﻿USE sofia;
DROP TABLE IF EXISTS sofia.spav1602p_vpl;
CREATE TABLE spav1602p_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES spav1602p_vpl WRITE;
INSERT INTO spav1602p_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","EN el principio creó Dios el cielo y la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Y la tierra estaba sin forma y vacía, y las tinieblas estaban sobre la faz del abismo, y el Espíritu de Dios se movía sobre la faz de las aguas. ");
INSERT INTO spav1602p_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Y dijo Dios: Sea la luz: y fue la luz. ");
INSERT INTO spav1602p_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Y vio Dios que la luz era buena: y apartó Dios la luz de las tinieblas. ");
INSERT INTO spav1602p_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Y llamó Dios a la luz Día, y a las tinieblas llamó Noche: y fue la tarde y la mañana el día pri­mero. ");
INSERT INTO spav1602p_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Y dijo Dios: Haya firmamento en medio de las aguas, y separe las aguas de las aguas. ");
INSERT INTO spav1602p_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","E hizo Dios el firmamento, y apartó las aguas que estaban debajo del firmamento de las aguas que estaban sobre el fir­mamento: y fue así. ");
INSERT INTO spav1602p_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Y llamó Dios al firmamento Cielo: y fue la tarde y la maña­na el día segundo. ");
INSERT INTO spav1602p_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Y dijo Dios: Júntense las aguas debajo de los cielos en un lugar, y aparezca la porción seca: y fue así. ");
INSERT INTO spav1602p_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Y llamó Dios a la porción seca Tierra, y a la reunión de las aguas llamó Mares: y vio Dios que era bueno. ");
INSERT INTO spav1602p_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Y dijo Dios: Produzca la tierra hierba verde, hierba que dé simiente, árbol de fruto que dé fruto según su género, que su simiente esté en él, sobre la tie­rra: y fue así. ");
INSERT INTO spav1602p_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Y produjo la tierra hierba verde, hierba que da simiente según su género, y árbol que da fruto, cuya simiente está en él, según su género: y vio Dios que era bueno. ");
INSERT INTO spav1602p_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Y fue la tarde y la mañana el día tercero. ");
INSERT INTO spav1602p_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Y dijo Dios: Sean lumbreras en el firmamento del cielo para apartar el día y la noche: y sean por señales, y para las esta­ciones, y para días y años; ");
INSERT INTO spav1602p_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Y sean por lumbreras en el fir­mamento del cielo para alum­brar sobre la tierra: y fue así. ");
INSERT INTO spav1602p_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","E hizo Dios las dos grandes lumbreras; la lumbrera mayor para señorear en el día, y la lumbrera menor para señorear en la noche: también él hizo las estrellas. ");
INSERT INTO spav1602p_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Y púsolas Dios en el firmamento del cielo, para alum­brar sobre la tierra, ");
INSERT INTO spav1602p_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Y para señorear en el día y en la noche, y para apartar la luz y las tinieblas: y vio Dios que era bueno. ");
INSERT INTO spav1602p_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Y fue la tarde y la mañana el día cuarto. ");
INSERT INTO spav1602p_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Y dijo Dios: Produzcan las aguas abundantemente criatura viviente que se mueve, y aves que vuelen sobre la tierra, en el firmamento abierto del cielo. ");
INSERT INTO spav1602p_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Y creó Dios las grandes ballenas, y toda criatura viva que se mueve, que las aguas produjeron abundantemente según su género, y toda ave alada según su género: y vio Dios que era bueno. ");
INSERT INTO spav1602p_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Y Dios los bendijo diciendo: Fructificad y multiplicad, y henchid las aguas en los mares, y las aves se multipliquen en la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Y fue la tarde y la mañana el día quinto. ");
INSERT INTO spav1602p_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Y dijo Dios: Produzca la tierra seres vivientes según su género, bestias y criaturas que se arrastran y animales de la tierra según su género: y fue así. ");
INSERT INTO spav1602p_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","E hizo Dios animales de la tierra según su género, y ganado según su género, y todo animal que anda arrastrando sobre la tie­rra según su género: y vio Dios que era bueno. ");
INSERT INTO spav1602p_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Y dijo Dios: Hagamos al hombre a nuestra imagen, conforme a nuestra semejanza: y señoree en los peces del mar, y en las aves del cielo, y en las bestias, y en toda la tierra, y en todo animal que anda arrastrando sobre la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Y creó Dios al hombre a su imagen, a imagen de Dios lo creó; varón y hembra los creó. ");
INSERT INTO spav1602p_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Y los bendijo Dios; y díjoles Dios: Fructificad y multiplicad, y henchid la tierra, y sojuzgadla, y señoread sobre los peces del mar, y sobre las aves del cielo, y sobre todas las bestias que se mueven sobre la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Y dijo Dios: He aquí que os he dado toda hierba que da simiente, que está sobre la faz de toda la tierra; y todo árbol en que hay fruto de árbol que da simiente, os será para comer. ");
INSERT INTO spav1602p_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Y a toda bestia de la tierra, y a toda ave del cielo, y a todo lo que se arrastra sobre la tierra, en que hay vida, os he dado toda hierba verde para comer: y fue así. ");
INSERT INTO spav1602p_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Y vio Dios todo lo que había hecho, y he aquí que era bueno en gran manera. Y fue la tarde y la mañana el día sexto. ");
INSERT INTO spav1602p_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Y FUERON acabados los cie­los y la tierra, y todo el ejér­cito de ellos. ");
INSERT INTO spav1602p_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Y acabó Dios en el día séptimo su obra que hizo, y reposó el día séptimo de toda su obra que había hecho. ");
INSERT INTO spav1602p_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Y bendijo Dios al día séptimo, y santificólo, porque en él reposó de toda su obra que había Dios creado y hecho. ");
INSERT INTO spav1602p_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Éstos son los orígenes de los cielos y de la tierra cuando fue­ron creados, en el día que el SEÑOR Dios hizo la tierra y los cielos, ");
INSERT INTO spav1602p_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Y toda planta del campo antes que fuese en la tierra, y toda hier­ba del campo antes que naciese: porque aun no había el SEÑOR Dios hecho llover sobre la tierra, ni había hombre para que labra­se la tierra; ");
INSERT INTO spav1602p_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Mas subía de la tierra un vapor, que regaba toda la faz de la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Formó, pues, el SEÑOR Dios al hombre del polvo de la tierra, y sopló en su nariz aliento de vida; y fue el hombre un alma viviente. ");
INSERT INTO spav1602p_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Y había el SEÑOR Dios plan­tado un huerto en Edén al orien­te, y puso allí al hombre que había formado. ");
INSERT INTO spav1602p_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Y había el SEÑOR Dios hecho nacer de la tierra todo árbol agradable a la vista, y bueno para comer: también el árbol de vida en medio del huerto, y el árbol del conocimiento del bien y del mal. ");
INSERT INTO spav1602p_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Y salía de Edén un río para regar el huerto, y de allí se repar­tía en cuatro ramales. ");
INSERT INTO spav1602p_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","El nombre del uno es Pisón: éste es el que rodea toda la tierra de Havila, donde hay oro; ");
INSERT INTO spav1602p_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Y el oro de aquella tierra es bueno: hay allí bedelio y piedra de ónix. ");
INSERT INTO spav1602p_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","El nombre del segundo río es Gihón: éste es el que rodea toda la tierra de Etiopía. ");
INSERT INTO spav1602p_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Y el nombre del tercer río es Hidekel: éste es el que va al oriente de Asiria. Y el cuarto río es el Éufrates. ");
INSERT INTO spav1602p_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Tomó, pues, el SEÑOR Dios al hombre, y le puso en el huerto de Edén, para que lo labrara y lo guardase. ");
INSERT INTO spav1602p_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Y mandó el SEÑOR Dios al hombre, diciendo: De todo árbol del huerto podrás libremente comer; ");
INSERT INTO spav1602p_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Mas del árbol del conoci­miento del bien y del mal no comerás de él; porque el día que de él comieres, ciertamente morirás. ");
INSERT INTO spav1602p_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Y dijo el SEÑOR Dios: No es bueno que el hombre esté solo; haréle ayuda idónea para él. ");
INSERT INTO spav1602p_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Formó, pues, el SEÑOR Dios de la tierra toda bestia del campo, y toda ave del cielo, y trájo­las a Adam, para que viese cómo les había de llamar; y todo lo que Adam llamó a los animales vivientes, ese fue su nombre. ");
INSERT INTO spav1602p_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Y puso Adam nombres a toda bestia y ave del cielo y a todo animal del campo: mas para Adam no se halló ayuda idónea para él. ");
INSERT INTO spav1602p_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Y el SEÑOR Dios hizo caer sueño sobre Adam, y se quedó dormido: entonces tomó una de sus costillas, y cerró la carne en su lugar; ");
INSERT INTO spav1602p_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Y de la costilla que el SEÑOR Dios tomó del hombre, hizo una mujer, y trájola al hombre. ");
INSERT INTO spav1602p_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Y dijo Adam: Ésta es ahora hueso de mis huesos, y carne de mi carne: ella será llamada Varona, porque del varón fue tomada. ");
INSERT INTO spav1602p_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Por tanto, dejará el hombre a su padre y a su madre, y allegar­se ha a su esposa, y serán una sola carne. ");
INSERT INTO spav1602p_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Y estaban ambos desnudos, el hombre y su esposa, y no se aver­gonzaban. ");
INSERT INTO spav1602p_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","AHORA la serpiente era astuta, más que todos los animales del campo que el SEÑOR Dios había hecho; la cual dijo a la mujer: ¿Conque Dios os ha dicho: No comáis de todo árbol del huerto? ");
INSERT INTO spav1602p_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Y la mujer respondió a la ser­piente: Del fruto de los árboles del huerto podemos comer ");
INSERT INTO spav1602p_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Mas del fruto del árbol que está en medio del huerto dijo Dios: No comeréis de él, ni le tocaréis, porque no muráis. ");
INSERT INTO spav1602p_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Entonces la serpiente dijo a la mujer: Ciertamente no moriréis; ");
INSERT INTO spav1602p_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Mas sabe Dios que el día que comiereis de él, serán abiertos vuestros ojos, y seréis como dio­ses sabiendo el bien y el mal. ");
INSERT INTO spav1602p_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Y cuando vio la mujer que el árbol era bueno para comer, y que era agradable a los ojos, y árbol codiciable para alcanzar la sabi­duría; tomó de su fruto, y comió; y dio también a su marido, el cual comió así como ella. ");
INSERT INTO spav1602p_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Y fueron abiertos los ojos de entrambos, y conocieron que estaban desnudos: entonces cosieron hojas de higuera, y se hicieron delantales. ");
INSERT INTO spav1602p_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Y oyeron la voz del SEÑOR Dios que se paseaba en el huerto al aire del día: y escondióse el hombre y su esposa de la presen­cia del SEÑOR Dios entre los árboles del huerto. ");
INSERT INTO spav1602p_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Y llamó el SEÑOR Dios a Adam, y le dijo: ¿Dónde estás tú? ");
INSERT INTO spav1602p_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Y él respondió: Oí tu voz en el huerto, y tuve miedo, porque estaba desnudo; y escondíme. ");
INSERT INTO spav1602p_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Y díjole: ¿Quién te enseñó que estabas desnudo? ¿Has comido del árbol de que yo te mandé no comieses? ");
INSERT INTO spav1602p_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Y el hombre respondió: La mujer que me diste para estar conmigo me dio del árbol, y yo comí. ");
INSERT INTO spav1602p_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Entonces el SEÑOR Dios dijo a la mujer: ¿Qué es lo que has hecho? Y dijo la mujer: La serpiente me engañó, y comí. ");
INSERT INTO spav1602p_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Y el SEÑOR Dios dijo a la serpiente: Por cuanto esto hiciste, maldita serás entre todas las bes­tias y entre todos los animales del campo; sobre tu pecho anda­rás, y polvo comerás todos los días de tu vida: ");
INSERT INTO spav1602p_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Y enemistad pondré entre ti y la mujer, y entre tu simiente y la simiente suya; esta simiente te herirá en la cabeza, y tú le herirás en el cal­cañar. ");
INSERT INTO spav1602p_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","A la mujer dijo: Multiplicaré en gran manera tus dolores y tus preñeces; con dolor parirás los hijos; y a tu marido será tu deseo, y él se enseñoreará de ti. ");
INSERT INTO spav1602p_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Y a Adam dijo: Por cuanto obedeciste a la voz de tu esposa, y comiste del árbol de que te mandé diciendo: No comerás de él; maldita será la tierra por tu causa; con dolor comerás de ella todos los días de tu vida; ");
INSERT INTO spav1602p_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Espinos y cardos te producirá, y comerás hierba del campo; ");
INSERT INTO spav1602p_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","En el sudor de tu rostro come­rás el pan hasta que vuelvas a la tierra; porque de ella fuiste toma­do: pues polvo eres, y al polvo serás tornado. ");
INSERT INTO spav1602p_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Y llamó Adam el nombre de su esposa, Eva; por cuanto ella era madre de todos los vivientes. ");
INSERT INTO spav1602p_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Y el SEÑOR Dios hizo a Adam y a su esposa túnicas de pieles, y vistiólos. ");
INSERT INTO spav1602p_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Y dijo el SEÑOR Dios: He aquí el hombre es como uno de nosotros sabiendo el bien y el mal: ahora, pues, porque no alargue su mano, y tome también del árbol de la vida, y coma, y viva para siempre: ");
INSERT INTO spav1602p_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Y sacólo el SEÑOR Dios del huerto de Edén, para que labrase la tierra de que fue tomado. ");
INSERT INTO spav1602p_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Echó, pues, fuera al hombre, y puso al oriente del huerto de Edén querubines, y una espada encendida que se revolvía a todos lados, para guardar el camino del árbol de la vida. ");
INSERT INTO spav1602p_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Y CONOCIÓ Adam a su esposa Eva, la cual concibió y parió a Caín, y dijo: Adquirido he varón por el SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Y después parió a su hermano Abel. Y fue Abel pastor de ove­jas, y Caín fue labrador de la tie­rra. ");
INSERT INTO spav1602p_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Y aconteció andando el tiempo, que Caín trajo del fruto de la tie­rra una ofrenda al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Y Abel trajo también de los pri­mogénitos de sus ovejas, y de su grosura. Y el SEÑOR respetó a Abel y aceptó su ofrenda; ");
INSERT INTO spav1602p_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Mas no miró propicio a Caín y a la ofrenda suya. Y ensañóse Caín en gran manera, y decayó su semblante. ");
INSERT INTO spav1602p_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Entonces el SEÑOR dijo a Caín: ¿Por qué te has ensañado, y por qué ha decaído tu ros­tro? ");
INSERT INTO spav1602p_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Si bien hicieres, ¿no serás aceptado? y si no hicieres bien, el pecado está acechando a la puerta y te desea, y tú te enseñorearás sobre él. ");
INSERT INTO spav1602p_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Y habló Caín con su hermano Abel: y aconteció que estando ellos en el campo, Caín se levan­tó contra su hermano Abel, y le mató. ");
INSERT INTO spav1602p_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Y el SEÑOR dijo a Caín: ¿Dónde está Abel tu hermano? Y él respondió: No sé; ¿soy yo guarda de mi hermano? ");
INSERT INTO spav1602p_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Y él le dijo: ¿Qué has hecho? La voz de la sangre de tu herma­no clama a mí desde la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Ahora pues, maldito seas tú de la tierra que abrió su boca para recibir la sangre de tu hermano de tu mano: ");
INSERT INTO spav1602p_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Cuando labrares la tierra, no te volverá a dar su fuerza: fugitivo y vagabundo serás en la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Y dijo Caín al SEÑOR: Mi castigo es más grande de lo que puedo soportar. ");
INSERT INTO spav1602p_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","He aquí me echas hoy de la faz de la tierra, y de tu presencia seré escondido; y seré fugitivo y vagabundo en la tierra; y sucede­rá que cualquiera que me hallare, me matará. ");
INSERT INTO spav1602p_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Y respondióle el SEÑOR: Cierto que cualquiera que matare a Caín, siete veces será castiga­do. Entonces el SEÑOR puso una marca en Caín, para que no lo matase cualquiera que le hallara. ");
INSERT INTO spav1602p_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Y salió Caín de la presencia del SEÑOR, y habitó en tierra de Nod, al oriente de Edén. ");
INSERT INTO spav1602p_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Y conoció Caín a su esposa, la cual concibió y parió a Enoc: y edificó una ciudad, y llamó el nombre de la ciudad del nombre de su hijo, Enoc. ");
INSERT INTO spav1602p_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Y a Enoc nació Irad, e Irad engendró a Mehujael, y Mehujael engendró a Metusael, y Metusael engendró a Lamec. ");
INSERT INTO spav1602p_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Y tomó para sí Lamec dos esposas; el nombre de la una fue Ada, y el nombre de la otra Zila. ");
INSERT INTO spav1602p_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Y Ada parió a Jabal, el cual fue padre de los que habitan en tiendas, y los que tienen ganados. ");
INSERT INTO spav1602p_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Y el nombre de su hermano fue Jubal, el cual fue padre de todos los que manejan arpa y órgano. ");
INSERT INTO spav1602p_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Y Zila también parió a Tubal-­Caín, un instructor de todo artífice de latón y de hierro: y la hermana de Tubal-Caín fue Naama. ");
INSERT INTO spav1602p_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Y dijo Lamec a sus esposas: Ada y Zila, oíd mi voz; esposas de Lamec, escuchad mi dicho: que varón mataré por mi herida, y mancebo por mi golpe: ");
INSERT INTO spav1602p_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Si siete veces será vengado Caín, Lamec en verdad setenta veces siete lo será. ");
INSERT INTO spav1602p_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Y conoció de nuevo Adam a su esposa, la cual parió un hijo, y llamó su nombre Set: Porque Dios, dijo ella, me ha dado otra simiente en lugar de Abel, a quien mató Caín. ");
INSERT INTO spav1602p_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Y a Set también le nació un hijo, y llamó su nombre Enós. Entonces los hombres comenza­ron a invocar el nombre del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","ÉSTE es el libro de las generaciones de Adam. El día en que creó Dios al hombre, a la semejanza de Dios lo hizo; ");
INSERT INTO spav1602p_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Varón y hembra los creó; y los bendijo, y llamó su nombre Adam, el día en que fueron creados. ");
INSERT INTO spav1602p_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Y vivió Adam ciento y treinta años, y engendró un hijo a su semejanza, conforme a su ima­gen, y llamó su nombre Set. ");
INSERT INTO spav1602p_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Y fueron los días de Adam, después que engendró a Set, ochocientos años: y engendró hijos e hijas. ");
INSERT INTO spav1602p_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Y fueron todos los días que vivió Adam novecientos y trein­ta años, y murió. ");
INSERT INTO spav1602p_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Y vivió Set ciento y cinco años, y engendró a Enós. ");
INSERT INTO spav1602p_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Y vivió Set, después que engendró a Enós, ochocientos y siete años: y engendró hijos e hijas. ");
INSERT INTO spav1602p_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Y fueron todos los días de Set novecientos y doce años; y murió. ");
INSERT INTO spav1602p_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Y vivió Enós noventa años, y engendró a Cainán. ");
INSERT INTO spav1602p_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Y vivió Enós después que engendró a Cainán, ochocientos y quince años: y engendró hijos e hijas. ");
INSERT INTO spav1602p_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Y fueron todos los días de Enós novecientos y cinco años; y murió. ");
INSERT INTO spav1602p_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Y vivió Cainán setenta años, y engendró a Mahalaleel. ");
INSERT INTO spav1602p_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Y vivió Cainán, después que engendró a Mahalaleel, ocho­cientos y cuarenta años: y engen­dró hijos e hijas. ");
INSERT INTO spav1602p_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Y fueron todos los días de Cainán novecientos y diez años; y murió. ");
INSERT INTO spav1602p_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Y vivió Mahalaleel sesenta y cinco años, y engendró a Jared. ");
INSERT INTO spav1602p_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Y vivió Mahalaleel, después que engendró a Jared, ochocien­tos y treinta años: y engendró hijos e hijas. ");
INSERT INTO spav1602p_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Y fueron todos los días de Mahalaleel ochocientos noventa y cinco años; y murió. ");
INSERT INTO spav1602p_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Y vivió Jared ciento sesenta y dos años, y engendró a Enoc. ");
INSERT INTO spav1602p_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Y vivió Jared, después que engendró a Enoc, ochocientos años: y engendró hijos e hijas. ");
INSERT INTO spav1602p_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Y fueron todos los días de Jared novecientos sesenta y dos años; y murió. ");
INSERT INTO spav1602p_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Y vivió Enoc sesenta y cinco años, y engendró a Matusalem. ");
INSERT INTO spav1602p_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Y caminó Enoc con Dios, des­pués que engendró a Matusalem, trescientos años: y engendró hijos e hijas. ");
INSERT INTO spav1602p_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Y fueron todos los días de Enoc trescientos sesenta y cinco años. ");
INSERT INTO spav1602p_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Caminó, pues, Enoc con Dios, y no apareció, porque le llevó Dios. ");
INSERT INTO spav1602p_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Y vivió Matusalem ciento ochenta y siete años, y engendró a Lamec. ");
INSERT INTO spav1602p_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Y vivió Matusalem, después que engendró a Lamec, sete­cientos ochenta y dos años: y engendró hijos e hijas. ");
INSERT INTO spav1602p_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Fueron, pues, todos los días de Matusalem, novecientos sesenta y nueve años; y murió. ");
INSERT INTO spav1602p_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Y vivió Lamec ciento ochen­ta y dos años, y engendró un hijo: ");
INSERT INTO spav1602p_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Y llamó su nombre Noé, diciendo: Éste nos consolará acerca de nuestras obras, y del trabajo de nuestras manos, a causa de la tie­rra que el SEÑOR maldijo. ");
INSERT INTO spav1602p_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Y vivió Lamec, después que engendró a Noé, quinientos noventa y cinco años: y engendró hijos e hijas. ");
INSERT INTO spav1602p_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Y fueron todos los días de Lamec setecientos setenta y siete años; y murió. ");
INSERT INTO spav1602p_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Y era Noé de edad quinientos años; y engendró Noé a Sem, Cam, y a Jafet. ");
INSERT INTO spav1602p_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Y ACAECIÓ que, cuando comenzaron los hombres a multiplicarse sobre la faz de la tierra, y les nacieron hijas, ");
INSERT INTO spav1602p_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Viendo los hijos de Dios que las hijas de los hombres eran hermosas, tomáronse esposas, escogiendo entre todas. ");
INSERT INTO spav1602p_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Y dijo el SEÑOR: No conten­derá mi Espíritu con el hombre para siempre, porque él también es carne: mas serán sus días ciento y veinte años. ");
INSERT INTO spav1602p_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Había gigantes en la tierra en aquellos días, y también después que entraron los hijos de Dios a las hijas de los hombres, y les engendraron hijos: éstos fueron los valientes que desde la anti­güedad fueron varones de nom­bre. ");
INSERT INTO spav1602p_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Y vio DIOS que era mucha la maldad del hombre en la tierra, y que toda imaginación de los pensamientos de su corazón era solamente mala continuamente. ");
INSERT INTO spav1602p_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Y arrepintióse el SEÑOR de haber hecho hombre en la tierra, y pesóle en su corazón. ");
INSERT INTO spav1602p_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Y dijo el SEÑOR: Raeré los hombres que he creado de sobre la faz de la tierra, desde el hom­bre hasta la bestia, y hasta el rep­til y las aves del cielo: porque me arrepiento de haberlos hecho. ");
INSERT INTO spav1602p_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Pero Noé halló gracia en los ojos del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Éstas son las generaciones de Noé: Noé fue un varón justo y perfecto en sus generaciones; con Dios caminó Noé. ");
INSERT INTO spav1602p_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Y engendró Noé tres hijos: a Sem, a Cam, y a Jafet. ");
INSERT INTO spav1602p_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Y corrompióse la tierra delan­te de Dios, y estaba la tierra llena de violencia. ");
INSERT INTO spav1602p_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Y miró Dios la tierra, y he aquí que estaba corrompida; por­que toda carne había corrompido su camino sobre la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Y dijo Dios a Noé: El fin de toda carne ha venido delante de mí; porque la tierra está llena de violencia a causa de ellos; y he aquí que yo los destruiré con la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Hazte un arca de madera de gofer: harás aposentos en el arca, y la embetunarás con brea por dentro y por fuera. ");
INSERT INTO spav1602p_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Y de esta manera la harás: de trescientos codos la longitud del arca, de cincuenta codos su anchu­ra, y de treinta codos su altura. ");
INSERT INTO spav1602p_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Una ventana harás al arca, y la acabarás a un codo de elevación por la parte de arriba: y pondrás la puerta del arca a su lado; y le harás piso bajo, segundo y terce­ro. ");
INSERT INTO spav1602p_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Y yo, he aquí que yo traigo un diluvio de aguas sobre la tierra, para destruir toda carne en que haya espíritu de vida debajo del cielo; todo lo que hay en la tierra morirá. ");
INSERT INTO spav1602p_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Mas estableceré mi pacto contigo, y vendrás en el arca tú, y tus hijos y tu esposa, y las esposas de tus hijos contigo. ");
INSERT INTO spav1602p_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Y de todo lo que vive, de toda carne, dos de cada género mete­rás en el arca, para que tengan vida contigo; macho y hembra serán. ");
INSERT INTO spav1602p_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","De las aves según su género, y de las bestias según su género, de todo reptil de la tierra según su género, dos de cada género vend­rán a ti para conservarles la vida. ");
INSERT INTO spav1602p_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Y toma contigo de toda vian­da que se come, y allégala a ti; servirá de alimento para ti y para ellos. ");
INSERT INTO spav1602p_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","E hízolo así Noé; hizo conforme a todo lo que Dios le mandó. ");
INSERT INTO spav1602p_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Y EL SEÑOR dijo a Noé: Ven tú y toda tu casa en el arca; porque a ti he visto justo delante de mí en esta generación. ");
INSERT INTO spav1602p_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","De todo animal limpio te toma­rás de siete en siete, macho y su hembra; mas de los animales que no son limpios, dos, macho y su hembra. ");
INSERT INTO spav1602p_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","También de las aves del cie­lo de siete en siete, macho y hembra; para guardar en vida la casta sobre la faz de toda la tie­rra. ");
INSERT INTO spav1602p_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Porque aún siete días, y yo haré llover sobre la tierra cua­renta días y cuarenta noches; y toda sustancia viviente que hice destruiré de sobre la faz de la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","E hizo Noé conforme a todo lo que le mandó el SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Y siendo Noé de seiscientos años, el diluvio de las aguas fue sobre la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Y vino Noé, y sus hijos, y su esposa, y las esposas de sus hijos con él al arca, por las aguas del diluvio. ");
INSERT INTO spav1602p_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","De los animales limpios, y de los animales que no son limpios, y de las aves, y de todo lo que se arrastra sobre la tierra, ");
INSERT INTO spav1602p_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","De dos en dos entraron a Noé en el arca: macho y hembra, como mandó Dios a Noé. ");
INSERT INTO spav1602p_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Y sucedió que al séptimo día las aguas del diluvio fueron sobre la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","El año seiscientos de la vida de Noé, en el mes segundo, a die­cisiete días del mes, aquel día fueron rotas todas las fuentes del grande abismo, y las cataratas del cielo fueron abiertas; ");
INSERT INTO spav1602p_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Y hubo lluvia sobre la tierra cuarenta días y cuarenta noches. ");
INSERT INTO spav1602p_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","En este mismo día entró Noé, y Sem, y Cam y Jafet, hijos de Noé, la esposa de Noé, y las tres esposas de sus hijos con él en el arca; ");
INSERT INTO spav1602p_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Ellos, y todos los animales según sus géneros, y todos los animales mansos según sus géneros, y todo reptil que anda arrastrando sobre la tierra según su género, y toda ave según su género, todo pájaro alado. ");
INSERT INTO spav1602p_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Y vinieron a Noé al arca, de dos en dos de toda carne en que había espíritu de vida. ");
INSERT INTO spav1602p_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Y los que vinieron, macho y hembra de toda carne vinieron, como le había mandado Dios: y el SEÑOR le cerró la puerta. ");
INSERT INTO spav1602p_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Y fue el diluvio cuarenta días sobre la tierra; y las aguas crecie­ron, y alzaron el arca, y se elevó sobre la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Y prevalecieron las aguas, y crecieron en gran manera sobre la tierra; y andaba el arca sobre la faz de las aguas. ");
INSERT INTO spav1602p_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Y las aguas prevalecieron mucho en extremo sobre la tie­rra; y todos los montes altos que había debajo de todo el cielo, fueron cubiertos. ");
INSERT INTO spav1602p_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Quince codos en alto prevale­cieron las aguas; y fueron cubier­tos los montes. ");
INSERT INTO spav1602p_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Y murió toda carne que se mueve sobre la tierra, así de aves como de ganados, y de bestias, y de todo reptil que anda arrastran­do sobre la tierra, y todo hombre: ");
INSERT INTO spav1602p_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Todo lo que tenía aliento de espíritu de vida en sus narices, de todo lo que había en la tierra, murió. ");
INSERT INTO spav1602p_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Así fue destruída toda sustancia viviente de sobre la faz de la tierra, desde el hombre hasta la bestia, y los reptiles, y las aves del cielo; y fueron destruidos de la tierra; y quedó solamente Noé, y los que con él estaban en el arca. ");
INSERT INTO spav1602p_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Y prevalecieron las aguas sobre la tierra ciento y cincuenta días. ");
INSERT INTO spav1602p_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Y ACORDÓSE Dios de Noé, y de todos los animales, y de todas las bestias que estaban con él en el arca; e hizo pasar Dios un viento sobre la tierra, y disminuyeron las aguas. ");
INSERT INTO spav1602p_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Y se cerraron las fuentes del abismo, y las cataratas del cie­lo; y la lluvia del cielo fue detenida. ");
INSERT INTO spav1602p_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Y tornáronse las aguas de sobre la tierra, yendo y volviendo: y decrecieron las aguas al cabo de ciento y cincuenta días. ");
INSERT INTO spav1602p_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Y reposó el arca en el mes sép­timo, a diecisiete días del mes, sobre los montes de Ararat. ");
INSERT INTO spav1602p_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Y las aguas fueron decreciendo hasta el mes décimo: en el déci­mo mes, el primer día del mes, se des­cubrieron las cimas de los mon­tes. ");
INSERT INTO spav1602p_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Y sucedió que, al cabo de cua­renta días, abrió Noé la ventana del arca que había hecho, ");
INSERT INTO spav1602p_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Y envió al cuervo, el cual salió, y estuvo yendo y tornando hasta que las aguas se secaron de sobre la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Envió también de sí a la palo­ma, para ver si las aguas se habí­an retirado de sobre la faz de la tierra; ");
INSERT INTO spav1602p_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Y no halló la paloma donde sentar la planta de su pie, y volvióse a él al arca, porque las aguas estaban aún sobre la faz de toda la tierra: entonces él exten­dió su mano y cogiéndola, hízola entrar consigo en el arca. ");
INSERT INTO spav1602p_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Y esperó aún otros siete días, y volvió a enviar la paloma fuera del arca. ");
INSERT INTO spav1602p_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Y la paloma volvió a él a la hora de la tarde: y he aquí que traía una hoja de oliva tomada en su pico: y entendió Noé que las aguas se habían retirado de sobre la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Y esperó aún otros siete días, y envió la paloma, la cual no vol­vió ya más a él. ");
INSERT INTO spav1602p_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Y sucedió que en el año seis­cientos y uno, en el mes primero, el primer día del mes, las aguas se enjugaron de sobre la tierra; y quitó Noé la cubierta del arca, y miró, y he aquí que la faz de la tierra estaba enjuta. ");
INSERT INTO spav1602p_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Y en el mes segundo, a los veintisiete días del mes, se secó la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Y habló Dios a Noé diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Sal del arca tú, y tu esposa, y tus hijos, y las esposas de tus hijos contigo. ");
INSERT INTO spav1602p_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Todos los animales que están contigo, de toda carne, tanto de aves como de bestias y de todo reptil que anda arrastrando sobre la tierra, sacarás contigo; y vayan por la tierra, y fructifiquen, y multiplí­quense sobre la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Entonces salió Noé, y sus hijos, y su esposa, y las esposas de sus hijos con él. ");
INSERT INTO spav1602p_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Todos los animales, y todo reptil y toda ave, todo lo que se mueve sobre la tierra según sus géneros, salieron del arca. ");
INSERT INTO spav1602p_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Y edificó Noé un altar al SEÑOR, y tomó de todo animal limpio y de toda ave limpia, y ofreció ofrendas quemadas en el altar. ");
INSERT INTO spav1602p_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Y percibió el SEÑOR olor de suavidad; y dijo el SEÑOR en su corazón: No tornaré más a mal­decir la tierra por causa del hom­bre; porque la imaginación del corazón del hombre es mala desde su juventud: ni volveré más a herir todo viviente, como he hecho. ");
INSERT INTO spav1602p_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Todavía serán todos los tiem­pos de la tierra; la sementera y la siega, y el frío y calor, verano e invierno, y día y noche, no cesa­rán. ");
INSERT INTO spav1602p_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Y BENDIJO Dios a Noé y a sus hijos, y díjoles: Fructificad, y multiplicad, y henchid la tierra: ");
INSERT INTO spav1602p_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Y vuestro temor y vuestro pavor será sobre todo animal de la tierra, y sobre toda ave del cielo, en todo lo que se mueva sobre la tierra, y en todos los peces del mar: en vuestra mano son entregados. ");
INSERT INTO spav1602p_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Todo lo que se mueve y vive, os será para mantenimiento: así como las legumbres y hierbas, os lo he dado todo. ");
INSERT INTO spav1602p_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Pero carne con su vida, que es su sangre, no comeréis. ");
INSERT INTO spav1602p_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Porque ciertamente demandaré la sangre de vuestras vidas; de mano de todo animal la deman­daré, y de mano del hombre; de mano del varón su hermano demandaré la vida del hombre. ");
INSERT INTO spav1602p_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","El que derramare sangre del hombre, por el hombre su sangre será derramada; porque a imagen de Dios es hecho el hombre. ");
INSERT INTO spav1602p_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Mas vosotros fructificad, y multiplicaos; procread abundan­temente en la tierra, y multipli­caos en ella. ");
INSERT INTO spav1602p_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Y habló Dios a Noé y a sus hijos con él, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","Yo, he aquí que yo establezco mi pacto con vosotros, y con vuestra simiente después de vosotros; ");
INSERT INTO spav1602p_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Y con toda alma viviente que está con vosotros, de aves, de animales, y de toda bestia de la tierra que está con vosotros; desde todos los que salieron del arca hasta todo animal de la tie­rra. ");
INSERT INTO spav1602p_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Estableceré mi pacto con vosotros, y no fenecerá ya más toda carne con aguas de diluvio; ni habrá más diluvio para des­truir la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Y dijo Dios: Ésta será la señal del pacto que yo establezco entre mí y vosotros y toda alma viviente que está con vosotros, por siglos perpetuos: ");
INSERT INTO spav1602p_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Mi arco pondré en las nubes, el cual será por señal de conve­nio entre mí y la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Y acontecerá que cuando haré venir nubes sobre la tierra, se dejará ver entonces mi arco en las nubes. ");
INSERT INTO spav1602p_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Y acordarme he del pacto mío, que hay entre mí y vosotros y toda alma viviente de toda carne; y no serán más las aguas por diluvio para destruir toda carne. ");
INSERT INTO spav1602p_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Y estará el arco en las nubes, y verlo he para acordarme del pacto perpetuo entre Dios y toda alma viviente, con toda carne que hay sobre la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Dijo, pues, Dios a Noé: Ésta será la señal del pacto que he establecido entre mí y toda carne que está sobre la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Y los hijos de Noé que salie­ron del arca fueron Sem, Cam y Jafet: y Cam es el padre de Canaán. ");
INSERT INTO spav1602p_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Estos tres son los hijos de Noé; y de ellos fue llena toda la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Y comenzó Noé a labrar la tierra, y plantó una viña: ");
INSERT INTO spav1602p_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Y bebió del vino, y se embria­gó, y estaba descubierto en medio de su tienda. ");
INSERT INTO spav1602p_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Y Cam, padre de Canaán, vio la desnudez de su padre, y díjolo a sus dos hermanos a la parte de afuera. ");
INSERT INTO spav1602p_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Entonces Sem y Jafet toma­ron la ropa, y la pusieron sobre sus propios hombros, y andando hacia atrás, cubrieron la desnu­dez de su padre, teniendo vueltos sus rostros, y así no vieron la desnudez de su padre. ");
INSERT INTO spav1602p_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Y despertó Noé de su vino, y supo lo que había hecho a él su hijo el más joven; ");
INSERT INTO spav1602p_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Y dijo: Maldito sea Canaán; Siervo de siervos será a sus her­manos. ");
INSERT INTO spav1602p_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Dijo más: Bendito sea el SEÑOR el Dios de Sem, y será Canaán su siervo. ");
INSERT INTO spav1602p_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Engrandecerá Dios a Jafet, y habitará en las tiendas de Sem, y será Canaán su siervo. ");
INSERT INTO spav1602p_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Y vivió Noé después del dilu­vio trescientos y cincuenta años. ");
INSERT INTO spav1602p_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Y fueron todos los días de Noé novecientos y cincuenta años; y murió. ");
INSERT INTO spav1602p_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","ÉSTAS son las generaciones de los hijos de Noé: Sem, Cam y Jafet, a los cuales nacieron hijos después del diluvio. ");
INSERT INTO spav1602p_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Los hijos de Jafet: Gomer, y Magog, y Madai, y Javán, y Tubal, y Mesec, y Tiras. ");
INSERT INTO spav1602p_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Y los hijos de Gomer: Askenaz, y Rifat, y Togarma. ");
INSERT INTO spav1602p_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Y los hijos de Javán: Elisa, y Tarsis, Quitim, y Dodanim. ");
INSERT INTO spav1602p_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Por éstos fueron repartidas las islas de los gentiles en sus tierras, cada cual según su lengua, confor­me a sus familias en sus naciones. ");
INSERT INTO spav1602p_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Los hijos de Cam: Cus, y Mizraim, y Fut, y Canaán. ");
INSERT INTO spav1602p_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Y los hijos de Cus: Seba, Havila, y Sabta, y Raama, y Sabteca. Y los hijos de Raama: Seba y Dedán. ");
INSERT INTO spav1602p_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Y Cus engendró a Nimrod: éste comenzó a ser poderoso en la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Éste fue vigoroso cazador delante del SEÑOR; por lo cual se dice: Así como Nimrod, vigo­roso cazador delante del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Y fue la cabecera de su reino Babel, y Erec, y Acad, y Calne, en la tierra de Sinar. ");
INSERT INTO spav1602p_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","De esa tierra salió Asur, y edificó a Nínive, y a Rehobot, y a Cala, ");
INSERT INTO spav1602p_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Y a Resén entre Nínive y Cala; la cual es ciudad grande. ");
INSERT INTO spav1602p_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Y Mizraim engendró a Ludim, y a Anamim, y a Lehabim, y a Naftuhim, ");
INSERT INTO spav1602p_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Y a Patrusim, y a Casluim, (de donde salieron los filisteos), y a Caftorim. ");
INSERT INTO spav1602p_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Y Canaán engendró a Sidón, su primogénito, y a Het, ");
INSERT INTO spav1602p_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Y al jebuseo, y al amorreo, y al gergeseo, ");
INSERT INTO spav1602p_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Y al heveo, y al araceo, y al sineo, ");
INSERT INTO spav1602p_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Y al Aradio, y al samareo, y al Amateo: y después se derrama­ron las familias de los cananeos. ");
INSERT INTO spav1602p_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Y fue el término de los cananeos desde Sidón, viniendo a Gerar hasta Gaza, hasta entrar en Sodoma y Gomorra, Adma, y Zeboim hasta Lasa. ");
INSERT INTO spav1602p_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Éstos son los hijos de Cam por sus familias, por sus lenguas, en sus tierras y en sus naciones. ");
INSERT INTO spav1602p_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","También le nacieron hijos a Sem, padre de todos los hijos de Heber, y hermano mayor de Jafet. ");
INSERT INTO spav1602p_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Y los hijos de Sem: Elam, y Asur, y Arfaxad, y Lud, y Aram. ");
INSERT INTO spav1602p_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Y los hijos de Aram: Uz, y Hul, y Geter, y Mas. ");
INSERT INTO spav1602p_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Y Arfaxad engendró a Sala, y Sala engendró a Heber. ");
INSERT INTO spav1602p_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Y a Heber nacieron dos hijos: el nombre del uno fue Peleg, por­que en sus días fue repartida la tie­rra; y el nombre de su hermano fue Joctán. ");
INSERT INTO spav1602p_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Y Joctán engendró a Almodad, y a Selef, y Hazarmavet, y a Jera, ");
INSERT INTO spav1602p_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Y a Adoram, y a Uzal, y a Dicla, ");
INSERT INTO spav1602p_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Y a Obal, y a Abimael, y a Seba, ");
INSERT INTO spav1602p_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Y a Ofir, y a Havila, y a Jobab: todos estos fueron hijos de Joctán. ");
INSERT INTO spav1602p_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Y fue su habitación desde Mesa viniendo de Sefar, monte a la parte del oriente. ");
INSERT INTO spav1602p_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Éstos fueron los hijos de Sem por sus familias, por sus lenguas, en sus tierras, en sus naciones. ");
INSERT INTO spav1602p_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Éstas son las familias de Noé por sus descendencias, en sus naciones; y de éstos fueron divi­didas las naciones en la tierra des­pués del diluvio. ");
INSERT INTO spav1602p_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","ERA entonces toda la tierra de una lengua y unas mismas palabras. ");
INSERT INTO spav1602p_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Y aconteció que, como se partieron de oriente, hallaron una vega en la tierra de Sinar, y asentaron allí. ");
INSERT INTO spav1602p_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Y dijeron los unos a los otros: Vaya, hagamos ladrillo y cozá­moslo con fuego. Y fueles el ladrillo en lugar de piedra, y el betún en lugar de mezcla. ");
INSERT INTO spav1602p_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Y dijeron: Vamos, edifiquémo­nos una ciudad y una torre, cuya cúspide llegue al cielo; y hagá­monos un nombre, por si fuére­mos esparcidos sobre la faz de toda la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Y descendió el SEÑOR para ver la ciudad y la torre que edifi­caban los hijos de los hombres. ");
INSERT INTO spav1602p_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Y dijo el SEÑOR: He aquí el pueblo es uno, y todos éstos tie­nen un lenguaje: y han comenza­do a obrar, y nada les retraerá ahora de lo que han pensado hacer. ");
INSERT INTO spav1602p_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Ahora pues, descendamos, y confundamos allí sus lenguas, para que ninguno entienda el habla de su compañero. ");
INSERT INTO spav1602p_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Así los esparció el SEÑOR desde allí sobre la faz de toda la tierra, y dejaron de edificar la ciudad. ");
INSERT INTO spav1602p_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Por esto fue llamado el nombre de ella Babel, porque allí confundió el SEÑOR el lenguaje de toda la tierra, y desde allí los esparció sobre la faz de toda la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Éstas son las generaciones de Sem: Sem fue de edad de cien años y engendró a Arfaxad, dos años después del diluvio. ");
INSERT INTO spav1602p_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Y vivió Sem, después que engendró a Arfaxad quinientos años, y engendró hijos e hijas. ");
INSERT INTO spav1602p_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Y Arfaxad vivió treinta y cinco años, y engendró a Sala. ");
INSERT INTO spav1602p_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Y vivió Arfaxad, después que engendró a Sala, cuatrocien­tos y tres años, y engendró hijos e hijas. ");
INSERT INTO spav1602p_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Y vivió Sala treinta años, y engendró a Heber. ");
INSERT INTO spav1602p_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Y vivió Sala, después que engendró a Heber, cuatrocientos y tres años, y engendró hijos e hijas. ");
INSERT INTO spav1602p_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Y vivió Heber treinta y cuatro años, y engendró a Peleg. ");
INSERT INTO spav1602p_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Y vivió Heber, después que engendró a Peleg, cuatrocientos y treinta años, y engendró hijos e hijas. ");
INSERT INTO spav1602p_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Y vivió Peleg, treinta años, y engendró a Reu. ");
INSERT INTO spav1602p_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Y vivió Peleg, después que engendró a Reu, doscientos y nueve años, y engendró hijos e hijas. ");
INSERT INTO spav1602p_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Y Reu vivió treinta y dos años, y engendró a Serug. ");
INSERT INTO spav1602p_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Y vivió Reu, después que engendró a Serug, doscientos y siete años, y engendró hijos e hijas. ");
INSERT INTO spav1602p_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Y vivió Serug treinta años, y engendró a Nacor. ");
INSERT INTO spav1602p_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Y vivió Serug, después que engendró a Nacor, doscientos años, y engendró hijos e hijas. ");
INSERT INTO spav1602p_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Y vivió Nacor veintinueve años, y engendró a Taré. ");
INSERT INTO spav1602p_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Y vivió Nacor, después que engendró a Taré, ciento dieci­nueve años, y engendró hijos e hijas. ");
INSERT INTO spav1602p_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Y vivió Taré setenta años, y engendró a Abram, y a Nacor, y a Harán. ");
INSERT INTO spav1602p_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Éstas son las generaciones de Taré: Taré engendró a Abram, y a Nacor, y a Harán; y Harán engendró a Lot. ");
INSERT INTO spav1602p_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Y murió Harán antes que su padre Taré en la tierra de su naturaleza, en Ur de los caldeos. ");
INSERT INTO spav1602p_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Y tomaron Abram y Nacor para sí esposas: el nombre de la esposa de Abram, fue Sarai, y el nombre de la esposa de Nacor, Milca, hija de Harán, padre de Milca y de Isca. ");
INSERT INTO spav1602p_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Mas Sarai fue esteril, y no tenía hijo. ");
INSERT INTO spav1602p_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Y tomó Taré a Abram su hijo, y a Lot hijo de Harán, hijo de su hijo, y a Sarai su nuera, esposa de Abram su hijo: y salió con ellos de Ur de los caldeos, para ir a la tierra de Canaán: y vinieron hasta Harán, y asenta­ron allí. ");
INSERT INTO spav1602p_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Y fueron los días de Taré doscientos y cinco años; y murió Taré en Harán. ");
INSERT INTO spav1602p_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","AHORA el SEÑOR había dicho a Abram: Vete de tu tierra y de tu parentela, y de la casa de tu padre, a la tierra que te mostraré; ");
INSERT INTO spav1602p_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Y haré de ti una nación grande, y bendecirte he, y engrandeceré tu nombre, y serás bendición: ");
INSERT INTO spav1602p_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Y bendeciré a los que te bendijeren, y a los que te maldijeren maldeciré: y serán benditas en ti todas las familias de la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Y fuese Abram, como el SEÑOR le dijo; y fue con él Lot: y era Abram de edad de setenta y cinco años cuando salió de Harán. ");
INSERT INTO spav1602p_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Y tomó Abram a Sarai su esposa, y a Lot hijo de su hermano, y toda su sustancia que habían ganado, y las almas que habían adquirido en Harán, y salieron para ir a tierra de Canaán; y a tierra de Canaán llegaron. ");
INSERT INTO spav1602p_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Y pasó Abram por aquella tie­rra hasta el lugar de Siquem, hasta la llanura de Moreh: y el cananeo estaba entonces en la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Y apareció el SEÑOR a Abram, y le dijo: A tu simiente daré esta tierra. Y edificó allí un altar al SEÑOR, que le había aparecido. ");
INSERT INTO spav1602p_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Y pasóse de allí a un monte al oriente de Betel, y tendió su tienda, teniendo a Betel al occi­dente y Hai al oriente: y edificó allí altar al SEÑOR, e invocó el nombre del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Y partióse Abram, yendo aún hacia el sur. ");
INSERT INTO spav1602p_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Y hubo hambre en la tierra, y descendió Abram a Egipto para peregrinar allá; porque era grande el hambre en la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Y aconteció que cuando esta­ba para entrar en Egipto, dijo a Sarai su esposa: He aquí, ahora conozco que eres mujer hermosa de vista; ");
INSERT INTO spav1602p_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Y será que cuando te habrán visto los egipcios, dirán: Su esposa es: y me matarán a mí, y a ti te reservarán la vida. ");
INSERT INTO spav1602p_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Ahora pues, di que eres mi hermana, para que yo haya bien por causa tuya, y viva mi alma por amor de ti. ");
INSERT INTO spav1602p_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Y aconteció que, como entró Abram en Egipto, los egipcios vieron la mujer que era hermosa en gran manera. ");
INSERT INTO spav1602p_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Viéronla también los prínci­pes de Faraón, y se la alabaron; y fue llevada la mujer a casa de Faraón: ");
INSERT INTO spav1602p_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","E hizo bien a Abram por causa de ella; y tuvo ovejas, y vacas, y asnos, y siervos, y cria­das, y asnas y camellos. ");
INSERT INTO spav1602p_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Mas el SEÑOR hirió a Faraón y a su casa con grandes plagas, por causa de Sarai esposa de Abram. ");
INSERT INTO spav1602p_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Entonces Faraón llamó a Abram, y le dijo: ¿Qué es esto que has hecho conmigo? ¿Por qué no me declaraste que era tu esposa? ");
INSERT INTO spav1602p_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","¿Por qué dijiste: Es mi her­mana, poniéndome en ocasión de tomarla para mí por esposa? Ahora pues, he aquí tu esposa, tómala y vete. ");
INSERT INTO spav1602p_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Entonces Faraón dio orden a sus gentes acerca de Abram; y le acompañaron, y a su esposa con todo lo que tenía. ");
INSERT INTO spav1602p_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","SUBIÓ, pues, Abram de Egipto hacia el sur, él, y su esposa, con todo lo que tenía, y con él Lot. ");
INSERT INTO spav1602p_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Y Abram era riquísimo en ganado, en plata y oro. ");
INSERT INTO spav1602p_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Y él fue por sus jornadas del sur hasta Betel, hasta el lugar donde había estado antes su tienda, entre Betel y Hai; ");
INSERT INTO spav1602p_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Al lugar del altar que había hecho allí antes: e invocó allí Abram el nombre del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Y asimismo Lot, que andaba con Abram, tenía ovejas, y vacas, y tiendas. ");
INSERT INTO spav1602p_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Y la tierra no podía darles para que habitasen juntos: porque su sustancia era mucha, y no podían morar en un mismo lugar. ");
INSERT INTO spav1602p_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Y hubo contienda entre los pas­tores del ganado de Abram y los pastores del ganado de Lot: y el cananeo y el ferezeo habitaban entonces en la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Entonces Abram dijo a Lot: No haya ahora altercado entre mí y ti, entre mis pastores y los tuyos, porque somos hermanos. ");
INSERT INTO spav1602p_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","¿No está toda la tierra delante de ti? Yo te ruego que te apartes de mí. Si fueres a la mano izquierda, yo iré a la derecha: y si fueres a la derecha, yo iré a la izquierda. ");
INSERT INTO spav1602p_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Y alzó Lot sus ojos, y vio toda la llanura del Jordán, que toda ella era de riego, antes que des­truyese el SEÑOR a Sodoma y a Gomorra, aún como el huerto del SEÑOR, como la tierra de Egipto entrando en Zoar. ");
INSERT INTO spav1602p_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Entonces Lot escogió para sí toda la llanura del Jordán: y par­tióse Lot de Oriente, y apartáron­se el uno del otro. ");
INSERT INTO spav1602p_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram asentó en la tierra de Canaán, y Lot asentó en las ciu­dades de la llanura, y fue ponien­do sus tiendas hasta Sodoma. ");
INSERT INTO spav1602p_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Mas los hombres de Sodoma eran malos y pecadores para con el SEÑOR en gran manera. ");
INSERT INTO spav1602p_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Y el SEÑOR dijo a Abram, después que Lot se apartó de él: Alza ahora tus ojos, y mira desde el lugar donde estás hacia el norte, y al sur, y al oriente y al occidente; ");
INSERT INTO spav1602p_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Porque toda la tierra que ves, la daré a ti y a tu simiente para siempre. ");
INSERT INTO spav1602p_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Y haré tu simiente como el polvo de la tierra: que si alguno podrá contar el polvo de la tierra, también tu simiente será contada. ");
INSERT INTO spav1602p_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Levántate, ve por la tierra a lo largo de ella y a su ancho; porque a ti la tengo de dar. ");
INSERT INTO spav1602p_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Abram, pues, removiendo su tienda, vino y moró en el llano de Mamre, que es en Hebrón, y edi­ficó allí altar al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Y ACONTECIÓ en los días de Amrafel, rey de Sinar, Arioc, rey de Elasar, Quedorlaomer, rey de Elam, y Tidal, rey de naciones, ");
INSERT INTO spav1602p_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Que éstos hicieron guerra contra Bera, rey de Sodoma, y con­tra Birsa, rey de Gomorra, y contra Sinab, rey de Adma, y contra Semeber, rey de Zeboim, y contra el rey de Bela, la cual es Zoar. ");
INSERT INTO spav1602p_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Todos estos se juntaron en el valle de Sidim, que es el mar salado. ");
INSERT INTO spav1602p_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Doce años habían servido a Quedorlaomer, y al décimotercio año se rebelaron. ");
INSERT INTO spav1602p_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Y en el año décimocuarto vino Quedorlaomer, y los reyes que estaban de su parte, y derrotaron a los refaítas en Asterot-car­naim, a los zuzitas en Ham, y a los emitas en Save-Quiriataim. ");
INSERT INTO spav1602p_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Y a los horeos en el monte de Seir, hasta la llanura de Parán, que está junto al desierto. ");
INSERT INTO spav1602p_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Y volvieron y vinieron a Emispat, que es Cades, y devastaron todas las haciendas de los amalecitas, y también al amorreo, que habitaba en Hazezón-tamar. ");
INSERT INTO spav1602p_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Y salió el rey de Sodoma, y el rey de Gomorra, y el rey de Adma, y el rey de Zeboim, y el rey de Bela, que es Zoar, y orde­naron contra ellos batalla en el valle de Sidim; ");
INSERT INTO spav1602p_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Es a saber, contra Quedorlaomer, rey de Elam, y Tidal, rey de nacio­nes, y Amrafel, rey de Sinar, y Arioc, rey de Elasar; cuatro reyes contra cinco. ");
INSERT INTO spav1602p_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Y el valle de Sidim estaba lleno de pozos de betún: y huyeron el rey de Sodoma y el de Gomorra, y cayeron allí; y los demás huyeron al monte. ");
INSERT INTO spav1602p_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Y tomaron toda la riqueza de Sodoma y de Gomorra, y todas sus vituallas, y se fueron. ");
INSERT INTO spav1602p_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Tomaron también a Lot, hijo del hermano de Abram, que moraba en Sodoma, y su hacien­da, y se fueron. ");
INSERT INTO spav1602p_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Y vino uno de los que escapa­ron, y denunciólo a Abram el hebreo, que habitaba en el llano de Mamre amorreo, hermano de Escol y hermano de Aner, los cuales estaban confederados con Abram. ");
INSERT INTO spav1602p_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Y oyó Abram que su hermano estaba prisionero, y armó a sus criados, los nacidos en su casa, trescientos dieciocho, y los siguió hasta Dan. ");
INSERT INTO spav1602p_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Y derramóse sobre ellos de noche él y sus siervos, e hiriólos, y fuélos siguiendo hasta Hobah, que está a la izquierda de Damasco. ");
INSERT INTO spav1602p_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Y recobró todos los bienes, y también a Lot su hermano y su hacienda, y también las mujeres y gente. ");
INSERT INTO spav1602p_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Y salió el rey de Sodoma a recibirlo, cuando volvía de la derrota de Quedorlaomer y de los reyes que con él estaban, al valle de Save, que es el valle del rey. ");
INSERT INTO spav1602p_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Entonces Melquisedec, rey de Salem, sacó pan y vino; el cual era sacerdote del Dios Altísimo; ");
INSERT INTO spav1602p_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Y bendíjole, y dijo: Bendito sea Abram del Dios Altísimo, posee­dor del cielo y de la tierra; ");
INSERT INTO spav1602p_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Y bendito sea el Dios Altísimo, que entregó tus enemigos en tu mano. Y dióle Abram los diez­mos de todo. ");
INSERT INTO spav1602p_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Entonces el rey de Sodoma dijo a Abram: Dame las perso­nas, y toma para ti la hacienda. ");
INSERT INTO spav1602p_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Y respondió Abram al rey de Sodoma: He alzado mi mano al SEÑOR Dios Altísimo, poseedor del cielo y de la tierra, ");
INSERT INTO spav1602p_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Que desde un hilo hasta la correa de un zapato, nada toma­ré de todo lo que es tuyo, para que no digas: Yo enriquecí a Abram: ");
INSERT INTO spav1602p_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Sacando solamente lo que comieron los mancebos, y la por­ción de los varones que fueron conmigo, Aner, Escol, y Mamre; los cuales tomarán su parte. ");
INSERT INTO spav1602p_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","DESPUÉS de estas cosas vino la palabra del SEÑOR a Abram en visión, diciendo: No temas, Abram; Yo soy tu escudo, y tu galardón sobremanera grande. ");
INSERT INTO spav1602p_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Y respondió Abram: Señor DIOS, ¿qué me has de dar, sien­do así que ando sin hijo, y el mayordomo de mi casa es ese damasceno Eliezer? ");
INSERT INTO spav1602p_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Dijo más Abram: Mira que no me has dado prole, y he aquí que es mi heredero uno nacido en mi casa. ");
INSERT INTO spav1602p_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Y luego la palabra del SEÑOR vino a él diciendo: No te heredará éste, sino el que saldrá de tus entrañas será el que te herede. ");
INSERT INTO spav1602p_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Y sacóle fuera, y dijo: Mira ahora al cielo, y cuenta las estrellas, si las puedes contar. Y le dijo: Así será tu simiente. ");
INSERT INTO spav1602p_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Y creyó al SEÑOR, y contóselo por justicia. ");
INSERT INTO spav1602p_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Y díjole: Yo soy el SEÑOR, que te saqué de Ur de los caldeos, para darte a heredar esta tierra. ");
INSERT INTO spav1602p_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Y él respondió: Señor DIOS, ¿en qué conoceré que la tengo de here­dar? ");
INSERT INTO spav1602p_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Y le dijo: Apártame una becerra de tres años, y una cabra de tres años, y un carnero de tres años, una tórtola también, y un palomi­no. ");
INSERT INTO spav1602p_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Y tomó él todas estas cosas, y partiólas por la mitad, y puso cada mitad una enfrente de otra; mas no partió las aves. ");
INSERT INTO spav1602p_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Y descendían aves sobre los cuerpos muertos, y ojeábalas Abram. ");
INSERT INTO spav1602p_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Mas a la caída del sol sobre­cogió el sueño a Abram, y he aquí que el pavor de una grande oscuridad cayó sobre él. ");
INSERT INTO spav1602p_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Entonces dijo a Abram: Ten por cierto que tu simiente será peregrina en tierra no suya, y ser­virá a los de allí, y serán por ellos afligidos cuatrocientos años. ");
INSERT INTO spav1602p_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Mas también a la nación a quien servirán, juzgaré yo; y después de esto saldrán con grande sustancia. ");
INSERT INTO spav1602p_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Y tú vendrás a tus padres en paz, y serás sepultado en buena vejez. ");
INSERT INTO spav1602p_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Y en la cuarta generación volverán acá: porque aun no está cumplida la maldad del amorreo hasta aquí. ");
INSERT INTO spav1602p_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Y sucedió que puesto el sol, y ya oscurecido, dejóse ver un horno humeando, y una antorcha de fuego que pasó por entre los animales divididos. ");
INSERT INTO spav1602p_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","En aquel día hizo el SEÑOR un pacto con Abram diciendo: A tu simiente daré esta tierra desde el río de Egipto hasta el río grande, el río Éufrates; ");
INSERT INTO spav1602p_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Los cineos, y los ceneceos, y los cedmoneos, ");
INSERT INTO spav1602p_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Y los heteos, y los ferezeos, y los refaítas, ");
INSERT INTO spav1602p_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Y los amorreos, y los cananeos, y los gergeseos, y los jebuseos. ");
INSERT INTO spav1602p_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Y SARAI, esposa de Abram no le paría: y ella tenía una sierva egipcia, que se llamaba Agar. ");
INSERT INTO spav1602p_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Dijo, pues, Sarai a Abram: Ya ves que el SEÑOR me ha hecho estéril: ruégote que entres a mi sierva; quizá tendré hijos de ella. Y atendió Abram al dicho de Sarai. ");
INSERT INTO spav1602p_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Y Sarai, esposa de Abram, tomó a Agar su sierva egipcia, al cabo de diez años que había habitado Abram en la tierra de Canaán, y dióla a Abram su marido por esposa. ");
INSERT INTO spav1602p_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Y él cohabitó con Agar, la cual concibió: y cuando vio que había concebido, miraba con desprecio a su señora. ");
INSERT INTO spav1602p_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Entonces Sarai dijo a Abram: Mi afrenta sea sobre ti: yo puse mi sierva en tu seno, y viéndose embarazada, me mira con des­precio; juzgue el SEÑOR entre mí y ti. ");
INSERT INTO spav1602p_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Y respondió Abram a Sarai: He ahí tu sierva en tu mano, haz con ella lo que bien te pareciere. Y como Sarai la afligiese, huyóse de su presencia. ");
INSERT INTO spav1602p_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Y hallóla el ángel del SEÑOR junto a una fuente de agua en el desierto, junto a la fuente que está en el camino de Shur. ");
INSERT INTO spav1602p_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Y le dijo: Agar, sierva de Sarai, ¿de dónde vienes tú, y a dónde vas? Y ella respondió: Huyo de delante de Sarai, mi señora. ");
INSERT INTO spav1602p_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Y díjole el ángel del SEÑOR: Vuélvete a tu señora, y ponte sumisa bajo de su mano. ");
INSERT INTO spav1602p_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Díjole también el ángel del SEÑOR: Multiplicaré tanto tu linaje, que no será contado a causa de la muchedumbre. ");
INSERT INTO spav1602p_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Díjole aún el ángel del SEÑOR: He aquí que has conce­bido, y parirás un hijo, y llamarás su nombre Ismael, porque oído ha el SEÑOR tu aflicción. ");
INSERT INTO spav1602p_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Y él será hombre fiero; su mano será contra todos, y las manos de todos contra él; y delante de todos sus hermanos habitará. ");
INSERT INTO spav1602p_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Y llamó el nombre del SEÑOR que con ella hablaba: Tú Dios me ves; porque dijo: ¿No he visto también aquí al que me ve? ");
INSERT INTO spav1602p_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Por lo cual llamó al pozo, Beer-lajai-roi. He aquí está entre Cades y Bered. ");
INSERT INTO spav1602p_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Y parió Agar a Abram un hijo, y llamó Abram el nombre de su hijo que le parió Agar, Ismael. ");
INSERT INTO spav1602p_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Y era Abram de edad de ochenta y seis años, cuando parió Agar a Ismael. ");
INSERT INTO spav1602p_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Y SIENDO Abram de edad de noventa y nueve años, aparecióle el SEÑOR, y le dijo: Yo soy el Dios Todopoderoso; anda delante de mí, y sé perfecto. ");
INSERT INTO spav1602p_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Y pondré mi pacto entre mí y ti, y multiplicarte he mucho en gran manera. ");
INSERT INTO spav1602p_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Entonces Abram cayó sobre su rostro, y Dios habló con él diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Yo, he aquí mi pacto es contigo: Serás padre de muchedumbre de naciones: ");
INSERT INTO spav1602p_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Y no se llamará más tu nombre Abram, sino que será tu nombre Abraham, porque te he puesto por padre de muchedumbre de naciones. ");
INSERT INTO spav1602p_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Y multiplicarte he mucho en gran manera, y te pondré en naciones, y reyes saldrán de ti. ");
INSERT INTO spav1602p_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Y estableceré mi pacto entre mí y ti, y tu simiente después de ti en sus generaciones, por pacto per­petuo, para serte a ti por Dios, y a tu simiente después de ti. ");
INSERT INTO spav1602p_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Y te daré a ti, y a tu simiente después de ti, la tierra de tus peregrinaciones, toda la tierra de Canaán en heredad perpetua; y seré el Dios de ellos. ");
INSERT INTO spav1602p_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Dijo de nuevo Dios a Abraham: Tú por lo tanto guardarás mi pacto, tú y tu simiente des­pués de ti por sus generaciones. ");
INSERT INTO spav1602p_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Éste es mi pacto, que guar­daréis entre mí y vosotros y tu simiente después de ti: Será cir­cuncidado todo varón de entre vosotros. ");
INSERT INTO spav1602p_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Circuncidaréis, pues, la carne de vuestro prepucio, y será por señal del pacto entre mí y voso­tros. ");
INSERT INTO spav1602p_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Y de edad de ocho días será circuncidado todo varón entre vosotros por vuestras generacio­nes: el nacido en casa, y el com­prado a dinero de cualquier extranjero, que no fuere de tu simiente. ");
INSERT INTO spav1602p_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Debe ser circuncidado el nacido en tu casa, y el comprado por tu dinero: y estará mi pacto en vuestra carne para pacto per­petuo. ");
INSERT INTO spav1602p_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Y el varón incircunciso que no hubiere circuncidado la carne de su prepucio, aquella alma será borrada de su pueblo; ha violado mi pacto. ");
INSERT INTO spav1602p_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Dijo también Dios a Abraham: A Sarai tu esposa no la llamarás Sarai, mas Sara será su nombre. ");
INSERT INTO spav1602p_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Y bendecirla he, y también te daré de ella hijo; sí, la bendeciré, y vendrá a ser madre de nacio­nes; reyes de pueblos serán de ella. ");
INSERT INTO spav1602p_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Entonces Abraham cayó sobre su rostro, y rióse, y dijo en su corazón: ¿A hombre de cien años ha de nacer hijo? ¿y Sara, ya de noventa años, ha de parir? ");
INSERT INTO spav1602p_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Y dijo Abraham a Dios: ¡Oh que Ismael viva delante de ti! ");
INSERT INTO spav1602p_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Y respondió Dios: Ciertamente Sara tu esposa te parirá un hijo, y llamarás su nombre Isaac; y con­firmaré mi pacto con él por un pacto perpetuo, y con su simiente des­pués de él. ");
INSERT INTO spav1602p_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Y en cuanto a Ismael, también te he oído: he aquí que le bende­ciré, y le haré fructificar y multi­plicar mucho en gran manera: doce príncipes engendrará, y le haré una gran nación. ");
INSERT INTO spav1602p_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Mas yo estableceré mi pacto con Isaac, al cual te parirá Sara por este tiempo el año siguiente. ");
INSERT INTO spav1602p_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Y acabó de hablar con él, y subió Dios de con Abraham. ");
INSERT INTO spav1602p_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Entonces tomó Abraham a Ismael su hijo, y a todos los nacidos en su casa, y a todos los comprados por su dinero, a todo varón entre los domésticos de la casa de Abraham, y circun­cidó la carne del prepucio de ellos en aquel mismo día, como Dios le había dicho. ");
INSERT INTO spav1602p_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Era Abraham de edad de noventa y nueve años cuando circuncidó la carne de su prepu­cio. ");
INSERT INTO spav1602p_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","E Ismael su hijo era de trece años, cuando fue circuncidada la carne de su prepucio. ");
INSERT INTO spav1602p_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","En el mismo día fue circunci­dado Abraham e Ismael su hijo. ");
INSERT INTO spav1602p_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Y todos los varones de su casa, los nacidos en casa, y los comprados por dinero del extranjero, fueron circuncidados con él. ");
INSERT INTO spav1602p_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Y APARECIÓLE el SEÑOR en el llano de Mamre, estando él sentado a la puerta de su tienda en el calor del día. ");
INSERT INTO spav1602p_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Y alzó sus ojos y miró, y he aquí tres varones que estaban junto a él: y cuando los vio, salió, corriendo de la puerta de su tien­da a recibirlos, e inclinóse hacia la tierra, ");
INSERT INTO spav1602p_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Y dijo: Señor, si ahora he halla­do gracia en tus ojos, ruégote que no pases de tu siervo. ");
INSERT INTO spav1602p_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Que se traiga ahora un poco de agua, y lavad vuestros pies; y recostaos debajo de un árbol, ");
INSERT INTO spav1602p_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Y traeré un bocado de pan, y sustentad vuestro corazón; des­pués pasaréis: porque por eso habéis pasado cerca de vuestro siervo. Y ellos dijeron: Haz así como has dicho. ");
INSERT INTO spav1602p_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Entonces Abraham fue de prie­sa a la tienda a Sara, y le dijo: Toma presto tres medidas de flor de harina, amasa y haz panes cocidos debajo del rescoldo. ");
INSERT INTO spav1602p_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Y corrió Abraham a las vacas, y tomó un becerro tierno y bueno, y diólo al mozo, y dióse éste priesa a aderezarlo. ");
INSERT INTO spav1602p_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Tomó también manteca y leche, y el becerro que había aderezado, y púsolo delante de ellos; y él estaba junto a ellos debajo del árbol; y comieron. ");
INSERT INTO spav1602p_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Y le dijeron: ¿Dónde está Sara tu esposa? Y él respondió: Aquí en la tienda. ");
INSERT INTO spav1602p_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Entonces dijo: De cierto vol­veré a ti según el tiempo de la vida, y he aquí, tendrá un hijo Sara tu esposa. Y Sara escuchaba a la puerta de la tienda, que esta­ba detrás de él. ");
INSERT INTO spav1602p_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Y Abraham y Sara eran viejos, y entrados en días: y a Sara había cesado ya la costumbre de las mujeres. ");
INSERT INTO spav1602p_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Rióse, pues, Sara entre si, diciendo: ¿Después que he enve­jecido tendré deleite, siendo tam­bién mi señor ya viejo? ");
INSERT INTO spav1602p_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Entonces el SEÑOR dijo a Abraham: ¿Por qué se ha reído Sara diciendo: Será cierto que he de parir siendo ya vieja? ");
INSERT INTO spav1602p_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","¿Hay para el SEÑOR alguna cosa difícil? Al tiempo señalado vol­veré a ti, según el tiempo de la vida, y Sara tendrá un hijo. ");
INSERT INTO spav1602p_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Entonces Sara negó, dicien­do: No me reí; porque tuvo miedo. Y él dijo: No, sino que te has reído. ");
INSERT INTO spav1602p_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Y los varones se levantaron de allí, y miraron hacia Sodoma: y Abraham iba con ellos acompa­ñándolos. ");
INSERT INTO spav1602p_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Y el SEÑOR dijo: ¿Encubriré yo a Abraham lo que voy a hacer, ");
INSERT INTO spav1602p_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Habiendo de ser Abraham en una nación grande y fuerte, y habiendo de ser benditas en él todas las naciones de la tierra? ");
INSERT INTO spav1602p_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Porque yo lo conozco, que mandará a sus hijos y a su casa después de si, que guarden el camino del SEÑOR, haciendo justicia y juicio, para que haga venir el SEÑOR sobre Abraham lo que ha hablado acerca de él. ");
INSERT INTO spav1602p_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Entonces el SEÑOR le dijo: Por cuanto el clamor de Sodoma y Gomorra se aumenta más y más, y el pecado de ellos se ha agravado en extremo, ");
INSERT INTO spav1602p_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Descenderé ahora, y veré si han consumado su obra según el clamor que ha venido hasta mí; y si no, saberlo he. ");
INSERT INTO spav1602p_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Y apartáronse de allí los varo­nes, y fueron hacia Sodoma: mas Abraham estaba aún delante del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Y acercóse Abraham y dijo: ¿Destruirás también al justo con el impío? ");
INSERT INTO spav1602p_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Quizá hay cincuenta justos dentro de la ciudad: ¿destruirás también y no perdonarás al lugar por cincuenta justos que estén dentro de él? ");
INSERT INTO spav1602p_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Lejos de ti el hacer tal, que hagas morir al justo con el impío, y que sea el justo tratado como el impío; nunca tal hagas. El juez de toda la tierra, ¿no ha de hacer lo que es justo? ");
INSERT INTO spav1602p_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Entonces respondió el SEÑOR: Si hallare en Sodoma cincuenta justos dentro de la ciu­dad, perdonaré a todo este lugar por amor de ellos. ");
INSERT INTO spav1602p_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Y Abraham replicó y dijo: He aquí ahora que he comenzado a hablar a mi Señor, aunque soy polvo y ceniza: ");
INSERT INTO spav1602p_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Quizá faltarán de cincuenta justos cinco: ¿destruirás toda la ciudad por aquellos cinco que falten? Y dijo: No la destruiré, si hallare allí cuarenta y cinco. ");
INSERT INTO spav1602p_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Y volvió a hablarle, y dijo: Quizá se hallarán allí cuarenta. Y respondió: No lo haré por amor de los cuarenta. ");
INSERT INTO spav1602p_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Y dijo: No se enoje ahora mi Señor, si hablare: quizá se halla­rán allí treinta. Y respondió: No lo haré si hallare allí treinta. ");
INSERT INTO spav1602p_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Y dijo: He aquí ahora que he emprendido el hablar a mi Señor: quizá se hallarán allí veinte. No la destruiré, respondió, por amor de los veinte. ");
INSERT INTO spav1602p_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Y volvió a decir: No se enoje ahora mi Señor, si hablare sola­mente esta vez: quizá se hallarán allí diez. No la destruiré, respon­dió, por amor de los diez. ");
INSERT INTO spav1602p_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Y fuese el SEÑOR, luego que acabó de hablar a Abraham: y Abraham se volvió a su lugar. ");
INSERT INTO spav1602p_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","LLEGARON, pues, los dos ángeles a Sodoma a la caída de la tarde: y Lot estaba sentado a la puerta de Sodoma. Y viéndolos Lot, levantóse a recibirlos, e inclinóse hacia el suelo; ");
INSERT INTO spav1602p_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Y dijo: Ahora, pues, mis seño­res, os ruego que vengáis a casa de vuestro siervo y os hospedéis, y lavaréis vuestros pies: y por la mañana os levantaréis, y seguiréis vuestro camino. Y ellos res­pondieron: No, que en la plaza nos quedaremos esta noche. ");
INSERT INTO spav1602p_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Mas él porfió con ellos mucho, y se vinieron con él, y entraron en su casa; e hízoles banquete, y coció panes sin levadura, y comieron. ");
INSERT INTO spav1602p_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Y antes que se acostasen, cer­caron la casa los hombres de la ciudad, los varones de Sodoma, todo el pueblo junto, desde el más joven hasta el más viejo; ");
INSERT INTO spav1602p_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Y llamaron a Lot, y le dijeron: ¿Dónde están los varones que vinieron a ti esta noche? sácanos­los, para que los conozcamos. ");
INSERT INTO spav1602p_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Entonces Lot salió a ellos a la puerta, y cerró las puertas tras sí, ");
INSERT INTO spav1602p_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Y dijo: Os ruego, hermanos, que no hagáis tal maldad. ");
INSERT INTO spav1602p_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","He aquí ahora yo tengo dos hijas que no han conocido varón; os las sacaré afuera, y haced de ellas como bien os pareciere: solamente a estos varones no hagáis nada, pues que vinieron a la sombra de mi tejado. ");
INSERT INTO spav1602p_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Y ellos respondieron: Quita allá: y añadieron: Vino éste aquí para habitar como un extraño, ¿y habrá de erigirse en juez? Ahora te haremos más mal que a ellos. Y hacían gran violencia al varón, aun a Lot, y se acercaron para romper las puertas. ");
INSERT INTO spav1602p_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Entonces los varones alarga­ron la mano, y metieron a Lot en casa con ellos, y cerraron las puertas. ");
INSERT INTO spav1602p_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Y a los hombres que estaban a la puerta de la casa desde el menor hasta el mayor, hirieron con ceguera; mas ellos se fatiga­ban por hallar la puerta. ");
INSERT INTO spav1602p_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Y dijeron los varones a Lot: ¿Tienes aquí alguno más? Yerno, y tus hijos y tus hijas, y todo lo que tienes en la ciudad, sácalo de este lugar: ");
INSERT INTO spav1602p_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Porque vamos a destruir este lugar, por cuanto el clamor de ellos ha subido de punto delante del SEÑOR; por tanto el SEÑOR nos ha enviado para destruirlo. ");
INSERT INTO spav1602p_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Entonces salió Lot, y habló a sus yernos, que se habían casado con sus hijas, y les dijo: Levantaos, salid de este lugar; porque el SEÑOR destruirá esta ciudad. Pero pareció a sus yernos como alguien que se burlaba. ");
INSERT INTO spav1602p_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Y al rayar el alba, los ángeles daban prisa a Lot, diciendo: Levántate, toma tu esposa, y tus dos hijas que se hallan aquí, por­que no perezcas en el castigo de la ciudad. ");
INSERT INTO spav1602p_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Y deteniéndose él, los varones asieron de su mano, y de la mano de su esposa, y de las manos de sus dos hijas, según la misericor­dia del SEÑOR para con él; y le sacaron, y le pusieron fuera de la ciudad. ");
INSERT INTO spav1602p_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Y sucedió que cuando los hubo sacado fuera, dijo: Escapa por tu vida; no mires tras ti, ni pares en toda esta llanura; escapa al monte, no sea que perezcas. ");
INSERT INTO spav1602p_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Y Lot les dijo: Oh no, Señor mío; ");
INSERT INTO spav1602p_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","He aquí ahora ha hallado tu siervo gracia en tus ojos, y has engrandecido tu misericordia que has hecho conmigo dándo­me la vida; mas yo no podré escapar al monte, no sea caso que me alcance el mal y muera. ");
INSERT INTO spav1602p_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","He aquí ahora esta ciudad está cerca para huir allá, la cual es pequeña; escaparé ahora allá, (¿no es ella pequeña?) y vivirá mi alma. ");
INSERT INTO spav1602p_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Y le respondió: He aquí he recibido también tu súplica sobre esto, y no destruiré la ciudad de que has hablado. ");
INSERT INTO spav1602p_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Date priesa, escápate allá; porque nada podré hacer hasta que allí hayas llegado. Por esto fue llamado el nombre de la ciu­dad, Zoar. ");
INSERT INTO spav1602p_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","El sol salía sobre la tierra, cuando Lot llegó a Zoar. ");
INSERT INTO spav1602p_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Entonces llovió el SEÑOR sobre Sodoma y sobre Gomorra azufre y fuego de parte del SEÑOR desde el cielo; ");
INSERT INTO spav1602p_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Y destruyó las ciudades, y toda aquella llanura, con todos los moradores de aquellas ciuda­des, y el fruto de la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Entonces la esposa de Lot miró atrás, a espaldas de él, y se volvió estatua de sal. ");
INSERT INTO spav1602p_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Y subió Abraham por la mañana al lugar donde había estado delante del SEÑOR: ");
INSERT INTO spav1602p_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Y miró hacia Sodoma y Gomorra, y hacia toda la tierra de aquella llanura miró; y he aquí que el humo subía de la tierra como el humo de un horno. ");
INSERT INTO spav1602p_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Así sucedió que, cuando destruyó Dios las ciudades de la llanura, acordóse Dios de Abraham, y envió fuera a Lot de en medio de la destrucción, al asolar las ciu­dades donde Lot estaba. ");
INSERT INTO spav1602p_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Y Lot subió de Zoar, y asentó en el monte, y sus dos hijas con él; porque tuvo miedo de quedar en Zoar, y se alojó en una cueva él y sus dos hijas. ");
INSERT INTO spav1602p_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Entonces la mayor dijo a la menor: Nuestro padre es viejo, y no queda varón en la tierra que entre a nosotras conforme a la costumbre de toda la tierra: ");
INSERT INTO spav1602p_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Ven, demos a beber vino a nuestro padre, y durmamos con él, y conservaremos de nuestro padre generación. ");
INSERT INTO spav1602p_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Y dieron a beber vino a su padre aquella noche: y entró la mayor, y durmió con su padre; mas él no sintió cuándo se acos­tó ella, ni cuándo se levantó. ");
INSERT INTO spav1602p_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","El día siguiente dijo la mayor a la menor: He aquí yo dormí la noche pasada con mi padre: démosle a beber vino también esta noche, y entra y duerme con él, para que conservemos de nuestro padre generación. ");
INSERT INTO spav1602p_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Y dieron a beber vino a su padre también aquella noche: y levantóse la menor, y durmió con él; pero no echó de ver cuándo se acostó ella, ni cuándo se levantó. ");
INSERT INTO spav1602p_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Y concibieron las dos hijas de Lot, de su padre. ");
INSERT INTO spav1602p_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Y parió la mayor un hijo, y llamó su nombre Moab, el cual es padre de los moabitas hasta hoy. ");
INSERT INTO spav1602p_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","La menor también parió un hijo, y llamó su nombre Ben­-amí, el cual es padre de los amonitas hasta hoy. ");
INSERT INTO spav1602p_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","DE ALLÍ partió Abraham a la tierra del sur, y asentó entre Cades y Shur, y habitó como forastero en Gerar. ");
INSERT INTO spav1602p_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Y dijo Abraham de Sara su esposa: Mi hermana es. Y Abimelec, rey de Gerar, envió y tomó a Sara. ");
INSERT INTO spav1602p_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Pero Dios vino a Abimelec en sueños de noche, y le dijo: He aquí muerto eres a causa de la mujer que has tomado, la cual es casada con marido. ");
INSERT INTO spav1602p_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Mas Abimelec no había llega­do a ella, y dijo: Señor, ¿matarás también una nación justa? ");
INSERT INTO spav1602p_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","¿No me dijo él: Mi hermana es; y ella también dijo: Es mi herma­no? Con sencillez de mi corazón, y con limpieza de mis manos he hecho esto. ");
INSERT INTO spav1602p_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Y díjole Dios en sueños: Yo tam­bién sé que con integridad de tu corazón has hecho esto; y yo tam­bién te detuve de pecar contra mí, y así no te permití que la tocases. ");
INSERT INTO spav1602p_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Ahora, pues, devuelve su esposa a este hombre; porque él es profeta, y orará por ti, y vivirás. Y si tú no la devolvieres, sabe que de cierto morirás, con todo lo que fuere tuyo. ");
INSERT INTO spav1602p_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Entonces Abimelec se levantó de mañana, y llamó a todos sus siervos, y dijo todas estas pala­bras en los oídos de ellos; y temieron los hombres en gran manera. ");
INSERT INTO spav1602p_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Después llamó Abimelec a Abraham, y le dijo: ¿Qué nos has hecho? ¿y en qué pequé yo con­tra ti, que has atraído sobre mí y sobre mi reino tan gran pecado? lo que no debiste hacer has hecho conmigo. ");
INSERT INTO spav1602p_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Y dijo más Abimelec a Abraham: ¿Qué viste para que hicieses esto? ");
INSERT INTO spav1602p_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Y Abraham respondió: Porque dije para mí: Cierto no hay temor de Dios en este lugar, y me mata­rán por causa de mi esposa. ");
INSERT INTO spav1602p_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Y a la verdad ella es mi hermana, es hija de mi padre, mas no hija de mi madre, y toméla por esposa. ");
INSERT INTO spav1602p_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Y sucedió que, cuando Dios me hizo salir errante de la casa de mi padre, yo le dije: Ésta es la mer­ced que tú me harás, que en todos los lugares donde llegáremos, digas de mí: Mi hermano es. ");
INSERT INTO spav1602p_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Entonces Abimelec tomó ovejas y vacas y siervos y sier­vas, y los dio a Abraham, y devol­vióle a Sara su esposa. ");
INSERT INTO spav1602p_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Y dijo Abimelec: He aquí mi tierra está delante de ti, habita donde bien te pareciere. ");
INSERT INTO spav1602p_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Y a Sara dijo: He aquí he dado mil piezas de plata a tu hermano: mira que él te es por velo de ojos para todos los que están contigo, y para con todos: así fue reprendida. ");
INSERT INTO spav1602p_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Entonces Abraham oró a Dios; y Dios sanó a Abimelec y a su esposa, y a sus siervas, y parieron hijos. ");
INSERT INTO spav1602p_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Porque había del todo cerrado el SEÑOR toda matriz de la casa de Abimelec, a causa de Sara esposa de Abraham. ");
INSERT INTO spav1602p_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Y VISITÓ el SEÑOR a Sara, como había dicho, e hizo el SEÑOR con Sara como había hablado. ");
INSERT INTO spav1602p_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Y concibió y parió Sara a Abraham un hijo en su vejez, en el tiempo que Dios le había dicho. ");
INSERT INTO spav1602p_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Y llamó Abraham el nombre de su hijo que le nació, que le parió Sara, Isaac. ");
INSERT INTO spav1602p_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Y circuncidó Abraham a su hijo Isaac de ocho días, como Dios le había mandado. ");
INSERT INTO spav1602p_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Y era Abraham de cien años, cuando le nació Isaac su hijo. ");
INSERT INTO spav1602p_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Entonces dijo Sara: Dios me ha hecho reir, así que cualquiera que lo oyere, se reirá conmigo. ");
INSERT INTO spav1602p_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Y añadió: ¿Quién dijera a Abraham que Sara había de dar de mamar a hijos? pues que le he parido un hijo en su vejez. ");
INSERT INTO spav1602p_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Y creció el niño, y fue desteta­do; e hizo Abraham gran ban­quete el día que fue destetado Isaac. ");
INSERT INTO spav1602p_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Y vio Sara al hijo de Agar la egipcia, el cual había ésta parido a Abraham, que se burlaba. ");
INSERT INTO spav1602p_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Por tanto dijo a Abraham: Echa a esta sierva y a su hijo; que el hijo de esta sierva no ha de heredar con mi hijo, aún con Isaac. ");
INSERT INTO spav1602p_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Este dicho pareció grave en gran manera a Abraham a causa de su hijo. ");
INSERT INTO spav1602p_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Entonces dijo Dios a Abraham: No te parezca grave a causa del muchacho y de tu sier­va; en todo lo que te dijere Sara, oye su voz, porque en Isaac te será llamada descendencia. ");
INSERT INTO spav1602p_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Y también al hijo de la sierva pondré en nación, porque es tu simiente. ");
INSERT INTO spav1602p_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Entonces Abraham se levantó muy de mañana, y tomó pan, y un odre de agua, y diólo a Agar, poniéndolo sobre su hombro, y entrególe el muchacho, y despi­dióla. Y ella partió, y andaba errante por el desierto de Beerseba. ");
INSERT INTO spav1602p_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Y faltó el agua del odre, y echó al muchacho debajo de un árbol; ");
INSERT INTO spav1602p_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Y se fue y se sentó en frente de él, alejándose como un tiro de arco: porque decía, No veré cuando el muchacho morirá. Y ella se sentó en frente de él, y alzó su voz y lloró. ");
INSERT INTO spav1602p_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Y oyó Dios la voz del mucha­cho; y el ángel de Dios llamó a Agar desde el cielo, y le dijo: ¿Qué tienes, Agar? No temas; porque Dios ha oído la voz del muchacho en donde está. ");
INSERT INTO spav1602p_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Levántate, alza al muchacho, y ásele de tu mano, porque en gran nación lo tengo de poner. ");
INSERT INTO spav1602p_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Entonces abrió Dios sus ojos, y vio una fuente de agua; y fue, y llenó el odre de agua, y dio de beber al muchacho. ");
INSERT INTO spav1602p_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Y fue Dios con el muchacho; y creció, y habitó en el desierto, y fue tirador de arco. ");
INSERT INTO spav1602p_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Y habitó en el desierto de Parán; y su madre le tomó esposa de la tierra de Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Y aconteció en aquel mismo tiempo que habló Abimelec, y Ficol, príncipe de su ejército, a Abraham diciendo: Dios es con­tigo en todo cuanto haces: ");
INSERT INTO spav1602p_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Ahora pues, júrame aquí por Dios, que no faltarás a mí, ni a mi hijo, ni a mi nieto; sino que conforme a la bondad que yo hice contigo, harás tú conmigo, y con la tierra donde has peregrinado. ");
INSERT INTO spav1602p_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Y respondió Abraham: Yo juraré. ");
INSERT INTO spav1602p_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Y Abraham reconvino a Abimelec a causa de un pozo de agua, que los siervos de Abimelec le habían quitado. ");
INSERT INTO spav1602p_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Y respondió Abimelec: No sé quién haya hecho esto, ni tampoco tú me lo hiciste saber, ni yo lo he oído hasta hoy. ");
INSERT INTO spav1602p_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Y tomó Abraham ovejas y vacas, y dio a Abimelec; e hicieron ambos alianza. ");
INSERT INTO spav1602p_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Y puso Abraham siete corde­ras del rebaño aparte. ");
INSERT INTO spav1602p_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Y dijo Abimelec a Abraham: ¿Qué significan esas siete corde­ras que has puesto aparte? ");
INSERT INTO spav1602p_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Y él respondió: Que estas siete corderas tomarás de mi mano, para que me sean en testimonio de que yo cavé este pozo. ");
INSERT INTO spav1602p_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Por esto llamó a aquel lugar Beerseba; porque allí juraron ambos. ");
INSERT INTO spav1602p_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Así hicieron pacto en Beerseba: y levantóse Abimelec, y Ficol, príncipe de su ejército, y se volvieron a tierra de los filisteos. ");
INSERT INTO spav1602p_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Y plantó Abraham un árbol en Beerseba, e invocó allí el nombre del SEÑOR Dios eterno. ");
INSERT INTO spav1602p_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Y moró Abraham en tierra de los filisteos muchos días. ");
INSERT INTO spav1602p_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Y ACONTECIÓ después de estas cosas, que tentó Dios a Abraham, y le dijo: Abraham. Y él respondió: Heme aquí. ");
INSERT INTO spav1602p_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Y dijo: Toma ahora tu hijo, tu único hijo Isaac, a quien amas, y vete a tierra de Moriah, y ofrécelo allí en ofrenda quemada sobre uno de los montes que yo te diré. ");
INSERT INTO spav1602p_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Y Abraham se levantó muy de mañana, y enalbardó su asno, y tomó consigo dos mozos suyos, y a Isaac su hijo: y cortó leña para la ofrenda quemada, y levantóse, y fue al lugar que Dios le dijo. ");
INSERT INTO spav1602p_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Al tercer día alzó Abraham sus ojos, y vio el lugar de lejos. ");
INSERT INTO spav1602p_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Y dijo Abraham a sus mozos: Esperaos aquí con el asno, y yo y el muchacho iremos hasta allí, y adoraremos, y volveremos a vosotros. ");
INSERT INTO spav1602p_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Y tomó Abraham la leña de la ofrenda quemada, y púsola sobre Isaac su hijo: y él tomó en su mano el fuego y el cuchillo; y fueron ambos juntos. ");
INSERT INTO spav1602p_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Y habló Isaac a Abraham su padre, y dijo: Padre mío. Y él res­pondió: Heme aquí, mi hijo. Y él dijo: He aquí el fuego y la leña; mas ¿dónde está el cordero para la ofrenda quemada? ");
INSERT INTO spav1602p_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Y respondió Abraham: Dios se proveerá cordero para una ofrenda quemada, hijo mío. E iban juntos. ");
INSERT INTO spav1602p_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Y cuando llegaron al lugar que Dios le había dicho, y edificó allí Abraham un altar, y compuso la leña, y ató a Isaac su hijo, y púso­le en el altar sobre la leña. ");
INSERT INTO spav1602p_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Y extendió Abraham su mano, y tomó el cuchillo, para degollar a su hijo. ");
INSERT INTO spav1602p_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Y el ángel del SEÑOR le dio voces del cielo, y dijo: Abraham, Abraham. Y él respondió: Heme aquí. ");
INSERT INTO spav1602p_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Y dijo: No extiendas tu mano sobre el muchacho, ni le hagas nada; que ya conozco que temes a Dios, pues que no me rehusas­te tu hijo, tu único hijo. ");
INSERT INTO spav1602p_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Entonces alzó Abraham sus ojos, y miró, y he aquí un carne­ro a sus espaldas trabado en un zarzal por sus cuernos: y fue Abraham, y tomó el carnero, y ofrecióle en una ofrenda quemada en lugar de su hijo. ");
INSERT INTO spav1602p_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Y llamó Abraham el nombre de aquel lugar, Jehová-jireh. Por tanto se dice hasta hoy: En el monte del SEÑOR será provisto. ");
INSERT INTO spav1602p_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Y llamó el ángel del SEÑOR a Abraham segunda vez desde el cielo, ");
INSERT INTO spav1602p_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Y dijo: Por mí mismo he jura­do, dice el SEÑOR, que por cuanto has hecho esto, y no me has rehusado tu hijo, tu único hijo; ");
INSERT INTO spav1602p_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Bendiciendo te bendeciré, y multiplicando multiplicaré tu simiente como las estrellas del cielo, y como la arena que está a la orilla del mar; y tu simiente poseerá las puertas de sus enemi­gos: ");
INSERT INTO spav1602p_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","En tu simiente serán benditas todas las naciones de la tierra, por cuanto obedeciste a mi voz. ");
INSERT INTO spav1602p_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Y tornóse Abraham a sus mozos, y levantáronse y se fue­ron juntos a Beerseba; y habitó Abraham en Beerseba. ");
INSERT INTO spav1602p_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Y aconteció después de estas cosas, que fue dada nueva a Abraham, diciendo: He aquí que también Milca ha parido hijos a Nacor tu hermano: ");
INSERT INTO spav1602p_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","A Uz su primogénito, y a Buz su hermano, y a Kemuel padre de Aram, ");
INSERT INTO spav1602p_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Y a Quesed, y a Hazo, y a Pildas, y a Jidlaf, y a Betuel. ");
INSERT INTO spav1602p_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Y Betuel engendró a Rebeca. Estos ocho parió Milca a Nacor, hermano de Abraham. ");
INSERT INTO spav1602p_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Y su concubina, que se llamaba Reúma, parió también a Teba, y a Gaham, y a Tahas, y a Maaca. ");
INSERT INTO spav1602p_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Y FUE la vida de Sara ciento veintisiete años: tantos fueron los años de la vida de Sara. ");
INSERT INTO spav1602p_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Y murió Sara en Quiriat-arba, que es Hebrón, en la tierra de Canaán: y vino Abraham a hacer el duelo a Sara, y a llorarla. ");
INSERT INTO spav1602p_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Y levantóse Abraham de delan­te de su muerta, y habló a los hijos de Het, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Peregrino y advenedizo soy entre vosotros; dadme heredad de sepultura con vosotros, y sepultaré mi muerta de delante de mí. ");
INSERT INTO spav1602p_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Y respondieron los hijos de Het a Abraham, y dijéronle: ");
INSERT INTO spav1602p_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","Óyenos, señor mío, eres un príncipe de Dios entre nosotros; en lo mejor de nuestras sepultu­ras sepulta a tu muerta; ninguno de nosotros te impedirá su sepul­tura, para que entierres tu muerta. ");
INSERT INTO spav1602p_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Y Abraham se levantó, e incli­nóse al pueblo de aquella tierra, aun a los hijos de Het; ");
INSERT INTO spav1602p_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Y habló con ellos, diciendo: Si tenéis voluntad que yo sepulte mi muerta de delante de mí, oidme, e interceded por mí con Efrón, hijo de Zohar, ");
INSERT INTO spav1602p_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Para que me dé la cueva de Macpela, que él tiene, que está al cabo de su heredad: que por su justo precio me la dé, para posesión de sepul­tura en medio de vosotros. ");
INSERT INTO spav1602p_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Y Efrón habitaba entre los hijos de Het; y respondió Efrón el heteo a Abraham en la audiencia de los hijos de Het, aun de todos los que entraban a la puerta de la ciudad, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","No, señor mío, óyeme: te doy la heredad, y te doy también la cueva que está en ella; delante de los hijos de mi pueblo te la doy; sepulta tu muerta. ");
INSERT INTO spav1602p_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Y Abraham se inclinó delante del pueblo de la tierra, ");
INSERT INTO spav1602p_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Y habló a Efrón en oídos del pueblo de la tierra, diciendo: Pero si tú lo dieres, te ruego que me oigas: Yo te daré el precio del campo, tómalo de mí, y sepultaré allí mi muer­ta. ");
INSERT INTO spav1602p_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Y respondió Efrón a Abraham, diciéndole: ");
INSERT INTO spav1602p_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","Señor mío, escúchame: la tie­rra vale cuatrocientos siclos de plata; ¿qué es esto entre mí y ti? entierra pues tu muerta. ");
INSERT INTO spav1602p_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Entonces Abraham se convi­no con Efrón, y pesó Abraham a Efrón el dinero que dijo, oyéndolo los hijos de Het, cua­trocientos siclos de plata, corriente entre mercaderes. ");
INSERT INTO spav1602p_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Y la heredad de Efrón, que estaba en Macpela, que estaba enfrente de Mamre, la heredad, y la cueva, que estaba en ella, y todos los árboles que estaban en la heredad, que estaba en todo su término alrededor, quedaron asegurados, ");
INSERT INTO spav1602p_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Por de Abraham en posesión, a vista de los hijos de Het, y de todos los que entraban por la puerta de la ciudad. ");
INSERT INTO spav1602p_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Y después de esto sepultó Abraham a Sara su esposa en la cueva de la heredad de Macpela enfrente de Mamre, que es Hebrón en la tierra de Canaán. ");
INSERT INTO spav1602p_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Y el campo, y la cueva que en él había, fueron confirmados a Abraham, en posesión de sepul­tura por los hijos de Het. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Y ABRAHAM era viejo, y bien entrado en días; y el SEÑOR había bendecido a Abraham en todo. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Y dijo Abraham a un criado suyo, el más viejo de su casa, que era el que gobernaba en todo lo que tenía: Pon ahora tu mano debajo de mi muslo, ");
INSERT INTO spav1602p_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Y te juramentaré por el SEÑOR, Dios del cielo y Dios de la tierra, que no has de tomar esposa para mi hijo de las hijas de los cananeos, entre los cuales yo habito; ");
INSERT INTO spav1602p_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Sino que irás a mi tierra y a mi parentela, y tomarás esposa para mi hijo Isaac. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Y el criado le respondió: Quizá la mujer no querrá venir en pos de mí a esta tierra: ¿volveré, pues, tu hijo a la tierra de donde saliste? ");
INSERT INTO spav1602p_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Y Abraham le dijo: Guárdate que no vuelvas a mi hijo allá. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","El SEÑOR, Dios del cielo, que me tomó de la casa de mi padre y de la tierra de mi paren­tela, y me habló y me juró, diciendo: A tu simiente daré esta tierra; él enviará su ángel delante de ti, y tú tomarás de allá esposa para mi hijo. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Y si la mujer no quisiere venir en pos de ti, serás libre de este mi juramento; solamente que no vuelvas allá a mi hijo. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Entonces el criado puso su mano debajo del muslo de Abraham su señor, y juróle sobre este negocio. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Y el criado tomó diez came­llos de los camellos de su señor, y fuése, pues todos los bienes de su señor estaban en su mano: y puesto en camino, llegó a Mesopotamia, a la ciudad de Nacor. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","E hizo arrodillar los camellos fuera de la ciudad, junto a un pozo de agua, a la hora de la tarde, aún la hora en que salen las mozas por agua. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Y dijo: Oh SEÑOR, Dios de mi amo Abraham, dame, te ruego, el tener hoy buen encuentro, y haz misericordia con mi amo Abraham. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","He aquí yo estoy junto a la fuente de agua, y las hijas de los varones de esta ciudad salen por agua: ");
INSERT INTO spav1602p_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Sea, pues, que la moza a quien yo dijere: Baja tu cántaro, te ruego, para que yo beba; y ella respondiere: Bebe, y también daré de beber a tus camellos: que sea ésta la que tú has destinado para tu siervo Isaac; y en esto conoceré que habrás hecho mise­ricordia con mi amo. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Y aconteció que antes que él acabase de hablar, he aquí Rebeca, que había nacido a Betuel, hijo de Milca, esposa de Nacor hermano de Abraham, la cual salía con su cántaro sobre su hombro. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Y la moza era de muy hermo­so aspecto, virgen, a la que varón no había conocido; la cual des­cendió a la fuente, y llenó su cán­taro, y se volvía. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Entonces el criado corrió hacia ella, y dijo: Ruégote que me des a beber un poco de agua de tu cántaro. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Y ella respondió: Bebe, señor mío: y dióse prisa a bajar su cán­taro sobre su mano, y le dio a beber. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Y cuando acabó de darle a beber, dijo: También para tus camellos sacaré agua, hasta que acaben de beber. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Y dióse prisa, y vació su cán­taro en la pila, y corrió otra vez al pozo para sacar agua, y sacó para todos sus camellos. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Y el hombre estaba maravilla­do de ella, callando, para saber si el SEÑOR había prosperado o no su viaje. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Y sucedió que como los camellos acabaron de beber, presentóle el hombre un pendiente de oro que pesaba medio siclo, y dos braza­letes para sus manos que pesaban diez siclos de oro; ");
INSERT INTO spav1602p_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Y dijo: ¿De quién eres hija? Ruégote me digas, ¿hay lugar en casa de tu padre donde posemos? ");
INSERT INTO spav1602p_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Y ella respondió: Soy hija de Betuel, hijo de Milca, el cual parió ella a Nacor. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Y añadió: También hay en nuestra casa paja y mucho forraje, y lugar para posar. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","El hombre entonces se incli­nó, y adoró al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Y dijo: Bendito sea el SEÑOR Dios de mi amo Abraham, que no apartó de mi amo su misericordia y su verdad: Estando yo en el camino, el SEÑOR me guió a casa de los hermanos de mi señor. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Y la moza corrió, e hizo saber en casa de su madre estas cosas. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Y Rebeca tenía un hermano cuyo nombre era Labán: y Labán corrió afuera al hombre, hasta la fuente. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Y sucedió, cuando vio el pendiente y los brazaletes en las manos de su hermana, y cuando oyó las palabras de su hermana Rebeca, diciendo, Así me habló aquel hombre; que vino a él: y he aquí, él estaba junto a los camellos a la fuente. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Y díjole: Ven, bendito del SEÑOR; ¿por qué estás fuera? yo he limpiado la casa, y el lugar para los camellos. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Entonces el hombre vino a casa: y él desató los camellos, y dióles paja y forraje, y agua para lavar los pies de él, y los pies de los hombres que estaban con él. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Y pusiéronle delante qué comer; mas él dijo: No comeré hasta que haya dicho mi mensa­je. Y él le dijo: Habla. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Entonces dijo: Yo soy criado de Abraham; ");
INSERT INTO spav1602p_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Y el SEÑOR ha bendecido mucho a mi señor, y él se ha engrandecido: y le ha dado ove­jas y vacas, plata y oro, siervos y siervas, camellos y asnos. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Y Sara, esposa de mi señor, parió en su vejez un hijo a mi señor, quien le ha dado todo cuanto tiene. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Y mi señor me hizo jurar, diciendo: No tomarás esposa para mi hijo de las hijas de los cananeos, en cuya tierra habito; ");
INSERT INTO spav1602p_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Sino que irás a la casa de mi padre, y a mi parentela, y toma­rás esposa para mi hijo. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Y yo dije a mi señor: Quizás la mujer no querrá seguirme. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Entonces él me respondió: El SEÑOR, en cuya presencia he andado, enviará su ángel conti­go, y prosperará tu camino; y tomarás esposa para mi hijo de mi linaje y de la casa de mi padre: ");
INSERT INTO spav1602p_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Entonces serás libre de mi juramento, cuando hubieres lle­gado a mi linaje; y si no te la die­ren, serás libre de mi juramento. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Llegué, pues, hoy a la fuente, y dije: Oh SEÑOR, Dios de mi amo Abraham, si tú prosperas ahora mi camino por el cual ando; ");
INSERT INTO spav1602p_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","He aquí yo estoy junto a la fuente de agua; sea, pues, que la virgen que saliere por agua, a la cual dijere: Dame a beber, te ruego, un poco de agua de tu cántaro; ");
INSERT INTO spav1602p_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Y ella me respondiere: Bebe tú, y también para tus camellos sacaré agua; ésta sea la mujer que destinó el SEÑOR para el hijo de mi señor. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Y antes que acabase de hablar en mi corazón, he aquí Rebeca, que salía con su cántaro sobre su hombro; y descendió a la fuente, y sacó agua; y le dije: Ruégote que me des a beber. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Y prestamente bajó su cántaro de su hombro, y dijo: Bebe, y también a tus camellos daré a beber. Y bebí, y dio también de beber a mis camellos. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Entonces preguntéle, y dije: ¿De quién eres hija? Y ella res­pondió: Hija de Betuel, hijo de Nacor, que le parió Milca. Entonces púsele un pendiente sobre su frente, y brazaletes sobre sus manos: ");
INSERT INTO spav1602p_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","E inclinéme, y adoré al SEÑOR, y bendije al SEÑOR, Dios de mi señor Abraham, que me había guiado por camino de verdad para tomar la hija del her­mano de mi señor para su hijo. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ahora pues, si vosotros hacéis misericordia y verdad con mi señor, declarádmelo; y si no, declarádmelo; y echaré a la dies­tra o a la siniestra. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Entonces Labán y Betuel respondieron y dijeron: Del SEÑOR ha salido esto; no pode­mos hablarte malo ni bueno. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","He aquí, Rebeca está delante de ti; tómala y vete, y sea esposa del hijo de tu señor, como lo ha dicho el SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Y sucedió, que como el criado de Abraham oyó sus palabras, inclinóse a tierra, y adoró al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Y sacó el criado vasos de plata, y vasos de oro y vestiduras, y los dio a Rebeca: también dio cosas preciosas a su hermano y a su madre. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Y ellos comieron y bebieron, él y los hombres que estaban con él, y pasaron toda la noche; y se levantaron en la mañana, y él dijo: Enviadme a mi señor. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Entonces respondió su her­mano y su madre: Espere la moza con nosotros a lo menos diez días, y después irá. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Y él les dijo: No me deten­gáis, pues que el SEÑOR ha prosperado mi camino; despa­chadme para que me vaya a mi señor. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ellos respondieron entonces: Llamemos la moza e inquirámosle. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Y llamaron a Rebeca, y dijé­ronle: ¿Irás tú con este varón? Y ella respondió: Sí, iré. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Entonces dejaron ir a Rebeca su hermana, y a su nodriza, y al criado de Abraham y a sus hom­bres. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Y bendijeron a Rebeca, y dijé­ronle: Nuestra hermana eres; seas madre de millares de millares, y tu generación posea la puerta de sus enemigos. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Levantóse entonces Rebeca y sus mozas, y subieron sobre los camellos, y siguieron al hombre: y el criado tomó a Rebeca, y fuese. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Y venía Isaac del pozo Beer-lajai-roi; porque él habitaba en la tierra del sur; ");
INSERT INTO spav1602p_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Y había salido Isaac a meditar en el campo, a la hora de la tarde; y alzando sus ojos miró, y he aquí los camellos que venían. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeca también alzó sus ojos, y vio a Isaac, y descendió del camello; ");
INSERT INTO spav1602p_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Porque había preguntado al criado: ¿Quién es este varón que viene por el campo hacia noso­tros? Y el siervo había respondi­do: Éste es mi señor. Ella enton­ces tomó el velo, y cubrióse. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Entonces el criado contó a Isaac todo lo que había hecho. ");
INSERT INTO spav1602p_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","E introdújola Isaac a la tienda de su madre Sara, y tomó a Rebeca por esposa; y amóla: y consolóse Isaac después de la muerte de su madre. ");
INSERT INTO spav1602p_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Y ABRAHAM tomó una esposa, cuyo nombre era Cetura; ");
INSERT INTO spav1602p_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","La cual le parió a Zimram, y a Joksan, y a Medan, y a Midiam, y a Isbak, y a Sua. ");
INSERT INTO spav1602p_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Y Joksan engendró a Seba, y a Dedán: e hijos de Dedán fueron Asurim, y Letusim, y Leumim. ");
INSERT INTO spav1602p_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","E hijos de Midiam: Efa, y Efer, y Hanoc, y Abida, y Eldaa. Todos estos fueron hijos de Cetura. ");
INSERT INTO spav1602p_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Y Abraham dio todo cuanto tenía a Isaac. ");
INSERT INTO spav1602p_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Pero a los hijos de las concubinas que Abraham tenía, dio Abraham dones, y los envió lejos de Isaac su hijo, mientras él vivía, hacia el oriente, a la tierra oriental. ");
INSERT INTO spav1602p_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Y éstos fueron los días de vida que vivió Abraham: ciento setenta y cinco años. ");
INSERT INTO spav1602p_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Y exhaló el espíritu, y murió Abraham en buena vejez, ancia­no y lleno de días, y fue unido a su pueblo. ");
INSERT INTO spav1602p_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Y sepultáronlo Isaac e Ismael sus hijos en la cueva de Macpela, en la heredad de Efrón, hijo de Zoar heteo, que está enfrente de Mamre; ");
INSERT INTO spav1602p_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Heredad que compró Abraham de los hijos de Het: allí fue Abraham sepultado, y Sara su esposa. ");
INSERT INTO spav1602p_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Y sucedió después de la muerte de Abraham, que Dios bendijo a Isaac su hijo: y habitó Isaac junto al pozo Beer-lajai-roi. ");
INSERT INTO spav1602p_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Y éstas son las generaciones de Ismael, hijo de Abraham, que le parió Agar egipcia, sierva de Sara: ");
INSERT INTO spav1602p_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Éstos, pues, son los nombres de los hijos de Ismael, por sus nombres, por sus generaciones: El primogénito de Ismael, Nabaiot; y Cedar, y Adbeel, y Mibsam, ");
INSERT INTO spav1602p_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Y Misma, y Duma, y Massa, ");
INSERT INTO spav1602p_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadar, y Tema, y Jetur, y Nafis, y Cedema. ");
INSERT INTO spav1602p_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Éstos son los hijos de Ismael, y estos son sus nombres, por sus villas y por sus campamentos; doce príncipes por sus familias. ");
INSERT INTO spav1602p_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Y estos fueron los años de la vida de Ismael, ciento treinta y siete años: y exhaló el espíritu Ismael, y murió; y fue unido a su pueblo. ");
INSERT INTO spav1602p_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Y habitaron desde Havila hasta Shur, que está enfrente de Egipto viniendo a Asiria; y murió en presencia de todos sus hermanos. ");
INSERT INTO spav1602p_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Y éstas son las generaciones de Isaac, hijo de Abraham. Abraham engendró a Isaac: ");
INSERT INTO spav1602p_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Y era Isaac de cuarenta años cuando tomó por esposa a Rebeca, hija de Betuel arameo de Padan-­aram, hermana de Labán arameo. ");
INSERT INTO spav1602p_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Y oró Isaac al SEÑOR por su esposa, que era estéril; y aceptólo el SEÑOR, y concibió Rebeca su esposa. ");
INSERT INTO spav1602p_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Y los hijos se combatían den­tro de ella; y dijo: Si es así ¿por qué estoy así? Y fue a inquirir del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Y respondióle el SEÑOR: Dos naciones hay en tu seno, y dos pueblos serán divididos desde tus entrañas: y el un pueblo será más fuerte que el otro pueblo, y el mayor servirá al menor. ");
INSERT INTO spav1602p_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Y como se cumplieron sus días para parir, he aquí habían mellizos en su vientre. ");
INSERT INTO spav1602p_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Y salió el primero rubio, y todo él velludo como una pelliza; y llamaron su nombre Esaú. ");
INSERT INTO spav1602p_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Y después salió su hermano, trabada su mano al calcañar de Esaú: y fue llamado su nombre Jacob. Y era Isaac de edad de sesenta años cuando ella los parió. ");
INSERT INTO spav1602p_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Y crecieron los niños, y Esaú fue diestro en la caza, hombre del campo: y Jacob era varón quieto, que habitaba en tiendas. ");
INSERT INTO spav1602p_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Y amó Isaac a Esaú, porque comía de su caza; mas Rebeca amaba a Jacob. ");
INSERT INTO spav1602p_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Y guisó Jacob un potaje; y vino Esaú del campo, y estaba él cansado; ");
INSERT INTO spav1602p_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Y dijo Esaú a Jacob: Te ruego que me des a comer de ese potaje rojo, pues estoy muy cansado. Por tanto fue llamado su nombre Edom. ");
INSERT INTO spav1602p_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Y Jacob respondió: Véndeme en este día tu primogenitura. ");
INSERT INTO spav1602p_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Entonces dijo Esaú: He aquí, yo estoy al punto de morir; ¿para qué me servirá la primogenitura? ");
INSERT INTO spav1602p_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Y dijo Jacob: Júramelo en este día. Y él le juró, y vendió a Jacob su primogenitura. ");
INSERT INTO spav1602p_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Entonces Jacob dio a Esaú pan y del guisado de las lentejas; y él comió y bebió, y levantóse, y fuese. Así menospreció Esaú su primogenitura. ");
INSERT INTO spav1602p_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Y HUBO hambre en la tierra, además de la primera hambre que fue en los días de Abraham: y fuese Isaac a Abimelec rey de los filisteos, en Gerar. ");
INSERT INTO spav1602p_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Y apareciósele el SEÑOR, y díjole: No desciendas a Egipto: habita en la tierra que yo te diré; ");
INSERT INTO spav1602p_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Habita en esta tierra, y seré contigo, y te bendeciré; porque a ti y a tu simiente daré todas estas tierras, y confirmaré el juramen­to que juré a Abraham tu padre: ");
INSERT INTO spav1602p_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Y multiplicaré tu simiente como las estrellas del cielo, y daré a tu simiente todas estas tierras; y todas las naciones de la tierra serán benditas en tu simiente: ");
INSERT INTO spav1602p_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Por cuanto obedeció Abraham mi voz, y guardó mi precepto, mis mandamientos, mis estatutos y mis leyes. ");
INSERT INTO spav1602p_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Habitó, pues, Isaac en Gerar. ");
INSERT INTO spav1602p_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Y los hombres de aquel lugar le preguntaron acerca de su esposa; y él respondió: Es mi hermana; porque tuvo miedo de decir: Es mi esposa que tal vez, dijo, los hombres del lugar me matarían por causa de Rebeca; porque era de hermoso aspecto. ");
INSERT INTO spav1602p_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Y sucedió que, después que él estuvo allí muchos días, Abimelec, rey de los filisteos, mirando por una ventana, vio a Isaac que jugaba con Rebeca su esposa. ");
INSERT INTO spav1602p_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Y llamó Abimelec a Isaac, y dijo: He aquí ella es de cierto tu esposa: ¿cómo, pues, dijiste: Es mi hermana? E Isaac le respon­dió: Porque dije: Quizá moriré por causa de ella. ");
INSERT INTO spav1602p_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Y Abimelec dijo: ¿Por qué nos has hecho esto? Por poco hubiera dormido alguno del pue­blo con tu esposa, y hubieras traí­do sobre nosotros el pecado. ");
INSERT INTO spav1602p_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Entonces Abimelec mandó a todo su pueblo, diciendo: El que tocare a este hombre o a su esposa, de cierto morirá. ");
INSERT INTO spav1602p_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Y sembró Isaac en aquella tie­rra, y halló aquel año ciento por uno: y bendíjole el SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Y el varón se engrandeció, y fue adelantando y engrandeciéndose, hasta hacerse muy podero­so: ");
INSERT INTO spav1602p_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Y tuvo hato de ovejas, y hato de vacas, y grande abundancia de siervos; y los filisteos le tuvieron envidia. ");
INSERT INTO spav1602p_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Y todos los pozos que habían abierto los criados de Abraham su padre en sus días, los filisteos los habían cegado y llenado de tierra. ");
INSERT INTO spav1602p_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Y dijo Abimelec a Isaac: Apártate de nosotros, porque mucho más poderoso que noso­tros te has hecho. ");
INSERT INTO spav1602p_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","E Isaac se fue de allí; y asen­tó sus tiendas en el valle de Gerar, y habitó allí. ");
INSERT INTO spav1602p_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Y volvió a abrir Isaac los pozos de agua que habían abier­to en los días de Abraham su padre, y que los filisteos habían cegado, muerto Abraham; y lla­mólos por los nombres que su padre los había llamado. ");
INSERT INTO spav1602p_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Y los siervos de Isaac cavaron en el valle, y hallaron allí un pozo de aguas vivas. ");
INSERT INTO spav1602p_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Y los pastores de Gerar riñe­ron con los pastores de Isaac, diciendo: El agua es nuestra: por eso llamó el nombre del pozo Esek, porque habían altercado con él. ");
INSERT INTO spav1602p_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Y abrieron otro pozo, y tam­bién riñeron sobre él: y llamó su nombre Sitnah. ");
INSERT INTO spav1602p_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Y apartóse de allí, y abrió otro pozo, y no riñeron sobre él: y llamó su nombre Rehobot, y dijo: Porque ahora nos ha hecho ensanchar el SEÑOR, y fructificaremos en la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Y de allí subió a Beerseba. ");
INSERT INTO spav1602p_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Y apareciósele el SEÑOR aquella noche, y dijo: Yo soy el Dios de Abraham tu padre; no temas, que yo soy contigo, y yo te bendeciré, y multiplicaré tu simiente por amor de Abraham mi siervo. ");
INSERT INTO spav1602p_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Y edificó allí un altar, e invo­có el nombre del SEÑOR, y ten­dió allí su tienda: y abrieron allí los siervos de Isaac un pozo. ");
INSERT INTO spav1602p_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Y Abimelec vino a él desde Gerar, y Ahuzat, amigo suyo, y Ficol, capitán de su ejército. ");
INSERT INTO spav1602p_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Y díjoles Isaac: ¿Por qué venís a mí, pues que me habéis aborrecido, y me echasteis de entre vosotros? ");
INSERT INTO spav1602p_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Y ellos respondieron: Hemos visto que el SEÑOR es contigo; y dijimos: Haya ahora juramento entre nosotros, aún entre nosotros y ti, y haremos pacto contigo: ");
INSERT INTO spav1602p_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Que no nos hagas mal, como nosotros no te hemos tocado, y como solamente te hemos hecho bien, y te enviamos en paz: tú eres ahora, bendito del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Entonces él les hizo banquete, y comieron y bebieron. ");
INSERT INTO spav1602p_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Y se levantaron de madruga­da, y juraron el uno al otro; e Isaac los despidió, y ellos se par­tieron de él en paz. ");
INSERT INTO spav1602p_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Y en aquel día sucedió que vinieron los criados de Isaac, y diéronle nuevas acerca del pozo que habían abierto, y le dijeron: Agua hemos hallado. ");
INSERT INTO spav1602p_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Y llamólo Seba: por cuya causa el nombre de aquella ciu­dad es Beerseba hasta este día. ");
INSERT INTO spav1602p_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Y cuando Esaú fue de cuaren­ta años, tomó por esposa a Judit hija de Beeri heteo, y a Basemat hija de Elón heteo: ");
INSERT INTO spav1602p_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Y fueron amargura de espíritu a Isaac y a Rebeca. ");
INSERT INTO spav1602p_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Y ACONTECIÓ que cuando hubo Isaac envejecido, y sus ojos se ofuscaron quedando sin vista, llamó a Esaú, su hijo el mayor, y díjole: Mi hijo. Y él respondió: Heme aquí. ");
INSERT INTO spav1602p_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Y él dijo: He aquí ya soy viejo, no sé el día de mi muerte: ");
INSERT INTO spav1602p_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Toma, pues, ahora tus armas, tu aljaba y tu arco, y sal al campo, y cógeme alguna caza; ");
INSERT INTO spav1602p_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Y hazme un guisado, como yo gusto, y tráemelo, y comeré; para que te bendiga mi alma antes que muera. ");
INSERT INTO spav1602p_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Y Rebeca estaba oyendo, cuan­do hablaba Isaac a Esaú su hijo: y fuese Esaú al campo para coger la caza que había de traer. ");
INSERT INTO spav1602p_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Entonces Rebeca habló a Jacob su hijo, diciendo: He aquí yo he oído a tu padre que hablaba con Esaú tu hermano, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Tráeme caza, y hazme un gui­sado, para que coma, y te bendi­ga delante del SEÑOR antes que yo muera. ");
INSERT INTO spav1602p_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Ahora pues, hijo mío, obedece a mi voz en lo que te mando; ");
INSERT INTO spav1602p_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Ve ahora al ganado, y tráeme de allí dos buenos cabritos de las cabras, y haré de ellos viandas para tu padre, como él gusta; ");
INSERT INTO spav1602p_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Y tú las llevarás a tu padre, y comerá, para que te bendiga antes de su muerte. ");
INSERT INTO spav1602p_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Y Jacob dijo a Rebeca su madre: He aquí, Esaú mi hermano es hombre velloso, y yo lampiño: ");
INSERT INTO spav1602p_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Quizá me tentará mi padre, y me tendrá por burlador, y traeré sobre mí maldición y no bendi­ción. ");
INSERT INTO spav1602p_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Y su madre respondió: Hijo mío, sobre mí sea tu maldición: sola­mente obedece a mi voz, y ve y tráemelos. ");
INSERT INTO spav1602p_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Entonces él fue, y tomó, y trá­jolos a su madre: y su madre hizo guisados, como su padre gusta­ba. ");
INSERT INTO spav1602p_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Y tomó Rebeca las vestiduras de Esaú su hijo mayor, las pre­ciosas, que ella tenía en casa, y vistió a Jacob su hijo menor: ");
INSERT INTO spav1602p_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","E hízole vestir sobre sus manos, y sobre la cerviz donde no tenía vello, las pieles de los cabritos de las cabras; ");
INSERT INTO spav1602p_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Y entregó los guisados y el pan que había aderezado, en mano de Jacob su hijo. ");
INSERT INTO spav1602p_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Y él fue a su padre, y dijo: Padre mío: y él respondió: Heme aquí, ¿quién eres, hijo mío? ");
INSERT INTO spav1602p_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Y Jacob dijo a su padre: Yo soy Esaú tu primogénito; he hecho como me dijiste: levántate ahora, y siéntate, y come de mi caza, para que me bendiga tu alma. ");
INSERT INTO spav1602p_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Entonces Isaac dijo a su hijo: ¿Cómo es que la hallaste tan presto, hijo mío? Y él respondió: Porque el SEÑOR tu Dios hizo que se encontrase delante de mí. ");
INSERT INTO spav1602p_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","E Isaac dijo a Jacob: Acércate ahora, y te palparé, hijo mío, por si eres mi hijo Esaú, o no. ");
INSERT INTO spav1602p_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Y llegóse Jacob a su padre Isaac; y él le palpó, y dijo: La voz es la voz de Jacob, mas las manos, las manos de Esaú. ");
INSERT INTO spav1602p_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Y no le conoció, porque sus manos eran vellosas como las manos de Esaú: y le bendijo. ");
INSERT INTO spav1602p_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Y dijo: ¿Eres tú mi hijo Esaú? Y él respondió: Yo soy. ");
INSERT INTO spav1602p_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Y dijo: Acércamela, y comeré de la caza de mi hijo, para que te bendiga mi alma; y él se la acer­có, y comió: trájole también vino, y bebió. ");
INSERT INTO spav1602p_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Y díjole Isaac su padre: Acércate ahora, y bésame, hijo mío. ");
INSERT INTO spav1602p_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Y él se llegó, y le besó; y olió Isaac el olor de sus vestiduras, y le bendijo, y dijo: Mira, el olor de mi hijo es como el olor del campo que el SEÑOR ha bendecido: ");
INSERT INTO spav1602p_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Dios, pues, te dé del rocío del cielo, y de las grosuras de la tie­rra, y abundancia de trigo y de mosto. ");
INSERT INTO spav1602p_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Sírvante pueblos, y naciones se inclinen a ti: sé señor de tus hermanos, e inclínense a ti los hijos de tu madre: malditos los que te maldijeren, y benditos los que te bendijeren. ");
INSERT INTO spav1602p_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Y aconteció, luego que hubo Isaac acabado de bendecir a Jacob, y apenas había salido Jacob de delante de Isaac su padre, que Esaú su hermano vino de su caza. ");
INSERT INTO spav1602p_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","E hizo él también guisados, y trajo a su padre, y díjole: Levántese mi padre, y coma de la caza de su hijo, para que me ben­diga tu alma. ");
INSERT INTO spav1602p_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Entonces Isaac su padre le dijo: ¿Quién eres tú? Y él dijo: Yo soy tu hijo, tu primogénito, Esaú. ");
INSERT INTO spav1602p_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Y estremecióse Isaac con grande estremecimiento, y dijo: ¿Quién es el que vino aquí, que cogió caza, y me trajo, y comí de todo antes que vinieses? Yo le bendije, y será bendito. ");
INSERT INTO spav1602p_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Como Esaú oyó las palabras de su padre, clamó con una muy grande y muy amarga exclama­ción, y le dijo: Bendíceme tam­bién a mí, padre mío. ");
INSERT INTO spav1602p_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Y él dijo: Vino tu hermano con engaño, y tomó tu bendición. ");
INSERT INTO spav1602p_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Y él respondió: Bien llamaron su nombre Jacob, que ya me ha engañado dos veces; alzóse con mi primogenitura, y he aquí ahora ha tomado mi bendición. Y dijo: ¿No has guardado bendi­ción para mí? ");
INSERT INTO spav1602p_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaac respondió y dijo a Esaú: He aquí yo le he puesto por señor tuyo, y le he dado por siervos a todos sus hermanos: de trigo y de vino le he provisto; ¿qué, pues, te haré a ti ahora, hijo mío? ");
INSERT INTO spav1602p_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Y Esaú respondió a su padre: ¿No tienes más que una sola ben­dición, padre mío? bendíceme también a mí, padre mío. Y alzó Esaú su voz, y lloró. ");
INSERT INTO spav1602p_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Entonces Isaac su padre habló y díjole: He aquí será tu habita­ción en grosuras de la tierra, y del rocío del cielo de arriba; ");
INSERT INTO spav1602p_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Y por tu espada vivirás, y a tu hermano servirás: y sucederá cuando te enseñorees, que des­cargarás su yugo de tu cerviz. ");
INSERT INTO spav1602p_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Y aborreció Esaú a Jacob por la bendición con que le había bendecido, y dijo en su corazón: Llegarán los días del luto de mi padre, y yo mataré a Jacob mi hermano. ");
INSERT INTO spav1602p_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Y fueron dichas a Rebeca las palabras de Esaú su hijo mayor: y ella envió y llamó a Jacob su hijo menor, y díjole: He aquí, Esaú tu hermano se consuela acerca de ti con la idea de matar­te. ");
INSERT INTO spav1602p_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Ahora pues, hijo mío, obede­ce a mi voz; levántate, y húyete a Labán mi hermano, a Harán; ");
INSERT INTO spav1602p_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Y mora con él algunos días, hasta que el enojo de tu hermano se mitigue; ");
INSERT INTO spav1602p_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Hasta que se aplaque la ira de tu hermano contra ti, y se olvide de lo que le has hecho; yo envia­ré entonces, y te traeré de allá: ¿por qué seré privada de voso­tros ambos en un día? ");
INSERT INTO spav1602p_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Y dijo Rebeca a Isaac: Fastidio tengo de mi vida, a causa de las hijas de Het. Si Jacob toma esposa de las hijas de Het, como éstas, de las hijas de esta tierra, ¿para qué quiero la vida? ");
INSERT INTO spav1602p_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","ENTONCES Isaac llamó a Jacob, y bendíjolo, y mandóle diciendo: No tomes esposa de las hijas de Canaán. ");
INSERT INTO spav1602p_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Levántate, ve a Padan-aram, a casa de Betuel, padre de tu madre, y toma allí esposa de las hijas de Labán, hermano de tu madre. ");
INSERT INTO spav1602p_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Y el Dios Todopoderoso te bendiga, y te haga fructificar, y te multiplique, hasta venir a ser congregación de pueblos; ");
INSERT INTO spav1602p_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Y te dé la bendición de Abraham, y a tu simiente conti­go, para que heredes la tierra de tus peregrinaciones, que Dios dio a Abraham. ");
INSERT INTO spav1602p_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Así envió Isaac a Jacob, el cual fue a Padan-aram, a Labán, hijo de Betuel arameo, hermano de Rebeca, madre de Jacob y de Esaú. ");
INSERT INTO spav1602p_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Y vio Esaú cómo Isaac había bendecido a Jacob, y le había enviado a Padan-aram, para tomar para si esposa de allí; y que cuando le bendijo, le había man­dado, diciendo: No tomarás esposa de las hijas de Canaán; ");
INSERT INTO spav1602p_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Y que Jacob había obedecido a su padre y a su madre, y se había ido a Padan-aram. ");
INSERT INTO spav1602p_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Vio asimismo Esaú que las hijas de Canaán parecían mal a Isaac su padre; ");
INSERT INTO spav1602p_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Y fuese Esaú a Ismael, y tomó para si por esposa a Mahalet, hija de Ismael, hijo de Abraham, hermana de Nabaiot, además de sus otras esposas. ");
INSERT INTO spav1602p_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Y salió Jacob de Beerseba, y fue a Harán; ");
INSERT INTO spav1602p_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Y encontró con un lugar, y durmió allí, porque ya el sol se había puesto: y tomó de las pie­dras de aquel paraje y las puso a su cabecera, y acostóse en aquel lugar. ");
INSERT INTO spav1602p_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Y soñó, y he aquí una escala que estaba apoyada en tierra, y su cabeza tocaba en el cielo: y he aquí ángeles de Dios que subían y descendían por ella. ");
INSERT INTO spav1602p_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Y he aquí, el SEÑOR estaba en lo alto de ella, el cual dijo: Yo soy el SEÑOR, el Dios de Abraham tu padre, y el Dios de Isaac: la tierra en que estás acos­tado te la daré a ti y a tu simien­te. ");
INSERT INTO spav1602p_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Y será tu simiente como el polvo de la tierra, y te extenderás al occidente, y al oriente, y al norte, y al sur; y todas las familias de la tierra serán ben­ditas en ti y en tu simiente. ");
INSERT INTO spav1602p_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Y he aquí, Yo soy contigo, y te guardaré por donde quiera que fueres, y te volveré a esta tie­rra; porque no te dejaré hasta tanto que haya hecho lo que te he dicho. ");
INSERT INTO spav1602p_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Y despertó Jacob de su sueño, y dijo: Ciertamente el SEÑOR está en este lugar, y yo no lo sabía. ");
INSERT INTO spav1602p_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Y tuvo miedo, y dijo: ¡Cuán terrible es este lugar! No es otra cosa que casa de Dios, y puerta del cielo. ");
INSERT INTO spav1602p_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Y levantóse Jacob de mañana, y tomó la piedra que había pues­to de cabecera, y alzóla por títu­lo, y derramó aceite encima de ella. ");
INSERT INTO spav1602p_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Y llamó el nombre de aquel lugar Betel, bien que Luz era el nombre de la ciudad primero. ");
INSERT INTO spav1602p_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","E hizo Jacob voto, diciendo: Si fuere Dios conmigo, y me guardare en este viaje que voy, y me diere pan para comer y vestidura para vestir, ");
INSERT INTO spav1602p_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","Y si tornare en paz a casa de mi padre, el SEÑOR será mi Dios, ");
INSERT INTO spav1602p_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Y esta piedra que he puesto por título, será casa de Dios: y de todo lo que me dieres, el diezmo lo he de apartar para ti. ");
INSERT INTO spav1602p_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Y SIGUIÓ Jacob su camino, y fue a la tierra de los orientales. ");
INSERT INTO spav1602p_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Y miró, y vio un pozo en el campo: y he aquí tres rebaños de ovejas que yacían cerca de él; porque de aquel pozo abrevaban los ganados: y había una gran piedra sobre la boca del pozo. ");
INSERT INTO spav1602p_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Y juntábanse allí todos los rebaños; y revolvían la piedra de sobre la boca del pozo, y abreva­ban las ovejas; y volvían la pie­dra sobre la boca del pozo a su lugar. ");
INSERT INTO spav1602p_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Y díjoles Jacob: Hermanos míos, ¿de dónde sois? Y ellos respondieron: De Harán somos. ");
INSERT INTO spav1602p_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Y él les dijo: ¿Conocéis a Labán, hijo de Nacor? Y ellos dijeron: Sí, le conocemos. ");
INSERT INTO spav1602p_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Y él les dijo: ¿Tiene paz? Y ellos dijeron: Paz; y he aquí Raquel su hija viene con el gana­do. ");
INSERT INTO spav1602p_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Y él dijo: He aquí el día es aún grande; no es tiempo todavía de recoger el ganado; abrevad las ovejas, e id a apacentarlas. ");
INSERT INTO spav1602p_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Y ellos respondieron: No pode­mos, hasta que se junten todos los ganados, y remuevan la pie­dra de sobre la boca del pozo, para que abrevemos las ovejas. ");
INSERT INTO spav1602p_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Estando aún él hablando con ellos, Raquel vino con el ganado de su padre, porque ella era la pastora. ");
INSERT INTO spav1602p_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Y sucedió que, como Jacob vio a Raquel, hija de Labán her­mano de su madre, y a las ovejas de Labán el hermano de su madre, llegóse Jacob, y removió la piedra de sobre la boca del pozo, y abrevó el ganado de Labán hermano de su madre. ");
INSERT INTO spav1602p_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Y Jacob besó a Raquel, y alzó su voz, y lloró. ");
INSERT INTO spav1602p_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Y Jacob dijo a Raquel como él era hermano de su padre, y como era hijo de Rebeca: y ella corrió, y dio las nuevas a su padre. ");
INSERT INTO spav1602p_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Y así que oyó Labán las nue­vas de Jacob, hijo de su hermana, corrió a recibirlo, y abrazólo, y besólo, y trájole a su casa: y él contó a Labán todas estas cosas. ");
INSERT INTO spav1602p_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Y Labán le dijo: Ciertamente hueso mío y carne mía eres. Y estuvo con él el tiempo de un mes. ");
INSERT INTO spav1602p_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Entonces dijo Labán a Jacob: ¿Por ser tú mi hermano, me has de servir gratuitamente? declárame qué será tu salario. ");
INSERT INTO spav1602p_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Y Labán tenía dos hijas: el nombre de la mayor era Lea, y el nombre de la menor, Raquel. ");
INSERT INTO spav1602p_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Y los ojos de Lea eran tiernos, pero Raquel era de lindo sem­blante y de hermoso parecer. ");
INSERT INTO spav1602p_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Y Jacob amó a Raquel, y dijo: Yo te serviré siete años por Raquel tu hija menor. ");
INSERT INTO spav1602p_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Y Labán respondió: Mejor es que te la dé a ti, y no que la dé a otro hombre: estáte conmigo. ");
INSERT INTO spav1602p_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Así sirvió Jacob por Raquel siete años: y pareciéronle como pocos días, porque la amaba. ");
INSERT INTO spav1602p_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Y dijo Jacob a Labán: Dame mi esposa, porque mi tiempo es cumplido, para que cohabite con ella. ");
INSERT INTO spav1602p_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Entonces Labán juntó a todos los varones de aquel lugar, e hizo banquete. ");
INSERT INTO spav1602p_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Y sucedió que a la noche tomó a Lea su hija, y se la trajo: y él entró a ella. ");
INSERT INTO spav1602p_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Y dio Labán su sierva Zilpa a su hija Lea por criada. ");
INSERT INTO spav1602p_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Y venida la mañana, he aquí que era Lea: y él dijo a Labán: ¿Qué es esto que me has hecho? ¿no te he servido por Raquel? ¿por qué, pues, me has engaña­do? ");
INSERT INTO spav1602p_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Y Labán respondió: No se hace así en nuestro lugar, que se dé la menor antes de la mayor. ");
INSERT INTO spav1602p_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Cumple la semana de ésta, y se te dará también la otra, por el servicio que hicieres conmigo otros siete años. ");
INSERT INTO spav1602p_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","E hizo Jacob así, y cumplió la semana de aquélla: y él le dio a Raquel su hija por esposa. ");
INSERT INTO spav1602p_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Y dio Labán a Raquel su hija por criada a su sierva Bilha. ");
INSERT INTO spav1602p_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Y entró también a Raquel: y amóla también más que a Lea: y sirvió con él aún otros siete años. ");
INSERT INTO spav1602p_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Y vio el SEÑOR que Lea era aborrecida, y abrió su matriz: pero Raquel era estéril. ");
INSERT INTO spav1602p_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Y concibió Lea, y parió un hijo, y llamó su nombre Rubén, porque dijo: Ya que ha mirado el SEÑOR mi aflicción; ahora por tanto me amará mi marido. ");
INSERT INTO spav1602p_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Y concibió otra vez, y parió un hijo, y dijo: Por cuanto oyó el SEÑOR que yo era aborrecida, me ha dado también éste. Y llamó su nombre Simeón. ");
INSERT INTO spav1602p_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Y concibió otra vez, y parió un hijo, y dijo: Ahora esta vez se unirá mi marido conmigo, por­que le he parido tres hijos: por tanto, llamó su nombre Leví. ");
INSERT INTO spav1602p_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Y concibió otra vez, y parió un hijo, y dijo: Esta vez alabaré al SEÑOR: por esto llamó su nombre Judá: y dejó de parir. ");
INSERT INTO spav1602p_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Y VIENDO Raquel que no daba hijos a Jacob, tuvo envidia de su hermana, y decía a Jacob: Dame hijos, o si no, me muero. ");
INSERT INTO spav1602p_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Y Jacob se enojaba contra Raquel, y decía: ¿Soy yo en lugar de Dios, que te impidió el fruto de tu vientre? ");
INSERT INTO spav1602p_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Y ella dijo: He aquí mi sierva Bilha; entra a ella, y parirá sobre mis rodillas, y yo también tendré hijos de ella. ");
INSERT INTO spav1602p_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Así le dio a Bilha su sierva por esposa; y Jacob entró a ella. ");
INSERT INTO spav1602p_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Y concibió Bilha, y parió a Jacob un hijo. ");
INSERT INTO spav1602p_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Y dijo Raquel: Juzgóme Dios, y también oyó mi voz, y dióme un hijo. Por tanto llamó su nom­bre Dan. ");
INSERT INTO spav1602p_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Y concibió otra vez Bilha, la sierva de Raquel, y parió el hijo segundo a Jacob. ");
INSERT INTO spav1602p_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Y dijo Raquel: Con luchas de Dios he contendido con mi her­mana, y he vencido. Y llamó su nombre Neftalí. ");
INSERT INTO spav1602p_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Y viendo Lea que había dejado de parir, tomó a Zilpa su sierva, y dióla a Jacob por esposa. ");
INSERT INTO spav1602p_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Y Zilpa, sierva de Lea, parió a Jacob un hijo. ");
INSERT INTO spav1602p_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Y dijo Lea: Vino la ventura. Y llamó su nombre Gad. ");
INSERT INTO spav1602p_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Y Zilpa, la sierva de Lea, parió un segundo hijo a Jacob. ");
INSERT INTO spav1602p_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Y dijo Lea: Para dicha mía; porque las mujeres me dirán dichosa: y llamó su nombre Aser. ");
INSERT INTO spav1602p_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Y fue Rubén en tiempo de la siega de los trigos, y halló mandrágoras en el campo, y trájolas a Lea su madre: y dijo Raquel a Lea: Ruégote que me des de las mandrágoras de tu hijo. ");
INSERT INTO spav1602p_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Y ella respondió: ¿Es poco que hayas tomado mi marido, sino que también te has de llevar las mandrágoras de mi hijo? Y dijo Raquel: Pues dormirá conti­go esta noche por las mandrágo­ras de tu hijo. ");
INSERT INTO spav1602p_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Y cuando Jacob volvía del campo a la tarde, salió Lea a él, y le dijo: A mí has de entrar, por­que a la verdad te he alquilado por las mandrágoras de mi hijo. Y durmió con ella aquella noche. ");
INSERT INTO spav1602p_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Y oyó Dios a Lea: y concibió, y parió a Jacob el quinto hijo. ");
INSERT INTO spav1602p_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Y dijo Lea: Dios me ha dado mi recompensa, por cuanto di mi sierva a mi marido: por eso llamó su nombre Isacar. ");
INSERT INTO spav1602p_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Y concibió Lea otra vez, y parió el sexto hijo a Jacob. ");
INSERT INTO spav1602p_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Y dijo Lea: Dios me ha dado una buena dote: ahora morará conmigo mi marido, porque le he parido seis hijos: y llamó su nombre Zabulón. ");
INSERT INTO spav1602p_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Y después parió una hija, y llamó su nombre Dina. ");
INSERT INTO spav1602p_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Y acordóse Dios de Raquel, y oyóla Dios, y abrió su matriz. ");
INSERT INTO spav1602p_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Y concibió, y parió un hijo: y dijo: Quitado ha Dios mi afrenta: ");
INSERT INTO spav1602p_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Y llamó su nombre José, diciendo: Añádame el SEÑOR otro hijo. ");
INSERT INTO spav1602p_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Y aconteció, cuando Raquel hubo parido a José, que Jacob dijo a Labán: Envíame, e iré a mi lugar, y a mi tierra. ");
INSERT INTO spav1602p_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Dame mis esposas y mis hijos, por las cuales he servido contigo, y déjame ir; pues tú sabes los servicios que te he hecho. ");
INSERT INTO spav1602p_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Y Labán le respondió: Halle yo ahora gracia en tus ojos, y quédate; experimentado he que el SEÑOR me ha bendecido por tu causa. ");
INSERT INTO spav1602p_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Y dijo: Señálame tu salario, que yo lo daré. ");
INSERT INTO spav1602p_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Y él respondió: Tú sabes cómo te he servido, y cómo ha estado tu ganado conmigo; ");
INSERT INTO spav1602p_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Porque poco tenías antes de mi venida, y ha crecido en gran número; y el SEÑOR te ha ben­decido con mi llegada: y ahora ¿cuándo tengo de hacer yo tam­bién por mi propia casa? ");
INSERT INTO spav1602p_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Y él dijo: ¿Qué te daré? Y res­pondió Jacob: No me des nada: si hicieres por mí esto, volveré a apacentar tus ovejas. ");
INSERT INTO spav1602p_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Yo pasaré hoy por todas tus ovejas, poniendo aparte todas las reses manchadas y de color vario, y todas las reses de color oscuro entre las ovejas, y las manchadas y de color vario entre las cabras; y esto será mi salario. ");
INSERT INTO spav1602p_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Así responderá por mí mi jus­ticia mañana, cuando me viniere mi salario delante de ti: toda la que no fuere pintada ni mancha­da en las cabras y de color oscu­ro en las ovejas mías, se me ha de tener por de hurto. ");
INSERT INTO spav1602p_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Y dijo Labán: Mira, que fuese como tú dices. ");
INSERT INTO spav1602p_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Y apartó aquel día los machos de cabrío rayados y manchados; y todas las cabras manchadas y de color vario, y toda res que tenía en sí algo de blanco, y todas las de color oscuro entre las ove­jas, y púsolas en manos de sus hijos; ");
INSERT INTO spav1602p_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Y puso tres días de camino entre sí y Jacob: y Jacob apacen­taba las otras ovejas de Labán. ");
INSERT INTO spav1602p_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Y tomóse Jacob varas de álamo verdes, y de avellano, y de castaño, y descortezó en ellas mondaduras blancas, descu­briendo así lo blanco de las varas. ");
INSERT INTO spav1602p_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Y puso las varas que había mondado en las pilas, delante del ganado, en los abrevaderos del agua donde venían a beber las ovejas, las cuales se recalentaban viniendo a beber. ");
INSERT INTO spav1602p_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Y concebían las ovejas delan­te de las varas, y parían borregos listados, pintados y salpicados de diversos colores. ");
INSERT INTO spav1602p_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Y apartaba Jacob los corde­ros, y poníalos con su rebaño, los listados, y todo lo que era oscuro en el hato de Labán. Y ponía su hato aparte, y no lo ponía con las ovejas de Labán. ");
INSERT INTO spav1602p_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Y sucedía que cuantas veces se recalentaban las tempranas, Jacob ponía las varas delante de las ovejas en las pilas, para que concibiesen a la vista de las varas. ");
INSERT INTO spav1602p_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Y cuando venían las ovejas tardías, no las ponía: así eran las tardías para Labán, y las tempra­nas para Jacob. ");
INSERT INTO spav1602p_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Y acreció el varón sumamente, y tuvo muchas ovejas, y siervas y siervos, y camellos y asnos. ");
INSERT INTO spav1602p_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Y OÍA él las palabras de los hijos de Labán, que decían: Jacob ha tomado todo lo que era de nuestro padre; y de lo que era de nuestro padre ha adquirido toda esta gloria. ");
INSERT INTO spav1602p_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Miraba también Jacob el sem­blante de Labán, y veía que no era para con él como ayer y antes de ayer. ");
INSERT INTO spav1602p_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","También el SEÑOR dijo a Jacob: Vuélvete a la tierra de tus padres, y a tu parentela; que yo seré contigo. ");
INSERT INTO spav1602p_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Y envió Jacob, y llamó a Raquel y a Lea al campo a sus ovejas, ");
INSERT INTO spav1602p_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Y díjoles: Veo que el semblan­te de vuestro padre no es para conmigo como ayer y antes de ayer: mas el Dios de mi padre ha sido conmigo. ");
INSERT INTO spav1602p_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Y vosotras sabéis que con todas mis fuerzas he servido a vuestro padre: ");
INSERT INTO spav1602p_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Y vuestro padre me ha engaña­do, y me ha mudado el salario diez veces: pero Dios no le ha permitido que me hiciese mal. ");
INSERT INTO spav1602p_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Si él decía así: Los pintados serán tu salario; entonces todas las ovejas parían pintados: y si decía así: Los listados serán tu salario; entonces todas las ovejas parían listados. ");
INSERT INTO spav1602p_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Así quitó Dios el ganado de vuestro padre, y diómelo a mí. ");
INSERT INTO spav1602p_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Y sucedió que al tiempo que las ovejas se recalentaban, alcé yo mis ojos y vi en sueños, y he aquí los machos que cubrían a las hembras eran listados, pintados y abigarrados. ");
INSERT INTO spav1602p_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Y díjome el ángel de Dios en sueños: Jacob. Y yo dije: Heme aquí. ");
INSERT INTO spav1602p_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Y él dijo: Alza ahora tus ojos, y verás todos los machos que cubren a las ovejas son listados, pin­tados y abigarrados; porque yo he visto todo lo que Labán te ha hecho. ");
INSERT INTO spav1602p_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Yo soy el Dios de Betel, donde tú ungiste el título, y donde me hiciste un voto. Levántate ahora, y sal de esta tie­rra, y vuélvete a la tierra de tu naturaleza. ");
INSERT INTO spav1602p_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Y respondió Raquel y Lea, y dijéronle: ¿Hay todavía parte o heredad para nosotras en la casa de nuestro padre? ");
INSERT INTO spav1602p_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","¿No nos tiene ya como por extrañas, pues que nos vendió, y aun se ha comido del todo nues­tro precio? ");
INSERT INTO spav1602p_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Porque toda la riqueza que Dios ha quitado a nuestro padre, nuestra es y de nuestros hijos: ahora pues, haz todo lo que Dios te ha dicho. ");
INSERT INTO spav1602p_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Entonces se levantó Jacob, y subió sus hijos y sus esposas sobre los camellos. ");
INSERT INTO spav1602p_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Y puso en camino todo su ganado, y toda su hacienda que había adquirido, el ganado de su ganancia que había obtenido en Padan-aram, para volverse a Isaac su padre en la tierra de Canaán. ");
INSERT INTO spav1602p_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Y Labán había ido a trasquilar sus ovejas: y Raquel hurtó los ído­los de su padre. ");
INSERT INTO spav1602p_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Y recató Jacob el corazón de Labán arameo, en no hacerle saber que se huía. ");
INSERT INTO spav1602p_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Huyó, pues, con todo lo que tenía; y levantóse, y pasó el río, y puso su rostro al monte de Galaad. ");
INSERT INTO spav1602p_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Y fue dicho a Labán al tercer día que Jacob había huido. ");
INSERT INTO spav1602p_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Entonces tomó a sus herma­nos consigo, y fue tras él camino de siete días, y alcanzóle en el monte de Galaad. ");
INSERT INTO spav1602p_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Y vino Dios a Labán arameo en sueños aquella noche, y le dijo: Guárdate que no hables a Jacob descomedidamente. ");
INSERT INTO spav1602p_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Alcanzó pues Labán a Jacob, y éste había fijado su tienda en el monte: y Labán acampó con sus hermanos en el monte de Galaad. ");
INSERT INTO spav1602p_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Y dijo Labán a Jacob: ¿Qué has hecho, que has salido sin avisarme, y has llevado a mis hijas como cautivas tomadas a espada? ");
INSERT INTO spav1602p_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","¿Por qué te escondiste para huir, y me hurtaste, y no me diste noticia, para que yo te enviara con alegría y con cantares, con tamborín y arpa? ");
INSERT INTO spav1602p_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","¿Y aun no me dejaste besar a mis hijos y a mis hijas? Ahora neciamente has hecho en hacer así. ");
INSERT INTO spav1602p_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Poder hay en mi mano para haceros mal: mas el Dios de vuestro padre me habló anoche diciendo: Guárdate que no hables a Jacob descomedida­mente. ");
INSERT INTO spav1602p_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Y ya que te ibas, porque tenías deseo de la casa de tu padre, ¿por qué me hurtaste mis dioses? ");
INSERT INTO spav1602p_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Y Jacob respondió, y dijo a Labán: Porque tuve miedo; pues dije, que quizás me quitarías por fuerza tus hijas. ");
INSERT INTO spav1602p_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Con quien hallares tus dioses, no viva: delante de nuestros her­manos reconoce lo que yo tuvie­re tuyo, y llévatelo. Pues Jacob no sabía que Raquel los había hurta­do. ");
INSERT INTO spav1602p_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Y entró Labán en la tienda de Jacob, y en la tienda de Lea, y en la tienda de las dos siervas, y no los halló, y salió de la tienda de Lea, y vino a la tienda de Raquel. ");
INSERT INTO spav1602p_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Y tomó Raquel los ídolos, y púsolos en una albarda de un camello, y sentóse sobre ellos: y tentó Labán toda la tienda, y no los halló. ");
INSERT INTO spav1602p_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Y ella dijo a su padre: No se enoje mi señor, porque no me puedo levantar delante de ti; pues estoy con la costumbre de las mujeres. Y él buscó, pero no halló los ídolos. ");
INSERT INTO spav1602p_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Entonces Jacob se enojó, y regañó con Labán; y respondió Jacob y dijo a Labán: ¿Qué pre­varicación es la mía? ¿cuál es mi pecado, que con tanto ardor has venido en seguimiento mío? ");
INSERT INTO spav1602p_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Pues que has tentado todos mis muebles, ¿qué has hallado de todas las alhajas de tu casa? Ponlo aquí delante de mis her­manos y tuyos, y juzguen entre nosotros ambos. ");
INSERT INTO spav1602p_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Estos veinte años he estado contigo: tus ovejas y tus cabras nunca abortaron, ni yo comí car­nero de tus ovejas. ");
INSERT INTO spav1602p_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","No te traje lo desgarrado por las fieras; yo pagaba el daño; lo hurtado así de día como de noche, de mi mano lo requerías. ");
INSERT INTO spav1602p_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","De día me consumía el calor, y de noche la helada, y el sueño se huía de mis ojos. ");
INSERT INTO spav1602p_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Así he estado veinte años en tu casa: catorce años te serví por tus dos hijas, y seis años por tu ganado; y has mudado mi salario diez veces. ");
INSERT INTO spav1602p_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Si el Dios de mi padre, el Dios de Abraham, y el temor de Isaac, no fuera conmigo, de cierto me enviarías ahora vacío: vio Dios mi aflicción y el trabajo de mis manos, y reprendióte anoche. ");
INSERT INTO spav1602p_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Y respondió Labán, y dijo a Jacob: Estas hijas son hijas mías, y estos hijos, hijos míos son, y este ganado es mi ganado, y todo lo que tú ves es mío: ¿y que puedo yo hacer hoy a estas mis hijas, o a sus hijos que ellas han parido? ");
INSERT INTO spav1602p_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Ven pues ahora, hagamos pacto yo y tú; y sea en testimonio entre mí y entre ti. ");
INSERT INTO spav1602p_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Entonces Jacob tomó una piedra, y levantóla por título. ");
INSERT INTO spav1602p_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Y dijo Jacob a sus hermanos: Coged piedras. Y tomaron pie­dras e hicieron un majano; y comieron allí sobre aquel maja­no. ");
INSERT INTO spav1602p_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Y llamólo Labán Jegar Sahaduta: y lo llamó Jacob Galaad. ");
INSERT INTO spav1602p_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Porque Labán dijo: Este majano es testigo hoy entre mí y entre ti; por eso fue llamado su nombre Galaad; ");
INSERT INTO spav1602p_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Y Mizpa, por cuanto dijo: Atalaye el SEÑOR entre mí y entre ti, cuando nos apartáremos el uno del otro. ");
INSERT INTO spav1602p_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Si afligieres mis hijas, o si tomares otras esposas además de mis hijas, nadie está con noso­tros; mira, Dios es testigo entre mí y entre ti. ");
INSERT INTO spav1602p_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Dijo más Labán a Jacob: He aquí este majano, y he aquí este título, que he erigido entre mí y ti. ");
INSERT INTO spav1602p_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Testigo sea este majano, y tes­tigo sea este título, que ni yo pasaré contra ti este majano, ni tú pasarás contra mí este majano ni este título, para mal. ");
INSERT INTO spav1602p_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","El Dios de Abraham, y el Dios de Nacor juzgue entre nosotros, el Dios de sus padres. Y Jacob juró por el temor de Isaac su padre. ");
INSERT INTO spav1602p_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Entonces Jacob inmoló vícti­mas en el monte, y llamó a sus hermanos a comer pan: y comie­ron pan, y durmieron aquella noche en el monte. ");
INSERT INTO spav1602p_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Y levantóse Labán de maña­na, y besó sus hijos y sus hijas, y los bendijo; y retrocedió y vol­vióse a su lugar. ");
INSERT INTO spav1602p_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Y JACOB se fue su camino, y saliéronle al encuentro ángeles de Dios. ");
INSERT INTO spav1602p_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Y dijo Jacob cuando los vio: El campo de Dios es éste: y llamó el nombre de aquel lugar Mahanaim. ");
INSERT INTO spav1602p_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Y envió Jacob mensajeros delante de sí a Esaú su hermano, a la tierra de Seir, campo de Edom. ");
INSERT INTO spav1602p_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Y mandóles diciendo: Así diréis a mí señor Esaú: Así dice tu siervo Jacob: Con Labán he morado, y detenídome hasta ahora; ");
INSERT INTO spav1602p_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Y tengo vacas, y asnos, y ove­jas, y siervos y siervas; y envío a decirlo a mi señor, por hallar gra­cia en tus ojos. ");
INSERT INTO spav1602p_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Y los mensajeros volvieron a Jacob, diciendo: Vinimos a tu hermano Esaú, y él también viene a recibirte, y cuatrocientos hombres con él. ");
INSERT INTO spav1602p_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Entonces Jacob tuvo gran temor, y angustióse; y partió el pueblo que tenía consigo, y las ovejas y las vacas y los camellos, en dos cuadrillas; ");
INSERT INTO spav1602p_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Y dijo: Si viniere Esaú a un campamento y lo hiriere, el otro campamento escapará. ");
INSERT INTO spav1602p_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Y dijo Jacob: Oh Dios de mi padre Abraham, y Dios de mi padre Isaac, SEÑOR, que me dijiste: Vuélvete a tu tierra y a tu paren­tela, y yo te haré bien; ");
INSERT INTO spav1602p_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Menor soy que todas las misericordias, y que toda la ver­dad que has usado para con tu siervo; que con mi bordón pasé este Jordán, y ahora estoy sobre dos cuadrillas. ");
INSERT INTO spav1602p_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Líbrame ahora de la mano de mi hermano, de la mano de Esaú, porque le temo; no venga quizá, y me hiera, y la madre con los hijos. ");
INSERT INTO spav1602p_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Y tú has dicho: Yo te haré bien, y pondré tu simiente como la arena del mar, que no se puede contar por la multitud. ");
INSERT INTO spav1602p_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Y durmió allí aquella noche, y tomó de lo que le vino a la mano un presente para su hermano Esaú; ");
INSERT INTO spav1602p_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Doscientas cabras y veinte machos de cabrío, doscientas ovejas y veinte carneros, ");
INSERT INTO spav1602p_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Treinta camellas paridas, con sus hijos, cuarenta vacas y diez novillos, veinte asnas y diez borricos. ");
INSERT INTO spav1602p_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Y entrególos en mano de sus siervos, cada manada de por sí; y dijo a sus siervos: Pasad delante de mí, y poned espacio entre manada y manada. ");
INSERT INTO spav1602p_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Y mandó al primero, dicien­do: Si Esaú mi hermano te encontrare, y te preguntare, diciendo: ¿De quién eres? ¿y adónde vas? ¿y para quién es esto que llevas delante de ti? ");
INSERT INTO spav1602p_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Entonces dirás: Estos son de tu siervo Jacob, es un presente enviado a mi señor Esaú; y he aquí, él viene tras nosotros. ");
INSERT INTO spav1602p_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Y mandó también al segundo, y al tercero, y a todos los que iban tras aquellas manadas, diciendo: Conforme a esto habla­réis a Esaú, cuando le hallareis. ");
INSERT INTO spav1602p_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Y diréis también: He aquí, tu siervo Jacob viene tras de nosotros. Porque dijo: Apaciguaré su ira con el presente que va delante de mí, y después veré su rostro: quizá le seré acepto. ");
INSERT INTO spav1602p_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Y pasó el presente delante de él; y él durmió aquella noche en el campamento. ");
INSERT INTO spav1602p_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Y levantóse aquella noche, y tomó sus dos esposas, y sus dos siervas, y sus once hijos, y pasó el vado de Jaboc. ");
INSERT INTO spav1602p_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Tomólos pues, y pasólos el arroyo, e hizo pasar lo que tenía. ");
INSERT INTO spav1602p_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Y quedóse Jacob solo, y luchó con él un varón hasta que rayaba el alba. ");
INSERT INTO spav1602p_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Y como vio que no podía con él, tocó en el sitio del encaje de su muslo, y descoyuntóse el muslo de Jacob mientras con él luchaba. ");
INSERT INTO spav1602p_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Y dijo: Déjame, que raya el alba. Y él dijo: No te dejaré, si no me bendices. ");
INSERT INTO spav1602p_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Y él le dijo: ¿Cuál es tu nom­bre? Y él respondió: Jacob. ");
INSERT INTO spav1602p_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Y él dijo: No se dirá más tu nombre Jacob, sino Israel: porque como un príncipe tienes poder con Dios y con los hombres, y has prevalecido. ");
INSERT INTO spav1602p_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Y Jacob le preguntó, y dijo: Declárame, te ruego, tu nombre. Y él respondió: ¿Por qué preguntas por mi nombre? Y bendíjolo allí. ");
INSERT INTO spav1602p_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Y llamó Jacob el nombre de aquel lugar, Peniel: porque vi a Dios cara a cara, y fue librada mi alma. ");
INSERT INTO spav1602p_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Y salióle el sol pasado que hubo a Peniel; y cojeaba de su anca. ");
INSERT INTO spav1602p_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Por esto los hijos de Israel no comen del tendón que se contrajo, el cual está en el encaje del muslo, hasta hoy día: porque tocó a Jacob este sitio de su muslo en el tendón que se contrajo. ");
INSERT INTO spav1602p_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Y ALZANDO Jacob sus ojos miró, y he aquí venía Esaú, y los cuatrocientos hombres con él: entonces repartió él los niños entre Lea y Raquel y las dos siervas. ");
INSERT INTO spav1602p_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Y puso las siervas y sus niños delante; luego a Lea y a sus niños; y a Raquel y a José los postreros. ");
INSERT INTO spav1602p_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Y él pasó delante de ellos, e inclinóse a tierra siete veces, hasta que llegó a su hermano. ");
INSERT INTO spav1602p_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Y Esaú corrió a su encuentro, y abrazóle, y echóse sobre su cue­llo, y le besó; y lloraron. ");
INSERT INTO spav1602p_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Y alzó sus ojos, y vio las muje­res y los niños, y dijo: ¿Quiénes son éstos contigo? Y él respondió: Son los niños que Dios graciosamente ha dado a tu siervo. ");
INSERT INTO spav1602p_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Y se llegaron las siervas, ellas y sus niños, e inclináronse. ");
INSERT INTO spav1602p_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Y llegóse Lea con sus niños, e inclináronse: y después llegó José y Raquel, y también se incli­naron. ");
INSERT INTO spav1602p_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Y él dijo: ¿Qué te propones con todas estas cuadrillas que he encontrado? Y él respondió: Hallar gracia en los ojos de mi señor. ");
INSERT INTO spav1602p_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Y dijo Esaú: Bastante tengo yo, hermano mío: sea para ti lo que es tuyo. ");
INSERT INTO spav1602p_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Y dijo Jacob: No, yo te ruego, si he hallado ahora gracia en tus ojos, toma mi presente de mi mano, pues que así he visto tu rostro, como si hubiera visto el rostro de Dios; y hazme placer. ");
INSERT INTO spav1602p_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Toma, te ruego, mi bendición que te es traída; porque Dios ha tratado graciosamente conmigo, y porque tengo suficiente. Y porfió con él, y tomóla. ");
INSERT INTO spav1602p_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Y dijo: Anda, y vamos; y yo iré delante de ti. ");
INSERT INTO spav1602p_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Y él le dijo: Mi señor sabe que los niños son tiernos, y que tengo conmigo rebaños y vacas paridas; y si las fatigan, en un día morirá todo el rebaño. ");
INSERT INTO spav1602p_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Pase ahora mi señor delante de su siervo, y yo guiaré poco a poco, conforme al paso del ganado que va delante de mí y al paso de los niños, hasta que llegue a mi señor a Seir. ");
INSERT INTO spav1602p_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Y Esaú dijo: Dejaré ahora con­tigo alguna de la gente que viene conmi­go. Y él dijo: ¿Para qué esto? halle yo gracia en los ojos de mi señor. ");
INSERT INTO spav1602p_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Así se volvió Esaú aquel día por su camino a Seir. ");
INSERT INTO spav1602p_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Y Jacob se partió a Sucot, y edificó allí casa para sí, e hizo cabañas para su ganado: por tanto llamó el nombre de aquel lugar Sucot. ");
INSERT INTO spav1602p_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Y vino Jacob sano a la ciudad de Siquem, que está en la tierra de Canaán, cuando venía de Padan-aram; y acampó delante de la ciudad. ");
INSERT INTO spav1602p_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Y compró una parte del campo, donde tendió su tienda, de mano de los hijos de Hamor, padre de Siquem, por cien piezas de moneda. ");
INSERT INTO spav1602p_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Y erigió allí un altar, y le llamó El-elohe-Israel. ");
INSERT INTO spav1602p_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Y SALIÓ Dina la hija de Lea, la cual había ésta parido a Jacob, a ver las hijas del país. ");
INSERT INTO spav1602p_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Y vióla Siquem, hijo de Hamor heveo, príncipe de aquella tierra, y tomóla, y echóse con ella, y la deshonró. ");
INSERT INTO spav1602p_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Mas su alma se apegó a Dina la hija de Lea, y enamoróse de la moza, y habló al corazón de la joven. ");
INSERT INTO spav1602p_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Y habló Siquem a Hamor su padre, diciendo: Tómame por esposa esta moza. ");
INSERT INTO spav1602p_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Y oyó Jacob que había Siquem amancillado a Dina su hija: y estando sus hijos con su ganado en el campo, calló Jacob hasta que ellos viniesen. ");
INSERT INTO spav1602p_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Y dirigióse Hamor padre de Siquem a Jacob, para hablar con él. ");
INSERT INTO spav1602p_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Y los hijos de Jacob vinieron del campo cuando lo supieron; y se entristecieron los varones, y se ensañaron mucho, porque hizo vileza en Israel echándose con la hija de Jacob, lo que no se debía haber hecho. ");
INSERT INTO spav1602p_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Y Hamor habló con ellos, diciendo: El alma de mi hijo Siquem se ha apegado a vuestra hija; ruégoos que se la deis por esposa. ");
INSERT INTO spav1602p_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Y emparentad con nosotros; dadnos vuestras hijas, y tomad vosotros las nuestras. ");
INSERT INTO spav1602p_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Y habitad con nosotros; por­que la tierra estará delante de vosotros; morad y negociad en ella, y tomad en ella posesión. ");
INSERT INTO spav1602p_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Siquem también dijo a su padre y a sus hermanos: Halle yo gracia en vuestros ojos, y daré lo que me dijereis. ");
INSERT INTO spav1602p_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Aumentad a cargo mío mucho dote y dones, que yo daré cuanto me dijereis, y dadme la moza por esposa. ");
INSERT INTO spav1602p_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Y respondieron los hijos de Jacob a Siquem y a Hamor su padre con engaño: y parlaron, por cuanto había amancillado a Dina su hermana. ");
INSERT INTO spav1602p_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Y dijéronles: No podemos hacer esto de dar nuestra herma­na a hombre que tiene prepucio; porque entre nosotros es abomi­nación. ");
INSERT INTO spav1602p_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Mas con esta condición os haremos placer: si habéis de ser como nosotros, que se circuncide entre vosotros todo varón; ");
INSERT INTO spav1602p_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Entonces os daremos nuestras hijas, y tomaremos nosotros las vuestras; y habitaremos con vosotros, y seremos un pueblo. ");
INSERT INTO spav1602p_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Mas si no nos prestareis oído para circuncidaros, tomaremos nuestra hija, y nos iremos. ");
INSERT INTO spav1602p_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Y parecieron bien sus pala­bras a Hamor y a Siquem, hijo de Hamor. ");
INSERT INTO spav1602p_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Y no dilató el mozo hacer aquello, porque la hija de Jacob le había agradado: y él era el más honrado de toda la casa de su padre. ");
INSERT INTO spav1602p_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Entonces Hamor y Siquem su hijo vinieron a la puerta de su ciudad, y hablaron a los varones de su ciudad, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Estos varones son pacíficos con nosotros, y habitarán en el país, y traficarán en él: pues he aquí la tierra es bastante ancha para ellos: nosotros tomaremos sus hijas por esposas, y les dare­mos las nuestras. ");
INSERT INTO spav1602p_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Mas con esta condición nos harán estos hombres el placer de habitar con nosotros, para que seamos un pueblo: si se circunci­dare en nosotros todo varón, así como ellos son circuncidados. ");
INSERT INTO spav1602p_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Sus ganados y su sustancia y todas sus bestias, ¿no serán nuestros? Solamente consintamos con ellos, y habitarán con nosotros. ");
INSERT INTO spav1602p_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Y obedecieron a Hamor y a Siquem su hijo todos los que salí­an por la puerta de la ciudad, y circuncidaron a todo varón, a cuantos salían por la puerta de su ciudad. ");
INSERT INTO spav1602p_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Y sucedió que al tercer día, cuando sentían ellos el mayor dolor, los dos hijos de Jacob, Simeón y Leví, hermanos de Dina, tomaron cada uno su espa­da, y vinieron contra la ciudad animosamente, y mataron a todo varón. ");
INSERT INTO spav1602p_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Y a Hamor y a Siquem su hijo los mataron a filo de espada: y tomaron a Dina de casa de Siquem, y saliéronse. ");
INSERT INTO spav1602p_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Y los hijos de Jacob vinieron a los muertos, y saquearon la ciu­dad; por cuanto habían amanci­llado a su hermana. ");
INSERT INTO spav1602p_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Tomaron sus ovejas y vacas y sus asnos, y lo que había en la ciudad y en el campo, ");
INSERT INTO spav1602p_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Y toda su riqueza, y todos sus niños, y sus esposas tomaron cautivos, y saquearon aún todo que estaba en casa. ");
INSERT INTO spav1602p_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Entonces dijo Jacob a Simeón y a Leví: Habéisme turbado con hacerme abominable a los mora­dores de esta tierra, el cananeo y el ferezeo; y teniendo yo pocos hombres, juntarse han contra mí, y me herirán, y seré destruido yo y mi casa. ");
INSERT INTO spav1602p_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Y ellos respondieron: ¿Había él de tratar a nuestra hermana como a una ramera? ");
INSERT INTO spav1602p_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Y DIJO Dios a Jacob: Levántate, sube a Betel, y estáte allí; y haz allí un altar al Dios que te apareció cuando huías de tu hermano Esaú. ");
INSERT INTO spav1602p_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Entonces Jacob dijo a su fami­lia y a todos los que con él esta­ban: Quitad los dioses ajenos que hay entre vosotros, y limpiaos, y mudad vuestros vestiduras. ");
INSERT INTO spav1602p_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Y levantémonos, y subamos a Betel; y haré allí altar al Dios que me respondió en el día de mi angustia, y ha sido conmigo en el camino que he andado. ");
INSERT INTO spav1602p_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Así dieron a Jacob todos los dioses ajenos que había en sus manos, y todos sus zarzillos que estaban en sus orejas; y Jacob los escondió debajo de una encina, que estaba junto a Siquem. ");
INSERT INTO spav1602p_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Y partiéronse, y el terror de Dios fue sobre las ciudades que había en sus alrededores, y no siguieron tras los hijos de Jacob. ");
INSERT INTO spav1602p_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Y llegó Jacob a Luz, que está en tierra de Canaán, (ésta es Betel) él y todo el pueblo que con él estaba; ");
INSERT INTO spav1602p_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Y edificó allí un altar, y llamó el lugar El-Betel, porque allí le había aparecido Dios, cuando huía de su hermano. ");
INSERT INTO spav1602p_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Entonces murió Débora, ama de Rebeca, y fue sepultada a las raíces de Betel, debajo de una encina: y llamóse su nombre Alon-Bacut. ");
INSERT INTO spav1602p_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Y aparecióse otra vez Dios a Jacob, cuando se había vuelto de Padan-aram, y bendíjole. ");
INSERT INTO spav1602p_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Y díjole Dios: Tu nombre es Jacob; no se llamará más tu nom­bre Jacob, sino Israel será tu nombre: y llamó su nombre Israel. ");
INSERT INTO spav1602p_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Y díjole Dios: Yo soy el Dios Todopoderoso: crece y multiplícate; una nación y compañía de naciones procederá de ti, y reyes saldrán de tus lomos: ");
INSERT INTO spav1602p_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Y la tierra que yo he dado a Abraham y a Isaac, la daré a ti: y a tu simiente después de ti daré la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Y fuese de él Dios, del lugar donde con él había hablado. ");
INSERT INTO spav1602p_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Y Jacob erigió un título en el lugar donde había hablado con él, un título de piedra, y derramó sobre él libación, y echó sobre él aceite. ");
INSERT INTO spav1602p_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Y llamó Jacob el nombre de aquel lugar donde Dios había hablado con él, Betel. ");
INSERT INTO spav1602p_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Y partieron de Betel, y había aún como media legua de tierra para llegar a Efrata, cuan­do parió Raquel, y hubo trabajo en su parto. ");
INSERT INTO spav1602p_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Y aconteció, que como había trabajo en su parir, díjole la par­tera: No temas, que también ten­drás este hijo. ");
INSERT INTO spav1602p_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Y acaeció que al salírsele el alma, (pues murió) llamó su nombre Benoni; mas su padre lo llamó Benjamín. ");
INSERT INTO spav1602p_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Así murió Raquel, y fue sepultada en el camino de Efrata, la cual es Belem. ");
INSERT INTO spav1602p_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Y puso Jacob un título sobre su sepultura: éste es el título de la sepultura de Raquel hasta hoy. ");
INSERT INTO spav1602p_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Y partió Israel, y tendió su tienda de la otra parte de Migdaleder. ");
INSERT INTO spav1602p_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Y acaeció, morando Israel en aquella tierra, que fue Rubén y durmió con Bilha la concubina de su padre; lo cual llegó a enten­der Israel. Ahora bien, los hijos de Israel fueron doce: ");
INSERT INTO spav1602p_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Los hijos de Lea: Rubén el primogénito de Jacob, y Simeón, y Leví, y Judá, e Isacar, y Zabulón. ");
INSERT INTO spav1602p_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Los hijos de Raquel: José, y Benjamín. ");
INSERT INTO spav1602p_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Y los hijos de Bilha, sierva de Raquel: Dan, y Neftalí. ");
INSERT INTO spav1602p_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Y los hijos de Zilpa, sierva de Lea: Gad, y Aser. Éstos fueron los hijos de Jacob, que le nacie­ron en Padan-aram. ");
INSERT INTO spav1602p_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Y vino Jacob a Isaac su padre a Mamre, a la ciudad de Arba, que es Hebrón, donde habitaron Abraham e Isaac. ");
INSERT INTO spav1602p_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Y fueron los días de Isaac ciento ochenta años. ");
INSERT INTO spav1602p_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Y exhaló Isaac el espíritu, y murió, y fue recogido a sus pue­blos, siendo viejo y lleno de días: y sepultáronlo Esaú y Jacob sus hijos. ");
INSERT INTO spav1602p_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Y ÉSTAS son las generaciones de Esaú, el cual es Edom. ");
INSERT INTO spav1602p_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esaú tomó sus esposas de las hijas de Canaán: a Ada, hija de Elón heteo, y a Aholibama, hija de Ana, hija de Zibeón el heveo; ");
INSERT INTO spav1602p_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Y a Basemat, hija de Ismael, hermana de Nabaiot. ");
INSERT INTO spav1602p_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Y Ada parió a Esaú a Elifaz; y Basemat parió a Reuel. ");
INSERT INTO spav1602p_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Y Aholibama parió a Jeús, y a Jaalam, y a Cora: éstos son los hijos de Esaú, que le nacieron en la tierra de Canaán. ");
INSERT INTO spav1602p_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Y Esaú tomó sus esposas, y sus hijos, y sus hijas, y todas las personas de su casa, y sus ganados, y todas sus bestias, y toda su sustancia que había adquirido en la tierra de Canaán, y se fue a otra tierra de delante de Jacob su hermano: ");
INSERT INTO spav1602p_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Porque la hacienda de ellos era grande, y no podían habitar jun­tos, ni la tierra de su peregrina­ción los podía sostener a causa de sus ganados. ");
INSERT INTO spav1602p_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Y Esaú habitó en el monte de Seir: Esaú es Edom. ");
INSERT INTO spav1602p_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Éstos son los linajes de Esaú, padre de Edom, en el monte de Seir. ");
INSERT INTO spav1602p_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Éstos son los nombres de los hijos de Esaú: Elifaz, hijo de Ada, esposa de Esaú; Reuel, hijo de Basemat, esposa de Esaú. ");
INSERT INTO spav1602p_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Y los hijos de Elifaz fueron Temán, Omar, Zefo, Gatam, y Cenaz. ");
INSERT INTO spav1602p_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Y Timna fue concubina de Elifaz, hijo de Esaú, la cual le parió a Amalec: éstos son los hijos de Ada, esposa de Esaú. ");
INSERT INTO spav1602p_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Y los hijos de Reuel fueron Nahat, Zera, Sama, y Miza: éstos son los hijos de Basemat, esposa de Esaú. ");
INSERT INTO spav1602p_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Éstos fueron los hijos de Aholibama, esposa de Esaú, hija de Ana, que fue hija de Zibeón: ella parió a Esaú, a Jeús, Jaalam, y Cora. ");
INSERT INTO spav1602p_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Éstos son los duques de los hijos de Esaú. Hijos de Elifaz, primogénito de Esaú: el duque Temán, el duque Omar, el duque Zefo, el duque Cenaz, ");
INSERT INTO spav1602p_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","El duque Cora, el duque Gatam, y el duque Amalec: éstos son los duques que vinieron de Elifaz en la tierra de Edom; éstos fueron los hijos de Ada. ");
INSERT INTO spav1602p_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Y éstos son los hijos de Reuel, hijo de Esaú: el duque Nahat, el duque Zera, el duque Sama, y el duque Miza; éstos son los duques que vinieron de Reuel en la tierra de Edom; éstos son los hijos de Basemat, esposa de Esaú. ");
INSERT INTO spav1602p_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Y éstos son los hijos de Aholibama, esposa de Esaú: el duque Jeús, el duque Jaalam, y el duque Cora: éstos fueron los duques que salieron de Aholibama, esposa de Esaú, hija de Ana. ");
INSERT INTO spav1602p_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Éstos, pues, son los hijos de Esaú, y sus duques: él es Edom. ");
INSERT INTO spav1602p_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Y éstos son los hijos de Seir horeo, moradores de aquella tie­rra: Lotán, Sobal, Zibeón, Ana, ");
INSERT INTO spav1602p_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Disón, Ezer, y Disán: éstos son los duques de los horeos, hijos de Seir, en la tierra de Edom. ");
INSERT INTO spav1602p_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Los hijos de Lotán fueron Hori y Hemán; y Timna fue her­mana de Lotán. ");
INSERT INTO spav1602p_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Y los hijos de Sobal fueron Alván, Manahat, Ebal, Sefo, y Onam. ");
INSERT INTO spav1602p_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Y éstos son los hijos de Zibeón; Aja, y Ana. Este Ana es el que descubrió los mulos en el desier­to, cuando apacentaba los asnos de Zibeón su padre. ");
INSERT INTO spav1602p_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Los hijos de Ana fueron Disón, y Aholibama, hija de Ana. ");
INSERT INTO spav1602p_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Y éstos son los hijos de Disón: Hemdán, Esbán, Itrán, y Cherán. ");
INSERT INTO spav1602p_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Y éstos son los hijos de Ezer: Bilhán, Zaaván, y Acán. ");
INSERT INTO spav1602p_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Éstos son los hijos de Disán: Uz, y Arán. ");
INSERT INTO spav1602p_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Y éstos son los duques que vinieron de los horeos: el duque Lotán, el duque Sobal, el duque Zibeón, el duque Ana, ");
INSERT INTO spav1602p_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","El duque Disón, el duque Ezer, el duque Disán: éstos son los duques que vinieron de los horeos, entre sus ducados en la tierra de Seir. ");
INSERT INTO spav1602p_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Y éstos son los reyes que reinaron en la tierra de Edom, antes que reinase algún rey sobre los hijos de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Y Bela, el hijo de Beor, reinó en Edom: y el nombre de su ciudad fue Dinaba. ");
INSERT INTO spav1602p_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Y murió Bela, y reinó en su lugar Jobab, hijo de Zera, de Bosra. ");
INSERT INTO spav1602p_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Y murió Jobab, y en su lugar reinó Husam, de tierra de Temán. ");
INSERT INTO spav1602p_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Y murió Husam, y reinó en su lugar Hadad, hijo de Bedad, el que hirió a Midián en el campo de Moab: y el nombre de su ciudad fue Avit. ");
INSERT INTO spav1602p_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Y murió Hadad, y en su lugar reinó Samla, de Masreca. ");
INSERT INTO spav1602p_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Y murió Samla, y reinó en su lugar Saúl de Rehobot, junto al río. ");
INSERT INTO spav1602p_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Y murió Saúl, y en lugar suyo reinó Baal-hanán, hijo de Acbor. ");
INSERT INTO spav1602p_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Y murió Baal-hanán , hijo de Acbor, y reinó Hadar en lugar suyo: y el nombre de su ciudad fue Pau; y el nombre de su esposa fue Meetabel, hija de Matred, hija de Mezaab. ");
INSERT INTO spav1602p_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Éstos, pues, son los nombres de los duques que vinieron de Esaú por sus linajes, por sus lugares, y sus nombres: el duque Timna, el duque Alva, el duque Jetet, ");
INSERT INTO spav1602p_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","El duque Aholibama, el duque Ela, el duque Pinón, ");
INSERT INTO spav1602p_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","El duque Cenaz, el duque Temán, el duque Mibzar, ");
INSERT INTO spav1602p_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","El duque Magdiel, y el duque Iram. Éstos son los duques de Edom, según sus habitaciones en la tierra de su posesión; él es Esaú el padre de los edomitas ");
INSERT INTO spav1602p_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Y HABITÓ Jacob en la tierra donde peregrinó su padre, en la tierra de Canaán. ");
INSERT INTO spav1602p_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Éstas son las generaciones de Jacob. José, siendo de edad de diez y siete años apacentaba las ovejas con sus hermanos; y el joven estaba con los hijos de Bilha, y con los hijos de Zilpa, esposas de su padre: y noticiaba José a su padre la mala fama de ellos. ");
INSERT INTO spav1602p_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Y amaba Israel a José más que a todos sus hijos, porque él era el hijo de su vejez: y le hizo una ropa de diversos colores. ");
INSERT INTO spav1602p_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Y viendo sus hermanos que su padre lo amaba más que a todos sus hermanos, aborrecíanle, y no le podían hablar pacíficamente. ");
INSERT INTO spav1602p_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Y soñó José un sueño, y contó­lo a sus hermanos; y ellos vinie­ron a aborrecerle más todavía. ");
INSERT INTO spav1602p_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Y él les dijo: Oíd ahora este sueño que he soñado: ");
INSERT INTO spav1602p_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","He aquí, estabamos en el campo atando los manojos, y he aquí, mi manojo se levantaba, y estaba derecho, y vuestros manojos estaban alrededor, y se inclinaban al mío. ");
INSERT INTO spav1602p_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Y respondiéronle sus herma­nos: ¿Has de reinar tú sobre nosotros, o te has de enseñorear sobre nosotros? Y le aborrecie­ron aún más a causa de sus sue­ños y de sus palabras. ");
INSERT INTO spav1602p_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Y soñó aún otro sueño, y con­tólo a sus hermanos, diciendo: He aquí que he soñado otro sueño, y he aquí que el sol y la luna y once estrellas se inclina­ban a mí. ");
INSERT INTO spav1602p_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Y contólo a su padre y a sus hermanos: y su padre le repren­dió, y díjole: ¿Qué sueño es éste que soñaste? ¿Hemos de venir yo y tu madre, y tus hermanos, a inclinarnos a ti a tierra? ");
INSERT INTO spav1602p_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Y sus hermanos le tenían envidia; pero su padre observaba el dicho. ");
INSERT INTO spav1602p_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Y fueron sus hermanos a apacentar las ovejas de su padre en Siquem. ");
INSERT INTO spav1602p_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Y dijo Israel a José: ¿No apacientan tus hermanos el rebaño en Siquem? Ven, y te enviaré a ellos. Y él le dijo: Heme aquí. ");
INSERT INTO spav1602p_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Y él le dijo: Ve ahora, mira cómo están tus hermanos y cómo están las ovejas, y tráeme la res­puesta. Y enviólo del valle de Hebrón, y llegó a Siquem. ");
INSERT INTO spav1602p_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Y hallólo un hombre, andan­do él perdido por el campo, y preguntóle aquel hombre, dicien­do: ¿Qué buscas? ");
INSERT INTO spav1602p_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Y él dijo: Busco a mis hermanos: ruégote que me digas dónde pastan. ");
INSERT INTO spav1602p_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Y aquel hombre respondió: Ya se han ido de aquí; yo les oí decir: Vamos a Dotán. Entonces José fue tras de sus hermanos, y hallólos en Dotán. ");
INSERT INTO spav1602p_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Y como ellos lo vieron de lejos, antes que cerca de ellos lle­gara, proyectaron contra él para matarle. ");
INSERT INTO spav1602p_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Y dijeron el uno al otro: He aquí viene el soñador; ");
INSERT INTO spav1602p_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Ahora pues, venid, y maté­moslo y echémosle en una cister­na, y diremos: Alguna mala bes­tia le devoró: y veremos qué serán sus sueños. ");
INSERT INTO spav1602p_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Y como Rubén oyó esto, librólo de sus manos, y dijo: No lo matemos. ");
INSERT INTO spav1602p_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Y les dijo Rubén: No derra­méis sangre; echadlo en este pozo que está en el desierto, y no pongáis mano en él; por librarlo así de sus manos, para entregarlo a su padre. ");
INSERT INTO spav1602p_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Y sucedió que, cuando llegó José a sus hermanos, ellos hicie­ron desnudar a José su ropa, la ropa de diversos colores que tenía sobre sí; ");
INSERT INTO spav1602p_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Y tomáronlo, y echáronle en la cisterna; mas la cisterna estaba vacía, no había en ella agua. ");
INSERT INTO spav1602p_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Y sentáronse a comer pan: y alzando los ojos miraron, y he aquí una compañía de ismaelitas que venía de Galaad, y sus came­llos traían aromas y bálsamo y mirra, e iban a llevarlo a Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Entonces Judá dijo a sus her­manos: ¿Qué provecho es que matemos a nuestro hermano y encubramos su sangre? ");
INSERT INTO spav1602p_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Venid, y vendámosle a los ismaelitas, y no sea nuestra mano sobre él; porque él es nuestro hermano y nuestra carne. Y sus her­manos acordaron con él. ");
INSERT INTO spav1602p_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Y como pasaban los madianitas mercaderes, sacaron ellos a José de la cisterna, y trajé­ronle arriba, y le vendieron a los ismaelitas por veinte piezas de plata. Y llevaron a José a Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Y Rubén volvió a la cisterna, y no halló a José dentro, y rasgó sus vestiduras. ");
INSERT INTO spav1602p_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Y tornó a sus hermanos, y dijo: El mozo no aparece; y yo, ¿adónde iré yo? ");
INSERT INTO spav1602p_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Entonces tomaron ellos la ropa de José, y degollaron un cabrito de las cabras, y tiñeron la ropa con la sangre; ");
INSERT INTO spav1602p_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Y enviaron la ropa de diversos colores y trajéronla a su padre, y dijeron: Ésta hemos hallado, reconoce ahora si es o no la ropa de tu hijo. ");
INSERT INTO spav1602p_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Y él la conoció, y dijo: La ropa de mi hijo es; alguna mala bestia le devoró; José ha sido despedazado. ");
INSERT INTO spav1602p_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Entonces Jacob rasgó sus vestiduras, y puso saco sobre sus lomos, y enlutóse por su hijo muchos días. ");
INSERT INTO spav1602p_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Y levantáronse todos sus hijos y todas sus hijas para consolarlo; mas él no quiso tomar consola­ción, y dijo: Porque yo tengo de descender a mi hijo enlutado hasta la sepultura. Y llorólo su padre. ");
INSERT INTO spav1602p_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Y los madianitas lo vendieron en Egipto a Potifar, oficial de Faraón y capitán de los de la guar­dia. ");
INSERT INTO spav1602p_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Y ACONTECIÓ en aquel tiempo, que Judá descendió de con sus hermanos, y fuese a un varón adulamita, que se llamaba Hira. ");
INSERT INTO spav1602p_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Y vio allí Judá la hija de un hombre cananeo, el cual se lla­maba Súa; y tomóla, y entró a ella: ");
INSERT INTO spav1602p_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","La cual concibió, y parió un hijo; y llamó su nombre Er. ");
INSERT INTO spav1602p_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Y concibió otra vez, y parió un hijo, y llamó su nombre Onán. ");
INSERT INTO spav1602p_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Y volvió a concebir, y parió un hijo, y llamó su nombre Sela. Y estaba en Chezib cuando lo parió. ");
INSERT INTO spav1602p_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Y Judá tomó esposa para su primogénito Er, la cual se llamaba Tamar. ");
INSERT INTO spav1602p_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Y Er, el primogénito de Judá, fue malo a los ojos del SEÑOR, y quitóle el SEÑOR la vida. ");
INSERT INTO spav1602p_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Entonces Judá dijo a Onán: Entra a la esposa de tu hermano, y despósate con ella, y suscita simiente a tu hermano. ");
INSERT INTO spav1602p_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Y sabiendo Onán que la simiente no había de ser suya, sucedía que cuando entraba a la esposa de su hermano vertía en tierra, por no dar simiente a su hermano. ");
INSERT INTO spav1602p_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Y desagradó en ojos del SEÑOR lo que hacía, y también quitó a él la vida. ");
INSERT INTO spav1602p_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Y Judá dijo a Tamar su nuera: Estáte viuda en casa de tu padre, hasta que crezca Sela mi hijo; porque dijo: Que quizá no muera él también como sucedió a sus her­manos. Y fuese Tamar, y estú­vose en casa de su padre. ");
INSERT INTO spav1602p_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Y pasaron muchos días, y murió la hija de Súa, esposa de Judá; y Judá se consoló, y subía a los trasquiladores de sus ovejas a Timnat, él y su amigo Hira el adulamita. ");
INSERT INTO spav1602p_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Y fue dado aviso a Tamar, diciendo: He aquí tu suegro sube a Timnat a trasquilar sus ovejas. ");
INSERT INTO spav1602p_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Entonces quitó ella de sobre sí las vestiduras de su viudez, y cubrióse con un velo, y arrebozó­se, y se puso a la puerta de las aguas que están junto al camino de Timnat: porque veía que había crecido Sela, y ella no era dada a él por esposa. ");
INSERT INTO spav1602p_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Y vióla Judá, y túvola por ramera, porque había ella cubier­to su rostro. ");
INSERT INTO spav1602p_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Y apartóse del camino hacia ella, y díjole: Ea, pues, ahora entraré a ti; porque no sabía que era su nuera; y ella dijo: ¿Qué me has de dar, si entrares a mí? ");
INSERT INTO spav1602p_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Él respondió: Yo te enviaré del ganado un cabrito de las cabras. Y ella dijo: ¿Me has de dar prenda hasta que lo envíes? ");
INSERT INTO spav1602p_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Entonces él dijo: ¿Qué prenda te daré? Y ella dijo: Tu sello, y tus pulseras, y tu bordón que tienes en tu mano. Y él se los dio, y entró a ella, la cual concibió de él. ");
INSERT INTO spav1602p_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Y levantóse, y fuese: y quitó­se el velo de sobre sí, y vistióse las ropas de su viudez. ");
INSERT INTO spav1602p_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Y Judá envió el cabrito de las cabras por mano de su amigo el adulamita, para que tomase la prenda de mano de la mujer; mas no la halló. ");
INSERT INTO spav1602p_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Entonces él preguntó a los hombres de aquel lugar, diciendo: ¿Dónde está la ramera, que andaba abiertamente junto al lado del camino? Y ellos dijeron: No había ninguna ramera en este lugar. ");
INSERT INTO spav1602p_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Entonces él se volvió a Judá, y dijo: No la puedo hallar; y también los hombres de aquel lugar dijeron: Aquí no ha estado ninguna ramera. ");
INSERT INTO spav1602p_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Y Judá dijo: Tómeselo para sí, porque no seamos menosprecia­dos: he aquí yo he enviado este cabrito, y tú no la hallaste. ");
INSERT INTO spav1602p_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Y acaeció que al cabo de unos tres meses fue dado aviso a Judá, diciendo: Tamar tu nuera ha fornicado, y aun cierto está pre­ñada de las fornicaciones. Y Judá dijo: Sacadla, y sea quemada. ");
INSERT INTO spav1602p_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Y cuando la sacaban, ella envió a decir a su suegro: Del varón cuyas son estas cosas, estoy preñada: y dijo más: Mira ahora cuyas son estas cosas, el sello, y las pulseras, y el bordón. ");
INSERT INTO spav1602p_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Entonces Judá las reconoció, y dijo: Más justa es que yo, por cuanto no la he dado a Sela mi hijo. Y nunca más la conoció. ");
INSERT INTO spav1602p_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Y aconteció que al tiempo del parir, he aquí había dos en su vientre. ");
INSERT INTO spav1602p_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Y sucedió, cuando paría, que sacó la mano el uno, y la partera tomó y ató a su mano un hilo de grana, diciendo: Éste salió pri­mero. ");
INSERT INTO spav1602p_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Y sucedió que tornando él a meter su mano, he aquí su hermano salió; y ella dijo: ¿Cómo has rompido? Sobre ti sea esta rotura. Y llamó su nombre Fares. ");
INSERT INTO spav1602p_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Y después salió su hermano, el que tenía en su mano el hilo de grana, y llamó su nombre Zara. ");
INSERT INTO spav1602p_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Y FUE llevado José a Egipto; y Potifar, oficial de Faraón, capitán de la guardia, varón egipcio, lo compró de mano de los ismaelitas que lo habían llevado allá. ");
INSERT INTO spav1602p_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Mas el SEÑOR fue con José, y fue varón prosperado: y estaba en la casa de su señor el egipcio. ");
INSERT INTO spav1602p_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Y vio su señor que el SEÑOR era con él, y que todo lo que él hacía, el SEÑOR lo hacía pros­perar en su mano. ");
INSERT INTO spav1602p_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Así halló José gracia en sus ojos, y servíale; y él le hizo mayordomo de su casa, y entre­gó en su poder todo lo que tenía. ");
INSERT INTO spav1602p_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Y aconteció que desde aquel tiempo cuando le dio el encargo de su casa, y de todo lo que tenía, que el SEÑOR bendijo la casa del egipcio a causa de José; y la bendición del SEÑOR fue sobre todo lo que él tenía en casa, y en el campo. ");
INSERT INTO spav1602p_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Y dejó todo lo que tenía en mano de José; ni con él sabía de nada más que del pan que comía. Y era José de hermoso semblan­te y bella presencia. ");
INSERT INTO spav1602p_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Y aconteció después de esto, que la esposa de su señor puso sus ojos en José, y dijo: Duerme con­migo. ");
INSERT INTO spav1602p_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Y él no quiso, y dijo a la esposa de su señor: He aquí que mi señor no sabe conmigo lo que hay en casa, y ha puesto en mi mano todo lo que tiene: ");
INSERT INTO spav1602p_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","No hay otro mayor que yo en esta casa, y ninguna cosa me ha reservado sino a ti, por cuanto tú eres su esposa; ¿cómo, pues, haría yo este grande mal, y pecaría contra Dios? ");
INSERT INTO spav1602p_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Y sucedió que hablando ella a José cada día, y no escuchándola él para acostarse al lado de ella, o para estar con ella, ");
INSERT INTO spav1602p_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Aconteció que entró él un día en casa para hacer su oficio, y no había nadie de los de casa allí en casa: ");
INSERT INTO spav1602p_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Y ella lo asió por su ropa, diciendo: Acuéstate conmigo. Y él dejó su ropa en la mano de ella, y huyó y salió fuera. ");
INSERT INTO spav1602p_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Y acaeció que cuando vio ella que le había dejado su ropa en sus manos, y había huido fuera, ");
INSERT INTO spav1602p_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","Llamó a los de casa, y habló­les diciendo: Mirad, nos ha traído un hebreo, para que hiciese burla de nosotros: vino él a mí para dormir conmigo, y yo di grandes voces; ");
INSERT INTO spav1602p_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Y viendo que yo alzaba la voz y gritaba, dejó junto a mí su ropa, y huyó, y salióse fuera. ");
INSERT INTO spav1602p_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Y ella puso junto a sí la ropa de él, hasta que vino su señor a su casa. ");
INSERT INTO spav1602p_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Entonces le habló ella seme­jantes palabras, diciendo: El sier­vo hebreo que nos trajiste, vino a mí para deshonrarme; ");
INSERT INTO spav1602p_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Y como yo alcé mi voz y grité, él dejó su ropa junto a mí, y huyó fuera. ");
INSERT INTO spav1602p_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Y sucedió que como oyó su señor las palabras que su esposa le hablara, diciendo: Así me ha tratado tu siervo; encendióse su furor. ");
INSERT INTO spav1602p_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Y tomó su señor a José, y púsole en la casa de la cárcel, donde estaban los presos del rey, y estuvo allí en la casa de la cár­cel. ");
INSERT INTO spav1602p_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Mas el SEÑOR fue con José, y extendió a él su misericordia, y dióle gracia en ojos del principal de la casa de la cárcel. ");
INSERT INTO spav1602p_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Y el principal de la casa de la cárcel entregó en mano de José todos los presos que había en aquella prisión; y todo lo que hacían allí, él lo hacía. ");
INSERT INTO spav1602p_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","No miraba el principal de la cár­cel cosa alguna que en su mano estaba; porque el SEÑOR era con él, y lo que él hacía, el SEÑOR lo prosperaba. ");
INSERT INTO spav1602p_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Y ACONTECIÓ después de estas cosas, que el copero del rey de Egipto y su panadero delinquieron contra su señor el rey de Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Y se enojó Faraón contra dos de sus oficiales, contra el principal de los coperos, y contra el princi­pal de los panaderos: ");
INSERT INTO spav1602p_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Y púsolos en prisión en la casa del capitán de la guardia, en la cárcel, el lugar donde José estaba atado. ");
INSERT INTO spav1602p_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Y el capitán de los de la guar­dia dio cargo de ellos a José, y él les servía: y estuvieron días en la prisión. ");
INSERT INTO spav1602p_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Y ambos soñaron un sueño, cada uno su propio sueño en una misma noche, cada uno conforme a la interpretación de su sueño, el copero y el panadero del rey de Egipto, que estaban arrestados en la prisión. ");
INSERT INTO spav1602p_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Y vino a ellos José por la maña­na, y mirólos, y he aquí que esta­ban tristes. ");
INSERT INTO spav1602p_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Y él preguntó a aquellos eunu­cos de Faraón, que estaban con él en la prisión de la casa de su señor, diciendo: ¿Por qué pare­cen hoy tristes vuestros semblan­tes? ");
INSERT INTO spav1602p_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Y ellos le dijeron: Hemos teni­do un sueño, y no hay quien lo interprete. Entonces les dijo José: ¿No son de Dios las interpretaciones? Contádmelo, os ruego. ");
INSERT INTO spav1602p_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Entonces el principal de los coperos contó su sueño a José, y díjole: En mi sueño, he aquí, una vid estaba delante de mí, ");
INSERT INTO spav1602p_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Y en la vid había tres sarmientos; y ella como que brotaba, y arrojaba su flor, y sus racimos trajeron uvas maduras: ");
INSERT INTO spav1602p_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Y que la copa de Faraón esta­ba en mi mano, y tomaba yo las uvas, y las exprimía en la copa de Faraón, y daba yo la copa en mano de Faraón. ");
INSERT INTO spav1602p_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Y díjole José: Ésta es su interpretación: Los tres sarmientos son tres días: ");
INSERT INTO spav1602p_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Al cabo de tres días Faraón te hará levantar cabeza, y te resti­tuirá a tu puesto: y darás la copa a Faraón en su mano, como solías cuando eras su copero. ");
INSERT INTO spav1602p_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Acuérdate, pues, de mí para contigo cuando tuvieres ese bien, y ruégote que uses conmigo de misericordia, y hagas mención de mí a Faraón, y me saques de esta casa: ");
INSERT INTO spav1602p_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Porque hurtado he sido de la tierra de los hebreos; y tampoco he hecho aquí porqué me hubiesen de poner en la cárcel. ");
INSERT INTO spav1602p_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Y viendo el principal de los panaderos que había declarado para bien, dijo a José: También yo soñaba que veía tres canasti­llos blancos sobre mi cabeza; ");
INSERT INTO spav1602p_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Y en el canastillo más alto había de todas las viandas de Faraón, obra de panadero; y que las aves las comían del canastillo de sobre mi cabeza. ");
INSERT INTO spav1602p_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Entonces respondió José, y dijo: Ésta es su interpretación: Los tres canastillos tres días son: ");
INSERT INTO spav1602p_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Al cabo de tres días quitará Faraón tu cabeza de sobre ti, y te hará colgar en la horca, y las aves comerán tu carne de sobre ti. ");
INSERT INTO spav1602p_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Y aconteció el tercer día, que era el cumpleaños de Faraón, que hizo banquete a todos sus siervos: y alzó la cabeza del principal de los coperos, y la cabeza del prin­cipal de los panaderos, entre sus servidores. ");
INSERT INTO spav1602p_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","E hizo volver a su oficio al principal de los coperos; y dio él la copa en mano de Faraón. ");
INSERT INTO spav1602p_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Mas hizo ahorcar al principal de los panaderos, como lo había interpretado José. ");
INSERT INTO spav1602p_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Y el principal de los coperos no se acordó de José, sino que le olvidó. ");
INSERT INTO spav1602p_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Y ACONTECIÓ que pasados dos años tuvo Faraón un sueño. Parecíale que estaba junto al río; ");
INSERT INTO spav1602p_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Y que del río subían siete vacas, hermosas a la vista, y muy gordas, y pacían en el prado: ");
INSERT INTO spav1602p_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Y que otras siete vacas subían tras ellas del río, de fea vista, y enjutas de carne, y se pararon cerca de las vacas hermosas a la orilla del río: ");
INSERT INTO spav1602p_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Y que las vacas de fea vista y enjutas de carne devoraban a las siete vacas hermosas y muy gor­das. Y despertó Faraón. ");
INSERT INTO spav1602p_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Durmióse de nuevo, y soñó la segunda vez: Que siete espigas llenas y hermosas subían de una caña: ");
INSERT INTO spav1602p_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Y que otras siete espigas menu­das y abatidas del Solano, salían después de ellas: ");
INSERT INTO spav1602p_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Y las siete espigas menudas devoraban a las siete espigas gruesas y llenas. Y despertó Faraón, y he aquí que era sueño. ");
INSERT INTO spav1602p_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Y acaeció que a la mañana esta­ba agitado su espíritu; y envió e hizo llamar a todos los magos de Egipto, y a todos sus sabios: y contóles Faraón sus sueños, mas nohabía quien a Faraón los interpretase. ");
INSERT INTO spav1602p_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Entonces el principal de los coperos habló a Faraón, diciendo: Acuérdome hoy de mis faltas: ");
INSERT INTO spav1602p_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Faraón se enojó contra sus siervos, y a mí me echó a la pri­sión de la casa del capitán de los de la guardia, a mí y al principal de los panaderos: ");
INSERT INTO spav1602p_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Y yo y él vimos un sueño una misma noche: cada uno soñó conforme a la interpretación de su sueño. ");
INSERT INTO spav1602p_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Y estaba allí con nosotros un mozo hebreo, siervo del capi­tán de los de la guardia; y se lo contamos, y él nos interpretó nues­tros sueños, e interpretó a cada uno conforme a su sueño. ");
INSERT INTO spav1602p_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Y aconteció que como él nos interpretó, así fue: a mí me hizo volver a mi puesto, e hizo colgar al otro. ");
INSERT INTO spav1602p_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Entonces Faraón envió y llamó a José, y le sacaron aprisa de la cárcel; y se afeitó y cambió su vestidura, y vino a Faraón. ");
INSERT INTO spav1602p_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Y dijo Faraón a José: Yo he tenido un sueño, y no hay quien lo interprete; mas he oído decir de ti, que oyes sueños para interpretar­los. ");
INSERT INTO spav1602p_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Y respondió José a Faraón, diciendo: No está en mí; Dios será el que responda paz a Faraón. ");
INSERT INTO spav1602p_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Entonces Faraón dijo a José: En mi sueño parecíame que esta­ba a la orilla del río: ");
INSERT INTO spav1602p_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Y que del río subían siete vacas de gruesas carnes y hermo­sa apariencia, que pacían en el prado: ");
INSERT INTO spav1602p_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Y que otras siete vacas subían después de ellas, flacas y de muy fea traza; tan extenuadas, que no he visto otras semejantes en toda la tierra de Egipto en fealdad: ");
INSERT INTO spav1602p_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Y las vacas flacas y feas comían a las siete primeras vacas gruesas: ");
INSERT INTO spav1602p_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Y cuando las habían comido, no se podía saber que las habían comido; porque su parecer era aún malo, como de primero. Entonces yo desperté. ");
INSERT INTO spav1602p_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Vi también soñando, que siete espigas subían en una misma caña llenas y hermosas; ");
INSERT INTO spav1602p_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Y que otras siete espigas menudas, marchitas, y abatidas del Solano, subían después de ellas: ");
INSERT INTO spav1602p_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Y las espigas menudas devo­raban a las siete espigas hermo­sas: y he dicho esto a los magos; mas no hay quien me lo interprete. ");
INSERT INTO spav1602p_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Entonces dijo José a Faraón: El sueño de Faraón es uno mismo: Dios ha mostrado a Faraón lo que está a punto de hacer. ");
INSERT INTO spav1602p_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Las siete vacas hermosas siete años son; y las espigas hermosas son siete años: el sueño es uno mismo. ");
INSERT INTO spav1602p_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","También las siete vacas flacas y feas que subían tras ellas, son siete años; y las siete espigas menudas y marchitas del Solano, siete años serán de hambre. ");
INSERT INTO spav1602p_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Esto es lo que respondo a Faraón. Lo que Dios va a hacer lo ha mostrado a Faraón. ");
INSERT INTO spav1602p_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","He aquí vienen siete años de grande abundancia en toda la tierra de Egipto: ");
INSERT INTO spav1602p_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Y levantarse han tras ellos siete años de hambre; y toda la abundancia será olvidada en la tierra de Egipto; y el hambre consumi­rá la tierra; ");
INSERT INTO spav1602p_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Y aquella abundancia no se echará de ver a causa del hambre siguiente, la cual será gravísima. ");
INSERT INTO spav1602p_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Y el suceder el sueño a Faraón dos veces, es porque la cosa es establecida por Dios, y que Dios se apresura a hacerla. ");
INSERT INTO spav1602p_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Por tanto, provéase ahora Faraón de un varón prudente y sabio, y póngalo sobre la tierra de Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Haga esto Faraón, y ponga gobernadores sobre el país, y tome la quinta parte de la tierra de Egipto en los siete años de abundancia; ");
INSERT INTO spav1602p_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Y junten toda la provisión de estos buenos años que vienen, y alleguen el trigo bajo la mano de Faraón para mantenimiento de las ciudades; y guárdenlo. ");
INSERT INTO spav1602p_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Y esté aquella provisión en depósito para el país, para los siete años del hambre que serán en la tierra de Egipto; y el país no perecerá de hambre. ");
INSERT INTO spav1602p_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Y el negocio pareció bien a Faraón, y a sus siervos. ");
INSERT INTO spav1602p_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Y dijo Faraón a sus siervos: ¿Hemos de hallar otro hombre como éste, en quien está el Espíri­tu de Dios? ");
INSERT INTO spav1602p_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Y dijo Faraón a José: Pues que Dios te ha hecho saber todo esto, no hay entendido ni sabio como tú: ");
INSERT INTO spav1602p_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Tú serás sobre mi casa, y por tu dicho se gobernará todo mi pueblo: solamente en el trono seré yo mayor que tú. ");
INSERT INTO spav1602p_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Dijo más Faraón a José: He aquí yo te he puesto sobre toda la tierra de Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Entonces Faraón quitó su anillo de su mano, y púsolo en la mano de José, e hízole vestir de ropas de lino finísimo, y puso un collar de oro en su cuello; ");
INSERT INTO spav1602p_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","E hízolo subir en su segundo carro, y proclamaron delante de él: Doblad la rodilla: y púsole sobre toda la tierra de Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Y dijo Faraón a José: Yo Faraón; y sin ti ninguno alzará su mano ni su pie en toda la tierra de Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Y llamó Faraón el nombre de José, Zafnat-paaneah; y dióle por esposa a Asenat, hija de Potifera, sacerdote de On. Y salió José por toda la tierra de Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Y era José de edad de treinta años cuando fue presentado delante de Faraón, rey de Egipto: y salió José de delante de Faraón, y transitó por toda la tierra de Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","E hizo la tierra en aquellos siete años de abundancia a montones. ");
INSERT INTO spav1602p_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Y él juntó todo el alimento de los siete años que fueron en la tierra de Egipto, y guardó el alimento en las ciudades, poniendo en las mismas el alimento del campo que estaba alrededor de cada ciudad. ");
INSERT INTO spav1602p_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Y acopió José trigo como arena del mar, mucho en extre­mo, hasta no poderse contar, por­que no tenía número. ");
INSERT INTO spav1602p_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Y nacieron a José dos hijos antes de que vinieran los años de hambre, los cuales le parió Asenat, hija de Potifera, sacerdote de On. ");
INSERT INTO spav1602p_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Y llamó José el nombre del primogénito Manasés; porque Dios, dijo, me hizo olvidar todo mi trabajo, y toda la casa de mi padre. ");
INSERT INTO spav1602p_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Y el nombre del segundo lla­mólo Efraím; porque Dios, dijo, me hizo fértil en la tierra de mi aflicción. ");
INSERT INTO spav1602p_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Y cumpliéronse los siete años de abundancia, que hubo en la tie­rra de Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Y comenzaron a venir los siete años del hambre, como José había dicho: y hubo hambre en todos los países, mas en toda la tierra de Egipto había pan. ");
INSERT INTO spav1602p_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Y cuando se sintió el hambre en toda la tierra de Egipto, el pueblo clamó a Faraón por pan. Y dijo Faraón a todos los egipcios: Id a José, y haced lo que él os dijere. ");
INSERT INTO spav1602p_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Y el hambre estaba por toda la extensión del país. Entonces abrió José todo granero donde había, y vendía a los egipcios; porque había crecido el hambre en la tierra de Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Y toda la tierra venía a Egipto para comprar de José, porque por toda la tierra había crecido el hambre. ");
INSERT INTO spav1602p_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Y VIENDO Jacob que en Egipto había alimentos, Jacob dijo a sus hijos: ¿Por qué os estáis mirando? ");
INSERT INTO spav1602p_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Y dijo: He aquí, yo he oído que hay víveres en Egipto; descended allá, y comprad de allí para nosotros, para que podamos vivir, y no nos muramos. ");
INSERT INTO spav1602p_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Y descendieron los diez herma­nos de José a comprar trigo a Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Mas Jacob no envió a Benjamín hermano de José con sus hermanos; porque dijo: No sea acaso que le acontezca algún desastre. ");
INSERT INTO spav1602p_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Y vinieron los hijos de Israel a comprar granos entre los que venían: porque había hambre en la tierra de Canaán. ");
INSERT INTO spav1602p_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Y José era el gobernador de la tierra, y él era el que vendía a todo el pueblo de la tierra: y llegaron los hermanos de José, e inclináronse a él rostro a tierra. ");
INSERT INTO spav1602p_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Y José como vio a sus herma­nos, conociólos; mas hizo que no los conocía, y hablóles áspera­mente, y les dijo: ¿De dónde habéis venido? Ellos respondie­ron: De la tierra de Canaán a comprar alimentos. ");
INSERT INTO spav1602p_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","José, pues, conoció a sus her­manos; pero ellos no le conocie­ron. ");
INSERT INTO spav1602p_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Entonces se acordó José de los sueños que había tenido de ellos, y díjoles: Espías sois; por ver lo descubierto del país habéis veni­do. ");
INSERT INTO spav1602p_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Y ellos le respondieron: No, señor mío: mas tus siervos han venido a comprar alimentos. ");
INSERT INTO spav1602p_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Todos nosotros somos hijos de un varón: somoshombres de verdad: tus siervos nunca fueron espías. ");
INSERT INTO spav1602p_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Y él les dijo: No; a ver lo des­cubierto del país habéis venido. ");
INSERT INTO spav1602p_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Y ellos respondieron: Tus siervos somos doce hermanos, hijos de un varón en la tierra de Canaán; y he aquí el menor está hoy con nuestro padre, y otro no aparece. ");
INSERT INTO spav1602p_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Y José les dijo: Eso es lo que os he dicho, afirmando que sois espías: ");
INSERT INTO spav1602p_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","En esto seréis probados: Vive Faraón que no saldréis de aquí, sino cuando vuestro hermano menor aquí viniere. ");
INSERT INTO spav1602p_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Enviad uno de vosotros, y traiga a vuestro hermano; y vosotros quedad presos, y vues­tras palabras serán probadas, si hay verdad con vosotros: y si no, vive Faraón, que sois espías. ");
INSERT INTO spav1602p_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Y juntólos en la cárcel por tres días. ");
INSERT INTO spav1602p_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Y al tercer día díjoles José: Haced esto, y vivid; porque yo temo a Dios: ");
INSERT INTO spav1602p_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Si sois hombres de verdad, quede preso en la casa de vuestra cárcel uno de vuestros hermanos; y vosotros id, llevad el alimento para el hambre de vuestra casa: ");
INSERT INTO spav1602p_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Pero habéis de traerme a vuestro hermano menor, y serán verificadas vuestras palabras, y no moriréis. Y ellos lo hicieron así. ");
INSERT INTO spav1602p_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Y decían el uno al otro: Verdaderamente somos culpables acerca de nuestro hermano, en que vimos la angustia de su alma, cuando nos rogaba, y no le oímos; por eso ha venido sobre nosotros esta angustia. ");
INSERT INTO spav1602p_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Entonces Rubén les respon­dió, diciendo: ¿No os hablé yo y dije: No pequéis contra el mozo; y no escuchasteis? He aquí tam­bién su sangre es requerida. ");
INSERT INTO spav1602p_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Y ellos no sabían que los entendía José, porque había intérprete entre ellos. ");
INSERT INTO spav1602p_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Y apartóse él de ellos, y lloró: después volvió a ellos, y les habló, y tomó de entre ellos a Simeón, y aprisionóle a vista de ellos. ");
INSERT INTO spav1602p_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Y mandó José que llenaran sus sacos de trigo, y devolviesen el dinero de cada uno de ellos, poniéndolo en su saco, y les die­sen comida para el camino: e hízose así con ellos. ");
INSERT INTO spav1602p_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Y ellos pusieron su trigo sobre sus asnos, y fuéronse de allí. ");
INSERT INTO spav1602p_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Y abriendo uno de ellos su saco para dar de comer a su asno en el mesón, vio su dinero que estaba en la boca de su costal. ");
INSERT INTO spav1602p_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Y dijo a sus hermanos: Mi dinero se me ha devuelto, y aun he aquí en mi saco. Sobresaltóseles entonces el cora­zón, y espantados dijeron el uno al otro: ¿Qué es esto que nos ha hecho Dios? ");
INSERT INTO spav1602p_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Y venidos a Jacob su padre en tierra de Canaán, contáronle todo lo que les había acaecido, dicien­do: ");
INSERT INTO spav1602p_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Aquel varón, señor de la tie­rra, nos habló ásperamente, y nos trató como a espías de la tierra: ");
INSERT INTO spav1602p_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Y nosotros le dijimos: Somos hombres de verdad, nunca fui­mos espías: ");
INSERT INTO spav1602p_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Somos doce hermanos, hijos de nuestro padre; uno no aparece, y el menor está hoy con nuestro padre en la tierra de Canaán. ");
INSERT INTO spav1602p_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Y aquel varón, señor de la tie­rra, nos dijo: En esto conoceré que sois hombres de verdad; dejad conmigo uno de vuestros hermanos, y tomad alimento para el ham­bre de vuestras casas, y andad, ");
INSERT INTO spav1602p_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Y traedme a vuestro hermano el menor, para que yo sepa que no sois espías, sino hombres de verdad: así os daré a vuestro her­mano, y negociaréis en la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Y aconteció que vaciando ellos sus sacos, he aquí que en el saco de cada uno estaba el atado de su dinero: y viendo ellos y su padre los atados de su dinero, tuvieron temor. ");
INSERT INTO spav1602p_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Entonces su padre Jacob les dijo: Habéisme privado de mis hijos; José no parece, ni Simeón tampoco, y a Benjamín le lleva­réis: contra mí son todas estas cosas. ");
INSERT INTO spav1602p_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Y Rubén habló a su padre, diciendo: Harás morir a mis dos hijos, si no te lo volviere; entré­galo en mi mano, que yo lo vol­veré a ti. ");
INSERT INTO spav1602p_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Y él dijo: No descenderá mi hijo con vosotros; que su herma­no es muerto, y él solo ha queda­do: y si le aconteciere algún desastre en el camino por donde vais, haréis descender mis canas con dolor a la sepultura. ");
INSERT INTO spav1602p_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Y EL hambre era grande en la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Y aconteció que como acaba­ron de comer el trigo que trajeron de Egipto, díjoles su padre: Volved, y comprad para nosotros un poco de alimento. ");
INSERT INTO spav1602p_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Y respondió Judá, diciendo: Aquel varón nos protestó con ánimo resuelto, diciendo: No veréis mi rostro si vuestro hermano noviniere con vosotros. ");
INSERT INTO spav1602p_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Si enviares a nuestro hermano con nosotros, descenderemos y te compraremos alimento: ");
INSERT INTO spav1602p_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Pero si no le enviares, no des­cenderemos: porque aquel varón nos dijo: No veréis mi rostro si vuestro hermano no viniere con vosotros. ");
INSERT INTO spav1602p_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Y dijo Israel: ¿Por qué me hicisteis tanto mal, diciendo al varón que teníais otro hermano? ");
INSERT INTO spav1602p_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Y ellos respondieron: Aquel varón nos preguntó expresamen­te por nosotros, y por nuestra parentela, diciendo: ¿Vive aún vuestro padre? ¿tenéis otro her­mano? y declarámosle conforme a estas palabras. ¿Podíamos nosotros saber que había de decir: Haced venir a vuestro her­mano? ");
INSERT INTO spav1602p_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Entonces Judá dijo a Israel su padre: Envía al mozo conmigo, y nos levantaremos e iremos, a fin que vivamos y no muramos nosotros, y tú, y nuestros niños. ");
INSERT INTO spav1602p_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Yo seré fiador por él; a mí me pedirás cuenta de él: si yo no te lo vol­viere y lo pusiere delante de ti, seré para ti el culpante por siem­pre: ");
INSERT INTO spav1602p_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Que si no nos hubiéramos detenido, cierto ahora hubiéramos ya vuelto dos veces. ");
INSERT INTO spav1602p_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Entonces Israel su padre les respondió: Pues que así es, haced­lo; tomad de lo mejor de la tierra en vuestros vasos, y llevad a aquel varón un presente, un poco de bál­samo, y un poco de miel, aromas y mirra, nueces y almendras. ");
INSERT INTO spav1602p_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Y tomad en vuestras manos doblado dinero, y llevadlo en vues­tra mano el dinero vuelto en las bocas de vuestros costales; quizá fue por error. ");
INSERT INTO spav1602p_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Tomad también a vuestro her­mano, y levantaos, y volved a aquel varón. ");
INSERT INTO spav1602p_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Y el Dios Todopoderoso os dé misericordias delante de aquel varón, y os suelte al otro vuestro hermano, y a este Benjamín. Y si he de ser privado de mis hijos, séalo. ");
INSERT INTO spav1602p_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Entonces tomaron aquellos varones el presente, y tomaron en su mano doblado dinero, y a Benjamín; y se levantaron, y des­cendieron a Egipto, y presentá­ronse delante de José. ");
INSERT INTO spav1602p_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Y vio José a Benjamín con ellos, y dijo al mayordomo de su casa: Mete en casa a estos hom­bres, y degüella víctima, y aderé­zala; porque estos hombres comerán conmigo al medio día. ");
INSERT INTO spav1602p_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","E hizo el hombre como José dijo; y metió aquel hombre a los hombres en casa de José. ");
INSERT INTO spav1602p_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Y aquellos hombres tuvieron temor, cuando fueron metidos en casa de José, y decían: Por el dinero que fue vuelto en nuestros costales la primera vez nos han metido aquí, para revolver contra nosotros, y dar sobre nosotros, y tomarnos por siervos a nosotros, y a nuestros asnos. ");
INSERT INTO spav1602p_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Y llegáronse al mayordomo de la casa de José, y le hablaron a la entrada de la casa. ");
INSERT INTO spav1602p_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Y dijeron: Ay, señor mío, nosotros en realidad de verdad descendimos al principio a com­prar alimentos: ");
INSERT INTO spav1602p_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Y aconteció que como vini­mos al mesón y abrimos nuestros costales, he aquí el dinero de cada uno estaba en la boca de su costal, nuestro dinero en su justo peso; y hémoslo vuelto en nues­tras manos. ");
INSERT INTO spav1602p_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Hemos también traído en nuestras manos otro dinero para comprar alimentos: nosotros no sabemos quién haya puesto nuestro dinero en nuestros costa­les. ");
INSERT INTO spav1602p_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Y él respondió: Paz sea a vo­sotros, no temáis; vuestro Dios y el Dios de vuestro padre os dio el tesoro en vuestros costales: vues­tro dinero vino a mí. Y sacó a Simeón a ellos. ");
INSERT INTO spav1602p_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Y metió aquel varón a aque­llos hombres en casa de José: y dióles agua, y lavaron sus pies: y dio de comer a sus asnos. ");
INSERT INTO spav1602p_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Y ellos prepararon el presente entretanto que venía José al medio día, porque habían oído que allí habían de comer pan. ");
INSERT INTO spav1602p_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Y vino José a casa, y ellos le trajeron el presente que tenían en su mano dentro de casa, e incli­náronse a él hasta tierra. ");
INSERT INTO spav1602p_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Entonces les preguntó él cómo estaban, y dijo: ¿Vuestro padre, el anciano que dijisteis, está bien? ¿vive todavía? ");
INSERT INTO spav1602p_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Y ellos respondieron: Bien va a tu siervo nuestro padre; aun vive. Y se inclinaron, e hicieron reverencia. ");
INSERT INTO spav1602p_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Y alzando él sus ojos vio a Benjamín su hermano, hijo de su madre, y dijo: ¿Es éste vuestro hermano menor, de quien me hablasteis? Y dijo: Dios tenga misericordia de ti, hijo mío. ");
INSERT INTO spav1602p_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Entonces José se apresuró, porque se conmovieron sus entrañas a causa de su hermano, y procuró donde llorar: y entróse en su cámara, y lloró allí. ");
INSERT INTO spav1602p_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Y lavó su rostro, y salió fuera, y reprimióse, y dijo: Poned pan. ");
INSERT INTO spav1602p_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Y pusieron para él aparte, y separadamente para ellos, y apar­te para los egipcios que con él comían: porque los egipcios no pueden comer pan con los hebreos, lo cual es abominación a los egipcios. ");
INSERT INTO spav1602p_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Y sentáronse delante de él, el mayor conforme a su mayoría, y el menor conforme a su menoría; y estaban aquellos hombres ató­nitos mirándose el uno al otro. ");
INSERT INTO spav1602p_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Y él tomó y envió viandas de delante de sí para ellos; mas la porción de Benjamín era cinco veces como cualquiera de las de ellos. Y bebieron, y alegráronse con él. ");
INSERT INTO spav1602p_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Y MANDÓ José al mayordomo de su casa, diciendo: Hinche los costales de aquestos varones con alimentos, cuanto pudieren llevar, y pon el dinero de cada uno en la boca de su costal: ");
INSERT INTO spav1602p_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Y pondrás mi copa, la copa de plata, en la boca del costal del menor, con el dinero de su trigo. Y él hizo como dijo José. ");
INSERT INTO spav1602p_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Venida la mañana, los hombres fueron despedidos con sus asnos. ");
INSERT INTO spav1602p_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Habiendo ellos salido de la ciu­dad, de la que aun no se habían alejado, dijo José a su mayordo­mo: Levántate, y sigue a esos hombres; y cuando los alcanza­res, diles: ¿Por qué habéis vuelto mal por bien? ");
INSERT INTO spav1602p_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","¿No es ésta la copa en la que bebe mi señor, y por la que suele adivi­nar? habéis hecho mal en lo que hicisteis. ");
INSERT INTO spav1602p_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Y como él los alcanzó díjoles estas palabras. ");
INSERT INTO spav1602p_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Y ellos le respondieron: ¿Por qué dice mi señor tales cosas? No lo permita Dios que tus siervos hagan según esta cosa. ");
INSERT INTO spav1602p_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","He aquí, el dinero que halla­mos en la boca de nuestros costales, te lo volvimos a traer desde la tierra de Canaán; ¿cómo, pues, habíamos de hurtar de casa de tu señor plata ni oro? ");
INSERT INTO spav1602p_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Aquel de tus siervos en quien fuere hallada la copa, que muera, y aun nosotros seremos siervos de mi señor. ");
INSERT INTO spav1602p_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Y él dijo: También ahora sea conforme a vuestras palabras; aquél en quien se hallare, será mi siervo, y vosotros seréis sin culpa. ");
INSERT INTO spav1602p_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Ellos entonces se dieron prisa, y derribando cada uno su costal en tierra, abrió cada cual el costal suyo. ");
INSERT INTO spav1602p_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Y él buscó; desde el mayor comenzó, y acabó en el menor; y la copa fue hallada en el costal de Benjamín. ");
INSERT INTO spav1602p_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Entonces ellos rasgaron sus vestiduras, y cargó cada uno su asno, y volvieron a la ciudad. ");
INSERT INTO spav1602p_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Y llegó Judá con sus herma­nos a casa de José, que aun esta­ba allí, y postráronse delante de él en tierra. ");
INSERT INTO spav1602p_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Y díjoles José: ¿Qué obra es ésta que habéis hecho? ¿no sabéis que un hombre como yo sabe adivinar? ");
INSERT INTO spav1602p_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Entonces dijo Judá: ¿Qué diremos a mi señor? ¿qué habla­remos? ¿o con qué nos justifica­remos? Dios ha hallado la mal­dad de tus siervos: he aquí, noso­tros somos siervos de mi señor, nosotros, y también aquél en cuyo poder fue hallada la copa. ");
INSERT INTO spav1602p_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Y él respondió: No permita Dios que yo haga tal: sino el varón en cuyo poder fue hallada la copa, él será mi siervo; vosotros id en paz a vuestro padre. ");
INSERT INTO spav1602p_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Entonces Judá se llegó a él, y dijo: Ay señor mío, ruégote que hable tu siervo una palabra en oídos de mi señor, y no se encien­da tu enojo contra tu siervo, pues que tú eres como Faraón. ");
INSERT INTO spav1602p_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Mi señor preguntó a sus sier­vos, diciendo: ¿Tenéis padre o hermano? ");
INSERT INTO spav1602p_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Y nosotros respondimos a mi señor: Tenemos un padre ancia­no, y un mozo que le nació en su vejez, pequeño aún; y un herma­no suyo murió, y él quedó solo de su madre, y su padre lo ama. ");
INSERT INTO spav1602p_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Y tú dijiste a tus siervos: Traédmelo, y pondré mis ojos sobre él. ");
INSERT INTO spav1602p_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Y nosotros dijimos a mi señor: El mozo no puede dejar a su padre, porque si le dejare, su padre morirá. ");
INSERT INTO spav1602p_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Y dijiste a tus siervos: Si vues­tro hermano menor no descendie­re con vosotros, no veáis más mi rostro. ");
INSERT INTO spav1602p_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Aconteció pues, que como llegamos a mi padre tu siervo, contámosle las palabras de mi señor. ");
INSERT INTO spav1602p_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Y dijo nuestro padre: Volved, y compradnos un poco de alimento. ");
INSERT INTO spav1602p_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Y nosotros respondimos: No podemos ir: si nuestro hermano fuere con nosotros, iremos; por­que no podemos ver el rostro del varón, si nuestro hermano el menor no estuviere con nosotros. ");
INSERT INTO spav1602p_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Entonces tu siervo mi padre nos dijo: Vosotros sabéis que dos hijos me parió mi esposa; ");
INSERT INTO spav1602p_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Y el uno salió de conmigo, y pienso de cierto que fue despeda­zado, y hasta ahora no le he visto; ");
INSERT INTO spav1602p_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Y si tomareis también éste de delante de mí, y le aconteciere algún desastre, haréis descender mis canas con dolor a la sepultu­ra. ");
INSERT INTO spav1602p_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Ahora, pues, cuando llegare yo a tu siervo mi padre, y el mozo no fuere conmigo, como su alma está ligada al alma de él, ");
INSERT INTO spav1602p_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","Sucederá que cuando no vea al mozo, morirá: y tus siervos harán descender las canas de tu siervo nuestro padre con dolor a la sepultura. ");
INSERT INTO spav1602p_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Como tu siervo salió por fia­dor del mozo con mi padre, diciendo: Si no te lo volviere, entonces yo seré culpable para mi padre por siempre; ");
INSERT INTO spav1602p_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Ruégote por tanto que quede ahora tu siervo por el mozo por siervo de mi señor, y que el mozo vaya con sus hermanos. ");
INSERT INTO spav1602p_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Porque ¿cómo iré yo a mi padre si el mozo no está conmigo? No podré, por no ver el mal que sobrevendrá a mi padre. ");
INSERT INTO spav1602p_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","NO podía ya José contenerse delante de todos los que estaban al lado suyo, y clamó: Haced salir de conmigo a todos. Y no quedó nadie con él, al darse a conocer José a sus hermanos. ");
INSERT INTO spav1602p_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Entonces se dio a llorar a voz en grito; y oyeron los egipcios, y oyó también la casa de Faraón. ");
INSERT INTO spav1602p_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Y dijo José a sus hermanos: Yo soy José: ¿vive aún mi padre? Y sus hermanos no pudieron res­ponderle, porque estaban turba­dos delante de él. ");
INSERT INTO spav1602p_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Entonces dijo José a sus her­manos: Acercaos ahora a mí. Y ellos se acercaron. Y él dijo: Yo soy José vuestro hermano el que vendisteis para Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Ahora pues, no os entristezcáis, ni os pese de haberme vendido acá; que para preservación de vida me envió Dios delante de vosotros: ");
INSERT INTO spav1602p_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Que ya ha habido dos años de hambre en la tierra, y aun quedan cinco años en que ni habrá arada ni siega. ");
INSERT INTO spav1602p_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Y Dios me envió delante de vosotros, para preservaros poste­ridad en la tierra, y para daros vida por medio de grande salva­mento. ");
INSERT INTO spav1602p_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Así pues, no fuisteis vosotros que me enviasteis acá, sino Dios, que me ha puesto por padre de Faraón, y por señor de toda su casa, y por gobernador en toda la tierra de Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Daos priesa, id a mi padre y decidle: Así dice tu hijo José: Dios me ha puesto por señor de todo Egipto; ven a mí, no te detengas: ");
INSERT INTO spav1602p_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Y habitarás en la tierra de Gosén, y estarás cerca de mí, tú y tus hijos, y los hijos de tus hijos, tus ganados y tus vacas, y todo lo que tienes. ");
INSERT INTO spav1602p_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Y allí te alimentaré, pues aun quedan cinco años de hambre, porque no perezcas de pobreza tú y tu casa, y todo lo que tienes: ");
INSERT INTO spav1602p_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Y he aquí, vuestros ojos ven, y los ojos de mi hermano Benjamín, que es mi boca que os habla. ");
INSERT INTO spav1602p_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Haréis pues saber a mi padre toda mi gloria en Egipto, y todo lo que habéis visto: y daos prie­sa, y traed a mi padre acá. ");
INSERT INTO spav1602p_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Y echóse sobre el cuello de Benjamín su hermano, y lloró; y también Benjamín lloró sobre su cuello. ");
INSERT INTO spav1602p_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Y besó a todos sus hermanos, y lloró sobre ellos: y después sus hermanos hablaron con él. ");
INSERT INTO spav1602p_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Y oyóse la noticia en la casa de Faraón, diciendo: Los herma­nos de José han venido. Y plugo en los ojos de Faraón y de sus siervos. ");
INSERT INTO spav1602p_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Y dijo Faraón a José: Di a tus hermanos: Haced esto: cargad vuestras bestias, e id, volved a la tierra de Canaán; ");
INSERT INTO spav1602p_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Y tomad a vuestro padre y vuestras familias, y venid a mí, que yo os daré lo bueno de la tie­rra de Egipto y comeréis la gro­sura de la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Y tú manda: Haced esto: tomaos de la tierra de Egipto carros para vuestros niños y vues­tras esposas; y tomad a vuestro padre, y venid. ");
INSERT INTO spav1602p_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Y no se os dé nada de vuestras alhajas, porque el bien de la tierra de Egipto será vuestro. ");
INSERT INTO spav1602p_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","E hiciéronlo así los hijos de Israel: y dióles José carros conforme a la orden de Faraón, y suministróles víveres para el camino. ");
INSERT INTO spav1602p_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","A cada uno de todos ellos dio mudas de vestiduras, y a Benjamín dio trescientas piezas de plata, y cinco mudas de vestiduras. ");
INSERT INTO spav1602p_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Y a su padre envió esto: diez asnos cargados de lo mejor de Egipto, y diez asnas cargadas de trigo, y pan y comida para su padre en el camino. ");
INSERT INTO spav1602p_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Y despidió a sus hermanos, y fuéronse. Y él les dijo: No riñáis por el camino. ");
INSERT INTO spav1602p_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Y subieron de Egipto, y llega­ron a la tierra de Canaán a Jacob su padre. ");
INSERT INTO spav1602p_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Y diéronle las nuevas, dicien­do: José vive aún; y él es gobernador en toda la tierra de Egipto. Y su corazón se desmayó; pues no los creía. ");
INSERT INTO spav1602p_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Y ellos le contaron todas las palabras de José, que él les había hablado; y viendo él los carros que José enviaba para llevarlo, el espíritu de Jacob su padre revi­vió. ");
INSERT INTO spav1602p_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Entonces dijo Israel: Basta: José mi hijo está vivo todavía: iré, y le veré antes que yo muera. ");
INSERT INTO spav1602p_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Y PARTIÓSE Israel con todo lo que tenía, y vino a Beerseba, y ofreció sacrificios al Dios de su padre Isaac. ");
INSERT INTO spav1602p_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Y habló Dios a Israel en visiones de noche, y dijo: Jacob, Jacob. Y él respondió: Heme aquí. ");
INSERT INTO spav1602p_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Y dijo: Yo soy Dios, el Dios de tu padre; no temas de descen­der a Egipto, porque yo haré de ti allí una gran nación. ");
INSERT INTO spav1602p_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Yo descenderé contigo a Egipto, y yo también te haré vol­ver: y José pondrá su mano sobre tus ojos. ");
INSERT INTO spav1602p_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Y levantóse Jacob de Beerseba; y tomaron los hijos de Israel a su padre Jacob, y a sus niños, y a sus esposas, en los carros que Faraón había enviado para llevarlo. ");
INSERT INTO spav1602p_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Y tomaron sus ganados, y su hacienda que había adquirido en la tierra de Canaán, y viniéronse a Egipto, Jacob, y toda su simiente consigo; ");
INSERT INTO spav1602p_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Sus hijos, y los hijos de sus hijos consigo; sus hijas, y las hijas de sus hijos, y a toda su simiente trajo consigo a Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Y estos son los nombres de los hijos de Israel, que entraron en Egipto, Jacob y sus hijos: Rubén, el primogénito de Jacob. ");
INSERT INTO spav1602p_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Y los hijos de Rubén: Enoc, y Falú, y Hezrón, y Carmi. ");
INSERT INTO spav1602p_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Y los hijos de Simeón: Jemuel, y Jamín, y Ohad, y Jaquín, y Zohar, y Saúl, hijo de la cananea. ");
INSERT INTO spav1602p_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Y los hijos de Leví: Gersón, y Coat, y Merari. ");
INSERT INTO spav1602p_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Y los hijos de Judá: Er, y Onán, y Sela, y Fares, y Zara: mas Er y Onán murieron en la tierra de Canaán. Y los hijos de Fares fueron Hezrón y Hamul. ");
INSERT INTO spav1602p_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Y los hijos de Isacar: Tola, y Fúa, y Job, y Simrón. ");
INSERT INTO spav1602p_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Y los hijos de Zabulón: Sered, y Elón, y Jahleel. ");
INSERT INTO spav1602p_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Éstos fueron los hijos de Lea, los que parió a Jacob en Padan-­aram, y además su hija Dina: todas las almas de sus hijos y sus hijas fueron treinta y tres. ");
INSERT INTO spav1602p_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Y los hijos de Gad: Zifión, y Aggi, y Ezbón, y Suni, y Heri, y Arodi, y Areli. ");
INSERT INTO spav1602p_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Y los hijos de Aser: Jimna, e Isua, e Isui, y Beria, y Sera, her­mana de ellos. Los hijos de Beria: Heber, y Malquiel. ");
INSERT INTO spav1602p_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Éstos son los hijos de Zilpa, la que Labán dio a su hija Lea, y parió estos a Jacob; todas diez y seis almas. ");
INSERT INTO spav1602p_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Y los hijos de Raquel, esposa de Jacob: José y Benjamín. ");
INSERT INTO spav1602p_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Y nacieron a José en la tierra de Egipto Manasés y Efraím, los que le parió Asenat, hija de Potifera, sacerdote de On. ");
INSERT INTO spav1602p_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Y los hijos de Benjamín fue­ron Bela, y Bequer y Asbel, y Gera, y Naamán, y Ehi, y Ros y Mupim, y Hupim, y Ard. ");
INSERT INTO spav1602p_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Éstos son los hijos de Raquel, que nacieron a Jacob: todas las almas fueron catorce. ");
INSERT INTO spav1602p_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Y los hijos de Dan: Husim. ");
INSERT INTO spav1602p_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Y los hijos de Neftalí: Jahzeel, y Guni, y Jezer, y Silem. ");
INSERT INTO spav1602p_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Éstos son los hijos de Bilha, la que dio Labán a Raquel su hija, y parió estos a Jacob; todas las almas fueron siete. ");
INSERT INTO spav1602p_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Todas las almas que vinieron con Jacob a Egipto, procedentes de sus lomos, sin las esposas de los hijos de Jacob, todas las almas fueron sesenta y seis. ");
INSERT INTO spav1602p_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Y los hijos de José, que le nacieron en Egipto, fueron dos almas. Todas las almas de la casa de Jacob, que entraron en Egipto, fueron setenta. ");
INSERT INTO spav1602p_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Y envió a Judá delante de sí a José, para que le viniese a ver a Gosén; y llegaron a la tierra de Gosén. ");
INSERT INTO spav1602p_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Y José unció su carro y vino a recibir a Israel su padre a Gosén; y se manifestó a él, y echóse sobre su cuello, y lloró sobre su cuello bastante. ");
INSERT INTO spav1602p_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Entonces Israel dijo a José: Muera yo ahora, ya que he visto tu rostro, pues aún vives. ");
INSERT INTO spav1602p_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Y José dijo a sus hermanos, y a la casa de su padre: Subiré y haré saber a Faraón, y diréle: Mis hermanos y la casa de mi padre, que estaban en la tierra de Canaán, han venido a mí; ");
INSERT INTO spav1602p_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Y los hombres son pastores de ovejas, porque son hombres ganaderos; y han traído sus ove­jas y sus vacas, y todo lo que tenían. ");
INSERT INTO spav1602p_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Y cuando Faraón os llamare y dijere: ¿cuál es vuestro oficio? ");
INSERT INTO spav1602p_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Entonces diréis: Hombres de ganadería han sido tus siervos desde nuestra mocedad hasta ahora, nosotros y nuestros padres; a fin que moréis en la tierra de Gosén, porque los egipcios abo­minan a todo pastor de ovejas. ");
INSERT INTO spav1602p_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Y JOSÉ vino, e hizo saber a Faraón, y dijo: Mi padre y mis hermanos, y sus ovejas y sus vacas, con todo lo que tienen, han venido de la tierra de Canaán, y he aquí, están en la tierra de Gosén. ");
INSERT INTO spav1602p_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Y él tomó algunos de sus hermanos, aún cinco hombres, y los presentó a Faraón. ");
INSERT INTO spav1602p_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Y Faraón dijo a sus hermanos: ¿Cuál es vuestro oficio? Y ellos respondieron a Faraón: Pastores de ovejas son tus siervos, así nosotros como nuestros padres. ");
INSERT INTO spav1602p_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Dijeron además a Faraón: Por morar en esta tierra hemos veni­do; porque no hay pasto para las ovejas de tus siervos, pues el hambre es grave en la tierra de Canaán: por tanto, te rogamos ahora que habiten tus siervos en la tierra de Gosén. ");
INSERT INTO spav1602p_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Entonces Faraón habló a José, diciendo: Tu padre y tus herma­nos han venido a ti; ");
INSERT INTO spav1602p_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","La tierra de Egipto delante de ti está; en lo mejor de la tierra haz habitar a tu padre y a tus herma­nos; habiten en la tierra de Gosén; y si entiendes que hay entre ellos hombres eficaces, ponlos por mayorales del ganado mío. ");
INSERT INTO spav1602p_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Y José introdujo a su padre, y presentólo delante de Faraón; y Jacob bendijo a Faraón. ");
INSERT INTO spav1602p_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Y dijo Faraón a Jacob: ¿Cuántos son los días de los años de tu vida? ");
INSERT INTO spav1602p_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Y Jacob respondió a Faraón: Los días de los años de mi pere­grinación son ciento treinta años; pocos y malos han sido los días de los años de mi vida, y no han llegado a los días de los años de la vida de mis padres en los días de su peregrinación. ");
INSERT INTO spav1602p_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Y Jacob bendijo a Faraón, y salióse de delante de Faraón. ");
INSERT INTO spav1602p_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Así José hizo habitar a su padre y a sus hermanos, y dióles posesión en la tierra de Egipto, en lo mejor de la tierra, en la tie­rra de Rameses como mandó Faraón. ");
INSERT INTO spav1602p_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Y alimentaba José a su padre y a sus hermanos, y a toda la casa de su padre, de pan, según sus familias. ");
INSERT INTO spav1602p_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Y no había pan en toda la tie­rra, y el hambre era muy grave; por lo que desfalleció de hambre la tierra de Egipto y toda la tierra de Canaán. ");
INSERT INTO spav1602p_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Y recogió José todo el dinero que se halló en la tierra de Egipto y en la tierra de Canaán, por los alimentos que de él compraban; y metió José el dinero en casa de Faraón. ");
INSERT INTO spav1602p_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Y acabado el dinero de la tie­rra de Egipto y de la tierra de Canaán, vino todo Egipto a José, diciendo: Danos pan: ¿por qué moriremos delante de ti, por haberse acabado el dinero? ");
INSERT INTO spav1602p_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Y José dijo: Dad vuestros ganados, y yo os daré por vues­tros ganados, si se ha acabado el dinero. ");
INSERT INTO spav1602p_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Y ellos trajeron sus ganados a José; y José les dio alimentos en cambio por caballos, y por el ganado de las ovejas, y por el ganado de las vacas, y por asnos: y sustentólos de pan por todos sus ganados aquel año. ");
INSERT INTO spav1602p_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Y acabado aquel año, vinieron a él el segundo año, y le dijeron: No lo encubriremos a nuestro señor que el dinero ciertamente se ha acabado; también el ganado es ya de nuestro señor; nada ha que­dado delante de nuestro señor sino nuestros cuerpos y nuestra tierra. ");
INSERT INTO spav1602p_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","¿Por qué moriremos delante de tus ojos, así nosotros como nuestra tierra? Cómpranos a nosotros y a nuestra tierra por pan, y seremos nosotros y nues­tra tierra siervos de Faraón: y danos simiente para que vivamos y no muramos, y no sea asolada la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Entonces compró José toda la tierra de Egipto para Faraón; pues los egipcios vendieron cada uno sus tierras, porque se agravó el hambre sobre ellos: y la tierra vino a ser de Faraón. ");
INSERT INTO spav1602p_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Y al pueblo hízolo pasar a las ciudades desde el un cabo del término de Egipto hasta el otro cabo. ");
INSERT INTO spav1602p_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Solamente la tierra de los sacerdotes no compró, porque los sacerdotes tenían una porción señalada a ellos de Faraón, y ellos comían su porción que Faraón les daba: por eso no vendieron su tierra. ");
INSERT INTO spav1602p_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Y José dijo al pueblo: He aquí os he hoy comprado y a vuestra tierra para Faraón: ved aquí hay simiente, y sembraréis la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Y será que de los frutos daréis la quinta parte a Faraón, y las cuatro partes serán vuestras para sem­brar las tierras, y para vuestro mantenimiento, y de los que están en vuestras casas, y para que coman vuestros niños. ");
INSERT INTO spav1602p_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Y ellos respondieron: La vida nos has dado: hallemos gracia en ojos de mi señor, y seamos sier­vos de Faraón. ");
INSERT INTO spav1602p_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Y José lo puso por ley sobre la tierra de Egipto hasta hoy, que Faraón debería tener la quinta parte; excepto sólo la tierra de los sacerdotes, que no fue de Faraón. ");
INSERT INTO spav1602p_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Así habitó Israel en la tierra de Egipto, en la tierra de Gosén; y aposesionáronse en ella, y se aumentaron, y multiplicaron en gran manera. ");
INSERT INTO spav1602p_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Y vivió Jacob en la tierra de Egipto diecisiete años: y fueron los días de Jacob, los años de su vida, ciento cuarenta y siete años. ");
INSERT INTO spav1602p_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Y llegáronse los días de Israel para morir, y llamó a José su hijo, y le dijo: Si he hallado ahora gracia en tus ojos, ruégote que pongas tu mano debajo de mi muslo, y harás conmigo miseri­cordia y verdad; ruégote que no me entierres en Egipto; ");
INSERT INTO spav1602p_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Mas cuando durmiere con mis padres, llevarme has de Egipto, y me sepultarás en el sepulcro de ellos. Y él respondió: Yo haré como tú dices. ");
INSERT INTO spav1602p_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Y él dijo: Júramelo. Y él le juró. Entonces Israel se inclinó sobre la cabecera de la cama. ");
INSERT INTO spav1602p_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Y SUCEDIÓ después de estas cosas que alguien dijo a José: He aquí tu padre está enfermo. Y él tomó consigo sus dos hijos Manasés y Efraím. ");
INSERT INTO spav1602p_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Y alguien contó a Jacob, dicien­do: He aquí tu hijo José viene a ti. Entonces se esforzó Israel, y sentóse sobre la cama; ");
INSERT INTO spav1602p_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Y Jacob dijo a José: El Dios Todopoderoso me apareció en Luz en la tierra de Canaán, y me bendijo, ");
INSERT INTO spav1602p_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Y díjome: He aquí, yo te haré crecer, y te multiplicaré, y te pon­dré por estirpe de pueblos: y daré esta tierra a tu simiente después de ti por heredad perpetua. ");
INSERT INTO spav1602p_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Y ahora tus dos hijos Efraím y Manasés, que te nacieron en la tierra de Egipto, antes que vinie­se a ti a la tierra de Egipto, míos son; como Rubén y Simeón, serán míos: ");
INSERT INTO spav1602p_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Y los que después de ellos has engendrado, serán tuyos; y por el nombre de sus hermanos serán llamados en sus heredades. ");
INSERT INTO spav1602p_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Y en cuanto a mí, cuando yo venía de Padan, se me murió Raquel en la tierra de Canaán, en el camino, cuando había todavía un pequeño camino para llegar a Efrata; y la sepulté allí en el camino de Efrata, que es Belem. ");
INSERT INTO spav1602p_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Y vio Israel los hijos de José, y dijo: ¿Quiénes son éstos? ");
INSERT INTO spav1602p_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Y respondió José a su padre: Son mis hijos, que Dios me ha dado en este lugar. Y él dijo: Allégalos ahora a mí, y los bendeciré. ");
INSERT INTO spav1602p_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Y los ojos de Israel estaban tan agravados de la vejez, que no podía ver. Hízoles, pues, llegar a él, y él los besó y abrazó. ");
INSERT INTO spav1602p_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Y dijo Israel a José: No pen­saba yo ver tu rostro, y he aquí Dios me ha hecho ver también tu simiente. ");
INSERT INTO spav1602p_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Entonces José los sacó de entre sus rodillas, e inclinóse a tierra. ");
INSERT INTO spav1602p_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Y tomólos José a ambos, Efraím a su diestra, a la sinies­tra de Israel; y a Manasés a su izquierda, a la derecha de Israel; e hízoles llegar a él. ");
INSERT INTO spav1602p_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Entonces Israel extendió su diestra, y púsola sobre la cabeza de Efraím, que era el menor, y su siniestra sobre la cabeza de Manasés, colocando así sus manos adrede, aunque Manasés era el primogénito. ");
INSERT INTO spav1602p_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Y bendijo a José, y dijo: El Dios en cuya presencia anduvie­ron mis padres Abraham e Isaac, el Dios que me mantiene desde que yo soy hasta este día, ");
INSERT INTO spav1602p_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","El Ángel que me liberta de todo mal, bendiga a estos mozos: y mi nombre sea llamado en ellos, y el nombre de mis padres Abraham e Isaac: y multipliquen en gran manera en medio de la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Entonces viendo José que su padre ponía la mano derecha sobre la cabeza de Efraím, cau­sóle esto disgusto; y asió la mano de su padre, para mudarla de sobre la cabeza de Efraím a la cabeza de Manasés. ");
INSERT INTO spav1602p_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Y dijo José a su padre: No así, padre mío, porque éste es el pri­mogénito; pon tu diestra sobre su cabeza. ");
INSERT INTO spav1602p_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Mas su padre no quiso, y dijo: Lo sé, hijo mío, lo sé: también él vendrá a ser un pueblo, y será también acrecentado; pero su hermano menor será más grande que él, y su simiente será pleni­tud de naciones. ");
INSERT INTO spav1602p_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Y bendíjolos aquel día, diciendo: En ti bendecirá Israel, diciendo: Hágate Dios como a Efraím y como a Manasés. Y puso a Efraím delante de Manasés. ");
INSERT INTO spav1602p_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Y dijo Israel a José: He aquí, yo muero, mas Dios será con vosotros, y os hará volver a la tie­rra de vuestros padres. ");
INSERT INTO spav1602p_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Y yo te he dado a ti una parte sobre tus hermanos, la cual tomé yo de mano del amorreo con mi espada y con mi arco. ");
INSERT INTO spav1602p_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Y LLAMÓ Jacob a sus hijos, y dijo: Juntaos, y os declararé lo que os ha de acontecer en los postreros días. ");
INSERT INTO spav1602p_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Juntaos y oíd, hijos de Jacob; Y escuchad a vuestro padre Israel. ");
INSERT INTO spav1602p_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Rubén, tú eres mi primogénito, mi fortaleza, y el principio de mi vigor; principal en dignidad, principal en poder. ");
INSERT INTO spav1602p_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Inestable como el agua, no serás el principal; por cuanto subiste al lecho de tu padre: entonces te envileciste, subiendo a mi estrado. ");
INSERT INTO spav1602p_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeón y Leví son hermanos; instrumentos de crueldad son sus habitaciones. ");
INSERT INTO spav1602p_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","En su secreto no entre mi alma, ni mi honra se junte en su asamblea; que en su furor mataron varón, y en su voluntad arranca­ron muro. ");
INSERT INTO spav1602p_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Maldito sea su furor, que fue fiero; y su ira, que fue dura: yo los dividiré en Jacob, y los esparciré en Israel. ");
INSERT INTO spav1602p_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Judá, tú eres quien tus hermanos alabarán: tu mano será en la cerviz de tus enemigos: los hijos de tu padre se inclinarán a ti. ");
INSERT INTO spav1602p_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Judá es un cachorro de león: de la presa subiste, hijo mío: encorvó­se, echóse como león, así como león viejo; ¿quién lo despertará? ");
INSERT INTO spav1602p_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","No será quitado el cetro de Judá, y el legislador de entre sus pies, hasta que venga Silo; Y a él se congregarán los pueblos. ");
INSERT INTO spav1602p_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Atando a la vid su pollino, y a la cepa el hijo de su asna, lavó en el vino su vestidura, y en la sangre de uvas su manto: ");
INSERT INTO spav1602p_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Sus ojos serán bermejos del vino, y los dientes blancos de la leche. ");
INSERT INTO spav1602p_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zabulón en puertos de mar habitará, y será para puerto de navíos; y su término será hasta Sidón. ");
INSERT INTO spav1602p_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isacar, es asno fuerte echa­do entre dos tercios: ");
INSERT INTO spav1602p_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Y vio que el descanso era bueno, y que la tierra era agradable; y bajó su hombro para llevar, y sirvió en tributo. ");
INSERT INTO spav1602p_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan juzgará a su pueblo, como una de las tribus de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Será Dan serpiente junto al camino, cerasta junto a la senda, que muerde los talones de los caballos, y hace caer por detrás al cabalgador de ellos. ");
INSERT INTO spav1602p_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","He esperado tu salvación, oh SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad, ejército lo acometerá; mas él acometerá al fin. ");
INSERT INTO spav1602p_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","El pan de Aser será grueso, y él dará deleites al rey. ");
INSERT INTO spav1602p_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Neftalí, es cierva dejada, que dará palabras hermosas. ");
INSERT INTO spav1602p_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","José es un ramo fructífero, aún un ramo fructífero junto a un pozo, cuyos ramos se extienden sobre el muro. ");
INSERT INTO spav1602p_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Los arqueros le agraviaron mucho, y le asaetearon a él, y le aborrecieron: ");
INSERT INTO spav1602p_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Mas su arco quedó en fortale­za, y los brazos de sus manos se corroboraron por las manos del poderoso Dios de Jacob, (de allí es el pastor, y la piedra de Israel,) ");
INSERT INTO spav1602p_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Por el Dios de tu padre, el cual te ayudará, y por el Todopoderoso, el cual te bendecirá con bendi­ciones del cielo de arriba, con bendiciones del abismo que está abajo, con bendiciones del seno y de la matriz. ");
INSERT INTO spav1602p_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Las bendiciones de tu padre prevalecieron más que las bendiciones de mis progenitores, hasta el término de los collados eternos serán sobre la cabeza de José, y sobre la mollera del que fue separado de sus hermanos. ");
INSERT INTO spav1602p_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjamín arrebatará como un lobo: en la mañana devorará la presa, y a la tarde repartirá los despojos. ");
INSERT INTO spav1602p_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Todos estos fueron las doce tribus de Israel: y esto fue lo que su padre les dijo, y bendíjolos: a cada uno por su bendición los bendijo. ");
INSERT INTO spav1602p_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Mandóles luego, y díjoles: Yo voy a ser reunido con mi pueblo: sepultadme con mis padres en la cueva que está en el campo de Efrón el heteo; ");
INSERT INTO spav1602p_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","En la cueva que está en el campo de Macpela, que está delante de Mamre en la tierra de Canaán, la cual compró Abraham con el mismo campo de Efrón el heteo, para heredad de sepultura. ");
INSERT INTO spav1602p_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Allí sepultaron a Abraham y a Sara su esposa; allí sepultaron a Isaac y a Rebeca su esposa; allí también sepulté yo a Lea. ");
INSERT INTO spav1602p_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","La compra del campo y de la cueva que está en él, fue de los hijos de Het. ");
INSERT INTO spav1602p_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Y como acabó Jacob de dar órdenes a sus hijos, encogió sus pies en la cama, y entregó el espíritu: y fue reunido con sus padres. ");
INSERT INTO spav1602p_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","ENTONCES se echó José sobre el rostro de su padre, y lloró sobre él, y besólo. ");
INSERT INTO spav1602p_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Y mandó José a sus médicos familiares que embalsamasen a su padre: y los médicos embalsa­maron a Israel. ");
INSERT INTO spav1602p_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Y cumpliéronle cuarenta días, porque así cumplían los días de los embalsamados, y lloráronlo los egipcios setenta días. ");
INSERT INTO spav1602p_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Y pasados los días de su luto, habló José a los de la casa de Faraón, diciendo: Si he hallado ahora gracia en vuestros ojos, os ruego que habléis en oídos de Faraón, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Mi padre me conjuró diciendo: He aquí yo muero; en mi sepul­cro que yo cavé para mí en la tie­rra de Canaán, allí me sepultarás; ruego pues que vaya yo ahora, y sepultaré a mi padre, y volveré. ");
INSERT INTO spav1602p_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Y Faraón dijo: Ve, y sepulta a tu padre, como él te conjuró. ");
INSERT INTO spav1602p_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Entonces José subió a sepultar a su padre; y subieron con él todos los siervos de Faraón, los ancianos de su casa, y todos los ancianos de la tierra de Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Y toda la casa de José, y sus hermanos, y la casa de su padre: solamente dejaron en la tierra de Gosén sus niños, y sus ovejas y sus vacas. ");
INSERT INTO spav1602p_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Y subieron también con él carros y gente de a caballo, e hízose un campamento muy grande. ");
INSERT INTO spav1602p_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Y llegaron hasta la era de Atad, que está a la otra parte del Jordán, y endecharon allí con grande y muy grave lamenta­ción: y José hizo a su padre duelo por siete días. ");
INSERT INTO spav1602p_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Y viendo los moradores de la tierra, los cananeos, el llanto en la era de Atad, dijeron: Llanto grande es este de los egipcios: por eso fue llamado su nombre Abelmizraim, que está a la otra parte del Jordán. ");
INSERT INTO spav1602p_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Hicieron, pues, sus hijos con él, según les había mandado: ");
INSERT INTO spav1602p_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Pues lleváronlo sus hijos a la tierra de Canaán, y le sepultaron en la cueva del campo de Macpela, la que había comprado Abraham con el mismo campo, para heredad de sepultura, de Efrón el heteo, delante de Mamre. ");
INSERT INTO spav1602p_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Y tornóse José a Egipto, él y sus hermanos, y todos los que subieron con él a sepultar a su padre, después que le hubo sepultado. ");
INSERT INTO spav1602p_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Y viendo los hermanos de José que su padre era muerto, dijeron: Quizá nos aborrecerá José, y nos dará el pago de todo el mal que le hicimos. ");
INSERT INTO spav1602p_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Y enviaron a decir a José: Tu padre mandó antes de su muerte, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Así diréis a José: Ruégote que perdones ahora la maldad de tus hermanos y su pecado, porque mal te trataron: por tanto ahora te rogamos que perdones la maldad de los siervos del Dios de tu padre. Y José lloró mientras hablaban. ");
INSERT INTO spav1602p_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Y vinieron también sus her­manos, y postráronse delante de él, y dijeron: He aquí, nosotros somos tus siervos. ");
INSERT INTO spav1602p_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Y respondióles José: No temáis: ¿estoy yo en lugar de Dios? ");
INSERT INTO spav1602p_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Vosotros pensasteis mal sobre mí, mas Dios lo encaminó a bien, para hacer lo que vemos hoy, para mantener en vida a mucho pueblo. ");
INSERT INTO spav1602p_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Ahora, pues, no tengáis miedo; yo os sustentaré a voso­tros y a vuestros hijos. Así los consoló, y les habló al corazón. ");
INSERT INTO spav1602p_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Y estuvo José en Egipto, él y la casa de su padre: y vivió José ciento diez años. ");
INSERT INTO spav1602p_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Y vio José los hijos de Efraím hasta la tercera genera­ción: también los hijos de Maquir, hijo de Manasés, fueron criados sobre las rodillas de José. ");
INSERT INTO spav1602p_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Y José dijo a sus hermanos: Yo me muero; y Dios cierta­mente os visitará, y os hará subir de esta tierra a la tierra que juró a Abraham, a Isaac, y a Jacob. ");
INSERT INTO spav1602p_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Y conjuró José a los hijos de Israel, diciendo: Dios ciertamen­te os visitará, y haréis llevar de aquí mis huesos. ");
INSERT INTO spav1602p_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Y murió José siendo de edad de cien­to diez años; y embalsamáronlo, y fue puesto en un ataúd en Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","ÉSTOS son los nombres de los hijos de Israel, que entraron en Egipto con Jacob; cada uno entró con su familia. ");
INSERT INTO spav1602p_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Rubén, Simeón, Leví y Judá; ");
INSERT INTO spav1602p_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isacar, Zabulón y Benjamín; ");
INSERT INTO spav1602p_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan y Neftalí, Gad y Aser. ");
INSERT INTO spav1602p_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Y todas las almas que salieron de los lomos de Jacob, fue­ron setenta almas; pues José ya estaba en Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Y murió José, y todos sus her­manos, y toda aquella genera­ción. ");
INSERT INTO spav1602p_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Y los hijos de Israel fructificaron, y aumentaron mucho, y se multiplicaron, y fueron fortalecidos en extremo; y la tierra se llenó de ellos. ");
INSERT INTO spav1602p_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Levantóse entretanto un nuevo rey sobre Egipto, que no conocía a José. ");
INSERT INTO spav1602p_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Y él dijo a su pueblo: He aquí, el pueblo de los hijos de Israel es mayor y más fuerte que nosotros: ");
INSERT INTO spav1602p_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Ahora, pues, seamos sabios para con ellos, porque no se multipli­quen, y acontezca que viniendo guerra, ellos también se junten con nuestros enemigos, y peleen contra nosotros, y se vayan de la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Entonces pusieron sobre ellos capataces que los afligiesen con sus cargas. Y edificaron a Faraón las ciudades de tesoros, Pitom y Ramesés. ");
INSERT INTO spav1602p_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Pero cuanto más los afligían, tanto más se multiplicaban y crecían. Y estaban fastidiados por causa de los hijos de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Y los egipcios hicieron servir a los hijos de Israel con dureza: ");
INSERT INTO spav1602p_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Y amargaron su vida con dura servidumbre, en hacer barro y ladrillo, y en toda labor del campo, y en todo su servicio, al cual los obligaban con rigorismo. ");
INSERT INTO spav1602p_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Y habló el rey de Egipto a las parteras de las hebreas, una de las cuales se llamaba Sifra, y otra Fúa: ");
INSERT INTO spav1602p_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Y díjoles: Cuando parteareis a las hebreas, y mirareis los asientos, si fuere hijo, matadlo; y si fuere hija, entonces viva. ");
INSERT INTO spav1602p_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Mas las parteras temieron a Dios, y no hicieron como les mandó el rey de Egipto, sino que salvaban la vida a los niños. ");
INSERT INTO spav1602p_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Y el rey de Egipto hizo llamar a las parteras, y díjoles: ¿Por qué habéis hecho esto, que habéis salvado la vida a los niños? ");
INSERT INTO spav1602p_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Y las parteras respondieron a Faraón: Porque las mujeres hebreas no son como las egipcias: porque son robustas, y paren antes que la partera venga a ellas. ");
INSERT INTO spav1602p_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Y Dios hizo bien a las parteras: y el pueblo se multiplicó, y se fortalecieron en gran manera. ");
INSERT INTO spav1602p_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Y aconteció que, por haber las parteras temi­do a Dios, él les hizo casas. ");
INSERT INTO spav1602p_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Entonces Faraón mandó a todo su pueblo, diciendo: Echad en el río todo hijo que naciere, y a toda hija reservad la vida. ");
INSERT INTO spav1602p_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Y UN varón de la familia de Leví fue, y tomó por esposa una hija de Leví: ");
INSERT INTO spav1602p_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","La cual concibió, y parió un hijo: y viéndolo que era niño hermo­so, túvole escondido tres meses. ");
INSERT INTO spav1602p_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Pero no pudiendo ocultarle más tiempo, tomó una arquilla de juncos, y calafateóla con pez y betún, y colocó en ella al niño, y púsolo en un carrizal a la orilla del río: ");
INSERT INTO spav1602p_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Y paróse una hermana suya a lo lejos, para ver lo que le acontecería. ");
INSERT INTO spav1602p_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Y la hija de Faraón descendió a lavarse al río, y paseándose sus doncellas por la ribera del río, vio ella la arquilla en el carrizal, y envió una criada suya a que la tomase. ");
INSERT INTO spav1602p_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Y como la abrió, vio al niño; y he aquí que el niño lloraba. Y teniendo compasión de él, dijo: De los niños de los hebreos es éste. ");
INSERT INTO spav1602p_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Entonces su hermana dijo a la hija de Faraón: ¿Iré a llamarte una ama de las hebreas, para que te críe este niño? ");
INSERT INTO spav1602p_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Y la hija de Faraón respondió: Ve. Entonces fue la doncella, y llamó a la madre del niño; ");
INSERT INTO spav1602p_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","A la cual dijo la hija de Faraón: Lleva este niño, y críamelo, y yo te lo pagaré. Y la mujer tomó al niño, y criólo. ");
INSERT INTO spav1602p_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Y creció el niño, y ella lo trajo a la hija de Faraón, la cual lo tomó por hijo. Y le puso por nombre Moisés, diciendo: Porque de las aguas lo saqué. ");
INSERT INTO spav1602p_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Y en aquellos días acaeció que, crecido ya Moisés, salió a sus hermanos, y vio sus cargas: y observó a un egipcio que hería a uno de los hebreos, sus herma­nos. ");
INSERT INTO spav1602p_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Y miró a todas partes, y vien­do que no había nadie, mató al egipcio, y escondiólo en la arena. ");
INSERT INTO spav1602p_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Y salió al día siguiente, y he aquí dos hebreos que reñían, y dijo al que hacía la injuria: ¿Por qué hieres a tu prójimo? ");
INSERT INTO spav1602p_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Y él respondió: ¿Quién te ha puesto a ti por príncipe y juez sobre nosotros? ¿piensas matar­me como mataste al egipcio? Entonces Moisés tuvo miedo, y dijo: Ciertamente esta cosa es descubierta. ");
INSERT INTO spav1602p_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Y oyendo Faraón este negocio, procuró matar a Moisés: mas Moisés huyó de la faz de Faraón, y habitó en la tierra de Madián; y sentóse junto a un pozo. ");
INSERT INTO spav1602p_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Tenía el sacerdote de Madián siete hijas, las cuales vinieron y sacaron agua, y llenaron las pilas para dar de beber al rebaño de su padre. ");
INSERT INTO spav1602p_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Y los pastores vinieron, y las echaron: pero Moisés se levantó y las ayudó, y dio de beber a su rebaño. ");
INSERT INTO spav1602p_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Y volviendo ellas a Reuel su padre, díjoles él: ¿Cómo habéis hoy venido tan presto? ");
INSERT INTO spav1602p_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Y ellas dijeron: Un varón egipcio nos libró de mano de los pastores, y también nos sacó agua suficiente, y dio de beber al rebaño. ");
INSERT INTO spav1602p_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Y dijo a sus hijas: ¿Y dónde está? ¿por qué habéis dejado ese hombre? llamadle para que coma pan. ");
INSERT INTO spav1602p_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Y Moisés estuvo contento en morar con aquel varón; y él dio a Moisés a su hija Séfora: ");
INSERT INTO spav1602p_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","La cual le parió un hijo, y él le puso por nombre Gersom: por­que dijo: Peregrino soy en tierra ajena. ");
INSERT INTO spav1602p_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Y aconteció que después de muchos días murió el rey de Egipto, y los hijos de Israel sus­piraron a causa de la servidum­bre, y clamaron: y subió a Dios el clamor de ellos por causa de su servidumbre. ");
INSERT INTO spav1602p_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Y oyó Dios el gemido de ellos, y acordóse Dios de su pacto con Abraham, Isaac y Jacob. ");
INSERT INTO spav1602p_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Y miró Dios a los hijos de Israel, y Dios les tuvo respeto. ");
INSERT INTO spav1602p_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Y APACENTANDO Moisés las ovejas de Jetro su suegro, sacerdote de Madián, llevó las ovejas detrás del desierto, y vino a Horeb, monte de Dios. ");
INSERT INTO spav1602p_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Y apareciósele el ángel del SEÑOR en una llama de fuego en medio de una zarza: y él miró, y vio que la zarza ardía en fuego, y la zarza no se consumía. ");
INSERT INTO spav1602p_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Y Moisés dijo: Iré yo ahora, y veré esta grande visión, por qué causa la zarza no está quemada. ");
INSERT INTO spav1602p_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Y viendo el SEÑOR que iba a ver, llamólo Dios de en medio de la zarza, y dijo: ¡Moisés, Moisés! Y él respondió: Heme aquí. ");
INSERT INTO spav1602p_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Y dijo: No te llegues acá: quita tus zapatos de tus pies, porque el lugar en que tú estás, tierra santa es. ");
INSERT INTO spav1602p_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Y dijo: Yo soy el Dios de tu padre, Dios de Abraham, Dios de Isaac, Dios de Jacob. Entonces Moisés cubrió su rostro, porque tuvo miedo de mirar a Dios. ");
INSERT INTO spav1602p_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Y dijo el SEÑOR: Bien he visto la aflicción de mi pueblo que está en Egipto, y he oído su clamor a causa de sus exactores; porque conozco sus angustias: ");
INSERT INTO spav1602p_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Y he descendido para librarlos de mano de los egipcios, y sacarlos de aquella tierra a una tierra buena y ancha, a tierra que fluye leche y miel, a los lugares del cananeo, del heteo, del amorreo, del ferezeo, del heveo, y del jebuseo. ");
INSERT INTO spav1602p_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","El clamor, por tanto, de los hijos de Israel ha venido delante de mí, y también he visto la opresión con que los egipcios los oprimen. ");
INSERT INTO spav1602p_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Ven por tanto ahora, y enviar­te he a Faraón, para que saques a mi pueblo, los hijos de Israel, de Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Y Moisés dijo a Dios: ¿Quién soy yo, para que vaya a Faraón, y saque de Egipto a los hijos de Israel? ");
INSERT INTO spav1602p_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Y él dijo: Ciertamente yo seré contigo; y esto te será por señal de que yo te he enviado: luego que hubieres sacado este pueblo de Egipto, serviréis a Dios sobre este monte. ");
INSERT INTO spav1602p_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Y dijo Moisés a Dios: He aquí que cuando llegue yo a los hijos de Israel, y les diga, el Dios de vuestros padres me ha enviado a vosotros; si ellos me preguntaren: ¿Cuál es su nombre? ¿qué les responderé? ");
INSERT INTO spav1602p_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Y respondió Dios a Moisés: YO SOY EL QUE SOY. Y dijo: Así dirás a los hijos de Israel: YO SOY me ha enviado a vosotros. ");
INSERT INTO spav1602p_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Y dijo más Dios a Moisés: Así dirás a los hijos de Israel: El SEÑOR, el Dios de vuestros padres, el Dios de Abraham, Dios de Isaac y Dios de Jacob, me ha enviado a vosotros. Éste es mi nombre por siempre, éste es mi memorial a todas generaciones. ");
INSERT INTO spav1602p_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Ve, y junta los ancianos de Israel, y diles: El SEÑOR Dios de vuestros padres, el Dios de Abraham, de Isaac, y de Jacob, me apareció, diciendo: De cierto os he visitado, y visto lo que se os ha hecho en Egipto; ");
INSERT INTO spav1602p_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Y he dicho: Yo os sacaré de la aflicción de Egipto a la tierra del cananeo, y del heteo, y del amorreo, y del ferezeo, y del heveo, y del jebuseo, a una tie­rra que fluye leche y miel. ");
INSERT INTO spav1602p_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Y oirán tu voz; e irás tú, y los ancianos de Israel, al rey de Egipto, y le diréis: El SEÑOR Dios de los hebreos, nos ha encontrado; por tanto nosotros iremos ahora camino de tres días por el desierto, para que sacrifi­quemos al SEÑOR nuestro Dios. ");
INSERT INTO spav1602p_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Y estoy seguro que el rey de Egipto no os dejará ir, no, ni por mano fuerte. ");
INSERT INTO spav1602p_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Y yo extenderé mi mano, y heriré a Egipto con todas mis maravillas que haré en medio de él, y entonces os dejará ir. ");
INSERT INTO spav1602p_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Y yo daré a este pueblo gracia en los ojos de los egipcios, para que cuando os partiereis, no sal­gáis vacíos: ");
INSERT INTO spav1602p_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Sino que cada mujer pedirá prestado a su vecina y a su huéspe­da joyas de plata, joyas de oro, y vestiduras: las cuales pondréis sobre vuestros hijos y vuestras hijas; y despojaréis a Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Y Moisés respondió, y dijo: Pero, he aquí que ellos no me creerán, ni oirán mi voz; porque dirán: No te ha aparecido el SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Y el SEÑOR dijo: ¿Qué es eso que tienes en tu mano? Y él res­pondió: Una vara. ");
INSERT INTO spav1602p_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Y él le dijo: Échala en tierra. Y él la echó en tierra, y tornóse una serpiente: y Moisés huía de ella. ");
INSERT INTO spav1602p_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Y dijo el SEÑOR a Moisés: Extiende tu mano, y tómala por la cola. Y él extendió su mano, y tomóla, y tornóse vara en su mano: ");
INSERT INTO spav1602p_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Para que crean que se te ha aparecido el SEÑOR, el Dios de tus padres, el Dios de Abraham, Dios de Isaac y Dios de Jacob. ");
INSERT INTO spav1602p_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Y díjole más el SEÑOR: Mete ahora tu mano en tu seno. Y él metió la mano en su seno; y como la sacó, he aquí que su mano estaba leprosa como la nieve. ");
INSERT INTO spav1602p_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Y dijo: Vuelve a meter tu mano en tu seno: y él volvió a meter su mano en su seno; y volviéndola a sacar del seno, y he aquí que se había vuelto como la otra carne. ");
INSERT INTO spav1602p_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Si aconteciere, que no te creye­ren, ni escucharen a la voz de la primera señal, creerán a la voz de la postrera. ");
INSERT INTO spav1602p_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Y acontecerá, si no creyeren aún a estas dos señales, ni oyeren tu voz, tomarás de las aguas del río, y derrámalas en tierra seca; y volverse han aquellas aguas que tomarás del río, se volverán sangre en la tierra seca. ");
INSERT INTO spav1602p_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Y dijo Moisés al SEÑOR: ¡Oh mi Señor! yo no soy elocuente, ni de antes, ni aun desde que tú has hablado a tu siervo; porque soy tardo en el habla y torpe de lengua. ");
INSERT INTO spav1602p_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Y el SEÑOR le dijo: ¿Quién hizo la boca del hombre? ¿o quién hizo al mudo o al sordo, al que ve o al ciego? ¿no soy yo el SEÑOR? ");
INSERT INTO spav1602p_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Ahora pues, ve, y yo seré con tu boca, y te enseñaré lo que has de decir. ");
INSERT INTO spav1602p_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Y él dijo: ¡Oh mi Señor! envía, te ruego, por mano del que has de enviar. ");
INSERT INTO spav1602p_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Y la ira del SEÑOR se encendió contra Moisés, y dijo: ¿No es Aarón, el levita, tu hermano? Yo sé que él habla bien. Y aun he aquí que él te saldrá a recibir, y en viéndote, se alegrará en su corazón. ");
INSERT INTO spav1602p_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Y tú hablarás a él, y pondrás en su boca las palabras, y yo seré con tu boca y con la suya, y os enseñaré lo que habéis de hacer. ");
INSERT INTO spav1602p_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Y él hablará por ti al pueblo; y él, aún él, te será a ti en lugar de boca, y tú serás para él en lugar de Dios. ");
INSERT INTO spav1602p_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Y tomarás esta vara en tu mano, con la cual harás las seña­les. ");
INSERT INTO spav1602p_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Y se fue Moisés y volvió a su suegro Jetro, y díjole: Déjame ir, te ruego, y volver a mis hermanos que están en Egipto, para ver si aún viven. Y Jetro dijo a Moisés: Ve en paz. ");
INSERT INTO spav1602p_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Dijo también el SEÑOR a Moisés en Madián: Ve, y vuélve­te a Egipto, porque han muerto todos los que procuraban tu muerte. ");
INSERT INTO spav1602p_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Entonces Moisés tomó su esposa y sus hijos, y púsolos sobre un asno, y volvióse a tierra de Egipto: tomó también Moisés la vara de Dios en su mano. ");
INSERT INTO spav1602p_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Y dijo el SEÑOR a Moisés: Cuando hubiereis vuelto a Egipto, mira que hagas delante de Faraón todas las maravillas que he puesto en tu mano: pero yo endureceré su corazón, de modo que no dejará ir al pue­blo. ");
INSERT INTO spav1602p_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Y dirás a Faraón: el SEÑOR ha dicho así: Israel es mi hijo, aún mi primogénito. ");
INSERT INTO spav1602p_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Y te he dicho: Dejes ir a mi hijo, para que me sirva; y si rehúsas dejarlo ir, he aquí yo mataré a tu hijo, tu primogénito. ");
INSERT INTO spav1602p_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Y aconteció en el camino, en una posada, que el SEÑOR le encontró, y buscó matarlo. ");
INSERT INTO spav1602p_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Entonces Séfora cogió un afilado pedernal, y cortó el pre­pucio de su hijo, y echólo a sus pies, diciendo: A la verdad tú me eres un esposo de sangre. ");
INSERT INTO spav1602p_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Así le dejó ir. Y ella dijo: Eres esposo de sangre, a causa de la circuncisión. ");
INSERT INTO spav1602p_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Y el SEÑOR dijo a Aarón: Ve a recibir a Moisés al desierto. Y él fue, y encontrólo en el monte de Dios, y besóle. ");
INSERT INTO spav1602p_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Entonces contó Moisés a Aarón todas las palabras del SEÑOR que le enviaba, y todas las señales que le había dado. ");
INSERT INTO spav1602p_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Y fueron Moisés y Aarón, y juntaron todos los ancianos de los hijos de Israel: ");
INSERT INTO spav1602p_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Y habló Aarón todas las pala­bras que el SEÑOR había dicho a Moisés, e hizo las señales delante de los ojos del pueblo. ");
INSERT INTO spav1602p_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Y el pueblo creyó: y oyendo que el SEÑOR había visitado los hijos de Israel, y que había visto su aflicción, inclináronse y ado­raron. ");
INSERT INTO spav1602p_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","DESPUÉS entraron Moisés y Aarón a Faraón, y le dijeron: El SEÑOR Dios de Israel, dice así: Deja ir a mi pueblo a celebrarme fiesta en el desierto. ");
INSERT INTO spav1602p_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Y Faraón respondió: ¿Quién es el SEÑOR, para que yo obedezca su voz y deje ir a Israel? Yo no conozco al SEÑOR, ni tampoco dejaré ir a Israel. ");
INSERT INTO spav1602p_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Y ellos dijeron: El Dios de los hebreos nos ha encontrado: déjanos ir, te rogamos, camino de tres días por el desierto, y sacrificar al SEÑOR nuestro Dios; porque no venga sobre nosotros con pestilencia o con espada. ");
INSERT INTO spav1602p_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Entonces el rey de Egipto les dijo: Moisés y Aarón, ¿por qué hacéis cesar al pueblo de su obra? idos a vuestros cargos. ");
INSERT INTO spav1602p_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Dijo también Faraón: He aquí el pueblo de la tierra es ahora mucho, y vosotros les hacéis cesar de sus cargos. ");
INSERT INTO spav1602p_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Y mandó Faraón aquel mismo día a los capataces del pueblo que le tenían a su cargo, y a sus oficiales, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","De aquí en adelante no daréis paja al pueblo para hacer ladrillo, como ayer y antes de ayer; vayan ellos y recojan por sí mismos la paja: ");
INSERT INTO spav1602p_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Y habéis de ponerles la tarea del ladrillo que hacían antes, y no les disminuiréis nada; porque están ociosos, y por eso levantan la voz diciendo: Vamos y sacrifi­caremos a nuestro Dios. ");
INSERT INTO spav1602p_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Agrávese la servidumbre sobre ellos, para que se ocupen en ella, y no atiendan a palabras vanas. ");
INSERT INTO spav1602p_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Y saliendo los capataces del pueblo y sus oficiales, hablaron al pueblo, diciendo: Así ha dicho Faraón: Yo no os doy paja. ");
INSERT INTO spav1602p_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Id vosotros, y recoged paja donde la hallareis; que nada se disminuirá de vuestra tarea. ");
INSERT INTO spav1602p_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Entonces el pueblo se esparció por toda la tierra de Egipto a coger rastrojo en lugar de paja. ");
INSERT INTO spav1602p_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Y los capataces los apremiaban, diciendo: Cumplid vuestra obra, la tarea diaria, como cuando había paja. ");
INSERT INTO spav1602p_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Y azotaban a los oficiales de los hijos de Israel, que los capataces de Faraón habían pues­to sobre ellos, diciendo: ¿Por qué no habéis cumplido vuestra tarea de ladrillo ni ayer ni hoy, como antes? ");
INSERT INTO spav1602p_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Y los oficiales de los hijos de Israel vinieron a Faraón, y se quejaron a él, diciendo: ¿Por qué lo haces así con tus siervos? ");
INSERT INTO spav1602p_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","No se da paja a tus siervos, y nos dicen: Haced el ladrillo. Y he aquí tus siervos son azotados, pero la falta está en tu propio pueblo. ");
INSERT INTO spav1602p_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Y él respondió: Estáis ociosos, sí, ociosos, y por eso decís: Vamos y sacrifiquemos al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Id pues ahora, y trabajad. No se os dará paja, y habéis de dar la tarea del ladrillo. ");
INSERT INTO spav1602p_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Y los oficiales de los hijos de Israel vieron que estaban en mal caso, habiéndoseles dicho: No se disminuirá nada de vuestro ladrillo, de su tarea diaria. ");
INSERT INTO spav1602p_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Y encontraron a Moisés y a Aarón, que estaban en el camino, cuando salían de Faraón, ");
INSERT INTO spav1602p_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Y dijéronles: Mire el SEÑOR sobre vosotros, y juzgue; pues habéis hecho heder nuestro olor delante de Faraón y de sus sier­vos, dándoles la espada en las manos para que nos maten. ");
INSERT INTO spav1602p_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Entonces Moisés se volvió al Señor, y dijo: SEÑOR, ¿por qué afliges tanto a este pueblo? ¿por qué me has enviado? ");
INSERT INTO spav1602p_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Porque desde que yo vine a Faraón para hablarle en tu nom­bre, él ha afligido a este pueblo; y tú tampoco has librado a tu pue­blo. ");
INSERT INTO spav1602p_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","EL SEÑOR respondió a Moisés: Ahora verás lo que yo haré a Faraón; porque con mano fuerte los ha de dejar ir; y con mano fuerte los ha de echar de su tierra. ");
INSERT INTO spav1602p_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Habló todavía Dios a Moisés, y díjole: Yo soy el SEÑOR; ");
INSERT INTO spav1602p_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Y yo aparecí a Abraham, a Isaac y a Jacob bajo el nombre de Dios Todopoderoso, mas en mi nombre JEHOVÁ no me di a conocer a ellos. ");
INSERT INTO spav1602p_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Y también yo establecí mi pacto con ellos, de darles la tierra de Canaán, la tierra de sus peregrinaciones, en la cual fueron extranjeros. ");
INSERT INTO spav1602p_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Y asimismo yo he oído el gemido de los hijos de Israel, a quienes mantienen en esclavitud los egipcios, y heme acordado de mi pacto. ");
INSERT INTO spav1602p_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Por tanto dirás a los hijos de Israel: Yo soy el SEÑOR; y yo os sacaré de debajo de las cargas de Egipto, y yo os libraré de su servidumbre, y yo os redimiré con brazo extendido, y con jui­cios grandes: ");
INSERT INTO spav1602p_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Y yo os tomaré por mi pueblo y yo seré vuestro Dios: y voso­tros sabréis que yo soy el SEÑOR vuestro Dios, que os saco de debajo de las cargas de Egipto: ");
INSERT INTO spav1602p_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Y yo os meteré en la tierra, acerca de la cual juré que la daría a Abraham, a Isaac y a Jacob; y yo os la daré por heredad: Yo soy el SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Y habló Moisés a los hijos de Israel: mas ellos no escuchaban a Moisés a causa de la congoja de espíritu, y de la dura servidumbre. ");
INSERT INTO spav1602p_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Y habló el SEÑOR a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","Entra, y habla a Faraón rey de Egipto, que deje ir de su tierra a los hijos de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Y respondió Moisés delante del SEÑOR, diciendo: He aquí, los hijos de Israel no me han escuchado: ¿cómo pues me escuchará Faraón, siendo yo incircunciso de labios? ");
INSERT INTO spav1602p_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Entonces el SEÑOR habló a Moisés y a Aarón, y dióles man­damiento para los hijos de Israel, y para Faraón rey de Egipto, para que sacasen a los hijos de Israel de la tierra de Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Éstas son las cabezas de las familias de sus padres. Los hijos de Rubén, el primogénito de Israel: Enoc y Falú, Hezrón y Carmi: éstas son las familias de Rubén. ");
INSERT INTO spav1602p_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Y los hijos de Simeón: Jemuel, y Jamín, y Ohad, y Jaquín, y Zoar, y Shaúl, el hijo de una cananea: éstas son las familias de Simeón. ");
INSERT INTO spav1602p_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Y éstos son los nombres de los hijos de Leví por sus generaciones: Gersón, y Coat, y Merari. Y los años de la vida de Leví fueron ciento treinta y siete años. ");
INSERT INTO spav1602p_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Y los hijos de Gersón: Libni, y Simi, según sus familias. ");
INSERT INTO spav1602p_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Y los hijos de Coat: Amram, e Izhar, y Hebrón, y Uziel. Y los años de la vida de Coat fueron ciento treinta y tres años. ");
INSERT INTO spav1602p_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Y los hijos de Merari: Mahali, y Musi: éstas son las familias de Leví según sus generaciones. ");
INSERT INTO spav1602p_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Y Amram tomó por esposa a Jocabed su tía; la cual le parió a Aarón y a Moisés. Y los años de la vida de Amram fueron ciento treinta y siete años. ");
INSERT INTO spav1602p_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Y los hijos de Izhar: Cora, y Nefeg y Zicri. ");
INSERT INTO spav1602p_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Y los hijos de Uziel: Misael, y Elzafán y Zicri. ");
INSERT INTO spav1602p_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Y tomóse Aarón por esposa a Elisabet, hija de Aminadab, hermana de Naasón; la cual le parió a Nadab, y a Abiú y a Eleazar y a Itamar. ");
INSERT INTO spav1602p_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Y los hijos de Cora: Asir, y Elcana, y Ebiasaf: éstas son las familias de los coritas. ");
INSERT INTO spav1602p_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Y Eleazar, hijo de Aarón, tomó para sí una esposa de las hijas de Futiel, la cual le parió a Finees: Y éstas son las cabezas de los padres de los levitas por sus familias. ");
INSERT INTO spav1602p_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Éste es aquel Aarón y aquel Moisés, a los cuales el SEÑOR dijo: Sacad a los hijos de Israel de la tierra de Egipto por sus ejércitos. ");
INSERT INTO spav1602p_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Éstos son los que hablaron a Faraón rey de Egipto, para sacar de Egipto a los hijos de Israel. Moisés y Aarón fueron éstos. ");
INSERT INTO spav1602p_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Y aconteció en el día cuando el SEÑOR habló a Moisés en la tierra de Egipto, ");
INSERT INTO spav1602p_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","Que el SEÑOR habló a Moisés, diciendo: Yo soy el SEÑOR; di a Faraón rey de Egipto todas las cosas que yo te digo a ti. ");
INSERT INTO spav1602p_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Y Moisés respondió delante del SEÑOR: He aquí, yo soy incircunciso de labios, ¿cómo pues me ha de oír Faraón? ");
INSERT INTO spav1602p_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Y EL SEÑOR dijo a Moisés: Mira, yo te he constituido dios para Faraón, y tu hermano Aarón será tu profeta. ");
INSERT INTO spav1602p_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Tú dirás todas las cosas que yo te mandare, y Aarón tu hermano hablará a Faraón, para que deje ir de su tierra a los hijos de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Y yo endureceré el corazón de Faraón, y multiplicaré en la tierra de Egipto mis señales y mis maravillas. ");
INSERT INTO spav1602p_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Pero Faraón no os oirá; mas yo pondré mi mano sobre Egipto, y sacaré a mis ejércitos, y mi pueblo, los hijos de Israel, de la tierra de Egipto, con grandes juicios. ");
INSERT INTO spav1602p_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Y sabrán los egipcios que yo soy el SEÑOR, cuando exten­deré mi mano sobre Egipto, y sacaré los hijos de Israel de en medio de ellos. ");
INSERT INTO spav1602p_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Y Moisés y Aarón hicieron como el SEÑOR les mandó, así hicieron ellos. ");
INSERT INTO spav1602p_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Y era Moisés de edad de ochenta años, y Aarón de edad de ochenta y tres, cuando hablaron a Faraón. ");
INSERT INTO spav1602p_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Y habló el SEÑOR a Moisés y a Aarón, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","Cuando Faraón os hablare, diciendo: Mostrad milagro; dirás a Aarón: Toma tu vara, y échala delante de Faraón, para que se torne serpiente. ");
INSERT INTO spav1602p_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Y entraron Moisés y Aarón a Faraón, e hicieron como el SEÑOR había mandado: y echó Aarón su vara delante de Faraón y de sus siervos, y tornó­se serpiente. ");
INSERT INTO spav1602p_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Entonces llamó también Faraón sabios y encantadores; e hicieron también lo mismo los encantadores de Egipto con sus encantamientos; ");
INSERT INTO spav1602p_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Porque echó cada uno su vara, las cuales se volvieron serpien­tes: mas la vara de Aarón devoró las varas de ellos. ");
INSERT INTO spav1602p_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Y el corazón de Faraón se endureció, y no los escuchó; como el SEÑOR lo había dicho. ");
INSERT INTO spav1602p_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Entonces el SEÑOR dijo a Moisés: El corazón de Faraón está endurecido, que rehusa dejar ir al pueblo. ");
INSERT INTO spav1602p_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Ve por la mañana a Faraón, he aquí que él sale a las aguas; y tú ponte a la orilla del río delante de él, y toma en tu mano la vara que se volvió serpiente. ");
INSERT INTO spav1602p_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Y le dirás: El SEÑOR Dios de los hebreos me ha enviado a ti, diciendo: Deja ir a mi pueblo, para que me sirvan en el desier­to; y he aquí que hasta ahora no has querido oír. ");
INSERT INTO spav1602p_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Así ha dicho el SEÑOR: En esto conocerás que yo soy el SEÑOR: he aquí, yo heriré con la vara que tengo en mi mano el agua que está en el río, y se con­vertirá en sangre: ");
INSERT INTO spav1602p_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Y los peces que hay en el río morirán, y hederá el río, y ten­drán asco los egipcios de beber el agua del río. ");
INSERT INTO spav1602p_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Y el SEÑOR dijo a Moisés: Di a Aarón: Toma tu vara, y extiende tu mano sobre las aguas de Egipto, sobre sus ríos, sobre sus arroyos y sobre sus estan­ques, y sobre todos sus depósitos de aguas, para que se conviertan en sangre, y haya sangre por toda la región de Egipto, así en los vasos de madera como en los de piedra. ");
INSERT INTO spav1602p_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Y Moisés y Aarón hicieron como el SEÑOR lo mandó; y alzando la vara hirió las aguas que había en el río, en presencia de Faraón y de sus siervos; y todas las aguas que había en el río se convirtieron en sangre. ");
INSERT INTO spav1602p_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Asimismo los peces que había en el río murieron; y el río se corrompió, que los egipcios no podían beber de él: y hubo san­gre por toda la tierra de Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Y los encantadores de Egipto hicieron lo mismo con sus encantamientos: y el corazón de Faraón se endureció, y no los escuchó; como el SEÑOR lo había dicho. ");
INSERT INTO spav1602p_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Y tornando Faraón volvióse a su casa, y no puso su corazón aun en esto. ");
INSERT INTO spav1602p_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Y en todo Egipto hicieron pozos alrededor del río para beber, porque no podían beber de las aguas del río. ");
INSERT INTO spav1602p_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Y cumpliéronse siete días des­pués que el SEÑOR hirió el río. ");
INSERT INTO spav1602p_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","ENTONCES el SEÑOR dijo a Moisés: Entra a Faraón, y díle: el SEÑOR ha dicho así: Deja ir a mi pueblo, para que me sirvan. ");
INSERT INTO spav1602p_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Y si no lo quisieres dejar ir, he aquí yo heriré con ranas todos tus términos: ");
INSERT INTO spav1602p_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Y el río criará ranas, las cuales subirán, y entrarán en tu casa, y en la cámara de tu cama, y sobre tu cama, y en las casas de tus siervos, y en tu pueblo, y en tus hornos, y en tus artesas: ");
INSERT INTO spav1602p_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Y las ranas subirán sobre ti, y sobre tu pueblo, y sobre todos tus siervos. ");
INSERT INTO spav1602p_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Y el SEÑOR dijo a Moisés: Di a Aarón: Extiende tu mano con tu vara sobre los ríos, arroyos, y estanques, para que haga venir ranas sobre la tierra de Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Entonces Aarón extendió su mano sobre las aguas de Egipto, y subieron ranas que cubrieron la tierra de Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Y los encantadores hicieron lo mismo con sus encantamientos, e hicieron venir ranas sobre la tierra de Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Entonces Faraón llamó a Moisés y a Aarón, y díjoles: Orad al SEÑOR que quite las ranas de mí y de mi pueblo; y dejaré ir al pueblo, para que sacrifique al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Y dijo Moisés a Faraón: Gloríate sobre mí: ¿cuándo oraré por ti, y por tus siervos, y por tu pueblo, para que las ranas sean quitadas de ti, y de tus casas, y que solamente se queden en el río? ");
INSERT INTO spav1602p_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Y él dijo: Mañana. Y Moisés respondió: Se hará conforme a tu palabra, para que conozcas que no hay como el SEÑOR nuestro Dios: ");
INSERT INTO spav1602p_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Y las ranas se irán de ti, y de tus casas, y de tus siervos, y de tu pueblo, y solamente se quedarán en el río. ");
INSERT INTO spav1602p_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Entonces salieron Moisés y Aarón de con Faraón, y clamó Moisés al SEÑOR sobre el nego­cio de las ranas que había puesto a Faraón. ");
INSERT INTO spav1602p_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","E hizo el SEÑOR conforme a la palabra de Moisés, y murieron las ranas de las casas, de los cor­tijos, y de los campos. ");
INSERT INTO spav1602p_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Y las juntaron en montones, y apestaban la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Y viendo Faraón que le habí­an dado reposo, endureció su corazón, y no los escuchó; como el SEÑOR lo había dicho. ");
INSERT INTO spav1602p_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Entonces el SEÑOR dijo a Moisés: Di a Aarón: Extiende tu vara, y hiere el polvo de la tierra, para que se vuelva piojos por todo el país de Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Y ellos lo hicieron así; y Aarón extendió su mano con su vara, e hirió el polvo de la tierra, el cual se volvió piojos, así en los hombres como en las bestias: todo el polvo de la tierra se vol­vió piojos en todo el país de Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Y los encantadores hicieron así también, para sacar piojos con sus encantamientos; mas no pudieron. Y había piojos así en los hombres como en las bestias. ");
INSERT INTO spav1602p_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Entonces los magos dijeron a Faraón: Dedo de Dios es este. Mas el corazón de Faraón se endureció, y no los escuchó; como el SEÑOR lo había dicho. ");
INSERT INTO spav1602p_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Y el SEÑOR dijo a Moisés: Levántate de mañana y ponte delante de Faraón, he aquí él sale a las aguas; y díle: el SEÑOR ha dicho así: Deja ir a mi pueblo, para que me sirva. ");
INSERT INTO spav1602p_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Porque si no dejares ir a mi pueblo, he aquí yo enviaré sobre ti, y sobre tus siervos, y sobre tu pueblo, y sobre tus casas toda suerte de moscas; y las casas de los egipcios se henchirán de toda suerte de moscas, y asimismo la tierra donde ellos estuvieren. ");
INSERT INTO spav1602p_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Y aquel día yo apartaré la tie­rra de Gosén, en la cual mi pue­blo habita, para que ninguna suerte de moscas haya en ella; a fin de que sepas que yo soy el SEÑOR en medio de la tie­rra. ");
INSERT INTO spav1602p_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Y yo pondré división entre mi pueblo y el tuyo. Mañana será esta señal. ");
INSERT INTO spav1602p_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Y el SEÑOR lo hizo así: que vino toda suerte de moscas molestísimas sobre la casa de Faraón, y sobre las casas de sus siervos, y sobre todo el país de Egipto; y la tierra fue corrompi­da a causa de ellas. ");
INSERT INTO spav1602p_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Entonces Faraón llamó a Moisés y a Aarón, y díjoles: Andad, sacrificad a vuestro Dios en la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Y Moisés respondió: No con­viene que hagamos así, porque sacrificaríamos al SEÑOR nues­tro Dios la abominación de los egipcios. He aquí, si sacrificára­mos la abominación de los egipcios delante de ellos, ¿no nos apedrearían? ");
INSERT INTO spav1602p_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Camino de tres días iremos por el desierto, y sacrificaremos al SEÑOR nuestro Dios, como él nos dirá. ");
INSERT INTO spav1602p_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Y dijo Faraón: Yo os dejaré ir para que sacrifiquéis al SEÑOR vuestro Dios en el desierto, con tal que no vayáis más lejos: orad por mí. ");
INSERT INTO spav1602p_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Y respondió Moisés: He aquí, en saliendo yo de contigo, rogaré al SEÑOR que las diversas suer­tes de moscas se vayan de Faraón, y de sus siervos, y de su pueblo mañana; con tal que Faraón no falte más, no dejando ir al pueblo a sacrificar al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Entonces Moisés salió de con Faraón, y oró al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Y el SEÑOR hizo conforme a la palabra de Moisés; y quitó todas aquellas moscas de Faraón, y de sus siervos, y de su pueblo, sin que quedara una. ");
INSERT INTO spav1602p_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Mas Faraón endureció aún esta vez su corazón, y no dejó ir al pueblo. ");
INSERT INTO spav1602p_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","ENTONCES el SEÑOR dijo a Moisés: Entra a Faraón, y díle: el SEÑOR, el Dios de los hebreos, dice así: Deja ir a mi pueblo, para que me sirvan; ");
INSERT INTO spav1602p_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Porque si no lo quieres dejar ir, y los detuvieres aún, ");
INSERT INTO spav1602p_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","He aquí la mano del SEÑOR será sobre tus ganados que están en el campo, caballos, asnos, camellos, vacas y ovejas, con pestilencia gravísima: ");
INSERT INTO spav1602p_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Y el SEÑOR hará separación entre los ganados de Israel y los de Egipto, de modo que nada muera de todo lo de los hijos de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Y el SEÑOR señaló tiempo, diciendo: Mañana hará el SEÑOR esta cosa en la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Y el día siguiente el SEÑOR hizo aquello, y murió todo el ganado de Egipto; mas del gana­do de los hijos de Israel no murió uno. ");
INSERT INTO spav1602p_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Entonces Faraón envió, y he aquí que del ganado de los hijos de Israel no había muerto uno. Mas el corazón de Faraón se endureció, y no dejó ir al pueblo. ");
INSERT INTO spav1602p_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Y el SEÑOR dijo a Moisés y a Aarón: Tomad puñados de ceni­za de un horno, y espárzala Moisés hacia el cielo delante de Faraón: ");
INSERT INTO spav1602p_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Y vendrá a ser polvo sobre toda la tierra de Egipto, el cual origi­nará sarpullido que cause tumo­res apostemados en los hombres y en las bestias, por todo el país de Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Y tomaron la ceniza del horno, y pusiéronse delante de Faraón, y esparcióla Moisés hacia el cielo; y vino un sarpulli­do que causaba tumores aposte­mados así en los hombres como en las bestias. ");
INSERT INTO spav1602p_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Y los magos no podían estar delante de Moisés a causa de los tumores, porque hubo sarpullido en los magos y en todos los egipcios, ");
INSERT INTO spav1602p_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Y el SEÑOR endureció el corazón de Faraón, y no los oyó; como el SEÑOR lo había dicho a Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Entonces el SEÑOR dijo a Moisés: Levántate de mañana, y ponte delante de Faraón, y díle: el SEÑOR, el Dios de los hebreos, dice así: Deja ir a mi pueblo, para que me sirva. ");
INSERT INTO spav1602p_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Porque yo enviaré esta vez todas mis plagas a tu corazón, sobre tus siervos, y sobre tu pue­blo, para que entiendas que no hay otro como yo en toda la tie­rra. ");
INSERT INTO spav1602p_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Porque ahora yo extenderé mi mano para herirte a ti y a tu pue­blo de pestilencia, y serás quita­do de la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Y a la verdad yo te he puesto para declarar en ti mi potencia, y que mi Nombre sea contado en toda la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","¿Todavía te ensalzas tú contra mi pueblo, para no dejarlos ir? ");
INSERT INTO spav1602p_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","He aquí que mañana a estas horas yo haré llover granizo muy grave, cual nunca fue en Egipto, desde el día que se fundó hasta ahora. ");
INSERT INTO spav1602p_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Envía, pues, a recoger tu ganado, y todo lo que tienes en el campo; porque todo hombre o animal que se hallare en el campo, y no fuere recogido a casa, el granizo descenderá sobre él, y morirá. ");
INSERT INTO spav1602p_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","De los siervos de Faraón el que temió la palabra del SEÑOR, hizo huir sus criados y su ganado a casa: ");
INSERT INTO spav1602p_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Mas el que no puso en su corazón la palabra del SEÑOR, dejó sus criados y sus ganados en el campo. ");
INSERT INTO spav1602p_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Y el SEÑOR dijo a Moisés: Extiende tu mano hacia el cielo, para que venga granizo en toda la tierra de Egipto sobre los hom­bres, y sobre las bestias, y sobre toda la hierba del campo en el país de Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Y Moisés extendió su vara hacia el cielo, y el SEÑOR hizo tronar y granizar, y el fuego dis­curría por la tierra; y llovió el SEÑOR granizo sobre la tierra de Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Hubo pues granizo, y fuego mezclado con el granizo, tan grande, cual nunca hubo en toda la tierra de Egipto desde que fue habitada. ");
INSERT INTO spav1602p_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Y aquel granizo hirió en toda la tierra de Egipto todo lo que estaba en el campo, así hombres como bestias; asimismo hirió el granizo toda la hierba del campo, y desgajó todos los árboles del país. ");
INSERT INTO spav1602p_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Solamente en la tierra de Gosén, donde los hijos de Israel estaban, no hubo granizo. ");
INSERT INTO spav1602p_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Entonces Faraón envió a lla­mar a Moisés y a Aarón, y les dijo: He pecado esta vez: el SEÑOR es justo, y yo y mi pue­blo somos impíos. ");
INSERT INTO spav1602p_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Orad al SEÑOR (basta ya): para que cesen los truenos de Dios y el granizo; y yo os dejaré ir, y no os detendréis más. ");
INSERT INTO spav1602p_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Y respondióle Moisés: En saliendo yo de la ciudad extende­ré mis manos al SEÑOR, y los truenos cesarán, y no habrá más granizo; para que sepas que del SEÑOR es la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Mas yo sé que ni tú ni tus sier­vos temeréis todavía la presencia del Dios el SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","El lino, pues, y la cebada fue­ron heridos; porque la cebada estaba ya espigada, y el lino en caña. ");
INSERT INTO spav1602p_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Mas el trigo y el centeno no fueron heridos; porque eran tar­díos. ");
INSERT INTO spav1602p_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Y salido Moisés de con Faraón de la ciudad, extendió sus manos al SEÑOR, y cesaron los truenos y el granizo; y la lluvia no cayó más sobre la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Y viendo Faraón que la lluvia había cesado y el granizo y los truenos, perseveró en pecar, y endureció su corazón, él y sus siervos. ");
INSERT INTO spav1602p_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Y el corazón de Faraón se endureció, y no dejó ir a los hijos de Israel; como el SEÑOR lo había dicho por medio de Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Y EL SEÑOR dijo a Moisés: Entra a Faraón; porque yo he endurecido su corazón, y el corazón de sus siervos, para mostrar entre ellos estas mis señales; ");
INSERT INTO spav1602p_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Y para que cuentes a tus hijos y a tus nietos las cosas que yo hice en Egipto, y mis señales que di entre ellos; y para que sepáis que yo soy el SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Entonces vinieron Moisés y Aarón a Faraón, y le dijeron: el SEÑOR, el Dios de los hebreos, ha dicho así: ¿Hasta cuándo no querrás humillarte delante de mí? Deja ir a mi pueblo, para que me sirvan. ");
INSERT INTO spav1602p_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Y si aún rehusas dejarlo ir, he aquí que yo traeré mañana lan­gosta en tus términos, ");
INSERT INTO spav1602p_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","La cual cubrirá la faz de la tie­rra, de modo que no pueda verse la tierra; y ella comerá lo que quedó salvo, lo que os ha queda­do del granizo; comerá asimismo todo árbol que os produce fruto en el campo: ");
INSERT INTO spav1602p_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Y llenarse han tus casas, y las casas de todos tus siervos, y las casas de todos los egipcios, cual nunca vieron tus padres ni tus abuelos, desde que ellos fueron sobre la tierra hasta hoy. Y vol­vióse, y salió de con Faraón. ");
INSERT INTO spav1602p_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Entonces los siervos de Faraón le dijeron: ¿Hasta cuándo nos ha de ser éste por lazo? Deja ir a estos hombres, para que sirvan al SEÑOR su Dios; ¿aún no sabes que Egipto está destruido? ");
INSERT INTO spav1602p_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Y Moisés y Aarón volvieron a ser llamados a Faraón, el cual les dijo: Andad, servid al SEÑOR vuestro Dios. ¿Quién y quién son los que han de ir? ");
INSERT INTO spav1602p_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Y Moisés respondió: Hemos de ir con nuestros niños y con nues­tros viejos, con nuestros hijos y con nuestras hijas: con nuestras ovejas y con nuestras vacas hemos de ir; porque tenemos solemnidad del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Y él les dijo: Así sea el SEÑOR con vosotros como yo os dejaré ir a vosotros y a vues­tros niños: mirad como el mal está delante de vuestro rostro. ");
INSERT INTO spav1602p_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","No será así: id ahora vo­sotros los varones, y servid al SEÑOR: pues esto es lo que vosotros demandasteis. Y echá­ronlos de delante de Faraón. ");
INSERT INTO spav1602p_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Entonces el SEÑOR dijo a Moisés: Extiende tu mano sobre la tierra de Egipto para traer langosta, a fin de que suba sobre el país de Egipto, y consuma todo lo que el granizo dejó. ");
INSERT INTO spav1602p_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Y extendió Moisés su vara sobre la tierra de Egipto, y el SEÑOR trajo un viento oriental sobre el país todo aquel día y toda aquella noche; y a la maña­na el viento oriental trajo la lan­gosta: ");
INSERT INTO spav1602p_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Y subió la langosta sobre toda la tierra de Egipto, y asentóse en todos los términos de Egipto, en gran manera grave: antes de ella no hubo langosta semejante, ni después de ella vendrá otra tal; ");
INSERT INTO spav1602p_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Y cubrió la faz de todo el país, y oscurecióse la tierra; y consu­mió toda la hierba de la tierra, y todo el fruto de los árboles que había dejado el granizo; que no quedó cosa verde en árboles ni en hierba del campo, por toda la tierra de Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Entonces Faraón hizo llamar apriesa a Moisés y a Aarón, y dijo: He pecado contra el SEÑOR vuestro Dios, y contra vosotros. ");
INSERT INTO spav1602p_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Mas ruego ahora que perdo­nes mi pecado solamente esta vez, y que oréis al SEÑOR vues­tro Dios que quite de mí sola­mente esta muerte. ");
INSERT INTO spav1602p_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Y salió de con Faraón, y oró al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Y el SEÑOR volvió un vien­to occidental fortísimo, y quitó la langosta, y arrojóla en el mar Bermejo: ni una langosta quedó en todo el término de Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Mas el SEÑOR endureció el corazón de Faraón; y no envió los hijos de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Y el SEÑOR dijo a Moisés: Extiende tu mano hacia el cielo, para que haya tinieblas sobre la tierra de Egipto, tales que cual­quiera las palpe. ");
INSERT INTO spav1602p_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Y extendió Moisés su mano hacia el cielo, y hubo densas tinieblas tres días por toda la tie­rra de Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Ninguno vio a su prójimo, ni nadie se levantó de su lugar en tres días; mas todos los hijos de Israel tenían luz en sus habitacio­nes. ");
INSERT INTO spav1602p_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Entonces Faraón hizo llamar a Moisés, y dijo: Id, servid al SEÑOR; solamente queden vuestras ovejas y vuestras vacas: vayan también vuestros niños con vosotros. ");
INSERT INTO spav1602p_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Y Moisés respondió: Tú tam­bién nos entregarás sacrificios y holocaustos que sacrifiquemos al SEÑOR nuestro Dios. ");
INSERT INTO spav1602p_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Nuestros ganados irán tam­bién con nosotros; no quedará ni una pezuña; porque de ellos hemos de tomar para servir al SEÑOR nuestro Dios; y no sabe­mos con qué hemos de servir al SEÑOR, hasta que lleguemos allá. ");
INSERT INTO spav1602p_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Mas el SEÑOR endureció el corazón de Faraón, y no quiso dejarlos ir. ");
INSERT INTO spav1602p_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Y díjole Faraón: Retírate de mí: guárdate que no veas más mi rostro, porque en cualquier día que vieres mi rostro, morirás. ");
INSERT INTO spav1602p_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Y Moisés respondió: Bien has dicho; no veré más tu rostro. ");
INSERT INTO spav1602p_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Y EL SEÑOR dijo a Moisés: Aún una plaga más traeré sobre Faraón, y sobre Egipto; después de la cual él os dejará ir de aquí; cuando él te permitirá salir, ciertamente os echará de aquí del todo. ");
INSERT INTO spav1602p_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Habla ahora al pueblo, y que cada uno pida a su vecino, y cada una a su vecina, joyas de plata y de oro. ");
INSERT INTO spav1602p_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Y el SEÑOR dio gracia al pue­blo en los ojos de los egipcios. También Moisés era un varón muy grande en la tierra de Egipto, a los ojos de los siervos de Faraón, y a los ojos del pueblo. ");
INSERT INTO spav1602p_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Y dijo Moisés: Así dice el SEÑOR: A la media noche yo saldré por medio de Egipto, ");
INSERT INTO spav1602p_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Y morirá todo primogénito en tierra de Egipto, desde el primo­génito de Faraón que se sienta en su trono, hasta el primogénito de la sierva que está tras la muela; y todo primogénito de las bestias. ");
INSERT INTO spav1602p_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Y habrá gran clamor por toda la tierra de Egipto, cual nunca fue, ni jamás será. ");
INSERT INTO spav1602p_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Pero entre todos los hijos de Israel, el perro no moverá su lengua, contra hombre ni bestia: para que sepáis que hará diferencia el SEÑOR entre los egipcios y los israelitas. ");
INSERT INTO spav1602p_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Y descenderán a mí todos estos tus siervos, e inclinados delante de mí dirán: Sal tú, y todo el pue­blo que está bajo de ti; y después de esto yo saldré. Y salióse muy enojado de con Faraón. ");
INSERT INTO spav1602p_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Y el SEÑOR dijo a Moisés: Faraón no os oirá, para que mis maravillas sean multiplicadas en la tierra de Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Y Moisés y Aarón hicieron todos estos prodigios delante de Faraón: mas el SEÑOR endureció el corazón de Faraón, y no dejó ir a los hijos de Israel fuera de su país. ");
INSERT INTO spav1602p_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Y HABLÓ el SEÑOR a Moisés y a Aarón en la tierra de Egipto, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","Este mes os será principio de los meses; será éste para vo­sotros el primero en los meses del año. ");
INSERT INTO spav1602p_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Hablad a toda la congregación de Israel, diciendo: En el diez de este mes tómese cada hombre un cordero por las familias de sus padres, un cordero por casa: ");
INSERT INTO spav1602p_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Y si la familia fuere pequeña que no baste a comer el cordero, entonces tomará a su vecino inmediato a su casa, y según el número de las almas, cada uno conforme a su comer, echaréis la cuenta sobre el cordero. ");
INSERT INTO spav1602p_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Vuestro cordero será sin defec­to, macho de un año: tomaréislo de las ovejas o de las cabras: ");
INSERT INTO spav1602p_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Y lo guardaréis hasta el día catorce de este mes; y lo inmolará toda la asamblea de la congregación de Israel entre las dos tardes. ");
INSERT INTO spav1602p_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Y tomarán de la sangre, y la pondrán en los dos postes y en el dintel de las casas en que lo han de comer. ");
INSERT INTO spav1602p_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Y aquella noche comerán la carne asada al fuego, y panes sin levadura: y con hierbas amargas lo comerán. ");
INSERT INTO spav1602p_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Ninguna cosa comeréis de él cruda, ni cocida en agua, sino asada al fuego; su cabeza con sus pies y sus intestinos. ");
INSERT INTO spav1602p_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Ninguna cosa dejaréis de él hasta la mañana; y lo que habrá quedado hasta la mañana, habéis de quemarlo en el fuego. ");
INSERT INTO spav1602p_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Y así habéis de comerlo: con vuestros lomos ceñi­dos, vuestros zapatos en vuestros pies, y vues­tro bordón en vuestra mano; y lo comeréis apresuradamente: es la Pascua del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Pues yo pasaré esta noche por la tierra de Egipto, y heriré a todo primogénito en la tierra de Egipto, así en los hombres como en las bestias: y ejecutaré juicio contra todos los dioses de Egipto. Yo soy el SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Y la sangre os será por señal en las casas donde vosotros estéis; y cuando yo viere la sangre, pasaré sobre vosotros, y no habrá en vosotros plaga para os destruir, cuando hiera la tierra de Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Y este día os será en memoria, y vosotros lo celebraréis como solemne al SEÑOR duran­te vuestras generaciones: por ordenanza perpetua lo celebraréis. ");
INSERT INTO spav1602p_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Siete días comeréis panes sin levadura; y así el primer día haréis que no haya levadura en vuestras casas: porque cualquie­ra que comiere leudado desde el primer día hasta el séptimo, aquella alma será cortada de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Y en el primer día habrá santa convocación, y asimismo en el séptimo día tendréis una santa convocación: ninguna obra se hará en ellos, excepto solamente que aderecéis lo que cada cual hubiere de comer. ");
INSERT INTO spav1602p_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Y guardaréis la fiesta de los panes sin levadura, porque en este mismo día saqué vuestros ejérci­tos de la tierra de Egipto: por tanto guardaréis este día en vues­tras generaciones por ordenanza perpetua. ");
INSERT INTO spav1602p_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","En el mes primero, el día catorce del mes por la tarde, comeréis los panes sin levadura, hasta el veintiuno del mes por la tarde. ");
INSERT INTO spav1602p_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Por siete días no se hallará levadura en vuestras casas, por­que cualquiera que comiere lo que está leu­dado, así extranjero como natural del país, aquella alma será corta­da de la congregación de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Ninguna cosa leudada comeréis; en todas vuestras habitaciones comeréis panes sin levadura. ");
INSERT INTO spav1602p_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Entonces Moisés convocó a todos los ancianos de Israel, y díjoles: Sacad, y tomaos corderos por vuestras familias, y sacrificad la pascua. ");
INSERT INTO spav1602p_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Y tomad un manojo de hisopo, y mojadlo en la sangre que estuviere en el tazón, y untad el dintel y los dos postes con la sangre que estuviere en el tazón; y ninguno de vosotros salga de la puerta de su casa hasta la mañana. ");
INSERT INTO spav1602p_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Porque el SEÑOR pasará en medio hiriendo a los egipcios; y cuando viere la sangre en el dintel y en los dos postes, pasará el SEÑOR aquella puerta, y no dejará entrar al destructor en vuestras casas para os herir. ");
INSERT INTO spav1602p_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Y guardaréis esto por ordenanza para vosotros y para vuestros hijos para siempre. ");
INSERT INTO spav1602p_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Y sucederá, cuando habréis venido a la tierra que el SEÑOR os dará, como él ha prometido, que guardaréis este servicio. ");
INSERT INTO spav1602p_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Y sucederá, cuando os dijeren vuestros hijos: ¿Qué servicio es este vuestro? ");
INSERT INTO spav1602p_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Que vosotros responderéis: Es el sacrificio de la Pascua del SEÑOR, el cual pasó sobre las casas de los hijos de Israel en Egipto, cuando hirió a los egipcios, y libró nuestras casas. Y el pueblo se inclinó y adoró. ");
INSERT INTO spav1602p_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Y los hijos de Israel se fueron, e hicieron como el SEÑOR había mandado a Moisés y a Aarón, así lo hicieron. ");
INSERT INTO spav1602p_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Y aconteció que a la media­noche el SEÑOR hirió a todo primogénito en la tierra de Egipto, desde el primogénito de Faraón que se sentaba sobre su trono, hasta el primogénito del cautivo que estaba en la cárcel, y todo primogénito de los anima­les. ");
INSERT INTO spav1602p_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Y levantóse aquella noche Faraón, él y todos sus siervos, y todos los egipcios; y había un gran clamor en Egipto, porque no había casa donde no hubiese muerto. ");
INSERT INTO spav1602p_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Y él llamó a Moisés y a Aarón de noche, y díjoles: Levantaos, y salid de en medio de mi pueblo, ambos vosotros y los hijos de Israel; e id, servid al SEÑOR, como habéis dicho. ");
INSERT INTO spav1602p_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Tomad también vuestras ove­jas y vuestras vacas, como habéis dicho, e idos; y bendecidme tam­bién a mí. ");
INSERT INTO spav1602p_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Y los egipcios apremiaban al pueblo, dándose prisa a echar­los de la tierra; porque decían: Todos somos muertos. ");
INSERT INTO spav1602p_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Y llevó el pueblo su masa antes que se leudase, sus masas envueltas en sus ropas sobre sus hombros. ");
INSERT INTO spav1602p_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","E hicieron los hijos de Israel conforme al mandamiento de Moisés, pidiendo prestado a los egipcios joyas de plata, y joyas de oro, y vestiduras. ");
INSERT INTO spav1602p_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Y el SEÑOR dio gracia al pueblo delante de los egipcios, y prestáronles tales cosas que requerían; y ellos despojaron a los egipcios. ");
INSERT INTO spav1602p_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Y partieron los hijos de Israel de Rameses a Sucot, como seiscientos mil hombres de a pie, sin contar los niños. ");
INSERT INTO spav1602p_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Y también subió con ellos grande multitud de diversa clase de gentes; y ovejas, y muchísimo ganado. ");
INSERT INTO spav1602p_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Y cocieron tortas sin levadura de la masa que habían sacado de Egipto; porque no había leudado, por cuanto echándolos los egipcios, no habían podido dete­nerse, ni aun prepararse comida. ");
INSERT INTO spav1602p_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","El tiempo que los hijos de Israel habitaron en Egipto, fue cuatrocientos treinta años. ");
INSERT INTO spav1602p_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Y pasados cuatrocientos trein­ta años, en el mismo día salieron todos los ejércitos del SEÑOR de la tierra de Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Es una noche para guardar al SEÑOR, por haberlos sacado de la tierra de Egipto. Ésta es la noche del SEÑOR que deben guardar todos los hijos de Israel en sus generaciones. ");
INSERT INTO spav1602p_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Y el SEÑOR dijo a Moisés y a Aarón: Ésta es la ordenanza de la Pascua: Ningún extranjero comerá de ella: ");
INSERT INTO spav1602p_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Mas todo siervo humano comprado por dinero, comerá de ella después que lo hubieres cir­cuncidado. ");
INSERT INTO spav1602p_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","El extranjero y el asalariado no comerán de ella. ");
INSERT INTO spav1602p_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","En una casa se comerá, y no llevarás de aquella carne fuera de casa, ni quebraréis hueso suyo. ");
INSERT INTO spav1602p_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Toda la congregación de Israel la guardará. ");
INSERT INTO spav1602p_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Mas si algún extranjero pere­grinare contigo, y quisiere guardar la pascua al SEÑOR, séale cir­cuncidado todo varón, y entonces se llegará a hacerla, y será como el natural de la tierra; pero ningún incircunciso comerá de ella. ");
INSERT INTO spav1602p_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","La misma ley será para el natural y para el extranjero que peregrinare entre vosotros. ");
INSERT INTO spav1602p_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Así lo hicieron todos los hijos de Israel; como mandó el SEÑOR a Moisés y a Aarón, así lo hicieron. ");
INSERT INTO spav1602p_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Y en aquel mismo día sacó el SEÑOR a los hijos de Israel de la tierra de Egipto por sus ejércitos. ");
INSERT INTO spav1602p_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Y EL SEÑOR habló a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","Santifícame todo primogénito, cualquiera que abre matriz entre los hijos de Israel, así de los hombres como de los animales: mío es. ");
INSERT INTO spav1602p_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Y Moisés dijo al pueblo: Tened memoria de este día, en el cual habéis salido de Egipto, de la casa de servidumbre; pues el SEÑOR os ha sacado de este lugar con mano fuerte: por tanto, no comeréis pan leudado. ");
INSERT INTO spav1602p_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Vosotros salís hoy en el mes de Abib. ");
INSERT INTO spav1602p_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Y cuando el SEÑOR te hubiere metido en la tierra del cananeo, y del heteo, y del amorreo, y del heveo, y del jebuseo, la cual juró a tus padres que te daría, tierra que destila leche y miel, harás este ser­vicio en este mes. ");
INSERT INTO spav1602p_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Siete días comerás pan sin levadura, y el séptimo día será fiesta al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Por los siete días se comerán los panes sin levadura; y no se verá contigo leudado, ni levadu­ra en todo tu territorio. ");
INSERT INTO spav1602p_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Y contarás en aquel día a tu hijo, diciendo: Hácese esto con motivo de lo que el SEÑOR hizo conmigo cuando salí de Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Y serte ha como una señal sobre tu mano, y como una memoria delante de tus ojos, para que la ley del SEÑOR esté en tu boca; por cuanto con mano fuerte te sacó el SEÑOR de Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Por tanto, tú guardarás esta ordenanza en su tiempo de año en año. ");
INSERT INTO spav1602p_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Y cuando el SEÑOR te hubie­re metido en la tierra del cananeo, como te ha jurado a ti y a tus padres, y cuando te la hubiere dado, ");
INSERT INTO spav1602p_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","Apartarás al SEÑOR todo lo que abriere la matriz, asimismo todo primerizo que abriere la matriz de tus animales: los machos serán del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Y todo primogénito de asno redimirás con un cordero; y si no lo redimieres, entonces le quebrarás la cerviz: asimismo redimirás todo humano primogénito de tus hijos. ");
INSERT INTO spav1602p_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Y será que cuando te preguntare tu hijo, diciendo: ¿Qué es esto? decirle has: el SEÑOR nos sacó con mano fuerte de Egipto, de casa de servidumbre; ");
INSERT INTO spav1602p_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Y aconteció que, cuando Faraón se endureció para no dejarnos ir, el SEÑOR mató en la tierra de Egipto a todo primogé­nito, desde el primogénito humano hasta el primogénito de la bestia: y por esta causa yo sacri­fico al SEÑOR todo primogénito macho, y redimo todo primogé­nito de mis hijos. ");
INSERT INTO spav1602p_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Y serte ha como una señal sobre tu mano, y por una memoria delante de tus ojos; ya que el SEÑOR nos sacó de Egipto con mano fuerte. ");
INSERT INTO spav1602p_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Y aconteció, cuando Faraón dejó ir al pueblo, que Dios no los llevó por el camino de la tierra de los filisteos, que estaba cerca; por­que dijo Dios: Que quizá no se arrepienta el pueblo cuando vie­ren la guerra, y se vuelvan a Egipto: ");
INSERT INTO spav1602p_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Mas hizo Dios al pueblo que rodease por el camino del desier­to del mar Bermejo. Y subieron los hijos de Israel de Egipto armados. ");
INSERT INTO spav1602p_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Y tomó también consigo Moisés los huesos de José, el cual había juramentado a los hijos de Israel, diciendo: Dios ciertamente os visitará, y haréis subir mis huesos de aquí con vosotros. ");
INSERT INTO spav1602p_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Y partidos de Sucot, acampa­ron en Etam, a la entra­da del desierto. ");
INSERT INTO spav1602p_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Y el SEÑOR iba delante de ellos de día en una columna de nube, para guiarlos por el cami­no; y de noche en una columna de fuego para alumbrarles; a fin de que anduviesen de día y de noche. ");
INSERT INTO spav1602p_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Él no quitó de delante del pueblo la columna de nube de día, ni de noche la columna de fuego. ");
INSERT INTO spav1602p_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Y HABLÓ el SEÑOR a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","Habla a los hijos de Israel que den la vuelta, y asienten su campo delante de Pihahirot, entre Migdol y el mar hacia Baalzefón: delante de él acamparéis, junto al mar. ");
INSERT INTO spav1602p_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Porque Faraón dirá de los hijos de Israel: Encerrados están en la tierra, el desierto los ha encerra­do. ");
INSERT INTO spav1602p_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Y yo endureceré el corazón de Faraón para que los siga; y seré glorificado en Faraón y en todo su ejército; y sabrán los egipcios que yo soy el SEÑOR. Y ellos lo hicieron así. ");
INSERT INTO spav1602p_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Y fue dado aviso al rey de Egipto cómo el pueblo se huía: y el corazón de Faraón y de sus siervos se volvió contra el pue­blo, y dijeron: ¿Cómo hemos hecho esto de haber dejado ir a Israel, para que no nos sirva? ");
INSERT INTO spav1602p_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Y unció su carro, y tomó consi­go su pueblo; ");
INSERT INTO spav1602p_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Y tomó seiscientos carros esco­gidos, y todos los carros de Egipto, y los capitanes sobre ellos. ");
INSERT INTO spav1602p_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Y endureció el SEÑOR el cora­zón de Faraón rey de Egipto, y siguió a los hijos de Israel; pero los hijos de Israel habían salido con mano poderosa. ");
INSERT INTO spav1602p_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Persiguiéndolos, pues, los egipcios, con toda la caballería y carros de Faraón, su gente de a caballo, y su ejército, alcanzáronlos acampando junto al mar, al lado de Pihahirot, delante de Baalzefón. ");
INSERT INTO spav1602p_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Y cuando Faraón se hubo acercado, los hijos de Israel alza­ron sus ojos, y he aquí los egipcios que venían tras ellos; por lo que temieron en gran manera, y clamaron los hijos de Israel al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Y dijeron a Moisés: ¿No había sepulcros en Egipto, que nos has sacado para que muramos en el desierto? ¿Por qué lo has hecho así con nosotros, que nos has sacado de Egipto? ");
INSERT INTO spav1602p_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","¿No es esto lo que te hablamos en Egipto, diciendo: Déjanos ser­vir a los egipcios? Que mejor nos fuera servir a los egipcios, que morir nosotros en el desierto. ");
INSERT INTO spav1602p_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Y Moisés dijo al pueblo: No temáis; estad quietos, y ved la salvación del SEÑOR, que él os mostrará hoy; porque a los egipcios que hoy habéis visto, nunca más para siempre los veréis. ");
INSERT INTO spav1602p_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","El SEÑOR peleará por vo­sotros, y vosotros estaréis que­dos. ");
INSERT INTO spav1602p_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Y el SEÑOR dijo a Moisés: ¿Por qué clamas a mí? di a los hijos de Israel, que marchen adelante: ");
INSERT INTO spav1602p_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Pero tú alza tu vara, y extiende tu mano sobre el mar, y divídelo; y entren los hijos de Israel por medio del mar en tierra seca. ");
INSERT INTO spav1602p_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Y yo, he aquí yo endureceré el corazón de los egipcios, para que los sigan: y yo me glorifica­ré en Faraón, y en todo su ejérci­to, y en sus carros, y en su caba­llería; ");
INSERT INTO spav1602p_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Y sabrán los egipcios que yo soy el SEÑOR, cuando me glorificaré en Faraón, en sus carros, y en su gente de a caballo. ");
INSERT INTO spav1602p_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Y el ángel de Dios que iba delante del campamento de Israel, se retiró, e iba en pos de ellos; y asimismo la columna de nube que iba delante de ellos, se retiró, y se puso a sus espaldas: ");
INSERT INTO spav1602p_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","E iba entre el campo de los egipcios y el campo de Israel; y era nube y tinieblas para aqué­llos, y alumbraba a Israel de noche: y en toda aquella noche nunca llegaron los unos a los otros. ");
INSERT INTO spav1602p_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Y extendió Moisés su mano sobre el mar, e hizo el SEÑOR que el mar se retirase por recio viento oriental toda aquella noche; y tornó el mar en tierra seca, y las aguas quedaron divididas. ");
INSERT INTO spav1602p_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Y los hijos de Israel entraron por medio del mar en tierra seca, y las aguas fueron como un muro a su diestra y a su siniestra: ");
INSERT INTO spav1602p_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Y siguiéndolos los egipcios, entraron tras ellos hasta el medio del mar, aún toda la caballería de Faraón, sus carros, y su gente de a caballo. ");
INSERT INTO spav1602p_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Y aconteció a la vela de la mañana, que el SEÑOR miró al campo de los egipcios desde la columna de fuego y nube, y per­turbó el campo de los egipcios. ");
INSERT INTO spav1602p_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Y quitóles las ruedas de sus carros, y trastornólos gravemen­te. Entonces los egipcios dije­ron: Huyamos de delante de Israel, porque el SEÑOR pelea por ellos contra los egipcios. ");
INSERT INTO spav1602p_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Y el SEÑOR dijo a Moisés: Extiende tu mano sobre el mar, para que las aguas vuelvan sobre los egipcios, sobre sus carros, y sobre su caballería. ");
INSERT INTO spav1602p_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Y Moisés extendió su mano sobre el mar, y el mar se volvió en su fuerza cuando amanecía; y los egipcios iban hacia ella: y el SEÑOR derribó a los egipcios en medio del mar. ");
INSERT INTO spav1602p_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Y volvieron las aguas, y cubrieron los carros y la caballe­ría, y todo el ejército de Faraón que había entrado tras ellos en el mar; no quedó de ellos ni siquiera uno. ");
INSERT INTO spav1602p_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Y los hijos de Israel fueron por medio del mar en tierra seca, y las aguas fueron como un muro a su diestra y a su siniestra. ");
INSERT INTO spav1602p_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Así salvó el SEÑOR aquel día a Israel de mano de los egipcios; e Israel vio a los egipcios muer­tos a la orilla del mar. ");
INSERT INTO spav1602p_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Y vio Israel aquel grande hecho que el SEÑOR ejecutó contra los egipcios: y el pueblo temió al SEÑOR, y creyeron al SEÑOR y a Moisés su siervo. ");
INSERT INTO spav1602p_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Entonces cantó Moisés y los hijos de Israel este cántico al SEÑOR, y hablaron, diciendo: Cantaré yo al SEÑOR, porque él ha triunfado gloriosamente, echando en el mar al caballo y al que en él subía. ");
INSERT INTO spav1602p_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","El SEÑOR es mi fortaleza y mi canción, y él se ha hecho mi salvación: él es mi Dios, y le prepararé una habitación; Dios de mi padre, y a él exaltaré. ");
INSERT INTO spav1602p_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","El SEÑOR es varón de guerra; el SEÑOR es su nombre. ");
INSERT INTO spav1602p_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Los carros de Faraón y a su ejército él echó en el mar; y sus escogidos príncipes fueron ahogados en el mar Bermejo. ");
INSERT INTO spav1602p_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Los abismos los cubrieron; como piedra se hundieron a los profundos. ");
INSERT INTO spav1602p_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Tu diestra, oh SEÑOR, es hecha gloriosa en fortaleza; tu dies­tra, oh SEÑOR, ha quebrantado al enemigo. ");
INSERT INTO spav1602p_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Y con la grandeza de tu excelencia has trastornado a los que se levantaron contra ti: enviaste tu furor; el cual los tragó como a hojaras­ca. ");
INSERT INTO spav1602p_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Con el soplo de tus narices se amontonaron las aguas; paráron­se las corrientes como en un montón; y los abismos se cuajaron en medio del mar. ");
INSERT INTO spav1602p_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","El enemigo dijo: Perseguiré, prenderé, repartiré despojos; mi alma se henchirá de ellos; Sacaré mi espada, destruirlos ha mi mano. ");
INSERT INTO spav1602p_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Soplaste con tu viento, cubriólos el mar: hundiéronse como plomo en las vehementes aguas. ");
INSERT INTO spav1602p_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","¿Quién es como tú, Oh SEÑOR, entre los dioses? ¿Quién es como tú, glorioso en santidad, temeroso en loores, haciendo maravillas? ");
INSERT INTO spav1602p_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Extendiste tu diestra; la tierra los tragó. ");
INSERT INTO spav1602p_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Condujiste en tu misericordia a este pueblo, al cual redimiste; lo guiaste con tu fortaleza a tu habitación de santidad. ");
INSERT INTO spav1602p_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Oiránlo los pueblos, y tembla­rán; apoderarse ha dolor de los moradores de Palestina. ");
INSERT INTO spav1602p_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Entonces los príncipes de Edom se turbarán; a los fuertes de Moab los ocupará temblor; desleírse han todos los moradores de Canaán. ");
INSERT INTO spav1602p_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Caerá sobre ellos temblor y espanto; por la grandeza de tu brazo enmudecerán como una piedra; hasta que haya pasado tu pueblo, oh SEÑOR, hasta que haya pasado este pueblo que tú compraste. ");
INSERT INTO spav1602p_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Tú los introducirás y los plantarás en el monte de tu heredad, en el lugar de tu morada, que tú has aparejado, oh SEÑOR; en el Santuario, oh SEÑOR, que tus manos han establecido. ");
INSERT INTO spav1602p_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","El SEÑOR reinará por y para siempre. ");
INSERT INTO spav1602p_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Porque Faraón entró cabal­gando con sus carros y su gente de a caballo en el mar, y el SEÑOR volvió las aguas del mar sobre ellos; mas los hijos de Israel fueron en tierra seca por medio del mar. ");
INSERT INTO spav1602p_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Y Miriam la profetisa, hermana de Aarón, tomó un pandero en su mano, y todas las mujeres salie­ron en pos de ella con panderos y danzas: ");
INSERT INTO spav1602p_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Y Miriam les respondía: Cantad al SEÑOR; porque él ha triunfado gloriosamente, echando en el mar al caballo, y al que en él subía. ");
INSERT INTO spav1602p_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Así Moisés trajo a Israel del mar Bermejo, y salie­ron al desierto de Shur; y andu­vieron tres días por el desierto sin hallar agua. ");
INSERT INTO spav1602p_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Y cuando llegaron a Mara, no pudieron beber las aguas de Mara, porque eran amargas; por eso le pusieron el nombre de Mara. ");
INSERT INTO spav1602p_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Entonces el pueblo murmuró contra Moisés, diciendo: ¿Qué hemos de beber? ");
INSERT INTO spav1602p_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Y Moisés clamó al SEÑOR; y el SEÑOR le mostró un árbol, el cual metídolo que hubo dentro de las aguas, las aguas se endul­zaron. Allí les dio estatutos y ordenanzas, y allí los probó; ");
INSERT INTO spav1602p_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Y dijo: Si oyeres atentamente la voz del SEÑOR tu Dios, e hicieres lo recto delante de sus ojos, y dieres oído a sus manda­mientos, y guardares todos sus estatutos, ninguna enfermedad de las que envié a los egipcios te enviaré a ti; porque yo soy el SEÑOR que te sana. ");
INSERT INTO spav1602p_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Y vinieron a Elim, donde había doce fuentes de aguas, y setenta palmas; y acamparon allí junto a las aguas. ");
INSERT INTO spav1602p_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Y PARTIENDO de Elim toda la congregación de los hijos de Israel, vino al desierto de Sin, que está entre Elim y Sinaí, a los quince días del segundo mes después que salieron de la tierra de Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Y toda la congregación de los hijos de Israel murmuró contra Moisés y Aarón en el desierto; ");
INSERT INTO spav1602p_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Y decíanles los hijos de Israel: Quiera Dios que hubiéramos muerto por mano del SEÑOR en la tierra de Egipto, cuando nos sentábamos a las ollas de las carnes, cuando comíamos pan en abundancia; pues nos habéis sacado a este desierto, para matar de hambre a toda esta asamblea. ");
INSERT INTO spav1602p_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Entonces el SEÑOR dijo a Moisés: He aquí yo os haré llover pan del cielo; y el pueblo saldrá, y recogerá una porción para cada día, para que yo lo pruebe si anda en mi ley, o no. ");
INSERT INTO spav1602p_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Y sucederá que en el sexto día aparejarán lo que han de recoger, que será el doble de lo que solían recoger cada día. ");
INSERT INTO spav1602p_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Y dijo Moisés y Aarón a todos los hijos de Israel: A la tarde sabréis que el SEÑOR os ha sacado de la tierra de Egipto: ");
INSERT INTO spav1602p_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Y a la mañana veréis la gloria del SEÑOR; porque él ha oído vuestras murmuraciones contra el SEÑOR; ¿y qué somos nosotros, para que vosotros murmuréis contra nosotros? ");
INSERT INTO spav1602p_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Y dijo Moisés: Esto será, cuando el SEÑOR os dará a la tarde carne para comer, y a la mañana pan en hartura; por cuanto el SEÑOR oye vuestras murmuraciones con que habéis murmurado contra él: ¿y qué somos nosotros? vuestras murmuraciones no son contra nosotros, sino contra el SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Y dijo Moisés a Aarón: Di a toda la congregación de los hijos de Israel: Acercaos a la presencia del SEÑOR; que él ha oído vues­tras murmuraciones. ");
INSERT INTO spav1602p_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Y aconteció, hablando Aarón a toda la congregación de los hijos de Israel, que miraron hacia el desierto, y he aquí, la gloria del SEÑOR apareció en la nube. ");
INSERT INTO spav1602p_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Y el SEÑOR habló a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","Yo he oído las murmuracio­nes de los hijos de Israel; hábla­les, diciendo: Entre las dos tardes comeréis carne, y por la mañana os hartaréis de pan, y sabréis que yo soy el SEÑOR vuestro Dios. ");
INSERT INTO spav1602p_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Y venida la tarde subieron codornices que cubrieron el campamento; y a la mañana descendió rocío en derredor del real. ");
INSERT INTO spav1602p_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Y cuando el rocío que estaba se levantó, he aquí sobre la faz del desierto había una cosa menuda, redonda, menuda como la escarcha sobre la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Y cuando lo vieron los hijos de Israel, se dijeron unos a otros: Esto es maná, porque no sabían lo qué era. Y Moisés les dijo: Esto es el pan que el SEÑOR os ha dado para comer. ");
INSERT INTO spav1602p_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Esto es lo que el SEÑOR ha mandado: cogeréis de él cada uno según pudiere comer; un gomer por cada hombre, conforme al número de vuestras personas, tomaréis cada uno para los que están en su tienda. ");
INSERT INTO spav1602p_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Y los hijos de Israel lo hicie­ron así: y recogieron unos más, otros menos: ");
INSERT INTO spav1602p_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Y cuando lo medían por gomer, no sobraba al que había recogido mucho, ni faltaba al que había recogido poco: cada uno recogió conforme a lo que había de comer. ");
INSERT INTO spav1602p_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Y díjoles Moisés: Ninguno deje nada de ello para mañana. ");
INSERT INTO spav1602p_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Mas ellos no obedecieron a Moisés, sino que algunos deja­ron de ello para otro día, y crió gusanos, y hedió; y enojóse contra ellos Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Y lo recogían cada mañana, cada hombre según lo que había de comer: y cuando el sol calentaba, se derretía. ");
INSERT INTO spav1602p_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Y aconteció, que en el sexto día recogieron doblado pan, dos gomeres para cada uno: y todos los gobernantes de la congregación vinieron y lo contaron a Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Y él les dijo: Esto es lo que ha dicho el SEÑOR: Mañana es el santo sábado, el reposo del SEÑOR: lo que hubiereis de cocer, cocedlo hoy, y lo que hubiereis de cocinar, cocinadlo; y todo lo que os sobrare, guar­dadlo para mañana. ");
INSERT INTO spav1602p_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Y ellos lo guardaron hasta la mañana, según que Moisés había mandado, y no se hedió, ni hubo en él gusano. ");
INSERT INTO spav1602p_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Y dijo Moisés: Comedlo hoy, porque hoy es sábado del SEÑOR: hoy no hallaréis en el campo. ");
INSERT INTO spav1602p_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","En los seis días lo recogeréis; mas el séptimo día es el sábado, en el cual no habrá. ");
INSERT INTO spav1602p_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Y aconteció que algunos del pueblo salieron en el séptimo día a recoger, y no hallaron. ");
INSERT INTO spav1602p_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Y el SEÑOR dijo a Moisés: ¿Hasta cuándo rehusáis guardar mis mandamientos y mis leyes? ");
INSERT INTO spav1602p_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Mirad que el SEÑOR os dio el sábado, y por eso os da en el sexto día pan para dos días. Estése, pues, cada uno en su estancia, y nadie salga de su lugar en el séptimo día. ");
INSERT INTO spav1602p_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Así el pueblo reposó el sépti­mo día. ");
INSERT INTO spav1602p_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Y la casa de Israel lo llamó Maná; y era como simiente de culantro, blanco, y su sabor como de hojuelas con miel. ");
INSERT INTO spav1602p_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Y dijo Moisés: Esto es lo que el SEÑOR ha mandado: Henchirás un gomer de él para que se guarde para vuestras generaciones, a fin de que vean el pan que yo os di a comer en el desierto, cuando yo os saqué de la tierra de Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Y dijo Moisés a Aarón: Toma un vaso, y pon en él un gomer lleno de maná, y ponlo delante del SEÑOR, para que sea guar­dado para vuestras generaciones. ");
INSERT INTO spav1602p_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Como el SEÑOR lo mandó a Moisés, así Aarón lo puso delante del Testimonio, para ser guardado. ");
INSERT INTO spav1602p_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Así comieron los hijos de Israel maná cuarenta años, hasta que entraron en la tierra habita­da: maná comieron hasta que lle­garon al término de la tierra de Canaán. ");
INSERT INTO spav1602p_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Ahora un gomer es la décima parte del efa. ");
INSERT INTO spav1602p_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Y TODA la congregación de los hijos de Israel partió del desierto de Sin, por sus jornadas, según el mandamiento del SEÑOR, y asentaron el campo en Refidim: y no había agua para que el pueblo bebiese. ");
INSERT INTO spav1602p_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Por lo cual altercó el pueblo con Moisés, y dijeron: Danos agua que beba­mos. Y Moisés les dijo: ¿Por qué altercáis conmigo? ¿por qué ten­táis al SEÑOR? ");
INSERT INTO spav1602p_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Así que el pueblo tuvo allí sed de agua, y murmuró contra Moisés, y dijo: ¿Por qué nos hicis­te subir de Egipto, para matarnos de sed a nosotros y a nuestros hijos y a nuestros ganados? ");
INSERT INTO spav1602p_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Entonces clamó Moisés al SEÑOR, diciendo: ¿Qué haré con este pueblo? de aquí a un poco me apedrearán. ");
INSERT INTO spav1602p_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Y el SEÑOR dijo a Moisés: Pasa delante del pueblo, y toma contigo de los ancianos de Israel; y toma también en tu mano tu vara, con que heriste el río, y ve: ");
INSERT INTO spav1602p_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","He aquí, yo estoy delante de ti allí sobre la roca en Horeb; y herirás la roca, y saldrán de ella aguas, y beberá el pueblo. Y Moisés lo hizo así en presencia de los ancianos de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Y llamó el nombre de aquel lugar Masah y Meriba, por la rencilla de los hijos de Israel, y porque tentaron al SEÑOR, diciendo: ¿Está, pues, el SEÑOR entre nosotros, o no? ");
INSERT INTO spav1602p_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Entonces vino Amalec, y peleó con Israel en Refidim. ");
INSERT INTO spav1602p_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Y dijo Moisés a Josué: Escógenos varones, y sal, pelea con Amalec: mañana yo estaré sobre la cumbre del collado, y la vara de Dios en mi mano. ");
INSERT INTO spav1602p_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","E hizo Josué como le dijo Moisés, y peleó con Amalec; y Moisés y Aarón y Hur subieron a la cumbre del collado. ");
INSERT INTO spav1602p_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Y sucedía que cuando alzaba Moisés su mano, Israel prevale­cía; mas cuando él bajaba su mano, prevalecía Amalec. ");
INSERT INTO spav1602p_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Pero las manos de Moisés esta­ban pesadas; por lo que tomaron una piedra, y pusiéronla debajo de él, y se sentó sobre ella: y Aarón y Hur sustentaban sus manos, el uno de una parte y el otro de otra; así hubo en sus manos firmeza hasta que se puso el sol. ");
INSERT INTO spav1602p_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Y Josué deshizo a Amalec y a su pueblo a filo de espada. ");
INSERT INTO spav1602p_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Y el SEÑOR dijo a Moisés: Escribe esto para memoria en un libro, y relátalo en los oídos de Josué; que del todo raeré la memoria de Amalec de debajo del cielo. ");
INSERT INTO spav1602p_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Y Moisés edificó un altar, y llamó su nombre Jehová-­nissi; ");
INSERT INTO spav1602p_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Porque dijo: Por cuanto el SEÑOR ha jurado, que el SEÑOR tendrá guerra con Amalec de generación en generación. ");
INSERT INTO spav1602p_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Y OYÓ Jetro, sacerdote de Madián, suegro de Moisés, todas las cosas que Dios había hecho con Moisés, y con Israel su pueblo, y cómo el SEÑOR había sacado a Israel de Egipto: ");
INSERT INTO spav1602p_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Entonces tomó Jetro, suegro de Moisés, a Séfora la esposa de Moisés, después que él la envió, ");
INSERT INTO spav1602p_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","Y a sus dos hijos; el uno se llamaba Gersóm, porque dijo, Peregrino he sido en tierra ajena; ");
INSERT INTO spav1602p_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Y el nombre del otro fue Eliezer, porque dijo: El Dios de mi padre fue mi ayuda, y me libró de la espada de Faraón. ");
INSERT INTO spav1602p_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Y Jetro, el suegro de Moisés, con sus hijos y su esposa, llegó a Moisés en el desierto, donde tenía el campo junto al monte de Dios; ");
INSERT INTO spav1602p_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Y dijo a Moisés: Yo tu suegro Jetro vengo a ti, con tu esposa, y sus dos hijos con ella. ");
INSERT INTO spav1602p_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Y Moisés salió a encontrar a su suegro, y se inclinó, y lo besó; y se preguntaron el uno al otro cómo estaban, y entraron en la tienda. ");
INSERT INTO spav1602p_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Y Moisés contó a su suegro todas las cosas que el SEÑOR había hecho a Faraón y a los egipcios por amor de Israel, y todo el trabajo que habían pasado en el camino, y cómo los había librado el SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Y alegróse Jetro de todo el bien que el SEÑOR había hecho a Israel, que lo había librado de mano de los egipcios. ");
INSERT INTO spav1602p_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Y Jetro dijo: Bendito sea el SEÑOR, que os libró de mano de los egipcios, y de la mano de Faraón, y que libró al pueblo de debajo de la mano de los egipcios. ");
INSERT INTO spav1602p_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Ahora conozco que el SEÑOR es más grande que todos los dioses; hasta en lo que se ensoberbecieron contra ellos. ");
INSERT INTO spav1602p_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Y tomó Jetro, suegro de Moisés, holocaustos y sacrificios para Dios: y vino Aarón, y todos los ancianos de Israel, a comer pan con el suegro de Moisés delante de Dios. ");
INSERT INTO spav1602p_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Y aconteció que al día siguiente se sentó Moisés a juzgar al pueblo; y el pueblo estuvo delante de Moisés desde la mañana hasta la tarde. ");
INSERT INTO spav1602p_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Y cuando vio el suegro de Moisés todo lo que él hacía con el pue­blo, dijo: ¿Qué es esto que haces tú con el pueblo? ¿por qué te sientas tú solo, y todo el pueblo está delante de ti desde la mañana hasta la tarde? ");
INSERT INTO spav1602p_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Y Moisés respondió a su sue­gro: Porque el pueblo viene a mí para inquirir de Dios: ");
INSERT INTO spav1602p_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Cuando tienen negocios, vie­nen a mí; y yo juzgo entre el uno y el otro, y les declaro los estatutos de Dios y sus leyes. ");
INSERT INTO spav1602p_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Entonces el suegro de Moisés le dijo: Lo que haces no está bien: ");
INSERT INTO spav1602p_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Desfallecerás del todo, tú, y también este pueblo que está contigo; porque el negocio es demasiado pesado para ti; no podrás hacerlo tú solo. ");
INSERT INTO spav1602p_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Oye ahora mi voz, yo te acon­sejaré, y Dios será contigo. Está tú por el pueblo delante de Dios, para que puedas traer las causas a Dios. ");
INSERT INTO spav1602p_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Y enseña a ellos las ordenan­zas y las leyes, y muéstrales el camino por donde deben andar, y lo que deben hacer. ");
INSERT INTO spav1602p_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Además proveerás tú de entre todo el pueblo varones capaces, temerosos de Dios, varones de verdad, que aborrezcan la avaricia; y constituirás a éstos sobre ellos gobernantes de mil, y gobernantes de ciento, gobernantes de cincuenta y gobernantes de diez. ");
INSERT INTO spav1602p_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Y dejes que ellos juzguen al pueblo en todo tiempo; y será que todo negocio grave lo traerán a ti, y ellos juzgarán todo negocio pequeño: alivia así la carga de sobre ti, y llevarla han ellos con­tigo. ");
INSERT INTO spav1602p_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Si esto hicieres, y Dios te lo mandare así, tú podrás persistir, y todo este pueblo se irá también en paz a su lugar. ");
INSERT INTO spav1602p_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Y oyó Moisés la voz de su suegro, e hizo todo lo que dijo. ");
INSERT INTO spav1602p_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Y escogió Moisés varones capaces de todo Israel, y los hizo cabezas sobre el pueblo, gobernantes de mil, gobernantes de ciento, gobernantes de cincuenta, y gobernantes de diez. ");
INSERT INTO spav1602p_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Y ellos juzgaban al pueblo en todo tiempo: las causas difíciles traíanlo a Moisés, y ellos juzgaban todo negocio pequeño. ");
INSERT INTO spav1602p_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Y despidió Moisés a su sue­gro, y fuese a su propia tierra. ");
INSERT INTO spav1602p_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","En el mes tercero, cuando los hijos de Israel habían salido de la tierra de Egipto, en el mismo día vinieron al desierto de Sinaí. ");
INSERT INTO spav1602p_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Porque partieron de Refidim, y llegaron al desierto de Sinaí, y asentaron en el desierto; y acam­pó allí Israel delante del monte. ");
INSERT INTO spav1602p_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Y Moisés subió a Dios; y el SEÑOR lo llamó desde el monte, diciendo: Así dirás a la casa de Jacob, y anunciarás a los hijos de Israel: ");
INSERT INTO spav1602p_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Vosotros visteis lo que hice a los egipcios, y cómo os tomé sobre alas de águilas, y os he traído a mí. ");
INSERT INTO spav1602p_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Ahora pues, si obedeciereis de hecho a mi voz, y guardareis mi pacto, vosotros seréis mi tesoro peculiar sobre todos los pueblos; porque mía es toda la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Y vosotros me seréis un reino de sacerdotes y una nación santa. Éstas son las palabras que dirás a los hijos de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Entonces vino Moisés, y llamó a los ancianos del pueblo, y pro­puso en presencia de ellos todas estas palabras que el SEÑOR le había mandado. ");
INSERT INTO spav1602p_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Y todo el pueblo respondió a una, y dijeron: Todo lo que el SEÑOR ha dicho haremos. Y Moisés relató las palabras del pueblo al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Y el SEÑOR dijo a Moisés: He aquí, yo vengo a ti en una nube espesa, para que el pueblo oiga cuando yo hablo contigo, y para que te crean para siempre. Y Moisés anunció las palabras del pueblo al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Y el SEÑOR dijo a Moisés: Ve al pueblo, y santifícalos hoy y mañana y que laven sus vestiduras; ");
INSERT INTO spav1602p_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Y estén apercibidos para el día tercero, porque al tercer día el SEÑOR descenderá, a ojos de todo el pueblo, sobre el monte Sinaí. ");
INSERT INTO spav1602p_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Y señalarás términos al pueblo en derredor, diciendo: Guardaos, no subáis al monte, ni toquéis a su término: cualquiera que toca­re el monte, de seguro morirá: ");
INSERT INTO spav1602p_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","No le tocará mano, mas será apedreado o asaeteado; sea ani­mal o sea hombre, no vivirá. En habiendo sonado largamente la trompeta, subirán al monte. ");
INSERT INTO spav1602p_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Y descendió Moisés del monte al pueblo, y santificó al pueblo; y lavaron sus vestiduras. ");
INSERT INTO spav1602p_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Y dijo al pueblo: Estad apercibidos para el tercer día; no entréis a vuestras esposas. ");
INSERT INTO spav1602p_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Y aconteció al tercer día cuan­do vino la mañana, que vinieron truenos y relámpagos, y espesa nube sobre el monte, y el sonido de una trompeta muy fuerte; y estremeció­se todo el pueblo que estaba en el campamento. ");
INSERT INTO spav1602p_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Y Moisés sacó del campamento al pue­blo para encontrarse con Dios; y pusiéronse al pie del monte. ");
INSERT INTO spav1602p_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Y todo el monte de Sinaí humeaba, porque el SEÑOR descendió sobre él en fuego: y el humo de él subía como el humo de un horno, y todo el monte se estremeció en gran manera. ");
INSERT INTO spav1602p_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Y cuando la voz de la trompeta sonaba largo tiempo, y aumentado el ruido, Moisés habló, y Dios le respondió en una voz. ");
INSERT INTO spav1602p_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Y descendió el SEÑOR sobre el monte de Sinaí, sobre la cum­bre del monte: y llamó el SEÑOR a Moisés a la cumbre del monte, y Moisés subió. ");
INSERT INTO spav1602p_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Y el SEÑOR dijo a Moisés: Desciende, manda al pueblo que no traspasen el término por ver al SEÑOR, porque perecerá multitud de ellos. ");
INSERT INTO spav1602p_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Y también los sacerdotes que se llegan al SEÑOR, se santifi­quen, porque el SEÑOR no haga en ellos estrago. ");
INSERT INTO spav1602p_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Y Moisés dijo al SEÑOR: El pueblo no podrá subir al monte de Sinaí, porque tú nos has mandado diciendo: Señala tér­minos al monte, y santifícalo. ");
INSERT INTO spav1602p_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Y el SEÑOR le dijo: Ve, des­ciende, y subirás tú, y Aarón con­tigo: mas los sacerdotes y el pue­blo no traspasen el término por subir al SEÑOR, porque no haga en ellos estrago. ");
INSERT INTO spav1602p_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Entonces Moisés descendió al pueblo, y habló con ellos. ");
INSERT INTO spav1602p_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Y HABLÓ Dios todas estas palabras, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Yo soy el SEÑOR tu Dios, que te saqué de la tierra de Egipto, de casa de siervos. ");
INSERT INTO spav1602p_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","No tendrás dioses ajenos delante de mí. ");
INSERT INTO spav1602p_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","No te harás imagen tallada, ni ninguna semejanza de cosa que esté arri­ba en el cielo, ni abajo en la tie­rra, ni en las aguas debajo de la tierra: ");
INSERT INTO spav1602p_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","No te inclinarás a ellas, ni las honrarás; porque yo el SEÑOR tu Dios soy Dios celoso, que visi­to la maldad de los padres sobre los hijos, sobre los terceros y sobre los cuartos, a los que me aborrecen, ");
INSERT INTO spav1602p_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Y que hago misericordia en millares a los que me aman, y guardan mis mandamientos. ");
INSERT INTO spav1602p_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","No tomarás el nombre del SEÑOR tu Dios en vano; porque no dará por inocente el SEÑOR al que tomare su nombre en vano. ");
INSERT INTO spav1602p_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Acordarte has del día del sába­do, para santificarlo: ");
INSERT INTO spav1602p_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Seis días trabajarás, y harás toda tu obra; ");
INSERT INTO spav1602p_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Mas el séptimo día es el sába­do para el SEÑOR tu Dios: no hagas en él obra alguna, tú, ni tu hijo, ni tu hija, ni tu siervo, ni tu criada, ni tu bestia, ni tu extranje­ro que está dentro de tus puertas: ");
INSERT INTO spav1602p_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Porque en seis días hizo el SEÑOR el cielo y la tierra, el mar y todas las cosas que en ellos hay, y reposó en el séptimo día: por tanto el SEÑOR bendijo el día del sábado y lo santificó. ");
INSERT INTO spav1602p_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Honra a tu padre y a tu madre, porque tus días se alarguen en la tierra que el SEÑOR tu Dios te da. ");
INSERT INTO spav1602p_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","No matarás. ");
INSERT INTO spav1602p_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","No cometerás adulterio. ");
INSERT INTO spav1602p_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","No hurtarás. ");
INSERT INTO spav1602p_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","No hablarás contra tu prójimo falso testimonio. ");
INSERT INTO spav1602p_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","No codiciarás la casa de tu prójimo, no codiciarás la esposa de tu prójimo, ni su siervo, ni su criada, ni su buey, ni su asno, ni cosa alguna de tu prójimo. ");
INSERT INTO spav1602p_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Y todo el pueblo veía los truenos, y los relámpagos, y el soni­do de la trompeta, y el monte que humeaba: y viéndolo el pueblo, se retiró, y púsose de lejos. ");
INSERT INTO spav1602p_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Y dijeron a Moisés: Habla tú con nosotros, que nosotros oire­mos; mas no hable Dios con nosotros, porque no muramos. ");
INSERT INTO spav1602p_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Y Moisés dijo al pue­blo: No temáis; que por probaros vino Dios, y porque su temor esté en vuestra presencia para que no pequéis. ");
INSERT INTO spav1602p_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Y el pueblo se puso de lejos, y Moisés se llegó a la obs­curidad, en la cual estaba Dios. ");
INSERT INTO spav1602p_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Y el SEÑOR dijo a Moisés: Así dirás a los hijos de Israel: Vosotros habéis visto que he hablado desde el cielo con vo­sotros. ");
INSERT INTO spav1602p_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","No hagáis conmigo dioses de plata, ni dioses de oro os haréis. ");
INSERT INTO spav1602p_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Altar de tierra harás para mí, y sacrificarás sobre él tus holo­caustos y tus pacíficos, tus ovejas y tus vacas: en cualquier lugar donde yo hiciere que esté la memoria de mi nombre, vendré a ti, y te bendeciré. ");
INSERT INTO spav1602p_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Y si me hicieres un altar de piedra, no lo edifiques de piedra labrada; porque si alzares tu herramienta sobre él, tú lo has profanado. ");
INSERT INTO spav1602p_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Y no subirás por gradas a mi altar, porque tu desnudez no sea junto a él descubierta. ");
INSERT INTO spav1602p_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Y ÉSTOS son los juicios que pondrás delante de ellos. ");
INSERT INTO spav1602p_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Si comprares siervo hebreo, seis años servirá; pero al séptimo saldrá libre gratuitamente. ");
INSERT INTO spav1602p_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Si entró solo, solo saldrá: si tenía esposa, saldrá él y su esposa con él. ");
INSERT INTO spav1602p_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Si su amo le hubiere dado esposa, y ella le hubiere parido hijos o hijas, la esposa y sus hijos serán de su amo, y él saldrá solo. ");
INSERT INTO spav1602p_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Y si el siervo dijere claramente: Yo amo a mi señor, a mi esposa y a mis hijos, no saldré libre: ");
INSERT INTO spav1602p_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","Entonces su amo lo hará llegar a los jueces, y harále llegar a la puerta o al poste de la puerta; y su amo le horadará la oreja con lesna, y será su siervo para siempre. ");
INSERT INTO spav1602p_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Y si alguno vendiere su hija por sierva, no saldrá como suelen salir los siervos. ");
INSERT INTO spav1602p_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Si no agradare a su señor, quien le desposó consigo mismo, entonces permitirle ha que sea redimida, y no la podrá vender a pueblo extraño cuando la desechare. ");
INSERT INTO spav1602p_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Y si la hubiere desposado con su hijo, hará con ella según la costumbre de las hijas. ");
INSERT INTO spav1602p_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Si le tomare otra esposa, no dismi­nuirá su alimento, ni su vestidura, ni el débito conyugal. ");
INSERT INTO spav1602p_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Y si ninguna de estas tres cosas hiciere, ella saldrá de gra­cia sin dinero. ");
INSERT INTO spav1602p_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","El que hiriere a alguno, haciéndole así morir, él ciertamente morirá. ");
INSERT INTO spav1602p_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Y el que no armó asechan­zas, sino que Dios lo puso en sus manos, entonces yo te señalaré lugar al cual ha de huir. ");
INSERT INTO spav1602p_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Pero, si alguno se enso­berbeciere contra su prójimo, y lo matare con alevosía, de mi altar lo quitarás para que muera. ");
INSERT INTO spav1602p_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Y el que hiriere a su padre o a su madre, ciertamente morirá. ");
INSERT INTO spav1602p_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Y el que robare una persona, y la vendiere, o se halla­re en sus manos, ciertamente morirá. ");
INSERT INTO spav1602p_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Y el que maldijere a su padre o a su madre, ciertamente morirá. ");
INSERT INTO spav1602p_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Y si algunos riñeren, y alguno hiriere a su prójimo con piedra o con el puño, y no muriere, pero cayere en cama; ");
INSERT INTO spav1602p_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","Si se levantare y anduviere fuera sobre su báculo, entonces será el que le hirió absuelto: solamente le pagará por su tiempo perdido, y hará que le curen completamente. ");
INSERT INTO spav1602p_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Y si alguno hiriere a su siervo o a su sierva con palo, y muriere bajo de su mano, será ciertamente castigado: ");
INSERT INTO spav1602p_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Mas si durare por un día o dos, no será castigado, porque su dinero es. ");
INSERT INTO spav1602p_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Si hombres riñeren, y uno hiriere a mujer preñada, para que salga su fruto, pero sin haber daño, ciertamente él será castigado conforme a lo que le impusiere el marido de la mujer, y pagará según determinen los jueces. ");
INSERT INTO spav1602p_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Y si hubiere algún daño, entonces darás vida por vida, ");
INSERT INTO spav1602p_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Ojo por ojo, diente por diente, mano por mano, pie por pie, ");
INSERT INTO spav1602p_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Quemadura por quemadura, herida por herida, golpe por golpe. ");
INSERT INTO spav1602p_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Y si alguno hiriere el ojo de su siervo, o el ojo de su sierva, y lo dañare, le dejará ir libre por razón de su ojo. ");
INSERT INTO spav1602p_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Y si sacare el diente de su sier­vo, o el diente de su sierva, por su diente le dejará ir libre. ");
INSERT INTO spav1602p_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Si un buey acorneare hombre o mujer, y de resultas muriere, el buey será apedreado, y no se comerá su carne; mas el dueño del buey será absuelto. ");
INSERT INTO spav1602p_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Pero si el buey era acorneador desde ayer y antes de ayer, y a su dueño le fue hecho requerimien­to, y no lo hubiere guardado, y matare hombre o mujer, el buey será apedreado, y también mori­rá su dueño. ");
INSERT INTO spav1602p_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Si le fuere impuesto rescate, entonces dará por el rescate de su persona cuanto le fuere impues­to. ");
INSERT INTO spav1602p_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Haya acorneado hijo, o haya acorneado hija, conforme a este juicio se hará con él. ");
INSERT INTO spav1602p_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Si el buey acorneare siervo o sierva, pagará treinta siclos de plata su señor, y el buey será ape­dreado. ");
INSERT INTO spav1602p_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Y si alguno abriere pozo, o si alguno cavare pozo, y no lo cubriere, y cayere allí buey o asno, ");
INSERT INTO spav1602p_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","El dueño del pozo lo reparará, y pagará el dinero a su dueño, y el animal muerto será suyo. ");
INSERT INTO spav1602p_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Y si el buey de alguno hiriere al buey de su prójimo, y éste muriere, entonces venderán el buey vivo, y partirán el dinero de él, y también partirán el buey muerto. ");
INSERT INTO spav1602p_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","O si era notorio que el buey era acorneador de ayer y antes de ayer, y su dueño no lo hubiere guardado, pagará buey por buey, y el muerto será suyo. ");
INSERT INTO spav1602p_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","CUANDO alguno hurtare buey u oveja, y le degollare o vendiere, por aquel buey pagará cinco bueyes, y por aquella oveja cuatro ovejas. ");
INSERT INTO spav1602p_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Si un ladrón fuere hallado entrando en una casa, y fuere herido hasta que muriere, no derramarás la sangre de aquel que le mató. ");
INSERT INTO spav1602p_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Si el sol hubiere sobre él salido, será sangre derramada por él: el ladrón habrá de restituir cumplidamente; si no tuviere, será vendido por su hurto. ");
INSERT INTO spav1602p_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Si fuere hallado con el hurto en la mano, sea buey o asno u oveja vivos, pagará el doble. ");
INSERT INTO spav1602p_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Si alguno hiciere pacer campo o viña, y metiere su bestia, y comiere en la tierra de otro, de lo mejor de su propia tierra y de lo mejor de su propia viña pagará. ");
INSERT INTO spav1602p_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Si rompiere un fuego, y prendiere espinas, y fuere quemado grano amontonado, o en pie, o el campo, el que encendió el fuego ciertamente hará restitución. ");
INSERT INTO spav1602p_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Cuando alguno diere a su pró­jimo plata o alhajas a guardar, y fuere hurtado de la casa de aquel hombre, si el ladrón se hallare, pagará el doble. ");
INSERT INTO spav1602p_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Si el ladrón no se hallare, entonces el dueño de la casa será presentado a los jueces, para ver si ha metido su mano en la hacienda de su prójimo. ");
INSERT INTO spav1602p_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Sobre todo negocio de fraude, si fuere sobre buey, sobre asno, sobre oveja, sobre vestidura, o sobre toda cosa perdida, cuando uno dijere: Esto es mío, la causa de ambos vendrá delante de los jueces; y el que los jueces condenaren, paga­rá el doble a su prójimo. ");
INSERT INTO spav1602p_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Si alguno hubiere dado a su prójimo asno, o buey, u oveja, o cualquier otro animal a guardar, y se muriere, o se perniquebrare, o fuere llevado sin verlo nadie; ");
INSERT INTO spav1602p_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","Juramento del SEÑOR tendrá lugar entre ambos de que no echó su mano a la hacienda de su prójimo; y su dueño lo aceptará, y el otro no lo pagará. ");
INSERT INTO spav1602p_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Mas si le hubiere sido hurta­do, restituirá a su dueño. ");
INSERT INTO spav1602p_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Y si le hubiere sido despedazado por fiera, traerle ha testimo­nio, y no pagará lo despedazado. ");
INSERT INTO spav1602p_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Y si alguno hubiere toma­do prestada bestia de su prójimo, y fuere estropeada o muerta, ausente su dueño, deberá pagar­la. ");
INSERT INTO spav1602p_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Pero si el dueño estaba presente, no la pagará. Si era alquilada, él vendrá por su alquiler. ");
INSERT INTO spav1602p_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Y si alguno engañare a alguna doncella que no fuere desposada, y durmiere con ella, deberá dotarla y tomarla por esposa. ");
INSERT INTO spav1602p_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Si su padre no quisiere dárse­la, él le pesará plata conforme al dote de las vírgenes. ");
INSERT INTO spav1602p_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","A la hechicera no dejarás que viva. ");
INSERT INTO spav1602p_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Cualquiera que tuviere ayun­tamiento con bestia, morirá. ");
INSERT INTO spav1602p_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","El que sacrificare a cualquier dios, excepto a sólo el SEÑOR, él será completamente destruido. ");
INSERT INTO spav1602p_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Y al extranjero no engañarás, ni angustiarás, porque extranje­ros fuisteis vosotros en la tierra de Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","A ninguna viuda ni huérfano afligiréis. ");
INSERT INTO spav1602p_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Que si tú llegas a afligirle, y él a mí clamare, ciertamente oiré yo su clamor; ");
INSERT INTO spav1602p_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Y mi furor se encenderá, y os mataré a espada, y vuestras esposas serán viudas, y huérfa­nos vuestros hijos. ");
INSERT INTO spav1602p_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Si prestares dinero a alguien que es pobre de los de mi pueblo que está contigo, no serás usurero para con él; no le impondrás usura. ");
INSERT INTO spav1602p_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Si tomares en prenda la vestidura de tu prójimo, a puestas del sol se la volverás: ");
INSERT INTO spav1602p_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Porque sólo aquella es su cubierta, es su vestidura para su piel: ¿En qué ha de dormir? Y será que cuando él a mí clamare, yo entonces le oiré, porque soy clemente. ");
INSERT INTO spav1602p_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","No injuriarás a los dioses, ni maldecirás al príncipe de tu pue­blo. ");
INSERT INTO spav1602p_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","No dilatarás en ofrecer la primicia de tu cosecha, ni de tu lagar: me darás el primogénito de tus hijos. ");
INSERT INTO spav1602p_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Así harás con el de tu buey y de tu oveja: siete días estará con su madre, y al octavo día me lo darás. ");
INSERT INTO spav1602p_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Y habéis de serme varones santos: y no comeréis ninguna carne arre­batada de las fieras en el campo; a los perros la echaréis. ");
INSERT INTO spav1602p_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","NO levantarás falso rumor. No pongas tu mano con el impío para ser testigo falso. ");
INSERT INTO spav1602p_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","No seguirás a los muchos para mal hacer; ni responderás en liti­gio inclinándote a los más para hacer agravios; ");
INSERT INTO spav1602p_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Ni al pobre favorecerás en su causa. ");
INSERT INTO spav1602p_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Si encontrares el buey de tu enemigo o su asno extraviado, sin falta se lo volverás a él. ");
INSERT INTO spav1602p_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Si vieres el asno del que te aborrece caído debajo de su carga, y te abstendrías en ayudarlo, sin falta ayudarás con él a levantarlo. ");
INSERT INTO spav1602p_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","No quitarás el derecho de tu pobre en su causa. ");
INSERT INTO spav1602p_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","De palabra de mentira te aleja­rás, y no matarás al inocente y justo; porque yo no justificaré al impío. ");
INSERT INTO spav1602p_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Y no recibirás presente; porque el presente ciega a los sabios, y pervierte las palabras justas. ");
INSERT INTO spav1602p_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Tampoco angustiarás al extranjero: pues vosotros conocéis el corazón del extranjero, ya que extranjeros fuisteis en la tie­rra de Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Y seis años sembrarás tu tierra, y allegarás los frutos de ella: ");
INSERT INTO spav1602p_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Pero el séptimo año la dejarás vacante y soltarás, para que coman los pobres de tu pueblo; y de lo que quedare comerán las bestias del campo; así harás de tu viña y de tu olivar. ");
INSERT INTO spav1602p_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Seis días harás tus negocios, y al séptimo día holgarás, a fin que descanse tu buey y tu asno, y tome refrigerio el hijo de tu sier­va, y el extranjero. ");
INSERT INTO spav1602p_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Y en todas las cosas que os he dicho seréis avisados. Y nombre de otros dioses no mencionaréis, ni se oirá de vuestra boca. ");
INSERT INTO spav1602p_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Tres veces en el año me guardaréis fiesta. ");
INSERT INTO spav1602p_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","La fiesta de los panes sin levadura guar­darás: siete días comerás los panes sin levadura, como yo te mandé, en el tiempo del mes de Abib; porque en él saliste de Egipto: y ninguno comparecerá vacío delante de mí: ");
INSERT INTO spav1602p_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","También la fiesta de la siega, los primeros frutos de tus labores que hubieres sembrado en el campo; y la fiesta de la cosecha, la cual es al fin del año, cuando habrás recogido tus labores del campo. ");
INSERT INTO spav1602p_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Tres veces en el año se presentarán todos tus varones delante del Señor DIOS. ");
INSERT INTO spav1602p_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","No ofrecerás la sangre de mi sacrifico con pan leudado; ni el sebo de mi sacrificio quedará de la noche hasta la mañana. ");
INSERT INTO spav1602p_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Las primicias de los primeros frutos de tu tierra traerás a la casa del SEÑOR tu Dios. No guisarás el cabrito con la leche de su madre. ");
INSERT INTO spav1602p_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","He aquí yo envío un Ángel delante de ti para que te guarde en el camino, y te introduzca en el lugar que yo he preparado. ");
INSERT INTO spav1602p_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Guárdate delante de él, y obedece su voz; no le provoques; por­que él no perdonará vuestra rebe­lión: porque mi nombre está en él. ");
INSERT INTO spav1602p_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Pero si en verdad obedecieres su voz, e hicieres todo lo que yo te dijere, seré enemigo a tus enemi­gos, y afligiré a los que te afligie­ren. ");
INSERT INTO spav1602p_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Porque mi Ángel irá delante de ti, y te introducirá al amorreo, y al heteo, y al ferezeo, y al cananeo, y al heveo, y al jebuseo, a los cuales yo haré des­truir. ");
INSERT INTO spav1602p_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","No te inclinarás a sus dioses, ni los servirás, ni harás conforme a sus obras; antes los destruirás del todo, y quebrantarás entera­mente sus estatuas. ");
INSERT INTO spav1602p_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Mas al SEÑOR vuestro Dios serviréis, y él bendecirá tu pan y tus aguas; y yo quitaré toda enfermedad de en medio de ti. ");
INSERT INTO spav1602p_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","No habrá mujer que aborte, ni estéril en tu tierra; y yo cumpliré el número de tus días. ");
INSERT INTO spav1602p_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Yo enviaré mi terror delante de ti, y destruiré a todo pueblo donde tú entrares, y haré que todos tus enemigos te den la espalda. ");
INSERT INTO spav1602p_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Yo enviaré la avispa delante de ti, que eche fuera al heveo, y al cananeo, y al heteo, de delante de ti: ");
INSERT INTO spav1602p_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","No los echaré de delante de ti en un año, para que no quede la tierra desierta, y se aumenten contra ti las bestias del campo. ");
INSERT INTO spav1602p_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Poco a poco los echaré de delante de ti, hasta que te multi­pliques y tomes la tierra por heredad. ");
INSERT INTO spav1602p_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Y yo pondré tus términos desde el mar Bermejo hasta el mar de Filistea, y desde el desierto hasta el río; porque pondré en vuestras manos los moradores de la tierra, y tú los echarás de delante de ti. ");
INSERT INTO spav1602p_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","No harás pacto con ellos, ni con sus dioses. ");
INSERT INTO spav1602p_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","En tu tierra no habitarán, no sea que te hagan pecar contra mí: porque si sirvieres a sus dioses, ciertamente te será de tropiezo. ");
INSERT INTO spav1602p_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Y DIJO a Moisés: Sube al SEÑOR, tú, y Aarón, Nadab, y Abiú, y setenta de los ancianos de Israel; y os inclinaréis desde lejos. ");
INSERT INTO spav1602p_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Mas Moisés sólo se llegará al SEÑOR; y ellos no se lleguen cerca, ni suba con él el pueblo. ");
INSERT INTO spav1602p_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Y Moisés vino y contó al pue­blo todas las palabras del SEÑOR, y todos los juicios; y todo el pueblo respondió a una voz, y dijeron: Ejecutaremos todas las palabras que el SEÑOR ha dicho. ");
INSERT INTO spav1602p_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Y Moisés escribió todas las palabras del SEÑOR, y levantán­dose muy de mañana, edificó un altar al pie del monte, y doce colum­nas, según las doce tribus de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Y envió a los mancebos de los hijos de Israel, los cuales ofrecieron holocaustos, y sacrificaron ofrendas de paz de becerros al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Y Moisés tomó la mitad de la sangre, y púsola en tazones, y esparció la otra mitad de la san­gre sobre el altar. ");
INSERT INTO spav1602p_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Y tomó el libro del pacto, y leyó a oídos del pueblo, el cual dijo: Haremos todas las cosas que el SEÑOR ha dicho, y seremos obe­dientes. ");
INSERT INTO spav1602p_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Entonces Moisés tomó la san­gre, y rocióla sobre el pueblo, y dijo: He aquí la sangre del pacto que el SEÑOR ha hecho con vosotros sobre todas estas palabras. ");
INSERT INTO spav1602p_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Y subieron Moisés y Aarón, Nadab y Abiú, y setenta de los ancianos de Israel; ");
INSERT INTO spav1602p_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Y vieron al Dios de Israel; y había debajo de sus pies como una piedra de zafiro, parecido al cielo en su claridad. ");
INSERT INTO spav1602p_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Mas no extendió su mano sobre los nobles de los hijos de Israel: también vieron a Dios, y comieron y bebieron. ");
INSERT INTO spav1602p_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Y el SEÑOR dijo a Moisés: Sube a mí al monte, y espera allá, y te daré tablas de piedra, y una ley, y mandamientos que he escrito para enseñarlos. ");
INSERT INTO spav1602p_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Y levantóse Moisés, y Josué su ministro; y Moisés subió al monte de Dios. ");
INSERT INTO spav1602p_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Y dijo a los ancianos: Esperadnos aquí hasta que vol­vamos a vosotros: y he aquí Aarón y Hur están con vosotros: el que tuviere negocios, lléguese a ellos. ");
INSERT INTO spav1602p_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Entonces Moisés subió al monte, y una nube cubrió el monte. ");
INSERT INTO spav1602p_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Y la gloria del SEÑOR reposó sobre el monte Sinaí, y la nube lo cubrió por seis días: y al sépti­mo día llamó a Moisés de en medio de la nube. ");
INSERT INTO spav1602p_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Y el parecer de la gloria del SEÑOR era como un fuego abrasador en la cumbre del monte, a los ojos de los hijos de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Y entró Moisés en medio de la nube, y subió al monte: y estuvo Moisés en el monte cuarenta días y cuarenta noches. ");
INSERT INTO spav1602p_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Y EL SEÑOR habló a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","Di a los hijos de Israel, que tomen para mí ofrenda: de todo varón que la diere de su volun­tad, de corazón, tomaréis mi ofrenda. ");
INSERT INTO spav1602p_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Y ésta es la ofrenda que toma­réis de ellos: Oro, y plata, y latón, ");
INSERT INTO spav1602p_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","Y azul, y púrpura, y escarlata, y lino fino, y pelo de cabras, ");
INSERT INTO spav1602p_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","Y pieles de carneros teñidos de rojo, y pieles de tejones, y madera de acacia; ");
INSERT INTO spav1602p_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","Aceite para la luminaria, espe­cias para el aceite de la unción, y para el incienso aromático; ");
INSERT INTO spav1602p_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","Piedras de ónix, y piedras de engastes, para el efod, y para la coraza. ");
INSERT INTO spav1602p_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Y me harán un santuario; para que yo habite entre ellos. ");
INSERT INTO spav1602p_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Conforme a todo lo que yo te mostrare, según el modelo del taberná­culo, y el modelo de todos sus vasos, así lo haréis. ");
INSERT INTO spav1602p_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Harán también un arca de madera de acacia, cuya longitud será de dos codos y medio, y su anchura de codo y medio, y su altura de codo y medio. ");
INSERT INTO spav1602p_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Y la cubrirás de oro puro; por dentro y por fuera la cubrirás; y harás sobre ella una cornisa de oro alrededor. ");
INSERT INTO spav1602p_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Y para ella harás de fundición cuatro anillos de oro, y los pondrás en sus cuatro esquinas; dos anillos en un lado de ella, y dos anillos en el otro lado. ");
INSERT INTO spav1602p_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Y harás unas varas de madera de acacia, las cuales cubrirás de oro, ");
INSERT INTO spav1602p_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Y meterás las varas por los anillos a los lados del arca, para llevar el arca con ellas. ");
INSERT INTO spav1602p_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Las varas se estarán en los anillos del arca: no se quitarán de ella. ");
INSERT INTO spav1602p_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Y pondrás en el arca el testi­monio que yo te daré. ");
INSERT INTO spav1602p_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Y harás un propiciatorio de oro fino, cuya longitud será de dos codos y medio, y su anchura de codo y medio. ");
INSERT INTO spav1602p_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Harás también dos querubi­nes de oro, labrados a martillo los harás, en los dos extremos del propiciatorio. ");
INSERT INTO spav1602p_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Y harás un querubín en un extremo, y el otro querubín en el otro extremo: aun del propiciatorio harás los querubines en sus dos extremos. ");
INSERT INTO spav1602p_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Y los querubines extenderán por encima sus alas, cubriendo con sus alas el propiciatorio, y sus caras la una enfrente de la otra, hacia el propiciatorio serán las caras de los querubines. ");
INSERT INTO spav1602p_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Y pondrás el propiciatorio encima del arca, y en el arca pondrás el testimonio que yo te daré. ");
INSERT INTO spav1602p_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Y de allí me declararé a ti, y hablaré contigo de sobre el propiciatorio, de entre los dos queru­bines que están sobre el arca del testimonio, todas las cosas que yo te mandaré para los hijos de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Harás asimismo una mesa de madera de acacia: su longitud será de dos codos, y de un codo su anchura, y su altura de codo y medio. ");
INSERT INTO spav1602p_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Y la cubrirás de oro puro, y le harás una cornisa de oro alrededor. ");
INSERT INTO spav1602p_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Y le harás también una mol­dura alrededor, del ancho de una mano, a la cual moldura harás una cornisa de oro alrededor. ");
INSERT INTO spav1602p_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Y le harás cuatro anillos de oro, los cuales pondrás a las cua­tro esquinas que están en sus cuatro pies. ");
INSERT INTO spav1602p_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Los anillos estarán antes de la moldura, por lugares de las varas, para llevar la mesa. ");
INSERT INTO spav1602p_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Y harás las varas de madera de acacia, y las cubrirás de oro, y con ellas será llevada la mesa. ");
INSERT INTO spav1602p_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Harás también sus platos, y sus cucharas, y sus cubiertas, y sus tazones, con que se cubrirá: de oro fino los harás. ");
INSERT INTO spav1602p_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Y pondrás sobre la mesa el pan de la proposición delante de mí continuamente. ");
INSERT INTO spav1602p_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Harás además un candelero de oro puro; labrado a martillo se hará el candelero: su pie, y su caña, sus copas, sus manzanas, y sus flores, serán de lo mismo: ");
INSERT INTO spav1602p_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Y saldrán seis brazos de sus lados: tres brazos del candelero de un lado suyo, y tres brazos del candelero del otro lado: ");
INSERT INTO spav1602p_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Tres copas en forma de almendras en el un brazo, con una manzana y una flor; y tres copas, figura de almendras, en el otro brazo, con una manzana y una flor: así pues, en los seis brazos que salen del candelero: ");
INSERT INTO spav1602p_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Y en el candelero habrá cuatro copas en forma de almendras, con sus manzanas y sus flores. ");
INSERT INTO spav1602p_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Y habrá una manzana debajo de los dos brazos de lo mismo, otra manzana debajo de los otros dos brazos de lo mismo, y otra man­zana debajo de los otros dos bra­zos de lo mismo, en conformidad a los seis brazos que salen del candelero. ");
INSERT INTO spav1602p_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Sus manzanas y sus brazos serán de lo mismo, todo ello será una pieza labrada a martillo, de oro puro. ");
INSERT INTO spav1602p_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Y le harás siete lámparas, las cuales encenderás para que alumbren a la parte de su delan­tera: ");
INSERT INTO spav1602p_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","También sus despabiladeras y sus platillos, serán de oro puro. ");
INSERT INTO spav1602p_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","De un talento de oro fino lo harás, con todos estos vasos. ");
INSERT INTO spav1602p_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Y mira, y hazlos conforme a su modelo, que te ha sido mos­trado en el monte. ");
INSERT INTO spav1602p_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","ADEMÁS harás el tabernáculo con diez cortinas de lino torcido, azul, y púrpura, y escarlata: y harás querubines de obra ingeniosa. ");
INSERT INTO spav1602p_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","La longitud de una cortina será de veintiocho codos, y la anchura de la misma cortina de cuatro codos: todas las cortinas tendrán una medida. ");
INSERT INTO spav1602p_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Las cinco cortinas estarán juntas la una con la otra, y otras cinco cortinas serán unidas la una con la otra. ");
INSERT INTO spav1602p_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Y harás lazadas de azul en la orilla de la una cortina, en el borde, en la juntura: y así harás en la orilla de la postrera cortina en la juntura segunda. ");
INSERT INTO spav1602p_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Cincuenta lazadas harás en la una cortina, y cincuenta lazadas harás en el borde de la cortina que está en la segunda juntura: las lazadas estarán contrapuestas la una a la otra. ");
INSERT INTO spav1602p_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Harás también cincuenta cor­chetes de oro, con los cuales jun­tarás las cortinas la una con la otra, y se formará un tabernácu­lo. ");
INSERT INTO spav1602p_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Harás asimismo cortinas de pelo de cabras para una cubierta sobre el tabernáculo; once corti­nas harás. ");
INSERT INTO spav1602p_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","La longitud de la una cortina será de treinta codos, y la anchu­ra de la misma cortina de cuatro codos: una medida tendrán las once cortinas. ");
INSERT INTO spav1602p_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Y juntarás las cinco cortinas aparte y las otras seis cortinas separadamente; y doblarás la sexta cortina delante de la faz del tabernáculo. ");
INSERT INTO spav1602p_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Y harás cincuenta lazadas en la orilla de la una cortina, que está al borde en la juntura, y cincuenta lazadas en el borde de la cortina en la segunda juntura. ");
INSERT INTO spav1602p_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Harás asimismo cincuenta corchetes de latón, los cuales meterás por las lazadas: y junta­rás la tienda, para que se haga una sola cubierta. ");
INSERT INTO spav1602p_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Y el sobrante que resulta en las cortinas de la tienda, la mitad de la una cortina que sobra, que­dará a las espaldas del tabernácu­lo. ");
INSERT INTO spav1602p_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Y un codo de la una parte, y otro codo de la otra que sobra en la longitud de las cortinas de la tienda, cargará sobre los lados del tabernáculo de la una parte y de la otra, para cubrirlo. ");
INSERT INTO spav1602p_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Harás también a la tienda una cubierta de cueros de carneros, teñidos de rojo, y una cubierta de cueros de tejones encima. ");
INSERT INTO spav1602p_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Y harás para el tabernáculo tablas de madera de acacia, que estén derechas. ");
INSERT INTO spav1602p_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","La longitud de cada tabla será de diez codos, y de codo y medio será la anchura de cada tabla. ");
INSERT INTO spav1602p_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Dos quicios tendrá cada tabla, trabadas la una con la otra; así harás todas las tablas del taberná­culo. ");
INSERT INTO spav1602p_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Harás, pues, las tablas del tabernáculo: veinte tablas al lado del austro, al sur. ");
INSERT INTO spav1602p_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Y harás cuarenta basas de plata debajo de las veinte tablas; dos basas debajo de la una tabla para sus dos quicios, y dos basas debajo de la otra tabla para sus dos quicios. ");
INSERT INTO spav1602p_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Y al otro lado del tabernáculo, a la parte del norte, serán veinte tablas; ");
INSERT INTO spav1602p_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Y sus cuarenta basas de plata: dos basas debajo de la una tabla, y dos basas debajo de la otra tabla. ");
INSERT INTO spav1602p_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Y para el lado del tabernáculo, al occidente, harás seis tablas. ");
INSERT INTO spav1602p_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Y harás dos tablas para las esquinas del tabernáculo en los dos ángulos posteriores; ");
INSERT INTO spav1602p_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Las cuales se unirán por abajo, y asimismo se juntarán por su alto a un anillo: así será de las otras dos que estarán a las dos esquinas. ");
INSERT INTO spav1602p_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Y serán ocho tablas, y sus basas de plata, diez y seis basas; dos basas deba­jo de la una tabla, y dos basas debajo de la otra tabla. ");
INSERT INTO spav1602p_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Harás también barras de madera de acacia; cinco para las tablas del tabernáculo, ");
INSERT INTO spav1602p_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","Y cinco barras para las tablas del otro lado del tabernáculo, y cinco barras para las tablas del lado del tabernáculo, para los dos lados al occidente. ");
INSERT INTO spav1602p_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Y la barra del medio pasará por medio de las tablas, del un cabo al otro. ");
INSERT INTO spav1602p_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Y cubrirás las tablas de oro, y harás sus anillos de oro para meter por ellos las barras: también cubrirás las barras de oro. ");
INSERT INTO spav1602p_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Y alzarás el tabernáculo conforme al modelo que te fue mos­trado en el monte. ");
INSERT INTO spav1602p_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Y harás también un velo de azul, y púrpura, y escarlata, y de lino fino torcido: será hecho de obra ingeniosa, con querubines: ");
INSERT INTO spav1602p_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Y has de ponerlo sobre cuatro columnas de madera de acacia cubiertas de oro; sus capiteles serán de oro, sobre basas de plata. ");
INSERT INTO spav1602p_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Y pondrás el velo debajo de los corchetes, y meterás allí, del velo adentro, el arca del testimo­nio; y aquel velo os hará separa­ción entre el lugar santo y el san­tísimo. ");
INSERT INTO spav1602p_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Y pondrás el propiciatorio sobre el arca del testimonio en el lugar santísimo. ");
INSERT INTO spav1602p_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Y pondrás la mesa fuera del velo, y el candelero enfrente de la mesa al lado del tabernáculo al sur; y pondrás la mesa al lado del norte. ");
INSERT INTO spav1602p_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Y harás a la puerta del taber­náculo una cortina de azul, y púrpura, y escarlata, y lino fino torci­do, obra de bordador. ");
INSERT INTO spav1602p_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Y harás para la cortina cinco columnas de madera de acacia, las cuales cubrirás de oro, y sus capiteles serán de oro: y hacerlas has de fundición cinco basas de latón. ");
INSERT INTO spav1602p_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","HARÁS también altar de madera de acacia de cinco codos de longitud, y de cinco codos de anchura: será cuadrado el altar, y su altura será de tres codos. ");
INSERT INTO spav1602p_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Y harás sus cuernos a sus cuatro esquinas; los cuernos serán de lo mismo; y lo cubrirás de latón. ");
INSERT INTO spav1602p_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Harás también sus calderas para echar su ceniza; y sus pale­tas, y sus tazones, y sus garfios, y sus braseros: harás todos sus vasos de latón. ");
INSERT INTO spav1602p_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Y le harás un enrejado de latón de obra de malla; y sobre el enrejado harás cuatro anillos de latón a sus cuatro esquinas. ");
INSERT INTO spav1602p_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Y lo pondrás dentro del cerco del altar abajo; y llegará el enrejado hasta el medio del altar. ");
INSERT INTO spav1602p_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Harás también varas para el altar, varas de madera de acacia, las cuales cubrirás de latón. ");
INSERT INTO spav1602p_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Y sus varas se meterán por los anillos: y estarán aquellas varas a ambos lados del altar, para llevarlo. ");
INSERT INTO spav1602p_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","De tablas lo harás, hueco: de la manera que te fue mostrado en el monte, así lo harás. ");
INSERT INTO spav1602p_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Y harás el patio del tabernáculo: para el lado del austro, hacia el sur, tendrá el patio cortinas de lino fino torcido, de cien codos de longitud cada lado; ");
INSERT INTO spav1602p_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Sus veinte columnas, y sus veinte basas serán de latón; los capiteles de las columnas y sus molduras serán de plata. ");
INSERT INTO spav1602p_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Y de la misma manera al lado del norte habrá a lo largo corti­nas de cien codos de longitud, y sus veinte columnas, con sus veinte basas de latón; los capiteles de sus columnas y sus mol­duras, de plata. ");
INSERT INTO spav1602p_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Y el ancho del patio del lado occidental tendrá cortinas de cin­cuenta codos; sus columnas diez, con sus diez basas. ");
INSERT INTO spav1602p_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Y en el ancho del patio por la parte de levante, al oriente, habrá cincuenta codos. ");
INSERT INTO spav1602p_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Y las cortinas de un lado de la puerta serán de quince codos; sus columnas tres, con sus tres basas. ");
INSERT INTO spav1602p_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Y al otro lado serán cortinas de quince codos: sus columnas tres, y sus basas tres. ");
INSERT INTO spav1602p_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Y a la puerta del atrio será una cortina de veinte codos, de azul, y púrpura, y escarlata, y lino fino torcido, de obra de bordador: y sus columnas serán cuatro, y sus cuatro basas. ");
INSERT INTO spav1602p_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Todas las columnas del patio en derredor serán ceñidas de plata; sus capiteles serán de plata, y sus basas de latón. ");
INSERT INTO spav1602p_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","La longitud del patio será de cien codos, y la anchura cincuen­ta por un lado y cincuenta por el otro, y la altura de cinco codosde lino fino torcido, y sus basas de latón. ");
INSERT INTO spav1602p_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Todos los vasos del taberná­culo en todo su servicio, y todos sus clavos, y todos los clavos del patio, serán de latón. ");
INSERT INTO spav1602p_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Y tú mandarás a los hijos de Israel que te traigan aceite puro de olivas, molido, para la lumi­naria, para hacer arder continua­mente las lámparas. ");
INSERT INTO spav1602p_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","En el tabernáculo de la congregación afuera del velo, que está delante del testimonio, Aarón y sus hijos las pondrán en orden desde la tarde hasta la mañana delante del SEÑOR: esto será estatuto perpetuo a sus generaciones a beneficio de los hijos de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Y TÚ allega a ti a Aarón tu hermano, y a sus hijos consigo, de entre los hijos de Israel, para que ministren a mí en el oficio de sacerdote; aún a Aarón, Nadab y Abiú, Eleazar e Itamar, hijos de Aarón. ");
INSERT INTO spav1602p_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Y harás vestiduras sagradas a Aarón tu hermano, para gloria y hermosura. ");
INSERT INTO spav1602p_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Y tú hablarás a todos los sabios de corazón, a quienes yo he henchido de espíritu de sabiduría, a fin que hagan las vestiduras de Aarón, para consagrarle a que me ministre en el oficio de sacerdote. ");
INSERT INTO spav1602p_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Las vestiduras que harán son éstas: una coraza, y un efod, y un manto, y una túnica labrada, una mitra, y un cinturón. Hagan, pues, las vestiduras sagradas a Aarón tu hermano, y a sus hijos, para que me ministren en el oficio de sacerdote. ");
INSERT INTO spav1602p_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Y tomarán oro, y azul, y púr­pura, y escarlata, y lino fino. ");
INSERT INTO spav1602p_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Y harán el efod de oro, de azul, y de púrpura, de escarlata, y lino fino torcido de obra ingeniosa. ");
INSERT INTO spav1602p_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Tendrá dos hombreras que se junten a sus dos lados, y así se juntará. ");
INSERT INTO spav1602p_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Y el artificio del cinto del efod que está sobre él, será de su misma obra, de lo mismo; aún de oro, de azul, y púrpura, y escarlata, y lino fino torcido. ");
INSERT INTO spav1602p_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Y tomarás dos piedras de ónix, y grabarás en ellas los nom­bres de los hijos de Israel: ");
INSERT INTO spav1602p_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Los seis de sus nombres en una piedra, y los otros seis nom­bres en la otra piedra, conforme al nacimiento de ellos. ");
INSERT INTO spav1602p_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","De obra de escultor en piedra a modo de grabaduras de sello, harás grabar aquellas dos piedras con los nombres de los hijos de Israel; harásles alrededor engas­tes de oro. ");
INSERT INTO spav1602p_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Y pondrás aquellas dos pie­dras sobre los hombros del efod, para piedras de memoria a los hijos de Israel; y Aarón lle­vará los nombres de ellos delan­te del SEÑOR en sus dos hom­bros por memoria. ");
INSERT INTO spav1602p_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Y harás engastes de oro, ");
INSERT INTO spav1602p_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","Y dos cadenas de oro puro; las cuales harás de hechura de trenza; y fijarás las cadenas de hechura de trenza en los engas­tes. ");
INSERT INTO spav1602p_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Y harás la coraza del juicio de obra ingeniosa, lo harás conforme a la obra del efod, de oro, de azul, y de púrpura, y de escarlata, y de lino fino torcido. ");
INSERT INTO spav1602p_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Será cuadrado y doble, de un palmo de largo y un palmo de ancho: ");
INSERT INTO spav1602p_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Y lo llenarás de pedrería con cuatro hileras de piedras: la primera hilera de un sardio, un topacio, y un carbunclo; ésta será la primera hilera. ");
INSERT INTO spav1602p_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Y la segunda hilera será una esme­ralda, un zafiro, y un diamante; ");
INSERT INTO spav1602p_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Y la tercera hilera, un rubí, un ágata, y una amatista; ");
INSERT INTO spav1602p_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Y la cuarta hilera, un berilo, un ónix, y un jaspe: estarán engastadas en oro en sus encajes. ");
INSERT INTO spav1602p_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Y serán aquellas piedras según los nombres de los hijos de Israel, doce según sus nom­bres; como grabaduras de sello cada una con su nombre, ven­drán a ser según las doce tribus. ");
INSERT INTO spav1602p_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Y harás en la coraza cadenas de hechura de trenzas de oro puro. ");
INSERT INTO spav1602p_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Y harás en la coraza dos ani­llos de oro, los cuales dos anillos pondrás a las dos puntas de la coraza. ");
INSERT INTO spav1602p_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Y pondrás las dos trenzas de cadenas de oro en los dos anillos a las dos puntas de la coraza: ");
INSERT INTO spav1602p_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Y los otros dos cabos de las dos cadenas trenzadas sobre los dos engastes, y las pondrás a los lados del efod en la parte delantera. ");
INSERT INTO spav1602p_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Harás también dos anillos de oro, los cuales pondrás a las dos puntas de la coraza, en su orilla que está al lado del efod de la parte de dentro. ");
INSERT INTO spav1602p_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Y harás otros dos anillos de oro, los cuales pondrás a los dos lados del efod abajo en la parte delantera, delante de su otra juntura sobre el cinto del efod. ");
INSERT INTO spav1602p_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Y juntarán la coraza con sus anillos a los anillos del efod con un cordón de azul, para que esté sobre el cinto del efod, y no se aparte la coraza del efod. ");
INSERT INTO spav1602p_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Y llevará Aarón los nombres de los hijos de Israel en la coraza del juicio sobre su corazón, cuando entrare en el lugar santo, para memoria delante del SEÑOR continuamente. ");
INSERT INTO spav1602p_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Y pondrás en la coraza del juicio el Urim y el Tumim, para que estén sobre el corazón de Aarón cuando entrare delante del SEÑOR: y llevará siempre Aarón el juicio de los hijos de Israel sobre su corazón delante del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Y harás el manto del efod todo de azul: ");
INSERT INTO spav1602p_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Y en medio de él por arriba habrá una abertura, la cual tendrá un borde alrededor de obra de tejedor, como el cuello de un coselete, para que no se rompa. ");
INSERT INTO spav1602p_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Y abajo en sus orillas harás granadas de azul, y de púrpura, y de escarlata, por sus bordes alrede­dor; y entre ellas campanillas de oro alrededor: ");
INSERT INTO spav1602p_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Una campanilla de oro y una granada, campanilla de oro y granada, por las orillas del manto alrededor. ");
INSERT INTO spav1602p_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Y estará sobre Aarón cuando ministrare; y oiráse su sonido cuando él entrare en el lugar santo delante del SEÑOR, y cuando saliere, porque no muera. ");
INSERT INTO spav1602p_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Y harás una plancha de oro puro, y grabarás en ella grabadura de sello, SANTIDAD AL SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Y la pondrás con un cordón de azul, y estará sobre la mitra; por el frente anterior de la mitra estará. ");
INSERT INTO spav1602p_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Y estará sobre la frente de Aarón: para que lleve Aarón la iniquidad de las cosas santas, que los hijos de Israel hubieren consagrado en todas sus santas ofrendas; y sobre su frente estará continuamente para que sean aceptados delante del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Y bordarás una túnica de lino fino, y harás una mitra de lino fino; harás también un cinto de obra de reca­mador. ");
INSERT INTO spav1602p_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Y para los hijos de Aarón harás túnicas; también les harás cintos, y les formarás tiaras para honra y hermosura. ");
INSERT INTO spav1602p_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Y con ellos vestirás a Aarón tu hermano, y a sus hijos con él: y los ungirás, y los consagrarás, y los santificarás, para que me ministren en el oficio de sacerdote. ");
INSERT INTO spav1602p_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Y les harás pañetes de lino para cubrir la carne vergonzosa; serán desde los lomos hasta los muslos: ");
INSERT INTO spav1602p_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Y estarán sobre Aarón y sobre sus hijos cuando entraren en el tabernáculo de la congregación, o cuando se llegaren al altar para servir en el lugar santo, para que no lleven iniquidad, y mueran. Estatuto perpetuo será para él, y para su simiente después de él. ");
INSERT INTO spav1602p_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Y ESTO es lo que les harás para consagrarlos, para que me ministren en el oficio de sacerdote: Toma un becerro de la vacada, y dos carneros sin tacha; ");
INSERT INTO spav1602p_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Y pan sin levadura, y tortas sin levadura amasadas con acei­te, y hojaldres sin levadura unta­das con aceite; de flor de harina de trigo las harás: ");
INSERT INTO spav1602p_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Y las pondrás en un canastillo, y en el canastillo las traerás, con el becerro y los dos carneros. ");
INSERT INTO spav1602p_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Y harás llegar a Aarón y a sus hijos a la puerta del tabernáculo de la congregación, y los lava­rás con agua. ");
INSERT INTO spav1602p_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Y tomarás las vestiduras, y ves­tirás a Aarón la túnica y el manto del efod, y el efod, y la coraza, y le ceñirás con el cinto del efod; ");
INSERT INTO spav1602p_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Y pondrás la mitra sobre su cabeza, y sobre la mitra pondrás la corona santa. ");
INSERT INTO spav1602p_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Y tomarás el aceite de la unción, y derramarás sobre su cabeza, y le ungirás. ");
INSERT INTO spav1602p_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Y harás llegar sus hijos, y les vestirás las túnicas. ");
INSERT INTO spav1602p_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Y les ceñirás el cinto, a Aarón y a sus hijos, y les atarás las tiaras, y tendrán el sacer­docio por estatuto perpetuo: y hen­chirás las manos de Aarón y de sus hijos. ");
INSERT INTO spav1602p_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Y harás llegar el becerro delante del tabernáculo de la con­gregación, y Aarón y sus hijos pondrán sus manos sobre la cabeza del becerro. ");
INSERT INTO spav1602p_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Y matarás el becerro delante del SEÑOR a la puerta del ta­bernáculo de la congregación. ");
INSERT INTO spav1602p_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Y tomarás de la sangre del becerro, y la pondrás sobre los cuernos del altar con tu dedo, y derramarás toda la demás sangre al pie del altar. ");
INSERT INTO spav1602p_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Tomarás también todo el sebo que cubre los intestinos, y el redaño que está sobre el hígado, y los dos riñones, y el sebo que está sobre ellos, y los quemarás sobre el altar. ");
INSERT INTO spav1602p_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Pero consumirás a fuego fuera del campo la carne del becerro, y su pellejo, y su estiér­col: es una expiación por el pecado. ");
INSERT INTO spav1602p_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Asimismo tomarás el un car­nero, y Aarón y sus hijos pon­drán sus manos sobre la cabeza del carnero. ");
INSERT INTO spav1602p_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Y matarás el carnero, y toma­rás su sangre, y la rociarás sobre el altar alrededor. ");
INSERT INTO spav1602p_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Y cortarás el carnero en peda­zos, y lavarás sus intestinos y sus piernas, y las pondrás sobre sus trozos y sobre su cabeza. ");
INSERT INTO spav1602p_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Y quemarás todo el carnero sobre el altar: es una ofrenda quemada al SEÑOR, es un olor grato, una ofren­da hecha por fuego al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Tomarás luego el otro carne­ro, y Aarón y sus hijos pondrán sus manos sobre la cabeza del carnero: ");
INSERT INTO spav1602p_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Y matarás el carnero, y tomarás de su sangre, y la pondrás sobre la ternilla de la oreja derecha de Aarón, y sobre la ternilla de las orejas de sus hijos, y sobre el dedo pulgar de las manos dere­chas de ellos, y sobre el dedo pulgar de los pies derechos de ellos, y rociarás la sangre sobre el altar alrededor. ");
INSERT INTO spav1602p_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Y tomarás de la sangre que hay sobre el altar, y del aceite de la unción, y lo rociarás sobre Aarón, y sobre sus vestiduras, y sobre sus hijos, y sobre las vesti­mentas de éstos; y él será santifi­cado, y sus vestiduras, y sus hijos, y las vestimentas de sus hijos con él. ");
INSERT INTO spav1602p_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Luego tomarás del carnero el sebo, y la cola, y el sebo que cubre los intestinos, y el redaño sobre el hígado, y los dos riñones, y el sebo que está sobre ellos, y la espaldilla derecha; porque es car­nero de consagraciones: ");
INSERT INTO spav1602p_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Y una barra de pan, y una torta de pan de aceite, y una hojaldre del canastillo de panes sin levadura que está delante del SEÑOR; ");
INSERT INTO spav1602p_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Y pondrás todo en las manos de Aarón, y en las manos de sus hijos, y lo mecerás por ofrenda mecida delante del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Después lo tomarás de sus manos, y lo harás arder sobre el altar en una ofrenda quemada, por olor agradable delante del SEÑOR: es una ofrenda hecha por fuego al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Y tomarás el pecho del carne­ro de las consagraciones, que fue inmolado para la de Aarón, y lo mecerás por ofrenda mecida delante del SEÑOR; y será por­ción tuya. ");
INSERT INTO spav1602p_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Y santificarás el pecho de la ofrenda mecida, y la espaldilla de la ofrenda elevada, que fue mecida y que fue elevada del carnero de la consagración, de lo que es de Aarón y de lo que es de sus hijos: ");
INSERT INTO spav1602p_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Y será para Aarón y para sus hijos por estatuto perpetuo de los hijos de Israel, porque es porción elevada; y será tomada de los hijos de Israel de sus sacrificios pacíficos, porción de ellos eleva­da en ofrenda al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Y las vestimentas santas, que son de Aarón, serán de sus hijos después de él, para ser ungidos con ellas, y para ser con ellas consagrados. ");
INSERT INTO spav1602p_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Y aquel hijo que es el sacerdote en su lugar las vestirá por siete días, cuando él viniere al tabernáculo de la congregación a servir en el lugar santo. ");
INSERT INTO spav1602p_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Y tomarás el carnero de las consagraciones, y cocerás su carne en el lugar santo. ");
INSERT INTO spav1602p_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Y Aarón y sus hijos comerán la carne del carnero, y el pan que está en el canastillo, a la puerta del tabernáculo de la congregación. ");
INSERT INTO spav1602p_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Y comerán aquellas cosas con las cuales fue hecha la expiación, para consagrarlas y para santificarlas; pero el extranjero no las comerá, porque son santas. ");
INSERT INTO spav1602p_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Y si sobrare algo de la carne de las consagraciones y del pan hasta la mañana, quemarás al fuego lo que hubiere sobrado: no se comerá, porque es santo. ");
INSERT INTO spav1602p_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Así pues harás a Aarón y a sus hijos, conforme a todas las cosas que yo te he mandado: por siete días los consagrarás. ");
INSERT INTO spav1602p_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Y sacrificarás el becerro de la expiación en cada día por una ofrenda de expiación de los pecados; y purificarás el altar en habiendo hecho expiación por él, y lo ungirás para santificarlo. ");
INSERT INTO spav1602p_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Por siete días expiarás el altar, y lo santificarás, y será un altar santísimo: cualquiera cosa que tocare al altar, será santificada. ");
INSERT INTO spav1602p_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Ahora estoes lo que ofrecerás sobre el altar: dos corderos de un año cada día, continuamente. ");
INSERT INTO spav1602p_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Ofrecerás el un cordero a la mañana, y el otro cordero ofrece­rás a la caída de la tarde: ");
INSERT INTO spav1602p_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Además una décima parte de un efa de flor de harina amasa­da con la cuarta parte de un hin de aceite molido: y la libación será la cuarta parte de un hin de vino con cada cordero. ");
INSERT INTO spav1602p_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Y ofrecerás el otro cordero a la caída de la tarde, haciendo conforme a la ofrenda de la mañana, y conforme a su liba­ción, en olor de suavidad; será una ofrenda hecha por fuego al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Esto será una ofrenda quemada continua por vuestras generaciones a la puerta del tabernáculo de la con­gregación delante del SEÑOR, en el cual me concertaré con vo­sotros, para hablaros allí. ");
INSERT INTO spav1602p_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Y allí testificaré de mí a los hijos de Israel, y el tabernáculo será santificado por mi gloria. ");
INSERT INTO spav1602p_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Y santificaré el tabernáculo de la congregación y el altar: santi­ficaré asimismo a Aarón y a sus hijos, para que me ministren en el oficio de sacerdote. ");
INSERT INTO spav1602p_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Y yo habitaré entre los hijos de Israel, y seré su Dios. ");
INSERT INTO spav1602p_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Y conocerán que yo soy el SEÑOR su Dios, que los saqué de la tierra de Egipto, para habi­tar en medio de ellos: Yo soy el SEÑOR su Dios. ");
INSERT INTO spav1602p_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Y HARÁS asimismo un altar para quemar el incienso de perfume: de madera de acacia lo harás. ");
INSERT INTO spav1602p_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Su longitud será de un codo, y su anchura de un codo: será cua­drado: y su altura de dos codos: y sus cuernos serán de lo mismo. ");
INSERT INTO spav1602p_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Y cubrirlo has de oro puro, su techado, y sus paredes en derre­dor, y sus cuernos: y le harás en derredor una corona de oro. ");
INSERT INTO spav1602p_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Le harás también dos anillos de oro debajo de su corona a sus dos esquinas en ambos lados suyos lo harás, para meter las varas con que será llevado. ");
INSERT INTO spav1602p_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Y harás las varas de madera de acacia, y los cubrirás de oro. ");
INSERT INTO spav1602p_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Y lo pondrás delante del velo que está junto al arca del testi­monio, delante del propiciatorio que está sobre el testimonio, donde yo te testificaré de mí. ");
INSERT INTO spav1602p_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Y quemará sobre él Aarón incienso aromático cada mañana: cuando aderezare las lámparas lo quemará. ");
INSERT INTO spav1602p_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Y cuando Aarón encendiere las lámparas al anochecer, quemará el incienso sobre él; incienso perpetuo delante del SEÑOR por vuestras generaciones. ");
INSERT INTO spav1602p_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","No ofreceréis sobre él incienso extraño, ni sacrificio quemado, ni ofrenda; ni tampoco derramaréis sobre él libación. ");
INSERT INTO spav1602p_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Y sobre sus cuernos hará Aarón expiación una vez en el año con la sangre de la expiación para las reconciliaciones: una vez en el año hará expiación sobre él en vuestras generaciones: es muy santo al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Y habló el SEÑOR a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","Cuando tomares el número de los hijos de Israel conforme a la cuenta de ellos, cada uno dará al SEÑOR el rescate de su alma, cuando los contares, para que no haya en ellos plaga, cuando los contares. ");
INSERT INTO spav1602p_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Esto dará cualquiera que pasare por la cuenta, medio siclo conforme al siclo del santuario; (el siclo es de veinte óbolos:) la mitad de un siclo será la ofrenda al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Cualquiera que pasare por la cuenta, de veinte años arriba, dará la ofrenda al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Ni el rico aumentará, ni el pobre disminuirá de medio siclo, cuando dieren la ofrenda al SEÑOR para hacer expiación por vuestras almas. ");
INSERT INTO spav1602p_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Y tomarás de los hijos de Israel el dinero de las expiacio­nes, y lo darás para el servicio del tabernáculo de la congregación: y será por memoria a los hijos de Israel delante del SEÑOR, para expiar vuestras almas. ");
INSERT INTO spav1602p_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Y habló el SEÑOR a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","Harás también una fuente de latón, con su basa también de latón, para lavar; y la has de poner entre el tabernáculo de la congrega­ción y el altar; y pondrás en ella agua. ");
INSERT INTO spav1602p_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Y de ella se lavarán Aarón y sus hijos las manos y los pies: ");
INSERT INTO spav1602p_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Cuando entraren en el taber­náculo de la congregación, se han de lavar con agua, y no mori­rán: y cuando se llegaren al altar para ministrar, para encender al SEÑOR la ofrenda que se ha de consumir al fuego, ");
INSERT INTO spav1602p_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","También se lavarán las manos y los pies, y no morirán. Y lo ten­drán por estatuto perpetuo él y su simiente por sus generaciones. ");
INSERT INTO spav1602p_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Habló más el SEÑOR a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","Y tomarás de las prin­cipales especias; de mirra excelen­te quinientos siclos, y de canela aromática la mitad, aún dos­cientos y cincuenta siclos, y de cálamo aromático doscientos y cincuenta siclos, ");
INSERT INTO spav1602p_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","Y de casia quinientos siclos, al peso del santuario, y de aceite de oli­vas un hin: ");
INSERT INTO spav1602p_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Y harás de ello el aceite de la santa unción, superior ungüento, obra de perfumador, el cual será el aceite de la unción sagrada. ");
INSERT INTO spav1602p_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Con él ungirás el tabernáculo de la congregación, y el arca del testimonio, ");
INSERT INTO spav1602p_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","Y la mesa, y todos sus vasos, y el candelero, y todos sus vasos, y el altar del incienso, ");
INSERT INTO spav1602p_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","Y el altar de la ofrenda quemada, todos sus vasos, y la fuente y su basa. ");
INSERT INTO spav1602p_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Así los consagrarás, y serán cosas santísimas: todo lo que tocare en ellos, será santificado. ");
INSERT INTO spav1602p_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Ungirás también a Aarón y a sus hijos, y los consagrarás, para que me ministren en el oficio del sacerdote. ");
INSERT INTO spav1602p_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Y hablarás a los hijos de Israel, diciendo: Éste será mi aceite de la santa unción por vuestras generaciones. ");
INSERT INTO spav1602p_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Sobre carne de hombre no será untado, ni haréis otro seme­jante, conforme a su composi­ción: santo es; y será santo para vosotros. ");
INSERT INTO spav1602p_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Cualquiera que compusiere ungüento semejante, y que pusiere algo de él sobre extraño, será cortado de sus pueblos. ");
INSERT INTO spav1602p_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Dijo además el SEÑOR a Moisés: Tómate especias aromáticas, estacte y uña aromática y gálbano: estas especias con incienso puro: cada uno de estos será de igual peso: ");
INSERT INTO spav1602p_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Y harás de ellos un perfume, una confección según la obra del perfumador, mezclada, pura y santa: ");
INSERT INTO spav1602p_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Y molerás alguna de ella pulverizándola, y la pondrás delante del testimonio en el tabernáculo de la congregación, donde yo me encontraré contigo. Os será cosa santísima. ");
INSERT INTO spav1602p_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Y como el perfume que harás, no os haréis otra según su composición: te será cosa sagra­da para el SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Cualquiera que hiciere otra como ella para olerla, será corta­do de sus pueblos. ");
INSERT INTO spav1602p_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Y HABLÓ el SEÑOR a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","Mira, yo he llamado por su nombre a Bezaleel, hijo de Uri, hijo de Hur, de la tribu de Judá; ");
INSERT INTO spav1602p_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Y lo he henchido del Espíritu de Dios, en sabiduría, y en enten­dimiento, y en conocimiento, y en todo artificio, ");
INSERT INTO spav1602p_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Para idear obras ingeniosas, para tra­bajar en oro, y en plata, y en latón, ");
INSERT INTO spav1602p_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Y en artificio de piedras para engastarlas, y en artificio de madera; para obrar en toda suer­te de labor. ");
INSERT INTO spav1602p_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Y, he aquí, que yo he puesto con él a Aholiab, hijo de Ahisamac, de la tribu de Dan: y he puesto sabiduría en el corazón de todo sabio de corazón, para que hagan todo lo que te he mandado: ");
INSERT INTO spav1602p_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","El tabernáculo de la congrega­ción, y el arca del testimonio, y el propiciatorio que está sobre ella, y todos los muebles del tabernáculo; ");
INSERT INTO spav1602p_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","Y la mesa y sus utensilios, y el can­delero limpio y todos sus utensilios, y el altar del perfume; ");
INSERT INTO spav1602p_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","Y el altar de la ofrenda quemada y todos sus vasos, y la fuente y su basa; ");
INSERT INTO spav1602p_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","Y las vestiduras del servicio, y las santas vestiduras para Aarón el sacerdote, y las vestiduras de sus hijos, para ministrar en el oficio del sacerdocio; ");
INSERT INTO spav1602p_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","Y el aceite de la unción, y el incienso aromático para el lugar santo: harán conforme a todo lo que te he mandado. ");
INSERT INTO spav1602p_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Y habló el SEÑOR a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Y tú hablarás a los hijos de Israel, diciendo: Con todo eso vosotros guardaréis mis sábados: porque es señal entre mí y voso­tros por vuestras generaciones, para que sepáis que yo soy el SEÑOR que os santifico. ");
INSERT INTO spav1602p_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Así que guardaréis el sábado, porque santo es a vosotros: el que lo profanare, de cierto mori­rá; porque cualquiera que hiciere obra alguna en él, aquella alma será cortada de en medio de sus pueblos. ");
INSERT INTO spav1602p_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Seis días se hará obra, mas el día séptimo es sábado de reposo consagrado al SEÑOR; cual­quiera que hiciere obra el día del sábado, morirá ciertamente. ");
INSERT INTO spav1602p_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Por lo tanto, guardarán el sábado los hijos de Israel: para observar el sábado por sus generaciones por pacto perpetuo: ");
INSERT INTO spav1602p_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Señal es para siempre entre mí y los hijos de Israel; porque en seis días hizo el SEÑOR el cielo y la tierra, y en el séptimo día cesó, y reposó. ");
INSERT INTO spav1602p_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Y dio a Moisés, cuando acabó de hablar con él en el monte de Sinaí, dos tablas del testimonio, tablas de piedra escritas con el dedo de Dios. ");
INSERT INTO spav1602p_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Y cuando el pueblo vio que Moisés tardaba en descender del monte, allegóse entonces a Aarón, y dijéronle: Levántate, haznos dioses que vayan delante de nosotros; porque a este Moisés, aquel varón que nos sacó de la tierra de Egipto, no sabemos qué le haya acontecido. ");
INSERT INTO spav1602p_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Y Aarón les dijo: Apartad los zarcillos de oro que están en las orejas de vuestras esposas, y de vuestros hijos, y de vuestras hijas, y traédmelos. ");
INSERT INTO spav1602p_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Y todo el pueblo apartó los zarcillos de oro que tenían en sus orejas, y trajéronlos a Aarón: ");
INSERT INTO spav1602p_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","El cual los tomó de las manos de ellos, y formólo con buril, e hizo de ello un becerro de fundi­ción. Y ellos dijeron: Israel, estos son tus dioses, que te saca­ron de la tierra de Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Y viendo esto Aarón, edificó un altar delante de aquel; y pregonó Aarón, y dijo: Mañana será fiesta al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Y el día siguiente madrugaron, y ofrecieron holocaustos, y pre­sentaron pacíficos: y sentóse el pueblo a comer y a beber, y levantáronse a jugar. ");
INSERT INTO spav1602p_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Y el SEÑOR dijo a Moisés: Anda, desciende, porque tu pueblo que sacaste de tierra de Egipto se ha corrompido: ");
INSERT INTO spav1602p_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Presto se han apartado del camino que yo les mandé, y se han hecho un becerro de fundi­ción, y lo han adorado, y han sacrificado a él, y han dicho: Israel, estos son tus dioses, que te sacaron de la tierra de Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Y dijo el SEÑOR a Moisés: Yo he visto a este pueblo, y he aquí, es un pueblo de dura cerviz: ");
INSERT INTO spav1602p_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Ahora pues, déjame sólo, para que mi furor se encienda contra ellos, y para que los consuma: y yo haré de ti una gran nación. ");
INSERT INTO spav1602p_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Y Moisés oró al SEÑOR su Dios, y dijo: SEÑOR, ¿por qué se encenderá tu furor contra tu pueblo, que tú sacaste de la tierra de Egipto con gran poder, y con mano fuer­te? ");
INSERT INTO spav1602p_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","¿Por qué han de hablar los egipcios, diciendo: Para mal los sacó, para matarlos en los mon­tes, y para raerlos de sobre la faz de la tierra? Vuélvete del furor de tu ira, y arrepiéntete de este mal contra tu pueblo. ");
INSERT INTO spav1602p_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Acuérdate de Abraham, de Isaac, y de Israel, tus siervos, a los cuales has jurado por ti mismo, y dícholes: Yo multipli­caré vuestra simiente como las estrellas del cielo; y daré a vues­tra simiente toda esta tierra que he dicho, y la tomarán por heredad para siempre. ");
INSERT INTO spav1602p_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Entonces el SEÑOR se arre­pintió del mal que pensó que había de hacer a su pueblo. ");
INSERT INTO spav1602p_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Y volvióse Moisés, y descendió del monte y las dos tablas del testimonio estaban en su mano: las tablas estaban escritas por ambos lados; de una parte y de otra estaban escritas. ");
INSERT INTO spav1602p_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Y las tablas eran obra de Dios, y la escritura era escritura de Dios grabada sobre las tablas. ");
INSERT INTO spav1602p_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Y oyendo Josué el clamor del pueblo que gritaba, dijo a Moisés: Alarido de pelea hay en el campamento. ");
INSERT INTO spav1602p_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Y él dijo: No es la voz de alarido de vencedores, ni la voz de alarido de vencidos: sino alarido de cantar oigo yo. ");
INSERT INTO spav1602p_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Y aconteció, que como llegó él cerca al campamento, y vio el becerro y las danzas, enardeciósele la ira a Moisés, y arrojó las tablas de sus manos, y quebrólas al pie del monte. ");
INSERT INTO spav1602p_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Y tomó el becerro que habían hecho, y quemólo en el fuego, y moliólo hasta reducirlo a polvo, que esparció sobre las aguas, y diólo a beber a los hijos de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Y dijo Moisés a Aarón: ¿Qué te ha hecho este pueblo, que has traído sobre él tan gran pecado? ");
INSERT INTO spav1602p_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Y respondió Aarón: No se enoje mi señor; tú conoces el pueblo, que es inclinado a mal. ");
INSERT INTO spav1602p_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Porque me dijeron: Haznos dioses, los cuales irán delante de nosotros, porque este Moisés, el varón que nos sacó de tierra de Egipto, no sabemos qué le ha acontecido. ");
INSERT INTO spav1602p_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Y yo les respondí: ¿Quién tiene oro? Apartadlo. Y diéron­melo, y echélo en el fuego, y salió este becerro. ");
INSERT INTO spav1602p_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Y viendo Moisés que el pue­blo estaba desnudo, (porque Aarón lo había despojado para vergüenza entre sus enemigos,) ");
INSERT INTO spav1602p_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Púsose entonces Moisés de pie a la puerta del campamento, y dijo: ¿Quién está en el lado del SEÑOR? júntese conmigo. Y juntáronse con él todos los hijos de Leví. ");
INSERT INTO spav1602p_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Y él les dijo: Así dice el SEÑOR Dios de Israel: Poned cada uno su espada sobre su muslo: pasad y volved de puerta a puerta por el campo, y matad cada uno a su hermano, y a su amigo, y a su vecino. ");
INSERT INTO spav1602p_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Y los hijos de Leví lo hicieron conforme a la palabra de Moisés: y cayeron del pueblo en aquel día como tres mil hombres. ");
INSERT INTO spav1602p_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Entonces Moisés dijo: Hoy os habéis consagrado al SEÑOR, porque cada uno se ha consagra­do en su hijo, y en su hermano, para que él dé hoy bendición sobre vosotros. ");
INSERT INTO spav1602p_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Y aconteció que el día siguiente dijo Moisés al pueblo: Vosotros habéis cometido un gran pecado: mas yo subiré ahora al SEÑOR; quizá haré una expiación para vuestro pecado. ");
INSERT INTO spav1602p_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Y volvió Moisés al SEÑOR, y dijo: Oh, este pueblo ha cometido un gran pecado porque se hicieron dioses de oro. ");
INSERT INTO spav1602p_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Ahora pues, si perdonares su pecado, y si no, ráeme, te ruego, de tu libro que has escrito. ");
INSERT INTO spav1602p_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Y el SEÑOR respondió a Moisés: Al que pecare contra mí, a éste raeré yo de mi libro. ");
INSERT INTO spav1602p_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Ve pues ahora, lleva a este pueblo allugar del que te he dicho: he aquí mi Ángel irá delante de ti; que en el día de mi visitación yo visitaré en ellos su pecado. ");
INSERT INTO spav1602p_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Y el SEÑOR castigó al pueblo, porque habían hecho el becerro que formó Aarón. ");
INSERT INTO spav1602p_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Y EL SEÑOR dijo a Moisés: Ve, y sube de aquí, tú y el pueblo que sacaste de la tierra de Egipto, a la tierra de la cual juré a Abraham, Isaac, y Jacob, diciendo: A tu simiente la daré: ");
INSERT INTO spav1602p_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Y yo enviaré delante de ti un ángel, y echaré fuera al cananeo y al amorreo, y al heteo, y al ferezeo, y al heveo y al jebuseo: ");
INSERT INTO spav1602p_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","A la tierra que fluye leche y miel; porque yo no subiré en medio de ti, porque eres pueblo de dura cerviz, para que no te con­suma en el camino. ");
INSERT INTO spav1602p_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Y cuando el pueblo oyó estas noticias malas, vistieron luto, y nin­guno se puso sus atavíos: ");
INSERT INTO spav1602p_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Pues el SEÑOR dijo a Moisés: Di a los hijos de Israel: Vosotros sois pueblo de dura cerviz: en un momento subiré en medio de ti, y te consumiré: quítate pues ahora tus atavíos, para que yo sepa lo que te he de hacer. ");
INSERT INTO spav1602p_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Y los hijos de Israel se despojaron de sus atavíos desde el monte Horeb. ");
INSERT INTO spav1602p_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Y Moisés tomó el tabernáculo, y extendiólo fuera del campo, lejos del campo, y llamólo el tabernáculo de la congregación. Y sucedió, que cualquiera que buscaba al SEÑOR, salía al tabernácu­lo de la congregación, que estaba fuera del campo. ");
INSERT INTO spav1602p_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Y acontecía, cuando salía Moisés al tabernáculo, que todo el pueblo se levantaba, y estaba cada cual en pie a la puerta de su tienda, y miraban en pos de Moisés, hasta que él entraba en el tabernáculo. ");
INSERT INTO spav1602p_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Y aconteció que, como entró Moisés en el tabernáculo, la columna de nube descendía, y poníase de pie a la puerta del tabernáculo, y el SEÑOR hablaba con Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Y viendo todo el pueblo la columna de la nube, que estaba a la puerta del tabernáculo, todo el pueblo se levantaba y adoraba, cada uno a la puerta de su tienda. ");
INSERT INTO spav1602p_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Y hablaba el SEÑOR a Moisés cara a cara, como habla cualquiera a su compañero. Y volvíase al campo; mas el joven Josué, su siervo, hijo de Nun, nunca se apartaba de en medio del tabernáculo. ");
INSERT INTO spav1602p_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Y dijo Moisés al SEÑOR: Mira, tú me dices a mí: Saca este pueblo: y tú no me has declarado a quién has de enviar conmigo: sin embargo, tú dices: Yo te conozco por tu nombre, y has hallado también gracia en mis ojos. ");
INSERT INTO spav1602p_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Ahora, pues, te ruego, si he hallado gracia en tus ojos, muéstrame ahora tu camino, para que yo te conozca, para que halle gracia en tus ojos: y consideres que esta nación es tu pueblo. ");
INSERT INTO spav1602p_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Y él dijo: Mi presencia irá conti­go, y te haré descansar. ");
INSERT INTO spav1602p_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Y él le respondió: Si tu presencia no ha de ir conmigo, no nos saques de aquí. ");
INSERT INTO spav1602p_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","¿Y en qué se conocerá aquí que he hallado gracia en tus ojos? ¿No es que irás tú con nosotros? Así estaremos separados, yo y tu pueblo, de todos los pueblos que están sobre la faz de la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Y el SEÑOR dijo a Moisés: También haré esto que has dicho, por cuanto has hallado gracia en mis ojos, y te conozco por tu nombre. ");
INSERT INTO spav1602p_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Y él dijo: Ruégote que me muestres tu gloria. ");
INSERT INTO spav1602p_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Y él dijo: Yo haré pasar toda mi bondad delante de ti, y proclamaré el nombre del SEÑOR delante de ti; y seré clemente para con el que seré clemente, y tendré misericordia del que tendré misericordia. ");
INSERT INTO spav1602p_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Y él dijo: No podrás ver mi rostro: porque no me verá hombre, y vivirá. ");
INSERT INTO spav1602p_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Y el SEÑOR dijo: He aquí hay un lugar junto a mí, y tú estarás sobre la roca: ");
INSERT INTO spav1602p_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Y acontecerá que, cuando pasare mi gloria, yo te pondré en una hendidura de la roca, y te cubriré con mi mano mientras yo pase: ");
INSERT INTO spav1602p_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Y apartaré mi mano, y verás mis espaldas; mas no se verá mi rostro. ");
INSERT INTO spav1602p_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Y EL SEÑOR dijo a Moisés: Alísate dos tablas de piedra como las primeras, y escribiré sobre estas tablas las palabras que estaban en las tablas primeras, que quebraste. ");
INSERT INTO spav1602p_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Apercíbete, pues, para mañana, y sube por la mañana al monte de Sinaí, y preséntate a mí sobre la cum­bre del monte. ");
INSERT INTO spav1602p_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Y no suba hombre contigo, ni parezca alguno en todo el monte; ni ovejas ni bueyes pazcan delante del monte. ");
INSERT INTO spav1602p_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Y Moisés alisó dos tablas de piedra como las primeras; y levantóse muy de mañana, y subió al monte de Sinaí, como le mandó el SEÑOR, y llevó en su mano las dos tablas de piedra. ");
INSERT INTO spav1602p_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Y el SEÑOR descendió en la nube, y estuvo allí con él, y proclamó el nombre del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Y el SEÑOR pasó por delante de él, y proclamó: El SEÑOR, El SEÑOR Dios, misericordioso y piadoso, tardo para la ira, y abundante en bondad y verdad; ");
INSERT INTO spav1602p_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Que guarda la misericordia en millares, perdonando la iniquidad y la transgresión y el pecado, y que de ningún modo justificará al malvado; que visita la iniqui­dad de los padres sobre los hijos y sobre los hijos de los hijos, sobre la tercera, y la cuarta gene­ración. ");
INSERT INTO spav1602p_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Entonces Moisés, apresurándo­se, bajó la cabeza hacia el suelo y adoró; ");
INSERT INTO spav1602p_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Y dijo: Si ahora, oh Señor, he hallado gracia en tus ojos, te ruego, vaya ahora el Señor en medio de nosotros; porque éste es pueblo de dura cerviz; y perdona nuestra iniquidad y nuestro pecado, y tómanos por tu heredad. ");
INSERT INTO spav1602p_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Y él dijo: He aquí, yo hago pacto delante de todo tu pue­blo: haré maravillas que no han sido hechas en toda la tierra, ni en nación alguna; y verá todo el pueblo en medio del cual estás tú, la obra del SEÑOR; porque ha de ser cosa terrible la que yo haré contigo. ");
INSERT INTO spav1602p_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Guarda lo que yo te mando hoy; he aquí que yo echo de delante de tu presencia al amorreo, y al cananeo, y al heteo, y al ferezeo, y al heveo, y al jebuseo. ");
INSERT INTO spav1602p_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Guárdate que no hagas pacto con los moradores de la tierra donde has de entrar, para que no sean por tropezadero en medio de ti: ");
INSERT INTO spav1602p_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Mas derribaréis sus altares, y quebraréis sus estatuas, y talaréis sus bosques: ");
INSERT INTO spav1602p_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Porque no te has de inclinar a ningún dios ajeno; porque el SEÑOR, cuyo nombre es Celoso, es un Dios celoso. ");
INSERT INTO spav1602p_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Por tanto no harás pacto con los moradores de aquella tierra; porque fornicarán en pos de sus dioses, y sacrificarán a sus dio­ses, y te llamarán, y comerás de sus sacrificios; ");
INSERT INTO spav1602p_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","O tomando de sus hijas para tus hijos, y fornicando sus hijas en pos de sus dioses, harán tam­bién fornicar a tus hijos en pos de los dioses de ellas. ");
INSERT INTO spav1602p_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","No harás dioses de fundición para ti. ");
INSERT INTO spav1602p_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","La fiesta de los panes sin levadura guar­darás. Siete días comerás por leu­dar, según te he mandado, en el tiempo del mes de Abib; porque en el mes de Abib saliste de Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Todo lo que abre la matriz, mío es; y de tu ganado todo primerizo, de vaca o de oveja, que fuere macho. ");
INSERT INTO spav1602p_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Pero redimirás con corde­ro el primerizo del asno; y si no lo redimieres, le has de cortar la cabeza. Redimirás todo primogé­nito de tus hijos, y no serán vis­tos vacíos delante de mí. ");
INSERT INTO spav1602p_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Seis días trabajarás, mas en el séptimo día descansarás: descansarás aun en la arada y en la siega. ");
INSERT INTO spav1602p_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Y te harás la fiesta de las semanas a los principios de la siega del trigo: y la fiesta de la cosecha a la vuelta del año. ");
INSERT INTO spav1602p_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Tres veces en el año será visto todo varón tuyo delante del Señor DIOS, el Dios de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Porque yo arrojaré las naciones de tu presencia, y ensancharé tus términos: y ninguno codiciará tu tierra, cuando tú subieres para ser visto delante del SEÑOR tu Dios tres veces en el año. ");
INSERT INTO spav1602p_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","No ofrecerás con leudo la san­gre de mi sacrificio; ni quedará de la noche para la mañana el sacrificio de la fiesta de la pas­cua. ");
INSERT INTO spav1602p_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","La primicia de los primeros frutos de tu tierra traerás a la casa del SEÑOR tu Dios. No cocerás el cabrito en la leche de su madre. ");
INSERT INTO spav1602p_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Y el SEÑOR dijo a Moisés: Escribe tú estas palabras; porque conforme a estas palabras he hecho el pacto contigo y con Israel. ");
INSERT INTO spav1602p_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Y él estuvo allí con el SEÑOR cuarenta días y cuarenta noches: no comió pan, ni bebió agua; y escribió en tablas las palabras del pacto, los diez mandamientos. ");
INSERT INTO spav1602p_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Y aconteció, cuando descendía Moisés del monte Sinaí con las dos tablas del testimonio en su mano, mientras descendía del monte, no sabía él que la piel de su rostro resplandecía, después que hubo con él hablado. ");
INSERT INTO spav1602p_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Y cuando miró Aarón y todos los hijos de Israel a Moisés, he aquí la piel de su rostro era res­plandeciente; y tuvieron miedo de llegarse a él. ");
INSERT INTO spav1602p_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Y llamólos Moisés; y Aarón y todos los príncipes de la congre­gación volvieron a él, y Moisés les habló. ");
INSERT INTO spav1602p_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Y después se acercaron todos los hijos de Israel, a los cuales les dio en mandamiento todo lo que el SEÑOR le había dicho en el monte de Sinaí. ");
INSERT INTO spav1602p_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Y cuando hubo acabado Moisés de hablar con ellos, puso un velo sobre su rostro. ");
INSERT INTO spav1602p_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Pero cuando venía Moisés delan­te del SEÑOR para hablar con él, quitábase el velo hasta que salía. Y saliendo, hablaba con los hijos de Israel lo que le era mandado; ");
INSERT INTO spav1602p_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Y veían los hijos de Israel el rostro de Moisés, que la piel de su rostro era resplandeciente; y volvía Moisés a poner el velo sobre su rostro, hasta que entraba a hablar con él. ");
INSERT INTO spav1602p_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Y MOISÉS juntó toda la congregación de los hijos de Israel, y díjoles: Éstas son las palabras que el SEÑOR ha mandado que hagáis. ");
INSERT INTO spav1602p_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Seis días se hará obra, mas el día séptimo os será un día santo, sábado de reposo al SEÑOR: cualquiera que en él hiciere obra, morirá. ");
INSERT INTO spav1602p_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","No encenderéis fuego en todas vuestras moradas en el día del sábado. ");
INSERT INTO spav1602p_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Y habló Moisés a toda la con­gregación de los hijos de Israel, diciendo: Esto es lo que el SEÑOR ha mandado, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Tomad de entre vosotros ofrenda para el SEÑOR: todo aquel que sea de corazón dispuesto, traiga ofrenda al SEÑOR: oro, plata, latón; ");
INSERT INTO spav1602p_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","Y azul, y púrpura, y escarlata, y lino fino, y pelo de cabras; ");
INSERT INTO spav1602p_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","Y cueros de carneros teñidos de rojo, y cueros de tejones, y madera de acacia; ");
INSERT INTO spav1602p_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","Y aceite para la luminaria, y especias para el acei­te de la unción, y para el incienso aromático; ");
INSERT INTO spav1602p_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","Y piedras de ónix, y demás pedrería, para el efod, y para la coraza. ");
INSERT INTO spav1602p_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Y todo sabio de corazón de entre vosotros, vendrá y hará todo lo que el SEÑOR ha mandado: ");
INSERT INTO spav1602p_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","El tabernáculo, su tienda, y su cubierta, y sus anillos, y sus tablas, sus barras, sus columnas, y sus basas; ");
INSERT INTO spav1602p_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","El arca, y sus varas, el propiciatorio, y el velo de la tienda; ");
INSERT INTO spav1602p_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","La mesa, y sus varas, y todos sus vasos, y el pan de la proposi­ción. ");
INSERT INTO spav1602p_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","El candelero de la luminaria, y sus vasos, y sus lámparas, y el aceite para la luminaria; ");
INSERT INTO spav1602p_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","Y el altar del incienso, y sus varas, y el aceite de la unción, y el incienso aromático, y el pabe­llón de la puerta, para la entrada del tabernáculo; ");
INSERT INTO spav1602p_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","El altar de la ofrenda quemada, y su enrejado de latón, y sus varas, y todos sus vasos, y la fuente con su basa; ");
INSERT INTO spav1602p_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","Las cortinas del patio, sus columnas, y sus basas, y el pabe­llón de la puerta del patio; ");
INSERT INTO spav1602p_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","Las estacas del tabernáculo, y las estacas del patio, y sus cuer­das; ");
INSERT INTO spav1602p_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Las vestiduras del servicio para ministrar en el lugar santo, las sagradas vestiduras de Aarón el sacerdote, y las vestiduras de sus hijos para servir en el sacerdocio. ");
INSERT INTO spav1602p_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Y salió toda la congregación de los hijos de Israel de delante de Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Y vino todo varón a quien su corazón estimuló, y todo aquel a quien su espíritu le dio voluntad, y trajeron ofrenda al SEÑOR para la obra del tabernáculo de la congregación, y para toda su fábrica, y para las sagradas vesti­duras. ");
INSERT INTO spav1602p_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Y vinieron, ambos hombres y mujeres, todo dispuesto de corazón, y trajeron brazaletes, y zarcillos, y anillos, y lingotes, todas joyas de oro; y cualquiera ofrecía ofrenda de oro al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Y todo hombre que se hallaba con azul, o púrpura, o escarlata, o lino fino, o pelo de cabras, o cueros teñidos rojos de carneros, o cue­ros de tejones, lo traía. ");
INSERT INTO spav1602p_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Cada uno que ofrecía ofren­da de plata o de latón, traía al SEÑOR la ofrenda: y todo el que se hallaba con madera de acacia, traíala para toda la obra del servi­cio. ");
INSERT INTO spav1602p_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Y todas las mujeres sabias de corazón hilaban con sus manos, y traían lo que habían hilado: azul, y púrpura, y escarlata, y lino fino. ");
INSERT INTO spav1602p_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Y todas las mujeres cuyo corazón las levantó en sabiduría, hilaron pelos de cabras. ");
INSERT INTO spav1602p_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Y los príncipes trajeron pie­dras de ónix, y las piedras de los engastes para el efod y la coraza; ");
INSERT INTO spav1602p_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Y la especia y acei­te, para la luminaria, y para el aceite de la unción, y para el incienso aromático. ");
INSERT INTO spav1602p_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Los hijos de Israel, así hombres como mujeres, todos los que tuvieron corazón dispuesto para traer para toda la obra, que el SEÑOR había mandado por medio de Moisés que hiciesen, trajeron ofrenda voluntaria al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Y dijo Moisés a los hijos de Israel: Mirad, el SEÑOR ha nombrado a Bezaleel, hijo de Uri, hijo de Hur, de la tribu de Judá; ");
INSERT INTO spav1602p_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Y lo ha henchido del Espíritu de Dios, en sabiduría, en entendi­miento, y en conocimiento, y en todo artificio, ");
INSERT INTO spav1602p_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Para idear obras curiosas, para trabajar en oro, y en plata, y en latón, ");
INSERT INTO spav1602p_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Y en obra de pedrería para engastar, y en obra de madera, para trabajar en toda obra ingeniosa. ");
INSERT INTO spav1602p_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Y ha puesto en su corazón el que pueda enseñar, así él como Aholiab hijo de Ahisamac, de la tribu de Dan: ");
INSERT INTO spav1602p_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Los ha llenado de sabiduría de corazón, para que hagan toda obra, del grabador, y del obrero ingenioso, y del bordador, en azul, y en púrpura, y en escarlata, y en lino fino, y del tejedor; para que hagan toda labor, e inventen obra ingeniosa. ");
INSERT INTO spav1602p_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","HIZO, pues, Bezaleel y Aholiab, y todo hombre sabio de corazón, a quien el SEÑOR dio sabiduría y entendimiento para que supiesen hacer toda la obra del servicio del santuario, todas las cosas que había mandado el SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Y Moisés llamó a Bezaleel y a Aholiab, y a todo varón sabio de corazón, en cuyo corazón había dado el SEÑOR sabiduría, y a todo hombre a quien su corazón le movió a llegarse a la obra, para trabajar en ella; ");
INSERT INTO spav1602p_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Y tomaron de delante de Moisés toda la ofrenda que los hijos de Israel habían traído para la obra del servicio del santuario, a fin de hacerla. Y ellos le traían aún ofrenda voluntaria cada mañana. ");
INSERT INTO spav1602p_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Vinieron, por tanto, todos los maestros que hacían toda la obra del santuario, cada uno de la obra que hacía, ");
INSERT INTO spav1602p_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Y hablaron a Moisés, diciendo: El pueblo trae mucho más de lo que es menester para la atención de hacer la obra que el SEÑOR ha mandado que se haga. ");
INSERT INTO spav1602p_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Entonces Moisés mandó proclamar por el campo, diciendo: Ningún hombre ni mujer haga más obra para ofrecer para el santuario. Y así fue el pueblo impedido de ofrecer; ");
INSERT INTO spav1602p_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Pues tenía material abundante para hacer toda la obra, y sobra­ba. ");
INSERT INTO spav1602p_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Y todos los sabios de corazón entre los que hacían la obra, hicieron el tabernáculo de diez cortinas, de lino torcido, y de azul, y de púrpura y escarlata; las cuales hicieron de obra ingeniosa, con querubines. ");
INSERT INTO spav1602p_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","La longitud de la una cortina era de veintiocho codos, y la anchura de cuatro codos: todas las cortinas tenían una misma medida. ");
INSERT INTO spav1602p_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Y juntó las cinco cortinas la una con la otra: asimismo unió las otras cinco cortinas la una con la otra. ");
INSERT INTO spav1602p_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","E hizo las lazadas de color de azul en la orilla de la una cor­tina, en el borde, a la juntura; y así hizo en la orilla al borde de la segunda cortina, en la juntura. ");
INSERT INTO spav1602p_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Cincuenta lazadas hizo en la una cortina, y otras cincuenta en la segunda cortina, en el borde, en la juntura; las unas lazadas enfrente de las otras. ");
INSERT INTO spav1602p_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Hizo también cincuenta cor­chetes de oro, con los cuales juntó las cortinas, la una con la otra; e hízose un tabernáculo. ");
INSERT INTO spav1602p_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Hizo asimismo cortinas de pelo de cabras para la tienda sobre el tabernáculo, e hízolas en número de once. ");
INSERT INTO spav1602p_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","La longitud de la una cortina era de treinta codos, y la anchura de cuatro codos: las once corti­nas tenían una misma medida. ");
INSERT INTO spav1602p_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Y juntó las cinco cortinas de por sí, y las seis cortinas aparte. ");
INSERT INTO spav1602p_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Hizo además cincuenta laza­das en la orilla de la postrera cor­tina en la juntura, y otras cin­cuenta lazadas en la orilla de la otra cortina en la juntura. ");
INSERT INTO spav1602p_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Hizo también cincuenta cor­chetes de latón para juntar la tienda, de modo que fuese una. ");
INSERT INTO spav1602p_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","E hizo una cubierta para la tienda de cueros rojos de carne­ros, y una cubierta encima de cueros de tejones. ");
INSERT INTO spav1602p_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Además hizo las tablas para el tabernáculo de madera de acacia, para estar derechas. ");
INSERT INTO spav1602p_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","La longitud de cada tabla de diez codos, y de codo y medio la anchura. ");
INSERT INTO spav1602p_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Cada tabla tenía dos quicios enclavijados el uno delante del otro: así hizo todas las tablas del tabernáculo. ");
INSERT INTO spav1602p_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Hizo, pues, las tablas para el tabernáculo: veinte tablas al lado del sur, al austro. ");
INSERT INTO spav1602p_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Hizo también las cuarenta basas de plata debajo de las vein­te tablas: dos basas debajo de la una tabla para sus dos quicios, y dos basas debajo de la otra tabla para sus dos quicios. ");
INSERT INTO spav1602p_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Y para el otro lado del tabernáculo, a la parte del norte, hizo veinte tablas, ");
INSERT INTO spav1602p_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","Con sus cuarenta basas de plata: dos basas debajo de la una tabla, y dos basas debajo de la otra tabla. ");
INSERT INTO spav1602p_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Y para el lado occidental del tabernáculo hizo seis tablas. ");
INSERT INTO spav1602p_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Para las esquinas del taberná­culo en los dos lados hizo dos tablas, ");
INSERT INTO spav1602p_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Las cuales se juntaban por abajo, y asimismo por arriba a un anillo: y así hizo a la una y a la otra en las dos esquinas. ");
INSERT INTO spav1602p_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Eran, pues, ocho tablas, y sus basas de plata dieciséis; dos basas debajo de cada tabla. ");
INSERT INTO spav1602p_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Hizo también las barras de madera de acacia; cinco para las tablas de un lado del tabernáculo, ");
INSERT INTO spav1602p_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","Y cinco barras para las tablas del otro lado del tabernáculo, y cinco barras para las tablas del lado del tabernáculo a la parte occidental. ");
INSERT INTO spav1602p_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","E hizo que la barra del medio pasase por medio de las tablas del un cabo al otro. ");
INSERT INTO spav1602p_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Y cubrió las tablas de oro, e hizo de oro los anillos de ellas por donde pasasen las barras: cubrió también de oro las barras. ");
INSERT INTO spav1602p_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Hizo asimismo el velo de azul, y púrpura, y escarlata, y lino torcido, el cual hizo con que­rubines de obra ingeniosa. ");
INSERT INTO spav1602p_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Y para él hizo cuatro colum­nas de madera de acacia; y cubriólas de oro, los capiteles de las cuales eran de oro; e hizo para ellas cuatro basas de plata de fundición. ");
INSERT INTO spav1602p_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Hizo también el velo para la puerta del tabernáculo, de azul, y púrpura, y escarlata, y lino torcido, obra de recamador; ");
INSERT INTO spav1602p_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Y sus cinco columnas con sus capiteles: y cubrió las cabezas de ellas y sus molduras de oro: pero sus cinco basas las hizo de latón. ");
INSERT INTO spav1602p_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","E HIZO Bezaleel el arca de madera de acacia: su longitud era de dos codos y medio, y de codo y medio su anchura, y su altura de otro codo y medio: ");
INSERT INTO spav1602p_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Y cubrióla de oro puro por de dentro y por de fuera, e hízole una cornisa de oro en derredor. ");
INSERT INTO spav1602p_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Hízole además de fundición cuatro anillos de oro para ser puestos a sus cuatro esquinas; en el un lado dos ani­llos y en el otro lado dos anillos. ");
INSERT INTO spav1602p_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","E hizo las varas de madera de acacia, y cubriólas de oro. ");
INSERT INTO spav1602p_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Y metió las varas por los ani­llos a los lados del arca, para lle­var el arca. ");
INSERT INTO spav1602p_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","E hizo el propiciatorio de oro puro: su longitud era de dos codos y medio, y su anchura de codo y medio. ");
INSERT INTO spav1602p_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","E hizo los dos querubi­nes de oro, hízolos labrados a martillo, a los dos cabos del propiciatorio: ");
INSERT INTO spav1602p_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","El un querubín de esta parte al un cabo, y el otro querubín de la otra parte al otro cabo del propiciatorio: hizo los querubines a sus dos cabos. ");
INSERT INTO spav1602p_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Y los querubines extendían sus alas por encima, y cubrían con sus alas el propiciatorio: y sus rostros el uno enfrente del otro, hacia el propiciatorio los rostros de los queru­bines. ");
INSERT INTO spav1602p_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","E hizo la mesa de madera de acacia; su longitud era de dos codos, y su anchura de un codo, y de codo y medio su altu­ra; ");
INSERT INTO spav1602p_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Y cubrióla de oro puro, e hízole una cornisa de oro en derredor. ");
INSERT INTO spav1602p_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Hízole también una moldura alrededor, del ancho de una mano, a la cual moldura hizo la cornisa de oro alrededor. ");
INSERT INTO spav1602p_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Hízole asimismo de fundición cuatro anillos de oro, y púsolos a las cuatro esquinas que corres­pondían a los cuatro pies de ella. ");
INSERT INTO spav1602p_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Delante de la moldura estaban los anillos, por los cuales se metiesen las varas para llevar la mesa. ");
INSERT INTO spav1602p_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","E hizo las varas de madera de acacia para llevar la mesa, y cubriólas de oro. ");
INSERT INTO spav1602p_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","E hizo los vasos que habían de estar sobre la mesa, sus platos, y sus cucharas, y sus cubiertos y sus tazones con que se había de libar, de oro fino. ");
INSERT INTO spav1602p_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","E hizo el candelero de oro puro, e hízolo labrado a martillo: su pie y su caña, sus copas, sus manzanas y sus flores eran de lo mismo. ");
INSERT INTO spav1602p_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","De sus lados salían seis bra­zos; tres brazos de un lado del candelero, y otros tres brazos del otro lado del candelero: ");
INSERT INTO spav1602p_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","En un brazo, tres copas figura de almendras, una manzana y una flor; y en el otro brazo tres copas figura de almendras, una manzana y una flor: y así en los seis brazos que salían del cande­lero. ");
INSERT INTO spav1602p_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Y en el candelero había cuatro copas figura de almendras, sus manzanas y sus flores: ");
INSERT INTO spav1602p_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Y un botón debajo de los dos brazos de lo mismo, y otro botón debajo de los otros dos brazos de lo mismo, y otro botón debajo de los otros dos brazos de lo mismo, conforme a los seis brazos que salían de él. ");
INSERT INTO spav1602p_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Sus manzanas y sus brazos eran de lo mismo; todo era una pieza labrada a martillo, de oro puro. ");
INSERT INTO spav1602p_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","E hizo sus siete lámparas, y sus despabiladeras, y sus platillos, de oro puro; ");
INSERT INTO spav1602p_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","De un talento de oro puro lo hizo, con todos sus vasos. ");
INSERT INTO spav1602p_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Hizo también el altar del incienso de madera de acacia: un codo era su longitud, y otro codo su anchura, era cuadrado; y su altu­ra era de dos codos; y sus cuernos de la misma pieza. ");
INSERT INTO spav1602p_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Y cubriólo de oro puro, su mesa y sus paredes alrededor, y sus cuernos: e hízole una corona de oro alrededor. ");
INSERT INTO spav1602p_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Hízole también dos anillos de oro debajo de la corona en las dos esquinas a los dos lados, para pasar por ellos las varas con que había de ser conducido. ");
INSERT INTO spav1602p_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","E hizo las varas de madera de acacia, y cubriólas de oro. ");
INSERT INTO spav1602p_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Hizo asimismo el aceite santo de la unción, y el incienso puro de especias, de obra de perfuma­dor. ");
INSERT INTO spav1602p_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","E HIZO el altar del holocausto de madera de acacia: su longitud era de cinco codos, y su anchura de otros cinco codos, era cuadrado, y de tres codos de altura. ");
INSERT INTO spav1602p_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","E hízole sus cuernos a sus cua­tro esquinas, los cuales eran de la misma pieza, y cubriólo de latón. ");
INSERT INTO spav1602p_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","E hizo todos los vasos del altar: calderas, y tenazas, y tazones, y garfios, y palas: todos sus vasos hizo de latón. ");
INSERT INTO spav1602p_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","E hizo para el altar el enrejado de latón, de hechura de red, que puso en su cerco por debajo hasta el medio del altar. ");
INSERT INTO spav1602p_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Hizo también cuatro anillos de fundición a los cuatro cabos del enrejado de latón, para meter las varas. ");
INSERT INTO spav1602p_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","E hizo las varas de madera de acacia, y cubriólas de latón. ");
INSERT INTO spav1602p_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Y metió las varas por los ani­llos a los lados del altar, para lle­varlo con ellas: hueco lo hizo, de tablas. ");
INSERT INTO spav1602p_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","E hizo la fuente de latón, con su basa de latón, de los espejos de las que se congregaban a la puerta del tabernáculo de la congregación. ");
INSERT INTO spav1602p_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","E hizo el patio; del lado del austro, hacia el sur, las cortinas del patio eran de cien codos, de lino fino torcido: ");
INSERT INTO spav1602p_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Sus columnas eran veinte, con sus veinte basas de latón: los capi­teles de las columnas y sus mol­duras eran de plata. ");
INSERT INTO spav1602p_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Y para la parte del norte las cortinas eran de cien codos: sus columnas eran veinte, y sus veinte basas de latón; los capiteles de las columnas y sus molduras, de plata. ");
INSERT INTO spav1602p_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Y para la parte del occidente corti­nas de cincuenta codos: sus columnas diez, y sus diez basas; los capiteles de las columnas y sus molduras, de plata. ");
INSERT INTO spav1602p_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Y a la parte oriental, al oriente, cortinas de cincuenta codos: ");
INSERT INTO spav1602p_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Las cortinas de un lado de la puerta eran quince codos; sus columnas tres, y sus basas tres. ");
INSERT INTO spav1602p_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Y al otro lado, de la una parte y de la otra de la puerta del patio, cortinas de quince codos, sus tres columnas, y sus tres basas. ");
INSERT INTO spav1602p_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Todas las cortinas del patio alrededor eran de lino torcido. ");
INSERT INTO spav1602p_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Y las basas de las columnas eran de latón; los capiteles de las columnas y sus molduras, de plata; asimismo las cubiertas de las cabezas de ellas, de plata: y todas las columnas del patio tenían molduras de plata. ");
INSERT INTO spav1602p_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Y el pabellón de la puerta del patio fue de obra de recamado, de azul, y púrpura, y escarlata, y lino torcido: la longitud de vein­te codos, y la altura en el ancho de cinco codos, conforme a las cortinas del patio. ");
INSERT INTO spav1602p_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Y sus columnas fueron cuatro con sus cuatro basas de latón: y sus capiteles de plata; y las cubiertas de los capiteles de ellas y sus molduras, de plata. ");
INSERT INTO spav1602p_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Y todas las estacas del taber­náculo y del patio alrededor fue­ron de latón. ");
INSERT INTO spav1602p_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Éstas son las cuentas del tabernáculo, del tabernáculo del testimonio, como fue contado, conforme al orden de Moisés por mano de Itamar, hijo de Aarón sacerdote, para el servicio de los levitas. ");
INSERT INTO spav1602p_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Y Bezaleel, hijo de Uri, hijo de Hur, de la tribu de Judá, hizo todas las cosas que el SEÑOR mandó a Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Y con él estaba Aholiab, hijo de Ahisamac, de la tribu de Dan, artífice, y diseñador, y recama­dor en azul, y púrpura, y escarlata, y lino fino. ");
INSERT INTO spav1602p_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Todo el oro empleado en la obra, en toda la obra del lugar santo, el cual fue oro de ofrenda, fue veintinueve talentos, y sete­cientos y treinta siclos, según el siclo del santuario. ");
INSERT INTO spav1602p_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Y la plata de los contados de la congregación fue cien talentos, y mil setecientos setenta y cinco siclos, según el siclo del santuario: ");
INSERT INTO spav1602p_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Un becá por cabeza, o sea, medio siclo según el siclo del santuario, para cada uno que fue para ser contado, de edad de veinte años y arriba, para seiscientos tres mil quinientos cincuenta. ");
INSERT INTO spav1602p_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Y de los cien talentos de plata fueron hechas de fundición las basas del santuario y las basas del velo: en cien basas cien talen­tos, a talento por basa. ");
INSERT INTO spav1602p_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Y de los mil setecientos seten­ta y cinco siclos hizo los capite­les de las columnas, y cubrió los capiteles de ellas, y las ciñó. ");
INSERT INTO spav1602p_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Y el latón de la ofrenda fue setenta talentos, y dos mil cuatro­cientos siclos; ");
INSERT INTO spav1602p_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Del cual hizo las basas de la puerta del tabernáculo de la con­gregación, y el altar de latón, y su enrejado de latón, y todos los vasos del altar. ");
INSERT INTO spav1602p_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Y las basas del patio alrededor, y las basas de la puerta del patio, y todas las estacas del tabernácu­lo, y todas las estacas del patio alrededor. ");
INSERT INTO spav1602p_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Y DEL azul, y púrpura, y escarlata, hicieron las vestimentas del ministerio para ministrar en el lugar santo, y asimismo hicieron las vestiduras sagradas para Aarón; como el SEÑOR lo había mandado a Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Hizo también el efod de oro, de azul y púrpura y escarlata, y lino fino torcido. ");
INSERT INTO spav1602p_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Y extendieron las planchas de oro, y cortaron hilos para tejerlos entre el azul, y entre la púrpu­ra, y entre la escarlata, y entre el lino, con obra ingeniosa. ");
INSERT INTO spav1602p_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Hiciéronle las hombreras que se juntasen; y uníanse en sus dos lados. ");
INSERT INTO spav1602p_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Y el cinto del efod que estaba sobre él, era de lo mismo, conforme a su obra; de oro, azul, y púrpura, y escarlata, y lino fino tor­cido; como el SEÑOR lo había mandado a Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Y labraron las piedras de ónix cercadas de engastes de oro, grabadas de grabadura de sello con los nombres de los hijos de Israel: ");
INSERT INTO spav1602p_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Y púsolas sobre las hombreras del efod, para que pudieran ser piedras de memo­ria a los hijos de Israel; como el SEÑOR lo había a Moisés man­dado. ");
INSERT INTO spav1602p_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","E hizo la coraza de obra ingeniosa, como la obra del efod, de oro, azul, y púrpura, y escarlata, y lino fino torcido. ");
INSERT INTO spav1602p_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Era cuadrado: doblado hicieron la coraza: su longitud era de un palmo, y de un palmo su anchu­ra, doblado. ");
INSERT INTO spav1602p_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Y engastaron en él cuatro órdenes de piedras. El primer orden era un sardio, un topacio, y un carbunclo: este era el primer orden. ");
INSERT INTO spav1602p_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","El segundo orden, una esme­ralda, un zafiro, y un diamante. ");
INSERT INTO spav1602p_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","El tercer orden, un ligurio, una ágata, y una amatista. ");
INSERT INTO spav1602p_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Y el cuarto orden, un berilo, un ónix, y un jaspe: fueron cercadas y encajadas en sus engastes de oro. ");
INSERT INTO spav1602p_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Las cuales piedras eran conforme a los nombres de los hijos de Israel, doce según los nom­bres de ellos; como grabaduras de sello, cada una con su nombre según las doce tribus. ");
INSERT INTO spav1602p_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Hicieron también sobre la coraza las cadenas pequeñas de hechura de trenza, de oro puro. ");
INSERT INTO spav1602p_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Hicieron asimismo los dos engastes y los dos anillos, de oro; los cuales dos anillos de oro pusieron en los dos cabos de la coraza. ");
INSERT INTO spav1602p_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Y pusieron las dos cadenas trenzadas de oro en aquellos dos anillos a los cabos de la coraza. ");
INSERT INTO spav1602p_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Y fijaron los dos cabos de las dos cadenas trenzadas en los dos engastes, que pusieron sobre las hombre­ras del efod, en la parte delan­tera de él. ");
INSERT INTO spav1602p_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","E hicieron dos anillos de oro, que pusieron en los dos cabos de la coraza en su orilla, a la parte baja del efod. ");
INSERT INTO spav1602p_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","E hicieron otros dos anillos de oro, los cuales pusieron en las dos hombreras del efod, abajo en la parte delantera, delante de su otra juntura, sobre el cinto del efod. ");
INSERT INTO spav1602p_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Y ataron la coraza de sus anillos a los anillos del efod con un cordón de azul, para que estuviese sobre el cinto del mismo efod, y no se apartase la coraza del efod; como el SEÑOR lo había mandado a Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","E hizo el manto del efod de obra de tejedor, todo de azul, ");
INSERT INTO spav1602p_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Y había una abertura en medio del manto, como el cuello de un coselete, con un borde en derredor de la abertura, para que no se rompiese. ");
INSERT INTO spav1602p_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","E hicieron en las orillas del manto las granadas de azul, y púrpura, y escarlata, y lino torci­do. ");
INSERT INTO spav1602p_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Hicieron también las campa­nillas de oro puro, las cuales campanillas pusieron entre las granadas por las orillas del manto alrededor entre las grana­das: ");
INSERT INTO spav1602p_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Una campanilla y una grana­da, una campanilla y una grana­da alrededor, en las orillas del manto, para ministrar; como el SEÑOR lo mandó a Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","E hicieron las túni­cas de lino fino de obra de teje­dor, para Aarón y para sus hijos; ");
INSERT INTO spav1602p_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Asimismo la mitra de lino fino, y los adornos de las tiaras de lino fino, y los pañetes de lino, de lino fino torcido; ");
INSERT INTO spav1602p_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","También el cinto de lino torci­do, y de azul, y púrpura, y escarlata, de obra de recamador; como el SEÑOR lo mandó a Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Hicieron asimismo la plancha de la corona santa de oro puro, y escribieron en ella un escrito, como grabadura de sello, SANTIDAD AL SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Y pusieron en ella un cordón de azul, para colocarla en alto sobre la mitra; como el SEÑOR lo había mandado a Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Así fue acabada toda la obra del tabernáculo, del tabernáculo de la congregación: e hicieron los hijos de Israel como el SEÑOR lo había mandado a Moisés: así lo hicieron. ");
INSERT INTO spav1602p_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Y trajeron el tabernáculo a Moisés, el tabernáculo y todos sus vasos; sus corchetes, sus tablas, sus barras, y sus colum­nas, y sus basas; ");
INSERT INTO spav1602p_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","Y la cubierta de pieles rojas de carneros, y la cubierta de pieles de tejones, y el velo del pabellón; ");
INSERT INTO spav1602p_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","El arca del testimonio, y sus varas, y el propiciatorio; ");
INSERT INTO spav1602p_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","La mesa, todos sus vasos, y el pan de la proposición; ");
INSERT INTO spav1602p_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","El candelero limpio, con sus lámparas, aún las lámparas que debían mantenerse en orden, y todos sus vasos, y el aceite para la lumina­ria; ");
INSERT INTO spav1602p_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","Y el altar de oro, y el aceite de la unción, y el incienso aromáti­co, y el pabellón para la puerta del tabernáculo; ");
INSERT INTO spav1602p_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","El altar de latón, y su enrejado de latón, sus varas, y todos sus vasos; y la fuente, y su basa; ");
INSERT INTO spav1602p_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","Las cortinas del patio, y sus columnas, y sus basas, y el pabe­llón para la puerta del patio, y sus cuerdas, y sus estacas, y todos los vasos del servicio del taber­náculo, del tabernáculo de la congregación; ");
INSERT INTO spav1602p_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Las vestimentas del servicio para ministrar en el lugar santo, las sagradas vestiduras para Aarón el sacerdote, y las vestiduras de sus hijos, para ministrar en el sacerdocio. ");
INSERT INTO spav1602p_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Conforme a todas las cosas que el SEÑOR había man­dado a Moisés, así hicieron los hijos de Israel toda la obra. ");
INSERT INTO spav1602p_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Y miró Moisés toda la obra, y he aquí, la habían hecho como el SEÑOR había mandado, aun así la habían hecho; y Moisés los bendijo. ");
INSERT INTO spav1602p_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Y EL SEÑOR habló a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","En el primer día del mes pri­mero harás levantar el tabernácu­lo, el tabernáculo de la congrega­ción: ");
INSERT INTO spav1602p_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Y pondrás en él el arca del testimonio, y cubrirás el arca con el velo: ");
INSERT INTO spav1602p_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Y meterás la mesa, y la pondrás en orden: meterás también el candelero, y encenderás sus lám­paras: ");
INSERT INTO spav1602p_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Y pondrás el altar de oro para el incienso delante del arca del tes­timonio, y pondrás el pabellón delante de la puerta del taberná­culo. ");
INSERT INTO spav1602p_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Después pondrás el altar de la ofrenda quemada delante de la puerta del tabernáculo, del tabernáculo de la congregación. ");
INSERT INTO spav1602p_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Luego pondrás la fuente entre el tabernáculo de la congrega­ción y el altar; y pondrás agua en ella. ");
INSERT INTO spav1602p_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Y pondrás el patio en derredor, y el pabellón de la puerta del patio. ");
INSERT INTO spav1602p_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Y tomarás el aceite de la unción y ungirás el tabernáculo, y todo lo que está en él; y le san­tificarás con todos sus vasos, y será santo. ");
INSERT INTO spav1602p_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Ungirás también el altar de la ofrenda quemada y todos sus vasos: y santificarás el altar, y será un altar santísimo. ");
INSERT INTO spav1602p_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Asimismo ungirás la fuente y su basa, y la santificarás. ");
INSERT INTO spav1602p_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Y harás llegar a Aarón y a sus hijos a la puerta del tabernáculo de la congregación, y los lavarás con agua. ");
INSERT INTO spav1602p_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Y harás vestir a Aarón las ves­tiduras sagradas, y lo ungirás, y lo consagrarás, para que me ministre en el oficio de sacerdote. ");
INSERT INTO spav1602p_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Después harás llegar sus hijos, y les vestirás con túnicas: ");
INSERT INTO spav1602p_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Y los ungirás como ungiste a su padre, para que me ministren en el oficio de sacerdote: y será que su unción les servirá por sacerdocio perpetuo por sus generaciones. ");
INSERT INTO spav1602p_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Así hizo Moisés conforme a todo lo que el SEÑOR le mandó; así lo hizo. ");
INSERT INTO spav1602p_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Y aconteció en el primer día del segundo año, en el primer día del mes, que el tabernáculo fue erigido. ");
INSERT INTO spav1602p_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Y Moisés erigió el tabernáculo, y asentó sus basas, y colocó sus tablas, y puso sus barras, e hizo alzar sus columnas. ");
INSERT INTO spav1602p_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Y extendió la tienda sobre el tabernáculo, y puso la sobrecu­bierta encima del mismo; como el SEÑOR había mandado a Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Y tomó y puso el testimonio dentro del arca, y colocó las varas en el arca, y encima el propiciatorio sobre el arca: ");
INSERT INTO spav1602p_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Y metió el arca en el taberná­culo, y puso el velo de la cobertura, y cubrió el arca del testimonio; como el SEÑOR había mandado a Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Y puso la mesa en el taberná­culo de la congregación, al lado del pabellón al norte, fuera del velo: ");
INSERT INTO spav1602p_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Y sobre ella puso por orden los panes delante del SEÑOR, como el SEÑOR había mandado a Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Y puso el candelero en el tabernáculo de la congregación, enfrente de la mesa, al lado del pabellón al sur. ");
INSERT INTO spav1602p_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Y encendió las lámparas delante del SEÑOR; como el SEÑOR había mandado a Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Puso también el altar de oro en el tabernáculo de la congrega­ción, delante del velo: ");
INSERT INTO spav1602p_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Y encendió sobre él el incienso aromático; como el SEÑOR había mandado a Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Puso asimismo la cortina a la puerta del tabernáculo. ");
INSERT INTO spav1602p_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Y colocó el altar de la ofrenda quemada a la puerta del tabernáculo, tabernáculo de la congrega­ción; y ofreció sobre él la ofrenda quemada y presente; como el SEÑOR había mandado a Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Y puso la fuente entre la tienda de la congregación y el altar; y puso en ella agua para lavarse. ");
INSERT INTO spav1602p_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Y Moisés y Aarón y sus hijos lavaban en ella sus manos y sus pies. ");
INSERT INTO spav1602p_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Cuando entraban en el taber­náculo de la congregación, y cuando se llegaban al altar, se lavaban; como el SEÑOR había mandado a Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Y erigió el patio en derredor del tabernáculo y del altar, y puso la cortina de la puer­ta del patio. Y así acabó Moisés la obra. ");
INSERT INTO spav1602p_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Entonces una nube cubrió el tabernáculo de la congregación, y la gloria del SEÑOR hinchió el tabernáculo. ");
INSERT INTO spav1602p_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Y no podía Moisés entrar en el tabernáculo de la congrega­ción, porque la nube estaba sobre él, y la gloria del SEÑOR lo tenía lleno. ");
INSERT INTO spav1602p_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Y cuando la nube se alzaba del tabernáculo, los hijos de Israel se movían en todas sus jor­nadas: ");
INSERT INTO spav1602p_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Pero si la nube no se alzaba, no se partían hasta el día en que ella se alzaba. ");
INSERT INTO spav1602p_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Porque la nube del SEÑOR estaba de día sobre el tabernácu­lo, y el fuego estaba de noche en él, a vista de toda la casa de Israel, en todas sus jornadas. ");
INSERT INTO spav1602p_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Y LLAMÓ el SEÑOR a Moisés, y habló con él desde el tabernáculo de la congregación, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Habla a los hijos de Israel, y díles: Cuando alguno de entre vosotros ofreciere ofrenda al SEÑOR, de ganado vacuno u ovejuno haréis vuestra ofrenda. ");
INSERT INTO spav1602p_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Si su ofrenda fuere una ofrenda quemada de vacas, macho sin tacha lo ofrecerá: de su voluntad lo ofre­cerá a la puerta del tabernáculo de la congregación delante del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Y pondrá su mano sobre la cabeza de la ofrenda quemada; y él lo aceptará para expiarle. ");
INSERT INTO spav1602p_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Entonces degollará el becerro en la presencia del SEÑOR; y los sacerdotes, hijos de Aarón, ofre­cerán la sangre, y rociarán la sangre alrededor sobre el altar, el cual está a la puerta del taberná­culo de la congregación. ");
INSERT INTO spav1602p_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Y desollará la ofrenda quemada, y lo dividirá en sus piezas. ");
INSERT INTO spav1602p_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Y los hijos de Aarón sacerdote pondrán fuego sobre el altar, y compondrán la leña sobre el fuego. ");
INSERT INTO spav1602p_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Luego los sacerdotes, hijos de Aarón, acomodarán las piezas, la cabeza y el redaño, sobre la leña que está sobre el fuego, que habrá encima del altar: ");
INSERT INTO spav1602p_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Y lavará con agua sus intesti­nos y sus piernas: y el sacerdote hará arder todo sobre el altar: ofrenda quemada es, ofrenda hecha por fuego, de olor suave al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Y si su ofrenda para sacrificio quemado fuere de ovejas, de los corde­ros, o de las cabras, macho sin defecto lo ofrecerá. ");
INSERT INTO spav1602p_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Y ha de degollarlo al lado sep­tentrional del altar delante del SEÑOR: y los sacerdotes, hijos de Aarón, rociarán su sangre sobre el altar alrededor. ");
INSERT INTO spav1602p_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Y lo dividirá en sus piezas, con su cabeza y su redaño; y el sacerdote las acomodará sobre la leña que está sobre el fuego, que habrá encima del altar; ");
INSERT INTO spav1602p_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Y lavará sus entrañas y sus piernas con agua; y el sacerdote lo ofrecerá todo, y harálo arder sobre el altar; ofrenda quemada es, ofrenda hecha por fuego, de olor suave al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Y si la ofrenda quemada se hubiere de ofrecer al SEÑOR de aves, presentará su ofrenda de tórtolas, o de palominos. ");
INSERT INTO spav1602p_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Y el sacerdote la ofrecerá sobre el altar, y ha de quitarle la cabeza, y hará que arda en el altar; y su sangre será exprimida sobre la pared del altar. ");
INSERT INTO spav1602p_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Y le ha de quitar el buche y las plumas, lo cual echará junto al altar, hacia el oriente, en el lugar de las cenizas. ");
INSERT INTO spav1602p_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Y la henderá por sus alas, mas no la dividirá en dos: y el sacer­dote la hará arder sobre el altar, sobre la leña que estará en el fuego; ofrenda quemada es, ofrenda hecha por fuego, de olor suave al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Y CUANDO alguna persona ofreciere oblación de presente al SEÑOR, su ofrenda será flor de harina, sobre la cual echará aceite, y pondrá sobre ella incienso: ");
INSERT INTO spav1602p_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Y la traerá a los sacerdotes, hijos de Aarón; y de ello tomará el sacerdote su puño lleno de su flor de harina y de su aceite, con todo su incienso, y lo hará arder sobre el altar: ofrenda hecha por fuego para recuerdo, de olor suave al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Y la sobra de la ofrenda será de Aarón y de sus hijos: es cosa san­tísima de las ofrendas hechas por fuego al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Y si ofrecieres ofrenda de presente cocida en horno, será de tortas de flor de harina sin levadura, amasadas con aceite, u hojaldres sin levadura untadas con aceite. ");
INSERT INTO spav1602p_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Mas si tu presente fuere ofren­da de sartén, será de flor de hari­na sin levadura, amasada con aceite, ");
INSERT INTO spav1602p_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","La cual partirás en piezas, y echarás sobre ella aceite: es pre­sente. ");
INSERT INTO spav1602p_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Y si tu presente fuere ofrenda cocida en cazuela, haráse de flor de harina con aceite. ");
INSERT INTO spav1602p_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Y traerás al SEÑOR la ofrenda que se hará de estas cosas, y la presentarás al sacerdote, el cual la llegará al altar. ");
INSERT INTO spav1602p_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Y tomará el sacerdote de aque­lla ofrenda, en memoria del mismo, y harálo arder sobre el altar; es ofrenda hecha por fuego, de suave olor al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Y lo restante de la ofrenda será de Aarón y de sus hijos: es cosa santísima de las ofrendas hechas por fuego al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Ninguna ofrenda que ofrecie­reis al SEÑOR, será con levadura: porque de ninguna cosa leuda, ni de ninguna miel, se ha de quemar en ofrenda hecha por fuego al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","En la ofrenda de las primicias las ofreceréis al SEÑOR: mas no serán quemadas sobre el altar en olor de suavidad. ");
INSERT INTO spav1602p_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Y sazonarás toda ofrenda de tu presente con sal; y no harás que falte jamás de tu presente la sal del pacto de tu Dios: en toda ofrenda tuya ofrecerás sal. ");
INSERT INTO spav1602p_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Y si ofrecieres al SEÑOR pre­sente de primicias, tostarás al fuego las espigas verdes, y el grano desmenuzado ofrecerás por ofrenda de tus primicias. ");
INSERT INTO spav1602p_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Y pondrás sobre ella aceite, y pondrás sobre ella incienso: es presente. ");
INSERT INTO spav1602p_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Y el sacerdote hará arder, en memoria del don, parte de su grano desmenuzado, y de su acei­te con todo su incienso; es ofrenda hecha por fuego al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Y SI su ofrenda fuere sacrificio de paces, si hubiere de ofrecerlo de ganado vacuno, sea macho o hembra, sin defecto lo ofrecerá delante del SEÑOR: ");
INSERT INTO spav1602p_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Y pondrá su mano sobre la cabe­za de su ofrenda, y la degollará a la puerta del tabernáculo de la congregación; y los sacerdotes, hijos de Aarón, rociarán su san­gre sobre el altar en derredor. ");
INSERT INTO spav1602p_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Luego ofrecerá del sacrificio de las paces, por ofrenda hecha por fuego al SEÑOR, el sebo que cubre los intestinos, y todo el sebo que está sobre las entrañas, ");
INSERT INTO spav1602p_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","Y los dos riñones, y el sebo que está sobre ellos, y sobre los ija­res, y con los riñones quitará el redaño que está sobre el hígado. ");
INSERT INTO spav1602p_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Y los hijos de Aarón harán arder esto en el altar, sobre la ofrenda quemada que estará sobre la leña que habrá encima del fuego; es ofrenda hecha por fuego, de olor suave al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Mas si de ovejas fuere su ofrenda para sacrificio de paces al SEÑOR, sea macho o hembra, ofrecerála sin tacha. ");
INSERT INTO spav1602p_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Si ofreciere cordero por su ofrenda, ha de ofrecerlo delante del SEÑOR: ");
INSERT INTO spav1602p_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Y pondrá su mano sobre la cabeza de su ofrenda, y después la degollará delante del taberná­culo de la congregación; y los hijos de Aarón rociarán su sangre sobre el altar en derredor. ");
INSERT INTO spav1602p_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Y del sacrificio de las paces ofrecerá por ofrenda hecha por fuego al SEÑOR; su sebo, y la cola entera, la cual quitará a raíz del espinazo; y el sebo que cubre los intestinos, y todo el sebo que está sobre las entrañas: ");
INSERT INTO spav1602p_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","Asimismo los dos riñones, y el sebo que está sobre ellos, y el que está sobre los ijares, y con los riñones quitará el redaño de sobre el hígado. ");
INSERT INTO spav1602p_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Y el sacerdote hará arder esto sobre el altar; vianda de ofrenda hecha por fuego al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Y si fuere cabra su ofrenda ofrecerála delante del SEÑOR: ");
INSERT INTO spav1602p_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Y pondrá su mano sobre la cabeza de ella, y la degollará delante del tabernáculo de la congregación; y los hijos de Aarón rociarán su sangre sobre el altar en derredor. ");
INSERT INTO spav1602p_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Después ofrecerá de ella su ofrenda hecha por fuego al SEÑOR; el sebo que cubre los intestinos, y todo el sebo que está sobre las entrañas, ");
INSERT INTO spav1602p_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","Y los dos riñones, y el sebo que está sobre ellos, y el que está sobre los ijares, y con los riñones quitará el redaño de sobre el hígado. ");
INSERT INTO spav1602p_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Y el sacerdote hará arder esto sobre el altar; es la vianda de la ofrenda hecha por fuego en olor de suavidad al SEÑOR: el sebo todo es del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Estatuto perpetuo por vues­tras edades; en todas vuestras moradas, ningún sebo ni ninguna sangre comeréis. ");
INSERT INTO spav1602p_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Y HABLÓ el SEÑOR a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Habla a los hijos de Israel, diciendo: Cuando alguna perso­na pecare por yerro en alguno de los mandamientos del SEÑOR sobre cosas que no se han de hacer, y obrare contra alguno de ellos; ");
INSERT INTO spav1602p_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Si sacerdote ungido pecare según el pecado del pueblo, ofre­cerá al SEÑOR, por su pecado que habrá cometido, un becerro sin tacha para expiación. ");
INSERT INTO spav1602p_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Y traerá el becerro a la puerta del tabernáculo de la congrega­ción delante del SEÑOR, y pon­drá su mano sobre la cabeza del becerro, y lo degollará delante del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Y el sacerdote ungido tomará de la sangre del becerro, y la trae­rá al tabernáculo de la congrega­ción; ");
INSERT INTO spav1602p_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Y mojará el sacerdote su dedo en la sangre, y rociará de aquella san­gre siete veces delante del SEÑOR, hacia el velo del santua­rio. ");
INSERT INTO spav1602p_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Y pondrá el sacerdote de la sangre sobre los cuernos del altar del perfume aromático, que está en el tabernáculo de la congrega­ción delante del SEÑOR: y echa­rá toda la sangre del becerro al pie del altar de la ofrenda quemada, que está a la puerta del tabernáculo de la congregación. ");
INSERT INTO spav1602p_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Y tomará del becerro para la expiación todo su sebo, el sebo que cubre los intestinos, y todo el sebo que está sobre las entrañas, ");
INSERT INTO spav1602p_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","Y los dos riñones, y el sebo que está sobre ellos, y el que está sobre los ijares, y con los riñones quitará el redaño de sobre el hígado, ");
INSERT INTO spav1602p_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","De la manera que se quita del buey del sacrificio de las paces: y el sacerdote lo hará arder sobre el altar de la ofrenda quemada. ");
INSERT INTO spav1602p_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Y el cuero del becerro, y toda su carne, con su cabeza, y sus piernas, y sus intestinos, y su estiércol, ");
INSERT INTO spav1602p_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","En fin, todo el becerro sacará fuera del campo, a un lugar lim­pio, donde se echan las cenizas, y lo quemará al fuego sobre la leña: en donde se echan las ceni­zas será quemado. ");
INSERT INTO spav1602p_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Y si toda la congregación de Israel hubiere errado, y el nego­cio estuviere oculto a los ojos de la asamblea, y hubieren hecho algo contra alguno de los mandamientos del SEÑOR en cosas que no se han de hacer, y fueren culpables; ");
INSERT INTO spav1602p_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Luego que fuere entendido el pecado sobre que delinquieron, la congregación ofrecerá un becerro por expiación, y lo trae­rán delante del tabernáculo de la congregación. ");
INSERT INTO spav1602p_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Y los ancianos de la congre­gación pondrán sus manos sobre la cabeza del becerro delante del SEÑOR; y en presencia del SEÑOR degollarán aquel bece­rro. ");
INSERT INTO spav1602p_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Y el sacerdote ungido meterá de la sangre del becerro en el tabernáculo de la congregación: ");
INSERT INTO spav1602p_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Y mojará el sacerdote su dedo en la misma sangre, y rociará siete veces delante del SEÑOR hacia el velo. ");
INSERT INTO spav1602p_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Y de aquella sangre pondrá sobre los cuernos del altar que está delante del SEÑOR en el tabernáculo de la congregación, y derramará toda la sangre al pie del altar de la ofrenda quemada, que está a la puerta del tabernáculo de la congregación. ");
INSERT INTO spav1602p_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Y le quitará todo el sebo, y harálo arder sobre el altar. ");
INSERT INTO spav1602p_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Y hará de aquel becerro como hizo con el becerro de la expia­ción; lo mismo hará de él: así hará el sacerdote expiación por ellos, y obtendrán perdón. ");
INSERT INTO spav1602p_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Y sacará el becerro fuera del campamento, y lo quemará como quemó el primer becerro; expiación de la congregación. ");
INSERT INTO spav1602p_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Y cuando pecare el príncipe, e hiciere por yerro algo contra alguno de todos los mandamien­tos del SEÑOR su Dios, sobre cosas que no se han de hacer, y pecare; ");
INSERT INTO spav1602p_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Luego que le fuere conocido su pecado en que ha delinquido, presentará por su ofrenda un macho cabrío sin defecto; ");
INSERT INTO spav1602p_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Y pondrá su mano sobre la cabeza del macho cabrío, y lo degollará en el lugar donde se degüella la ofrenda quemada delante del SEÑOR; es expiación. ");
INSERT INTO spav1602p_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Y tomará el sacerdote con su dedo de la sangre de la expia­ción, y pondrá sobre los cuernos del altar de la ofrenda quemada, y derra­mará la sangre al pie del altar de la ofrenda quemada: ");
INSERT INTO spav1602p_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Y quemará todo su sebo sobre el altar, como el sebo del sacrifi­cio de las paces: así hará el sacer­dote por él la expiación de su pecado, y tendrá perdón. ");
INSERT INTO spav1602p_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Y si alguna persona del común del pueblo pecare por yerro, haciendo algo contra algu­no de los mandamientos del SEÑOR en cosas que no se han de hacer, y fuere culpable; ");
INSERT INTO spav1602p_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Luego que le fuere conocido su pecado que cometió, traerá por su ofrenda una hembra de las cabras, una cabra sin defecto, por su pecado que habrá cometido: ");
INSERT INTO spav1602p_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Y pondrá su mano sobre la cabeza de la expiación, y la degollará en el lugar de la ofrenda quemada. ");
INSERT INTO spav1602p_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Luego tomará el sacerdote en su dedo de su sangre, y pondrá sobre los cuernos del altar de la ofrenda quemada, y derramará toda su sangre al pie del altar: ");
INSERT INTO spav1602p_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Y le quitará todo su sebo, de la manera que fue quitado el sebo del sacrificio de las paces; y el sacerdote lo hará arder sobre el altar en olor de suavidad al SEÑOR: así hará el sacerdote expiación por él, y será perdona­do. ");
INSERT INTO spav1602p_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Y si trajere cordero para su ofrenda por el pecado, hembra sin defecto traerá: ");
INSERT INTO spav1602p_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Y pondrá su mano sobre la cabeza de la expiación y la dego­llará por expiación en el lugar donde se degüella la ofrenda quemada. ");
INSERT INTO spav1602p_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Después tomará el sacerdote con su dedo de la sangre de la expiación, y pondrá sobre los cuernos del altar de la ofrenda quemada; y derramará toda la sangre al pie del altar: ");
INSERT INTO spav1602p_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Y le quitará todo su sebo, como fue quitado el sebo del sacrificio de las paces, y harálo el sacerdote arder en el altar, conforme a la ofrenda hecha por fuego al SEÑOR: y le hará el sacerdote expiación de su pecado que habrá cometido, y le será perdonado. ");
INSERT INTO spav1602p_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Y CUANDO alguna persona pecare, que hubiere oído la voz del que juró, y él fuere testigo que vio, o supo, si no lo denunciare, él llevará su pecado. ");
INSERT INTO spav1602p_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Asimismo la persona que hubiere tocado en cualquiera cosa inmunda, sea cuerpo muerto de bestia inmunda, o cuerpo muerto de animal inmundo, o cuerpo muerto de reptil inmundo, bien que no lo supiere, será inmunda y habrá delinquido: ");
INSERT INTO spav1602p_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","O si tocare a hombre inmundo en cualquiera inmundicia suya de que es inmundo, y no lo echa­re de ver; si después llega a saberlo, será culpable. ");
INSERT INTO spav1602p_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","También la persona que jurare, pronunciando con sus labios hacer mal o bien, en cualesquie­ra cosas que el hombre profiere con juramento, y él no lo cono­ciere; si después lo entiende, será culpado en una de estas cosas. ");
INSERT INTO spav1602p_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Y será que cuando pecare en alguna de estas cosas, confesará aquello en que pecó: ");
INSERT INTO spav1602p_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Y para su expiación traerá al SEÑOR por su pecado que ha cometido, una hembra de los rebaños, una cordera o una cabra como ofrenda de expiación; y el sacerdote hará expiación por él de su pecado. ");
INSERT INTO spav1602p_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Y si no le alcanzare para un cor­dero, traerá en expiación por su pecado que cometió, dos tórtolas o dos palominos al SEÑOR; el uno para expiación, y el otro para ofrenda quemada. ");
INSERT INTO spav1602p_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Y ha de traerlos al sacerdote, el cual ofrecerá primero el que es para expiación, y desunirá su cabeza de su cuello, mas no la apartará del todo: ");
INSERT INTO spav1602p_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Y rociará de la sangre de la expiación sobre la pared del altar; y lo que sobrare de la san­gre lo exprimirá al pie del altar; es expiación. ");
INSERT INTO spav1602p_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Y del otro hará ofrenda quemada conforme a la manera; y hará por él el sacerdote expiación de su pecado que cometió, y será perdonado. ");
INSERT INTO spav1602p_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Mas si su posibilidad no alcanzare para dos tórtolas, o dos palominos, el que pecó traerá por su ofrenda la décima parte de un efa de flor de harina por expia­ción. No pondrá sobre ella acei­te, ni sobre ella pondrá incienso, porque es expiación. ");
INSERT INTO spav1602p_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Traerála, pues, al sacerdote, y el sacerdote tomará de ella su puño lleno, en memoria suya, y la hará arder en el altar, conforme a las ofrendas hechas por fuego al SEÑOR: es expiación. ");
INSERT INTO spav1602p_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Y hará el sacerdote expiación por él de su pecado que cometió en alguna de estas cosas, y será perdonado; y el sobrante será del sacerdote, como el presente de vianda. ");
INSERT INTO spav1602p_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Habló más el SEÑOR a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Cuando alguna persona cometiere falta, y pecare por yerro en las cosas santificadas al SEÑOR, traerá su expiación al SEÑOR, un carnero sin tacha de los rebaños, conforme a tu esti­mación, en siclos de plata del siclo del santuario, en ofrenda por el pecado: ");
INSERT INTO spav1602p_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Y pagará aquello de las cosas santas en que hubiere pecado, y añadirá a ello el quinto, y lo dará al sacerdote: y el sacerdote hará expiación por él con el carnero del sacrificio por el pecado, y será perdonado. ");
INSERT INTO spav1602p_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Finalmente, si una persona pecare, o hiciere alguna de todas aquellas cosas que por manda­miento del SEÑOR no se han de hacer, aun sin hacerlo a sabien­das, es culpable, y llevará su pecado. ");
INSERT INTO spav1602p_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Traerá, pues, al sacerdote por expiación, según tú lo estimes, un carnero sin tacha de los reba­ños: y el sacerdote hará expia­ción por él de su yerro que come­tió por ignorancia, y será perdo­nado. ");
INSERT INTO spav1602p_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Es ofrenda de transgresión, y ciertamente traspasó contra el SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Y HABLÓ el SEÑOR a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Cuando una persona pecare, e hiciere prevaricación contra el SEÑOR, y negare a su prójimo lo encomendado, o dejado en su mano, o bien robare, o calumnia­re a su prójimo; ");
INSERT INTO spav1602p_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","O sea que hallando lo perdido, después lo negare, y jurare en falso, en alguna de todas aquellas cosas en que suele pecar el hom­bre: ");
INSERT INTO spav1602p_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Entonces será que, puesto habrá pecado y ofendido, restituirá aquello que robó, o por el daño de la calumnia, o el depósito que se le encomendó, o lo perdido que halló, ");
INSERT INTO spav1602p_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","O todo aquello sobre que hubiere jurado falsamente; lo restituirá, pues, por entero, y aña­dirá a ello la quinta parte, que ha de pagar a aquel a quien pertene­ce en el día de su expiación. ");
INSERT INTO spav1602p_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Y por su expiación traerá al SEÑOR un carnero sin tacha de los rebaños, conforme a tu esti­mación, al sacerdote para la expiación. ");
INSERT INTO spav1602p_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Y el sacerdote hará expiación por él delante del SEÑOR, y obtendrá perdón de cualquiera de todas las cosas en que suele ofen­der. ");
INSERT INTO spav1602p_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Habló aún el SEÑOR a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Manda a Aarón y a sus hijos diciendo: Ésta es la ley de la ofrenda quemada: Es ofrenda quemada, porque se quema sobre el altar toda la noche hasta la mañana, y el fuego del altar arderá en él. ");
INSERT INTO spav1602p_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Y el sacerdote se pondrá su ves­timenta de lino, y se vestirá pañe­tes de lino sobre su carne; y cuando el fuego hubiere consu­mido la ofrenda quemada, apartará él las cenizas de sobre el altar, y pondrálas junto al altar. ");
INSERT INTO spav1602p_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Después se desnudará de sus vestimentas, y se pondrá otras vestiduras, y sacará las cenizas fuera del real al lugar limpio. ");
INSERT INTO spav1602p_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Y el fuego encendido sobre el altar no ha de apagarse, sino que el sacerdote pondrá en él leña cada mañana, y acomodará sobre él la ofrenda quemada, y quemará sobre él los sebos de las paces. ");
INSERT INTO spav1602p_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","El fuego ha de arder conti­nuamente en el altar; no se apa­gará. ");
INSERT INTO spav1602p_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Y ésta es la ley del presente: Han de ofrecerlo los hijos de Aarón delante del SEÑOR, delan­te del altar. ");
INSERT INTO spav1602p_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Y tomará de él un puñado de la flor de harina del presente, y de su aceite, y todo el incienso que está sobre el presente, y harálo arder sobre el altar por memoria, en olor suavísimo al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Y el sobrante de ella lo come­rán Aarón y sus hijos: sin levadu­ra se comerá en el lugar santo; en el patio del tabernáculo de la con­gregación lo comerán. ");
INSERT INTO spav1602p_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","No se cocerá con levadura: helo dado a ellos por su porción de mis ofrendas hechas por fuego; es cosa santísima, como la expiación por el pecado, y como la expiación por la culpa. ");
INSERT INTO spav1602p_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Todos los varones de los hijos de Aarón comerán de ella. Estatuto perpetuo será para vues­tras generaciones tocante a las ofrendas hechas por fuego del SEÑOR: toda cosa que tocare en ellas será santificada. ");
INSERT INTO spav1602p_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Y habló el SEÑOR a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Ésta es la ofrenda de Aarón y de sus hijos, que ofrecerán al SEÑOR el día que serán ungi­dos: la décima parte de un efa de flor de harina, presente perpetuo, la mitad a la mañana y la mitad a la tarde. ");
INSERT INTO spav1602p_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","En sartén se aderezará con aceite; frita la traerás, y los peda­zos cocidos del presente ofrece­rás al SEÑOR en olor de suavi­dad. ");
INSERT INTO spav1602p_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Y el sacerdote que en lugar de Aarón fuere ungido de entre sus hijos, hará la ofrenda; estatuto perpetuo del SEÑOR: toda ella será quemada. ");
INSERT INTO spav1602p_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Y todo presente de sacerdote será enteramente quemado; no se comerá. ");
INSERT INTO spav1602p_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Y habló el SEÑOR a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","Habla a Aarón y a sus hijos, diciendo: Ésta es la ley de la expiación: en el lugar donde será degollado la ofrenda quemada, será degollada la expiación por el pecado delante del SEÑOR: es cosa santísima. ");
INSERT INTO spav1602p_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","El sacerdote que la ofreciere por expiación, la comerá: en el lugar santo será comida, en el patio del tabernáculo de la con­gregación. ");
INSERT INTO spav1602p_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Todo lo que en su carne toca­re, será santificado; y si cayere de su sangre sobre la vestidura, lavarás aquello sobre que cayere, en el lugar santo. ");
INSERT INTO spav1602p_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Y la vasija de barro en que fuere cocida, será quebrada: y si fuere cocida en vasija de latón, será fregada y lavada con agua. ");
INSERT INTO spav1602p_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Todo varón de entre los sacer­dotes la comerá: es cosa santísi­ma. ");
INSERT INTO spav1602p_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Mas no se comerá de expia­ción alguna, de cuya sangre se metiere en el tabernáculo de la congregación para reconciliar en el santuario: al fuego será que­mada. ");
INSERT INTO spav1602p_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","ASIMISMO ésta es la ley de la expiación de la culpa: es cosa muy santa. ");
INSERT INTO spav1602p_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","En el lugar donde degollaren la ofrenda quemada, degollarán la víctima por la culpa; y rociará su sangre en derredor sobre el altar: ");
INSERT INTO spav1602p_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Y de ella ofrecerá todo su sebo, la cola, y el sebo que cubre los intestinos. ");
INSERT INTO spav1602p_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","Y los dos riñones, y el sebo que está sobre ellos, y el que está sobre los ijares; y con los riñones quitará el redaño de sobre el hígado. ");
INSERT INTO spav1602p_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Y el sacerdote lo hará arder sobre el altar; ofrenda hecha por fuego al SEÑOR: es ofrenda por la culpa. ");
INSERT INTO spav1602p_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Todo varón de entre los sacerdotes la comerá: será comida en el lugar santo: es cosa muy santa. ");
INSERT INTO spav1602p_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Como la expiación por el peca­do, así es la expiación de la culpa: una misma ley tendrán: será del sacerdote que habrá hecho la reconciliación con ella. ");
INSERT INTO spav1602p_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Y el sacerdote que ofreciere ofrenda quemada de alguno, el cuero de la ofrenda quemada que ofreciere, será para él. ");
INSERT INTO spav1602p_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Asimismo todo presente que se cociere en horno, y todo el que fuere aderezado en sartén, o en cazuela, será del sacerdote que lo ofreciere. ");
INSERT INTO spav1602p_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Y todo presente amasado con aceite, y seco, será de todos los hijos de Aarón, tanto al uno como al otro. ");
INSERT INTO spav1602p_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Y ésta es la ley del sacrificio de las paces, que se ofrecerá al SEÑOR: ");
INSERT INTO spav1602p_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Si se ofreciere por acción de gracias, ofrecerá con sacrificio de acción de gracias tortas sin levadura amasadas con aceite, y hojaldres sin levadura untadas con aceite, y flor de harina frita en tortas amasadas con aceite. ");
INSERT INTO spav1602p_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Con tortas de pan leudo ofre­cerá su ofrenda en el sacrificio de acción de gracias de sus paces. ");
INSERT INTO spav1602p_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Y de toda la ofrenda presenta­rá una parte por ofrenda elevada al SEÑOR, y será del sacerdote que rociare la sangre de los pací­ficos. ");
INSERT INTO spav1602p_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Y la carne del sacrificio de sus pacíficos en acción de gracias, se comerá en el día que fuere ofre­cida: no dejarán de ella nada para otro día. ");
INSERT INTO spav1602p_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Mas si el sacrificio de su ofrenda fuere voto, o voluntario, el día que ofreciere su sacrificio será comido; y lo que de él que­dare, comerse ha el día siguiente: ");
INSERT INTO spav1602p_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Y lo que quedare para el ter­cer día de la carne del sacrificio, será quemado en el fuego. ");
INSERT INTO spav1602p_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Y si se comiere de la carne del sacrificio de sus paces el tercer día, el que lo ofreciere no será acepto, ni le será imputado; abo­minación será, y la persona que de él comiere llevará su pecado. ");
INSERT INTO spav1602p_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Y la carne que tocare a alguna cosa inmunda, no se comerá; al fuego será quemada; mas cual­quiera limpio comerá de esta carne. ");
INSERT INTO spav1602p_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Y la persona que comiere la carne del sacrificio de paces, el cual es del SEÑOR, estando inmunda, aquella persona será cortada de sus pueblos. ");
INSERT INTO spav1602p_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Además, la persona que toca­re alguna cosa inmunda, en inmundicia de hombre, o en ani­mal inmundo, o en cualquiera abominación inmunda, y comie­re la carne del sacrificio de las paces, el cual es del SEÑOR, aquella persona será cortada de sus pueblos. ");
INSERT INTO spav1602p_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Habló aún el SEÑOR a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Habla a los hijos de Israel, diciendo: Ningún sebo de buey, ni de cordero, ni de cabra, come­réis. ");
INSERT INTO spav1602p_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","El sebo de animal mortecino, y el sebo del que fue arrebatado de fieras, se aparejará para cual­quiera otro uso, mas no lo come­réis. ");
INSERT INTO spav1602p_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Porque cualquiera que comie­re sebo de animal, del cual se ofrece al SEÑOR ofrenda hecha por fuego, la persona que lo comiere, será cortada de sus pue­blos. ");
INSERT INTO spav1602p_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Además, ninguna sangre comeréis en todas vuestras habitaciones, así de aves como de bestias. ");
INSERT INTO spav1602p_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Cualquiera persona que comie­re alguna sangre, la tal persona será cortada de sus pueblos. ");
INSERT INTO spav1602p_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Habló más el SEÑOR a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Habla a los hijos de Israel, diciendo: El que ofreciere sacri­ficio de sus paces al SEÑOR, traerá su ofrenda del sacrificio de sus paces al SEÑOR; ");
INSERT INTO spav1602p_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Sus manos traerán las ofren­das del SEÑOR hechas por fuego: traerá el sebo con el pecho: el pecho para que éste sea mecido, como sacrificio mecido delante del SEÑOR; ");
INSERT INTO spav1602p_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Y el sebo lo hará arder el sacerdote en el altar; mas el pecho será de Aarón y de sus hijos. ");
INSERT INTO spav1602p_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Y daréis al sacerdote para ser elevada en ofrenda, la espaldilla derecha de los sacrificios de vuestras paces. ");
INSERT INTO spav1602p_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","El que de los hijos de Aarón ofreciere la sangre de las paces, y el sebo, de él será en porción la espaldilla derecha; ");
INSERT INTO spav1602p_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Porque he tomado de los hijos de Israel, de los sacrificios de sus paces, el pecho mecido, y la espaldilla elevada en ofrenda, y lo he dado a Aarón el sacerdote y a sus hijos, por estatuto perpetuo de los hijos de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Ésta es por la unción de Aarón y la unción de sus hijos, la parte de ellos en las ofrendas hechas por fuego al SEÑOR, desde el día que él los allegó para ser sacerdotes del SEÑOR: ");
INSERT INTO spav1602p_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Lo cual mandó el SEÑOR que les diesen, desde el día que él los ungió de entre los hijos de Israel, por estatuto perpetuo en sus generaciones. ");
INSERT INTO spav1602p_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Ésta es la ley de la ofrenda quemada, del presente, de la expiación por el pecado, y de la culpa, y de las consagraciones, y del sacrificio de las paces: ");
INSERT INTO spav1602p_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","La cual intimó el SEÑOR a Moisés, en el monte de Sinaí, el día que mandó a los hijos de Israel que ofreciesen sus ofren­das al SEÑOR en el desierto de Sinaí. ");
INSERT INTO spav1602p_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Y HABLÓ el SEÑOR a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","Toma a Aarón y a sus hijos con él, y las vestimentas, y el aceite de la unción, y el becerro de la expiación, y los dos carneros, y el canastillo de los panes sin levadura; ");
INSERT INTO spav1602p_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Y reúne toda la congregación a la puerta del tabernáculo de la congregación. ");
INSERT INTO spav1602p_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Hizo, pues, Moisés como el SEÑOR le mandó, y juntóse la asamblea a la puerta del tabernáculo de la congregación. ");
INSERT INTO spav1602p_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Y dijo Moisés a la congrega­ción: Esto es lo que el SEÑOR ha mandado hacer. ");
INSERT INTO spav1602p_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Entonces Moisés hizo llegar a Aarón y a sus hijos, y lavólos con agua. ");
INSERT INTO spav1602p_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Y puso sobre él la túnica, y ciñólo con el cinto; vistióle des­pués el manto, y puso sobre él el efod, y ciñólo con el cinto del efod, y ajustólo con él. ");
INSERT INTO spav1602p_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Púsole luego encima la coraza, y en él puso el Urim y Tumim. ");
INSERT INTO spav1602p_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Después puso la mitra sobre su cabeza; y sobre la mitra en su frente delantera puso la plancha de oro, la corona santa; como el SEÑOR había mandado a Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Y tomó Moisés el aceite de la unción, y ungió el tabernáculo, y todas las cosas que estaban en él, y santificólas. ");
INSERT INTO spav1602p_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Y roció de él sobre el altar siete veces, y ungió el altar y todos sus vasos, y la fuente y su basa, para santificarlos. ");
INSERT INTO spav1602p_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Y derramó del aceite de la unción sobre la cabeza de Aarón, y ungiólo para santificarlo. ");
INSERT INTO spav1602p_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Después Moisés hizo llegar los hijos de Aarón, y vistióles las túnicas, y ciñólos con cintos, y ajustóles las tiaras, como el SEÑOR lo había mandado a Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Hizo luego llegar el becerro de la expiación, y Aarón y sus hijos pusieron sus manos sobre la cabeza del becerro de la expia­ción. ");
INSERT INTO spav1602p_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Y degollólo; y Moisés tomó la sangre, y puso con su dedo sobre los cuernos del altar alrededor, y purificó el altar; y echó la demás sangre al pie del altar, y santifi­cólo para reconciliar sobre él. ");
INSERT INTO spav1602p_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Después tomó todo el sebo que estaba sobre los intestinos, y el redaño del hígado, y los dos riñones, y el sebo de ellos, e hízolo Moisés arder sobre el altar. ");
INSERT INTO spav1602p_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Mas el becerro, y su cuero, y su carne, y su estiércol, quemólo al fuego fuera del real; como el SEÑOR lo había mandado a Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Después hizo llegar el carne­ro para la ofrenda quemada, y Aarón y sus hijos pusieron sus manos sobre la cabeza del carnero: ");
INSERT INTO spav1602p_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Y degollólo; y roció Moisés la sangre sobre el altar en derredor. ");
INSERT INTO spav1602p_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Y cortó el carnero en trozos: y Moisés hizo arder la cabeza, y los trozos, y el sebo. ");
INSERT INTO spav1602p_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Lavó luego con agua los intestinos y piernas, y quemó Moisés todo el carnero sobre el altar: ofrenda quemada en olor de sua­vidad, ofrenda hecha por fuego al SEÑOR; como lo había el SEÑOR mandado a Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Después hizo llegar el otro carnero, el carnero de las consa­graciones, y Aarón y sus hijos pusieron sus manos sobre la cabeza del carnero: ");
INSERT INTO spav1602p_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Y degollólo; y tomó Moisés de su sangre, y puso sobre la ter­nilla de la oreja derecha de Aarón, y sobre el dedo pulgar de su mano derecha, y sobre el dedo pulgar de su pie derecho. ");
INSERT INTO spav1602p_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Hizo llegar luego los hijos de Aarón, y puso Moisés de la sangre sobre la ternilla de sus orejas derechas, y sobre los pulgares de sus manos derechas, y sobre los pulgares de sus pies derechos: y roció Moisés la sangre sobre el altar en derredor; ");
INSERT INTO spav1602p_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Y después tomó el sebo, y la cola, y todo el sebo que estaba sobre los intestinos, y el redaño del hígado, y los dos riñones, y el sebo de ellos, y la espaldilla derecha; ");
INSERT INTO spav1602p_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Y del canastillo de panes sin levadura, que estaba delante del SEÑOR, tomó una torta sin levadura, y una torta de pan de aceite, y una hojaldre, y las puso sobre el sebo y sobre la espaldilla derecha; ");
INSERT INTO spav1602p_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Y púsolo todo en las manos de Aarón, y en las manos de sus hijos, e hízolo mecer: ofrenda mecida delante del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Después tomó aquellas cosas Moisés de las manos de ellos, e hízolas arder en el altar sobre la ofrenda quemada: las consagraciones en olor de suavidad, ofrenda hecha por fuego al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Y tomó Moisés el pecho, y meciólo, ofrenda mecida delante del SEÑOR: del carnero de las consagraciones aquella fue la parte de Moisés; como el SEÑOR lo había mandado a Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Luego tomó Moisés del acei­te de la unción, y de la sangre que estaba sobre el altar, y roció sobre Aarón, y sobre sus vestidu­ras, sobre sus hijos, y sobre las vestiduras de sus hijos con él; y santificó a Aarón, y sus vestiduras, y a sus hijos, y las vestiduras de sus hijos con él. ");
INSERT INTO spav1602p_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Y dijo Moisés a Aarón y a sus hijos: Comed la carne a la puerta del tabernáculo de la congrega­ción; y comedla allí con el pan que está en el canastillo de las consagraciones, según yo he mandado, diciendo: Aarón y sus hijos la comerán. ");
INSERT INTO spav1602p_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Y lo que sobrare de la carne y del pan, habéis de quemarlo al fuego. ");
INSERT INTO spav1602p_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","De la puerta del tabernáculo de la congregación no saldréis en siete días, hasta el día que se cumplieren los días de vuestras consagraciones: porque por siete días seréis consagrados. ");
INSERT INTO spav1602p_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","De la manera que hoy se ha hecho, mandó hacer el SEÑOR para expiaros. ");
INSERT INTO spav1602p_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","A la puerta, pues, del taberná­culo de la congregación estaréis día y noche por siete días, y guar­daréis la ordenanza delante del SEÑOR, para que no muráis; porque así me ha sido mandado. ");
INSERT INTO spav1602p_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Y Aarón y sus hijos hicieron todas las cosas que mandó el SEÑOR por medio de Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Y SUCEDIÓ en el día octavo, que Moisés llamó a Aarón y a sus hijos, y a los ancianos de Israel; ");
INSERT INTO spav1602p_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Y dijo a Aarón: Toma un becerro para una ofrenda por el pecado, y un carnero para una ofrenda quemada, sin defecto, y ofrécelos delante del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Y a los hijos de Israel hablarás, diciendo: Tomad un macho cabrío para expiación, y un bece­rro y un cordero ambos de un año, sin tacha, para ofrenda quemada; ");
INSERT INTO spav1602p_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Asimismo un buey y un carne­ro para sacrificios de paz, que inmoléis delante del SEÑOR; y un presente amasado con aceite: porque el SEÑOR se aparecerá hoy a vosotros. ");
INSERT INTO spav1602p_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Y llevaron lo que mandó Moisés delante del tabernáculo de la congregación, y llegóse toda la congregación, y pusiéron­se delante del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Entonces Moisés dijo: Esto es lo que mandó el SEÑOR; hacedlo, y la gloria del SEÑOR se os aparecerá. ");
INSERT INTO spav1602p_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Y dijo Moisés a Aarón: Llégate al altar, y haz tu expiación, y tu ofrenda quemada, y haz la reconcilia­ción por ti y por el pueblo: haz también la ofrenda del pueblo, y haz la reconciliación por ellos; como ha mandado el SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Entonces llegóse Aarón al altar; y degolló su becerro de la expiación que era por él. ");
INSERT INTO spav1602p_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Y los hijos de Aarón le trajeron la sangre; y él mojó su dedo en la sangre, y la puso sobre los cuernos del altar, y derramó la demás sangre al pie del altar; ");
INSERT INTO spav1602p_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Y el sebo y riñones y redaño del hígado, de la expiación, hízo­los arder sobre el altar; como el SEÑOR lo había mandado a Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Mas la carne y el cuero los quemó al fuego fuera del campamento. ");
INSERT INTO spav1602p_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Y degolló la ofrenda quemada, y los hijos de Aarón le presentaron la sangre, la cual roció él alrededor sobre el altar. ");
INSERT INTO spav1602p_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Y presentáronle la ofrenda quemada, a trozos, y la cabeza; e hízolos quemar sobre el altar. ");
INSERT INTO spav1602p_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Y lavó los intestinos y las piernas, y quemólos sobre la ofrenda quemada en el altar. ");
INSERT INTO spav1602p_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Y ofreció la ofrenda del pueblo, y tomó el macho cabrío que era la ofrenda para el pecado del pueblo, y degollólo, y lo ofre­ció por el pecado como el prime­ro. ");
INSERT INTO spav1602p_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Y ofreció la ofrenda quemada, e hizo según la manera. ");
INSERT INTO spav1602p_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Y ofreció la ofrenda, e hinchió de él su mano, y lo hizo quemar sobre el altar, además del sacrificio quemado de la mañana. ");
INSERT INTO spav1602p_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Degolló también el buey y el carnero para sacrificio de ofrendas de paz, que era para el pueblo: y los hijos de Aarón le presentaron la sangre, la cual roció él sobre el altar alrededor, ");
INSERT INTO spav1602p_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Y los sebos del buey; y del carnero la cola con lo que cubre las entrañas, y los riñones, y el redaño sobre el hígado: ");
INSERT INTO spav1602p_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Y pusieron los sebos sobre los pechos, y él quemó los sebos sobre el altar: ");
INSERT INTO spav1602p_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Y los pechos, con la espaldilla derecha, meciólos Aarón por ofrenda mecida delan­te del SEÑOR; como el SEÑOR lo había mandado a Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Después alzó Aarón sus manos hacia el pueblo y bendíjo­los: y descendió de hacer la expiación, y la ofrenda quemada, y las ofrendas de paz. ");
INSERT INTO spav1602p_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Y entraron Moisés y Aarón en el tabernáculo de la congrega­ción; y salieron, y bendijeron al pueblo: y la gloria del SEÑOR se apareció a todo el pueblo. ");
INSERT INTO spav1602p_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Y salió fuego de delante del SEÑOR, y consumió la ofrenda quemada y los sebos sobre el altar; y cuando todo el pueblo lo vio, alaba­ron, y cayeron sobre sus rostros. ");
INSERT INTO spav1602p_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Y LOS hijos de Aarón, Nadab y Abiú, tomaron cada uno su incensario, y pusieron fuego en ellos, sobre el cual pusieron incienso, y ofrecieron delante del SEÑOR fuego extraño, que él no les mandó. ");
INSERT INTO spav1602p_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Y salió fuego de delante del SEÑOR que los devoró, y murie­ron delante del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Entonces dijo Moisés a Aarón: Esto es lo que habló el SEÑOR, diciendo: Y yo seré santificado en los que se acercan a mí, y en presencia de todo el pueblo seré glorificado. Y Aarón calló. ");
INSERT INTO spav1602p_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Y llamó Moisés a Misael, y a Elzafán, hijos de Uziel, tío de Aarón, y díjoles: Acercaos y sacad a vuestros hermanos de delante del santuario fuera del campo. ");
INSERT INTO spav1602p_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Y ellos se acercaron, y sacáronlos con sus túnicas fuera del campo, como dijo Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Y Moisés dijo a Aarón, y a Eleazar y a Itamar, sus hijos: No descubráis vuestras cabezas, ni rasguéis vuestras vestiduras, porque no muráis, ni se levante la ira sobre toda la congregación: pero deje que vuestros hermanos, toda la casa de Israel, lamenten el incendio que el SEÑOR ha hecho. ");
INSERT INTO spav1602p_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Ni saldréis de la puerta del tabernáculo de la congregación, porque moriréis; por cuanto el aceite de la unción del SEÑOR está sobre vosotros. Y ellos hicie­ron conforme a la palabra de Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Y el SEÑOR habló a Aarón, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","Tú, y tus hijos contigo, no beberéis vino ni bebida fuerte, cuando hubiereis de entrar en el taberná­culo de la congregación, porque no muráis: esto será estatuto perpetuo por vuestras generaciones; ");
INSERT INTO spav1602p_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Y para poder discernir entre lo santo y lo profano, y entre lo inmundo y lo limpio; ");
INSERT INTO spav1602p_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Y para enseñar a los hijos de Israel todos los estatutos que el SEÑOR les ha dicho por medio de Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Y Moisés dijo a Aarón, y a Eleazar y a Itamar, sus hijos que habían quedado: Tomad la ofren­da que queda de las ofrendas hechas por fuego al SEÑOR, y comedla sin levadura junto al altar, porque es cosa muy santa. ");
INSERT INTO spav1602p_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Y la comeréis en el lugar santo: porque esto es fuero para ti, y fuero para tus hijos, de las ofrendas hechas por fuego al SEÑOR, pues que así me ha sido mandado. ");
INSERT INTO spav1602p_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Comeréis asimismo en lugar limpio, tú y tus hijos y tus hijas contigo, el pecho de la mecida, y la espaldilla elevada, porque estos serán por fuero para tí, y fuero para tus hijos, todos son dados de los sacrificios de ofrendas de paz de los hijos de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","La espalda elevada y el pecho de la mecida traerán con las ofrendas hechas de fuego de la grosura, para mecerla para una ofrenda mecida delante del SEÑOR; y será para tí, y para tus hijos contigo, como estatuto para siempre; como el SEÑOR ha mandado. ");
INSERT INTO spav1602p_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Y Moisés buscó diligentemente el macho cabrío de la expiación, y hallóse que era quemado: y enojóse con­tra Eleazar e Itamar, los hijos de Aarón que habían quedado vivos, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","¿Por qué no comisteis la expiación en el lugar santo? por­que es muy santa, y dióla Dios a vosotros para llevar la iniquidad de la congregación, para que sean reconciliados delante del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","He aquí, su sangre no fue metida dentro del lugar santo: habíais de comerla en el lugar santo, como yo mandé. ");
INSERT INTO spav1602p_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Y respondió Aarón a Moisés: He aquí hoy han ofrecido su expiación y su ofrenda quemada delan­te del SEÑOR: pero me han acontecido estas cosas: pues si comiera yo hoy de la expiación, ¿Hubiera sido acepto al SEÑOR? ");
INSERT INTO spav1602p_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Y cuando Moisés oyó esto, estuvo contento. ");
INSERT INTO spav1602p_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Y HABLÓ el SEÑOR a Moisés y a Aarón diciéndoles: ");
INSERT INTO spav1602p_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","Hablad a los hijos de Israel, diciendo: Éstos son los animales que comeréis de todos los anima­les que están sobre la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","De entre los animales, todo el de pezuña, y que tiene las pezu­ñas hendidas, y que rumia, éste comeréis. ");
INSERT INTO spav1602p_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Éstos sin embargo no comeréis de los que rumian y de los que tie­nen pezuña: el camello, porque rumia mas no tiene pezuña hen­dida, habéis de tenerlo por inmundo; ");
INSERT INTO spav1602p_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","También el conejo, porque rumia, mas no tiene pezuña, ten­dréislo por inmundo; ");
INSERT INTO spav1602p_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Asimismo la liebre, porque rumia, mas no tiene pezuña, ten­dréisla por inmunda; ");
INSERT INTO spav1602p_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","También el puerco, porque tiene pezuñas, y es de pezuñas hendidas, mas no rumia, ten­dréislo por inmundo. ");
INSERT INTO spav1602p_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","De la carne de ellos no come­réis, ni tocaréis su cuerpo muer­to: tendréislos por inmundos. ");
INSERT INTO spav1602p_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Esto comeréis de todas las cosas que están en las aguas: todas las cosas que tienen aletas y escamas en las aguas del mar, y en los ríos, aquellas comeréis; ");
INSERT INTO spav1602p_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Y todas las cosas que no tienen aletas ni escamas en el mar y en los ríos, así de todo que se mueve en las aguas, y de toda cosa viviente que está en las aguas, las tendréis en abominación. ");
INSERT INTO spav1602p_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Os serán aún en abomina­ción: de su carne no comeréis, y abominaréis sus cuerpos muer­tos. ");
INSERT INTO spav1602p_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Todo lo que no tuviere aletas y escamas en las aguas, tendréis­lo en abominación. ");
INSERT INTO spav1602p_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Y éstas son las que tendréis en abominación entre las aves; no se comerán, son abominación: el águila, el quebrantahuesos, el esmerejón, ");
INSERT INTO spav1602p_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","El buitre, y el milano según su género; ");
INSERT INTO spav1602p_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","Todo cuervo según su género; ");
INSERT INTO spav1602p_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","El búho, y el halcón nocturno, y el cuclillo, y el gavilán según su género; ");
INSERT INTO spav1602p_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","Y el mochuelo, y el cormorán, y el búho real, ");
INSERT INTO spav1602p_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","Y el cisne, y el pelícano, y el alimoche, ");
INSERT INTO spav1602p_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","Y la cigüeña, la garza según su género, y el ave fría, y el murciélago. ");
INSERT INTO spav1602p_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Todo lo que vuele y se arrastre sobre cuatro, os será una abominación. ");
INSERT INTO spav1602p_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Pero esto comeréis de todo lo que vuele y se arrastre sobre cuatro, que tenga piernas sobre sus pies para saltar con ellas sobre la tierra; ");
INSERT INTO spav1602p_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Éstos comeréis de ellos: la langosta según su género, y el langostín según su género, y el escarabajo según su género, y el saltamonte según su género. ");
INSERT INTO spav1602p_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Mas las otras cosas volantes que se arrastran, que tienen cuatro pies, tendréis en abominación. ");
INSERT INTO spav1602p_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Y por estas cosas seréis inmun­dos: cualquiera que tocare a sus cuerpos muertos, será inmundo hasta la tarde: ");
INSERT INTO spav1602p_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Y cualquiera que llevare algo de sus cuerpos muertos, lavará sus vestiduras, y será inmundo hasta la tarde. ");
INSERT INTO spav1602p_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Todo animal de pezuña, pero que no tiene pezuña hendida, ni rumia, tendréis por inmundo: cualquiera que los tocare será inmundo. ");
INSERT INTO spav1602p_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Y de todos los animales que andan a cuatro pies, tendréis por inmundo cualquiera que ande sobre sus patas: cualquiera que tocare sus cuerpos muertos, será inmundo hasta la tarde. ");
INSERT INTO spav1602p_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Y el que llevare sus cuerpos muertos, lavará sus vestiduras, y será inmundo hasta la tarde: habéis de tenerlos por inmundos. ");
INSERT INTO spav1602p_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Y estos tendréis por inmundos de las criaturas que se arrastren sobre la tierra: la comadreja, y el ratón, y la tortuga según su género, ");
INSERT INTO spav1602p_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","Y el hurón, y el camaleón, y el lagarto, y el caracol, y el topo. ");
INSERT INTO spav1602p_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Éstos tendréis por inmundos de todos los que andan arrastrando: cualquiera que los tocare, cuando estuvieren muertos, será inmundo hasta la tarde. ");
INSERT INTO spav1602p_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Y todo aquello sobre que cayere alguno de ellos después de muertos, será inmundo; así vaso de madera, como vestidura, o piel, o saco, cualquier instrumen­to con que se hace obra, será metido en agua, y será inmundo hasta la tarde, y así será limpio. ");
INSERT INTO spav1602p_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Y toda vasija de barro dentro de la cual cayere alguno de ellos, todo lo que estuviere en ella será inmundo, y quebraréis la vasija: ");
INSERT INTO spav1602p_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Toda vianda que se come, sobre la cual viniere el agua de tales vasijas, será inmunda: y toda bebida que se bebiere, será en todas esas vasijas inmunda: ");
INSERT INTO spav1602p_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Y todo aquello sobre que cayere algo del cuerpo muerto de ellos, será inmundo: sea el horno u hornillos se derribarán; son inmundos, y por inmundos los tendréis. ");
INSERT INTO spav1602p_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Sin embargo, una fuente o una cister­na donde se recogen aguas, serán limpias: pero lo que hubiere toca­do en sus cuerpos muertos será inmundo. ");
INSERT INTO spav1602p_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Y si cayere algo de sus cuerpos muertos sobre alguna simiente que se haya de sembrar, será lim­pia. ");
INSERT INTO spav1602p_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Mas si se hubiere puesto agua en la simiente, y cayere algo de sus cuerpos muertos sobre ella, ten­dréisla por inmunda. ");
INSERT INTO spav1602p_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Y si algún animal que tuvie­reis para comer se muriere, el que tocare su cuerpo muerto será inmundo hasta la tarde: ");
INSERT INTO spav1602p_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Y el que comiere de su cuerpo muerto, lavará sus vestiduras, y será inmundo hasta la tarde: asi­mismo el que sacare su cuerpo muerto, lavará sus vestiduras, y será inmundo hasta la tarde. ");
INSERT INTO spav1602p_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Y toda criatura que va arrastran­do sobre la tierra, es abomina­ción; no se comerá. ");
INSERT INTO spav1602p_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Todo lo que va sobre el vientre, y todo lo que anda sobre cuatro o más pies, de todas criaturas que se arrastran sobre la tierra, no las comeréis, porque son una abominación. ");
INSERT INTO spav1602p_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","No ensuciéis vuestras perso­nas con ninguna criatura que se arrastra, ni os contaminéis con ellos, ni seáis inmundos por ellos. ");
INSERT INTO spav1602p_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Porque yo soy el SEÑOR vuestro Dios, vosotros por tanto os santificaréis, y seréis santos, porque yo soy santo: así que no ensuciéis vuestras per­sonas con ningún reptil que andu­viere arrastrando sobre la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Porque yo soy el SEÑOR, que os hago subir de la tierra de Egipto para ser tu Dios: seréis pues santos, porque yo soy santo. ");
INSERT INTO spav1602p_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Ésta es la ley de los animales y de las aves, y de todo ser viviente que se mueve en las aguas, y de todo animal que anda arrastrando sobre la tierra; ");
INSERT INTO spav1602p_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Para hacer diferencia entre inmundo y limpio, y entre los animales que se pueden comer y los animales que no se pueden comer. ");
INSERT INTO spav1602p_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Y HABLÓ el SEÑOR a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Habla a los hijos de Israel, diciendo: Si una mujer concibiere y pariere, y naciere varón, será inmun­da siete días; conforme a los días que está separada por su mens­truo, será inmunda. ");
INSERT INTO spav1602p_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Y al octavo día circuncidará la carne del prepucio de él. ");
INSERT INTO spav1602p_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Mas ella permanecerá treinta y tres días en la sangre de su purificación: ninguna cosa santa toca­rá, ni vendrá al santuario, hasta que sean cumplidos los días de su purgación. ");
INSERT INTO spav1602p_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Y si pariere hembra será inmunda dos semanas, conforme a su separación, y sesenta y seis días estará purificándose de su sangre. ");
INSERT INTO spav1602p_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Y cuando los días de su purificación fueren cumplidos, por hijo o por hija, traerá un cordero de un año para ofrenda quemada, y un palo­mino o una tórtola para expia­ción, a la puerta del tabernáculo de la congregación, al sacerdote: ");
INSERT INTO spav1602p_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Y él ofrecerá delante del SEÑOR, y hará expiación por ella, y será limpia del flujo de su sangre. Ésta es la ley de la que pariere varón o hembra. ");
INSERT INTO spav1602p_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Y si no puede traer un cordero, toma­rá entonces dos tórtolas o dos palominos, uno para ofrenda quemada, y otro para expiación: y el sacer­dote hará expiación por ella, y será limpia. ");
INSERT INTO spav1602p_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Y HABLÓ el SEÑOR a Moisés y a Aarón, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Cuando el hombre tuviere en la piel de su carne hinchazón, o pos­tilla, o mancha blanca, y hubiere en la piel de su carne como llaga de lepra, será traído a Aarón el sacerdote, o a uno de los sacerdo­tes sus hijos: ");
INSERT INTO spav1602p_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Y el sacerdote mirará la llaga en la piel de la carne: y cuando el pelo en la llaga se ha vuelto blanco, y pareciere la llaga más hundida que la piel de la carne, llaga de lepra es; y el sacerdote le recono­cerá, y le pronunciará inmundo. ");
INSERT INTO spav1602p_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Y si en la piel de su carne hubiere mancha blanca, pero no pareciere más hundida que la piel, ni su pelo se hubiere vuelto blan­co, entonces el sacerdote ence­rrará al llagado por siete días; ");
INSERT INTO spav1602p_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Y al séptimo día el sacerdote lo mirará; y he aquí, si la llaga a su parecer se hubiere estancado, no habién­dose extendido en la piel, enton­ces el sacerdote le volverá a encerrar por otros siete días. ");
INSERT INTO spav1602p_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Y al séptimo día el sacerdote le reconocerá de nuevo; y si parece haberse oscurecido la llaga, y que no ha cundido en la piel, entonces el sacerdote le pronunciará limpio: era postilla; y lavará sus vestiduras, y será limpio. ");
INSERT INTO spav1602p_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Mas si hubiere ido creciendo la postilla en la piel, después que fue mostrado al sacerdote para ser limpio, será visto otra vez del sacerdote: ");
INSERT INTO spav1602p_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Y si reconociéndolo el sacerdo­te, ve que la postilla ha crecido en la piel, el sacerdote le pronunciará inmundo: es lepra. ");
INSERT INTO spav1602p_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Cuando hubiere llaga de lepra en el hombre, será traído al sacerdote; ");
INSERT INTO spav1602p_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Y el sacerdote mirará, y si pareciere tumor blanco en la piel, el cual haya mudado el color del pelo a blanco, y se descubre asimismo la carne viva, ");
INSERT INTO spav1602p_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","Lepra es envejecida en la piel de su carne; y le pronunciará inmun­do el sacerdote, y no le encerrará, porque es inmundo. ");
INSERT INTO spav1602p_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Mas si brotare la lepra cun­diendo por el cutis, y ella cubrie­re toda la piel del llagado desde su cabeza hasta sus pies, a toda vista de ojos del sacerdote; ");
INSERT INTO spav1602p_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","Entonces el sacerdote le reco­nocerá; y he aquí, si la lepra hubiere cubierto toda su carne, le pronunciará limpio al llagado: hase vuelto toda ella blanca; y él es limpio. ");
INSERT INTO spav1602p_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Mas el día que apareciere en él la carne viva, será inmundo. ");
INSERT INTO spav1602p_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Y el sacerdote mirará la carne viva, y le pronunciará inmundo. Es inmunda la carne viva: es lepra. ");
INSERT INTO spav1602p_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Mas cuando la carne viva se mudare y volviere blanca, enton­ces vendrá al sacerdote; ");
INSERT INTO spav1602p_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Y el sacerdote mirará, y he aquí, si la llaga se hubiere vuelto blanca, el sacerdote le pronunciará limpio al que tenía la llaga, y será limpio. ");
INSERT INTO spav1602p_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Y cuando en la carne, aún en su piel, hubiere llaga, y se sanare, ");
INSERT INTO spav1602p_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","Y sucediere en el lugar de la llaga tumor blanco, o man­cha blanca embermejecida, será mostrado al sacerdote: ");
INSERT INTO spav1602p_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Y cuando el sacerdote lo mirare, he aquí, si está más baja que su piel y su pelo se hubiere vuelto blanco, el sacerdote le pronunciará inmundo: es llaga de lepra que se originó en la llaga. ");
INSERT INTO spav1602p_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Y si el sacerdote la considera­re, y no pareciere en ella pelo blanco, ni estuviere más baja que la piel, sino oscura, entonces el sacerdote lo encerrará por siete días: ");
INSERT INTO spav1602p_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Y si se fuere extendiendo por la piel, entonces el sacerdote le pronunciará inmundo: es llaga. ");
INSERT INTO spav1602p_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Pero si la mancha blanca se estuviere en su lugar, que no haya cundido, es la costra de la llaga; y el sacerdote le pronunciará limpio. ");
INSERT INTO spav1602p_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Asimismo cuando la carne tuviere en su piel quemadura de fuego, y hubiere en lo sanado del fuego mancha blanquecina, ber­mejiza o blanca, ");
INSERT INTO spav1602p_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","El sacerdote la mirará; y he aquí, si el pelo se hubiere vuelto blanco en la mancha, y pareciere estar más hundida que la piel, es lepra que salió en la quemadura; y el sacer­dote le pronunciará inmundo, por ser llaga de lepra. ");
INSERT INTO spav1602p_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Mas si el sacerdote la mirare, y he aquí, no pareciere en la mancha pelo blanco, ni estuviere más baja que la piel, sino que está oscura, le encerrará el sacerdote por siete días; ");
INSERT INTO spav1602p_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Y al séptimo día el sacerdote la reconocerá: y si se hubiere ido extendiendo por la piel, el sacer­dote le pronunciará inmundo: es llaga de lepra. ");
INSERT INTO spav1602p_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Y si la mancha se estu­viere en su lugar, y no se hubiere extendido en la piel, sino que está oscura, hinchazón es de la quemadura: el sacerdote le pronunciará limpio; que señal de la que­madura es. ");
INSERT INTO spav1602p_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Si un hombre o una mujer tuviere una llaga sobre la cabeza o en la barba, ");
INSERT INTO spav1602p_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","Entonces el sacerdote mirará la llaga; y he aquí, si pareciere estar más profunda que la piel, y el pelo en ella fuera amarillo y adelgazado, entonces el sacerdote le pronunciará inmundo: es tiña, es lepra de la cabeza o de la barba. ");
INSERT INTO spav1602p_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Y si el sacerdote mirare la llaga de la tiña, y he aquí, no pareciere estar más profun­da que la piel, ni fuere en ella pelo negro, el sacerdote encerrará al llagado de la tiña por siete días: ");
INSERT INTO spav1602p_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Y al séptimo día el sacerdote mirará la llaga: y he aquí, si la tiña no pareciere haberse extendido, ni hubiere en ella pelo amarillo, ni pareciere la tiña más profunda que la piel, ");
INSERT INTO spav1602p_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","Entonces lo trasquilarán, mas no trasquilarán el lugar de la tiña: y encerrará el sacerdote al que tiene la tiña por otros siete días. ");
INSERT INTO spav1602p_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Y al séptimo día mirará el sacerdote la tiña; y he aquí, si la tiña no hubiere cundido en la piel, ni pareciere estar más profunda que la piel, el sacerdote le pronunciará limpio; y lavará sus vestiduras, y será limpio. ");
INSERT INTO spav1602p_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Pero si la tiña se hubiere ido extendiendo en la piel des­pués de su limpieza, ");
INSERT INTO spav1602p_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","Entonces el sacerdote la mira­rá; y he aquí, si la tiña hubiere cundido en la piel, no busque el sacerdote el pelo amarillo, es inmundo. ");
INSERT INTO spav1602p_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Mas si le pareciere que la tiña está detenida, y que ha salido en ella el pelo negro, la tiña está sanada; él está limpio, y el sacerdote le pronunciará limpio. ");
INSERT INTO spav1602p_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Asimismo el hombre o mujer, cuando en la piel de su carne tuviere manchas, aún manchas blan­cas, ");
INSERT INTO spav1602p_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","El sacerdote mirará: y he aquí, si en la piel de su carne parecieren man­chas blancas algo oscurecidas, es empeine que brotó en la piel, está limpia la persona. ");
INSERT INTO spav1602p_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Y el hombre cuyo pelo ha caído, él es calvo; pero limpio es. ");
INSERT INTO spav1602p_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Y él que tiene su pelo caído de la parte de su cabeza hacia su faz, calvo por delante es: pero limpio es. ");
INSERT INTO spav1602p_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Mas cuando en la calva o en la antecalva hubiere llaga blanca rojiza, lepra es que brota en su calva o en su antecalva. ");
INSERT INTO spav1602p_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Entonces el sacerdote lo mira­rá, y he aquí, si pareciere la hinchazón de la llaga blanca rojiza en su calva o en su antecalva, como el pare­cer de la lepra de la piel de la carne, ");
INSERT INTO spav1602p_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","Leproso es, es inmundo; el sacerdote le pronunciará muy inmundo; en su cabeza tiene su llaga. ");
INSERT INTO spav1602p_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Y el leproso en quien hubiere llaga, sus vestiduras serán deshe­chas y su cabeza descubierta, y embozado proclamará: ¡Inmundo! ¡inmundo! ");
INSERT INTO spav1602p_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Todos los días que la llaga estuviere en él, será inmundo; estará impuro: habitará solo; fuera del real será su morada. ");
INSERT INTO spav1602p_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Y cuando en la vestidura hubie­re plaga de lepra, sea en vestidura de lana, o en vestidura de lino; ");
INSERT INTO spav1602p_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","O en estambre o en trama, de lino o de lana, o en piel, o en cualquiera obra de piel; ");
INSERT INTO spav1602p_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","Y si la plaga sea verde, o bermeja, en vestidura o en piel, o en estambre, o en trama, o en cualquiera obra de piel; plaga es de lepra, y se ha de mostrar al sacerdote. ");
INSERT INTO spav1602p_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Y el sacerdote mirará la plaga, y encerrará lo que es plagado por siete días. ");
INSERT INTO spav1602p_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Y al séptimo día mirará la plaga: y si hubiere cundido la plaga en la vestidura, o estambre, o en la trama, o en piel, o en cual­quiera obra que se hace de pieles, lepra roedora es la plaga; inmun­da será. ");
INSERT INTO spav1602p_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Por lo cual, él quemará la vestidura, o estambre o trama, de lana o de lino, o cualquiera obra de pieles en que hubiere tal plaga; porque lepra roedora es; al fuego será quemada. ");
INSERT INTO spav1602p_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Y si el sacerdote mirare, y he aquí, no pareciere que la plaga se haya extendido en la vestidura, o estam­bre, o en la trama, o en cualquie­ra obra de pieles; ");
INSERT INTO spav1602p_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","Entonces el sacerdote manda­rá que laven la cosa donde está la plaga, y la encerrará otra vez por siete días. ");
INSERT INTO spav1602p_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Y el sacerdote mirará a la plaga, después que fuere lavada y, he aquí, si la plaga no ha mudado su color, y la plaga no haya crecido, inmundo es; la quemarás en fuego; es corrosión penetrante, esté lo raído por dentro o por fuera. ");
INSERT INTO spav1602p_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Mas si el sacerdote la viere, y he aquí, pareciere que la plaga se ha oscu­recido después que fue lavada, la cortará de la vestidura, o de la piel, o del estambre, o de la trama. ");
INSERT INTO spav1602p_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Y si apareciere más en la vestidura, o estambre, o trama, o en cualquiera cosa de pieles, es una plaga que extiende, quemarás al fuego aquello donde estuviere la plaga. ");
INSERT INTO spav1602p_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Y la vestidura, o estam­bre, o trama, o cualquiera cosa de piel que lavares, y que se le qui­tare la plaga, lavarse ha segunda vez, y entonces será limpia. ");
INSERT INTO spav1602p_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Ésta es la ley de la plaga de la lepra de la vestidura de lana o de lino, o del estambre, o de la trama, o de cualquiera cosa de piel, para que sea dada por limpia o por inmun­da. ");
INSERT INTO spav1602p_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Y HABLÓ el SEÑOR a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","Ésta será la ley del leproso en el día de su limpieza: Será traído al sacerdote: ");
INSERT INTO spav1602p_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Y el sacerdote saldrá fuera del campamento; y he aquí, si está sana la plaga de la lepra del leproso, ");
INSERT INTO spav1602p_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","Entonces el sacerdote mandará luego que se tomen para el que será puri­ficado dos aves vivas y limpias, y palo de cedro, y grana, e hiso­po; ");
INSERT INTO spav1602p_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Y mandará el sacerdote matar el ave en un vaso de barro sobre aguas corrientes; ");
INSERT INTO spav1602p_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Después tomará el ave viva, y el palo de cedro, y la grana, y el hisopo, y lo mojará con el ave viva en la sangre del ave muerta sobre las aguas vivas: ");
INSERT INTO spav1602p_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Y rociará siete veces sobre el que será purificado de la lepra, y le pronunciará limpio; y soltará el ave viva sobre la faz del campo. ");
INSERT INTO spav1602p_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Y el que será purificado lavará sus vestiduras, y raerá todos sus pelos, y se ha de lavar con agua, y será limpio: y después entrará en el campamento, y morará fuera de su tienda siete días. ");
INSERT INTO spav1602p_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Pero será, que al séptimo día raerá todos sus pelos, su cabeza, y su barba, y las cejas de sus ojos; finalmente, raerá todo su pelo, y lavará sus vestiduras, y lavará su carne en agua, y será limpio. ");
INSERT INTO spav1602p_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Y el día octavo tomará dos corderos sin defecto, y una cor­dera de un año sin tacha; y tres décimas de flor de harina para presente amasada con aceite, y un log de aceite. ");
INSERT INTO spav1602p_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Y el sacerdote que le purifica presentará con aquellas cosas al que se ha de limpiar delante del SEÑOR, a la puerta del taberná­culo de la congregación: ");
INSERT INTO spav1602p_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Y tomará el sacerdote un cordero, y lo ofrecerá para una ofrenda por el pecado, y el log de aceite, y los mecerá como ofrenda mecida delante del SEÑOR: ");
INSERT INTO spav1602p_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Y degollará el cordero en el lugar donde degüellan la ofrenda por el pecado y la ofrenda quemada, en el lugar santo: porque como la ofrenda por el pecado, así también la ofrenda por la culpa es del sacerdote: es cosa muy sagrada. ");
INSERT INTO spav1602p_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Y tomará el sacerdote de la sangre de la ofrenda por la culpa, y la pondrá el sacerdote sobre la ternilla de la oreja derecha del que ha de ser purificado, y sobre el pulgar de su mano derecha, y sobre el pulgar de su pie derecho. ");
INSERT INTO spav1602p_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Y tomará el sacerdo­te del log de aceite, y lo echará sobre la palma de su mano izquierda: ");
INSERT INTO spav1602p_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Y mojará su dedo derecho en el aceite que tiene en su mano izquierda, y esparcirá del aceite con su dedo siete veces delante del SEÑOR: ");
INSERT INTO spav1602p_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Y de lo que quedare del aceite que tiene en su mano, pondrá el sacerdote sobre la ternilla de la oreja derecha del que ha de ser purificado, y sobre el pulgar de su mano derecha, y sobre el pulgar de su pie derecho, sobre la sangre de la expiación por la culpa: ");
INSERT INTO spav1602p_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Y lo que quedare del aceite que tiene en su mano, pondrá sobre la cabeza del que ha de ser purificado: y hará el sacerdote expiación por él delante del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Ofrecerá luego el sacerdote el sacrificio por el pecado, y hará expiación por el que se ha de purificar de su inmundicia, y después degollará la ofrenda quemada: ");
INSERT INTO spav1602p_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Y ofrecerá el sacerdote la ofrenda quemada y el presente sobre el altar. Así hará el sacerdote expia­ción por él, y será limpio. ");
INSERT INTO spav1602p_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Mas si fuere pobre, que no alcanzare su mano a tanto, enton­ces tomará un cordero para ser ofrecido como ofrenda elevada por la culpa, para reconciliarse, y una décima de flor de harina amasada con aceite para presen­te, y un log de aceite; ");
INSERT INTO spav1602p_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Y dos tórtolas, o dos palomi­nos, lo que alcanzare su mano: y el uno será para expiación por el pecado, y el otro para ofrenda quemada; ");
INSERT INTO spav1602p_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Las cuales cosas traerá al octavo día de su purificación al sacerdote, a la puerta del taberná­culo de la congregación delante del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Y el sacerdote tomará el cordero de la expiación por la culpa, y el log de aceite, y mecerálo el sacerdote como ofrenda mecida delante del SEÑOR; ");
INSERT INTO spav1602p_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Luego degollará el cordero de la culpa, y tomará el sacerdote de la sangre de la culpa, y pondrá sobre la ternilla de la oreja dere­cha del que ha de ser purificado, y sobre el pulgar de su mano derecha, y sobre el pulgar de su pie derecho. ");
INSERT INTO spav1602p_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Y el sacerdote echará del acei­te sobre la palma de su mano izquierda; ");
INSERT INTO spav1602p_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Y con su dedo derecho rocia­rá el sacerdote del aceite que tiene en su mano izquierda, siete veces delante del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","También pondrá el sacerdote del aceite que tiene en su mano sobre la ternilla de la oreja dere­cha del que ha de ser purificado, y sobre el pulgar de su mano derecha, y sobre el pulgar de su pie derecho, en el lugar de la sangre de la culpa. ");
INSERT INTO spav1602p_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Y lo que sobrare del aceite que el sacerdote tiene en su mano, pondrálo sobre la cabeza del que ha de ser purificado, para hacer expiación por él delante del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Y ofrecerá una de las tórtolas, o de los palominos, lo que alcanzare su mano: ");
INSERT INTO spav1602p_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Aún de lo que alcanzare su mano, en expiación por el peca­do, y el otro en ofrenda quemada, ade­más del presente: y hará el sacer­dote expiación por el que se ha de purificar, delante del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Ésta es la ley del que tiene plaga de lepra, cuya mano no alcanzare lo prescrito para su purificación. ");
INSERT INTO spav1602p_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Y habló el SEÑOR a Moisés y a Aarón, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","Cuando hubieres entrado en la tierra de Canaán, la cual yo os doy en posesión, y pusiere yo plaga de lepra en alguna casa de la tierra de vuestra posesión, ");
INSERT INTO spav1602p_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","Vendrá aquél cuya fuere la casa, y dará aviso al sacerdote, diciendo: Como plaga ha apare­cido en mi casa. ");
INSERT INTO spav1602p_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Entonces mandará el sacerdo­te, y despejarán la casa antes que el sacerdote entre a mirar la plaga, por que no sea contamina­do todo lo que estuviere en la casa: y después el sacerdote entrará a reconocer la casa: ");
INSERT INTO spav1602p_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Y mirará la plaga: y he aquí, si se vie­ren manchas en las paredes de la casa, cavernillas verdosas o rojas, las cuales parecieren más hundidas que la pared, ");
INSERT INTO spav1602p_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","Entonces el sacerdote saldrá de la casa a la puerta de ella, y cerrará la casa por siete días: ");
INSERT INTO spav1602p_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Y al séptimo día volverá el sacerdote, y mirará: y he aquí, si la plaga hubiere crecido en las paredes de la casa; ");
INSERT INTO spav1602p_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","Entonces mandará el sacerdo­te, y arrancarán las piedras en que estuviere la plaga, y las echa­rán fuera de la ciudad, en lugar inmundo: ");
INSERT INTO spav1602p_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Y hará descostrar la casa por dentro alrededor, y derramarán el polvo que descostraren fuera de la ciudad en lugar inmundo: ");
INSERT INTO spav1602p_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Y tomarán otras piedras, y las pondrán en lugar de las piedras quitadas; y tomarán otro barro, y encostrarán la casa. ");
INSERT INTO spav1602p_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Y si la plaga volviere a brotar en aquella casa, después que hizo arrancar las piedras, y descostrar la casa, y después que fue encostrada, ");
INSERT INTO spav1602p_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","Entonces el sacerdote entrará y mirará; y he aquí, si pareciere haberse extendido la plaga en la casa, lepra roedora está en la casa: inmunda es. ");
INSERT INTO spav1602p_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Y derribará la casa, sus piedras, y sus maderos, y toda la mezcla de la casa; y los sacará fuera de la ciudad a lugar inmundo. ");
INSERT INTO spav1602p_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Además, cualquiera que entrare en aquella casa todos los días que la mandó cerrar, será inmundo hasta la tarde. ");
INSERT INTO spav1602p_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Y el que durmiere en aquella casa, lavará sus vestiduras; tam­bién el que comiere en la casa, lavará sus vestiduras. ");
INSERT INTO spav1602p_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Mas si entrare el sacerdote y mirare, y he aquí, viere que la plaga no se ha extendido en la casa después que fue encostrada, el sacerdote pronunciará la casa limpia, porque la plaga ha sanado. ");
INSERT INTO spav1602p_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Entonces tomará para limpiar la casa dos aves, y palo de cedro, y grana, e hisopo: ");
INSERT INTO spav1602p_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Y degollará una de las aves en una vasija de barro sobre aguas vivas: ");
INSERT INTO spav1602p_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Y tomará el palo de cedro, y el hisopo, y la grana, y el ave viva, y mojarálos en la sangre del ave muerta y en las aguas vivas, y rociará la casa siete veces: ");
INSERT INTO spav1602p_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Y purificará la casa con la sangre del ave, y con las aguas vivas, y con el ave viva, y el palo de cedro, y el hiso­po, y la grana: ");
INSERT INTO spav1602p_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Pero soltará el ave viva fuera de la ciudad sobre la faz del campo. Así hará expiación por la casa, y será limpia. ");
INSERT INTO spav1602p_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Ésta es la ley acerca de toda plaga de lepra, y de tiña; ");
INSERT INTO spav1602p_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","Y de la lepra de la vestidura, y de una casa; ");
INSERT INTO spav1602p_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","Y acerca de la hinchazón, y de la postilla, y de la mancha blan­ca: ");
INSERT INTO spav1602p_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Para enseñar cuándo es inmundo, y cuándo es limpio. Ésta es la ley de la lepra. ");
INSERT INTO spav1602p_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Y HABLÓ el SEÑOR a Moisés y a Aarón, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","Hablad a los hijos de Israel, y decidles: Cuando algún hombre tiene flujo de su carne, por su flujo él es inmundo. ");
INSERT INTO spav1602p_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Y ésta será su inmundicia en su flujo; sea que su carne destiló por causa de su flujo, o que su carne se obstruyó a causa de su flujo, será su inmundicia. ");
INSERT INTO spav1602p_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Toda cama en que se acostare el que tuviere flujo, será inmun­da; y toda cosa sobre que se sen­tare, inmunda será. ");
INSERT INTO spav1602p_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Y cualquiera que tocare a su cama lavará sus vestiduras, lava­ráse también a sí mismo en agua, y será inmundo hasta la tarde. ");
INSERT INTO spav1602p_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Y el que se sentare sobre aque­llo en que se hubiere sentado el que tiene flujo, lavará sus vestiduras, se lavará también a sí mismo en agua, y será inmundo hasta la tarde. ");
INSERT INTO spav1602p_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Y el que tocare la carne del que tiene flujo, lavará sus vestiduras, y a sí mismo se lavará en agua, y será inmundo hasta la tarde. ");
INSERT INTO spav1602p_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Y si el que tiene flujo escupie­re sobre el limpio, éste lavará sus vestiduras, y después de haberse lavado en agua, será inmundo hasta la tarde. ");
INSERT INTO spav1602p_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Y toda montura sobre que cabalgare el que tuviere flujo, será inmundo. ");
INSERT INTO spav1602p_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Y cualquiera que tocare cual­quiera cosa que haya estado debajo de él, será inmundo hasta la tarde; y el que llevare cual­quiera cosa, lavará sus vestiduras, y después de lavarse en agua, será inmundo hasta la tarde. ");
INSERT INTO spav1602p_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Y todo aquel a quien tocare el que tiene flujo, y no lavare con agua sus manos, lavará sus vestiduras, y a sí mismo se lavará en agua, y será inmundo hasta la tarde. ");
INSERT INTO spav1602p_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Y la vasija de barro en que tocare el que tiene flujo, será quebrada; y toda vasija de made­ra será lavada en agua. ");
INSERT INTO spav1602p_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Y cuando se hubiere limpiado de su flujo el que tiene flujo, se ha de contar siete días desde su purificación, y lavará sus vestiduras, y lavará su carne en aguas corrientes, y será limpio. ");
INSERT INTO spav1602p_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Y el octavo día tomará dos tórtolas, o dos palominos, y ven­drá delante del SEÑOR a la puerta del tabernáculo de la con­gregación, y los dará al sacerdo­te: ");
INSERT INTO spav1602p_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Y harálos el sacerdote, el uno ofrenda por el pecado, y el otro ofrenda quemada: y le purificará el sacerdote de su flujo delante del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Y el hombre, cuando de él saliere derramamiento de semen, lavará en aguas toda su carne, y será inmundo hasta la tarde. ");
INSERT INTO spav1602p_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Y toda vestidura, o toda piel sobre la cual hubiere el derrama­miento del semen, lavaráse con agua, y será inmunda hasta la tarde. ");
INSERT INTO spav1602p_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Y la mujer también con quien el varón tuviera ayuntamiento de semen, ambos se lavarán con agua, y serán inmundos hasta la tarde. ");
INSERT INTO spav1602p_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Y cuando la mujer tuviere flujo de sangre, y su flujo fuere en su carne, siete días estará apartada; y cualquiera que la tocare, será inmundo hasta la tarde. ");
INSERT INTO spav1602p_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Y todo aquello sobre lo que ella se acostare durante su separa­ción, será inmundo: también todo aquello sobre lo que se senta­re, será inmundo. ");
INSERT INTO spav1602p_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Y cualquiera que tocare a su cama, lavará sus vestiduras, y des­pués de lavarse en agua, será inmundo hasta la tarde. ");
INSERT INTO spav1602p_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Y cualquiera que toca­re cualquier mueble sobre que ella se hubiere sentado, lavará sus vestiduras; lavaráse luego a sí mismo en agua, y será inmundo hasta la tarde. ");
INSERT INTO spav1602p_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Y si estuviere sobre su cama, o sobre la silla en que ella se hubie­re sentado, el que lo tocare será inmundo hasta la tarde. ");
INSERT INTO spav1602p_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Y si alguno durmiere con ella, y su menstruo fuere sobre él, será inmundo por siete días; y toda cama sobre que durmiere, será inmunda. ");
INSERT INTO spav1602p_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Y si una mujer tiene flujo de su sangre por muchos días fuera del tiempo de su separación, o si va más que su tiempo de su separación; todos los días de su flujo de su inmundicia serán los días de su separación: ella será inmunda. ");
INSERT INTO spav1602p_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Toda cama en que durmiere todo el tiempo de su flujo, le será como la cama de su separación; y todo mueble sobre que se senta­re, será inmundo, como la inmundicia de su separación. ");
INSERT INTO spav1602p_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Cualquiera que tocare esas cosas será inmundo; y lavará sus vestiduras, y a sí mismo se lavará en agua, y será inmundo hasta la tarde. ");
INSERT INTO spav1602p_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Pero cuando fuere libre de su flujo, se ha de contar siete días, y después será limpia. ");
INSERT INTO spav1602p_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Y el octavo día tomará consigo dos tórtolas, o dos palominos, y los traerá al sacerdote, a la puerta del tabernáculo de la con­gregación: ");
INSERT INTO spav1602p_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Y el sacerdote ofrecerá el uno para una ofrenda por el pecado, y el otro para una ofrenda quemada; y el sacerdote hará expiación por ella delante del SEÑOR por el flujo de su inmundicia. ");
INSERT INTO spav1602p_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Así apartaréis los hijos de Israel de sus inmundicias, a fin de que no mueran por sus inmun­dicias, ensuciando mi tabernácu­lo que está entre ellos. ");
INSERT INTO spav1602p_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Ésta es la ley del que tiene flujo, y del que sale derrama­miento de semen, viniendo a ser inmundo a causa de ello; ");
INSERT INTO spav1602p_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","Y de la que padece su cos­tumbre, y acerca del que tuviere flujo, sea varón o hembra, y del hombre que durmiere con mujer inmunda. ");
INSERT INTO spav1602p_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Y HABLÓ el SEÑOR a Moisés, después que murieron los dos hijos de Aarón, cuando ofrecieron delante del SEÑOR, y murieron; ");
INSERT INTO spav1602p_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Y el SEÑOR dijo a Moisés: Di a Aarón tu hermano, que no en todo tiempo entre en el lugar santo del velo adentro, delante del propiciatorio que está sobre el arca, para que no muera: porque yo apareceré en la nube sobre el propiciatorio. ");
INSERT INTO spav1602p_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Así entrará Aarón en el lugar santo: con un becerro por expiación, y un carnero en ofrenda quemada. ");
INSERT INTO spav1602p_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","La túnica santa de lino se ves­tirá, y sobre su carne tendrá pañetes de lino, y ceñiráse el cinto de lino; y con la mitra de lino se cubrirá: estas son las santas vestiduras: con ellas, después de lavar su carne con agua, se ha de vestir. ");
INSERT INTO spav1602p_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Y de la congregación de los hijos de Israel tomará dos machos de cabrío para una ofrenda por el pecado, y un carnero para una ofrenda quemada. ");
INSERT INTO spav1602p_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Y hará allegar Aarón el becerro de la ofrenda por el pecado, que es suyo, y hará la reconciliación por sí y por su casa. ");
INSERT INTO spav1602p_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Después tomará los dos machos de cabrío, y los presenta­rá delante del SEÑOR a la puer­ta del tabernáculo de la congre­gación. ");
INSERT INTO spav1602p_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Y echará suertes Aarón sobre los dos machos cabríos; una suerte por el SEÑOR, y la otra suerte por el macho cabrío de escapatoria. ");
INSERT INTO spav1602p_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Y Aarón hará allegar el macho cabrío sobre el cual cayere la suerte por el SEÑOR, y lo ofrecerá para una ofrenda por el pecado. ");
INSERT INTO spav1602p_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Pero el macho cabrío, sobre el cual cayere la suerte para ser el macho cabrío de escapatoria, lo presentará vivo delante del SEÑOR, para hacer expiación con él, para enviarlo como macho cabrío de escapatoria al desierto. ");
INSERT INTO spav1602p_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Y traerá Aarón el becerro de la ofrenda por el pecado, lo cual es para sí, y hará la reconciliación por sí y por su casa, y degollará en expiación el becerro que es suyo. ");
INSERT INTO spav1602p_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Y él tomará el incensario lleno de brasas de fuego, del altar de delante del SEÑOR, y sus puños llenos del perfume aromá­tico molido, y meterálo del velo adentro: ");
INSERT INTO spav1602p_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Y pondrá el perfume sobre el fuego delante del SEÑOR, y la nube del perfume cubrirá el propiciatorio que está sobre el testi­monio, para que no muera. ");
INSERT INTO spav1602p_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Tomará luego de la sangre del becerro, y la rociará con su dedo hacia el propiciatorio al lado oriental: hacia el propiciatorio rociará siete veces de la sangre con su dedo. ");
INSERT INTO spav1602p_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Entonces degollará el macho cabrío de la ofrenda por el pecado, que era del pueblo, y meterá la sangre de él del velo adentro; y hará de su sangre como hizo de la sangre del becerro, y rociará sobre el propiciatorio y delante del propiciatorio: ");
INSERT INTO spav1602p_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Y hará una expiación para el lugar santo, por la inmundicia de los hijos de Israel, y por sus transgresiones en todos sus pecados: de la misma manera hará también al taberná­culo de la congregación, el cual reside entre ellos en medio de sus inmundicias. ");
INSERT INTO spav1602p_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Y ningún hombre estará en el tabernáculo de la congregación cuando él entrare a hacer la expiación en el lugar santo, hasta que él salga, y haya hecho la reconciliación por sí, y por su casa, y por toda la congregación de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Y saldrá al altar que está delante del SEÑOR, y lo hará expiación; y tomará de la sangre del becerro, y de la sangre del macho cabrío, y pondrá sobre los cuer­nos del altar alrededor. ");
INSERT INTO spav1602p_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Y rociará sobre él de la sangre con su dedo siete veces, y lo lim­piará, y lo santificará de las inmundicias de los hijos de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Y cuando hubiere acabado de reconciliar el lugar santo, y el taberná­culo de la congregación, y el altar, hará llegar el macho cabrío vivo: ");
INSERT INTO spav1602p_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Y pondrá Aarón ambas manos suyas sobre la cabeza del macho cabrío vivo, y confesará sobre él todas las iniquidades de los hijos de Israel, y todas sus rebeliones, y todos sus pecados, poniéndolos así sobre la cabeza del macho cabrío, y lo enviará al desierto por mano de un hombre destina­do para esto. ");
INSERT INTO spav1602p_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Y aquel macho cabrío llevará sobre si todas las iniquidades de ellos a tierra inhabitada: y dejará ir el macho cabrío por el desier­to. ");
INSERT INTO spav1602p_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Después vendrá Aarón al tabernáculo de la congregación, y se desnudará las vestimentas de lino, que había vestido para entrar en el lugar santo, y pondrá­las allí. ");
INSERT INTO spav1602p_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Y lavará su carne con agua en el lugar santo, y después de ponerse sus vestiduras saldrá, y hará su ofrenda quemada, y la ofrenda quemada del pueblo, y hará expiación por sí y por el pueblo. ");
INSERT INTO spav1602p_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Y quemará el sebo de la ofrenda por el pecado sobre el altar. ");
INSERT INTO spav1602p_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Y el que hubiere soltado el macho cabrío como macho cabrío de escapatoria, lavará sus vestiduras, lavará también en agua su carne, y después entrará en el campamento. ");
INSERT INTO spav1602p_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Y sacará fuera del campamento el becerro para la ofrenda por el pecado, y el macho cabrío para la ofrenda por el pecado, la sangre de los cuales fue metida para hacer la expiación en el lugar santo; y quemarán en el fuego sus pelle­jos, y sus carnes, y su estiércol. ");
INSERT INTO spav1602p_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Y el que los quemare, lavará sus vestiduras, lavará también su carne con agua, y después entra­rá en el campamento. ");
INSERT INTO spav1602p_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Y esto tendréis por estatuto perpetuo: En el mes séptimo, a los diez del mes, afligiréis vues­tras almas, y ninguna obra haréis, ni el natural ni el extranjero que peregrina entre vosotros: ");
INSERT INTO spav1602p_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Porque en este día el sacerdote hará expiación para vosotros, para limpiaros; para que seáis limpios de todos vuestros pecados delante del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Sábado de reposo es para vosotros, y afligiréis vuestras almas, por estatuto perpetuo. ");
INSERT INTO spav1602p_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Y el sacerdote, que fuere ungido, y que fuere consagrado para ministrar en el oficio del sacerdote en lugar de su padre; hará la expiación, y se vestirá las vestimentas de lino, aún las vestiduras sagradas: ");
INSERT INTO spav1602p_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Y hará expiación por el santuario santo, y hará expiación por el tabernáculo de la congregación y por el altar, y hará expiación por los sacerdotes, y por todo el pueblo de la congregación. ");
INSERT INTO spav1602p_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Y esto tendréis por estatuto perpetuo, para hacer expiación por los hijos de Israel de todos sus pecados una vez al año. Y lo hizo como el SEÑOR mandó a Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Y HABLÓ el SEÑOR a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","Habla a Aarón y a sus hijos, y a todos los hijos de Israel, y diles: Esto es lo que ha mandado el SEÑOR, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Cualquier varón de la casa de Israel que degollare buey, o cor­dero, o cabra, en el campamento, o fuera del campamento, ");
INSERT INTO spav1602p_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","Y no lo trajere a la puerta del tabernáculo de la congregación, para ofrecer ofrenda al SEÑOR delante del tabernáculo del SEÑOR, sangre será imputada al tal varón: él ha derramado sangre; corta­do será el tal varón de entre su pueblo: ");
INSERT INTO spav1602p_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","A fin de que traigan los hijos de Israel sus sacrificios, los que ofrecen sobre la faz del campo, para que los traigan al SEÑOR a la puerta del taberná­culo de la congregación al sacer­dote, y para ofrecerlos para ofrendas de paz al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Y el sacerdote rociará la sangre sobre el altar del SEÑOR, a la puerta del tabernáculo de la congregación, y quemará el sebo en olor de suavidad al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Y nunca más sacrificarán sus sacrificios a los demonios, tras de los cuales han fornicado: ten­drán esto por estatuto perpetuo por sus edades. ");
INSERT INTO spav1602p_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Les dirás también: Cualquier varón de la casa de Israel, o de los extranjeros que peregrinan entre vosotros, que ofreciere ofrenda quemada o sacrificio, ");
INSERT INTO spav1602p_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","Y no lo trajere a la puerta del tabernáculo de la congregación, para ofrecerlo al SEÑOR, el tal varón será igualmente cortado de sus pueblos. ");
INSERT INTO spav1602p_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Y cualquier varón de la casa de Israel, o de los extranjeros que peregrinan entre ellos, que comiere alguna sangre, yo pon­dré mi rostro contra la persona que comiere sangre, y le cortaré de entre su pueblo. ");
INSERT INTO spav1602p_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Porque la vida de la carne en la sangre está: y yo os la he dado sobre el altar para hacer expiación por vuestras almas: porque es la sangre que hace expiación por el alma. ");
INSERT INTO spav1602p_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Por tanto, he dicho a los hijos de Israel: ninguna persona de vosotros comerá sangre, ni el extranjero que peregrina entre vosotros comerá sangre. ");
INSERT INTO spav1602p_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Y cualquier varón de los hijos de Israel, o de los extranjeros que peregrinan entre ellos, que cogie­re caza de animal o de ave que sea de comer, derramará su san­gre y cubrirála con tierra: ");
INSERT INTO spav1602p_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Porque es la vida de toda carne, su sangre es para su vida: por tanto he dicho a los hijos de Israel: No comeréis la sangre de ninguna carne, porque la vida de toda carne es su sangre: cualquiera que la comiere será cortado. ");
INSERT INTO spav1602p_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Y cualquier alma que comiere lo que murió de sí mismo, o lo que fue despedazado de bestias, así de los natu­rales como de los extranjeros, lavará sus vestiduras y a sí mismo se lavará con agua, y será inmun­do hasta la tarde; entonces será limpio. ");
INSERT INTO spav1602p_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Y si no los lavare, ni lavare su carne, entonces llevará su iniquidad. ");
INSERT INTO spav1602p_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Y HABLÓ el SEÑOR a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","Habla a los hijos de Israel, y díles: Yo soy el SEÑOR vuestro Dios. ");
INSERT INTO spav1602p_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","No haréis como hacen en la tie­rra de Egipto, en la cual moras­teis; ni haréis como hacen en la tierra de Canaán, a la cual yo os traigo; ni andaréis en sus ordenanzas. ");
INSERT INTO spav1602p_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Mis juicios pondréis por obra, y mis ordenanzas guardaréis, andando en ellas: Yo soy el SEÑOR vuestro Dios. ");
INSERT INTO spav1602p_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Por tanto mis estatutos y mis derechos guardaréis, los cuales haciendo el hombre, vivirá en ellos: Yo soy el SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Ningún varón se allegue a nin­guna cercana de su carne, para descubrir su desnudez: Yo soy el SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","La desnudez de tu padre, o la desnudez de tu madre, no descu­brirás: tu madre es, no descubri­rás su desnudez. ");
INSERT INTO spav1602p_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","La desnudez de la esposa de tu padre no descubrirás; es la des­nudez de tu padre. ");
INSERT INTO spav1602p_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","La desnudez de tu hermana, hija de tu padre, o hija de tu madre, nacida en casa o nacida fuera, aún su desnudez no descubri­rás. ");
INSERT INTO spav1602p_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","La desnudez de la hija de tu hijo, o de la hija de tu hija, aún su desnudez no descubrirás, porque es la desnudez tuya. ");
INSERT INTO spav1602p_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","La desnudez de la hija de la esposa de tu padre, engendrada de tu padre, tu hermana es, su des­nudez no descubrirás. ");
INSERT INTO spav1602p_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","La desnudez de la hermana de tu padre no descubrirás: es parienta de tu padre. ");
INSERT INTO spav1602p_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","La desnudez de la hermana de tu madre no descubrirás: porque parienta de tu madre es. ");
INSERT INTO spav1602p_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","La desnudez del hermano de tu padre no descubrirás: no llega­rás a su esposa: es tu tía. ");
INSERT INTO spav1602p_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","La desnudez de tu nuera no descubrirás: esposa es de tu hijo; no descubrirás su desnudez. ");
INSERT INTO spav1602p_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","La desnudez de la esposa de tu hermano no descubrirás: es la desnudez de tu hermano. ");
INSERT INTO spav1602p_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","La desnudez de la mujer y de su hija no descubrirás: no toma­rás la hija de su hijo, ni la hija de su hija, para descubrir su desnu­dez: son parientas, es maldad. ");
INSERT INTO spav1602p_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","No tomarás esposa juntamente con su hermana, para hacerla su rival, descubriendo su desnudez delante de ella en su vida. ");
INSERT INTO spav1602p_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Y no llegarás a la mujer en el apartamiento de su inmundicia, para descubrir su desnudez. ");
INSERT INTO spav1602p_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Además, no tendrás acto car­nal con la esposa de tu prójimo, contaminándote con ella. ");
INSERT INTO spav1602p_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Y no des de tu simiente para hacerla pasar por el fuego a Moloc; no contamines el nom­bre de tu Dios: Yo soy el SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","No te echarás con varón como con mujer: es abominación. ");
INSERT INTO spav1602p_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Ni con ningún animal tendrás ayuntamiento amancillándote con él; ni mujer alguna se pondrá delante de animal para ayuntarse con él: es confusión. ");
INSERT INTO spav1602p_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","En ninguna de estas cosas os ensuciaréis; porque en todas estas cosas se han ensuciado las naciones que yo echo de delante de vosotros: ");
INSERT INTO spav1602p_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Y la tierra fue contaminada; por lo cual yo visité su maldad sobre ella, y la tierra vomitó sus moradores. ");
INSERT INTO spav1602p_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Guardad, pues, vosotros mis estatutos y mis derechos, y no hagáis ninguna de todas estas abominaciones; ni el natural ni el extranjero que peregrina entre vosotros. ");
INSERT INTO spav1602p_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","(Porque todas estas abomina­ciones hicieron los hombres de la tierra, que fueron antes de voso­tros, y la tierra fue contaminada:) ");
INSERT INTO spav1602p_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Para que la tierra no os vomite, por haberla contaminado, como vomitó a las naciones que fueron antes de vosotros. ");
INSERT INTO spav1602p_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Porque cualquiera que hiciere alguna de todas estas abomina­ciones, aún las almas que las hicie­ren, serán cortadas de entre su pueblo. ");
INSERT INTO spav1602p_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Por tanto, guardaréis mi ordenanza para que no cometáis ninguna de estas costumbres abominables que fueron cometidas antes de vosotros, y que no os contaminéis en ellas: Yo soy el SEÑOR vuestro Dios. ");
INSERT INTO spav1602p_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Y HABLÓ el SEÑOR a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Habla a toda la congregación de los hijos de Israel, y díles: Santos seréis, porque santo soy yo el SEÑOR vuestro Dios. ");
INSERT INTO spav1602p_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Cada uno temerá a su madre y a su padre, y mis sábados guar­daréis: Yo soy el SEÑOR vuestro Dios. ");
INSERT INTO spav1602p_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","No os volveréis a los ídolos, ni haréis para vosotros dioses de fundición: Yo soy el SEÑOR vuestro Dios. ");
INSERT INTO spav1602p_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Y si sacrificareis sacrifi­cio de paces al SEÑOR, de vues­tra voluntad lo sacrificaréis. ");
INSERT INTO spav1602p_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Será comido el día que lo sacri­ficareis, y el siguiente día: y lo que quedare para el tercer día, será quemado en el fuego. ");
INSERT INTO spav1602p_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Y si se comiere el día tercero, es abominación; no será acep­to: ");
INSERT INTO spav1602p_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Y el que lo comiere, llevará su iniquidad, por cuanto profanó lo santo del SEÑOR; y la tal perso­na será cortada de su pueblo. ");
INSERT INTO spav1602p_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Cuando segareis la mies de vuestra tierra, no acabarás de segar el rincón de tu campo, ni espigarás tu tierra segada. ");
INSERT INTO spav1602p_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Y no rebuscarás tu viña, ni recogerás los granos caídos de tu viña; para el pobre y para el extranjero los dejarás: Yo soy el SEÑOR vuestro Dios. ");
INSERT INTO spav1602p_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","No hurtaréis, y no engañaréis, ni mentiréis ninguno a su próji­mo. ");
INSERT INTO spav1602p_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Y no juraréis en mi nombre falsamente, ni profanarás el nombre de tu Dios: Yo soy el SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","No oprimirás a tu prójimo, ni le robarás. No se detendrá el tra­bajo del jornalero en tu casa hasta la mañana. ");
INSERT INTO spav1602p_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","No maldigas al sordo, y delante del ciego no pongas tro­piezo, mas tendrás temor de tu Dios: Yo soy el SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","No harás agravio en el juicio: no tendrás respeto al pobre, ni honrarás la cara del grande: pero con justicia juzgarás a tu prójimo. ");
INSERT INTO spav1602p_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","No andarás chismeando entre tu pueblo. No te pondrás contra la sangre de tu prójimo: Yo soy el SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","No aborrecerás a tu hermano en tu corazón: ciertamente reprenderás a tu prójimo, y no consentirás sobre él pecado. ");
INSERT INTO spav1602p_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","No te vengarás, ni guardarás rencor a los hijos de tu pueblo: mas amarás a tu prójimo como a ti mismo: Yo soy el SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Mis estatutos guardaréis. A tu ganado no harás ayuntar con diversos géneros; tu campo no sembrarás con mistura de semillas, y no te pondrás vestiduras con mezcla de diversas cosas. ");
INSERT INTO spav1602p_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Y cualquier hombre que tuviere cópula con mujer, y ella fuere sierva desposada con alguno, y no estuviere rescatada, ni le hubiere sido dada libertad, ambos serán azotados: no mori­rán, por cuanto ella no es libre. ");
INSERT INTO spav1602p_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Y él traerá al SEÑOR su ofrenda por la culpa, a la puerta del tabernáculo de la congregación, un carnero para ofrenda por su culpa. ");
INSERT INTO spav1602p_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Y con el carnero de la expia­ción lo reconciliará el sacerdote delante del SEÑOR, por su peca­do que cometió: y se le perdona­rá su pecado que ha cometido. ");
INSERT INTO spav1602p_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Y cuando hubiereis entrado en la tierra, y plantareis toda clase de árboles de comer, contaréis como incircunciso su fruto: tres años os será incircunciso: su fruto no se comerá. ");
INSERT INTO spav1602p_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Y el cuarto año todo su fruto será santo para loor al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Mas al quinto año comeréis el fruto de él, para que os haga cre­cer su fruto: Yo soy el SEÑOR vuestro Dios. ");
INSERT INTO spav1602p_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","No comeréis cosa alguna con sangre. No seréis agoreros, ni adivinaréis. ");
INSERT INTO spav1602p_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","No cortaréis en redondo las extremidades de vuestras cabe­zas, ni dañarás la punta de tu barba. ");
INSERT INTO spav1602p_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Y no haréis cortes en vuestra carne por un muerto, ni imprimiréis en vosotros marca alguna: Yo soy el SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","No contaminarás tu hija haciéndola prostituirse: porque no se prostituya la tierra, y se llene de maldad. ");
INSERT INTO spav1602p_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Mis sábados guardaréis, y mi santuario tendréis en reverencia: Yo soy el SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","No os volváis a los encanta­dores y a los adivinos: no los consultéis ensuciándoos con ellos: Yo soy el SEÑOR vues­tro Dios. ");
INSERT INTO spav1602p_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Delante de las canas te levan­tarás, y honrarás el rostro del anciano, y de tu Dios tendrás temor: Yo soy el SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Y cuando el extranjero mora­re contigo en vuestra tierra, no le oprimiréis. ");
INSERT INTO spav1602p_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Como a uno nacido entre vosotros tendréis al extranjero que peregrinare entre vosotros; y ámalo como a ti mismo; porque peregrinos fuisteis en la tierra de Egipto: Yo soy el SEÑOR vuestro Dios. ");
INSERT INTO spav1602p_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","No hagáis agravio en juicio, en medida de tierra, ni en peso, ni en otra medida. ");
INSERT INTO spav1602p_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Balanzas justas, pesas justas, efa justo, e hin justo tendréis: Yo soy el SEÑOR vuestro Dios, que os saqué de la tierra de Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Guardad pues todos mis esta­tutos, y todos mis juicios, y ponedlos por obra: Yo soy el SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Y HABLÓ el SEÑOR a Moisés diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","Dirás asimismo a los hijos de Israel: Cualquier varón de los hijos de Israel, o de los extranje­ros que peregrinan en Israel, que diere de su simiente a Moloc, de seguro morirá: el pueblo de la tierra lo apedreará con piedras. ");
INSERT INTO spav1602p_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Y yo pondré mi rostro contra el tal varón, y lo cortaré de entre su pueblo; por cuanto dio de su simiente a Moloc, para contaminar mi santuario, y profanar mi santo nombre. ");
INSERT INTO spav1602p_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Que si escondiere el pueblo de la tierra sus ojos de aquel varón que hubiere dado de su simiente a Moloc, para no matarle, ");
INSERT INTO spav1602p_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","Entonces yo pondré mi rostro contra aquel varón, y contra su familia, y le cortaré de entre su pueblo, con todos los que forni­caron en pos de él, prostituyén­dose con Moloc. ");
INSERT INTO spav1602p_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Y la persona que atendiere a encantadores o adivinos, para prostituirse tras de ellos, yo pon­dré mi rostro contra la tal perso­na, y cortaréla de entre su pue­blo. ");
INSERT INTO spav1602p_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Santificaos, pues, y sed santos, porque yo soy el SEÑOR vuestro Dios. ");
INSERT INTO spav1602p_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Y guardad mis estatutos, y ponedlos por obra: Yo soy el SEÑOR que os santifico. ");
INSERT INTO spav1602p_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Porque varón que maldijere a su padre o a su madre, de cierto morirá: a su padre o a su madre maldijo; su sangre será sobre él. ");
INSERT INTO spav1602p_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Y el hombre que adulterare con la esposa de otro, aún el que cometiere adulterio con la esposa de su prójimo, indefectiblemente se hará morir al adúltero y a la adúltera. ");
INSERT INTO spav1602p_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Y cualquiera que se echare con la esposa de su padre, la des­nudez de su padre descubrió; ambos han de ser muertos; su sangre será sobre ellos. ");
INSERT INTO spav1602p_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Y cualquiera que durmiere con su nuera, ambos han de morir: hicieron confusión; su sangre será sobre ellos. ");
INSERT INTO spav1602p_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Y cualquiera que tuviere ayuntamiento con varón como con mujer, abominación hicie­ron: entrambos han de ser muer­tos; sobre ellos será su sangre. ");
INSERT INTO spav1602p_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Y el que tomare esposa y a la madre de ella, comete vileza: quemarán en fuego a él y a ellas, porque no haya vileza entre vosotros. ");
INSERT INTO spav1602p_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Y cualquiera que tuviere cópula con bestia, ha de ser muerto; y mataréis a la bestia. ");
INSERT INTO spav1602p_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Y la mujer que se allegare a algún animal, para tener ayunta­miento con él, a la mujer y al ani­mal matarás: morirán infalible­mente; será su sangre sobre ellos. ");
INSERT INTO spav1602p_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Y cualquiera que tomare a su hermana, hija de su padre o hija de su madre, y viere su desnudez, y ella viere la suya, cosa malvada es; por tanto serán muertos a ojos de los hijos de su pueblo: descubrió la desnudez de su her­mana; su pecado llevará. ");
INSERT INTO spav1602p_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Y cualquiera que durmiere con mujer menstruosa, y descu­briere su desnudez, su fuente descubrió, y ella descubrió la fuente de su sangre: ambos serán cortados de entre su pueblo. ");
INSERT INTO spav1602p_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","La desnudez de la hermana de tu madre, o de la hermana de tu padre, no descubrirás: por cuanto descubrió su parienta, su iniqui­dad llevarán. ");
INSERT INTO spav1602p_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Y cualquiera que durmiere con la esposa del hermano de su padre, la desnudez del hermano de su padre descubrió; su pecado llevarán; morirán sin hijos. ");
INSERT INTO spav1602p_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Y el que tomare la esposa de su hermano, es suciedad; la desnu­dez de su hermano descubrió; sin hijos serán. ");
INSERT INTO spav1602p_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Guardad, pues, todos mis estatutos y todos mis juicios, y hacedlos: y no os vomi­tará la tierra, a la cual yo os traigo para que habitéis en ella. ");
INSERT INTO spav1602p_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Y no andéis en las prácticas de la nación que yo echaré de delante de vosotros: porque ellos hicieron todas estas cosas, y los tuve en abominación. ");
INSERT INTO spav1602p_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Pero a vosotros os he dicho: Vosotros poseeréis la tierra de ellos, y yo os la daré para que la poseáis por heredad, tierra que fluye leche y miel: Yo soy el SEÑOR vuestro Dios, que os he apartado de otros pueblos. ");
INSERT INTO spav1602p_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Por tanto, vosotros haréis diferencia entre animal limpio e inmundo, y entre ave inmunda y limpia: y no ensuciéis vuestras personas en los animales, ni en las aves, ni en ninguna cosa que va arrastrando por la tierra, las cuales os he apartado por inmun­das. ");
INSERT INTO spav1602p_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Habéis, pues, de serme san­tos, porque yo el SEÑOR soy santo, y os he apartado de los pueblos, para que seáis míos. ");
INSERT INTO spav1602p_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Y el hombre o la mujer en quienes hubiere espíritu de hechicería o de adivinación, han de ser muertos: los apedrearán con pie­dras; su sangre será sobre ellos. ");
INSERT INTO spav1602p_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Y EL SEÑOR dijo a Moisés: Habla a los sacerdotes, los hijos de Aarón, y díles que no se contaminen por un muerto entre su pueblo. ");
INSERT INTO spav1602p_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Mas por su pariente cercano a sí, por su madre, o por su padre, o por su hijo, o por su hermano, ");
INSERT INTO spav1602p_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","O por su hermana virgen, a él cercana, la cual no haya tenido marido, por ella se contaminará. ");
INSERT INTO spav1602p_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","No se contaminará, porque es príncipe en sus pueblos, hacién­dose inmundo. ");
INSERT INTO spav1602p_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","No harán calva en su cabeza, ni raerán la punta de su barba, ni en su carne harán cortes. ");
INSERT INTO spav1602p_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Santos serán a su Dios, y no profanarán el nombre de su Dios; porque las ofrendas del SEÑOR hechas por fuego, y el pan de su Dios, ofrecen: por tanto serán santos. ");
INSERT INTO spav1602p_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Mujer ramera o infame no tomarán: ni tomarán mujer repu­diada de su marido: porque es santo a su Dios. ");
INSERT INTO spav1602p_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Lo santificarás por tanto, pues el pan de tu Dios ofrece: santo será para ti, porque santo soy yo el SEÑOR que os santifico. ");
INSERT INTO spav1602p_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Y la hija del varón sacerdote, si comenzare a fornicar, a su padre amancilla: quemada será al fuego. ");
INSERT INTO spav1602p_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Y el sumo sacerdote entre sus hermanos, sobre cuya cabeza fue derramado el aceite de la unción, y que hinchió su mano para ves­tir las vestimentas, no descubrirá su cabeza, ni romperá sus vestiduras: ");
INSERT INTO spav1602p_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Ni entrará donde haya alguna persona muerta, ni por su padre, o por su madre se contaminará. ");
INSERT INTO spav1602p_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Ni saldrá del santuario, ni contaminará el santuario de su Dios; porque la corona del aceite de la unción de su Dios está sobre él: Yo soy el SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Y tomará él esposa con su vir­ginidad. ");
INSERT INTO spav1602p_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Viuda, o repudiada, o infame, o ramera, éstas no tomará: mas tomará virgen de sus pueblos por esposa. ");
INSERT INTO spav1602p_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Y no amancillará su simiente en sus pueblos; porque yo el SEÑOR soy el que los santifico. ");
INSERT INTO spav1602p_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Y el SEÑOR habló a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","Habla a Aarón, y díle: El varón de tu simiente en sus gene­raciones, en el cual hubiere falta, no se allegará para ofrecer el pan de su Dios. ");
INSERT INTO spav1602p_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Porque ningún varón en el cual hubiere falta, se allegará: varón ciego, o cojo, o falto, o sobrado, ");
INSERT INTO spav1602p_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","O varón en el cual hubiere que­bradura de pie o rotura de mano, ");
INSERT INTO spav1602p_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","O corcovado, o lagañoso, o que tuviere nube en el ojo, o que tenga sarna, o empeine, o compañón relajado; ");
INSERT INTO spav1602p_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Ningún varón de la simiente de Aarón sacerdote, en el cual hubiere falta, se allegará para ofrecer las ofrendas hechas por fuego del SEÑOR. Hay falta en él; no se allegará a ofrecer el pan de su Dios. ");
INSERT INTO spav1602p_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Él comerá el pan de su Dios, del santísimo y del santo. ");
INSERT INTO spav1602p_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Pero no entrará del velo adentro, ni se allegará al altar, por cuanto hay falta en él: y no profa­nará mis santuarios, porque yo el SEÑOR los santifico. ");
INSERT INTO spav1602p_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Y Moisés habló esto a Aarón, y a sus hijos, y a todos los hijos de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Y HABLÓ el SEÑOR a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","Di a Aarón y a sus hijos, que se separen de las cosas santas de los hijos de Israel, y que no profanen mi santo nombre en lo que ellos me santifican: Yo soy el SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Díles: Todo varón de toda vues­tra simiente en vuestras generacio­nes que llegare a las cosas sagra­das, que los hijos de Israel consa­gran al SEÑOR, teniendo inmun­dicia sobre sí, de delante de mí será cortada su alma: Yo soy el SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Cualquier varón de la simiente de Aarón que fuere leproso, o padeciere flujo, no comerá de las cosas sagradas hasta que esté limpio: y el que tocare cualquie­ra cosa inmunda de mortecino, o el varón del cual hubiere salido derramamiento de semen; ");
INSERT INTO spav1602p_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","O cualquier que hubiere tocado cualquier criatura que se arrastre, por el cual será inmundo, u hombre por el cual venga a ser inmundo, conforme a cualquiera inmundicia suya; ");
INSERT INTO spav1602p_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","La persona que lo tocare, será inmunda hasta la tarde, y no comerá de las cosas sagradas antes que haya lavado su carne con agua. ");
INSERT INTO spav1602p_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Y cuando el sol se pusiere, será limpio; y después comerá las cosas sagradas, porque su comida es. ");
INSERT INTO spav1602p_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Lo que muera de sí mismo, o lo que es despedazado por fiera, no comerá para contaminarse en ello: Yo soy el SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Guarden, pues, mi ordenanza, para que no lleven pecado por ello, no sea que así mueran cuando la profanaren: Yo el SEÑOR que los santifico. ");
INSERT INTO spav1602p_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Ningún extraño comerá de la cosa sagrada; el huésped del sacerdo­te, ni el jornalero, no comerá de la cosa sagrada. ");
INSERT INTO spav1602p_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Mas si el sacerdote comprare alguna persona con su dinero, ésta comerá de ella, y el nacido en su casa: éstos comerán de su alimento. ");
INSERT INTO spav1602p_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Si la hija del sacerdote esté casada con un extranjero, ella no comerá de la ofrenda de las cosas sagradas. ");
INSERT INTO spav1602p_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Pero si la hija del sacerdote fuere viuda, o repudiada, y no tuviere hijo, y se hubiere vuelto a la casa de su padre, como en su mocedad, comerá del alimento de su padre; mas ningún extraño coma de él. ");
INSERT INTO spav1602p_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Y el que por yerro comiere cosa sagrada, añadirá a ella una quinta parte, y la dará al sacerdote con la cosa sagrada. ");
INSERT INTO spav1602p_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","No profanarán, pues, las cosas santas de los hijos de Israel, las cuales ofrecen para el SEÑOR: ");
INSERT INTO spav1602p_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Y no les harán llevar la iniqui­dad del pecado, comiendo las cosas santas de ellos: porque yo el SEÑOR los santifi­co. ");
INSERT INTO spav1602p_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Y habló el SEÑOR a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","Habla a Aarón y a sus hijos, y a todos los hijos de Israel, y díles: Cualquier varón de la casa de Israel, o de los extranjeros en Israel, que ofreciere su ofrenda por todos sus votos, y por todas sus voluntarias oblaciones que ofrecieren al SEÑOR en ofrenda quemada; ");
INSERT INTO spav1602p_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","De vuestra propia voluntad ofrece­réis macho sin defecto de entre las vacas, de entre los corderos, o de entre las cabras. ");
INSERT INTO spav1602p_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Pero cualquier cosa que tiene mancha, no la ofreceréis. ");
INSERT INTO spav1602p_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Asimismo, cuando alguno ofreciere sacrificio de paces al SEÑOR para presentar voto, u ofreciendo voluntariamente, sea de vacas o de ovejas, sin defecto será acepto; no ha de haber en él mancha. ");
INSERT INTO spav1602p_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Ciego, o perniquebrado, o mutilado, o verrugoso, o sarnoso, o roñoso, no ofreceréis éstos al SEÑOR, ni de ellos pondréis ofrenda hecha por fuego sobre el altar del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Buey o carnero que tenga de más o de menos, podrás ofrecer por ofrenda voluntaria; mas por voto no será acepto. ");
INSERT INTO spav1602p_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","No ofreceréis al SEÑOR lo que está herido, o magullado, o rompido, o cortado; ni en vuestra tierra haréis tal ofrenda. ");
INSERT INTO spav1602p_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Y de mano de extran­jero no ofreceréis el pan de vues­tro Dios de todas estas cosas; porque su corrupción está en ellas: hay en ellas defecto, no se os aceptarán. ");
INSERT INTO spav1602p_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Y habló el SEÑOR a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","El buey, o el cordero, o la cabra, cuando naciere, siete días estará mamando de su madre: mas desde el octavo día en ade­lante será acepto para ofrenda hecha por fuego al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Y sea buey o carnero, no degollaréis en un día a él y a su hijo. ");
INSERT INTO spav1602p_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Y cuando sacrificareis sacrifi­cio de acción de gracias al SEÑOR, de vuestra propia voluntad lo sacrificaréis. ");
INSERT INTO spav1602p_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","En el mismo día se comerá; no dejaréis de él para otro día: Yo soy el SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Guardad pues mis manda­mientos, y ejecutadlos: Yo soy el SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Y no profanaréis mi santo nombre, y yo me santificaré en medio de los hijos de Israel: Yo soy el SEÑOR que os santifi­co; ");
INSERT INTO spav1602p_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Que os saqué de la tierra de Egipto, para ser vuestro Dios: Yo soy el SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Y HABLÓ el SEÑOR a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","Habla a los hijos de Israel, y diles: Las fiestas solemnes del SEÑOR, las cuales proclamaréis santas convocaciones, éstas son mis fiestas solemnes. ");
INSERT INTO spav1602p_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Seis días se trabajará, y el sép­timo día sábado de reposo es, convocación santa: ninguna obra haréis; sábado es del SEÑOR en todas vuestras habitaciones. ");
INSERT INTO spav1602p_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Éstas son las fiestas solemnes del SEÑOR, aún las convocaciones santas, a las cuales proclamaréis en sus estaciones. ");
INSERT INTO spav1602p_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","En el mes primero, a los cator­ce del mes, entre las dos tardes, pascua es del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Y a los quince días de este mes es la solemnidad de los panes sin levadura al SEÑOR: siete días comeréis panes sin levadura. ");
INSERT INTO spav1602p_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","El primer día tendréis santa convocación: ninguna obra servil haréis. ");
INSERT INTO spav1602p_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Y ofreceréis al SEÑOR siete días ofrenda hecha por fuego: el séptimo día será santa convoca­ción; ninguna obra servil haréis. ");
INSERT INTO spav1602p_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Y habló el SEÑOR a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","Habla a los hijos de Israel, y díles: Cuando hubiereis entrado en la tierra que yo os doy, y sega­reis su mies, traeréis al sacerdote un omer por primicia de los pri­meros frutos de vuestra siega; ");
INSERT INTO spav1602p_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","El cual mecerá el omer delan­te del SEÑOR, para que seáis aceptos: el siguiente día del sába­do lo mecerá el sacerdote. ");
INSERT INTO spav1602p_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Y el día que ofrezcáis el omer, ofreceréis un cordero de un año, sin defecto, en ofrenda quemada al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Y su ofrenda será dos décimas de flor de harina amasada con aceite, ofrenda hecha por fuego al SEÑOR en olor suavísimo; y la libación será de vino, la cuarta parte de un hin. ");
INSERT INTO spav1602p_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Y no comeréis pan, ni grano tostado, ni espiga fresca, hasta este mismo día, hasta que hayáis ofrecido la ofrenda de vuestro Dios; estatuto perpetuo es por todas vuestras generaciones en todas vuestras habitaciones. ");
INSERT INTO spav1602p_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Y os habéis de contar desde el siguiente día del sábado, desde el día en que ofrecisteis el omer de la ofrenda mecida; siete sábados cumplidos serán: ");
INSERT INTO spav1602p_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Hasta el siguiente día del sábado séptimo contaréis cin­cuenta días; entonces ofreceréis nuevo presente al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","De vuestras habitaciones trae­réis dos panes para ofrenda mecida, que serán de dos déci­mas de flor de harina, cocidos con levadura, son primicias al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Y ofreceréis con el pan siete corderos de un año sin defecto, y un becerro de la vacada y dos carneros: serán ofrenda quemada al SEÑOR, con su ofrenda y sus libaciones; ofrenda hecha por fuego de suave olor al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Ofreceréis además un macho de cabrío por expiación; y dos corderos de un año en sacrificio de paces. ");
INSERT INTO spav1602p_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Y el sacerdote los mecerá en ofrenda mecida delante del SEÑOR, con el pan de las primi­cias, y los dos corderos: serán cosa sagrada del SEÑOR para el sacerdote. ");
INSERT INTO spav1602p_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Y proclamaréis en este mismo día; que os será santa convocación: ninguna obra servil haréis: será estatuto perpetuo en todas vuestras habitaciones por vuestras generaciones. ");
INSERT INTO spav1602p_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Y cuando segareis la mies de vuestra tierra, no acabarás de segar el rincón de tu campo, ni espigarás tu siega; para el pobre, y para el extranjero la dejarás: Yo soy el SEÑOR vuestro Dios. ");
INSERT INTO spav1602p_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Y habló el SEÑOR a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","Habla a los hijos de Israel, diciendo: En el mes séptimo, al primer día del mes, tendréis sábado, una conmemoración al son de trompetas, una santa convocación. ");
INSERT INTO spav1602p_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Ninguna obra servil haréis; y ofreceréis ofrenda hecha por fuego al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Y habló el SEÑOR a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","También en el décimo día de este séptimo mes será el día de las expia­ciones: tendréis santa convoca­ción, y afligiréis vuestras almas, y ofreceréis ofrenda hecha por fuego al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Ninguna obra haréis en este mismo día; porque es día de expiaciones, para reconciliaros delante del SEÑOR vuestro Dios. ");
INSERT INTO spav1602p_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Porque toda alma que no se afligiere en este mismo día, será cortada de entre su pueblo. ");
INSERT INTO spav1602p_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Y cualquier alma que hiciere obra alguna en este mismo día, yo destruiré la tal persona de entre su pueblo. ");
INSERT INTO spav1602p_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Ninguna obra haréis: estatuto perpetuo será por vuestras edades en todas vuestras habitaciones. ");
INSERT INTO spav1602p_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Sábado de reposo será a voso­tros, y afligiréis vuestras almas, comenzando a los nueve del mes en la tarde: de tarde a tarde celebraréis vuestro sábado. ");
INSERT INTO spav1602p_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Y habló el SEÑOR a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","Habla a los hijos de Israel, y díles: A los quince días de este mes séptimo será la solemnidad de los tabernáculos al SEÑOR por siete días. ");
INSERT INTO spav1602p_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","El primer día habrá santa con­vocación: ninguna obra servil haréis. ");
INSERT INTO spav1602p_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Siete días ofreceréis ofrenda hecha por fuego al SEÑOR: el octavo día tendréis santa convo­cación, y ofreceréis ofrenda hecha por fuego al SEÑOR: es una asamblea solemne: ninguna obra servil haréis. ");
INSERT INTO spav1602p_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Éstas son las fiestas solemnes del SEÑOR, a las que proclamaréis convocaciones santas, para ofre­cer ofrenda hecha por fuego al SEÑOR, ofrenda quemada y presente, sacrificio y libaciones, cada cosa en su tiempo: ");
INSERT INTO spav1602p_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Además de los sábados del SEÑOR y además de vuestros dones, y a más de todos vuestros votos, y además de todas vues­tras ofrendas voluntarias, que daréis al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","También a los quince del mes séptimo, cuando hubiereis alle­gado el fruto de la tierra, haréis fiesta al SEÑOR por siete días: el primer día será sábado; sábado será también el octavo día. ");
INSERT INTO spav1602p_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Y tomaréis el primer día gajos con fruto de árbol hermoso, ramos de palmas, y ramas de árboles espesos, y sauces de los arroyos; y os regocijaréis delante del SEÑOR vuestro Dios por siete días. ");
INSERT INTO spav1602p_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Y guardaréis fiesta solemne al SEÑOR por siete días cada año; será estatuto perpetuo por vuestras generaciones; en el mes séptimo la celebraréis. ");
INSERT INTO spav1602p_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","En cabañas habitaréis siete días: todo natural de Israel habi­tará en cabañas; ");
INSERT INTO spav1602p_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Para que sepan vuestros des­cendientes que en cabañas hice yo habitar a los hijos de Israel, cuando los saqué de la tierra de Egipto: Yo soy el SEÑOR vuestro Dios. ");
INSERT INTO spav1602p_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Así habló Moisés a los hijos de Israel sobre las fiestas solemnes del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Y HABLÓ el SEÑOR a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","Manda a los hijos de Israel que te traigan aceite puro de olivas, molido para la luminaria, para hacer arder las lámparas de con­tinuo. ");
INSERT INTO spav1602p_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Fuera del velo del testimonio, en el tabernáculo de la congrega­ción, las aderezará Aarón desde la tarde hasta la mañana delante del SEÑOR, de continuo: será estatu­to perpetuo por vuestras generaciones. ");
INSERT INTO spav1602p_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Sobre el candelero limpio pon­drá siempre en orden las lámpa­ras delante del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Y tomarás flor de harina, y cocerás de ella doce tortas: cada torta será de dos décimas. ");
INSERT INTO spav1602p_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Y has de ponerlas en dos órdenes, seis en cada orden, sobre la mesa limpia delante del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Pondrás también sobre cada orden incienso limpio, y será para el pan para memorial, aún ofren­da hecha por fuego al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Cada día de sábado lo pondrá de continuo en orden delante del SEÑOR, tomado de los hijos de Israel por pacto sempiterno. ");
INSERT INTO spav1602p_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Y será de Aarón y de sus hijos, los cuales lo comerán en el lugar santo; porque es cosa muy santa para él, de las ofrendas hechas por fuego al SEÑOR, por fuero perpetuo. ");
INSERT INTO spav1602p_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Y el hijo de una mujer israelita, el cual era hijo de un egipcio, salió entre los hijos de Israel; y el hijo de la israelita y un hombre de Israel riñeron en el campamento: ");
INSERT INTO spav1602p_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Y el hijo de la mujer israelita blasfemó el nombre del SEÑOR, y maldijo. Entonces le llevaron a Moisés. (Y su madre se llamaba Selomit, hija de Dribi, de la tribu de Dan.) ");
INSERT INTO spav1602p_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Y pusiéronlo en la cárcel, hasta que les fuese declarado por palabra del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Y el SEÑOR habló a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","Saca al blasfemo fuera del campamento, y todos los que le oyeron pongan sus manos sobre la cabe­za de él, y apedréelo toda la con­gregación. ");
INSERT INTO spav1602p_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Y a los hijos de Israel habla­rás, diciendo: Cualquiera que maldijere a su Dios, llevará su iniquidad. ");
INSERT INTO spav1602p_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Y el que blasfemare el nom­bre del SEÑOR, ha de ser muer­to; toda la congregación lo ape­dreará: así el extranjero como el natural, cuando blasfemare el nombre del SEÑOR, que muera. ");
INSERT INTO spav1602p_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Y el hombre que hiere de muerte a cualquiera per­sona, ciertamente será puesto a la muerte. ");
INSERT INTO spav1602p_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Y el que hiere a algún animal, ha de restituirlo: animal por ani­mal. ");
INSERT INTO spav1602p_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Y el que causare lesión en su prójimo, según hizo, así le sea hecho: ");
INSERT INTO spav1602p_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Rotura por rotura, ojo por ojo, diente por diente: según la lesión que habrá hecho a otro, tal se hará a él. ");
INSERT INTO spav1602p_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","El que hiere algún animal, ha de restituirlo; mas el que hiere de muerte a un hombre, que muera. ");
INSERT INTO spav1602p_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Tendréis una misma ley: como el extranjero, así será el natural: porque yo soy el SEÑOR vuestro Dios. ");
INSERT INTO spav1602p_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Y habló Moisés a los hijos de Israel, y ellos sacaron al blasfe­mo fuera del campamento, y apedreáronlo con piedras. Y los hijos de Israel hicieron según que el SEÑOR había mandado a Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Y EL SEÑOR habló a Moisés en el monte de Sinaí, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Habla a los hijos de Israel, y díles: Cuando hubiereis entrado en la tierra que yo os doy, entonces la tierra guardará sábado al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Seis años sembrarás tu tierra, y seis años podarás tu viña, y coge­rás sus frutos; ");
INSERT INTO spav1602p_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Y el séptimo año la tierra ten­drá sábado de reposo, sábado al SEÑOR: no sembrarás tu tie­rra, ni podarás tu viña. ");
INSERT INTO spav1602p_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Lo que de suyo se naciere en tu tierra segada, no lo segarás; y las uvas de tu viñedo no vendimia­rás: año de reposo será a la tie­rra. ");
INSERT INTO spav1602p_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Mas el sábado de la tierra os será para comer, a ti, y a tu sier­vo, y a tu sierva, y a tu criado, y a tu extranjero que morare conti­go: ");
INSERT INTO spav1602p_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Y a tu ganado, y a la bestia que hubiere en tu tierra, será todo el fruto de ella para comer. ");
INSERT INTO spav1602p_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Y te has de contar siete sábados de años, siete veces siete años; de modo que los días de los siete sábados de años vendrán a serte cuarenta y nueve años. ");
INSERT INTO spav1602p_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Entonces harás pasar la trom­peta de jubilación en el mes sép­timo a los diez del mes; el día de la expiación haréis pasar la trom­peta por toda vuestra tierra. ");
INSERT INTO spav1602p_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Y santificaréis el año cincuenta, y proclamaréis libertad en la tierra a todos sus moradores: éste os será jubileo; y volveréis cada uno a su posesión, y cada cual volverá a su familia. ");
INSERT INTO spav1602p_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","El año de los cincuenta años os será jubileo: no sembraréis, ni segaréis lo que naciere de suyo en la tierra, ni vendimiaréis las uvas de sus viñedos: ");
INSERT INTO spav1602p_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Porque es jubileo: santo será a vosotros; el producto de la tierra comeréis. ");
INSERT INTO spav1602p_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","En este año de jubileo volve­réis cada uno a su posesión. ");
INSERT INTO spav1602p_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Y cuando vendiereis algo a vuestro prójimo o comprareis de mano de vuestro prójimo, no engañe ninguno a su hermano: ");
INSERT INTO spav1602p_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Conforme al número de los años después del jubileo compra­rás de tu prójimo; y conforme al número de los años de los frutos te venderá él a ti. ");
INSERT INTO spav1602p_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Conforme a la multitud de los años aumentarás el precio, y conforme a la disminución de los años disminuirás el precio; por­que según el número de los años de los ren­dimientos te ha de vender él. ");
INSERT INTO spav1602p_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Y no engañe ninguno a su prójimo; mas tendrás temor de tu Dios: porque yo soy el SEÑOR vuestro Dios. ");
INSERT INTO spav1602p_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Ejecutad, pues, mis estatutos, y guardad mis juicios, y ponedlos por obra, y habitaréis en la tierra seguros; ");
INSERT INTO spav1602p_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Y la tierra dará su fruto, y comeréis hasta abundancia, y habita­réis en ella con seguridad. ");
INSERT INTO spav1602p_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Y si dijereis: ¿Qué comeremos el séptimo año? he aquí no hemos de sembrar, ni hemos de coger nuestros frutos: ");
INSERT INTO spav1602p_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Entonces yo os enviaré mi bendición el sexto año, y hará fruto por tres años. ");
INSERT INTO spav1602p_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Y sembraréis el año octavo, y comeréis aún del fruto añejo; hasta el año noveno, hasta que venga su fruto comeréis del añejo. ");
INSERT INTO spav1602p_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Y la tierra no se venderá para siempre: porque la tierra es mía; que vosotros peregrinos y extranjeros sois para conmigo. ");
INSERT INTO spav1602p_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Y en toda la tierra de vuestra posesión, otorgaréis redención a la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Si tu hermano empobreciere, y vendiere algo de su posesión, y si su pariente viniere para redimirlo, entonces redimirá lo que su hermano hubiere vendido. ");
INSERT INTO spav1602p_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Y si el hombre no tuviere para redimirlo, pero consiguiere lo suficiente para redimirlo; ");
INSERT INTO spav1602p_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Entonces contará los años de su venta, y restituirá lo que queda­re al varón a quien vendió, y vol­verá a su posesión. ");
INSERT INTO spav1602p_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Pero si no alcanzare su mano lo que basta para que vuelva a él, lo que vendió estará en poder del que lo compró hasta el año del jubileo; y al jubileo saldrá, y él volverá a su posesión. ");
INSERT INTO spav1602p_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Y el varón que vendiere casa de morada en ciudad cercada, tendrá facultad de redimirla hasta acabarse el año de su venta: un año será el término de poderse redimir. ");
INSERT INTO spav1602p_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Y si no fuere redimida dentro de un año entero, la casa que estuviere en la ciudad murada quedará para siempre por de aquel que la compró, y para sus descendientes: no saldrá en el jubileo. ");
INSERT INTO spav1602p_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Mas las casas de las aldeas que no tienen muro alrededor, serán estimadas como un campo de tierra: tendrán redención, y saldrán en el jubileo. ");
INSERT INTO spav1602p_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Pero en cuanto a las ciudades de los levitas, siempre podrán redimir los levitas las casas de las ciudades que poseyeren. ");
INSERT INTO spav1602p_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Y el que comprare de los levitas, saldrá de la casa vendi­da, o de la ciudad de su posesión, en el año del jubileo: por cuanto las casas de las ciudades de los levitas es la posesión de ellos entre los hijos de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Mas la tierra del ejido de sus ciudades no se venderá, porque es perpetua posesión de ellos. ");
INSERT INTO spav1602p_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Y cuando tu hermano empo­breciere, y se acogiere a ti, tú lo ampararás: como peregrino y extranjero vivirá contigo. ");
INSERT INTO spav1602p_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","No tomarás usura de él, ni aumento; mas tendrás temor de tu Dios, y tu hermano vivirá con­tigo. ");
INSERT INTO spav1602p_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","No le darás tu dinero a usura, ni tu vitualla a ganancia: ");
INSERT INTO spav1602p_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Yo soy el SEÑOR vuestro Dios, que os saqué de la tierra de Egipto, para daros la tierra de Canaán, y para ser vuestro Dios. ");
INSERT INTO spav1602p_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Y si tu hermano empobreciere, estando contigo, y se vendiere a ti, no le harás servir como siervo: ");
INSERT INTO spav1602p_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Sino como criado, y como extranje­ro estará contigo; y hasta el año del jubileo te servirá. ");
INSERT INTO spav1602p_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Entonces saldrá de contigo, él y sus hijos consigo, y volverá a su familia, y a la posesión de sus padres se restituirá. ");
INSERT INTO spav1602p_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Porque son mis siervos, los cuales saqué yo de la tierra de Egipto: no serán vendidos a manera de siervos. ");
INSERT INTO spav1602p_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","No te enseñorearás de él con dureza, pero tendrás temor de tu Dios. ");
INSERT INTO spav1602p_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Así tu siervo como tu sierva que tuvieres, serán de las nacio­nes que están en vuestro alrede­dor: de ellos compraréis siervos y siervas. ");
INSERT INTO spav1602p_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Además compraréis de los hijos de los extranjeros que viven entre vosotros, y de los que del linaje de ellos son nacidos en vuestra tierra, que están con vosotros; los cuales tendréis por posesión: ");
INSERT INTO spav1602p_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Y los poseeréis por heredad para vuestros hijos des­pués de vosotros, como posesión hereditaria; para siempre os ser­viréis de ellos; pero en vues­tros hermanos los hijos de Israel, no os enseñorearéis cada uno sobre su hermano con dureza. ");
INSERT INTO spav1602p_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Y si el peregrino o extranjero que está contigo se enriqueciere, y tu hermano que está con él empobreciere, y se vendiere al peregrino o extranjero que está contigo, o a la raza de la familia del extranjero; ");
INSERT INTO spav1602p_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","Después que se hubiere ven­dido, podrá ser redimido: uno de sus hermanos lo redimirá; ");
INSERT INTO spav1602p_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","O su tío, o el hijo de su tío lo redimirá, o el cercano de su carne, de su linaje, lo redimirá; o si sus medios alcanzaren, él mismo se redimirá. ");
INSERT INTO spav1602p_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Y contará con el que lo com­pró, desde el año que se vendió a él hasta el año del jubileo: y ha de apreciarse el dinero de su venta conforme al número de los años, y se hará con él conforme al tiempo de un criado asalaria­do. ");
INSERT INTO spav1602p_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Si aún fueren muchos años, conforme a ellos volverá para su redención del dinero por el cual se vendió. ");
INSERT INTO spav1602p_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Y si quedare poco tiempo hasta el año del jubileo, entonces contará con él, y devolverá el precio de su redención conforme a sus años. ");
INSERT INTO spav1602p_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Como con tomado a salario anualmente hará con él: no se enseñoreará en él con aspereza delante de tus ojos. ");
INSERT INTO spav1602p_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Y si no se redimiere en esos años, en el año del jubileo saldrá él, y sus hijos con él. ");
INSERT INTO spav1602p_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Porque los hijos de Israel son siervos para mí; son siervos míos, a los cuales saqué de la tierra de Egipto: Yo soy el SEÑOR vuestro Dios. ");
INSERT INTO spav1602p_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","NO HARÉIS para vosotros ídolos, ni escultura, ni os levantaréis estatua, ni pondréis en vuestra tierra imagen de piedra para inclinaros a ella: porque yo soy el SEÑOR vuestro Dios. ");
INSERT INTO spav1602p_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Guardad mis sábados, y tened en reverencia mi santuario: Yo soy el SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Si anduviereis en mis estatutos, y guardareis mis mandamientos, y los hiciereis; ");
INSERT INTO spav1602p_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","Yo daré vuestra lluvia en su debido tiempo, y la tierra rendirá sus producciones, y el árbol del campo dará su fruto; ");
INSERT INTO spav1602p_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Y su trilla os alcanzará a la ven­dimia, y la vendimia alcanzará a la sementera, y comeréis vuestro pan en abundancia y habitaréis segu­ros en vuestra tierra: ");
INSERT INTO spav1602p_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Y yo daré paz en la tierra, y dormiréis, y no habrá quien os espante: y haré quitar las malas bestias de vuestra tierra, y no pasará por vuestro país la espada: ");
INSERT INTO spav1602p_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Y perseguiréis a vuestros ene­migos, y caerán a espada delante de vosotros: ");
INSERT INTO spav1602p_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Y cinco de vosotros persegui­rán a cien, y cien de vosotros perseguirán a diez mil, y vues­tros enemigos caerán a espada delante de vosotros. ");
INSERT INTO spav1602p_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Porque yo os tendré respeto, y os haré crecer, y os multi­plicaré, y estableceré mi pacto con vosotros: ");
INSERT INTO spav1602p_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Y comeréis lo añejo de mucho tiempo, y sacareis fuera lo añejo a causa de lo nuevo: ");
INSERT INTO spav1602p_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Y pondré mi tabernáculo en medio de vosotros, y mi alma no os abo­minará: ");
INSERT INTO spav1602p_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Y andaré entre vosotros, y yo seré vuestro Dios, y vosotros seréis mi pueblo. ");
INSERT INTO spav1602p_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Yo soy el SEÑOR vuestro Dios, que os saqué de la tierra de Egipto, para que no fueseis sus siervos; y rompí las bandas de vuestro yugo, y os he hecho andar rectos. ");
INSERT INTO spav1602p_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Pero si no me oyereis, ni hiciereis todos estos mis manda­mientos, ");
INSERT INTO spav1602p_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","Y si despreciareis mis estatutos, o vuestra alma aborreciere mis juicios, no ejecutando todos mis mandamientos, quebrantando mi pacto; ");
INSERT INTO spav1602p_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","Yo también haré con vosotros esto: enviaré sobre vosotros terror, enflaquecimiento y calentura, que consuman los ojos, y ator­menten el alma: y sembraréis en vano vuestra simiente, porque vuestros enemigos la comerán: ");
INSERT INTO spav1602p_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Y pondré mi rostro contra vosotros, y seréis heridos delante de vuestros enemigos; y los que os aborrecen se enseñorearán de vosotros, y huiréis sin que haya quien os persiga. ");
INSERT INTO spav1602p_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Y si aún con estas cosas no me oyereis, yo os castigaré siete veces más por vuestros pecados. ");
INSERT INTO spav1602p_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Y quebrantaré la soberbia de vuestra fortaleza, y tornaré vuestro cielo como hierro, y vuestra tierra como latón: ");
INSERT INTO spav1602p_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Y vuestra fuerza se consumi­rá en vano; que vuestra tierra no dará su esquilmo, y los árboles de la tierra no darán su fruto. ");
INSERT INTO spav1602p_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Y si anduviereis conmigo en oposición, y no me quisiereis oír, yo añadiré sobre vosotros siete veces más plagas según vuestros pecados. ");
INSERT INTO spav1602p_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Enviaré también contra voso­tros bestias fieras que os arreba­ten los hijos, y destruyan vues­tros animales, y os apoquen, y vuestros caminos sean desiertos. ");
INSERT INTO spav1602p_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Y si con estas cosas no fuereis corregidos, sino que anduviereis conmigo en oposición, ");
INSERT INTO spav1602p_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","Entonces yo también procederé con vosotros en oposición, y os heri­ré aún siete veces por vuestros pecados: ");
INSERT INTO spav1602p_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Y traeré sobre vosotros espa­da vengadora, en vindicación del pacto; y os recogeréis a vuestras ciudades; mas yo enviaré pesti­lencia entre vosotros, y seréis entregados en mano del enemi­go. ");
INSERT INTO spav1602p_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Y cuando yo os quebrantare el arrimo del pan, cocerán diez mujeres vuestro pan en un horno, y os devolverán vuestro pan por peso; y comeréis, y no os harta­réis. ");
INSERT INTO spav1602p_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Y si con esto no me oyereis, mas procediereis conmigo en oposición, ");
INSERT INTO spav1602p_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","Yo procederé con vosotros en contra y con ira, y os castigaré aún siete veces por vuestros pecados. ");
INSERT INTO spav1602p_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Y comeréis las carnes de vuestros hijos, y comeréis las carnes de vuestras hijas: ");
INSERT INTO spav1602p_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Y destruiré vuestros lugares altos, y derribaré vuestras imágenes, y pon­dré vuestros cuerpos muertos sobre los cuerpos muertos de vuestros ídolos, y mi alma os abominará: ");
INSERT INTO spav1602p_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Y pondré vuestras ciudades en desierto, y asolaré vuestros santuarios, y no oleré la fragan­cia de vuestro suave perfume. ");
INSERT INTO spav1602p_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Yo asolaré también la tierra, y vuestros enemigos que moran en ella estarán atónitos: ");
INSERT INTO spav1602p_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Y a vosotros os esparciré por las naciones, y desenvainaré espada en pos de vosotros: y vuestra tierra estará asolada, y desiertas vuestras ciudades. ");
INSERT INTO spav1602p_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Entonces la tierra descansará sus sábados todos los días que estu­viere asolada, y vosotros en la tierra de vuestros enemigos: la tierra descansará entonces y gozará sus sábados. ");
INSERT INTO spav1602p_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Todo el tiempo que esté asolada reposará, porque no reposó en vuestros sábados mientras habitabais en ella. ");
INSERT INTO spav1602p_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Y a los que quedaren de voso­tros infundiré en sus corazones tal cobardía, en la tierra de sus enemigos, que el sonido de una hoja movida los perseguirá, y huirán como de espada, y caerán sin que nadie los persiga. ");
INSERT INTO spav1602p_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Y tropezarán los unos en los otros, como si huyeran delante de espada, aunque nadie los per­siga; y no podréis resistir delante de vuestros enemigos. ");
INSERT INTO spav1602p_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Y pereceréis entre las nacio­nes, y la tierra de vuestros ene­migos os consumirá. ");
INSERT INTO spav1602p_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Y los que quedaren de voso­tros decaerán en las tierras de vuestros enemigos por su iniqui­dad; y por la iniquidad de sus padres decaerán con ellos: ");
INSERT INTO spav1602p_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Si confesaren su iniquidad, y la iniquidad de sus padres, por su prevaricación con que prevarica­ron contra mí: y también porque anduvieron conmigo en oposi­ción; ");
INSERT INTO spav1602p_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","Y que yo también he andado con ellos en contra, y los he meti­do en la tierra de sus enemigos: si entonces se humillaren su corazón incircunciso, y aceptaren el castigo de su iniquidad; ");
INSERT INTO spav1602p_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","Entonces yo me acordaré de mi pacto con Jacob, y asimismo de mi pacto con Isaac, y también de mi pacto con Abraham me acordaré; y haré memoria de la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Que la tierra estará desampa­rada de ellos, y holgará sus sába­dos, estando desolada a causa de ellos; mas entretanto se somete­rán al castigo de sus iniquidades: por cuanto menospreciaron mis juicios, y tuvo el alma de ellos fastidio de mis estatutos. ");
INSERT INTO spav1602p_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Y aun con todo esto, estando ellos en tierra de sus enemigos, yo no los desecharé, ni los abo­minaré para consumirlos, invali­dando mi pacto con ellos: porque yo soy el SEÑOR su Dios: ");
INSERT INTO spav1602p_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Pero me acordaré de ellos por el pacto de sus ancestros, cuando los saqué de la tierra de Egipto a los ojos de las naciones, para ser su Dios: Yo soy el SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Éstos son los estatutos, juicios y leyes que estableció el SEÑOR entre sí y los hijos de Israel en el monte de Sinaí por mano de Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Y HABLÓ el SEÑOR a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","Habla a los hijos de Israel, y díles: Cuando alguno hiciere especial voto al SEÑOR, según la estimación de las personas que se hayan de redimir, así será tu estimación: ");
INSERT INTO spav1602p_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","En cuanto al varón de veinte años hasta sesenta, tu estimación será cincuenta siclos de plata, según el siclo del santuario. ");
INSERT INTO spav1602p_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Y si fuere hembra, entonces la estima­ción será treinta siclos. ");
INSERT INTO spav1602p_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Y si fuere de cinco años hasta veinte, tu estimación será respec­to al varón veinte siclos, y a la hembra diez siclos. ");
INSERT INTO spav1602p_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Y si fuere de un mes hasta cinco años, tu estimación será en orden al varón, cinco siclos de plata; y por la hembra será tu estimación tres siclos de plata. ");
INSERT INTO spav1602p_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Mas si fuere de sesenta años arriba, por el varón tu estimación será quince siclos, y por la hembra diez siclos. ");
INSERT INTO spav1602p_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Pero si fuere más pobre que tu estimación, entonces compare­cerá ante el sacerdote, y el sacer­dote le pondrá valor: conforme a la facultad del votante le impon­drá valor el sacerdote. ");
INSERT INTO spav1602p_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Y si fuere animal de que se ofrece ofrenda al SEÑOR, todo lo que se diere de él al SEÑOR será santo. ");
INSERT INTO spav1602p_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","No será mudado ni trocado, bueno por malo, ni malo por bueno; y si se permutare un ani­mal por otro, él y el dado por él en cambio serán sagrados. ");
INSERT INTO spav1602p_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Y si fuere algún animal inmundo, de que no se ofrece ofrenda al SEÑOR, entonces el animal será puesto delante del sacerdote: ");
INSERT INTO spav1602p_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Y el sacerdote lo apreciará, sea bueno o sea malo; conforme a la estimación del sacerdote, así será. ");
INSERT INTO spav1602p_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Y si lo hubieren de redimir, añadirán su quinto sobre tu valuación. ");
INSERT INTO spav1602p_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Y cuando alguno santificare su casa consagrándola al SEÑOR, la apreciará el sacerdo­te, sea buena o sea mala: según la apreciare el sacerdote, así queda­rá. ");
INSERT INTO spav1602p_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Mas si el santificante redimie­re su casa, añadirá a tu valuación el quinto del dinero de ella, y será suya. ");
INSERT INTO spav1602p_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Y si alguno santificare de la tierra de su posesión al SEÑOR, tu estimación será conforme a su sembradura: un omer de sembra­dura de cebada se apreciará en cincuenta siclos de plata. ");
INSERT INTO spav1602p_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Y si santificare su tierra desde el año del jubileo, conforme a tu estimación quedará. ");
INSERT INTO spav1602p_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Mas si después del jubileo santificare su tierra, entonces el sacerdote hará la cuenta del dine­ro conforme a los años que que­daren hasta el año del jubileo, y se rebajará de tu estimación. ");
INSERT INTO spav1602p_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Y si el que santificó la tierra quisiere redimirla, añadirá a tu estimación el quinto del dinero de ella, y quedaráse para él. ");
INSERT INTO spav1602p_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Mas si él no redimiere la tie­rra, y la tierra se vendiere a otro, no la redimirá más; ");
INSERT INTO spav1602p_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Sino que cuando saliere en el jubileo, la tierra será santa al SEÑOR, como tierra consagra­da: la posesión de ella será del sacerdote. ");
INSERT INTO spav1602p_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Y si santificare alguno al SEÑOR la tierra que él compró, que no era de la tierra de su herencia, ");
INSERT INTO spav1602p_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","Entonces el sacerdote calcula­rá con él la suma de tu estima­ción, hasta el año del jubileo, y aquel día dará tu señalado precio, como cosa consagrada al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","En el año del jubileo, volverá la tierra a aquél de quien él la compró, cuya es la herencia de la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Y todo lo que apreciares será conforme al siclo del santuario: el siclo tiene veinte óbolos. ");
INSERT INTO spav1602p_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Pero el primogénito de los animales, que por la primogenitura es del SEÑOR, nadie lo santificará; sea buey u oveja, del SEÑOR es. ");
INSERT INTO spav1602p_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Mas si fuere de los animales inmundos, lo redimirán confor­me a tu estimación, y añadirán sobre ella su quinto: y si no lo redimieren, se venderá conforme a tu estimación. ");
INSERT INTO spav1602p_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Pero ninguna cosa consagra­da, que alguno hubiere santifica­do al SEÑOR de todo lo que tuviere, de hombres y animales, y de las tierras de su posesión, no se venderá, ni se redimirá: todo lo consagrado será cosa santísi­ma al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Ninguna cosa consagrada, que fuere consagrada de los hombres, será redimida; indefectiblemente ha de ser muerta. ");
INSERT INTO spav1602p_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Y todas las décimas de la tie­rra, así de la simiente de la tierra como del fruto de los árboles, del SEÑOR son: es cosa consagrada al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Y si alguno quisiere redimir algo de sus décimas, añadirá su quinto a ello. ");
INSERT INTO spav1602p_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Y toda décima de vacas o de ovejas, de todo lo que pasa bajo la vara, la décima será consagra­da al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","No mirará si es bueno o malo, ni lo trocará: y si lo trocare, ello y su trueque serán cosas sagra­das; no se redimirá. ");
INSERT INTO spav1602p_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Éstos son los mandamientos que ordenó el SEÑOR a Moisés, para los hijos de Israel, en el monte de Sinaí. ");
INSERT INTO spav1602p_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Y HABLÓ el SEÑOR a Moisés en el desierto de Sinaí, en el tabernáculo de la congregación, en el primero del mes segundo, en el segundo año de su salida de la tierra de Egipto, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","Tomad el encabezamiento de toda la congregación de los hijos de Israel por sus familias, por las casas de sus padres, con la cuen­ta de sus nombres, todos los varo­nes por sus cabezas: ");
INSERT INTO spav1602p_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","De veinte años arriba, todos los que pueden salir a la guerra en Israel, los contaréis tú y Aarón por sus ejércitos. ");
INSERT INTO spav1602p_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Y estará con vosotros un varón de cada tribu, cada uno cabeza de la casa de sus padres. ");
INSERT INTO spav1602p_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Y estos son los nombres de los varones que estarán con voso­tros: De la tribu de Rubén, Elisur hijo de Sedeur. ");
INSERT INTO spav1602p_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","De Simeón, Selumiel hijo de Zurisadai. ");
INSERT INTO spav1602p_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","De Judá, Naasón hijo de Aminadab. ");
INSERT INTO spav1602p_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","De Isacar, Natanael hijo de Zuar. ");
INSERT INTO spav1602p_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","De Zabulón, Eliab hijo de Helón. ");
INSERT INTO spav1602p_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","De los hijos de José: de Efraím, Elisama hijo de Amiud; de Manasés, Gamaliel hijo de Pedasur. ");
INSERT INTO spav1602p_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","De Benjamín, Abidán hijo de Gideoni. ");
INSERT INTO spav1602p_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","De Dan, Ahiezer hijo de Amisadai. ");
INSERT INTO spav1602p_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","De Aser, Pagiel hijo de Ocrán. ");
INSERT INTO spav1602p_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","De Gad, Eliasaf hijo de Deuel. ");
INSERT INTO spav1602p_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","De Neftalí, Ahira hijo de Enán. ");
INSERT INTO spav1602p_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Éstos eran los de renombre de la congregación, príncipes de las tribus de sus padres, capitanes de los millares de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Tomó pues Moisés y Aarón a estos varones que fueron decla­rados por sus nombres: ");
INSERT INTO spav1602p_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","Y juntaron toda la congrega­ción en el primero del mes segundo, y declararon sus linajes, por las casas de sus padres, según la cuenta de los nombres, de veinte años arriba, por sus cabezas, ");
INSERT INTO spav1602p_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Como el SEÑOR lo había mandado a Moisés; y contólos en el desierto de Sinaí. ");
INSERT INTO spav1602p_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Y los hijos de Rubén, primogénito de Israel, por sus generaciones, por sus familias, por las casas de sus padres, conforme a la cuenta de los nombres por sus cabezas, todos los varones de veinte años arriba, todos los que podían salir a la guerra; ");
INSERT INTO spav1602p_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Los contados de ellos, de la tribu de Rubén, fueron cuarenta y seis mil y quinientos. ");
INSERT INTO spav1602p_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","De los hijos de Simeón, por sus generaciones, por sus fami­lias, por las casas de sus padres, los contados de ellos conforme a la cuenta de los nombres por sus cabezas, todos los varones de veinte años arriba, todos los que podían salir a la guerra; ");
INSERT INTO spav1602p_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Los contados de ellos, de la tribu de Simeón, cincuenta y nueve mil y trescientos. ");
INSERT INTO spav1602p_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","De los hijos de Gad, por sus generaciones por sus familias, por las casas de sus padres, conforme a la cuenta de los nom­bres, de veinte años arriba, todos los que podían salir a la guerra; ");
INSERT INTO spav1602p_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Los contados de ellos, de la tribu de Gad, cuarenta y cinco mil seiscientos y cincuenta. ");
INSERT INTO spav1602p_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","De los hijos de Judá, por sus generaciones, por sus familias, por las casas de sus padres, conforme a la cuenta de los nom­bres, de veinte años arriba, todos los que podían salir a la guerra; ");
INSERT INTO spav1602p_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Los contados de ellos, de la tribu de Judá, setenta y cuatro mil y seiscientos. ");
INSERT INTO spav1602p_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","De los hijos de Isacar, por sus generaciones, por sus familias, por las casas de sus padres, conforme a la cuenta de los nom­bres, de veinte años arriba, todos los que podían salir a la guerra; ");
INSERT INTO spav1602p_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Los contados de ellos, de la tribu de Isacar, cincuenta y cuatro mil y cuatrocientos. ");
INSERT INTO spav1602p_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","De los hijos de Zabulón, por sus generaciones, por sus fami­lias, por las casas de sus padres, conforme a la cuenta de sus nombres, de veinte años arriba, todos los que podían salir a la guerra; ");
INSERT INTO spav1602p_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Los contados de ellos, de la tribu de Zabulón, cincuenta y siete mil y cuatrocientos. ");
INSERT INTO spav1602p_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","De los hijos de José: a saber, de los hijos de Efraím, por sus gene­raciones, por sus familias, por las casas de sus padres, conforme a la cuenta de los nombres, de veinte años arriba, todos los que podían salir a la guerra; ");
INSERT INTO spav1602p_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Los contados de ellos, de la tribu de Efraím, cuarenta mil y quinientos. ");
INSERT INTO spav1602p_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","De los hijos de Manasés, por sus generaciones, por sus fami­lias, por las casas de sus padres, conforme a la cuenta de los nom­bres, de veinte años arriba, todos los que podían salir a la guerra; ");
INSERT INTO spav1602p_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Los contados de ellos, de la tribu de Manasés, treinta y dos mil y doscientos. ");
INSERT INTO spav1602p_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","De los hijos de Benjamín, por sus generaciones, por sus fami­lias, por las casas de sus padres, conforme a la cuenta de los nom­bres, de veinte años arriba, todos los que podían salir a la guerra; ");
INSERT INTO spav1602p_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Los contados de ellos, de la tribu de Benjamín, treinta y cinco mil y cuatrocientos. ");
INSERT INTO spav1602p_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","De los hijos de Dan, por sus generaciones, por sus familias, por las casas de sus padres, conforme a la cuenta de los nom­bres, de veinte años arriba, todos los que podían salir a la guerra; ");
INSERT INTO spav1602p_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Los contados de ellos, de la tribu de Dan, sesenta y dos mil y setecientos. ");
INSERT INTO spav1602p_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","De los hijos de Aser, por sus generaciones, por sus familias, por las casas de sus padres, conforme a la cuenta de los nom­bres, de veinte años arriba, todos los que podían salir a la guerra. ");
INSERT INTO spav1602p_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Los contados de ellos, de la tribu de Aser, cuarenta y un mil y quinientos. ");
INSERT INTO spav1602p_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","De los hijos de Neftalí, por sus generaciones, por sus fami­lias, por las casas de sus padres, conforme a la cuenta de los nom­bres, de veinte años arriba, todos los que podían salir a la guerra; ");
INSERT INTO spav1602p_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Los contados de ellos, de la tribu de Neftalí, cincuenta y tres mil y cuatrocientos. ");
INSERT INTO spav1602p_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Éstos fueron los contados, los cuales contaron Moisés y Aarón, con los príncipes de Israel, que eran doce, uno por cada casa de sus padres. ");
INSERT INTO spav1602p_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Y fueron todos los contados de los hijos de Israel por las casas de sus padres, de veinte años arriba, todos los que podían salir a la guerra en Israel; ");
INSERT INTO spav1602p_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Aún todos los contados fueron seiscientos tres mil, quinientos y cincuenta. ");
INSERT INTO spav1602p_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Pero los levitas no fueron contados entre ellos según la tribu de sus padres. ");
INSERT INTO spav1602p_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Porque habló el SEÑOR a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","Solamente no contarás la tribu de Leví, ni tomarás la cuen­ta de ellos entre los hijos de Israel: ");
INSERT INTO spav1602p_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Mas tú pondrás a los levitas en el tabernáculo del testimonio, y sobre todos sus vasos, y sobre todas las cosas que le per­tenecen: ellos llevarán el taber­náculo y todos sus vasos, y ellos servirán en él, y asentarán sus tiendas alrededor del tabernácu­lo. ");
INSERT INTO spav1602p_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Y cuando el tabernáculo par­tiere, los levitas lo desarmarán; y cuando el tabernáculo asentare, los levitas lo armarán: y el extraño que se llegare, morirá. ");
INSERT INTO spav1602p_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Y los hijos de Israel asentarán sus tiendas cada uno en su escua­drón, y cada uno junto a su ban­dera, por sus cuadrillas; ");
INSERT INTO spav1602p_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Mas los levitas asentarán las suyas alrededor del tabernáculo del testimonio, y no habrá ira sobre la congregacion de los hijos de Israel: y los levitas ten­drán la guarda del tabernáculo del testimonio. ");
INSERT INTO spav1602p_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","E hicieron los hijos de Israel conforme a todas las cosas que mandó el SEÑOR a Moisés; así lo hicieron. ");
INSERT INTO spav1602p_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Y HABLÓ el SEÑOR a Moisés y a Aarón, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","Los hijos de Israel acamparán cada uno junto a su bandera, según las enseñas de las casas de sus padres; alrededor del taber­náculo de la congregación acam­parán. ");
INSERT INTO spav1602p_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Y al lado oriente, hacia donde sale el sol, acamparán los de la bandera del campamento de Judá, por sus ejércitos; y Naasón el hijo de Aminadab será capitán de los hijos de Judá. ");
INSERT INTO spav1602p_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Y su hueste, con los contados de ellos, setenta y cuatro mil y seis­cientos. ");
INSERT INTO spav1602p_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Junto a él acamparán los de la tribu de Isacar: y Natanael, hijo de Zuar, será capitán de los hijos de Isacar; ");
INSERT INTO spav1602p_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Y su hueste, con sus contados, cincuenta y cuatro mil y cuatro­cientos: ");
INSERT INTO spav1602p_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Y la tribu de Zabulón: y el capitán de los hijos de Zabulón, Eliab hijo de Helón; ");
INSERT INTO spav1602p_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Y su hueste, con sus contados, cincuenta y siete mil y cuatro­cientos. ");
INSERT INTO spav1602p_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Todos los contados en el campamento de Judá, ciento ochenta y seis mil y cuatrocientos, por sus ejércitos, irán delante. ");
INSERT INTO spav1602p_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","La bandera del campamento de Rubén al sur, por sus ejércitos: y el capitán de los hijos de Rubén, Elisur hijo de Sedeur; ");
INSERT INTO spav1602p_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Y su hueste, sus contados, cuarenta y seis mil y quinientos. ");
INSERT INTO spav1602p_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Y acamparán junto a él los de la tribu de Simeón: y el capitán de los hijos de Simeón, Selumiel hijo de Zurisadai; ");
INSERT INTO spav1602p_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Y su hueste, con los contados de ellos, cincuenta y nueve mil y trescientos: ");
INSERT INTO spav1602p_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Y la tribu de Gad: y el capitán de los hijos de Gad, Eliasaf hijo de Rehuel; ");
INSERT INTO spav1602p_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Y su hueste, con los contados de ellos, cuarenta y cinco mil seiscientos y cincuenta. ");
INSERT INTO spav1602p_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Todos los contados en el campamento de Rubén, ciento cincuenta y un mil cuatrocientos y cincuenta, por sus ejércitos, irán los segundos. ");
INSERT INTO spav1602p_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Luego irá el tabernáculo de la congregación, el campamento de los levitas en medio de los ejércitos: de la manera que asientan el campamento, así caminarán, cada uno en su lugar, junto a sus banderas. ");
INSERT INTO spav1602p_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","La bandera del campamento de Efraím por sus ejércitos, al occidente: y el capitán de los hijos de Efraím, Elisama hijo de Amiud; ");
INSERT INTO spav1602p_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Y su hueste, con los contados de ellos, cuarenta mil y quinien­tos. ");
INSERT INTO spav1602p_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Y junto a él estará la tribu de Manasés; y el capitán de los hijos de Manasés, Gamaliel hijo de Pedasur; ");
INSERT INTO spav1602p_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Y su hueste, con los contados de ellos, treinta y dos mil y dos­cientos: ");
INSERT INTO spav1602p_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Después la tribu de Benjamín: y el capitán de los hijos de Benjamín, Abidán hijo de Gideoni; ");
INSERT INTO spav1602p_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Y su hueste, con los contados de ellos, treinta y cinco mil y cuatrocientos. ");
INSERT INTO spav1602p_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Todos los contados en el campamento de Efraím, ciento ocho mil y ciento, por sus ejércitos, irán los terceros. ");
INSERT INTO spav1602p_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","La bandera del campamento de Dan estará al norte, por sus ejércitos: y el capitán de los hijos de Dan, Ahiezer hijo de Amisadai; ");
INSERT INTO spav1602p_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Y su hueste, con los contados de ellos, sesenta y dos mil y sete­cientos. ");
INSERT INTO spav1602p_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Junto a él acamparán los de la tribu de Aser: y el capitán de los hijos de Aser, Pagiel hijo de Ocrán; ");
INSERT INTO spav1602p_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Y su hueste, con los contados de ellos, cuarenta y un mil y qui­nientos: ");
INSERT INTO spav1602p_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Después la tribu de Neftalí: y el capitán de los hijos de Neftalí, Ahira hijo de Enán; ");
INSERT INTO spav1602p_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Y su hueste, con los contados de ellos, cincuenta y tres mil y cuatrocientos. ");
INSERT INTO spav1602p_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Todos los contados en el campamento de Dan, ciento cincuenta y siete mil y seiscientos: irán los postreros tras sus banderas. ");
INSERT INTO spav1602p_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Éstos son los contados de los hijos de Israel, por las casas de sus padres: todos los contados por campamentos, por sus escuadro­nes, seiscientos tres mil quinien­tos y cincuenta. ");
INSERT INTO spav1602p_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Mas los levitas no fueron contados entre los hijos de Israel; como el SEÑOR lo mandó a Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","E hicieron los hijos de Israel conforme a todas las cosas que el SEÑOR mandó a Moisés; así asentaron el campo por sus ban­deras, y así marcharon cada uno por sus familias, según las casas de sus padres. ");
INSERT INTO spav1602p_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Y ÉSTAS son las generaciones de Aarón y de Moisés en el día que el SEÑOR habló a Moisés en el monte de Sinaí. ");
INSERT INTO spav1602p_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Y éstos son los nombres de los hijos de Aarón: Nadab el primogénito, y Abiú, Eleazar, e Itamar. ");
INSERT INTO spav1602p_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Éstos son los nombres de los hijos de Aarón, sacerdotes ungi­dos; los cuales él consagró para ministrar en el sacerdocio. ");
INSERT INTO spav1602p_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Y Nadab y Abiú murieron delante del SEÑOR, cuando ofrecieron fuego extraño delante del SEÑOR, en el desierto de Sinaí, y no tuvieron hijos: y Eleazar e Itamar ministraron el sacerdocio delante de Aarón su padre. ");
INSERT INTO spav1602p_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Y el SEÑOR habló a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","Haz llegar a la tribu de Leví, y hazla estar delante del sacerdote Aarón, para que le ministren; ");
INSERT INTO spav1602p_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Y desempeñen su cargo, y el cargo de toda la congregación delante del tabernáculo de la congregación, para servir en el ministerio del tabernáculo; ");
INSERT INTO spav1602p_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Y guarden todos los utensilios del tabernáculo de la congregación, y lo encargado a ellos de los hijos de Israel, y ministren en el servicio del tabernáculo. ");
INSERT INTO spav1602p_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Y darás los levitas a Aarón y a sus hijos: le son enteramente dados de entre los hijos de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Y constituirás a Aarón y a sus hijos, para que guarden su sacer­docio: y el extraño que se llega­re, morirá. ");
INSERT INTO spav1602p_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Y habló el SEÑOR a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","Y he aquí, yo he tomado los levitas de entre los hijos de Israel en lugar de todos los pri­mogénitos que abren la matriz entre los hijos de Israel; serán pues míos los levitas: ");
INSERT INTO spav1602p_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Porque mío es todo primogé­nito; desde el día que yo maté todos los primogénitos en la tie­rra de Egipto, yo santifiqué a mí todos los primogénitos en Israel, así de hombres como de anima­les: míos serán: Yo soy el SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Y el SEÑOR habló a Moisés en el desierto de Sinaí, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","Cuenta los hijos de Leví por las casas de sus padres, por sus familias: contarás todos los varo­nes de un mes arriba. ");
INSERT INTO spav1602p_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Y Moisés los contó conforme a la palabra del SEÑOR, como le fue mandado. ");
INSERT INTO spav1602p_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Y los hijos de Leví fueron éstos por sus nombres: Gersón, y Coat, y Merari. ");
INSERT INTO spav1602p_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Y éstos son los nombres de los hijos de Gersón, por sus familias: Libni, y Simei. ");
INSERT INTO spav1602p_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Y los hijos de Coat, por sus familias: Amram, e Izhar, y Hebrón, y Uziel. ");
INSERT INTO spav1602p_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Y los hijos de Merari, por sus familias: Mahali, y Musi. Éstas son las familias de Leví, por las casas de sus padres. ");
INSERT INTO spav1602p_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","De Gersón era la familia de Libni y la de Simei: éstas son las familias de Gersón. ");
INSERT INTO spav1602p_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Los que fueron contados de ellos, conforme a la cuenta de todos los varones, de un mes arriba, aún los que fueron contados de ellos fueron siete mil y quinientos. ");
INSERT INTO spav1602p_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Las familias de Gersón asen­tarán sus tiendas atrás del tabernáculo, al occidente; ");
INSERT INTO spav1602p_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Y el jefe de la casa del padre de los gersonitas será Eliasaf hijo de Lael. ");
INSERT INTO spav1602p_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Y a cargo de los hijos de Gersón, en el tabernáculo de la congregación, estará el taberná­culo, y la tienda, y su cubierta, y la cortina de la puerta del taber­náculo de la congregación, ");
INSERT INTO spav1602p_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","Y las cortinas del patio, y la cortina de la puerta del patio, que está junto al tabernáculo y junto al altar alrededor; asimis­mo sus cuerdas para todo su ser­vicio. ");
INSERT INTO spav1602p_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Y de Coat era la familia amramítica, y la familia izeharítica, y la familia hebronítica, y la familia ozielítica: éstas son las familias coatitas. ");
INSERT INTO spav1602p_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Por la cuenta de todos los varones de un mes arriba, eran ocho mil y seiscientos, que tenían la guarda del santuario. ");
INSERT INTO spav1602p_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Las familias de los hijos de Coat acamparán al lado del tabernáculo, hacia el sur; ");
INSERT INTO spav1602p_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Y el jefe de la casa del padre de las familias de Coat será Elisafán hijo de Uziel. ");
INSERT INTO spav1602p_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Y a cargo de ellos estará el arca, y la mesa, y el candelero, y los altares, y los vasos del san­tuario con que ministran, y el velo, con todo su servicio. ");
INSERT INTO spav1602p_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Y el principal de los jefes de los levitas será Eleazar, hijo de Aarón el sacerdote, encargado de los que tienen la guarda del san­tuario. ");
INSERT INTO spav1602p_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","De Merari, la familia mahalítica y la familia musítica: éstas son las familias de Merari. ");
INSERT INTO spav1602p_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Y los contados de ellos conforme a la cuenta de todos los varones de un mes arriba, fueron seis mil y doscientos. ");
INSERT INTO spav1602p_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Y el jefe de la casa del padre de las familias de Merari fue Suriel hijo de Abihail: éstos acamparán al lado del tabernáculo, al norte. ");
INSERT INTO spav1602p_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Y a cargo de los hijos de Merari estará la custodia de las tablas del tabernáculo, y sus barras, y sus columnas, y sus basas, y todos sus enseres, con todo su servicio: ");
INSERT INTO spav1602p_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Y las columnas en derredor del patio, y sus basas, y sus esta­cas, y sus cuerdas. ");
INSERT INTO spav1602p_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Pero los que acamparán delante del tabernáculo al oriente, delan­te del tabernáculo de la congre­gación al levante, serán Moisés, y Aarón y sus hijos, teniendo la guarda del santuario en lugar de los hijos de Israel: y el extraño que se acercare, será puesto a la muerte. ");
INSERT INTO spav1602p_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Todos los contados de los levitas, que Moisés y Aarón conforme a la palabra del SEÑOR contaron por sus fami­lias, todos los varones de un mes arriba, fueron veinte y dos mil. ");
INSERT INTO spav1602p_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Y el SEÑOR dijo a Moisés: Cuenta todos los varones primogénitos de los hijos de Israel de un mes arriba, y toma la cuenta de los nombres de ellos. ");
INSERT INTO spav1602p_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Y tomarás los levitas para mí, (Yo soy el SEÑOR), en lugar de todos los primogénitos de los hijos de Israel: y los ani­males de los levitas en lugar de todos los primogénitos de los animales de los hijos de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Y contó Moisés, como el SEÑOR le mandó, todos los pri­mogénitos de los hijos de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Y todos los primogénitos varones, conforme a la cuenta de los nombres, de un mes arriba, los contados de ellos fueron veinte y dos mil doscientos setenta y tres. ");
INSERT INTO spav1602p_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Y habló el SEÑOR a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","Toma los levitas en lugar de todos los primogénitos de los hijos de Israel, y los animales de los levitas en lugar de sus ani­males; y los levitas serán míos: Yo soy el SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Y para los que serán redimidos de los doscientos y setenta y tres de los primogénitos de los hijos de Israel, que son más que los Levitas; ");
INSERT INTO spav1602p_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Tomarás cinco siclos por cabeza; conforme al siclo del santuario tomarás: (el siclo tiene veinte óbolos:) ");
INSERT INTO spav1602p_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Y darás a Aarón y a sus hijos el dinero por los redimidos de los que de ellos sobran. ");
INSERT INTO spav1602p_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Tomó, pues, Moisés el dinero de la redención de los que resultaron de más de los redimidos por los levitas: ");
INSERT INTO spav1602p_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Y recibió de los primogénitos de los hijos de Israel en dinero, mil trescientos sesenta y cinco siclos, conforme al siclo del san­tuario. ");
INSERT INTO spav1602p_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Y Moisés dio el dinero de la redención a Aarón y a sus hijos, conforme a la palabra del SEÑOR, según que el SEÑOR había man­dado a Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Y HABLÓ el SEÑOR a Moisés y a Aarón, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","Toma la cuenta de los hijos de Coat de entre los hijos de Leví, por sus familias, por las casas de sus padres, ");
INSERT INTO spav1602p_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","De edad de treinta años arriba hasta cincuenta años, todos los que entran en compañía, para hacer servicio en el tabernáculo de la congregación. ");
INSERT INTO spav1602p_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Éste será el servicio de los hijos de Coat en el tabernáculo de la congregación, en las cosas santísimas: ");
INSERT INTO spav1602p_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Cuando se hubiere de mudar el campamento, vendrán Aarón y sus hijos, y desarmarán el velo de la tienda, y cubrirán con él el arca del testimonio: ");
INSERT INTO spav1602p_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Y pondrán sobre ella la cubier­ta de pieles de tejones, y exten­derán encima el paño todo de azul, y le pondrán sus varas. ");
INSERT INTO spav1602p_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Y sobre la mesa de la proposi­ción extenderán el paño azul, y pondrán sobre ella los platos, y las cucharas, y las copas, y los tazones para libar: y el pan continuo estará sobre ella. ");
INSERT INTO spav1602p_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Y extenderán sobre ella el paño de escarlata, y lo cubri­rán con la cubierta de pieles de tejones; y le pondrán sus varas. ");
INSERT INTO spav1602p_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Y tomarán un paño azul, y cubrirán el candelero de la lumi­naria; y sus lámparas, y sus des­pabiladeras, y sus platillos, y todos sus vasos del aceite con que se sirve; ");
INSERT INTO spav1602p_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Y lo pondrán con todos sus vasos en una cubierta de pieles de tejones, y lo colocarán sobre unas parihuelas. ");
INSERT INTO spav1602p_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Y sobre el altar de oro exten­derán el paño azul, y le cubri­rán con la cubierta de pieles de tejones, y le pondrán sus varas. ");
INSERT INTO spav1602p_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Y tomarán todos los vasos del ministerio, con los que ministran en el santuario, y los pondrán en un paño azul, y los cubrirán con una cubierta de pieles de tejones, y los colocarán sobre unas varas. ");
INSERT INTO spav1602p_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Y quitarán la ceniza del altar, y extenderán sobre él un paño de púrpura: ");
INSERT INTO spav1602p_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Y pondrán sobre él todos sus instrumentos con los que ministran: las paletas, los garfios, los braseros, y los tazones, todos los vasos del altar; y extenderán sobre él la cubierta de pieles de tejones, y le pondrán además las varas. ");
INSERT INTO spav1602p_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Y cuando Aarón y sus hijos acaben de cubrir el santuario y todos los vasos del santuario, cuando el campamento haya de mudarse, vendrán después de ello los hijos de Coat para transportarlo: mas no tocarán cosa santa, para que no mueran. Éstas serán las cargas de los hijos de Coat en el tabernáculo de la congregación. ");
INSERT INTO spav1602p_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Y al cargo de Eleazar, hijo de Aarón el sacerdote, estará el aceite de la luminaria, y el per­fume aromático, y el presente continuo, y el aceite de la unción; el cargo de todo el tabernáculo, y de todo lo que está en él, en el santuario, y en sus vasos. ");
INSERT INTO spav1602p_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Y habló el SEÑOR a Moisés y a Aarón, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","No cortaréis la tribu de las familias de Coat de entre los levitas; ");
INSERT INTO spav1602p_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Mas esto haréis con ellos, para que vivan, y no mueran cuando llegaren a las cosas santísimas: Aarón y sus hijos entrarán y los pondrán a cada uno en su servicio, y en su cargo. ");
INSERT INTO spav1602p_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Pero no entrarán para ver, cuando cubrieren las cosas santas; para que no mueran. ");
INSERT INTO spav1602p_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Y habló el SEÑOR a Moisés diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","Toma también la cuenta de los hijos de Gersón por las casas de sus padres, por sus familias. ");
INSERT INTO spav1602p_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","De edad de treinta años arriba hasta cincuenta años los conta­rás; todos los que entran para hacer servicio, para hacer la obra en el tabernáculo de la congregación. ");
INSERT INTO spav1602p_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Éste será el servicio de las fami­lias de Gersón, para servir y para llevar cargas: ");
INSERT INTO spav1602p_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Llevarán las cortinas del tabernáculo, y el tabernáculo de la congregación, su cubierta, y la cubierta de pieles de tejones que está sobre él encima, y la cortina de la puerta del tabernáculo de la congregación, ");
INSERT INTO spav1602p_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","Y las cortinas del patio, y la cortina de la puerta del patio, que está cerca del tabernáculo y cerca del altar alrededor, y sus cuerdas, y todos los instrumentos de su servicio, y todo lo que será hecho para ellos: así servirán. ");
INSERT INTO spav1602p_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Según la orden de Aarón y de sus hijos será todo el servicio de los hijos de Gersón en todos sus cargos, y en todo su servicio: y les encomendaréis en guarda todos sus cargos. ");
INSERT INTO spav1602p_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Éste es el servicio de las fami­lias de los hijos de Gersón en el tabernáculo de la congregación: y el cargo de ellos estará bajo la mano de Itamar, hijo de Aarón el sacerdote. ");
INSERT INTO spav1602p_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","En cuanto a los hijos de Merari, los contarás por sus familias, por las casas de sus padres. ");
INSERT INTO spav1602p_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Desde el de edad de treinta años arriba hasta el de cincuenta años, los contarás; todos los que entran en compañía, para hacer servicio en el tabernáculo de la congregación. ");
INSERT INTO spav1602p_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Y éste será el deber de su cargo, conforme a todo su servicio en el tabernáculo de la congregación: las tablas del tabernáculo, y sus barras, y sus columnas, y sus basas, ");
INSERT INTO spav1602p_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","Y las columnas del patio alre­dedor, y sus basas, y sus estacas, y sus cuerdas con todos sus ins­trumentos, y todo su servicio; y contaréis por sus nombres todos los vasos de la guarda de su cargo. ");
INSERT INTO spav1602p_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Éste será el servicio de las familias de los hijos de Merari, conforme a todo su servicio en el tabernáculo de la congregación, bajo la mano de Itamar, hijo de Aarón el sacerdote. ");
INSERT INTO spav1602p_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Y Moisés y Aarón, y los jefes de la congregación, conta­ron los hijos de Coat por sus familias, y por las casas de sus padres, ");
INSERT INTO spav1602p_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Desde el de edad de treinta años arriba hasta el de edad de cincuenta años; todo el que entra en el servicio, para la obra en el tabernáculo de la congregación. ");
INSERT INTO spav1602p_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Y fueron los contados de ellos por sus familias, dos mil sete­cientos y cincuenta. ");
INSERT INTO spav1602p_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Éstos fueron los contados de las familias de Coat, todos los que ministran en el tabernáculo de la congregación, los cuales contaron Moisés y Aarón, como lo mandó el SEÑOR por mano de Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Y los contados de los hijos de Gersón, por sus familias, y por las casas de sus padres, ");
INSERT INTO spav1602p_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Desde el de edad de treinta años arriba hasta el de edad de cincuenta años, todo el que entra en el servicio, para la obra en el tabernáculo de la congregación; ");
INSERT INTO spav1602p_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","Aún los contados de ellos por sus familias, por las casas de sus padres, fueron dos mil seiscien­tos y treinta. ");
INSERT INTO spav1602p_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Éstos son los contados de las familias de los hijos de Gersón, todos los que ministran en el tabernáculo de la congregación, los cuales contaron Moisés y Aarón por el mandamiento del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Y los contados de las familias de los hijos de Merari, por sus familias, por las casas de sus padres, ");
INSERT INTO spav1602p_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Desde el de edad de treinta años arriba hasta el de edad de cincuenta años, todo el que entra en el servicio, para la obra en el tabernáculo de la congregación; ");
INSERT INTO spav1602p_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","Aún los contados de ellos, por sus familias, fueron tres mil y dos­cientos. ");
INSERT INTO spav1602p_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Éstos fueron los contados de las familias de los hijos de Merari, los cuales contaron Moisés y Aarón, según la palabra del SEÑOR por mano de Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Todos los contados de los levitas, que Moisés y Aarón y los jefes de Israel contaron por sus familias, y por las casas de sus padres, ");
INSERT INTO spav1602p_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Desde el de edad de treinta años arriba hasta el de edad de cincuenta años, todos los que entraban para ministrar en el ser­vicio, y tener cargo de obra en el tabernáculo de la congregación; ");
INSERT INTO spav1602p_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","Aún los contados de ellos fueron ocho mil quinientos y ochenta, ");
INSERT INTO spav1602p_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Conforme al mandamiento del SEÑOR por mano de Moisés fueron contados, cada uno según su servicio y según su cargo; así fueron contados por él, como el SEÑOR mandó a Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Y EL SEÑOR habló a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","Manda a los hijos de Israel que echen del campo a todo leproso, y a todos los que padecen flujo de semen, y a todo contaminado por muerto: ");
INSERT INTO spav1602p_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Así hombres como mujeres echaréis, fuera del campo los echaréis; porque no contaminen sus campos, entre los cuales yo habito. ");
INSERT INTO spav1602p_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","E hiciéronlo así los hijos de Israel, y los echaron fuera del campo: como el SEÑOR dijo a Moisés, así lo hicieron los hijos de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Y habló el SEÑOR a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","Habla a los hijos de Israel: El hombre o la mujer que cometiere alguno de todos los pecados de los hombres, haciendo prevarica­ción contra el SEÑOR, y fuere culpable aquella persona; ");
INSERT INTO spav1602p_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Confesarán su pecado que cometieron, y compensarán su ofensa enteramente, y añadirán su quinto sobre ello, y lo darán a aquel contra quien pecaron. ");
INSERT INTO spav1602p_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Pero si aquel hombre no tuviere pariente al cual sea restituida la ofensa, sea la ofensa restituida al SEÑOR, aún al sacerdote; a más del carnero de la expiación, con el cual hará expiación por él. ");
INSERT INTO spav1602p_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Y toda ofrenda de todas las cosas santas que los hijos de Israel presentaren al sacerdote, suya será. ");
INSERT INTO spav1602p_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Y lo santificado de cualquiera será suyo: asimismo lo que cual­quiera diere al sacerdote, suyo será. ");
INSERT INTO spav1602p_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Y el SEÑOR habló a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","Habla a los hijos de Israel, y diles: Si la esposa de alguno se desviare, y transgrediere contra él, ");
INSERT INTO spav1602p_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","Y alguno se hubiere echado con ella en ayuntamiento carnal, y su marido no lo hubiese visto por haberse ella contaminado ocultamente, ni hubiere testigo contra ella, ni ella hubiere sido tomada en el acto; ");
INSERT INTO spav1602p_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","Y viniere sobre él espíritu de celo, y tuviere celos de su esposa, habiéndose ella contaminado; o viniere sobre él espíritu de celo, y tuviere celos de su esposa, no habiéndose ella contaminado; ");
INSERT INTO spav1602p_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","Entonces el marido traerá su esposa al sacerdote, y traerá su ofrenda con ella, la décima de un efa de harina de cebada; no echará sobre ella aceite, ni pondrá sobre ella incienso: porque es ofrenda de celos, ofrenda de recordación, que trae en memoria la iniquidad. ");
INSERT INTO spav1602p_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Y el sacerdote la hará acercar, y la hará poner delante del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Luego tomará el sacerdote del agua santa en un vaso de barro: tomará también el sacerdote del polvo que hubiere en el suelo del tabernáculo, y echarálo en el agua. ");
INSERT INTO spav1602p_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Y hará el sacerdote estar en pie a la mujer delante del SEÑOR, y descubrirá la cabeza de la mujer, y pondrá sobre sus manos la ofrenda de la recorda­ción, que es la ofrenda de celos: y el sacerdote tendrá en la mano las aguas amargas que acarrean maldición. ");
INSERT INTO spav1602p_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Y el sacerdote la conjurará, y le dirá: Si ninguno hubiere dor­mido contigo, y si no te has apar­tado de tu marido a inmundicia, libre seas de estas aguas amargas que traen maldición: ");
INSERT INTO spav1602p_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Mas si te has descarriado de tu marido, y te has amancillado, y alguno hubiere tenido coito contigo, fuera de tu marido: ");
INSERT INTO spav1602p_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","(El sacerdote conjurará a la mujer con juramento de maldi­ción, y dirá a la mujer): el SEÑOR te dé en maldición y en conjuración en medio de tu pue­blo, haciendo el SEÑOR a tu muslo que caiga, y a tu vientre que se te hinche; ");
INSERT INTO spav1602p_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Y estas aguas que dan maldi­ción entren en tus entrañas, y hagan hinchar tu vientre, y caer tu muslo. Y la mujer dirá: Amén, amén. ");
INSERT INTO spav1602p_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Y el sacerdote escribirá estas maldiciones en un libro, y las borrará con las aguas amargas: ");
INSERT INTO spav1602p_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Y dará a beber a la mujer las aguas amargas que traen maldi­ción; y las aguas que obran mal­dición entrarán en ella por amar­gas. ");
INSERT INTO spav1602p_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Después tomará el sacerdote de la mano de la mujer el presen­te de los celos, y mecerálo delan­te del SEÑOR, y lo ofrecerá delante del altar: ");
INSERT INTO spav1602p_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Y tomará el sacerdote un puñado del presente, en memoria de ella, y lo quemará sobre el altar, y después dará a beber las aguas a la mujer. ");
INSERT INTO spav1602p_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Darále pues a beber las aguas; y será, que si fuere inmunda y hubiere hecho traición contra su marido, las aguas que obran mal­dición entrarán en ella en amar­gura, y su vientre se hinchará, y caerá su muslo; y la mujer será por maldición en medio de su pueblo. ");
INSERT INTO spav1602p_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Mas si la mujer no fuere inmunda, sino que estuviere limpia, ella será libre, y será fecun­da. ");
INSERT INTO spav1602p_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Ésta es la ley de los celos, cuando la esposa hiciere traición a su marido, y se amancillare; ");
INSERT INTO spav1602p_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","O del marido, sobre el cual pasare espíritu de celo, y tuviere celos de su esposa: presentarála entonces delante del SEÑOR, y el sacerdote ejecutará en ella toda esta ley. ");
INSERT INTO spav1602p_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Y aquel varón será libre de iniquidad, y la mujer llevará su pecado. ");
INSERT INTO spav1602p_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Y HABLÓ el SEÑOR a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","Habla a los hijos de Israel, y díles: El hombre, o la mujer, cuando se apartare haciendo voto de Nazareo, para dedicarse al SEÑOR, ");
INSERT INTO spav1602p_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","Se abstendrá de vino y de bebida fuerte; no beberá vinagre de vino, ni vinagre de bebida fuerte, ni beberá algún licor de uvas, ni tampoco comerá uvas frescas ni secas. ");
INSERT INTO spav1602p_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Todo el tiempo de su nazarea­to, de todo lo que se hace de vid de vino, desde los granillos hasta el hollejo, no comerá. ");
INSERT INTO spav1602p_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Todo el tiempo del voto de su nazareato no pasará navaja sobre su cabeza, hasta que sean cum­plidos los días de su apartamien­to al SEÑOR: santo será; dejará crecer las guedejas del cabello de su cabeza. ");
INSERT INTO spav1602p_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Todo el tiempo que se apartare al SEÑOR, no entrará a persona muerta. ");
INSERT INTO spav1602p_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Por su padre, ni por su madre, por su hermano, ni por su herma­na, no se contaminará con ellos cuando murieren; porque consa­gración de su Dios tiene sobre su cabeza. ");
INSERT INTO spav1602p_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Todo el tiempo de su nazarea­to, será santo al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Y si alguno muriere muy de repente junto a él, contaminará la cabeza de su nazareato; por tanto el día de su purificación raerá su cabeza; al séptimo día la raerá. ");
INSERT INTO spav1602p_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Y el día octavo traerá dos tór­tolas o dos palominos al sacerdo­te, a la puerta del tabernáculo de la congregación; ");
INSERT INTO spav1602p_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Y el sacerdote hará el uno en expiación, y el otro en ofrenda quemada: y expiarálo de lo que pecó sobre el muerto, y santificará su cabeza en aquel día. ");
INSERT INTO spav1602p_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Y consagrará al SEÑOR los días de su nazareato, y traerá un cordero de un año en expiación por la culpa; y los días primeros serán anulados, por cuanto fue contaminado su nazareato. ");
INSERT INTO spav1602p_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Ésta es, pues, la ley del Nazareo el día que se cumpliere el tiempo de su nazareato: Vendrá a la puerta del tabernácu­lo de la congregación; ");
INSERT INTO spav1602p_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Y ofrecerá su ofrenda al SEÑOR, un cordero de un año sin tacha en ofrenda quemada, y una cordera de un año sin defecto en expiación, y un carnero sin defecto por sacrificio de paces: ");
INSERT INTO spav1602p_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Y un canastillo de panes sin levadura, tortas de flor de harina amasadas con aceite, y hojaldres de panes sin levadura untadas con aceite, y su ofrenda de alimento, y sus libaciones. ");
INSERT INTO spav1602p_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Y el sacerdote lo ofrecerá delante del SEÑOR, y hará su expiación y su ofrenda quemada: ");
INSERT INTO spav1602p_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Y ofrecerá el carnero en sacri­ficio de paces al SEÑOR, con el canastillo de las cenceñas; ofre­cerá asimismo el sacerdote su presente, y sus libaciones. ");
INSERT INTO spav1602p_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Y el nazareo raerá a la puerta del tabernáculo de la congregación la cabeza de su separación, y tomará el cabello de la cabeza de su separación, y lo pondrá sobre el fuego que está debajo del sacrificio de las ofrendas de paz. ");
INSERT INTO spav1602p_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Y tomará el sacerdote la espaldilla cocida del carnero, y una torta sin levadura del canastillo, y una hojaldre sin levadura, y las pondrá sobre las manos del nazareo, después que el cabello de su separación fuere raído: ");
INSERT INTO spav1602p_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Y el sacerdote mecerá aque­llo, ofrenda mecida delante del SEÑOR; lo cual será cosa santa del sacerdote, a más del pecho mecido y de la espaldilla separa­da: y después podrá beber vino el Nazareo. ");
INSERT INTO spav1602p_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Ésta es la ley del Nazareo que hiciere voto de su ofrenda al SEÑOR por su nazareato, a más de lo que su mano alcanzare: según el voto que hiciere, así hará, conforme a la ley de su nazareato. ");
INSERT INTO spav1602p_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Y el SEÑOR habló a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","Habla a Aarón y a sus hijos, y díles: Así bendeciréis a los hijos de Israel, diciéndoles: ");
INSERT INTO spav1602p_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","El SEÑOR te bendiga, y te guarde: ");
INSERT INTO spav1602p_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Haga resplandecer el SEÑOR su rostro sobre ti, y haya de ti misericordia: ");
INSERT INTO spav1602p_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","El SEÑOR alce a ti su rostro, y ponga en ti paz. ");
INSERT INTO spav1602p_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Y pondrán mi nombre sobre los hijos de Israel, y yo los ben­deciré. ");
INSERT INTO spav1602p_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Y ACONTECIÓ, que cuando Moisés hubo acabado de levantar el tabernáculo, y ungídolo, y santificádolo, con todos sus vasos; y asimismo ungido y santificado el altar, con todos sus vasos; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Entonces los príncipes de Israel, las cabezas de las casas de sus padres, los cuales eran los príncipes de las tribus, que esta­ban sobre los contados, ofrecie­ron; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Y trajeron sus ofrendas delante del SEÑOR, seis carros cubier­tos, y doce bueyes; por cada dos príncipes un carro, y cada uno un buey; lo cual ofrecieron delante del tabernáculo. ");
INSERT INTO spav1602p_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Y el SEÑOR habló a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","Tómalo de ellos, y será para el servicio del tabernáculo de la congregación: y lo darás a los levitas, a cada uno conforme a su ministerio. ");
INSERT INTO spav1602p_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Entonces Moisés recibió los carros y los bueyes, y diólos a los levitas. ");
INSERT INTO spav1602p_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Dos carros y cuatro bueyes, dio a los hijos de Gersón, conforme a su ministerio; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Y a los hijos de Merari dio los cuatro carros y ocho bueyes, conforme a su ministerio, bajo la mano de Itamar, hijo de Aarón el sacerdote. ");
INSERT INTO spav1602p_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Y a los hijos de Coat no dio; porque llevaban sobre sí en los hombros el servicio del santua­rio. ");
INSERT INTO spav1602p_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Y ofrecieron los príncipes a la dedicación del altar el día que fue ungido, ofrecieron los prínci­pes su ofrenda delante del altar. ");
INSERT INTO spav1602p_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Y el SEÑOR dijo a Moisés: Ofrecerán su ofrenda, un prínci­pe un día, y otro príncipe otro día, a la dedicación del altar. ");
INSERT INTO spav1602p_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Y el que ofreció su ofrenda el primer día fue Naasón hijo de Aminadab, de la tribu de Judá. ");
INSERT INTO spav1602p_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Y fue su ofrenda un plato de plata de peso de ciento y treinta siclos, y un jarro de plata de setenta siclos, al siclo del santua­rio; ambos llenos de flor de hari­na amasada con aceite para pre­sente; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","Una cuchara de oro de diez siclos, llena de perfume; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","Un becerro, un carnero, un cordero de un año para ofrenda quemada; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","Un macho cabrío para expia­ción; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","Y para sacrificio de paces, dos bueyes, cinco carneros, cinco machos de cabrío, cinco corderos de un año. Ésta fue la ofrenda de Naasón, hijo de Aminadab. ");
INSERT INTO spav1602p_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","El segundo día ofreció Natanael hijo de Zuar, príncipe de Isacar. ");
INSERT INTO spav1602p_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Ofreció por su ofrenda un plato de plata de ciento y treinta siclos de peso, un jarro de plata de setenta siclos, al siclo del san­tuario; ambos llenos de flor de harina amasada con aceite para presente; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","Una cuchara de oro de diez siclos, llena de perfume; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","Un becerro, un carnero, un cordero de un año para ofrenda quemada; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","Un macho cabrío para expia­ción; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","Y para sacrificio de paces, dos bueyes, cinco carneros, cinco machos de cabrío, cinco corderos de un año. Ésta fue la ofrenda de Natanael, hijo de Zuar. ");
INSERT INTO spav1602p_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","El tercer día, Eliab hijo de Helón, príncipe de los hijos de Zabulón: ");
INSERT INTO spav1602p_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Y su ofrenda, un plato de plata de ciento y treinta siclos de peso, un jarro de plata de setenta siclos, al siclo del santuario; ambos lle­nos de flor de harina amasada con aceite para presente; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","Una cuchara de oro de diez siclos, llena de perfume; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","Un becerro, un carnero, un cordero de un año para ofrenda quemada; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","Un macho cabrío para expia­ción; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","Y para sacrificio de paces, dos bueyes, cinco carneros, cinco machos de cabrío, cinco corde­ros de un año. Ésta fue la ofren­da de Eliab, hijo de Helón. ");
INSERT INTO spav1602p_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","El cuarto día, Elisur hijo de Sedeur, príncipe de los hijos de Rubén: ");
INSERT INTO spav1602p_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Y su ofrenda, un plato de plata de ciento y treinta siclos de peso, un jarro de plata de setenta siclos, al siclo del santuario, ambos llenos de flor de harina amasada con aceite para presen­te; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","Una cuchara de oro de diez siclos, llena de perfume; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","Un becerro, un carnero, un cordero de un año para ofrenda quemada; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","Un macho cabrío para expia­ción; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","Y para sacrificio de paces, dos bueyes, cinco carneros, cinco machos de cabrío, cinco corde­ros de un año. Ésta fue la ofren­da de Elisur, hijo de Sedeur. ");
INSERT INTO spav1602p_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","El quinto día, Selumiel hijo de Zurisadai, príncipe de los hijos de Simeón: ");
INSERT INTO spav1602p_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Y su ofrenda, un plato de plata de ciento y treinta siclos de peso, un jarro de plata de setenta siclos, al siclo del santuario; ambos llenos de flor de harina amasada con aceite para presen­te; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","Una cuchara de oro de diez siclos llena de perfume; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","Un becerro, un carnero, un cordero de un año para ofrenda quemada; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","Un macho cabrío para expia­ción; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","Y para sacrificio de paces, dos bueyes, cinco carneros, cinco machos de cabrío, cinco corde­ros de un año. Ésta fue la ofren­da de Selumiel, hijo de Zurisadai. ");
INSERT INTO spav1602p_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","El sexto día, Eliasaf hijo de Deuel, príncipe de los hijos de Gad: ");
INSERT INTO spav1602p_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Y su ofrenda, un plato de plata de ciento y treinta siclos de peso, un jarro de plata de setenta siclos, al siclo del santuario; ambos llenos de flor de harina amasada con aceite para presen­te; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","Una cuchara de oro de diez siclos, llena de perfume; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","Un becerro, un carnero, un cordero de un año para ofrenda quemada; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","Un macho cabrío para expia­ción; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","Y para sacrificio de paces, dos bueyes, cinco carneros, cinco machos de cabrío, cinco corde­ros de un año: ésta fue la ofrenda de Eliasaf, hijo de Deuel. ");
INSERT INTO spav1602p_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","El séptimo día, el príncipe de los hijos de Efraím, Elisama hijo de Amiud: ");
INSERT INTO spav1602p_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Y su ofrenda, un plato de plata de ciento y treinta siclos de peso, un jarro de plata de setenta siclos, al siclo del santuario; ambos llenos de flor de harina amasada con aceite para presen­te; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","Una cuchara de oro de diez siclos, llena de perfume; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","Un becerro, un carnero, un cordero de un año para ofrenda quemada; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","Un macho cabrío para expia­ción; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","Y para sacrificio de paces, dos bueyes, cinco carneros, cinco machos de cabrío, cinco corde­ros de un año. Ésta fue la ofren­da de Elisama, hijo de Amiud. ");
INSERT INTO spav1602p_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","El octavo día, el príncipe de los hijos de Manasés, Gamaliel hijo de Pedasur: ");
INSERT INTO spav1602p_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Y su ofrenda, un plato de plata de ciento y treinta siclos de peso, un jarro de plata de setenta siclos, al siclo del santuario; ambos llenos de flor de harina amasada con aceite para presen­te; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","Una cuchara de oro de diez siclos, llena de perfume; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","Un becerro, un carnero, un cordero de un año para ofrenda quemada; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","Un macho cabrío para expia­ción; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","Y para sacrificio de paces, dos bueyes, cinco carneros, cinco machos de cabrío, cinco corde­ros de un año. Ésta fue la ofren­da de Gamaliel, hijo de Pedasur. ");
INSERT INTO spav1602p_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","El noveno día, el príncipe de los hijos de Benjamín, Abidán hijo de Gideoni: ");
INSERT INTO spav1602p_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Y su ofrenda, un plato de plata de ciento y treinta siclos de peso, un jarro de plata de setenta siclos, al siclo del santuario; ambos llenos de flor de harina amasada con aceite para presen­te; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","Una cuchara de oro de diez siclos, llena de perfume; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","Un becerro, un carnero, un cordero de un año para ofrenda quemada; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","Un macho cabrío para expia­ción; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","Y para sacrificio de paces, dos bueyes, cinco carneros, cinco machos de cabrío, cinco corde­ros de un año. Ésta fue la ofren­da de Abidán, hijo de Gideoni. ");
INSERT INTO spav1602p_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","El décimo día, el príncipe de los hijos de Dan, Ahiezer hijo de Amisadai: ");
INSERT INTO spav1602p_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Y su ofrenda, un plato de plata de ciento y treinta siclos de peso, un jarro de plata de setenta siclos, al siclo del santuario; ambos llenos de flor de harina amasada con aceite para presen­te; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","Una cuchara de oro de diez siclos, llena de perfume; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","Un becerro, un carnero, un cordero de un año para ofrenda quemada; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","Un macho cabrío para expia­ción; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","Y para sacrificio de paces, dos bueyes, cinco carneros, cinco machos de cabrío, cinco corde­ros de un año. Ésta fue la ofren­da de Ahiezer, hijo de Amisadai. ");
INSERT INTO spav1602p_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","El undécimo día, el príncipe de los hijos de Aser, Pagiel hijo de Ocrán: ");
INSERT INTO spav1602p_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Y su ofrenda, un plato de plata de ciento y treinta siclos de peso, un jarro de plata de setenta siclos, al siclo del santuario; ambos llenos de flor de harina amasada con aceite para presen­te; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","Una cuchara de oro de diez siclos, llena de perfume; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","Un becerro, un carnero, un cor­dero de un año para ofrenda quemada; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","Un macho cabrío para expia­ción; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","Y para sacrificio de paces, dos bueyes, cinco carneros, cinco machos de cabrío, cinco corderos de un año. Ésta fue la ofrenda de Pagiel, hijo de Ocrán. ");
INSERT INTO spav1602p_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","El duodécimo día, el príncipe de los hijos de Neftalí, Ahira hijo de Enán: ");
INSERT INTO spav1602p_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Y su ofrenda, un plato de plata de ciento y treinta siclos de peso, un jarro de plata de setenta siclos, al siclo del santuario; ambos lle­nos de flor de harina amasada con aceite para presente; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","Una cuchara de oro de diez siclos, llena de perfume; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","Un becerro, un carnero, un cor­dero de un año para ofrenda quemada; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","Un macho cabrío para expia­ción; ");
INSERT INTO spav1602p_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","Y para sacrificio de paces, dos bueyes, cinco carneros, cinco machos de cabrío, cinco corde­ros de un año. Ésta fue la ofren­da de Ahira, hijo de Enán. ");
INSERT INTO spav1602p_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Ésta fue la dedicación del altar, el día que fue ungido, por los príncipes de Israel: doce pla­tos de plata, doce jarros de plata, doce cucharas de oro. ");
INSERT INTO spav1602p_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Cada plato de ciento y treinta siclos, cada jarro de setenta: toda la plata de los vasos, dos mil y cuatrocientos siclos, al siclo del santuario. ");
INSERT INTO spav1602p_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Las doce cucharas de oro lle­nas de perfume, de diez siclos cada cuchara, al siclo del santua­rio: todo el oro de las cucharas, ciento y veinte siclos. ");
INSERT INTO spav1602p_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Todos los bueyes para ofrenda quemada, doce becerros; doce los carneros, doce los corderos de un año, con su presente: y doce los machos de cabrío, para expia­ción. ");
INSERT INTO spav1602p_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Y todos los bueyes del sacrifi­cio de las paces veinte y cuatro novillos, sesenta los carneros, sesenta los machos de cabrío, sesenta los corderos de un año. Ésta fue la dedicación del altar, después que fue ungido. ");
INSERT INTO spav1602p_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Y cuando entraba Moisés en el tabernáculo de la congrega­ción, para hablar con él, oía la voz que le hablaba de encima del propiciatorio que estaba sobre el arca del testimonio, de entre los dos querubines: y hablaba con él. ");
INSERT INTO spav1602p_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Y HABLÓ el SEÑOR a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","Habla a Aarón, y díle: Cuando encendieres las lámparas, las siete lámparas alumbrarán frente a frente del candelero. ");
INSERT INTO spav1602p_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Y Aarón lo hizo así; que encen­dió enfrente del candelero sus lámparas, como el SEÑOR lo mandó a Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Y ésta era la hechura del can­delero: de oro labrado a martillo; desde su pie hasta sus flores era labrado a martillo: conforme al modelo que el SEÑOR mostró a Moisés, así hizo el candelero. ");
INSERT INTO spav1602p_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Y el SEÑOR habló a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","Toma a los levitas de entre los hijos de Israel, y expíalos. ");
INSERT INTO spav1602p_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Y así les harás para expiarlos: rocía sobre ellos el agua de la expiación, y haz pasar la navaja sobre toda su carne, y lavarán sus vestiduras, y serán expiados. ");
INSERT INTO spav1602p_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Luego tomarán un novillo, con su presente de flor de harina amasada con aceite; y tomarás otro novillo para expiación. ");
INSERT INTO spav1602p_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Y harás llegar los levitas delante del tabernáculo de la congregación, y juntarás toda la asamblea de los hijos de Israel; ");
INSERT INTO spav1602p_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Y cuando habrás hecho llegar los levitas delante del SEÑOR, pondrán los hijos de Israel sus manos sobre los levitas; ");
INSERT INTO spav1602p_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Y ofrecerá Aarón los levitas delante del SEÑOR en ofrenda de los hijos de Israel, y servirán en el ministerio del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Y los levitas pondrán sus manos sobre las cabezas de los novillos: y ofrecerás el uno por expiación, y el otro en ofrenda quemada al SEÑOR, para expiar los levitas. ");
INSERT INTO spav1602p_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Y harás presentar los levitas delante de Aarón, y delante de sus hijos, y los ofrecerás en ofrenda al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Así apartarás los levitas de entre los hijos de Israel; y serán míos los levitas ");
INSERT INTO spav1602p_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Y después de eso vendrán los levitas a ministrar en el taberná­culo de la congregación: los expiarás pues, y los ofrecerás en ofrenda. ");
INSERT INTO spav1602p_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Porque enteramente me son a mí dados los levitas de entre los hijos de Israel, en lugar de todo aquel que abre matriz; helos tomado para mí en lugar de los primogénitos de todos los hijos de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Porque mío es todo primogé­nito en los hijos de Israel, así de hombres como de animales; desde el día que yo herí todo pri­mogénito en la tierra de Egipto, los santifiqué para mí. ");
INSERT INTO spav1602p_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Y he tomado los levitas en lugar de todos los primogénitos en los hijos de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Y yo he dado en don los levitas a Aarón y a sus hijos de entre los hijos de Israel, para que sirvan el ministerio de los hijos de Israel en el tabernáculo de la congregación, y reconcilien a los hijos de Israel; porque no haya plaga en los hijos de Israel, lle­gando los hijos de Israel al san­tuario. ");
INSERT INTO spav1602p_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Y Moisés, y Aarón, y toda la congregación de los hijos de Israel, hicieron de los levitas conforme a todas las cosas que mandó el SEÑOR a Moisés acer­ca de los levitas; así hicieron de ellos los hijos de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Y los levitas se purificaron, y lavaron sus vestiduras; y Aarón los ofreció en ofrenda delante del SEÑOR, e hizo Aarón expiación por ellos para purificarlos. ");
INSERT INTO spav1602p_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Y así vinieron después los levitas para servir en su ministe­rio en el tabernáculo de la con­gregación, delante de Aarón y delante de sus hijos: de la mane­ra que mandó el SEÑOR a Moisés acerca de los levitas, así hicieron con ellos. ");
INSERT INTO spav1602p_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Y habló el SEÑOR a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","Esto cuanto a los levitas: de veinte y cinco años arriba entra­rán a hacer su oficio en el servi­cio del tabernáculo de la congre­gación: ");
INSERT INTO spav1602p_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Mas desde los cincuenta años volverán del oficio de su ministe­rio, y nunca más servirán: ");
INSERT INTO spav1602p_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Pero servirán con sus herma­nos en el tabernáculo de la con­gregación, para hacer la guarda, bien que no servirán en el minis­terio. Así harás de los levitas cuanto a sus oficios. ");
INSERT INTO spav1602p_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Y HABLÓ el SEÑOR a Moisés en el desierto de Sinaí, en el segundo año de su salida de la tierra de Egipto, en el mes primero, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","Los hijos de Israel harán la pas­cua a su tiempo. ");
INSERT INTO spav1602p_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","El décimocuarto día de este mes, entre las dos tardes, la haréis a su tiempo: conforme a todos sus ritos, y conforme a todas sus leyes la haréis. ");
INSERT INTO spav1602p_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Y habló Moisés a los hijos de Israel, para que hiciesen la pas­cua. ");
INSERT INTO spav1602p_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","E hicieron la pascua en el mes primero, a los catorce días del mes, entre las dos tardes, en el desierto de Sinaí: conforme a todas las cosas que mandó el SEÑOR a Moisés, así hicieron los hijos de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Y hubo algunos que estaban inmundos a causa de muerto, y no pudieron hacer la pascua aquel día; y llegaron delante de Moisés y delante de Aarón aquel día; ");
INSERT INTO spav1602p_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Y dijéronle aquellos hombres: Nosotros somos inmundos por causa de muerto; ¿por qué sere­mos impedidos de ofrecer ofren­da al SEÑOR a su tiempo entre los hijos de Israel? ");
INSERT INTO spav1602p_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Y Moisés les respondió: Esperad, y oiré qué mandará el SEÑOR acerca de vosotros. ");
INSERT INTO spav1602p_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Y el SEÑOR habló a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","Habla a los hijos de Israel, diciendo: Cualquiera de vosotros o de vuestras generaciones, que fuere inmundo por causa de muerto o estuviere de viaje lejos, hará pascua al SEÑOR: ");
INSERT INTO spav1602p_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","En el mes segundo, a los catorce días del mes, entre las dos tardes, la harán: con cence­ñas y hierbas amargas la come­rán; ");
INSERT INTO spav1602p_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","No dejarán de él para la mañana, ni quebrarán hueso en él: conforme a todas las ordenanzas de la pascua la harán. ");
INSERT INTO spav1602p_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Mas el que estuviere limpio, y no estuviere de viaje, si dejare de hacer la pascua, la tal persona será cortada de sus pueblos: por cuanto no ofreció a su tiempo la ofrenda del SEÑOR, el tal hom­bre llevará su pecado. ");
INSERT INTO spav1602p_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Y si morare con vosotros peregrino, e hiciere la pascua al SEÑOR, conforme a la ordenanza de la pascua y conforme a sus leyes así la hará: una misma ordenanza tendréis, así el peregrino como el natural de la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Y el día que el tabernáculo fue levantado, la nube cubrió el tabernáculo sobre la tienda del testimonio; y a la tarde había sobre el tabernáculo como una apariencia de fuego, hasta la mañana. ");
INSERT INTO spav1602p_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Así era continuamente: la nube lo cubría de día, y de noche la apa­riencia de fuego. ");
INSERT INTO spav1602p_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Y según que se alzaba la nube del tabernáculo, los hijos de Israel se partían: y en el lugar donde la nube paraba, allí aloja­ban los hijos de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Al mandato del SEÑOR los hijos de Israel se partían: y al mandato del SEÑOR asentaban el campo: todos los días que la nube estaba sobre el tabernáculo, ellos estaban quedos. ");
INSERT INTO spav1602p_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Y cuando la nube se detenía sobre el tabernáculo muchos días, entonces los hijos de Israel guardaban la ordenanza del SEÑOR y no partían. ");
INSERT INTO spav1602p_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Y cuando sucedía que la nube estaba sobre el tabernáculo pocos días, al dicho del SEÑOR alojaban, y al dicho del SEÑOR partían. ");
INSERT INTO spav1602p_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Y cuando era que la nube se detenía desde la tarde hasta la mañana, cuando a la mañana la nube se levantaba, ellos partían: o si había estado el día, y a la noche la nube se levantaba, entonces partían. ");
INSERT INTO spav1602p_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","O si dos días, o un mes, o un año, mientras la nube se detenía sobre el tabernáculo quedándose sobre él, los hijos de Israel se estaban acampados y no movían: mas cuando ella se alzaba, ellos movían. ");
INSERT INTO spav1602p_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Al dicho del SEÑOR asenta­ban, y al dicho del SEÑOR par­tían, guardando la ordenanza del SEÑOR, como lo había el SEÑOR dicho por medio de Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Y EL SEÑOR habló a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","Hazte dos trompetas de plata; de obra de martillo las harás, las cuales te servirán para convocar la asamblea, y para hacer mover el campo. ");
INSERT INTO spav1602p_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Y cuando las tocaren, toda la asamblea se juntará a ti a la puerta del tabernáculo de la con­gregación. ");
INSERT INTO spav1602p_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Mas cuando tocaren sólo la una, entonces se congregarán a ti los príncipes, las cabezas de los millares de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Y cuando tocareis alarma, entonces moverán el campo de los que están alojados al oriente. ");
INSERT INTO spav1602p_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Y cuando tocareis alarma la segunda vez, entonces moverán el campo de los que están aloja­dos al sur: alarma tocarán a sus partidas. ");
INSERT INTO spav1602p_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Pero cuando hubiereis de juntar la congregación, tocaréis, mas no con sonido de alarma. ");
INSERT INTO spav1602p_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Y los hijos de Aarón, los sacer­dotes, tocarán las trompetas; y las tendréis por ordenanza perpetua por vuestras generaciones. ");
INSERT INTO spav1602p_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Y cuando viniereis a la guerra en vuestra tierra contra el enemi­go que os molestare, tocaréis alarma con las trompetas: y seréis en memoria delante del SEÑOR vuestro Dios, y seréis salvos de vuestros enemigos. ");
INSERT INTO spav1602p_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Y en el día de vuestra alegría, y en vuestros días solemnes, y en los principios de vuestros meses, tocaréis las trompetas sobre vuestros holocaustos, y sobre los sacrificios de vuestras paces, y os serán por memoria delante de vuestro Dios: Yo soy el SEÑOR vuestro Dios. ");
INSERT INTO spav1602p_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Y sucedió en el año segundo, en el mes segundo, a los veinte del mes, que la nube se alzó del tabernáculo de la congregación. ");
INSERT INTO spav1602p_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Y movieron los hijos de Israel por sus partidas del desierto de Sinaí; y paró la nube en el desier­to de Parán. ");
INSERT INTO spav1602p_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Y movieron la primera vez al dicho del SEÑOR por mano de Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Y la bandera del campamento de los hijos de Judá comenzó a marchar primero, por sus ejércitos: y Naasón, hijo de Aminadab, era sobre su ejército. ");
INSERT INTO spav1602p_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Y sobre el ejército de la tribu de los hijos de Isacar, Natanael hijo de Zuar. ");
INSERT INTO spav1602p_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Y sobre el ejército de la tribu de los hijos de Zabulón, Eliab hijo de Helón. ");
INSERT INTO spav1602p_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Y después que estaba ya desarmado el tabernáculo, movieron los hijos de Gersón y los hijos de Merari, que lo lleva­ban. ");
INSERT INTO spav1602p_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Luego comenzó a marchar la bandera del campo de Rubén por sus ejércitos: y Elisur, hijo de Sedeur, era sobre su ejército. ");
INSERT INTO spav1602p_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Y sobre el ejército de la tribu de los hijos de Simeón, Selumiel hijo de Zurisadai. ");
INSERT INTO spav1602p_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Y sobre el ejército de la tribu de los hijos de Gad, Eliasaf hijo de Deuel. ");
INSERT INTO spav1602p_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Luego comenzaron a marchar los coatitas llevando el santua­rio; y entre tanto que ellos llega­ban, los otros acondicionaron el tabernáculo. ");
INSERT INTO spav1602p_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Después comenzó a marchar la bandera del campamento de los hijos de Efraím por sus ejércitos: y Elisama, hijo de Amiud, era sobre su ejército. ");
INSERT INTO spav1602p_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Y sobre el ejército de la tribu de los hijos de Manasés, Gamaliel hijo de Pedasur. ");
INSERT INTO spav1602p_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Y sobre el ejército de la tribu de los hijos de Benjamín, Abidán hijo de Gideoni. ");
INSERT INTO spav1602p_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Luego comenzó a marchar la bandera del campo de los hijos de Dan por sus escuadrones, a retaguardia de todos los campos: y Ahiezer, hijo de Amisadai, estaba sobre su escuadrón. ");
INSERT INTO spav1602p_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Y sobre el ejército de la tribu de los hijos de Aser, Pagiel hijo de Ocrán. ");
INSERT INTO spav1602p_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Y sobre el ejército de la tribu de los hijos de Neftalí, Ahira hijo de Enán. ");
INSERT INTO spav1602p_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Éstas son las partidas de los hijos de Israel por sus ejércitos, cuando se movían. ");
INSERT INTO spav1602p_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Entonces dijo Moisés a Hobab, hijo de Ragüel madianita, suegro de Moisés: Nosotros nos partimos para el lugar del cual el SEÑOR ha dicho: Yo os lo daré. Ven con nosotros, y te haremos bien: por­que el SEÑOR ha hablado bien respecto a Israel. ");
INSERT INTO spav1602p_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Y él le respondió: Yo no iré, sino que me marcharé a mi tierra y a mi parentela. ");
INSERT INTO spav1602p_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Y él le dijo: Ruégote que no nos dejes; porque tú conoces los sitios en donde debemos acampar en el desierto, y nos serás en lugar de ojos. ");
INSERT INTO spav1602p_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Y será, que si vinieres con nosotros, cuando tuviéremos el bien que el SEÑOR nos ha de hacer, nosotros te haremos bien. ");
INSERT INTO spav1602p_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Así partieron del monte del SEÑOR camino de tres días; y el arca del pacto del SEÑOR fue delante de ellos camino de tres días, buscándoles lugar de des­canso. ");
INSERT INTO spav1602p_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Y la nube del SEÑOR iba sobre ellos de día, desde que par­tieron del campo. ");
INSERT INTO spav1602p_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Y sucedió, que en moviendo el arca, Moisés decía: Levántate, SEÑOR, y sean disipados tus enemigos, y huyan de tu presen­cia los que te aborrecen. ");
INSERT INTO spav1602p_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Y cuando ella asentaba, decía: Vuelve, oh SEÑOR, a los millares de millares de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Y ACONTECIÓ que el pueblo se quejó a oídos del SEÑOR: y oyólo el SEÑOR, y enardecióse su furor, y encendióse en ellos fuego del SEÑOR y consumió el un cabo del campo. ");
INSERT INTO spav1602p_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Entonces el pueblo dio voces a Moisés, y Moisés oró al SEÑOR, y soterróse el fuego. ");
INSERT INTO spav1602p_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Y llamó a aquel lugar Tabera; porque el fuego del SEÑOR se encendió en ellos. ");
INSERT INTO spav1602p_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Y el vulgo que había en medio tuvo un vivo deseo, y volvieron, y aun lloraron los hijos de Israel, y dijeron: ¡Quién nos diera a comer carne! ");
INSERT INTO spav1602p_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Nos acordamos del pescado que comíamos en Egipto gratuitamente, de los cohombros, y de los melones, y de los puerros, y de las cebollas, y de los ajos: ");
INSERT INTO spav1602p_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Y ahora nuestra alma se seca; que nada sino maná ven nuestros ojos. ");
INSERT INTO spav1602p_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Y era el maná como semilla de culantro, y su color como color de bdelio. ");
INSERT INTO spav1602p_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Derramábase el pueblo, y reco­gían, y molían en molinos, o majaban en morteros, y lo cocían en caldera, o hacían de él tortas: y su sabor era como sabor de aceite nuevo. ");
INSERT INTO spav1602p_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Y cuando descendía el rocío sobre el real de noche, el maná descendía de sobre él. ");
INSERT INTO spav1602p_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Y oyó Moisés al pueblo, que lloraba por sus familias, cada uno a la puerta de su tienda: y el furor del SEÑOR se encendió en gran manera; también pareció mal a Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Y dijo Moisés al SEÑOR: ¿Por qué has hecho mal a tu sier­vo? ¿y por qué no he hallado gra­cia en tus ojos, que has puesto la carga de todo este pueblo sobre mí? ");
INSERT INTO spav1602p_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","¿Concebí yo a todo este pue­blo? ¿engendrélo yo, para que me digas: Llévalo en tu seno, como lleva la que cría al que mama, a la tierra de la cual juras­te a sus padres? ");
INSERT INTO spav1602p_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","¿De dónde tengo yo carne para dar a todo este pueblo? por­que lloran a mí, diciendo: Danos carne que comamos. ");
INSERT INTO spav1602p_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","No puedo yo solo soportar a todo este pueblo, que me es pesa­do en demasía. ");
INSERT INTO spav1602p_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Y si así lo haces tú conmigo, yo te ruego que me des muerte, si he hallado gracia en tus ojos; y que yo no vea mi mal. ");
INSERT INTO spav1602p_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Entonces el SEÑOR dijo a Moisés: Júntame setenta varones de los ancianos de Israel, que tú sabes que son ancianos del pue­blo y sus principales; y tráelos a la puerta del tabernáculo de la congregación, y esperen allí con­tigo. ");
INSERT INTO spav1602p_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Y yo descenderé y hablaré allí contigo; y tomaré del espíritu que está en ti, y pondré en ellos; y llevarán contigo la carga del pueblo, y no la llevarás tú solo. ");
INSERT INTO spav1602p_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Y dirás al pueblo: Santificaos para mañana, y comeréis carne: pues que habéis llorado en oídos del SEÑOR, diciendo: ¡Quién nos diera a comer carne! ¡cierto mejor nos iba en Egipto! El SEÑOR, pues, os dará carne, y comeréis. ");
INSERT INTO spav1602p_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","No comeréis un día, ni dos días, ni cinco días, ni diez días, ni veinte días; ");
INSERT INTO spav1602p_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Sino hasta un mes de tiempo, hasta que os salga por las narices, y os sea en aborrecimiento: por cuanto menospreciasteis al SEÑOR que está en medio de vosotros, y llorasteis delante de él, diciendo: ¿Para qué salimos acá de Egipto? ");
INSERT INTO spav1602p_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Entonces dijo Moisés: Seiscientos mil de a pie es el pue­blo en medio del cual yo estoy; y tú dices: Les daré carne, y come­rán el tiempo de un mes. ");
INSERT INTO spav1602p_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","¿Se han de degollar para ellos ovejas y bueyes que les basten? ¿o se juntarán para ellos todos los peces del mar para que ten­gan abasto? ");
INSERT INTO spav1602p_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Entonces el SEÑOR respon­dió a Moisés: ¿Hase acortado la mano del SEÑOR? ahora verás si te sucede mi dicho, o no. ");
INSERT INTO spav1602p_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Y salió Moisés, y dijo al pue­blo las palabras del SEÑOR: y juntó los setenta varones de los ancianos del pueblo, e hízolos estar alrededor del tabernáculo. ");
INSERT INTO spav1602p_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Entonces el SEÑOR descen­dió en la nube, y hablóle; y tomó del espíritu que estaba en él, y púsolo en los setenta varones ancianos; y sucedió que, cuando posó sobre ellos el espíritu, profetiza­ron, y no cesaron. ");
INSERT INTO spav1602p_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Y habían quedado en el campo dos varones, llamado el uno Eldad y el otro Medad, sobre los cuales también reposó el espíritu: estaban estos entre los escritos, mas no habían salido al tabernáculo; y profetizaron en el campo. ");
INSERT INTO spav1602p_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Y corrió un mozo, y dio aviso a Moisés, y dijo: Eldad y Medad profetizan en el campo. ");
INSERT INTO spav1602p_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Entonces respondió Josué hijo de Nun, ministro de Moisés, uno de sus mancebos, y dijo: Señor mío Moisés, impídelos. ");
INSERT INTO spav1602p_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Y Moisés le respondió: ¿Tienes tú celos por mí? ¡Quiera Dios! que todo el pueblo del SEÑOR fuesen profetas, que el SEÑOR pusiera su espíritu sobre ellos. ");
INSERT INTO spav1602p_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Y recogióse Moisés al campo, él y los ancianos de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Y salió un viento del SEÑOR, y trajo codornices del mar, y dejólas sobre el real, un día de camino de la una parte, y un día de camino de la otra, en derredor del campo, y casi dos codos sobre la faz de la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Entonces el pueblo estuvo levantado todo aquel día, y toda la noche, y todo el día siguiente, y recogiéronse codornices: el que menos, recogió diez monto­nes; y las tendieron para si a lo largo en derredor del campo. ");
INSERT INTO spav1602p_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Aún estaba la carne entre los dientes de ellos, antes que fuese mascada, cuando el furor del SEÑOR se encendió en el pue­blo, e hirió el SEÑOR al pueblo con una muy grande plaga. ");
INSERT INTO spav1602p_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Y llamó el nombre de aquel lugar Kibrot-hataava, por cuanto allí sepultaron al pueblo codicioso. ");
INSERT INTO spav1602p_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","De Kibrot-hataava movió el pueblo a Haserot, y pararon en Haserot. ");
INSERT INTO spav1602p_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Y HABLARON Miriam y Aarón contra Moisés a causa de la mujer etíope que había tomado: porque él había tomado mujer etíope. ");
INSERT INTO spav1602p_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Y dijeron: ¿Solamente por Moisés ha hablado el SEÑOR? ¿no ha hablado también por nosotros? Y oyólo el SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Y aquel varón Moisés era muy manso, más que todos los hom­bres que había sobre la tierra, ");
INSERT INTO spav1602p_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Y luego dijo el SEÑOR a Moisés, y a Aarón, y a Miriam: Salid vosotros tres al tabernáculo de la congregación. Y salieron ellos tres. ");
INSERT INTO spav1602p_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Entonces el SEÑOR descendió en la columna de la nube, y púso­se a la puerta del tabernáculo, y llamó a Aarón y a Miriam; y salie­ron ellos ambos. ");
INSERT INTO spav1602p_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Y él les dijo: Oíd ahora mis palabras: si tuviereis profeta del SEÑOR, le apareceré en visión, en sueños hablaré con él. ");
INSERT INTO spav1602p_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","No así a mi siervo Moisés, que es fiel en toda mi casa: ");
INSERT INTO spav1602p_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Boca a boca hablaré con él, y a las claras, y no por figuras; y verá la apariencia del SEÑOR: ¿por qué pues no tuvisteis temor de hablar contra mi siervo Moisés? ");
INSERT INTO spav1602p_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Entonces el furor del SEÑOR se encendió en ellos; y fuese. ");
INSERT INTO spav1602p_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Y la nube se apartó del taber­náculo: y he aquí que Miriam era leprosa como la nieve; y miró Aarón a Miriam, y he aquí que estaba leprosa. ");
INSERT INTO spav1602p_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Y dijo Aarón a Moisés: ¡Ah! señor mío, no pongas ahora sobre nosotros pecado; porque locamente lo hemos hecho, y hemos pecado. ");
INSERT INTO spav1602p_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","No sea ella ahora como el que sale muerto del vientre de su madre, consumida la mitad de su carne. ");
INSERT INTO spav1602p_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Entonces Moisés clamó al SEÑOR, diciendo: Ruégote, oh Dios, que la sanes ahora. ");
INSERT INTO spav1602p_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Respondió el SEÑOR a Moisés: Pues si su padre hubiera escupido en su cara, ¿no se avergonzaría por siete días? sea echada fuera del real por siete días, y después se reunirá. ");
INSERT INTO spav1602p_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Así Miriam fue echada del real siete días; y el pueblo no pasó adelante hasta que se le reunió Miriam. ");
INSERT INTO spav1602p_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Y después movió el pueblo de Haserot, y asentaron el campo en el desierto de Parán. ");
INSERT INTO spav1602p_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Y EL SEÑOR habló a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","Envía tú hombres que reconoz­can la tierra de Canaán, la cual yo doy a los hijos de Israel: de cada tribu de sus padres enviaréis un varón, cada uno príncipe entre ellos. ");
INSERT INTO spav1602p_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Y Moisés los envió desde el desierto de Parán, conforme a la palabra del SEÑOR: y todos aquellos varones eran príncipes de los hijos de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Los nombres de los cuales son éstos: De la tribu de Rubén, Samúa hijo de Zacur. ");
INSERT INTO spav1602p_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","De la tribu de Simeón, Safat hijo de Hori. ");
INSERT INTO spav1602p_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","De la tribu de Judá, Caleb hijo de Jefone. ");
INSERT INTO spav1602p_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","De la tribu de Isacar, Igal hijo de José. ");
INSERT INTO spav1602p_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","De la tribu de Efraím, Oseas hijo de Nun. ");
INSERT INTO spav1602p_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","De la tribu de Benjamín, Palti hijo de Rafu. ");
INSERT INTO spav1602p_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","De la tribu de Zabulón, Gadiel hijo de Sodi. ");
INSERT INTO spav1602p_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","De la tribu de José, de la tribu de Manasés, Gadi hijo de Susi. ");
INSERT INTO spav1602p_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","De la tribu de Dan, Amiel hijo de Gemali. ");
INSERT INTO spav1602p_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","De la tribu de Aser, Setur hijo de Micael. ");
INSERT INTO spav1602p_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","De la tribu de Neftalí, Nahabí hijo de Vapsi. ");
INSERT INTO spav1602p_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","De la tribu de Gad, Geuel hijo de Maqui. ");
INSERT INTO spav1602p_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Éstos son los nombres de los varones que Moisés envió a reco­nocer la tierra: y a Oseas hijo de Nun, le puso Moisés el nombre de Josué. ");
INSERT INTO spav1602p_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Enviólos, pues, Moisés a reco­nocer la tierra de Canaán, dicién­doles: Subid por aquí, hacia el sur, y subid al monte: ");
INSERT INTO spav1602p_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Y observad la tierra qué tal es; y el pueblo que la habita, si es fuerte o débil, si poco o numeroso; ");
INSERT INTO spav1602p_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Qué tal la tierra habitada, si es buena o mala; y qué tales son las ciudades habitadas, si de tiendas o de fortalezas; ");
INSERT INTO spav1602p_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Y cuál sea el terreno, si es pin­güe o flaco, si en él hay o no árboles: y esforzaos, y coged del fruto del país. Y el tiempo era el tiempo de las primeras uvas. ");
INSERT INTO spav1602p_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Y ellos subieron, y reconocieron la tierra desde el desierto de Zin hasta Rehob, entrando en Hamat. ");
INSERT INTO spav1602p_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Y subieron por el sur, y vinieron hasta Hebrón: y allí estaban Aimán, y Sesai, y Talmai, hijos de Anac. Hebrón fue edificada siete años antes de Zoán, la de Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Y llegaron hasta el arroyo de Escol, y de allí cortaron un sar­miento con un racimo de uvas, el cual trajeron dos en un palo, y de las granadas y de los higos. ");
INSERT INTO spav1602p_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Se llamó aquel lugar el arroyo de Escol, por el racimo de uvas que cortaron de allí los hijos de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Y volvieron de reconocer la tierra al cabo de cuarenta días. ");
INSERT INTO spav1602p_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Y anduvieron y vinieron a Moisés y a Aarón, y a toda la congregación de los hijos de Israel, en el desierto de Parán, en Cades, y diéronles la respuesta, y a toda la congregación, y les mostraron el fruto de la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Y le contaron, y dijeron: Nosotros llegamos a la tierra a la cual nos enviaste, la que cierta­mente fluye leche y miel; y éste es el fruto de ella. ");
INSERT INTO spav1602p_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Mas el pueblo que habita aquella tierra es fuerte, y las ciu­dades muy grandes y fuertes; y también vimos allí los hijos de Anac. ");
INSERT INTO spav1602p_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Amalec habita la tierra del sur; y el heteo, y el jebuseo, y el amorreo, habitan en el monte; y el cananeo habita junto al mar, y a la ribera del Jordán. ");
INSERT INTO spav1602p_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Entonces Caleb hizo callar el pueblo delante de Moisés, y dijo: Subamos luego, y poseámosla; que más podremos que ella. ");
INSERT INTO spav1602p_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Mas los varones que subieron con él, dijeron: No podremos subir contra aquel pueblo; por­que es más fuerte que nosotros. ");
INSERT INTO spav1602p_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Y vituperaron entre los hijos de Israel la tierra que habían reconocido, diciendo: La tierra por donde pasamos para recono­cerla, es tierra que traga a sus moradores; y todo el pueblo que vimos en medio de ella, son hombres de grande estatura. ");
INSERT INTO spav1602p_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","También vimos allí gigantes, hijos de Anac, raza de los gigan­tes: y éramos nosotros, a nuestro parecer, como langostas; y así les parecíamos a ellos. ");
INSERT INTO spav1602p_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","ENTONCES toda la congrega- ción alzaron grita, y dieron voces: y el pueblo lloró aquella noche. ");
INSERT INTO spav1602p_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Y quejáronse contra Moisés y contra Aarón todos los hijos de Israel; y díjoles toda la multitud: ¡Quiera Dios qué muriéramos en la tierra de Egipto; quiera Dios qué muriéramos en este desierto! ");
INSERT INTO spav1602p_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","¿Y por qué nos trae el SEÑOR a esta tierra para caer a espada, y que nuestras esposas y nuestros chiquitos sean por presa? ¿no nos sería mejor volvernos a Egipto? ");
INSERT INTO spav1602p_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Y decían el uno al otro: Hagamos un capitán, y volvámo­nos a Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Entonces Moisés y Aarón cayeron sobre sus rostros delante de toda la asamblea de la congre­gación de los hijos de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Y Josué hijo de Nun, y Caleb hijo de Jefone, que eran de los que habían reconocido la tierra, rompieron sus vestiduras; ");
INSERT INTO spav1602p_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Y hablaron a toda la congrega­ción de los hijos de Israel, dicien­do: La tierra por donde pasamos para reconocerla, es tierra en gran manera buena. ");
INSERT INTO spav1602p_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Si el SEÑOR se agradare de nosotros, él nos meterá en esta tierra, y nos la entregará; tierra que fluye leche y miel. ");
INSERT INTO spav1602p_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Por tanto, no seáis rebeldes contra el SEÑOR, ni temáis al pueblo de esta tierra, porque nuestro pan son: su amparo se ha apartado de ellos, y con nosotros está el SEÑOR: no los temáis. ");
INSERT INTO spav1602p_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Entonces toda la multitud habló de apedrearlos con piedras. Mas la gloria del SEÑOR se mostró en el tabernáculo de la congregación a todos los hijos de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Y el SEÑOR dijo a Moisés: ¿Hasta cuándo me ha de irritar este pueblo? ¿hasta cuándo no me ha de creer con todas las señales que he hecho en medio de ellos? ");
INSERT INTO spav1602p_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Yo los heriré con pestilencia, y los desheredaré, y haré de ti una nación más grande y más fuerte que ellos. ");
INSERT INTO spav1602p_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Y Moisés respondió al SEÑOR: Oiránlo luego los egipcios, porque de en medio de ellos sacaste a este pueblo con tu fortaleza: ");
INSERT INTO spav1602p_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Y lo dirán a los habitadores de esta tierra; los cuales han oído que tú, oh SEÑOR, estabas en medio de este pueblo, que ojo a ojo aparecías tú, oh SEÑOR, y que tu nube estaba sobre ellos, y que de día ibas delante de ellos en columna de nube, y de noche en columna de fuego: ");
INSERT INTO spav1602p_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Y que has hecho morir a este pueblo como a un hombre: y las naciones que hubieren oído tu fama hablarán, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","Porque no pudo el SEÑOR meter este pueblo en la tierra de la cual les había jurado, los mató en el desierto. ");
INSERT INTO spav1602p_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Ahora, pues, yo te ruego que sea grande el poder de mi Señor, como lo hablaste, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","El SEÑOR, es tardo de ira y grande en misericordia, que per­dona la iniquidad y la rebelión, aunque de ningún modo tendrá por inocente al culpable; que visita la maldad de los padres sobre los hijos hasta los terceros y hasta los cuartos. ");
INSERT INTO spav1602p_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Perdona ahora la iniquidad de este pueblo según la grandeza de tu misericordia, y como has per­donado a este pueblo desde Egipto hasta aquí. ");
INSERT INTO spav1602p_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Entonces el SEÑOR dijo: Yo lo he perdonado conforme a tu dicho: ");
INSERT INTO spav1602p_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Mas tan cierto como vivo yo, toda la tierra será llena de la gloria del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Porque todos los que vieron mi gloria y mis señales que he hecho en Egipto y en el desierto, y me han tentado ya diez veces, y no han oído mi voz, ");
INSERT INTO spav1602p_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","No verán la tierra de la cual juré a sus padres: no, ninguno de los que me han irritado la verá. ");
INSERT INTO spav1602p_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Pero mi siervo Caleb, por cuanto hubo en él otro espíritu, y cumplió de ir en pos de mí, yo le meteré en la tierra donde entró, y su simiente la recibirá en heredad. ");
INSERT INTO spav1602p_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Ahora bien, el Amalecita y el cananeo habitan en el valle; vol­veos mañana, y partíos al desier­to, camino del mar Bermejo. ");
INSERT INTO spav1602p_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Y el SEÑOR habló a Moisés y a Aarón, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","¿Hasta cuándo oiré esta depravada multitud que murmu­ra contra mí, las querellas de los hijos de Israel, que de mí se que­jan? ");
INSERT INTO spav1602p_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Díles: Vivo yo, dice el SEÑOR, que según habéis hablado a mis oídos, así haré yo con vosotros: ");
INSERT INTO spav1602p_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","En este desierto caerán vues­tros cuerpos; todos vuestros con­tados según toda vuestra cuenta, de veinte años arriba, los cuales habéis murmurado contra mí; ");
INSERT INTO spav1602p_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Vosotros a la verdad no entra­réis en la tierra, por la cual alcé mi mano de haceros habitar en ella; exceptuando a Caleb hijo de Jefone, y a Josué hijo de Nun. ");
INSERT INTO spav1602p_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Mas vuestros chiquitos, de los cuales dijisteis que serán por presa, yo los introduciré, y ellos conocerán la tierra que vosotros despreciasteis. ");
INSERT INTO spav1602p_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Y en cuanto a vosotros, vues­tros cuerpos caerán en este desierto. ");
INSERT INTO spav1602p_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Y vuestros hijos andarán pas­toreando en el desierto cuarenta años, y ellos llevarán vuestras fornicaciones, hasta que vuestros cuerpos sean consumidos en el desierto. ");
INSERT INTO spav1602p_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Conforme al número de los días, de los cuarenta días en que reconocisteis la tierra, llevaréis vuestras iniquidades cuarenta años, un año por cada día; y conoceréis mi castigo. ");
INSERT INTO spav1602p_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Yo el SEÑOR he hablado; así haré a toda esta multitud perver­sa que se ha juntado contra mí; en este desierto serán consumi­dos, y ahí morirán. ");
INSERT INTO spav1602p_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Y los varones que Moisés envió a reconocer la tierra, y vueltos habían hecho murmurar contra él a toda la congregación, desacreditando aquel país, ");
INSERT INTO spav1602p_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","Aquellos varones que habían hablado mal de la tierra, murieron de plaga delante del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Mas Josué hijo de Nun, y Caleb hijo de Jefone, quedaron con vida de entre aquellos hom­bres que habían ido a reconocer la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Y Moisés dijo estas cosas a todos los hijos de Israel, y el pue­blo se enlutó mucho. ");
INSERT INTO spav1602p_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Y levantáronse por la mañana, y subieron a la cumbre del monte, diciendo: Henos aquí para subir al lugar del cual ha hablado el SEÑOR; porque hemos pecado. ");
INSERT INTO spav1602p_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Y dijo Moisés: ¿Por qué que­brantáis el dicho del SEÑOR? Esto tampoco os sucederá bien. ");
INSERT INTO spav1602p_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","No subáis, porque el SEÑOR no está en medio de vosotros, no seáis heridos delante de vuestros enemigos. ");
INSERT INTO spav1602p_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Porque el Amalecita y el cananeo están allí delante de vosotros, y caeréis a espada: pues por cuanto os habéis retraí­do de seguir al SEÑOR, por eso no será el SEÑOR con vosotros. ");
INSERT INTO spav1602p_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Sin embargo, se obstinaron en subir a la cima del monte: mas el arca del pacto del SEÑOR, y Moisés, no se apartaron de en medio del campo. ");
INSERT INTO spav1602p_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Y descendieron el Amalecita y el cananeo, que habitaban en aquel monte, e hiriéronlos y derrotáronlos, persiguiéndolos hasta Horma. ");
INSERT INTO spav1602p_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Y EL SEÑOR habló a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","Habla a los hijos de Israel, y díles: Cuando hubiereis entrado en la tierra de vuestras habitacio­nes, que yo os doy, ");
INSERT INTO spav1602p_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","E hiciereis ofrenda hecha por fuego al SEÑOR, ofrenda quemada, o sacrificio, por especial voto, o de vuestra voluntad, o para hacer en vuestras fiestas solemnes olor suave al SEÑOR, de vacas o de ovejas; ");
INSERT INTO spav1602p_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Entonces el que ofreciere su ofrenda al SEÑOR, traerá por presente una décima de un efa de flor de harina, amasada con la cuarta parte de un hin de aceite; ");
INSERT INTO spav1602p_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Y de vino para la libación ofre­cerás la cuarta parte de un hin, además de la ofrenda quemada o del sacrificio, por cada un cordero. ");
INSERT INTO spav1602p_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Y por cada carnero harás pre­sente de dos décimas de flor de harina, amasada con el tercio de un hin de aceite: ");
INSERT INTO spav1602p_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","Y de vino para la libación ofre­cerás el tercio de un hin, en olor suave al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Y cuando ofreciereis novillo en ofrenda quemada o sacrificio, por espe­cial voto, o de paces al SEÑOR, ");
INSERT INTO spav1602p_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","Ofrecerás con el novillo un presente de tres décimas de flor de harina, amasada con la mitad de un hin de aceite: ");
INSERT INTO spav1602p_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Y de vino para la libación ofrecerás la mitad de un hin, en ofrenda hecha por fuego de olor suave al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Así se hará con cada un buey, o carnero, o cordero, lo mismo de ovejas que de cabras. ");
INSERT INTO spav1602p_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Conforme al número así haréis con cada uno según el número de ellos. ");
INSERT INTO spav1602p_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Todo natural hará estas cosas así, para ofrecer ofrenda hecha por fuego, de olor suave al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Y cuando habitare con vosotros extranjero, o cualquiera que estuviere entre vosotros por vuestras edades, si hiciere ofren­da hecha por fuego, de olor suave al SEÑOR, como vosotros hiciereis, así hará él. ");
INSERT INTO spav1602p_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Una misma ordenanza tendréis vosotros de la congregación y el extranjero que con vosotros mora; ordenanza que será perpetua por vuestras edades: como voso­tros, así será el peregrino delante del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Una misma ley y un mismo derecho tendréis vosotros y el peregrino que con vosotros mora. ");
INSERT INTO spav1602p_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Y habló el SEÑOR a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","Habla a los hijos de Israel, y díles: Cuando hubiereis entrado en la tierra a la cual yo os traigo, ");
INSERT INTO spav1602p_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","Será que cuando comenzareis a comer del pan de la tierra, ofre­ceréis ofrenda al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","De lo primero que amasareis, ofreceréis una torta en ofrenda; como la ofrenda de la era, así la ofreceréis. ");
INSERT INTO spav1602p_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","De las primicias de vuestras masas daréis al SEÑOR ofrenda por vuestras generaciones. ");
INSERT INTO spav1602p_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Y cuando errareis, y no hicie­reis todos estos mandamientos que el SEÑOR ha dicho a Moisés, ");
INSERT INTO spav1602p_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","Todas las cosas que el SEÑOR os ha mandado por la mano de Moisés, desde el día que el SEÑOR lo mandó, y en adelante por vuestras edades, ");
INSERT INTO spav1602p_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","Será que, si algo fuere hecho por ignorancia sin el conocimiento de la congregación, toda la con­gregación ofrecerá un novillo por ofrenda quemada, en olor suave al SEÑOR, con su presente y su libación, conforme a la ley; y un macho cabrío en expiación. ");
INSERT INTO spav1602p_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Y el sacerdote hará expiación por toda la congregación de los hijos de Israel; y les será perdo­nado, porque yerro es: y ellos traerán sus ofrendas, ofrenda hecha por fuego al SEÑOR, y sus expiaciones delante del SEÑOR, por sus yerros: ");
INSERT INTO spav1602p_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Y será perdonado a toda la congregación de los hijos de Israel, y al extranjero que pere­grina entre ellos, por cuanto es yerro de todo el pueblo. ");
INSERT INTO spav1602p_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Y si una persona pecare por yerro, ofrecerá una cabra de un año por expiación. ");
INSERT INTO spav1602p_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Y el sacerdote hará expiación por la persona que habrá pecado por yerro, cuando pecare por yerro delante del SEÑOR, la reconciliará, y le será perdonado. ");
INSERT INTO spav1602p_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","El natural entre los hijos de Israel y el peregrino que habitare entre ellos, una misma ley ten­dréis para el que hiciere algo por yerro. ");
INSERT INTO spav1602p_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Mas la persona que hiciere algo con altiva mano, así el natu­ral como el extranjero, al SEÑOR injurió; y la tal persona será cortada de en medio de su pueblo. ");
INSERT INTO spav1602p_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Por cuanto tuvo en poco la palabra del SEÑOR, y dio por nulo su mandamiento, entera­mente será cortada la tal persona: su iniquidad será sobre ella. ");
INSERT INTO spav1602p_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Y estando los hijos de Israel en el desierto, hallaron un hom­bre que recogía leña en día de sábado. ");
INSERT INTO spav1602p_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Y los que le hallaron reco­giendo leña, trajéronle a Moisés y a Aarón, y a toda la congrega­ción: ");
INSERT INTO spav1602p_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Y pusiéronlo en la cárcel, por que no estaba declarado qué le habían de hacer. ");
INSERT INTO spav1602p_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Y el SEÑOR dijo a Moisés: Irremisiblemente muera aquel hombre; apedréelo con piedras toda la congregación fuera del campo. ");
INSERT INTO spav1602p_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Entonces lo sacó la congrega­ción fuera del campo, y apedreá­ronlo con piedras, y murió; como el SEÑOR mandó a Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Y el SEÑOR habló a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","Habla a los hijos de Israel, y díles que se hagan franjas en los remates de sus vestiduras, por sus generaciones; y pongan en cada pezuelo de los remates un cordón de azul: ");
INSERT INTO spav1602p_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Y serviros ha de pezuelo, para que cuando lo viereis, os acor­déis de todos los mandamientos del SEÑOR, para ponerlos por obra; y no miréis en pos de vues­tro corazón y de vuestros ojos, en pos de los cuales fornicáis: ");
INSERT INTO spav1602p_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Para que os acordéis, y hagáis todos mis mandamientos, y seáis santos a vuestro Dios. ");
INSERT INTO spav1602p_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Yo soy el SEÑOR vuestro Dios, que os saqué de la tierra de Egipto, para ser vuestro Dios: Yo soy el SEÑOR vuestro Dios. ");
INSERT INTO spav1602p_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Y CORÉ, hijo de Izhar, hijo de Coat, hijo de Leví; y Datán y Abiram, hijos de Eliab; y On, hijo de Pelet, de los hijos de Rubén, tomaron gente, ");
INSERT INTO spav1602p_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Y levantáronse contra Moisés con doscientos y cincuenta varo­nes de los hijos de Israel, prínci­pes de la asamblea, de los del consejo, varones de nombre; ");
INSERT INTO spav1602p_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Y se juntaron contra Moisés y Aarón, y les dijeron: Básteos, porque toda la congregación, todos ellos son santos, y en medio de ellos está el SEÑOR: ¿por qué, pues, os levantáis vosotros sobre la congregación del SEÑOR? ");
INSERT INTO spav1602p_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Y como lo oyó Moisés, echóse sobre su rostro; ");
INSERT INTO spav1602p_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Y habló a Coré y a toda su compañía, diciendo: Mañana mos­trará el SEÑOR quién es suyo, y al santo harálo llegar a sí; y al que él escogiere, él lo allegará a sí. ");
INSERT INTO spav1602p_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Haced esto: tomad incensarios, Coré y toda su compañía: ");
INSERT INTO spav1602p_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","Y poned fuego en ellos, y poned en ellos sahumerio delan­te del SEÑOR mañana; y será que el varón a quien el SEÑOR escogiere, aquel será el santo: básteos esto, hijos de Leví. ");
INSERT INTO spav1602p_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Dijo más Moisés a Coré: Oíd ahora, hijos de Leví: ");
INSERT INTO spav1602p_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","¿Os es poco que el Dios de Israel os haya apartado de la con­gregación de Israel, haciéndoos allegar a sí para que ministraseis en el servicio del tabernáculo del SEÑOR, y estuvieseis delante de la congregación para ministrar­les? ");
INSERT INTO spav1602p_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","¿Y que te hizo acercar a ti, y a todos tus hermanos los hijos de Leví contigo; para que procuréis también el sacerdocio? ");
INSERT INTO spav1602p_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Por tanto, tú y toda tu compañía sois los que os juntáis contra el SEÑOR: pues Aarón, ¿qué es para que contra él murmuréis? ");
INSERT INTO spav1602p_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Y envió Moisés a llamar a Datán y Abiram, hijos de Eliab; mas ellos respondieron: No ire­mos allá: ");
INSERT INTO spav1602p_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","¿Es poco que nos hayas hecho venir de una tierra que destila leche y miel, para hacernos morir en el desierto, sino que también te enseñorees de nosotros impe­riosamente? ");
INSERT INTO spav1602p_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Ni tampoco nos has metido tú en tierra que fluya leche y miel, ni nos has dado heredades de tie­rras y viñas: ¿has de arrancar los ojos de estos hombres? No subi­remos. ");
INSERT INTO spav1602p_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Entonces Moisés se enojó en gran manera, y dijo al SEÑOR: No mires a su presente: ni aun un asno he tomado de ellos, ni a nin­guno de ellos he hecho mal. ");
INSERT INTO spav1602p_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Después dijo Moisés a Coré: Tú y toda tu compañía, poneos mañana delante del SEÑOR; tú, y ellos, y Aarón: ");
INSERT INTO spav1602p_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Y tomad cada uno su incensa­rio, y poned sahumerio en ellos, y allegad delante del SEÑOR cada uno su incensario: doscien­tos y cincuenta incensarios: tú también, y Aarón, cada uno con su incensario. ");
INSERT INTO spav1602p_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Y tomaron cada uno su incen­sario, y pusieron en ellos fuego, y echaron en ellos sahumerio, y pusiéronse a la puerta del taber­náculo de la congregación con Moisés y Aarón. ");
INSERT INTO spav1602p_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Ya Coré había hecho juntar contra ellos toda la congregación a la puerta del tabernáculo de la congregación: entonces la gloria del SEÑOR apareció a toda la congregación. ");
INSERT INTO spav1602p_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Y el SEÑOR habló a Moisés y a Aarón, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","Apartaos de entre esta congre­gación, y consumirlos he en un momento. ");
INSERT INTO spav1602p_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Y ellos se echaron sobre sus rostros, y dijeron: Oh Dios, Dios de los espíritus de toda carne, ¿no es un hombre el que pecó? ¿y airar­te has tú contra toda la congrega­ción? ");
INSERT INTO spav1602p_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Entonces el SEÑOR habló a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","Habla a la congregación, diciendo: Apartaos de en derre­dor de la tienda de Coré, Datán, y Abiram. ");
INSERT INTO spav1602p_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Y Moisés se levantó, y fue a Datán y Abiram; y los ancianos de Israel fueron en pos de él. ");
INSERT INTO spav1602p_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Y él habló a la congregación, diciendo: Apartaos ahora de las tiendas de estos impíos hombres, y no toquéis ninguna cosa suya, por que no perezcáis en todos sus pecados. ");
INSERT INTO spav1602p_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Y apartáronse de las tiendas de Coré, de Datán, y de Abiram en derredor: y Datán y Abiram salieron y pusiéronse a las puer­tas de sus tiendas, con sus esposas, y sus hijos, y sus chiquitos. ");
INSERT INTO spav1602p_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Y dijo Moisés: En esto cono­ceréis que el SEÑOR me ha enviado para que hiciese todas estas cosas; que no de mi cora­zón las hice. ");
INSERT INTO spav1602p_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Si como mueren todos los hombres murieren éstos, o si fue­ren ellos visitados a la manera de todos los hombres, el SEÑOR no me envió. ");
INSERT INTO spav1602p_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Mas si el SEÑOR hiciere una nueva cosa, y la tierra abriere su boca, y los tragare con todas sus cosas, y descendieren vivos al abismo, entonces conoceréis que estos hombres irritaron al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Y aconteció, que en acabando él de hablar todas estas palabras, rompióse la tierra que estaba debajo de ellos: ");
INSERT INTO spav1602p_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Y abrió la tierra su boca, y tra­gólos a ellos, y a sus casas, y a todos los hombres de Coré, y a toda su hacienda. ");
INSERT INTO spav1602p_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Y ellos, con todo lo que tenían, descendieron vivos al abismo, y cubriólos la tierra, y perecieron de en medio de la congre­gación. ");
INSERT INTO spav1602p_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Y todo Israel, los que estaban en derredor de ellos, huyeron al grito de ellos; porque decían: No nos trague también la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Y salió fuego del SEÑOR, y consumió los doscientos y cin­cuenta hombres que ofrecían el sahumerio. ");
INSERT INTO spav1602p_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Entonces el SEÑOR habló a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","Di a Eleazar, hijo de Aarón sacerdote, que tome los incensa­rios de en medio del incendio, y derrame más allá el fuego; por­que son santificados: ");
INSERT INTO spav1602p_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Los incensarios de estos peca­dores contra sus almas: y harán de ellos planchas extendidas para cubrir el altar: por cuanto ofre­cieron con ellos delante del SEÑOR, son santificados; y serán por señal a los hijos de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Y el sacerdote Eleazar tomó los incensarios de latón con que los quemados habían ofreci­do; y extendiéronlos para cubrir el altar, ");
INSERT INTO spav1602p_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","En recuerdo a los hijos de Israel que ningún extraño que no sea de la simiente de Aarón, lle­gue a ofrecer sahumerio delante del SEÑOR, porque no sea como Coré, y como su compañía; según se lo dijo el SEÑOR por mano de Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","El día siguiente toda la congregación de los hijos de Israel murmuró contra Moisés y Aarón, diciendo: Vosotros habéis muerto al pueblo del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Y aconteció que, como se juntó la congregación contra Moisés y Aarón, miraron hacia el tabernáculo de la congregación, y he aquí la nube lo había cubier­to, y apareció la gloria del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Y vinieron Moisés y Aarón delante del tabernáculo de la congregación. ");
INSERT INTO spav1602p_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Y el SEÑOR habló a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","Apartaos de en medio de esta congregación, y consumirélos en un momento. Y ellos se echaron sobre sus rostros. ");
INSERT INTO spav1602p_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Y dijo Moisés a Aarón: Toma el incensario, y pon en él fuego del altar, y sobre él pon perfume, y ve presto a la congregación, y haz expiación por ellos; porque el furor ha salido de delante la faz del SEÑOR: la mortandad ha comenzado. ");
INSERT INTO spav1602p_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Entonces tomó Aarón el incensario, como Moisés dijo, y corrió en medio de la congrega­ción: y he aquí que la mortandad había comenzado en el pueblo: y él puso perfume, e hizo expia­ción por el pueblo. ");
INSERT INTO spav1602p_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Y púsose entre los muertos y los vivos; y cesó la mortandad. ");
INSERT INTO spav1602p_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Y los que murieron en aquella mortandad fueron catorce mil y setecientos, sin los muertos por el negocio de Coré. ");
INSERT INTO spav1602p_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Después se volvió Aarón a Moisés a la puerta del tabernáculo de la congregación, cuando la mortandad había cesado. ");
INSERT INTO spav1602p_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Y HABLÓ el SEÑOR a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","Habla a los hijos de Israel, y toma de ellos una vara por cada casa de los padres, de todos los príncipes de ellos, doce varas conforme a las casas de sus padres; y escribirás el nombre de cada uno sobre su vara. ");
INSERT INTO spav1602p_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Y escribirás el nombre de Aarón sobre la vara de Leví; por­que cada cabeza de familia de sus padres tendrá una vara. ");
INSERT INTO spav1602p_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Y las pondrás en el tabernáculo de la congregación delante del testimonio, donde yo me decla­raré a vosotros. ");
INSERT INTO spav1602p_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Y será, que el varón que yo escogiere, su vara florecerá: y haré cesar de sobre mí las quejas de los hijos de Israel, con que murmuran contra vosotros. ");
INSERT INTO spav1602p_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Y Moisés habló a los hijos de Israel, y todos los príncipes de ellos le dieron varas; cada príncipe por las casas de sus padres una vara, en todas doce varas; y la vara de Aarón estaba entre las varas de ellos. ");
INSERT INTO spav1602p_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Y Moisés puso las varas delan­te del SEÑOR en el tabernáculo de la congregación. ");
INSERT INTO spav1602p_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Y aconteció que el día siguien­te vino Moisés al tabernáculo de la congregación; y he aquí que la vara de Aarón de la casa de Leví había brotado, y echado flores, y arrojado renuevos, y producido almendras. ");
INSERT INTO spav1602p_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Entonces sacó Moisés todas las varas de delante del SEÑOR a todos los hijos de Israel; y ellos lo vieron, y tomaron cada uno su vara. ");
INSERT INTO spav1602p_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Y el SEÑOR dijo a Moisés: Vuelve la vara de Aarón delante del testimonio, para que se guarde por señal a los hijos rebeldes; y harás cesar sus quejas de sobre mí, porque no mueran. ");
INSERT INTO spav1602p_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","E hízolo Moisés: como le mandó el SEÑOR, así hizo. ");
INSERT INTO spav1602p_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Entonces los hijos de Israel hablaron a Moisés, diciendo: He aquí nosotros somos muertos, perdidos somos, todos nosotros somos perdidos. ");
INSERT INTO spav1602p_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Cualquiera que se llegare, el que se acercare al tabernáculo del SEÑOR morirá: ¿acabare­mos de perecer todos? ");
INSERT INTO spav1602p_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Y EL SEÑOR dijo a Aarón: Tú y tus hijos, y la casa de tu padre contigo, llevaréis el pecado del santuario: y tú y tus hijos contigo llevaréis el pecado de vuestro sacerdocio. ");
INSERT INTO spav1602p_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Y a tus hermanos también, la tribu de Leví, la tribu de tu padre, hazlos llegar a ti, y júntense con­tigo, y servirte han; y tú y tus hijos contigo serviréis delante del tabernáculo de la congrega­ción. ");
INSERT INTO spav1602p_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Y guardarán lo que tú ordenares, y el cargo de todo el tabernáculo: mas no llegarán a los vasos santos ni al altar, porque no mue­ran ellos y vosotros. ");
INSERT INTO spav1602p_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Se juntarán, pues, contigo, y tendrán el cargo del tabernáculo de la congregación en todo el servicio del tabernáculo; ningún extraño se ha de llegar a voso­tros. ");
INSERT INTO spav1602p_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Y tendréis la guarda del santua­rio, y la guarda del altar, para que no sea más la ira sobre los hijos de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Porque he aquí yo he tomado a vuestros hermanos los levitas de entre los hijos de Israel, dados a vosotros en don del SEÑOR, para que sirvan en el ministerio del tabernáculo de la congrega­ción. ");
INSERT INTO spav1602p_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Mas tú y tus hijos contigo guar­daréis vuestro sacerdocio en todo negocio del altar, y del velo adentro, y ministraréis. Yo os he dado en don el servicio de vues­tro sacerdocio; y el extraño que se llegare, morirá. ");
INSERT INTO spav1602p_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Dijo más el SEÑOR a Aarón: He aquí yo te he dado también la guarda de mis ofrendas: todas las cosas consagradas de los hijos de Israel te he dado por razón de la unción, y a tus hijos, por ordenanza perpetua. ");
INSERT INTO spav1602p_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Esto será tuyo de la ofrenda de las cosas santas reservadas del fuego: toda ofrenda de ellos, todo presente suyo, y toda expia­ción por el pecado de ellos, y toda expiación por la culpa de ellos, que me han de presentar, será cosa muy santa para ti y para tus hijos. ");
INSERT INTO spav1602p_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","En el santuario la comerás; todo varón comerá de ella: cosa santa será para ti. ");
INSERT INTO spav1602p_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Esto también será tuyo: la ofrenda elevada de sus dones, y todas las ofrendas mecidas de los hijos de Israel, he dado a ti y a tus hijos y a tus hijas contigo, por estatuto perpetuo: todo limpio en tu casa comerá de ellas. ");
INSERT INTO spav1602p_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","De aceite, y de mosto, y de trigo, todo lo más escogido, las primicias de ello, que presenta­rán al SEÑOR, a ti las he dado. ");
INSERT INTO spav1602p_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Las primicias de todas las cosas de la tierra de ellos, las cuales traerán al SEÑOR, serán tuyas: todo limpio en tu casa comerá de ellas. ");
INSERT INTO spav1602p_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Todo lo consagrado por voto en Israel será tuyo. ");
INSERT INTO spav1602p_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Todo lo que abriere matriz en toda carne que ofrecerán al SEÑOR, así de hombres como de animales, será tuyo: mas has de hacer redimir el primogénito del hombre: también harás redi­mir el primogénito de animal inmundo. ");
INSERT INTO spav1602p_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Y de un mes harás efectuar el rescate de ellos, conforme a tu estimación, por precio de cinco siclos, al siclo del santuario, que es de veinte óbolos. ");
INSERT INTO spav1602p_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Mas el primogénito de vaca, y el primogénito de oveja, y el pri­mogénito de cabra, no redimirás; santificados son: la sangre de ellos rociarás sobre el altar, y quemarás la grosura de ellos, ofrenda hecha por fuego en olor suave al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Y la carne de ellos será tuya: como el pecho de la mecedura y como la espaldilla derecha, será tuya. ");
INSERT INTO spav1602p_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Todas las ofrendas elevadas de las cosas santas, que los hijos de Israel ofrecieren al SEÑOR, helas dado para ti, y para tus hijos y para tus hijas contigo, por estatuto perpetuo: pacto de sal perpetuo es delante del SEÑOR para ti y para tu simiente contigo. ");
INSERT INTO spav1602p_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Y el SEÑOR dijo a Aarón: De la tierra de ellos no tendrás heredad, ni entre ellos tendrás parte: Yo soy tu parte y tu heredad en medio de los hijos de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Y he aquí yo he dado a los hijos de Leví todos los diezmos en Israel por heredad, por su ministerio, por cuanto ellos sir­ven en el ministerio del taberná­culo de la congregación. ");
INSERT INTO spav1602p_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Y no llegarán más los hijos de Israel al tabernáculo de la con­gregación, porque no lleven pecado, por el cual mueran. ");
INSERT INTO spav1602p_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Mas los levitas harán el ser­vicio del tabernáculo de la con­gregación, y ellos llevarán su iniquidad: estatuto perpetuo por vuestras edades; y no poseerán heredad entre los hijos de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Porque a los levitas he dado por heredad los diezmos de los hijos de Israel, que ofrecerán al SEÑOR en ofrenda; por lo cual les he dicho: Entre los hijos de Israel no poseerán heredad. ");
INSERT INTO spav1602p_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Y habló el SEÑOR a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","Así hablarás a los levitas, y les dirás: Cuando tomareis de los hijos de Israel los diezmos que os he dado de ellos por vuestra heredad, vosotros presentaréis de ellos en ofrenda mecida al SEÑOR el diezmo de los diez­mos. ");
INSERT INTO spav1602p_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Y se os contará vuestra ofren­da como grano de la era, y como acopio del lagar. ");
INSERT INTO spav1602p_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Así ofreceréis también voso­tros ofrenda al SEÑOR de todos vuestros diezmos que hubiereis recibido de los hijos de Israel; y daréis de ellos la ofrenda del SEÑOR a Aarón el sacerdote. ");
INSERT INTO spav1602p_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","De todos vuestros dones ofre­ceréis toda ofrenda al SEÑOR; de todo lo mejor de ellos ofrece­réis la porción que ha de ser con­sagrada. ");
INSERT INTO spav1602p_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Y les dirás: Cuando ofrecie­reis lo mejor de ellos, será conta­do a los levitas por fruto de la era, y como fruto del lagar. ");
INSERT INTO spav1602p_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Y lo comeréis en cualquier lugar, vosotros y vuestra familia: pues es vuestra remuneración por vuestro ministerio en el tabernáculo de la congregación. ");
INSERT INTO spav1602p_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Y cuando vosotros hubiereis ofrecido de ello lo mejor suyo, no llevaréis por ello pecado: y no habéis de contaminar las cosas santas de los hijos de Israel, y no moriréis. ");
INSERT INTO spav1602p_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Y EL SEÑOR habló a Moisés y a Aarón, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","Ésta es la ordenanza de la ley que el SEÑOR ha prescrito, diciendo: Di a los hijos de Israel que te traigan una vaca bermeja, perfecta, en la cual no haya falta, sobre la cual no se haya puesto yugo: ");
INSERT INTO spav1602p_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Y la daréis a Eleazar el sacer­dote, y él la sacará fuera del campo, y harála degollar en su presencia. ");
INSERT INTO spav1602p_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Y tomará Eleazar el sacerdote de su sangre con su dedo, y rociará hacia la delantera del tabernáculo de la congregación con la sangre de ella siete veces; ");
INSERT INTO spav1602p_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Y hará quemar la vaca ante sus ojos: su cuero y su carne y su sangre, con su estiércol, hará quemar. ");
INSERT INTO spav1602p_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Luego tomará el sacerdote palo de cedro, e hisopo, y escarlata, y lo echará en medio del fuego en que arde la vaca. ");
INSERT INTO spav1602p_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","El sacerdote lavará luego sus vestiduras, lavará también su carne con agua, y después entrará en el real; y será inmundo el sacerdote hasta la tarde. ");
INSERT INTO spav1602p_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Asimismo el que la quemó, lavará sus vestiduras en agua, tam­bién lavará en agua su carne, y será inmundo hasta la tarde. ");
INSERT INTO spav1602p_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Y un hombre limpio recogerá las cenizas de la vaca, y las pon­drá fuera del campo en lugar lim­pio, y las guardará la congrega­ción de los hijos de Israel para el agua de separación: es una expiación. ");
INSERT INTO spav1602p_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Y el que recogió las cenizas de la vaca, lavará sus vestiduras, y será inmundo hasta la tarde: y será a los hijos de Israel, y al extranjero que peregrina entre ellos, por estatuto perpetuo. ");
INSERT INTO spav1602p_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","El que tocare muerto de cual­quiera persona humana, siete días será inmundo: ");
INSERT INTO spav1602p_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Éste se purificará al tercer día con esta agua, y al séptimo día será limpio; y si al tercer día no se purificare, no será limpio al séptimo día. ");
INSERT INTO spav1602p_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Cualquiera que tocare en muerto, en persona de hombre que estuviere muerto, y no se purificare, el tabernáculo del SEÑOR contaminó; y aquella persona será cortada de Israel: por cuanto el agua de la separa­ción no fue rociada sobre él, inmundo será; y su inmundicia será sobre él. ");
INSERT INTO spav1602p_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Ésta es la ley para cuando alguno muriere en la tienda: cualquiera que entrare en la tien­da y todo el que estuviere en ella, será inmundo siete días. ");
INSERT INTO spav1602p_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Y todo vaso abierto, sobre el cual no hubiere tapadera bien ajustada, será inmundo. ");
INSERT INTO spav1602p_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Y cualquiera que tocare en muerto a espada sobre la faz del campo, o en muerto, o en hueso humano, o en sepulcro, siete días será inmundo. ");
INSERT INTO spav1602p_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Y para el inmundo tomarán de la ceniza de la quemada vaca de la expiación, y echarán sobre ella agua viva en un vaso: ");
INSERT INTO spav1602p_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Y un hombre limpio tomará hisopo, y mojarálo en el agua, y rociará sobre la tienda, y sobre todos los muebles, y sobre las personas que allí estuvieren, y sobre aquel que hubiere tocado el hueso, o el matado, o el muer­to, o el sepulcro: ");
INSERT INTO spav1602p_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Y el limpio rociará sobre el inmundo al tercero y al séptimo día: y cuando lo habrá purificado al día séptimo, él lavará luego sus vestiduras, y a sí mismo se lavará con agua, y será limpio a la tarde. ");
INSERT INTO spav1602p_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Y el que fuere inmundo, y no se purificare, la tal persona será cortada de entre la congregación, por cuanto contaminó el taberná­culo del SEÑOR: no fue rociada sobre él el agua de separación: es inmundo. ");
INSERT INTO spav1602p_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Y les será por estatuto perpe­tuo: también el que rociare el agua de la separación lavará sus vestiduras; y el que tocare el agua de la separación, será inmundo hasta la tarde. ");
INSERT INTO spav1602p_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Y todo lo que el inmundo tocare, será inmundo: y la perso­na que lo tocare, será inmunda hasta la tarde. ");
INSERT INTO spav1602p_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Y LLEGARON los hijos de Israel, toda la congregación, al desierto de Zin, en el mes primero, y asentó el pueblo en Cades; y allí murió Miriam, y fue allí sepultada. ");
INSERT INTO spav1602p_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Y como no hubiese agua para la congregación, juntáronse con­tra Moisés y Aarón. ");
INSERT INTO spav1602p_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Y regañó el pueblo con Moisés, y hablaron diciendo: ¡Quiera Dios que nosotros hubiéramos muerto cuando perecieron nuestros her­manos delante del SEÑOR! ");
INSERT INTO spav1602p_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","¿Y por qué hiciste venir la con­gregación del SEÑOR a este desierto, para que muramos aquí nosotros y nuestras bestias? ");
INSERT INTO spav1602p_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","¿Y por qué nos has hecho subir de Egipto, para traernos a este mal lugar? No es lugar de sementera, de higueras, de viñas, ni granadas: ni aun de agua para beber. ");
INSERT INTO spav1602p_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Y fuéronse Moisés y Aarón de delante de la asamblea a la puerta del tabernáculo de la con­gregación, y echáronse sobre sus rostros; y la gloria del SEÑOR apareció sobre ellos. ");
INSERT INTO spav1602p_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Y habló el SEÑOR a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","Toma la vara, y reune la asamblea, tú y Aarón tu herma­no, y hablad a la roca en ojos de ellos; y ella dará su agua, y les sacarás aguas de la roca, y darás de beber a la congregación, y a sus bestias. ");
INSERT INTO spav1602p_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Entonces Moisés tomó la vara de delante del SEÑOR, como él le mandó. ");
INSERT INTO spav1602p_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Y juntaron Moisés y Aarón la congregación delante de la roca, y díjoles: Oíd ahora, rebeldes: ¿os hemos de hacer salir aguas de esta roca? ");
INSERT INTO spav1602p_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Entonces alzó Moisés su mano, e hirió la roca con su vara dos veces: y salieron aguas en abundancia, y bebió la congregación, y sus bestias. ");
INSERT INTO spav1602p_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Y el SEÑOR dijo a Moisés y a Aarón: Por cuanto no creísteis en mí, para santificarme en ojos de los hijos de Israel, por tanto, no meteréis esta congregación en la tierra que les he dado. ");
INSERT INTO spav1602p_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Éstas son las aguas de Meriba, por las cuales contendieron los hijos de Israel con el SEÑOR, y él se santificó en ellos. ");
INSERT INTO spav1602p_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Y envió Moisés embajadores al rey de Edom desde Cades: Así dice Israel tu hermano: Tú has sabido todo el trabajo que nos ha venido: ");
INSERT INTO spav1602p_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Cómo nuestros padres des­cendieron a Egipto, y estuvimos en Egipto largo tiempo, y los egipcios nos maltrataron, y a nuestros padres; ");
INSERT INTO spav1602p_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Y clamamos al SEÑOR, el cual oyó nuestra voz, y envió ángel, y sacónos de Egipto; y he aquí estamos en Cades, ciudad al extremo de tus confines: ");
INSERT INTO spav1602p_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Rogámoste que pasemos por tu tierra; no pasaremos por labranza, ni por viña, ni bebere­mos agua de pozos: por el cami­no real iremos, sin apartarnos a la diestra ni a la siniestra, hasta que hayamos pasado tu término. ");
INSERT INTO spav1602p_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Y Edom le respondió: No pasarás por mi país, de otra manera saldré contra ti armado. ");
INSERT INTO spav1602p_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Y los hijos de Israel dijeron: Por el camino seguido iremos; y si bebiéremos tus aguas yo y mis ganados, daré el precio de ellas: ciertamente sin hacer otra cosa, pasaré de seguida. ");
INSERT INTO spav1602p_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Y él respondió: No pasarás. Y salió Edom contra él con mucho pueblo, y mano fuerte. ");
INSERT INTO spav1602p_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","No quiso, pues, Edom dejar pasar a Israel por su término, y apartóse Israel de él. ");
INSERT INTO spav1602p_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Y partidos de Cades los hijos de Israel, toda aquella congrega­ción, vinieron al monte de Hor. ");
INSERT INTO spav1602p_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Y el SEÑOR habló a Moisés y Aarón en el monte de Hor, en los confines de la tierra de Edom, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","Aarón será reunido a sus pue­blos; pues no entrará en la tierra que yo di a los hijos de Israel, por cuanto fuisteis rebeldes a mi mandamiento en las aguas de la rencilla. ");
INSERT INTO spav1602p_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Toma a Aarón y a Eleazar su hijo, y hazlos subir al monte de Hor; ");
INSERT INTO spav1602p_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Y haz desnudar a Aarón sus vestiduras, y viste de ellos a Eleazar su hijo; porque Aarón será reunido a su pueblo, y allí morirá. ");
INSERT INTO spav1602p_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Y Moisés hizo como el SEÑOR le mandó: y subieron al monte de Hor a ojos de toda la congregación. ");
INSERT INTO spav1602p_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Y Moisés hizo desnudar a Aarón de sus vestiduras y vistiólos a Eleazar su hijo: y Aarón murió allí en la cumbre del monte: y Moisés y Eleazar descendieron del monte. ");
INSERT INTO spav1602p_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Y viendo toda la congrega­ción que Aarón era muerto, hiciéronle duelo por treinta días todas las familias de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Y OYENDO el cananeo, el rey de Arad, el cual habitaba en el sur, que venía Israel por el camino de los centinelas, peleó con Israel, y tomó de él presa. ");
INSERT INTO spav1602p_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Entonces Israel hizo voto al SEÑOR, y dijo: Si en efecto entregares a este pueblo en mi mano, yo destruiré sus ciudades. ");
INSERT INTO spav1602p_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Y el SEÑOR escuchó la voz de Israel, y entregó al cananeo, y destruyólos a ellos y a sus ciuda­des; y llamó el nombre de aquel lugar Horma. ");
INSERT INTO spav1602p_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Y partieron del monte de Hor, camino del mar Bermejo, para rodear la tierra de Edom; y aba­tióse el ánimo del pueblo por el camino. ");
INSERT INTO spav1602p_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Y habló el pueblo contra Dios y Moisés: ¿Por qué nos hiciste subir de Egipto para que mura­mos en este desierto? que ni hay pan, ni agua, y nuestra alma tiene fastidio de este pan tan liviano. ");
INSERT INTO spav1602p_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Y el SEÑOR envió entre el pueblo serpientes ardientes, que mordían al pueblo: y murió mucho pueblo de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Entonces el pueblo vino a Moisés, y dijeron: Pecado hemos por haber hablado contra el SEÑOR, y contra ti: ruega al SEÑOR que quite de nosotros estas serpientes. Y Moisés oró por el pueblo. ");
INSERT INTO spav1602p_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Y el SEÑOR dijo a Moisés: Hazte una serpiente ardiente, y ponla sobre la bandera: y será que cualquiera que fuere mordi­do y mirare a ella, vivirá. ");
INSERT INTO spav1602p_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Y Moisés hizo una serpiente de latón, y la puso sobre un palo; y sucedió, que cuando una ser­piente había mordido a alguno, miraba a la serpiente de latón, y vivía. ");
INSERT INTO spav1602p_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Y partieron los hijos de Israel, y asentaron campo en Obot. ");
INSERT INTO spav1602p_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Y partidos de Obot, asenta­ron en Ije-abarim, en el desierto que está delante de Moab, al nacimiento del sol. ");
INSERT INTO spav1602p_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Partidos de allí, asentaron en la arroyada de Zared. ");
INSERT INTO spav1602p_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","De allí movieron, y asentaron de la otra parte de Arnón, que está en el desierto, y que sale del término del amorreo; porque Arnón es término de Moab, entre Moab y el amorreo. ");
INSERT INTO spav1602p_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Por tanto se dice en el libro de las batallas del SEÑOR: Lo que hizo en el mar Bermejo, y en los arroyos de Arnón: ");
INSERT INTO spav1602p_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","Y a la corriente de los arroyos que va a parar en Ar, y descansa en el término de Moab. ");
INSERT INTO spav1602p_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Y de allí vinieron a Beer: este es el pozo del cual el SEÑOR dijo a Moisés: Junta al pueblo, y les daré agua. ");
INSERT INTO spav1602p_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Entonces cantó Israel esta canción: Sube, oh pozo; a él cantad: ");
INSERT INTO spav1602p_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Pozo, el cual cavaron los señores; caváronlo los príncipes del pueblo, y el legislador, con sus bordones. Y del desierto vinieron a Mataná: ");
INSERT INTO spav1602p_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Y de Mataná a Nahaliel: y de Nahaliel a Bamot: ");
INSERT INTO spav1602p_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Y de Bamot al valle que está en los campos de Moab, y a la cumbre de Pisga, que mira a Jesimón. ");
INSERT INTO spav1602p_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Y envió Israel embajadores a Sehón, rey de los amorreos, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","Pasaré por tu tierra: no nos apartaremos por los labrados, ni por las viñas; no beberemos las aguas de los pozos: por el cami­no real iremos, hasta que pase­mos tu término. ");
INSERT INTO spav1602p_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Mas Sehón no dejó pasar a Israel por su término: antes juntó Sehón todo su pueblo, y salió contra Israel en el desierto: y vino a Jahaz, y peleó contra Israel. ");
INSERT INTO spav1602p_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","E hirióle Israel a filo de espa­da, y tomó su tierra desde Arnón hasta Jaboc, hasta los hijos de Amón: porque el término de los hijos de Amón era fuerte. ");
INSERT INTO spav1602p_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Y tomó Israel todas estas ciu­dades: y habitó Israel en todas las ciudades del amorreo, en Hesbón y en todas sus aldeas. ");
INSERT INTO spav1602p_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Porque Hesbón era la ciudad de Sehón, rey de los amorreos; el cual había tenido guerra antes con el rey de Moab, y tomado de su poder toda su tierra hasta Arnón. ");
INSERT INTO spav1602p_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Por tanto, dicen los proverbis­tas: Venid a Hesbón, edifíquese y repárese la ciudad de Sehón: ");
INSERT INTO spav1602p_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Que fuego salió de Hesbón, y llama de la ciudad de Sehón, y consumió a Ar de Moab, a los señores de los altos de Arnón. ");
INSERT INTO spav1602p_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","¡Ay de ti, Moab! Perecido has, pueblo de Quemos: puso sus hijos en huída, y sus hijas en cau­tividad, por Sehón rey de los amorreos. ");
INSERT INTO spav1602p_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Mas devastamos el reino de ellos; pereció Hesbón hasta Dibón, y destruimos hasta Nofa y Medeba. ");
INSERT INTO spav1602p_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Así habitó Israel en la tierra del amorreo. ");
INSERT INTO spav1602p_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Y envió Moisés a reconocer a Jazer; y tomaron sus aldeas, y echaron al amorreo que estaba allí. ");
INSERT INTO spav1602p_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Y volvieron, y subieron cami­no de Basán, y salió contra ellos Og rey de Basán, él y todo su pueblo, para pelear en Edrei. ");
INSERT INTO spav1602p_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Entonces el SEÑOR dijo a Moisés: No le tengas miedo, que en tu mano lo he dado, a él y a todo su pueblo, y a su tierra; y harás de él como hiciste de Sehón, rey de los amorreos, que habitaba en Hesbón. ");
INSERT INTO spav1602p_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","E hirieron a él, y a sus hijos, y a toda su gente, sin que le queda­ra uno, y poseyeron su tierra. ");
INSERT INTO spav1602p_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Y MOVIERON los hijos de Israel, y asentaron en los campos de Moab, de esta parte del Jordán de Jericó. ");
INSERT INTO spav1602p_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Y vio Balac, hijo de Zipor, todo lo que Israel había hecho al amorreo. ");
INSERT INTO spav1602p_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Y Moab temió mucho a causa del pueblo que era mucho; y angustióse Moab a causa de los hijos de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Y dijo Moab a los ancianos de Madián: Ahora lamerá esta gente todos nuestros contornos, como lame el buey la grama del campo. Y Balac, hijo de Zipor, era entonces rey de Moab. ");
INSERT INTO spav1602p_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Por tanto envió mensajeros a Balaam hijo de Beor, a Petor, que está junto al río en la tierra de los hijos de su pueblo, para que lo llamasen, diciendo: Un pueblo ha salido de Egipto, y he aquí cubre la faz de la tierra, y habita delante de mí: ");
INSERT INTO spav1602p_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Ven pues ahora, te ruego, mal­díceme este pueblo, porque es más fuerte que yo: quizá podré yo herirlo, y echarlo de la tierra: que yo sé que el que tú bendije­res, será bendito, y el que tú mal­dijeres, será maldito. ");
INSERT INTO spav1602p_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Y fueron los ancianos de Moab, y los ancianos de Madián, con las dádivas de adivinación en su mano, y llegaron a Balaam, y le dijeron las palabras de Balac. ");
INSERT INTO spav1602p_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Y él les dijo: Reposad aquí esta noche, y yo os referiré las palabras, como el SEÑOR me hablare. Así los príncipes de Moab se quedaron con Balaam. ");
INSERT INTO spav1602p_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Y vino Dios a Balaam, y díjo­le: ¿Qué varones son estos que están contigo? ");
INSERT INTO spav1602p_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Y Balaam respondió a Dios: Balac hijo de Zipor, rey de Moab, ha enviado a mí diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","He aquí este pueblo que ha salido de Egipto, cubre la faz de la tierra: ven pues ahora, y mal­dícemelo; quizá podré pelear con él, y echarlo. ");
INSERT INTO spav1602p_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Entonces dijo Dios a Balaam: No vayas con ellos, ni maldigas al pueblo; porque es bendito. ");
INSERT INTO spav1602p_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Así Balaam se levantó por la mañana, y dijo a los príncipes de Balac: Volveos a vuestra tierra, porque el SEÑOR no me quiere dejar ir con vosotros. ");
INSERT INTO spav1602p_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Y los príncipes de Moab se levantaron, y vinieron a Balac, y dijeron: Balaam no quiso venir con nosotros. ");
INSERT INTO spav1602p_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Y tornó Balac a enviar otra vez más príncipes, y más hono­rables que los otros. ");
INSERT INTO spav1602p_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Los cuales vinieron a Balaam, y dijéronle: Así dice Balac, hijo de Zipor: Ruégote que no dejes de venir a mí: ");
INSERT INTO spav1602p_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Porque sin duda te honraré mucho, y haré todo lo que me dijeres: ven pues ahora, maldíce­me a este pueblo. ");
INSERT INTO spav1602p_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Y Balaam respondió, y dijo a los siervos de Balac: Aunque Balac me diese su casa llena de plata y oro, no puedo traspasar la palabra del SEÑOR mi Dios, para hacer cosa chica ni grande. ");
INSERT INTO spav1602p_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Ruégoos por tanto ahora, que reposéis aquí esta noche, para que yo sepa qué me vuelve a decir el SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Y vino Dios a Balaam de noche, y díjole: Si vinieren a lla­marte hombres, levántate y ve con ellos: pero harás lo que yo te dijere. ");
INSERT INTO spav1602p_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Así Balaam se levantó por la mañana, y cinchó su asna, y fue con los príncipes de Moab. ");
INSERT INTO spav1602p_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Y el furor de Dios se encendió porque él iba; y el ángel del SEÑOR se puso en el camino por adversario suyo. Iba, pues, él montado sobre su asna, y con él dos mozos suyos. ");
INSERT INTO spav1602p_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Y el asna vio al ángel del SEÑOR, que estaba en el cami­no con su espada desnuda en su mano; y apartóse el asna del camino, e iba por el campo. Entonces hirió Balaam al asna para hacerla volver al camino. ");
INSERT INTO spav1602p_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Mas el ángel del SEÑOR se puso en una senda de viñas que tenía pared de una parte y pared de otra. ");
INSERT INTO spav1602p_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Y viendo el asna al ángel del SEÑOR, pegóse a la pared, y apretó contra la pared el pie de Balaam: y él volvió a herirla. ");
INSERT INTO spav1602p_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Y el ángel del SEÑOR pasó más allá, y púsose en una angos­tura, donde no había camino para apartarse ni a diestra ni a sinies­tra. ");
INSERT INTO spav1602p_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Y viendo el asna al ángel del SEÑOR, echóse debajo de Balaam: y enojóse Balaam, e hirió al asna con el palo. ");
INSERT INTO spav1602p_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Entonces el SEÑOR abrió la boca al asna, la cual dijo a Balaam: ¿Qué te he hecho, que me has herido estas tres veces? ");
INSERT INTO spav1602p_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Y Balaam respondió al asna: Porque te has burlado de mí: ¡si hubiera espada en mi mano, que ahora mismo te mataría! ");
INSERT INTO spav1602p_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Y el asna dijo a Balaam: ¿No soy yo tu asna? sobre mí has cabalgado desde que tú me tienes hasta este día; ¿he acostumbrado a hacerlo así contigo? Y él res­pondió: No. ");
INSERT INTO spav1602p_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Entonces el SEÑOR abrió los ojos a Balaam, y vio al ángel del SEÑOR que estaba en el cami­no, y tenía su espada desnuda en su mano. Y Balaam hizo reve­rencia, e inclinóse sobre su ros­tro. ");
INSERT INTO spav1602p_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Y el ángel del SEÑOR le dijo: ¿Por qué has herido tu asna estas tres veces? he aquí yo he salido para contrarrestarte, porque tu camino es perverso delante de mí: ");
INSERT INTO spav1602p_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","El asna me ha visto, y hase apartado luego de delante de mí estas tres veces: y si de mí no se hubiera apartado, yo también ahora te mataría a ti, y a ella deja­ría viva. ");
INSERT INTO spav1602p_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Entonces Balaam dijo al ángel del SEÑOR: He pecado, que no sabía que tú te ponías delante de mí en el camino: mas ahora, si te parece mal, yo me volveré. ");
INSERT INTO spav1602p_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Y el ángel del SEÑOR dijo a Balaam: Ve con esos hombres: pero la palabra que yo te dije­re, esa hablarás. Así Balaam fue con los príncipes de Balac. ");
INSERT INTO spav1602p_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Y oyendo Balac que Balaam venía, salió a recibirlo a la ciudad de Moab, que está junto al térmi­no de Arnón, que es el cabo de los confines. ");
INSERT INTO spav1602p_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Y Balac dijo a Balaam: ¿No envié yo a ti a llamarte? ¿por qué no has venido a mí? ¿no puedo yo honrarte? ");
INSERT INTO spav1602p_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Y Balaam respondió a Balac: He aquí yo he venido a ti: mas ¿podré ahora hablar alguna cosa? La palabra que Dios pusiere en mi boca, esa hablaré. ");
INSERT INTO spav1602p_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Y fue Balaam con Balac, y vinieron a la ciudad de Husot. ");
INSERT INTO spav1602p_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Y Balac hizo matar bueyes y ovejas, y envió a Balaam, y a los príncipes que estaban con él. ");
INSERT INTO spav1602p_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Y el día siguiente Balac tomó a Balaam, e hízolo subir a los altos de Baal, y desde allí vio la extremidad del pueblo. ");
INSERT INTO spav1602p_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Y BALAAM dijo a Balac: Edifícame aquí siete altares, y prepárame aquí siete becerros y siete carneros. ");
INSERT INTO spav1602p_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Y Balac hizo como le dijo Balaam: y ofrecieron Balac y Balaam un becerro y un carnero en cada altar. ");
INSERT INTO spav1602p_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Y Balaam dijo a Balac: Ponte junto a tu ofrenda quemada, y yo iré: quizá el SEÑOR me vendrá al encuentro, y cualquiera cosa que me mostrare, te la noticiaré. Y se fue a un lugar alto. ");
INSERT INTO spav1602p_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Y vino Dios al encuentro de Balaam, y éste le dijo: Siete alta­res he ordenado, y en cada altar he ofrecido un becerro y un car­nero. ");
INSERT INTO spav1602p_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Y el SEÑOR puso palabra en la boca de Balaam, y díjole: Vuelve a Balac, y has de hablar así. ");
INSERT INTO spav1602p_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Y volvió a él, y he aquí estaba él junto a su sacrificio quemado, él y todos los príncipes de Moab. ");
INSERT INTO spav1602p_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Y él tomó su parábola, y dijo: De Aram me trajo Balac, rey de Moab, de los montes del oriente: ven, maldíceme a Jacob; y ven, execra a Israel. ");
INSERT INTO spav1602p_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","¿Por qué maldeciré yo al que Dios no maldijo? ¿Y por qué he de execrar al que el SEÑOR no ha execrado? ");
INSERT INTO spav1602p_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Porque de la cumbre de las peñas lo veré, y desde los colla­dos lo miraré: He aquí un pueblo que habitará solo, y no será contado entre las naciones. ");
INSERT INTO spav1602p_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","¿Quién contará el polvo de Jacob, o el número de la cuarta parte de Israel? Muera mi perso­na de la muerte de los rectos, y mi postrimería sea como la suya. ");
INSERT INTO spav1602p_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Entonces Balac dijo a Balaam: ¿Qué me has hecho? hete tomado para que maldigas a mis enemigos, y he aquí has pro­ferido bendiciones. ");
INSERT INTO spav1602p_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Y él respondió, y dijo: ¿No observaré yo lo que el SEÑOR pusiere en mi boca para decirlo? ");
INSERT INTO spav1602p_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Y dijo Balac: Ruégote que vengas conmigo a otro lugar desde el cual lo veas; su extremi­dad solamente verás, que no lo verás todo; y desde allí me lo maldecirás. ");
INSERT INTO spav1602p_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Y llevólo al campo de Sofim, a la cumbre de Pisga, y edificó siete altares, y ofreció un becerro y un carnero en cada altar. ");
INSERT INTO spav1602p_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Entonces él dijo a Balac: Ponte aquí junto a tu ofrenda quemada, y yo iré a encontrar al SEÑOR allí. ");
INSERT INTO spav1602p_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Y el SEÑOR salió al encuen­tro de Balaam, y puso palabra en su boca, y díjole: Vuelve a Balac, y así has de decir. ");
INSERT INTO spav1602p_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Y vino a él, y he aquí que él estaba junto a su ofrenda quemada, y con él los príncipes de Moab: y díjole Balac: ¿Qué ha dicho el SEÑOR? ");
INSERT INTO spav1602p_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Entonces él tomó su parábola, y dijo: Balac, levántate y oye; escucha mis palabras, hijo de Zipor: ");
INSERT INTO spav1602p_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Dios no es hombre, para que mienta; ni hijo de hombre para que se arrepienta: ¿Él dijo, y no hará? ¿Habló, y no lo ejecutará? ");
INSERT INTO spav1602p_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","He aquí yo he recibido un mandato de bendecir y no podré revocarlo. ");
INSERT INTO spav1602p_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","No ha notado iniquidad en Jacob, ni ha visto perversidad en Israel: El SEÑOR su Dios es con él, y júbilo de rey en él. ");
INSERT INTO spav1602p_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Dios los ha sacado de Egipto; tiene fuerzas como de unicornio. ");
INSERT INTO spav1602p_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Porque en Jacob no hay agüero, ni adivinación en Israel: como ahora, será dicho de Jacob y de Israel: ¡Lo que ha hecho Dios! ");
INSERT INTO spav1602p_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","He aquí el pueblo, que como león se levantará, y como león se erguirá: no se echará hasta que coma la presa, y beba la sangre de los muertos. ");
INSERT INTO spav1602p_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Entonces Balac dijo a Balaam: Ya que no lo maldices, ni tampoco lo bendigas. ");
INSERT INTO spav1602p_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Y Balaam respondió, y dijo a Balac: ¿No te he dicho que todo lo que el SEÑOR me dijere, aquello tengo de hacer? ");
INSERT INTO spav1602p_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Y dijo Balac a Balaam: Ruégote que vengas, te llevaré a otro lugar; por ventura parecerá bien a Dios que desde allí me lo maldigas. ");
INSERT INTO spav1602p_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Y Balac llevó a Balaam a la cumbre de Peor, que mira hacia Jesimón. ");
INSERT INTO spav1602p_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Entonces Balaam dijo a Balac: Edifícame aquí siete alta­res, y prepárame aquí siete bece­rros y siete carneros. ");
INSERT INTO spav1602p_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Y Balac hizo como Balaam le dijo; y ofreció un becerro y un carnero en cada altar. ");
INSERT INTO spav1602p_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Y COMO vio Balaam que parecía bien al SEÑOR que él bendijese a Israel, no fue, como la primera y segunda vez, a encuentro de agüeros, sino que puso su rostro hacia el desierto; ");
INSERT INTO spav1602p_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Y alzando sus ojos, vio a Israel alojado por sus tribus; y el espíritu de Dios vino sobre él. ");
INSERT INTO spav1602p_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Entonces tomó su parábola, y dijo: Dijo Balaam hijo de Beor, y dijo el varón de ojos abiertos: ");
INSERT INTO spav1602p_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Dijo el que oyó las palabras de Dios, el que vio la visión del Todopoderoso; caído, mas abier­tos los ojos: ");
INSERT INTO spav1602p_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","¡Cuán hermosas son tus tien­das, oh Jacob, tus tabernáculos, oh Israel! ");
INSERT INTO spav1602p_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Como arroyos están extendi­das, como huertos junto al río, como lináloes plantados por el SEÑOR, como cedros junto a las aguas. ");
INSERT INTO spav1602p_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","De sus manos destilarán aguas, y su simiente será en muchas aguas: y ensalzarse ha su rey más que Agag, y su reino será ensal­zado. ");
INSERT INTO spav1602p_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Dios lo sacó de Egipto; tiene fuerzas como de unicornio: comerá a las naciones sus enemi­gas, y desmenuzará sus huesos, y asaeteará con sus saetas. ");
INSERT INTO spav1602p_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Se encorvará para echarse como león, y como leona; ¿quién lo despertará? Benditos los que te bendijeren, y malditos los que te maldijeren. ");
INSERT INTO spav1602p_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Entonces se encendió la ira de Balac contra Balaam, y batiendo sus palmas le dijo: Para maldecir a mis enemigos te he llamado, y he aquí los has resueltamente bendecido ya tres veces. ");
INSERT INTO spav1602p_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Húyete, por tanto, ahora a tu lugar: yo dije que te honraría, mas he aquí que el SEÑOR te ha privado de honra. ");
INSERT INTO spav1602p_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Y Balaam le respondió: ¿No lo declaré yo también a tus men­sajeros que me enviaste, dicien­do: ");
INSERT INTO spav1602p_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","Si Balac me diese su casa llena de plata y oro, yo no podré traspasar el dicho del SEÑOR para hacer cosa buena ni mala de mi arbitrio; mas lo que el SEÑOR hablare, eso diré yo? ");
INSERT INTO spav1602p_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","He aquí yo me voy ahora a mi pueblo: por tanto, ven, te indica­ré lo que este pueblo ha de hacer a tu pueblo en los postrimeros días. ");
INSERT INTO spav1602p_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Y tomó su parábola, y dijo: Dijo Balaam hijo de Beor, dijo el varón de ojos abiertos: ");
INSERT INTO spav1602p_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Dijo el que oyó las palabras de Dios, y el que sabe el conoci­miento del Altísimo, el que vio la visión del Todopoderoso; caído, mas abiertos los ojos: ");
INSERT INTO spav1602p_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Verélo, mas no ahora: lo mira­ré, mas no de cerca: saldrá Estrella de Jacob, y levanta­ráse Cetro de Israel, y herirá los cantones de Moab, y destruirá a todos los hijos de Set. ");
INSERT INTO spav1602p_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Y será tomada Edom, será también tomada Seir por sus ene­migos, e Israel se portará varonil­mente. ");
INSERT INTO spav1602p_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Y el de Jacob se enseñoreará, y destruirá de la ciudad lo que quedare. ");
INSERT INTO spav1602p_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Y viendo a Amalec, tomó su parábola, y dijo: Amalec, cabeza de naciones; mas su postrimería perecerá para siempre. ");
INSERT INTO spav1602p_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Y viendo al cineo, tomó su parábola, y dijo: Fuerte es tu habi­tación, pon en la roca tu nido: ");
INSERT INTO spav1602p_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Que el cineo será echado, cuando Asur te llevará cautivo. ");
INSERT INTO spav1602p_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Todavía tomó su parábola, y dijo: ¡Ay! ¿quién vivirá cuando hiciere Dios estas cosas? ");
INSERT INTO spav1602p_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Y vendrán navíos de la costa de Quitim, y afligirán a Asur, afligirán también a Eber: mas él también perecerá para siempre. ");
INSERT INTO spav1602p_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Entonces se levantó Balaam, y se fue, y volvióse a su lugar: y también Balac se fue por su camino. ");
INSERT INTO spav1602p_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Y REPOSÓ Israel en Sitim, y el pueblo empezó a fornicar con las hijas de Moab: ");
INSERT INTO spav1602p_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Las cuales llamaron al pueblo a los sacrificios de sus dioses: y el pueblo comió, e inclinóse a sus dioses. ");
INSERT INTO spav1602p_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Y allegóse el pueblo a Baal-­peor; y el furor del SEÑOR se encendió contra Israel. ");
INSERT INTO spav1602p_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Y el SEÑOR dijo a Moisés: Toma todos los príncipes del pueblo, y ahórcalos al SEÑOR delante del sol; y la ira del furor del SEÑOR se apartará de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Entonces Moisés dijo a los jue­ces de Israel: Matad cada uno a aquellos de los suyos que se han allegado a Baal-peor. ");
INSERT INTO spav1602p_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Y he aquí un varón de los hijos de Israel vino y trajo una madianita a sus hermanos, a ojos de Moisés y de toda la congrega­ción de los hijos de Israel, llorando ellos a la puerta del taberná­culo de la congregación. ");
INSERT INTO spav1602p_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Y viólo Finees, hijo de Eleazar, hijo de Aarón el sacer­dote, y levantóse de en medio de la congregación, y tomó una lanza en su mano: ");
INSERT INTO spav1602p_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","Y fue tras el varón de Israel a la tienda, y alanceólos a ambos, al varón de Israel, y a la mujer por su vientre. Y cesó la mortandad de los hijos de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Y murieron de aquella mortan­dad veinte y cuatro mil. ");
INSERT INTO spav1602p_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Entonces el SEÑOR habló a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","Finees, hijo de Eleazar, hijo de Aarón el sacerdote, ha hecho tornar mi furor de los hijos de Israel, llevado de celo entre ellos: por lo cual yo no he consumido en mi celo a los hijos de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Por tanto díles: He aquí yo establezco mi pacto de paz con él; ");
INSERT INTO spav1602p_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Y tendrá él, y su simiente des­pués de él, el pacto del sacerdo­cio perpetuo; por cuanto tuvo celo por su Dios, e hizo expia­ción por los hijos de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Y el nombre del varón muer­to, que fue muerto con la madianita, era Zimri hijo de Salu, jefe de una familia de la tribu de Simeón. ");
INSERT INTO spav1602p_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Y el nombre de la mujer madianita muerta, era Cozbi, hija de Zur, príncipe de pueblos, padre de familia en Madián. ");
INSERT INTO spav1602p_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Y el SEÑOR habló a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","Hostilizaréis a los madianitas, y los heriréis: ");
INSERT INTO spav1602p_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","Por cuanto ellos os afligieron a vosotros con sus ardides, con que os han engañado en el nego­cio de Peor, y en el negocio de Cozbi, hija del príncipe de Madián, su hermana, la cual fue muerta el día de la mortandad por causa de Peor. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Y ACONTECIÓ después de la mortandad, que el SEÑOR habló a Moisés, y a Eleazar hijo del sacerdote Aarón, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","Tomad la suma de toda la con­gregación de los hijos de Israel, de veinte años arriba, por las casas de sus padres, todos los que puedan salir a la guerra en Israel. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Y Moisés y Eleazar el sacerdo­te hablaron con ellos en los cam­pos de Moab, junto al Jordán de Jericó, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","Contaréis el pueblo de veinte años arriba, como mandó el SEÑOR a Moisés y a los hijos de Israel, que habían salido de tierra de Egipto. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Rubén primogénito de Israel: los hijos de Rubén: Enoc, del cual era la familia de los enoquitas; de Falú, la familia de los faluitas; ");
INSERT INTO spav1602p_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","De Hesrón, la familia de los hesronitas; de Carmi, la familia de los carmitas. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Éstas son las familias de los rubenitas: y sus contados fueron cuarenta y tres mil setecientos y treinta. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Y los hijos de Falú: Eliab. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Y los hijos de Eliab: Nemuel, y Datán, y Abiram. Estos Datán y Abiram fueron los del consejo de la congregación, que hicieron el motín contra Moisés y Aarón con la compañía de Coré, cuando se amotinaron contra el SEÑOR; ");
INSERT INTO spav1602p_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Que la tierra abrió su boca y tragó a ellos y a Coré, cuando aquella compañía murió, cuando consumió el fuego doscientos y cincuenta varones, los cuales fueron por señal. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Mas los hijos de Coré no murieron. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Los hijos de Simeón por sus familias: de Nemuel, la familia de los nemuelitas; de Jamín, la familia de los jaminitas; de Jaquín, la familia de los jaquínitas; ");
INSERT INTO spav1602p_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","De Zera, la familia de los zeraitas; de Saúl, la familia de los saulitas. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Éstas son las familias de los simeonitas, veinte y dos mil y doscientos. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Los hijos de Gad por sus familias: de Zefón, la familia de los zefonitas; de Aggi, la familia de los aggitas; de Suni, la familia de los sunitas; ");
INSERT INTO spav1602p_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","De Ozni, la familia de los oznitas; de Eri, la familia de los eritas; ");
INSERT INTO spav1602p_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","De Aroz, la familia de los aroditas; de Areli, la familia de los arelitas. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Éstas son las familias de Gad, por sus contados, cuarenta mil y quinientos. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Los hijos de Judá: Er y Onán; y Er y Onán murieron en la tierra de Canaán. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Y fueron los hijos de Judá por sus familias: de Sela, la familia de los selaitas; de Fares, la familia de los faresitas; de Zera, la familia de los zeraitas. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Y fueron los hijos de Fares: de Hesrón, la familia de los hesronitas; de Hamul, la familia de los hamulitas. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Éstas son las familias de Judá, por sus contados, setenta y seis mil y quinientos. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Los hijos de Isacar por sus familias: de Tola, la familia de los tolaitas; de Puá la familia de los puanitas; ");
INSERT INTO spav1602p_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","De Jasub, la familia de los jasubitas; de Simron, la familia de los simronitas. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Éstas son las familias de Isacar, por sus contados, sesenta y cuatro mil y trescien­tos. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Los hijos de Zabulón por sus familias: de Sered, la familia de los sereditas; de Elón, la familia de los elonitas; de Jalel, la fami­lia de los jalelitas. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Éstas son las familias de los zabulonitas, por sus contados, sesenta mil y quinientos. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Los hijos de José por sus familias: Manasés y Efraím. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Los hijos de Manasés: de Maquir, la familia de los maquiritas; y Maquir engendró a Galaad; de Galaad, la familia de los galaaditas. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Éstos son los hijos de Galaad: de Jezer, la familia de los jezeritas; de Helec, la familia de los helecitas; ");
INSERT INTO spav1602p_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","De Asriel, la familia de los asrielitas; de Siquem, la familia de los siquemitas; ");
INSERT INTO spav1602p_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","De Semida, la familia de los semidaitas; de Hefer, la familia de los heferitas. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Y Zelofehad, hijo de Hefer, no tuvo hijos sino hijas: y los nombres de las hijas de Zelofehad fueron Maala, y Noa, y Hogla, y Milca, y Tirsa. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Éstas son las familias de Manasés; y sus contados, cin­cuenta y dos mil y setecientos. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Éstos son los hijos de Efraím por sus familias: de Sutela, la familia de los sutelaítas; de Bequer, la familia de los bequeritas; de Tahan, la familia de los tahanitas. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Y estos son los hijos de Sutela: de Herán, la familia de los heranitas. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Éstas son las familias de los hijos de Efraím, por sus conta­dos, treinta y dos mil y quinien­tos. Éstos son los hijos de José por sus familias. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Los hijos de Benjamín por sus familias: de Bela, la familia de los belaitas; de Asbel, la familia de los asbelitas; de Ahiram, la familia de los ahiramitas; ");
INSERT INTO spav1602p_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","De Sufam, la familia de los sufamitas; de Hufam, la familia de los hufamitas. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Y los hijos de Bela fueron Ard y Naamán: de Ard, la familia de los arditas; de Naamán, la fami­lia de los naamanitas. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Éstos son los hijos de Benjamín por sus familias; y sus contados, cuarenta y cinco mil y seiscientos. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Éstos son los hijos de Dan por sus familias: de Suham, la fami­lia de los suhamitas. Éstas son las familias de Dan por sus fami­lias. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Todas las familias de los suhamitas, por sus contados, sesenta y cuatro mil y cuatro­cientos. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Los hijos de Aser por sus familias: de Imna, la familia de los imnaitas; de Isui, la familia de los isuitas; de Beria, la fami­lia de los beriaitas. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Los hijos de Beria: de Heber, la familia de los heberitas; de Malquiel, la familia de los malquielitas. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Y el nombre de la hija de Aser fue Sera. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Éstas son las familias de los hijos de Aser, por sus contados, cincuenta y tres mil y cuatrocien­tos. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Los hijos de Neftalí por sus familias: de Jahzeel, la familia de los jahzeelitas; de Guni, la fami­lia de los gunitas; ");
INSERT INTO spav1602p_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","De Jeser, la familia de los jeseritas; de Sillem, la familia de los sillemitas. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Éstas son las familias de Neftalí por sus familias; y sus contados, cuarenta y cinco mil y cuatrocientos. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Éstos son los contados de los hijos de Israel, seiscientos y un mil setecientos y treinta. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Y habló el SEÑOR a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","A estos se repartirá la tierra en heredad, por la cuenta de los nombres. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","A los más darás mayor heredad, y a los menos menor; y a cada uno se le dará su heredad conforme a sus contados. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","No obstante la tierra será reparti­da por suerte; y por los nombres de las tribus de sus padres here­darán. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Conforme a la suerte será repartida su heredad entre el grande y el pequeño. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Y los contados de los levitas por sus familias son estos: de Gersón, la familia de los gersonitas; de Coat, la familia de los coatitas; de Merari, la familia de los meraritas. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Éstas son las familias de los levitas: la familia de los libnitas, la familia de los hebronitas, la familia de los mahalitas, la familia de los musitas, la familia de los coritas. Y Coat engendró a Amram. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Y la esposa de Amram se llamó Jocabed, hija de Leví, la cual nació a Leví en Egipto: ésta parió de Amram a Aarón y a Moisés, y a Miriam su hermana. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Y a Aarón nacieron Nadab y Abiú, Eleazar e Itamar. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Mas Nadab y Abiú murieron, cuando ofrecieron fuego extraño delante del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Y los contados de los levitas fueron veinte y tres mil, todos varones de un mes arriba: porque no fueron contados entre los hijos de Israel, por cuanto no les había de ser dada heredad entre los hijos de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Éstos son los contados por Moisés y Eleazar el sacerdote, los cuales contaron los hijos de Israel en los campos de Moab, junto al Jordán de Jericó. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Y entre estos ninguno hubo de los contados por Moisés y Aarón el sacerdote, los cuales contaron a los hijos de Israel en el desierto de Sinaí. ");
INSERT INTO spav1602p_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Porque el SEÑOR les dijo: Han de morir en el desierto: y no quedó varón de ellos, sino Caleb hijo de Jefone, y Josué hijo de Nun. ");
INSERT INTO spav1602p_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Y LAS hijas de Zelofehad, hijo de Hefer, hijo de Galaad, hijo de Maquir, hijo de Manasés, de las familias de Manasés, hijo de José, los nombres de las cuales eran Maala, y Noa, y Hogla, y Milca, y Tirsa, llegaron; ");
INSERT INTO spav1602p_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Y presentáronse delante de Moisés, y delante del sacerdote Eleazar, y delante de los príncipes, y de toda la congregación, a la puerta del tabernáculo de la congregación, y dijeron: ");
INSERT INTO spav1602p_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","Nuestro padre murió en el desierto, el cual no estuvo en la compañía que se reunió contra el SEÑOR en la compañía de Coré: sino que en su pecado murió, y no tuvo hijos. ");
INSERT INTO spav1602p_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","¿Por qué será quitado el nom­bre de nuestro padre de entre su familia, por no haber tenido hijo? Danos heredad entre los herma­nos de nuestro padre. ");
INSERT INTO spav1602p_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Y Moisés llevó su causa delan­te del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Y el SEÑOR respondió a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","Bien dicen las hijas de Zelofehad: has de darles posesión de heredad entre los hermanos de su padre; y traspasarás la heredad de su padre a ellas. ");
INSERT INTO spav1602p_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Y a los hijos de Israel hablarás, diciendo: Cuando alguno murie­re sin hijos, traspasaréis su herencia a su hija: ");
INSERT INTO spav1602p_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Y si no tuviere hija, daréis su herencia a sus hermanos: ");
INSERT INTO spav1602p_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Y si no tuviere hermanos, daréis su herencia a los herma­nos de su padre. ");
INSERT INTO spav1602p_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Y si su padre no tuviere her­manos, daréis su herencia a su pariente más cercano de su lina­je, el cual la poseerá: y será a los hijos de Israel por estatuto de derecho, como el SEÑOR mandó a Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Y el SEÑOR dijo a Moisés: Sube a este monte Abarim, y verás la tierra que he dado a los hijos de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Y después que la habrás visto, tú también serás reunido a tus pueblos, como fue reunido tu hermano Aarón: ");
INSERT INTO spav1602p_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Pues fuisteis rebeldes a mi dicho en el desierto de Zin, en la rencilla de la congregación, para santificarme en las aguas a ojos de ellos. Éstas son las aguas de la rencilla de Cades en el desierto de Zin. ");
INSERT INTO spav1602p_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Entonces respondió Moisés al SEÑOR, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","Ponga el SEÑOR, Dios de los espíritus de toda carne, varón sobre la congregación, ");
INSERT INTO spav1602p_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","Que salga delante de ellos, y que entre delante de ellos, que los saque y los introduzca; por­que la congregación del SEÑOR no sea como ovejas sin pastor. ");
INSERT INTO spav1602p_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Y el SEÑOR dijo a Moisés: Toma a Josué hijo de Nun, varón en el cual hay espíritu, y pondrás tu mano sobre él; ");
INSERT INTO spav1602p_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Y ponerlo has delante de Eleazar el sacerdote, y delante de toda la congregación; y le darás órdenes en presencia de ellos. ");
INSERT INTO spav1602p_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Y pondrás de tu dignidad sobre él, para que toda la congre­gación de los hijos de Israel le obedezcan. ");
INSERT INTO spav1602p_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Y él estará delante de Eleazar el sacerdote, y a él preguntará por el juicio del Urim delante del SEÑOR: por el dicho de él sal­drán, y por el dicho de él entra­rán, él, y todos los hijos de Israel con él, y toda la congregación. ");
INSERT INTO spav1602p_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Y Moisés hizo como el SEÑOR le había mandado; que tomó a Josué, y le puso delante de Eleazar el sacerdote, y de toda la congregación: ");
INSERT INTO spav1602p_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Y puso sobre él sus manos, y dióle órdenes, como el SEÑOR había mandado por mano de Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Y HABLÓ el SEÑOR a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","Manda a los hijos de Israel, y díles: Mi ofrenda, mi pan con mis ofrendas hechas por fuego en olor a mí agradable, guarda­réis, ofreciéndomelo a su tiempo. ");
INSERT INTO spav1602p_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Y les dirás: Ésta es la ofrenda hecha por fuego que ofreceréis al SEÑOR: dos corderos sin tacha de un año, cada un día, para una ofrenda quemada continua. ");
INSERT INTO spav1602p_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","El un cordero ofrecerás por la mañana, y el otro cordero ofrece­rás entre las dos tardes: ");
INSERT INTO spav1602p_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Y la décima de un efa de flor de harina, amasada con una cuar­ta de un hin de aceite molido, en presente. ");
INSERT INTO spav1602p_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Es ofrenda quemada continua, que fue hecho en el monte de Sinaí en olor de suavidad, ofrenda hecha por fuego al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Y su libación, la cuarta de un hin con cada cordero: derramarás libación de superior vino al SEÑOR en el santuario. ");
INSERT INTO spav1602p_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Y ofrecerás el segundo cordero entre las dos tardes: conforme a la ofrenda de la mañana, y conforme a su libación ofrecerás, ofrenda hecha por fuego en olor de suavidad al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","Mas el día del sábado dos cor­deros de un año sin defecto, y dos décimas de flor de harina amasada con aceite, por presen­te, con su libación: ");
INSERT INTO spav1602p_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Es la ofrenda quemada de cada sába­do, además de la ofrenda quemada conti­nua y su libación. ");
INSERT INTO spav1602p_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","Y en los principios de vues­tros meses ofreceréis en ofrenda quemada al SEÑOR dos becerros de la vacada, y un carnero, y siete corderos de un año sin defecto; ");
INSERT INTO spav1602p_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Y tres décimas de flor de hari­na amasada con aceite, por pre­sente con cada becerro; y dos décimas de flor de harina amasa­da con aceite, por presente con cada carnero; ");
INSERT INTO spav1602p_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","Y una décima de flor de hari­na amasada con aceite, en ofren­da por presente con cada corde­ro: ofrenda quemada de olor suave, ofrenda hecha por fuego al SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Y sus libaciones de vino, medio hin con cada becerro, y el tercio de un hin con cada carne­ro, y la cuarta de un hin con cada cordero. Éste es la ofrenda quemada de cada mes por todos los meses del año. ");
INSERT INTO spav1602p_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Y un macho cabrío en expia­ción se ofrecerá al SEÑOR, ade­más de la ofrenda quemada continua con su libación. ");
INSERT INTO spav1602p_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","Mas en el mes primero, a los catorce del mes será la pascua del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Y a los quince días de este mes, la solemnidad: por siete días se comerán panes sin levadura. ");
INSERT INTO spav1602p_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","El primer día, santa convoca­ción; ninguna obra servil haréis: ");
INSERT INTO spav1602p_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Y ofreceréis por ofrenda hecha por fuego en ofrenda quemada al SEÑOR, dos becerros de la vacada, y un carnero, y siete cor­deros de un año: sin defecto los tomaréis: ");
INSERT INTO spav1602p_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Y su presente de harina ama­sada con aceite: tres décimas con cada becerro, y dos décimas con cada carnero ofreceréis; ");
INSERT INTO spav1602p_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","Con cada uno de los siete cor­deros ofreceréis una décima; ");
INSERT INTO spav1602p_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Y un macho cabrío por expia­ción, para reconciliaros. ");
INSERT INTO spav1602p_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Esto ofreceréis además de la ofrenda quemada de la mañana, que es para una ofrenda quemada continua. ");
INSERT INTO spav1602p_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Conforme a esto ofreceréis cada uno de los siete días, vianda y ofrenda hecha por fuego en olor de suavidad al SEÑOR; ofrecerse ha, además de la ofrenda quemada continua, con su libación. ");
INSERT INTO spav1602p_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Y el séptimo día tendréis santa convocación: ninguna obra servil haréis. ");
INSERT INTO spav1602p_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","Además el día de las primi­cias, cuando ofreciereis presente nuevo al SEÑOR en vuestras semanas, tendréis santa convoca­ción: ninguna obra servil haréis: ");
INSERT INTO spav1602p_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Pero ofreceréis la ofrenda quemada, en olor de suavidad al SEÑOR, dos becerros de la vacada, un carnero, siete corderos de un año: ");
INSERT INTO spav1602p_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Y el presente de ellos, flor de harina amasada con aceite, tres décimas con cada becerro, dos décimas con cada carnero, ");
INSERT INTO spav1602p_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","Con cada uno de los siete cor­deros una décima; ");
INSERT INTO spav1602p_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Un macho cabrío, para hacer expiación por vosotros: ");
INSERT INTO spav1602p_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Los ofreceréis, además de la ofrenda quemada continua con sus pre­sentes, y sus libaciones: sin defecto los tomaréis. ");
INSERT INTO spav1602p_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","Y EL séptimo mes, al primero del mes tendréis santa convocación: ninguna obra servil haréis; os será día de sonar las trompetas. ");
INSERT INTO spav1602p_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Y ofreceréis ofrenda quemada por olor de suavidad al SEÑOR, un becerro de la vacada, un carnero, siete corderos de un año sin defecto; ");
INSERT INTO spav1602p_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Y el presente de ellos, de flor de harina amasada con aceite, tres décimas con cada becerro, dos décimas con cada carnero, ");
INSERT INTO spav1602p_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","Y con cada uno de los siete cor­deros, una décima; ");
INSERT INTO spav1602p_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Y un macho cabrío por expia­ción, para reconciliaros; ");
INSERT INTO spav1602p_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Además de la ofrenda quemada del mes, y su presente, y la ofrenda quemada continua y su presente, y sus libaciones, conforme a su ley, por ofrenda encendida al SEÑOR en olor de suavidad. ");
INSERT INTO spav1602p_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","Y en el diez de este mes séptimo tendréis santa convocación, y afligiréis vuestras almas: ningu­na obra haréis: ");
INSERT INTO spav1602p_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Y ofreceréis en ofrenda quemada al SEÑOR por olor de suavidad, un becerro de la vacada, un carnero, siete corderos de un año; sin defecto los tomaréis: ");
INSERT INTO spav1602p_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Y sus presentes, flor de harina amasada con aceite, tres décimas con cada becerro, dos décimas con cada carnero, ");
INSERT INTO spav1602p_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","Y con cada uno de los siete corderos, una décima; ");
INSERT INTO spav1602p_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Un macho cabrío por expia­ción: además de la ofrenda de las expiaciones por el pecado, y de la ofrenda quemada continua, y de sus presentes, y de sus libaciones. ");
INSERT INTO spav1602p_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","También a los quince días del mes séptimo tendréis santa con­vocación; ninguna obra servil haréis, y celebraréis solemnidad al SEÑOR por siete días; ");
INSERT INTO spav1602p_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Y ofreceréis una ofrenda quemada, una ofrenda encendida al SEÑOR en olor de suavidad, trece becerros de la vacada, dos carneros, cator­ce corderos de un año: han de ser sin defecto; ");
INSERT INTO spav1602p_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Y los presentes de ellos, de flor de harina amasada con acei­te, tres décimas con cada uno de los trece becerros, dos décimas con cada uno de los dos carneros, ");
INSERT INTO spav1602p_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","Y con cada uno de los catorce corderos, una décima; ");
INSERT INTO spav1602p_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Y un macho cabrío por expia­ción: además de la ofrenda quemada continua, su presente y su libación. ");
INSERT INTO spav1602p_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","Y el segundo día, doce becerros de la vacada, dos carneros, catorce corderos de un año sin defecto; ");
INSERT INTO spav1602p_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Y sus presentes y sus libacio­nes con los becerros, con los car­neros, y con los corderos, según el número de ellos, conforme a la ley; ");
INSERT INTO spav1602p_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Y un macho cabrío por expiación: además de la ofrenda quemada continua, y su presente y su libación. ");
INSERT INTO spav1602p_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","Y el día tercero, once bece­rros, dos carneros, catorce corde­ros de un año sin defecto; ");
INSERT INTO spav1602p_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","Y sus presentes y sus libacio­nes con los becerros, con los car­neros, y con los corderos, según el número de ellos, conforme a la ley; ");
INSERT INTO spav1602p_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Y un macho cabrío por expiación: además de la ofrenda quemada continua, y su presente y su libación. ");
INSERT INTO spav1602p_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","Y el cuarto día, diez becerros, dos carneros, catorce corderos de un año sin defecto; ");
INSERT INTO spav1602p_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","Sus presentes y sus libaciones con los becerros, con los carne­ros, y con los corderos, según el número de ellos, conforme a la ley; ");
INSERT INTO spav1602p_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Y un macho cabrío por expia­ción: además de la ofrenda quemada continua, su presente y su libación. ");
INSERT INTO spav1602p_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","Y el quinto día, nueve bece­rros, dos carneros, catorce corde­ros de un año sin defecto; ");
INSERT INTO spav1602p_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","Y sus presentes y sus libacio­nes con los becerros, con los car­neros, y con los corderos, según el número de ellos, conforme a la ley; ");
INSERT INTO spav1602p_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Y un macho cabrío por expiación: además de la ofrenda quemada continua, su presente y su libación. ");
INSERT INTO spav1602p_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","Y el sexto día, ocho becerros, dos carneros, catorce corderos de un año sin defecto; ");
INSERT INTO spav1602p_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","Y sus presentes y sus libacio­nes con los becerros, con los car­neros, y con los corderos, según el número de ellos, conforme a la ley; ");
INSERT INTO spav1602p_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Y un macho cabrío por expia­ción: además de la ofrenda quemada continua, su presente y sus libacio­nes. ");
INSERT INTO spav1602p_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","Y el séptimo día, siete bece­rros, dos carneros, catorce corde­ros de un año sin defecto; ");
INSERT INTO spav1602p_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","Y sus presentes y sus libacio­nes con los becerros, con los car­neros, y con los corderos, según el número de ellos, conforme a la ley; ");
INSERT INTO spav1602p_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Y un macho cabrío por expia­ción: además de la ofrenda quemada continua, con su presente y su liba­ción. ");
INSERT INTO spav1602p_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","El octavo día tendréis una asamblea solemne: ninguna obra servil haréis: ");
INSERT INTO spav1602p_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Pero ofreceréis una ofrenda quemada, una ofrenda encendida de olor suave al SEÑOR, un novillo, un carne­ro, siete corderos de un año sin defecto; ");
INSERT INTO spav1602p_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Sus presentes y sus libaciones con el novillo, con el carnero, y con los corderos, según el núme­ro de ellos, conforme a la ley; ");
INSERT INTO spav1602p_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Y un macho cabrío por expia­ción: además de la ofrenda quemada continua, con su presente y su liba­ción. ");
INSERT INTO spav1602p_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Éstas cosas ofreceréis al SEÑOR en vuestras fiestas solemnes, además de vuestros votos, y de vuestras ofrendas libres, para vuestros holocaustos, y para vuestros presentes, y para vues­tras libaciones, y para vuestras paces. ");
INSERT INTO spav1602p_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Y Moisés dijo a los hijos de Israel, conforme a todo lo que el SEÑOR le había mandado. ");
INSERT INTO spav1602p_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Y HABLÓ Moisés a los príncipes de las tribus de los hijos de Israel, diciendo: Esto es lo que el SEÑOR ha mandado. ");
INSERT INTO spav1602p_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Cuando alguno hiciere voto al SEÑOR, o hiciere juramento ligando su alma con obligación, no violará su palabra: hará conforme a todo lo que salió de su boca. ");
INSERT INTO spav1602p_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Mas la mujer, cuando hiciere voto al SEÑOR, y se ligare con obligación en casa de su padre, en su mocedad; ");
INSERT INTO spav1602p_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","Si su padre oyere su voto, y la obligación con que ligó su alma, y su padre callare a ello, todos los votos de ella serán firmes, y toda obligación con que hubiere liga­do su alma, firme será. ");
INSERT INTO spav1602p_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Mas si su padre le vedare el día que oyere todos sus votos y sus obligaciones, con que ella hubie­re ligado su alma, no serán fir­mes; y el SEÑOR la perdonará, por cuanto su padre le vedó. ");
INSERT INTO spav1602p_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Y si fuere casada, e hiciere votos, o pronunciare de sus labios cosa con que obligue su alma; ");
INSERT INTO spav1602p_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","Si su marido lo oyere, y cuan­do lo oyere callare a ello, los votos de ella serán firmes, y la obligación con que ligó su alma, firme será. ");
INSERT INTO spav1602p_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Pero si cuando su marido lo oyó, le vedó, entonces el voto que ella hizo, y lo que pronunció de sus labios con que ligó su alma, será nulo; y el SEÑOR lo perdonará. ");
INSERT INTO spav1602p_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Mas todo voto de viuda, o repudiada, con que ligare su alma, será firme. ");
INSERT INTO spav1602p_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","Y si hubiere hecho voto en casa de su marido, y hubiere ligado su alma con obligación de juramento, ");
INSERT INTO spav1602p_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","Si su marido oyó, y calló a ello, y no le vedó; entonces todos sus votos serán firmes, y toda obligación con que hubiere liga­do su alma, firme será. ");
INSERT INTO spav1602p_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Mas si su marido los anuló el día que los oyó; todo lo que salió de sus labios cuanto a sus votos, y cuanto a la obligación de su alma, será nulo; su marido los anuló, y el SEÑOR la perdonará. ");
INSERT INTO spav1602p_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Todo voto, o todo juramento obligándose a afligir el alma, su marido lo confirmará, o su mari­do lo anulará. ");
INSERT INTO spav1602p_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Pero si su marido callare a ello de día en día, entonces con­firmó todos sus votos, y todas las obligaciones que están sobre ella: confirmólas, por cuanto calló a ello el día que lo oyó. ");
INSERT INTO spav1602p_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Mas si las anulare después de haberlas oído, entonces él llevará el pecado de ella. ");
INSERT INTO spav1602p_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Éstas son las ordenanzas que el SEÑOR mandó a Moisés entre el varón y su esposa, entre el padre y su hija, durante su moce­dad en casa de su padre. ");
INSERT INTO spav1602p_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Y EL SEÑOR habló a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","Haz la venganza de los hijos de Israel sobre los madianitas; des­pués serás recogido a tus pue­blos. ");
INSERT INTO spav1602p_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Entonces Moisés habló al pue­blo, diciendo: Armaos algunos de vosotros para la guerra, e irán contra Madián, y harán la ven­ganza del SEÑOR en Madián. ");
INSERT INTO spav1602p_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Mil de cada tribu de todas las tribus de los hijos de Israel, enviaréis a la guerra. ");
INSERT INTO spav1602p_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Así fueron dados de los milla­res de Israel, mil por cada tribu, doce mil a punto de guerra. ");
INSERT INTO spav1602p_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Y Moisés los envió a la guerra: mil de cada tribu envió: y Finees, hijo de Eleazar sacerdo­te, fue a la guerra con los santos instrumentos, con las trompetas en su mano para tocar. ");
INSERT INTO spav1602p_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Y pelearon contra Madián, como el SEÑOR lo mandó a Moisés, y mataron a todo varón. ");
INSERT INTO spav1602p_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Mataron también, entre los muertos de ellos, a los reyes de Madián: Evi, y Recem, y Zur, y Hur, y Reba, cinco reyes de Madián, a Balaam también, hijo de Beor, mataron a espada. ");
INSERT INTO spav1602p_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Y llevaron cautivas los hijos de Israel las mujeres de los madianitas, y sus chiquitos y todas sus bestias, y todos sus ganados; y arrebataron toda su hacienda. ");
INSERT INTO spav1602p_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Y abrasaron con fuego todas sus ciudades, aldeas y castillos. ");
INSERT INTO spav1602p_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Y tomaron todo el despojo, y toda la presa, así de hombres como de bestias. ");
INSERT INTO spav1602p_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","Y trajeron a Moisés, y a Eleazar el sacerdote, y a la con­gregación de los hijos de Israel, los cautivos y la presa y los des­pojos, al campo en los llanos de Moab, que están junto al Jordán de Jericó. ");
INSERT INTO spav1602p_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Y salieron Moisés y Eleazar el sacerdote, y todos los príncipes de la congregación, a recibirlos fuera del campo. ");
INSERT INTO spav1602p_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Y enojóse Moisés con los oficiales del ejército, los capitanes sobre miles y capitanes sobre cientos, que venían de la batalla. ");
INSERT INTO spav1602p_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Y díjoles Moisés: ¿Todas las mujeres habéis reservado? ");
INSERT INTO spav1602p_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","He aquí ellas fueron a los hijos de Israel, por consejo de Balaam, para causar prevarica­ción contra el SEÑOR en el negocio de Peor; por lo que hubo mortandad en la congregación del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Matad pues ahora todos los varones entre los niños: matad también toda mujer que haya conocido varón carnalmente. ");
INSERT INTO spav1602p_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Y todas las niñas entre las mujeres, que no hayan conocido ayuntamiento de varón, os reser­varéis vivas. ");
INSERT INTO spav1602p_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Y vosotros quedaos fuera del campo siete días: y todos los que hubieren matado persona, y cual­quiera que hubiere tocado muer­to, os purificaréis al tercero y al séptimo día, vosotros y vuestros cautivos. ");
INSERT INTO spav1602p_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Asimismo purificaréis toda vestidura, y toda prenda de pieles, y toda obra de pelos de cabra, y todo vaso de madera. ");
INSERT INTO spav1602p_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Y Eleazar el sacerdote dijo a los hombres de guerra que vení­an de la guerra: Ésta es la orde­nanza de la ley que el SEÑOR ha mandado a Moisés: ");
INSERT INTO spav1602p_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Ciertamente el oro, y la plata, latón, hierro, estaño, y plomo, ");
INSERT INTO spav1602p_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","Todo lo que resiste el fuego, por fuego lo haréis pasar, y será limpio, bien que en las aguas de purificación habrá de purificarse: mas haréis pasar por agua todo lo que no aguanta el fuego. ");
INSERT INTO spav1602p_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Además lavaréis vuestras vestiduras el séptimo día, y así seréis limpios; y después entraréis en el campo. ");
INSERT INTO spav1602p_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Y el SEÑOR habló a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","Toma la cuenta de la presa que se ha hecho, así de las perso­nas como de las bestias, tú y el sacerdote Eleazar, y las cabezas de los padres de la congregación: ");
INSERT INTO spav1602p_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Y partirás por mitad la presa entre los que pelearon, los que salieron a la guerra, y toda la congregación. ");
INSERT INTO spav1602p_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Y apartarás para el SEÑOR el tributo de los hombres de guerra, que salieron a la guerra: de qui­nientos uno, así de las personas como de los bueyes, de los asnos, y de las ovejas: ");
INSERT INTO spav1602p_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","De la mitad de ellos lo toma­rás; y darás a Eleazar el sacerdo­te la ofrenda del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Y de la mitad perteneciente a los hijos de Israel tomarás uno de cincuenta, de las personas, de los bueyes, de los asnos, y de las ovejas, de todo animal; y los darás a los levitas, que tienen la guarda del tabernáculo del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","E hicieron Moisés y Eleazar el sacerdote como el SEÑOR mandó a Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Y fue la presa, el resto de la presa que tomaron los hombres de guerra, seiscientas y setenta y cinco mil ovejas, ");
INSERT INTO spav1602p_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","Y setenta y dos mil bueyes, ");
INSERT INTO spav1602p_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","Y sesenta y un mil asnos; ");
INSERT INTO spav1602p_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","Y en cuanto a personas, de mujeres que no habían conocido ayuntamiento de varón, en todas treinta y dos mil. ");
INSERT INTO spav1602p_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Y la mitad, la parte de los que habían salido a la guerra, fue el número de trescientas treinta y siete mil y quinientas ovejas. ");
INSERT INTO spav1602p_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","Y el tributo para el SEÑOR de las ovejas, fue seiscientas setenta y cinco. ");
INSERT INTO spav1602p_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","Y de los bueyes, treinta y seis mil: y de ellos el tributo para el SEÑOR, setenta y dos. ");
INSERT INTO spav1602p_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","Y de los asnos, treinta mil y quinientos: y de ellos el tributo para el SEÑOR, sesenta y uno. ");
INSERT INTO spav1602p_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","Y de las personas, diez y seis mil: y de ellas el tributo para el SEÑOR, treinta y dos personas. ");
INSERT INTO spav1602p_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Y dio Moisés el tributo, por elevada ofrenda al SEÑOR, a Eleazar el sacerdote, como el SEÑOR lo mandó a Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Y de la mitad para los hijos de Israel, que apartó Moisés de los hombres que habían ido a la gue­rra; ");
INSERT INTO spav1602p_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","(La mitad para la congrega­ción fue: de las ovejas, trescien­tas treinta y siete mil y quinien­tas; ");
INSERT INTO spav1602p_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","Y de los bueyes, treinta y seis mil; ");
INSERT INTO spav1602p_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","Y de los asnos, treinta mil y quinientos; ");
INSERT INTO spav1602p_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","Y de las personas, diez y seis mil:) ");
INSERT INTO spav1602p_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","De la mitad, pues, para los hijos de Israel tomó Moisés uno de cada cincuenta, así de las per­sonas como de los animales, y diólos a los levitas, que tenían la guarda del tabernáculo del SEÑOR; como el SEÑOR lo había mandado a Moisés. ");
INSERT INTO spav1602p_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Y llegaron a Moisés los jefes de los millares de aquel ejército, los tribunos y centuriones; ");
INSERT INTO spav1602p_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","Y dijeron a Moisés: Tus sier­vos han tomado razón de los hombres de guerra que están en nuestro poder, y ninguno ha fal­tado de nosotros. ");
INSERT INTO spav1602p_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Por lo cual hemos ofrecido al SEÑOR ofrenda, cada uno de lo que ha hallado, joyas de oro, cadenas, y brazaletes, anillos, zarcillos, y lingotes, para hacer expiación por nuestras almas delante del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Y Moisés y el sacerdote Eleazar recibieron el oro de ellos, alhajas, todas elaboradas. ");
INSERT INTO spav1602p_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Y todo el oro de la ofrenda que ofrecieron al SEÑOR de los tribunos y centuriones, fue diez y seis mil setecientos y cincuenta siclos. ");
INSERT INTO spav1602p_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Los hombres del ejército habían pillado cada uno para sí. ");
INSERT INTO spav1602p_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Recibieron, pues, Moisés y el sacerdote Eleazar, el oro de los tribunos y centuriones, y trajé­ronlo al tabernáculo de la con­gregación, por memoria de los hijos de Israel delante del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Y LOS hijos de Rubén y los hijos de Gad tenían una muy grande muchedumbre de ganado; los cuales viendo la tierra de Jazer y de Galaad, parecióles el país lugar de ganado. ");
INSERT INTO spav1602p_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Y vinieron los hijos de Gad y los hijos de Rubén, y hablaron a Moisés, y a Eleazar el sacerdote, y a los príncipes de la congrega­ción, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","Atarot, y Dibón, y Jazer, y Nimra, y Hesbón, y Eleale, y Sabán, y Nebo, y Beón, ");
INSERT INTO spav1602p_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","La tierra que el SEÑOR hirió delante de la congregación de Israel, es tierra de ganado, y tus siervos tienen ganado. ");
INSERT INTO spav1602p_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Por tanto, dijeron, si hallamos gracia en tus ojos, dése esta tierra a tus siervos en heredad, y no nos hagas pasar el Jordán. ");
INSERT INTO spav1602p_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Y respondió Moisés a los hijos de Gad y a los hijos de Rubén: ¿Vendrán vuestros hermanos a la guerra, y vosotros os quedaréis aquí? ");
INSERT INTO spav1602p_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","¿Y por qué prevenís el ánimo de los hijos de Israel, para que no pasen a la tierra que les ha dado el SEÑOR? ");
INSERT INTO spav1602p_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Así hicieron vuestros padres, cuando los envié desde Cades-­barnea para que viesen la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Que subieron hasta la arroyada de Escol, y después que vieron la tierra, preocuparon el ánimo de los hijos de Israel, para que no viniesen a la tierra que el SEÑOR les había dado. ");
INSERT INTO spav1602p_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Y el furor del SEÑOR se encendió entonces, y juró dicien­do: ");
INSERT INTO spav1602p_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","Que no verán los varones que subieron de Egipto de veinte años arriba, la tierra por la cual juré a Abraham, Isaac, y Jacob, por cuanto no fueron perfectos en pos de mí; ");
INSERT INTO spav1602p_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","Excepto Caleb, hijo de Jefone Cenezeo, y Josué hijo de Nun, que fueron perfectos en pos del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Y el furor del SEÑOR se encendió en Israel, e hízolos andar errantes cuarenta años por el desierto, hasta que fue acabada toda aquella generación, que había hecho mal delante del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Y he aquí vosotros habéis sucedido en lugar de vuestros padres, prole de hombres peca­dores, para añadir aún a la ira del SEÑOR contra Israel. ");
INSERT INTO spav1602p_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Si os volviereis de en pos de él, él volverá otra vez a dejaros en el desierto, y destruiréis a todo este pueblo. ");
INSERT INTO spav1602p_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Entonces ellos se allegaron a él, y dijeron: Edificaremos aquí majadas para nuestro ganado, y ciudades para nuestros niños; ");
INSERT INTO spav1602p_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Y nosotros nos armaremos, e iremos con diligencia delante de los hijos de Israel, hasta que los metamos en su lugar: y nuestros niños quedarán en ciudades fuer­tes a causa de los moradores del país. ");
INSERT INTO spav1602p_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","No volveremos a nuestras casas hasta que los hijos de Israel posean cada uno su heredad. ");
INSERT INTO spav1602p_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Porque no tomaremos heredad con ellos al otro lado del Jordán ni adelante, por cuanto tendremos ya nuestra heredad de estotra parte del Jordán al orien­te. ");
INSERT INTO spav1602p_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Entonces les respondió Moisés: Si lo hiciereis así, si os apercibiereis para ir delante del SEÑOR a la guerra, ");
INSERT INTO spav1602p_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","Y pasareis todos vosotros armados el Jordán delante del SEÑOR, hasta que haya echado a sus enemigos de delante de sí, ");
INSERT INTO spav1602p_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","Y sea el país sojuzgado delan­te del SEÑOR; luego volveréis, y seréis libres de culpa para con el SEÑOR, y para con Israel; y esta tierra será vuestra en heredad delante del SEÑOR. ");
INSERT INTO spav1602p_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Mas si así no lo hiciereis, he aquí habréis pecado al SEÑOR; y sabed que os alcanzará vuestro pecado. ");
INSERT INTO spav1602p_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Edificaos ciudades para vues­tros niños, y majadas para vues­tras ovejas, y haced lo que ha salido de vuestra boca. ");
INSERT INTO spav1602p_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Y hablaron los hijos de Gad y los hijos de Rubén a Moisés, diciendo: Tus siervos harán como mi señor ha mandado. ");
INSERT INTO spav1602p_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Nuestros niños, nuestras esposas, nuestros ganados, y todas nuestras bestias, estarán ahí en las ciudades de Galaad; ");
INSERT INTO spav1602p_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","Y tus siervos, armados todos de guerra, pasarán delante del SEÑOR a la guerra, de la mane­ra que mi señor dice. ");
INSERT INTO spav1602p_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Entonces los encomendó Moisés a Eleazar el sacerdote, y a Josué hijo de Nun, y a los prín­cipes de los padres de las tribus de los hijos de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Y díjoles Moisés: Si los hijos de Gad y los hijos de Rubén, pasaren con vosotros el Jordán, armados todos de guerra delante del SEÑOR, luego que el país fuere sojuzgado delante de voso­tros, les daréis la tierra de Galaad en posesión: ");
INSERT INTO spav1602p_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Mas si no pasaren armados con vosotros, entonces tendrán posesión entre vosotros en la tie­rra de Canaán. ");
INSERT INTO spav1602p_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Y los hijos de Gad y los hijos de Rubén respondieron, dicien­do: Haremos lo que el SEÑOR ha dicho a tus siervos. ");
INSERT INTO spav1602p_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Nosotros pasaremos armados delante del SEÑOR a la tierra de Canaán, y la posesión de nuestra heredad será de esta parte del Jordán. ");
INSERT INTO spav1602p_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Así les dio Moisés a los hijos de Gad y a los hijos de Rubén, y a la media tribu de Manasés hijo de José, el reino de Sehón rey amorreo, y el reino de Og rey de Basán, la tierra con sus ciuda­des y términos, las ciudades del país alrededor. ");
INSERT INTO spav1602p_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Y los hijos de Gad edificaron a Dibón, y a Atarot, y a Aroer, ");
INSERT INTO spav1602p_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Y a Atrot, Sofan, y a Jazer, y a Jogbaa, ");
INSERT INTO spav1602p_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Y a Bet-nimra, y a Betarán: ciudades fuertes, y también majadas para ovejas. ");
INSERT INTO spav1602p_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Y los hijos de Rubén edifica­ron a Hesbón, y a Eleale, y a Quiriataim, ");
INSERT INTO spav1602p_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Y a Nebo, y a Baal-meón, (mudados los nombres), y a Sibma: y pusieron nombres a las ciudades que edificaron. ");
INSERT INTO spav1602p_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Y los hijos de Maquir hijo de Manasés fueron a Galaad, y tomáronla, y echaron al amorreo que estaba en ella. ");
INSERT INTO spav1602p_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Y Moisés dio Galaad a Maquir hijo de Manasés, el cual habitó en ella. ");
INSERT INTO spav1602p_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","También Jair hijo de Manasés fue y tomó sus aldeas, y púsoles por nombre Havot-jair. ");
INSERT INTO spav1602p_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Asimismo Noba fue y tomó a Kenat y sus aldeas, y llamóle Noba, conforme a su nombre. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","ÉSTAS SON las estancias de los hijos de Israel, los cuales salieron de la tierra de Egipto por sus ejércitos, bajo la conducta de Moisés y Aarón. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Y Moisés escribió sus salidas conforme a sus jornadas por mandato del SEÑOR. Éstas, pues, son sus estancias con arre­glo a sus partidas. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","De Rameses partieron en el mes primero, a los quince días del mes primero: el segundo día de la pascua salieron los hijos de Israel con mano alta, a ojos de todos los egipcios. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","Estaban enterrando los egipcios los que el SEÑOR había muerto de ellos, a todo pri­mogénito; habiendo el SEÑOR hecho también juicios en sus dio­ses. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Partieron, pues, los hijos de Israel de Rameses, y asentaron campo en Sucot. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Y partiendo de Sucot, asen­taron en Etam, que está al cabo del desierto. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Y partiendo de Etam, volvie­ron sobre Pi-hahirot, que está delante de Baalsefón, y asenta­ron delante de Migdol. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Y partiendo de Pi-hahirot, pasaron por medio del mar al desierto, y anduvieron camino de tres días por el desierto de Etam, y asentaron en Mara. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Y partiendo de Mara, vinieron a Elim, donde había doce fuentes de aguas, y setenta palmeras; y asentaron allí. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Y partidos de Elim, asentaron junto al mar Bermejo. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Y partidos del mar Bermejo, asentaron en el desierto de Sin. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Y partidos del desierto de Sin, asentaron en Dofca. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Y partidos de Dofca, asenta­ron en Alús. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Y partidos de Alús, asentaron en Refidim, donde el pueblo no tuvo aguas para beber. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Y partidos de Refidim, asen­taron en el desierto de Sinaí. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Y partidos del desierto de Sinaí, asentaron en Kibrot-­hataava. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Y partidos de Kibrot-hataa­va, asentaron en Haserot. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Y partidos de Haserot, asen­taron en Ritma. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Y partidos de Ritma, asenta­ron en Rimón-peres. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Y partidos de Rimón-peres, asentaron en Libna. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Y partidos de Libna, asenta­ron en Rissa. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Y partidos de Rissa, asentaron en Ceelata, ");
INSERT INTO spav1602p_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Y partidos de Ceelata, asen­taron en el monte de Sefer. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Y partidos del monte de Sefer, asentaron en Harada. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Y partidos de Harada, asenta­ron en Macelot. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Y partidos de Macelot, asen­taron en Tahat. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Y partidos de Tahat, asenta­ron en Tara. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Y partidos de Tara, asentaron en Mitca. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Y partidos de Mitca, asenta­ron en Hasmona. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Y partidos de Hasmona, asen­taron en Moserot. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Y partidos de Moserot, asen­taron en Bene-jaacán. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Y partidos de Bene-jaacán, asentaron en el monte de Gidgad. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Y partidos del monte de Gidgad, asentaron en Jotbata. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Y partidos de Jotbata, asen­taron en Abrona. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Y partidos de Abrona, asenta­ron en Esion-geber. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Y partidos de Esion-geber, asentaron en el desierto de Zin, que es Cades. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Y partidos de Cades, asenta­ron en el monte de Hor, en la extremidad del país de Edom. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Y subió Aarón el sacerdote al monte de Hor, conforme al dicho del SEÑOR, y allí murió a los cuarenta años de la salida de los hijos de Israel de la tierra de Egipto, en el mes quinto, en el primero del mes. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Y era Aarón de edad de cien­to y veinte y tres años, cuando murió en el monte de Hor. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Y el cananeo, rey de Arad, que habitaba en el sur en la tierra de Canaán, oyó como habí­an venido los hijos de Israel. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Y partidos del monte de Hor, asentaron en Salmona. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Y partidos de Salmona, asen­taron en Funón. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Y partidos de Funón, asenta­ron en Obot. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Y partidos de Obot, asenta­ron en Ije-abarim; en el término de Moab. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Y partidos de Ije-abarim, asentaron en Dibón-gad. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Y partidos de Dibón-gad, asentaron en Almon-diblataim. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Y partidos de Almon-diblataim, asentaron en los montes de Abarim, delante de Nebo. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Y partidos de los montes de Abarim, asentaron en los campos de Moab, junto al Jordán de Jericó. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Finalmente asentaron junto al Jordán, desde Bet-jesimot hasta Abel-sitim, en los campos de Moab. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Y habló el SEÑOR a Moisés en los campos de Moab junto al Jordán de Jericó, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","Habla a los hijos de Israel, y díles: Cuando hubiereis pasado el Jordán a la tierra de Canaán, ");
INSERT INTO spav1602p_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","Echaréis a todos los morado­res del país de delante de voso­tros, y destruiréis todas sus pintu­ras, y todas sus imágenes de fun­dición, y arruinaréis todos sus altos; ");
INSERT INTO spav1602p_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Y echaréis los moradores de la tierra, y habitaréis en ella; por­que yo os la he dado para que la poseáis. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Y heredaréis la tierra por suertes por vuestras familias: a los muchos daréis mucho por su heredad, y a los pocos daréis menos por heredad suya: donde le saliere la suerte, allí la tendrá cada uno: por las tribus de vues­tros padres heredaréis. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Y si no echareis los morado­res del país de delante de voso­tros, sucederá que los que deja­reis de ellos serán por aguijones en vuestros ojos, y por espinas en vuestros costados, y afligiros han sobre la tierra en que vosotros habitareis. ");
INSERT INTO spav1602p_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Será además, que haré a voso­tros como yo pensé hacerles a ellos. ");
INSERT INTO spav1602p_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Y EL SEÑOR habló a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","Manda a los hijos de Israel, y díles: Cuando hubiereis entrado en la tierra de Canaán, es a saber, la tierra que os ha de caer en heredad, la tierra de Canaán según sus términos; ");
INSERT INTO spav1602p_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","Tendréis el lado del sur desde el desierto de Zin hasta los términos de Edom; y os será el término del sur al extremo del mar salado hacia el oriente: ");
INSERT INTO spav1602p_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","Y este término os irá rodeando desde el sur hasta la subida de Acrabim, y pasará hasta Zin; y sus salidas serán del sur a Cades-barnea; y saldrá a Hasar-­adar, y pasará hasta Asmón; ");
INSERT INTO spav1602p_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","Y rodeará este término, desde Asmón hasta el torrente de Egipto, y sus remates serán al occidente. ");
INSERT INTO spav1602p_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","Y el término occidental os será la gran mar: este término os será el término occidental. ");
INSERT INTO spav1602p_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","Y el término del norte será este: desde la gran mar os señalaréis el monte de Hor; ");
INSERT INTO spav1602p_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","Del monte de Hor señalaréis a la entrada de Hamat, y serán las salidas de aquel término a Sedad; ");
INSERT INTO spav1602p_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","Y saldrá este término a Zifón, y serán sus remates en Hasar­-enán: este os será el término del norte. ");
INSERT INTO spav1602p_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","Y por término al oriente os señalaréis desde Hasar-enán hasta Sefam; ");
INSERT INTO spav1602p_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","Y bajará este término desde Sefam a Ribla, al oriente de Ain: y descenderá el término, y llegará a la costa del mar de Cineret al oriente; ");
INSERT INTO spav1602p_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","Después descenderá este tér­mino al Jordán, y serán sus sali­das al mar Salado: ésta será vues­tra tierra: por sus términos alre­dedor. ");
INSERT INTO spav1602p_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Y mandó Moisés a los hijos de Israel, diciendo: Ésta es la tie­rra que heredaréis por suerte, la cual mandó el SEÑOR que diese a las nueve tribus, y a la media tribu: ");
INSERT INTO spav1602p_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","Porque la tribu de los hijos de Rubén según las casas de sus padres, y la tribu de los hijos de Gad según las casas de sus padres, y la media tribu de Manasés, han tomado su heren­cia: ");
INSERT INTO spav1602p_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Dos tribus y media tomaron su heredad de esta parte del Jordán de Jericó al oriente, al nacimiento del sol. ");
INSERT INTO spav1602p_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Y habló el SEÑOR a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","Éstos son los nombres de los varones que os aposesionarán la tierra: Eleazar el sacerdote, y Josué hijo de Nun. ");
INSERT INTO spav1602p_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Tomaréis también de cada tribu un príncipe, para dar la posesión de la tierra. ");
INSERT INTO spav1602p_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","Y éstos son los nombres de los varones: De la tribu de Judá, Caleb hijo de Jefone. ");
INSERT INTO spav1602p_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","Y de la tribu de los hijos de Simeón, Samuel hijo de Amiud. ");
INSERT INTO spav1602p_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","De la tribu de Benjamín, Elidad hijo de Chislón. ");
INSERT INTO spav1602p_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","Y de la tribu de los hijos de Dan, el príncipe Buqui hijo de Jogli. ");
INSERT INTO spav1602p_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","De los hijos de José: de la tribu de los hijos de Manasés, el príncipe Haniel hijo de Efod. ");
INSERT INTO spav1602p_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","Y de la tribu de los hijos de Efraím, el príncipe Quemuel hijo de Siftán. ");
INSERT INTO spav1602p_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","Y de la tribu de los hijos de Zabulón, el príncipe Elisafán hijo de Farnac. ");
INSERT INTO spav1602p_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","Y de la tribu de los hijos de Isacar, el príncipe Paltiel hijo de Azan. ");
INSERT INTO spav1602p_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","Y de la tribu de los hijos de Aser, el príncipe Ahiud hijo de Selomi. ");
INSERT INTO spav1602p_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","Y de la tribu de los hijos de Neftalí, el príncipe Pedael hijo de Amiud. ");
INSERT INTO spav1602p_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Éstos son a los que mandó el SEÑOR que hiciesen la partición de la herencia a los hijos de Israel en la tierra de Canaán. ");
INSERT INTO spav1602p_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Y HABLÓ el SEÑOR a Moisés en los campos de Moab, junto al Jordán de Jericó, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","Manda a los hijos de Israel, que den a los levitas de la posesión de su heredad ciudades en que habiten: También daréis a los levitas los ejidos de esas ciuda­des alrededor de ellas. ");
INSERT INTO spav1602p_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Y tendrán ellos las ciudades para habitar, y los ejidos de ellas serán para sus animales, y para sus ganados, y para todas sus bestias. ");
INSERT INTO spav1602p_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","Y los ejidos de las ciudades que daréis a los levitas, serán mil codos alrededor, desde el muro de la ciudad para afuera. ");
INSERT INTO spav1602p_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Luego mediréis fuera de la ciu­dad a la parte del oriente dos mil codos, y a la parte del sur dos mil codos, y a la parte del occidente dos mil codos, y a la parte del norte dos mil codos, y la ciudad en medio: esto tendrán por los ejidos de las ciudades. ");
INSERT INTO spav1602p_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","Y de las ciudades que daréis a los levitas, seis ciudades serán de acogimiento, las cuales daréis para que el homicida se acoja allá: y además de éstas daréis cuarenta y dos ciudades. ");
INSERT INTO spav1602p_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Todas las ciudades que daréis a los levitas serán cuarenta y ocho ciudades; ellas con sus ejidos. ");
INSERT INTO spav1602p_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Y las ciudades que diereis de la heredad de los hijos de Israel, del que mucho tomaréis mucho, y del que poco tomaréis poco: cada uno dará de sus ciudades a los levitas según la posesión que heredará. ");
INSERT INTO spav1602p_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Y habló el SEÑOR a Moisés, diciendo: ");
INSERT INTO spav1602p_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","Habla a los hijos de Israel, y díles: Cuando hubiereis pasado el Jordán a la tierra de Canaán, ");
INSERT INTO spav1602p_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","Os señalaréis ciudades, ciuda­des de acogimiento tendréis, donde huya el homicida que hiriere a alguno de muerte por yerro. ");
INSERT INTO spav1602p_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Y os serán aquellas ciudades por acogimiento del pariente, y no morirá el homicida hasta que esté a juicio delante de la congre­gación. ");
INSERT INTO spav1602p_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","De las ciudades, pues, que daréis, tendréis seis ciudades de acogimiento. ");
INSERT INTO spav1602p_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Tres ciudades daréis de esta parte del Jordán, y tres ciudades daréis en la tierra de Canaán; las cuales serán ciudades de acogi­miento. ");
INSERT INTO spav1602p_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Estas seis ciudades serán para acogimiento a los hijos de Israel, y al peregrino, y al que morare entre ellos, para que huya allá cualquiera que hiriere de muerte a otro por yerro. ");
INSERT INTO spav1602p_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","Y si con instrumento de hierro lo hiriere y muriere, homicida es; el homicida morirá: ");
INSERT INTO spav1602p_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Y si con piedra de mano, de que pueda morir, lo hiriere, y muriere, homicida es; el homici­da morirá. ");
INSERT INTO spav1602p_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Y si con instrumento de palo de mano, de que pueda morir, lo hiriere, y muriere, homicida es; el homicida morirá. ");
INSERT INTO spav1602p_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","El vengador de sangre mismo matará al homicida: cuando lo encontrare, él le matará. ");
INSERT INTO spav1602p_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Y si por odio lo empujó, o echó sobre él alguna cosa por asechanzas, y muere; ");
INSERT INTO spav1602p_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","O por enemistad lo hirió con su mano, y murió: el heridor morirá; es homicida; el vengador de sangre matará al homicida, cuando lo encontrare. ");
INSERT INTO spav1602p_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","Mas si casualmente lo empu­jó sin enemistades, o echó sobre él cualquier instrumento sin ase­chanzas, ");
INSERT INTO spav1602p_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","O bien, sin verlo, hizo caer sobre él alguna piedra, de que pudo morir, y muriere, y él no era su enemigo, ni procuraba su mal; ");
INSERT INTO spav1602p_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","Entonces la congregación juz­gará entre el heridor y el venga­dor de sangre conforme a estas leyes: ");
INSERT INTO spav1602p_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Y la congregación librará al homicida de mano del vengador de sangre, y la congregación lo hará volver a su ciudad de refu­gio, a la cual se había huido; y morará en ella hasta que muera el gran sacerdote, el cual fue ungi­do con el aceite santo. ");
INSERT INTO spav1602p_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","Y si el homicida saliere fuera del término de su ciudad de refugio, a la cual se acogió, ");
INSERT INTO spav1602p_vpl VALUES ("NU35_27","005_35_27","NUM","35","2