﻿USE sofia;
DROP TABLE IF EXISTS sofia.spaonbv_vpl;
CREATE TABLE spaonbv_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES spaonbv_vpl WRITE;
INSERT INTO spaonbv_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","En el principio creó Dios los cielos y la tierra. ");
INSERT INTO spaonbv_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","La tierra estaba desordenada y no tenía forma. La oscuridad cubría el profundo abismo, mientras que el Espíritu de Dios se movía sobre las aguas. ");
INSERT INTO spaonbv_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Entonces Dios dijo: «¡Que aparezca la luz!». Y apareció la luz. ");
INSERT INTO spaonbv_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Dios vio que la luz era hermosa, y la separó de la oscuridad. ");
INSERT INTO spaonbv_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","A la luz Dios la llamó «día», y a la oscuridad la llamó «noche». Pasó la tarde y pasó la mañana, y se completó, así, el primer día. ");
INSERT INTO spaonbv_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Después Dios dijo: «Que aparezca el firmamento en medio de las aguas, para que las separe». ");
INSERT INTO spaonbv_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Así que Dios hizo el firmamento, para separar las aguas. De modo que una parte de las aguas quedó arriba del firmamento y otra, debajo de él. ");
INSERT INTO spaonbv_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Al firmamento Dios lo llamó «cielo». Pasó la tarde y pasó la mañana, y se completó, así, el segundo día. ");
INSERT INTO spaonbv_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Después Dios dijo: «Que las aguas que están debajo del cielo se junten en un solo lugar, de modo que la otra parte quede seca». Y así ocurrió. ");
INSERT INTO spaonbv_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","A la parte seca Dios le dio el nombre de «tierra», y a las aguas las llamó «mares». Dios vio que todo esto era hermoso. ");
INSERT INTO spaonbv_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","12","Así que dijo: «Que de la tierra brote toda clase de vegetación, es decir, plantas que se reproduzcan por medio de semillas, y árboles frutales en cuyos frutos estén sus semillas». Y, tal como Dios lo dijo, de la tierra brotaron las plantas y árboles frutales con sus respectivas semillas para su reproducción. Y Dios vio que todo esto era hermoso. ");
INSERT INTO spaonbv_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Pasó la tarde y pasó la mañana, y se completó, así, el tercer día. ");
INSERT INTO spaonbv_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","15","Después Dios dijo: «Que haya luces en el cielo, para que alumbren la tierra y separen el día de la noche, y para que marquen también las estaciones, los días y los años». Y así ocurrió. ");
INSERT INTO spaonbv_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Entonces Dios hizo dos grandes luces: la más grande para que alumbre durante el día, y la más pequeña, para que brille en la noche. También Dios hizo las estrellas. ");
INSERT INTO spaonbv_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","18","Dios puso estas luces en el cielo para que alumbraran la tierra de día y de noche, y para que separaran la luz de la oscuridad. Y Dios vio que esto era hermoso. ");
INSERT INTO spaonbv_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Pasó la tarde y pasó la mañana, y se completó, así, el cuarto día. ");
INSERT INTO spaonbv_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Después Dios dijo: «Que las aguas se llenen de peces y de otros animales acuáticos, y que también haya aves que vuelen sobre la tierra, en el inmenso firmamento». ");
INSERT INTO spaonbv_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Fue así como Dios creó los grandes animales que hay en el mar, y todos los demás seres vivos que hay en el agua. También Dios creó todas las clases de aves que existen. Y Dios vio que todo esto era hermoso. ");
INSERT INTO spaonbv_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Luego Dios los bendijo y les dijo: «Tengan muchas, pero muchas crías, para que llenen los mares». Además, dijo: «¡Que las aves se reproduzcan en grandes cantidades!». ");
INSERT INTO spaonbv_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Pasó la tarde y pasó la mañana, y se completó, así, el quinto día. ");
INSERT INTO spaonbv_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Después Dios dijo: «Que en la tierra haya toda especie de animales: domésticos, salvajes y reptiles». Y así ocurrió. ");
INSERT INTO spaonbv_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Así que Dios hizo todos los animales domésticos, los salvajes y los reptiles, todos según su propia especie. Y vio Dios que todo esto era hermoso. ");
INSERT INTO spaonbv_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Entonces Dios dijo: «Hagamos a los seres humanos a nuestra imagen, a nuestra semejanza, para que ejerzan poder sobre los peces, las aves, los animales domésticos y salvajes, y sobre los reptiles». ");
INSERT INTO spaonbv_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","De modo que Dios creó a los seres humanos a su imagen. Sí, a su imagen Dios los creó. Y Dios los creó hombre y mujer. ");
INSERT INTO spaonbv_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Luego Dios los bendijo y les dijo: «Tengan muchos hijos, para que llenen toda la tierra, y la administren. Ustedes dominarán a los peces del mar, a las aves del cielo, y a todos los animales que hay en la tierra». ");
INSERT INTO spaonbv_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","También les dijo: «Ustedes se alimentarán de toda planta que se reproduzca por medio de semillas, y de todos los árboles frutales. ");
INSERT INTO spaonbv_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Las bestias del campo, las aves del cielo, y todos los seres vivos que se arrastran sobre la tierra se alimentarán de vegetales». ");
INSERT INTO spaonbv_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Entonces Dios contempló todo lo que había hecho, y vio que era muy, pero muy hermoso. Pasó la tarde y pasó la mañana, y se completó, así, el sexto día. ");
INSERT INTO spaonbv_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","De este modo fueron creados los cielos y la tierra, y todo lo que hay en ellos. ");
INSERT INTO spaonbv_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Después de haber terminado todo lo que se había propuesto hacer, Dios descansó el séptimo día. ");
INSERT INTO spaonbv_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Y bendijo el séptimo día y lo instituyó como día santo, porque en ese día descansó después de haber creado todo. ");
INSERT INTO spaonbv_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Aquí termina la historia de la creación del cielo y de la tierra. Cuando Dios el Señor hizo la tierra y el cielo, ");
INSERT INTO spaonbv_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","todavía no había ninguna clase de vegetación en la tierra, porque Dios el Señor aún no había hecho llover. Además, no había quien trabajara la tierra, porque todavía Dios no había hecho al hombre. ");
INSERT INTO spaonbv_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Sin embargo, de la tierra brotaba agua que regaba el suelo. ");
INSERT INTO spaonbv_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Entonces Dios el Señor formó el cuerpo del hombre del polvo de la tierra y sopló en su nariz el aliento de vida. Fue así como el hombre se convirtió en un ser vivo. ");
INSERT INTO spaonbv_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Luego Dios el Señor plantó un jardín en Edén, hacia el oriente, y puso en él al hombre que había creado. ");
INSERT INTO spaonbv_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Dios el Señor hizo que en el jardín se diera toda clase de árboles hermosos y de frutos deliciosos. En el centro del jardín plantó el árbol de la vida y también el árbol del conocimiento del bien y del mal. ");
INSERT INTO spaonbv_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","De la tierra de Edén salía un río que corría a través del huerto para regarlo. Después el río se dividía en cuatro brazos. ");
INSERT INTO spaonbv_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","12","El primero se llamaba Pisón, el cual recorría toda la región de Javilá, donde había oro de muy buena calidad. También allí había plantas con las que se hacen perfumes muy finos, y piedras de ónice. ");
INSERT INTO spaonbv_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","El segundo se llamaba Guijón, y atravesaba toda la región de Cus. ");
INSERT INTO spaonbv_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","El tercero era el río Tigris, que es el que pasa al oriente de Asiria. Y el cuarto era el río Éufrates. ");
INSERT INTO spaonbv_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Dios el Señor puso al hombre en el jardín de Edén para que lo labrara y lo cuidara, ");
INSERT INTO spaonbv_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","y a la vez le dio esta orden: «Puedes comer del fruto de todos los árboles que hay en el jardín, ");
INSERT INTO spaonbv_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","pero del árbol del conocimiento del bien y del mal no podrás comer, porque el día que comas del fruto de ese árbol, morirás». ");
INSERT INTO spaonbv_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Dios el Señor dijo: «No es bueno que el hombre esté solo. Le voy a hacer una compañera que sea de ayuda para él en todas sus necesidades». ");
INSERT INTO spaonbv_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","20","Dios el Señor formó, del polvo de la tierra, todos los animales del campo y todas las aves del cielo. Luego se los llevó al hombre para que este les pusiera nombre. Así que el hombre les puso a todos los animales el nombre con que se conocen en la actualidad. Pero entre todos esos animales no se encontró ninguno que le sirviera al hombre de pareja adecuada. ");
INSERT INTO spaonbv_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Entonces Dios el Señor hizo que cayera sobre el hombre un sueño profundo, le sacó una costilla y cerró la carne en el lugar de donde la había sacado. ");
INSERT INTO spaonbv_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Con la costilla hizo a la mujer y se la llevó al hombre. ");
INSERT INTO spaonbv_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Al verla, el hombre exclamó: «¡Esta sí es hueso de mis huesos y carne de mi carne! Se llamará “mujer” porque fue sacada del hombre». ");
INSERT INTO spaonbv_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Es por eso que el hombre deja a su padre y a su madre y se casa con su mujer, y los dos llegan a ser como una sola persona. ");
INSERT INTO spaonbv_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Aunque en ese tiempo el hombre y la mujer estaban desnudos, no se sentían avergonzados. ");
INSERT INTO spaonbv_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","La serpiente, que era el más astuto de todos los animales del campo creados por Dios el Señor, se le acercó a la mujer y le preguntó: ―¿Es verdad que Dios no les permite comer de ningún árbol que hay en el jardín? ");
INSERT INTO spaonbv_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","La mujer le contestó: ―Sí podemos comer los frutos de cualquier árbol, ");
INSERT INTO spaonbv_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","menos del que está en el centro del jardín. Dios nos dijo que si comemos o tocamos el fruto de ese árbol, moriremos. ");
INSERT INTO spaonbv_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","―¡Mentira! —silbó la serpiente—. ¡No morirán! ");
INSERT INTO spaonbv_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Lo que pasa es que Dios sabe que, cuando ustedes coman del fruto de ese árbol, obtendrán todo el conocimiento, pues podrán conocer el bien y el mal. ¡Ese día ustedes serán como Dios! ");
INSERT INTO spaonbv_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","La mujer contempló el árbol y se convenció de que su fruto era bueno para comer. Además, lo vio muy hermoso, y pensó que era su oportunidad para conseguir la sabiduría. Así que agarró el fruto y comió. Luego le dio de comer a su marido, el cual estaba con ella. ");
INSERT INTO spaonbv_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Tan pronto lo comieron, se dieron cuenta de que estaban desnudos y sintieron vergüenza. Entonces cosieron hojas de higuera para cubrir su desnudez. ");
INSERT INTO spaonbv_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Aquella tarde, a la hora en que sopla la brisa, el hombre y la mujer oyeron que Dios andaba por el jardín. Entonces corrieron a esconderse entre los árboles, para que Dios el Señor no los viera. ");
INSERT INTO spaonbv_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Pero Dios el Señor llamó al hombre y le preguntó: ―¿Dónde estás? ");
INSERT INTO spaonbv_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","El hombre le contestó: ―Oí que andabas por el jardín y me dio miedo, pues estoy desnudo. Así que me escondí. ");
INSERT INTO spaonbv_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","―¿Quién te dijo que estás desnudo? —le preguntó Dios el Señor—. ¿Acaso comiste del fruto del árbol que te ordené que no comieras? ");
INSERT INTO spaonbv_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","El hombre contestó: ―La mujer que me diste para que me acompañara me dio del fruto de ese árbol, y yo lo comí. ");
INSERT INTO spaonbv_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Entonces Dios el Señor le preguntó a la mujer: ―¿Qué es lo que has hecho? Ella respondió: ―La serpiente me engañó, y por eso comí de ese fruto. ");
INSERT INTO spaonbv_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Entonces Dios el Señor le dijo a la serpiente: ―Por haber hecho esto, te maldeciré. Serás la más desdichada de todos los animales, incluyendo los domésticos y los salvajes. A partir de este momento andarás arrastrándote sobre tu vientre y comerás polvo durante toda tu vida. ");
INSERT INTO spaonbv_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Habrá siempre enemistad entre ti y la mujer, y entre tu descendencia y la de ella. El descendiente de la mujer te aplastará la cabeza, mientras tú solamente le morderás el talón. ");
INSERT INTO spaonbv_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Luego Dios le dijo a la mujer: ―Haré que sufras bastante durante tus embarazos y que al tener tus hijos sientas mucho dolor. Y a pesar de eso, seguirás deseando a tu marido, y él tendrá dominio sobre ti. ");
INSERT INTO spaonbv_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Después Dios le dijo al hombre: ―La tierra estará bajo maldición por tu culpa, pues le hiciste caso a tu mujer y comiste del fruto que te prohibí. Por eso, de aquí en adelante tendrás que trabajar muy duro para conseguir tu alimento. ");
INSERT INTO spaonbv_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","La tierra te producirá espinas y cardos, y tendrás que comer plantas silvestres. ");
INSERT INTO spaonbv_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Para obtener tu alimento tendrás que trabajar mucho, hasta el día de tu muerte; ese día volverás a la tierra de la cual fuiste hecho, pues eres polvo y al polvo tendrás que volver. ");
INSERT INTO spaonbv_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Luego el hombre le puso a su mujer el nombre de Eva, pues ella sería la madre de todos los seres humanos. ");
INSERT INTO spaonbv_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Dios el Señor hizo túnicas de pieles de animales, y con ellas vistió al hombre y a su mujer. ");
INSERT INTO spaonbv_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Y dijo: «Ahora el ser humano es como uno de nosotros, pues sabe lo que es bueno y lo que es malo, no conviene que tome del fruto del árbol de la vida y viva para siempre». ");
INSERT INTO spaonbv_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Entonces Dios el Señor expulsó al hombre y a la mujer del jardín de Edén, y puso al hombre a que trabajara la tierra de la cual fue hecho. ");
INSERT INTO spaonbv_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Después de haber expulsado al hombre y a la mujer, Dios puso al oriente del jardín de Edén a los querubines, y una espada encendida que giraba en todas las direcciones, para evitar que nadie pudiera llegar hasta el árbol de la vida. ");
INSERT INTO spaonbv_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adán tuvo relaciones con su esposa Eva, y ella quedó embarazada, y dio a luz a su hijo Caín, y dijo: «Gracias al Señor, he tenido un hijo varón». ");
INSERT INTO spaonbv_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Después volvió a tener otro hijo al cual le puso por nombre Abel. Abel fue pastor de ovejas, en cambio Caín fue un agricultor. ");
INSERT INTO spaonbv_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Después de algún tiempo, Caín le dio al Señor una ofrenda de lo que había cosechado. ");
INSERT INTO spaonbv_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","También Abel le dio una ofrenda al Señor. Le ofreció las primeras y mejores crías de sus ovejas. Al Señor le agradó Abel y su ofrenda, ");
INSERT INTO spaonbv_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","pero no se agradó de Caín ni de su ofrenda. Por eso Caín se enojó muchísimo y andaba amargado. ");
INSERT INTO spaonbv_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Entonces el Señor le preguntó: «¿Por qué estás tan enojado y andas amargado? ");
INSERT INTO spaonbv_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Si hicieras lo correcto podrías andar con tu frente en alto. Pero si actúas mal, el pecado, como una fiera, está listo a lanzarse sobre ti y destruirte. Sin embargo, tú puedes dominarlo». ");
INSERT INTO spaonbv_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Un día Caín invitó a su hermano a dar un paseo. Cuando estaban en el campo, Caín atacó a su hermano y lo mató. ");
INSERT INTO spaonbv_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Poco tiempo después el Señor le preguntó a Caín: ―¿Dónde está Abel, tu hermano? Caín le contestó: ―No lo sé. ¿Acaso tengo la obligación de cuidar a mi hermano? ");
INSERT INTO spaonbv_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Pero el Señor le dijo: ―¿Qué hiciste? Desde la tierra, la sangre de tu hermano me pide justicia. ");
INSERT INTO spaonbv_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Por eso, quedarás bajo la maldición de la tierra, la cual se ha tragado la sangre de tu hermano, al que tú mataste. ");
INSERT INTO spaonbv_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Cuando trabajes la tierra, no te dará cosechas. Vivirás en el mundo como un fugitivo, sin poder encontrar descanso. ");
INSERT INTO spaonbv_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Caín le dijo al Señor: ―Ese castigo es más de lo que puedo soportar. ");
INSERT INTO spaonbv_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Hoy me echas de esta tierra, y tendré que vivir lejos de tu presencia. Tendré que vivir huyendo como un fugitivo, expuesto a que cualquiera que me encuentre me mate. ");
INSERT INTO spaonbv_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","El Señor le contestó: ―Eso no sucederá. Si alguien te mata, será castigado siete veces. Luego el Señor le puso una marca a Caín, para que nadie lo matara. ");
INSERT INTO spaonbv_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Entonces Caín se alejó de la presencia del Señor y fue a vivir en la región de Nod —tierra de los errantes—, al oriente del Edén. ");
INSERT INTO spaonbv_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Caín tuvo relaciones con su esposa, la cual quedó embarazada y dio a luz a Enoc. Caín fundó una ciudad y le puso el nombre de Enoc, en honor a su hijo. ");
INSERT INTO spaonbv_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enoc fue el padre de Irad, Irad fue padre de Mejuyael, Mejuyael fue padre de Metusael, y este fue el padre de Lamec. ");
INSERT INTO spaonbv_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamec tuvo dos esposas: Ada y Zila. ");
INSERT INTO spaonbv_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada dio a luz a Jabal, que es el antepasado de los que viven en carpas y se dedican a la cría de ganado. ");
INSERT INTO spaonbv_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Jabal tuvo un hermano llamado Jubal, que es el antepasado de los que tocan el arpa y la flauta. ");
INSERT INTO spaonbv_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","También Zila, la otra esposa de Lamec, dio a luz a Tubal Caín, que hacía toda clase de objetos de bronce y de hierro. Tubal Caín tuvo una hermana que se llamaba Noama. ");
INSERT INTO spaonbv_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Un día, Lamec les dijo a sus esposas: «¡Escúchenme, mujeres de Lamec! ¡Oigan bien lo que les digo! A un hombre que me hirió, lo maté, y lo mismo hice con un muchacho que me golpeó. ");
INSERT INTO spaonbv_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Si el que mate a Caín será vengado siete veces, entonces, el que mate a Lamec será vengado setenta y siete veces». ");
INSERT INTO spaonbv_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adán volvió a tener relaciones con su esposa, la cual dio a luz un hijo al que le puso por nombre Set, pues dijo: «Dios me ha dado otro hijo en lugar de Abel, al que Caín mató». ");
INSERT INTO spaonbv_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","También Set tuvo un hijo, al que llamó Enós. Desde ese tiempo la gente comenzó a invocar el nombre del Señor. ");
INSERT INTO spaonbv_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Esta es la lista de los descendientes de Adán. El día en que los seres humanos fueron creados, Dios los creó a su propia imagen. ");
INSERT INTO spaonbv_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Los creó hombre y mujer, y los bendijo. Ese mismo día los llamó «seres humanos». ");
INSERT INTO spaonbv_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","5","Adán tenía ciento treinta años cuando le nació un hijo, a su imagen y semejanza, y le puso el nombre de Set. Adán vivió ochocientos años más, tuvo hijos e hijas, y murió a los novecientos treinta años de edad. ");
INSERT INTO spaonbv_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","8","Set tenía ciento cinco años cuando nació Enós. Después de esto, vivió otros ochocientos siete años, tuvo hijos e hijas, y murió a la edad de novecientos doce años. ");
INSERT INTO spaonbv_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","11","Enós tenía noventa años cuando nació su hijo Cainán. Después de esto, vivió ochocientos quince años, tuvo hijos e hijas, y murió a la edad de novecientos cinco años. ");
INSERT INTO spaonbv_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","14","Cainán tenía setenta años cuando nació su hijo Malalel. Después de esto, vivió ochocientos cuarenta años, tuvo hijos e hijas, y murió a la edad de novecientos diez años. ");
INSERT INTO spaonbv_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","17","Malalel tenía sesenta y cinco años cuando nació su hijo Jared. Después de esto, vivió ochocientos treinta años, tuvo hijos e hijas, y murió a la edad de ochocientos noventa y cinco años. ");
INSERT INTO spaonbv_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","20","Jared tenía ciento sesenta y dos años cuando nació su hijo Enoc. Después de esto, vivió ochocientos años, tuvo hijos e hijas, y murió a la edad de novecientos sesenta y dos años. ");
INSERT INTO spaonbv_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","24","Enoc tenía sesenta y cinco años cuando nació su hijo Matusalén. Después de Matusalén, tuvo otros hijos e hijas, y vivió trescientos años más. Durante toda su vida, Enoc vivió de acuerdo con la voluntad de Dios, y cuando tenía trescientos sesenta y cinco años desapareció, porque Dios se lo llevó sin que muriera. ");
INSERT INTO spaonbv_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","27","Matusalén tenía ciento ochenta y siete años cuando nació su hijo Lamec. Después de esto, vivió setecientos ochenta y dos años, tuvo hijos e hijas, y murió a los novecientos sesenta y nueve años de edad. ");
INSERT INTO spaonbv_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","31","Lamec tenía ciento ochenta y dos años cuando nació su hijo Noé. Lamec lo llamó Noé, porque dijo: «Él nos aliviará del duro trabajo que significa labrar la tierra que Dios maldijo». Después de esto, Lamec vivió quinientos noventa y cinco años, tuvo hijos e hijas, y murió a la edad de setecientos setenta y siete años. ");
INSERT INTO spaonbv_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noé tenía quinientos años cuando tuvo tres hijos: Sem, Cam y Jafet. ");
INSERT INTO spaonbv_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","La población comenzó a multiplicarse sobre la tierra. ");
INSERT INTO spaonbv_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Entonces los hijos de Dios se fijaron en la belleza de las mujeres y tomaron como mujeres a todas las que quisieron. ");
INSERT INTO spaonbv_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Por eso el Señor dijo: «No dejaré que el ser humano viva muchísimos años, porque su maldad ha aumentado. De modo que sólo lo dejaré vivir ciento veinte años». ");
INSERT INTO spaonbv_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","En aquellos días y aun después, cuando los hijos de Dios tuvieron relaciones con mujeres, nacieron gigantes que fueron famosos por su valentía. ");
INSERT INTO spaonbv_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","6","Cuando el Señor Dios vio el alcance de la maldad humana, y que la gente sólo pensaba en hacer lo malo, le dolió haberla creado y se llenó de mucho pesar. ");
INSERT INTO spaonbv_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Entonces Dios dijo: «Voy a borrar de la tierra todo lo que he creado, hombres, animales, reptiles y aves. ¡Lamento haberlos creado!». ");
INSERT INTO spaonbv_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Pero Noé contaba con la aprobación del Señor. ");
INSERT INTO spaonbv_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Esta es la historia de Noé y de sus descendientes. Noé era un hombre justo y bueno, y todo el tiempo vivía conforme a la voluntad de Dios. ");
INSERT INTO spaonbv_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noé tuvo tres hijos: Sem, Cam y Jafet. ");
INSERT INTO spaonbv_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","13","Dios vio que la humanidad se había degenerado, y practicaba la violencia. La depravación llegó a tal extremo que un día Dios le dijo a Noé: «He decidido destruir a la humanidad, porque por su culpa hay mucha violencia y corrupción en la tierra. Sí, voy a destruir a toda la gente junto con lo que hay en el mundo. ");
INSERT INTO spaonbv_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Hazte un barco de madera de pino, cubre todas sus hendijas con alquitrán, y hazle cubiertas y camarotes a todo lo largo. ");
INSERT INTO spaonbv_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Hazlo de ciento treinta y cinco metros de largo, veintidós metros y medio de ancho y trece metros y medio de alto. ");
INSERT INTO spaonbv_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Permite que entre el techo y la pared alrededor de todo el barco haya un espacio libre de unos cuarenta y cinco centímetros para que tanto la luz como el aire puedan circular. Hazle tres cubiertas: una cubierta inferior, una intermedia y una superior, y hazle una puerta al costado. ");
INSERT INTO spaonbv_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Porque voy a inundar la tierra con un diluvio para destruir a todos los seres vivos. Todos morirán. ");
INSERT INTO spaonbv_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Pero contigo haré un pacto, de modo que entrarás en el barco junto con tus hijos, tu esposa, y tus nueras, para que no mueran. ");
INSERT INTO spaonbv_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","»De cada animal trae un macho y una hembra, y hazlos entrar en el barco contigo, para que sobrevivan al diluvio. Haz entrar una pareja de cada especie de animal, ave y reptil. ");
INSERT INTO spaonbv_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","También guarda en el barco todo el alimento que tú y ellos necesitarán». ");
INSERT INTO spaonbv_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Y Noé hizo todo lo que Dios le mandó. ");
INSERT INTO spaonbv_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Después el Señor le dijo a Noé: «Entra en el barco con toda tu familia, porque tú eres el único hombre bueno que vive en este tiempo. ");
INSERT INTO spaonbv_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Mete en el barco siete machos y siete hembras de todos los animales que se consideran puros; pero de los que se consideran impuros sólo lleva un macho y una hembra. ");
INSERT INTO spaonbv_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Lleva también siete machos y siete hembras de todas las aves que existen, para conservar su especie en la tierra. ");
INSERT INTO spaonbv_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Porque dentro de siete días haré que comience una lluvia que durará cuarenta días con sus noches, y todo lo que vive en la tierra morirá». ");
INSERT INTO spaonbv_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Y Noé hizo todo lo que Dios le mandó. ");
INSERT INTO spaonbv_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","7","Cuando comenzó el diluvio, Noé tenía seiscientos años de edad. Entonces entró en el barco con sus hijos, su esposa, y sus nueras, para librarse del diluvio. ");
INSERT INTO spaonbv_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","También entraron con Noé los animales puros e impuros, las aves y los reptiles, macho y hembra, tal como Dios se lo había ordenado. ");
INSERT INTO spaonbv_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Luego de siete días, las aguas del diluvio comenzaron a inundar la tierra. ");
INSERT INTO spaonbv_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Eso ocurrió el día diecisiete del mes segundo, es decir, cuando Noé cumplió sus seiscientos años de vida. Ese día se reventaron todas las fuentes del mar que está debajo de la tierra, y se abrieron las compuertas del cielo dejando caer una lluvia torrencial. ");
INSERT INTO spaonbv_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Llovió, sin parar, durante cuarenta días y cuarenta noches. ");
INSERT INTO spaonbv_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Fue en aquel día que Noé entró en el barco con su esposa, sus hijos Sem, Cam y Jafet, y sus nueras. ");
INSERT INTO spaonbv_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","15","Con ellos había en el barco parejas de toda clase de animales, domésticos y silvestres, reptiles y aves. ");
INSERT INTO spaonbv_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Habían entrado de dos en dos, macho y hembra, tal como Dios lo había ordenado. Después el Señor cerró la puerta del barco. ");
INSERT INTO spaonbv_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Estuvo lloviendo sobre la tierra durante cuarenta días. Como el nivel de las aguas subió, el barco comenzó a flotar sobre las aguas. ");
INSERT INTO spaonbv_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","A medida que el agua subía, el barco flotaba sin peligro sobre ellas. ");
INSERT INTO spaonbv_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Las aguas subieron tanto, que cubrieron hasta las montañas más altas de la tierra. ");
INSERT INTO spaonbv_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Las aguas subieron unos siete metros por encima de las montañas. ");
INSERT INTO spaonbv_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","22","Por eso, murieron todos los seres vivos que había en la tierra: las aves, los animales salvajes y los domésticos, todos los reptiles, y todos los seres humanos. ");
INSERT INTO spaonbv_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Tan sólo Noé y los que estaban con él en el barco quedaron vivos. Todos los demás seres humanos murieron, junto con los animales domésticos, las aves y los reptiles. ");
INSERT INTO spaonbv_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Las aguas inundaron la tierra durante unos ciento cincuenta días. ");
INSERT INTO spaonbv_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Entonces Dios se acordó de Noé y de todos los animales que estaban con él en el barco. Dios hizo soplar un fuerte viento sobre la tierra, de modo que las aguas comenzaron a bajar. ");
INSERT INTO spaonbv_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Se cerraron tanto las fuentes del mar profundo como las compuertas de los cielos, y dejó de llover. ");
INSERT INTO spaonbv_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Las aguas fueron bajando poco a poco. Después de ciento cincuenta días las aguas habían bajado bastante. ");
INSERT INTO spaonbv_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Fue por eso que el día diecisiete del mes séptimo el barco se posó sobre las montañas de Ararat. ");
INSERT INTO spaonbv_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","El agua siguió bajando, de modo que el día primero del mes décimo pudieron verse las partes más altas de las montañas. ");
INSERT INTO spaonbv_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Después de cuarenta días, Noé abrió la ventana que le había hecho al barco ");
INSERT INTO spaonbv_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","y soltó un cuervo, el cual estuvo volando de un lado a otro esperando que la tierra se secara, pero no regresó. ");
INSERT INTO spaonbv_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Luego Noé soltó una paloma, para ver si ya la tierra estaba seca. ");
INSERT INTO spaonbv_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Pero la paloma regresó al barco, porque no encontró un lugar seco en el cual pudiera posarse. Entonces Noé extendió su mano, agarró a la paloma y la metió al barco. ");
INSERT INTO spaonbv_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Esperó otros siete días más y volvió a soltar la paloma. ");
INSERT INTO spaonbv_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Ya estaba oscureciendo cuando la paloma regresó, trayendo en su pico una ramita verde de olivo. Por eso, Noé se dio cuenta de que las aguas habían bajado mucho, de modo que ya se podía ver la tierra seca. ");
INSERT INTO spaonbv_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Siete días después volvió a soltar la paloma, pero esta vez la paloma no regresó. ");
INSERT INTO spaonbv_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Cuando Noé tenía seiscientos un años de vida, las aguas desaparecieron. El primer día del mes primero de ese año, Noé retiró el techo del barco y vio que la tierra estaba casi seca. ");
INSERT INTO spaonbv_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","El día veintisiete del segundo mes, la tierra ya estaba completamente seca. ");
INSERT INTO spaonbv_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Entonces Dios le dijo a Noé: ");
INSERT INTO spaonbv_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","17","«Ya pueden salir todos. Deja salir a todos los animales, aves y reptiles para que se reproduzcan abundantemente y llenen la tierra». ");
INSERT INTO spaonbv_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Así que Noé, sus hijos, su esposa y sus nueras salieron del barco. ");
INSERT INTO spaonbv_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","También salieron todos los animales, según su propia especie: los animales salvajes y los domésticos, las aves y los reptiles. ");
INSERT INTO spaonbv_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Después Noé construyó un altar para adorar al Señor. En ese altar Noé le ofreció a Dios animales y aves adecuados para el sacrificio, es decir, que eran puros. ");
INSERT INTO spaonbv_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Al Señor le agradó mucho el olor de los sacrificios, y se dijo a sí mismo: «Nunca más volveré a maldecir la tierra por culpa de la humanidad, pues todos los seres humanos están inclinados hacia el mal desde que son niños. ¡Jamás volveré a destruir a los seres vivos, como lo hice en esta ocasión! ");
INSERT INTO spaonbv_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Mientras exista la tierra, habrá siembra y cosecha; siempre habrá frío y calor, verano e invierno, los días y las noches». ");
INSERT INTO spaonbv_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Dios dio esta bendición a Noé y a sus hijos: «Tengan muchos hijos y vuelvan a llenar la tierra. ");
INSERT INTO spaonbv_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Todos los animales de la tierra temblarán de miedo delante de ustedes. Todas las bestias de la tierra, todas las aves, todos los reptiles y todos los peces se tendrán que someter a ustedes. ");
INSERT INTO spaonbv_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Les doy todos los animales, lo mismo que las plantas y verduras para que los usen para su alimentación. ");
INSERT INTO spaonbv_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Pero no deberán comer animales sin haberles sacado la sangre, porque la vida está en la sangre. ");
INSERT INTO spaonbv_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Si un animal mata a un ser humano, yo lo castigaré. También castigaré a cualquier persona que mate a otro ser humano. Sí, yo pediré cuentas a cualquier animal o persona que mate a un ser humano. ");
INSERT INTO spaonbv_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","El que mate a una persona, otra persona lo matará a él; porque los seres humanos fueron creados a la imagen de Dios. ");
INSERT INTO spaonbv_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","»Ustedes recuerden: “Tengan muchos hijos y vuelvan a poblar la tierra; ¡sí, multiplíquense y llenen la tierra!”». ");
INSERT INTO spaonbv_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","11","Entonces Dios les dijo a Noé y a sus hijos: «Hoy mismo hago un pacto con ustedes, con todo hombre y mujer que nazca después de ustedes, y con todos los animales que están con ustedes y que salieron del barco, es decir, con los animales domésticos y salvajes, con las aves y con todos los demás animales que hay en la tierra. Por medio de este pacto les prometo que nunca más enviaré otro diluvio para destruir la tierra. ¡Nunca más mataré a ningún ser viviente por medio de un diluvio!». ");
INSERT INTO spaonbv_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","Además, Dios dijo: «El arco iris servirá de señal para recordar este pacto que acabo de hacer con ustedes y con todos los animales. Sí, cada vez que aparezca el arco iris sobre las nubes les recordará la promesa que he hecho a toda la tierra. ");
INSERT INTO spaonbv_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","16","Cuando yo cubra de nubes la tierra, también haré que aparezca el arco iris. De ese modo me acordaré de la promesa que les he hecho a ustedes y a todos los demás seres vivos de la tierra. Así que nunca más los destruiré por medio de un diluvio. ");
INSERT INTO spaonbv_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","No lo olviden: Esta es la señal del pacto que acabo de hacer con ustedes y con todo ser viviente en la tierra». ");
INSERT INTO spaonbv_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Los tres hijos de Noé fueron: Sem, Cam y Jafet. (Cam es el padre de Canaán). ");
INSERT INTO spaonbv_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","De estos tres hijos de Noé proceden todas las naciones de la tierra. ");
INSERT INTO spaonbv_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","21","Noé, que era agricultor, plantó una viña e hizo vino. Un día bebió tanto vino que se emborrachó y se quedó desnudo, tendido en el piso de su carpa. ");
INSERT INTO spaonbv_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","En esas, Cam, el padre de Canaán, entró a la carpa y vio a Noé desnudo. Al salir de la carpa le contó a sus hermanos que había visto a su padre desnudo. ");
INSERT INTO spaonbv_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Entonces Sem y Jafet tomaron una túnica, se la echaron sobre los hombros y, para evitar ver la desnudez de su padre, entraron caminando hacia atrás y lo cubrieron. ");
INSERT INTO spaonbv_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","25","Cuando Noé despertó de su borrachera y supo lo que le había hecho su hijo menor, dijo: «¡Maldito sea Canaán y sus descendientes! ¡Serán esclavos de los descendientes de Sem y Jafet! ¡Serán los esclavos de más bajo rango!». ");
INSERT INTO spaonbv_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Luego Noé dijo: «¡Bendito sea el Señor, Dios de Sem! ¡Que Canaán sea esclavo de Sem! ");
INSERT INTO spaonbv_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","¡Que Dios prospere mucho a Jafet, y que viva en los campamentos de Sem! ¡Que Canaán sea esclavo de Jafet!». ");
INSERT INTO spaonbv_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Noé vivió otros trescientos cincuenta años después del diluvio, ");
INSERT INTO spaonbv_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","y tenía novecientos cincuenta años cuando murió. ");
INSERT INTO spaonbv_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Después del diluvio, Sem, Cam y Jafet, los hijos de Noé, tuvieron sus propios hijos. Estos son sus descendientes: ");
INSERT INTO spaonbv_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Los hijos de Jafet fueron: Gómer, Magog, Maday, Javán, Tubal, Mésec, Tirás. ");
INSERT INTO spaonbv_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Los hijos de Gómer fueron: Asquenaz, Rifat y Togarma. ");
INSERT INTO spaonbv_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Los hijos de Javán fueron: Elisá, Tarsis, Quitín y Rodanín. ");
INSERT INTO spaonbv_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Estos se fueron a vivir en las islas y costas, y fundaron naciones en diversos lugares, con sus propios idiomas. ");
INSERT INTO spaonbv_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Los hijos de Cam fueron: Cus, Misrayin, Fut y Canaán. ");
INSERT INTO spaonbv_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Los hijos de Cus fueron: Seba, Javilá, Sabtá, Ragama y Sabteca. Los hijos de Ragama fueron: Sabá y Dedán. ");
INSERT INTO spaonbv_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Cus fue el padre de Nimrod, que llegó a ser el primer guerrero muy famoso. ");
INSERT INTO spaonbv_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Con la ayuda del Señor llegó a ser un cazador muy valiente. Por eso, se hizo popular decir: «Tan valiente como Nimrod, quien llegó a ser un excelente cazador porque el Señor lo ayudó». ");
INSERT INTO spaonbv_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Las ciudades más importantes de su reino fueron Babel, Érec, Acad y Calné. Todas estas ciudades estaban en la región de Sinar. ");
INSERT INTO spaonbv_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","12","De allí salió para Asur, donde edificó las ciudades de Nínive, Rejobot Ir, Cala y la importante ciudad de Resén, que estaba situada entre Nínive y Cala. ");
INSERT INTO spaonbv_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","14","Misrayin fue el antepasado de los ludeos, los anameos, los leabitas, los naftuitas, los patruseos, los caslujitas y los caftoritas, que son los antepasados de los filisteos. ");
INSERT INTO spaonbv_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Canaán fue el padre de Sidón, su hijo mayor, y de Het. ");
INSERT INTO spaonbv_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","18","Además, de Canaán descienden los jebuseos, los amorreos, los gergeseos, los heveos, los araceos, los sineos, los arvadeos, los zemareos y los jamatitas. Después de algún tiempo todas estas familias de los cananeos se separaron y se dispersaron por la tierra. ");
INSERT INTO spaonbv_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Su territorio abarcaba desde Sidón hasta Guerar y Gaza, y pasaba por Sodoma, Gomorra, Admá y Zeboyín, y llegaba hasta Lasa. ");
INSERT INTO spaonbv_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Estos fueron, pues, los descendientes de Cam. Se hallaban dispersos en muchas tierras y naciones y hablaban muchas lenguas. ");
INSERT INTO spaonbv_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Sem, el hermano mayor de Jafet, también tuvo hijos, y fue el antepasado de todos los descendientes de Éber. ");
INSERT INTO spaonbv_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Los hijos de Sem fueron: Elam, Asur, Arfaxad, Lud y Aram. ");
INSERT INTO spaonbv_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Los hijos de Aram fueron: Uz, Hul, Guéter y Mas. ");
INSERT INTO spaonbv_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arfaxad fue el padre de Selaj, y Selaj fue el padre de Éber. ");
INSERT INTO spaonbv_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Éber tuvo dos hijos: El primero se llamó Péleg, porque fue durante su vida que la gente del mundo se dividió. El otro hijo de Éber fue Joctán. ");
INSERT INTO spaonbv_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","30","Joctán fue el padre de Almodad, Sélef, Jazar Mávet, Yeraj, Hadorán, Uzal, Diclá, Obal, Abimael, Sabá, Ofir, Javilá y Jobab. Todos estos fueron los descendientes de Joctán, quienes ocuparon la región que va desde Mesá hasta Sefar, es decir, la región montañosa que queda al oriente. ");
INSERT INTO spaonbv_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Así que estos fueron los descendientes de Sem, según sus familias, sus regiones, sus países y sus idiomas. ");
INSERT INTO spaonbv_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","En resumen, todos estas son las familias que descienden de Noé, según sus pueblos y naciones. Después del diluvio, todas estas familias se esparcieron por todas partes y formaron las naciones que hay en el mundo. ");
INSERT INTO spaonbv_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","En ese tiempo, toda la gente hablaba un mismo idioma. ");
INSERT INTO spaonbv_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Al salir hacia el oriente, encontraron una llanura en la región de Sinar, y se quedaron a vivir allí. ");
INSERT INTO spaonbv_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Un día decidieron hacer ladrillos y cocerlos en el fuego. De ese modo usaron los ladrillos en lugar de piedras. Además, emplearon el alquitrán en lugar de mezcla. ");
INSERT INTO spaonbv_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Después dijeron: «Construyamos una ciudad con una torre altísima, que toque el cielo. Así nos haremos muy famosos y no tendremos que vivir por siempre errantes». ");
INSERT INTO spaonbv_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Entonces el Señor bajó para ver la ciudad y la torre que estaban edificando, ");
INSERT INTO spaonbv_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","y pensó: «Esto lo pueden hacer porque forman un solo pueblo y hablan el mismo idioma. Esa torre es sólo la primera de muchas otras obras que harán. ¡Todo lo que se propongan hacer lo harán y nadie podrá detenerlos! ");
INSERT INTO spaonbv_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Vamos, descendamos y hagamos que hablen diversos idiomas, para que no puedan entenderse». ");
INSERT INTO spaonbv_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Así, pues, Dios los esparció por toda la tierra, lo que impidió que terminaran la construcción de la ciudad. ");
INSERT INTO spaonbv_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Por esta razón la ciudad se llamó Babel, porque fue allí donde Dios los confundió haciendo que hablaran diversos idiomas, y los esparció por toda la tierra. ");
INSERT INTO spaonbv_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","La siguiente es la lista de los descendientes de Sem: Dos años después del diluvio, cuando Sem cumplió los cien años, tuvo un hijo al que llamó Arfaxad. ");
INSERT INTO spaonbv_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Después de que Arfaxad nació, Sem vivió quinientos años más, y tuvo más hijos e hijas. ");
INSERT INTO spaonbv_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arfaxad tenía treinta y cinco años cuando le nació su hijo Selaj. ");
INSERT INTO spaonbv_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Después de que Selaj nació, Arfaxad vivió cuatrocientos tres años más, y tuvo más hijos e hijas. ");
INSERT INTO spaonbv_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Selaj tenía treinta años cuando le nació su hijo Éber. ");
INSERT INTO spaonbv_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Después de que Éber nació, Selaj vivió cuatrocientos tres años más, y tuvo más hijos e hijas. ");
INSERT INTO spaonbv_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Éber tenía treinta y cuatro años cuando le nació su hijo Péleg. ");
INSERT INTO spaonbv_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Después de que Péleg nació, Éber vivió cuatrocientos treinta años más, y tuvo más hijos e hijas. ");
INSERT INTO spaonbv_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Péleg tenía treinta años cuando le nació su hijo Reú. ");
INSERT INTO spaonbv_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Después de que Reú nació, Péleg vivió doscientos nueve años más, y tuvo más hijos e hijas. ");
INSERT INTO spaonbv_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reú tenía treinta y dos años cuando le nació su hijo Serug. ");
INSERT INTO spaonbv_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Después de que Serug nació, Reú vivió doscientos siete años más, y tuvo más hijos e hijas. ");
INSERT INTO spaonbv_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serug tenía treinta años cuando le nació su hijo Najor. ");
INSERT INTO spaonbv_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Después de que Najor nació, Serug vivió doscientos años más, y tuvo más hijos e hijas. ");
INSERT INTO spaonbv_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Najor tenía veintinueve años cuando le nació su hijo Téraj. ");
INSERT INTO spaonbv_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Después de que Téraj nació, Najor vivió ciento diecinueve años más, y tuvo más hijos e hijas. ");
INSERT INTO spaonbv_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","A sus setenta años, a Téraj ya le habían nacido sus hijos Abram, Najor y Jarán. ");
INSERT INTO spaonbv_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","La siguiente es la lista de los descendientes de Téraj, el padre de Abram, Najor y Jarán. Jarán, que fue el padre de Lot, ");
INSERT INTO spaonbv_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","murió en el mismo lugar en el que había nacido, es decir, en Ur de los caldeos. Jarán murió antes que su padre Téraj. ");
INSERT INTO spaonbv_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram se casó con Saray, y Najor se casó con Milca. Esta era hija de Jarán y hermana de Iscá. ");
INSERT INTO spaonbv_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Saray no podía tener hijos, pues era estéril. ");
INSERT INTO spaonbv_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Un día Téraj decidió salir de Ur de los caldeos para irse a vivir al país de Canaán. Se llevó consigo a su hijo Abram, a su nieto Lot y a su nuera Saray. Pero cuando llegaron a la ciudad de Jarán, se quedaron viviendo en ese lugar. ");
INSERT INTO spaonbv_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Fue allí en Jarán donde murió Téraj, cuando tenía doscientos cinco años de edad. ");
INSERT INTO spaonbv_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","El Señor le dijo a Abram: «Deja tu tierra, tus familiares y la casa de tu padre, y vete a la región que te voy a mostrar. ");
INSERT INTO spaonbv_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Te voy a convertir en una nación muy grande; te voy a bendecir, y te haré un hombre muy famoso. ¡Serás de bendición para muchas personas! ");
INSERT INTO spaonbv_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","A los que te bendigan, yo los bendeciré; pero a quienes te maldigan, yo los maldeciré. ¡Por medio de ti, yo bendeciré a todos los pueblos del mundo!». ");
INSERT INTO spaonbv_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Tal como el Señor se lo había ordenado, Abram salió de Jarán, y con él también se fue Lot. En aquel tiempo Abram tenía setenta y cinco años. ");
INSERT INTO spaonbv_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Cuando Abram salió hacia la región de Canaán se llevó a su esposa Saray, a su sobrino Lot y a toda la gente que había comprado en Jarán. También se llevó todas las cosas y animales que había conseguido. ");
INSERT INTO spaonbv_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram atravesó toda la región de Canaán hasta que llegó a Siquén, donde está la encina sagrada de Moré. En ese tiempo, los cananeos eran los que vivían en aquella región. ");
INSERT INTO spaonbv_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","El Señor se le apareció allí a Abram y le dijo: «Esta tierra se la voy a dar a tus descendientes». Entonces Abram construyó un altar para adorar al Señor, porque se le había aparecido allí. ");
INSERT INTO spaonbv_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Después, Abram salió de aquel lugar y viajó hacia el sur, a la región montañosa que queda entre Betel por el oeste y Hai por el este. Allí estableció su campamento e hizo un altar al Señor, e invocó su nombre. ");
INSERT INTO spaonbv_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Luego, Abram continuó su viaje hacia el sur, deteniéndose en varios lugares, hasta que llegó a la región del Néguev. ");
INSERT INTO spaonbv_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","En ese tiempo hubo mucha hambre en aquella región; así que Abram se fue a vivir a Egipto. ");
INSERT INTO spaonbv_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Cuando ya estaban cerca de Egipto, Abram le dijo a su esposa Saray: «¡Eres una mujer muy hermosa, y ");
INSERT INTO spaonbv_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","tan pronto te vean los egipcios y sepan que eres mi esposa, me matarán para quedarse contigo! ");
INSERT INTO spaonbv_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Pero si dices que eres mi hermana, los egipcios me tratarán bien debido a su interés por ti, y me dejarán con vida». ");
INSERT INTO spaonbv_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Y así fue. Cuando llegaron a Egipto, todos hablaban de la belleza de Saray. ");
INSERT INTO spaonbv_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Los funcionarios del faraón también la vieron. Entonces fueron y le contaron al faraón que aquella mujer era muy hermosa. Luego, la llevaron a vivir al palacio. ");
INSERT INTO spaonbv_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Para congraciarse con Saray, el faraón trató muy bien a Abram y le regaló ovejas, vacas, esclavos y esclavas, burros y burras, y camellos. ");
INSERT INTO spaonbv_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Pero, debido a que el faraón llevó a Saray a su palacio, el Señor lo castigó a él y a su familia con terribles enfermedades. ");
INSERT INTO spaonbv_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Entonces el faraón mandó a llamar a Abram, y le dijo: «¿Por qué me has hecho esto? ¿Por qué no me dijiste que Saray es tu esposa? ");
INSERT INTO spaonbv_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Casi la tomo como esposa, confiado en que dijiste que era tu hermana. ¡Aquí está! ¡Tómala y vete!». ");
INSERT INTO spaonbv_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Luego, el faraón ordenó a sus servidores que sacaran de Egipto a Abram y a su esposa, junto con todas sus posesiones. ");
INSERT INTO spaonbv_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Cuando Abram salió de Egipto con su esposa, con Lot y con todas sus posesiones, se dirigió hacia la región del Néguev. ");
INSERT INTO spaonbv_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram era muy rico, pues tenía oro, plata y mucho ganado. ");
INSERT INTO spaonbv_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Desde el Néguev, Abram avanzó lentamente hasta llegar a Betel. Una vez allí, se dirigió al lugar donde había acampado antes, es decir, entre Betel y Hai. ");
INSERT INTO spaonbv_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","En ese mismo lugar Abram había construido un altar para invocar el nombre del Señor. ");
INSERT INTO spaonbv_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","También Lot, que iba con Abram, tenía muchas ovejas, vacas y carpas. ");
INSERT INTO spaonbv_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","De modo que ya no podían vivir juntos, pues el campo no era suficiente para alimentar a tantos animales. ");
INSERT INTO spaonbv_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Por eso, había muchas peleas entre los pastores que cuidaban los rebaños de Abram y los que cuidaban los rebaños de Lot. En ese tiempo, los cananeos y los ferezeos todavía vivían en aquella región. ");
INSERT INTO spaonbv_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Así que un día Abram le dijo a Lot: «Recuerda que tú y yo somos parientes, de modo que no es bueno que haya peleas entre nosotros, ni entre tus pastores y los míos. ");
INSERT INTO spaonbv_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Mira, ahí tienes una gran extensión de tierra. Escoge dónde quieres irte a vivir. Si te vas a la región que está a la izquierda, entonces yo me iré a la que está a la derecha; pero si te vas a la derecha, entonces yo me iré a la izquierda». ");
INSERT INTO spaonbv_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lot contempló toda la extensa llanura del Jordán, y vio que toda esa región, hasta Zoar, era muy buena para la agricultura, pues tenía mucha agua. Era como el jardín del Señor o como la tierra de Egipto. Así era esa región antes de que el Señor destruyera a Sodoma y a Gomorra. ");
INSERT INTO spaonbv_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","De modo que Lot escogió la región que estaba al oriente, es decir, la llanura del Jordán, y se fue a vivir allá. Fue así como Abram y Lot se separaron. ");
INSERT INTO spaonbv_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram se quedó viviendo en Canaán, mientras que Lot habitó entre las ciudades de la llanura, cerca de la ciudad de Sodoma. ");
INSERT INTO spaonbv_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Los habitantes de Sodoma eran muy perversos y ofendían mucho al Señor con sus horribles pecados. ");
INSERT INTO spaonbv_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","15","Después de que Lot se fue, el Señor le dijo a Abram: «Mira toda la tierra que tienes a tu alrededor por el norte, el sur, el oriente y el occidente. Toda esa tierra será para ti y para todos tus descendientes. ");
INSERT INTO spaonbv_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Además, tu descendencia será tan numerosa como el polvo de la tierra. De modo que sólo quien sea capaz de contar el polvo de la tierra, podrá contar a tus descendientes. ");
INSERT INTO spaonbv_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Ahora, pues, levántate y recorre toda esa región, a lo largo y a lo ancho, porque te la voy a regalar». ");
INSERT INTO spaonbv_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Así que Abram se fue a vivir junto al bosque de encinas de Mamré, que queda cerca de Hebrón. Allí construyó un altar para el Señor. ");
INSERT INTO spaonbv_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","En esa época, Amrafel era el rey de Sinar, Arioc era el rey de Elasar, Quedorlaómer era el rey de Elam, y Tidal era el rey de Goyim. ");
INSERT INTO spaonbv_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Estos reyes se unieron para ir a pelear contra los reyes Bera de Sodoma, Birsá de Gomorra, Sinab de Admá, Semeber de Zeboyín, y contra el rey de Bela, que es el mismo pueblo conocido como Zoar. ");
INSERT INTO spaonbv_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Estos cinco últimos reyes reunieron sus ejércitos en el valle de Sidín, que es donde está el Mar Muerto. ");
INSERT INTO spaonbv_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Durante doce años habían estado sometidos al rey Quedorlaómer, pero en el año decimotercero decidieron rebelarse contra él. ");
INSERT INTO spaonbv_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Por eso, al año siguiente, el rey Quedorlaómer y los otros reyes que lo apoyaban fueron a la región de Astarot Carnayin y derrotaron a los refaítas. Luego fueron a Jam y derrotaron a los zuzitas; después fueron a la región de Save Quiriatayin y derrotaron a los emitas. ");
INSERT INTO spaonbv_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Por último, pasaron a las montañas de Seír y derrotaron a los horeos, a quienes persiguieron hasta El Parán, que está cerca del desierto. ");
INSERT INTO spaonbv_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Ya de regreso, Quedorlaómer y sus compañeros fueron a Enmispat, que también se conoce como Cades. Derrotaron a los amalecitas y conquistaron su territorio; también derrotaron a los amorreos que vivían en Jazezón Tamar. ");
INSERT INTO spaonbv_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","9","Entonces los reyes de Sodoma, Gomorra, Admá Zeboyín y Bela, que es Zoar, fueron al valle de Sidín para pelear contra Quedorlaómer, rey de Elam, y sus aliados, es decir: Tidal, rey de Goyim, Amrafel, rey de Sinar, y Arioc, rey de Elasar. De modo que eran cinco reyes contra cuatro. ");
INSERT INTO spaonbv_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Los reyes de Sodoma y Gomorra, al verse derrotados, intentaron huir junto con sus ejércitos, pero cayeron en los pozos de alquitrán que había en el valle de Sidín. Los que lograron salir de allí, se escondieron en la montaña. ");
INSERT INTO spaonbv_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Los que ganaron la batalla fueron a las ciudades de Sodoma y Gomorra se llevaron todos los alimentos y artículos de valor que había en ellas. Después emprendieron el regreso a sus países. ");
INSERT INTO spaonbv_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Como Lot, el sobrino de Abram, vivía en Sodoma, también se lo llevaron, junto con todo lo que tenía. ");
INSERT INTO spaonbv_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Uno de los hombres que logró escapar fue hasta donde estaba Abram, el hebreo, y le contó todo lo que había sucedido. Abram estaba viviendo junto al bosque de encinas que pertenecía a Mamré, el amorreo. Mamré era hermano de Escol y de Aner, que eran amigos de Abram. ");
INSERT INTO spaonbv_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Cuando Abram oyó que a Lot se lo habían llevado preso, reunió a todos los trescientos dieciocho criados que habían nacido en su casa. Luego, con ellos, salió a perseguir a los que se habían llevado a Lot, y los alcanzó en la ciudad de Dan. ");
INSERT INTO spaonbv_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Esperó hasta la noche y los atacó por sorpresa, los derrotó y los persiguió hasta Hobá, que queda al norte de Damasco. ");
INSERT INTO spaonbv_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","De modo que Abram pudo recuperar todas las cosas que esos hombres se habían robado. También logró liberar a su sobrino Lot y sus posesiones, a las mujeres y a todas las demás personas que habían sido capturadas. ");
INSERT INTO spaonbv_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Cuando Abram regresaba de derrotar a Quedorlaómer y a sus aliados, el rey de Sodoma salió a recibirlo al valle de Save, conocido también como el valle del Rey. ");
INSERT INTO spaonbv_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","También Melquisedec, que era rey de Salén y sacerdote del Dios Altísimo, le llevó pan y vino. ");
INSERT INTO spaonbv_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Luego, Melquisedec bendijo a Abram con estas palabras: «Abram, que el Dios Altísimo, creador del cielo y de la tierra, te bendiga. ");
INSERT INTO spaonbv_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","¡Alabado sea el Dios Altísimo que te permitió derrotar a tus enemigos!». Entonces Abram le entregó a Melquisedec la décima parte de todos los bienes que había recuperado. ");
INSERT INTO spaonbv_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","El rey de Sodoma le dijo a Abram: ―Entrégame las personas que liberaste y quédate con todas las cosas que has recuperado. ");
INSERT INTO spaonbv_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","23","Pero Abram le contestó: ―Le prometí al Señor, el Dios Altísimo, creador del cielo y de la tierra, que no me quedaría con nada de lo que es tuyo, ni siquiera con un cordón o una correa de una sandalia. Así no podrás decir jamás: “Abram se hizo rico, porque se quedó con mis bienes”. ");
INSERT INTO spaonbv_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","No quiero nada para mí. Lo único que acepto de ti son los alimentos que ya comieron mis criados. Pero mis amigos Aner, Escol y Mamré sí tomarán lo que les corresponde. ");
INSERT INTO spaonbv_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Poco tiempo después, el Señor le dijo a Abram: ―Abram, no tengas miedo, porque yo te protejo, y te voy a dar una recompensa muy grande. ");
INSERT INTO spaonbv_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Pero Abram contestó: ―Mi Señor y Dios, ¿para qué me servirá todo lo que me vas a dar, si no tengo hijos? En ese caso, como no me has dado un hijo, todo lo que me regales le quedará a Eliezer de Damasco, que es uno de mis criados. ");
INSERT INTO spaonbv_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Entonces el Señor le dijo: ―Vas a tener un hijo, y será él quien se quede con todo lo que tienes. ¡De modo que ningún extraño se quedará con tus bienes! ");
INSERT INTO spaonbv_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Luego el Señor hizo que Abram saliera de su carpa, y le dijo: ―Intenta contar todas las estrellas que hay en el cielo, y verás que no puedes. ¡Pues, así de numerosos serán tus descendientes! ");
INSERT INTO spaonbv_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Y Abram le creyó al Señor, y esto le agradó al Señor y, por eso, lo consideró un hombre justo. ");
INSERT INTO spaonbv_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Y le dijo: ―Yo soy el Señor que te saqué de la ciudad de Ur de los caldeos, para regalarte esta tierra. ");
INSERT INTO spaonbv_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Pero Abram le respondió: ―Mi Señor y Dios, ¿cómo podré estar seguro de que me la vas a regalar? ");
INSERT INTO spaonbv_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Entonces el Señor le dijo: ―Trae una ternera, una cabra y un carnero, de tres años cada uno. También consigue una tórtola y un pichón de paloma. ");
INSERT INTO spaonbv_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abram consiguió estos animales, los partió por la mitad, y puso una mitad frente a la otra. Pero las aves no las partió. ");
INSERT INTO spaonbv_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Entonces las aves de rapiña se lanzaban sobre los cuerpos de los animales muertos, pero Abram las espantaba. ");
INSERT INTO spaonbv_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Al anochecer, Abram se quedó profundamente dormido, y se sintió rodeado de una oscuridad aterradora. ");
INSERT INTO spaonbv_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Entonces el Señor le dijo: ―Abram, ten la seguridad de que tus descendientes van a vivir como esclavos en una tierra extraña, y los tratarán mal durante unos cuatrocientos años. ");
INSERT INTO spaonbv_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Pero yo castigaré a la nación que los esclavice, y haré que tus descendientes salgan libres y con mucha riqueza. ");
INSERT INTO spaonbv_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","En cuanto a ti, debes saber que morirás en paz y a una edad muy avanzada. ");
INSERT INTO spaonbv_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Después de cuatro generaciones, tus descendientes regresarán a esta tierra. En ese momento será tanta la maldad de los amorreos que viven aquí, que tendré que castigarlos. ");
INSERT INTO spaonbv_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Cuando el sol se ocultó, y anocheció por completo, Abram vio que por entre los animales muertos se paseaba un horno que echaba humo y una antorcha encendida. ");
INSERT INTO spaonbv_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Ese día el Señor hizo un pacto con Abram, y le dijo: ―A tus descendientes les voy a dar toda la tierra que va desde el río de Egipto hasta el gran río, es decir, el río Éufrates. ");
INSERT INTO spaonbv_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","21","Esta tierra es la que habitan actualmente los quenitas, los quenizitas, los cadmoneos, los hititas, los ferezeos, los refaítas, los amorreos, los cananeos, los gergeseos y los jebuseos. ");
INSERT INTO spaonbv_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Saray, la esposa de Abram, no había podido tener hijos. Pero como tenía una esclava egipcia llamada Agar, ");
INSERT INTO spaonbv_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","3","Saray la tomó y se la llevó a Abram para que durmiera con ella. Saray le dijo a Abram: ―Como el Señor no me ha permitido tener hijos, te ruego que te acuestes con mi esclava, para que yo pueda tener hijos por medio de ella. Abram estuvo de acuerdo con lo que le propuso Saray. Esto ocurrió cuando ya llevaban diez años viviendo en Canaán. ");
INSERT INTO spaonbv_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Así que Abram se acostó con Agar, y ella quedó embarazada. Cuando Agar supo que estaba embarazada, comenzó a portarse mal con Saray, su dueña. ");
INSERT INTO spaonbv_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Por eso, Saray le dijo a Abram: ―¡Tú tienes la culpa de que esta esclava me trate con desprecio! Yo te permití que durmieras con ella, y ahora que sabe que está embarazada se porta mal conmigo. ¡Que sea el Señor el que determine quién de nosotros tiene la culpa! ");
INSERT INTO spaonbv_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Entonces Abram le dijo a Saray: ―La muchacha es tu esclava, así que haz con ella lo que quieras. Saray comenzó a maltratar tanto a Agar, que esta decidió huir. ");
INSERT INTO spaonbv_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","El ángel del Señor la encontró en el desierto, junto a un pozo que se halla en el camino que va hacia la región de Sur, ");
INSERT INTO spaonbv_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","y le preguntó: ―Agar, esclava de Saray, ¿de dónde vienes, y a dónde vas? ―Estoy huyendo de Saray, mi dueña —respondió Agar. ");
INSERT INTO spaonbv_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Entonces el ángel del Señor le dijo: ―Regresa adonde tu dueña, y obedécela. ");
INSERT INTO spaonbv_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Además, el ángel del Señor le dijo: ―Tus descendientes serán tan numerosos que no será posible contarlos. ");
INSERT INTO spaonbv_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Estás embarazada y tendrás un hijo, y lo llamarás Ismael (Dios oye), porque el Señor ha escuchado tu dolor. ");
INSERT INTO spaonbv_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ismael será un hombre rebelde, como un potro salvaje. Peleará contra todos, y todos pelearán contra él; pero vivirá cerca de sus hermanos. ");
INSERT INTO spaonbv_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Agar llamó al Señor, que hablaba con ella, «el Dios que me ve», pues se decía para sus adentros: «He visto al Dios que me ve». ");
INSERT INTO spaonbv_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Por eso, a este pozo, que está entre Cades y Béred, se le conoce como el «Pozo del Viviente que me ve». ");
INSERT INTO spaonbv_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Así que Agar le dio un hijo a Abram, el cual lo llamó Ismael. ");
INSERT INTO spaonbv_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abram tenía ochenta y seis años cuando nació Ismael. ");
INSERT INTO spaonbv_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Cuando Abram tenía noventa y nueve años, el Señor se le apareció y le dijo: ―Yo soy el Dios Todopoderoso. Vive siempre de acuerdo con mi voluntad y haz lo correcto, ");
INSERT INTO spaonbv_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","y yo te prometo que te daré una descendencia numerosísima. ");
INSERT INTO spaonbv_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Entonces Abram se inclinó hasta tocar el suelo con su frente. Dios, por su parte, continuó diciéndole: ");
INSERT INTO spaonbv_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","―El pacto que voy a hacer contigo es este: Serás el padre de muchas naciones. ");
INSERT INTO spaonbv_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Además, a partir de hoy ya no te llamarás Abram (Padre Excelso), sino Abraham (Padre de Naciones), porque haré que seas el padre de muchas naciones. ");
INSERT INTO spaonbv_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Te daré muchísimos descendientes, de modo que de ti saldrán reyes y naciones. ");
INSERT INTO spaonbv_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Contigo y con tus descendientes haré un pacto que durará para siempre. Debido a este pacto, yo seré tu Dios y el Dios de tus descendientes. ");
INSERT INTO spaonbv_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","A ti y a tus descendientes les regalaré para siempre toda la tierra de Canaán, es decir, la tierra en que estás viviendo ahora. Y yo seré su Dios. ");
INSERT INTO spaonbv_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","10","Además Dios dijo a Abraham: ―A través de todos los tiempos, tú y tus descendientes deberán obedecer este pacto: todos los varones que haya en tu pueblo deberán ser circuncidados. ");
INSERT INTO spaonbv_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","A cada varón le cortarán la carne de su prepucio. Esta será la señal de que tú y ellos aceptan mi pacto. ");
INSERT INTO spaonbv_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Todo varón será circuncidado al octavo día de su nacimiento. Esto se aplica tanto a los niños que nazcan en tu casa, como a aquellos que hayan sido comprados por dinero a algún extranjero. Este es un pacto que deberán obedecer siempre tus descendientes. ");
INSERT INTO spaonbv_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Todos, sin excepción, deben ser circuncidados. De esa manera todos los varones llevarán en su cuerpo la señal de mi pacto, que es un pacto que nunca se acabará. ");
INSERT INTO spaonbv_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Cualquiera que no cumpla con las condiciones del pacto, es decir, que no sea circuncidado, será eliminado de mi pueblo, por haber desobedecido mi pacto. ");
INSERT INTO spaonbv_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Dios también le dijo a Abraham: ―Tu esposa ya no se llamará Saray, sino Sara (Princesa). ");
INSERT INTO spaonbv_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Yo la bendeciré y te daré un hijo de ella. La bendeciré tanto, que será madre de naciones y de reyes. ");
INSERT INTO spaonbv_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abraham se inclinó hasta tocar el suelo con su frente, y se rio de pensar que un hombre de cien años pudiera ser padre, y que Sara pudiera tener un hijo a los noventa años. ");
INSERT INTO spaonbv_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Por eso le dijo a Dios: ―¡Sería suficiente con que Ismael contara con tu bendición! ");
INSERT INTO spaonbv_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Dios le respondió: ―Lo que acabo de decirte es que tu esposa Sara te dará un hijo, al cual lo llamarás Isaac (Risa). Con él y con sus descendientes confirmaré mi pacto para siempre. ");
INSERT INTO spaonbv_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","En cuanto a Ismael, también te he oído y haré lo que me has pedido. Le daré una descendencia muy numerosa, y haré que de él salga una gran nación. Él será el padre de doce príncipes. ");
INSERT INTO spaonbv_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Pero mi pacto es con Isaac, el hijo que te dará Sara dentro de un año, por esta misma época. ");
INSERT INTO spaonbv_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Terminada la conversación, Dios se fue. ");
INSERT INTO spaonbv_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Aquel mismo día Abraham tomó a su hijo Ismael y lo circuncidó. También tomó a los esclavos, tanto a los que habían nacido en su casa como a los que había comprado, y a todos los demás varones que había en su casa, y los circuncidó, tal como Dios le había dicho. ");
INSERT INTO spaonbv_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","25","Abraham tenía noventa y nueve años cuando fue circuncidado, y su hijo Ismael tenía trece. ");
INSERT INTO spaonbv_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Tanto Abraham como Ismael fueron circuncidados el mismo día. ");
INSERT INTO spaonbv_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","También, ese mismo día, fueron circuncidados todos los varones que había en su casa, tanto los que habían nacido en ella como los que le había comprado a extranjeros. ");
INSERT INTO spaonbv_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","El Señor se le apareció a Abraham junto al bosque de encinas de Mamré. Ese día Abraham estaba sentado a la entrada de su carpa, a la hora más caliente del día. ");
INSERT INTO spaonbv_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Abraham levantó la mirada y vio que tres hombres se dirigían hacia él. Se levantó de un salto y corrió al encuentro de ellos. Se inclinó hasta tocar el suelo con su frente, ");
INSERT INTO spaonbv_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","y dijo: ―Mi señor, le ruego por favor que no pase de largo, sino que se quede aquí un momento. ");
INSERT INTO spaonbv_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Voy a pedir que les traigan agua para que se laven los pies, y podrán quedarse a descansar bajo la sombra de este árbol. ");
INSERT INTO spaonbv_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Y ya que han pasado por la carpa de este servidor de ustedes, les voy a traer algo de comer, para que repongan sus fuerzas y puedan continuar su viaje. ―Muy bien —dijeron ellos—, aceptamos tu invitación. ");
INSERT INTO spaonbv_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Entonces Abraham entró corriendo a la carpa y le dijo a Sara: ―Toma pronto unos veinte kilos de la mejor harina, amásalos y haz unos panes. ");
INSERT INTO spaonbv_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Luego corrió al lugar donde estaba el ganado, tomó el mejor ternero, y le dijo a uno de sus sirvientes que lo preparara inmediatamente. ");
INSERT INTO spaonbv_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Junto con el becerro ya preparado, Abraham les ofreció leche y mantequilla. Mientras los hombres comían, Abraham se quedo de pie junto a ellos, debajo del árbol. ");
INSERT INTO spaonbv_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","―¿Dónde está tu esposa Sara? —le preguntaron. ―En la carpa —contestó Abraham. ");
INSERT INTO spaonbv_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Entonces uno de ellos dijo: ―El próximo año, por este tiempo, volveré a visitarte. En esa fecha Sara tendrá un hijo. Sara escuchaba detrás de ellos, a la entrada de la carpa. ");
INSERT INTO spaonbv_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Ahora bien, Abraham y Sara eran muy viejos, y hacía tiempo que Sara no tenía la menstruación. ");
INSERT INTO spaonbv_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Por eso, Sara no pudo evitar reírse, mientras pensaba: «¿Será posible que vaya a tener semejante placer, siendo que tanto mi marido como yo somos muy viejos?». ");
INSERT INTO spaonbv_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Entonces el Señor le dijo a Abraham: ―¿Por qué se rio Sara? ¿A caso no cree que pueda tener un hijo a pesar de su edad? ");
INSERT INTO spaonbv_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","¿Hay algo que sea difícil para el Señor? Como te dije, el próximo año, por este tiempo, volveré a visitarte, y para entonces Sara tendrá un hijo. ");
INSERT INTO spaonbv_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Cuando Sara escuchó esto, tuvo miedo y quiso defenderse. Por eso dijo: ―No me reí. Pero el Señor le contestó: ―Sí te reíste. ");
INSERT INTO spaonbv_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Cuando terminaron de comer, los visitantes se levantaron para seguir su viaje hacia Sodoma. Abraham los acompañó hasta cierto lugar, y los despidió. ");
INSERT INTO spaonbv_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Pero el Señor pensó: «¿Le ocultaré a Abraham lo que estoy pensando hacer? ");
INSERT INTO spaonbv_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","¿Acaso no lo convertiré en una nación grande y poderosa, y haré que sea una fuente de bendición para todas las naciones de la tierra? ");
INSERT INTO spaonbv_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Estoy seguro de que enseñará a sus descendientes a obedecerme, de modo que cuando él muera ellos continúen practicando la justicia y la honestidad. Yo, por mi parte, le cumpliré a Abraham todo lo que le he prometido». ");
INSERT INTO spaonbv_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Así que el Señor le dijo a Abraham: ―Ya no puedo aguantar más la queja que hay contra Sodoma y Gomorra, pues su pecado es muy grande. ");
INSERT INTO spaonbv_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Bajaré a Sodoma para ver si de verdad sus habitantes son tan malos. Voy a comprobar personalmente si lo que se dice de ellos es verdad o mentira. ");
INSERT INTO spaonbv_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","23","Dos de los varones siguieron su camino hacia Sodoma, pero el Señor se quedó con Abraham por un momento. Entonces Abraham se le acercó y le dijo: ―¿Vas a exterminar juntamente al justo con el malvado? ");
INSERT INTO spaonbv_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Si encontraras cincuenta justos en la ciudad, ¿acabarías con todos, y no perdonarías a la gente de ese lugar por amor a los cincuenta justos? ");
INSERT INTO spaonbv_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","¡Jamás se te vaya a ocurrir matar al justo junto con el malvado! ¡Jamás vayas a tratar de la misma manera al justo y al malvado! ¿Acaso el Juez de toda la tierra no hará lo que es correcto? ");
INSERT INTO spaonbv_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Y el Señor le contestó: ―Si encontrara cincuenta justos, perdonaría a todos los demás, por amor a los justos. ");
INSERT INTO spaonbv_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Y Abraham volvió a decir: ―Puesto que ya comencé a hablar a mi Señor, te ruego que me escuches, aunque tan solo soy un ser humano. ");
INSERT INTO spaonbv_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Supongamos que haya solamente cuarenta y cinco justos, ¿destruirías la ciudad por los cinco que faltan? Y el Señor le dijo: ―Si encontrara en la ciudad cuarenta y cinco justos, no la destruiría. ");
INSERT INTO spaonbv_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Insistió Abraham con sus ruegos: ―Supongamos que hubiera solamente cuarenta. Y el Señor le contestó: ―No la destruiría si encontrara cuarenta justos. ");
INSERT INTO spaonbv_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","―No te enojes conmigo, mi Señor —le rogó Abraham—, si digo algo más. ¿Y si hubiera sólo treinta? Y el Señor le contestó: ―No destruiría la ciudad si encontrara en ella treinta justos. ");
INSERT INTO spaonbv_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Entonces Abraham dijo: ―Es atrevimiento mío hablarte así mi Señor, pero permíteme continuar: Supongamos que haya solamente veinte. Y el Señor le contestó: ―No destruiría la ciudad, por amor a los veinte. ");
INSERT INTO spaonbv_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Finalmente, Abraham dijo: ―No te molestes mi Señor; hablaré sólo una vez más. Supongamos que sólo encontraras diez justos. Y el Señor le contestó: ―Entonces, por amor a los diez, no destruiría la ciudad. ");
INSERT INTO spaonbv_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Cuando el Señor terminó de conversar con Abraham, continuó el viaje hacia Sodoma; y Abraham regresó a su carpa. ");
INSERT INTO spaonbv_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Ya estaba oscureciendo cuando los dos ángeles llegaron a Sodoma. Lot estaba sentado a la entrada de la ciudad. Cuando los vio, se levantó a saludarlos, inclinándose delante de ellos en señal de respeto, ");
INSERT INTO spaonbv_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","y les dijo: ―Señores, vengan a mi casa para que se laven los pies y duerman. Mañana temprano podrán continuar el viaje. ―No, gracias —dijeron ellos—. Pasaremos la noche en la plaza. ");
INSERT INTO spaonbv_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Pero Lot insistió tanto, que ellos le aceptaron la invitación y se fueron con él a la casa. Allí él les sirvió una buena cena con pan sin levadura, recién horneado. ");
INSERT INTO spaonbv_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Todavía no se habían acostado, cuando todos los hombres de Sodoma, desde el más joven hasta el más viejo, rodearon la casa. ");
INSERT INTO spaonbv_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Entonces llamaron a Lot y le dijeron: ―¿Dónde están los hombres que han venido a quedarse en tu casa? ¡Sácalos, pues queremos tener relaciones sexuales con ellos! ");
INSERT INTO spaonbv_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lot salió a hablar con ellos y, después de cerrar la puerta, ");
INSERT INTO spaonbv_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","les dijo: ―Por favor, amigos míos, no vayan a cometer semejante maldad. ");
INSERT INTO spaonbv_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Miren, tengo dos hijas vírgenes. Se las daré para que hagan con ellas lo que bien les parezca, pero no les hagan nada a estos hombres, pues yo los invité a quedarse esta noche en mi casa. ");
INSERT INTO spaonbv_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","―¡Quítate de en medio! —le respondieron—. ¿Con qué derecho nos vas a ordenar lo que debemos hacer? ¡No olvides que eres un extranjero! ¡Ahora te trataremos peor que a ellos! Así que comenzaron a maltratar a Lot, y se acercaron a la puerta para echarla abajo. ");
INSERT INTO spaonbv_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Pero los dos varones agarraron a Lot, lo metieron a la casa, y cerraron la puerta. ");
INSERT INTO spaonbv_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Después dejaron ciegos a los hombres que estaban allí —desde el más joven hasta el más viejo—, de modo que no pudieron encontrar la puerta. ");
INSERT INTO spaonbv_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Luego le preguntaron a Lot: ―Si tienes en la ciudad hijos, hijas, yernos y cualquier otro familiar ¡sácalos de inmediato! ");
INSERT INTO spaonbv_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","El Señor nos ha enviado a destruir esta ciudad, porque ha recibido muchísimas quejas contra los habitantes de este lugar. Así que el Señor no puede perdonarlos más, y ha decidido destruir este lugar. ");
INSERT INTO spaonbv_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Inmediatamente Lot fue y les dijo a los novios de sus hijas: ―¡Apresúrense! ¡Salgan de la ciudad, porque el Señor va a destruirla! Pero los jóvenes creyeron que Lot estaba bromeando. ");
INSERT INTO spaonbv_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Al amanecer, los ángeles le insistieron a Lot: ―¡Date prisa! ¡Toma a tu esposa y a tus dos hijas y sal con ellas de la ciudad, si no quieren morir junto con todos los demás! ");
INSERT INTO spaonbv_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Como Lot se tardaba mucho en salir, los ángeles lo tomaron de la mano, junto con su esposa y sus hijas, y los sacaron de la ciudad. Hicieron esto, porque el Señor tuvo compasión de Lot y de su familia. ");
INSERT INTO spaonbv_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Apenas salieron de la ciudad, uno de los ángeles les dijo: ―¡Corran para que se salven de morir! ¡No miren hacia atrás, ni se detengan en ninguna parte de esta llanura! ¡Vayan a las montañas, para que no perezcan! ");
INSERT INTO spaonbv_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","19","Pero Lot les dijo: ―Por favor, señores míos, ya que han sido tan buenos y misericordiosos conmigo al salvarme la vida, yo les ruego que no me envíen a las montañas, ya que me da miedo que la destrucción me alcance en el camino, y muera. ");
INSERT INTO spaonbv_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Más bien déjenme ir a aquella pequeña ciudad que está más cerca de aquí, para salvar mi vida. En realidad es una ciudad muy pequeña. ");
INSERT INTO spaonbv_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","22","―Muy bien —dijo uno de los ángeles—. Acepto tu súplica y no destruiré esa pequeña ciudad. Pero ¡date prisa! porque nada podemos hacer hasta que te hayas refugiado en ella. Desde aquel tiempo esa ciudad fue llamada Zoar (ciudad pequeña). ");
INSERT INTO spaonbv_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Salía el sol cuando Lot llegó a Zoar. ");
INSERT INTO spaonbv_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Entonces el Señor hizo que desde el cielo lloviera fuego y azufre sobre Sodoma y Gomorra. ");
INSERT INTO spaonbv_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","De este modo destruyó completamente esas ciudades, junto con todos sus habitantes. También acabó con toda la vegetación que había en esa llanura. ");
INSERT INTO spaonbv_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Pero la esposa de Lot miró hacia atrás, y quedó convertida en una estatua de sal. ");
INSERT INTO spaonbv_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Aquella mañana, Abraham se levantó temprano y regresó al lugar donde había estado conversando con el Señor. ");
INSERT INTO spaonbv_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Miró hacia Sodoma y Gomorra, y hacia toda la llanura, y vio que del suelo salía humo, como el humo que sale de un horno. ");
INSERT INTO spaonbv_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Fue así como Dios destruyó esas ciudades de la llanura donde Lot había vivido. Pero Dios se acordó de Abraham y, por eso, libró a Lot de perecer en aquella catástrofe. ");
INSERT INTO spaonbv_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Después Lot, por miedo a la gente de Zoar, dejó la ciudad, junto con sus dos hijas, y se fue a vivir a una cueva que había en la montaña. ");
INSERT INTO spaonbv_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Un día, la hija mayor le dijo a su hermana: ―Ya nuestro padre está muy viejo y, además, no ha quedado hombre alguno en estos lugares con los que podamos casarnos, como es la costumbre. ");
INSERT INTO spaonbv_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Así que vamos a emborracharlo, y nos acostamos con él. De este modo lograremos que nuestro padre tenga descendientes. ");
INSERT INTO spaonbv_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Aquella noche emborracharon a su padre. Entonces la hija mayor tuvo relaciones con él. Pero Lot no se dio cuenta de lo que pasó. ");
INSERT INTO spaonbv_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","A la mañana siguiente la mayor le dijo a la menor: ―Anoche me acosté con mi padre. Vamos a emborracharlo también esta noche, para que tú te acuestes con él; y de esta manera nuestro padre tendrá descendencia. ");
INSERT INTO spaonbv_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Aquella noche volvieron a darle a beber vino hasta emborracharlo. Enseguida, la menor entró, se acostó con él, y salió. Pero Lot no se dio cuenta de lo que pasó. ");
INSERT INTO spaonbv_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Así fue que las dos hijas quedaron embarazadas de su padre. ");
INSERT INTO spaonbv_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","El hijo de la mayor se llamó Moab, y fue el padre de los actuales moabitas. ");
INSERT INTO spaonbv_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","El hijo de la menor fue llamado Ben Amí, y fue el padre de los actuales amonitas. ");
INSERT INTO spaonbv_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","De allí Abraham se trasladó al sur, al territorio de Néguev, y se estableció en Guerar, que queda entre Cades y Sur. ");
INSERT INTO spaonbv_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Allí decía que Sara era su hermana. Por eso, Abimélec, que era el rey de Guerar, hizo que llevaran a Sara a su palacio, para hacerla su esposa. ");
INSERT INTO spaonbv_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Pero esa noche Dios se le apareció a Abimélec en sueños, y le dijo: ―Eres hombre muerto, porque la mujer que tomaste tiene marido. ");
INSERT INTO spaonbv_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Pero como Abimélec todavía no había dormido con ella, le dijo: ―Señor, ¿matarías a un inocente? ");
INSERT INTO spaonbv_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Yo he hecho todo de buena fe, pues Abraham me dijo que ella era su hermana. Además, ella también me dijo que él es su hermano. Así que yo no tengo la culpa. ");
INSERT INTO spaonbv_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","―Sí, lo sé —le respondió el Señor en un sueño—. Es por eso que te impedí que pecaras contra mí, y no te dejé tocarla. ");
INSERT INTO spaonbv_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Ahora devuélvela a su marido y él orará por ti, porque es profeta, y vivirás. Pero si no la devuelves, entonces, morirás tú junto con todos los de tu casa. ");
INSERT INTO spaonbv_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","En la mañana del día siguiente, el rey Abimélec se levantó y reunió a todos sus servidores y les contó lo ocurrido. Al oír esto, todos se llenaron de miedo. ");
INSERT INTO spaonbv_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","10","Luego el rey llamó a Abraham, y le reclamó: ―¿Qué es lo que nos has hecho? ¿Qué te he hecho para que hayas hecho caer sobre mí y sobre mi gente este pecado tan grande? ¡Esto que has hecho no se le hace a nadie! ¿Qué pensabas que ibas a lograr con esa mentira? ");
INSERT INTO spaonbv_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraham respondió: ―Pensé que en este lugar no tendrían ningún respeto por Dios, y que alguien, por quedarse con mi esposa, me mataría. ");
INSERT INTO spaonbv_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Pero en verdad, ella sí es mi hermana, pues es hija de mi padre aunque no de mi madre. Por eso me casé con ella. ");
INSERT INTO spaonbv_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Cuando Dios me ordenó que saliera de la casa de mi padre, le dije a mi esposa: “Donde quiera que vayamos, me vas a hacer el favor de decir que yo soy tu hermano”. ");
INSERT INTO spaonbv_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Entonces el rey Abimélec le dio a Abraham ovejas, bueyes y esclavos de ambos sexos, y le devolvió a Sara. ");
INSERT INTO spaonbv_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","―Mi reino está a tu vista —le dijo el rey—. Elige el lugar que más te agrade para vivir. ");
INSERT INTO spaonbv_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Y, volviéndose a Sara, le dijo: ―Mira, yo le voy a dar a tu hermano mil monedas de plata para compensar cualquier daño que pudiera haberte hecho, y para dar por terminado este asunto tan molesto. De esta manera se restaurará tu buen nombre, y nadie podrá hablar mal de ti. ");
INSERT INTO spaonbv_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Entonces Abraham oró por Abimélec. Y Dios sanó a Abimélec, a su esposa y a sus siervas, y les permitió tener hijos, ");
INSERT INTO spaonbv_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","porque el Señor había dejado estériles a las mujeres que estaban en la casa de Abimélec, debido a lo ocurrido con Sara, la esposa de Abraham. ");
INSERT INTO spaonbv_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","El Señor se acordó de Sara y le cumplió lo que le había prometido. ");
INSERT INTO spaonbv_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Por eso, Sara quedó embarazada y le dio un hijo a Abraham en su vejez, en el tiempo que Dios le había dicho. ");
INSERT INTO spaonbv_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Al hijo que Sara le dio Abraham le dio el nombre de Isaac. ");
INSERT INTO spaonbv_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Cuando el niño cumplió ocho días, Abraham lo circuncidó, tal como Dios le había ordenado. ");
INSERT INTO spaonbv_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Cuando Isaac nació, Abraham ya tenía cien años. ");
INSERT INTO spaonbv_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Y Sara dijo: «Dios me ha hecho reír, y cualquiera que oiga que he tenido un hijo, se reirá conmigo. ");
INSERT INTO spaonbv_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Porque, ¿quién se hubiera atrevido a decirle a Abraham que yo le iba a dar de mamar a un hijo? Sin embargo, ¡le he dado un hijo a Abraham en su vejez!». ");
INSERT INTO spaonbv_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","El niño creció y llegó a la edad en que fue destetado. Y Abraham celebró la ocasión con una gran fiesta. ");
INSERT INTO spaonbv_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Pero Sara vio que Ismael, el hijo que la egipcia Agar le había dado a Abraham, se burlaba de Isaac. ");
INSERT INTO spaonbv_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Entonces fue y le dijo a Abraham: ―Echa a la esclava y a su hijo. ¡Jamás permitiré que el hijo de esa esclava participe de los bienes que le corresponden a mi hijo Isaac! ");
INSERT INTO spaonbv_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Esto le causó mucho dolor a Abraham, porque, después de todo, Ismael también era hijo suyo. ");
INSERT INTO spaonbv_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Pero Dios le dijo a Abraham: ―No te preocupes por el niño ni por la esclava. Haz lo que Sara te ha dicho, porque Isaac es el hijo a través del cual te daré descendencia. ");
INSERT INTO spaonbv_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","También de los descendientes del hijo de la esclava haré una nación, porque es tu hijo. ");
INSERT INTO spaonbv_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Al día siguiente, Abraham se levantó temprano, preparó alimentos para el viaje, ató una vasija de cuero con agua a las espaldas de Agar y la despidió junto con su hijo. Ella se fue y anduvo de un lado para otro por el desierto de Berseba. ");
INSERT INTO spaonbv_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Cuando se le terminó el agua de la vasija, puso al muchacho bajo un arbusto. ");
INSERT INTO spaonbv_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Luego ella fue a sentarse a cierta distancia de allí, pues se decía a sí misma: «No quiero verlo morir». Cuando ella se sentó, el niño se puso a llorar a gritos. ");
INSERT INTO spaonbv_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Entonces Dios oyó el clamor del niño, y el ángel de Dios llamó a Agar desde el cielo y le dijo: ―Agar, ¿qué te pasa? No tengas miedo. Dios ha oído el clamor del niño. ");
INSERT INTO spaonbv_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Anda, levanta al niño y tómalo de la mano, porque haré de él una nación grande. ");
INSERT INTO spaonbv_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Entonces Dios le abrió los ojos y ella vio un pozo. Así que llenó la vasija de cuero y le dio de beber al niño. ");
INSERT INTO spaonbv_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","21","Dios bendijo a Ismael, el cual vivió en el desierto de Parán y se convirtió en un excelente arquero. Su madre lo casó con una egipcia. ");
INSERT INTO spaonbv_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Por este tiempo, el rey Abimélec, acompañado de Ficol, el comandante de sus tropas, fue a donde estaba Abraham y le dijo: ―Es evidente que Dios te bendice y te ayuda en todo lo que emprendes. ");
INSERT INTO spaonbv_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Júrame, por Dios, ahora mismo, que no nos harás daño ni a mí ni a mis hijos ni a mis descendientes. Júrame que, tanto a mí como a los habitantes de este país donde vives como extranjero, nos tratarás con la misma bondad con que yo te he tratado. ");
INSERT INTO spaonbv_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abraham contestó: ―¡Te lo juro! ");
INSERT INTO spaonbv_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Luego, Abraham le hizo el reclamo a Abimélec acerca de un pozo que los siervos de este le habían quitado. ");
INSERT INTO spaonbv_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","―Sólo hasta ahora me entero de esto —exclamó el rey—, y no sé quién tenga la culpa. ¿Por qué no me lo dijiste antes? ");
INSERT INTO spaonbv_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Entonces Abraham le dio ovejas y vacas a Abimélec; y los dos hicieron un pacto. ");
INSERT INTO spaonbv_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abraham puso aparte siete corderas del rebaño. ");
INSERT INTO spaonbv_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Entonces Abimélec le preguntó: ―¿Para qué son esas siete corderas que has separado? ");
INSERT INTO spaonbv_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abraham contestó: ―Es un regalo que te hago como confirmación pública de que este pozo es mío. ");
INSERT INTO spaonbv_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Desde ese momento el pozo fue llamado Berseba (pozo del juramento), porque allí los dos hicieron un juramento. ");
INSERT INTO spaonbv_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Después de haber hecho este pacto en Berseba, el rey Abimélec y Ficol, el comandante de su ejército, volvieron al país de los filisteos. ");
INSERT INTO spaonbv_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Y Abraham plantó un árbol tamarisco allí en Berseba, e invocó el nombre del Señor, el Dios eterno. ");
INSERT INTO spaonbv_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Y vivió Abraham en Filistea durante mucho tiempo. ");
INSERT INTO spaonbv_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Después de algunos años, Dios sometió a Abraham a una prueba. ―¡Abraham! —llamó Dios. ―Aquí estoy —respondió Abraham. ");
INSERT INTO spaonbv_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Entonces Dios le dijo: ―Toma a Isaac, tú único hijo a quien tanto amas, y llévalo a la tierra de Moria. Cuando llegues a allá, me lo ofrecerás en holocausto sobre uno de los cerros que yo te señalaré. ");
INSERT INTO spaonbv_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Al día siguiente, Abraham madrugó y ensilló su burro. Luego cortó la leña para el holocausto, y junto con dos de sus criados y su hijo Isaac salió rumbo al lugar que Dios le había indicado. ");
INSERT INTO spaonbv_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Al tercer día, alzó Abraham los ojos y vio el lugar a lo lejos. ");
INSERT INTO spaonbv_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Entonces Abraham les dijo a sus criados: ―Quédense aquí con el burro, mientras el muchacho y yo vamos allí para adorar. Luego volveremos. ");
INSERT INTO spaonbv_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abraham puso la leña del holocausto sobre los hombros de Isaac, y tomó el cuchillo y el fuego. Entonces los dos continuaron juntos el camino. ");
INSERT INTO spaonbv_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","―¡Padre mío! —dijo Isaac—. Y Abraham le contestó: ―Aquí estoy, ¿qué quieres, hijo mío? ―Tenemos la leña y el fuego —siguió diciendo Isaac—, pero ¿dónde está el cordero para el sacrificio? ");
INSERT INTO spaonbv_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraham le respondió: ―Dios lo proveerá, hijo mío. Y siguieron caminando. ");
INSERT INTO spaonbv_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Cuando llegaron al lugar que Dios le había indicado, Abraham edificó un altar y colocó la leña. Luego ató a su hijo Isaac y lo puso en el altar, sobre la leña. ");
INSERT INTO spaonbv_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Enseguida Abraham tomó el cuchillo, para matar a su hijo. ");
INSERT INTO spaonbv_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","En ese momento, el ángel del Señor le gritó desde el cielo: ―¡Abraham! ¡Abraham! ―Aquí estoy —contestó Abraham. ");
INSERT INTO spaonbv_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","―¡Suelta el cuchillo! No le hagas ningún daño al muchacho —le dijo el ángel—. Ahora sé que de verdad tienes temor de Dios, porque no te negaste a darme a tu único hijo. ");
INSERT INTO spaonbv_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Entonces Abraham miró hacia atrás y vio que un carnero estaba enredado por los cuernos en un arbusto. Fue, tomó el carnero y lo ofreció en holocausto, en lugar de su hijo. ");
INSERT INTO spaonbv_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Por eso, Abraham le puso a ese lugar el nombre de «el Señor proveerá». Hasta hoy se dice: «En un monte el Señor proveerá». ");
INSERT INTO spaonbv_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Poco después, el ángel del Señor llamó nuevamente a Abraham desde el cielo, ");
INSERT INTO spaonbv_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","y le dijo: ―Ya que me obedeciste y no me negaste a tu único hijo, juro por mí mismo —lo digo yo, el Señor—, que ");
INSERT INTO spaonbv_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","te bendeciré muchísimo. Tu descendencia será tan numerosa como las estrellas del cielo y como la arena del mar. Además, tus descendientes poseerán las ciudades de sus enemigos. ");
INSERT INTO spaonbv_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Por haberme obedecido, todas las naciones del mundo serán bendecidas por medio de tus descendientes. ");
INSERT INTO spaonbv_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Entonces Abraham regresó al lugar donde había dejado a sus criados. Luego todos volvieron a Berseba, y Abraham se quedó a vivir allí. ");
INSERT INTO spaonbv_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","23","Después de algún tiempo, Abraham recibió un mensaje en que se le contaba que Milca, la esposa de Najor, el hermano de Abraham, había tenido ocho hijos. El primero de ellos fue Uz. Luego nacieron: Buz y Quemuel, que fue el padre de Aram. A estos les siguieron: Quésed, Jazó, Pildás, Yidlaf y Betuel. Este último fue el padre de Rebeca. Así que estos fueron los ocho hijos que Milca le dio a Najor, el hermano de Abraham. ");
INSERT INTO spaonbv_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Además, con su concubina Reumá, Najor tuvo cuatro hijos, que fueron: Tébaj, Gaján, Tajás y Macá. ");
INSERT INTO spaonbv_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara vivió ciento veintisiete años, ");
INSERT INTO spaonbv_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","y murió en Quiriat Arbá —la que hoy es la ciudad de Hebrón—, en la tierra de Canaán. Abraham lloró por la muerte de Sara y le guardó luto. ");
INSERT INTO spaonbv_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Luego, salió del lugar donde estaba el cadáver de su esposa, y fue a hablar con los hititas. Les dijo: ");
INSERT INTO spaonbv_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","―Aunque soy un extranjero entre ustedes, les suplico que me vendan un sepulcro en el cual pueda sepultar a mi esposa. ");
INSERT INTO spaonbv_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Los hititas le contestaron: ");
INSERT INTO spaonbv_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","¡Señor, por favor, escúchenos! Para nosotros usted es un príncipe poderoso. Escoja el mejor de nuestros sepulcros para que sepulte a su esposa. Ninguno de nosotros le negará su sepulcro para que lo haga. ");
INSERT INTO spaonbv_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Entonces Abraham se inclinó delante de ellos, ");
INSERT INTO spaonbv_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","y les dijo: ―Puesto que tienen la buena voluntad de concedérmelo, díganle a Efrón hijo de Zojar, ");
INSERT INTO spaonbv_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","que, por favor, me venda la cueva de Macpela, que queda al final de su campo. Por supuesto, le pagaré lo que vale, y la usaré como sepultura para mi familia. ");
INSERT INTO spaonbv_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Efrón el hitita, que estaba sentado entre sus familiares, le contestó a Abraham públicamente delante de ellos y de todos los que entraban a la ciudad: ");
INSERT INTO spaonbv_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","―Señor mío, por favor, escúcheme. Le daré el campo, junto con la cueva que está en él. Todos los que están aquí serán testigos de que se los regalo. Vaya y entierre a su esposa. ");
INSERT INTO spaonbv_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Abraham se inclinó nuevamente delante de los habitantes de ese lugar ");
INSERT INTO spaonbv_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","y, en presencia de todos, le respondió a Efrón: ―No, por favor, escúcheme usted. Yo insisto en pagarle el valor de la propiedad. Recíbalo, para que yo pueda enterrar allí a mi esposa. ");
INSERT INTO spaonbv_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Entonces Efrón le respondió: ");
INSERT INTO spaonbv_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","―Bueno, señor mío, la tierra cuesta cuatrocientas monedas de plata. Creo que eso es tan poco que no vamos a discutir por ello. Vaya y entierre a su esposa. ");
INSERT INTO spaonbv_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abraham estuvo de acuerdo con Efrón y, delante de los hititas, le entregó las cuatrocientas monedas de plata de las que usaban corrientemente los comerciantes. ");
INSERT INTO spaonbv_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Fue así como Abraham adquirió el campo de Efrón, que estaba en Macpela, cerca de Mamré, junto con la cueva y todos los árboles que había en él. ");
INSERT INTO spaonbv_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","El negocio se hizo en presencia de los hititas y de todos los que entraban a la ciudad. ");
INSERT INTO spaonbv_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Después de esto, Abraham fue y sepultó a su esposa Sara en la cueva del campo de Macpela, al oriente de Mamré, que se conocía también como Hebrón, en Canaán. ");
INSERT INTO spaonbv_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","De ese modo, el campo, junto con la cueva, dejó de pertenecer a los hititas y pasó a ser propiedad de Abraham para sepultura, pues Abraham lo compró. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham estaba muy viejo, y Dios lo había bendecido en todo. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Un día Abraham le dijo a su mayordomo, que era el más viejo de sus siervos: ―Coloca tu mano en mi entrepierna, ");
INSERT INTO spaonbv_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","y júrame por el nombre del Señor, el Dios del cielo y de la tierra, que no dejarás que mi hijo se case con una muchacha de esta tierra de Canaán, donde yo vivo. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Para que esto no ocurra, irás a mi tierra, a casa de mi familia, y buscarás allí una esposa para mi hijo Isaac. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","El criado le dijo a Abraham: ―Supongamos que yo no pueda hallar una muchacha que quiera venir conmigo a este lugar. Entonces, ¿debo hacer que Isaac se vaya a vivir al país del cual usted salió? ");
INSERT INTO spaonbv_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","―¡No! —advirtió Abraham—. Cuídate de no hacerlo bajo ninguna circunstancia. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Porque el Señor, Dios del cielo, que me ordenó dejar mi tierra y mi familia, y prometió darme esta tierra como propiedad para mí y mis descendientes, enviará a su ángel delante de ti y hará que encuentres allí una doncella para que sea la esposa de mi hijo. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Pero si no lo logras, quedas libre de tu juramento. Pero bajo ninguna circunstancia llevarás a mi hijo para allá. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Entonces el criado colocó su mano en la entrepierna de su amo Abraham, y le juró seguir sus instrucciones. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Tomó diez camellos de su amo, y los cargó con muchos regalos, de las mejores cosas que Abraham tenía, y se fue hacia el pueblo de Najor en Aram Najarayin. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Una vez allí, hizo que los camellos se arrodillaran junto a un pozo de agua que estaba a las afueras de la ciudad. Era la hora de la puesta del sol, cuando las mujeres salían a buscar agua. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Luego comenzó a orar: «Señor, Dios de mi amo Abraham, sé misericordioso con mi amo y ayúdame para cumplir el propósito de mi viaje. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Mira, aquí estoy junto al pozo de agua, a la hora en que las muchachas del pueblo vienen a sacar agua. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Permíteme saber cuál es la joven que tú has escogido para que sea la esposa de tu siervo Isaac. Te suplico que esa joven sea a quien yo le diga: “Por favor, baje su cántaro para que yo pueda tomar un poco de agua”, y que me conteste: “Tome usted, y también le voy a dar de beber a los camellos”. De esta manera podré estar bien seguro de que en verdad amas a mi amo Abraham». ");
INSERT INTO spaonbv_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Todavía estaba orando, cuando vio que se acercaba una muchacha con su cántaro al hombro. Era Rebeca, la hija de Betuel. Este Betuel era el hijo de Milca y de Najor, el hermano de Abraham. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","La joven era muy hermosa y virgen, pues aún no había tenido relaciones sexuales con ningún hombre. Rebeca bajó al pozo, llenó su cántaro de agua y se dispuso a regresar. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Entonces el criado corrió hacia ella y le dijo: ―Le ruego que me permita beber un poco de agua de su cántaro. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","―Con mucho gusto, señor —dijo ella. Y con prontitud inclinó el cántaro para que él pudiera beber. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Cuando el criado terminó de beber, la muchacha dijo: ―También sacaré agua para sus camellos, para que beban hasta que queden satisfechos. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Acto seguido vació el cántaro en el bebedero y fue corriendo varias veces al pozo a sacar agua, hasta que hubo la suficiente para todos los camellos. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Mientras tanto, el criado la observaba en silencio, preguntándose si el Señor le había contestado la oración. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Cuando los camellos terminaron de beber, el criado sacó un pendiente de oro, que pesaba unos seis gramos, y se lo puso a Rebeca en la nariz. También le colocó en los brazos dos brazaletes que pesaban ciento veinte gramos cada uno. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Luego el criado le preguntó: ―¿Por favor, dígame quién es su papá? ¿Habrá lugar en casa de su padre para pasar la noche? ");
INSERT INTO spaonbv_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","―Mi padre es Betuel, hijo de Milca, que es esposa de Najor —contestó ella—. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Y en nuestra casa tenemos abundante comida para los camellos, y una pieza para huéspedes. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","El criado, entonces, se arrodilló y adoró al Señor ");
INSERT INTO spaonbv_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","con la siguiente oración: «¡Alabado sea el Señor, Dios de mi amo Abraham, pues siempre ha sido tan bueno y leal con él! ¡Gracias por haberme guiado directamente a los familiares de mi amo!». ");
INSERT INTO spaonbv_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","La muchacha corrió hasta la casa para contarle estas cosas a su familia. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Rebeca tenía un hermano llamado Labán. Cuando este escuchó todo lo que la muchacha les contó, y además vio el pendiente y los brazaletes que llevaba puestos, salió corriendo hacia el pozo, donde todavía estaba el hombre de pie junto a los camellos. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Al verlo, le dijo: ―¡Venga, usted, bendito del Señor, y quédese con nosotros! No tiene por qué quedarse aquí afuera. ¡Ya le he preparado un lugar para usted. También hay sitio para los camellos! ");
INSERT INTO spaonbv_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","El criado siguió a Labán a la casa. Luego, Labán les llevó agua, para que el criado y sus acompañantes se lavaran los pies. También les quitó a los camellos las cargas que llevaban y les dio suficiente comida. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Cuando les sirvieron la comida, el criado de Abraham dijo: ―No quiero comer nada hasta haberles dicho por qué estoy aquí. ―Muy bien —dijo Labán—, danos tu mensaje. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","―Soy siervo de Abraham —explicó—. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","El Señor ha colmado de bendiciones a mi amo, de modo que él es considerado un gran hombre entre la gente de la tierra donde vive. Dios le ha dado grandes rebaños de ovejas y de vacas, además le ha dado una gran fortuna en plata y oro, y muchos esclavos y esclavas, camellos y burros. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Como si esto fuera poco, Sara, la esposa de mi amo, siendo ya muy anciana, le dio un hijo a mi amo. A ese hijo mi amo le ha dado todo lo que posee. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","38","Y mi amo hizo que yo le prometiera que no dejaría que Isaac se casara con una de las mujeres de Canaán, que es la tierra donde él vive. Por eso, me pidió que viniera a esta lejana tierra, para buscar entre sus familiares una esposa para su hijo. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Yo le pregunté: “¿Y si no puedo encontrar una muchacha que quiera venir?”. Él me respondió: ");
INSERT INTO spaonbv_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“Vendrá, porque mi Señor, en cuya presencia he andado, enviará su ángel contigo y hará que tu misión tenga éxito. Por tanto, busca una muchacha entre la familia de mi padre. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","En caso de que mis familiares no quieran dejar venir a la muchacha, tú quedarás libre de la promesa que me has hecho”. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","»Pues bien, esta tarde, cuando llegué al manantial, hice la siguiente oración: “Señor, Dios de mi amo Abraham, si tú me estás guiando para que mi misión tenga éxito, guíame en la forma siguiente: ");
INSERT INTO spaonbv_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Aquí estoy junto a este pozo, te ruego que me ayudes. Voy a decirle a una muchacha que venga a sacar agua de este pozo: ‘Por favor, deme un poco de agua para beber’. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Si ella me responde: ‘Con mucho gusto, y también le daré agua a los camellos’, entonces sabré que es la muchacha que has escogido para que sea la esposa del hijo de mi amo”. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","»Mientras yo decía estas cosas, apareció Rebeca con el cántaro al hombro, se dirigió al pozo, sacó agua y llenó el cántaro. Yo le dije: “Por favor, deme de beber”. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Ella con prontitud inclinó hacia mi el cántaro para que pudiera beber y me dijo: “Con mucho gusto, señor, y también sacaré agua para sus camellos”. ¡Y así lo hizo! ");
INSERT INTO spaonbv_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Entonces le pregunté: “¿De qué familia es usted?”. Y ella me dijo: “Soy de la familia de Najor. Mi padre es Betuel, hijo de Najor y de Milca”. Entonces le puse el pendiente en la nariz, y los brazaletes en los brazos. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Luego me arrodillé y adoré al Señor. Sí, alabé al Señor, el Dios de mi amo Abraham, porque me había llevado por el camino correcto, hasta encontrar en la casa del hermano de mi amo la esposa para su hijo Isaac. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ahora, díganme si van a ser bondadosos y leales con mi amo Abraham; si no piensan serlo, también díganmelo. Así yo sabré qué camino tomar. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Entonces Labán y Betuel contestaron: ―Es evidente que esto es obra del Señor, de modo que en ese caso nosotros no podemos hacer nada. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Mire, aquí está Rebeca. Tómela y llévesela, para que sea la esposa del hijo de su amo, tal como el Señor lo ha dispuesto. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Al oír la respuesta, el mayordomo de Abraham cayó de rodillas delante del Señor. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Enseguida sacó joyas de plata y de oro y hermosos vestidos para Rebeca, y también les hizo valiosos regalos a la madre y al hermano de ella. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Luego el criado y sus acompañantes cenaron y pasaron allí la noche. Al día siguiente, cuando se levantaron, el criado dijo: ―Debo regresar a casa de mi amo. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Pero el hermano y la mamá de Rebeca le dijeron: ―Queremos que Rebeca se quede con nosotros unos diez días más. Después de ese tiempo se podrá ir. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Pero él les rogó: ―No retarden mi regreso. El Señor ha hecho que mi misión tenga éxito, así que déjenme regresar a donde mi amo. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","―Bien —respondieron—. Llamemos a la muchacha y preguntémosle si quiere irse o no. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Llamaron a Rebeca y le preguntaron: ―¿Quieres irte con este señor? Y ella respondió: ―Sí, me voy con él. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Entonces dejaron ir a Rebeca con el mayordomo y sus acompañantes. Además, permitieron que la mujer que había cuidado a Rebeca desde que era niña fuera también con ella ");
INSERT INTO spaonbv_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","y la despidieron con esta bendición: «Hermana nuestra: ¡que seas madre de millones de hijos! ¡Que tu descendencia conquiste las ciudades de sus enemigos!». ");
INSERT INTO spaonbv_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Entonces Rebeca y sus esclavas subieron a los camellos y se fueron con el criado de Abraham. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Mientras tanto, Isaac, cuyo hogar estaba en el Néguev, había regresado del pozo de Lajay Roí. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Una tarde, salió a caminar por el campo para meditar. De repente, levantó la vista y vio que se acercaban unos camellos. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","También Rebeca levantó la vista, y al ver a Isaac, se bajó del camello, ");
INSERT INTO spaonbv_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","y le preguntó al criado: ―¿Quién es ese hombre que viene por el campo hacia nosotros? ―Es el hijo de mi amo —le contestó. Entonces ella se cubrió el rostro con el velo. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Cuando Isaac llegó hasta ellos, el mayordomo le contó todo lo ocurrido. ");
INSERT INTO spaonbv_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Isaac llevó a Rebeca a la tienda de su madre y la tomó por esposa. Él la amó mucho, y ella le sirvió de especial consuelo por la muerte de su madre. ");
INSERT INTO spaonbv_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham volvió a casarse. Su nueva esposa se llamaba Cetura. ");
INSERT INTO spaonbv_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Con ella Abraham tuvo los siguientes hijos: Zimrán, Jocsán, Medán, Madián, Isbac y Súaj. ");
INSERT INTO spaonbv_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Los dos hijos de Jocsán fueron Sabá y Dedán. Los hijos de Dedán fueron los asureos, los letuseos y los leumeos. ");
INSERT INTO spaonbv_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Los hijos de Madián fueron Efá, Éfer, Janoc, Abidá y Eldá. Todos estos fueron descendientes de Cetura. ");
INSERT INTO spaonbv_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Todo cuanto Abraham poseía se lo dio a Isaac. ");
INSERT INTO spaonbv_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","A los hijos de sus otras mujeres les dio regalos, y los envió hacia el oriente, para alejarlos de Isaac. ");
INSERT INTO spaonbv_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Abraham murió a la avanzada edad de ciento setenta y cinco años ");
INSERT INTO spaonbv_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","10","y fue sepultado por sus hijos Isaac e Ismael en la cueva de Macpela, cerca de Mamré, en el campo que Abraham le había comprado a Efrón, el hijo de Zojar el hitita. Fue sepultado junto a su esposa Sara. ");
INSERT INTO spaonbv_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Después de la muerte de Abraham, Dios derramó abundantes bendiciones sobre Isaac. Isaac se quedó a vivir cerca del pozo de Lajay Roí. ");
INSERT INTO spaonbv_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","15","Esta es una lista, por orden de nacimiento, de los hijos de Ismael, hijo de Abraham y de Agar, la esclava egipcia de Sara: Nebayot, Cedar, Abdel, Mibsán, Mismá, Dumá, Masá, Hadar, Temá, Jetur, Nafis y Cedema. ");
INSERT INTO spaonbv_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Estos doce hijos de Ismael fundaron las doce tribus que llevan sus nombres. ");
INSERT INTO spaonbv_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismael murió a la edad de ciento treinta y siete años, y fue a reunirse con sus antepasados. ");
INSERT INTO spaonbv_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Los descendientes de Ismael habitaron en la región que va desde Javilá hasta Sur, que está frente a Egipto, en la vía que va a Asiria. Así que Ismael se quedó a vivir en frente de todos sus parientes. ");
INSERT INTO spaonbv_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Esta es la historia de Isaac, el hijo de Abraham. ");
INSERT INTO spaonbv_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaac tenía cuarenta años cuando se casó con Rebeca, la hija de Betuel y hermana de Labán. Betuel y Labán eran arameos y vivían en Padán Aram. ");
INSERT INTO spaonbv_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Como Rebeca no podía tener hijos, Isaac oró al Señor a favor de ella. El Señor escuchó su oración, de modo que Rebeca quedó embarazada. ");
INSERT INTO spaonbv_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Pronto se dio cuenta que iba a tener mellizos porque los niños luchaban dentro de su vientre. Preocupada, Rebeca se dijo así misma: «Si las cosas van a seguir así, ¿para qué quiero seguir viviendo?». Entonces fue a consultar al Señor, ");
INSERT INTO spaonbv_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Y Dios le dijo: «En tu vientre hay dos naciones; dos pueblos divididos desde antes de nacer. Uno será más fuerte que el otro, y el mayor servirá al menor». ");
INSERT INTO spaonbv_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Llegado el momento, Rebeca dio a luz. ");
INSERT INTO spaonbv_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","El primero que nació era pelirrojo y tan velludo, que parecía tener un abrigo de piel. Por eso lo llamaron Esaú. ");
INSERT INTO spaonbv_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Luego nació el segundo, que salió aferrado al tobillo de Esaú, por lo que lo llamaron Jacob (Suplantador). Isaac tenía sesenta años cuando nacieron los mellizos. ");
INSERT INTO spaonbv_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Los niños crecieron. Esaú se hizo hábil cazador y le gustaba el campo, mientras que Jacob era muy tranquilo y prefería quedarse en la casa. ");
INSERT INTO spaonbv_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Esaú era el favorito de Isaac, porque le daba de comer de lo que cazaba; pero Jacob era el favorito de Rebeca. ");
INSERT INTO spaonbv_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Un día Jacob estaba haciendo un guiso cuando Esaú llegó del campo muy cansado ");
INSERT INTO spaonbv_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","y le dijo: ―Hombre, ¡estoy muerto de hambre! ¡Por favor, dame un poco de ese guiso rojo! (Por eso, a Esaú también se le conoció con el nombre de Edom, que significa rojo). ");
INSERT INTO spaonbv_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","―Muy bien, pero dame en cambio tu derecho de primogenitura —respondió Jacob. ");
INSERT INTO spaonbv_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","―¿De qué me sirve la primogenitura si me muero de hambre? —replicó Esaú. ");
INSERT INTO spaonbv_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","―Entonces prométeme bajo juramento que me cedes tu derecho de primogenitura —insistió Jacob. Esaú hizo el juramento y vendió así sus derechos de hijo mayor al hermano menor. ");
INSERT INTO spaonbv_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Entonces Jacob le dio pan y el guiso de lentejas. Después de comer y de beber, Esaú se levantó y se fue. Así demostró que no le importaba para nada su derecho de hijo mayor. ");
INSERT INTO spaonbv_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","En aquella época hubo mucha hambre en esa región, tal como había ocurrido antes en el tiempo de Abraham. Isaac entonces se trasladó a la ciudad de Guerar, donde vivía Abimélec el rey de los filisteos. ");
INSERT INTO spaonbv_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Allí se le apareció el Señor y le dijo: «No vayas a Egipto. Quédate en el lugar que yo te indique. ");
INSERT INTO spaonbv_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Vive en este país, y yo estaré contigo y te bendeciré, porque toda esta tierra te la daré a ti y a todos tus descendientes, tal como le prometí a Abraham, tu padre. ");
INSERT INTO spaonbv_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Haré que tus descendientes sean tan numerosos como las estrellas, y les daré todas estas tierras. Por causa de tus descendientes serán bendecidas todas las naciones de la tierra. ");
INSERT INTO spaonbv_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Haré esto por cuanto Abraham obedeció mis mandamientos y mis leyes». ");
INSERT INTO spaonbv_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Isaac, pues, se quedó en Guerar. ");
INSERT INTO spaonbv_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Cuando los hombres del lugar le preguntaban quién era la mujer que lo acompañaba, Isaac decía que era su hermana. Es que Rebeca era tan bonita, que Isaac tenía miedo de que los hombres de aquel lugar lo mataran si se enteraban que ella era su esposa. ");
INSERT INTO spaonbv_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Pero algún tiempo después, Abimélec, el rey de los filisteos, miró por la ventana y vio a Isaac acariciando a Rebeca. ");
INSERT INTO spaonbv_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Abimélec entonces llamó a Isaac y le dijo: ―¡Ah, con que esa mujer es tu esposa! ¿Por qué dijiste que era tu hermana? ―Porque tuve miedo de ser asesinado —replicó Isaac—. Pensé que alguien podría matarme para apoderarse de ella. ");
INSERT INTO spaonbv_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","―¿Cómo pudiste hacernos esto? —exclamó Abimélec—. Alguno, sin saberlo, pudo haberse acostado con ella, y todos habríamos cargado con las consecuencias de ese pecado. ");
INSERT INTO spaonbv_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Entonces Abimélec proclamó públicamente: «Cualquiera que le haga algún daño a este hombre o a su esposa, morirá». ");
INSERT INTO spaonbv_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Ese año las cosechas de Isaac fueron enormes: cosechó cien veces lo sembrado, porque el Señor lo bendijo. ");
INSERT INTO spaonbv_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Día a día Isaac fue adquiriendo bienes, hasta que llegó a ser muy rico. ");
INSERT INTO spaonbv_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Tenía grandes rebaños de ovejas y de vacas, y muchos esclavos. Por esta razón los filisteos le tenían envidia. ");
INSERT INTO spaonbv_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Así que llenaron de tierra los pozos que habían cavado los siervos de su padre Abraham. ");
INSERT INTO spaonbv_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Entonces el rey Abimélec le dijo a Isaac: ―Vete a otro lugar, porque te has enriquecido y eres más poderoso que nosotros. ");
INSERT INTO spaonbv_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","De modo que Isaac salió de allí y se fue a vivir al valle de Guerar. ");
INSERT INTO spaonbv_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Allí Isaac volvió a abrir los pozos de Abraham, los mismos que los filisteos habían tapado después de la muerte de Abraham. Isaac les puso los mismos nombres que les había dado su padre. ");
INSERT INTO spaonbv_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Un día, los pastores de Isaac abrieron un hoyo en el valle y encontraron un manantial. ");
INSERT INTO spaonbv_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Pero cuando los pastores del lugar lo vieron lo reclamaron como suyo. ―Esta es nuestra tierra, por lo tanto el pozo es nuestro —dijeron, y disputaron con los pastores de Isaac. Por eso, Isaac llamó a ese pozo Pelea, porque habían peleado por él. ");
INSERT INTO spaonbv_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Los hombres de Isaac cavaron otro pozo y nuevamente pelearon por él. A este pozo Isaac le puso el nombre de Enemistad. ");
INSERT INTO spaonbv_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Isaac se fue de allí y cavó otro pozo, pero esta vez no pelearon por él. Entonces Isaac le puso el nombre de Lugar de Libertad, pues dijo: «Ahora el Señor nos ha dado un lugar en el que podremos prosperar». ");
INSERT INTO spaonbv_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","De allí, Isaac fue a Berseba. ");
INSERT INTO spaonbv_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Esa noche, el Señor se le apareció y le dijo: «Yo soy el Dios de Abraham, tu padre. No temas, porque estoy contigo. Por amor a Abraham, mi siervo, te bendeciré y haré que tu descendencia sea muy numerosa». ");
INSERT INTO spaonbv_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Entonces Isaac construyó un altar y adoró al Señor. Allí se estableció, y sus siervos abrieron un pozo. ");
INSERT INTO spaonbv_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Un día, Abimélec vino desde Guerar para visitar a Isaac. Con él vinieron Ajuzat, su consejero, y Ficol, comandante de su ejército. ");
INSERT INTO spaonbv_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","―¿A qué han venido, si me odian y me echaron de su tierra? —les preguntó Isaac. ");
INSERT INTO spaonbv_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","―Bueno —dijeron ellos—, podemos ver claramente que el Señor te está bendiciendo. Así que hemos decidido venir a pedirte que hagamos un pacto entre nosotros. El pacto que haremos contigo, bajo juramento, es este: ");
INSERT INTO spaonbv_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Prométenos que no nos harás daño, tal como nosotros no te lo hemos causado a ti. Realmente, te hemos hecho solamente bien y te despedimos en forma pacífica. ¡Ahora tú cuentas con la bendición del Señor! ");
INSERT INTO spaonbv_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Entonces Isaac les hizo una gran fiesta, y comieron y bebieron. ");
INSERT INTO spaonbv_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Al día siguiente, se levantaron muy temprano y sellaron el pacto con un juramento. Luego Isaac los despidió en paz. ");
INSERT INTO spaonbv_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ese mismo día los siervos de Isaac vinieron y le dijeron: ―¡Encontramos agua en el pozo que estábamos abriendo! ");
INSERT INTO spaonbv_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Por eso, Isaac le puso a ese pozo el nombre de Seba (Juramento). Por esta razón, aquella ciudad, hasta el día de hoy, lleva el nombre de Berseba. ");
INSERT INTO spaonbv_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","A los cuarenta años de edad, Esaú se casó con una muchacha llamada Judit, hija de un hitita llamado Beerí. Además se casó con Basemat, hija de otro hitita llamado Elón. ");
INSERT INTO spaonbv_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Estas dos mujeres fueron un dolor de cabeza para Isaac y Rebeca. ");
INSERT INTO spaonbv_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isaac estaba muy viejo y se había quedado ciego. Un día llamó a Esaú, su hijo mayor, y le dijo: ―¡Hijo mío! ―¿Qué quieres, padre? —contestó Esaú. ");
INSERT INTO spaonbv_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","―Ya estoy viejo —dijo Isaac—, y en cualquier momento me puedo morir. ");
INSERT INTO spaonbv_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Toma el arco y las flechas y anda al campo a ver qué puedes cazar para mí. ");
INSERT INTO spaonbv_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Luego prepárame un guiso sabroso, como a mí me gusta, y me lo traes para comérmelo. Después de eso te daré mi bendición antes de morir. ");
INSERT INTO spaonbv_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Rebeca oyó la conversación que Isaac tuvo con su hijo Esaú. Así que tan pronto este salió al campo a cazar un animal para su padre, ");
INSERT INTO spaonbv_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","llamó a su hijo Jacob y le dijo: ―Acabo de escuchar que tu padre estaba hablando con tu hermano, y le decía ");
INSERT INTO spaonbv_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","que fuera a cazar algún animal para que le preparara un guiso, y que después de eso le daría su bendición. ");
INSERT INTO spaonbv_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Ahora, hijo mío, préstame atención y haz exactamente lo que yo te voy a decir: ");
INSERT INTO spaonbv_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Ve al rebaño y tráeme dos de los mejores cabritos. Con ellos le prepararé un guiso sabroso a tu padre, tal como a él le gusta. ");
INSERT INTO spaonbv_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Luego tú se lo servirás, y cuando él se lo haya comido, te dará la bendición antes de su muerte. ");
INSERT INTO spaonbv_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","―Pero, madre —dijo Jacob—, mi hermano es muy velludo, mientras que yo soy lampiño. ");
INSERT INTO spaonbv_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Si a mi padre le da por tocarme pensará que me estoy burlando de él. Entonces, en vez de bendecirme me maldecirá. ");
INSERT INTO spaonbv_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","―Que sus maldiciones caigan sobre mí, hijo mío —dijo ella—. Haz lo que te he dicho. Ve a buscar los cabritos. ");
INSERT INTO spaonbv_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Jacob siguió las instrucciones de su madre y le trajo los dos cabritos. Su madre preparó un guiso tal como le gustaba a Isaac. ");
INSERT INTO spaonbv_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Enseguida tomó la mejor ropa de su hijo Esaú, que este había dejado en la casa, y le pidió a Jacob que se la pusiera. ");
INSERT INTO spaonbv_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Luego, con la piel de los cabritos, Rebeca le cubrió a Jacob los brazos y la parte del cuello donde no tenía vellos. ");
INSERT INTO spaonbv_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Después, le entregó a Jacob el guiso y el pan que había preparado. ");
INSERT INTO spaonbv_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Jacob llevó la bandeja con la comida a la pieza donde estaba su padre. ―¡Padre! —dijo Jacob. ―Aquí estoy, hijo mío. ¿Quién eres tú? —preguntó Isaac. ");
INSERT INTO spaonbv_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","―Soy Esaú, tu hijo mayor —dijo Jacob—. Hice lo que me dijiste que hiciera. Este es el guiso que preparé con lo que he cazado. Siéntate y cómelo, para que me bendigas. ");
INSERT INTO spaonbv_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Entonces Isaac le preguntó: ―Hijo mío, ¿cómo pudiste hacerlo con tanta rapidez? ―Porque el Señor, tu Dios, me permitió encontrar el animal muy pronto —respondió Jacob. ");
INSERT INTO spaonbv_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","―Acércate —le ordenó Isaac—. Quiero palparte para estar seguro de que eres mi hijo Esaú. ");
INSERT INTO spaonbv_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Jacob se acercó a su padre, y él lo palpó. «Es la voz de Jacob —dijo Isaac para sí—, pero las manos son las de Esaú». ");
INSERT INTO spaonbv_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Así que Isaac no reconoció a Jacob, porque sus manos eran tan velludas como las de su hermano Esaú. Antes de bendecir a Jacob, ");
INSERT INTO spaonbv_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Isaac volvió a preguntarle: ―¿Eres realmente Esaú? ―Sí, por supuesto —respondió Jacob. ");
INSERT INTO spaonbv_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","―Entonces pásame el guiso de lo que cazaste. Me lo comeré y luego te bendeciré. Jacob se lo pasó, e Isaac comió; también bebió el vino que Jacob le había llevado. ");
INSERT INTO spaonbv_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","―Acércate y bésame, hijo mío —dijo Isaac. ");
INSERT INTO spaonbv_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Jacob se acercó y besó a su padre. Al oler la ropa que Jacob llevaba puesta, Isaac lo bendijo con estas palabras: «El olor de mi hijo es como el buen aroma de un campo bendecido por el Señor. ");
INSERT INTO spaonbv_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Que Dios te dé siempre abundante agua del cielo; que te dé cosechas abundantes, y mucho trigo y vino. ");
INSERT INTO spaonbv_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Que muchas naciones te sirvan; que muchos pueblos se inclinen delante de ti. Que seas el amo de todos tus parientes, y que todos ellos se inclinen delante de ti. Malditos sean los que te maldigan, y benditos los que te bendigan». ");
INSERT INTO spaonbv_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","En cuanto Isaac hubo bendecido a Jacob, y casi en el momento en que este salía de la carpa de su padre, llegó Esaú del campo con su caza. ");
INSERT INTO spaonbv_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","También la preparó en la forma que a su padre le gustaba y se la llevó. ―Padre —dijo Esaú—, aquí está lo que te he preparado con lo que he cazado. Siéntate y come, para que me des la mejor de tus bendiciones. ");
INSERT INTO spaonbv_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","―Pero, ¿quién eres tú? —preguntó Isaac. ―Pues, yo soy Esaú, tu hijo primogénito —le contestó. ");
INSERT INTO spaonbv_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isaac se estremeció fuertemente y dijo a Esaú: ―Entonces, ¿quién fue el que estuvo aquí y me trajo un guiso? Acabo de comerme el guiso que me trajo, y le di mi bendición, y nadie se la podrá quitar. ");
INSERT INTO spaonbv_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Cuando Esaú escuchó esto, comenzó a llorar con profunda amargura, y le dijo: ―Padre mío, ¡bendíceme también a mí! ");
INSERT INTO spaonbv_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Isaac le contestó: ―Tu hermano estuvo aquí, me engañó y se llevó tu bendición. ");
INSERT INTO spaonbv_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","―¡Con razón lo llamaron Jacob! —dijo Esaú con amargura—. Primero se apoderó de mi primogenitura, y ahora me ha robado tu bendición. Padre, ¿no has guardado una bendición para mí? ");
INSERT INTO spaonbv_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","―Lo he puesto por señor tuyo y le he dado por siervos a todos sus parientes —le respondió Isaac—. Le he garantizado que tendrá abundancia de grano y de vino. ¿Qué puedo darte a ti, hijo mío? ");
INSERT INTO spaonbv_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esaú insistió: ―¿No tienes ninguna bendición para mí? ¡Padre mío, bendíceme también a mí! Y se puso a llorar a gritos. ");
INSERT INTO spaonbv_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Entonces Isaac le dijo: «Vivirás lejos de las tierras fértiles y de la lluvia que cae del cielo. ");
INSERT INTO spaonbv_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Para poder vivir tendrás que usar tu espada, y servirás a tu hermano por un tiempo. Pero cuando seas más fuerte te liberarás del dominio de tu hermano». ");
INSERT INTO spaonbv_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Entonces Esaú se llenó de odio contra Jacob por lo que este le había hecho, y se dijo: «Pronto morirá mi padre, y en cuanto esto haya ocurrido, mataré a Jacob». ");
INSERT INTO spaonbv_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","A Rebeca le contaron lo que estaba planeando Esaú. Entonces mandó a llamar a Jacob, y le dijo: ―Me he enterado de que tu hermano Esaú anda con intenciones de matarte. ");
INSERT INTO spaonbv_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Por eso, hijo mío, haz lo que te voy a decir: Levántate y vete a la casa de mi hermano Labán, que vive en Jarán. ");
INSERT INTO spaonbv_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","45","Quédate allá hasta que el tiempo haya aplacado la furia de tu hermano y se haya olvidado de lo que hiciste. Entonces yo te mandaré a buscar. ¿Por qué he de perder a los dos el mismo día? ");
INSERT INTO spaonbv_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Después Rebeca le dijo a Isaac: ―Me tienen enferma y cansada estas mujeres hititas. Preferiría morirme antes de ver a Jacob casado con alguna de esas hititas que viven aquí. ");
INSERT INTO spaonbv_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Entonces Isaac llamó a Jacob, lo bendijo y le ordenó: ―No te cases con ninguna mujer de aquí de Canaán. ");
INSERT INTO spaonbv_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Debes ir inmediatamente a Padán Aram, a la casa de tu abuelo Betuel, el padre de tu madre, para que te cases con alguna de las hijas de tu tío Labán. ");
INSERT INTO spaonbv_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Que el Dios Todopoderoso te bendiga y te dé muchos hijos; que llegues a ser una nación compuesta de muchas tribus. ");
INSERT INTO spaonbv_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Que Dios te dé a ti, y también a tu descendencia, las grandes bendiciones prometidas a Abraham. Que te dé la posesión de esta tierra en que ahora somos extranjeros, porque Dios se la prometió a Abraham. ");
INSERT INTO spaonbv_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","De esta manera despidió Isaac a Jacob y lo envió a Padán Aram, donde vivía Labán, el hijo de Betuel, el arameo, y hermano de Rebeca, la madre de Jacob y Esaú. ");
INSERT INTO spaonbv_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esaú supo que su padre había bendecido a Jacob y que lo había enviado a Padán Aram, para que se casara allá. También se enteró de que Isaac, al bendecir a Jacob, le prohibió que se casara con una mujer cananea. ");
INSERT INTO spaonbv_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Y que Jacob, efectivamente, obedeció a su padre y a su madre, y se fue para Padán Aram. ");
INSERT INTO spaonbv_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Por eso, Esaú comprendió que las mujeres de Canaán no eran del agrado de Isaac, su padre. ");
INSERT INTO spaonbv_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Entonces Esaú fue a la región donde vivía Ismael, el hijo de Abraham. Allí Esaú, aunque ya tenía otras esposas, se casó con Majalat, que era hija de Ismael y hermana de Nebayot. ");
INSERT INTO spaonbv_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jacob salió de Berseba y viajó hacia Jarán. ");
INSERT INTO spaonbv_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Llegó hasta cierto lugar y se quedó allí para pasar la noche, pues ya el sol se había ocultado. Tomó una piedra y la puso como almohada, y se acostó a dormir. ");
INSERT INTO spaonbv_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Mientras dormía soñó que había una escalera desde la tierra hasta el cielo, y vio ángeles de Dios que subían y bajaban por ella. ");
INSERT INTO spaonbv_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","En el sueño también vio que el Señor estaba parado junto a él y le decía: «Yo soy el Señor, el Dios de tu abuelo Abraham y de tu padre Isaac. A ti y a tus descendientes les voy a dar esta tierra en la que estás acostado. ");
INSERT INTO spaonbv_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Tus descendientes serán tantos como el polvo de la tierra. Llenarán la tierra de este a oeste y de norte a sur. Todas las naciones de la tierra serán bendecidas por medio de ti y de tu descendencia. ");
INSERT INTO spaonbv_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Además, estaré contigo y te protegeré dondequiera que vayas, y te traeré de nuevo sano y salvo a esta tierra. ¡Jamás te abandonaré sin haberte cumplido mis promesas!». ");
INSERT INTO spaonbv_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","17","Cuando Jacob despertó de su sueño tuvo mucho miedo, y pensó: «¡Sin duda alguna el Señor está en este lugar, y yo no lo sabía! ¡Este lugar es asombroso! ¡Es nada menos que la casa de Dios y la puerta del cielo!». ");
INSERT INTO spaonbv_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Al día siguiente se levantó muy de mañana, tomó la piedra que había usado como almohada, la paró como si fuera una columna, para que sirviera de señal de lo ocurrido. Luego derramó aceite de oliva sobre ella. ");
INSERT INTO spaonbv_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","En ese lugar había una ciudad que se llamaba Luz, pero Jacob le cambió el nombre y la llamó Betel (Casa de Dios). ");
INSERT INTO spaonbv_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","22","Jacob, entonces, hizo este voto: «Si Dios me ayuda y me protege en este viaje, me da ropa y comida, y me permite regresar sano y salvo a la casa de mi padre, el Señor será mi Dios. Y esta piedra que he levantado para señal, será lugar de adoración. Además, de todo lo que me dé, le entregaré el diezmo». ");
INSERT INTO spaonbv_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Jacob continuó el viaje hasta que llegó finalmente a la tierra ubicada al este del río Jordán. ");
INSERT INTO spaonbv_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Allí en el campo vio un pozo. Junto al pozo se encontraban tres rebaños de ovejas, pues era de allí que bebían agua. El pozo estaba tapado con una piedra muy grande. ");
INSERT INTO spaonbv_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Sólo cuando se reunían todos los pastores con sus rebaños era que quitaban la piedra. Una vez que las ovejas bebían, los pastores volvían a colocar la piedra sobre la boca del pozo. ");
INSERT INTO spaonbv_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jacob se acercó a los pastores y les preguntó: ―Amigos, ¿dónde viven ustedes? ―Vivimos en Jarán —dijeron. ");
INSERT INTO spaonbv_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","―¿Conocen a un tal Labán hijo de Najor? —les volvió a preguntar. ―¡Claro que sí lo conocemos! —le contestaron. ");
INSERT INTO spaonbv_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Jacob continuó preguntando: ―¿Cómo está? ―Está bien y ha prosperado. Mira, allí viene su hija Raquel con las ovejas —le dijeron los pastores. ");
INSERT INTO spaonbv_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","―Falta mucho para que se oculte el sol, y todavía es muy temprano para que encierren sus rebaños. ¿Por qué no le dan de beber al ganado para que sigan pastando antes de llevarlos a dormir? —preguntó Jacob. ");
INSERT INTO spaonbv_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","―Porque tenemos un acuerdo de que sólo quitaremos la piedra cuando ya estén juntos todos los rebaños. Sólo hasta ese momento podremos darles de beber a las ovejas —contestaron. ");
INSERT INTO spaonbv_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Mientras conversaban, llegó Raquel con las ovejas de su padre, porque ella era la pastora. ");
INSERT INTO spaonbv_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Cuando Jacob vio a Raquel, la hija de su tío Labán, se apresuró a quitar la piedra que estaba sobre el pozo, para que bebieran las ovejas que ella pastoreaba. ");
INSERT INTO spaonbv_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Luego Jacob besó a Raquel y se echó a llorar. ");
INSERT INTO spaonbv_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Jacob le contó a Raquel que él era sobrino de Labán, ya que era hijo de Rebeca. Entonces Raquel salió corriendo a darle la noticia a su padre. ");
INSERT INTO spaonbv_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Cuando Labán supo que su sobrino Jacob estaba allí, salió corriendo a recibirlo. Al verlo, lo abrazó, lo besó y lo llevó a su casa. Entonces Jacob le contó su historia. ");
INSERT INTO spaonbv_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Por eso, Labán le dijo: «¡No hay duda de que eres de mi familia!». Cuando Jacob ya llevaba un mes viviendo en la casa de Labán, ");
INSERT INTO spaonbv_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","este le dijo: ―No hay razón para que trabajes para mí sin recibir pago por el hecho de ser parientes. ¿Cuánto quieres que te pague? ");
INSERT INTO spaonbv_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Ahora bien, Labán tenía dos hijas: Lea, la mayor, y Raquel, la menor. ");
INSERT INTO spaonbv_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea tenía hermosos ojos, pero Raquel era hermosa en todo sentido. ");
INSERT INTO spaonbv_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Jacob estaba enamorado de Raquel. Por lo tanto, le dijo a Labán: ―Trabajaré para ti siete años si me das a Raquel para que sea mi esposa. ");
INSERT INTO spaonbv_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","―¡De acuerdo! —replicó Labán—. Prefiero dártela a ti antes que a alguien que no sea de la familia. ");
INSERT INTO spaonbv_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Así fue que Jacob trabajó los siete años siguientes para quedarse con Raquel. Sin embargo, le parecieron pocos días, porque estaba muy enamorado de ella. ");
INSERT INTO spaonbv_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Finalmente, llegó el día en que Jacob podía casarse con Raquel. ―Cumplí mi parte del contrato —le dijo Jacob a Labán. Ahora dame a Raquel para que sea mi esposa. ");
INSERT INTO spaonbv_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Entonces, Labán invitó a toda la gente de ese lugar e hizo una gran fiesta. ");
INSERT INTO spaonbv_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Ya entrada la noche, Labán tomó a su hija Lea y se la llevó a Jacob. Y Jacob durmió con Lea, sin saber que era ella. ");
INSERT INTO spaonbv_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Como regalo de bodas, Labán le dio a Lea una esclava llamada Zilpá, para que la atendiera. ");
INSERT INTO spaonbv_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Al levantarse en la mañana, Jacob descubrió que era Lea con quien había dormido. Por eso, fue donde Labán y le reclamó: ―¿Qué clase de engaño es este? ¿Acaso no trabajé siete años para que me dieras a Raquel? ¿Qué es lo que pretendes al engañarme de este modo? ");
INSERT INTO spaonbv_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Labán respondió en tono conciliador: ―No es costumbre entre nosotros que la hija menor se case antes que la mayor. ");
INSERT INTO spaonbv_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Espera a que termine la semana de la fiesta de boda de Lea y te daré también a Raquel, siempre y cuando me prometas que trabajarás para mí otros siete años. ");
INSERT INTO spaonbv_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Jacob aceptó el trato. Entonces, cuando se cumplió la semana que le correspondía a Lea, Labán le dio a Jacob a Raquel por esposa. ");
INSERT INTO spaonbv_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Labán le dio también a Raquel una esclava llamada Bilhá, para que la ayudara. ");
INSERT INTO spaonbv_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Jacob durmió con Raquel y la amó más que a Lea; y se quedó trabajando los siete años adicionales. ");
INSERT INTO spaonbv_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Jacob no amaba a Lea, y cuando vio esto el Señor permitió que Lea tuviera hijos; pero a Raquel no se lo permitió. ");
INSERT INTO spaonbv_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","De modo que Lea quedó embarazada y tuvo un hijo al que llamó Rubén, porque dijo: «El Señor ha visto mi sufrimiento; ahora sí me amará mi marido». ");
INSERT INTO spaonbv_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Poco tiempo después volvió a quedar embarazada y tuvo otro hijo. A este le puso Simeón (el Señor oyó), porque dijo. «El Señor ha oído que no soy amada, y por eso me dio este otro hijo». ");
INSERT INTO spaonbv_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Nuevamente quedó embarazada y dio a luz un tercer hijo, al que llamó Leví (unido), porque dijo: «Seguramente ahora sí me amará mi marido, puesto que le he dado tres hijos». ");
INSERT INTO spaonbv_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Por cuarta vez quedó embarazada y tuvo un hijo al que llamó Judá (alabanza), porque dijo: «Ahora alabaré al Señor». Entonces dejó de tener hijos. ");
INSERT INTO spaonbv_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Cuando Raquel se dio cuenta de que no podía tener hijos, sintió envidia de su hermana, y le dijo a Jacob: ―¡Dame un hijo, o me muero! ");
INSERT INTO spaonbv_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Jacob se enojó y le respondió: ―¿Acaso soy yo Dios? Él es el que no te ha permitido tener hijos. ");
INSERT INTO spaonbv_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Entonces Raquel le dijo: ―Acuéstate con mi sierva Bilhá. Así cuando ella vaya a dar a luz, sus hijos nacerán sobre mis rodillas. De ese modo será como si yo misma los hubiera tenido, y serán mis hijos. ");
INSERT INTO spaonbv_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Entonces Raquel le entregó a Jacob a su sierva Bilhá para que tuviera hijos con ella. Y Jacob tuvo relaciones sexuales con ella, y ");
INSERT INTO spaonbv_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilhá quedó embarazada y le dio un hijo a Jacob. ");
INSERT INTO spaonbv_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Raquel lo llamó Dan (justicia), porque dijo: «Dios me hizo justicia y oyó la voz de mis ruegos, y me dio un hijo». ");
INSERT INTO spaonbv_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Después Bilhá, la sierva de Raquel, quedó nuevamente embarazada y le dio a Jacob un segundo hijo. ");
INSERT INTO spaonbv_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Raquel lo llamo Neftalí (lucha), porque dijo: «He tenido una dura lucha con mi hermana y he vencido». ");
INSERT INTO spaonbv_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Cuando Lea vio que no podía tener más hijos, tomó a su sierva Zilpá y se la entregó a Jacob para que tuviera hijos con ella. ");
INSERT INTO spaonbv_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Zilpá, entonces, le dio un hijo a Jacob. ");
INSERT INTO spaonbv_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Lea lo llamó Gad (ha vuelto mi suerte), porque dijo: «¡Me ha regresado la buena suerte!». ");
INSERT INTO spaonbv_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Después Zilpá le dio un segundo hijo a Jacob. ");
INSERT INTO spaonbv_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Lea lo llamó Aser (feliz), porque dijo: «¡Qué gozo tengo! Ahora las demás mujeres me van a felicitar». ");
INSERT INTO spaonbv_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Un día, durante la época de la cosecha del trigo, Rubén encontró algunas mandrágoras que crecían en el campo y se las llevó a Lea, su madre. Raquel le dijo a Lea: ―Por favor, regálame algunas de las mandrágoras que te trajo tu hijo. ");
INSERT INTO spaonbv_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Pero Lea, disgustada, le respondió: ―¿No crees que es suficiente con que me hayas robado a mi marido, para que ahora quieras quedarte con las mandrágoras que me ha traído mi hijo? Raquel entonces le dijo con tristeza: ―Si me das las mandrágoras, te prometo que Jacob dormirá contigo esta noche. ");
INSERT INTO spaonbv_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Aquella tarde cuando Jacob regresaba al hogar desde el campo, Lea le salió al encuentro y le dijo: ―Tienes que dormir conmigo esta noche, pues te alquilé por unas mandrágoras que encontró mi hijo. Y Jacob durmió con ella esa noche. ");
INSERT INTO spaonbv_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Dios contestó las oraciones de Lea, pues esta quedó embarazada y le dio a Jacob un quinto hijo. ");
INSERT INTO spaonbv_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Lea lo llamó Isacar (recompensa), porque dijo: «Dios me ha recompensado por haberle dado a mi sierva mi marido». ");
INSERT INTO spaonbv_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lea quedó otra vez embarazada, y le dio a Jacob un sexto hijo. ");
INSERT INTO spaonbv_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Lo llamó Zabulón (obsequios), porque dijo: «Dios me ha dado un buen regalo. Ahora mi marido se quedará conmigo, porque le he dado seis hijos». ");
INSERT INTO spaonbv_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Después dio a luz una hija, y la llamó Dina. ");
INSERT INTO spaonbv_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Entonces Dios tuvo compasión de Raquel, y le respondió sus oraciones, pues le permitió tener hijos. ");
INSERT INTO spaonbv_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","24","Así que ella quedó embarazada, y dio a luz un hijo. A este hijo, Raquel le puso por nombre José (que añada otro), porque dijo: «Dios ha quitado la humillación que había sobre mí». Luego añadió: «¡Qué bueno sería que el Señor me diera otro hijo». ");
INSERT INTO spaonbv_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Poco después de que José nació, Jacob le dijo a Labán: ");
INSERT INTO spaonbv_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","―Quiero volver a mi tierra. Permíteme llevarme a mis esposas y a mis hijos, porque yo los gané con mi trabajo. Tú sabes que te los he pagado con mis servicios. ");
INSERT INTO spaonbv_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","―No me dejes, por favor —respondió Labán—. Por adivinación me he enterado de que el Señor me ha bendecido a través de ti. ");
INSERT INTO spaonbv_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Dime qué salario quieres recibir, y yo te lo pagaré. ");
INSERT INTO spaonbv_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Jacob contestó: ―Tú sabes con cuánta fidelidad te he servido durante todos estos años, y cómo, debido a mis cuidados, han aumentado tus rebaños. ");
INSERT INTO spaonbv_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","De lo poco que tenías has pasado a tener un rebaño inmenso. El Señor te ha bendecido desde que yo llegué. Pero ya es tiempo de que yo trabaje para mi propia familia. ");
INSERT INTO spaonbv_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","32","―¿Qué salario quieres que te pague? —volvió a preguntarle Labán. Jacob respondió: ―Si aceptas lo que te voy a decir, volveré a trabajar para ti. Déjame revisar tu ganado y apartar todos los corderos manchados, rayados y negros, lo mismo que todas las cabras manchadas y rayadas. Dame eso como salario. ");
INSERT INTO spaonbv_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Entonces, si alguna vez encuentras alguna cabra u oveja blanca entre mi rebaño, sabrás que te la he robado. ");
INSERT INTO spaonbv_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","―De acuerdo —respondió Labán—. Se hará como has dicho. ");
INSERT INTO spaonbv_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","36","Ese mismo día Labán salió al campo y puso aparte todos los chivos que tenían pintas o manchas y las cabras que tenían algo de color o que tenían manchas o listas blancas, y todos los corderos negros. Labán entregó este ganado a sus hijos para que lo cuidaran. Después Labán se llevó el rebaño a unos sesenta kilómetros de distancia para alejarlos de Jacob, mientras este seguía cuidando el resto de los rebaños de Labán. ");
INSERT INTO spaonbv_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Por su parte, Jacob tomó varas verdes de álamo, de avellano y de castaño y las descortezó para dejar al descubierto las franjas blancas. ");
INSERT INTO spaonbv_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Enseguida colocó las varas en los bebederos, para que el ganado las viera cuando venían a beber, porque era allí donde se apareaban. ");
INSERT INTO spaonbv_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","40","De modo que se apareaban delante de las varas y así las hembras parían ejemplares manchados, negros o rayados. Jacob apartaba estas crías y las colocaba frente a los animales rayados y negros del ganado de Labán. ");
INSERT INTO spaonbv_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Además, cada vez que los animales más fuertes estaban en celo, Jacob colocaba las varas en los bebederos, de modo que los animales, al unirse, lo hacían mirando las ramas. ");
INSERT INTO spaonbv_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Sin embargo, cuando los animales más débiles se unían, Jacob no colocaba las ramas. De este modo los corderos más débiles eran de Labán, mientras que los fuertes eran para Jacob. ");
INSERT INTO spaonbv_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Como resultado, Jacob se enriqueció mucho, pues llegó a tener muchas ovejas, muchos esclavos, esclavas, camellos y burros. ");
INSERT INTO spaonbv_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Al tiempo, Jacob se enteró de que los hijos de Labán estaban diciendo: «Jacob se ha ido quedando con todo lo que era de nuestro padre, y por eso se ha hecho rico». ");
INSERT INTO spaonbv_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Pronto Jacob percibió un considerable cambio en la actitud de Labán hacia él. ");
INSERT INTO spaonbv_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Entonces el Señor le habló a Jacob y le dijo: «Regresa a la tierra de tus padres y de tus parientes, y yo estaré contigo». ");
INSERT INTO spaonbv_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Un día Jacob mandó a buscar a Raquel y a Lea para que fueran a verlo al campo donde estaba con sus rebaños, pues quería hablar de esto con ellas. Jacob les dijo: ");
INSERT INTO spaonbv_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","―Su padre ya no me trata como antes, ¡pero el Dios de mi padre siempre ha estado conmigo! ");
INSERT INTO spaonbv_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ustedes saben cuánto he trabajado para Labán, ");
INSERT INTO spaonbv_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","pero él ha buscado la manera de engañarme, y ha violado una y otra vez el contrato de salario que tiene conmigo. Pero Dios no ha permitido que me haga daño. ");
INSERT INTO spaonbv_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Si él decía que las ovejas manchadas serían mías, entonces todo el ganado comenzaba a salir pinto. Pero después él cambiaba y decía que serían míos los animales que nacieran rayados, y entonces todos los corderos nacían rayados. ");
INSERT INTO spaonbv_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","De esta manera Dios me ha enriquecido a expensas del padre de ustedes. ");
INSERT INTO spaonbv_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","»En el tiempo en que los animales estaban en celo tuve un sueño. En ese sueño veía que los chivos que se unían a las cabras eran manchados, rayados o moteados. ");
INSERT INTO spaonbv_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Entonces, en el sueño, el ángel de Dios me llamó por mi nombre, y yo le contesté: «Aquí estoy». ");
INSERT INTO spaonbv_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","13","Entonces él me dijo: «Levanta la vista y observa que los machos que se unen a las hembras son manchados, rayados o moteados, porque estoy al tanto de lo que Labán te ha hecho. Yo soy el Dios que conociste en Betel, el lugar donde ungiste la piedra e hiciste voto de servirme. Deja ahora este país y vete a la tierra de tu nacimiento». ");
INSERT INTO spaonbv_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Raquel y Lea contestaron: ―¡Estamos de acuerdo! Aquí no tenemos nada, pues no vamos a recibir ninguna herencia de parte de nuestro padre. ");
INSERT INTO spaonbv_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Él nos ha tratado como extranjeras. Nos vendió, y lo que recibió por nosotras ya lo gastó. ");
INSERT INTO spaonbv_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Así que las riquezas que Dios te dio a expensas de nuestro padre, son legalmente nuestras y de nuestros hijos. Sigue adelante, y haz lo que Dios te dijo. ");
INSERT INTO spaonbv_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","20","Así fue que un día, mientras Labán se encontraba ausente trasquilando las ovejas, Jacob hizo que sus esposas e hijos montaran en los camellos. Además, tomó todos los ganados, junto con todas las riquezas que había conseguido en Padán Aram, y emprendió el viaje hacia Canaán, donde vivía su padre Isaac. Esto lo hizo sin que Labán se diera cuenta. Por su parte, Raquel le robó a Labán los ídolos de la familia. Esto lo hizo mientras Labán se encontraba en otro lugar esquilando las ovejas. ");
INSERT INTO spaonbv_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","De modo que huyó con todas sus posesiones, cruzó el Éufrates y se dirigió a la tierra de Galaad. ");
INSERT INTO spaonbv_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Tan solo tres días después Laban se enteró de que Jacob se había ido. ");
INSERT INTO spaonbv_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Entonces, tomando a varios de sus familiares con él, salió en afanosa persecución, hasta que los alcanzó siete días después en el monte Galaad. ");
INSERT INTO spaonbv_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Aquella noche Dios se le apareció a Labán, el arameo, en sueños, y le dijo: «¡No te atrevas a tratar mal a Jacob!». ");
INSERT INTO spaonbv_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Labán, finalmente, encontró a Jacob cuando este estaba acampado en los montes de Galaad. Labán también acampó allí, junto con los familiares que lo acompañaban, ");
INSERT INTO spaonbv_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","y le dijo a Jacob: ―¿Por qué me hiciste esto? ¿Por qué me engañaste y te trajiste a mis hijas como si fueran prisioneras de guerra? ");
INSERT INTO spaonbv_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","¿Por qué no me diste la oportunidad de hacer una despedida con canciones, orquestas y arpa? ");
INSERT INTO spaonbv_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","¿Por qué no dejaste que besara a mis nietos para despedirme de ellos? Tu manera de actuar ha sido muy extraña. ");
INSERT INTO spaonbv_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Yo podría causarte bastante daño, pero anoche se me apareció el Dios de tu padre y me dijo: “¡No te atrevas a tratar mal a Jacob!”. ");
INSERT INTO spaonbv_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Pero, mira, si pensabas que debías partir, y tanto extrañabas el hogar de tu niñez, ¿por qué has robado mis ídolos? ");
INSERT INTO spaonbv_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jacob le respondió: ―Yo hui porque tenía miedo. Pensé: “Él me quitará a sus hijas por la fuerza”. ");
INSERT INTO spaonbv_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Pero en cuanto a tus ídolos no tengo ni idea. Si alguno de nosotros te los robó, entonces que sea castigado con la muerte. Si encuentras una sola cosa que te hayamos robado, te juro delante de todos estos hombres, que te la podrás llevar sin ningún problema. Jacob dijo esto porque no sabía que Raquel se los había robado. ");
INSERT INTO spaonbv_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Labán entró primero a la tienda de Jacob a buscar los ídolos, luego a la de Lea y de allí a las de las dos concubinas, pero no encontró nada en ellas. Finalmente entró a la tienda de Raquel. ");
INSERT INTO spaonbv_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Como recordarán, Raquel era la que se había robado los ídolos. Ella los había escondido en la silla de su camello y estaba sentada sobre ellos. Aunque Labán buscó en toda la tienda, nada encontró. ");
INSERT INTO spaonbv_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Raquel le dijo a Labán: ―Padre, perdóname que no me levante, pero estoy con la menstruación. Labán siguió buscando sus ídolos, pero no los encontró. ");
INSERT INTO spaonbv_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Entonces Jacob se enojó, y en tono fuerte le dijo a Labán: ―¿Qué mal te he hecho, para que me hayas perseguido como si yo fuera un criminal? ");
INSERT INTO spaonbv_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","¡Has registrado todas mis cosas! Dime, ¿encontraste algo que sea tuyo? Si es así, entonces, colócalo aquí para que todos los que están aquí lo vean y digan quién tiene la razón. ");
INSERT INTO spaonbv_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Veinte años te serví y todo ese tiempo cuidé tus ovejas y tus cabras para que tuvieran crías sanas, y jamás saqué un cordero de los tuyos para comérmelo. ");
INSERT INTO spaonbv_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Si alguno era atacado por los animales salvajes y moría, yo me hacía cargo de la pérdida. Me hacías pagar cada animal que se robaban, fuera mía la culpa o no. ");
INSERT INTO spaonbv_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","En el día me quemaba el sol y en la noche tiritaba de frío. ¡A veces ni siquiera podía dormir! ");
INSERT INTO spaonbv_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Sí, veinte años: catorce para pagar tus dos hijas, y seis para formar mis rebaños. ¡Y muchas veces me cambiaste el salario! ");
INSERT INTO spaonbv_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","En realidad, de no ser por la gracia del Dios de mi abuelo Abraham, el glorioso Dios de mi padre Isaac, tú me habrías despedido sin abonar un centavo a mi cuenta. Pero Dios vio tu crueldad y mi duro trabajo, y por eso es que se te apareció anoche y te reprendió. ");
INSERT INTO spaonbv_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Labán contestó: ―Estas mujeres son mis hijas, y estos niños son mis nietos. También las ovejas y todo lo que ves me pertenece. ¿Cómo crees que yo quiera ahora hacerles daño a mis hijas y a mis nietos? ");
INSERT INTO spaonbv_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Ven ahora y firmemos un pacto de paz, tú y yo. ¡Ese pacto será testigo de nuestro acuerdo! ");
INSERT INTO spaonbv_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Entonces Jacob tomó una piedra y la colocó como un pilar, para que les sirviera de prueba. ");
INSERT INTO spaonbv_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Luego les dijo a sus familiares que reunieran piedras y las amontonaran. Una vez hecho esto, comieron sobre ese montón de piedras. ");
INSERT INTO spaonbv_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","A ese montón de piedras Labán le puso el nombre de Yegar Saduta, y Jacob lo llamó Galaad. ");
INSERT INTO spaonbv_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Luego Labán dijo: ―Este montón de piedras servirá para recordarnos el trato que tú y yo hemos hecho hoy. Aquel lugar se llamó Galaad ");
INSERT INTO spaonbv_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","y Mizpa, porque Labán dijo: ―Que el Señor cuide que nosotros respetemos este trato cuando nos hayamos separado. ");
INSERT INTO spaonbv_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Y si tú tratas con rudeza a mis hijas, o si tomas otras esposas, yo no lo sabré, pero recuerda que Dios sí lo verá y será testigo de lo que hagas. ");
INSERT INTO spaonbv_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","52","Labán continuó diciéndole a Jacob: ―Mira bien, este montón de piedras y este pilar que he levantado entre tú y yo quedan como testigos de nuestros votos. Yo no cruzaré esta línea para atacarte, ni tú la cruzarás para atacarme. ");
INSERT INTO spaonbv_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","¡Que el Dios de Abraham y el Dios de Najor sea quien juzgue si cumplimos o no este trato! Entonces Jacob juró por el poderoso Dios de Isaac, su padre. ");
INSERT INTO spaonbv_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Enseguida ofreció un sacrificio a Dios allí sobre la cumbre del monte, e invitó a sus parientes a participar de la comida. Después de comer, todos se quedaron esa noche en la montaña. ");
INSERT INTO spaonbv_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Labán se levantó temprano la mañana siguiente, besó a sus hijas y a sus nietos, los bendijo, y regresó a su tierra. ");
INSERT INTO spaonbv_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Jacob y su familia reanudaron la marcha. Los ángeles de Dios le salieron al encuentro. ");
INSERT INTO spaonbv_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Cuando él los vio, exclamó: «¡Aquí está el campamento de Dios!». Por esta razón llamó aquel lugar Majanayin (dos campamentos). ");
INSERT INTO spaonbv_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Jacob envió mensajeros a su hermano Esaú en Edom, que está en la tierra de Seír. ");
INSERT INTO spaonbv_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Les pidió que le dijeran a Esaú: «Te saluda tu siervo Jacob. Hasta hace poco estuve viviendo con nuestro tío Labán. ");
INSERT INTO spaonbv_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Ahora poseo bueyes, burros, ovejas y muchos esclavos y esclavas. He enviado estos mensajeros para que te den la noticia de que regreso, con la esperanza de que tengamos un encuentro amistoso». ");
INSERT INTO spaonbv_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Los mensajeros volvieron con la noticia de que Esaú estaba en camino para encontrarse con Jacob, ¡con cuatrocientos hombres! ");
INSERT INTO spaonbv_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","El temor y la angustia se apoderaron de Jacob. Dividió la familia, los rebaños, las reses y los camellos en dos grupos; ");
INSERT INTO spaonbv_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","porque se dijo: «Si Esaú ataca un grupo, el otro podrá escapar». ");
INSERT INTO spaonbv_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Entonces Jacob oró: «Señor, Dios de mi abuelo Abraham y de mi padre Isaac, tú me dijiste que regresara a la tierra de mis padres y que estarías conmigo para que me fuera bien. ");
INSERT INTO spaonbv_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Mira, no soy digno de recibir la más pequeña de las misericordias que me has mostrado una y otra vez, conforme a tu promesa. Cuando salí de mi hogar y crucé el río Jordán, la única posesión que tenía era mi bastón; pero ahora necesito dos campamentos para guardar todo lo que tengo. ");
INSERT INTO spaonbv_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","¡Te suplico que me libres del furor de mi hermano Esaú! Tengo miedo, un miedo terrible de que él venga a matarme, y mate también a estas mujeres y a sus hijos. ");
INSERT INTO spaonbv_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Recuerda que tú prometiste que me harías bien y que multiplicarías mis descendientes hasta que llegaran a ser como la arena del mar, de modo que no podrían ser contados». ");
INSERT INTO spaonbv_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","15","Jacob pasó allí la noche y preparó un obsequio para su hermano Esaú: 200 cabras, 20 chivos, 200 ovejas, 20 carneros, 30 camellas paridas con sus crías, 40 vacas, 10 toros, 20 burras, 10 burros. ");
INSERT INTO spaonbv_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Instruyó a sus siervos para que los condujeran en grupos, y les pidió que guardaran una distancia prudente entre grupo y grupo. ");
INSERT INTO spaonbv_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Le dijo al que llevaba el primer grupo que cuando encontrara a Esaú, y este preguntara: «¿Hacia dónde van? ¿A quién sirven? ¿De quién son estos animales?», ");
INSERT INTO spaonbv_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","le respondiera: «Mi señor Esaú, este es un regalo que le envía mi amo Jacob. A propósito, él viene detrás de nosotros». ");
INSERT INTO spaonbv_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Jacob pidió a cada uno de los que envió al frente de los grupos que le dieran el mismo mensaje a Esaú. ");
INSERT INTO spaonbv_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","La estrategia de Jacob consistía en apaciguar a su hermano por medio de los presentes enviados antes de su encuentro. Jacob pensaba que quizá de esa manera Esaú dejaría de odiarlo, y cuando se encontraran lo recibiría muy bien. ");
INSERT INTO spaonbv_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Así que Jacob le envió a Esaú los regalos por adelantado, y él pasó la noche en el campamento. ");
INSERT INTO spaonbv_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","24","Pero durante la noche, Jacob se levantó y despertó a sus dos esposas, a las concubinas y a los once hijos y los hizo cruzar el Jordán por el vado de Jaboc. Enseguida regresó al campamento y se quedó solo allí. Y un varón luchó con él hasta el alba. ");
INSERT INTO spaonbv_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Cuando el varón vio que no podía ganar la lucha, hirió a Jacob en la articulación de la cadera y se la dislocó. ");
INSERT INTO spaonbv_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Entonces el varón le dijo: ―Déjame ir, porque ya amanece. Pero Jacob le contestó: ―No te soltaré si no me bendices. ");
INSERT INTO spaonbv_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","―¿Cómo te llamas? —le preguntó el varón. ―Jacob —fue la respuesta. ");
INSERT INTO spaonbv_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","―Ese ya no será tu nombre —le dijo el varón—. A partir de hoy te llamarás Israel, porque has luchado con Dios y con los hombres, y has ganado. ");
INSERT INTO spaonbv_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Jacob le preguntó: ―¿Cómo te llamas? ―¿Por qué me lo preguntas? —le dijo aquel varón. Luego bendijo a Jacob. ");
INSERT INTO spaonbv_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","A aquel lugar Jacob le puso Peniel (rostro de Dios), porque dijo: «Vi a Dios cara a cara y me dejó con vida». ");
INSERT INTO spaonbv_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Salía el sol cuando Jacob emprendió el camino, y renqueaba a causa de su cadera. ");
INSERT INTO spaonbv_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","(Esta es la razón por la que el pueblo de Israel, hasta este día, no come del tendón que está en la articulación de la cadera, porque en esa parte Jacob fue herido). ");
INSERT INTO spaonbv_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","A la distancia, Jacob vio a Esaú que llegaba con cuatrocientos hombres. Entonces repartió a sus hijos entre Lea, Raquel y las dos siervas. ");
INSERT INTO spaonbv_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Al frente de todos puso a las dos siervas junto con sus hijos, luego a Lea y sus hijos, y finalmente a Raquel y su hijo José. ");
INSERT INTO spaonbv_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Luego Jacob pasó al frente. Cuando estuvo cerca de su hermano, se inclinó siete veces delante de él. ");
INSERT INTO spaonbv_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Esaú, al verlo, corrió a su encuentro, lo abrazó afectuosamente y lo besó; y ambos se pusieron a llorar. ");
INSERT INTO spaonbv_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Entonces Esaú vio a las mujeres y a los niños, y preguntó: ―¿Quiénes son estas personas que están contigo? ―Son los hijos que Dios, por su amor, me ha dado —respondió Jacob. ");
INSERT INTO spaonbv_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Las concubinas se adelantaron con sus hijos y se inclinaron ante Esaú. ");
INSERT INTO spaonbv_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Luego Lea y sus hijos se acercaron y también se inclinaron ante Esaú. Finalmente, llegaron Raquel y José y también se inclinaron. ");
INSERT INTO spaonbv_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","―¿Y para qué era todo ese ganado que he encontrado en el camino mientras venía hacia acá? —preguntó Esaú. Jacob contestó: ―Son obsequios que te envié para ganarme tu favor. ");
INSERT INTO spaonbv_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","―Hermano mío, yo tengo bastante —dijo Esaú—. Déjalos para ti. ");
INSERT INTO spaonbv_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","―No, te ruego que los aceptes —dijo Jacob—, porque al verte me parece estar viendo a Dios mismo, pues me has recibido con mucha bondad. ");
INSERT INTO spaonbv_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Por favor, acepta mis obsequios. Dios ha sido muy misericordioso conmigo y me ha dado muchas riquezas. Tanto insistió Jacob, que al fin Esaú aceptó los regalos. ");
INSERT INTO spaonbv_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","―Bueno, ahora pongámonos en marcha —dijo Esaú—. Mis hombres y yo nos quedaremos con ustedes y les señalaremos el camino. ");
INSERT INTO spaonbv_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Pero Jacob respondió: ―Como puedes ver, algunos de mis hijos son pequeños, y además el ganado tiene crías, de modo que si avanzamos muy rápido, morirán. ");
INSERT INTO spaonbv_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Ve tú adelante. Nosotros iremos detrás de ustedes, al paso de los niños y del ganado. Nos encontraremos en Seír. ");
INSERT INTO spaonbv_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","―Bueno —dijo Esaú—, al menos permíteme que te deje algunos hombres para que te ayuden y sirvan de guía. ―No —insistió Jacob—, no es necesario. Por favor, acepta mi sugerencia. ");
INSERT INTO spaonbv_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Entonces, aquel mismo día, Esaú emprendió el regreso a Seír. ");
INSERT INTO spaonbv_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Por su parte Jacob y su familia se fueron hasta Sucot. Allí levantó un campamento con cabañas para su ganado. Por eso es que el lugar se llama Sucot (cabañas). ");
INSERT INTO spaonbv_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Luego llegaron a salvo a Siquén, en Canaán, y acamparon fuera de la ciudad. ");
INSERT INTO spaonbv_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Jacob le compró a la familia de Jamor, padre de Siquén, por cien monedas de plata, un pedazo de tierra. ");
INSERT INTO spaonbv_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Allí edificó un altar y lo llamó El Elohé Israel (Dios es el Dios de Israel). ");
INSERT INTO spaonbv_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Dina, la hija de Lea, salió un día a visitar a algunas de las muchachas del lugar. ");
INSERT INTO spaonbv_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Y la vio Siquén hijo de Jamor, el jefe de los heveos. Entonces la agarró a la fuerza y la violó. ");
INSERT INTO spaonbv_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Pero Siquén quedó profundamente enamorado de ella y trató de ganarse su cariño. ");
INSERT INTO spaonbv_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Por eso le dijo a su padre: ―Ve y pídeme a esa joven por esposa, pues quiero casarme con ella. ");
INSERT INTO spaonbv_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Cuando Jacob se enteró de que Siquén había violado a su hija Dina, sus hijos estaban en el campo pastoreando el ganado, de modo que no hizo nada hasta el regreso de ellos. ");
INSERT INTO spaonbv_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","7","Mientras tanto, Jamor, padre de Siquén, fue a hablar con Jacob. Llegó en el mismo momento en que los hijos de Jacob regresaban del campo. Al enterarse de lo sucedido se llenaron de ira, pues lo que Siquén hizo fue una ofensa muy grande para Israel. ¡Eso nunca debió haberlo hecho! ");
INSERT INTO spaonbv_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Pero Jamor les dijo: ―Mi hijo Siquén está muy enamorado de la hermana de ustedes. Por favor, permítanle casarse con ella. ");
INSERT INTO spaonbv_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","10","Aun más, los invitamos a que vivan entre nosotros y que las hijas de ustedes se casen con nuestros hijos, y nosotros daremos nuestras hijas a los jóvenes de ustedes. Podrán vivir en donde quieran en nuestra tierra, negociar en ella y enriquecerse. ");
INSERT INTO spaonbv_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Siquén también les dijo a Jacob y a los hermanos de Dina: ―Sean bondadosos conmigo y dénmela por esposa. Yo les daré cualquier cosa que pidan. ");
INSERT INTO spaonbv_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","No importa que la dote que pidan sea muy alta, yo la pagaré. Pero, ¡denme a la muchacha por esposa! ");
INSERT INTO spaonbv_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Los hermanos de Dina entonces les mintieron a Siquén y a Jamor, pues les respondieron con engaños. Hicieron esto en venganza por lo que Siquén le había hecho a Dina. ");
INSERT INTO spaonbv_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Así que les dijeron: ―A nosotros no nos está permitido entregarle nuestra hermana a un hombre que no está circuncidado. ¡Eso sería una deshonra para nosotros! ");
INSERT INTO spaonbv_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","16","Ahora bien, si ustedes aceptan que todo varón entre ustedes se circuncide, entonces podremos darles nuestras hijas para que se casen con ellas. Además, nuestros hijos podrían casarse con las hijas de ustedes. Esa es la condición que les ponemos. Entonces nos quedaremos a vivir con ustedes y formaremos un solo pueblo. ");
INSERT INTO spaonbv_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Si no es así nos iremos de aquí y nos llevaremos a nuestra hermana. ");
INSERT INTO spaonbv_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","19","Jamor y Siquén aceptaron gustosamente la propuesta. Y como Siquén estaba tan enamorado de Dina, no vaciló en circuncidarse inmediatamente. Siquén estaba seguro de que podría convencer a todos los hombres de la ciudad, pues gozaba del respeto de todos ellos. ");
INSERT INTO spaonbv_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Así que Jamor y Siquén regresaron a la ciudad y se presentaron ante el concejo de la ciudad para hacer su petición. ");
INSERT INTO spaonbv_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","―Estos hombres son amigos nuestros —dijeron—. Invitémosles a vivir entre nosotros y a que tengan sus negocios aquí, pues la tierra que tenemos es suficientemente extensa. Nosotros podremos casarnos con sus hijas, y ellos con las nuestras. ");
INSERT INTO spaonbv_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","23","Sin embargo, no aceptarán si no cumplimos una condición: que todo hombre entre nosotros sea circuncidado, al igual que ellos. Si hacemos esto, todo lo que ellos tienen será también nuestro, y la tierra se habrá enriquecido. Vamos, aprueben esto para que ellos se queden a vivir entre nosotros. ");
INSERT INTO spaonbv_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Todos los hombres estuvieron de acuerdo, de modo que se circuncidaron. ");
INSERT INTO spaonbv_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","26","Pero a los tres días de haberse circuncidado, es decir, cuando más dolor sentían, fueron sorprendidos por Simeón y Leví, hijos de Jacob y hermanos de Dina. En efecto, aprovechando esa circunstancia, Simeón y Leví agarraron sus espadas, entraron en la ciudad y mataron a todos los hombres, incluyendo a Siquén y a Jamor. Luego sacaron a Dina de la casa de Siquén, y regresaron al campamento. ");
INSERT INTO spaonbv_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Después todos los hijos de Jacob fueron y saquearon la ciudad con el pretexto de que su hermana había sido violada allí. ");
INSERT INTO spaonbv_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Se apoderaron de todo el ganado, ovejas, vacas y burros, y de todo lo que había en la ciudad y en el campo. ");
INSERT INTO spaonbv_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","También se llevaron a las mujeres, a los niños, y todo tipo de riquezas. ");
INSERT INTO spaonbv_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Entonces Jacob les dijo a Leví y a Simeón: ―Ustedes me han hecho un mal muy grande. A partir de hoy, los cananeos y los ferezeos que viven en esta región me van a odiar. Si ellos se unen y nos atacan, nos matarán a todos, pues cuento con muy pocos hombres para defenderme. ");
INSERT INTO spaonbv_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Pero ellos respondieron: ―¿Acaso tenía él derecho de tratar a nuestra hermana como si fuera una prostituta? ");
INSERT INTO spaonbv_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Dios le dijo a Jacob: «Regresa a Betel y quédate allí. Al llegar construirás un altar para adorar al Dios que se te apareció cuando huías de tu hermano Esaú». ");
INSERT INTO spaonbv_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Jacob entonces ordenó a su familia y a toda la gente que estaba con él que destruyeran los ídolos que habían traído consigo, que se purificaran ceremonialmente y que se pusieran ropa limpia. ");
INSERT INTO spaonbv_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Además les dijo: «Nos vamos a Betel. Allí voy a construir un altar al Dios que respondió a mis oraciones en el día en que estaba angustiado, y me acompañó en todo el viaje». ");
INSERT INTO spaonbv_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Entonces todos le entregaron sus ídolos y los aretes que llevaban en las orejas. Jacob agarró todo esto y lo enterró bajo la encina que estaba cerca de Siquén. ");
INSERT INTO spaonbv_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Luego emprendieron la marcha. Pasaron por varias ciudades, pero nadie se atrevió a hacerles daño, pues tenían miedo de Dios. ");
INSERT INTO spaonbv_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Finalmente llegaron a Luz (que también se llama Betel), en Canaán. ");
INSERT INTO spaonbv_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Jacob erigió allí un altar y llamó a ese lugar El Betel (Dios de Betel), porque fue en Betel donde Dios se le apareció mientras huía de Esaú. ");
INSERT INTO spaonbv_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Poco después de esto murió Débora, la anciana que había criado a Rebeca. La sepultaron bajo una encina en el valle que quedaba junto a Betel. Por esto, a ese lugar Jacob le puso el nombre de Elón Bacut (encina del llanto). ");
INSERT INTO spaonbv_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Cuando Jacob llegó a Betel desde Padán Aram, Dios se le apareció y lo bendijo nuevamente. ");
INSERT INTO spaonbv_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Le dijo Dios: «Hasta hoy te llamaste Jacob (usurpador). Pero a partir de este momento ya no te llamarás Jacob, sino Israel (el que prevalece con Dios)». Así que Dios le cambió el nombre. ");
INSERT INTO spaonbv_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Después de esto Dios le dijo: «Yo soy el Dios Todopoderoso. Vas a tener muchos hijos, y tus descendientes serán muy numerosos. Haré de ti una gran nación, y muchos pueblos saldrán de ti. Además, entre descendientes habrá muchos reyes. ");
INSERT INTO spaonbv_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","A ti te entregaré la tierra que les di a Abraham y a Isaac. Y después de ti se la daré a tu descendencia». ");
INSERT INTO spaonbv_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Luego, Dios se fue de este lugar donde había hablado con Jacob. ");
INSERT INTO spaonbv_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Entonces Jacob levantó una piedra por monumento en el lugar en que Dios le había hablado. Sobre ella derramó vino y aceite para consagrarla. ");
INSERT INTO spaonbv_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Jacob llamó a aquel lugar Betel, porque Dios le había hablado allí. ");
INSERT INTO spaonbv_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Después, Jacob y todos los que estaban con él salieron de Betel y viajaron hacia Efrata. Cuando todavía estaban bastante lejos de Efrata, Raquel dio a luz, pero con mucha dificultad. ");
INSERT INTO spaonbv_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Después de un parto muy difícil, la partera finalmente exclamó: ―¡No tengas miedo, pues has tenido otro hijo varón! ");
INSERT INTO spaonbv_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Pero Raquel murió luego de dar a luz a su hijo. Sin embargo, cuando estaba agonizando alcanzó a decir que su hijo se llamaría Benoní, es decir, «hijo de mi tristeza». Pero Jacob lo llamó Benjamín, que quiere decir «Hijo de mi mano derecha». ");
INSERT INTO spaonbv_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Muerta Raquel, fue sepultada junto al camino a Efrata (que también se llama Belén). ");
INSERT INTO spaonbv_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Jacob levantó una piedra en la tumba como señal, y allí está hasta hoy. ");
INSERT INTO spaonbv_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Entonces Israel viajó y acampó más allá de Migdal Edar (torre de Edar). ");
INSERT INTO spaonbv_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Fue allí donde Rubén tuvo relaciones sexuales con Bilhá, la concubina de Jacob, quien se enteró de lo sucedido. Estos son los nombres de los doce hijos de Jacob: ");
INSERT INTO spaonbv_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Los hijos de Lea: Rubén, que es el hijo mayor de Jacob, Simeón, Leví, Judá, Isacar y Zabulón. ");
INSERT INTO spaonbv_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Los hijos de Raquel: José y Benjamín. ");
INSERT INTO spaonbv_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Los hijos de Bilhá, la esclava de Raquel: Dan y Neftalí. ");
INSERT INTO spaonbv_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Los hijos de Zilpá, la esclava de Lea: Gad y Aser. Todos estos nacieron en Padán Aram. ");
INSERT INTO spaonbv_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Finalmente Jacob fue hasta Mamré, cerca de Quiriat Arbá, a visitar a su padre Isaac. Quiriat Arbá es la misma Hebrón. Allí habían vivido Abraham e Isaac. ");
INSERT INTO spaonbv_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","29","Isaac murió poco después a la avanzada edad de ciento ochenta años, y sus hijos Esaú y Jacob lo sepultaron. ");
INSERT INTO spaonbv_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Esta es la lista de los descendientes de Esaú (que también se llama Edom): ");
INSERT INTO spaonbv_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","3","Esaú se casó con Ada (hija de Elón el hitita), con Aholibama (hija de Aná y nieta de Zibeón el heveo), y con Basemat (hija de Ismael y hermana de Nebayot). Estas tres mujeres eran de Canaán. ");
INSERT INTO spaonbv_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Esaú y Ada tuvieron un hijo que se llamó Elifaz. Esaú y Basemat tuvieron un hijo llamado Reuel. ");
INSERT INTO spaonbv_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Los hijos de Esaú y Aholibama fueron: Jeús, Jalán y Coré. Todos ellos nacieron en la tierra de Canaán. ");
INSERT INTO spaonbv_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","8","La tierra no daba abasto para alimentar el ganado de Esaú y de Jacob. Por eso, Esaú tomó a sus esposas, sus niños, sus esclavos, todo su ganado y toda la riqueza que había obtenido en la tierra de Canaán, y se fue a vivir en la región montañosa de Seír, lejos de su hermano. ");
INSERT INTO spaonbv_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Estos son los nombres de los edomitas, es decir, los descendientes de Esaú, que vivieron en la región montañosa de Seír: ");
INSERT INTO spaonbv_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","12","Descendientes a través de Elifaz, hijo de su esposa Ada: Temán, Omar, Zefo, Gatán y Quenaz. Además, Elifaz tuvo otro hijo con su concubina Timná, al que llamó Amalec. Así que estos son los nietos de Esaú y Ada. ");
INSERT INTO spaonbv_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Esaú también tuvo descendientes a través de Reuel, hijo de Basemat: Najat, Zera, Sama y Mizá. Así que estos fueron los nietos de Esaú y Basemat. ");
INSERT INTO spaonbv_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Hay que recordar que Esaú tuvo otra esposa, la cual se llamaba Aholibama, que era hija de Aná y nieta de Zibeón. Con ella también tuvo tres hijos, que fueron: Jeús, Jalán y Coré. ");
INSERT INTO spaonbv_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","16","Los nietos de Esaú fueron jefes de los siguientes clanes: El clan de Temán, el clan de Omar, el clan de Zefo, el clan de Quenaz, el clan de Coré, el clan de Gatán, el clan de Amalec. Estos clanes estaban formados por los descendientes de Elifaz, el hijo mayor de Esaú y Ada, y vivían en la tierra de Edom. ");
INSERT INTO spaonbv_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Los siguientes clanes estaban formados por los descendientes de Reuel, hijo de Esaú y de Basemat: El clan de Najat, el clan de Zera, el clan de Sama y el clan de Mizá. ");
INSERT INTO spaonbv_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Los siguientes clanes recibieron el nombre de los hijos de Esaú y de Aholibama (hija de Aná): El clan de Jeús, el clan de Jalán y el clan de Coré. ");
INSERT INTO spaonbv_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","De modo que todos estos fueron los descendientes de Esaú, conocido también como Edom. Todos ellos fueron jefes de sus clanes. ");
INSERT INTO spaonbv_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Las siguientes son las tribus que descendieron de Seír el horeo, una de las familias nativas de la tierra de Seír: La tribu de Lotán, la tribu de Sobal, la tribu de Zibeón, la tribu de Aná, la tribu de Disón, la tribu de Ezer y la tribu de Disán. Todos estos fueron jefes de los horeos, los cuales vivían en Edom. ");
INSERT INTO spaonbv_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Los hijos de Lotán (el hijo de Seír) fueron: Horí y Homán (Lotán tuvo una hermana que se llamaba Timná). ");
INSERT INTO spaonbv_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Los hijos de Sobal fueron: Alván, Manajat, Ebal, Sefó y Onam. ");
INSERT INTO spaonbv_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Los hijos de Zibeón fueron: Ayá y Aná. (Este fue el que descubrió manantiales en el desierto mientras apacentaba los burros de su padre). ");
INSERT INTO spaonbv_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Los hijos de Aná fueron: Disón y Ahoibama, hija de Aná. ");
INSERT INTO spaonbv_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Los hijos de Disón fueron: Hemdán, Esbán, Itrán y Querán. ");
INSERT INTO spaonbv_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Los hijos de Ezer fueron: Bilán, Zaván y Acán, ");
INSERT INTO spaonbv_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Los hijos de Disán fueron: Uz y Arán. ");
INSERT INTO spaonbv_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Los jefes de las tribus de los horeos fueron Lotán, Sobal, Zibeón, Aná, Disón, Ezer y Disán. ");
INSERT INTO spaonbv_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","39","Estos son los nombres de los reyes de Edom (antes que Israel tuviera su primer rey): El rey Bela (hijo de Beor), reinó en la ciudad de Dinaba, en Edom. Fue sucedido por el rey Jobab (hijo de Zera), del pueblo de Bosra. Este fue sucedido por el rey Jusán, de la tierra de Temán. A su muerte fue sucedido por el rey Hadad (el hijo de Bedad), caudillo de las fuerzas que derrotaron al ejército de Madián, en el campo de Moab. Su capital fue Avit. Este fue sucedido por el rey Samla, del pueblo de Masreca. Su sucesor fue el rey Saúl de Rejobot, junto al Éufrates. Fue sucedido por Baal Janán hijo de Acbor. Su sucesor fue el rey Hadad, de la ciudad de Pau. La esposa del rey Hadad fue Mehitabel hija de Matred y nieta de Mezab. ");
INSERT INTO spaonbv_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Estos son los nombres de los clanes de Esaú, que vivieron en las localidades que llevan su nombre: El clan de Timná, el clan de Alvá, el clan de Jetet, el clan de Aholibama, el clan de Elá, el clan de Pinón, el clan de Quenaz, el clan de Temán, el clan de Mibzar, el clan de Magdiel y el clan de Iram. Estos son, pues, los nombres de los jefes de Edom, cada uno de los cuales dio su nombre a la región en que vivían (todos eran edomitas, descendientes de Edom, que es el mismo Esaú). ");
INSERT INTO spaonbv_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jacob se fue a vivir a la tierra de Canaán, donde su padre había vivido como extranjero. ");
INSERT INTO spaonbv_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Esta es la historia de la familia de Jacob: José, el hijo de Jacob, tenía diecisiete años. Su trabajo consistía en apacentar los rebaños de su padre, en compañía de los hijos de Bilhá y de Zilpá, que eran concubinas de Jacob. Pero José le informaba a su padre de la mala conducta de aquellos. ");
INSERT INTO spaonbv_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Israel amaba más a José que a sus otros hijos, porque José le había nacido en su vejez. Un día Jacob le regaló una túnica de mangas largas. ");
INSERT INTO spaonbv_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Los hermanos notaban que su padre prefería a José. Por eso, llegaron a odiarlo y no le podían hablar en buenos términos. ");
INSERT INTO spaonbv_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Una noche José tuvo un sueño y se lo contó de inmediato a sus hermanos, lo que hizo que estos lo odiaran aún más. ");
INSERT INTO spaonbv_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","―Oigan, les voy a contar el sueño que tuve —les dijo—. ");
INSERT INTO spaonbv_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Soñé que todos nosotros estábamos en el campo atando manojos de trigo. Mi manojo se mantuvo derecho, mientras que los de ustedes se reunieron alrededor del mío y le hicieron reverencias. ");
INSERT INTO spaonbv_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","―¿Quiere decir que vas a ser nuestro rey? —se burlaron—, y lo odiaron aún más por el sueño y porque creían que él se jactaba de ser superior a ellos. ");
INSERT INTO spaonbv_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Luego tuvo otro sueño, y también se lo contó a sus hermanos: ―Oigan mi segundo sueño —les dijo—. Soñé que el sol, la luna y once estrellas me hacían reverencias. ");
INSERT INTO spaonbv_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Esta vez José le contó el sueño también a su padre, después de habérselo contado a sus hermanos. Su padre lo reprendió: ―¿Qué es esto que has soñado? ¿Acaso yo, tu madre y tus hermanos vamos a inclinarnos delante de ti? ");
INSERT INTO spaonbv_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Los hermanos se sintieron molestos y se llenaron de envidia, pero Jacob se quedó pensando qué significaría todo aquello. ");
INSERT INTO spaonbv_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Un día los hermanos de José llevaron los rebaños de su padre a Siquén, para apacentarlos allí. ");
INSERT INTO spaonbv_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","14","Pocos días después Israel llamó a José y le dijo: ―Tus hermanos están en Siquén apacentando el ganado. Anda a ver cómo están ellos y el ganado, y vuelve a avisarme. ―Muy bien —respondió José. Entonces José salió del valle de Hebrón y se dirigió a Siquén. ");
INSERT INTO spaonbv_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Un hombre que lo vio caminando por los campos le preguntó: ―¿A quién buscas? ");
INSERT INTO spaonbv_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","―Busco a mis hermanos y sus rebaños. ¿Los ha visto? ");
INSERT INTO spaonbv_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","―Sí —respondió el hombre—, ya no están aquí. Les oí decir que iban a Dotán. José entonces se fue hasta Dotán y allí encontró a sus hermanos. ");
INSERT INTO spaonbv_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Pero cuando ellos lo vieron, lo reconocieron a la distancia y decidieron matarlo. ");
INSERT INTO spaonbv_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","20","―¡Ahí viene el soñador! —exclamaron—. Vamos, matémoslo y echémoslo en una cisterna. Luego le diremos a nuestro padre que algún animal salvaje se lo comió. ¡Veremos en qué paran sus sueños! ");
INSERT INTO spaonbv_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","22","Cuando Rubén escuchó esto, intentó salvarle la vida a José. ―No lo matemos —dijo—; no debemos derramar sangre. Echémoslo vivo dentro de la cisterna. Así morirá sin que lo toquemos. El plan de Rubén era sacarlo más tarde y enviarlo a casa de su padre. ");
INSERT INTO spaonbv_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Cuando José llegó donde ellos estaban, le quitaron su túnica de mangas largas, ");
INSERT INTO spaonbv_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","y lo arrojaron a una cisterna vacía. ");
INSERT INTO spaonbv_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Luego se sentaron a comer. De repente vieron a la distancia una caravana de Ismaelitas que venían de Galaad. Sus camellos iban cargados de perfumes, especias y bálsamos que llevaban a vender a Egipto. ");
INSERT INTO spaonbv_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","27","―¡Miren! —dijo Judá a los demás—. Allá vienen unos ismaelitas. ¡Vendámosles a José! ¿Para qué hemos de matarlo y cargar con esta culpa en la conciencia? No seamos responsables de su muerte porque, después de todo, es nuestro hermano. Todos los hermanos estuvieron de acuerdo. ");
INSERT INTO spaonbv_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Cuando llegaron los comerciantes, sacaron a José de la cisterna y se lo vendieron por veinte monedas de plata. Los comerciantes siguieron el viaje llevando consigo a José hasta Egipto. ");
INSERT INTO spaonbv_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Un poco más tarde llegó Rubén (que había estado fuera cuando pasaron los ismaelitas) y fue hasta la cisterna para sacar a José. Cuando vio que José no estaba allí, rasgó sus ropas lleno de angustia y de frustración. ");
INSERT INTO spaonbv_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","―El muchacho no está; y yo, ¿dónde me meto ahora? ");
INSERT INTO spaonbv_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Ellos entonces tomaron un cabrito, lo degollaron y con la sangre mancharon la túnica de José. ");
INSERT INTO spaonbv_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Luego le llevaron la túnica a Jacob para que la identificara. ―Encontramos esto en el campo —le dijeron—. ¿Será la túnica de José? ");
INSERT INTO spaonbv_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","El padre la reconoció de inmediato. ―Sí, es la túnica de mi hijo. Algún animal salvaje destrozó a mi hijo y se lo comió. ");
INSERT INTO spaonbv_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Entonces Israel rasgó su ropa y se vistió de ropas ásperas e hizo duelo por su hijo, y lo lloró durante varias semanas. ");
INSERT INTO spaonbv_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Toda su familia trató en vano de consolarlo. Pero él decía: «No dejaré de llorar hasta que muera y me reúna con mi hijo». Y seguía llorando. ");
INSERT INTO spaonbv_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Mientras tanto en Egipto, José fue vendido a Potifar por los mercaderes. Potifar era un funcionario del faraón, rey de Egipto. Era nada menos que el capitán de la guardia. ");
INSERT INTO spaonbv_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Más o menos por ese tiempo, Judá salió de la casa de su padre y se fue a vivir a Adulán, a casa de un hombre llamado Hirá. ");
INSERT INTO spaonbv_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Allí se casó con una mujer cananea, hija de Súa. ");
INSERT INTO spaonbv_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","La mujer quedó embarazada y tuvo un hijo, al que llamó Er. ");
INSERT INTO spaonbv_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Después volvió a quedar embarazada y tuvo otro hijo, al que llamó Onán. ");
INSERT INTO spaonbv_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Tiempo después tuvo otro hijo, al que llamó Selá. Este nació en Quezib. ");
INSERT INTO spaonbv_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Cuando creció Er, su hijo mayor, Judá lo casó con Tamar. ");
INSERT INTO spaonbv_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Pero Er era malo y Dios lo mató, ");
INSERT INTO spaonbv_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Entonces Judá le dijo a Onán, hermano de Er: ―Tienes que casarte con Tamar, conforme a lo que nuestra ley exige del hermano del muerto. Así los hijos que ella tenga serán los herederos de tu hermano. ");
INSERT INTO spaonbv_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Pero Onán no quería tener hijos que no se consideraran suyos, sino de su hermano. Por eso, aunque se casó con Tamar, cada vez que tenía relaciones sexuales con ella derramaba el semen fuera. De esa manera evitaba darle hijos a su hermano. ");
INSERT INTO spaonbv_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Esto le pareció muy malo a Dios, y lo mató también a él. ");
INSERT INTO spaonbv_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Entonces Judá le dijo a Tamar, su nuera, que no se casara por el momento y que se quedara en la casa de sus padres, hasta que Selá tuviera edad suficiente para casarse con ella. Realmente era una excusa, porque temía que su hijo menor también muriera al casarse con ella. Tamar, pues, volvió a vivir con sus padres. ");
INSERT INTO spaonbv_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Pasó el tiempo, y la esposa de Judá, que era hija de Súa, murió. Cuando terminó el tiempo del duelo, Judá y su amigo Hirá, el adulanita, fueron a Timnat a esquilar las ovejas. ");
INSERT INTO spaonbv_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Alguien le dijo a Tamar que su suegro iba a Timnat a esquilar las ovejas. ");
INSERT INTO spaonbv_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Entonces ella, comprendiendo que él no iba a dejarla casar con Selá, a pesar de que él ya tenía edad suficiente, se quitó la ropa de viuda, se cubrió con un velo para no ser reconocida, y se sentó junto al camino, a la entrada de Enayin, que está en el camino a Timnat. ");
INSERT INTO spaonbv_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Judá la vio al pasar y creyó que era una prostituta, ya que tenía el rostro cubierto con un velo. ");
INSERT INTO spaonbv_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Él se detuvo y le propuso que lo dejara acostarse con ella, sin darse cuenta de que era su nuera. ―¿Cuánto me pagarás? —preguntó ella. ");
INSERT INTO spaonbv_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","―Te enviaré un cabrito de mi rebaño —prometió él. ―¿Qué prendas me darás para que tenga la seguridad de que me lo vas a mandar? —preguntó ella. ");
INSERT INTO spaonbv_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","―Bien, ¿qué es lo que quieres? —preguntó Judá. ―Dame el sello que usas para identificarte, tu cordón y tu bastón —respondió ella. Él le entregó las prendas, y tuvieron relaciones sexuales. Ella quedó embarazada ");
INSERT INTO spaonbv_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","y volvió a ponerse su ropa de viuda. ");
INSERT INTO spaonbv_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Judá le pidió a su amigo Hirá, el adulanita, que le llevara el cabrito a la mujer y le pidiera que le devolviera las prendas que le había dado. Pero Hirá no pudo encontrarla; ");
INSERT INTO spaonbv_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","así que les preguntó a los hombres de la ciudad: ―¿Dónde vive la prostituta que estaba junto al camino, a la entrada del pueblo? ―Aquí nunca ha habido una prostituta —le contestaron. ");
INSERT INTO spaonbv_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Entonces Hirá volvió a donde estaba Judá y le dijo que no la había podido encontrar. También le contó lo que le habían dicho los hombres del pueblo. ");
INSERT INTO spaonbv_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","―¡Que se quede con las prendas! —exclamó Judá—. Hemos hecho lo que teníamos que hacer. Yo cumplí con enviarle el cabrito, pero tú no la encontraste. Seríamos el hazmerreír del pueblo si volvemos a ir. ");
INSERT INTO spaonbv_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Tres meses más tarde, le contaron a Judá que Tamar, su nuera, se había acostado con otro hombre, y que estaba embarazada. ―¡Sáquenla y quémenla! —ordenó Judá. ");
INSERT INTO spaonbv_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Pero, cuando la sacaban para quemarla, ella le envió el siguiente mensaje a su suegro: «El dueño de este sello de identificación, de este cordón y de este bastón es el padre de mi hijo. ¿Los reconoces?». ");
INSERT INTO spaonbv_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Judá reconoció que eran suyos y dijo: ―Ella es más justa que yo, porque yo no quise cumplir mi promesa de darle a mi hijo Selá por esposo. Por su parte, Judá nunca más volvió a tener relaciones sexuales con ella. ");
INSERT INTO spaonbv_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Llegado el tiempo del parto, Tamar tuvo mellizos. ");
INSERT INTO spaonbv_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","En el momento de nacer, la partera le ató un hilo rojo en la muñeca del que apareció primero. ");
INSERT INTO spaonbv_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Pero este metió la mano, y nació primero el otro. Entonces la partera exclamó: «¡Qué brecha te abriste!». Por eso le pusieron Fares, (el que salió). ");
INSERT INTO spaonbv_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Poco después nació el bebé que tenía el hilo rojo en la muñeca, y lo llamaron Zera. ");
INSERT INTO spaonbv_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Cuando José llegó a Egipto, fue vendido por los ismaelitas a Potifar, que era un egipcio muy importante, ya que era el capitán de la guardia personal del faraón. ");
INSERT INTO spaonbv_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","El Señor bendijo mucho a José en la casa de su amo, de modo que tenía éxito en todo lo que emprendía. ");
INSERT INTO spaonbv_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Potifar comprendió que el Señor estaba con José de una manera muy especial. ");
INSERT INTO spaonbv_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Por supuesto, José llegó a ser su persona de confianza. Pronto estuvo a cargo de la administración de la hacienda y todos los negocios de Potifar. ");
INSERT INTO spaonbv_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Inmediatamente, Dios comenzó a bendecir a Potifar, por amor a José. Todos los asuntos de su hacienda comenzaron a prosperar, sus cosechas aumentaron y se multiplicó su ganado. ");
INSERT INTO spaonbv_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Por esa razón, Potifar le entregó a José la responsabilidad de administrar todas sus posesiones. Potifar no tenía nada de qué preocuparse, sino de comer. Además de las cualidades mencionadas, José era un joven bien parecido. ");
INSERT INTO spaonbv_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Un día la mujer de Potifar comenzó a fijarse en José, se enamoró de él y lo invitó a tener relaciones sexuales con ella. ");
INSERT INTO spaonbv_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Pero José se rehusó a hacerlo, y le dijo: ―Señora, mi amo confía en mí en todo lo relacionado con su hacienda; ");
INSERT INTO spaonbv_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","él me ha dado toda su autoridad. No me ha prohibido ninguna cosa. Solamente sobre usted yo no tengo ningún derecho, pues usted es su esposa. ¿Cómo podría yo hacerle una maldad tan grande como esta? Sería un pecado muy grande contra Dios. ");
INSERT INTO spaonbv_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Pero ella continuó con sus insinuaciones día tras día, a pesar de que él se negaba y evitaba en todo lo posible encontrarse con ella a solas. ");
INSERT INTO spaonbv_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Un día, mientras José estaba haciendo sus quehaceres en la casa, ella aprovechó que no había nadie más en la casa, ");
INSERT INTO spaonbv_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","lo agarró de la túnica y le ordenó: ―¡Acuéstate conmigo! Él salió corriendo, pero ella logró echarle mano del manto y se lo quitó. ");
INSERT INTO spaonbv_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Cuando ella vio el manto de José en sus manos, y que él había huido, ");
INSERT INTO spaonbv_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","15","comenzó a gritar. Cuando los otros hombres que estaban cerca llegaron corriendo para ver lo que ocurría, ella comenzó a gritar histéricamente. ―¡Mi marido tenía que traer a ese esclavo hebreo para que nos insultara! —dijo llorando—. Trató de violarme, pero cuando grité, huyó y olvidó llevarse el manto. ");
INSERT INTO spaonbv_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Ella guardó el manto, y cuando Potifar regresó a casa esa noche, ");
INSERT INTO spaonbv_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","le dijo: ―¡El esclavo hebreo que tienes aquí quiso violarme, ");
INSERT INTO spaonbv_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","y solamente mis gritos me salvaron! ¡Al salir corriendo se le quedó su manto! ");
INSERT INTO spaonbv_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Cuando Potifar oyó esto, se enfureció. ");
INSERT INTO spaonbv_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Tomó preso a José y lo echó en la cárcel donde tenían encadenados a los prisioneros del rey. ");
INSERT INTO spaonbv_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Pero el Señor estuvo con José también allí y le mostró su amor, permitiendo que se ganara la confianza del carcelero. ");
INSERT INTO spaonbv_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","El hecho es que el carcelero pronto le entregó el cuidado de los prisioneros y lo dejó a cargo de todo lo demás que se hacía en la cárcel. ");
INSERT INTO spaonbv_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Por eso, el carcelero ya no se preocupaba de nada, porque José tenía cuidado de cada cosa y el Señor hacía que todas las cosas le salieran bien. ");
INSERT INTO spaonbv_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Mucho tiempo después, el jefe de los panaderos y el jefe de los coperos que servían al rey de Egipto, hicieron algo que lo ofendió. ");
INSERT INTO spaonbv_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","3","Por eso, el faraón se enojó con ellos y los mandó a la misma cárcel en donde estaba José, es decir, en la casa del capitán de la guardia. ");
INSERT INTO spaonbv_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Estuvieron presos un buen tiempo, y el capitán de la guardia designó a José para que los atendiera. ");
INSERT INTO spaonbv_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Cierta noche cada uno de ellos tuvo un sueño. ");
INSERT INTO spaonbv_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","A la mañana siguiente José los notó tristes y deprimidos. ");
INSERT INTO spaonbv_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","―¿Qué les pasa? ¿Por qué están tan tristes? —les preguntó. ");
INSERT INTO spaonbv_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ellos le contestaron: ―Cada uno de nosotros tuvo un sueño anoche, y no hay quién nos interprete los sueños. ");
INSERT INTO spaonbv_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","10","El primero en contar su sueño fue el jefe de los coperos: ―En mi sueño vi una vid con tres ramas que brotaron, florecieron y luego dieron racimos de uva madura. ");
INSERT INTO spaonbv_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Yo tenía la copa del faraón, Entonces tomé las uvas y las exprimí en la copa del faraón y se la serví. ");
INSERT INTO spaonbv_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","José entonces le dijo: ―Esta es la interpretación del sueño: Las tres ramas son tres días. ");
INSERT INTO spaonbv_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Dentro de tres días el faraón te va a sacar de la cárcel y te pondrá nuevamente en tu cargo de copero. ");
INSERT INTO spaonbv_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Por favor, apiádate de mí cuando hayas vuelto a gozar del favor del faraón, y pídele que me saque de aquí. ");
INSERT INTO spaonbv_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Yo soy un hebreo que fue raptado de su tierra, y ahora estoy en la cárcel sin haber hecho nada para merecer este castigo. ");
INSERT INTO spaonbv_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Cuando el jefe de los panaderos vio que el primer sueño tenía un significado tan bueno, también le contó su sueño a José. ―En mi sueño llevaba tres canastos de pan sobre la cabeza. ");
INSERT INTO spaonbv_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","El canasto de encima estaba lleno de deliciosos productos de pastelería, hechos especialmente para el faraón. Pero vinieron las aves y se los comieron. ");
INSERT INTO spaonbv_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","―Los tres canastos son tres días —le dijo José—. ");
INSERT INTO spaonbv_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","De aquí a tres días, el faraón te quitará la cabeza, colgará tu cuerpo de un madero, y las aves comerán tus carnes. ");
INSERT INTO spaonbv_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Tres días más tarde, el faraón hizo una fiesta para celebrar su cumpleaños. Invitó a todos sus funcionarios y a todo el personal de su palacio. Mandó a buscar al jefe de los coperos y al jefe de los panaderos. Así que los sacaron de la cárcel y los llevaron delante del faraón. ");
INSERT INTO spaonbv_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Entonces el faraón colocó de nuevo al jefe de los coperos en su cargo, ");
INSERT INTO spaonbv_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","pero mandó a ahorcar al jefe de los panaderos, tal como lo había dicho José. ");
INSERT INTO spaonbv_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Sin embargo, el jefe de los coperos se olvidó por completo de José. ");
INSERT INTO spaonbv_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Una noche, dos años más tarde, el faraón soñó que estaba a la orilla del Nilo. ");
INSERT INTO spaonbv_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Repentinamente vio siete vacas hermosas y gordas que salían del río y se ponían a pastar. ");
INSERT INTO spaonbv_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Luego salieron siete vacas flacas; eran tan flacas que se les veían todas las costillas. ");
INSERT INTO spaonbv_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Salieron del río, se pusieron junto a las vacas gordas y se las comieron. En ese preciso momento, el faraón despertó. ");
INSERT INTO spaonbv_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Cuando volvió a dormirse tuvo un segundo sueño. Esta vez vio siete espigas de trigo que crecían de una misma caña. Eran gruesas y estaban llenas de grano, ");
INSERT INTO spaonbv_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","De repente, de la caña salieron otras siete espigas, pero estas eran delgadas y estaban vacías y las marchitaba el viento que venía del desierto. ");
INSERT INTO spaonbv_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Y estas siete espigas delgadas devoraron a las siete espigas gruesas y llenas. Cuando el faraón despertó nuevamente se dio cuenta de que todo había sido un sueño. ");
INSERT INTO spaonbv_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Al día siguiente, al acordarse de los sueños se sintió bastante preocupado por lo que pudieran significar. Así que llamó a todos los magos y sabios de Egipto, y les contó los sueños. Pero ninguno pudo ni siquiera dar una idea de lo que significaban. ");
INSERT INTO spaonbv_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Entonces el jefe de los coperos le dijo al faraón: ―Hoy recuerdo mi falta. ");
INSERT INTO spaonbv_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Hace algún tiempo usted se enojó con el jefe de los panaderos y conmigo, y nos mandó a la cárcel que dirigía el capitán de la guardia. ");
INSERT INTO spaonbv_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Allí el jefe de los panaderos y yo tuvimos un sueño una noche, y cada sueño tenía su propio significado. ");
INSERT INTO spaonbv_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Le contamos los sueños a un joven hebreo, que era esclavo del capitán de la guardia, y él nos los interpretó. ");
INSERT INTO spaonbv_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Todo ocurrió tal como él lo dijo: yo fui restaurado en mi puesto de jefe de los coperos del rey, y el jefe de los panaderos fue ahorcado. ");
INSERT INTO spaonbv_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","El faraón mandó inmediatamente a buscar a José. Lo hicieron salir corriendo del calabozo, lo afeitaron rápidamente, le cambiaron la ropa y lo hicieron entrar a la presencia del faraón. ");
INSERT INTO spaonbv_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","―Anoche tuve un sueño —le dijo el faraón—, y ninguno de estos hombres puede interpretármelo. He oído decir que puedes interpretar sueños, y por esa razón te he hecho venir. ");
INSERT INTO spaonbv_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","―Yo no lo puedo hacer por mi propia cuenta —replicó José— pero Dios le dirá lo que significa. ");
INSERT INTO spaonbv_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Entonces el faraón le contó el sueño: ―Yo estaba parado a orillas del Nilo —dijo—, ");
INSERT INTO spaonbv_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","cuando repentinamente salieron del río siete vacas gordas y hermosas y se pusieron a pastar a lo largo de la ribera. ");
INSERT INTO spaonbv_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Pero entonces salieron del río otras siete vacas muy flacas y huesudas. Jamás había visto vacas tan flacas en todo Egipto. ");
INSERT INTO spaonbv_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Y las vacas flacas se comieron a las siete gordas que habían venido primero, ");
INSERT INTO spaonbv_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","y después quedaron más flacas que antes. Entonces desperté. ");
INSERT INTO spaonbv_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Poco después tuve otro sueño. Esta vez vi que salían siete espigas de trigo de una caña. Las siete espigas eran gruesas y estaban llenas de grano. ");
INSERT INTO spaonbv_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Entonces, del mismo tallo, salieron siete espigas delgadas y marchitas. ");
INSERT INTO spaonbv_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Y las espigas delgadas devoraron a las gruesas. Les conté todo esto a mis magos, pero ninguno de ellos pudo darme su interpretación. ");
INSERT INTO spaonbv_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Entonces José le dijo al faraón: ―Ambos son un solo sueño. Dios le ha dicho lo que hará en la tierra de Egipto. ");
INSERT INTO spaonbv_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Las siete vacas gordas y también las siete espigas gruesas y llenas significan que vendrán siete años de prosperidad. ");
INSERT INTO spaonbv_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Las siete vacas flacas y también las siete espigas marchitas indican que habrá siete años de hambre a continuación de los siete años de prosperidad. ");
INSERT INTO spaonbv_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","»Así que yo le digo que Dios le ha mostrado a usted lo que hará: ");
INSERT INTO spaonbv_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","En los próximos siete años habrá mucha prosperidad en toda la tierra de Egipto. ");
INSERT INTO spaonbv_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Sin embargo, a continuación habrá siete años de hambre, tan grande, que se olvidará la gran prosperidad, y habrá sólo hambre en la tierra. ");
INSERT INTO spaonbv_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","El hambre será tan terrible que se borrará el recuerdo de los años de abundancia. ");
INSERT INTO spaonbv_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","El haber tenido dos veces el sueño indica que con toda seguridad esto ocurrirá, porque Dios lo ha determinado, y así va a ocurrir pronto. ");
INSERT INTO spaonbv_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Tengo, pues, una sugerencia que hacerle: Busque al hombre más sabio de Egipto y póngalo a cargo de la administración de la agricultura y de la economía de la nación. ");
INSERT INTO spaonbv_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","35","Su Majestad, divida a Egipto en cinco distritos administrativos, y haga que los oficiales de estos distritos reúnan en los graneros reales todo el excedente de los próximos siete años, ");
INSERT INTO spaonbv_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","para que haya suficiente alimento durante los siete años de escasez, y así se evitará el desastre. ");
INSERT INTO spaonbv_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Las sugerencias de José fueron bien recibidas por el faraón y sus ministros. ");
INSERT INTO spaonbv_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Mientras discutían quién sería designado para la delicada tarea, el faraón dijo: ―¿Quién podría hacerlo mejor que José? Obviamente él es un hombre lleno del espíritu de Dios. ");
INSERT INTO spaonbv_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Luego, volviéndose hacia José, el faraón le dijo: ―Puesto que Dios te ha revelado el significado del sueño, eres el hombre más sabio de Egipto. ");
INSERT INTO spaonbv_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Por lo tanto, te nombro encargado de todo este proyecto. Lo que tú digas será ley en toda la tierra de Egipto. Solamente yo seré superior a ti, por cuanto soy el rey del país. ");
INSERT INTO spaonbv_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","42","Entonces el faraón colocó en el dedo de José el anillo con el sello real, como señal de su autoridad, lo vistió con ropas muy finas y le puso la cadena real de oro en el cuello, y proclamó: ―¡Mira que hoy te pongo a cargo de toda la tierra de Egipto! ");
INSERT INTO spaonbv_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Además el faraón le dio a José la segunda carroza real, y por dondequiera que iba pregonaban delante de él: ―¡Doblen las rodillas! ");
INSERT INTO spaonbv_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","El faraón entonces le dijo a José: ―Yo, el faraón de Egipto, declaro que tendrás completa autoridad sobre toda la tierra de Egipto, de modo que nadie podrá hacer algo sin tu permiso. ");
INSERT INTO spaonbv_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","El faraón le cambió el nombre a José por el de Zafenat Panea. Además, le dio por esposa a Asenat, hija de Potifera, sacerdote de Heliópolis. Fue así como José quedó a cargo de Egipto. ");
INSERT INTO spaonbv_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Tenía treinta años cuando entró al servicio del faraón. José salió de la presencia del faraón, y comenzó a recorrer todo Egipto. ");
INSERT INTO spaonbv_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Tal como lo había predicho José, llegaron los siete años de abundancia. Durante esos años la tierra produjo cosechas abundantes. ");
INSERT INTO spaonbv_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Durante aquellos años José compró para el gobierno una porción de todas las cosechas obtenidas a través de Egipto y la almacenó en las ciudades cercanas. ");
INSERT INTO spaonbv_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","De este modo José logró amontonar tanto trigo, que nadie podía calcular la cantidad que había, pues era como la arena del mar. ");
INSERT INTO spaonbv_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","En este tiempo, antes que llegara el tiempo de escasez, su esposa Asenat, hija de Potifera, sacerdote de Heliópolis, le dio dos hijos. ");
INSERT INTO spaonbv_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","A su hijo mayor José lo llamó Manasés (me hizo olvidar), porque dijo: «Dios hizo que me olvidara de mi angustia y a la familia de mi padre». ");
INSERT INTO spaonbv_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","El segundo hijo se llamó Efraín (fructífero), porque dijo: «Dios me hizo fructificar en la tierra de mi esclavitud». ");
INSERT INTO spaonbv_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Finalmente, los siete años de abundancia pasaron ");
INSERT INTO spaonbv_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","y, como José había predicho, comenzaron los siete años de escasez. El hambre afectó a todos los países, menos a Egipto, pues allí había abundancia de comida. ");
INSERT INTO spaonbv_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","La gente de Egipto comenzó a sentir el hambre, pues la tierra dejó de producir. Entonces iban donde el faraón a rogarle que les diera alimentos. El faraón los enviaba a José: ―Hagan todo lo que él diga —les decía. ");
INSERT INTO spaonbv_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Cuando la escasez fue grande, y el hambre se extendió por la tierra, José abrió los graneros para venderles alimento a los egipcios. ");
INSERT INTO spaonbv_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Además, como el hambre se extendió por toda la tierra, de otros países venía gente a Egipto, para comprar alimentos a José. ");
INSERT INTO spaonbv_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Cuando Jacob oyó que en Egipto había trigo, dijo a sus hijos: ―¿Por qué se quedan ahí parados mirándose? ");
INSERT INTO spaonbv_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","He sabido que en Egipto hay trigo. Vayan y compren alimento antes que nos muramos de hambre. ");
INSERT INTO spaonbv_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Entonces los diez hermanos mayores de José fueron a Egipto para comprar trigo. ");
INSERT INTO spaonbv_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Pero Jacob no dejó que fuera Benjamín, el hermano menor de José, porque temía que algo malo le pudiera ocurrir, como había sucedido con José antes. ");
INSERT INTO spaonbv_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","De modo que los hijos de Israel fueron a Egipto, junto con mucha gente de otros pueblos, porque el hambre en Canaán era muy grande. ");
INSERT INTO spaonbv_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Y como José era el gobernador de todo Egipto y estaba a cargo de la venta del trigo, sus hermanos llegaron y, en señal de respeto, se inclinaron delante de él, hasta tocar el suelo con la frente. ");
INSERT INTO spaonbv_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","José los reconoció instantáneamente, pero hizo como que no los conocía. ―¿De dónde son ustedes? —les preguntó ásperamente. ―Somos de Canaán —respondieron—. Hemos venido a comprar trigo. ");
INSERT INTO spaonbv_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","9","José recordó los sueños que había tenido cuando todavía vivía con ellos, y les dijo: ―¡Ustedes son espías! ¡Han venido a ver si nuestra tierra se ha debilitado con la escasez! ");
INSERT INTO spaonbv_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","―¡No, no! —exclamaron—. Sólo hemos venido a comprar alimentos. ");
INSERT INTO spaonbv_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Somos hijos del mismo padre, somos personas honradas, señor. ¡No somos espías! ");
INSERT INTO spaonbv_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","―¡Sí, lo son! —insistió—. Han venido a ver si estamos débiles e indefensos. ");
INSERT INTO spaonbv_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","―Señor —dijeron—, somos doce hermanos y nuestro padre se quedó en Canaán. Nuestro hermano menor se quedó con nuestro padre, y el otro murió. ");
INSERT INTO spaonbv_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","―¿Sí? —preguntó José—, ¿y eso, prueba algo? Ya lo he dicho: Son espías. ");
INSERT INTO spaonbv_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","De esta manera sabré si la historia que me cuentan es verídica: Juro por la vida del faraón que no saldrán de Egipto hasta que su hermano menor haya venido a mi presencia. ");
INSERT INTO spaonbv_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Uno de ustedes tiene que ir y traer a su hermano menor. Los demás se quedarán aquí encarcelados. De esta manera sabré si dicen la verdad. Si ocurre que no tienen un hermano menor, sabré con certeza que son espías. ");
INSERT INTO spaonbv_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Entonces los echó a la cárcel por tres días. ");
INSERT INTO spaonbv_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Al tercer día les dijo: ―Yo soy hombre temeroso de Dios. Por eso les voy a dar una oportunidad de probar lo que afirman. ");
INSERT INTO spaonbv_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Si ustedes en verdad son honrados, entonces uno de ustedes se quedará encadenado en la cárcel y los demás podrán volver con el trigo para su familia. ");
INSERT INTO spaonbv_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Pero tendrán que regresar trayendo a su hermano menor. De esta manera sabré si me están diciendo la verdad. Si han dicho la verdad, los dejaré libres. Y ellos estuvieron de acuerdo con esta proposición. ");
INSERT INTO spaonbv_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Luego se pusieron a conversar entre ellos y decían: ―Esto nos ha ocurrido como consecuencia de lo que le hicimos a José en nuestra juventud. Vimos el terror y la angustia suya y oímos sus ruegos, pero no le hicimos caso. ");
INSERT INTO spaonbv_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","―Yo les dije que no lo hicieran —dijo Rubén—, pero no me quisieron hacer caso. Ahora tendremos que pagar por lo que hicimos. ");
INSERT INTO spaonbv_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Desde luego, ellos no sabían que José les entendía, ya que les había hablado por medio de un intérprete. ");
INSERT INTO spaonbv_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","José entonces salió de la sala y buscó un lugar para llorar. Cuando volvió, escogió a Simeón y lo hizo atar delante de ellos. ");
INSERT INTO spaonbv_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","José, entonces, ordenó a sus esclavos que llenaran los costales de los hombres. Pero también ordenó que dentro de los costales colocaran el dinero que sus hermanos habían pagado por el trigo. Además les dio comida para el camino. ");
INSERT INTO spaonbv_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Ellos cargaron el trigo en los burros y emprendieron el viaje de regreso. ");
INSERT INTO spaonbv_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Cuando se detuvieron para pasar la noche, uno de ellos abrió su costal para sacar grano, para dar de comer a sus animales y, ¡encontró el dinero dentro del costal! ");
INSERT INTO spaonbv_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","―¡Miren! —le dijo a sus hermanos—, ¡el dinero que yo pagué está en mi costal! Quedaron todos llenos de terror. Temblando se decían unos a otros: ―¿Qué es lo que Dios nos ha hecho? ");
INSERT INTO spaonbv_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","En ese estado llegaron a Canaán y le contaron a su padre Jacob todo lo que les había ocurrido. ");
INSERT INTO spaonbv_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","―El hombre que gobierna ese país nos habló en forma muy severa —le dijeron—, y nos tomó por espías. ");
INSERT INTO spaonbv_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","―“No, no” —le dijimos—, “somos hombres honrados; no somos espías. ");
INSERT INTO spaonbv_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Somos doce hermanos, hijos de un mismo padre; uno murió, y el menor quedó con nuestro padre en la tierra de Canaán”. ");
INSERT INTO spaonbv_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Entonces nos dijo: ―De esta manera sabré que son lo que dicen ser. Dejen uno de sus hermanos aquí conmigo y lleven el trigo para su familia y regresen a su tierra. ");
INSERT INTO spaonbv_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Pero tienen que traer a su hermano menor cuando vuelvan. Entonces sabré si son espías u hombres de bien; si demuestran ser lo que han dicho que son, yo les devolveré a su hermano y podrán volver cuantas veces quieran a comprar trigo. ");
INSERT INTO spaonbv_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","A medida que vaciaban los costales, iban descubriendo que dentro de cada uno estaba el dinero que habían pagado por el trigo. El terror se apoderó de todos ellos y también de su padre. ");
INSERT INTO spaonbv_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Entonces Jacob exclamó: ―¡Ustedes me han privado de mis hijos! Perdí a José, luego a Simeón, y ahora quieren llevarse a Benjamín. Todo se ha confabulado en mi contra. ");
INSERT INTO spaonbv_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Entonces Rubén le dijo a su padre: ―Mata a mis dos hijos si no te devuelvo a Benjamín. Yo respondo por su regreso. ");
INSERT INTO spaonbv_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Pero Jacob replicó: ―Mi hijo no irá con ustedes, porque José su hermano murió y sólo él me ha quedado de los hijos de su madre. Si algo llegara a sucederle, yo me moriría. ");
INSERT INTO spaonbv_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Pero el hambre se hacía insoportable sobre la tierra. ");
INSERT INTO spaonbv_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Cuando estaba por acabárseles el trigo que habían comprado en Egipto, Jacob les dijo a sus hijos: ―Vayan nuevamente y compren más alimento. ");
INSERT INTO spaonbv_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","5","Pero Judá le dijo: ―Aquel hombre no estaba bromeando cuando dijo: “No regresen, a menos que su hermano venga con ustedes”. Así que no podemos ir, a menos que dejes que Benjamín vaya con nosotros. ");
INSERT INTO spaonbv_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","―¿Por qué tuvieron que decirle que tenían otro hermano? —se quejó Israel—. ¿Por qué tenían que hacerme esto? ");
INSERT INTO spaonbv_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","―Porque aquel hombre nos preguntó específicamente por nuestra familia —respondieron—. Quería saber si nuestro padre todavía vivía y nos preguntó si teníamos otro hermano. Por eso se lo dijimos. ¿Cómo íbamos a saber nosotros que nos iba a decir: “Traigan a su hermano”? ");
INSERT INTO spaonbv_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Judá le dijo a su padre: ―Envía al muchacho bajo mi cuidado, y podremos ponernos en camino. De otro modo nos moriremos todos de hambre, y no sólo nosotros, sino todos nuestros hijos. ");
INSERT INTO spaonbv_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Yo garantizo su seguridad. Si no te lo traigo al regresar, yo llevaré para siempre la culpa delante de ti. ");
INSERT INTO spaonbv_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Si lo hubieras dejado ir, ya habríamos ido y vuelto en todo este tiempo. ");
INSERT INTO spaonbv_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Entonces Israel, su padre, finalmente les dijo: ―Si no se puede evitar, entonces por lo menos hagan esto: Carguen los burros con los mejores productos de la tierra: bálsamo, miel, especias, mirra, nueces y almendras, y llévenle todo eso a aquel hombre. ");
INSERT INTO spaonbv_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Lleven también doble cantidad de dinero para que puedan devolverle el que encontraron dentro de los costales, ya que alguien, por error lo puso allí. ");
INSERT INTO spaonbv_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Tomen a Benjamín y vayan, ");
INSERT INTO spaonbv_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","¡Quiera el Dios Todopoderoso que aquel hombre les tenga misericordia, para que le dé la libertad a Simeón y deje volver a Benjamín! Y si debo sufrir el dolor de la muerte de ellos, que así sea. ");
INSERT INTO spaonbv_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Entonces tomaron los regalos y doble cantidad de dinero, y salieron rumbo a Egipto y se presentaron delante de José. ");
INSERT INTO spaonbv_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Cuando José vio que Benjamín llegaba con ellos, le dijo al mayordomo de su casa: ―Estos hombres comerán conmigo al mediodía. Llévalos a mi casa y prepara una gran fiesta. ");
INSERT INTO spaonbv_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","El hombre hizo lo que se le mandó y llevó a los hijos de Israel al palacio de José. ");
INSERT INTO spaonbv_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ellos se asustaron mucho cuando vieron hacia dónde los llevaban. ―Es por causa del dinero que encontramos en nuestros costales —se decían—. Aquel hombre quiere acusarnos de que le hemos robado, para apoderarse de nosotros y de nuestros animales, y nos hará sus esclavos. ");
INSERT INTO spaonbv_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Cuando llegaron a la entrada del palacio, le hablaron al mayordomo de la casa de José y le dijeron: ");
INSERT INTO spaonbv_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","―Señor, después de nuestro primer viaje a Egipto para comprar alimentos, ");
INSERT INTO spaonbv_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","22","al volver a nuestra tierra, nos detuvimos en un lugar a pasar la noche, abrimos nuestros costales y encontramos el dinero que habíamos pagado por el trigo. Aquí está; lo trajimos para devolverlo, además del dinero necesario para comprar más alimento. ¡No tenemos idea de cómo llegó el dinero a nuestros costales! ");
INSERT INTO spaonbv_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","―No se preocupen por ello —les dijo el mayordomo—; su Dios, el Dios de su padre, debe de haberlo puesto allí, porque nosotros recibimos el dinero completo. Entonces soltó a Simeón y lo llevó a donde ellos estaban, ");
INSERT INTO spaonbv_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Enseguida fueron conducidos al interior del palacio y les dieron agua para que se lavaran los pies. También les dieron comida a sus burros. ");
INSERT INTO spaonbv_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Luego sacaron y organizaron los regalos, para tenerlos listos para cuando llegara José al mediodía, porque se les había dicho que comerían allí. ");
INSERT INTO spaonbv_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Cuando José llegó le entregaron los regalos, y se inclinaron delante de él, en señal de respeto. ");
INSERT INTO spaonbv_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Él les preguntó cómo estaban, y dijo: ―¿Cómo está su padre, el anciano de que me hablaron? ¿Vive aún? ");
INSERT INTO spaonbv_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","―Sí —respondieron ellos—. Vive y goza de buena salud. Entonces volvieron a inclinarse delante de José. ");
INSERT INTO spaonbv_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","José miró a Benjamín, su hermano menor, y preguntó: ―¿Es este su hermano menor del cual me hablaron? ¿Cómo estás, hijo mío? ¡Dios te bendiga! ");
INSERT INTO spaonbv_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Entonces José tuvo que salir apresuradamente, porque el amor hacia su hermano lo llenó de emoción, y sintió necesidad de llorar. Se fue a su aposento y allí lloró. ");
INSERT INTO spaonbv_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Después de tranquilizarse, se lavó la cara, salió y ordenó. ―Sirvan la comida. ");
INSERT INTO spaonbv_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","José comió solo, mientras que sus hermanos comían en otra mesa, y los egipcios en otra, porque los egipcios despreciaban a los hebreos y jamás comían con ellos. ");
INSERT INTO spaonbv_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","José le indicó a cada uno su asiento, y los sentó de mayor a menor para sorpresa de ellos. ");
INSERT INTO spaonbv_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","La comida de los hermanos de José la servían desde la mesa de este. Le dio a Benjamín una porción cinco veces mayor que la de los demás. Bebieron con José, y pasaron unos momentos de mucha alegría. ");
INSERT INTO spaonbv_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Cuando sus hermanos estuvieron listos para emprender el regreso, José ordenó a su mayordomo que llenara cada una de sus costales con todo el trigo que pudieran contener, y pusiera en cada uno de ellos el dinero que habían pagado por el trigo. ");
INSERT INTO spaonbv_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","También le dijo que en el costal de Benjamín no sólo colocara el dinero sino también su copa de plata. Así lo hizo el mayordomo. ");
INSERT INTO spaonbv_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Los hermanos se levantaron de madrugada y emprendieron el viaje, con sus animales cargados. ");
INSERT INTO spaonbv_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Apenas habían salido de la ciudad, cuando José le dijo a su mayordomo: ―Alcánzalos, detenlos y pregúntales por qué me hacen esto a mí, que he sido tan bondadoso con ellos. ");
INSERT INTO spaonbv_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Pregúntales: “¿Qué pretendían al robar la copa de mi señor, la que usa para adivinar? ¡Qué gran maldad han hecho!”. ");
INSERT INTO spaonbv_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Entonces el mayordomo los siguió, los detuvo y les habló conforme a las instrucciones que José le había dado. ");
INSERT INTO spaonbv_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","―¿Qué dice? —le preguntaron—. ¿Qué clase de personas piensa que somos, que nos acusa de un delito tan grande? ");
INSERT INTO spaonbv_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Nosotros devolvimos el dinero que encontramos en nuestros costales. ¿Por qué habríamos de robar plata u oro de la casa de su amo? ");
INSERT INTO spaonbv_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Si encuentra su copa en poder de alguno de nosotros, que muera. Todos los demás seremos esclavos de su amo para siempre. ");
INSERT INTO spaonbv_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","―De acuerdo —contestó el hombre—, sólo el que robó la copa quedará de esclavo, y los demás quedarán libres. ");
INSERT INTO spaonbv_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Ellos bajaron rápidamente los costales que estaban sobre los animales, y los abrieron. ");
INSERT INTO spaonbv_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","El mayordomo comenzó a buscar en el costal del mayor y siguió revisando hasta llegar al del menor. ¡La copa estaba en el costal de Benjamín! ");
INSERT INTO spaonbv_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Ellos, llenos de desesperación, rasgaron su ropa, cargaron sus burros nuevamente, y volvieron a la ciudad. ");
INSERT INTO spaonbv_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","José todavía estaba en su casa cuando Judá y sus hermanos regresaron. Al llegar, se inclinaron delante de José. ");
INSERT INTO spaonbv_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","―¿Qué pretendían hacer? —les preguntó José—. ¿No sabían que un hombre como yo puede adivinar? ");
INSERT INTO spaonbv_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Entonces Judá dijo: ―¿Qué podemos decirle a mi señor? ¿Qué podemos decir a nuestro favor? ¿Cómo podríamos alegar inocencia? Dios nos está castigando por nuestros pecados. Señor, todos nosotros hemos regresado para ser sus esclavos, todos, incluso aquél en cuyo costal se encontró la copa. ");
INSERT INTO spaonbv_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","―No —dijo José—. Solamente el hombre que robó la copa será mi esclavo. Todos los demás pueden regresar en paz a su tierra y a su padre. ");
INSERT INTO spaonbv_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Entonces Judá se adelantó y dijo: ―Déjeme decirle algo. Tenga paciencia conmigo por un momento, porque sé que usted puede condenarme en un instante, como si fuera el mismo faraón. ");
INSERT INTO spaonbv_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Señor, usted nos preguntó si teníamos un padre y si teníamos hermanos. ");
INSERT INTO spaonbv_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Y nosotros le respondimos: “Sí, tenemos un padre, anciano, y un hijo de su vejez, el cual todavía es muy joven. El hermano de este murió y sólo él ha quedado de los hijos de su madre, y su padre lo ama mucho”. ");
INSERT INTO spaonbv_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Entonces usted nos dijo: “Tráiganlo para que yo lo vea”. ");
INSERT INTO spaonbv_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Pero nosotros le dijimos: “Señor, el muchacho no puede salir del lado de su padre, porque este moriría”. ");
INSERT INTO spaonbv_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Sin embargo, usted nos dijo: “No regresen sin su hermano menor”. ");
INSERT INTO spaonbv_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Entonces volvimos a nuestro padre y le contamos lo que usted nos había dicho. ");
INSERT INTO spaonbv_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Cuando él nos dijo: “Regresen y compren más alimento”, ");
INSERT INTO spaonbv_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","le respondimos: “No podemos, a menos que dejes que nuestro hermano menor vaya con nosotros. Sólo en ese caso podemos ir”. ");
INSERT INTO spaonbv_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Entonces mi padre nos dijo: “Ustedes saben que mi esposa sólo tuvo dos hijos, ");
INSERT INTO spaonbv_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","y que uno de ellos salió y no volvió jamás, sin duda destrozado por algún animal salvaje. Nunca más lo volví a ver. ");
INSERT INTO spaonbv_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Si ustedes se llevan a su hermano, y sufre algún daño, yo me moriré de dolor”. ");
INSERT INTO spaonbv_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","»Ahora, señor, si regresamos a nuestro padre sin nuestro hermano menor, de seguro se morirá de tristeza, pues está muy apegado a este muchacho. En ese caso, nosotros seremos los culpables de la muerte de nuestro padre. ");
INSERT INTO spaonbv_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Señor, yo le prometí a mi padre que cuidaría al muchacho. Le dije: “Si no te lo traigo de regreso, yo cargaré con la culpa para siempre”. ");
INSERT INTO spaonbv_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Por eso, señor, permita que yo me quede como su esclavo en lugar del muchacho, y deje que él regrese con sus hermanos. ");
INSERT INTO spaonbv_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Porque, ¿cómo regresaré a mi padre si el muchacho no va conmigo? ¡Yo no podría soportar ver sufrir tanto a mi padre! ");
INSERT INTO spaonbv_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","José no pudo aguantar más. ―¡Salgan todos de mi presencia! —exclamó—, dirigiéndose a sus siervos. Quedó solo con sus hermanos y, no pudiendo contenerse más, ");
INSERT INTO spaonbv_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","lloró en alta voz. Su llanto se oyó en todo el palacio, y la noticia llegó pronto al palacio del faraón. ");
INSERT INTO spaonbv_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","―Yo soy José —les dijo a sus hermanos—. ¿Mi padre vive aún? Pero los hermanos, debido a la gran sorpresa, se quedaron mudos. ");
INSERT INTO spaonbv_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","―¡Acérquense! —les dijo José. Ellos se acercaron, y José añadió: ―Yo soy su hermano José, el que ustedes vendieron como esclavo para Egipto. ");
INSERT INTO spaonbv_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Pero no se aflijan ni se condenen por ello, porque era plan de Dios. Dios me envió aquí antes que a ustedes para preservarnos la vida y la de nuestras familias. ");
INSERT INTO spaonbv_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Estos años de escasez son los primeros dos de siete años de hambre. En ese tiempo no habrá siembra ni cosecha. ");
INSERT INTO spaonbv_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Dios me envió aquí para mantenerlos con vida a ustedes y a sus familias, para que puedan ser una nación grande. ");
INSERT INTO spaonbv_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Sí, Dios, y no ustedes, fue el que me envió a Egipto. Dios me puso por consejero del faraón y por administrador de toda la nación, gobernador de toda la tierra de Egipto. ");
INSERT INTO spaonbv_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Dense prisa en volver a mi padre y díganle: “Tu hijo José dice: ‘Dios me ha puesto por jefe de toda la tierra de Egipto. Ven hasta donde yo estoy inmediatamente. ");
INSERT INTO spaonbv_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Vivirás en la tierra de Gosén y estarás cerca de mí con todos tus hijos y nietos, con tus ovejas y vacas, y todo lo que tengas. ");
INSERT INTO spaonbv_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","13","Yo te cuidaré’ ”. Ustedes son testigos de mi promesa, y mi hermano Benjamín me ha oído decirlo. Díganle a mi padre que todavía quedan cinco años de escasez. Si no hacen lo que les digo, quedarán en la completa pobreza ustedes y sus familias. Cuéntenle a mi padre todo el poder que tengo en Egipto y cómo todos me obedecen. Hagan que él venga pronto a verme. ");
INSERT INTO spaonbv_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Entonces, llorando de gozo, abrazó a Benjamín, y este comenzó a llorar también. ");
INSERT INTO spaonbv_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Hizo lo mismo con cada uno de sus hermanos. Después de esto, sus hermanos hablaron con él. ");
INSERT INTO spaonbv_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Y la noticia de que los hermanos de José estaban en Egipto llegó a oídos del faraón. Al saberlo, el faraón y sus funcionarios se alegraron mucho. ");
INSERT INTO spaonbv_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Entonces el faraón le dijo a José: ―Diles a tus hermanos que carguen sus bestias y vuelvan cuanto antes a sus hogares, en Canaán. ");
INSERT INTO spaonbv_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Además, diles que traigan a tu padre y a todas sus familias, para que se queden a vivir aquí en Egipto. Yo les daré la mejor tierra, de modo que podrán disfrutar de lo mejor de Egipto. ");
INSERT INTO spaonbv_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Diles también que lleven consigo carros de Egipto, para que traigan a sus esposas, a sus hijos pequeños y a su padre. ");
INSERT INTO spaonbv_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Y que no se preocupen por lo que tengan que dejar en su tierra, porque lo mejor de Egipto será de ellos. ");
INSERT INTO spaonbv_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Entonces José les dio carros, conforme a la orden del faraón. Además les dio provisiones para el viaje y mudas de ropa. ");
INSERT INTO spaonbv_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Pero a Benjamín le dio cinco mudas de ropa y trescientas monedas de plata. ");
INSERT INTO spaonbv_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","A su padre le envió diez burros cargados con las mejores cosas de Egipto, diez burras cargadas de trigo, y toda clase de alimentos para que comieran durante el viaje. ");
INSERT INTO spaonbv_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Entonces despidió a sus hermanos. ―No peleen en el camino —les aconsejó al despedirlos. ");
INSERT INTO spaonbv_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Ellos emprendieron el viaje y regresaron a la tierra de Canaán, donde estaba su padre Jacob. ");
INSERT INTO spaonbv_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","¡José está vivo! —exclamaron al contárselo—. Es el gobernador de toda la tierra de Egipto. Jacob se quedó pasmado, y no les creía. ");
INSERT INTO spaonbv_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Pero cuando le dieron los mensajes de José, y cuando vio los carros cargados de alimentos que José le había enviado, se llenó de alegría. ");
INSERT INTO spaonbv_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","―¡Les creo! —dijo—. ¡José mi hijo está vivo! ¡Iré y lo veré antes de morir! ");
INSERT INTO spaonbv_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Israel emprendió el viaje con todas sus posesiones, y fue hasta Berseba, donde ofreció sacrificios al Dios de su padre Isaac. ");
INSERT INTO spaonbv_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Aquella noche Dios le habló en visión: ―¡Jacob, Jacob! ―¿Qué quieres, Señor? —respondió. ");
INSERT INTO spaonbv_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","―Yo soy Dios —dijo la voz—, el Dios de tu padre. No tengas miedo de ir a Egipto, porque allí te haré una nación grande. ");
INSERT INTO spaonbv_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Yo iré contigo a Egipto y haré que tus descendientes vuelvan de allí. Tú morirás en Egipto, y José estará a tu lado. ");
INSERT INTO spaonbv_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Entonces Jacob salió de Berseba, y sus hijos lo llevaron a Egipto, juntamente con sus descendientes y sus esposas, en los carros que el faraón les había proporcionado. ");
INSERT INTO spaonbv_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","También llevaron todo el ganado y todas las pertenencias que habían acumulado en la tierra de Canaán. De ese modo Jacob y sus familiares llegaron a Egipto. ");
INSERT INTO spaonbv_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Es decir que a Jacob lo acompañaron todos sus seres queridos: hijos, hijas, nietos y nietas. ");
INSERT INTO spaonbv_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","14","Estos son los nombres de los hijos y nietos de Jacob que fueron con él a Egipto: Rubén, su primogénito. Los hijos de Rubén: Janoc, Falú, Jezrón y Carmí. Simeón y sus hijos: Jemuel, Jamín, Oad, Jaquín, Zojar y Saúl (cuya madre era una cananea). Leví y sus hijos: Guersón, Coat y Merari. Judá y sus hijos: Er, Onán, Selá, Fares y Zera (pero Er y Onán murieron cuando todavía estaban en Canaán, antes de que Israel fuera a Egipto). Los hijos de Fares fueron Jezrón y Jamul. Isacar y sus hijos: Tola, Fuvá, Job y Simrón. Zabulón y sus hijos: Séred, Elón y Yalel. ");
INSERT INTO spaonbv_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Estos son los descendientes de Jacob y Lea, sin contar a Dina, que nacieron en Padán Aram. En total eran treinta y tres personas. ");
INSERT INTO spaonbv_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","17","También fueron con él: Gad y sus hijos: Zefón, Jaguí, Esbón, Suni, Erí, Arodí y Arelí. Aser y sus hijos: Imná, Isvá, Isví, Beriá, y Sera, hermana de ellos. Los hijos de Beriá fueron Héber y Malquiel. ");
INSERT INTO spaonbv_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Estas dieciséis personas fueron los hijos de Jacob y Zilpá, la esclava que Lea recibió de su padre Labán. ");
INSERT INTO spaonbv_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","22","Los siguientes son los descendientes de Jacob y Raquel: José y Benjamín. Los hijos de José, que nacieron en Egipto, fueron Manasés y Efraín (la madre de ellos fue Asenat, hija de Potifera, sacerdote de Heliópolis). Los hijos de Benjamín: Bela, Béquer, Asbel, Guerá, Naamán, Ehí, Ros, Mupín, Jupín y Ard. En total, los descendientes de Jacob y Raquel fueron catorce personas. ");
INSERT INTO spaonbv_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","25","Además, en el grupo estaban estos siete descendientes de Jacob y Bilhá, la esclava que Raquel recibió de su padre Labán: Dan y su hijo Jusín; Neftalí y sus hijos: Yazel, Guní, Jéser y Silén. ");
INSERT INTO spaonbv_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","De modo que el total de los que fueron a Egipto, de los descendientes directos, sin contar a las esposas de los hijos de Jacob, eran sesenta y seis. ");
INSERT INTO spaonbv_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Considerando la familia de José con sus dos hijos, que estaban en Egipto, sumaban setenta. ");
INSERT INTO spaonbv_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Jacob envió a Judá adelante para que le dijera a José que ya estaban en camino y que pronto llegarían a Gosén. Cuando llegaron a ese lugar, ");
INSERT INTO spaonbv_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","José pidió que le prepararan su carro, y fue hasta allá, para ver a su padre. Cuando se encontraron se abrazaron y lloraron largo rato. ");
INSERT INTO spaonbv_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Entonces Israel le dijo a José: ―¡Ya me puedo morir, porque te he vuelto a ver y sé que estás vivo! ");
INSERT INTO spaonbv_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","José entonces le dijo a sus hermanos y a sus familias: ―Voy a decirle al faraón que ustedes están aquí, que han venido de la tierra de Canaán a quedarse conmigo. ");
INSERT INTO spaonbv_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Además le diré: “Estos hombres son pastores. Trajeron consigo sus ovejas y vacas, y todo lo que tenían”. ");
INSERT INTO spaonbv_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Entonces, cuando el faraón los llame y les pregunte por su ocupación, ");
INSERT INTO spaonbv_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","díganle: “Hemos sido pastores de ovejas desde nuestra niñez, y nuestros padres lo han sido durante generaciones”. Cuando le digan esto, los dejará vivir en la tierra de Gosén, porque para los egipcios es cosa detestable vivir junto a pastores de ovejas. ");
INSERT INTO spaonbv_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Luego, José fue a ver al faraón, y le dijo: ―Han llegado mi padre y mis hermanos desde Canaán con todas sus posesiones, ovejas y vacas. En este momento se encuentran en la región de Gosén. ");
INSERT INTO spaonbv_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","José había llevado consigo a cinco de sus hermanos y se los presentó al faraón. ");
INSERT INTO spaonbv_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Este entonces les preguntó: ―¿A qué se dedican? Y ellos contestaron: ―Somos pastores, como nuestros antepasados. ");
INSERT INTO spaonbv_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Hemos venido a vivir en Egipto porque no hay pasto para nuestro ganado en Canaán. El hambre es mucha allá. Queremos pedirle permiso para vivir en la tierra de Gosén. ");
INSERT INTO spaonbv_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","6","El faraón le dijo a José: ―Escoge el lugar que tú quieras para que vivan ellos. Dales la mejor tierra de Egipto. La tierra de Gosén es buena. Y si alguno de ellos quiere, ponlo a cargo de mis rebaños también. ");
INSERT INTO spaonbv_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Entonces José llevó a su padre Jacob ante el faraón. Y Jacob bendijo al faraón. ");
INSERT INTO spaonbv_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","―¿Qué edad tienes? —le preguntó el faraón. ");
INSERT INTO spaonbv_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Jacob le respondió: ―He vivido ciento treinta años que han sido largos y difíciles, pero no se pueden comparar con la edad de mis antepasados. ");
INSERT INTO spaonbv_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Entonces Jacob bendijo nuevamente al faraón y salió. ");
INSERT INTO spaonbv_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","José, pues, les dio la tierra de Ramsés, de acuerdo con lo que el faraón le había ordenado. ");
INSERT INTO spaonbv_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","José les proporcionó alimentos, según el número de los miembros de la familia. ");
INSERT INTO spaonbv_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","La escasez de alimentos fue cada vez mayor, de modo que toda la gente de Egipto y de Canaán estaba experimentando mucha hambre. ");
INSERT INTO spaonbv_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","José reunió todo el dinero de Canaán y de Egipto a cambio del trigo que les vendía, e ingresó ese dinero en la tesorería del faraón. ");
INSERT INTO spaonbv_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Cuando a la gente se le terminó el dinero, fueron a José a suplicar que se les diera alimentos. ―Se nos ha terminado el dinero —dijeron—. Por favor, denos alimentos, porque si no moriremos de hambre. ");
INSERT INTO spaonbv_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","―Bueno —replicó José—, denme sus ganados y yo les daré alimentos en cambio. ");
INSERT INTO spaonbv_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Así que trajeron el ganado a José para cambiarlo por alimentos. Pronto todos los caballos, ovejas, vacas y burros que había en Egipto pasaron a ser del faraón. ");
INSERT INTO spaonbv_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Al año siguiente vino nuevamente el pueblo y le dijo: ―Señor, usted sabe que ya no tenemos dinero. Además, todo nuestro ganado ahora es suyo. Tan solo podemos pagarle con nuestros cuerpos y nuestras tierras. ");
INSERT INTO spaonbv_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","¿Por qué hemos de morir? Cómprenos a nosotros y a nuestras tierras, y seremos esclavos del faraón. Cómprenos a nosotros por alimentos para que vivamos y para que la tierra no quede deshabitada. ");
INSERT INTO spaonbv_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Entonces José compró toda la tierra de Egipto para el faraón. La verdad es que, debido al hambre, los egipcios vendieron sus tierras. De ese modo, todo el país pasó a poder del faraón. ");
INSERT INTO spaonbv_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Y todos los egipcios pasaron a ser esclavos del faraón. ");
INSERT INTO spaonbv_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","La única tierra que no compró fue la de los sacerdotes, porque tenían ración de parte del faraón y no necesitaban venderla. ");
INSERT INTO spaonbv_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Entonces José dijo a la gente: ―Los he comprado a ustedes y a sus tierras para el faraón. Aquí está el trigo. Vayan y siembren la tierra. ");
INSERT INTO spaonbv_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Cuando llegue la cosecha, la quinta parte será para el faraón. Reserven cuatro partes para que se alimenten y tengan semilla para el año siguiente. Así tendrán alimento para ustedes y sus familias. ");
INSERT INTO spaonbv_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","―¡Usted nos ha salvado la vida! —le dijeron—. ¡Con todo gusto seremos esclavos del faraón! ");
INSERT INTO spaonbv_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Entonces José estableció esta ley en Egipto: la quinta parte de todas las cosechas es del faraón. Esta ley todavía se sigue aplicando. Las únicas tierras que no pasaron a ser propiedad del faraón fueron las de los sacerdotes. ");
INSERT INTO spaonbv_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Los israelitas, pues, vivieron en la tierra de Gosén, en Egipto, consiguieron terrenos, prosperaron y tuvieron muchos hijos. ");
INSERT INTO spaonbv_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jacob vivió diecisiete años en Egipto, y en total, vivió ciento cuarenta y siete años. ");
INSERT INTO spaonbv_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Cuando se le acercaba el momento de la muerte, llamó a su hijo José y le dijo: ―Júrame solemnemente que harás lo que te voy a pedir. ¡Si de veras me amas, por favor, no me entierres en Egipto! ");
INSERT INTO spaonbv_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Cuando yo haya muerto, sácame de Egipto y sepúltame junto a mis antepasados. Y José se lo prometió. ");
INSERT INTO spaonbv_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","―¡Júrame que lo harás! —insistió Jacob. Y José se lo juró. Luego, Israel se recostó sobre la cabecera de la cama. ");
INSERT INTO spaonbv_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Poco tiempo después de esto, José recibió la noticia de que su padre estaba enfermo. Entonces, tomó a sus dos hijos, Manasés y Efraín, y fue a visitarlo. ");
INSERT INTO spaonbv_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Cuando Jacob oyó que José había llegado, reunió todas sus fuerzas y se sentó en la cama y le dijo: ");
INSERT INTO spaonbv_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","―El Dios Todopoderoso se me apareció en Luz, en la tierra de Canaán. ");
INSERT INTO spaonbv_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Allí me dijo: “Haré de ti una nación grande, y esta tierra de Canaán será para ti y para los hijos de tus hijos, como posesión permanente”. ");
INSERT INTO spaonbv_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","»A tus dos hijos, Efraín y Manasés, que te nacieron antes de que yo llegara a esta tierra, los adopto como hijos míos. Ellos recibirán parte de mi herencia tal como lo harán Rubén y Simeón. ");
INSERT INTO spaonbv_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Pero cualesquiera otros hijos que te nazcan serán tuyos, y heredarán de ti la porción de Efraín y Manasés. ");
INSERT INTO spaonbv_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Raquel, tu madre, murió cerca de Efrata, en la tierra de Canaán, cuando yo regresaba de Padán Aram. Entonces la sepulté allí junto al camino de Efrata, que es la misma ciudad de Belén. ");
INSERT INTO spaonbv_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","En eso, Jacob vio a los hijos de José, y le preguntó: ―¿Y quiénes son estos? ");
INSERT INTO spaonbv_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","José le respondió: ―Son mis hijos, los cuales Dios me ha dado aquí en Egipto. ―Acércamelos, para que los bendiga —dijo Israel. ");
INSERT INTO spaonbv_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Debido a su avanzada edad, Israel no podía ver bien. Por eso, José le acercó sus hijos. Entonces Israel los besó y abrazó. ");
INSERT INTO spaonbv_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Israel entonces le dijo a José: ―Jamás pensé que te volvería a ver. Sin embargo Dios me ha permitido ver a tus hijos también. ");
INSERT INTO spaonbv_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","13","José tomó a sus hijos de la mano, se inclinó delante de su padre, e hizo que los muchachos se postraran delante de su abuelo: Efraín a la izquierda de Israel y Manasés a su derecha. ");
INSERT INTO spaonbv_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Sin embargo, Israel cruzó los brazos y los extendió para ponerlos en la cabeza de los muchachos, de modo que su mano derecha estaba sobre la cabeza de Efraín y su izquierda sobre la cabeza de Manasés, el mayor. Hizo esto intencionalmente. ");
INSERT INTO spaonbv_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Entonces bendijo a José, diciéndole: ―Quiera Dios, el Dios de mis padres Abraham e Isaac, el Dios que me pastoreó toda la vida, bendecir a estos muchachos. ");
INSERT INTO spaonbv_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Él es el Ángel que me ha librado de todo mal. Que estos muchachos hagan perpetua la memoria de mi nombre y la de mis padres Abraham e Isaac, y que lleguen a ser una nación grande. ");
INSERT INTO spaonbv_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Pero José, al ver que su padre había puesto su mano derecha sobre la cabeza de Efraín, se molestó. Entonces agarró la mano de su padre y se la quitó de encima de la cabeza de Efraín y se la puso sobre la cabeza de Manasés, y le dijo: ");
INSERT INTO spaonbv_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","―¡No hagas esto, padre mío! Por favor, pon tu mano derecha sobre mi hijo Manasés, pues él es el mayor. ");
INSERT INTO spaonbv_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Pero su padre se rehusó a hacerlo. ―Yo sé lo que estoy haciendo, hijo mío —le dijo—. Manasés también será una nación grande, pero su hermano menor será más importante, y de él saldrán muchos pueblos. ");
INSERT INTO spaonbv_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Así, pues, aquel día Jacob les dio a los muchachos la siguiente bendición: ―Que el pueblo de Israel use el siguiente dicho como bendición: “Dios te haga próspero como Efraín y Manasés”. Y puso a Efraín antes que a Manasés. ");
INSERT INTO spaonbv_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Entonces Israel le dijo a José: ―Estoy para morir; pero Dios estará con ustedes y los hará volver a Canaán, la tierra de sus antepasados. ");
INSERT INTO spaonbv_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","A ti te doy la tierra escogida de Siquén, pues estás por encima de tus hermanos. Esa tierra se la quité a los amorreos, luchando fieramente contra ellos. ");
INSERT INTO spaonbv_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Jacob llamó a todos sus hijos, y les dijo: ―Reúnanse a mi alrededor, pues voy a decirles que les va a suceder en los días venideros. ");
INSERT INTO spaonbv_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Óiganme, hijos de Jacob, escuchen a Israel su padre. ");
INSERT INTO spaonbv_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","»Rubén, tú eres mi hijo mayor, el hijo de mi vigorosa juventud. Eres el primero en rango y en dignidad, ");
INSERT INTO spaonbv_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","pero a partir de hoy, ya no serás el primero, porque me deshonraste al dormir con una de mis mujeres. Eres impetuoso como las fieras ondas del mar. ");
INSERT INTO spaonbv_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","»Simeón y Leví son hermanos; usan sus armas para matar con violencia. ");
INSERT INTO spaonbv_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","No quiero participar de sus planes malvados, ni estar en sus reuniones. En su ira asesinaron hombres y por diversión desjarretaron toros. ");
INSERT INTO spaonbv_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","¡Maldita sea su ira! ¡Maldita sea también su violencia y crueldad! Haré que sus descendientes sean esparcidos por todo el país de Israel. ");
INSERT INTO spaonbv_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","»Judá, tus hermanos te alabarán. Vencerás a tus enemigos. Los hijos de tu padre se inclinarán delante de ti. ");
INSERT INTO spaonbv_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Judá es como un cachorro de león que se levanta después de comer a su presa. Se pone al acecho como un león o como una leona, ¿quién se atreverá a molestarlo? ");
INSERT INTO spaonbv_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","El cetro estará en las manos de Judá, y el bastón de gobernante estará en sus pies, hasta que llegue el rey por excelencia, a quien todos los pueblos obedecerán. ");
INSERT INTO spaonbv_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Atará su burrito en la vid más selecta y lavará su ropa en vino. ");
INSERT INTO spaonbv_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Sus ojos son más oscuros que el vino y sus dientes más blancos que la leche. ");
INSERT INTO spaonbv_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","»Zabulón habitará en las costas del mar, servirá de puerto para los navíos, y sus fronteras se extenderán hasta Sidón. ");
INSERT INTO spaonbv_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","»Isacar es fuerte bestia de carga que descansa entre las alforjas. ");
INSERT INTO spaonbv_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Cuando vea la hermosura del paisaje, lo agradable de la tierra, con gusto agachará su hombro para la tarea y se convertirá en un esclavo. ");
INSERT INTO spaonbv_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","»Dan gobernará su pueblo como cualquier tribu de Israel. ");
INSERT INTO spaonbv_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Será serpiente en el sendero, que muerde los talones del caballo para que caiga el jinete. ");
INSERT INTO spaonbv_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","»¡Señor, esperaré tu ayuda! ");
INSERT INTO spaonbv_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","»Un ejército atacará a Gad, pero él lo atacará por atrás. ");
INSERT INTO spaonbv_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","»Aser producirá manjares deliciosos que serán dignos del rey. ");
INSERT INTO spaonbv_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","»Neftalí es una gacela libre, que tendrá preciosas crías. ");
INSERT INTO spaonbv_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","»José es un árbol fructífero, es como un árbol junto a una fuente, y sus ramas pasan sobre el muro. ");
INSERT INTO spaonbv_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Gente mala le causa amargura, lo atacan sin piedad y le lanzan flechas. ");
INSERT INTO spaonbv_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Pero su arma se mantuvo firme, sus brazos fueron fortalecidos por el Dios poderoso de Jacob, por el que es el Pastor y la Roca de Israel. ");
INSERT INTO spaonbv_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","¡Que el Dios de tus padres, el Todopoderoso, te bendiga con bendiciones celestiales y con bendiciones del profundo mar, con bendiciones de los pechos y bendiciones de la matriz. ");
INSERT INTO spaonbv_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Las bendiciones de tu padre son más grandes que las bendiciones de mis padres. Estas bendiciones reposarán sobre la cabeza de José hasta el fin de las montañas eternas, por cuanto él es el más importante de sus hermanos. ");
INSERT INTO spaonbv_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","»Benjamin es como un lobo feroz, que por la mañana devora a su presa, y al atardecer reparte lo que sobra». ");
INSERT INTO spaonbv_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Estas fueron las bendiciones que Israel pronunció sobre sus doce hijos. ");
INSERT INTO spaonbv_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","30","Además les dijo: ―Ya voy a morir. Deben sepultarme con mis padres en la tierra de Canaán, en la cueva del campo de Macpela, frente a Mamré, el campo que Abraham le compró a Efrón el hitita, como propiedad para sepulturas. ");
INSERT INTO spaonbv_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Allí fueron sepultados Abraham y su esposa Sara. También fueron sepultados allí Isaac y su esposa Rebeca; y allí también sepulté a Lea. ");
INSERT INTO spaonbv_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Es la cueva que mi abuelo Abraham les compró a los hijos de Het. ");
INSERT INTO spaonbv_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Cuando Jacob terminó de dar estas instrucciones a sus hijos, se acostó nuevamente, exhaló su último suspiro, y murió. ");
INSERT INTO spaonbv_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","José, entonces, se puso a llorar, abrazó a su padre y lo besó. ");
INSERT INTO spaonbv_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Luego les dijo a los médicos que estaban a su servicio que embalsamaran el cuerpo de su padre. Y los médicos egipcios obedecieron. ");
INSERT INTO spaonbv_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Esperaron los cuarenta días establecidos para los embalsamados, los egipcios hicieron duelo nacional durante setenta días. ");
INSERT INTO spaonbv_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Cuando terminó el duelo, José se acercó a los funcionarios de la casa del faraón y les dijo: ―Díganle a su majestad ");
INSERT INTO spaonbv_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","que mi padre me hizo jurar que llevaría su cuerpo de regreso a la tierra de Canaán, para sepultarlo allá. Díganle a su majestad que me permita ir a sepultar a mi padre. Asegúrenle que volveré pronto. ");
INSERT INTO spaonbv_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","El faraón estuvo de acuerdo: ―Ve y sepulta a tu padre, tal como se lo prometiste. ");
INSERT INTO spaonbv_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","8","Entonces José fue a enterrar a su padre. Con él fueron su familia, sus hermanos y el resto de la familia de Jacob. En Gosén sólo dejaron a los niños, las ovejas y las vacas. Además, los acompañaron un gran número de funcionarios y consejeros del faraón, y los hombres importantes de Egipto. ");
INSERT INTO spaonbv_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","De modo que muchos carros y caballos, y gente de a pie acompañaron a José. ");
INSERT INTO spaonbv_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Cuando llegaron a la era de Hatad, que está al otro lado del Jordán, tuvieron un servicio fúnebre grande y solemne. Allí José guardó siete días de luto por su padre. ");
INSERT INTO spaonbv_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Los cananeos que vivían en esa región vieron que los egipcios lloraban amargamente en la era de Hatad, le pusieron a ese lugar el nombre de Abel Misrayin, pues dijeron: «Los egipcios están haciendo duelo por alguien importante». ");
INSERT INTO spaonbv_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","13","De modo que, de acuerdo con las órdenes de Israel, sus hijos llevaron su cuerpo a la tierra de Canaán y lo sepultaron en la cueva de Macpela, la cueva que Abraham había comprado en el campo de Efrón el hitita, cerca de Mamré. ");
INSERT INTO spaonbv_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","José regresó luego a Egipto, junto con todos los que lo habían acompañado al funeral de su padre. ");
INSERT INTO spaonbv_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Una vez muerto su padre, los hermanos de José sintieron miedo, pues pensaban que José les guardaba rencor, y aprovecharía la ocasión para vengarse de ellos por lo que le hicieron. ");
INSERT INTO spaonbv_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Así que le enviaron a unos mensajeros, para que le dijeran a José que su padre, antes de morir, había dicho: ");
INSERT INTO spaonbv_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","«Díganle a José que, por favor, les perdone a sus hermanos el mal que le hicieron». Así que los emisarios fueron y le dieron el mensaje a José. Además, añadieron: «Te rogamos que perdones el pecado de estos siervos del Dios de tu padre». Cuando José oyó el mensaje, se conmovió profundamente y lloró. ");
INSERT INTO spaonbv_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Luego llegaron sus hermanos, y cayendo de rodillas delante de él le dijeron: ―Aquí estamos para ser tus esclavos. ");
INSERT INTO spaonbv_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Pero José les respondió: ―No me tengan miedo. ¿Creen que puedo tomar yo el lugar de Dios para juzgarlos y castigarlos? ");
INSERT INTO spaonbv_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","En lo que a mí respecta, Dios convirtió en bien el mal que ustedes quisieron hacerme, y me puso en el alto cargo que ahora desempeño a fin de que salvara la vida de mucha gente. ");
INSERT INTO spaonbv_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","No, no tengan miedo. Yo mismo cuidaré de sus familias. Y de esta manera les habló con mucho cariño y los tranquilizó. ");
INSERT INTO spaonbv_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","José y sus hermanos siguieron viviendo en la tierra de Egipto. José murió a la edad de ciento diez años, y ");
INSERT INTO spaonbv_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","vio nacer los hijos de Efraín hasta la tercera generación. También alcanzó a cargar en sus rodillas a los hijos de Maquir, el hijo de Manasés. ");
INSERT INTO spaonbv_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Y dijo José a sus hermanos: «Muy pronto moriré. Pero Dios ciertamente vendrá y los sacará de la tierra de Egipto, para hacerlos regresar a la tierra que él prometió a la descendencia de Abraham, Isaac, y Jacob». ");
INSERT INTO spaonbv_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Entonces José hizo que sus hermanos le prometieran con juramento que se iban a llevar consigo su cuerpo, cuando regresaran a Canaán. ");
INSERT INTO spaonbv_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","José, pues, murió a la edad de ciento diez años. Fue embalsamado, y su cuerpo fue puesto en un ataúd en Egipto.");
INSERT INTO spaonbv_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Esta es la lista de los hijos de Jacob que lo acompañaron a Egipto con sus familias: ");
INSERT INTO spaonbv_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","4","Rubén, Simeón, Leví, Judá, Isacar, Zabulón, Benjamín, Dan, Neftalí, Gad y Aser. ");
INSERT INTO spaonbv_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","El número total de las personas que lo acompañaron fue de setenta (porque José ya estaba allá). ");
INSERT INTO spaonbv_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Con el correr del tiempo, José y sus hermanos murieron, y se acabó toda aquella generación. ");
INSERT INTO spaonbv_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Pero sus descendientes fueron muy fructíferos y se multiplicaron rápidamente, de modo que llegaron a ser un pueblo muy numeroso y fuerte. ¡Todo el país se fue llenando de israelitas! ");
INSERT INTO spaonbv_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Pasado el tiempo, subió al trono de Egipto un nuevo rey que no se sintió comprometido con los descendientes de José. ");
INSERT INTO spaonbv_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","«Estos israelitas se han convertido en un peligro para nosotros, porque son demasiados —dijo a su pueblo—. ");
INSERT INTO spaonbv_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Tenemos que buscar la manera de ponerle fin a esto. De otro modo, en caso de guerra, podrían aliarse con nuestros enemigos, pelear en contra de nosotros y escapar del país». ");
INSERT INTO spaonbv_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Entonces los egipcios esclavizaron a los hebreos, y les pusieron capataces muy crueles. Estos les asignaron la dura tarea de edificar las ciudades de Pitón y Ramsés, que eran las ciudades donde el rey almacenaba todas las provisiones. ");
INSERT INTO spaonbv_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Pero cuanto más los oprimían los egipcios, más se multiplicaban los israelitas. Los egipcios estaban alarmados ");
INSERT INTO spaonbv_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","14","e hicieron aún más amarga la esclavitud de los hebreos. Los obligaron a trabajar duramente largas jornadas en los campos y a acarrear pesadas cargas de ladrillo y mezcla. ");
INSERT INTO spaonbv_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","16","El faraón, rey de Egipto, ordenó a las parteras que atendían a las mujeres hebreas (dos de las cuales se llamaban Sifrá y Fuvá) que se fijaran en el sexo del bebé a la hora de nacer, y que mataran a todos los niños hebreos en cuanto nacieran, y que dejaran con vida sólo a las niñas. ");
INSERT INTO spaonbv_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Pero las parteras tenían temor de Dios y desobedecieron al faraón, pues permitían que los niños vivieran. ");
INSERT INTO spaonbv_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","El faraón las citó para que se presentaran delante de él, y les preguntó: ―¿Por qué me han desobedecido y han dejado vivir a los niños? ");
INSERT INTO spaonbv_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","―Señor —dijeron ellas—, las mujeres hebreas no son como las egipcias, son tan vigorosas que dan a luz antes de que nosotras lleguemos. ");
INSERT INTO spaonbv_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Dios bendijo a las parteras por haber favorecido a su pueblo. Así que los israelitas siguieron multiplicándose, hasta llegar a ser una nación poderosa. ");
INSERT INTO spaonbv_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Y como las parteras tuvieron temor de Dios, él les permitió tener muchos hijos. ");
INSERT INTO spaonbv_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Entonces el faraón ordenó a su pueblo que echaran al río Nilo a todo niño hebreo que naciera, pero que a las niñas las dejaran con vida. ");
INSERT INTO spaonbv_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Por esa época, un hombre de la tribu de Leví se casó con una mujer de su misma tribu. ");
INSERT INTO spaonbv_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Después de un tiempo, la mujer quedó embarazada y tuvo un hijo. El niño era tan hermoso, que la madre lo mantuvo escondido durante tres meses. ");
INSERT INTO spaonbv_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Pero cuando ya no pudo esconderlo más, le hizo una pequeña cesta de papiro, la recubrió con asfalto, y puso al niño adentro; luego fue y lo dejó en medio de las cañas que crecían a la orilla del río. ");
INSERT INTO spaonbv_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","La hermana del bebé lo estuvo vigilando desde lejos, para ver qué iba a pasar con él. ");
INSERT INTO spaonbv_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","En eso vio que llegaba a bañarse al río una princesa, una de las hijas del faraón. Mientras caminaba por la orilla con sus damas de compañía, vio la pequeña cesta que estaba en medio de las cañas y envió a una de sus doncellas para que se la llevara. ");
INSERT INTO spaonbv_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Cuando la abrió, vio al bebé que lloraba, y se sintió conmovida. ―Debe de ser un bebé de los hebreos —dijo. ");
INSERT INTO spaonbv_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","La hermana del niño se acercó y le preguntó a la princesa: ―¿Quiere que vaya y busque a una mujer hebrea para que le cuide al niño? ");
INSERT INTO spaonbv_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","―Sí, anda —respondió la princesa. La muchacha corrió hasta su casa, y regresó con su madre. ");
INSERT INTO spaonbv_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","―Lleva a este niño a tu casa y cuídamelo —le ordenó la princesa a la madre del niño—. Te pagaré bien. Ella, pues, lo llevó a su casa y lo cuidó. ");
INSERT INTO spaonbv_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Cuando el niño creció, la madre se lo llevó a la princesa, y ella lo adoptó como hijo suyo. Lo llamó Moisés, porque lo había sacado de las aguas. ");
INSERT INTO spaonbv_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Un día, cuando Moisés ya había crecido, salió a visitar a los hebreos y vio la terrible condición en que se encontraban. Durante esta visita vio que un egipcio golpeaba a un hebreo, ¡a un compatriota suyo! ");
INSERT INTO spaonbv_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Moisés miró hacia todos lados para asegurarse de que nadie lo veía, mató al egipcio y lo sepultó en la arena. ");
INSERT INTO spaonbv_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Al día siguiente volvió a salir a visitar a los hebreos, y vio que dos de ellos estaban peleando. ―¿Por qué golpeas a tu hermano de esa manera? —le dijo al que estaba golpeando al otro. ");
INSERT INTO spaonbv_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","―¿Quién te crees tú? —le contestó el hombre—. Supongo que te crees príncipe y juez. ¿Quieres matarme también como lo hiciste con el egipcio ayer? Cuando Moisés se dio cuenta de que se sabía lo que había hecho, se asustó. ");
INSERT INTO spaonbv_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Y en efecto, cuando el faraón se enteró, ordenó que Moisés fuera arrestado y ejecutado. Pero Moisés huyó hacia la tierra de Madián. Al llegar a allá, se sentó junto a un pozo. ");
INSERT INTO spaonbv_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Estaba allí sentado, cuando llegaron siete muchachas a sacar agua del pozo, para llenar los abrevaderos y darles de beber a las ovejas de su padre. Las siete eran hijas del sacerdote de Madián. ");
INSERT INTO spaonbv_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Pero los pastores que estaban allí querían impedir que ellas sacaran agua. Moisés acudió en su ayuda y las libró de los pastores, y dio de beber a las ovejas. ");
INSERT INTO spaonbv_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Cuando las muchachas volvieron a casa, su padre Reuel, también llamado Jetro, les preguntó: ―¿Cómo es que pudieron regresar hoy tan temprano? ");
INSERT INTO spaonbv_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","―Un egipcio nos defendió de los pastores —respondieron ellas—, y sacó agua y dio de beber a los rebaños. ");
INSERT INTO spaonbv_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","―Bueno, pero ¿dónde está? —les preguntó el padre—. ¿Lo dejaron allá? Invítenlo a comer. ");
INSERT INTO spaonbv_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Moisés aceptó la invitación y acabó quedándose a vivir con ellos. Después de un tiempo, Reuel le dio por esposa a Séfora, una de sus hijas. ");
INSERT INTO spaonbv_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Tuvieron un hijo, y Moisés le puso por nombre Guersón, porque dijo: «Soy forastero en tierra extraña». ");
INSERT INTO spaonbv_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Pasaron muchos años, y murió el faraón. Los israelitas, sin embargo, gemían bajo su pesada carga, profundamente atribulados por la esclavitud, y lloraban amargamente delante de Dios. Dios oyó su lamento desde los cielos y ");
INSERT INTO spaonbv_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","se acordó de su pacto, de la promesa hecha a Abraham, a Isaac y a Jacob de hacer regresar a sus descendientes a la tierra de Canaán. ");
INSERT INTO spaonbv_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Los miró desde lo alto y decidió ayudarlos. ");
INSERT INTO spaonbv_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Un día, mientras Moisés pastoreaba los rebaños de su suegro Jetro, sacerdote de Madián, al otro lado del desierto, cerca de Horeb, monte de Dios, ");
INSERT INTO spaonbv_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","repentinamente se le apareció el ángel del Señor, como llamas de fuego en una zarza. Cuando Moisés vio que la zarza ardía sin quemarse, ");
INSERT INTO spaonbv_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","4","se acercó para ver bien lo que pasaba. Pero el Señor lo llamó: ―¡Moisés, Moisés! ―¿Quién me llama? —preguntó Moisés. ");
INSERT INTO spaonbv_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","―No te acerques —le dijo Dios—. ¡Quítate las sandalias, porque estás pisando tierra santa! ");
INSERT INTO spaonbv_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Yo soy el Dios de tus padres, el Dios de Abraham, de Isaac y de Jacob. Moisés se cubrió el rostro con ambas manos, porque tenía miedo de mirar a Dios. ");
INSERT INTO spaonbv_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","―He visto los profundos sufrimientos de mi pueblo en Egipto —le dijo el Señor—, y he oído sus oraciones en que piden liberación de sus duros capataces. ");
INSERT INTO spaonbv_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","He venido a liberarlos de sus opresores egipcios y a llevarlos a una tierra buena y grande, tierra de la que fluye leche y miel, tierra en que viven los cananeos, los hititas, los amorreos, los ferezeos, los heveos y los jebuseos. ");
INSERT INTO spaonbv_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Sí, el clamor del pueblo de Israel ha ascendido hasta mi presencia, y he visto las pesadas tareas con que los egipcios los han oprimido. ");
INSERT INTO spaonbv_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Ahora te voy a enviar al faraón, para que saques a mi pueblo de Egipto. ");
INSERT INTO spaonbv_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","―Pero, yo no soy la persona adecuada para esta tarea —le dijo Moisés a Dios. ");
INSERT INTO spaonbv_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","―Ciertamente estaré contigo —le dijo Dios—, y esta es la demostración de que yo soy el que te envío: cuando hayas sacado al pueblo de Egipto, tú y el pueblo me adorarán sobre esta montaña. ");
INSERT INTO spaonbv_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Pero Moisés dijo: ―Si yo voy al pueblo de Israel y les digo que me envió el Dios de sus padres, ellos me preguntarán: “¿De qué Dios nos estás hablando?”. ¿Qué les diré? ");
INSERT INTO spaonbv_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Entonces Dios le respondió a Moisés: ―Diles que te envía el Dios eterno, pues YO SOY EL QUE SOY. ¡Mi nombre es YO SOY! Simplemente diles: “YO SOY es el que me ha enviado”. ");
INSERT INTO spaonbv_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Además, Dios agregó: ―Diles a los israelitas: “El Señor, el Dios de sus antepasados Abraham, Isaac y Jacob me ha enviado a ustedes. Este es mi nombre eterno y por este nombre seré conocido a través de las generaciones”. ");
INSERT INTO spaonbv_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","»Convoca a todos los ancianos de Israel y diles que el Señor se te apareció en esta zarza ardiente y que te dijo: “He visitado a mi pueblo y he visto lo que les ocurre en Egipto. ");
INSERT INTO spaonbv_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Prometo rescatarlos de la esclavitud y humillación que están soportando, y llevarlos a la tierra que ahora ocupan los cananeos, los hititas, los amorreos, los ferezeos, los heveos y los jebuseos, tierra que fluye leche y miel”. ");
INSERT INTO spaonbv_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Los ancianos del pueblo aceptarán tu mensaje, e irán contigo ante el faraón a decirle: “El Señor, el Dios de los hebreos, ha venido a visitarnos y nos ha dado órdenes de ir tres días de camino por el desierto, para ofrecerle sacrificio. Así que te pedimos que nos dejes ir”. ");
INSERT INTO spaonbv_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Pero yo sé que el faraón no les dará permiso, a menos que se haga sobre él mucha presión. ");
INSERT INTO spaonbv_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Yo me encargaré de presionarlo hasta que los deje salir. ");
INSERT INTO spaonbv_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Además, haré que los egipcios los carguen de obsequios en el momento de salir, para que no salgan con las manos vacías. ");
INSERT INTO spaonbv_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Cada mujer pedirá joyas, plata, oro y los vestidos más finos de sus vecinas y de las amigas de estas. Así ustedes vestirán a sus hijos e hijas con lo mejor de Egipto. De esa manera ustedes se quedarán con los objetos más valiosos de los egipcios». ");
INSERT INTO spaonbv_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Pero Moisés le respondió a Dios: ―No me creerán ni harán lo que les diga. Al contrario, me dirán: “¡El Señor no se te ha aparecido!”. ");
INSERT INTO spaonbv_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","―¿Qué tienes en la mano? —le preguntó el Señor. ―Una vara de pastor —le respondió Moisés. ");
INSERT INTO spaonbv_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","―Tírala al suelo —le ordenó el Señor. Cuando la arrojó, la vara se convirtió en una serpiente, y Moisés retrocedió al verla. ");
INSERT INTO spaonbv_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","―Tómala de la cola —le dijo el Señor. Él lo hizo, y la serpiente volvió a convertirse en vara. ");
INSERT INTO spaonbv_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","―Haz eso y te creerán —le dijo el Señor—, pues comprenderán que me has visto a mí, que soy el Señor Dios de sus antepasados Abraham, Isaac y Jacob. ");
INSERT INTO spaonbv_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Ahora, mete tu mano dentro de tu ropa y tócate el pecho. Moisés metió la mano y la volvió a sacar. ¡Estaba blanca de lepra! ");
INSERT INTO spaonbv_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","―Hazlo otra vez —le dijo Dios. Cuando Moisés metió la mano y la volvió a sacar, estaba normal, completamente sana. ");
INSERT INTO spaonbv_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","―Si no creen al primer milagro, creerán al segundo —le dijo el Señor—. ");
INSERT INTO spaonbv_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Si no aceptan el segundo, toma agua del Nilo y derrámala en tierra seca. Tan pronto el agua caiga al suelo, se convertirá en sangre. ");
INSERT INTO spaonbv_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Pero Moisés insistió: ―Señor, tú sabes que nunca me he distinguido por ser un buen orador. Es un problema que tengo desde mucho antes de que tú me hablaras. ¡Me cuesta mucho trabajo expresarme bien! ");
INSERT INTO spaonbv_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","―¿Quién hizo la boca? —le preguntó el Señor—. ¿No la hice yo, el Señor? ¿Quién hace que el hombre pueda o no pueda hablar, que vea o no vea, que oiga o no oiga? ");
INSERT INTO spaonbv_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Ahora ve y haz lo que te dije, porque yo te ayudaré a expresarte bien, y te diré lo que tienes que decir. ");
INSERT INTO spaonbv_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Moisés le dijo: ―Señor, por favor, envía a otra persona. ");
INSERT INTO spaonbv_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","El Señor se enojó con Moisés y le dijo: ―¡Muy bien! Tu hermano Aarón habla bien. Él vendrá a buscarte y se alegrará mucho cuando te encuentre. ");
INSERT INTO spaonbv_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Yo te diré lo que tienes que decirle; yo los ayudaré a ambos para que hablen bien, y les diré lo que deben hacer. ");
INSERT INTO spaonbv_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Yo te diré lo que debes comunicarle a Aarón, y él hablará por ti al pueblo, y será como si tú mismo estuvieras hablándole a la gente. ");
INSERT INTO spaonbv_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Llévate la vara para que puedas realizar los milagros que te he mostrado. ");
INSERT INTO spaonbv_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Moisés volvió a casa y habló de esto con Jetro, su suegro. ―Con tu permiso —le dijo Moisés—, iré a Egipto para ver cómo están mis hermanos. Ni siquiera sé si viven aún. ―Ve con mi bendición —contestó Jetro. ");
INSERT INTO spaonbv_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Antes de que Moisés saliera de Madián, el Señor le dijo: ―No tengas miedo de regresar a Egipto, porque los que querían matarte han muerto. ");
INSERT INTO spaonbv_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Moisés tomó a su esposa y a sus hijos, los puso sobre un burro, y regresó a la tierra de Egipto, llevando en la mano la vara de Dios. ");
INSERT INTO spaonbv_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Y el Señor le dijo: ―Cuando hayas regresado a Egipto tienes que hacer delante del faraón los milagros que te mostré. Sin embargo, yo haré que el faraón se niegue a dejar salir al pueblo. ");
INSERT INTO spaonbv_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Así que tú le dirás: “El Señor dice: ‘Israel es mi hijo primogénito, ");
INSERT INTO spaonbv_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","y yo te he ordenado que lo dejes salir, para que vaya a adorarme, pero te has negado. Por lo tanto, mataré a tu primogénito’ ”. ");
INSERT INTO spaonbv_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Durante el viaje, Moisés y su familia se detuvieron para pasar la noche. Allí el Señor se le apareció y amenazó con matarlo. ");
INSERT INTO spaonbv_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","26","Pero Séfora, la esposa de Moisés, tomó un cuchillo de pedernal y cortó el prepucio del pene de su hijo. Luego, con el prepucio tocó los genitales de Moisés, y le dijo: ―Me has resultado un marido de sangre. Entonces Dios lo dejó ir. ");
INSERT INTO spaonbv_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Mientras tanto, el Señor le había dicho a Aarón: ―Ve al desierto a encontrarte con Moisés. Aarón viajó hasta Horeb, el monte de Dios, y allí se encontró con Moisés, y ambos se saludaron con mucho cariño. ");
INSERT INTO spaonbv_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Moisés le contó a Aarón lo que Dios le había dicho que debían hacer y lo que tenían que decir, y le habló de los milagros que debían hacer en presencia del faraón. ");
INSERT INTO spaonbv_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Moisés y Aarón regresaron a Egipto y convocaron a los ancianos a una reunión. ");
INSERT INTO spaonbv_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Aarón les contó lo que el Señor le había dicho a Moisés; y Moisés realizó delante de ellos los milagros que debía hacer en presencia del faraón. ");
INSERT INTO spaonbv_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Los ancianos creyeron que el Señor los había enviado. Y cuando supieron que el Señor los había visitado, que había visto sus sufrimientos y había decidido rescatarlos, se regocijaron, se arrodillaron y lo adoraron. ");
INSERT INTO spaonbv_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Después de haber hablado con los ancianos, Moisés y Aarón fueron a ver al faraón, y le dijeron: ―Le traemos un mensaje de parte del Señor, Dios de Israel. Así dice el Señor: “Deja salir a mi pueblo, porque quiero que vayan al desierto a hacerme fiesta y a adorarme”. ");
INSERT INTO spaonbv_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","―¿Conque esas tenemos? —replicó el faraón—. ¿Quién es el Señor para que yo tenga que obedecerlo y dejarlos ir? Yo no conozco al tal Señor, así que no dejaré salir a Israel. ");
INSERT INTO spaonbv_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Pero Aarón y Moisés insistieron: ―El Dios de los hebreos ha salido a nuestro encuentro, y nos ordenó ir a un lugar en el desierto, que queda a tres días de camino, para ofrecerle sacrificios. Si no obedecemos al Señor nuestro Dios, nos podrá castigar por medio de las pestes o la espada. ");
INSERT INTO spaonbv_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","5","―¿Quiénes se creen ustedes? —gritó el faraón—. ¿Por qué distraen al pueblo de su trabajo? ¡Vuelvan a sus tareas! ");
INSERT INTO spaonbv_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Ese mismo día, el faraón les envió la siguiente orden a sus cuadrilleros y a los capataces que tenían que vigilar el trabajo del pueblo de Israel: ");
INSERT INTO spaonbv_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","8","«No se entregará más paja a los hebreos para la elaboración de los ladrillos. Sin embargo, no se les disminuirá en un solo ladrillo su cuota de producción, porque parecen no tener suficiente trabajo. De otro modo no hablarían de ir al desierto a ofrecerle sacrificio a su Dios. ");
INSERT INTO spaonbv_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","¡Cárguenlos de trabajo y háganlos sudar! ¡Eso les enseñará a no prestar oídos a las mentiras de Moisés y de Aarón!». ");
INSERT INTO spaonbv_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","11","Los cuadrilleros y los capataces le informaron al pueblo: ―El faraón ha dado órdenes de que no les proporcionemos la paja para los ladrillos. Deben ir ustedes mismos a buscarla a donde puedan. Y deberán producir tantos ladrillos como antes. ");
INSERT INTO spaonbv_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Y el pueblo se dispersó en busca de paja. ");
INSERT INTO spaonbv_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Los cuadrilleros fueron muy crueles: «Completen la misma cuota de producción de antes» les decían. ");
INSERT INTO spaonbv_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Y azotaban a los capataces israelitas que habían nombrado, y les decían: «Ni ayer ni anteayer cumplieron con la cuota diaria de producción de ladrillos, ¿por qué?». ");
INSERT INTO spaonbv_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Los capataces fueron a quejarse al faraón, y le rogaron: ―¡No nos traten así! ");
INSERT INTO spaonbv_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","No se nos proporciona la paja que necesitamos y se nos exige que hagamos la misma cantidad de ladrillos que antes. Se nos está azotando por algo que no es culpa nuestra. Es culpa de los cuadrilleros que nos hacen demandas tan irrazonables. ");
INSERT INTO spaonbv_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Pero el faraón replicó: ―Ustedes no tienen suficiente trabajo; de lo contrario no estarían diciendo: “Vamos a ofrecerle sacrificios al Señor”. ");
INSERT INTO spaonbv_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","¡Vuelvan al trabajo! No se les dará paja, y tendrán que cumplir con la misma cuota de ladrillos. ");
INSERT INTO spaonbv_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Los capataces vieron que estaban en una situación realmente difícil. ");
INSERT INTO spaonbv_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Al salir de la entrevista con el faraón, encontraron a Moisés y a Aarón, que los esperaban afuera del palacio, ");
INSERT INTO spaonbv_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","y les dijeron: «Que Dios los juzgue por habernos hecho odiosos al faraón y a su pueblo. Ustedes le han dado una excusa para que nos mate». ");
INSERT INTO spaonbv_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Entonces Moisés oró al Señor, y le dijo: ―Señor, ¿cómo puedes maltratar a tu pueblo de esta manera? ¿Por qué me enviaste, si ibas a hacerles esto? ");
INSERT INTO spaonbv_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Desde que le di tu mensaje al faraón, los ha tratado en forma aún más brutal, y tú no has librado a tu pueblo. ");
INSERT INTO spaonbv_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","―Ahora verás lo que le voy a hacer al faraón —le dijo el Señor—. Sólo por la fuerza dejará él salir a mi pueblo. Ah, pero no sólo los dejará salir, sino que los echará de la tierra de Egipto. ");
INSERT INTO spaonbv_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","3","Yo soy el Señor, el Dios Todopoderoso que les apareció a Abraham, a Isaac y a Jacob, aunque a ellos no me revelé con mi nombre, que es “YO SOY”. ");
INSERT INTO spaonbv_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Con ellos establecí un pacto solemne en el que les prometí que les daría a ellos y a sus descendientes la tierra de Canaán, que era el lugar donde vivían como extranjeros. ");
INSERT INTO spaonbv_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","He oído ahora el clamor del pueblo de Israel, que sufre como esclavo de los egipcios, y me acuerdo de mi promesa. ");
INSERT INTO spaonbv_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Por lo tanto, diles a los descendientes de Israel que usaré todo mi poder y realizaré grandes milagros, para sacarlos de la esclavitud y hacerlos libres. ");
INSERT INTO spaonbv_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Yo los aceptaré como pueblo mío, y seré el Dios de ellos. Y ellos sabrán que yo soy el Señor su Dios, que los he rescatado de los egipcios. ");
INSERT INTO spaonbv_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","9","Yo los introduciré en la tierra que prometí darles a Abraham, a Isaac y a Jacob. Sí, yo les daré a ustedes esa tierra. Moisés le contó al pueblo lo que Dios había dicho; pero ellos estaban muy contrariados por las trágicas consecuencias de lo que les había dicho anteriormente, y no quisieron oírlo. ");
INSERT INTO spaonbv_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Nuevamente el Señor le habló a Moisés y le dijo: ");
INSERT INTO spaonbv_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","―Vuelve al faraón y dile que tiene que dejar salir al pueblo de Israel. ");
INSERT INTO spaonbv_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","―Pero, si ni siquiera mi propio pueblo quiso oírme, ¿cómo puedo esperar que el faraón me oiga? Yo no tengo el poder de convicción —objetó Moisés. ");
INSERT INTO spaonbv_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Entonces el Señor les ordenó a Moisés y a Aarón que regresaran al pueblo de Israel, y se presentaran delante del faraón para exigirle que permitiera la salida del pueblo. ");
INSERT INTO spaonbv_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Estos son los nombres de los jefes de los clanes de las diversas tribus de Israel: Los hijos de Rubén, hijo mayor de Israel: Janoc, Falú, Jezrón y Carmí. ");
INSERT INTO spaonbv_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Los jefes de los clanes de la tribu de Simeón: Jemuel, Jamín, Oad, Jaquín, Zojar y Saúl, cuya madre era una cananea. ");
INSERT INTO spaonbv_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Estos son los nombres de los jefes de los clanes de la tribu de Leví, por orden de edad: Guersón, Coat y Merari. Leví vivió ciento treinta y siete años. ");
INSERT INTO spaonbv_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Los hijos de Guersón fueron: Libní y Simí, con sus respectivos clanes. ");
INSERT INTO spaonbv_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Los hijos de Coat: Amirán, Izar, Hebrón y Uziel. Coat vivió ciento treinta y tres años. ");
INSERT INTO spaonbv_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Los hijos de Merari: Majlí y Musí. Estas, pues, son las familias de los levitas, según el orden de sus edades. ");
INSERT INTO spaonbv_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amirán se casó con su tía Jocabed. De esta unión nacieron Aarón y Moisés. Amirán vivió hasta los ciento treinta y siete años. ");
INSERT INTO spaonbv_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Los hijos de Izar fueron: Coré, Néfeg y Zicrí. ");
INSERT INTO spaonbv_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Los hijos de Uziel: Misael, Elzafán y Sitri. ");
INSERT INTO spaonbv_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aarón se casó con Elisabet, la hija de Aminadab y hermana de Naasón. Tuvieron los siguientes hijos: Nadab, Abiú, Eleazar e Itamar. ");
INSERT INTO spaonbv_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Los hijos de Coré fueron: Asir, Elcaná y Abiasaf. Estas fueron las familias del clan de Coré. ");
INSERT INTO spaonbv_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eleazar hijo de Aarón se casó con una de las hijas de Futiel, y uno de sus hijos fue Finés. Estos son los nombres de todos los jefes de clanes de los levitas, y de las familias que había dentro de los clanes. ");
INSERT INTO spaonbv_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Aarón y Moisés, incluidos en esta lista, son los mismos a quienes el Señor les dijo: «Saquen al pueblo de Israel de la tierra de Egipto», ");
INSERT INTO spaonbv_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","y que fueron a ver al faraón para pedirle que dejara salir al pueblo. ");
INSERT INTO spaonbv_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","29","Este Moisés es el mismo a quien el Señor le había dicho: «Yo soy el Señor, anda y dale al faraón el mensaje que te he dado». ");
INSERT INTO spaonbv_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Este es aquel Moisés que le respondió al Señor: «Yo no puedo hacerlo. Yo no tengo el poder de convicción. ¡El faraón no me oirá!». ");
INSERT INTO spaonbv_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Por eso, el Señor le dijo a Moisés: «Mira, cuando te presentes ante el faraón será como si yo mismo estuviera allí, y tu hermano Aarón será como tu profeta, el que habla en lugar tuyo. ");
INSERT INTO spaonbv_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Dile a Aarón todo lo que yo te diga, para que él se lo repita al faraón. Así que será Aarón el que le pedirá al faraón que deje salir de Egipto a mi pueblo Israel. ");
INSERT INTO spaonbv_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Pero yo haré que el faraón se niegue a hacerlo. Yo entonces multiplicaré mis milagros en la tierra de Egipto. ");
INSERT INTO spaonbv_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Aun así el faraón no los oirá; por lo que traeré sobre Egipto un desastre final de grandes proporciones, y luego sacaré a mi pueblo de esta tierra. ");
INSERT INTO spaonbv_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Cuando les muestre mi poder y los obligue a dejar salir a mi pueblo, los egipcios comprenderán que yo soy el Señor». ");
INSERT INTO spaonbv_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Moisés y Aarón hicieron lo que el Señor les había ordenado. ");
INSERT INTO spaonbv_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Cuando se presentaron ante el faraón, Moisés tenía ochenta años y Aarón, ochenta y tres. ");
INSERT INTO spaonbv_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","El Señor les dijo a Moisés y a Aarón: ");
INSERT INTO spaonbv_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","«El faraón les exigirá un milagro que demuestre que yo los he enviado. Cuando lo haga, Aarón arrojará al suelo la vara, y esta se convertirá en serpiente». ");
INSERT INTO spaonbv_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Entonces Moisés y Aarón fueron a ver al faraón, y realizaron el milagro de la manera que el Señor les había dicho: Aarón arrojó al suelo la vara ante el faraón, y esta se convirtió en serpiente. ");
INSERT INTO spaonbv_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Pero el faraón llamó a sus encantadores, los magos de Egipto, y ellos hicieron lo mismo mediante sus artes mágicas. ");
INSERT INTO spaonbv_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Pero la serpiente de Aarón se tragó a todas las serpientes de ellos. ");
INSERT INTO spaonbv_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","El corazón del faraón permaneció duro y obstinado y no quiso oír, tal como el Señor lo había advertido. ");
INSERT INTO spaonbv_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","El Señor le dijo a Moisés que el faraón era terco y se empeñaría en no dejar salir de Egipto al pueblo de Israel. ");
INSERT INTO spaonbv_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Pero que, a pesar de eso, debería regresar por la mañana, cuando el faraón salía a bañarse, y esperarlo a las orillas del Nilo. Y le recordó que debía llevar la vara que se había convertido en serpiente. ");
INSERT INTO spaonbv_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Además, le dijo que cuando estuviera frente al faraón, le dijera: «El Señor, el Dios de los hebreos, me ha dicho que vuelva a pedirte que dejes que mi pueblo salga a adorarlo en el desierto. Como no quisiste oír antes, ");
INSERT INTO spaonbv_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","ahora el Señor te dice lo siguiente: “Vas a saber que yo soy el Señor, porque le he dado orden a Moisés de tocar el agua del Nilo con su vara, y el río se transformará en sangre. ");
INSERT INTO spaonbv_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Morirán los peces, y el río apestará, de tal modo que los egipcios no querrán beber su agua”». ");
INSERT INTO spaonbv_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","El Señor ordenó a Moisés: «Dile a Aarón que dirija su vara hacia las aguas de Egipto, para que todos sus ríos, arroyos, estanques y los depósitos de agua, y aun el agua de las casas, se les convierta en sangre». ");
INSERT INTO spaonbv_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Mientras el faraón y todos sus funcionarios miraban, Aarón tocó con su vara la superficie del Nilo, y el agua se convirtió en sangre. ");
INSERT INTO spaonbv_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Los peces murieron, y el agua se contaminó, de tal modo que los egipcios tuvieron asco de beberla, y hubo sangre en todo Egipto. ");
INSERT INTO spaonbv_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Pero los magos usaron sus artes secretas y también pudieron convertir el agua en sangre. Por lo tanto, el faraón persistió en su terquedad y no quiso escuchar a Moisés y a Aarón, tal como el Señor lo había advertido. ");
INSERT INTO spaonbv_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","El faraón regresó a su palacio, como si nada importante hubiera acontecido. ");
INSERT INTO spaonbv_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Entonces los egipcios cavaron pozos a lo largo del río para conseguir agua, porque no podían beber el agua del río. ");
INSERT INTO spaonbv_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Después de que el Señor golpeó las aguas del Nilo, pasaron siete días. ");
INSERT INTO spaonbv_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","El Señor le dijo a Moisés: «Preséntate nuevamente ante el faraón y dile que yo, el Señor, le ordeno que deje que mi pueblo vaya y me adore. ");
INSERT INTO spaonbv_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Que si se niega, enviaré una plaga de ranas a toda la tierra, de un rincón a otro del país. ");
INSERT INTO spaonbv_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","4","El río Nilo se llenará de ranas que entrarán aun a sus cuartos y estarán sobre sus camas. Cada casa de Egipto se llenará de ranas, de modo que hasta se meterán en los hornos y en donde amasan la harina para el pan. ¡Tantas serán las ranas que hasta se treparán sobre sus hombros, y sobre sus funcionarios y sobre toda la gente!». ");
INSERT INTO spaonbv_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","El Señor le dijo a Moisés: «Dile a Aarón que dirija la vara hacia los ríos, arroyos y fuentes de Egipto, para que haya ranas por todas partes». ");
INSERT INTO spaonbv_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Aarón lo hizo, y las ranas cubrieron la nación. ");
INSERT INTO spaonbv_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Pero los magos, usando sus artes secretas, también hicieron salir ranas por todo Egipto. ");
INSERT INTO spaonbv_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","El faraón llamó a Moisés y a Aarón y les dijo: ―Rueguen al Señor que quite las ranas, y yo dejaré que su pueblo salga a ofrecerle sacrificio. ");
INSERT INTO spaonbv_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","―Muy bien —le dijo Moisés—. Solamente dime cuándo quieres que ore al Señor por ti, por tus funcionarios y por todo el pueblo. Al hacerlo, las ranas se irán de sus casas, y sólo estarán en el río. ");
INSERT INTO spaonbv_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","―Mañana mismo —respondió el faraón. ―De acuerdo —dijo Moisés—. Será como has dicho. Así sabrás que no hay nadie como el Señor nuestro Dios. ");
INSERT INTO spaonbv_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Te aseguro que las ranas ya no serán una molestia, pues saldrán de tu casa, de las casas de tus oficiales y de las de todo el pueblo, y sólo quedarán las que están en el río. ");
INSERT INTO spaonbv_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Moisés y Aarón salieron de la presencia del faraón, y Moisés rogó al Señor que quitara las ranas que había enviado. ");
INSERT INTO spaonbv_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Y el Señor hizo lo que Moisés le pidió. Entonces murieron todas las ranas que estaban en las casas, en las granjas y en el campo. ");
INSERT INTO spaonbv_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","La gente recogía todas las ranas muertas y las amontonaba. ¡En todo el país se sentía la peste de las ranas muertas! ");
INSERT INTO spaonbv_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Pero cuando el faraón vio que se habían acabado las ranas, endureció su corazón y, tal como el Señor lo había advertido, no hizo caso a la petición que le habían hecho Moisés y Aarón. ");
INSERT INTO spaonbv_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","El Señor le dijo a Moisés: «Dile a Aarón que golpee el polvo con su vara, para que todo el país se llene de mosquitos». ");
INSERT INTO spaonbv_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Moisés y Aarón hicieron lo que Dios les mandó. Tan pronto Aarón tocó el suelo con su vara, los mosquitos salieron de la tierra y picaban a hombres y animales. ¡Todo el polvo que había en Egipto se convirtió en mosquitos! ");
INSERT INTO spaonbv_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Los magos trataron de hacer lo mismo con sus artes secretas, pero esta vez fracasaron. Los mosquitos seguían picando a hombres y animales. ");
INSERT INTO spaonbv_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","«¡No hay la menor duda de que esto es obra de Dios!», exclamaron ante el faraón. Pero el faraón persistió en su terquedad, y no quiso oírlos, tal como el Señor lo había advertido. ");
INSERT INTO spaonbv_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Luego el Señor le dijo a Moisés: «Levántate temprano, y sal al encuentro del faraón, cuando vaya a bañarse al río, y dile que yo, el Señor, le ordeno que deje que mi pueblo vaya y me adore. ");
INSERT INTO spaonbv_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Que si se niega, enviaré plagas de tábanos por todo Egipto, de modo que todas las casas se llenarán de ellos. ¡Hasta el piso se cubrirá de tábanos! ");
INSERT INTO spaonbv_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Pero que en la tierra de Gosén, donde viven los israelitas, no habrá tábanos. Que de este modo sabrá que yo soy el Señor, Dios de toda la tierra. ");
INSERT INTO spaonbv_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Que haré distinción entre mi pueblo y su pueblo. Dile que todo esto ocurrirá mañana». ");
INSERT INTO spaonbv_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Y el Señor hizo lo que había dicho, de modo que hubo una terrible plaga de tábanos en el palacio del faraón y en la casa de cada egipcio. ");
INSERT INTO spaonbv_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","El faraón inmediatamente llamó a Moisés y a Aarón y les dijo: ―Está bien, vayan y ofrézcanle sacrificios a su Dios, pero háganlo aquí en Egipto. No vayan al desierto. ");
INSERT INTO spaonbv_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Pero Moisés replicó: ―¡Imposible! Los sacrificios al Señor nuestro Dios no son aprobados por los egipcios, y si lo hacemos aquí, delante de sus ojos, nos apedrearán. ");
INSERT INTO spaonbv_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Tenemos que ir al desierto, a tres días de camino, a ofrecer allí nuestros sacrificios al Señor nuestro Dios, tal como él nos lo ha ordenado. ");
INSERT INTO spaonbv_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","―Está bien, vayan —respondió el faraón—, pero no se vayan demasiado lejos. Ahora, dense prisa y oren por mí. ");
INSERT INTO spaonbv_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","―Sí —dijo Moisés—, le pediré al Señor que haga desaparecer los tábanos, pero te advierto que no debes engañarnos más prometiendo que el pueblo saldrá y cambiando luego de parecer. ");
INSERT INTO spaonbv_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Moisés salió de la presencia del faraón y le pidió a Dios que librara al país de los tábanos. ");
INSERT INTO spaonbv_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","32","El Señor hizo lo que Moisés le pidió, de modo que los tábanos desaparecieron por completo de la casa del faraón, y de las casas de sus funcionarios y del pueblo en general. Pero el faraón endureció su corazón nuevamente y no permitió que el pueblo fuera a adorar al Señor. ");
INSERT INTO spaonbv_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","El Señor le dijo a Moisés que fuera a ver al faraón y le dijera: «El Señor, Dios de los hebreos, te exige que dejes salir al pueblo para que hagan su sacrificio. ");
INSERT INTO spaonbv_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Si te niegas a dejarlos ir, ");
INSERT INTO spaonbv_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","el Señor hará que se desate una plaga mortal que destruirá los caballos, los burros, los camellos, los rebaños de ovejas, y las manadas de vacas. ");
INSERT INTO spaonbv_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Pero la plaga afectará solamente a los animales de los egipcios. Ninguno de los rebaños de los israelitas será tocado». ");
INSERT INTO spaonbv_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","El Señor anunció que la plaga comenzaría a la mañana siguiente, ");
INSERT INTO spaonbv_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","y así fue. A la mañana siguiente, todos los animales de los egipcios comenzaron a morirse, pero ni uno solo de los animales de los israelitas se enfermó. ");
INSERT INTO spaonbv_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","El faraón envió a ver si era cierto que los animales de los israelitas no morían, pero aunque comprobó que así era, permaneció firme, y no dejó salir al pueblo. ");
INSERT INTO spaonbv_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","El Señor les dijo a Moisés y a Aarón: «Tomen puñados de ceniza, y que Moisés la arroje hacia el cielo delante del faraón. ");
INSERT INTO spaonbv_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Apenas lo haga, la ceniza se convertirá en un polvillo fino. Ese polvillo se esparcirá por todo Egipto, y cuando caiga sobre la gente y los animales les producirá úlceras y tumores». ");
INSERT INTO spaonbv_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Entonces, Moisés y Aarón tomaron ceniza y salieron al encuentro del faraón. Mientras este miraba, Moisés lanzó la ceniza hacia el cielo, y la ceniza, al caer sobre la gente y los animales, les produjo úlceras llenas de pus. En todo el país de Egipto ocurrió lo mismo. ");
INSERT INTO spaonbv_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Los magos no pudieron presentarse delante de Moisés, pues también ellos, como toda la gente, tenían úlceras llenas de pus. ");
INSERT INTO spaonbv_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Pero el Señor endureció el corazón del faraón, quien persistió en su soberbia y se negó a oír, tal como ya el Señor lo había advertido. ");
INSERT INTO spaonbv_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","El Señor le dijo a Moisés que se levantara temprano para que fuera a ver al faraón y le dijera: «El Señor, Dios de los hebreos te ordena que dejes salir a su pueblo para que vaya a adorarlo. ");
INSERT INTO spaonbv_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Si no obedeces, entonces él enviará una plaga que realmente vendrá sobre ti, tus siervos y toda la gente de Egipto. Dile que le voy a demostrar que no hay otro Dios en toda la tierra. ");
INSERT INTO spaonbv_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Que si yo quisiera, hubiera podido usar todo mi poder para mandar una peste que acabara con todos los egipcios de una vez, ");
INSERT INTO spaonbv_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","pero no lo hice, porque quiero que todos sepan cuán poderoso soy, y para que mi nombre se mencione en todo el país. ");
INSERT INTO spaonbv_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Dile que si es que se cree muy grande como para atreverse a desafiar mi poder y a negarle a mi pueblo el permiso para salir. ");
INSERT INTO spaonbv_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","También dile que mañana, a esta hora, enviaré una tormenta de granizo que azotará a toda la nación como jamás ha sido azotada. ");
INSERT INTO spaonbv_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Por eso, deben apresurarse a meterse en sus casas y a recoger los animales que están en el campo, ya que el granizo caerá sobre toda persona y animal que esté al aire libre, y los matará». ");
INSERT INTO spaonbv_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Algunos egipcios, aterrorizados por esta amenaza, recogieron sus ganados y sus esclavos de los campos; ");
INSERT INTO spaonbv_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","pero otros no dieron importancia a la palabra del Señor, y los dejaron en el campo, a merced de la tormenta. ");
INSERT INTO spaonbv_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Entonces el Señor le dijo a Moisés: «Levanta tu mano hacia el cielo, y haz que descienda granizo sobre todo Egipto, sobre personas, animales y vegetación». ");
INSERT INTO spaonbv_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Moisés extendió la mano, y el Señor envió truenos, rayos y granizo. ");
INSERT INTO spaonbv_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","La escena fue tan horrible que no se puede describir. Jamás en la historia de Egipto había habido una tormenta similar. ");
INSERT INTO spaonbv_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Todo Egipto quedó en ruinas. Todo cuanto había en los campos, hombres y animales por igual, murieron, y los árboles quedaron destrozados y las cosechas arruinadas. ");
INSERT INTO spaonbv_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","El único lugar de Egipto en que no hubo granizo aquel día fue en Gosén, donde vivía el pueblo de Israel. ");
INSERT INTO spaonbv_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","El faraón mandó a llamar a Moisés y a Aarón, y les dijo: ―Ahora reconozco mi falta. Yo y mi pueblo hemos actuado mal. ");
INSERT INTO spaonbv_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Rueguen al Señor que termine este terrible azote, pues ya hemos tenido suficientes truenos y granizo, y yo dejaré salir a su pueblo al instante. ");
INSERT INTO spaonbv_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","―Muy bien —respondió Moisés—. Tan pronto como yo haya salido de la ciudad, levantaré las manos hacia el Señor, y los truenos y el granizo se detendrán. Esto te probará que el Señor reina en la tierra. ");
INSERT INTO spaonbv_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Pero yo sé que ni tú ni tus funcionarios están todavía dispuestos a obedecer a Dios, el Señor. ");
INSERT INTO spaonbv_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Todo el lino y la cebada se perdieron, porque la cebada estaba madura y el lino estaba en flor; ");
INSERT INTO spaonbv_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","pero el trigo y el centeno no fueron destruidos, porque aún no habían brotado de la tierra. ");
INSERT INTO spaonbv_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Moisés salió de la presencia del faraón, y ya fuera de la ciudad levantó las manos hacia el Señor. Al instante, los truenos y el granizo se detuvieron, y cesó la lluvia. ");
INSERT INTO spaonbv_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Cuando el faraón y sus funcionarios vieron esto, pecaron aún más, pues no cumplieron lo que habían prometido. ");
INSERT INTO spaonbv_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","El faraón negó el permiso para que el pueblo saliera, tal como el Señor le había advertido a Moisés. ");
INSERT INTO spaonbv_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","El Señor le dijo a Moisés: «Vuelve a hablar con el faraón. Pero yo lo he endurecido a él y a sus funcionarios, a fin de hacer nuevos milagros y demostrar mi poder. ");
INSERT INTO spaonbv_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Un día podrán ustedes contarles a sus hijos y a sus nietos las cosas increíbles que estoy haciendo en Egipto. Les contarán cómo destruí a los egipcios, y cómo demostré que yo soy el Señor». ");
INSERT INTO spaonbv_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Moisés y Aarón pidieron otra audiencia al faraón y le dijeron: ―El Señor, Dios de los hebreos, pregunta: “¿Hasta cuando te negarás a someterte a mí? Deja que mi pueblo vaya y me adore. ");
INSERT INTO spaonbv_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","5","Si te niegas, mañana cubriré la nación con una plaga de langostas, tan grande, que no podrás ver el suelo, y ellas acabarán de destruir todo lo que escapó del granizo. ");
INSERT INTO spaonbv_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Estarán en tu palacio, en las casas de tus funcionarios y en todas las casas de Egipto. Jamás en la historia de Egipto ha habido una plaga como esta”. Tan pronto acabó de hablar, Moisés dio media vuelta y se retiró. ");
INSERT INTO spaonbv_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Los funcionarios se presentaron delante del faraón, y le preguntaron: ―¿Vas a permitir que seamos destruidos completamente? ¿No sabes que todo Egipto está en ruinas? Deja que ese pueblo vaya y adore al Señor su Dios. ");
INSERT INTO spaonbv_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Entonces, el faraón mandó a llamar a Moisés y a Aarón, y les dijo: ―Bien, salgan y adoren al Señor su Dios. Pero necesito que me informen cuántos irán. ");
INSERT INTO spaonbv_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","―Iremos con nuestros niños y nuestros ancianos, nuestras ovejas y nuestras vacas —respondió Moisés—. Llevaremos todo lo nuestro, porque iremos en santa peregrinación. ");
INSERT INTO spaonbv_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","―¡Que el Señor los ayude! —respondió el faraón—. ¿Acaso creen que les dejaré llevar a los pequeños? ¡Ya veo lo que están planeando! ");
INSERT INTO spaonbv_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","¡Jamás accederé a esto! Si quieren ir a adorar al Señor, entonces vayan solamente ustedes los hombres. Luego echaron de la presencia del faraón a Moisés y a Aarón. ");
INSERT INTO spaonbv_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Entonces el Señor le dijo a Moisés: «Levanta tu mano sobre la tierra de Egipto, para hacer que vengan langostas a cubrir la tierra y a comer todo lo que quedó después del granizo». ");
INSERT INTO spaonbv_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Moisés levantó la vara y el Señor hizo que un viento oriental soplara todo aquel día y toda la noche. A la mañana siguiente, el viento oriental había traído las langostas. ");
INSERT INTO spaonbv_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Y las langostas cubrieron a Egipto completamente. Era la peor plaga de langostas en la historia de Egipto. ¡Nunca habrá otra igual! ");
INSERT INTO spaonbv_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Las langostas cubrían la tierra y no permitían que se viera el sol, de modo que la tierra estaba en tinieblas. Las langostas se comieron toda la vegetación que había escapado del granizo. No quedó nada verde, ni árbol ni planta, en todo Egipto. ");
INSERT INTO spaonbv_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","El faraón mandó a llamar urgentemente a Moisés y a Aarón, y les dijo: «Confieso que he pecado contra el Señor su Dios, y contra ustedes. ");
INSERT INTO spaonbv_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Perdonen mi pecado por última vez, y rueguen al Señor su Dios que aleje de mí esta plaga mortal. Prometo que no les negaré el permiso de salir a adorarlo». ");
INSERT INTO spaonbv_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Entonces Moisés salió de la presencia del faraón y oró al Señor. ");
INSERT INTO spaonbv_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","El Señor envió un viento fuerte de occidente que hizo que las langostas fueran a dar al Mar Rojo, de modo que no quedó una sola langosta en Egipto. ");
INSERT INTO spaonbv_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Pero el Señor endureció el corazón del faraón, y este no dejó salir al pueblo. ");
INSERT INTO spaonbv_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","El Señor le dijo a Moisés: «Levanta tus manos al cielo, para que todo Egipto quede cubierto de tinieblas. ¡Será tal la oscuridad que los egipcios andarán a tientas!». ");
INSERT INTO spaonbv_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Así lo hizo Moisés, y espesas tinieblas cubrieron la tierra. Durante tres días, ");
INSERT INTO spaonbv_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","los egipcios no pudieron verse unos a otros, ni salir de sus casas. En la región habitada por el pueblo de Israel, en cambio, había luz como de costumbre. ");
INSERT INTO spaonbv_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","El faraón llamó a Moisés y le dijo: ―Vayan y adoren al Señor, pero dejen sus ovejas y sus vacas aquí. Pueden llevarse a sus hijos con ustedes. ");
INSERT INTO spaonbv_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","―No —respondió Moisés—, debemos llevar nuestras ovejas y vacas para presentar ofrendas y holocaustos a nuestro Dios. ");
INSERT INTO spaonbv_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Ni una pezuña se quedará aquí, porque debemos llevar sacrificios al Señor nuestro Dios, y sólo cuando lleguemos allá, él nos dirá cuáles animales tendremos que ofrecerle. ");
INSERT INTO spaonbv_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Pero el Señor endureció el corazón del faraón, y este no los dejó salir. ");
INSERT INTO spaonbv_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","―¡Sal de aquí y no vuelvas a venir a mi presencia! ¡El día que lo hagas, morirás! —le gritó el faraón a Moisés. ");
INSERT INTO spaonbv_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","―Muy bien —respondió Moisés—. ¡Nunca más volveré por aquí! ");
INSERT INTO spaonbv_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","El Señor le dijo a Moisés: «Enviaré una plaga más sobre el faraón y su tierra, y después de ella los dejará ir. Es más, él estará ansioso de deshacerse de ustedes y, prácticamente, los arrojará del país. ");
INSERT INTO spaonbv_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Diles a todos los hombres y mujeres de Israel que pidan a sus vecinos egipcios joyas de oro y plata». ");
INSERT INTO spaonbv_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Dios hizo que los egipcios se mostraran favorables hacia el pueblo de Israel. Además, Moisés era un hombre muy importante en Egipto, y era temido por los funcionarios del faraón y por el pueblo de Egipto. ");
INSERT INTO spaonbv_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Moisés, pues, le dijo al faraón: «El Señor dice: “A medianoche pasaré por Egipto, ");
INSERT INTO spaonbv_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","y morirán todos los hijos mayores de todas las familias de Egipto, desde el primogénito del faraón hasta el primogénito de la esclava que trabaja en el molino; y también morirá toda primera cría de animal. ");
INSERT INTO spaonbv_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","El llanto por la muerte de los primogénitos resonará por todo Egipto. Jamás antes ha habido una angustia similar, y jamás se volverá a ver nada semejante. ");
INSERT INTO spaonbv_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Pero ni siquiera un perro gemirá por la muerte de uno de los nuestros, pues ni personas ni animales morirán entre el pueblo de Israel. Así sabrán ustedes que el Señor hace distinción entre egipcios e israelitas. ");
INSERT INTO spaonbv_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Todos tus funcionarios vendrán corriendo a mí, e inclinándose me suplicarán que me vaya con todo el pueblo. Entonces saldré y me llevaré a todo el pueblo de Israel”». Luego, Moisés salió muy enojado de la presencia del faraón. ");
INSERT INTO spaonbv_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","El Señor le había dicho a Moisés: «El faraón no oirá, y esto me dará la oportunidad de hacer portentosos milagros para demostrar mi poder». ");
INSERT INTO spaonbv_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Por eso, aunque Moisés y Aarón hicieron estos milagros delante del faraón, el Señor le endureció el corazón para que no dejara salir al pueblo. ");
INSERT INTO spaonbv_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","El Señor les dijo a Moisés y a Aarón: ");
INSERT INTO spaonbv_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","«De ahora en adelante, este mes será el primero y el más importante del año judío. ");
INSERT INTO spaonbv_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","4","Díganles a los israelitas que cada año, en el décimo día de este mes, cada familia tomará un cordero. Si la familia es pequeña, compartirá el cordero con otra familia pequeña del vecindario; el hacer o no esto dependerá del tamaño de la familia. ");
INSERT INTO spaonbv_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Este animal, ya sea cordero o cabrito, será un macho de un año y sin ningún defecto. ");
INSERT INTO spaonbv_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","»El animal deberá ser cuidado hasta el día catorce del mes. Ese día, al atardecer, cada familia de Israel sacrificará su cordero o cabrito. ");
INSERT INTO spaonbv_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Luego tomarán un poco de sangre del animal y la colocarán en los dos postes y en el travesaño de la puerta de la casa en que se han de comer al animal. ");
INSERT INTO spaonbv_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Asarán la carne al fuego y la comerán esa noche con panes sin levadura y hierbas amargas. ");
INSERT INTO spaonbv_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Nada crudo ni cocido comerán del animal, sino asado, incluso la cabeza, las piernas, el corazón y el hígado. ");
INSERT INTO spaonbv_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","No comerán nada de esa carne el día siguiente, y si algo sobra esa noche, deberá ser quemado. ");
INSERT INTO spaonbv_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","»Comerán con la ropa y el calzado puestos, como si estuvieran listos para emprender un largo viaje, y con el bordón en la mano. Comerán apresuradamente. Esta fiesta es la Pascua en honor al Señor. ");
INSERT INTO spaonbv_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","»Esa noche yo pasaré por la tierra de Egipto, y daré muerte a todos los primogénitos de los hombres y de los animales de Egipto, y así ejecutaré mi juicio sobre todos los dioses de Egipto; porque yo soy el Señor. ");
INSERT INTO spaonbv_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","La sangre que ustedes colocarán en los postes y en las puertas será prueba de que me han obedecido; y cuando vea la sangre, pasaré de largo y no destruiré a los primogénitos de ustedes, cuando castigue a Egipto. ");
INSERT INTO spaonbv_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","»Este día lo celebrarán cada año (como una ley permanente), para recordar esta noche. ");
INSERT INTO spaonbv_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","La celebración durará siete días. En todo ese tiempo sólo podrán comer pan sin levadura. Cualquiera que desobedezca esta norma durante los siete días que dura la celebración, será expulsado de la comunidad de Israel. ");
INSERT INTO spaonbv_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","El primer día de la celebración, y el séptimo día, habrá reunión sagrada para toda la congregación, y no harán trabajos de ningún tipo en esos días, salvo la preparación de alimentos. ");
INSERT INTO spaonbv_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","»Esta celebración anual de panes sin levadura hará que siempre recuerden este día como el día en que yo los saqué de la tierra de Egipto. Será obligatorio observar esta festividad anualmente de ahora en adelante, de generación en generación. ");
INSERT INTO spaonbv_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Desde la tarde del día catorce del mes hasta la tarde del día veintiuno sólo podrán comer panes sin levadura. ");
INSERT INTO spaonbv_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","En esos siete días no debe haber rastro de levadura en sus hogares. Durante ese tiempo, cualquiera que coma algo con levadura será expulsado de la comunidad de Israel. Esta misma regla se aplica a los extranjeros que vivan entre ustedes y a todos los que hayan nacido en el país. ");
INSERT INTO spaonbv_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Repito, durante esos días no deben comer ninguna cosa que contenga levadura; sólo comerán panes sin levadura». ");
INSERT INTO spaonbv_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Moisés convocó a todos los ancianos de Israel y les dijo: «Vayan y tomen corderos del rebaño, uno por cada familia, según el número de personas que la componen; y maten el cordero, para que celebren la Pascua. ");
INSERT INTO spaonbv_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Recojan la sangre del cordero en una vasija, tomen una rama de hisopo, mójenla en la sangre del cordero y unten la sangre en los postes de la puerta y el travesaño. ¡Que nadie salga de su casa en toda la noche! ");
INSERT INTO spaonbv_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","El Señor pasará por Egipto y dará muerte a los egipcios; pero cuando vea la sangre sobre el travesaño de la puerta y sobre los dos postes, pasará de largo y no permitirá que el destructor entre a matar a sus hijos. ");
INSERT INTO spaonbv_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Recuerden: esta es una ley permanente para ustedes y para sus descendientes. ");
INSERT INTO spaonbv_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Cuando entren en la tierra que el Señor les dará, como ha prometido, y estén celebrando la Pascua, ");
INSERT INTO spaonbv_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","y sus hijos les pregunten: “¿Qué significa esto? ¿Qué ceremonia es esta?”, ");
INSERT INTO spaonbv_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","ustedes les responderán: “Es la celebración del paso del Señor, porque pasó de largo por los hogares del pueblo de Israel cuando mató a los egipcios. Pasó de largo por nuestras casas y no entró a destruirnos”». Y todos los israelitas inclinaron la cabeza y adoraron, ");
INSERT INTO spaonbv_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","e hicieron lo que el Señor les había ordenado por medio de Moisés y de Aarón. ");
INSERT INTO spaonbv_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","A medianoche, el Señor dio muerte a los primogénitos de Egipto, desde el hijo mayor del faraón hasta el hijo mayor del cautivo que estaba en el calabozo. Además, dio muerte a toda primera cría de animal. ");
INSERT INTO spaonbv_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","El faraón, sus funcionarios y todo el pueblo de Egipto se levantaron en la noche. Y hubo amargo llanto en todo Egipto, porque no había casa donde no hubiera un muerto. ");
INSERT INTO spaonbv_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","El faraón llamó a Moisés y a Aarón durante la noche y les dijo: «Salgan, por favor, de en medio de mi pueblo; vayan y sirvan a su Dios como querían. ");
INSERT INTO spaonbv_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Tomen sus vacas y sus ovejas, y váyanse. Pues para mí será un alivio que se vayan». ");
INSERT INTO spaonbv_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Y los egipcios pedían a los israelitas que se fueran lo antes posible. Les decían: «Si no se van pronto, todos moriremos». ");
INSERT INTO spaonbv_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Los israelitas tomaron la masa para el pan sin levadura, la envolvieron en sábanas y la pusieron sobre sus hombros. ");
INSERT INTO spaonbv_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","El pueblo de Israel hizo lo que Dios les había ordenado, y pidieron a los egipcios plata, oro y telas. ");
INSERT INTO spaonbv_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Y el Señor hizo que los egipcios miraran favorablemente a los israelitas y les dieran todo lo que ellos les pedían. Y los egipcios fueron prácticamente despojados de todo lo que poseían. ");
INSERT INTO spaonbv_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Aquella noche, el pueblo de Israel salió de Ramsés y emprendió la marcha hacia Sucot. Eran como seiscientos mil hombres de a pie, sin contar las mujeres ni los niños. ");
INSERT INTO spaonbv_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","También salieron con ellos personas de diferentes nacionalidades, con gran cantidad de vacas y ovejas. ");
INSERT INTO spaonbv_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Cuando se detuvieron a comer, cocieron panes sin levadura. Como no tuvieron tiempo para preparar comida antes de salir de Egipto, tuvieron que usar la masa sin levadura que lograron sacar. ");
INSERT INTO spaonbv_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","41","Los hijos de Jacob y sus descendientes habían vivido en Egipto cuatrocientos treinta años, y el último día del año cuatrocientos treinta todo el pueblo del Señor salió de Egipto. ");
INSERT INTO spaonbv_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Toda esa noche, el Señor estuvo despierto sacando a su pueblo de la tierra de Egipto. Por eso, a los israelitas se les mandó que esa noche de la Pascua la pasaran despiertos, como una manera de honrar al Señor, recordando lo que él hizo por ellos. ");
INSERT INTO spaonbv_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","El Señor les dijo a Moisés y a Aarón: «Estas son las instrucciones acerca de la observancia de la Pascua. Ningún extranjero comerá del animal, ");
INSERT INTO spaonbv_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","pero cualquier esclavo que haya sido comprado podrá comerlo, siempre y cuando haya sido circuncidado. ");
INSERT INTO spaonbv_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Un empleado, o un visitante extranjero, no podrá participar de la Pascua. ");
INSERT INTO spaonbv_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Todos los que coman del animal, deberán comerlo juntos en una casa, y no podrá sacarse ni siquiera un pedazo de carne. Al animal sacrificado tampoco se le podrá quebrar ni un solo hueso. ");
INSERT INTO spaonbv_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Todo el pueblo de Israel deberá celebrar esta fiesta. ");
INSERT INTO spaonbv_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","»En cuanto a los extranjeros, si viven con ustedes y desean celebrar la Pascua, deberán circuncidarse y circuncidar a todos los varones que pertenezcan a su familia. De esa manera serán considerados como parte del pueblo, y por lo tanto, podrán participar de la Pascua. Ninguna persona incircuncisa podrá comer del cordero. ");
INSERT INTO spaonbv_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","»Esta ley se aplicará tanto a los israelitas como a los extranjeros nacidos en Israel». ");
INSERT INTO spaonbv_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Y el pueblo de Israel siguió todas las instrucciones que el Señor les había dado a Moisés y a Aarón. ");
INSERT INTO spaonbv_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Este mismo día el Señor sacó a Israel de Egipto, tribu por tribu, como si fueran un ejército. ");
INSERT INTO spaonbv_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","El Señor le ordenó a Moisés: ");
INSERT INTO spaonbv_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","«El primer hijo de cada familia israelita será consagrado a mí, pues me pertenece. De igual manera las primeras crías de los animales serán para mí». ");
INSERT INTO spaonbv_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Entonces Moisés dijo al pueblo: «Este es un día que deben recordar siempre. Es el día que salieron de la esclavitud de Egipto. Es el día en que el Señor los sacó con milagros portentosos. Recuerden que durante la celebración anual de este suceso no podrán comer pan con levadura. ");
INSERT INTO spaonbv_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","5","Ustedes deberán celebrar esta fiesta en el mes de aviv, pues es en este mes que salieron de Egipto. Cuando el Señor los haya llevado a la tierra del cananeo, del hitita, del amorreo, del heveo y del jebuseo, que es la tierra que prometió dar a nuestros padres, tierra de la que fluye leche y miel, deberán seguir celebrando esta fiesta. ");
INSERT INTO spaonbv_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","7","Durante siete días comerán solamente pan sin levadura. Y el séptimo día se celebrará una gran fiesta en honor al Señor. Durante esos días, no se podrá tener levadura o pan con levadura en ninguna casa israelita. ");
INSERT INTO spaonbv_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","»Durante estos días de celebración cada uno de ustedes deberá explicar a sus hijos el porqué de la fiesta. Les dirán que es una celebración de lo que el Señor hizo por ustedes cuando salieron de Egipto. ");
INSERT INTO spaonbv_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Esta semana de conmemoración anual nos identificará como el pueblo de Dios; será como si él hubiera puesto su sello de propiedad en nuestras manos y en nuestra frente. ");
INSERT INTO spaonbv_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Por lo tanto, celebren el acontecimiento anualmente en el mes de aviv. ");
INSERT INTO spaonbv_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","»Y cuando el Señor los haya hecho entrar en la tierra que prometió a sus antepasados hace tanto tiempo, es decir, la tierra donde viven ahora los cananeos, ");
INSERT INTO spaonbv_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","recuerden que todos los primogénitos varones y todo primer macho de animales pertenecen al Señor, así que deben entregárselos. ");
INSERT INTO spaonbv_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Cuando la primera cría de una burra sea macho, entonces podrá ser rescatado dando a cambio un cordero o un cabrito. Pero si deciden no rescatar al burro, deben quebrarle el cuello. Sin embargo, deben rescatar a sus hijos primogénitos. ");
INSERT INTO spaonbv_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","»En adelante, cuando sus hijos les pregunten: “¿Qué es esto?”, ustedes responderán: “Con grandes milagros el Señor nos sacó de Egipto, para librarnos de nuestra esclavitud. ");
INSERT INTO spaonbv_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","El faraón no quería dejarnos salir, pero el Señor hizo morir a todos los primogénitos varones de Egipto, y también a las primeras crías de los animales. Por eso es que ahora dedicamos todos los varones primogénitos al Señor, pero siempre los rescatamos”. ");
INSERT INTO spaonbv_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Nuevamente les digo que esta celebración los identificará como pueblo de Dios; será como si él hubiera puesto su marca de propiedad sobre la frente de ustedes. Es un recordatorio de que el Señor los sacó de Egipto con gran poder». ");
INSERT INTO spaonbv_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","18","Cuando por fin el faraón dejó salir a los israelitas, Dios no los condujo a través de la tierra de los filisteos, aunque era la ruta más directa desde Egipto a la Tierra prometida. Dios no quería que el pueblo se desalentara al tener que pelear durante todo el camino, y deseara volverse a Egipto. Por eso los condujo por la ruta que está junto al Mar Rojo. ");
INSERT INTO spaonbv_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Moisés tomó también consigo los huesos de José, porque José había hecho que los hijos de Israel le prometieran que llevarían consigo sus huesos cuando salieran de Egipto, pues estaba seguro de que Dios los sacaría. ");
INSERT INTO spaonbv_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Salieron de Sucot y acamparon en Etam, a la entrada del desierto. ");
INSERT INTO spaonbv_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","El Señor los guiaba por medio de una columna de nube durante el día, y por una columna de fuego durante la noche. De esta manera podían viajar de día o de noche. ");
INSERT INTO spaonbv_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","La columna de nube nunca se apartó de ellos durante el día, ni la de fuego durante la noche. ");
INSERT INTO spaonbv_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","El Señor le ordenó a Moisés: ");
INSERT INTO spaonbv_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","«Diles a los israelitas que den la vuelta hacia Pi Ajirot, entre Migdol y el mar, frente a Baal Zefón, y que acampen allí junto al mar. ");
INSERT INTO spaonbv_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","El faraón pensará: “Los israelitas están allí atrapados entre el mar y el desierto”. ");
INSERT INTO spaonbv_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Y una vez más endureceré el corazón del faraón, y él los perseguirá. Lo hago así para mostrarle mi poder al faraón y a todo su ejército. Entonces todos los egipcios sabrán que yo soy el Señor». Los israelitas acamparon donde el Señor les había dicho. ");
INSERT INTO spaonbv_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Cuando el faraón y sus hombres se dieron cuenta de que los israelitas se habían escapado, cambiaron de parecer, y dijeron: «¿Cómo hemos dejado que estos esclavos se nos vayan? ¿Quién va a hacer el trabajo que ellos hacían? ¿Por qué hemos sido tan torpes?». ");
INSERT INTO spaonbv_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Sin pérdida de tiempo, el faraón salió en su carro de guerra para perseguir al pueblo de Israel, ");
INSERT INTO spaonbv_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","seguido por todos los carros de guerra de Egipto, seiscientos en total, y otros más conducidos por los oficiales egipcios. ");
INSERT INTO spaonbv_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Lo hizo porque el Señor le había endurecido el corazón. Así que salió en persecución de Israel, el cual marchaba firme y confiado en la victoria. ");
INSERT INTO spaonbv_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Todo el ejército del faraón, compuesto por caballos, carros de guerra, jinetes y las tropas de a pie, salió en persecución de los israelitas. Y los alcanzaron cerca de Pi Ajirot, frente a Baal Zefón, junto al mar, donde estaban acampando. ");
INSERT INTO spaonbv_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Cuando los israelitas vieron que a lo lejos venía el ejército egipcio en su persecución, tuvieron mucho miedo, y clamaron al Señor en busca de ayuda. ");
INSERT INTO spaonbv_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Luego se volvieron contra Moisés, diciéndole: «¿Nos has traído para que muramos en el desierto? ¿Acaso no había suficientes tumbas en Egipto para enterrarnos? ¿Por qué nos hiciste salir de Egipto? ");
INSERT INTO spaonbv_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Cuando éramos esclavos, ¿no te dijimos que mejor nos dejaras tranquilos, que era mucho mejor ser esclavos de los egipcios que morir en el desierto?». ");
INSERT INTO spaonbv_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Pero Moisés le dijo al pueblo: «No teman, quédense donde están y observen la forma maravillosa en que el Señor los salvará en este día. Los egipcios que hoy ven, no los volverán a ver nunca más. ");
INSERT INTO spaonbv_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","El Señor peleará por ustedes, de modo que ustedes no tendrán que levantar ni un solo dedo». ");
INSERT INTO spaonbv_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","El Señor le dijo a Moisés: «¿Por qué clamas a mí? ¡Dile al pueblo que siga adelante! ");
INSERT INTO spaonbv_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Extiende tu vara sobre las aguas, y el mar abrirá un sendero delante de ti, y todo el pueblo de Israel podrá cruzarlo como en tierra seca. ");
INSERT INTO spaonbv_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Yo he endurecido el corazón de los egipcios, y ellos los seguirán, y verán cómo honro mi nombre derrotando al faraón, con todos sus ejércitos, sus carros y sus caballos. ");
INSERT INTO spaonbv_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","¡Todo Egipto sabrá que yo soy el Señor!». ");
INSERT INTO spaonbv_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","El ángel del Señor, que estaba guiando al pueblo de Israel, se puso detrás de todos. También la columna de nube se colocó detrás del pueblo, ");
INSERT INTO spaonbv_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","y se interpuso entre el pueblo de Israel y los egipcios. Y aquella noche, al convertirse en columna de fuego, dio oscuridad a los egipcios e iluminó al pueblo de Israel. ¡Los egipcios no pudieron alcanzar a los israelitas! ");
INSERT INTO spaonbv_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Mientras tanto, Moisés extendió su vara sobre el mar, y el Señor abrió un sendero a través del mar, con muros de agua a cada lado. Un gran viento del oriente sopló toda la noche y secó el fondo del mar. ");
INSERT INTO spaonbv_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","¡El pueblo de Israel caminó a través del mar por tierra seca! ");
INSERT INTO spaonbv_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Los egipcios los siguieron por entre los dos muros de agua a lo largo del fondo del mar, con todos los caballos, carros y jinetes del faraón. ");
INSERT INTO spaonbv_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Pero en la mañana, el Señor miró desde la nube de fuego a los egipcios, y trastornó su campamento. ");
INSERT INTO spaonbv_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Las ruedas de sus carros de guerra se atascaron, de modo que avanzaban muy lentamente. Entonces los egipcios gritaron: «¡Salgamos de aquí, porque el Señor está peleando por ellos contra nosotros!». ");
INSERT INTO spaonbv_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Cuando todos los israelitas pasaron, el Señor le dijo a Moisés: «Extiende tu vara sobre el mar, para que las aguas regresen y caigan sobre los egipcios, sobre sus carros y sus jinetes». ");
INSERT INTO spaonbv_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Moisés lo hizo así y, al amanecer, el mar regresó a su posición normal. Los egipcios trataron de huir, pero el Señor los hizo ahogar en el mar. ");
INSERT INTO spaonbv_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","El agua cubrió el sendero, y a los caballos y sus jinetes. Y todo el ejército del faraón, que perseguía a Israel a través del mar, pereció. ");
INSERT INTO spaonbv_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","En cambio, el pueblo de Israel cruzó el mar por tierra seca, pues las aguas habían formado muros a ambos lados de ellos. ");
INSERT INTO spaonbv_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Así salvó el Señor a los israelitas aquel día. El pueblo de Israel vio a los egipcios muertos a la orilla del mar. ");
INSERT INTO spaonbv_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Cuando los israelitas vieron el gran milagro que el Señor había hecho por ellos contra los egipcios, temieron al Señor, y creyeron en él y en su siervo Moisés. ");
INSERT INTO spaonbv_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Llenos de júbilo, Moisés y el pueblo de Israel cantaron este himno al Señor: Cantaré al Señor, porque obtuvo un triunfo extraordinario, pues arrojó caballos y jinetes al mar. ");
INSERT INTO spaonbv_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","El Señor es mi fortaleza, mi cántico y mi salvación. Lo alabaré, porque él es mi Dios. Lo exaltaré, porque él es el Dios de mis padres. ");
INSERT INTO spaonbv_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","El Señor es un guerrero. Sí, su nombre es el Señor. ");
INSERT INTO spaonbv_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Echó en el mar los carros y la caballería del faraón. Los más valientes guerreros egipcios yacen muertos en el Mar Rojo. ");
INSERT INTO spaonbv_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Las aguas los cubren. Como piedras se hundieron en el fondo. ");
INSERT INTO spaonbv_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Tu brazo derecho, Señor, es poderosísimo. Tu brazo derecho, Señor, aplasta al enemigo. ");
INSERT INTO spaonbv_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","En la grandeza de tu majestad destruiste a todos tus adversarios. Desataste tu ira y los consumiste, como el fuego consume la paja. ");
INSERT INTO spaonbv_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Al soplo de tu aliento las aguas se abrieron. Como diques poderosos se contuvieron las aguas del mar, y se separaron. ");
INSERT INTO spaonbv_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Los enemigos dijeron: «Los seguiremos, les daremos alcance y los destruiremos. ¡Los destrozaremos con nuestras espadas y repartiremos el botín!». ");
INSERT INTO spaonbv_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Pero el Señor sopló, y las aguas los cubrieron. Se hundieron como plomo en medio de las aguas. ");
INSERT INTO spaonbv_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","¿Quién es como tú, Señor, entre los dioses? ¿Quién es glorioso y santo como tú? ¿Quién es tan poderoso como tú? ¿Quién hace tantas maravillas y prodigios? ");
INSERT INTO spaonbv_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Extendiste tu brazo derecho, y la tierra los tragó. ");
INSERT INTO spaonbv_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Has conducido al pueblo que redimiste. En tu gracia misericordiosa lo guiaste hasta tu santa tierra. ");
INSERT INTO spaonbv_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Las naciones oyeron lo ocurrido y temblaron. El temor se ha apoderado del pueblo filisteo. ");
INSERT INTO spaonbv_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Los caudillos de Edom están turbados. Los poderosos de Moab están angustiados; todos los habitantes de Canaán se derriten de miedo. ");
INSERT INTO spaonbv_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","El terror y la angustia los han vencido. Señor, por miedo a tu gran poder se quedan mudos como una piedra. El pueblo que tú rescataste pasará por en medio de ellos con seguridad. ");
INSERT INTO spaonbv_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Los conducirás hasta tu monte y los plantarás en tu tierra, en el santuario que hiciste para que ellos vivan. ");
INSERT INTO spaonbv_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","¡El Señor reinará para siempre! ");
INSERT INTO spaonbv_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","La caballería del faraón, sus jinetes y sus carros trataron de seguir a Israel a través del mar, pero el Señor hizo que las aguas del mar cayeran sobre ellos, mientras que el pueblo de Israel pasó en seco. ");
INSERT INTO spaonbv_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Entonces Miriam, la profetisa, hermana de Aarón, tomó una pandereta y dirigió a las mujeres en las danzas, y ");
INSERT INTO spaonbv_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","entonó este cántico: Cantemos al Señor, porque obtuvo un triunfo extraordinario, pues arrojó caballos y jinetes al mar. ");
INSERT INTO spaonbv_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Moisés condujo al pueblo de Israel desde el Mar Rojo hasta el desierto de Sur; y viajaron tres días sin hallar agua. ");
INSERT INTO spaonbv_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Luego llegaron a Mara, pero no pudieron beber el agua, porque era amarga. Por esta razón el lugar fue llamado Mara, que significa amarga. ");
INSERT INTO spaonbv_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","El pueblo se quejó contra Moisés, y le reclamó: «¿Y qué vamos a beber?». ");
INSERT INTO spaonbv_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Por eso, Moisés oró al Señor para que los ayudara. Entonces el Señor le mostró un árbol que debía arrojar al agua. Así lo hizo y el agua se endulzó. Allí en Mara fue donde el Señor puso a prueba a los israelitas y les dio una ley que les serviría como norma de conducta. ");
INSERT INTO spaonbv_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Les dijo: «Yo soy el Señor su Dios. Si ustedes prestan atención a mi voz, y me obedecen y hacen lo que es bueno, no los dejaré sufrir las enfermedades que envié sobre los egipcios, porque yo soy el Señor que les da la salud». ");
INSERT INTO spaonbv_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Después los israelitas llegaron a Elim, donde había doce manantiales y setenta palmeras; y acamparon allí, junto a los manantiales. ");
INSERT INTO spaonbv_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Los israelitas salieron de Elim y viajaron al desierto de Sin, que está entre Elim y el monte de Sinaí. Hacía un mes y quince días que habían salido de Egipto. ");
INSERT INTO spaonbv_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Allí también el pueblo se quejó contra Moisés y Aarón. ");
INSERT INTO spaonbv_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Les dijeron: ―¡Ojalá el Señor nos hubiera quitado la vida en Egipto! Allí nos sentábamos junto a las ollas llenas de carne y comíamos hasta quedar satisfechos. Pero ustedes nos han traído hasta este desierto para matarnos de hambre. ");
INSERT INTO spaonbv_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","El Señor le dijo a Moisés: «Yo voy a hacer que les caigan alimentos del cielo. Cada uno podrá salir y recoger cuanto pueda comer ese día. Los probaré en esto, para ver si siguen mis órdenes. ");
INSERT INTO spaonbv_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Diles que el sexto día de la semana recojan el doble de lo que recogen los demás días». ");
INSERT INTO spaonbv_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Así que Moisés y Aarón convocaron al pueblo a una reunión y le dijeron: ―Esta tarde sabrán que fue el Señor el que los sacó de la tierra de Egipto. ");
INSERT INTO spaonbv_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","8","En la mañana verán la gloria del Señor, quien ha oído sus quejas contra él. Sí, contra él es que ustedes se están quejando, pues nosotros sólo somos sus representantes. El Señor les dará a comer carne en la tarde y pan abundante por la mañana. Él ya escuchó sus quejas, pues no es contra nosotros que ustedes se han quejado, sino contra él. ¡Nosotros no somos nadie! ");
INSERT INTO spaonbv_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Luego Moisés le dijo a Aarón: ―Diles a todos los israelitas que se reúnan delante del Señor, pues él ha escuchado todas sus quejas. ");
INSERT INTO spaonbv_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Mientras Aarón les hablaba, apareció repentinamente del desierto, de dentro de la nube que los guiaba, la majestuosa gloria del Señor. ");
INSERT INTO spaonbv_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","12","Y el Señor le dijo a Moisés: «He oído sus quejas. Diles que en la tarde tendrán carne y en la mañana podrán saciarse con pan. Y sabrán que yo soy el Señor su Dios». ");
INSERT INTO spaonbv_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Aquella tarde llegó una gran cantidad de codornices y cubrió el campo. Al día siguiente, todo el desierto, alrededor del campamento, amaneció mojado de rocío, ");
INSERT INTO spaonbv_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","y cuando desapareció el rocío, quedó sobre el suelo una cosa menuda parecida a la escarcha. ");
INSERT INTO spaonbv_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Cuando los israelitas vieron aquello, se preguntaban unos a otros: ―¿Qué es esto? Y Moisés les dijo: ―Es el pan que el Señor les da. ");
INSERT INTO spaonbv_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","El Señor ha dicho que cada uno debe recoger cuanto sea necesario para su familia, más o menos dos litros por persona. ");
INSERT INTO spaonbv_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","El pueblo de Israel empezó a recogerlo. ");
INSERT INTO spaonbv_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Había suficiente para todos, unos dos litros por persona. A los que juntaron mucho nada les sobró, y a los que juntaron poco, nada les faltó. Cada familia tuvo lo necesario. ");
INSERT INTO spaonbv_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Y Moisés les dijo: ―No dejen nada para mañana. ");
INSERT INTO spaonbv_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Pero hubo algunos que no prestaron atención, y guardaron para el día siguiente; y cuando miraron lo que habían guardado, estaba lleno de gusanos. ¡Se les había podrido! Moisés se enojó mucho con ellos. ");
INSERT INTO spaonbv_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","De modo que recogían alimento cada mañana, según sus necesidades. Cuando el sol calentaba la tierra, el alimento se derretía y desaparecía. ");
INSERT INTO spaonbv_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","El sexto día recogieron el doble de lo acostumbrado, unos cuatro litros. Los dirigentes del pueblo, al ver esto, fueron y le informaron a Moisés. ");
INSERT INTO spaonbv_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Entonces Moisés les dijo: ―El Señor ha señalado el sábado como día de reposo, de solemne reposo, en el que deben apartarse de sus tareas diarias. Por eso es que deben preparar hoy todo lo que necesiten, y guardar lo que sobre para mañana. Todo lo que deban cocinar o hervir deben hacerlo hoy, y lo que sobre deben guardarlo para mañana. ");
INSERT INTO spaonbv_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Los israelitas obedecieron a Moisés, y guardaron para el siguiente día toda la comida que les sobró. A la mañana siguiente el alimento estaba en buen estado, sin gusanos y sin mal olor. ");
INSERT INTO spaonbv_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Y Moisés les dijo: ―Este es su alimento para hoy, porque es día de reposo, consagrado al Señor. Hoy no habrá alimento en el campo. ");
INSERT INTO spaonbv_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Recojan alimento durante seis días, pero el séptimo día es día de reposo, y no hallarán nada. ");
INSERT INTO spaonbv_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Pero algunos salieron a recoger alimento, aun cuando era día de reposo, pero nada encontraron. ");
INSERT INTO spaonbv_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","29","Y el Señor le dijo a Moisés: ―¿Hasta cuándo se niega este pueblo a obedecerme? ¿No comprenden que les doy el doble en el sexto día para que tengan suficiente para dos días? Les he dado el séptimo día como día de reposo; deben permanecer en sus casas, y no salir a buscar alimento en ese día. ");
INSERT INTO spaonbv_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","El pueblo reposó en el séptimo día. ");
INSERT INTO spaonbv_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Y el alimento recibió el nombre de maná, que significa: «¿Qué es esto?». Era como semilla de cilantro, pero blanco, con sabor como a pan de miel. ");
INSERT INTO spaonbv_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Moisés les comunicó a los israelitas estas otras órdenes del Señor: Debían recoger unos dos litros de maná y guardarlo de muestra para siempre, para que las generaciones posteriores pudieran conocer el pan con que el Señor los había alimentado en el desierto, después de sacarlos de Egipto. ");
INSERT INTO spaonbv_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Moisés le dijo a Aarón: ―Consigue una vasija y mete en ella los dos litros de maná. Luego guarda la vasija en la presencia del Señor, frente al cofre del pacto. Allí deberá permanecer de generación en generación. ");
INSERT INTO spaonbv_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Aarón hizo lo que el Señor le había ordenado por medio de Moisés. Así que guardó la vasija con el maná frente al cofre del pacto. ");
INSERT INTO spaonbv_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Los israelitas comieron del maná durante cuarenta años, hasta que entraron en la tierra de Canaán, donde pudieron comer de lo que la tierra producía. ");
INSERT INTO spaonbv_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","La medida que usaban para medir el maná se llamaba gómer, y era aproximadamente de dos litros, y equivalía a la décima parte de otra medida llamada efa. ");
INSERT INTO spaonbv_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Ahora bien, por mandato del Señor, el pueblo de Israel dejó el desierto de Sin y se dirigió hasta Refidín. Pero se encontraron con que en Refidín no había agua. ");
INSERT INTO spaonbv_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Así que una vez más los israelitas se enojaron con Moisés y le dijeron: ―¡Danos agua, pues nos estamos muriendo de sed! Moisés les dijo: ―¿Por qué se enojan conmigo? ¿Están tratando de nuevo de poner a prueba la paciencia del Señor? ");
INSERT INTO spaonbv_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Pero, atormentados por la sed, le respondieron: ―¿Por qué nos sacaste de Egipto? ¿Por qué nos trajiste a morir de sed aquí, junto con nuestros hijos y nuestro ganado? ");
INSERT INTO spaonbv_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Moisés, entonces, oró al Señor, y le dijo: ―¿Qué haré con esta gente? ¡Están a punto de apedrearme! ");
INSERT INTO spaonbv_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","6","El Señor le contestó: ―Toma contigo a algunos de los ancianos de Israel, y lleva al pueblo hasta el monte Horeb. Allí te esperaré junto a la roca. No se te olvide llevar la vara con que golpeaste el río Nilo. Cuando llegues al monte Horeb, golpea la roca, y verás cómo de ella brotará agua suficiente para todos. En presencia de los ancianos de Israel, Moisés hizo lo que Dios le había dicho, y el agua brotó de la roca. ");
INSERT INTO spaonbv_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","A ese lugar, Moisés lo llamó Masá, que significa tentación, porque allí los israelitas tentaron al Señor, diciendo: «¿Está el Señor entre nosotros, o no?». También lo llamó Meribá, que significa queja, pues allí el pueblo de Israel se quejó contra Dios. ");
INSERT INTO spaonbv_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Los amalecitas salieron a pelear contra el pueblo de Israel en Refidín. ");
INSERT INTO spaonbv_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Entonces Moisés le ordenó a Josué: «Escoge a algunos hombres, y sal con ellos a pelear contra el ejército de Amalec. Mañana yo me pararé en la cumbre de la colina con la vara de Dios en mis manos». ");
INSERT INTO spaonbv_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Josúe y sus soldados salieron a presentar batalla al ejército de Amalec. Moisés, Aarón y Jur subieron a la cumbre de la montaña. ");
INSERT INTO spaonbv_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Mientras Moisés mantenía los brazos en alto, Israel ganaba, pero cuando los bajaba, entonces los amalecitas comenzaban a ganar terreno. ");
INSERT INTO spaonbv_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Finalmente, Moisés sintió tanto cansancio que no podía tener los brazos más tiempo en alto. Entonces Aarón y Jur le pusieron una piedra para que él se sentara, y ellos se pusieron a sus lados, sosteniendo sus brazos en alto hasta la puesta del sol. ");
INSERT INTO spaonbv_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Como resultado, Josué y sus soldados derrotaron al ejército de Amalec a filo de espada. ");
INSERT INTO spaonbv_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Luego, el Señor le ordenó a Moisés: «Escribe esto en un libro para que se recuerde siempre, y anuncia a Josué que borraré todo rastro de Amalec». ");
INSERT INTO spaonbv_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","16","Moisés edificó allí un altar, y lo llamó «El Señor-Nisí», que significa «El Señor es mi bandera», y exclamó: «¡Tomen la bandera del Señor en la mano! ¡El Señor estará en guerra con Amalec de generación en generación!». ");
INSERT INTO spaonbv_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Jetro, suegro de Moisés y sacerdote de Madián, supo las maravillosas cosas que el Señor había hecho por su pueblo Israel y por Moisés, y cómo el Señor los había sacado de Egipto. ");
INSERT INTO spaonbv_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Tiempo antes, cuando Moisés tuvo que enviar a Séfora, su esposa, a la región de Madián, Jetro la recibió en su casa, ");
INSERT INTO spaonbv_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","junto con sus dos hijos, Guersón, que significa extranjero, porque Moisés había dicho cuando nació: «He estado peregrinando en tierra extranjera», ");
INSERT INTO spaonbv_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","y Eliezer, que significa ayuda, porque Moisés había dicho cuando nació: «El Dios de mi padre fue quien me ayudó, y me libró de la espada del faraón». ");
INSERT INTO spaonbv_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","6","Jetro tomó, pues, a Séfora y a sus dos nietos, y se fue al desierto a visitar a Moisés. Cuando supo que los israelitas estaban acampando junto a la montaña de Dios, le envió este mensaje a Moisés: «Yo, Jetro, tu suegro, voy a visitarte. Conmigo vienen tu esposa y tus dos hijos». ");
INSERT INTO spaonbv_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Moisés salió a recibir a su suegro con mucho cariño. Se preguntaron sobre la salud de uno y otro, y luego entraron en la tienda de Moisés, para seguir conversando. ");
INSERT INTO spaonbv_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Moisés le contó a su suegro todo lo que había estado ocurriendo, y lo que el Señor les había hecho al faraón y a los egipcios, para librar a Israel. También le contó todos los problemas que habían tenido en el camino, y la forma en que el Señor había librado a su pueblo de todos ellos. ");
INSERT INTO spaonbv_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Jetro se sintió muy feliz con todo lo que el Señor estaba haciendo por Israel, y de que los hubiera sacado de Egipto. ");
INSERT INTO spaonbv_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Y exclamó: «¡Bendito sea el Señor, porque te ha salvado de los egipcios y del faraón, y ha rescatado a Israel! ");
INSERT INTO spaonbv_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Yo sé que el Señor es mayor que cualquier otro dios, porque libró a su pueblo de la soberbia y de la crueldad de los egipcios». ");
INSERT INTO spaonbv_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Luego, Jetro ofreció sacrificios a Dios. Aarón y los líderes de Israel fueron a ver a Jetro, y todos juntos comieron del sacrificio delante de Dios. ");
INSERT INTO spaonbv_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Al día siguiente, como de costumbre, Moisés se sentó desde la mañana hasta la tarde a escuchar los problemas que la gente venía a contarle. Mientras Moisés atendía a unos, los demás permanecían de pie. ");
INSERT INTO spaonbv_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Cuando Jetro vio la manera como Moisés atendía al pueblo, le dijo: ―¿Por qué estás tratando de hacer todo esto tú solo, y la gente tiene que estar parada todo el día esperando a que la atiendas? ");
INSERT INTO spaonbv_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","16","―Porque el pueblo viene a mí con sus problemas para consultar a Dios —respondió Moisés—. Yo soy el juez y debo decidir quién tiene la razón y quién está equivocado. Además, debo enseñarles los mandamientos y enseñanzas de Dios. ");
INSERT INTO spaonbv_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","―No está bien —le dijo su suegro—. ");
INSERT INTO spaonbv_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Te vas a agotar, y entonces ¿qué le ocurrirá a tu pueblo? Esto es demasiado trabajo para tratar de llevarlo tú solo. ");
INSERT INTO spaonbv_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","20","Escúchame y permíteme darte un consejo, para que Dios te bendiga. Sé el abogado de este pueblo, su representante delante de Dios, para que Dios resuelva sus problemas. Tú les comunicarás las decisiones de Dios, les enseñarás sus leyes, y les darás a conocer los principios que deben seguir para tener una conducta correcta. ");
INSERT INTO spaonbv_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","»Busca a algunos hombres capaces, piadosos y honestos, que odien el soborno, y desígnalos como jueces. Nombra un juez para cada mil personas. Y él, a su vez, tendrá a su cargo diez jueces; y cada uno de estos estará a cargo de cien personas. Bajo cada uno de los jueces de cien habrá dos jueces, cada uno a cargo de cincuenta personas. Y cada uno de estos tendrá cinco jueces a su cargo, uno para cada diez personas. ");
INSERT INTO spaonbv_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Deja que estos hombres se encarguen de administrar justicia. Cualquier cosa que sea muy importante o complicada, pueden traértela a ti. Pero en los asuntos menores, ellos pueden decidir por sí mismos. De este modo será todo más fácil para ti, porque tú compartirás la carga con ellos. ");
INSERT INTO spaonbv_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Si sigues mi consejo, y si al Señor le parece bien, podrás soportar todas las presiones, y habrá paz y armonía en el campamento». ");
INSERT INTO spaonbv_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Moisés escuchó atentamente el consejo de su suegro y siguió sus sugerencias. ");
INSERT INTO spaonbv_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Escogió hombres capaces y los designó jueces del pueblo, jueces de mil, de cien, de cincuenta y de diez. ");
INSERT INTO spaonbv_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Estaban constantemente disponibles para administrar justicia. Los casos más difíciles los referían a Moisés, pero ellos juzgaban todos los casos menores. ");
INSERT INTO spaonbv_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Poco después, Moisés despidió a su suegro, quien regresó a su tierra. ");
INSERT INTO spaonbv_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Los israelitas llegaron al desierto de Sinaí, tres meses después de su salida de Egipto. ");
INSERT INTO spaonbv_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","3","Levantaron el campamento en Refidín, y continuaron su viaje. Cuando llegaron al pie del monte Sinaí, establecieron allí su campamento. Moisés subió al monte para encontrarse con Dios, y desde la cima el Señor lo llamó y le dijo: «Esto es lo que les dirás a los israelitas, los descendientes de Jacob: ");
INSERT INTO spaonbv_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","“Ustedes han visto lo que hice con los egipcios, y cómo los traje a ustedes con tanto cuidado, como cuando las águilas llevan sobre sus alas a sus polluelos. ");
INSERT INTO spaonbv_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Ahora, pues, si oyen mi voz y guardan mi pacto, serán mi principal tesoro entre todas las naciones de la tierra, porque toda la tierra es mía. ");
INSERT INTO spaonbv_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Y serán un reino de sacerdotes y gente santa”». ");
INSERT INTO spaonbv_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Moisés descendió del monte, llamó a todos los dirigentes del pueblo y les dijo lo que el Señor le había dicho. ");
INSERT INTO spaonbv_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Le respondieron unánimes: «Haremos siempre todo lo que él nos pida». Y Moisés le refirió al Señor la respuesta del pueblo. ");
INSERT INTO spaonbv_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","El Señor le dijo, a Moisés: ―Yo voy a presentarme delante de ti en forma de una nube oscura, de modo que el pueblo mismo pueda oírme cuando hable contigo, y así siempre te creerán. ");
INSERT INTO spaonbv_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Desciende ahora y haz que el pueblo se prepare para mi visita. Santifícalos hoy y mañana; y haz que laven su ropa. ");
INSERT INTO spaonbv_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Luego, pasado mañana, descenderé sobre el monte Sinaí, mientras el pueblo observa. ");
INSERT INTO spaonbv_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Establece límites para que la gente no pase, y diles: “No suban al monte ni toquen sus límites. ");
INSERT INTO spaonbv_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Si algún hombre o animal lo hace, nadie tocará al ofensor, sino que morirá a pedradas o a flechazos. Permanezcan alejados del monte. Sólo cuando oigan el toque largo de trompeta, podrán subir a la montaña”. ");
INSERT INTO spaonbv_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Moisés descendió al pueblo y lo santificó, y ellos lavaron su ropa. ");
INSERT INTO spaonbv_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Luego Moisés les dijo: «Prepárense para encontrarse con Dios pasado mañana, y no tengan relaciones sexuales». ");
INSERT INTO spaonbv_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","En la mañana del tercer día hubo una terrible tormenta de relámpagos y truenos. Una densa nube descendió sobre el monte, y hubo un largo toque de trompeta, y todo el pueblo tembló. ");
INSERT INTO spaonbv_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Moisés los hizo salir del campamento para ir al encuentro de Dios, y los dejó al pie del monte. ");
INSERT INTO spaonbv_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Todo el monte Sinaí estaba cubierto de humo, porque el Señor había descendido en forma de fuego. El humo subía al cielo como si saliera de un horno, y todo el monte temblaba como sacudido por un violento terremoto; ");
INSERT INTO spaonbv_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","y el toque de trompeta era cada vez más fuerte. Moisés hablaba con Dios, y él le respondía con voz de trueno. ");
INSERT INTO spaonbv_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","El Señor bajó a la cumbre del monte Sinaí, y llamó a Moisés para que subiera. Entonces Moisés subió, ");
INSERT INTO spaonbv_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","y el Señor le dijo: ―Desciende, y advierte al pueblo que no debe cruzar los límites. Nadie debe subir hasta aquí para tratar de verme, porque morirá. ");
INSERT INTO spaonbv_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Aun los sacerdotes que estén de turno deben santificarse para que no los destruya. ");
INSERT INTO spaonbv_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","―Pero el pueblo no subirá al monte —contestó Moisés—. Tú les dijiste que no lo hicieran. Me dijiste que estableciera límites alrededor del monte, y que les avisara que el terreno que estaba a este lado de los límites estaba reservado para ti. ");
INSERT INTO spaonbv_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","El Señor le dijo: ―Desciende y trae a Aarón contigo. Pero nadie más debe subir al monte, ni siquiera los sacerdotes, pues quien lo haga se expone a mi castigo. ");
INSERT INTO spaonbv_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Moisés bajó del monte, y les dijo a los israelitas lo que el Señor le había comunicado. ");
INSERT INTO spaonbv_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Dios le dijo al pueblo de Israel: ");
INSERT INTO spaonbv_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","«Yo soy el Señor tu Dios que te sacó de Egipto, donde eras esclavo. ");
INSERT INTO spaonbv_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","»No tendrás otros dioses además de mí. ");
INSERT INTO spaonbv_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","»No te harás ídolos ni imágenes de nada que esté en el cielo, en la tierra o en lo profundo del mar. ");
INSERT INTO spaonbv_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","No te inclinarás delante de ninguna imagen ni la adorarás, porque yo, el Señor tu Dios, soy muy celoso, y no compartiré con otros dioses la honra que me pertenece. Cuando castigo a alguien por sus pecados, el castigo alcanza a sus hijos, a sus nietos y a sus bisnietos. ");
INSERT INTO spaonbv_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Pero derramo mi amor sobre millares de generaciones de los que me aman y obedecen mis mandamientos. ");
INSERT INTO spaonbv_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","»No usarás el nombre del Señor tu Dios en vano ni en forma irreverente. No dejaré sin castigo a quien se atreva a usar mi nombre sin el debido respeto. ");
INSERT INTO spaonbv_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","»Acuérdate de observar el día de reposo, es decir, el sábado, como día santo. ");
INSERT INTO spaonbv_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Seis días de la semana son para los quehaceres cotidianos y el trabajo regular. ");
INSERT INTO spaonbv_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Pero el séptimo día es día de reposo delante del Señor tu Dios. Ese día no harán trabajo de ninguna clase tú, ni tu hijo, ni tu hija, ni tus esclavos, ni tus huéspedes, ni tus animales, ");
INSERT INTO spaonbv_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","porque en seis días hizo el Señor los cielos, la tierra, el mar y todo lo que en ellos hay, y reposó el séptimo día. Por eso bendijo el día de reposo y lo santificó. ");
INSERT INTO spaonbv_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","»Honra a tu padre y a tu madre, para que tengas una vida larga y buena en la tierra que el Señor tu Dios te da. ");
INSERT INTO spaonbv_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","»No matarás. ");
INSERT INTO spaonbv_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","»No cometerás adulterio. ");
INSERT INTO spaonbv_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","»No robarás. ");
INSERT INTO spaonbv_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","»No darás un testimonio falso en contra de tu prójimo. ");
INSERT INTO spaonbv_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","»No codiciarás la casa de tu prójimo: no codiciarás la mujer de tu prójimo, ni su esclavo, ni su buey, ni su burro, ni ninguna otra cosa que le pertenezca». ");
INSERT INTO spaonbv_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Todos los israelitas vieron los relámpagos y el humo que subía del monte, y oyeron los truenos y el toque de la trompeta, y se quedaron lejos, temblando de miedo. ");
INSERT INTO spaonbv_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Y le dijeron a Moisés: ―Dinos lo que Dios diga, y nosotros obedeceremos. Pero que no nos hable Dios en forma directa, pues moriremos. ");
INSERT INTO spaonbv_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","―No teman —les dijo Moisés—, porque Dios se ha presentado de esta manera para probarlos, de modo que de aquí en adelante tengan temor de pecar en su contra. ");
INSERT INTO spaonbv_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Mientras el pueblo permanecía a una distancia prudente, Moisés volvió a entrar en la nube donde estaba Dios. ");
INSERT INTO spaonbv_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Y el Señor le dijo a Moisés que les comunicara a los israelitas lo siguiente: «Ustedes son testigos de que les he dado a conocer mi voluntad desde el cielo. ");
INSERT INTO spaonbv_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Recuerden que no deben adorar ídolos, ya sean de plata, de oro o de algún otro material. ");
INSERT INTO spaonbv_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Los altares que hagan para mí deben ser sencillos altares de tierra. Sobre ellos me ofrecerán sus sacrificios, sus holocaustos y sus ofrendas pacíficas de ovejas y bueyes. Yo iré al lugar donde les pida que invoquen mi nombre, y los bendeciré allí. ");
INSERT INTO spaonbv_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","También pueden edificar altares de piedra, pero solamente con piedras sin tallar. No golpearán las piedras con ningún tipo de herramienta para labrarlas, porque eso las profanaría y no servirían para mi altar. ");
INSERT INTO spaonbv_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Y no harán gradas para subir a mi altar; para que no se les vea la desnudez. ");
INSERT INTO spaonbv_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","»Estas son otras leyes que deben obedecer: ");
INSERT INTO spaonbv_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","»Si alguien adquiere un esclavo hebreo, sólo lo obligará a trabajar para él por seis años. Al séptimo año le dará la libertad, sin que pague nada. ");
INSERT INTO spaonbv_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","»Si el esclavo era soltero, y luego se casa, solamente él será libre. Pero si estaba casado, su esposa recibirá la libertad al mismo tiempo que él. ");
INSERT INTO spaonbv_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Si su amo le dio esposa mientras era esclavo, y tuvieron hijos o hijas, la esposa y los hijos pertenecerán todavía al amo. Por eso, el esclavo tendrá que irse solo. ");
INSERT INTO spaonbv_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","»Pero si el esclavo declara: “Amo a mi dueño, a mi esposa y a mis hijos, y no quiero ser puesto en libertad”, ");
INSERT INTO spaonbv_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","el amo lo llevará delante de los jueces, y en presencia de ellos le perforará la oreja con un punzón, y será su esclavo para siempre. ");
INSERT INTO spaonbv_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","»Si un hombre vende a su hija como esclava, ella no será libre al final de los seis años, como en el caso del hombre. ");
INSERT INTO spaonbv_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","»Si el hombre que la compró no desea casarse con ella, porque no le agrada, permitirá que sea rescatada. Pero no podrá venderla a extranjeros, puesto que la despreció al no querer tenerla como esposa. ");
INSERT INTO spaonbv_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Pero si la ha desposado con su hijo, ya no deberá tratarla como esclava, sino como hija. ");
INSERT INTO spaonbv_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","»Si el que la compró se casa con ella, y luego toma otra esposa, no podrá disminuirle el alimento ni el vestido; ni dejar de dormir con ella. ");
INSERT INTO spaonbv_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Si falla en alguno de estos compromisos, ella quedará libre, sin necesidad de pago alguno. ");
INSERT INTO spaonbv_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","»Cualquiera que mate a otro hombre, deberá morir. ");
INSERT INTO spaonbv_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Pero si fue accidental, porque así yo lo había determinado, entonces el asesino podrá huir y refugiarse en un lugar que yo te indicaré. ");
INSERT INTO spaonbv_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","»Sin embargo, si lo mata deliberadamente, aun si se refugia en mi altar, de allí lo sacarás y le darás muerte. ");
INSERT INTO spaonbv_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","»Cualquiera que golpee a su padre o a su madre morirá. ");
INSERT INTO spaonbv_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","»El que secuestre a una persona y la venda, o lo sorprendan con ella en su poder, deberá morir. ");
INSERT INTO spaonbv_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","»El que insulte o maldiga a su madre o a su padre, ciertamente debe morir. ");
INSERT INTO spaonbv_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","»Si dos hombres están peleando y uno golpea al otro con una piedra o con su puño, y le causa un daño tal que debe guardar cama, pero no muere, ");
INSERT INTO spaonbv_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","el ofensor será declarado inocente, siempre y cuando el herido pueda levantarse y caminar apoyado sobre un bastón. Sin embargo, el que lo golpeó deberá pagarle por el tiempo que esté sin trabajar, como también los gastos de su curación, hasta que esté completamente sano. ");
INSERT INTO spaonbv_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","»Si un hombre golpea a su esclavo y le da muerte, debe ser castigado. ");
INSERT INTO spaonbv_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Sin embargo, si el esclavo no muere en un par de días, el ofensor no será castigado, porque el esclavo es propiedad suya. ");
INSERT INTO spaonbv_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","»Si varios hombres pelean, y en medio de la pelea uno de ellos golpea a una mujer que está embarazada, y como consecuencia ella tiene un aborto, pero queda viva, el hombre que la haya herido deberá pagar la multa que exija el marido de la mujer, y que los jueces aprueben. ");
INSERT INTO spaonbv_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Pero si la mujer muere, entonces el ofensor pagará vida por vida, ");
INSERT INTO spaonbv_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","ojo por ojo, diente por diente; mano por mano, pie por pie; ");
INSERT INTO spaonbv_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","quemadura por quemadura, herida por herida, golpe por golpe. ");
INSERT INTO spaonbv_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","»Si un hombre golpea a su esclavo o a su esclava en un ojo, y por dicho golpe el esclavo o la esclava pierde su ojo, entonces el ofensor le dará la libertad, como una compensación por el ojo que le dañó. ");
INSERT INTO spaonbv_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Si le arranca un diente, también deberá darle la libertad. ");
INSERT INTO spaonbv_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","»Si un buey cornea a un hombre o a una mujer y le da muerte, el dueño del animal no será considerado culpable. Pero se matará al buey a pedradas, y no se podrá comer su carne. ");
INSERT INTO spaonbv_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Pero si el buey es bravo, y el dueño lo sabe y lo deja suelto, el buey será apedreado y el dueño deberá morir, ");
INSERT INTO spaonbv_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","a menos que los parientes del muerto acepten la indemnización que los jueces determinen. ");
INSERT INTO spaonbv_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","»La misma ley se aplica si el buey cornea a un niño o a una niña. ");
INSERT INTO spaonbv_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","»Pero si el buey cornea a un esclavo, hombre o mujer, el dueño pagará treinta monedas de plata al dueño del esclavo o de la esclava, y el buey se matará a pedradas. ");
INSERT INTO spaonbv_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","»Si un hombre cava un pozo y, por no cubrirlo, cae en él un buey o un burro, ");
INSERT INTO spaonbv_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","pagará los daños al propietario del animal, y el animal muerto quedará para él. ");
INSERT INTO spaonbv_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","»Si un buey mata al buey de otra persona, los dos propietarios venderán el buey vivo, se repartirán el dinero, y cada uno se quedará con la mitad del buey muerto. ");
INSERT INTO spaonbv_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Pero si se sabía que el buey era bravo, su dueño deberá reponer el buey muerto con uno vivo, y se quedará con el buey muerto. ");
INSERT INTO spaonbv_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","»Si alguien roba un buey y lo mata o lo vende, pagará cinco por uno: cinco bueyes serán devueltos por un buey robado. Si se trata de una oveja, serán cuatro por una: cuatro ovejas serán devueltas por una robada. ");
INSERT INTO spaonbv_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","»Si el ladrón es sorprendido en el acto de entrar en una casa y lo matan, el que lo mató no es culpable. ");
INSERT INTO spaonbv_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Pero si ocurre a la luz del día, se presume que es homicidio, y el que lo mató es culpable. Si se captura a un ladrón, debe hacer completa restitución de lo robado. Si no puede, debe ser vendido como esclavo para cancelar su deuda. ");
INSERT INTO spaonbv_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Si es sorprendido robando un buey, un burro, una oveja o cualquier otra cosa, pagará el doble de su valor como multa. ");
INSERT INTO spaonbv_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","»Si alguien deliberadamente deja suelto un animal, y este se introduce en la viña de un vecino o entra a pastar en su campo, con lo mejor de su propia cosecha esa persona deberá pagar todos los daños. ");
INSERT INTO spaonbv_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","»Si se prende fuego para quemar la maleza, y el fuego pasa a la propiedad de un vecino y destruye su cosecha, sea que esté amontonada o que aún no haya sido cortada, el autor del fuego deberá pagar todos los daños. ");
INSERT INTO spaonbv_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","»Si alguien entrega dinero o cosas de valor a otra persona para que se las guarde, y estos le son robados, el ladrón pagará el doble, en caso de que lo atrapen. ");
INSERT INTO spaonbv_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Pero si no se descubre al ladrón, entonces el hombre que recibió las cosas en depósito será llevado a los jueces, para que determinen si dispuso de los bienes o si participó en el robo. ");
INSERT INTO spaonbv_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","»En todo caso en que un buey, un burro, una oveja, ropa o cualquier otra cosa se haya perdido, y el propietario piense que lo ha encontrado en poder de otro que lo niega, los dos se presentarán ante los jueces; y el que sea declarado culpable pagará el doble al otro. ");
INSERT INTO spaonbv_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","»Si un hombre le pide a su vecino que le guarde un burro, una oveja o cualquier otro animal, y este muere, se hace daño, o se pierde, y no hay testigos que puedan dar cuenta de lo que ocurrió, ");
INSERT INTO spaonbv_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","el vecino deberá jurar ante el Señor que no lo ha robado; y el propietario deberá aceptar su palabra, y no se hará restitución por ello. ");
INSERT INTO spaonbv_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Pero si el animal o la posesión del otro han sido robados, el que lo tenía en custodia deberá hacer restitución al propietario. ");
INSERT INTO spaonbv_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Si fue atacado por algún animal salvaje, traerá los despojos para confirmar el hecho, y no tendrá que hacer restitución. ");
INSERT INTO spaonbv_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","»Si un hombre pide prestado un animal o cualquier otra cosa a un vecino, y lo prestado sufre daño o muere cuando el propietario no se encontraba presente, el hombre que lo tomó prestado deberá pagarlo. ");
INSERT INTO spaonbv_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Pero si el propietario estaba presente, no necesita pagar, y si era alquilado, solo tendrá que pagar el alquiler. ");
INSERT INTO spaonbv_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","»Si un hombre seduce a una mujer que aún no está comprometida, deberá pagar la dote usual y aceptarla por esposa. ");
INSERT INTO spaonbv_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Pero si el padre se niega a que se case con ella, pagará de todos modos la dote. ");
INSERT INTO spaonbv_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","»Las hechiceras deberán ser condenadas a muerte. ");
INSERT INTO spaonbv_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","»Cualquiera que tenga relaciones sexuales con animales deberá ser condenado a muerte. ");
INSERT INTO spaonbv_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","»Cualquiera que ofrezca sacrificios a otros dioses, en vez de ofrecérselos sólo al Señor, será condenado a muerte. ");
INSERT INTO spaonbv_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","»No maltraten ni opriman al extranjero. Recuerden que ustedes fueron extranjeros en Egipto. ");
INSERT INTO spaonbv_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","»No hagan daño alguno a la viuda o al huérfano. ");
INSERT INTO spaonbv_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Si lo hacen, y ellos claman a mí pidiendo ayuda, ciertamente los ayudaré. ");
INSERT INTO spaonbv_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Entonces desataré mi ira contra ustedes y haré que mueran a filo de espada. ¡De este modo las que se quedarán viudas serán sus esposas, y los que se quedarán huérfanos serán sus hijos! ");
INSERT INTO spaonbv_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","»Si prestan dinero a un israelita necesitado, no le cobrarán interés en la forma acostumbrada. ");
INSERT INTO spaonbv_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Si toman su túnica como prenda, deberán devolvérsela en la noche. ");
INSERT INTO spaonbv_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Es probable que sea su único abrigo, de modo que no tendrá con qué cobijarse en la noche. Si no le devuelven su túnica, y él clama a mí, entonces yo lo atenderé, porque soy muy compasivo. ");
INSERT INTO spaonbv_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","»No ofenderán ni maldecirán a las autoridades, ni a los jueces ni a los gobernantes. ");
INSERT INTO spaonbv_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","»Deberán dar el diezmo de sus cosechas y de sus vinos, y el pago de rescate de sus hijos primogénitos. ");
INSERT INTO spaonbv_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","»En cuanto al primero de sus ganados y de sus rebaños, deberán entregármelos en el octavo día, después de dejarlo estar con su madre siete días. ");
INSERT INTO spaonbv_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","»Y por cuanto ustedes son mi pueblo especial, no comerán la carne de ningún animal que haya sido atacado y muerto por una bestia salvaje. Esa carne se la echarán a los perros. ");
INSERT INTO spaonbv_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","»No acepten falsos rumores. »No cooperen con el malvado apoyando su testimonio, cuando sepan que es falso. ");
INSERT INTO spaonbv_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","3","»No sigan a las mayorías que intenten hacer mal. Cuando estén en el estrado de los testigos, no inclinen sus testimonios a favor de la mayoría presente ni hacia el pobre, por el simple hecho de ser pobre. ");
INSERT INTO spaonbv_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","»Si encuentran el buey o el burro extraviado de su enemigo, llévenselo a su dueño. ");
INSERT INTO spaonbv_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Si ven que su enemigo trata de levantar su burro que ha caído bajo una pesada carga, deberán detenerse a ayudarle. ");
INSERT INTO spaonbv_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","»La pobreza del hombre no es razón para torcer la justicia en su contra. ");
INSERT INTO spaonbv_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","»Aléjense de todo intento de acusar a alguien falsamente. No permitan que un inocente sea condenado a muerte. Esto yo no lo toleraré. ");
INSERT INTO spaonbv_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","»No acepten soborno, porque los inclina hacia la parcialidad y daña la causa del inocente. ");
INSERT INTO spaonbv_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","»No oprimirán al extranjero, porque ustedes saben lo que es ser extranjero. Recuerden su experiencia en Egipto. ");
INSERT INTO spaonbv_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","»Sembrarán y cosecharán durante seis años, ");
INSERT INTO spaonbv_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","pero la tierra descansará durante el séptimo año, y los pobres del pueblo podrán espigar lo que salga espontáneamente; el resto lo dejarán para que coman los animales. Esta misma regla se aplica a sus viñedos y olivares. ");
INSERT INTO spaonbv_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","»Trabajarán seis días solamente y descansarán el séptimo. Esto es para dar descanso a su buey y su asno, a sus esclavos y al extranjero que viva con ustedes. ");
INSERT INTO spaonbv_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","»Obedezcan todas estas cosas, y recuerden que no deben ni siquiera mencionar el nombre de otro dios. ");
INSERT INTO spaonbv_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","»Deberán celebrar tres fiestas religiosas en el año. ");
INSERT INTO spaonbv_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","La primera es la de los Panes sin levadura. Durante siete días no comerán pan con levadura, conforme a lo que les he ordenado. Esta celebración será anual. La celebrarán en el mes de aviv, que fue el mes en que salieron de Egipto. Cada uno deberá ofrecerme algún sacrificio en esa fecha. ");
INSERT INTO spaonbv_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","»También celebrarán la fiesta de las Primicias, en la que me ofrecerán las primicias de la cosecha. Y finalmente, la fiesta de la Cosecha, cuando termine el trabajo de recolección de la cosecha. ");
INSERT INTO spaonbv_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","»Cada año, en estas tres fiestas, todo varón de Israel se presentará delante del Señor. ");
INSERT INTO spaonbv_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","»Ningún sacrificio de sangre será ofrecido con panes con levadura; no se dejará la grasa del animal sacrificado para ofrecerla al día siguiente. ");
INSERT INTO spaonbv_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","»Llevarán a la casa del Señor los primeros y mejores frutos de sus campos. »No cocerán el cabrito en la leche de su madre. ");
INSERT INTO spaonbv_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","»Miren, estoy enviando un ángel delante de ustedes, para que lleguen con seguridad a la tierra que les he preparado. ");
INSERT INTO spaonbv_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Muéstrenle reverencia y obedezcan todas sus órdenes. No se rebelen contra él, porque él actúa en mi nombre, y no les perdonará sus faltas. ");
INSERT INTO spaonbv_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Si le obedecen cuidadosamente y siguen todas sus instrucciones, yo seré enemigo de sus enemigos. ");
INSERT INTO spaonbv_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Y mi ángel irá delante de ustedes y los conducirá a la tierra de los amorreos, de los ferezeos, de los hititas, de los cananeos, de los heveos y de los jebuseos, para que vivan en ella. Yo destruiré estos pueblos delante de ustedes. ");
INSERT INTO spaonbv_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","»No adorarán dioses de otras naciones ni les ofrecerán sacrificios; no deben imitar el ejemplo de esos pueblos paganos. Deben vencerlos completamente y destrozar todos sus ídolos vergonzosos. ");
INSERT INTO spaonbv_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","»Servirán al Señor su Dios solamente, y yo los bendeciré con alimentos y agua, y apartaré toda enfermedad de entre ustedes. ");
INSERT INTO spaonbv_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","No habrá abortos ni esterilidad en su tierra, y vivirán a plenitud todos los días de su vida. ");
INSERT INTO spaonbv_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","»El pánico del Señor caerá sobre las naciones que ustedes invadan, de modo que sus habitantes huirán delante de ustedes. ");
INSERT INTO spaonbv_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","»Enviaré delante de ustedes avispas que expulsen a los heveos, cananeos e hititas. ");
INSERT INTO spaonbv_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","No lo haré todo en un solo año, porque la tierra se convertiría en un desierto y los animales salvajes se multiplicarían, de manera que no se podrían dominar. ");
INSERT INTO spaonbv_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Los expulsaré poco a poco, hasta que la población de ustedes haya crecido lo suficiente como para llenar la tierra. ");
INSERT INTO spaonbv_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Los límites que les pondré serán desde el Mar Rojo hasta la costa de los filisteos, y desde el desierto hasta el río Éufrates. Haré que ustedes venzan a los pueblos que hoy viven en esa tierra, y los expulsen de la región. ");
INSERT INTO spaonbv_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","»No deberán hacer pacto con ellos, ni tendrán parte alguna con sus dioses. ");
INSERT INTO spaonbv_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","No dejen que vivan entre ustedes, porque yo sé que ellos los contaminarán con su pecado de adorar a dioses falsos, y eso sería la ruina de ustedes». ");
INSERT INTO spaonbv_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","El Señor le dijo a Moisés: «Sube con Aarón, Nadab, Abiú y setenta de los ancianos de Israel. Pero ellos no podrán acercarse, sino que se arrodillarán a cierta distancia. ");
INSERT INTO spaonbv_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Sólo tú podrás llegar junto a mí. Recuerda que nadie del pueblo podrá subir al monte». ");
INSERT INTO spaonbv_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Moisés anunció al pueblo todas las leyes y reglamentos que el Señor le había dado, y el pueblo respondió al unísono: «Obedeceremos todo lo que el Señor ha dicho». ");
INSERT INTO spaonbv_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Moisés escribió todo lo que el Señor le dijo. Al día siguiente, Moisés se levantó muy temprano y construyó un altar al pie del monte, con doce columnas alrededor, pues doce eran las tribus de Israel. ");
INSERT INTO spaonbv_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Entonces envió a algunos de los jóvenes a hacer holocaustos y a sacrificar ofrendas de paz al Señor. ");
INSERT INTO spaonbv_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Moisés tomó la mitad de la sangre de estos animales y la echó en grandes vasijas. La otra mitad la roció sobre el altar. ");
INSERT INTO spaonbv_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Después leyó al pueblo el libro que había escrito, el Libro del Pacto, que contenía todas las órdenes y leyes de Dios. Y el pueblo dijo nuevamente: ―Solemnemente prometemos obedecer todas las leyes del Señor. ");
INSERT INTO spaonbv_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Moisés tomó la sangre que estaba en las vasijas, roció con ella al pueblo, y dijo: ―Esta sangre confirma y sella el pacto que el Señor ha hecho con ustedes, al darles estas leyes. ");
INSERT INTO spaonbv_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Moisés, Aarón, Nadab, Abiú y los setenta ancianos de Israel subieron al monte ");
INSERT INTO spaonbv_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","y vieron al Dios de Israel parado sobre una especie de pavimento hecho con piedras de zafiro, tan puro como el cielo. ");
INSERT INTO spaonbv_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Y aunque los ancianos pudieron contemplar a Dios, y comer y beber con él, no murieron, pues él no usó su poder para destruirlos. ");
INSERT INTO spaonbv_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","El Señor le dijo a Moisés: «Sube al monte, donde estoy, y quédate hasta que yo te dé las leyes y los mandamientos que he grabado en tablas de piedra, para que puedas enseñárselos al pueblo». ");
INSERT INTO spaonbv_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Moisés y Josué, su ayudante, subieron al monte de Dios. ");
INSERT INTO spaonbv_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Antes de subir, Moisés les dijo a los ancianos: «Quédense aquí y espérennos hasta que regresemos. Si hay problemas mientras estamos ausentes, consulten con Aarón y Jur». ");
INSERT INTO spaonbv_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Cuando Moisés subió, una nube cubrió el monte. ");
INSERT INTO spaonbv_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","La gloria del Señor reposó sobre el monte Sinaí. La nube cubrió el monte por seis días, y al séptimo día Dios llamó a Moisés desde la nube. ");
INSERT INTO spaonbv_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Los que estaban al pie del monte tuvieron una visión sobrecogedora. La gloria del Señor sobre la cumbre del monte parecía un fuego abrasador. ");
INSERT INTO spaonbv_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Y Moisés desapareció en la nube que cubría el monte, y estuvo allí cuarenta días y cuarenta noches. ");
INSERT INTO spaonbv_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","El Señor le dijo a Moisés: ");
INSERT INTO spaonbv_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","«Dile al pueblo de Israel que el que quiera hacerme una ofrenda, puede traerme ");
INSERT INTO spaonbv_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","cualquiera de las siguientes cosas: oro, plata, bronce, ");
INSERT INTO spaonbv_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","tela azul, morada o escarlata, lino fino, pelo de cabra, ");
INSERT INTO spaonbv_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","pieles de carnero teñidas de rojo, pieles de cabra, madera de acacia, ");
INSERT INTO spaonbv_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","aceite de oliva para las lámparas, especias para el aceite de la unción y para el incienso perfumado, ");
INSERT INTO spaonbv_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","piedras de ónice y piedras finas para colocarlas en el efod y el pectoral. ");
INSERT INTO spaonbv_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Quiero que el pueblo de Israel me haga un santuario donde pueda habitar en medio de ellos. ");
INSERT INTO spaonbv_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Mi santuario será una tienda, un tabernáculo. Yo te daré el diseño de la construcción y los detalles de todos los utensilios. ");
INSERT INTO spaonbv_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","»Harás un cofre de madera de acacia, de un metro y diez centímetros de largo, por setenta centímetros de ancho y setenta de alto. ");
INSERT INTO spaonbv_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Lo recubrirás por dentro y por fuera con oro puro, y le pondrás una moldura de oro. ");
INSERT INTO spaonbv_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Harás cuatro argollas de oro y se las pondrás en las cuatro esquinas inferiores, dos por cada costado. ");
INSERT INTO spaonbv_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","14","También harás unas varas de madera de acacia cubiertas de oro, y las pasarás por las argollas de los costados, para transportarlo. ");
INSERT INTO spaonbv_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Estas varas nunca serán sacadas de las argollas. ");
INSERT INTO spaonbv_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Cuando el cofre esté terminado, colocarás dentro de él las tablas que yo te daré con los Diez Mandamientos grabados en ellas. ");
INSERT INTO spaonbv_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","»También le harás al cofre una cubierta de oro puro de un metro y diez centímetros de largo, por setenta centímetros de ancho. ");
INSERT INTO spaonbv_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Harás también dos querubines de oro, trabajados a martillo, y los colocarás a los dos extremos de la cubierta del cofre. ");
INSERT INTO spaonbv_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Tanto la tapa del cofre como los dos querubines serán hechos de una sola pieza. ");
INSERT INTO spaonbv_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Los querubines estarán uno frente al otro, mirando hacia el centro de la tapa del cofre, y tendrán sus alas extendidas sobre la cubierta de oro. ");
INSERT INTO spaonbv_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Pondrás la cubierta sobre el cofre y dentro pondrás las tablas de piedra que yo te daré. ");
INSERT INTO spaonbv_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Y me encontraré contigo allí, y conversaré contigo exactamente entre los dos querubines; y el cofre contendrá las leyes de mi pacto. Allí te diré los mandamientos que he promulgado para el pueblo de Israel. ");
INSERT INTO spaonbv_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","»Luego harás una mesa de madera de acacia, de noventa centímetros de largo, cuarenta y cinco de ancho y setenta de alto. ");
INSERT INTO spaonbv_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","La cubrirás con oro puro y le harás una moldura de oro alrededor. ");
INSERT INTO spaonbv_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Le harás un borde de siete centímetros y medio de ancho. Alrededor del borde le pondrás una moldura de oro. ");
INSERT INTO spaonbv_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","27","Harás cuatro argollas de oro y las pondrás en los costados, junto a las cuatro patas, cerca de la parte superior. Por ellas pasarán las varas que servirán para transportar la mesa. ");
INSERT INTO spaonbv_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Las varas las harás de madera de acacia, recubiertas de oro. ");
INSERT INTO spaonbv_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","También harás tazones de oro, platos, cucharas, jarros y tazas para las ofrendas de líquidos. ");
INSERT INTO spaonbv_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Sobre la mesa pondrás el pan de la Presencia, el cual deberá permanecer continuamente delante de mí. ");
INSERT INTO spaonbv_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","»Harás un candelabro de oro puro, fundido y martillado. Todo el candelabro y sus decorados estarán hechos de una sola pieza: la base, el tallo, los cálices, las copas y las flores. ");
INSERT INTO spaonbv_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","De cada lado del candelabro central saldrán tres brazos, ");
INSERT INTO spaonbv_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","cada uno de los cuales estará decorado con cálices en forma de flor de almendro. ");
INSERT INTO spaonbv_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","35","El candelabro central también estará decorado con cuatro cálices en forma de flor de almendro, con sus capullos y flores. Cada uno será colocado debajo de cada juego de brazos. ");
INSERT INTO spaonbv_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Estos adornos, los brazos y el candelabro central, serán de una pieza de oro martillado. ");
INSERT INTO spaonbv_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","»Harás siete lámparas para el candelabro, y las pondrás de modo que alumbren hacia adelante. ");
INSERT INTO spaonbv_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Sus despabiladeras y sus platillos serán también de oro puro. ");
INSERT INTO spaonbv_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Necesitarás unos treinta y tres kilos de oro fino para el candelabro y todos sus accesorios. ");
INSERT INTO spaonbv_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","»Ten cuidado de hacer todo siguiendo el modelo que te he mostrado aquí en el monte. ");
INSERT INTO spaonbv_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","»Harás el santuario con diez cortinas de lino fino retorcido, teñidas de azul, morado y escarlata; en ellas bordarás figuras de querubines. ");
INSERT INTO spaonbv_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Las medidas serán de doce metros y medio de largo y un metro con ochenta de ancho. Todas las cortinas tendrán las mismas medidas. ");
INSERT INTO spaonbv_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Las unirás por sus extremos, de cinco en cinco, para formar dos cortinas largas, una para cada lado. ");
INSERT INTO spaonbv_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","5","Estarán unidas por medio de ojales de color morado, cincuenta a cada lado. ");
INSERT INTO spaonbv_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Harás cincuenta corchetes de oro para unir los ojales de los dos conjuntos de cortinas, de modo que el santuario, que es la morada de Dios, sea un todo. ");
INSERT INTO spaonbv_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","8","»El techo del santuario estará hecho de lonas de pelo de cabra. Harás once de estas lonas, cada una de trece metros y medio de largo y un metro ochenta de ancho. ");
INSERT INTO spaonbv_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Unirás cinco lonas para una parte y seis para la otra. La sexta lona colgará al frente de la tienda. ");
INSERT INTO spaonbv_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","11","Usarás cincuenta ojales en los bordes de cada una de estas piezas, para unirlas con cincuenta corchetes de bronce. De esta manera las dos piezas formarán una sola. ");
INSERT INTO spaonbv_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Sobrará medio metro de estas lonas, el cual colgará en la parte posterior del santuario, ");
INSERT INTO spaonbv_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","y medio metro por la parte frontal. ");
INSERT INTO spaonbv_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Sobre estas lonas colocarás una cubierta de cueros de carnero, teñida de rojo, y sobre esta cubierta colocarás otra de pieles de cabras. Esto completará el techo. ");
INSERT INTO spaonbv_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","16","»El armazón del santuario estará hecho de madera de acacia. Cada pieza será de cuatro metros y medio de largo por setenta centímetros de ancho. Irán en posición vertical ");
INSERT INTO spaonbv_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","y se unirán con espigas por los costados. ");
INSERT INTO spaonbv_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","19","Con veinte de estas tablas formarás el costado sur del santuario, sobre cuarenta bases de plata, dos bases para cada tabla. ");
INSERT INTO spaonbv_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","En el costado norte también habrá veinte de estas tablas ");
INSERT INTO spaonbv_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","con sus cuarenta bases de plata, dos bases por cada tabla, una debajo de cada esquina. ");
INSERT INTO spaonbv_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","En el costado occidental habrá seis tablas, ");
INSERT INTO spaonbv_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","y dos más en cada esquina. ");
INSERT INTO spaonbv_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Estas tablas estarán unidas de las esquinas mediante ganchos, abajo y arriba. ");
INSERT INTO spaonbv_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","De modo que serán ocho tablas en ese extremo, con dieciséis bases de plata para las tablas, dos bases por cada tabla. ");
INSERT INTO spaonbv_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","27","»Harás cinco travesaños de madera de acacia para cada costado del santuario, y cinco para las tablas de la parte occidental. ");
INSERT INTO spaonbv_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Uno de los travesaños centrales pasará por el centro de las tablas a todo lo largo del santuario. ");
INSERT INTO spaonbv_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Cubrirás las tablas de oro, y harás argollas de oro por donde pasen los travesaños. También cubrirás los travesaños con oro. ");
INSERT INTO spaonbv_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Construirás el santuario como yo te he mostrado en el monte. ");
INSERT INTO spaonbv_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","»Dentro del santuario harás una cortina de tela azul, morada y escarlata, de lino fino torcido, con querubines bordados en ella. ");
INSERT INTO spaonbv_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","La colgarás de cuatro postes de acacia cubiertos de oro, cada una con un gancho de oro. Los postes estarán asentados en cuatro bases de plata. ");
INSERT INTO spaonbv_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Colgarás la cortina de los ganchos. Detrás de esta cortina pondrás el cofre que contiene las tablas de piedra donde están grabadas las leyes de Dios. La cortina separará el Lugar Santo del Lugar Santísimo. ");
INSERT INTO spaonbv_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Sobre el cofre, que estará en el Lugar Santísimo, pondrás el propiciatorio, es decir, la cubierta de oro del cofre. ");
INSERT INTO spaonbv_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","La mesa y el candelabro los pondrás frente a frente en la parte exterior de la cortina. El candelabro estará en la parte sur del Lugar Santo, y la mesa en el costado norte. ");
INSERT INTO spaonbv_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","»Para la entrada del santuario harás otra cortina de lino fino torcido de color azul, morado y escarlata, bordada artísticamente. ");
INSERT INTO spaonbv_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Colgarás esta cortina de cinco postes de madera de acacia cubiertos de oro, con un gancho de oro y base de bronce para cada columna. ");
INSERT INTO spaonbv_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","»Con madera de acacia harás un altar cuadrado, de dos metros y medio por lado, y de un metro y medio de alto. ");
INSERT INTO spaonbv_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","En cada esquina del altar pondrás un cuerno firmemente unido; y todo estará cubierto de bronce. ");
INSERT INTO spaonbv_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Los recipientes para las cenizas, las palas, las vasijas y los braseros serán de bronce. ");
INSERT INTO spaonbv_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Harás un enrejado de bronce, con una argolla de metal en cada esquina, ");
INSERT INTO spaonbv_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","y lo colocarás debajo de la cubierta del altar, de modo que llegue a la mitad de la altura. ");
INSERT INTO spaonbv_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Para mover el altar harás varas de madera de acacia, cubiertas de bronce. ");
INSERT INTO spaonbv_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Para transportar el altar pondrás las varas en las argollas que tiene a cada costado. ");
INSERT INTO spaonbv_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","El altar será hueco, hecho de tablas, como te fue mostrado en el monte. ");
INSERT INTO spaonbv_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","10","»Luego harás un atrio para el santuario, el cual estará encerrado con cortinas hechas de lino fino torcido. En el costado sur, las cortinas se extenderán a lo largo de cuarenta y cinco metros y estarán suspendidas de veinte postes, asentados sobre veinte bases de bronce. Las cortinas estarán sujetas por medio de ganchos y varillas de plata, unidos a los postes. ");
INSERT INTO spaonbv_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","El costado norte será igual: cortinas a lo largo de cuarenta y cinco metros, colgadas de veinte postes asentados sobre bases de bronce y sujetas con ganchos y varillas de plata. ");
INSERT INTO spaonbv_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","El costado occidental del atrio será de veintidós metros y medio, con diez postes y diez bases. ");
INSERT INTO spaonbv_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","El lado oriental también será de veintidós metros y medio. ");
INSERT INTO spaonbv_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","15","A cada costado de la entrada habrá siete metros de cortinas, con tres postes y tres bases en cada lado. ");
INSERT INTO spaonbv_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","»La entrada del atrio tendrá una cortina de nueve metros de largo, hecha de lino fino torcido, teñido de azul, morado y escarlata, y bordada en forma artística. Estará colgada de cuatro postes asentados sobre cuatro bases. ");
INSERT INTO spaonbv_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Todos los postes alrededor del atrio estarán unidos por medio de barras de plata, montadas en ganchos de plata. Los postes estarán asentados sobre bases de bronce. ");
INSERT INTO spaonbv_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Todo el atrio será de cuarenta y cinco metros de largo y veintidós y medio de ancho, y las cortinas serán de dos metros y medio de alto, hechas de lino fino torcido. ");
INSERT INTO spaonbv_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","»Todos los utensilios que se necesiten en el santuario, incluyendo todas las estacas y los clavos, serán de bronce. ");
INSERT INTO spaonbv_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","»Pide al pueblo de Israel que te traiga aceite puro de oliva, para usarlo en las lámparas del santuario, de modo que se mantengan siempre encendidas. ");
INSERT INTO spaonbv_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Aarón y sus hijos colocarán las lámparas en el Lugar Santo, y las mantendrán encendidas delante del Señor día y noche. Esta será una norma permanente para el pueblo de Israel. ");
INSERT INTO spaonbv_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","»Consagra a tu hermano Aarón y a sus hijos Nadab, Abiú, Eleazar e Itamar, para que me sirvan como sacerdotes y ministros. ");
INSERT INTO spaonbv_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Hazle vestiduras especiales a Aarón, para indicar que está separado para el servicio de Dios, vestiduras hermosas que señalen la dignidad de su oficio. ");
INSERT INTO spaonbv_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Ordena a quienes he dotado de capacidad para ello, que le hagan vestiduras que lo distingan de los demás, para que pueda desempeñar el oficio de sacerdote. ");
INSERT INTO spaonbv_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Estas son las vestiduras que harán: un pectoral, un efod, un manto, una túnica bordada, una mitra y un cinturón. También harán vestiduras especiales para los hijos de Aarón. ");
INSERT INTO spaonbv_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","6","»El efod será una gran obra de arte, en la que usarán hilos de oro e hilos de lino fino de color azul, morado y escarlata. ");
INSERT INTO spaonbv_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Consistirá de dos piezas que se unirán sobre los hombros. ");
INSERT INTO spaonbv_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","El cinto estará hecho del mismo material, hilos de oro e hilos de lino fino torcido de color azul, morado y escarlata. ");
INSERT INTO spaonbv_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Tomarán dos piedras de ónice y grabarán en ellas los nombres de las tribus de Israel. ");
INSERT INTO spaonbv_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Habrá seis nombres en cada piedra, dispuestos según el orden de su nacimiento. ");
INSERT INTO spaonbv_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Cuando graben estos nombres, deberán usar la misma técnica que se usa para hacer un sello, y montarán las piedras en oro. ");
INSERT INTO spaonbv_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Deberán montar las dos piedras sobre las hombreras del efod, como piedras de recuerdo para Israel: Aarón llevará sus piedras delante del Señor, como un recuerdo constante. ");
INSERT INTO spaonbv_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","14","Harán dos cadenas de oro puro, trenzadas en forma de cordón, la cuales se unirán con enlaces de oro, sobre las hombreras del efod. ");
INSERT INTO spaonbv_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","»Luego, con gran esmero harán el pectoral, para que sea usado para impartir justicia. Usa hilos de oro y de lino fino torcido de color azul, morado y escarlata, como en el efod. ");
INSERT INTO spaonbv_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Será cuadrado, y estará hecho de dos pedazos de tela que formarán una bolsa de veinte centímetros de lado. ");
INSERT INTO spaonbv_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Pondrás cuatro hileras de piedras. En la primera hilera habrá un rubí, un topacio y una esmeralda. ");
INSERT INTO spaonbv_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","En la segunda hilera, una turquesa, un zafiro y un diamante. ");
INSERT INTO spaonbv_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","En la tercera, un jacinto, un ágata y una amatista. ");
INSERT INTO spaonbv_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","En la cuarta, un berilo, un ónice y un jaspe. Todas estarán engastadas en oro. ");
INSERT INTO spaonbv_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Cada piedra representará una tribu de Israel, y el nombre de cada tribu será grabado en cada piedra como un sello. ");
INSERT INTO spaonbv_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","24","»Unirás la parte superior del pectoral al efod por medio de dos cordones trenzados de oro puro. Un cabo de cada cordón estará atado a un anillo de oro colocado en la parte superior del pectoral. ");
INSERT INTO spaonbv_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Los otros extremos de los dos cordones serán atados a la parte delantera de los engastes de las piedras de ónice, que estarán sobre las hombreras del efod. ");
INSERT INTO spaonbv_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Harás dos anillos de oro y los colocarás en las partes interiores e inferiores del pectoral. ");
INSERT INTO spaonbv_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Además, harás dos anillos de oro para fijarlos en la parte delantera de las dos hombreras del efod, a la altura del cinto. ");
INSERT INTO spaonbv_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Fijarás la parte inferior del pectoral a los anillos del efod por medio de cintas azules. Esto evitará que el pectoral se separe del efod. ");
INSERT INTO spaonbv_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","De esta manera, Aarón llevará los nombres de las tribus de Israel en el pectoral, sobre su corazón, cuando entre al Lugar Santo. Así el Señor los recordará continuamente. ");
INSERT INTO spaonbv_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Dentro del pectoral pondrás el urim y el tumim, para que Aarón los lleve junto a su corazón cuando entre en la presencia del Señor. De esta manera llevará siempre, junto a su corazón, el urim y el tumim que le servirán para impartir justicia. ");
INSERT INTO spaonbv_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","»El manto del efod será hecho con tela de color morado, ");
INSERT INTO spaonbv_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","con una abertura para la cabeza. Tendrá un borde tejido alrededor de la abertura, como refuerzo. Será como el que se hace en el cuello de un chaleco, para que no se rompa fácilmente. ");
INSERT INTO spaonbv_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","34","El borde inferior del efod estará bordado con granadas de color azul, morado y escarlata, que se alternarán con campanillas de oro. ");
INSERT INTO spaonbv_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Aarón usará el efod siempre que entre a servir delante del Señor. Las campanillas sonarán cada vez que él entre y salga de la presencia del Señor en el Lugar Santo, para que no muera. ");
INSERT INTO spaonbv_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","»Además, harás una lámina de oro puro y grabarás en ella: dedicado al Señor, como se hace con un sello. ");
INSERT INTO spaonbv_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","38","Esta lámina estará atada con una cinta morada a la parte delantera de la mitra. Aarón la llevará siempre sobre la frente, para que el Señor acepte las ofrendas de los israelitas, pues él cargará con los pecados que el pueblo cometa al presentar sus ofrendas. Así el Señor les perdonará y aceptará sus ofrendas. ");
INSERT INTO spaonbv_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","»Tejerás la túnica de Aarón de lino fino, y también del mismo lino harás la mitra y un cinto bordado. ");
INSERT INTO spaonbv_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","»Para los hijos de Aarón harás túnicas, cintos y mitras que les den un aspecto honorable y respetable. ");
INSERT INTO spaonbv_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Les pondrás a Aarón y a sus hijos estas vestiduras y luego los dedicarás al ministerio, ungiéndolos en la cabeza con aceite de oliva y santificándolos como sacerdotes y ministros míos. ");
INSERT INTO spaonbv_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","También les harás calzoncillos de lino, que usarán debajo de la túnica, pegados a su cuerpo, que les lleguen desde la cadera hasta las rodillas. ");
INSERT INTO spaonbv_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Aarón y sus hijos los usarán cada vez que entren en el santuario, al altar del Lugar Santo, para que no incurran en falta y, por esto, mueran. Esta es una ordenanza permanente para Aarón y sus hijos. ");
INSERT INTO spaonbv_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","»Esta es la ceremonia para la dedicación de Aarón y sus hijos como sacerdotes: Tomarás un becerro y dos carneros sin defectos, ");
INSERT INTO spaonbv_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","pan y tortas sin levadura, pasados por aceite, y hojaldres sin levadura, sobre los que se haya rociado aceite. Los diversos tipos de pan estarán hechos de harina fina. ");
INSERT INTO spaonbv_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","4","Colocarás el pan en un canasto y lo llevarás a la entrada del santuario, junto con el becerro y los dos carneros. »Bañarás a Aarón y a sus hijos allí a la entrada. ");
INSERT INTO spaonbv_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Luego vestirás a Aarón con su túnica, el efod, el pectoral y el cinto, ");
INSERT INTO spaonbv_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","y le pondrás en la cabeza la mitra con la lámina de oro. ");
INSERT INTO spaonbv_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Tomarás el aceite de la unción y lo derramarás sobre su cabeza. ");
INSERT INTO spaonbv_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Después vestirás a sus hijos con sus túnicas ");
INSERT INTO spaonbv_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","y sus cintos tejidos, y les pondrás las mitras. Serán sacerdotes para siempre. De esa manera consagrarás a Aarón y a sus hijos. ");
INSERT INTO spaonbv_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","»Traerás el becerro al santuario, y Aarón y sus hijos pondrán sus manos sobre la cabeza del animal. ");
INSERT INTO spaonbv_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Lo matarás delante del Señor, a la entrada del santuario. ");
INSERT INTO spaonbv_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Pondrás su sangre sobre los cuernos del altar, mojándolos con el dedo, y derramarás el resto en la base del altar. ");
INSERT INTO spaonbv_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Tomarás toda la grasa que cubre los intestinos y el hígado, así como los dos riñones y la grasa que hay sobre ellos, y los quemarás sobre el altar. ");
INSERT INTO spaonbv_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Después tomarás el cuerpo, incluyendo la piel y el excremento, los llevarás fuera del campamento y los quemarás como una ofrenda por el pecado. ");
INSERT INTO spaonbv_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","16","»Luego Aarón y sus hijos pondrán sus manos sobre la cabeza de uno de los carneros que va a ser sacrificado. Su sangre será recogida para ser rociada sobre el altar. ");
INSERT INTO spaonbv_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Cortarás el carnero en pedazos, y lavarás los intestinos y las piernas; lo pondrás con la cabeza y las demás partes del cuerpo ");
INSERT INTO spaonbv_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","y lo quemarás sobre el altar. Este es un holocausto de muy grato olor para el Señor. ");
INSERT INTO spaonbv_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","20","»Luego tomarás el otro carnero, y Aarón y sus hijos le pondrán las manos sobre la cabeza mientras lo sacrifican. Tomarás un poco de la sangre y la untarás en el lóbulo de la oreja derecha y en los pulgares de la mano derecha y del pie derecho de Aarón y de sus hijos; con el resto rociarás el altar. ");
INSERT INTO spaonbv_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","También tomarás sangre del altar, la mezclarás con aceite de la unción, y rociarás esto sobre Aarón, sus hijos y sus vestiduras. En esta forma ellos serán consagrados al Señor, junto con sus vestiduras. ");
INSERT INTO spaonbv_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","»Luego, toma del carnero la grasa, la cola, la grasa que cubre los intestinos y el hígado, los dos riñones y la grasa que los rodea, y la espaldilla derecha, porque este es el carnero para la ordenación de Aarón y sus hijos. ");
INSERT INTO spaonbv_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Toma también un pan, una torta de pan de aceite y un hojaldre del canastillo de panes sin levadura, que fue puesto delante del Señor, ");
INSERT INTO spaonbv_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","y ponlos en las manos de Aarón y de sus hijos, quienes los ofrecerán meciéndolos ante el Señor. ");
INSERT INTO spaonbv_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Luego ellos te entregarán todos estos productos, para que tú los quemes sobre el altar, como holocausto de olor delante del Señor. ");
INSERT INTO spaonbv_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Después tomarás el pecho del carnero de la ordenación de Aarón y lo ofrecerás, meciéndolo delante del Señor. Esta parte del animal será para ti. ");
INSERT INTO spaonbv_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","»Les darás el pecho y la espadilla del carnero de la consagración ");
INSERT INTO spaonbv_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","a Aarón y a sus hijos. El pueblo de Israel siempre debe dar esta porción de sus sacrificios de paz a Aarón y a sus hijos, como contribución. ");
INSERT INTO spaonbv_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","»Las vestiduras sagradas de Aarón serán preservadas para los hijos que le sucedan de generación en generación, en la ceremonia en que sean consagrados como sacerdotes. ");
INSERT INTO spaonbv_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Cualquiera que sea el sumo sacerdote que suceda a Aarón, deberá usar estas vestiduras durante siete días, al entrar al santuario para ministrar en el Lugar Santo. ");
INSERT INTO spaonbv_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","»Tomarás el carnero de la consagración, el carnero usado en la ceremonia ordinaria, y cocerás su carne en un lugar santificado. ");
INSERT INTO spaonbv_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Aarón y sus hijos comerán la carne y el pan del canasto en la puerta del santuario. ");
INSERT INTO spaonbv_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Sólo ellos comerán estas cosas usadas en su expiación, es decir, en la ceremonia de su consagración. El hombre común no comerá de ello, porque estas cosas son sagradas. ");
INSERT INTO spaonbv_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Deberás quemar el pan o la carne que sobre. Lo que sobre no podrá ser comido al día siguiente, porque es sagrado. ");
INSERT INTO spaonbv_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","»Este, pues, es el modo de ordenar a Aarón y a sus hijos para el desempeño de sus funciones. Esta ordenación durará siete días. ");
INSERT INTO spaonbv_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Cada día sacrificarás un becerro como ofrenda expiatoria por el pecado. Después purificarás el altar, haciendo expiación por él y derramando aceite de oliva sobre él para consagrarlo. ");
INSERT INTO spaonbv_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Harás expiación por el altar y lo consagrarás a Dios cada uno de los siete días. Después de esto, el altar será muy santo, y cualquiera que lo toque será apartado para el Señor. ");
INSERT INTO spaonbv_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","»Cada día ofrecerás dos corderos de un año sobre el altar, ");
INSERT INTO spaonbv_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","uno en la mañana y otro en la tarde. ");
INSERT INTO spaonbv_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Con uno de ellos ofrecerás dos kilos de harina fina, mezclada con un litro de aceite de oliva y un litro de vino, para la libación. ");
INSERT INTO spaonbv_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Ofrecerás el otro cordero en la tarde, junto con la harina y el vino para la libación, como se hizo en la mañana, como ofrenda de olor fragante al Señor. ");
INSERT INTO spaonbv_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","»Esta será una ofrenda diaria que me ofrecerán todos los israelitas, a través de todas sus generaciones. Me la ofrecerán a la entrada del santuario, que es el lugar donde me encontraré contigo y te hablaré. ");
INSERT INTO spaonbv_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Allí me reuniré con el pueblo de Israel, y el santuario será santificado por mi gloria. ");
INSERT INTO spaonbv_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Yo santificaré el santuario y el altar, y a Aarón y a sus hijos, que son mis ministros, mis sacerdotes. ");
INSERT INTO spaonbv_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Viviré en medio del pueblo de Israel y seré su Dios, ");
INSERT INTO spaonbv_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","y ellos sabrán que yo soy el Señor su Dios. Yo los saqué de Egipto para vivir entre ellos. Yo soy el Señor su Dios. ");
INSERT INTO spaonbv_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","»Harás luego un pequeño altar para quemar incienso. Lo harás de madera de acacia. ");
INSERT INTO spaonbv_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Tendrá cuarenta y cinco centímetros de ancho, cuarenta y cinco centímetros de largo y noventa centímetros de alto. Tallarás sus cuernos de la misma pieza, para que sean parte del altar. ");
INSERT INTO spaonbv_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Cubrirás la parte superior, los costados y los cuernos del altar con oro puro, y en todo su contorno pondrás una moldura de oro. ");
INSERT INTO spaonbv_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Bajo la moldura, a ambos costados, harás dos argollas de oro para poner las varas que servirán para transportarlo. ");
INSERT INTO spaonbv_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Las varas serán de madera de acacia, cubiertas de oro. ");
INSERT INTO spaonbv_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Pondrás el altar junto a la cortina, por el lado exterior, cerca de la tapa que cubre el cofre que contiene los Diez Mandamientos. Allí es donde me encontraré contigo. ");
INSERT INTO spaonbv_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","»Cada mañana, cuando Aarón prepare las lámparas, quemará incienso aromático sobre el altar, ");
INSERT INTO spaonbv_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","y cada tarde cuando encienda las lámparas, quemará el incienso delante del Señor. Esto se hará de generación en generación. ");
INSERT INTO spaonbv_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","No ofrecerás incienso, holocaustos, ofrendas ni libaciones que no hayan sido autorizados por el Señor. ");
INSERT INTO spaonbv_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","»Una vez al año, Aarón deberá consagrar el altar, poniendo sobre los cuernos la sangre de la ofrenda de expiación por el pecado. Esta será una ceremonia que se hará sin falta cada año, de generación en generación, porque este es el altar que ha sido consagrado por completo al Señor». ");
INSERT INTO spaonbv_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","12","El Señor le dijo a Moisés: «Siempre que hagas un censo del pueblo de Israel, cada hombre que sea contado dará un rescate al Señor por su persona, para que no haya plaga en el pueblo cuando tú lo cuentes. ");
INSERT INTO spaonbv_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Este pago equivaldrá a medio siclo del santuario, es decir, seis gramos de plata. ");
INSERT INTO spaonbv_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Todos los que hayan cumplido veinte años darán esta ofrenda. ");
INSERT INTO spaonbv_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","El rico no dará más, ni el pobre dará menos, porque es una ofrenda para el Señor, para hacer expiación por ustedes mismos. ");
INSERT INTO spaonbv_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Usarás este dinero para el cuidado del Santuario. Esto servirá para que el Señor recuerde que los israelitas pagaron el dinero del rescate, y para hacer expiación por ellos». ");
INSERT INTO spaonbv_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","18","El Señor le dijo a Moisés: «Harás un lavamanos de bronce, con una base de bronce. Lo pondrás entre el Santuario y el altar, y lo llenarás de agua. ");
INSERT INTO spaonbv_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Aarón y sus hijos se lavarán las manos y los pies allí ");
INSERT INTO spaonbv_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","cuando entren al Santuario a presentarse delante del Señor, o cuando se acerquen al altar para presentar holocausto delante del Señor. Siempre deberán lavarse antes de hacer esto, o morirán. ");
INSERT INTO spaonbv_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Estas son instrucciones para Aarón y sus hijos, de generación en generación». ");
INSERT INTO spaonbv_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","23","Entonces el Señor le dijo a Moisés: «Toma las siguientes especias: seis kilos de mirra pura, tres kilos de canela, tres kilos de cálamo aromático, ");
INSERT INTO spaonbv_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","seis kilos de casia y cuatro litros de aceite de oliva. Para esto, deberás usar la medida que se usa en el santuario. ");
INSERT INTO spaonbv_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Con estos ingredientes prepararás el aceite, tal como lo hacen los expertos en preparar perfumes. Este será el aceite santo de la unción. ");
INSERT INTO spaonbv_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","27","»Usarás este aceite para ungir el santuario, la mesa y todos sus instrumentos, el candelabro y todos sus utensilios, el altar del incienso, ");
INSERT INTO spaonbv_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","el altar del holocausto con todos sus instrumentos, y el lavamanos con su base. ");
INSERT INTO spaonbv_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Conságralos para que sean sagrados. Cualquier cosa que los toque será sagrada. ");
INSERT INTO spaonbv_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","También lo usarás para ungir a Aarón y a sus hijos, consagrándolos para que puedan servir delante de mí como sacerdotes. ");
INSERT INTO spaonbv_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Y dile al pueblo de Israel: “Este será siempre mi aceite de unción. ");
INSERT INTO spaonbv_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","No debe ser derramado sobre personas comunes, y no harás jamás este aceite por tu cuenta, porque es sagrado y será tratado por ti como algo sagrado. ");
INSERT INTO spaonbv_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Cualquiera que prepare un aceite semejante a este o lo ponga sobre alguien que no sea un sacerdote, será expulsado de la comunidad”». ");
INSERT INTO spaonbv_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Estas fueron las instrucciones que el Señor le dio a Moisés acerca del incienso: «Tomarás cantidades iguales de aromas: resina, uña aromática, gálbano e incienso puro, ");
INSERT INTO spaonbv_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","y, según las técnicas del perfumista, harás un perfume sazonado con sal. Será un incienso puro y santo. ");
INSERT INTO spaonbv_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Molerás una parte y la pondrás frente al cofre, donde yo me reúno contigo en el santuario. Este incienso es muy sagrado. ");
INSERT INTO spaonbv_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","No lo hagan jamás para ustedes mismos, porque está reservado para el Señor, y deben tratarlo como cosa sagrada. ");
INSERT INTO spaonbv_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Cualquiera que lo haga será expulsado de la comunidad». ");
INSERT INTO spaonbv_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","También el Señor le dijo a Moisés: ");
INSERT INTO spaonbv_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","«Yo he designado a Bezalel hijo de Uri y nieto de Jur, de la tribu de Judá. ");
INSERT INTO spaonbv_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Lo he llenado con mi Espíritu y le he dado sabiduría, capacidad y habilidad para la construcción del santuario y todo lo que contiene. ");
INSERT INTO spaonbv_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Está altamente capacitado como diseñador artístico de objetos de oro, de plata y de bronce. ");
INSERT INTO spaonbv_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","También ha sido dotado como joyero y tallador de madera. ");
INSERT INTO spaonbv_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","»Igualmente, he designado a Aholiab hijo de Ajisamac, de la tribu de Dan, para que sea su ayudante. Además, he dado habilidad especial a todos los que son conocidos como expertos, para que puedan hacer todas las cosas que he ordenado, esto es, ");
INSERT INTO spaonbv_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","el santuario, el cofre con el propiciatorio sobre ella, todos los utensilios del templo, ");
INSERT INTO spaonbv_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","la mesa y sus utensilios, el candelabro de oro y sus utensilios, el altar del incienso, ");
INSERT INTO spaonbv_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","el altar del holocausto con sus utensilios, el lavamanos y su base, ");
INSERT INTO spaonbv_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","las hermosas y sagradas vestiduras sacerdotales de Aarón y de sus hijos, ");
INSERT INTO spaonbv_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","el aceite de la unción y el incienso perfumado para el Lugar Santo. Ellos seguirán exactamente las instrucciones que yo te he dado». ");
INSERT INTO spaonbv_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","13","El Señor le dio estas instrucciones a Moisés: «Dile al pueblo de Israel que observe mi día de descanso, porque el descanso es un recordatorio del pacto que hice con ustedes para siempre. Es para que recuerden que yo soy el Señor que los santifico. ");
INSERT INTO spaonbv_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","15","Descansarán en ese día, porque es santo. Cualquiera que no obedezca este mandamiento, morirá. Cualquiera que haga alguna clase de trabajo en ese día, será ejecutado. ");
INSERT INTO spaonbv_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Solamente trabajarán seis días, porque el día séptimo es el día de descanso solemne, santo para el Señor. Esta ley es un pacto perpetuo y una obligación para el pueblo de Israel. ");
INSERT INTO spaonbv_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Es un símbolo eterno del pacto que he hecho con el pueblo de Israel, porque en seis días yo, el Señor, hice el cielo y la tierra, y el séptimo día descansé». ");
INSERT INTO spaonbv_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Cuando terminó de hablar con Moisés sobre el monte Sinaí, Dios le entregó dos tablas de piedra con los Diez Mandamientos, escritos con su propio dedo. ");
INSERT INTO spaonbv_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Como Moisés se demoraba en descender del monte, el pueblo se presentó ante Aarón: ―Mira —le dijeron—, haznos dioses que nos dirijan, porque este Moisés que nos sacó de Egipto no aparece; algo debe de haberle ocurrido. ");
INSERT INTO spaonbv_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","3","―Tráiganme los aretes de oro que tengan sus esposas, hijos e hijas —respondió Aarón. Así que todos los que tenían aretes se los quitaron y se los entregaron a Aarón. ");
INSERT INTO spaonbv_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Entonces él fundió el oro, y con un cincel hizo un becerro. Al ver el becerro, el pueblo exclamó: «¡Israel, este es tu dios que te sacó de Egipto!». ");
INSERT INTO spaonbv_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Cuando Aarón vio lo feliz que estaba el pueblo con el becerro, edificó un altar delante del becerro, y anunció: ―Mañana habrá fiesta en honor del Señor. ");
INSERT INTO spaonbv_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","A la mañana siguiente madrugaron y comenzaron a presentar holocaustos y ofrendas de paz. Luego de comer y beber, se entregaron a la diversión. ");
INSERT INTO spaonbv_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Por eso, el Señor le dijo a Moisés: ―Date prisa, desciende, porque el pueblo que sacaste de Egipto se ha contaminado, ");
INSERT INTO spaonbv_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","y pronto han abandonado mis leyes. Han hecho un becerro y lo han adorado; le han ofrecido sacrificios y han dicho: “¡Israel, este es tu dios que te sacó de Egipto!”. ");
INSERT INTO spaonbv_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","El Señor añadió: ―He visto que este pueblo es rebelde y testarudo. ");
INSERT INTO spaonbv_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Deja que desate contra ellos mi ira y los destruya; y de ti, Moisés, haré otra nación grande. ");
INSERT INTO spaonbv_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Pero Moisés le rogó al Señor que no lo hiciera. ―Señor —suplicó—, ¿por qué se ha encendido tanto tu ira contra este tu pueblo, al que sacaste de Egipto con tu gran poder y tan grandes milagros? ");
INSERT INTO spaonbv_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","¿Quieres que los egipcios digan: “Dios los engañó y los hizo ir a las montañas para matarlos y borrarlos de la tierra”? Aparta tu ira y no le hagas eso a tu pueblo. ");
INSERT INTO spaonbv_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Recuerda lo que le prometiste a tus siervos Abraham, Isaac e Israel cuando juraste por ti mismo: “Yo multiplicaré tu descendencia como las estrellas del cielo, y les daré toda la tierra que he prometido a tus descendientes, y la heredarán para siempre”. ");
INSERT INTO spaonbv_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Entonces el Señor tuvo compasión de ellos y no los destruyó. ");
INSERT INTO spaonbv_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Luego Moisés descendió del monte, llevando en sus manos las dos tablas de piedra, en las que estaban escritos los mandamientos por ambos lados. ");
INSERT INTO spaonbv_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Dios mismo preparó las tablas y escribió en ellas. ");
INSERT INTO spaonbv_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Cuando Josué oyó el bullicio del pueblo que gritaba, le dijo a Moisés: ―Suena como si estuvieran preparándose para la guerra. ");
INSERT INTO spaonbv_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Pero Moisés le respondió: ―No es grito de victoria ni de derrota lo que yo oigo; lo que escucho son canciones. ");
INSERT INTO spaonbv_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Cuando llegaron cerca del campamento, Moisés vio el becerro y las danzas, y con terrible ira arrojó las tablas al suelo, al pie del monte, y se rompieron. ");
INSERT INTO spaonbv_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Luego tomó el becerro, lo fundió en fuego, y cuando se enfrió el metal, lo molió hasta hacerlo polvo. Mezcló ese polvo con agua, para que el pueblo bebiera. ");
INSERT INTO spaonbv_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Después se dirigió a Aarón, y le preguntó: ―¿Qué te ha hecho este pueblo, para que le hagas cometer este terrible pecado? ");
INSERT INTO spaonbv_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","―No te enojes tanto —dijo Aarón—. Tú bien sabes que este pueblo es inclinado a la maldad. ");
INSERT INTO spaonbv_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Ellos me dijeron. “Haznos un dios que nos dirija, porque algo le habrá ocurrido a Moisés, el que nos sacó de Egipto”. ");
INSERT INTO spaonbv_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Entonces les dije: “Tráiganme sus aretes”. Ellos me los trajeron, los eché al fuego… y ¡salió este becerro! ");
INSERT INTO spaonbv_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Cuando Moisés vio que Aarón no había podido guiar bien a los israelitas, y que por eso se habían vuelto locos, de tal modo que la gente de otros pueblos se estaban burlando de ellos, ");
INSERT INTO spaonbv_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","se paró a la entrada del campamento y gritó: «¡Todos los que estén de parte del Señor, vengan aquí y únanse a mí!». Entonces todos los levitas se acercaron. ");
INSERT INTO spaonbv_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Moisés les dijo: «El Señor, Dios de Israel, les ordena que tomen sus espadas y recorran el campamento, de uno a otro extremo, y maten a sus hermanos, parientes y vecinos». ");
INSERT INTO spaonbv_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Los levitas lo hicieron, y aquel día mataron a unos tres mil hombres. ");
INSERT INTO spaonbv_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Moisés, entonces, les dijo: «Hoy se han santificado para el servicio del Señor, porque han obedecido, aun cuando tuvieron que dar muerte a sus hijos y hermanos. Ahora el Señor les dará una gran bendición». ");
INSERT INTO spaonbv_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Al día siguiente, Moisés le dijo al pueblo: «Ustedes han cometido un gran pecado, pero yo regresaré a la montaña, y me presentaré delante del Señor, para interceder por ustedes. Quizá él quiera otorgarles el perdón». ");
INSERT INTO spaonbv_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Moisés regresó a la presencia del Señor, y le dijo: ―Desgraciadamente este pueblo ha pecado en gran manera y ha hecho ídolos de oro. ");
INSERT INTO spaonbv_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Sólo te ruego que perdones su pecado. Si no lo haces, te pido que borres mi nombre del libro que has escrito. ");
INSERT INTO spaonbv_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","―Cualquiera que haya pecado contra mí —dijo el Señor— será borrado. ");
INSERT INTO spaonbv_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Ahora ve y conduce al pueblo al lugar que yo te indiqué, y diles que mi ángel irá delante de ellos. Sin embargo, cuando yo visite a este pueblo, lo castigaré por sus pecados. ");
INSERT INTO spaonbv_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Luego el Señor envió una gran plaga al pueblo, porque habían adorado al becerro que Aarón les hizo. ");
INSERT INTO spaonbv_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","El Señor le dijo a Moisés: «Lleva a este pueblo que sacaste de Egipto a la tierra que prometí a Abraham, a Isaac y a Jacob, porque yo les prometí que les daría esta tierra a sus descendientes. ");
INSERT INTO spaonbv_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Enviaré un ángel delante de ti para que expulse a los cananeos, a los amorreos, a los hititas, a los ferezeos, a los heveos y a los jebuseos. ");
INSERT INTO spaonbv_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Es una tierra de la que fluye leche y miel. Pero yo no iré con ustedes, porque son un pueblo rebelde y soberbio, y no resistiré el deseo de destruirlos en el camino». ");
INSERT INTO spaonbv_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Cuando los israelitas oyeron estas duras palabras, se pusieron a llorar, y se despojaron de sus joyas y ornamentos, ");
INSERT INTO spaonbv_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","porque el Señor le había ordenado a Moisés que les dijera: «Ustedes son un pueblo rebelde y soberbio. Si estuviera con ustedes un momento, los exterminaría. Quítense las joyas y ornamentos hasta que decida lo que haré con ustedes». ");
INSERT INTO spaonbv_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Después de esto, ellos dejaron de usar joyas. ");
INSERT INTO spaonbv_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Moisés siempre levantaba, a cierta distancia del campamento, el santuario o Tienda de reunión con Dios. Todo el que quería consultar al Señor, iba allí. ");
INSERT INTO spaonbv_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Siempre que Moisés salía hacia la Tienda de reunión, el pueblo se levantaba y se paraba a la entrada de sus tiendas, y se quedaban mirando hasta que él entraba en la Tienda. ");
INSERT INTO spaonbv_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Cuando él entraba, la columna de nube descendía y cubría la entrada, mientras el Señor le hablaba. ");
INSERT INTO spaonbv_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Entonces todo el pueblo adoraba delante de sus tiendas, y se inclinaba ante la columna de nube. ");
INSERT INTO spaonbv_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","En la Tienda de reunión, el Señor le hablaba a Moisés cara a cara, como un hombre habla con su amigo. Después Moisés regresaba al campamento, pero el joven que le ayudaba, Josué hijo de Nun, nunca se alejaba de la Tienda de reunión. ");
INSERT INTO spaonbv_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Moisés un día habló allí con el Señor, y le dijo: ―Me has pedido que lleve a este pueblo a la Tierra prometida, pero no me has dicho a quién enviarás conmigo. Dices que eres mi amigo y que he hallado gracia delante de ti. ");
INSERT INTO spaonbv_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Si es así, te ruego que me indiques qué quieres que haga, para que pueda comprenderte claramente y saber que cuento con tu ayuda. No olvides que esta nación es tu pueblo. ");
INSERT INTO spaonbv_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Y el Señor respondió: ―Yo iré contigo y te daré descanso. ");
INSERT INTO spaonbv_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Moisés le dijo: ―Si no vas a ir con nosotros, no dejes que nos movamos ni un paso de este lugar. ");
INSERT INTO spaonbv_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Si no vas con nosotros, ¿quién sabrá que mi pueblo y yo contamos con tu ayuda, y que somos diferentes a los demás pueblos que habitan la tierra? ");
INSERT INTO spaonbv_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Entonces el Señor le respondió: ―Haré lo que tú has pedido, porque ciertamente cuentas con mi ayuda, y eres mi amigo. ");
INSERT INTO spaonbv_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Moisés, entonces, le dijo: ―¡Permíteme contemplar tu gloria! ");
INSERT INTO spaonbv_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Y el Señor le respondió: ―Haré que pase delante de ti mi gloria, y pronunciaré mi nombre, pues soy bondadoso y compasivo con quien quiero. ");
INSERT INTO spaonbv_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Pero no podrás ver mi rostro, porque ningún hombre podrá verme y seguir viviendo. ");
INSERT INTO spaonbv_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Sin embargo, quédate en esta roca que está junto a mí, ");
INSERT INTO spaonbv_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","y cuando pase mi gloria, yo te pondré en una hendidura de la roca y te cubriré con mi mano hasta que haya pasado. ");
INSERT INTO spaonbv_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Luego quitaré mi mano, y podrás verme la espalda, pero no el rostro. ");
INSERT INTO spaonbv_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","El Señor le dijo a Moisés: ―Prepara dos tablas de piedra como las primeras, y yo escribiré en ellas los mismos mandamientos que estaban en las tablas que quebraste. ");
INSERT INTO spaonbv_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Prepárate para subir a la cumbre del monte Sinaí, para presentarte ante mí. ");
INSERT INTO spaonbv_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Nadie vendrá contigo y nadie deberá estar en ningún lugar del monte. Ni dejes que los animales pasten junto al monte. ");
INSERT INTO spaonbv_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Moisés tomó dos tablas de piedra similares a las primeras, se levantó de madrugada y subió al monte Sinaí, tal como el Señor le había dicho, llevando las dos tablas de piedra en las manos. ");
INSERT INTO spaonbv_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","6","El Señor descendió en la forma de una columna de nube y estuvo allí con él, y pasó delante de él y anunció el significado de su nombre: ―Yo soy el Señor, Dios de misericordia y de gracia —dijo—. Soy lento para la ira y grande en misericordia y verdad. ");
INSERT INTO spaonbv_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Yo, el Señor, muestro este amor firme a millares que reciben el perdón de sus pecados; pero no doy por inocente al culpable, y exijo que el pecado del padre sea castigado en los hijos, en los nietos y aun en generaciones posteriores. ");
INSERT INTO spaonbv_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Moisés se postró delante del Señor, lo adoró ");
INSERT INTO spaonbv_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","y le dijo: ―Señor, si es cierto que cuento con tu favor, te ruego que vayas con nosotros a la Tierra prometida. Sí, el pueblo es rebelde y soberbio, pero perdona nuestros pecados y acéptanos como pueblo tuyo. ");
INSERT INTO spaonbv_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","El Señor le respondió: ―Bien, este es el pacto que voy a hacer contigo. Haré milagros como nunca han sido hechos en toda la tierra, y todo el pueblo de Israel verá mi poder, el terrible poder que mostraré por medio de ti. ");
INSERT INTO spaonbv_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Tu parte en este pacto es obedecer todos mis mandamientos. Entonces yo expulsaré de delante de ti a los amorreos, a los cananeos, a los hititas, a los ferezeos, a los heveos, y a los jebuseos. ");
INSERT INTO spaonbv_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","»Cuídate de hacer alianza con el pueblo que habita la tierra a donde vas, porque si lo haces, pronto andarás en sus malos caminos. ");
INSERT INTO spaonbv_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","En cambio, destruirás sus altares paganos, derribarás las piedras que adoran y destrozarás las imágenes de la diosa Aserá. ");
INSERT INTO spaonbv_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","No deben adorar otros dioses sino solamente a mí, porque yo, el Señor, soy un Dios celoso, que exige lealtad absoluta y devoción exclusiva. ");
INSERT INTO spaonbv_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","»No harás tratados de paz con los pueblos que viven en esa tierra, porque son idólatras que me han rechazado para ofrecer sacrificios a sus dioses. Si haces amistad con ellos, entonces, cuando presenten los sacrificios a sus dioses, te invitarán a participar, y te sentirás obligado a ir. ");
INSERT INTO spaonbv_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Y aceptarás para tus hijos a sus hijas, que adoran a otros dioses, y tus hijos me abandonarán, y adorarán a los dioses de sus esposas. ");
INSERT INTO spaonbv_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","No tendrás nada que ver con los ídolos. ");
INSERT INTO spaonbv_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","»Celebrarás la fiesta de los Panes sin levadura durante siete días, en la forma que te ordené, en la fecha señalada del mes de aviv. Este fue el mes en que saliste de Egipto. ");
INSERT INTO spaonbv_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","»Todo primer macho es mío: vacuno, lanar y cabrío. ");
INSERT INTO spaonbv_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","El primer burro podrá ser redimido, dando un cordero en su lugar. Pero si decides no redimirlo, deberás quebrarle el cuello. Todos tus hijos serán redimidos; ninguno se presentará delante de mí sin una ofrenda. ");
INSERT INTO spaonbv_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","»Aun durante el tiempo de la siembra y el de la cosecha, solamente trabajarás durante seis días y descansarás el séptimo. ");
INSERT INTO spaonbv_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","»Te acordarás de celebrar la fiesta de las Semanas, al comenzar la cosecha del trigo, y la fiesta de la Cosecha, al fin del año. ");
INSERT INTO spaonbv_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","»Todos los varones de Israel deberán presentarse ante mí tres veces al año. Yo soy el Señor, Dios de Israel. ");
INSERT INTO spaonbv_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Nadie atacará ni conquistará tu tierra mientras estés delante del Señor tu Dios, porque expulsaré a las naciones delante de ti y agrandaré tus fronteras. ");
INSERT INTO spaonbv_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","»No usarás panes con levadura en tus sacrificios, y no dejarás hasta el día siguiente la carne del cordero pascual. ");
INSERT INTO spaonbv_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","»Cada año deberás ofrecerme los mejores frutos de las primeras cosechas, y lo traerás a la casa del Señor tu Dios. »No cocinarás el cabrito en la leche de su madre». ");
INSERT INTO spaonbv_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","También el Señor le dijo a Moisés: ―Escribe estas leyes que te doy, porque son las condiciones del pacto que hice contigo y con Israel. ");
INSERT INTO spaonbv_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Moisés estuvo con el Señor en el monte durante cuarenta días y cuarenta noches; y en todo ese tiempo no comió ni bebió. Durante ese tiempo, Dios grabó el pacto, los Diez Mandamientos, sobre tablas de piedra. ");
INSERT INTO spaonbv_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Cuando Moisés descendió del monte con las tablas en la mano, no se dio cuenta de que su rostro resplandecía por haber estado en la presencia de Dios. ");
INSERT INTO spaonbv_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Debido al resplandor de su rostro, Aarón y el pueblo de Israel tuvieron miedo de acercarse. ");
INSERT INTO spaonbv_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Pero Moisés los llamó, y Aarón y todos los dirigentes de la congregación fueron y hablaron con él. ");
INSERT INTO spaonbv_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Después todo el pueblo se acercó, y él les dio los mandamientos que el Señor le había entregado en el monte. ");
INSERT INTO spaonbv_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Cuando Moisés acabó de hablar con ellos, se puso un velo en el rostro. ");
INSERT INTO spaonbv_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Pero cuando entraba en el santuario a hablar con el Señor, se quitaba el velo hasta que volvía a salir. Entonces comunicaba al pueblo toda instrucción que el Señor le hubiera dado, ");
INSERT INTO spaonbv_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","y el pueblo veía su rostro resplandeciente. Entonces Moisés se ponía de nuevo el velo, hasta que volvía al santuario a hablar con Dios. ");
INSERT INTO spaonbv_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Un día Moisés convocó a todos los israelitas, y les dijo: «Estas son las leyes que el Señor les ha dado para que las obedezcan: ");
INSERT INTO spaonbv_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Trabajarán solamente seis días, pues el séptimo es día de descanso solemne, santo, y debe ser dedicado a la adoración al Señor. Cualquiera que trabaje en ese día, morirá. ");
INSERT INTO spaonbv_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","No deben ni siquiera encender fuego en sus hogares ese día». ");
INSERT INTO spaonbv_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Luego Moisés le dijo a todo el pueblo: «Esto es lo que el Señor ha ordenado: ");
INSERT INTO spaonbv_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","9","Todo el que tenga corazón generoso, puede traer las siguientes ofrendas al Señor: Oro, plata, y bronce; tela azul, morada y escarlata, hecha de lino fino torcido o de pelo de cabra; pieles de carnero, y pieles de cabra especialmente tratadas; madera de acacia; aceite de oliva para las lámparas; especias para el aceite de la unción y para el incienso; piedras de ónice y piedras para usar en el efod y en el pectoral. ");
INSERT INTO spaonbv_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","19","»Vengan todos los que son artesanos con talentos especiales y construyan lo que el Señor les ha ordenado: La Tienda del santuario con sus cubiertas, ganchos, tablas, barras, columnas y bases; el cofre y sus varas; el propiciatorio; la cortina que está delante del Lugar Santo; la mesa con sus varas y todos sus utensilios; el pan de la ofrenda; el candelabro con sus lámparas y aceite; el altar del incienso y sus varas para transportarlo; el aceite de la unción y el incienso aromático; la cortina para la puerta del santuario; el altar para los holocaustos; el enrejado de bronce del altar, sus varas para transportarlo, y sus demás utensilios; el lavamanos con su base; las cortinas que servirán de cerco para el atrio; las columnas y sus bases; la cortina para la entrada del atrio; las estacas del atrio del santuario, y sus cuerdas; las vestiduras sagradas que los sacerdotes deben usar cuando sirvan en el Lugar Santo; las vestiduras sagradas del sacerdote Aarón y de sus hijos». ");
INSERT INTO spaonbv_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Entonces todo el pueblo fue a sus tiendas a preparar las donaciones. ");
INSERT INTO spaonbv_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Aquellos cuyo corazón fue tocado por el Espíritu de Dios volvieron con sus ofrendas de materiales para el santuario y su equipo, y para las vestiduras sagradas. ");
INSERT INTO spaonbv_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Vinieron hombres y mujeres, todos los que tuvieron un corazón dispuesto a dar. Le trajeron al Señor ofrendas de oro, joyas, pendientes, anillos, collares y objetos de oro de toda especie. ");
INSERT INTO spaonbv_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Otros trajeron tela azul, morada y escarlata, hecha de lino fino torcido de pelo de cabra, pieles de carnero teñidas de rojo y pieles de cabra especialmente tratadas. ");
INSERT INTO spaonbv_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Otros trajeron plata y bronce como ofrenda al Señor; y algunos trajeron la madera de acacia que se necesitaba para la construcción. ");
INSERT INTO spaonbv_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Las mujeres que tenían habilidades para la costura y para hilar prepararon hilos y telas de color azul, morado y escarlata, y lino fino torcido, y lo trajeron como ofrenda. ");
INSERT INTO spaonbv_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Otras mujeres, con mucha alegría, usaron sus dones especiales para hacer telas de pelo de cabras. ");
INSERT INTO spaonbv_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Los dirigentes trajeron piedras de ónice para el efod y para el pectoral, ");
INSERT INTO spaonbv_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","y especias y aceite para las lámparas y para la preparación del aceite de la unción y el incienso aromático. ");
INSERT INTO spaonbv_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","De esta manera el pueblo de Israel, todo hombre y mujer que quiso ayudar en la obra encomendada a ellos por el Señor, trajo su ofrenda voluntaria. ");
INSERT INTO spaonbv_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","31","Y Moisés les dijo: «El Señor ha señalado específicamente a Bezalel, hijo de Uri y nieto de Jur, de la tribu de Judá, como supervisor general de la construcción. ");
INSERT INTO spaonbv_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Él puede hacer hermosas creaciones de artesanía en oro, plata y bronce; ");
INSERT INTO spaonbv_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","puede cortar y engastar piedras preciosas, y puede hacer hermosas obras de tallado. En suma él tiene todas las habilidades necesarias. ");
INSERT INTO spaonbv_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Dios ha hecho que él y Aholiab sean maestros dotados y que puedan enseñar sus habilidades a los demás. Aholiab es hijo de Ajisamac, de la tribu de Dan. ");
INSERT INTO spaonbv_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Dios los ha dotado de habilidades muy especiales, de modo que pueden hacer toda obra de joyería y carpintería. También tienen la capacidad para hacer bordados en tela azul, morada y escarlata, y para elaborar cualquier tipo de tejido. Ellos, en fin, se destacan en todas las artes necesarias para la obra. ");
INSERT INTO spaonbv_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","»Los demás artesanos, a quienes el Señor haya dado habilidades, deberán ayudar a Bezalel y Aholiab en la construcción y preparación de los utensilios del santuario, de acuerdo con lo que el Señor ha ordenado». ");
INSERT INTO spaonbv_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Luego Moisés dijo a Bezalel, a Aholiab y a todos los que sintieron el deseo de colaborar en los trabajos que comenzaran a trabajar, ");
INSERT INTO spaonbv_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","y les entregó los materiales donados por el pueblo para la construcción del santuario. Pero como la gente continuaba llevando ofrendas todos los días, ");
INSERT INTO spaonbv_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","7","los obreros dejaron sus trabajos y fueron a reunirse con Moisés, y le dijeron: «La gente ha ofrendado mucho más de lo que necesitamos para realizar la obra que el Señor nos ha encomendado». Entonces Moisés envió mensajeros que fueran por el campamento avisando que ya no se necesitaban más donaciones. Por fin la gente dejó de llevar ofrendas. ");
INSERT INTO spaonbv_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Los tejedores hicieron primero diez cortinas de lino fino torcido, de color azul, morado y escarlata, y las adornaron con querubines hermosamente bordados sobre ellas. ");
INSERT INTO spaonbv_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Cada cortina medía unos doce metros y medio de largo por un metro con ochenta centímetros de ancho. ");
INSERT INTO spaonbv_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Cinco fueron unidas entre sí, y luego otras cinco unidas de la misma manera, y así formaron dos grandes cortinas. ");
INSERT INTO spaonbv_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","12","Con cincuenta cintas azules se hicieron lazos en el borde de las dos cortinas, cada lazo frente a su compañero de la otra cortina. ");
INSERT INTO spaonbv_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Luego se hicieron cincuenta ganchos de oro para unir los lazos, y de esta manera unir las dos grandes cortinas, de modo que el santuario era uno solo, pues se veía como si fuera de una sola pieza. ");
INSERT INTO spaonbv_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","15","Sobre el cielo raso fue colocada una segunda capa formada por once cortinas hechas de pelo de cabra. Tenían todas trece metros y medio de largo por un metro con ochenta centímetros de ancho. ");
INSERT INTO spaonbv_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Bezalel unió cinco de estas cortinas para hacer una pieza larga, y otras seis para hacer otra. ");
INSERT INTO spaonbv_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Luego hizo cincuenta lazos en el extremo de cada una, ");
INSERT INTO spaonbv_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","y cincuenta pequeños ganchos de bronce para unir los lazos, a fin de que las cortinas quedaran firmemente unidas una a otra. ");
INSERT INTO spaonbv_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","La cubierta superior del techo fue hecha de pieles de carnero teñidas de rojo y de pieles de cabras. ");
INSERT INTO spaonbv_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Para los costados del santuario se usaron tablas de madera de acacia, puestas en forma vertical. ");
INSERT INTO spaonbv_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","El alto de cada tabla era de cuatro metros y medio y el ancho de setenta centímetros. ");
INSERT INTO spaonbv_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Cada tabla se unía a la otra por medio de dos ganchos. ");
INSERT INTO spaonbv_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Había veinte tablas en el costado sur, ");
INSERT INTO spaonbv_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","asentadas en cuarenta bases de plata. Cada tabla estaba unida a su base por medio de dos ganchos. ");
INSERT INTO spaonbv_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","26","Había veinte tablas en el costado norte del santuario, con cuarenta bases de plata, dos para cada tabla. ");
INSERT INTO spaonbv_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","El costado occidental del santuario, que era la parte posterior, estaba hecho con seis tablas, ");
INSERT INTO spaonbv_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","más otra a cada extremo. ");
INSERT INTO spaonbv_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Estas tablas, incluyendo las de las esquinas, fueron unidas unas a otras, arriba y abajo, por medio de argollas. ");
INSERT INTO spaonbv_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","De modo que por el costado occidental había un total de ocho tablas con dieciséis bases de plata, dos por cada tabla. ");
INSERT INTO spaonbv_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","32","Luego hicieron cinco series de travesaños de madera de acacia, para unir las tablas por los lados, cinco por cada costado del santuario. ");
INSERT INTO spaonbv_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Uno de estos travesaños pasaba por el centro de las tablas, e iba de un extremo al otro del santuario. ");
INSERT INTO spaonbv_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Las tablas y los travesaños estaban recubiertos de oro, y las argollas eran de oro puro. ");
INSERT INTO spaonbv_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","La cortina interior azul, morada y escarlata fue hecha de lino fino torcido, con querubines primorosamente bordados. ");
INSERT INTO spaonbv_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","La cortina colgaba de cuatro ganchos de oro, montados en cuatro postes de madera de acacia, cubiertos de oro y asentados sobre cuatro bases de plata. ");
INSERT INTO spaonbv_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Luego hicieron una cortina para la entrada del santuario, tejida de lino fino bordado con azul, morado y escarlata. ");
INSERT INTO spaonbv_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Esta cortina iba unida por medio de cinco ganchos a cinco postes. Los postes, sus capiteles y varas estaban cubiertos con oro, y las cinco bases eran de bronce. ");
INSERT INTO spaonbv_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","A continuación, Bezalel construyó el cofre. Fue hecho de madera de acacia, y tenía un metro con diez centímetros de largo, setenta centímetros de ancho y setenta centímetros de alto. ");
INSERT INTO spaonbv_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Estaba cubierto de oro puro por dentro y por fuera, y tenía una moldura de oro por todo el contorno. ");
INSERT INTO spaonbv_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Hizo cuatro argollas de oro y colocó una en cada una de las esquinas, en la parte inferior. ");
INSERT INTO spaonbv_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Luego hizo varas de madera de acacia y las cubrió de oro, ");
INSERT INTO spaonbv_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","y las puso en las argollas de los costados del cofre, para transportarlo. ");
INSERT INTO spaonbv_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Luego hizo una cubierta de oro puro, que llamó propiciatorio. Tenía un metro con diez centímetros de largo, y setenta centímetros de ancho. ");
INSERT INTO spaonbv_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Hizo dos querubines de oro martillado y los colocó a los dos extremos del propiciatorio. ");
INSERT INTO spaonbv_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Los querubines formaban una sola pieza con la cubierta de oro, ");
INSERT INTO spaonbv_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","y estaban uno frente al otro, con las alas extendidas, de tal modo que cubrían el propiciatorio, y miraban hacia él. ");
INSERT INTO spaonbv_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Con madera de acacia hizo una mesa de noventa centímetros de largo, cuarenta y cinco de ancho y setenta de alto. ");
INSERT INTO spaonbv_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","La cubrió de oro puro y le puso una moldura de oro por todo su contorno. ");
INSERT INTO spaonbv_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Le hizo también un borde de siete centímetros y medio de alto por todo el contorno de la mesa, con una moldura de oro en el borde. ");
INSERT INTO spaonbv_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Luego fundió cuatro argollas de oro y las puso en las cuatro patas de la mesa, ");
INSERT INTO spaonbv_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","junto a la moldura, para colocar las varas que se usarían para su transporte. ");
INSERT INTO spaonbv_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","16","A continuación, usando oro puro, hizo los platos, las cucharas, los cubiertos y los tazones de la mesa. ");
INSERT INTO spaonbv_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Hizo un candelabro de oro puro, martillado. La base, el tallo, las lámparas y sus decoraciones de flores de almendra eran de una sola pieza. ");
INSERT INTO spaonbv_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","El candelabro tenía seis brazos, tres a cada costado del tallo principal. ");
INSERT INTO spaonbv_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Cada uno de los brazos estaba decorado con idénticas flores talladas. ");
INSERT INTO spaonbv_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","21","El tallo principal del candelabro estaba decorado también con flores de almendras, una flor en el punto donde arrancaba cada par de brazos, y una flor también bajo el par inferior y sobre el par superior, cuatro en total. ");
INSERT INTO spaonbv_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Los decorados y los brazos del candelabro eran todos de una sola pieza de oro puro martillado. ");
INSERT INTO spaonbv_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","24","Luego hizo siete lámparas y las puso en el extremo superior de cada brazo, con sus despabiladeras y sus platillos, todo de oro puro. El peso total del candelabro era de treinta y tres kilos. ");
INSERT INTO spaonbv_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","El altar del incienso estaba hecho de madera de acacia. Tenía cuarenta y cinco centímetros de largo por cuarenta y cinco centímetros de ancho, y su altura era de noventa centímetros. En sus esquinas tenía cuernos que formaban una sola pieza con el altar. ");
INSERT INTO spaonbv_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Lo cubrió de oro puro, y le puso una moldura de oro en todo su contorno. ");
INSERT INTO spaonbv_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","En cada lado fueron colocadas dos argollas de oro, debajo de la moldura, para sostener las varas que servirían para transportarlo. ");
INSERT INTO spaonbv_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Las varas eran de madera de acacia, cubiertas de oro. ");
INSERT INTO spaonbv_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Luego, con especias aromáticas hizo el aceite sagrado de la unción para los sacerdotes, y el incienso puro, de acuerdo con las técnicas de los mejores perfumistas. ");
INSERT INTO spaonbv_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","El altar de los holocaustos también fue construido de madera de acacia. Tenía dos metros y medio por lado en la parte superior, y un metro y medio de alto. ");
INSERT INTO spaonbv_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Tenía un cuerno en cada esquina, formando una sola pieza con el resto del altar. El altar estaba cubierto de bronce. ");
INSERT INTO spaonbv_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Hizo los utensilios de bronce para el uso del altar: calderos, tenazas, tazones, ganchos y palas. ");
INSERT INTO spaonbv_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","A continuación hizo una rejilla de bronce, que puso en el interior de la caja que estaba a media altura del altar. ");
INSERT INTO spaonbv_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","También hizo cuatro argollas para los costados de la parrilla, para sostener las varas para transportarlo. ");
INSERT INTO spaonbv_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Estas varas eran también de madera de acacia y estaban cubiertas de bronce. ");
INSERT INTO spaonbv_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Las varas que servían para transportar el altar las ponían en las argollas que estaban en los costados. El altar era hueco, forrado de tablas. ");
INSERT INTO spaonbv_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Con el bronce de los espejos donados por las mujeres que se reunían a la entrada del santuario, hizo el lavamanos y su base. ");
INSERT INTO spaonbv_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Luego edificó el atrio. La pared sur, de cuarenta y cinco metros de largo, estaba formada por cortinas tejidas de lino fino torcido. ");
INSERT INTO spaonbv_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Las cortinas colgaban de veinte postes cuyas bases eran de bronce, con ganchos y varas de plata. ");
INSERT INTO spaonbv_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","La pared norte también era de cuarenta y cinco metros de largo y tenía veinte postes con bases de bronce, y ganchos y varas de plata. ");
INSERT INTO spaonbv_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","El lado occidental media veintidós metros y medio de ancho, y tenía cortinas y diez postes con sus bases. También tenía ganchos y varas de plata. ");
INSERT INTO spaonbv_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","El costado oriental también tenía veintidós metros y medio. ");
INSERT INTO spaonbv_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","15","Las cortinas de cada lado de la entrada tenían siete metros de ancho, cada una con tres postes y tres bases. ");
INSERT INTO spaonbv_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Todas las cortinas que formaban las paredes del atrio estaban tejidas de lino fino torcido. ");
INSERT INTO spaonbv_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Cada poste tenía una base de bronce, y todos los ganchos y varas eran de plata; la parte superior de los postes estaba recubierta con plata, y las varas que servían para sostener las cortinas eran de plata maciza. ");
INSERT INTO spaonbv_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","La cortina que cubría la entrada del atrio era de lino fino torcido, bellamente bordada con hilo azul, morado y escarlata. Tenía nueve metros de largo y dos metros y medio de ancho, igual que las cortinas que componían las paredes del atrio. ");
INSERT INTO spaonbv_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Estaba colgada de cuatro postes, cada uno con su base de bronce, y con sus ganchos y varas de plata. La parte superior de los postes también era de plata. ");
INSERT INTO spaonbv_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Todas las estacas que se usaron en la construcción del santuario y del atrio eran de bronce. ");
INSERT INTO spaonbv_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Esto resume los diversos pasos dados en la edificación del santuario que serviría de morada para el cofre, de modo que los levitas pudieran desarrollar en él su ministerio. Todo fue hecho en el orden señalado por Moisés, y fue supervisado por Itamar, hijo del sacerdote Aarón. ");
INSERT INTO spaonbv_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Bezalel, hijo de Uri y nieto de Jur, de la tribu de Judá, era el artesano mayor, y ");
INSERT INTO spaonbv_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","le ayudaba Aholiab hijo de Ajisamac, de la tribu de Dan, quien también era un artesano muy capaz, experto en tallados, tejidos y bordados en azul, morado y escarlata sobre lino fino. ");
INSERT INTO spaonbv_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","El total de oro que el pueblo llevó como ofrenda, y que fue usado en la obra del santuario, fue de una tonelada, de acuerdo con la medida usada en el santuario. ");
INSERT INTO spaonbv_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","26","La cantidad de plata usada fue de tres toneladas y media, y fue tomada del impuesto que se le cobraba a todos los que, según el censo, tenían más de veinte años; un total de seiscientos tres mil quinientos cincuenta hombres. ");
INSERT INTO spaonbv_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Las bases para las tablas de los costados del santuario y de los postes que sostenían las cortinas se llevaron tres mil trescientos kilos de plata, cerca de treinta y tres kilos por cada base. ");
INSERT INTO spaonbv_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","La plata sobrante fue usada para cubrir la parte superior de los postes, y para las varas y ganchos. ");
INSERT INTO spaonbv_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","31","El pueblo ofrendó dos mil trescientos cuarenta kilos de bronce, que fue usado para fundir las bases de los postes de la entrada del santuario, el altar de bronce, la parrilla de bronce, los utensilios del altar, las bases de los postes que sostenían las cortinas del atrio, y para todos los clavos usados en la construcción del santuario y del atrio. ");
INSERT INTO spaonbv_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Las hermosas vestiduras para los sacerdotes fueron hechas de tela azul, morada y escarlata. Estas vestiduras las usarían los sacerdotes mientras sirvieran en el Lugar Santo. Esta misma tela fue usada para las vestiduras sagradas de Aarón, conforme a las órdenes que el Señor le había dado a Moisés. ");
INSERT INTO spaonbv_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","El efod también fue hecho de esta tela, tejido de lino fino torcido. ");
INSERT INTO spaonbv_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Bezalel hizo láminas de oro martillado, y de estas láminas sacaron hilos para tejerlos en el lino azul, morado y escarlata. Fue una preciosa obra de artesanía. ");
INSERT INTO spaonbv_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","5","El efod lo sostenían unas hombreras, las cuales se unían por los extremos con un cinto hecho de una sola pieza de hilo de lino torcido azul, morado y escarlata, y bordado con oro, de la manera ordenada por Dios a Moisés. ");
INSERT INTO spaonbv_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","7","Las dos piedras de ónice, unidas a las dos hombreras del efod, fueron engastadas en oro, y las piedras fueron grabadas con los nombres de las tribus de Israel, de la manera que se graban las iniciales en un anillo. Estas piedras servían para recordar a los israelitas. Todo esto fue hecho de acuerdo con las instrucciones que el Señor le había dado a Moisés. ");
INSERT INTO spaonbv_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","El pectoral era una obra primorosa, al igual que el efod, hecho del mejor oro, y de lino fino de color azul, morado y escarlata. ");
INSERT INTO spaonbv_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Era una pieza cuadrada de veinte centímetros por lado, doblada para formar una bolsa. ");
INSERT INTO spaonbv_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","En esta bolsa había cuatro hileras de piedras. En la primera había un rubí, un topacio y una esmeralda. ");
INSERT INTO spaonbv_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","En la segunda hilera había una turquesa, un zafiro y un diamante. ");
INSERT INTO spaonbv_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","En la tercera hilera había un jacinto, un ágata y una amatista. ");
INSERT INTO spaonbv_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","En la cuarta hilera, un berilo, un ónice y un jaspe, todo montado en engastes de oro. ");
INSERT INTO spaonbv_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Las piedras fueron grabadas con el nombre de las doce tribus de Israel. ");
INSERT INTO spaonbv_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","18","Para unir el pectoral al efod se colocó un anillo de oro en la parte superior de cada hombrera del efod, y de estos anillos de oro salían dos cordones de oro trenzado, unidos a dos anillos que había en las esquinas superiores del pectoral. ");
INSERT INTO spaonbv_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","También se pusieron dos anillos de oro en la parte inferior del pectoral, a cada lado, junto al efod. ");
INSERT INTO spaonbv_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Otros dos anillos de oro fueron puestos en la parte inferior de las hombreras del efod, junto al punto en que el efod se unía al cinto tejido. ");
INSERT INTO spaonbv_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","El pectoral se fijaba al cinto del efod, atando los anillos del pectoral a los anillos del efod con una cinta azul. Todo esto se hizo exactamente como el Señor se lo había ordenado a Moisés. ");
INSERT INTO spaonbv_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","El manto del efod estaba tejido de azul, ");
INSERT INTO spaonbv_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","y tenía una abertura en el centro, tal como el que se hace en el cuello de un chaleco, para pasar la cabeza por ella, reforzada por los bordes, para que no se rompiera fácilmente. ");
INSERT INTO spaonbv_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","En el borde inferior de la túnica había granadas de tela de lino, bordadas en azul, morado y escarlata. ");
INSERT INTO spaonbv_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","26","En todo el contorno del borde inferior del manto pusieron campanillas de oro puro, alternadas con las granadas. Este manto lo usaría Aarón cuando sirviera al Señor, tal como él le había ordenado a Moisés. ");
INSERT INTO spaonbv_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Luego hicieron túnicas de lino fino para Aarón y sus hijos. ");
INSERT INTO spaonbv_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","29","El pectoral, la hermosa mitra, los adornos del turbante, y la ropa interior fueron hechos con lino; y el cinto de lino estaba primorosamente bordado con hilos de color azul, morado y escarlata, tal como el Señor había ordenado a Moisés. ");
INSERT INTO spaonbv_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Finalmente, hicieron la lámina santa, de oro puro, para ponerla en la parte frontal de la mitra, en la que se grabaron las palabras: «dedicado al Señor». ");
INSERT INTO spaonbv_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Fue unida a la mitra con un cordón azul, tal como el Señor lo había ordenado. ");
INSERT INTO spaonbv_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","La construcción del santuario, es decir, de la Tienda de reunión, se hizo de acuerdo con todas las instrucciones que el Señor le dio a Moisés. ");
INSERT INTO spaonbv_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","40","Entonces trajeron el santuario completo a Moisés: Utensilios, ganchos, tablas, barras, postes, bases, cubiertas para el techo y los costados, pieles de carnero teñidas de rojo, pieles de cabra especialmente tratadas, y la cortina de la entrada; el cofre con los Diez Mandamientos en su interior, junto con las varas para transportarlo, el propiciatorio, la mesa y todos sus utensilios, el pan de la Presencia; el candelabro de oro puro, con sus lámparas, utensilios y aceite; el altar de oro; el aceite de la unción, el incienso aromático, las cortinas de la entrada del santuario, el altar de bronce, la parrilla de bronce, las varas y los utensilios, el lavamanos y su base, las cortinas para las paredes del atrio, junto con los postes que las sostenían; las bases y las cortinas de la puerta del atrio; las cuerdas y los clavos, y todos los demás utensilios usados en el santuario, es decir en la Tienda de reunión. ");
INSERT INTO spaonbv_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","También trajeron para su inspección las vestiduras primorosamente confeccionadas, que los sacerdotes deberían usar mientras sirvieran en el Lugar Santo, y las vestiduras sagradas para el sacerdote Aarón y sus hijos, que deberían usar mientras realizaran sus labores. ");
INSERT INTO spaonbv_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","De esta manera el pueblo de Israel siguió todas las instrucciones que el Señor le había dado a Moisés. ");
INSERT INTO spaonbv_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Moisés inspeccionó toda aquella obra, y bendijo a quienes la habían hecho, porque todo era exactamente como el Señor lo había ordenado. ");
INSERT INTO spaonbv_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","El Señor le dijo entonces a Moisés: ");
INSERT INTO spaonbv_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","«Arma el santuario el primer día del mes. ");
INSERT INTO spaonbv_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Coloca en él el cofre que contiene los Diez Mandamientos. Instala luego la cortina para cerrar el acceso al cofre dentro del Lugar Santísimo. ");
INSERT INTO spaonbv_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Después mete la mesa y coloca en ella los utensilios, y pon el candelabro y enciende las lámparas. ");
INSERT INTO spaonbv_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","»Coloca el altar de oro para el incienso frente al cofre. Instala las cortinas a la entrada del santuario, ");
INSERT INTO spaonbv_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","y coloca el altar para el holocausto frente a la entrada. ");
INSERT INTO spaonbv_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Pon el lavamanos entre el santuario y el altar, y llénalo de agua. ");
INSERT INTO spaonbv_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Luego levanta el atrio alrededor de la tienda, y cuelga las cortinas de la entrada del atrio. ");
INSERT INTO spaonbv_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","»Toma el aceite de la unción y rocíalo en el santuario y en todo lo que está en él, sobre todos sus utensilios y muebles, para santificarlo. Una vez hecho esto, será santo. ");
INSERT INTO spaonbv_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Ungirás el altar del holocausto y los utensilios, para santificarlos; así el altar será santísimo. ");
INSERT INTO spaonbv_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Luego ungirás el lavamanos y su base, para santificarlo. ");
INSERT INTO spaonbv_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","»Enseguida llevarás a Aarón y a sus hijos a la entrada del santuario y los lavarás con agua. ");
INSERT INTO spaonbv_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Le pondrás a Aarón las vestiduras sagradas y lo ungirás con aceite, y de esa manera quedará consagrado como sacerdote, para que me sirva. ");
INSERT INTO spaonbv_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Después llevarás a sus hijos, los vestirás, ");
INSERT INTO spaonbv_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","y los ungirás de la manera que lo hiciste con su padre, para que puedan servir delante de mí, como sacerdotes. La unción de ellos será permanente, es decir, de generación en generación: sus hijos y los hijos de sus hijos, todos ellos serán para siempre mis sacerdotes». ");
INSERT INTO spaonbv_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Moisés comenzó a hacer todo lo que el Señor le había ordenado. ");
INSERT INTO spaonbv_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","En el primer día del primer mes del segundo año armaron el santuario. ");
INSERT INTO spaonbv_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Moisés lo levantó, colocó las tablas en sus bases y unió los travesaños. ");
INSERT INTO spaonbv_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Luego extendió las cortinas sobre esta estructura, y puso las cubiertas del techo, en la forma que el Señor le había ordenado. ");
INSERT INTO spaonbv_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Dentro del cofre colocó las piedras que contenían los Diez Mandamientos, colocó las varas para transportar el cofre, y le puso la cubierta, llamada propiciatorio. ");
INSERT INTO spaonbv_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Luego llevó el cofre al interior del santuario, y puso la cortina para cubrir la entrada, tal como el Señor le había ordenado. ");
INSERT INTO spaonbv_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Enseguida, puso la mesa en el costado norte de la sala, al exterior de la cortina, ");
INSERT INTO spaonbv_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","y puso el pan de la Presencia sobre la mesa delante del Señor, de acuerdo con lo que él le había ordenado. ");
INSERT INTO spaonbv_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Junto a la mesa puso el candelabro, en el costado sur del santuario. ");
INSERT INTO spaonbv_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Luego encendió las lámparas delante del Señor, siguiendo todas sus instrucciones. ");
INSERT INTO spaonbv_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","También puso el altar de oro en el santuario, junto a la cortina, ");
INSERT INTO spaonbv_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","y sobre él quemó incienso hecho con especias aromáticas, según las instrucciones del Señor. ");
INSERT INTO spaonbv_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Puso la cortina a la entrada del santuario, ");
INSERT INTO spaonbv_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","y colocó afuera el altar para los holocaustos, junto a la entrada, y ofreció en él un holocausto y una ofrenda de grano, tal como el Señor le había ordenado. ");
INSERT INTO spaonbv_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","A continuación, colocó el lavamanos de bronce entre la tienda y el altar, y lo llenó de agua, para que los sacerdotes pudieran usarla para los lavamientos. ");
INSERT INTO spaonbv_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Moisés, Aarón y los hijos de Aarón se lavaron los pies y las manos allí. ");
INSERT INTO spaonbv_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Cuando pasaban del altar para entrar en el santuario, se detenían y se lavaban, obedeciendo, así, lo que el Señor había ordenado a Moisés. ");
INSERT INTO spaonbv_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Luego, levantaron un cerco o atrio alrededor de la tienda y el altar, y pusieron la cortina a la entrada del atrio. Así acabó Moisés la obra. ");
INSERT INTO spaonbv_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Entonces la nube cubrió el santuario, y la gloria del Señor lo llenó. ");
INSERT INTO spaonbv_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Moisés no pudo entrar a causa de la nube que estaba allí, y de la gloria del Señor que llenaba el santuario. ");
INSERT INTO spaonbv_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Cuando la nube se levantaba y empezaba a moverse, el pueblo de Israel emprendía la marcha y la seguía. ");
INSERT INTO spaonbv_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Si la nube se detenía, ellos permanecían allí hasta que la nube se volvía a mover. ");
INSERT INTO spaonbv_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","La nube se posaba sobre el santuario durante el día, y en la noche la nube se encendía con fuego, para que el pueblo de Israel pudiera ver. Y esto sucedió durante toda su marcha por el desierto.");
INSERT INTO spaonbv_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","El Señor le habló a Moisés desde el santuario, ");
INSERT INTO spaonbv_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","y le ordenó que le diera las siguientes instrucciones al pueblo de Israel: «Cuando presenten una ofrenda animal al Señor, deberán traer un animal de ganado vacuno o lanar. ");
INSERT INTO spaonbv_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","»Si el animal que se ofrece en holocausto es de ganado vacuno, entonces deberá ser un macho sin defecto. Llevarán el animal hasta la entrada del santuario, donde los sacerdotes aceptarán su ofrenda para el Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","La persona que lo lleve deberá poner las manos sobre la cabeza del animal, con lo que este se convertirá en su sustituto. La muerte del animal será aceptada por el Señor, en lugar de quien lo ofrece como castigo por sus pecados. ");
INSERT INTO spaonbv_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","El hombre dará muerte al animal allí, delante del Señor, y los hijos de Aarón, los sacerdotes, presentarán la sangre delante del Señor y la rociarán alrededor del altar, a la entrada del santuario. ");
INSERT INTO spaonbv_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","7","Entonces los sacerdotes desollarán el animal, lo descuartizarán, prenderán leña sobre el altar, ");
INSERT INTO spaonbv_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","y pondrán las diferentes partes del animal, la cabeza y la grasa sobre la leña. ");
INSERT INTO spaonbv_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Lavarán los órganos internos y las patas, y luego los sacerdotes lo quemarán todo sobre el altar. Será un holocausto, una ofrenda de olor grato al Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","»Si el animal ofrecido para el holocausto es un cordero o un cabrito, también debe ser un macho sin defectos. ");
INSERT INTO spaonbv_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","El hombre que lo presente lo matará delante del Señor, en el lado norte del altar, y los hijos de Aarón, los sacerdotes, rociarán la sangre alrededor del altar. ");
INSERT INTO spaonbv_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Entonces el ofrendante lo descuartizará, y el sacerdote colocará los pedazos, con la cabeza y la grasa encima de la leña, sobre el altar. ");
INSERT INTO spaonbv_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Pero antes lavará los órganos internos y las patas con agua. Luego, el sacerdote quemará el sacrificio sobre el altar como un holocausto, como ofrenda encendida de olor grato al Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","»Si alguno desea ofrecer un holocausto de aves, puede elegir tórtolas o palominos. ");
INSERT INTO spaonbv_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","17","El sacerdote llevará el ave al altar, le cortará la cabeza y derramará la sangre sobre la pared del altar. Enseguida el sacerdote tomará el buche y las plumas y los arrojará al costado oriental del altar, sobre las cenizas. Luego, tomándola por las alas, partirá el ave en dos, pero sin separar completamente las dos partes. Por último, el sacerdote la quemará sobre el altar como un holocausto, una ofrenda de olor grato al Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","»Cuando alguna persona quiera presentar una ofrenda de cereales al Señor, deberá llevar harina de la mejor calidad, sobre la cual derramará aceite puro de oliva e incienso. ");
INSERT INTO spaonbv_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Entonces tomará un puñado, que simbolizará el total de la ofrenda, y lo entregará a uno de los sacerdotes para que queme el puñado de harina. Será una ofrenda quemada de grato olor al Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","El resto será entregado a Aarón y a sus hijos como alimento; pero la ofrenda entera será considerada como una ofrenda santa, agradable al Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","»Si se trae como ofrenda al Señor una torta cocida en el horno, debe haber sido hecha de harina de la mejor calidad, cocida con aceite, pero sin levadura. También se puede ofrecer hojaldres sin levadura, hechas con harina de la mejor calidad y amasadas con aceite de oliva. ");
INSERT INTO spaonbv_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","»Si la ofrenda es algo preparado en sartén, deberá ser de harina de la mejor calidad, sin levadura y mezclada con aceite de oliva. ");
INSERT INTO spaonbv_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Hay que partirla en pedazos y echarle aceite encima. Es una ofrenda de cereal. ");
INSERT INTO spaonbv_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Si la ofrenda ha sido preparada en cazuela, será de harina de la mejor calidad, mezclada con aceite de oliva. ");
INSERT INTO spaonbv_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","»Cualquiera que sea la forma como se haya preparado la ofrenda (al horno, al sartén o a la cazuela), será presentada al sacerdote, el cual la llevará al altar, para ofrecérsela al Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","»El sacerdote quemará solo una parte representativa de la ofrenda, pero toda ella será aceptada por el Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","El resto de la ofrenda será para el uso personal de los sacerdotes, pero toda ella será considerada una ofrenda santa quemada delante del Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","»No usarán levadura en sus ofrendas de harina. No se permite levadura ni miel en las ofrendas hechas al Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Pueden ofrecer pan con levadura y miel como ofrenda de acción de gracias en la época de la cosecha, pero no como ofrenda quemada. ");
INSERT INTO spaonbv_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","»Toda ofrenda deberá ser sazonada con sal, porque la sal es un recordatorio del pacto de Dios. ");
INSERT INTO spaonbv_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","»Si tu ofrenda es de los primeros frutos de los cereales, toma una espiga tierna, tuéstala, desmenuza el grano y preséntasela al Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Sobre la ofrenda derrama aceite de olivas e incienso, porque es una ofrenda de cereales. ");
INSERT INTO spaonbv_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Entonces los sacerdotes quemarán una parte del cereal desmenuzado mezclado con aceite y todo el incienso, como símbolo de la consagración de toda la ofrenda al Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","»Cualquiera que quiera presentar una ofrenda de acción de gracias delante del Señor, podrá traer un becerro o una ternera, pero el animal debe ser sin defectos. ");
INSERT INTO spaonbv_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","El hombre que presenta la ofrenda pondrá la mano sobre la cabeza del animal y lo matará a la entrada del santuario. Entonces los hijos de Aarón rociarán la sangre a los lados del altar, ");
INSERT INTO spaonbv_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","5","y quemarán, delante del Señor, la grasa que cubre los intestinos, los dos riñones y la grasa que los recubre, la grasa que está sobre los lomos y un pedazo del hígado. Será una ofrenda quemada de grato olor al Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","»Si se presenta como ofrenda de acción de gracias un animal del ganado ovino, podrá ser macho o hembra, pero sin defectos. ");
INSERT INTO spaonbv_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","8","Si es un cordero, el hombre que lo ofrezca deberá poner la mano sobre la cabeza del animal y lo matará a la entrada del santuario. Los sacerdotes rociarán la sangre a los lados del altar ");
INSERT INTO spaonbv_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","11","y ofrecerán sobre el altar la grasa, la cola entera (cortada a raíz del espinazo), la grasa que cubre los intestinos, los dos riñones con la grasa de ellos, la grasa que cubre los lomos, y un pedazo del hígado. Lo harán arder todo en el altar. Será una comida, una ofrenda presentada por fuego al Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","»Si alguno trae una cabra como ofrenda al Señor, ");
INSERT INTO spaonbv_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","deberá poner la mano sobre la cabeza del animal y matarlo a la entrada del santuario. Los sacerdotes rociarán la sangre sobre todos los lados del altar, ");
INSERT INTO spaonbv_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","y pondrán sobre el altar la grasa que cubre las entrañas, ");
INSERT INTO spaonbv_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","16","los dos riñones y la grasa de ellos, la grasa que recubre los lomos, y un pedazo del hígado, como una ofrenda quemada ante el Señor. Es una comida, una ofrenda de olor grato presentada por fuego al Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","»Esta es una ordenanza permanente en toda tu tierra: No coman grasa ni sangre». ");
INSERT INTO spaonbv_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Entonces el Señor le dio estas otras instrucciones a Moisés: ");
INSERT INTO spaonbv_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","«Dile al pueblo de Israel que estas son las leyes para cualquiera que sin querer quebrante alguno de mis mandamientos: ");
INSERT INTO spaonbv_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","»Si un sacerdote peca, sin haber tenido la intención de hacerlo, y en consecuencia hace caer alguna culpa sobre el pueblo, debe ofrecer al Señor un becerro sin defecto, como expiación por el pecado del pueblo. ");
INSERT INTO spaonbv_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Llevará el becerro hasta la puerta del santuario, pondrá la mano sobre la cabeza del animal y lo matará delante del Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Entonces entrará con la sangre del animal al santuario, ");
INSERT INTO spaonbv_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","mojará el dedo en la sangre y la rociará siete veces delante del Señor, ante la cortina que cierra la entrada al Lugar Santísimo. ");
INSERT INTO spaonbv_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Después pondrá sangre sobre los cuernos del altar del incienso, delante del Señor, en el santuario; el resto de la sangre la derramará sobre la base del altar del holocausto, a la entrada del santuario. ");
INSERT INTO spaonbv_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Enseguida tomará toda la grasa de los intestinos, ");
INSERT INTO spaonbv_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","los dos riñones con la grasa que los cubre, la grasa que cubre los lomos, y un pedazo del hígado, ");
INSERT INTO spaonbv_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","igual como se hace con el animal que se sacrifica para ofrenda de reconciliación. Luego el sacerdote quemará todo en al altar del holocausto. ");
INSERT INTO spaonbv_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","12","Pero el resto del becerro, la piel, la carne, la cabeza, las patas, los órganos internos y los intestinos, serán llevados a un lugar ceremonialmente limpio, fuera del campamento, al lugar donde se llevan las cenizas del altar, y lo quemarán sobre la leña encendida. ");
INSERT INTO spaonbv_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","»Si toda la nación de Israel peca, sin darse cuenta de ello, y hace algo que el Señor le haya prohibido, todo el pueblo será culpable. ");
INSERT INTO spaonbv_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Cuando se den cuenta de su pecado, ofrecerán un becerro como expiación por el pecado, y lo traerán al santuario, ");
INSERT INTO spaonbv_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","donde los jefes del pueblo pondrán las manos sobre la cabeza del animal y lo matarán delante del Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Entonces el sacerdote entrará con la sangre al santuario, ");
INSERT INTO spaonbv_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","mojará el dedo en la sangre y rociará siete veces delante del Señor, frente a la cortina. ");
INSERT INTO spaonbv_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Luego pondrá sangre sobre los cuernos del altar allí en el santuario, en la presencia del Señor, y derramará todo el resto de la sangre en la base del altar del holocausto, a la entrada del santuario. ");
INSERT INTO spaonbv_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Le quitará toda la grasa y la quemará sobre el altar. ");
INSERT INTO spaonbv_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Seguirá el mismo procedimiento usado en la ofrenda por el pecado. De esta manera el sacerdote hará la expiación por la nación, y todos serán perdonados. ");
INSERT INTO spaonbv_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Enseguida, el sacerdote sacará el becerro del campamento y lo quemará, de la misma manera que lo haría si se tratara de una ofrenda por el pecado de algún individuo, sólo que esta vez se trata de una ofrenda por el pecado de toda la nación. ");
INSERT INTO spaonbv_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","»Si uno de los jefes de la nación peca sin darse cuenta, y desobedece la ley de Dios, ");
INSERT INTO spaonbv_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","en cuanto se dé cuenta de su pecado deberá presentar un sacrificio consistente en un macho cabrío que no tenga defectos. ");
INSERT INTO spaonbv_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Pondrá la mano sobre la cabeza del animal y lo sacrificará en el lugar donde se matan los animales de los holocaustos, y lo presentará al Señor. Es su ofrenda por el pecado. ");
INSERT INTO spaonbv_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Enseguida el sacerdote tomará sangre, y con el dedo la untará sobre los cuernos del altar del holocausto, y derramará el resto de la sangre al pie del altar. ");
INSERT INTO spaonbv_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Toda la grasa será quemada sobre el altar como se hace con el sacrificio de acción de gracias; de esta manera el sacerdote hará expiación por el jefe que haya pecado, y este será perdonado. ");
INSERT INTO spaonbv_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","»Si alguien del pueblo peca y no se da cuenta de ello, es culpable. ");
INSERT INTO spaonbv_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","En cuanto comprenda que ha pecado deberá presentar en sacrificio una cabra sin defectos, como expiación por su pecado. ");
INSERT INTO spaonbv_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","La llevará al lugar donde se matan los animales para el holocausto, colocará la mano sobre la cabeza del animal y lo matará. ");
INSERT INTO spaonbv_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","El sacerdote mojará el dedo en sangre y la untará sobre los cuernos del altar del holocausto. Enseguida derramará el resto de la sangre al pie del altar. ");
INSERT INTO spaonbv_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Se le quitará al animal toda la grasa, siguiendo el mismo procedimiento de la ofrenda de acción de gracias, y el sacerdote la quemará sobre el altar, como una ofrenda de grato olor al Señor. De esta manera el sacerdote hará expiación por aquel hombre, y este recibirá el perdón. ");
INSERT INTO spaonbv_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","»Pero si prefiere presentar un cordero como ofrenda por el pecado, deberá ser una hembra sin defecto. ");
INSERT INTO spaonbv_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","La llevará al lugar donde se hacen los holocaustos, pondrá la mano sobre la cabeza del animal y lo sacrificará allí como una ofrenda por su pecado. ");
INSERT INTO spaonbv_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","El sacerdote mojará el dedo en la sangre y la untará sobre los cuernos del altar del holocausto, y todo el resto de la sangre la derramará al pie del altar. ");
INSERT INTO spaonbv_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","La grasa la usará siguiendo el mismo procedimiento del sacrificio del cordero en la ofrenda de acción de gracias: el sacerdote quemará la grasa en el altar, como en los demás sacrificios ofrecidos al Señor en el fuego; y hará expiación por el hombre, y este recibirá el perdón de sus pecados. ");
INSERT INTO spaonbv_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","»Cualquiera que se niegue a testificar acerca de un delito del cual es testigo, ya sea porque vio o escuchó, es culpable de complicidad, y deberá pagar por ello. ");
INSERT INTO spaonbv_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","»Cualquier persona que toque algo que es ritualmente impuro, como el cuerpo muerto de un animal prohibido como alimento, salvaje o doméstico, o el cuerpo de un insecto prohibido, es culpable, aun cuando no se haya dado cuenta de que lo tocó. ");
INSERT INTO spaonbv_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","O si toca una impureza humana, de cualquier tipo, quedará impuro en cuanto se dé cuenta de ello. ");
INSERT INTO spaonbv_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","»Si alguien jura precipitadamente, sea el voto bueno o malo, en cuanto comprenda su error, será culpable. ");
INSERT INTO spaonbv_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","»En cualquiera de estos casos, confesará el pecado cometido ");
INSERT INTO spaonbv_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","y presentará una ofrenda por su culpa: una hembra de ganado menor, oveja o cabra. El sacerdote hará la expiación por esa persona, y esta quedará perdonada. ");
INSERT INTO spaonbv_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","»Si el culpable es una persona muy pobre, de modo que no tiene forma de ofrecer una oveja, entonces ofrecerá dos tórtolas o dos pichones de paloma: uno como ofrenda por el pecado y el otro como holocausto. ");
INSERT INTO spaonbv_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","El sacerdote ofrecerá en primer lugar el sacrificio por el pecado, para lo cual le cortará el cuello al ave, pero sin separarle la cabeza del cuerpo. ");
INSERT INTO spaonbv_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Enseguida rociará una parte de la sangre sobre el costado del altar y el resto lo derramará al pie del altar; es la ofrenda por el pecado. ");
INSERT INTO spaonbv_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","La segunda ave será ofrecida como holocausto siguiendo los procedimientos ya mencionados. De esta manera el sacerdote hará expiación por la persona que pecó, y esta será perdonada. ");
INSERT INTO spaonbv_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","»Si el culpable es aún más pobre, de modo que ni siquiera puede ofrecer tórtolas o pichones de paloma, ofrecerá como ofrenda por su pecado dos kilos de harina de la mejor calidad. No debe mezclarla con aceite de olivas ni ponerle incienso, porque es una ofrenda por el pecado. ");
INSERT INTO spaonbv_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Se la llevará al sacerdote, el cual tomará un puñado que representará la ofrenda completa, y la quemará sobre el altar, como cualquier otro sacrificio ofrecido al Señor por fuego; esta será su ofrenda por el perdón de sus pecados. ");
INSERT INTO spaonbv_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","De esta manera el sacerdote hará expiación por el que haya cometido cualquier pecado de esta clase, y será perdonado. El resto de la harina pertenecerá al sacerdote, como en el caso de una ofrenda de cereales». ");
INSERT INTO spaonbv_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Además, el Señor le dijo a Moisés: ");
INSERT INTO spaonbv_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","«Si alguno peca inadvertidamente, al no darle al Señor todo lo que le corresponde, ofrecerá por su pecado un carnero sin defecto. El valor del animal se calculará de acuerdo con la moneda oficial del santuario. Es un sacrificio por la culpa. ");
INSERT INTO spaonbv_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Además, el culpable hará restitución por el diezmo que retuvo, más un veinte por ciento como multa, lo cual entregará al sacerdote. Entonces el sacerdote, por medio del carnero sacrificado, hará expiación por el culpable, y este será perdonado. ");
INSERT INTO spaonbv_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","18","»Cualquiera que desobedezca alguna ley de Dios, aun sin darse cuenta, de todos modos es culpable. Entonces deberá llevar al sacerdote un carnero sin defecto, o su equivalente en dinero. El precio será fijado de la misma manera que se hace con el sacrificio por la culpa. El sacerdote, entonces, presentará el sacrificio a favor del que pecó sin darse cuenta, y este será perdonado. ");
INSERT INTO spaonbv_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Se trata de una ofrenda por la culpa, porque ciertamente esa persona es culpable delante del Señor». ");
INSERT INTO spaonbv_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","El Señor le dijo a Moisés: ");
INSERT INTO spaonbv_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","«Si alguien peca contra mí negándose a devolver un depósito por algo que rentó o si se niega a devolver algo que se le confió, o si le quita a la fuerza algo a su prójimo, ");
INSERT INTO spaonbv_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","o si se encuentra algo que se le perdió a su prójimo, y se queda con lo encontrado negando, bajo juramento, tenerlo, ");
INSERT INTO spaonbv_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","5","es culpable de pecado. Tendrá que devolver todo lo que haya robado, más un veinte por ciento como multa. Además, el mismo día llevará una ofrenda por su pecado al santuario. ");
INSERT INTO spaonbv_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","La ofrenda por su culpa será un carnero sin defecto, deberá ser del valor que tú determines. Lo llevará al sacerdote y ");
INSERT INTO spaonbv_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","el sacerdote hará la expiación a su favor delante del Señor, y será perdonado». ");
INSERT INTO spaonbv_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Además, el Señor le dijo a Moisés: ");
INSERT INTO spaonbv_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","«Dale a Aarón y a sus hijos estas reglas acerca de los holocaustos: El holocausto se dejará toda la noche sobre el fuego del altar. ");
INSERT INTO spaonbv_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Al día siguiente, el sacerdote, vestido de lino y con ropa interior de lino, sacará las cenizas del holocausto y las pondrá junto al altar. ");
INSERT INTO spaonbv_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","En seguida se cambiará la ropa, sacará las cenizas del campamento, y las llevará a un lugar ritualmente limpio. ");
INSERT INTO spaonbv_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Mientras tanto, el fuego del altar continuará encendido. No debe dejarse apagar. El sacerdote deberá ponerle leña cada mañana, y pondrá sobre él el holocausto diario y la grasa del sacrificio de paz que se ofrece todos los días. ");
INSERT INTO spaonbv_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","El fuego debe mantenerse encendido continuamente sobre el altar. No debe dejarse apagar. ");
INSERT INTO spaonbv_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","»Estas son las reglas acerca de las ofrendas de cereales: Los hijos de Aarón se pondrán de pie ante el altar, delante del Señor para presentar la ofrenda de cereales. ");
INSERT INTO spaonbv_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Los sacerdotes entonces sacarán un puñado de harina fina mezclada con aceite de oliva e incienso, y la quemarán sobre el altar como porción representativa delante del Señor, como una ofrenda recordatoria de olor grato al Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Lo que quede de la harina, después de que el sacerdote haya sacado el puñado, será para la alimentación de Aarón y sus hijos. La comerán sin levadura en el atrio del santuario. ");
INSERT INTO spaonbv_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Reafírmales esta instrucción: La ofrenda será cocida sin levadura. He asignado a los sacerdotes esta parte de los holocaustos que se me ofrecen. Sin embargo, toda la ofrenda es santísima, al igual que el sacrificio por el pecado y el sacrificio por la culpa. ");
INSERT INTO spaonbv_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Podrá comerla cualquier varón descendiente de Aarón, generación tras generación. Pero sólo ellos podrán comer de estas ofrendas presentadas en el fuego al Señor. Cualquier cosa que toque los sacrificios quedará consangrada». ");
INSERT INTO spaonbv_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","20","El Señor le dijo a Moisés: «El día que Aarón y sus hijos sean ungidos, presentarán al Señor una ofrenda de dos kilos de harina: ofrecerán la mitad en la mañana, y la otra mitad en la tarde. ");
INSERT INTO spaonbv_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Será preparada con aceite de oliva en una sartén, y se freirá bien, y luego será llevada delante del Señor como ofrenda muy agradable para él. ");
INSERT INTO spaonbv_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","23","Cuando los hijos de los sacerdotes tengan que tomar el lugar de sus padres, serán incorporados al oficio por medio de la presentación de este mismo sacrificio en el día de su unción. Esta es una ley perpetua. Estas ofrendas serán completamente quemadas delante del Señor. Nadie comerá parte alguna de ellas». ");
INSERT INTO spaonbv_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Luego el Señor le dijo a Moisés: ");
INSERT INTO spaonbv_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","«Diles a Aarón y a sus hijos que estos son mis mandamientos acerca de la ofrenda por el pecado: Este es un sacrificio santísimo. Será inmolado en el lugar en que se da muerte a los animales de los holocaustos. ");
INSERT INTO spaonbv_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","El sacerdote que oficia lo comerá en el atrio del santuario. ");
INSERT INTO spaonbv_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Solamente los que están santificados, los sacerdotes, podrán tocar esta carne. Si una gota de sangre salpica su vestido, deberá lavarlo en un lugar santo. ");
INSERT INTO spaonbv_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Luego quebrará la vasija de barro en que haya lavado su vestido. Si usó una vasija de bronce, deberá limpiarla cuidadosamente. ");
INSERT INTO spaonbv_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Cualquier hijo de los sacerdotes puede comer de esta ofrenda; pero sólo ellos, porque es santísima. ");
INSERT INTO spaonbv_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Pero los sacerdotes no podrán comer de la ofrenda por el pecado, si la sangre ha sido llevada al interior del santuario, para suplicar el perdón de Dios. La víctima será completamente quemada con fuego delante del Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","»Estas son mis órdenes sobre la ofrenda santísima por la culpa: ");
INSERT INTO spaonbv_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","La víctima será sacrificada en el lugar donde se inmola el holocausto, y la sangre será rociada varias veces a lo largo del altar. ");
INSERT INTO spaonbv_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","El sacerdote ofrecerá sobre el altar toda la grasa, la cola, la grasa que cubre los intestinos, ");
INSERT INTO spaonbv_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","los dos riñones y la grasa que los recubre, la grasa que recubre los lomos, y un pedazo del hígado. ");
INSERT INTO spaonbv_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","El sacerdote lo quemará todo sobre el altar como ofrenda al Señor por la culpa. ");
INSERT INTO spaonbv_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Todo varón de entre los sacerdotes podrá comer la víctima, y deberá hacerlo en un lugar limpio, porque es un sacrificio santísimo. ");
INSERT INTO spaonbv_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","»La misma orden se aplica a la ofrenda por el pecado y a la ofrenda por la culpa: El animal sacrificado pertenece al sacerdote que está a cargo de presentar el sacrificio, y comerá de él. ");
INSERT INTO spaonbv_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","El sacerdote que ofrece un holocausto se quedará con la piel del animal. ");
INSERT INTO spaonbv_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Lo que quede de las ofrendas de harina, después de la ceremonia, será para el sacerdote que haya oficiado, cualquiera que sea la forma de la ofrenda: al horno, al sartén o cocida en cazuela. ");
INSERT INTO spaonbv_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Todas las demás ofrendas de harina, mezcladas con aceite de oliva o secas, son propiedad de todos los hijos de Aarón. ");
INSERT INTO spaonbv_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","»Estas son mis órdenes acerca de los sacrificios presentados como ofrendas de paz al Señor: ");
INSERT INTO spaonbv_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Si es una ofrenda de acción de gracias, se deberá presentar, junto con el sacrificio, panes sin levadura amasados con aceite, hojaldres sin levadura untadas con aceite de oliva, y panes amasados con aceite de oliva. ");
INSERT INTO spaonbv_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Esta ofrenda de acción de gracias estará acompañada de panes con levadura. ");
INSERT INTO spaonbv_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Parte de este sacrificio será presentado al Señor como contribución, y será para el sacerdote que oficia, el que rocía la sangre del animal presentado para el sacrificio. ");
INSERT INTO spaonbv_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Después de que el animal haya sido sacrificado al Señor, como ofrenda de paz de olor grato y de acción de gracias al Señor, deberá comerse la carne el mismo día. No deberá dejarse nada para el día siguiente. ");
INSERT INTO spaonbv_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","»Sin embargo, si alguno trae un sacrificio que no es de acción de gracias sino como cumplimiento de un voto o una ofrenda voluntaria al Señor, cualquier porción de la víctima que no se coma el mismo día en que se sacrifique, podrá comerse al día siguiente. ");
INSERT INTO spaonbv_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","18","Si queda algo para el tercer día, será quemado, porque lo que se coma el tercer día no tendrá valor de sacrificio. No se le tomará en cuenta al que lo ofreció. El sacerdote que coma será culpable, porque esa carne será considerada impura delante del Señor. El que la coma tendrá que pagar por su pecado. ");
INSERT INTO spaonbv_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","»Toda carne que tenga contacto con algo ritualmente impuro será quemada, pues no se podrá comer. En cuanto a la carne no contaminada, sólo podrá comerla una persona que esté ritualmente limpia. ");
INSERT INTO spaonbv_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","»Si un sacerdote está ritualmente impuro y come una porción de la ofrenda de acción de gracias, será separado de su pueblo, porque ha profanado lo que es santo. ");
INSERT INTO spaonbv_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","»Cualquiera que toque algo que esté ritualmente impuro, sea de hombre o de bestia, y luego coma del sacrificio de paz, será separado de su pueblo por haber contaminado lo que es sagrado». ");
INSERT INTO spaonbv_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Entonces el Señor le dijo a Moisés ");
INSERT INTO spaonbv_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","que le dijera a los israelitas: «No coman grasa jamás, sea de bueyes, ovejas o cabras. ");
INSERT INTO spaonbv_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","La grasa de un animal que muere enfermo, o que es atacado y muerto por animales salvajes, se puede usar para otros propósitos pero no se comerá. ");
INSERT INTO spaonbv_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Cualquiera que coma grasa de una ofrenda quemada al Señor será expulsado de su pueblo. ");
INSERT INTO spaonbv_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","27","Sin importar dónde ustedes vivan, no podrán comer sangre ni grasa de aves ni de ningún animal. Cualquiera que lo haga será expulsado de su pueblo». ");
INSERT INTO spaonbv_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Y el Señor le dijo a Moisés ");
INSERT INTO spaonbv_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","que les dijera a los israelitas: «Cualquiera que traiga una ofrenda de acción de gracias al Señor, deberá traerla personalmente. ");
INSERT INTO spaonbv_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Traerá como ofrenda la grasa y el pecho, lo cual será mecido delante del altar. ");
INSERT INTO spaonbv_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Luego el sacerdote quemará la grasa sobre el altar. El pecho pertenecerá a Aarón y a sus hijos. ");
INSERT INTO spaonbv_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","33","El muslo derecho se dará como contribución para el sacerdote que oficia, ");
INSERT INTO spaonbv_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","porque he destinado el pecho y el muslo como donación del pueblo de Israel para los hijos de Aarón. A Aarón y a sus hijos debe dárseles siempre esta porción del sacrificio». ");
INSERT INTO spaonbv_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","De las ofrendas que se queman en honor al Señor, esta es la porción que les corresponde a Aarón y a sus hijos. Así ha sido desde el día que Moisés consagró como sacerdotes del Señor a Aarón y a sus hijos. ");
INSERT INTO spaonbv_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","El día que Dios los ungió, ordenó que el pueblo de Israel les diera estas porciones. Es lo que les corresponde para siempre, a través de todas las generaciones. ");
INSERT INTO spaonbv_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Estas fueron las órdenes acerca de los holocaustos, las ofrendas de harina, las ofrendas por el pecado, la ofrenda por la culpa, las ofrendas de consagración y de paz. ");
INSERT INTO spaonbv_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Estas órdenes se las dio el Señor a Moisés en el monte Sinaí, para que se las diera a conocer al pueblo de Israel, a fin de que ellos supieran cómo debían ofrecerse los sacrificios a Dios en el desierto de Sinaí. ");
INSERT INTO spaonbv_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","El Señor le dijo a Moisés: ");
INSERT INTO spaonbv_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","«Lleva ahora a la entrada del santuario a Aarón y a sus hijos, sus vestiduras, el aceite de la unción, el becerro para el sacrificio por el pecado, los dos carneros y la cesta de panes sin levadura, ");
INSERT INTO spaonbv_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","y convoca al pueblo de Israel para que se reúna allí». ");
INSERT INTO spaonbv_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Entonces Moisés hizo todo lo que el Señor le ordenó. Cuando los israelitas se reunieron a la entrada del santuario, ");
INSERT INTO spaonbv_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Moisés les dijo: «Lo que ahora voy a hacer ha sido ordenado por el Señor». ");
INSERT INTO spaonbv_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Enseguida tomó a Aarón y a sus hijos, los purificó con agua ");
INSERT INTO spaonbv_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","y le puso a Aarón la túnica, el cinto, el manto y el efod con su cinto. ");
INSERT INTO spaonbv_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Luego le puso el pectoral, y depositó el urim y tumim dentro del pectoral. ");
INSERT INTO spaonbv_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Luego colocó la mitra en la cabeza de Aarón, y sobre la mitra puso la lámina de oro, la diadema santa, tal como Dios se lo había ordenado. ");
INSERT INTO spaonbv_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Luego, Moisés tomó el aceite de la unción y lo roció sobre el santuario y sobre cada uno de sus elementos para santificarlos. ");
INSERT INTO spaonbv_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Cuando llegó al altar, lo roció siete veces y roció también los utensilios del altar, el lavamanos y su base, y los santificó. ");
INSERT INTO spaonbv_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Después derramó el aceite de la unción sobre la cabeza de Aarón consagrándolo así para el servicio. ");
INSERT INTO spaonbv_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Enseguida Moisés vistió a los hijos de Aarón con las túnicas, los cinturones y las mitras, de acuerdo con lo ordenado por el Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Después tomó el becerro para la ofrenda por el pecado. Aarón y sus hijos pusieron las manos sobre la cabeza del animal ");
INSERT INTO spaonbv_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","16","mientras Moisés lo degollaba. Con el dedo tomó sangre y la untó sobre los cuernos del altar y sobre el altar mismo para santificarlo, y derramó el resto de la sangre al pie del altar. De esta manera santificó el altar, haciendo el rito del perdón por los pecados. Tomó toda la grasa que cubría los intestinos, la grasa que cubría el hígado, los dos riñones y la grasa que los cubría, y los quemó sobre el altar. ");
INSERT INTO spaonbv_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","El becerro, la piel y el excremento fueron quemados fuera del campamento, de acuerdo con lo que el Señor le había ordenado a Moisés. ");
INSERT INTO spaonbv_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Después de esto presentó al Señor el carnero para el holocausto. Aarón y sus hijos pusieron las manos sobre la cabeza del animal ");
INSERT INTO spaonbv_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","y Moisés lo mató y roció la sangre alrededor del altar. ");
INSERT INTO spaonbv_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Enseguida descuartizó el carnero, quemó las partes, la cabeza y la grasa. ");
INSERT INTO spaonbv_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","A continuación lavó los intestinos y las extremidades en agua y los quemó sobre el altar, de modo que todo el carnero se consumió delante del Señor. Fue una ofrenda quemada de muy grato olor al Señor, por cuanto Moisés había seguido en forma estricta las órdenes que él le había dado. ");
INSERT INTO spaonbv_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","A continuación Moisés ofreció el otro carnero, el carnero de la consagración. Aarón y sus hijos pusieron sus manos sobre la cabeza del animal, ");
INSERT INTO spaonbv_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","y luego Moisés lo mató, tomó sangre y puso un poco en la oreja derecha, en el pulgar derecho de la mano y del pie derecho de Aarón. ");
INSERT INTO spaonbv_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Luego puso sangre en el lóbulo de la oreja derecha y en el pulgar de la mano derecha y el dedo gordo del pie derecho de los hijos de Aarón. El resto de la sangre lo roció a todo lo largo y ancho del altar. ");
INSERT INTO spaonbv_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Luego tomó la grasa, la cola, la grasa que cubre los intestinos y el hígado, los dos riñones con su grasa y el muslo derecho, ");
INSERT INTO spaonbv_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","y tomó del canastillo un pan sin levadura, una torta amasada con aceite y una hojaldre, y puso todo esto sobre la grasa y el muslo derecho. ");
INSERT INTO spaonbv_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Todo fue puesto en las manos de Aarón y de sus hijos para que lo ofrecieran al Señor, meciéndolo delante del altar. ");
INSERT INTO spaonbv_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Moisés entonces lo recibió de las manos de ellos y lo quemó sobre el altar, junto con el holocausto ofrecido al Señor, que se sintió complacido con esta ofrenda. Fue un sacrificio por la ordenación, una ofrenda de grato olor al Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","A continuación, Moisés tomó el pecho, lo meció y se lo presentó al Señor, delante del altar. Esta era la porción del carnero de la consagración que correspondía a Moisés, de acuerdo con las instrucciones que el Señor le había dado. ");
INSERT INTO spaonbv_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Acto seguido, tomó el aceite de la unción y un poco de sangre de la que había rociado sobre el altar, y los roció sobre Aarón y sus vestiduras, y sobre los hijos de Aarón y sus vestiduras, consagrando así para el servicio del Señor a Aarón, sus hijos y las vestiduras sacerdotales. ");
INSERT INTO spaonbv_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Entonces Moisés les dijo a Aarón y a sus hijos: «Cuezan la carne a la entrada del santuario y cómansela con el pan que está en la cesta de la consagración, tal como lo he mandado. ");
INSERT INTO spaonbv_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Lo que quede de la carne y el pan, será quemado». ");
INSERT INTO spaonbv_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Después les dijo que no salieran de la entrada del santuario durante siete días, porque necesitaban siete días para completar la consagración. ");
INSERT INTO spaonbv_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Y Moisés les dijo nuevamente que todo lo que había hecho ese día había sido ordenado por el Señor, para que sus pecados les fueran perdonados. ");
INSERT INTO spaonbv_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Luego reiteró a Aarón y a sus hijos que debían permanecer a la entrada del santuario día y noche durante siete días. Les repitió: «Si dejan su lugar, morirán, pues es lo que el Señor ha dicho». ");
INSERT INTO spaonbv_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","De esta manera cumplieron Aarón y sus hijos todo lo que el Señor le había ordenado a Moisés. ");
INSERT INTO spaonbv_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Al octavo día de las ceremonias de la consagración, Moisés convocó a Aarón, a sus hijos y a los jefes de Israel, ");
INSERT INTO spaonbv_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","y le dijo a Aarón que tomara un becerro para ofrenda por su pecado y un carnero sin defectos para el holocausto, y que los ofreciera al Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Además, Moisés le dijo a Aarón: «Diles a los israelitas que traigan un macho cabrío para ofrenda por el pecado, un becerro y un cordero de un año cada uno, todos sin defectos, para ofrecerlos como holocausto. ");
INSERT INTO spaonbv_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Además el pueblo deberá presentarle al Señor, como ofrenda de paz, un toro y un carnero, y una ofrenda de harina de la mejor calidad mezclada con aceite de oliva. Porque hoy se les aparecerá el Señor». ");
INSERT INTO spaonbv_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Entonces ellos llevaron todas estas cosas a la entrada del santuario, como Moisés lo había ordenado, y el pueblo vino y estuvo de pie delante del Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Moisés les dijo: «Si ustedes cumplen con todo lo que el Señor les ha pedido, entonces él les mostrará su gloria». ");
INSERT INTO spaonbv_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Moisés, entonces, le dijo a Aarón que caminara hacia el altar y presentara la ofrenda por el pecado y el holocausto, para que pidiera por el perdón de sus propios pecados, y después pidiera perdón por los pecados del pueblo, de acuerdo con lo ordenado por el Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Aarón se acercó al altar y mató el becerro como sacrificio por sus propios pecados. ");
INSERT INTO spaonbv_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Sus hijos le llevaron la sangre, y él mojó el dedo en ella y la untó sobre los cuernos del altar, y derramó el resto al pie del altar. ");
INSERT INTO spaonbv_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","A continuación quemó sobre el altar la grasa, los riñones y el hígado de la ofrenda por sus pecados, de acuerdo con las órdenes dadas por el Señor a Moisés, ");
INSERT INTO spaonbv_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","y quemó la carne y la piel fuera del campamento. ");
INSERT INTO spaonbv_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Le correspondió enseguida dar muerte al animal para el holocausto. Sus hijos le llevaron la sangre, y él la roció a lo largo y ancho del altar; ");
INSERT INTO spaonbv_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","le llevaron el animal descuartizado, incluida la cabeza, y lo quemó sobre el altar. ");
INSERT INTO spaonbv_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Enseguida, lavó los intestinos y las patas, y los ofreció sobre el altar como ofrenda quemada. ");
INSERT INTO spaonbv_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Acto seguido, presentó la ofrenda del pueblo. Mató el macho cabrío y lo ofreció de la misma manera que lo había hecho con la ofrenda por sus pecados. ");
INSERT INTO spaonbv_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","De esta manera ofreció el holocausto al Señor, de acuerdo con las instrucciones recibidas. ");
INSERT INTO spaonbv_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","A continuación presentó la ofrenda de harina de la mejor calidad. Tomó un puñado y lo quemó sobre el altar, junto al sacrificio de la mañana. ");
INSERT INTO spaonbv_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Después degolló el becerro y el carnero que eran los sacrificios de paz que ofrecía el pueblo. Los hijos de Aarón le llevaron la sangre, y él la roció a lo largo y ancho del altar. ");
INSERT INTO spaonbv_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Luego tomó la grasa del becerro y del carnero, la grasa de las colas, y la que cubría a los intestinos y la que cubría los riñones y el hígado. ");
INSERT INTO spaonbv_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Colocó todo esto sobre el pecho de estos animales, y Aarón los quemó sobre el altar. ");
INSERT INTO spaonbv_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Y meció los pechos y el muslo derecho, como un acto de consagración al Señor, tal como Moisés lo había ordenado. ");
INSERT INTO spaonbv_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Entonces, con las manos extendidas hacia la gente, Aarón los bendijo, y descendió del altar. ");
INSERT INTO spaonbv_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Moisés y Aarón entraron al santuario. Cuando salieron, bendijeron nuevamente al pueblo, y la gloria del Señor se apareció delante de toda la congregación. ");
INSERT INTO spaonbv_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Entonces descendió fuego de la presencia del Señor, que consumió la ofrenda y la grasa que había sobre el altar. Cuando el pueblo vio esto, dio gritos de júbilo y adoró al Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Nadab y Abiú, hijos de Aarón, pusieron fuego sin consagrar en sus incensarios, y ofrecieron incienso delante Señor. De modo que actuaron en contra de lo que el Señor les acababa de ordenar. ");
INSERT INTO spaonbv_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Entonces salió fuego de la presencia del Señor que los quemó y mató. ");
INSERT INTO spaonbv_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Moisés le dijo a Aarón: «Esto es lo que el Señor quiso decir cuando declaró: “Me santificaré entre los que se acercan a mí y seré glorificado delante de todo el pueblo”». Aarón, permaneció en silencio. ");
INSERT INTO spaonbv_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Moisés llamó a Misael y a Elzafán, primos de Aarón, hijos de Uziel, y les dijo: «¡Vayan y saquen a sus hermanos que quedaron delante del santuario y llévenlos fuera del campamento!». ");
INSERT INTO spaonbv_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Se acercaron, pues, los agarraron por sus túnicas y los sacaron fuera del campamento, como Moisés les había ordenado. ");
INSERT INTO spaonbv_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Entonces Moisés les dijo a Aarón y a sus hijos Eleazar e Itamar: «No lloren ni anden despeinados, ni se rasguen sus vestidos, en señal de duelo. Si lo hacen, el Señor se enojará contra ustedes y les dará muerte también, y hará caer su ira sobre todo el pueblo de Israel. El resto del pueblo sí puede lamentar la muerte de Nadab y Abiú y puede hacer duelo por el terrible fuego que el Señor ha enviado. ");
INSERT INTO spaonbv_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Pero ustedes no deben salir del santuario, pues si lo hacen serán castigados con la muerte, porque el Señor los ha ungido». Ellos hicieron, pues, lo que Moisés ordenó. ");
INSERT INTO spaonbv_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","9","El Señor le habló a Aarón y le dijo: «No bebas vino ni otras bebidas alcohólicas cuando tengas que entrar al santuario, o morirás. Esta norma se aplicará a tus hijos y a todos tus descendientes, de generación en generación. ");
INSERT INTO spaonbv_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Así que deben aprender a distinguir entre lo que es sagrado y lo que no lo es, entre lo puro y lo impuro, ");
INSERT INTO spaonbv_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","de modo que también podrán enseñarles a los israelitas las leyes que yo, el Señor, les he dado por medio de Moisés». ");
INSERT INTO spaonbv_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Entonces Moisés le dijo a Aarón y a los hijos que le quedaban, es decir, Eleazar e Itamar: «Tomen lo que ha quedado de la ofrenda de harina de la mejor calidad, y cómanla sin levadura, junto al altar. Es una ofrenda santísima. ");
INSERT INTO spaonbv_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Por lo tanto, la comerán en un lugar santo. Esa parte de las ofrendas presentadas por fuego al Señor te pertenece a ti y a tus hijos. Así se me ha mandado. ");
INSERT INTO spaonbv_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","»También podrán comer, en un lugar puro, el pecho que fue mecido y presentado al Señor, y el muslo que fue entregado como contribución. Es la porción que te pertenece a ti y a tus hijos e hijas, para que se alimenten. Es la porción que les pertenece de los sacrificios de paz presentados por el pueblo de Israel. ");
INSERT INTO spaonbv_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","»El pueblo debe traer el muslo que fue apartado y el pecho que se ofreció cuando se quemó la grasa, y ambos serán presentados y mecidos delante del Señor. Después de eso serán para ti y para tu familia, porque el Señor lo ha ordenado así». ");
INSERT INTO spaonbv_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Moisés buscó diligentemente el macho cabrío de la ofrenda por el pecado, y cuando descubrió que lo habían quemado, se disgustó mucho con Eleazar e Itamar, los dos hijos de Aarón. ");
INSERT INTO spaonbv_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","―¿Por qué no se comieron la ofrenda por el pecado en el santuario? —les dijo—. Es una ofrenda santísima, y Dios se la ha dado a ustedes para que quiten el pecado de la congregación, para hacer expiación por ellos delante del Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Puesto que su sangre no fue llevada al interior del santuario, debían haberla comido aquí, como les ordené. ");
INSERT INTO spaonbv_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Pero Aarón intercedió delante de Moisés. ―Ellos han presentado hoy la ofrenda por el pecado y el holocausto delante del Señor. ¡Y precisamente hoy me ha sucedido la desgracia de perder a mis hijos! Si yo hubiera comido la ofrenda por el pecado en un día como este, ¿habría agradado al Señor? ");
INSERT INTO spaonbv_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Cuando Moisés oyó la respuesta de Aarón, quedó satisfecho. ");
INSERT INTO spaonbv_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Entonces el Señor les dijo a Moisés y a Aarón: ");
INSERT INTO spaonbv_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","3","«Díganle al pueblo de Israel que los animales que pueden comer son los que tienen pezuña hendida y que rumian. ");
INSERT INTO spaonbv_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","7","Así que no se pueden comer los siguientes animales: El camello, porque aunque rumia no tiene la pezuña partida; el conejo, porque aunque rumia no tiene la pezuña partida; la liebre, porque aunque rumia no tiene la pezuña partida; el cerdo, porque aunque tiene la pezuña partida, no es rumiante. ");
INSERT INTO spaonbv_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","»No comerán la carne de ellos ni tocarán sus cuerpos muertos. Tales animales están prohibidos para ustedes. ");
INSERT INTO spaonbv_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","»En cuanto a los animales que viven en el mar o en los ríos, comerán los que tienen aletas y escamas. ");
INSERT INTO spaonbv_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Los demás animales que hay en el agua no los comerán. ");
INSERT INTO spaonbv_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Les prohíbo estrictamente que los coman, o que toquen sus cuerpos muertos. ");
INSERT INTO spaonbv_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Repito: les prohíbo que coman cualquier animal acuático que no tenga aletas ni escamas. ");
INSERT INTO spaonbv_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","19","»Entre las aves, estas son las que no pueden comer: El águila, el quebrantahuesos, el azor, el gallinazo, el milano de todas las especies, el cuervo de todas las especies, el avestruz, la lechuza, la gaviota, el gavilán de todas las especies, el búho, el somormujo, el ibis, el calamón, el pelícano, el buitre, la cigüeña, la garza de todas las especies, la abubilla y el murciélago. ");
INSERT INTO spaonbv_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","»Les prohíbo que coman los insectos voladores de cuatro patas, ");
INSERT INTO spaonbv_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","22","excepto los que saltan. Podrán comer langostas de todas las especies, saltamontes de todas las especies y grillos. ");
INSERT INTO spaonbv_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Los demás insectos alados que tienen cuatro patas están prohibidos. ");
INSERT INTO spaonbv_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","»Cualquiera que toque sus cuerpos muertos quedará impuro hasta la noche, ");
INSERT INTO spaonbv_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","y deberá lavarse la ropa de inmediato. Además, se aislará hasta la noche por estar ritualmente impuro. ");
INSERT INTO spaonbv_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","»También quedarán impuros cuando toquen cualquier animal que no tenga la pezuña partida ni sea rumiante. ");
INSERT INTO spaonbv_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","»Les prohíbo que coman animales que caminan sobre garras. La persona que toque un animal muerto de este tipo quedará impura hasta la noche. ");
INSERT INTO spaonbv_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","La persona que saque el animal muerto deberá lavarse la ropa y permanecerá impura hasta la noche. Es algo que está prohibido. ");
INSERT INTO spaonbv_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","30","»Estos son los animales impuros que se arrastran por el suelo: El topo, el ratón, el lagarto, la lagartija, el erizo, el cocodrilo, la rana y el camaleón. ");
INSERT INTO spaonbv_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","»La persona que toque alguno de estos animales muertos quedará impura hasta la noche. ");
INSERT INTO spaonbv_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","»Cualquier objeto, sin importar de qué material esté hecho, sobre el que caiga el animal muerto, quedará impuro, y deberán dejarlo en agua hasta el anochecer. ");
INSERT INTO spaonbv_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","»Si el animal muerto cae en una vasija de alfarería, todo lo que esté dentro de ella quedará impuro, y tendrán que romper la vasija. ");
INSERT INTO spaonbv_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Si el agua usada para purificar el artículo impuro toca algún alimento, este quedará impuro. También quedará impura la bebida que toque. ");
INSERT INTO spaonbv_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","»Si uno de estos animales muertos toca un horno de barro, este quedará impuro y habrá que derribarlo. ");
INSERT INTO spaonbv_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Si el animal cae sobre una cisterna donde hay agua, el agua no se contaminará, pero la persona que saque el animal quedará impura. ");
INSERT INTO spaonbv_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","»Si el animal muerto toca la semilla que se iba a sembrar en el campo, esa semilla no se contamina, ");
INSERT INTO spaonbv_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","a menos que la semilla estuviera húmeda cuando el animal cayó sobre ella. En este caso la semilla sí se contamina. ");
INSERT INTO spaonbv_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","»Si algún animal de los que se pueden comer muere de enfermedad, y alguien lo toca, esa persona quedará impura hasta el anochecer. ");
INSERT INTO spaonbv_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Además, cualquier persona que coma esa carne o saque el animal tendrá que lavarse la ropa y quedará impura hasta el anochecer. ");
INSERT INTO spaonbv_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","42","»No comerán animales que se arrastran sobre la tierra. Esto incluye a reptiles que se deslizan sobre el vientre y los que tienen patas. Ningún animal que se arrastra y tiene muchas patas se podrá comer, porque es impuro. ");
INSERT INTO spaonbv_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","No se contaminen tocándolos. ");
INSERT INTO spaonbv_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","»Yo soy el Señor su Dios. Consérvense puros en estas cosas y sean santos, porque yo soy santo. Por lo tanto, no se contaminen tocando estos animales que se arrastran sobre la tierra. ");
INSERT INTO spaonbv_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Yo soy el Señor, el que los sacó de Egipto para ser su Dios. Por lo tanto, deben ser santos como yo soy santo. ");
INSERT INTO spaonbv_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","»Estas son las leyes acerca de animales, aves, animales acuáticos y reptiles. ");
INSERT INTO spaonbv_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Estas son las distinciones entre los animales que son ritualmente puros y se pueden comer, y los que son ritualmente impuros y no se pueden comer». ");
INSERT INTO spaonbv_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","El Señor le dijo a Moisés que le diera las siguientes instrucciones al pueblo de Israel: ");
INSERT INTO spaonbv_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","«Cuando nazca un niño, la madre quedará ritualmente impura por siete días, y quedará sujeta a las mismas restricciones a que se somete durante su menstruación. ");
INSERT INTO spaonbv_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Al octavo día circuncidará a su hijo. ");
INSERT INTO spaonbv_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Luego, durante los treinta y tres días siguientes, mientras se recupera de su impureza ritual, no debe tocar ninguna cosa sagrada, ni debe entrar en el santuario. ");
INSERT INTO spaonbv_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","»Cuando nazca una niña, la impureza ceremonial de la madre durará dos semanas, lapso en que quedará sujeta a las mismas restricciones del período menstrual. Su recuperación durará sesenta y seis días. ");
INSERT INTO spaonbv_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","»Cuando hayan pasado los días de su purificación, y esto se aplica tanto si su bebé es niño o niña, deberá presentar un cordero de un año como holocausto, y un pichón de paloma o una tórtola como ofrenda por su pecado. Debe llevarlos a la puerta del santuario y entregarlos al sacerdote. ");
INSERT INTO spaonbv_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","El sacerdote, entonces, los ofrecerá delante del Señor, y pedirá perdón por los pecados de ella. Después de esto, la mujer será declarada ritualmente pura de su flujo de sangre. Este es el procedimiento que debe seguir después del parto. ");
INSERT INTO spaonbv_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","»Pero si ella es muy pobre y no puede ofrecer un cordero, deberá llevar dos pichones de paloma o dos tórtolas. Uno será para el holocausto y el otro para la ofrenda por su pecado. El sacerdote, entonces, pedirá perdón por los pecados de ella, y la mujer quedará purificada». ");
INSERT INTO spaonbv_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","El Señor les dijo a Moisés y a Aarón: ");
INSERT INTO spaonbv_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","«Si alguien nota que en la piel le ha salido una hinchazón, un sarpullido o mancha blanca, sospechará que tiene lepra. Deberá ser conducido ante el sacerdote Aarón, o ante alguno de sus hijos, ");
INSERT INTO spaonbv_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","para que examine el lugar afectado. Si el vello de aquel lugar se le pone blanco y la llaga parece estar más hundida que la piel, se trata de lepra, y el sacerdote lo declarará oficialmente leproso. ");
INSERT INTO spaonbv_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","»Pero, si la parte blanca de la piel no parece más hundida que el resto, y el vello de aquel lugar no se ha puesto blanco, el sacerdote aislará al enfermo durante siete días. ");
INSERT INTO spaonbv_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Al cabo de los siete días, el sacerdote lo volverá a examinar. Si no ha habido variación en la mancha, ni se ha extendido por la piel, lo aislará otros siete días. ");
INSERT INTO spaonbv_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Al séptimo día nuevamente lo examinará, y si la mancha de la piel ha disminuido y no se han extendido, el sacerdote lo declarará sano. Era una erupción. Entonces la persona afectada sólo lavará su ropa y volverá a su vida normal. ");
INSERT INTO spaonbv_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","»Pero si la mancha se ha extendido por la piel, después de que la persona fue declarada sana, entonces tendrá que volver a presentarse ante el sacerdote. ");
INSERT INTO spaonbv_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Si al examinar a la persona, el sacerdote descubre que la mancha se ha extendido sobre la piel, entonces la declarará impura. Se trata de un caso de lepra. ");
INSERT INTO spaonbv_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","10","»Cuando una persona presente una llaga en la piel, tendrá que ser llevada ante el sacerdote. Si al examinar a la persona, el sacerdote nota que la llaga y el vello se han puesto blancos, y se ve la carne viva, ");
INSERT INTO spaonbv_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","entonces se trata de un caso de lepra. El sacerdote debe declarar impura a esa persona, pero no tendrá que aislarla para tenerla en observación, porque se ha comprobado definitivamente que se trata de lepra. ");
INSERT INTO spaonbv_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","»Pero si el sacerdote ve que la mancha ha brotado y se ha esparcido por todo su cuerpo, de pies a cabeza, ");
INSERT INTO spaonbv_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","declarará a esa persona sin lepra, porque la mancha se ha vuelto completamente blanca, y no es lepra. ");
INSERT INTO spaonbv_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","15","Pero si aparece carne viva en algún lugar, la persona será declarada leprosa. Lo comprueba la carne viva. ");
INSERT INTO spaonbv_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","17","Pero si la carne viva se vuelve blanca, la persona enferma acudirá al sacerdote para ser examinada nuevamente. Si el lugar en realidad se ha vuelto completamente blanco, el sacerdote la declarará sin lepra. ");
INSERT INTO spaonbv_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","»En el caso de que una persona haya tenido un absceso en la piel, ");
INSERT INTO spaonbv_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","y que este al sanar haya dejado una hinchazón o una mancha blanca o rojiza, deberá acudir al sacerdote para ser examinada. ");
INSERT INTO spaonbv_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Si el sacerdote ve que la parte afectada está un poco más hundida que el resto de la piel y que el vello del lugar se ha vuelto blanco, la declarará impura, porque ha brotado lepra. ");
INSERT INTO spaonbv_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Pero si el sacerdote no encuentra vellos blancos en el punto afectado, y este no parece estar más hundido que el resto de la piel, y si el color es gris, aislará a la persona durante siete días. ");
INSERT INTO spaonbv_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Si durante ese lapso la mancha se extiende, el sacerdote la declarará leprosa. ");
INSERT INTO spaonbv_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Pero si no parece mayor, y no se ha extendido, se trata solamente de la cicatriz del absceso, y el sacerdote la declarará limpia. ");
INSERT INTO spaonbv_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","»Si alguien se quema en cualquier forma, y la parte quemada se pone de un color blanco rojizo, ");
INSERT INTO spaonbv_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","el sacerdote deberá examinar la parte afectada. Si el vello de aquel lugar se pone blanco, y la parte quemada se ve más hundida que el resto de la piel, es lepra que ha brotado en la quemadura, y el sacerdote deberá declararlo leproso. ");
INSERT INTO spaonbv_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Pero si el sacerdote ve que no hay vellos blancos y que la mancha no está más hundida que el resto de la piel, y que está disminuyendo, lo aislará por siete días. ");
INSERT INTO spaonbv_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Al cabo de los siete días lo volverá a examinar. Si la mancha se ha extendido por la piel, el sacerdote lo declarará leproso. ");
INSERT INTO spaonbv_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Pero si el lugar afectado no se ha extendido, y se ve que ha disminuido, se trata sólo de la cicatriz de la quemadura, y el sacerdote lo declarará limpio. ");
INSERT INTO spaonbv_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","30","»Si una persona, hombre o mujer, tiene una llaga en la cabeza o en el mentón, acudirá al sacerdote para que examine la llaga. Si la llaga parece estar más hundida que el resto de la piel y se encuentra vello amarillento en ella, el sacerdote declarará leprosa a esa persona. ");
INSERT INTO spaonbv_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Pero si el examen del sacerdote revela que la llaga es superficial y que está cubierta con vello negro, aislará al enfermo durante siete días ");
INSERT INTO spaonbv_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","para examinarlo al final de ese plazo. Si la llaga no se ha extendido ni se ha puesto amarillo el vello, y si no parece estar más hundida que el resto de la piel, ");
INSERT INTO spaonbv_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","le afeitará todo el vello que la rodea, sin tocar los de la parte infectada, y lo aislará por otros siete días. ");
INSERT INTO spaonbv_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Será examinado nuevamente el séptimo día, y si la llaga no se ha extendido y no pareciera estar más hundida que el resto de la piel, el sacerdote lo declarará sano. El enfermo lavará su ropa, y quedará libre. ");
INSERT INTO spaonbv_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","»Pero, si más adelante, comienza a extenderse la llaga, ");
INSERT INTO spaonbv_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","el sacerdote deberá examinarlo nuevamente y, sin esperar a que aparezcan vellos amarillos, lo declarará leproso. ");
INSERT INTO spaonbv_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Pero si se ve claramente que la herida ha dejado de extenderse y que los vellos del lugar son negros, es porque dicha persona está sana, así que el sacerdote la declarará sin lepra. ");
INSERT INTO spaonbv_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","»Si una persona, hombre o mujer, presenta manchas blancuzcas en la piel, ");
INSERT INTO spaonbv_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","pero estas se están oscureciendo, no es lepra. Se trata sólo de una infección común de la piel. Por eso, dicha persona es pura. ");
INSERT INTO spaonbv_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","»Si un hombre pierde el cabello, aunque quede calvo, no es leproso. ");
INSERT INTO spaonbv_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","El que pierde el cabello de la frente es calvo, pero no es leproso. ");
INSERT INTO spaonbv_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Pero si en la calva le sale una mancha de color rojizo, puede tratarse de un caso de lepra. ");
INSERT INTO spaonbv_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","El sacerdote lo examinará, y si ve que la mancha es de color rojizo, como de lepra, ");
INSERT INTO spaonbv_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","se trata efectivamente de lepra, y el sacerdote así lo declarará. ");
INSERT INTO spaonbv_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","»La persona en la que se encuentre una infección deberá rasgar su ropa, andar despeinada, cubrirse el rostro hasta el labio superior y anunciar mientras camina: “¡Soy impuro! ¡Soy impuro!”. ");
INSERT INTO spaonbv_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Mientras dure la enfermedad será considerado impuro, y tendrá que vivir fuera del campamento. ");
INSERT INTO spaonbv_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","48","»Cuando aparezca una mancha en un vestido de lana o de lino, o en un objeto de piel o en un utensilio de cuero, ");
INSERT INTO spaonbv_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","y sea de color verdusco o rojizo, será llevado al sacerdote para que examine la mancha. ");
INSERT INTO spaonbv_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","El sacerdote aislará el objeto por siete días ");
INSERT INTO spaonbv_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","y examinará la mancha nuevamente el séptimo día. Si se ha extendido, se trata de un hongo maligno. ");
INSERT INTO spaonbv_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Entonces el artículo, sin importar del material que sea, deberá ser quemado, porque es un hongo maligno que debe ser destruido por fuego. ");
INSERT INTO spaonbv_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","»Pero, si al examinarlo nuevamente al séptimo día, el sacerdote observa que la mancha no se ha extendido, ");
INSERT INTO spaonbv_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","ordenará que se lave el artículo y que se aísle por otros siete días. ");
INSERT INTO spaonbv_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Si después de ese plazo la mancha no ha cambiado de color, aun cuando no se haya extendido, se quemará la prenda, pues es impura. ");
INSERT INTO spaonbv_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","»Pero si el sacerdote ve que la mancha ha disminuido después de lavar la prenda, solo cortará la parte en la cual está la mancha. ");
INSERT INTO spaonbv_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Si la mancha vuelve a aparecer en la prenda, esta será quemada. ");
INSERT INTO spaonbv_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Si después de lavarla no reaparece la mancha, se podrá usar nuevamente, lavándola por segunda vez, y la prenda será declarada pura». ");
INSERT INTO spaonbv_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Estas son las normas acerca de las manchas que se descubren en la ropa o en otras cosas hechas de piel o de cuero, para determinar si esas prendas deben considerarse puras o impuras. ");
INSERT INTO spaonbv_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","El Señor le dio a Moisés las siguientes instrucciones ");
INSERT INTO spaonbv_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","acerca de la persona que se cura de alguna infección cutánea, de modo que es declarada pura: «La persona que estuvo infectada será llevada ante el sacerdote, ");
INSERT INTO spaonbv_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","para ser examinada. El sacerdote saldrá al campo para examinarla. Si ve que la infección ha desaparecido, ");
INSERT INTO spaonbv_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","pedirá que le traigan dos avecillas vivas y puras, madera de cedro, una cinta roja y una rama de hisopo. ");
INSERT INTO spaonbv_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Luego, el sacerdote ordenará que una de las aves sea degollada sobre una vasija de barro llena de agua pura. ");
INSERT INTO spaonbv_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Después tomará la otra avecilla, es decir, la que está viva, la mojará en la sangre junto con la madera de cedro, la cinta roja y el hisopo. ");
INSERT INTO spaonbv_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","A continuación, el sacerdote rociará siete veces la sangre sobre la persona que fue curada, la declarará limpia, y dejará libre el ave para que vuele hacia el campo. ");
INSERT INTO spaonbv_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","»Enseguida la persona curada lavará su ropa, se rapará el pelo, se bañará y volverá a vivir en el campamento. Sin embargo, deberá permanecer fuera de su carpa durante siete días. ");
INSERT INTO spaonbv_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Al séptimo día volverá a afeitarse la cabeza, la barba y las cejas, lavará su ropa y se bañará, y después esa persona será declarada completamente curada, y será declarada definitivamente limpia. ");
INSERT INTO spaonbv_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","»Al día siguiente, es decir, al octavo día, tomará dos corderos sin defectos y una cordera de un año sin defectos, seis kilos de harina de la mejor calidad mezclada con aceite de oliva, y un tercio de litro de aceite de oliva. ");
INSERT INTO spaonbv_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Entonces el sacerdote que realiza la purificación presentará a la persona y su ofrenda delante del Señor, a la entrada del santuario. ");
INSERT INTO spaonbv_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","El sacerdote tomará uno de los corderos y el tercio del litro de aceite de oliva y lo ofrecerá al Señor como ofrenda por la culpa, meciéndolos delante del altar. ");
INSERT INTO spaonbv_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Enseguida, matará el cordero en el lugar en que se degüellan los animales que se ofrecen por el pecado y los animales de los holocaustos. Esta ofrenda por la culpa será entregada al sacerdote para su alimento, tal como se hace con una ofrenda por el pecado. Es una ofrenda santísima. ");
INSERT INTO spaonbv_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","El sacerdote tomará sangre del animal sacrificado por la culpa y la untará en el lóbulo de la oreja derecha, sobre el pulgar de la mano derecha y en el dedo gordo del pie derecho de la persona que se está purificando. ");
INSERT INTO spaonbv_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","A continuación, el sacerdote tomará aceite de oliva y lo derramará en la palma de su mano izquierda, ");
INSERT INTO spaonbv_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","se mojará el índice derecho y rociará siete veces delante del Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Del aceite que le quede en la mano, el sacerdote untará un poco en el lóbulo de la oreja derecha, en el pulgar de la mano derecha y en el dedo gordo del pie derecho de la persona que se está purificando, de la misma manera que lo hizo con la sangre de la ofrenda por la culpa. ");
INSERT INTO spaonbv_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","El resto del aceite lo usará para ungir a la persona en la cabeza. De esta manera el sacerdote pedirá al Señor el perdón para aquella persona. ");
INSERT INTO spaonbv_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","El sacerdote deberá presentar la ofrenda por el pecado y realizar el rito de la expiación por la persona que se está purificando de la infección; acto seguido degollará el cordero para el holocausto, ");
INSERT INTO spaonbv_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","y lo presentará con la ofrenda de harina sobre el altar, y hará expiación por esa persona, y la declarará completamente purificada. ");
INSERT INTO spaonbv_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","»En caso de que quien se purifica fuera tan pobre que no pudiera comprar dos corderos, presentará solamente uno, el cordero para la ofrenda por la culpa, el cual será ofrecido al Señor, meciéndolo delante del altar, y además presentará sólo dos kilos de harina de la mejor calidad amasada con aceite de oliva, y un cuarto de litro de aceite de oliva. ");
INSERT INTO spaonbv_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Además, llevará, según sus posibilidades, dos tórtolas o dos pichones de paloma, y usará una de ellas como ofrenda por su pecado y la otra como holocausto. ");
INSERT INTO spaonbv_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Llevará los animales al sacerdote a la entrada del santuario, al octavo día, para realizar su ceremonia de purificación delante del Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","El sacerdote tomará el cordero para la ofrenda por la culpa, y el cuarto del litro de aceite y los mecerá delante del altar y los ofrecerá al Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Enseguida degollará el cordero y pondrá sangre en el lóbulo de la oreja derecha, en el pulgar de la mano derecha y en el dedo gordo del pie derecho de quien se está purificando. ");
INSERT INTO spaonbv_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Luego, el sacerdote derramará aceite de oliva en la palma de su mano izquierda, ");
INSERT INTO spaonbv_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","y con el índice de la mano derecha rociará siete veces delante del Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","A continuación, de su mano tomará aceite de oliva y lo untará en el lóbulo de la oreja derecha, en el pulgar de la mano derecha y en el dedo gordo del pie derecho de quien se está purificando, de la misma manera que lo hizo con la sangre de la ofrenda por la culpa. ");
INSERT INTO spaonbv_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","El resto del aceite que tiene en la mano lo pondrá sobre la cabeza de la persona que se está purificando, para hacer expiación por ella delante del Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Después de esto, deberá ofrecer las dos tórtolas o los dos pichones de paloma, según lo que la persona haya podido conseguir. ");
INSERT INTO spaonbv_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Una de las aves será para la ofrenda por el pecado y la otra para el holocausto, junto con la ofrenda de harina; y el sacerdote hará expiación por aquella persona delante del Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","»Estas, pues, son las leyes acerca de las personas pobres que se purifican de alguna infección cutánea, y que no pueden presentar los sacrificios normalmente requeridos para su purificación». ");
INSERT INTO spaonbv_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","34","Entonces el Señor les dijo a Moisés y Aarón: «Cuando lleguen a la tierra de Canaán, que yo les he dado, si ven que aparecen hongos o moho en las paredes de una casa, ");
INSERT INTO spaonbv_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","el propietario acudirá al sacerdote para informarle, diciéndole: “En mi casa han aparecido unas manchas”. ");
INSERT INTO spaonbv_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","El sacerdote ordenará que se desocupe la casa antes de examinarla, para que no se declaren impuras las cosas, en caso de que llegue a la conclusión de que la casa está contaminada. ");
INSERT INTO spaonbv_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Si encuentra manchas verdosas o rojizas en las paredes de la casa, y que al parecer no son superficiales, ");
INSERT INTO spaonbv_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","cerrará la casa por siete días. ");
INSERT INTO spaonbv_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Regresará el día séptimo para examinarla nuevamente. Si las manchas se han esparcido por las paredes, ");
INSERT INTO spaonbv_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","el sacerdote ordenará que se quiten las piedras que están manchadas. El material sacado será arrojado en un lugar impuro, fuera de la ciudad. ");
INSERT INTO spaonbv_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Luego ordenará que raspen las paredes de la casa en forma completa y que arrojen el polvo que salga en un lugar impuro, fuera de la ciudad. ");
INSERT INTO spaonbv_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","En el lugar donde estaban las manchas, colocarán piedras nuevas, usando nueva mezcla para pegarlas, y toda la casa será resanada con material nuevo. ");
INSERT INTO spaonbv_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","»Pero si la mancha aparece nuevamente, ");
INSERT INTO spaonbv_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","el sacerdote irá a examinarla, y si ve que se ha extendido, declarará que la casa es impura por tener un hongo maligno. ");
INSERT INTO spaonbv_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Acto seguido ordenará la destrucción de la casa, y todos los materiales: piedras, madera y todo el polvo, serán llevados fuera de la ciudad, a un lugar impuro. ");
INSERT INTO spaonbv_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","»Cualquier persona que entre en la casa mientras está cerrada, quedará impura hasta el anochecer. ");
INSERT INTO spaonbv_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Cualquiera que se acueste o coma en la casa deberá lavar su ropa. ");
INSERT INTO spaonbv_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","»Pero si al volver el sacerdote a examinar la casa, observa que las manchas no han reaparecido después de haber sido resanada de nuevo, declarará que la casa está limpia y que el hongo ha desaparecido. ");
INSERT INTO spaonbv_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","»Además, celebrará la ceremonia de la purificación usando dos aves, madera de cedro, cinta roja y ramas de hisopo. ");
INSERT INTO spaonbv_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Degollará una de las avecillas sobre una vasija de barro llena de agua pura, ");
INSERT INTO spaonbv_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","52","y mojará la madera de cedro, el hisopo, la cinta roja y la otra avecilla en la sangre del ave que fue sacrificada, y rociará la casa siete veces. De esta manera se realizará la ceremonia de purificación de la casa. ");
INSERT INTO spaonbv_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Enseguida soltará el ave viva para que vuele hacia el campo, fuera de la ciudad. De esta manera se hará la expiación y la purificación de la casa. ");
INSERT INTO spaonbv_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","55","»Estas, pues, son las leyes acerca de la infección de la piel, de los hongos o manchas en la ropa o en la casa, ");
INSERT INTO spaonbv_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","como también de las inflamaciones, erupciones o manchas de la piel. ");
INSERT INTO spaonbv_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","De esta manera se puede saber cuándo algo es puro o impuro. Por esta razón se dan estas leyes». ");
INSERT INTO spaonbv_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","El Señor habló a Moisés y a Aarón para darles más instrucciones para el pueblo. ");
INSERT INTO spaonbv_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","Les dijo: «El hombre que tenga una infección en el pene, es ritualmente impuro, ");
INSERT INTO spaonbv_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","ya sea que la infección de su pene supure o no. ");
INSERT INTO spaonbv_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","»La cama en que duerma o cualquier lugar en que se siente quedará contaminado, ");
INSERT INTO spaonbv_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","y cualquiera que toque su cama quedará ritualmente impuro hasta el anochecer, y tendrá que lavar su ropa y bañarse. ");
INSERT INTO spaonbv_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","La persona que se siente donde el hombre con flujo se haya sentado quedará ceremonialmente impura hasta la tarde, tendrá que lavar su ropa y bañarse. ");
INSERT INTO spaonbv_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Lo mismo se aplica para quien toque al afectado. ");
INSERT INTO spaonbv_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Si este hombre escupe sobre alguna persona, esta queda impura hasta la noche y tendrá que lavar su ropa y bañarse. ");
INSERT INTO spaonbv_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Toda silla en que cabalgue el que padece de flujo queda impura, ");
INSERT INTO spaonbv_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","y cualquiera que toque o lleve alguna cosa que haya estado debajo del afectado quedará impuro hasta la tarde, y tendrá que lavar su ropa y bañarse. ");
INSERT INTO spaonbv_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Si el impuro toca la mano de alguien, sin haberse lavado las manos antes, la persona que toque tendrá que lavar su ropa y bañarse, y quedará impura hasta la noche. ");
INSERT INTO spaonbv_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Si el hombre toca alguna vasija de barro esta deberá romperse, y si toca utensilios de madera, deberán lavarse con agua. ");
INSERT INTO spaonbv_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","»Cuando haya cesado la supuración, el hombre iniciará una ceremonia de purificación que durará siete días. Primero lavará su ropa y se bañará con agua de manantial. ");
INSERT INTO spaonbv_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Al octavo día tomará dos tórtolas o dos pichones de paloma y se presentará delante del Señor, a la entrada del santuario, y se los entregará al sacerdote. ");
INSERT INTO spaonbv_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","El sacerdote los ofrecerá allí, uno como ofrenda por el pecado y el otro en holocausto. De esta manera el sacerdote hará expiación delante del Señor por el hombre que haya padecido de flujo. ");
INSERT INTO spaonbv_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","»Cuando el hombre tenga una emisión de semen se bañará completamente y quedará impuro hasta la noche. ");
INSERT INTO spaonbv_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","La ropa de vestir o de cama que haya sido manchada por el semen deberá lavarse y quedará impura hasta la noche. ");
INSERT INTO spaonbv_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Después de la relación conyugal, la mujer y el hombre deberán bañarse y quedarán ritualmente impuros hasta la noche siguiente. ");
INSERT INTO spaonbv_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","»Cuando una mujer tenga su flujo menstrual quedará ritualmente impura los siete días siguientes al término de su menstruación. Todo el que la toque durante ese tiempo quedará impuro hasta la noche. ");
INSERT INTO spaonbv_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","El lugar en que la mujer se acueste o se siente durante el tiempo de su impureza, quedará impuro. ");
INSERT INTO spaonbv_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","23","Cualquiera que toque su cama o su asiento deberá lavarse la ropa, y bañarse, y quedará impuro hasta la noche. ");
INSERT INTO spaonbv_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","El hombre que tenga relaciones con ella durante este tiempo, quedará ritualmente impuro durante siete días, y la cama en que se acueste quedará impura. ");
INSERT INTO spaonbv_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","»Si el flujo menstrual se prolonga más allá de lo normal u ocurre en alguna fecha imprevista del mes, se aplicará la misma regla anterior, ");
INSERT INTO spaonbv_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","de modo que la cama en que ella se acueste quedará impura, como habría ocurrido durante su período menstrual ordinario, y el asiento que ocupe quedará también impuro. ");
INSERT INTO spaonbv_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Si alguien toca su cama o su asiento quedará impuro y tendrá que lavar su ropa y bañarse, y su impureza durará hasta la noche. ");
INSERT INTO spaonbv_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","»Después de que cese su flujo, contará siete días para poder considerarse pura. ");
INSERT INTO spaonbv_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Al octavo día tomará dos tórtolas o dos pichones de paloma y los llevará al sacerdote, a la entrada del santuario. ");
INSERT INTO spaonbv_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Entonces el sacerdote presentará un ave como ofrenda por el pecado y la otra como holocausto. Así hará expiación por ella delante del Señor a causa de su impureza menstrual. ");
INSERT INTO spaonbv_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","»De esta manera purificarán al pueblo de Israel, para que no mueran al contaminar mi santuario que está en medio de ellos. ");
INSERT INTO spaonbv_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","»Esta es, pues, la ley para el hombre que está ritualmente impuro por una enfermedad genital o por una emisión seminal, ");
INSERT INTO spaonbv_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","y para la mujer que está impura por su período menstrual, y para cualquiera que tenga relaciones con una mujer mientras dura su período de impureza». ");
INSERT INTO spaonbv_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Después de la muerte de los dos hijos de Aarón, que murieron por haber actuado en forma incorrecta al acercarse al Señor, ");
INSERT INTO spaonbv_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","le dijo el Señor a Moisés: «Adviértele a tu hermano Aarón que no puede entrar en cualquier momento al Lugar Santísimo, que está detrás de la cortina, donde se encuentra el cofre del pacto cubierto con el propiciatorio. El castigo por hacerlo es la muerte. Porque yo mismo estoy presente en la nube que está sobre el propiciatorio. ");
INSERT INTO spaonbv_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","»Sólo cumpliendo estas condiciones podrá entrar: Deberá ofrecer un novillo como ofrenda por su pecado, y un carnero para el holocausto. ");
INSERT INTO spaonbv_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Se bañará y se pondrá las vestiduras sagradas, la túnica de lino, los calzones de lino, el cinturón de lino y el turbante de lino. ");
INSERT INTO spaonbv_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","»Entonces el pueblo de Israel le llevará dos machos cabríos para la ofrenda por el pecado y un carnero para el holocausto. ");
INSERT INTO spaonbv_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","En primer lugar, ofrecerá al Señor el novillo como sacrificio expiatorio por su propio pecado y el pecado de su familia. ");
INSERT INTO spaonbv_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","A continuación llevará los dos machos cabríos ante la presencia del Señor, a la entrada del santuario ");
INSERT INTO spaonbv_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","y echará suertes para determinar cuál será el del Señor y cuál será dejado libre. ");
INSERT INTO spaonbv_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","El macho cabrío asignado al Señor será sacrificado por Aarón, como ofrenda por el pecado. ");
INSERT INTO spaonbv_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","El otro será conservado vivo y será colocado delante del Señor. Sobre él se realizará la ceremonia de la expiación, y enseguida será enviado al desierto, para Azazel. ");
INSERT INTO spaonbv_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","»Después de que Aarón haya sacrificado el novillo como ofrenda expiatoria por sí mismo y por su familia, ");
INSERT INTO spaonbv_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","tomará un incensario lleno de brasas del altar, y dos puñados de incienso aromático, finamente molido, y entrará al recinto que está detrás de la cortina. ");
INSERT INTO spaonbv_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Allí, delante del Señor, pondrá incienso sobre las brasas, para que la nube de incienso cubra el propiciatorio que está sobre el cofre del pacto. De esta manera no morirá. ");
INSERT INTO spaonbv_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Llevará sangre del novillo y rociará siete veces con su dedo la parte oriental del propiciatorio, y siete veces delante del propiciatorio. ");
INSERT INTO spaonbv_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","»Luego saldrá y sacrificará el macho cabrío elegido para la expiación de los pecados; entrará con la sangre al interior de la cortina y rociará con ella encima y delante del propiciatorio, de la misma manera que lo hizo con la sangre del novillo. ");
INSERT INTO spaonbv_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Así purificará el santuario de los pecados de los hijos de Israel. Y lo mismo hará por el santuario que está en medio de ellos, rodeado de sus impurezas. ");
INSERT INTO spaonbv_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Ninguna otra persona entrará al santuario cuando Aarón entre allí a hacer la purificación. Nadie podrá entrar al santuario mientras Aarón esté haciendo expiación por sí mismo, por su familia, y por todo el pueblo de Israel. ");
INSERT INTO spaonbv_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","»Luego Aarón saldrá y hará expiación sobre el altar. Pondrá sangre del novillo y del macho cabrío sobre los cuernos del altar, ");
INSERT INTO spaonbv_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","y rociará sangre sobre el altar, siete veces con su dedo, y de esta manera lo purificará de los pecados de Israel, y lo santificará. ");
INSERT INTO spaonbv_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","»Cuando haya terminado de purificar el santuario, la Tienda de reunión y el altar, tomará el macho cabrío vivo, ");
INSERT INTO spaonbv_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","pondrá las manos sobre la cabeza del animal y confesará sobre él los pecados del pueblo de Israel. Depositará todos los pecados sobre la cabeza del animal y lo enviará al desierto por medio de un hombre designado para eso. ");
INSERT INTO spaonbv_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","El hombre lo soltará en el desierto, y de este modo el macho cabrío llevará todos los pecados del pueblo a una tierra deshabitada. ");
INSERT INTO spaonbv_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","»Aarón entrará en el santuario nuevamente; se quitará las vestiduras de lino con que entró al Lugar Santísimo, y las dejará en el santuario. ");
INSERT INTO spaonbv_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Se bañará en un lugar santo, se pondrá sus vestiduras y saldrá para ofrecer el holocausto por sí mismo y el holocausto por el pueblo, haciendo, así, expiación por él y por el pueblo. ");
INSERT INTO spaonbv_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","También quemará sobre el altar la grasa de la ofrenda por el pecado. ");
INSERT INTO spaonbv_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","»En cuanto al hombre que lleve el macho cabrío al desierto, lavará su ropa, se bañará y luego regresará al campamento. ");
INSERT INTO spaonbv_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","»El novillo y el macho cabrío que son ofrecidos en sacrificio, cuya sangre será llevada por Aarón al Lugar Santo para hacer expiación, serán llevados fuera del campamento, donde se quemarán junto con la piel y los órganos internos. ");
INSERT INTO spaonbv_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Después la persona encargada de quemarlos lavará su ropa y se bañará antes de regresar al campamento. ");
INSERT INTO spaonbv_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","30","»Esta es una ley permanente: No trabajarán el décimo día del séptimo mes. Pasarán el día examinándose y humillándose. Esto se aplica a los nacidos en la tierra de Israel y a los extranjeros que vivan entre el pueblo. Es el día en que se celebrará la expiación para que sean limpios de todos sus pecados delante del Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Será un día solemne de completo descanso y ayuno. Esta es una ley perpetua. ");
INSERT INTO spaonbv_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","»En las generaciones venideras, esta ceremonia será oficiada por el sacerdote que haya sido elegido y consagrado en lugar de su padre. Se pondrá las vestiduras sagradas de lino, ");
INSERT INTO spaonbv_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","y hará expiación por el Lugar Santísimo, por el santuario, es decir, la Tienda de reunión, por el altar, por los sacerdotes y por el pueblo. ");
INSERT INTO spaonbv_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","»Esta será una ley permanente para ustedes, para que hagan expiación por los pecados del pueblo de Israel una vez al año». Y todo se hizo conforme a las instrucciones que el Señor le había dado a Moisés. ");
INSERT INTO spaonbv_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","El Señor también le dio a Moisés estas instrucciones ");
INSERT INTO spaonbv_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","para Aarón, para los sacerdotes y para todo el pueblo de Israel: ");
INSERT INTO spaonbv_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","4","«Cualquier israelita que degüelle un buey, un cordero o un chivo en otro lugar que no sea el santuario será culpable de derramamiento de sangre, y será expulsado de su nación. ");
INSERT INTO spaonbv_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","El propósito de esta ley es que la gente deje de matar animales fuera del santuario, para presentárselos al Señor como una ofrenda. De ahora en adelante, no podrán ellos sacrificar los animales en el campo, sino que se los llevarán al sacerdote, a la entrada del santuario, para que sea él quien los ofrezca al Señor como una ofrenda de reconciliación. ");
INSERT INTO spaonbv_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Porque de esta manera el sacerdote podrá rociar la sangre sobre el altar del Señor, a la entrada del santuario, y podrá quemar la grasa como ofrenda de olor grato al Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Así se impedirá que el pueblo ofrezca sacrificios a los espíritus malos en el campo. Esta es una norma permanente para ustedes, y deberá observarse en todas las generaciones venideras. ");
INSERT INTO spaonbv_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","9","Repito: Cualquiera, israelita o extranjero que viva entre ustedes, que ofrezca un sacrificio o un holocausto en un lugar distinto de la entrada del santuario, que es el único lugar donde debe ser ofrecido al Señor, será expulsado del pueblo. ");
INSERT INTO spaonbv_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","»Castigaré a cualquiera, israelita o extranjero, que coma sangre en cualquier forma; el que lo haga será expulsado de mi pueblo. ");
INSERT INTO spaonbv_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Porque la vida de todo ser vivo está en la sangre, y la he dado para que sea rociada sobre el altar, en expiación por sus almas. Es la sangre la que hace la expiación, porque en ella está la vida. ");
INSERT INTO spaonbv_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Esta es la razón por la que he ordenado al pueblo de Israel que ni ellos, ni los extranjeros que viven entre ellos, coman sangre. ");
INSERT INTO spaonbv_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","»Cualquier persona, israelita o extranjero que viva entre ustedes, que vaya a cazar y mate un animal o ave de los que se pueden comer, debe derramar la sangre de lo que cazó y cubrirla con tierra, ");
INSERT INTO spaonbv_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","porque la sangre es la vida. Por esto le he dicho al pueblo de Israel que no la coma, porque la vida de todo animal está en la sangre. Por lo tanto, cualquiera que coma sangre deberá ser expulsado del pueblo. ");
INSERT INTO spaonbv_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","»Y cualquier persona, nativa o extranjera, que coma carne de un animal que muere naturalmente o atacado por animales salvajes, deberá lavar su ropa y bañarse, y permanecerá impura hasta el anochecer, después de lo cual será declarada limpia. ");
INSERT INTO spaonbv_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Pero si no lava su ropa ni se baña, sufrirá las consecuencias de su pecado». ");
INSERT INTO spaonbv_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","El Señor ordenó a Moisés ");
INSERT INTO spaonbv_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","que les dijera a los israelitas: «Yo soy el Señor su Dios. ");
INSERT INTO spaonbv_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Por lo tanto, no se comporten como los paganos, como el pueblo de Egipto donde vivieron tanto tiempo, ni como los cananeos a cuya tierra los conduzco. ");
INSERT INTO spaonbv_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","5","Solamente obedecerán mis leyes y las cumplirán al pie de la letra, porque yo soy el Señor su Dios. Si las obedecen tendrán vida. Yo soy el Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","»Ninguno de ustedes podrá casarse con una pariente cercana, porque lo digo yo, el Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Una muchacha no puede casarse con su padre, ni un hijo con su madre ");
INSERT INTO spaonbv_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","ni con las viudas de su padre, ");
INSERT INTO spaonbv_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","ni con su hermana o medio hermana, por parte de padre o de madre, hayan nacido en la misma casa o fuera de ella. ");
INSERT INTO spaonbv_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","»No podrán casarse con su nieta, sea hija de alguno de sus hijos o de sus hijas, porque es pariente cercana. ");
INSERT INTO spaonbv_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","No podrán casarse con su medio hermana, hija de la esposa de su padre; ");
INSERT INTO spaonbv_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","ni con su tía, por parte de su padre, porque está directamente relacionada con su padre. ");
INSERT INTO spaonbv_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Tampoco podrán hacerlo con su tía, la hermana de su madre, porque es pariente cercana de su madre, ");
INSERT INTO spaonbv_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","ni con su tía política. ");
INSERT INTO spaonbv_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","»No se casarán con su nuera, ");
INSERT INTO spaonbv_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","ni con su cuñada, porque es la esposa de su hermano. ");
INSERT INTO spaonbv_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","No podrán casarse con una mujer y, al mismo tiempo, con su hija o nieta, porque son parientes cercanas, y eso es algo detestable. ");
INSERT INTO spaonbv_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Un hombre no se podrá casar con la hermana de su esposa ni tener relaciones sexuales con ella, mientras su esposa viva, pues hará que las dos se traten como enemigas. ");
INSERT INTO spaonbv_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","»No tendrán relaciones con una mujer durante su menstruación, ");
INSERT INTO spaonbv_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","ni con la esposa de otro, porque quedarán impuros. ");
INSERT INTO spaonbv_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","»No ofrecerán sus hijos a Moloc, quemándolos sobre su altar. Si lo hacen, profanarán el nombre de su Dios, porque yo soy el Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","»Ningún varón tendrá relaciones sexuales con otro varón, porque es un acto repugnante. ");
INSERT INTO spaonbv_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","»El hombre no debe tener relaciones sexuales con animales. Si lo hace se considerará impuro. »Una mujer no debe tener relaciones sexuales con un animal, pues es una horrible perversión. ");
INSERT INTO spaonbv_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","»No se contaminen con ninguna de estas cosas, porque estas son cosas que los paganos hacen, y debido a que las hacen los voy a expulsar de la tierra a la que ustedes entrarán. ");
INSERT INTO spaonbv_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Toda esa tierra está contaminada con este tipo de cosas. Por eso voy a castigar a los pueblos que allí viven, y los expulsaré. ");
INSERT INTO spaonbv_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Deben obedecer completamente todas mis leyes y ordenanzas, y no deben hacer ninguna de las depravaciones que ellos practican. Estas leyes tienen vigor para los que han nacido en Israel y para los extranjeros que vivan entre ustedes. ");
INSERT INTO spaonbv_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","»Todas estas depravaciones han sido practicadas habitualmente por los habitantes de la tierra a donde los llevaré, por eso la tierra está contaminada. ");
INSERT INTO spaonbv_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","No deben hacer estas cosas, o los expulsaré de la tierra, del mismo modo que arrojaré a las naciones que allí viven ahora. ");
INSERT INTO spaonbv_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","30","»Cualquiera que practique alguna de estas inmundicias será expulsado del pueblo. Obedezcan, pues, mis leyes y no practiquen las costumbres detestables de la gente de esos pueblos. No se contaminen con las prácticas inmundas de los que viven en la tierra a la que entrarán ustedes. Yo soy el Señor su Dios». ");
INSERT INTO spaonbv_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Además, el Señor le encargó a Moisés ");
INSERT INTO spaonbv_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","que le dijera al pueblo de Israel: «Sean santos, porque yo, el Señor su Dios, soy santo. »Respeten a su padre y a su madre, y obedezcan mis leyes sobre el descanso, porque yo soy el Señor su Dios. ");
INSERT INTO spaonbv_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","4","»No hagan ídolos ni los adoren, porque yo soy el Señor su Dios. ");
INSERT INTO spaonbv_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","»Cuando presenten una ofrenda de reconciliación al Señor, ofrézcanla en forma correcta para que sea aceptada. ");
INSERT INTO spaonbv_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Cómansela el mismo día en que la ofrezcan o, a más tardar, al día siguiente. Lo que quede para el tercer día debe ser quemado. ");
INSERT INTO spaonbv_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Cualquier porción que sea comida al tercer día no será tenida en cuenta como sacrificio, y no la aceptaré. ");
INSERT INTO spaonbv_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","El que la coma al tercer día, será culpable, por cuanto ha profanado la santidad del Señor, y será expulsado de su pueblo. ");
INSERT INTO spaonbv_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","»Cuando cosechen sus campos, no arranquen las espigas que están a la orilla del campo, ni recojan las espigas que hayan caído al suelo. ");
INSERT INTO spaonbv_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Lo mismo harán con sus viñedos. No recogerán las uvas que queden en la mata después de la cosecha, ni las que hayan caído al suelo. Déjenlas para los pobres y para los extranjeros, porque yo soy el Señor su Dios. ");
INSERT INTO spaonbv_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","»No robarán, ni mentirán ni engañarán. ");
INSERT INTO spaonbv_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","No deben jurar en falso, difamando el nombre de Dios, porque yo soy el Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","»No robarán ni oprimirán a nadie. Pagarán con prontitud el salario a sus obreros. Si les deben algo a ellos, no esperen a la mañana siguiente para pagarles. ");
INSERT INTO spaonbv_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","»No maldecirán al sordo ni pondrán tropiezo en el camino al hombre ciego. Teman a Dios; yo soy el Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","»Los jueces siempre deben dictar sentencia con justicia, sin tener en cuenta si la persona es pobre o rica; deben ser siempre justos. ");
INSERT INTO spaonbv_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","»No acusen falsamente de algún delito a su prójimo, porque yo soy el Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","»No guarden rencor contra su hermano. »Corrijan a su prójimo, cuando tengan que hacerlo, y no participen de su pecado. ");
INSERT INTO spaonbv_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","»No busquen la venganza. No conserven rencor en el corazón, sino amen a su prójimo como a ustedes mismos, porque yo soy el Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","»Obedezcan mis leyes: No crucen su ganado con animales de otra especie; no siembren en su campo dos clases de semillas; no usen ropa mezclada de lana y lino. ");
INSERT INTO spaonbv_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","»Si un hombre seduce a una esclava que está comprometida para casarse, ambos serán juzgados, pero no se condenarán a muerte, porque ella no es libre. ");
INSERT INTO spaonbv_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","El hombre que lo haya hecho presentará un cordero al Señor, como ofrenda por su culpa. El cordero deberá llevarlo a la entrada del santuario. ");
INSERT INTO spaonbv_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","El sacerdote usará el cordero para hacer expiación por el pecado del hombre, y este será perdonado. ");
INSERT INTO spaonbv_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","»Cuando hayan entrado en la tierra y hayan plantado todo tipo de árboles frutales, no coman lo que produzcan los tres primeros años, porque están ritualmente impuros. ");
INSERT INTO spaonbv_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","La cosecha del cuarto año será dedicada por completo al Señor, como una ofrenda de alabanza. ");
INSERT INTO spaonbv_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Pero la cosecha del quinto año sí será para ustedes. Haré que la cosecha sea abundante. Yo soy el Señor su Dios. ");
INSERT INTO spaonbv_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","»No coman carne con sangre. »No practiquen la adivinación ni la hechicería. ");
INSERT INTO spaonbv_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","»No deben recortarse el pelo ni la punta de la barba, pues eso lo hacen los paganos. ");
INSERT INTO spaonbv_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","»No se harán cortes ni tatuajes en el cuerpo, para venerar a los muertos. Yo soy el Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","»No violarán la pureza de su hija haciéndola prostituta, para que la tierra no se llene de maldad. ");
INSERT INTO spaonbv_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","»Obedezcan mis leyes acerca del descanso, y tengan reverencia por mi santuario, porque yo soy el Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","»No se contaminen consultando adivinos o hechiceros, porque yo soy el Señor su Dios. ");
INSERT INTO spaonbv_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","»Demostrarán verdadero respeto y honrarán a los ancianos por temor a Dios. Yo soy el Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","»No opriman a los extranjeros que vivan en la tierra de ustedes; no les hagan mal alguno. ");
INSERT INTO spaonbv_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Deben tratarlos como a uno de ustedes. Ámenlos como a ustedes mismos, porque recuerden que ustedes también fueron extranjeros en Egipto. Yo soy el Señor su Dios. ");
INSERT INTO spaonbv_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","36","»Sean imparciales en los juicios. Usen medidas exactas de longitud, de peso y de volumen, y den la medida completa, porque yo soy el Señor su Dios, que los saqué de Egipto. ");
INSERT INTO spaonbv_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","»Obedezcan por completo todos mis mandamientos y ordenanzas, porque yo soy el Señor». ");
INSERT INTO spaonbv_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","El Señor le dio a Moisés estas otras instrucciones ");
INSERT INTO spaonbv_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","para el pueblo de Israel: «Cualquiera que viva en medio de ustedes, sea israelita o extranjero, que presente a su hijo en sacrificio al dios Moloc será condenado a muerte. Todo el pueblo lo matará a pedradas. ");
INSERT INTO spaonbv_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Yo mismo me volveré contra aquel hombre y lo eliminaré del pueblo, por haber dado su hijo a Moloc, pues con ello habrá hecho que mi santuario sea indigno de mi presencia, y habrá insultado mi santo nombre. ");
INSERT INTO spaonbv_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Y si el pueblo no se da por enterado de lo que el hombre ha hecho, y se niegan a darle muerte, ");
INSERT INTO spaonbv_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","yo mismo me pondré en contra de aquel hombre y de su familia, y los eliminaré de mi pueblo, junto con todos los demás que se vuelvan a dioses ajenos. ");
INSERT INTO spaonbv_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","»Me pondré en contra de cualquier persona que consulte a adivinos y a hechiceros, en vez de consultarme a mí, y los eliminaré de mi pueblo. ");
INSERT INTO spaonbv_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","»Santifíquense y sean santos, porque yo soy el Señor su Dios. ");
INSERT INTO spaonbv_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","»Obedezcan todos mis mandamientos, porque yo soy el Señor que los santifica. ");
INSERT INTO spaonbv_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","»El que maldiga a su padre o a su madre deberá morir, pues ha maldecido a su propia sangre. ");
INSERT INTO spaonbv_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","»Si un hombre comete adulterio con la esposa de otro hombre, el hombre y la mujer deben morir. ");
INSERT INTO spaonbv_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","»Si un hombre duerme con la esposa de su padre, ha deshonrado a su padre. Y el hombre y la mujer deberán morir, pues son culpables. ");
INSERT INTO spaonbv_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","»Y si un hombre tiene relaciones sexuales con su nuera, ambos serán condenados a muerte. Lo merecen por haberse contaminado mutuamente. ");
INSERT INTO spaonbv_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","»El hombre que tenga relaciones sexuales con otro hombre comete un horrible pecado. Los dos hombres serán condenados a muerte, y sólo ellos serán culpables de su muerte. ");
INSERT INTO spaonbv_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","»Si un hombre tiene relaciones sexuales con una mujer y con la madre de esta, comete un grave delito. Los tres serán quemados vivos para erradicar la maldad de entre ustedes. ");
INSERT INTO spaonbv_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","»Si un hombre tiene relaciones sexuales con un animal, será condenado a muerte, y también se matará al animal. ");
INSERT INTO spaonbv_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Si una mujer tiene relaciones sexuales con un animal, será condenada a muerte, y también se matará al animal. ");
INSERT INTO spaonbv_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","»Si un hombre tiene relaciones sexuales con su hermana, sea la hija de su padre o de su madre, comete un pecado, y ambos serán ejecutados en público. Por haberlo hecho, se hacen culpables de su pecado. ");
INSERT INTO spaonbv_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","»Si un hombre tiene relaciones sexuales con una mujer durante su período menstrual, ambos serán expulsados de su pueblo. ");
INSERT INTO spaonbv_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","»Están prohibidas las relaciones sexuales entre un hombre y su tía soltera, ya sea hermana de su padre o de su madre, porque son parientes cercanos; los dos serán responsables de su pecado. ");
INSERT INTO spaonbv_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Si un hombre tiene relaciones sexuales con la esposa de su tío, ha avergonzado a su tío. Tanto el hombre como la mujer serán considerados culpables, y morirán sin tener hijos. ");
INSERT INTO spaonbv_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","»Si un hombre tiene relaciones sexuales con la esposa de su hermano, comete un acto detestable, y deshonra a su hermano. Tanto el hombre como la mujer serán considerados culpables, y morirán sin tener hijos. ");
INSERT INTO spaonbv_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","»Guarden, pues, todas mis leyes y ordenanzas, para que no los arroje de la nueva tierra. ");
INSERT INTO spaonbv_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Apártense de las costumbres de las naciones que he echado delante de ustedes, porque ellas hacen todas estas cosas que les he prohibido a ustedes, y esa es la razón por la que las aborrecí. ");
INSERT INTO spaonbv_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Yo he prometido darles a ustedes la tierra de ellos. Se la daré para que la posean. Es una tierra de la que fluye leche y miel. »Yo soy el Señor, que hago distinción entre ustedes y las otras naciones. ");
INSERT INTO spaonbv_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Por tanto, harán distinción entre las aves y animales impuros que no pueden comer y los que sí pueden comer. No se contaminen ustedes mismos ni se hagan odiosos delante de mí, comiendo animales o aves que yo les haya prohibido, aunque la tierra esté llena de ellos. ");
INSERT INTO spaonbv_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Sean santos delante de mí, porque yo el Señor soy santo, y los he apartado de las otras naciones para que sean míos. ");
INSERT INTO spaonbv_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","»Cualquier adivino o hechicero, hombre o mujer, será apedreado hasta morir, y será responsable de su castigo». ");
INSERT INTO spaonbv_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","El Señor ordenó a Moisés que les diera a los sacerdotes, descendientes de Aarón, estas instrucciones: «No deben tocar ningún muerto, pues eso los hará impuros. ");
INSERT INTO spaonbv_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","3","Tan solo se les permite hacerlo en caso de que el muerto sea un pariente cercano, como su madre, su padre, su hijo, su hija, su hermano, o su hermana soltera por la que tenga especial responsabilidad, por cuanto ella no tiene marido. ");
INSERT INTO spaonbv_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","El sacerdote es jefe de su pueblo, así que es diferente de cualquier otro hombre del pueblo. Por eso, no debe contaminarse con lo que es impuro. ");
INSERT INTO spaonbv_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","»Los sacerdotes no se recortarán el pelo ni la punta de la barba; ni se harán cortes en la carne. ");
INSERT INTO spaonbv_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Serán santos delante de su Dios, y no deshonrarán ni profanarán su nombre, de otro modo serán indignos de presentar las ofrendas quemadas delante del Señor su Dios. ");
INSERT INTO spaonbv_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","»El sacerdote no se casará con una prostituta, ni con una mujer de otra tribu, ni con una mujer divorciada, porque es un hombre consagrado a Dios. ");
INSERT INTO spaonbv_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","El sacerdote ha sido apartado para ofrecer los sacrificios a su Dios; es santo, porque yo, el Señor que lo santifico, soy santo. ");
INSERT INTO spaonbv_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","»La hija de un sacerdote que se haga prostituta y deshonre así tanto la santidad de su padre como la suya propia, será quemada viva. ");
INSERT INTO spaonbv_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","»El sumo sacerdote ha recibido la unción especial y usa las vestiduras especiales, y por eso no debe descubrirse, ni rasgar sus vestiduras, ");
INSERT INTO spaonbv_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","ni acercarse a un cadáver, aun cuando sea su padre o su madre. ");
INSERT INTO spaonbv_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","»No dejará el santuario cuando esté oficiando, ni tratará mi santuario como una casa ordinaria, porque está consagrado con la unción de Dios. Yo soy el Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","»Debe casarse con una virgen. ");
INSERT INTO spaonbv_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","15","No puede casarse con una viuda, ni con una divorciada, ni con una prostituta. Debe casarse con una virgen de su propia tribu, porque él no puede ser padre de hijos de sangre mixta, mitad sacerdotal y mitad de persona común. Yo soy el Señor que lo santifica». ");
INSERT INTO spaonbv_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","17","El Señor le ordenó a Moisés que le dijera a Aarón: «A través de todas las generaciones, cualquier descendiente tuyo que tenga algún defecto físico no podrá ofrecer sacrificio delante de Dios. ");
INSERT INTO spaonbv_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Por ejemplo, si un hombre es ciego o cojo, o tiene fracturada la nariz, o tiene algún dedo de más en las manos o en los pies, ");
INSERT INTO spaonbv_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","o tiene fracturado un pie o una mano, ");
INSERT INTO spaonbv_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","o es jorobado, o enano, o tiene un defecto en el ojo, o tiene sarna o tiña, o tiene los testículos dañados, ");
INSERT INTO spaonbv_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","aun cuando sea descendiente de Aarón, no podrá ofrecer holocaustos al Señor, pues tiene un defecto físico. ");
INSERT INTO spaonbv_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Sin embargo, comerá de la comida de los sacerdotes, de los sacrificios ofrecidos a Dios, de las ofrendas santas y de las más santas. ");
INSERT INTO spaonbv_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Pero no pasará tras la cortina ni se acercará al altar, debido a su defecto físico. Si lo hace, contamina mi santuario. Yo soy el Señor que los he consagrado». ");
INSERT INTO spaonbv_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Moisés dio, pues, estas instrucciones a Aarón y a sus hijos y a todo el pueblo de Israel. ");
INSERT INTO spaonbv_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","El Señor le ordenó a Moisés ");
INSERT INTO spaonbv_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","que les dijera a Aarón y a sus hijos: «Sean muy cuidadosos en el trato que le dan a las ofrendas que el pueblo me consagra, para que no deshonren mi santo nombre; porque yo soy el Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","»De ahora en adelante, y para siempre, si el sacerdote que esté ceremonialmente impuro sacrifica los animales traídos por el pueblo, o toca las ofrendas dedicadas a mí, será destituido del sacerdocio. Yo soy el Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","»Ningún sacerdote que esté leproso, o tenga una llaga que supura podrá comer las santas ofrendas hasta que se haya curado. Cualquier sacerdote que toque un cadáver, o esté contaminado por una emisión seminal, ");
INSERT INTO spaonbv_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","o toque algún reptil o alguna otra cosa prohibida, o toque a cualquiera que esté ritualmente impuro, por cualquier razón, ");
INSERT INTO spaonbv_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","quedará impuro hasta el anochecer, y no comerá del santo sacrificio hasta después que se haya bañado. ");
INSERT INTO spaonbv_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Después de la puesta del sol quedará limpio nuevamente y podrá comer de las cosas sagradas, porque son la fuente de su vida. ");
INSERT INTO spaonbv_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","No puede comer animales que sean encontrados muertos o que hayan sido destrozados por animales salvajes, porque esto lo contaminaría. Yo soy el Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","»Todos los sacerdotes deben obedecer estas instrucciones, para que no sean culpables, y mueran por violarlas. Yo soy el Señor quien los santifica. ");
INSERT INTO spaonbv_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","»Nadie que no pertenezca a la familia de un sacerdote podrá comer de las ofrendas sagradas. Por eso, ni los huéspedes o jornaleros de un sacerdote podrán comer de las ofrendas sagradas. ");
INSERT INTO spaonbv_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Sin embargo, hay una excepción: Si el sacerdote compra un esclavo con su dinero, ese esclavo puede comer de lo sacrificado, y si el esclavo tiene hijos en la casa del sacerdote, ellos pueden comer. ");
INSERT INTO spaonbv_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Si la hija de un sacerdote se casa fuera de la tribu, no puede participar de la ofrenda sagrada. ");
INSERT INTO spaonbv_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Pero si queda viuda, o se divorcia y no tiene hijos que la sostengan, y regresa a casa de su padre, puede comer nuevamente de los alimentos de su padre. Fuera de esto, nadie que no pertenezca a la familia sacerdotal puede comer de las ofrendas sagradas. ");
INSERT INTO spaonbv_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","»Si alguien come de los sacrificios sagrados sin darse cuenta, devolverá al sacerdote la cantidad que haya usado, más un veinte por ciento; ");
INSERT INTO spaonbv_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","porque el sacrificio santo traído por el pueblo de Israel no debe ser contaminado por personas que lo coman sin estar autorizadas para ello, porque estos sacrificios han sido consagrados al Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Cualquiera que viole esta ley es culpable y está en peligro, porque ha comido de las ofrendas sagradas. Yo soy el Señor, quien santifica las ofrendas». ");
INSERT INTO spaonbv_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","18","El Señor le ordenó a Moisés que les dijera a Aarón y a sus hijos, y a todos los israelitas en general: «Si un israelita o un extranjero que viva en medio de ustedes ofrece un holocausto al Señor, sea para cumplir una promesa o sea una ofrenda voluntaria espontánea, ");
INSERT INTO spaonbv_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","sólo será aceptable delante del Señor si es un animal macho sin defecto; deberá ser un becerro, un carnero o un macho cabrío. ");
INSERT INTO spaonbv_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Ningún animal que tenga defecto será presentado, porque no será aceptado por el Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","»Si alguien ofrece un sacrificio de reconciliación al Señor, ya sea ganado vacuno u ovino, sea para cumplir un voto o como ofrenda voluntaria, el animal que se vaya a sacrificar debe ser sin defecto, o no será aceptado por el Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","No se debe ofrecer al Señor un animal que sea ciego o que esté perniquebrado o mutilado, o que tenga llagas, sarna o cualquier otra enfermedad de la piel. No es adecuado para ofrecerlo sobre el altar del Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Si el becerro o el cordero que se va a presentar al Señor tiene alguna deformidad, puede ofrecerse como ofrenda voluntaria, pero no en pago de un voto. ");
INSERT INTO spaonbv_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","»No se podrá ofrecer al Señor, bajo ninguna circunstancia, un animal que tenga los testículos lastimados, dañados, cortados o arrancados. ");
INSERT INTO spaonbv_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Esta restricción se aplica también a los sacrificios hechos por los extranjeros que habiten en medio de ustedes. Así que no aceptarán ningún animal que tenga algún defecto de los ya mencionados». ");
INSERT INTO spaonbv_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","27","Y el Señor le dijo a Moisés: «Cuando nazca un becerro, un cordero o un cabrito, será dejado con su madre siete días, pero al octavo día es aceptable como holocausto al Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","»No degollarán el mismo día una vaca o una oveja con su cría. ");
INSERT INTO spaonbv_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","30","»Cuando ofrezcan al Señor un sacrificio de acción de gracias, deberán hacerlo en la forma correcta, comiéndose el animal sacrificado el mismo día que fue degollado. No dejarán parte de él para el día siguiente. Yo soy el Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","»Deberán obedecer todos mis mandamientos, porque yo soy el Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","33","»No me tratarán como si fuera algo común y ordinario. Al contrario, reconozcan que yo soy el Dios santo que habito entre ustedes. Yo soy el Señor que los santifico a ustedes. Fui yo quien los rescaté de Egipto para que fueran mi pueblo especial. Yo soy el Señor». ");
INSERT INTO spaonbv_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","El Señor le ordenó a Moisés ");
INSERT INTO spaonbv_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","que les dijera a los israelitas: «Las siguientes son las fiestas solemnes que yo he establecido, las cuales deberán celebrar en mi honor de una manera muy especial. En tales ocasiones todos deberán reunirse para adorarme. Yo, el Señor, las establecí. ");
INSERT INTO spaonbv_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","»Seis días trabajarán, pero descansarán el día séptimo. Ese día es un día muy especial. Por eso, no harán ningún tipo de trabajo, sino que lo dedicarán para adorarme. Donde quiera que ustedes vivan, ese día será dedicado a mí, pues yo soy el Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","»Las siguientes son las festividades santas que deberán observar cada año: ");
INSERT INTO spaonbv_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","»La Pascua del Señor: Esta fiesta comenzará el día catorce del mes primero, al anochecer. ");
INSERT INTO spaonbv_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","»La fiesta de los Panes sin levadura: Se celebrará durante siete días, a partir del día siguiente de la Pascua. ");
INSERT INTO spaonbv_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","El primer día de esta festividad el pueblo se reunirá para adorar, y cesará todo trabajo ordinario. ");
INSERT INTO spaonbv_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Lo mismo hará el séptimo día de la festividad. Y durante los siete días ofrecerán holocaustos al Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","11","»La fiesta de las Primicias: Cuando lleguen a la tierra que yo les daré, y hagan su primera cosecha, lleven las primeras gavillas de la cosecha al sacerdote, al día siguiente del día de descanso. Él la mecerá para ofrecérsela al Señor, quien la aceptará como ofrenda de ustedes. ");
INSERT INTO spaonbv_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","El mismo día sacrificarán, en holocausto al Señor, un cordero de un año, sin defecto. ");
INSERT INTO spaonbv_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Junto con el cordero, ofrecerán cuatro kilos de harina de la mejor calidad mezclada con aceite de oliva, para ser ofrecida como ofrenda quemada al Señor. Será una ofrenda de olor grato al Señor. Además, presentarán una ofrenda de un litro de vino. ");
INSERT INTO spaonbv_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Mientras no hayan presentado estas ofrendas, no comerán pan, ni grano tostado, ni espiga fresca de esta cosecha. Esta será una ley permanente para la nación, donde quiera que vivan. ");
INSERT INTO spaonbv_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","16","»La fiesta de las Semanas: Cincuenta días después traerán al Señor una ofrenda de grano nuevo de su última cosecha. ");
INSERT INTO spaonbv_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Traerán de sus casas dos panes para ser presentados como ofrenda mecida delante del Señor. Este pan lo prepararán con cuatro kilos de harina de la mejor calidad, y lo cocerán con levadura. Es una ofrenda para el Señor, ofrecida con las primicias de su última cosecha. ");
INSERT INTO spaonbv_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Además del pan y del vino, ofrecerán siete corderos de un año, sin defectos, un becerro y dos carneros. Estos animales serán ofrecidos en holocausto al Señor, es una ofrenda que se quema totalmente como ofrenda de olor grato al Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Después sacrificarán un macho cabrío como ofrenda por los pecados, y dos corderos de un año como ofrenda de reconciliación. ");
INSERT INTO spaonbv_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","»El sacerdote traerá estas ofrendas a la presencia del Señor, juntamente con los panes que representan las primicias de la última cosecha, y las presentará como ofrendas mecidas delante del Señor. Estarán consagradas al Señor, y serán entregadas a los sacerdotes para que las coman. ");
INSERT INTO spaonbv_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Este día será convocada una asamblea sagrada de todo el pueblo. No harán ningún trabajo en ese día. Esta es una norma que será observada de generación en generación. ");
INSERT INTO spaonbv_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","»Cuando cosechen el producto de la tierra, no lo harán hasta el último rincón del campo, ni recogerán el grano caído, sino que lo dejarán para los pobres y para los extranjeros que vivan en medio de ustedes y que no tienen tierra de su propiedad. Yo soy el Señor su Dios. ");
INSERT INTO spaonbv_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","24","»La fiesta de las Trompetas: Esta fiesta se celebrará el primer día del séptimo mes. Es una fiesta en honor al Señor, y todo el pueblo se reunirá para adorar solemnemente al Señor. Es una fecha memorable, y debe ser anunciada por medio del sonido de trompetas. ");
INSERT INTO spaonbv_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Ese día no harán ningún trabajo, y ofrecerán un sacrificio al Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","27","»El día del Perdón: Se celebrará nueve días después, es decir, el día diez del mes séptimo. Todo el pueblo debe presentarse delante del Señor, para ayunar y presentar sacrificios por fuego en honor al Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","No harán en aquel día ningún trabajo, porque es el día del Perdón, en el cual se pide al Señor perdón por los pecados del pueblo. ");
INSERT INTO spaonbv_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Cualquiera que no dedique el día al ayuno será eliminado de su pueblo. ");
INSERT INTO spaonbv_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","31","Al que realice algún trabajo en ese día yo lo destruiré. Esta es una ley que regirá en Israel de generación en generación. ");
INSERT INTO spaonbv_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Porque este es un día de descanso solemne, y en él ustedes se humillarán y expresarán completo arrepentimiento; esto lo comenzarán en la tarde del día noveno y continuará todo el día hasta la tarde del día siguiente. ");
INSERT INTO spaonbv_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","34","»La fiesta de las Enramadas: Cinco días después, esto es, el día quince del mes séptimo, se celebrará la fiesta de las Enramadas durante siete días, delante del Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","En el primer día habrá una asamblea sagrada de todo el pueblo; no harán en él ningún trabajo. ");
INSERT INTO spaonbv_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","En cada uno de los siete días de la fiesta presentarán un sacrificio u ofrenda quemada delante del Señor. El octavo día habrá una nueva asamblea sagrada de todo el pueblo, ocasión en la que se presentará otra ofrenda quemada al Señor. Es una celebración en la que deben estar alegres, y no realizarán en ella ningún trabajo. ");
INSERT INTO spaonbv_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","»Estas son, pues, las fiestas regulares del año, asambleas sagradas para todo el pueblo, en que deberán presentar ofrendas quemadas delante del Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Estas fiestas anuales se celebrarán además de los días sagrados de descanso de cada semana. Los sacrificios que se hagan durante las fiestas se presentarán además de las ofrendas regulares y del normal cumplimiento de sus votos. ");
INSERT INTO spaonbv_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","»A partir del día quince del mes séptimo, que es el final de la cosecha, celebrarán una fiesta de siete días delante del Señor. Recuerden que el primero y el último día de la fiesta son días de descanso solemne. ");
INSERT INTO spaonbv_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","En el primer día tomarán ramas de árboles frutales cargadas con frutos, ramas de palmera y de árboles frondosos, como los sauces que crecen junto a los arroyos, y construirán enramadas con ellos; y se regocijarán y alegrarán delante del Señor su Dios durante siete días. ");
INSERT INTO spaonbv_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","La celebración de esta fiesta de siete días será una obligación que regirá para siempre. ");
INSERT INTO spaonbv_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Durante esos siete días todos los israelitas vivirán en las enramadas. ");
INSERT INTO spaonbv_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","El propósito de esta fiesta es recordar al pueblo de Israel, año tras año, que yo los rescaté de Egipto, y que hice que vivieran en enramadas. Yo soy el Señor su Dios». ");
INSERT INTO spaonbv_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Moisés, entonces, instruyó a los israelitas en cuanto a las fiestas que habían sido establecidas por el Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","El Señor le dijo a Moisés: ");
INSERT INTO spaonbv_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","«Ordena al pueblo de Israel que traiga aceite puro de oliva, para mantener encendidas las lámparas, de modo que el santuario esté siempre iluminado. ");
INSERT INTO spaonbv_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","4","Aarón preparará las lámparas que están en el santuario, fuera de la cortina del testimonio. Cada mañana y cada tarde Aarón pondrá aceite nuevo en las lámparas que habrá limpiado. La llama arderá continuamente delante del Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","8","»Cada día de descanso, el sumo sacerdote colocará doce panes, en dos hileras, sobre la mesa de oro que está delante del Señor. Cada uno de estos panes será preparado con harina de la mejor calidad, y deberá pesar unos cuatro kilos. Sobre cada hilera pondrá incienso puro. Esto será una ofrenda recordatoria, ofrecida por fuego al Señor. Con ella se recordará el pacto eterno que el Señor hizo con el pueblo de Israel. ");
INSERT INTO spaonbv_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","El pan será comido por Aarón y sus hijos, en un lugar señalado para esto, pues las ofrendas que se ofrecen al Señor por fuego son muy sagradas. Esta es una ley que debe cumplirse siempre». ");
INSERT INTO spaonbv_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Un joven, de madre israelita y padre egipcio, riñó con uno de los hombres de Israel en el campo. ");
INSERT INTO spaonbv_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Durante la pelea, el hijo del egipcio maldijo el nombre de Dios. Entonces fue llevado ante Moisés para ser juzgado. El nombre de la madre era Selomit, hija de Dibrí, de la tribu de Dan. ");
INSERT INTO spaonbv_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Mientras se recibía instrucciones del Señor acerca de lo que debía hacerse, el joven fue puesto en la cárcel. ");
INSERT INTO spaonbv_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","14","Entonces el Señor le dijo a Moisés: «Saca fuera del campamento al que me ofendió, y diles a todos los que lo oyeron que pongan las manos sobre su cabeza; luego toda la comunidad de Israel lo apedreará hasta darle muerte. ");
INSERT INTO spaonbv_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","16","Y dile al pueblo de Israel que cualquiera que maldiga a Dios sufrirá el mismo castigo. Sí, todo el que pronuncie el nombre del Señor al maldecir a su prójimo debe ser condenado a muerte. Esta ley se aplicará tanto a israelitas como a extranjeros. El que pronuncie el nombre del Señor al maldecir, será muerto a pedradas. ");
INSERT INTO spaonbv_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","»Además, todos los asesinos deberán ser ejecutados. ");
INSERT INTO spaonbv_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","El que mate un animal ajeno, lo repondrá. ");
INSERT INTO spaonbv_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","El castigo por haberle causado daño al prójimo será el mismo que el daño causado: ");
INSERT INTO spaonbv_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","fractura por fractura, ojo por ojo, diente por diente. El que cause daño a otro recibirá el mismo daño que haya hecho. ");
INSERT INTO spaonbv_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","»Repito: Cualquiera que mate un animal debe reponerlo; cualquiera que mate a un hombre debe morir. ");
INSERT INTO spaonbv_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","La misma ley rige para el extranjero y para el israelita. Yo soy el Señor su Dios». ");
INSERT INTO spaonbv_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Entonces llevaron al joven fuera del campamento y lo apedrearon hasta que murió, tal como el Señor le había ordenado a Moisés. ");
INSERT INTO spaonbv_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Mientras Moisés estaba en el monte Sinaí, el Señor le dio estas instrucciones para el pueblo de Israel: ");
INSERT INTO spaonbv_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","«Cuando hayan entrado en la tierra que les voy a dar, dejarán que la tierra descanse en el séptimo año, en honor al Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Durante seis años podrán sembrar los campos, podar las viñas, y recoger lo que ellas produzcan, ");
INSERT INTO spaonbv_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","pero el séptimo año dejarán que la tierra descanse, en honor al Señor. No sembrarán los campos ni podarán los viñedos en todo el año. ");
INSERT INTO spaonbv_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Tampoco cosecharán los brotes de la siembra anterior, ni las uvas de los viñedos no podados. Es un año de descanso para la tierra. ");
INSERT INTO spaonbv_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","7","Todo lo que se produzca naturalmente ese año servirá de alimento para ustedes, para sus siervos, para sus esclavos y para los extranjeros que vivan entre ustedes. Allí también pastarán el ganado y los animales salvajes. ");
INSERT INTO spaonbv_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","»Cada cincuenta años, ");
INSERT INTO spaonbv_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","en el día de la expiación, esto es, el día diez del mes séptimo, harán resonar las trompetas por toda la tierra. ");
INSERT INTO spaonbv_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Porque el año cincuenta será un año santo, y se proclamará libertad en la tierra a todos los deudores esclavizados, perdonarán todas las deudas públicas y privadas. Será un año en que las propiedades de la familia vendidas a otros serán devueltas a sus propietarios originales o a sus herederos. ");
INSERT INTO spaonbv_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","»Será un año de gran felicidad. No sembrarán, no cosecharán granos, ni uvas, ");
INSERT INTO spaonbv_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","porque es el año santo de jubileo para ustedes. Ese año se alimentarán de lo que la tierra produzca espontáneamente. ");
INSERT INTO spaonbv_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Durante el año del jubileo cada uno regresará a la posesión original de su familia. Si una propiedad ha sido vendida, le será devuelta a su antiguo dueño. ");
INSERT INTO spaonbv_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","16","Por esta razón, si se vende la tierra durante los cuarenta y nueve años precedentes, se establecerá un precio justo, teniendo en cuenta los años que faltan para el jubileo. Si el jubileo está a muchos años de distancia, el precio será alto. Si faltan pocos años, el precio será bajo. Lo que realmente están haciendo es vender el número de cosechas que habrá hasta el próximo jubileo, cuando la tierra les sea devuelta por el que la compró. ");
INSERT INTO spaonbv_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","18","»Teman a Dios y no le hagan daño a su prójimo, porque yo soy el Señor. Si quieren vivir seguros en la tierra, obedezcan mis leyes. ");
INSERT INTO spaonbv_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Si me obedecen, la tierra les dará buenas cosechas, y podrán comer hasta saciarse. ");
INSERT INTO spaonbv_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","»Pero preguntarán: ¿Qué comeremos el séptimo año, puesto que no se nos permite sembrar, ni cosechar? ");
INSERT INTO spaonbv_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","22","La respuesta es: Los bendeciré con cosechas extraordinarias el sexto año, lo que les permitirá vivir hasta que obtengan la cosecha del octavo año. ");
INSERT INTO spaonbv_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","»Recuerden, la tierra es mía, de modo que no pueden venderla definitivamente. Ustedes son solamente arrendatarios y tendrán la tierra a su cargo. ");
INSERT INTO spaonbv_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","En todo contrato de venta debe haber una cláusula que diga que la tierra puede ser recuperada en cualquier tiempo por el vendedor. ");
INSERT INTO spaonbv_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","»Si alguno se empobrece y vende parte de su tierra, sus parientes más cercanos pueden recuperarla. ");
INSERT INTO spaonbv_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Si no hay quien pueda recuperarla, y él mismo logra ganar suficiente dinero, ");
INSERT INTO spaonbv_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","entonces puede comprarla a un precio proporcional al número de cosechas que falten para el jubileo; y el que posee la tierra deberá aceptar el dinero, y devolvérsela a su dueño original. ");
INSERT INTO spaonbv_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Pero, si este no puede recuperarla antes, pertenecerá al que se la compró hasta el año del jubileo, y ese año la devolverá. ");
INSERT INTO spaonbv_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","»Si un hombre vende una casa en la ciudad, tiene un año para recuperarla, con plenos derechos de recuperación durante ese tiempo. ");
INSERT INTO spaonbv_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Pero la casa no recuperada dentro de ese año, pertenecerá definitivamente al nuevo propietario, y no será devuelta a su dueño original en el año del jubileo. ");
INSERT INTO spaonbv_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Pero las casas de los pueblos —que se distinguen de las ciudades en que no tienen murallas alrededor— son como la tierra; y se pueden recuperar en cualquier tiempo, y siempre serán devueltas a sus propietarios originales en el año del jubileo. ");
INSERT INTO spaonbv_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","»Hay una sola excepción: Las casas de los levitas, aun cuando estén en ciudades amuralladas, podrán ser recuperadas en cualquier tiempo, ");
INSERT INTO spaonbv_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","y serán devueltas a sus propietarios originales en el año del jubileo. Esto se debe a que los levitas no recibirán tierra agrícola como las otras tribus; solamente recibirán casas en las ciudades y el campo que las rodea. Esa es su única heredad familiar. ");
INSERT INTO spaonbv_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","No se permite que los levitas vendan los campos que están alrededor de sus ciudades, porque estas son posesión permanente de ellos, y no pueden pertenecer a otras personas. ");
INSERT INTO spaonbv_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","»Si su hermano empobrece, ustedes tienen la obligación de ayudarlo, tal como harían con un extranjero; de esa forma él podrá seguir viviendo entre ustedes. ");
INSERT INTO spaonbv_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Teman a Dios y dejen que su hermano viva con ustedes. No le cobren interés por el dinero que le presten. ");
INSERT INTO spaonbv_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Recuerden: No le cobren interés. Denle al costo cuanto necesita. No traten de hacer ganancia a costa de su pobreza. ");
INSERT INTO spaonbv_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Porque yo, el Señor su Dios, los saqué de Egipto, para darles la tierra de Canaán, y para ser su Dios. ");
INSERT INTO spaonbv_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","»Si un israelita empobrece y se vende como esclavo, no deben tratarlo como a un esclavo común, ");
INSERT INTO spaonbv_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","sino como a un servidor a sueldo o como un huésped. Él les servirá solamente hasta el año del jubileo. ");
INSERT INTO spaonbv_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Entonces, ese año quedará libre junto con sus hijos, y podrá regresar a su familia y a sus posesiones. ");
INSERT INTO spaonbv_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Yo los saqué de Egipto, y ustedes son mis siervos. Por lo tanto, no podrán venderse como esclavos comunes ");
INSERT INTO spaonbv_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","ni ser tratados duramente. Teman a su Dios. ");
INSERT INTO spaonbv_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","»Sin embargo, pueden comprar esclavos de las naciones que viven a su alrededor, ");
INSERT INTO spaonbv_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","y pueden comprar los hijos de los extranjeros que vivan en medio de su pueblo, aun cuando hayan nacido en su tierra. ");
INSERT INTO spaonbv_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Ellos serán esclavos permanentes y serán heredados por sus hijos. Pero sus hermanos, miembros del pueblo de Israel, no serán tratados así. ");
INSERT INTO spaonbv_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","»Si un extranjero que vive en Israel se enriquece, y un israelita empobrece y se vende como esclavo al extranjero, o a la familia del extranjero, ");
INSERT INTO spaonbv_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","podrá ser redimido por uno de sus hermanos, ");
INSERT INTO spaonbv_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","por su tío, su sobrino, o cualquier pariente cercano. También puede redimirse a sí mismo, si reúne el dinero. ");
INSERT INTO spaonbv_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","El precio de su libertad se acordará en proporción al número de años que falten para el jubileo, es decir, lo que costaría contratar a un sirviente por ese número de años. ");
INSERT INTO spaonbv_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Si aún faltan muchos años para el jubileo, pagará la cantidad que recibió cuando se vendió. ");
INSERT INTO spaonbv_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Si los años han pasado y solamente quedan pocos para el jubileo, pagará solamente una pequeña parte de la cantidad que recibió cuando se vendió. ");
INSERT INTO spaonbv_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Si se vende a un extranjero, el extranjero deberá tratarlo como a un sirviente a sueldo y no como a un esclavo o a una propiedad suya. ");
INSERT INTO spaonbv_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","»Si al llegar el año del jubileo, el israelita que tuvo que venderse como esclavo no fue rescatado en esta forma, entonces él y sus hijos quedarán libres. ");
INSERT INTO spaonbv_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Pues ustedes los israelitas son mis siervos, yo los rescaté de la esclavitud de Egipto. Yo soy el Señor su Dios. ");
INSERT INTO spaonbv_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","»No tendrán ídolos. No adorarán imágenes talladas, ni estatuas ni piedras esculpidas, porque yo soy el Señor su Dios. ");
INSERT INTO spaonbv_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","»Obedecerán mis leyes acerca del día de descanso y tendrán mucha reverencia hacia mi santuario; porque yo soy el Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","»Si obedecen todos mis mandamientos, ");
INSERT INTO spaonbv_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","5","yo les daré las lluvias con regularidad, la tierra producirá cosechas abundantes, y los árboles darán frutos por más tiempo que el normal. Aún estarán madurando las uvas cuando llegue el tiempo de la siembra. Comerán hasta saciarse, y vivirán seguros en la tierra, ");
INSERT INTO spaonbv_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","porque yo les daré paz y podrán dormir sin temor. Haré desaparecer los animales peligrosos, ");
INSERT INTO spaonbv_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","y ustedes perseguirán a sus enemigos y los matarán a espada. ");
INSERT INTO spaonbv_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Cinco de ustedes perseguirán a cien, y cien de ustedes perseguirán a diez mil. Derrotarán a todos sus enemigos. ");
INSERT INTO spaonbv_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","»Yo los cuidaré, los multiplicaré y cumpliré mi pacto con ustedes. ");
INSERT INTO spaonbv_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Tendrán cosechas tan abundantes que no sabrán qué hacer con ellas cuando llegue el tiempo de la nueva cosecha. ");
INSERT INTO spaonbv_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Yo viviré en medio de ustedes, y no los despreciaré. ");
INSERT INTO spaonbv_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Caminaré en medio de ustedes y seré su Dios, y ustedes serán mi pueblo. ");
INSERT INTO spaonbv_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Porque yo soy el Señor su Dios que los sacó de Egipto, y no permitiré que sean esclavos nuevamente. He roto sus cadenas, y haré que anden con dignidad. ");
INSERT INTO spaonbv_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","»Pero si no escuchan lo que les digo y no me obedecen, ");
INSERT INTO spaonbv_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","sino que rechazan mis leyes, ");
INSERT INTO spaonbv_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","esto es lo que les haré: Los castigaré con terrores repentinos, con tuberculosis y otras enfermedades, les arderán los ojos y la vida se les consumirá. Sembrarán en vano, porque sus enemigos se comerán sus cosechas. ");
INSERT INTO spaonbv_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Me volveré contra ustedes, y huirán delante de sus enemigos. Los que los odian los gobernarán, y ustedes huirán sin que nadie los persiga. ");
INSERT INTO spaonbv_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","»Si persisten en su desobediencia, los castigaré siete veces más fuerte por su pecado. ");
INSERT INTO spaonbv_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Quebrantaré su orgulloso poder, y haré que el cielo sea como acero y la tierra como bronce. ");
INSERT INTO spaonbv_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Gastarán sus fuerzas en vano, porque la tierra no producirá, ni sus árboles darán fruto. ");
INSERT INTO spaonbv_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","»Si aún después de esto no me obedecen ni oyen mis palabras, recibirán como retribución por su pecado siete veces más plagas. ");
INSERT INTO spaonbv_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Enviaré animales salvajes que matarán a sus hijos y destruirán su ganado, y reducirán el número de ustedes, de tal modo que sus caminos quedarán desiertos. ");
INSERT INTO spaonbv_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","»Si después de esto aún no están dispuestos a obedecer, sino que continúan procediendo en contra de mi voluntad, ");
INSERT INTO spaonbv_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","yo, entonces, procederé en contra de sus deseos, y personalmente los castigaré siete veces más fuerte por su pecado. ");
INSERT INTO spaonbv_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Haré que todo el castigo anunciado en mi ley caiga sobre ustedes. Huirán a las ciudades y enviaré plagas contra ustedes allí. Serán conquistados por sus enemigos. ");
INSERT INTO spaonbv_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Destruiré sus abastecimientos de alimento, de modo que un horno será suficiente para cocer el pan de diez familias, y tendrán hambre después que les hayan dado su ración. ");
INSERT INTO spaonbv_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","»Si después de esto no prestan atención ni me obedecen, ");
INSERT INTO spaonbv_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","desataré mi gran ira, y enviaré siete veces más castigos por sus pecados. ");
INSERT INTO spaonbv_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Se comerán a sus hijos e hijas, ");
INSERT INTO spaonbv_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","y destruiré los altares de los lugares altos donde adoran ídolos, derribaré sus altares de incienso, y dejaré que sus cadáveres se pudran en medio de sus ídolos. Y los aborreceré. ");
INSERT INTO spaonbv_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Haré que sus ciudades queden desiertas, destruiré los lugares de adoración, y no responderé a sus ofrendas de incienso. ");
INSERT INTO spaonbv_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Sí, yo desolaré su tierra, y sus enemigos vivirán en ella, y se asombrarán de lo que yo haya hecho. ");
INSERT INTO spaonbv_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Los esparciré entre las naciones, y los destruiré. Sus tierras serán desoladas y sus ciudades quedarán destruidas. ");
INSERT INTO spaonbv_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","35","Entonces la tierra tendrá el descanso que ustedes le negaron. Porque descansará mientras ustedes estén cautivos en tierras enemigas. Sí, la tierra descansará y gozará de sus descansos. Recibirá el descanso que ustedes no le dieron cada siete años, mientras vivían en ella. ");
INSERT INTO spaonbv_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","»A los que queden vivos, haré que sean llevados a tierras distantes como prisioneros de guerra y esclavos. Allí vivirán en constante temor. Una hoja que caiga arrastrada por el viento hará que huyan como si fueran perseguidos por un hombre armado con espada. Huirán cuando nadie los persiga. ");
INSERT INTO spaonbv_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Aun cuando nadie los persiga, huirán y tropezarán unos con otros. No tendrán fuerza alguna para hacer frente a sus enemigos. ");
INSERT INTO spaonbv_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Perecerán en medio de las naciones; serán destruidos por sus enemigos. ");
INSERT INTO spaonbv_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Los que queden, morirán y se pudrirán en un país enemigo, debido a sus propios pecados y a los pecados de sus padres. ");
INSERT INTO spaonbv_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","41","»Pero si se arrepienten y confiesan sus pecados y los pecados con los que sus padres me traicionaron, y que fueron la causa para que yo los sacara de su tierra y los hiciera ir a un país extraño, ");
INSERT INTO spaonbv_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","entonces yo recordaré nuevamente las promesas que les hice a Abraham, a Isaac y a Jacob, y recordaré la tierra y su desolación. ");
INSERT INTO spaonbv_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","La tierra gozará de su descanso mientras esté abandonada. Pero tendrán que reconocer que el castigo que recibieron fue debido a que rechazaron mis leyes. ");
INSERT INTO spaonbv_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","»A pesar de todo lo que hayan hecho, yo no los destruiré totalmente ni desecharé mi pacto con ellos, porque yo soy el Señor su Dios. ");
INSERT INTO spaonbv_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Por amor a sus antepasados, yo recordaré las promesas que les hice de ser su Dios. Yo saqué a sus padres de Egipto mientras todas las naciones los contemplaban maravilladas. Yo soy el Señor». ");
INSERT INTO spaonbv_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Estas fueron las leyes, ordenanzas e instrucciones que el Señor le dio al pueblo de Israel por medio de Moisés, en el monte Sinaí. ");
INSERT INTO spaonbv_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","El Señor le ordenó a Moisés ");
INSERT INTO spaonbv_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","que les dijera a los israelitas: «Cuando una persona haga el voto especial de darse a sí mismo al Señor, tendrá que hacer los siguientes pagos para ser liberada del voto: ");
INSERT INTO spaonbv_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","»Un hombre, cuya edad fluctúe entre los veinte y los sesenta años, pagará cincuenta monedas de plata, según la moneda del santuario. ");
INSERT INTO spaonbv_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","»Una mujer, cuya edad fluctúe entre los veinte y los sesenta años pagará treinta monedas de plata. ");
INSERT INTO spaonbv_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","»Un muchacho entre los cinco y los veinte años, pagará veinte monedas de plata, y una mujer de la misma edad pagará diez monedas de plata. ");
INSERT INTO spaonbv_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","»Por los niños de un mes a cinco años se pagarán cinco monedas de plata, y por las niñas de la misma edad se pagarán tres monedas. ");
INSERT INTO spaonbv_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","»Un hombre mayor de sesenta años, pagará quince monedas de plata, y por una mujer de la misma edad se pagarán diez monedas. ");
INSERT INTO spaonbv_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","»Pero si la persona que hizo el voto es demasiado pobre para pagar el precio establecido, será llevada a la presencia del sacerdote, y este acordará el precio que la persona deberá pagar, de acuerdo con los recursos que tenga. ");
INSERT INTO spaonbv_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","»Pero si se presenta un animal como ofrenda al Señor, el animal quedará consagrado al Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Por eso, no se podrá cambiar por otro animal. Así que un animal bueno no se podrá cambiar por uno malo, ni uno malo se podrá cambiar por uno bueno. Si se hiciera ese cambio, los dos animales pertenecerán al Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","12","»Pero si el animal ofrecido al Señor es un animal impuro, el dueño lo presentará al sacerdote para que determine su precio que se deberá pagar a cambio. ");
INSERT INTO spaonbv_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Si el dueño quiere recuperar su animal, entonces deberá añadir un veinte por ciento más sobre el valor estipulado por el sacerdote. ");
INSERT INTO spaonbv_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","15","»Si alguno ofrece su casa al Señor, y luego desea recuperarla, el sacerdote establecerá su valor, y el hombre pagará esa suma más el veinte por ciento, y la casa será suya nuevamente. ");
INSERT INTO spaonbv_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","»Si alguien consagra una parte de su campo al Señor, el sacerdote determinará el precio del terreno de acuerdo con la cantidad de semilla que se pueda sembrar en él. Por cada doscientos veinte kilos de semilla se pagarán cincuenta monedas de plata. ");
INSERT INTO spaonbv_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Si alguien consagra su campo en el año del jubileo, pagará el total de su valor; ");
INSERT INTO spaonbv_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","pero si lo hace después del año de jubileo, entonces el valor será calculado en proporción al número de años que falten para el próximo jubileo. ");
INSERT INTO spaonbv_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","»Si la persona decide recuperar el campo, pagará el veinte por ciento sobre lo establecido por el sacerdote, y el campo volverá a su poder. ");
INSERT INTO spaonbv_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Pero si decide no recuperarlo o si ha vendido el campo a otra persona y ha dado al Señor sus derechos en el año de jubileo, no le será devuelto. ");
INSERT INTO spaonbv_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Cuando el campo sea liberado en el año de jubileo, pertenecerá al Señor, como campo consagrado a él, y será entregado a los sacerdotes. ");
INSERT INTO spaonbv_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","»Si alguien dedica al Señor un campo comprado, que no es parte de su posesión familiar, ");
INSERT INTO spaonbv_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","el sacerdote estimará su valor según lo que falte para el año del jubileo, e inmediatamente el oferente pagará al Señor el valor estimado. ");
INSERT INTO spaonbv_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","En el año del jubileo el campo volverá a ser propiedad de su dueño original. ");
INSERT INTO spaonbv_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","»Todos los precios se calcularán de acuerdo con la moneda oficial del santuario, que es de diez gramos de plata. ");
INSERT INTO spaonbv_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","»No pueden consagrar al Señor el primogénito de sus bueyes u ovejas, porque ya le pertenecen a él, por ser las primeras crías. ");
INSERT INTO spaonbv_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Pero, si es el primogénito de un animal impuro, el propietario pagará según la estimación hecha por el sacerdote, más el veinte por ciento. Si el propietario no desea recuperarlo, el sacerdote puede vender el animal a otra persona. ");
INSERT INTO spaonbv_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","»Sin embargo, cualquier cosa consagrada al Señor, ya se trate de personas, animales o tierras, no será vendida ni recuperada, porque es cosa santísima delante del Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Ninguno que haya sido sentenciado a muerte podrá pagar por su rescate, sino que deberá morir. ");
INSERT INTO spaonbv_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","»La décima parte del producto de la tierra, sean cereales o frutas, es del Señor, y es santa. ");
INSERT INTO spaonbv_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Si alguien desea rescatar este producto, debe pagar su valor más el veinte por ciento. ");
INSERT INTO spaonbv_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","El diezmo de sus vacas, ovejas y animales domésticos es del Señor. ");
INSERT INTO spaonbv_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","La parte que pertenece al Señor no se podrá cambiar. Así que nadie puede cambiar un animal bueno por uno malo, pues en ese caso los dos animales serán del Señor, y no podrán ser rescatados». ");
INSERT INTO spaonbv_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Estos son los mandamientos para el pueblo de Israel que Dios le dio a Moisés, en el monte Sinaí.");
INSERT INTO spaonbv_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","El primer día del segundo mes del segundo año desde la salida de los israelitas de Egipto, el Señor dio las siguientes instrucciones a Moisés, que se encontraba en el santuario, en el desierto del Sinaí. ");
INSERT INTO spaonbv_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","15","«Haz un censo de todos los hombres, mayores de veinte años, capaces de ir a la guerra. En la lista anota la tribu y familia a la que pertenezcan. Aarón y tú deberán organizar este trabajo, con la ayuda de los siguientes jefes de cada tribu. Tribu Jefe Rubén Elisur (hijo de Sedeúr); Simeón Selumiel (hijo de Zurisaday); Judá Naasón (hijo de Aminadab); Isacar Natanael (hijo de Zuar); Zabulón Eliab (hijo de Helón); hijos de José: Efraín Elisama (hijo de Amiud); Manasés Gamaliel (hijo de Pedasur); Benjamín Abidán (hijo de Gedeoni); Dan Ajiezer (hijo de Amisaday); Aser Paguiel (hijo de Ocrán); Gad Eliasaf (hijo de Deuel); Neftalí Ajira (hijo de Enán)». ");
INSERT INTO spaonbv_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Estos eran los jefes de tribu seleccionados de entre el pueblo. ");
INSERT INTO spaonbv_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","19","El mismo día, Moisés, Aarón y los jefes de tribu que se acaban de mencionar convocaron a todos los hombres de Israel de más de veinte años, para que se inscribieran, indicando su tribu y familia, como el Señor le había dicho a Moisés. ");
INSERT INTO spaonbv_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","46","La tabla resultante: Tribu Total Rubén (el hijo mayor de Jacob) 46.500 Simeón 59.300 Gad 45.650 Judá 74.600 Isacar 54.400 Zabulón 57.400 José: Efraín (hijo de José) 40.500 José: Manasés (hijo de José) 32.200 Benjamín 35.400 Dan 62.700 Aser 41.500 Neftalí 53.400 TOTAL 603.550 ");
INSERT INTO spaonbv_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","49","Esa cifra no incluía a los levitas, pues el Señor le había dicho a Moisés: «Excluye a toda la tribu de Leví, ");
INSERT INTO spaonbv_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","porque los levitas tienen que hacerse cargo del trabajo del santuario y de su transporte. Tienen que vivir cerca del santuario, ");
INSERT INTO spaonbv_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","y cuando este deba ser trasladado, los levitas deberán desmontarlo y montarlo. Si cualquiera otra persona lo toca, deberá ser ejecutada. ");
INSERT INTO spaonbv_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Cada tribu de Israel acampará por separado y tendrá su bandera propia. ");
INSERT INTO spaonbv_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Las tiendas de campaña de los levitas estarán situadas en torno al santuario para proteger al pueblo de la ira de Dios». ");
INSERT INTO spaonbv_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Así pues, todas las instrucciones que el Señor dio a Moisés se llevaron a cabo. ");
INSERT INTO spaonbv_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","El Señor dio también estas instrucciones a Moisés y Aarón: ");
INSERT INTO spaonbv_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","«Cada tribu tendrá su propio campamento, con un mástil y la bandera de la tribu; y en el centro de estos campamentos estará el santuario». ");
INSERT INTO spaonbv_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","31","La ubicación de las tribus: Tribu Jefe Situación Censo Judá Naasón (hijo de Aminadab) Al este del santuario 74.600 Isacar Natanael (hijo de Zuar) Junto a Judá 54.400 Zabulón Eliab (hijo de Helón) Junto a Isacar 57.400 El total de los que estaban en el campamento junto a Judá era de ciento ochenta y seis mil cuatrocientos. Estas tribus abrían la marcha siempre que los israelitas tenían que trasladar el campamento. Tribu Jefe Situación Censo Rubén Elisur (hijo de Sedeúr) Al sur del santuario 46.500 Simeón Selumiel (hijo de Zurisaday) Junto a Rubén 59.300 Gad Eliasaf (hijo de Reuel o Deuel) Junto a Simeón 45.650 Así que el total de los que estaban en el campamento junto a Rubén era de ciento cincuenta y un mil cuatrocientos cincuenta. Estas tres tribus eran las segundas en marchar cuando los israelitas viajaban. Luego seguía el santuario con los levitas. Durante los viajes, cada tribu se mantenía en torno a su bandera, conservando el lugar, el orden y la distancia que había entre cada una cuando acampaban. Tribu Jefe Situación Censo Efraín Elisama (hijo de Amiud) Al oeste del santuario 40.500 Manasés Gamaliel (hijo de Pedasur) Junto a Efraín 32.200 Benjamín Abidán (hijo de Gedeoni) Junto a Manasés 35.400 El total de los que estaban en el campamento junto a Efraín era de ciento ocho mil cien, y eran los terceros en marchar. Tribu Jefe Situación Censo Dan Ajiezer (hijo de Amisaday) Al norte del santuario 62.700 Aser Paguiel (hijo de Ocrán) Junto a Dan 41.500 Neftalí Ajira (hijo de Enán) Junto a Aser 53.400 El total de los que estaban en el campamento junto a Dan era de ciento cincuenta y siete mil seiscientos. Estos cerraban la marcha cuando Israel se trasladaba. ");
INSERT INTO spaonbv_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","33","En resumen, los ejércitos de Israel sumaban seiscientos tres mil quinientos cincuenta (sin incluir a los levitas, que quedaban exentos por el mandamiento que el Señor le había dado a Moisés). ");
INSERT INTO spaonbv_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Así pues, el pueblo de Israel asentó sus campamentos situándose y marchando cada tribu bajo su bandera, en los lugares que el Señor le había indicado a Moisés. ");
INSERT INTO spaonbv_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","En la época en que el Señor habló a Moisés en el monte Sinaí, ");
INSERT INTO spaonbv_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","los hijos de Aarón eran: Nadab (el mayor), Abiú, Eleazar e Itamar. ");
INSERT INTO spaonbv_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Todos ellos fueron ungidos para el sacerdocio, y dedicados para el servicio del santuario. ");
INSERT INTO spaonbv_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Pero Nadab y Abiú murieron delante del Señor en el desierto del Sinaí, porque utilizaron un fuego diferente al que Dios les había indicado. Y como no tenían hijos, sólo quedaron Eleazar e Itamar para ayudar a su padre Aarón. ");
INSERT INTO spaonbv_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Entonces el Señor le dijo a Moisés: ");
INSERT INTO spaonbv_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","«Convoca a la tribu de Leví y preséntalos a Aarón, para que sean sus ayudantes. ");
INSERT INTO spaonbv_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","9","Seguirán sus instrucciones y realizarán los deberes sagrados del santuario en lugar de todo el pueblo de Israel, al cual representan. Se encargarán de todos los suministros del santuario y de su mantenimiento. ");
INSERT INTO spaonbv_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Pero sólo Aarón y sus hijos están autorizados para desempeñar este cargo; cualquiera otro que se atreva a hacerlo morirá». ");
INSERT INTO spaonbv_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Además el Señor le dijo a Moisés: ");
INSERT INTO spaonbv_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","«He aceptado a los levitas en sustitución de todos los primogénitos del pueblo de Israel. Los levitas me pertenecen ");
INSERT INTO spaonbv_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","a cambio de todos los primogénitos. Desde el día en que maté a todos los primogénitos de los egipcios, me he reservado para mí a todos los primogénitos de Israel, tanto de hombres como de animales. Son míos: Yo soy el Señor». ");
INSERT INTO spaonbv_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","El Señor le habló de nuevo a Moisés en el desierto del Sinaí, diciéndole: ");
INSERT INTO spaonbv_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","«Haz el censo de la tribu de Leví, indicando el clan a que pertenece cada persona; cuenta todos los hombres desde un mes de nacidos en adelante». ");
INSERT INTO spaonbv_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","24","Y Moisés lo hizo. Estos fueron los resultados: Hijo de Leví Nietos de Leví (Nombres del clan) Censo Jefe Situación Guersón Libn, Simí 7.500 Eliasaf (hijo de Lael) Al oeste del santuario La responsabilidad de estos dos clanes de levitas consistía en cuidar el santuario: sus cubiertas, sus cortinajes de entrada, la cortina que cubría la valla que rodeaba el patio, la cortina de la entrada al patio del santuario, el altar y todas las cuerdas que se usaban para armar el santuario. Coat Amirá, Iza, Hebró, Uziel 8.600 Elizafán (hijo de Uziel) Al sur del santuario ");
INSERT INTO spaonbv_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","37","Las responsabilidades de estos cuatro clanes de levitas consistían en cuidar el cofre, la mesa, el candelabro, los altares, los diversos utensilios empleados en el santuario, el velo, y todo lo que fuera necesario para sus usos. (Nota: Eleazar, hijo de Aarón, fue el administrador general de los jefes de los levitas, y tuvo la responsabilidad de supervisar el santuario). Merari Majl, Musí 6.200 Zuriel Al norte del santuario La responsabilidad de estos dos clanes consistía en cuidar la estructura de la tienda del santuario, los postes, las bases de los postes, y todo lo que fuera necesario para sus usos, los postes que hay en torno al patio, con sus bases, estacas, y cuerdas. ");
INSERT INTO spaonbv_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","La zona este del santuario estaba reservada para las tiendas de Moisés y de Aarón y sus hijos, quienes tenían la responsabilidad máxima sobre el santuario, en representación del pueblo de Israel. (Si alguien que no fuera sacerdote ni levita entraba en el santuario, debía ser ejecutado). ");
INSERT INTO spaonbv_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Así que los levitas, contados por Moisés y Aarón por mandamiento del Señor, sumaban veintidós mil varones de más de un mes de edad. ");
INSERT INTO spaonbv_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Entonces el Señor le dijo a Moisés: «Ahora haz un censo de todos los primogénitos de Israel de más de un mes de nacidos; e inscríbelos por sus nombres. ");
INSERT INTO spaonbv_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Los levitas serán míos en sustitución de los primogénitos de Israel; y el ganado de los levitas es mío en sustitución de los primogénitos del ganado de toda la nación. Yo soy el Señor». ");
INSERT INTO spaonbv_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Así, pues, Moisés hizo el censo de todos los primogénitos de Israel, como el Señor había ordenado, ");
INSERT INTO spaonbv_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","y vio que el número de primogénitos de más de un mes de nacidos era de veintidós mil doscientos setenta y tres. ");
INSERT INTO spaonbv_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Entonces el Señor le dijo a Moisés: ");
INSERT INTO spaonbv_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","«Dame los levitas a cambio de los primogénitos del pueblo de Israel; y dame el ganado de los levitas a cambio de los primogénitos del ganado del pueblo de Israel; sí, los levitas serán míos. Yo soy el Señor. ");
INSERT INTO spaonbv_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Para redimir los doscientos setenta y tres primogénitos que exceden del número de levitas, ");
INSERT INTO spaonbv_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","48","paga sesenta gramos de plata por cada uno a Aarón y sus hijos». ");
INSERT INTO spaonbv_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Moisés, pues, recibió dinero para redimir a los primogénitos que sobrepasaban el número de los levitas. (Todos los demás estaban redimidos porque los levitas habían sido entregados al Señor en su lugar). ");
INSERT INTO spaonbv_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","El dinero recogido ascendió a un total de más de dieciséis kilos de plata. ");
INSERT INTO spaonbv_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Y Moisés se lo dio a Aarón y a sus hijos, tal como el Señor había mandado. ");
INSERT INTO spaonbv_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Entonces el Señor les dijo a Moisés y a Aarón: ");
INSERT INTO spaonbv_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","«Haz el censo del grupo de Coat en la tribu de Leví. ");
INSERT INTO spaonbv_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Este censo debe incluir a todos los hombres entre treinta y cincuenta años capaces de trabajar en el santuario. ");
INSERT INTO spaonbv_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Estos serán sus sagrados deberes: ");
INSERT INTO spaonbv_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","»Cuando el campamento se traslade, Aarón y sus hijos entrarán primero en el santuario, quitarán el velo y cubrirán el cofre con él. ");
INSERT INTO spaonbv_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Luego cubrirán el velo con pieles de cabra, y taparán las pieles de cabra con un paño azul, y pondrán en los anillos del cofre las varas para transportarla. ");
INSERT INTO spaonbv_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","»Luego extenderán un paño azul sobre la mesa donde se exhibe el pan de la Presencia; y pondrán sobre ese paño los platos, cucharas, tazas y el pan. ");
INSERT INTO spaonbv_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Extenderán un paño escarlata sobre todo eso, y por último lo taparán todo con una piel de cabra. Después meterán las varas en los anillos de la mesa, para el transporte. ");
INSERT INTO spaonbv_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","»Luego taparán con un manto azul el candelabro, las lamparillas, las despabiladeras, las bandejas y el depósito del aceite. ");
INSERT INTO spaonbv_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Todos estos objetos serán envueltos en una piel de cabra, y el paquete se pondrá en unas barras de madera. ");
INSERT INTO spaonbv_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","»A continuación taparán el altar de oro con un paño azul, lo cubrirán con pieles de cabra, y meterán las varas para transportarlo. ");
INSERT INTO spaonbv_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Todos los demás utensilios del santuario irán envueltos en un paño azul, tapado con pieles de cabra, y colocado sobre unas barras de madera. ");
INSERT INTO spaonbv_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","»Quitarán las cenizas del altar, y lo cubrirán con un paño púrpura. ");
INSERT INTO spaonbv_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Todos los utensilios del altar se pondrán en este paño: los ceniceros, los garfios, los braseros y los tazones, y se tapará todo con pieles de cabra. Por último se colocarán las varas para su transporte. ");
INSERT INTO spaonbv_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Cuando Aarón y sus hijos hayan terminado de empacar el santuario y todos los utensilios, el clan de Coat vendrá y trasladará todos los paquetes al nuevo lugar del campamento; pero no deben tocar los objetos sagrados, para que no mueran. Este es el trabajo sagrado de los hijos de Coat. ");
INSERT INTO spaonbv_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","»Eleazar, el hijo de Aarón, se encargará del aceite para las lámparas, del incienso, del grano para la ofrenda diaria y del aceite de la unción. En otras palabras, la supervisión de todo el santuario y de todo lo que en él hay, será responsabilidad suya». ");
INSERT INTO spaonbv_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","También el Señor les dijo a Moisés y a Aarón: ");
INSERT INTO spaonbv_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","«¡No permitan que las familias de los hijos de Coat se destruyan! ");
INSERT INTO spaonbv_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Esto es lo que tienen que hacer para que no mueran cuando trasladen las cosas santas: Aarón y sus hijos entrarán con ellos y les indicarán lo que cada uno debe transportar. ");
INSERT INTO spaonbv_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Aparte de esto, nunca deben entrar en el santuario ni por un momento, porque si se atreven a mirar los objetos sagrados, morirán». ");
INSERT INTO spaonbv_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Y el Señor le dijo a Moisés: ");
INSERT INTO spaonbv_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","«Haz el censo del clan de Guersón de la tribu de Leví: ");
INSERT INTO spaonbv_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","de todos los hombres entre treinta y cincuenta años, aptos para el trabajo sagrado en el santuario. ");
INSERT INTO spaonbv_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Sus funciones serán las siguientes: ");
INSERT INTO spaonbv_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","»Transportarán los cortinajes del santuario, el santuario propiamente dicho con sus cubiertas, la cubierta superior de piel de cabra, y la cortina de la entrada del santuario. ");
INSERT INTO spaonbv_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","También transportarán las cortinas que tapan la valla del atrio, la cortina de la entrada al atrio que rodea al santuario y al altar. También transportarán el altar, las cuerdas y todos los accesorios. Serán totalmente responsables de estos objetos. ");
INSERT INTO spaonbv_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Aarón o cualquiera de sus hijos pueden encomendar estas tareas a los gersonitas, ");
INSERT INTO spaonbv_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","pero estos serán directamente responsables ante Itamar, el hijo de Aarón. ");
INSERT INTO spaonbv_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","»Luego haz el censo del clan de Merari de la tribu de Leví, ");
INSERT INTO spaonbv_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","incluyendo a todos los hombres entre treinta y cincuenta años, aptos para el trabajo en el santuario. ");
INSERT INTO spaonbv_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Cuando se traslade el santuario, ellos transportarán la estructura del mismo, las barras, las bases, ");
INSERT INTO spaonbv_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","la estructura de la valla del atrio con sus bases, estacas y cuerdas, y todo lo necesario para su uso y reparación. Consignarás por sus nombres todos los utensilios que ellos tienen que llevar. ");
INSERT INTO spaonbv_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","El clan de Merari también será responsable ante Itamar, el hijo de Aarón». ");
INSERT INTO spaonbv_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Así pues, Moisés, Aarón y los demás jefes hicieron el censo del clan de Coat, ");
INSERT INTO spaonbv_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","incluyendo a todos los hombres entre treinta y cincuenta años, aptos para el servicio del santuario, ");
INSERT INTO spaonbv_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","y vieron que el número total era de dos mil setecientos cincuenta. ");
INSERT INTO spaonbv_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Todo esto lo hicieron en cumplimiento de las instrucciones que el Señor le dio a Moisés. ");
INSERT INTO spaonbv_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","41","El censo similar del clan de Guersón dio una cifra de dos mil seiscientos treinta. ");
INSERT INTO spaonbv_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","45","Y el del clan de Merari, tres mil doscientos. ");
INSERT INTO spaonbv_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","48","Así que Moisés, Aarón y los demás dirigentes de Israel vieron que el total de los levitas entre treinta y cincuenta años, aptos para el servicio en el santuario, y para su transporte, era de ocho mil quinientos ochenta. ");
INSERT INTO spaonbv_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Este censo se hizo en obediencia a las instrucciones que el Señor le dio a Moisés. ");
INSERT INTO spaonbv_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Otras instrucciones que el Señor dio a Moisés: ");
INSERT INTO spaonbv_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","«Informa al pueblo de Israel que deben sacar a todos los leprosos del campamento y a todos los que padecen flujo, así como a los que se han contaminado tocando a un muerto. ");
INSERT INTO spaonbv_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Esto es aplicable tanto a hombres como a mujeres. Sáquenlos para que no contaminen el campamento donde yo habito con ustedes». ");
INSERT INTO spaonbv_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Estas instrucciones se llevaron a cabo. ");
INSERT INTO spaonbv_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Entonces el Señor le dijo a Moisés: ");
INSERT INTO spaonbv_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","«Dile al pueblo de Israel que cuando alguien, sea hombre o mujer, sea infiel al Señor por pecar contra su prójimo, ");
INSERT INTO spaonbv_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","debe confesar su pecado y debe restituir a la persona perjudicada completamente el daño, añadiendo el veinte por ciento. ");
INSERT INTO spaonbv_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Pero si la persona perjudicada ha muerto, y no hay un pariente cercano a quien se pueda hacer el pago, entonces la restitución debe darse al sacerdote, junto con un cordero como restitución. ");
INSERT INTO spaonbv_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","10","Cuando el pueblo de Israel lleve una ofrenda al Señor, la ofrenda quedará como posesión de los sacerdotes». ");
INSERT INTO spaonbv_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Y el Señor le dijo a Moisés: ");
INSERT INTO spaonbv_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","«Dile al pueblo de Israel que si la esposa de un hombre comete adulterio, ");
INSERT INTO spaonbv_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","pero no hay pruebas por falta de testigos, ");
INSERT INTO spaonbv_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","y él tiene sospechas y está celoso, ");
INSERT INTO spaonbv_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","el marido llevará a su mujer ante el sacerdote junto con una ofrenda por ella, consistente en dos kilos y medio de harina de cebada, sin aceite ni incienso —porque es una ofrenda de celos— con el fin de averiguar la verdad en cuanto a si es culpable o no. ");
INSERT INTO spaonbv_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","»El sacerdote presentará a la mujer ante el Señor, ");
INSERT INTO spaonbv_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","y pondrá agua santa en una jarra de barro, mezclándola con polvo del suelo del santuario. ");
INSERT INTO spaonbv_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","La mujer desatará sus cabellos y pondrá en sus manos la ofrenda de los celos para determinar si las sospechas de su marido están o no justificadas. El sacerdote estará de pie delante de ella sosteniendo al jarro con agua amarga que trae la maldición. ");
INSERT INTO spaonbv_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","El sacerdote la pondrá bajo juramento para jurar que es inocente, y a continuación le dirá: “Si ningún hombre se ha acostado contigo, excepto tu marido que quedes libre de los efectos de esta agua amarga que trae maldición. ");
INSERT INTO spaonbv_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Pero si has cometido adulterio, ");
INSERT INTO spaonbv_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","22","que el Señor te maldiga en medio de tu pueblo, y no puedas tener hijos y tu vientre se hinche”. Entonces le pedirá a la mujer que diga: “Sí, así sea”. ");
INSERT INTO spaonbv_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","A continuación el sacerdote escribirá las maldiciones en un libro y las lavará con el agua amarga. ");
INSERT INTO spaonbv_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","(Cuando la mujer se beba el agua a instancia del sacerdote, esta se hará amarga dentro de ella si es culpable). ");
INSERT INTO spaonbv_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","»Entonces el sacerdote tomará la ofrenda de los celos, la mecerá ante el Señor y la llevará al altar. ");
INSERT INTO spaonbv_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Tomará un puñado de la ofrenda, lo quemará sobre el altar, y luego ordenará a la mujer que se beba el agua. ");
INSERT INTO spaonbv_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Si ella se ha contaminado cometiendo adulterio contra su marido, el agua se volverá amarga en su interior, y su vientre se hinchará y sus muslos se secarán, y ella será maldita en su nación. ");
INSERT INTO spaonbv_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Pero si ella es fiel a su marido y no ha cometido adulterio, no le pasará nada y pronto quedará encinta. ");
INSERT INTO spaonbv_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","»Esta es, pues, la ley en cuanto a la esposa infiel —o en cuanto a las sospechas de un marido respecto a su mujer—. ");
INSERT INTO spaonbv_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","Esta es la ley que se aplicará cuando una esposa sea infiel a su marido, o este sospeche que lo ha sido, el marido llevará a su mujer ante el sacerdote, y este actuará como se ha dicho antes. ");
INSERT INTO spaonbv_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","El marido no será juzgado por haberle causado tan terrible enfermedad, pues ella es la responsable». ");
INSERT INTO spaonbv_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","El Señor también le dio a Moisés estas instrucciones para el pueblo de Israel: ");
INSERT INTO spaonbv_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","«Cuando un hombre o una mujer haga el voto del nazareato, consagrándose al Señor de un modo especial, ");
INSERT INTO spaonbv_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","4","durante todo el período de su consagración al Señor no debe probar bebidas fuertes, ni vino añejo, ni vino recién hecho, ni mosto, ni uvas, ni uvas pasas. No puede comer nada de lo que proviene de la uva, ni siquiera los granillos o el hollejo. ");
INSERT INTO spaonbv_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","»Durante todo ese tiempo nunca se cortará el cabello, pues es santo y consagrado al Señor, y por eso debe dejar que le crezca. ");
INSERT INTO spaonbv_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","»Tampoco podrá acercarse a un cadáver durante el tiempo de su voto, ");
INSERT INTO spaonbv_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","aunque se trate del cuerpo de su padre o de su madre, hermano o hermana, pues su voto de consagración sigue teniendo efecto, ");
INSERT INTO spaonbv_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","y está consagrado al Señor durante todo ese tiempo. ");
INSERT INTO spaonbv_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","»Si se contamina porque alguien cae muerto junto a él, siete días después se afeitará su cabeza contaminada y así quedará limpio de la contaminación por haber estado en presencia de un cadáver. ");
INSERT INTO spaonbv_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Al día siguiente, el octavo, llevará dos tórtolas o dos palominos al sacerdote, en la entrada del santuario. ");
INSERT INTO spaonbv_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","El sacerdote ofrecerá una de estas aves a modo de ofrenda por el pecado, y la otra como ofrenda totalmente quemada, y así reparará el problema de su contaminación. Ese mismo día deberá renovar sus votos y dejar que el cabello le vuelva a crecer. ");
INSERT INTO spaonbv_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Los días que cumplió del voto antes de su contaminación no serán válidos. Debe empezar de nuevo con otro voto, y debe presentar un cordero de un año en pago por su culpa. ");
INSERT INTO spaonbv_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","»Al terminar el período de su consagración al Señor, irá a la entrada del santuario ");
INSERT INTO spaonbv_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","y ofrecerá como ofrenda quemada al Señor, un cordero de un año sin ningún defecto. También ofrecerá una cabra de un año sin ningún defecto en pago por sus pecados, un carnero sin defecto como ofrenda de paz, ");
INSERT INTO spaonbv_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","una cesta de panes sin levadura; panes hechos con harina fina y aceite de oliva, hojaldres sin levadura untados con aceite y las correspondientes ofrendas de grano y de bebidas. ");
INSERT INTO spaonbv_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","El sacerdote presentará estas ofrendas ante el Señor: primero la ofrenda por el pecado y la ofrenda quemada, ");
INSERT INTO spaonbv_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","luego el carnero de la ofrenda de paz junto con la cesta de pan sin levadura, y por último la ofrenda de grano y la ofrenda de bebidas. ");
INSERT INTO spaonbv_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","»Entonces el nazareo se cortará el cabello que se dejó crecer como señal de su voto de separación. Esto se hará a la entrada del santuario, y a continuación se echará el cabello al fuego, junto con el sacrificio de la ofrenda de paz. ");
INSERT INTO spaonbv_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Después de afeitar la cabeza del devoto, el sacerdote cogerá la paletilla asada del cordero, uno de los panes (hechos sin levadura) y una de las hojaldres, y lo pondrá en las manos del hombre. ");
INSERT INTO spaonbv_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Luego el sacerdote lo mecerá ante el Señor como se hace con la ofrendas. Todo esto será una porción santa para el sacerdote, así como también la costilla y la paletilla que fueron mecidas ante el Señor. Después de esto el nazareo puede beber otra vez vino, pues ha quedado libre de su voto. ");
INSERT INTO spaonbv_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","»Ese es el reglamento para el nazareato y para sus sacrificios al terminar el período de la dedicación especial. Además de estos sacrificios debe también traer la ofrenda que prometió cuando hizo el voto de hacerse nazareo». ");
INSERT INTO spaonbv_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Luego el Señor le dijo a Moisés: ");
INSERT INTO spaonbv_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","«Diles a Aarón y a sus hijos que cuando bendigan al pueblo de Israel lo hagan con esta bendición: ");
INSERT INTO spaonbv_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","26","“El Señor te bendiga y te guarde; que el rostro del Señor resplandezca sobre ti, que él te sea propicio, te muestre su favor y te dé su paz”. ");
INSERT INTO spaonbv_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Así es como Aarón y sus hijos invocarán mis bendiciones sobre el pueblo de Israel; y yo los bendeciré». ");
INSERT INTO spaonbv_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Moisés ungió y santificó el santuario, incluyendo el altar y los utensilios, el mismo día en que se terminó su montaje. ");
INSERT INTO spaonbv_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Entonces los dirigentes de Israel —los jefes de las tribus que habían organizado el censo— presentaron sus ofrendas. ");
INSERT INTO spaonbv_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Trajeron seis carros cubiertos, tirados cada uno de ellos por dos bueyes —un carro por cada dos jefes y un buey por cada uno— y lo presentaron ante el Señor a la entrada del santuario. ");
INSERT INTO spaonbv_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","5","«Acepta sus ofrendas» —le dijo el Señor a Moisés—, «y utiliza esos carros para el trabajo del santuario. Entrégaselos a los levitas para lo que los necesiten». ");
INSERT INTO spaonbv_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Moisés, por lo tanto, hizo entrega de los carros y los bueyes a los levitas. ");
INSERT INTO spaonbv_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Al clan de Guersón se le dio, para uso de ellos, dos carros y cuatro bueyes, ");
INSERT INTO spaonbv_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","y cuatro carros y ocho bueyes fueron entregados al grupo de Merari, que estaba al mando de Itamar, hijo de Aarón. ");
INSERT INTO spaonbv_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Al grupo de Coat no se le dio ningún carro ni ninguna yunta, ya que se les había requerido que transportaran en hombros la parte que les correspondía del santuario. ");
INSERT INTO spaonbv_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Los jefes presentaron también unas ofrendas de dedicación el día en que el altar fue ungido, colocándolas sobre el altar. ");
INSERT INTO spaonbv_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","El Señor le dijo a Moisés: «Que cada uno traiga, en días diferentes, su ofrenda para la dedicación del altar». ");
INSERT INTO spaonbv_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Naasón, hijo de Aminadab, de la tribu de Judá, fue el primero en presentar su ofrenda. ");
INSERT INTO spaonbv_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Esta consistía en una bandeja de plata que pesaba más de un kilo y medio y un tazón de plata de más de ochocientos gramos, llenos los dos con ofrendas de harina y aceite. ");
INSERT INTO spaonbv_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","También presentó una pequeña bandeja de oro llena de incienso, que pesaba unos ciento veinte gramos. ");
INSERT INTO spaonbv_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","Trajo además, como ofrendas para ser quemadas por completo, un becerro, un carnero y un corderillo de un año. ");
INSERT INTO spaonbv_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","También trajo un chivo para la ofrenda por el pecado, ");
INSERT INTO spaonbv_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","y dos bueyes, cinco carneros, cinco chivos y cinco corderillos de un año para la ofrenda de paz. ");
INSERT INTO spaonbv_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","23","Al día siguiente Natanael, hijo de Zuar, jefe de la tribu de Isacar, presentó sus dones y ofrendas. Eran estos exactamente iguales que los que había presentado Naasón el día anterior. ");
INSERT INTO spaonbv_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","29","Al tercer día, Eliab, hijo de Helón, jefe de la tribu de Zabulón, vino con ofrendas iguales a las que se habían presentado los días anteriores. ");
INSERT INTO spaonbv_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","35","Al cuarto día Elisur, hijo de Sedeúr, jefe de la tribu de Rubén, fue a entregar sus ofrendas, que eran iguales que las que se habían presentado con anterioridad. ");
INSERT INTO spaonbv_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","41","Al quinto día fue Selumiel, hijo de Zurisaday, jefe de la tribu de Simeón, con las mismas ofrendas. ");
INSERT INTO spaonbv_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","47","Al día siguiente le correspondió a Eliasaf, hijo de Deuel, jefe de la tribu de Gad. También él presentó las mismas ofrendas y sacrificios. ");
INSERT INTO spaonbv_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","53","Al séptimo día, Elisama, hijo de Amiud, jefe de la tribu de Efraín, llevó sus ofrendas, igual que las que se habían presentado anteriormente. ");
INSERT INTO spaonbv_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","59","Gamaliel, hijo de Pedasur, jefe de la tribu de Manasés, fue al octavo día con las mismas ofrendas. ");
INSERT INTO spaonbv_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","65","Al noveno día fue Abidán, hijo de Gedeoni, jefe de la tribu de Benjamín, con ofrendas iguales a las que presentaron los otros. ");
INSERT INTO spaonbv_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","71","Ajiezer, hijo de Amisaday, llevó sus ofrendas al décimo día. Este era jefe de la tribu de Dan, y sus ofrendas fueron iguales que las de los demás. ");
INSERT INTO spaonbv_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","77","Paguiel, hijo de Ocrán, jefe de la tribu de Aser, llevó sus ofrendas al undécimo día y eran idénticas a las anteriores. ");
INSERT INTO spaonbv_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","83","Al duodécimo día se presentó Ajira, hijo de Enán, jefe de la tribu de Neftalí, con sus ofrendas, que eran idénticas a las entregadas por los otros. ");
INSERT INTO spaonbv_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","86","Así pues, a partir del día en que se ungió el altar, este fue dedicado con las ofrendas de los jefes de las tribus de Israel. Las ofrendas sumadas fueron: 12 bandejas de plata (de más de un kilo y medio cada una); 12 tazones de plata (de más de ochocientos gramos cada uno, de modo que el peso total de la plata era casi veintinueve kilos); 12 cajitas de oro (cada una de ellas de ciento veinte gramos; de modo que el peso total del oro casi llegaba al kilo y medio). ");
INSERT INTO spaonbv_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Para las ofrendas que se ofrecen en su totalidad presentaron: 12 becerros, 12 carneros y 12 chivos tiernos (con las ofrendas de grano que les acompañaban). Para las ofrendas por el pecado presentaron: 12 chivos. ");
INSERT INTO spaonbv_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Para las ofrendas de paz presentaron: 24 novillos, 60 carneros, 60 chivos, 60 corderos de un año. ");
INSERT INTO spaonbv_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Cuando Moisés entraba en el santuario para hablar con Dios, oía la voz que le hablaba desde encima del propiciatorio que estaba sobre el cofre, entre los dos querubines. ");
INSERT INTO spaonbv_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","El Señor le dijo a Moisés: ");
INSERT INTO spaonbv_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","«Dile a Aarón que cuando encienda las siete lámparas del candelabro, debe hacerlo de forma que la luz se proyecte hacia delante». ");
INSERT INTO spaonbv_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Y Aarón lo hizo así. ");
INSERT INTO spaonbv_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","El candelabro, incluyendo los adornos florales de la base y las ramas, estaba todo hecho de oro labrado a martillo. Su construcción correspondía al modelo exacto que el Señor le había mostrado a Moisés. ");
INSERT INTO spaonbv_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Entonces el Señor le dijo a Moisés: ");
INSERT INTO spaonbv_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","«Ahora separa a los levitas de las demás tribus de Israel. ");
INSERT INTO spaonbv_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Esto lo harás rociando sobre ellos el agua de la purificación, y haciendo que se afeiten el cuerpo y se bañen y se laven la ropa. ");
INSERT INTO spaonbv_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Haz que traigan un becerro y una ofrenda de harina fina mezclada con aceite, junto con otro becerro para la ofrenda por el pecado. ");
INSERT INTO spaonbv_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Luego haz venir a los levitas a la puerta del santuario, a vista de todo el pueblo. ");
INSERT INTO spaonbv_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Entonces los jefes de las tribus pondrán las manos sobre ellos, ");
INSERT INTO spaonbv_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","y Aarón, como si estuviera haciendo una ofrenda, los presentará al Señor como un don de toda la nación de Israel. Así, los levitas quedarán consagrados y representarán a todo el pueblo en el servicio del Señor. ");
INSERT INTO spaonbv_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","»A continuación, los jefes levitas pondrán las manos sobre las cabezas de los becerros y los ofrecerán al Señor; uno para la ofrenda por el pecado y el otro para ser quemada en su totalidad, para perdonar las faltas y pecados de los levitas. ");
INSERT INTO spaonbv_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Los levitas serán presentados a Aarón y sus hijos, de la misma forma en que cualquiera otra ofrenda al Señor es presentada a los sacerdotes. ");
INSERT INTO spaonbv_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","De esta forma dedicarás a los levitas de entre el resto del pueblo de Israel, y los levitas serán míos. ");
INSERT INTO spaonbv_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Después de que los hayas santificado y presentado de esta forma, podrán entrar y salir del santuario en cumplimiento de sus deberes: ");
INSERT INTO spaonbv_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","»Son míos de entre el pueblo de Israel y yo los he aceptado en sustitución de todos los primogénitos de los israelitas. He tomado a los levitas como sustitutos, ");
INSERT INTO spaonbv_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","pues todos los primogénitos de los hijos de Israel son míos, tanto hombres como animales; yo me los apropié la noche en que maté a todos los primogénitos de los egipcios. ");
INSERT INTO spaonbv_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Sí, yo he aceptado a los levitas en lugar de los primogénitos de Israel. ");
INSERT INTO spaonbv_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Y los daré como presente a Aarón y sus hijos. Los levitas desempeñarán los deberes sagrados requeridos al pueblo de Israel en el santuario, y ofrecerán los sacrificios del pueblo para obtener el perdón por él. Así, no habrá plaga alguna en Israel como la habría si personas comunes entraran en el santuario». ");
INSERT INTO spaonbv_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Moisés y Aarón y todo el pueblo de Israel dedicaron, pues, a los levitas, siguiendo cuidadosamente las instrucciones que el Señor le había dado a Moisés. ");
INSERT INTO spaonbv_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Los levitas se purificaron y lavaron sus vestiduras, y Aarón los presentó al Señor haciendo un gesto de ofrenda. Luego hizo el rito del perdón sobre ellos para purificarlos. ");
INSERT INTO spaonbv_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Después de esto entraron en el santuario como ayudantes de Aarón y sus hijos. Todo se hizo como el Señor le había mandado a Moisés. ");
INSERT INTO spaonbv_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","El Señor le dijo también a Moisés: ");
INSERT INTO spaonbv_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","«Los levitas comenzarán a servir en el santuario a la edad de veinticinco años, ");
INSERT INTO spaonbv_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","y se retirarán a los cincuenta. ");
INSERT INTO spaonbv_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Después de su retiro pueden ayudar en el santuario en las tareas ligeras, pero no tendrán deberes regulares». ");
INSERT INTO spaonbv_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","El Señor le dio estas instrucciones a Moisés cuando él y el resto de Israel estaban en la península de Sinaí, durante el primer mes del segundo año tras su salida de Egipto: ");
INSERT INTO spaonbv_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","3","«El pueblo de Israel debe celebrar la Pascua cada año el día catorce del primer mes empezando al atardecer. Asegúrate de que sigan todas mis instrucciones al celebrarla». ");
INSERT INTO spaonbv_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Moisés anunció entonces ");
INSERT INTO spaonbv_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","que la celebración de la Pascua comenzaría al atardecer del día catorce, allí mismo; en la península de Sinaí, tal como el Señor había ordenado. ");
INSERT INTO spaonbv_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Pero sucedió que varios hombres habían asistido a un entierro, ");
INSERT INTO spaonbv_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","y estaban contaminados ceremonialmente por haber tocado el cadáver, de modo que no podían comer el cordero pascual aquella noche. Acudieron a Moisés y a Aarón y les explicaron el problema y se quejaron de que se les prohibiera comer su sacrificio al Señor en el día señalado. ");
INSERT INTO spaonbv_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Moisés respondió que consultaría al Señor acerca de esta cuestión, ");
INSERT INTO spaonbv_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","y una vez hecho, la respuesta del Señor fue como sigue: ");
INSERT INTO spaonbv_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","«Si cualquier persona del pueblo de Israel, ya sea ahora o en las generaciones venideras, queda contaminada en la época de la Pascua a causa de haber tocado un cuerpo muerto, o si está de viaje y no puede estar presente, debe celebrar también la Pascua, pero un mes más tarde, ");
INSERT INTO spaonbv_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","el día catorce del segundo mes, por la noche. Deberá comer el cordero ese día, con pan sin levadura y hierbas amargas. ");
INSERT INTO spaonbv_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","No debe dejar ninguna sobra para la mañana siguiente, y tampoco debe romper ningún hueso del cordero, y debe seguir todas las instrucciones normales de la Pascua. ");
INSERT INTO spaonbv_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","»Pero cualquiera que no esté contaminado o no esté de viaje, y no obstante se oponga a celebrar la Pascua en la fecha establecida, será expulsado del pueblo de Israel por rehusar hacer el sacrificio en el momento debido; y responderá por su falta. ");
INSERT INTO spaonbv_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Y si un extranjero vive con ustedes y quiere celebrar la Pascua al Señor, seguirá las mismas instrucciones. Todos tienen la misma ley». ");
INSERT INTO spaonbv_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","El día en que se erigió el santuario, la nube lo cubrió; y por la noche la nube se transformó en fuego y se mantuvo así durante toda la noche. ");
INSERT INTO spaonbv_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Siempre sucedía así: la nube que lo cubría de día tomaba de noche aspecto de fuego. ");
INSERT INTO spaonbv_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Cuando la nube se levantaba, el pueblo de Israel la seguía hasta donde se detenía, y acampaba allí. ");
INSERT INTO spaonbv_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Por orden del Señor todo el pueblo viajaba y por orden del Señor se detenía y acampaba. ");
INSERT INTO spaonbv_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Si la nube se detenía por largo tiempo, todos los israelitas se quedaban por largo tiempo. Pero si se detenía tan sólo por unos días, ellos sólo se quedaban esos días, porque así lo había ordenado el Señor. ");
INSERT INTO spaonbv_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","21","A veces la nube de fuego se detenía tan sólo una noche, y a la mañana siguiente continuaba su marcha. Pero fuera de día o de noche cuando la nube se movía, el pueblo desmontaba el campamento y la seguía. ");
INSERT INTO spaonbv_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Si la nube permanecía sobre el santuario dos días, un mes o un año, ese era el tiempo que el pueblo de Israel se detenía; pero en cuanto se movía, ellos la seguían. ");
INSERT INTO spaonbv_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Resultaba así que acampaban o viajaban por orden del Señor; y cualquier cosa que el Señor le ordenaba a Moisés, lo hacían. ");
INSERT INTO spaonbv_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Luego el Señor le dijo a Moisés: ");
INSERT INTO spaonbv_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","«Haz dos trompetas de plata labrada para convocar a las asambleas del pueblo y para indicar el desmontaje del campamento. ");
INSERT INTO spaonbv_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Cuando suenen las dos trompetas, el pueblo entenderá que debe reunirse a la entrada del santuario. ");
INSERT INTO spaonbv_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Pero si sólo suena una trompeta, sólo comparecerán ante ti los jefes de las tribus de Israel. ");
INSERT INTO spaonbv_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","7","»Usarás distintos toques de trompeta para diferenciar la convocatoria a una asamblea y la orden de desmontar el campamento y emprender la marcha. Cuando suene la señal de partida, las tribus acampadas al este del santuario serán las primeras en salir. Y cuando suene la segunda señal marcharán las que están al sur. ");
INSERT INTO spaonbv_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Únicamente los sacerdotes podrán tocar las trompetas. Esto es una orden permanente que ha de obedecerse por todas las generaciones. ");
INSERT INTO spaonbv_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","»Cuando lleguen a la Tierra prometida y tengan que luchar contra sus enemigos, Dios los oirá y los salvará de ellos cuando den la alarma con estas trompetas. ");
INSERT INTO spaonbv_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Usen las trompetas en tiempo de alegría también, haciéndolas sonar en las fiestas anuales y al comienzo de cada mes, para alegrarse en las ofrendas totalmente ofrecidas a Dios y en las ofrendas de paz. Y yo me acordaré de ustedes. Pues yo soy el Señor, su Dios». ");
INSERT INTO spaonbv_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","La nube se levantó del santuario el día veinte del segundo mes del segundo año después de la salida de Israel de Egipto ");
INSERT INTO spaonbv_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","y los israelitas salieron del desierto de Sinaí y siguieron la nube hasta que esta se detuvo en el desierto de Parán. ");
INSERT INTO spaonbv_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Este fue su primer viaje después de que Moisés recibió las instrucciones del Señor. ");
INSERT INTO spaonbv_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Abriendo la marcha iba la tribu de Judá, agrupada detrás de su bandera, y conducida por Naasón, hijo de Aminadab. ");
INSERT INTO spaonbv_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","A continuación iban la tribu de Isacar, conducida por Natanael, hijo de Zuar, ");
INSERT INTO spaonbv_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","y la tribu de Zabulón, conducida por Eliab, hijo de Helón. ");
INSERT INTO spaonbv_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","El santuario fue desmontado y los hombres de Guersón y Merari, grupos de la tribu de Leví, se pusieron a continuación en la línea de marcha, llevando el santuario en los hombros. ");
INSERT INTO spaonbv_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","A continuación iba la bandera del campamento de Rubén, con Elisur hijo de Sedeúr a la cabeza. ");
INSERT INTO spaonbv_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Le seguían la tribu de Simeón, encabezada por Selumiel hijo de Zurisaday, ");
INSERT INTO spaonbv_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","y la tribu de Gad conducida por Eliasaf, hijo de Deuel. ");
INSERT INTO spaonbv_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Después seguían los coatitas, llevando los utensilios del Lugar Santísimo. (El santuario estaba ya montado en su nuevo emplazamiento cuando ellos llegaban). ");
INSERT INTO spaonbv_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","A continuación iba la tribu de Efraín tras su bandera, conducida por Elisama, hijo de Amiud, ");
INSERT INTO spaonbv_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","la tribu de Manasés conducida por Gamaliel hijo de Pedasur ");
INSERT INTO spaonbv_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","y la tribu de Benjamín conducida por Abidán hijo de Gedeoni. ");
INSERT INTO spaonbv_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","En último lugar marchaban las tribus encabezadas por la bandera de Dan, bajo la dirección de Ajiezer hijo de Amisaday, ");
INSERT INTO spaonbv_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","la tribu de Aser dirigida por Paguiel hijo de Ocrán, ");
INSERT INTO spaonbv_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","y la tribu de Neftalí conducida por Ajira, hijo de Enán. ");
INSERT INTO spaonbv_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Este era el orden en que marchaban las tribus. ");
INSERT INTO spaonbv_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Un día Moisés le dijo a su cuñado Hobab, hijo de Reuel, el madianita: ―Por fin estamos camino a la Tierra prometida. Ven con nosotros y te favoreceremos, pues el Señor ha hecho maravillosas promesas a Israel. ");
INSERT INTO spaonbv_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Pero su cuñado le respondió: ―¡Muchas gracias!, pero debo regresar a mi tierra, con mis parientes. ");
INSERT INTO spaonbv_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","―Quédate con nosotros —le rogó Moisés—, pues tú conoces los caminos del desierto y nos servirás de guía. ");
INSERT INTO spaonbv_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Si vienes, tendrás una parte de los bienes que Dios nos dará. ");
INSERT INTO spaonbv_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Tras dejar el monte Sinaí, viajaron tres días con el cofre al frente de la columna, para elegir lugar donde detenerse. ");
INSERT INTO spaonbv_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Cuando salieron era de día, y la nube iba delante de ellos mientras marchaban. ");
INSERT INTO spaonbv_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Cuando el cofre empezaba a moverse, Moisés exclamaba: «Levántate; oh Señor, y esparce a tus enemigos; que huyan delante de ti». ");
INSERT INTO spaonbv_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Y cuando el cofre se detenía, decía: «Vuelve, Oh Señor, a los miles de millares de Israel». ");
INSERT INTO spaonbv_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","El pueblo empezó pronto a quejarse, y el Señor lo oyó. Su furor se encendió contra ellos a causa de sus quejas, y el fuego del Señor empezó por destruir a los que se encontraban en uno de los extremos del campamento. ");
INSERT INTO spaonbv_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Entonces ellos clamaron a Moisés, y cuando este oró por ellos, el fuego se apagó. ");
INSERT INTO spaonbv_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Desde entonces aquel lugar se conoció con el nombre de Taberá (Incendio), porque el fuego del Señor ardió allí. ");
INSERT INTO spaonbv_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","5","El populacho que iban con ellos empezó a añorar las cosas buenas de Egipto. A esto se sumó el resto de los israelitas que, descontentos, empezaron a llorar diciendo: «¡Quién nos diera carne! ¡Ah, si tuviéramos un poco del delicioso pescado que comíamos gratis en Egipto, y pepinos, melones, puerros, cebollas y ajos! ");
INSERT INTO spaonbv_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Pero aquí estamos perdiendo las fuerzas, y todos los días tenemos que conformarnos con este maná». ");
INSERT INTO spaonbv_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Y era el maná del tamaño de una semilla de cilantro, y tenía el aspecto de gotas de resina de árbol. ");
INSERT INTO spaonbv_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","El pueblo lo recogía del suelo y lo machacaba para convertirlo en harina, lo hervía después y hacía tortas con él. Sabía a tortas fritas con aceite de oliva. ");
INSERT INTO spaonbv_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","El maná caía con el rocío de la noche. ");
INSERT INTO spaonbv_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Moisés oyó que las familias lloraban de pie delante de sus tiendas, y el furor del Señor se encendió. También Moisés se disgustó mucho, y ");
INSERT INTO spaonbv_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","le dijo al Señor: «¿Por qué me has elegido a mí para darme una carga semejante con este pueblo? ");
INSERT INTO spaonbv_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","¿Acaso son hijos míos? ¿Soy yo su padre para que me impongas el deber de criarlos como si fueran criaturas, hasta que lleguemos a la tierra que prometiste a sus antepasados? ");
INSERT INTO spaonbv_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","¿De dónde voy a sacar carne para toda esta gente? Porque me están llorando y diciendo: “¡Danos carne!”. ");
INSERT INTO spaonbv_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","¡Yo solo no puedo soportar a esta nación! ¡Es demasiada carga! ");
INSERT INTO spaonbv_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Si me vas a tratar así, mándame la muerte; me harías un favor. ¡Déjame salir de esta situación insoportable!». ");
INSERT INTO spaonbv_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Entonces el Señor le dijo a Moisés: ―Convócame a setenta dirigentes de Israel y reúnelos en el santuario para que se presenten contigo. ");
INSERT INTO spaonbv_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Yo descenderé y hablaré contigo allí, y tomaré del Espíritu que hay en ti y lo pondré también en ellos. Ellos te ayudarán a llevar la carga de modo que no tengas que hacer este trabajo solo. ");
INSERT INTO spaonbv_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","»Y dile a la gente que se purifique, porque mañana tendrán carne para comer. Diles: “El Señor ha oído sus lloriqueos por lo que han dejado en Egipto, y les va a dar carne. ");
INSERT INTO spaonbv_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Comerán carne no por un día ni dos, ni cinco ni diez ni veinte. ");
INSERT INTO spaonbv_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Durante un mes entero tendrán carne, hasta que la vomiten por las narices; porque han despreciado al Señor que está aquí entre ustedes y han suspirado por Egipto”». ");
INSERT INTO spaonbv_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Pero Moisés dijo: ―Sólo los hombres suman seiscientos mil (mujeres y niños aparte); ¡y a pesar de eso les prometes carne durante todo un mes! ");
INSERT INTO spaonbv_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","¡Aunque matáramos todos nuestros rebaños no tendríamos suficiente! ¡Habría que pescar todos los peces del mar para cumplir tu promesa! ");
INSERT INTO spaonbv_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Entonces el Señor dijo a Moisés: ―¿Cuándo he sido débil? ¡Ahora verás que mi palabra se cumple! ");
INSERT INTO spaonbv_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Y Moisés salió del santuario e informó al pueblo de las palabras del Señor; y reunió a los setenta ancianos y los situó en torno al santuario. ");
INSERT INTO spaonbv_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Y el Señor descendió en la nube y habló con Moisés, y tomó del Espíritu que había en Moisés y lo puso en los setenta ancianos; y cuando el Espíritu estuvo en ellos, profetizaron una sola vez. ");
INSERT INTO spaonbv_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Pero dos de aquellos setenta —Eldad y Medad— se habían quedado en el campamento, y cuando el Espíritu vino a ellos, profetizaron allí. ");
INSERT INTO spaonbv_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Un muchacho fue corriendo y le explicó a Moisés lo que estaba sucediendo, ");
INSERT INTO spaonbv_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","y Josué (hijo de Nun), uno de los ayudantes de Moisés, protestó: ―¡Moisés, hazles callar! ");
INSERT INTO spaonbv_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Pero Moisés le respondió: ―¿Tienes celos por mí? ¡Ojalá todo el pueblo de Dios fuera profeta, y el Señor pusiera su Espíritu sobre todos ellos! ");
INSERT INTO spaonbv_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Entonces Moisés regresó al campamento acompañado de los ancianos de Israel. ");
INSERT INTO spaonbv_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","El Señor envió un viento que arrastró codornices de la ribera del mar, y las dejó caer en el campamento y en todos sus alrededores. Había codornices en todas direcciones, a distancia de un día de camino, y hasta casi un metro de altura. ");
INSERT INTO spaonbv_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Así pues, el pueblo tomó y mató codornices durante todo el día y la noche, y todo el día siguiente. El que menos recogió, juntó diez montones, y algunos hasta las extendieron en el campo para secarlas. ");
INSERT INTO spaonbv_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Pero en cuanto empezaron a comer carne, la ira de Dios se levantó contra el pueblo, y mató a gran cantidad de ellos con una plaga. ");
INSERT INTO spaonbv_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Por esta razón aquel lugar fue llamado Quibrot Hatavá (Tumba de los codiciosos), porque allí enterraron a los que habían deseado la carne y el regreso a Egipto. ");
INSERT INTO spaonbv_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Y desde aquel lugar se trasladaron a Jazerot, y se quedaron allí una temporada. ");
INSERT INTO spaonbv_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Un día Miriam y Aarón se pusieron a criticar a Moisés porque su mujer era una cusita, ");
INSERT INTO spaonbv_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","y dijeron: ―¡El Señor no ha hablado sólo por medio de Moisés! ¡También ha hablado por medio de nosotros dos! Pero el Señor los oyó ");
INSERT INTO spaonbv_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","4","y no le gustó el comentario de ambos, porque Moisés era el hombre más humilde del mundo, e inmediatamente convocó a Moisés, a Aarón y a Miriam al santuario: ―Vengan aquí los tres —ordenó. Entonces se presentaron ante el Señor. ");
INSERT INTO spaonbv_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","De inmediato el Señor descendió en la nube y se situó a la entrada del santuario, y les ordenó a Miriam y Aarón que se acercaran. Y ellos lo hicieron. ");
INSERT INTO spaonbv_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","El Señor les dijo: ―Hasta con un profeta me comunicaría con visiones y sueños; ");
INSERT INTO spaonbv_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","pero no es así como me comunico con mi siervo Moisés. ¡Él es completamente fiel en toda mi casa! ");
INSERT INTO spaonbv_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","¡Con él hablo cara a cara! ¡Y él ve la mismísima apariencia de Dios! ¿Cómo es que se han atrevido a criticarlo? ");
INSERT INTO spaonbv_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Entonces la ira del Señor se encendió contra ellos, y Dios se apartó. ");
INSERT INTO spaonbv_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","En el momento en que la nube se alejó de encima del santuario, Miriam quedó de repente blanca por la lepra. Aarón vio lo ocurrido, ");
INSERT INTO spaonbv_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","y le dijo a Moisés: ―Señor, no nos castigues por este pecado; hemos sido necios al hacerlo. ");
INSERT INTO spaonbv_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Que no quede ella como quien ha muerto desde antes de nacer. ");
INSERT INTO spaonbv_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Moisés clamó al Señor diciendo: ―Sánala, oh Dios, te lo ruego. ");
INSERT INTO spaonbv_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Y el Señor le dijo a Moisés: ―Si su padre le hubiera escupido el rostro, ella habría quedado impura durante siete días. Que quede fuera del campamento por siete días, y después podrá regresar. ");
INSERT INTO spaonbv_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Entonces Miriam fue expulsada del campamento por siete días, y el pueblo esperó hasta que ella regresara antes de continuar el viaje. ");
INSERT INTO spaonbv_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Después salieron de Jazerot y acamparon en el desierto de Parán. ");
INSERT INTO spaonbv_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Un día el Señor le ordenó a Moisés: ");
INSERT INTO spaonbv_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","«Envía espías a la tierra de Canaán; la tierra que le voy a dar a Israel. Envía uno de cada tribu». ");
INSERT INTO spaonbv_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","15","Moisés hizo lo que el Señor le había ordenado y envió desde el desierto de Parán a las siguientes personas, una por cada tribu: Samúa, hijo de Zacur, de la tribu de Rubén; Safat, hijo de Horí, de la tribu de Simeón; Caleb, hijo de Jefone, de la tribu de Judá; Igal, hijo de José, de la tribu de Isacar; Oseas, hijo de Nun, de la tribu de Efraín; Palti, hijo de Rafú, de la tribu de Benjamín; Gadiel, hijo de Sodi de la tribu de Zabulón; Gadí, hijo de Susi, de la tribu de José (realmente era parte de la tribu de Manasés); Amiel, hijo de Gemalí, de la tribu de Dan; Setur, hijo de Micael, de la tribu de Aser Najbi, hijo de Vapsi, de la tribu de Neftalí; Geuel, hijo de Maquí, de la tribu de Gad. ");
INSERT INTO spaonbv_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","En esta ocasión Moisés le cambió el nombre a Oseas (Salvación) y le puso Josué (el Señor es salvación). ");
INSERT INTO spaonbv_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Moisés los envió en su misión de exploración diciéndoles: ―Vayan hacia el norte, hacia el Néguev, y suban las montañas; ");
INSERT INTO spaonbv_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","y observen qué tal es la tierra; fíjense, además, cómo es el pueblo que vive allí, si son fuertes o débiles; pocos o muchos; ");
INSERT INTO spaonbv_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","si la tierra es fértil o no, y qué clase de ciudades son, si son pueblos sin muros o si son ciudades fortificadas; ");
INSERT INTO spaonbv_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","si la tierra es rica o pobre, y si hay árboles. No teman, y cuando regresen traigan algunas muestras de los frutos que vean. (Era la época en que comenzaba la vendimia). ");
INSERT INTO spaonbv_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Ellos fueron y exploraron la tierra de Canaán desde el desierto de Zin hasta Rejob y Jamat. ");
INSERT INTO spaonbv_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Yendo hacia el norte, atravesaron el Néguev y llegaron a Hebrón. Allí vieron a los descendientes de Ajimán, de Sesay y de Talmay, descendientes de Anac. (Hebrón era muy antigua, y había sido fundada siete años antes que Zoán, en Egipto). ");
INSERT INTO spaonbv_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Luego llegaron a lo que se conoce ahora como valle de Escol donde cortaron un racimo de uvas tan grande que fue necesario transportarlo en un palo cargado por dos hombres. También llevaron algunas muestras de granadas e higos. ");
INSERT INTO spaonbv_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Los israelitas llamaron al valle Escol (Racimo) por el racimo que allí encontraron. ");
INSERT INTO spaonbv_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Cuarenta días después regresaron de su expedición. ");
INSERT INTO spaonbv_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Informaron a Moisés, a Aarón y a todo el pueblo de Israel en el desierto de Parán, en Cades, y les mostraron el fruto de la tierra que habían traído consigo. ");
INSERT INTO spaonbv_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Este fue su informe: ―Llegamos a la tierra que ustedes nos enviaron a explorar, y encontramos que es una tierra excelente de la que realmente fluye leche y miel. Hemos traído estos frutos como muestra. ");
INSERT INTO spaonbv_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Pero el pueblo que vive en ella es poderoso, sus ciudades están fortificadas y son grandes y, lo que es peor, hemos visto gigantes descendientes de Anac en aquellos lugares. ");
INSERT INTO spaonbv_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Los amalecitas viven en el sur, mientras que en los montes hay heteos, jebuseos y amorreos. A lo largo de la costa del Mediterráneo y en el valle del Jordán están los cananeos. ");
INSERT INTO spaonbv_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Sin embargo, Caleb animó al pueblo delante de Moisés. ―Subamos inmediatamente y tomemos posesión de la tierra —dijo— porque podemos conquistarla. ");
INSERT INTO spaonbv_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","―No podremos luchar contra un pueblo tan poderoso —respondieron los otros espías. ");
INSERT INTO spaonbv_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","De modo que el informe de la mayoría de los exploradores fue negativo: ―La tierra está llena de guerreros, los pueblos que la habitan son poderosos, ");
INSERT INTO spaonbv_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","y vimos gigantes descendientes de Anac. Eran tan grandes que parecíamos langostas al lado de ellos. ");
INSERT INTO spaonbv_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Entonces el pueblo comenzó a llorar en alta voz y se pasaron la noche llorando. ");
INSERT INTO spaonbv_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Elevaron sus voces como un gran coro de quejas en contra de Moisés y Aarón. «Preferiríamos haber muerto en Egipto —se quejaban— o aun aquí en el desierto, ");
INSERT INTO spaonbv_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","antes que entrar a ese país que tenemos ante nosotros. El Señor permitirá que nos maten allí y nuestras esposas e hijos serán esclavos. Regresemos a Egipto». ");
INSERT INTO spaonbv_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","La idea corrió por el campamento: «Elijamos a un caudillo y regresemos a Egipto». ");
INSERT INTO spaonbv_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Entonces Moisés y Aarón se postraron en tierra delante del pueblo de Israel; ");
INSERT INTO spaonbv_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","dos de los espías, Josué hijo de Nun y Caleb, hijo de Jefone, rasgaron su ropa ");
INSERT INTO spaonbv_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","y le dijeron al pueblo: ―Tenemos un país maravilloso por delante ");
INSERT INTO spaonbv_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","y el Señor nos ama. Él hará que entremos sanos y salvos en la tierra y nos la entregará. Es una tierra muy fértil, una tierra de la que verdaderamente fluye leche y miel. ");
INSERT INTO spaonbv_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","No se rebelen contra el Señor y no teman al pueblo que habita en aquella tierra. Los venceremos fácilmente. El Señor está con nosotros y se ha apartado de ellos. No teman. ");
INSERT INTO spaonbv_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Como respuesta, todo el pueblo se dispuso apedrearlos. Pero la gloria del Señor apareció ante ellos, ");
INSERT INTO spaonbv_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","y el Señor le dijo a Moisés: ―¿Hasta cuando me despreciará este pueblo? ¿Es que nunca me creerán aun después de todos los milagros que he hecho entre ellos? ");
INSERT INTO spaonbv_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Los desheredaré y los destruiré con una plaga, y de ti haré una nación mucho más poderosa que ellos. ");
INSERT INTO spaonbv_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","―Pero, ¿qué pensarán los egipcios cuando oigan acerca de esto? —le respondió Moisés al Señor—. Ellos saben bien la demostración de poder que hiciste al rescatar a tu pueblo. ");
INSERT INTO spaonbv_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Lo han contado a los habitantes de esta tierra, que saben bien que tú estás con Israel y que tú hablas con Israel cara a cara. Ellos ven la columna de nube y fuego que está sobre nosotros, y saben que tú nos diriges y nos proteges día y noche. ");
INSERT INTO spaonbv_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Si matas a este pueblo, las naciones que habrán oído de tu fama dirán: ");
INSERT INTO spaonbv_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","“El Señor les ha dado muerte porque no tuvo suficiente poder para introducirlos en la tierra que juró que les daría”. ");
INSERT INTO spaonbv_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","»Oh Señor, muestra tu gran poder, ");
INSERT INTO spaonbv_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","misericordia y gran paciencia perdonando nuestros pecados. Perdónanos aun cuando dijiste que no dejarías pecado sin castigo, y que castigas las faltas del padre en los hijos hasta la tercera y cuarta generación. ");
INSERT INTO spaonbv_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Perdona los pecados de este pueblo por tu amor magnífico, así como muchas veces los has perdonado desde que salimos de Egipto». ");
INSERT INTO spaonbv_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","―Bien, los perdonaré de la manera que me has pedido —respondió el Señor—. ");
INSERT INTO spaonbv_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Pero juro por mi propio nombre que, así como la tierra está llena de mi gloria, ");
INSERT INTO spaonbv_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","ninguno de los hombres que vieron mi gloria y los milagros que hice en Egipto y en el desierto (y diez veces se negaron a confiar en mí y a obedecerme) ");
INSERT INTO spaonbv_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","verá la tierra que les prometí a sus antepasados. ");
INSERT INTO spaonbv_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Pero mi siervo Caleb es diferente: me ha obedecido en todo. Lo haré entrar en la tierra donde ya ha estado, y sus descendientes poseerán una buena parte de ella. ");
INSERT INTO spaonbv_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Pero ahora, puesto que el pueblo de Israel teme a los amalecitas y a los cananeos que viven en los valles, mañana regresarán al desierto en dirección al Mar Rojo. ");
INSERT INTO spaonbv_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Entonces el Señor les dijo a Moisés y a Aarón: ");
INSERT INTO spaonbv_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","―¿Hasta cuando se quejará de mí este pueblo perverso? ");
INSERT INTO spaonbv_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Dile: “El Señor promete concederles lo que acaban de pedir. ");
INSERT INTO spaonbv_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Morirán todos en el desierto. Ninguno que tenga más de veinte años y se haya quejado contra mí ");
INSERT INTO spaonbv_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","entrará en la Tierra prometida. Sólo Caleb, hijo de Jefone, y Josué, hijo de Nun podrán entrar. ");
INSERT INTO spaonbv_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Ustedes dijeron que sus hijos serían esclavos del pueblo de esa tierra. Pues no. Al contrario, los haré vivir tranquilos en la tierra y heredarán lo que ustedes han despreciado. ");
INSERT INTO spaonbv_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","En cuanto a ustedes, sus cadáveres quedarán en el desierto. ");
INSERT INTO spaonbv_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Hasta que no muera el último de ustedes en el desierto, sus hijos vagarán por él como nómadas durante cuarenta años. De esta manera ustedes pagarán por su falta de fe. ");
INSERT INTO spaonbv_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Por cuanto los espías estuvieron cuarenta días en la tierra, ustedes vagarán en el desierto durante cuarenta años, un año por cada día, llevando la carga de sus pecados. Les enseñaré cada día lo que significa rechazarme”. ");
INSERT INTO spaonbv_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Yo el Señor he hablado. Cada uno de ustedes que haya conspirado en mi contra morirá en este desierto. ");
INSERT INTO spaonbv_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","38","Los diez espías que habían incitado la rebelión contra el Señor y habían llenado de temor los corazones del pueblo fueron los primeros en morir delante del Señor. Josué y Caleb fueron los únicos que quedaron con vida. ");
INSERT INTO spaonbv_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Y hubo llanto en el campamento cuando Moisés les informó lo que el Señor le había dicho. ");
INSERT INTO spaonbv_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","A la mañana siguiente los israelitas se levantaron muy temprano y comenzaron a avanzar hacia la Tierra prometida. ―Comprendemos que hemos pecado —dijeron—, pero ahora estamos dispuestos a entrar en la tierra que el Señor nos ha prometido. ");
INSERT INTO spaonbv_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","―Es demasiado tarde —les respondió Moisés—. Ahora están desobedeciendo las órdenes del Señor de regresar al desierto. ");
INSERT INTO spaonbv_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","No sigan con ese plan o serán derrotados por sus enemigos, porque el Señor no irá con ustedes. ");
INSERT INTO spaonbv_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","¿No recuerdan? ¡Allí están los amalecitas y los cananeos! Ustedes se han apartado del Señor y ahora él se apartará de ustedes. ");
INSERT INTO spaonbv_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Pero ellos avanzaron hacia las montañas a pesar de que ni el cofre ni Moisés salieron con ellos del campamento. ");
INSERT INTO spaonbv_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Entonces los amalecitas y los cananeos que vivían en las montañas cayeron sobre ellos y los atacaron y los persiguieron hasta el pueblo de Jormá donde los derrotaron totalmente. ");
INSERT INTO spaonbv_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","El Señor habló con Moisés y le dio las siguientes órdenes para el pueblo de Israel: ");
INSERT INTO spaonbv_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","«Cuando los hijos de ustedes estén en la tierra que les voy a dar ");
INSERT INTO spaonbv_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","y quieran agradar al Señor con una ofrenda quemada por completo u otro tipo de ofrenda, ofrecerán un animal de sus rebaños de ovejas, cabras o vacas. Cada sacrificio, sea ordinario o para cumplir un voto, sea una ofrenda voluntaria o un sacrificio especial en una de las festividades anuales, será acompañado de una ofrenda de grano. ");
INSERT INTO spaonbv_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Si lo que se sacrifica es un cordero, se usarán dos kilos y medio de harina fina mezclada con un litro de aceite, ");
INSERT INTO spaonbv_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","y acompañada por un litro de vino para la libación. ");
INSERT INTO spaonbv_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","»Si el sacrificio es un carnero, usará cinco kilos de harina fina mezclada con un litro y tercio de aceite, ");
INSERT INTO spaonbv_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","y un litro y tercio de vino para la libación. Este será un sacrificio de olor grato delante del Señor. ");
INSERT INTO spaonbv_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","9","»Si el sacrificio es un becerro, la ofrenda de grano que lo acompaña será de siete kilos de harina fina mezclada con dos litros de aceite, ");
INSERT INTO spaonbv_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","más dos litros de vino para la libación. Esto será presentado como ofrenda encendida de olor grato delante del Señor. ");
INSERT INTO spaonbv_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","12","»Estas son las instrucciones sobre lo que debe ir junto a cada sacrificio sea de becerro, cordero o cabrito. ");
INSERT INTO spaonbv_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","14","Estas instrucciones deben seguirlas los israelitas nativos y los extranjeros que vivan entre ellos y deseen agradar al Señor con sacrificio u ofrendas encendidas. ");
INSERT INTO spaonbv_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","16","Esta misma ley rige para todos, israelitas o extranjeros, y tendrá vigencia de generación en generación para siempre. Todos son iguales delante del Señor. La misma ley regirá para todos». ");
INSERT INTO spaonbv_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","El Señor también dijo a Moisés en este tiempo: ");
INSERT INTO spaonbv_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","«Dile al pueblo de Israel que cuando hayan entrado en la tierra que les voy a dar, ");
INSERT INTO spaonbv_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","21","deben ofrecer al Señor las primicias de la nueva cosecha presentándole un pan de harina gruesa cada año. Este pan será ofrecido al Señor, anualmente, de generación en generación. ");
INSERT INTO spaonbv_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","23","»Si por error tú o las generaciones futuras no cumplen con todas las reglas que el Señor les ha dado a través de los años por medio de Moisés, ");
INSERT INTO spaonbv_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","el pueblo debe ofrecer un becerro como ofrenda totalmente quemada al comprender el error. Será de olor grato delante del Señor, y será sacrificado con la ofrenda de grano y la libación acostumbradas, y un chivo como ofrenda por el pecado. ");
INSERT INTO spaonbv_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","El sacerdote hará esa ofrenda por el perdón de todo el pueblo de Israel y así quedarán libres de culpa. Era un error y lo han corregido con la ofrenda encendida al Señor y con su ofrenda por el pecado. ");
INSERT INTO spaonbv_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Todo el pueblo será perdonado, así como los extranjeros que vivan entre ellos, porque toda la población cayó en el error y será perdonada juntamente. ");
INSERT INTO spaonbv_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","»Si el error lo cometió un individuo, ofrecerá una cabra de un año como ofrenda por el pecado, ");
INSERT INTO spaonbv_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","y el sacerdote hará la ofrenda por el pecado, en su nombre, delante del Señor y será perdonado. ");
INSERT INTO spaonbv_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Esta misma ley se aplica a los israelitas y a los extranjeros que viven entre ustedes. ");
INSERT INTO spaonbv_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","»Pero si alguien deliberadamente comete un pecado, sea israelita o extranjero, está blasfemando contra el Señor y será cortado de en medio de su pueblo. ");
INSERT INTO spaonbv_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Ha despreciado el mandamiento del Señor y deliberadamente ha dejado de obedecer su ley. Deberá ser ejecutado a causa de su pecado». ");
INSERT INTO spaonbv_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Un día, estando el pueblo de Israel en el desierto, uno de ellos fue sorprendido recogiendo leña en el día de reposo. ");
INSERT INTO spaonbv_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Fue arrestado y llevado delante de Moisés, Aarón y los demás jueces. ");
INSERT INTO spaonbv_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Lo encerraron hasta que pudiesen saber con respecto a este caso. ");
INSERT INTO spaonbv_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Entonces el Señor le dijo a Moisés: «Ese hombre debe morir. Todo el pueblo lo apedreará fuera del campamento hasta darle muerte». ");
INSERT INTO spaonbv_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Entonces lo llevaron fuera del campamento y le dieron muerte de la manera que el Señor lo había ordenado. ");
INSERT INTO spaonbv_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","El Señor le dijo a Moisés: ");
INSERT INTO spaonbv_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","«Dile al pueblo de Israel que hagan flecos para ponerlos en los bordes de sus vestiduras (esta es una regla permanente de generación en generación) y que cosan los flecos con un hilo azul. ");
INSERT INTO spaonbv_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","El propósito de esta regla es recordarles los mandamientos del Señor cada vez que vean los flecos, y para que obedezcan sus leyes en vez de seguir sus propios deseos y de andar en sus propios caminos como lo hacían cuando servían a otros dioses. ");
INSERT INTO spaonbv_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Les recordará que deben ser santos para Dios. ");
INSERT INTO spaonbv_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Porque yo soy el Señor, que los saqué de la tierra de Egipto. Sí; yo soy el Señor su Dios». ");
INSERT INTO spaonbv_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Un día Coré (hijo de Izhar, nieto de Coat y descendiente de Leví) conspiró con Datán y Abirán (hijos de Eliab), y con On (hijo de Pélet). La intención de los tres, que por cierto pertenecían a la tribu de Rubén, ");
INSERT INTO spaonbv_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","era incitar al pueblo a una rebelión contra Moisés. En dicha rebelión participaron doscientos cincuenta varones, todos miembros principales del consejo y personas de renombre en el pueblo. ");
INSERT INTO spaonbv_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Se presentaron delante de Moisés y Aarón y les dijeron: ―Ya los hemos soportado bastante. Ustedes no son mejores que los demás. Todo israelita es un escogido del Señor, y él está con nosotros: ¿Qué derecho tienen ustedes de ponerse en puestos de mando y de demandar que les obedezcamos, y de actuar como si fueran superiores a los demás israelitas? ");
INSERT INTO spaonbv_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Cuando Moisés oyó aquello se postró rostro en tierra, ");
INSERT INTO spaonbv_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","y dijo a Coré y a los que estaban con él: ―Mañana el Señor mostrará quiénes son los suyos, quién es santo y a quién ha escogido como sacerdote. ");
INSERT INTO spaonbv_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Hagan esto: Coré, tú y todos los que están contigo tomen incensarios mañana, ");
INSERT INTO spaonbv_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","enciéndanlos y pongan incienso en ellos delante del Señor, y así sabremos a quién ha escogido el Señor. Ustedes, hijos de Leví, son los presuntuosos. ");
INSERT INTO spaonbv_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Luego Moisés añadió: ");
INSERT INTO spaonbv_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","―¿Te parece poco, Coré, que el Dios de Israel te haya escogido de entre todo el pueblo de Israel para estar junto a él mientras haces tus trabajos en el santuario del Señor, y que puedas presentarte delante del pueblo para ministrar en su favor? ");
INSERT INTO spaonbv_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","¿Es poco para ti que él haya dado esta tarea exclusivamente a ustedes los levitas? ¿Y ahora quieren también el sacerdocio? ");
INSERT INTO spaonbv_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Esto es lo que realmente están buscando. Por eso es que se rebelan en contra del Señor. ¿Y qué ha hecho Aarón para que estén disconformes con él? ");
INSERT INTO spaonbv_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Entonces Moisés llamó a Datán y a Abirán (los hijos de Eliab), pero ellos se negaron a acudir: ");
INSERT INTO spaonbv_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","―¿Es poco —dijeron burlonamente— que nos haya sacado de Egipto, tierra que fluye leche y miel, para hacernos morir en este desierto terrible? ¡Y ahora quieres convertirte en nuestro rey! ");
INSERT INTO spaonbv_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Y por si eso fuera poco, no nos has hecho entrar en el país maravilloso que prometiste, ni nos has dado campos y viñas. ¿A quién estas tratando de engañar? No queremos ir. ");
INSERT INTO spaonbv_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Entonces Moisés se airó y le dijo al Señor: ―No aceptes sus sacrificios. Ni aun un burro he tomado de ellos, ni les he causado daño alguno. ");
INSERT INTO spaonbv_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Y Moisés le dijo a Coré: ―Preséntate mañana delante del Señor con todos tus amigos. Aarón también estará aquí. ");
INSERT INTO spaonbv_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Traigan incensarios con incienso. Un incensario para cada hombre, doscientos cincuenta en total. También Aarón estará aquí con el suyo. ");
INSERT INTO spaonbv_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Y así lo hicieron. Acudieron con sus incensarios, los encendieron; pusieron incienso en ellos y estuvieron a la entrada del santuario con Moisés y Aarón. ");
INSERT INTO spaonbv_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Mientras tanto, Coré había incitado a toda la nación contra Moisés y Aarón, y todos se reunieron a observar. Entonces la gloria del Señor apareció ante todo el pueblo, ");
INSERT INTO spaonbv_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","y el Señor les dijo a Moisés y a Aarón: ");
INSERT INTO spaonbv_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","―Apártense de este pueblo, que voy a destruirlo inmediatamente. ");
INSERT INTO spaonbv_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Pero Moisés y Aarón se postraron en tierra, delante del Señor: ―Oh Dios, Dios de toda la humanidad, ¿has de enojarte con toda el pueblo cuando es un solo hombre el que ha pecado? ");
INSERT INTO spaonbv_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Y el Señor le dijo a Moisés: ");
INSERT INTO spaonbv_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","―Entonces dile al pueblo que se aparte de las tiendas de Coré, Datán y Abirán. ");
INSERT INTO spaonbv_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Moisés corrió a las tiendas de Datán y Abirán seguido muy de cerca por los doscientos cincuenta jefes israelitas. ");
INSERT INTO spaonbv_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","―Vamos, rápido —le dijo al pueblo—, apártense de las tiendas de estos hombres inicuos, y no toquen nada que pertenezca a ellos, o serán ustedes incluidos en su pecado y serán destruidos con ellos. ");
INSERT INTO spaonbv_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Entonces todo el pueblo se apartó de las tiendas de Coré, Datán y Abirán. Datán y Abirán salieron y se pusieron a la puerta de sus tiendas con sus esposas, hijos e hijas. ");
INSERT INTO spaonbv_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Y Moisés dijo: ―Ahora se sabrá si el Señor me ha enviado o no a hacer todas las cosas que he hecho, o si he actuado por mi iniciativa. ");
INSERT INTO spaonbv_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Si estos hombres mueren en forma natural; de algún accidente o enfermedad común, el Señor no me ha enviado. ");
INSERT INTO spaonbv_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Pero si el Señor hace un milagro y la tierra se abre y se los traga juntamente con todo lo que les pertenece, y entran vivos en el Seol entonces se sabrá que estos hombres han despreciado al Señor. ");
INSERT INTO spaonbv_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Apenas había acabado de decir estas palabras; cuando la tierra se abrió debajo de los rebeldes, ");
INSERT INTO spaonbv_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","y una gran grieta se los tragó junto con sus tiendas; familias y amigos que estaban con ellos y con todo lo que poseían. ");
INSERT INTO spaonbv_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","De esta manera entraron vivos en el Seol y la tierra se cerró sobre ellas y perecieron. ");
INSERT INTO spaonbv_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Todo el pueblo de Israel huyó gimiendo, temeroso de que la tierra también se los tragara a ellos. ");
INSERT INTO spaonbv_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Enseguida descendió fuego del Señor y quemó a los doscientos cincuenta hombres que estaban ofreciéndole incienso. ");
INSERT INTO spaonbv_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Y el Señor le dijo a Moisés: ");
INSERT INTO spaonbv_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","―Dile a Eleazar el hijo de Aarón el sacerdote que retire del fuego los incensarios porque son sagrados, dedicados al Señor. Además debes apagar el fuego ");
INSERT INTO spaonbv_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","de los incensarios de estos hombres que han pecado y les ha costado la vida. ");
INSERT INTO spaonbv_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Con sus incensarios harán planchas de metal para cubrir el altar, ");
INSERT INTO spaonbv_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","a fin de que sirva de recordatorio al pueblo de Israel de que ninguna persona no autorizada, esto es, que no sea descendiente de Aarón; puede venir delante del Señor a quemar el incienso; porque le ocurrirá lo mismo que le pasó a Coré y sus aliados. Estas órdenes del Señor dadas a Moisés fueron cumplidas al pie de la letra. ");
INSERT INTO spaonbv_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Pero a la mañana siguiente, todo el pueblo comenzó a murmurar contra Moisés y Aarón diciendo: ―Tú has dado muerte al pueblo de el Señor. ");
INSERT INTO spaonbv_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","No tardó en formarse un gran tumulto. Pero repentinamente, mientras se dirigían hacia el santuario, la nube se apareció y se vio la gran gloria del Señor. ");
INSERT INTO spaonbv_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Moisés y Aarón se pararon a la entrada del santuario ");
INSERT INTO spaonbv_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","y el Señor le dijo a Moisés: ");
INSERT INTO spaonbv_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","―Apártate de este pueblo, para que pueda destruirlo instantáneamente. Pero Moisés y Aarón se postraron en tierra delante del Señor. ");
INSERT INTO spaonbv_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Y Moisés le dijo a Aarón: ―Rápido, toma un incensario y ponle fuego del altar, coloca incienso y llévalo en medio del pueblo y haz el rito de reparación por ellos, porque la ira del Señor se ha encendido en su contra y una plaga ya ha comenzado. ");
INSERT INTO spaonbv_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Aarón hizo todo lo que Moisés le había ordenado, y corrió por en medio del pueblo, porque la plaga ya había comenzado; y puso incienso en el incensario e hizo la ofrenda de perdón de pecados por ellos. ");
INSERT INTO spaonbv_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Y se paró entre los vivos y los muertos y la plaga se detuvo. ");
INSERT INTO spaonbv_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Pero alcanzaron a morir catorce mil setecientas personas (además de los que habían muerto el día anterior con Coré). ");
INSERT INTO spaonbv_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Entonces Aarón regresó a reunirse con Moisés a la entrada del santuario; de esta manera se detuvo la plaga. ");
INSERT INTO spaonbv_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Entonces el Señor le dijo a Moisés: ");
INSERT INTO spaonbv_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","«Dile al pueblo de Israel que cada uno de los jefes de sus tribus debe presentarse con una vara de árbol con su nombre escrito en ella. ");
INSERT INTO spaonbv_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","El nombre de Aarón estará en la vara de la tribu de Leví. ");
INSERT INTO spaonbv_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","»Pon estas varas en el Lugar Santísimo del santuario, donde yo me encuentro con ustedes, en frente del cofre. ");
INSERT INTO spaonbv_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Yo usaré estas varas para identificar al hombre que he escogido pues la vara del escogido florecerá. Así se acabarán las murmuraciones y quejas en contra tuya». ");
INSERT INTO spaonbv_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Entonces Moisés dio estas instrucciones al pueblo, y cada uno de los jefes de las doce tribus (incluyendo a Aarón) le trajo una vara. ");
INSERT INTO spaonbv_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Las puso delante del Señor en la sala interior del santuario, ");
INSERT INTO spaonbv_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","y cuando entró al día siguiente, halló que la vara de Aarón, que representaba a la tribu de Leví, había reverdecido y florecido, y hasta tenía almendras. ");
INSERT INTO spaonbv_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Cuando Moisés sacó todas las varas delante del Señor, todos los israelitas las pudieron ver, y cada jefe se llevó su propia vara. ");
INSERT INTO spaonbv_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Y el Señor le dijo a Moisés: «Coloca la vara de Aarón dentro del cofre como advertencia a los rebeldes. De esta manera detendrás las protestas de la gente y evitarás que mueran». ");
INSERT INTO spaonbv_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Así lo hizo Moisés, conforme al mandato del Señor. ");
INSERT INTO spaonbv_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","13","Pero el pueblo de Israel volvió a quejarse una vez más: «¡Estamos perdidos! —se lamentaron—. Cada persona que se acerca al santuario muere. ¿Es que vamos a morir todos?». ");
INSERT INTO spaonbv_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","El Señor le dijo a Aarón: «Tú y tus hijos, y tu familia responderán por cualquier profanación del santuario, y por cualquier conducta impropia durante el servicio sacerdotal. ");
INSERT INTO spaonbv_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","3","Tus hermanos, los de la tribu de Leví, son tus ayudantes. Pero solamente tú y tus hijos pueden desarrollar los ritos sagrados en el santuario mismo. Los levitas tendrán mucho cuidado de no tocar los objetos sagrados del altar, pues podría destruirlos a ellos y a ti. ");
INSERT INTO spaonbv_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Nadie que no sea miembro de la tribu de Leví puede ayudarte. ");
INSERT INTO spaonbv_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","»Recuerda, sólo los sacerdotes deben realizar los deberes sagrados dentro del santuario y en el altar. Si sigues estas instrucciones, jamás caerá la ira de Dios sobre el pueblo de Israel por violar sus leyes. ");
INSERT INTO spaonbv_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Repito: tus parientes los levitas son tus ayudantes en las tareas del santuario. Ellos son un don de Dios para ti. ");
INSERT INTO spaonbv_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Pero tú, y tus hijos, personalmente llevarán a cabo el servicio sagrado incluyendo el del altar y todo lo que está dentro de la cortina, porque el sacerdocio es una tarea especial que Dios ha puesto en tus manos. Cualquier persona que trate de realizar estos deberes sin ser de tus descendientes morirá». ");
INSERT INTO spaonbv_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Además el Señor le dio estas órdenes a Aarón: «He cedido a los sacerdotes todos los presentes que se ofrecen al Señor; todas las ofrendas que se presentan al Señor meciéndolas delante del altar te pertenecen a ti y a tus hijos por norma permanente. ");
INSERT INTO spaonbv_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Las ofrendas de grano, las ofrendas por el pecado y las ofrendas por la culpa son tuyas, salvo el puñado que se presenta al Señor quemándolo sobre el altar. Estas son ofrendas muy sagradas. ");
INSERT INTO spaonbv_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Sólo podrán comerse en el santuario, y solamente comerán de ella los varones. ");
INSERT INTO spaonbv_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","»Todas las otras ofrendas que se me ofrecen mecidas delante del altar son para ti y para tu familia, hijos e hijas por igual. Todos los miembros de tu familia pueden comerlas salvo alguno que esté ceremonialmente impuro en el momento de la comida. ");
INSERT INTO spaonbv_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","»También son tuyos los primeros frutos de la cosecha que el pueblo trae para ofrecer al Señor: lo mejor del aceite de oliva, del grano ");
INSERT INTO spaonbv_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","y de toda otra cosecha. Tu familia puede comer todas estas ofrendas, menos el que se encuentre ceremonialmente impuro. ");
INSERT INTO spaonbv_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","15","»Todo lo que haya sido dedicado al Señor será de ustedes, incluyendo a los primogénitos del pueblo de Israel, y el primogénito de sus animales. ");
INSERT INTO spaonbv_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Sin embargo, no podrás aceptar a los hijos primogénitos, ni los primogénitos de los animales que no se pueden comer. Pero tendrán que redimirlos pagando sesenta gramos de plata por cada hijo primogénito. Esto tiene que ser pagado cuando cumpla un mes de edad. ");
INSERT INTO spaonbv_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","»Sin embargo, los primogénitos de vacas, ovejas o cabras no podrán ser redimidos porque serán sacrificados al Señor. Su sangre será rociada sobre el altar y se hará arder su grasa sobre el altar como ofrenda encendida de olor muy agradable delante del Señor. ");
INSERT INTO spaonbv_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","La carne de estos animales será tuya, incluyendo el pecho y la pierna derecha, que son presentados meciéndolos delante del altar: ");
INSERT INTO spaonbv_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Sí, yo te he dado todas estas “ofrendas mecidas” que los israelitas presentan al Señor. Son para que tú y tu familia las coman. Este es un convenio permanente entre el Señor, tú y tus descendientes. ");
INSERT INTO spaonbv_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","»Los sacerdotes no podrán poseer tierras ni tener otros ingresos, porque el tenerme a mí les será suficiente. ");
INSERT INTO spaonbv_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","En cuanto a los de la tribu de Leví, familiares de ustedes, recibirán pago por el servicio prestado mediante los diezmos de toda la tierra de Israel. ");
INSERT INTO spaonbv_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","»De ahora en adelante no podrán entrar en el santuario los israelitas que no sean sacerdotes o levitas. Los que lo hagan serán castigados y morirán. ");
INSERT INTO spaonbv_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Solamente los levitas harán trabajos allí; y si no lo hacen serán considerados culpables y ellos serán responsables de las faltas que cometan. Es ley permanente que los levitas no tengan propiedad en Israel. ");
INSERT INTO spaonbv_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Porque los diezmos que el pueblo ofrezca al Señor mecidos delante del altar pertenecerán a los levitas. Esta es la heredad de ellos, y por lo tanto no tienen necesidad de propiedades». ");
INSERT INTO spaonbv_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","El Señor también le dijo a Moisés: ");
INSERT INTO spaonbv_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","«Dile a los levitas que den al Señor el diezmo de los diezmos que reciban. ");
INSERT INTO spaonbv_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","El Señor lo recibirá como si fuera primicia de grano, vino, productos de la propiedad de ellos. ");
INSERT INTO spaonbv_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","29","Este diezmo de los diezmos será seleccionado de la mejor parte de los diezmos recibidos. Y será la porción del Señor, que entregarán a Aarón el sacerdote. ");
INSERT INTO spaonbv_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","»Se considerará como si tú lo hubieras obtenido de tu era y de tus lagares. ");
INSERT INTO spaonbv_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Aarón, sus hijos y sus familias podrán comerlo en sus hogares o dondequiera que ellos deseen hacerlo, porque es la compensación por su servicio en el santuario. ");
INSERT INTO spaonbv_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Ustedes los levitas no serán tenidos por culpables de aceptar los diezmos del Señor, si luego dan lo mejor de los diezmos a los sacerdotes. »Pero, cuidado, porque si tratan los presentes sagrados del pueblo de Israel como si fuera algo común y corriente, morirán». ");
INSERT INTO spaonbv_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","El Señor les dijo a Moisés y a Aarón: ");
INSERT INTO spaonbv_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","«Otra de mis leyes: Dile al pueblo de Israel que traiga una ternera alazana sin defecto, que no haya trabajado nunca. ");
INSERT INTO spaonbv_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Dásela a Eleazar el sacerdote, y alguien la matará en su presencia. ");
INSERT INTO spaonbv_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Eleazar mojará el dedo en la sangre y rociará siete veces hacia el frente del santuario. ");
INSERT INTO spaonbv_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Enseguida alguien quemará la ternera en presencia de Eleazar. Quemará la piel, la carne; la sangre y el estiércol. ");
INSERT INTO spaonbv_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Eleazar entonces tomará madera de cedro, ramas de hisopo e hilo escarlata y los arrojará en la fogata. ");
INSERT INTO spaonbv_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","»Luego deberá lavar sus vestiduras y bañarse. Después de hecho esto, regresará al campamento y permanecerá ceremonialmente impuro hasta la noche. ");
INSERT INTO spaonbv_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","De igual manera, el que la quemó lavará su ropa y se bañará, y quedará impuro hasta la noche. ");
INSERT INTO spaonbv_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Y otro hombre limpio reunirá las cenizas de la ternera y las colocará en algún lugar purificado fuera del campamento, donde serán conservadas por el pueblo de Israel para preparar el agua de las ceremonias de purificación para remisión del pecado. ");
INSERT INTO spaonbv_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","El que junta las cenizas de la ternera deberá lavarse las ropas y quedará impuro hasta la noche. Esta es una ley permanente para beneficio del pueblo de Israel y para los extranjeros que viven en medio de ustedes. ");
INSERT INTO spaonbv_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","»Cualquiera que toque un cadáver permanecerá impuro siete días. ");
INSERT INTO spaonbv_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Al tercer y al séptimo días, se purificará con agua, agua que habrá pasado por las cenizas de la ternera alazana, y quedará limpio; pero si no lo hace, continuará estando impuro aun después del séptimo día. ");
INSERT INTO spaonbv_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Cualquiera que toque un cadáver y no se purifique de la manera especificada, habrá profanado la santidad del santuario del Señor, y será excomulgado de Israel. Por cuanto el agua de la purificación no fue rociada sobre él, continúa en su impureza. ");
INSERT INTO spaonbv_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","»Estas son algunas reglas para cuando un hombre muera en una tienda: Cualquiera que entre en la tienda y los que estén en ella en el momento de su muerte, quedarán impuros siete días. ");
INSERT INTO spaonbv_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Cualquier vasija que haya en la tienda que no esté bien cubierta quedará impura. ");
INSERT INTO spaonbv_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","»Si alguien en el campo toca el cadáver de uno que ha sido muerto en la batalla, o que ha muerto de alguna otra manera, o si toca el hueso de alguna tumba, quedará impuro siete días. ");
INSERT INTO spaonbv_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Para purificarlo se tomarán cenizas de la ternera alazana quemada para pago por el pecado y se pondrán en un recipiente y se llenará con aguas de manantial. ");
INSERT INTO spaonbv_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Entonces una persona que no esté impura tomará de una rama de hisopo, y la mojará en agua y rociará la tienda y todos los muebles que haya en la tienda, y todas las personas que se hayan contaminado por haber estado en la tienda. También rociará a las personas contaminadas por haber tocado un hueso, o por haber tocado a alguien que ha sido asesinado o que ha muerto de muerte natural, o por haber tocado una tumba. ");
INSERT INTO spaonbv_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Esto se hará los días tercero y séptimo. Enseguida la persona impura lavará su ropa, se bañará y en la noche quedará libre de su contaminación. ");
INSERT INTO spaonbv_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","»Pero si alguien que está impuro no se purifica, será expulsado por cuanto ha contaminado el santuario del Señor. El agua de la purificación no ha sido rociada sobre él. Por lo tanto permanece impuro. ");
INSERT INTO spaonbv_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Esta es una ley permanente. »El hombre que rocía el agua debe después lavar sus ropas, y cualquiera que toque el agua quedará impuro hasta la noche. ");
INSERT INTO spaonbv_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Todo lo que una persona contaminada toque, permanecerá contaminado hasta la noche. Y quien toque a una persona contaminada, también quedará contaminado hasta la noche». ");
INSERT INTO spaonbv_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","El pueblo de Israel entró en el desierto de Zin en abril, y acampó en Cades, donde Miriam murió y fue sepultada. ");
INSERT INTO spaonbv_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Al ver que no había suficiente agua en aquel lugar, el pueblo nuevamente se rebeló contra Moisés y Aarón, ");
INSERT INTO spaonbv_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","y se formó un gran tumulto: «Ojalá hubiésemos muerto junto con los hermanos nuestros que Dios mató —lloraban ante Moisés—. ");
INSERT INTO spaonbv_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Deliberadamente nos trajiste a este desierto para que muramos nosotros, nuestras vacas y ovejas. ");
INSERT INTO spaonbv_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","¿Por qué nos hiciste salir de Egipto y nos trajiste a este lugar tan malo? ¿Dónde están las tierras fértiles, las cosechas maravillosas, los higos, los viñedos, y el ganado que decías que encontraríamos? Aquí ni siquiera hay agua para beber». ");
INSERT INTO spaonbv_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Moisés y Aarón se apartaron y fueron a la entrada del santuario donde se postraron sobre sus rostros delante del Señor; y la gloria del Señor se les apareció. ");
INSERT INTO spaonbv_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Y el Señor le dijo a Moisés: ");
INSERT INTO spaonbv_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","«Toma la vara de Aarón y tú y Aarón convoquen al pueblo. Delante de ellos ordénale a la roca que produzca agua. La roca dará agua suficiente para todo el pueblo y su ganado». ");
INSERT INTO spaonbv_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Moisés hizo lo que se le había ordenado: Tomó la vara del lugar donde era guardada delante del Señor, ");
INSERT INTO spaonbv_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","y él y Aarón convocaron al pueblo y los hicieron reunirse junto a la roca. Luego les dijo: «Oigan, rebeldes: ¿Hemos de sacar agua de esta roca?». ");
INSERT INTO spaonbv_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Moisés levantó la vara y golpeó la roca dos veces y el agua brotó, y el pueblo y el ganado bebieron. ");
INSERT INTO spaonbv_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Pero el Señor dijo a Moisés y a Aarón: «Por cuanto no me creyeron ni me honraron delante del pueblo de Israel, no serán ustedes quienes los conduzcan a la tierra que yo les he prometido». ");
INSERT INTO spaonbv_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","El lugar fue llamado Meribá (Aguas de la rencillas), porque allí el pueblo de Israel se rebeló contra el Señor, y allí les mostró que era un Dios santo. ");
INSERT INTO spaonbv_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Cuando llegaron a Cades, Moisés envió el siguiente mensaje al rey de Edom: «Somos los descendientes de tu hermano Israel. Tú sabes nuestra triste historia. ");
INSERT INTO spaonbv_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Nuestros antepasados tuvieron que emigrar a Egipto y se quedaron allí por mucho tiempo, y luego los egipcios los esclavizaron. ");
INSERT INTO spaonbv_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Pero cuando clamamos al Señor, él nos oyó y envió un ángel que nos sacó de Egipto, y ahora estamos en Cades acampados en los límites de tu tierra. ");
INSERT INTO spaonbv_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Permítenos pasar por tu país. Prometemos no pasar por los plantíos ni por los viñedos; ni siquiera beberemos agua de tus pozos. No nos saldremos del camino principal y no lo dejaremos hasta que hayamos cruzado la frontera al otro lado». ");
INSERT INTO spaonbv_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Pero el rey de Edom le respondió: «No permitiré que pasen por mi territorio. Si tratan de entrar, yo les haré frente con mi ejército». ");
INSERT INTO spaonbv_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Los enviados israelitas respondieron: «Le prometemos que no nos saldremos del camino principal y ni siquiera tomaremos nada del agua que se encuentre en su territorio, y cualquier cosa que necesitemos la pagaremos. Solamente deseamos pasar a través de su país, y nada más». ");
INSERT INTO spaonbv_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Pero el rey de Edom fue cortante: «Ya se los advertí, ¡no pasen por mi territorio!». Dicho eso, se dirigió hacia la frontera con un ejército muy fuerte y bien armado. ");
INSERT INTO spaonbv_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","22","Debido a que Edom le negó el paso a través de su territorio, Israel tuvo que regresar y viajar desde Cades hasta el monte de Hor. ");
INSERT INTO spaonbv_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Entonces el Señor les dijo a Moisés y a Aarón en la frontera de Edom: ");
INSERT INTO spaonbv_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","―Ha llegado el momento en que Aarón debe morir. Él no entrará en la tierra que yo le he dado al pueblo de Israel, porque ustedes dos se rebelaron contra mis instrucciones en las aguas de Meribá. ");
INSERT INTO spaonbv_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Ahora toma a Aarón y a su hijo Eleazar y llévalos al monte Hor. ");
INSERT INTO spaonbv_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Allí le quitarás a Aarón las ropas sacerdotales y se las pondrás a Eleazar su hijo, y Aarón morirá allí. ");
INSERT INTO spaonbv_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Moisés hizo como el Señor le había mandado. Los tres subieron juntos al monte Hor mientras todo el pueblo miraba. ");
INSERT INTO spaonbv_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Cuando llegaron a la cima, Moisés le quitó a Aarón sus ropas sacerdotales y las puso sobre su hijo Eleazar. Y Aarón murió en la cima de la montaña. Moisés y Eleazar descendieron del monte, ");
INSERT INTO spaonbv_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","y cuando el pueblo fue informado de la muerte de Aarón, lo lloraron por treinta días. ");
INSERT INTO spaonbv_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Cuando el rey de Arad que estaba en Néguev, oyó que los israelitas se acercaban (porque estaban siguiendo la misma ruta de los espías), movilizó su ejército y atacó a Israel, y tomó prisioneros a algunos de sus hombres. ");
INSERT INTO spaonbv_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Entonces el pueblo de Israel hizo voto al Señor que si él les ayudaba a vencer al rey de Arad y a su pueblo, destruirían completamente las ciudades de aquella región. ");
INSERT INTO spaonbv_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","El Señor oyó su petición y derrotaron a los cananeos, y los israelitas destruyeron completamente todas sus ciudades. De ahí en adelante el nombre de la región fue Jormá (Destrucción completa). ");
INSERT INTO spaonbv_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","El pueblo de Israel regresó al monte de Hor, y desde allí continuó hacia el sur por la ruta del Mar Rojo con el fin de dar un rodeo y pasar por el costado de la tierra de Edom. El pueblo estaba muy desalentado. ");
INSERT INTO spaonbv_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Comenzaron a murmurar contra el Señor y a quejarse contra Moisés. ―¿Por qué nos trajiste desde Egipto para morir en este desierto? Aquí no hay nada para comer, nada para beber y ya estamos hastiados de este insípido maná. ");
INSERT INTO spaonbv_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Entonces el Señor los castigó enviando serpientes venenosas, y muchos murieron. ");
INSERT INTO spaonbv_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","El pueblo acudió a Moisés y llorando le dijo: ―Hemos pecado, al hablar contra el Señor y contra ti. Ora y pídele que eche de aquí estas serpientes. Moisés entonces oró por el pueblo, y ");
INSERT INTO spaonbv_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","el Señor le dijo: ―Haz una serpiente de bronce y átala en un asta de bandera. Quienquiera que haya sido mordido vivirá con sólo mirar a la serpiente de bronce. ");
INSERT INTO spaonbv_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Moisés hizo la serpiente de bronce y todo el que era mordido y miraba a la serpiente de bronce se salvaba. ");
INSERT INTO spaonbv_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","A continuación Israel viajó a Obot y acampó allí. ");
INSERT INTO spaonbv_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Luego siguieron viaje a Iyé Abarín, en el desierto, a corta distancia de Moab hacia el oriente, ");
INSERT INTO spaonbv_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","y desde allí siguieron su camino hasta el valle del arroyo de Zéred y allí establecieron el campamento. ");
INSERT INTO spaonbv_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Luego se trasladaron al otro lado del río Arnón, cerca de la frontera de los amorreos. (El río Arnón es la línea limítrofe entre los moabitas y los amorreos. ");
INSERT INTO spaonbv_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Este hecho se menciona en el libro de los guerras del Señor, donde se dice que el valle del río Arnón y la ciudad de Waheb ");
INSERT INTO spaonbv_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","están entre los amorreos y el pueblo de Moab:) ");
INSERT INTO spaonbv_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Entonces Israel viajó hasta Ber, que significa pozo. Este es el lugar donde el Señor le dijo a Moisés: «Convoca al pueblo y yo les daré agua». ");
INSERT INTO spaonbv_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Lo que ocurrió lo describe una canción que el pueblo canta: «Brota, oh manantial; cantémosle al agua. ");
INSERT INTO spaonbv_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Este manantial los caudillos lo cavaron con sus bastones y sus palas». Salieron del desierto y pasaron por Matana, ");
INSERT INTO spaonbv_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Najaliel y Bamot. ");
INSERT INTO spaonbv_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Luego entraron en los valles de la meseta de Moab hasta llegar a la cumbre del monte Pisgá, desde donde se puede ver el desierto. ");
INSERT INTO spaonbv_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Israel envió entonces embajadores al rey Sijón de los amorreos. ");
INSERT INTO spaonbv_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","«Permítanos cruzar por su territorio —le pidieron—. No nos saldremos del camino real hasta que hayamos pasado las fronteras. No nos meteremos en los campos ni en los viñedos, ni beberemos el agua de sus pozos». ");
INSERT INTO spaonbv_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Pero el rey Sijón se negó. En vez de concederles el permiso, movilizó su ejército, y atacó a Israel en el desierto. Le presentó batalla en Yahaza. ");
INSERT INTO spaonbv_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Pero Israel lo derrotó y ocupó la tierra desde el río Arnón hasta el río Jaboc, es decir, hasta la frontera de los amonitas. Se detuvieron allí porque las ciudades amonitas estaban bien fortificadas. ");
INSERT INTO spaonbv_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","De este modo Israel capturó todas las ciudades de los amorreos y vivió en ellas incluyendo la ciudad de Hesbón, ");
INSERT INTO spaonbv_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","de la cual había sido rey Sijón, el que anteriormente había peleado contra el rey de Moab y había tomado toda la tierra de este hasta Arnón. ");
INSERT INTO spaonbv_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Los poetas de antaño se habían referido a Sijón con este poema: «Vengan a Hesbón, capital de Sijón. ");
INSERT INTO spaonbv_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Porque de ella ha salido fuego, y ha devorado a la ciudad de Ar en Moab, en las alturas del río Arnón. ");
INSERT INTO spaonbv_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","¡Ay de ti, Moab! Pueblo de Quemós, ¡estás acabado! Los hijos de Moab han huido, y sus hijas han sido capturadas por Sijón, rey de los amorreos. ");
INSERT INTO spaonbv_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Él ha devastado el reino de ellos, y ha perecido Hesbón hasta Dibón, y destruimos hasta Nofa y Medeba». ");
INSERT INTO spaonbv_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Estando Israel en el país de los amorreos, ");
INSERT INTO spaonbv_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Moisés envió exploradores a observar el territorio de Jazer; luego capturó sus pueblos, y expulsó a los amorreos. ");
INSERT INTO spaonbv_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Más tarde se fueron a la ciudad de Basán, pero el rey Og de Basán se enfrentó a ellos en Edrey. ");
INSERT INTO spaonbv_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","El Señor le dijo a Moisés que no tuviera temor, que el enemigo ya estaba vencido. «Lo mismo que le ocurrió al rey Sijón en Hesbón le ocurrirá al rey Og», —les dijo el Señor. ");
INSERT INTO spaonbv_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Y así ocurrió: Israel obtuvo la victoria y mató al rey Og, a sus hijos y a sus súbditos, ¡no quedó nadie vivo! Israel tuvo paso libre para tomar posesión de ese territorio. ");
INSERT INTO spaonbv_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","El pueblo de Israel siguió su viaje hacia las llanuras de Moab y acampó al oriente del río Jordán, frente a Jericó. ");
INSERT INTO spaonbv_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","3","Cuando el rey Balac de Moab (hijo de Zipor) se enteró del número de los israelitas, y se enteró de lo que le habían hecho a los amorreos, él y su pueblo tuvieron gran temor. ");
INSERT INTO spaonbv_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Rápidamente consultaron a los jefes de Madián. ―Está muchedumbre va a comernos con la misma facilidad con que un buey come pasto —exclamaron los moabitas. Entonces el rey Balac ");
INSERT INTO spaonbv_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","6","envió mensajeros a Balán (hijo de Beor) quien vivía en su tierra natal de Petor, cerca del río Éufrates. En su mensaje el rey rogaba a Balán que fuera y les ayudara. ―Una multitud ha llegado de Egipto, cubren toda la superficie de nuestro país; y han acampado justo delante de mí —le decía—. Ven y maldícelos en mi nombre para que pueda echarlos de mi tierra. Sé que cuando tú bendices grandes bendiciones caen sobre ellos, y también sé que a quienes tú maldices les va mal en todo. ");
INSERT INTO spaonbv_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","La comitiva, compuesta de algunos de los príncipes de Moab y de Madían, se presentó ante Balán, dinero en mano, y le refirieron las palabras de Balac. ");
INSERT INTO spaonbv_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","―Quédense esta noche —dijo Balán—. Les contaré en la mañana lo que el Señor me ordene hacer. Y así lo hicieron. ");
INSERT INTO spaonbv_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Aquella noche el Señor vino y le preguntó a Balán: ―¿Quiénes son estos hombres? ");
INSERT INTO spaonbv_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","―Ellos han venido de parte del rey Balac de Moab —le explicó—. ");
INSERT INTO spaonbv_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","El rey dice que un pueblo enorme ha venido de Egipto y ha llegado hasta sus fronteras. Quiere que yo vaya inmediatamente y los maldiga. Tiene la esperanza de que pueda vencerlos en la batalla si yo voy con ellos y maldigo a los invasores. ");
INSERT INTO spaonbv_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","―No lo hagas —le dijo el Señor—. No debes maldecirlos, porque ellos tienen mi bendición. ");
INSERT INTO spaonbv_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Al día siguiente Balán les dijo a los hombres: ―Váyanse, el Señor no me deja ir con ustedes. ");
INSERT INTO spaonbv_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Los embajadores del rey Balac regresaron e informaron al rey de la negativa de Balán. ");
INSERT INTO spaonbv_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Pero Balac insistió. Envió un número mayor y más distinguido de embajadores. ");
INSERT INTO spaonbv_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","17","Estos se presentaron ante Balán y le dieron el siguiente mensaje: ―El rey Balac te ruega que vayas. Promete darte grandes honores y cualquier cantidad de dinero que pidas. Ven de inmediato, y maldice a ese pueblo. ");
INSERT INTO spaonbv_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Pero Balán replicó: ―Aunque Balac me ofreciera un palacio repleto de oro y plata, yo no podría hacer nada contrario a los mandamientos del Señor mi Dios. ");
INSERT INTO spaonbv_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Sin embargo, pasen aquí la noche para ver si el Señor añade algo a lo que me dijo antes. ");
INSERT INTO spaonbv_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Aquella noche el Señor le dijo a Balán: ―Levántate y ve con aquellos hombres, pero harás solamente lo que yo te ordene. ");
INSERT INTO spaonbv_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Al día siguiente Balán aparejó su burra y salió con los mensajeros del rey. ");
INSERT INTO spaonbv_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Pero Dios estaba enojado, y envió un ángel para que en el camino le diera muerte. Mientras Balán y los dos siervos cabalgaban juntos, ");
INSERT INTO spaonbv_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","la burra de Balán vio repentinamente al ángel del Señor que estaba en el camino con una espada desenvainada. La burra se apartó del camino y entró en un campo, pero Balán la golpeó hasta que volvió al camino. ");
INSERT INTO spaonbv_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Nuevamente el ángel del Señor se paró en el lugar donde el camino se estrechaba entre dos muros de viñas. ");
INSERT INTO spaonbv_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Cuando la burra lo vio allí se espantó y apretó el pie de Balán contra la pared. Él azotó nuevamente a la burra. ");
INSERT INTO spaonbv_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Entonces el ángel del Señor siguió por el camino y se paró en un lugar tan estrecho que la burra no podía pasar por ningún lado. ");
INSERT INTO spaonbv_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Así que el animal no tuvo más remedio que echarse en el camino. En un arranque de ira, Balán la azotó nuevamente con su vara. ");
INSERT INTO spaonbv_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Entonces el Señor hizo que la burra hablara: ―¿Qué te he hecho; que me has castigado tres veces? —preguntó. ");
INSERT INTO spaonbv_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","―Es que tú me has hecho quedar como un necio —gritó Balán—. Si tuviera una espada conmigo te habría dado muerte. ");
INSERT INTO spaonbv_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","―¿Te he hecho alguna vez algo semejante en toda mi vida? —le preguntó la burra. ―No —reconoció Balán. ");
INSERT INTO spaonbv_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Entonces el Señor abrió los ojos de Balán y pudo ver al ángel parado en el camino con la espada desenvainada. El profeta cayó en tierra delante del ángel. ");
INSERT INTO spaonbv_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","―¿Por qué golpeaste a tu burra tres veces? —le preguntó el ángel—. He venido para detenerte porque vas caminando hacia la destrucción. ");
INSERT INTO spaonbv_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Tres veces la burra me vio y se apartó de mí. Si no hubiera sido por ella ciertamente ya te habría dado muerte, y ella habría salido con vida. ");
INSERT INTO spaonbv_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","―He pecado —confesó Balán—. No me di cuenta que estabas allí. Regresaré a casa si no quieres que siga adelante. ");
INSERT INTO spaonbv_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","El ángel le dijo: ―Ve con esos hombres, pero hablarás solamente lo que yo te diga. Balán, siguió con ellos. ");
INSERT INTO spaonbv_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Cuando el rey Balac oyó que Balán se acercaba, salió de la capital y se dirigió a encontrarlo en el río Arnón, en la frontera de su tierra. ");
INSERT INTO spaonbv_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","―¿Por qué te has demorado tanto? —le preguntó—. ¿No creíste cuando yo te dije que te daría grandes honores? ");
INSERT INTO spaonbv_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balán replicó: ―He venido, pero no tengo poder para decir nada, salvo lo que el Señor me diga. Y eso es lo que haré. ");
INSERT INTO spaonbv_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Balán acompaño al rey hasta Quiriat Jusot, ");
INSERT INTO spaonbv_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","donde el rey Balac dio animales a Balán y a los embajadores para que ofrecieran sacrificios. ");
INSERT INTO spaonbv_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","A la mañana siguiente Balac llevó a Balán hasta la cumbre del monte de Ramot Baal, desde el cual podía ver a todo el pueblo de Israel esparcido delante de sí. ");
INSERT INTO spaonbv_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balán le dijo al rey: «Edifica siete altares y prepara siete becerros y siete carneros para el sacrificio». ");
INSERT INTO spaonbv_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balac hizo lo que Balán le pedía, y sacrificó un becerro y un carnero en cada altar. ");
INSERT INTO spaonbv_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Entonces Balán le dijo al rey: «Quédate junto al altar de los sacrificios y yo iré a ver si el Señor se encuentra conmigo. Entonces te diré lo que él me diga». Subió luego hacia una cumbre solitaria, ");
INSERT INTO spaonbv_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","y Dios lo encontró allí. ―He preparado siete altares y he sacrificado un becerro y un carnero en cada uno —dijo Balán al Señor. ");
INSERT INTO spaonbv_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Entonces el Señor le dio a Balán un mensaje para el rey Balac. ");
INSERT INTO spaonbv_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Cuando Balán regresó, el rey estaba de pie junto a las ofrendas que deben quemarse en forma completa con todos los príncipes de Moab. ");
INSERT INTO spaonbv_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Este fue el mensaje de Balán: «Balac, rey de Moab, me trajo de la tierra de Aram, desde las montañas orientales. “Ven”, me dijo, “maldice a Jacob en favor mío. Deja que tu ira se alce contra Israel”. ");
INSERT INTO spaonbv_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","»Pero, ¿cómo puedo yo maldecir lo que Dios no ha maldecido? ¿Cómo puedo yo amenazar a un pueblo que Dios no ha amenazado? ");
INSERT INTO spaonbv_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Los he visto desde las altas cumbres, los he observado desde las colinas. Viven solos, y prefieren ser distintos a cualquiera otra nación. ");
INSERT INTO spaonbv_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Son numerosos como el polvo, no se pueden contar. ¡Quién pudiera morir tan feliz como un israelita! ¡Oh, si yo pudiera terminar mi vida como termina la de ellos!». ");
INSERT INTO spaonbv_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","―¿Qué me has hecho? —preguntó el rey Balac—. ¡Yo te dije que maldijeras a mis enemigos, pero tú los has bendecido! ");
INSERT INTO spaonbv_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","―¿Puedo decir algo distinto de lo que el Señor me ha dicho? ");
INSERT INTO spaonbv_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Entonces Balac le dijo: ―Ven conmigo a otro lugar. Allí sólo verás una parte del pueblo de Israel. Maldice por lo menos a esa parte. ");
INSERT INTO spaonbv_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","El rey Balac tomó a Balán y lo llevó a los campos de Zofín en la cumbre del monte de Pisgá, y edificó allí siete altares y ofreció un becerro y un carnero en cada altar. ");
INSERT INTO spaonbv_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Entonces Balán le dijo al rey: ―Quédate allí junto a los altares mientras yo voy a encontrarme con el Señor. ");
INSERT INTO spaonbv_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Y el Señor se encontró con Balán y le dijo lo que tenía que decir. ");
INSERT INTO spaonbv_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Luego Balán regresó con el rey y sus príncipes que estaban de pie junto a los altares. ―¿Qué te ha dicho el Señor? —le preguntó ansiosamente el rey. ");
INSERT INTO spaonbv_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Y la respuesta de Balán fue: «Levántate, Balac, y escucha: Escúchame, tú; hijo de Zipor. ");
INSERT INTO spaonbv_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Dios no es hombre para que mienta; él no se arrepiente como los hombres. ¿Ha prometido alguna vez sin cumplir lo que ha dicho? ");
INSERT INTO spaonbv_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","He recibido orden de bendecirlos, porque Dios los ha bendecido, y esto no puede ser cambiado. ");
INSERT INTO spaonbv_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Él no ha visto pecado en Jacob, ni perversidad en Israel. El Señor su Dios está con ellos. Él es su rey. ");
INSERT INTO spaonbv_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Dios los sacó de Egipto. Israel tiene la fortaleza del búfalo. ");
INSERT INTO spaonbv_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","No se puede maldecir a Jacob, y no hay magia que pueda hacer algo en su contra. Porque ahora se dirá de Israel: ¡Qué maravillas ha hecho Dios por ellos! ");
INSERT INTO spaonbv_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Esta gente se levanta como un león; no caerá hasta que haya comido lo capturado y haya bebido la sangre de los degollados». ");
INSERT INTO spaonbv_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","―Si no vas a maldecirlos, por lo menos no los bendigas —exclamó el rey Balac. ");
INSERT INTO spaonbv_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Pero Balán contestó: ―¿No te dije que yo tengo que decir lo que el Señor me diga? ");
INSERT INTO spaonbv_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","―Yo te llevaré a otro lugar —le dijo el rey—. Quizá desde allí el Señor quiera que los maldigas. ");
INSERT INTO spaonbv_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Lo llevó a la cumbre del monte Peor, que domina el desierto. ");
INSERT INTO spaonbv_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Balán nuevamente le dijo al rey que construyera siete altares y preparara siete becerros y siete carneros para el sacrificio. ");
INSERT INTO spaonbv_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","El rey lo hizo así, y ofreció un becerro y un carnero en cada altar. ");
INSERT INTO spaonbv_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Por fin Balán comprendió que el Señor tenía intenciones de bendecir a Israel, de modo que no fue a encontrarse con el Señor como lo había hecho anteriormente. En cambio, fue y dio una mirada hacia el campamento de Israel ");
INSERT INTO spaonbv_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","que estaba ocupando la llanura y ordenado según sus tribus. Entonces el Espíritu del Señor vino sobre Balán, ");
INSERT INTO spaonbv_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","quien proclamo la siguiente profecía: «Balán, el hijo de Beor, ");
INSERT INTO spaonbv_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","el hombre cuyos ojos están abiertos, dice: He oído la palabra del Señor, y he visto lo que el Dios Altísimo me ha mostrado; mis ojos fueron abiertos: ");
INSERT INTO spaonbv_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","»¡Ah, qué delicias aguardan a Israel, deleites en las tiendas de Jacob! ");
INSERT INTO spaonbv_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Los veo extenderse delante de mí como valles verdes y huertas fructíferas junto al río; como árboles plantados por el Señor mismo; como cedros junto a las aguas. ");
INSERT INTO spaonbv_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Serán bendecidos con abundancia de aguas, y vivirán en muchos lugares. El rey será más grande que Agag; su reino será exaltado. ");
INSERT INTO spaonbv_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","»Dios los sacó de Egipto. Israel tiene la fortaleza de un búfalo, y devorará a todas las naciones que se le opongan; les partirá los huesos en pedazos, y los herirá con muchas flechas. ");
INSERT INTO spaonbv_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Israel duerme como león, como leona, ¿quién se atreve a hacer que se levante? Bendito será el que te bendiga, oh Israel, y maldito será el que te maldiga». ");
INSERT INTO spaonbv_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","El rey Balac estaba pálido de ira. Golpeando las manos con furia gritó: ―Yo te llamé para que maldijeras a mis enemigos y en lugar de ello los has bendecido tres veces. ");
INSERT INTO spaonbv_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","¡Lárgate de aquí! ¡Vete a tu casa! Yo quería darte un gran honor, pero el Señor te ha despojado de todo bien. ");
INSERT INTO spaonbv_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balán contestó: ―Yo te dije por medio de los mensajeros ");
INSERT INTO spaonbv_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","que aunque me dieras un palacio lleno de oro y plata, yo no podría contradecir al Señor; te advertí que no podía hablar por mí mismo. Dije que hablaría solamente lo que el Señor me ordenara. ");
INSERT INTO spaonbv_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","En efecto, voy a regresar ahora mismo a mi pueblo, pero déjame primero decirte lo que los israelitas van a hacerle a tu pueblo. ");
INSERT INTO spaonbv_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Entonces Balán añadió: «Balán el hijo de Beor, ");
INSERT INTO spaonbv_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","¡es el hombre cuyos ojos están abiertos! El oye las palabras de Dios y tiene conocimiento del Altísimo; él ve lo que el Dios Todopoderoso le ha mostrado. ");
INSERT INTO spaonbv_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","»Calló, y sus ojos fueron abiertos y vio. Vio el futuro de Israel. ¡Vio salir en la distancia, una estrella de Jacob! Este Gobernador de Israel herirá al pueblo de Moab, y destruirá a los hijos de Set. ");
INSERT INTO spaonbv_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","»Israel poseerá todo Edom y Seír, y vencerá a todos sus enemigos. ");
INSERT INTO spaonbv_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Jacob se levantará con poder y destruirá muchas ciudades». ");
INSERT INTO spaonbv_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Entonces Balán miró hacia las tiendas del pueblo de Amalec y profetizó: «Amalec fue la primera de las naciones, pero al fin perecerá para siempre». ");
INSERT INTO spaonbv_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","A continuación miró hacia los ceneos: «Sí, están en una situación de fuerza, tienen su nido entre las rocas. ");
INSERT INTO spaonbv_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Pero los ceneos serán destruidos y el poderoso ejército de Asiria los deportará de esta tierra». ");
INSERT INTO spaonbv_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Concluyó sus profecías diciendo: «Ay, ¿quién podrá vivir cuando Dios haga esto? ");
INSERT INTO spaonbv_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Barcos vendrán de las costas de Chipre, y someterán a Éber y a Asiria. También deben ser destruidos». ");
INSERT INTO spaonbv_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Entonces Balán y Balac regresaron cada uno a su lugar. ");
INSERT INTO spaonbv_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Mientras Israel estaba establecido en Sitín, algunos de los jóvenes comenzaron a tener relaciones con las muchachas moabitas. ");
INSERT INTO spaonbv_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Ellas los invitaban a asistir a los sacrificios que hacían a sus dioses, y pronto aquellos hombres no solamente asistían a las fiestas de ellas, sino que también se postraban ante los ídolos para adorarlos. ");
INSERT INTO spaonbv_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","No mucho después Israel entero adoraba a Baal, el dios de Moab, y la ira del Señor se encendió en contra de su pueblo, y los castigó con una plaga. ");
INSERT INTO spaonbv_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Entonces el Señor le ordenó a Moisés: «Ejecuta a todos los dirigentes de Israel. Ahórcalos en pleno día delante del Señor para que mi ira se aparte del pueblo». ");
INSERT INTO spaonbv_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Moisés, pues, ordenó a los jueces que ejecutaran a todos los que habían adorado a Baal. ");
INSERT INTO spaonbv_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Uno de los israelitas insolentemente introdujo a una madianita en el campamento ante la vista de Moisés, mientras este y todo el pueblo lloraban a la puerta del santuario. ");
INSERT INTO spaonbv_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Cuando Finés (hijo de Eleazar y nieto de Aarón el sacerdote) vio esto, ");
INSERT INTO spaonbv_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","corrió, tomó una espada, y entró en la tienda donde el hombre había llevado a la mujer. Allí tomó la espada y los atravesó a ambos por el vientre. La plaga se detuvo, ");
INSERT INTO spaonbv_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","pero ya habían muerto veinticuatro mil personas. ");
INSERT INTO spaonbv_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Entonces el Señor le dijo a Moisés: ");
INSERT INTO spaonbv_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","«Finés (hijo de Eleazar el sacerdote y nieto de Aarón el sacerdote) ha aplacado mi ira, porque sintió el mismo ardor que yo respecto de mi honra. Por esto no destruiré a Israel. ");
INSERT INTO spaonbv_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","13","En virtud de lo que ha hecho, en virtud de su celo por su Dios, y por cuanto ha hecho expiación por el pueblo de Israel, prometo que él y sus descendientes tendrán el sacerdocio para siempre». ");
INSERT INTO spaonbv_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","El hombre que fue muerto con la muchacha madianita se llamaba Zimri, hijo de Salu, uno de los jefes de la tribu de Simeón. ");
INSERT INTO spaonbv_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","El nombre de la muchacha era Cozbí, hija de Zur, príncipe madianita. ");
INSERT INTO spaonbv_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Entonces el Señor dijo a Moisés: ");
INSERT INTO spaonbv_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","«Destruye a los madianitas, ");
INSERT INTO spaonbv_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","porque ellos los están destruyendo a ustedes con sus engaños. Están provocándolos para que adoren a Baal, y los están apartando del camino, como acaban de ver en el caso de Cozbí». ");
INSERT INTO spaonbv_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Cuando la plaga terminó, el Señor les dijo a Moisés y a Eleazar (hijo de Aarón el sacerdote): ");
INSERT INTO spaonbv_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","«Levanten un censo de todos los hombres de Israel mayores de veinte años, para saber cuántos hombres de cada tribu y familia pueden ir a la guerra». ");
INSERT INTO spaonbv_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","4","Moisés y Eleazar hicieron el censo en la llanura de Moab, juntó al Jordán, frente a Jericó, donde el pueblo se había establecido. Estos son los resultados del censo: ");
INSERT INTO spaonbv_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","11","Tribu de Rubén: 43.730. (Rubén era el hijo mayor de Israel). En esta tribu había los siguientes clanes, nombrados de acuerdo con los nombres de los hijos de Rubén: Los enoquitas, descendientes de Enoc. Los faluitas, descendientes de Falú. (En el clan de Eliab, que era uno de los hijos de Falú, estaban las familias de Nemuel, Datán y Abirán. Datán y Abirán son los dos líderes que conspiraron junto a Coré en contra de Moisés y Aarón, y que se rebelaron contra Dios mismo y su autoridad. Pero la tierra abrió su boca y se los tragó; doscientos cincuenta hombres fueron destruidos por fuego del Señor aquel día, a modo de advertencia para toda la nación. Pero los hijos de Coré no murieron). Los jezronitas, descendientes de Jezrón. Los carmitas, descendientes de Carmí. ");
INSERT INTO spaonbv_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","14","Tribu de Simeón: 22.200. Esta tribu estaba formada por los siguientes clanes fundados por los hijos de Simeón: Los nemuelitas, descendientes de Nemuel. Los jaminitas, descendientes de Jamín. Los jaquinitas, descendientes de Jaquín. Los zeraítas, descendientes de Zera. Los saulitas, descendientes de Saúl. ");
INSERT INTO spaonbv_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","18","Tribu de Gad: 40.500. Esta tribu estaba formada por los siguientes clanes fundados por los hijos de Gad: Los zefonitas, descendientes de Zefón. Los jaguitas, descendientes de Jaguí. Los sunitas, descendientes de Suni. Los oznitas, descendientes de Ozni. Los eritas, descendientes de Erí. Los aroditas, descendientes de Arodí. Los arelitas, descendientes de Arelí. ");
INSERT INTO spaonbv_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","22","Tribu de Judá: 76.500. Esta tribu estaba formada por los siguientes clanes, cuyos nombres corresponden a los hijos de Judá. Entre ellos no se incluyen Er ni Onán, que murieron en la tierra de Canaán: Los selaítas, descendientes de Selá. Los faresitas, descendientes de Fares. Los zeraítas, descendientes de Zera. Este censo además incluyó los subclanes de Fares: Los jezronitas, descendientes de Jezrón. Los jamulitas descendientes de Jamul. ");
INSERT INTO spaonbv_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","25","Tribu de Isacar: 64.300. Esta tribu estaba formada por los siguientes clanes, cuyos nombres corresponden a los hijos de Isacar: Los tolaítas, descendientes de Tola. Los fuvitas, descendientes de Fuvá. Los yasubitas, descendientes de Yasub. Los simronitas, descendientes de Simrón. ");
INSERT INTO spaonbv_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","27","Tribu de Zabulón: 60.500. En esta tribu había los siguientes clanes, cuyos nombres corresponden a los hijos de Zabulón: Los sereditas, descendientes de Séred. Los elonitas, descendientes de Elón. Los yalelitas, descendientes de Yalel. ");
INSERT INTO spaonbv_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","37","Tribu de José: 32.500 en la media tribu de Efraín, y 52.700 en la media tribu de Manasés. La media tribu de Manasés estaba formada por el clan de los maquiritas descendientes de Maquir. El subclan de los maquiritas estaba formado por los galaaditas descendientes de Galaad. Las familias de los galaaditas eran las siguientes: Los jezeritas, descendientes de Jezer. Los jelequitas, descendientes de Jélec. Los asrielitas, descendientes de Asriel. Los siquemitas, descendientes de Siquén. Los semidaítas, descendientes de Semidá. Los jeferitas, descendientes de Jéfer. Zelofejad el hijo de Jéfer no tuvo hijos. Estos son los nombres de sus hijas: Majlá, Noa, Joglá, Milca y Tirsá. Los 32.500 contados en la media tribu de Efraín eran de los siguientes clanes, cuyos nombres corresponden a los hijos de Efraín: Los sutelaítas, descendientes de Sutela (Un subclan de los sutelaítas, los eranitas, eran descendientes de Erán, hijo de Sutela). Los bequeritas, descendientes de Béquer. Los tajanitas, descendientes de Taján. ");
INSERT INTO spaonbv_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","41","Tribu de Benjamín: 45.600. Esta tribu estaba formada por los siguientes clanes, cuyos nombres corresponden a los hijos de Benjamín: Los belaítas, descendientes de Bela. Los subclanes de Bela eran dos: Los arditas, descendientes de Ard, y los naamitas, descendientes de Naamán. Los asbelitas, descendientes de Asbel. Los ajiranitas, descendientes de Ajirán. Los sufanitas, descendientes de Sufán. Los jufanitas, descendientes de Jufán. ");
INSERT INTO spaonbv_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","43","La tribu de Dan: 64.400. En esta tribu estaba el clan de los sujanitas, descendientes de Suján, hijo de Dan. ");
INSERT INTO spaonbv_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","47","Tribu de Aser: 53.400. Esta tribu estaba formada por los siguientes clanes, cuyos nombres corresponden a los hijos de Aser: Los imnaítas, descendientes de Imná. Los isvitas, descendientes de Isví. Los beriaítas, descendientes de Beriá. Bería dio origen a los siguientes clanes: Los jeberitas, descendientes de Jéber. Los malquielitas, descendientes de Malquiel. Aser también tuvo una hija llamada Sera. ");
INSERT INTO spaonbv_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","50","Tribu de Neftalí: 45.400. La tribu estaba formada por los siguientes clanes, cuyos nombres corresponden a los hijos de Neftalí: Los yazelitas, descendientes de Yazel. Los gunitas, descendientes de Guní. Los jeseritas, descendientes de Jéser. Los silenitas, descendientes de Silén. ");
INSERT INTO spaonbv_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","El número total de hombres capaces de salir a la guerra en Israel era de 601.730. ");
INSERT INTO spaonbv_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Entonces el Señor le dijo a Moisés ");
INSERT INTO spaonbv_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","que dividiera la tierra entre las tribus, en proporción a la población de cada una, en la forma indicada por el censo: ");
INSERT INTO spaonbv_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Las tribus más grandes recibirían más tierras, y las tribus, más pequeñas, menos. ");
INSERT INTO spaonbv_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","56","La tierra seria distribuida por sorteo haciendo distinción entre las tribus grandes y las pequeñas. ");
INSERT INTO spaonbv_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Estos son los clanes de los levitas contados en el censo: Los guersonitas, descendientes de Guersón. Los coatitas, descendientes de Coat. Los meraritas, descendientes de Merari. ");
INSERT INTO spaonbv_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","59","Las familias de la tribu de Leví son las siguientes: Los libnitas, los hebronitas, los majlitas, los musitas, y los coreítas. Cuando Leví estaba en Egipto tuvo una hija a la que llamó Jocabed. Se casó con Amirán hijo de Coat. Ellos fueron padres de Aarón, Moisés y Miriam. ");
INSERT INTO spaonbv_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Aarón tuvo los siguientes hijos: Nadab, Abiú, Eleazar e Itamar. ");
INSERT INTO spaonbv_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Pero Nadab y Abiú murieron cuando ofrecieron fuego diferente al que Dios les había indicado. ");
INSERT INTO spaonbv_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","El número total de los levitas en el censo fue de 23.000, contando todos los varones de un mes hacia arriba. Sin embargo, los levitas no fueron incluidos en la cifra total del censo del pueblo de Israel, porque los levitas no iban a recibir tierras cuando estas se distribuyeran entre las tribus. ");
INSERT INTO spaonbv_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Estas, pues, son las cifras del censo preparado por Moisés y Eleazar el sacerdote, junto al río Jordán, en la ribera opuesta a Jericó. ");
INSERT INTO spaonbv_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Ninguna persona de este censo había sido contada en el censo anterior realizado en el desierto de Sinaí. ");
INSERT INTO spaonbv_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Todos los contados habían muerto, porque el Señor había dicho de ellos: «Morirán en el desierto». Las únicas excepciones eran Caleb (hijo de Jefone) y Josué (hijo de Nun). ");
INSERT INTO spaonbv_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Había un hombre llamado Zelofejad hijo de Héfer, nieto de Galaad, y bisnieto de Maquir, de la tribu de Manasés hijo de José. Zelofejad tenía cinco hijas llamadas Majlá, Noa, Joglá, Milca y Tirsá. ");
INSERT INTO spaonbv_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Un día se presentaron en el santuario para hacerle una petición a Moisés, a Eleazar el sacerdote y a los dirigentes tribales que estaban allí. ");
INSERT INTO spaonbv_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","―Nuestro padre murió en el desierto —dijeron—, y no fue de los que murieron en la rebelión de Coré contra el Señor. Murió de muerte natural, sin dejar hijos varones. ");
INSERT INTO spaonbv_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","¿Por qué ha de desaparecer el nombre de nuestro padre por el hecho de no haber tenido ningún hijo? Creemos que debiéramos tener una propiedad al igual que los descendientes de los hermanos de nuestro padre. ");
INSERT INTO spaonbv_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Moisés presentó este caso delante del Señor, ");
INSERT INTO spaonbv_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","7","y el Señor le respondió: ―Las hijas de Zelofejad tienen razón: Dales una heredad junto a sus tíos. Dales la propiedad que hubiera correspondido al padre de ellas si hubiera vivido. ");
INSERT INTO spaonbv_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Que esta sea ley entre ustedes. Si un hombre muere y no tiene hijos, la herencia pasará a sus hijas. ");
INSERT INTO spaonbv_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Y si no tiene ninguna hija, pertenecerá a sus hermanos. ");
INSERT INTO spaonbv_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Si no tiene hermanos, pasará a sus tíos. ");
INSERT INTO spaonbv_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Y si no tiene tíos, pasará al pariente más cercano. ");
INSERT INTO spaonbv_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Un día el Señor le dijo a Moisés: ―Sube al monte Abarín y verás al otro lado del río la tierra que he dado al pueblo de Israel. ");
INSERT INTO spaonbv_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Después que la hayas visto, morirás como murió Aarón tu hermano, ");
INSERT INTO spaonbv_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","por cuanto te rebelaste contra mis instrucciones en el desierto de Zin. Cuando el pueblo de Israel se rebeló, no me glorificaste delante de ellos siguiendo mis instrucciones a fin de que el agua brotara de la roca. Se estaba refiriendo al incidente de las aguas de Meribá (Aguas de la rencilla) en Cades, en el desierto de Zin. ");
INSERT INTO spaonbv_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Entonces Moisés le dijo al Señor: ");
INSERT INTO spaonbv_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","―Oh, Señor, Dios de los espíritus de los humanos, antes que yo sea llevado designa a un nuevo caudillo para el pueblo, ");
INSERT INTO spaonbv_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","un hombre que los guíe en la batalla y cuide de ellos, de manera que el pueblo del Señor no quede como oveja sin pastor. ");
INSERT INTO spaonbv_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","El Señor contestó: ―Toma a Josué (hijo de Nun), quien tiene al Espíritu, ");
INSERT INTO spaonbv_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","y llévalo ante Eleazar el sacerdote; y en presencia de todo el pueblo, encárgale la responsabilidad de dirigir la nación. ");
INSERT INTO spaonbv_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Entrégale públicamente tu autoridad para que todo el pueblo le obedezca. ");
INSERT INTO spaonbv_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Él consultará a Eleazar el sacerdote para recibir mis órdenes. Yo, el Señor, hablaré con Eleazar por medio del urim, y Eleazar le entregará las instrucciones a Josué y al pueblo. De esta manera continuará guiando a Israel. ");
INSERT INTO spaonbv_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Entonces Moisés hizo como el Señor le había ordenado: tomó a Josué y lo llevó ante Eleazar el sacerdote. En presencia del pueblo, ");
INSERT INTO spaonbv_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Moisés puso las manos sobre Josué, y lo consagró para el cargo que el Señor le había dado. ");
INSERT INTO spaonbv_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","El Señor le dio a Moisés las siguientes instrucciones para que las entregara al pueblo de Israel: ");
INSERT INTO spaonbv_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","«Las ofrendas que se presentan encendidas sobre el altar son para mí como el alimento, y las recibo con gratitud; por lo tanto, deberán presentarlas a su tiempo y tal como lo he mandado. ");
INSERT INTO spaonbv_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","»Cuando presenten ofrendas encendidas, presenten corderos machos sin defectos. Presenten dos cada día como ofrenda regular. ");
INSERT INTO spaonbv_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Uno será sacrificado en la mañana, y el otro en la tarde. ");
INSERT INTO spaonbv_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Con ellos ofrecerán dos kilos y medio de harina fina amasada con un litro de aceite. ");
INSERT INTO spaonbv_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Esta es la ofrenda que fue ordenada en el monte Sinaí, y que debe ofrecerse continuamente como olor grato, ofrenda presentada por fuego al Señor. ");
INSERT INTO spaonbv_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Juntamente con ella se ofrecerá una libación consistente en un litro de vino fuerte con cada cordero, que se derramará en el Lugar Santo delante del Señor. ");
INSERT INTO spaonbv_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","El segundo cordero lo ofrecerán en la tarde con la misma ofrenda de harina fina y libación. Es también una ofrenda de olor fragante delante del Señor, una ofrenda presentada por fuego. ");
INSERT INTO spaonbv_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","10","»En el día de reposo, sacrificarán dos corderos de un año, sin defectos, además de las ofrendas regulares. Serán acompañados por una ofrenda de cinco kilos de harina mezclada con aceite y la libación acostumbrada. ");
INSERT INTO spaonbv_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","»Además, el primer día de cada mes, se presentará una ofrenda encendida extraordinaria en que se ofrecerán al Señor dos becerros, un carnero y siete corderos de un año, todos sin defecto. ");
INSERT INTO spaonbv_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Los acompañarán con siete kilos de harina fina mezclada con aceite como ofrenda vegetal por cada becerro; cinco litros con cada carnero; ");
INSERT INTO spaonbv_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","y dos litros y medio con cada cordero. Esta ofrenda será presentada por fuego, y será de olor grato delante del Señor. ");
INSERT INTO spaonbv_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Con cada sacrificio se ofrecerá también una libación de dos litros de vino por cada becerro, un litro y medio por cada carnero y un litro por cada cordero. Esta, pues, será la ofrenda encendida que se presentará cada mes a través de todo el año. ");
INSERT INTO spaonbv_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","»Además, el primer día de cada mes, ofrecerán al Señor un chivo como ofrenda por el pecado. Lo ofrecerán además de la ofrenda encendida y la libación de cada día. ");
INSERT INTO spaonbv_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","»En el día catorce del primer mes de cada año, celebrarán la Pascua. ");
INSERT INTO spaonbv_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Al día siguiente, comenzará una fiesta de mucha alegría que durará siete días, en los que no se servirá pan leudado. ");
INSERT INTO spaonbv_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","En el primer día de la festividad se convocará a una asamblea santa de todo el pueblo y no se realizará en él trabajo alguno. ");
INSERT INTO spaonbv_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Ofrecerán como ofrenda especial al Señor dos becerros jóvenes, un carnero y siete corderos de un año, todos sin defecto. ");
INSERT INTO spaonbv_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Con cada becerro se llevará una ofrenda vegetal consistente en siete kilos de harina fina mezclada con aceite; con el carnero se ofrecerán cinco litros ");
INSERT INTO spaonbv_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","y con cada uno de los siete corderos se ofrecerán dos litros y medio. ");
INSERT INTO spaonbv_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Además deberán ofrecer un chivo como ofrenda por el pecado para hacer expiación por ustedes. ");
INSERT INTO spaonbv_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Estas ofrendas se instituyen además de los sacrificios cotidianos. ");
INSERT INTO spaonbv_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","El mismo sacrificio se ofrecerá cada uno de los siete días de la fiesta; será muy grato delante del Señor. ");
INSERT INTO spaonbv_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","En el séptimo día habrá una asamblea santa y solemne de todo el pueblo, y durante aquel día no podrán hacer obra alguna. ");
INSERT INTO spaonbv_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","»En el día de las Primicias (llamado también fiesta de las Semanas o Pentecostés), habrá una asamblea especial y solemne en la que todo el pueblo se reunirá para celebrar la nueva cosecha. En aquel día presentarán las primicias de la nueva cosecha de grano como una ofrenda vegetal al Señor. Nadie trabajará en aquel día. ");
INSERT INTO spaonbv_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","También se ofrecerán como ofrenda especial: dos becerros, un carnero y siete corderos de un año. Se le presentarán al Señor como ofrenda quemada de olor agradable. ");
INSERT INTO spaonbv_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Acompañarán esos sacrificios con una ofrenda vegetal de siete kilos de harina fina mezclada con aceite por cada becerro, cinco litros por el carnero, ");
INSERT INTO spaonbv_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","y dos litros y medio por cada uno de los siete corderos. ");
INSERT INTO spaonbv_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Además, ofrecerán un chivo como expiación de sus pecados. ");
INSERT INTO spaonbv_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Estas ofrendas especiales se ofrecerán además de las regulares y de las ofrendas vegetales y libaciones de cada día. Los animales que se ofrecerán serán sin defecto alguno. ");
INSERT INTO spaonbv_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","»La fiesta de las Trompetas será celebrada el primer día del séptimo mes de cada año. Habrá una asamblea solemne de todo el pueblo en aquel día, y nadie realizará trabajo alguno. ");
INSERT INTO spaonbv_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Ofrecerán un sacrificio consistente en un becerro, un carnero y siete corderos de un año, todos sin defecto. Estos son sacrificios que el Señor aprecia y en los que se goza. ");
INSERT INTO spaonbv_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Con el becerro presentarán una ofrenda de grano de siete kilos de harina fina mezclada con aceite, cinco kilos de harina con el carnero ");
INSERT INTO spaonbv_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","y dos kilos y medio con cada uno de los siete corderos. ");
INSERT INTO spaonbv_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Además de esto, sacrificarán un chivo como ofrenda de expiación por el pecado. ");
INSERT INTO spaonbv_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Estos sacrificios especiales los ofrecerán además de las ofrendas quemadas de cada día y de cada mes. Me los presentarán con sus respectivas ofrendas vegetales y libaciones, en la forma especificada. ");
INSERT INTO spaonbv_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","»Diez días después convocarán nuevamente al pueblo. Ese será un día de humillación delante del Señor, y no se realizará trabajo alguno. ");
INSERT INTO spaonbv_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","En ese día ofrecerán un holocausto, es decir, una ofrenda quemada al Señor que será muy grato para él. Consistirá de un becerro, un carnero y siete corderos, todos sin defecto, ");
INSERT INTO spaonbv_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","y de las correspondientes ofrendas vegetales. Con el becerro ofrecerán siete kilos de harina fina mezclada con aceite, cinco litros con el carnero, ");
INSERT INTO spaonbv_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","y dos litros y medio con cada uno de los siete corderos. ");
INSERT INTO spaonbv_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Además presentarán un chivo como ofrenda por el pecado. Esta se presenta aparte además de la ofrenda por el pecado del día de la Expiación (que se ofrecerá cada año en ese día) y aparte de las ofrendas encendidas regulares de cada día y sus correspondientes ofrendas vegetales y libaciones. ");
INSERT INTO spaonbv_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","»Cinco días después habrá otra asamblea de todo el pueblo, y ese día no se hará trabajo alguno. Es el comienzo de una fiesta dedicada al Señor que durará siete días. ");
INSERT INTO spaonbv_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","La ofrenda especial que presentarán ese día será de olor muy grato delante del Señor y consistirá en trece becerros, dos carneros y catorce corderos de un año, todos sin defecto y quemados en su totalidad. ");
INSERT INTO spaonbv_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Acompañarán esas ofrendas con las usuales ofrendas vegetales: siete litros de harina fina mezclada con aceite por cada uno de los trece becerros, cinco litros por cada uno de los dos carneros ");
INSERT INTO spaonbv_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","y dos litros y medio por cada uno de los catorce corderos. ");
INSERT INTO spaonbv_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Además ofrecerán un chivo por el pecado, aparte del sacrificio regular de cada día, y sus correspondientes ofrendas de grano y libaciones. ");
INSERT INTO spaonbv_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","»El segundo día de esta fiesta de los siete días, ofrecerán doce becerros, dos carneros y catorce corderos de un año; todos sin defectos, ");
INSERT INTO spaonbv_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","acompañado cada uno de las respectivas ofrendas vegetales y libaciones. ");
INSERT INTO spaonbv_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Además de los sacrificios correspondientes a ese día, sacrificarán un chivo, con su respectiva ofrenda vegetal y libación, que será ofrenda por el pecado. ");
INSERT INTO spaonbv_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","»En el tercer día de la fiesta, ofrecerán once becerros, dos carneros, catorce chivos, cada uno sin defecto, ");
INSERT INTO spaonbv_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","y las correspondientes ofrendas y libaciones con cada sacrificio. ");
INSERT INTO spaonbv_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Además de las ofrendas que se ofrecen totalmente quemadas cada día, sacrificarán un chivo como ofrenda por el pecado, con sus correspondientes ofrendas de granos y libaciones. ");
INSERT INTO spaonbv_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","»En el cuarto día del festival, sacrificarán diez becerros, dos carneros y catorce corderos de un año sin defectos, ");
INSERT INTO spaonbv_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","cada uno con sus correspondientes ofrendas de grano y libaciones. ");
INSERT INTO spaonbv_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Además sacrificarán un chivo como ofrenda por el pecado con sus acostumbradas ofrendas de granos y libaciones, aparte de los sacrificios regulares del día: ");
INSERT INTO spaonbv_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","27","»En el quinto día de la fiesta, sacrificarán nueve becerros, dos carneros y catorce corderos de un año, cada uno sin defecto, acompañados por las acostumbradas ofrendas vegetales y libaciones. ");
INSERT INTO spaonbv_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Además sacrificarán un chivo con las acostumbradas ofrendas de granos y libaciones como ofrenda especial por el pecado, además de los sacrificios regulares del día. ");
INSERT INTO spaonbv_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","»En el sexto día de la fiesta, ofrecerán ocho becerros, dos carneros y catorce corderos de un año, cada uno sin defecto, ");
INSERT INTO spaonbv_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","junto con sus acostumbradas ofrendas de granos y libaciones. ");
INSERT INTO spaonbv_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Además del sacrificio cotidiano, sacrificarán como ofrenda por el pecado un chivo con la correspondiente ofrenda de granos y libación. ");
INSERT INTO spaonbv_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","»En el séptimo día de la fiesta, sacrificarán siete becerros, dos carneros y catorce corderos de un año, cada uno sin defecto, ");
INSERT INTO spaonbv_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","con sus correspondientes ofrendas vegetales y libaciones. ");
INSERT INTO spaonbv_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Además sacrificarán como ofrenda extraordinaria por el pecado un chivo con las acostumbradas ofrendas vegetales y libaciones, aparte de los sacrificios regulares del día. ");
INSERT INTO spaonbv_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","»El octavo día, convocarán al pueblo a otra asamblea solemne. No trabajarán ese día. ");
INSERT INTO spaonbv_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Sacrificarán, como ofrenda agradable al Señor, un becerro, un carnero, y siete corderos de un año, sin defectos. Todos ellos serán sacrificados y quemados totalmente en el altar. ");
INSERT INTO spaonbv_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","También ofrecerán las acostumbradas ofrendas de granos y libaciones. ");
INSERT INTO spaonbv_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Además sacrificarán un chivo con su correspondiente ofrenda vegetal y libación como ofrenda por el pecado, además de los sacrificios regulares del día. ");
INSERT INTO spaonbv_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Estas ofrendas son obligatorias con ocasión de las festividades anuales, y se ofrecen además de los sacrificios y ofrendas que presentan ustedes en conexión con votos, o como ofrendas voluntarias, las ofrendas que deben quemarse en su totalidad, ofrendas vegetales, libaciones u ofrendas pacíficas». ");
INSERT INTO spaonbv_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Y Moisés dio todas estas instrucciones al pueblo de Israel. ");
INSERT INTO spaonbv_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Moisés convocó a todos los jefes de las tribus y les dijo: ");
INSERT INTO spaonbv_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","«El Señor ha ordenado que cualquiera que le haga una promesa, ya sea de hacer algo o de dejar de hacer algo, deberá cumplirla fielmente. La persona que hace el voto deberá hacer exactamente lo que ha prometido. ");
INSERT INTO spaonbv_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","»Mas si una mujer soltera que vive en casa de su padre promete al Señor que hará o no hará algo, ");
INSERT INTO spaonbv_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","y su padre oye que ha hecho un voto y no dice nada, el voto de ella será válido. ");
INSERT INTO spaonbv_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Pero si el padre se niega a darle el permiso para hacer el voto, entonces la promesa quedará automáticamente anulada. Y así el Señor la liberará porque su padre no quiere que ella lo haga. ");
INSERT INTO spaonbv_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","»Si se casa cuando todavía está ligada por un voto; ");
INSERT INTO spaonbv_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","y su marido se entera y no le dice nada, el voto será válido. ");
INSERT INTO spaonbv_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Pero si al enterarse el marido se niega a aceptarlo, su desacuerdo anula el voto y el Señor la libertará. ");
INSERT INTO spaonbv_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","»Pero si la mujer es viuda o divorciada, ella deberá cumplir el voto. ");
INSERT INTO spaonbv_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","»Si se ha casado y vive en casa de su marido cuando hace el voto, ");
INSERT INTO spaonbv_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","y su marido se entera de él, y nada dice, el voto será válido. ");
INSERT INTO spaonbv_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Pero si él se niega a permitirlo en el primer día en que se entera del voto, el voto de ella quedará nulo y el Señor la perdonará. ");
INSERT INTO spaonbv_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","De modo que el marido podrá confirmar o anular el voto, ");
INSERT INTO spaonbv_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","pero si él no dice nada durante el día significa que lo ha aprobado. ");
INSERT INTO spaonbv_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Si espera más de un día y luego se niega a reconocer el voto, las obligaciones del voto recaerán sobre él y él será responsable». ");
INSERT INTO spaonbv_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Estos pues, son los mandamientos que el Señor dio a Moisés acerca de las relaciones entre un hombre y su esposa, y entre un padre y su hija que vive en su casa. ");
INSERT INTO spaonbv_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Entonces el Señor le dijo a Moisés: ");
INSERT INTO spaonbv_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","«Toma venganza de los madianitas por haber inducido a Israel a la idolatría. Luego morirás». ");
INSERT INTO spaonbv_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Moisés le dijo al pueblo: «Algunos de ustedes deben tomar las armas para hacer caer sobre Madián la venganza del Señor. ");
INSERT INTO spaonbv_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Alisten mil hombres de cada tribu». ");
INSERT INTO spaonbv_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Así se hizo, y de Israel fueron enviados doce mil hombres a la batalla. ");
INSERT INTO spaonbv_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Finés (hijo de Eleazar el sacerdote) los condujo a la batalla acompañado por el cofre del pacto y con sonido de trompetas. ");
INSERT INTO spaonbv_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","En la batalla murieron todos los hombres de Madián. ");
INSERT INTO spaonbv_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Entre los muertos estaban los cinco reyes madianitas: Eví, Requen, Zur, Jur y Reba. También murió en la batalla Balán hijo de Beor. ");
INSERT INTO spaonbv_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","11","El ejército israelita tomó cautivos a las mujeres y a los niños, y se apoderó de las vacas, las ovejas y de un cuantioso botín. Y quemaron todas las ciudades, pueblos y aldeas de Madián. ");
INSERT INTO spaonbv_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","Los cautivos y los despojos de la guerra fueron llevados ante Moisés, Eleazar el sacerdote y el resto del pueblo de Israel que estaba acampando en la llanura de Moab, junto al río Jordán, frente a Jericó. ");
INSERT INTO spaonbv_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Moisés, Eleazar el sacerdote y todos los jefes del pueblo salieron a encontrar al ejército victorioso, ");
INSERT INTO spaonbv_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","pero Moisés se enojó con los oficiales del ejército y los comandantes de batallón. ");
INSERT INTO spaonbv_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","«¿Por qué dejaron con vida a las mujeres? —les preguntó—. ");
INSERT INTO spaonbv_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Ellas fueron las que siguieron el consejo de Balán y causaron gran daño al pueblo de Israel, haciendo que adorara a Baal Peor, y son la causa de la plaga que nos destruyó. ");
INSERT INTO spaonbv_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Maten pues a los niños varones y a todas las mujeres que hayan tenido relación sexual. ");
INSERT INTO spaonbv_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Solamente las muchachas vírgenes podrán vivir. Con ellas pueden quedarse. ");
INSERT INTO spaonbv_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","»Y en cuanto a ustedes, quédense fuera del campamento por siete días todos los que hayan matado a alguien o hayan tocado un cuerpo muerto. Purifíquense ustedes y los cautivos en los días tercero y séptimo. ");
INSERT INTO spaonbv_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Acuérdense también de purificar la ropa que traen puesta y todo lo que esté hecho de piel, de pelo de cabrito o de madera». ");
INSERT INTO spaonbv_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Entonces el sacerdote Eleazar dijo a los hombres que habían estado en la batalla: «Este es el mandamiento que el Señor le ha dado a Moisés: ");
INSERT INTO spaonbv_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Todo lo que resiste el calor: oro, plata, bronce, hierro, estaño o cuero, ");
INSERT INTO spaonbv_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","será pasado por fuego a fin de que quede ceremonialmente limpio. Luego será purificado con agua. Lo que no resista el calor será purificado solamente con agua. ");
INSERT INTO spaonbv_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","En el día séptimo deben lavar la ropa que traen puesta, y después de purificarse pueden regresar al campamento». ");
INSERT INTO spaonbv_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Y el Señor le dijo a Moisés: ");
INSERT INTO spaonbv_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","«Tú, el sacerdote Eleazar y los caudillos de las tribus harán una lista del botín, incluyendo las personas y animales. ");
INSERT INTO spaonbv_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Luego lo dividirán en dos partes. La mitad será para los hombres que estuvieron en la batalla, y la otra mitad será distribuida entre el pueblo de Israel. ");
INSERT INTO spaonbv_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Pero antes que nada, darán al Señor su parte de todos los cautivos, bueyes, burros y ovejas que corresponden al ejército. Su parte será uno de cada quinientos. ");
INSERT INTO spaonbv_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Esta parte se la entregarán a Eleazar el sacerdote para que sea ofrecida al Señor meciéndola delante del altar. ");
INSERT INTO spaonbv_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Además, impondrán un tributo del dos por ciento de todos los cautivos, cabezas de ganado y las ovejas que se entregan al pueblo de Israel. Esto lo entregarán a los levitas que están a cargo del santuario, porque es la porción del Señor». ");
INSERT INTO spaonbv_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Entonces Moisés y Eleazar el sacerdote hicieron lo que el Señor había ordenado. ");
INSERT INTO spaonbv_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","35","El total del botín (además de las joyas, vestidos etc., que los soldados guardaron para sí) fue de 675.000 ovejas; 72.000 vacas, 61.000 burros, y 32.000 muchachas vírgenes. ");
INSERT INTO spaonbv_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","40","La parte entregada al ejército sumó: 337.500 ovejas, (675 fueron entregadas a el Señor), 36.000 bueyes (72 fueron entregados a el Señor); 30.500 burros (61 fueron entregados a el Señor); 16.000 muchachas (32 fueron entregadas al Señor). ");
INSERT INTO spaonbv_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Todo lo que correspondía a la porción del Señor fue entregado a Eleazar el sacerdote conforme a las instrucciones dadas a Moisés. ");
INSERT INTO spaonbv_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","46","La mitad del botín que le correspondía al resto del pueblo fue de: 337.500 ovejas, 36.000 bueyes, 30.500 burros, y 16.000 muchachas. ");
INSERT INTO spaonbv_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","En conformidad con las órdenes del Señor, Moisés dio el dos por ciento de todo a los levitas. ");
INSERT INTO spaonbv_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Entonces los oficiales y los comandantes de batallones se acercaron a Moisés y le dijeron: ");
INSERT INTO spaonbv_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","«Hemos pasado lista a los hombres que salieron a la batalla, y ninguno de nosotros falta. ");
INSERT INTO spaonbv_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Por lo tanto hemos traído al Señor una ofrenda tomada de nuestro botín para que nos perdone todos nuestros pecados: oro, joyas, brazaletes, anillos, aros y collares». ");
INSERT INTO spaonbv_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","52","Moisés y Eleazar el sacerdote recibieron esta ofrenda especial de los capitanes y comandantes de batallones y encontraron que el valor era de unos doscientos kilos de oro. ");
INSERT INTO spaonbv_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","(Los soldados habían reservado el botín que a cada cual correspondía). ");
INSERT INTO spaonbv_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","La ofrenda fue llevada al santuario y quedó delante del Señor como memoria del pueblo de Israel. ");
INSERT INTO spaonbv_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Cuando Israel llegó a la tierra de Jazer y Galaad, las tribus de Rubén y Gad (que tenían grandes rebaños de ovejas) notaron que era un país hermoso para el pastoreo, ");
INSERT INTO spaonbv_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","y se presentaron ante Moisés, Eleazar el sacerdote y los demás jefes de las tribus y dijeron: ");
INSERT INTO spaonbv_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","―El Señor ha usado a Israel para destruir a los pueblos de todo el país: Atarot, Dibón, Jazer, Nimrá, Hesbón, Elalé, Sebán, Nebo y Beón. ");
INSERT INTO spaonbv_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","Es una excelente tierra para el pastoreo, ideal para nuestros ganados. ");
INSERT INTO spaonbv_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Permítasenos tener esta tierra como porción nuestra en vez de tener parte al otro lado del río Jordán. ");
INSERT INTO spaonbv_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","―¿Quieren decir que desean establecerse aquí, mientras sus hermanos van al otro lado del Jordán y realizan la conquista? —preguntó Moisés—. ");
INSERT INTO spaonbv_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","¿Están tratando de desalentar al resto del pueblo para que no pase al otro lado, a la tierra que el Señor les ha dado? ");
INSERT INTO spaonbv_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Esto es lo mismo que hicieron sus padres. Los envié desde Cades a explorar la tierra, ");
INSERT INTO spaonbv_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","pero cuando acabaron la investigación y regresaron del valle de Escol, desalentaron al pueblo, y este no quiso entrar en la Tierra prometida. ");
INSERT INTO spaonbv_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Entonces la ira del Señor se encendió en contra de ellos, ");
INSERT INTO spaonbv_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","y juró que de los que habían salido de Egipto, ninguno que tuviera más de veinte años entraría en la Tierra que había prometido a Abraham, Isaac y Jacob, porque se habían negado a hacer la voluntad del Señor. ");
INSERT INTO spaonbv_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","Las únicas excepciones fueron Caleb (hijo de Jefone el cenezeo), y Josué (hijo de Nun), porque de todo corazón siguieron al Señor. ");
INSERT INTO spaonbv_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Entonces el Señor hizo que regresáramos y peregrináramos por el desierto durante cuarenta años hasta que toda la generación perversa hubo muerto. ");
INSERT INTO spaonbv_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","»Y ahora ustedes, descendientes de tales pecadores, pretenden hacer lo mismo. De modo que la ira del Señor se encenderá contra Israel con mayor furor esta vez. ");
INSERT INTO spaonbv_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Si ustedes se apartan de Dios de esta manera, él hará que el pueblo esté más tiempo en el desierto, y ustedes serán los culpables de la destrucción de este pueblo y de haber traído el desastre sobre toda la nación. ");
INSERT INTO spaonbv_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","―De ninguna manera —explicaron ellos—. Queremos construir rediles para nuestros ganados y ciudades para nuestros pequeños, ");
INSERT INTO spaonbv_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","pero nosotros iremos con nuestras armas adelante del resto del pueblo de Israel hasta que hayamos tomado posesión de la herencia que a ellos les corresponde. Pero primero necesitamos construir ciudades amuralladas para nuestras familias, para que ellos estén a salvo de los ataques de los habitantes de los alrededores. ");
INSERT INTO spaonbv_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","No nos estableceremos aquí hasta que el pueblo de Israel haya recibido el total de su heredad. ");
INSERT INTO spaonbv_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","No queremos tierra en la otra orilla del Jordán. Más bien la queremos a este lado, en la ribera oriental. ");
INSERT INTO spaonbv_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Entonces Moisés dijo: ―De acuerdo. Hagan lo que prometen y vayan a hacer la guerra, ");
INSERT INTO spaonbv_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","y crucen con sus soldados al otro lado del Jordán hasta que el Señor haya expulsado a todos los enemigos, ");
INSERT INTO spaonbv_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","y cuando la tierra finalmente haya sido sometida al Señor, quedarán libres del deber delante del Señor y delante del resto del pueblo de Israel, y la tierra de la orilla oriental será de ustedes ante el Señor. ");
INSERT INTO spaonbv_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","»Pero si no cumplen lo que han prometido, pecarán contra el Señor, y pagarán las consecuencias. ");
INSERT INTO spaonbv_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Vayan y edifiquen ciudades para sus familias y rediles para sus rebaños. Hagan todo lo que han dicho. ");
INSERT INTO spaonbv_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","―Seguiremos tus instrucciones al pie de la letra —respondieron los descendientes de Gad y Rubén—. ");
INSERT INTO spaonbv_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Nuestros hijos, nuestras esposas, los rebaños y el ganado quedarán aquí en las ciudades de Galaad. ");
INSERT INTO spaonbv_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","Pero todos nosotros nos alistaremos para ir a pelear por el Señor como tú lo has dicho. ");
INSERT INTO spaonbv_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Entonces Moisés les dijo a Eleazar, a Josué y a los jefes de las tribus de Israel: ");
INSERT INTO spaonbv_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","―Si todos estos hombres de las tribus de Gad y Rubén que se han alistado para pelear las batallas del Señor van con ustedes al otro lado del Jordán, recibirán la tierra cuando termine la conquista. ");
INSERT INTO spaonbv_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Pero si se niegan a acompañarlos deben aceptar un terreno entre los demás en la tierra de Canaán. ");
INSERT INTO spaonbv_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Las tribus de Gad y Rubén dijeron entonces: ―Haremos como el Señor ha ordenado. ");
INSERT INTO spaonbv_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Seguiremos al Señor armados y entraremos en la tierra de Canaán, pero nuestra tierra estará aquí, en este lado del Jordán. ");
INSERT INTO spaonbv_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Entonces Moisés asignó el territorio de Sijón rey de los amorreos y del rey Og de Basán, incluso sus ciudades, a las tribus de Gad, Rubén y Manasés (hijo de José). ");
INSERT INTO spaonbv_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","36","El pueblo de Gad construyó las siguientes ciudades: Dibón, Atarot, Aroer, Atarot Sofán, Jazer, Yogbea, Bet Nimrá y Bet Arán. Todas estas eran ciudades fortificadas y tenían rediles para las ovejas. ");
INSERT INTO spaonbv_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Los hijos de Rubén edificaron las siguientes ciudades: Hesbón, Elealé, Quiriatayim, ");
INSERT INTO spaonbv_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Nebo, Baal Megón y Sibma. (Los israelitas después cambiaron los nombres de algunas de estas ciudades que habían conquistado y reconstruido). ");
INSERT INTO spaonbv_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","El clan de Maquir de la tribu de Manasés fue a Galaad y la conquistó, y expulsó a los amorreos que vivían allí. ");
INSERT INTO spaonbv_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Moisés, entonces, dio Galaad a los maquiritas. ");
INSERT INTO spaonbv_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Los hombres de Yaír, otro clan de la tribu de Manasés, ocuparon varias de las ciudades de Galaad; y le cambiaron el nombre a la región y le pusieron Javot Yaír. ");
INSERT INTO spaonbv_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Mientras tanto un hombre llamado Noba, fue y tomó a Quenat y sus pueblos, y los ocupó, y la región se llamó Noba. ");
INSERT INTO spaonbv_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Este es el itinerario que Israel siguió desde que Moisés y Aarón lo sacaron de Egipto. ");
INSERT INTO spaonbv_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Moisés anotó las etapas del viaje en la forma que el Señor le había ordenado. ");
INSERT INTO spaonbv_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","4","Salieron de la ciudad de Ramsés en Egipto el primero de abril, el día siguiente de la noche de la Pascua. Salieron con orgullo, a instancias de los egipcios que estaban sepultando a los primogénitos que el Señor había matado la noche anterior. El Señor ciertamente había derrotado a todos los dioses de Egipto aquella noche. ");
INSERT INTO spaonbv_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","6","Después de salir de Ramsés, acamparon en Sucot, en Etam (el límite del desierto), y ");
INSERT INTO spaonbv_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","en Pit Ajirot (cerca de Baal Zefón donde acamparon al pie del monte Migdol). ");
INSERT INTO spaonbv_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Desde allí cruzaron en seco el Mar Rojo y durante tres días se internaron en el desierto de Etam, acampando luego en Mara. ");
INSERT INTO spaonbv_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Salieron de Mara y acamparon en Elim donde había doce fuentes de agua y setenta palmeras. ");
INSERT INTO spaonbv_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Saliendo de Elim acamparon junto al Mar Rojo, ");
INSERT INTO spaonbv_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","y luego en el desierto de Sin. ");
INSERT INTO spaonbv_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","De allí llegaron hasta Dofcá, ");
INSERT INTO spaonbv_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","y luego acamparon en Alús. ");
INSERT INTO spaonbv_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Siguieron después a Refidín (donde no había agua para que el pueblo bebiera). ");
INSERT INTO spaonbv_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","37","Desde Refidín siguieron hasta el desierto de Sinaí; desde el desierto de Sinaí a Quibrot Jatavá; de Quibrot Jatavá a Jazerot; de Jazerot a Ritma; de Ritma a Rimón Peres; de Rimón Peres a Libná; de Libná a Risá; de Risá a Celata; de Celata al monte de Sefér; del monte de Sefér a Jaradá; de Jaradá a Maquelot: de Maquelot a Tajat; de Tajat a Téraj; de Téraj a Mitca; de Mitca a Jasmoná; de Jasmoná a Moserot; de Moserot a Bené Yacán; de Bené Yacán al monte de Gidgad; del monte de Gidgad a Jotbata; de Jotbata a Abroná; de Abroná a Ezión Guéber; de Ezión Guéber a Cades (en el desierto de Zin); de Cades al monte Hor (junto a la tierra de Edom). ");
INSERT INTO spaonbv_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","39","Mientras estaban al pie del monte Hor, Dios le ordenó a Aarón el sacerdote que subiera a la montaña, y allí murió. Esto ocurrió en el año cuarenta después de la salida del pueblo de Israel de Egipto. La fecha de su muerte fue el quince de julio, cuando tenía ciento veintitrés años. ");
INSERT INTO spaonbv_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Estando allí, el rey cananeo de Arad, que vivía en el Néguev, en la tierra de Canaán, oyó que el pueblo de Israel se acercaba a su tierra. ");
INSERT INTO spaonbv_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Luego los israelitas viajaron del monte de Hor hasta Zalmona, ");
INSERT INTO spaonbv_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","de allí a Punón, ");
INSERT INTO spaonbv_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","de Punón a Obot, ");
INSERT INTO spaonbv_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","de Obot a Iyé Abarín (en la frontera con Moab), ");
INSERT INTO spaonbv_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","de Iyé Abarín a Dibón Gad, ");
INSERT INTO spaonbv_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","y luego acamparon en Almón Diblatayin. ");
INSERT INTO spaonbv_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","De allí siguieron hasta los montes de Abarín delante del monte Nebo, ");
INSERT INTO spaonbv_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","y finalmente llegaron a la llanura de Moab junto al río Jordán, frente a Jericó. ");
INSERT INTO spaonbv_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Mientras estaban en esta zona acamparon en varios lugares a lo largo del río Jordán desde Bet Yesimot hasta Abel Sitín en las llanuras de Moab. ");
INSERT INTO spaonbv_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Estando acampados allí, el Señor le pidió a Moisés que dijera al pueblo de Israel: ");
INSERT INTO spaonbv_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","«Cuando hayan pasado el río Jordán, y hayan entrado en la tierra de Canaán, ");
INSERT INTO spaonbv_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","expulsarán a todos los pueblos que viven allí y destruirán sus ídolos esculpidos en piedra, sus imágenes fundidas y los santuarios hechos al aire libre en las colinas. ");
INSERT INTO spaonbv_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Yo les he entregado la tierra. Tómenla y vivan en ella. ");
INSERT INTO spaonbv_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Recibirán tierra en proporción al tamaño de cada tribu. Las zonas más grandes de la tierra serán sorteadas entre las tribus mayores, y las zonas menores serán asignadas por suertes a las tribus menores. ");
INSERT INTO spaonbv_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","»Pero si no expulsan a los pueblos que viven allí; los que queden les molestarán como arena en los ojos y espinas en los costados. ");
INSERT INTO spaonbv_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Entonces yo los destruiré a ustedes en vez de destruirlos a ellos». ");
INSERT INTO spaonbv_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","El Señor le dijo a Moisés: ");
INSERT INTO spaonbv_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","«Dile al pueblo de Israel que cuando entre en la tierra de Canaán, que le daré como patria, ");
INSERT INTO spaonbv_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","en el extremo sur del país estará el desierto de Zin hasta la frontera de Edom; ese será el límite sur que comenzará en el Mar Muerto, ");
INSERT INTO spaonbv_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","y continuará hacia el sur hasta la subida de Acrabim (Paso escorpión) y seguirá hasta Zin. El punto más austral será Cades Barnea, desde donde seguirá hasta Jasar Adar, y desde allí hasta Asmón. ");
INSERT INTO spaonbv_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","Desde Asmón el límite seguirá a lo largo del Wadi el Aris (Torrente de Egipto), hasta el mar Mediterráneo. ");
INSERT INTO spaonbv_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","»El límite occidental será el mar Mediterráneo. ");
INSERT INTO spaonbv_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","9","»La frontera norte comenzará en el mar Mediterráneo y seguirá hacia el oriente hasta el monte de Hor, desde donde seguirá hasta la entrada de Jamat, y de allí a través de Zedad y Zifón hasta Jazar Enán. ");
INSERT INTO spaonbv_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","11","»El límite oriental irá desde Jazar Enán hacia el sur hasta Sefam, y de allí hasta Riblá al lado oriental de Ayín. Desde allí hará un gran semicírculo primero hacia el sur, luego hacia el occidente, hasta tocar el extremo sur del mar de Galilea, ");
INSERT INTO spaonbv_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","y entonces seguirá a lo largo del río Jordán para terminar en el Mar Muerto. Estos serán los límites de la tierra. ");
INSERT INTO spaonbv_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","»Este es el territorio que dividirán entre ustedes; se dividirá entre las nueve tribus y media, ");
INSERT INTO spaonbv_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","15","porque las tribus de Rubén y Gad y la media tribu de Manasés ya tienen tierra asignada en el lado oriental del río Jordán, frente a Jericó». ");
INSERT INTO spaonbv_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","28","Y el Señor le dijo a Moisés: ―Estos son los nombres de los hombres que he elegido para que dirijan la repartición de tierra: el sacerdote Eleazar, Josué (hijo de Nun) y un jefe de cada tribu que serán los siguientes: Tribu Jefe Judá Caleb (hijo de Jefone) Simeón Samuel (hijo de Amiud) Benjamín Elidad (hijo de Quislón) Dan Buquí (hijo de Joglí) Manasés Janiel (hijo de Efod) Efraín Quemuel (hijo de Siftán) Zabulón Elizafán (hijo de Parnac) Isacar Paltiel (hijo de Azán) Aser Ajiud (hijo de Selomí) Neftalí Pedael (hijo de Amiud) ");
INSERT INTO spaonbv_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Estos son los hombres que he designado para que vigilen la repartición de tierra entre las tribus. ");
INSERT INTO spaonbv_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Mientras Israel estaba acampando junto al Jordán en las llanuras de Moab, frente a Jericó, el Señor le dijo a Moisés: ");
INSERT INTO spaonbv_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","«Ordena a todo Israel que dé como herencia a los levitas ciertas ciudades y las tierras de pastoreo que las rodean. ");
INSERT INTO spaonbv_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Estas ciudades son para habitar, y las tierras circundantes son para el ganado, las ovejas y otros animales que puedan poseer. ");
INSERT INTO spaonbv_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","Las tierras de pastoreo estarán inmediatamente a continuación de los muros de la ciudad y será una franja de cuatrocientos cincuenta metros en torno a la ciudad, ");
INSERT INTO spaonbv_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","De este modo el diámetro de la ciudad se verá aumentado en novecientos metros. ");
INSERT INTO spaonbv_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","»Asignarán a los levitas cuarenta y ocho ciudades, seis de las cuales serán ciudades de refugio. En ellas podrá refugiarse cualquier persona que haya dado muerte a otra en forma accidental. ");
INSERT INTO spaonbv_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","En total serán cuarenta y ocho las ciudades que se darán a los levitas con sus correspondientes tierras de pastoreo. ");
INSERT INTO spaonbv_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Estas ciudades estarán distribuidas en diversos lugares de la nación. Las tribus más grandes, que tienen muchas ciudades, darán más ciudades a los levitas, mientras que las tribus más pequeñas les darán menos ciudades». ");
INSERT INTO spaonbv_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Y el Señor le dijo a Moisés: ");
INSERT INTO spaonbv_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","«Dile al pueblo que cuando entre en la tierra, ");
INSERT INTO spaonbv_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","se designarán ciudades de refugio a fin de que se ponga a salvo en ellas cualquiera que haya dado muerte a otro en forma accidental. ");
INSERT INTO spaonbv_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Estas ciudades serán lugares de protección donde el homicida accidental pueda protegerse del que quiera vengar al muerto. El homicida no podrá ser ejecutado sino hasta que se le haya seguido un juicio justo y se haya establecido su culpa. ");
INSERT INTO spaonbv_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","14","Tres de estas ciudades de refugio estarán en la tierra de Canaán, y tres en el lado oriental del río Jordán. ");
INSERT INTO spaonbv_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Estas no sólo servirán de protección a los israelitas sino también a los extranjeros y a los viajeros. ");
INSERT INTO spaonbv_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","»Pero si alguien es golpeado y muerto con un instrumento de hierro, debe presumirse que hubo asesinato, y el homicida deberá ser ejecutado. ");
INSERT INTO spaonbv_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Si el hombre murió porque lo golpearon con una piedra grande, se trata de un asesinato, y el asesino debe morir. ");
INSERT INTO spaonbv_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Lo mismo es válido si alguien es muerto con un arma de madera. ");
INSERT INTO spaonbv_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","El vengador de la sangre personalmente dará muerte al asesino cuando lo encuentre. ");
INSERT INTO spaonbv_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Si alguno da muerte a otro por odio arrojándole algo, poniéndole emboscada o ");
INSERT INTO spaonbv_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","golpeándole con el puño hasta darle muerte; es un asesino. El asesino será ejecutado por el vengador de la sangre cuando lo hallare. ");
INSERT INTO spaonbv_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","23","»Pero si se trata de un accidente, de un caso en que alguien arroja una piedra y sin querer golpea y mata a quien no era su enemigo, ");
INSERT INTO spaonbv_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","el pueblo juzgará si hay que entregar o no al homicida en manos del vengador de la sangre. ");
INSERT INTO spaonbv_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Si se llega a conclusión de que la muerte fue accidental, el pueblo protegerá al homicida para que no caiga en manos del vengador de la sangre. El homicida será residente permanente de la ciudad de refugio. Vivirá allí hasta la muerte del sumo sacerdote. ");
INSERT INTO spaonbv_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","»Si el homicida sale de la ciudad, ");
INSERT INTO spaonbv_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","y el vengador lo encuentra fuera de ella y le da muerte, no es un asesinato, ");
INSERT INTO spaonbv_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","porque el hombre debió haber permanecido dentro de la ciudad hasta la muerte del sumo sacerdote. Pero después de la muerte del sumo sacerdote, el hombre puede volver a su tierra y a su hogar. ");
INSERT INTO spaonbv_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","Estas son leyes permanentes para todo Israel de generación en generación. ");
INSERT INTO spaonbv_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","»Todos los homicidas serán ejecutados, pero solamente si hay más de un testigo. Ningún hombre podrá ser ejecutado por el testimonio de una sola persona. ");
INSERT INTO spaonbv_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","Cualquiera que sea declarado culpable de asesinato, debe morir, y no se aceptará rescate por él. ");
INSERT INTO spaonbv_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Tampoco se podrá aceptar que un refugiado en una de estas ciudades pague para que se le permita regresar a su hogar antes de la muerte del sumo sacerdote. ");
INSERT INTO spaonbv_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","Mediante el cumplimiento de estas normas la tierra no se contaminará, porque el asesinato contamina la tierra, y no se puede hacer reparación por la muerte de una persona sino por la ejecución del asesino. ");
INSERT INTO spaonbv_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","No contaminen la tierra donde van a vivir, porque yo, el Señor, viviré allí entre ustedes». ");
INSERT INTO spaonbv_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Entonces los dirigentes del subclan de Galaad (el clan de Maquir, de la tribu de Manasés, uno de los hijos de José) vinieron a Moisés ante los jefes de Israel con una petición: ");
INSERT INTO spaonbv_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","―El Señor dio orden de repartir la tierra por sorteo entre el pueblo de Israel —le recordaron a Moisés—, y que se diera la heredad de nuestro hermano Zelofejad a sus hijas. ");
INSERT INTO spaonbv_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Pero si ellas se casan en otra tribu, la tierra de ellas pasará a la tribu de su marido. De esta manera nuestra tierra se verá reducida, ");
INSERT INTO spaonbv_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","y no regresará a nosotros en el año del jubileo. ");
INSERT INTO spaonbv_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Moisés contestó públicamente, dando estas órdenes de parte del Señor: ―Los hombres de la tribu de José tienen una queja justa. ");
INSERT INTO spaonbv_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Esto es lo que el Señor ha ordenado acerca de las hijas de Zelofejad: ");
INSERT INTO spaonbv_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","Pueden casarse con quienes quieran, siempre que sea dentro de su tribu. De esta manera, ninguna parte de la tierra de su tribu pasará a otra tribu, ya que la tierra debe pertenecer permanentemente a la tribu a la que fue asignada en el principio. ");
INSERT INTO spaonbv_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Las jóvenes de las tribus de Israel que pertenezcan a una familia que esté sin heredero varón, deberán casarse dentro de su propia tribu, para que la tierra no salga de la tribu. ");
INSERT INTO spaonbv_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","De este modo, la tierra no pasará de una tribu a otra». ");
INSERT INTO spaonbv_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Las hijas de Zelofejad hicieron lo que el Señor le había ordenado a Moisés. ");
INSERT INTO spaonbv_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","Estas eran: Majlá, Tirsá, Joglá, Milca y Noa, y se casaron con hombres de su propia tribu de Manasés (hijo de José). ");
INSERT INTO spaonbv_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","De este modo la tierra de ellas permaneció en la tribu. ");
INSERT INTO spaonbv_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Estos son los mandamientos y las ordenanzas que el Señor le dio al pueblo de Israel por medio de Moisés, mientras estaban acampados en las llanuras de Moab junto al río Jordán, frente a Jericó.");
INSERT INTO spaonbv_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Este libro registra las palabras que Moisés dirigió al pueblo de Israel cuando estaba acampado en el valle del Arabá en el desierto de Moab, al oriente del río Jordán. Las ciudades que había en la zona eran Parán, Tofel, Labán, Jazerot y Dizahab. ");
INSERT INTO spaonbv_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","3","Las palabras fueron pronunciadas el primer día del mes undécimo; habían pasado cuarenta años desde el momento en que el pueblo de Israel dejó el monte Horeb (aunque el viaje a pie desde el monte Horeb hasta Cades Barnea normalmente solo dura once días, siguiendo la vía del monte Seír). ");
INSERT INTO spaonbv_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Sijón, rey de los amorreos, había sido ya derrotado en Hesbón y el rey Og de Basán había sido derrotado en Astarot, cerca de Edrey. ");
INSERT INTO spaonbv_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Estas, pues, son las palabras que Moisés declaró ante el pueblo de Israel: ");
INSERT INTO spaonbv_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","«Hace cuarenta años, junto al monte Horeb, el Señor, nuestro Dios, nos dijo: “Ya han estado aquí largo tiempo. ");
INSERT INTO spaonbv_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Vayan ahora y ocupen la región montañosa de los amorreos, el valle del Arabá, el Néguev, y toda la tierra de Canaán y el Líbano: toda el área desde las costas del mar Mediterráneo hasta el río Éufrates. ");
INSERT INTO spaonbv_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Yo se la doy a ustedes. Entren y poséanla, porque es la tierra que el Señor prometió a sus antepasados Abraham, Isaac y Jacob, y a todos sus descendientes”. ");
INSERT INTO spaonbv_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","»En aquel tiempo le dije al pueblo: “Ayúdenme. Ustedes son una gran carga para que yo la lleve solo, ");
INSERT INTO spaonbv_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","porque el Señor nos ha multiplicado como las estrellas. ");
INSERT INTO spaonbv_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Quiera él multiplicarnos mil veces más y bendecirnos como ha prometido. ");
INSERT INTO spaonbv_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Pero ¿qué puede hacer un hombre solo para resolver las dificultades, los pleitos y los problemas que hay entre ustedes? ");
INSERT INTO spaonbv_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Elijan, pues, hombres de cada tribu que sean sabios, experimentados y entendidos, y yo los pondré como jefes”. ");
INSERT INTO spaonbv_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","»Ellos estuvieron de acuerdo con esto. ");
INSERT INTO spaonbv_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Entonces tomé los hombres que eligieron, varios de cada tribu, y los señalé como jefes administrativos a cargo de mil, de cien, de cincuenta y de diez para decidir en sus dificultades y ayudarles en todo. ");
INSERT INTO spaonbv_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","Les di órdenes de que fueran perfectamente justos en todo tiempo con sus hermanos y aun con los extranjeros. ");
INSERT INTO spaonbv_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","“Cuando tomen decisiones”, les dije; “no favorezcan a un hombre porque sea rico; sean justos con el grande y con el pequeño. No teman si a ellos no les agrada el fallo de ustedes, porque ustedes son jueces en el nombre de Dios. Los casos demasiado difíciles tráiganmelos a mí, y yo los resolveré”. ");
INSERT INTO spaonbv_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","Les di además varias otras instrucciones para ustedes. ");
INSERT INTO spaonbv_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","21","»Luego nos alejamos del monte Horeb y viajamos a través del desierto grande y terrible, y llegamos finalmente a las montañas de los amorreos a las cuales el Señor nuestro Dios nos había dirigido. Estábamos entonces en Cades Barnea (en el límite con la Tierra prometida) y le dije al pueblo: “El Señor, el Dios de nuestros antepasados, nos ha dado esta tierra. Vayan y poséanla como él nos ha dicho. No teman, ni duden”. ");
INSERT INTO spaonbv_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","»Pero los israelitas replicaron: “Deja que primero enviemos espías para descubrir el mejor camino de entrada y para decidir qué ciudades debemos capturar en primer lugar”. ");
INSERT INTO spaonbv_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","»Esto me pareció bien, por lo que elegí doce espías, uno de cada tribu. ");
INSERT INTO spaonbv_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","25","Los espías cruzaron las colinas y llegaron al valle de Escol, y volvieron con muestras de las frutas que allí se producían. Una sola mirada bastó para convencernos de que la tierra que el Señor nos había dado era una tierra buena. ");
INSERT INTO spaonbv_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","»Pero el pueblo no quiso entrar y se rebeló contra el mandamiento del Señor. ");
INSERT INTO spaonbv_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","Todos a una sola voz murmuraron y se quejaron en sus tiendas y dijeron: “El Señor debe aborrecernos pues nos ha sacado de Egipto para ser asesinados en el desierto por estos amorreos. ");
INSERT INTO spaonbv_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","¿A dónde vamos a entrar? Nuestros hermanos que han visitado la tierra nos han atemorizado con todo lo que nos contaron. Dicen que la gente de esa tierra es alta y fuerte, y que los muros de sus ciudades llegan hasta el cielo. Por si fuera poco, han visto gigantes allí: los descendientes de Anac”. ");
INSERT INTO spaonbv_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","»Pero yo les dije: “No teman. ");
INSERT INTO spaonbv_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","El Señor nuestro Dios irá delante, y peleará por ustedes como lo hizo en Egipto. ");
INSERT INTO spaonbv_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","Él nos ha cuidado en nuestra peregrinación por el desierto de la manera que un padre cuida a sus hijos”. ");
INSERT INTO spaonbv_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","Pero nada de lo que les dije los convenció. No quisieron creer al Señor nuestro Dios, ");
INSERT INTO spaonbv_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","quien los había guiado por el camino y había elegido los mejores lugares para que acamparan, y los había guiado con una columna de fuego por la noche y una columna de nubes durante el día. ");
INSERT INTO spaonbv_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","»El Señor oyó la queja de los israelitas y se enojó. ");
INSERT INTO spaonbv_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","Juró que nadie de esa generación viviría para ver las bondades de la tierra que había prometido a sus antepasados. ");
INSERT INTO spaonbv_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","Caleb (hijo de Jefone) es el único que, por haber confiado completamente en el Señor, recibirá, para él y sus descendientes, como heredad personal parte de la tierra sobre la cual había andado. ");
INSERT INTO spaonbv_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","»Y el Señor también se enojó conmigo por causa del pueblo, y me dijo: “Tampoco tú entrarás en la Tierra prometida. ");
INSERT INTO spaonbv_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Josué (el hijo de Nun), tu ayudante, guiará a tu pueblo hacia ella. Anímale mientras se prepara para tomar el mando. ");
INSERT INTO spaonbv_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","La tierra se la entregaré a la nueva generación, a aquellos que según sus padres iban a morir en el desierto y todos los pequeños quienes todavía no saben distinguir entre lo bueno y lo malo. ");
INSERT INTO spaonbv_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","Por eso se dirigió a los de la antigua generación y les dijo: Ya que así lo desean, ¡regresen al desierto, camino del Mar Rojo!”. ");
INSERT INTO spaonbv_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","»Entonces ellos confesaron: “Hemos pecado; entraremos en la tierra y pelearemos por ella como el Señor nuestro Dios nos ha dicho”. Se armaron, pues, pensando que sería fácil conquistar la región. ");
INSERT INTO spaonbv_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","Pero el Señor me dijo: “Ordénales que no lo hagan, porque no iré con ellos; ¡serán derrotados!”. ");
INSERT INTO spaonbv_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","»Pero los israelitas no quisieron escuchar. En abierta rebelión contra el mandato del Señor, subieron a los montes a pelear. ");
INSERT INTO spaonbv_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Pero los amorreos que vivían allí salieron a presentarles batalla y, como avispas, los persiguieron desde Seír hasta Jormá y mataron a muchos de ellos. ");
INSERT INTO spaonbv_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Luego regresaron y lloraron delante del Señor, pero no los escuchó. ");
INSERT INTO spaonbv_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","Tuvieron que permanecer en Cades largo tiempo. ");
INSERT INTO spaonbv_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","»Luego regresamos al desierto camino del Mar Rojo, como me había ordenado el Señor. Durante muchos años vagamos por los alrededores del monte Seír, ");
INSERT INTO spaonbv_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","hasta que al fin el Señor dijo: ");
INSERT INTO spaonbv_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","“Ya han permanecido demasiado tiempo en este monte. Vuelvan al norte. ");
INSERT INTO spaonbv_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","Informa al pueblo que pasarán por el territorio de sus hermanos los edomitas, descendientes de Esaú, que viven en Seír; los edomitas sentirán temor, de modo que ¡cuidado! ");
INSERT INTO spaonbv_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","No presenten batalla. Yo les he dado a ellos el monte Seír como posesión permanente, y no les daré a ustedes nada que les pertenezca a ellos. ");
INSERT INTO spaonbv_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Páguenles el alimento y el agua que consuman. ");
INSERT INTO spaonbv_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","El Señor, el Dios de ustedes, los ha cuidado y bendecido durante los cuarenta años que han peregrinado en este gran desierto, y nada les ha faltado durante todo este tiempo”. ");
INSERT INTO spaonbv_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","»Así fue que pasamos a través de Edom, territorio de nuestros hermanos los hijos de Esaú, cruzamos el camino del Arabá que va hacia el sur a Elat y Ezión Guéber, y tomamos rumbo al norte, hacia el desierto de Moab. ");
INSERT INTO spaonbv_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","Entonces el Señor me advirtió: “No ataques ni provoques a los moabitas, porque yo no les daré a ustedes la tierra de ellos, la región de Ar; la he dado a los descendientes de Lot”. ");
INSERT INTO spaonbv_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","»(Los emitas habían habitado antes aquella zona. Eran una tribu grande y poderosa, de hombres altos como los gigantes de Anac; ");
INSERT INTO spaonbv_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","a los emitas y a los anaceos se les suele llamar refaítas, pero los moabitas los llaman emitas. ");
INSERT INTO spaonbv_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","Anteriormente los horeos vivían en Seír, pero fueron desplazados por las edomitas, los descendientes de Esaú, tal como Israel desplazará a los pueblos de Canaán, cuya tierra ha sido asignada a Israel por el Señor). ");
INSERT INTO spaonbv_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","“Crucen ahora el arroyo de Zéred”, dijo el Señor, y así lo hicimos. ");
INSERT INTO spaonbv_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","»Habían pasado treinta y ocho años desde que salimos de Cades hasta que cruzamos por fin el arroyo de Zéred, porque el Señor había decretado que no cruzaríamos el arroyo hasta que hubieran muerto todos los hombres que hacía treinta y ocho años tenían edad suficiente para llevar armas. ");
INSERT INTO spaonbv_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","16","Sí, la mano del Señor estuvo contra ellos hasta que todos murieron. ");
INSERT INTO spaonbv_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","»Finalmente el Señor me dijo: ");
INSERT INTO spaonbv_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","“Hoy cruzará Israel los limites de Moab en Ar ");
INSERT INTO spaonbv_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","para entrar a la tierra de Amón. Pero no los ataques ni provoques, porque yo no te daré su tierra. La he dado a los descendientes de Lot”. ");
INSERT INTO spaonbv_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","(Aquella zona también estaba habitada por unos gigantes que los amonitas llamaban zamzumitas. ");
INSERT INTO spaonbv_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","Eran una tribu grande y poderosa, de hombres tan altos como los anaceos. Pero el Señor los destruyó cuando los amonitas entraron en esa tierra y vivieron allí en su lugar. ");
INSERT INTO spaonbv_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","El Señor igualmente había ayudado a los descendientes de Esaú en el monte Seír destruyendo a los horeos que vivían allí antes que ellos. ");
INSERT INTO spaonbv_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","Una situación similar se produjo cuando el pueblo de Caftor invadió y destruyó la tribu de los aveos que vivían en pueblos esparcidos en toda aquella zona hasta Gaza). ");
INSERT INTO spaonbv_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","»Y el Señor dijo: “Pasen el río Arnón y entren en la tierra de Sijón, rey amorreo de Hesbón. Háganle guerra y tomen posesión de su tierra. ");
INSERT INTO spaonbv_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","A partir de hoy haré que todos los pueblos de esta tierra tiemblen de temor delante de ustedes y sientan angustia ante su llegada”. ");
INSERT INTO spaonbv_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","»No obstante; envié mensajeros desde el desierto de Cademot al rey Sijón en Hesbón, con una propuesta de paz. ");
INSERT INTO spaonbv_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","“Pasaremos por tu tierra”, le dijimos. “Nos mantendremos en el camino real y no entraremos a tus campos a ninguno de los dos lados. ");
INSERT INTO spaonbv_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","No robaremos alimento mientras cruzamos, sino que pagaremos por todo lo que comamos y todo lo que bebamos. Lo único que queremos es el permiso para pasar por ella. ");
INSERT INTO spaonbv_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","Los edomitas en Seír nos permitieron pasar por su país; lo mismo hicieron los moabitas, cuya capital es Ar. Queremos cruzar el Jordán para entrar en la tierra que el Señor, nuestro Dios, nos ha dado”. ");
INSERT INTO spaonbv_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","»Pero el rey Sijón se negó, porque el Señor nuestro Dios hizo que se endureciera, para poder destruir a Sijón con las manos de Israel como ahora ya lo ha hecho. ");
INSERT INTO spaonbv_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","»Y el Señor me dijo: “He comenzado a darles la tierra del rey Sijón. Cuando tomen posesión de ella, pertenecerá para siempre a Israel”. ");
INSERT INTO spaonbv_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","»El rey Sijón entonces nos declaró la guerra y movilizó sus fuerzas en Yahaza. ");
INSERT INTO spaonbv_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","34","Pero el Señor, nuestro Dios, lo entregó en nuestras manos y conquistamos todas sus ciudades y destruimos completamente todo, incluyendo mujeres y niños. ");
INSERT INTO spaonbv_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","Nada dejamos con vida salvo el ganado, el que tomamos como botín, juntamente con lo obtenido del saqueo de las ciudades que habíamos tomado. ");
INSERT INTO spaonbv_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","Lo conquistamos todo desde Aroer hasta Galaad, desde la orilla del río Arnón, incluyendo todas las ciudades del valle. Ninguna ciudad tuvo fuerza suficiente para oponérsenos, porque el Señor nuestro Dios las había entregado en nuestras manos. ");
INSERT INTO spaonbv_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","Sin embargo, permanecimos alejados de los amonitas, del río Jaboc y de las ciudades del monte, y de todos los lugares a los que el Señor nuestro Dios nos había prohibido entrar. ");
INSERT INTO spaonbv_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","»Luego seguimos hacia la tierra de Basán. Inmediatamente el rey Og movilizó su ejército y nos atacó en Edrey. ");
INSERT INTO spaonbv_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","Pero el Señor me dijo que no tuviera temor de él. “Todo este pueblo y sus tierras son tuyos”, me dijo. “Tú harás con él como hiciste con el rey Sijón de los amorreos en Hesbón”. ");
INSERT INTO spaonbv_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","Entonces el Señor nos guio en la batalla contra el rey Og y su pueblo, y les dimos muerte a todos. ");
INSERT INTO spaonbv_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","Conquistamos todas sus ciudades, en total sesenta, toda la región de Argob, del reino de Og en Basán. ");
INSERT INTO spaonbv_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","Estas eran ciudades muy fortificadas, con muros muy altos y puertas con barras. Tomamos también las ciudades no amuralladas. ");
INSERT INTO spaonbv_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","Destruimos completamente el reino de Basán del mismo modo que lo hicimos con el reino de Sijón en Hesbón, dando muerte a toda la población: hombres, mujeres y niños. ");
INSERT INTO spaonbv_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","Pero conservamos el ganado y el botín. ");
INSERT INTO spaonbv_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","»Quedamos en posesión del territorio de los dos reyes amorreos, al oriente del río Jordán: toda la tierra del valle de Arnón hasta y el monte Hermón ");
INSERT INTO spaonbv_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(los sidonios lo llaman Sirión y los amorreos lo llaman Senir). ");
INSERT INTO spaonbv_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","Habíamos conquistado las ciudades de la meseta y todo Galaad y Basán hasta las ciudades de Salcá y Edrey. ");
INSERT INTO spaonbv_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","»A propósito, el rey Og de Basán fue el último de los gigantes. Su cama de hierro se conserva en un museo de Rabá, una de las ciudades de los amonitas, y mide unos cuatro metros de largo por uno ochenta de ancho. ");
INSERT INTO spaonbv_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","»En aquel tiempo entregué la tierra conquistada a las tribus de Rubén y Gad, y a la media tribu de Manasés. A las tribus de Rubén y Gad les di la región que comenzaba en Aroer sobre el río Arnón, más la mitad del monte Galaad; incluyendo sus ciudades. ");
INSERT INTO spaonbv_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","La media tribu de Manasés recibió el resto de Galaad y todo lo que era el reino de Og en la región de Argob. (Basán es llamada a veces tierra de gigantes). ");
INSERT INTO spaonbv_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","El clan de Yaír, de la tribu de Manasés, tomó toda la región de Argob (Basán) hasta el límite con Gesur y Maaca. Ellos le pusieron su nombre al país y lo llamaron Javot Yaír (Pueblos de Yaír) como se le llama hasta hoy. ");
INSERT INTO spaonbv_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","Entonces le di Galaad a Maquir. ");
INSERT INTO spaonbv_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","Las tribus de Rubén y Gad recibieron la región que se extiende desde el río Jaboc en Galaad (que está en el límite con Amón) hasta el centro del valle del río Arnón. ");
INSERT INTO spaonbv_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","También recibieron el Arabá, con el Jordán como límite al occidente, desde Quinéret hasta el pie del monte Pisgá y el Mar Salado (llamado también mar del Arabá). ");
INSERT INTO spaonbv_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","»En aquella oportunidad les dije a las tribus de Rubén, Gad y de Manasés que aunque el Señor les había dado la tierra, no debían establecerse en ella hasta que sus hombres armados ayudaran a las otras tribus a establecerse al otro lado del Jordán. ");
INSERT INTO spaonbv_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","»“Pero sus mujeres y sus niños”, les dije, “pueden permanecer en las ciudades que Dios les ha dado, cuidando su gran cantidad de ganado, ");
INSERT INTO spaonbv_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","hasta que el Señor haya dado la victoria a las otras tribus. Cuando ellos hayan conquistado las tierras que el Señor les ha dado al otro lado del río Jordán, podrán ustedes regresar a la tierra que les he dado”. ");
INSERT INTO spaonbv_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","»Entonces le dije a Josué: “Tú mismo has sido testigo de lo que el Señor tu Dios ha hecho con estos dos reyes. Ahora tú harás lo mismo con todos los reinos que hay al otro lado del Jordán. ");
INSERT INTO spaonbv_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","No temas a los pueblos que allí viven, porque el Señor tu Dios peleará por ti”. ");
INSERT INTO spaonbv_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","»En aquel tiempo, oré al Señor así: ");
INSERT INTO spaonbv_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","25","“Señor, mi Dios, permíteme entrar en la Tierra prometida; la buena tierra que está al otro lado del Jordán con sus montes, y el Líbano. ¡Soy testigo de tu grandeza y de tu poder! Y tengo la certeza de que no hay ningún dios en los cielos o la tierra que puede hacer todo lo que tú has hecho por nosotros”. ");
INSERT INTO spaonbv_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","»Pero el Señor estaba disgustado conmigo a causa de ustedes y no me dejó cruzar. Al contrario, me calló y me dijo: “No hablemos más de eso. ");
INSERT INTO spaonbv_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","Te ordeno que subas a la cumbre del monte Pisgá, desde donde puedes mirar en todas direcciones, y desde allí verás la tierra. Pero no cruzarás el río Jordán. ");
INSERT INTO spaonbv_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","Comisiona a Josué para que te reemplace. Aliéntalo, porque él hará que este pueblo entre a conquistar el territorio que tú solo verás desde la cumbre del monte”. ");
INSERT INTO spaonbv_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","»De modo que permanecimos en el valle cerca de Bet Peor». ");
INSERT INTO spaonbv_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","Moisés continuó su discurso y dijo: «Escuchen ahora con atención, israelitas, las leyes que les doy y obedézcanlas, si quieren vivir y entrar a poseer la tierra que les da el Señor, Dios de sus padres. ");
INSERT INTO spaonbv_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","No añadan otras leyes ni quiten ninguna de las que ahora les doy. Pónganlas en práctica, porque se las ha dado el Señor su Dios. ");
INSERT INTO spaonbv_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","»Ustedes mismos han sido testigos de lo que el Señor hizo en Baal Peor, donde destruyó a los idólatras, ");
INSERT INTO spaonbv_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","pero dejó con vida a los que de ustedes permanecieron fieles a él. ");
INSERT INTO spaonbv_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","»Estas son las leyes que ustedes deberán obedecer cuando lleguen a la tierra donde vivirán. Han sido dadas por el Señor mi Dios. ");
INSERT INTO spaonbv_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Si las obedecen, obtendrán reputación de sabiduría e inteligencia. Cuando las naciones que los rodeen oigan estas leyes, exclamarán: “¿Qué otra nación es tan sabia y prudente como Israel?”. ");
INSERT INTO spaonbv_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Porque ¿qué otra nación, grande o pequeña, tiene a Dios entre ellos como el Señor nuestro Dios está entre nosotros siempre que lo invocamos? ");
INSERT INTO spaonbv_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","¿Qué nación, no importa cuán grande sea, tiene leyes tan justas como las que les estoy dando hoy? ");
INSERT INTO spaonbv_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","Pero ¡cuidado! No olviden jamás lo que Dios hace por ustedes. Cuenten a sus hijos y a sus nietos los gloriosos milagros que él ha hecho. ");
INSERT INTO spaonbv_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","Cuéntenles especialmente acerca del día en que estuvieron delante del Señor en el monte Horeb, y él me dijo: “Reúne al pueblo delante de mí, y yo les enseñaré, para que aprendan a obedecerme y también para que les enseñen estas leyes a sus hijos”. ");
INSERT INTO spaonbv_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","Ustedes se reunieron al pie del monte y el monte ardía con fuego en medio de la oscuridad, ");
INSERT INTO spaonbv_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","y el Señor les habló desde el fuego. Ustedes oyeron sus palabras y nada más, pero ¡nunca lo vieron! ");
INSERT INTO spaonbv_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","Esa fue la manera con la que Dios proclamó sus leyes que ustedes deben obedecer. Son los Diez Mandamientos, y los escribió en dos tablas de piedra. ");
INSERT INTO spaonbv_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","En aquel tiempo el Señor me ordenó que les entregara las leyes que deben obedecer tan pronto entren en la Tierra prometida. ");
INSERT INTO spaonbv_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","»Pero ¡cuidado! Ustedes no vieron la figura de Dios el día en que les habló desde el fuego en el monte Horeb, ");
INSERT INTO spaonbv_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","17","de modo que no se corrompan tratando de hacer una imagen de Dios, sea en forma de hombre, de mujer, de animal, de ave, ");
INSERT INTO spaonbv_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","de reptil que se arrastre sobre la tierra, o de pez. ");
INSERT INTO spaonbv_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","No levanten la vista a los cielos para adorar al sol, la luna o las estrellas. El Señor le ha tolerado esto a otras naciones, pero no a ustedes. ");
INSERT INTO spaonbv_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","El Señor los ha rescatado de Egipto (tan destructor como un horno) para que sean su pueblo escogido, su heredad. Esto es lo que ustedes son hoy. ");
INSERT INTO spaonbv_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","El Señor se enojó conmigo a causa de ustedes. Juró que yo no cruzaría el río Jordán para entrar a la buena tierra que él les ha dado a ustedes como heredad. ");
INSERT INTO spaonbv_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","Ustedes la poseerán, pero yo moriré aquí, a este lado del río. ");
INSERT INTO spaonbv_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Cuídense de no quebrantar el pacto del Señor su Dios. Si se fabrican ídolos, lo estarán quebrantando, porque el Señor, el Dios de ustedes, lo ha prohibido. ");
INSERT INTO spaonbv_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","Él es fuego devorador, Dios celoso. ");
INSERT INTO spaonbv_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","»En el futuro, cuando los hijos y nietos de ustedes hayan nacido y hayan vivido en la tierra largo tiempo, si se corrompen haciendo ídolos y el Señor su Dios se enoja con ustedes a causa de su pecado, ");
INSERT INTO spaonbv_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","el cielo y la tierra son testigos de que pronto serán ustedes destruidos en la tierra. En poco tiempo cruzarán el río Jordán y conquistarán aquella tierra. Pero sus días en ella serán cortos; serán completamente destruidos. ");
INSERT INTO spaonbv_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","El Señor los esparcirá entre las naciones y serán muy pocos en número. ");
INSERT INTO spaonbv_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","Allí, lejos de su tierra, servirán ídolos de madera y de piedra, hechos por la gente, ídolos que no ven ni oyen, no comen ni huelen. ");
INSERT INTO spaonbv_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","»Pero entonces comenzarán a buscar otra vez al Señor su Dios, y lo encontrarán si lo buscan con todo el corazón y toda el alma. ");
INSERT INTO spaonbv_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","Cuando esos días amargos vengan sobre ustedes en los últimos tiempos, se volverán al Señor su Dios y oirán lo que les dice. ");
INSERT INTO spaonbv_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","Porque el Señor su Dios es misericordioso; él no los abandonará ni los destruirá ni olvidará el pacto y las promesas hechas a sus antepasados. ");
INSERT INTO spaonbv_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","»Analicen la historia desde que Dios creó al ser humano sobre la tierra, y busquen desde un extremo del cielo al otro, para ver si pueden encontrar algo semejante a esto: ");
INSERT INTO spaonbv_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","Que toda una nación oyó la voz de Dios hablándoles desde el fuego, como pasó con ustedes, y vivió. ");
INSERT INTO spaonbv_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","¿Dónde se informa de que algún dios hubiera sacado a una nación de la esclavitud por medio de plagas terribles, milagros poderosos, guerra y terror? Sin embargo, eso es exactamente lo que el Señor su Dios hizo por ustedes en Egipto ante sus mismos ojos. ");
INSERT INTO spaonbv_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","Él hizo estas cosas para que ustedes comprendan que el Señor es Dios; y que no hay ninguno como él. ");
INSERT INTO spaonbv_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","Dios les permitió oír su voz dando órdenes desde el cielo, y les dejó ver la gran columna de fuego sobre la tierra; y oyeron sus palabras desde el centro del fuego. ");
INSERT INTO spaonbv_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","»El Señor los sacó a ustedes de Egipto con gran demostración de poder porque amó a sus antepasados y quiso bendecir a sus descendientes. ");
INSERT INTO spaonbv_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","El Señor desechó a otras naciones más poderosas y numerosas que ustedes, y la tierra que era de ellos se la dio a ustedes como heredad. ");
INSERT INTO spaonbv_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","Piensen en esto hoy y reflexionen: El Señor es Dios en el cielo y en la tierra, y no hay otro Dios sino solo el Señor. ");
INSERT INTO spaonbv_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","Deben obedecer las leyes que les doy en este día para que ustedes y sus hijos tengan bienestar y puedan vivir para siempre en la tierra que el Señor su Dios les da». ");
INSERT INTO spaonbv_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","Entonces Moisés instruyó al pueblo de Israel para que apartaran tres ciudades al oriente del río Jordán ");
INSERT INTO spaonbv_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","donde pudiera refugiarse cualquier persona que diera muerte a otra por accidente. ");
INSERT INTO spaonbv_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","Estas ciudades eran Béser en la llanura del desierto para la tribu de Rubén; Ramot de Galaad para la tribu de Gad; y Golán de Basán para la de Manasés. ");
INSERT INTO spaonbv_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","46","Estas son las leyes que Moisés entregó al pueblo de Israel cuando salieron de Egipto y estuvieron acampados al oriente del río Jordán cerca de la ciudad de Bet Peor. (Este había sido parte del territorio de Sijón, rey de los amorreos. Su capital era Hesbón; él y su pueblo fueron destruidos por Moisés y los israelitas. ");
INSERT INTO spaonbv_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","Israel conquistó su tierra y la del rey Og de Basán. Ellos eran los dos reyes amorreos que estaban al oriente del Jordán. ");
INSERT INTO spaonbv_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","Israel también conquistó el territorio que se extiende desde Aroer a orillas del río Arnón hasta el monte Sirión o monte Hermón, como se le llama a veces, ");
INSERT INTO spaonbv_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","y todo el Arabá al oriente del Jordán hasta el Mar Salado, al pie de las laderas del Pisgá). ");
INSERT INTO spaonbv_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","Moisés siguió hablándole al pueblo de Israel y le dijo: «Oigan ahora cuidadosamente estas leyes y normas que Dios les ha dado; apréndanselas, consérvenlas y obedézcanlas. ");
INSERT INTO spaonbv_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","3","»El Señor nuestro Dios hizo un pacto con ustedes en el monte Horeb, no con sus antepasados, sino con ustedes que están aquí vivos hoy día. ");
INSERT INTO spaonbv_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","El Señor habló con ustedes cara a cara desde el centro del fuego en el monte. ");
INSERT INTO spaonbv_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","Yo estaba como mediador entre ustedes y el Señor porque ustedes tenían miedo del fuego y no se quisieron acercar al monte. Él me habló y yo les di sus leyes. Esto es lo que dijo: ");
INSERT INTO spaonbv_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","»Yo soy el Señor tu Dios que te liberó de la esclavitud de Egipto. ");
INSERT INTO spaonbv_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","»No tendrás dioses ajenos delante de mí. ");
INSERT INTO spaonbv_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","»No te harás ídolos, no adorarás imágenes; sean de hombre o mujer, de aves, de animales o de peces. ");
INSERT INTO spaonbv_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","10","No te inclinarás delante de imagen alguna para adorarla de ninguna forma, porque yo, el Señor tu Dios; soy un Dios celoso. Yo castigo la maldad que haga un jefe de clan, incluyendo la tercera y cuarta generación de los que me odian; pero muestro misericordia a muchas generaciones de los que me aman y obedecen mis mandamientos. ");
INSERT INTO spaonbv_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","»No usarás mi nombre en vano. No daré por inocente al que lo haga. Yo el Señor tu Dios. ");
INSERT INTO spaonbv_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","»Guarda el día de reposo como un día santo. Este es mi mandamiento. ");
INSERT INTO spaonbv_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","Trabaja seis días, ");
INSERT INTO spaonbv_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","pero el séptimo le pertenece al Señor tu Dios; en ese día nadie en tu casa debe trabajar: tú, tus hijos e hijas, tus esclavos, tus bueyes, tus burros, ni ninguno de tus animales, ni los extranjeros que se han establecido entre ustedes. Todos deben descansar juntamente contigo, especialmente tus esclavos y tus esclavas. ");
INSERT INTO spaonbv_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","Recuerda que tú mismo fuiste esclavo en Egipto, y el Señor tu Dios te sacó de ese país con gran demostración de poder. Esa es la razón para obedecer este mandamiento. ");
INSERT INTO spaonbv_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","»Honra a tu padre y a tu madre, tal como el Señor tu Dios te ordenó. Si lo haces, tendrás una vida larga y próspera en la tierra que te da. ");
INSERT INTO spaonbv_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","»No matarás, ");
INSERT INTO spaonbv_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","ni cometerás adulterio, ");
INSERT INTO spaonbv_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","ni robarás, ");
INSERT INTO spaonbv_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","ni acusarás falsamente a tu prójimo. ");
INSERT INTO spaonbv_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","Tampoco codiciarás la esposa de otro hombre, ni su casa, ni su tierra, ni sus esclavos, ni sus bueyes, ni sus burros ni cosa alguna que él posea. ");
INSERT INTO spaonbv_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","»El Señor les dio estas leyes cuando estaban congregados como asamblea ante el monte. Él les habló desde el fuego, las nubes y las tinieblas que cubrían el monte Sinaí. Estos fueron los únicos mandamientos que el Señor les dio entonces, y los escribió en dos tablas de piedra que me entregó. ");
INSERT INTO spaonbv_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","Pero cuando ustedes oyeron la voz que salía desde la oscuridad, y vieron el fuego terrible en la cumbre del monte, sus jefes vinieron a mí ");
INSERT INTO spaonbv_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","y me rogaron: “Hoy nuestro Dios nos ha mostrado su gloria y su grandeza; hemos oído su voz desde el centro del fuego. Ahora sabemos que una persona puede oír a Dios y no morir; ");
INSERT INTO spaonbv_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","pero si nos habla nuevamente, de seguro moriremos. ¡Ese fuego terrible nos va a destruir totalmente! ");
INSERT INTO spaonbv_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","¿Qué mortal puede oír, como hemos oído nosotros, la voz del Dios vivo, que habla desde el fuego, y vivir? ");
INSERT INTO spaonbv_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","Ve tú y escucha todo lo que Dios dice, y luego ven y dínoslo y nosotros oiremos y obedeceremos”. ");
INSERT INTO spaonbv_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","»El Señor accedió a la petición y me dijo: “He oído lo que el pueblo te ha dicho y estoy de acuerdo. ");
INSERT INTO spaonbv_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","Ojalá siempre estuviera dispuesto a obedecer mis mandamientos. Si así fuera, les iría bien en todo a ellos, a sus hijos y a las generaciones futuras. ");
INSERT INTO spaonbv_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","Ve y diles que regresen a sus tiendas. ");
INSERT INTO spaonbv_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","Luego regresa de nuevo a donde estoy. Te daré todos los mandamientos para que se los enseñes al pueblo con el fin de que los pongan en práctica en la tierra que les voy a dar”». ");
INSERT INTO spaonbv_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","Entonces Moisés le dijo al pueblo: «Deben obedecer los mandamientos tal como el Señor su Dios se los ha ordenado. Sigan sus instrucciones al pie de la letra, ");
INSERT INTO spaonbv_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","y manténganse en el derrotero que Dios les trazó. Esa es la única forma en la que tendrán vida larga y próspera en la tierra que pronto entrarán a poseer. ");
INSERT INTO spaonbv_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","»El Señor su Dios me ha pedido que les dé estos mandamientos, para que los obedezcan en la tierra a la que pronto entrarán y en la cual vivirán. ");
INSERT INTO spaonbv_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","El propósito es que ustedes, sus hijos y nietos, obedezcan al Señor su Dios en todo. ¡Esa es la manera en que ustedes lo honrarán! Como resultado, vivirán muchos años llenos de prosperidad. ");
INSERT INTO spaonbv_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","Por tanto, oh Israel, escucha atentamente cada mandato y ponlo por obra para que te vaya bien a ti y a tus hijos. Si obedeces estos mandamientos llegarás a ser una gran nación en la tierra gloriosa de la que fluye leche y miel, según la promesa de Dios a tus padres. ");
INSERT INTO spaonbv_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","»Oye Israel: el Señor nuestro Dios es nuestro único Señor. ");
INSERT INTO spaonbv_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Ámalo con toda tu capacidad mental, con todo lo que eres y con todo lo que vales. ");
INSERT INTO spaonbv_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","Debes pensar constantemente en estos mandamientos que te doy en este día. ");
INSERT INTO spaonbv_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","Debes enseñarlos a tus hijos y hablar de ellos cuando estás en casa o cuando caminas con ellos; al acostarte y al levantarte. ");
INSERT INTO spaonbv_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","Átalos en tu mano y llévalos en la frente, ");
INSERT INTO spaonbv_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","escríbelos en la puerta de tu casa y en los portones de tu ciudad. ");
INSERT INTO spaonbv_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","11","»Cuando el Señor tu Dios te haya introducido en la tierra que les prometió a tus antepasados Abraham, Isaac y Jacob; y cuando te haya dado ciudades grandes y hermosas que no edificaste, repletas de todo tipo de bienes con pozos que no cavaste, viñedos y olivares que no plantaste; y cuando hayas comido hasta saciarte; ");
INSERT INTO spaonbv_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","no olvides jamás que el Señor te sacó de Egipto, tierra de esclavitud. ");
INSERT INTO spaonbv_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","Por esa razón solo al Señor debes rendirle toda honra, servirlo y usar su nombre para respaldar tus juramentos y promesas. ");
INSERT INTO spaonbv_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","»No adorarás a los dioses de las naciones que te rodean, ");
INSERT INTO spaonbv_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","porque el Señor tu Dios, que permanece contigo, es un Dios celoso, y su ira puede encenderse en contra tuya y borrarte de la faz de la tierra. ");
INSERT INTO spaonbv_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","No debes provocarlo ni probar su paciencia como lo hiciste cuando te quejaste en su contra en Masá. ");
INSERT INTO spaonbv_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","Debes obedecerle en todo lo que te mande. ");
INSERT INTO spaonbv_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","Sólo entonces estarás haciendo lo que es correcto y bueno de acuerdo con el deseo del Señor. Si le obedeces, todo te irá bien, y podrás entrar y poseer la buena tierra que el Señor prometió a tus antepasados. ");
INSERT INTO spaonbv_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","También podrás expulsar a todos los enemigos que viven en tu tierra, como el Señor te ha dicho. ");
INSERT INTO spaonbv_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","»En el futuro, cuando tus hijos te pregunten cuál es el propósito de todos estos mandamientos que el Señor nuestro Dios nos ha dado, ");
INSERT INTO spaonbv_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","les responderás: “Fuimos esclavos del faraón en Egipto, y el Señor nos sacó de Egipto con gran poder ");
INSERT INTO spaonbv_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","y por medio de milagros portentosos. Envió terribles plagas contra Egipto, contra el faraón y contra toda su gente. Lo vimos con nuestros propios ojos. ");
INSERT INTO spaonbv_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","Nos sacó de Egipto para darnos esta tierra que había prometido a nuestros antepasados. ");
INSERT INTO spaonbv_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","Y nos ha mandado que obedezcamos estas leyes y las honremos, para que sigamos con vida como lo ha hecho hasta ahora. ");
INSERT INTO spaonbv_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","Porque cuando obedecemos todas estas leyes del Señor nuestro Dios, somos justos”. ");
INSERT INTO spaonbv_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","»Cuando el Señor te haya introducido en la Tierra prometida, como pronto lo hará, destruirá a las siguientes naciones, siete en total, todas naciones numerosas y más poderosas que tú: Los hititas, los gergeseos, los amorreos, los cananeos, los ferezeos, los heveos y los jebuseos. ");
INSERT INTO spaonbv_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","»Cuando el Señor tu Dios te las entregue, deberás destruirlas completamente. No hagas con ellas pacto, ni les muestres misericordia. Las destruirás completamente. ");
INSERT INTO spaonbv_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","No te casarás con ninguna de las mujeres de esas naciones, ni permitirás que tus hijos e hijas casen a sus hijos e hijas con ellos. ");
INSERT INTO spaonbv_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","Si eso sucediera, con seguridad, tus descendientes comenzarían a adorar a los dioses de esas naciones y se apartarían del Señor. Entonces la ira del Señor se encendería en contra tuya y te destruiría. ");
INSERT INTO spaonbv_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","»Debes derribar los altares paganos, quebrar los obeliscos, destruir las imágenes de Aserá y quemar sus ídolos. ");
INSERT INTO spaonbv_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","Porque eres una nación santa, consagrada al Señor tu Dios. Él te ha elegido de entre todos los pueblos de la tierra para ser su pueblo escogido. ");
INSERT INTO spaonbv_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","El Señor no te eligió ni te demostró su amor porque fueras una nación más grande que las demás. Al contrario, eras la más insignificante de todas las naciones. ");
INSERT INTO spaonbv_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","Fue porque él te amó y cumplió la promesa hecha a tus antepasados. Por esta razón te liberó de la esclavitud de Egipto con una gran demostración de poder y milagros maravillosos. ");
INSERT INTO spaonbv_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","»Entiende, pues, que el Señor tu Dios es el único Dios fiel, que por mil generaciones es fiel a su alianza y muestra su lealtad a los que le aman y obedecen sus mandamientos. ");
INSERT INTO spaonbv_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","Pero los que lo odian, él mismo los castigará y destruirá. ");
INSERT INTO spaonbv_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","Por lo tanto, obedece todos estos mandamientos, estatutos y decretos que te doy en este día. ");
INSERT INTO spaonbv_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","Como resultado de tu obediencia a los mandamientos, el Señor tu Dios mantendrá la parte del pacto que bajo juramento y con tierno amor hizo con tus antepasados. ");
INSERT INTO spaonbv_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","Te amará y te bendecirá y te hará una nación muy numerosa. Los hará fértiles a ti, a tu tierra y a tus animales. Así tendrás abundancia de cereales, de vino y de aceite. Además, tus rebaños de vacas, de ovejas y de cabras aumentarán sobremanera cuando entres a la tierra que prometió a tus antepasados que les daría. ");
INSERT INTO spaonbv_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","Serás bendecido más que todas las naciones de la tierra; ninguno de los tuyos, sea hombre o mujer, será estéril, y tampoco lo será tu ganado. ");
INSERT INTO spaonbv_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","Y el Señor quitará de ti toda enfermedad y no dejará que sufras ninguna de las plagas que tú mismo sabes que azotaron a Egipto. En cambio, tus enemigos sí las sufrirán. ");
INSERT INTO spaonbv_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","»Deberás destruir a todas las naciones que el Señor tu Dios entrega en tus manos. No te apiadarás de ellas ni adorarás sus dioses. El día que lo hagas habrás caído en una trampa. ");
INSERT INTO spaonbv_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","Quizás pienses: “¿Cómo podemos vencer a estas naciones que son mucho más poderosas que nosotros?”. ");
INSERT INTO spaonbv_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","No les tengas miedo. Recuerda lo que el Señor tu Dios le hizo al faraón y a toda la tierra de Egipto. ");
INSERT INTO spaonbv_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","¿Recuerdas las plagas que el Señor envió sobre ellos (tus padres las vieron con sus propios ojos) y los milagros portentosos, y las maravillas, y el poder y fortaleza que Dios Todopoderoso usó para sacarte de Egipto? Pues el Señor tu Dios usará ese mismo poder contra el pueblo que tú temas. ");
INSERT INTO spaonbv_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","Más aún, Dios enviará avispas para destruir a los que queden y se escondan de ti. ");
INSERT INTO spaonbv_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","»No tengas miedo de esas naciones porque el Señor tu Dios está contigo y es un Dios poderoso y terrible. ");
INSERT INTO spaonbv_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","Él las expulsará en forma paulatina. No lo hará de una vez, porque si lo hiciera, los animales salvajes se multiplicarían con demasiada rapidez y esto sería peligroso. ");
INSERT INTO spaonbv_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","Lo hará gradualmente para que puedas actuar contra ellas y destruirlas. ");
INSERT INTO spaonbv_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","Dios entregará los reyes de esas naciones en tus manos, y tú borrarás sus nombres de la faz de la tierra. Ninguno podrá prevalecer en contra tuya. ");
INSERT INTO spaonbv_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","»Quema sus ídolos y no toques la plata o el oro con que estén hechos. No los tomes porque te servirán de tropiezo: el Señor los detesta. ");
INSERT INTO spaonbv_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","No traigas ídolos a tu casa ni los adores, porque entonces sellarás tu condenación. Aborrécelos porque son malditos. ");
INSERT INTO spaonbv_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","»Obedece los mandamientos que te doy en este día. Si así lo haces, no solamente vivirás sino que te multiplicarás y entrarás, y poseerás la tierra que el Señor prometió a tus antepasados. ");
INSERT INTO spaonbv_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","¿Recuerdas cómo te condujo el Señor a través del desierto durante estos cuarenta años, humillándote y probándote para saber dónde estaban tus prioridades y si realmente obedecerías o no sus mandamientos? ");
INSERT INTO spaonbv_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","Sí, el Señor te humilló dejándote pasar hambre y luego te dio a comer maná, alimento que no conocían tú ni tus antepasados. Él lo hizo para que comprendieras que no sólo de pan vive el ser humano, sino de la Palabra de Dios. ");
INSERT INTO spaonbv_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","En estos cuarenta años tus vestiduras no se han envejecido ni se te han hinchado los pies. ");
INSERT INTO spaonbv_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","Así podrás comprender que como un padre disciplina a sus hijos, el Señor te disciplina para ayudarte. ");
INSERT INTO spaonbv_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","»Obedece los mandamientos del Señor tu Dios, vive de acuerdo con su voluntad y dale la honra que se merece. ");
INSERT INTO spaonbv_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","Porque el Señor tu Dios te está llevando a una buena tierra, tierra de arroyos, de pozos; de manantiales, de valles y de montes; ");
INSERT INTO spaonbv_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","tierra de trigo y cebada y viñedos, de higueras y granados, de olivares, de aceite y de miel; ");
INSERT INTO spaonbv_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","tierra donde el alimento es abundante y nada falta; tierra donde el hierro es tan común como las piedras, y el cobre abunda en las montañas. ");
INSERT INTO spaonbv_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","Tendrás de todo hasta saciarte, y bendecirás al Señor tu Dios por la buena tierra que te ha dado. ");
INSERT INTO spaonbv_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","»¡No olvides al Señor tu Dios, y no dejes de obedecer todos sus mandamientos! ");
INSERT INTO spaonbv_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","Siempre existe el peligro de que cuando te hayas saciado y hayas prosperado, y hayas edificado casas hermosas, ");
INSERT INTO spaonbv_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","y cuando tu ganado y rebaños se hayan engrandecido y tu oro y tu plata se hayan multiplicado, ");
INSERT INTO spaonbv_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","caigas en el orgullo y te olvides del Señor tu Dios que te sacó de la esclavitud en la tierra de Egipto. Por eso, ten mucho cuidado, ¡no te olvides del Señor tu Dios, ");
INSERT INTO spaonbv_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","pues te condujo a través del desierto grande y terrible habitado por víboras y escorpiones peligrosos, donde todo es árido y seco. No olvides que te dio de beber agua de la roca; ");
INSERT INTO spaonbv_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","que te dio de comer maná en el desierto (una especie de pan que antes te era desconocido). A lo largo del camino te probó y te humilló con el fin de hacerte bien. ");
INSERT INTO spaonbv_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","No pienses jamás que por tu poder y tu fuerza has obtenido esa riqueza. ");
INSERT INTO spaonbv_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","Recuerda siempre que el Señor tu Dios es el que te da el poder para obtener las riquezas, y él lo hace para cumplir la promesa hecha a tus antepasados. ");
INSERT INTO spaonbv_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","»Ten por cierto que si te olvidas del Señor tu Dios y adoras en su lugar a otros dioses, si te desvías por malos caminos, ciertamente perecerás ");
INSERT INTO spaonbv_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","como las naciones que el Señor destruyó delante de ti. Tu destino será el mismo si no obedeces al Señor tu Dios. ");
INSERT INTO spaonbv_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","»Escucha, Israel: hoy mismo vas a cruzar el río Jordán e iniciarás la conquista de las naciones que viven al otro lado del río. ");
INSERT INTO spaonbv_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","Estas naciones son más numerosas y poderosas que tú. Sus habitantes viven en ciudades grandes y amuralladas. Entre ellos están los famosos gigantes, descendientes de Anac, a quienes nadie ha podido vencer. ");
INSERT INTO spaonbv_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","Pero el Señor tu Dios irá delante de ti como un fuego consumidor para destruirlos de modo que puedas vencerlos con rapidez y expulsarlos de la tierra. ");
INSERT INTO spaonbv_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","»Cuando el Señor haya realizado todo esto, no te atrevas a decir que todo esto lo hizo por tu rectitud. La realidad es otra. El Señor lo hará por la impiedad de las otras naciones. ");
INSERT INTO spaonbv_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","El Señor los expulsará de la tierra no por tu bondad o rectitud, sino debido a la impiedad de las otras naciones, y para cumplir la promesa que hizo a tus antepasados Abraham, Isaac y Jacob. ");
INSERT INTO spaonbv_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","Te lo digo una vez más: El Señor tu Dios no te da esta buena tierra porque tú seas justo, porque no lo eres: Al contrario, eres un pueblo soberbio y rebelde. ");
INSERT INTO spaonbv_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","»No lo olvides, más bien recuerda las muchas veces que hiciste enojar al Señor tu Dios en el desierto. Esto lo hiciste, una y otra vez, desde el día que te sacó de Egipto hasta ahora. Todo este tiempo te has rebelado continuamente contra Dios. ");
INSERT INTO spaonbv_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","»Recuerda también que lo hiciste enojar cuando estabas esperando al pie del monte Horeb. El Señor estaba dispuesto a destruirte. ");
INSERT INTO spaonbv_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","Yo estaba en el monte en ese momento recibiendo las tablas de piedra, las tablas de la alianza que el Señor había hecho contigo. Estuve allí cuarenta días y cuarenta noches, y en todo ese tiempo nada comí. Ni siquiera tomé agua. ");
INSERT INTO spaonbv_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","11","Al finalizar esos cuarenta días y cuarenta noches, el Señor me dio las tablas de la alianza en las que Dios mismo había escrito las palabras que promulgó desde la cumbre de la montaña cubierta de fuego mientras el pueblo miraba desde abajo, ");
INSERT INTO spaonbv_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","y me dijo que bajara rápidamente porque el pueblo que había librado de Egipto se había corrompido apartándose de la voluntad del Señor y había hecho un ídolo de metal fundido. ");
INSERT INTO spaonbv_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","14","»El Señor me dijo entonces: “Déjame que destruya a este pueblo terco. Borraré su nombre de debajo del cielo y de ti haré una nación más numerosa y más poderosa de lo que ellos son ahora”. ");
INSERT INTO spaonbv_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","»De inmediato descendí de la montaña que ardía en fuego, llevando en mis manos las dos tablas de la alianza. ");
INSERT INTO spaonbv_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","Cuando bajé con horror descubrí que ustedes habían pecado contra el Señor su Dios. ¡Hicieron un ídolo en forma de becerro y lo adoraron! ¡No les tomó nada de tiempo apartarse de la voluntad de Dios! ");
INSERT INTO spaonbv_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","Tomé las dos tablas de piedra y las estrellé contra el piso; ¡frente a ustedes se hicieron añicos! ");
INSERT INTO spaonbv_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","Tras esto, y durante otros cuarenta días y cuarenta noches, estuve delante del Señor sin probar un solo bocado ni un trago de agua, porque ustedes habían pecado grandemente ante el Señor, e hicieron que se enojara grandemente. ");
INSERT INTO spaonbv_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","Yo temía por ustedes, porque el Señor estaba dispuesto a destruirlos. Pero en aquella oportunidad, nuevamente respondió positivamente a mi oración. ");
INSERT INTO spaonbv_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","Aarón estaba en gran peligro de perder la vida también, porque el Señor estaba sumamente airado con él. Pero también intercedí por él. ");
INSERT INTO spaonbv_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","Sin perder tiempo, tomé el objeto del pecado de todos ustedes, el ídolo, y lo quemé, lo reduje a polvo y lo lancé al arroyo que descendía de la montaña. ");
INSERT INTO spaonbv_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","»Nuevamente en Taberá, y luego en Masá y en Quibrot Hatavá, ustedes hicieron que se encendiera la ira del Señor. ");
INSERT INTO spaonbv_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","En Cades Barnea, cuando el Señor les dijo que entraran a poseer la tierra que les había dado, se rebelaron y no quisieron creer que Dios los ayudaría; no quisieron obedecerle. ");
INSERT INTO spaonbv_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","Ustedes han sido rebeldes contra el Señor su Dios desde el primer día que los conocí. ");
INSERT INTO spaonbv_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","Cuarenta días y cuarenta noches estuve postrado delante del Señor, porque iba a destruirlos. ");
INSERT INTO spaonbv_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","»Le supliqué al Señor, y le dije: “Señor y Dios mío, no destruyas a tu pueblo. Es tu propia herencia que rescataste de Egipto con tu maravilloso poder y gloriosa fuerza. ");
INSERT INTO spaonbv_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","No tomes en cuenta las rebeliones y la soberbia de este pueblo. Recuerda las promesas que les hiciste a tus siervos Abraham, Isaac y Jacob. No tomes en cuenta la maldad y el pecado de este pueblo, ");
INSERT INTO spaonbv_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","porque si lo destruyes, los egipcios dirán que no pudiste introducirlos en la tierra que les prometiste, o que los destruiste porque los odiabas, que los llevaste al desierto para darles muerte allí. ");
INSERT INTO spaonbv_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","Ellos son tu pueblo, y la herencia que tú trajiste de Egipto con tu gran poder y con tu brazo poderoso”. ");
INSERT INTO spaonbv_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","»En aquel tiempo, el Señor me dijo que preparara dos tablas de piedra como las primeras, y que hiciera un cofre de madera para guardarlas dentro, y que volviera a subir a su presencia en el monte. ");
INSERT INTO spaonbv_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","Dijo que volvería a escribir las mismas palabras que estaban en las tablas que yo destruí, y me ordenó que colocara las nuevas tablas en el cofre. ");
INSERT INTO spaonbv_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","Entonces hice un cofre de madera de acacia y preparé dos piedras lisas como las primeras, y subí con ellas a la montaña. ");
INSERT INTO spaonbv_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","El Señor nuevamente escribió los Diez Mandamientos sobre ellas y me las dio. ");
INSERT INTO spaonbv_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","Cuando descendí, coloqué las tablas en el cofre que había hecho, donde están hasta este día como el Señor me lo ordenó». ");
INSERT INTO spaonbv_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","El pueblo de Israel luego avanzó desde los pozos de Berot Bené Yacán hasta Moserá, donde murió Aarón y fue sepultado. Eleazar, su hijo, fue nombrado sumo sacerdote. ");
INSERT INTO spaonbv_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","De allí partieron hacia Gudgoda y de Gudgoda a Jotbata, tierra donde hay arroyos. ");
INSERT INTO spaonbv_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","Allí fue donde el Señor apartó a la tribu de Leví para que llevara el cofre de la alianza del Señor. Esa tribu debía estar en la presencia del Señor, para estar a su servicio y para bendecir al pueblo en nombre de Dios, hasta el presente. ");
INSERT INTO spaonbv_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","Esa es la razón por la cual la tribu de Leví no tiene reservada ninguna porción de la tierra entre las tribus hermanas. El Señor es su heredad, como el mismo Señor afirmó. ");
INSERT INTO spaonbv_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","«Como ocurrió en la primera ocasión, yo permanecí en el monte por espacio de cuarenta días y cuarenta noches. Y en esta ocasión el Señor respondió a mi oración, y no te destruyó. ");
INSERT INTO spaonbv_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","»Y me dijo el Señor: “Levántate y lleva a este pueblo a la tierra que prometí a sus antepasados. Es tiempo de que entren y la posean”. ");
INSERT INTO spaonbv_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","13","»Ahora pues, Israel, ¿qué es lo que el Señor tu Dios quiere de ti sino que escuches cuidadosamente todo lo que te dice y obedezcas por tu bien los mandamientos que te doy en este día, y que lo ames y le sirvas con toda tu mente y todo tu ser? ");
INSERT INTO spaonbv_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","La tierra y los altos cielos pertenecen al Señor tu Dios. ");
INSERT INTO spaonbv_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","Sin embargo, el Señor se agradó de tus padres y los amó tanto que te escogió para ponerte por encima de todas las naciones como es evidente hoy día. ");
INSERT INTO spaonbv_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","Por tanto, limpia tu corazón pecaminoso y deja de lado tu soberbia. ");
INSERT INTO spaonbv_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","»El Señor tu Dios es Dios de dioses y Señor de señores. Él es el grande y poderoso Dios, temible; que no es parcial y no acepta soborno, ");
INSERT INTO spaonbv_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","que hace justicia a los huérfanos y a las viudas; que ama al exiliado y le da alimento y vestido. ");
INSERT INTO spaonbv_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","(Recuerda que debes amar a los exiliados porque fuiste exiliado en Egipto). ");
INSERT INTO spaonbv_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","Temerás, pues, al Señor tu Dios; y lo servirás, lo seguirás, y jurarás solamente por su nombre. ");
INSERT INTO spaonbv_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","Él es el objeto de tu alabanza, y él es tu Dios, el que ha hecho los milagros grandiosos que has visto. ");
INSERT INTO spaonbv_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","Cuando tus antepasados descendieron a Egipto eran sólo setenta personas; pero ahora tu número ha aumentado hasta ser tan numeroso como las estrellas del cielo. ");
INSERT INTO spaonbv_vpl VALUES ("DT11_1","006_11_1","DEU","11","1","1","»Amen al Señor su Dios y obedezcan todos los días cada uno de sus mandamientos. ");
INSERT INTO spaonbv_vpl VALUES ("DT11_2","006_11_2","DEU","11","2","2","No les estoy hablando ahora a los hijos de ustedes, que jamás han experimentado la disciplina del Señor su Dios ni han visto su grandeza ni su glorioso poder, ");
INSERT INTO spaonbv_vpl VALUES ("DT11_3","006_11_3","DEU","11","3","3","ni los milagros y actos portentosos en Egipto contra el faraón y contra su tierra; ");
INSERT INTO spaonbv_vpl VALUES ("DT11_4","006_11_4","DEU","11","4","4","ni tampoco han visto lo que el Señor hizo con el ejército egipcio, con sus caballos y sus carros, hundiéndolos en el Mar Rojo y aniquilándolos hasta este mismo día. ");
INSERT INTO spaonbv_vpl VALUES ("DT11_5","006_11_5","DEU","11","5","5","»Los hijos de ustedes tampoco vieron cómo el Señor los cuidó a ustedes durante todos los años en que anduvieron por el desierto hasta llegar a este lugar. ");
INSERT INTO spaonbv_vpl VALUES ("DT11_6","006_11_6","DEU","11","6","6","Ellos no estaban presentes cuando Datán y Abirán (los hijos de Eliab, descendientes de Rubén) pecaron y la tierra se abrió y los tragó, juntamente con sus familias y tiendas y con todas sus pertenencias, cosa que todo Israel vio. ");
INSERT INTO spaonbv_vpl VALUES ("DT11_7","006_11_7","DEU","11","7","7","Tú, en cambio, sí viste esos milagros. ");
INSERT INTO spaonbv_vpl VALUES ("DT11_8","006_11_8","DEU","11","8","8","»¡Obedezcan todos los mandamientos que les doy en este día, para que tengan la fuerza de ir y poseer la tierra a la que están por entrar! ");
INSERT INTO spaonbv_vpl VALUES ("DT11_9","006_11_9","DEU","11","9","9","Si ustedes obedecen los mandamientos, tendrán una vida larga y buena en la tierra que el Señor les prometió a sus antepasados y a sus descendientes, tierra maravillosa de la que fluye leche y miel. ");
INSERT INTO spaonbv_vpl VALUES ("DT11_10","006_11_10","DEU","11","10","10","Porque la tierra a la que estás por entrar y poseer no es como la tierra de Egipto, de la cual saliste, donde es necesario el riego. ");
INSERT INTO spaonbv_vpl VALUES ("DT11_11","006_11_11","DEU","11","11","11","Esta es una tierra de colinas y valles con lluvia suficiente. ");
INSERT INTO spaonbv_vpl VALUES ("DT11_12","006_11_12","DEU","11","12","12","Una tierra que el Señor tu Dios personalmente cuida. Sus ojos están sobre ella día a día, durante todo el año. ");
INSERT INTO spaonbv_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","13","»Si ustedes obedecen cuidadosamente todos los mandamientos que les voy a entregar en este día, y si aman al Señor su Dios con toda su mente y con toda su vida, y lo adoran, ");
INSERT INTO spaonbv_vpl VALUES ("DT11_14","006_11_14","DEU","11","14","14","él les enviará lluvia que caiga a su tiempo, tanto la de otoño como la de primavera, que haga producir ricas cosechas de grano, de uvas en sus viñedos y de aceite de sus olivares. ");
INSERT INTO spaonbv_vpl VALUES ("DT11_15","006_11_15","DEU","11","15","15","El Señor les dará hierba verde para su ganado, y tendrán abundante comida, y se saciarán. ");
INSERT INTO spaonbv_vpl VALUES ("DT11_16","006_11_16","DEU","11","16","16","»Pero no dejen ustedes que su corazón se aparte del Señor para adorar a otros dioses. ");
INSERT INTO spaonbv_vpl VALUES ("DT11_17","006_11_17","DEU","11","17","17","Porque si lo hacen, la ira del Señor se encenderá en su contra y cerrará los cielos de modo que no haya lluvia ni cosechas, y todos ustedes perecerán en la buena tierra que el Señor les ha dado. ");
INSERT INTO spaonbv_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","Guarden estos mandamientos cuidadosamente en su memoria y en todo su ser. Átenlos en su mano para que se acuerden de obedecerlos, átenlos en su frente entre sus dos ojos. ");
INSERT INTO spaonbv_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","Enséñenselos a sus hijos. Hablen de ellos cuando estén sentados en su casa, cuando estén afuera caminando, a la hora de acostarse, y al levantarse. ");
INSERT INTO spaonbv_vpl VALUES ("DT11_20","006_11_20","DEU","11","20","20","Escríbelos en los postes de la casa y sobre las puertas de la ciudad, ");
INSERT INTO spaonbv_vpl VALUES ("DT11_21","006_11_21","DEU","11","21","21","de tal modo que mientras haya cielo sobre la tierra, tú y tus hijos disfruten de la buena vida que te espera en la tierra que Señor te ha prometido. ");
INSERT INTO spaonbv_vpl VALUES ("DT11_22","006_11_22","DEU","11","22","22","»Si ustedes obedecen cuidadosamente todos los mandamientos que les doy, y aman al Señor su Dios, andan en todos sus caminos, y lo siguen, ");
INSERT INTO spaonbv_vpl VALUES ("DT11_23","006_11_23","DEU","11","23","23","el Señor echará de delante de ustedes a todas las naciones de esta tierra, no importa cuán grandes y fuertes sean. ");
INSERT INTO spaonbv_vpl VALUES ("DT11_24","006_11_24","DEU","11","24","24","Dondequiera que ustedes vayan, esa porción de tierra es suya. Sus fronteras se extenderán desde el Néguev por el sur hasta el Líbano, y desde el río Éufrates hasta el mar Mediterráneo. ");
INSERT INTO spaonbv_vpl VALUES ("DT11_25","006_11_25","DEU","11","25","25","Nadie podrá hacerles frente porque el Señor su Dios hará que todos les tengan miedo a ustedes cualquiera sea el lugar que pasen, tal como te lo ha prometido. ");
INSERT INTO spaonbv_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","»Ahora ustedes deben elegir entre la bendición de Dios y la maldición de Dios. ");
INSERT INTO spaonbv_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","Tendrán bendición si obedecen los mandamientos del Señor su Dios que les estoy dando en este día, ");
INSERT INTO spaonbv_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","y maldición si lo desobedecen y adoran los dioses de estas otras naciones. ");
INSERT INTO spaonbv_vpl VALUES ("DT11_29","006_11_29","DEU","11","29","29","Cuando el Señor su Dios los introduzca en esa tierra para poseerla, una bendición se proclamará desde el monte Guerizín y una maldición desde el monte Ebal. ");
INSERT INTO spaonbv_vpl VALUES ("DT11_30","006_11_30","DEU","11","30","30","(Guerizín y Ebal son montes que están al occidente del río Jordán, donde viven los cananeos en el desierto Arabá frente a Guilgal, junto a las encinas de Moré). ");
INSERT INTO spaonbv_vpl VALUES ("DT11_31","006_11_31","DEU","11","31","31","Porque ustedes cruzarán el Jordán y vivirán en la tierra que el Señor les da. ");
INSERT INTO spaonbv_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","Pero ustedes deben siempre estar dispuestos en vivir de acuerdo con todas las leyes que hoy les estoy dando. ");
INSERT INTO spaonbv_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","»Estas son las leyes que debes obedecer cuando llegues a la tierra que el Señor, el Dios de tus padres, te ha dado para siempre: ");
INSERT INTO spaonbv_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","»Destruirás todos los altares paganos dondequiera que los encuentres: en los montes altos, en los collados o debajo de los árboles frondosos. ");
INSERT INTO spaonbv_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","Derribarás los altares, destruirás las estatuas, quemarás las imágenes de Aserá, destruirás los ídolos de metal y no dejarás nada que te los recuerde. ");
INSERT INTO spaonbv_vpl VALUES ("DT12_4","006_12_4","DEU","12","4","5","»No harás sacrificios a tu Dios en cualquier lugar como los paganos lo hacen con sus dioses. Por el contrario, deberás construir un santuario para Dios en un lugar que él mismo te señalará como su morada. ");
INSERT INTO spaonbv_vpl VALUES ("DT12_6","006_12_6","DEU","12","6","6","Allí llevarás al Señor tus holocaustos y los demás sacrificios: los diezmos, las ofrendas presentadas con devoción delante del altar, el pago de tus votos, las ofrendas voluntarias y las primicias de tus rebaños y del ganado. ");
INSERT INTO spaonbv_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","Tú y tu familia harán fiesta allí delante del Señor tu Dios y te regocijarás en todo lo que él ha hecho por ti. ");
INSERT INTO spaonbv_vpl VALUES ("DT12_8","006_12_8","DEU","12","8","8","»Nadie hará lo que bien le pareciere, como hasta ahora. ");
INSERT INTO spaonbv_vpl VALUES ("DT12_9","006_12_9","DEU","12","9","9","Porque estas leyes no entran en vigor hasta que no hayas entrado al lugar de gozo que el Señor tu Dios te ha dado. ");
INSERT INTO spaonbv_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","10","Pero cuando hayas cruzado el río y vivas en la Tierra prometida, y el Señor te dé reposo y te libere de todos tus enemigos, ");
INSERT INTO spaonbv_vpl VALUES ("DT12_11","006_12_11","DEU","12","11","11","llevarás todos tus sacrificios y ofrendas al santuario, al lugar que Dios elegirá como su morada. ");
INSERT INTO spaonbv_vpl VALUES ("DT12_12","006_12_12","DEU","12","12","12","Allí te regocijarás delante del Señor con tus hijos e hijas y siervos. Además, recuerda siempre de invitar a los levitas para que hagan fiesta contigo, porque ellos no tienen tierra propia. ");
INSERT INTO spaonbv_vpl VALUES ("DT12_13","006_12_13","DEU","12","13","13","»No presentarás tus holocaustos en cualquier lugar; ");
INSERT INTO spaonbv_vpl VALUES ("DT12_14","006_12_14","DEU","12","14","14","podrás hacerlo solamente en el lugar que el Señor escogerá. Él elegirá un lugar en el territorio designado para una de las tribus. Solamente allí podrás hacer tus sacrificios y llevar tus ofrendas. ");
INSERT INTO spaonbv_vpl VALUES ("DT12_15","006_12_15","DEU","12","15","15","Sin embargo, la carne que comas podrás obtenerla matando a tus animales en cualquier lugar, de la manera como lo haces ahora con la gacela o el ciervo. Come toda la carne que desees y con la frecuencia que puedas, conforme a la prosperidad que el Señor te haya dado. Los que estén ceremonialmente impuros también pueden comer. ");
INSERT INTO spaonbv_vpl VALUES ("DT12_16","006_12_16","DEU","12","16","16","La única restricción es que no podrás comer sangre, derrámala sobre la tierra. ");
INSERT INTO spaonbv_vpl VALUES ("DT12_17","006_12_17","DEU","12","17","17","»Sin embargo, no podrás comer en tu casa las ofrendas ni el diezmo de tus cosechas de grano, de tu vino o de tu aceite, ni las primicias de tus rebaños o de tus vacas, ni ninguna cosa que hayas dedicado al Señor; ni tus ofrendas voluntarias, ni las ofrendas que haya de presentarse al Señor meciéndolas delante de su altar. ");
INSERT INTO spaonbv_vpl VALUES ("DT12_18","006_12_18","DEU","12","18","18","Todas deberán ser llevadas delante el altar donde tú, tus hijos y los levitas comerán de ellas delante del Señor tu Dios. Él te dirá dónde quedará establecido este altar. Regocíjate delante del Señor tu Dios en todo lo que haces. ");
INSERT INTO spaonbv_vpl VALUES ("DT12_19","006_12_19","DEU","12","19","19","No te olvides jamás de los levitas; comparte con ellos tu comida. ");
INSERT INTO spaonbv_vpl VALUES ("DT12_20","006_12_20","DEU","12","20","22","»Cuando el Señor ensanche tu territorio, si el altar está demasiado lejos de ti, podrás matar tus ovejas y vacas en tu propia tierra, como lo haces actualmente con las gacelas y los ciervos. Aun las personas que estén ceremonialmente impuras podrán comer de ellos. ");
INSERT INTO spaonbv_vpl VALUES ("DT12_23","006_12_23","DEU","12","23","23","La única restricción es que nunca coman sangre, porque la sangre es la vida, y no comerás la vida con la carne. ");
INSERT INTO spaonbv_vpl VALUES ("DT12_24","006_12_24","DEU","12","24","25","Derramarás la sangre sobre la tierra, de este modo, a tus hijos y a ti les irá bien. ");
INSERT INTO spaonbv_vpl VALUES ("DT12_26","006_12_26","DEU","12","26","27","Pero lo que hayas consagrado al Señor, las ofrendas que hayas prometido en tus votos y los holocaustos deben ser llevados al altar. Esto sólo puede ser ofrecido sobre el altar del Señor, tu Dios. La sangre será derramada sobre el altar, y comerás la carne. ");
INSERT INTO spaonbv_vpl VALUES ("DT12_28","006_12_28","DEU","12","28","28","»Obedece cuidadosamente todos estos mandamientos. Si haces lo que al Señor tu Dios le agrada, te irá bien a ti y a tus hijos para siempre. ");
INSERT INTO spaonbv_vpl VALUES ("DT12_29","006_12_29","DEU","12","29","29","Cuando Dios destruya las naciones que habitan en la tierra donde tú vivirás, y las hayas expulsado, ");
INSERT INTO spaonbv_vpl VALUES ("DT12_30","006_12_30","DEU","12","30","30","procura no seguir su ejemplo ni adores a sus dioses. Tampoco te dejes llevar por la curiosidad y preguntes cómo adoran a sus dioses estas naciones, para luego ir y adorarlos de la manera que ellos lo hacen. ");
INSERT INTO spaonbv_vpl VALUES ("DT12_31","006_12_31","DEU","12","31","31","No debes insultar a tu Dios de esa manera. Estas naciones han hecho cosas abominables que él aborrece, todo en nombre de su religión. Hasta han llegado a quemar a sus hijos y a sus hijas delante de sus dioses. ");
INSERT INTO spaonbv_vpl VALUES ("DT12_32","006_12_32","DEU","12","32","32","Obedece todos los mandamientos que yo te doy; no les añadas ni les quites nada. ");
INSERT INTO spaonbv_vpl VALUES ("DT13_1","006_13_1","DEU","13","1","1","»Si hay en medio tuyo un profeta o alguien que asegure ver el futuro por medio de sueños, ");
INSERT INTO spaonbv_vpl VALUES ("DT13_2","006_13_2","DEU","13","2","2","si su predicción se cumple pero dice: “Vamos, adoremos a los dioses de las otras naciones”, ");
INSERT INTO spaonbv_vpl VALUES ("DT13_3","006_13_3","DEU","13","3","3","no le escuches. Porque el Señor te está probando para saber si lo amas realmente con toda tu mente y corazón y con todo tu ser. ");
INSERT INTO spaonbv_vpl VALUES ("DT13_4","006_13_4","DEU","13","4","4","No debes jamás adorar a dios alguno sino al Señor; obedece sus mandamientos y síguelo a él nada más. ");
INSERT INTO spaonbv_vpl VALUES ("DT13_5","006_13_5","DEU","13","5","5","»El profeta que trate de desviarte debe morir, porque ha tratado de fomentar rebelión contra el Señor tu Dios que te sacó de la esclavitud en Egipto. Con su ejecución habrás quitado el mal de en medio de ti. ");
INSERT INTO spaonbv_vpl VALUES ("DT13_6","006_13_6","DEU","13","6","7","Si un pariente cercano, o un amigo muy íntimo, o aun un hermano, hermana, hija o hijo, te sugiere que vayas y adores a dioses extraños, ");
INSERT INTO spaonbv_vpl VALUES ("DT13_8","006_13_8","DEU","13","8","8","no consientas ni les escuches, ni tengas misericordia de ellos. No perdonarás a tal persona; no encubrirás su horrible sugerencia. ");
INSERT INTO spaonbv_vpl VALUES ("DT13_9","006_13_9","DEU","13","9","9","Deberá morir. Tu propia mano será la primera que se levante en su contra para darle muerte, y luego la mano de todo el resto del pueblo. ");
INSERT INTO