﻿USE sofia;
DROP TABLE IF EXISTS sofia.spablm_vpl;
CREATE TABLE spablm_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES spablm_vpl WRITE;
INSERT INTO spablm_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","En el principio, Dios creó los cielos y la tierra. ");
INSERT INTO spablm_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","La tierra estaba sin forma y vacía. Las tinieblas estaban en la superficie de las profundidades y el Espíritu de Dios se cernía sobre la superficie de las aguas. ");
INSERT INTO spablm_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Dios dijo: “Que se haga la luz”, y se hizo la luz. ");
INSERT INTO spablm_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Dios vio la luz y vio que era buena. Dios separó la luz de las tinieblas. ");
INSERT INTO spablm_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Dios llamó a la luz “día”, y a las tinieblas las llamó “noche”. Hubo tarde y hubo mañana, el primer día. ");
INSERT INTO spablm_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Dios dijo: “Que haya una extensión en medio de las aguas, y que divida las aguas de las aguas”. ");
INSERT INTO spablm_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Dios hizo la expansión y dividió las aguas que estaban debajo de la expansión de las aguas que estaban encima de la expansión; y así fue. ");
INSERT INTO spablm_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Dios llamó a la expansión “cielo”. Hubo tarde y mañana, un segundo día. ");
INSERT INTO spablm_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Dios dijo: “Que las aguas bajo el cielo se reúnan en un solo lugar, y que aparezca la tierra seca”; y así fue. ");
INSERT INTO spablm_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Dios llamó a la tierra seca “tierra”, y a la reunión de las aguas la llamó “mares”. Dios vio que era bueno. ");
INSERT INTO spablm_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Dijo Dios: “Produzca la tierra hierba, hierbas que den semillas y árboles frutales que den fruto según su especie, con sus semillas, sobre la tierra”; y así fue. ");
INSERT INTO spablm_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","La tierra dio hierba, hierbas que producen semillas según su género, y árboles que dan fruto, con sus semillas, según su género; y vio Dios que era bueno. ");
INSERT INTO spablm_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Se hizo la tarde y la mañana, un tercer día. ");
INSERT INTO spablm_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Dios dijo: “Que haya luces en la extensión del cielo para separar el día de la noche; y que sean para señales que marquen las estaciones, los días y los años; ");
INSERT INTO spablm_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","y que sean para luces en la extensión del cielo para alumbrar la tierra”; y así fue. ");
INSERT INTO spablm_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Dios hizo las dos grandes luces: la luz mayor para gobernar el día, y la luz menor para gobernar la noche. También hizo las estrellas. ");
INSERT INTO spablm_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Dios las puso en la extensión del cielo para que alumbraran la tierra, ");
INSERT INTO spablm_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","y para que dominaran el día y la noche, y para que separaran la luz de las tinieblas. Dios vio que era bueno. ");
INSERT INTO spablm_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Se hizo la tarde y se hizo la mañana, un cuarto día. ");
INSERT INTO spablm_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Dios dijo: “Que las aguas abunden en seres vivos, y que las aves vuelen sobre la tierra en la abierta extensión del cielo”. ");
INSERT INTO spablm_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Dios creó las grandes criaturas marinas y toda criatura viviente que se mueve, con las que pululan las aguas, según su especie, y toda ave alada según su especie. Dios vio que era bueno. ");
INSERT INTO spablm_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Dios los bendijo diciendo: “Sean fecundos y multiplíquense, llenen las aguas de los mares y multiplíquense las aves en la tierra.” ");
INSERT INTO spablm_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Se hizo la tarde y la mañana, un quinto día. ");
INSERT INTO spablm_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Dios dijo: “Que la tierra produzca seres vivos según su especie, ganado, reptiles y animales de la tierra según su especie”; y así fue. ");
INSERT INTO spablm_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Dios hizo a los animales de la tierra según su especie, a los animales según su especie y a todo lo que se arrastra por el suelo según su especie. Dios vio que era bueno. ");
INSERT INTO spablm_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Dios dijo: “Hagamos al hombre a nuestra imagen y semejanza. Que tenga dominio sobre los peces del mar, sobre las aves del cielo, sobre el ganado, sobre toda la tierra y sobre todo lo que se arrastra sobre ella”. ");
INSERT INTO spablm_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Dios creó al hombre a su imagen y semejanza. A imagen y semejanza de Dios lo creó; hombre y mujer los creó. ");
INSERT INTO spablm_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Dios los bendijo. Dios les dijo: “Sed fecundos, multiplicaos, llenad la tierra y sometedla. Dominen a los peces del mar, a las aves del cielo y a todo ser viviente que se mueve sobre la tierra”. ");
INSERT INTO spablm_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Dios dijo: “Mira, te he dado toda hierba que da semilla, que está en la superficie de toda la tierra, y todo árbol que da fruto que da semilla. Serán su alimento. ");
INSERT INTO spablm_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","A todo animal de la tierra, y a toda ave del cielo, y a todo lo que se arrastra sobre la tierra, en el que hay vida, les he dado toda hierba verde como alimento”; y así fue. ");
INSERT INTO spablm_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Dios vio todo lo que había hecho, y he aquí que era muy bueno. Hubo tarde y mañana, un sexto día. ");
INSERT INTO spablm_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Los cielos, la tierra y todo su vasto conjunto fueron terminados. ");
INSERT INTO spablm_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","En el séptimo día Dios terminó su obra que había hecho; y descansó en el séptimo día de toda su obra que había hecho. ");
INSERT INTO spablm_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Dios bendijo el séptimo día y lo santificó, porque en él descansó de toda su obra de creación que había hecho. ");
INSERT INTO spablm_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Esta es la historia de las generaciones de los cielos y de la tierra cuando fueron creados, el día en que Yahvé Dios hizo la tierra y los cielos. ");
INSERT INTO spablm_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Todavía no había en la tierra ninguna planta del campo, ni había brotado ninguna hierba del campo, porque Yahvé Dios no había hecho llover sobre la tierra. No había ningún hombre que labrara la tierra, ");
INSERT INTO spablm_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","sino que una niebla subía de la tierra y regaba toda la superficie del suelo. ");
INSERT INTO spablm_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Yahvé Dios formó al hombre del polvo de la tierra y sopló en su nariz aliento de vida, y el hombre se convirtió en un alma viviente. ");
INSERT INTO spablm_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Yahvé Dios plantó un jardín hacia el este, en el Edén, y allí puso al hombre que había formado. ");
INSERT INTO spablm_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","De la tierra Yahvé Dios hizo crecer todo árbol agradable a la vista y bueno para comer, incluyendo el árbol de la vida en medio del jardín y el árbol del conocimiento del bien y del mal. ");
INSERT INTO spablm_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Un río salía del Edén para regar el jardín, y desde allí se dividía y se convertía en la fuente de cuatro ríos. ");
INSERT INTO spablm_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","El nombre del primero es Pishón; fluye por toda la tierra de Havilah, donde hay oro; ");
INSERT INTO spablm_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","y el oro de esa tierra es bueno. También hay allí bdellium y piedra de ónice. ");
INSERT INTO spablm_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","El nombre del segundo río es Gihón. Es el mismo río que atraviesa toda la tierra de Cus. ");
INSERT INTO spablm_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","El nombre del tercer río es Hiddekel. Es el que fluye frente a Asiria. El cuarto río es el Éufrates. ");
INSERT INTO spablm_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Yahvé Dios tomó al hombre y lo puso en el jardín del Edén para que lo cultivara y lo cuidara. ");
INSERT INTO spablm_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Yahvé Dios ordenó al hombre diciendo: “Puedes comer libremente de todos los árboles del jardín; ");
INSERT INTO spablm_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","pero no comerás del árbol del conocimiento del bien y del mal, porque el día que comas de él, morirás.” ");
INSERT INTO spablm_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Yahvé Dios dijo: “No es bueno que el hombre esté solo. Le haré un ayudante comparable a el”. ");
INSERT INTO spablm_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Yahvé Dios formó de la tierra todo animal del campo y toda ave del cielo, y se los llevó al hombre para ver cómo los llamaba. Lo que el hombre llamó a cada criatura viviente se convirtió en su nombre. ");
INSERT INTO spablm_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","El hombre dio nombres a todo el ganado, a las aves del cielo y a todo animal del campo; pero para el hombre no se encontró un ayudante comparable a él. ");
INSERT INTO spablm_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","El Señor Dios hizo que el hombre cayera en un profundo sueño. Mientras el hombre dormía, tomó una de sus costillas y cerró la carne en su lugar. ");
INSERT INTO spablm_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Yahvé Dios hizo una mujer a partir de la costilla que había tomado del hombre, y se la llevó al hombre. ");
INSERT INTO spablm_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","El hombre dijo: “Esto es ahora hueso de mis huesos y carne de mi carne. Se llamará ‘mujer’, porque fue tomada del Hombre”. ");
INSERT INTO spablm_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Por tanto, el hombre dejará a su padre y a su madre y se unirá a su mujer, y serán una sola carne. ");
INSERT INTO spablm_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","El hombre y su mujer estaban desnudos, y no se avergonzaban. ");
INSERT INTO spablm_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","La serpiente era más astuta que cualquier otro animal del campo que había hecho Yahvé Dios. Le dijo a la mujer: “¿De verdad ha dicho Dios: “No comerás de ningún árbol del jardín”?” ");
INSERT INTO spablm_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","La mujer dijo a la serpiente: “Podemos comer del fruto de los árboles del jardín, ");
INSERT INTO spablm_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","pero no del fruto del árbol que está en medio del jardín. Dios ha dicho: ‘No comerás de él. No lo tocarás, para que no mueras”. ");
INSERT INTO spablm_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","La serpiente dijo a la mujer: “No morirás realmente, ");
INSERT INTO spablm_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","porque Dios sabe que el día que lo comas se te abrirán los ojos y serás como Dios, conociendo el bien y el mal.” ");
INSERT INTO spablm_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Cuando la mujer vio que el árbol era bueno para comer y que era un deleite para los ojos, y que el árbol era deseable para hacerse sabio, tomó parte de su fruto y comió. Luego le dio un poco a su marido, que también comió. ");
INSERT INTO spablm_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Se les abrieron los ojos y ambos se dieron cuenta de que estaban desnudos. Cosieron hojas de higuera y se cubrieron. ");
INSERT INTO spablm_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Oyeron la voz de Yahvé Dios que se paseaba por el jardín en el fresco del día, y el hombre y su mujer se escondieron de la presencia de Yahvé Dios entre los árboles del jardín. ");
INSERT INTO spablm_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Yahvé Dios llamó al hombre y le dijo: “¿Dónde estás?”. ");
INSERT INTO spablm_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","El hombre dijo: “Oí tu voz en el jardín, y tuve miedo, porque estaba desnudo; así que me escondí”. ");
INSERT INTO spablm_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Dios dijo: “¿Quién te dijo que estabas desnudo? ¿Has comido del árbol del que te ordené no comer?” ");
INSERT INTO spablm_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","El hombre dijo: “La mujer que me diste para estar conmigo, me dio fruto del árbol y lo comí”. ");
INSERT INTO spablm_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Yahvé Dios dijo a la mujer: “¿Qué has hecho?” La mujer dijo: “La serpiente me engañó y comí”. ");
INSERT INTO spablm_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Yahvé Dios dijo a la serpiente, “Porque has hecho esto, estás maldito por encima de todo el ganado, y por encima de todo animal del campo. Irás sobre tu vientre y comerás polvo todos los días de tu vida. ");
INSERT INTO spablm_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Pondré hostilidad entre tú y la mujer, y entre tu descendencia y la de ella. Te va a magullar la cabeza, y le magullarás el talón”. ");
INSERT INTO spablm_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","A la mujer le dijo, “Multiplicaré en gran medida tus dolores de parto. Tendrás hijos con dolor. Tu deseo será para tu marido, y te gobernará”. ");
INSERT INTO spablm_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","A Adán le dijo, “Porque has escuchado la voz de tu mujer, y han comido del árbol, sobre lo que te ordené, diciendo: ‘No comerás de él’. la tierra está maldita por tu causa. Comerás de él con mucho trabajo todos los días de tu vida. ");
INSERT INTO spablm_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Te dará espinas y cardos; y comerás la hierba del campo. ");
INSERT INTO spablm_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Comerás el pan con el sudor de tu rostro hasta que vuelvas a la tierra, ya que fuiste sacado de ella. Porque tú eres polvo, y volverás al polvo”. ");
INSERT INTO spablm_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","El hombre llamó a su mujer Eva, porque ella sería la madre de todos los vivientes. ");
INSERT INTO spablm_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Yahvé Dios hizo vestidos de pieles de animales para Adán y para su mujer, y los vistió. ");
INSERT INTO spablm_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Yahvé Dios dijo: “He aquí que el hombre ha llegado a ser como uno de nosotros, conociendo el bien y el mal. Ahora bien, para que no extienda su mano y tome también del árbol de la vida, y coma, y viva para siempre —” ");
INSERT INTO spablm_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Por eso Yahvé Dios lo envió fuera del jardín de Edén, para que labrara la tierra de la que fue tomado. ");
INSERT INTO spablm_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Y expulsó al hombre; y puso querubines al oriente del jardín del Edén, y una espada flamígera que se volvía hacia todos lados, para guardar el camino del árbol de la vida. ");
INSERT INTO spablm_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","El hombre conoció Eva, su mujer. Ella concibió, y dio a luz a Caín, y dijo: “He conseguido un hombre con la ayuda de Yahvé”. ");
INSERT INTO spablm_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","De nuevo dio a luz a Abel, el hermano de Caín. Abel era cuidador de ovejas, pero Caín era labrador de la tierra. ");
INSERT INTO spablm_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Con el tiempo, Caín trajo una ofrenda a Yahvé del fruto de la tierra. ");
INSERT INTO spablm_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abel también trajo parte de los primogénitos de su rebaño y de su grasa. Yahvé respetó a Abel y su ofrenda, ");
INSERT INTO spablm_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","pero no respetó a Caín y su ofrenda. Caín se enfadó mucho, y la expresión de su rostro decayó. ");
INSERT INTO spablm_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Yahvé dijo a Caín: “¿Por qué estás enojado? ¿Por qué ha decaído la expresión de tu rostro? ");
INSERT INTO spablm_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Si haces bien, ¿no se levantará? Si no haces bien, el pecado se agazapa a la puerta. Su deseo es para ti, pero tú debes dominarlo”. ");
INSERT INTO spablm_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Caín dijo a Abel, su hermano: “Vamos al campo”. Mientras estaban en el campo, Caín se levantó contra Abel, su hermano, y lo mató. ");
INSERT INTO spablm_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Yahvé dijo a Caín: “¿Dónde está Abel, tu hermano?” Dijo: “No lo sé. ¿Soy el guardián de mi hermano?” ");
INSERT INTO spablm_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","El Señor dijo: “¿Qué has hecho? La voz de la sangre de tu hermano clama a mí desde la tierra. ");
INSERT INTO spablm_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Ahora estás maldito por culpa de la tierra, que ha abierto su boca para recibir la sangre de tu hermano de tu mano. ");
INSERT INTO spablm_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","De ahora en adelante, cuando labres la tierra, no te cederá su fuerza. Serás un fugitivo y un vagabundo en la tierra”. ");
INSERT INTO spablm_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Caín dijo a Yahvé: “Mi castigo es mayor de lo que puedo soportar. ");
INSERT INTO spablm_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","He aquí que hoy me has expulsado de la superficie de la tierra. Quedaré oculto de tu rostro, y seré un fugitivo y un vagabundo en la tierra. Quien me encuentre me matará”. ");
INSERT INTO spablm_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Yahvé le dijo: “Por lo tanto, quien mate a Caín, se vengará de él siete veces”. Yahvé designó una señal para Caín, para que quien lo encontrara no lo golpeara. ");
INSERT INTO spablm_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Caín dejó la presencia de Yahvé y vivió en la tierra de Nod, al este de Edén. ");
INSERT INTO spablm_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Caín conoció a su esposa. Ella concibió y dio a luz a Enoc. Él construyó una ciudad, y llamó a la ciudad con el nombre de su hijo, Enoc. ");
INSERT INTO spablm_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","De Enoc nació Irad. Irad se convirtió en el padre de Mehujael. Mehujael fue el padre de Matusalén. Matusalén fue el padre de Lamec. ");
INSERT INTO spablm_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamec tomó dos esposas: el nombre de la primera fue Ada, y el nombre de la segunda fue Zila. ");
INSERT INTO spablm_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada dio a luz a Jabal, que fue el padre de los que habitan en tiendas y tienen ganado. ");
INSERT INTO spablm_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Su hermano se llamaba Jubal, que fue el padre de todos los que manejan el arpa y la flauta. ");
INSERT INTO spablm_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zila también dio a luz a Tubal Caín, el forjador de todo instrumento cortante de bronce y hierro. La hermana de Tubal Caín fue Naama. ");
INSERT INTO spablm_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lamec dijo a sus esposas, “Adah y Zila, escuchen mi voz. Esposas de Lamec, escuchad mi discurso, porque he matado a un hombre por herirme, un joven por haberme golpeado. ");
INSERT INTO spablm_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Si Caín será vengado siete veces, verdaderamente Lamec setenta y siete veces”. ");
INSERT INTO spablm_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adán volvió a conocer a su mujer. Ella dio a luz un hijo, y le puso el nombre de Set, diciendo: “Porque Dios me ha dado otro hijo en lugar de Abel, ya que Caín lo mató”. ");
INSERT INTO spablm_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","También le nació un hijo a Set, y lo llamó Enós. En aquel tiempo los hombres comenzaron a invocar el nombre de Yahvé. ");
INSERT INTO spablm_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Este es el libro de las generaciones de Adán. El día que Dios creó al hombre, lo hizo a su semejanza. ");
INSERT INTO spablm_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Los creó varón y mujer, y los bendijo. El día en que fueron creados, les puso el nombre de Adán. ");
INSERT INTO spablm_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adán vivió ciento treinta años y fue padre de un hijo a su imagen y semejanza, al que llamó Set. ");
INSERT INTO spablm_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Los días de Adán después de ser padre de Set fueron ochocientos años, y llegó a ser padre de otros hijos e hijas. ");
INSERT INTO spablm_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Todos los días que vivió Adán fueron novecientos treinta años, y luego murió. ");
INSERT INTO spablm_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Set vivió ciento cinco años y luego fue padre de Enós. ");
INSERT INTO spablm_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Set vivió después de ser padre de Enós ochocientos siete años, y fue padre de otros hijos e hijas. ");
INSERT INTO spablm_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Todos los días de Set fueron novecientos doce años, y luego murió. ");
INSERT INTO spablm_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enós vivió noventa años y fue padre de Cainan. ");
INSERT INTO spablm_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Enós vivió, después de ser padre de Cainan, ochocientos quince años, y fue padre de otros hijos e hijas. ");
INSERT INTO spablm_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Todos los días de Enós fueron novecientos cinco años, y luego murió. ");
INSERT INTO spablm_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Cainan vivió setenta años, y luego fue padre de Mahalalel. ");
INSERT INTO spablm_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Cainan vivió después de ser padre de Mahalalel ochocientos cuarenta años, y fue padre de otros hijos e hijas ");
INSERT INTO spablm_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","y todos los días de Cainan fueron novecientos diez años, luego murió. ");
INSERT INTO spablm_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalalel vivió sesenta y cinco años, y luego fue padre de Jared. ");
INSERT INTO spablm_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Mahalalel vivió, después de ser padre de Jared, ochocientos treinta años, y fue padre de otros hijos e hijas. ");
INSERT INTO spablm_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Todos los días de Mahalalel fueron ochocientos noventa y cinco años, y luego murió. ");
INSERT INTO spablm_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Jared vivió ciento sesenta y dos años, y luego fue padre de Enoc. ");
INSERT INTO spablm_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Jared vivió después de ser padre de Enoc ochocientos años, y fue padre de otros hijos e hijas. ");
INSERT INTO spablm_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Todos los días de Jared fueron novecientos sesenta y dos años, y luego murió. ");
INSERT INTO spablm_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enoc vivió sesenta y cinco años, y luego fue padre de Matusalén. ");
INSERT INTO spablm_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Después del nacimiento de Matusalén, Enoc caminó con Dios durante trescientos años y fue padre de más hijos e hijas. ");
INSERT INTO spablm_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Todos los días de Enoc fueron trescientos sesenta y cinco años. ");
INSERT INTO spablm_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enoc caminó con Dios, y no fue hallado, pues Dios se lo llevó. ");
INSERT INTO spablm_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Matusalén vivió ciento ochenta y siete años, y luego fue padre de Lamec. ");
INSERT INTO spablm_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Matusalén vivió, después de ser padre de Lamec, setecientos ochenta y dos años, y fue padre de otros hijos e hijas. ");
INSERT INTO spablm_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Todos los días de Matusalén fueron novecientos sesenta y nueve años, y luego murió. ");
INSERT INTO spablm_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamec vivió ciento ochenta y dos años, y luego fue padre de un hijo. ");
INSERT INTO spablm_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Le puso el nombre de Noé, diciendo: “Éste nos consolará en nuestro trabajo y en el trabajo de nuestras manos, causado por la tierra que Yahvé ha maldecido.” ");
INSERT INTO spablm_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Lamec vivió, después de ser padre de Noé, quinientos noventa y cinco años, y fue padre de otros hijos e hijas. ");
INSERT INTO spablm_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Todos los días de Lamec fueron setecientos setenta y siete años, y luego murió. ");
INSERT INTO spablm_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noé tenía quinientos años, entonces Noé fue padre de Sem, Cam y Jafet. ");
INSERT INTO spablm_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Cuando los hombres comenzaron a multiplicarse sobre la superficie de la tierra, y les nacieron hijas, ");
INSERT INTO spablm_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Los hijos de Dios vieron que las hijas de los hombres eran hermosas, y tomaron para sí las que quisieron como esposas. ");
INSERT INTO spablm_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Yahvé dijo: “Mi Espíritu no luchará con el hombre para siempre, porque él también es carne; así que sus días serán de ciento veinte años.” ");
INSERT INTO spablm_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Los Nefilim estaban en la tierra en esos días, y también después de eso, cuando los hijos de Dios entraron a las hijas de los hombres y tuvieron hijos con ellas. Esos eran los hombres poderosos que había en la antigüedad, hombres de renombre. ");
INSERT INTO spablm_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Yahvé vio que la maldad del hombre era grande en la tierra, y que todo designio de los pensamientos del corazón del hombre era de continuo sólo el mal. ");
INSERT INTO spablm_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Yahvé se arrepintió de haber hecho al hombre en la tierra, y le dolió en su corazón. ");
INSERT INTO spablm_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Yahvé dijo: “Destruiré al hombre que he creado de la superficie de la tierra, junto con los animales, los reptiles y las aves del cielo, pues me arrepiento de haberlos hecho.” ");
INSERT INTO spablm_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Pero Noé encontró el favor de los ojos de Yahvé. ");
INSERT INTO spablm_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Esta es la historia de las generaciones de Noé: Noé era un hombre justo, irreprochable entre la gente de su tiempo. Noé caminó con Dios. ");
INSERT INTO spablm_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noé fue padre de tres hijos: Sem, Cam y Jafet. ");
INSERT INTO spablm_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","La tierra estaba corrompida ante Dios, y la tierra estaba llena de violencia. ");
INSERT INTO spablm_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Dios vio la tierra y vio que estaba corrompida, porque toda la carne había corrompido su camino en la tierra. ");
INSERT INTO spablm_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Dios dijo a Noé: “Voy a acabar con toda la carne, porque la tierra está llena de violencia por culpa de ellos. He aquí que los destruiré a ellos y a la tierra. ");
INSERT INTO spablm_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Haz un barco de madera de topo. Harás habitaciones en la nave, y la sellarás por dentro y por fuera con brea. ");
INSERT INTO spablm_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Así lo harás. La longitud de la nave será de trescientos codos, su anchura de cincuenta codos, y su altura de treinta codos. ");
INSERT INTO spablm_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Harás un techo en la nave, y lo terminarás a un codo hacia arriba. Pondrás la puerta de la nave en su costado. La harás con niveles inferior, segundo y tercero. ");
INSERT INTO spablm_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Yo, yo mismo, traeré el diluvio de aguas sobre esta tierra, para destruir toda carne que tenga aliento de vida de debajo del cielo. Todo lo que hay en la tierra morirá. ");
INSERT INTO spablm_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Pero yo estableceré mi pacto con ustedes. Entrarás en la nave, tú, tus hijos, tu mujer y las mujeres de tus hijos contigo. ");
INSERT INTO spablm_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","De todo ser viviente de toda carne, traerás dos de cada especie a la nave, para mantenerlos vivos contigo. Serán macho y hembra. ");
INSERT INTO spablm_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","De las aves según su especie, del ganado según su especie, de todo reptil del suelo según su especie, dos de cada especie irán con vosotros, para mantenerlos con vida. ");
INSERT INTO spablm_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Toma contigo algo de todo lo que se come, y recógelo para ti, y te servirá de alimento a ti y a ellos.” ");
INSERT INTO spablm_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Así hizo Noé. Hizo todo lo que Dios le ordenó. ");
INSERT INTO spablm_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Yahvé dijo a Noé: “Sube con toda tu familia a la nave, porque he visto tu justicia ante mí en esta generación. ");
INSERT INTO spablm_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Llevarás contigo siete parejas de cada animal limpio, el macho y su hembra. De los animales que no están limpios, toma dos, el macho y su hembra. ");
INSERT INTO spablm_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","También de las aves del cielo, siete y siete, macho y hembra, para mantener viva la semilla en la superficie de toda la tierra. ");
INSERT INTO spablm_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","En siete días haré llover sobre la tierra durante cuarenta días y cuarenta noches. Destruiré todo ser viviente que he hecho de la superficie de la tierra”. ");
INSERT INTO spablm_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Noé hizo todo lo que Yahvé le ordenó. ");
INSERT INTO spablm_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noé tenía seiscientos años cuando el diluvio de aguas llegó a la tierra. ");
INSERT INTO spablm_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Noé subió a la nave con sus hijos, su mujer y las mujeres de sus hijos, a causa de las aguas del diluvio. ");
INSERT INTO spablm_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Los animales limpios, los inmundos, las aves y todo lo que se arrastra por el suelo ");
INSERT INTO spablm_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","entraron por parejas con Noé en la nave, machos y hembras, como Dios le había ordenado a Noé. ");
INSERT INTO spablm_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Después de los siete días, las aguas de la inundación llegaron a la tierra. ");
INSERT INTO spablm_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","En el año seiscientos de la vida de Noé, en el segundo mes, a los diecisiete días del mes, ese día estallaron todas las fuentes del gran abismo y se abrieron las ventanas del cielo. ");
INSERT INTO spablm_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Llovió sobre la tierra durante cuarenta días y cuarenta noches. ");
INSERT INTO spablm_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","En el mismo día Noé, y Sem, Cam y Jafet — los hijos de Noé — y la esposa de Noé y las tres esposas de sus hijos con ellos, entraron en la nave — ");
INSERT INTO spablm_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","ellos, y todo animal según su especie, todo el ganado según su especie, todo reptil que se arrastra sobre la tierra según su especie, y toda ave según su especie, toda ave de toda clase. ");
INSERT INTO spablm_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Las parejas de toda carne con aliento de vida entraron en la nave hacia Noé. ");
INSERT INTO spablm_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Los que entraron, entraron macho y hembra de toda carne, como Dios le ordenó; entonces Yahvé lo encerró. ");
INSERT INTO spablm_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","El diluvio duró cuarenta días sobre la tierra. Las aguas aumentaron, y levantaron la nave, y ésta se elevó sobre la tierra. ");
INSERT INTO spablm_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Las aguas crecieron y aumentaron mucho sobre la tierra, y el barco flotaba sobre la superficie de las aguas. ");
INSERT INTO spablm_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Las aguas se elevaron mucho sobre la tierra. Todos los montes altos que había bajo todo el cielo quedaron cubiertos. ");
INSERT INTO spablm_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Las aguas subieron quince codos más, y las montañas quedaron cubiertas. ");
INSERT INTO spablm_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Murió toda la carne que se movía sobre la tierra, incluyendo las aves, el ganado, los animales, todo lo que se arrastra sobre la tierra y todo hombre. ");
INSERT INTO spablm_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Murió todo lo que estaba en la tierra firme, en cuyas narices había aliento de espíritu de vida. ");
INSERT INTO spablm_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Fue destruido todo ser viviente que estaba sobre la superficie de la tierra, incluidos el hombre, el ganado, los reptiles y las aves del cielo. Fueron destruidos de la tierra. Sólo quedó Noé y los que estaban con él en la nave. ");
INSERT INTO spablm_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Las aguas inundaron la tierra durante ciento cincuenta días. ");
INSERT INTO spablm_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Dios se acordó de Noé, de todos los animales y de todo el ganado que estaba con él en el barco; y Dios hizo pasar un viento sobre la tierra. Las aguas se calmaron. ");
INSERT INTO spablm_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","También se detuvieron las fuentes de las profundidades y las ventanas del cielo, y se frenó la lluvia del cielo. ");
INSERT INTO spablm_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Las aguas se retiraron continuamente de la tierra. Al cabo de ciento cincuenta días las aguas se retiraron. ");
INSERT INTO spablm_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","La nave se detuvo en el séptimo mes, el día diecisiete del mes, sobre las montañas de Ararat. ");
INSERT INTO spablm_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Las aguas retrocedieron continuamente hasta el décimo mes. En el décimo mes, el primer día del mes, las cimas de las montañas fueron visibles. ");
INSERT INTO spablm_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Al cabo de cuarenta días, Noé abrió la ventana de la nave que había hecho, ");
INSERT INTO spablm_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","y envió un cuervo. Fue de un lado a otro, hasta que las aguas se secaron de la tierra. ");
INSERT INTO spablm_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Él mismo envió una paloma para ver si las aguas se habían retirado de la superficie de la tierra, ");
INSERT INTO spablm_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","pero la paloma no encontró lugar para posar su pie, y volvió a la nave hacia él, porque las aguas estaban en la superficie de toda la tierra. Él extendió la mano, la tomó y la introdujo en la nave. ");
INSERT INTO spablm_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Esperó aún otros siete días, y volvió a enviar a la paloma fuera de la nave. ");
INSERT INTO spablm_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Al anochecer, la paloma regresó a él, y he aquí que en su boca había una hoja de olivo recién arrancada. Así Noé supo que las aguas habían desaparecido de la tierra. ");
INSERT INTO spablm_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Esperó aún otros siete días y envió a la paloma, y ésta ya no volvió a él. ");
INSERT INTO spablm_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","En el año seiscientos uno, en el primer mes, el primer día del mes, las aguas se secaron de la tierra. Noé quitó la cubierta de la nave y miró. Vio que la superficie de la tierra estaba seca. ");
INSERT INTO spablm_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","En el segundo mes, a los veintisiete días del mes, la tierra estaba seca. ");
INSERT INTO spablm_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Dios habló a Noé, diciendo: ");
INSERT INTO spablm_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Sal de la nave, tú, tu mujer, tus hijos y las mujeres de tus hijos contigo. ");
INSERT INTO spablm_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Saca contigo todo ser viviente de toda carne, incluyendo las aves, el ganado y todo animal que se arrastra sobre la tierra, para que se reproduzcan abundantemente en la tierra, y sean fructíferos y se multipliquen sobre la tierra.” ");
INSERT INTO spablm_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Noé salió con sus hijos, su mujer y las mujeres de sus hijos. ");
INSERT INTO spablm_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Todo animal, todo reptil y toda ave, todo lo que se mueve en la tierra, según sus familias, salió de la nave. ");
INSERT INTO spablm_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Noé construyó un altar a Yahvé, y tomó de todo animal limpio y de toda ave limpia, y ofreció holocaustos sobre el altar. ");
INSERT INTO spablm_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Yahvé olió el agradable aroma. Yahvé dijo en su corazón: “No volveré a maldecir la tierra por causa del hombre, porque la imaginación del corazón del hombre es mala desde su juventud. No volveré a golpear a todo ser viviente, como lo he hecho. ");
INSERT INTO spablm_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Mientras la tierra permanezca, no cesarán el tiempo de la siembra y la cosecha, el frío y el calor, el verano y el invierno, el día y la noche.” ");
INSERT INTO spablm_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Dios bendijo a Noé y a sus hijos y les dijo: “Sed fecundos, multiplicaos y llenad la tierra. ");
INSERT INTO spablm_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","El temor y el miedo a vosotros recaerán sobre todos los animales de la tierra y sobre todas las aves del cielo. Todo lo que se mueve por la tierra, y todos los peces del mar, serán entregados en tu mano. ");
INSERT INTO spablm_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Todo lo que se mueve y vive será alimento para ti. Así como te di la hierba verde, te he dado todo. ");
INSERT INTO spablm_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Pero la carne con vida, es decir, su sangre, no la comeréis. ");
INSERT INTO spablm_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Ciertamente pediré cuentas por la sangre de tu vida. A la mano de todo animal se la exigiré. A la mano del hombre, incluso a la mano del hermano de todo hombre, le exigiré la vida del hombre. ");
INSERT INTO spablm_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","El que derrame sangre de hombre, su sangre será derramada por el hombre, porque Dios hizo al hombre a su imagen y semejanza. ");
INSERT INTO spablm_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Sed fecundos y multiplicaos. Creced en abundancia en la tierra y multiplicaos en ella”. ");
INSERT INTO spablm_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Dios habló a Noé y a sus hijos con él, diciendo: ");
INSERT INTO spablm_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“En cuanto a mí, he aquí que yo establezco mi pacto con vosotros, y con vuestra descendencia después de vosotros, ");
INSERT INTO spablm_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","y con toda criatura viviente que está con vosotros: las aves, el ganado y todo animal de la tierra con vosotros, de todos los que salen de la nave, todo animal de la tierra. ");
INSERT INTO spablm_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Estableceré mi pacto con vosotros: Toda la carne no volverá a ser eliminada por las aguas del diluvio. Nunca más habrá un diluvio que destruya la tierra”. ");
INSERT INTO spablm_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Dios dijo: “Esta es la señal de la alianza que hago entre ustedes y yo, y toda criatura viviente que está con ustedes, por generaciones perpetuas: ");
INSERT INTO spablm_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Yo pongo mi arco iris en la nube, y será una señal de alianza entre la tierra y yo. ");
INSERT INTO spablm_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Cuando traiga una nube sobre la tierra, para que el arco iris se vea en la nube, ");
INSERT INTO spablm_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","me acordaré de mi pacto, que es entre yo y vosotros y toda criatura viviente de toda carne, y las aguas no se convertirán más en un diluvio para destruir toda carne. ");
INSERT INTO spablm_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","El arco iris estará en la nube. Lo miraré para acordarme del pacto eterno entre Dios y toda criatura viviente de toda carne que está en la tierra.” ");
INSERT INTO spablm_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Dios dijo a Noé: “Esta es la señal de la alianza que he establecido entre yo y toda la carne que está sobre la tierra.” ");
INSERT INTO spablm_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Los hijos de Noé que salieron de la nave fueron Sem, Cam y Jafet. Cam es el padre de Canaán. ");
INSERT INTO spablm_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Estos tres fueron los hijos de Noé, y de ellos se pobló toda la tierra. ");
INSERT INTO spablm_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noé comenzó a ser agricultor y plantó una viña. ");
INSERT INTO spablm_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Bebió del vino y se emborrachó. Se descubrió dentro de su tienda. ");
INSERT INTO spablm_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Cam, el padre de Canaán, vio la desnudez de su padre y se lo dijo a sus dos hermanos que estaban fuera. ");
INSERT INTO spablm_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Sem y Jafet tomaron una prenda de vestir, se la pusieron sobre los hombros de ambos, entraron de espaldas y cubrieron la desnudez de su padre. Sus rostros estaban al revés, y no vieron la desnudez de su padre. ");
INSERT INTO spablm_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Noé despertó de su vino y supo lo que su hijo menor le había hecho. ");
INSERT INTO spablm_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Dijo, “Canaán está maldito. Será siervo de los siervos de sus hermanos”. ");
INSERT INTO spablm_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Él dijo, “Bendito sea Yahvé, el Dios de Sem. Que Canaán sea su siervo. ");
INSERT INTO spablm_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Que Dios engrandezca a Jafet. Que habite en las tiendas de Sem. Que Canaán sea su siervo”. ");
INSERT INTO spablm_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Noé vivió trescientos cincuenta años después del diluvio. ");
INSERT INTO spablm_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Todos los días de Noé fueron novecientos cincuenta años, y luego murió. ");
INSERT INTO spablm_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Esta es la historia de las generaciones de los hijos de Noé y de Sem, Cam y Jafet. Les nacieron hijos después del diluvio. ");
INSERT INTO spablm_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Los hijos de Jafet fueron: Gomer, Magog, Madai, Javan, Tubal, Mesec y Tiras. ");
INSERT INTO spablm_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Los hijos de Gomer fueron: Askenaz, Rifat y Togarma. ");
INSERT INTO spablm_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Los hijos de Javán fueron: Elisa, Tarsis, Quitim y Dodanim. ");
INSERT INTO spablm_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","De éstos se dividieron las islas de las naciones en sus tierras, cada uno según su lengua, según sus familias, en sus naciones. ");
INSERT INTO spablm_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Los hijos de Cam fueron: Cus, Mizraim, Put y Canaán. ");
INSERT INTO spablm_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Los hijos de Cus fueron: Seba, Havila, Sabta, Raama y Sabteca. Los hijos de Raama fueron: Sabá y Dedán. ");
INSERT INTO spablm_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Cus fue el padre de Nimrod. Él comenzó a ser un poderoso en la tierra. ");
INSERT INTO spablm_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Fue un poderoso cazador ante Yahvé. Por eso se dice: “como Nimrod, un poderoso cazador ante Yahvé”. ");
INSERT INTO spablm_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","El principio de su reino fue Babel, Erec, Acad y Calne, en la tierra de Sinar. ");
INSERT INTO spablm_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","De esa tierra pasó a Asiria y construyó Nínive, Rehobot Ir, Cala, ");
INSERT INTO spablm_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","y Resen entre Nínive y la gran ciudad Cala. ");
INSERT INTO spablm_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mizraim fue el padre de Ludim, Anamim, Lehabim, Naftuhim, ");
INSERT INTO spablm_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patrusim, Casluhim (del que descienden los filisteos) y Caftorim. ");
INSERT INTO spablm_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Canaán fue padre de Sidón (su primogénito), de Het, de ");
INSERT INTO spablm_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","de los jebuseos, de los amorreos, de los gergeseos, de ");
INSERT INTO spablm_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","de los heveos, de los arquitas, de los sinitas, de ");
INSERT INTO spablm_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","de los arvaditas, de los zemaritas y de los hamateos. Después, las familias de los cananeos se extendieron por el mundo. ");
INSERT INTO spablm_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","La frontera de los cananeos iba desde Sidón — en dirección a Gerar — hasta Gaza — en dirección a Sodoma, Gomorra, Adma y Zeboiim — hasta Lasa. ");
INSERT INTO spablm_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Estos son los hijos de Cam, por sus familias, según sus lenguas, en sus tierras y sus naciones. ");
INSERT INTO spablm_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","También le nacieron hijos a Sem (el hermano mayor de Jafet), el padre de todos los hijos de Éber. ");
INSERT INTO spablm_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Los hijos de Sem fueron: Elam, Asur, Arfaxad, Lud y Aram. ");
INSERT INTO spablm_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Los hijos de Aram fueron: Uz, Hul, Geter y Mas. ");
INSERT INTO spablm_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arfaxad fue el padre de Sala. Sala fue el padre de Heber. ");
INSERT INTO spablm_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","A Heber le nacieron dos hijos. El nombre de uno fue Peleg, porque en sus días la tierra fue dividida. El nombre de su hermano fue Joctán. ");
INSERT INTO spablm_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Joctán fue padre de Almodad, Selef, Hazarmavet, Jera, ");
INSERT INTO spablm_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Adoram, Uzal, Dicla, ");
INSERT INTO spablm_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Seba, ");
INSERT INTO spablm_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Havila y Jobab. Todos ellos eran hijos de Joctán. ");
INSERT INTO spablm_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Su morada se extendía desde Mesá, a medida que se avanza hacia Sefar, la montaña del oriente. ");
INSERT INTO spablm_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Estos son los hijos de Sem, por sus familias, según sus lenguas, tierras y naciones. ");
INSERT INTO spablm_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Estas son las familias de los hijos de Noé, por sus generaciones, según sus naciones. Las naciones se dividieron de éstas en la tierra después del diluvio. ");
INSERT INTO spablm_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Toda la tierra tenía una misma lengua y un mismo lenguaje. ");
INSERT INTO spablm_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Mientras viajaban hacia el este, encontraron una llanura en la tierra de Sinar, y allí vivieron. ");
INSERT INTO spablm_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Se dijeron unos a otros: “Venid, hagamos ladrillos y quemémoslos bien”. Tenían ladrillos por piedra, y usaban alquitrán como mortero. ");
INSERT INTO spablm_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Dijeron: “Vengan, construyamos una ciudad y una torre cuya cima llegue al cielo, y hagamos un nombre para nosotros, no sea que nos dispersemos por la superficie de toda la tierra.” ");
INSERT INTO spablm_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Yahvé bajó a ver la ciudad y la torre que los hijos de los hombres construyeron. ");
INSERT INTO spablm_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Yahvé dijo: “He aquí que son un solo pueblo, y todos tienen una sola lengua, y esto es lo que comienzan a hacer. Ahora no se les impedirá nada de lo que pretenden hacer. ");
INSERT INTO spablm_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Vamos, bajemos y confundamos allí su lengua, para que no entiendan el habla de los demás.” ");
INSERT INTO spablm_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Así que el Señor los dispersó desde allí por la superficie de toda la tierra. Dejaron de construir la ciudad. ");
INSERT INTO spablm_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Por eso su nombre fue llamado Babel, porque allí Yahvé confundió el lenguaje de toda la tierra. Desde allí, Yahvé los dispersó por la superficie de toda la tierra. ");
INSERT INTO spablm_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Esta es la historia de las generaciones de Sem: Sem tenía cien años cuando fue padre de Arpachshad dos años después del diluvio. ");
INSERT INTO spablm_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Sem vivió quinientos años después de ser padre de Arfaxad, y fue padre de más hijos e hijas. ");
INSERT INTO spablm_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arfaxad vivió treinta y cinco años y llegó a ser el padre de Sala. ");
INSERT INTO spablm_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Arfaxad vivió cuatrocientos tres años después de ser el padre de Shelah, y llegó a ser el padre de más hijos e hijas. ");
INSERT INTO spablm_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sala vivió treinta años y fue padre de Heber. ");
INSERT INTO spablm_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Sala vivió cuatrocientos tres años después de ser padre de Heber, y fue padre de más hijos e hijas. ");
INSERT INTO spablm_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Heber vivió treinta y cuatro años y fue padre de Peleg. ");
INSERT INTO spablm_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Heber vivió cuatrocientos treinta años después de ser padre de Peleg, y fue padre de más hijos e hijas. ");
INSERT INTO spablm_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Peleg vivió treinta años y fue padre de Reu. ");
INSERT INTO spablm_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Peleg vivió doscientos nueve años después de ser padre de Reu, y fue padre de más hijos e hijas. ");
INSERT INTO spablm_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reu vivió treinta y dos años, y llegó a ser el padre de Serug. ");
INSERT INTO spablm_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Reu vivió doscientos siete años después de ser padre de Serug, y fue padre de más hijos e hijas. ");
INSERT INTO spablm_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serug vivió treinta años y llegó a ser padre de Nacor. ");
INSERT INTO spablm_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Serug vivió doscientos años después de ser padre de Nacor, y llegó a ser padre de más hijos e hijas. ");
INSERT INTO spablm_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nacor vivió veintinueve años, y llegó a ser padre de Taré. ");
INSERT INTO spablm_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Nacor vivió ciento diecinueve años después de ser padre de Taré, y llegó a ser padre de más hijos e hijas. ");
INSERT INTO spablm_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Taré vivió setenta años y fue padre de Abram, Nacor y Harán. ");
INSERT INTO spablm_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Esta es la historia de las generaciones de Taré. Taré fue el padre de Abram, Nacor y Harán. Harán fue el padre de Lot. ");
INSERT INTO spablm_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Harán murió en su tierra natal, en Ur de los Caldeos, mientras su padre Taré aún vivía. ");
INSERT INTO spablm_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram y Nacor se casaron con esposas. El nombre de la esposa de Abram era Sarai, y el nombre de la esposa de Nacor era Milca, hija de Harán, quien también era el padre de Isca. ");
INSERT INTO spablm_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarai era estéril. No tuvo ningún hijo. ");
INSERT INTO spablm_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Taré tomó a Abram, su hijo, a Lot, hijo de Harán, y a Sarai, su nuera, esposa de su hijo Abram. Salieron de Ur de los Caldeos para ir a la tierra de Canaán. Llegaron a Harán y vivieron allí. ");
INSERT INTO spablm_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Los días de Taré fueron doscientos cinco años. Taré murió en Harán. ");
INSERT INTO spablm_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","El Señor dijo a Abram: “Deja tu país, tus parientes y la casa de tu padre, y vete a la tierra que te mostraré. ");
INSERT INTO spablm_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Haré de ti una gran nación. Te bendeciré y engrandeceré tu nombre. Serás una bendición. ");
INSERT INTO spablm_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Bendeciré a los que te bendigan y maldeciré a los que te traten con desprecio. Todas las familias de la tierra serán bendecidas por ti”. ");
INSERT INTO spablm_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Así que Abram se fue, como Yahvé le había dicho. Lot lo acompañó. Abram tenía setenta y cinco años cuando partió de Harán. ");
INSERT INTO spablm_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abram tomó a Sarai, su esposa, a Lot, el hijo de su hermano, todas las posesiones que habían reunido y el pueblo que habían adquirido en Harán, y se fueron a la tierra de Canaán. Entraron en la tierra de Canaán. ");
INSERT INTO spablm_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram pasó por la tierra hasta el lugar de Siquem, hasta la encina de Moreh. En ese momento, los cananeos estaban en la tierra. ");
INSERT INTO spablm_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Yahvé se le apareció a Abram y le dijo: “Le daré esta tierra a tu descendencia”. Allí construyó un altar a Yahvé, que se le había aparecido. ");
INSERT INTO spablm_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Salió de allí para ir a la montaña que está al este de Betel y acampó, teniendo Betel al oeste y Hai al este. Allí construyó un altar a Yahvé e invocó el nombre de Yahvé. ");
INSERT INTO spablm_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Abram siguió viajando, todavía en dirección al sur. ");
INSERT INTO spablm_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Hubo hambre en la tierra. Abram bajó a Egipto para vivir como extranjero allí, porque el hambre era grave en la tierra. ");
INSERT INTO spablm_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Cuando estuvo a punto de entrar en Egipto, le dijo a Sarai, su esposa: “Mira ahora, sé que eres una mujer hermosa de ver. ");
INSERT INTO spablm_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Sucederá que cuando los egipcios te vean, dirán: ‘Esta es su mujer’. A mí me matarán, pero a ti te salvarán viva. ");
INSERT INTO spablm_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Por favor, di que eres mi hermana, para que me vaya bien por ti y para que mi alma viva gracias a ti.” ");
INSERT INTO spablm_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Cuando Abram llegó a Egipto, los egipcios vieron que la mujer era muy hermosa. ");
INSERT INTO spablm_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Los príncipes del faraón la vieron y la alabaron ante el faraón; y la mujer fue llevada a la casa del faraón. ");
INSERT INTO spablm_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Este trató bien a Abram por causa de ella. Tuvo ovejas, ganado, asnos machos, siervos machos, siervas hembras, asnos hembras y camellos. ");
INSERT INTO spablm_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","El Señor afligió al faraón y a su casa con grandes plagas a causa de Sarai, la esposa de Abram. ");
INSERT INTO spablm_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","El faraón llamó a Abram y le dijo: “¿Qué es esto que me has hecho? ¿Por qué no me dijiste que era tu mujer? ");
INSERT INTO spablm_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","¿Por qué dijiste: ‘Es mi hermana’, para que la tomara por esposa? Ahora, pues, ve a tu mujer, tómala y vete”. ");
INSERT INTO spablm_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","El faraón ordenó a los hombres que se ocuparan de él, y lo escoltaron con su mujer y todo lo que tenía. ");
INSERT INTO spablm_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abram subió de Egipto — él, su mujer, todo lo que tenía, y Lot con él — al Sur. ");
INSERT INTO spablm_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram era muy rico en ganado, en plata y en oro. ");
INSERT INTO spablm_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Siguió su camino desde el sur hasta Betel, hasta el lugar donde había estado su tienda al principio, entre Betel y Hai, ");
INSERT INTO spablm_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","hasta el lugar del altar que había hecho allí al principio. Allí Abram invocó el nombre de Yahvé. ");
INSERT INTO spablm_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","También Lot, que iba con Abram, tenía rebaños, vacas y tiendas. ");
INSERT INTO spablm_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","La tierra no podía sostenerlos para que vivieran juntos, pues sus posesiones eran tan grandes que no podían vivir juntos. ");
INSERT INTO spablm_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Hubo disputas entre los pastores del ganado de Abram y los pastores del ganado de Lot. Los cananeos y los ferezeos vivían entonces en la tierra. ");
INSERT INTO spablm_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Abram le dijo a Lot: “Por favor, que no haya disputas entre tú y yo, y entre tus pastores y los míos, porque somos parientes. ");
INSERT INTO spablm_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","¿No está toda la tierra ante ti? Por favor, sepárense de mí. Si te vas a la izquierda, yo me iré a la derecha. O si te vas a la derecha, entonces yo me iré a la izquierda”. ");
INSERT INTO spablm_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lot alzó los ojos y vio toda la llanura del Jordán, que estaba bien regada por todas partes, antes de que Yahvé destruyera a Sodoma y Gomorra, como el jardín de Yahvé, como la tierra de Egipto, al ir a Zoar. ");
INSERT INTO spablm_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Así que Lot eligió para sí la llanura del Jordán. Lot viajó hacia el este, y se separaron el uno del otro. ");
INSERT INTO spablm_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram vivió en la tierra de Canaán, y Lot vivió en las ciudades de la llanura, y trasladó su tienda hasta Sodoma. ");
INSERT INTO spablm_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Los hombres de Sodoma eran sumamente malvados y pecadores contra el Señor. ");
INSERT INTO spablm_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Yahvé dijo a Abram, después de que Lot se separó de él: “Ahora, levanta tus ojos y mira desde el lugar donde estás, hacia el norte y el sur y hacia el este y el oeste, ");
INSERT INTO spablm_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","porque daré toda la tierra que ves a ti y a tu descendencia para siempre. ");
INSERT INTO spablm_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Haré que tu descendencia sea como el polvo de la tierra, de modo que si un hombre puede contar el polvo de la tierra, también tu descendencia podrá ser contada. ");
INSERT INTO spablm_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Levántate, recorre la tierra a lo largo y a lo ancho, porque yo te la daré”. ");
INSERT INTO spablm_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Abram trasladó su tienda y vino a vivir junto a las encinas de Mamre, que están en Hebrón, y construyó allí un altar a Yahvé. ");
INSERT INTO spablm_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","En los días de Amrafel, rey de Sinar; Arioc, rey de Elasar; Quedorlaomer, rey de Elam; y Tidal, rey de Goim, ");
INSERT INTO spablm_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","hicieron la guerra a Bera, rey de Sodoma; a Birsa, rey de Gomorra; a Sinab, rey de Adma; a Semeber, rey de Zeboim; y al rey de Bela (también llamado Zoar). ");
INSERT INTO spablm_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Todos ellos se unieron en el valle de Sidim (también llamado Mar Salado). ");
INSERT INTO spablm_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Sirvieron a Quedorlaomer durante doce años, y en el año trece se rebelaron. ");
INSERT INTO spablm_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","En el decimocuarto año Quedorlaomer y los reyes que estaban con él vinieron y golpearon a los refaítas en Astarot Karnaim, a los zuzim en Ham, a los emim en Save Quiriataim, ");
INSERT INTO spablm_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","y a los horeos en su monte Seir, hasta El Paran, que está junto al desierto. ");
INSERT INTO spablm_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Volvieron y llegaron a En Mispat (también llamado Cades), y atacaron todo el país de los amalecitas, y también a los amorreos que vivían en Hazazón Tamar. ");
INSERT INTO spablm_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Salieron el rey de Sodoma y el rey de Gomorra, el rey de Adma, el rey de Zeboim y el rey de Bela (también llamada Zoar), y prepararon la batalla contra ellos en el valle de Sidim ");
INSERT INTO spablm_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","contra Quedorlaomer, rey de Elam, Tidal, rey de Goim, Amrafel, rey de Sinar, y Arioc, rey de Elasar; cuatro reyes contra los cinco. ");
INSERT INTO spablm_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","El valle de Sidim estaba lleno de pozos de brea, y los reyes de Sodoma y Gomorra huyeron, y algunos cayeron allí. Los que quedaron huyeron a las colinas. ");
INSERT INTO spablm_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Tomaron todos los bienes de Sodoma y Gomorra, y toda su comida, y se fueron. ");
INSERT INTO spablm_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Tomaron a Lot, el hijo del hermano de Abram, que vivía en Sodoma, y sus bienes, y se fueron. ");
INSERT INTO spablm_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Uno que había escapado vino y se lo contó a Abram, el hebreo. En aquel tiempo, vivía junto a los robles de Mamre, el amorreo, hermano de Escol y hermano de Aner. Eran aliados de Abram. ");
INSERT INTO spablm_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Cuando Abram se enteró de que su pariente estaba cautivo, sacó a sus trescientos dieciocho hombres entrenados, nacidos en su casa, y los persiguió hasta Dan. ");
INSERT INTO spablm_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Se dividió contra ellos de noche, él y sus siervos, y los atacó, y los persiguió hasta Hoba, que está a la izquierda de Damasco. ");
INSERT INTO spablm_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Hizo volver todos los bienes, y también hizo volver a su pariente Lot y sus bienes, y también a las mujeres y a las demás personas. ");
INSERT INTO spablm_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","El rey de Sodoma salió a recibirlo después de su regreso de la matanza de Quedorlaomer y de los reyes que estaban con él, en el valle de Save (es decir, el Valle del Rey). ");
INSERT INTO spablm_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Melquisedec, rey de Salem, sacó pan y vino. Era sacerdote del Dios Altísimo. ");
INSERT INTO spablm_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Lo bendijo y dijo: “Bendito sea Abram del Dios Altísimo, poseedor del cielo y de la tierra. ");
INSERT INTO spablm_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Bendito sea el Dios Altísimo, que ha entregado a tus enemigos en tu mano”. Abram le dio la décima parte de todo. ");
INSERT INTO spablm_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","El rey de Sodoma dijo a Abram: “Dame la gente y toma los bienes para ti”. ");
INSERT INTO spablm_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Abram dijo al rey de Sodoma: “He levantado mi mano a Yahvé, Dios Altísimo, poseedor del cielo y de la tierra, ");
INSERT INTO spablm_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","que no tomaré ni un hilo ni una correa de sandalia ni nada que sea tuyo, para que no digas: ‘Yo he enriquecido a Abram’. ");
INSERT INTO spablm_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","No aceptaré nada de ti, excepto lo que hayan comido los jóvenes y la porción de los hombres que fueron conmigo: Aner, Escol y Mamre. Que tomen su porción”. ");
INSERT INTO spablm_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Después de estas cosas, la palabra de Yahvé vino a Abram en una visión, diciendo: “No temas, Abram. Yo soy tu escudo, tu gran recompensa”. ");
INSERT INTO spablm_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Abram dijo: “Señor Yahvé, ¿qué me darás, ya que me voy sin hijos, y el que heredará mis bienes es Eliezer de Damasco?” ");
INSERT INTO spablm_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Abram respondió: “He aquí que no me has dado hijos, y he aquí que uno nacido en mi casa es mi heredero.” ");
INSERT INTO spablm_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","He aquí que la palabra de Yahvé vino a él, diciendo: “Este hombre no será tu heredero, pero el que saldrá de tu propio cuerpo será tu heredero.” ");
INSERT INTO spablm_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Yahvé lo sacó fuera y le dijo: “Mira ahora hacia el cielo y cuenta las estrellas, si eres capaz de contarlas”. Le dijo a Abram: “Así será tu descendencia”. ");
INSERT INTO spablm_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Él creyó en Yahvé, que se lo acreditó por justicia. ");
INSERT INTO spablm_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Le dijo a Abram: “Yo soy Yahvé, que te saqué de Ur de los caldeos, para darte esta tierra en herencia.” ");
INSERT INTO spablm_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Dijo: “Señor Yahvé, ¿cómo sabré que lo heredaré?” ");
INSERT INTO spablm_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Le dijo: “Tráeme una ternera de tres años, una cabra de tres años, un carnero de tres años, una tórtola y un pichón”. ");
INSERT INTO spablm_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Él le trajo todo esto, lo dividió en el medio y puso cada mitad frente a la otra; pero no dividió las aves. ");
INSERT INTO spablm_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Las aves de rapiña descendieron sobre los cadáveres, y Abram las ahuyentó. ");
INSERT INTO spablm_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Cuando el sol se ponía, un profundo sueño cayó sobre Abram. El terror y la gran oscuridad cayeron sobre él. ");
INSERT INTO spablm_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Le dijo a Abram: “Ten por seguro que tu descendencia vivirá como extranjera en una tierra que no es la suya, y les servirá. Los afligirán durante cuatrocientos años. ");
INSERT INTO spablm_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Yo también juzgaré a esa nación, a la que servirán. Después saldrán con grandes riquezas; ");
INSERT INTO spablm_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","pero tú irás con tus padres en paz. Serás enterrado a una buena edad. ");
INSERT INTO spablm_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","En la cuarta generación volverán a venir aquí, porque la iniquidad del amorreo aún no está completa.” ");
INSERT INTO spablm_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Sucedió que, cuando se puso el sol y estuvo oscuro, he aquí que un horno humeante y una antorcha encendida pasaron entre estas piezas. ");
INSERT INTO spablm_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Aquel día Yahvé hizo un pacto con Abram, diciendo: “He dado esta tierra a tu descendencia, desde el río de Egipto hasta el gran río, el río Éufrates: ");
INSERT INTO spablm_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","la tierra de los ceneos, de los cenecitas, de los cadmonitas, ");
INSERT INTO spablm_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","de los hititas, de los ferezeos, de los refaítas, ");
INSERT INTO spablm_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","de los amorreos, de los cananeos, de los gergeseos y de los jebuseos.” ");
INSERT INTO spablm_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Sarai, la esposa de Abram, no le dio hijos. Tenía una sierva, una egipcia, que se llamaba Agar. ");
INSERT INTO spablm_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Sarai le dijo a Abram: “Mira ahora, Yahvé me ha impedido tener hijos. Por favor, acude a mi sierva. Puede ser que obtenga hijos de ella”. Abram escuchó la voz de Sarai. ");
INSERT INTO spablm_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Sarai, la esposa de Abram, tomó a Agar la egipcia, su sierva, después de que Abram había vivido diez años en la tierra de Canaán, y se la dio a Abram su esposo para que fuera su esposa. ");
INSERT INTO spablm_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Él se acercó a Agar, y ella concibió. Al ver que había concebido, su ama se despreció ante sus ojos. ");
INSERT INTO spablm_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Sarai dijo a Abram: “Este mal es culpa tuya. Entregué a mi sierva en tu seno, y cuando vio que había concebido, miraba con desprecio a su señora”. ");
INSERT INTO spablm_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Pero Abram dijo a Sarai: “He aquí que tu doncella está en tu mano. Haz con ella lo que te parezca bien”. Sarai la trató con dureza, y ella huyó de su rostro. ");
INSERT INTO spablm_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","El ángel de Yahvé la encontró junto a una fuente de agua en el desierto, junto a la fuente del camino de Shur. ");
INSERT INTO spablm_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Le dijo: “Agar, sierva de Sarai, ¿de dónde vienes? ¿A dónde vas?” Ella dijo: “Huyo de la cara de mi señora Sarai”. ");
INSERT INTO spablm_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","El ángel de Yahvé le dijo: “Vuelve a tu señora y sométete a sus manos”. ");
INSERT INTO spablm_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","El ángel de Yahvé le dijo: “Multiplicaré en gran medida tu descendencia, que no podrá ser contada a causa de la multitud”. ");
INSERT INTO spablm_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","El ángel de Yahvé le dijo: “He aquí que estás encinta y darás a luz un hijo. Lo llamarás Ismael, porque Yahvé ha escuchado tu aflicción. ");
INSERT INTO spablm_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Será como un asno salvaje entre los hombres. Su mano estará en contra de todo hombre, y la mano de todo hombre en contra de él. Vivirá opuesto a todos sus hermanos”. ");
INSERT INTO spablm_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Ella llamó al nombre de Yahvé que le habló: “Tú eres un Dios que ve”, pues dijo: “¿Acaso he quedado viva después de verlo?” ");
INSERT INTO spablm_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Por eso el pozo se llamó Beer Lahai Roi. He aquí que está entre Cades y Bered. ");
INSERT INTO spablm_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Agar dio a luz un hijo para Abram. Abram llamó el nombre de su hijo, que Agar dio a luz, Ismael. ");
INSERT INTO spablm_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abram tenía ochenta y seis años cuando Agar dio a luz a Ismael. ");
INSERT INTO spablm_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Cuando Abram tenía noventa y nueve años, Yahvé se le apareció y le dijo: “Yo soy el Dios Todopoderoso. Camina delante de mí y sé irreprochable. ");
INSERT INTO spablm_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Haré mi pacto entre yo y tú, y te multiplicaré en gran manera”. ");
INSERT INTO spablm_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abram se postró sobre su rostro. Dios habló con él, diciendo: ");
INSERT INTO spablm_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“En cuanto a mí, he aquí que mi pacto es contigo. Serás el padre de una multitud de naciones. ");
INSERT INTO spablm_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Ya no te llamarás Abram, sino que tu nombre será Abraham, porque te he hecho padre de una multitud de naciones. ");
INSERT INTO spablm_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Te haré fructificar en gran medida, y haré naciones de ti. De ti saldrán reyes. ");
INSERT INTO spablm_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Estableceré mi pacto entre mí y tú y tu descendencia después de ti por sus generaciones, como un pacto eterno, para ser un Dios para ti y para tu descendencia después de ti. ");
INSERT INTO spablm_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Te daré a ti, y a tu descendencia después de ti, la tierra por la que viajas, toda la tierra de Canaán, como posesión eterna. Yo seré su Dios”. ");
INSERT INTO spablm_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Dios dijo a Abraham: “En cuanto a ti, guardarás mi pacto, tú y tu descendencia después de ti por sus generaciones. ");
INSERT INTO spablm_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Este es mi pacto, que guardarás, entre tú y yo y tu descendencia después de ti. Todo varón de entre vosotros será circuncidado. ");
INSERT INTO spablm_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Será circuncidado en la carne de su prepucio. Será una señal de la alianza entre mí y vosotros. ");
INSERT INTO spablm_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Será circuncidado entre vosotros el que tenga ocho días de edad, todo varón a lo largo de vuestras generaciones, el que haya nacido en la casa o haya sido comprado con dinero a cualquier extranjero que no sea de vuestra descendencia. ");
INSERT INTO spablm_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","El que nazca en tu casa, y el que sea comprado con tu dinero, debe ser circuncidado. Mi pacto estará en tu carne como pacto eterno. ");
INSERT INTO spablm_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","El varón incircunciso que no esté circuncidado en la carne de su prepucio, esa alma será cortada de su pueblo. Ha roto mi pacto”. ");
INSERT INTO spablm_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Dios dijo a Abraham: “En cuanto a Sarai, tu mujer, no la llamarás Sarai, sino que su nombre será Sara. ");
INSERT INTO spablm_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Yo la bendeciré, y además te daré un hijo de ella. Sí, la bendeciré, y será madre de naciones. De ella saldrán reyes de pueblos”. ");
INSERT INTO spablm_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Entonces Abraham se postró sobre su rostro y se rió, y dijo en su corazón: “¿Le nacerá un hijo a quien tiene cien años? ¿Dará a luz Sara, que tiene noventa años?” ");
INSERT INTO spablm_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Abraham dijo a Dios: “¡Oh, que Ismael viva ante ti!” ");
INSERT INTO spablm_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Dios dijo: “No, pero Sara, tu mujer, te dará un hijo. Lo llamarás Isaac. Estableceré mi pacto con él como un pacto eterno para su descendencia después de él. ");
INSERT INTO spablm_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","En cuanto a Ismael, te he escuchado. He aquí que lo he bendecido, lo haré fructificar y lo multiplicaré en gran manera. Llegará a ser padre de doce príncipes, y haré de él una gran nación. ");
INSERT INTO spablm_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Pero yo estableceré mi alianza con Isaac, a quien Sara dará a luz en esta época del año próximo.” ");
INSERT INTO spablm_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Cuando terminó de hablar con él, Dios se alejó de Abraham. ");
INSERT INTO spablm_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Abraham tomó a su hijo Ismael, a todos los nacidos en su casa y a todos los comprados con su dinero; a todo varón de la casa de Abraham, y circuncidó la carne de su prepucio en el mismo día, como Dios le había dicho. ");
INSERT INTO spablm_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abraham tenía noventa y nueve años cuando fue circuncidado en la carne de su prepucio. ");
INSERT INTO spablm_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Ismael, su hijo, tenía trece años cuando fue circuncidado en la carne de su prepucio. ");
INSERT INTO spablm_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","El mismo día fueron circuncidados Abraham e Ismael, su hijo. ");
INSERT INTO spablm_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Todos los hombres de su casa, los nacidos en ella y los comprados con dinero a un extranjero, fueron circuncidados con él. ");
INSERT INTO spablm_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Yahvé se le apareció junto a los robles de Mamre, mientras estaba sentado en la puerta de la tienda en el calor del día. ");
INSERT INTO spablm_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Levantó los ojos y miró, y vio que tres hombres estaban cerca de él. Al verlos, corrió a su encuentro desde la puerta de la tienda, se inclinó hacia la tierra, ");
INSERT INTO spablm_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","y dijo: “Señor mío, si ahora he encontrado gracia ante tus ojos, por favor no te alejes de tu siervo. ");
INSERT INTO spablm_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Traigan ahora un poco de agua, lávense los pies y descansen bajo el árbol. ");
INSERT INTO spablm_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Yo traeré un trozo de pan para que refresquéis vuestro corazón. Después podéis seguir vuestro camino, ya que habéis acudido a vuestro siervo”. Dijeron: “Muy bien, haz lo que has dicho”. ");
INSERT INTO spablm_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Abraham se apresuró a entrar en la tienda con Sara y le dijo: “Prepara rápidamente tres seahs de harina fina, amásala y haz tortas.” ");
INSERT INTO spablm_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Abraham corrió hacia el rebaño, cogió un ternero tierno y bueno y se lo dio al criado. Éste se apresuró a aderezarlo. ");
INSERT INTO spablm_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Tomó mantequilla, leche y el ternero que había aderezado, y lo puso delante de ellos. Se puso junto a ellos, bajo el árbol, y comieron. ");
INSERT INTO spablm_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Le preguntaron: “¿Dónde está Sara, tu mujer?” Dijo: “Allí, en la tienda”. ");
INSERT INTO spablm_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Dijo: “Ciertamente volveré a ti por esta época el año que viene, y he aquí que Sara, tu mujer, tendrá un hijo”. Sara oyó en la puerta de la tienda, que estaba detrás de él. ");
INSERT INTO spablm_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abraham y Sara eran viejos, de edad avanzada. Sara había pasado la edad de tener hijos. ");
INSERT INTO spablm_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Sara se reía en su interior, diciendo: “¿Después de envejecer tendré placer, siendo mi señor también viejo?” ");
INSERT INTO spablm_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Yahvé dijo a Abraham: “¿Por qué se rió Sara, diciendo: “¿De verdad voy a dar a luz cuando sea vieja?” ");
INSERT INTO spablm_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","¿Hay algo demasiado difícil para Yahvé? A la hora fijada volveré a ti, cuando llegue la estación, y Sara tendrá un hijo”. ");
INSERT INTO spablm_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Entonces Sara lo negó, diciendo: “No me he reído”, pues tenía miedo. Me dijo: “No, pero te reíste”. ");
INSERT INTO spablm_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Los hombres se levantaron de allí y miraron hacia Sodoma. Abraham fue con ellos para verlos en su camino. ");
INSERT INTO spablm_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Yahvé dijo: “¿Voy a ocultar a Abraham lo que hago, ");
INSERT INTO spablm_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","ya que Abraham llegará a ser una nación grande y poderosa, y todas las naciones de la tierra serán bendecidas en él? ");
INSERT INTO spablm_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Porque lo he conocido, a fin de que mande a sus hijos y a su casa después de él, para que guarden el camino de Yahvé, haciendo justicia y rectitud; a fin de que Yahvé haga cumplir a Abraham lo que ha dicho de él.” ");
INSERT INTO spablm_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Yahvé dijo: “Porque el clamor de Sodoma y Gomorra es grande, y porque su pecado es muy grave, ");
INSERT INTO spablm_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","bajaré ahora y veré si sus obras son tan malas como los informes que me han llegado. Si no es así, lo sabré”. ");
INSERT INTO spablm_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Los hombres se apartaron de allí y se dirigieron a Sodoma, pero Abraham estaba todavía delante de Yahvé. ");
INSERT INTO spablm_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abraham se acercó y dijo: “¿Consumirás al justo con el impío? ");
INSERT INTO spablm_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","¿Y si hay cincuenta justos en la ciudad? ¿Consumirás y no perdonarás el lugar por los cincuenta justos que están en ella? ");
INSERT INTO spablm_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Que esté lejos de ti hacer cosas así, matar al justo con el impío, para que el justo sea como el impío. Que eso esté lejos de ti. ¿No debería el Juez de toda la tierra hacer lo correcto?” ");
INSERT INTO spablm_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Yahvé dijo: “Si encuentro en Sodoma cincuenta justos dentro de la ciudad, entonces perdonaré a todo el lugar por ellos”. ");
INSERT INTO spablm_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abraham respondió: “Mira ahora, me he encargado de hablar con el Señor, aunque soy polvo y ceniza. ");
INSERT INTO spablm_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","¿Y si faltan cinco de los cincuenta justos? ¿Destruirás toda la ciudad por falta de cinco?” Dijo: “No lo destruiré si encuentro cuarenta y cinco allí”. ");
INSERT INTO spablm_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Volvió a hablarle y le dijo: “¿Y si se encuentran allí cuarenta?”. Dijo: “No lo haré por los cuarenta”. ");
INSERT INTO spablm_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Él dijo: “Oh, no dejes que el Señor se enoje, y yo hablaré. ¿Y si se encuentran treinta allí?” Dijo: “No lo haré si encuentro treinta allí”. ");
INSERT INTO spablm_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Dijo: “Mira ahora, me he encargado de hablar con el Señor. ¿Y si se encuentran veinte allí?” Dijo: “No lo destruiré por el bien de los veinte”. ");
INSERT INTO spablm_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Él dijo: “Oh, no dejes que el Señor se enoje, y hablaré sólo una vez más. ¿Y si se encuentran diez allí?” Dijo: “No lo destruiré por el bien de los diez”. ");
INSERT INTO spablm_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","El Señor se fue en cuanto terminó de hablar con Abraham, y éste volvió a su lugar. ");
INSERT INTO spablm_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Los dos ángeles llegaron a Sodoma al anochecer. Lot estaba sentado en la puerta de Sodoma. Lot los vio y se levantó a recibirlos. Se inclinó con el rostro hacia la tierra, ");
INSERT INTO spablm_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","y les dijo: “Vean ahora, señores míos, por favor, entren en la casa de su siervo, quédense toda la noche, lávense los pies, y podrán levantarse temprano y seguir su camino.” Dijeron: “No, pero nos quedaremos en la calle toda la noche”. ");
INSERT INTO spablm_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Los exhortó mucho, y entraron con él en su casa. Les hizo un banquete, y horneó panes sin levadura, y comieron. ");
INSERT INTO spablm_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Pero antes de que se acostaran, los hombres de la ciudad, los hombres de Sodoma, rodearon la casa, tanto los jóvenes como los ancianos, toda la gente de todas partes. ");
INSERT INTO spablm_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Llamaron a Lot y le dijeron: “¿Dónde están los hombres que entraron en tu casa esta noche? Tráenoslos, para que nos acostemos con ellos”. ");
INSERT INTO spablm_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lot salió hacia ellos por la puerta, y cerró la puerta tras de sí. ");
INSERT INTO spablm_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Dijo: “Por favor, hermanos míos, no actuéis con tanta maldad. ");
INSERT INTO spablm_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Mirad, tengo dos hijas vírgenes. Por favor, dejad que os las traiga, y podéis hacer con ellas lo que os parezca bien. Sólo que no les hagáis nada a estos hombres, porque han venido bajo la sombra de mi techo”. ");
INSERT INTO spablm_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Dijeron: “¡Atrás!” Entonces dijeron: “Este tipo entró a vivir como extranjero, y se nombra a sí mismo juez. Ahora te trataremos peor que a ellos”. Presionaron con fuerza al hombre Lot, y se acercaron para romper la puerta. ");
INSERT INTO spablm_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Pero los hombres extendieron la mano y metieron a Lot en la casa, y cerraron la puerta. ");
INSERT INTO spablm_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","A los hombres que estaban a la puerta de la casa los hirieron con ceguera, tanto a los pequeños como a los grandes, de modo que se cansaron de encontrar la puerta. ");
INSERT INTO spablm_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Los hombres dijeron a Lot: “¿Tienes a alguien más aquí? Yernos, hijos, hijas y todos los que tengas en la ciudad, sácalos del lugar: ");
INSERT INTO spablm_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","porque vamos a destruir este lugar, porque el clamor contra ellos ha crecido tanto ante Yahvé que Yahvé nos ha enviado a destruirlo.” ");
INSERT INTO spablm_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lot salió y habló a sus yernos, que estaban comprometidos a casarse con sus hijas, y les dijo: “¡Levántense! Salid de este lugar, porque Yahvé va a destruir la ciudad”. Pero a sus yernos les pareció que estaba bromeando. ");
INSERT INTO spablm_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Cuando llegó la mañana, los ángeles apresuraron a Lot, diciendo: “¡Levántate! Toma a tu mujer y a tus dos hijas que están aquí, para que no te consumas en la iniquidad de la ciudad”. ");
INSERT INTO spablm_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Pero él se demoró, y los hombres lo tomaron de la mano, de la mano de su esposa y de la mano de sus dos hijas, siendo Yahvé misericordioso con él, y lo sacaron y lo pusieron fuera de la ciudad. ");
INSERT INTO spablm_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Cuando los sacaron, les dijo: “¡Escapen por su vida! No mires detrás de ti, y no te quedes en ningún lugar de la llanura. Escapad a las montañas, no sea que os consuman”. ");
INSERT INTO spablm_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lot les dijo: “Oh, no es así, mi señor. ");
INSERT INTO spablm_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Mira ahora, tu siervo ha hallado gracia ante tus ojos, y has engrandecido tu amorosa bondad, que has mostrado conmigo al salvar mi vida. No puedo escapar al monte, no sea que el mal me alcance y muera. ");
INSERT INTO spablm_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Mira ahora, esta ciudad está cerca para huir, y es pequeña. Oh, déjame escapar allí (¿no es una pequeña?), y mi alma vivirá”. ");
INSERT INTO spablm_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Le dijo: “He aquí que he concedido tu petición en cuanto a esto también, que no derribaré la ciudad de la que has hablado. ");
INSERT INTO spablm_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Date prisa, escapa allí, porque no puedo hacer nada hasta que llegues”. Por eso el nombre de la ciudad se llamó Zoar. ");
INSERT INTO spablm_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","El sol había salido sobre la tierra cuando Lot llegó a Zoar. ");
INSERT INTO spablm_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Entonces Yahvé hizo llover sobre Sodoma y sobre Gomorra azufre y fuego de Yahvé desde el cielo. ");
INSERT INTO spablm_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Derribó aquellas ciudades, toda la llanura, todos los habitantes de las ciudades y lo que crecía en el suelo. ");
INSERT INTO spablm_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Pero la esposa de Lot miró hacia atrás desde su espalda, y se convirtió en una columna de sal. ");
INSERT INTO spablm_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Abraham subió de madrugada al lugar donde había estado frente a Yahvé. ");
INSERT INTO spablm_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Miró hacia Sodoma y Gomorra, y hacia toda la tierra de la llanura, y vio que el humo de la tierra subía como el humo de un horno. ");
INSERT INTO spablm_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Cuando Dios destruyó las ciudades de la llanura, se acordó de Abraham y envió a Lot en medio de la destrucción, cuando derribó las ciudades en las que vivía Lot. ");
INSERT INTO spablm_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lot subió de Zoar y vivió en el monte, con sus dos hijas, porque tenía miedo de vivir en Zoar. Vivió en una cueva con sus dos hijas. ");
INSERT INTO spablm_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","La primogénita dijo a la menor: “Nuestro padre es viejo, y no hay hombre en la tierra que pueda entrar con nosotras en el camino de toda la tierra. ");
INSERT INTO spablm_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Vengan, hagamos que nuestro padre beba vino y nos acostaremos con él, para conservar el linaje de nuestro padre”. ");
INSERT INTO spablm_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Hicieron beber vino a su padre aquella noche, y la primogénita entró y se acostó con su padre. Él no supo cuándo se acostó, ni cuándo se levantó. ");
INSERT INTO spablm_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Al día siguiente, la primogénita dijo a la menor: “Mira, anoche me acosté con mi padre. Hagamos que esta noche vuelva a beber vino. Entra tú y acuéstate con él, para que conservemos el linaje de nuestro padre”. ");
INSERT INTO spablm_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","También esa noche hicieron beber vino a su padre. La más joven fue y se acostó con él. Él no supo cuándo se acostó, ni cuándo se levantó. ");
INSERT INTO spablm_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Así, las dos hijas de Lot quedaron embarazadas de su padre. ");
INSERT INTO spablm_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","La primogénita dio a luz un hijo y lo llamó Moab. Él es el padre de los moabitas hasta el día de hoy. ");
INSERT INTO spablm_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","La menor también dio a luz un hijo y lo llamó Ben Ammi. Él es el padre de los hijos de Amón hasta el día de hoy. ");
INSERT INTO spablm_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abraham viajó desde allí hacia la tierra del Sur, y vivió entre Cades y Shur. Vivió como extranjero en Gerar. ");
INSERT INTO spablm_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Abraham dijo de su esposa Sara: “Es mi hermana”. Abimelec, rey de Gerar, envió y tomó a Sara. ");
INSERT INTO spablm_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Pero Dios vino a Abimelec en un sueño nocturno y le dijo: “He aquí que eres un hombre muerto a causa de la mujer que has tomado, porque es mujer de hombre.” ");
INSERT INTO spablm_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Ahora bien, Abimelec no se había acercado a ella. Dijo: “Señor, ¿vas a matar incluso a una nación justa? ");
INSERT INTO spablm_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","¿No me dijo: ‘Es mi hermana’? Ella, incluso ella misma, dijo: ‘Es mi hermano’. He hecho esto con la integridad de mi corazón y la inocencia de mis manos”. ");
INSERT INTO spablm_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Dios le dijo en el sueño: “Sí, sé que en la integridad de tu corazón has hecho esto, y también te he impedido pecar contra mí. Por eso no te permití tocarla. ");
INSERT INTO spablm_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Ahora, pues, restituye a ese hombre su mujer. Porque él es un profeta, y orará por ti, y vivirás. Si no la restituyes, ten por seguro que morirás, tú y todos los tuyos”. ");
INSERT INTO spablm_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Abimelec se levantó de madrugada, llamó a todos sus siervos y les dijo todo esto al oído. Los hombres estaban muy asustados. ");
INSERT INTO spablm_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Entonces Abimelec llamó a Abraham y le dijo: “¿Qué nos has hecho? ¿Cómo he pecado contra ti, que has traído sobre mí y sobre mi reino un gran pecado? Me has hecho obras que no debían hacerse”. ");
INSERT INTO spablm_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abimelec le dijo a Abraham: “¿Qué has visto para que hayas hecho esto?” ");
INSERT INTO spablm_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraham dijo: “Porque pensé: ‘Seguramente el temor de Dios no está en este lugar. Me matarán por causa de mi mujer’. ");
INSERT INTO spablm_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Además, ella es en verdad mi hermana, la hija de mi padre, pero no la hija de mi madre; y se convirtió en mi esposa. ");
INSERT INTO spablm_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Cuando Dios hizo que me alejara de la casa de mi padre, le dije a ella: ‘Esta es la bondad que mostrarás conmigo. Dondequiera que vayamos, di de mí: “Es mi hermano”’”. ");
INSERT INTO spablm_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Abimelec tomó ovejas y ganado, siervos y siervas, y se los dio a Abraham, y le devolvió a Sara, su esposa. ");
INSERT INTO spablm_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimelec dijo: “Mira, mi tierra está delante de ti. Habita donde te plazca”. ");
INSERT INTO spablm_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","A Sara le dijo: “He aquí que le he dado a tu hermano mil monedas de plata. He aquí que es para ti una cubierta de los ojos para todos los que están contigo. Delante de todos estás reivindicada”. ");
INSERT INTO spablm_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Abraham oró a Dios. Entonces Dios sanó a Abimelec, a su esposa y a sus siervas, y éstas dieron a luz. ");
INSERT INTO spablm_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Porque Yahvé había cerrado bien todos los vientres de la casa de Abimelec, a causa de Sara, la mujer de Abraham. ");
INSERT INTO spablm_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Yahvé visitó a Sara como había dicho, y Yahvé hizo con Sara lo que había dicho. ");
INSERT INTO spablm_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sara concibió y dio a luz un hijo a Abraham en su vejez, en el tiempo establecido del que Dios le había hablado. ");
INSERT INTO spablm_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abraham llamó a su hijo que le había nacido, y que Sara le dio a luz, Isaac. ");
INSERT INTO spablm_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Abraham circuncidó a su hijo Isaac a los ocho días de nacido, como Dios le había ordenado. ");
INSERT INTO spablm_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abraham tenía cien años cuando le nació su hijo Isaac. ");
INSERT INTO spablm_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sara dijo: “Dios me ha hecho reír. Todo el que oiga se reirá conmigo”. ");
INSERT INTO spablm_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Ella dijo: “¿Quién le habría dicho a Abraham que Sara amamantaría a sus hijos? Pues le he dado a luz un hijo en su vejez”. ");
INSERT INTO spablm_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","El niño creció y fue destetado. Abraham hizo una gran fiesta el día en que Isaac fue destetado. ");
INSERT INTO spablm_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Sara vio que el hijo de Agar la egipcia, que había dado a luz a Abraham, se burlaba. ");
INSERT INTO spablm_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Entonces dijo a Abraham: “¡Echa a esta sierva y a su hijo! Porque el hijo de esta sierva no será heredero de mi hijo Isaac”. ");
INSERT INTO spablm_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","La cosa fue muy penosa a los ojos de Abraham a causa de su hijo. ");
INSERT INTO spablm_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Dios le dijo a Abraham: “No te aflijas por el niño y por tu sierva. En todo lo que te diga Sara, escucha su voz. Porque tu descendencia llevará el nombre de Isaac. ");
INSERT INTO spablm_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","También haré una nación del hijo de la sierva, porque es tu hijo.” ");
INSERT INTO spablm_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Abraham se levantó de madrugada, tomó pan y un recipiente de agua y se lo dio a Agar, poniéndoselo al hombro; le dio el niño y la despidió. Ella partió y anduvo errante por el desierto de Beerseba. ");
INSERT INTO spablm_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","El agua de la vasija se agotó, y ella puso al niño debajo de uno de los arbustos. ");
INSERT INTO spablm_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Fue y se sentó frente a él, a una buena distancia, como a un tiro de arco. Porque dijo: “No me dejes ver la muerte del niño”. Se sentó frente a él, alzó la voz y lloró. ");
INSERT INTO spablm_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Dios escuchó la voz del niño. El ángel de Dios llamó a Agar desde el cielo y le dijo: “¿Qué te preocupa, Agar? No tengas miedo. Porque Dios ha escuchado la voz del niño donde está. ");
INSERT INTO spablm_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Levántate, levanta al niño y sostenlo con tu mano. Porque yo haré de él una gran nación”. ");
INSERT INTO spablm_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Dios le abrió los ojos y vio un pozo de agua. Fue, llenó el recipiente de agua y le dio de beber al niño. ");
INSERT INTO spablm_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Dios estuvo con el niño, y éste creció. Vivió en el desierto, y al crecer se convirtió en arquero. ");
INSERT INTO spablm_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Vivió en el desierto de Parán. Su madre le consiguió una esposa de la tierra de Egipto. ");
INSERT INTO spablm_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","En aquel tiempo, Abimelec y Ficol, el capitán de su ejército, hablaron con Abraham, diciendo: “Dios está contigo en todo lo que haces. ");
INSERT INTO spablm_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Ahora, pues, júrame aquí por Dios que no harás un trato falso conmigo, ni con mi hijo, ni con el hijo de mi hijo. Sino que según la bondad que yo he hecho contigo, tú harás conmigo y con la tierra en la que has vivido como extranjero.” ");
INSERT INTO spablm_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abraham dijo: “Lo juraré”. ");
INSERT INTO spablm_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Abraham se quejó a Abimelec a causa de un pozo de agua, que los siervos de Abimelec habían quitado con violencia. ");
INSERT INTO spablm_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimelec dijo: “No sé quién ha hecho esto. No me lo has dicho, y no me he enterado hasta hoy”. ");
INSERT INTO spablm_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Abraham tomó ovejas y ganado y se los dio a Abimelec. Aquellos dos hicieron un pacto. ");
INSERT INTO spablm_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abraham puso siete corderos del rebaño por separado. ");
INSERT INTO spablm_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimelec le dijo a Abraham: “¿Qué significan estas siete ovejas que has puesto solas?” ");
INSERT INTO spablm_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Dijo: “Tomarás estas siete ovejas de mi mano, para que me sirvan de testimonio de que he cavado este pozo”. ");
INSERT INTO spablm_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Por eso llamó a ese lugar Beersheba, porque ambos hicieron allí un juramento. ");
INSERT INTO spablm_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Así que hicieron un pacto en Beerseba. Abimelec se levantó con Ficol, el capitán de su ejército, y volvieron a la tierra de los filisteos. ");
INSERT INTO spablm_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abraham plantó un tamarisco en Beerseba, y allí invocó el nombre de Yahvé, el Dios eterno. ");
INSERT INTO spablm_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abraham vivió muchos días como extranjero en la tierra de los filisteos. ");
INSERT INTO spablm_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Después de estas cosas, Dios probó a Abraham y le dijo: “¡Abraham!” Dijo: “Aquí estoy”. ");
INSERT INTO spablm_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Dijo: “Ahora toma a tu hijo, tu único hijo, Isaac, a quien amas, y vete a la tierra de Moriah. Ofrécelo allí como holocausto en uno de los montes que te diré”. ");
INSERT INTO spablm_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Abraham se levantó de madrugada, ensilló su asno y tomó consigo a dos de sus jóvenes y a su hijo Isaac. Partió la leña para el holocausto, se levantó y se dirigió al lugar que Dios le había indicado. ");
INSERT INTO spablm_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Al tercer día, Abraham alzó los ojos y vio el lugar a lo lejos. ");
INSERT INTO spablm_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Abraham dijo a sus jóvenes: “Quedaos aquí con el burro. El muchacho y yo iremos allí. Adoraremos, y volveremos a ti”. ");
INSERT INTO spablm_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abraham tomó la madera del holocausto y la puso sobre Isaac, su hijo. Tomó en su mano el fuego y el cuchillo. Ambos fueron juntos. ");
INSERT INTO spablm_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isaac se dirigió a su padre Abraham y le dijo: “¿Padre mío?” Dijo: “Aquí estoy, hijo mío”. Dijo: “Aquí está el fuego y la leña, pero ¿dónde está el cordero para el holocausto?”. ");
INSERT INTO spablm_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraham dijo: “Dios se proveerá del cordero para el holocausto, hijo mío”. Así que se fueron los dos juntos. ");
INSERT INTO spablm_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Llegaron al lugar que Dios le había indicado. Abraham construyó allí el altar, y puso la madera en orden, ató a su hijo Isaac y lo puso sobre el altar, sobre la madera. ");
INSERT INTO spablm_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Abraham extendió su mano y tomó el cuchillo para matar a su hijo. ");
INSERT INTO spablm_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","El ángel de Yahvé le llamó desde el cielo y le dijo: “¡Abraham, Abraham!” Dijo: “Aquí estoy”. ");
INSERT INTO spablm_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Él dijo: “No pongas tu mano sobre el niño ni le hagas nada. Porque ahora sé que temes a Dios, ya que no me has ocultado a tu hijo, tu único hijo”. ");
INSERT INTO spablm_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Abraham alzó los ojos y miró, y vio que detrás de él había un carnero atrapado en la espesura por sus cuernos. Abraham fue y tomó el carnero, y lo ofreció en holocausto en lugar de su hijo. ");
INSERT INTO spablm_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Abraham llamó el nombre de aquel lugar “Yahvé proveerá”. Como se dice hasta hoy: “En el monte de Yahvé se proveerá”. ");
INSERT INTO spablm_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","El ángel de Yahvé llamó a Abraham por segunda vez desde el cielo, ");
INSERT INTO spablm_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","y le dijo: “‘He jurado por mí mismo’, dice Yahvé, ‘porque has hecho esto y no has retenido a tu hijo, tu único hijo, ");
INSERT INTO spablm_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","que te bendeciré en gran manera, y multiplicaré tu descendencia en gran manera como las estrellas del cielo y como la arena que está a la orilla del mar. Tu descendencia poseerá la puerta de sus enemigos. ");
INSERT INTO spablm_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Todas las naciones de la tierra serán bendecidas por tu descendencia, porque has obedecido mi voz.’” ");
INSERT INTO spablm_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Entonces Abraham volvió con sus jóvenes, y se levantaron y se fueron juntos a Beerseba. Abraham vivía en Beerseba. ");
INSERT INTO spablm_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Después de estas cosas, se le dijo a Abraham: “He aquí que Milca también ha dado a luz hijos a tu hermano Nacor: ");
INSERT INTO spablm_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Uz su primogénito, Buz su hermano, Kemuel el padre de Aram, ");
INSERT INTO spablm_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Quesed, Hazo, Pildas, Jidlaf y Betuel.” ");
INSERT INTO spablm_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuel fue el padre de Rebeca. Estos ocho Milcah dio a luz a Nahor, hermano de Abraham. ");
INSERT INTO spablm_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Su concubina, que se llamaba Reúma, también dio a luz a Teba, Gaham, Tahas y Maaca.. ");
INSERT INTO spablm_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara vivió ciento veintisiete años. Esta fue la duración de la vida de Sara. ");
INSERT INTO spablm_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Sara murió en Quiriat Arba (también llamada Hebrón), en la tierra de Canaán. Abraham vino a hacer duelo por Sara y a llorarla. ");
INSERT INTO spablm_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Abraham se levantó de delante de su muerta y habló a los hijos de Het, diciendo: ");
INSERT INTO spablm_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Soy extranjero y forastero y vivo con vosotros. Dadme posesión de un lugar de enterramiento con vosotros, para que pueda enterrar a mi muerta delante de mí”. ");
INSERT INTO spablm_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Los hijos de Het respondieron a Abraham, diciéndole: ");
INSERT INTO spablm_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Escúchanos, mi señor. Tú eres un príncipe de Dios entre nosotros. Entierra a tu muerta en la mejor de nuestras tumbas. Ninguno de nosotros te negará su tumba. Entierra a tu muerta”. ");
INSERT INTO spablm_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Abraham se levantó y se inclinó ante el pueblo de aquella tierra, ante los hijos de Het. ");
INSERT INTO spablm_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Habló con ellos diciendo: “Si estáis de acuerdo en que entierre a mi muerta fuera de mi vista, escuchadme y rogad por mí a Efrón, hijo de Zohar, ");
INSERT INTO spablm_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","para que me venda la cueva de Macpela que tiene, que está en el extremo de su campo. Por el precio completo que me la venda entre ustedes como posesión para un lugar de entierro”. ");
INSERT INTO spablm_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Efrón estaba sentado en medio de los hijos de Het. Efrón el hitita respondió a Abraham a la vista de los hijos de Het, de todos los que entraban por la puerta de su ciudad, diciendo: ");
INSERT INTO spablm_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“No, señor mío, escúchame. Yo te doy el campo, y te doy la cueva que hay en él. En presencia de los hijos de mi pueblo te lo doy. Entierra a tu muerta”. ");
INSERT INTO spablm_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Abraham se inclinó ante el pueblo de aquella tierra. ");
INSERT INTO spablm_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Habló a Efrón en la audiencia del pueblo de la tierra, diciendo Daré el precio del campo. Tómalo de mi parte, y enterraré allí a mi muerta”. ");
INSERT INTO spablm_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efrón respondió a Abraham, diciéndole: ");
INSERT INTO spablm_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Señor mío, escúchame. ¿Qué es un pedazo de tierra que vale cuatrocientos siclos de plata entre tú y yo? Entierra, pues, a tu muerta”. ");
INSERT INTO spablm_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abraham escuchó a Efrón. Abraham pesó a Efrón la plata que había nombrado al oír a los hijos de Het, cuatrocientos siclos de plata, según el patrón de los mercaderes corrientes. ");
INSERT INTO spablm_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Así que el campo de Efrón, que estaba en Macpela, que estaba delante de Mamre, el campo, la cueva que había en él, y todos los árboles que había en el campo, que estaban en todos sus límites, fueron escriturados ");
INSERT INTO spablm_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","a Abraham como posesión en presencia de los hijos de Het, ante todos los que entraban a la puerta de su ciudad. ");
INSERT INTO spablm_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Después de esto, Abraham enterró a Sara, su esposa, en la cueva del campo de Macpela, frente a Mamre (es decir, Hebrón), en la tierra de Canaán. ");
INSERT INTO spablm_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","El campo y la cueva que hay en él fueron legados a Abraham por los hijos de Het como posesión para un lugar de enterramiento. ");
INSERT INTO spablm_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham era viejo y de edad avanzada. Yahvé había bendecido a Abraham en todo. ");
INSERT INTO spablm_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Abraham dijo a su siervo, el mayor de su casa, que gobernaba todo lo que tenía: “Por favor, pon tu mano debajo de mi muslo. ");
INSERT INTO spablm_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Te haré jurar por Yahvé, el Dios de los cielos y el Dios de la tierra, que no tomarás para mi hijo una esposa de las hijas de los cananeos, entre los que vivo. ");
INSERT INTO spablm_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Sino que irás a mi país y a mis parientes y tomarás una esposa para mi hijo Isaac”. ");
INSERT INTO spablm_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","El criado le dijo: “¿Y si la mujer no está dispuesta a seguirme a esta tierra? ¿Debo traer a su hijo de nuevo a la tierra de la que vino?” ");
INSERT INTO spablm_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraham le dijo: “Cuídate de no volver a llevar a mi hijo allí. ");
INSERT INTO spablm_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Yahvé, el Dios del cielo, que me sacó de la casa de mi padre y de la tierra donde nací, que me habló y me juró diciendo: ‘Daré esta tierra a tu descendencia’, enviará a su ángel delante de ti, y tomarás de allí una mujer para mi hijo. ");
INSERT INTO spablm_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Si la mujer no está dispuesta a seguirte, entonces quedarás libre de este juramento a mí. Sólo que no volverás a llevar a mi hijo allí”. ");
INSERT INTO spablm_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","El siervo puso su mano bajo el muslo de Abraham, su amo, y le juró sobre este asunto. ");
INSERT INTO spablm_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","El siervo tomó diez de los camellos de su amo y partió, llevando consigo una variedad de cosas buenas de su amo. Se levantó y fue a Mesopotamia, a la ciudad de Najor. ");
INSERT INTO spablm_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Hizo que los camellos se arrodillaran fuera de la ciudad, junto al pozo de agua, a la hora del atardecer, la hora en que las mujeres salen a sacar agua. ");
INSERT INTO spablm_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Dijo: “Yahvé, el Dios de mi amo Abraham, por favor dame éxito hoy, y muestra bondad a mi amo Abraham. ");
INSERT INTO spablm_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","He aquí que estoy junto al manantial de agua. Las hijas de los hombres de la ciudad están saliendo a sacar agua. ");
INSERT INTO spablm_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Que la joven a la que le diga: “Por favor, baja tu cántaro para que pueda beber”, y que diga: “Bebe, y yo también daré de beber a tus camellos”, sea la que has designado para tu siervo Isaac. Así sabré que has sido amable con mi señor”. ");
INSERT INTO spablm_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Antes de que terminara de hablar, he aquí que salía Rebeca, nacida de Betuel, hijo de Milca, mujer de Nacor, hermano de Abraham, con su cántaro al hombro. ");
INSERT INTO spablm_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","La joven era muy hermosa de ver, virgen. Ningún hombre la había conocido. Bajó a la fuente, llenó su cántaro y subió. ");
INSERT INTO spablm_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","El criado corrió a su encuentro y le dijo: “Por favor, dame de beber, un poco de agua de tu cántaro”. ");
INSERT INTO spablm_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ella dijo: “Bebe, mi señor”. Ella se apresuró a bajar el cántaro de su mano y le dio de beber. ");
INSERT INTO spablm_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Cuando terminó de darle de beber, dijo: “Yo también sacaré para tus camellos, hasta que terminen de beber.” ");
INSERT INTO spablm_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Ella se apresuró a vaciar su cántaro en el abrevadero, y corrió de nuevo al pozo para sacar, y sacó para todos sus camellos. ");
INSERT INTO spablm_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","El hombre la miró fijamente, permaneciendo en silencio, para saber si Yahvé había hecho próspero su viaje o no. ");
INSERT INTO spablm_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Cuando los camellos terminaron de beber, el hombre tomó un anillo de oro de medio siclo de peso, y dos brazaletes para sus manos de diez siclos de peso de oro, ");
INSERT INTO spablm_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","y dijo: “¿De quién eres hija? Por favor, dime. ¿Hay sitio en la casa de tu padre para que nos quedemos?” ");
INSERT INTO spablm_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Ella le dijo: “Soy hija de Betuel, hijo de Milca, que dio a luz a Nacor”. ");
INSERT INTO spablm_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Además, le dijo: “Tenemos paja y alimento suficientes, y espacio para alojarnos”. ");
INSERT INTO spablm_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","El hombre inclinó la cabeza y adoró a Yahvé. ");
INSERT INTO spablm_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Dijo: “Bendito sea Yahvé, el Dios de mi amo Abraham, que no ha abandonado su bondad y su verdad para con mi amo. En cuanto a mí, Yahvé me ha conducido por el camino a la casa de los parientes de mi amo”. ");
INSERT INTO spablm_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","La joven corrió y contó estas palabras a la casa de su madre. ");
INSERT INTO spablm_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebeca tenía un hermano que se llamaba Labán. Labán salió corriendo hacia el hombre, hacia la fuente. ");
INSERT INTO spablm_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Cuando vio el anillo y los brazaletes en las manos de su hermana, y cuando oyó las palabras de su hermana Rebeca, diciendo: “Esto es lo que me ha dicho el hombre”, se acercó al hombre. He aquí que él estaba junto a los camellos en el manantial. ");
INSERT INTO spablm_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Le dijo: “Entra, bendito de Yahvé. ¿Por qué te quedas fuera? Porque he preparado la casa y el espacio para los camellos”. ");
INSERT INTO spablm_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","El hombre entró en la casa y descargó los camellos. Dio paja y pienso para los camellos, y agua para lavar sus pies y los de los hombres que le acompañaban. ");
INSERT INTO spablm_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Se le puso comida para que comiera, pero él dijo: “No comeré hasta que haya dicho mi mensaje”. Labán dijo: “Habla”. ");
INSERT INTO spablm_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Él dijo: “Yo soy el siervo de Abraham. ");
INSERT INTO spablm_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","El Señor ha bendecido mucho a mi amo. Se ha hecho grande. El Señor le ha dado rebaños y manadas, plata y oro, siervos y siervas, camellos y asnos. ");
INSERT INTO spablm_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Sara, la esposa de mi amo, le dio un hijo a mi amo cuando ya era viejo. Le ha dado todo lo que tiene. ");
INSERT INTO spablm_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Mi amo me hizo jurar, diciendo: ‘No tomarás mujer para mi hijo de entre las hijas de los cananeos, en cuya tierra vivo, ");
INSERT INTO spablm_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","sino que irás a la casa de mi padre y de mis parientes y tomarás mujer para mi hijo.’ ");
INSERT INTO spablm_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Yo le pregunté a mi amo: ‘¿Y si la mujer no me sigue?’ ");
INSERT INTO spablm_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Él me dijo: ‘El Señor, ante quien yo ando, enviará su ángel contigo y prosperará tu camino. Tomarás una mujer para mi hijo de entre mis parientes y de la casa de mi padre. ");
INSERT INTO spablm_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Así quedarás libre de mi juramento, cuando llegues a mis parientes. Si no te la dan, quedarás libre de mi juramento’. ");
INSERT INTO spablm_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Vine hoy al manantial y dije: ‘Yahvé, el Dios de mi amo Abraham, si ahora haces prosperar mi camino que voy — ");
INSERT INTO spablm_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","he aquí que estoy junto a este manantial de agua. Que la doncella que salga a sacar, a la que yo le diga: “Por favor, dame un poco de agua de tu cántaro para que beba”, ");
INSERT INTO spablm_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","entonces me diga: “Bebe, y yo también sacaré para tus camellos”, sea la mujer que Yahvé ha designado para el hijo de mi amo.’ ");
INSERT INTO spablm_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Antes de que terminara de hablar en mi corazón, he aquí que Rebeca salió con su cántaro al hombro. Bajó al manantial y sacó. Le dije: ‘Por favor, déjame beber’. ");
INSERT INTO spablm_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Ella se apresuró a bajar el cántaro de su hombro y dijo: ‘Bebe, y yo también daré de beber a tus camellos’. Así que bebí, y ella también dio de beber a los camellos. ");
INSERT INTO spablm_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Le pregunté: “¿De quién eres hija? Ella respondió: ‘La hija de Betuel, hijo de Nacor, que le dio Milca’. Le puse el anillo en la nariz y los brazaletes en las manos. ");
INSERT INTO spablm_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Incliné la cabeza, adoré a Yahvé y bendije a Yahvé, el Dios de mi amo Abraham, que me había guiado por el camino correcto para tomar a la hija del hermano de mi amo para su hijo. ");
INSERT INTO spablm_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ahora bien, si tú tratas con bondad y verdad a mi amo, dímelo. Si no, dímelo, para que me vuelva a la derecha o a la izquierda”. ");
INSERT INTO spablm_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Entonces Labán y Betuel respondieron: “La cosa procede de Yahvé. No podemos hablarte ni mal ni bien. ");
INSERT INTO spablm_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","He aquí que Rebeca está delante de ti. Tómenla y váyanse, y que sea la esposa del hijo de su amo, como ha dicho Yahvé”. ");
INSERT INTO spablm_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Cuando el siervo de Abraham escuchó sus palabras, se postró en tierra ante Yahvé. ");
INSERT INTO spablm_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","El siervo sacó joyas de plata, joyas de oro y ropa, y se las dio a Rebeca. También dio cosas preciosas a su hermano y a su madre. ");
INSERT INTO spablm_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Comieron y bebieron, él y los hombres que estaban con él, y se quedaron toda la noche. Se levantaron por la mañana, y él dijo: “Envíenme a mi amo”. ");
INSERT INTO spablm_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Su hermano y su madre dijeron: “Que la joven se quede con nosotros unos días, al menos diez. Después se irá”. ");
INSERT INTO spablm_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Él les dijo: “No me estorben, pues Yahvé ha prosperado mi camino. Despídanme para que vaya con mi amo”. ");
INSERT INTO spablm_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Dijeron: “Llamaremos a la joven y le preguntaremos”. ");
INSERT INTO spablm_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Llamaron a Rebeca y le dijeron: “¿Quieres ir con este hombre?” Ella dijo: “Iré”. ");
INSERT INTO spablm_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Despidieron a Rebeca, su hermana, con su nodriza, el siervo de Abraham, y sus hombres. ");
INSERT INTO spablm_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Bendijeron a Rebeca y le dijeron: “Hermana nuestra, que seas madre de miles de diez mil, y que tu descendencia posea la puerta de los que la odian.” ");
INSERT INTO spablm_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Rebeca se levantó con sus damas. Montaron en los camellos y siguieron al hombre. El siervo tomó a Rebeca y siguió su camino. ");
INSERT INTO spablm_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Isaac venía del camino de Beer Lahai Roi, pues vivía en la tierra del Sur. ");
INSERT INTO spablm_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Isaac salió a meditar en el campo al atardecer. Levantó sus ojos y miró. He aquí que venían camellos. ");
INSERT INTO spablm_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeca levantó los ojos y, al ver a Isaac, se bajó del camello. ");
INSERT INTO spablm_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Dijo al criado: “¿Quién es el hombre que viene al campo a recibirnos?” El criado dijo: “Es mi amo”. Tomó su velo y se cubrió. ");
INSERT INTO spablm_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","El siervo le contó a Isaac todo lo que había hecho. ");
INSERT INTO spablm_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Isaac la llevó a la tienda de su madre Sara, y tomó a Rebeca, y ella se convirtió en su esposa. Él la amaba. Así que Isaac se sintió reconfortado después de la muerte de su madre. ");
INSERT INTO spablm_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham tomó otra esposa, que se llamaba Cetura. ");
INSERT INTO spablm_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ella le dio a luz a Zimran, Jocsan, Medan, Midian, Isbac y Shuah. ");
INSERT INTO spablm_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jocsan fue el padre de Sheba y de Dedan. Los hijos de Dedán fueron Asurim, Letusim y Leumim. ");
INSERT INTO spablm_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Los hijos de Madián fueron Efá, Efer, Hanoc, Abida y Eldá. Todos ellos eran hijos de Cetura. ");
INSERT INTO spablm_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abraham dio todo lo que tenía a Isaac, ");
INSERT INTO spablm_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","pero Abraham dio regalos a los hijos de las concubinas de Abraham. Mientras él vivía, los envió lejos de su hijo Isaac, hacia el este, al país oriental. ");
INSERT INTO spablm_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Estos son los días de los años que vivió Abraham: ciento setenta y cinco años. ");
INSERT INTO spablm_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Abraham renunció a su espíritu y murió en buena edad, anciano y lleno de años, y fue reunido con su pueblo. ");
INSERT INTO spablm_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Isaac e Ismael, sus hijos, lo enterraron en la cueva de Macpela, en el campo de Efrón, hijo de Zohar el hitita, que está cerca de Mamre, ");
INSERT INTO spablm_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","el campo que Abraham compró a los hijos de Het. Abraham fue enterrado allí con Sara, su esposa. ");
INSERT INTO spablm_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Después de la muerte de Abraham, Dios bendijo a Isaac, su hijo. Isaac vivía en Beer Lahai Roi. ");
INSERT INTO spablm_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Esta es la historia de las generaciones de Ismael, hijo de Abraham, que Agar la egipcia, sierva de Sara, dio a luz a Abraham. ");
INSERT INTO spablm_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Estos son los nombres de los hijos de Ismael, por sus nombres, según el orden de su nacimiento: el primogénito de Ismael, Nebaiot, luego Cedar, Adbeel, Mibsam, ");
INSERT INTO spablm_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Duma, Massa, ");
INSERT INTO spablm_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Jetur, Nafis y Cedema. ");
INSERT INTO spablm_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Estos son los hijos de Ismael, y estos son sus nombres, por sus pueblos y por sus campamentos: doce príncipes, según sus naciones. ");
INSERT INTO spablm_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Estos son los años de la vida de Ismael: ciento treinta y siete años. Entregó su espíritu y murió, y fue reunido con su pueblo. ");
INSERT INTO spablm_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Vivió desde Havila hasta Shur, que está delante de Egipto, en dirección a Asiria. Vivió frente a todos sus parientes. ");
INSERT INTO spablm_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Esta es la historia de las generaciones de Isaac, hijo de Abraham. Abraham fue el padre de Isaac. ");
INSERT INTO spablm_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaac tenía cuarenta años cuando tomó por esposa a Rebeca, hija de Betuel el sirio de Paddán Aram, hermana de Labán el sirio. ");
INSERT INTO spablm_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isaac suplicó a Yahvé por su esposa, porque era estéril. Yahvé fue suplicado por él, y Rebeca, su esposa, concibió. ");
INSERT INTO spablm_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Los hijos lucharon juntos dentro de ella. Ella dijo: “Si es así, ¿para qué vivo?”. Fue a consultar a Yahvé. ");
INSERT INTO spablm_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Yahvé le dijo, “Dos naciones están en tu vientre. Dos personas serán separadas de su cuerpo. Un pueblo será más fuerte que el otro. El mayor servirá al menor”. ");
INSERT INTO spablm_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Cuando se cumplieron sus días de parto, he aquí que había gemelos en su vientre. ");
INSERT INTO spablm_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","El primero salió rojo por todas partes, como una prenda velluda. Le pusieron el nombre de Esaú. ");
INSERT INTO spablm_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Después salió su hermano, y su mano se aferró al talón de Esaú. Le pusieron el nombre de Jacob. Isaac tenía sesenta años cuando los dio a luz. ");
INSERT INTO spablm_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Los muchachos crecieron. Esaú era un hábil cazador, un hombre de campo. Jacob era un hombre tranquilo, que vivía en tiendas. ");
INSERT INTO spablm_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isaac amaba a Esaú, porque comía su carne de venado. Rebeca amaba a Jacob. ");
INSERT INTO spablm_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Jacob hervía un guiso. Esaú llegó del campo, y estaba hambriento. ");
INSERT INTO spablm_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Esaú le dijo a Jacob: “Por favor, aliméntame con un poco de ese guiso rojo, porque estoy hambriento”. Por eso se llamó Edom. ");
INSERT INTO spablm_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Jacob dijo: “Primero, véndeme tu primogenitura”. ");
INSERT INTO spablm_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esaú dijo: “He aquí que estoy a punto de morir. ¿De qué me sirve la primogenitura?” ");
INSERT INTO spablm_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Jacob dijo: “Júrame primero”. Se lo juró. Vendió su primogenitura a Jacob. ");
INSERT INTO spablm_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Jacob dio a Esaú pan y guiso de lentejas. Comió y bebió, se levantó y siguió su camino. Entonces Esaú despreció su primogenitura. ");
INSERT INTO spablm_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Hubo una hambruna en la tierra, además de la primera hambruna que hubo en los días de Abraham. Isaac fue a Abimelec, rey de los filisteos, a Gerar. ");
INSERT INTO spablm_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Yahvé se le apareció y le dijo: “No bajes a Egipto. Vive en la tierra de la que te hablaré. ");
INSERT INTO spablm_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Vive en esta tierra, y yo estaré contigo y te bendeciré. Porque te daré a ti y a tu descendencia todas estas tierras, y confirmaré el juramento que le hice a Abraham, tu padre. ");
INSERT INTO spablm_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Multiplicaré tu descendencia como las estrellas del cielo, y daré todas estas tierras a tu descendencia. En tu descendencia serán bendecidas todas las naciones de la tierra, ");
INSERT INTO spablm_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","porque Abraham obedeció mi voz y guardó mis requerimientos, mis mandamientos, mis estatutos y mis leyes.” ");
INSERT INTO spablm_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Isaac vivía en Gerar. ");
INSERT INTO spablm_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Los hombres del lugar le preguntaron por su esposa. Él respondió: “Es mi hermana”, pues temía decir: “Mi esposa”, no sea que, pensó, “los hombres del lugar me maten por Rebeca, porque es hermosa de ver”. ");
INSERT INTO spablm_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Cuando ya llevaba mucho tiempo allí, Abimelec, rey de los filisteos, se asomó a una ventana y vio que Isaac estaba acariciando a Rebeca, su esposa. ");
INSERT INTO spablm_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Abimelec llamó a Isaac y le dijo: “He aquí que ella es tu mujer. ¿Por qué has dicho: ‘Es mi hermana’?” Isaac le respondió: “Porque dije: “No sea que muera por su culpa””. ");
INSERT INTO spablm_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimelec dijo: “¿Qué es lo que nos has hecho? Uno del pueblo podría haberse acostado fácilmente con tu mujer, ¡y nos habrías hecho caer la culpa!” ");
INSERT INTO spablm_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Abimelec ordenó a todo el pueblo que dijera: “El que toque a este hombre o a su mujer, morirá”. ");
INSERT INTO spablm_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isaac sembró en esa tierra y cosechó en el mismo año cien veces lo que había plantado. El Señor lo bendijo. ");
INSERT INTO spablm_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","El hombre se hizo grande, y creció más y más hasta llegar a ser muy grande. ");
INSERT INTO spablm_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Tenía posesiones de rebaños, posesiones de manadas y una gran casa. Los filisteos lo envidiaban. ");
INSERT INTO spablm_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Ahora bien, todos los pozos que los siervos de su padre habían cavado en los días de Abraham, su padre, los filisteos los habían cerrado y llenado de tierra. ");
INSERT INTO spablm_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Abimelec dijo a Isaac: “Vete de nosotros, porque eres mucho más poderoso que nosotros”. ");
INSERT INTO spablm_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Isaac partió de allí, acampó en el valle de Gerar y vivió allí. ");
INSERT INTO spablm_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Isaac volvió a cavar los pozos de agua que habían cavado en los días de Abraham, su padre, pues los filisteos los habían detenido después de la muerte de Abraham. Les puso los nombres que su padre les había puesto. ");
INSERT INTO spablm_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Los siervos de Isaac cavaron en el valle y encontraron allí un pozo de agua que fluía. ");
INSERT INTO spablm_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Los pastores de Gerar discutieron con los pastores de Isaac, diciendo: “El agua es nuestra”. Así que llamó el nombre del pozo Esek, porque discutían con él. ");
INSERT INTO spablm_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Ellos cavaron otro pozo, y también discutieron por él. Así que lo llamó Sitna. ");
INSERT INTO spablm_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Dejó ese lugar y cavó otro pozo. No discutieron por ese. Así que lo llamó Rehobot. Dijo: “Porque ahora el Señor nos ha hecho un lugar, y seremos fructíferos en la tierra”. ");
INSERT INTO spablm_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","De allí subió a Beerseba. ");
INSERT INTO spablm_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Esa misma noche se le apareció el Señor y le dijo: “Yo soy el Dios de Abraham, tu padre. No temas, porque yo estoy contigo y te bendeciré y multiplicaré tu descendencia por amor a mi siervo Abraham.” ");
INSERT INTO spablm_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Allí construyó un altar, invocó el nombre de Yahvé y acampó. Allí los siervos de Isaac cavaron un pozo. ");
INSERT INTO spablm_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Entonces Abimelec fue a él desde Gerar y Ahuzat, su amigo, y Ficol, el capitán de su ejército. ");
INSERT INTO spablm_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isaac les dijo: “¿Por qué habéis venido a mí, ya que me odiáis y me habéis enviado lejos de vosotros?” ");
INSERT INTO spablm_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Dijeron: “Vimos claramente que el Señor estaba con ustedes. Dijimos: ‘Que haya ahora un juramento entre nosotros, incluso entre nosotros y vosotros, y hagamos un pacto con vosotros, ");
INSERT INTO spablm_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","de que no nos haréis ningún daño, como no os hemos tocado, y como no os hemos hecho más que el bien, y os hemos despedido en paz.’ Ahora sois los benditos de Yahvé”. ");
INSERT INTO spablm_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Les hizo un banquete, y comieron y bebieron. ");
INSERT INTO spablm_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Se levantaron por la mañana y se juraron mutuamente. Isaac los despidió, y ellos se alejaron de él en paz. ");
INSERT INTO spablm_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","El mismo día, los siervos de Isaac vinieron y le contaron sobre el pozo que habían cavado, y le dijeron: “Hemos encontrado agua”. ");
INSERT INTO spablm_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Lo llamó “Shibah”. Por eso el nombre de la ciudad es “Beersheba” hasta el día de hoy. ");
INSERT INTO spablm_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Cuando Esaú tenía cuarenta años, tomó por esposa a Judit, hija de Beeri el hitita, y a Basemat, hija de Elón el hitita. ");
INSERT INTO spablm_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Ellas afligieronlos espíritus de Isaac y Rebeca. ");
INSERT INTO spablm_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Cuando Isaac envejeció, y sus ojos se oscurecieron, de modo que no podía ver, llamó a Esaú, su hijo mayor, y le dijo: “¿Hijo mío?” Le dijo: “Aquí estoy”. ");
INSERT INTO spablm_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Él dijo: “Mira ahora, soy viejo. No sé el día de mi muerte. ");
INSERT INTO spablm_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Ahora, pues, por favor, toma tus armas, tu carcaj y tu arco, y sal al campo, y tráeme venado. ");
INSERT INTO spablm_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Prepárame una comida sabrosa, como las que me gustan, y tráemela, para que coma y mi alma te bendiga antes de morir.” ");
INSERT INTO spablm_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Rebeca escuchó cuando Isaac habló con su hijo Esaú. Esaú fue al campo a cazar venado y a traerlo. ");
INSERT INTO spablm_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebeca habló a su hijo Jacob, diciendo: “He aquí que he oído a tu padre hablar a Esaú, tu hermano, diciendo: ");
INSERT INTO spablm_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Tráeme venado, y hazme comida sabrosa, para que yo coma, y te bendiga delante de Yahvé antes de mi muerte’. ");
INSERT INTO spablm_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Ahora, pues, hijo mío, obedece mi voz según lo que te mando. ");
INSERT INTO spablm_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Ve ahora al rebaño y tráeme dos buenos cabritos de allí. Yo los haré comida sabrosa para tu padre, como a él le gusta. ");
INSERT INTO spablm_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Se lo llevarás a tu padre para que coma y te bendiga antes de su muerte.” ");
INSERT INTO spablm_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Jacob dijo a su madre Rebeca: “Mira, mi hermano Esaú es un hombre velludo, y yo soy un hombre liso. ");
INSERT INTO spablm_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","¿Y si mi padre me toca? Le pareceré un engañador, y traería una maldición sobre mí, y no una bendición”. ");
INSERT INTO spablm_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Su madre le dijo: “Que tu maldición caiga sobre mí, hijo mío. Sólo obedece mi voz, y ve a buscarlos por mí”. ");
INSERT INTO spablm_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Fue a buscarlos y se los llevó a su madre. Su madre preparó una comida sabrosa, como la que le gustaba a su padre. ");
INSERT INTO spablm_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Rebeca tomó los buenos vestidos de Esaú, su hijo mayor, que estaban con ella en la casa, y se los puso a Jacob, su hijo menor. ");
INSERT INTO spablm_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Puso las pieles de los cabritos en sus manos y en la parte lisa de su cuello. ");
INSERT INTO spablm_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Dio la comida sabrosa y el pan que había preparado en manos de su hijo Jacob. ");
INSERT INTO spablm_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Se acercó a su padre y le dijo: “¿Padre mío?” Dijo: “Aquí estoy. ¿Quién eres tú, hijo mío?” ");
INSERT INTO spablm_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jacob dijo a su padre: “Yo soy Esaú, tu primogénito. He hecho lo que me pediste. Por favor, levántate, siéntate y come de mi venado, para que tu alma me bendiga”. ");
INSERT INTO spablm_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isaac dijo a su hijo: “¿Cómo es que lo has encontrado tan rápido, hijo mío?” Dijo: “Porque Yahvé, tu Dios, me dio el éxito”. ");
INSERT INTO spablm_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Isaac dijo a Jacob: “Por favor, acércate para que pueda sentirte, hijo mío, si realmente eres mi hijo Esaú o no”. ");
INSERT INTO spablm_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Jacob se acercó a su padre Isaac. Lo palpó y dijo: “La voz es de Jacob, pero las manos son de Esaú”. ");
INSERT INTO spablm_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","No lo reconoció, porque sus manos eran peludas, como las de su hermano Esaú. Así que lo bendijo. ");
INSERT INTO spablm_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Le dijo: “¿Eres realmente mi hijo Esaú?” Él dijo: “Yo soy”. ");
INSERT INTO spablm_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Dijo: “Acércamelo, y comeré del venado de mi hijo, para que mi alma te bendiga”. Se lo acercó, y comió. Le trajo vino, y bebió. ");
INSERT INTO spablm_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Su padre Isaac le dijo: “Acércate ahora y bésame, hijo mío”. ");
INSERT INTO spablm_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Se acercó y lo besó. Olió el olor de su ropa, lo bendijo y dijo, “He aquí el olor de mi hijo es como el olor de un campo que Yahvé ha bendecido. ");
INSERT INTO spablm_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Dios te dé del rocío del cielo, de la grosura de la tierra, y mucho grano y vino nuevo. ");
INSERT INTO spablm_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Que los pueblos te sirvan, y las naciones se inclinan ante ti. Sé el señor de tus hermanos. Que los hijos de tu madre se inclinen ante ti. Maldito sea todo aquel que te maldiga. Bendito sea todo aquel que te bendiga”. ");
INSERT INTO spablm_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Cuando Isaac terminó de bendecir a Jacob, y éste acababa de salir de la presencia de su padre Isaac, su hermano Esaú llegó de su cacería. ");
INSERT INTO spablm_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Él también preparó comida sabrosa y se la llevó a su padre. Dijo a su padre: “Que mi padre se levante y coma de la carne de caza de su hijo, para que tu alma me bendiga”. ");
INSERT INTO spablm_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Su padre Isaac le dijo: “¿Quién eres tú?” Dijo: “Soy tu hijo, tu primogénito, Esaú”. ");
INSERT INTO spablm_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isaac se estremeció violentamente y dijo: “¿Quién es, pues, el que ha tomado carne de venado y me la ha traído, y yo he comido de todo antes de que vinieras, y lo he bendecido? Sí, será bendecido”. ");
INSERT INTO spablm_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Cuando Esaú escuchó las palabras de su padre, lloró con un grito muy grande y amargo, y dijo a su padre: “Bendíceme, a mí también, padre mío”. ");
INSERT INTO spablm_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Dijo: “Tu hermano vino con engaño y te ha quitado la bendición”. ");
INSERT INTO spablm_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Dijo: “¿No se llama Jacob con razón? Porque me ha suplantado estas dos veces. Me quitó la primogenitura. Mira, ahora me ha quitado la bendición”. Dijo: “¿No me has reservado una bendición?”. ");
INSERT INTO spablm_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaac respondió a Esaú: “He aquí que lo he hecho tu señor, y a todos sus hermanos se los he dado por servidores. Lo he mantenido con grano y vino nuevo. ¿Qué haré entonces por ti, hijo mío?” ");
INSERT INTO spablm_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esaú dijo a su padre: “¿Tienes una sola bendición, padre mío? Bendíceme a mí también, padre mío”. Esaú alzó la voz y lloró. ");
INSERT INTO spablm_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Isaac, su padre, le respondió, “He aquí que tu morada será de la grosura de la tierra, y del rocío del cielo desde arriba. ");
INSERT INTO spablm_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Vivirás con tu espada y servirás a tu hermano. Ocurrirá, cuando te liberes, que sacudirás su yugo de tu cuello”. ");
INSERT INTO spablm_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esaú odiaba a Jacob a causa de la bendición con que su padre lo había bendecido. Esaú dijo en su corazón: “Se acercan los días de luto por mi padre. Entonces mataré a mi hermano Jacob”. ");
INSERT INTO spablm_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Las palabras de Esaú, su hijo mayor, fueron contadas a Rebeca. Ella envió y llamó a Jacob, su hijo menor, y le dijo: “Mira, tu hermano Esaú se consuela de ti planeando matarte. ");
INSERT INTO spablm_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Ahora, pues, hijo mío, obedece mi voz. Levántate y huye a Labán, mi hermano, en Harán. ");
INSERT INTO spablm_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Quédate con él unos días, hasta que la furia de tu hermano se aleje... ");
INSERT INTO spablm_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","hasta que la ira de tu hermano se aleje de ti, y se olvide de lo que le has hecho. Entonces enviaré y te sacaré de allí. ¿Por qué he de perderos a los dos en un solo día?” ");
INSERT INTO spablm_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Rebeca dijo a Isaac: “Estoy cansada de mi vida a causa de las hijas de Het. Si Jacob toma una esposa de las hijas de Het, como éstas, de las hijas de la tierra, ¿de qué me servirá mi vida?” ");
INSERT INTO spablm_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Isaac llamó a Jacob, lo bendijo y le ordenó: “No tomarás mujer de las hijas de Canaán. ");
INSERT INTO spablm_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Levántate, ve a Paddán Aram, a la casa de Betuel, el padre de tu madre. Toma de allí una esposa de entre las hijas de Labán, el hermano de tu madre. ");
INSERT INTO spablm_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Que Dios Todopoderoso te bendiga, te haga fructificar y te multiplique, para que seas una compañía de pueblos, ");
INSERT INTO spablm_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","y te dé la bendición de Abraham, a ti y a tu descendencia contigo, para que heredes la tierra por la que transitas, que Dios le dio a Abraham.” ");
INSERT INTO spablm_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Isaac despidió a Jacob. Fue a Padán Aram, a Labán, hijo de Betuel el sirio, hermano de Rebeca, madre de Jacob y Esaú. ");
INSERT INTO spablm_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esaú vio que Isaac había bendecido a Jacob y lo había enviado a Padán Aram para que tomara una esposa de allí, y que al bendecirlo le dio una orden, diciendo: “No tomarás esposa de las hijas de Canaán”; ");
INSERT INTO spablm_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","y que Jacob obedeció a su padre y a su madre, y se fue a Padán Aram. ");
INSERT INTO spablm_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Esaú vio que las hijas de Canaán no agradaban a Isaac, su padre. ");
INSERT INTO spablm_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Entonces Esaú se fue a Ismael y tomó, además de las esposas que tenía, a Mahalat, hija de Ismael, hijo de Abraham, hermana de Nebaiot, para que fuera su esposa. ");
INSERT INTO spablm_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jacob salió de Beerseba y se dirigió a Harán. ");
INSERT INTO spablm_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Llegó a un lugar y se quedó allí toda la noche, porque el sol se había puesto. Tomó una de las piedras del lugar, la puso debajo de su cabeza y se acostó en ese lugar para dormir. ");
INSERT INTO spablm_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Soñó y vio una escalera colocada sobre la tierra, cuya cima llegaba hasta el cielo. Los ángeles de Dios subían y bajaban por ella. ");
INSERT INTO spablm_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","He aquí que Yahvé estaba de pie sobre ella y decía: “Yo soy Yahvé, el Dios de Abraham, tu padre, y el Dios de Isaac. Daré la tierra sobre la que te acuestas a ti y a tu descendencia. ");
INSERT INTO spablm_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Tu descendencia será como el polvo de la tierra, y te extenderás al oeste, al este, al norte y al sur. En ti y en tu descendencia serán bendecidas todas las familias de la tierra. ");
INSERT INTO spablm_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","He aquí que yo estoy con vosotros y os guardaré dondequiera que vayáis, y os haré volver a esta tierra. Porque no te dejaré hasta que haya hecho lo que te he dicho”. ");
INSERT INTO spablm_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Jacob despertó de su sueño y dijo: “Ciertamente Yahvé está en este lugar, y yo no lo sabía”. ");
INSERT INTO spablm_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Tuvo miedo y dijo: “¡Qué impresionante es este lugar! Esto no es más que la casa de Dios, y ésta es la puerta del cielo”. ");
INSERT INTO spablm_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Jacob se levantó de madrugada, tomó la piedra que había puesto debajo de su cabeza, la puso como pilar y derramó aceite en su parte superior. ");
INSERT INTO spablm_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Llamó el nombre de aquel lugar Betel, pero el nombre de la ciudad era Luz al principio. ");
INSERT INTO spablm_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Jacob hizo un voto, diciendo: “Si Dios está conmigo y me guarda en este camino que recorro, y me da pan para comer y ropa para vestir, ");
INSERT INTO spablm_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","de modo que vuelva a la casa de mi padre en paz, y Yahvé sea mi Dios, ");
INSERT INTO spablm_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","entonces esta piedra, que he levantado como columna, será la casa de Dios. De todo lo que me des te daré seguramente la décima parte”. ");
INSERT INTO spablm_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Entonces Jacob siguió su camino y llegó a la tierra de los hijos de Oriente. ");
INSERT INTO spablm_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Miró, y vio un pozo en el campo, y vio tres rebaños de ovejas acostados junto a él. Porque de ese pozo abrevaban los rebaños. La piedra de la boca del pozo era grande. ");
INSERT INTO spablm_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Allí estaban reunidos todos los rebaños. Rodaron la piedra de la boca del pozo, dieron de beber a las ovejas y volvieron a poner la piedra en la boca del pozo en su lugar. ");
INSERT INTO spablm_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jacob les dijo: “Parientes míos, ¿de dónde sois?” Dijeron: “Somos de Harán”. ");
INSERT INTO spablm_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Les dijo: “¿Conocéis a Labán, hijo de Nacor?” Dijeron: “Lo conocemos”. ");
INSERT INTO spablm_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Les dijo: “¿Le va bien?”. Dijeron: “Está bien. Mira, Raquel, su hija, viene con las ovejas”. ");
INSERT INTO spablm_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Dijo: “Mira, todavía es mediodía, no es hora de reunir el ganado. Da de beber a las ovejas y ve a darles de comer”. ");
INSERT INTO spablm_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Dijeron: “No podemos, hasta que se reúnan todos los rebaños y se quite la piedra de la boca del pozo. Entonces abrevaremos las ovejas”. ");
INSERT INTO spablm_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Mientras aún hablaba con ellos, llegó Raquel con las ovejas de su padre, pues las guardaba. ");
INSERT INTO spablm_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Cuando Jacob vio a Raquel, la hija de Labán, hermano de su madre, y las ovejas de Labán, hermano de su madre, se acercó, hizo rodar la piedra de la boca del pozo y dio de beber al rebaño de Labán, hermano de su madre. ");
INSERT INTO spablm_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Jacob besó a Raquel, alzó la voz y lloró. ");
INSERT INTO spablm_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Jacob le dijo a Raquel que era pariente de su padre y que era hijo de Rebeca. Ella corrió y se lo contó a su padre. ");
INSERT INTO spablm_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Cuando Labán oyó la noticia de Jacob, el hijo de su hermana, corrió a recibir a Jacob, lo abrazó y lo besó, y lo llevó a su casa. Jacob le contó a Labán todas estas cosas. ");
INSERT INTO spablm_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Labán le dijo: “Ciertamente tú eres mi hueso y mi carne”. Jacob se quedó con él durante un mes. ");
INSERT INTO spablm_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Labán le dijo a Jacob: “Porque eres mi pariente, ¿debes servirme por nada? Dime, ¿cuál será tu salario?” ");
INSERT INTO spablm_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Labán tenía dos hijas. El nombre de la mayor era Lía, y el de la menor, Raquel. ");
INSERT INTO spablm_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Los ojos de Lea eran débiles, pero Raquel era hermosa en forma y atractiva. ");
INSERT INTO spablm_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Jacob amaba a Raquel. Dijo: “Te serviré siete años por Raquel, tu hija menor”. ");
INSERT INTO spablm_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Labán dijo: “Es mejor que te la entregue a ti que a otro hombre. Quédate conmigo”. ");
INSERT INTO spablm_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Jacob sirvió siete años por Raquel. Le parecieron pocos días, para el amor que sentía por ella. ");
INSERT INTO spablm_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Jacob dijo a Labán: “Dame a mi mujer, pues mis días están cumplidos, para que entre con ella.” ");
INSERT INTO spablm_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Labán reunió a todos los hombres del lugar e hizo un banquete. ");
INSERT INTO spablm_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Al anochecer, tomó a su hija Lea y la llevó a Jacob. Él entró con ella. ");
INSERT INTO spablm_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Labán le dio a su hija Lea a Zilpá como sirvienta. ");
INSERT INTO spablm_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Por la mañana, he aquí que era Lea. Le dijo a Labán: “¿Qué es esto que has hecho conmigo? ¿No he servido contigo por Raquel? ¿Por qué entonces me has engañado?” ");
INSERT INTO spablm_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Labán dijo: “No se hace así en nuestro lugar, dar al menor antes que al primogénito. ");
INSERT INTO spablm_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Cumple la semana de éste, y te daremos también el otro para el servicio que prestarás conmigo durante siete años más.” ");
INSERT INTO spablm_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Jacob lo hizo y cumplió su semana. Le dio a su hija Raquel como esposa. ");
INSERT INTO spablm_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Labán dio a Bilhá, su sierva, a su hija Raquel para que fuera su sirvienta. ");
INSERT INTO spablm_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Entró también a Raquel, y amó también a Raquel más que a Lea, y sirvió con él siete años más. ");
INSERT INTO spablm_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Yahvé vio que Lea era odiada, y abrió su vientre, pero Raquel era estéril. ");
INSERT INTO spablm_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea concibió y dio a luz un hijo, al que llamó Rubén. Porque dijo: “Porque Yahvé ha mirado mi aflicción, pues ahora mi esposo me amará”. ");
INSERT INTO spablm_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Concibió de nuevo y dio a luz un hijo, y dijo: “Porque Yahvé ha oído que soy odiada, por eso me ha dado también este hijo.” Le puso el nombre de Simeón. ");
INSERT INTO spablm_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Concibió de nuevo y dio a luz un hijo. Dijo: “Esta vez mi esposo se unirá a mí, porque le he dado tres hijos”. Por eso se llamó Leví. ");
INSERT INTO spablm_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Concibió de nuevo y dio a luz un hijo. Dijo: “Esta vez alabaré a Yahvé”. Por eso lo llamó Judá. Luego dejó de dar a luz. ");
INSERT INTO spablm_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Cuando Raquel vio que no daba hijos a Jacob, envidió a su hermana. Le dijo a Jacob: “Dame hijos o moriré”. ");
INSERT INTO spablm_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","La ira de Jacob ardió contra Raquel y dijo: “¿Estoy yo en lugar de Dios, que te ha negado el fruto del vientre?” ");
INSERT INTO spablm_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Ella dijo: “He aquí mi doncella Bilhá. Entra con ella, para que dé a luz sobre mis rodillas, y yo también pueda obtener hijos de ella”. ");
INSERT INTO spablm_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Ella le dio como esposa a su sierva Bilhá, y Jacob se acercó a ella. ");
INSERT INTO spablm_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilhá concibió y dio a luz un hijo a Jacob. ");
INSERT INTO spablm_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Raquel dijo: “Dios me ha juzgado, y también ha escuchado mi voz, y me ha dado un hijo”. Por eso lo llamó Dan. ");
INSERT INTO spablm_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bilhah, la sierva de Raquel, concibió de nuevo y dio a Jacob un segundo hijo. ");
INSERT INTO spablm_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Raquel dijo: “He luchado con mi hermana con poderosos combates, y he vencido.” Lo llamó Neftalí. ");
INSERT INTO spablm_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Cuando Lía vio que había terminado de parir, tomó a Zilpá, su sierva, y se la dio a Jacob como esposa. ");
INSERT INTO spablm_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Zilpa, la sierva de Lea, dio a luz un hijo a Jacob. ");
INSERT INTO spablm_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Lea dijo: “¡Qué suerte!”. Le puso el nombre de Gad. ");
INSERT INTO spablm_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Zilpa, la sierva de Lía, dio a luz un segundo hijo a Jacob. ");
INSERT INTO spablm_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Lea dijo: “Feliz soy, porque las hijas me llamarán feliz”. Lo llamó Aser. ");
INSERT INTO spablm_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Rubén fue en los días de la cosecha del trigo y encontró mandrágoras en el campo, y se las llevó a su madre, Lea. Entonces Raquel le dijo a Lea: “Por favor, dame algunas de las mandrágoras de tu hijo”. ");
INSERT INTO spablm_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Lea le dijo: “¿Es poca cosa que me hayas quitado a mi marido? ¿Quieres quitarle también las mandrágoras a mi hijo?” Raquel dijo: “Por eso se acostará contigo esta noche por las mandrágoras de tu hijo”. ");
INSERT INTO spablm_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Al anochecer, Jacob volvió del campo, y Lea salió a su encuentro y le dijo: “Tienes que entrar en mi casa, porque te he contratado con las mandrágoras de mi hijo.” Aquella noche se acostó con ella. ");
INSERT INTO spablm_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Dios escuchó a Lea, y ella concibió y dio a luz a Jacob un quinto hijo. ");
INSERT INTO spablm_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Lea dijo: “Dios me ha dado mi salario, porque le di mi sierva a mi marido”. Lo llamó Isacar. ");
INSERT INTO spablm_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lea concibió de nuevo y dio a luz un sexto hijo a Jacob. ");
INSERT INTO spablm_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Lea dijo: “Dios me ha dotado de una buena dote. Ahora mi marido vivirá conmigo, porque le he dado seis hijos”. Le puso el nombre de Zabulón. ");
INSERT INTO spablm_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Después dio a luz a una hija y la llamó Dina. ");
INSERT INTO spablm_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Dios se acordó de Raquel, la escuchó y le abrió el vientre. ");
INSERT INTO spablm_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Concibió, dio a luz un hijo y dijo: “Dios ha quitado mi afrenta”. ");
INSERT INTO spablm_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Le puso el nombre de José, diciendo: “Que Yahvé me añada otro hijo”. ");
INSERT INTO spablm_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Cuando Raquel dio a luz a José, Jacob dijo a Labán: “Despídeme para que me vaya a mi lugar y a mi país. ");
INSERT INTO spablm_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Dame mis esposas y mis hijos por los que te he servido, y déjame ir; porque tú conoces mi servicio con el que te he servido.” ");
INSERT INTO spablm_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Labán le dijo: “Si ahora he hallado gracia ante tus ojos, quédate aquí, pues he adivinado que Yahvé me ha bendecido por tu causa.” ");
INSERT INTO spablm_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Él le dijo: “Ponme tu salario, y te lo daré”. ");
INSERT INTO spablm_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Jacob le dijo: “Tú sabes cómo te he servido y cómo me ha ido con tu ganado. ");
INSERT INTO spablm_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Porque era poco lo que tenías antes de que yo llegara, y ha aumentado hasta convertirse en una multitud. El Señor te ha bendecido dondequiera que me he vuelto. Ahora, ¿cuándo proveeré también para mi propia casa?” ");
INSERT INTO spablm_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Labán dijo: “¿Qué te doy?” Jacob dijo: “No me darás nada. Si haces esto por mí, volveré a apacentar tu rebaño y lo mantendré. ");
INSERT INTO spablm_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Hoy pasaré por todo tu rebaño, eliminando de él a toda oveja manchada y a toda oveja negra, y a la moteada y a la manchada entre las cabras. Este será mi salario. ");
INSERT INTO spablm_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Así mi justicia responderá por mí en adelante, cuando vengas a hablar de mi salario que está delante de ti. Todo el que no esté moteado y manchado entre las cabras, y negro entre las ovejas, que pueda estar conmigo, se considerará robado.” ");
INSERT INTO spablm_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Labán dijo: “He aquí, que sea según tu palabra”. ");
INSERT INTO spablm_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Aquel día quitó los machos cabríos rayados y manchados, y todas las cabras moteadas y manchadas, todas las que tenían blanco, y todas las negras entre las ovejas, y las entregó en manos de sus hijos. ");
INSERT INTO spablm_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Puso tres días de camino entre él y Jacob, y éste apacentó el resto de los rebaños de Labán. ");
INSERT INTO spablm_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Jacob tomó para sí varas de álamo, almendro y plátano frescos, peló en ellas vetas blancas e hizo aparecer el blanco que había en las varas. ");
INSERT INTO spablm_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Puso las varas que había pelado frente a los rebaños en los abrevaderos donde éstos venían a beber. Ellas concebían cuando venían a beber. ");
INSERT INTO spablm_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Los rebaños concibieron delante de las varas, y los rebaños produjeron rayados, moteados y manchados. ");
INSERT INTO spablm_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Jacob separó los corderos, y puso las caras de los rebaños hacia los rayados y todos los negros del rebaño de Labán. Apartó sus propios rebaños y no los puso en el rebaño de Labán. ");
INSERT INTO spablm_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Cuando las más fuertes del rebaño concebían, Jacob ponía las varas delante de los ojos del rebaño en los abrevaderos, para que concibieran entre las varas; ");
INSERT INTO spablm_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","pero cuando el rebaño era débil, no las metía. Así que las más débiles eran de Labán, y las más fuertes de Jacob. ");
INSERT INTO spablm_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","El hombre crecía mucho, y tenía grandes rebaños, siervas y siervos, y camellos y asnos. ");
INSERT INTO spablm_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Jacob escuchó las palabras de los hijos de Labán, que decían: “Jacob se ha llevado todo lo que era de nuestro padre. Ha obtenido toda esta riqueza de lo que era de nuestro padre”. ");
INSERT INTO spablm_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Jacob vio la expresión del rostro de Labán, y he aquí que no era hacia él como antes. ");
INSERT INTO spablm_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Yahvé dijo a Jacob: “Vuelve a la tierra de tus padres y a tus parientes, y yo estaré contigo.” ");
INSERT INTO spablm_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Jacob envió a llamar a Raquel y a Lea al campo, a su rebaño, ");
INSERT INTO spablm_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","y les dijo: “Veo la expresión del rostro de vuestro padre, que no es hacia mí como antes; pero el Dios de mi padre ha estado conmigo. ");
INSERT INTO spablm_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Sabéis que he servido a vuestro padre con todas mis fuerzas. ");
INSERT INTO spablm_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Tu padre me ha engañado y ha cambiado mi salario diez veces, pero Dios no le ha permitido hacerme daño. ");
INSERT INTO spablm_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Sí dijo: 'El moteado será tu salario', entonces todo el rebaño parían moteado. Sí dijo: “Tu salario será él rayado”, entonces todo el rebaño paría rayado. ");
INSERT INTO spablm_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Así, Dios se llevó el ganado de vuestro padre y me lo dio a mí. ");
INSERT INTO spablm_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Durante la época de apareamiento, levanté los ojos y vi en sueños que los machos cabríos que saltaban en el rebaño estaban rayados, moteados y canosos. ");
INSERT INTO spablm_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","El ángel de Dios me dijo en el sueño: “Jacob”, y yo dije: “Aquí estoy”. ");
INSERT INTO spablm_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Me dijo: ‘Ahora levanta tus ojos y mira que todos los machos cabríos que saltan en el rebaño están rayados, moteados y canosos, porque he visto todo lo que Labán te hace. ");
INSERT INTO spablm_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Yo soy el Dios de Betel, donde ungiste una columna, donde me hiciste un voto. Ahora levántate, sal de esta tierra y vuelve a la tierra donde naciste’”. ");
INSERT INTO spablm_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Raquel y Lea le respondieron: “¿Hay todavía alguna porción o herencia para nosotras en la casa de nuestro padre? ");
INSERT INTO spablm_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","¿No somos consideradas por él como extranjeras? Porque nos ha vendido, y también ha agotado nuestro dinero. ");
INSERT INTO spablm_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Pues todas las riquezas que Dios ha quitado a nuestro padre son nuestras y de nuestros hijos. Ahora bien, todo lo que Dios te ha dicho, hazlo”. ");
INSERT INTO spablm_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Entonces Jacob se levantó y puso a sus hijos y a sus mujeres sobre los camellos, ");
INSERT INTO spablm_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","y se llevó todo su ganado y todas sus posesiones que había reunido, incluyendo el ganado que había ganado en Padán Aram, para ir a Isaac, su padre, a la tierra de Canaán. ");
INSERT INTO spablm_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Labán había ido a esquilar sus ovejas, y Raquel robó los terafines que eran de su padre. ");
INSERT INTO spablm_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Jacob engañó a Labán el sirio, pues no le dijo que estaba huyendo. ");
INSERT INTO spablm_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Así que huyó con todo lo que tenía. Se levantó, pasó el río y puso su rostro en dirección al monte de Galaad. ");
INSERT INTO spablm_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Al tercer día le avisaron a Labán que Jacob había huido. ");
INSERT INTO spablm_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Tomó consigo a sus parientes y lo persiguió durante siete días de viaje. Lo alcanzó en la montaña de Galaad. ");
INSERT INTO spablm_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Dios vino a Labán el sirio en un sueño nocturno y le dijo: “Ten cuidado de no hablarle a Jacob ni bien ni mal”. ");
INSERT INTO spablm_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Labán alcanzó a Jacob. Jacob había acampado en la montaña, y Labán con sus parientes acampó en la montaña de Galaad. ");
INSERT INTO spablm_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Labán dijo a Jacob: “¿Qué has hecho, que me has engañado y te has llevado a mis hijas como cautivas de la espada? ");
INSERT INTO spablm_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","¿Por qué huiste en secreto y me engañaste, y no me lo dijiste, para que te despidiera con alegría y con cantos, con pandereta y con arpa; ");
INSERT INTO spablm_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","y no me dejaste besar a mis hijos y a mis hijas? Ahora has hecho una tontería. ");
INSERT INTO spablm_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Está en poder de mi mano hacerte daño, pero el Dios de tu padre me habló anoche, diciendo: ‘Ten cuidado de no hablarle a Jacob ni bien ni mal’. ");
INSERT INTO spablm_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ahora bien, tú quieres irte, porque anhelabas mucho la casa de tu padre, pero ¿por qué has robado mis dioses?” ");
INSERT INTO spablm_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jacob respondió a Labán: “Porque tuve miedo, pues dije: ‘No sea que me quites a tus hijas por la fuerza’. ");
INSERT INTO spablm_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Cualquiera con quien encuentres a tus dioses no vivirá. Ante nuestros parientes, discierne lo que es tuyo conmigo, y tómalo”. Pues Jacob no sabía que Raquel las había robado. ");
INSERT INTO spablm_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Labán entró en la tienda de Jacob, en la tienda de Lea y en la tienda de las dos siervas, pero no las encontró. Salió de la tienda de Lea y entró en la tienda de Raquel. ");
INSERT INTO spablm_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Raquel había tomado los terafines, los había puesto en la silla del camello y se había sentado sobre ellos. Labán tanteó toda la tienda, pero no los encontró. ");
INSERT INTO spablm_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Ella le dijo a su padre: “Que mi señor no se enoje porque no puedo levantarme delante de ti, porque tengo la regla”. Buscó, pero no encontró los terafines. ");
INSERT INTO spablm_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Jacob se enojó y discutió con Labán. Jacob respondió a Labán: “¿Cuál es mi infracción? ¿Cuál es mi pecado, para que me hayas perseguido acaloradamente? ");
INSERT INTO spablm_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Ahora que has hurgado en todas mis cosas, ¿qué has encontrado de todas las cosas de tu casa? Ponlo aquí delante de mis parientes y de los tuyos, para que juzguen entre nosotros dos. ");
INSERT INTO spablm_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Estos veinte años he estado con ustedes. Tus ovejas y tus cabras no han abortado sus crías, y no me he comido los carneros de tus rebaños. ");
INSERT INTO spablm_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Lo que fue desgarrado de los animales, no te lo traje. Yo cargaba su pérdida. De mi mano lo exigiste, ya fuera robado de día o de noche. ");
INSERT INTO spablm_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Esta era mi situación: de día me consumía la sequía, y de noche la helada; y mi sueño huía de mis ojos. ");
INSERT INTO spablm_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Estos veinte años he estado en tu casa. Te he servido catorce años por tus dos hijas, y seis años por tu rebaño, y has cambiado mi salario diez veces. ");
INSERT INTO spablm_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Si el Dios de mi padre, el Dios de Abraham, y el temor de Isaac, no hubieran estado conmigo, seguramente ahora me habrías despedido con las manos vacías. Dios ha visto mi aflicción y el trabajo de mis manos, y te reprendió anoche”. ");
INSERT INTO spablm_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Labán respondió a Jacob: “¡Las hijas son mis hijas, los hijos son mis hijos, los rebaños son mis rebaños, y todo lo que ves es mío! ¿Qué puedo hacer hoy a estas mis hijas, o a sus hijos que han dado a luz? ");
INSERT INTO spablm_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Ahora ven, hagamos un pacto, tú y yo. Que sea para que haya un testimonio entre tú y yo”. ");
INSERT INTO spablm_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Jacob tomó una piedra y la puso como pilar. ");
INSERT INTO spablm_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Jacob dijo a sus parientes: “Recojan piedras”. Tomaron piedras e hicieron un montón. Comieron allí junto al montón. ");
INSERT INTO spablm_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Labán lo llamó Jegar Sahadutha, pero Jacob lo llamó Galeed. ");
INSERT INTO spablm_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Labán dijo: “Este montón es testigo entre tú y yo hoy”. Por eso se llamó Galeed ");
INSERT INTO spablm_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","y Mizpa, porque dijo: “Yahvé vela entre mí y tú, cuando estamos ausentes el uno del otro. ");
INSERT INTO spablm_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Si afliges a mis hijas, o si tomas esposas además de mis hijas, ningún hombre está con nosotros; he aquí que Dios es testigo entre mí y tú.” ");
INSERT INTO spablm_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Labán dijo a Jacob: “Mira este montón y mira la columna que he puesto entre mí y tú. ");
INSERT INTO spablm_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Que este montón sea testigo, y la columna sea testigo, de que yo no pasaré por encima de este montón para ti, y de que tú no pasarás por encima de este montón y de esta columna para mí, para hacer daño. ");
INSERT INTO spablm_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","El Dios de Abraham y el Dios de Nacor, el Dios de su padre, juzguen entre nosotros”. Entonces Jacob juró por el temor de su padre, Isaac. ");
INSERT INTO spablm_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Jacob ofreció un sacrificio en el monte, y llamó a sus parientes para que comieran pan. Comieron pan y se quedaron toda la noche en el monte. ");
INSERT INTO spablm_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Al amanecer, Labán se levantó, besó a sus hijos y a sus hijas y los bendijo. Labán partió y regresó a su lugar. ");
INSERT INTO spablm_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Jacob siguió su camino, y los ángeles de Dios salieron a su encuentro. ");
INSERT INTO spablm_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Al verlos, Jacob dijo: “Este es el ejército de Dios”. Llamó el nombre de aquel lugar Mahanaim. ");
INSERT INTO spablm_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Jacob envió mensajeros delante de él a Esaú, su hermano, a la tierra de Seir, el campo de Edom. ");
INSERT INTO spablm_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Les ordenó diciendo: “Esto es lo que le diréis a mi señor Esaú: ‘Esto es lo que dice tu siervo, Jacob. He vivido como extranjero con Labán, y me he quedado hasta ahora. ");
INSERT INTO spablm_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Tengo ganado, asnos, rebaños, siervos y siervas. He enviado a decírselo a mi señor, para que encuentre gracia ante tus ojos”. ");
INSERT INTO spablm_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Los mensajeros regresaron a Jacob diciendo: “Hemos venido a ver a tu hermano Esaú. Viene a tu encuentro, y cuatrocientos hombres están con él”. ");
INSERT INTO spablm_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Entonces Jacob tuvo mucho miedo y se angustió. Dividió a la gente que estaba con él, junto con los rebaños, las manadas y los camellos, en dos grupos. ");
INSERT INTO spablm_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Dijo: “Si Esaú llega a una de las compañías y la golpea, la compañía que queda escapará”. ");
INSERT INTO spablm_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Jacob dijo: “Dios de mi padre Abraham, y Dios de mi padre Isaac, Yahvé, que me dijo: ‘Vuelve a tu país y a tus parientes, y yo te haré el bien’, ");
INSERT INTO spablm_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","No soy digno de la menor de todas las bondades y de toda la verdad que has mostrado a tu siervo, pues sólo con mi bastón crucé este Jordán, y ahora me he convertido en dos compañías. ");
INSERT INTO spablm_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Por favor, líbrame de la mano de mi hermano, de la mano de Esaú; porque le temo, no sea que venga y me hiera a mí y a las madres con los hijos. ");
INSERT INTO spablm_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Dijiste: ‘Ciertamente te haré un bien y haré que tu descendencia sea como la arena del mar, que no se puede contar porque es muy numerosa’”. ");
INSERT INTO spablm_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Aquella noche se quedó allí y tomó de lo que llevaba consigo un regalo para Esaú, su hermano ");
INSERT INTO spablm_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","doscientas cabras hembras y veinte machos cabríos, doscientas ovejas y veinte carneros, ");
INSERT INTO spablm_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","treinta camellos de leche y sus potros, cuarenta vacas, diez toros, veinte asnos hembras y diez potros. ");
INSERT INTO spablm_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Los entregó en manos de sus siervos, cada rebaño por separado, y dijo a sus siervos: “Pasad delante de mí y poned un espacio entre rebaño y rebaño.” ");
INSERT INTO spablm_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Y ordenó a los primeros que dijeran: “Cuando Esaú, mi hermano, se encuentre con vosotros y os pregunte diciendo: “¿De quién sois? ¿Adónde vas? ¿De quién son estos que tienes delante?’ ");
INSERT INTO spablm_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Entonces dirás: ‘Son de tu siervo, de Jacob. Es un regalo enviado a mi señor, Esaú. He aquí que él también está detrás de nosotros’”. ");
INSERT INTO spablm_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Mandó también al segundo, al tercero y a todos los que seguían a los rebaños, diciendo: “Así hablaréis a Esaú cuando lo encontréis. ");
INSERT INTO spablm_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Diréis: “No sólo eso, sino que he aquí que tu siervo Jacob está detrás de nosotros”. Porque, dijo, “Lo apaciguaré con el presente que va delante de mí, y después veré su rostro. Tal vez me acepte”. ");
INSERT INTO spablm_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Así que el presente pasó ante él, y él mismo se quedó aquella noche en el campamento. ");
INSERT INTO spablm_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Aquella noche se levantó y tomó a sus dos mujeres, a sus dos siervos y a sus once hijos, y cruzó el vado del Jaboc. ");
INSERT INTO spablm_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Los tomó y los hizo pasar por el arroyo, y envió lo que tenía. ");
INSERT INTO spablm_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Jacob se quedó solo, y luchó allí con un hombre hasta el amanecer. ");
INSERT INTO spablm_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Al ver que no prevalecía contra él, el hombre le tocó el hueco del muslo, y el hueco del muslo de Jacob se tensó mientras luchaba. ");
INSERT INTO spablm_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","El hombre dijo: “Déjame ir, porque amanece”. Jacob dijo: “No te dejaré ir si no me bendices”. ");
INSERT INTO spablm_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Le dijo: “¿Cuál es tu nombre?” Dijo: “Jacob”. ");
INSERT INTO spablm_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Dijo: “Tu nombre ya no se llamará Jacob, sino Israel, porque has luchado con Dios y con los hombres, y has vencido.” ");
INSERT INTO spablm_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Jacob le preguntó: “Por favor, dime tu nombre”. Le dijo: “¿Por qué preguntas cuál es mi nombre?”. Y allí lo bendijo. ");
INSERT INTO spablm_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Jacob llamó el nombre del lugar Peniel; porque dijo: “He visto a Dios cara a cara, y mi vida se ha conservado.” ");
INSERT INTO spablm_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Al pasar por Peniel, el sol se puso sobre él, y cojeó a causa de su muslo. ");
INSERT INTO spablm_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Por eso los hijos de Israel no comen el tendón de la cadera, que está en el hueco del muslo, hasta el día de hoy, porque tocó el hueco del muslo de Jacob en el tendón de la cadera. ");
INSERT INTO spablm_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Jacob alzó los ojos y miró, y he aquí que Esaú venía, y con él cuatrocientos hombres. Repartió los niños entre Lea, Raquel y los dos criadas. ");
INSERT INTO spablm_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Puso a los siervos y a sus hijos al frente, a Lea y a sus hijos después, y a Raquel y a José en la retaguardia. ");
INSERT INTO spablm_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Él mismo pasó delante de ellos y se inclinó hasta el suelo siete veces, hasta llegar cerca de su hermano. ");
INSERT INTO spablm_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Esaú corrió a su encuentro, lo abrazó, se echó a su cuello y lo besó, y lloraron. ");
INSERT INTO spablm_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Levantó los ojos y vio a las mujeres y a los niños, y dijo: “¿Quiénes son estos que están contigo?” Dijo: “Los hijos que Dios ha dado a tu siervo”. ");
INSERT INTO spablm_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Entonces las siervas se acercaron con sus hijos y se inclinaron. ");
INSERT INTO spablm_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","También Lía y sus hijos se acercaron y se inclinaron. Después de ellos, José se acercó con Raquel, y se inclinaron. ");
INSERT INTO spablm_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esaú dijo: “¿Qué quieres decir con toda esta compañía que he conocido?” Jacob dijo: “Para encontrar el favor a los ojos de mi señor”. ");
INSERT INTO spablm_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Esaú dijo: “Tengo suficiente, hermano mío; que lo que tienes sea tuyo”. ");
INSERT INTO spablm_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Jacob dijo: “Por favor, no, si ahora he encontrado gracia ante tus ojos, recibe mi regalo de mi mano, porque he visto tu rostro, como se ve el rostro de Dios, y te has complacido en mí. ");
INSERT INTO spablm_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Toma, por favor, el regalo que te he traído, porque Dios ha sido benévolo conmigo, y porque tengo bastante”. Le instó, y lo tomó. ");
INSERT INTO spablm_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Esaú dijo: “Emprendamos nuestro viaje y vayamos, y yo iré delante de ti”. ");
INSERT INTO spablm_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Jacob le dijo: “Mi señor sabe que los niños son tiernos, y que los rebaños y las manadas que están conmigo tienen sus crías, y si un día se exceden, todos los rebaños morirán. ");
INSERT INTO spablm_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Por favor, deja que mi señor pase delante de su siervo, y yo seguiré con suavidad, según el paso del ganado que va delante de mí y según el paso de los niños, hasta que llegue a mi señor a Seir.” ");
INSERT INTO spablm_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esaú dijo: “Déjame ahora dejar contigo a algunos de los que están conmigo”. Dijo: “¿Por qué? Déjeme encontrar el favor a los ojos de mi señor”. ");
INSERT INTO spablm_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Así que Esaú regresó aquel día de camino a Seir. ");
INSERT INTO spablm_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Jacob viajó a Sucot, se construyó una casa e hizo refugios para su ganado. Por eso el nombre del lugar se llama Sucot. ");
INSERT INTO spablm_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Jacob llegó en paz a la ciudad de Siquem, que está en la tierra de Canaán, cuando venía de Padán Aram; y acampó ante la ciudad. ");
INSERT INTO spablm_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Compró la parcela donde había tendido su tienda, de mano de los hijos de Hamor, padre de Siquem, por cien monedas. ");
INSERT INTO spablm_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Levantó allí un altar y lo llamó El Elohe Israel. ");
INSERT INTO spablm_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Dina, la hija de Lea, que dio a luz a Jacob, salió a ver a las hijas de la tierra. ");
INSERT INTO spablm_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","La vio Siquem, hijo de Hamor el heveo, príncipe de la tierra. La tomó, se acostó con ella y la humilló. ");
INSERT INTO spablm_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Su alma se unió a Dina, la hija de Jacob, y amó a la joven, y le habló con cariño. ");
INSERT INTO spablm_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Siquem habló con su padre, Hamor, diciendo: “Consígueme a esta joven como esposa”. ");
INSERT INTO spablm_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Jacob se enteró de que había mancillado a su hija Dina, y sus hijos estaban con su ganado en el campo. Jacob calló hasta que llegaron. ");
INSERT INTO spablm_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Hamor, el padre de Siquem, salió a buscar a Jacob para hablar con él. ");
INSERT INTO spablm_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Los hijos de Jacob vinieron del campo cuando lo oyeron. Los hombres se entristecieron y se enojaron mucho, porque él había hecho una locura en Israel al acostarse con la hija de Jacob, cosa que no debía hacerse. ");
INSERT INTO spablm_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamor habló con ellos, diciendo: “El alma de mi hijo Siquem anhela a su hija. Por favor, dénsela como esposa. ");
INSERT INTO spablm_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Hagan matrimonios con nosotros. Dennos sus hijas y tomen las nuestras para ustedes. ");
INSERT INTO spablm_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Viviréis con nosotros, y la tierra estará ante vosotros. Vivan y comercien en ella, y obtengan posesiones en ella”. ");
INSERT INTO spablm_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Siquem dijo a su padre y a sus hermanos: “Dejadme encontrar el favor de vuestros ojos, y todo lo que me digáis os lo daré. ");
INSERT INTO spablm_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Pedidme una gran cantidad como dote, y os daré lo que me pidáis, pero dadme a la joven como esposa”. ");
INSERT INTO spablm_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Los hijos de Jacob respondieron a Siquem y a su padre Hamor con engaño cuando hablaron, porque había mancillado a Dina, su hermana, ");
INSERT INTO spablm_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","y les dijeron: “No podemos hacer esto, entregar a nuestra hermana a un incircunciso; porque eso es un reproche para nosotros. ");
INSERT INTO spablm_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Sólo con esta condición os consentiremos. Si sois como nosotros, que todo varón de vosotros sea circuncidado, ");
INSERT INTO spablm_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","entonces os daremos nuestras hijas; y tomaremos vuestras hijas para nosotros, y moraremos con vosotros, y seremos un solo pueblo. ");
INSERT INTO spablm_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Pero si no nos escucháis y os circuncidáis, entonces tomaremos a nuestra hermana, y nos iremos”. ");
INSERT INTO spablm_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Sus palabras agradaron a Hamor y a Siquem, hijo de Hamor. ");
INSERT INTO spablm_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","El joven no esperó para hacer esto, porque se había deleitado en la hija de Jacob, y fue honrado sobre toda la casa de su padre. ");
INSERT INTO spablm_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Hamor y Siquem, su hijo, llegaron a la puerta de su ciudad, y hablaron con los hombres de su ciudad, diciendo: ");
INSERT INTO spablm_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Estos hombres son pacíficos con nosotros. Por lo tanto, déjenlos vivir en la tierra y comerciar en ella. Porque he aquí que la tierra es suficientemente grande para ellos. Tomemos a sus hijas para nosotros como esposas, y démosles nuestras hijas. ");
INSERT INTO spablm_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Sólo con esta condición los hombres consentirán en vivir con nosotros, para ser un solo pueblo, si todo varón de entre nosotros se circuncida, como ellos se circuncidan. ");
INSERT INTO spablm_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","¿No será nuestro su ganado y sus posesiones y todos sus animales? Sólo démosles nuestro consentimiento, y ellos habitarán con nosotros”. ");
INSERT INTO spablm_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Todos los que salían de la puerta de su ciudad escuchaban a Hamor y a su hijo Siquem, y todo varón era circuncidado, todos los que salían de la puerta de su ciudad. ");
INSERT INTO spablm_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Al tercer día, cuando ya estaban adoloridos, dos de los hijos de Jacob, Simeón y Leví, hermanos de Dina, tomaron cada uno su espada, vinieron a la ciudad desprevenida y mataron a todos los varones. ");
INSERT INTO spablm_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Mataron a Hamor y a Siquem, su hijo, a filo de espada, y sacaron a Dina de la casa de Siquem y se fueron. ");
INSERT INTO spablm_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Los hijos de Jacob vinieron sobre los muertos y saquearon la ciudad, porque habían profanado a su hermana. ");
INSERT INTO spablm_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Tomaron sus rebaños, sus vacas, sus asnos, lo que había en la ciudad, lo que había en el campo, ");
INSERT INTO spablm_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","y toda su riqueza. Llevaron cautivos a todos sus pequeños y a sus mujeres, y tomaron como botín todo lo que había en la casa. ");
INSERT INTO spablm_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Jacob dijo a Simeón y a Leví: “Me habéis turbado para hacerme odioso a los habitantes del país, entre los cananeos y los ferezeos. Soy poco numeroso. Se reunirán contra mí y me atacarán, y seré destruido, yo y mi casa”. ");
INSERT INTO spablm_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Dijeron: “¿Debe tratar a nuestra hermana como a una prostituta?” ");
INSERT INTO spablm_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Dios dijo a Jacob: “Levántate, sube a Betel y vive allí. Haz allí un altar a Dios, que se te apareció cuando huías de la cara de tu hermano Esaú”. ");
INSERT INTO spablm_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Entonces Jacob dijo a su familia y a todos los que estaban con él: “Quitad los dioses extranjeros que hay entre vosotros, purificaos y cambiad vuestros vestidos. ");
INSERT INTO spablm_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Levantémonos y subamos a Betel. Haré allí un altar a Dios, que me respondió en el día de mi angustia y estuvo conmigo en el camino que recorrí.” ");
INSERT INTO spablm_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Entregaron a Jacob todos los dioses extranjeros que tenían en sus manos, y los anillos que tenían en sus orejas; y Jacob los escondió bajo la encina que estaba junto a Siquem. ");
INSERT INTO spablm_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Ellos viajaron, y un terror de Dios estaba sobre las ciudades que estaban alrededor, y no persiguieron a los hijos de Jacob. ");
INSERT INTO spablm_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Entonces Jacob llegó a Luz (es decir, Betel), que está en la tierra de Canaán, él y todo el pueblo que estaba con él. ");
INSERT INTO spablm_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Edificó allí un altar y llamó al lugar El Betel, porque allí se le reveló Dios, cuando huía de la cara de su hermano. ");
INSERT INTO spablm_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Murió Débora, la nodriza de Rebeca, y fue enterrada debajo de Betel, bajo la encina; y su nombre fue llamado Allon Bacuth. ");
INSERT INTO spablm_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Dios se le apareció de nuevo a Jacob, cuando venía de Padán Aram, y lo bendijo. ");
INSERT INTO spablm_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Dios le dijo: “Tu nombre es Jacob. Ya no te llamarás Jacob, sino que te llamarás Israel”. Le puso el nombre de Israel. ");
INSERT INTO spablm_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Dios le dijo: “Yo soy el Dios Todopoderoso. Sé fecundo y multiplícate. De ti saldrá una nación y una compañía de naciones, y de tu cuerpo saldrán reyes. ");
INSERT INTO spablm_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","La tierra que di a Abraham y a Isaac, te la daré a ti, y a tu descendencia después de ti le daré la tierra”. ");
INSERT INTO spablm_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Dios se alejó de él en el lugar donde habló con él. ");
INSERT INTO spablm_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Jacob levantó una columna en el lugar donde habló con él, una columna de piedra. Derramó sobre ella una libación y derramó sobre ella aceite. ");
INSERT INTO spablm_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Jacob llamó “Betel” al lugar donde Dios habló con él. ");
INSERT INTO spablm_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Viajaron desde Betel. Todavía faltaba una distancia para llegar a Efraín, y Raquel estaba de parto. Tuvo un duro parto. ");
INSERT INTO spablm_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Cuando estaba de parto, la partera le dijo: “No temas, porque ahora tendrás otro hijo.” ");
INSERT INTO spablm_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Cuando su alma partió (pues murió), le puso el nombre de Benoni, pero su padre le puso el nombre de Benjamín. ");
INSERT INTO spablm_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Raquel murió y fue enterrada en el camino de Efrata (también llamada Belén). ");
INSERT INTO spablm_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Jacob levantó una columna sobre su tumba. El mismo es el pilar de la tumba de Raquel hasta el día de hoy. ");
INSERT INTO spablm_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Israel viajó y extendió su tienda más allá de la torre de Eder. ");
INSERT INTO spablm_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Mientras Israel vivía en esa tierra, Rubén fue y se acostó con Bilhá, la concubina de su padre, e Israel se enteró. Los hijos de Jacob eran doce. ");
INSERT INTO spablm_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Los hijos de Lea: Rubén (primogénito de Jacob), Simeón, Leví, Judá, Isacar y Zabulón. ");
INSERT INTO spablm_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Los hijos de Raquel: José y Benjamín. ");
INSERT INTO spablm_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Los hijos de Bilhah (sierva de Raquel): Dan y Neftalí. ");
INSERT INTO spablm_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Los hijos de Zilpa (sierva de Lea): Gad y Aser. Estos son los hijos de Jacob, que le nacieron en Padan Aram. ");
INSERT INTO spablm_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jacob vino a Isaac, su padre, a Mamre, a Quiriat Arba (que es Hebrón), donde Abraham e Isaac vivían como extranjeros. ");
INSERT INTO spablm_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Los días de Isaac fueron ciento ochenta años. ");
INSERT INTO spablm_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Isaac entregó el espíritu y murió, y fue reunido con su pueblo, viejo y lleno de días. Esaú y Jacob, sus hijos, lo enterraron. ");
INSERT INTO spablm_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Esta es la historia de las generaciones de Esaú (es decir, Edom). ");
INSERT INTO spablm_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esaú tomó sus esposas de las hijas de Canaán: Ada, hija de Elón, el hitita; y Aholibama, hija de Aná, hija de Zibeón, el heveo; ");
INSERT INTO spablm_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","y Basemat, hija de Ismael, hermana de Nebaiot. ");
INSERT INTO spablm_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada dio a luz a Esaú, Elifaz. Basemat dio a luz a Reuel. ");
INSERT INTO spablm_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Aholibama dio a luz a Jeús, Jalam y Coré. Estos son los hijos de Esaú, que le nacieron en la tierra de Canaán. ");
INSERT INTO spablm_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esaú tomó a sus esposas, a sus hijos, a sus hijas y a todos los miembros de su familia, con su ganado, todos sus animales y todas sus posesiones, que había reunido en la tierra de Canaán, y se fue a una tierra alejada de su hermano Jacob. ");
INSERT INTO spablm_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Porque su riqueza era demasiado grande para que pudieran habitar juntos, y la tierra de sus viajes no podía soportarlos a causa de su ganado. ");
INSERT INTO spablm_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Esaú vivió en la región montañosa de Seir. Esaú es Edom. ");
INSERT INTO spablm_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Esta es la historia de las generaciones de Esaú, padre de los edomitas, en la región montañosa de Seír: ");
INSERT INTO spablm_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Estos son los nombres de los hijos de Esaú Elifaz, hijo de Ada, esposa de Esaú; y Reuel, hijo de Basemat, esposa de Esaú. ");
INSERT INTO spablm_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Los hijos de Elifaz fueron Temán, Omar, Zefo, Gatam y Cenaz. ");
INSERT INTO spablm_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Timna fue concubina de Elifaz, hijo de Esaú, y dio a luz a Amalec. Estos son los descendientes de Ada, esposa de Esaú. ");
INSERT INTO spablm_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Estos son los hijos de Reuel: Nahat, Zera, Sama y Miza. Estos fueron los descendientes de Basemat, esposa de Esaú. ");
INSERT INTO spablm_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Estos fueron los hijos de Aholibama, hija de Aná, hija de Zibeón, mujer de Esaú; ella dio a luz a Esaú: Jeús, Jalam y Coré. ");
INSERT INTO spablm_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Estos son los jefes de los hijos de Esaú: los hijos de Elifaz, primogénito de Esaú: el jefe Temán, el jefe Omar, el jefe Zefo, el jefe Cenaz, ");
INSERT INTO spablm_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","el jefe Coré, el jefe Gatam, el jefe Amalec. Estos son los jefes que vinieron de Elifaz en la tierra de Edom. Estos son los hijos de Ada. ");
INSERT INTO spablm_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Estos son los hijos de Reuel, hijo de Esaú: el jefe Nahat, el jefe Zerah, el jefe Shammah, el jefe Mizzah. Estos son los jefes que vinieron de Reuel en la tierra de Edom. Estos son los hijos de Basemat, mujer de Esaú. ");
INSERT INTO spablm_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Estos son los hijos de Aholibama, mujer de Esaú: el jefe Jeús, el jefe Jalam y el jefe Coré. Estos son los jefes que vinieron de Aholibama, hija de Aná, mujer de Esaú. ");
INSERT INTO spablm_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Estos son los hijos de Esaú (es decir, Edom), y estos son sus jefes. ");
INSERT INTO spablm_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Estos son los hijos de Seir el horeo, los habitantes de la tierra: Lotán, Sobal, Zibeón, Aná, ");
INSERT INTO spablm_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Disón, Ezer y Disán. Estos son los jefes que vinieron de los horeos, los hijos de Seír en la tierra de Edom. ");
INSERT INTO spablm_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Los hijos de Lotán fueron Hori y Hemán. La hermana de Lotán fue Timna. ");
INSERT INTO spablm_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Estos son los hijos de Sobal: Alván, Manahat, Ebal, Sefo y Onam. ");
INSERT INTO spablm_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Estos son los hijos de Zibeón Aja y Aná. Este es Aná, que encontró las aguas termales en el desierto, mientras alimentaba a los asnos de Zibeón, su padre. ");
INSERT INTO spablm_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Estos son los hijos de Aná: Disón y Aholibama, hija de Aná. ");
INSERT INTO spablm_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Estos son los hijos de Disón: Hemdán, Esbán, Itrán y Querán. ");
INSERT INTO spablm_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Estos son los hijos de Ezer Bilhán, Zaaván y Acán. ");
INSERT INTO spablm_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Estos son los hijos de Disán: Uz y Arán. ");
INSERT INTO spablm_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Estos son los jefes que vinieron de los horeos: el jefe Lotán, el jefe Sobal, el jefe Zibeón, el jefe Aná, ");
INSERT INTO spablm_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","el jefe Disón, el jefe Ezer y el jefe Disán. Estos son los jefes que vinieron de los horeos, según sus jefes en la tierra de Seir. ");
INSERT INTO spablm_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Estos son los reyes que reinaron en la tierra de Edom, antes de que ningún rey reinara sobre los hijos de Israel. ");
INSERT INTO spablm_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela, hijo de Beor, reinó en Edom. El nombre de su ciudad fue Dinaba. ");
INSERT INTO spablm_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela murió, y en su lugar reinó Jobab, hijo de Zera de Bosra. ");
INSERT INTO spablm_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Murió Jobab, y en su lugar reinó Husam, del país de los temanitas. ");
INSERT INTO spablm_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Murió Husam, y reinó en su lugar Hadad, hijo de Bedad, que hirió a Madián en el campo de Moab. El nombre de su ciudad fue Avit. ");
INSERT INTO spablm_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Murió Hadad, y en su lugar reinó Samlá de Masreca. ");
INSERT INTO spablm_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Murió Samlá, y en su lugar reinó Saúl, de Rehobot, junto al río. ");
INSERT INTO spablm_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Murió Saúl, y en su lugar reinó Baal Hanán, hijo de Acbor. ");
INSERT INTO spablm_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Murió Baal Hanán, hijo de Acbor, y en su lugar reinó Hadar. El nombre de su ciudad fue Pau. Su esposa se llamaba Mehetabel, hija de Matred, hija de Mezab. ");
INSERT INTO spablm_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Estos son los nombres de los jefes que vinieron de Esaú, según sus familias, por sus lugares y por sus nombres: el jefe Timna, el jefe Alva, el jefe Jetet, ");
INSERT INTO spablm_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","el jefe Aholibamah, el jefe Ela, el jefe Pinon, ");
INSERT INTO spablm_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","el jefe Cenaz, el jefe Teman, el jefe Mibzar, ");
INSERT INTO spablm_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","el jefe Magdiel y el jefe Iram. Estos son los jefes de Edom, según sus domicilios en la tierra de su posesión. Este es Esaú, el padre de los edomitas. ");
INSERT INTO spablm_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jacob vivía en la tierra donde peregrinó su padre, en la tierra de Canaán. ");
INSERT INTO spablm_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Esta es la historia de las generaciones de Jacob. José, teniendo diecisiete años, apacentaba el rebaño con sus hermanos. Era un muchacho con los hijos de Bilha y Zilpa, las esposas de su padre. José informó a su padre sobre su maldad. ");
INSERT INTO spablm_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Israel amaba a José más que a todos sus hijos, porque era el hijo de su vejez, y le hizo una túnica de muchos colores. ");
INSERT INTO spablm_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Sus hermanos vieron que su padre lo amaba más que a todos sus hermanos, y lo odiaron y no pudieron hablarle pacíficamente. ");
INSERT INTO spablm_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","José soñó un sueño, y se lo contó a sus hermanos, y éstos lo odiaron aún más. ");
INSERT INTO spablm_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Les dijo: “Escuchad este sueño que he soñado: ");
INSERT INTO spablm_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","porque he aquí que estábamos atando gavillas en el campo, y he aquí que mi gavilla se levantó y también se puso de pie; y he aquí que vuestras gavillas se acercaron y se inclinaron hacia mi gavilla.” ");
INSERT INTO spablm_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Sus hermanos le preguntaron: “¿De verdad vas a reinar sobre nosotros? ¿Realmente tendrás dominio sobre nosotros?” Lo odiaban aún más por sus sueños y por sus palabras. ");
INSERT INTO spablm_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Soñó aún otro sueño y lo contó a sus hermanos, diciendo: “He aquí que he soñado otro sueño, y he aquí que el sol, la luna y once estrellas se inclinaban ante mí.” ");
INSERT INTO spablm_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Se lo contó a su padre y a sus hermanos. Su padre lo reprendió y le dijo: “¿Qué es este sueño que has soñado? ¿Acaso yo y tu madre y tus hermanos vendremos a postrarnos en la tierra ante ti?” ");
INSERT INTO spablm_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Sus hermanos le envidiaban, pero su padre tenía presente esta frase. ");
INSERT INTO spablm_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Sus hermanos fueron a apacentar el rebaño de su padre en Siquem. ");
INSERT INTO spablm_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Israel dijo a José: “¿No están tus hermanos apacentando el rebaño en Siquem? Ven, y te enviaré con ellos”. Él le respondió: “Aquí estoy”. ");
INSERT INTO spablm_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Le dijo: “Ve ahora a ver si les va bien a tus hermanos y al rebaño, y tráeme otra vez la noticia”. Y lo envió fuera del valle de Hebrón, y llegó a Siquem. ");
INSERT INTO spablm_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Cierto hombre lo encontró, y he aquí que estaba vagando por el campo. El hombre le preguntó: “¿Qué buscas?” ");
INSERT INTO spablm_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Dijo: “Busco a mis hermanos. Dime, por favor, dónde están apacentando el rebaño”. ");
INSERT INTO spablm_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","El hombre dijo: “Se han ido de aquí, porque les he oído decir: “Vamos a Dotán””. José fue tras sus hermanos y los encontró en Dotán. ");
INSERT INTO spablm_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Lo vieron de lejos, y antes de que se acercara a ellos, conspiraron contra él para matarlo. ");
INSERT INTO spablm_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Se decían unos a otros: “He aquí que viene este soñador. ");
INSERT INTO spablm_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Venid, pues, y matémosle, y echémosle en uno de los pozos, y diremos: ‘Un animal malvado le ha devorado’. Veremos qué será de sus sueños”. ");
INSERT INTO spablm_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Rubén lo oyó y lo libró de sus manos y dijo: “No le quitemos la vida”. ");
INSERT INTO spablm_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Rubén les dijo: “No derramen sangre. Arrojadlo a este pozo que está en el desierto, pero no le pongáis la mano encima”, para librarlo de sus manos y devolverlo a su padre. ");
INSERT INTO spablm_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Cuando José llegó a manos de sus hermanos, éstos le quitaron la túnica de muchos colores que llevaba puesta; ");
INSERT INTO spablm_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","lo tomaron y lo arrojaron a la fosa. La fosa estaba vacía. No había agua en ella. ");
INSERT INTO spablm_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Se sentaron a comer el pan, y levantaron los ojos y miraron, y vieron que una caravana de ismaelitas venía de Galaad, con sus camellos cargados de especias, bálsamo y mirra, que iban a llevar a Egipto. ");
INSERT INTO spablm_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Judá dijo a sus hermanos: “¿De qué nos sirve matar a nuestro hermano y ocultar su sangre? ");
INSERT INTO spablm_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Vengan y vendámoslo a los ismaelitas, y que nuestra mano no lo toque, porque es nuestro hermano, nuestra carne.” Sus hermanos le hicieron caso. ");
INSERT INTO spablm_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Pasaron unos madianitas que eran mercaderes, y sacaron y levantaron a José de la fosa, y vendieron a José a los ismaelitas por veinte monedas de plata. Los mercaderes llevaron a José a Egipto. ");
INSERT INTO spablm_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Rubén volvió a la fosa y vio que José no estaba en ella, y se rasgó las vestiduras. ");
INSERT INTO spablm_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Volvió a sus hermanos y dijo: “El niño ya no está; y yo, ¿a dónde iré?” ");
INSERT INTO spablm_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Tomaron la túnica de José, mataron un macho cabrío y mojaron la túnica en la sangre. ");
INSERT INTO spablm_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Tomaron la túnica de muchos colores, la llevaron a su padre y le dijeron: “Hemos encontrado esto. Examínala ahora y comprueba si es la túnica de tu hijo o no”. ");
INSERT INTO spablm_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Lo reconoció y dijo: “Es la túnica de mi hijo. Un animal malvado lo ha devorado. Sin duda, José está despedazado”. ");
INSERT INTO spablm_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Jacob se rasgó las vestiduras, se puso tela de saco en la cintura y lloró a su hijo durante muchos días. ");
INSERT INTO spablm_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Todos sus hijos y todas sus hijas se levantaron para consolarlo, pero él se negó a ser consolado. Dijo: “Porque bajaré al Seol a mi hijo, de luto”. Su padre lloró por él. ");
INSERT INTO spablm_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Los madianitas lo vendieron a Egipto a Potifar, un oficial del Faraón, el capitán de la guardia. ");
INSERT INTO spablm_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","En aquel tiempo, Judá bajó de entre sus hermanos y visitó a un adulamita que se llamaba Hira. ");
INSERT INTO spablm_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Allí, Judá vio a la hija de un cananeo llamado Súa. La tomó y se acercó a ella. ");
INSERT INTO spablm_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Ella concibió y dio a luz un hijo, al que llamó Er. ");
INSERT INTO spablm_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Concibió de nuevo y dio a luz un hijo, al que llamó Onán. ");
INSERT INTO spablm_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Concibió de nuevo y dio a luz un hijo, al que llamó Sala. Estaba en Chezib cuando lo dio a luz. ");
INSERT INTO spablm_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Judá tomó una esposa para Er, su primogénito, y su nombre fue Tamar. ");
INSERT INTO spablm_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Er, el primogénito de Judá, era malvado a los ojos de Yahvé. Así que Yahvé lo mató. ");
INSERT INTO spablm_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Judá le dijo a Onán: “Acércate a la mujer de tu hermano y cumple con ella el deber de un marido hermano, y cría descendencia para tu hermano.” ");
INSERT INTO spablm_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Onán sabía que la descendencia no sería suya; y cuando entró a la mujer de su hermano, derramó su semen en el suelo, para no dar descendencia a su hermano. ");
INSERT INTO spablm_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Lo que hizo fue malo a los ojos de Yahvé, y también lo mató. ");
INSERT INTO spablm_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Entonces Judá le dijo a Tamar, su nuera: “Quédate viuda en la casa de tu padre hasta que crezca Sala, mi hijo”, pues dijo: “No sea que él también muera como sus hermanos”. Tamar se fue a vivir a la casa de su padre. ");
INSERT INTO spablm_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Después de muchos días, murió la hija de Súa, esposa de Judá. Judá se consoló y subió con sus esquiladores de ovejas a Timná, él y su amigo Hira, el adulamita. ");
INSERT INTO spablm_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Le dijeron a Tamar: “Mira, tu suegro sube a Timnát a esquilar sus ovejas”. ");
INSERT INTO spablm_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Ella se quitó las prendas de su viudez, se cubrió con su velo y se envolvió, y se sentó en la puerta de Enaim, que está en el camino de Timnát, porque vio que Selá era mayor, y que ella no le había sido dada como esposa. ");
INSERT INTO spablm_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Cuando Judá la vio, pensó que era una prostituta, pues se había cubierto el rostro. ");
INSERT INTO spablm_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Se dirigió a ella por el camino y le dijo: “Por favor, ven, déjame entrar contigo”, pues no sabía que era su nuera. Ella dijo: “¿Qué me darás, para que puedas entrar en mí?” ");
INSERT INTO spablm_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Dijo: “Te enviaré un cabrito del rebaño”. Ella dijo: “¿Me darás una prenda, hasta que la envíes?” ");
INSERT INTO spablm_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Él dijo: “¿Qué prenda te daré?” Ella dijo: “Tu sello y tu cordón, y tu bastón que está en tu mano”. Se los dio, y entró en ella, y ella concibió por él. ");
INSERT INTO spablm_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Ella se levantó y se fue, y se quitó el velo de encima y se puso las ropas de su viudez. ");
INSERT INTO spablm_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Judá envió al cabrito de la mano de su amigo, el adulamita, a recibir la prenda de la mano de la mujer, pero no la encontró. ");
INSERT INTO spablm_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Entonces preguntó a los hombres de su lugar, diciendo: “¿Dónde está la prostituta que estaba en Enaim, junto al camino?” Dijeron: “Aquí no ha habido ninguna prostituta”. ");
INSERT INTO spablm_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Volvió a Judá y le dijo: “No la he encontrado; y también los hombres del lugar dijeron: “Aquí no ha habido ninguna prostituta””. ");
INSERT INTO spablm_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Judá dijo: “Que se quede con ella, no sea que nos avergoncemos. He aquí que he enviado esta cabrita, y no la has encontrado”. ");
INSERT INTO spablm_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Unos tres meses después, se le dijo a Judá: “Tamar, tu nuera, se ha prostituido. Además, he aquí que está embarazada por prostitución”. Judá dijo: “Sácala y que la quemen”. ");
INSERT INTO spablm_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Cuando la sacaron, envió a decir a su suegro: “Estoy embarazada del hombre que tiene esto”. También le dijo: “Por favor, discierne de quién son estos: el sello, los cordones y el bastón”. ");
INSERT INTO spablm_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Judá los reconoció y dijo: “Ella es más justa que yo, porque no se la di a Sala, mi hijo”. No volvió a conocerla. ");
INSERT INTO spablm_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","En el tiempo de su parto, he aquí que había gemelos en su seno. ");
INSERT INTO spablm_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Cuando dio a luz, uno de ellos sacó una mano, y la partera tomó y ató un hilo de grana en su mano, diciendo: “Este salió primero.” ");
INSERT INTO spablm_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Al retirar la mano, he aquí que su hermano salió, y ella le dijo: “¿Por qué te has hecho una brecha?” Por eso se llamó Fares. ");
INSERT INTO spablm_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Después salió su hermano, que tenía el hilo escarlata en la mano, y se llamó Zerah. ");
INSERT INTO spablm_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","José fue llevado a Egipto. Potifar, un oficial del Faraón, el capitán de la guardia, un egipcio, lo compró de la mano de los ismaelitas que lo habían hecho descender. ");
INSERT INTO spablm_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","El Señor estaba con José, y éste era un hombre próspero. Estaba en la casa de su amo el egipcio. ");
INSERT INTO spablm_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Su amo vio que Yahvé estaba con él, y que Yahvé hacía prosperar en su mano todo lo que hacía. ");
INSERT INTO spablm_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","José halló gracia ante sus ojos. Le sirvió, y Potifar lo nombró supervisor de su casa, y todo lo que tenía lo puso en sus manos. ");
INSERT INTO spablm_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Desde el momento en que lo nombró supervisor de su casa y de todo lo que tenía, Yahvé bendijo la casa del egipcio por causa de José. La bendición del Señor recayó sobre todo lo que tenía, en la casa y en el campo. ");
INSERT INTO spablm_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Dejó todo lo que tenía en manos de José. No se preocupó por nada, excepto por la comida que comía. José era bien parecido y guapo. ");
INSERT INTO spablm_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Después de esto, la mujer de su amo puso sus ojos en José y le dijo: “Acuéstate conmigo”. ");
INSERT INTO spablm_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Pero él se negó y dijo a la mujer de su amo: “He aquí que mi amo no sabe lo que hay conmigo en la casa, y ha puesto en mi mano todo lo que tiene. ");
INSERT INTO spablm_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Nadie es mayor que yo en esta casa, y no me ha ocultado nada más que a ti, porque eres su mujer. ¿Cómo, pues, puedo hacer esta gran maldad, y pecar contra Dios?” ");
INSERT INTO spablm_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Mientras ella le hablaba a José cada día, él no la escuchaba, ni se acostaba junto a ella, ni estaba con ella. ");
INSERT INTO spablm_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Por aquel entonces, él entró en la casa para hacer su trabajo, y no había ninguno de los hombres de la casa dentro. ");
INSERT INTO spablm_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Ella lo agarró por el manto, diciendo: “Acuéstate conmigo”. Él dejó su manto en la mano de ella y salió corriendo. ");
INSERT INTO spablm_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Cuando ella vio que él había dejado su manto en la mano de ella, y había corrido afuera, ");
INSERT INTO spablm_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","llamó a los hombres de su casa, y les habló diciendo: “He aquí, él ha traído a un hebreo para burlarse de nosotros. Entró en mi casa para acostarse conmigo, y yo grité con fuerza. ");
INSERT INTO spablm_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Cuando oyó que yo levantaba la voz y gritaba, dejó su manto junto a mí y salió corriendo.” ");
INSERT INTO spablm_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Ella dejó su ropa junto a ella, hasta que su amo volvió a casa. ");
INSERT INTO spablm_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Ella le habló según estas palabras, diciendo: “El siervo hebreo que nos has traído, entró a burlarse de mí, ");
INSERT INTO spablm_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","y al levantar mi voz y gritar, dejó su ropa junto a mí y salió corriendo.” ");
INSERT INTO spablm_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Cuando su amo oyó las palabras de su mujer, que le dijo: “Esto es lo que me hizo tu siervo”, se encendió su ira. ");
INSERT INTO spablm_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","El amo de José lo apresó y lo metió en la cárcel, el lugar donde estaban atados los prisioneros del rey, y allí estuvo detenido. ");
INSERT INTO spablm_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Pero el Señor estaba con José, y se mostró bondadoso con él, y le dio favor a los ojos del guardián de la prisión. ");
INSERT INTO spablm_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","El guardián de la cárcel puso en manos de José a todos los presos que estaban en la cárcel. Todo lo que hicieran allí, él era responsable de ello. ");
INSERT INTO spablm_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","El guardián de la cárcel no se ocupaba de nada de lo que estaba bajo su mano, porque el Señor estaba con él; y lo que él hacía, el Señor lo hacía prosperar. ");
INSERT INTO spablm_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Después de estas cosas, el copero del rey de Egipto y su panadero ofendieron a su señor, el rey de Egipto. ");
INSERT INTO spablm_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","El faraón se enojó con sus dos oficiales, el jefe de los coperos y el jefe de los panaderos. ");
INSERT INTO spablm_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Los puso en custodia en la casa del capitán de la guardia, en la cárcel, el lugar donde estaba atado José. ");
INSERT INTO spablm_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","El capitán de la guardia se los asignó a José, y él se ocupó de ellos. Permanecieron en la cárcel muchos días. ");
INSERT INTO spablm_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Ambos soñaron un sueño, cada uno su sueño, en una noche, cada uno según la interpretación de su sueño, el copero y el panadero del rey de Egipto, que estaban atados en la cárcel. ");
INSERT INTO spablm_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","José entró a ellos por la mañana, los vio y vio que estaban tristes. ");
INSERT INTO spablm_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Preguntó a los oficiales del faraón que estaban con él detenidos en la casa de su amo, diciendo: “¿Por qué parecen tan tristes hoy?” ");
INSERT INTO spablm_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Le dijeron: “Hemos soñado un sueño y no hay nadie que pueda interpretarlo”. José les dijo: “¿Las interpretaciones no son de Dios? Por favor, díganmelo a mí”. ");
INSERT INTO spablm_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","El jefe de los coperos contó su sueño a José y le dijo: “En mi sueño, he aquí que una vid estaba delante de mí, ");
INSERT INTO spablm_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","y en la vid había tres sarmientos. Era como si hubiera brotado, florecido, y sus racimos producían uvas maduras. ");
INSERT INTO spablm_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","La copa del faraón estaba en mi mano; tomé las uvas, las exprimí en la copa del faraón y entregué la copa en la mano del faraón.” ");
INSERT INTO spablm_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","José le dijo: “Esta es su interpretación: las tres ramas son tres días. ");
INSERT INTO spablm_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Dentro de tres días más, el faraón levantará tu cabeza y te devolverá tu cargo. Entregarás la copa del Faraón en su mano, como lo hacías cuando eras su copero. ");
INSERT INTO spablm_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Pero acuérdate de mí cuando te vaya bien. Por favor, muéstrate bondadoso conmigo, y mencióname ante el Faraón, y sácame de esta casa. ");
INSERT INTO spablm_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Porque ciertamente fui robado de la tierra de los hebreos, y aquí tampoco he hecho nada para que me metan en el calabozo.” ");
INSERT INTO spablm_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Cuando el jefe de los panaderos vio que la interpretación era buena, dijo a José: “Yo también estaba en mi sueño, y he aquí que tres cestas de pan blanco estaban sobre mi cabeza. ");
INSERT INTO spablm_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","En el cesto de arriba había toda clase de alimentos horneados para el Faraón, y las aves los comían del cesto sobre mi cabeza.” ");
INSERT INTO spablm_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","José respondió: “Esta es su interpretación. Los tres cestos son tres días. ");
INSERT INTO spablm_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Dentro de tres días más, el Faraón levantará tu cabeza de encima, te colgará en un árbol y las aves comerán tu carne de encima.” ");
INSERT INTO spablm_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Al tercer día, que era el cumpleaños del Faraón, éste hizo un banquete para todos sus servidores, y levantó la cabeza del jefe de los coperos y la del jefe de los panaderos entre sus servidores. ");
INSERT INTO spablm_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Restituyó al jefe de los coperos a su puesto, y entregó la copa a la mano del Faraón; ");
INSERT INTO spablm_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","pero colgó al jefe de los panaderos, como José les había interpretado. ");
INSERT INTO spablm_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Sin embargo, el jefe de los coperos no se acordó de José, sino que lo olvidó. ");
INSERT INTO spablm_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Al cabo de dos años completos, Faraón soñó, y he aquí que estaba junto al río. ");
INSERT INTO spablm_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","He aquí que siete reses subían del río. Estaban lisos y gordos, y se alimentaban en la hierba del pantano. ");
INSERT INTO spablm_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","He aquí que otras siete reses subían tras ellas del río, feas y flacas, y se quedaban junto a las otras reses al borde del río. ");
INSERT INTO spablm_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Las reses feas y flacas se comieron a las siete reses lisas y gordas. Entonces el faraón se despertó. ");
INSERT INTO spablm_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Se durmió y soñó por segunda vez; y he aquí que siete cabezas de grano surgían en un solo tallo, sanas y buenas. ");
INSERT INTO spablm_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","He aquí que siete cabezas de grano, delgadas y arruinadas por el viento del este, brotaban tras ellas. ");
INSERT INTO spablm_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Las cabezas de grano delgadas se tragaron las siete espigas sanas y llenas. El faraón se despertó, y he aquí que era un sueño. ");
INSERT INTO spablm_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Por la mañana, su espíritu se turbó y mandó llamar a todos los magos y sabios de Egipto. El Faraón les contó sus sueños, pero no había nadie que pudiera interpretárselos. ");
INSERT INTO spablm_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Entonces el jefe de los coperos habló al Faraón, diciendo: “Hoy me acuerdo de mis faltas. ");
INSERT INTO spablm_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","El faraón se enojó con sus servidores y me puso en custodia en la casa del capitán de la guardia, con el jefe de los panaderos. ");
INSERT INTO spablm_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","En una noche soñamos un sueño, él y yo. Cada uno soñó según la interpretación de su sueño. ");
INSERT INTO spablm_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Estaba allí con nosotros un joven hebreo, sirviente del capitán de la guardia, y se lo contamos, y él nos interpretó nuestros sueños. Él interpretó a cada uno según su sueño. ");
INSERT INTO spablm_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Tal como nos lo interpretó, así fue. Me restituyó en mi cargo, y lo colgó”. ");
INSERT INTO spablm_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Entonces el Faraón envió a llamar a José, y lo sacaron apresuradamente del calabozo. Se afeitó, se cambió de ropa y entró a ver al Faraón. ");
INSERT INTO spablm_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","El faraón dijo a José: “He soñado un sueño, y no hay nadie que pueda interpretarlo. He oído decir de ti que cuando oyes un sueño puedes interpretarlo”. ");
INSERT INTO spablm_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","José respondió al Faraón diciendo: “No está en mí. Dios le dará al Faraón una respuesta de paz”. ");
INSERT INTO spablm_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","El faraón habló a José: “En mi sueño, he aquí que yo estaba al borde del río; ");
INSERT INTO spablm_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","y he aquí que siete reses gordas y lisas subían del río. Se alimentaban en la hierba del pantano; ");
INSERT INTO spablm_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","y he aquí que otras siete reses subían tras ellas, pobres y muy feas y flacas, como nunca vi en toda la tierra de Egipto por su fealdad. ");
INSERT INTO spablm_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Las reses flacas y feas se comieron a las primeras siete reses gordas; ");
INSERT INTO spablm_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","y cuando se las comieron, no se podía saber que se las habían comido, sino que seguían siendo feas, como al principio. Entonces me desperté. ");
INSERT INTO spablm_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Vi en mi sueño, y he aquí que siete cabezas de grano salían de un solo tallo, llenas y buenas; ");
INSERT INTO spablm_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","y he aquí que siete cabezas de grano, marchitas, flacas y arrasadas por el viento del este, salían detrás de ellas. ");
INSERT INTO spablm_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Las cabezas de grano flacas se tragaron a las siete cabezas de grano buenas. Se lo conté a los magos, pero no hubo nadie que pudiera explicármelo”. ");
INSERT INTO spablm_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","José dijo al Faraón: “El sueño del Faraón es uno. Lo que Dios va a hacer se lo ha declarado al Faraón. ");
INSERT INTO spablm_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Las siete reses buenas son siete años, y las siete cabezas de grano buenas son siete años. El sueño es uno. ");
INSERT INTO spablm_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Las siete reses flacas y feas que subieron después de ellas son siete años, y también las siete cabezas de grano vacías que fueron destruidas por el viento del este; serán siete años de hambre. ");
INSERT INTO spablm_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Esto es lo que le he dicho al Faraón. Dios ha mostrado al Faraón lo que va a hacer. ");
INSERT INTO spablm_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","He aquí que vienen siete años de gran abundancia en toda la tierra de Egipto. ");
INSERT INTO spablm_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Después de ellos vendrán siete años de hambre, y toda la abundancia será olvidada en la tierra de Egipto. El hambre consumirá la tierra, ");
INSERT INTO spablm_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","y la abundancia no se conocerá en la tierra a causa de esa hambruna que sigue, pues será muy grave. ");
INSERT INTO spablm_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","El sueño se duplicó para el Faraón, porque la cosa está establecida por Dios, y Dios la llevará a cabo en breve. ");
INSERT INTO spablm_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Ahora, pues, busque el Faraón un hombre discreto y sabio, y póngalo sobre la tierra de Egipto. ");
INSERT INTO spablm_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Que el Faraón haga esto, y que designe capataces sobre la tierra, y que recoja la quinta parte de los productos de la tierra de Egipto en los siete años de abundancia. ");
INSERT INTO spablm_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Que recojan todo el alimento de estos años buenos que vienen, y que almacenen el grano bajo la mano del Faraón para la alimentación en las ciudades, y que lo guarden. ");
INSERT INTO spablm_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","El alimento será para abastecer la tierra contra los siete años de hambre que habrá en la tierra de Egipto, para que la tierra no perezca por el hambre.” ");
INSERT INTO spablm_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","La cosa fue buena a los ojos del Faraón y de todos sus siervos. ");
INSERT INTO spablm_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","El faraón dijo a sus siervos: “¿Acaso podemos encontrar a alguien como éste, un hombre en quien esté el Espíritu de Dios?” ");
INSERT INTO spablm_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","El faraón dijo a José: “Porque Dios te ha mostrado todo esto, no hay nadie tan discreto y sabio como tú. ");
INSERT INTO spablm_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Tú estarás al frente de mi casa. Todo mi pueblo será gobernado según tu palabra. Sólo en el trono seré más grande que tú”. ");
INSERT INTO spablm_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","El faraón dijo a José: “He aquí que te he puesto sobre toda la tierra de Egipto”. ");
INSERT INTO spablm_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","El faraón se quitó el anillo de sello de su mano y lo puso en la de José; lo vistió con ropas de lino fino y le puso una cadena de oro al cuello. ");
INSERT INTO spablm_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Lo hizo montar en el segundo carro que tenía. Gritaron ante él: “¡Inclina la rodilla!” Lo puso sobre toda la tierra de Egipto. ");
INSERT INTO spablm_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","El faraón dijo a José: “Yo soy el faraón. Sin ti, nadie levantará la mano ni el pie en toda la tierra de Egipto”. ");
INSERT INTO spablm_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","El faraón llamó a José Zafnat-Panea. Le dio por esposa a Asenat, hija de Potifera, sacerdote de On. José salió a recorrer la tierra de Egipto. ");
INSERT INTO spablm_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","José tenía treinta años cuando se presentó ante el Faraón, rey de Egipto. José salió de la presencia del Faraón y recorrió toda la tierra de Egipto. ");
INSERT INTO spablm_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","En los siete años de abundancia, la tierra produjo en abundancia. ");
INSERT INTO spablm_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Recogió toda la comida de los siete años que había en la tierra de Egipto, y guardó la comida en las ciudades. En cada ciudad almacenó alimentos de los campos que rodeaban la ciudad. ");
INSERT INTO spablm_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","José acumuló grano como la arena del mar, mucho, hasta que dejó de contarlo, porque no tenía número. ");
INSERT INTO spablm_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","A José le nacieron dos hijos antes de que llegara el año del hambre, que le dio a luz Asenat, hija de Potifera, sacerdote de On. ");
INSERT INTO spablm_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","José llamó al primogénito Manasés, “Porque”, dijo, “Dios me ha hecho olvidar todo mi trabajo y toda la casa de mi padre.” ");
INSERT INTO spablm_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","El nombre del segundo, lo llamó Efraín: “Porque Dios me ha hecho fructificar en la tierra de mi aflicción.” ");
INSERT INTO spablm_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Los siete años de abundancia que hubo en la tierra de Egipto llegaron a su fin. ");
INSERT INTO spablm_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Comenzaron a llegar los siete años de hambre, tal como había dicho José. Hubo hambre en todas las tierras, pero en toda la tierra de Egipto hubo pan. ");
INSERT INTO spablm_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Cuando toda la tierra de Egipto estaba hambrienta, el pueblo clamó al Faraón por pan, y el Faraón dijo a todos los egipcios: “Vayan a José. Haced lo que él os diga”. ");
INSERT INTO spablm_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","El hambre se extendía por toda la superficie de la tierra. José abrió todos los almacenes y vendió a los egipcios. El hambre era grave en la tierra de Egipto. ");
INSERT INTO spablm_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Todos los países vinieron a Egipto, a José, para comprar grano, porque el hambre era grave en toda la tierra. ");
INSERT INTO spablm_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Vio Jacob que había grano en Egipto, y dijo a sus hijos: “¿Por qué os miráis unos a otros?”. ");
INSERT INTO spablm_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Dijo: “He aquí, he oído que hay grano en Egipto. Bajad allí y comprad para nosotros de allí, para que vivamos y no muramos”. ");
INSERT INTO spablm_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Los diez hermanos de José bajaron a comprar grano a Egipto. ");
INSERT INTO spablm_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Pero Jacob no envió a Benjamín, el hermano de José, con sus hermanos, porque dijo: “No sea que le pase algo malo.” ");
INSERT INTO spablm_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Los hijos de Israel fueron a comprar entre los que venían, porque había hambre en la tierra de Canaán. ");
INSERT INTO spablm_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","José era el gobernador de la tierra. Era él quien vendía a todo el pueblo de la tierra. Vinieron los hermanos de José y se inclinaron ante él con el rostro hacia la tierra. ");
INSERT INTO spablm_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","José vio a sus hermanos y los reconoció, pero se comportó con ellos como un extraño y les habló con rudeza. Les dijo: “¿De dónde venís?”. Dijeron: “De la tierra de Canaán, para comprar comida”. ");
INSERT INTO spablm_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","José reconoció a sus hermanos, pero ellos no lo reconocieron a él. ");
INSERT INTO spablm_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","José se acordó de los sueños que había soñado con ellos y les dijo: “¡Sois espías! Habéis venido a ver la desnudez de la tierra”. ");
INSERT INTO spablm_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Le dijeron: “No, mi señor, pero tus siervos han venido a comprar comida. ");
INSERT INTO spablm_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Todos somos hijos de un hombre; somos hombres honrados. Tus siervos no son espías”. ");
INSERT INTO spablm_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Les dijo: “¡No, pero habéis venido a ver la desnudez de la tierra!” ");
INSERT INTO spablm_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ellos dijeron: “Nosotros, tus siervos, somos doce hermanos, hijos de un solo hombre en la tierra de Canaán; y he aquí que el menor está hoy con nuestro padre, y uno ya no está.” ");
INSERT INTO spablm_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","José les dijo: “Es como les dije, diciendo: ‘Ustedes son espías’. ");
INSERT INTO spablm_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Por esto seréis probados. Por la vida del Faraón, no saldréis de aquí, a menos que venga vuestro hermano menor. ");
INSERT INTO spablm_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Enviad a uno de vosotros y que traiga a vuestro hermano, y seréis atados, para que se compruebe si vuestras palabras son verdaderas, o si por la vida del faraón ciertamente sois espías.” ");
INSERT INTO spablm_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Los puso a todos juntos en custodia durante tres días. ");
INSERT INTO spablm_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Al tercer día, José les dijo: “Haced esto y vivid, porque temo a Dios. ");
INSERT INTO spablm_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Si sois hombres honrados, dejad que uno de vuestros hermanos sea atado en vuestra prisión; pero vosotros id, llevad grano para el hambre de vuestras casas. ");
INSERT INTO spablm_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Traedme a vuestro hermano menor; así se verificarán vuestras palabras y no moriréis.” Así lo hicieron. ");
INSERT INTO spablm_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Se dijeron unos a otros: “Ciertamente somos culpables respecto a nuestro hermano, ya que vimos la angustia de su alma, cuando nos suplicó, y no quisimos escucharlo. Por eso nos ha sobrevenido esta angustia”. ");
INSERT INTO spablm_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Rubén les respondió: “¿No os dije que no pecarais contra el niño, y no quisisteis escuchar? Por eso también, he aquí que se requiere su sangre”. ");
INSERT INTO spablm_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Ellos no sabían que José los entendía, pues había un intérprete entre ellos. ");
INSERT INTO spablm_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Se apartó de ellos y lloró. Luego volvió a ellos y les habló, y tomó a Simeón de entre ellos y lo ató ante sus ojos. ");
INSERT INTO spablm_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Entonces José dio la orden de llenar sus sacos de grano, y de devolver a cada uno su dinero en su saco, y de darles comida para el camino. Así se hizo con ellos. ");
INSERT INTO spablm_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Cargaron sus asnos con el grano y se fueron de allí. ");
INSERT INTO spablm_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Cuando uno de ellos abrió su saco para dar de comer a su asno en el lugar de alojamiento, vio su dinero. Estaba en la boca de su saco. ");
INSERT INTO spablm_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Dijo a sus hermanos: “¡Mi dinero se ha recuperado! He aquí que está en mi saco”. Les falló el corazón, y se volvieron temblando unos a otros, diciendo: “¿Qué es esto que Dios ha hecho con nosotros?” ");
INSERT INTO spablm_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Vinieron a Jacob, su padre, a la tierra de Canaán, y le contaron todo lo que les había sucedido, diciendo: ");
INSERT INTO spablm_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“El hombre, el señor de la tierra, habló con nosotros con aspereza y nos tomó por espías del país. ");
INSERT INTO spablm_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Nosotros le dijimos: ‘Somos hombres honestos. No somos espías. ");
INSERT INTO spablm_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Somos doce hermanos, hijos de nuestro padre; uno ya no existe, y el más joven está hoy con nuestro padre en la tierra de Canaán.’ ");
INSERT INTO spablm_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","El hombre, el señor de la tierra, nos dijo: ‘Por esto sabré que sois hombres honrados: dejad conmigo a uno de vuestros hermanos, tomad grano para el hambre de vuestras casas y seguid vuestro camino. ");
INSERT INTO spablm_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Traedme a vuestro hermano menor. Entonces sabré que no sois espías, sino que sois hombres honrados. Así te entregaré a tu hermano, y comerciarás en la tierra”. ");
INSERT INTO spablm_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Cuando vaciaron sus sacos, he aquí que el fajo de dinero de cada uno estaba en su saco. Cuando ellos y su padre vieron sus fajos de dinero, se asustaron. ");
INSERT INTO spablm_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Jacob, su padre, les dijo: “¡Me habéis privado de mis hijos! Ya no está José, ya no está Simeón, y queréis llevaros a Benjamín. Todo esto es contra mí”. ");
INSERT INTO spablm_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Rubén habló a su padre diciendo: “Mata a mis dos hijos si no te lo traigo. Confíalo a mi cuidado, y te lo traeré de nuevo”. ");
INSERT INTO spablm_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Dijo: “Mi hijo no bajará con vosotros, pues su hermano ha muerto y sólo queda él. Si le ocurre algún daño en el camino por el que vas, entonces harás descender mis canas con dolor al Seol”. ");
INSERT INTO spablm_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","El hambre era severa en la tierra. ");
INSERT INTO spablm_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Cuando se consumió el grano que habían sacado de Egipto, su padre les dijo: “Volved a comprarnos un poco más de comida”. ");
INSERT INTO spablm_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Judá le habló diciendo: “El hombre nos advirtió solemnemente, diciendo: ‘No veréis mi rostro, a menos que vuestro hermano esté con vosotros’. ");
INSERT INTO spablm_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Si envías a nuestro hermano con nosotros, bajaremos a comprarte comida; ");
INSERT INTO spablm_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","pero si no lo envías, no bajaremos, porque el hombre nos dijo: ‘No veréis mi rostro, a menos que vuestro hermano esté con vosotros’”. ");
INSERT INTO spablm_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Israel dijo: “¿Por qué me trataste tan mal, diciéndole al hombre que tenías otro hermano?” ");
INSERT INTO spablm_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Dijeron: “El hombre preguntó directamente por nosotros y por nuestros parientes, diciendo: ‘¿Vive aún tu padre? ¿Tenéis otro hermano? Nos limitamos a responder a sus preguntas. ¿Acaso podíamos saber que iba a decir: ‘Bajad a vuestro hermano’?” ");
INSERT INTO spablm_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Judá dijo a Israel, su padre: “Envía al muchacho conmigo, y nos levantaremos y nos iremos, para que vivamos y no muramos, tanto nosotros como tú, y también nuestros pequeños. ");
INSERT INTO spablm_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Yo seré la garantía para él. De mi mano lo requerirás. Si no te lo traigo, y lo pongo delante de ti, entonces déjame cargar con la culpa para siempre; ");
INSERT INTO spablm_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","porque si no nos hubiéramos demorado, seguramente ya habríamos regresado por segunda vez.” ");
INSERT INTO spablm_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Su padre, Israel, les dijo: “Si ha de ser así, haced esto: Tomad de los frutos selectos de la tierra en vuestros sacos, y bajad un regalo para el hombre, un poco de bálsamo, un poco de miel, especias y mirra, nueces y almendras; ");
INSERT INTO spablm_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","y tomad el doble de dinero en vuestra mano, y llevad el dinero que se os devolvió en la boca de vuestros sacos. Tal vez fue un descuido. ");
INSERT INTO spablm_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Toma también a tu hermano, levántate y vuelve con él. ");
INSERT INTO spablm_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Que el Dios Todopoderoso te dé misericordia ante el hombre, para que te libere a tu otro hermano y a Benjamín. Si estoy desprovisto de mis hijos, estoy desprovisto”. ");
INSERT INTO spablm_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Los hombres aceptaron ese regalo, y tomaron el doble de dinero en su mano, y a Benjamín; se levantaron, bajaron a Egipto y se presentaron ante José. ");
INSERT INTO spablm_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Cuando José vio a Benjamín con ellos, le dijo al mayordomo de su casa: “Lleva a los hombres a la casa, descuartiza un animal y prepárate, porque los hombres cenarán conmigo al mediodía.” ");
INSERT INTO spablm_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","El hombre hizo lo que José le ordenó, y llevó a los hombres a la casa de José. ");
INSERT INTO spablm_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Los hombres tuvieron miedo de que los llevaran a la casa de José, y dijeron: “Por el dinero que se devolvió en nuestros sacos la primera vez, nos han traído, para que busque ocasión contra nosotros, nos ataque y nos tome como esclavos, junto con nuestros asnos.” ");
INSERT INTO spablm_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Se acercaron al mayordomo de la casa de José, y le hablaron a la puerta de la casa, ");
INSERT INTO spablm_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","y le dijeron: “Oh, señor mío, la primera vez bajamos a comprar comida. ");
INSERT INTO spablm_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Cuando llegamos al lugar de alojamiento, abrimos nuestros sacos, y he aquí que el dinero de cada uno estaba en la boca de su saco, nuestro dinero en su totalidad. Lo hemos traído en nuestra mano. ");
INSERT INTO spablm_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Hemos bajado otro dinero en nuestra mano para comprar comida. No sabemos quién puso nuestro dinero en nuestros sacos”. ");
INSERT INTO spablm_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Dijo: “La paz sea con vosotros. No tengáis miedo. Tu Dios, y el Dios de tu padre, te ha dado un tesoro en tus sacos. He recibido vuestro dinero”. Hizo salir a Simeón hacia ellos. ");
INSERT INTO spablm_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","El hombre llevó a los hombres a la casa de José, les dio agua y les lavó los pies. Les dio forraje a sus burros. ");
INSERT INTO spablm_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Prepararon el regalo para la llegada de José al mediodía, pues se enteraron de que debían comer pan allí. ");
INSERT INTO spablm_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Cuando José volvió a casa, le llevaron el regalo que tenían en la mano a la casa, y se postraron en tierra ante él. ");
INSERT INTO spablm_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Él les preguntó por su bienestar y les dijo: “¿Está bien vuestro padre, el anciano del que habéis hablado? ¿Aún vive?” ");
INSERT INTO spablm_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ellos dijeron: “Tu siervo, nuestro padre, está bien. Todavía está vivo”. Se inclinaron humildemente. ");
INSERT INTO spablm_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Él levantó los ojos y vio a Benjamín, su hermano, hijo de su madre, y dijo: “¿Es éste tu hermano menor, del que me hablaste?” Y él respondió: “Que Dios se apiade de ti, hijo mío”. ");
INSERT INTO spablm_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","José se apresuró, pues su corazón anhelaba a su hermano, y buscó un lugar para llorar. Entró en su habitación y lloró allí. ");
INSERT INTO spablm_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Se lavó la cara y salió. Se controló y dijo: “Sirve la comida”. ");
INSERT INTO spablm_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Le servían a él solo, y a ellos solos, y a los egipcios que comían con él solos, porque los egipcios no comen con los hebreos, pues eso es una abominación para los egipcios. ");
INSERT INTO spablm_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Se sentaron delante de él, el primogénito según su primogenitura y el menor según su juventud, y los hombres se maravillaron entre sí. ");
INSERT INTO spablm_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Les mandó porciones de delante, pero la porción de Benjamín fue cinco veces mayor que la de cualquiera de ellos. Bebieron y se alegraron con él. ");
INSERT INTO spablm_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Mandó al administrador de su casa, diciendo: “Llena los sacos de los hombres con comida, toda la que puedan llevar, y pon el dinero de cada uno en la boca de su saco. ");
INSERT INTO spablm_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Pon mi copa, la copa de plata, en la boca del saco del más joven, con su dinero del grano”. Él hizo conforme a la palabra que José había dicho. ");
INSERT INTO spablm_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Tan pronto como amaneció, los hombres fueron despedidos, ellos y sus asnos. ");
INSERT INTO spablm_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Cuando salieron de la ciudad y aún no estaban lejos, José dijo a su mayordomo: “Arriba, sigue a los hombres. Cuando los alcances, pregúntales: ‘¿Por qué habéis premiado el mal con el bien? ");
INSERT INTO spablm_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","¿No es esto de lo que bebe mi señor, y por lo que en verdad adivina? Habéis hecho el mal al hacerlo’”. ");
INSERT INTO spablm_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Los alcanzó y les dijo estas palabras. ");
INSERT INTO spablm_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Le dijeron: “¿Por qué habla mi señor tales palabras? ¡Lejos están tus siervos de hacer tal cosa! ");
INSERT INTO spablm_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","He aquí, el dinero que encontramos en la boca de nuestros sacos, te lo trajimos de la tierra de Canaán. ¿Cómo, pues, habríamos de robar plata u oro de la casa de tu señor? ");
INSERT INTO spablm_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Con cualquiera de tus siervos que se encuentre, que muera, y nosotros también seremos esclavos de mi señor”. ");
INSERT INTO spablm_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Dijo: “Ahora también sea según tus palabras. Aquel con quien se encuentre será mi esclavo; y tú serás irreprochable”. ");
INSERT INTO spablm_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Entonces se apresuraron, y cada uno bajó su saco al suelo, y cada uno abrió su saco. ");
INSERT INTO spablm_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Buscó, comenzando por el más viejo y terminando por el más joven. La copa se encontró en el saco de Benjamín. ");
INSERT INTO spablm_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Luego se rasgaron las vestiduras, y cada uno cargó su asno, y regresaron a la ciudad. ");
INSERT INTO spablm_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Judá y sus hermanos llegaron a la casa de José, y éste todavía estaba allí. Se postraron en el suelo ante él. ");
INSERT INTO spablm_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","José les dijo: “¿Qué obra es ésta que habéis hecho? ¿No sabéis que un hombre como yo sí puede hacer adivinación?” ");
INSERT INTO spablm_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Judá dijo: “¿Qué le diremos a mi señor? ¿Qué vamos a decir? ¿Cómo nos exculparemos? Dios ha descubierto la iniquidad de tus siervos. He aquí que somos esclavos de mi señor, tanto nosotros como aquel en cuya mano se encuentra la copa”. ");
INSERT INTO spablm_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Él dijo: “Lejos de mí el hacerlo. El hombre en cuya mano se encuentre la copa, será mi esclavo; pero en cuanto a ti, sube en paz a tu padre.” ");
INSERT INTO spablm_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Entonces Judá se acercó a él y le dijo: “Oh, señor mío, por favor, deja que tu siervo hable una palabra en los oídos de mi señor, y no dejes que tu ira arda contra tu siervo, porque eres como Faraón. ");
INSERT INTO spablm_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Mi señor preguntó a sus siervos, diciendo: “¿Tenéis padre o hermano?” ");
INSERT INTO spablm_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Dijimos a mi señor: “Tenemos un padre, un anciano, y un hijo de su edad, un pequeño; y su hermano ha muerto, y sólo queda él de su madre; y su padre lo quiere. ");
INSERT INTO spablm_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Dijiste a tus siervos: ‘Tráiganlo a mí, para que ponga mis ojos en él’. ");
INSERT INTO spablm_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Dijimos a mi señor: ‘El muchacho no puede dejar a su padre, pues si lo dejara, su padre moriría’. ");
INSERT INTO spablm_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Dijiste a tus siervos: Si tu hermano menor no baja contigo, no verás más mi rostro’. ");
INSERT INTO spablm_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Cuando subimos donde tu siervo mi padre, le contamos las palabras de mi señor. ");
INSERT INTO spablm_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Nuestro padre dijo: ‘Vuelve a comprarnos un poco de comida’. ");
INSERT INTO spablm_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Nosotros dijimos: ‘No podemos bajar. Si nuestro hermano menor está con nosotros, entonces bajaremos; porque no podremos ver el rostro del hombre, a menos que nuestro hermano menor esté con nosotros.’ ");
INSERT INTO spablm_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Tu siervo, mi padre, nos dijo: ‘Ustedes saben que mi esposa me dio dos hijos. ");
INSERT INTO spablm_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Uno salió de mí, y dije: “Seguramente está despedazado”; y no lo he vuelto a ver. ");
INSERT INTO spablm_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Si me quitan a éste también, y le sucede algún daño, harán descender mis canas con dolor al Seol.’ ");
INSERT INTO spablm_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Ahora, pues, cuando vaya a ver a tu siervo mi padre, y el muchacho no esté con nosotros, ya que su vida está ligada a la del muchacho, ");
INSERT INTO spablm_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","sucederá que cuando vea que el muchacho ya no está, morirá. Tus siervos harán descender las canas de tu siervo, nuestro padre, con dolor al Seol. ");
INSERT INTO spablm_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Porque tu siervo se hizo responsable del muchacho ante mi padre, diciendo: ‘Si no te lo traigo, entonces cargaré con la culpa ante mi padre para siempre’. ");
INSERT INTO spablm_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Ahora, pues, por favor, deja que tu siervo se quede en lugar del muchacho, el esclavo de mi señor; y deja que el muchacho suba con sus hermanos. ");
INSERT INTO spablm_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Porque ¿cómo voy a subir a mi padre si el muchacho no está conmigo? para que no vea el mal que le sobrevendrá a mi padre”. ");
INSERT INTO spablm_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Entonces José no pudo controlarse ante todos los que estaban frente a él, y gritó: “¡Que todos salgan de mí!”. Nadie más estaba con él, mientras José se daba a conocer a sus hermanos. ");
INSERT INTO spablm_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Lloró en voz alta. Los egipcios lo oyeron, y la casa del faraón también. ");
INSERT INTO spablm_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","José dijo a sus hermanos: “¡Yo soy José! ¿Vive aún mi padre?” Sus hermanos no pudieron responderle, pues estaban aterrados ante su presencia. ");
INSERT INTO spablm_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","José dijo a sus hermanos: “Acérquense a mí, por favor”. Se acercaron. Él les dijo: “Yo soy José, vuestro hermano, a quien vendisteis a Egipto. ");
INSERT INTO spablm_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","No os entristezcáis ni os enfadéis por haberme vendido aquí, pues Dios me ha enviado delante de vosotros para preservar la vida. ");
INSERT INTO spablm_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Durante estos dos años el hambre ha estado en la tierra, y aún quedan cinco años, en los que no habrá arado ni cosecha. ");
INSERT INTO spablm_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Dios me envió delante de vosotros para preservar para vosotros un remanente en la tierra, y para salvarte con vida mediante una gran liberación. ");
INSERT INTO spablm_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Así que ahora no fuisteis vosotros quien me envió aquí, sino Dios, y él me ha hecho padre del Faraón, señor de toda su casa y gobernante de toda la tierra de Egipto. ");
INSERT INTO spablm_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Date prisa, sube a ver a mi padre y dile: “Esto es lo que dice tu hijo José: “Dios me ha hecho señor de todo Egipto. Baja a verme. No esperes. ");
INSERT INTO spablm_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Habitarás en la tierra de Gosén, y estarás cerca de mí, tú, tus hijos, los hijos de tus hijos, tus rebaños, tus manadas y todo lo que tengas. ");
INSERT INTO spablm_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Allí te proveeré, porque todavía hay cinco años de hambre; para que no llegues a la pobreza, tú y tu familia, y todo lo que tienes”’. ");
INSERT INTO spablm_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","He aquí que vuestros ojos ven, y los ojos de mi hermano Benjamín, que es mi boca la que te habla. ");
INSERT INTO spablm_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Contarás a mi padre toda mi gloria en Egipto y todo lo que has visto. Te apresurarás a traer a mi padre aquí”. ");
INSERT INTO spablm_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Se echó al cuello de su hermano Benjamín y lloró, y Benjamín lloró sobre su cuello. ");
INSERT INTO spablm_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Besó a todos sus hermanos y lloró sobre ellos. Después sus hermanos hablaron con él. ");
INSERT INTO spablm_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","La noticia se oyó en la casa del faraón, diciendo: “Han venido los hermanos de José”. Esto agradó al Faraón y a sus siervos. ");
INSERT INTO spablm_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","El faraón le dijo a José: “Dile a tus hermanos que hagan esto: Carguen sus animales y vayan, viajen a la tierra de Canaán. ");
INSERT INTO spablm_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Tomad a vuestro padre y a vuestras familias, y venid a mí, y os daré el bien de la tierra de Egipto, y comeréis la grasa de la tierra.’ ");
INSERT INTO spablm_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Ahora se os ordena hacer esto: Tomad carros de la tierra de Egipto para vuestros pequeños y para vuestras mujeres, y traed a vuestro padre, y venid. ");
INSERT INTO spablm_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Además, no os preocupéis por vuestras pertenencias, porque el bien de toda la tierra de Egipto es vuestro.” ");
INSERT INTO spablm_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Así lo hicieron los hijos de Israel. José les dio carros, según el mandato del faraón, y les dio provisiones para el camino. ");
INSERT INTO spablm_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","A cada uno de ellos le dio mudas de ropa, pero a Benjamín le dio trescientas piezas de plata y cinco mudas de ropa. ");
INSERT INTO spablm_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Envió a su padre lo siguiente: diez burros cargados con los bienes de Egipto, y diez burras cargadas de grano y pan y provisiones para su padre en el camino. ");
INSERT INTO spablm_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Entonces despidió a sus hermanos y se fueron. Les dijo: “Mirad que no os peleéis por el camino”. ");
INSERT INTO spablm_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Subieron de Egipto y llegaron a la tierra de Canaán, donde su padre Jacob. ");
INSERT INTO spablm_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Le contaron, diciendo: “José aún vive, y es soberano de toda la tierra de Egipto”. Su corazón se desmayó, pues no les creyó. ");
INSERT INTO spablm_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Le contaron todas las palabras de José que él les había dicho. Cuando vio los carros que José había enviado para llevarlo, el espíritu de Jacob, su padre, revivió. ");
INSERT INTO spablm_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Israel dijo: “Es suficiente. José, mi hijo, sigue vivo. Iré a verlo antes de morir”. ");
INSERT INTO spablm_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Israel viajó con todo lo que tenía, llegó a Beerseba y ofreció sacrificios al Dios de su padre, Isaac. ");
INSERT INTO spablm_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Dios habló a Israel en las visiones de la noche, y dijo: “¡Jacob, Jacob!” Dijo: “Aquí estoy”. ");
INSERT INTO spablm_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Dijo: “Yo soy Dios, el Dios de tu padre. No tengas miedo de bajar a Egipto, porque allí haré de ti una gran nación. ");
INSERT INTO spablm_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Yo bajaré contigo a Egipto. También te haré subir con toda seguridad. La mano de José cerrará tus ojos”. ");
INSERT INTO spablm_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Jacob se levantó de Beerseba, y los hijos de Israel llevaron a Jacob, a su padre, a sus hijos y a sus mujeres, en los carros que el faraón había enviado para transportarlo. ");
INSERT INTO spablm_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Tomaron su ganado y sus bienes, que habían adquirido en la tierra de Canaán, y entraron en Egipto: Jacob, y toda su descendencia con él, ");
INSERT INTO spablm_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","sus hijos, y los hijos de sus hijos con él, sus hijas y las hijas de sus hijos, y llevó toda su descendencia con él a Egipto. ");
INSERT INTO spablm_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Estos son los nombres de los hijos de Israel que entraron en Egipto, Jacob y sus hijos: Rubén, primogénito de Jacob. ");
INSERT INTO spablm_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Los hijos de Rubén: Hanoc, Falu, Esrom y Carmi.. ");
INSERT INTO spablm_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Los hijos de Simeón: Jemuel, Jamín, Ohad, Jaquin, Zohar y Saul, hijo de una cananea. ");
INSERT INTO spablm_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Los hijos de Leví: Gersón, Coat y Merari. ");
INSERT INTO spablm_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Los hijos de Judá: Er, Onán, Sala, Fares y Zéraj; pero Er y Onán murieron en la tierra de Canaán. Los hijos de Fares fueron Esrom y Hamul. ");
INSERT INTO spablm_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Los hijos de Isacar: Tola, Puvah, Iob y Shimron. ");
INSERT INTO spablm_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Los hijos de Zabulón: Sered, Elón y Jahleel. ");
INSERT INTO spablm_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Estos son los hijos de Lea, que dio a luz a Jacob en Padan Aram, además de su hija Dina. Todas las almas de sus hijos e hijas fueron treinta y tres. ");
INSERT INTO spablm_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Los hijos de Gad: Zifón, Haggi, Suni, Ezbón, Eri, Arodi y Areli. ");
INSERT INTO spablm_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Los hijos de Aser: Imna, Ishva, Ishvi, Beriá y su hermana Sera. Los hijos de Beriá: Heber y Malquiel. ");
INSERT INTO spablm_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Estos son los hijos de Zilpá, que Labán dio a su hija Lea, y que ella dio a luz a Jacob, dieciséis almas. ");
INSERT INTO spablm_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Los hijos de Raquel, mujer de Jacob José y Benjamín. ");
INSERT INTO spablm_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","A José le nacieron en la tierra de Egipto Manasés y Efraín, que le dio a luz Asenat, hija de Potifera, sacerdote de On. ");
INSERT INTO spablm_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Los hijos de Benjamín: Bela, Bequer, Asbel, Gera, Naamán, Ehi, Ros, Mupim, Hupim y Ard. ");
INSERT INTO spablm_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Estos son los hijos de Raquel que le nacieron a Jacob: todos fueron catorce. ");
INSERT INTO spablm_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","El hijo de Dan: Hushim. ");
INSERT INTO spablm_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Los hijos de Neftalí: Jahzeel, Guni, Jezer y Silem. ");
INSERT INTO spablm_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Estos son los hijos de Bilhá, que Labán dio a su hija Raquel, y éstos fueron los que ella dio a luz a Jacob: todas las almas fueron siete. ");
INSERT INTO spablm_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Todas las almas que vinieron con Jacob a Egipto, que fueron su descendencia directa, además de las mujeres de los hijos de Jacob, todas las almas fueron sesenta y seis. ");
INSERT INTO spablm_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Los hijos de José, que le nacieron en Egipto, fueron dos almas. Todas las almas de la casa de Jacob, que llegaron a Egipto, fueron setenta. ");
INSERT INTO spablm_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Jacob envió a Judá delante de José para que le mostrara el camino a Gosén, y llegaron a la tierra de Gosén. ");
INSERT INTO spablm_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","José preparó su carro y subió a recibir a Israel, su padre, en Gosén. Se presentó ante él, y se echó sobre su cuello, y lloró sobre su cuello un buen rato. ");
INSERT INTO spablm_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Israel dijo a José: “Ahora déjame morir, ya que he visto tu rostro, que aún estás vivo”. ");
INSERT INTO spablm_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","José dijo a sus hermanos y a la casa de su padre: “Subiré y hablaré con el Faraón y le diré: ‘Mis hermanos y la casa de mi padre, que estaban en la tierra de Canaán, han venido a mí. ");
INSERT INTO spablm_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Estos hombres son pastores, pues han sido cuidadores de ganado, y han traído sus rebaños, sus manadas y todo lo que tienen.’ ");
INSERT INTO spablm_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Sucederá que cuando el Faraón os llame y os diga: “¿A qué os dedicáis? ");
INSERT INTO spablm_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","que diréis: ‘Tus siervos han sido cuidadores de ganado desde nuestra juventud hasta ahora, tanto nosotros como nuestros padres’, para que podáis habitar en la tierra de Gosén; porque todo pastor es una abominación para los egipcios.” ");
INSERT INTO spablm_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Entonces José entró y dio cuenta al Faraón, diciendo: “Mi padre y mis hermanos, con sus rebaños, sus manadas y todo lo que poseen, han salido de la tierra de Canaán; y he aquí que están en la tierra de Gosén.” ");
INSERT INTO spablm_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","De entre sus hermanos tomó cinco hombres y los presentó al Faraón. ");
INSERT INTO spablm_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","El faraón dijo a sus hermanos: “¿A qué os dedicáis?” Dijeron al Faraón: “Tus siervos son pastores, tanto nosotros como nuestros padres”. ");
INSERT INTO spablm_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","También dijeron al Faraón: “Hemos venido a vivir como extranjeros en la tierra, porque no hay pastos para los rebaños de tus siervos. Porque el hambre es grave en la tierra de Canaán. Ahora, pues, por favor, deja que tus siervos habiten en la tierra de Gosén”. ");
INSERT INTO spablm_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","El faraón habló a José, diciendo: “Tu padre y tus hermanos han venido a ti. ");
INSERT INTO spablm_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","La tierra de Egipto está ante ti. Haz que tu padre y tus hermanos habiten en lo mejor de la tierra. Que habiten en la tierra de Gosén. Si conoces a algún hombre capaz entre ellos, ponlo a cargo de mi ganado”. ");
INSERT INTO spablm_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","José hizo entrar a Jacob, su padre, y lo presentó ante el Faraón; y Jacob bendijo al Faraón. ");
INSERT INTO spablm_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","El faraón dijo a Jacob: “¿Cuántos años tienes?” ");
INSERT INTO spablm_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Jacob dijo al Faraón: “Los años de mi peregrinación son ciento treinta años. Los días de los años de mi vida han sido pocos y malos. No han llegado a los días de los años de la vida de mis padres en los días de su peregrinación”. ");
INSERT INTO spablm_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Jacob bendijo al faraón y salió de la presencia del faraón. ");
INSERT INTO spablm_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","José colocó a su padre y a sus hermanos, y les dio una posesión en la tierra de Egipto, en lo mejor de la tierra, en la tierra de Ramsés, como lo había ordenado el Faraón. ");
INSERT INTO spablm_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","José proveyó de pan a su padre, a sus hermanos y a toda la familia de su padre, según el tamaño de sus familias. ");
INSERT INTO spablm_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","No había pan en toda la tierra, pues el hambre era muy severa, de modo que la tierra de Egipto y la tierra de Canaán desfallecían a causa del hambre. ");
INSERT INTO spablm_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","José reunió todo el dinero que se encontró en la tierra de Egipto y en la tierra de Canaán, por el grano que compraron; y José llevó el dinero a la casa del Faraón. ");
INSERT INTO spablm_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Cuando se gastó todo el dinero en la tierra de Egipto y en la tierra de Canaán, todos los egipcios se acercaron a José y le dijeron: “Danos pan, pues ¿para qué vamos a morir en tu presencia? Porque nuestro dinero se agota”. ");
INSERT INTO spablm_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","José dijo: “Dame tu ganado, y yo te daré comida para tu ganado, si se acaba tu dinero”. ");
INSERT INTO spablm_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Trajeron sus ganados a José, y éste les dio pan a cambio de los caballos, de los rebaños y de los asnos, y los alimentó con pan a cambio de todos sus ganados de aquel año. ");
INSERT INTO spablm_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Terminado aquel año, vinieron a él el segundo año y le dijeron: “No vamos a ocultar a mi señor que todo nuestro dinero se ha gastado, y que los rebaños son de mi señor. No queda nada a la vista de mi señor, sino nuestros cuerpos y nuestras tierras. ");
INSERT INTO spablm_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","¿Por qué hemos de morir ante sus ojos, nosotros y nuestras tierras? Cómpranos a nosotros y a nuestra tierra a cambio de pan, y nosotros y nuestra tierra seremos siervos del faraón. Danos semilla, para que vivamos y no muramos, y para que la tierra no quede desolada”. ");
INSERT INTO spablm_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Así que José compró toda la tierra de Egipto para el Faraón, pues cada hombre de los egipcios vendió su campo, porque la hambruna se agravó sobre ellos, y la tierra pasó a ser del Faraón. ");
INSERT INTO spablm_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","En cuanto al pueblo, lo trasladó a las ciudades desde un extremo de la frontera de Egipto hasta el otro. ");
INSERT INTO spablm_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Sólo que no compró la tierra de los sacerdotes, porque los sacerdotes tenían una porción del Faraón y comían su porción que el Faraón les daba. Por eso no vendieron sus tierras. ");
INSERT INTO spablm_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Entonces José dijo al pueblo: “Miren, hoy les he comprado a ustedes y a sus tierras para el Faraón. He aquí que hay semilla para ustedes, y ustedes sembrarán la tierra. ");
INSERT INTO spablm_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Sucederá que en las cosechas daréis una quinta parte al Faraón, y cuatro partes serán vuestras, para semilla del campo, para vuestro alimento, para los de vuestras casas y para el alimento de vuestros hijos.” ");
INSERT INTO spablm_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Dijeron: “¡Nos has salvado la vida! Hallemos el favor a los ojos de mi señor, y seremos siervos del Faraón”. ");
INSERT INTO spablm_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","José hizo un estatuto sobre la tierra de Egipto hasta el día de hoy, para que el Faraón tuviera el quinto. Sólo la tierra de los sacerdotes no pasó a ser del Faraón. ");
INSERT INTO spablm_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Israel vivió en la tierra de Egipto, en la tierra de Gosén, y se apropió de ella, y fructificó y se multiplicó en gran manera. ");
INSERT INTO spablm_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jacob vivió en la tierra de Egipto diecisiete años. Así que los días de Jacob, los años de su vida, fueron ciento cuarenta y siete años. ");
INSERT INTO spablm_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Se acercó el momento en que Israel debía morir, y llamó a su hijo José, y le dijo: “Si ahora he hallado gracia ante tus ojos, por favor, pon tu mano debajo de mi muslo y trátame con bondad y sinceridad. Por favor, no me entierres en Egipto, ");
INSERT INTO spablm_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","sino que cuando duerma con mis padres, me sacarás de Egipto y me enterrarás en su sepultura.” José dijo: “Haré lo que has dicho”. ");
INSERT INTO spablm_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Israel dijo: “Júrame”, y él le juró. Entonces Israel se inclinó sobre la cabecera de la cama. ");
INSERT INTO spablm_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Después de estas cosas, alguien dijo a José: “He aquí que tu padre está enfermo”. Tomó consigo a sus dos hijos, Manasés y Efraín. ");
INSERT INTO spablm_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Alguien avisó a Jacob y le dijo: “He aquí que tu hijo José viene a ti”, e Israel se fortaleció y se sentó en la cama. ");
INSERT INTO spablm_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Jacob dijo a José: “El Dios Todopoderoso se me apareció en Luz, en la tierra de Canaán, y me bendijo, ");
INSERT INTO spablm_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","y me dijo: ‘He aquí que te haré fructificar y te multiplicaré, y haré de ti una compañía de pueblos, y daré esta tierra a tu descendencia después de ti como posesión eterna’. ");
INSERT INTO spablm_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Tus dos hijos, que te nacieron en la tierra de Egipto antes de que yo viniera a ti a Egipto, son míos; Efraín y Manasés, como Rubén y Simeón, serán míos. ");
INSERT INTO spablm_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Tu descendencia, de la que seas padre después de ellos, será tuya. Se llamarán con el nombre de sus hermanos en su herencia. ");
INSERT INTO spablm_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","En cuanto a mí, cuando vine de Padán Aram, Raquel murió a mi lado en la tierra de Canaán, en el camino, cuando aún faltaba para llegar a Efrat, y la enterré allí en el camino a Efrat (también llamada Belén).” ");
INSERT INTO spablm_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Israel vio a los hijos de José y dijo: “¿Quiénes son estos?” ");
INSERT INTO spablm_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","José dijo a su padre: “Son mis hijos, que Dios me ha dado aquí”. Dijo: “Por favor, tráemelos, y los bendeciré”. ");
INSERT INTO spablm_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Ahora bien, los ojos de Israel estaban apagados por la edad, de modo que no podía ver bien. José los acercó, los besó y los abrazó. ");
INSERT INTO spablm_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Israel dijo a José: “No creía que fuera a ver tu rostro, y he aquí que Dios me ha permitido ver también tu descendencia.” ");
INSERT INTO spablm_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","José los sacó de entre sus rodillas y se inclinó con el rostro hacia la tierra. ");
INSERT INTO spablm_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","José tomó a ambos, a Efraín con su mano derecha hacia la mano izquierda de Israel, y a Manasés con su mano izquierda hacia la mano derecha de Israel, y los acercó a él. ");
INSERT INTO spablm_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Israel extendió su mano derecha y la puso sobre la cabeza de Efraín, que era el menor, y su mano izquierda sobre la cabeza de Manasés, guiando sus manos a sabiendas, pues Manasés era el primogénito. ");
INSERT INTO spablm_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Bendijo a José y dijo, “El Dios ante el que caminaron mis padres Abraham e Isaac, el Dios que me ha alimentado durante toda mi vida hasta el día de hoy, ");
INSERT INTO spablm_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","el ángel que me ha redimido de todo mal, bendice a los muchachos, y que mi nombre sea nombrado en ellos, y el nombre de mis padres Abraham e Isaac. Que crezcan en multitud sobre la tierra”. ");
INSERT INTO spablm_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Cuando José vio que su padre ponía su mano derecha sobre la cabeza de Efraín, le disgustó. Levantó la mano de su padre para quitarla de la cabeza de Efraín a la de Manasés. ");
INSERT INTO spablm_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","José dijo a su padre: “No es así, padre mío, porque éste es el primogénito. Pon tu mano derecha sobre su cabeza”. ");
INSERT INTO spablm_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Su padre se negó y dijo: “Lo sé, hijo mío, lo sé. Él también llegará a ser un pueblo, y también será grande. Sin embargo, su hermano menor será más grande que él, y su descendencia llegará a ser una multitud de naciones”. ");
INSERT INTO spablm_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Aquel día los bendijo diciendo: “Israel bendecirá en vosotros, diciendo: “Dios os haga como Efraín y como Manasés”” Puso a Efraín por delante de Manasés. ");
INSERT INTO spablm_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Israel dijo a José: “He aquí que yo muero, pero Dios estará contigo y te hará volver a la tierra de tus padres. ");
INSERT INTO spablm_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Además, te he dado una porción por encima de tus hermanos, que tomé de la mano del amorreo con mi espada y con mi arco.” ");
INSERT INTO spablm_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Jacob llamó a sus hijos y les dijo “Reúnanse, para que les diga lo que les sucederá en los días venideros. ");
INSERT INTO spablm_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Reúnanse y escuchen, hijos de Jacob. Escucha a Israel, tu padre. ");
INSERT INTO spablm_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Rubén, tú eres mi primogénito, mi fuerza y el principio de mi fortaleza, sobresaliendo en dignidad, y sobresaliendo en poder. ");
INSERT INTO spablm_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Hirviendo como el agua, no sobresaldrás, porque subiste a la cama de tu padre, y luego lo profanó. Subió a mi sofá. ");
INSERT INTO spablm_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Simeón y Leví son hermanos. Sus espadas son armas de violencia. ");
INSERT INTO spablm_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Alma mía, no entres en su consejo. Gloria mía, no te unas a su asamblea; porque en su ira mataron a los hombres. En su voluntad propia, han maniatado al ganado. ");
INSERT INTO spablm_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Maldita sea su cólera, porque era feroz; y su ira, pues era cruel. Los dividiré en Jacob, y los dispersaré en Israel. ");
INSERT INTO spablm_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Judá, tus hermanos te alabarán. Tu mano estará en el cuello de tus enemigos. Los hijos de tu padre se inclinarán ante ti. ");
INSERT INTO spablm_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Judá es un cachorro de león. De la presa, hijo mío, has subido. Se agachó, se agazapó como un león, como una leona. ¿Quién lo despertará? ");
INSERT INTO spablm_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","El cetro no se apartará de Judá, ni el bastón de mando de entre sus pies, hasta que llegue a quien le corresponde. La obediencia de los pueblos será a él. ");
INSERT INTO spablm_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Atando su potro a la vid, el potro de su asno a la cepa elegida, ha lavado su ropa en vino, sus ropas en la sangre de las uvas. ");
INSERT INTO spablm_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Sus ojos estarán rojos de vino, sus dientes blancos de leche. ");
INSERT INTO spablm_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Zabulón habitará en el puerto del mar. Será para un puerto de barcos. Su frontera estará en Sidón. ");
INSERT INTO spablm_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Isacar es un asno fuerte, tumbado entre las alforjas. ");
INSERT INTO spablm_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Vio un lugar de descanso, que era bueno, la tierra, que era agradable. Inclina su hombro ante la carga, y se convierte en un siervo haciendo trabajos forzados. ");
INSERT INTO spablm_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Dan juzgará a su pueblo, como una de las tribus de Israel. ");
INSERT INTO spablm_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan será una serpiente en el camino, un sumador en el camino, que muerde los talones del caballo, para que su jinete caiga hacia atrás. ");
INSERT INTO spablm_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","He esperado tu salvación, Yahvé. ");
INSERT INTO spablm_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Una tropa presionará a Gad, pero les presionará el talón. ");
INSERT INTO spablm_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“La comida de Asher será rica. Producirá manjares reales. ");
INSERT INTO spablm_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Neftalí es una cierva liberada, que lleva hermosos cervatillos. ");
INSERT INTO spablm_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“José es una vid fructífera, una vid fructífera junto a un manantial. Sus ramas pasan por encima de la pared. ");
INSERT INTO spablm_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Los arqueros lo han afligido gravemente, le dispararon y le persiguieron: ");
INSERT INTO spablm_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Pero su arco siguió siendo fuerte. Los brazos de sus manos se hicieron fuertes, por las manos del Poderoso de Jacob, (de allí es el pastor, la piedra de Israel), ");
INSERT INTO spablm_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","por el Dios de tu padre, que te ayudará, por el Todopoderoso, que te bendecirá, con las bendiciones del cielo, las bendiciones de las profundidades que se encuentran debajo, bendiciones de los pechos, y del vientre. ");
INSERT INTO spablm_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Las bendiciones de tu padre han prevalecido sobre las de mis antepasados, por encima de los límites de las antiguas colinas. Estarán en la cabeza de José, en la coronilla del que se separa de sus hermanos. ");
INSERT INTO spablm_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Benjamín es un lobo voraz. Por la mañana devorará la presa. Al anochecer repartirá el botín”. ");
INSERT INTO spablm_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Todas estas son las doce tribus de Israel, y esto es lo que su padre les habló y los bendijo. Bendijo a cada uno según su propia bendición. ");
INSERT INTO spablm_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Los instruyó y les dijo: “Voy a ser reunido con mi pueblo. Entiérrenme con mis padres en la cueva que está en el campo de Efrón el hitita, ");
INSERT INTO spablm_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","en la cueva que está en el campo de Macpela, que está delante de Mamre, en la tierra de Canaán, que Abraham compró con el campo de Efrón el hitita como lugar de sepultura. ");
INSERT INTO spablm_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Allí enterraron a Abraham y a Sara, su esposa. Allí enterraron a Isaac y a Rebeca, su mujer, y allí enterré a Lea: ");
INSERT INTO spablm_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","el campo y la cueva que hay en él, que fue comprada a los hijos de Het.” ");
INSERT INTO spablm_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Cuando Jacob terminó de encargar a sus hijos, recogió sus pies en el lecho, exhaló su último aliento y se reunió con su pueblo. ");
INSERT INTO spablm_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","José se postró sobre el rostro de su padre, lloró sobre él y lo besó. ");
INSERT INTO spablm_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","José ordenó a sus servidores, los médicos, que embalsamaran a su padre; y los médicos embalsamaron a Israel. ");
INSERT INTO spablm_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Le dedicaron cuarenta días, pues son los que se necesitan para embalsamar. Los egipcios lloraron a Israel durante setenta días. ");
INSERT INTO spablm_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Cuando pasaron los días de llanto por él, José habló al bastón del faraón, diciendo: “Si ahora he encontrado gracia ante tus ojos, por favor, habla en los oídos del faraón, diciendo: ");
INSERT INTO spablm_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Mi padre me hizo jurar, diciendo: “He aquí que me estoy muriendo. Entiérrame en mi tumba que me he cavado en la tierra de Canaán”. Ahora, pues, te ruego que me dejes subir a enterrar a mi padre, y volveré”. ");
INSERT INTO spablm_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","El faraón dijo: “Sube y entierra a tu padre, como te hizo jurar”. ");
INSERT INTO spablm_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","José subió a enterrar a su padre, y con él subieron todos los servidores del faraón, los ancianos de su casa, todos los ancianos del país de Egipto, ");
INSERT INTO spablm_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","toda la casa de José, sus hermanos y la casa de su padre. Sólo dejaron en la tierra de Gosén a sus pequeños, sus rebaños y sus manadas. ");
INSERT INTO spablm_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Tanto los carros como los jinetes subieron con él. Era una compañía muy grande. ");
INSERT INTO spablm_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Llegaron a la era de Atad, que está al otro lado del Jordán, y allí se lamentaron con un lamento muy grande y severo. Hicieron duelo por su padre durante siete días. ");
INSERT INTO spablm_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Cuando los habitantes de la tierra, los cananeos, vieron el luto en la era de Atad, dijeron: “Este es un luto grave de los egipcios”. Por eso su nombre fue llamado Abel Mizraim, que está al otro lado del Jordán. ");
INSERT INTO spablm_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Sus hijos le hicieron tal como él les había ordenado, ");
INSERT INTO spablm_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","pues sus hijos lo llevaron a la tierra de Canaán y lo enterraron en la cueva del campo de Macpela, que Abraham compró con el campo, como posesión para un lugar de entierro, a Efrón el hitita, cerca de Mamre. ");
INSERT INTO spablm_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","José regresó a Egipto, junto con sus hermanos y todos los que subieron con él para enterrar a su padre, después de haber enterrado a su padre. ");
INSERT INTO spablm_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Cuando los hermanos de José vieron que su padre había muerto, dijeron: “Puede ser que José nos odie y nos pague plenamente todo el mal que le hicimos.” ");
INSERT INTO spablm_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Enviaron un mensaje a José, diciendo: “Tu padre ordenó antes de morir, diciendo: ");
INSERT INTO spablm_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","“Ahora dirás a José: “Por favor, perdona la desobediencia de tus hermanos y su pecado, porque te hicieron mal”. Ahora, por favor, perdona la desobediencia de los siervos del Dios de tu padre”. José lloró cuando le hablaron. ");
INSERT INTO spablm_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Sus hermanos también fueron y se postraron ante su rostro, y dijeron: “He aquí que somos tus siervos”. ");
INSERT INTO spablm_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","José les dijo: “No tengáis miedo, porque ¿estoy en el lugar de Dios? ");
INSERT INTO spablm_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","En cuanto a ustedes, quisieron hacer el mal contra mí, pero Dios lo quiso para el bien, para salvar a mucha gente con vida, como sucede hoy. ");
INSERT INTO spablm_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Ahora, pues, no tengas miedo. Yo los mantendré a ustedes y a sus hijos”. Los consoló y les habló con amabilidad. ");
INSERT INTO spablm_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","José vivió en Egipto, él y la casa de su padre. José vivió ciento diez años. ");
INSERT INTO spablm_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","José vio a los hijos de Efraín hasta la tercera generación. También los hijos de Maquir, hijo de Manasés, nacieron sobre las rodillas de José. ");
INSERT INTO spablm_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","José dijo a sus hermanos: “Yo me estoy muriendo, pero seguramente Dios los visitará y los hará subir de esta tierra a la tierra que juró a Abraham, a Isaac y a Jacob.” ");
INSERT INTO spablm_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","José hizo un juramento a los hijos de Israel, diciendo: “Ciertamente Dios os visitará y haréis subir mis huesos de aquí.” ");
INSERT INTO spablm_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Murió, pues, José, de ciento diez años de edad; lo embalsamaron y lo pusieron en un ataúd en Egipto. ");
INSERT INTO spablm_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Estos son los nombres de los hijos de Israel que vinieron a Egipto (cada hombre y su familia vinieron con Jacob): ");
INSERT INTO spablm_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Rubén, Simeón, Leví y Judá, ");
INSERT INTO spablm_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isacar, Zabulón y Benjamín, ");
INSERT INTO spablm_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan y Neftalí, Gad y Aser. ");
INSERT INTO spablm_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Todas las almas que salieron del cuerpo de Jacob fueron setenta almas, y José ya estaba en Egipto. ");
INSERT INTO spablm_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","José murió, al igual que todos sus hermanos y toda aquella generación. ");
INSERT INTO spablm_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Los hijos de Israel fructificaron, se multiplicaron y se hicieron muy poderosos, y la tierra se llenó de ellos. ");
INSERT INTO spablm_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Se levantó un nuevo rey sobre Egipto, que no conocía a José. ");
INSERT INTO spablm_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Dijo a su pueblo: “He aquí, el pueblo de los hijos de Israel es más y más poderoso que nosotros. ");
INSERT INTO spablm_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Vengan, tratemos con sabiduría con ellos, no sea que se multipliquen, y suceda que cuando estalle alguna guerra, ellos también se unan a nuestros enemigos y luchen contra nosotros, y escapen del país.” ");
INSERT INTO spablm_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Por lo tanto, pusieron sobre ellos a los capataces para que los afligieran con sus cargas. Construyeron ciudades de almacenamiento para el Faraón: Pitón y Ramsés. ");
INSERT INTO spablm_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Pero cuanto más los afligían, más se multiplicaban y más se extendían. Comenzaron a temer a los hijos de Israel. ");
INSERT INTO spablm_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Los egipcios hicieron servir sin piedad a los hijos de Israel, ");
INSERT INTO spablm_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","y les amargaron la vida con un duro servicio en la argamasa y en el ladrillo, y en todo tipo de servicio en el campo, todo su servicio, en el que los hicieron servir sin piedad. ");
INSERT INTO spablm_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","El rey de Egipto habló con las parteras hebreas, de las cuales una se llamaba Sifra y la otra Fua, ");
INSERT INTO spablm_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","y les dijo: “Cuando cumpláis con el deber de partera a las mujeres hebreas y las veáis en el taburete de parto, si es un hijo, lo mataréis; pero si es una hija, vivirá.” ");
INSERT INTO spablm_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Pero las parteras temían a Dios, y no hicieron lo que el rey de Egipto les ordenaba, sino que salvaron a los niños vivos. ");
INSERT INTO spablm_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","El rey de Egipto llamó a las parteras y les dijo: “¿Por qué habéis hecho esto y habéis salvado vivos a los niños?” ");
INSERT INTO spablm_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Las parteras dijeron al faraón: “Porque las mujeres hebreas no son como las egipcias, pues son vigorosas y dan a luz antes de que la partera llegue a ellas.” ");
INSERT INTO spablm_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Dios trató bien a las parteras, y el pueblo se multiplicó y se hizo muy poderoso. ");
INSERT INTO spablm_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Como las parteras temían a Dios, él les dio familias. ");
INSERT INTO spablm_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","El faraón ordenó a todo su pueblo, diciendo: “Echaréis al río a todo hijo que nazca, y a toda hija la salvaréis con vida.” ");
INSERT INTO spablm_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Un hombre de la casa de Leví fue y tomó como esposa a una hija de Leví. ");
INSERT INTO spablm_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","La mujer concibió y dio a luz un hijo. Al ver que era un buen niño, lo escondió durante tres meses. ");
INSERT INTO spablm_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Cuando ya no pudo esconderlo, tomó un cesto de papiro para él, y lo cubrió con brea y alquitrán. Puso al niño en ella y lo depositó en los juncos de la orilla del río. ");
INSERT INTO spablm_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Su hermana se quedó lejos, para ver qué se hacía con él. ");
INSERT INTO spablm_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","La hija del faraón bajó a bañarse en el río. Sus doncellas se paseaban por la orilla del río. Vio el cesto entre los juncos y envió a su criado a buscarlo. ");
INSERT INTO spablm_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","La abrió y vio al niño, y he aquí que el niño lloraba. Se compadeció de él y dijo: “Este es uno de los hijos de los hebreos”. ");
INSERT INTO spablm_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Entonces su hermana dijo a la hija del faraón: “¿Debo ir a llamar a una nodriza de las mujeres hebreas para que te amamante al niño?” ");
INSERT INTO spablm_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","La hija del faraón le dijo: “Ve”. La joven fue y llamó a la madre del niño. ");
INSERT INTO spablm_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","La hija del faraón le dijo: “Llévate a este niño y cuídalo por mí, y te daré tu salario”. La mujer tomó al niño y lo amamantó. ");
INSERT INTO spablm_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","El niño creció, lo llevó a la hija del faraón y se convirtió en su hijo. Ella le puso el nombre de Moisés, y dijo: “Porque lo saqué del agua”. ");
INSERT INTO spablm_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","En aquellos días, cuando Moisés había crecido, salió a ver a sus hermanos y vio sus cargas. Vio que un egipcio golpeaba a un hebreo, uno de sus hermanos. ");
INSERT INTO spablm_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Miró a un lado y a otro, y al ver que no había nadie, mató al egipcio y lo escondió en la arena. ");
INSERT INTO spablm_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Salió el segundo día, y he aquí que dos hombres de los hebreos estaban peleando entre sí. Le dijo al que había hecho el mal: “¿Por qué golpeas a tu compañero?”. ");
INSERT INTO spablm_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Él dijo: “¿Quién te ha hecho príncipe y juez sobre nosotros? ¿Piensas matarme, como mataste al egipcio?” Moisés tuvo miedo y dijo: “Ciertamente esto se sabe”. ");
INSERT INTO spablm_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Cuando el Faraón se enteró de esto, trató de matar a Moisés. Pero Moisés huyó de la presencia del Faraón, y vivió en la tierra de Madián, y se sentó junto a un pozo. ");
INSERT INTO spablm_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","El sacerdote de Madián tenía siete hijas. Ellas vinieron y sacaron agua, y llenaron los abrevaderos para abrevar el rebaño de su padre. ");
INSERT INTO spablm_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Los pastores vinieron y las ahuyentaron; pero Moisés se levantó y las ayudó, y abrevó su rebaño. ");
INSERT INTO spablm_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Cuando llegaron a Reuel, su padre, éste les dijo: “¿Cómo es que habéis vuelto hoy tan temprano?” ");
INSERT INTO spablm_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Dijeron: “Un egipcio nos libró de la mano de los pastores, y además nos sacó agua y abrevó el rebaño.” ");
INSERT INTO spablm_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Dijo a sus hijas: “¿Dónde está? ¿Por qué habéis dejado al hombre? Llamadle, para que coma pan”. ");
INSERT INTO spablm_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Moisés se contentó con habitar con el hombre. Le dio a Moisés a Séfora, su hija. ");
INSERT INTO spablm_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Ella dio a luz un hijo, y él le puso el nombre de Gershom, porque dijo: “He vivido como extranjero en tierra extranjera”. ");
INSERT INTO spablm_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","En el transcurso de esos muchos días, el rey de Egipto murió, y los hijos de Israel suspiraron a causa de la esclavitud, y lloraron, y su clamor subió a Dios a causa de la esclavitud. ");
INSERT INTO spablm_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Dios oyó su gemido, y se acordó de su pacto con Abraham, con Isaac y con Jacob. ");
INSERT INTO spablm_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Dios vio a los hijos de Israel, y Dios comprendió. ");
INSERT INTO spablm_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Moisés guardaba el rebaño de Jetro, su suegro, el sacerdote de Madián, y condujo el rebaño al fondo del desierto, y llegó al monte de Dios, a Horeb. ");
INSERT INTO spablm_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","El ángel de Yahvé se le apareció en una llama de fuego en medio de un arbusto. Miró, y he aquí que la zarza ardía en fuego, y la zarza no se consumía. ");
INSERT INTO spablm_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Moisés dijo: “Iré ahora a ver este gran espectáculo, por qué la zarza no se quema”. ");
INSERT INTO spablm_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Cuando Yahvé vio que se acercaba a ver, Dios le llamó desde el centro de la zarza y le dijo: “¡Moisés! Moisés!” Dijo: “Aquí estoy”. ");
INSERT INTO spablm_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Él dijo: “No te acerques. Quítate las sandalias, porque el lugar que pisas es tierra santa”. ");
INSERT INTO spablm_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Además, dijo: “Yo soy el Dios de tu padre, el Dios de Abraham, el Dios de Isaac y el Dios de Jacob”. Moisés ocultó su rostro porque tenía miedo de mirar a Dios. ");
INSERT INTO spablm_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Yahvé dijo: “Ciertamente he visto la aflicción de mi pueblo que está en Egipto, y he oído su clamor a causa de sus capataces, pues conozco sus penas. ");
INSERT INTO spablm_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","He descendido para librarlos de la mano de los egipcios, y para hacerlos subir de esa tierra a una tierra buena y extensa, a una tierra que fluye leche y miel; al lugar del cananeo, del hitita, del amorreo, del ferezeo, del heveo y del jebuseo. ");
INSERT INTO spablm_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Ahora bien, he aquí que el clamor de los hijos de Israel ha llegado hasta mí. Además, he visto la opresión con que los egipcios los oprimen. ");
INSERT INTO spablm_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Ven, pues, ahora y te enviaré al Faraón para que saques a mi pueblo, los hijos de Israel, de Egipto”. ");
INSERT INTO spablm_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Moisés dijo a Dios: “¿Quién soy yo para ir al Faraón y sacar a los hijos de Israel de Egipto?” ");
INSERT INTO spablm_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Dijo: “Ciertamente yo estaré con vosotros. Esta será la señal para ti, de que te he enviado: cuando hayas sacado al pueblo de Egipto, servirás a Dios en este monte.” ");
INSERT INTO spablm_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Moisés dijo a Dios: “He aquí que cuando llegue a los hijos de Israel y les diga: “El Dios de vuestros padres me ha enviado a vosotros”, y ellos me pregunten: “¿Cuál es su nombre?”, ¿qué debo decirles?” ");
INSERT INTO spablm_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Dios dijo a Moisés: “YO SOY EL QUE SOY”, y dijo: “Dirás a los hijos de Israel esto: ‘YO SOY me ha enviado a ustedes’”. ");
INSERT INTO spablm_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Dios dijo además a Moisés: “Dirás a los hijos de Israel esto: ‘Yahvé, el Dios de vuestros padres, el Dios de Abraham, el Dios de Isaac y el Dios de Jacob, me ha enviado a vosotros’. Este es mi nombre para siempre, y este es mi memorial para todas las generaciones. ");
INSERT INTO spablm_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Ve y reúne a los ancianos de Israel y diles: ‘El Señor, el Dios de tus padres, el Dios de Abraham, de Isaac y de Jacob, se me ha aparecido diciendo: “Ciertamente te he visitado y he visto lo que te han hecho en Egipto. ");
INSERT INTO spablm_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","He dicho que te haré subir de la aflicción de Egipto a la tierra del cananeo, del hitita, del amorreo, del ferezeo, del heveo y del jebuseo, a una tierra que mana leche y miel”. ");
INSERT INTO spablm_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Ellos escucharán tu voz. Vendrás, tú y los ancianos de Israel, al rey de Egipto, y le dirás: ‘El Señor, el Dios de los hebreos, se ha reunido con nosotros. Ahora, por favor, vayamos tres días de camino al desierto, para que ofrezcamos sacrificios a Yahvé, nuestro Dios’. ");
INSERT INTO spablm_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Yo sé que el rey de Egipto no te dará permiso para ir, ni siquiera con una mano poderosa. ");
INSERT INTO spablm_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Extenderé mi mano y golpearé a Egipto con todas mis maravillas que haré entre ellos, y después de eso los dejará ir. ");
INSERT INTO spablm_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Yo le daré a este pueblo el favor a los ojos de los egipcios, y sucederá que cuando te vayas, no te irás con las manos vacías. ");
INSERT INTO spablm_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Pero cada mujer pedirá a su vecina, y a la que visite su casa, joyas de plata, joyas de oro y ropa. Las pondréis sobre vuestros hijos y sobre vuestras hijas. Saquearás a los egipcios”. ");
INSERT INTO spablm_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Moisés respondió: “Pero he aquí que no me creerán ni escucharán mi voz, porque dirán: “Yahvé no se te ha aparecido””. ");
INSERT INTO spablm_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Yahvé le dijo: “¿Qué es eso que tienes en la mano?” Dijo: “Una vara”. ");
INSERT INTO spablm_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Dijo: “Tíralo al suelo”. La arrojó al suelo, y se convirtió en una serpiente; y Moisés huyó de ella. ");
INSERT INTO spablm_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Yahvé dijo a Moisés: “Extiende tu mano y tómalo por la cola”. Extendió la mano y la agarró, y se convirtió en una vara en su mano. ");
INSERT INTO spablm_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","“Esto es para que crean que Yahvé, el Dios de sus padres, el Dios de Abraham, el Dios de Isaac y el Dios de Jacob, se te ha aparecido”. ");
INSERT INTO spablm_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Yahvé le dijo además: “Ahora pon tu mano dentro de tu manto”. Metió la mano dentro de su manto, y cuando la sacó, he aquí que su mano estaba leprosa, blanca como la nieve. ");
INSERT INTO spablm_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Dijo: “Vuelve a meter la mano en el manto”. Volvió a meter la mano dentro de su manto, y cuando la sacó de su manto, he aquí que se había vuelto de nuevo como su otra carne. ");
INSERT INTO spablm_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","“Sucederá que si no te creen ni escuchan la voz de la primera señal, creerán la voz de la segunda señal. ");
INSERT INTO spablm_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Sucederá, si no creen ni siquiera en estas dos señales ni escuchan tu voz, que tomarás del agua del río y la derramarás sobre la tierra seca. El agua que saques del río se convertirá en sangre sobre la tierra seca”. ");
INSERT INTO spablm_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Moisés dijo a Yahvé: “Oh, Señor, no soy elocuente, ni antes, ni desde que has hablado a tu siervo; porque soy lento de palabra y de lengua lenta.” ");
INSERT INTO spablm_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","El Señor le dijo: “¿Quién hizo la boca del hombre? ¿O quién hace que uno sea mudo, o sordo, o que vea, o ciego? ¿No soy yo, Yahvé? ");
INSERT INTO spablm_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Ahora, pues, vete, y yo estaré con tu boca y te enseñaré lo que debes hablar”. ");
INSERT INTO spablm_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Moisés dijo: “Oh, Señor, por favor, envía a otro”. ");
INSERT INTO spablm_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","La ira de Yahvé ardió contra Moisés y le dijo: “¿Y Aarón, tu hermano, el levita? Sé que sabe hablar bien. Además, he aquí que él sale a recibirte. Cuando te vea, se alegrará en su corazón. ");
INSERT INTO spablm_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Tú le hablarás y pondrás las palabras en su boca. Yo estaré con tu boca y con la suya, y te enseñaré lo que debes hacer. ");
INSERT INTO spablm_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Él será tu portavoz ante el pueblo. Sucederá que él será para ti una boca, y tú serás para él como Dios. ");
INSERT INTO spablm_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Tomarás esta vara en tu mano, con la que harás las señales”. ");
INSERT INTO spablm_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Moisés fue y regresó a Jetro, su suegro, y le dijo: “Por favor, déjame ir y regresar a mis hermanos que están en Egipto, y ver si todavía están vivos.” Jetro dijo a Moisés: “Ve en paz”. ");
INSERT INTO spablm_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Yahvé dijo a Moisés en Madián: “Ve, vuelve a Egipto, porque todos los hombres que buscaban tu vida han muerto”. ");
INSERT INTO spablm_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Moisés tomó a su mujer y a sus hijos, los montó en un asno y volvió a la tierra de Egipto. Moisés tomó la vara de Dios en su mano. ");
INSERT INTO spablm_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","El Señor le dijo a Moisés: “Cuando vuelvas a Egipto, procura hacer ante el Faraón todas las maravillas que he puesto en tu mano, pero yo endureceré su corazón y no dejará ir al pueblo. ");
INSERT INTO spablm_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Le dirás al faraón: “Yahvé dice: Israel es mi hijo, mi primogénito, ");
INSERT INTO spablm_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","y yo te he dicho: “Deja ir a mi hijo para que me sirva”, y tú te has negado a dejarlo ir. He aquí que voy a matar a tu hijo primogénito’”. ");
INSERT INTO spablm_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","En el camino, en un lugar de alojamiento, Yahvé se encontró con Moisés y quiso matarlo. ");
INSERT INTO spablm_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Entonces Séfora tomó un pedernal, cortó el prepucio de su hijo y lo arrojó a sus pies, y dijo: “Ciertamente eres un novio de sangre para mí”. ");
INSERT INTO spablm_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Así que lo dejó en paz. Entonces le dijo: “Eres un novio de sangre”, a causa de la circuncisión. ");
INSERT INTO spablm_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Yahvé dijo a Aarón: “Ve al desierto a recibir a Moisés”. Fue, y se encontró con él en el monte de Dios, y lo besó. ");
INSERT INTO spablm_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Moisés le contó a Aarón todas las palabras de Yahvé con las que lo había enviado, y todas las señales con las que lo había instruido. ");
INSERT INTO spablm_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Moisés y Aarón fueron y reunieron a todos los ancianos de los hijos de Israel. ");
INSERT INTO spablm_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Aarón pronunció todas las palabras que Yahvé había dicho a Moisés, e hizo las señales a la vista del pueblo. ");
INSERT INTO spablm_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","El pueblo creyó, y al oír que el Señor había visitado a los hijos de Israel y que había visto su aflicción, inclinaron la cabeza y adoraron. ");
INSERT INTO spablm_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Después vinieron Moisés y Aarón y le dijeron al Faraón: “Esto es lo que dice Yahvé, el Dios de Israel: ‘Deja ir a mi pueblo para que me celebre una fiesta en el desierto’”. ");
INSERT INTO spablm_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","El faraón dijo: “¿Quién es Yahvé, para que yo escuche su voz para dejar ir a Israel? No conozco a Yahvé, y además no dejaré ir a Israel”. ");
INSERT INTO spablm_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Dijeron: “El Dios de los hebreos se ha reunido con nosotros. Por favor, vayamos tres días de camino al desierto y ofrezcamos sacrificios a Yahvé, nuestro Dios, no sea que caiga sobre nosotros la peste o la espada.” ");
INSERT INTO spablm_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","El rey de Egipto les dijo: “¿Por qué ustedes, Moisés y Aarón, sacan al pueblo de su trabajo? Volved a vuestras cargas”. ");
INSERT INTO spablm_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","El faraón dijo: “He aquí que el pueblo de la tierra es ahora numeroso, y ustedes lo hacen descansar de sus cargas”. ");
INSERT INTO spablm_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Ese mismo día el faraón ordenó a los capataces del pueblo y a sus oficiales, diciendo: ");
INSERT INTO spablm_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Ya no le daréis al pueblo paja para hacer ladrillos, como antes. Que vayan a recoger paja por sí mismos. ");
INSERT INTO spablm_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Les exigiréis el número de ladrillos que antes hacían. No disminuirán nada de ella, porque son ociosos. Por eso claman diciendo: ‘Vamos a sacrificar a nuestro Dios’. ");
INSERT INTO spablm_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Deja que el trabajo más pesado recaiga sobre los hombres, para que trabajen en él. Que no presten atención a las palabras mentirosas”. ");
INSERT INTO spablm_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Los capataces del pueblo salieron con sus oficiales y hablaron al pueblo diciendo: “Esto es lo que dice el Faraón: ‘No les daré paja. ");
INSERT INTO spablm_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Vayan ustedes mismos, consigan paja donde puedan encontrarla, porque nada de su trabajo será disminuido’”. ");
INSERT INTO spablm_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Así que el pueblo se dispersó por toda la tierra de Egipto para recoger rastrojos para hacer paja. ");
INSERT INTO spablm_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Los capataces urgían diciendo: “¡Cumplan su cuota de trabajo diariamente, como cuando había paja!” ");
INSERT INTO spablm_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Los oficiales de los hijos de Israel, que los capataces del faraón habían puesto sobre ellos, fueron golpeados y se les preguntó: “¿Por qué no habéis cumplido vuestra cuota tanto ayer como hoy, haciendo ladrillos como antes?” ");
INSERT INTO spablm_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Entonces los oficiales de los hijos de Israel vinieron y gritaron al Faraón, diciendo: “¿Por qué tratas así a tus siervos? ");
INSERT INTO spablm_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","No se les da paja a tus siervos, y nos dicen: ‘¡Haz ladrillo!’ y he aquí que tus siervos son golpeados; pero la culpa es de tu propio pueblo.” ");
INSERT INTO spablm_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Pero el Faraón dijo: “¡Estás ocioso! ¡Estás ocioso! Por eso dices: ‘Vamos a sacrificar a Yahvé’. ");
INSERT INTO spablm_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","¡Vayan, pues, ahora y trabajen, porque no se les dará paja, pero entregarán el mismo número de ladrillos!” ");
INSERT INTO spablm_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Los oficiales de los hijos de Israel vieron que estaban en problemas cuando se les dijo: “¡No disminuirán nada de tu cuota diaria de ladrillos!” ");
INSERT INTO spablm_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Se encontraron con Moisés y Aarón, que estaban en el camino, cuando salían del Faraón. ");
INSERT INTO spablm_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Les dijeron: “¡Que Yahvé los mire y los juzgue, porque ustedes nos han convertido en un hedor abominable a los ojos del Faraón y a los ojos de sus siervos, para poner una espada en su mano para matarnos!” ");
INSERT INTO spablm_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Moisés volvió a Yahvé y le dijo: “Señor, ¿por qué has traído problemas a este pueblo? ¿Por qué me has enviado? ");
INSERT INTO spablm_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Porque desde que vine al Faraón a hablar en tu nombre, él ha traído problemas a este pueblo. No has rescatado a tu pueblo en absoluto”. ");
INSERT INTO spablm_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Yahvé dijo a Moisés: “Ahora verás lo que haré con el Faraón, porque con mano fuerte los dejará ir, y con mano fuerte los expulsará de su tierra.” ");
INSERT INTO spablm_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Dios habló a Moisés y le dijo: “Yo soy Yahvé. ");
INSERT INTO spablm_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Me presenté a Abraham, a Isaac y a Jacob como Dios Todopoderoso; pero por mi nombre Yahvé no me conocieron. ");
INSERT INTO spablm_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","También he establecido mi pacto con ellos, para darles la tierra de Canaán, la tierra de sus viajes, en la que vivían como extranjeros. ");
INSERT INTO spablm_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Además, he oído el gemido de los hijos de Israel, a quienes los egipcios mantienen en esclavitud, y me he acordado de mi pacto. ");
INSERT INTO spablm_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Por tanto, di a los hijos de Israel: “Yo soy Yahvé, y os sacaré de las cargas de los egipcios, y os libraré de su esclavitud, y os redimiré con brazo extendido y con grandes juicios. ");
INSERT INTO spablm_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Os tomaré para mí como pueblo. Yo seré tu Dios; y sabrás que yo soy Yahvé, tu Dios, que te saca de las cargas de los egipcios. ");
INSERT INTO spablm_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Os llevaré a la tierra que juré dar a Abraham, a Isaac y a Jacob, y os la daré en herencia: yo soy Yahvé”. ");
INSERT INTO spablm_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Moisés habló así a los hijos de Israel, pero ellos no escucharon a Moisés por la angustia de espíritu y la cruel esclavitud. ");
INSERT INTO spablm_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Yahvé habló a Moisés diciendo: ");
INSERT INTO spablm_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Entra y habla con el faraón, rey de Egipto, para que deje salir a los hijos de Israel de su tierra.” ");
INSERT INTO spablm_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Moisés habló ante el Señor diciendo: “He aquí que los hijos de Israel no me han escuchado. ¿Cómo, pues, me va a escuchar el faraón, si tengo los labios incircuncisos?” ");
INSERT INTO spablm_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Yahvé habló a Moisés y a Aarón y les dio una orden a los hijos de Israel y al faraón, rey de Egipto, para que sacaran a los hijos de Israel de la tierra de Egipto. ");
INSERT INTO spablm_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Estos son los jefes de las casas de sus padres. Los hijos de Rubén, primogénito de Israel: Hanoc, Falu, Esrom y Carmi; estas son las familias de Rubén. ");
INSERT INTO spablm_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Los hijos de Simeón: Jemuel, Jamín, Ohad, Jaquín, Zohar y Saúl, hijo de una cananea; estas son las familias de Simeón. ");
INSERT INTO spablm_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Estos son los nombres de los hijos de Leví según sus generaciones Gersón, Coat y Merari; y los años de la vida de Leví fueron ciento treinta y siete años. ");
INSERT INTO spablm_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Los hijos de Gersón: Libni y Simei, según sus familias. ");
INSERT INTO spablm_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Los hijos de Coat Amram, Izhar, Hebrón y Uziel; y los años de la vida de Coat fueron ciento treinta y tres años. ");
INSERT INTO spablm_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Los hijos de Merari: Mahli y Musi. Estas son las familias de los levitas según sus generaciones. ");
INSERT INTO spablm_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram tomó como esposa a Jocabed, hermana de su padre, y ella le dio a luz a Aarón y a Moisés. Los años de la vida de Amram fueron ciento treinta y siete años. ");
INSERT INTO spablm_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Los hijos de Izhar Coré, Nefeg y Zicri. ");
INSERT INTO spablm_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Los hijos de Uziel: Misael, Elzafán y Sitri. ");
INSERT INTO spablm_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aarón tomó por esposa a Elisaba, hija de Aminadab, hermana de Naasón, y ella le dio a luz a Nadab y Abiú, Eleazar e Itamar. ");
INSERT INTO spablm_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Los hijos de Coré: Asir, Elcana y Abiasaf; estas son las familias de los Coreitas. ");
INSERT INTO spablm_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eleazar, hijo de Aarón, tomó por mujer a una de las hijas de Putiel, y ella le dio a luz a Finees. Estos son los jefes de las casas paternas de los levitas según sus familias. ");
INSERT INTO spablm_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Estos son aquel Aarón y aquel Moisés a quienes Yahvé dijo: “Sacad a los hijos de Israel de la tierra de Egipto según sus ejércitos.” ");
INSERT INTO spablm_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Estos son los que hablaron con el faraón, rey de Egipto, para sacar a los hijos de Israel de Egipto. Estos son Moisés y Aarón. ");
INSERT INTO spablm_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","El día en que Yahvé habló con Moisés en la tierra de Egipto, ");
INSERT INTO spablm_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","Yahvé dijo a Moisés: “Yo soy Yahvé. Dile al Faraón, rey de Egipto, todo lo que te digo”. ");
INSERT INTO spablm_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Moisés dijo ante Yahvé: “He aquí que soy de labios incircuncisos, ¿y cómo me escuchará el Faraón?” ");
INSERT INTO spablm_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Yahvé dijo a Moisés: “He aquí que te he puesto como Dios ante el Faraón, y Aarón tu hermano será tu profeta. ");
INSERT INTO spablm_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Tú hablarás todo lo que yo te mande; y Aarón tu hermano hablará al Faraón para que deje salir a los hijos de Israel de su tierra. ");
INSERT INTO spablm_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Yo endureceré el corazón del Faraón, y multiplicaré mis señales y mis prodigios en la tierra de Egipto. ");
INSERT INTO spablm_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Pero el Faraón no te escuchará, así que pondré mi mano sobre Egipto y sacaré a mis ejércitos, a mi pueblo los hijos de Israel, de la tierra de Egipto con grandes juicios. ");
INSERT INTO spablm_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Los egipcios sabrán que yo soy Yahvé cuando extienda mi mano sobre Egipto y saque a los hijos de Israel de entre ellos.” ");
INSERT INTO spablm_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Moisés y Aarón lo hicieron. Como el Señor les ordenó, así lo hicieron. ");
INSERT INTO spablm_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Moisés tenía ochenta años, y Aarón ochenta y tres, cuando hablaron con el faraón. ");
INSERT INTO spablm_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Yahvé habló a Moisés y a Aarón, diciendo: ");
INSERT INTO spablm_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Cuando el Faraón les hable diciendo: ‘Hagan un milagro’, entonces le dirán a Aarón: ‘Toma tu vara y arrójala ante el Faraón, y se convertirá en una serpiente’”. ");
INSERT INTO spablm_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Moisés y Aarón se presentaron ante el faraón, y así lo hicieron, tal como lo había ordenado el Señor. Aarón arrojó su vara ante el Faraón y ante sus servidores, y se convirtió en una serpiente. ");
INSERT INTO spablm_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Entonces el faraón llamó también a los sabios y a los hechiceros. Ellos también, los magos de Egipto, hicieron lo mismo con sus encantamientos. ");
INSERT INTO spablm_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Cada uno de ellos arrojó su vara y se convirtió en serpiente; pero la vara de Aarón se tragó sus varas. ");
INSERT INTO spablm_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","El corazón del faraón se endureció y no los escuchó, como había dicho el Señor. ");
INSERT INTO spablm_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","El Señor dijo a Moisés: “El corazón del faraón es obstinado. Se niega a dejar ir al pueblo. ");
INSERT INTO spablm_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Ve a ver al faraón por la mañana. He aquí que él va a salir al agua. Tú estarás a la orilla del río para recibirlo. Tomarás en tu mano la vara convertida en serpiente. ");
INSERT INTO spablm_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Le dirás: “Yahvé, el Dios de los hebreos, me ha enviado a ti, diciendo: “Deja ir a mi pueblo, para que me sirva en el desierto. He aquí que hasta ahora no has hecho caso”. ");
INSERT INTO spablm_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Yahvé dice: “En esto sabrán que yo soy Yahvé. Miren: Golpearé con la vara que tengo en mi mano las aguas que están en el río, y se convertirán en sangre. ");
INSERT INTO spablm_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Los peces que están en el río morirán y el río se ensuciará. Los egipcios detestarán beber agua del río”. ");
INSERT INTO spablm_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Yahvé dijo a Moisés: “Dile a Aarón: ‘Toma tu vara y extiende tu mano sobre las aguas de Egipto, sobre sus ríos, sobre sus arroyos y sobre sus estanques, y sobre todos sus estanques de agua, para que se conviertan en sangre. Habrá sangre en toda la tierra de Egipto, tanto en los recipientes de madera como en los de piedra’”. ");
INSERT INTO spablm_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Moisés y Aarón lo hicieron así, tal como lo había ordenado el Señor, y él levantó la vara y golpeó las aguas que estaban en el río, a la vista del Faraón y de sus servidores, y todas las aguas que estaban en el río se convirtieron en sangre. ");
INSERT INTO spablm_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Los peces que había en el río murieron. El río se volvió fétido. Los egipcios no podían beber agua del río. La sangre se extendió por toda la tierra de Egipto. ");
INSERT INTO spablm_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Los magos de Egipto hicieron lo mismo con sus encantamientos. Así que el corazón del faraón se endureció y no les hizo caso, como había dicho el Señor. ");
INSERT INTO spablm_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","El faraón se volvió y entró en su casa, y ni siquiera lo tomó en cuenta. ");
INSERT INTO spablm_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Todos los egipcios cavaron alrededor del río en busca de agua para beber, porque no podían beber el agua del río. ");
INSERT INTO spablm_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Se cumplieron siete días, después de que el Señor golpeó el río. ");
INSERT INTO spablm_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Yahvé le habló a Moisés: “Ve a Faraón y dile: ‘Esto es lo que dice Yahvé: “Deja ir a mi pueblo para que me sirva. ");
INSERT INTO spablm_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Si te niegas a dejarlos ir, he aquí que yo plagaré de ranas todas tus fronteras. ");
INSERT INTO spablm_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","El río se llenará de ranas, que subirán y entrarán en tu casa, en tu dormitorio, en tu cama, en la casa de tus siervos y en tu pueblo, en tus hornos y en tus amasadoras. ");
INSERT INTO spablm_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Las ranas subirán sobre ti, sobre tu pueblo y sobre todos tus servidores”. ");
INSERT INTO spablm_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Yahvé dijo a Moisés: “Dile a Aarón: ‘Extiende tu mano con tu vara sobre los ríos, sobre los arroyos y sobre los estanques, y haz que las ranas suban sobre la tierra de Egipto’”. ");
INSERT INTO spablm_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Aarón extendió su mano sobre las aguas de Egipto, y las ranas subieron y cubrieron la tierra de Egipto. ");
INSERT INTO spablm_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Los magos hicieron lo mismo con sus encantamientos, e hicieron subir ranas sobre la tierra de Egipto. ");
INSERT INTO spablm_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Entonces el faraón llamó a Moisés y a Aarón y les dijo: “Rogad a Yahvé que quite las ranas de mí y de mi pueblo, y dejaré ir al pueblo para que ofrezca sacrificios a Yahvé.” ");
INSERT INTO spablm_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Moisés dijo al Faraón: “Te concedo el honor de fijar el tiempo en que debo orar por ti, por tus siervos y por tu pueblo, para que las ranas desaparezcan de ti y de tus casas, y se queden sólo en el río.” ");
INSERT INTO spablm_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","El faraón dijo: “Mañana”. Moisés dijo: “Que sea según tu palabra, para que sepas que no hay nadie como Yahvé, nuestro Dios. ");
INSERT INTO spablm_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Las ranas se apartarán de ti, de tus casas, de tus siervos y de tu pueblo. Se quedarán sólo en el río”. ");
INSERT INTO spablm_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Moisés y Aarón salieron del Faraón, y Moisés clamó a Yahvé por las ranas que había traído sobre el Faraón. ");
INSERT INTO spablm_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","El Señor hizo lo que le dijo Moisés, y las ranas murieron en las casas, en los patios y en los campos. ");
INSERT INTO spablm_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Las juntaron en montones, y la tierra apestaba. ");
INSERT INTO spablm_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Pero cuando el faraón vio que había un respiro, endureció su corazón y no les hizo caso, como había dicho el Señor. ");
INSERT INTO spablm_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Yahvé dijo a Moisés: “Dile a Aarón: ‘Extiende tu vara y golpea el polvo de la tierra para que se convierta en piojos en toda la tierra de Egipto’”. ");
INSERT INTO spablm_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Así lo hicieron; y Aarón extendió su mano con su vara y golpeó el polvo de la tierra, y hubo piojos en los hombres y en los animales; todo el polvo de la tierra se convirtió en piojos en toda la tierra de Egipto. ");
INSERT INTO spablm_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Los magos intentaron con sus encantamientos producir piojos, pero no pudieron. Había piojos en los hombres y en los animales. ");
INSERT INTO spablm_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Entonces los magos le dijeron al faraón: “Este es el dedo de Dios”; pero el corazón del faraón se endureció y no los escuchó, tal como lo había dicho el Señor. ");
INSERT INTO spablm_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","El Señor dijo a Moisés: “Levántate de madrugada y preséntate ante el Faraón; he aquí que él sale al agua, y dile: “Esto es lo que dice el Señor: “Deja ir a mi pueblo para que me sirva. ");
INSERT INTO spablm_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","De lo contrario, si no dejas ir a mi pueblo, he aquí que enviaré enjambres de moscas sobre ti, sobre tus siervos y sobre tu pueblo, y a tus casas. Las casas de los egipcios se llenarán de enjambres de moscas, y también el suelo sobre el que están. ");
INSERT INTO spablm_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","En ese día apartaré la tierra de Gosén, en la que habita mi pueblo, para que no haya enjambres de moscas, a fin de que se sepa que yo soy Yahvé en la tierra. ");
INSERT INTO spablm_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Pondré una división entre mi pueblo y el tuyo. Esta señal se producirá para mañana””. ");
INSERT INTO spablm_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Así lo hizo Yahvé, y entraron graves enjambres de moscas en la casa del Faraón y en las casas de sus servidores. En todo el territorio de Egipto la tierra se corrompió a causa de los enjambres de moscas. ");
INSERT INTO spablm_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","El faraón llamó a Moisés y a Aarón y les dijo: “¡Vayan a sacrificar a su Dios en la tierra!” ");
INSERT INTO spablm_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Moisés dijo: “No es conveniente hacerlo, porque vamos a sacrificar la abominación de los egipcios a Yahvé, nuestro Dios. He aquí que si sacrificamos la abominación de los egipcios ante sus ojos, ¿no nos apedrearán? ");
INSERT INTO spablm_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Iremos tres días de camino al desierto y sacrificaremos a Yahvé, nuestro Dios, como él nos mande.” ");
INSERT INTO spablm_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","El faraón dijo: “Te dejaré ir para que ofrezcas sacrificios a Yahvé, tu Dios, en el desierto, sólo que no te irás muy lejos. Reza por mí”. ");
INSERT INTO spablm_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Moisés dijo: “He aquí que yo salgo de ti. Oraré a Yahvé para que los enjambres de moscas se alejen mañana del Faraón, de sus servidores y de su pueblo; sólo que no permitas que el Faraón siga actuando con engaño al no dejar que el pueblo vaya a sacrificar a Yahvé.” ");
INSERT INTO spablm_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Moisés salió del Faraón y oró a Yahvé. ");
INSERT INTO spablm_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","El Señor hizo lo que le dijo Moisés, y eliminó los enjambres de moscas del Faraón, de sus servidores y de su pueblo. No quedó ni una. ");
INSERT INTO spablm_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","El faraón también endureció su corazón esta vez y no dejó ir al pueblo. ");
INSERT INTO spablm_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Entonces Yahvé dijo a Moisés: “Ve a Faraón y dile: ‘Esto es lo que dice Yahvé, el Dios de los hebreos: “Deja ir a mi pueblo para que me sirva. ");
INSERT INTO spablm_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Porque si te niegas a dejarlos ir y los retienes, ");
INSERT INTO spablm_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","he aquí que la mano de Yahvé está sobre tu ganado que está en el campo, sobre los caballos, sobre los asnos, sobre los camellos, sobre los rebaños y sobre las manadas con una peste muy grave. ");
INSERT INTO spablm_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","El Señor hará una distinción entre el ganado de Israel y el de Egipto, y no morirá nada de todo lo que pertenece a los hijos de Israel”. ");
INSERT INTO spablm_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Yahvé fijó un tiempo determinado, diciendo: “Mañana Yahvé hará esta cosa en la tierra”. ");
INSERT INTO spablm_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Yahvé hizo esa cosa al día siguiente; y todo el ganado de Egipto murió, pero del ganado de los hijos de Israel no murió ni uno. ");
INSERT INTO spablm_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","El faraón envió, y he aquí que no había muerto ni uno solo de los ganados de los israelitas. Pero el corazón del Faraón era obstinado, y no dejó ir al pueblo. ");
INSERT INTO spablm_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","El Señor dijo a Moisés y a Aarón: “Tomen puñados de ceniza del horno y que Moisés la esparza hacia el cielo a la vista del Faraón. ");
INSERT INTO spablm_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Se convertirá en polvo pequeño sobre toda la tierra de Egipto, y habrá forúnculos y ampollas que brotarán en el hombre y en el animal, en toda la tierra de Egipto.” ");
INSERT INTO spablm_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Tomaron cenizas del horno y se presentaron ante el Faraón; Moisés las roció hacia el cielo, y se convirtieron en forúnculos y ampollas que brotaron en el hombre y en el animal. ");
INSERT INTO spablm_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Los magos no podían estar delante de Moisés a causa de los forúnculos, pues los forúnculos estaban en los magos y en todos los egipcios. ");
INSERT INTO spablm_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","El Señor endureció el corazón del faraón y no les hizo caso, como el Señor le había dicho a Moisés. ");
INSERT INTO spablm_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Yahvé dijo a Moisés: “Levántate de madrugada y preséntate ante el faraón y dile: “Esto es lo que dice Yahvé, el Dios de los hebreos: “Deja ir a mi pueblo para que me sirva. ");
INSERT INTO spablm_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Por esta vez enviaré todas mis plagas contra tu corazón, contra tus funcionarios y contra tu pueblo, para que sepas que no hay nadie como yo en toda la tierra. ");
INSERT INTO spablm_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Porque ahora habría extendido mi mano y te habría herido a ti y a tu pueblo con la peste, y habrías sido eliminado de la tierra; ");
INSERT INTO spablm_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","pero, en verdad, por esta causa te he puesto en pie: para mostrarte mi poder, y para que mi nombre sea declarado en toda la tierra, ");
INSERT INTO spablm_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","porque todavía te exaltas contra mi pueblo, que no lo dejas ir. ");
INSERT INTO spablm_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","He aquí que mañana a esta hora haré llover un granizo muy fuerte, como no ha habido en Egipto desde el día de su fundación hasta ahora. ");
INSERT INTO spablm_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Ordena, pues, que todo tu ganado y todo lo que tengas en el campo se ponga a resguardo. El granizo caerá sobre todos los hombres y animales que se encuentren en el campo y no sean llevados a casa, y morirán””. ");
INSERT INTO spablm_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Los que temían la palabra de Yahvé entre los siervos del Faraón hicieron huir a sus siervos y a sus ganados a las casas. ");
INSERT INTO spablm_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Los que no respetaron la palabra de Yahvé dejaron a sus siervos y a su ganado en el campo. ");
INSERT INTO spablm_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Yahvé dijo a Moisés: “Extiende tu mano hacia el cielo, para que haya granizo en toda la tierra de Egipto, sobre el hombre, sobre el animal y sobre toda hierba del campo, en toda la tierra de Egipto.” ");
INSERT INTO spablm_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Moisés extendió su vara hacia el cielo, y el Señor envió truenos y granizo, y los relámpagos cayeron sobre la tierra. El Señor hizo llover granizo sobre la tierra de Egipto. ");
INSERT INTO spablm_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Hubo un granizo muy fuerte, y los relámpagos se mezclaron con el granizo, como no había habido en toda la tierra de Egipto desde que se convirtió en una nación. ");
INSERT INTO spablm_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","El granizo hirió en toda la tierra de Egipto a todo lo que estaba en el campo, tanto a los hombres como a los animales; y el granizo hirió toda hierba del campo, y quebró todo árbol del campo. ");
INSERT INTO spablm_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Sólo en la tierra de Gosén, donde estaban los hijos de Israel, no hubo granizo. ");
INSERT INTO spablm_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","El faraón mandó llamar a Moisés y a Aarón y les dijo: “Esta vez he pecado. El Señor es justo, y yo y mi pueblo somos impíos. ");
INSERT INTO spablm_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Supliquen Yahvé, porque ya ha habido bastantes truenos y granizo. Los dejaré ir, y no se quedarán por más tiempo”. ");
INSERT INTO spablm_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Moisés le dijo: “En cuanto salga de la ciudad, extenderé mis manos a Yahvé. Cesarán los truenos y no habrá más granizo, para que sepas que la tierra es de Yahvé. ");
INSERT INTO spablm_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Pero en cuanto a ti y a tus siervos, sé que aún no temes a Yahvé Dios”. ");
INSERT INTO spablm_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","El lino y la cebada fueron golpeados, porque la cebada había madurado y el lino estaba floreciendo. ");
INSERT INTO spablm_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Pero el trigo y la escanda no fueron golpeados, porque no habían crecido. ");
INSERT INTO spablm_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Moisés salió de la ciudad del Faraón y extendió sus manos a Yahvé; y cesaron los truenos y el granizo, y no se derramó la lluvia sobre la tierra. ");
INSERT INTO spablm_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Cuando el Faraón vio que la lluvia, el granizo y los truenos habían cesado, pecó aún más, y endureció su corazón, él y sus siervos. ");
INSERT INTO spablm_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","El corazón del faraón se endureció, y no dejó ir a los hijos de Israel, tal como Yahvé había dicho por medio de Moisés. ");
INSERT INTO spablm_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Yahvé dijo a Moisés: “Entra a Faraón, porque he endurecido su corazón y el de sus siervos, para mostrar estas mis señales entre ellos; ");
INSERT INTO spablm_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","y para que cuentes a tu hijo y al hijo de tu hijo las cosas que he hecho a Egipto y mis señales que he realizado entre ellos, para que sepas que yo soy Yahvé.” ");
INSERT INTO spablm_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Moisés y Aarón fueron a ver al faraón y le dijeron: “Esto es lo que dice el Señor, el Dios de los hebreos: ‘¿Hasta cuándo te negarás a humillarte ante mí? Deja ir a mi pueblo para que me sirva. ");
INSERT INTO spablm_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","O bien, si te niegas a dejar ir a mi pueblo, he aquí que mañana traeré langostas a tu país, ");
INSERT INTO spablm_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","y cubrirán la superficie de la tierra, de modo que no se podrá ver la tierra. Se comerán el residuo de lo que se haya escapado, lo que os quede del granizo, y se comerán todo árbol que crezca para vosotros del campo. ");
INSERT INTO spablm_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Tus casas se llenarán, y las casas de todos tus siervos, y las casas de todos los egipcios, como nunca vieron tus padres ni los padres de tus padres, desde el día en que estuvieron en la tierra hasta hoy.’” Se volvió y salió del Faraón. ");
INSERT INTO spablm_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Los siervos del faraón le dijeron: “¿Hasta cuándo será este hombre una trampa para nosotros? Deja ir a los hombres para que sirvan a Yahvé, su Dios. ¿Aún no sabes que Egipto está destruido?” ");
INSERT INTO spablm_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Moisés y Aarón fueron llevados de nuevo ante el Faraón, y éste les dijo: “Id, servid a Yahvé vuestro Dios; pero ¿quiénes son los que irán?” ");
INSERT INTO spablm_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Moisés dijo: “Iremos con nuestros jóvenes y nuestros ancianos. Iremos con nuestros hijos y con nuestras hijas, con nuestros rebaños y con nuestras manadas; porque debemos celebrar una fiesta a Yahvé”. ");
INSERT INTO spablm_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Les dijo: “¡Que el Señor esté con vosotros si os dejo ir con vuestros pequeños! Ved que el mal está claramente ante vuestras caras. ");
INSERT INTO spablm_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","¡No es así! Vayan ahora ustedes, que son hombres, y sirvan a Yahvé; ¡pues eso es lo que desean!” Entonces fueron expulsados de la presencia del faraón. ");
INSERT INTO spablm_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Yahvé dijo a Moisés: “Extiende tu mano sobre la tierra de Egipto para que suban las langostas sobre la tierra de Egipto y coman toda la hierba de la tierra, todo lo que el granizo ha dejado.” ");
INSERT INTO spablm_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Moisés extendió su vara sobre la tierra de Egipto, y el Señor trajo un viento del este sobre la tierra durante todo ese día y toda la noche; y cuando amaneció, el viento del este trajo las langostas. ");
INSERT INTO spablm_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Las langostas subieron por toda la tierra de Egipto y se posaron en todos los límites de Egipto. Eran muy graves. Antes de ellas no hubo langostas como ellas, ni las habrá jamás. ");
INSERT INTO spablm_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Porque cubrieron la superficie de toda la tierra, de modo que la tierra se oscureció, y se comieron toda la hierba de la tierra y todo el fruto de los árboles que había dejado el granizo. No quedó nada verde, ni árbol ni hierba del campo, en toda la tierra de Egipto. ");
INSERT INTO spablm_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Entonces el faraón llamó a Moisés y a Aarón a toda prisa, y dijo: “He pecado contra el Señor, tu Dios, y contra ti. ");
INSERT INTO spablm_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Ahora, por favor, perdonen de nuevo mi pecado, y rueguen a Yahvé su Dios, para que también me quite esta muerte.” ");
INSERT INTO spablm_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Moisés salió del Faraón y oró al Señor. ");
INSERT INTO spablm_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","El Señor envió un fortísimo viento del oeste que arrastró a las langostas y las arrojó al Mar Rojo. No quedó ni una sola langosta en todos los límites de Egipto. ");
INSERT INTO spablm_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Pero Yahvé endureció el corazón del faraón, y no dejó ir a los hijos de Israel. ");
INSERT INTO spablm_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Yahvé dijo a Moisés: “Extiende tu mano hacia el cielo, para que haya tinieblas sobre la tierra de Egipto, tinieblas que se puedan sentir.” ");
INSERT INTO spablm_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Moisés extendió su mano hacia el cielo, y hubo una densa oscuridad en toda la tierra de Egipto durante tres días. ");
INSERT INTO spablm_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","No se veían unos a otros, y nadie se levantó de su lugar durante tres días; pero todos los hijos de Israel tenían luz en sus moradas. ");
INSERT INTO spablm_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","El faraón llamó a Moisés y le dijo: “Ve y sirve a Yahvé. Sólo deja que tus rebaños y tus manadas se queden atrás. Que tus pequeños también vayan contigo”. ");
INSERT INTO spablm_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Moisés dijo: “También debes entregar en nuestras manos sacrificios y holocaustos, para que ofrezcamos sacrificios a Yahvé, nuestro Dios. ");
INSERT INTO spablm_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Nuestro ganado también irá con nosotros. No se dejará ni una pezuña, pues de ella debemos tomar para servir a Yahvé nuestro Dios; y no sabemos con qué debemos servir a Yahvé, hasta que lleguemos allí.” ");
INSERT INTO spablm_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Pero Yahvé endureció el corazón del faraón y no los dejó ir. ");
INSERT INTO spablm_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","El faraón le dijo: “¡Aléjate de mí! Cuídate de no ver más mi rostro, porque el día que veas mi rostro morirás”. ");
INSERT INTO spablm_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Moisés dijo: “Has hablado bien. No volveré a ver tu rostro”. ");
INSERT INTO spablm_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","El Señor le dijo a Moisés: “Traeré una plaga más sobre el Faraón y sobre Egipto; después te dejará ir. Cuando los deje ir, seguramente los expulsará por completo. ");
INSERT INTO spablm_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Habla ahora en los oídos del pueblo, y que cada hombre pida a su prójimo, y cada mujer a su prójimo, joyas de plata y joyas de oro.” ");
INSERT INTO spablm_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Yahvé le dio al pueblo el favor a los ojos de los egipcios. Además, el hombre Moisés era muy grande en la tierra de Egipto, a los ojos de los siervos del faraón y del pueblo. ");
INSERT INTO spablm_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Moisés dijo: “Esto es lo que dice el Señor: ‘Hacia la medianoche saldré al centro de Egipto, ");
INSERT INTO spablm_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","y morirán todos los primogénitos en la tierra de Egipto, desde el primogénito del Faraón que se sienta en su trono, hasta el primogénito de la sierva que está detrás del molino, y todos los primogénitos del ganado. ");
INSERT INTO spablm_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Habrá un gran clamor en toda la tierra de Egipto, como no lo ha habido ni lo habrá nunca. ");
INSERT INTO spablm_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Pero contra cualquiera de los hijos de Israel ni siquiera ladrará un perro ni moverá la lengua, ni contra el hombre ni contra el animal, para que sepas que el Señor hace distinción entre los egipcios e Israel. ");
INSERT INTO spablm_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Todos estos siervos tuyos bajarán a mí y se inclinarán ante mí, diciendo: “Sal, con todo el pueblo que te sigue”; y después de eso saldré yo”. Salió del Faraón con gran ira. ");
INSERT INTO spablm_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Yahvé dijo a Moisés: “El faraón no te escuchará, para que mis maravillas se multipliquen en la tierra de Egipto”. ");
INSERT INTO spablm_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Moisés y Aarón hicieron todos estos prodigios ante el faraón, pero Yahvé endureció el corazón del faraón, y no dejó salir a los hijos de Israel de su tierra. ");
INSERT INTO spablm_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Yahvé habló a Moisés y a Aarón en la tierra de Egipto, diciendo: ");
INSERT INTO spablm_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Este mes será para vosotros el principio de los meses. Será para ustedes el primer mes del año. ");
INSERT INTO spablm_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Hablad a toda la congregación de Israel, diciendo: “El día diez de este mes, cada uno tomará un cordero, según las casas de sus padres, un cordero por familia; ");
INSERT INTO spablm_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","y si la familia es demasiado pequeña para un cordero, entonces él y su vecino de al lado tomarán uno según el número de las almas. Harás la cuenta del cordero según lo que cada uno pueda comer. ");
INSERT INTO spablm_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Tu cordero será sin defecto, un macho de un año. Lo tomarás de las ovejas o de las cabras. ");
INSERT INTO spablm_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Lo guardarás hasta el día catorce del mismo mes; y toda la asamblea de la congregación de Israel lo matará al atardecer. ");
INSERT INTO spablm_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Tomarán un poco de la sangre y la pondrán en los dos postes de la puerta y en el dintel, en las casas en las que la comerán. ");
INSERT INTO spablm_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Esa noche comerán la carne, asada al fuego, con panes sin levadura. La comerán con hierbas amargas. ");
INSERT INTO spablm_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","No la comerán cruda, ni hervida en absoluto con agua, sino asada al fuego; con su cabeza, sus patas y sus partes interiores. ");
INSERT INTO spablm_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","No dejarás que quede nada de él hasta la mañana; pero lo que quede de él hasta la mañana lo quemarás al fuego. ");
INSERT INTO spablm_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Así lo comerás: con tu cinturón en la cintura, tus sandalias en los pies y tu bastón en la mano; y lo comerás de prisa: es la Pascua de Yahvé. ");
INSERT INTO spablm_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Porque esa noche pasaré por la tierra de Egipto y heriré a todos los primogénitos de la tierra de Egipto, tanto a los hombres como a los animales. Ejecutaré juicios contra todos los dioses de Egipto. Yo soy Yahvé. ");
INSERT INTO spablm_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","La sangre les servirá de señal en las casas donde estén. Cuando vea la sangre, pasaré por encima de ustedes, y no habrá ninguna plaga que los destruya cuando golpee la tierra de Egipto. ");
INSERT INTO spablm_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Este día será un memorial para ustedes. Lo celebrarán como una fiesta para Yahvé. Lo celebraréis como una fiesta a lo largo de vuestras generaciones, como una ordenanza para siempre. ");
INSERT INTO spablm_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","“‘Siete días comeréis panes sin levadura; el primer día quitaréis la levadura de vuestras casas, porque cualquiera que coma pan con levadura desde el primer día hasta el séptimo, esa persona será cortada de Israel. ");
INSERT INTO spablm_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","El primer día tendréis una santa convocación, y el séptimo día una santa convocación; no se hará en ellos ninguna clase de trabajo, sino el que cada uno deba comer, sólo el que pueda ser hecho por vosotros. ");
INSERT INTO spablm_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Observaréis la fiesta de los panes sin levadura, porque en este mismo día he sacado vuestros ejércitos de la tierra de Egipto. Por lo tanto, observaréis este día a lo largo de vuestras generaciones como una ordenanza para siempre. ");
INSERT INTO spablm_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","En el primer mes, el día catorce del mes por la tarde, comeréis panes sin levadura, hasta el día veintiuno del mes por la tarde. ");
INSERT INTO spablm_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","No se hallará levadura en vuestras casas durante siete días, porque el que coma algo leudado será eliminado de la congregación de Israel, ya sea extranjero o nacido en el país. ");
INSERT INTO spablm_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","No comeréis nada con levadura. En todas vuestras moradas comeréis panes sin levadura”. ");
INSERT INTO spablm_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Entonces Moisés llamó a todos los ancianos de Israel y les dijo: “Sacad y tomad corderos según vuestras familias y matad la Pascua. ");
INSERT INTO spablm_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Tomaréis un manojo de hisopo y lo mojaréis en la sangre que está en la pila, y golpearéis el dintel y los dos postes de la puerta con la sangre que está en la pila. Ninguno de ustedes saldrá de la puerta de su casa hasta la mañana. ");
INSERT INTO spablm_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Porque Yahvé pasará para herir a los egipcios; y cuando vea la sangre en el dintel y en los dos postes de la puerta, Yahvé pasará por encima de la puerta, y no permitirá que el destructor entre en vuestras casas para heriros. ");
INSERT INTO spablm_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Observaréis esto como una ordenanza para vosotros y para vuestros hijos para siempre. ");
INSERT INTO spablm_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Sucederá que cuando lleguéis a la tierra que Yahvé os dará, como ha prometido, guardaréis este servicio. ");
INSERT INTO spablm_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Sucederá que cuando vuestros hijos os pregunten: “¿Qué queréis decir con este servicio?” ");
INSERT INTO spablm_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Diréis: “Es el sacrificio de la Pascua de Yahvé, que pasó por encima de las casas de los hijos de Israel en Egipto, cuando hirió a los egipcios y perdonó nuestras casas.” El pueblo inclinó la cabeza y adoró. ");
INSERT INTO spablm_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Los hijos de Israel fueron y lo hicieron; como Yahvé había ordenado a Moisés y a Aarón, así lo hicieron. ");
INSERT INTO spablm_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","A medianoche, el Señor hirió a todos los primogénitos en la tierra de Egipto, desde el primogénito del faraón que se sentaba en su trono hasta el primogénito del cautivo que estaba en el calabozo, y a todos los primogénitos del ganado. ");
INSERT INTO spablm_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","El faraón se levantó por la noche, él y todos sus siervos, y todos los egipcios; y hubo un gran clamor en Egipto, pues no había casa donde no hubiera un muerto. ");
INSERT INTO spablm_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Llamó de noche a Moisés y a Aarón y les dijo: “¡Levántense, salgan de entre mi pueblo, ustedes y los hijos de Israel, y vayan a servir a Yahvé, como han dicho! ");
INSERT INTO spablm_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Tomen sus rebaños y sus manadas, como han dicho, y váyanse; ¡y bendecidme también a mí!” ");
INSERT INTO spablm_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Los egipcios estaban urgidos con el pueblo, para enviarlo fuera de la tierra a toda prisa, pues decían: “Todos somos hombres muertos”. ");
INSERT INTO spablm_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","El pueblo tomó su masa antes de que fuera leudada, con sus amasadoras atadas a sus ropas sobre los hombros. ");
INSERT INTO spablm_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Los hijos de Israel hicieron conforme a la palabra de Moisés, y pidieron a los egipcios joyas de plata, joyas de oro y ropa. ");
INSERT INTO spablm_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","El Señor le concedió al pueblo el favor de los egipcios, de modo que les permitieron tener lo que pedían. Saquearon a los egipcios. ");
INSERT INTO spablm_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Los hijos de Israel viajaron de Ramesés a Sucot, unos seiscientos mil a pie que eran hombres, además de los niños. ");
INSERT INTO spablm_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","También subió con ellos una multitud mixta, con rebaños, manadas y mucho ganado. ");
INSERT INTO spablm_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Con la masa que habían sacado de Egipto cocinaban tortas sin levadura, pues no estaba leudada, porque habían sido expulsados de Egipto y no podían esperar, y no habían preparado ningún alimento para ellos. ");
INSERT INTO spablm_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","El tiempo que los hijos de Israel vivieron en Egipto fue de cuatrocientos treinta años. ");
INSERT INTO spablm_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Al final de los cuatrocientos treinta años, hasta el día de hoy, todos los ejércitos de Yahvé salieron de la tierra de Egipto. ");
INSERT INTO spablm_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Es una noche que hay que observar mucho a Yahvé por haberlos sacado de la tierra de Egipto. Esta es la noche de Yahvé, que debe ser muy observada por todos los hijos de Israel a lo largo de sus generaciones. ");
INSERT INTO spablm_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","El Señor dijo a Moisés y a Aarón: “Esta es la ordenanza de la Pascua. Ningún extranjero comerá de ella, ");
INSERT INTO spablm_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","pero el siervo de todo hombre comprado por dinero, cuando lo hayas circuncidado, entonces comerá de ella. ");
INSERT INTO spablm_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","El extranjero y el jornalero no comerán de ella. ");
INSERT INTO spablm_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Debe comerse en una sola casa. No llevarás nada de la carne fuera de la casa. No rompas ninguno de sus huesos. ");
INSERT INTO spablm_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Toda la congregación de Israel la guardará. ");
INSERT INTO spablm_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Cuando un extranjero viva con vosotros como forastero y quiera celebrar la Pascua a Yahvé, que se circunciden todos sus varones, y entonces que se acerque y la celebre. Será como uno de los nacidos en la tierra; pero ningún incircunciso podrá comer de ella. ");
INSERT INTO spablm_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Una misma ley será para el nacido en casa, y para el extranjero que vive como forastero entre vosotros.” ");
INSERT INTO spablm_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Así lo hicieron todos los hijos de Israel. Como Yahvé les ordenó a Moisés y a Aarón, así lo hicieron. ");
INSERT INTO spablm_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Ese mismo día, Yahvé sacó a los hijos de Israel de la tierra de Egipto con sus ejércitos. ");
INSERT INTO spablm_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Santifícame a todos los primogénitos, todo lo que abre el vientre entre los hijos de Israel, tanto de los hombres como de los animales. Es mío”. ");
INSERT INTO spablm_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Moisés dijo al pueblo: “Acuérdate de este día en que saliste de Egipto, de la casa de servidumbre, porque con la fuerza de tu mano Yahvé te sacó de este lugar. No se comerá pan con levadura. ");
INSERT INTO spablm_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Hoy salís en el mes de Abib. ");
INSERT INTO spablm_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Cuando Yahvé os lleve a la tierra del cananeo, del hitita, del amorreo, del heveo y del jebuseo, que juró a vuestros padres que os daría, una tierra que mana leche y miel, celebraréis este servicio en este mes. ");
INSERT INTO spablm_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Durante siete días comeréis panes sin levadura, y el séptimo día será una fiesta para Yahvé. ");
INSERT INTO spablm_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Durante los siete días comeréis panes sin levadura, y no se verá con vosotros ningún pan con levadura. No se verá levadura con vosotros, dentro de todas vuestras fronteras. ");
INSERT INTO spablm_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Ese día le dirás a tu hijo: ‘Es por lo que hizo el Señor por mí cuando salí de Egipto’. ");
INSERT INTO spablm_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Te servirá de señal en tu mano, y de recuerdo entre tus ojos, para que la ley de Yahvé esté en tu boca; porque con mano fuerte Yahvé te sacó de Egipto. ");
INSERT INTO spablm_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Por lo tanto, guardarás esta ordenanza en su temporada de año en año. ");
INSERT INTO spablm_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Cuando Yahvé os introduzca en la tierra de los cananeos, como os juró a vosotros y a vuestros padres, y os la entregue, ");
INSERT INTO spablm_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","apartaréis para Yahvé todo lo que abra el vientre, y todo primogénito que proceda de un animal que tengáis. Los machos serán de Yahvé. ");
INSERT INTO spablm_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Todo primogénito de asno lo redimirás con un cordero; y si no lo quieres redimir, le romperás el cuello; y redimirás todo primogénito de hombre entre tus hijos. ");
INSERT INTO spablm_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Cuando tu hijo te pregunte en el futuro, diciendo: “¿Qué es esto?”, le dirás: “Con la fuerza de la mano, Yahvé nos sacó de Egipto, de la casa de servidumbre. ");
INSERT INTO spablm_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Cuando el faraón se negó obstinadamente a dejarnos ir, el Señor mató a todos los primogénitos en la tierra de Egipto, tanto a los primogénitos de los hombres como a los primogénitos de los animales. Por eso sacrifico a Yahvé todo lo que abre el vientre, siendo varones; pero a todos los primogénitos de mis hijos los redimo’. ");
INSERT INTO spablm_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Será como una señal en tu mano y como un símbolo entre tus ojos, porque con la fuerza de la mano Yahvé nos sacó de Egipto.” ");
INSERT INTO spablm_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Cuando el faraón dejó ir al pueblo, Dios no lo condujo por el camino de la tierra de los filisteos, aunque estaba cerca; porque Dios dijo: “No sea que el pueblo cambie de opinión al ver la guerra, y vuelva a Egipto”; ");
INSERT INTO spablm_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","sino que Dios condujo al pueblo por el camino del desierto, junto al Mar Rojo; y los hijos de Israel subieron armados de la tierra de Egipto. ");
INSERT INTO spablm_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Moisés llevó consigo los huesos de José, porque había hecho jurar a los hijos de Israel, diciendo: “Ciertamente Dios os visitará, y llevaréis con vosotros mis huesos.” ");
INSERT INTO spablm_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Partieron de Sucot y acamparon en Etam, en el límite del desierto. ");
INSERT INTO spablm_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Yahvé iba delante de ellos de día en una columna de nube, para guiarlos en su camino, y de noche en una columna de fuego, para alumbrarles, para que pudieran ir de día y de noche: ");
INSERT INTO spablm_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","la columna de nube de día, y la columna de fuego de noche, no se apartaban de delante del pueblo. ");
INSERT INTO spablm_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Habla a los hijos de Israel para que regresen y acampen frente a Pihahirot, entre Migdol y el mar, frente a Baal Zefon. Acamparán frente a ella, junto al mar. ");
INSERT INTO spablm_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","El Faraón dirá de los hijos de Israel: ‘Están enredados en la tierra. El desierto los ha encerrado’. ");
INSERT INTO spablm_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Endureceré el corazón del faraón y los seguirá, y obtendré honor sobre el faraón y sobre todos sus ejércitos, y los egipcios sabrán que yo soy Yahvé.” Así lo hicieron. ");
INSERT INTO spablm_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","El rey de Egipto recibió la noticia de que el pueblo había huido; y el corazón del faraón y de sus siervos se transformó hacia el pueblo, y dijeron: “¿Qué es lo que hemos hecho, que hemos dejado que Israel deje de servirnos?” ");
INSERT INTO spablm_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Preparó su carro, y tomó su ejército con él; ");
INSERT INTO spablm_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","y tomó seiscientos carros escogidos, y todos los carros de Egipto, con capitanes sobre todos ellos. ");
INSERT INTO spablm_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","El Señor endureció el corazón del faraón, rey de Egipto, y persiguió a los hijos de Israel; porque los hijos de Israel salieron con la mano en alto. ");
INSERT INTO spablm_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Los egipcios los persiguieron. Todos los caballos y carros del Faraón, su caballería y su ejército los alcanzaron acampando junto al mar, junto a Pihahirot, ante Baal Zefon. ");
INSERT INTO spablm_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Cuando el faraón se acercó, los hijos de Israel alzaron los ojos y vieron que los egipcios marchaban tras ellos, y tuvieron mucho miedo. Los hijos de Israel clamaron a Yahvé. ");
INSERT INTO spablm_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Le dijeron a Moisés: “Porque no había tumbas en Egipto, ¿nos has llevado a morir al desierto? ¿Por qué nos has tratado así, para sacarnos de Egipto? ");
INSERT INTO spablm_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","¿No es ésta la palabra que te dijimos en Egipto: ‘Déjanos en paz, para que sirvamos a los egipcios’? Porque hubiera sido mejor para nosotros servir a los egipcios que morir en el desierto”. ");
INSERT INTO spablm_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Moisés dijo al pueblo: “No tengan miedo. Quédense quietos y vean la salvación de Yahvé, que él obrará hoy en favor de ustedes; porque nunca más verán a los egipcios que han visto hoy. ");
INSERT INTO spablm_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Yahvé luchará por ustedes, y ustedes se quedarán quietos”. ");
INSERT INTO spablm_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","El Señor dijo a Moisés: “¿Por qué clamas a mí? Habla a los hijos de Israel para que avancen. ");
INSERT INTO spablm_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Levanta tu vara, extiende tu mano sobre el mar y divídelo. Entonces los hijos de Israel entrarán en medio del mar sobre tierra seca. ");
INSERT INTO spablm_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","He aquí que yo mismo endureceré el corazón de los egipcios, y entrarán tras ellos. Yo mismo obtendré honor sobre el Faraón y sobre todos sus ejércitos, sobre sus carros y sobre su caballería. ");
INSERT INTO spablm_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Los egipcios sabrán que yo soy Yahvé cuando me haya ganado el honor sobre el Faraón, sobre sus carros y sobre su caballería.” ");
INSERT INTO spablm_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","El ángel de Dios, que iba delante del campamento de Israel, se movió y fue detrás de ellos; y la columna de nube se movió de delante de ellos y se puso detrás de ellos. ");
INSERT INTO spablm_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Se interpuso entre el campamento de Egipto y el campamento de Israel. Allí estaba la nube y las tinieblas, pero daba luz de noche. Uno no se acercó al otro en toda la noche. ");
INSERT INTO spablm_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Moisés extendió su mano sobre el mar, y el Señor hizo retroceder el mar con un fuerte viento del este durante toda la noche, e hizo que el mar se secara, y las aguas se dividieron. ");
INSERT INTO spablm_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Los hijos de Israel entraron en medio del mar, en seco, y las aguas les sirvieron de muro a su derecha y a su izquierda. ");
INSERT INTO spablm_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Los egipcios los persiguieron y entraron tras ellos en medio del mar: todos los caballos del faraón, sus carros y su caballería. ");
INSERT INTO spablm_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","En la vigilia de la mañana, el Señor miró al ejército egipcio a través de la columna de fuego y de nube, y confundió al ejército egipcio. ");
INSERT INTO spablm_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Les quitó las ruedas de los carros, y los hizo caer pesadamente, de modo que los egipcios dijeron: “¡Huyamos de la faz de Israel, porque Yahvé lucha por ellos contra los egipcios!” ");
INSERT INTO spablm_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Yahvé dijo a Moisés: “Extiende tu mano sobre el mar, para que las aguas vuelvan a caer sobre los egipcios, sobre sus carros y sobre su caballería.” ");
INSERT INTO spablm_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Moisés extendió su mano sobre el mar, y el mar volvió a su fuerza cuando apareció la mañana, y los egipcios huyeron contra él. El Señor derrotó a los egipcios en medio del mar. ");
INSERT INTO spablm_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Las aguas volvieron a cubrir los carros y la gente de a caballo, así como todo el ejército del faraón que entró tras ellos en el mar. No quedó ni uno solo de ellos. ");
INSERT INTO spablm_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Pero los hijos de Israel caminaban en seco en medio del mar, y las aguas eran un muro para ellos a su derecha y a su izquierda. ");
INSERT INTO spablm_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Así salvó Yahvé a Israel aquel día de la mano de los egipcios; e Israel vio a los egipcios muertos en la orilla del mar. ");
INSERT INTO spablm_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Israel vio la gran obra que Yahvé hizo a los egipcios, y el pueblo temió a Yahvé; y creyeron en Yahvé y en su siervo Moisés. ");
INSERT INTO spablm_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Entonces Moisés y los hijos de Israel entonaron este cántico a Yahvé, y dijeron “Cantaré a Yahvé, porque ha triunfado gloriosamente. Ha arrojado al mar al caballo y a su jinete. ");
INSERT INTO spablm_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Yah es mi fuerza y mi canción. Se ha convertido en mi salvación. Este es mi Dios, y lo alabaré; el Dios de mi padre, y lo exaltaré. ");
INSERT INTO spablm_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Yahvé es un hombre de guerra. Yahvé es su nombre. ");
INSERT INTO spablm_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Ha arrojado al mar los carros del Faraón y su ejército. Sus capitanes elegidos se hunden en el Mar Rojo. ");
INSERT INTO spablm_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Las profundidades los cubren. Bajaron a las profundidades como una piedra. ");
INSERT INTO spablm_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Tu mano derecha, Yahvé, es gloriosa en poder. Tu mano derecha, Yahvé, hace pedazos al enemigo. ");
INSERT INTO spablm_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","En la grandeza de tu excelencia, derrotas a los que se levantan contra ti. Envías tu ira. Los consume como rastrojo. ");
INSERT INTO spablm_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Con el soplo de tus narices, las aguas se amontonaron. Las inundaciones se levantaron como un montón. Las profundidades se congelaron en el corazón del mar. ");
INSERT INTO spablm_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","El enemigo dijo: “Voy a perseguir. Voy a alcanzarlo. Repartiré el botín. Mi deseo será satisfecho en ellos. Sacaré mi espada. Mi mano los destruirá”. ");
INSERT INTO spablm_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Soplaste con tu viento. El mar los cubrió. Se hundieron como el plomo en las poderosas aguas. ");
INSERT INTO spablm_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","¿Quién es como tú, Yahvé, entre los dioses? Que es como tú, glorioso en santidad, temeroso en las alabanzas, haciendo maravillas? ");
INSERT INTO spablm_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Extendiste tu mano derecha. La tierra se los tragó. ");
INSERT INTO spablm_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","“Tú, en tu amorosa bondad, has guiado al pueblo que has redimido. Los has guiado con tu fuerza hacia tu santa morada. ");
INSERT INTO spablm_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Los pueblos han oído. Tiemblan. Los dolores se han apoderado de los habitantes de Filistea. ");
INSERT INTO spablm_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Entonces los jefes de Edom quedaron consternados. El temblor se apodera de los poderosos hombres de Moab. Todos los habitantes de Canaán se han derretido. ");
INSERT INTO spablm_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","El terror y el pavor caen sobre ellos. Por la grandeza de tu brazo están tan quietos como una piedra, hasta que tu pueblo pase, Yahvé, hasta que pasen las personas que has comprado. ");
INSERT INTO spablm_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Los traerás y los plantarás en el monte de tu heredad, el lugar, Yahvé, que te has hecho para habitar: el santuario, Señor, que tus manos han establecido. ");
INSERT INTO spablm_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Yahvé reinará por los siglos de los siglos”. ");
INSERT INTO spablm_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Porque los caballos del faraón entraron con sus carros y con su gente de a caballo en el mar, y el Señor hizo volver las aguas del mar sobre ellos; pero los hijos de Israel caminaron en seco en medio del mar. ");
INSERT INTO spablm_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","La profetisa Miriam, hermana de Aarón, tomó un pandero en su mano, y todas las mujeres salieron tras ella con panderos y danzas. ");
INSERT INTO spablm_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miriam les respondió, “Cantad a Yahvé, porque ha triunfado gloriosamente. Ha arrojado al mar al caballo y a su jinete”. ");
INSERT INTO spablm_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Moisés condujo a Israel desde el Mar Rojo, y salieron al desierto de Shur; anduvieron tres días por el desierto y no encontraron agua. ");
INSERT INTO spablm_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Cuando llegaron a Mara, no pudieron beber de las aguas de Mara, porque eran amargas. Por eso su nombre fue llamado Mara. ");
INSERT INTO spablm_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","El pueblo murmuró contra Moisés, diciendo: “¿Qué vamos a beber?” ");
INSERT INTO spablm_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Entonces él clamó a Yahvé. Yahvé le mostró un árbol, y él lo arrojó a las aguas, y las aguas se endulzaron. Allí les hizo un estatuto y una ordenanza, y allí los puso a prueba. ");
INSERT INTO spablm_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Les dijo: “Si escucháis con diligencia la voz del Señor, vuestro Dios, y hacéis lo que es justo a sus ojos, y prestáis atención a sus mandamientos y guardáis todos sus estatutos, no pondré sobre vosotros ninguna de las enfermedades que puse sobre los egipcios, porque yo soy el Señor que os sana.” ");
INSERT INTO spablm_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Llegaron a Elim, donde había doce fuentes de agua y setenta palmeras. Allí acamparon junto a las aguas. ");
INSERT INTO spablm_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Partieron de Elim, y toda la congregación de los hijos de Israel llegó al desierto de Sin, que está entre Elim y Sinaí, el día quince del segundo mes después de su salida de la tierra de Egipto. ");
INSERT INTO spablm_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Toda la congregación de los hijos de Israel murmuró contra Moisés y contra Aarón en el desierto; ");
INSERT INTO spablm_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","y los hijos de Israel les dijeron: “Ojalá hubiéramos muerto por mano de Yahvé en la tierra de Egipto, cuando nos sentábamos junto a las ollas de carne, cuando nos saciábamos de pan, porque ustedes nos han traído a este desierto para matar de hambre a toda esta asamblea.” ");
INSERT INTO spablm_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Entonces Yahvé dijo a Moisés: “He aquí que yo haré llover pan del cielo para ustedes, y el pueblo saldrá a recoger la porción de un día cada día, para que yo los pruebe, si andan o no en mi ley. ");
INSERT INTO spablm_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Al sexto día prepararán lo que traigan, y será el doble de lo que recojan cada día.” ");
INSERT INTO spablm_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Moisés y Aarón dijeron a todos los hijos de Israel: “Al anochecer, sabrán que el Señor los ha sacado de la tierra de Egipto. ");
INSERT INTO spablm_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Por la mañana, verán la gloria de Yahvé, porque él escucha sus murmuraciones contra Yahvé. ¿Quiénes somos nosotros, para que murmuren contra nosotros?” ");
INSERT INTO spablm_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Moisés dijo: “Ahora Yahvé os dará de comer por la tarde, y por la mañana pan para saciaros, porque Yahvé oye vuestras murmuraciones, que vosotros murmuráis contra él. ¿Y quiénes somos nosotros? Sus murmuraciones no son contra nosotros, sino contra Yahvé”. ");
INSERT INTO spablm_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Moisés le dijo a Aarón: “Dile a toda la congregación de los hijos de Israel que se acerque a Yahvé, porque él ha escuchado sus murmuraciones”. ");
INSERT INTO spablm_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Mientras Aarón hablaba a toda la congregación de los hijos de Israel, miraron hacia el desierto, y he aquí que la gloria de Yahvé apareció en la nube. ");
INSERT INTO spablm_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Yahvé habló a Moisés diciendo: ");
INSERT INTO spablm_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“He oído las murmuraciones de los hijos de Israel. Háblales diciendo: ‘Al atardecer comeréis carne, y por la mañana os saciaréis de pan. Entonces sabrán que yo soy Yahvé, vuestro Dios’”. ");
INSERT INTO spablm_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Al atardecer, las codornices subieron y cubrieron el campamento; y por la mañana el rocío se posó alrededor del campamento. ");
INSERT INTO spablm_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Cuando el rocío que había caído se desvaneció, he aquí que en la superficie del desierto había una cosa pequeña y redonda, pequeña como la escarcha del suelo. ");
INSERT INTO spablm_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Cuando los hijos de Israel lo vieron, se dijeron unos a otros: “¿Qué es?” Porque no sabían lo que era. Moisés les dijo: “Es el pan que el Señor les ha dado para comer. ");
INSERT INTO spablm_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Esto es lo que Yahvé ha ordenado: ‘Recoged de él cada uno según su consumo; un omer por cabeza, según el número de vuestras personas, lo tomaréis, cada uno para los que están en su tienda’.” ");
INSERT INTO spablm_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Los hijos de Israel lo hicieron así, y unos recogieron más y otros menos. ");
INSERT INTO spablm_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Cuando lo midieron con un omer, al que recogió mucho no le sobró nada, y al que recogió poco no le faltó. Cada uno recogió según lo que comía. ");
INSERT INTO spablm_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Moisés les dijo: “Que nadie deje nada de ello mañana”. ");
INSERT INTO spablm_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Pero no escucharon a Moisés, sino que algunos de ellos dejaron parte de ella hasta la mañana, de modo que criaba gusanos y apestaba; y Moisés se enojó con ellos. ");
INSERT INTO spablm_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Lo recogieron de mañana en mañana, cada uno según su consumo. Cuando el sol se calentó, se derritió. ");
INSERT INTO spablm_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Al sexto día, recogieron el doble de pan, dos omers para cada uno; y todos los jefes de la congregación vinieron a decírselo a Moisés. ");
INSERT INTO spablm_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Este les dijo: “Esto es lo que ha dicho el Señor: ‘Mañana es un descanso solemne, un sábado sagrado para el Señor. Horneen lo que quieran hornear, y hiervan lo que quieran hervir; y todo lo que sobre lo guarden hasta la mañana’”. ");
INSERT INTO spablm_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Lo guardaron hasta la mañana, tal como lo ordenó Moisés, y no se ensució, ni hubo gusanos en él. ");
INSERT INTO spablm_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Moisés dijo: “Coman eso hoy, porque hoy es sábado para Yahvé. Hoy no lo encontrarás en el campo. ");
INSERT INTO spablm_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Seis días lo recogerás, pero el séptimo día es sábado. En él no habrá nada”. ");
INSERT INTO spablm_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","El séptimo día, algunos del pueblo salieron a recoger, y no encontraron nada. ");
INSERT INTO spablm_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Yahvé dijo a Moisés: “¿Hasta cuándo os negáis a cumplir mis mandamientos y mis leyes? ");
INSERT INTO spablm_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Miren, porque Yahvé les ha dado el sábado, por eso les da en el sexto día el pan de dos días. Que cada uno se quede en su lugar. Que nadie salga de su lugar en el séptimo día”. ");
INSERT INTO spablm_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Así que el pueblo descansó el séptimo día. ");
INSERT INTO spablm_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","La casa de Israel lo llamó “Maná”, y era como semilla de cilantro, blanco; y su sabor era como de obleas con miel. ");
INSERT INTO spablm_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Moisés dijo: “Esto es lo que Yahvé ha ordenado: ‘Guarden un omer lleno de él a lo largo de sus generaciones, para que vean el pan con el que los alimenté en el desierto, cuando los saqué de la tierra de Egipto’”. ");
INSERT INTO spablm_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Moisés le dijo a Aarón: “Toma una vasija y pon en ella un omer lleno de maná, y guárdalo delante de Yahvé, para que lo guarden a lo largo de sus generaciones.” ");
INSERT INTO spablm_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Tal como Yahvé le ordenó a Moisés, Aarón lo depositó ante el Testimonio, para que se conservara. ");
INSERT INTO spablm_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Los hijos de Israel comieron el maná durante cuarenta años, hasta que llegaron a una tierra habitada. Comieron el maná hasta que llegaron a los límites de la tierra de Canaán. ");
INSERT INTO spablm_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Un omeres la décima parte de un efa. ");
INSERT INTO spablm_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Toda la congregación de los hijos de Israel partió del desierto de Sin, siguiendo el mandato de Yahvé, y acampó en Refidim; pero no había agua para que el pueblo bebiera. ");
INSERT INTO spablm_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Por eso el pueblo discutió con Moisés y le dijo: “Danos agua para beber”. Moisés les dijo: “¿Por qué os peleáis conmigo? ¿Por qué ponéis a prueba a Yahvé?” ");
INSERT INTO spablm_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","El pueblo estaba sediento de agua allí; por eso el pueblo murmuró contra Moisés y dijo: “¿Por qué nos has hecho subir de Egipto para matarnos de sed a nosotros, a nuestros hijos y a nuestro ganado?” ");
INSERT INTO spablm_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Moisés clamó a Yahvé diciendo: “¿Qué debo hacer con este pueblo? Están casi listos para apedrearme”. ");
INSERT INTO spablm_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Yahvé dijo a Moisés: “Camina delante del pueblo, y lleva contigo a los ancianos de Israel, y toma en tu mano la vara con la que golpeaste el Nilo, y vete. ");
INSERT INTO spablm_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","He aquí que yo me pondré delante de ti allí, en la roca de Horeb. Golpearás la roca y saldrá agua de ella, para que el pueblo pueda beber”. Así lo hizo Moisés a la vista de los ancianos de Israel. ");
INSERT INTO spablm_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Llamó el nombre del lugar Massah, y Meribah, porque los hijos de Israel se peleaban y porque ponían a prueba a Yahvé, diciendo: “¿Está Yahvé entre nosotros o no?” ");
INSERT INTO spablm_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Entonces vino Amalec y peleó contra Israel en Refidim. ");
INSERT INTO spablm_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Moisés dijo a Josué: “Escoge hombres para nosotros y sal a pelear con Amalec. Mañana estaré en la cima de la colina con la vara de Dios en la mano”. ");
INSERT INTO spablm_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Así que Josué hizo lo que Moisés le había dicho, y luchó contra Amalec; y Moisés, Aarón y Hur subieron a la cima de la colina. ");
INSERT INTO spablm_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Cuando Moisés levantó la mano, Israel venció. Cuando bajó su mano, Amalec prevaleció. ");
INSERT INTO spablm_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Pero a Moisés le pesaban las manos, así que tomaron una piedra y la pusieron debajo de él, y se sentó sobre ella. Aarón y Hur le sostuvieron las manos, el uno de un lado y el otro del otro. Sus manos estuvieron firmes hasta la puesta del sol. ");
INSERT INTO spablm_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Josué derrotó a Amalec y a su pueblo a filo de espada. ");
INSERT INTO spablm_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Yahvé dijo a Moisés: “Escribe esto como recuerdo en un libro, y recuérdalo en los oídos de Josué: que borraré por completo la memoria de Amalec de debajo del cielo.” ");
INSERT INTO spablm_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Moisés construyó un altar y lo llamó “Yahvé, nuestro estandarte”. ");
INSERT INTO spablm_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Dijo: “Yah ha jurado: ‘Yahvé tendrá guerra con Amalec de generación en generación’.” ");
INSERT INTO spablm_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Jetro, el sacerdote de Madián, suegro de Moisés, se enteró de todo lo que Dios había hecho por Moisés y por su pueblo Israel, de cómo Yahvé había sacado a Israel de Egipto. ");
INSERT INTO spablm_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Jetro, suegro de Moisés, recibió a Séfora, la esposa de Moisés, después de haberla despedido, ");
INSERT INTO spablm_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","y a sus dos hijos. El nombre de un hijo era Gershom, porque Moisés dijo: “He vivido como extranjero en tierra extranjera”. ");
INSERT INTO spablm_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","El nombre del otro fue Eliezer, pues dijo: “El Dios de mi padre fue mi ayuda y me libró de la espada del Faraón”. ");
INSERT INTO spablm_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Jetro, el suegro de Moisés, vino con los hijos de Moisés y su esposa a Moisés al desierto, donde estaba acampado, en la Montaña de Dios. ");
INSERT INTO spablm_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Le dijo a Moisés: “Yo, tu suegro Jetro, he venido a ti con tu mujer y sus dos hijos con ella.” ");
INSERT INTO spablm_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Moisés salió al encuentro de su suegro, se inclinó y lo besó. Se preguntaron mutuamente por su bienestar, y entraron en la tienda. ");
INSERT INTO spablm_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Moisés le contó a su suegro todo lo que Yahvé había hecho al faraón y a los egipcios por causa de Israel, todas las dificultades que les habían sobrevenido en el camino, y cómo Yahvé los había librado. ");
INSERT INTO spablm_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Jetro se alegró de toda la bondad que Yahvé había hecho con Israel, al librarlo de la mano de los egipcios. ");
INSERT INTO spablm_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Jetro dijo: “Bendito sea Yahvé, que te ha librado de la mano de los egipcios y de la mano del faraón; que ha librado al pueblo de la mano de los egipcios. ");
INSERT INTO spablm_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Ahora sé que Yahvé es más grande que todos los dioses, por la forma en que trataron al pueblo con arrogancia.” ");
INSERT INTO spablm_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Jetro, suegro de Moisés, llevó un holocausto y sacrificios para Dios. Aarón vino con todos los ancianos de Israel, para comer el pan con el suegro de Moisés ante Dios. ");
INSERT INTO spablm_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Al día siguiente, Moisés se sentó a juzgar al pueblo, y el pueblo estuvo de pie alrededor de Moisés desde la mañana hasta la noche. ");
INSERT INTO spablm_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Cuando el suegro de Moisés vio todo lo que hacía con el pueblo, le dijo: “¿Qué es esto que haces por el pueblo? ¿Por qué te sientas solo, y todo el pueblo está de pie a tu alrededor desde la mañana hasta la noche?” ");
INSERT INTO spablm_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Moisés dijo a su suegro: “Porque el pueblo viene a mí para consultar a Dios. ");
INSERT INTO spablm_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Cuando tienen un asunto, vienen a mí, y yo juzgo entre el hombre y su prójimo, y les hago conocer los estatutos de Dios y sus leyes.” ");
INSERT INTO spablm_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","El suegro de Moisés le dijo: “Lo que haces no es bueno. ");
INSERT INTO spablm_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Seguramente te desgastarás, tanto tú como este pueblo que está contigo, porque la cosa es demasiado pesada para ti. No eres capaz de realizarlo tú solo. ");
INSERT INTO spablm_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Escucha ahora mi voz. Yo te aconsejaré, y Dios estará contigo. Tú representas al pueblo ante Dios, y llevas las causas a Dios. ");
INSERT INTO spablm_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Les enseñarás los estatutos y las leyes, y les mostrarás el camino por el que deben andar y el trabajo que deben hacer. ");
INSERT INTO spablm_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Además, proveerás de todo el pueblo hombres capaces y temerosos de Dios; hombres de verdad, que odien la ganancia injusta; y los pondrás al frente de ellos, para que sean jefes de millares, jefes de centenas, jefes de cincuenta y jefes de decenas. ");
INSERT INTO spablm_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Que juzguen al pueblo en todo momento. Todo asunto grande te lo traerán a ti, pero todo asunto pequeño lo juzgarán ellos mismos. Así te será más fácil, y ellos compartirán la carga contigo. ");
INSERT INTO spablm_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Si haces esto, y Dios te lo ordena, entonces podrás sostenerte, y toda esta gente también irá a su lugar en paz.” ");
INSERT INTO spablm_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Entonces Moisés escuchó la voz de su suegro, e hizo todo lo que él había dicho. ");
INSERT INTO spablm_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Moisés eligió a hombres capaces de todo Israel, y los nombró jefes del pueblo, jefes de millares, jefes de centenas, jefes de cincuenta y jefes de decenas. ");
INSERT INTO spablm_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Ellos juzgaban al pueblo en todo momento. Traían los casos difíciles a Moisés, pero todo asunto menor lo juzgaban ellos mismos. ");
INSERT INTO spablm_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Moisés dejó partir a su suegro y se fue a su tierra. ");
INSERT INTO spablm_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","En el tercer mes después que los hijos de Israel salieron de la tierra de Egipto, ese mismo día llegaron al desierto de Sinaí. ");
INSERT INTO spablm_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Cuando partieron de Refidim y llegaron al desierto de Sinaí, acamparon en el desierto, y allí acampó Israel ante el monte. ");
INSERT INTO spablm_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Moisés subió a Dios, y Yahvé lo llamó desde el monte, diciendo: “Esto es lo que dirás a la casa de Jacob y a los hijos de Israel ");
INSERT INTO spablm_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Habéis visto lo que hice a los egipcios, y cómo os llevé en alas de águila y os traje a mí. ");
INSERT INTO spablm_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Ahora, pues, si de verdad obedecéis mi voz y guardáis mi pacto, seréis mi posesión de entre todos los pueblos, porque toda la tierra es mía; ");
INSERT INTO spablm_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","y seréis para mí un reino de sacerdotes y una nación santa.’ Estas son las palabras que dirás a los hijos de Israel”. ");
INSERT INTO spablm_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Moisés vino y llamó a los ancianos del pueblo, y les expuso todas estas palabras que Yahvé le había ordenado. ");
INSERT INTO spablm_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Todo el pueblo respondió en conjunto y dijo: “Haremos todo lo que Yahvé ha dicho”. Moisés informó a Yahvé de las palabras del pueblo. ");
INSERT INTO spablm_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Yahvé dijo a Moisés: “He aquí que vengo a ti en una nube espesa, para que el pueblo oiga cuando hablo contigo y te crea para siempre”. Moisés le contó a Yahvé las palabras del pueblo. ");
INSERT INTO spablm_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Yahvé dijo a Moisés: “Ve al pueblo y santifícalo hoy y mañana, y que lave sus vestidos, ");
INSERT INTO spablm_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","y esté preparado para el tercer día; porque al tercer día Yahvé bajará a la vista de todo el pueblo al monte Sinaí. ");
INSERT INTO spablm_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Pondrás límites a todo el pueblo, diciendo: ‘Tengan cuidado de no subir al monte ni tocar su borde. El que toque el monte será condenado a muerte. ");
INSERT INTO spablm_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Ninguna mano lo tocará, sino que será apedreado o atravesado; sea animal u hombre, no vivirá.’ Cuando la trompeta suene largamente, subirán al monte”. ");
INSERT INTO spablm_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Moisés bajó del monte hacia el pueblo y lo santificó, y ellos lavaron sus ropas. ");
INSERT INTO spablm_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Le dijo al pueblo: “Prepárense para el tercer día. No tengan relaciones sexuales con una mujer”. ");
INSERT INTO spablm_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Al tercer día, al amanecer, hubo truenos y relámpagos, y una espesa nube sobre la montaña, y el sonido de una trompeta muy fuerte; y todo el pueblo que estaba en el campamento tembló. ");
INSERT INTO spablm_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Moisés sacó al pueblo del campamento para ir al encuentro de Dios, y se paró en la parte baja del monte. ");
INSERT INTO spablm_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Todo el monte Sinaí humeaba, porque Yahvé descendía sobre él en fuego; y su humo subía como el humo de un horno, y todo el monte temblaba en gran manera. ");
INSERT INTO spablm_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Cuando el sonido de la trompeta se hizo más y más fuerte, Moisés habló, y Dios le respondió con una voz. ");
INSERT INTO spablm_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Yahvé bajó al monte Sinaí, a la cima de la montaña. Yahvé llamó a Moisés a la cima del monte, y Moisés subió. ");
INSERT INTO spablm_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Yahvé dijo a Moisés: “Baja y advierte al pueblo, no sea que se abran paso hacia Yahvé para mirar, y muchos de ellos perezcan. ");
INSERT INTO spablm_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Que también los sacerdotes que se acercan a Yahvé se santifiquen, no sea que Yahvé irrumpa sobre ellos.” ");
INSERT INTO spablm_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Moisés dijo a Yahvé: “El pueblo no puede subir al monte Sinaí, porque tú nos advertiste diciendo: “Poned límites alrededor del monte y santificadlo””. ");
INSERT INTO spablm_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Yahvé le dijo: “¡Baja! Harás subir a Aarón contigo, pero no permitas que los sacerdotes y el pueblo se abran paso para subir a Yahvé, no sea que él se revele contra ellos.” ");
INSERT INTO spablm_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Entonces Moisés bajó al pueblo y les dijo. ");
INSERT INTO spablm_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Dios pronunció todas estas palabras, diciendo: ");
INSERT INTO spablm_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Yo soy Yahvé, tu Dios, que te sacó de la tierra de Egipto, de la casa de servidumbre. ");
INSERT INTO spablm_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“No tendréis otros dioses delante de mí. ");
INSERT INTO spablm_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“No os haréis ningún ídolo, ni ninguna imagen de lo que está arriba en los cielos, ni abajo en la tierra, ni en las aguas debajo de la tierra: ");
INSERT INTO spablm_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","no os inclinaréis ante ellos, ni los serviréis, porque yo, Yahvé, vuestro Dios, soy un Dios celoso, que visita la iniquidad de los padres en los hijos, en la tercera y en la cuarta generación de los que me odian, ");
INSERT INTO spablm_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","y que muestra bondad amorosa a miles de los que me aman y guardan mis mandamientos. ");
INSERT INTO spablm_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“No harás mal uso del nombre de Yahvé, tu Dios, porque Yahvé no declarará inocente al que haga mal uso de su nombre. ");
INSERT INTO spablm_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Acuérdate del día de reposo para santificarlo. ");
INSERT INTO spablm_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Trabajarás seis días y harás todo tu trabajo, ");
INSERT INTO spablm_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","pero el séptimo día es sábado para Yahvé vuestro Dios. No harás ningún trabajo en él, ni tú, ni tu hijo, ni tu hija, ni tu siervo, ni tu sierva, ni tu ganado, ni tu extranjero que esté dentro de tus puertas; ");
INSERT INTO spablm_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","porque en seis días Yahvé hizo los cielos y la tierra, el mar y todo lo que hay en ellos, y descansó el séptimo día; por eso Yahvé bendijo el día de reposo y lo santificó. ");
INSERT INTO spablm_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Honra a tu padre y a tu madre, para que tus días se alarguen en la tierra que el Señor tu Dios te da. ");
INSERT INTO spablm_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“No matarás. ");
INSERT INTO spablm_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“No cometerás adulterio. ");
INSERT INTO spablm_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“No robarás. ");
INSERT INTO spablm_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“No darás falso testimonio contra tu prójimo. ");
INSERT INTO spablm_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“No codiciarás la casa de tu prójimo. No codiciarás la mujer de tu prójimo, ni su siervo, ni su sierva, ni su buey, ni su asno, ni nada que sea de tu prójimo”. ");
INSERT INTO spablm_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Todo el pueblo percibió los truenos, los relámpagos, el sonido de la trompeta y la montaña humeante. Al verlo, el pueblo tembló y se mantuvo a distancia. ");
INSERT INTO spablm_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Dijeron a Moisés: “Habla tú con nosotros, y te escucharemos; pero no dejes que Dios hable con nosotros, no sea que muramos.” ");
INSERT INTO spablm_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Moisés dijo al pueblo: “No tengan miedo, porque Dios ha venido a probarlos, y para que su temor esté ante ustedes, para que no pequen”. ");
INSERT INTO spablm_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","El pueblo se mantuvo a distancia, y Moisés se acercó a la espesa oscuridad donde estaba Dios. ");
INSERT INTO spablm_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","El Señor dijo a Moisés: “Esto es lo que les dirás a los hijos de Israel: ‘Ustedes mismos han visto que yo he hablado con ustedes desde el cielo. ");
INSERT INTO spablm_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","No os haréis dioses de plata ni dioses de oro para estar junto a mí. ");
INSERT INTO spablm_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Haréis un altar de tierra para mí, y sacrificaréis en él vuestros holocaustos y vuestras ofrendas de paz, vuestras ovejas y vuestros ganados. En todo lugar donde registre mi nombre vendré a ti y te bendeciré. ");
INSERT INTO spablm_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Si me haces un altar de piedra, no lo construirás de piedras cortadas; porque si alzas tu herramienta sobre él, lo habrás contaminado. ");
INSERT INTO spablm_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","No subirás por las escaleras a mi altar, para que tu desnudez no quede expuesta a él’. ");
INSERT INTO spablm_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Éstas son las ordenanzas que les pondrás delante: ");
INSERT INTO spablm_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“Si compras un siervo hebreo, servirá seis años, y al séptimo saldrá libre sin pagar nada. ");
INSERT INTO spablm_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Si entra solo, saldrá solo. Si está casado, su mujer saldrá con él. ");
INSERT INTO spablm_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Si su amo le da una esposa y ella le da hijos o hijas, la esposa y sus hijos serán de su amo, y él saldrá solo. ");
INSERT INTO spablm_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Pero si el siervo dice claramente: “Amo a mi amo, a mi mujer y a mis hijos. No saldré libre;’ ");
INSERT INTO spablm_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","entonces su amo lo llevará a Dios, y lo traerá a la puerta o al poste de la puerta, y su amo le perforará la oreja con un punzón, y le servirá para siempre. ");
INSERT INTO spablm_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Si un hombre vende a su hija para que sea sierva, no saldrá como los siervos. ");
INSERT INTO spablm_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Si no le gusta a su amo, que la ha casado consigo, entonces la dejará rescatar. No tendrá derecho a venderla a un pueblo extranjero, ya que ha actuado con engaño con ella. ");
INSERT INTO spablm_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Si la casa con su hijo, la tratará como a una hija. ");
INSERT INTO spablm_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Si toma otra esposa para sí, no disminuirá su comida, su ropa ni sus derechos matrimoniales. ");
INSERT INTO spablm_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Si no hace estas tres cosas por ella, podrá quedar libre sin pagar nada. ");
INSERT INTO spablm_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“El que golpee a un hombre de modo que muera, será ciertamente condenado a muerte, ");
INSERT INTO spablm_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","pero no si es involuntario, sino que Dios permite que ocurra; entonces te designaré un lugar donde huirá. ");
INSERT INTO spablm_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Si un hombre trama y se acerca presuntuosamente a su prójimo para matarlo, lo sacarás de mi altar para que muera. ");
INSERT INTO spablm_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Cualquiera que ataque a su padre o a su madre será condenado a muerte. ");
INSERT INTO spablm_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Cualquiera que secuestre a alguien y lo venda, o si lo encuentra en su mano, será condenado a muerte. ");
INSERT INTO spablm_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Cualquiera que maldiga a su padre o a su madre será condenado a muerte. ");
INSERT INTO spablm_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Si los hombres riñen y uno golpea al otro con una piedra o con su puño, y no muere, sino que queda confinado en la cama; ");
INSERT INTO spablm_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","si se levanta de nuevo y camina con su bastón, entonces el que lo golpeó quedará libre de culpa; sólo que pagará por la pérdida de su tiempo, y proveerá a su curación hasta que esté completamente curado. ");
INSERT INTO spablm_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Si un hombre golpea a su siervo o a su sierva con una vara, y éste muere bajo su mano, el hombre será castigado. ");
INSERT INTO spablm_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Sin embargo, si su siervo se levanta después de uno o dos días, no será castigado, porque el siervo es de su propiedad. ");
INSERT INTO spablm_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Si los hombres pelean y hieren a una mujer embarazada de modo que dé a luz prematuramente, y sin embargo no se produce ningún daño, se le impondrá la multa que el marido de la mujer exija y los jueces permitan. ");
INSERT INTO spablm_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Pero si se produce algún daño, entonces hay que quitar vida por vida, ");
INSERT INTO spablm_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","ojo por ojo, diente por diente, mano por mano, pie por pie, ");
INSERT INTO spablm_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","quemadura por quemadura, herida por herida y contusión por contusión. ");
INSERT INTO spablm_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Si un hombre golpea el ojo de su siervo o de su sierva y lo destruye, lo dejará libre por su ojo. ");
INSERT INTO spablm_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Si golpea el diente de su siervo o de su sierva, lo dejará libre por su diente. ");
INSERT INTO spablm_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Si un toro mata a un hombre o a una mujer de una cornada, el toro será apedreado y su carne no se comerá; pero el dueño del toro no será responsable. ");
INSERT INTO spablm_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Pero si el toro ha tenido la costumbre de cornear en el pasado, y esto ha sido atestiguado a su dueño, y éste no lo ha guardado, pero ha matado a un hombre o a una mujer, el toro será apedreado, y su dueño también será condenado a muerte. ");
INSERT INTO spablm_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Si se le impone un rescate, deberá dar por la redención de su vida lo que se le imponga. ");
INSERT INTO spablm_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Tanto si ha corneado a un hijo como si ha corneado a una hija, según este juicio se hará con él. ");
INSERT INTO spablm_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Si el toro cornea a un siervo o a una sierva, se darán treinta siclos de plata a su amo, y el buey será apedreado. ");
INSERT INTO spablm_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Si un hombre abre una fosa, o si un hombre cava una fosa y no la cubre, y un toro o un asno cae en ella, ");
INSERT INTO spablm_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","el dueño de la fosa deberá repararla. Dará dinero a su dueño, y el animal muerto será suyo. ");
INSERT INTO spablm_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Si el toro de un hombre hiere al de otro, de modo que muera, entonces venderán el toro vivo y dividirán su precio; y también dividirán el animal muerto. ");
INSERT INTO spablm_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","O si se sabe que el toro tenía la costumbre de corneado en el pasado, y su dueño no lo ha guardado, pagará ciertamente toro por toro, y el animal muerto será suyo. ");
INSERT INTO spablm_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Si un hombre roba un buey o una oveja, y lo mata o lo vende, deberá pagar cinco bueyes por un buey, y cuatro ovejas por una oveja. ");
INSERT INTO spablm_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Si el ladrón es encontrado entrando a la fuerza, y es golpeado de tal manera que muere, no habrá culpa de sangre para él. ");
INSERT INTO spablm_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Si el sol ha salido sobre él, es culpable de derramamiento de sangre. Deberá restituirlo. Si no tiene nada, será vendido por su robo. ");
INSERT INTO spablm_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Si la propiedad robada se encuentra en su mano con vida, ya sea buey, burro u oveja, deberá pagar el doble. ");
INSERT INTO spablm_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Si un hombre hace comer un campo o una viña dejando suelto a su animal, y éste pasta en el campo de otro, deberá restituirlo con lo mejor de su campo y con lo mejor de su viña. ");
INSERT INTO spablm_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Si se produce un incendio y se prende en las espinas, de modo que se consuman las mazorcas, el grano en pie o el campo, el que encendió el fuego deberá restituirlo. ");
INSERT INTO spablm_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Si un hombre entrega a su prójimo dinero o cosas para que las guarde, y se las roban en su casa, si el ladrón es encontrado, deberá pagar el doble. ");
INSERT INTO spablm_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Si no se encuentra al ladrón, el dueño de la casa se acercará a Dios para averiguar si ha metido la mano en los bienes de su prójimo. ");
INSERT INTO spablm_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","En todo asunto de transgresión, ya sea por buey, por asno, por oveja, por ropa o por cualquier cosa perdida, sobre la que uno diga: “Esto es mío”, la causa de ambas partes se presentará ante Dios. Aquel a quien Dios condene pagará el doble a su prójimo. ");
INSERT INTO spablm_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Si un hombre entrega a su prójimo un asno, un buey, una oveja o cualquier otro animal para que lo guarde, y éste muere o se daña, o se aleja, sin que nadie lo vea; ");
INSERT INTO spablm_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","el juramento de Yahvé será entre ambos, no ha puesto su mano en los bienes de su prójimo; y su dueño lo aceptará, y no hará restitución. ");
INSERT INTO spablm_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Pero si se lo roban, el que lo robó deberá restituirlo a su dueño. ");
INSERT INTO spablm_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Si se ha roto en pedazos, que lo traiga como prueba. No deberá restituir lo que fue roto. ");
INSERT INTO spablm_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Si un hombre toma prestado algo de su prójimo, y se daña o muere, sin que su dueño esté con él, deberá restituirlo. ");
INSERT INTO spablm_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Si su dueño está con ella, no deberá restituirla. Si se trata de una cosa alquilada, vendrá por su alquiler. ");
INSERT INTO spablm_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Si un hombre seduce a una virgen que no está comprometida para casarse y se acuesta con ella, deberá pagar una dote para que sea su esposa. ");
INSERT INTO spablm_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Si el padre de ella se niega rotundamente a dársela, deberá pagar el dinero correspondiente a la dote de las vírgenes. ");
INSERT INTO spablm_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“No permitirás que viva una hechicera. ");
INSERT INTO spablm_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“El que tenga relaciones sexuales con un animal será condenado a muerte. ");
INSERT INTO spablm_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“El que ofrezca sacrificios a cualquier dios, excepto a Yahvé solamente, será destruido por completo. ");
INSERT INTO spablm_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“No agraviarás al extranjero ni lo oprimirás, pues fuisteis extranjeros en la tierra de Egipto. ");
INSERT INTO spablm_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“No te aprovecharás de ninguna viuda ni de ningún huérfano. ");
INSERT INTO spablm_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Si os aprovecháis de ellos, y ellos claman a mí, ciertamente oiré su clamor; ");
INSERT INTO spablm_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","y mi ira se encenderá, y os mataré a espada; y vuestras mujeres serán viudas, y vuestros hijos huérfanos. ");
INSERT INTO spablm_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Si prestas dinero a alguno de mi pueblo que esté contigo y sea pobre, no serás para él como un acreedor. No le cobrarás intereses. ");
INSERT INTO spablm_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Si tomas el vestido de tu prójimo como garantía, se lo devolverás antes de que se ponga el sol, ");
INSERT INTO spablm_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","porque es su única cobertura, es su vestido para su piel. ¿Con qué va a dormir? Sucederá que cuando clame a mí, yo lo escucharé, porque soy clemente. ");
INSERT INTO spablm_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“No blasfemarás a Dios, ni maldecirás a un gobernante de tu pueblo. ");
INSERT INTO spablm_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“No te demorarás en ofrecer de tu cosecha y de la salida de tus lagares. “Me darás el primogénito de tus hijos. ");
INSERT INTO spablm_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Lo mismo harás con tu ganado y con tus ovejas. Estará con su madre siete días, y al octavo día me lo darás. ");
INSERT INTO spablm_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Seréis hombres santos para mí, por lo que no comeréis ninguna carne desgarrada por los animales en el campo. Se la echarán a los perros. ");
INSERT INTO spablm_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“No difundirás una noticia falsa. No juntes tu mano con la del malvado para ser un testigo malicioso. ");
INSERT INTO spablm_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“No seguirás a una multitud para hacer el mal. No testificarás en la corte para ponerte del lado de una multitud para pervertir la justicia. ");
INSERT INTO spablm_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","No favorecerás al pobre en su causa. ");
INSERT INTO spablm_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Si encuentras al buey de tu enemigo o a su asno extraviado, lo harás volver a él. ");
INSERT INTO spablm_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Si ves que el asno del que te odia se ha caído bajo su carga, no lo dejes. Lo ayudarás con toda seguridad. ");
INSERT INTO spablm_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“No negarás la justicia a tu pueblo pobre en sus pleitos. ");
INSERT INTO spablm_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","“Aléjate de una acusación falsa y no mates al inocente y al justo, porque no justificaré al impío. ");
INSERT INTO spablm_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“No aceptarás soborno, porque el soborno ciega a los que tienen vista y pervierte las palabras de los justos. ");
INSERT INTO spablm_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“No oprimirás al extranjero, pues conoces el corazón del extranjero, ya que fuisteis extranjeros en la tierra de Egipto. ");
INSERT INTO spablm_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Durante seis años sembrarás tu tierra y recogerás sus frutos, ");
INSERT INTO spablm_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","pero el séptimo año la dejarás descansar y en barbecho, para que coman los pobres de tu pueblo; y lo que dejen lo comerá el animal del campo. Del mismo modo, te ocuparás de tu viña y de tu olivar. ");
INSERT INTO spablm_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Seis días harás tu trabajo, y el séptimo día descansarás, para que tu buey y tu asno tengan descanso, y el hijo de tu siervo y el extranjero se refresquen. ");
INSERT INTO spablm_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Cuida de hacer todo lo que te he dicho; y no invoques el nombre de otros dioses ni dejes que se oiga de tu boca. ");
INSERT INTO spablm_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Celebrarás una fiesta para mí tres veces al año. ");
INSERT INTO spablm_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Celebrarás la fiesta de los panes sin levadura. Siete días comeréis panes sin levadura, como os he mandado, en el tiempo señalado en el mes de Abib (porque en él salisteis de Egipto), y nadie se presentará vacío ante mí. ");
INSERT INTO spablm_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Y la fiesta de la cosecha, con los primeros frutos de vuestras labores, que sembréis en el campo; y la fiesta de la recolección, al final del año, cuando recojáis vuestras labores del campo. ");
INSERT INTO spablm_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Tres veces al año se presentarán todos vuestros varones ante el Señor Yahvé. ");
INSERT INTO spablm_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“No ofrecerás la sangre de mi sacrificio con pan leudado. La grasa de mi fiesta no permanecerá toda la noche hasta la mañana. ");
INSERT INTO spablm_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Traerás las primicias de tu tierra a la casa de Yahvé, tu Dios. “No hervirás un cabrito en la leche de su madre. ");
INSERT INTO spablm_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“He aquí que yo envío un ángel delante de ti, para que te guarde en el camino y te lleve al lugar que he preparado. ");
INSERT INTO spablm_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Presta atención a él y escucha su voz. No lo provoques, porque no perdonará tu desobediencia, pues mi nombre está en él. ");
INSERT INTO spablm_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Pero si en verdad escuchas su voz y haces todo lo que yo digo, seré enemigo de tus enemigos y adversario de tus adversarios. ");
INSERT INTO spablm_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Porque mi ángel irá delante de ti y te llevará ante el amorreo, el hitita, el ferezeo, el cananeo, el heveo y el jebuseo, y los eliminaré. ");
INSERT INTO spablm_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","No te inclinarás ante sus dioses, ni los servirás, ni seguirás sus prácticas, sino que los derrocarás por completo y demolerás sus pilares. ");
INSERT INTO spablm_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Servirás a Yahvé, tu Dios, y él bendecirá tu pan y tu agua, y quitaré la enfermedad de en medio de ti. ");
INSERT INTO spablm_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Nadie abortará ni será estéril en tu tierra. Cumpliré el número de tus días. ");
INSERT INTO spablm_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Enviaré mi terror delante de ti y confundiré a todos los pueblos a los que vayas, y haré que todos tus enemigos te den la espalda. ");
INSERT INTO spablm_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Enviaré el avispón delante de ti, que expulsará al heveo, al cananeo y al hitita de tu presencia. ");
INSERT INTO spablm_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","No los expulsaré de delante de ti en un año, no sea que la tierra quede desolada y los animales del campo se multipliquen contra ti. ");
INSERT INTO spablm_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Poco a poco los expulsaré de delante de ti, hasta que te hayas multiplicado y hayas heredado la tierra. ");
INSERT INTO spablm_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Fijaré tu frontera desde el Mar Rojo hasta el mar de los filisteos, y desde el desierto hasta el río; porque entregaré en tu mano a los habitantes de la tierra, y los expulsarás delante de ti. ");
INSERT INTO spablm_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","No harás ningún pacto con ellos, ni con sus dioses. ");
INSERT INTO spablm_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","No habrán de habitar en tu tierra, para que no te hagan pecar contra mí, pues si sirves a sus dioses, ciertamente será una trampa para ti.” ");
INSERT INTO spablm_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Le dijo a Moisés: “Sube a Yahvé, tú, y Aarón, Nadab y Abiú, y setenta de los ancianos de Israel; y adora desde lejos. ");
INSERT INTO spablm_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Sólo Moisés se acercará a Yahvé, pero ellos no se acercarán. El pueblo no subirá con él”. ");
INSERT INTO spablm_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Llegó Moisés y contó al pueblo todas las palabras de Yahvé y todas las ordenanzas; y todo el pueblo respondió a una sola voz y dijo: “Todas las palabras que Yahvé ha dicho las pondremos en práctica.” ");
INSERT INTO spablm_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Moisés escribió todas las palabras de Yahvé, luego se levantó de madrugada y construyó un altar al pie de la montaña, con doce pilares para las doce tribus de Israel. ");
INSERT INTO spablm_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Envió a jóvenes de los hijos de Israel, que ofrecieron holocaustos y sacrificaron ofrendas de paz de ganado a Yahvé. ");
INSERT INTO spablm_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Moisés tomó la mitad de la sangre y la puso en cuencos, y la otra mitad la roció sobre el altar. ");
INSERT INTO spablm_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Tomó el libro de la alianza y lo leyó a la vista del pueblo, que dijo: “Haremos todo lo que Yahvé ha dicho y seremos obedientes”. ");
INSERT INTO spablm_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Moisés tomó la sangre, la roció sobre el pueblo y dijo: “Miren, ésta es la sangre de la alianza que Yahvé ha hecho con ustedes sobre todas estas palabras.” ");
INSERT INTO spablm_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Entonces subieron Moisés, Aarón, Nadab, Abiú y setenta de los ancianos de Israel. ");
INSERT INTO spablm_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Vieron al Dios de Israel. Bajo sus pies había como una obra de piedra de zafiro, como los cielos por su claridad. ");
INSERT INTO spablm_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","No puso su mano sobre los nobles de los hijos de Israel. Vieron a Dios, y comieron y bebieron. ");
INSERT INTO spablm_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Yahvé dijo a Moisés: “Sube a mí en la montaña y quédate aquí, y te daré las tablas de piedra con la ley y los mandamientos que he escrito, para que los enseñes.” ");
INSERT INTO spablm_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Moisés se levantó con Josué, su siervo, y subió a la Montaña de Dios. ");
INSERT INTO spablm_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Dijo a los ancianos: “Esperadnos aquí, hasta que volvamos a vosotros. He aquí que Aarón y Hur están con ustedes. El que esté involucrado en una disputa puede acudir a ellos”. ");
INSERT INTO spablm_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Moisés subió al monte, y la nube cubrió la montaña. ");
INSERT INTO spablm_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","La gloria de Yahvé se posó en el monte Sinaí, y la nube lo cubrió durante seis días. Al séptimo día llamó a Moisés desde el centro de la nube. ");
INSERT INTO spablm_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","La apariencia de la gloria de Yahvé era como un fuego devorador en la cima de la montaña a los ojos de los hijos de Israel. ");
INSERT INTO spablm_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Moisés entró en medio de la nube y subió a la montaña; y Moisés estuvo en la montaña cuarenta días y cuarenta noches. ");
INSERT INTO spablm_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Yahvé habló a Moisés diciendo: ");
INSERT INTO spablm_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Habla a los hijos de Israel para que tomaréis una ofrenda para mí. De todo aquel cuyo corazón lo haga querer, tomarás mi ofrenda. ");
INSERT INTO spablm_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Esta es la ofrenda que tomaréis de ellos: oro, plata, bronce, ");
INSERT INTO spablm_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","azul, púrpura, escarlata, lino fino, pelo de cabra, ");
INSERT INTO spablm_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","pieles de carnero teñidas de rojo, cueros de vacas marinas, madera de acacia, ");
INSERT INTO spablm_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","aceite para la luz, especias para el aceite de la unción y para el incienso aromático, ");
INSERT INTO spablm_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","piedras de ónice, y piedras de engaste para el efod y para el pectoral. ");
INSERT INTO spablm_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Que me hagan un santuario, para que yo habite en medio de ellos. ");
INSERT INTO spablm_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Conforme a todo lo que te muestre, el modelo del tabernáculo y el modelo de todos sus muebles, así lo harás. ");
INSERT INTO spablm_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Harán un arca de madera de acacia. Su longitud será de dos codos y medio, su anchura un codo y medio, y un codo y medio su altura. ");
INSERT INTO spablm_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","La cubrirás de oro puro. Lo cubrirás por dentro y por fuera, y harás una moldura de oro alrededor. ");
INSERT INTO spablm_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Le fundirás cuatro anillos de oro y los pondrás en sus cuatro pies. Dos anillos estarán a un lado de él, y dos anillos al otro lado. ");
INSERT INTO spablm_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Harás varas de madera de acacia y las cubrirás de oro. ");
INSERT INTO spablm_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Pondrás las varas en las argollas a los lados del arca para transportarla. ");
INSERT INTO spablm_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Las varas estarán en los anillos del arca. No se sacarán de ella. ");
INSERT INTO spablm_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Pondrás en el arca el pacto que yo te daré. ");
INSERT INTO spablm_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Harás un propiciatorio de oro puro. Su longitud será de dos codos y medio, y su anchura de codo y medio. ");
INSERT INTO spablm_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Harás dos querubines de oro martillado. Los harás en los dos extremos del propiciatorio. ");
INSERT INTO spablm_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Haz un querubín en un extremo y un querubín en el otro. Harás los querubines en sus dos extremos de una sola pieza con el propiciatorio. ");
INSERT INTO spablm_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Los querubines extenderán sus alas hacia arriba, cubriendo el propiciatorio con sus alas, con sus rostros uno hacia el otro. Los rostros de los querubines estarán hacia el propiciatorio. ");
INSERT INTO spablm_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Pondrás el propiciatorio encima del arca, y en el arca pondrás el pacto que yo te daré. ");
INSERT INTO spablm_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Allí me reuniré contigo, y te diré desde arriba del propiciatorio, desde entre los dos querubines que están sobre el arca de la alianza, todo lo que te mando para los hijos de Israel. ");
INSERT INTO spablm_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Harás una mesa de madera de acacia. Su longitud será de dos codos, su anchura de un codo y su altura de un codo y medio. ");
INSERT INTO spablm_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","La cubrirás de oro puro y le harás una moldura de oro alrededor. ");
INSERT INTO spablm_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Harás un borde de un palmo de ancho alrededor. Harás una moldura de oro en su borde alrededor. ");
INSERT INTO spablm_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Le harás cuatro anillos de oro y los pondrás en las cuatro esquinas que están sobre sus cuatro pies. ");
INSERT INTO spablm_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Los anillos estarán cerca del borde, como lugares para las varas para llevar la mesa. ");
INSERT INTO spablm_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Harás las varas de madera de acacia y las cubrirás de oro, para que la mesa pueda ser transportada con ellas. ");
INSERT INTO spablm_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Harás sus platos, sus cucharas, sus cucharones y sus tazones con los que se vierten las ofrendas. Los harás de oro puro. ");
INSERT INTO spablm_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","En la mesa pondrás siempre el pan de la presencia delante de mí. ");
INSERT INTO spablm_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Harás un candelabro de oro puro. El candelabro se hará de obra martillada. Su base, su fuste, sus copas, sus capullos y sus flores serán de una sola pieza con él. ");
INSERT INTO spablm_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","De sus lados saldrán seis ramas: tres brazos del candelabro salen de un lado, y tres brazos del candelabro salen del otro lado; ");
INSERT INTO spablm_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","tres copas hechas como flores de almendro en un brazo, un capullo y una flor; y tres copas hechas como flores de almendro en el otro brazo, un capullo y una flor, así para los seis brazos que salen del candelabro; ");
INSERT INTO spablm_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","y en el candelabro cuatro copas hechas como flores de almendro, sus capullos y sus flores; ");
INSERT INTO spablm_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","y un capullo debajo de dos ramas de una pieza con él, y un capullo debajo de dos ramas de una pieza con él, y un capullo debajo de dos ramas de una pieza con él, para las seis ramas que salen del candelabro. ");
INSERT INTO spablm_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Sus capullos y sus ramas serán de una sola pieza con ella, toda ella de una sola pieza batida de oro puro. ");
INSERT INTO spablm_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Harás sus lámparas de siete, y ellas encenderán sus lámparas para alumbrar el espacio que está frente a ella. ");
INSERT INTO spablm_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Sus apagadores y sus tabaqueras serán de oro puro. ");
INSERT INTO spablm_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Se hará de un talento de oro puro, con todos estos accesorios. ");
INSERT INTO spablm_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Procura hacerlos según su modelo, que te ha sido mostrado en la montaña. ");
INSERT INTO spablm_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Además, harás el tabernáculo con diez cortinas de lino fino, azul, púrpura y escarlata, con querubines. Las harás con el trabajo de un obrero hábil. ");
INSERT INTO spablm_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","La longitud de cada cortina será de veintiocho codos, y la anchura de cada cortina de cuatro codos; todas las cortinas tendrán una misma medida. ");
INSERT INTO spablm_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Cinco cortinas estarán unidas entre sí, y las otras cinco cortinas estarán unidas entre sí. ");
INSERT INTO spablm_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Harás lazos de color azul en el borde de una de las cortinas desde el borde en el acoplamiento, y harás lo mismo en el borde de la cortina que está más afuera en el segundo acoplamiento. ");
INSERT INTO spablm_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Harás cincuenta lazos en la primera cortina, y harás cincuenta lazos en el borde de la cortina que está en el segundo acoplamiento. Los lazos estarán uno frente al otro. ");
INSERT INTO spablm_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Harás cincuenta corchetes de oro y unirás las cortinas entre sí con los corchetes. El tabernáculo será una unidad. ");
INSERT INTO spablm_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Harás cortinas de pelo de cabra para cubrir el tabernáculo. Harás once cortinas. ");
INSERT INTO spablm_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","La longitud de cada cortina será de treinta codos, y la anchura de cada cortina de cuatro codos; las once cortinas tendrán una sola medida. ");
INSERT INTO spablm_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Acoplarás cinco cortinas solas y seis cortinas solas, y doblarás la sexta cortina en la parte delantera de la tienda. ");
INSERT INTO spablm_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Harás cincuenta lazos en el borde de la cortina que está más afuera en el acople, y cincuenta lazos en el borde de la cortina que está más afuera en el segundo acople. ");
INSERT INTO spablm_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Harás cincuenta broches de bronce, los pondrás en las presillas y unirás la tienda para que sea una sola. ");
INSERT INTO spablm_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","La parte que sobresale de las cortinas de la tienda — la mitad de la cortina que queda — colgará sobre la parte posterior del tabernáculo. ");
INSERT INTO spablm_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","El codo de un lado y el codo del otro lado, de lo que queda de la longitud de las cortinas de la tienda, colgará sobre los lados del tabernáculo de este lado y del otro, para cubrirlo. ");
INSERT INTO spablm_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Harás una cubierta para la tienda de pieles de carnero teñidas de rojo, y una cubierta de pieles de vaca marina por encima. ");
INSERT INTO spablm_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Harás las tablas para el tabernáculo de madera de acacia, de pie. ");
INSERT INTO spablm_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","La longitud de una tabla será de diez codos, y la anchura de cada tabla de un codo y medio. ");
INSERT INTO spablm_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","En cada tabla habrá dos espigas unidas entre sí; así harás todas las tablas del tabernáculo. ");
INSERT INTO spablm_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Harás veinte tablas para el tabernáculo, para el lado sur, hacia el sur. ");
INSERT INTO spablm_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Harás cuarenta basas de plata debajo de las veinte tablas; dos basas debajo de una tabla para sus dos espigas, y dos basas debajo de otra tabla para sus dos espigas. ");
INSERT INTO spablm_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Para el segundo lado del tabernáculo, en el lado norte, veinte tablas, ");
INSERT INTO spablm_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","y sus cuarenta basas de plata; dos basas debajo de una tabla, y dos basas debajo de otra tabla. ");
INSERT INTO spablm_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Para el lado opuesto del tabernáculo, hacia el oeste, harás seis tablas. ");
INSERT INTO spablm_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Harás dos tablas para las esquinas del tabernáculo en el lado opuesto. ");
INSERT INTO spablm_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Serán dobles por debajo, y de la misma manera serán enteras hasta su parte superior a un anillo; así será para ambas; serán para las dos esquinas. ");
INSERT INTO spablm_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Habrá ocho tablas, y sus basas de plata, dieciséis basas; dos basas debajo de una tabla, y dos basas debajo de otra tabla. ");
INSERT INTO spablm_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Harás barras de madera de acacia: cinco para las tablas de un lado del tabernáculo, ");
INSERT INTO spablm_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","y cinco barras para las tablas del otro lado del tabernáculo, y cinco barras para las tablas del lado del tabernáculo, para el lado opuesto, hacia el oeste. ");
INSERT INTO spablm_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","La barra del medio de las tablas pasará de extremo a extremo. ");
INSERT INTO spablm_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Cubrirás las tablas con oro, y harás sus anillos de oro para colocar las barras. Cubrirás de oro las barras. ");
INSERT INTO spablm_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Montarás el tabernáculo de acuerdo con la forma en que se te mostró en la montaña. ");
INSERT INTO spablm_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Harás un velo de azul, púrpura, escarlata y lino fino, con querubines. Será obra de un hábil obrero. ");
INSERT INTO spablm_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Lo colgarás en cuatro columnas de acacia recubiertas de oro; sus ganchos serán de oro, sobre cuatro bases de plata. ");
INSERT INTO spablm_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Colgarás el velo debajo de los corchetes, y meterás allí el arca de la alianza dentro del velo. El velo separará para ti el lugar santo del santísimo. ");
INSERT INTO spablm_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Pondrás el propiciatorio sobre el arca de la alianza en el lugar santísimo. ");
INSERT INTO spablm_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Pondrás la mesa fuera del velo, y el candelabro frente a la mesa, del lado del tabernáculo hacia el sur. Pondrás la mesa en el lado norte. ");
INSERT INTO spablm_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Harás un biombo para la puerta de la Tienda, de azul, púrpura, escarlata y lino torcido, obra del bordador. ");
INSERT INTO spablm_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Harás para el biombo cinco columnas de acacia, y las cubrirás de oro. Sus ganchos serán de oro. Fundirás para ellas cinco bases de bronce. ");
INSERT INTO spablm_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Harás el altar de madera de acacia, de cinco codos de largo y cinco codos de ancho. El altar será cuadrado. Su altura será de tres codos. ");
INSERT INTO spablm_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Harás sus cuernos en sus cuatro esquinas. Sus cuernos serán de una sola pieza con él. Lo cubrirás de bronce. ");
INSERT INTO spablm_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Harás sus ollas para recoger sus cenizas, sus palas, sus cuencos, sus ganchos para la carne y sus sartenes para el fuego. Harás todos sus recipientes de bronce. ");
INSERT INTO spablm_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Le harás una rejilla de red de bronce. En la red harás cuatro anillos de bronce en sus cuatro esquinas. ");
INSERT INTO spablm_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","La pondrás debajo de la cornisa que rodea el altar, para que la red llegue hasta la mitad del altar. ");
INSERT INTO spablm_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Harás varas para el altar, varas de madera de acacia, y las cubrirás de bronce. ");
INSERT INTO spablm_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Sus varas se pondrán en los anillos, y las varas estarán a los dos lados del altar cuando lo lleves. ");
INSERT INTO spablm_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Lo harás hueco con tablas. Lo harán como se te ha mostrado en la montaña. ");
INSERT INTO spablm_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Harás el atrio del tabernáculo: para el lado sur, hacia el sur, habrá cortinas para el atrio de lino fino de cien codos de largo por un lado. ");
INSERT INTO spablm_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Sus columnas serán veinte, y sus bases veinte, de bronce. Los ganchos de las columnas y sus filetes serán de plata. ");
INSERT INTO spablm_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Asimismo, para la longitud del lado norte, habrá cortinas de cien codos, y sus columnas serán veinte, y sus bases veinte, de bronce; los ganchos de las columnas y sus filetes, de plata. ");
INSERT INTO spablm_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","La anchura del atrio del lado occidental tendrá cortinas de cincuenta codos; sus columnas, diez, y sus basas, diez. ");
INSERT INTO spablm_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","La anchura del atrio del lado oriental será de cincuenta codos. ");
INSERT INTO spablm_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Las cortinas de un lado de la puerta serán de quince codos, sus columnas de tres y sus bases de tres. ");
INSERT INTO spablm_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Las cortinas del otro lado serán de quince codos; sus columnas, tres, y sus bases, tres. ");
INSERT INTO spablm_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Para la puerta del atrio habrá una cortina de veinte codos, de azul, púrpura, carmesí y lino torcido, obra del bordador; sus columnas cuatro, y sus bases cuatro. ");
INSERT INTO spablm_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Todas las columnas del atrio alrededor estarán forradas de plata; sus ganchos, de plata, y sus bases, de bronce. ");
INSERT INTO spablm_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","La longitud del atrio será de cien codos, la anchura de cincuenta y la altura de cinco codos, de lino fino, y sus bases de bronce. ");
INSERT INTO spablm_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Todos los instrumentos del tabernáculo en todo su servicio, y todos sus pasadores, y todos los pasadores del atrio, serán de bronce. ");
INSERT INTO spablm_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Mandarás a los hijos de Israel que te traigan aceite de oliva puro batido para la luz, para hacer arder continuamente una lámpara. ");
INSERT INTO spablm_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","En la Tienda del Encuentro, fuera del velo que está delante del pacto, Aarón y sus hijos la mantendrán en orden desde la tarde hasta la mañana delante de Yahvé; será un estatuto para siempre a través de sus generaciones a favor de los hijos de Israel. ");
INSERT INTO spablm_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Trae a Aarón, tu hermano, y a sus hijos con él, cerca de ti, de entre los hijos de Israel, para que me sirva en el oficio de sacerdote: Aarón, con Nadab, Abiú, Eleazar e Itamar, hijos de Aarón. ");
INSERT INTO spablm_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Harás vestiduras sagradas para Aarón, tu hermano, para gloria y belleza. ");
INSERT INTO spablm_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Hablarás a todos los sabios de corazón, a quienes he llenado de espíritu de sabiduría, para que hagan las vestiduras de Aarón para santificarlo, a fin de que me sirva en el oficio de sacerdote. ");
INSERT INTO spablm_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Estas son las vestimentas que harán: un pectoral, un efod, un manto, una túnica ajustada, un turbante y un fajín. Harán las vestiduras sagradas para Aarón tu hermano y sus hijos, para que me sirvan en el oficio sacerdotal. ");
INSERT INTO spablm_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Usarán el oro, el azul, la púrpura, la escarlata y el lino fino. ");
INSERT INTO spablm_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Harán el efod de oro, azul, púrpura, escarlata y lino torcido, obra del obrero hábil. ");
INSERT INTO spablm_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Tendrá dos correas para los hombros, unidas a los dos extremos del mismo, para que se pueda unir. ");
INSERT INTO spablm_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","La banda tejida con destreza, que está sobre él, será como su obra y de la misma pieza; de oro, azul, púrpura, escarlata y lino fino torcido. ");
INSERT INTO spablm_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Tomarás dos piedras de ónice y grabarás en ellas los nombres de los hijos de Israel. ");
INSERT INTO spablm_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Seis de sus nombres en una piedra, y los nombres de los seis que quedan en la otra piedra, en el orden de su nacimiento. ");
INSERT INTO spablm_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Con el trabajo de un grabador en piedra, como los grabados de un sello, grabarás las dos piedras, según los nombres de los hijos de Israel. Las harás encerrar en engastes de oro. ");
INSERT INTO spablm_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Pondrás las dos piedras en los tirantes del efod, para que sean piedras conmemorativas de los hijos de Israel. Aarón llevará sus nombres ante el Señor en sus dos hombros como recuerdo. ");
INSERT INTO spablm_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Harás engastes de oro, ");
INSERT INTO spablm_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","y dos cadenas de oro puro; las harás como cordones trenzados. Pondrás las cadenas trenzadas en los engastes. ");
INSERT INTO spablm_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Harás un pectoral de juicio, obra de obrero experto; como la obra del efod lo harás; de oro, de azul, de púrpura, de carmesí y de lino torcido, lo harás. ");
INSERT INTO spablm_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Será cuadrado y con doble pliegue; un palmo será su longitud, y un palmo su anchura. ");
INSERT INTO spablm_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Pondrás en él engastes de piedras, cuatro hileras de piedras: una hilera de rubíes, topacios y berilos será la primera hilera; ");
INSERT INTO spablm_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","y la segunda hilera una turquesa, un zafiro, y una esmeralda; ");
INSERT INTO spablm_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","y la tercera hilera un jacinto, un ágata y una amatista; ");
INSERT INTO spablm_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","y la cuarta hilera un crisolito, un ónice y un jaspe. Estarán encerrados en oro en sus engastes. ");
INSERT INTO spablm_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Las piedras serán según los nombres de los hijos de Israel, doce, según sus nombres; como los grabados de un sello, cada uno según su nombre, serán para las doce tribus. ");
INSERT INTO spablm_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Harás en el pectoral cadenas como cordones, de oro puro trenzado. ");
INSERT INTO spablm_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Harás en el pectoral dos anillos de oro, y pondrás los dos anillos en los dos extremos del pectoral. ");
INSERT INTO spablm_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Pondrás las dos cadenas trenzadas de oro en los dos anillos de los extremos del pectoral. ");
INSERT INTO spablm_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Los otros dos extremos de las dos cadenas trenzadas los pondrás en los dos engastes, y los pondrás en los tirantes del efod en su parte delantera. ");
INSERT INTO spablm_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Harás dos anillos de oro y los pondrás en los dos extremos del pectoral, en su borde, que está hacia el lado del efod, hacia adentro. ");
INSERT INTO spablm_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Harás dos anillos de oro y los pondrás en los dos tirantes del efod por debajo, en su parte delantera, cerca de su acoplamiento, por encima de la banda hábilmente tejida del efod. ");
INSERT INTO spablm_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","El pectoral lo unirán por sus anillos a los anillos del efod con un cordón de color azul, para que quede sobre la banda hábilmente tejida del efod, y para que el pectoral no se salga del efod. ");
INSERT INTO spablm_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Aarón llevará los nombres de los hijos de Israel en el pectoral del juicio sobre su corazón, cuando entre en el lugar santo, como recuerdo ante Yahvé siempre. ");
INSERT INTO spablm_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","En el pectoral del juicio pondrás el Urim y el Tumim, y estarán en el corazón de Aarón cuando entre delante de Yahvé. Aarón llevará el juicio de los hijos de Israel en su corazón ante el Señor continuamente. ");
INSERT INTO spablm_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Harás el manto del efod todo de color azul. ");
INSERT INTO spablm_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Tendrá un orificio para la cabeza en el centro. Tendrá un cordón de tejido alrededor de su orificio, como el orificio de una cota de malla, para que no se rompa. ");
INSERT INTO spablm_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","En su dobladillo harás granadas de azul, de púrpura y de escarlata, alrededor de su dobladillo; con campanillas de oro entre ellas y alrededor de ellas: ");
INSERT INTO spablm_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","una campanilla de oro y una granada, una campanilla de oro y una granada, alrededor del dobladillo del manto. ");
INSERT INTO spablm_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Estará sobre Aarón para ministrar; y su sonido se oirá cuando entre al lugar santo delante de Yahvé, y cuando salga, para que no muera. ");
INSERT INTO spablm_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Harás una placa de oro puro y grabarás en ella, como los grabados de un sello, ‘SANTO A YAHWEH’. ");
INSERT INTO spablm_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","La pondrás sobre un cordón de color azul, y estará en el fajín. Estará en la parte delantera del fajín. ");
INSERT INTO spablm_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Estará en la frente de Aarón, y Aarón llevará la iniquidad de las cosas sagradas que los hijos de Israel santifican en todos sus dones sagrados; y estará siempre en su frente, para que sean aceptados ante Yahvé. ");
INSERT INTO spablm_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Tejerás la túnica con lino fino. Harás un turbante de lino fino. Harás un fajín, obra del bordador. ");
INSERT INTO spablm_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","“Harás túnicas para los hijos de Aarón. Les harás fajas. Les harás cintillos, para gloria y belleza. ");
INSERT INTO spablm_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Se las pondrás a Aarón, tu hermano, y a sus hijos con él, y los ungirás, los consagrarás y los santificarás, para que me sirvan en el oficio de sacerdote. ");
INSERT INTO spablm_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Les harás pantalones de lino para cubrir su carne desnuda. Llegarán desde la cintura hasta los muslos. ");
INSERT INTO spablm_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Estarán sobre Aarón y sobre sus hijos, cuando entren en la Tienda de Reunión, o cuando se acerquen al altar para ministrar en el lugar santo, para que no lleven iniquidad y mueran. Esto será un estatuto para siempre para él y para su descendencia después de él. ");
INSERT INTO spablm_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Esto es lo que les harás para santificarlos, para que me sirvan en el oficio sacerdotal: toma un novillo y dos carneros sin defecto, ");
INSERT INTO spablm_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","panes sin levadura, tortas sin levadura mezcladas con aceite y obleas sin levadura untadas con aceite. Las harás de harina de trigo fina. ");
INSERT INTO spablm_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Los pondrás en un canasto y los traerás en el canasto, con el toro y los dos carneros. ");
INSERT INTO spablm_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Llevarás a Aarón y a sus hijos a la puerta de la Tienda del Encuentro, y los lavarás con agua. ");
INSERT INTO spablm_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Tomarás las vestimentas y le pondrás a Aarón la túnica, el manto del efod, el efod y el pectoral, y lo vestirás con la banda hábilmente tejida del efod. ");
INSERT INTO spablm_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Pondrás el turbante sobre su cabeza y pondrás la corona sagrada sobre el turbante. ");
INSERT INTO spablm_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Luego tomarás el aceite de la unción, lo derramarás sobre su cabeza y lo ungirás. ");
INSERT INTO spablm_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Traerás a sus hijos y les pondrás túnicas. ");
INSERT INTO spablm_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Los vestirás con cinturones, a Aarón y a sus hijos, y les atarás cintillos. Ellos tendrán el sacerdocio por estatuto perpetuo. Consagrarás a Aarón y a sus hijos. ");
INSERT INTO spablm_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Llevarás el toro ante la Tienda del Encuentro, y Aarón y sus hijos pondrán sus manos sobre la cabeza del toro. ");
INSERT INTO spablm_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Matarás el toro ante el Señor, a la puerta de la Tienda del Encuentro. ");
INSERT INTO spablm_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Tomarás de la sangre del toro y la pondrás con tu dedo sobre los cuernos del altar, y derramarás toda la sangre al pie del altar. ");
INSERT INTO spablm_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Tomarás toda la grasa que cubre las vísceras, la cubierta del hígado, los dos riñones y la grasa que hay sobre ellos, y los quemarás sobre el altar. ");
INSERT INTO spablm_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Pero la carne del toro, su piel y su estiércol los quemarás al fuego fuera del campamento. Es una ofrenda por el pecado. ");
INSERT INTO spablm_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“También tomarás el único carnero, y Aarón y sus hijos pondrán sus manos sobre la cabeza del carnero. ");
INSERT INTO spablm_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Matarás el carnero, tomarás su sangre y la rociarás alrededor del altar. ");
INSERT INTO spablm_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Cortarás el carnero en pedazos, y lavarás sus entrañas y sus patas, y las pondrás con sus pedazos y con su cabeza. ");
INSERT INTO spablm_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Quemarás todo el carnero sobre el altar: es un holocausto para Yahvé; es un aroma agradable, una ofrenda hecha por fuego para Yahvé. ");
INSERT INTO spablm_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Tomarás el otro carnero, y Aarón y sus hijos pondrán sus manos sobre la cabeza del carnero. ");
INSERT INTO spablm_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Luego matarás el carnero, tomarás un poco de su sangre y la pondrás en el lóbulo de la oreja derecha de Aarón y en el lóbulo de la oreja derecha de sus hijos, en el pulgar de su mano derecha y en el dedo gordo de su pie derecho, y rociarás la sangre alrededor del altar. ");
INSERT INTO spablm_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Tomarás de la sangre que está sobre el altar, y del aceite de la unción, y la rociarás sobre Aarón, y sobre sus vestiduras, y sobre sus hijos, y sobre las vestiduras de sus hijos con él; y él será santificado, y sus vestiduras, y sus hijos, y las vestiduras de sus hijos con él. ");
INSERT INTO spablm_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","También tomarás parte de la grasa del carnero, la cola gorda, la grasa que cubre las vísceras, la cubierta del hígado, los dos riñones, la grasa que hay en ellos y el muslo derecho (porque es un carnero de consagración), ");
INSERT INTO spablm_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","y una hogaza de pan, una torta de pan engrasado y una oblea del canasto de los panes sin levadura que están delante de Yahvé. ");
INSERT INTO spablm_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Pondrás todo esto en las manos de Aarón y en las manos de sus hijos, y los agitarás como ofrenda mecida ante Yahvé. ");
INSERT INTO spablm_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Los tomarás de sus manos y los harás arder en el altar, sobre el holocausto, como aroma agradable ante Yahvé; es una ofrenda encendida para Yahvé. ");
INSERT INTO spablm_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","“Tomarás el pecho del carnero de las consagraciones de Aarón y lo mecerás como ofrenda mecida ante Yahvé. Será tu porción. ");
INSERT INTO spablm_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Santificarás el pecho de la ofrenda mecida y el muslo de la ofrenda mecida, que se eleva, del carnero de las consagraciones, del que es para Aarón y del que es para sus hijos. ");
INSERT INTO spablm_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Será para Aarón y sus hijos como su porción para siempre de los hijos de Israel; porque es una ofrenda mecida. Será una ofrenda mecida de los hijos de Israel de los sacrificios de sus ofrendas de paz, su ofrenda mecida a Yahvé. ");
INSERT INTO spablm_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Las vestiduras sagradas de Aarón serán para sus hijos después de él, para ser ungidos con ellas y para ser consagrados con ellas. ");
INSERT INTO spablm_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Siete días se las pondrá el hijo que sea sacerdote en su lugar, cuando entre en la Tienda de Reunión para ministrar en el lugar santo. ");
INSERT INTO spablm_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Tomarás el carnero de las consagraciones y cocerás su carne en un lugar sagrado. ");
INSERT INTO spablm_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Aarón y sus hijos comerán la carne del carnero y el pan que esté en el canasto, a la puerta de la Tienda de Reunión. ");
INSERT INTO spablm_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Comerán esas cosas con las que se hizo expiación, para consagrarlas y santificarlas; pero un extraño no comerá de ellas, porque son sagradas. ");
INSERT INTO spablm_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Si algo de la carne de la consagración, o del pan, queda hasta la mañana, entonces quemarás el resto con fuego. No se comerá, porque es sagrado. ");
INSERT INTO spablm_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Así harás con Aarón y con sus hijos, según todo lo que te he mandado. Los consagrarás durante siete días. ");
INSERT INTO spablm_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Cada día ofrecerás el toro de la ofrenda por el pecado para la expiación. Limpiarás el altar cuando hagas la expiación por él. Lo ungirás para santificarlo. ");
INSERT INTO spablm_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Siete días expiarás el altar y lo santificarás, y el altar será santísimo. Todo lo que toque el altar será santo. ");
INSERT INTO spablm_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Esto es lo que ofrecerás sobre el altar: dos corderos de un año, de día en día, continuamente. ");
INSERT INTO spablm_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","El primer cordero lo ofrecerás por la mañana, y el otro cordero lo ofrecerás al atardecer; ");
INSERT INTO spablm_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","y con el primer cordero la décima parte de un efa de harina fina mezclada con la cuarta parte de un hin de aceite batido, y la cuarta parte de un hin de vino como libación. ");
INSERT INTO spablm_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","El otro cordero lo ofrecerás al atardecer, y harás con él lo mismo que con la ofrenda de la mañana y con su libación, como aroma agradable, ofrenda encendida a Yahvé. ");
INSERT INTO spablm_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Será un holocausto continuo a lo largo de vuestras generaciones, a la puerta de la Tienda del Encuentro, delante de Yahvé, donde me reuniré con vosotros para hablaros allí. ");
INSERT INTO spablm_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Allí me reuniré con los hijos de Israel, y el lugar será santificado por mi gloria. ");
INSERT INTO spablm_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Santificaré la Carpa del Encuentro y el altar. También santificaré a Aarón y a sus hijos para que me sirvan en el oficio de sacerdote. ");
INSERT INTO spablm_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Habitaré entre los hijos de Israel y seré su Dios. ");
INSERT INTO spablm_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Sabrán que yo soy el Señor, su Dios, que los sacó de la tierra de Egipto para que yo habitara en medio de ellos: Yo soy el Señor, su Dios. ");
INSERT INTO spablm_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Harás un altar para quemar incienso. Lo harás de madera de acacia. ");
INSERT INTO spablm_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Su longitud será de un codo, y su anchura de un codo. Será cuadrado, y su altura será de dos codos. Sus cuernos serán de una sola pieza con él. ");
INSERT INTO spablm_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Lo cubrirás de oro puro, su parte superior, sus lados alrededor y sus cuernos; y harás una moldura de oro alrededor. ");
INSERT INTO spablm_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Le harás dos anillos de oro debajo de su moldura; en sus dos costillas, en sus dos lados los harás; y servirán de lugares para las varas que servirán de sostén. ");
INSERT INTO spablm_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Harás las varas de madera de acacia y las cubrirás de oro. ");
INSERT INTO spablm_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Lo pondrás delante del velo que está junto al arca del testimonio, delante del propiciatorio que está sobre él testimonio, donde me reuniré contigo. ");
INSERT INTO spablm_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Aarón quemará sobre él incienso de especias dulces cada mañana. Cuando atienda las lámparas, las quemará. ");
INSERT INTO spablm_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Cuando Aarón encienda las lámparas al atardecer, las quemará, un incienso perpetuo ante el Señor por vuestras generaciones. ");
INSERT INTO spablm_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","No ofrecerás sobre él ningún incienso extraño, ni holocausto, ni ofrenda; y no derramarás sobre él ninguna libación. ");
INSERT INTO spablm_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Aarón hará expiación sobre sus cuernos una vez al año; con la sangre del sacrificio por el pecado de la expiación, una vez al año, hará expiación por él a lo largo de vuestras generaciones. Es muy sagrado para Yahvé”. ");
INSERT INTO spablm_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Yahvé habló a Moisés diciendo: ");
INSERT INTO spablm_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Cuando hagas el censo de los hijos de Israel, según los que se cuenten entre ellos, cada uno dará un rescate por su alma a Yahvé cuando los cuentes, para que no haya plaga entre ellos cuando los cuentes. ");
INSERT INTO spablm_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Todo el que pase a los contados dará medio siclo según el siclo del santuario (el siclo es de veinte gerahs); medio siclo como ofrenda a Yahvé. ");
INSERT INTO spablm_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Todo el que pase a los contados, de veinte años para arriba, dará la ofrenda a Yahvé. ");
INSERT INTO spablm_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","El rico no dará más, y el pobre no dará menos, que el medio siclo, cuando den la ofrenda a Yahvé, para hacer expiación por vuestras almas. ");
INSERT INTO spablm_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Tomarás el dinero de la expiación de los hijos de Israel y lo destinarás al servicio de la Tienda de Reunión, para que sea un memorial de los hijos de Israel ante Yahvé, para hacer expiación por vuestras almas.” ");
INSERT INTO spablm_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Yahvé habló a Moisés diciendo: ");
INSERT INTO spablm_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Harás también una pila de bronce, con su base de bronce, en la que se lavará. La pondrás entre la Tienda de Reunión y el altar, y pondrás agua en ella. ");
INSERT INTO spablm_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Aarón y sus hijos se lavarán las manos y los pies en ella. ");
INSERT INTO spablm_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Cuando entren en la Tienda del Encuentro, se lavarán con agua, para no morir; o cuando se acerquen al altar para ministrar, para quemar una ofrenda encendida a Yahvé. ");
INSERT INTO spablm_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Así se lavarán las manos y los pies para no morir. Esto les servirá de estatuto para siempre, a él y a sus descendientes por sus generaciones.” ");
INSERT INTO spablm_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Además, Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Toma también especias finas: de mirra líquida, quinientos siclos; y de canela aromática la mitad, doscientos cincuenta; y de caña aromática, doscientos cincuenta; ");
INSERT INTO spablm_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","y de casia quinientos, según el siclo del santuario; y un hin de aceite de oliva. ");
INSERT INTO spablm_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Lo convertirás en un aceite santo para la unción, un perfume compuesto según el arte del perfumista; será un aceite santo para la unción. ");
INSERT INTO spablm_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Lo usarás para ungir la Tienda de reunión, el arca de la alianza, ");
INSERT INTO spablm_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","la mesa y todos sus artículos, el candelabro y sus accesorios, el altar del incienso, ");
INSERT INTO spablm_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","el altar del holocausto con todos sus utensilios, y la pila con su base. ");
INSERT INTO spablm_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Los santificarás para que sean santos. Todo lo que los toque será santo. ");
INSERT INTO spablm_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Ungirás a Aarón y a sus hijos, y los santificarás para que me sirvan en el oficio de sacerdote. ");
INSERT INTO spablm_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Hablarás a los hijos de Israel diciendo: “Este será un aceite de unción santo para mí a través de vuestras generaciones. ");
INSERT INTO spablm_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","No se derramará sobre la carne del hombre, y no hagas nada semejante a él, según su composición. Es santo. Será santo para vosotros. ");
INSERT INTO spablm_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","El que componga algo semejante, o el que ponga algo de él sobre un extraño, será cortado de su pueblo”. ");
INSERT INTO spablm_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Yahvé dijo a Moisés: “Toma para ti especias dulces, resina de goma, onycha y gálbano: especias dulces con incienso puro. Habrá un peso igual de cada una. ");
INSERT INTO spablm_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Harás con ello incienso, un perfume según el arte del perfumista, sazonado con sal, puro y santo. ");
INSERT INTO spablm_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Machacaréis una parte muy pequeña y pondréis otra delante del pacto en la Tienda de reunión, donde me reuniré con vosotros. Será para ti algo muy sagrado. ");
INSERT INTO spablm_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","No haréis este incienso, según su composición, para vosotros; será para vosotros santo para Yahvé. ");
INSERT INTO spablm_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","El que haga algo semejante, para olerlo, será cortado de su pueblo.” ");
INSERT INTO spablm_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“He aquí que he llamado por nombre a Bezalel, hijo de Uri, hijo de Hur, de la tribu de Judá. ");
INSERT INTO spablm_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Lo he llenado con el Espíritu de Dios, en sabiduría, en inteligencia y en conocimiento, y en toda clase de trabajos, ");
INSERT INTO spablm_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","para idear obras de arte, para trabajar en oro, en plata y en bronce, ");
INSERT INTO spablm_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","y en el corte de piedras para engastar, y en la talla de madera, para trabajar en toda clase de trabajos. ");
INSERT INTO spablm_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","He aquí que yo mismo he puesto con él a Aholiab, hijo de Ahisamac, de la tribu de Dan; y en el corazón de todos los sabios de corazón he puesto la sabiduría, para que hagan todo lo que os he mandado: ");
INSERT INTO spablm_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","la Tienda de reunión, el arca de la alianza, el propiciatorio que está sobre ella, todo el mobiliario de la Tienda, ");
INSERT INTO spablm_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","la mesa y sus recipientes, el candelabro puro con todos sus recipientes, el altar del incienso, ");
INSERT INTO spablm_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","el altar del holocausto con todos sus recipientes, la pila y su base, ");
INSERT INTO spablm_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","las vestiduras finamente trabajadas — las vestiduras sagradas para el sacerdote Aarón, las vestiduras de sus hijos para servir en el oficio sacerdotal — ");
INSERT INTO spablm_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","el aceite de la unción, y el incienso de especias dulces para el lugar santo: conforme a todo lo que te he mandado, lo harán.” ");
INSERT INTO spablm_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Habla también a los hijos de Israel, diciendo: ‘Ciertamente guardaréis mis sábados, porque es una señal entre yo y vosotros por vuestras generaciones, para que sepáis que yo soy Yahvé, que os santifico. ");
INSERT INTO spablm_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Por lo tanto, guardarán el sábado, porque es sagrado para ustedes. Todo el que lo profane será condenado a muerte, pues el que haga algún trabajo en él, esa persona será cortada de entre su pueblo. ");
INSERT INTO spablm_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Seis días se trabajará, pero el séptimo día es un día de descanso solemne, santo para Yahvé. El que haga algún trabajo en el día de reposo será condenado a muerte. ");
INSERT INTO spablm_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Por lo tanto, los hijos de Israel guardarán el sábado, para observar el sábado a través de sus generaciones, como un pacto perpetuo. ");
INSERT INTO spablm_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Es una señal entre yo y los hijos de Israel para siempre; porque en seis días Yahvé hizo el cielo y la tierra, y en el séptimo día descansó y se refrescó”. ");
INSERT INTO spablm_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Cuando terminó de hablar con él en el monte Sinaí, le dio a Moisés las dos tablas del testimonio, tablas de piedra, escritas con el dedo de Dios. ");
INSERT INTO spablm_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Cuando el pueblo vio que Moisés se demoraba en bajar del monte, se reunió con Aarón y le dijo: “Ven, haznos dioses que vayan delante de nosotros, porque en cuanto a este Moisés, el hombre que nos sacó de la tierra de Egipto, no sabemos qué ha sido de él.” ");
INSERT INTO spablm_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aarón les dijo: “Quítense los anillos de oro que están en las orejas de sus esposas, de sus hijos y de sus hijas, y tráiganmelos”. ");
INSERT INTO spablm_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Todo el pueblo se quitó los anillos de oro que tenía en sus orejas y se los llevó a Aarón. ");
INSERT INTO spablm_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","El recibió lo que le entregaron, lo modeló con un instrumento de grabado y lo convirtió en un becerro moldeado. Luego le dijeron: “Estos son tus dioses, Israel, que te sacaron de la tierra de Egipto”. ");
INSERT INTO spablm_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Al ver esto, Aarón construyó un altar delante de él; y Aarón hizo una proclama y dijo: “Mañana será una fiesta para Yahvé.” ");
INSERT INTO spablm_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Al día siguiente se levantaron temprano, ofrecieron holocaustos y trajeron ofrendas de paz; el pueblo se sentó a comer y a beber, y se levantó a jugar. ");
INSERT INTO spablm_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","El Señor le dijo a Moisés: “Ve, baja, porque tu pueblo, al que sacaste de la tierra de Egipto, se ha corrompido. ");
INSERT INTO spablm_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Se han desviado rápidamente del camino que les ordené. Se han hecho un becerro moldeado, lo han adorado y le han ofrecido sacrificios, y han dicho: ‘Estos son tus dioses, Israel, que te hicieron subir de la tierra de Egipto’.” ");
INSERT INTO spablm_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Yahvé dijo a Moisés: “He visto a este pueblo, y he aquí que es un pueblo de dura cerviz. ");
INSERT INTO spablm_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Ahora, pues, déjame en paz, para que arda mi ira contra ellos y los consuma; y haré de ti una gran nación.” ");
INSERT INTO spablm_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Moisés suplicó a su Dios y le dijo: “Señor, ¿por qué arde tu ira contra tu pueblo, que sacaste de la tierra de Egipto con gran poder y con mano poderosa? ");
INSERT INTO spablm_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","¿Por qué han de hablar los egipcios diciendo: ‘Los sacó para mal, para matarlos en los montes y consumirlos de la superficie de la tierra’? Vuélvete de tu feroz ira, y aléjate de este mal contra tu pueblo. ");
INSERT INTO spablm_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Acuérdate de Abraham, de Isaac y de Israel, tus siervos, a quienes juraste por ti mismo y les dijiste: ‘Multiplicaré tu descendencia como las estrellas del cielo, y toda esta tierra de la que he hablado se la daré a tu descendencia, y la heredarán para siempre’.” ");
INSERT INTO spablm_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Entonces Yahvé se apartó del mal que dijo que haría a su pueblo. ");
INSERT INTO spablm_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Moisés se volvió y bajó del monte con las dos tablas del testimonio en la mano, tablas que estaban escritas por ambos lados. Estaban escritas de un lado y del otro. ");
INSERT INTO spablm_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Las tablas eran obra de Dios, y la escritura era la escritura de Dios, grabada en las tablas. ");
INSERT INTO spablm_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Cuando Josué oyó el ruido del pueblo al gritar, dijo a Moisés: “Hay ruido de guerra en el campamento”. ");
INSERT INTO spablm_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Dijo: “No es la voz de los que gritan por la victoria. No es la voz de los que gritan por ser vencidos, sino el ruido de los que cantan lo que oigo”. ");
INSERT INTO spablm_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","En cuanto se acercó al campamento, vio el becerro y las danzas. Entonces la ira de Moisés se encendió, y arrojó las tablas de sus manos, y las rompió debajo de la montaña. ");
INSERT INTO spablm_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Tomó el becerro que habían hecho, lo quemó con fuego, lo molió hasta hacerlo polvo y lo esparció sobre el agua, e hizo que los hijos de Israel lo bebieran. ");
INSERT INTO spablm_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Moisés le dijo a Aarón: “¿Qué te ha hecho esta gente para que les hayas provocado un gran pecado?” ");
INSERT INTO spablm_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aarón dijo: “No dejes que se caliente la ira de mi señor. Tú conoces al pueblo, que está empeñado en el mal. ");
INSERT INTO spablm_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Porque me han dicho: ‘Haznos dioses que vayan delante de nosotros’. En cuanto a este Moisés, el hombre que nos sacó de la tierra de Egipto, no sabemos qué ha sido de él’. ");
INSERT INTO spablm_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Les dije: ‘El que tenga oro, que lo saque’. Y me lo dieron; lo eché al fuego, y salió este becerro”. ");
INSERT INTO spablm_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Cuando Moisés vio que el pueblo estaba fuera de control, (pues Aarón los había dejado perder el control, causando la burla de sus enemigos), ");
INSERT INTO spablm_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","entonces Moisés se paró en la puerta del campamento y dijo: “¡Quien esté del lado de Yahvé, venga a mí!” Todos los hijos de Leví se reunieron con él. ");
INSERT INTO spablm_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Él les dijo: “Yahvé, el Dios de Israel, dice: ‘Cada uno ponga su espada en el muslo y vaya de puerta en puerta por todo el campamento, y cada uno mate a su hermano, a su compañero y a su vecino’”. ");
INSERT INTO spablm_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Los hijos de Leví hicieron lo que dijo Moisés. Ese día cayeron unos tres mil hombres del pueblo. ");
INSERT INTO spablm_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Moisés dijo: “Conságrense hoy a Yahvé, porque cada hombre estaba en contra de su hijo y de su hermano, para que él les dé hoy una bendición.” ");
INSERT INTO spablm_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Al día siguiente, Moisés dijo al pueblo: “Habéis cometido un gran pecado. Ahora subiré a Yahvé. Tal vez haga expiación por su pecado”. ");
INSERT INTO spablm_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Moisés volvió a Yahvé y dijo: “Oh, este pueblo ha cometido un gran pecado y se ha hecho dioses de oro. ");
INSERT INTO spablm_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Pero ahora, si quieres, perdona su pecado; y si no, por favor, bórrame de tu libro que has escrito.” ");
INSERT INTO spablm_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Yahvé dijo a Moisés: “A quien haya pecado contra mí, lo borraré de mi libro. ");
INSERT INTO spablm_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Ahora ve, conduce al pueblo al lugar del que te he hablado. He aquí que mi ángel irá delante de ti. Sin embargo, el día en que yo castigue, los castigaré por su pecado”. ");
INSERT INTO spablm_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","El Señor golpeó al pueblo por lo que hicieron con el becerro que hizo Aarón. ");
INSERT INTO spablm_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Yahvé habló a Moisés: “Vete, sube de aquí, tú y el pueblo que has sacado de la tierra de Egipto, a la tierra que juré a Abraham, a Isaac y a Jacob, diciendo: ‘La daré a tu descendencia’. ");
INSERT INTO spablm_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Enviaré un ángel delante de ti, y expulsaré al cananeo, al amorreo, al hitita, al ferezeo, al heveo y al jebuseo. ");
INSERT INTO spablm_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Vayan a una tierra que fluye leche y miel; pero yo no subiré en medio de ustedes, porque son un pueblo de cuello duro, no sea que los consuma en el camino.” ");
INSERT INTO spablm_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Al oír esta mala noticia, el pueblo se puso de luto y nadie se puso sus joyas. ");
INSERT INTO spablm_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Yahvé había dicho a Moisés: “Di a los hijos de Israel: ‘Sois un pueblo de cuello duro. Si subiera entre vosotros un momento, os consumiría. Por lo tanto, quítense ahora sus joyas, para que yo sepa qué hacer con ustedes’”. ");
INSERT INTO spablm_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Los hijos de Israel se despojaron de sus joyas a partir del monte Horeb. ");
INSERT INTO spablm_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Moisés acostumbraba a tomar la tienda y a armarla fuera del campamento, lejos de él, y la llamaba “Tienda del Encuentro”. Todos los que buscaban a Yahvé salían a la Tienda del Encuentro, que estaba fuera del campamento. ");
INSERT INTO spablm_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Cuando Moisés salió a la Tienda, todo el pueblo se levantó y se puso de pie, cada uno a la puerta de su tienda, y observó a Moisés hasta que éste entró en la Tienda. ");
INSERT INTO spablm_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Cuando Moisés entró en la Carpa, la columna de nube descendió, se puso a la puerta de la Carpa, y Yahvé habló con Moisés. ");
INSERT INTO spablm_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Todo el pueblo vio que la columna de nube estaba a la puerta de la Carpa, y todo el pueblo se levantó y adoró, cada uno a la puerta de su carpa. ");
INSERT INTO spablm_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Yahvé habló con Moisés cara a cara, como un hombre habla con su amigo. Volvió a entrar en el campamento, pero su siervo Josué, hijo de Nun, un joven, no salió de la Tienda. ");
INSERT INTO spablm_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Moisés dijo a Yahvé: “He aquí que tú me dices: ‘Haz subir a este pueblo’, y no me has hecho saber a quién enviarás conmigo. Sin embargo, has dicho: ‘Te conozco por tu nombre, y también has hallado gracia ante mis ojos’. ");
INSERT INTO spablm_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Ahora, pues, si he hallado gracia ante tus ojos, muéstrame ahora tu camino, para que te conozca y pueda hallar gracia ante tus ojos; y considera que esta nación es tu pueblo.” ");
INSERT INTO spablm_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Dijo: “Mi presencia irá contigo y te daré descanso”. ");
INSERT INTO spablm_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Moisés le dijo: “Si tu presencia no va conmigo, no nos subas de aquí. ");
INSERT INTO spablm_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Pues ¿cómo sabrá la gente que he hallado gracia ante tus ojos, yo y tu pueblo? ¿No es que tú vas con nosotros, para que estemos separados, yo y tu pueblo, de todos los pueblos que están sobre la superficie de la tierra?” ");
INSERT INTO spablm_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Yahvé dijo a Moisés: “También haré esto que has dicho, porque has hallado gracia ante mis ojos y te conozco por tu nombre.” ");
INSERT INTO spablm_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Moisés dijo: “Por favor, muéstrame tu gloria”. ");
INSERT INTO spablm_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Dijo: “Haré pasar ante ti toda mi bondad, y proclamaré el nombre de Yahvé ante ti. Tendré piedad con quien tenga piedad, y mostraré misericordia con quien tenga piedad”. ");
INSERT INTO spablm_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Dijo: “No puedes ver mi rostro, porque el hombre no puede verme y vivir.” ");
INSERT INTO spablm_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Yahvé también dijo: “He aquí que hay un lugar junto a mí, y tú estarás sobre la roca. ");
INSERT INTO spablm_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Sucederá que, mientras pasa mi gloria, te pondré en una hendidura de la roca y te cubriré con mi mano hasta que haya pasado; ");
INSERT INTO spablm_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","entonces quitaré mi mano, y verás mi espalda; pero mi rostro no se verá.” ");
INSERT INTO spablm_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Yahvé dijo a Moisés: “Talla dos tablas de piedra como las primeras. Yo escribiré en las tablas las palabras que estaban en las primeras tablas, que tú rompiste. ");
INSERT INTO spablm_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Prepárate para la mañana, y sube por la mañana al monte Sinaí, y preséntate allí ante mí en la cima de la montaña. ");
INSERT INTO spablm_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Nadie subirá contigo ni se te verá en ningún lugar del monte. No dejes que los rebaños o las manadas pasten frente a ese monte”. ");
INSERT INTO spablm_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Cinceló dos tablas de piedra como la primera; entonces Moisés se levantó de madrugada y subió al monte Sinaí, como Yahvé le había ordenado, y tomó en su mano dos tablas de piedra. ");
INSERT INTO spablm_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Yahvé descendió en la nube y se quedó allí con él, y proclamó el nombre de Yahvé. ");
INSERT INTO spablm_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Yahvé pasó por delante de él y proclamó: “¡Yahvé! Yahvé, Dios misericordioso y clemente, lento a la cólera y abundante en bondades y verdades, ");
INSERT INTO spablm_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","que guarda la bondad amorosa durante miles de años, que perdona la iniquidad, la desobediencia y el pecado, y que no exculpa a los culpables, visitando la iniquidad de los padres en los hijos y en los hijos de los hijos, en la tercera y en la cuarta generación.” ");
INSERT INTO spablm_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Moisés se apresuró a inclinar la cabeza hacia la tierra y adoró. ");
INSERT INTO spablm_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Dijo: “Si ahora he hallado gracia ante tus ojos, Señor, por favor, deja que el Señor vaya entre nosotros, aunque éste sea un pueblo de dura cerviz; perdona nuestra iniquidad y nuestro pecado, y tómanos como herencia.” ");
INSERT INTO spablm_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Dijo: “He aquí que hago un pacto: ante todo tu pueblo haré maravillas, como no se han hecho en toda la tierra, ni en ninguna nación; y todos los pueblos en medio de los cuales te encuentras verán la obra de Yahvé, porque es algo impresionante lo que hago contigo. ");
INSERT INTO spablm_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Observen lo que hoy les ordeno. He aquí que voy a expulsar ante vosotros al amorreo, al cananeo, al hitita, al ferezeo, al heveo y al jebuseo. ");
INSERT INTO spablm_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Tened cuidado, no sea que hagáis un pacto con los habitantes de la tierra a la que vais, para que no os sirva de lazo; ");
INSERT INTO spablm_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","sino que derrumbéis sus altares, y hagáis pedazos sus columnas, y cortéis sus postes de Asera; ");
INSERT INTO spablm_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","porque no adoraréis a ningún otro dios; porque Yahvé, cuyo nombre es Celoso, es un Dios celoso. ");
INSERT INTO spablm_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“No hagas un pacto con los habitantes de la tierra, no sea que ellos se prostituyan según sus dioses y sacrifiquen a sus dioses, y uno te llame y comas de su sacrificio; ");
INSERT INTO spablm_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","y tomes de sus hijas a tus hijos, y sus hijas se prostituyan según sus dioses, y hagas que tus hijos se prostituyan según sus dioses. ");
INSERT INTO spablm_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“No os haréis ídolos de fundición. ");
INSERT INTO spablm_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Celebrarás la fiesta de los panes sin levadura. Siete días comeréis panes sin levadura, como os he mandado, en el tiempo señalado del mes de Abib; porque en el mes de Abib salisteis de Egipto. ");
INSERT INTO spablm_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Todo lo que abre el vientre es mío; y todo tu ganado que sea macho, el primogénito de vaca y de oveja. ");
INSERT INTO spablm_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","El primogénito del asno lo redimirás con un cordero. Si no quieres redimirlo, le romperás el cuello. Redimirás a todos los primogénitos de tus hijos. Nadie se presentará ante mí con las manos vacías. ");
INSERT INTO spablm_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Seis días trabajarás, pero el séptimo día descansarás: en el tiempo de arar y en el de cosechar descansarás. ");
INSERT INTO spablm_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Celebrarás la fiesta de las semanas con las primicias de la cosecha de trigo, y la fiesta de la cosecha al final del año. ");
INSERT INTO spablm_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Tres veces al año se presentarán todos vuestros varones ante el Señor Yahvé, el Dios de Israel. ");
INSERT INTO spablm_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Porque expulsaré a las naciones delante de ti y ampliaré tus fronteras; nadie deseará tu tierra cuando subas a presentarte ante Yahvé, tu Dios, tres veces al año. ");
INSERT INTO spablm_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“No ofrecerás la sangre de mi sacrificio con pan leudado. El sacrificio de la fiesta de la Pascua no se dejará para la mañana. ");
INSERT INTO spablm_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Traerás las primicias de los primeros frutos de tu tierra a la casa de Yahvé, tu Dios. “No hervirás un cabrito en la leche de su madre”. ");
INSERT INTO spablm_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Yahvé dijo a Moisés: “Escribe estas palabras, porque de acuerdo con ellas he hecho un pacto contigo y con Israel”. ");
INSERT INTO spablm_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Estuvo allí con Yahvé cuarenta días y cuarenta noches; no comió pan ni bebió agua. Escribió en las tablas las palabras de la alianza, los diez mandamientos. ");
INSERT INTO spablm_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Cuando Moisés bajó del monte Sinaí con las dos tablas de la alianza en la mano, cuando bajó del monte, Moisés no sabía que la piel de su rostro brillaba por haber hablado con él. ");
INSERT INTO spablm_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Cuando Aarón y todos los hijos de Israel vieron a Moisés, he aquí que la piel de su rostro brillaba, y tuvieron miedo de acercarse a él. ");
INSERT INTO spablm_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Moisés los llamó, y Aarón y todos los jefes de la congregación volvieron a él; y Moisés les habló. ");
INSERT INTO spablm_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Después se acercaron todos los hijos de Israel, y él les dio todos los mandamientos que Yahvé había hablado con él en el monte Sinaí. ");
INSERT INTO spablm_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Cuando Moisés terminó de hablar con ellos, se puso un velo sobre el rostro. ");
INSERT INTO spablm_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Pero cuando Moisés entró delante de Yahvé para hablar con él, se quitó el velo hasta que salió; y salió y habló a los hijos de Israel lo que se le había ordenado. ");
INSERT INTO spablm_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Los hijos de Israel vieron el rostro de Moisés, que la piel del rostro de Moisés resplandecía; entonces Moisés volvió a poner el velo sobre su rostro, hasta que entró a hablar con él. ");
INSERT INTO spablm_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Moisés reunió a toda la congregación de los hijos de Israel y les dijo: “Estas son las palabras que Yahvé ha ordenado, para que las pongáis en práctica. ");
INSERT INTO spablm_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","‘Seis días se trabajará, pero el séptimo día será un día sagrado para ustedes, un día de descanso solemne para Yahvé; cualquiera que haga algún trabajo en él será condenado a muerte. ");
INSERT INTO spablm_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","No encenderéis fuego en vuestras moradas en el día de reposo’”. ");
INSERT INTO spablm_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Moisés habló a toda la congregación de los hijos de Israel, diciendo: “Esto es lo que mandó Yahvé, diciendo: ");
INSERT INTO spablm_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","‘Tomad de entre vosotros una ofrenda para Yahvé. El que tenga el corazón dispuesto, que lo traiga como ofrenda a Yahvé: oro, plata, bronce, ");
INSERT INTO spablm_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","azul, púrpura, escarlata, lino fino, pelo de cabra, ");
INSERT INTO spablm_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","pieles de carnero teñidas de rojo, cueros de vaca marina, madera de acacia, ");
INSERT INTO spablm_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","aceite para la luz, especias para el aceite de la unción y para el incienso aromático, ");
INSERT INTO spablm_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","piedras de ónice, y piedras para engastar para el efod y para el pectoral. ");
INSERT INTO spablm_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“‘Que venga todo sabio de corazón de entre vosotros y haga todo lo que Yahvé ha mandado: ");
INSERT INTO spablm_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","el tabernáculo, su cubierta exterior, su techo, sus corchetes, sus tablas, sus barras, sus pilares y sus bases; ");
INSERT INTO spablm_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","el arca y sus postes, el propiciatorio, el velo de la cortina; ");
INSERT INTO spablm_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","la mesa con sus postes y todos sus recipientes, y el pan de la función; ");
INSERT INTO spablm_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","el candelabro para la luz, con sus vasos, sus lámparas y el aceite para la luz; ");
INSERT INTO spablm_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","y el altar del incienso con sus varas, el aceite de la unción, el incienso aromático, la cortina de la puerta, a la entrada del tabernáculo ");
INSERT INTO spablm_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","el altar del holocausto, con su reja de bronce, sus varas y todos sus utensilios, la pila y su base; ");
INSERT INTO spablm_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","las cortinas del atrio, sus columnas, sus bases y la cortina para la puerta del atrio; ");
INSERT INTO spablm_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","las clavijas del tabernáculo, las clavijas del atrio y sus cuerdas; ");
INSERT INTO spablm_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","las vestimentas finamente trabajadas para ministrar en el lugar santo: las vestimentas sagradas para Aarón, el sacerdote, y las vestimentas de sus hijos, para ministrar en el oficio del sacerdote.’” ");
INSERT INTO spablm_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Toda la congregación de los hijos de Israel partió de la presencia de Moisés. ");
INSERT INTO spablm_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Vinieron, todos aquellos cuyo corazón los animó, y todos aquellos a quienes su espíritu los hizo dispuestos, y trajeron la ofrenda de Yahvé para la obra de la Tienda del Encuentro, y para todo su servicio, y para las vestiduras sagradas. ");
INSERT INTO spablm_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Vinieron, tanto hombres como mujeres, todos los que estaban dispuestos, y trajeron broches, pendientes, anillos de sello y brazaletes, todas las joyas de oro; todo hombre que ofreció una ofrenda de oro a Yahvé. ");
INSERT INTO spablm_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Todo el que tenía azul, púrpura, escarlata, lino fino, pelo de cabra, pieles de carnero teñidas de rojo y cueros de vaca marina, los traía. ");
INSERT INTO spablm_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Todo el que ofrecía una ofrenda de plata y de bronce traía la ofrenda de Yahvé; y todo el que tenía madera de acacia para cualquier obra del servicio, la traía. ");
INSERT INTO spablm_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Todas las mujeres de corazón sabio hilaron con sus manos, y trajeron lo que habían hilado: el azul, la púrpura, la escarlata y el lino fino. ");
INSERT INTO spablm_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Todas las mujeres cuyo corazón las movía a la sabiduría hilaron el pelo de las cabras. ");
INSERT INTO spablm_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Los jefes trajeron las piedras de ónice y las piedras de engaste para el efod y para el pectoral; ");
INSERT INTO spablm_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","con la especia y el aceite para la luz, para el aceite de la unción y para el incienso aromático. ");
INSERT INTO spablm_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Los hijos de Israel trajeron una ofrenda voluntaria a Yahvé; cada hombre y cada mujer cuyo corazón los hizo traer para toda la obra, que Yahvé había mandado hacer por medio de Moisés. ");
INSERT INTO spablm_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Moisés dijo a los hijos de Israel: “He aquí que Yahvé ha llamado por nombre a Bezalel, hijo de Uri, hijo de Hur, de la tribu de Judá. ");
INSERT INTO spablm_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Lo ha llenado con el Espíritu de Dios, en sabiduría, en inteligencia, en conocimiento y en toda clase de trabajos; ");
INSERT INTO spablm_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","y para hacer obras de arte, para trabajar en oro, en plata, en bronce, ");
INSERT INTO spablm_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","en el corte de piedras para engastar, y en el tallado de madera, para trabajar en toda clase de trabajos de habilidad. ");
INSERT INTO spablm_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Ha puesto en su corazón que puede enseñar, tanto él como Oholiab, hijo de Ahisamac, de la tribu de Dan. ");
INSERT INTO spablm_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Los ha llenado de sabiduría de corazón para que trabajen en toda clase de obra, del grabador, del obrero hábil y del bordador, en azul, en púrpura, en escarlata y en lino fino, y del tejedor, incluso de los que hacen cualquier obra, y de los que hacen obras hábiles. ");
INSERT INTO spablm_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Bezaleel y Aholiab trabajarán con todo hombre de corazón sabio, en quien Yahvé haya puesto sabiduría y entendimiento para saber hacer toda la obra para el servicio del santuario, según todo lo que Yahvé ha ordenado.” ");
INSERT INTO spablm_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Moisés llamó a Bezalel y a Oholiab, y a todo hombre de corazón sabio, en cuyo corazón Yahvé había puesto la sabiduría, a todo aquel cuyo corazón lo movía a venir a la obra para hacerla. ");
INSERT INTO spablm_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Ellos recibían de Moisés toda la ofrenda que los hijos de Israel habían traído para la obra del servicio del santuario, con la cual la hacían. Cada mañana le traían ofrendas voluntarias. ");
INSERT INTO spablm_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Todos los sabios, que realizaban toda la obra del santuario, venían cada uno de su trabajo que hacía. ");
INSERT INTO spablm_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Hablaron con Moisés, diciendo: “El pueblo ha traído mucho más de lo necesario para el servicio de la obra que Yahvé mandó hacer.” ");
INSERT INTO spablm_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Moisés dio un mandamiento, y lo hicieron proclamar por todo el campamento, diciendo: “Que ni el hombre ni la mujer hagan otra cosa para la ofrenda para el santuario”. Así el pueblo se abstuvo de traer. ");
INSERT INTO spablm_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Porque lo que tenían era suficiente para hacer toda la obra, y demasiado. ");
INSERT INTO spablm_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Todos los sabios de corazón entre los que hacían la obra hicieron el tabernáculo con diez cortinas de lino fino torcido, azul, púrpura y escarlata. Las hicieron con querubines, obra de un hábil obrero. ");
INSERT INTO spablm_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","La longitud de cada cortina era de veintiocho codos, y el ancho de cada cortina de cuatro codos. Todas las cortinas tenían una misma medida. ");
INSERT INTO spablm_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Unió cinco cortinas entre sí, y las otras cinco cortinas las unió entre sí. ");
INSERT INTO spablm_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Hizo lazos de color azul en el borde de una de las cortinas, desde el borde en la unión. Igualmente hizo en el borde de la cortina que estaba más afuera en el segundo acoplamiento. ");
INSERT INTO spablm_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Hizo cincuenta lazos en la primera cortina y cincuenta lazos en el borde de la cortina que estaba en el segundo acoplamiento. Los lazos estaban opuestos entre sí. ");
INSERT INTO spablm_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Hizo cincuenta corchetes de oro y unió las cortinas entre sí con los corchetes; así el tabernáculo formaba una unidad. ");
INSERT INTO spablm_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Hizo cortinas de pelo de cabra para cubrir el tabernáculo. Les hizo once cortinas. ");
INSERT INTO spablm_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","La longitud de cada cortina era de treinta codos, y el ancho de cada cortina era de cuatro codos. Las once cortinas tenían una sola medida. ");
INSERT INTO spablm_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Unió cinco cortinas solas y seis cortinas solas. ");
INSERT INTO spablm_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Hizo cincuenta lazos en el borde de la cortina que estaba más afuera en el acople, e hizo cincuenta lazos en el borde de la cortina que estaba más afuera en el segundo acople. ");
INSERT INTO spablm_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Hizo cincuenta ganchos de bronce para unir la tienda, a fin de que fuera una unidad. ");
INSERT INTO spablm_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Hizo una cubierta para la tienda de pieles de carnero teñidas de rojo, y una cubierta de pieles de vaca marina encima. ");
INSERT INTO spablm_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Hizo las tablas para el tabernáculo de madera de acacia, de pie. ");
INSERT INTO spablm_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Diez codos era la longitud de una tabla, y codo y medio la anchura de cada tabla. ");
INSERT INTO spablm_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Cada tabla tenía dos espigas unidas entre sí. Así hizo todas las tablas del tabernáculo. ");
INSERT INTO spablm_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Hizo las tablas del tabernáculo, veinte tablas para el lado sur hacia el sur. ");
INSERT INTO spablm_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Hizo cuarenta basas de plata debajo de las veinte tablas: dos basas debajo de una tabla para sus dos espigas, y dos basas debajo de otra tabla para sus dos espigas. ");
INSERT INTO spablm_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Para el segundo lado del tabernáculo, en el lado norte, hizo veinte tablas ");
INSERT INTO spablm_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","y sus cuarenta basas de plata: dos basas debajo de una tabla y dos basas debajo de otra tabla. ");
INSERT INTO spablm_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Para la parte más alejada del tabernáculo, al oeste, hizo seis tablas. ");
INSERT INTO spablm_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Hizo dos tablas para las esquinas del tabernáculo en la parte más alejada. ");
INSERT INTO spablm_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Eran dobles por debajo, y de la misma manera llegaban hasta su parte superior a un anillo. Hizo esto en las dos esquinas. ");
INSERT INTO spablm_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Había ocho tablas y sus bases de plata, dieciséis bases; debajo de cada tabla había dos bases. ");
INSERT INTO spablm_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Hizo barras de madera de acacia: cinco para las tablas de un lado del tabernáculo, ");
INSERT INTO spablm_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","y cinco barras para las tablas del otro lado del tabernáculo, y cinco barras para las tablas del tabernáculo de la parte posterior hacia el oeste. ");
INSERT INTO spablm_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Hizo que la barra del medio pasara por en medio de las tablas, desde un extremo hasta el otro. ");
INSERT INTO spablm_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Recubrió las tablas de oro, e hizo sus anillos de oro como lugares para las barras, y recubrió las barras de oro. ");
INSERT INTO spablm_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Hizo el velo de azul, púrpura, escarlata y lino fino, con querubines. Lo hizo obra de un hábil artesano. ");
INSERT INTO spablm_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Hizo para él cuatro columnas de acacia y las recubrió de oro. Sus ganchos eran de oro. Les fundió cuatro bases de plata. ");
INSERT INTO spablm_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Hizo una cortina para la puerta de la tienda, de azul, púrpura, escarlata y lino fino, obra de un bordador; ");
INSERT INTO spablm_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","y sus cinco columnas con sus ganchos. Recubrió de oro sus capiteles y sus molduras, y sus cinco bases eran de bronce. ");
INSERT INTO spablm_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bezalel hizo el arca de madera de acacia. Su longitud era de dos codos y medio, y su anchura de codo y medio, y su altura de codo y medio. ");
INSERT INTO spablm_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","La recubrió de oro puro por dentro y por fuera, y le hizo una moldura de oro alrededor. ");
INSERT INTO spablm_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Le fundió cuatro anillos de oro en sus cuatro pies: dos anillos en un lado y dos anillos en el otro. ");
INSERT INTO spablm_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Hizo varas de madera de acacia y las recubrió de oro. ");
INSERT INTO spablm_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Colocó las varas en los anillos a los lados del arca, para transportarla. ");
INSERT INTO spablm_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Hizo un propiciatorio de oro puro. Su longitud era de dos codos y medio, y su anchura de codo y medio. ");
INSERT INTO spablm_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Hizo dos querubines de oro. Los hizo de obra batida, en los dos extremos del propiciatorio: ");
INSERT INTO spablm_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","un querubín en un extremo, y un querubín en el otro extremo. Hizo los querubines de una sola pieza con el propiciatorio en sus dos extremos. ");
INSERT INTO spablm_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Los querubines extendían sus alas por encima, cubriendo el propiciatorio con sus alas, con sus rostros uno hacia el otro. Los rostros de los querubines estaban hacia el propiciatorio. ");
INSERT INTO spablm_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Hizo la mesa de madera de acacia. Su longitud era de dos codos, su anchura de un codo y su altura de codo y medio. ");
INSERT INTO spablm_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","La recubrió de oro puro y le hizo una moldura de oro alrededor. ");
INSERT INTO spablm_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Hizo un borde de un palmo de ancho a su alrededor, e hizo una moldura de oro a su alrededor. ");
INSERT INTO spablm_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Le fundió cuatro anillos de oro y los puso en las cuatro esquinas que estaban sobre sus cuatro pies. ");
INSERT INTO spablm_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Los anillos estaban cerca del borde, los lugares para las varas para llevar la mesa. ");
INSERT INTO spablm_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Hizo las varas de madera de acacia y las recubrió de oro para transportar la mesa. ");
INSERT INTO spablm_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Hizo los recipientes que estaban sobre la mesa, sus platos, sus cucharas, sus tazones y sus cántaros para servir, de oro puro. ");
INSERT INTO spablm_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Hizo el candelabro de oro puro. Hizo el candelabro de obra batida. Su base, su fuste, sus copas, sus capullos y sus flores eran de una sola pieza. ");
INSERT INTO spablm_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Había seis brazos que salían de sus lados: tres brazos del candelabro salían de un lado, y tres brazos del candelabro salían del otro lado: ");
INSERT INTO spablm_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","tres copas hechas como flores de almendro en un brazo, un capullo y una flor, y tres copas hechas como flores de almendro en el otro brazo, un capullo y una flor; así para los seis brazos que salían del candelabro. ");
INSERT INTO spablm_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","En el candelabro había cuatro copas hechas como flores de almendro, sus capullos y sus flores; ");
INSERT INTO spablm_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","y un capullo bajo dos ramas de una pieza con él, y un capullo bajo dos ramas de una pieza con él, y un capullo bajo dos ramas de una pieza con él, para las seis ramas que salían de él. ");
INSERT INTO spablm_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Sus brotes y sus ramas eran de una sola pieza con él. Todo el conjunto era una sola pieza batida de oro puro. ");
INSERT INTO spablm_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Hizo sus siete lámparas, sus apagadores y sus tabaqueras de oro puro. ");
INSERT INTO spablm_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Lo hizo de un talento de oro puro, con todos sus recipientes. ");
INSERT INTO spablm_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Hizo el altar del incienso de madera de acacia. Era cuadrado: su longitud era de un codo, y su anchura de un codo. Su altura era de dos codos. Sus cuernos eran de una sola pieza. ");
INSERT INTO spablm_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Lo recubrió de oro puro: su parte superior, sus lados alrededor y sus cuernos. Hizo una moldura de oro a su alrededor. ");
INSERT INTO spablm_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Le hizo dos anillos de oro debajo de la corona de la moldura, en sus dos costillas, en sus dos lados, para los lugares de las varas con las que se transportaba. ");
INSERT INTO spablm_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Hizo las varas de madera de acacia y las recubrió de oro. ");
INSERT INTO spablm_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Hizo el aceite santo de la unción y el incienso puro de especias dulces, según el arte del perfumista. ");
INSERT INTO spablm_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Hizo el altar del holocausto de madera de acacia. Era cuadrado. Su longitud era de cinco codos, su anchura era de cinco codos, y su altura de tres codos. ");
INSERT INTO spablm_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Hizo sus cuernos en sus cuatro esquinas. Sus cuernos eran de una sola pieza con él, y lo recubrió de bronce. ");
INSERT INTO spablm_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Hizo todos los utensilios del altar: las ollas, las palas, las pilas, los tenedores y las sartenes. Hizo todos sus recipientes de bronce. ");
INSERT INTO spablm_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Hizo para el altar una rejilla de red de bronce, debajo de la cornisa que lo rodeaba por debajo, que llegaba hasta la mitad. ");
INSERT INTO spablm_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Fundió cuatro anillos para las cuatro esquinas de la reja de bronce, para que fueran lugares para los postes. ");
INSERT INTO spablm_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Hizo los postes de madera de acacia y los recubrió de bronce. ");
INSERT INTO spablm_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Colocó las varas en los anillos a los lados del altar, con los que se podía transportar. Lo hizo hueco con tablas. ");
INSERT INTO spablm_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Hizo la pila de bronce, y su base de bronce, de los espejos de las mujeres que servían a la puerta de la Tienda de Reunión. ");
INSERT INTO spablm_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Hizo el atrio: para el lado sur, las cortinas del atrio eran de lino fino torcido, de cien codos; ");
INSERT INTO spablm_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","sus columnas eran veinte, y sus basas veinte, de bronce; los ganchos de las columnas y sus filetes eran de plata. ");
INSERT INTO spablm_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Para el lado norte, cien codos; sus columnas, veinte, y sus basas, veinte, de bronce; los ganchos de las columnas, y sus filetes, de plata. ");
INSERT INTO spablm_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Para el lado del oeste había cortinas de cincuenta codos, sus columnas de diez, y sus bases de diez; los ganchos de las columnas, y sus filetes, de plata. ");
INSERT INTO spablm_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Para el lado del oriente, cincuenta codos, ");
INSERT INTO spablm_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","las cortinas de un lado eran de quince codos; sus columnas, tres, y sus bases, tres; ");
INSERT INTO spablm_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","y lo mismo para el otro lado: a un lado y a otro de la puerta del atrio había cortinas de quince codos; sus columnas, tres, y sus bases, tres. ");
INSERT INTO spablm_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Todas las cortinas alrededor del atrio eran de lino fino. ");
INSERT INTO spablm_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Las bases de las columnas eran de bronce. Los ganchos de las columnas y sus filetes eran de plata. Sus capiteles estaban recubiertos de plata. Todas las columnas del atrio tenían bandas de plata. ");
INSERT INTO spablm_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","La cortina de la puerta del atrio era obra del bordador, de azul, púrpura, escarlata y lino fino. Su longitud era de veinte codos, y su altura a lo ancho era de cinco codos, como las cortinas del atrio. ");
INSERT INTO spablm_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Sus columnas eran cuatro, y sus bases cuatro, de bronce; sus ganchos de plata, y el revestimiento de sus capiteles y sus filetes, de plata. ");
INSERT INTO spablm_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Todos los pasadores del tabernáculo, y alrededor del atrio, eran de bronce. ");
INSERT INTO spablm_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Estas son las cantidades de materiales que se usaron para el tabernáculo, el Tabernáculo del Testimonio, tal como fueron contadas, según el mandato de Moisés, para el servicio de los levitas, por mano de Itamar, hijo del sacerdote Aarón. ");
INSERT INTO spablm_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Bezalel hijo de Uri, hijo de Hur, de la tribu de Judá, hizo todo lo que Yahvé mandó a Moisés. ");
INSERT INTO spablm_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Con él estaba Oholiab, hijo de Ahisamac, de la tribu de Dan, grabador y hábil obrero, y bordador en azul, en púrpura, en escarlata y en lino fino. ");
INSERT INTO spablm_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Todo el oro que se usó para la obra en toda la obra del santuario, el oro de la ofrenda, fue de veintinueve talentos y setecientos treinta siclos, según el siclo del santuario. ");
INSERT INTO spablm_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","La plata de los contados de la congregación era de cien talentos y mil setecientos setenta y cinco siclos, según el siclo del santuario: ");
INSERT INTO spablm_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","un beka por cabeza, es decir, medio siclo, según el siclo del santuario, por todos los que pasaron a los contados, de veinte años para arriba, por seiscientos tres mil quinientos cincuenta hombres. ");
INSERT INTO spablm_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Los cien talentos de plata fueron para fundir las basas del santuario y las basas del velo: cien basas para los cien talentos, un talento por basas. ");
INSERT INTO spablm_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","De los mil setecientos setenta y cinco siclos hizo ganchos para las columnas, recubrió sus capiteles e hizo molduras para ellos. ");
INSERT INTO spablm_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","El bronce de la ofrenda era de setenta talentos y dos mil cuatrocientos siclos. ");
INSERT INTO spablm_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Con esto hizo los zócalos de la puerta de la Tienda de reunión, el altar de bronce, la reja de bronce para él, todos los utensilios del altar, ");
INSERT INTO spablm_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","los zócalos alrededor del atrio, los zócalos de la puerta del atrio, todos los pasadores del tabernáculo y todos los pasadores alrededor del atrio. ");
INSERT INTO spablm_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","De azul, púrpura y escarlata, hicieron las prendas de vestir finamente trabajadas para ministrar en el lugar santo, e hicieron las vestiduras sagradas para Aarón, como Yahvé le ordenó a Moisés. ");
INSERT INTO spablm_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Hizo el efod de oro, azul, púrpura, escarlata y lino fino. ");
INSERT INTO spablm_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","El oro lo batieron en láminas finas y lo cortaron en hilos, para trabajarlo con el azul, la púrpura, la escarlata y el lino fino, obra del artesano hábil. ");
INSERT INTO spablm_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Le hicieron correas para los hombros, unidas entre sí. Se unió por los dos extremos. ");
INSERT INTO spablm_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","La banda tejida con destreza que lo cubría, con la cual se sujetaba, era de la misma pieza, como su obra: de oro, de azul, de púrpura, de escarlata y de lino fino torcido, como Yahvé le ordenó a Moisés. ");
INSERT INTO spablm_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Trabajaron las piedras de ónice, encerradas en engastes de oro, grabadas con los grabados de un sello, según los nombres de los hijos de Israel. ");
INSERT INTO spablm_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Las puso en los tirantes del efod, para que fueran piedras conmemorativas de los hijos de Israel, tal como el Señor se lo había ordenado a Moisés. ");
INSERT INTO spablm_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Hizo el pectoral, obra de un hábil artesano, como la obra del efod: de oro, de azul, de púrpura, de escarlata y de lino torcido. ");
INSERT INTO spablm_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Era cuadrado. Hicieron el pectoral doble. Su longitud era de un palmo, y su anchura de un palmo, siendo doble. ");
INSERT INTO spablm_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Colocaron en él cuatro hileras de piedras. Una hilera de rubí, topacio y berilo era la primera hilera; ");
INSERT INTO spablm_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","y la segunda hilera, una turquesa, un zafiro, y una esmeralda; ");
INSERT INTO spablm_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","y la tercera hilera, un jacinto, una ágata y una amatista; ");
INSERT INTO spablm_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","y la cuarta hilera, un crisolito, un ónice y un jaspe. Estaban encerradas en engastes de oro. ");
INSERT INTO spablm_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Las piedras eran según los nombres de los hijos de Israel, doce, según sus nombres; como los grabados de un sello, cada uno según su nombre, para las doce tribus. ");
INSERT INTO spablm_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Hicieron en el pectoral cadenas como cordones, de oro puro trenzado. ");
INSERT INTO spablm_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Hicieron dos engastes de oro y dos anillos de oro, y pusieron los dos anillos en los dos extremos del pectoral. ");
INSERT INTO spablm_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Pusieron las dos cadenas trenzadas de oro en los dos anillos de los extremos del pectoral. ");
INSERT INTO spablm_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Los otros dos extremos de las dos cadenas trenzadas los pusieron en los dos engastes, y los pusieron en los tirantes del efod, en su parte delantera. ");
INSERT INTO spablm_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Hicieron dos anillos de oro y los pusieron en los dos extremos del pectoral, en su borde, que estaba hacia el lado del efod, hacia adentro. ");
INSERT INTO spablm_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Hicieron otros dos anillos de oro y los pusieron en los dos tirantes del efod por debajo, en su parte delantera, cerca de su acoplamiento, por encima de la banda hábilmente tejida del efod. ");
INSERT INTO spablm_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Luego unieron el pectoral por sus anillos a los anillos del efod con un cordón de color azul, para que quedara sobre la banda hábilmente tejida del efod, y para que el pectoral no se desprendiera del efod, tal como el Señor lo había ordenado a Moisés. ");
INSERT INTO spablm_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Hizo el manto del efod de tela, todo de color azul. ");
INSERT INTO spablm_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","La abertura del manto en el centro era como la abertura de una cota de malla, con una cinta alrededor de la abertura, para que no se rompiera. ");
INSERT INTO spablm_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Hicieron en las faldas del manto granadas de color azul, púrpura, escarlata y lino torcido. ");
INSERT INTO spablm_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Hicieron campanas de oro puro, y pusieron las campanas entre las granadas alrededor de los faldones del manto, entre las granadas; ");
INSERT INTO spablm_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","una campana y una granada, una campana y una granada, alrededor de los faldones del manto, para ministrar, como Yahvé le ordenó a Moisés. ");
INSERT INTO spablm_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Hicieron las túnicas de lino fino de obra tejida para Aarón y para sus hijos, ");
INSERT INTO spablm_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","el turbante de lino fino, las cintillos de lino fino, los pantalones de lino fino, ");
INSERT INTO spablm_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","el fajín de lino fino, azul, púrpura y escarlata, obra del bordador, como Yahvé mandó a Moisés. ");
INSERT INTO spablm_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Hicieron la placa de la corona sagrada de oro puro, y escribieron en ella una inscripción, como los grabados de un sello: “SANTIDAD A YAHWEH”. ");
INSERT INTO spablm_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Le ataron un cordón de color azul, para sujetarlo al turbante de arriba, como Yahvé le ordenó a Moisés. ");
INSERT INTO spablm_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Así quedó terminada toda la obra del tabernáculo de la Tienda de Reunión. Los hijos de Israel hicieron conforme a todo lo que Yahvé ordenó a Moisés; así lo hicieron. ");
INSERT INTO spablm_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Llevaron el tabernáculo a Moisés la tienda, con todos sus muebles, sus broches, sus tablas, sus barras, sus pilares, sus bases, ");
INSERT INTO spablm_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","la cubierta de pieles de carnero teñidas de rojo, la cubierta de pieles de vaca marina, el velo de la pantalla, ");
INSERT INTO spablm_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","el arca del testimonio con sus postes, el propiciatorio, ");
INSERT INTO spablm_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","la mesa, todos sus utensilios, el pan de la proposición, ");
INSERT INTO spablm_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","el candelabro puro, sus lámparas, todos sus utensilios, el aceite para la luz, ");
INSERT INTO spablm_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","el altar de oro, el aceite de la unción, el incienso aromático, la cortina para la puerta de la Tienda, ");
INSERT INTO spablm_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","el altar de bronce, su reja de bronce, sus varas, todos sus vasos, la pila y su base, ");
INSERT INTO spablm_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","las cortinas del atrio, sus columnas, sus bases, la cortina para la puerta del atrio, sus cuerdas, sus clavijas, y todos los instrumentos del servicio del tabernáculo, para la Tienda de Reunión, ");
INSERT INTO spablm_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","las vestimentas finamente trabajadas para ministrar en el lugar santo, las vestimentas sagradas para el sacerdote Aarón y las vestimentas de sus hijos, para ministrar en el oficio del sacerdote. ");
INSERT INTO spablm_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Conforme a todo lo que Yahvé mandó a Moisés, así hicieron los hijos de Israel todo el trabajo. ");
INSERT INTO spablm_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Moisés vio toda la obra, y he aquí que la habían hecho como Yahvé había ordenado. Así lo habían hecho; y Moisés los bendijo. ");
INSERT INTO spablm_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“El primer día del primer mes levantarás el tabernáculo de la Tienda de Reunión. ");
INSERT INTO spablm_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Pondrás en él el Arca del Testimonio, y cubrirás el Arca con el velo. ");
INSERT INTO spablm_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Traerás la mesa y pondrás en orden las cosas que están sobre ella. Traerás el candelabro y encenderás sus lámparas. ");
INSERT INTO spablm_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Pondrás el altar de oro para el incienso delante del arca de la alianza, y pondrás la cortina de la puerta del tabernáculo. ");
INSERT INTO spablm_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“Pondrás el altar del holocausto delante de la puerta de la Carpa del Encuentro. ");
INSERT INTO spablm_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Pondrás la pila entre la Carpa del Encuentro y el altar, y pondrás agua en ella. ");
INSERT INTO spablm_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Armarás el atrio alrededor, y colgarás la cortina de la puerta del atrio. ");
INSERT INTO spablm_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Tomarás el aceite de la unción y ungirás el tabernáculo y todo lo que hay en él, y lo santificarás junto con todo su mobiliario, y será santo. ");
INSERT INTO spablm_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Ungirás el altar del holocausto con todos sus utensilios, y santificarás el altar, y el altar será santísimo. ");
INSERT INTO spablm_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Ungirás la pila y su base, y la santificarás. ");
INSERT INTO spablm_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Llevarás a Aarón y a sus hijos a la puerta de la Tienda de Reunión, y los lavarás con agua. ");
INSERT INTO spablm_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Pondrás a Aarón las vestiduras sagradas, lo ungirás y lo santificarás para que me sirva en el oficio de sacerdote. ");
INSERT INTO spablm_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Traerás a sus hijos y les pondrás túnicas. ");
INSERT INTO spablm_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Los ungirás, como ungiste a su padre, para que me sirvan en el oficio sacerdotal. Su unción será para ellos un sacerdocio eterno por sus generaciones”. ");
INSERT INTO spablm_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Así lo hizo Moisés. Conforme a todo lo que Yahvé le ordenó, así lo hizo. ");
INSERT INTO spablm_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","En el primer mes del segundo año, el primer día del mes, se levantó el tabernáculo. ");
INSERT INTO spablm_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Moisés levantó el tabernáculo, colocó sus bases, puso sus tablas, colocó sus barras y levantó sus columnas. ");
INSERT INTO spablm_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Extendió la cubierta sobre la tienda, y puso encima el techo del tabernáculo, como Yahvé le había ordenado a Moisés. ");
INSERT INTO spablm_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Tomó y puso el pacto en el arca, colocó las varas sobre el arca y puso el propiciatorio encima del arca. ");
INSERT INTO spablm_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Llevó el arca al tabernáculo, colocó el velo de la cortina y cubrió el arca de la alianza, tal como el Señor se lo había ordenado a Moisés. ");
INSERT INTO spablm_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Puso la mesa en la Tienda de Reunión, en el lado norte de la Morada, fuera del velo. ");
INSERT INTO spablm_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Sobre ella puso el pan en orden ante el Señor, como el Señor le había ordenado a Moisés. ");
INSERT INTO spablm_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Puso el candelabro en la Tienda de Reunión, frente a la mesa, en el lado sur de la Morada. ");
INSERT INTO spablm_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Encendió las lámparas delante de Yahvé, como Yahvé le había ordenado a Moisés. ");
INSERT INTO spablm_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Puso el altar de oro en la Tienda del Encuentro, delante del velo; ");
INSERT INTO spablm_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","y quemó en él incienso de especias dulces, como el Señor le había ordenado a Moisés. ");
INSERT INTO spablm_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Colocó la cortina de la puerta del tabernáculo. ");
INSERT INTO spablm_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Puso el altar del holocausto a la puerta de la Carpa del Encuentro, y ofreció sobre él el holocausto y la ofrenda, como Yahvé le había ordenado a Moisés. ");
INSERT INTO spablm_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Puso la pila entre la Tienda del Encuentro y el altar, y puso en ella agua para lavarse. ");
INSERT INTO spablm_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Moisés, Aarón y sus hijos se lavaron allí las manos y los pies. ");
INSERT INTO spablm_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Cuando entraban en la Tienda del Encuentro, y cuando se acercaban al altar, se lavaban, como Yahvé le había ordenado a Moisés. ");
INSERT INTO spablm_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","El levantó el atrio alrededor del tabernáculo y del altar, y colocó la cortina de la puerta del atrio. Y Moisés terminó la obra. ");
INSERT INTO spablm_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Entonces la nube cubrió la Tienda del Encuentro, y la gloria de Yahvé llenó el tabernáculo. ");
INSERT INTO spablm_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Moisés no pudo entrar en la Tienda del Encuentro, porque la nube permanecía sobre ella, y la gloria de Yahvé llenaba el tabernáculo. ");
INSERT INTO spablm_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Cuando la nube se alzaba sobre el tabernáculo, los hijos de Israel seguían adelante en todos sus viajes; ");
INSERT INTO spablm_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","pero si la nube no se alzaba, entonces no viajaban hasta el día en que se alzaba. ");
INSERT INTO spablm_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Porque la nube de Yahvé estaba sobre el tabernáculo de día, y había fuego en la nube de noche, a la vista de toda la casa de Israel, durante todos sus viajes. ");
INSERT INTO spablm_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Yahvé llamó a Moisés y le habló desde la Tienda del Encuentro, diciendo: ");
INSERT INTO spablm_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Habla a los hijos de Israel y diles: ‘Cuando alguno de vosotros ofrezca una ofrenda a Yahvé, ofreceréis vuestra ofrenda del ganado, de la manada y del rebaño. ");
INSERT INTO spablm_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“‘Si su ofrenda es un holocausto del rebaño, ofrecerá un macho sin defecto. Lo ofrecerá a la puerta de la Tienda del Encuentro, para que sea aceptado ante el Señor. ");
INSERT INTO spablm_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Pondrá su mano sobre la cabeza del holocausto, y le será aceptado para hacer expiación por él. ");
INSERT INTO spablm_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Matará el toro delante de Yahvé. Los hijos de Aarón, los sacerdotes, presentarán la sangre y la rociarán alrededor del altar que está a la puerta de la Tienda de reunión. ");
INSERT INTO spablm_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Desollará el holocausto y lo cortará en pedazos. ");
INSERT INTO spablm_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Los hijos del sacerdote Aarón pondrán fuego en el altar y pondrán la leña en orden sobre el fuego; ");
INSERT INTO spablm_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","y los hijos de Aarón, los sacerdotes, pondrán los trozos, la cabeza y la grasa en orden sobre la leña que está sobre el fuego que está en el altar; ");
INSERT INTO spablm_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","pero lavará sus entrañas y sus patas con agua. El sacerdote lo quemará todo sobre el altar, como holocausto, ofrenda encendida, de aroma agradable para Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“‘Si su ofrenda es del rebaño, de las ovejas o de las cabras, para un holocausto, ofrecerá un macho sin defecto. ");
INSERT INTO spablm_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Lo matará en el lado norte del altar, delante de Yahvé. Los hijos de Aarón, los sacerdotes, rociarán su sangre alrededor del altar. ");
INSERT INTO spablm_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Lo cortará en pedazos, con su cabeza y su grasa. El sacerdote los pondrá en orden sobre la leña que está sobre el fuego que está sobre el altar, ");
INSERT INTO spablm_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","pero las entrañas y las patas las lavará con agua. El sacerdote ofrecerá el conjunto y lo quemará sobre el altar. Es un holocausto, una ofrenda hecha por el fuego, de aroma agradable para Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“‘Si su ofrenda a Yahvé es un holocausto de aves, ofrecerá su ofrenda de tórtolas o de pichones. ");
INSERT INTO spablm_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","El sacerdote la traerá al altar, le arrancará la cabeza y la quemará sobre el altar, y su sangre se derramará a un lado del altar; ");
INSERT INTO spablm_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","y le quitará el buche y las plumas, y la echará junto al altar, en la parte oriental, en el lugar de las cenizas. ");
INSERT INTO spablm_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","La arrancará por las alas, pero no la separará. El sacerdote lo quemará sobre el altar, sobre la leña que está sobre el fuego. Es un holocausto, una ofrenda hecha por el fuego, de aroma agradable para Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“‘Cuando alguien ofrezca una ofrenda de cereal a Yahvé, su ofrenda será de harina fina. La cubrirá con aceite y la cubrirá con incienso. ");
INSERT INTO spablm_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","La llevará a los hijos de Aarón, los sacerdotes. Tomará su puñado de su harina fina y de su aceite, con todo su incienso, y el sacerdote quemará su memorial en el altar, una ofrenda hecha por fuego, de aroma agradable para Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Lo que quede de la ofrenda de harina será de Aarón y de sus hijos. Es una parte santísima de las ofrendas quemadas a Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“‘Cuando ofrezcas una ofrenda de harina cocida en el horno, será de tortas sin levadura de harina fina mezcladas con aceite, o de obleas sin levadura untadas con aceite. ");
INSERT INTO spablm_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Si tu ofrenda es una ofrenda de harina hecha a la plancha, será de harina fina sin levadura, mezclada con aceite. ");
INSERT INTO spablm_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","La cortarás en pedazos y la untarás con aceite. Es una ofrenda alimenticia. ");
INSERT INTO spablm_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Si tu ofrenda es una ofrenda de harina de sartén, será de harina fina con aceite. ");
INSERT INTO spablm_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Traerás a Yahvé la ofrenda de harina hecha de estas cosas. Se la presentarás al sacerdote, y él la llevará al altar. ");
INSERT INTO spablm_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","El sacerdote tomará de la ofrenda de cereal su recuerdo y la hará arder en el altar, como ofrenda encendida de aroma agradable para el Señor. ");
INSERT INTO spablm_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Lo que quede de la ofrenda de comida será de Aarón y de sus hijos. Es una parte santísima de las ofrendas quemadas a Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“‘Ninguna ofrenda de harina que ofrezcas a Yahvé se hará con levadura; porque no quemarás levadura ni miel como ofrenda encendida a Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Como ofrenda de primicias las ofrecerás a Yahvé, pero no subirán como aroma agradable al altar. ");
INSERT INTO spablm_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Cada una de las ofrendas de tu comida la sazonarás con sal. No dejarás que la sal del pacto de tu Dios falte en tu ofrenda de comida. Con todas tus ofrendas ofrecerás sal. ");
INSERT INTO spablm_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“‘Si ofreces una ofrenda de primicias a Yahvé, ofrecerás para la ofrenda de tus primicias cabezas frescas de grano tostadas y machacadas. ");
INSERT INTO spablm_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Pondrás aceite y pondrás incienso sobre ella. Es una ofrenda de comida. ");
INSERT INTO spablm_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","El sacerdote quemará como su memorial parte de su grano molido y parte de su aceite, junto con todo su incienso. Es una ofrenda hecha por fuego a Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“‘Si su ofrenda es un sacrificio de paz, si la ofrece de entre los rebaños, sea macho o hembra, la ofrecerá sin defecto ante Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Pondrá su mano sobre la cabeza de su ofrenda y la matará a la puerta de la Tienda de Reunión. Los hijos de Aarón, los sacerdotes, rociarán la sangre alrededor del altar. ");
INSERT INTO spablm_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Del sacrificio de paz ofrecerá una ofrenda encendida a Yahvé. La grasa que cubre las vísceras, y toda la grasa que está sobre las vísceras, ");
INSERT INTO spablm_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","y los dos riñones, y la grasa que está sobre ellos, que está junto a los lomos, y la cubierta del hígado, con los riñones, la quitará. ");
INSERT INTO spablm_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Los hijos de Aarón lo quemarán en el altar, sobre el holocausto que está sobre la leña que está sobre el fuego; es una ofrenda hecha por el fuego, de aroma agradable para Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“‘Si su ofrenda para un sacrificio de paz a Yahvé es del rebaño, ya sea macho o hembra, la ofrecerá sin defecto. ");
INSERT INTO spablm_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Si ofrece un cordero como ofrenda, lo ofrecerá delante de Yahvé; ");
INSERT INTO spablm_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","y pondrá su mano sobre la cabeza de su ofrenda, y la matará delante de la Tienda del Encuentro. Los hijos de Aarón rociarán su sangre alrededor del altar. ");
INSERT INTO spablm_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Del sacrificio de paz ofrecerá una ofrenda encendida a Yahvé; su grasa, toda la grasa de la cola, la quitará junto a la espina dorsal; y la grasa que cubre las vísceras, y toda la grasa que está sobre las vísceras, ");
INSERT INTO spablm_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","y los dos riñones, y la grasa que está sobre ellos, que está junto a los lomos, y la cubierta del hígado, con los riñones, la quitará. ");
INSERT INTO spablm_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","El sacerdote lo quemará sobre el altar: es el alimento de la ofrenda hecha por fuego a Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“‘Si su ofrenda es un macho cabrío, lo ofrecerá ante Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Pondrá su mano sobre su cabeza y lo matará delante de la Tienda del Encuentro; y los hijos de Aarón rociarán su sangre alrededor del altar. ");
INSERT INTO spablm_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Ofrecerá de ella, como ofrenda encendida a Yahvé, la grasa que cubre las vísceras, y toda la grasa que está sobre las vísceras, ");
INSERT INTO spablm_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","y los dos riñones, y la grasa que está sobre ellos, que está junto a los lomos, y la cubierta del hígado, con los riñones, los quitará. ");
INSERT INTO spablm_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","El sacerdote los quemará sobre el altar: es el alimento de la ofrenda hecha por el fuego, para un aroma agradable; toda la grasa es de Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","“‘Será un estatuto perpetuo a través de vuestras generaciones en todas vuestras moradas, que no comeréis ni grasa ni sangre.’” ");
INSERT INTO spablm_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Habla a los hijos de Israel, diciendo: ‘Si alguno peca involuntariamente, en cualquiera de las cosas que Yahvé ha ordenado no hacer, y hace alguna de ellas, ");
INSERT INTO spablm_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","si el sacerdote ungido peca de manera que traiga la culpa al pueblo, entonces que ofrezca por su pecado que ha cometido un toro joven sin defecto a Yahvé como ofrenda por el pecado. ");
INSERT INTO spablm_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Llevará el toro a la puerta de la Tienda del Encuentro, delante de Yahvé, y pondrá su mano sobre la cabeza del toro, y lo matará delante de Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","El sacerdote ungido tomará parte de la sangre del toro y la llevará a la Tienda del Encuentro. ");
INSERT INTO spablm_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","El sacerdote mojará su dedo en la sangre y rociará parte de la sangre siete veces ante Yahvé, delante del velo del santuario. ");
INSERT INTO spablm_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","El sacerdote pondrá parte de la sangre en los cuernos del altar del incienso aromático, que está en la Tienda del Encuentro, y derramará el resto de la sangre del toro al pie del altar del holocausto, que está a la puerta de la Tienda del Encuentro. ");
INSERT INTO spablm_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Tomará de él toda la grasa del toro de la ofrenda por el pecado: la grasa que cubre las entrañas, y toda la grasa que está sobre las entrañas, ");
INSERT INTO spablm_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","y los dos riñones, y la grasa que está sobre ellos, que está junto a los lomos, y la cubierta del hígado, con los riñones, los quitará, ");
INSERT INTO spablm_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","como se quita del toro del sacrificio de paz. El sacerdote los quemará en el altar del holocausto. ");
INSERT INTO spablm_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Llevará la piel del toro, toda su carne, con su cabeza y con sus patas, sus entrañas y su estiércol ");
INSERT INTO spablm_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","— todo el resto del toro — fuera del campamento, a un lugar limpio donde se viertan las cenizas, y lo quemará sobre leña con fuego. Se quemará en el lugar donde se vierten las cenizas. ");
INSERT INTO spablm_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“‘Si toda la congregación de Israel peca, y el hecho está oculto a los ojos de la asamblea, y han hecho alguna de las cosas que Yahvé ha ordenado que no se hagan, y son culpables; ");
INSERT INTO spablm_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","cuando se conozca el pecado en que han incurrido, entonces la asamblea ofrecerá un novillo como ofrenda por el pecado, y lo traerá ante la Tienda del Encuentro. ");
INSERT INTO spablm_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Los ancianos de la congregación pondrán sus manos sobre la cabeza del toro delante de Yahvé, y el toro será sacrificado delante de Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","El sacerdote ungido llevará parte de la sangre del toro a la Tienda de reunión. ");
INSERT INTO spablm_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","El sacerdote mojará su dedo en la sangre y la rociará siete veces ante Yahvé, delante del velo. ");
INSERT INTO spablm_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Pondrá parte de la sangre en los cuernos del altar que está delante de Yahvé, que está en la Tienda del Encuentro; y el resto de la sangre lo derramará al pie del altar del holocausto, que está a la puerta de la Tienda del Encuentro. ");
INSERT INTO spablm_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Tomará toda su grasa y la quemará sobre el altar. ");
INSERT INTO spablm_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Hará esto con el toro; como hizo con el toro del sacrificio por el pecado, así hará con éste; y el sacerdote hará expiación por ellos, y serán perdonados. ");
INSERT INTO spablm_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Llevará el toro fuera del campamento y lo quemará como quemó el primer toro. Es la ofrenda por el pecado para la asamblea. ");
INSERT INTO spablm_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“‘Cuando un gobernante peca, y sin darse cuenta hace alguna de todas las cosas que Yahvé su Dios ha ordenado que no se hagan, y es culpable, ");
INSERT INTO spablm_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","si se le da a conocer el pecado en que ha incurrido, traerá como ofrenda un macho cabrío sin defecto. ");
INSERT INTO spablm_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Pondrá su mano sobre la cabeza del macho cabrío y lo matará en el lugar donde se mata el holocausto delante de Yahvé. Es una ofrenda por el pecado. ");
INSERT INTO spablm_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","El sacerdote tomará con su dedo parte de la sangre de la ofrenda por el pecado y la pondrá sobre los cuernos del altar del holocausto. El resto de la sangre la derramará al pie del altar del holocausto. ");
INSERT INTO spablm_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Toda su grasa la quemará sobre el altar, como la grasa del sacrificio de paz; y el sacerdote hará la expiación de su pecado, y será perdonado. ");
INSERT INTO spablm_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“‘Si alguno del pueblo común peca sin saberlo, haciendo alguna de las cosas que Yahvé ha ordenado no hacer, y es culpable, ");
INSERT INTO spablm_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","si se le da a conocer su pecado que ha cometido, entonces traerá para su ofrenda un macho cabrío, una hembra sin defecto, por su pecado que ha cometido. ");
INSERT INTO spablm_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Pondrá su mano sobre la cabeza de la ofrenda por el pecado, y matará la ofrenda por el pecado en el lugar del holocausto. ");
INSERT INTO spablm_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","El sacerdote tomará con su dedo parte de su sangre y la pondrá sobre los cuernos del altar del holocausto, y el resto de su sangre lo derramará al pie del altar. ");
INSERT INTO spablm_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Le quitará toda la grasa, como se quita la grasa del sacrificio de paz; y el sacerdote la hará arder sobre el altar como aroma agradable para Yahvé; y el sacerdote hará expiación por él, y será perdonado. ");
INSERT INTO spablm_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“‘Si trae un cordero como ofrenda por el pecado, traerá una hembra sin defecto. ");
INSERT INTO spablm_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Pondrá su mano sobre la cabeza de la ofrenda por el pecado, y la matará como ofrenda por el pecado en el lugar donde se mata el holocausto. ");
INSERT INTO spablm_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","El sacerdote tomará con su dedo una parte de la sangre de la ofrenda por el pecado y la pondrá sobre los cuernos del altar del holocausto; y todo el resto de su sangre lo derramará al pie del altar. ");
INSERT INTO spablm_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Quitará toda su grasa, como se quita la grasa del cordero del sacrificio de paz. El sacerdote los quemará sobre el altar, sobre las ofrendas de Yahvé hechas por el fuego. El sacerdote hará la expiación por su pecado que haya cometido, y será perdonado. ");
INSERT INTO spablm_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“‘Si alguien peca, al oír una admonición pública para testificar, siendo él un testigo, si ha visto o sabido, si no lo denuncia, entonces cargará con su iniquidad. ");
INSERT INTO spablm_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“‘O si alguien toca algo inmundo, ya sea el cadáver de un animal salvaje, o el cadáver de un animal doméstico, o el cadáver de un reptil inmundo, aunque no se de cuenta de ello, y se contamina, entonces será culpable. ");
INSERT INTO spablm_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","“‘O si toca la impureza del hombre, cualquiera que sea su impureza con la que esté impuro, pero no se da cuenta; cuando lo sepa, entonces será culpable. ");
INSERT INTO spablm_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","“‘O si alguno jura sin pensar con sus labios para hacer el mal o para hacer el bien — lo que sea que un hombre pueda decir sin pensar con un juramento, y se le oculta — cuando lo sepa, entonces será culpable de uno de estos. ");
INSERT INTO spablm_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Cuando sea culpable de una de estas cosas, deberá confesar aquello en lo que ha pecado; ");
INSERT INTO spablm_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","y traerá su ofrenda por la culpa a Yahvé por el pecado que ha cometido: una hembra del rebaño, una oveja o una cabra, como ofrenda por el pecado; y el sacerdote hará expiación por él respecto a su pecado. ");
INSERT INTO spablm_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“‘Si no puede comprar un cordero, entonces traerá su ofrenda por la culpa en la que ha pecado, dos tórtolas o dos pichones, a Yahvé; uno para la ofrenda por el pecado, y el otro para el holocausto. ");
INSERT INTO spablm_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Los traerá al sacerdote, quien ofrecerá primero el que es para la ofrenda por el pecado. Le desunirá la cabeza del cuello, pero no la cortará del todo. ");
INSERT INTO spablm_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Rociará una parte de la sangre de la ofrenda por el pecado a un lado del altar, y el resto de la sangre se escurrirá al pie del altar. Es una ofrenda por el pecado. ");
INSERT INTO spablm_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Ofrecerá el segundo como holocausto, según la ordenanza; y el sacerdote hará la expiación por su pecado que ha cometido, y será perdonado. ");
INSERT INTO spablm_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“‘Pero si no puede pagar dos tórtolas o dos pichones, entonces traerá como ofrenda por aquello en lo que pecó, la décima parte de un efa de harina fina como ofrenda por el pecado. No pondrá aceite ni incienso sobre ella, porque es una ofrenda por el pecado. ");
INSERT INTO spablm_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","La traerá al sacerdote, y el sacerdote tomará un puñado de ella como porción conmemorativa, y la quemará sobre el altar, sobre las ofrendas de Yahvé hechas por fuego. Es una ofrenda por el pecado. ");
INSERT INTO spablm_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","El sacerdote hará la expiación por su pecado que haya cometido en cualquiera de estas cosas, y será perdonado; y el resto será del sacerdote, como la ofrenda de comida.’” ");
INSERT INTO spablm_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Si alguien comete una infracción y peca involuntariamente con respecto a las cosas santas de Yahvé, entonces traerá su ofrenda por la infracción a Yahvé: un carnero sin defecto del rebaño, según tu estimación en plata por siclos, de acuerdo con el siclo del santuario, como ofrenda por la infracción. ");
INSERT INTO spablm_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Hará la restitución de lo que haya hecho mal con respecto a la cosa sagrada, y le añadirá una quinta parte, y se la dará al sacerdote; y el sacerdote hará la expiación por él con el carnero de la ofrenda por la culpa, y será perdonado. ");
INSERT INTO spablm_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“Si alguno peca, haciendo alguna de las cosas que Yahvé ha mandado no hacer, aunque no lo supiera, sigue siendo culpable, y llevará su iniquidad. ");
INSERT INTO spablm_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Traerá al sacerdote un carnero sin defecto del rebaño, según tu estimación, como ofrenda por la culpa; y el sacerdote hará expiación por él en cuanto a la cosa en que pecó y no lo sabía, y será perdonado. ");
INSERT INTO spablm_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Es una ofrenda por la culpa. Ciertamente es culpable ante Yahvé”. ");
INSERT INTO spablm_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Si alguno peca y comete una transgresión contra Yahvé, y trata con falsedad a su prójimo en un asunto de depósito, o de negociación, o de robo, o ha oprimido a su prójimo, ");
INSERT INTO spablm_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","o ha encontrado lo que se había perdido y ha mentido sobre ello, y jurando en una mentira-en cualquiera de estas cosas que un hombre peca en sus acciones— ");
INSERT INTO spablm_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","entonces será, si ha pecado, y es culpable, deberá restaurar lo que tomó por robo, o la cosa que ha obtenido por opresión, o el depósito que le fue encomendado, o la cosa perdida que encontró, ");
INSERT INTO spablm_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","o cualquier cosa sobre la que ha jurado en falso: lo restituirá íntegramente, y le añadirá una quinta parte más. Lo devolverá a su dueño el día que sea declarado culpable. ");
INSERT INTO spablm_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Traerá su ofrenda por la culpa a Yahvé: un carnero sin defecto del rebaño, según tu estimación, como ofrenda por la culpa, al sacerdote. ");
INSERT INTO spablm_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","El sacerdote hará expiación por él ante Yahvé, y se le perdonará todo lo que haga para ser culpable.” ");
INSERT INTO spablm_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Manda a Aarón y a sus hijos, diciendo: ‘Esta es la ley del holocausto: el holocausto estará sobre el hogar del altar toda la noche hasta la mañana; y el fuego del altar se mantendrá encendido sobre él. ");
INSERT INTO spablm_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","El sacerdote se pondrá su vestimenta de lino, y se pondrá sus pantalones de lino sobre su cuerpo; y quitará las cenizas de donde el fuego haya consumido el holocausto en el altar, y las pondrá junto al altar. ");
INSERT INTO spablm_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Se quitará sus vestidos y se pondrá otros, y llevará las cenizas fuera del campamento a un lugar limpio. ");
INSERT INTO spablm_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","El fuego del altar se mantendrá encendido en él, no se apagará; y el sacerdote quemará leña en él cada mañana. Pondrá el holocausto en orden sobre él, y quemará sobre él la grasa de los sacrificios de paz. ");
INSERT INTO spablm_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","El fuego se mantendrá encendido sobre el altar continuamente; no se apagará. ");
INSERT INTO spablm_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“‘Esta es la ley de la ofrenda de cereal: los hijos de Aarón la ofrecerán ante Yahvé, delante del altar. ");
INSERT INTO spablm_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","El hijo de Aarón tomará de allí un puñado de la flor de harina de la ofrenda, y de su aceite, y todo el incienso que esté sobre la ofrenda, y lo hará arder sobre el altar en olor agradable, como su porción conmemorativa, para Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Lo que quede de ella lo comerán Aarón y sus hijos. Se comerá sin levadura en un lugar sagrado. Lo comerán en el atrio de la Tienda de Reunión. ");
INSERT INTO spablm_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","No se cocinará con levadura. Yo se lo he dado como su porción de mis ofrendas hechas por el fuego. Es muy sagrada, al igual que la ofrenda por el pecado y la ofrenda por la culpa. ");
INSERT INTO spablm_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Todo varón de los hijos de Aarón comerán de ella, como su porción para siempre a lo largo de vuestras generaciones, de las ofrendas quemadas de Yahvé. El que las toque será santo”. ");
INSERT INTO spablm_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Yahvé habló a Moisés diciendo: ");
INSERT INTO spablm_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Esta es la ofrenda de Aarón y de sus hijos, que ofrecerán a Yahvé el día en que sea ungido: la décima parte de un efa de harina fina como ofrenda perpetua, la mitad por la mañana y la otra mitad por la tarde. ");
INSERT INTO spablm_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Se hará con aceite en una plancha. Cuando esté empapado, lo traerás. Ofrecerás la ofrenda de comida en trozos cocidos como aroma agradable a Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","La ofrecerá el sacerdote ungido que estará en su lugar de entre sus hijos. Como estatuto para siempre, será quemada en su totalidad a Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Toda ofrenda de un sacerdote será quemada por completo. No se comerá”. ");
INSERT INTO spablm_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Habla a Aarón y a sus hijos, diciendo: ‘Esta es la ley del sacrificio por el pecado: en el lugar donde se mata el holocausto, se matará el sacrificio por el pecado delante de Yahvé. Es algo muy sagrado. ");
INSERT INTO spablm_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","El sacerdote que la ofrezca por el pecado la comerá. Se comerá en un lugar sagrado, en el atrio de la Tienda de Reunión. ");
INSERT INTO spablm_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Todo lo que toque su carne será sagrado. Cuando su sangre haya sido rociada sobre una prenda de vestir, lavarás la prenda sobre la que fue rociada en un lugar santo. ");
INSERT INTO spablm_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Pero la vasija de barro en que se haya cocido se romperá; y si se ha cocido en una vasija de bronce, se lavará y se enjuagará con agua. ");
INSERT INTO spablm_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Todo varón de entre los sacerdotes comerá de ella. Es algo muy sagrado. ");
INSERT INTO spablm_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","No se comerá ninguna ofrenda por el pecado cuya sangre se introduzca en la Tienda de Reunión para hacer expiación en el Lugar Santo. Se quemará con fuego. ");
INSERT INTO spablm_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“‘Esta es la ley de la ofrenda por la culpa: Es santísima. ");
INSERT INTO spablm_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","En el lugar donde se mata el holocausto, se matará la ofrenda por la culpa, y su sangre se esparcirá alrededor del altar. ");
INSERT INTO spablm_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Ofrecerá toda su grasa: el rabo gordo y la grasa que cubre las vísceras, ");
INSERT INTO spablm_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","y quitará los dos riñones, y la grasa que está sobre ellos, que está junto a los lomos, y la cubierta del hígado, con los riñones; ");
INSERT INTO spablm_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","y el sacerdote los quemará en el altar como ofrenda encendida a Yahvé: es una ofrenda por la culpa. ");
INSERT INTO spablm_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Todo varón de entre los sacerdotes podrá comer de ella. Se comerá en un lugar sagrado. Es algo muy sagrado. ");
INSERT INTO spablm_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“‘Como la ofrenda por el pecado, así es la ofrenda por la culpa; hay una sola ley para ellos. El sacerdote que haga la expiación con ellos la tendrá. ");
INSERT INTO spablm_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","El sacerdote que ofrezca el holocausto de cualquier hombre tendrá para sí la piel del holocausto que haya ofrecido. ");
INSERT INTO spablm_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Toda ofrenda que se cocine en el horno, y todo lo que se prepare en la sartén y en la plancha, será del sacerdote que la ofrezca. ");
INSERT INTO spablm_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Toda ofrenda, mezclada con aceite o seca, pertenece a todos los hijos de Aarón, tanto a unos como a otros. ");
INSERT INTO spablm_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“‘Esta es la ley del sacrificio de las ofrendas de paz, que uno debe ofrecer a Yahvé: ");
INSERT INTO spablm_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Si lo ofrece para una acción de gracias, ofrecerá con el sacrificio de acción de gracias tortas sin levadura mezcladas con aceite, y obleas sin levadura untadas con aceite, y tortas mezcladas con aceite. ");
INSERT INTO spablm_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Con el sacrificio de sus ofrendas de paz para la acción de gracias, ofrecerá su ofrenda con tortas de pan leudado. ");
INSERT INTO spablm_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","De cada una de las ofrendas ofrecerá una como ofrenda a Yahvé. Será del sacerdote que rocía la sangre de los sacrificios de paz. ");
INSERT INTO spablm_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","La carne del sacrificio de sus ofrendas de paz para la acción de gracias se comerá el día de su ofrenda. No dejará nada de ella hasta la mañana siguiente. ");
INSERT INTO spablm_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“‘Pero si el sacrificio de su ofrenda es un voto, o una ofrenda voluntaria, se comerá el día en que ofrezca su sacrificio. Al día siguiente se comerá lo que quede de él, ");
INSERT INTO spablm_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","pero lo que quede de la carne del sacrificio al tercer día se quemará con fuego. ");
INSERT INTO spablm_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Si algo de la carne del sacrificio de sus ofrendas de paz se come al tercer día, no se aceptará y no se le acreditará al que lo ofrezca. Será una abominación, y el alma que coma algo de ella cargará con su iniquidad. ");
INSERT INTO spablm_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“‘La carne que toque cualquier cosa impura no se comerá. Se quemará con fuego. En cuanto a la carne, todo el que esté limpio podrá comerla; ");
INSERT INTO spablm_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","pero la persona que coma de la carne del sacrificio de paz que pertenece a Yahvé, teniendo su impureza encima, esa persona será cortada de su pueblo. ");
INSERT INTO spablm_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Cuando alguien toque alguna cosa impura, impureza de hombre, o animal impuro, o cualquier abominación impura, y coma algo de la carne del sacrificio de paz que pertenece a Yahvé, esa alma será cortada de su pueblo.’” ");
INSERT INTO spablm_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Yahvé habló a Moisés diciendo: ");
INSERT INTO spablm_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Habla a los hijos de Israel diciendo: No comeréis grasa de toro, ni de oveja, ni de cabra. ");
INSERT INTO spablm_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","La grasa de la que muere por sí misma, y la grasa de la que se desgarra de los animales, puede usarse para cualquier otro servicio, pero de ninguna manera comeréis de ella. ");
INSERT INTO spablm_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Porque el que coma la grasa del animal que los hombres ofrecen como ofrenda encendida a Yahvé, el alma que la coma será cortada de su pueblo. ");
INSERT INTO spablm_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","No comeréis sangre, ni de aves ni de animales, en ninguna de vuestras viviendas. ");
INSERT INTO spablm_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Cualquiera que coma sangre, esa alma será cortada de su pueblo”. ");
INSERT INTO spablm_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Habla a los hijos de Israel, diciendo: ‘El que ofrece el sacrificio de sus ofrendas de paz a Yahvé, traerá su ofrenda a Yahvé del sacrificio de sus ofrendas de paz. ");
INSERT INTO spablm_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Con sus propias manos traerá las ofrendas a Yahvé hechas al fuego. Traerá la grasa con el pecho, para que el pecho sea mecido como ofrenda mecida ante Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","El sacerdote quemará la grasa sobre el altar, pero el pecho será de Aarón y de sus hijos. ");
INSERT INTO spablm_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","El muslo derecho se lo darás al sacerdote como ofrenda elevada de los sacrificios de tus ofrendas de paz. ");
INSERT INTO spablm_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","El que de entre los hijos de Aarón ofrezca la sangre de los sacrificios de paz y la grasa, tendrá el muslo derecho como porción. ");
INSERT INTO spablm_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Porque el pecho ondulado y el muslo abultado los he tomado de los hijos de Israel de los sacrificios de sus ofrendas de paz, y se los he dado a Aarón el sacerdote y a sus hijos como su porción para siempre de los hijos de Israel.’” ");
INSERT INTO spablm_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Esta es la porción consagrada de Aarón y la porción consagrada de sus hijos, de las ofrendas a Yahvé hechas por el fuego, el día en que los presentó para servir a Yahvé en el oficio sacerdotal; ");
INSERT INTO spablm_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","que Yahvé ordenó que se les diera de los hijos de Israel, el día en que los ungió. Es su porción para siempre a través de sus generaciones. ");
INSERT INTO spablm_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Esta es la ley del holocausto, de la ofrenda, de la ofrenda por el pecado, de la ofrenda por la culpa, de la consagración y del sacrificio de las ofrendas de paz ");
INSERT INTO spablm_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","que Yahvé ordenó a Moisés en el monte Sinaí el día en que ordenó a los hijos de Israel que ofrecieran sus ofrendas a Yahvé, en el desierto de Sinaí. ");
INSERT INTO spablm_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Toma a Aarón y a sus hijos con él, y las vestiduras, y el aceite de la unción, y el toro de la ofrenda por el pecado, y los dos carneros, y el cesto de los panes sin levadura; ");
INSERT INTO spablm_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","y reúne a toda la congregación a la puerta de la Tienda del Encuentro.” ");
INSERT INTO spablm_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Moisés hizo lo que Yahvé le ordenó, y la congregación se reunió a la puerta de la Tienda de Reunión. ");
INSERT INTO spablm_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Moisés dijo a la congregación: “Esto es lo que Yahvé ha mandado hacer”. ");
INSERT INTO spablm_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Moisés trajo a Aarón y a sus hijos, y los lavó con agua. ");
INSERT INTO spablm_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Le puso la túnica, le ató el fajín, lo vistió con el manto, le puso el efod, le ató la banda hábilmente tejida del efod y se la sujetó con ella. ");
INSERT INTO spablm_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Le puso el pectoral. Puso el Urim y el Tumim en el pectoral. ");
INSERT INTO spablm_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Le puso el turbante en la cabeza. Puso la placa de oro, la corona sagrada, en la parte delantera del turbante, como Yahvé le ordenó a Moisés. ");
INSERT INTO spablm_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Moisés tomó el aceite de la unción, ungió el tabernáculo y todo lo que había en él, y lo santificó. ");
INSERT INTO spablm_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Lo roció sobre el altar siete veces, y ungió el altar y todos sus utensilios, y la pila y su base, para santificarlos. ");
INSERT INTO spablm_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Derramó parte del aceite de la unción sobre la cabeza de Aarón y lo ungió para santificarlo. ");
INSERT INTO spablm_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Moisés trajo a los hijos de Aarón y los vistió con túnicas, les ató fajas y les puso cintillos, como el Señor le había ordenado a Moisés. ");
INSERT INTO spablm_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Trajo el becerro del sacrificio por el pecado, y Aarón y sus hijos pusieron sus manos sobre la cabeza del becerro del sacrificio por el pecado. ");
INSERT INTO spablm_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Lo mató, y Moisés tomó la sangre y la puso alrededor de los cuernos del altar con su dedo, y purificó el altar, y derramó la sangre al pie del altar, y lo santificó para hacer expiación. ");
INSERT INTO spablm_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Tomó toda la grasa que había en las vísceras, y la cubierta del hígado, y los dos riñones y su grasa; y Moisés lo quemó sobre el altar. ");
INSERT INTO spablm_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Pero el toro, su piel, su carne y su estiércol los quemó con fuego fuera del campamento, como Yahvé le había ordenado a Moisés. ");
INSERT INTO spablm_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Presentó el carnero del holocausto. Aarón y sus hijos pusieron sus manos sobre la cabeza del carnero. ");
INSERT INTO spablm_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Lo mató, y Moisés roció la sangre alrededor del altar. ");
INSERT INTO spablm_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Cortó el carnero en pedazos, y Moisés quemó la cabeza, los pedazos y la grasa. ");
INSERT INTO spablm_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Lavó con agua las vísceras y las patas, y Moisés quemó todo el carnero sobre el altar. Era un holocausto de aroma agradable. Era una ofrenda hecha por fuego a Yahvé, como Yahvé le había ordenado a Moisés. ");
INSERT INTO spablm_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Presentó el otro carnero, el de la consagración. Aarón y sus hijos pusieron sus manos sobre la cabeza del carnero. ");
INSERT INTO spablm_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Lo mató, y Moisés tomó un poco de su sangre y la puso en la punta de la oreja derecha de Aarón, en el pulgar de su mano derecha y en el dedo gordo de su pie derecho. ");
INSERT INTO spablm_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Hizo venir a los hijos de Aarón, y Moisés puso un poco de la sangre en la punta de su oreja derecha, en el pulgar de su mano derecha y en el dedo gordo de su pie derecho; y Moisés roció la sangre alrededor del altar. ");
INSERT INTO spablm_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Tomó la grasa, la cola de grasa, toda la grasa que había en las vísceras, la cubierta del hígado, los dos riñones y su grasa, y el muslo derecho; ");
INSERT INTO spablm_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","y del canasto de los panes sin levadura que estaba delante de Yahvé, tomó una torta sin levadura, una torta de pan aceitado y una oblea, y las puso sobre la grasa y sobre el muslo derecho. ");
INSERT INTO spablm_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Puso todo esto en las manos de Aarón y en las de sus hijos, y los agitó como ofrenda mecida ante Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Moisés se los quitó de las manos y los quemó en el altar, sobre el holocausto. Eran una ofrenda de consagración para un aroma agradable. Era una ofrenda hecha por fuego a Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Moisés tomó el pecho y lo agitó como ofrenda mecida ante Yahvé. Era la porción que le correspondía a Moisés del carnero de la consagración, tal como el Señor se lo había ordenado. ");
INSERT INTO spablm_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Moisés tomó un poco del aceite de la unción y un poco de la sangre que estaba sobre el altar, y lo roció sobre Aarón, sobre sus vestidos, sobre sus hijos y sobre los vestidos de sus hijos con él, y santificó a Aarón, sus vestidos, sus hijos y los vestidos de sus hijos con él. ");
INSERT INTO spablm_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Moisés dijo a Aarón y a sus hijos: “Haced hervir la carne a la puerta de la Tienda de las Reuniones, y comed allí la carne y el pan que está en el cesto de las consagraciones, como yo lo he mandado, diciendo: ‘Aarón y sus hijos lo comerán’. ");
INSERT INTO spablm_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Lo que quede de la carne y del pan lo quemarás al fuego. ");
INSERT INTO spablm_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","No saldrás de la puerta de la Tienda de Reunión durante siete días, hasta que se cumplan los días de tu consagración; porque él te consagrará durante siete días. ");
INSERT INTO spablm_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Lo que se ha hecho hoy, así lo ha mandado hacer Yahvé, para hacer expiación por vosotros. ");
INSERT INTO spablm_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Permaneceréis a la puerta de la Tienda de Reunión día y noche durante siete días, y cumpliréis la orden de Yahvé, para que no muráis; porque así me ha sido ordenado.” ");
INSERT INTO spablm_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Aarón y sus hijos hicieron todo lo que Yahvé ordenó por medio de Moisés. ");
INSERT INTO spablm_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Al octavo día, Moisés llamó a Aarón y a sus hijos, y a los ancianos de Israel; ");
INSERT INTO spablm_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","y dijo a Aarón: “Toma un becerro de la manada para una ofrenda por el pecado, y un carnero para un holocausto, sin defecto, y ofrécelos ante Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Hablarás a los hijos de Israel, diciendo: “Tomad un macho cabrío para la ofrenda por el pecado, y un ternero y un cordero, ambos de un año, sin defecto, para el holocausto; ");
INSERT INTO spablm_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","y un toro y un carnero para las ofrendas de paz, para sacrificar ante Yahvé; y una ofrenda de harina mezclada con aceite, porque hoy Yahvé se os aparece.” ");
INSERT INTO spablm_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Trajeron lo que Moisés había ordenado ante la Tienda del Encuentro. Toda la congregación se acercó y se puso de pie ante el Señor. ");
INSERT INTO spablm_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Moisés dijo: “Esto es lo que Yahvé mandó que hicieran, y la gloria de Yahvé se les aparecerá”. ");
INSERT INTO spablm_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Moisés dijo a Aarón: “Acércate al altar y ofrece tu ofrenda por el pecado y tu holocausto, y haz la expiación por ti y por el pueblo; y ofrece la ofrenda del pueblo y haz la expiación por ellos, como lo ha ordenado Yahvé.” ");
INSERT INTO spablm_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Entonces Aarón se acercó al altar y mató el becerro de la ofrenda por el pecado, que era para él. ");
INSERT INTO spablm_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Los hijos de Aarón le presentaron la sangre, y él mojó su dedo en la sangre, y la puso sobre los cuernos del altar, y derramó la sangre al pie del altar; ");
INSERT INTO spablm_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","pero la grasa, los riñones y la cubierta del hígado de la ofrenda por el pecado, los quemó sobre el altar, como Yahvé le había ordenado a Moisés. ");
INSERT INTO spablm_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","La carne y la piel las quemó con fuego fuera del campamento. ");
INSERT INTO spablm_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Mató el holocausto, y los hijos de Aarón le entregaron la sangre, y él la roció alrededor del altar. ");
INSERT INTO spablm_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Le entregaron el holocausto, pieza por pieza, y la cabeza. Él los quemó sobre el altar. ");
INSERT INTO spablm_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Lavó las vísceras y las patas, y las quemó sobre el holocausto en el altar. ");
INSERT INTO spablm_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Presentó la ofrenda del pueblo y tomó el macho cabrío de la ofrenda por el pecado que era para el pueblo, lo mató y lo ofreció por el pecado, como el primero. ");
INSERT INTO spablm_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Presentó el holocausto, y lo ofreció según la ordenanza. ");
INSERT INTO spablm_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Presentó el holocausto, y llenó su mano de él, y lo quemó sobre el altar, además del holocausto de la mañana. ");
INSERT INTO spablm_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","También sacrificó el toro y el carnero, el sacrificio de paz, que era para el pueblo. Los hijos de Aarón le entregaron la sangre, que roció alrededor del altar; ");
INSERT INTO spablm_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","y la grasa del toro y del carnero, la cola gorda, y lo que cubre las entrañas, y los riñones, y la cubierta del hígado; ");
INSERT INTO spablm_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","y pusieron la grasa sobre los pechos, y quemó la grasa sobre el altar. ");
INSERT INTO spablm_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Aarón agitó los pechos y el muslo derecho como ofrenda mecida ante Yahvé, tal como lo había ordenado Moisés. ");
INSERT INTO spablm_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Aarón levantó sus manos hacia el pueblo y lo bendijo, y bajó de ofrecer la ofrenda por el pecado, el holocausto y las ofrendas de paz. ");
INSERT INTO spablm_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Moisés y Aarón entraron en la Tienda del Encuentro, salieron y bendijeron al pueblo, y la gloria de Yahvé apareció ante todo el pueblo. ");
INSERT INTO spablm_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","El fuego salió de delante de Yahvé y consumió el holocausto y la grasa sobre el altar. Cuando todo el pueblo lo vio, gritó y se postró sobre sus rostros. ");
INSERT INTO spablm_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Nadab y Abiú, hijos de Aarón, tomaron cada uno su incensario, pusieron fuego en él y colocaron incienso, y ofrecieron delante de Yahvé un fuego extraño que él no les había mandado. ");
INSERT INTO spablm_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Salió fuego de delante de Yahvé y los devoró, y murieron delante de Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Entonces Moisés le dijo a Aarón: “Esto es lo que habló Yahvé, diciendo, Me mostraré santo a los que se acerquen a mí, y ante todo el pueblo seré glorificado”. Aarón calló. ");
INSERT INTO spablm_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Moisés llamó a Misael y a Elzafán, hijos de Uziel, tío de Aarón, y les dijo: “Acérquense y saquen a sus hermanos de delante del santuario fuera del campamento.” ");
INSERT INTO spablm_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Se acercaron, pues, y los llevaron en sus túnicas fuera del campamento, como Moisés había dicho. ");
INSERT INTO spablm_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Moisés dijo a Aarón, a Eleazar y a Itamar, sus hijos: “No os soltéis el pelo de la cabeza, ni os rasguéis las vestiduras, para que no muráis, y para que no se enoje con toda la congregación; pero que vuestros hermanos, toda la casa de Israel, se lamenten por el fuego que Yahvé ha encendido. ");
INSERT INTO spablm_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","No saldrás de la puerta de la Tienda del Encuentro, para que no mueras, porque el aceite de la unción de Yahvé está sobre ti.” Ellos hicieron lo que dijo Moisés. ");
INSERT INTO spablm_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Entonces Yahvé le dijo a Aarón: ");
INSERT INTO spablm_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Tú y tus hijos no deben beber vino ni bebida fuerte cada vez que entren en la Tienda del Encuentro, o morirán. Esto será un estatuto para siempre a lo largo de vuestras generaciones. ");
INSERT INTO spablm_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Debes distinguir entre lo santo y lo común, y entre lo inmundo y lo limpio. ");
INSERT INTO spablm_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Enseñarás a los hijos de Israel todos los estatutos que Yahvé les ha dicho por medio de Moisés.” ");
INSERT INTO spablm_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Moisés dijo a Aarón, a Eleazar y a Itamar, sus hijos que habían quedado: “Tomad la ofrenda que queda de las ofrendas encendidas a Yahvé, y comedla sin levadura junto al altar, porque es santísima; ");
INSERT INTO spablm_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","y la comeréis en lugar santo, porque es vuestra porción y la de vuestros hijos, de las ofrendas encendidas a Yahvé; porque así me ha sido ordenado. ");
INSERT INTO spablm_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","El pecho de la ofrenda mecida y el muslo elevado los comeréis en un lugar limpio, tú, tus hijos y tus hijas contigo, porque son dados como tu porción y la de tus hijos, de los sacrificios de las ofrendas de paz de los hijos de Israel. ");
INSERT INTO spablm_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Traerán el muslo elevado y el pecho mecido con las ofrendas encendidas de la grasa, para mecerlo como ofrenda mecida ante Yahvé. Será de ustedes, y de sus hijos con ustedes, como porción para siempre, como lo ha ordenado Yahvé”. ");
INSERT INTO spablm_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Moisés indagó diligentemente sobre el macho cabrío de la ofrenda por el pecado, y, he aquí, fue quemado. Se enojó con Eleazar y con Itamar, los hijos de Aarón que habían quedado, diciendo: ");
INSERT INTO spablm_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“¿Por qué no habéis comido la ofrenda por el pecado en el lugar del santuario, ya que es santísima, y él os la ha dado para que carguéis con la iniquidad de la congregación, para hacer expiación por ellos ante Yahvé? ");
INSERT INTO spablm_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","He aquí que su sangre no fue llevada al interior del santuario. Ciertamente debisteis comerlo en el santuario, como yo lo ordené”. ");
INSERT INTO spablm_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Aarón habló a Moisés: “He aquí que hoy han ofrecido su ofrenda por el pecado y su holocausto ante Yahvé, y me han sucedido cosas como éstas. Si yo hubiera comido hoy la ofrenda por el pecado, ¿habría sido agradable a los ojos de Yahvé?” ");
INSERT INTO spablm_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Cuando Moisés lo oyó, le pareció bien. ");
INSERT INTO spablm_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Yahvé habló a Moisés y a Aarón, diciéndoles: ");
INSERT INTO spablm_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Hablad a los hijos de Israel, diciendo: “Estos son los seres vivos que podéis comer de entre todos los animales que hay en la tierra. ");
INSERT INTO spablm_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Todo lo que tiene pezuña hendida y rumia entre los animales, eso podéis comer. ");
INSERT INTO spablm_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","“‘Sin embargo, no comeréis de los que rumian, ni de los que parten la pezuña: el camello, porque rumia pero no tiene la pezuña partida, es inmundo para vosotros. ");
INSERT INTO spablm_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","El huracán, porque mastica el bolo alimenticio, pero no tiene la pezuña partida, es impuro para ti. ");
INSERT INTO spablm_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","La liebre, por masticar el bolo alimenticio, pero sin tener la pezuña abierta, es impura para ustedes. ");
INSERT INTO spablm_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","El cerdo, porque tiene la pezuña hendida y es de pezuña hendida, pero no rumia, es inmundo para ti. ");
INSERT INTO spablm_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","No comerás su carne. No tocarás sus cadáveres. Son impuros para ti. ");
INSERT INTO spablm_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“‘Puedes comer de todo lo que está en las aguas: todo lo que tiene aletas y escamas en las aguas, en los mares y en los ríos, eso puedes comer. ");
INSERT INTO spablm_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Todo lo que no tiene aletas y escamas en los mares y ríos, todo lo que se mueve en las aguas, y todos los seres vivos que están en las aguas, son una abominación para ti, ");
INSERT INTO spablm_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","y los detestarás. No comerás su carne, y aborrecerás sus cadáveres. ");
INSERT INTO spablm_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Todo lo que no tenga aletas ni escamas en las aguas es una abominación para ti. ");
INSERT INTO spablm_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“‘Aborrecerás éstas entre las aves; no se comerán porque son una abominación: el águila, el buitre, el buitre negro, ");
INSERT INTO spablm_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","el milano real, cualquier tipo de milano negro, ");
INSERT INTO spablm_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","cualquier tipo de cuervo, ");
INSERT INTO spablm_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","el búho cornudo, el búho chillón, la gaviota, cualquier tipo de halcón, ");
INSERT INTO spablm_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","el búho pequeño, el cormorán, el búho grande, ");
INSERT INTO spablm_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","el búho blanco, el búho del desierto, el águila pescadora, ");
INSERT INTO spablm_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","la cigüeña, cualquier tipo de garza, la abubilla y el murciélago. ");
INSERT INTO spablm_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“‘Todos los insectos voladores que andan a cuatro patas son una abominación para ti. ");
INSERT INTO spablm_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Sin embargo, puedes comer estos: de todos los reptiles alados que andan a cuatro patas, que tienen patas largas y articuladas para saltar sobre la tierra. ");
INSERT INTO spablm_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Incluso de estos podréis comer: cualquier tipo de langosta, cualquier tipo de cateta, cualquier tipo de grillo y cualquier tipo de saltamontes. ");
INSERT INTO spablm_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Pero todos los reptiles alados que tienen cuatro patas son una abominación para ustedes. ");
INSERT INTO spablm_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“‘Por ellos quedarás impuro: el que toque sus cadáveres quedará impuro hasta la noche. ");
INSERT INTO spablm_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","El que levante alguna parte de sus cadáveres se lavará la ropa y quedará impuro hasta la noche. ");
INSERT INTO spablm_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","“‘Todo animal que tenga una pezuña partida que no esté completamente dividida, o que no rumie, es impuro para ti. Todo el que los toque será impuro. ");
INSERT INTO spablm_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Todo lo que vaya sobre sus patas, entre todos los animales que van a cuatro patas, son inmundos para ti. El que toque sus cadáveres quedará impuro hasta la noche. ");
INSERT INTO spablm_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","El que levante su cadáver se lavará la ropa y quedará impuro hasta la noche. Son inmundos para ti. ");
INSERT INTO spablm_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“‘Estos son los inmundos para vosotros entre los reptiles que se arrastran por la tierra: la comadreja, la rata, cualquier clase de lagarto grande, ");
INSERT INTO spablm_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","la salamanquesa, y el lagarto monitor, el lagarto de pared, el eslizón y el camaleón. ");
INSERT INTO spablm_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Estos son los impuros para vosotros entre todos los que se arrastran. El que los toque cuando estén muertos será impuro hasta la noche. ");
INSERT INTO spablm_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Todo lo que caiga sobre ellos cuando estén muertos será impuro; ya sea un recipiente de madera, ropa, piel o saco, cualquiera que sea el recipiente con el que se haga cualquier trabajo, deberá ser puesto en agua, y quedará impuro hasta la noche. Entonces quedará limpio. ");
INSERT INTO spablm_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Toda vasija de barro en la que caiga cualquiera de ellas y todo lo que haya en ella será impuro. Lo romperás. ");
INSERT INTO spablm_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Todo alimento que se pueda comer y que esté empapado en agua será impuro. Toda la bebida que se beba en cualquiera de esos recipientes será inmunda. ");
INSERT INTO spablm_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Todo aquello sobre lo que caiga una parte de su cuerpo será inmundo; ya sea el horno o la cocina para las ollas, se romperá en pedazos. Son inmundos, y serán inmundos para vosotros. ");
INSERT INTO spablm_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Sin embargo, el manantial o la cisterna donde se recoja el agua serán limpios, pero lo que toque su cadáver será impuro. ");
INSERT INTO spablm_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Si parte de su cadáver cae sobre cualquier semilla que se vaya a sembrar, será limpia. ");
INSERT INTO spablm_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Pero si se pone agua sobre la semilla, y parte de su cadáver cae sobre ella, será impuro para ti. ");
INSERT INTO spablm_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“‘Si algún animal de los que puedes comer muere, el que toque su cadáver quedará impuro hasta la noche. ");
INSERT INTO spablm_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","El que coma de su cadáver lavará sus vestidos y quedará impuro hasta la noche. El que lleve su cadáver lavará su ropa y quedará impuro hasta la noche. ");
INSERT INTO spablm_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“‘Todo lo que se arrastra por la tierra es una abominación. No se comerá. ");
INSERT INTO spablm_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Todo lo que ande sobre su vientre, y todo lo que ande a cuatro patas, o todo lo que tenga muchas patas, todo lo que se arrastra sobre la tierra, no lo comeréis, porque es una abominación. ");
INSERT INTO spablm_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","No os haréis abominables con ningún reptil que se arrastre. No os haréis inmundos con ellos, para que os contaminéis con ellos. ");
INSERT INTO spablm_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Porque yo soy Yahvé, vuestro Dios. Santificaos, pues, y sed santos, porque yo soy santo. No os contaminaréis con ningún animal que se mueva sobre la tierra. ");
INSERT INTO spablm_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Porque yo soy Yahvé, que os he sacado de la tierra de Egipto para ser vuestro Dios. Seréis, pues, santos, porque yo soy santo. ");
INSERT INTO spablm_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“‘Esta es la ley del animal, del ave y de todo ser viviente que se mueve en las aguas, y de todo ser que se arrastra por la tierra, ");
INSERT INTO spablm_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","para distinguir entre lo inmundo y lo limpio, y entre lo que se puede comer y lo que no se puede comer’”. ");
INSERT INTO spablm_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Habla a los hijos de Israel, diciendo: Si una mujer concibe y da a luz un hijo varón, será impura siete días; como en los días de su menstruación será impura. ");
INSERT INTO spablm_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Al octavo día se circuncidará la carne de su prepucio. ");
INSERT INTO spablm_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Ella permanecerá en la sangre de purificación treinta y tres días. No tocará ninguna cosa sagrada, ni entrará en el santuario, hasta que se completen los días de su purificación. ");
INSERT INTO spablm_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Pero si da a luz a una niña, será impura dos semanas, como en su período; y permanecerá en la sangre de purificación sesenta y seis días. ");
INSERT INTO spablm_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“‘Cuando se completen los días de su purificación por un hijo o por una hija, ella traerá al sacerdote, a la puerta de la Tienda de Reunión, un cordero de un año para el holocausto, y un pichón o una tórtola, para el sacrificio por el pecado. ");
INSERT INTO spablm_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Él la ofrecerá ante Yahvé y hará expiación por ella; entonces quedará limpia de la fuente de su sangre. “‘Esta es la ley para la que da a luz, sea macho o hembra. ");
INSERT INTO spablm_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Si no puede comprar un cordero, tomará dos tórtolas o dos pichones: uno para el holocausto y el otro para el sacrificio por el pecado. El sacerdote hará expiación por ella, y quedará limpia”. ");
INSERT INTO spablm_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Yahvé habló a Moisés y a Aarón, diciendo: ");
INSERT INTO spablm_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Cuando un hombre tenga una hinchazón en la piel de su cuerpo, o una costra, o una mancha brillante, y se convierta en la piel de su cuerpo en la plaga de la lepra, entonces será llevado al sacerdote Aarón o a uno de sus hijos, los sacerdotes. ");
INSERT INTO spablm_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","El sacerdote examinará la plaga en la piel del cuerpo. Si el pelo de la plaga se ha vuelto blanco, y el aspecto de la plaga es más profundo que la piel del cuerpo, se trata de una plaga de lepra; entonces el sacerdote lo examinará y lo declarará impuro. ");
INSERT INTO spablm_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Si la mancha es blanca en la piel de su cuerpo, y su apariencia no es más profunda que la piel, y su pelo no se ha vuelto blanco, entonces el sacerdote aislará a la persona infectada durante siete días. ");
INSERT INTO spablm_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","El sacerdote lo examinará al séptimo día. Si en sus ojos la plaga está detenida y la plaga no se ha extendido en la piel, entonces el sacerdote lo aislará por siete días más. ");
INSERT INTO spablm_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","El sacerdote lo examinará de nuevo al séptimo día. Si la peste ha desaparecido y no se ha extendido por la piel, el sacerdote lo declarará limpio. Se trata de una costra. Se lavará la ropa y quedará limpio. ");
INSERT INTO spablm_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Pero si la costra se extiende en la piel después de haberse presentado al sacerdote para su purificación, se presentará de nuevo al sacerdote. ");
INSERT INTO spablm_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","El sacerdote lo examinará, y si la costra se ha extendido por la piel, el sacerdote lo declarará impuro. Es lepra. ");
INSERT INTO spablm_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“Cuando la plaga de la lepra esté en un hombre, será llevado al sacerdote; ");
INSERT INTO spablm_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","y el sacerdote lo examinará. Si hay una hinchazón blanca en la piel, que ha vuelto blanco el cabello, y hay carne viva en la hinchazón, ");
INSERT INTO spablm_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","se trata de una lepra crónica en la piel de su cuerpo, y el sacerdote lo declarará impuro. No lo aislará, porque ya está impuro. ");
INSERT INTO spablm_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“Si la lepra brota por toda la piel, y la lepra cubre toda la piel del infectado, desde la cabeza hasta los pies, según lo que le parezca al sacerdote, ");
INSERT INTO spablm_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","entonces el sacerdote lo examinará. Si la lepra ha cubierto toda su carne, lo declarará limpio de la plaga. Todo se ha vuelto blanco: está limpio. ");
INSERT INTO spablm_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Pero cuando la carne viva aparezca en él, será impuro. ");
INSERT INTO spablm_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","El sacerdote examinará la carne viva y lo declarará impuro: la carne viva es impura. Es lepra. ");
INSERT INTO spablm_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","O si la carne viva se vuelve y se convierte en blanca, entonces vendrá al sacerdote. ");
INSERT INTO spablm_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","El sacerdote lo examinará. Si la llaga se ha vuelto blanca, el sacerdote lo declarará limpio de la llaga. Está limpio. ");
INSERT INTO spablm_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“Cuando el cuerpo tenga un forúnculo en la piel, y se haya curado, ");
INSERT INTO spablm_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","y en el lugar del forúnculo haya una hinchazón blanca, o una mancha brillante, de color blanco rojizo, entonces se mostrará al sacerdote. ");
INSERT INTO spablm_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","El sacerdote lo examinará. Si su aspecto es más profundo que la piel, y su pelo se ha vuelto blanco, el sacerdote lo declarará impuro. Es la plaga de la lepra. Ha brotado en el forúnculo. ");
INSERT INTO spablm_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Pero si el sacerdote lo examina, y he aquí que no hay pelos blancos en él, y no está más profundo que la piel, sino que es tenue, entonces el sacerdote lo aislará siete días. ");
INSERT INTO spablm_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Si se extiende en la piel, el sacerdote lo declarará impuro. Es una plaga. ");
INSERT INTO spablm_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Pero si la mancha brillante permanece en su lugar y no se ha extendido, es la cicatriz del forúnculo; y el sacerdote lo declarará limpio. ");
INSERT INTO spablm_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“O cuando el cuerpo tenga una quemadura de fuego en su piel, y la carne viva de la quemadura se convierta en una mancha brillante, de color blanco rojizo o blanco, ");
INSERT INTO spablm_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","entonces el sacerdote lo examinará; y he aquí que si el pelo de la mancha brillante se ha vuelto blanco, y su aspecto es más profundo que la piel, es lepra. Ha brotado en el quemado, y el sacerdote lo declarará impuro. Es la plaga de la lepra. ");
INSERT INTO spablm_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Pero si el sacerdote lo examina y ve que no hay pelo blanco en la mancha, y que no es más profunda que la piel, sino que se ha desvanecido, entonces el sacerdote lo aislará siete días. ");
INSERT INTO spablm_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","El sacerdote lo examinará al séptimo día. Si se ha extendido en la piel, el sacerdote lo declarará impuro. Es la plaga de la lepra. ");
INSERT INTO spablm_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Si la mancha brillante permanece en su lugar y no se ha extendido en la piel, sino que se ha desvanecido, es la hinchazón de la quemadura, y el sacerdote lo declarará limpio, porque es la cicatriz de la quemadura. ");
INSERT INTO spablm_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“Cuando un hombre o una mujer tenga una plaga en la cabeza o en la barba, ");
INSERT INTO spablm_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","entonces el sacerdote examinará la plaga; y si su aspecto es más profundo que la piel, y el pelo en ella es amarillo y fino, entonces el sacerdote lo declarará impuro. Se trata de una picazón. Es lepra de la cabeza o de la barba. ");
INSERT INTO spablm_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Si el sacerdote examina la plaga de prurito, y he aquí que su aspecto no es más profundo que la piel, y no hay pelo negro en ella, entonces el sacerdote aislará a la persona infectada de prurito durante siete días. ");
INSERT INTO spablm_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Al séptimo día el sacerdote examinará la plaga; y he aquí que si la picazón no se ha extendido, y no hay pelo amarillo en ella, y la apariencia de la picazón no es más profunda que la piel, ");
INSERT INTO spablm_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","entonces será afeitado, pero no afeitará la picazón. Entonces el sacerdote aislará al que tiene la picazón siete días más. ");
INSERT INTO spablm_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Al séptimo día, el sacerdote examinará el prurito; y si el prurito no se ha extendido en la piel, y su apariencia no es más profunda que la piel, entonces el sacerdote lo declarará limpio. Se lavará la ropa y quedará limpio. ");
INSERT INTO spablm_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Pero si la picazón se extiende en la piel después de su limpieza, ");
INSERT INTO spablm_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","entonces el sacerdote lo examinará; y si la picazón se ha extendido en la piel, el sacerdote no buscará el pelo amarillo; es impuro. ");
INSERT INTO spablm_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Pero si en sus ojos se ha detenido la picazón y le ha crecido pelo negro, entonces la picazón está curada. Está limpio. El sacerdote lo declarará limpio. ");
INSERT INTO spablm_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“Cuando un hombre o una mujer tenga manchas brillantes en la piel del cuerpo, incluso manchas blancas brillantes, ");
INSERT INTO spablm_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","entonces el sacerdote los examinará. He aquí, si las manchas brillantes en la piel de su cuerpo son de color blanco opaco, es una erupción inofensiva. Ha brotado en la piel. Está limpio. ");
INSERT INTO spablm_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“Si a un hombre se le cae el pelo de la cabeza, es calvo. Está limpio. ");
INSERT INTO spablm_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Si se le ha caído el pelo de la parte delantera de la cabeza, es calvo de frente. Está limpio. ");
INSERT INTO spablm_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Pero si en la cabeza calva o en la frente calva hay una plaga de color blanco rojizo, es lepra que brota en su cabeza calva o en su frente calva. ");
INSERT INTO spablm_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Entonces el sacerdote lo examinará. He aquí, si la hinchazón de la plaga es de color blanco rojizo en su cabeza calva o en su frente calva, como la apariencia de la lepra en la piel del cuerpo, ");
INSERT INTO spablm_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","es un hombre leproso. Es impuro. El sacerdote lo declarará impuro. Su plaga está en su cabeza. ");
INSERT INTO spablm_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“El leproso en el que se encuentre la plaga se vestirá con ropas rasgadas, y el cabello de su cabeza colgará suelto. Se cubrirá el labio superior y gritará: “¡Inmundo! Impuro! ");
INSERT INTO spablm_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Todo el tiempo que la plaga esté en él, será impuro. Es impuro. Vivirá solo. Su morada estará fuera del campamento. ");
INSERT INTO spablm_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“También el vestido en el que esté la plaga de la lepra, sea de lana o de lino; ");
INSERT INTO spablm_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","sea de urdimbre o de trama; de lino o de lana; sea de cuero o de cualquier cosa de cuero; ");
INSERT INTO spablm_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","si la plaga es verdosa o rojiza en el vestido, o en el cuero, o en la urdimbre, o en la trama, o en cualquier cosa de cuero, es la plaga de la lepra, y será mostrada al sacerdote. ");
INSERT INTO spablm_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","El sacerdote examinará la plaga y la aislará durante siete días. ");
INSERT INTO spablm_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Al séptimo día examinará la plaga. Si la plaga se ha extendido en el vestido, ya sea en la urdimbre o en la trama, o en la piel, cualquiera que sea el uso que se le dé a la piel, la plaga es un moho destructor. Es impuro. ");
INSERT INTO spablm_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Se quemará el vestido, ya sea en la urdimbre o en la trama, en la lana o en el lino, o en cualquier cosa de cuero, en el que esté la plaga, porque es un moho destructor. Se quemará en el fuego. ");
INSERT INTO spablm_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“Si el sacerdote lo examina, y he aquí que la peste no se ha propagado en el vestido, ni en la urdimbre, ni en la trama, ni en nada de piel; ");
INSERT INTO spablm_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","entonces el sacerdote ordenará que laven el objeto en que está la peste, y lo aislará siete días más. ");
INSERT INTO spablm_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Entonces el sacerdote lo examinará, después de lavar la plaga; y he aquí que si la plaga no ha cambiado de color, y la plaga no se ha propagado, es impuro; lo quemarás en el fuego. Es una mancha enmohecida, ya sea que la desnudez esté por dentro o por fuera. ");
INSERT INTO spablm_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Si el sacerdote mira, y he aquí que la plaga se ha desvanecido después de haberla lavado, entonces la arrancará del vestido, o de la piel, o de la urdimbre, o de la trama; ");
INSERT INTO spablm_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","y si aparece de nuevo en el vestido, ya sea en la urdimbre, en la trama o en cualquier cosa de la piel, se está extendiendo. Quemarás con fuego lo que contenga la plaga. ");
INSERT INTO spablm_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","El vestido, ya sea en la urdimbre o en la trama, o en cualquier cosa de piel que sea, que lavarás, si la peste se ha ido de ellos, se lavará por segunda vez, y quedará limpio.” ");
INSERT INTO spablm_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Esta es la ley de la plaga del moho en una prenda de lana o de lino, ya sea en la urdimbre o en la trama, o en cualquier cosa de piel, para declararla limpia o para declararla impura. ");
INSERT INTO spablm_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Yahvé habló a Moisés, diciendo, ");
INSERT INTO spablm_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Esta será la ley del leproso el día de su purificación: Será llevado al sacerdote, ");
INSERT INTO spablm_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","y el sacerdote saldrá del campamento. El sacerdote lo examinará. Si la plaga de la lepra se ha curado en el leproso, ");
INSERT INTO spablm_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","entonces el sacerdote mandará que tomen para el que va a ser purificado dos aves vivas y limpias, madera de cedro, grana e hisopo. ");
INSERT INTO spablm_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","El sacerdote les ordenará que maten una de las aves en una vasija de barro sobre agua corriente. ");
INSERT INTO spablm_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","En cuanto a la ave viva, la tomará, así como la madera de cedro, la grana y el hisopo, y los mojará, junto con la ave viva, en la sangre de la ave matada sobre el agua corriente. ");
INSERT INTO spablm_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Rociará siete veces sobre el que ha de quedar limpio de la lepra, y lo declarará limpio, y dejará que el ave viva salga al campo. ");
INSERT INTO spablm_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“El que vaya a ser purificado lavará su ropa, se afeitará todo el pelo y se bañará en agua, y quedará limpio. Después entrará en el campamento, pero permanecerá siete días fuera de su tienda. ");
INSERT INTO spablm_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Al séptimo día se afeitará todo el cabello de la cabeza, la barba y las cejas. Se afeitará todo el cabello. Lavará sus ropas y bañará su cuerpo con agua. Entonces quedará limpio. ");
INSERT INTO spablm_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“Al octavo día tomará dos corderos machos sin defecto, una oveja de un año sin defecto, tres décimas de efa de harina fina para la ofrenda de harina, mezclada con aceite, y un tronco de aceite. ");
INSERT INTO spablm_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","El sacerdote que lo purifique pondrá al hombre que va a ser purificado, y esas cosas, delante de Yahvé, a la puerta de la Tienda del Encuentro. ");
INSERT INTO spablm_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","“El sacerdote tomará uno de los corderos machos y lo ofrecerá como ofrenda por el pecado, con el tronco de aceite, y los agitará como ofrenda mecida ante Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Matará el cordero macho en el lugar donde se mata el sacrificio por el pecado y el holocausto, en el lugar del santuario; porque así como el sacrificio por el pecado es del sacerdote, también lo es el sacrificio por la culpa. Es algo muy sagrado. ");
INSERT INTO spablm_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","El sacerdote tomará un poco de la sangre de la ofrenda por el pecado y la pondrá en la punta de la oreja derecha del que va a ser purificado, en el pulgar de su mano derecha y en el dedo gordo de su pie derecho. ");
INSERT INTO spablm_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","El sacerdote tomará un poco del tronco de aceite y lo echará en la palma de su mano izquierda. ");
INSERT INTO spablm_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","El sacerdote mojará su dedo derecho en el aceite que tiene en su mano izquierda, y rociará un poco del aceite con su dedo siete veces delante de Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","El sacerdote pondrá un poco del resto del aceite que tiene en su mano sobre la punta de la oreja derecha del que va a ser purificado, y sobre el pulgar de su mano derecha, y sobre el dedo gordo de su pie derecho, sobre la sangre de la ofrenda por la culpa. ");
INSERT INTO spablm_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","El resto del aceite que tiene el sacerdote en su mano lo pondrá sobre la cabeza del que va a ser purificado, y el sacerdote hará expiación por él ante Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“El sacerdote ofrecerá la ofrenda por el pecado y hará la expiación por el que ha de ser purificado a causa de su impureza. Después matará el holocausto; ");
INSERT INTO spablm_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","entonces el sacerdote ofrecerá el holocausto y la ofrenda sobre el altar. El sacerdote hará expiación por él, y quedará limpio. ");
INSERT INTO spablm_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“Si es pobre y no puede pagar tanto, tomará un cordero macho como ofrenda por la culpa, para hacer expiación por él, y la décima parte de un efa de harina fina mezclada con aceite para una ofrenda de harina, y un tronco de aceite; ");
INSERT INTO spablm_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","y dos tórtolas, o dos pichones de paloma, como pueda pagar; y una será una ofrenda por el pecado, y la otra un holocausto. ");
INSERT INTO spablm_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“Al octavo día los traerá para su purificación al sacerdote, a la puerta de la Tienda del Encuentro, ante Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","El sacerdote tomará el cordero de la ofrenda por la culpa y el tronco de aceite, y el sacerdote los agitará como ofrenda mecida ante Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Matará el cordero de la ofrenda por la culpa. El sacerdote tomará un poco de la sangre de la ofrenda por la culpa y la pondrá en la punta de la oreja derecha del que va a ser purificado, en el pulgar de su mano derecha y en el dedo gordo de su pie derecho. ");
INSERT INTO spablm_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","El sacerdote verterá un poco del aceite en la palma de su mano izquierda; ");
INSERT INTO spablm_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","y el sacerdote rociará con su dedo derecho un poco del aceite que tiene en su mano izquierda siete veces ante Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Luego el sacerdote pondrá un poco del aceite que tiene en su mano sobre la punta de la oreja derecha del que va a ser purificado, y sobre el pulgar de su mano derecha, y sobre el dedo gordo de su pie derecho, en el lugar de la sangre de la ofrenda por la culpa. ");
INSERT INTO spablm_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","El resto del aceite que está en la mano del sacerdote lo pondrá sobre la cabeza del que va a ser purificado, para hacer expiación por él ante Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Ofrecerá una de las tórtolas o de los pichones de paloma, lo que pueda pagar, ");
INSERT INTO spablm_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","de la clase que pueda pagar, la una para la ofrenda por el pecado y la otra para el holocausto, con la ofrenda. El sacerdote hará la expiación por el que ha de ser purificado ante Yahvé”. ");
INSERT INTO spablm_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Esta es la ley para el que tiene la plaga de la lepra y no puede pagar el sacrificio para su purificación. ");
INSERT INTO spablm_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Yahvé habló a Moisés y a Aarón, diciendo: ");
INSERT INTO spablm_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Cuando hayáis entrado en la tierra de Canaán, que yo os doy en posesión, y pongo un moho que se extiende en una casa de la tierra de vuestra posesión, ");
INSERT INTO spablm_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","entonces el dueño de la casa vendrá y avisará al sacerdote, diciendo: “Me parece que hay una especie de plaga en la casa. ");
INSERT INTO spablm_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","El sacerdote ordenará que se vacíe la casa, antes de que el sacerdote entre a examinar la plaga, para que todo lo que haya en la casa no quede impuro. Después el sacerdote entrará a inspeccionar la casa. ");
INSERT INTO spablm_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Examinará la plaga; y si la plaga está en las paredes de la casa con vetas huecas, verdosas o rojizas, y parece ser más profunda que la pared, ");
INSERT INTO spablm_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","entonces el sacerdote saldrá de la casa a la puerta de la misma, y cerrará la casa por siete días. ");
INSERT INTO spablm_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","El sacerdote volverá al séptimo día y mirará. Si la peste se ha extendido por las paredes de la casa, ");
INSERT INTO spablm_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","entonces el sacerdote mandará que saquen las piedras en las que está la peste, y las arrojen a un lugar inmundo fuera de la ciudad. ");
INSERT INTO spablm_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Hará que se raspe todo el interior de la casa. Echarán la argamasa que rasparon fuera de la ciudad en un lugar inmundo. ");
INSERT INTO spablm_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Tomarán otras piedras y las pondrán en el lugar de esas piedras; y tomará otra argamasa y enlucirá la casa. ");
INSERT INTO spablm_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“Si la peste vuelve a brotar en la casa después de haber sacado las piedras, y después de haber raspado la casa, y después de haberla enlucido, ");
INSERT INTO spablm_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","entonces el sacerdote entrará y mirará; y he aquí que si la peste se ha extendido en la casa, es un moho destructor en la casa. Es impura. ");
INSERT INTO spablm_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Derribará la casa, sus piedras y su madera, y toda la argamasa de la casa. Los sacará de la ciudad a un lugar inmundo. ");
INSERT INTO spablm_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","“Además, el que entre en la casa mientras está cerrada será impuro hasta la noche. ");
INSERT INTO spablm_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","El que se acueste en la casa lavará su ropa, y el que coma en la casa lavará su ropa. ");
INSERT INTO spablm_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“Si el sacerdote entra y la examina, y he aquí que la peste no se ha propagado en la casa, después de haberla enlucido, entonces el sacerdote declarará limpia la casa, porque la peste está curada. ");
INSERT INTO spablm_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Para limpiar la casa tomará dos aves, madera de cedro, grana e hisopo. ");
INSERT INTO spablm_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Matará una de las aves en una vasija de barro sobre agua corriente. ");
INSERT INTO spablm_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Tomará la madera de cedro, el hisopo, la grana y el ave viva, y los mojará en la sangre del ave sacrificada y en el agua corriente, y rociará la casa siete veces. ");
INSERT INTO spablm_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Limpiará la casa con la sangre del ave y con el agua corriente, con el ave viva, con la madera de cedro, con el hisopo y con la grana; ");
INSERT INTO spablm_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","pero dejará que el ave viva salga de la ciudad al campo abierto. Así expiará la casa, y quedará limpia”. ");
INSERT INTO spablm_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Esta es la ley para cualquier plaga de lepra, y para una picazón, ");
INSERT INTO spablm_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","y para el moho destructor de un vestido, y para una casa, ");
INSERT INTO spablm_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","y para una hinchazón, y para una costra, y para una mancha brillante; ");
INSERT INTO spablm_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","para enseñar cuándo es impuro, y cuándo es limpio. Esta es la ley de la lepra. ");
INSERT INTO spablm_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Yahvé habló a Moisés y a Aarón, diciendo: ");
INSERT INTO spablm_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Hablad a los hijos de Israel y decidles: ‘Cuando un hombre tenga flujo de su cuerpo, a causa de su flujo será impuro. ");
INSERT INTO spablm_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Esta será su impureza en su flujo: ya sea que su cuerpo corra con su flujo, o que su cuerpo se haya detenido por su flujo, es su impureza. ");
INSERT INTO spablm_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“‘Todo lecho sobre el que se acueste el que tiene el flujo será impuro; y todo aquello sobre lo que se siente será impuro. ");
INSERT INTO spablm_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","El que toque su lecho lavará su ropa y se bañará con agua, y quedará impuro hasta la noche. ");
INSERT INTO spablm_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","El que se siente sobre cualquier cosa en la que se haya sentado el hombre que tiene el flujo, lavará su ropa, se bañará con agua y quedará impuro hasta la noche. ");
INSERT INTO spablm_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","“‘El que toque el cuerpo del que tiene el flujo se lavará la ropa y se bañará con agua, y quedará impuro hasta la noche. ");
INSERT INTO spablm_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","“‘Si el que tiene el flujo escupe sobre el que está limpio, entonces lavará su ropa y se bañará con agua, y quedará impuro hasta la noche. ");
INSERT INTO spablm_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","“‘Cualquier silla de montar que lleve el enfermo será impura. ");
INSERT INTO spablm_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","El que toque cualquier cosa que haya estado debajo de él quedará impuro hasta la noche. El que lleve esas cosas se lavará la ropa y se bañará con agua, y quedará impuro hasta la noche. ");
INSERT INTO spablm_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","“‘Cualquiera que toque el que tiene el flujo, sin haberse lavado las manos con agua, lavará su ropa y se bañará con agua, y quedará impuro hasta la noche. ");
INSERT INTO spablm_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“‘La vasija de barro que toque el que tiene él flujo, será rota; y toda vasija de madera será enjuagada en agua. ");
INSERT INTO spablm_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“‘Cuando el que tiene flujo se limpie de su flujo, contará para sí siete días para su purificación, y lavará sus vestidos; y bañará su carne en agua corriente, y quedará limpio. ");
INSERT INTO spablm_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","“‘Al octavo día tomará dos tórtolas o dos pichones de paloma, y se presentará ante Yahvé a la puerta de la Tienda del Encuentro, y los entregará al sacerdote. ");
INSERT INTO spablm_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","El sacerdote los ofrecerá, uno como ofrenda por el pecado y el otro como holocausto. El sacerdote hará la expiación por él ante Yahvé por su liberación. ");
INSERT INTO spablm_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“‘Si un hombre tiene una emisión de semen, se lavará con agua toda su carne y quedará impuro hasta la noche. ");
INSERT INTO spablm_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Toda la ropa y toda la piel sobre la que haya semen se lavará con agua, y quedará impura hasta la noche. ");
INSERT INTO spablm_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Si un hombre se acuesta con una mujer y hay emisión de semen, ambos se bañarán con agua y quedarán impuros hasta la noche. ");
INSERT INTO spablm_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“‘Si una mujer tiene flujo, y su flujo en su carne es de sangre, estará en su impureza siete días. Quien la toque será impuro hasta la noche. ");
INSERT INTO spablm_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","“‘Todo lo que ella se acueste en su impureza será impuro. Todo lo que ella se siente será impuro. ");
INSERT INTO spablm_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","El que toque su lecho lavará su ropa y se bañará en agua, y quedará impuro hasta la noche. ");
INSERT INTO spablm_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","El que toque algo sobre lo que ella se siente, lavará su ropa, se bañará con agua y quedará impuro hasta la noche. ");
INSERT INTO spablm_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Si está en la cama o en cualquier cosa sobre la que ella se siente, cuando la toque será impuro hasta la noche. ");
INSERT INTO spablm_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“‘Si alguno se acuesta con ella, y su flujo menstrual está sobre él, será impuro siete días; y toda cama en la que se acueste será impura. ");
INSERT INTO spablm_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“‘Si una mujer tiene una descarga de su sangre muchos días fuera del tiempo de su período, o si tiene una descarga más allá del tiempo de su período, todos los días de la descarga de su impureza serán como en los días de su período. Será impura. ");
INSERT INTO spablm_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Toda cama en la que se acueste durante todos los días de su flujo será para ella como la cama de su período. Todo aquello sobre lo que se siente será impuro, como la impureza de su menstruación. ");
INSERT INTO spablm_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Quien toque estas cosas quedará impuro, lavará su ropa y se bañará con agua, y quedará impuro hasta la noche. ");
INSERT INTO spablm_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","“‘Pero si se limpia de su flujo, contará para sí siete días, y después de eso quedará limpia. ");
INSERT INTO spablm_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Al octavo día tomará dos tórtolas o dos pichones y los llevará al sacerdote, a la puerta de la Tienda de reunión. ");
INSERT INTO spablm_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","El sacerdote ofrecerá una como ofrenda por el pecado, y la otra como holocausto; y el sacerdote hará expiación por ella ante Yahvé por la impureza de su flujo. ");
INSERT INTO spablm_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“‘Así separarás a los hijos de Israel de su impureza, para que no mueran en su impureza cuando contaminen mi tabernáculo que está en medio de ellos’”. ");
INSERT INTO spablm_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Esta es la ley del que tiene flujo, y del que tiene emisión de semen, de modo que es impuro por ello; ");
INSERT INTO spablm_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","y de la que tiene la menstruación, y del hombre o la mujer que tiene flujo, y del que se acuesta con ella que es impuro. ");
INSERT INTO spablm_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Yahvé habló a Moisés después de la muerte de los dos hijos de Aarón, cuando se acercaron ante Yahvé y murieron; ");
INSERT INTO spablm_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","y Yahvé dijo a Moisés: “Dile a Aarón, tu hermano, que no entre en ningún momento en el Lugar Santísimo, dentro del velo, delante del propiciatorio que está sobre el arca, para que no muera, porque me apareceré en la nube sobre el propiciatorio. ");
INSERT INTO spablm_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“Aarón entrará en el santuario con un novillo para el sacrificio por el pecado y un carnero para el holocausto. ");
INSERT INTO spablm_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Se pondrá la túnica de lino sagrada. Tendrá los pantalones de lino sobre su cuerpo, y se pondrá la faja de lino, y se vestirá con el turbante de lino. Son las vestimentas sagradas. Bañará su cuerpo con agua y se las pondrá. ");
INSERT INTO spablm_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Tomará de la congregación de los hijos de Israel dos machos cabríos para el sacrificio por el pecado y un carnero para el holocausto. ");
INSERT INTO spablm_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","“Aarón ofrecerá el toro de la ofrenda por el pecado, que es para él, y hará expiación por él y por su casa. ");
INSERT INTO spablm_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Tomará los dos machos cabríos y los pondrá delante de Yahvé, a la puerta de la Tienda del Encuentro. ");
INSERT INTO spablm_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Aarón echará suertes sobre los dos machos cabríos: una suerte para Yahvé, y la otra suerte para el chivo expiatorio. ");
INSERT INTO spablm_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Aarón presentará el macho cabrío sobre el que haya caído la suerte para Yahvé, y lo ofrecerá como ofrenda por el pecado. ");
INSERT INTO spablm_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Pero el macho cabrío sobre el que cayó la suerte para el chivo expiatorio será presentado vivo ante Yahvé, para hacer expiación por él, para enviarlo como chivo expiatorio al desierto. ");
INSERT INTO spablm_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Aarón presentará el becerro del sacrificio por el pecado, que es para él, y hará la expiación por sí mismo y por su casa, y matará el becerro del sacrificio por el pecado que es para él. ");
INSERT INTO spablm_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Tomará un incensario lleno de carbones encendidos del altar, delante de Yahvé, y dos puñados de incienso aromático machacado, y lo llevará al interior del velo. ");
INSERT INTO spablm_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Pondrá el incienso sobre el fuego delante de Yahvé, para que la nube del incienso cubra el propiciatorio que está sobre el pacto, a fin de que no muera. ");
INSERT INTO spablm_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Tomará parte de la sangre del becerro y la rociará con su dedo sobre el propiciatorio que está al oriente; y delante del propiciatorio rociará parte de la sangre con su dedo siete veces. ");
INSERT INTO spablm_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“Entonces matará el macho cabrío de la ofrenda por el pecado que es para el pueblo, y llevará su sangre al interior del velo, y hará con su sangre lo mismo que hizo con la sangre del becerro, y la rociará sobre el propiciatorio y delante del propiciatorio. ");
INSERT INTO spablm_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Hará la expiación por el Lugar Santo, a causa de la impureza de los hijos de Israel y de sus transgresiones, de todos sus pecados; y lo mismo hará por la Tienda de Reunión que habita con ellos en medio de su impureza. ");
INSERT INTO spablm_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Nadie estará en la Tienda de reunión cuando entre a hacer expiación en el Lugar Santo, hasta que salga y haya hecho expiación por él y por su familia, y por toda la asamblea de Israel. ");
INSERT INTO spablm_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","“Saldrá al altar que está delante de Yahvé y hará expiación por él, y tomará parte de la sangre del toro y parte de la sangre del macho cabrío, y la pondrá alrededor de los cuernos del altar. ");
INSERT INTO spablm_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Con su dedo rociará parte de la sangre sobre el altar siete veces, y lo purificará y lo santificará de la impureza de los hijos de Israel. ");
INSERT INTO spablm_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“Cuando haya terminado de expiar el Lugar Santo, la Tienda de Reunión y el altar, presentará el macho cabrío vivo. ");
INSERT INTO spablm_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Aarón pondrá sus dos manos sobre la cabeza del macho cabrío vivo y confesará sobre él todas las iniquidades de los hijos de Israel y todas sus transgresiones, todos sus pecados, y los pondrá sobre la cabeza del macho cabrío, y lo enviará al desierto de la mano de un hombre preparado. ");
INSERT INTO spablm_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","El macho cabrío llevará sobre sí todas sus iniquidades a una tierra solitaria, y soltará al macho cabrío en el desierto. ");
INSERT INTO spablm_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Aarón entrará en la Tienda del Encuentro y se quitará las vestiduras de lino que se puso al entrar en el Lugar Santo, y las dejará allí. ");
INSERT INTO spablm_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Luego se bañará en agua en un lugar santo, se pondrá sus vestiduras y saldrá a ofrecer su holocausto y el holocausto del pueblo, y hará expiación por él y por el pueblo. ");
INSERT INTO spablm_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","La grasa de la ofrenda por el pecado la quemará sobre el altar. ");
INSERT INTO spablm_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“El que suelte el macho cabrío como chivo expiatorio lavará su ropa y bañará su carne con agua, y después entrará en el campamento. ");
INSERT INTO spablm_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","El becerro para la ofrenda por el pecado y el macho cabrío para la ofrenda por el pecado, cuya sangre fue traída para hacer expiación en el Lugar Santo, serán llevados fuera del campamento; y quemarán sus pieles, su carne y su estiércol con fuego. ");
INSERT INTO spablm_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","El que los queme lavará su ropa y bañará su carne con agua, y después entrará en el campamento. ");
INSERT INTO spablm_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“Será un estatuto para vosotros: en el séptimo mes, a los diez días del mes, afligiréis vuestras almas y no haréis ningún tipo de trabajo, ya sea nativo o extranjero que viva como forastero entre vosotros; ");
INSERT INTO spablm_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","porque en este día se hará expiación por vosotros, para limpiaros. Quedarás limpio de todos tus pecados ante el Señor. ");
INSERT INTO spablm_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Es un día de descanso solemne para ustedes, y afligirán sus almas. Es un estatuto para siempre. ");
INSERT INTO spablm_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","El sacerdote ungido y consagrado para ser sacerdote en lugar de su padre, hará la expiación y se pondrá las vestiduras de lino, las vestiduras sagradas. ");
INSERT INTO spablm_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Luego hará la expiación por el Santuario Sagrado; y hará la expiación por la Tienda de Reunión y por el altar; y hará la expiación por los sacerdotes y por todo el pueblo de la asamblea. ");
INSERT INTO spablm_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","“Esto será un estatuto eterno para ti, para hacer expiación por los hijos de Israel una vez al año por todos sus pecados”. Se hizo como Yahvé le ordenó a Moisés. ");
INSERT INTO spablm_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Habla a Aarón y a sus hijos, y a todos los hijos de Israel, y diles: ‘Esto es lo que Yahvé ha ordenado: ");
INSERT INTO spablm_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Todo hombre de la casa de Israel que mate un becerro, un cordero o una cabra en el campamento, o que lo mate fuera del campamento, ");
INSERT INTO spablm_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","y no lo haya traído a la puerta de la Tienda de Reunión para ofrecerlo como ofrenda a Yahvé ante el tabernáculo de Yahvé: la sangre se le imputará a ese hombre. Ha derramado sangre. Ese hombre será cortado de entre su pueblo. ");
INSERT INTO spablm_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Esto es para que los hijos de Israel traigan sus sacrificios, que sacrifican en el campo abierto, para que los traigan a Yahvé, a la puerta de la Tienda del Encuentro, al sacerdote, y los sacrifiquen como ofrendas de paz a Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","El sacerdote rociará la sangre sobre el altar de Yahvé, a la puerta de la Tienda del Encuentro, y quemará la grasa como aroma agradable para Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","No volverán a sacrificar sus productos a los ídolos caprinos, después de los cuales se prostituyen. Esto les servirá de estatuto para siempre a lo largo de sus generaciones”. ");
INSERT INTO spablm_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“Les dirás: ‘Cualquier hombre que haya de la casa de Israel, o de los extranjeros que viven como forasteros entre ellos, que ofrezca un holocausto o un sacrificio, ");
INSERT INTO spablm_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","y no lo traiga a la puerta de la Tienda del Encuentro para sacrificarlo a Yahvé, ese hombre será cortado de su pueblo. ");
INSERT INTO spablm_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“‘Cualquier hombre de la casa de Israel, o de los extranjeros que viven como forasteros entre ellos, que coma cualquier clase de sangre, yo pondré mi rostro contra esa alma que come sangre, y la cortaré de entre su pueblo. ");
INSERT INTO spablm_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Porque la vida de la carne está en la sangre. Os la he dado sobre el altar para hacer expiación por vuestras almas; porque es la sangre la que hace expiación en razón de la vida. ");
INSERT INTO spablm_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Por eso he dicho a los hijos de Israel: “Ninguna persona entre vosotros puede comer sangre, ni ningún extranjero que viva como tal entre vosotros puede comer sangre.” ");
INSERT INTO spablm_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“‘Todo hombre de los hijos de Israel, o de los extranjeros que vivan como forasteros entre ellos, que cace algún animal o ave que se pueda comer, derramará su sangre y lo cubrirá con polvo. ");
INSERT INTO spablm_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Porque en cuanto a la vida de toda carne, su sangre es con su vida. Por eso dije a los hijos de Israel: “No comeréis la sangre de ninguna clase de carne, porque la vida de toda carne es su sangre. El que la coma será cortado”. ");
INSERT INTO spablm_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“‘Toda persona que coma lo que muere por sí mismo, o lo que desgarran los animales, sea nativo o extranjero, lavará sus ropas y se bañará con agua, y quedará impuro hasta la noche. Entonces quedará limpio. ");
INSERT INTO spablm_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Pero si no los lava, ni se baña con agua, entonces cargará con su iniquidad”. ");
INSERT INTO spablm_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Yahvé dijo a Moisés: ");
INSERT INTO spablm_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Habla a los hijos de Israel y diles: “Yo soy Yahvé, vuestro Dios. ");
INSERT INTO spablm_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","No harás lo que hacen en la tierra de Egipto, donde vivías. No haréis como ellos en la tierra de Canaán, adonde os llevo. No seguirás sus estatutos. ");
INSERT INTO spablm_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Harás mis ordenanzas. Guardarán mis estatutos y caminarán en ellos. Yo soy el Señor, tu Dios. ");
INSERT INTO spablm_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Por lo tanto, guardaréis mis estatutos y mis ordenanzas, los cuales, si el hombre los cumple, vivirá en ellos. Yo soy Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“‘Ninguno de ustedes se acercará a ningún pariente cercano para descubrir su desnudez: Yo soy Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“‘No descubrirás la desnudez de tu padre, ni la desnudez de tu madre: ella es tu madre. No descubrirás su desnudez. ");
INSERT INTO spablm_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","“‘No descubrirás la desnudez de la mujer de tu padre. Es la desnudez de tu padre. ");
INSERT INTO spablm_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“‘No descubrirás la desnudez de tu hermana, de la hija de tu padre o de la hija de tu madre, tanto si ha nacido en casa como si ha nacido fuera. ");
INSERT INTO spablm_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“‘No descubrirás la desnudez de la hija de tu hijo o de la hija de tu hija, su desnudez, porque la de ellos es tu propia desnudez. ");
INSERT INTO spablm_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“‘No descubrirás la desnudez de la hija de la mujer de tu padre, concebida por éste, pues es tu hermana. ");
INSERT INTO spablm_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“‘No descubrirás la desnudez de la hermana de tu padre. Ella es la pariente cercana de tu padre. ");
INSERT INTO spablm_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","“‘No descubrirás la desnudez de la hermana de tu madre, porque es pariente cercana de tu madre. ");
INSERT INTO spablm_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","“‘No descubrirás la desnudez del hermano de tu padre. No te acercarás a su mujer. Ella es tu tía. ");
INSERT INTO spablm_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“‘No descubrirás la desnudez de tu nuera. Es la mujer de tu hijo. No descubrirás su desnudez. ");
INSERT INTO spablm_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“‘No descubrirás la desnudez de la mujer de tu hermano. Es la desnudez de tu hermano. ");
INSERT INTO spablm_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“‘No descubrirás la desnudez de una mujer y de su hija. No tomarás a la hija de su hijo, ni a la hija de su hija, para descubrir su desnudez. Son parientes cercanos. Es una maldad. ");
INSERT INTO spablm_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“‘No tomarás una esposa además de su hermana, para ser rival, para descubrir su desnudez, mientras su hermana esté viva. ");
INSERT INTO spablm_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“‘No te acercarás a una mujer para descubrir su desnudez, mientras esté impura por su impureza. ");
INSERT INTO spablm_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“‘No te acostarás carnalmente con la mujer de tu prójimo, ni te contaminarás con ella. ");
INSERT INTO spablm_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“‘No darás a ninguno de tus hijos como sacrificio a Moloc. No profanarás el nombre de tu Dios. Yo soy Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“‘No te acostarás con un hombre como con una mujer. Eso es detestable. ");
INSERT INTO spablm_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“‘No te acostarás con ningún animal para contaminarte con él. Ninguna mujer puede entregarse a un animal para acostarse con él: es una perversión. ");
INSERT INTO spablm_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“‘No os contaminéis en ninguna de estas cosas; porque en todas ellas se contaminaron las naciones que estoy echando delante de vosotros. ");
INSERT INTO spablm_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","La tierra se contaminó. Por eso castigué su iniquidad, y la tierra vomitó a sus habitantes. ");
INSERT INTO spablm_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Guardad, pues, mis estatutos y mis ordenanzas, y no hagáis ninguna de estas abominaciones; ni el nativo, ni el extranjero que vive como forastero entre vosotros ");
INSERT INTO spablm_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","(porque los hombres de la tierra que estaban antes de vosotros habían hecho todas estas abominaciones, y la tierra se contaminó), ");
INSERT INTO spablm_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","para que la tierra no os vomite también a vosotros, cuando la contaminéis, como vomitó a la nación que estaba antes de vosotros. ");
INSERT INTO spablm_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","“‘Porque cualquiera que haga alguna de estas abominaciones, las almas que las hagan serán cortadas de entre su pueblo. ");
INSERT INTO spablm_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Por lo tanto, guardarán mis requisitos, para que no practiquen ninguna de estas costumbres abominables que se practicaban antes de ustedes, y para que no se contaminen con ellas. Yo soy Yahvé, vuestro Dios”. ");
INSERT INTO spablm_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Yahvé habló a Moisés diciendo: ");
INSERT INTO spablm_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Habla a toda la congregación de los hijos de Israel y diles: “Seréis santos, porque yo, Yahvé, vuestro Dios, soy santo. ");
INSERT INTO spablm_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“‘Cada uno de vosotros respetará a su madre y a su padre. Guardarán mis sábados. Yo soy Yahvé, vuestro Dios. ");
INSERT INTO spablm_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“‘No se vuelvan a los ídolos, ni se hagan dioses de fundición. Yo soy Yahvé, vuestro Dios. ");
INSERT INTO spablm_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“‘Cuando ofrezcas un sacrificio de paz a Yahvé, lo ofrecerás para que seas aceptado. ");
INSERT INTO spablm_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Se comerá el mismo día que lo ofrezcas, y al día siguiente. Si queda algo hasta el tercer día, se quemará con fuego. ");
INSERT INTO spablm_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Si se come al tercer día, es una abominación. No se aceptará; ");
INSERT INTO spablm_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","sino que todo el que lo coma cargará con su iniquidad, porque ha profanado la cosa santa de Yahvé, y esa alma será cortada de su pueblo. ");
INSERT INTO spablm_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“‘Cuando recojas la cosecha de tu tierra, no segarás del todo los rincones de tu campo, ni recogerás las espigas de tu cosecha. ");
INSERT INTO spablm_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","No espigarás tu viña, ni recogerás las uvas caídas de tu viña. Las dejarás para el pobre y para el extranjero. Yo soy el Señor, tu Dios. ");
INSERT INTO spablm_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“‘No robarás’. “‘No mentirás’. “‘No os engañaréis unos a otros’. ");
INSERT INTO spablm_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","“‘No jurarás por mi nombre en falso ni profanarás el nombre de tu Dios. Yo soy Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“‘No oprimirás a tu prójimo ni le robarás. “‘El salario de un jornalero no permanecerá con vosotros toda la noche hasta la mañana. ");
INSERT INTO spablm_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“‘No maldecirás al sordo, ni pondrás tropiezo al ciego, sino que temerás a tu Dios. Yo soy Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“‘No cometerás injusticia en el juicio. No serás parcial con el pobre, ni mostrarás favoritismo con el grande; sino que juzgarás a tu prójimo con justicia. ");
INSERT INTO spablm_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“‘No irás por ahí como calumniador entre tu pueblo. “‘No pondrás en peligro la vida de tu prójimo. Yo soy Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“‘No odiarás a tu hermano en tu corazón. Reprenderás a tu prójimo y no cargarás con el pecado por su culpa. ");
INSERT INTO spablm_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","“‘No te vengarás ni guardarás rencor a los hijos de tu pueblo, sino que amarás a tu prójimo como a ti mismo. Yo soy Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“‘Deberás cumplir mis estatutos. “‘No cruzarás diferentes tipos de animales. “‘No sembrarás tu campo con dos tipos de semilla; “‘No lleves una prenda hecha de dos tipos de material. ");
INSERT INTO spablm_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“‘Si un hombre se acuesta carnalmente con una mujer que es una chica esclava, comprometida para casarse con otro hombre, y no se rescata o se le da la libertad; serán castigados. No serán condenados a muerte, porque ella no era libre. ");
INSERT INTO spablm_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Traerá su ofrenda por la culpa a Yahvé, a la puerta de la Tienda del Encuentro, un carnero como ofrenda por la culpa. ");
INSERT INTO spablm_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","El sacerdote hará expiación por él con el carnero de la ofrenda por la culpa ante Yahvé, por el pecado que haya cometido; y el pecado que haya cometido le será perdonado. ");
INSERT INTO spablm_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“‘Cuando llegues a la tierra y hayas plantado toda clase de árboles para comer, entonces contarás sus frutos como prohibidos. Durante tres años te estará prohibido. No se podrá comer. ");
INSERT INTO spablm_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Pero al cuarto año todo su fruto será sagrado, para alabar al Señor. ");
INSERT INTO spablm_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","En el quinto año comerás su fruto, para que te dé sus frutos. Yo soy el Señor, tu Dios. ");
INSERT INTO spablm_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“‘No comerás ninguna carne con la sangre todavía en ella. No usarás encantamientos, ni practicarás la hechicería. ");
INSERT INTO spablm_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“‘No te cortarás el pelo a los lados de la cabeza ni te recortarás el borde de la barba. ");
INSERT INTO spablm_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","“‘No harás ningún corte en tu carne por los muertos, ni te tatuarás ninguna marca. Yo soy Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“‘No profanes a tu hija, para hacerla prostituta; no sea que la tierra caiga en la prostitución, y la tierra se llene de maldad. ");
INSERT INTO spablm_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“‘Guardarán mis sábados y reverenciarán mi santuario; yo soy Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“‘No te dirijas a los que son médiums, ni a los magos. No los busques para ser contaminado por ellos. Yo soy Yahvé, tu Dios. ");
INSERT INTO spablm_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“‘Te levantarás ante la cabeza gris y honrarás el rostro de los ancianos; y temerás a tu Dios. Yo soy Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“‘Si un extranjero vive como forastero con vosotros en vuestra tierra, no le haréis mal. ");
INSERT INTO spablm_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","El extranjero que viva como forastero con ustedes será para ustedes como el nativo entre ustedes, y lo amarán como a ustedes mismos; porque ustedes vivieron como extranjeros en la tierra de Egipto. Yo soy Yahvé, tu Dios. ");
INSERT INTO spablm_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“‘No harás injusticia en el juicio, en las medidas de longitud, de peso o de cantidad. ");
INSERT INTO spablm_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Tendrás balanzas justas, pesas justas, un efa justo, y un hin justo. Yo soy el Señor, tu Dios, que te sacó de la tierra de Egipto. ");
INSERT INTO spablm_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“‘Observarás todos mis estatutos y todas mis ordenanzas, y los pondrás en práctica. Yo soy Yahvé’”. ");
INSERT INTO spablm_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Además, dirás a los hijos de Israel: ‘Cualquiera de los hijos de Israel, o de los extranjeros que vivan como forasteros en Israel, que entregue alguno de sus vástagos a Moloc, morirá. El pueblo del país apedreará a esa persona con piedras. ");
INSERT INTO spablm_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Yo también pondré mi rostro contra esa persona, y la cortaré de entre su pueblo, porque ha dado de su descendencia a Moloc, para profanar mi santuario, y para profanar mi santo nombre. ");
INSERT INTO spablm_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Si todos los pueblos de la tierra esconden sus ojos de esa persona cuando da de su descendencia a Moloc, y no le dan muerte, ");
INSERT INTO spablm_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","entonces yo pondré mi rostro contra ese hombre y contra su familia, y lo cortaré de entre su pueblo, y a todos los que se prostituyen después de él para prostituirse con Moloc. ");
INSERT INTO spablm_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“‘La persona que se vuelve a los que son médiums y magos, para jugar a la prostitución después de ellos, incluso pondré mi cara contra esa persona, y la cortaré de entre su pueblo. ");
INSERT INTO spablm_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“‘Santificaos, pues, y sed santos, porque yo soy Yahvé, vuestro Dios. ");
INSERT INTO spablm_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Guardarán mis estatutos y los pondrán en práctica. Yo soy Yahvé, que os santifico. ");
INSERT INTO spablm_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“‘Porque todo el que maldiga a su padre o a su madre será condenado a muerte. Ha maldecido a su padre o a su madre. Su sangre caerá sobre él. ");
INSERT INTO spablm_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“‘El hombre que comete adulterio con la mujer de otro hombre, incluso el que comete adulterio con la mujer de su prójimo, el adúltero y la adúltera serán condenados a muerte. ");
INSERT INTO spablm_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","“‘El hombre que se acuesta con la mujer de su padre ha descubierto la desnudez de su padre. Ambos serán condenados a muerte. Su sangre será sobre ellos. ");
INSERT INTO spablm_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“‘Si un hombre se acuesta con su nuera, ambos serán condenados a muerte. Han cometido una perversión. Su sangre caerá sobre ellos. ");
INSERT INTO spablm_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“‘Si un hombre se acuesta con un varón como con una mujer, ambos han cometido una abominación. Serán condenados a muerte. Su sangre será sobre ellos mismos. ");
INSERT INTO spablm_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“‘Si un hombre toma una esposa y a su madre, es una maldad. Serán quemados con fuego, tanto él como ellas, para que no haya maldad entre vosotros. ");
INSERT INTO spablm_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“‘Si un hombre se acuesta con un animal, será condenado a muerte; y matarás al animal. ");
INSERT INTO spablm_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","“‘Si una mujer se acerca a un animal y se acuesta con él, matarás a la mujer y al animal. Serán condenados a muerte. Su sangre caerá sobre ellos. ");
INSERT INTO spablm_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“‘Si un hombre toma a su hermana — la hija de su padre o de su madre — y ve su desnudez, y ella ve la suya, es cosa vergonzosa. Serán cortados a la vista de los hijos de su pueblo. Él ha descubierto la desnudez de su hermana. Llevará su iniquidad. ");
INSERT INTO spablm_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“‘Si un hombre se acuesta con una mujer que tiene su menstruación y descubre su desnudez, él ha desnudado su fuente, y ella ha descubierto la fuente de su sangre. Ambos serán cortados de entre su pueblo. ");
INSERT INTO spablm_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“‘No descubrirás la desnudez de la hermana de tu madre, ni la de la hermana de tu padre, porque ha desnudado a su pariente cercano. Ellos cargarán con su iniquidad. ");
INSERT INTO spablm_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Si un hombre se acuesta con la mujer de su tío, ha descubierto la desnudez de su tío. Ellos cargarán con su pecado. Morirán sin hijos. ");
INSERT INTO spablm_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“‘Si un hombre toma la mujer de su hermano, es una impureza. Ha descubierto la desnudez de su hermano. No tendrán hijos. ");
INSERT INTO spablm_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“‘Por lo tanto, guardaréis todos mis estatutos y todas mis ordenanzas, y los pondréis en práctica, para que la tierra donde os traigo a vivir no os vomite. ");
INSERT INTO spablm_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","No andarás en las costumbres de la nación que estoy echando delante de ti; porque ellos hicieron todas estas cosas, y por eso los aborrecí. ");
INSERT INTO spablm_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Pero a vosotros os he dicho: “Heredaréis su tierra, y os la daré para que la poseáis, una tierra que mana leche y miel”. Yo soy Yahvé, tu Dios, que te ha separado de los pueblos. ");
INSERT INTO spablm_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","“‘Por tanto, distinguiréis entre el animal limpio y el impuro, y entre las aves impuras y las limpias. No os haréis abominables con ningún animal, ni con ninguna ave, ni con nada de lo que abunda en la tierra, que yo he separado de vosotros como impuro para vosotros. ");
INSERT INTO spablm_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Seréis santos para mí, porque yo, Yahvé, soy santo, y os he apartado de los pueblos para que seáis míos. ");
INSERT INTO spablm_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“‘El hombre o la mujer que sea un médium o un mago serán condenados a muerte. Serán apedreados. Su sangre será sobre ellos”. ");
INSERT INTO spablm_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Yahvé dijo a Moisés: “Habla a los sacerdotes, hijos de Aarón, y diles: ‘El sacerdote no se profanará por los muertos de su pueblo, ");
INSERT INTO spablm_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","excepto por sus parientes que están cerca de él: por su madre, por su padre, por su hijo, por su hija, por su hermano, ");
INSERT INTO spablm_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","y por su hermana virgen que está cerca de él, que no ha tenido marido; por ella puede profanarse. ");
INSERT INTO spablm_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","No se contaminará, siendo jefe de su pueblo, para profanarse. ");
INSERT INTO spablm_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“‘No se afeitarán la cabeza ni se afeitarán las comisuras de la barba, ni se harán cortes en la carne. ");
INSERT INTO spablm_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Serán santos para su Dios, y no profanarán el nombre de su Dios, porque ofrecen las ofrendas quemadas de Yahvé, el pan de su Dios. Por lo tanto, serán santos. ");
INSERT INTO spablm_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“‘No se casarán con una mujer prostituta o profana. El sacerdote no se casará con una mujer divorciada de su marido, porque él es santo para su Dios. ");
INSERT INTO spablm_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Por eso lo santificarás, porque él ofrece el pan de tu Dios. Será santo para ti, porque yo, Yahvé, que te santifico, soy santo. ");
INSERT INTO spablm_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“‘La hija de cualquier sacerdote, si se profana haciendo de prostituta, profana a su padre. Será quemada con fuego. ");
INSERT INTO spablm_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“‘El que es sumo sacerdote entre sus hermanos, sobre cuya cabeza se derrama el aceite de la unción, y que es consagrado para vestir las vestiduras, no dejará suelto el cabello de su cabeza, ni rasgará sus vestidos. ");
INSERT INTO spablm_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","No debe entrar a ningún cadáver, ni contaminarse por su padre o por su madre. ");
INSERT INTO spablm_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","No saldrá del santuario ni profanará el santuario de su Dios, porque la corona del aceite de la unción de su Dios está sobre él. Yo soy Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“‘Tomará una esposa en su virginidad. ");
INSERT INTO spablm_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","No se casará con una viuda, ni con una divorciada, ni con una mujer impura, ni con una prostituta. Tomará como esposa a una virgen de su propio pueblo. ");
INSERT INTO spablm_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","No profanará su descendencia entre su pueblo, porque yo soy Yahvé, que lo santifico”. ");
INSERT INTO spablm_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Di a Aarón: “Ninguno de tus descendientes, a lo largo de sus generaciones, que tenga un defecto podrá acercarse a ofrecer el pan de su Dios. ");
INSERT INTO spablm_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Porque todo hombre que tenga un defecto, no se acercará: un ciego, o un cojo, o el que tenga la nariz chata, o cualquier deformidad, ");
INSERT INTO spablm_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","o un hombre que tenga un pie lesionado, o una mano lesionada, ");
INSERT INTO spablm_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","o un jorobado, o un enano, o el que tenga un defecto en el ojo, o una enfermedad que pique, o costras, o que tenga los testículos dañados. ");
INSERT INTO spablm_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Ningún hombre de la descendencia del sacerdote Aarón que tenga un defecto se acercará a ofrecer las ofrendas de Yahvé hechas por fuego. Como tiene un defecto, no se acercará a ofrecer el pan de su Dios. ");
INSERT INTO spablm_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Comerá el pan de su Dios, tanto del más sagrado como del santo. ");
INSERT INTO spablm_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","No se acercará al velo, ni se acercará al altar, porque tiene un defecto; para que no profane mis santuarios, porque yo soy Yahvé que los santifico”. ");
INSERT INTO spablm_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Entonces Moisés habló a Aarón, a sus hijos y a todos los hijos de Israel. ");
INSERT INTO spablm_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Di a Aarón y a sus hijos que se separen de las cosas sagradas de los hijos de Israel, que ellos hacen sagradas para mí, y que no profanen mi santo nombre. Yo soy Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","“Diles: ‘Si alguno de todos tus descendientes, a lo largo de tus generaciones, se acerca a las cosas sagradas que los hijos de Israel santifican a Yahvé, teniendo su impureza encima, esa alma será cortada de delante de mí. Yo soy Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“‘Quien de los descendientes de Aarón sea leproso o tenga flujo, no comerá de las cosas sagradas hasta que esté limpio. El que toque algo inmundo por los muertos, o un hombre que tenga una emisión seminal, ");
INSERT INTO spablm_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","o el que toque cualquier cosa que se arrastre por la que pueda quedar impuro, o un hombre del que pueda quedar impuro, sea cual sea la impureza que tenga— ");
INSERT INTO spablm_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","la persona que toque a cualquiera de ellos quedará impura hasta la tarde, y no comerá de las cosas sagradas a menos que se bañe en agua. ");
INSERT INTO spablm_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Cuando se ponga el sol, quedará limpio, y después comerá de las cosas sagradas, porque es su pan. ");
INSERT INTO spablm_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","No comerá lo que muera por sí mismo o sea desgarrado por los animales, contaminándose con ello. Yo soy Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“‘Por tanto, seguirán mi mandamiento, para que no carguen con el pecado y mueran en él, si lo profanan. Yo soy Yahvé, que los santifico. ");
INSERT INTO spablm_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“‘Ningún extranjero comerá de la cosa sagrada; el extranjero que viva con los sacerdotes, o un siervo contratado, no comerá de la cosa sagrada. ");
INSERT INTO spablm_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Pero si un sacerdote compra un esclavo, adquirido con su dinero, comerá de él; y los nacidos en su casa comerán de su pan. ");
INSERT INTO spablm_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Si la hija de un sacerdote se casa con un extranjero, no comerá de la ofrenda de las cosas santas. ");
INSERT INTO spablm_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Pero si la hija de un sacerdote es viuda o divorciada y no tiene hijos, y ha vuelto a la casa de su padre como en su juventud, podrá comer del pan de su padre; pero ningún extraño comerá de él. ");
INSERT INTO spablm_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“‘Si un hombre come algo sagrado sin saberlo, entonces le añadirá la quinta parte de su valor, y le dará la cosa sagrada al sacerdote. ");
INSERT INTO spablm_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Los sacerdotes no profanarán las cosas santas de los hijos de Israel, que ofrecen a Yahvé, ");
INSERT INTO spablm_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","y así les harán cargar con la iniquidad que trae la culpa cuando comen sus cosas santas; porque yo soy Yahvé que los santifico.’” ");
INSERT INTO spablm_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Habla a Aarón y a sus hijos, y a todos los hijos de Israel, y diles: “Todo el que sea de la casa de Israel, o de los extranjeros en Israel, que ofrezca su ofrenda, ya sea alguno de sus votos o alguna de sus ofrendas voluntarias, que ofrezcan a Yahvé como holocausto: ");
INSERT INTO spablm_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","para que seas aceptado, ofrecerás un macho sin defecto, de los toros, de las ovejas o de las cabras. ");
INSERT INTO spablm_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Pero no ofrecerás lo que tenga algún defecto, porque no te será aceptable. ");
INSERT INTO spablm_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","El que ofrezca un sacrificio de paz a Yahvé para cumplir un voto, o para una ofrenda voluntaria de la manada o del rebaño, será perfecto para ser aceptado. No deberá tener ningún defecto. ");
INSERT INTO spablm_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","No ofrecerás a Yahvé lo que esté ciego, herido, mutilado, con verrugas, supurante o con llagas, ni harás de ellos una ofrenda encendida sobre el altar de Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","O un toro o un cordero que tenga alguna deformidad o falta en sus partes, que podrás ofrecer como ofrenda voluntaria; pero para un voto no se aceptará. ");
INSERT INTO spablm_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","No debes ofrecer a Yahvé lo que tenga los testículos magullados, aplastados, rotos o cortados. No debes hacer esto en tu tierra. ");
INSERT INTO spablm_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","No debes ofrecer nada de esto como pan de tu Dios de la mano de un extranjero, porque su corrupción está en ellos. Hay un defecto en ellos. No te serán aceptados”. ");
INSERT INTO spablm_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Yahvé habló a Moisés diciendo: ");
INSERT INTO spablm_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Cuando nazca un becerro, una oveja o una cabra, permanecerá siete días con su madre. A partir del octavo día será aceptado como ofrenda quemada a Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Ya sea que se trate de una vaca o de una oveja, no la matarás a ella y a su cría en un solo día. ");
INSERT INTO spablm_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“Cuando sacrifiques un sacrificio de acción de gracias a Yahvé, lo sacrificarás para que seas aceptado. ");
INSERT INTO spablm_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Se comerá en el mismo día; no dejarás nada de él para la mañana. Yo soy Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“Por lo tanto, guardarán mis mandamientos y los pondrán en práctica. Yo soy Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","No profanarás mi santo nombre, sino que seré santificado entre los hijos de Israel. Yo soy Yahvé que te santifica, ");
INSERT INTO spablm_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","que te sacó de la tierra de Egipto, para ser tu Dios. Yo soy Yahvé”. ");
INSERT INTO spablm_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Habla a los hijos de Israel y diles: ‘Las fiestas fijas de Yahvé, que proclamarás como convocatorias sagradas, son mis fiestas fijas. ");
INSERT INTO spablm_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“‘Seis días se trabajará, pero el séptimo día es un día de descanso solemne, una santa convocación; no harás ninguna clase de trabajo. Es un día de reposo para Yahvé en todas vuestras moradas. ");
INSERT INTO spablm_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“‘Estas son las fiestas fijas de Yahvé, las convocatorias sagradas, que proclamarás a su tiempo. ");
INSERT INTO spablm_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","En el primer mes, el día catorce del mes, por la tarde, es la Pascua de Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","El decimoquinto día del mismo mes es la fiesta de los panes sin levadura para Yahvé. Durante siete días comerás panes sin levadura. ");
INSERT INTO spablm_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","El primer día tendrás una santa convocación. No harás ningún trabajo regular. ");
INSERT INTO spablm_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Pero durante los siete días ofrecerás a Yahvé una ofrenda encendida. El séptimo día es una santa convocación. No harás ningún trabajo regular”. ");
INSERT INTO spablm_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Habla a los hijos de Israel y diles: ‘Cuando hayáis entrado en la tierra que os doy y hayáis recogido su cosecha, traeréis al sacerdote la gavilla de las primicias de vuestra cosecha. ");
INSERT INTO spablm_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Él agitará la gavilla ante el Señor, para que sea aceptada por ustedes. Al día siguiente del sábado, el sacerdote la mecerá. ");
INSERT INTO spablm_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","El día en que agites la gavilla, ofrecerás un cordero macho sin defecto de un año como holocausto a Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","La ofrenda con él será de dos décimas de efa de harina fina mezclada con aceite, ofrenda encendida a Yahvé en olor agradable; y la libación con él será de vino, la cuarta parte de un hin. ");
INSERT INTO spablm_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","No debes comer pan, ni grano tostado, ni grano fresco, hasta este mismo día, hasta que hayas traído la ofrenda de tu Dios. Este es un estatuto para siempre a través de vuestras generaciones en todas vuestras moradas. ");
INSERT INTO spablm_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“‘Contarás desde el día siguiente al sábado, desde el día en que trajiste la gavilla de la ofrenda mecida: se completarán siete sábados. ");
INSERT INTO spablm_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Al día siguiente del séptimo sábado contarás cincuenta días, y ofrecerás una nueva ofrenda a Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Sacaréis de vuestras moradas dos panes para la ofrenda mecida, hechos de dos décimas de efa de harina fina. Serán cocidos con levadura, como primicias para Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Con el pan presentarás siete corderos de un año sin defecto, un novillo y dos carneros. Serán un holocausto para Yahvé, con su ofrenda y sus libaciones, una ofrenda encendida, de dulce aroma para Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Ofrecerás un macho cabrío como ofrenda por el pecado, y dos corderos de un año como sacrificio de paz. ");
INSERT INTO spablm_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","El sacerdote los agitará con el pan de las primicias como ofrenda mecida ante Yahvé, junto con los dos corderos. Serán sagrados para Yahvé para el sacerdote. ");
INSERT INTO spablm_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Ese mismo día proclamarás que habrá una convocatoria sagrada para ti. No harás ningún trabajo regular. Este es un estatuto para siempre en todas vuestras moradas a lo largo de vuestras generaciones. ");
INSERT INTO spablm_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“‘Cuando recojas la cosecha de tu tierra, no debes segar totalmente en los rincones de tu campo. No debes recoger los restos de tu cosecha. Debes dejarlos para el pobre y para el extranjero. Yo soy Yahvé, tu Dios”. ");
INSERT INTO spablm_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Habla a los hijos de Israel, diciendo: ‘En el séptimo mes, el primer día del mes, habrá un descanso solemne para ustedes, un memorial de toque de trompetas, una convocatoria santa. ");
INSERT INTO spablm_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","No haréis ningún trabajo regular. Ofreceréis una ofrenda encendida a Yahvé’”. ");
INSERT INTO spablm_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Yahvé habló a Moisés diciendo: ");
INSERT INTO spablm_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Sin embargo, el décimo día de este séptimo mes es el día de la expiación. Será para ustedes una convocatoria sagrada. Os afligiréis y ofreceréis una ofrenda encendida a Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","No haréis ninguna clase de trabajo en ese mismo día, porque es un día de expiación, para expiaros ante Yahvé vuestro Dios. ");
INSERT INTO spablm_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Porque el que no se niegue a sí mismo en ese mismo día, será cortado de su pueblo. ");
INSERT INTO spablm_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","El que haga cualquier tipo de trabajo en ese mismo día, yo destruiré a esa persona de entre su pueblo. ");
INSERT INTO spablm_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","No harás ninguna clase de trabajo: es un estatuto para siempre a través de tus generaciones en todas tus moradas. ");
INSERT INTO spablm_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Será para vosotros un sábado de descanso solemne, y os negaréis a vosotros mismos. En el noveno día del mes, al atardecer, de tarde en tarde, guardaréis vuestro sábado”. ");
INSERT INTO spablm_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Habla a los hijos de Israel y diles: ‘El día quince de este mes séptimo es la fiesta de las cabañas durante siete días a Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","El primer día será una convocatoria sagrada. No harás ningún trabajo regular. ");
INSERT INTO spablm_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Durante los siete días ofrecerás a Yahvé una ofrenda encendida. El octavo día será una convocatoria sagrada para ustedes. Ofreceréis a Yahvé una ofrenda encendida. Es una asamblea solemne; no harás ningún trabajo regular. ");
INSERT INTO spablm_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“‘Estas son las fiestas señaladas por Yahvé, que proclamarás como convocatorias sagradas, para ofrecer una ofrenda encendida a Yahvé, un holocausto, una ofrenda de comida, un sacrificio y ofrendas de bebida, cada una en su día — ");
INSERT INTO spablm_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","además de los sábados de Yahvé, y además de tus dones, y además de todos tus votos, y además de todas tus ofrendas voluntarias, que das a Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“‘Así pues, el día quince del mes séptimo, cuando hayáis recogido los frutos de la tierra, celebraréis la fiesta de Yahvé durante siete días. El primer día será un descanso solemne, y el octavo día será un descanso solemne. ");
INSERT INTO spablm_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","El primer día tomarás los frutos de los árboles majestuosos, las ramas de las palmeras, las ramas de los árboles frondosos y los sauces del arroyo; y te alegrarás ante Yahvé, tu Dios, durante siete días. ");
INSERT INTO spablm_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Lo celebraréis como fiesta para Yahvé durante siete días al año. Es un estatuto para siempre a lo largo de vuestras generaciones. La celebraréis en el séptimo mes. ");
INSERT INTO spablm_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Viviréis en refugios temporales durante siete días. Todos los nativos de Israel habitarán en refugios temporales, ");
INSERT INTO spablm_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","para que vuestras generaciones sepan que yo hice habitar a los hijos de Israel en refugios temporales cuando los saqué de la tierra de Egipto. Yo soy Yahvé, vuestro Dios”. ");
INSERT INTO spablm_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Así pues, Moisés declaró a los hijos de Israel las fiestas señaladas por Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Ordena a los hijos de Israel que te traigan aceite de oliva puro batido para la luz, para hacer arder continuamente una lámpara. ");
INSERT INTO spablm_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Fuera del velo del Testimonio, en la Tienda del Encuentro, Aarón la mantendrá en orden desde la tarde hasta la mañana ante Yahvé continuamente. Será un estatuto para siempre a lo largo de vuestras generaciones. ");
INSERT INTO spablm_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","El mantendrá en orden las lámparas en el candelabro de oro puro ante el Señor continuamente. ");
INSERT INTO spablm_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“Tomarás harina fina y cocerás con ella doce tortas; dos décimas de efa irán en una torta. ");
INSERT INTO spablm_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Las pondrás en dos hileras, seis en cada hilera, sobre la mesa de oro puro delante de Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Pondrás incienso puro en cada hilera, para que sea para el pan un memorial, una ofrenda encendida a Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Cada día de reposo lo pondrá en orden delante de Yahvé continuamente. Es un pacto eterno a favor de los hijos de Israel. ");
INSERT INTO spablm_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Será para Aarón y sus hijos. Lo comerán en un lugar sagrado, porque es lo más sagrado para él de las ofrendas de Yahvé hechas por fuego por un estatuto perpetuo.” ");
INSERT INTO spablm_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","El hijo de una mujer israelita, cuyo padre era egipcio, salió entre los hijos de Israel; y el hijo de la mujer israelita y un hombre de Israel se pelearon en el campamento. ");
INSERT INTO spablm_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","El hijo de la mujer israelita blasfemó el Nombre y maldijo, y lo llevaron a Moisés. Su madre se llamaba Selomit, hija de Dibri, de la tribu de Dan. ");
INSERT INTO spablm_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Lo pusieron en custodia hasta que se les declarara la voluntad de Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Saca del campamento al que ha maldecido, y que todos los que lo hayan oído pongan sus manos sobre su cabeza, y que toda la congregación lo apedree. ");
INSERT INTO spablm_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Hablarás a los hijos de Israel diciendo: “El que maldiga a su Dios cargará con su pecado. ");
INSERT INTO spablm_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","El que blasfeme el nombre de Yahvé, ciertamente morirá. Toda la congregación lo apedreará ciertamente. Tanto el extranjero como el nativo serán condenados a muerte cuando blasfemen el Nombre. ");
INSERT INTO spablm_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“‘El que hiera mortalmente a un hombre, morirá. ");
INSERT INTO spablm_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","El que hiera mortalmente a un animal, lo compensará, vida por vida. ");
INSERT INTO spablm_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Si alguien hiere a su prójimo, se hará con él lo mismo que él ha hecho: ");
INSERT INTO spablm_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","fractura por fractura, ojo por ojo, diente por diente. Se hará con él lo mismo que haya hecho con alguien. ");
INSERT INTO spablm_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","El que mate a un animal lo compensará, y el que mate a un hombre será condenado a muerte. ");
INSERT INTO spablm_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Tendrás un mismo tipo de ley tanto para el extranjero como para el nativo, porque yo soy Yahvé, tu Dios”. ");
INSERT INTO spablm_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Moisés habló a los hijos de Israel, y sacaron del campamento al que había maldecido y lo apedrearon. Los hijos de Israel hicieron lo que Yahvé les ordenó a Moisés. ");
INSERT INTO spablm_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Yahvé dijo a Moisés en el monte Sinaí: ");
INSERT INTO spablm_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Habla a los hijos de Israel y diles: ‘Cuando entréis en la tierra que os doy, la tierra guardará un sábado para Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Sembrarás tu campo durante seis años, y podarás tu viña durante seis años, y recogerás sus frutos; ");
INSERT INTO spablm_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","pero en el séptimo año habrá un sábado de descanso solemne para la tierra, un sábado para Yahvé. No sembrarás tu campo ni podarás tu viña. ");
INSERT INTO spablm_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Lo que crezca por sí mismo en tu cosecha no lo cosecharás, y no recogerás las uvas de tu viña desnuda. Será un año de descanso solemne para la tierra. ");
INSERT INTO spablm_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","El sábado de la tierra será para tu comida; para ti, para tu siervo, para tu sierva, para tu jornalero y para tu extranjero, que vive como forastero contigo. ");
INSERT INTO spablm_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","También para tu ganado y para los animales que están en tu tierra, todo su producto será para comer. ");
INSERT INTO spablm_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“‘Contarás siete sábados de años, siete veces siete años; y serán para ti los días de siete sábados de años, cuarenta y nueve años. ");
INSERT INTO spablm_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Entonces harás sonar la trompeta en el décimo día del séptimo mes. En el Día de la Expiación tocarás la trompeta en toda tu tierra. ");
INSERT INTO spablm_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Santificarás el quincuagésimo año y proclamarás la libertad en toda la tierra para todos sus habitantes. Será un jubileo para vosotros; y cada uno de vosotros volverá a su propiedad, y cada uno de vosotros volverá a su familia. ");
INSERT INTO spablm_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Ese quincuagésimo año será un jubileo para vosotros. En él no sembraréis, ni cosecharéis lo que crezca por sí mismo, ni recogeréis de las viñas deshojadas. ");
INSERT INTO spablm_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Porque es un jubileo; será sagrado para vosotros. Comeréis de su cosecha del campo. ");
INSERT INTO spablm_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“‘En este Año del Jubileo cada uno de vosotros volverá a su propiedad. ");
INSERT INTO spablm_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","“‘Si vendes algo a tu prójimo, o compras a tu prójimo, no te perjudicarás mutuamente. ");
INSERT INTO spablm_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Según el número de años después del jubileo comprarás a tu prójimo. Según el número de años de las cosechas te venderá. ");
INSERT INTO spablm_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Según la duración de los años, aumentaréis su precio, y según la brevedad de los años, disminuiréis su precio; porque él os vende el número de las cosechas. ");
INSERT INTO spablm_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","No os perjudicaréis unos a otros, sino que temeréis a vuestro Dios, porque yo soy Yahvé, vuestro Dios. ");
INSERT INTO spablm_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“‘Por tanto, pondréis en práctica mis estatutos, y guardaréis mis ordenanzas y las pondréis en práctica; y habitaréis en la tierra con seguridad. ");
INSERT INTO spablm_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","La tierra dará su fruto, y comeréis hasta saciaros, y habitaréis en ella con seguridad. ");
INSERT INTO spablm_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Si dijerais: “¿Qué comeremos el séptimo año? He aquí que no sembraremos, ni recogeremos nuestros frutos”; ");
INSERT INTO spablm_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","entonces ordenaré mi bendición sobre vosotros en el sexto año, y dará fruto durante los tres años. ");
INSERT INTO spablm_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","El octavo año sembrarás y comerás de los frutos de la vieja tienda hasta el noveno año. Hasta que dé sus frutos, comerás de la vieja tienda. ");
INSERT INTO spablm_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“‘La tierra no se venderá a perpetuidad, pues la tierra es mía; porque vosotros sois extranjeros y vivís como tales conmigo. ");
INSERT INTO spablm_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","En toda la tierra de vuestra posesión concederéis un rescate por la tierra. ");
INSERT INTO spablm_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“‘Si tu hermano se empobrece y vende parte de sus bienes, entonces su pariente más cercano vendrá a rescatar lo que su hermano ha vendido. ");
INSERT INTO spablm_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Si el hombre no tiene quien lo rescate, y llega a ser próspero y encuentra medios suficientes para redimirlo, ");
INSERT INTO spablm_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","entonces que cuente los años transcurridos desde su venta, y devuelva el excedente al hombre a quien lo vendió; y éste volverá a su propiedad. ");
INSERT INTO spablm_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Pero si no puede recuperarlo para sí, entonces lo que haya vendido quedará en manos del que lo compró hasta el Año del Jubileo. En el Jubileo será liberado, y volverá a su propiedad. ");
INSERT INTO spablm_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“‘Si un hombre vende una vivienda en una ciudad amurallada, podrá rescatarla en el plazo de un año entero después de haberla vendido. Durante un año completo tendrá el derecho de redención. ");
INSERT INTO spablm_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Si no se rescata en el plazo de un año completo, la casa que esté en la ciudad amurallada quedará asegurada a perpetuidad para el que la compró, por sus generaciones. No se liberará en el jubileo. ");
INSERT INTO spablm_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Pero las casas de las aldeas que no tengan muro alrededor serán contabilizadas con los campos del país; podrán ser redimidas, y serán liberadas en el Jubileo. ");
INSERT INTO spablm_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“‘Sin embargo, en las ciudades de los levitas, los levitas podrán redimir las casas de las ciudades de su posesión en cualquier momento. ");
INSERT INTO spablm_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Los levitas podrán rescatar la casa vendida y la ciudad de su posesión, y será liberada en el jubileo; porque las casas de las ciudades de los levitas son su posesión entre los hijos de Israel. ");
INSERT INTO spablm_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Pero el campo de las tierras de pastoreo de sus ciudades no podrá ser vendido, porque es su posesión perpetua. ");
INSERT INTO spablm_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“‘Si tu hermano se ha empobrecido, y su mano no puede mantenerse entre vosotros, entonces lo mantendrás. Vivirá contigo como un extranjero y un residente temporal. ");
INSERT INTO spablm_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","No tomes de él ningún interés ni ganancia, sino teme a tu Dios, para que tu hermano viva entre vosotros. ");
INSERT INTO spablm_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","No le prestarás tu dinero con intereses, ni le darás tu comida con fines de lucro. ");
INSERT INTO spablm_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Yo soy el Señor, tu Dios, que te sacó de la tierra de Egipto para darte la tierra de Canaán y para ser tu Dios. ");
INSERT INTO spablm_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“‘Si tu hermano se ha empobrecido entre vosotros y se vende a ti, no lo harás servir como esclavo. ");
INSERT INTO spablm_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Como jornalero y como residente temporal estará contigo; servirá contigo hasta el Año del Jubileo. ");
INSERT INTO spablm_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Entonces saldrá de vosotros, él y sus hijos con él, y volverá a su familia y a la posesión de sus padres. ");
INSERT INTO spablm_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Porque son mis siervos, a quienes saqué de la tierra de Egipto. No serán vendidos como esclavos. ");
INSERT INTO spablm_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","No te enseñorearás de él con dureza, sino que temerás a tu Dios. ");
INSERT INTO spablm_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“‘En cuanto a tus esclavos y esclavas, que puedes tener de las naciones que te rodean, de ellos podrás comprar esclavos y esclavas. ");
INSERT INTO spablm_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Además, de los hijos de los extranjeros que vivan entre vosotros, podréis comprar, y de sus familias que estén con vosotros, lo que hayan concebido en vuestra tierra; y serán de vuestra propiedad. ");
INSERT INTO spablm_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Podrás convertirlos en herencia para tus hijos después de ti, para que los tengas en posesión. De ellos podréis tomar vuestros esclavos para siempre, pero sobre vuestros hermanos los hijos de Israel no gobernaréis, unos sobre otros, con dureza. ");
INSERT INTO spablm_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“‘Si un extranjero o un residente temporal entre vosotros se enriquece, y su hermano junto a él se ha empobrecido, y se vende al extranjero o a la extranjera que vive entre vosotros, o a un miembro de la familia del extranjero, ");
INSERT INTO spablm_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","después de ser vendido podrá ser redimido. Uno de sus hermanos podrá redimirlo; ");
INSERT INTO spablm_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","o su tío, o el hijo de su tío, podrá redimirlo, o cualquiera que sea pariente cercano de su familia podrá redimirlo; o si se ha enriquecido, podrá redimirlo él mismo. ");
INSERT INTO spablm_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Contará con el que lo compró desde el año en que se vendió a él hasta el año del jubileo. El precio de su venta será según el número de años; estará con él según el tiempo de un jornalero. ");
INSERT INTO spablm_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Si aún quedan muchos años, según ellos devolverá el precio de su redención del dinero por el que fue comprado. ");
INSERT INTO spablm_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Si faltan pocos años para el año del jubileo, entonces contará con él; según sus años de servicio devolverá el precio de su redención. ");
INSERT INTO spablm_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Como siervo contratado año tras año estará con él. No gobernará con dureza sobre él a sus ojos. ");
INSERT INTO spablm_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Si no es redimido por estos medios, será liberado en el Año del Jubileo: él y sus hijos con él. ");
INSERT INTO spablm_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Porque para mí los hijos de Israel son siervos; son mis siervos que saqué de la tierra de Egipto. Yo soy Yahvé, vuestro Dios. ");
INSERT INTO spablm_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“‘No os haréis ídolos, y no levantaréis imagen tallada ni columna, y no pondréis en vuestra tierra ninguna piedra labrada para inclinaros ante ella, porque yo soy Yahvé, vuestro Dios. ");
INSERT INTO spablm_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","“‘Guardarán mis sábados y tendrán reverencia por mi santuario. Yo soy Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“‘Si andáis en mis estatutos y guardáis mis mandamientos, y los ponéis en práctica, ");
INSERT INTO spablm_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","entonces os daré vuestras lluvias a su tiempo, y la tierra dará sus frutos, y los árboles del campo darán sus frutos. ");
INSERT INTO spablm_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Tu trilla continuará hasta la vendimia, y la vendimia continuará hasta el tiempo de la siembra. Comerás tu pan en abundancia y habitarás tu tierra con seguridad. ");
INSERT INTO spablm_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“‘Daré paz en la tierra, y os acostaréis, y nadie os hará temer. Quitaré de la tierra los animales malignos, y la espada no pasará por tu tierra. ");
INSERT INTO spablm_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Perseguiréis a vuestros enemigos, y caerán ante vosotros a espada. ");
INSERT INTO spablm_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Cinco de vosotros perseguirán a cien, y cien de vosotros perseguirán a diez mil; y vuestros enemigos caerán ante vosotros a espada. ");
INSERT INTO spablm_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“‘Te respetaré, te haré fructificar, te multiplicaré y estableceré mi pacto contigo. ");
INSERT INTO spablm_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Comerás las provisiones viejas guardadas durante mucho tiempo, y desplazarás lo viejo a causa de lo nuevo. ");
INSERT INTO spablm_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Pondré mi tienda entre vosotros, y mi alma no os abominará. ");
INSERT INTO spablm_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Caminaré en medio de ustedes y seré su Dios, y ustedes serán mi pueblo. ");
INSERT INTO spablm_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Yo soy el Señor, tu Dios, que te sacó de la tierra de Egipto para que no fueras su esclavo. He roto las barras de tu yugo y te he hecho caminar erguido. ");
INSERT INTO spablm_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“‘Pero si no me escuchas, y no pones en práctica todos estos mandamientos, ");
INSERT INTO spablm_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","y si rechazas mis estatutos, y si tu alma aborrece mis ordenanzas, de modo que no pongas en práctica todos mis mandamientos, sino que rompas mi pacto, ");
INSERT INTO spablm_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","yo también te haré esto: Pondré sobre ti el terror, la tisis y la fiebre, que consumirán los ojos y harán que el alma se consuma. Sembrarás tu semilla en vano, pues tus enemigos la comerán. ");
INSERT INTO spablm_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Pondré mi rostro contra ti, y serás golpeado ante tus enemigos. Los que te odian se enseñorearán de ti; y huirás cuando nadie te persiga. ");
INSERT INTO spablm_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“‘Si a pesar de estas cosas no me escuchas, entonces te castigaré siete veces más por tus pecados. ");
INSERT INTO spablm_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Romperé la soberbia de tu poder, y haré que tu cielo sea como el hierro, y tu tierra como el bronce. ");
INSERT INTO spablm_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Tu fuerza se gastará en vano, porque tu tierra no dará su cosecha, ni los árboles de la tierra darán su fruto. ");
INSERT INTO spablm_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“‘Si andas en contra de mí y no me escuchas, entonces traeré sobre ti siete veces más plagas según tus pecados. ");
INSERT INTO spablm_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Enviaré entre vosotros animales salvajes que os robarán vuestros hijos, destruirán vuestro ganado y os harán escasos. Vuestros caminos quedarán desolados. ");
INSERT INTO spablm_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“‘Si por estas cosas no os volvéis a mí, sino que camináis en contra de mí, ");
INSERT INTO spablm_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","entonces yo también caminaré en contra de vosotros; y os golpearé, yo mismo, siete veces por vuestros pecados. ");
INSERT INTO spablm_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Traeré sobre vosotros una espada que ejecutará la venganza del pacto. Seréis reunidos en vuestras ciudades, y enviaré la peste entre vosotros. Seréis entregados a la mano del enemigo. ");
INSERT INTO spablm_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Cuando rompa vuestro báculo de pan, diez mujeres cocerán vuestro pan en un solo horno, y volverán a entregar vuestro pan por peso. Comerás y no te saciarás. ");
INSERT INTO spablm_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“‘Si a pesar de esto no me escuchas, sino que andas en contra de mí, ");
INSERT INTO spablm_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","entonces andaré en contra de ti con ira. También te castigaré siete veces por tus pecados. ");
INSERT INTO spablm_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Comerás la carne de tus hijos, y comerás la carne de tus hijas. ");
INSERT INTO spablm_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Destruiré vuestros lugares altos, derribaré vuestros altares de incienso y arrojaré vuestros cadáveres sobre los cuerpos de vuestros ídolos, y mi alma os abominará. ");
INSERT INTO spablm_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Asolaré vuestras ciudades, y pondré en desolación vuestros santuarios. No me deleitaré con la dulce fragancia de vuestras ofrendas. ");
INSERT INTO spablm_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Pondré la tierra en desolación, y tus enemigos que la habitan se asombrarán de ella. ");
INSERT INTO spablm_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Te dispersaré entre las naciones, y sacaré la espada tras de ti. Vuestra tierra será una desolación, y vuestras ciudades serán un desierto. ");
INSERT INTO spablm_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Entonces la tierra disfrutará de sus sábados mientras esté desolada y ustedes estén en la tierra de sus enemigos. Incluso entonces la tierra descansará y disfrutará de sus sábados. ");
INSERT INTO spablm_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Mientras yazca desolada tendrá descanso, el descanso que no tuvo en tus sábados cuando vivías en ella. ");
INSERT INTO spablm_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“‘En cuanto a los que quedan, enviaré un desfallecimiento en sus corazones en las tierras de sus enemigos. El sonido de una hoja al caer los pondrá en fuga; y huirán, como se huye de la espada. Caerán cuando nadie los persiga. ");
INSERT INTO spablm_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Tropezarán unos con otros, como ante la espada, cuando nadie los perseguía. No tendrán fuerza para resistir ante sus enemigos. ");
INSERT INTO spablm_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Perecerás entre las naciones. La tierra de vuestros enemigos os devorará. ");
INSERT INTO spablm_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Los que queden de vosotros se consumirán en su iniquidad en las tierras de vuestros enemigos; y también en las iniquidades de sus padres se consumirán con ellos. ");
INSERT INTO spablm_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“‘Si confiesan su iniquidad y la iniquidad de sus padres, en la transgresión que cometieron contra mí; y también que porque anduvieron en contra de mí, ");
INSERT INTO spablm_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","yo también anduve en contra de ellos, y los llevé a la tierra de sus enemigos; si entonces su corazón incircunciso se humilla, y entonces aceptan el castigo de su iniquidad, ");
INSERT INTO spablm_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","entonces me acordaré de mi pacto con Jacob, de mi pacto con Isaac, y también de mi pacto con Abraham; y me acordaré de la tierra. ");
INSERT INTO spablm_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","La tierra también será abandonada por ellos, y disfrutará de sus sábados mientras yace desolada sin ellos; y aceptarán el castigo de su iniquidad porque rechazaron mis ordenanzas, y su alma aborreció mis estatutos. ");
INSERT INTO spablm_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Sin embargo, cuando estén en la tierra de sus enemigos, no los rechazaré ni los aborreceré para destruirlos por completo y para romper mi pacto con ellos, porque yo soy el Señor, su Dios. ");
INSERT INTO spablm_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Pero me acordaré por ellos del pacto de sus antepasados, a quienes saqué de la tierra de Egipto a la vista de las naciones, para ser su Dios. Yo soy Yahvé”. ");
INSERT INTO spablm_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Estos son los estatutos, ordenanzas y leyes que Yahvé estableció entre él y los hijos de Israel en el monte Sinaí por medio de Moisés. ");
INSERT INTO spablm_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Habla a los hijos de Israel y diles: ‘Cuando un hombre consagre a una persona a Yahvé en un voto, según vuestra valoración, ");
INSERT INTO spablm_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","vuestra valoración de un varón de veinte a sesenta años será de cincuenta siclos de plata, según el siclo del santuario. ");
INSERT INTO spablm_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Si se trata de una mujer, tu valoración será de treinta siclos. ");
INSERT INTO spablm_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Si la persona tiene de cinco a veinte años, tu valoración será de veinte siclos para el varón y de diez siclos para la mujer. ");
INSERT INTO spablm_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Si la persona tiene de un mes a cinco años, tu valoración será de cinco siclos de plata para el varón y de tres siclos de plata para la mujer. ");
INSERT INTO spablm_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Si la persona es de sesenta años en adelante, si es varón, tu valoración será de quince siclos, y para la mujer de diez siclos. ");
INSERT INTO spablm_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Pero si es más pobre que tu valuación, entonces será presentada ante el sacerdote, y éste le asignará un valor. El sacerdote le asignará un valor según su capacidad de pago. ");
INSERT INTO spablm_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“‘Si se trata de un animal del que los hombres ofrecen una ofrenda a Yahvé, todo lo que un hombre da de él a Yahvé se convierte en santo. ");
INSERT INTO spablm_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","No lo alterará, ni lo cambiará, un bien por un mal, o un mal por un bien. Si se cambia un animal por otro, tanto éste como el que se cambia serán santos. ");
INSERT INTO spablm_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Si se trata de un animal impuro, del que no se ofrece como ofrenda a Yahvé, entonces pondrá el animal delante del sacerdote; ");
INSERT INTO spablm_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","y el sacerdote lo evaluará, si es bueno o malo. Según lo evalúe el sacerdote, así será. ");
INSERT INTO spablm_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Pero si en verdad lo redime, entonces añadirá la quinta parte de él a su valoración. ");
INSERT INTO spablm_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“‘Cuando un hombre dedique su casa a ser santa para Yahvé, entonces el sacerdote la evaluará, si es buena o mala. Según la evalúe el sacerdote, así quedará. ");
INSERT INTO spablm_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Si el que la dedica quiere redimir su casa, entonces le añadirá la quinta parte del dinero de su evaluación, y será suya. ");
INSERT INTO spablm_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“‘Si un hombre dedica a Yahvé una parte del campo de su posesión, su valoración será según la semilla de la misma. La siembra de un homer de cebada se valorará en cincuenta siclos de plata. ");
INSERT INTO spablm_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Si él dedica su campo desde el Año del Jubileo, según tu valoración se mantendrá. ");
INSERT INTO spablm_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Pero si dedica su campo después del Jubileo, el sacerdote le contará el dinero según los años que falten para el Año del Jubileo, y se hará una rebaja de tu valoración. ");
INSERT INTO spablm_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Si el que dedicó el campo lo rescata, le agregará la quinta parte del dinero de tu valuación, y seguirá siendo suyo. ");
INSERT INTO spablm_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Si no quiere rescatar el campo, o si lo ha vendido a otro hombre, ya no se rescatará; ");
INSERT INTO spablm_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","pero el campo, cuando salga en el jubileo, será sagrado para Yahvé, como campo consagrado. Será propiedad de los sacerdotes. ");
INSERT INTO spablm_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“‘Si dedica a Yahvé un campo que ha comprado, que no es del campo de su posesión, ");
INSERT INTO spablm_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","entonces el sacerdote le calculará el valor de su valoración hasta el Año del Jubileo; y le dará su valoración en ese día, como cosa sagrada para Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","En el Año del Jubileo el campo volverá al que lo compró, al que le pertenece la posesión de la tierra. ");
INSERT INTO spablm_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Todas vuestras valoraciones serán según el siclo del santuario: veinte gerahs al siclo. ");
INSERT INTO spablm_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“‘Sin embargo, el primogénito entre los animales, que pertenece a Yahvé como primogénito, ningún hombre puede dedicarlo, ya sea un buey o una oveja. Es de Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Si se trata de un animal impuro, lo recomprará según tu valoración, y le añadirá la quinta parte; o si no se redime, se venderá según tu valoración. ");
INSERT INTO spablm_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“‘Sin embargo, ninguna cosa consagrada que un hombre dedique a Yahvé de todo lo que tiene, sea de hombre o de animal, o del campo de su posesión, será vendida o redimida. Todo lo que se consagra permanentemente es santísimo para Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","“‘Ningún consagrado a la destrucción, que sea consagrado de entre los hombres, será rescatado. Será condenado a muerte. ");
INSERT INTO spablm_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“‘Todo el diezmo de la tierra, ya sea de la semilla de la tierra o del fruto de los árboles, es de Yahvé. Es sagrado para Yahvé. ");
INSERT INTO spablm_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Si un hombre rescata algo de su diezmo, le añadirá la quinta parte. ");
INSERT INTO spablm_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Todo el diezmo de las vacas o de los rebaños, todo lo que pase por debajo de la vara, el décimo será santo para el Señor. ");
INSERT INTO spablm_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","No examinará si es bueno o malo, ni lo cambiará. Si lo cambia, tanto él como aquello por lo que se cambie serán sagrados. No se canjeará”. ");
INSERT INTO spablm_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Estos son los mandamientos que Yahvé ordenó a Moisés para los hijos de Israel en el Monte Sinaí. ");
INSERT INTO spablm_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Yahvé habló a Moisés en el desierto del Sinaí, en la Tienda del Encuentro, el primer día del segundo mes, en el segundo año después de haber salido de la tierra de Egipto, diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Haz un censo de toda la congregación de los hijos de Israel, por sus familias, por las casas de sus padres, según el número de los nombres, cada varón, uno por uno, ");
INSERT INTO spablm_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","de veinte años en adelante, todos los que puedan salir a la guerra en Israel. Tú y Aarón los contarán por sus divisiones. ");
INSERT INTO spablm_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Con vosotros habrá un hombre de cada tribu, cada uno jefe de la casa de sus padres. ");
INSERT INTO spablm_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Estos son los nombres de los hombres que estarán con vosotros: De Reuben: Elizur el hijo de Sedeur. ");
INSERT INTO spablm_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","De Simeón: Selumiel, hijo de Zurisadai. ");
INSERT INTO spablm_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","De Judá: Naasón, hijo de Aminadab. ");
INSERT INTO spablm_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","De Isacar: Netanel, hijo de Zuar. ");
INSERT INTO spablm_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","De Zabulón: Eliab, hijo de Helón. ");
INSERT INTO spablm_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","De los hijos de José: de Efraín: Elisama hijo de Amiud; de Manasés Gamaliel, hijo de Pedasur. ");
INSERT INTO spablm_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","De Benjamín: Abidán, hijo de Gideoni. ");
INSERT INTO spablm_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","De Dan: Ahiezer, hijo de Ammishaddai. ");
INSERT INTO spablm_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","De Aser: Pagiel, hijo de Ocran. ");
INSERT INTO spablm_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","De Gad: Eliasaf, hijo de Deuel. ");
INSERT INTO spablm_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","De Neftalí: Ahira, hijo de Enán”. ");
INSERT INTO spablm_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Estos son los que fueron llamados de la congregación, los príncipes de las tribus de sus padres; eran los jefes de los millares de Israel. ");
INSERT INTO spablm_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Moisés y Aarón tomaron a estos hombres mencionados por su nombre. ");
INSERT INTO spablm_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","Reunieron a toda la congregación el primer día del segundo mes, y declararon su ascendencia por sus familias, por las casas de sus padres, según el número de los nombres, de veinte años en adelante, uno por uno. ");
INSERT INTO spablm_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Como Yahvé le ordenó a Moisés, así los contó en el desierto de Sinaí. ");
INSERT INTO spablm_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Los hijos de Rubén, primogénitos de Israel, sus generaciones, por sus familias, por las casas de sus padres, según el número de los nombres, uno por uno, todo varón de veinte años para arriba, todos los que podían salir a la guerra: ");
INSERT INTO spablm_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Los contados de ellos, de la tribu de Rubén, fueron cuarenta y seis mil quinientos. ");
INSERT INTO spablm_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","De los hijos de Simeón, sus generaciones, por sus familias, por las casas de sus padres, los que fueron contados de ella, según el número de los nombres, uno por uno, todo varón de veinte años para arriba, todos los que podían salir a la guerra: ");
INSERT INTO spablm_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","los que fueron contados de ellos, de la tribu de Simeón, fueron cincuenta y nueve mil trescientos. ");
INSERT INTO spablm_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","De los hijos de Gad, sus generaciones, por sus familias, por las casas de sus padres, según el número de los nombres, de veinte años para arriba, todos los que podían salir a la guerra: ");
INSERT INTO spablm_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Los contados de ellos, de la tribu de Gad, fueron cuarenta y cinco mil seiscientos cincuenta. ");
INSERT INTO spablm_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","De los hijos de Judá, sus generaciones, por sus familias, por las casas de sus padres, según el número de los nombres, de veinte años para arriba, todos los que podían salir a la guerra: ");
INSERT INTO spablm_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Los contados de ellos, de la tribu de Judá, fueron setenta y cuatro mil seiscientos. ");
INSERT INTO spablm_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","De los hijos de Isacar, sus generaciones, por sus familias, por las casas de sus padres, según el número de los nombres, de veinte años para arriba, todos los que podían salir a la guerra: ");
INSERT INTO spablm_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Los contados de ellos, de la tribu de Isacar, fueron cincuenta y cuatro mil cuatrocientos. ");
INSERT INTO spablm_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","De los hijos de Zabulón, sus generaciones, por sus familias, por las casas de sus padres, según el número de los nombres, de veinte años para arriba, todos los que podían salir a la guerra: ");
INSERT INTO spablm_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Los contados de ellos, de la tribu de Zabulón, fueron cincuenta y siete mil cuatrocientos. ");
INSERT INTO spablm_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","De los hijos de José: de los hijos de Efraín, sus generaciones, por sus familias, por las casas de sus padres, según el número de los nombres, de veinte años para arriba, todos los que podían salir a la guerra: ");
INSERT INTO spablm_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","los contados de ellos, de la tribu de Efraín, fueron cuarenta mil quinientos. ");
INSERT INTO spablm_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","De los hijos de Manasés, sus generaciones, por sus familias, por las casas de sus padres, según el número de los nombres, de veinte años para arriba, todos los que podían salir a la guerra: ");
INSERT INTO spablm_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Los contados de ellos, de la tribu de Manasés, fueron treinta y dos mil doscientos. ");
INSERT INTO spablm_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","De los hijos de Benjamín, sus generaciones, por sus familias, por las casas de sus padres, según el número de los nombres, de veinte años para arriba, todos los que podían salir a la guerra: ");
INSERT INTO spablm_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Los contados de ellos, de la tribu de Benjamín, fueron treinta y cinco mil cuatrocientos. ");
INSERT INTO spablm_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","De los hijos de Dan, sus generaciones, por sus familias, por las casas de sus padres, según el número de los nombres, de veinte años para arriba, todos los que podían salir a la guerra: ");
INSERT INTO spablm_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Los contados de ellos, de la tribu de Dan, fueron sesenta y dos mil setecientos. ");
INSERT INTO spablm_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","De los hijos de Aser, sus generaciones, por sus familias, por las casas de sus padres, según el número de los nombres, de veinte años para arriba, todos los que podían salir a la guerra: ");
INSERT INTO spablm_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Los contados de ellos, de la tribu de Aser, fueron cuarenta y un mil quinientos. ");
INSERT INTO spablm_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","De los hijos de Neftalí, sus generaciones, por sus familias, por las casas de sus padres, según el número de los nombres, de veinte años para arriba, todos los que podían salir a la guerra: ");
INSERT INTO spablm_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Los contados de ellos, de la tribu de Neftalí, fueron cincuenta y tres mil cuatrocientos. ");
INSERT INTO spablm_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Estos son los que fueron contados, los cuales contaron Moisés y Aarón, y los doce hombres que eran príncipes de Israel, cada uno por la casa de su padre. ");
INSERT INTO spablm_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Así que todos los que fueron contados de los hijos de Israel por las casas de sus padres, de veinte años para arriba, todos los que podían salir a la guerra en Israel — ");
INSERT INTO spablm_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","todos los que fueron contados fueron seiscientos tres mil quinientos cincuenta. ");
INSERT INTO spablm_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Pero los levitas según la tribu de sus padres no fueron contados entre ellos. ");
INSERT INTO spablm_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Porque Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Sólo la tribu de Leví no contarás, ni harás censo de ellos entre los hijos de Israel; ");
INSERT INTO spablm_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","sino que designarás a los levitas sobre el Tabernáculo del Testimonio, y sobre todos sus enseres, y sobre todo lo que le pertenece. Ellos llevarán el tabernáculo y todos sus enseres; lo cuidarán y acamparán alrededor de él. ");
INSERT INTO spablm_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Cuando el tabernáculo deba trasladarse, los levitas lo desmontarán; y cuando el tabernáculo deba levantarse, los levitas lo armarán. El extranjero que se acerque morirá. ");
INSERT INTO spablm_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Los hijos de Israel acamparán, cada uno en su campamento, y cada uno en su estandarte, según sus divisiones. ");
INSERT INTO spablm_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Pero los levitas acamparán alrededor del Tabernáculo del Testimonio, para que no haya ira en la congregación de los hijos de Israel. Los levitas serán responsables del Tabernáculo del Testimonio”. ");
INSERT INTO spablm_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Así hicieron los hijos de Israel. Según todo lo que Yahvé ordenó a Moisés, así lo hicieron. ");
INSERT INTO spablm_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Yahvé habló a Moisés y a Aarón, diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Los hijos de Israel acamparán cada uno con su propio estandarte, con los estandartes de las casas de sus padres. Acamparán alrededor de la Tienda del Encuentro, a distancia de ella. ");
INSERT INTO spablm_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","“Los que acampen en el lado oriental hacia la salida del sol serán del estandarte del campamento de Judá, según sus divisiones. El príncipe de los hijos de Judá será Naasón, hijo de Aminadab. ");
INSERT INTO spablm_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Su división, y los que fueron contados de ellos, fueron setenta y cuatro mil seiscientos. ");
INSERT INTO spablm_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","“Los que acampen junto a él serán de la tribu de Isacar. El príncipe de los hijos de Isacar será Netanel, hijo de Zuar. ");
INSERT INTO spablm_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Su división, y los que fueron contados de ella, fueron cincuenta y cuatro mil cuatrocientos. ");
INSERT INTO spablm_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","“La tribu de Zabulón: el príncipe de los hijos de Zabulón será Eliab hijo de Helón. ");
INSERT INTO spablm_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Su división, y los contados de ella, fueron cincuenta y siete mil cuatrocientos. ");
INSERT INTO spablm_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","“Todos los contados del campamento de Judá fueron ciento ochenta y seis mil cuatrocientos, según sus divisiones. Ellos partirán primero. ");
INSERT INTO spablm_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","“En el lado sur estará el estandarte del campamento de Rubén según sus divisiones. El príncipe de los hijos de Rubén será Elisur, hijo de Sedeur. ");
INSERT INTO spablm_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Su división, y los que se contaron de ella, fueron cuarenta y seis mil quinientos. ");
INSERT INTO spablm_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","“Los que acampen junto a él serán la tribu de Simeón. El príncipe de los hijos de Simeón será Selumiel, hijo de Zurishaddai. ");
INSERT INTO spablm_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Su división, y los que fueron contados de ellos, fueron cincuenta y nueve mil trescientos. ");
INSERT INTO spablm_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","“La tribu de Gad: el príncipe de los hijos de Gad será Eliasaf, hijo de Reuel. ");
INSERT INTO spablm_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Su división, y los contados de ellos, fueron cuarenta y cinco mil seiscientos cincuenta. ");
INSERT INTO spablm_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","“Todos los contados del campamento de Rubén fueron ciento cincuenta y un mil cuatrocientos cincuenta, según sus ejércitos. Ellos partirán en segundo lugar. ");
INSERT INTO spablm_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","“Entonces saldrá la Tienda de la Reunión, con el campamento de los levitas en medio de los campamentos. Así como acampan, así saldrán, cada uno en su lugar, por sus estandartes. ");
INSERT INTO spablm_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","“En el lado occidental estará el estandarte del campamento de Efraín según sus divisiones. El príncipe de los hijos de Efraín será Elisama, hijo de Ammihud. ");
INSERT INTO spablm_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Su división, y los que fueron contados de ellos, fueron cuarenta mil quinientos. ");
INSERT INTO spablm_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","“Junto a él estará la tribu de Manasés. El príncipe de los hijos de Manasés será Gamaliel, hijo de Pedahzur. ");
INSERT INTO spablm_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Su división, y los que fueron contados de ellos, fueron treinta y dos mil doscientos. ");
INSERT INTO spablm_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","“La tribu de Benjamín: el príncipe de los hijos de Benjamín será Abidán, hijo de Gedeón. ");
INSERT INTO spablm_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Su ejército, y los contados de ellos, fueron treinta y cinco mil cuatrocientos. ");
INSERT INTO spablm_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","“Todos los contados del campamento de Efraín fueron ciento ocho mil cien, según sus divisiones. Ellos partirán en tercer lugar. ");
INSERT INTO spablm_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","“En el lado norte estará el estandarte del campamento de Dan según sus divisiones. El jefe de los hijos de Dan será Ahiezer hijo de Amisadái. ");
INSERT INTO spablm_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Su división, y los que fueron contados de ellos, fueron sesenta y dos mil setecientos. ");
INSERT INTO spablm_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","“Los que acampen junto a él serán la tribu de Aser. El príncipe de los hijos de Aser será Pagiel, hijo de Ocrán. ");
INSERT INTO spablm_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Su división, y los que fueron contados de ellos, fueron cuarenta y un mil quinientos. ");
INSERT INTO spablm_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","“La tribu de Neftalí: el príncipe de los hijos de Neftalí será Ahira, hijo de Enán. ");
INSERT INTO spablm_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Su división, y los que fueron contados de ellos, fueron cincuenta y tres mil cuatrocientos. ");
INSERT INTO spablm_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","“Todos los contados del campamento de Dan fueron ciento cincuenta y siete mil seiscientos. Saldrán los últimos por sus estandartes”. ");
INSERT INTO spablm_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Estos son los que fueron contados de los hijos de Israel por sus casas paternas. Todos los que fueron contados de los campamentos según sus ejércitos fueron seiscientos tres mil quinientos cincuenta. ");
INSERT INTO spablm_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Pero los levitas no fueron contados entre los hijos de Israel, tal como Yahvé ordenó a Moisés. ");
INSERT INTO spablm_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Así hicieron los hijos de Israel. Conforme a todo lo que el Señor ordenó a Moisés, acamparon por sus banderas, y así se pusieron en marcha, cada uno por su familia, según las casas de sus padres. ");
INSERT INTO spablm_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Esta es la historia de las generaciones de Aarón y Moisés en el día en que Yahvé habló con Moisés en el monte Sinaí. ");
INSERT INTO spablm_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Estos son los nombres de los hijos de Aarón: Nadab, el primogénito, y Abiú, Eleazar e Itamar. ");
INSERT INTO spablm_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Estos son los nombres de los hijos de Aarón, los sacerdotes que fueron ungidos, a quienes consagró para que ejercieran el ministerio sacerdotal. ");
INSERT INTO spablm_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Nadab y Abiú murieron ante Yahvé cuando ofrecieron fuego extraño ante Yahvé en el desierto de Sinaí, y no tuvieron hijos. Eleazar e Itamar ejercieron el ministerio sacerdotal en presencia de Aarón, su padre. ");
INSERT INTO spablm_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Haz que se acerque la tribu de Leví, y ponlos delante del sacerdote Aarón, para que le sirvan. ");
INSERT INTO spablm_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Ellos guardarán sus requerimientos, y los requerimientos de toda la congregación ante la Tienda de Reunión, para hacer el servicio del tabernáculo. ");
INSERT INTO spablm_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Guardarán todo el mobiliario de la Tienda de reunión y las obligaciones de los hijos de Israel, para hacer el servicio del tabernáculo. ");
INSERT INTO spablm_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Darás los levitas a Aarón y a sus hijos. Le serán entregados íntegramente en nombre de los hijos de Israel. ");
INSERT INTO spablm_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Designarás a Aarón y a sus hijos, y ellos conservarán su sacerdocio, pero el extranjero que se acerque será condenado a muerte.” ");
INSERT INTO spablm_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“He aquí que he tomado a los levitas de entre los hijos de Israel en lugar de todos los primogénitos que abren el vientre entre los hijos de Israel; y los levitas serán míos, ");
INSERT INTO spablm_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","porque todos los primogénitos son míos. El día en que derribé a todos los primogénitos en la tierra de Egipto, santifiqué para mí a todos los primogénitos de Israel, tanto hombres como animales. Serán míos. Yo soy Yahvé”. ");
INSERT INTO spablm_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Yahvé habló a Moisés en el desierto del Sinaí, diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Cuenta a los hijos de Leví por las casas de sus padres, por sus familias. Contarás a todos los varones de un mes en adelante”. ");
INSERT INTO spablm_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Moisés los contó según la palabra de Yahvé, como se le había ordenado. ");
INSERT INTO spablm_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Estos fueron los hijos de Leví por sus nombres: Gersón, Coat y Merari. ");
INSERT INTO spablm_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Estos son los nombres de los hijos de Gersón por sus familias Libni y Simei. ");
INSERT INTO spablm_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Los hijos de Coat por sus familias: Amram, Izhar, Hebrón y Uziel. ");
INSERT INTO spablm_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Los hijos de Merari por sus familias: Mahli y Mushi. Estas son las familias de los levitas según las casas de sus padres. ");
INSERT INTO spablm_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","De Gersón era la familia de los libnitas, y la familia de los simeítas. Estas son las familias de los gersonitas. ");
INSERT INTO spablm_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Los que fueron contados de ellos, según el número de todos los varones de un mes para arriba, fueron siete mil quinientos. ");
INSERT INTO spablm_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Las familias de los gersonitas acamparán detrás del tabernáculo hacia el oeste. ");
INSERT INTO spablm_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Eliasaf, hijo de Lael, será el príncipe de la casa paterna de los gersonitas. ");
INSERT INTO spablm_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","La tarea de los hijos de Gersón en la Tienda de reunión será el tabernáculo, la tienda, su cubierta, la cortina de la puerta de la Tienda de reunión, ");
INSERT INTO spablm_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","las cortinas del atrio, la cortina de la puerta del atrio que está junto al tabernáculo y alrededor del altar, y sus cuerdas para todo su servicio. ");
INSERT INTO spablm_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","De Coat era la familia de los amramitas, la familia de los izharitas, la familia de los hebronitas y la familia de los uzielitas. Estas son las familias de los coatitas. ");
INSERT INTO spablm_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Según el número de todos los varones de un mes en adelante, había ocho mil seiscientos que cumplían con los requisitos del santuario. ");
INSERT INTO spablm_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Las familias de los hijos de Coat acamparán al sur de la tienda. ");
INSERT INTO spablm_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","El príncipe de la casa paterna de las familias de Coat será Elizafán hijo de Uziel. ");
INSERT INTO spablm_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Su tarea será el arca, la mesa, el candelabro, los altares, los utensilios del santuario con los que se ministra, la cortina y todo su servicio. ");
INSERT INTO spablm_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Eleazar, hijo del sacerdote Aarón, será el príncipe de los príncipes de los levitas, con la supervisión de los que cumplen los requisitos del santuario. ");
INSERT INTO spablm_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","De Merari era la familia de los Musitas y la familia de los Mushitas. Estas son las familias de Merari. ");
INSERT INTO spablm_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Los contados de ellos, según el número de todos los varones de un mes para arriba, fueron seis mil doscientos. ");
INSERT INTO spablm_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","El príncipe de la casa paterna de las familias de Merari era Zuriel hijo de Abihail. Acamparán en el lado norte del tabernáculo. ");
INSERT INTO spablm_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","La tarea asignada a los hijos de Merari será las tablas del tabernáculo, sus barras, sus pilares, sus bases, todos sus instrumentos, todo su servicio, ");
INSERT INTO spablm_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","los pilares del atrio que lo rodea, sus bases, sus clavijas y sus cuerdas. ");
INSERT INTO spablm_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Los que acampen delante del tabernáculo hacia el oriente, frente a la Tienda de Reunión hacia la salida del sol, serán Moisés, con Aarón y sus hijos, guardando los requisitos del santuario para el deber de los hijos de Israel. El forastero que se acerque será condenado a muerte. ");
INSERT INTO spablm_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Todos los contados de los levitas, que Moisés y Aarón contaron por orden de Yahvé, por sus familias, todos los varones de un mes en adelante, fueron veintidós mil. ");
INSERT INTO spablm_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Yahvé dijo a Moisés: “Cuenta todos los primogénitos varones de los hijos de Israel de un mes en adelante, y toma la cuenta de sus nombres. ");
INSERT INTO spablm_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Tomarás a los levitas para mí — yo soy Yahvé — en lugar de todos los primogénitos entre los hijos de Israel; y el ganado de los levitas en lugar de todos los primogénitos entre el ganado de los hijos de Israel.” ");
INSERT INTO spablm_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Moisés contó, como le había ordenado Yahvé, todos los primogénitos de los hijos de Israel. ");
INSERT INTO spablm_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Todos los primogénitos varones, según el número de nombres, de un mes para arriba, de los que fueron contados, fueron veintidós mil doscientos setenta y tres. ");
INSERT INTO spablm_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Yahvé habló a Moisés diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Toma a los levitas en lugar de todos los primogénitos de los hijos de Israel, y el ganado de los levitas en lugar de su ganado; y los levitas serán míos. Yo soy Yahvé. ");
INSERT INTO spablm_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Para la redención de los doscientos setenta y tres primogénitos de los hijos de Israel que excedan el número de los levitas, ");
INSERT INTO spablm_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","tomarás cinco siclos por cada uno; según el siclo del santuario los tomarás (el siclo es de veinte gerahs); ");
INSERT INTO spablm_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","y darás el dinero, con el que se redime su resto, a Aarón y a sus hijos.” ");
INSERT INTO spablm_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Moisés tomó el dinero de la redención de los que excedían el número de los redimidos por los levitas; ");
INSERT INTO spablm_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","de los primogénitos de los hijos de Israel tomó el dinero, mil trescientos sesenta y cinco siclos, según el siclo del santuario; ");
INSERT INTO spablm_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","y Moisés dio el dinero de la redención a Aarón y a sus hijos, según la palabra de Yahvé, como Yahvé le ordenó a Moisés. ");
INSERT INTO spablm_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Yahvé habló a Moisés y a Aarón, diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Haz un censo de los hijos de Coat de entre los hijos de Leví, por sus familias, por las casas de sus padres, ");
INSERT INTO spablm_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","desde los treinta años en adelante hasta los cincuenta años, todos los que entren en el servicio para hacer el trabajo en la Tienda del Encuentro. ");
INSERT INTO spablm_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“Este es el servicio de los hijos de Coat en la Tienda del Encuentro, en lo que respecta a las cosas más sagradas. ");
INSERT INTO spablm_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Cuando el campamento avance, Aarón entrará con sus hijos; y ellos quitarán el velo de la cortina, cubrirán con él el Arca del Testimonio, ");
INSERT INTO spablm_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","le pondrán una cubierta de piel de tejones, extenderán sobre ella un paño azul y colocarán sus varas. ");
INSERT INTO spablm_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“Sobre la mesa del pan de la función extenderán un paño azul, y pondrán sobre él los platos, las cucharas, los tazones y las copas con las que se sirve; y sobre él estará el pan continuo. ");
INSERT INTO spablm_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Extenderán sobre ella un paño de color escarlata y la cubrirán con un revestimiento de piel de tejón, y pondrán sus varas. ");
INSERT INTO spablm_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“Tomarán un paño azul y cubrirán el candelabro de la lámpara, sus lámparas, sus apagadores, sus tabaqueras y todos sus recipientes de aceite, con los que la atienden. ");
INSERT INTO spablm_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","La pondrán, junto con todos sus recipientes, dentro de una cubierta de piel de tejón, y la pondrán sobre el armazón. ");
INSERT INTO spablm_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“Sobre el altar de oro extenderán un paño azul y lo cubrirán con una cubierta de piel de tejón, y pondrán sus varas. ");
INSERT INTO spablm_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“Tomarán todos los utensilios del ministerio con los que ministran en el santuario, los pondrán en un paño azul, los cubrirán con una funda de piel de tejón y los pondrán sobre el bastidor. ");
INSERT INTO spablm_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“Quitarán la ceniza del altar y extenderán sobre él un paño de color púrpura. ");
INSERT INTO spablm_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Pondrán sobre él todos los utensilios con los que ministran a su alrededor, las sartenes para el fuego, los ganchos para la carne, las palas y las palanganas, todos los utensilios del altar; y extenderán sobre él una cubierta de piel de tejón, y pondrán sus varas. ");
INSERT INTO spablm_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“Cuando Aarón y sus hijos hayan terminado de cubrir el santuario y todos los muebles del santuario, mientras el campamento avanza; después de eso, los hijos de Coat vendrán a llevarlo; pero no tocarán el santuario, para no morir. Los hijos de Coat llevarán estas cosas que pertenecen a la Tienda de reunión. ");
INSERT INTO spablm_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“La tarea del sacerdote Eleazar, hijo de Aarón, será el aceite para la luz, el incienso aromático, la ofrenda continua y el aceite para la unción, los requisitos de todo el tabernáculo y de todo lo que hay en él, el santuario y su mobiliario.” ");
INSERT INTO spablm_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Yahvé habló a Moisés y a Aarón, diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“No eliminen a la tribu de las familias de los coatitas de entre los levitas; ");
INSERT INTO spablm_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","sino que hagan esto con ellos, para que vivan y no mueran cuando se acerquen a las cosas más santas: Aarón y sus hijos entrarán y asignarán a cada uno su servicio y su carga; ");
INSERT INTO spablm_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","pero no entrarán a ver el santuario ni siquiera por un momento, para que no mueran.” ");
INSERT INTO spablm_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Yahvé habló a Moisés diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Haz un censo también de los hijos de Gersón, por las casas de sus padres, por sus familias; ");
INSERT INTO spablm_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","los contarás desde los treinta años en adelante hasta los cincuenta años: todos los que entran a servir, a hacer el trabajo en la Tienda del Encuentro. ");
INSERT INTO spablm_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“Este es el servicio de las familias de los gersonitas, para servir y llevar cargas: ");
INSERT INTO spablm_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","llevarán las cortinas del tabernáculo y de la Tienda de reunión, su cubierta, la cubierta de piel de sello que está sobre ella, la cortina de la puerta de la Tienda de reunión, ");
INSERT INTO spablm_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","las cortinas del atrio, la cortina de la puerta del atrio que está junto al tabernáculo y alrededor del altar, sus cuerdas y todos los instrumentos de su servicio, y todo lo que se haga con ellos. Ellos servirán allí. ");
INSERT INTO spablm_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","A las órdenes de Aarón y de sus hijos estará todo el servicio de los hijos de los gersonitas, en toda su carga y en todo su servicio; y les asignarás su deber en todas sus responsabilidades. ");
INSERT INTO spablm_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Este es el servicio de las familias de los hijos de los gersonitas en la Tienda de Reunión. Su deber estará bajo la mano de Itamar, hijo del sacerdote Aarón. ");
INSERT INTO spablm_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“En cuanto a los hijos de Merari, los contarás por sus familias, por las casas de sus padres; ");
INSERT INTO spablm_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","los contarás desde los treinta años y hasta los cincuenta, todos los que entren en el servicio, para hacer la obra de la Tienda de reunión. ");
INSERT INTO spablm_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Esta es la tarea de su carga, según todo su servicio en la Tienda de reunión: las tablas del tabernáculo, sus barras, sus pilares, sus bases, ");
INSERT INTO spablm_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","los pilares del atrio que lo rodea, sus bases, sus clavijas, sus cuerdas, con todos sus instrumentos y con todo su servicio. Les asignarás los instrumentos del servicio de su carga por su nombre. ");
INSERT INTO spablm_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Este es el servicio de las familias de los hijos de Merari, según todo su servicio en la Tienda de reunión, bajo la mano de Itamar hijo del sacerdote Aarón.” ");
INSERT INTO spablm_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Moisés y Aarón y los príncipes de la congregación contaron a los hijos de los coatitas por sus familias y por las casas de sus padres, ");
INSERT INTO spablm_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","desde los treinta años y hasta los cincuenta, a todos los que entraban en el servicio para trabajar en la Tienda del Encuentro. ");
INSERT INTO spablm_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Los contados de ellos por sus familias fueron dos mil setecientos cincuenta. ");
INSERT INTO spablm_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Estos son los que fueron contados de las familias de los coatitas, todos los que servían en la Tienda del Encuentro, los cuales fueron contados por Moisés y Aarón según el mandato de Yahvé por medio de Moisés. ");
INSERT INTO spablm_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Los que fueron contados de los hijos de Gersón, por sus familias y por las casas de sus padres, ");
INSERT INTO spablm_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","desde los treinta años de edad hasta los cincuenta, todos los que entraron en el servicio para trabajar en la Tienda del Encuentro, ");
INSERT INTO spablm_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","los que fueron contados de ellos, por sus familias y por las casas de sus padres, fueron dos mil seiscientos treinta. ");
INSERT INTO spablm_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Estos son los que fueron contados de las familias de los hijos de Gersón, todos los que servían en la Tienda del Encuentro, los cuales fueron contados por Moisés y Aarón según el mandamiento de Yahvé. ");
INSERT INTO spablm_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Los que fueron contados de las familias de los hijos de Merari, por sus familias, por las casas de sus padres, ");
INSERT INTO spablm_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","de treinta años en adelante hasta los cincuenta años, todos los que entraron en el servicio para trabajar en la Tienda de Reunión, ");
INSERT INTO spablm_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","hasta los que fueron contados de ellos por sus familias, fueron tres mil doscientos. ");
INSERT INTO spablm_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Estos son los que fueron contados de las familias de los hijos de Merari, que Moisés y Aarón contaron según el mandato de Yahvé por medio de Moisés. ");
INSERT INTO spablm_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Todos los contados de los levitas que Moisés y Aarón y los príncipes de Israel contaron, por sus familias y por las casas de sus padres, ");
INSERT INTO spablm_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","de treinta años en adelante hasta los cincuenta, todos los que entraron a hacer el trabajo de servicio y el trabajo de llevar cargas en la Tienda del Encuentro, ");
INSERT INTO spablm_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","los contados de ellos, fueron ocho mil quinientos ochenta. ");
INSERT INTO spablm_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Según el mandato de Yahvé fueron contados por Moisés, cada uno según su servicio y según su cargo. Así fueron contados por él, como Yahvé le ordenó a Moisés. ");
INSERT INTO spablm_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Ordena a los hijos de Israel que saquen del campamento a todo leproso, a todo el que tenga flujo y a todo el que esté impuro por un cadáver. ");
INSERT INTO spablm_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Pondrán fuera del campamento tanto a los hombres como a las mujeres, para que no contaminen su campamento, en medio del cual yo habito”. ");
INSERT INTO spablm_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Los hijos de Israel lo hicieron, y los pusieron fuera del campamento; como Yahvé habló a Moisés, así lo hicieron los hijos de Israel. ");
INSERT INTO spablm_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Habla a los hijos de Israel: ‘Cuando un hombre o una mujer cometa cualquier pecado de los que cometen los hombres, de modo que transgreda a Yahvé, y esa alma sea culpable, ");
INSERT INTO spablm_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","entonces confesará su pecado que ha cometido; y hará la restitución de su culpa en su totalidad, añadiendo a ella la quinta parte de la misma, y se la dará a aquel respecto del cual ha sido culpable. ");
INSERT INTO spablm_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Pero si el hombre no tiene pariente a quien hacer la restitución por la culpa, la restitución por la culpa que se haga a Yahvé será del sacerdote, además del carnero de la expiación, con el cual se hará la expiación por él. ");
INSERT INTO spablm_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Toda ofrenda de todas las cosas santas de los hijos de Israel, que presenten al sacerdote, será suya. ");
INSERT INTO spablm_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Las cosas santas de cada uno serán suyas; todo lo que cualquiera dé al sacerdote, será suyo”. ");
INSERT INTO spablm_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Yahvé habló a Moisés diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Habla a los hijos de Israel y diles: ‘Si la mujer de un hombre se extravía y le es infiel, ");
INSERT INTO spablm_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","y un hombre se acuesta con ella carnalmente, y se oculta a los ojos de su marido y esto se mantiene oculto, y ella se mancha, no hay testigo contra ella, y no es tomada en el acto; ");
INSERT INTO spablm_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","y el espíritu de celos se apodera de él, y tiene celos de su mujer y ella está contaminada; o si el espíritu de celos se apodera de él, y tiene celos de su mujer y ella no está contaminada; ");
INSERT INTO spablm_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","entonces el hombre traerá a su mujer al sacerdote, y traerá su ofrenda por ella: una décima parte de un efa de harina de cebada. No derramará aceite ni pondrá incienso sobre ella, porque es una ofrenda de celos, una ofrenda de memoria, que trae la iniquidad a la memoria. ");
INSERT INTO spablm_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","El sacerdote la acercará y la pondrá delante de Yahvé. ");
INSERT INTO spablm_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","El sacerdote tomará agua bendita en una vasija de barro; y el sacerdote tomará un poco del polvo que está en el piso del tabernáculo y lo pondrá en el agua. ");
INSERT INTO spablm_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","El sacerdote pondrá a la mujer delante de Yahvé, y dejará suelto el cabello de la cabeza de la mujer, y pondrá en sus manos la ofrenda de comida conmemorativa, que es la ofrenda de celos. El sacerdote tendrá en su mano el agua de la amargura que trae la maldición. ");
INSERT INTO spablm_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","El sacerdote le hará prestar juramento y le dirá a la mujer: “Si ningún hombre se ha acostado contigo y si no te has desviado a la impureza, estando bajo la autoridad de tu marido, libérate de esta agua de amargura que trae maldición. ");
INSERT INTO spablm_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Pero si te has desviado, estando bajo la autoridad de tu marido, y si estás impura, y algún hombre se ha acostado contigo además de tu marido —” ");
INSERT INTO spablm_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","entonces el sacerdote hará que la mujer jure con el juramento de maldición, y el sacerdote le dirá a la mujer: “Que Yahvé te haga una maldición y un juramento entre tu pueblo, cuando Yahvé permita que tu muslo se desprenda y tu cuerpo se hinche; ");
INSERT INTO spablm_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","y esta agua que trae una maldición entrará en tus entrañas y hará que tu cuerpo se hinche y tu muslo se desprenda.” La mujer dirá: “Amén, Amén”. ");
INSERT INTO spablm_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“‘El sacerdote escribirá estas maldiciones en un libro, y las limpiará en el agua de la amargura. ");
INSERT INTO spablm_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Hará que la mujer beba el agua de la amargura que causa la maldición; y el agua que causa la maldición entrará en ella y se volverá amarga. ");
INSERT INTO spablm_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","El sacerdote tomará la ofrenda de celos de la mano de la mujer, agitará la ofrenda delante de Yahvé y la llevará al altar. ");
INSERT INTO spablm_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","El sacerdote tomará un puñado de la ofrenda de comida, como su porción conmemorativa, y la quemará en el altar, y después hará que la mujer beba el agua. ");
INSERT INTO spablm_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Cuando le haya hecho beber el agua, sucederá que si ella está contaminada y ha cometido una transgresión contra su marido, el agua que causa la maldición entrará en ella y se volverá amarga, y su cuerpo se hinchará, y su muslo se caerá; y la mujer será una maldición entre su pueblo. ");
INSERT INTO spablm_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Si la mujer no está contaminada, sino que está limpia, entonces será libre y concebirá descendencia. ");
INSERT INTO spablm_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“‘Esta es la ley de los celos, cuando la mujer, estando bajo su marido, se extravía y se contamina, ");
INSERT INTO spablm_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","o cuando el espíritu de los celos se apodera de un hombre, y éste tiene celos de su mujer; entonces pondrá a la mujer delante de Yahvé, y el sacerdote ejecutará sobre ella toda esta ley. ");
INSERT INTO spablm_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","El hombre quedará libre de iniquidad, y la mujer cargará con su iniquidad.’” ");
INSERT INTO spablm_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Habla a los hijos de Israel y diles: ‘Cuando un hombre o una mujer haga un voto especial, el voto de nazareo, para consagrarse a Yahvé, ");
INSERT INTO spablm_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","se separará del vino y de la bebida fuerte. No beberá vinagre de vino, ni vinagre de bebida fermentada, ni beberá jugo de uva, ni comerá uvas frescas o secas. ");
INSERT INTO spablm_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Durante todos los días de su consagración, no comerá nada que esté hecho de la vid, desde las semillas hasta los hollejos. ");
INSERT INTO spablm_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“‘Durante todos los días de su voto de separación, ninguna navaja se acercará a su cabeza, hasta que se cumplan los días en que se separa de Yahvé. Será santo. Dejará crecer los mechones de su cabeza. ");
INSERT INTO spablm_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","“‘Todos los días que se consagre de Yahvé no se acercará a un cadáver. ");
INSERT INTO spablm_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","No se contaminará por su padre, ni por su madre, ni por su hermano, ni por su hermana, cuando mueran, porque su separación a Dios está sobre su cabeza. ");
INSERT INTO spablm_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Todos los días de su consagración es santo para Yahvé. ");
INSERT INTO spablm_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“‘Si alguno muere muy repentinamente junto a él, y contamina la cabeza de su consagración, entonces se afeitará la cabeza en el día de su purificación. Al séptimo día se la afeitará. ");
INSERT INTO spablm_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Al octavo día traerá dos tórtolas o dos pichones al sacerdote, a la puerta de la Tienda de reunión. ");
INSERT INTO spablm_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","El sacerdote ofrecerá uno como ofrenda por el pecado y el otro como holocausto, y hará expiación por él, porque pecó por causa de la muerte, y santificará su cabeza ese mismo día. ");
INSERT INTO spablm_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Separará para Yahvé los días de su consagración, y traerá un cordero macho de un año como ofrenda por la culpa; pero los días anteriores serán anulados, porque su consagración fue contaminada. ");
INSERT INTO spablm_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“‘Esta es la ley del nazireo: cuando se cumplan los días de su separación, será llevado a la puerta de la Tienda del Encuentro, ");
INSERT INTO spablm_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","y ofrecerá su ofrenda a Yahvé: un cordero macho de un año sin defecto para el holocausto, una oveja de un año sin defecto para la ofrenda por el pecado, un carnero sin defecto para las ofrendas de paz, ");
INSERT INTO spablm_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","una cesta de panes sin levadura, tortas de harina fina mezcladas con aceite, y obleas sin levadura untadas con aceite con su ofrenda y sus libaciones. ");
INSERT INTO spablm_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","El sacerdote los presentará ante Yahvé, y ofrecerá su ofrenda por el pecado y su holocausto. ");
INSERT INTO spablm_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Ofrecerá el carnero como sacrificio de paz a Yahvé, con el cesto de los panes sin levadura. El sacerdote ofrecerá también su ofrenda y su libación. ");
INSERT INTO spablm_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","El nazareo se afeitará la cabeza de su consagración a la puerta de la Tienda del Encuentro, tomará el pelo de la cabeza de su separación y lo pondrá sobre el fuego que está debajo del sacrificio de paz. ");
INSERT INTO spablm_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","El sacerdote tomará la espaldilla cocida del carnero, una torta sin levadura del canasto y una oblea sin levadura, y las pondrá sobre las manos del nazareo después de que haya afeitado la cabeza de su consagración; ");
INSERT INTO spablm_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","y el sacerdote las agitará como ofrenda mecida ante Yahvé. Son sagrados para el sacerdote, junto con el pecho que se agita y el muslo que se ofrece. Después, el nazareo podrá beber vino. ");
INSERT INTO spablm_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“‘Esta es la ley del nazareo que hace voto y de su ofrenda a Yahvé por su consagración, además de lo que pueda pagar. Según su voto que hace, así debe hacer según la ley de su consagración’”. ");
INSERT INTO spablm_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Yahvé habló a Moisés diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Habla a Aarón y a sus hijos, diciendo: ‘Así bendecirás a los hijos de Israel’. Les dirás, ");
INSERT INTO spablm_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‘Que el Señor te bendiga y te guarde. ");
INSERT INTO spablm_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Yahvé hace brillar su rostro sobre ti, y ser amable contigo. ");
INSERT INTO spablm_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Yahvé levanta su rostro hacia ti, y te dará la paz”. ");
INSERT INTO spablm_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“Así pondrán mi nombre sobre los hijos de Israel, y los bendeciré”. ");
INSERT INTO spablm_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","El día en que Moisés terminó de levantar el tabernáculo, lo ungió y lo santificó con todo su mobiliario, y el altar con todos sus utensilios, y los ungió y santificó; ");
INSERT INTO spablm_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","los príncipes de Israel, los jefes de las casas de sus padres, dieron ofrendas. Estos eran los príncipes de las tribus. Estos son los que estaban sobre los contados; ");
INSERT INTO spablm_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","y trajeron su ofrenda ante Yahvé, seis carros cubiertos y doce bueyes; un carro por cada dos de los príncipes, y por cada uno un buey. Los presentaron ante el tabernáculo. ");
INSERT INTO spablm_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Acéptalos de ellos, para que sean utilizados en el servicio de la Tienda de Reunión; y los darás a los levitas, a cada uno según su servicio.” ");
INSERT INTO spablm_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Moisés tomó los carros y los bueyes y los entregó a los levitas. ");
INSERT INTO spablm_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Dio dos carros y cuatro bueyes a los hijos de Gersón, según su servicio. ");
INSERT INTO spablm_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","A los hijos de Merari les dio cuatro carros y ocho bueyes, según su servicio, bajo la dirección de Itamar, hijo del sacerdote Aarón. ");
INSERT INTO spablm_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Pero a los hijos de Coat no les dio ninguno, porque el servicio del santuario les correspondía a ellos; lo llevaban sobre sus hombros. ");
INSERT INTO spablm_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Los príncipes dieron ofrendas para la dedicación del altar el día en que fue ungido. Los príncipes dieron sus ofrendas ante el altar. ");
INSERT INTO spablm_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Yahvé dijo a Moisés: “Ofrecerán su ofrenda, cada príncipe en su día, para la dedicación del altar”. ");
INSERT INTO spablm_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","El que ofreció su ofrenda el primer día fue Naasón hijo de Aminadab, de la tribu de Judá, ");
INSERT INTO spablm_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","y su ofrenda fue: una bandeja de plata, cuyo peso era de ciento treinta siclos, un cuenco de plata de setenta siclos, según el siclo del santuario, ambos llenos de harina fina mezclada con aceite para una ofrenda de harina; ");
INSERT INTO spablm_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","un cazo de oro de diez siclos, lleno de incienso; ");
INSERT INTO spablm_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","un becerro joven, un carnero, un cordero macho de un año, para el holocausto; ");
INSERT INTO spablm_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","un macho cabrío como ofrenda por el pecado; ");
INSERT INTO spablm_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","y para el sacrificio de las ofrendas de paz, dos cabezas de ganado, cinco carneros, cinco machos cabríos y cinco corderos de un año. Esta fue la ofrenda de Naasón, hijo de Aminadab. ");
INSERT INTO spablm_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","El segundo día, Netanel hijo de Zuar, príncipe de Isacar, presentó su ofrenda. ");
INSERT INTO spablm_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Ofreció por su ofrenda: una bandeja de plata, cuyo peso era de ciento treinta siclos, un cuenco de plata de setenta siclos, según el siclo del santuario, ambos llenos de harina fina mezclada con aceite para una ofrenda de harina; ");
INSERT INTO spablm_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","un cazo de oro de diez siclos, lleno de incienso; ");
INSERT INTO spablm_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","un becerro joven, un carnero, un cordero macho de un año, para el holocausto; ");
INSERT INTO spablm_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","un macho cabrío como ofrenda por el pecado; ");
INSERT INTO spablm_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","y para el sacrificio de las ofrendas de paz, dos cabezas de ganado, cinco carneros, cinco machos cabríos, cinco corderos de un año. Esta fue la ofrenda de Natanel, hijo de Zuar. ");
INSERT INTO spablm_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Al tercer día Eliab hijo de Helón, príncipe de los hijos de Zabulón, ");
INSERT INTO spablm_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","dio su ofrenda: una bandeja de plata, cuyo peso era de ciento treinta siclos, un cuenco de plata de setenta siclos, según el siclo del santuario, ambos llenos de harina fina mezclada con aceite para una ofrenda de harina; ");
INSERT INTO spablm_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","un cazo de oro de diez siclos, lleno de incienso; ");
INSERT INTO spablm_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","un becerro joven, un carnero, un cordero macho de un año, para el holocausto; ");
INSERT INTO spablm_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","un macho cabrío como ofrenda por el pecado; ");
INSERT INTO spablm_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","y para el sacrificio de las ofrendas de paz, dos cabezas de ganado, cinco carneros, cinco machos cabríos y cinco corderos de un año. Esta fue la ofrenda de Eliab, hijo de Helón. ");
INSERT INTO spablm_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","El cuarto día Elizur, hijo de Sedeur, príncipe de los hijos de Rubén, ");
INSERT INTO spablm_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","dio su ofrenda: una bandeja de plata, cuyo peso era de ciento treinta siclos, un cuenco de plata de setenta siclos, según el siclo del santuario, ambos llenos de harina fina mezclada con aceite para una ofrenda de harina; ");
INSERT INTO spablm_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","un cazo de oro de diez siclos, lleno de incienso; ");
INSERT INTO spablm_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","un becerro joven, un carnero, un cordero macho de un año, para el holocausto; ");
INSERT INTO spablm_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","un macho cabrío como ofrenda por el pecado; ");
INSERT INTO spablm_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","y para el sacrificio de las ofrendas de paz, dos cabezas de ganado, cinco carneros, cinco machos cabríos y cinco corderos de un año. Esta fue la ofrenda de Elizur, hijo de Sedeur. ");
INSERT INTO spablm_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","El quinto día, Selumiel, hijo de Zurishaddai, príncipe de los hijos de Simeón, ");
INSERT INTO spablm_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","dio su ofrenda: una bandeja de plata, cuyo peso era de ciento treinta siclos, un cuenco de plata de setenta siclos, según el siclo del santuario, ambos llenos de harina fina mezclada con aceite para una ofrenda de harina; ");
INSERT INTO spablm_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","un cazo de oro de diez siclos, lleno de incienso; ");
INSERT INTO spablm_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","un becerro joven, un carnero, un cordero macho de un año, para el holocausto; ");
INSERT INTO spablm_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","un macho cabrío como ofrenda por el pecado; ");
INSERT INTO spablm_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","y para el sacrificio de las ofrendas de paz, dos cabezas de ganado, cinco carneros, cinco machos cabríos y cinco corderos de un año: esta fue la ofrenda de Selumiel, hijo de Zurishaddai. ");
INSERT INTO spablm_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Al sexto día, Eliasaf hijo de Deuel, príncipe de los hijos de Gad, ");
INSERT INTO spablm_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","dio su ofrenda: una bandeja de plata, cuyo peso era de ciento treinta siclos, un cuenco de plata de setenta siclos, según el siclo del santuario, ambos llenos de harina fina mezclada con aceite para una ofrenda de harina; ");
INSERT INTO spablm_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","un cazo de oro de diez siclos, lleno de incienso; ");
INSERT INTO spablm_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","un becerro joven, un carnero, un cordero macho de un año, para el holocausto; ");
INSERT INTO spablm_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","un macho cabrío como ofrenda por el pecado; ");
INSERT INTO spablm_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","y para el sacrificio de las ofrendas de paz, dos cabezas de ganado, cinco carneros, cinco machos cabríos y cinco corderos de un año. Esta fue la ofrenda de Eliasaf, hijo de Deuel. ");
INSERT INTO spablm_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","El séptimo día Elishama, hijo de Ammihud, príncipe de los hijos de Efraín, ");
INSERT INTO spablm_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","dio su ofrenda: una bandeja de plata, cuyo peso era de ciento treinta siclos, un cuenco de plata de setenta siclos, según el siclo del santuario, ambos llenos de harina fina mezclada con aceite para una ofrenda de harina; ");
INSERT INTO spablm_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","un cazo de oro de diez siclos, lleno de incienso; ");
INSERT INTO spablm_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","un becerro joven, un carnero, un cordero macho de un año, para el holocausto; ");
INSERT INTO spablm_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","un macho cabrío como ofrenda por el pecado; ");
INSERT INTO spablm_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","y para el sacrificio de las ofrendas de paz, dos cabezas de ganado, cinco carneros, cinco machos cabríos y cinco corderos de un año. Esta fue la ofrenda de Elisama, hijo de Amiud. ");
INSERT INTO spablm_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","El octavo día Gamaliel, hijo de Pedasur, príncipe de los hijos de Manasés, ");
INSERT INTO spablm_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","dio su ofrenda: una bandeja de plata, cuyo peso era de ciento treinta siclos, un cuenco de plata de setenta siclos, según el siclo del santuario, ambos llenos de harina fina mezclada con aceite para una ofrenda de harina; ");
INSERT INTO spablm_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","un cazo de oro de diez siclos, lleno de incienso; ");
INSERT INTO spablm_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","un becerro joven, un carnero, un cordero macho de un año, para el holocausto; ");
INSERT INTO spablm_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","un macho cabrío como ofrenda por el pecado; ");
INSERT INTO spablm_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","y para el sacrificio de las ofrendas de paz, dos cabezas de ganado, cinco carneros, cinco machos cabríos y cinco corderos de un año. Esta fue la ofrenda de Gamaliel, hijo de Pedasur. ");
INSERT INTO spablm_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","El noveno día Abidán hijo de Gedeón, príncipe de los hijos de Benjamín, ");
INSERT INTO spablm_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","dio su ofrenda: una bandeja de plata, cuyo peso era de ciento treinta siclos, un cuenco de plata de setenta siclos, según el siclo del santuario, ambos llenos de harina fina mezclada con aceite para una ofrenda de harina; ");
INSERT INTO spablm_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","un cazo de oro de diez siclos, lleno de incienso; ");
INSERT INTO spablm_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","un becerro joven, un carnero, un cordero macho de un año, para el holocausto; ");
INSERT INTO spablm_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","un macho cabrío como ofrenda por el pecado; ");
INSERT INTO spablm_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","y para el sacrificio de las ofrendas de paz, dos cabezas de ganado, cinco carneros, cinco machos cabríos y cinco corderos de un año. Esta fue la ofrenda de Abidán, hijo de Gedeón. ");
INSERT INTO spablm_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","El décimo día Ahiezer hijo de Amisadai, príncipe de los hijos de Dan, ");
INSERT INTO spablm_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","dio su ofrenda: una bandeja de plata, cuyo peso era de ciento treinta siclos, un cuenco de plata de setenta siclos, según el siclo del santuario, ambos llenos de harina fina mezclada con aceite para una ofrenda de harina; ");
INSERT INTO spablm_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","un cazo de oro de diez siclos, lleno de incienso; ");
INSERT INTO spablm_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","un becerro joven, un carnero, un cordero macho de un año, para el holocausto; ");
INSERT INTO spablm_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","un macho cabrío como ofrenda por el pecado; ");
INSERT INTO spablm_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","y para el sacrificio de las ofrendas de paz, dos cabezas de ganado, cinco carneros, cinco machos cabríos y cinco corderos de un año. Esta fue la ofrenda de Ahiezer hijo de Amisadai. ");
INSERT INTO spablm_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","El undécimo día Pagiel, hijo de Ocrán, príncipe de los hijos de Aser, ");
INSERT INTO spablm_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","dio su ofrenda: una bandeja de plata, cuyo peso era de ciento treinta siclos, un cuenco de plata de setenta siclos, según el siclo del santuario, ambos llenos de harina fina mezclada con aceite para una ofrenda de harina; ");
INSERT INTO spablm_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","un cazo de oro de diez siclos, lleno de incienso; ");
INSERT INTO spablm_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","un becerro joven, un carnero, un cordero macho de un año, para el holocausto; ");
INSERT INTO spablm_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","un macho cabrío como ofrenda por el pecado; ");
INSERT INTO spablm_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","y para el sacrificio de las ofrendas de paz, dos cabezas de ganado, cinco carneros, cinco machos cabríos y cinco corderos de un año. Esta fue la ofrenda de Pagiel, hijo de Ocrán. ");
INSERT INTO spablm_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","El duodécimo día Ahira, hijo de Enán, príncipe de los hijos de Neftalí, ");
INSERT INTO spablm_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","dio su ofrenda: una bandeja de plata, cuyo peso era de ciento treinta siclos, un cuenco de plata de setenta siclos, según el siclo del santuario, ambos llenos de harina fina mezclada con aceite para una ofrenda de harina; ");
INSERT INTO spablm_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","un cazo de oro de diez siclos, lleno de incienso; ");
INSERT INTO spablm_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","un becerro joven, un carnero, un cordero macho de un año, para el holocausto; ");
INSERT INTO spablm_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","un macho cabrío como ofrenda por el pecado; ");
INSERT INTO spablm_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","y para el sacrificio de las ofrendas de paz, dos cabezas de ganado, cinco carneros, cinco machos cabríos y cinco corderos de un año. Esta fue la ofrenda de Ahira, hijo de Enán. ");
INSERT INTO spablm_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Esta fue la ofrenda de dedicación del altar, el día en que fue ungido, por los príncipes de Israel: doce fuentes de plata, doce tazones de plata, doce cucharones de oro; ");
INSERT INTO spablm_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","cada fuente de plata pesaba ciento treinta siclos, y cada tazón setenta; toda la plata de los utensilios dos mil cuatrocientos siclos, según el siclo del santuario; ");
INSERT INTO spablm_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","los doce cucharones de oro, llenos de incienso, pesaban diez siclos cada uno, según el siclo del santuario; todo el oro de los cucharones pesaba ciento veinte siclos; ");
INSERT INTO spablm_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","todo el ganado para el holocausto, doce becerros, los carneros doce, los corderos machos de un año doce, y su ofrenda de comida; y doce machos cabríos para la ofrenda por el pecado; ");
INSERT INTO spablm_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","y todo el ganado para el sacrificio de las ofrendas de paz: veinticuatro becerros, sesenta carneros, sesenta machos cabríos y sesenta corderos de un año. Esta fue la ofrenda de dedicación del altar, después de ser ungido. ");
INSERT INTO spablm_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Cuando Moisés entró en la Tienda del Encuentro para hablar con Yahvé, oyó su voz que le hablaba desde lo alto del propiciatorio que estaba sobre el arca del Testimonio, desde entre los dos querubines; y le habló. ");
INSERT INTO spablm_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Yahvé habló a Moisés diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Habla a Aarón y dile: “Cuando enciendas las lámparas, las siete lámparas alumbrarán delante del candelabro””. ");
INSERT INTO spablm_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Aarón lo hizo. Encendió sus lámparas para iluminar el área frente al candelabro, como Yahvé le ordenó a Moisés. ");
INSERT INTO spablm_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Esta era la hechura del candelabro, obra de oro batido. Desde su base hasta sus flores, era de oro batido. Hizo el candelabro según el modelo que el Señor le había mostrado a Moisés. ");
INSERT INTO spablm_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Yahvé habló a Moisés diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Toma a los levitas de entre los hijos de Israel y purifícalos. ");
INSERT INTO spablm_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Harás lo siguiente para purificarlos: rocía sobre ellos el agua de la purificación, deja que se afeiten todo el cuerpo con una navaja de afeitar, que laven sus ropas y se purifiquen. ");
INSERT INTO spablm_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Luego tomarán un novillo y su ofrenda de harina fina mezclada con aceite; y otro novillo lo tomarás como ofrenda por el pecado. ");
INSERT INTO spablm_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Presentarás a los levitas ante la Tienda de reunión. Reunirás a toda la congregación de los hijos de Israel. ");
INSERT INTO spablm_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Presentarás a los levitas ante el Señor. Los hijos de Israel pondrán sus manos sobre los levitas, ");
INSERT INTO spablm_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","y Aarón ofrecerá a los levitas ante Yahvé como ofrenda mecida en nombre de los hijos de Israel, para que sea de ellos el servicio de Yahvé. ");
INSERT INTO spablm_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“Los levitas pondrán sus manos sobre las cabezas de los toros, y ofreceréis uno como ofrenda por el pecado y el otro como holocausto a Yahvé, para hacer expiación por los levitas. ");
INSERT INTO spablm_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Pondrás a los levitas delante de Aarón y de sus hijos, y los ofrecerás como ofrenda mecida a Yahvé. ");
INSERT INTO spablm_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Así separarás a los levitas de entre los hijos de Israel, y los levitas serán míos. ");
INSERT INTO spablm_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“Después, los levitas entrarán a hacer el servicio de la Tienda de reunión. Los purificarás y los ofrecerás como ofrenda mecida. ");
INSERT INTO spablm_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Porque me son enteramente dados de entre los hijos de Israel; en lugar de todos los que abren el vientre, los primogénitos de todos los hijos de Israel, los he tomado para mí. ");
INSERT INTO spablm_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Porque todos los primogénitos de los hijos de Israel son míos, tanto los hombres como los animales. El día en que herí a todos los primogénitos en la tierra de Egipto, los sancioné para mí. ");
INSERT INTO spablm_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","He tomado a los levitas en lugar de todos los primogénitos de los hijos de Israel. ");
INSERT INTO spablm_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","He dado a los levitas como regalo a Aarón y a sus hijos de entre los hijos de Israel, para que hagan el servicio de los hijos de Israel en la Tienda del Encuentro, y para que hagan la expiación por los hijos de Israel, a fin de que no haya plaga entre los hijos de Israel cuando éstos se acerquen al santuario.” ");
INSERT INTO spablm_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Moisés, y Aarón, y toda la congregación de los hijos de Israel hicieron así con los levitas. Conforme a todo lo que Yahvé mandó a Moisés acerca de los levitas, así lo hicieron los hijos de Israel con ellos. ");
INSERT INTO spablm_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Los levitas se purificaron del pecado y lavaron sus ropas; y Aarón los ofreció como ofrenda mecida ante Yahvé, y Aarón hizo expiación por ellos para purificarlos. ");
INSERT INTO spablm_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Después de eso, los levitas entraron a hacer su servicio en la Tienda del Encuentro, delante de Aarón y de sus hijos; como Yahvé había ordenado a Moisés acerca de los levitas, así hicieron con ellos. ");
INSERT INTO spablm_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Esto es lo que se asigna a los levitas: de veinticinco años en adelante entrarán a atender el servicio en la obra de la Tienda de Reunión; ");
INSERT INTO spablm_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","y a partir de los cincuenta años se retirarán de hacer la obra, y no servirán más, ");
INSERT INTO spablm_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","sino que asistirán a sus hermanos en la Tienda de Reunión, para cumplir con el deber, y no harán ningún servicio. Así harás que los levitas cumplan con sus deberes”. ");
INSERT INTO spablm_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Yahvé habló a Moisés en el desierto del Sinaí, en el primer mes del segundo año después de que salieron de la tierra de Egipto, diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Que los hijos de Israel celebren la Pascua en su tiempo señalado. ");
INSERT INTO spablm_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","El día catorce de este mes, al atardecer, la celebraréis a su tiempo. La celebraréis según todos sus estatutos y según todas sus ordenanzas”. ");
INSERT INTO spablm_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Moisés dijo a los hijos de Israel que debían celebrar la Pascua. ");
INSERT INTO spablm_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Celebraron la Pascua en el primer mes, el día catorce del mes por la tarde, en el desierto de Sinaí. Conforme a todo lo que el Señor ordenó a Moisés, así lo hicieron los hijos de Israel. ");
INSERT INTO spablm_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Había ciertos hombres que estaban impuros a causa del cadáver de un hombre, de modo que no podían celebrar la Pascua en ese día, y se presentaron ante Moisés y Aarón en ese día. ");
INSERT INTO spablm_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Aquellos hombres le dijeron: “Somos impuros a causa del cadáver de un hombre. ¿Por qué se nos retiene, para que no ofrezcamos la ofrenda de Yahvé en su tiempo señalado entre los hijos de Israel?” ");
INSERT INTO spablm_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Moisés les respondió: “Esperen, para que yo oiga lo que Yahvé mande sobre ustedes”. ");
INSERT INTO spablm_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Di a los hijos de Israel: “Si alguno de vosotros o de vuestras generaciones es impuro por causa de un cadáver, o está de viaje lejos, aún así celebrará la Pascua a Yahvé. ");
INSERT INTO spablm_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","En el segundo mes, el día catorce por la tarde la celebrarán; la comerán con panes sin levadura y hierbas amargas. ");
INSERT INTO spablm_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","No dejarán nada de ella para la mañana siguiente, ni romperán ningún hueso. Conforme a todo el estatuto de la Pascua la celebrarán. ");
INSERT INTO spablm_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Pero el hombre que esté limpio y no esté de viaje, y no guarde la Pascua, esa persona será cortada de su pueblo. Por no haber ofrecido la ofrenda de Yahvé en su tiempo señalado, ese hombre cargará con su pecado. ");
INSERT INTO spablm_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“‘Si un extranjero vive entre ustedes y desea celebrar la Pascua a Yahvé, entonces lo hará según el estatuto de la Pascua, y según su ordenanza. Tendréis un solo estatuto, tanto para el extranjero como para el nacido en la tierra.’” ");
INSERT INTO spablm_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","El día en que se levantó el tabernáculo, la nube cubrió el tabernáculo, la Tienda del Testimonio. Al atardecer estaba sobre el tabernáculo, como una apariencia de fuego, hasta la mañana. ");
INSERT INTO spablm_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Así era continuamente. La nube lo cubría, y la apariencia de fuego por la noche. ");
INSERT INTO spablm_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Cada vez que la nube se alzaba sobre la Tienda, los hijos de Israel se desplazaban; y en el lugar donde la nube permanecía, allí acampaban los hijos de Israel. ");
INSERT INTO spablm_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Por orden de Yahvé, los hijos de Israel viajaban, y por orden de Yahvé acampaban. Mientras la nube permaneció sobre el tabernáculo, permanecieron acampados. ");
INSERT INTO spablm_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Cuando la nube permanecía sobre el tabernáculo muchos días, entonces los hijos de Israel cumplían la orden de Yahvé y no viajaban. ");
INSERT INTO spablm_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","A veces la nube estaba unos pocos días sobre el tabernáculo; entonces, según el mandato de Yahvé, permanecían acampados, y según el mandato de Yahvé, viajaban. ");
INSERT INTO spablm_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","A veces la nube estaba desde la tarde hasta la mañana, y cuando la nube se levantaba por la mañana, viajaban; o de día y de noche, cuando la nube se levantaba, viajaban. ");
INSERT INTO spablm_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Ya sea que la nube permaneciera dos días, un mes o un año sobre el tabernáculo, los hijos de Israel permanecían acampados y no viajaban; pero cuando se levantaba, viajaban. ");
INSERT INTO spablm_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Al mandato del Señor acampaban, y al mandato del Señor viajaron. Cumplieron el mandato de Yahvé, a la orden de Yahvé por medio de Moisés. ");
INSERT INTO spablm_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Yahvé habló a Moisés diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Haz dos trompetas de plata. Las harás de plata labrada. Las usarás para llamar a la congregación y para el desplazamiento de los campamentos. ");
INSERT INTO spablm_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Cuando las toquen, toda la congregación se reunirá contigo a la puerta de la Tienda de Reunión. ");
INSERT INTO spablm_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Si tocan una sola, los príncipes, los jefes de los millares de Israel, se reunirán contigo. ");
INSERT INTO spablm_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Cuando toques una alarma, los campamentos que se encuentran en el lado oriental avanzarán. ");
INSERT INTO spablm_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Cuando toques la alarma por segunda vez, los campamentos que se encuentran en el lado sur se adelantarán. Tocarán la alarma para sus desplazamientos. ");
INSERT INTO spablm_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Pero cuando se reúna la asamblea, tocaréis, pero no haréis sonar la alarma. ");
INSERT INTO spablm_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","“Los hijos de Aarón, los sacerdotes, tocarán las trompetas. Esto os servirá de estatuto para siempre por vuestras generaciones. ");
INSERT INTO spablm_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Cuando vayas a la guerra en tu tierra contra el adversario que te oprime, entonces tocarás la alarma con las trompetas. Entonces serás recordado ante el Señor, tu Dios, y te salvarás de tus enemigos. ");
INSERT INTO spablm_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","“También en el día de tu alegría, y en tus fiestas establecidas, y en los comienzos de tus meses, tocarás las trompetas sobre tus holocaustos y sobre los sacrificios de tus ofrendas de paz; y te servirán de recuerdo ante tu Dios. Yo soy Yahvé, tu Dios”. ");
INSERT INTO spablm_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","En el segundo año, en el segundo mes, a los veinte días del mes, la nube se levantó de encima del tabernáculo de la alianza. ");
INSERT INTO spablm_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Los hijos de Israel salieron del desierto de Sinaí, y la nube se quedó en el desierto de Parán. ");
INSERT INTO spablm_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Primero avanzaron según el mandato de Yahvé por medio de Moisés. ");
INSERT INTO spablm_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","En primer lugar, el estandarte del campamento de los hijos de Judá avanzó según sus ejércitos. Naasón hijo de Aminadab estaba al frente de su ejército. ");
INSERT INTO spablm_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Natanael hijo de Zuar estaba al frente del ejército de la tribu de los hijos de Isacar. ");
INSERT INTO spablm_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Eliab hijo de Helón estaba al frente del ejército de la tribu de los hijos de Zabulón. ");
INSERT INTO spablm_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","El tabernáculo fue desmontado, y los hijos de Gersón y los hijos de Merari, que llevaban el tabernáculo, avanzaron. ");
INSERT INTO spablm_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","El estandarte del campamento de Rubén avanzó según sus ejércitos. Elizur hijo de Sedeur estaba al frente de su ejército. ");
INSERT INTO spablm_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Selumiel hijo de Zurishaddai estaba al frente del ejército de la tribu de los hijos de Simeón. ");
INSERT INTO spablm_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Eliasaf hijo de Deuel estaba al frente del ejército de la tribu de los hijos de Gad. ");
INSERT INTO spablm_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Los coatitas se adelantaron llevando el santuario. Los demás montaron el tabernáculo antes de que ellos llegaran. ");
INSERT INTO spablm_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","El estandarte del campamento de los hijos de Efraín avanzaba según sus ejércitos. Elisama hijo de Amiud estaba al frente de su ejército. ");
INSERT INTO spablm_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Gamaliel hijo de Pedahzur estaba al frente del ejército de la tribu de los hijos de Manasés. ");
INSERT INTO spablm_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Abidán hijo de Gedeón estaba al frente del ejército de la tribu de los hijos de Benjamín. ");
INSERT INTO spablm_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","El estandarte del campamento de los hijos de Dan, que era la retaguardia de todos los campamentos, avanzaba según sus ejércitos. Ahiezer hijo de Amisada estaba al frente de su ejército. ");
INSERT INTO spablm_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Pagiel hijo de Ocrán estaba al frente del ejército de la tribu de los hijos de Aser. ");
INSERT INTO spablm_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Ahira hijo de Enán estaba al frente del ejército de la tribu de los hijos de Neftalí. ");
INSERT INTO spablm_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Así fueron los viajes de los hijos de Israel según sus ejércitos; y avanzaron. ");
INSERT INTO spablm_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Moisés le dijo a Hobab, hijo de Reuel el madianita, el suegro de Moisés: “Nos dirigimos al lugar del que Yahvé dijo: ‘Te lo daré’. Ven con nosotros y te trataremos bien, porque Yahvé ha hablado bien de Israel”. ");
INSERT INTO spablm_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Le dijo: “No iré, sino que me iré a mi tierra y a mis parientes”. ");
INSERT INTO spablm_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Moisés dijo: “No nos dejes, por favor; porque tú sabes cómo hemos de acampar en el desierto, y puedes ser nuestros ojos. ");
INSERT INTO spablm_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Será, si vas con nosotros — sí, será — que todo lo bueno que haga Yahvé con nosotros, nosotros haremos lo mismo con ustedes.” ");
INSERT INTO spablm_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Partieron del monte de Yahvé a tres días de camino. El arca de la alianza de Yahvé iba delante de ellos a tres días de camino, para buscarles un lugar de descanso. ");
INSERT INTO spablm_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","La nube del Señor estaba sobre ellos durante el día, cuando partían del campamento. ");
INSERT INTO spablm_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Cuando el arca se adelantó, Moisés dijo: “¡Levántate, Yahvé, y que se dispersen tus enemigos! Que los que te odian huyan ante ti”. ");
INSERT INTO spablm_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Cuando descansó, dijo: “Vuelve, Yahvé, a los diez mil de los miles de Israel”. ");
INSERT INTO spablm_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","El pueblo se quejaba a los oídos del Señor. Cuando Yahvé lo oyó, se encendió su ira; y el fuego de Yahvé ardió entre ellos, y consumió algunas de las afueras del campamento. ");
INSERT INTO spablm_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","El pueblo clamó a Moisés; Moisés oró a Yahvé, y el fuego se calmó. ");
INSERT INTO spablm_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","El nombre de ese lugar fue llamado Taberah, porque el fuego de Yahvé ardía entre ellos. ");
INSERT INTO spablm_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","La multitud mixta que estaba en medio de ellos tuvo mucho deseo insaciable; también los hijos de Israel volvieron a llorar y dijeron: “¿Quién nos dará de comer? ");
INSERT INTO spablm_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Nos acordamos del pescado que comimos en Egipto de balde; de los pepinos, los melones, los puerros, las cebollas y los ajos; ");
INSERT INTO spablm_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","pero ahora hemos perdido el apetito. No hay nada más que este maná para mirar”. ");
INSERT INTO spablm_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","El maná era como una semilla de cilantro, y parecía bdellium. ");
INSERT INTO spablm_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","La gente iba de un lado a otro, lo recogía y lo molía en molinos o lo batía en morteros, lo hervía en ollas y hacía tortas con él. Su sabor era como el del aceite fresco. ");
INSERT INTO spablm_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Cuando el rocío caía sobre el campamento por la noche, el maná caía sobre él. ");
INSERT INTO spablm_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Moisés oyó que el pueblo lloraba en sus familias, cada uno a la puerta de su tienda; y la ira de Yahvé ardía en gran medida, y Moisés se disgustó. ");
INSERT INTO spablm_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Moisés dijo a Yahvé: “¿Por qué has tratado tan mal a tu siervo? ¿Por qué no he hallado gracia ante tus ojos, para que pongas sobre mí la carga de todo este pueblo? ");
INSERT INTO spablm_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","¿He concebido yo a todo este pueblo? ¿Acaso los he sacado, para que me digas: “Llévalos en tu seno, como una nodriza lleva a un niño de pecho, a la tierra que juraste a sus padres”? ");
INSERT INTO spablm_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","¿De dónde podría sacar carne para dar a todo este pueblo? Porque lloran ante mí, diciendo: ‘Danos carne para que comamos’. ");
INSERT INTO spablm_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","No puedo soportar solo a todo este pueblo, porque es demasiado pesado para mí. ");
INSERT INTO spablm_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Si me tratas así, por favor, mátame ahora mismo, si es que he hallado gracia ante tus ojos; y no me dejes ver mi miseria.” ");
INSERT INTO spablm_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","El Señor le dijo a Moisés: “Reúne conmigo a setenta hombres de los ancianos de Israel, que sepas que son los ancianos del pueblo y los oficiales sobre ellos, y tráelos a la Tienda de Reunión, para que estén allí contigo. ");
INSERT INTO spablm_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Yo bajaré y hablaré con ustedes allí. Tomaré del Espíritu que está sobre ti, y lo pondré sobre ellos; y ellos llevarán la carga del pueblo contigo, para que no la lleves tú solo. ");
INSERT INTO spablm_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“Di al pueblo: “Santificaos para prepararos para mañana, y comeréis carne; porque habéis llorado a oídos de Yahvé, diciendo: “¿Quién nos dará de comer? Porque nos fue bien en Egipto”. Por lo tanto, Yahvé les dará carne, y ustedes comerán. ");
INSERT INTO spablm_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","No comeréis un solo día, ni dos días, ni cinco días, ni diez días, ni veinte días, ");
INSERT INTO spablm_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","sino un mes entero, hasta que os salga por las narices, y os resulte repugnante; porque habéis rechazado a Yahvé, que está en medio de vosotros, y habéis llorado ante él, diciendo: “¿Por qué salimos de Egipto?”” ");
INSERT INTO spablm_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Moisés dijo: “El pueblo, en medio del cual me encuentro, es de seiscientos mil hombres de a pie; y tú has dicho: ‘Les daré comida para que coman todo un mes’. ");
INSERT INTO spablm_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","¿Se sacrificarán para ellos rebaños y manadas, para que les baste? ¿Se reunirán para ellos todos los peces del mar, para que les basten?” ");
INSERT INTO spablm_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Yahvé dijo a Moisés: “¿Se ha acortado la mano de Yahvé? Ahora verás si mi palabra se cumple o no”. ");
INSERT INTO spablm_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Moisés salió y le contó al pueblo las palabras de Yahvé, y reunió a setenta hombres de los ancianos del pueblo, y los puso alrededor de la Tienda. ");
INSERT INTO spablm_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","El Señor descendió en la nube y le habló, y tomó del Espíritu que estaba sobre él y lo puso sobre los setenta ancianos. Cuando el Espíritu se posó sobre ellos, profetizaron, pero no lo hicieron más. ");
INSERT INTO spablm_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Pero dos hombres se quedaron en el campamento. El nombre de uno era Eldad, y el del otro Medad; y el Espíritu reposó sobre ellos. Eran de los que estaban escritos, pero no habían salido a la Tienda; y profetizaban en el campamento. ");
INSERT INTO spablm_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Un joven corrió y se lo comunicó a Moisés, diciendo: “¡Eldad y Medad están profetizando en el campamento!” ");
INSERT INTO spablm_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Josué, hijo de Nun, siervo de Moisés, uno de sus elegidos, respondió: “¡Mi señor Moisés, prohíbelo!” ");
INSERT INTO spablm_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Moisés le dijo: “¿Estás celoso por mí? Ojalá todo el pueblo de Yahvé fuera profeta, para que Yahvé pusiera su Espíritu en ellos”. ");
INSERT INTO spablm_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Moisés entró en el campamento, él y los ancianos de Israel. ");
INSERT INTO spablm_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Salió un viento de Yahvé y trajo codornices del mar, y las dejó caer junto al campamento, como a un día de camino de un lado, y a un día de camino del otro, alrededor del campamento, y como a dos codos sobre la superficie de la tierra. ");
INSERT INTO spablm_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","El pueblo se levantó todo ese día, toda esa noche y todo el día siguiente, y recogió las codornices. El que menos juntó, juntó diez homers; y se las repartieron todas alrededor del campamento. ");
INSERT INTO spablm_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Mientras la carne estaba todavía entre sus dientes, antes de ser masticada, la ira de Yahvé ardió contra el pueblo, y Yahvé hirió al pueblo con una plaga muy grande. ");
INSERT INTO spablm_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","El nombre de ese lugar fue llamado Kibrot Hataava,, porque allí enterraron a la gente que codiciaba. ");
INSERT INTO spablm_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Desde Kibrot Hataava el pueblo viajó a Hazeroth; y se quedaron en Hazeroth. ");
INSERT INTO spablm_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Miriam y Aarón hablaron contra Moisés a causa de la mujer cusita con la que se había casado, pues se había casado con una mujer cusita. ");
INSERT INTO spablm_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Dijeron: “¿Acaso Yahvé ha hablado sólo con Moisés? ¿No ha hablado también con nosotros?” Y Yahvé lo escuchó. ");
INSERT INTO spablm_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","El hombre Moisés era muy humilde, más que todos los hombres que había sobre la superficie de la tierra. ");
INSERT INTO spablm_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Yahvé habló de repente a Moisés, a Aarón y a Miriam: “¡Salgan ustedes tres a la Tienda del Encuentro!” Los tres salieron. ");
INSERT INTO spablm_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","El Señor descendió en una columna de nube, se paró a la puerta de la Tienda y llamó a Aarón y a Miriam, y ambos se acercaron. ");
INSERT INTO spablm_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","El dijo: “Escuchen ahora mis palabras. Si hay un profeta entre ustedes, yo, Yahvé, me daré a conocer a él en una visión. Hablaré con él en un sueño. ");
INSERT INTO spablm_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Mi siervo Moisés no es así. Él es fiel en toda mi casa. ");
INSERT INTO spablm_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Con él hablaré de boca a boca, claramente y no con enigmas, y verá la forma de Yahvé. ¿Por qué, pues, no temiste hablar contra mi siervo, contra Moisés?” ");
INSERT INTO spablm_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","La ira de Yahvé ardió contra ellos, y se marchó. ");
INSERT INTO spablm_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","La nube se apartó de la Tienda, y he aquí que Miriam estaba leprosa, blanca como la nieve. Aarón miró a Miriam, y he aquí que estaba leprosa. ");
INSERT INTO spablm_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Aarón dijo a Moisés: “Oh, señor mío, por favor, no nos tomes en cuenta este pecado, en el que hemos actuado neciamente y en el que hemos pecado. ");
INSERT INTO spablm_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Te ruego que no sea como un muerto, cuya carne está medio consumida cuando sale del vientre de su madre”. ");
INSERT INTO spablm_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Moisés clamó a Yahvé diciendo: “¡Sánala, Dios, te lo ruego!” ");
INSERT INTO spablm_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Yahvé dijo a Moisés: “Si su padre no hubiera hecho más que escupirle en la cara, ¿no debería estar avergonzada siete días? Que la encierren fuera del campamento durante siete días, y después la volverán a meter”. ");
INSERT INTO spablm_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Miriam fue encerrada fuera del campamento durante siete días, y el pueblo no viajó hasta que Miriam fue traída de nuevo. ");
INSERT INTO spablm_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Después, el pueblo partió de Hazerot y acampó en el desierto de Parán. ");
INSERT INTO spablm_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Envía hombres para que espíen la tierra de Canaán, que yo doy a los hijos de Israel. De cada tribu de sus padres, enviarás un hombre, cada uno de ellos un príncipe entre ellos”. ");
INSERT INTO spablm_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Moisés los envió desde el desierto de Parán, según el mandato de Yahvé. Todos ellos eran hombres que eran jefes de los hijos de Israel. ");
INSERT INTO spablm_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Estos eran sus nombres: De la tribu de Rubén, Samua hijo de Zacur. ");
INSERT INTO spablm_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","De la tribu de Simeón, Safat hijo de Hori. ");
INSERT INTO spablm_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","De la tribu de Judá, Caleb hijo de Jefone. ");
INSERT INTO spablm_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","De la tribu de Isacar, Igal hijo de José. ");
INSERT INTO spablm_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","De la tribu de Efraín, Oseas hijo de Nun. ");
INSERT INTO spablm_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","De la tribu de Benjamín, Palti, hijo de Rafu. ");
INSERT INTO spablm_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","De la tribu de Zabulón, Gadiel hijo de Sodi. ");
INSERT INTO spablm_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","De la tribu de José, de la tribu de Manasés, Gadi hijo de Susi. ");
INSERT INTO spablm_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","De la tribu de Dan, Ammiel hijo de Gemali. ");
INSERT INTO spablm_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","De la tribu de Aser, Setur, hijo de Micael. ");
INSERT INTO spablm_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","De la tribu de Neftalí, Nahbi hijo de Vapsi. ");
INSERT INTO spablm_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","De la tribu de Gad, Geuel hijo de Maqui. ");
INSERT INTO spablm_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Estos son los nombres de los hombres que Moisés envió a espiar la tierra. Moisés llamó Josué a Oseas hijo de Nun. ");
INSERT INTO spablm_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Moisés los envió a espiar la tierra de Canaán, y les dijo: “Suban por este camino del sur y suban a la región montañosa. ");
INSERT INTO spablm_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Ved la tierra, cómo es; y el pueblo que la habita, si es fuerte o débil, si es poco o mucho; ");
INSERT INTO spablm_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","y cómo es la tierra que habitan, si es buena o mala; y qué ciudades son las que habitan, si en campamentos o en fortalezas; ");
INSERT INTO spablm_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","y cómo es la tierra, si es fértil o pobre, si hay madera en ella o no. Sé valiente y trae algo del fruto de la tierra”. Era el tiempo de las primeras uvas maduras. ");
INSERT INTO spablm_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Subieron, pues, y reconocieron la tierra desde el desierto de Zin hasta Rehob, hasta la entrada de Hamat. ");
INSERT INTO spablm_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Subieron por el sur y llegaron a Hebrón, donde estaban Ahimán, Sesai y Talmai, hijos de Anac. (Ahora bien, Hebrón fue construida siete años antes que Zoán en Egipto.) ");
INSERT INTO spablm_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Llegaron al valle de Escol, y cortaron de allí una rama con un racimo de uvas, y la llevaron en un bastón entre dos. También llevaron algunas granadas e higos. ");
INSERT INTO spablm_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Aquel lugar fue llamado valle de Escol, por el racimo que los hijos de Israel cortaron de allí. ");
INSERT INTO spablm_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Volvieron de espiar la tierra al cabo de cuarenta días. ");
INSERT INTO spablm_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Fueron y vinieron a Moisés, a Aarón y a toda la congregación de los hijos de Israel, al desierto de Parán, a Cades, y les trajeron la noticia a ellos y a toda la congregación. Les mostraron el fruto de la tierra. ");
INSERT INTO spablm_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Ellos se lo contaron y dijeron: “Hemos llegado a la tierra a la que nos enviaste. Ciertamente fluye leche y miel, y éste es su fruto. ");
INSERT INTO spablm_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Sin embargo, el pueblo que habita la tierra es fuerte, y las ciudades están fortificadas y son muy grandes. Además, vimos allí a los hijos de Anac. ");
INSERT INTO spablm_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Amalec habita en la tierra del Sur. El hitita, el jebuseo y el amorreo habitan en la región montañosa. El cananeo habita junto al mar y al lado del Jordán”. ");
INSERT INTO spablm_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Caleb calmó al pueblo ante Moisés y dijo: “¡Subamos de inmediato y tomemos posesión de ella, pues somos capaces de vencerla!” ");
INSERT INTO spablm_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Pero los hombres que subieron con él dijeron: “No somos capaces de subir contra ese pueblo, porque es más fuerte que nosotros”. ");
INSERT INTO spablm_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Presentaron a los hijos de Israel un mal informe de la tierra que habían espiado, diciendo: “La tierra por la que hemos pasado para espiarla es una tierra que devora a sus habitantes, y todos los pueblos que vimos en ella son hombres de gran estatura. ");
INSERT INTO spablm_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Allí vimos a los Nefilim, los hijos de Anak, que provienen de los Nefilim. Éramos a nuestra vista como saltamontes, y así éramos a su vista”. ");
INSERT INTO spablm_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Toda la congregación alzó la voz y gritó, y el pueblo lloró aquella noche. ");
INSERT INTO spablm_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Todos los hijos de Israel murmuraron contra Moisés y contra Aarón. Toda la congregación les dijo: “¡Ojalá hubiéramos muerto en la tierra de Egipto, o hubiéramos muerto en este desierto! ");
INSERT INTO spablm_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","¿Por qué nos trae el Señor a esta tierra para que caigamos a espada? ¡Nuestras esposas y nuestros pequeños serán capturados o asesinados! ¿No sería mejor que volviéramos a Egipto?” ");
INSERT INTO spablm_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Se dijeron unos a otros: “Elijamos un líder y volvamos a Egipto”. ");
INSERT INTO spablm_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Entonces Moisés y Aarón se postraron ante toda la asamblea de la congregación de los hijos de Israel. ");
INSERT INTO spablm_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Josué, hijo de Nun, y Caleb, hijo de Jefone, que eran de los que espiaban la tierra, se rasgaron las vestiduras. ");
INSERT INTO spablm_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Hablaron a toda la congregación de los hijos de Israel, diciendo: “La tierra que atravesamos para espiarla es una tierra sumamente buena. ");
INSERT INTO spablm_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Si Yahvé se complace en nosotros, nos introducirá en esta tierra y nos la dará: una tierra que mana leche y miel. ");
INSERT INTO spablm_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Sólo que no se rebelen contra Yahvé, ni teman al pueblo de la tierra, porque ellos son el pan para nosotros. Su defensa ha sido retirada de encima de ellos, y Yahvé está con nosotros. No les temáis”. ");
INSERT INTO spablm_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Pero toda la congregación amenazó con apedrearlos. La gloria de Yahvé se presentó en la Tienda del Encuentro a todos los hijos de Israel. ");
INSERT INTO spablm_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Yahvé dijo a Moisés: “¿Hasta cuándo me despreciará este pueblo? ¿Hasta cuándo no creerán en mí, por todas las señales que he realizado entre ellos? ");
INSERT INTO spablm_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Los heriré con la peste y los desheredaré, y haré de ti una nación más grande y poderosa que ellos.” ");
INSERT INTO spablm_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Moisés dijo a Yahvé: “Entonces los egipcios lo oirán, porque tú con tu poder sacaste a este pueblo con tu fuerza de entre ello. ");
INSERT INTO spablm_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Lo contarán a los habitantes de esta tierra. Han oído que tú, Yahvé, estás en medio de este pueblo; porque a ti, Yahvé, te ven cara a cara, y tu nube está sobre ellos, y tú vas delante de ellos, en una columna de nube de día, y en una columna de fuego de noche. ");
INSERT INTO spablm_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Ahora bien, si matas a este pueblo como a un solo hombre, las naciones que han oído tu fama hablarán diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘Porque Yahvé no pudo llevar a este pueblo a la tierra que le había jurado, por eso lo ha matado en el desierto.’ ");
INSERT INTO spablm_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Ahora, por favor, haz que el poder de Yahvé sea grande, según has hablado, diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘Yahvé es lento para la ira, y abundante en misericordia, que perdona la iniquidad y la desobediencia; y de ninguna manera exculpará al culpable, visitando la iniquidad de los padres en los hijos, en la tercera y en la cuarta generación.’ ");
INSERT INTO spablm_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Por favor, perdona la iniquidad de este pueblo según la grandeza de tu amorosa bondad, y tal como has perdonado a este pueblo, desde Egipto hasta ahora.” ");
INSERT INTO spablm_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Yahvé dijo: “Yo he perdonado según tu palabra; ");
INSERT INTO spablm_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","pero en realidad — mientras yo viva y toda la tierra se llene de la gloria de Yahvé — ");
INSERT INTO spablm_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","porque todos esos hombres que han visto mi gloria y mis señales, que hice en Egipto y en el desierto, me han tentado estas diez veces, y no han escuchado mi voz; ");
INSERT INTO spablm_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","ciertamente no verán la tierra que juré a sus padres, ni la verá ninguno de los que me despreciaron. ");
INSERT INTO spablm_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Pero a mi siervo Caleb, por haber tenido otro espíritu con él y haberme seguido plenamente, lo introduciré en la tierra a la que entró. Su descendencia la poseerá. ");
INSERT INTO spablm_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Puesto que el amalecita y el cananeo habitan en el valle, mañana se volverán y entrarán en el desierto por el camino del Mar Rojo.” ");
INSERT INTO spablm_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Yahvé habló a Moisés y a Aarón, diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“¿Hasta cuándo tendré que soportar a esta congregación malvada que se queja contra mí? He oído las quejas de los hijos de Israel, que se quejan contra mí. ");
INSERT INTO spablm_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Diles: “Vivo yo, dice Yahvé, que tal como habéis hablado en mis oídos, así haré con vosotros. ");
INSERT INTO spablm_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Vuestros cadáveres caerán en este desierto; y todos los que fueron contados de vosotros, según vuestro número total, de veinte años para arriba, que se han quejado contra mí, ");
INSERT INTO spablm_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","ciertamente no entraréis en la tierra sobre la cual juré que os haría habitar en ella, excepto Caleb hijo de Jefone y Josué hijo de Nun. ");
INSERT INTO spablm_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Pero traeré a vuestros pequeños que dijisteis que debían ser capturados o muertos, y ellos conocerán la tierra que habéis rechazado. ");
INSERT INTO spablm_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Pero en cuanto a vosotros, vuestros cadáveres caerán en este desierto. ");
INSERT INTO spablm_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Vuestros hijos serán errantes en el desierto durante cuarenta años, y soportarán vuestra prostitución, hasta que vuestros cadáveres se consuman en el desierto. ");
INSERT INTO spablm_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Después del número de los días en que espiasteis la tierra, cuarenta días, por cada día un año, llevaréis vuestras iniquidades, cuarenta años, y conoceréis mi alienación.’ ");
INSERT INTO spablm_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Yo, Yahvé, he hablado. Ciertamente haré esto a toda esta congregación malvada que se ha reunido contra mí. En este desierto serán consumidos, y allí morirán”. ");
INSERT INTO spablm_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Los hombres que Moisés envió a espiar la tierra, y que regresaron e hicieron que toda la congregación murmurara contra él presentando un mal informe contra la tierra, ");
INSERT INTO spablm_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","incluso aquellos hombres que presentaron un mal informe de la tierra, murieron por la plaga ante Yahvé. ");
INSERT INTO spablm_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Pero Josué, hijo de Nun, y Caleb, hijo de Jefone, quedaron vivos de aquellos hombres que fueron a espiar la tierra. ");
INSERT INTO spablm_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Moisés contó estas palabras a todos los hijos de Israel, y el pueblo se lamentó mucho. ");
INSERT INTO spablm_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Se levantaron de madrugada y subieron a la cima del monte, diciendo: “Ya estamos aquí y subiremos al lugar que Yahvé ha prometido, porque hemos pecado.” ");
INSERT INTO spablm_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Moisés dijo: “¿Por qué desobedecen ahora el mandamiento de Yahvé, ya que no prosperará? ");
INSERT INTO spablm_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","No suban, porque Yahvé no está en medio de ustedes; así no serán derribados ante sus enemigos. ");
INSERT INTO spablm_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Porque allí están el amalecita y el cananeo delante de ustedes, y caerán a espada porque se apartaron de seguir a Yahvé; por eso Yahvé no estará con ustedes.” ");
INSERT INTO spablm_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Pero ellos se atrevieron a subir a la cima de la montaña. Sin embargo, el arca de la alianza de Yahvé y Moisés no salieron del campamento. ");
INSERT INTO spablm_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Entonces bajaron los amalecitas y los cananeos que vivían en ese monte, y los golpearon y los derrotaron hasta Horma. ");
INSERT INTO spablm_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Habla a los hijos de Israel y diles: ‘Cuando hayáis entrado en la tierra de vuestras moradas, que yo os doy, ");
INSERT INTO spablm_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","y hagáis una ofrenda por fuego a Yahvé — un holocausto, o un sacrificio, para cumplir un voto o como ofrenda voluntaria, o en vuestras fiestas establecidas, para hacer un aroma agradable a Yahvé, de la manada o del rebaño — ");
INSERT INTO spablm_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","entonces el que ofrezca su ofrenda ofrecerá a Yahvé una ofrenda de harina de una décima parte de un efa de harina fina mezclada con una cuarta parte de un hin de aceite. ");
INSERT INTO spablm_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Prepararás vino para la libación, la cuarta parte de un hin, con el holocausto o para el sacrificio, por cada cordero. ");
INSERT INTO spablm_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“‘Por un carnero, prepararás para una ofrenda dos décimas de efa de harina fina mezclada con la tercera parte de un hin de aceite; ");
INSERT INTO spablm_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","y para la libación ofrecerás la tercera parte de un hin de vino, de aroma agradable para Yahvé. ");
INSERT INTO spablm_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Cuando prepares un toro para un holocausto o para un sacrificio, para cumplir un voto, o para ofrendas de paz a Yahvé, ");
INSERT INTO spablm_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","entonces ofrecerás con el becerro una ofrenda de harina de tres décimas de efa de harina fina mezclada con medio hin de aceite; ");
INSERT INTO spablm_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","y ofrecerás para la libación medio hin de vino, como ofrenda encendida, de aroma agradable a Yahvé. ");
INSERT INTO spablm_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Así se hará por cada toro, por cada carnero, por cada uno de los corderos o de los cabritos. ");
INSERT INTO spablm_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Según el número que prepares, así harás con cada uno según su número. ");
INSERT INTO spablm_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“‘Todos los nativos harán estas cosas de esta manera, al ofrecer una ofrenda encendida, de aroma agradable a Yahvé. ");
INSERT INTO spablm_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Si un extranjero vive como forastero con vosotros, o quienquiera que esté entre vosotros a lo largo de vuestras generaciones, y ofrece una ofrenda encendida de aroma agradable a Yahvé, como hacéis vosotros, así lo hará. ");
INSERT INTO spablm_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Para la asamblea, habrá un estatuto para vosotros y para el extranjero que vive como tal, un estatuto para siempre a lo largo de vuestras generaciones. Como vosotros, así será el extranjero ante Yahvé. ");
INSERT INTO spablm_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Una sola ley y un solo estatuto habrá para vosotros y para el extranjero que vive como forastero con vosotros.’” ");
INSERT INTO spablm_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Habla a los hijos de Israel y diles: ‘Cuando lleguéis a la tierra a la que os traigo, ");
INSERT INTO spablm_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","entonces será que cuando comáis del pan de la tierra, ofreceréis una ofrenda mecida a Yahvé. ");
INSERT INTO spablm_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","De lo primero de tu masa ofrecerás una torta como ofrenda mecida. Como la ofrenda mecida de la era, así la ofrecerás. ");
INSERT INTO spablm_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","De las primicias de tu masa, ofrecerás a Yahvé una ofrenda mecida a lo largo de tus generaciones. ");
INSERT INTO spablm_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“‘Cuando erréis y no observéis todos estos mandamientos que Yahvé ha dicho a Moisés — ");
INSERT INTO spablm_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","todo lo que Yahvé os ha mandado por medio de Moisés, desde el día en que Yahvé dio el mandamiento y en adelante por vuestras generaciones — ");
INSERT INTO spablm_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","entonces será si se hizo sin querer, sin conocimiento de la congregación, toda la congregación ofrecerá un novillo en holocausto, como aroma agradable a Yahvé, con su ofrenda y su libación, según la ordenanza, y un macho cabrío como ofrenda por el pecado. ");
INSERT INTO spablm_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","El sacerdote hará la expiación por toda la congregación de los hijos de Israel, y serán perdonados; porque fue un error, y han traído su ofrenda, una ofrenda encendida a Yahvé, y su ofrenda por el pecado ante Yahvé, por su error. ");
INSERT INTO spablm_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Toda la congregación de los hijos de Israel será perdonada, así como el extranjero que vive como forastero en medio de ellos; porque con respecto a todo el pueblo, se hizo sin querer. ");
INSERT INTO spablm_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“‘Si una persona peca involuntariamente, ofrecerá una cabra hembra de un año como ofrenda por el pecado. ");
INSERT INTO spablm_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","El sacerdote hará expiación por el alma que se equivoca cuando peca involuntariamente ante Yahvé. Hará expiación por él, y será perdonado. ");
INSERT INTO spablm_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Tendrás una sola ley para el que hace algo involuntariamente, para el nativo entre los hijos de Israel y para el extranjero que vive como forastero entre ellos. ");
INSERT INTO spablm_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“‘Pero el alma que hace algo con mano alzada, sea nativo o extranjero, blasfema a Yahvé. Esa alma será cortada de entre su pueblo. ");
INSERT INTO spablm_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Porque ha despreciado la palabra de Yahvé y ha violado su mandamiento, esa alma será cortada por completo. Su iniquidad recaerá sobre él”. ");
INSERT INTO spablm_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Mientras los hijos de Israel estaban en el desierto, encontraron a un hombre recogiendo palos en el día de reposo. ");
INSERT INTO spablm_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Los que lo encontraron recogiendo palos lo llevaron a Moisés y a Aarón, y a toda la congregación. ");
INSERT INTO spablm_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Lo pusieron en custodia, porque no se había declarado lo que debía hacerse con él. ");
INSERT INTO spablm_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","El Señor le dijo a Moisés: “Ese hombre deberá morir. Toda la congregación lo apedreará fuera del campamento”. ");
INSERT INTO spablm_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Toda la congregación lo sacó fuera del campamento y lo apedreó hasta la muerte, como Yahvé le ordenó a Moisés. ");
INSERT INTO spablm_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Habla a los hijos de Israel y diles que se hagan flecos en los bordes de sus vestidos por sus generaciones, y que pongan en el fleco de cada borde un cordón de color azul. ");
INSERT INTO spablm_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Será para ti como un fleco, para que lo veas y te acuerdes de todos los mandamientos de Yahvé, y los pongas en práctica; y para que no sigas tu propio corazón y tus propios ojos, según los cuales solías jugar a la prostitución; ");
INSERT INTO spablm_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","para que te acuerdes y pongas en práctica todos mis mandamientos, y seas santo para tu Dios. ");
INSERT INTO spablm_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Yo soy el Señor, tu Dios, que te sacó de la tierra de Egipto para ser tu Dios: Yo soy Yahvé vuestro Dios”. ");
INSERT INTO spablm_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Coré, hijo de Izhar, hijo de Coat, hijo de Leví, con Datán y Abiram, hijos de Eliab, y On, hijo de Pelet, hijos de Rubén, tomaron algunos hombres. ");
INSERT INTO spablm_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Se levantaron ante Moisés, con algunos de los hijos de Israel, doscientos cincuenta príncipes de la congregación, llamados a la asamblea, hombres de renombre. ");
INSERT INTO spablm_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Se juntaron contra Moisés y contra Aarón, y les dijeron: “¡Os arrogáis demasiado, ya que toda la congregación es santa, todos ellos, y Yahvé está en medio de ellos! ¿Por qué os alzáis por encima de la asamblea de Yahvé?” ");
INSERT INTO spablm_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Cuando Moisés lo oyó, se postró sobre su rostro. ");
INSERT INTO spablm_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Dijo a Coré y a toda su compañía: “Por la mañana, el Señor mostrará quiénes son suyos y quiénes son santos, y los hará acercarse a él. También hará que se acerque a él el que él elija. ");
INSERT INTO spablm_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Hagan esto: que Coré y toda su compañía tomen incensarios, ");
INSERT INTO spablm_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","pongan fuego en ellos, y pongan incienso en ellos ante Yahvé mañana. El hombre que elija Yahvé será santo. Habéis ido demasiado lejos, hijos de Leví”. ");
INSERT INTO spablm_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Moisés dijo a Coré: “¡Escuchen ahora, hijos de Leví! ");
INSERT INTO spablm_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","¿Os parece poco que el Dios de Israel os haya separado de la congregación de Israel para acercaros a él, para que hagáis el servicio del tabernáculo de Yahvé, y para que estéis delante de la congregación para servirles; ");
INSERT INTO spablm_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","y que os haya acercado a vosotros, y a todos vuestros hermanos los hijos de Leví con vosotros? ¿Acaso buscáis también el sacerdocio? ");
INSERT INTO spablm_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","¡Por eso tú y toda tu compañía os habéis reunido contra Yahvé! ¿Qué es Aarón para que os quejéis contra él?” ");
INSERT INTO spablm_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Moisés mandó llamar a Datán y Abiram, hijos de Eliab, y ellos dijeron: “¡No subiremos! ");
INSERT INTO spablm_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","¿Es poca cosa que nos hayas hecho subir de una tierra que mana leche y miel, para matarnos en el desierto, y que además te hagas príncipe sobre nosotros? ");
INSERT INTO spablm_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Además, no nos has traído a una tierra que fluye leche y miel, ni nos has dado herencia de campos y viñedos. ¿Vas a sacarle los ojos a estos hombres? No subiremos”. ");
INSERT INTO spablm_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Moisés se enojó mucho y le dijo a Yahvé: “No respetes su ofrenda. No les he quitado ni un solo asno, ni he hecho daño a ninguno de ellos”. ");
INSERT INTO spablm_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Moisés dijo a Coré: “Tú y toda tu compañía vayan mañana ante Yahvé, tú y ellos, y Aarón. ");
INSERT INTO spablm_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Cada uno tomará su incensario y pondrá incienso en él, y cada uno llevará ante Yahvé su incensario, doscientos cincuenta incensarios; tú también y Aarón, cada uno con su incensario.” ");
INSERT INTO spablm_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Cada uno de ellos tomó su incensario, puso fuego en él y puso incienso, y se puso a la puerta de la Tienda de Reunión con Moisés y Aarón. ");
INSERT INTO spablm_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Coré reunió a toda la congregación frente a ellos a la puerta de la Tienda del Encuentro. La gloria de Yahvé apareció a toda la congregación. ");
INSERT INTO spablm_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Yahvé habló a Moisés y a Aarón, diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“¡Sepárense de entre esta congregación, para que yo los consuma en un momento!” ");
INSERT INTO spablm_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Se postraron sobre sus rostros y dijeron: “Dios, el Dios de los espíritus de toda carne, ¿pecará un solo hombre y te enojarás con toda la congregación?” ");
INSERT INTO spablm_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Yahvé habló a Moisés diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Habla a la congregación diciendo: “¡Aléjate de los alrededores de la tienda de Coré, Datán y Abiram!””. ");
INSERT INTO spablm_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Moisés se levantó y se dirigió a Datán y Abiram, y los ancianos de Israel lo siguieron. ");
INSERT INTO spablm_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Habló a la congregación diciendo: “¡Apártense, por favor, de las tiendas de estos malvados, y no toquen nada de ellos, no sea que se consuman en todos sus pecados!” ");
INSERT INTO spablm_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Y se alejaron de la tienda de Coré, Datán y Abiram, por todos lados. Datán y Abiram salieron, y se pusieron a la puerta de sus tiendas con sus mujeres, sus hijos y sus pequeños. ");
INSERT INTO spablm_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Moisés dijo: “Así sabrán que Yahvé me ha enviado a hacer todas estas obras, porque no son de mi propia cosecha. ");
INSERT INTO spablm_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Si estos hombres mueren la muerte común de todos los hombres, o si experimentan lo que todos los hombres experimentan, entonces Yahvé no me ha enviado. ");
INSERT INTO spablm_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Pero si Yahvé hace una cosa nueva, y la tierra abre su boca y los traga con todo lo que les pertenece, y bajan vivos al Seol, entonces entenderás que estos hombres han despreciado a Yahvé.” ");
INSERT INTO spablm_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Cuando terminó de decir todas estas palabras, la tierra que estaba debajo de ellos se partió. ");
INSERT INTO spablm_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","La tierra abrió su boca y se los tragó con sus familias, todos los hombres de Coré y todos sus bienes. ");
INSERT INTO spablm_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Ellos y todo lo que les pertenecía descendieron vivos al Seol. La tierra se cerró sobre ellos, y perecieron de entre la asamblea. ");
INSERT INTO spablm_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Todo Israel que estaba alrededor de ellos huyó ante su grito, pues dijeron: “¡No sea que la tierra nos trague!” ");
INSERT INTO spablm_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Salió fuego del Señor y devoró a los doscientos cincuenta hombres que ofrecían el incienso. ");
INSERT INTO spablm_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Habla a Eleazar, hijo de Aarón, el sacerdote, para que saque los incensarios de la quema, y esparza el fuego lejos del campamento; porque son sagrados, ");
INSERT INTO spablm_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","incluso los incensarios de los que pecaron contra su propia vida. Que los golpeen en placas para cubrir el altar, pues los ofrecieron ante Yahvé. Por eso son santos. Serán una señal para los hijos de Israel”. ");
INSERT INTO spablm_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","El sacerdote Eleazar tomó los incensarios de bronce que habían ofrecido los quemados, y los batieron para cubrir el altar, ");
INSERT INTO spablm_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","para que sirvieran de recuerdo a los hijos de Israel, a fin de que ningún extranjero que no sea de la descendencia de Aarón se acerque a quemar incienso delante de Yahvé, para que no sea como Coré y su compañía, como le habló Yahvé por medio de Moisés. ");
INSERT INTO spablm_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Pero al día siguiente toda la congregación de los hijos de Israel se quejó contra Moisés y contra Aarón, diciendo: “¡Habéis matado al pueblo de Yahvé!” ");
INSERT INTO spablm_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Cuando la congregación se reunió contra Moisés y contra Aarón, miraron hacia la Tienda del Encuentro. He aquí que la nube la cubría, y la gloria de Yahvé aparecía. ");
INSERT INTO spablm_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Moisés y Aarón llegaron al frente de la Tienda de Reunión. ");
INSERT INTO spablm_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“¡Aléjate de entre esta congregación, para que los consuma en un momento!” Ellos cayeron de bruces. ");
INSERT INTO spablm_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Moisés dijo a Aarón: “¡Toma tu incensario, pon en él fuego del altar, ponle incienso, llévalo rápidamente a la congregación y haz expiación por ellos, porque la ira ha salido de Yahvé! La plaga ha comenzado”. ");
INSERT INTO spablm_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Aarón hizo lo que dijo Moisés y corrió al centro de la asamblea. La plaga ya había comenzado entre el pueblo. Se puso el incienso e hizo expiación por el pueblo. ");
INSERT INTO spablm_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Se puso entre los muertos y los vivos, y la plaga se detuvo. ");
INSERT INTO spablm_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Los que murieron por la plaga fueron catorce mil setecientos, además de los que murieron por el asunto de Coré. ");
INSERT INTO spablm_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Aarón volvió con Moisés a la puerta de la Tienda del Encuentro, y la plaga se detuvo. ");
INSERT INTO spablm_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Yahvé habló a Moisés diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Habla a los hijos de Israel y toma varas de ellos, una por cada casa paterna, de todos sus príncipes según sus casas paternas, doce varas. Escribe el nombre de cada uno en su vara. ");
INSERT INTO spablm_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Escribirás el nombre de Aarón en la vara de Leví. Habrá una vara por cada jefe de sus casas paternas. ");
INSERT INTO spablm_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Las pondrás en la Tienda de Reunión, delante del pacto, donde me reúno con ustedes. ");
INSERT INTO spablm_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Sucederá que la vara del hombre que yo elija brotará. Haré que cesen las murmuraciones de los hijos de Israel, que murmuran contra ti, a partir de mí.” ");
INSERT INTO spablm_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Moisés habló a los hijos de Israel, y todos sus príncipes le dieron varas, para cada príncipe una, según las casas de sus padres, un total de doce varas. La vara de Aarón estaba entre sus varas. ");
INSERT INTO spablm_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Moisés depositó las varas ante el Señor en la Tienda del Testimonio. ");
INSERT INTO spablm_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Al día siguiente, Moisés entró en la Tienda del Testimonio; y he aquí que la vara de Aarón para la casa de Leví había brotado, había echado brotes, había producido flores y había dado almendras maduras. ");
INSERT INTO spablm_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Moisés sacó todas las varas de delante de Yahvé para todos los hijos de Israel. Ellos miraron, y cada uno tomó su vara. ");
INSERT INTO spablm_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Yahvé dijo a Moisés: “Vuelve a poner la vara de Aarón delante del pacto, para que la guardes como señal contra los hijos de la rebelión; así pondrás fin a sus quejas contra mí, para que no mueran.” ");
INSERT INTO spablm_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Así lo hizo Moisés. Como Yahvé le ordenó, así lo hizo. ");
INSERT INTO spablm_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Los hijos de Israel hablaron con Moisés, diciendo: “¡He aquí que perecemos! ¡Estamos perdidos! ¡Todos estamos deshechos! ");
INSERT INTO spablm_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","¡Todos los que se acercan al tabernáculo de Yahvé mueren! ¿Pereceremos todos?” ");
INSERT INTO spablm_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Yahvé dijo a Aarón: “Tú y tus hijos, y la casa de tu padre contigo, llevarán la iniquidad del santuario; y tú y tus hijos contigo llevarán la iniquidad de tu sacerdocio. ");
INSERT INTO spablm_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Trae también contigo a tus hermanos de la tribu de Leví, la tribu de tu padre, para que se unan a ti y te sirvan; pero tú y tus hijos contigo estarán delante de la Tienda del Testimonio. ");
INSERT INTO spablm_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Ellos guardarán tus mandatos y el deber de toda la Tienda; sólo que no se acercarán a los utensilios del santuario ni al altar, para que no mueran, ni ellos ni tú. ");
INSERT INTO spablm_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Se unirán a ti y guardarán la responsabilidad de la Tienda de reunión, para todo el servicio de la Tienda. Un extranjero no se acercará a vosotros. ");
INSERT INTO spablm_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“Cumplirás el deber del santuario y el deber del altar, para que no haya más ira sobre los hijos de Israel. ");
INSERT INTO spablm_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","He aquí que yo mismo he tomado a tus hermanos los levitas de entre los hijos de Israel. Ellos son un regalo para ti, dedicados a Yahvé, para hacer el servicio de la Tienda del Encuentro. ");
INSERT INTO spablm_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Tú y tus hijos contigo mantendrán su sacerdocio para todo lo que se refiere al altar, y para lo que está dentro del velo. Servirás. Te doy el servicio del sacerdocio como un regalo. El extranjero que se acerque será condenado a muerte”. ");
INSERT INTO spablm_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Yahvé habló a Aarón: “He aquí que yo mismo te he dado el mando de mis ofrendas mecidas, todas las cosas sagradas de los hijos de Israel. Te las he dado a ti por razón de la unción, y a tus hijos, como porción para siempre. ");
INSERT INTO spablm_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Esto será para ti de las cosas más santas del fuego: toda ofrenda de ellos, toda ofrenda por el pecado de ellos y toda ofrenda por la culpa de ellos, que me presenten, será santísima para ti y para tus hijos. ");
INSERT INTO spablm_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Comeréis de ella como de las cosas más santas. Todo varón comerá de ella. Será sagrado para ti. ");
INSERT INTO spablm_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“Esto también es tuyo: la ofrenda mecida de su regalo, todas las ofrendas mecidas de los hijos de Israel. Te las he dado a ti, a tus hijos y a tus hijas contigo, como porción para siempre. Todo el que esté limpio en tu casa comerá de ella. ");
INSERT INTO spablm_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“Te he dado todo lo mejor del aceite, todo lo mejor de la cosecha y del grano, las primicias de ellos que den a Yahvé. ");
INSERT INTO spablm_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Los primeros frutos de todo lo que hay en su tierra, que traen a Yahvé, serán tuyos. Todo el que esté limpio en tu casa comerá de ello. ");
INSERT INTO spablm_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“Todo lo consagrado en Israel será tuyo. ");
INSERT INTO spablm_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Todo lo que abra el vientre, de toda la carne que ofrezcan a Yahvé, tanto de hombres como de animales, será tuyo. Sin embargo, redimirás al primogénito del hombre, y redimirás al primogénito de los animales inmundos. ");
INSERT INTO spablm_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Redimirás a los que deban ser redimidos de un mes de edad, según tu estimación, por cinco siclos de dinero, según el siclo del santuario, que pesa veinte gerahs. ");
INSERT INTO spablm_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“Pero no redimirás el primogénito de una vaca, ni el primogénito de una oveja, ni el primogénito de una cabra. Son sagrados. Rociarás su sangre sobre el altar, y quemarás su grasa como ofrenda encendida, como aroma agradable para Yahvé. ");
INSERT INTO spablm_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Su carne será tuya, como el pecho de la ofrenda mecida y como el muslo derecho, será tuyo. ");
INSERT INTO spablm_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Todas las ofrendas mecidas de las cosas santas que los hijos de Israel ofrecen a Yahvé, te las he dado a ti y a tus hijos e hijas contigo, como una porción para siempre. Es un pacto de sal para siempre ante Yahvé para ti y para tu descendencia contigo”. ");
INSERT INTO spablm_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Yahvé dijo a Aarón: “No tendrás herencia en su tierra, ni tendrás parte entre ellos. Yo soy tu porción y tu herencia entre los hijos de Israel. ");
INSERT INTO spablm_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“A los hijos de Leví, he aquí que yo les he dado en herencia todo el diezmo en Israel, a cambio del servicio que prestan, el servicio de la Tienda del Encuentro. ");
INSERT INTO spablm_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","De ahora en adelante los hijos de Israel no se acercarán a la Tienda del Encuentro, para que no lleven el pecado y mueran. ");
INSERT INTO spablm_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Pero los levitas harán el servicio de la Carpa del Encuentro, y cargarán con su iniquidad. Será un estatuto para siempre a lo largo de vuestras generaciones. Entre los hijos de Israel no tendrán herencia. ");
INSERT INTO spablm_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Porque el diezmo de los hijos de Israel, que ofrecen como ofrenda mecida a Yahvé, lo he dado a los levitas como herencia. Por eso les he dicho: ‘Entre los hijos de Israel no tendrán herencia’”. ");
INSERT INTO spablm_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Yahvé habló a Moisés diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Además, hablarás a los levitas y les dirás: “Cuando toméis de los hijos de Israel el diezmo que os he dado de ellos como herencia, ofreceréis de él una ofrenda mecida para Yahvé, un diezmo del diezmo. ");
INSERT INTO spablm_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Tu ofrenda mecida se te acreditará como el grano de la era y como la plenitud del lagar. ");
INSERT INTO spablm_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Así también ofrecerás una ofrenda mecida a Yahvé de todos tus diezmos que recibas de los hijos de Israel; y de ella darás la ofrenda mecida de Yahvé al sacerdote Aarón. ");
INSERT INTO spablm_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","De todas vuestras ofrendas, ofreceréis a Yahvé cada ofrenda mecida, de todas sus mejores partes, la parte sagrada.’ ");
INSERT INTO spablm_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“Por lo tanto, les dirás: ‘Cuando saques lo mejor de ella, se acreditará a los levitas como el producto de la era y como el producto del lagar. ");
INSERT INTO spablm_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Podéis comerlo en cualquier parte, vosotros y vuestras familias, porque es vuestra recompensa en recompensa por vuestro servicio en la Tienda de Reunión. ");
INSERT INTO spablm_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","No cargarás con ningún pecado por causa de ella, cuando hayas sacado de ella lo mejor. No profanarás las cosas santas de los hijos de Israel, para que no mueras”. ");
INSERT INTO spablm_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Yahvé habló a Moisés y a Aarón, diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Este es el estatuto de la ley que Yahvé ha ordenado. Di a los hijos de Israel que te traigan una novilla roja sin mancha, en la que no haya ningún defecto, y que nunca haya sido unida. ");
INSERT INTO spablm_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Se la daréis al sacerdote Eleazar, y él la llevará fuera del campamento, y la matará delante de él. ");
INSERT INTO spablm_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","El sacerdote Eleazar tomará un poco de su sangre con su dedo, y rociará su sangre hacia el frente de la Tienda de Reunión siete veces. ");
INSERT INTO spablm_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","El sacerdote quemará la novilla delante de él; quemará su piel, su carne y su sangre, con su estiércol. ");
INSERT INTO spablm_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","El sacerdote tomará madera de cedro, hisopo y escarlata, y lo echará en medio del incendio de la novilla. ");
INSERT INTO spablm_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Luego el sacerdote lavará sus vestidos y bañará su carne con agua, y después entrará en el campamento, y el sacerdote quedará impuro hasta la noche. ");
INSERT INTO spablm_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","El que la queme lavará sus ropas con agua y bañará su carne con agua, y quedará impuro hasta la noche. ");
INSERT INTO spablm_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“El hombre limpio recogerá las cenizas de la vaquilla y las depositará fuera del campamento, en un lugar limpio, y las guardará para la congregación de los hijos de Israel para usarlas en el agua para limpiar la impureza. Es una ofrenda por el pecado. ");
INSERT INTO spablm_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","El que recoja las cenizas de la vaquilla se lavará la ropa y quedará impuro hasta la noche. Será para los hijos de Israel, y para el extranjero que viva como forastero entre ellos, como un estatuto para siempre. ");
INSERT INTO spablm_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“El que toque el cadáver de un hombre será impuro durante siete días. ");
INSERT INTO spablm_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Al tercer día se purificará con agua, y al séptimo día quedará limpio; pero si no se purifica al tercer día, al séptimo no quedará limpio. ");
INSERT INTO spablm_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","El que toque a un muerto, el cuerpo de un hombre que ha muerto, y no se purifique, contamina el tabernáculo de Yahvé; y esa alma será cortada de Israel; porque el agua para la impureza no fue rociada sobre él, será impuro. Su impureza aún está sobre él. ");
INSERT INTO spablm_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“Esta es la ley cuando un hombre muere en una tienda: todo el que entre en la tienda, y todo el que esté en ella, será impuro durante siete días. ");
INSERT INTO spablm_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Toda vasija abierta, que no tenga cubierta atada, es inmunda. ");
INSERT INTO spablm_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","“Cualquiera que en el campo abierto toque a un muerto con espada, o un cadáver, o un hueso de hombre, o una tumba, quedará impuro siete días. ");
INSERT INTO spablm_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“En cuanto a los impuros, tomarán de la ceniza de la quema de la ofrenda por el pecado, y se derramará sobre ellos agua corriente en una vasija. ");
INSERT INTO spablm_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","La persona limpia tomará hisopo, lo mojará en el agua y lo rociará sobre la tienda, sobre todos los utensilios, sobre las personas que estaban allí y sobre el que haya tocado el hueso, o el muerto, o la tumba. ");
INSERT INTO spablm_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","El limpio rociará sobre el impuro al tercer día y al séptimo. Al séptimo día lo purificará. Lavará su ropa y se bañará con agua, y quedará limpio al anochecer. ");
INSERT INTO spablm_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Pero el hombre que sea impuro y no se purifique, esa persona será cortada de entre la asamblea, porque ha profanado el santuario de Yahvé. El agua para la impureza no ha sido rociada sobre él. Es impuro. ");
INSERT INTO spablm_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Será un estatuto perpetuo para ellos. El que rocíe el agua de la impureza lavará sus ropas, y el que toque el agua de la impureza quedará impuro hasta la noche. ");
INSERT INTO spablm_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","“Todo lo que toque el impuro será impuro, y el alma que lo toque será impura hasta la noche”. ");
INSERT INTO spablm_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Los hijos de Israel, toda la congregación, llegaron al desierto de Zin en el primer mes. El pueblo se quedó en Cades. Allí murió Miriam, y allí fue enterrada. ");
INSERT INTO spablm_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","No había agua para la congregación, y se juntaron contra Moisés y contra Aarón. ");
INSERT INTO spablm_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","El pueblo discutió con Moisés y habló diciendo: “¡Ojalá hubiéramos muerto cuando nuestros hermanos murieron ante Yahvé! ");
INSERT INTO spablm_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","¿Por qué has traído la asamblea de Yahvé a este desierto, para que muramos allí, nosotros y nuestros animales? ");
INSERT INTO spablm_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","¿Por qué nos has hecho subir de Egipto para traernos a este mal lugar? No es lugar de semillas, ni de higos, ni de vides, ni de granadas; tampoco hay agua para beber.” ");
INSERT INTO spablm_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Moisés y Aarón salieron de la presencia de la asamblea a la puerta de la Tienda de Reunión y se postraron sobre sus rostros. La gloria de Yahvé se les apareció. ");
INSERT INTO spablm_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Toma la vara y reúne a la congregación, tú y Aarón, tu hermano, y habla a la roca ante sus ojos, para que derrame su agua. Les traerás agua de la roca; así darás de beber a la congregación y a sus ganados”. ");
INSERT INTO spablm_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Moisés tomó la vara de delante de Yahvé, como él le había ordenado. ");
INSERT INTO spablm_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Moisés y Aarón reunieron a la asamblea ante la roca, y les dijo: “¡Escuchen ahora, rebeldes! ¿Hemos de sacar agua de esta roca para ustedes?” ");
INSERT INTO spablm_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Moisés levantó su mano y golpeó la roca con su vara dos veces, y el agua salió en abundancia. La congregación y su ganado bebieron. ");
INSERT INTO spablm_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Yahvé dijo a Moisés y a Aarón: “Como no habéis creído en mí para santificarme a los ojos de los hijos de Israel, no introduciréis esta asamblea en la tierra que les he dado.” ");
INSERT INTO spablm_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Estas son las aguas de Meribá; porque los hijos de Israel lucharon con Yahvé, y él se santificó en ellas. ");
INSERT INTO spablm_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Moisés envió mensajeros desde Cades al rey de Edom, diciendo: “Tu hermano Israel dice: Tú sabes toda la aflicción que nos ha sucedido; ");
INSERT INTO spablm_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","cómo nuestros padres bajaron a Egipto, y vivimos en Egipto mucho tiempo. Los egipcios nos maltrataron a nosotros y a nuestros padres. ");
INSERT INTO spablm_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Cuando clamamos al Señor, él escuchó nuestra voz, envió un ángel y nos sacó de Egipto. He aquí que estamos en Cades, una ciudad en el límite de su frontera. ");
INSERT INTO spablm_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","“Por favor, déjanos pasar por tu tierra. No pasaremos por el campo ni por la viña, ni beberemos del agua de los pozos. Iremos por el camino del rey. No nos desviaremos a la derecha ni a la izquierda, hasta que hayamos pasado tu frontera”. ");
INSERT INTO spablm_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Edom le dijo: “No pasarás por mí, no sea que salga con la espada contra ti”. ");
INSERT INTO spablm_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Los hijos de Israel le dijeron: “Subiremos por el camino, y si bebemos tu agua, yo y mi ganado, te daré su precio. Sólo déjame, sin hacer nada más, pasar de pie”. ");
INSERT INTO spablm_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Dijo: “No pasarás”. Edom salió contra él con mucha gente y con mano dura. ");
INSERT INTO spablm_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Así, Edom se negó a dar paso a Israel por su frontera, por lo que Israel se alejó de él. ");
INSERT INTO spablm_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Partieron de Cades, y los hijos de Israel, toda la congregación, llegaron al monte Hor. ");
INSERT INTO spablm_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Yahvé habló a Moisés y a Aarón en el monte Hor, junto a la frontera de la tierra de Edom, diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Aarón será reunido con su pueblo, pues no entrará en la tierra que he dado a los hijos de Israel, porque os habéis rebelado contra mi palabra en las aguas de Meribá. ");
INSERT INTO spablm_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Toma a Aarón y a su hijo Eleazar, y llévalos al monte Hor; ");
INSERT INTO spablm_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","y despoja a Aarón de sus vestiduras, y pónselas a su hijo Eleazar. Aarón será recogido y morirá allí”. ");
INSERT INTO spablm_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Moisés hizo lo que Yahvé le ordenó. Subieron al monte Hor a la vista de toda la congregación. ");
INSERT INTO spablm_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Moisés despojó a Aarón de sus vestiduras y se las puso a su hijo Eleazar. Aarón murió allí, en la cima del monte, y Moisés y Eleazar bajaron del monte. ");
INSERT INTO spablm_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Cuando toda la congregación vio que Aarón había muerto, lloraron a Aarón durante treinta días, toda la casa de Israel. ");
INSERT INTO spablm_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","El cananeo, rey de Arad, que vivía en el sur, se enteró de que Israel venía por el camino de Atarim. Luchó contra Israel y tomó cautivos a algunos de ellos. ");
INSERT INTO spablm_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Israel hizo un voto a Yahvé y le dijo: “Si realmente entregas a este pueblo en mi mano, destruiré por completo sus ciudades.” ");
INSERT INTO spablm_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Yahvé escuchó la voz de Israel y entregó a los cananeos; y los destruyeron por completo a ellos y a sus ciudades. El nombre del lugar fue llamado Horma. ");
INSERT INTO spablm_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Viajaron desde el monte Hor por el camino del Mar Rojo, para rodear la tierra de Edom. El alma del pueblo estaba muy desanimada a causa del viaje. ");
INSERT INTO spablm_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","El pueblo hablaba contra Dios y contra Moisés: “¿Por qué nos has sacado de Egipto para morir en el desierto? Porque no hay pan, no hay agua, y nuestra alma aborrece esta comida repugnante”. ");
INSERT INTO spablm_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","El Señor envió serpientes venenosas entre el pueblo, y éstas mordieron al pueblo. Murió mucha gente de Israel. ");
INSERT INTO spablm_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","El pueblo se acercó a Moisés y le dijo: “Hemos pecado, porque hemos hablado contra Yahvé y contra ti. Ruega a Yahvé que nos quite las serpientes”. Moisés oró por el pueblo. ");
INSERT INTO spablm_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Yahvé dijo a Moisés: “Haz una serpiente venenosa y ponla en un poste. Sucederá que todo el que sea mordido, cuando la vea, vivirá”. ");
INSERT INTO spablm_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Moisés hizo una serpiente de bronce y la puso en el asta. Si una serpiente había mordido a algún hombre, cuando miraba la serpiente de bronce, vivía. ");
INSERT INTO spablm_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Los hijos de Israel partieron y acamparon en Obot. ");
INSERT INTO spablm_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Partieron de Obot y acamparon en Ije Abarim, en el desierto que está frente a Moab, hacia el amanecer. ");
INSERT INTO spablm_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","De allí partieron y acamparon en el valle de Zered. ");
INSERT INTO spablm_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","De allí partieron y acamparon al otro lado del Arnón, que está en el desierto que sale de la frontera del amorreo; porque el Arnón es la frontera de Moab, entre Moab y el amorreo. ");
INSERT INTO spablm_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Por eso se dice en el Libro de las Guerras de Yahvé: “Vaheb en Sufa, los valles del Arnón, ");
INSERT INTO spablm_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","la pendiente de los valles que se inclinan hacia la morada de Ar, se inclina sobre la frontera de Moab.” ");
INSERT INTO spablm_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Desde allí viajaron a Beer; ése es el pozo del que Yahvé dijo a Moisés: “Reúne al pueblo y les daré agua”. ");
INSERT INTO spablm_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Entonces Israel cantó esta canción: “¡Surge, pues! Cántale, ");
INSERT INTO spablm_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","el pozo que cavaron los príncipes, que los nobles del pueblo cavaron, con el cetro, y con sus varas”. Desde el desierto viajaron a Matana; ");
INSERT INTO spablm_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","y de Matana a Nahaliel; y de Nahaliel a Bamot; ");
INSERT INTO spablm_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","y de Bamot al valle que está en el campo de Moab, a la cima del Pisga, que mira hacia el desierto. ");
INSERT INTO spablm_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Israel envió mensajeros a Sehón, rey de los amorreos, diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Déjame pasar por tu tierra. No nos apartaremos del campo ni de la viña. No beberemos del agua de los pozos. Iremos por el camino del rey, hasta que hayamos pasado tu frontera”. ");
INSERT INTO spablm_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Sehón no permitió que Israel pasara por su frontera, pero Sehón reunió a todo su pueblo y salió contra Israel en el desierto, y llegó a Jahaz. Luchó contra Israel. ");
INSERT INTO spablm_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Israel lo hirió a filo de espada y se apoderó de su tierra desde Arnón hasta Jaboc, hasta los hijos de Amón, pues la frontera de los hijos de Amón estaba fortificada. ");
INSERT INTO spablm_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Israel tomó todas estas ciudades. Israel vivió en todas las ciudades de los amorreos, en Hesbón y en todas sus aldeas. ");
INSERT INTO spablm_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Porque Hesbón era la ciudad de Sehón, rey de los amorreos, que había luchado contra el antiguo rey de Moab y le había arrebatado toda su tierra hasta el Arnón. ");
INSERT INTO spablm_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Por eso dicen los que hablan en proverbios, “Ven a Hesbon. Que se construya y se establezca la ciudad de Sehón; ");
INSERT INTO spablm_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","porque el fuego ha salido de Hesbón, una llama de la ciudad de Sihon. Ha devorado a Ar de Moab, Los señores de los lugares altos del Arnón. ");
INSERT INTO spablm_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","¡Ay de ti, Moab! ¡Están deshechos, gente de Quemos! Ha entregado a sus hijos como fugitivos, y sus hijas en cautiverio, a Sehón, rey de los amorreos. ");
INSERT INTO spablm_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Les hemos disparado. Hesbón ha perecido hasta Dibón. Hemos arrasado incluso con Nofa, Que llega hasta Medeba”. ");
INSERT INTO spablm_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Así vivió Israel en la tierra de los amorreos. ");
INSERT INTO spablm_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Moisés envió a espiar a Jazer. Tomaron sus aldeas y expulsaron a los amorreos que estaban allí. ");
INSERT INTO spablm_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Se volvieron y subieron por el camino de Basán. Og, el rey de Basán, salió contra ellos, él y todo su pueblo, para combatir en Edrei. ");
INSERT INTO spablm_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","El Señor dijo a Moisés: “No le temas, porque lo he entregado en tu mano, con todo su pueblo y su tierra. Harás con él lo mismo que hiciste con Sehón, rey de los amorreos, que vivía en Hesbón”. ");
INSERT INTO spablm_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Así que lo hirieron, con sus hijos y todo su pueblo, hasta que no hubo sobrevivientes; y se apoderaron de su tierra. ");
INSERT INTO spablm_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Los hijos de Israel partieron y acamparon en las llanuras de Moab, al otro lado del Jordán, en Jericó. ");
INSERT INTO spablm_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Balac, hijo de Zipor, vio todo lo que Israel había hecho a los amorreos. ");
INSERT INTO spablm_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Moab tuvo mucho miedo del pueblo, porque era numeroso. Moab estaba angustiado a causa de los hijos de Israel. ");
INSERT INTO spablm_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Moab dijo a los ancianos de Madián: “Ahora esta multitud lamerá todo lo que nos rodea, como el buey lame la hierba del campo.” Balac hijo de Zipor era entonces rey de Moab. ");
INSERT INTO spablm_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Envió mensajeros a Balaam, hijo de Beor, a Petor, que está junto al río, a la tierra de los hijos de su pueblo, para llamarlo, diciendo: “He aquí que hay un pueblo que salió de Egipto. He aquí que cubren la superficie de la tierra, y se alojan frente a mí. ");
INSERT INTO spablm_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Por tanto, ven ahora y maldice a este pueblo por mí, porque es demasiado poderoso para mí. Tal vez prevalezca, para que los golpeemos y los expulse de la tierra; porque sé que el que bendices es bendito, y el que maldices es maldito.” ");
INSERT INTO spablm_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Los ancianos de Moab y los ancianos de Madián partieron con los premios de adivinación en la mano. Vinieron a Balaam y le hablaron de las palabras de Balac. ");
INSERT INTO spablm_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Les dijo: “Quédense aquí esta noche, y les traeré de nuevo la palabra, según me hable Yahvé”. Los príncipes de Moab se quedaron con Balaam. ");
INSERT INTO spablm_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Dios se acercó a Balaam y le dijo: “¿Quiénes son estos hombres que están contigo?” ");
INSERT INTO spablm_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balaam dijo a Dios: “Balac, hijo de Zipor, rey de Moab, me ha dicho: ");
INSERT INTO spablm_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘He aquí que el pueblo que ha salido de Egipto cubre la superficie de la tierra. Ahora, ven a maldecirlos por mí. Tal vez pueda luchar contra ellos y los expulse’”. ");
INSERT INTO spablm_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Dios dijo a Balaam: “No irás con ellos. No maldecirás al pueblo, porque está bendecido”. ");
INSERT INTO spablm_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Balaam se levantó por la mañana y dijo a los príncipes de Balac: “Vayan a su tierra, porque Yahvé no me permite ir con ustedes”. ");
INSERT INTO spablm_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Los príncipes de Moab se levantaron y fueron a ver a Balac y le dijeron: “Balaam se niega a venir con nosotros”. ");
INSERT INTO spablm_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Balac volvió a enviar príncipes, más, y más honorables que ellos. ");
INSERT INTO spablm_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Ellos vinieron a Balaam y le dijeron: “Balac, hijo de Zipor, dice: ‘Por favor, no dejes que nada te impida venir a mí, ");
INSERT INTO spablm_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","porque te ascenderé a un honor muy grande, y todo lo que me digas lo haré. Ven, pues, y maldice a este pueblo por mí’”. ");
INSERT INTO spablm_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Balaam respondió a los siervos de Balac: “Si Balac me diera su casa llena de plata y oro, no podría ir más allá de la palabra de Yahvé, mi Dios, para hacer menos o más. ");
INSERT INTO spablm_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Ahora, pues, quédate aquí también esta noche, para saber qué más me dirá Yahvé”. ");
INSERT INTO spablm_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Dios vino a Balaam de noche y le dijo: “Si los hombres han venido a llamarte, levántate y ve con ellos; pero sólo harás la palabra que yo te diga.” ");
INSERT INTO spablm_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Balaam se levantó por la mañana, ensilló su asno y se fue con los príncipes de Moab. ");
INSERT INTO spablm_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","La ira de Dios se encendió porque él iba, y el ángel de Yahvé se puso en el camino como adversario suyo. Iba montado en su asno, y lo acompañaban sus dos siervos. ");
INSERT INTO spablm_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","El asno vio al ángel de Yahvé parado en el camino, con su espada desenvainada en la mano; y el asno se apartó del camino y se metió en el campo. Balaam golpeó a la burra para hacerla volver al camino. ");
INSERT INTO spablm_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Entonces el ángel de Yahvé se paró en un sendero estrecho entre las viñas, con un muro a un lado y otro a otro. ");
INSERT INTO spablm_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","La burra vio al ángel de Yahvé, y se arrimó a la pared, y aplastó el pie de Balaam contra la pared. Él la golpeó de nuevo. ");
INSERT INTO spablm_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","El ángel de Yahvé fue más allá y se paró en un lugar estrecho, donde no había forma de girar ni a la derecha ni a la izquierda. ");
INSERT INTO spablm_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","La burra vio al ángel de Yahvé y se acostó debajo de Balaam. La ira de Balaam ardió, y golpeó a la burra con su bastón. ");
INSERT INTO spablm_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","El Señor abrió la boca de la burra, y ella le dijo a Balaam: “¿Qué te he hecho, para que me hayas golpeado estas tres veces?” ");
INSERT INTO spablm_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balaam dijo al asno: “Porque te has burlado de mí, ojalá tuviera una espada en la mano, porque ahora te habría matado”. ");
INSERT INTO spablm_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","El asno dijo a Balaam: “¿No soy yo tu asno, en el que has montado toda tu vida hasta hoy? ¿Acaso he tenido la costumbre de hacerlo contigo?” Dijo: “No”. ");
INSERT INTO spablm_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Entonces el Señor abrió los ojos de Balaam, y vio al ángel del Señor parado en el camino, con su espada desenvainada en la mano; e inclinó la cabeza y se postró sobre su rostro. ");
INSERT INTO spablm_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","El ángel de Yahvé le dijo: “¿Por qué has golpeado a tu asno estas tres veces? He aquí que he salido como adversario, porque tu camino es perverso ante mí. ");
INSERT INTO spablm_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","La burra me vio y se apartó ante mí estas tres veces. Si no se hubiera apartado de mí, seguramente ahora te habría matado a ti y la habría salvado con vida”. ");
INSERT INTO spablm_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balaam le dijo al ángel de Yahvé: “He pecado, pues no sabía que estabas en el camino contra mí. Ahora, pues, si te desagrada, volveré a regresar”. ");
INSERT INTO spablm_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","El ángel de Yahvé dijo a Balaam: “Ve con los hombres, pero sólo hablarás la palabra que yo te diga”. Entonces Balaam fue con los príncipes de Balac. ");
INSERT INTO spablm_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Cuando Balac oyó que Balaam había venido, salió a recibirlo a la ciudad de Moab, que está en la frontera de Arnón, que está en el extremo de la frontera. ");
INSERT INTO spablm_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balac le dijo a Balaam: “¿No envié a buscarte con insistencia para convocarte? ¿Por qué no viniste a mí? ¿Acaso no puedo promoverte a la honra?” ");
INSERT INTO spablm_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balaam dijo a Balac: “He aquí que he venido a ti. ¿Tengo ahora algún poder para hablar algo? Hablaré la palabra que Dios ponga en mi boca”. ");
INSERT INTO spablm_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Balaam fue con Balac, y llegaron a Quiriat Huzot. ");
INSERT INTO spablm_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Balac sacrificó ganado y ovejas, y envió a Balaam y a los príncipes que estaban con él. ");
INSERT INTO spablm_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Por la mañana, Balac tomó a Balaam y lo hizo subir a los lugares altos de Baal, y vio desde allí a parte del pueblo. ");
INSERT INTO spablm_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balaam dijo a Balac: “Construye aquí siete altares para mí, y prepara aquí siete becerros y siete carneros para mí”. ");
INSERT INTO spablm_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balac hizo lo que Balaam había dicho; y Balac y Balaam ofrecieron en cada altar un becerro y un carnero. ");
INSERT INTO spablm_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Balaam le dijo a Balac: “Quédate junto a tu holocausto, y yo me iré. Tal vez el Señor venga a mi encuentro. Lo que él me muestre te lo diré”. Se dirigió a una altura despojada. ");
INSERT INTO spablm_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Dios salió al encuentro de Balaam y le dijo: “He preparado los siete altares y he ofrecido un becerro y un carnero en cada altar.” ");
INSERT INTO spablm_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Yahvé puso una palabra en la boca de Balaam y le dijo: “Vuelve a Balac y así hablarás”. ");
INSERT INTO spablm_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Volvió a él, y he aquí que estaba junto a su holocausto, él y todos los príncipes de Moab. ");
INSERT INTO spablm_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Tomó su parábola y dijo, “De Aram me ha traído Balak, el rey de Moab desde las montañas del Este. Ven, maldice a Jacob por mí. Ven, desafía a Israel. ");
INSERT INTO spablm_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","¿Cómo voy a maldecir a quien Dios no ha maldecido? ¿Cómo voy a desafiar a quien Yahvé no ha desafiado? ");
INSERT INTO spablm_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Porque desde lo alto de las rocas lo veo. Desde las colinas lo veo. He aquí que es un pueblo que habita solo, y no será catalogado entre las naciones. ");
INSERT INTO spablm_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Quién puede contar el polvo de Jacob, o contar la cuarta parte de Israel? ¡Dejadme morir como los justos! ¡Que mi último final sea como el suyo!” ");
INSERT INTO spablm_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Balac dijo a Balaam: “¿Qué me has hecho? Te tomé para maldecir a mis enemigos, y he aquí que los has bendecido por completo”. ");
INSERT INTO spablm_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Respondió y dijo: “¿No debo tener cuidado de decir lo que Yahvé pone en mi boca?” ");
INSERT INTO spablm_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Balac le dijo: “Por favor, ven conmigo a otro lugar, donde puedas verlos. Sólo verás una parte de ellos, y no los verás todos. Maldícelos desde allí por mí”. ");
INSERT INTO spablm_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Lo llevó al campo de Zofim, a la cima del Pisga, y construyó siete altares, y ofreció un toro y un carnero en cada altar. ");
INSERT INTO spablm_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Le dijo a Balac: “Quédate aquí con tu holocausto, mientras yo me encuentro con Dios allá”. ");
INSERT INTO spablm_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Yahvé salió al encuentro de Balaam y puso una palabra en su boca, diciendo: “Vuelve a Balac y dile esto”. ");
INSERT INTO spablm_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Se acercó a él, y he aquí que estaba de pie junto a su holocausto, y los príncipes de Moab con él. Balac le dijo: “¿Qué ha dicho Yahvé?” ");
INSERT INTO spablm_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Retomó su parábola y dijo, “¡Levántate, Balak, y escucha! Escúchame, hijo de Zippor. ");
INSERT INTO spablm_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Dios no es un hombre, para que mienta, ni hijo de hombre, que se arrepienta. ¿Ha dicho, y no lo hará? ¿O ha hablado y no lo hará bien? ");
INSERT INTO spablm_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","He aquí que he recibido la orden de bendecir. Ha bendecido, y no puedo revertirlo. ");
INSERT INTO spablm_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","No ha visto iniquidad en Jacob. Tampoco ha visto perversidad en Israel. Yahvé, su Dios, está con él. El grito de un rey está entre ellos. ");
INSERT INTO spablm_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Dios los saca de Egipto. Tiene como la fuerza del búfalo salvaje. ");
INSERT INTO spablm_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Seguramente no hay ningún encantamiento con Jacob; tampoco hay adivinación con Israel. Ahora se dirá de Jacob y de Israel, “¡Qué ha hecho Dios! ");
INSERT INTO spablm_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","He aquí que un pueblo se levanta como una leona. Como un león se levanta. No se echará hasta que coma de la presa, y beba la sangre de los muertos”. ");
INSERT INTO spablm_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Balac dijo a Balaam: “Ni los maldigas, ni los bendigas”. ");
INSERT INTO spablm_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Pero Balaam respondió a Balac: “¿No te dije que todo lo que diga Yahvé lo tengo que hacer?” ");
INSERT INTO spablm_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Balac dijo a Balaam: “Ven ahora, te llevaré a otro lugar; tal vez le plazca a Dios que los maldigas por mí desde allí”. ");
INSERT INTO spablm_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Balac llevó a Balaam a la cima de Peor, que da al desierto. ");
INSERT INTO spablm_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Balaam le dijo a Balac: “Construye aquí siete altares para mí, y prepara aquí siete becerros y siete carneros”. ");
INSERT INTO spablm_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balac hizo lo que había dicho Balaam, y ofreció un becerro y un carnero en cada altar. ");
INSERT INTO spablm_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Cuando Balaam vio que a Yahvé le agradaba bendecir a Israel, no fue, como las otras veces, a usar la adivinación, sino que puso su rostro hacia el desierto. ");
INSERT INTO spablm_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Balaam levantó sus ojos y vio a Israel habitando según sus tribus, y el Espíritu de Dios vino sobre él. ");
INSERT INTO spablm_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Tomó su parábola y dijo “Balaam el hijo de Beor dice, el hombre que tiene los ojos abiertos dice; ");
INSERT INTO spablm_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","dice, que escucha las palabras de Dios, que ve la visión del Todopoderoso, cayendo, y teniendo los ojos abiertos: ");
INSERT INTO spablm_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Qué buenas son tus tiendas, Jacob, ¡y tus moradas, Israel! ");
INSERT INTO spablm_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Como valles se extienden, como jardines a la orilla del río, como áloes que Yahvé ha plantado, como los cedros junto a las aguas. ");
INSERT INTO spablm_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","El agua fluirá de sus cubos. Su semilla estará en muchas aguas. Su rey será más alto que Agag. Su reino será exaltado. ");
INSERT INTO spablm_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Dios lo saca de Egipto. Tiene como la fuerza de un búfalo salvaje. Consumirá a las naciones sus adversarios, romperá sus huesos en pedazos, y los atravesará con sus flechas. ");
INSERT INTO spablm_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Se acuesta, se acuesta como un león, como una leona; ¿quién lo despertará? Todos los que te bendicen son bendecidos. Todo el que te maldiga está maldito”. ");
INSERT INTO spablm_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","La ira de Balac ardió contra Balaam, y éste se golpeó las manos. Balac dijo a Balaam: “Te llamé para que maldijeras a mis enemigos, y he aquí que los has bendecido por completo estas tres veces. ");
INSERT INTO spablm_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Por lo tanto, ¡huye ahora a tu lugar! Yo pensaba promoverte a un gran honor; pero, he aquí, Yahvé te ha alejado del honor”. ");
INSERT INTO spablm_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balaam le dijo a Balac: “¿No les dije también a tus mensajeros que me enviaste, diciéndoles: ");
INSERT INTO spablm_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘Si Balac me da su casa llena de plata y oro, no puedo ir más allá de la palabra de Yahvé, para hacer el bien o el mal de mi propia mente. Diré lo que dice Yahvé’? ");
INSERT INTO spablm_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Ahora, he aquí que voy a mi pueblo. Ven, te informaré de lo que este pueblo hará a tu pueblo en los últimos días”. ");
INSERT INTO spablm_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Retomó su parábola y dijo, “Balaam el hijo de Beor dice, el hombre que tiene los ojos abiertos dice; ");
INSERT INTO spablm_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","dice, que escucha las palabras de Dios, conoce el conocimiento del Altísimo, y que ve la visión del Todopoderoso, cayendo, y teniendo los ojos abiertos: ");
INSERT INTO spablm_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Lo veo, pero no ahora. Lo veo, pero no cerca. Una estrella saldrá de Jacob. Un cetro se levantará de Israel, y golpeará los rincones de Moab, y aplastar a todos los hijos de Set. ");
INSERT INTO spablm_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Edom será una posesión. Seir, su enemigo, también será una posesión, mientras que Israel lo hace valientemente. ");
INSERT INTO spablm_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","De Jacob uno tendrá el dominio, y destruirá el remanente de la ciudad”. ");
INSERT INTO spablm_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Miró a Amalec, retomó su parábola y dijo, “Amalec fue la primera de las naciones, pero su último fin será la destrucción”. ");
INSERT INTO spablm_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Miró al ceneo, retomó su parábola y dijo “Tu morada es fuerte. Su nido está enclavado en la roca. ");
INSERT INTO spablm_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Sin embargo, Caín será destruido, hasta que Asur te lleve cautivo”. ");
INSERT INTO spablm_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Retomó su parábola y dijo, “Ay, ¿quién vivirá cuando Dios haga esto? ");
INSERT INTO spablm_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Pero los barcos vendrán de la costa de Kittim. Afligirán a Asur y afligirán a Éber. También él vendrá a la destrucción”. ");
INSERT INTO spablm_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Balaam se levantó, y se fue y volvió a su lugar; y Balac también se fue. ");
INSERT INTO spablm_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Israel se quedó en Sitim, y el pueblo comenzó a prostituirse con las hijas de Moab; ");
INSERT INTO spablm_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","pues llamaron al pueblo a los sacrificios de sus dioses. El pueblo comía y se inclinaba ante sus dioses. ");
INSERT INTO spablm_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Israel se unió a Baal Peor, y la ira de Yahvé ardió contra Israel. ");
INSERT INTO spablm_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Yahvé dijo a Moisés: reúne a todos los jefes del pueblo y ahórcalos delante de mí, “Toma a todos los jefes del pueblo a Yahvé ante el sol, para que el furor de Yahvé se aparte de Israel.” ");
INSERT INTO spablm_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Moisés dijo a los jueces de Israel: “Maten todos a sus hombres que se han unido a Baal Peor”. ");
INSERT INTO spablm_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","He aquí que uno de los hijos de Israel vino y trajo a sus hermanos una mujer madianita a la vista de Moisés y de toda la congregación de los hijos de Israel, mientras lloraban a la puerta de la Tienda de Reunión. ");
INSERT INTO spablm_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Cuando Finees, hijo de Eleazar, hijo del sacerdote Aarón, lo vio, se levantó de en medio de la congregación y tomó una lanza en su mano. ");
INSERT INTO spablm_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","Fue tras el hombre de Israel al pabellón, y los atravesó a ambos, al hombre de Israel y a la mujer por el cuerpo. Así se detuvo la plaga entre los hijos de Israel. ");
INSERT INTO spablm_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Los que murieron por la plaga fueron veinticuatro mil. ");
INSERT INTO spablm_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Yahvé habló a Moisés y le dijo: ");
INSERT INTO spablm_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Finees, hijo de Eleazar, hijo del sacerdote Aarón, ha alejado mi ira de los hijos de Israel, ya que se puso celoso con mis celos entre ellos, para que yo no consumiera a los hijos de Israel en mis celos. ");
INSERT INTO spablm_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Por tanto, di: “He aquí que yo le doy mi pacto de paz. ");
INSERT INTO spablm_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Será para él, y para su descendencia después de él, el pacto de un sacerdocio eterno, porque fue celoso por su Dios e hizo expiación por los hijos de Israel.’” ");
INSERT INTO spablm_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","El nombre del hombre de Israel que fue asesinado con la mujer madianita era Zimri, hijo de Salu, príncipe de una casa paterna entre los simeonitas. ");
INSERT INTO spablm_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","El nombre de la mujer madianita que fue asesinada era Cozbi, hija de Zur. Era jefe de la gente de una casa paterna en Madián. ");
INSERT INTO spablm_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Acosa a los madianitas y atácalos; ");
INSERT INTO spablm_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","porque te han acosado con sus artimañas, en las que te han engañado en el asunto de Peor, y en el incidente relativo a Cozbi, la hija del príncipe de Madián, su hermana, que fue asesinada el día de la plaga en el asunto de Peor.” ");
INSERT INTO spablm_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Después de la plaga, Yahvé habló a Moisés y al sacerdote Eleazar hijo de Aarón, diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Hagan un censo de toda la congregación de los hijos de Israel, de veinte años en adelante, por las casas de sus padres, todos los que puedan salir a la guerra en Israel.” ");
INSERT INTO spablm_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Moisés y el sacerdote Eleazar hablaron con ellos en las llanuras de Moab, junto al Jordán, en Jericó, diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“Hagan un censo, de veinte años en adelante, como Yahvé les ordenó a Moisés y a los hijos de Israel.” Estos son los que salieron de la tierra de Egipto. ");
INSERT INTO spablm_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Rubén, el primogénito de Israel; los hijos de Rubén: de Hanoc, la familia de los Hanocitas; de Falú, la familia de los Falúitas; ");
INSERT INTO spablm_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","de Esrom, la familia de los Esromitas; de Carmi, la familia de los Carmitas. ");
INSERT INTO spablm_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Estas son las familias de los rubenitas; y los contados de ellas fueron cuarenta y tres mil setecientos treinta. ");
INSERT INTO spablm_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","El hijo de Pallu: Eliab. ");
INSERT INTO spablm_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Los hijos de Eliab: Nemuel, Datán y Abiram. Estos son aquellos Datán y Abiram que fueron llamados por la congregación, que se rebelaron contra Moisés y contra Aarón en la compañía de Coré cuando se rebelaron contra Yahvé; ");
INSERT INTO spablm_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","y la tierra abrió su boca y los tragó junto con Coré cuando esa compañía murió; en ese momento el fuego devoró a doscientos cincuenta hombres, y se convirtieron en una señal. ");
INSERT INTO spablm_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Sin embargo, los hijos de Coré no murieron. ");
INSERT INTO spablm_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Los hijos de Simeón por sus familias: de Nemuel, la familia de los nemuelitas; de Jamín, la familia de los jaminitas; de Jaquín, la familia de los jaquinitas; ");
INSERT INTO spablm_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","de Zera, la familia de los zeraítas; de Saúl, la familia de los shaúlitas. ");
INSERT INTO spablm_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Estas son las familias de los simeonitas, veintidós mil doscientos. ");
INSERT INTO spablm_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Los hijos de Gad por sus familias: de Zefón, la familia de los zefonitas; de Haggi, la familia de los haggitas; de Suni, la familia de los sunitas; ");
INSERT INTO spablm_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","de Ozni, la familia de los oznitas; de Eri, la familia de los eritas; ");
INSERT INTO spablm_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","de Arod, la familia de los aroditas; de Areli, la familia de los arelitas. ");
INSERT INTO spablm_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Estas son las familias de los hijos de Gad según los contados de ellos, cuarenta mil quinientos. ");
INSERT INTO spablm_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Los hijos de Judá: Er y Onán. Er y Onán murieron en la tierra de Canaán. ");
INSERT INTO spablm_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Los hijos de Judá por sus familias fueron: de Selá, la familia de los selanitas; de Fares, la familia de los pérezicos; de Zera, la familia de los zeraitas. ");
INSERT INTO spablm_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Los hijos de Fares fueron: de Esrom, la familia de los Esromitas; de Hamul, la familia de los hamulitas. ");
INSERT INTO spablm_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Estas son las familias de Judá según los contados de ellas, setenta y seis mil quinientos. ");
INSERT INTO spablm_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Los hijos de Isacar por sus familias: de Tola, la familia de los tolaítas; de Puva, la familia de los punítas; ");
INSERT INTO spablm_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","de Jasub, la familia de los jasubitas; de Simrón, la familia de los simronitas. ");
INSERT INTO spablm_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Estas son las familias de Isacar según los contados de ellas, sesenta y cuatro mil trescientos. ");
INSERT INTO spablm_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Los hijos de Zabulón por sus familias: de Sered, la familia de los sereditas; de Elón, la familia de los elonitas; de Jahleel, la familia de los jahleelitas. ");
INSERT INTO spablm_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Estas son las familias de los zabulonitas según los contados de ellos, sesenta mil quinientos. ");
INSERT INTO spablm_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Los hijos de José según sus familias: Manasés y Efraín. ");
INSERT INTO spablm_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Los hijos de Manasés: de Maquir, la familia de los maquiritas; y Maquir fue el padre de Galaad; de Galaad, la familia de los galaaditas. ");
INSERT INTO spablm_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Estos son los hijos de Galaad: de Jezer, la familia de los Jezeritas; de Helec, la familia de los Helequitas; ");
INSERT INTO spablm_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","y de Asriel, la familia de los Asrielitas; y de Siquem, la familia de los Siquemitas; ");
INSERT INTO spablm_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","y de Semida, la familia de los Semidaitas; y de Hefer, la familia de los Heferitas. ");
INSERT INTO spablm_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Zelofehad, hijo de Hefer, no tuvo hijos, sino hijas; y los nombres de las hijas de Zelofehad fueron Maalá, Noa, Hogiá, Milca y Tirsa. ");
INSERT INTO spablm_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Estas son las familias de Manasés. Los contados de ellos fueron cincuenta y dos mil setecientos. ");
INSERT INTO spablm_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Estos son los hijos de Efraín por sus familias: de Sutela, la familia de los Sutelitas; de Bequer, la familia de los Bequeritas; de Tahan, la familia de los Tahanitas. ");
INSERT INTO spablm_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Estos son los hijos de Sutela: de Erán, la familia de los eranitas. ");
INSERT INTO spablm_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Estas son las familias de los hijos de Efraín, según los contados de ellos, treinta y dos mil quinientos. Estos son los hijos de José por sus familias. ");
INSERT INTO spablm_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Los hijos de Benjamín por sus familias: de Bela, la familia de los belaítas; de Asbel, la familia de los asbelitas; de Ahiram, la familia de los ahiramitas; ");
INSERT INTO spablm_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","de Sefufam, la familia de los sefufamitas; de Hufam, la familia de los hufamitas. ");
INSERT INTO spablm_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Los hijos de Bela fueron Ard y Naamán: la familia de los arditas; y de Naamán, la familia de los naamitas. ");
INSERT INTO spablm_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Estos son los hijos de Benjamín por sus familias; y los contados de ellos fueron cuarenta y cinco mil seiscientos. ");
INSERT INTO spablm_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Estos son los hijos de Dan por sus familias: de Suham, la familia de los suhamitas. Estas son las familias de Dan por sus familias. ");
INSERT INTO spablm_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Todas las familias de los suhamitas, según los contados de ellos, fueron sesenta y cuatro mil cuatrocientos. ");
INSERT INTO spablm_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Los hijos de Aser por sus familias: de Imna, la familia de los imnitas; de Imna, la familia de los imnitas; de Beriá, la familia de los beritas. ");
INSERT INTO spablm_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","De los hijos de Beriá: de Heber, la familia de los heberitas; de Malquiel, la familia de los malquielitas. ");
INSERT INTO spablm_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","El nombre de la hija de Aser fue Sera. ");
INSERT INTO spablm_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Estas son las familias de los hijos de Aser según los contados de ellos, cincuenta y tres mil cuatrocientos. ");
INSERT INTO spablm_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Los hijos de Neftalí por sus familias: de Jahzeel, la familia de los jahzeelitas; de Guni, la familia de los gunitas; ");
INSERT INTO spablm_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","de Jezer, la familia de los jezeritas; de Silem, la familia de los silemitas. ");
INSERT INTO spablm_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Estas son las familias de Neftalí según sus familias; y los contados de ellas fueron cuarenta y cinco mil cuatrocientos. ");
INSERT INTO spablm_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Estos son los contados de los hijos de Israel, seiscientos un mil setecientos treinta. ");
INSERT INTO spablm_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Yahvé habló a Moisés diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“A éstos se les repartirá la tierra en herencia según el número de nombres. ");
INSERT INTO spablm_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","A los más les darás más herencia, y a los menos les darás menos herencia. A cada uno se le dará su herencia según los contados de él. ");
INSERT INTO spablm_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Sin embargo, la tierra se dividirá por sorteo. Según los nombres de las tribus de sus padres heredarán. ");
INSERT INTO spablm_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Según la suerte se repartirá su herencia entre los más y los menos”. ");
INSERT INTO spablm_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Estos son los contados de los levitas según sus familias: de Gersón, la familia de los gersonitas; de Coat, la familia de los coatitas; de Merari, la familia de los meraritas. ");
INSERT INTO spablm_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Estas son las familias de Leví: la familia de los libnitas, la familia de los hebronitas, la familia de los mahlitas, la familia de los musitas y la familia de los coreitas. Coat fue el padre de Amram. ");
INSERT INTO spablm_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","El nombre de la esposa de Amram era Jocabed, hija de Leví, que había nacido de Leví en Egipto. Ella dio a luz a Amram, a Aarón y a Moisés, y a su hermana Miriam. ");
INSERT INTO spablm_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","De Aarón nacieron Nadab y Abiú, Eleazar e Itamar. ");
INSERT INTO spablm_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Nadab y Abiú murieron cuando ofrecieron fuego extraño ante Yahvé. ");
INSERT INTO spablm_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Los que fueron contados de ellos fueron veintitrés mil, todos los varones de un mes para arriba; pues no fueron contados entre los hijos de Israel, porque no se les dio herencia entre los hijos de Israel. ");
INSERT INTO spablm_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Estos son los que fueron contados por Moisés y el sacerdote Eleazar, quienes contaron a los hijos de Israel en los llanos de Moab, junto al Jordán de Jericó. ");
INSERT INTO spablm_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Pero entre éstos no hubo ninguno de los que fueron contados por Moisés y el sacerdote Aarón, que contaron a los hijos de Israel en el desierto de Sinaí. ");
INSERT INTO spablm_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Porque Yahvé había dicho de ellos: “Ciertamente morirán en el desierto”. No quedó ningún hombre de ellos, excepto Caleb, hijo de Jefone, y Josué, hijo de Nun. ");
INSERT INTO spablm_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Entonces se acercaron las hijas de Zelofehad, hijo de Hefer, hijo de Galaad, hijo de Maquir, hijo de Manasés, de las familias de Manasés hijo de José. Estos son los nombres de sus hijas: Maala, Noa, Hogla, Milca y Tirsa. ");
INSERT INTO spablm_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Se presentaron ante Moisés, ante el sacerdote Eleazar y ante los príncipes y toda la congregación, a la puerta de la Tienda del Encuentro, diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Nuestro padre murió en el desierto. No estaba entre la compañía de los que se agruparon contra Yahvé en compañía de Coré, sino que murió en su propio pecado. No tuvo hijos. ");
INSERT INTO spablm_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","¿Por qué se ha de quitar el nombre de nuestro padre de entre su familia, porque no tuvo hijo? Danos una posesión entre los hermanos de nuestro padre”. ");
INSERT INTO spablm_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Moisés llevó su causa ante el Señor. ");
INSERT INTO spablm_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Las hijas de Zelofehad hablan con razón. Ciertamente les darás posesión de una herencia entre los hermanos de su padre. Harás que la herencia de su padre pase a ellas. ");
INSERT INTO spablm_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Hablarás a los hijos de Israel diciendo: “Si un hombre muere y no tiene hijo, harás que su herencia pase a su hija. ");
INSERT INTO spablm_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Si no tiene hija, darás su herencia a sus hermanos. ");
INSERT INTO spablm_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Si no tiene hermanos, darás su herencia a los hermanos de su padre. ");
INSERT INTO spablm_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Si su padre no tiene hermanos, entonces darás su herencia a su pariente más cercano de su familia, y él la poseerá. Esto será un estatuto y una ordenanza para los hijos de Israel, como Yahvé le ordenó a Moisés”. ");
INSERT INTO spablm_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Yahvé dijo a Moisés: “Sube a este monte de Abarim y ve la tierra que he dado a los hijos de Israel. ");
INSERT INTO spablm_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Cuando la hayas visto, tú también serás reunido con tu pueblo, como fue reunido tu hermano Aarón; ");
INSERT INTO spablm_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","porque en la contienda de la congregación, te rebelaste contra mi palabra en el desierto de Zin, para honrarme como santo en las aguas ante sus ojos.” (Estas son las aguas de Meriba de Cades en el desierto de Zin). ");
INSERT INTO spablm_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Moisés habló a Yahvé, diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Que Yahvé, el Dios de los espíritus de toda carne, designe a un hombre sobre la congregación, ");
INSERT INTO spablm_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","que salga delante de ellos, y que entre delante de ellos, y que los conduzca fuera, y que los haga entrar, para que la congregación de Yahvé no sea como ovejas que no tienen pastor.” ");
INSERT INTO spablm_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","El Señor dijo a Moisés: “Toma a Josué, hijo de Nun, un hombre en el que está el Espíritu, y pon tu mano sobre él. ");
INSERT INTO spablm_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Ponlo delante del sacerdote Eleazar y de toda la congregación, y encárgalo ante ellos. ");
INSERT INTO spablm_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Le darás autoridad, para que toda la congregación de los hijos de Israel obedezca. ");
INSERT INTO spablm_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Se presentará ante el sacerdote Eleazar, quien preguntará por él con el juicio del Urim ante Yahvé. A su palabra saldrán, y a su palabra entrarán, él y todos los hijos de Israel con él, toda la congregación.” ");
INSERT INTO spablm_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Moisés hizo lo que el Señor le había ordenado. Tomó a Josué y lo presentó ante el sacerdote Eleazar y ante toda la congregación. ");
INSERT INTO spablm_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Le impuso las manos y lo comisionó, tal como Yahvé habló por medio de Moisés. ");
INSERT INTO spablm_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“Ordena a los hijos de Israel y diles: ‘Procuren presentar mi ofrenda, mi alimento para mis ofrendas encendidas, como aroma agradable para mí, a su debido tiempo’. ");
INSERT INTO spablm_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Les dirás: ‘Esta es la ofrenda encendida que ofrecerás a Yahvé: corderos machos de un año sin defecto, dos al día, para un holocausto continuo. ");
INSERT INTO spablm_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Ofrecerás un cordero por la mañana, y ofrecerás el otro cordero al atardecer, ");
INSERT INTO spablm_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","con la décima parte de un efa de harina fina como ofrenda, mezclada con la cuarta parte de un hin de aceite batido. ");
INSERT INTO spablm_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Es un holocausto continuo que fue ordenado en el monte Sinaí como aroma agradable, una ofrenda hecha por fuego a Yahvé. ");
INSERT INTO spablm_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Su libación será la cuarta parte de un hin por cada cordero. Derramarás una libación de bebida fuerte a Yahvé en el lugar santo. ");
INSERT INTO spablm_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","El otro cordero lo ofrecerás al atardecer. Como la ofrenda de la mañana, y como su libación, lo ofrecerás, ofrenda encendida, como aroma agradable a Yahvé. ");
INSERT INTO spablm_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“‘En el día de reposo, ofrecerás dos corderos machos de un año sin defecto, y dos décimas de efa de harina fina como ofrenda mezclada con aceite, y su libación: ");
INSERT INTO spablm_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Este es el holocausto de cada sábado, además del holocausto continuo y su libación. ");
INSERT INTO spablm_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“‘En los comienzos de tus meses, ofrecerás un holocausto a Yahvé dos novillos, un carnero, siete corderos machos de un año sin defecto, ");
INSERT INTO spablm_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","y tres décimas de un efa de harina fina para un holocausto mezclado con aceite, para cada toro; y dos décimas de harina fina para un holocausto mezclado con aceite, para el único carnero; ");
INSERT INTO spablm_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","y una décima de harina fina mezclada con aceite para un holocausto a cada cordero, como ofrenda quemada de aroma agradable, ofrenda hecha por fuego a Yahvé. ");
INSERT INTO spablm_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Sus libaciones serán la mitad de un hin de vino para el becerro, la tercera parte de un hin para el carnero y la cuarta parte de un hin para el becerro. Este es el holocausto de cada mes durante todos los meses del año. ");
INSERT INTO spablm_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","También se ofrecerá un macho cabrío como ofrenda por el pecado a Yahvé, además del holocausto continuo y su libación. ");
INSERT INTO spablm_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“‘En el primer mes, el día catorce del mes, es la Pascua de Yahvé. ");
INSERT INTO spablm_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","El decimoquinto día de este mes habrá una fiesta. Se comerá pan sin levadura durante siete días. ");
INSERT INTO spablm_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","En el primer día habrá una santa convocación. No harás ningún trabajo regular, ");
INSERT INTO spablm_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","sino que ofrecerás una ofrenda encendida, un holocausto a Yahvé: dos novillos, un carnero y siete corderos de un año. Serán sin defecto, ");
INSERT INTO spablm_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","con su ofrenda de harina, harina fina mezclada con aceite. Ofrecerás tres décimas por el becerro, y dos décimas por el carnero. ");
INSERT INTO spablm_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","Ofrecerás una décima por cada cordero de los siete corderos; ");
INSERT INTO spablm_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","y un macho cabrío como ofrenda por el pecado, para hacer expiación por ti. ");
INSERT INTO spablm_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Los ofrecerás además del holocausto de la mañana, que es un holocausto continuo. ");
INSERT INTO spablm_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Así ofrecerás cada día, durante siete días, el alimento de la ofrenda encendida, de aroma agradable para Yahvé. Se ofrecerá además del holocausto continuo y su libación. ");
INSERT INTO spablm_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","El séptimo día tendréis una santa convocación. No harás ningún trabajo regular. ");
INSERT INTO spablm_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“‘También en el día de las primicias, cuando ofrezcas una nueva ofrenda a Yahvé en tu fiesta de las semanas, tendrás una santa convocación. No harás ningún trabajo regular; ");
INSERT INTO spablm_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","sino que ofrecerás un holocausto como aroma agradable a Yahvé: dos novillos, un carnero, siete corderos macho de un año; ");
INSERT INTO spablm_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","y su ofrenda de harina fina mezclada con aceite, tres décimas por cada becerro, dos décimas por el único carnero, ");
INSERT INTO spablm_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","una décima por cada cordero de los siete corderos; ");
INSERT INTO spablm_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","y un macho cabrío, para hacer expiación por ti. ");
INSERT INTO spablm_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Además del holocausto continuo y su ofrenda de comida, los ofrecerás junto con sus libaciones. Procura que sean sin defecto. ");
INSERT INTO spablm_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“‘En el séptimo mes, el primer día del mes, tendréis una santa convocación; no haréis ningún trabajo regular. Es un día de toque de trompetas para ti. ");
INSERT INTO spablm_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Ofrecerás un holocausto como aroma agradable a Yahvé: un novillo, un carnero, siete corderos machos de un año sin defecto; ");
INSERT INTO spablm_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","y su ofrenda de harina fina mezclada con aceite: tres décimas por el becerro, dos décimas por el carnero, ");
INSERT INTO spablm_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","y una décima por cada cordero de los siete corderos; ");
INSERT INTO spablm_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","y un macho cabrío como ofrenda por el pecado, para hacer expiación por vosotros; ");
INSERT INTO spablm_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","además del holocausto de la luna nueva con su ofrenda, y el holocausto continuo con su ofrenda, y sus libaciones, según su ordenanza, como aroma agradable, ofrenda encendida a Yahvé. ");
INSERT INTO spablm_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“‘En el décimo día de este séptimo mes tendréis una santa convocación. Afligiréis vuestras almas. No haréis ninguna clase de trabajo; ");
INSERT INTO spablm_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","sino que ofreceréis a Yahvé un holocausto como aroma agradable: un novillo, un carnero, siete corderos macho de un año, todos sin defecto; ");
INSERT INTO spablm_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","y su ofrenda de harina fina mezclada con aceite: tres décimas por el becerro, dos décimas por el único carnero, ");
INSERT INTO spablm_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","una décima por cada cordero de los siete corderos; ");
INSERT INTO spablm_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","un macho cabrío como ofrenda por el pecado, además de la ofrenda por el pecado de la expiación, y el holocausto continuo, y su ofrenda de comida, y sus libaciones. ");
INSERT INTO spablm_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“‘El decimoquinto día del séptimo mes tendrás una santa convocación. No harás ningún trabajo regular. Celebrarás una fiesta a Yahvé durante siete días. ");
INSERT INTO spablm_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Ofrecerás un holocausto, una ofrenda encendida, de aroma agradable a Yahvé: trece novillos, dos carneros, catorce corderos machos de un año, todos sin defecto; ");
INSERT INTO spablm_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","y su ofrenda de harina fina mezclada con aceite: tres décimas por cada becerro de los trece becerros, dos décimas por cada carnero de los dos carneros, ");
INSERT INTO spablm_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","y una décima por cada cordero de los catorce corderos; ");
INSERT INTO spablm_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","y un macho cabrío para la ofrenda por el pecado, además del holocausto continuo, su ofrenda y su libación. ");
INSERT INTO spablm_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“‘El segundo día ofrecerás doce novillos, dos carneros y catorce corderos machos de un año sin defecto; ");
INSERT INTO spablm_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","y su ofrenda y su libación por los becerros, por los carneros y por los corderos, según su número, conforme a la ordenanza; ");
INSERT INTO spablm_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","y un macho cabrío como ofrenda por el pecado, además del holocausto continuo, con su ofrenda y su libación. ");
INSERT INTO spablm_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“‘Al tercer día: once becerros, dos carneros, catorce corderos machos de un año sin defecto; ");
INSERT INTO spablm_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","y su ofrenda y su libación por los becerros, por los carneros y por los corderos, según su número, conforme a la ordenanza; ");
INSERT INTO spablm_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","y un macho cabrío como ofrenda por el pecado, además del holocausto continuo, y su ofrenda y su libación. ");
INSERT INTO spablm_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“‘Al cuarto día diez becerros, dos carneros, catorce corderos machos de un año sin defecto; ");
INSERT INTO spablm_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","su ofrenda y su libación por los becerros, por los carneros y por los corderos, según su número, conforme a la ordenanza; ");
INSERT INTO spablm_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","y un macho cabrío como ofrenda por el pecado; además del holocausto continuo, su ofrenda y su libación. ");
INSERT INTO spablm_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“‘Al quinto día: nueve becerros, dos carneros, catorce corderos machos de un año sin defecto; ");
INSERT INTO spablm_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","y su ofrenda y su libación por los becerros, por los carneros y por los corderos, según su número, conforme a la ordenanza, ");
INSERT INTO spablm_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","y un macho cabrío como ofrenda por el pecado, además del holocausto continuo, y su ofrenda y su libación. ");
INSERT INTO spablm_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“‘En el sexto día: ocho becerros, dos carneros, catorce corderos machos de un año sin defecto; ");
INSERT INTO spablm_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","y su ofrenda y su libación por los becerros, por los carneros y por los corderos, según su número, conforme a la ordenanza, ");
INSERT INTO spablm_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","y un macho cabrío como ofrenda por el pecado; además del holocausto continuo, su ofrenda y su libación. ");
INSERT INTO spablm_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“‘En el séptimo día: siete becerros, dos carneros, catorce corderos machos de un año sin defecto; ");
INSERT INTO spablm_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","y su ofrenda y su libación por los becerros, por los carneros y por los corderos, según su número, conforme a la ordenanza, ");
INSERT INTO spablm_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","y un macho cabrío como ofrenda por el pecado; además del holocausto continuo, su ofrenda y su libación. ");
INSERT INTO spablm_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“‘El octavo día tendrás una asamblea solemne. No harás ningún trabajo regular; ");
INSERT INTO spablm_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","sino que ofrecerás un holocausto, una ofrenda encendida, un aroma agradable a Yahvé: un becerro, un carnero, siete corderos machos de un año sin defecto; ");
INSERT INTO spablm_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","su ofrenda y su libación por el becerro, por el carnero y por los corderos, serán según su número, conforme a la ordenanza, ");
INSERT INTO spablm_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","y un macho cabrío como ofrenda por el pecado, además del holocausto continuo, con su ofrenda y su libación. ");
INSERT INTO spablm_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“‘Ofrecerás esto a Yahvé en tus fiestas establecidas — además de tus votos y tus ofrendas voluntarias — para tus holocaustos, tus ofrendas de comida, tus ofrendas de bebida y tus ofrendas de paz’”. ");
INSERT INTO spablm_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Moisés dijo a los hijos de Israel todo lo que Yahvé le había ordenado a Moisés. ");
INSERT INTO spablm_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Moisés habló a los jefes de las tribus de los hijos de Israel, diciendo: “Esto es lo que Yahvé ha ordenado. ");
INSERT INTO spablm_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Cuando un hombre haga un voto a Yahvé, o haga un juramento para atar su alma con un vínculo, no deberá faltar a su palabra. Hará conforme a todo lo que salga de su boca. ");
INSERT INTO spablm_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“Además, cuando una mujer hace un voto a Yahvé y se compromete con una promesa, estando en la casa de su padre, en su juventud, ");
INSERT INTO spablm_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","y su padre oye su voto y su promesa con la que ha vinculado su alma, y su padre no le dice nada, entonces todos sus votos serán válidos, y toda promesa con la que haya vinculado su alma será válida. ");
INSERT INTO spablm_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Pero si su padre se lo prohíbe el día que se entere, ninguno de sus votos ni de sus promesas con los que haya ligado su alma subsistirán. El Señor la perdonará, porque su padre se lo ha prohibido. ");
INSERT INTO spablm_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“Si tiene marido, mientras sus votos están sobre ella, o la imprudente expresión de sus labios con la que ha ligado su alma, ");
INSERT INTO spablm_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","y su marido lo oye, y no le dice nada el día que lo oye, entonces sus votos serán firmes, y sus promesas con las que ha ligado su alma serán firmes. ");
INSERT INTO spablm_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Pero si su marido se lo prohíbe el día que lo oiga, entonces anulará su voto que está sobre ella y las palabras imprudentes de sus labios, con las que ha ligado su alma. El Señor la perdonará. ");
INSERT INTO spablm_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“Pero el voto de la viuda o de la divorciada, todo aquello con lo que haya ligado su alma quedará en su contra. ");
INSERT INTO spablm_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“Si ella hizo un voto en casa de su marido o vinculó su alma con un juramento, ");
INSERT INTO spablm_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","y su marido lo oyó, y calló ante ella y no la desautorizó, entonces todos sus votos serán válidos, y toda prenda con la que vinculó su alma será válida. ");
INSERT INTO spablm_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Pero si su marido los anuló el día que los oyó, entonces todo lo que haya salido de sus labios en cuanto a sus votos, o en cuanto al vínculo de su alma, no subsistirá. Su marido los ha anulado. El Señor la perdonará. ");
INSERT INTO spablm_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Todo voto, y todo juramento vinculante para afligir el alma, su marido puede establecerlo, o su marido puede anularlo. ");
INSERT INTO spablm_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Pero si su esposo no le dice nada de un día para otro, entonces él establece todos sus votos o todos sus juramentos que están sobre ella. Los ha establecido, porque no le dijo nada el día que los escuchó. ");
INSERT INTO spablm_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Pero si los anula después de haberlos escuchado, entonces él cargará con su iniquidad.” ");
INSERT INTO spablm_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Estosson los estatutos que Yahvé ordenó a Moisés, entre un hombre y su esposa, entre un padre y su hija, estando en su juventud, en la casa de su padre. ");
INSERT INTO spablm_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Véngate de los hijos de Israel contra los madianitas. Después te reunirás con tu pueblo”. ");
INSERT INTO spablm_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Moisés habló al pueblo diciendo: “Arma a los hombres de entre ustedes para la guerra, para que vayan contra Madián, para ejecutar la venganza de Yahvé contra Madián. ");
INSERT INTO spablm_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Enviaréis mil de cada tribu, de todas las tribus de Israel, a la guerra.” ");
INSERT INTO spablm_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Así que fueron entregados, de los miles de Israel, mil de cada tribu, doce mil armados para la guerra. ");
INSERT INTO spablm_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Moisés los envió, mil de cada tribu, a la guerra con Finees, hijo del sacerdote Eleazar, a la guerra, con los utensilios santos del santuario y las trompetas de alarma en su mano. ");
INSERT INTO spablm_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Lucharon contra Madián, como Yahvé le ordenó a Moisés. Mataron a todos los varones. ");
INSERT INTO spablm_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Mataron a los reyes de Madián con el resto de sus muertos: Evi, Requem, Zur, Hur y Reba, los cinco reyes de Madián. También mataron a espada a Balaam, hijo de Beor. ");
INSERT INTO spablm_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Los hijos de Israel tomaron cautivas a las mujeres de Madián con sus hijos, y tomaron como botín todo su ganado, todos sus rebaños y todos sus bienes. ");
INSERT INTO spablm_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Quemaron todas sus ciudades en los lugares donde vivían y todos sus campamentos. ");
INSERT INTO spablm_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Tomaron todos los cautivos y todo el botín, tanto de hombres como de animales. ");
INSERT INTO spablm_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","Llevaron a los cautivos, con la presa y el botín, a Moisés, al sacerdote Eleazar y a la congregación de los hijos de Israel, al campamento de los llanos de Moab, que están junto al Jordán, en Jericó. ");
INSERT INTO spablm_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Moisés y el sacerdote Eleazar, con todos los jefes de la congregación, salieron a recibirlos fuera del campamento. ");
INSERT INTO spablm_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Moisés se enojó con los oficiales del ejército, los capitanes de mil y los de cien, que venían del servicio de guerra. ");
INSERT INTO spablm_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Moisés les dijo: “¿Habéis salvado a todas las mujeres con vida? ");
INSERT INTO spablm_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","He aquí que éstas hicieron que los hijos de Israel, por consejo de Balaam, cometieran transgresión contra Yahvé en el asunto de Peor, y así fue la plaga en la congregación de Yahvé. ");
INSERT INTO spablm_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Maten, pues, a todo varón entre los pequeños, y maten a toda mujer que haya conocido al hombre acostándose con él. ");
INSERT INTO spablm_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Pero todas las muchachas que no hayan conocido al hombre acostándose con él, manténganse vivas. ");
INSERT INTO spablm_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","“Acampad fuera del campamento durante siete días. El que haya matado a alguna persona, y el que haya tocado a algún muerto, purificaos al tercer día y al séptimo, vosotros y vuestros cautivos. ");
INSERT INTO spablm_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Purificaréis todos los vestidos, todo lo que sea de piel, todo lo que sea de pelo de cabra y todo lo que sea de madera.” ");
INSERT INTO spablm_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","El sacerdote Eleazar dijo a los hombres de guerra que iban a la batalla: “Este es el estatuto de la ley que Yahvé ha ordenado a Moisés. ");
INSERT INTO spablm_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Sin embargo, el oro, la plata, el bronce, el hierro, el estaño y el plomo, ");
INSERT INTO spablm_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","todo lo que pueda resistir el fuego, lo haréis pasar por el fuego, y quedará limpio; no obstante, será purificado con el agua para la impureza. Todo lo que no resista el fuego lo harás pasar por el agua. ");
INSERT INTO spablm_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","El séptimo día lavarás tus ropas, y quedarás limpio. Después entrarás en el campamento”. ");
INSERT INTO spablm_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“Cuenta el botín que fue tomado, tanto de personas como de animales, tú, y el sacerdote Eleazar, y los jefes de familia de la congregación; ");
INSERT INTO spablm_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","y divide el botín en dos partes: entre los hombres hábiles en la guerra, que salieron a la batalla, y toda la congregación. ");
INSERT INTO spablm_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Levanten un tributo a Yahvé de los hombres de guerra que salieron a la batalla: un alma de cada quinientos; de las personas, del ganado, de los asnos y de los rebaños. ");
INSERT INTO spablm_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Tómalo de la mitad de ellos y dáselo al sacerdote Eleazar, para la ofrenda mecida de Yahvé. ");
INSERT INTO spablm_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","De la mitad de los hijos de Israel, tomarás un alma de cada cincuenta, de las personas, del ganado, de los asnos y de los rebaños, de todo el ganado, y se los darás a los levitas, que cumplen con el deber del tabernáculo de Yahvé.” ");
INSERT INTO spablm_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Moisés y el sacerdote Eleazar hicieron lo que Yahvé les ordenó. ");
INSERT INTO spablm_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","El botín, además del botín que tomaron los hombres de guerra, fue de seiscientas setenta y cinco mil ovejas, ");
INSERT INTO spablm_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","setenta y dos mil cabezas de ganado, ");
INSERT INTO spablm_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","sesenta y un mil asnos, ");
INSERT INTO spablm_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","y treinta y dos mil personas en total, de las mujeres que no habían conocido al hombre acostándose con él. ");
INSERT INTO spablm_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","La mitad, que era la porción de los que salían a la guerra, era en número de trescientas treinta y siete mil quinientas ovejas; ");
INSERT INTO spablm_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","y el tributo de las ovejas era de seiscientas setenta y cinco. ");
INSERT INTO spablm_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","El ganado vacuno era de treinta y seis mil, de los cuales el tributo de Yahvé era de setenta y dos. ");
INSERT INTO spablm_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","Los asnos eran treinta mil quinientos, de los cuales el tributo del Señor era sesenta y uno. ");
INSERT INTO spablm_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","Las personas eran dieciséis mil, de las cuales el tributo de Yahvé era de treinta y dos personas. ");
INSERT INTO spablm_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Moisés entregó el tributo, que era la ofrenda mecida de Yahvé, al sacerdote Eleazar, como Yahvé se lo había ordenado a Moisés. ");
INSERT INTO spablm_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","De la mitad de los hijos de Israel, que Moisés repartió entre los hombres que combatieron ");
INSERT INTO spablm_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","(la mitad de la congregación era de trescientas treinta y siete mil quinientas ovejas, ");
INSERT INTO spablm_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","treinta y seis mil cabezas de ganado, ");
INSERT INTO spablm_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","treinta mil quinientos asnos ");
INSERT INTO spablm_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","y dieciséis mil personas), ");
INSERT INTO spablm_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","de la mitad de los hijos de Israel, Moisés tomó un animal de cada cincuenta, tanto de hombres como de animales, y se los dio a los levitas, que cumplían con el deber del tabernáculo de Yahvé, como Yahvé le ordenó a Moisés. ");
INSERT INTO spablm_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Se acercaron a Moisés los oficiales que estaban al frente de los miles del ejército, los capitanes de miles y los de cientos. ");
INSERT INTO spablm_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","Le dijeron a Moisés: “Tus siervos han tomado la suma de los hombres de guerra que están bajo nuestro mando, y no falta ni uno de nosotros. ");
INSERT INTO spablm_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Hemos traído la ofrenda de Yahvé, lo que cada uno encontró: adornos de oro, brazaletes, pulseras, anillos de sello, pendientes y collares, para expiar nuestras almas ante Yahvé.” ");
INSERT INTO spablm_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Moisés y el sacerdote Eleazar tomaron su oro, todas las joyas trabajadas. ");
INSERT INTO spablm_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Todo el oro de la ofrenda de ola que ofrecieron a Yahvé, de los capitanes de millares y de los capitanes de centenas, fue de dieciséis mil setecientos cincuenta siclos. ");
INSERT INTO spablm_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Los hombres de guerra habían tomado un botín, cada uno para sí mismo. ");
INSERT INTO spablm_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Moisés y el sacerdote Eleazar tomaron el oro de los capitanes de millares y de centenas, y lo llevaron a la Tienda del Encuentro como memorial para los hijos de Israel ante Yahvé. ");
INSERT INTO spablm_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Los hijos de Rubén y los hijos de Gad tenían una gran cantidad de ganado. Vieron la tierra de Jazer y la tierra de Galaad. He aquí que el lugar era un sitio para el ganado. ");
INSERT INTO spablm_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Entonces los hijos de Gad y los hijos de Rubén vinieron y hablaron a Moisés, al sacerdote Eleazar y a los jefes de la congregación, diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“Atarot, Dibón, Jazer, Nimra, Hesbón, Eleale, Sebam, Nebo y Beón, ");
INSERT INTO spablm_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","la tierra que Yahvé hirió ante la congregación de Israel, es tierra de ganado; y vuestros siervos tienen ganado.” ");
INSERT INTO spablm_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Ellos dijeron: “Si hemos hallado gracia ante tus ojos, que esta tierra sea dada a tus siervos como posesión. No nos hagas pasar el Jordán”. ");
INSERT INTO spablm_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Moisés dijo a los hijos de Gad y a los hijos de Rubén: “¿Van a ir sus hermanos a la guerra mientras ustedes están sentados aquí? ");
INSERT INTO spablm_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","¿Por qué desaniman el corazón de los hijos de Israel para que no vayan a la tierra que el Señor les ha dado? ");
INSERT INTO spablm_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Así lo hicieron sus padres cuando los envié desde Cades Barnea a ver la tierra. ");
INSERT INTO spablm_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Pues cuando subieron al valle de Escol y vieron la tierra, desanimaron el corazón de los hijos de Israel para que no entraran en la tierra que Yahvé les había dado. ");
INSERT INTO spablm_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Aquel día ardió la ira de Yahvé, y juró diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘Ciertamente ninguno de los hombres que subieron de Egipto, de veinte años en adelante, verá la tierra que juré a Abraham, a Isaac y a Jacob; porque no me han seguido del todo, ");
INSERT INTO spablm_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","excepto Caleb hijo de Jefone cenezeo, y Josué hijo de Nun, porque han seguido a Yahvé del todo.’ ");
INSERT INTO spablm_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","La ira del Señor se encendió contra Israel, y lo hizo vagar de un lado a otro del desierto durante cuarenta años, hasta que se consumió toda la generación que había hecho el mal a los ojos del Señor. ");
INSERT INTO spablm_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","“He aquí que ustedes se han levantado en el lugar de sus padres, un aumento de hombres pecadores, para aumentar el furor de Yahvé contra Israel. ");
INSERT INTO spablm_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Porque si os apartáis de él, volverá a dejarlos en el desierto, y destruiréis a todo este pueblo.” ");
INSERT INTO spablm_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Se acercaron a él y le dijeron: “Construiremos aquí apriscos para nuestros ganados y ciudades para nuestros pequeños; ");
INSERT INTO spablm_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","pero nosotros mismos estaremos listos armados para ir delante de los hijos de Israel, hasta que los hayamos llevado a su lugar. Nuestros pequeños vivirán en las ciudades fortificadas a causa de los habitantes de la tierra. ");
INSERT INTO spablm_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","No volveremos a nuestras casas hasta que todos los hijos de Israel hayan recibido su herencia. ");
INSERT INTO spablm_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Porque no heredaremos con ellos al otro lado del Jordán y más allá, porque nuestra herencia nos ha llegado a este lado del Jordán hacia el este.” ");
INSERT INTO spablm_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Moisés les dijo: “Si hacéis esto, si os armáis para ir delante de Yahvé a la guerra, ");
INSERT INTO spablm_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","y cada uno de vuestros hombres armados pasará el Jordán delante de Yahvé hasta que haya expulsado a sus enemigos de delante de él, ");
INSERT INTO spablm_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","y la tierra esté sometida delante de Yahvé; entonces después volveréis, y estaréis libres de obligaciones para con Yahvé y para con Israel. Entonces esta tierra será tu posesión ante el Señor. ");
INSERT INTO spablm_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","“Pero si no lo haces, he aquí que has pecado contra Yahvé; y ten por seguro que tu pecado te descubrirá. ");
INSERT INTO spablm_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Construye ciudades para tus pequeños, y rediles para tus ovejas; y haz lo que ha salido de tu boca.” ");
INSERT INTO spablm_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Los hijos de Gad y los hijos de Rubén hablaron con Moisés y le dijeron: “Tus siervos harán lo que ordena mi señor. ");
INSERT INTO spablm_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Nuestros pequeños, nuestras mujeres, nuestros rebaños y todo nuestro ganado quedarán allí en las ciudades de Galaad; ");
INSERT INTO spablm_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","pero tus siervos pasarán, cada uno de ellos armado para la guerra, delante de Yahvé para combatir, como dice mi señor.” ");
INSERT INTO spablm_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Entonces Moisés ordenó acerca de ellos al sacerdote Eleazar y a Josué hijo de Nun, y a los jefes de familia de las tribus de los hijos de Israel. ");
INSERT INTO spablm_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Moisés les dijo: “Si los hijos de Gad y los hijos de Rubén pasan con vosotros el Jordán, cada uno armado para la batalla delante de Yahvé, y la tierra es sometida delante de vosotros, les daréis la tierra de Galaad en posesión; ");
INSERT INTO spablm_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","pero si no pasan con vosotros armados, tendrán posesión entre vosotros en la tierra de Canaán.” ");
INSERT INTO spablm_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Los hijos de Gad y los hijos de Rubén respondieron diciendo: “Como Yahvé ha dicho a tus siervos, así haremos. ");
INSERT INTO spablm_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Pasaremos armados delante de Yahvé a la tierra de Canaán, y la posesión de nuestra herencia quedará con nosotros al otro lado del Jordán.” ");
INSERT INTO spablm_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Moisés les dio a los hijos de Gad, a los hijos de Rubén y a la media tribu de Manasés hijo de José, el reino de Sehón, rey de los amorreos, y el reino de Og, rey de Basán; la tierra, según sus ciudades y sus límites, las ciudades de los alrededores. ");
INSERT INTO spablm_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Los hijos de Gad edificaron Dibón, Atarot, Aroer, ");
INSERT INTO spablm_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Atarot-sofán, Jazer, Jogbehá, ");
INSERT INTO spablm_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Bet Nimra y Bet Harán: ciudades fortificadas y rediles para las ovejas. ");
INSERT INTO spablm_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Los hijos de Rubén edificaron Hesbón, Elealeh, Quiriatáim, ");
INSERT INTO spablm_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Nebo y Baal Meón (sus nombres fueron cambiados) y Sibma. Dieron otros nombres a las ciudades que construyeron. ");
INSERT INTO spablm_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Los hijos de Maquir, hijo de Manasés, fueron a Galaad, la tomaron y despojaron a los amorreos que estaban en ella. ");
INSERT INTO spablm_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Moisés dio Galaad a Maquir hijo de Manasés, y éste vivió en ella. ");
INSERT INTO spablm_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Jair hijo de Manasés fue y tomó sus aldeas, y las llamó Havvoth Jair. ");
INSERT INTO spablm_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Noba fue y tomó Kenat y sus aldeas, y la llamó Noba, según su propio nombre. ");
INSERT INTO spablm_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Estos son los viajes de los hijos de Israel, cuando salieron de la tierra de Egipto con sus ejércitos bajo la mano de Moisés y Aarón. ");
INSERT INTO spablm_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Moisés escribió los puntos de partida de sus viajes por mandato de Yahvé. Estos son sus viajes según sus puntos de partida. ");
INSERT INTO spablm_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Partieron de Ramsés en el primer mes, el día quince del primer mes; al día siguiente de la Pascua, los hijos de Israel salieron con la mano en alto a la vista de todos los egipcios, ");
INSERT INTO spablm_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","mientras los egipcios enterraban a todos sus primogénitos, a los que Yahvé había herido entre ellos. Yahvé también ejecutó juicios sobre sus dioses. ");
INSERT INTO spablm_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Los hijos de Israel partieron de Ramsés y acamparon en Sucot. ");
INSERT INTO spablm_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Partieron de Sucot y acamparon en Etam, que está en el límite del desierto. ");
INSERT INTO spablm_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Partieron de Etam y volvieron a Pihahiroth, que está frente a Baal Zephon, y acamparon frente a Migdol. ");
INSERT INTO spablm_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Partieron de delante de Hahirot y cruzaron por el medio del mar hacia el desierto. Recorrieron tres días de camino en el desierto de Etam, y acamparon en Mara. ");
INSERT INTO spablm_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Partieron de Mara y llegaron a Elim. En Elim había doce fuentes de agua y setenta palmeras, y acamparon allí. ");
INSERT INTO spablm_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Partieron de Elim y acamparon junto al Mar Rojo. ");
INSERT INTO spablm_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Partieron del Mar Rojo y acamparon en el desierto de Sin. ");
INSERT INTO spablm_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Partieron del desierto de Sin y acamparon en Dolca. ");
INSERT INTO spablm_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Partieron de Dolca y acamparon en Alus. ");
INSERT INTO spablm_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Partieron de Alus y acamparon en Refidim, donde no había agua para que el pueblo bebiera. ");
INSERT INTO spablm_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Partieron de Refidim y acamparon en el desierto de Sinaí. ");
INSERT INTO spablm_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Partieron del desierto de Sinaí y acamparon en Kibroth Hattaava. ");
INSERT INTO spablm_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Partieron de Kibroth Hattaava y acamparon en Hazerot. ");
INSERT INTO spablm_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Partieron de Hazerot y acamparon en Ritma. ");
INSERT INTO spablm_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Partieron de Ritma y acamparon en Rimón Fares. ");
INSERT INTO spablm_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Partieron de Rimón Fares y acamparon en Libná. ");
INSERT INTO spablm_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Partieron de Libná y acamparon en Rissá. ");
INSERT INTO spablm_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Partieron de Rissá y acamparon en Ceeletá. ");
INSERT INTO spablm_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Partieron de Ceeletá y acamparon en el monte Sefer. ");
INSERT INTO spablm_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Partieron del monte Sefer y acamparon en Harada. ");
INSERT INTO spablm_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Partieron de Harada y acamparon en Macelot. ");
INSERT INTO spablm_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Partieron de Macelot y acamparon en Tahat. ");
INSERT INTO spablm_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Partieron de Tahat y acamparon en Taré. ");
INSERT INTO spablm_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Partieron de Taré y acamparon en Mitcá. ");
INSERT INTO spablm_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Partieron de Mitca y acamparon en Hasmona. ");
INSERT INTO spablm_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Partieron de Hasmona y acamparon en Moserot. ");
INSERT INTO spablm_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Partieron de Moserot y acamparon en Bene Jaacán. ");
INSERT INTO spablm_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Partieron de Bene Jaacan y acamparon en Hor de Gidgad. ");
INSERT INTO spablm_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Partieron de Hor de Gidgad y acamparon en Jotbata. ");
INSERT INTO spablm_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Partieron de Jotbata y acamparon en Abrona. ");
INSERT INTO spablm_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Partieron de Abrona y acamparon en Ezión Geber. ");
INSERT INTO spablm_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Partieron de Ezión Geber y acamparon en Cades, en el desierto de Zin. ");
INSERT INTO spablm_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Partieron de Cades y acamparon en el monte Hor, en el límite de la tierra de Edom. ");
INSERT INTO spablm_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","El sacerdote Aarón subió al monte Hor por orden de Yahvé y murió allí, en el cuadragésimo año después de que los hijos de Israel salieron de la tierra de Egipto, en el quinto mes, el primer día del mes. ");
INSERT INTO spablm_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Aarón tenía ciento veintitrés años cuando murió en el monte Hor. ");
INSERT INTO spablm_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","El rey cananeo de Arad, que vivía en el sur, en la tierra de Canaán, se enteró de la llegada de los hijos de Israel. ");
INSERT INTO spablm_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Partieron del monte Hor y acamparon en Zalmoná. ");
INSERT INTO spablm_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Partieron de Zalmoná y acamparon en Punón. ");
INSERT INTO spablm_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Partieron de Punón y acamparon en Obot. ");
INSERT INTO spablm_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Partieron de Oboth y acamparon en Ije Abarim, en la frontera de Moab. ");
INSERT INTO spablm_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Partieron de Ije Abarim y acamparon en Dibón Gad. ");
INSERT INTO spablm_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Partieron de Dibón Gad y acamparon en Almon Diblataim. ");
INSERT INTO spablm_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Partieron de Almon Diblataim y acamparon en los montes de Abarim, frente a Nebo. ");
INSERT INTO spablm_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Partieron de los montes de Abarim y acamparon en las llanuras de Moab, junto al Jordán, en Jericó. ");
INSERT INTO spablm_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Acamparon junto al Jordán, desde Bet Jesimot hasta Abel Sitim, en las llanuras de Moab. ");
INSERT INTO spablm_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Yahvé habló a Moisés en las llanuras de Moab, junto al Jordán de Jericó, diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","Habla a los hijos de Israel y diles: “Cuando paséis el Jordán a la tierra de Canaán, ");
INSERT INTO spablm_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","entonces expulsaréis a todos los habitantes de la tierra de delante de vosotros, destruiréis todos sus ídolos de piedra, destruiréis todas sus imágenes fundidas y derribaréis todos sus lugares altos. ");
INSERT INTO spablm_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Tomarás posesión de la tierra y habitarás en ella, porque yo te he dado la tierra para que la poseas. ");
INSERT INTO spablm_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Heredaréis la tierra por sorteo según vuestras familias; a los grupos más numerosos les darás una herencia mayor, y a los más pequeños les darás una herencia menor. Dondequiera que le toque la suerte a un hombre, eso será suyo. Heredaréis según las tribus de vuestros padres. ");
INSERT INTO spablm_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","“Pero si no expulsas a los habitantes de la tierra de delante de ti, los que dejes que queden de ellos serán como aguijones en tus ojos y espinas en tus costados. Te acosarán en la tierra en la que habitas. ");
INSERT INTO spablm_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Sucederá que, como pensaba hacerles a ellos, así os haré a vosotros”. ");
INSERT INTO spablm_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“Manda a los hijos de Israel y diles: ‘Cuando lleguéis a la tierra de Canaán (ésta es la tierra que os corresponderá en herencia, la tierra de Canaán según sus límites), ");
INSERT INTO spablm_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","vuestro límite sur será desde el desierto de Zin a lo largo del lado de Edom, y vuestro límite sur será desde el extremo del Mar Salado hacia el este. ");
INSERT INTO spablm_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","Tu frontera girará hacia el sur de la subida de Acrabim, y pasará por Zin; y pasará por el sur de Cades Barnea; y de allí irá a Hasar Adar, y pasará por Asmón. ");
INSERT INTO spablm_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","La frontera girará desde Asmón hasta el arroyo de Egipto, y terminará en el mar. ");
INSERT INTO spablm_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","“‘Para la frontera occidental, tendrás el gran mar y su frontera. Esta será tu frontera occidental. ");
INSERT INTO spablm_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","“‘Esta será vuestra frontera del norte: desde el gran mar os marcaréis el monte Hor. ");
INSERT INTO spablm_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","Desde el monte Hor marcaréis hasta la entrada de Hamat, y la frontera pasará por Zedad. ");
INSERT INTO spablm_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","Luego la frontera irá hasta Zifrón, y terminará en Hazar Enán. Esta será vuestra frontera norte. ");
INSERT INTO spablm_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","“‘Marcarás tu frontera oriental desde Hazar Enán hasta Sefam. ");
INSERT INTO spablm_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","La frontera bajará desde Sefam hasta Ribla, al lado oriental de Ain. La frontera descenderá y llegará hasta el lado del mar de Cineret, hacia el este. ");
INSERT INTO spablm_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","La frontera bajará hasta el Jordán y terminará en el Mar Salado. Esta será tu tierra según sus límites alrededor”. ");
INSERT INTO spablm_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Moisés ordenó a los hijos de Israel diciendo: “Esta es la tierra que heredaréis por sorteo, que Yahvé ha ordenado dar a las nueve tribus y a la media tribu; ");
INSERT INTO spablm_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","porque la tribu de los hijos de Rubén según las casas de sus padres, la tribu de los hijos de Gad según las casas de sus padres y la media tribu de Manasés han recibido su herencia. ");
INSERT INTO spablm_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Las dos tribus y la media tribu han recibido su herencia al otro lado del Jordán, en Jericó, hacia el este, hacia la salida del sol.” ");
INSERT INTO spablm_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Yahvé habló a Moisés diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“Estos son los nombres de los hombres que te repartirán la tierra en herencia El sacerdote Eleazar y Josué, hijo de Nun. ");
INSERT INTO spablm_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Tomarás un príncipe de cada tribu para repartir la tierra en herencia. ");
INSERT INTO spablm_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","Estos son los nombres de los hombres: De la tribu de Judá, Caleb hijo de Jefone. ");
INSERT INTO spablm_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","De la tribu de los hijos de Simeón, Semuel hijo de Amiud. ");
INSERT INTO spablm_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","De la tribu de Benjamín, Elidad hijo de Quislón. ");
INSERT INTO spablm_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","De la tribu de los hijos de Dan, un príncipe, Buqui hijo de Jogli. ");
INSERT INTO spablm_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","De los hijos de José: de la tribu de los hijos de Manasés, un príncipe, Haniel hijo de Efod. ");
INSERT INTO spablm_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","De la tribu de los hijos de Efraín, un príncipe, Kemuel hijo de Siftán. ");
INSERT INTO spablm_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","De la tribu de los hijos de Zabulón, un príncipe: Elizafán, hijo de Parnac. ");
INSERT INTO spablm_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","De la tribu de los hijos de Isacar, un príncipe: Paltiel, hijo de Azán. ");
INSERT INTO spablm_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","De la tribu de los hijos de Aser, un príncipe: Ahiud, hijo de Selomi. ");
INSERT INTO spablm_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","De la tribu de los hijos de Neftalí un príncipe, Pedael hijo de Amiud”. ");
INSERT INTO spablm_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Estos son los que Yahvé mandó a repartir la herencia a los hijos de Israel en la tierra de Canaán. ");
INSERT INTO spablm_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Yahvé habló a Moisés en las llanuras de Moab, junto al Jordán, en Jericó, diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“Ordena a los hijos de Israel que den a los levitas ciudades para que las habiten de su herencia. Darán a los levitas tierras de pastoreo para las ciudades de los alrededores. ");
INSERT INTO spablm_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Ellos tendrán las ciudades para habitarlas. Sus tierras de pastoreo serán para su ganado, para sus posesiones y para todos sus animales. ");
INSERT INTO spablm_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","“Las tierras de pastoreo de las ciudades, que darás a los levitas, serán desde el muro de la ciudad y hacia afuera mil codos alrededor de ella. ");
INSERT INTO spablm_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Medirás fuera de la ciudad dos mil codos por el lado este, dos mil codos por el lado sur, dos mil codos por el lado oeste y dos mil codos por el lado norte, quedando la ciudad en medio. Estas serán las tierras de pastoreo de sus ciudades. ");
INSERT INTO spablm_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","“Las ciudades que darás a los levitas serán las seis ciudades de refugio que darás para que huya el homicida. Además de ellas, darás cuarenta y dos ciudades. ");
INSERT INTO spablm_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Todas las ciudades que darás a los levitas serán cuarenta y ocho ciudades junto con sus tierras de pastoreo. ");
INSERT INTO spablm_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","En cuanto a las ciudades que darás de la posesión de los hijos de Israel, de los muchos tomarás muchos, y de los pocos tomarás pocos. Cada uno, según su herencia, dará parte de sus ciudades a los levitas”. ");
INSERT INTO spablm_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Yahvé habló a Moisés, diciendo: ");
INSERT INTO spablm_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“Habla a los hijos de Israel y diles: ‘Cuando paséis el Jordán a la tierra de Canaán, ");
INSERT INTO spablm_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","entonces os designaréis ciudades para que os sirvan de refugio, para que huya allí el homicida que mate a cualquier persona sin saberlo. ");
INSERT INTO spablm_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Las ciudades os servirán de refugio contra el vengador, para que el homicida no muera hasta que se presente ante la congregación para ser juzgado. ");
INSERT INTO spablm_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Las ciudades que darás serán para ti seis ciudades de refugio. ");
INSERT INTO spablm_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Darás tres ciudades al otro lado del Jordán, y darás tres ciudades en la tierra de Canaán. Serán ciudades de refugio. ");
INSERT INTO spablm_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Estas seis ciudades serán refugio para los hijos de Israel, para el extranjero y para el forastero que viva entre ellos, para que todo el que mate a alguien sin querer huya allí. ");
INSERT INTO spablm_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","“‘Pero si lo golpeó con un instrumento de hierro, de modo que murió, es un asesino. El asesino será condenado a muerte. ");
INSERT INTO spablm_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Si lo golpeó con una piedra en la mano, con la que un hombre puede morir, y murió, es un asesino. El homicida será condenado a muerte. ");
INSERT INTO spablm_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","O si lo golpea con un arma de madera en la mano, con la que pueda morir un hombre, y muere, es un asesino. El asesino morirá. ");
INSERT INTO spablm_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","El vengador de la sangre dará muerte al asesino. Cuando lo encuentre, lo matará. ");
INSERT INTO spablm_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Si lo empujó por odio, o le arrojó algo mientras estaba al acecho, de modo que murió, ");
INSERT INTO spablm_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","o en hostilidad lo golpeó con su mano, de modo que murió, el que lo golpeó ciertamente morirá. Es un asesino. El vengador de la sangre dará muerte al asesino cuando lo encuentre. ");
INSERT INTO spablm_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","“‘Pero si lo empuja repentinamente sin hostilidad, o arroja sobre él cualquier cosa sin estar al acecho, ");
INSERT INTO spablm_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","o con cualquier piedra, con la que pueda morir un hombre, sin verlo, y la arroja sobre él de modo que muera, y no era su enemigo ni buscaba su daño, ");
INSERT INTO spablm_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","entonces la congregación juzgará entre el agresor y el vengador de la sangre de acuerdo con estas ordenanzas. ");
INSERT INTO spablm_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","La congregación librará al homicida de la mano del vengador de la sangre, y la congregación lo devolverá a su ciudad de refugio, donde había huido. Allí habitará hasta la muerte del sumo sacerdote, que fue ungido con el óleo santo. ");
INSERT INTO spablm_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","“‘Pero si el homicida sale en algún momento de la frontera de su ciudad de refugio donde huye, ");
INSERT INTO spablm_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","y el vengador de la sangre lo encuentra fuera de la frontera de su ciudad de refugio, y el vengador de la sangre mata al homicida, éste no será culpable de sangre, ");
INSERT INTO spablm_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","porque debería haber permanecido en su ciudad de refugio hasta la muerte del sumo sacerdote. Pero después de la muerte del sumo sacerdote, el homicida regresará a la tierra de su posesión. ");
INSERT INTO spablm_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","“‘Estas cosas serán para vosotros un estatuto y una ordenanza a lo largo de vuestras generaciones en todas vuestras moradas. ");
INSERT INTO spablm_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","“‘Cualquiera que mate a una persona, el asesino será asesinado con base en el testimonio de los testigos; pero un solo testigo no declarará contra una persona para que muera. ");
INSERT INTO spablm_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","“‘Además, no aceptarás ningún rescate por la vida de un asesino que sea culpable de muerte. Será condenado a muerte. ");
INSERT INTO spablm_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","“‘No tomarás rescate por el que haya huido a su ciudad de refugio, para que vuelva a habitar en la tierra antes de la muerte del sacerdote. ");
INSERT INTO spablm_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","“‘Así no contaminarás la tierra donde vives; porque la sangre contamina la tierra. No se puede hacer expiación de la tierra por la sangre que se derrama en ella, sino por la sangre del que la derramó. ");
INSERT INTO spablm_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","No contaminarás la tierra que habitas, donde yo habito; porque yo, Yahvé, habito en medio de los hijos de Israel.’” ");
INSERT INTO spablm_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Los jefes de familia de los hijos de Galaad, hijo de Maquir, hijo de Manasés, de las familias de los hijos de José, se acercaron y hablaron ante Moisés y ante los príncipes, los jefes de familia de los hijos de Israel. ");
INSERT INTO spablm_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","Ellos dijeron: “Yahvé ordenó a mi señor que diera la tierra en herencia por sorteo a los hijos de Israel. Mi señor recibió la orden de Yahvé de dar la herencia de nuestro hermano Zelofehad a sus hijas. ");
INSERT INTO spablm_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Si ellas se casan con alguno de los hijos de las otras tribus de los hijos de Israel, su herencia se quitará de la herencia de nuestros padres y se añadirá a la herencia de la tribu a la que pertenezcan. Así será quitada de la suerte de nuestra herencia. ");
INSERT INTO spablm_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","Cuando llegue el jubileo de los hijos de Israel, su herencia se añadirá a la de la tribu a la que pertenezcan. Así que su herencia será quitada de la herencia de la tribu de nuestros padres”. ");
INSERT INTO spablm_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Moisés ordenó a los hijos de Israel según la palabra de Yahvé, diciendo: “La tribu de los hijos de José dice lo que es justo. ");
INSERT INTO spablm_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Esto es lo que Yahvé manda con respecto a las hijas de Zelofehad, diciendo: “Que se casen con quien mejor les parezca, sólo que se casarán en la familia de la tribu de su padre. ");
INSERT INTO spablm_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","Así, ninguna herencia de los hijos de Israel pasará de una tribu a otra, pues todos los hijos de Israel conservarán la herencia de la tribu de sus padres. ");
INSERT INTO spablm_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Toda hija que posea una herencia en cualquier tribu de los hijos de Israel será esposa de uno de la familia de la tribu de su padre, para que los hijos de Israel posean cada uno la herencia de sus padres. ");
INSERT INTO spablm_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","Así, ninguna herencia pasará de una tribu a otra, pues las tribus de los hijos de Israel conservarán cada una su propia herencia”. ");
INSERT INTO spablm_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Las hijas de Zelofehad hicieron lo que Yahvé mandó a Moisés: ");
INSERT INTO spablm_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","porque Maalá, Tirsa, Hogiá, Milca y Noa, las hijas de Zelofehad, se casaron con los hijos de los hermanos de su padre. ");
INSERT INTO spablm_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","Se casaron con las familias de los hijos de Manasés, hijo de José. Su herencia permaneció en la tribu de la familia de su padre. ");
INSERT INTO spablm_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Estos son los mandamientos y las ordenanzas que Yahvé ordenó por medio de Moisés a los hijos de Israel en las llanuras de Moab, junto al Jordán, en Jericó. ");
INSERT INTO spablm_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Estas son las palabras que Moisés dirigió a todo Israel al otro lado del Jordán, en el desierto, en el Arabá frente a Suf, entre Parán, Tofel, Labán, Hazerot y Dizahab. ");
INSERT INTO spablm_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","Hay once días de viaje desde Horeb, por el camino del monte Seir, hasta Cades Barnea. ");
INSERT INTO spablm_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","En el año cuarenta, en el mes undécimo, el primer día del mes, Moisés habló a los hijos de Israel según todo lo que Yahvé le había ordenado, ");
INSERT INTO spablm_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","después de haber herido en Edrei a Sehón, rey de los amorreos que vivía en Hesbón, y a Og, rey de Basán que vivía en Astarot. ");
INSERT INTO spablm_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Al otro lado del Jordán, en la tierra de Moab, Moisés comenzó a declarar esta ley, diciendo: ");
INSERT INTO spablm_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","“El Señor, nuestro Dios, nos habló en Horeb, diciendo: ‘Ya habéis vivido bastante en este monte. ");
INSERT INTO spablm_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Volveos y emprended vuestro viaje, e id a la región montañosa de los amorreos y a todos los lugares cercanos a ella: en el Arabá, en la región montañosa, en la llanura, en el sur, a la orilla del mar, en la tierra de los cananeos y en el Líbano hasta el gran río, el río Éufrates. ");
INSERT INTO spablm_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","He aquí que he puesto la tierra delante de ti. Entrad y poseed la tierra que Yahvé juró a vuestros padres — a Abraham, a Isaac y a Jacob — para dársela a ellos y a su descendencia después de ellos”. ");
INSERT INTO spablm_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","En aquel tiempo te hablé diciendo: “No puedo hacerme cargo yo solo. ");
INSERT INTO spablm_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","Yahvé, vuestro Dios, os ha multiplicado, y he aquí que sois hoy como las estrellas del cielo por la multitud. ");
INSERT INTO spablm_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","¡Que Yahvé, el Dios de tus padres, te haga mil veces más numerosa y te bendiga, como te ha prometido! ");
INSERT INTO spablm_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","¿Cómo podré llevar yo solo vuestros problemas, vuestras cargas y vuestras luchas? ");
INSERT INTO spablm_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Toma a hombres sabios y entendidos que sean respetados entre tus tribus, y los haré jefes sobre ti”. ");
INSERT INTO spablm_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","Tú me respondiste y dijiste: “Lo que has dicho es bueno hacerlo”. ");
INSERT INTO spablm_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Así que tomé a los jefes de vuestras tribus, hombres sabios y respetados, y los nombré jefes sobre vosotros, capitanes de millares, capitanes de centenas, capitanes de cincuenta, capitanes de decenas y oficiales, según vuestras tribus. ");
INSERT INTO spablm_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","En aquel tiempo ordené a vuestros jueces, diciendo: “Oíd los casos entre vuestros hermanos y juzgad con justicia entre un hombre y su hermano, y el extranjero que vive con él. ");
INSERT INTO spablm_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","No mostrarás parcialidad en el juicio; escucharás por igual al pequeño y al grande. No temerás el rostro del hombre, porque el juicio es de Dios. El caso que sea demasiado duro para ti, lo traerás a mí, y yo lo escucharé”. ");
INSERT INTO spablm_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","En aquel momento os ordené todo lo que debíais hacer. ");
INSERT INTO spablm_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","Salimos de Horeb y atravesamos todo ese desierto grande y terrible que ustedes vieron, por el camino de la región montañosa de los amorreos, como nos lo ordenó el Señor, nuestro Dios, y llegamos a Cades Barnea. ");
INSERT INTO spablm_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","Os dije: “Habéis llegado a la región montañosa de los amorreos, que el Señor nuestro Dios nos da. ");
INSERT INTO spablm_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","He aquí que el Señor, vuestro Dios, ha puesto la tierra delante de vosotros. Subid y tomad posesión, como os ha dicho el Señor, el Dios de vuestros padres. No tengas miedo ni te acobardes”. ");
INSERT INTO spablm_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","Os acercasteis a mí, todos vosotros, y dijisteis: “Enviemos hombres delante de nosotros, para que nos busquen por la tierra y nos traigan la noticia del camino por el que debemos subir y de las ciudades a las que debemos llegar.” ");
INSERT INTO spablm_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","El asunto me agradó. Tomé doce de tus hombres, un hombre por cada tribu. ");
INSERT INTO spablm_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","Se volvieron y subieron a la región montañosa, y llegaron al valle de Escol y lo exploraron. ");
INSERT INTO spablm_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","Tomaron en sus manos parte del fruto de la tierra y nos lo trajeron, y nos volvieron a avisar diciendo: “Es una buena tierra la que nos da el Señor, nuestro Dios.” ");
INSERT INTO spablm_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","Pero no quisisteis subir, sino que os rebelasteis contra el mandamiento del Señor, vuestro Dios. ");
INSERT INTO spablm_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","Murmurabais en vuestras tiendas y decíais: “Porque Yahvé nos odiaba, nos ha sacado de la tierra de Egipto para entregarnos en manos de los amorreos para que nos destruyan. ");
INSERT INTO spablm_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","¿Adónde vamos a subir? Nuestros hermanos han hecho que nuestro corazón se derrita, diciendo: ‘Los pueblos son más grandes y más altos que nosotros. Las ciudades son grandes y están fortificadas hasta el cielo. Además, hemos visto allí a los hijos de los Anac”. ");
INSERT INTO spablm_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","Entonces les dije: “No se asusten. No les tengáis miedo. ");
INSERT INTO spablm_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","Yahvé vuestro Dios, que va delante de vosotros, luchará por vosotros, según todo lo que hizo por vosotros en Egipto ante vuestros ojos, ");
INSERT INTO spablm_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","y en el desierto, donde has visto cómo Yahvé vuestro Dios te llevaba, como un hombre lleva a su hijo, en todo el camino que recorriste, hasta que llegaste a este lugar.” ");
INSERT INTO spablm_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","Pero en esto no creísteis a Yahvé, vuestro Dios, ");
INSERT INTO spablm_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","que iba delante de vosotros en el camino, para buscaros un lugar donde acampar: en el fuego de noche, para mostraros por qué camino debíais ir, y en la nube de día. ");
INSERT INTO spablm_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","Yahvé oyó la voz de vuestras palabras y se enojó, y juró diciendo: ");
INSERT INTO spablm_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","“Ciertamente ninguno de estos hombres de esta mala generación verá la buena tierra que juré dar a vuestros padres, ");
INSERT INTO spablm_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","excepto Caleb hijo de Jefone. Él la verá. Le daré la tierra que ha pisado a él y a sus hijos, porque ha seguido enteramente a Yahvé”. ");
INSERT INTO spablm_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","También el Señor se enojó conmigo por causa de ustedes, diciendo: “Tú tampoco entrarás allí. ");
INSERT INTO spablm_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Josué, hijo de Nun, que está delante de ti, entrará allí. Anímalo, porque él hará que Israel la herede. ");
INSERT INTO spablm_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","Además, tus pequeños, que dijiste que serían capturados o asesinados, tus hijos, que hoy no tienen conocimiento del bien ni del mal, entrarán allí. Yo se la daré, y ellos la poseerán. ");
INSERT INTO spablm_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","Pero en cuanto a ti, vuélvete y emprende tu viaje al desierto por el camino del Mar Rojo”. ");
INSERT INTO spablm_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","Entonces respondisteis y me dijisteis: “Hemos pecado contra Yahvé. Subiremos a pelear, conforme a todo lo que nos ordenó el Señor, nuestro Dios”. Cada uno de ustedes se vistió con sus armas de guerra y se dispuso a subir a la región montañosa. ");
INSERT INTO spablm_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","El Señor me dijo: “Diles que no suban y que no peleen, porque yo no estoy en medio de ustedes, para que no sean golpeados ante sus enemigos”. ");
INSERT INTO spablm_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","Así que os hablé, y no me escuchasteis, sino que os rebelasteis contra el mandamiento del Señor, y fuisteis presuntuosos, y subisteis a la región montañosa. ");
INSERT INTO spablm_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Los amorreos, que vivían en esa región montañosa, salieron contra ti y te persiguieron como lo hacen las abejas, y os derrotaron en Seir, hasta Horma. ");
INSERT INTO spablm_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Volvisteis y llorasteis delante de Yahvé, pero Yahvé no escuchó vuestra voz, ni volvió su oído hacia vosotros. ");
INSERT INTO spablm_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","Así que permaneciste en Cades muchos días, según los días que permaneciste. ");
INSERT INTO spablm_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","Luego nos volvimos y emprendimos la marcha hacia el desierto por el camino del Mar Rojo, como me había dicho Yahvé; y rodeamos el monte Seir durante muchos días. ");
INSERT INTO spablm_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","Yahvé me habló diciendo: ");
INSERT INTO spablm_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","“Ya has rodeado bastante este monte. Vuélvete hacia el norte. ");
INSERT INTO spablm_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","Ordena al pueblo que diga: ‘Vas a pasar por la frontera de tus hermanos, los hijos de Esaú, que habitan en Seír; y ellos tendrán miedo de ti. Tened, pues, cuidado. ");
INSERT INTO spablm_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","No contendáis con ellos, porque no os daré nada de su tierra, ni siquiera para que la pise la planta del pie, porque he dado el monte Seir a Esaú como posesión. ");
INSERT INTO spablm_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Les comprarás alimentos por dinero, para que puedas comer. También les comprarás agua por dinero, para que puedas beber’”. ");
INSERT INTO spablm_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","Porque el Señor, tu Dios, te ha bendecido en toda la obra de tus manos. Él ha conocido tu caminar por este gran desierto. Estos cuarenta años, el Señor tu Dios ha estado contigo. Nada te ha faltado. ");
INSERT INTO spablm_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","Así pasamos de nuestros hermanos, los hijos de Esaú, que habitan en Seir, por el camino del Arabá, desde Elat y desde Ezión Geber. Nos volvimos y pasamos por el camino del desierto de Moab. ");
INSERT INTO spablm_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","El Señor me dijo: “No molestes a Moab, ni te enfrentes a ellos en la batalla, porque no te daré nada de su tierra en posesión, ya que he dado Ar a los hijos de Lot en posesión.” ");
INSERT INTO spablm_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","(Los Emim vivían allí antes, un pueblo grande y numeroso, y alto como los de Anac. ");
INSERT INTO spablm_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","Estos también se consideran refaítas, como los de Anac; pero los moabitas los llaman emim. ");
INSERT INTO spablm_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","Los horeos también vivieron en Seir en el pasado, pero los hijos de Esaú los desalojaron. Los destruyeron de delante de ellos y vivieron en su lugar, como hizo Israel con la tierra de su posesión, que Yahvé les dio). ");
INSERT INTO spablm_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","“Ahora levántate y cruza el arroyo Zered”. Pasamos por el arroyo Zered. ");
INSERT INTO spablm_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","Los días en que salimos de Cades Barnea hasta que pasamos el arroyo de Zered fueron treinta y ocho años, hasta que toda la generación de los hombres de guerra fue consumida desde la mitad del campamento, como se lo había jurado el Señor. ");
INSERT INTO spablm_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","Además, la mano de Yahvé estaba contra ellos, para destruirlos desde la mitad del campamento, hasta que fueran consumidos. ");
INSERT INTO spablm_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","Entonces, cuando todos los hombres de guerra fueron consumidos y muertos de entre el pueblo, ");
INSERT INTO spablm_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","el Señor me habló diciendo: ");
INSERT INTO spablm_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","“Hoy debes pasar por Ar, la frontera de Moab. ");
INSERT INTO spablm_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","Cuando te acerques a la frontera de los hijos de Amón, no los molestes ni contiendas con ellos, porque no te daré nada de la tierra de los hijos de Amón en posesión, porque se la he dado a los hijos de Lot en posesión.” ");
INSERT INTO spablm_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","(Eso también se considera tierra de refaítas. Los refaim vivían allí en el pasado, pero los amonitas los llamaban zomzomeos, ");
INSERT INTO spablm_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","un pueblo grande, numeroso y alto, como los de Anak; pero Yahvé los destruyó de delante de Israel, y los desalojaron y vivieron en su lugar, ");
INSERT INTO spablm_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","como hizo con los hijos de Esaú que habitan en Seir, cuando destruyó a los horeos de delante de ellos; y los desalojaron y vivieron en su lugar hasta el día de hoy. ");
INSERT INTO spablm_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","Luego los heveos, que vivían en aldeas hasta Gaza: los caftoreos, que salieron de Caftor, los destruyeron y vivieron en su lugar). ");
INSERT INTO spablm_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","“Levántate, emprende tu viaje y pasa por el valle de Arnón. He aquí que he entregado en tu mano a Sehón el amorreo, rey de Hesbón, y a su tierra; comienza a poseerla, y enfréntate a él en la batalla. ");
INSERT INTO spablm_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","Hoy comenzaré a infundir tu temor y tu miedo a los pueblos que están bajo todo el cielo, que oirán la noticia de ustedes y temblarán y se angustiarán por tu causa.” ");
INSERT INTO spablm_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","Envié mensajeros desde el desierto de Cademot a Sehón, rey de Hesbón, con palabras de paz, diciendo: ");
INSERT INTO spablm_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","“Déjame pasar por tu tierra. Iré por el camino. No me desviaré ni a la derecha ni a la izquierda. ");
INSERT INTO spablm_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","Me venderás comida por dinero, para que coma; y me darás agua por dinero, para que beba. Sólo déjenme pasar sobre mis pies, ");
INSERT INTO spablm_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","como lo hicieron conmigo los hijos de Esaú que habitan en Seír, y los moabitas que habitan en Ar, hasta que pase el Jordán a la tierra que el Señor, nuestro Dios, nos da.” ");
INSERT INTO spablm_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","Pero Sehón, rey de Hesbón, no nos dejó pasar, porque el Señor, tu Dios, endureció su espíritu e hizo que su corazón se obstinara, para entregarlo en tu mano, como sucede hoy. ");
INSERT INTO spablm_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","El Señor me dijo: “He aquí que he comenzado a entregar a Sehón y su tierra delante de ti. Comienza a poseer, para que heredes su tierra”. ");
INSERT INTO spablm_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","Entonces Sijón salió contra nosotros, él y todo su pueblo, para combatir en Jahaz. ");
INSERT INTO spablm_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","El Señor, nuestro Dios, lo entregó ante nosotros, y lo derrotamos a él, a sus hijos y a todo su pueblo. ");
INSERT INTO spablm_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","En ese momento tomamos todas sus ciudades, y destruimos por completo todas las ciudades habitadas, con las mujeres y los niños. No dejamos a nadie en pie. ");
INSERT INTO spablm_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","Sólo tomamos el ganado como botín para nosotros, con el saqueo de las ciudades que habíamos tomado. ");
INSERT INTO spablm_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","Desde Aroer, que está al borde del valle de Arnón, y la ciudad que está en el valle, hasta Galaad, no hubo ciudad demasiado fuerte para nosotros. El Señor, nuestro Dios, lo entregó todo ante nosotros. ");
INSERT INTO spablm_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","Sólo a la tierra de los hijos de Amón no os acercasteis: a todas las riberas del río Jaboc y a las ciudades de