﻿USE sofia;
DROP TABLE IF EXISTS sofia.soy_vpl;
CREATE TABLE soy_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES soy_vpl WRITE;
INSERT INTO soy_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yeesu Kirisi yɛ Tɑfiti kɛyɑsɛ lɛ, Tɑfiti pɔ́ɔn kɔ Apirɑhɑm kɛyɑsɛ. Upikpurɛ ɑnyiri yɛ nnyɛ́: ");
INSERT INTO soy_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Apirɑhɑm yɛɛ Isɑɑki mɑri, Isɑɑki pɔ́ɔ Yɑkupu mɑru, Yɑkupu pɔ́ɔ Yutɑ nɛ upimɑrɛcɔ mɑ́rɛi, ");
INSERT INTO soy_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yutɑ pɔ́ɔ Perɛsi nɛ Serɑ mɑru. Piuni yɛɛ Tɑmɑɑ. Perɛsi pɔ́ɔ Hɛsirɔɔ mɑru, Hɛsirɔɔ pɔ́ɔ Arɑm mɑru, ");
INSERT INTO soy_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Arɑm pɔ́ɔ Aminɑtɑpi mɑru, Aminɑtɑpi pɔ́ɔ Nɑsɔɔ mɑru, Nɑsɔɔ pɔ́ɔ Sɑlimɑni mɑru, ");
INSERT INTO soy_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Sɑlimɑni pɔ́ɔ Poosi mɑru. Pi yɛ Poosi uni sée rɛ Rɑhɑpi. Poosi pɔ́ɔ Opɛti mɑru. Uyɛ̃ uni yɛɛ Ruuti. Opɛti pɔ́ɔ Yesee mɑru, ");
INSERT INTO soy_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yesee pɔ́ɔ uyɔ́ɔpi Tɑfiti mɑru, Tɑfiti pɔ́ɔ Sɑlomɔɔ mɑru. Sɑlomɔɔ uni yɛ mɛkɛɛ-mɛ Urii sɔ́ɔnlɛnlɛ. ");
INSERT INTO soy_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sɑlomɔɔ pɔ́ɔ Ropowɑm mɑru, Ropowɑm pɔ́ɔ Apiyɑ mɑru, Apiyɑ pɔ́ɔ Asɑɑ mɑru, ");
INSERT INTO soy_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asɑɑ pɔ́ɔ Yosɑfɑti mɑru. Yosɑfɑti pɔ́ɔ Yorɑm mɑru. Yorɑm pɔ́ɔ Osiyɑsi mɑru, ");
INSERT INTO soy_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Osiyɑsi pɔ́ɔ Yotɑm mɑru, Yotɑm pɔ́ɔ Akɑɑsi mɑru, Akɑɑsi pɔ́ɔ Esekiyɑsi mɑru, ");
INSERT INTO soy_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekiyɑsi pɔ́ɔ Mɑnɑsee mɑ́ru, Mɑnɑsee pɔ́ɔ Amɔɔ mɑru, Amɔɔ pɔ́ɔ Yosiyɑsi mɑru, ");
INSERT INTO soy_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosiyɑsi pɔ́ɔ Yekoniyɑ nɛ upimɑrɛcɔ mɑ́rɛi. Likumúŋɛ́ kpɛ-i kɑpi Isirɑyɛɛli pikɔ́ cɔ́pii ɑpí nɛ Pɑpilɔɔni kuyu sĩ. ");
INSERT INTO soy_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Kɑpi Isirɑyɛɛli pikɔ́ n cɔ́pii ɑpí nɛ Pɑpilɔɔni kuyu sĩ mɛmɑ́ɑ́ kɛ Yekoniyɑ pɔ́ɔ pɛɛ Seɑlitiyɛli mɑri, Seɑlitiyɛli pɔ́ɔ Soropɑpɛɛli mɑru, ");
INSERT INTO soy_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Soropɑpɛɛli pɔ́ɔ Apihuuti mɑru, Apihuuti pɔ́ɔ Eliyɑkim mɑru, Eliyɑkim pɔ́ɔ Asɔɔ mɑru, ");
INSERT INTO soy_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asɔɔ pɔ́ɔ Sɑtɔki mɑru, Sɑtɔki pɔ́ɔ Akim mɑru, Akim pɔ́ɔ Eliwuuti mɑru, ");
INSERT INTO soy_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliwuuti pɔ́ɔ Eleyɑsɑɑ mɑru, Eleyɑsɑɑ pɔ́ɔ Mɑtɑni mɑru, Mɑtɑni pɔ́ɔ Yɑkupu mɑru, ");
INSERT INTO soy_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yɑkupu pɔ́ɔ Mɑɑri ulɑ Yosɛfi mɑru. Mɑɑri kɛ́mɛɛ́ kɛ Yeesu kɑpi yɛ kɔ n sée rɛ Kirisi uu léemɛ. ");
INSERT INTO soy_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Lɛ̃ nnyɑ, kɑí nɛ Apirɑhɑm-i n kpísi ɑí nɛ Tɑfiti-i pɑ́, li wɑlɛ ncɔpuri ɑnɑi kɛfi nɛ ɑnɑ. Kɑi Tɑfiti-i n kpísi ɑí nɛ kumúŋɛ́ kpɛ-i kɑpi Isirɑyɛɛli pikɔ́ n cɔ́pii ɑpí nɛ Pɑpilɔɔni kuyu sĩ pɑ́, li wɑlɛ ncɔpuri ɑnɑi kɛfi nɛ ɑnɑ. Kɑi kɔ kei n kpísi ɑí nɛ Kirisi imɑrɛtuŋɛ pɑ́, li wɑlɛ ncɔpuri ɑnɑi kɛfi nɛ ɑnɑ ɑcɔ. ");
INSERT INTO soy_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Lɛ̃ kɑpi Yeesu Kirisi m mɑ́ri yɛ nní: Uuni Mɑɑri kɑpí pɛɛ Yosɛfi feleilɛ̃, ɑmɑ́ Nfɑ́ɑsɔnɛ nn tíyɛsɛ uu fɑpisi u nɛ Yosɛfi ɑ́pi kɔ kɑhɑnɛ kulee rimpɛ́nɛ. ");
INSERT INTO soy_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Uulɑ Yosɛfi yɛ ɑsei ute lɛ, úu pɛɛ́ lɑ ukɛ́ unɔ́si isɛi lukɛisɛ kuyu kukɛ́ kṍ, uu pɛɛ́ n lɑ ukɛ́ risɛ́ɛ́ nɛ u lɑkɑsɛ. ");
INSERT INTO soy_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Kuu ń we un likɛcɑ́ɑ́ músu, Upíimɑ uleecɑɑtumɛ unyinɛ uu kɛlɑ́rɛ́-i u kpɑ́fúmɛ uu u mɑɑ rɛ: Tɑfiti kɛpirɛ̃ Yosɛfi, Mɑɑri pikpíkɛ́ ɑ́pi kɑpɛ pɔ́ n cɔ́ŋlɛ̃. Nfɑ́ɑsɔnɛ mɛɛ tíyɛsɛ kuu fɑpisi. ");
INSERT INTO soy_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","U kɛwɑ́ntisi mɑrunɛ ɑɑ kɛ séi rɛ Yeesu. Kɛkɛɛ sɔ́nti kɛkɛ́ kɛmpuri pikɔ́ ɑkópɛ kɛ́mɛɛ lesɛ. ");
INSERT INTO soy_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Lɛ̃ nnɛ́í ɑi wɑi, Upíimɑ rinɔɔ kuu mɛkɛɛ ɑntepu Esɑyi m mɑ́ɑsɛ rikɛ́ nɛ n li nnyɑ. Lɛlɛɛ rɛ: ");
INSERT INTO soy_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ukpére yɛɛ úu utisi n nyu yɛ́ kɛfɑ wɑ, uu kɛwɑ́ntisi mɑru ɑpi kɛ séi rɛ Emɑnuyɛɛli, liɑsei rɛ Uléécɑɑ yɛ kɛrɔ́mɛɛ́ we. ");
INSERT INTO soy_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Kɛ Yosɛfi uu n yisi, uu lɛ̃ kɛ Upíimɑ uleecɑɑtumɛ uu u n símisi wɑi, uu Mɑɑri kunɔ́si kpísi. ");
INSERT INTO soy_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Amɑ́ u nɛ uyɛ̃ ɑ́pi kulee ripɛ́nɛ uú hɑ nɛ kɛwɑ́ntisi mɑru. Kuu kɛ m mɑ́ri, Yosɛfi uu kɛ séi rɛ Yeesu. ");
INSERT INTO soy_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yutee kɛtẽ kɛ́mɛɛ kɑpi Pɛtɛlɛhɛm-pɔ Yeesu mɑri. Erooti yɛɛ pɛɛ kei kumúŋɛ́ kpɛ-i uyɔ́ɔpi píimɑ. Pinyuwɛ píimɑ pinyinɛ ɑpi kɛtuŋɛleemɛ-mɛmpɔ yisi ɑpi Yerusɑlɛm tulu. ");
INSERT INTO soy_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Apí hɑ pisɛ rɛ: Yei yɛ kɛwɑ̃́ kɛ̃ kɑpi m mɑ́ri pin tee rɛ kɛkɛɛ sɔ́nti kɛkɛ́ Pisuifi iyɔɔpi tonɛ? Hɑ́i kɛtuŋɛleemɛ-pɔ kɑri riwɑ́rɛpi tɛɛ n nyísɛlɛ̃ tɛ pi kɛwɑ̃́ kɛ̃ mɑri yɛ̃. Lɛ̃ nnyɑ kɑrí kɑ rɛ tɔkɛ́ kɛ yɑ́ɑ́si ɑri wúlɑ. ");
INSERT INTO soy_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kɛ uyɔ́ɔpi píimɑ Erooti uu lɛ̃ n kṍ, ɑi u nɛ Yerusɑlɛm pikɔ́ nnɛ́í mpɔ́ɔcɑɑi tɑni. ");
INSERT INTO soy_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Uu pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ nnɛ́í nɛ isé picélɑɑ cɑ́pinɛ uu pi pisɛ rɛ kɛlõ kɛ́ye-i kɑpí uyɛ̃ kɛ Uléécɑɑ uu n wɛ́ɛ mɑrunɛ. ");
INSERT INTO soy_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Api u pɛsɛ rɛ: Yutee kɛteni-i, Pɛtɛlɛhɛm-pɔ le. Antepu Misee yɛ mɛkɛɛ-mɛ wɔi rɛ: ");
INSERT INTO soy_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Pɔ̃́ Pɛtɛlɛhɛm kuyu! Ái pɔ́ɔ Yutee kɛtẽ kɛcɑ́ɑ́ ɑyu kɛcɔpɛ ríyu pɑɑlɛ̃. Li we rɛ kɛpɔ́mɛɛ́ kɛ uyɔ́ɔpi píimɑ uu léerinɛ, uyɛɛ yɛ́ pinɛ́soi Isirɑyɛɛli pikɔ́ n séni. ");
INSERT INTO soy_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Kei kɛ Erooti uu pɛɛ pinyuwɛ píimɑ pɛ̃ mɛyɑɑ sée uu pi pisɛ rɛ pikɛ́ u símisi ńsɔnɛ ukɛ́ céri kumúŋɛ́ kpɛ-i kɛ riwɑ́rɛpi tɛ̃ ɑri n léemɛ. ");
INSERT INTO soy_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Uu pɛɛ limɛmɑ́ɑ́ Pɛtɛlɛhɛm-pɔ pi tum uu pi mɑɑ rɛ: ɑni n ŋme ɑni hɑ kɛwɑ̃́ kɛ̃ kɛcɑ́ɑ́ ńsɔnɛ písɛi ɑni kóm. Nɔn kɛ n yɛ̃, ɑni pɛɛri ɑni nɛ́ símisi nɛ́ɛkɛ́ hɑ kɔ kɛ yɑ́ɑ́si kɛ́ riwulɑ. ");
INSERT INTO soy_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Kɛ Erooti uu lɛ̃ pisímɛ́ pi ḿ mɑsí, ɑpi yisi ɑpi ncée pɔlɔ. Kei kɑpi pɛɛ ripɑí, ɑpi yɛ́nu riwɑ́rɛpi tɛ̃ kɑpí pɛɛ kɛtuŋɛleemɛ-pɔ n yɛ̃́ tin pikɛyu sɔ́nɛ pin ti tikilɛ̃. Ari kɛlõ kɛ-i kɛ kɛwɑ̃́ kɛ̃ ɑkɛ ń we tulu, ɑri nyɛrɛ. ");
INSERT INTO soy_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Kɑpi kei ri n yɛ̃́, ɑi mɛyíkíyiki pi lɑrisi. ");
INSERT INTO soy_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Api kɛ́yɔ loni ɑpi kɛwɑ̃́ nɛ kɛuni Mɑɑri yɛnu, ɑpi kɛ yɑ́ɑ́si ɑpí nɛ wulɑ. Api pɛɛ pimɛmɑ́ fénnɛ ɑpi wurɑ nɛ tulɑɑli ŋmɑɑ-ŋmɑɑ nɛ mɛ́kpɔ kɑpi yɛ n sée rɛ miiri lesɛ ɑpi kɛ hɛkɛsi. ");
INSERT INTO soy_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Uléécɑɑ uu pɛɛ́ mɑsí kɛlɑ́rɛ́ kɛ́mɛɛ pi símisi rɛ ɑ́pi kɑpɛ Erooti kɛ́mɛɛ pɛlɛ. Kei kɑpi pɛɛ ncée féé kpísi ɑpí nɛ pikuyu pɛlɛ. ");
INSERT INTO soy_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Kɛ pinyuwɛ pɛ̃ ɑpi n tɔ́mpɔ, Upíimɑ uleecɑɑtumɛ unyinɛ uu kɛlɑ́rɛ́-i Yosɛfi kpɑ́fúmɛ uu rɛ: A yisi, ɑ kɛwɑ̃́ nɛ kɛuni kpísi ɑɑ wuru ɑɑ Esipiti kɛtẽ loni. Erooti yɛ lɑlɛ ukɛ́ kɛ kpu. Lɛ̃ nnyɑ, ɑni hɑ kei-pɔ n tũ likɛ́ hɑ nɛ tu kumúŋɛ́ kpɛ-i kɑm yɛ́ nɔ́ n símisi rɛ ɑni pɛɛmɛ. ");
INSERT INTO soy_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yosɛfi uu yisi uu kɛwɑ̃́ nɛ kɛuni kpísi uú nɛ kɛsinɛcɔ wuru uú hɑ Esipiti-pɔ pésu. ");
INSERT INTO soy_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Uu kei n we Erooti uú hɑ nɛ kpi. Lɛ̃ kɛ Upíimɑ uú pɛɛ uɑntepu m mɑ́ɑsɛ likɛ́ nɛ n wɑ nnyɑ kɑi lɛ̃ wɑ. U pɛɛ rɛ: Nɛ unɛ́ŋmɑ́nɛ sée rɛ ukɛ́ Esipiti kɛteni-i le. ");
INSERT INTO soy_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Kɛ Erooti uu ń kɑ uu céru rɛ pinyuwɛ pɛɛ u kirɑɑsɛlɛ, kuwɔ́i píimɑ kunyinɛ ɑku u wɑi. Uu pɛɛ kumúŋɛ́ kpɛ̃ kɛ pinyuwɛ pɛ̃ ɑpi u n símisi nɛ pɑ́mɛ uu tíyɛsɛ ɑpi siwɑ́ntisi nnɛ́í sɛɛ ɑŋmɛ̃ ɑtɛ́ n tu nɛ sɛ̃ sisíńsɑ́ Pɛtɛlɛhɛm nɛ ɑyu nyɛɛ nɛ kei n kɔ́lɛ̃ kɛ́mɛɛ kóni. ");
INSERT INTO soy_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Lɛ̃ kɛ ɑntepu Yeremii uú pɛɛ mɛkɛɛ-mɛ ḿ mɑ kɑi lɛ̃ wɑ. U pɛɛ rɛ: ");
INSERT INTO soy_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Rɑmɑ-pɔ kɑri nní nnɛ̃́ kómɛiri. Sicɑ́ɑ́ilɑ nɛ ikpɔtu kɛ unyinɛ uu wɔ́rii Rɑsɛɛli yɛɛ lɛ̃ usiwɑ̃ kɛcɑ́ɑ́ téni. Úu nkpɑ́ni lɑ pikɛ́ u kpurɛi. Nɛ kɛsɛ, ɑ́i nkpɑ́ni u tisɛ. ");
INSERT INTO soy_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Upíimɑ uleecɑɑtumɛ unyinɛ uu Esipiti-pɔ Erooti mɛkpɔ-mɑɑ́ kɛlɑ́rɛ́-i Yosɛfi kpɑ́fúmɛ, ");
INSERT INTO soy_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","uu rɛ: A yisi, ɑ kɛwɑ̃́ nɛ kɛuni kpísi ɑɑ́ nɛ Isirɑyɛɛli kɛtẽ pɛlɛ. Pɛpɛɛ pɛɛ ń lɑ pikɛ́ kɛwɑ̃́ kɛ̃ kpu yɛ kpínlɛ. ");
INSERT INTO soy_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Kei kɛ Yosɛfi uu yisi uu kɛwɑ̃́ nɛ kɛuni kpísi uú nɛ Isirɑyɛɛli pɛlɛ. ");
INSERT INTO soy_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Amɑ́ kɛ Yosɛfi uu n kṍ tɛ Aricelɑyuusi yɛɛ usɑ́ɑ Erooti iyɔɔpi Yutee kɛtẽ kɛcɑ́ɑ́ tónɛ, iwɑmɛ ii u wɑi uu pɛɛ́ n yulu rɛ úu kei tonɛnɛ. Uléécɑɑ uu kɔ kɛlɑ́rɛ́-i u símisi uu yisi uu Kɑlilee kɛtẽ-mɛ̃ tɔ́mpɔ, ");
INSERT INTO soy_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","uú hɑ kuyu kpɛ̃ kɑpi yɛ n sée rɛ Nɑsɑrɛti-i tonɛ. Lɛ̃ kɛ ɑntepuyɛ ɑpí pɛɛ ḿ mɑ kɑi lɛ̃ tikilɛ̃. Pi pɛɛ rɛ: Pi yɛ́ kɑm ɑpi kɛwɑ̃́ kɛ̃ séi rɛ Nɑsɑrɛti ukɔ́. ");
INSERT INTO soy_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Aí weri kumúŋɛ́ kunyinɛ-i, Yohɑni Úniwolɛ uu léeri un Yutee kucɛsi kóimɑ-i yóólɛ̃ tɛ: ");
INSERT INTO soy_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ani mɛfinɛ consɛ, Uléécɑɑ iyɔɔpi yɛ nyɑhɑimɛlɛ! ");
INSERT INTO soy_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yohɑni nsímɛ́ kɛ ɑntepu Esɑyi uú pɛɛ mɑɑ rɛ: Usoi rinɔɔ yɛ ri tɛɛ kucɛsi kóimɑ-i n yóólɛ̃ tɛ: Ani Upíimɑ ncee nyɔ́ɔnsɛ, ɑni usiceepi tɛ̃iisɛ. ");
INSERT INTO soy_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Kuyooyoo nkpíí kɛtukɑnkɑ kɛ Yohɑni uú pɛɛ tɑnɑɑlɛ̃ un kɛkónɛpɑmpi kɛhɑlɛ-i télɛ̃. Apɑ́ɑ́ni nɛ mɛtɛ̃́ kuú pɛɛ le. ");
INSERT INTO soy_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Yerusɑlɛm pikɔ́ nɛ Yutee kɛtẽ nnɛ́í pikɔ́ nɛ Yuritɛɛ nkoi kɛtẽ pikɔ́ nnɛ́í yɛ pɛɛ ukɛmɛɛ sɔ́nɑɑpɔlɛ, ");
INSERT INTO soy_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ɑpi yɛ piɑkópɛ yɑ́mnɛ ɑpi tíyɛsɛ uu Yuritɛɛ nkoi kɛ́mɛɛ míni pi wolɛ. ");
INSERT INTO soy_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yohɑni uu yɛ́nu rɛ Pifɑrisi nɛ Pisɑtusee pɛɛ ukɛmɛɛ n sɔ́nɑɑpɔ rɛ ukɛ́ míni pi wolɛ ɑ́pi kusɑ kulúi we. Uu pɛɛ pi mɑɑ rɛ: Nɔ́ ɑkpurii nnyɛ́! Wóo nɔ́ céesi rɛ ɑni Uléécɑɑ kuwɔi kpɛɛ n nyɑhɑimɛ kɑɑsɛ? ");
INSERT INTO soy_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ani nɔ́mɛnɛ́wɑi nɛ nyísɛ rɛ nɔ mɛsei mɛfinɛ consɛlɛ. ");
INSERT INTO soy_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Áni kɑpɛ n nyu rɛ kɑni nní ḿ mɑ́ikɛɛ rɛ Apirɑhɑm yɛɛ nɔ́unɛ́sɑ́ɑyɑhɑ nnyɑ, lɛɛ nɛ nɔ́ piyɛ. Amɑ́ nɛ kɑlɛ kɛ́ nɔ́ símisi rɛ Uléécɑɑ yɛ́ fe uu ɑpɑrɛ nnyɛ́ pɑnsɛsɛ Apirɑhɑm siyɑsɛ. ");
INSERT INTO soy_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Isɔ yɛ pinɑŋɑɑ mɑ́ɑ́lɛnlɛ pikɛ́ nɛ ɑléé iníŋí sémni. Lɛ̃ nnyɑ, kuléé kúye kunsɑ́ ɑpipi sɔnɛ m mɑru, pi yɛ́ ku riké ɑpi nnɑ-i sɑ́pɔ. ");
INSERT INTO soy_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Míni ŋmɑnɛ kɛ nɛ́ɛ nɔ́ wolɛ likɛ́ nyísɛ rɛ nɔ mɛfinɛ consɛlɛ. Amɑ́ uyɛɛ nɛ̃́ mɛmɑ́ɑ́ n sɔ́nti yɛ nɛ́ felɛ. Ám tu ricuruu kɛ́ uɑnɛ́ɛ́ri u mɑhɑ̃. Uyɛɛ sɔ́nti ukɛ́ Nfɑ́ɑsɔnɛ nɛ nnɑ nɔ́ wolɛ. ");
INSERT INTO soy_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","U nkpɑ́ni yɑrɛ usoi nkó yɛɛ kulũ kɑpí nɛ n cɑ́cɑi m múílɛ̃. U yɛ́ kukpépi pééi uu mɛlukɛpipi risímɛ-i súúni, uu kɔ ɑcɔ́lɛ́ ilúkɛ́ té ukɛ́ wɑ ukɛ́ nnɑ tɛnɛcirɛ́ kɛ́mɛɛ ɑ risɛ́. ");
INSERT INTO soy_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Kumúŋɛ́ kpɛ-i kɛ Yohɑni uu kei ń we un pisoi míni wolɛ kɛ Yeesu uu Kɑlilee-pɔ yisi uu Yuritɛɛ nkoi mmɛ-i u lɛɛpɔ rɛ ukɛ́ kɔ uyɛ̃ míni wolɛ. ");
INSERT INTO soy_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Amɑ́ Yohɑni uu yúlu uu rɛ: Nɛ̃́ kɑí nɛ sɑ́ rɛ kɛ́ kɛpɔ́mɛɛ́ hɑpɔ pɔkɛ́ nɛ́ wolɛ, ɑ́i pɔ́ɔ yɛ́ mɛníŋɛ kɛnɛ́mɛɛ́ kɑm. ");
INSERT INTO soy_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yeesu uu pɛɛ u pɛsɛ rɛ: A riyɑ́ likɛ́ pɛɛ lɛ̃ n we kɛlenɛ. Lɛ̃ kɑri yɛ́ fe ɑrí nɛ lɛ̃ nnɛ́í kɛ Uléécɑɑ uu ń lɑ ńsɔnɛ wɑi. Kuu lɛ̃ ḿ mɑ, Yohɑni uu pɛɛ kóm uu míni u wolɛ. ");
INSERT INTO soy_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Kɛ Yohɑni uu lɛ̃ Yeesu piwólɛ ḿ mɑsí, Yeesu uu míni-i léepɔ. Kɛyómɛ ɑkɛ kei nní wúkulɛ uu Uléécɑɑ Nfɑɑsɔnɛ yɛnu nn kɛyómɛcɑɑ-pɔ súiri yɑrɛ rilɔ́ɔlɑ̃, nn ukɛcɑ́ɑ́ tonɛ. ");
INSERT INTO soy_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Tinɔ́ɔ rinyinɛ ɑri pɛɛ kɛyómɛcɑɑ-pɔ leeri rɛ: Nkó yɛɛ Kɛnɛ́pipi lɑlɑ kɛcirɛ, ɑ́m yɛ ukɛcɑ́ɑ́ kṍ. ");
INSERT INTO soy_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Lɛ̃ mɛmɑ́ɑ́, Uléécɑɑ Nfɑɑsɔnɛ nn pɛɛ Yeesu kpísi nń nɛ kucɛsi kóimɑ loni rɛ Setɑni ukɛ́ hɑ u peikɛɛ. ");
INSERT INTO soy_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Kɛ Yeesu uu sitúŋɛ́ ɑfɛɛnɑ nɛ sisinɛ ɑfɛɛnɑ ɑnɔ́ɔ m pɑɑsi, nkṹ nn u wɑi. ");
INSERT INTO soy_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Setɑni yɛɛ m peikɛɛ uú nɛ u kɔ uu u mɑɑ rɛ: Pɔn mɛsei Uléécɑɑ Kɛpipi, ɑ ɑpɑrɛ nnyɛ́ rinɔ́ɔ mɑɑ ɑkɛ́ pɑnsɛ ɑkpɔ́nɔ́, ɑɑ le. ");
INSERT INTO soy_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yeesu uu u pɛsɛ rɛ: Li Nléécɑɑsimɛ́ kɛ́mɛɛ wɔ́lɑɑlɛ̃ tɛ: Ái ilukɛ ŋmɑnɛ yɛɛ yɛ usoi nfɑ́ɑ hɛ, ɑmɑ́ ḿpɑ́ nsímɛ́ ń-ye mɛɛ Uléécɑɑ nnɔɔ-i n léemɛ yɛɛ kɔ usoi nfɑ́ɑ hɛlɛ. ");
INSERT INTO soy_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Setɑni uu kɔ Yeesu kpísi uú nɛ Uléécɑɑ kuyu Yerusɑlɛm sĩ, uú hɑ kei Uléécɑɑ kɛyɔ kɛhórɛ́-pɔ u tɔsi ");
INSERT INTO soy_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","uu rɛ: Pɔn mɛsei Uléécɑɑ Kɛpipi, ɑ mɛpɔ́círɛ kɛteni-i risɑ́pɔ. Li we rɛ li Nléécɑɑsimɛ́ kɛ́mɛɛ wɔ́lɑɑlɛ̃ tɛ: Uléécɑɑ yɛ́ pɔ̃́ nnyɑ upileecɑɑtumɛ rinɔ́ɔ hɛ ɑpi pɔ́ yéu kupɔ́nɑ ɑ́ku kɑpɛ nɛ ripɑrɛ rinyinɛ rinkpɔ́u nnyɑ. ");
INSERT INTO soy_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yeesu uu kɔ u pɛsɛ rɛ: Li kɔ kɛmɛ́ɛ wɔ́lɑɑlɛ̃ tɛ: Kɑpɛ Upíimɑ Upɔ́léécɑɑ peikɛɛ pɔkɛ́ ukɛtɔ yɛ̃. ");
INSERT INTO soy_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Setɑni uu kɔ pikpíkɛ́ u kpɑ́ uú hɑ riyɔ́pɛ mɑɑmɑɑ píimɑ rinyinɛ kɛhórɛ́-pɔ tɔsi uu kɛtẽ nkɛ́ kɛcɑ́ɑ́ ɑyɔɔpiyu nɛ ɑmmulɛ nnɛ́í u nyísɛntɛ ");
INSERT INTO soy_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","uu pɛɛ kɔ u mɑɑ rɛ: Pɔn n ŋmurɛi ɑɑ wúlɑ ɑɑ nɛ́ yɑ́ɑ́si, ɑm nní nnɛ́í pɔ́ hɛ. ");
INSERT INTO soy_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yeesu uu u mɑɑ rɛ: A kɛnɛ́kúrí yisi, Setɑni. Li Nléécɑɑsimɛ́ ritɛlɛ́-i wɔ́lɑɑlɛ̃ tɛ: Upíimɑ Upɔ́léécɑɑ mɛcirɛ kóló kɑí pisɛ rɛ usoi ukɛ́ riwulɑ ukɛ́ yɑ́ɑ́si. ");
INSERT INTO soy_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Kei kɛ Setɑni uu pɛɛ Yeesu riyɑ́, piléécɑɑtumɛ ɑpi ukɛkúrí hɑpɔ ɑpi pɛɛ ukɛcɑ́ɑ́ m pɑílɛ̃. ");
INSERT INTO soy_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Kɛ Yeesu uu n kṍ tɛ Yohɑni yɛ kukpɑniilee-i we, uu yisi uu Kɑlilee kɛtẽ-mɛ̃ pɛlɛ. ");
INSERT INTO soy_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Kuu n hɑ́pɔ, úu Nɑsɑrɛti-i tónɛ, ɑmɑ́ Kɑpɛrinɑwum-mɛ̃ kuu tɔ́mpɔ. Kei yɛ kupiyɛ ritimɛ welɛ, Sɑpilɔɔ nɛ Nɛfitɑlii kɛtẽ-pɔ. ");
INSERT INTO soy_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Lɛ̃ kɛ ɑntepu Esɑyi uú pɛɛ ḿ mɑ likɛ́ nɛ n wɑ nnyɑ kɑi lɛ̃ wɑ. U pɛɛ rɛ: ");
INSERT INTO soy_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Nɔ̃́ Sɑpilɔɔ nɛ Nɛfitɑlii sitẽ pikɔ́, nɔ́ɔ mínimɑɑ ritimɛ ń we nɛ nɔ́ɔ Yuritɛɛ nkoi mɛtɛ́ŋ́ ń we, nɔ̃́ mpuri sɑnɛ pikɔ́, nɔ́ɔ Kɑlilee kɛteni-i ń we, ");
INSERT INTO soy_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","nɔ́ɔ pɛɛ kuŋmɑhɑ-i ń we, ɑni kõ tɛ nɔ nkpéni mɛtɛ́í píimɑ yɛnlɛ. Nkpɔ kuhorɛ-i kɑní pɛɛ́ we, mɛtɛ́í yɛ nkpéni nɔ́ lɛɛpɔlɛ. ");
INSERT INTO soy_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kɑí nɛ kei n kpísi kɛ Yeesu uu pɛɛ piyóó lõ tɛ: Ani mɛfinɛ consɛ, Uléécɑɑ iyɔɔpi yɛ nyɑhɑimɛlɛ. ");
INSERT INTO soy_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yeesu yɛ pɛɛ Kɑlilee kupiyɛ ritimɛ sɔ́nɛlɛ uu Simɔɔ kɑpi rinyíri n hɛ rɛ Piyɛɛ nɛ uuwɑ̃ Antiree yɛnu. Pikɛtɛ́ yɛ pikpíntomɛ́cɔ́pii lɛ. Anyɛŋ́ kɑpí pɛɛ fóm pin nɛ ikpíntomɛ́ cɔ́pii. ");
INSERT INTO soy_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Uu pɛɛ pi mɑɑ rɛ: Ani nɛ́ ritiki kɛ́ tíyɛsɛ ɑni yɛ pisoi pɛɛ yɛ́ nɛ́ rintíki wɛ́ɛ́si. ");
INSERT INTO soy_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Api mɛsɛ nɛ mɛsɛ ɑnyɛŋ́ sɑ́ ɑpi u tiki. ");
INSERT INTO soy_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Kuu kei n yisi, uu kɛ́yu-mɛ̃ sĩ uu kɔ Sepetee piŋmɑ́nɛ pitɛ́ Yɑkupu nɛ uuwɑ̃ Yohɑni yɛnu pi nɛ piusɑɑ Sepetee pin pikuninɔi-i we pin piɑnyɛŋ́ nyɔ́ɔnsɛntɛ. Uu pi séi ");
INSERT INTO soy_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ɑpi mɛsɛ nɛ mɛsɛ kúninɔi nɛ piusɑɑ yɑ́ ɑpi u tiki. ");
INSERT INTO soy_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yeesu yɛ pɛɛ Kɑlilee kɛtẽ nnɛ́í kɔ́ɔ́núlɛnlɛ un Pisuifi ɑyomɛyɑ́hɑɑlee kɛ́mɛɛ céési un kɔ Uléécɑɑ iyɔɔpi Nsímɛ́ Kɛcirɛ yóólɛ̃ un kɔ itói ncɔpuri nɛ ncɔ́ŋ ncɔpuri mɛɛ pisoi m pɛkɛsi pɔisɛntɛ. ");
INSERT INTO soy_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Kei kɛ urinyiri ɑri pɛɛ Sirii kɛtẽ nnɛ́í kɛcɑ́ɑ́ rikɔ́ɔ́nú. Api pɛɛ́ nɛ pitóikɔ́ nnɛ́í ncɔpuri nɛ pɛ̃ nnɛ́í pɛɛ piipiŋɛ-i ncɔ́ŋ nnyinɛ n kómɛi u n sɔ́nɑɑpɔ un pi pɔisɛntɛ. Lɛlɛɛ nní yɑrɛ pinírihélɑɑ nɛ rikpínkpĩ́ pikɔ́ nɛ síkɑnkɑ́lɑ́kɑ́. ");
INSERT INTO soy_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Asoiwuí píimɑ nyɛɛ Kɑlilee-pɔ nɛ Ayu Kɛfi kɛtẽ-pɔ nɛ Yerusɑlɛm-pɔ nɛ Yutee-pɔ nɛ Yuritɛɛ nkoi mɛtɛ́ŋ́-pɔ n léemɛ ɑɑ pɛɛ u n tikilɛ̃. ");
INSERT INTO soy_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Kɛ Yeesu uu lɛ̃ tisoiwuí n yɛ̃́, uu yisi uu riyɔ́pɛ yopoi uú hɑ tonɛ. Upipirɛtiki ɑpi pɛɛ kei u lɛɛpɔ, ");
INSERT INTO soy_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","uu pɛɛ picélɑɑ pi loni. Icélɑɑ iyɛɛ nnyí: ");
INSERT INTO soy_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Pɛpɛɛ n nyu rɛ ɑ́pi Uléécɑɑ inipɛɛ-i líkɑ tulɑɑlɛ̃ pɛɛ pínɑrɛkomɛ. Pɛpɛɛ Uléécɑɑ iyɔɔpi te. ");
INSERT INTO soy_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Pɛpɛɛ n téni pɛɛ pínɑrɛkomɛ. Uléécɑɑ yɛ sɔ́ntilɛ ukɛ́ pi kpurɛi. ");
INSERT INTO soy_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Pɛpɛɛ ḿ purú pɛɛ pínɑrɛkomɛ. Uléécɑɑ yɛ́ kɛtẽ kuú nɛ upisoi m mɛ̃́ pi pɑ. ");
INSERT INTO soy_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Pɛpɛɛ n nɑ́ɑ́si pikɛ́ mɛwɑi wɑ mɛkɛ́ ɑsei n tikilɛ̃ pɛɛ pínɑrɛkomɛ. Uléécɑɑ yɛ́ kɑm uu pimɛlɑ pi wɑi. ");
INSERT INTO soy_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Pɛpɛɛ yɛ picɔ íwɛ n tẽ́ pɛɛ pínɑrɛkomɛ. Uléécɑɑ yɛ́ kɑm uu kɔ pɛ̃ íwɛ téni. ");
INSERT INTO soy_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Pɛpɛɛ kɛfɑ n kpɑ̃́iilɛ̃ pɛɛ pínɑrɛkomɛ. Pi yɛ́ kɑm ɑpi Uléécɑɑ yɛ́nu. ");
INSERT INTO soy_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Pɛpɛɛ n wɛ́ɛ́si rɛ pin yei n we, likɛ́ kei n niŋú pɛɛ pínɑrɛkomɛ. Uléécɑɑ yɛ́ kɑm uu pi séi rɛ usipipi. ");
INSERT INTO soy_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Pɛpɛɛ ɑsei n tíkilɛ̃, pisoi pin lɛ̃ nnyɑ pi wéékusɛlɛ̃ pɛɛ pínɑrɛkomɛ. Pɛpɛɛ Uléécɑɑ iyɔɔpi pikɔ́. ");
INSERT INTO soy_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Nɔ́ mpí kɑpi n lɑ́misi pin nɔ́ wéékusɛlɛ̃ pin nɛ̃́ nnyɑ nɔ́kɛnɛ́cɑ́ɑ́ nnɔ́ɔmɛ símɑɑnkɛɛ, nɔ́ɔ pínɑrɛkomɛ. ");
INSERT INTO soy_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Likɛ́ nɔ́ n lɑ́ɑ́rú nɔn nɛ mpɔ́ɔnɑrɛ cuunkɛɛ. Nɔ́inɛ́hɛɛ yɛ kɛyómɛcɑɑ-pɔ piyɛlɛ ɑ́i kumúŋɛ́ mɑ́. Limɛcɔ kɑpí pɛɛ ɑntepuyɛ pɛɛ pɛɛ́ ń we ɑni kɛlenɛ weri wéékusɛlɛ̃. ");
INSERT INTO soy_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Nɔ́ɔ kɛtẽ kɛcɑ́ɑ́ nnyɑ́si. Nnyɑ́si mɛlõ mɛn nkpéni n kpu, yo kɑpi yɛ́ pɛɛ́ nɛ mɛlõ n pɛsɛ? Li tisɛ pikɛ́ kɛtɑhɑi-mɛ̃ n fómpɔ pisoi pikɛ́ tɛ́lɛisɛ. ");
INSERT INTO soy_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Nɔ́ɔ kɔ kɛtẽ mɛtɛ́í. Kuyu kpɛɛ riyɔ́pɛ kɛcɑ́ɑ́ m mɔ́mɑɑlɛ̃ ɑ́ku yɛ́ fe kukɛ́ m pékɑɑlɛ̃. ");
INSERT INTO soy_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Úkɑ úu yɛ kɛ́firɑ́ɑ risɛ́ uu kucɑ́ri kɛ kipi. Kɛcɑ́cɑ́ kuu yɛ kɛ ritɔsi ɑkɛ ḿpɑ́ úye kɛ́yɔ-i n kpɑ̃́iilɛ̃. ");
INSERT INTO soy_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Limɛcɔ kɑi pisɛ rɛ nɔ́mɛnɛ́tɛ́í mɛkɛ́ n kpɑ̃́iilɛ̃ pisoi nnɛ́í pin mɛ nyɑ́ni. Pisoi pikɛ́ nɔ́mɛnɛ́wɑi sɔnɛ n nyɑ́ni pin nɛ Nɔ́unɛ́sɑ́ɑ Uléécɑɑ yɛɛ kɛyómɛcɑɑ-pɔ ń we ríyu wɑisɛ. ");
INSERT INTO soy_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Yeesu uu kɔ pimɑ́ɑ pi kpɑ́ rɛ: Áni kɑpɛ m músu rɛ Moisi isé nɛ ɑntepuyɛ icélɑɑ kɑm pikópɛ kɑ. Ám kɑ rɛ kɛ́ i kpu, ɑmɑ́ nɛ kɑlɛ rɛ likɛ́ lɛ̃ li. ");
INSERT INTO soy_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Asei kɑm nní nɔ́ símisi, kɛtẽ nɛ kɛyómɛ yɛ kpére we, kɛwɔ́ipi cíú-cíú kɛ́kɑ nɛ́ɛ kɛsímɛ́pi kɛ́kɑ ɑ́kɛ isé kɛ́mɛɛ mɛ́lelɛ mɑ́, likɛ́ hɑ nɛ ḿpɑ́ yo kɛtɔ tu. ");
INSERT INTO soy_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Lɛ̃ nnyɑ, úye un isé rinɔɔ rinyinɛ n kɛsi uu kɔ picɔ céési rɛ pikɛ́ ri kɛsi, ḿpɑ́ rinɔ́ɔ tɛ̃ tinsɑ́ pitíki m pɑ́ɑ́pú, uyɛɛ yɛ́ mɑsí Uléécɑɑ iyɔɔpi kɛ́mɛɛ usíńsɑ́. Amɑ́ úye un ti m pɑkɑrɛ un kɔ picɔ n céési rɛ pikɛ́ limɛcɔ wɑ, uyɛɛ yɛ́ mɑsí Uléécɑɑ iyɔɔpi kɛ́mɛɛ úyukɔɔ́. ");
INSERT INTO soy_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Asei yɛ nyɛ rɛ nɔnsɑ́ Uléécɑɑ mɛlɑ n tikilɛ̃ likɛ́ isé picélɑɑ nɛ Pifɑrisi n fe, ɑ́ni yɛ́ Uléécɑɑ iyɔɔpi kɛ́mɛɛ lõ. ");
INSERT INTO soy_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Yeesu uu kɔ pimɑ́ɑ pi kpɑ́ rɛ: Nɔ kõ tɛ Uléécɑɑ yɛ pirɔ́kpurɛ mɑɑ rɛ: Kɑpɛ usoi kpu. Úye un usoi n kpu, pikɛ́ liute nɛ túhɑɑnɛ. ");
INSERT INTO soy_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Amɑ́ nɛ̃́ nɛ nɔ́ mɑɑ rɛ: Úye un nɛ uucɔ n wɔ́ɔsi, pikɛ́ nɛ liute túhɑɑnɛ. Úye un uucɔ m mɑɑ rɛ: Pɔ́ uníri nkó, pikɛ́ liute nɛ pɛpɛɛ yɛ kɛtúhɑɑnɛ píimɑ-i n túhɑɑnɛ kɛ́mɛɛ hɑ. Úye un uucɔ m mɑɑ rɛ: Pɔ́ uníri nkó, li tu rɛ pikɛ́ liute nnɑ tɛnɛcirɛ́ iwɛ kɛ́mɛɛ risɑ́pɔ. ");
INSERT INTO soy_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Lɛ̃ nnyɑ, pɔn Uléécɑɑ kɛyɔ-i kɛnyɔ́ɔnsɛ-i linyinɛ nɛ Uléécɑɑ pihɛɛ n hɑ, pɔn n léisɛ rɛ upɔ́cɔ yɛ nɛ pɔ́ wɔ́lɑɑlɛ̃, ");
INSERT INTO soy_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","li pisɛ rɛ pɔkɛ́ kei ipɔ́hɛɛ iyɛ̃ tiyɑ́ pɔkɛ́ liute lɛɛpɔ nɔkɛ́ nsímɛ́ nyɔ́ɔnsɛ kɛlenɛ, ɑɑ pɛɛ inyɔ́ɔnsɛ piwɑi pɛlɛ. ");
INSERT INTO soy_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Pitele pin nɔ́ nɛ unyinɛ kɛcɔpɛ n we, nɔn kɛtɑhɑi pitúhɑɑnɛ n sĩ, ɑ tíyɛsɛ nɔ́ nɛ uyɛ̃ ɑni ncée kómɛinɛ. Insɑ́ lɛ̃, u yɛ́ nɛ utúhɑɑnɛ-i pɔ́ hɑ, uyɛ̃ uu pɔ́ kpísi uu pisɔ́ɔ́cɑ pɑ, pɛ̃ ɑpi kukpɑniilee pɔ́ tɑni. ");
INSERT INTO soy_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Asei kɑm nní pɔ́ símisi, pɔnsɑ́ ripɔ́wómɛ nnɛ́í n hɛ́ɛlɛ tikɛ́ tɛnɛ cɑ́kɑ́-cɑ́kɑ́ nɛ kɛtɑnkɑ́ tɔrɔɔ-pɔ, ɑ́ɑ kei mɛ́lelɛ mɑ́. ");
INSERT INTO soy_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Yeesu uu kɔ pimɑ́ɑ pi kpɑ́ rɛ: Nɔ kõ tɛ Uléécɑɑ yɛ mɑɑ rɛ: Kɑpɛ iwɑ́sɑ́ wɑ. ");
INSERT INTO soy_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Amɑ́ nɛ̃́ nɛ nɔ́ mɑɑ rɛ: Utisi úye un ucɔ unɔsi n yɛ̃ uu kɑ́ipi, u ukɛmúŋɛ́ kɛ́mɛɛ iwɑ́sɑ́ nɛ unɔ́si uyɛ̃ piwɑi mɑsilɛ lɛ̃. ");
INSERT INTO soy_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","In tɛ mɛpɔ́nípɛɛ lukɛ-lukɛ mɛɛ ɑkópɛ pɔ́ wɑisɛ, ɑ mɛ lesɛ ɑɑ kɛtɑɑ-pɔ fómpɔ. Li kutɔsi we usoi ukɛ́ uipiŋɛ likɔ́ linyinɛ pɑɑ uú nɛ nfɑ́ɑ yɛnu nɛ kuu yɛ́ uipiŋɛ nnɛ́í ḿ mɑ́ ɑpí nɛ nnɑ tɛnɛcirɛ́ kɛ́mɛɛ u sɑ́pɔ. ");
INSERT INTO soy_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","In tɛ kupɔ́nípɛ lukɛ-lukɛ kpɛɛ yɛ ɑkópɛ pɔ́ wɑisɛ, ɑ ku riké ɑɑ kɛtɑɑ-pɔ ku fómpɔ. Li kutɔsi we pɔkɛ́ kupɔ́nípɛ lukɛ-lukɛ pɑɑ ɑɑ́ nɛ nfɑ́ɑ yɛnu nɛ kɑɑ yɛ́ ipɔ́piŋɛ nnɛ́í ḿ mɑ́ ɑpí nɛ nnɑ tɛnɛcirɛ́ kɛ́mɛɛ pɔ́ sɑ́pɔ. ");
INSERT INTO soy_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Yeesu uu kɔ pimɑ́ɑ pi kpɑ́ rɛ: Nɔ kõ tɛ pi pɛɛ pirɔ́kpurɛ mɑɑ rɛ: Úye un unɔ́si n lɑkɑsɛ, ukɛ́ rítɛlɛ́ wɑ ukɛ́ unɔ́si rimúísɛ rɛ u u yɛlɛ. ");
INSERT INTO soy_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Amɑ́ nɛ̃́ nɛ nɔ́ mɑɑ rɛ: Úye un unɔ́si n lɑkɑsɛ linsɑ́ iwɑ́sɑ́ nnyɑ, iwɑ́sɑ́ kuu lɛ̃ u tɑni. Úye un kɔ unɔ́si kɛ ucɔ uu n lɑ́kɑsɛ n kpísi, iwɑ́sɑ́ kɛ liute uu lɛ̃ wɑ. ");
INSERT INTO soy_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Yeesu uu kɔ pimɑ́ɑ pi kpɑ́ rɛ: Nɔ kõ tɛ pi pɛɛ pirɔ́kpurɛ mɑɑ rɛ: Pɔn tinɔ́ɔ n yekei, ɑ ti ritiki. Pɔn tinɔ́ɔ n yekei rɛ pɔ́ Upíimɑ linyinɛ wɑ, kɑpɛ piwɑi li riyɑ́. ");
INSERT INTO soy_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Amɑ́ nɛ̃́ nɛ nɔ́ mɑɑ rɛ: Áni kɑpɛ yɛ rinɔ́ɔ yekei rɛ nɔ́ Uléécɑɑ linyinɛ wɑ. Áni kɑpɛ yɛ wéeri ɑní nɛ kɛyómɛcɑɑ séi. Kɑi nní kei yɛ Uléécɑɑ riyɔɔpitũ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Áni kɑpɛ yɛ kɔ wéeri ɑní nɛ kɛtẽ séi, kɑi nní kei yɛ Uléécɑɑ ritũ nnyɑ. Áni kɑpɛ yɛ kɔ wéeri ɑní nɛ Yerusɑlɛm séi, kɑi nní kei yɛ uyɔ́ɔpi wɛ́ɛ́sɛ kuyu nnyɑ. ");
INSERT INTO soy_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Áni kɑpɛ yɛ kɔ wéeri ɑní nɛ nɔ́rinɛ́yu séi, kɑ́ni yɛ́ nní n fe nɔkɛ́ ḿpɑ́ nnyúpi cirɛníŋɛ riwɑ́rɑrɑsɛ nɛ́ɛ nɔkɛ́ risɔmɑɑsɛ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Nɔn yɛ m mɑɑ rɛ \"ɛɛɛ\", likɛ́ \"ɛɛɛ\"! Nɔn yɛ m mɑɑ rɛ \"eehei\", likɛ́ \"eehei\"! Nɔn lɛ̃ mɛmɑ́ɑ́ nnyinɛ ncɔ rinkpɑ́sɛ, Setɑni nkɔ́ yɛ mmɛ̃. ");
INSERT INTO soy_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Yeesu uu kɔ pimɑ́ɑ pi kpɑ́ rɛ: Nɔ kõ tɛ pi mɑɑ rɛ: Úye un ucɔ mɛnípɛɛ n fori, pikɛ́ liute mɛnípɛɛ piforɛ cɛɛi. Úye un ucɔ kunĩ́ n wɛhɛ, pikɛ́ liute kunĩ́ piwɛ́hɛ cɛɛi. ");
INSERT INTO soy_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Amɑ́ nɛ̃́ nɛ nɔ́ mɑɑ rɛ: Áni kɑpɛ yɛ usoi mɛwɑi kópɛ cɛɛi. Usoi un kulukɛ-lukɛ-mɛ̃ kɛpɛsɛ pɔ́ n tɔ, ɑ kumíi-mɛ̃ pɑnsɛ ukɛ́ kɔ kei kɛpɛsɛ pɔ́ tɔ. ");
INSERT INTO soy_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Usoi un n lɑ ukɛ́ kɛtɑhɑi pɔ́ sée ukɛ́ kɛpɔ́túkɑnkɑ tene yɔsí, ɑɑ mɛsɛ kupɔ́kpɛ́lɛnku mɑhɑni ɑɑ u múísɛ. ");
INSERT INTO soy_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Usoi un pɔ́ n tĩ un ilũ pɔ́ n cɔnsɛ rɛ ɑ nɛ rinɑ̃ tisɛ u sɑrumpɔ, ɑɑ mɛsɛ i cɔni ɑɑ́ nɛ tinɑ̃ tɛ̃ mɛtɛ́ u sɑrumpɔ. ");
INSERT INTO soy_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Úye un linyinɛ pɔ́ n we, ɑ u hɛ, úye un kɔ rɛ u yɛ́ linyinɛ pɔ́ lõ, ɑ u lonsɛ. ");
INSERT INTO soy_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Yeesu uu kɔ pimɑ́ɑ pi kpɑ́ rɛ: Nɔ kõ tɛ pi mɑɑ rɛ: A upɔ́sɑ́nɛ n lɑ ɑɑ upɔ́lɑ́ɑrɔ ipuri n yulu. ");
INSERT INTO soy_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Amɑ́ nɛ̃́ nɛ nɔ́ mɑɑ rɛ: Ani nɔ́pinɛ́lɑ́ɑrɔ n lɑ, ɑni yɛ pɛpɛɛ nɔ́ n wéékusɛlɛ̃ kɛcɑ́ɑ́ kɛyómɛ yɑ́ɑ́si. ");
INSERT INTO soy_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Nɔn lɛ̃ n wɑi, nɔ pɛɛ mɛsei Nɔ́unɛ́sɑ́ɑ Uléécɑɑ yɛɛ kɛyómɛcɑɑ-pɔ ń we sipipi lɛ. U yɛ tíyɛsɛlɛ ituŋɛ ii pisoi sɔnɛ nɛ pikópɛ leeri, uu kɔ tíyɛsɛ ikónɛ ii cuuni ɑi pɛpɛɛ u m pɑkɑrɛlɛ̃ nɛ pɛpɛɛ ɑ́pi u m pɑkɑrɛlɛ̃ yoriyɛ. ");
INSERT INTO soy_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Asei kɛcɑ́ɑ́, in tɛ pɛpɛɛ nɔ́ ń lɑ ŋmɑnɛ kɑní lɑ, ihɛ́ɛ́ íye kɑni pɛɛ mɛ̃́ tɛ Uléécɑɑ ukɛ́ nɔ́ pɑ? Pilɑmpooyɔɔ́ ŋmɑɑ ricuruu pɔ̃́ nɛ yɛ kɔ limɛcɔ wɑlɛ. ");
INSERT INTO soy_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","In tɛ nɔ́pinɛ́mɑ́rɛcɔ ŋmɑnɛ kɑní yɛ yɑ́ɑsi, yo kɑni pɛɛ wɑ lisɑ́ŋɑ? Pɛpɛɛ ɑ́pi Uléécɑɑ m pɑkɑrɛlɛ̃ ticuruu yɛɛ kɔ limɛcɔ wɑlɛ. ");
INSERT INTO soy_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ani n nyɑḿ nɛ kɛ́tɔ-pɔ yɑrɛ kɛ Nɔ́unɛ́sɑ́ɑ yɛɛ kɛléécɑɑ-pɔ ń we uu ń nyɑḿ nɛ kɛ́tɔ-pɔ mɛcɔ. ");
INSERT INTO soy_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yeesu uu kɔ pimɑ́ɑ pi kpɑ́ rɛ: Ani nɔ́mɛnɛ́círɛ tĩ, ɑ́ni kɑpɛ yɛ lɛ̃ kɑí nɛ n sɑ́ rɛ nɔkɛ́ Uléécɑɑ nnyɑ wɑ pisoi inipɛɛ-i wɑ rɛ pikɛ́ nɔ́ yɛ̃́ pikɛ́ pɑkɑrɛ nnyɑ. Insɑ́ lɛ̃, Nɔ́unɛ́sɑ́ɑ yɛɛ kɛyómɛcɑɑ-pɔ ń we úu ihɛ́ɛ́ íkɑ nɔ́ pɑnɛ. ");
INSERT INTO soy_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Lɛ̃ nnyɑ pɔn úwɛkɔɔ́ linyinɛ n hɛ, kɑpɛ kuloo pi pɔkɛ́ riyóó yɑrɛ kɛ kɛcɑ́ɑ́ kɛcɑ́ɑ́ mɛwɑi pikɔ́ ɑpi yɛ ɑyómɛyɑ́hɑɑlee-i nɛ icée kɛcɑ́ɑ́ n wɑi rɛ pisoi pikɛ́ pi pɑkɑrɛ mɛcɔ. Asei kɛcɑ́ɑ́, pi piihɛ́ɛ́ piyɔ́ɔ́ mɑsilɛ lɛ̃! ");
INSERT INTO soy_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Amɑ́ pɔ́ɔn yɛ linyinɛ úwɛkɔɔ́ n hɛ, kupɔ́nípɛ mii ɑ́ku kɑpɛ lɛ̃ kɛ kulukɛ-lukɛ ɑku n wɑ ceri. ");
INSERT INTO soy_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","A yɛ risɛ́ɛ́ nɛ hɛ. Upɔ́sɑ́ɑ Uléécɑɑ yɛɛ mɛpɔ́wɑi kɑɑ́ nɛ risɛ́ɛ́ n wɑi n nyɑ́ni yɛ́ pɛɛ pɔ́ hɛ́ɛ́lɛ. ");
INSERT INTO soy_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Yeesu uu kɔ pimɑ́ɑ pi kpɑ́ rɛ: Nɔn yɛ kɛyómɛ n yɑ́ɑ́si, ɑ́ni kɑpɛ yɛ kɛcɑ́ɑ́ kɛcɑ́ɑ́ mɛwɑi pikɔ́ mɛcɔ n wɑi. Pi yɛ n lɑlɛ pikɛ́ ɑyómɛyɑ́hɑɑlee-i nɛ sicéepɛnɛ-i n nyɛnu pin nɛ kɛyómɛ yɑ́ɑ́si rɛ pisoi pikɛ́ pi yɛ̃ nnyɑ. Asei yɛ nyɛ kɑm nní nɔ́ símisi rɛ pi piihɛ́ɛ́ piyɔ́ɔ́ mɑsilɛ. ");
INSERT INTO soy_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Amɑ́ pɔ́ɔn yɛ n lɑ pɔkɛ́ kɛyómɛ yɑ́ɑ́si, ɑ yɛ kupɔ́lee lõ ɑɑ hɑ́nɛsi ɑɑ pɛɛ Upɔ́sɑ́ɑ Uléécɑɑ kɛ úkɑ úu n nyɑ́ni yɑ́ɑ́si. Upɔ́sɑ́ɑ Uléécɑɑ yɛɛ n nyɑ́ni lɛ̃ kɑɑ́ nɛ risɛ́ɛ́ n wɑi yɛ́ ipɔ́hɛ́ɛ́ pɔ́ pɑ. ");
INSERT INTO soy_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Nɔn yɛ kɛyómɛ n yɑ́ɑ́si, ɑ́ni kɑpɛ yɛ mɛ́woo kusímɛ́nɑɑpí n wɑi yɑrɛ pɛpɛɛ ɑ́pi Uléécɑɑ n nyu mɛcɔ. Pi yɛ m músu rɛ pin lɛ̃ mɛyɑ̃́ n símɑɑnkɛɛ, Uléécɑɑ yɛ́ nɛ pi kõ. ");
INSERT INTO soy_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Áni kɑpɛ pimɛcɔ n wɑi. Nɔ́unɛ́sɑ́ɑ Uléécɑɑ yɛ lɛ̃ kɑi nɔ́ m pisɛ nyulɛ ɑni yɛ kɛlenɛ li u welu. ");
INSERT INTO soy_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Lɛ̃ kɑi m pisɛ rɛ nɔkɛ́ yɛ kɛyómɛ n yɑ́ɑ́si yɛ nní: Urɔ́sɑ́ɑ, pɔ́ɔ kɛyómɛcɑɑ-pɔ ń we, ");
INSERT INTO soy_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Pisoi pikɛ́ céri rɛ tipɔ́nyíri yɛ kóólɛlɛnlɛ, Ipɔ́yɔ́ɔpi ikɛ́ kɑm, Mɛpɔ́lɑ mɛkɛ́ kɛtẽ kɛcɑ́ɑ́ wɑ yɑrɛ kɛyómɛcɑɑ-pɔ. ");
INSERT INTO soy_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","A yɛ ḿpɑ́ kɛweesi kɛ́ye ilukɛ rɔ́ hɛ, ");
INSERT INTO soy_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","A ɑrɔ́kópɛ rɔ́ sɑ́rɛi yɑrɛ kɛ tɔ́ɔ yɛ kɔ picɔ n sɑ́rɛi pin ɑkópɛ rɔ́ n wɑ mɛcɔ. ");
INSERT INTO soy_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kɑpɛ tíyɛsɛ tɔkɛ́ pipeikɛɛ kɛ́mɛɛ loó. Amɑ́ ɑ kuníri ɑnipɛ-i rɔ́ lesɛ. Li we rɛ pɔ́ɔ iyɔ́ɔpi nɛ ńnɑŋɛ nɛ ḿmulɛ te ḿpɑ́ píyei-pɔ. Amí. ");
INSERT INTO soy_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Nɔn yɛ picɔ ɑkópɛ kɑpi nɔ́ n wɑ pi n sɑ́rɛi, Nɔ́unɛ́sɑ́ɑ yɛɛ kɛyómɛcɑɑ-pɔ ń we yɛ́ kɔ nɔ́ɑnɛ́kɔ́ nɔ́ sɑ́rɛi. ");
INSERT INTO soy_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Amɑ́ nɔnsɑ́ yɛ picɔ ɑkópɛ pi n sɑ́rɛi, Nɔ́unɛ́sɑ́ɑ pɑ́ɑ yɛ́ kɔ nɔ́ɑnɛ́kɔ́ nɔ́ sɑ́rɛi. ");
INSERT INTO soy_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Yeesu uu kɔ pimɑ́ɑ pi kpɑ́ rɛ: Nɔn yɛ ɑnɔ́ɔ m pɑhɑɑlɛ̃, ɑ́ni kɑpɛ yɛ kɛcɑ́ɑ́ kɛcɑ́ɑ́ mɛwɑi pikɔ́ mɛcɔ kɛ́yu n cɑɑilɛ̃. Pi yɛ kɛ́yu n cɔ́hɔnɛlɛnlɛ rɛ pisoi pikɛ́ céri rɛ ɑnɔ́ɔ kɑpi pɑhɑɑlɛ̃. Asei kɑm nní nɔ́ símisi rɛ pi piihɛ́ɛ́ lɛ̃ piyɔ́ɔ́ mɑsilɛ. ");
INSERT INTO soy_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Amɑ́ pɔ́ɔn yɛ ɑnɔ́ɔ m pɑhɑɑlɛ̃, ɑ yɛ lihí ɑɑ ríyu tulɑɑli fóm. ");
INSERT INTO soy_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Pisoi ɑ́pi kɑpɛ nɛ n céri rɛ ɑnɔ́ɔ kɑɑ pɑhɑɑlɛ̃ nnyɑ. Upɔ́sɑ́ɑ Uléécɑɑ kɛ úkɑ úu n nyɑ́ni ŋmɑnɛ yɛɛ nyɑ́ni lɛ̃ kɑɑ́ nɛ risɛ́ɛ́ n wɑi. Uyɛɛ yɛ́ pɛɛ ipɔ́hɛ́ɛ́ pɔ́ pɑ. ");
INSERT INTO soy_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Yeesu uu kɔ pimɑ́ɑ pi kpɑ́ rɛ: Áni kɑpɛ n wɛ́ɛ́si nɔkɛ́ kɛtẽ nté mɛmɑ́ yɛ̃́ nɔkɛ́ curii. Apɑpi nɛ ncɑ́mɛ́ yɛ̀ɛ̀ nté mɛ cɑɑilɛ, piyɑɑ pɔ́ɔ ihɑ́nɑɑ foru ɑpi mɛ yɑ́ɑ́i. ");
INSERT INTO soy_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Amɑ́ kɛyómɛcɑɑ-pɔ kɑí nɛ sɑ́ rɛ nɔkɛ́ mɛmɑ́ yɛ̃́ nɔkɛ́ curii. Apɑpi nɛ ncɑ́mɛ́ nn yɛ kei fe nkɛ́ mɛ cɑɑi, piyɑɑ ɑ́pi yɛ́ kɔ fe pikɛ́ ihɑ́nɑɑ fori pikɛ́ mɛ yɑ́ɑ́i. ");
INSERT INTO soy_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Li we rɛ kei kɛ mɛpɔ́mɑ́ ɑmɛ ń we kɛ kɛpɔ́múŋɛ́ ɑkɛ́ wepɔ. ");
INSERT INTO soy_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Yeesu uu kɔ pimɑ́ɑ pi kpɑ́ rɛ: Inípɛɛ yɛɛ ipiŋɛ kɛfirɑ́ɑ. Ipɔ́nípɛɛ in n nyɑḿ, i yɛ ipiŋɛ nnɛ́í n kpɑ̃́iilɛnlɛ. ");
INSERT INTO soy_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Amɑ́ ipɔ́nípɛɛ in m pɔ́ɔ́lú, ipɔ́piŋɛ nnɛ́í yɛɛ yɛ kuŋmɑhɑ-i n we. Lɛ̃ nnyɑ, in tɛ mɛtɛ́í mɛ̃ kɑɑ m mɑ́ yɛ pɑnsɛlɛ kuŋmɑhɑ, ɑ yɛ̃ tɛ kuŋmɑhɑ píimɑ-i kɑɑ́ we. ");
INSERT INTO soy_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Yeesu uu kɔ pimɑ́ɑ pi kpɑ́ rɛ: Úkɑ úu yɛ́ fe ukɛ́ kumúŋɛ́ kusɛ kɛ́mɛɛ píyɔsɑɑ pitɛ́ n tikilɛ̃. Ḿpɑ́ likɛ́ íye wɑ, u yɛ́ usɛ ipuri yɛ̀ uu ucɔ ikɔ́ n lɑ, nɛ́ɛ u yɛ́ usɛ nɛ kutu n cɔlɛ̃ úu yɛ pɛɛ ucɔ n wɑisɛlɛ̃. Áni yɛ́ fe nɔkɛ́ kumúŋɛ́ kusɛ kɛ́mɛɛ Uléécɑɑ nɛ siwóó n tikilɛ̃. ");
INSERT INTO soy_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Yeesu uu kɔ pimɑ́ɑ pi kpɑ́ rɛ: Lɛ̃ nnyɑ kɑm nɔ́ mɑɑ rɛ ɑ́ni kɑpɛ lɛ̃ kɑni yɛ́ n li nɛ lɛ̃ kɑni yɛ́ ń ntí nɔkɛ́ nɛ nfɑ́ɑ m mɑ́ nɛ ilũ kɑni yɛ́ nɔ́inɛ́piŋɛ n yɑ́rii nfɑsimɛ́ wɑ. Nfɑ́ɑ nn ilukɛ fee, nɛ́ɛ ipiŋɛ yɛɛ ilũ fe? ");
INSERT INTO soy_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ani sinúipi ripɑí nkɛ̃́. Ási yɛ lukɛsi, ɑ́si yɛ kpɑsi, ɑ́si yɛ líkɑ risímɛ súũ. Amɑ́ Nɔ́unɛ́sɑ́ɑ yɛɛ kɛyómɛcɑɑ-pɔ ń we yɛ si kpíniilɛ! Yɑrɛ nɔ̃́ ŋmɑɑ ɑ́ni pɛɛ ríyu mɑ́ lin sinúipi sɛ̃ fee? ");
INSERT INTO soy_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nɔ́ úye yɛɛ yɛ́ fe uu nfɑsimɛ́ wɑi uú hɑ nɛ unfɑɑ ɑŋmɛ̃ ḿpɑ́ nkɑ́ripi kpɑ́sɛ? ");
INSERT INTO soy_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Yo nnyɑ kɑni pɛɛ nkpɑ́ni ilũ kɑni yɛ́ nɔ́inɛ́piŋɛ n yɑ́rii nfɑsimɛ́ wɑi? Ani mɛyúi mɛɛ yɛ sicɑrɛ-i n fɛlɛsi ripɑí nkɛ̃́! Ámɛ pikɛi píkɑ wɑi, ɑ́mɛ kɔ ilũ íkɑ nyɛlɑɑnkɛɛ. ");
INSERT INTO soy_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Amɑ́ kɛ́ nɔ́ símisi rɛ ḿpɑ́ nɛ lɛ̃, Uyɔ́ɔpi píimɑ Sɑlomɔɔ ricuruu nɛ ummulɛ mmú nnɛ́í, úu pɛɛ ilũ inyinɛ mɑ́ yɛɛ ń nyɑḿ ɑi mɛfɛlɛ mɛnyinɛ tulu. ");
INSERT INTO soy_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nɔ́ pisoi mpí nfɑtɛnɛ ńn piyɛ. In tɛ Uléécɑɑ yɛ mɛyúi mɛɛ nɛni kɛcɑrɛ-i ń we pin kɔ kóso nnɑ mɛ ŋmɑɑsinɛ lɛ̃ sɔnukusɛ, nɔ̃́ kɛcɑ́ɑ́ kúu yɛ́ pɛɛ mɛníŋɛ ripɑíí? ");
INSERT INTO soy_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Lɛ̃ nnyɑ, ɑ́ni kɑpɛ yɛ nfɑsimɛ́ wɑ nɔkɛ́ mɑɑ rɛ: Yo kɑri yɛ́ li nɛ́ɛ yo kɑri yɛ́ ń ntí nɛ́ɛ yo kɑri yɛ́ tɑ̃. ");
INSERT INTO soy_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Pɛpɛɛ ɑ́pi Uléécɑɑ n nyu pɛɛ lɛ̃ likɔ́ mɛsɛ́rɛ wɛ́ɛ́si. Amɑ́ Nɔ́unɛ́sɑ́ɑ yɛɛ kɛyómɛcɑɑ-pɔ ń we yɛ nyulɛ lɛ̃ kɑi nɔ́ m pisɛ. ");
INSERT INTO soy_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Uléécɑɑ iyɔɔpi kɑni yɛ́ mɛfoí wɛ́ɛ́si, ɑni kɔ lɛ̃ kuu m pisɛ n wɑi, u yɛ́ kɔ litɔ́rɔɔ nní nnɛ́í mpuri pihɛɛ nɔ́ rikpɑ́. ");
INSERT INTO soy_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Lɛ̃ nnyɑ, ɑ́ni kɑpɛ yɛ nfɑsimɛ́ wɑ rɛ íye kɑi yɛ́ kóso n we. Li we rɛ ḿpɑ́ kɛyɑ́ɑ kɛ́ye nɛ kɛnkɔ́ yɛ mu. ");
INSERT INTO soy_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Yeesu uu kɔ pimɑ́ɑ pi kpɑ́ rɛ: Áni kɑpɛ yɛ picɔ nɛ túhɑɑnɛ, Uléécɑɑ úu kɑpɛ nɛ nɔ̃́ n túhɑɑnɛ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Lɛ̃ kɑni yɛ picɔ ɑkópɛ ḿ pɑ mɛcɔ kɛ Uléécɑɑ uu ɑkópɛ nɔ́ pɑnɛ. Kɛmúŋɛ́ kɛ̃ kɑni yɛ nɛ picɔ ḿ musí kɑpi kɔ nɛ nɔ̃́ músunɛ. ");
INSERT INTO soy_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Yo nnyɑ kɑɑ kɛyúipi kɛɛ upɔ́cɔ mɛnipɛɛ-i ń we nyɑ́ni, ɑ́ɑ pɛɛ kɛnɑwɛlɛ́pi kɛɛ mɛpɔ́kɔ́-i ń we nyɑ́ni? ");
INSERT INTO soy_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Íye kɑɑ yɛ́ fe ɑɑ ucɔ mɑɑ rɛ: A nyɛrɛ kɛ́ kɛyúipi mɛpɔ́nípɛɛ-i lesɛ, kɛnɑwɛlɛ́pi kɛn kɔ pɛɛ́ nɛ mɛpɔ́kɔ́ kɛ́mɛɛ́ we? ");
INSERT INTO soy_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","A tíyɛ pɔ kɛcɑ́ɑ́ kɛcɑ́ɑ́ mɛwɑi mɑ́ kpɑ! Kɛnɑwɛlɛ́pi kɛɛ mɛpɔ́nípɛɛ-i ń we kɑɑ yɛ́ mɛfoí lesɛ ɑɑ pɛɛ ńsɔnɛ n nyɑ́ni ɑɑ́ nɛ kɛyúipi kɛɛ ucɔ mɛnipɛɛ-i ń we lesɛ. ");
INSERT INTO soy_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Áni kɑpɛ yɛ Uléécɑɑ likɔ́ sipɔpi pɑ rɛ sikɛ́ li. Insɑ́ lɛ̃, si yɛ́ nɛ nɔ́ pɑnsɛ ɑsi nɔ́ kɛ́hɛni. Áni kɑpɛ yɛ kɔ nɔ́inɛ́kólɛ́ kɛcirɛ ɑ́fɔŋ kɛyu-i risɑ́. Insɑ́ lɛ̃, ɑ yɛ́ i tɛlɛisɛ ii cɑɑi. ");
INSERT INTO soy_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Yeesu uu kɔ pimɑ́ɑ pi kpɑ́ rɛ: Ani yɛ Uléécɑɑ we, u yɛ́ nɔ́ hɛ. Ani yɛ ukɛmɛɛ piwɛ́lɑɑ hɑ, u yɛ́ tíyɛsɛ ɑni yɛ́nu. Ani yɛ ihɑ́nɑɑ u rikóḿkóḿ, u yɛ́ nɔ́ hɑ́nnɛ. ");
INSERT INTO soy_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Úye un u n we, u yɛ u hɛlɛ. Úye un ukɛmɛɛ linyinɛ n wɛ́ɛ́si, u yɛ li yɛnlɛ. Úye un kɔ ihɑ́nɑɑ u rinkóḿkóḿ, u yɛ u hɑ́nnɛlɛ. ");
INSERT INTO soy_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Nɔ́ úye kɛpipi kɛɛ yɛ́ ilukɛ u we, uu pɛɛ ripɑrɛ kpísi uu kɛ hɛ? ");
INSERT INTO soy_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Nɛ́ɛ nɔ́ úye kɛpipi kɛɛ yɛ́ nkpíntomɛ́ u we, uu pɛɛ iwɑ́ɑ kpísi uu kɛ hɛ? ");
INSERT INTO soy_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ḿpɑ́ nɔ́ pikpɑ́ɑ́ree mpí nní, nɔ yɛ felɛ ɑni nɔ́sinɛ́pipi lisɔnɛ hɛ. Nɔ́unɛ́sɑ́ɑ yɛɛ kɛyómɛcɑɑ-pɔ ń we yɛɛ yɛ́ pɛɛ mɛníŋɛ pɛpɛɛ lisɔnɛ u m pisɛ pihɛɛ riyɑ́ɑ́? ");
INSERT INTO soy_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Lɛ̃ nnɛ́í kɑni ń lɑ rɛ pisoi pikɛ́ yɛ nɔ́ wɑ, ɑni yɛ limɛcɔ pi wɑ. Lɛ̃ kɛ isé nɛ ɑntepuyɛ ɑpi pisɛ rɛ nɔkɛ́ yɛ wɑ. ");
INSERT INTO soy_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Yeesu uu kɔ pimɑ́ɑ pi kpɑ́ rɛ: Ani nɛ rinɔnɔɔ tɛɛ m mɔ́kú-mɔ́kúlɛ̃ lompɔ. Tinɔnɔɔ pɛ́rɛ́-pɛ́rɛ́ nɛ ncée mɛɛ n lɑɑnu pelele yɛ nkpɔ-mɛ̃ simpɔlɛ. Pisoi kulúi pɛɛ yɛ nɛ kei lompɔ. ");
INSERT INTO soy_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Amɑ́ rinɔnɔɔ tɛɛ yɛ nɛ nfɑ́ɑ-mɛ̃ ń hɑ yɛ mɔ́kú-mɔ́kúlɛnlɛ. Lincee pɔ̃́ nɛ kɔ nkpɑ́ni mɛsɛ wɛ́kɛ́-wɛ́kɛ́. Pisoi pɛɛ yɛ n n yɛ̃́ ɑ́pi kulúi we. ");
INSERT INTO soy_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Yeesu uu kɔ pimɑ́ɑ pi kpɑ́ rɛ: Ani nɔ́mɛnɛ́círɛ tĩ nɛ ɑntepuyɛ nɔɔmɛ. Pi yɛ rikpɑ́rɑ́lɛ ɑpí n nyísɛlɛ̃ tɛ pi ɑsɑ́ŋpipi lɛ, nɛ́ḿpɑ́kɑnɛ pi pisifɑ-i ɑ́kpɛ kpɑ́ɑ́ree lɛ. ");
INSERT INTO soy_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Pimɛwɑi kɑni yɛ́ɛ́ nɛ pi ceri yɑrɛ kɑpi yɛ ɑléépipi nɛ ɑkuléé ń céri mɛcɔ. Ápi yɛ ɑrɛɛsɛɛ sinípɛleépi kɛcɑ́ɑ́ tɔ. Ápi yɛ kɔ ɑfiiki ɑhííhíí kɛcɑ́ɑ́ tɔ. ");
INSERT INTO soy_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kuléé sɔnɛ kpɛɛ yɛ ɑpipi sɔnɛ mɑri, kuléé kópɛ pɔ́ɔ ɑpipi kópɛ mɑru. ");
INSERT INTO soy_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Limɛcɔ kɛ kuléé sɔnɛ ɑ́ku yɛ fe kukɛ́ ɑpipi kópɛ mɑri, kukópɛ pɑ́ɑ yɛ kɔ fe kukɛ́ ɑpipi sɔnɛ mɑri. ");
INSERT INTO soy_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Pi yɛ kuléé kpɛɛ ɑ́ku ɑpipi sɔnɛ m mɑ́ru rikélɛ ɑpi nnɑ-i ku sɑ́pɔ. ");
INSERT INTO soy_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Limɛcɔ kɑni yɛ́ɛ́ ɑntepuyɛ nɔɔmɛ mɛwɑi nɛ pi ceri. ");
INSERT INTO soy_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Yeesu uu kɔ pimɑ́ɑ pi kpɑ́ rɛ: Ái pɛ̃ nnɛ́í pɛɛ nɛ́ n sélei rɛ Upíimɑ, Upíimɑ pɛɛ Uléécɑɑ iyɔɔpi kɛ́mɛɛ loninɛ, ɑmɑ́ pɛpɛɛ Unɛ́sɑ́ɑ yɛɛ kɛyómɛcɑɑ-pɔ ń we mɛlɑ n wɑi ŋmɑnɛ pɛɛ Uléécɑɑ iyɔɔpi kɛ́mɛɛ loninɛ. ");
INSERT INTO soy_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Mɛyɑ̃́ nɛ́ hɑ kɛyɑ́ɑ kɛ̃ kɛ Uléécɑɑ uu pisoi n túhɑɑnɛnɛ nɛ́ mɑɑ rɛ: Upíimɑ, Upíimɑ, ɑ́i tɔ́ɔ ripɔ́nyíri nɛ Uléécɑɑ nsímɛ́ pisoi símisi ɑri ɑníri lɑkɑsɛntɛ ɑri kɔ tipɔ́nyíri nɛ mɛwɑisɑŋɑ kulúi wɑpisii? ");
INSERT INTO soy_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Kei kɑm yɛ́ pɛɛ pi símisi ńsɔnɛ rɛ: Ám píkɑi nɔ́ nyu! Nɔ́ pikópɛkɔɔ́ mpí. Ani kɛnɛ́kúrí nté rinyɔsɔ́! ");
INSERT INTO soy_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Yeesu uu pɛɛ ntɔ́rɔɔ pi mɑɑ rɛ: Úye un nsímɛ́ mmú nnɛ́í kutu rincɔ un kɔ n tintiki, u we yɑrɛ usɔhɔɔ yɛɛ kɛpɑrɛ kɛcɑ́ɑ́ ukɛyɔ m mɔ̃́. ");
INSERT INTO soy_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ikónɛ ii cuuni, ikói ii yipu, kuyɔ píimɑ kunyinɛ ɑku kɛ́yɔ kɛ-i pépu, ɑ́i nkpɑ́ni líkɑ kɛ wɑ, kɑkɛ kɛpɑrɛ kɛcɑ́ɑ́ m mɔ́mɑɑlɛ̃ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Nkó yɛɛ nsímɛ́ mmú nnɛ́í kutu rińcɔ, úu yɛ pɛɛ n titiki yɛ we yɑrɛ uníri yɛɛ nnyɛnɛ kɛcɑ́ɑ́ ukɛyɔ mɛ́woo m mɔ̃́. ");
INSERT INTO soy_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ikónɛ ii cuuni ikói ii yipu, kuyɔ píimɑ kunyinɛ ɑku kɛ́yɔ kɛ-i pépu, ɑkɛ lólu ɑkɛ foru tɛ́kɛ́-tɛ́kɛ́. ");
INSERT INTO soy_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Kɛ Yeesu uu ɑnɔ́ɔ nyɛ̃ nnɛ́í pimɑ́ɑ ḿ mɑsí, umɛcélɑɑ ɑmɛ pɛɛ pisoi riwúí mɛyɑ̃́ nnɔ́ɔ n yipɑɑlɛ̃. ");
INSERT INTO soy_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Uyɛ̃ úu céési yɑrɛ isé picélɑɑ mɛcɔ. Amɑ́ Uléécɑɑ nnɑŋɛ kɛ uyɛ̃ uú pɛɛ́ nɛ céési. ");
INSERT INTO soy_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Kɛ Yeesu uu riyɔ́pɛ rincɛ́pimɛ mɛmɑ́ɑ́, ɑsoiwuí píimɑ ɑnyinɛ ɑɑ pɛɛ u n tikilɛ̃. ");
INSERT INTO soy_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Kei kɛ uyɔ̃́ unyinɛ uu ukɛkúrí hɑ́pɔ uu wúlɑ uu rɛ: Upíimɑ, pɔn n lɑ, pɔ́ nɛ́ wolɛ ɑm funi. ");
INSERT INTO soy_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yeesu uu kunípɛ sɑɑpɔ uu u cɑ uu rɛ: Nɛ lɑlɛ ɑ peí. Mɛsɛ nɛ mɛsɛ, kɛyɔ̃́ ɑkɛ ukɛcɑ́ɑ́ lelu uu funi. ");
INSERT INTO soy_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yeesu uu pɛɛ rinɔ́ɔ u hɛ rɛ: Kɑpɛ wɑ unyinɛ ukɛ́ kṍ. Amɑ́ ɑ uyɛɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑi lɛɛpɔ ukɛ́ pɔ́ musí ukɛ́ yɛ̃́ tɛ pɔ peí, ɑɑ pɛɛ limɛmɑ́ɑ́ inyɔ́ɔnsɛ kɛ Moisi uú nɛ nɔ́ n tíyɛ wɑi likɛ́ ḿpɑ́ úye nyísɛ rɛ pɔ peilɛ. ");
INSERT INTO soy_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yeesu uu pɛɛ limɛmɑ́ɑ́ ncée kpísi uu Kɑpɛrinɑwum kuyu lompɔ. Rɔm usɔ́ɔ́cɑ kpéẽ unyinɛ uu ukɛkúrí nyɔsɔ́pɔ uú nɛ u téni rɛ ukɛ́ u comɛ. ");
INSERT INTO soy_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","U Yeesu mɑɑ rɛ: Upíimɑ, unɛ́kɛikɔ́ yɛ kɛ́yɔ-pɔ nɛ kufɔ́ŋ finupɔlɛ lin ɑ́nɑ u pɑhɑɑlɛ̃, úu nkɛ́hɛ̃ nɛ kɛ́yu mɑ́pɔ. ");
INSERT INTO soy_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yeesu uu u pɛsɛ rɛ: Nɛ kõ, nɛ́ hɑ u pɔisɛ. ");
INSERT INTO soy_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Kei kɛ usɔ́ɔ́cɑ kpéẽ uyɛ̃ uu pɛɛ kɔ rɛ: Ám tu rɛ pɔkɛ́ kɛnɛ́yɔ-i lompɔ, Upíimɑ. Amɑ́ pɔ kpére rinɔ́ɔ hɛ, unɛ́kɛikɔ́ yɛ lɛ̃ peilɛ. ");
INSERT INTO soy_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Li we rɛ nɛ̃́ ticuruu yɛ pinɛ́wɛ́ɛ́sɛ mɑ́lɛ nɛn pi pɑkɑrɛlɛ̃. Nɛn kɔ pisɔ́ɔ́cɑ mɑ́ pɛɛ nɛ̃́ m pɑkɑrɛlɛ̃. Nɛn piunyinɛ m mɑɑ rɛ ukɛ́ mɛ́ye hɑ, u yɛ hɑlɛ. Nɛn kɔ ucɔ m mɑɑ rɛ ukɛ́ kɑm, u yɛ kɑlɛ. Nɛn kɔ unɛ́kɛikɔ́ m mɑɑ rɛ ukɛ́ linyinɛ wɑ, u yɛ li wɑlɛ. ");
INSERT INTO soy_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Kɛ Yeesu uu ɑnɔ́ɔ nyɛ̃ n kṍ, ɑi nnɔ́ɔ u yipu, uu pɛpɛɛ u n tíkilɛ̃ mɑɑ rɛ: Asei kɑm nní nɔ́ símisi, ɑ́m Isirɑyɛɛli kɛteni-i ricuruu úkɑ kɛ́mɛɛ nfɑtɛnɛ píimɑ mmú ncɔ yɛnɑɑlɛ̃. ");
INSERT INTO soy_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nɛ lɑ kɛ́ nɔ́ símisi rɛ pisoi mɛyɑ̃ yɛ́ kɛtuŋɛleemɛ nɛ kɛtuŋɛlolɛ́-mɛ̃ leemɛ, pi nɛ pirɔ́sɑ́ɑyɑhɑ Apirɑhɑm nɛ Isɑɑki nɛ Yɑkupu ɑpi Uléécɑɑ iyɔɔpi-i tonɛ ɑpi kɛsẽ́ ilukɛ le. ");
INSERT INTO soy_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Amɑ́ pi yɛ́ pɛ̃ kɑí pɛɛ́ nɛ n sɑ́ rɛ pikɛ́ Uléécɑɑ iyɔɔpi kɛ́mɛɛ lõ kɛtɑhɑi kuŋmɑhɑ-mɛ̃ fómpɔ ɑpi pɛɛ kei m pupukɛɛ pin inĩ́ tɑkɑi. ");
INSERT INTO soy_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Kei kɛ Yeesu uu pɛɛ usɔ́ɔ́cɑ kpéẽ uyɛ̃ mɑɑ rɛ: A n ŋme ɑ kui. Mpɔ́fɑtɛnɛ nnyɑ, lɛ̃ kɑɑ m pisɛ yɛ́ wɑ. Ukɛikɔ́ uu mɛsei ituŋɛ isɛ iyɛ-i pélu. ");
INSERT INTO soy_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yeesu uu pɛɛ limɛmɑ́ɑ́ yisi uu Piyɛɛ kɛyɔ sĩ, uu kei uyɛ̃ ulɔ́hɔ́ni lɛɛpɔ un finu uipiŋɛ in tolú. ");
INSERT INTO soy_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yeesu uu kunípɛ u cɑ, kupiŋɛtoi ɑku tɛnɛ, unɔ́si uu yisi uu ukɛcɑ́ɑ́ pɑí. ");
INSERT INTO soy_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Kɑi nnyɔ́ɔ́ n wɑ, ɑpí nɛ pinírihélɑɑ kulúi Yeesu lɛɛpɔ, uu rinɔ́ɔ ɑníri mɑlɛ, ɑɑ wuru ɑɑ pikɛmɛɛ́ lelu, uu kɔ pitóikɔ́ nnɛ́í pɔisɛntɛ. ");
INSERT INTO soy_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Lɛ̃ kɛ ɑntepu Esɑyi uú pɛɛ ḿ mɑ kɛ mɛwɑi mɛ̃ ɑmɛ ritiki rɛ: Tirɔ́nɑ́rɛi kuú yɔsí uu irɔ́tói kpísi uu cɔni. ");
INSERT INTO soy_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Kɛyɑ́ɑ kɛnyinɛ kɛ Yeesu uu Kɑlilee kupiyɛ ritimɛ we, risoiwuí ɑri u kɑ́lɑɑpɔ. Kei kuu pɛɛ upipirɛtiki mɑɑ rɛ u nɛ pɛ̃ pikɛ́ ritímɛ ricɔ-mɛ̃ hɑ. ");
INSERT INTO soy_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Kei kɛ isé ucélɑɑ usɛ uú nɛ u rikɔ uu u mɑɑ rɛ: Ucélɑɑ, ḿpɑ́ yei kɑɑ sĩ́ nɛ́ pɔ́ ritiki. ");
INSERT INTO soy_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yeesu uu u pɛsɛ rɛ: Sisɑ́ŋɑ́ yɛ siɑlééri mɑ́lɛ, sinúipi sin siɑyɑ́mɛ́ mɑ́. Amɑ́ nɛ̃́ Usoi Kɛpipi, ɑ́m tíkɑ mɑ́ kɑm yɛ́ ríyu n tɑmpɔ kɛ́ wéntɛ. ");
INSERT INTO soy_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Kei kɛ uupirɛtiki usɛ pɔ́ɔ pɛɛ kɔ u mɑɑ rɛ: Upíimɑ, ɑ ncée nɛ́ hɛ kɛ́ hɑ unɛ́sɑ́ɑ kulɛsi kɛ́ pɛɛ kɛlenɛ pɔ́ ritiki. ");
INSERT INTO soy_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yeesu uu u pɛsɛ rɛ: A nɛ́ ritiki ɑɑ pikpɔkpɔ yɑ́ pikɛ́ pipikpɔkpɔ kulɑɑnkɛɛ. ");
INSERT INTO soy_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yeesu uu kúninɔi kɛ́mɛɛ lompɔ, upipirɛtiki ɑpi yisi ɑpi u lɛɛpɔ. ");
INSERT INTO soy_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Kɑpi n tɔ́su, mɛyɔ píimɑ mɛnyinɛ ɑmɛ pipépɛ kɑ́pɑ́ɑ́, míni ɑmɛ kúninɔi yɑrii. Amɑ́ Yeesu pɔ́ɔn pɛɛ lɔni. ");
INSERT INTO soy_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Upipirɛtiki ɑpi ukɛkúrí nyɔsɔ́pɔ ɑpi u yóŋsɛ ɑpi rɛ: Upíimɑ ɑ rɔ́ comɛ, tɔ kpíninɛ. ");
INSERT INTO soy_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yeesu uu pɛɛ pi mɑɑ rɛ: Yo nnyɑ kɑni iwɑmɛ wɑi? Nɔ́ pisoi mpí, nɔ́nnɛ́fɑtɛnɛ ńn piyɛ. Kei kuu pɛɛ yisi uú nɛ kuyɔ nɛ míni cɛ́si, ɑi pɛɛ sɛ́ɛ́ lɛ́kɛ́-lɛ́kɛ́ keu. ");
INSERT INTO soy_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ai ḿpɑ́ úye nnɔ́ɔ yipu ɑpi pɛɛ pimɛcɔpɛcirɛ n tee rɛ: Usoi úye kɛcirɛ yɛ nkó kɑí nɛ kuyɔ nɛ míni ripɛ́nɛ lin u pɑkɑrɛlɛ̃? ");
INSERT INTO soy_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Kɛ Yeesu uu kupiyɛ ritimɛ tɛ-i n yisi uu Kɑtɑrɑɑ kɛtẽ-pɔ ritimɛ ricɔ tulu, pinírihélɑɑ pitɛ́ pinyinɛ ɑpi ɑkpíí kɛcɔpɛ leeri ɑpi u lɛɛpɔ. Pisoi pɛ̃ tikpɑ́kɑ́rɑ́ kɑpi n wɑi nnyɑ, úkɑ úu yɛ pɛɛ kɑhɑ ukɛ́ ncée mmɛ̃ titiki. ");
INSERT INTO soy_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Kɑpí nɛ Yeesu rinsɑ́nɛ, ɑpi pɛɛ́ n cɑ́ɑ́i rɛ: Uléécɑɑ Kɛpipi, tɔ́ nɛ mpɔ̃́ nɛ ń-ye? Pɔ kɑ rɛ pɔkɛ́ íwɛ rɔ́ wɑ Uléécɑɑ ituŋɛ iyɛ-i kuú nɛ rɔ́ n túhɑɑnɛnɛ ikɛ́ kɛlenɛ tuu? ");
INSERT INTO soy_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Áfɔŋ ɑnyinɛ yɛ pɛɛ kei kulúi welɛ ɑn túkuri, ɑ́i mɛyɑ̃́ nɛ kɛtɑɑ pi we. ");
INSERT INTO soy_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Aníri ɑɑ Yeesu suúlusɛ rɛ: Pɔn n lɑ pɔkɛ́ pisoi mpí-i rɔ́ lɑ́kɑsɛ, ɑ tíyɛ tɔkɛ́ hɑ ɑ́fɔŋ nnyɛ́ nyɛɛ nté-pɔ nní kulúi ń we kɛ́mɛɛ lompɔ. ");
INSERT INTO soy_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yeesu uu ɑ mɑɑ rɛ: Ani n tɔ́su! Aɑ pɛɛ pisoi pitɛ́ pɛ-i yisi ɑɑ́ hɑ ɑ́fɔŋ nyɛ-i loni. Mɛsɛ nɛ mɛsɛ, ɑ́fɔŋ nyɛ̃ ɑɑ wuru ɑɑ́ nɛ rikúú cɛ́pi ɑɑ́ hɑ nɛ kupiyɛ-i kpúupɔ ɑɑ kpíni. ");
INSERT INTO soy_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Pɛpɛɛ pɛɛ ɑ́fɔŋ nyɛ̃ m mɛ̃́ ɑpi itóó kɑrii ɑpi kuyu sĩ ɑpí hɑ lɛ̃ nnɛ́í lɛɛ n wɑ nɛ lɛlɛɛ pinírihélɑɑ pɛ̃ n wɑ kɛɛni. ");
INSERT INTO soy_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kei kɛ kuyu pisoi nnɛ́í ɑpi ripehépɔ ɑpi Yeesu lɛɛpɔ. Kɑpi u n yɛ̃́, ɑpi u suúlusɛ rɛ ukɛ́ pikɛteni-i le ukɛ́ tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yeesu uu pɛɛ kúninɔi loni uu kupiyɛ pitɛ́ŋ́ kpɑ́, uu ukuyu pɛlɛ. ");
INSERT INTO soy_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Api pɛɛ kɛ́kɑnkɑ́lɑ́kɑ́ kɛnyinɛ risɑ́ŋɑ́ɑ́pɔrɛ́ wɑi ɑpí nɛ u lɛɛpɔ. Kuu pinfɑtɛnɛ n yɛ̃́, uu kɛ́kɑnkɑ́lɑ́kɑ́ kɛ̃ mɑɑ rɛ: A n kɑhɑri unɛ́pipi, nɛ ɑpɔ́kópɛ pɔ́ sɑ́rɛilɛ. ");
INSERT INTO soy_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Kei kɛ isé picélɑɑ pinyinɛ ɑpi pɛɛ pimɛcɔpɛcirɛ tee rɛ: Utisi nkó yɛ Uléécɑɑ riyu kopulɛ! ");
INSERT INTO soy_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yeesu uu pikɛmúŋɛ́ céru uu rɛ: Yo nnyɑ kɑni lɛ̃ nɔ́sinɛ́fɑ-i simúŋɛ́ kópɛ wɑi? ");
INSERT INTO soy_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Anɔ́ɔ nnyɛ́ kɛtɛ́ kɛcɔpɛ, ríye tɛɛ fɑ́kú nɛ ricɔ: Kɛ usoi uu yɛ́ kɛ́kɑnkɑ́lɑ́kɑ́ ḿ mɑɑ rɛ: Nɛ ɑpɔ́kópɛ pɔ́ sɑ́rɛi nɛ́ɛ kuu yɛ́ kɛ ḿ mɑɑ rɛ: A yisi ɑ sɔ́nɛ? ");
INSERT INTO soy_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Nɛ lɑ nɔkɛ́ céri rɛ nɛ̃́, Usoi Kɛpipi yɛ kɛtẽ kɛcɑ́ɑ́ ńnɑŋɛ mɑ́lɛ kɛ́ nɛ pisoi ɑkópɛ pi sɑ́rɛi. Kei kuu pɛɛ kɛ́kɑnkɑ́lɑ́kɑ́ kɛ̃ mɑɑ rɛ: A yisi ɑ nyɛrɛ, ɑ ripɔ́sɑ́ŋɑ́ɑ́pɔrɛ́ pílɛsi ɑɑ́ kulu. ");
INSERT INTO soy_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Utisi uu yisi uú kulu. ");
INSERT INTO soy_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Kɛ pisoi kulúi pɛɛ kei ń we ɑpi lɛ̃ n yɛ̃́, ɑi pírí pi wɑi ɑpi pɛɛ Uléécɑɑ m pɑkɑrɛntɛ rɛ u sisoipipi ńnɑŋɛ píimɑ mmɛ̃ hɛ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yeesu uu kɛ́yu-mɛ̃ n tɔ́su uu utisi unyinɛ kɑpi yɛ n sée rɛ Mɑtiyee yɛnu un pilɑmpooyɔɔ́ kɛkɛi-i tṹ. Uu u mɑɑ rɛ: A yisi ɑ nɛ́ ritiki. Mɑtiyee uu yisi uu u tiki. ");
INSERT INTO soy_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yeesu uu pɛɛ lɛ̃ mɛmɑ́ɑ́ sĩ́ uú hɑ Mɑtiyee kɛyɔ-i n tũ un ilukɛ le. Pilɑmpooyɔɔ́ nɛ pikópɛkɔɔ́ picɔ ɑpí hɑpɔ ɑpi kei u nɛ upipirɛtiki kɛkúrí tonɛ. ");
INSERT INTO soy_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Kɛ Pifɑrisi ɑpi lɛ̃ n yɛ̃́, ɑpi Yeesu pipirɛtiki mɑɑ rɛ: Yo nnyɑ kɛ nɔ́unɛ́célɑɑ nɛ pilɑmpooyɔɔ́ nɛ pikópɛkɔɔ́ picɔ ɑpi kɛlõ kɛsɛ tũ pin le? ");
INSERT INTO soy_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yeesu uu kóm pin lɛ̃ símisi uu rɛ: Ái pisoi pɛɛ isɑrɛ n lɑ́ɑ́rú nnyɑ kɛ upɔisɛ uú we, ɑmɑ́ pitóikɔ́ nnyɑ kuú we. ");
INSERT INTO soy_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ani hɑ Uléécɑɑ nsímɛ́ mmú kuu ḿ mɑ ɑsei wɛ́ɛ́si ɑni kóm. U mɑɑ rɛ: Nɛ̃́, Uléécɑɑ yɛ nɔ́ písɛi rɛ ɑni íwɛ n ténɑɑnɛ, ɑ́m nɔ́ písɛi rɛ ɑni yɛ isɛɛ nɛ nɛ́ nyɔ́ɔnsɛ. Yeesu uu kɔ pimɑ́ɑ pi kpɑ́ rɛ: Ái pɛpɛɛ pimɛcirɛ n nyɑ́ni rɛ pi pisoi lɛ pɛɛ ɑsei n tikilɛ̃ kɑm piséi kɑ, ɑmɑ́ pikópɛkɔɔ́ nnyɑ kɑḿ kɑ. ");
INSERT INTO soy_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Kei kɛ Yohɑni Úniwolɛ pipirɛtiki ɑpi Yeesu kɛkúrí hɑ́pɔ ɑpi u pisɛ rɛ: Yo nnyɑ kɛ tɔ́ nɛ Pifɑrisi ɑri ɑnɔ́ɔ pɑhɑɑnkɛɛ mɛsɛ́rɛ, ɑmɑ́ pɔ̃́ pipirɛtiki ɑ́pi yɛ pɛɛ pɑɑsi? ");
INSERT INTO soy_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yeesu uu pɛɛ pi pɛsɛ rɛ: Nɔ músu rɛ usoi yɛ́ pisɔ́ɔnnɛ ɑnyɑ̃́ n wɑi uu upisɑnɛ séi ɑpi pɛɛ́ hɑpɔ ɑpí nɛ mpɔ́ɔcɑɑi n tũ? Aɑi, mmɛ̃ ńn we. Li yɛ́ kɑm ɑpi kumúŋɛ́ kunyinɛ-i unɔ́sikɔ́ uyɛ̃ pikɛcɔpɛ lesɛ ɑpí nɛ tɔ́mpɔ. Pɛɛ́ uyɛ-i kɑpi yɛ́ pɛɛ ɑnɔ́ɔ pɑɑsi. ");
INSERT INTO soy_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Yeesu uu kɔ pimɑ́ɑ pi kpɑ́ rɛ: Ápi yɛ kusɑ́ŋɑ́ɑ́ fɑlɛ kɛpɑmpi kpísi ɑpí nɛ risípii kpurɛ tɑŋɛnɛ. Insɑ́ lɛ̃, kusɑ́ŋɑ́ɑ́ fɑlɛ kɛpɑmpi yɛ́ kusɑ́ŋɑ́ɑ́ kpurɛ nkú m pɑsɑlɛ̃ ɑí cɛɛ́ri, kupólɛ ɑku pɛɛ kufoí feriyɛ. ");
INSERT INTO soy_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Uu kɔ kpɑ́ rɛ: Úkɑ úu yɛ pítɑ pelẽ ɑkónɛnuŋ́ kpurɛ-i súũ. Insɑ́ lɛ̃, pítɑ yɛ́ kɑm ɑpi pelu, ɑnúŋ́ ɑɑ kpɑ́fú ɑpi kɛteni-i lúlu, ɑnúŋ́ pɔ́ɔ kɔ mɛ́woo wɑi. Amɑ́ ɑkónɛnuŋ́ fɑlɛ kɛ́mɛɛ kɑpi yɛ pítɑ fɑlɛ súũ, ɑi lɛ̃ n we ɑpí hɑ nɛ pelu. ");
INSERT INTO soy_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yeesu un lɛ̃ we un nɛ Yohɑni Úniwolɛ pipirɛtiki símisi, Pisuifi uyukɔɔ́ unyinɛ uú hɑpɔ uu ukɛyu-i wúlɑ uu rɛ: Unɛ́kpére yɛɛ nfɑ́ɑni nní kpupɔ ɑ́i kɑhɑnɛ n nɑ́ŋɑi. Amɑ́ ɑ kɑm ɑ hɑ ɑnípɛ ukɛcɑ́ɑ́ rilɑɑ. U yɛ́ nfɑ́ɑ wɑ. ");
INSERT INTO soy_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yeesu uu yisi u nɛ upipirɛtiki ɑpi u tiki. ");
INSERT INTO soy_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Unɔ́si unyinɛ yɛɛ mɛ́nyɛ n foho hɑ́i iŋmɛ̃ kɛfi nɛ itɛ́, uú nɛ Yeesu kɔ, uu uilũ titimɛ kɛpirɛ-mɛ̃ cɑ. ");
INSERT INTO soy_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ái mɛ́woo kuu lɛ̃ ticɑ. U ukɛfɑ-i mɑɑ rɛ: Nɛn pɛɛ́ ŋmɑɑ uilũ kerí n fe ɑḿ cɑ, nɛ yɛɛ pɛɛ́ peí. ");
INSERT INTO soy_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yeesu uu pɛɛ kɛpirɛ-mɛ̃ pɑnsɛpɔ uu u yɛnu uu u mɑɑ rɛ: A n kɑhɑri unɛ́kpére, mpɔ́fɑtɛnɛ yɛ pɔ́ péisɛlɛ. Unɔ́si uyɛ̃ uu kei nní pélu. ");
INSERT INTO soy_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Kɛ Yeesu uú hɑ úyukɔɔ́ uyɛ̃ kɛyɔ n tuipɔ, pisunsímɑɑ pɛɛ pimɛcirɛ n cɑ́pinɛ pikɛ́ nkpɔ wɑ nɛ risoiwuí nɛ iwɔ́ɔ líkí-líkí kuu lɛɛpɔ kɛ́yɔ mɛyipɛ. ");
INSERT INTO soy_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Uu pi mɑɑ rɛ: Ani nté léepɔ. Kɛkpérepi nkɛ́ ɑ́kɛ kpu, kɛ lɔnilɛ. Kuu lɛ̃ ḿ mɑ, ɑpi u sɛ́nnyi. ");
INSERT INTO soy_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Kɑpi pisoi kɛtɑhɑi-mɛ̃ n lésɛpɔ, Yeesu uu pɛɛ kulee lompɔ. Uu kɛkpérepi kunípɛ tini, ɑkɛ yisi ɑkɛ nyɛrɛ. ");
INSERT INTO soy_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Nsímɛ́ nn kei kɛtẽ kɛ̃ nnɛ́í kɔ́ɔ́nú nn tɑ́ŋɛnɛ. ");
INSERT INTO soy_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Kɛ Yeesu uu kei n yisi un tɔ́su, pinyíyɛ pitɛ́ pinyinɛ ɑpi u n tikilɛ̃ pin cɑ́ɑ́i rɛ: A irɔ́wɛ yɛ̃, Tɑfiti Kɛpipi. ");
INSERT INTO soy_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Kuu kɛ́yɔ n tu, pinyíyɛ pɛ̃ ɑpi ukɛkúrí hɑpɔ. Kei kuu pɛɛ pi pisɛ rɛ: Nɔ nɛ kɛfɑ tɛnɛ rɛ nɛ́ fe ɑm lɛ̃ kɑni ń lɑ wɑii? Api u pɛsɛ rɛ: Ɛɛɛ Upíimɑ, pɔ́ fe. ");
INSERT INTO soy_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Kei kɛ Yeesu uu pɛɛ piinipɛɛ ricɑ uu rɛ: Uléécɑɑ ukɛ́ lɛ̃ kɑní nɛ nní kɛfɑ n tɛnɛ nɔ́ wɑ. ");
INSERT INTO soy_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Kuu lɛ̃ ḿ mɑ, piinipɛɛ ii wúkulɛ ɑpí n nyɑ́ni. Uu pɛɛ pi kúrúrúsɛ rɛ: Ani nɔ́mɛnɛ́círɛ tĩ ńsɔnɛ, ɑ́ni kɑpɛ tíyɛ unyinɛ ukɛ́ lɛ̃ kõ. ");
INSERT INTO soy_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Amɑ́ kɑpi yɛ́ kei nní n léepɔ, ɑpi pikɛtẽ kɛ̃ nnɛ́í nɛ Yeesu nsímɛ́ kɔ́ɔ́nú ɑpi ríyu u wɑisɛ. ");
INSERT INTO soy_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Pinyíyɛ pɛ̃ pɔ́ɔn nní fɑ́ɑupɔlɛ̃, pinyinɛ ɑpí nɛ unírihélɑɑ unyinɛ yɛɛ úu yɛ nsímɛ́ n fe Yeesu lɛɛpɔ. ");
INSERT INTO soy_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Kɛ Yeesu uu yɛ́ kuníri kpɛ̃ n lɑ́kɑsɛpɔ, utisi uyɛ̃ uu nsímɛ́ kɑ́pɑ́ɑ́. Ai riwúí tɛ-i ḿpɑ́ úye nnɔ́ɔ yipu, ɑpi pɛɛ rɛ: Ári píkɑi Isirɑyɛɛli kɛteni-i mɛwɑi mmɛ́ mɛcɔ yɛnɑɑlɛ̃! ");
INSERT INTO soy_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Amɑ́ Pifɑrisi pɔ́ɔ rɛ: Kunírilɑ̃ wɛ́ɛ́sɛ kpɛɛ ńnɑŋɛ u hɛ un nɛ ɑníri lɑkɑsɛ! ");
INSERT INTO soy_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yeesu yɛ pɛɛ ɑyu nɛ siyupi nnɛ́í kɔ́ɔ́núlɛnlɛ un kei Pisuifi ɑyomɛyɑ́hɑɑlee kɛ́mɛɛ céési un kɔ Uléécɑɑ iyɔɔpi Nsímɛ́ Kɛcirɛ pisoi yóólɛ̃ un kɔ itói ncɔpuri nɛ ncɔ́ŋ ncɔpuri mɛɛ pisoi m pɛkɛsi pɔisɛntɛ. ");
INSERT INTO soy_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Uu ɑsoiwuí yɛ́nu ɑn pɔɔnɛlɛ̃ lin ɑ feriyɛlɛ̃, ɑn mɛ́woo tóórinkɛɛ yɑrɛ isɑ́ŋ yɛɛ íi usẽ́ m mɑ́, ɑi íwɛ u wɑi. ");
INSERT INTO soy_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Uu pɛɛ upipirɛtiki mɑɑ rɛ: Kɛcɑrɛ kɛɛ kúkpɑɑ n tu yɛ lɑɑnulɛ pelele, ɑmɑ́ pɛpɛɛ yɛ́ kɛ ń kpɑsi ɑ́pi pɛɛ kulúi we. ");
INSERT INTO soy_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Lɛ̃ nnyɑ, ɑni Upíimɑ pisɛ rɛ ukɛ́ pikɛikɔ́ pɛɛ yɛ́ ń kpɑsi pɑmɛ. ");
INSERT INTO soy_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yeesu uu pɛɛ upirɛtiki kɛfi nɛ pitɛ́ séi uu ńnɑŋɛ pi hɛ pikɛ́ yɛ nɛ ɑníri lɑkɑsɛ ɑpi yɛ kɔ nɛ itói ncɔpuri nɛ ncɔ́ŋ ncɔpuri mɛɛ pisoi m pɛkɛsi pɔisɛntɛ. ");
INSERT INTO soy_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Pitumɛ kɛfi nɛ pitɛ́ pɛ̃ ɑnyiri yɛ nnyɛ́: Ufoí yɛɛ Simɔɔ kɑpi rinyíri n hɛ rɛ Piyɛɛ nɛ uuwɑ̃ Antiree, nɛ Yɑkupu nɛ uuwɑ̃ Yohɑni. Pɛ̃ kɛtɛ́ yɛ Sepetee piŋmɑ́nɛ lɛ, ");
INSERT INTO soy_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","nɛ Filipu nɛ Pɑtelemii nɛ Tomɑɑ nɛ ulɑmpooyɔɔ́ Mɑtiyee nɛ Alifee uŋmɑ́nɛ Yɑkupu nɛ Tɑtee, ");
INSERT INTO soy_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","nɛ Simɔɔ yɛɛ pɛɛ ukuyu pimúlɛ́ kɛcɑ́ɑ́ n tɔpu nɛ Yutɑsi Isikɑriyɔɔti yɛɛ Yeesu n tĩ́ uu pilɑ́ɑrɔ ɑnipɛ-i wɑi. ");
INSERT INTO soy_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Pisoi kɛfi nɛ pitɛ́ pɛ̃ kɛ Yeesu uú nɛ pikɛi tũ uu pi céési rɛ: Ani silõ sɛ-i kɛ mpuri sɑnɛ pikɔ́ ɑpi ń we n kɑɑsɛ. Áni kɑpɛ Sɑmɑrii pikɔ́ ɑyu kɛ́mɛɛ hɑ. ");
INSERT INTO soy_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Amɑ́ Isirɑyɛɛli pikɔ́ pɛɛ ń we yɑrɛ isɑ́ŋ yɛɛ m pɔ kɛ́mɛɛ kɑni yɛ́ hɑ. ");
INSERT INTO soy_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ani icée kɛ́mɛɛ pi n símisi rɛ: Uléécɑɑ iyɔɔpi yɛ nyɑhɑimɛlɛ. ");
INSERT INTO soy_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ani pitóikɔ́ m pɔisɛntɛ, ɑni pikpɔkpɔ yukusɛntɛ, ɑni tíyɛsɛ piyɔ̃́ pikɛ́ pɑnsɛ pisoi pɛɛ ɑ́pi mɛ́kpɛrinkpɛ m mɑ́, ɑni ɑníri lɑkɑsɛ. Fɑɑlɑɑ kɑni yɛ̃́, fɑɑlɑɑ kɛ nɔ́ɔ yɛ́ kɔ picɔ hɛ. ");
INSERT INTO soy_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Áni kɑpɛ nkpɑ́ni wurɑ nɛ́ɛ nwóóweni nɛ́ɛ mɛwóópipi kpísi nɔkɛ́ ɑwóólɔɔ-i wɑ nɔkɛ́ nɛ ripɛ́nɛ. ");
INSERT INTO soy_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Áni kɑpɛ kulɔ́ɔ kpísi nɔkɛ́ nɛ ncée ritiki, ɑ́ni kɑpɛ kɔ kɛtúkɑnkɑ kɛsɛ kpísi. Áni kɑpɛ kɔ ɑnɛ́ɛ́ri nɛ́ɛ kusɛ́lɛ rimúlú. Li we rɛ ukɛikɔ́ yɛɛ yɛ upikɛi pilukɛ li. ");
INSERT INTO soy_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ḿpɑ́ kuyu mɑɑ-i nɛ́ɛ kɛyupi-i kɑni lompɔ, ɑni yɛ uyɛɛ yɛ́ ń ŋmurɛi uu nɔ́ yɔ́su wɛ́ɛ́si. Un n ŋmurɛi un nɔ́ n yɔsí, ɑni ukɛmɛɛ́ tonɛ ɑí hɑ nɛ nɔ́kɛnɛ́tɔ́ŋɛ́yɑɑ tulu. ");
INSERT INTO soy_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nɔn yɛ kɛ́yɔ kɛ́ye-i n lompo, ɑni yɛ kɛpikɔ́ yɑ́ɑ́si rɛ: Likɛ́ nɔ́ n niŋú! ");
INSERT INTO soy_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kɛ́yɔ kɛ̃ pikɔ́ pin nɔ́ n yɔsí, nkíŋniŋɛ kɑní nɛ pi ń lɑ nkɛ́ pikɛcɑ́ɑ́ n we. Amɑ́ pinsɑ́ nɔ́ n yɔsí, nkíŋniŋɛ kɑní nɛ pi ń lɑ nkɛ́ nɔ́kɛnɛ́mɛɛ pɛɛpɔ. ");
INSERT INTO soy_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Pin kɛ́yɔ kɛnyinɛ-i nɛ́ɛ kuyu kunyinɛ-i n yɛ̀ rɛ ɑ́pi nɔ́ yɔ́sunɛ nɛ́ɛ ɑ́pi kɔ nɔ́nnɛ́símɛ́ kutu cɔnɛ, ɑni kɛ́yɔ kɛ-i nɛ́ɛ kuyu kpɛ-i léepɔ ɑni nɔ́ɑnɛ́nɑ nkoŋo péi ɑni pikuwɛ́ɛ́-mɛ̃ yɑɑpɔ. ");
INSERT INTO soy_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Asei kɑm nní nɔ́ símisi rɛ kɛyɑ́ɑ kɛ̃ kɛ Uléécɑɑ uu n sɔ́nti ukɛ́ nɛ pisoi n túhɑɑnɛ, Sotɔm nɛ Komɔɔri pikɔ́ kɛ Uléécɑɑ uu nnɑ n ŋmɑɑsi iwɛ yɛ́ nɛ kuyu kpɛ̃ ikɔ́ kutɔsi wɑ. ");
INSERT INTO soy_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Yeesu uu kɔ pimɑ́ɑ pi kpɑ́ rɛ: Ani ńsɔnɛ kõ tɛ, kɑm nní nɔ́ n tum, ɑni isɑ́ŋ yɛɛ ɑ́kpɛ kɛcɔpɛ ń we mɛcɔ n sɔ́nɛ. Lɛ̃ nnyɑ, ɑni mɛsɔhɔ m mɑ́ yɑrɛ iwɑ́ɑ, ɑni ɑlɔ́ɔlɑ̃ mɛcɔ kɛ́yu m purú. ");
INSERT INTO soy_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ani nɔ́mɛnɛ́círɛ nɛ pisoi tĩ. Li yɛ́ kɑm ɑpi yɛ nɔ́ tini ɑpí nɛ sitúhɑɑnɛ-i sĩ́, ɑpi yɛ kɔ piɑyomɛyɑ́hɑɑlee-i isɛ́í nɔ́ súúkɛɛ. ");
INSERT INTO soy_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Pi yɛ́ kɑm ɑpi yɛ nɛ̃́ nnyɑ píyukɔɔ́ nɛ piyɔ́ɔpi kɛ́mɛɛ nɔ́ séi rɛ nɔkɛ́ kɔ pɛ̃ kɛyu-i nɛ mpuri sɑnɛ pikɔ́ kɛyu-i inɛ́tɑnsei li nnyɑ. ");
INSERT INTO soy_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Pin yɛ kɛtɑhɑi nɔ́ n sée, iwɑmɛ íi kɑpɛ yɛ nɔ́ wɑ rɛ ń-ye kɑni yɛ́ hɑ símisi nɛ́ɛ íye kɑni yɛ́ hɑ n símisi. Liituŋɛ in n tu, Uléécɑɑ yɛ́ ḿmɑɑ-mɑɑ nɔ́ hɛ ɑní mɑlɛ. ");
INSERT INTO soy_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ái nɔ́kɛnɛ́mɛɛ knn léerinɛ. Amɑ́ Nɔ́unɛ́sɑ́ɑ Uléécɑɑ Nfɑɑsɔnɛ yɛɛ nɔ́kɛnɛ́mɛɛ símisinɛ. ");
INSERT INTO soy_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Usoi yɛ́ umɑ́rɛcɔ kpísi uú pɑ rɛ pikɛ́ kpu. Usoi uu kɔ ukɛpipi kpísi uú nɛ limɛcɔ wɑi. Siwɑ̃́ ɑsi pisɑ́ɑ nɛ píni kɛcɑ́ɑ́ nyɛrɛ ɑsi pi kpísi ɑsí pɑ rɛ pikɛ́ kpu. ");
INSERT INTO soy_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Pisoi nnɛ́í yɛ́ kɑm ɑpi nɛ̃́ nnyɑ nɔ́inɛ́puri yulu. Amɑ́ nkó yɛɛ rinkɑ́hɑ́-kɑ́hɑ́ nɛ kɛ́tɔ-pɔ, Uléécɑɑ yɛ́ uriyu lɔ. ");
INSERT INTO soy_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","In kuyu kúye-i nɔ́ n wéékusɛlɛ̃, ɑni wuri ɑni kucɔ tɛ́ŋ́. Asei kɑm nɔ́ símisi rɛ ɑ́ni Isirɑyɛɛli ɑyu kɔ́ɔ́núnɛ nɔkɛ́ tɑ́ŋɛnɛ Usoi Kɛpipi kɛkɛ́ kɛlenɛ kɑm. ");
INSERT INTO soy_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Upeikɛɛ úkɑ úu uucélɑɑ fe. Limɛcɔ, ukɛikɔ́ úkɑ úu ukɛisɑɑ fe. ");
INSERT INTO soy_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Li nyɑm tɛ upeikɛɛ ukɛ́ ucélɑɑ kɛtulɛ tu. Li nyɑm tɛ ukɛikɔ́ ukɛ́ ukɛisɑɑ kɛtulɛ tu. Nɛ́ɛ nɔ́unɛ́yɔsɑɑ, nɛ̃́ kɑ́pi piséi tíyɛ rɛ Pɛlisepulɛ, wóo pɛɛ nɔ̃́ pinɛ́yɔkɔ́? ");
INSERT INTO soy_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Yeesu uu kɔ pimɑ́ɑ pi kpɑ́ rɛ: Áni kɑpɛ pisoi n wuru. Lɛ̃ nnɛ́í lɛɛ m pékɑɑlɛ̃ nɛ lɛ̃ nnɛ́í kɛ úkɑ úu n nyu yɛ́ kɑm ɑi mɛtɛ́í kɛ́mɛɛ léeri ḿpɑ́ úye uu li yɛnu uu kɔ li ceru. ");
INSERT INTO soy_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Mmɛ̃ kɑm nní kuŋmɑhɑ-i nɔ́ n símisi, ɑni hɑ mɛtɛ́í kɛ́mɛɛ n tiyóó. Ani hɑ kɔ mmɛ̃ kɑm nní kutu-i nɔ́ rinwɛ́í-wɛ́í, kɛcɑ́cɑ́-i nyɛrɛ ɑni yóó ḿpɑ́ úye ukɛ́ kṍ. ");
INSERT INTO soy_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Áni kɑpɛ pɛpɛɛ yɛ usoi ń kpu ɑ́pi yɛ pɛɛ fe pikɛ́ ukumííri kpu n wuru. Amɑ́ Uléécɑɑ kɑni yɛ́ mɛníŋɛ n wuru rɛ u yɛ felɛ uu usoi kopu uu kɔ u nɛ ukumííri kpísi uu nnɑ tɛnɛcirɛ́ kɛ́mɛɛ wɑipɔ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ńté pi yɛ sinúipi yukɛ-yukɛ sitɛ́ yɑ́ɑ ɑí nɛ kɛ́tɑnkɑ́ kumúŋɛ́ sɑ́, nɛ́ɛ yo? Ḿpɑ́ nɛ lɛ̃, kɛ́kɑ ɑ́kɛ yɛ mɛ́woo kpu kɑ́i Nɔ́unɛ́sɑ́ɑ Uléécɑɑ mɛlɑ. ");
INSERT INTO soy_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ticuruu Uléécɑɑ yɛ nɔ́rinɛ́yu kɛcɑ́ɑ́ nnyúpi kɛɛnlɛ un n-nnɛ́í nyu. ");
INSERT INTO soy_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Lɛ̃ nnyɑ, iwɑmɛ íi kɑpɛ yɛ nɔ́ wɑ. Nɔ Uléécɑɑ inipɛɛ-i ríyu mɑ́lɛ lin sinúipi yukɛ-yukɛ kulúi fe. ");
INSERT INTO soy_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Yeesu uu kɔ kpɑ́ rɛ: Úye un pisoi kɛcɔpɛ n ŋmurɛi rɛ u unɛ́kɔ́ lɛ, nɛ̃́ nɛ́ kɔ Unɛ́sɑ́ɑ yɛɛ kɛyómɛcɑɑ-pɔ ń we kɛyu-i ŋmurɛi rɛ nɛ́ɛ u te. ");
INSERT INTO soy_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Amɑ́ úye un kɔ pisoi kɛcɔpɛ n kɛsi rɛ úu unɛ́kɔ́, nɛ̃́ nɛ́ kɔ Unɛ́sɑ́ɑ yɛɛ kɛyómɛcɑɑ-pɔ ń we kɛyu-i kɛ́si rɛ ɑ́m u nyu. ");
INSERT INTO soy_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Yeesu uu kɔ kpɑ́ rɛ: Áni kɑpɛ m músu rɛ ńniŋɛ kɑḿ nɛ kɛtẽ kɛcɑ́ɑ́ kɑ. Ái nkpɑ́ni ńniŋɛ, ɑmɑ́ ɑtɔpi kɑḿ nɛ kɑ. ");
INSERT INTO soy_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nɛ kɑlɛ kɛ́ uŋmɑ́nɛ nɛ usɑ́ɑ cɛ́ŋsɛ, ɑm kɔ ukpére nɛ úni nɛ ufɔsi nɛ unyɑ́ɑni cɛ́ŋsɛ. ");
INSERT INTO soy_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Usoi kɛyɔ cirɛ pikɔ́ ŋmɑɑ pɛɛ ilɑ́ɑrɔ u wɑinɛ. ");
INSERT INTO soy_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Usoi nkó yɛɛ usɑ́ɑ nɛ́ɛ úni ń lɑ ɑi tɔ́su lɛ̃ kuu nɛ́ ń lɑ úu nɛ sɑ́ rɛ ukɛ́ unɛ́pirɛtiki. Nkó yɛɛ kɔ uuŋmɑ́nɛ nɛ́ɛ uukpére ń lɑ ɑi tɔ́su lɛ̃ kuu nɛ́ ń lɑ úu nɛ sɑ́ rɛ ukɛ́ unɛ́pirɛtiki. ");
INSERT INTO soy_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Nkó yɛɛ úu n ŋmurɛi rɛ ukɛ́ mɛnɛ́cɔ ukunɑpɛ́ɛ́kɔɔ́ riyɑ ukɛ́ pɛɛ nɛ́ ritiki, úu nɛ sɑ́ rɛ ukɛ́ unɛ́pirɛtiki. ");
INSERT INTO soy_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nkó yɛɛ ń lɑ ukɛ́ unfɑɑ m múílɛ̃, yɛ́ kɑm uú nɛ n fómni. Amɑ́ nkó yɛɛ nɛ̃́ nnyɑ unfɑɑ n fóm, yɛ́ kɑm uu n yɛnu. ");
INSERT INTO soy_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Yeesu uu kɔ pimɑ́ɑ pi kpɑ́ rɛ: Nkó yɛɛ nɔ́ n yɔsí, yɛ kɔ nɛ̃́ yɔsilɛ. Nkó yɛɛ nɛ́ n yɔsí, yɛ kɔ uyɛɛ nɛ́ n tummɛ yɔsilɛ. ");
INSERT INTO soy_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Úye un ɑntepu unyinɛ n yɔsí rɛ ɑntepu lo nnyɑ kuu u yɔsí, Uléécɑɑ yɛ́ ihɛ́ɛ́ kuu yɛ́ ɑntepu ḿ pɑ icɔ u hɛ́ɛ́lɛ. Nkó yɛɛ kɔ uyɛɛ ɑsei nɛ Uléécɑɑ pikɛi n wɑi n yɔsí rɛ ɑsei ute lo nnyɑ kuu u yɔsí, Uléécɑɑ yɛ́ ihɛ́ɛ́ kuu yɛ́ ɑsei ute ḿ pɑ u hɛ́ɛ́lɛ. ");
INSERT INTO soy_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Asei kɑm nɔ́ símisi rɛ nkó yɛɛ pisoi mpí kɛ úkɑ úu nní n wɑisɛlɛ̃ kɛcɔpɛ unyinɛ míni rińwuhúsɛ rɛ pi pinɛ́pirɛtiki lɛ nnyɑ, Uléécɑɑ yɛ́ liihɛ́ɛ́ u pɑ. ");
INSERT INTO soy_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Kɛ Yeesu uu upipirɛtiki kɛfi nɛ pitɛ́ pɛ̃ uicélɑɑ pípɑ ḿ mɑsí, uu kei yisi uú hɑ kɛtẽ kɛ̃ ɑyu kɛ́mɛɛ n céési un kɔ Nléécɑɑsimɛ́ yóólɛ̃. ");
INSERT INTO soy_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yohɑni Úniwolɛ yɛ pɛɛ likumúŋɛ́ kpɛ-i kukpɑniilee-i wepɔlɛ. Uu Kirisi pikɛi kuu n wɑi nkɔ́ kóm, uu pɛɛ upipirɛtiki yukusɛ uu ukɛmɛɛ tum ");
INSERT INTO soy_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","tɛ pikɛ́ hɑ u pisɛ rɛ uyɛɛ usoi uyɛ̃ kɑpi mɛkɛɛ-mɛ n tee rɛ u sɔ́nti nɛ́ɛ unyinɛ ucɔ yɛ kɛpirɛ wemɛlɛ? ");
INSERT INTO soy_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Kei kɛ Yeesu uu pɛɛ pi pɛsɛ rɛ: Ani hɑ lɛ̃ kɑni n kómɛi nɔn kɔ nyɑ́ni Yohɑni símisi, ");
INSERT INTO soy_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","lɛlɛɛ rɛ pinyíyɛ yɛ nyɑ́nilɛ, síkɑnkɑ́lɑ́kɑ́ sin sɔ́nɛ, piyɔ̃́ pin wolɛ pin funi, pitusuí pin kómɛi, pikpɔkpɔ pin yisikɛɛ, píwɛkɔɔ́ pin kɔ Nsímɛ́ Kɛcirɛ kɛ pisoi ɑpi pi n yóólɛ̃ kómɛi. ");
INSERT INTO soy_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Úye unsɑ́ nɛ̃́ nnyɑ n loó, liute yɛ únɑrɛkomɛ lɛ. ");
INSERT INTO soy_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Kɛ Yeesu uu lɛ̃ pisímɛ́ pi ḿ mɑsí ɑpi tɔ́mpɔ, uu pɛɛ Yohɑni kɛcɑ́ɑ́ nsímɛ́ pisoi pɛɛ n cɑ́pinɛlɛ̃ n símisi, uu rɛ: Yo kɑni kucɛsi kóimɑ-i piyɛ́nɛ hɑ? Kɛkpɑ́pi kɛ kuyɔ ɑku n fíkiisɛɛ? ");
INSERT INTO soy_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Usoi yɛɛ mɛlɑpɛ kɛcirɛ n lɑpɑɑlɛ̃ yɛɛ kei we, nɛ́ɛ yo? Amɑ́ piyɔ́ɔpi ɑkpɑ́ŋɑ́-i kɛ pɛpɛɛ mɛlɑpɛ kɛcirɛ m mɑ́ ɑpí we. ");
INSERT INTO soy_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Yɑrɛ yo kɛcirɛ ŋmɑɑ kɑni mpíí piyɛ́nɛ hɑ? Antepu unyinɛ nɛ́ɛ yo? Amɑ́ ɑsei kɛcɑ́ɑ́ uyɛ̃ kɑni nní ń yɛ̃́ nɛ ɑntepu felɛ. ");
INSERT INTO soy_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ukɛcɑ́ɑ́ kɑi wɔ́lɑɑlɛ̃ tɛ: Unɛ́tumɛ yɛ nkó kɑm n tummɛ ukɛ́ nɛ kɛkpéẽ pɔ́ wɑ ukɛ́ mpɔ́cée nyɔ́ɔnsɛ. ");
INSERT INTO soy_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Asei kɑm nní nɔ́ símisi rɛ kɑí nɛ n wemɛ, ɑ́pi unyinɛ mɑrɑɑlɛ̃ yɛɛ Yohɑni Úniwolɛ n fe. Ḿpɑ́ nɛ lɛ̃, pɛpɛɛ Uléécɑɑ iyɔɔpi kɛ́mɛɛ ń we kɛcɔpɛ, uyɛɛ n fíílɛ̃ yɛ u felɛ. ");
INSERT INTO soy_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kɑí nɛ kumúŋɛ́ kpɛ-i kɛ Yohɑni uu Uléécɑɑ Nsímɛ́ n yóólɛ̃ n kpíimɛ ɑí nɛ kumúŋɛ́ nkú-i tuiri, pisoi yɛ Uléécɑɑ iyɔɔpi nnyɑ tɔpulɛ pin nɑ́ɑ́si pikɛ́ i yɛ̃, pinɑ́ŋɛ-nɑŋɛ pɛɛ yɛ i yɛ̃. ");
INSERT INTO soy_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Antepuyɛ nnɛ́í nɛ isé yɛ Uléécɑɑ iyɔɔpi nsímɛ́ símɑɑrilɛ ɑí weri ɑí nɛ Yohɑni ikɑmɛtuŋɛ tulu. ");
INSERT INTO soy_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","In tɛ nɔ mɛsei lɑ nɔkɛ́ nnɛ́símɛ́ kṍ, Yohɑni yɛɛ Elii uyɛ̃ kɑpí pɛɛ n tee rɛ u wemɛ. ");
INSERT INTO soy_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Úye un ukómɛ uu kóm! ");
INSERT INTO soy_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Uu kɔ pimɑ́ɑ pi kpɑ́ rɛ: Yo kɑm yɛ́ fe kɛ́ nɛ nfɑ́ɑni pisoi múŋɛisɛnɛ? Pi nkpɑ́ni yɑrɛ siwɑ̃́ sɛɛ kɛ́yɑɑ́lɑ-i n tṹ si nɛ sisicɔ sin nɛ ipupɛi séleinɛ, ɑsi yɛ rɛ: ");
INSERT INTO soy_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Tɔ ɑsũ nɔ́ símisilɛ rɛ ɑni yesi, ɑni yúlu, ɑri sikpɔyomɛ yom, ɑ́ni tẽ́. ");
INSERT INTO soy_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Mɛsei kɛ Yohɑni uú kɑ, úu yɛ ilukɛ li, úu yɛ pítɑ n ntí, ɑni rɛ ɑníri kuu héesi. ");
INSERT INTO soy_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Usoi Kɛpipi pɔ́ɔ weri kɛn le kɛn níru, ɑni kɔ rɛ: Pilukɛ nɛ pítɑ nirɛ́ ŋmɑnɛ nkɔ́ mɛɛ uyɛ̃ we. U kɔ pilɑmpooyɔɔ́ nɛ pikópɛkɔɔ́ usɑnɛ lɛ. Amɑ́ li pɛɛ umɛwɑi kɛ́mɛɛ nyísɛlɛnlɛ rɛ Uléécɑɑ mɛwɛ́ɛ́sɛsɔhɔ yɛ mɛ. ");
INSERT INTO soy_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Lɛ̃ mɛmɑ́ɑ́, Yeesu uu pɛɛ ɑyu nyɛ-i kuu mɛwɑisɑŋɑ mɛyɑ̃ n wɑpisi pikɔ́ picɛ́ kɑ́pɑ́ɑ́ kɑ́pi nɛ mɛfinɛ n consɛ nnyɑ. U nɛ pi cɛ́si rɛ: ");
INSERT INTO soy_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Nɔ̃́ Korɑsin pikɔ́, íwɛ kɑni topori. Nɔ̃́ Petisɑyitɑ pikɔ́, íwɛ kɑni topori! Likumúŋɛ́ rɛ mɛwɑisɑŋɑ kɑpi nɔ́kɛnɛ́mɛɛ n wɑpisi mɛn pɛɛ Tiiri nɛ Sitɔɔ kɛ́mɛɛ n wɑ, ɑi nní ń we pin piɑkópɛ kɛpirɛ ritɔ ɑpi ɑ́fɔrɔnti tɑni ɑpi pimɛcirɛ nfúrɔ̃ kɔikɛɛ likɛ́ nyísɛ rɛ pi consɛ. ");
INSERT INTO soy_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Lɛ̃ nnyɑ kɑm nɔ́ símisi rɛ Tiiri nɛ Sitɔɔ pikɔ́ iwɛ yɛ́ hɑ kɛtúhɑɑnɛyɑɑ kɛ̃ nɛ nɔ́inɛ́kɔ́ kutɔsi wɑ. ");
INSERT INTO soy_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ńté nɔ̃́ Kɑpɛrinɑwum pikɔ́, nɔ músu rɛ kɛléécɑɑ-mɛ̃ kɑní tɑɑ́lɛ̃? Ái nkpɑ́ni lɛ̃. Amɑ́ kukúlɑ̃yu-i kɛ Uléécɑɑ uu kɛtẽ-mɛ̃ nɔ́ lɑ́upɔlɛ. Ái líkɑ nnyɑ, pin pɛɛ mɛwɑisɑŋɑ mmɛ́ kɑpi nní nɔ́kɛnɛ́mɛɛ n wɑpisi mɛcɔ Sotɔm kɛ́mɛɛ n wɑpisi, li yɛ́ pɛɛ nní ń we kuyu kpɛ̃ kun nɛ we. ");
INSERT INTO soy_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Lɛ̃ nnyɑ kɑm nɔ́ símisi rɛ kɛyɑ́ɑ kɛ̃ kɛ Uléécɑɑ uú nɛ pisoi n túhɑɑnɛnɛ, Sotɔm pikɔ́ iwɛ íi nɔ́inɛ́kɔ́ nɛ kutɔsi wɑ. ");
INSERT INTO soy_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Yeesu uu pɛɛ likumúŋɛ́ kpɛ-i mɑɑ rɛ: Sɑ́ɑ, kɛtẽ nɛ kɛyómɛ Upiimɑ, nɛ pɔ́ pɑkɑrɛ rɛ pɔ tíyɛsɛ siwɑ̃́ síńsɑ́pi ɑsi nsímɛ́ mmɛ̃ kɑɑ pisɔhɔɔ nɛ pinyuwɛ ḿ pesí ɑsei kom. ");
INSERT INTO soy_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Pɔ́ɔ lɑ rɛ likɛ́ lɛ̃ wɑ kɑi kɔ mɛsei lɛ̃ wɑ, Sɑ́ɑ. ");
INSERT INTO soy_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Yeesu uu kɔ limɛmɑ́ɑ́ pi mɑɑ rɛ: Unɛ́sɑ́ɑ yɛ ḿpɑ́ yo nnɛ́í nɛ́ pɑlɛ. Úkɑ ucɔ úu nɛ̃́, Ukɛpipi nyu Unɛ́sɑ́ɑ mɛmɑ́ɑ́. Úkɑ ucɔ úu kɔ Unɛ́sɑ́ɑ nyu insɑ́ nɛ̃́ Ukɛpipi nɛ pɛ̃ kɑm n tíyɛsɛ ɑpi u ceru. ");
INSERT INTO soy_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Nɔ́ mpí nnɛ́í nɔ́ɔ nní ncɔni mulɛ-mulɛ nɛ n nɑ́kɑɑnkɛɛ lin nɔ́ pelɑɑlɛ̃, ɑni kɛnɛ́mɛɛ́ kɑm kɛ́ nɔ́ topilɛ ɑni wéntɛ. ");
INSERT INTO soy_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ám lɑ kɛ́ nɔ́ n nyikilɛ̃ lin nɔ́ pelɑɑlɛ̃. Ani ncɔni kɑḿ nɛ nɔ́ ń lɑ ŋmurɛi ɑni cɔni, ɑni tíyɛ kɛ́ nɔ́ n céési. Nɔ́ pɛɛ yɛ̃́ kɑni yɛ́ ń wéntɛ. Nɛ kɛfɑ lɑ́ɑ́rúlɛ. Mɛnɛ́kɔ́ ɑ́mɛ kɔ pɔ́ɔ́lú. ");
INSERT INTO soy_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ncɔni mmɛ̃ kɑm nní nɛ nɔ́ ń lɑ rɛ ɑni cɔ̃ yɛ fɑ́kúlɛ, ńn nkpɑ́ni mulú. ");
INSERT INTO soy_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Lɛ̃ mɛmɑ́ɑ́, Yeesu uu pɛɛ kɛwéntɛyɑɑ kɛtúŋɛ́ imúí inyinɛ kɛcɑrɛ kɛ́mɛɛ n tikilɛ̃ un tɔ́su. Nkṹ nn upipirɛtiki wɑi, ɑpi pɛɛ iwéhe kpééni ɑpi mɛpipi tɑkɑi. ");
INSERT INTO soy_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Kɛ Pifɑrisi ɑpi lɛ̃ n yɛ̃́, ɑpi Yeesu mɑɑ rɛ: A ripɑí kɛ pipɔ́pirɛtiki ɑpi n wɑi lɛ̃ kɛ isé ii ḿ mɑɑ rɛ pisoi ɑ́pi kɑpɛ yɛ kɛwéntɛyɑɑ kɛtúŋɛ́ wɑ. ");
INSERT INTO soy_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Kei kɛ Yeesu uu pɛɛ pi pɛsɛ rɛ: Lɛ̃ nnyɑ, ɑ́ni lɛ̃ kɛ Tɑfiti uu kumúŋɛ́ kpɛ-i kɛ nkṹ nn u nɛ upikɔ́ n wɑ kɛɛnlɛ̃, nɛ́ɛ yo? ");
INSERT INTO soy_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Uléécɑɑ kɛyɔ-i kuu lompɔ uu ɑkpɔ́nɔ́ kɑpi Uléécɑɑ n yekei kpísi u nɛ upikɔ́ ɑpi le, ɑ́i kɔ pɛɛ rɛ piunyinɛ yɛ ncée mɑ́ ukɛ́ ɑ li. Pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ ŋmɑnɛ pɛɛ ncée mɑ́ pikɛ́ ɑ li. ");
INSERT INTO soy_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Nɛ́ɛ ɑ́ni isé ɑtɛlɛ́ kɛ́mɛɛ kɛ́ɛ̃ tɛ pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ yɛ Uléécɑɑ kɛyɔ-i pikɛi wɑilɛ ɑí nɛ kɛwéntɛyɑɑ pɛ́nɛ? Lɛ̃ nnyɑ ɑkópɛ kɑpi lɛ̃ wɑɑ? ");
INSERT INTO soy_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Amɑ́ kɛ́ nɔ́ símisi rɛ uyɛɛ nté nní ń we yɛ Uléécɑɑ kɛyɔ felɛ. ");
INSERT INTO soy_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Nɔn pɛɛ Uléécɑɑ ritɛlɛ́ kɛ́mɛɛ iwɔ́i nnyí ɑsei mɛyíkíyiki n kõ tɛ Uléécɑɑ yɛ mɑɑ rɛ: Nɛ̃́, Uléécɑɑ yɛ nɔ́ písɛi rɛ ɑni íwɛ n ténɑɑnɛ, ɑ́m nɔ́ písɛi rɛ ɑni yɛ isɛɛ nɛ nɛ́ nyɔ́ɔnsɛ, ɑ́ni yɛ́ɛ́ pɛɛ nkó yɛɛ úu líkɑ n cɑɑi ɑkópɛ pɑ. ");
INSERT INTO soy_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Lɛ̃ nnyɑ kɛ nɛ̃́, Usoi Kɛpipi ɑm kɛwéntɛyɑɑ ute. ");
INSERT INTO soy_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yeesu uu kei yisi uu tɔ́mpɔ uú hɑ pikuyomɛyɑ́hɑɑlee loni. ");
INSERT INTO soy_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Utisi unyinɛ yɛ pɛɛ kei welɛ un kunípɛ kópɛ mɑ́. Pɛpɛɛ kei ń we ɑpi pɛɛ kɛwɑ́ɑ́nɑ́ n wɛ́ɛ́si pikɛ́ nɛ Yeesu tĩ. Api Yeesu pisɛ rɛ: Ncée yɛ we rɛ pikɛ́ kɛwéntɛyɑɑ kɛtúŋɛ́ usoi pɔisɛɛ? ");
INSERT INTO soy_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Uu pi pɛsɛ rɛ: Nɔ́ úye un nkpéni isɑ́ŋ isɛ m mɑ́ ii kɛwéntɛyɑɑ kɛtúŋɛ́ kuhórɛ címɛ́-cimɛ́ kunyinɛ-i lóipɔ, úu yɛ́ hɑ kei i lesɛɛ? ");
INSERT INTO soy_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Kɛsoipipi yɛ kɔ pɛɛ isɑ́ŋ felɛ ɑ́i nkɑ́ripi. Lɛ̃ nnyɑ, irɔ́sé yɛ ncée hɛlɛ rɛ pikɛ́ yɛ kɛwéntɛyɑɑ kɛtúŋɛ́ usoi lisɔnɛ wɑ. ");
INSERT INTO soy_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Yeesu uu pɛɛ utisi uyɛ̃ mɑɑ rɛ: A kupɔ́nípɛ rituŋɑ́mɛ. Uu ku tuŋɑ́pɔ ɑku pélu ɑku kucɔ mɛcɔ sɔnɛsi. ");
INSERT INTO soy_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Kɑi lɛ̃ n wɑ, Pifɑrisi ɑpi pɛɛ léepɔ ɑpí hɑ símɑɑnɛ pikɛ́ yɛ̃́ tɛ íye kɑpi yɛ́ wɑ pikɛ́ nɛ Yeesu kpu. ");
INSERT INTO soy_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Kɛ Yeesu uu n kṍ tɛ pi lɑ pikɛ́ u kpu, uu kei yisi uú nyɔsɔ́. Pisoi kulúi ɑpi yisi ɑpi u tiki, uu pitóikɔ́ nnɛ́í pɔisɛntɛ. ");
INSERT INTO soy_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Amɑ́ uu pɛɛ pi símisi ńsɔnɛ uu kúrúrúsɛ rɛ ɑ́pi kɑpɛ tíyɛ unyinɛ ukɛ́ kṍ tɛ lɛ̃ kuu wɑ. ");
INSERT INTO soy_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Lɛ̃ kɛ ɑntepu Esɑyi uu uritɛlɛ́ kɛ́mɛɛ ḿ mɑ likɛ́ nɛ n wɑ nnyɑ. U pɛɛ rɛ: ");
INSERT INTO soy_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Unɛ́kɛikɔ́ lɑlɑ yɛ nkó. Uyɛ̃ kɑm wɛ́ɛ. Ám kusɑ u lɑ. Nɛ́ Nnɛ́fɑ́ɑsɔnɛ ukɛmɛɛ wɑ ukɛ́ nɛ sitẽ nnɛ́í isoipuri ɑsei kɑḿ nɛ i n wemɛ riyóó. ");
INSERT INTO soy_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","U nɛ úkɑ ɑ́pi líkɑ kɛcɑ́ɑ́ kɛ́ŋɛnɛ, úu yɛ́ kɔ sɛnkɛɛ. Ápi yɛ́ unnɛ̃́ icée-i n kómɛi. ");
INSERT INTO soy_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Úu yɛ́ kɛkpɑ́pi kɛɛ pikɔ́nɔ́ɔ́ m mɑ́ɑ́lɛ̃ sei. Úu yɛ́ kɔ kɛ́firɑ́ɑ kɛɛ pinyúḿ-nyúḿ ḿ mɑsí kpu. Lɛ̃ kuu yɛ́ n wɑi ɑí weri ɑí nɛ tulu kumúŋɛ́ kpɛ-i kɛ ɑsei ɑɑ yɛ́ ḿpɑ́ yo n feriyɛ. ");
INSERT INTO soy_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Sitẽ nnɛ́í isoipuri ii pɛɛ́ nɛ u n tɑ́lɛ̃. ");
INSERT INTO soy_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Kei kɛ pinyinɛ ɑpi pɛɛ́ nɛ unírihélɑɑ unyinɛ kɛ ɑníri ɑɑ n nyíinsɛ úu kɔ símisi Yeesu lɛɛpɔ rɛ ukɛ́ u pɔisɛ. Yeesu uu u pɔisɛ uu pɛɛ fe uu yɛ símisi uu yɛ kɔ yɛnu. ");
INSERT INTO soy_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ai pisoi pɛɛ n cɑ́pinɛlɛ̃ nnɔ́ɔ yipu, pinnɛ́í ɑpi yɛ pɛɛ rɛ: Nɛ́ntɛ utisi nkó yɛ Tɑfiti Kɛpipi lɛ? ");
INSERT INTO soy_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Kɛ Pifɑrisi ɑpi lɛ̃ n kṍ, ɑpi rɛ: Aníri uyɔɔpi Pɛlisepulɛ yɛɛ utisi nkó ńnɑŋɛ hɛ kuú nɛ ɑníri lɑkɑsɛntɛ. ");
INSERT INTO soy_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Amɑ́ Yeesu yɛ pɛɛ pikɛmúŋɛ́ nyulɛ. Uu pɛɛ pi mɑɑ rɛ: Kuyɔ́ɔpiyu kunyinɛ pisoi pin pimɛcɔpɛcirɛ n tɔpu, ku yɛ kpulɛ. Limɛcɔ, kuyu kunyinɛ nɛ́ɛ kɛ́yɔ kɛnyinɛ pikɔ́ pin pimɛcɔpɛcirɛ n tɔpu, pi yɛ kpulɛ. ");
INSERT INTO soy_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Setɑni un nkpéni ɑníri n lɑkɑsɛntɛ, umɛcirɛ kuu lɛ̃ nɛ tɔpu, íye kɛ ukuyɔɔpiyu ɑku yɛ́ pɛɛ fe ɑkú nɛ n we? ");
INSERT INTO soy_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","In tɛ Pɛlisepulɛ yɛɛ ńnɑŋɛ nɛ́ hɛ kɑḿ nɛ ɑníri lɑkɑsɛntɛ, wóo pɛɛ nɔ́pinɛ́kɔ́ pɔ̃́ ńnɑŋɛ hɛ kɑpí nɛ ɑ lɑkɑsɛntɛ? Ani n nyu rɛ nɔ́pinɛ́kɔ́ cirɛ pɛɛ nɔ́ nyísɛnɛ rɛ ɑ́ni ɑlɑri mɑ́. ");
INSERT INTO soy_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Asei kɛcɑ́ɑ́, Uléécɑɑ Nfɑɑsɔnɛ nnɑŋɛ kɑḿ nɛ ɑníri lɑkɑsɛntɛ. Lɛlɛɛ nyísɛlɛ̃ tɛ Uléécɑɑ iyɔɔpi yɛ nɔ́kɛnɛ́mɛɛ pituimɛ mɑsilɛ. ");
INSERT INTO soy_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Úkɑ úu yɛ́ fe ukɛ́ unɑ́ŋɛ-nɑŋɛ kɛyɔ-i lompɔ uu ulikɔ́ yɑ́ɑ́i, kumúŋɛ́ kpɛ-i kúu kɑhɑnɛ u n tĩ́ ukɛ́ pɑɑsi. Amɑ́ un n fe un u n tĩ uu pɑɑsi, u yɛ́ pɛɛ fe uu kɛ́yɔ likɔ́ nnɛ́í yɑ́ɑ́i. ");
INSERT INTO soy_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Nkó yɛɛ úu kɛnɛ́cɑ́ɑ́ n kpɑ́lɛ̃ yɛ ilɑ́ɑrɔ nɛ́ wɑilɛ. Nkó yɛɛ úu kɔ picɑ́pinɛ nɛ́ n lɛ́ni yɛ hɑrɛsilɛ. ");
INSERT INTO soy_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Lɛ̃ nnyɑ kɑm nɔ́ símisi rɛ Uléécɑɑ yɛ́ ɑkópɛ nɛ ɑlɛ̃́ nnɛ́í mpuri kɛsoipipi sɑ́rɛi, ɑmɑ́ úye un Uléécɑɑ Nfɑɑsɔnɛ n lɑ́mɑɑnkɛɛ, Uléécɑɑ úu yɛ́ liute sɑ́rɛi. ");
INSERT INTO soy_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Uléécɑɑ yɛ́ nkó yɛɛ nɛ̃́ Usoi Kɛpipi kɛcɑ́ɑ́ nkópɛ n símisi, ɑkópɛ u sɑ́rɛi, ɑmɑ́ Uléécɑɑ úu yɛ́ nkó yɛɛ Nfɑ́ɑsɔnɛ kɛcɑ́ɑ́ nkópɛ n símisi, ɑkópɛ u sɑ́rɛi nɛ kɛweesi-pɔ. ");
INSERT INTO soy_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Yeesu uu kɔ pimɑ́ɑ pi kpɑ́ rɛ: Kuléé kun isɑrɛ n lɑ́ɑ́rú, kuɑpipi yɛ̀ɛ̀ n nyɑmlɛ. Kunsɑ́ isɑrɛ n lɑ́ɑ́rú, kuɑpipi yɛ̀ɛ̀ n cɑɑilɛnlɛ. Ḿpɑ́ kuléé kúye ɑpipi kɑpi yɛ nɛ ku ceri. ");
INSERT INTO soy_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Nɔ́ ɑkpurii nnyɛ́! Íye kɛ nɔ́ pisoi kpɑ́ɑ́ree mpí ɑni yɛ́ fe ɑni nsímɛ́ sɔnɛ mɑlɛ? Li we rɛ nsímɛ́ mɛɛ usoi kɛfɑ-i ń we mɛɛ yɛ nnɔ́ɔ-i léemɛ. ");
INSERT INTO soy_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Usoi sɔnɛ yɛɛ yɛ nsímɛ́ sɔnɛ mɛɛ ukɛfɑ sɔnɛ-i ń we símisi, usoi kópɛ pɔ́ɔ nsímɛ́ kópɛ mɛɛ ukɛfɑ kópɛ-i ń we símisi. ");
INSERT INTO soy_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Kɛ́ nɔ́ símisi rɛ kɛyɑ́ɑ kɛ̃ kɛ Uléécɑɑ uú nɛ pisoi n túhɑɑnɛnɛ, isímɛ́ kópɛ kɛ pisoi ɑpi n símɑɑnkɛɛ cirɛ nnyɑ kɑpí nɛ pi túhɑɑnɛnɛ. ");
INSERT INTO soy_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Li we rɛ mpɔ́nɔ́ɔsimɛ́ mɛɛ tíyɛsɛnɛ pɔkɛ́ ɑlɑri nɛ́ɛ ɑkópɛ yɛ̃. ");
INSERT INTO soy_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Lɛ̃ mɛmɑ́ɑ́, isé picélɑɑ kɛcɔpɛ pinyinɛ nɛ Pifɑrisi pinyinɛ ɑpi Yeesu mɑɑ rɛ: Tɔ pɛɛ́ lɑ rɛ ɑ mɛwɑisɑŋɑ mɛnyinɛ wɑ tɔkɛ́ yɛ̃́. ");
INSERT INTO soy_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yeesu uu pi pɛsɛ rɛ: Nfɑ́ɑni kɛtẽ nkɛ́ pisoi yɛ cɑɑilɛnlɛ hɑ́i. Ápi lɑ pikɛ́ Uléécɑɑ ŋmɑnɛ ritiki, ɑmɑ́ mɛwɑisɑŋɑ kɑpi wɛ́ɛ́si pikɛ́ yɛ̃́. Mɛwɑisɑŋɑ mɛ̃ kɛ ɑntepu Yonɑɑsi uu n yɛ̃́ mɛnyinɛcɔ kɑpi yɛ́ kɔ yɛ̃. ");
INSERT INTO soy_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Asei kɛcɑ́ɑ́, lɛ̃ kɛ Yonɑɑsi uu mɛkpíntomɛ́ mɑɑmɑɑ kɛfɑ-i sitúŋɛ́ sitɑɑni nɛ sisinɛ sitɑɑni n wɑ mɛcɔ kɛ Usoi Kɛpipi pɔ́ɔ kɔ sɔ́nti kɛkɛ́ kɛtẽ kɛ́mɛɛ wɑ sitúŋɛ́ sitɑɑni nɛ sisinɛ sitɑɑni. ");
INSERT INTO soy_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Kɛyɑ́ɑ kɛ̃ kɛ Uléécɑɑ uú nɛ pisoi n túhɑɑnɛnɛ, Niniifi pikɔ́ yɛ́ hɑ yisi ɑpi nfɑ́ɑni kɛtẽ nkɛ́ pisoi ɑkópɛ pɑ. Li we rɛ kumúŋɛ́ kpɛ-i kɛ Yonɑɑsi uú pɛɛ Nléécɑɑsimɛ́ rin-yóó ɑpi kóm, pi pɛɛ mɛfinɛ consɛlɛ. Uyɛɛ nté nní ń we yɛ kɔ pɛɛ Yonɑɑsi felɛ. ");
INSERT INTO soy_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Kɛyɑ́ɑ kɛ̃ kɛ Uléécɑɑ uú nɛ pisoi n túhɑɑnɛnɛ, unɔ́siyɔɔpi yɛɛ Sɑɑpɑ kɛtẽ kɛcɑ́ɑ́ n tṹ yɛ́ hɑ yisi uu nfɑ́ɑni kɛtẽ nkɛ́ pisoi ɑkópɛ pɑ. Li we rɛ uyɛɛ pɛɛ hɑ́i kɛtẽ kɛtɔ-pɔ leemɛlɛ uú weri rɛ ukɛ́ Sɑlomɔɔ mɛwɛ́ɛ́sɛsɔhɔ kõ. Uyɛɛ nté nní ń we yɛ kɔ pɛɛ Sɑlomɔɔ felɛ. ");
INSERT INTO soy_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Yeesu uu kɔ kpɑ́ rɛ: Kuníri kun usoi kɛ́mɛɛ n yisi, ku yɛ hɑlɛ ɑkú hɑ kɛlõ kóimɑ kɛnyinɛ-i n kerɑɑi kun kɛwéntɛ wɛ́ɛ́si. Kɑ́ku nní kɛ n yɛ̃́ nnyɑ, ");
INSERT INTO soy_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ɑku pɛɛ rɛ: Nɛ́ kɛnɛ́yɔ kɛ̃ kɑm n yisimɛ kɛ́mɛɛ pɛlɛ. Kun m pɛɛpɔ, ɑku kɛ́yɔ ŋmɑnɛ lɛɛpɔ kɑpi m péeinkɛɛ ɑpi nyɔ́ɔnsɛntɛ cɑ́kɑ́-cɑ́kɑ́. ");
INSERT INTO soy_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Kei kɑku yɛ pɛɛ́ hɑ kuɑcɔ ɑsɛɛi nyɛɛ kuricuruu rikpɑ́kɑ́rɑ́ ń fe kpíipɔ ɑɑ́ nɛ kɛ́yɔ kɛ-i tonɛ. Lɛlɛɛ yɛ tíyɛsɛ kɛ liute uyɛ̃ mɛwee fɑlɛ ɑmɛ yɛ n cɑɑilɛ̃ ɑmɛ mɛkpurɛ mɛ-i kuú pɛɛ mɛkɛɛ ń we tɔ́su. Lɛ̃ kɛ nfɑ́ɑni pisoi kópɛ mpí ɑpi sɔ́nti pikɛ́ nɛ kɛ́tɔ tɛnɛ. ");
INSERT INTO soy_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yeesu un kei lɛ̃ we un nɛ pisoi símisi, uuni nɛ upiwɑ̃ pin tuipɔ, ɑpi kɛtɑhɑi-pɔ nyɛrɛ, pin lɑ pikɛ́ rinɔ́ɔ u mɑɑ. ");
INSERT INTO soy_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Unyinɛ uu Yeesu mɑɑ rɛ: A ripɑí, upɔ́ni nɛ pipɔ́wɑ̃́ yɛ kɛtɑhɑi-pɔ nyɛnulɛ pin lɑ pikɛ́ rinɔ́ɔ pɔ́ mɑɑ. ");
INSERT INTO soy_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yeesu uu liute uyɛ̃ pɛsɛ rɛ: Wóo unɛ́ni, píye pɛɛ pinɛ́wɑ̃́? ");
INSERT INTO soy_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Uu pɛɛ upipirɛtiki-mɛ̃ kunípɛ tuŋɑ́pɔ uu rɛ: Unɛ́ni nɛ pinɛ́wɑ̃́ yɛ mpí nté! ");
INSERT INTO soy_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Asei kɛcɑ́ɑ́, úye un Unɛ́sɑ́ɑ yɛɛ kɛyómɛcɑɑ-pɔ ń we mɛlɑ n wɑi, uyɛɛ unɛ́wɑ̃́ nɛ́ɛ unɛ́yɛ́i nɛ́ɛ unɛ́ni. ");
INSERT INTO soy_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Yeesu uu kɛyɑ́ɑ kɛ̃ kɛ́yɔ-i léeri uu sĩ́ uú hɑ kupiyɛ ritimɛ tonɛ. ");
INSERT INTO soy_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Pisoi kulúi ɑpi ukɛkúrí cɑ́pinɛpɔ uu pɛɛ lɛ̃ nnyɑ kúninɔi loni uú tonɛ. Pisoi pɛ̃ pɔ́ɔ kupiyɛ ritimɛ tonɛ. ");
INSERT INTO soy_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Uu sinyɑ́rũ kpísi uú nɛ isímɛ́ isímɛ́ pi símɑɑnkɛɛ. Uu rɛ: Utisi unyinɛ yɛɛ we, uu kɛyɑ́ɑ ukɛcɑrɛ-i ipuri pifómɛ leepɔ. ");
INSERT INTO soy_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Kuu lɛ̃ n fóm, ipuri inyinɛ ii ricéetimɛ lólɛsi, sinúipi ɑsí hɑpɔ ɑsi i kpóuli. ");
INSERT INTO soy_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Icɔ ii kɛpɑrɛtẽ kɛcɑ́ɑ́ kɛ ntɑɑi ńn m piyɛ lólɛsi. Kɛ kɛtẽ ɑ́kɛ n címú nnyɑ, ipuri iyɛ̃ ii mɛsɛ nɛ mɛsɛ lɛlu. ");
INSERT INTO soy_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Amɑ́ kɛ ntuŋɛ nn n tɑ, mɛlɛi fɑlɛ mɛ̃ ɑmɛ iníŋí kuweecirɛ́ nnyɑ torɛ. ");
INSERT INTO soy_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ipuri icɔ ii sinípɛleépi kɛpɑ́ɑ́pɑ́ɑ́ lólɛsi, sinípɛleépi ɑsi pelu ɑsi i hilɑ. ");
INSERT INTO soy_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Amɑ́ ipuri icɔ ií hɑ kɛtẽ sɔnɛ kɛcɑ́ɑ́ lólɛsi ii lɛlu ii pelu ii fólu. Mpuri nsɛ nn fólu ipipi pílɛ, ncɔ ipipi kuwóó nɛ kɛfi, ncɔ ipipi ɑfɛɛtɑɑni. ");
INSERT INTO soy_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Kɛ Yeesu uu lɛ̃ pimɑ́ɑ pi m mɑsí, uu kɔ pi kpɑ́ rɛ: Úye un ukómɛ uu kóm. ");
INSERT INTO soy_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Kei kɛ upipirɛtiki ɑpi pɛɛ́ nɛ u rikɔ ɑpi u pisɛ rɛ: Yo nnyɑ kɑɑ sinyɑ́rũ kpísi pɔn nɛ pisoi símisi? ");
INSERT INTO soy_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yeesu uu pi pɛsɛ rɛ: Nɔ̃́ kɛ Uléécɑɑ uu uiyɔɔpi nsímɛ́ mɛɛ m pékɑɑlɛ̃ cereisɛ, úu pɛ̃ cereisɛ. Lɛ̃ nnyɑ kɑḿ nɛ lɛ̃ pi símisi. ");
INSERT INTO soy_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Li we yɑrɛ kɑpi yɛ ḿ mɑɑ rɛ: Nkó yɛɛ linyinɛ m mɑ́ kɑpi yɛ licɔ rikpɑ́ ɑi mɛyɑ̃́ wɑi. Amɑ́ nkó yɛɛ úu líkɑ m mɑ́ kɑpi yɛ likɑ́ripikɔɔ́ lɛ̃ kuu m mɑ́ yɔsí. ");
INSERT INTO soy_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Lɛ̃ nnyɑ kɑm sinyɑ́rũ kpísi nɛn nɛ pi símisi. Li we rɛ pi yɛ n wiilɛnlɛ, ɑmɑ́ ɑ́pi pɛɛ nyɑ́ni, ɑpi yɛ kutu n cɔlɛ̃, ɑmɑ́ ɑ́pi pɛɛ kɔ kómɛi. Ápi kɔ ɑsei ceri. ");
INSERT INTO soy_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Lɛ̃ kɛ ɑntepu Esɑyi uú pɛɛ mɛkɛɛ-mɛ ḿ mɑ yɛɛ lɛ̃ wɑi rɛ: Nɔ́ kɑm ɑni yɛ n kómɛi, ɑ́ni yɛ́ɛ́ pɛɛ liɑsei ceri. Nɔ́ kɑm ɑni yɛ n nyɑ́nɛi, ɑ́ni yɛ́ɛ́ pɛɛ yɛ̃́. ");
INSERT INTO soy_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Li we rɛ mpuri mmú pisoi ɑkiŋ yɛ tɑkɑsilɛ. Pi pimɛcirɛ ɑtu tɑ́pisilɛ. Api inípɛɛ wúkɛsi, ɑpi yúlu rɛ piɑtu ɑ́ɑ kɑpɛ yɛ kõ, piinipɛɛ íi kɑpɛ yɛ yɛ̃ pimɛsɔhɔ ɑ́mɛ kɑpɛ yɛ kɔ líkɑ ceri. Lɛ̃ kɛ́mɛɛ, ɑ́pi yɛ́ pɛɛ fe pikɛ́ pimɛfinɛ consɛ. Nɛ̃́ Uléécɑɑ, kɛ́ nɛ pi m pɔisɛ. ");
INSERT INTO soy_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Amɑ́ in nɔ́ɔ, nɔ pínɑrɛkomɛ lɛ rɛ nɔ́inɛ́nípɛɛ yɛ nyɑ́ni, nɔ́ɑnɛ́tu ɑn kómɛi. ");
INSERT INTO soy_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Asei kɑm nní nɔ́ símisi rɛ ɑntepuyɛ nɛ ɑsei pite Uléécɑɑ inipɛɛ-i yɛ kulúi welɛ pɛɛ pɛɛ́ ń lɑ pikɛ́ lɛ̃ kɑni nní ń nyɑ́ni yɛ̃, ɑmɑ́ ɑ́pi li yɛ̃. Pi pɛɛ kɔ lɑlɛ pikɛ́ lɛ̃ kɑni nní nɛ nɔ́ɑnɛ́tu n kómɛi kõ, ɑmɑ́ ɑ́pi li kõ. ");
INSERT INTO soy_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Kei kɛ Yeesu uu pɛɛ pi mɑɑ rɛ: Ani nkpéni ulukɑɑ kɛnyɑ́rũ kɛ̃ ɑsei kõ: ");
INSERT INTO soy_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Pisoi pɛɛ yɛ Uléécɑɑ iyɔɔpi nsímɛ́ kutu rińcɔ ɑ́pi yɛ́ nkɛmɛɛ́ kṍ yɛ we yɑrɛ ricéetimɛ tɛ-i kɛ ipuri ii n lólɛsi. Kuníri yɛ̀ɛ̀ kɑlɛ ɑku nsímɛ́ mmɛ̃ pikɛmɛɛ́ lesɛ. ");
INSERT INTO soy_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Picɔ yɛ kɔ we yɑrɛ kɛpɑrɛtẽ kɛ-i kɛ ipuri ii n lólɛsi. Lipite yɛ̀ɛ̀ nsímɛ́ kutu ricɔlɛ ɑpi mɛsɛ nɛ mɛsɛ piɑkiŋ kɛ́mɛɛ n yɔ́su nɛ mpɔ́ɔnɑrɛ. ");
INSERT INTO soy_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Amɑ́ ɑ́pi yɛ tíyɛ nkɛ́ pikɛmɛɛ iníŋí wɑ, ńn yɛ pikɛmɛɛ tónɛ likɛ́ nɑ́ŋɑi. Ncɔ́ŋ nn nsímɛ́ mmɛ̃ nnyɑ pi n lɛɛmɛ nɛ́ɛ mɛ́wee kópɛ mɛnyinɛ mɛn pi m pɛkɛsi, ɑpi kei nɛ kɛwɑ́ɑ́nɑ́ yɛ́nu ɑpí nɛ Uléécɑɑ kɛpirɛ tɔ. ");
INSERT INTO soy_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Picɔ yɛ kɔ we yɑrɛ ipuri yɛɛ sinípɛleépi kɛpɑ́ɑ́pɑ́ɑ́ ń loó. Lipite yɛ̀ɛ̀ nsímɛ́ kutu ricɔlɛ, ɑmɑ́ kɛtẽ kɛcɑ́ɑ́ pikɛi kɛ pisoi ɑpí nɛ ń kpɑrɑ́lɛ̃ nɛ mɛmɑ́ nnɑ́ɑ́pí mɛɛ yɛ n kírɑɑsɛ yɛ̀ɛ̀ nsímɛ́ mmɛ̃ tihilɑlɛ ńn yɛ pɛɛ líkɑ pi yoriyɛ. ");
INSERT INTO soy_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Picɔ yɛ kɔ welɛ yɑrɛ ipuri yɛɛ kɛfɛ́nɛtẽ kɛcɑ́ɑ́ ń loó. Lipite yɛ̀ɛ̀ nsímɛ́ mmɛ̃ kutu ricɔlɛ ɑpi nkɛmɛɛ́ kóm nn pi lɛ́ni ɑpi pɛɛ́ n we yɑrɛ ɑléé nyɛɛ yɛ ɑpipi m mɑ́ri, kunyinɛ pílɛ, kucɔ kuwóó nɛ kɛfi, kucɔ ɑfɛɛtɑɑni. ");
INSERT INTO soy_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yeesu uu kɔ kɛnyɑ́rũ kɛcɔ pi kpɑ́ rɛ: Uléécɑɑ iyɔɔpi yɛ we yɑrɛ usoi nkó nsímɛ́ mmú: Utisi unyinɛ yɛɛ ukɛcɑrɛ-i mɛlukɛpipi lukɛsi. ");
INSERT INTO soy_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ulɑ́ɑrɔ uu kɛsinɛ kɛnyinɛ hɑpɔ, pisoi pin lɔni uu ilukɛ kɛpɑ́ɑ́pɑ́ɑ́ mɛyúipuri kópɛ uu yɑɑ, uu tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Kɛ ilukɛ ii n lɛ ii mɛpɛ́i leeri ii fólu, mɛyúipuri pɔ́ɔ kɔ leeri. ");
INSERT INTO soy_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Pikɛikɔ́ ɑpí weri ɑpi ucɑrɛte uyɛ̃ mɑɑ rɛ: Ái ilukɛpuri kɑɑ kɛpɔ́cɑrɛ-i lukɛsii, Upíimɑ? Kɑi pɛɛ íye wɑ kɛ mɛyúipuri kópɛ ɑmɛ́ nɛ n lɛ? ");
INSERT INTO soy_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Uu pi pɛsɛ rɛ: Unɛ́lɑ́ɑrɔ unyinɛ yɛɛ lɛ̃ wɑ. Pikɛikɔ́ ɑpi rɛ: Pɔ lɑ tɔkɛ́ hɑ mɛ wɛhɛɛ? ");
INSERT INTO soy_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Uu rɛ: Eehei. Nɛ wuru rɛ nɔ́ mɛyúipuri kópɛ pilésɛ n lɑ ɑní nɛ ilukɛ pɛ́nɛ ɑní wɛhɛ. ");
INSERT INTO soy_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Lɛ̃ nnyɑ, ɑni likɛtɛ́ riyɑ́ likɛ́ kɛsẽ́ m pelu ɑí nɛ kúkpɑɑ tulu. Lin kúkpɑɑ n tu, nɛ́ pɛpɛɛ ń kpɑsi mɑɑ rɛ: Ani mɛyúipuri kópɛ mɛfoí lesɛ ɑni ɑpehe mɛ pɑhɑɑnkɛɛ tɔkɛ́ mɛ risɛ́, ɑni pɛɛ kɔ ilukɛ cɑ́pinɛ ɑni rinɛ́símɛ-i súúni. ");
INSERT INTO soy_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yeesu uu kɔ kɛnyɑ́rũ pi kpɑ́ rɛ: Uléécɑɑ iyɔɔpi yɛ kɔ we yɑrɛ mpuri yukɛ-yukɛ nnyinɛ kɛ usoi uu n kpísi uu ukɛcɑrɛ-i lukɛsi. ");
INSERT INTO soy_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ipuri kɛcɔpɛ mmɛ mɛɛ ń-yukɛ icɔ fe. Amɑ́ nn n lɛ, nkuléé kpɛɛ yɛ kɛcɑrɛ-i ɑyɛ́hɛléé kɛcɔpɛ kumɑ́ɑ. Ai pɛɛ wɑi kuléé mɑɑ kpɛ̃ ilesɛ kɛcɑ́ɑ́ kɛ sinúipi ɑsi yɛ ɑyɑ́mɛ́ wɑ. ");
INSERT INTO soy_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yeesu uu kɔ kɛnyɑ́rũ pi wɑi rɛ: Uléécɑɑ iyɔɔpi yɛ kɔ we yɑrɛ nkpɔ́nɔ́tɔ pitɛ kɛ unɔ́si uu ntɔ píimɑ kɛ́mɛɛ n cɔ́hɔnɛpɔ uu pulu pikpɛ́ɛ ɑpi yisi. ");
INSERT INTO soy_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Sinyɑ́rũ kɛ Yeesu uu yɛ pɛɛ kpísi uú nɛ pisoi pɛɛ n cɑ́pinɛlɛ̃ n céési. Sinyɑ́rũ ŋmɑnɛ kuu yɛ pɛɛ kpísi uú nɛ pi céési. ");
INSERT INTO soy_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Lɛ̃ kɛ ɑntepu uú pɛɛ n wɔ́i likɛ́ nɛ n wɑ nnyɑ. U pɛɛ rɛ: Sinyɑ́rũ kɑm kpísinɛ kɛ́ nɛ n símisi. Nɛ́ sinyɑ́rũ kpísi ɑḿ nɛ lɛ̃ nnɛ́í lɛɛ ḿpɑ́ yo kɛkorɑɑnɛ-mɛ m pékɑɑlɛ̃ yóó. ");
INSERT INTO soy_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Kei kɛ Yeesu uu pɛɛ yisi uu pisoi pɛɛ n cɑ́pinɛlɛ̃ yɑ́ uu kɛ́yɔ sĩ. Upipirɛtiki ɑpi u lɛɛpɔ ɑpi u pisɛ rɛ: A mɛyúipuri kópɛ mɛɛ kɛcɑrɛ-i n lɛ kɛnyɑ́rũ kɛ̃ ɑsei rɔ́ símisi. ");
INSERT INTO soy_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Uu pi pɛsɛ rɛ: Uyɛɛ ilukɛpuri n lukɛsi yɛɛ nní Usoi Kɛpipi. ");
INSERT INTO soy_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Kɛcɑrɛ kɛɛ nní kɛtẽ, nlukɛpuri sɔnɛ mɛɛ nní Uléécɑɑ iyɔɔpi pikɔ́, pɛpɛɛ Setɑni n tíkilɛ̃ pɛɛ nní mɛyúipuri kópɛ. ");
INSERT INTO soy_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ulɑ́ɑrɔ uyɛɛ mɛyúipuri kópɛ n lukɛsi yɛɛ nní Setɑni. Kɛtẽ nkɛ́ mɛtɛnɛ yɛɛ nní kúkpɑɑ. Pɛpɛɛ ń kpɑsinɛ pɛɛ nní piléécɑɑtumɛ. ");
INSERT INTO soy_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Yɑrɛ kɑpi yɛ nní mɛyúipuri kópɛ n wɛ́hɛ ɑpi nnɑ sɛ́ mɛcɔ kɑi sɔ́nti likɛ́ kɛtẽ mɛtɛnɛ kɛtúŋɛ́ wɑ. ");
INSERT INTO soy_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nɛ̃́, Usoi Kɛpipi yɛ́ pinɛ́léécɑɑtumɛ tũ ɑpi pɛ̃ nnɛ́í pɛɛ inɛ́yɔ́ɔpi kɛ́mɛɛ picɔ ɑkópɛ n wɑisɛ nɛ pɛ̃ nnɛ́í pɛɛ mɛwɑi kópɛ n wɑi lesɛ. ");
INSERT INTO soy_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Api nnɑ píimɑ kɛ́mɛɛ pi sɑ́pɔ. Kei kɛ pisoi ɑpi yɛ́ mɛyɑ̃́ ténesi pin inĩ́ tɑkɑi. ");
INSERT INTO soy_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Pɛɛ́ uyɛ-i kɛ pɛpɛɛ ɑsei n tíkilɛ̃ pɔ́ɔ yɛ́ pɛɛ piusɑɑ Uléécɑɑ iyɔɔpi kɛ́mɛɛ n we pin tɛ́lu yɑrɛ ituŋɛ. Úye un ukómɛ uu kóm! ");
INSERT INTO soy_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yeesu uu kɔ upipirɛtiki kɛnyɑ́rũ kɛcɔ kpɑ́ rɛ: Uléécɑɑ iyɔɔpi yɛ kɔ we yɑrɛ nsímɛ́ mmú: Mɛmɑ́ píimɑ mɛnyinɛ mɛɛ kɛcɑrɛ kɛnyinɛ-i kúlɑɑlɛ̃. Utisi unyinɛ uu kɛyɑ́ɑ mɛmɑ́ píimɑ mɛ̃ yɛnu, uu pikúlɑɑ mɛ pɛsɛ, uu kɔ mpɔ́ɔnɑrɛ nɛ ulikɔ́ nnɛ́í kpísi uu yɑ́i uú nɛ kɛcɑrɛ kɛ̃ lɔlu. ");
INSERT INTO soy_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Yeesu uu kɔ kpɑ́ rɛ: Uléécɑɑ iyɔɔpi yɛ kɔ we yɑrɛ ukpéénsɛ unyinɛ yɛɛ kɛyɑ́ɑ ikólɛ́ kɛcirɛ wɛ́ɛ́si. ");
INSERT INTO soy_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Kuú hɑ nkólɛ́ mɛɛ mɛyíkíyiki ń nyɑḿ n yɛ̃́, uu sĩ́ uú hɑ ulikɔ́ nnɛ́í yɑ́i uú nɛ n lɔlu. ");
INSERT INTO soy_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Uu kɔ kpɑ́ rɛ: Uléécɑɑ iyɔɔpi yɛ kɔ we yɑrɛ kunyɛŋ́ kunyinɛ kɛ usoi uu mínimɑɑ-i n fṍ ɑku ikpíntomɛ́ nnyí ncɔpuri pɑɑ́lɑ. ");
INSERT INTO soy_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Kɑku n yi, pikpíntomɛ́cɔ́pii ɑpi ku pɑsɑi ɑpi ritimɛ lesɛri ɑpi pɛɛ́ n tũ pin ikpíntomɛ́ tɛ́si, pin isɔnɛ ɑnɛ́rɛ-i wɑi pin ikópɛ fóŋɛɛ. ");
INSERT INTO soy_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Lɛ̃ kɑi sɔ́nti likɛ́ kɛtẽ mɛtɛnɛ kumúŋɛ́-i wɑ. Piléécɑɑtumɛ yɛ hɑ sɔ́ntilɛ pikɛ́ pɛpɛɛ Uléécɑɑ mɛlɑ n wɑ nɛ pɛpɛɛ ɑ́pi Umɛlɑ n wɑ kóólɛnɛ, ");
INSERT INTO soy_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ɑpi pɛpɛɛ ɑ́pi Umɛlɑ n wɑ nnɑ píimɑ kɛ́mɛɛ sɑ́pɔ. Kei kɛ pisoi ɑpi yɛ́ mɛyɑ̃́ ténesi pin inĩ́ tɑkɑi. ");
INSERT INTO soy_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yeesu uu upipirɛtiki pisɛ rɛ: Nɔ pɛɛ lɛ̃ nnɛ́í kɑm nní n símisi ɑsei konlɛ nníí? Api rɛ: Ɛɛɛ, tɔ konlɛ. ");
INSERT INTO soy_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Kei kuu pɛɛ pi mɑɑ rɛ: Lɛ̃ nnyɑ, isé ucélɑɑ úye un Uléécɑɑ iyɔɔpi nkɔ́ n ŋmurɛi, u we yɑrɛ úyɔsɑɑ unyinɛ yɛɛ ulikɔ́ kɛ́mɛɛ lifɑ́lɛ nɛ likpurɛ ń lesɛ. ");
INSERT INTO soy_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Kɛ Yeesu uu lɛ̃ nɛ sinyɑ́rũ sɛ̃ picélɑɑ pi m mɑsí, uu kei yisi uu tɔ́mpɔ, ");
INSERT INTO soy_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","uu kuyu kpɛ-i kuu iwɑ̃́ n li kɛ́mɛɛ sĩ́ uú hɑ kei Pisuifi kuyomɛyɑ́hɑɑlee-i n céési. Ai pɛpɛɛ kei ń we nnɛ́í nnɔ́ɔ yipu, ɑpi yɛ pɛɛ rɛ: Yei kɛcirɛ kɛ nkó uu mpíí mɛwɛ́ɛ́sɛsɔhɔ mmɛ́ tu? Íye kuu yɛ nɛ mɛwɑisɑŋɑ mmɛ́ wɑpisi? ");
INSERT INTO soy_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nɛ́ntɛ uyɛɛ usɛ́rɛ́ uyɛ̃ uŋmɑ́nɛ? Ái úni yɛɛ Mɑɑri? Ái upiwɑ̃ pɛɛ nní Yɑkupu nɛ Yosɛfi nɛ Simɔɔ nɛ Yuutii? ");
INSERT INTO soy_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ái tɔ́ nɛ upiyɛi nnɛ́í tɔ́ɔ nté kɛsẽ́ wee? Yei kɛcirɛ kuu pɛɛ mpíí ńnɑŋɛ mmú yɛ̃́? ");
INSERT INTO soy_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Nní nnɛ́í ɑi pi tɑpisi ɑ́pi nɛ Yeesu kɛfɑ tɛnɛ. Yeesu uu pɛɛ pi mɑɑ rɛ: Ápi yɛ ɑntepu kuyu-i nɛ ukɛyɔ-i u n wɑisɛlɛ̃. ");
INSERT INTO soy_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Pinfɑtɛnɛ kucírɛ́ nnyɑ, Yeesu úu kei mɛwɑisɑŋɑ mɛyɑ̃́ wɑpisi. ");
INSERT INTO soy_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Uyɔ́ɔpi Erooti yɛɛ pɛɛ likumúŋɛ́ kpɛ-i Kɑlilee kɛtẽ kɛcɑ́ɑ́ pɑílɛ̃. Uu pɛɛ kóm pin Yeesu nsímɛ́ símisi. ");
INSERT INTO soy_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Uu upikɛikɔ́ mɑɑ rɛ: Yohɑni Úniwolɛ yɛɛ n kpu nsímɛ́ kɑpi símisi. U pikpɔkpɔ kɛ́mɛɛ yisilɛ. Lɛ̃ nnyɑ kuu nní ńnɑŋɛ yɛ̃ un nɛ mɛwɑisɑŋɑ wɑpisi. ");
INSERT INTO soy_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Asei kɛcɑ́ɑ́, Erooti yɛ pɛɛ tíyɛsɛlɛ ɑpi Yohɑni Úniwolɛ tini ɑpi pɑɑsi ɑpi kukpɑniilee tɑni. Umɑ́ɑ Filipu unɔsi kɑpi yɛ n sée rɛ Erootiyɑti nnyɑ kuú pɛɛ́ lɛ̃ wɑ. ");
INSERT INTO soy_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Yohɑni yɛ pɛɛ Erooti mɑɑ rɛ: Áɑ ncée mɑ́ pɔkɛ́ upɔ́mɑ́ɑ unɔsi kpísi. ");
INSERT INTO soy_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Lɛ̃ nnyɑ kɛ Erooti uú pɛɛ́ lɑ ukɛ́ Yohɑni kpu, ɑmɑ́ un pɛɛ pisoi pɛɛ n cɑ́pinɛlɛ̃ wuru. Pɛ̃ nɛ pɛɛ nyɑ́nilɛ rɛ Yohɑni yɛ ɑntepu lɛ. ");
INSERT INTO soy_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Api pɛɛ kɛyɑ́ɑ kɛnyinɛ Erooti kɛmɑrɛyɑɑ ɑnyɑ̃́ n wɑi, Erootiyɑti ukpére uu léépɔ uu pisɑ́nɛ pɛɛ n cɑ́pinɛlɛ̃ kɛcɔpɛ yesu ɑi Erooti yúkúlú ");
INSERT INTO soy_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","uu pisoi inipɛɛ iyɛ-i símisi uu wééri rɛ ukpére uyɛ̃ un yo mpuri n lɑ, un li u m pisɛ, u yɛ́ li u pɑ. ");
INSERT INTO soy_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Kei kɛ Erootiyɑti uu ukpére tɑ́lɑɑnkɛɛ, uyɛ̃ uu pɛɛ Erooti mɑɑ rɛ: A nté nní Yohɑni Úniwolɛ riyu kɛcɑ́ripi tɑ́í-tɑ́í kɛ́mɛɛ wɑ ɑɑ nɛ́ pɑ. ");
INSERT INTO soy_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Kɛ Erooti uu lɛ̃ n kṍ, uripɔɔ ɑri cɑɑi. Amɑ́ uɑwééri nɛ pisɑnɛ isɛi nnyɑ, uu rinɔ́ɔ hɛ rɛ pikɛ́ lɛ̃ kuu m pisɛ u pɑ. ");
INSERT INTO soy_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Uu unyinɛ tum tɛ pikɛ́ hɑ kukpɑniilee-i Yohɑni riyu tɔ. ");
INSERT INTO soy_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Apí hɑ ríyu tɔlu ɑpí nɛ weri ɑpi ukpére uyɛ̃ pɑ, uyɛ̃ uu ri kpísi uu úni pɑ. ");
INSERT INTO soy_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Kei kɛ Yohɑni pipirɛtiki ɑpi pɛɛ́ hɑ ɑpi u kpísi ɑpi kúlɛsi, ɑpi limɛmɑ́ɑ́ pɛɛ sĩ́ ɑpí hɑ lɛlɛɛ n wɑ nnɛ́í Yeesu kɛɛni. ");
INSERT INTO soy_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Kɛ Yeesu uu nsímɛ́ mmɛ̃ n kṍ, uu yisi uu kúninɔi loni rɛ ukɛ́ tɔ́mpɔ ukɛ́ hɑ umɛcirɛ kei kɛ úkɑ úu ń we n tũ. Pisoi ɑpi kóm ɑpi ɑyu nyɛɛ nɛ kei n kɔ́lɛ̃ kɛ́mɛɛ nɛ ɑ́nɑ yisi ɑpi lɛ̃ kupiyɛ n kɑnɛi ɑpí hɑ nɛ u lɛɛpɔ. ");
INSERT INTO soy_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Kuu kúninɔi-i ń suí, uu risoiwuí yɛ́nu, tiicɔ ii íwɛ u wɑi uu pitóikɔ́ pɛɛ n hɑ́pɔ pipɔisɛntɛ loni. ");
INSERT INTO soy_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Kɑi nnyɔ́ɔ́ n wɑ, upipirɛtiki ɑpi ukɛkúrí hɑpɔ ɑpi rɛ: Ituŋɛ yɛ nkpéni pitɛnɛ mɑsilɛ, ɑ́ri kɔ nté nɛ kuyu kúkɑ kɔlɛ̃. A pisoi kulúi mpí riyɑ́ pikɛ́ siyupi-i pilukɛlɑlɛ hɑ pikɛ́ li. ");
INSERT INTO soy_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yeesu uu pi pɛsɛ rɛ: Ái tílɑsi rɛ pikɛ́ tɔ́mpɔ. Ani nɔ́rinɛ́cúruu ilukɛ pi hɛ pikɛ́ li. ");
INSERT INTO soy_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Api pɛɛ u mɑɑ rɛ: Akpɔ́nɔ́ ɑnupũ nɛ ikpíntomɛ́ itɛ́ ŋmɑnɛ kɑri nté mɑ́. ");
INSERT INTO soy_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yeesu uu pi pɛsɛ rɛ: Ani nɛ nté nɛ́ kɑm. ");
INSERT INTO soy_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Kɑpí nɛ n hɑ́pɔ, uu pɛɛ pisoi riwúí tɛ̃ mɑɑ rɛ pikɛ́ mɛyúi kɛcɑ́ɑ́ tonɛ. Uu ɑkpɔ́nɔ́ ɑnupũ nyɛ̃ nɛ ikpíntomɛ́ itɛ́ iyɛ̃ kpísi uu kɛléécɑɑ weríí uu Uléécɑɑ pɔɔnɛsɛ, uu ɑkpɔ́nɔ́ kpɔ́kɔrinɛ uu upipirɛtiki pɑ ɑpi pisoi riwúí hɔ́ɔ́nɛ. ");
INSERT INTO soy_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Pinnɛ́í ɑpi le ɑpi lɛpu. Upipirɛtiki ɑpi ɑkéri nyɛɛ m pɔɔnɛ cɑ́pinɛ ɑi ɑnɛ́rɛ kɛfi nɛ ɑtɛ́ yipu. ");
INSERT INTO soy_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Pɛpɛɛ ilukɛ iyɛ̃ n li yɛ tu pitisi ŋmɑnɛ ɑ́kotokú ɑnupũ (5.000). Ápi pinɔ́si nɛ siwɑ̃́ kɛɛ̃. ");
INSERT INTO soy_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Kɑpi pilukɛ ḿ mɑsí, Yeesu uu upipirɛtiki rinɔ́ɔ hɛ rɛ pikɛ́ kúninɔi lõ pikɛ́ hɑ kupiyɛ ritimɛ ricɔ-pɔ u fɔsí, uyɛ̃ ukɛ́ pɛɛ kei pisoi riwúí tɛ̃ n kpiisɛlɛ̃ kɛlenɛ. ");
INSERT INTO soy_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Kɛ pisoi ɑpi pikúũ ḿ mɑsí, uu yisi uu riyɔ́pɛ tɑɑ́ rɛ ukɛ́ kei umɛcirɛ n we un kɛyómɛ yɑ́ɑ́si. Uu pɛɛ kei lɛ̃ umɛcirɛ n we ɑí nɛ nnyɔ́ɔ́ wɑi. ");
INSERT INTO soy_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Kúninɔi yɛ pɛɛ likumúŋɛ́ kpɛ-i míni ritimɛ nɛ kɛtɑɑ piwɑi mɑsilɛ. Kɛ kuyɔ ɑku nní kukɛyu-mɛ̃ m pépuri nnyɑ, ɑ́niwɑlɛ́ ɑɑ pɛɛ ku n tɑ́ŋɑisɛ. ");
INSERT INTO soy_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Yeesu uu riweeki kumúŋɛ́ míni kɛcɑ́ɑ́ n sɔ́nɛ un nɛ upipirɛtiki kɛ́mɛɛ sĩ́. ");
INSERT INTO soy_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Kɑpi lɛ̃ u n yɛ̃́ un míni kɛcɑ́ɑ́ sɔ́nɛ, piipiŋɛ ii kpi nɛ iwɑmɛ mɛpehẽ, ɑpi pɛɛ pimɛcɔpɛcirɛ n tee rɛ: Kunírilɑ̃ yɛ ku. Api pɛɛ iwɑmɛ nɛ m pupukɛɛ. ");
INSERT INTO soy_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yeesu uu pɛɛ mɛsɛ nɛ mɛsɛ pi mɑɑ rɛ: Áni kɑpɛ pírí tónɛ. Nɛ́ɛ lo, iwɑmɛ íi kɑpɛ nɔ́ wɑ! ");
INSERT INTO soy_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Piyɛɛ uu u mɑɑ rɛ: In tɛ mɛsei pɔ́ɔ lo, ɑ tíyɛsɛ kɛ́ míni kɛcɑ́ɑ́ sɔ́nɛ kɛ́ nɛ pɔ́ lɛɛpɔ, Upíimɑ! ");
INSERT INTO soy_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Uu rɛ: A kɑm! Piyɛɛ uu kúninɔi-i léepɔ uu míni kɛcɑ́ɑ́ sɔ́nɛ rɛ ukɛ́ Yeesu lɛɛpɔ. ");
INSERT INTO soy_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Amɑ́ kuu n yɛ̃́ tɛ kuyɔ yɛ pɑ́ɑ́púlɛ, iwɑmɛ ii u loni, míni ɑmɛ pɛɛ u m muuni. Uu cɑ́ɑ́i rɛ: Upíimɑ, ɑ nɛ́ yóriyɛ! ");
INSERT INTO soy_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yeesu uu mɛsɛ nɛ mɛsɛ kunípɛ sɑɑpɔ uu u tini uu u pisɛ rɛ: Mpɔ́fɑtɛnɛ ńn piyɛ. Yo nnyɑ kɑɑ́ tirí? ");
INSERT INTO soy_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Kei kɛ pikɛtɛ́ ɑpi pɛɛ kúninɔi kɛ́mɛɛ lompɔ, kuyɔ ɑku sɛ́ɛ́. ");
INSERT INTO soy_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Yeesu pipirɛtiki picɔ pɛɛ kúninɔi kɛ́mɛɛ ń we ɑpi pɛɛ́ hɑ Yeesu mɛtene wulɑ ɑpi rɛ: Pɔ mɛsei Uléécɑɑ Kɛpipi lɛ. ");
INSERT INTO soy_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Kɑpi kupiyɛ pitɛ́ŋ́ ḿ mɑsí ɑpi Kenesɑrɛti kɛtẽ tulu, ");
INSERT INTO soy_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","kei pikɔ́ ɑpi Yeesu ceru, ɑpi pitumɛ ḿpɑ́ yei yɛ́kɑ́ɑ́sɛ rɛ pikɛ́ pisoi símisi rɛ u kɑ. Pisoi ɑpi pɛɛ pitóikɔ́ nnɛ́í nɛ u sɔ́nɑɑpɔ. ");
INSERT INTO soy_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Api u welu rɛ ukɛ́ ŋmurɛi pitóikɔ́ pɛ̃ pikɛ́ ḿpɑ́ ukutukɑnkɑ ritimɛ ŋmɑnɛ ricɑ. Pɛ̃ nnɛ́í pɛɛ rińcɑ ɑpi pélu cɑ́kɑ́-cɑ́kɑ́. ");
INSERT INTO soy_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Kei kɛ Pifɑrisi nɛ isé picélɑɑ pinyinɛ ɑpi Yerusɑlɛm-pɔ leemɛ ɑpi Yeesu lɛɛri ɑpi u pisɛ rɛ: ");
INSERT INTO soy_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Yo nnyɑ kɛ pipɔ́pirɛtiki ɑpi yɛ inyɛ́kii kɛ pirɔ́kpurɛ ɑpi n yekei rilɔ́ɔ́? Lɛlɛɛ rɛ ɑ́pi yɛ nɑlɛ pikɛ́ kɛlenɛ li yɑrɛ kɑi mɛkɛɛ-mɛ n wemɛ? ");
INSERT INTO soy_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yeesu uu pi pɛsɛ rɛ: Nɔ̃́ ni, yo nnyɑ kɛ nɔ́ɔ Uléécɑɑ isé rilɔ́ɔ́ ɑni nɔ́pinɛ́kpurɛ inyɛkii n tikilɛ̃? ");
INSERT INTO soy_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Uléécɑɑ yɛ mɑɑ rɛ: A upɔ́sɑ́ɑ nɛ upɔ́ni ríyu wɑisɛ. Uu kɔ rɛ úye un usɑ́ɑ nɛ́ɛ úni ɑnɔ́ɔ n wɑ, li pisɛ rɛ pikɛ́ liute kpu. ");
INSERT INTO soy_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Amɑ́ nɔ̃́ nɛ yɛ rɛ: Úye un usɑ́ɑ nɛ́ɛ úni m mɑɑ rɛ u lɛ̃ kuú pɛɛ́ ń lɑ ukɛ́ nɛ u n lɛ̃́ Uléécɑɑ hɛlɛ, ");
INSERT INTO soy_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","u yɛ́ fe uu lɛ̃ nnyɑ usɑ́ɑ nɛ́ɛ úni nkpéni pilɛ̃́ yɑ́. Uléécɑɑ nsímɛ́ kɑni lɛ̃ fómpɔ ɑni pɛɛ nɔ́pinɛ́kpurɛ inyɛkii n tikilɛ̃. ");
INSERT INTO soy_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Nɔ́ kɛcɑ́ɑ́ kɛcɑ́ɑ́ mɛwɑi pikɔ́ mpí! Antepu Esɑyi yɛ ɑlɑri mɑ́lɛ ukɛ́ nɔ́kɛnɛ́cɑ́ɑ́ mɑɑ rɛ: ");
INSERT INTO soy_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Nnɔ́ɔ-i ŋmɑnɛ kɛ pisoi mpí ɑpi ríyu nɛ́ wɑisɛlɛ̃, ɑmɑ́ ɑ́pi pɛɛ pisifɑ-i nɛ nɛ́ kɔ́lɛ̃. ");
INSERT INTO soy_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Piiyɑ́hɑɑ yɛ likpɑ́rɑ́kɔɔ́ lɛ. Pi rinyɑlɛ pin sisoipipi inyɛkii kpísi pin céési yɑrɛ inɛ́kɔ́ yɛ nyi. ");
INSERT INTO soy_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yeesu uu pɛɛ risoiwuí cɑ́pinɛ uu pi mɑɑ rɛ: Ani kutu nɛ́ ricɔ ɑni kóm ńsɔnɛ: ");
INSERT INTO soy_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ái lɛlɛɛ yɛ usoi nnɔɔ-i n lompɔ lɛɛ yɛ mɛ́kpɛrinkpɛ u wɑisɛ, ɑmɑ́ lɛlɛɛ yɛ unnɔɔ-i n léemɛ lɛɛ yɛ mɛ́kpɛrinkpɛ u wɑisɛ. ");
INSERT INTO soy_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Kei kɛ upipirɛtiki ɑpi ukɛkúrí rinyɔsɔ́pɔ ɑpi u mɑɑ rɛ: Pɔ nyu rɛ lɛ̃ kɑɑ nní n símisi yɛ Pifɑrisi mɛyɑ̃́ ticɔ́ŋ? ");
INSERT INTO soy_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Uu pi pɛsɛ rɛ: Kuléé kúye kun n we, kɑ́i Unɛ́sɑ́ɑ yɛɛ kɛyómɛcɑɑ-pɔ ń we yɛɛ ku tɑmɛsi, pi ku wɛhɛnɛ. ");
INSERT INTO soy_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ani pi riyɑ́ kei. Pi nkpɑ́ni yɑrɛ pinyíyɛ pɛɛ pinyíyɛcɔ n tórikɛɛ? Unyíyɛ un unyíyɛcɔ n tɔrɔi, pi sɔ́ntilɛ pikɛ́ hɑ nɛ pikɛtɛ́ kúcoŋ́horɛ kunyinɛ-i lóipɔ. ");
INSERT INTO soy_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Piyɛɛ uu pɛɛ rinɔ́ɔ yɔ́su uu Yeesu mɑɑ rɛ: A kɛnyɑ́rũ nkɛ́ ɑsei rɔ́ símisi. ");
INSERT INTO soy_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yeesu uu u pɛsɛ rɛ: Aí nɛ nɔ̃́ pɛ́nɛ ɑ́ni kɑhɑnɛ nkpɑ́ni líkɑ n kõo? ");
INSERT INTO soy_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Áni kõ tɛ lɛ̃ nnɛ́í lɛɛ yɛ usoi nnɔɔ-i n lompɔ yɛ̀ɛ̀ kɛfɑ-i hɑlɛ uu wɑi uu iyɑɑ leepɔ uu li lesɛrii? ");
INSERT INTO soy_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Kɛfɑ kɛ́mɛɛ kɛ nsímɛ́ nn yɛ n we, nn pɛɛ nnɔ́ɔ-i tíkimɛ nń nɛ leeri. Mmɛ mɛɛ yɛ usoi mɛ́kpɛrinkpɛ wɑisɛ. ");
INSERT INTO soy_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Lɛ̃ nnyɑ, kɛfɑ-i kɛ simúŋɛ́ kópɛ ɑsi léeri. Sɛsɛɛ yɛ tíyɛsɛ kɛ usoi uu yɛ usoi kpu, uu ucɔ unɔsi nɛ́ɛ ucɔ ulɑ kuwɑ́ncɔ wɑi, uu iwɑ́sɑ́ wɑi, uu yɑ́ɑ́i, uu kɔ ucɔ nɛ nsímɛ́ kpɑ́rɑ́, nɛ́ɛ uu ucɔ lɑ́mɑɑnkɛɛ. ");
INSERT INTO soy_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Lɛlɛɛ yɛ usoi mɛ́kpɛrinkpɛ n wɑisɛ yɛ lɛ̃. Amɑ́ usoi unsɑ́ n nɑlɛ yɑrɛ kɛ irɔ́nyɛ́kii ii ḿ mɑ ukɛ́ kɛlenɛ li, ɑ́i yɛ́ mɛ́kpɛrinkpɛ u wɑisɛ. ");
INSERT INTO soy_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yeesu uu limɛmɑ́ɑ́ kei yisi uu Tiiri nɛ Sitɔɔ sitẽ-mɛ̃ tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kɑnɑɑ kɛtẽ unɔsi unyinɛ yɛɛ kei n hɑ́pɔ uu yisi uu Yeesu lɛɛpɔ, uu pupɛi rɛ: Upíimɑ, Tɑfiti Kɛpipi, ɑ inɛ́wɛ yɛ̃. Kuníri yɛ unɛ́kpére lémɑɑpɔlɛnlɛ ɑ́i nyɑḿ! ");
INSERT INTO soy_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yeesu uu kɔ lɛ̃ n sɛ́ɛ́lɛ̃ lɛ́kɛ́-lɛ́kɛ́. Kei kɛ upipirɛtiki ɑpi ukɛkúrí rinyɔsɔ́pɔ ɑpi rɛ: A unɔ́si nkó nɛ kutu ricɔ ukɛ́ tɔ́mpɔ. U welɛ un pupukɛɛ un nɛ rɔ́ tíkilɛ̃! ");
INSERT INTO soy_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yeesu uu pi pɛsɛ rɛ Isirɑyɛɛli pikɔ́ pɛɛ ń we yɑrɛ isɑ́ŋ yɛɛ m pɔ íi nɛ usẽ́ ŋmɑnɛ kɛ́mɛɛ kɛ Uléécɑɑ uu nɛ́ tummɛ. ");
INSERT INTO soy_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Kei kɛ unɔ́si uyɛ̃ uu pɛɛ yisipɔ uú hɑ ukɛnyɑlɛ-i wúlɑ uu u mɑɑ rɛ: A risuúlu ɑ nɛ́ lɛ̃́, Upíimɑ. ");
INSERT INTO soy_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yeesu uu u pɛsɛ rɛ: Ái nyɑḿ tɛ pikɛ́ siwɑ̃́ ilukɛ kpísi pikɛ́ sipɔpipi risɑ́. ");
INSERT INTO soy_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Unɔ́si uyɛ̃ uu kɔ kpɑ́ rɛ: Mɛsei yɛ mɛ, Upíimɑ. Amɑ́ ḿpɑ́ nɛ lɛ̃, sipɔpipi pite pin n le, si yɛ lɛlɛɛ kɛteni-i m póroi n hínilɛ sin le. ");
INSERT INTO soy_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yeesu uu pɛɛ u pɛsɛ rɛ: A tíyɛ mpɔ́fɑtɛnɛ yɛ piyɛ kpɑ! Uléécɑɑ yɛ́ tíyɛsɛ lɛ̃ kɑɑ ń lɑ ɑi wɑi. Kei nní uukpére uyɛ̃ uu mɛsɛ nɛ mɛsɛ pélu. ");
INSERT INTO soy_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yeesu uu kei yisi uu Kɑlilee kupiyɛ ritimɛ sĩ. Uu pɛɛ rikúú rinyinɛ tɑɑ́ uú tonɛ. ");
INSERT INTO soy_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Kei kɛ pisoi kulúi ɑpí nɛ pipɑ́íkɔɔ́ nɛ pinyíyɛ nɛ síkɑnkɑ́lɑ́kɑ́ nɛ pisímɛ́cirɛ́ nɛ pitóikɔ́ picɔ picɔ u kɑ́lɑɑpɔ ɑpi uɑnɑ-i pi lɑikɛɛ, uu pi pɔisɛntɛ. ");
INSERT INTO soy_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Kɛ pisoi ɑpi pisímɛ́cirɛ́ n yɛ̃́ pin símisi, síkɑnkɑ́lɑ́kɑ́ sin pélɑɑlɛ̃, pipɑ́íkɔɔ́ pin sɔ́nɛ, pinyíyɛ pin nyɑ́ni, ɑi nnɔ́ɔ pi yipu ɑpi pɛɛ Isirɑyɛɛli pikɔ́ Uleecɑɑ ríyu n wɑisɛ. ");
INSERT INTO soy_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yeesu uu pɛɛ upipirɛtiki séi uu pi mɑɑ rɛ: Pisoi mpí icɔ yɛ íwɛ nɛ́ welɛ. Siyɑ́ɑ sitɑɑni yɛ nsí kɑpi kɛnɛ́kúrí we ɑ́pi kɔ nkpéni líkɑ mɑ́ pikɛ́ li. Ám kɔ lɑ kɛ́ nɛ nkṹ pi kuisɛ. Insɑ́ lɛ̃, li yɛ́ hɑ ncée pi feriyɛ. ");
INSERT INTO soy_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Upipirɛtiki ɑpi pɛɛ u pisɛ rɛ: Yei kɑri yɛ́ kuyúi nkú-i ilukɛ mɛyɑ̃́ tu pisoi píimɑ mpí pikɛ́ nɛ n lɛ? ");
INSERT INTO soy_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yeesu uu pɛɛ pi pisɛ rɛ: Akpɔ́nɔ́ ɑlɛ́ kɑni mɑ́? Api rɛ: Asɛɛi nɛ sikpíntomɛ́pi nkɑ́ripi. ");
INSERT INTO soy_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Kei kuu pɛɛ pisoi pɛɛ n cɑ́pinɛlɛ̃ tinɔ́ɔ hɛ rɛ pikɛ́ kɛteni-i tonɛ. ");
INSERT INTO soy_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Kɑpi n tónɛ, uu ɑkpɔ́nɔ́ ɑsɛɛi nyɛ̃ nɛ ikpíntomɛ́ iyɛ̃ kpísi uu Uléécɑɑ pɔɔnɛsɛ uu pɛɛ ɑ kpɔ́kɔrinɛ uu upipirɛtiki pɑ, ɑpi pisoi nnɛ́í hɔ́ɔ́nɛ. ");
INSERT INTO soy_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ḿpɑ́ úye uu le uu lɛpu. Pipirɛtiki ɑpi ɑkpɔ́nɔ́ keri nyɛɛ m pɔɔnɛ kɔ́ɔ́i ɑi ɑnɛ́rɛ ɑsɛɛi yipu. ");
INSERT INTO soy_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Pɛpɛɛ pɛɛ n li yɛ lelɛ pitisi ŋmɑnɛ ɑ́kotokú ɑnɑ (4.000), ɑ́pi pinɔ́si nɛ siwɑ̃́ kɛmɛ́ɛ kɛɛ̃. ");
INSERT INTO soy_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yeesu uu pɛɛ lɛ̃ mɛmɑ́ɑ́ pi kuisɛ, uyɛ̃ uu pɛɛ kúninɔi loni uú nɛ Mɑkɑtɑni kɛtẽ-mɛ̃ tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Kɛ Yeesu uu kei n tuipɔ, Pifɑrisi nɛ Pisɑtusee ɑpi ukɛkúrí hɑpɔ, pin wɛ́ɛ́si pikɛ́ ripinɛ u wɑ. Api u pisɛ rɛ ukɛ́ mɛwɑisɑŋɑ mɛnyinɛ wɑ mɛɛ yɛ́ n nyísɛ rɛ Uléécɑɑ-i kuu léeri. ");
INSERT INTO soy_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Kei kuu pi pɛsɛ rɛ: Ituŋɛ in n lóipɔ kɛyómɛ kɛn n wɔŋnɛ, nɔ yɛ mɑɑ rɛ kɛyɑ́ɑ yɛ nɛni nyɑmlɛ. ");
INSERT INTO soy_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Kɛyómɛ kɛn mmɑrɛ n sɑnnyɛ lin n hiihiilɛ̃, nɔ yɛ kɔ mɑɑ rɛ kɛyɑ́ɑ yɛ nɛni cɑɑinɛ. Nɔ yɛ felɛ ɑni kɛyómɛ mɛwee yɛnu ɑni mɛɑsei kom, ɑmɑ́ ɑ́ni yɛ lɛ̃ kɛ Uléécɑɑ uu ituŋɛ nnyí-i nɔ́kɛnɛ́cɔpɛ n wɑi ɑsei kõ! ");
INSERT INTO soy_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Nfɑ́ɑni kɛtẽ nkɛ́ pisoi yɛ cɑɑilɛnlɛ hɑ́i, ɑ́pi lɑ pikɛ́ Uléécɑɑ ŋmɑnɛ ritiki. Amɑ́ mɛwɑisɑŋɑ kɑpi wɛ́ɛ́si pikɛ́ yɛ̃́. Mɛwɑisɑŋɑ mɛ̃ kɛ Yonɑɑsi uu n yɛ̃́ mɛnyinɛcɔ kɑpi yɛ́ kɔ yɛ̃. Yeesu uu pɛɛ pi yɑ́ uu tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Kɛ Yeesu nɛ upipirɛtiki ɑpi ritimɛ ricɔ-mɛ̃ n sĩ́, upipirɛtiki ɑpi pɑlɛi pikɛ́ ɑkpɔ́nɔ́ kpísi pikɛ́ nɛ ripɛ́nɛ. ");
INSERT INTO soy_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yeesu uu pɛɛ pi mɑɑ rɛ: Ani nɔ́mɛnɛ́círɛ tĩ ńsɔnɛ nɛ Pifɑrisi nɛ Pisɑtusee nkpɔ́nɔ́tɔ pitɛ. ");
INSERT INTO soy_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Api pɛɛ pimɛcɔpɛcirɛ pipísɛinɛ kɑ́pɑ́ɑ́ rɛ: Kɑ́ri ɑkpɔ́nɔ́ nɛ rimpɛ́nɛmɛ nnyɑ kuu lɛ̃ cɛ́si. ");
INSERT INTO soy_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yeesu uu lɛ̃ ceru uu pi pisɛ rɛ: Nɔ́ pisoi mpí nfɑtɛnɛ ńn piyɛ. Yo nnyɑ kɑni lɛ̃ símɑɑnɛ rɛ ɑ́ni ɑkpɔ́nɔ́ kpísi? ");
INSERT INTO soy_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Íye nnyɑ kɑ́ni kómɛi hɑ́i nɛ nkpéni-mɛ? Áni ɑkpɔ́nɔ́ ɑnupũ nyɛ̃ kɑpi pisoi ɑ́kotokú ɑnupũ n hɔ́ɔnɛ nɛ ɑnɛ́rɛ tɔrɔɔ nyɛɛ m pɔɔnɛ ɑni kɔ́ɔ́i léisɛɛ? ");
INSERT INTO soy_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Áni ɑkpɔ́nɔ́ nyɛ̃ kɑpi pisoi ɑ́kotokú ɑnɑ n hɔ́ɔnɛ nɛ ɑnɛ́rɛ tɔrɔɔ nyɛɛ m pɔɔnɛ ɑni kɔ́ɔ́i pɔ̃́ kɔ léisɛɛ? ");
INSERT INTO soy_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Íye kɑi pɛɛ wɑ nɛ nkpéni-mɛ ɑ́ni kɑhɑnɛ n kõ tɛ ɑ́i ɑkpɔ́nɔ́ kɑm tee kɑḿ pɛɛ́ nɛ mɑɑ rɛ: Ani nɔ́mɛnɛ́círɛ tĩ nɛ Pifɑrisi nɛ Pisɑtusee nkpɔ́nɔ́tɔ pitɛ? ");
INSERT INTO soy_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Kei kɛ upipirɛtiki ɑpi pɛɛ kṍ tɛ ɑ́i nkpɔ́nɔ́tɔ pitɛ kɑpi yɛ nɛ ɑkpɔ́nɔ́ ń wɑ kuú pɛɛ tee rɛ pikɛ́ nɛ pimɛcirɛ tĩ. Amɑ́ lɛ̃ kɛ Pifɑrisi nɛ Pisɑtusee ɑpi n céési kuu rɛ pikɛ́ nɛ pimɛcirɛ tĩ. ");
INSERT INTO soy_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Kɛ Yeesu uu Filipu kɛtẽ-mɛ̃ Sesɑree kuyu-i n lompɔ, uu upipirɛtiki pisɛ rɛ: Pisoi yɛ rɛ nɛ̃́, Usoi Kɛpipi nɛ́ɛ úye? ");
INSERT INTO soy_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Api u pɛsɛ rɛ: Pinyinɛ yɛ símisi rɛ pɔ́ɔ Yohɑni Úniwolɛ, picɔ rɛ pɔ́ɔ Elii, picɔ pɔ́ɔ kɔ rɛ Yeremii nɛ́ɛ ɑntepuyɛ kɛcɔpɛ usɛ unyinɛ. ");
INSERT INTO soy_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Kei kuu pɛɛ pi pisɛ rɛ: Nɔ̃́ ní, nɔ̃́ nɛ mpíí rɛ nɛ́ɛ úye? ");
INSERT INTO soy_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simɔɔ Piyɛɛ uu rinɔ́ɔ u yɔ́su rɛ: Pɔ́ɔ Kirisi kɛ Uléécɑɑ uu n wɛ́ɛ. Pɔ́ɔ Uléécɑɑ, nfɑ́ɑ ute Kɛpipi. ");
INSERT INTO soy_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Kei kɛ Yeesu uu pɛɛ rinɔ́ɔ rikpɑ́ uu rɛ: Pɔ únɑrɛkomɛ lɛ, pɔ̃́ Yonɑɑsi uŋmɑ́nɛ Simɔɔ! Li we rɛ ɑ́i kɛsoipipi kɛɛ mmú pɔ́ símisi, ɑmɑ́ Unɛ́sɑ́ɑ yɛɛ kɛyómɛcɑɑ-pɔ ń we lo. ");
INSERT INTO soy_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Lɛ̃ nnyɑ, kɛ́ mmú pɔ́ símisi rɛ pɔ́ɔ Piyɛɛ, liɑsei rɛ ripɑrɛ. Tipɑrɛ tɛ̃ kɛcɑ́ɑ́ kɑm pinɛ́kɔ́ cɑ́pinɛnɛ, nkpɔ ŋmɑɑ ricuruu ńn yɛ́ ńnɑŋɛ ńkɑ pikɛcɑ́ɑ́ m mɑ́. ");
INSERT INTO soy_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nɛ́ Uléécɑɑ iyɔɔpi rinɔnɔɔ kɛhɑ́nnɛ pɔ́ rimúísɛ. Pɔn yɛ linyinɛ kɛtẽ nkɛ́ kɛcɑ́ɑ́ n yɛ̀, Uléécɑɑ yɛ́ kɔ kɛyómɛcɑɑ-pɔ li yɛ̀. Pɔn yɛ kɔ kɛtẽ nkɛ́ kɛcɑ́ɑ́ yo n ŋmurɛi, Uléécɑɑ pɔ̃́ nɛ́ kɔ kɛyómɛcɑɑ-pɔ li ŋmurɛi. ");
INSERT INTO soy_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Kei kɛ Yeesu uu pɛɛ upipirɛtiki rinɔ́ɔ hɛ rɛ ɑ́pi kɑpɛ úkɑ símisi rɛ uyɛ̃ kɛ Uléécɑɑ uu wɛ́ɛ. ");
INSERT INTO soy_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kɑí nɛ kei n kpísi kɛ Yeesu uu pɛɛ upipirɛtiki pisímɛ́ kórɑɑnɛ rɛ li pisɛ rɛ ukɛ́ Yerusɑlɛm hɑ, ukɛ́ hɑ mɛyɑ̃́ Pisuifi piwɛ́ɛ́sɛ nɛ pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ nɛ isé picélɑɑ ɑnipɛ-i íwɛ li, pikɛ́ u kpu ukɛ́ pɛɛ kɛyɑ́ɑ tɑ́ɑ́nũ tuŋɛ́ nkpɔ kɛ́mɛɛ yisi. ");
INSERT INTO soy_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Piyɛɛ uu pɛɛ u kpísi uú nɛ iyɑɑ leepɔ uú nɛ u cɛ́si rɛ: Uléécɑɑ úu yɛ́ ŋmurɛi, Upíimɑ! Líkɑ ɑ́i pɔ́ wɑinɛ! ");
INSERT INTO soy_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Kei kɛ Yeesu uu pɑnsɛpɔ uu Piyɛɛ mɑɑ rɛ: Pɔ́ɔkɛ́ mɛ̃ pɛlɛ, Setɑni! Kɑpɛ nɛ nɛ́ rikɔ! Pɔ lɑlɛ pɔkɛ́ nɛ́ púnɛisɛntɛ kɛ́ loó! Kɛpɔ́múŋɛ́ yɛ sisoipipi kɛmúŋɛ́ lɛ, ɑ́i Uléécɑɑ kɛkɔ́. ");
INSERT INTO soy_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Yeesu uu pɛɛ upipirɛtiki mɑɑ rɛ: Úye un n lɑ ukɛ́ nɛ́ ritiki, ukɛ́ umɛcirɛ pípɑí riyɑ́, uu ukunɑpɛ́ɛ́kɔɔ́ yɑ uu pɛɛ nɛ́ tíki. ");
INSERT INTO soy_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ái líkɑ nnyɑ, úye un n lɑ ukɛ́ unfɑɑ lɔ, u n fómnilɛ. Amɑ́ úye un nɛ̃́ nnyɑ unfɑɑ n fóm, u yɛ kɑlɛ uu n yɛnu. ");
INSERT INTO soy_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Usoi un nkpéni kɛtẽ nté likɔ́ nnɛ́í n yɛ̃ uu pɛɛ nfɑ́ɑ pɑɑ, kulɑ́ɑ kúye kuu pɛɛ yɛ̃́? Nɛ́ɛ yo kɛcirɛ kɛ usoi uu yɛ́ fe uu hɛ́ɛ́lɛ uú nɛ unfɑɑ yɛnu? ");
INSERT INTO soy_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Usoi Kɛpipi yɛ hɑ Kɛusɑɑ mɛyɔɔpi kɛ́mɛɛ sɔ́ntilɛ nɛ piléécɑɑtumɛ, ɑkɛ pɛɛ ḿpɑ́ úye lɛ̃ kuu n wɑ hɛ́ɛ́lɛ. ");
INSERT INTO soy_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Asei kɑm nní nɔ́ símisi rɛ: Pisoi pɛɛ nté nní ń we kɛ́mɛɛ, pinyinɛ yɛ́ nɛ̃́ Usoi Kɛpipi yɛ̃ kumúŋɛ́ kpɛ-i kɑm inɛ́yɔ́ɔpi n lenɛ ɑpi kɛlenɛ kpíni. ");
INSERT INTO soy_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Siyɑ́ɑ sikpuulũ mɛmɑ́ɑ́, Yeesu uu Piyɛɛ nɛ Yɑkupu nɛ uyɛ̃ uwɑ̃ Yohɑni kpísi ɑpí nɛ riyɔ́pɛ cɑ́cɑ́ rinyinɛ tɑɑ́ ɑpí hɑ kei pimɛcirɛ n we. ");
INSERT INTO soy_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Kei kɛ uipiŋɛ ii piinipɛɛ iyɛ-i consɛ. Ukɛyu ɑkɛ́ n tɛ́lu yɑrɛ ituŋɛ. Uilũ ii wɑ́rɑrɑ yɑrɛ mɛtɛ́í. ");
INSERT INTO soy_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Moisi nɛ Elii ɑpi pɛɛ kpɑ́fúmɛ, pi nɛ Yeesu pin yɔ́i. ");
INSERT INTO soy_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Kei kɛ Piyɛɛ uu pɛɛ Yeesu mɑɑ rɛ: Upíimɑ, li nyɑmlɛ rɛ tɔkɛ́ nté n we. Pɔn n lɑ, nɛ́ sicɑ́ŋíípi sitɑɑni nté kɑrii, pɔ́ɔ kɛsɛ kpísi, Moisi kɛsɛ, Elii kɛsɛ. ");
INSERT INTO soy_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Un kei lɛ̃ símisi, kuhopɛ pei-pei kunyinɛ ɑkú weri ɑku pi hilɑ. Tinɔ́ɔ rinyinɛ ɑri kuhopɛ kpɛ-i léeri rɛ: Nkó yɛɛ Kɛnɛ́pipi lɑlɑ kɛɛ nnɛ́pɔ́ɔnɑrɛ nnɛ́í ń te. Ani kutu kɛ ricɔ! ");
INSERT INTO soy_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Kɛ Yeesu pipirɛtiki ɑpi rinɔ́ɔ tɛ̃ n kṍ, iwɑmɛ píimɑ ii pi loni ɑpi lólu ɑpi kɛtẽ kɛ́yu tuhu. ");
INSERT INTO soy_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yeesu uu pɛɛ́ nyɔsɔ́pɔ uú nɛ pi kɔ uu rɛ: Ani yisi, iwɑmɛ íi kɑpɛ nɔ́ wɑ. ");
INSERT INTO soy_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Kɑpi inípɛɛ rinsíkɑ, Yeesu mɛcirɛ kɑpi yɛ̃́. ");
INSERT INTO soy_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Kɑpi riyɔ́pɛ n cɛ́pilɛ̃, Yeesu uu rinɔ́ɔ ntí pi hɛ: Ani n sɛ́ɛ́lɛ̃, ɑ́ni kɑpɛ úkɑ lɛ̃ kɑni n yɛ̃́ símisi likɛ́ hɑ nɛ kɛyɑ́ɑ kɛ̃ kɛ Usoi Kɛpipi ɑkɛ yɛ́ nkpɔ kɛ́mɛɛ n yisi tu. ");
INSERT INTO soy_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Upipirɛtiki ɑpi pɛɛ u pisɛ rɛ: Yo nnyɑ kɛ isé picélɑɑ ɑpi rɛ Elii yɛɛ mɛfoí sɔ́nti likɛ́ kɛlenɛ kɛtẽ kɛtɔ tu? ");
INSERT INTO soy_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Uu pi pɛsɛ rɛ: Li pisɛ ɑsei kɛcɑ́ɑ́ rɛ Elii ukɛ́ mɛfoí pɛɛmɛ ukɛ́ ḿpɑ́ yo ripɔhɔ-i li yekei. ");
INSERT INTO soy_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Nɛ̃́ nɛ lɑ kɛ́ nɔ́ símisi rɛ Elii yɛ pipɛɛmɛ mɑsilɛ pisoi ɑ́pi nkpɑ́ni u ceri, ɑmɑ́ ɑpí nɛ u wɑi yɑrɛ kɑpi ń lɑ. Limɛcɔ kɛ Usoi Kɛpipi ɑkɛ kɔ piɑnipɛ-i íwɛ lenɛ. ");
INSERT INTO soy_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Kei kɛ upipirɛtiki ɑpi pɛɛ kṍ tɛ Yohɑni Úniwolɛ nsímɛ́ kuu pi símisi. ");
INSERT INTO soy_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Kɛ Yeesu nɛ upipirɛtiki ɑpi risoiwuí nɛ rińkɔ, utisi unyinɛ uu ukɛkúrí nyɔsɔ́pɔ uu uɑnɑ-i wúlɑ. ");
INSERT INTO soy_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Uu rɛ: Upíimɑ, ɑ kɛnɛ́wɑ̃́ nkɛ́ íwɛ tẽ́! Kɛ rikpínkpĩ́ pɔ́ɔ́lúlɛ ɑkɛ yɛ mɛsɛ́rɛ lóirɛntɛ ɑkɛ́ nɛ míni-i nɛ́ɛ nnɑ-i lóipɔ. ");
INSERT INTO soy_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nɛ nɛ pipɔ́pirɛtiki kɛ lɛɛpɔlɛ ɑ́pi fe pikɛ́ kɛ pɔisɛ. ");
INSERT INTO soy_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yeesu uu pɛɛ rɛ: Nɔ́ nfɑtɛnɛcirɛ́ nɛ pikpɑ́ɑ́ree mpuri mmú! Ituŋɛ ilɛ́ kɑm nɔ́kɛnɛ́mɛɛ pitónɛ kpɑ́nɛ? Ituŋɛ ilɛ́ kɑm yɛ́ lɛ̃ nɛ nɔ́ n kɑhɑri? Ani nɛ kɛwɑ̃́ kɛ̃ nté nɛ́ kɑm. ");
INSERT INTO soy_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yeesu uu kuníri sɛnkɛɛ ɑku kɛŋmɑ́nɛpi kɛ-i lelu ɑkɛ mɛyéne mɛsɛ kei nní pélu. ");
INSERT INTO soy_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kei kɛ upipirɛtiki ɑpi pɛɛ ukɛkúrí hɑ́pɔ ɑpi iyɑɑ u pisɛ rɛ: Yo nnyɑ kɑ́ri fe tɔkɛ́ kɛŋmɑ́nɛpi kɛ̃ ɑníri pɛsɛ? ");
INSERT INTO soy_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yeesu uu pi pɛsɛ rɛ: Kɛ nɔ́nnɛ́fɑtɛnɛ nn n fíílɛ̃ nnyɑ yɛ ni. Asei kɑm nɔ́ símisi rɛ nɔ́nnɛ́fɑtɛnɛ nn pɛɛ mpuri yukɛ-yukɛ sei nnyinɛ n tulɑɑlɛ̃, nɔ́ yɛ pɛɛ fe ɑni riyɔ́pɛ ntí mɑɑ rɛ: A nté yisi ɑ hɑ nté-pɔ nyɛrɛ, ɑri mɛsei lɛ̃ wɑi. Líkɑ ɑ́i yɛ́ pɛɛ n we kɑni yɛ́ piwɑi m pɔɔnɛ. ");
INSERT INTO soy_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Piyómɛyɑ́hɑɑ nɛ pinɔ́ɔpɑhɑɑ kɛ usoi uu yɛ́ nɛ ɑníri nnyɛ́ mpuri pɛsɛ. ");
INSERT INTO soy_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Kumúŋɛ́ kpɛ-i kɑpi Kɑlilee kɛtẽ n kɔ́ɔ́núlɛ̃, Yeesu uu pɛɛ pi mɑɑ rɛ: Pi yɛ́ Usoi Kɛpipi tĩ ɑpi pisoi ɑnipɛ-i wɑi ");
INSERT INTO soy_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ɑpi kɛ kopu, ɑkɛ pɛɛ kɛyɑ́ɑ tɑ́ɑ́nũ tuŋɛ́ nkpɔ kɛ́mɛɛ yisi. Kuu lɛ̃ ḿ mɑ, upipirɛtiki ɑpɔɔ ɑɑ cɑɑi hɑ́i. ");
INSERT INTO soy_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Kɛ Yeesu nɛ upipirɛtiki ɑpi Kɑpɛrinɑwum n tuipɔ, pɛpɛɛ Uléécɑɑ kɛyɔ kɛ́mɛɛ lɑmpoo n yɔ́su ɑpi Piyɛɛ kɛkúrí sĩ́ ɑpí hɑ u pisɛ rɛ: Nɔ́unɛ́wɛ́ɛ́sɛ úu yɛ Uléécɑɑ kɛyɔ ulɑmpoo hɛ́ɛlɛ nɛ́ɛ? ");
INSERT INTO soy_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Piyɛɛ uu pi pɛsɛ rɛ: U yɛ hɛ́ɛlɛlɛ. Kuu kɛ́yɔ-i m pɛɛpɔ, Yeesu uu u pisɛ rɛ: Íye kɑɑ músu Simɔɔ? Piyupipi nɛ́ɛ pisɑ́nɛ kɑi pisɛ rɛ pikɛ́ kɛtẽ nté piyɔɔpi lɑmpoo nɛ ítɔhɔ m pɑsii? ");
INSERT INTO soy_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Piyɛɛ uu u pɛsɛ rɛ: Pisɑ́nɛ yɛ pi. Kei kɛ Yeesu uu pɛɛ rɛ: In lɛɛ ni, ɑ́i pisɛ rɛ piyupipi pikɛ́ hɛ́ɛ́lɛ. ");
INSERT INTO soy_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Amɑ́ ɑ́ri lɑ mɛrɔ́wɑi mɛnyinɛ mɛkɛ́ pi ricɔ́ŋ. Lɛ̃ nnyɑ, ɑ hɑ kupiyɛ kɛ́mɛɛ kɛhímpi ripɔlɔ ɑɑ nkpíntomɛ́ foí kɑɑ ń tininɛ lesɛri ɑɑ nnɔ́ɔ n hɑɑsɛ. Pɔ́ kɛ́mɛɛ siwóó sɛ̃ kɑi rɔ́ m pisɛ lɛɛpɔ, ɑɑ si kpísi ɑɑ́ nɛ tɔ́ nɛ mpɔ̃́ ulɑmpoo hɛ́ɛ́lɛ. ");
INSERT INTO soy_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Likumúŋɛ́ kpɛ-i, Yeesu pipirɛtiki ɑpi ukɛkúrí hɑpɔ ɑpi u pisɛ rɛ: Wóo *Uléécɑɑ iyɔɔpi kɛ́mɛɛ uwɛ́ɛ́sɛ? ");
INSERT INTO soy_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Kei kɛ Yeesu uu pɛɛ kɛwɑ̃́ síńsɑ́pi kɛnyinɛ sée uu pikɛcɔpɛ kɛ nyɛrɛsɛ ");
INSERT INTO soy_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","uu rɛ: Asei kɑm nní nɔ́ símisi rɛ nɔnsɑ́ mɛfinɛ n consɛ nɔkɛ́ siwɑ̃́ síńsɑ́pi mɛcɔ n we, ɑ́ni yɛ́ Uléécɑɑ iyɔɔpi kɛ́mɛɛ lompɔ. ");
INSERT INTO soy_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Lɛ̃ nnyɑ, uyɛɛ umɛcirɛ rincɛ́pisɛ uú n we yɑrɛ kɛwɑ̃́ síńsɑ́pi nkɛ́ mɛcɔ yɛɛ Uléécɑɑ iyɔɔpi kɛ́mɛɛ uwɛ́ɛ́sɛ. ");
INSERT INTO soy_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Úye un nɛ̃́ nnyɑ kɛwɑ̃́ nkɛ́ kɛcɔ kusɑ́nɛ n yɔsí, tinɛ́cúruu ŋmɑɑ kuu lɛ̃ kusɑ́nɛ yɔsí. ");
INSERT INTO soy_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Yeesu uu kɔ upipirɛtiki pimɑ́ɑ kpɑ́ rɛ: Amɑ́ úye un n tíyɛsɛ un siwɑ̃́ nsí kɛnyinɛ kɛɛ nɛ kɛfɑ nɛ́ n tɛnɛlɛ̃ ɑkópɛ n wɑisɛ, li kutɔsi we in tɛ pi rinɑ́ipɑrɛ mulɛ-mulɛ risɑ́ɑ-i u lɛsi ɑpí nɛ mínimɑɑ kɛ́mɛɛ u nyikipɔ. ");
INSERT INTO soy_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kɛ kɛtẽ nkɛ́ pikɔ́ ɑpi pipikɔ́ ɑkópɛ n wɑisɛ nnyɑ, íwɛ kɑpi topori. Likɛi lɛ̃ ɑ́i piwée yɑ́nɛ. Amɑ́ úye un lɛ̃ n wɑ, íwɛ kɛ liute u topori. ");
INSERT INTO soy_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","In tɛ kupɔ́nípɛ nɛ́ɛ kupɔ́nɑ kpɛɛ yɛ ɑkópɛ pɔ́ wɑisɛ, ɑ ku riké ɑɑ kɛtɑɑ-pɔ fómni. Li kutɔsi we pɔkɛ́ unípɛ nɛ́ɛ únɑkerikɔ́ ɑɑ́ nɛ nfɑ́ɑ yɛnu nɛ kɑɑ yɛ́ ɑ́nɑ nɛ́ɛ ɑnípɛ ɑtɛ́ m mɑ́ ɑɑ́ nɛ nnɑ tɛnɛcirɛ́ kɛ́mɛɛ loni. ");
INSERT INTO soy_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","In tɛ mɛpɔ́nípɛɛ mɛɛ yɛ ɑkópɛ pɔ́ wɑisɛ, ɑ mɛ lesɛ ɑɑ kɛtɑɑ-pɔ fómni. Li kutɔsi we pɔkɛ́ mɛnípɛɛ mɛsɛ m mɑ́ ɑɑ́ nɛ nfɑ́ɑ yɛnu nɛ kɑɑ yɛ́ inípɛɛ itɛ́ m mɑ́ ɑɑ́ nɛ íwɛ píimɑ kɛ́mɛɛ loni nnɑ tɛnɛcirɛ́ kɛlõ-pɔ. ");
INSERT INTO soy_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Yeesu uu kɔ pimɑ́ɑ pi kpɑ́ rɛ: Ani nɔ́mɛnɛ́círɛ tĩ nɛ siwɑ̃́ nsí kɛcɔpɛ kɛnyinɛ pilómiisɛ. Asei yɛ nyɛ rɛ *pipileecɑɑtumɛ yɛ mɛsɛ́rɛ Unɛ́sɑ́ɑ yɛɛ kɛyómɛcɑɑ-pɔ ń we lɛɛkɛɛpɔlɛ.  ");
INSERT INTO soy_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Li we rɛ pisoi pɛɛ m pɔlɑɑlɛ̃ piwɛ́lɑɑ kɛ Usoi Kɛpipi ɑkɛ́ kɑ kɛkɛ́ piɑyu lɔ. ");
INSERT INTO soy_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Íye kɑni yɛ̃́? Usoi un isɑ́ŋ pílɛ m mɑ́, ikɛmɛɛ isɛ in m pɔ, úu yɛ isɛ íi we pílɛ nnyí riyɔ́pɛ kɛcɑ́ɑ́ tíyɛ uú hɑ isɛ nnyí yɛɛ nní m pɔ wɛ́ɛ́sii? ");
INSERT INTO soy_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Un n fe un i n heei, ɑsei kɑm nɔ́ símisi rɛ isɛ iyɛ̃ piheei yɛɛ urikiŋ niŋukusɛlɛ ɑi tɔ́su isɛ íi we pílɛ nnyí yɛɛ íi nní m pɔ. ");
INSERT INTO soy_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Lɛ̃ nnyɑ, Nɔ́unɛ́sɑ́ɑ yɛɛ kɛyómɛcɑɑ-pɔ ń we úu lɑ rɛ pɛpɛɛ nní nɛ kɛfɑ u n tɛnɛlɛ̃, úkɑ úu kɔ pɛɛ pi wɑisɛlɛ̃ kɛcɔpɛ unyinɛ ukɛ́ pɔ. ");
INSERT INTO soy_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Yeesu uu kɔ pimɑ́ɑ pi kpɑ́ rɛ: Upɔ́cɔ un nɛ pɔ́ m púnnɛ, ɑ mɛpɔ́círɛ u lɛɛpɔ ɑɑ u nyísɛ lɛ̃ kuú nɛ pɔ́ m púnnɛ. Un n ŋmurɛi, upɔ́cɔ kɑɑ lɛ̃ ncée sɔnɛ-i pɛsɛmɛ. ");
INSERT INTO soy_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Amɑ́ unsɑ́ nɛ kutu pɔ́ rincɔ, ɑɑ usoi usɛ nɛ́ɛ pitɛ́ kpísi ɑɑ́ nɛ u lɛɛpɔ likɛ́ wɑ rɛ pisoi pitɛ́ nɛ́ɛ pitɑɑni yɛ itɑnsei nɔ́ li ɑní nɛ nɔ́nnɛ́símɛ́ nyɔ́ɔnsɛ. ");
INSERT INTO soy_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Amɑ́ un pɛ̃ kutu pícɔ n yɛ̀, ɑɑ Uléécɑɑ icɑ́pinɛ pikɔ́ símisi. Un kɔ Uléécɑɑ icɑ́pinɛ pikɔ́ kutu pícɔ n yɛ̀, ɑ u kpísi rɛ usoi yɛɛ úu Uléécɑɑ n nyu nɛ́ɛ *ulɑmpooyɔɔ́ lo. ");
INSERT INTO soy_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Asei kɑm nní nɔ́ símisi rɛ nɔn yɛ linyinɛ kɛtẽ nkɛ́ kɛcɑ́ɑ́ n yɛ̀, Uléécɑɑ yɛ́ kɔ kɛyómɛcɑɑ-pɔ li yɛ̀. Nɔn yɛ kɔ kɛtẽ nkɛ́ kɛcɑ́ɑ́ yo n ŋmurɛi, Uléécɑɑ pɔ̃́ nɛ́ kɔ kɛyómɛcɑɑ-pɔ li ŋmurɛi. ");
INSERT INTO soy_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Asei kɑm kɔ nní nɔ́ símisi rɛ pisoi pitɛ́ pin nɔ́kɛnɛ́cɔpɛ n kómɛinɛ kɛtẽ nté ɑpí nɛ ḿpɑ́ yo kɑpi ń lɑ pisɛ, Unɛ́sɑ́ɑ yɛɛ kɛyómɛcɑɑ-pɔ ń we yɛ́ likɛi lɛ̃ pi pɑ. ");
INSERT INTO soy_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Li we rɛ pisoi pitɛ́ nɛ́ɛ pitɑɑni pin tinɛ́nyíri yei n sée pin nɛ n tũ, nɛ pikɛcɔpɛ welɛ. ");
INSERT INTO soy_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Kei kɛ Piyɛɛ uu Yeesu kɛyúrí rinyɔsɔ́pɔ uu rɛ: Upíimɑ! Unɛ́cɔ un nɛ nɛ́ m púnnɛntɛ, mɛlɛ́ kɑm yɛ́ fe ɑm u sɑ́rɛi? Mɛsɛɛi kɛsẽ, nɛ́ɛ íye? Yeesu uu u pɛsɛ rɛ: ");
INSERT INTO soy_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ám pɔ́ mɑɑ rɛ mɛsɛɛi ŋmɑnɛ, ɑmɑ́ mɛsɛɛi mɛsɛɛi mɛpehẽ kuwóó nɛ ɑfɛɛrɛ́. ");
INSERT INTO soy_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Lɛ̃ nnyɑ kɛ *Uléécɑɑ iyɔɔpi ií we yɑrɛ nsímɛ́ mmú: Uyɔ́ɔpi unyinɛ yɛɛ kɛyɑ́ɑ upikɛikɔ́ pisɛ rɛ pikɛ́ ɑwómɛ kɑpí nɛ u m mɑ́ hɛ́ɛ́lɛntɛ. ");
INSERT INTO soy_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kuu yɛ́ pikɛ́ɛ̃ n kórɑɑnɛ, ɑpí nɛ uukɛikɔ́ unyinɛ hɑpɔ yɛɛ riwómɛ píimɑ nɛ u m mɑ́. ");
INSERT INTO soy_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Kɛ ukɛikɔ́ uyɛ̃ úu nní pihɛ́ɛlɛ n fenɛ, uukɛisɑɑ uu rinɔ́ɔ hɛ rɛ pikɛ́ u nɛ unɔ́si nɛ siwɑ̃́ nɛ ulikɔ́ nnɛ́í yɑ́ɑ́ pikɛ́ nɛ riwómɛ hɛ́ɛ́lɛ. ");
INSERT INTO soy_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ukɛikɔ́ uyɛ̃ uu kɛteni-i ɑnui kɛcɑ́ɑ́ wúlɑ uu ukɛisɑɑ kɛyu-i kpɑrɑ́ uu rɛ: A ísuúlu li kɛlenɛ Upíimɑ, nɛ́ linnɛ́í pɔ́ hɛ́ɛ́lɛ. ");
INSERT INTO soy_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ukɛisɑɑ uu íwɛ u téni uu u yɑ́ uu tɔ́mpɔ, uu kɔ riwómɛ tɛ̃ u hɛ. ");
INSERT INTO soy_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Kɛ ukɛikɔ́ uyɛ̃ uu kei n léepɔ, uú nɛ uukɛicɔ unyinɛ sɑ́nɛ yɛɛ riwómɛ u n lukɑɑlɛ̃ yɑrɛ siwóó nkɑ́ripi kumúŋɛ́. Uu uwómɛlukɛ uyɛ̃ kɛmuũ yéu uu rɛ: A lɛ̃ kɑɑ nɛ́ n li nɛ́ hɛ́ɛ́lɛ. ");
INSERT INTO soy_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ukɛicɔ uyɛ̃ uu ɑnui u finɛ uu u kpurukɛɛ rɛ: A ísuúlu li kɛlenɛ, nɛ́ pɔ́ hɛ́ɛ́lɛ. ");
INSERT INTO soy_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Amɑ́ uu yúlu, ticuruu uu tíyɛ ɑpi kukpɑniilee u tɑni rɛ ukɛ́ kei n we uú nɛ uriwomɛ hɛ́ɛ́lɛ. ");
INSERT INTO soy_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Kɛ pikɛikɔ́ picɔ ɑpi n yɛ̃́ lɛlɛɛ n wɑi, mpɔ́ɔcɑɑi nn pi loni ɑpi yisi ɑpí hɑ lɛ̃ nnɛ́í lɛɛ n wɑ piukɛisɑɑ kɛɛni. ");
INSERT INTO soy_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ukɛisɑɑ uu pɛɛ tum ɑpi ukɛikɔ́ uyɛ̃ u séipɔ uu u mɑɑ rɛ: Pɔ́ ukɛikɔ́ kpɑ́ɑ́ree nkó! Tipɔ́wómɛ nnɛ́í kɑḿ pɛɛ pɔ́ hɛ rɛ pɔ rikɛcɑ́ɑ́ ísuúlu nɛ́ we nnyɑ. ");
INSERT INTO soy_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Pɑ́ɑ yɛ pɛɛ upɔ́kɛicɔ nkó íwɛ tẽ́ yɑrɛ kɛ nɛ́ɛ íwɛ pɔ́ n tẽ́ mɛcɔɔ? ");
INSERT INTO soy_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Uukɛisɑɑ uu kuwɔ́i nɛ tíyɛ ɑpi kukpɑniilee u tɑni rɛ ukɛ́ íwɛ rilélé uú nɛ uriwomɛ nnɛ́í hɛ́ɛ́lɛ. ");
INSERT INTO soy_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yeesu uu kɔ kpɑ́ rɛ: Nɔ́kɛnɛ́cɔpɛ úye unsɑ́ yɛ uucɔ nɛ kɛfɑ kɛsɛ n sɑ́rɛi, limɛcɔ kɛ Unɛ́sɑ́ɑ yɛɛ kɛyómɛcɑɑ-pɔ ń we uu u wɑinɛ. ");
INSERT INTO soy_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Kɛ Yeesu uu lɛ̃ pisímɛ́ ḿ mɑsí, uu Kɑlilee kɛteni-i yisi uu Yutee kɛtẽ kɛɛ Yuritɛɛ nkoi kuwɛ́ɛ́-mɛ̃ ń we sĩ. ");
INSERT INTO soy_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Pisoi kulúi ɑpi kei u tikipɔ uu pitóikɔ́ pɔisɛntɛ. ");
INSERT INTO soy_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Pifɑrisi pinyinɛ ɑpí nɛ u kɔ rɛ pikɛ́ ripinɛ u wɑ nnyɑ. Api u pisɛ rɛ: Ncée yɛ we rɛ utisi yɛ́ fe uu ḿpɑ́ yo mpuri nnyɑ unɔ́si yuluu? ");
INSERT INTO soy_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yeesu uu pi pɛsɛ rɛ: Áni Uléécɑɑ Nsímɛ́ ritɛlɛ́ kɛ́mɛɛ nsímɛ́ mmú kɑpi n wɔ́i kɛɛnlɛí? Pi wɔi rɛ: Kɛ́korɑɑnɛ, utisi nɛ unɔ́si kɛ Uléécɑɑ uu wɑ ");
INSERT INTO soy_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","uu rɛ: Lɛ̃ nnyɑ kɛ utisi uu usɑ́ɑ nɛ úni yisinɛ u nɛ unɔ́si ɑpí hɑ pɛ́nɛ ɑpi pɑnsɛ ipiŋɛ isɛ. ");
INSERT INTO soy_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Lɛ̃ nnyɑ, ɑ́pi nkpéni pitɛ́, ɑmɑ́ piipiŋɛ yɛ isɛ lɛ. Lɛ̃ nnyɑ usoi úu kɑpɛ lɛ̃ kɛ Uléécɑɑ uu rimpɛ́nɛ kóólɛnɛ. ");
INSERT INTO soy_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Kei kɛ Pifɑrisi ɑpi pɛɛ u pisɛ rɛ: Yo nnyɑ kɛ Moisi uu pɛɛ́ mɑɑ rɛ utisi yɛ́ fe uu pitúunnɛ ritɛlɛ́ unɔ́si wɔlu uu pɛɛ u yulu. ");
INSERT INTO soy_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yeesu uu pi pɛsɛ rɛ: Nɔ́ɑnɛ́kíŋ ntɑkɛ nnyɑ kɛ Moisi uu ncée nɔ́ hɛ rɛ ɑni yɛ fe ɑni nɔ́pinɛ́nɔ́si lɑkɑsɛ. Ái pɛɛ kɛ́korɑɑnɛ-mɛ lɛ̃ we. ");
INSERT INTO soy_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Asei kɑm nní nɔ́ símisi: Úye un unɔ́si n lɑkɑsɛ, linsɑ́ iwɑ́sɑ́nkɑí nnyɑ, kuu pɛɛ́ hɑ unɔ́si féé kpísi, iwɑ́sɑ́nkɑí kuu lɛ̃ wɑ. ");
INSERT INTO soy_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Kei kɛ upipirɛtiki ɑpi pɛɛ u mɑɑ rɛ: In lɛ̃ kɑi pisɛ rɛ utisi ukɛ́ nɛ unɔ́si n we, li kutɔsi we rɛ usoi úu kɑpɛ unɔ́si kpísi. ");
INSERT INTO soy_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yeesu uu pi pɛsɛ rɛ: Ái pisoi nnɛ́í pɛɛ yɛ́ nsímɛ́ mmú ŋmurɛi. Pɛ̃ kɛ Uléécɑɑ uu n tíyɛsɛ rɛ pikɛ́ ŋmurɛi mɛcirɛ pɛɛ yɛ́ ŋmurɛi. ");
INSERT INTO soy_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Li we rɛ pisoi yɛ welɛ pɛɛ ɑ́pi yɛ pinɔ́si n kpísi rɛ ɑ́pi yɛ́ fe nnyɑ. Lɛ̃ kɑpí nɛ picɔ mɑri. Pisoicɔ mɛwɑi mɛɛ lɛ̃ picɔ pɑnsɛsɛ. Picɔ pɔ́ɔ Uléécɑɑ iyɔɔpi nnyɑ pinɔ́sikpikɛ́ yɑ́. Úye un n lɑ ukɛ́ icélɑɑ nnyí kṍ uu kóm. ");
INSERT INTO soy_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Lɛ̃ mɛmɑ́ɑ́ pisoi pinyinɛ ɑpí nɛ siwɑ̃́ síńsɑ́pi sinyinɛ Yeesu hɑpɔ rɛ ukɛ́ ɑnípɛ sikɛcɑ́ɑ́ rilɑɑ ukɛ́ kɔ sikɛcɑ́ɑ́ kɛyómɛ yɑ́ɑ́si. Amɑ́ upipirɛtiki ɑpí nɛ pi cɛsi. ");
INSERT INTO soy_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Kei kuu pɛɛ pi mɑɑ rɛ: Ani siwɑ̃́ tiyɑ́ sikɛ́ kɛnɛ́mɛɛ kɑm. Áni kɑpɛ ncée si tɑ́pisi. Likumúŋɛ́ rɛ mpí pɛɛ simɛcɔ ń we pɛɛ yɛ́ Uléécɑɑ iyɔɔpi kɛ́mɛɛ lõ. ");
INSERT INTO soy_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Kei kuu ɑnípɛ sikɛcɑ́ɑ́ rilɑɑ uu pɛɛ limɛmɑ́ɑ́ kei yisi uu tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Kɛyɑ́ɑ kɛ uŋmɑ́nɛ unyinɛ uú nɛ Yeesu rikɔ uu u pisɛ rɛ: Sɑ́ɑ, lisɔnɛ líye kɑi pisɛ rɛ kɛ́ wɑ kɛ́ nɛ nfɑ́ɑ tɛnɛcirɛ́ n yɛ̃́? ");
INSERT INTO soy_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Uu u pɛsɛ rɛ: Yo nnyɑ kɑɑ lisɔnɛ kɛcɑ́ɑ́ nkɔ́ nɛ́ písɛi? Usɛ kóló yɛɛ Usɔnɛ. Uyɛɛ Uléécɑɑ. Pɔn n lɑ pɔkɛ́ nfɑ́ɑ tɛnɛcirɛ́ yɛ̃́, isé kuu m pɑ́sii kɑɑ yɛ́ n tikilɛ̃. ");
INSERT INTO soy_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Uu rɛ: Iyɛɛ íye? Yeesu uu rɛ: Iyɛɛ rɛ: Kɑpɛ usoi kpu, kɑpɛ iwɑ́sɑ́ wɑ, kɑpɛ nnɔ́ɔmɛ itɑnsei nyɛrɛ, kɑpɛ yɑ́ɑi. ");
INSERT INTO soy_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","A yɛ upɔ́sɑ́ɑ nɛ upɔ́ni ríyu wɑisɛ, ɑɑ kɔ upɔ́cɔ n lɑ yɑrɛ kɑɑ ripɔ́cúruu ń lɑ. ");
INSERT INTO soy_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Uŋmɑ́nɛ uyɛ̃ uu u pɛsɛ rɛ: Nɛ lɛ̃ nnɛ́í wɑlɛ. Yo icɔ kɑi pisɛ rɛ kɛ́ wɑ? ");
INSERT INTO soy_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yeesu uu pɛɛ u mɑɑ rɛ: Pɔn n lɑ pɔkɛ́ wɑ likɛ́ n nyɑḿ nɛ kɛ́tɔ-pɔ, ɑ n ŋme ɑ lɛ̃ kɑɑ m mɑ́ yɑ́ɑ́, ɑɑ siwóó sɛ̃ píwɛkɔɔ́ hɔ́ɔnɛ, pɔ́ pɛɛ mɛmɑ́ yɛ̃́ kɛyómɛcɑɑ-pɔ. Pɔn lɛ̃ piwɑi m mɑsí, ɑɑ pɛɛ́ weri ɑɑ nɛ́ tíki. ");
INSERT INTO soy_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Kɛ uŋmɑ́nɛ uyɛ̃ uu lɛ̃ n kṍ, uú nɛ mpɔ́ɔcɑɑi tɔ́mpɔ, kɛ ukunipɛ ɑku nní m mulú nnyɑ. ");
INSERT INTO soy_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Kei kɛ Yeesu uu pɛɛ upipirɛtiki mɑɑ rɛ: Asei kɑm nní nɔ́ símisi rɛ Uléécɑɑ iyɔɔpi kɛ́mɛɛ pilonɛ yɛ nɛ umɑ́mɑ́ pɑ́ɑ́púlɛ. ");
INSERT INTO soy_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kɛ́ kɔ nɔ́ rikpɑ́ rɛ: Kuyooyoo kun n lɑ kukɛ́ kɛhímpi kupolɛ-i lompɔ, li yɛ́ kutɔsi m purú nɛ kɛ umɑ́mɑ́ uu yɛ́ ń lɑ ukɛ́ Uléécɑɑ iyɔɔpi kɛ́mɛɛ n lompɔ. ");
INSERT INTO soy_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Kɛ upipirɛtiki pɛ̃ ɑpi lɛ̃ n kṍ, ɑi pi muuni síḿ ɑpi pɛɛ rɛ: In lɛ̃, wóo yɛ́ pɛɛ fe uu píyulɑlɛ yɛnu? ");
INSERT INTO soy_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yeesu uu pi nyɑ́nɛi ńsɔnɛ uu pɛɛ rɛ: Lɛlɛɛ ɑ́i sisoipipi kɛ́mɛɛ kuwɑi ń we yɛ Uléécɑɑ kɛ́mɛɛ kuwɑi welɛ. ");
INSERT INTO soy_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Kei kɛ Piyɛɛ uu pɛɛ rinɔ́ɔ yɔsí uu rɛ: A ripɑí kɑri lirɔ́kɔ́ nnɛ́í n tíyɛ tɔn pɔ́ tíkilɛ̃. Yo kɑri likɛmɛɛ yɛ́nunɛ? ");
INSERT INTO soy_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yeesu uu pi pɛsɛ rɛ: Asei kɑm nní nɔ́ símisi rɛ kumúŋɛ́ kpɛ-i kɛ nɛ̃́ Usoi Kɛpipi ɑm n sɔ́nti kɛ́ mɛ́yukɔɔ́ kɛtẽ fɑlɛ kɛ Uléécɑɑ uu n consɛ kɛ́mɛɛ rinɛ́yɔ́ɔpitũ kɛcɑ́ɑ́ ń tonɛ, nɔ́ kɛfi nɛ pitɛ́ mpí nɔ́ɔ nní nɛ́ rintíki, nɔ̃́ nɛ kɔ ɑtṹ kɛfi nɛ ɑtɛ́ kɛcɑ́ɑ́ túntinɛ ɑní nɛ Isirɑyɛɛli ipuri kɛfi nɛ itɛ́ iyɛ̃ pisoi kɛtɑhɑi túhɑɑnɛ. ");
INSERT INTO soy_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Pɛpɛɛ nɛ̃́ nnyɑ síyɔ nɛ́ɛ pimɑ́ɑ nɛ piwɑ̃́ nɛ́ɛ piyɛ́i nɛ́ɛ pisɑ́ɑ nɛ́ɛ píni nɛ́ɛ pinɔ́si nɛ sipipi nɛ́ɛ sicɑrɛ n tíyɛ, yɛ́ lɛ̃ kɑpi n tíyɛntɛ yɛ̃ mɛpehẽ pílɛ, ɑpi kɔ nfɑ́ɑ tɛnɛcirɛ́ yɛ́nu ɑi likɛcɑ́ɑ́ kpɑ́. ");
INSERT INTO soy_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Pifoí mɛyɑ̃ yɛ́ pitɔ́rɔɔ pɑnsɛ, pitɔ́rɔɔ mɛyɑ̃ ɑpi pifoí. ");
INSERT INTO soy_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yeesu uu kɔ kpɑ́ rɛ: Lɛ̃ nnyɑ, Uléécɑɑ iyɔɔpi yɛ kɔ we yɑrɛ nsímɛ́ mmú: Ukɛisɑɑ unyinɛ yɛɛ kɛmɑrɛsinɛ leepɔ rɛ ukɛ́ pikɛikɔ́ wɛ́ɛ́si pikɛ́ uɑléé kɑpi yɛ n sée rɛ fiinyi kɛcɑrɛ kɛ́mɛɛ u kɛisi. ");
INSERT INTO soy_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","U nɛ pɛ̃ ɑpi kómɛinɛ rɛ ukɛ́ pi hɛ́ɛ́lɛ nnɛ́í mmɛ̃ kɑpi yɛ kɛyɑ́ɑ kɛsɛ ukɛikɔ́ n hɛ́ɛlɛ. Kei kuu pɛɛ kɛcɑrɛ-i pi tɔ́ŋsɛpɔ. ");
INSERT INTO soy_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Kɑi ḿ pi yɑrɛ ituŋɛ mɛsɛ ɑ́mɛ we kɛfi kumúŋɛ́, uu kɔ leepɔ uu pikɛikɔ́ picɔ yɛnu, pɛ̃ pin kɛ́yɑɑ́lɑ-i mɛ́woo nyɛnu. ");
INSERT INTO soy_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Uu pi mɑɑ rɛ: Nɔ́ɔkɛ́ hɑ kɔ kɛnɛ́cɑrɛ-i kɛisi kɛ́ nnɛ́í mmɛ̃ kɑi m pisɛ nɔ́ hɛ́ɛ́lɛ. ");
INSERT INTO soy_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Api yisi ɑpi sĩ́. Uu kɔ ituŋɛ kɛcírɛ kumúŋɛ́ nɛ nnyɔ́ɔ́ mɛtɑɑni kumúŋɛ́ piléepɔ kpɑ́, uu kɔ pikɛikɔ́ picɔ kpísi. ");
INSERT INTO soy_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Kɑi nnyɔ́ɔ́ mɛnupũ ḿ pi, uu kɔ piléepɔ kpɑ́ uu pinyinɛ yɛnu pin kei nyɛnu, uu pi mɑɑ rɛ: Yo nnyɑ kɑni nté mɛ́woo nyɛnu ituŋɛ nɛ imɛlólɛ́? ");
INSERT INTO soy_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Api u pɛsɛ rɛ: Lɛlɛɛ rɛ úkɑ úu pikɛi rɔ́ kpísi. Uu pi mɑɑ rɛ: Nɔ́ɔkɛ́ kɔ n ŋme ɑni hɑ kɛnɛ́cɑrɛ-i kɛisi. ");
INSERT INTO soy_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Kɑi nnyɔ́ɔ́ n wɑ, ucɑrɛte uyɛ̃ uu uyɛɛ ulikɔ́ kɛcɑ́ɑ́ m pɑílɛ̃ mɑɑ rɛ: A pikɛikɔ́ pɛ̃ sée ɑɑ pɛpɛɛ mɛtɔ́rɔɔ ń kɑ nɛ pihɛ́ɛ́lɛ korɑɑnɛ ɑɑ́ nɛ pifoí kɛ́tɔ pɑ́ɑ́lɑ́. ");
INSERT INTO soy_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Pɛpɛɛ nnyɔ́ɔ́ mɛnupũ kumúŋɛ́ pikɛi n kórɑɑnɛ ɑpí weri, ḿpɑ́ úye uu nnɛ́í mmɛ̃ kɑpi yɛ kɛyɑ́ɑ kɛsɛ ukɛikɔ́ n hɛ́ɛlɛ yɔ́su. ");
INSERT INTO soy_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Kɛ pikɛikɔ́ foí pɛ̃ ɑpi ń kɑ, ɑpí m músu rɛ piihɛ́ɛ́ yɛ́ picɔ ikɔ́ rifɑɑu. Amɑ́ ḿpɑ́ úye uu nnɛ́í nsɛ mmɛ̃ kɑpi yɛ kɛyɑ́ɑ kɛsɛ ukɛikɔ́ n hɛ́ɛlɛ yɔ́su. ");
INSERT INTO soy_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Api kɛwóóyɔɔ́ kɛ-i iŋmúlɑɑ nɛ ukɛisɑɑ uyɛ̃ iwɔ́hɔ́ loni. ");
INSERT INTO soy_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Api rɛ: Mpí pɛɛ nní pikɛi mɛtɔ́rɔɔ mmɛ́ ń kɑ yɛ wɑlɛ ituŋɛ mɛkɔ́ɔ́nú mɛsɛ. Aɑ pɛɛ tɔ́ nɛ pɛ̃ nnɛ́í nsɛ hɛ́ɛlɛ, in kɔ nɛ tɔ́ɔ mɛyɑ̃́ ntuŋɛ nɛ mpɔɔnɛ kõ. ");
INSERT INTO soy_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ukɛisɑɑ uyɛ̃ uu piusɛ rinɔ́ɔ yɔ́su rɛ: Ám inípɛɛ pɔ́ li, unɛ́sɑ́nɛ! Ái rɔ kómɛinɛlɛ rɛ nnɛ́í mmɛ̃ kɑpi yɛ kɛyɑ́ɑ kɛsɛ ukɛikɔ́ n hɛ́ɛlɛ kɑɑ yɛ́ yɔsíi? ");
INSERT INTO soy_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","A lipɔ́kɔ́ kpísi ɑɑ tɔ́mpɔ! Nɛ lɑlɛ kɛ́ nɔ́ nɛ uyɛɛ pikɛi mɛtɔ́rɔɔ mmɛ́ ń kɑ nnɛ́í nsɛ hɛ́ɛ́lɛ. ");
INSERT INTO soy_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Yɑrɛ ɑ́m ncée mɑ́ kɛ́ linɛ́kɔ́ nɛ mɛnɛ́lɑ wɑ, nɛ́ɛ íye? Nɛ́ɛ pɔ inípɛɛ wɔŋnɛ rɛ nɛ kɛfɑ lɑ́ɑ́rú nnyɑ? ");
INSERT INTO soy_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Kei kɛ Yeesu uu rikpɑ́ rɛ limɛcɔ kɛ pitɔ́rɔɔ ɑpi yɛ́ pɑnsɛ pifoí, pifoí ɑpi pitɔ́rɔɔ. ");
INSERT INTO soy_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yeesu nɛ upipirɛtiki ɑpi kɛyɑ́ɑ kɛnyinɛ Yerusɑlɛm n tɔ́su, uu upipirɛtiki kɛfi nɛ pitɛ́ pɛ̃ iyɑɑ séi uu pi mɑɑ rɛ: ");
INSERT INTO soy_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Nɔ nyɑ́nii, Yerusɑlɛm kɑri nní símpɔ pikɛ́ hɑ kei Usoi Kɛpipi tĩ pikɛ́ pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ nɛ isé picélɑɑ ɑnipɛ-i wɑ, pɛ̃ pikɛ́ nɛ u túhɑɑnɛ ɑpi yekei rɛ pikɛ́ u kpu. ");
INSERT INTO soy_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Pi yɛ́ pɛpɛɛ ɑ́pi Uléécɑɑ m pɑkɑrɛlɛ̃ ɑnipɛ-i u wɑ, ɑpi mɛ́woo u nyɑ́nɛi ɑpi isɛ́í u fopii ɑpi kunɑpɛ́ɛ́kɔɔ́ kɛcɑ́ɑ́ u kɑrii, uu pɛɛ kɛyɑ́ɑ tɑ́ɑ́nũ tuŋɛ́ nkpɔ kɛ́mɛɛ yisi. ");
INSERT INTO soy_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Kei kɛ unɔsi uu upiŋmɑ́nɛ kɛtɛ́, Yɑkupu nɛ Yohɑni kpísi uú nɛ Yeesu lɛɛpɔ, uu ukɛyu-i wúlɑ uú nɛ u téni. ");
INSERT INTO soy_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yeesu uu pɛɛ u pisɛ rɛ: Yo kɑɑ́ lɑ kɛ́ pɔ́ wɑ? Uu rinɔ́ɔ u yɔ́su rɛ: Nɛ lɑ rɛ ɑ ŋmurɛi rɛ pɔ́ tíyɛsɛ pinɛ́ŋmɑ́nɛ mpí kɛtɛ́ ɑpí mɑsí ipɔ́yɔ́ɔpi kɛ́mɛɛ tonɛ, ucɔ kupɔ́lukɛ-lukɛ, ucɔ kupɔ́míi-mɛ̃. ");
INSERT INTO soy_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yeesu uu pɛɛ pi pɛsɛ rɛ: Áni nyu lɛ̃ kɑni kei nní n welu. Nɔ́ fe ɑni ntóósi kɛporipi kɑm n nírunɛ níruu? Api rɛ: Ɛɛɛ, tɔ́ fe. ");
INSERT INTO soy_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yeesu uu pi mɑɑ rɛ: Nɔ́ mɛsei ntóósi kɛporipi mɛnɛ́cɔ n ntí. Amɑ́ in kunɛ́lukɛ-lukɛ nɛ́ɛ kunɛ́míi mɛtonɛ nkɔ́ mmú, ɑ́i nɛ́ɛ yɛ́ tíyɛsɛ likɛ́ nɛ lɛ̃. Pɛ̃ nnyɑ kɛ Unɛ́sɑ́ɑ uu sitónɛ sɛ̃ n nyɔ́ɔnsɛlɛ̃ kuu si pɑnɛ. ");
INSERT INTO soy_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Kɛ upipirɛtiki kɛfi tɔrɔɔ mpí pɔ́ɔ lɛ̃ n kṍ, piripɔɔ ɑrí nɛ pimɑ́rɛcɔ pitɛ́ mpí cɑɑi. ");
INSERT INTO soy_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yeesu uu pinnɛ́í séi uu pi mɑɑ rɛ: Nɔ nyulɛ rɛ pɛ̃ kɑpi n kpíilɛ̃ tɛ ɑyu piwɛ́ɛ́sɛ yɛ pinnɑŋɛ nɛ ɑ wéékusɛlɛnlɛ, pisoi kɛcirɛ pin pinnɑŋɛ ɑ nyísɛlɛ̃. ");
INSERT INTO soy_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Amɑ́ ɑ́i limɛcɔ kɑi nɔ̃́ kɛ́mɛɛ we. Úye un n lɑ ukɛ́ nɔ́kɛnɛ́cɔpɛ uwɛ́ɛ́sɛ, ukɛ́ pɑnsɛ nɔ́unɛ́kɛikɔ́. ");
INSERT INTO soy_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Úye un kɔ nɔ́kɛnɛ́cɔpɛ ikpéẽ n lɑ, liute ukɛ́ nɔ́unɛ́lɑ́si. ");
INSERT INTO soy_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Limɛcɔ kɛ Usoi Kɛpipi ɑ́kɛ kɑ rɛ pikɛ́ kɛ n kɛisi. Amɑ́ kɛ kɑlɛ rɛ kɛkɛ́ picɔ kɛisi kɛkɛ́ kɔ kɛnfɑɑ kpísi kɛkɛ́ piɑkópɛ nnyɑ hɛ likɛ́ nɛ pisoi mɛyɑ̃ ɑyu lɔ. ");
INSERT INTO soy_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Lɛ̃ mɛmɑ́ɑ́, Yeesu nɛ upipirɛtiki ɑpi Yeriko kuyu tulu. Kɑpi kei n yisi pin tɔ́su, tisoiwuí píimɑ rinyinɛ ɑri un n tikilɛ̃. ");
INSERT INTO soy_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Kei kɛ pinyíyɛ pitɛ́ pinyinɛ pɛɛ ricéetimɛ n tṹ ɑpi kṍ tɛ Yeesu yɛɛ tɔ́su. Api pɛɛ sicɑ́ɑ́ilɑ kɑ́pɑ́ɑ́ rɛ: Upíimɑ, Tɑfiti Kɛpipi, ɑ irɔ́wɛ ripɑí! ");
INSERT INTO soy_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Pisoi pɛɛ n cɑ́pinɛlɛ̃ ɑpi pi cɛ́si rɛ pikɛ́ risɛ́ɛ́, ɑmɑ́ ɑpi pɛɛ mɛyɑ̃́ n cɑ́ɑ́i ŋmɑɑ nɛ ńnɑŋɛ rɛ: Upíimɑ, Tɑfiti Kɛpipi, ɑ irɔ́wɛ ripɑí! ");
INSERT INTO soy_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yeesu uu pɛɛ nyɛrɛ, uu pi séi uu pi pisɛ rɛ: Yo kɑní lɑ kɛ́ nɔ́ wɑ? ");
INSERT INTO soy_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Api u pɛsɛ rɛ: Upíimɑ, tɔ lɑ rɛ ɑ wɑ irɔ́nípɛɛ ikɛ́ wúkulɛ. ");
INSERT INTO soy_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yeesu uu piiwɛ pɑí uu piinipɛɛ cɑ, mɛsɛ nɛ mɛsɛ, inípɛɛ ii wúkulɛ, pikɛtɛ́ ɑpi pɛɛ u tiki. ");
INSERT INTO soy_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Kɛ Yeesu nɛ upisencɔ ɑpi Yerusɑlɛm n nyɑhɑipɔ, ɑpi Olifiyee rikúú mɛtene Pɛtifɑsee kuyu-i lompɔ. Yeesu uu upipirɛtiki pitɛ́ tum ");
INSERT INTO soy_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","uu pi mɑɑ rɛ: Ani kuyu nkú kpɛɛ nní nɔ́kɛnɛ́yu-pɔ ń we kɛ́mɛɛ hɑpɔ. Nɔ́ mɛsɛ nɛ mɛsɛ kɛminɑɑyɑhɑ kɛnyinɛ lɛɛpɔ, kɛ nɛ kɛkɛpipi sin torɑɑlɛ̃. Ani si fénnɛ ɑní nɛ nɛ́ si weri. ");
INSERT INTO soy_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Úye un ń-ye nɔ́ m pisɛ, ɑni u pɛsɛ rɛ: Upíimɑ yɛ si lɑlɛ. Liute yɛ́ kei nní nɔ́ riyɑ́ ɑni tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Lɛ̃ kɛ ɑntepu uú pɛɛ ḿ mɑ likɛ́ nɛ n wɑ nnyɑ kɑi lɛ̃ wɑ. U pɛɛ́ mɑɑ rɛ: ");
INSERT INTO soy_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Ani Siyɔɔ kuyu pikɔ́ mɑɑ rɛ: Ani ripɑí, nɔ́unɛ́yɔ́ɔpi yɛɛ nní nɔ́kɛnɛ́mɛɛ wemɛ. Usoi niŋɛ-niŋɛ lo, kɛminɑɑ kɛpipi kɛcɑ́ɑ́ kuu túnti. ");
INSERT INTO soy_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Upipirɛtiki ɑpi yisi ɑpi tɔ́mpɔ, ɑpí hɑ wɑi yɑrɛ kuu pi n forii. ");
INSERT INTO soy_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Apí nɛ kɛminɑɑ nɛ kɛkɛpipi weri ɑpi pimɛlɑpɛ sikɛcɑ́ɑ́ lɑ́ɑi ɑpi mɛkɛcɑ́ɑ́ u tonsɛ. ");
INSERT INTO soy_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Pisoi kulúi ɑpi pisitukɑnkɑ lesɛ ɑpi ncée-i tɑ́ŋɛntɛ, picɔ ɑpi ɑpɛ́i hɛ́piri ɑpi tɑ́ŋɛntɛ rɛ pikɛ́ nɛ ríyu u wɑisɛ. ");
INSERT INTO soy_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Pisoi pɛɛ ukɛyu n sɔ́nɛ nɛ pɛpɛɛ ukɛpirɛ n tíkilɛ̃ ɑpi pɛɛ́ n cɑ́ɑ́i rɛ: Tɑfiti Kɛpipi, ɑni uyɛɛ n sɔ́nti nɛ Upíimɑ rinyiri ritɑɑ́sɛ! Osɑnnɑ, ɑni urinyiri kɛyómɛcɑɑ-pɔ ritɑɑ́sɛ! ");
INSERT INTO soy_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Kɛ Yeesu uu Yerusɑlɛm kuyu-i n lompɔ, ɑi pisoi nnɛ́í lémesi ɑpi pɛɛ́ m písɛinɛ rɛ: Usoi úye kɛcirɛ yɛ nkó? ");
INSERT INTO soy_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Pisoi pɛɛ u n tíkilɛ̃ ɑpi rɛ: Uyɛɛ ɑntepu Yeesu, Kɑlilee kɛtẽ-pɔ Nɑsɑrɛti ukɔ́ lo. ");
INSERT INTO soy_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yeesu uu Uléécɑɑ kɛyɔ kɛ́mɛɛ lompɔ uu pɛpɛɛ kei n yɑ́lisi nɛ pɛpɛɛ n lɛ́ɛ́ri nnɛ́í lɑ́kɑsɛ. Uu pɛpɛɛ siwóó n cɔhɔnɛ ɑtɑɑpili nɛ pilɔ́ɔlɑ̃yɑ́i situmpi lɑ́uli. ");
INSERT INTO soy_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Uu pɛɛ pi mɑɑ rɛ: Li wɔlɑɑlɛ̃ tɛ: Pi yɛ́ Kɛnɛ́yɔ sée rɛ kɛyómɛyɑ́hɑɑyɔ. Amɑ́ nɔ̃́ nɛ kɛ ripɔ́lɔ́sɛlɛ piyɑɑlukɛ kuhorɛ. ");
INSERT INTO soy_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Kɛ Yeesu uu kei lɛ̃ ń we, pinyíyɛ nɛ síkɑnkɑ́lɑ́kɑ́ ɑsí hɑpɔ ɑsí nɛ Uléécɑɑ kɛyɔ kɛ́mɛɛ u kɔ uu si pɔisɛntɛ. ");
INSERT INTO soy_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Amɑ́ kɛ pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ nɛ isé picélɑɑ ɑpi mɛwɑi píimɑ kɛ Yeesu uu n wɑpisi n yɛ̃́ nɛ siwɑ̃́ sɛɛ Uléécɑɑ kɛyɔ kɛ́mɛɛ n cɑ́ɑ́i rɛ: Osɑnnɑ, Tɑfiti Kɛpipi, ɑi pi tóósi. ");
INSERT INTO soy_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Kei kɑpi pɛɛ u pisɛ rɛ: Pɔ kómɛi lɛ̃ kɑpi nní n cɑ́ɑ́ii? Yeesu uu rɛ: Ɛɛɛ. Uu pɛɛ pi pisɛ rɛ: Lɛ̃ nnyɑ, ɑ́ni kɑhɑnɛ Uléécɑɑ ritɛlɛ́ kɛ́mɛɛ nsímɛ́ mmú n kɛɛ̃ tɛ: Pɔ tíyɛsɛ ɑí nɛ siwɑ̃́ síńsɑ́pi nɛ siwɑ̃́ fɛnfɛ̃í pɛ́nɛ ɑsi pɔ́ m pɑkɑrɛntɛɛ? ");
INSERT INTO soy_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yeesu uu pɛɛ limɛmɑ́ɑ́ kei pi yɑ́ uu kuyu lelu uú hɑ Petɑnii-pɔ finɛ. ");
INSERT INTO soy_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kɑi n weesi, Yeesu uu yisi un Yerusɑlɛm tɔ́su, nkṹ nn u wɑi. ");
INSERT INTO soy_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Uu kúfikiyee ricéetimɛ yɛnupɔ, uu sɔ́nɛpɔ uú nɛ ku kɔ, ɑmɑ́ mɛpɛ́i ŋmɑnɛ kuu lɛɛpɔ. Uu pɛɛ kuléé kpɛ̃ mɑɑ rɛ: Pɑ́ɑ nkpéni kɔ píkɑi mɑ́runɛ! Kei nní, kúfikiyee kpɛ̃ ɑku kóósi. ");
INSERT INTO soy_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kɛ upipirɛtiki ɑpi lɛ̃ n yɛ̃́, ɑi nnɔ́ɔ pi yipu ɑpi pɛɛ rɛ: Íye kɛ kúfikiyee nkú ɑku nní mɛsɛ nɛ mɛsɛ kólɑɑpɔ? ");
INSERT INTO soy_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yeesu uu pɛɛ pi mɑɑ rɛ: Kɛ́ ɑsei kɛcɑ́ɑ́ nɔ́ símisi rɛ nɔn Uléécɑɑ nɛ kɛfɑ n tɛnɛlɛ̃ nɔnsɑ́ kɔ n tíru, nɔ́ fe ɑni lɛ̃ kɑm nní kuléé nkú n wɑ mɛcɔ wɑi. Ái kɔ lɛ̃ ŋmɑnɛ, ticuruu, nɔ́ fe ɑni riyɔ́pɛ ntí mɑɑ rɛ: A kei yisi ɑ hɑ mínimɑɑ-i ripɔlɔ, ɑi kɔ mɛsei lɛ̃ wɑi. ");
INSERT INTO soy_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nɔn Uléécɑɑ nɛ kɛfɑ n tɛnɛlɛ̃, nɔ́ yɛ lɛ̃ nnɛ́í kɑni yɛ kɛyómɛyɑ́hɑɑ-i m pisɛ yɛ̃. ");
INSERT INTO soy_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Lɛ̃ mɛmɑ́ɑ́, Yeesu uu pɛɛ Uléécɑɑ kɛyɔ-i lompɔ un we un pisoi céési, pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ nɛ kuyu piwɛ́ɛ́sɛ ɑpí hɑpɔ ɑpí nɛ u kɔ ɑpi u pisɛ rɛ: Ńnɑŋɛ ń-ye kɑɑ́ nɛ nní wɑi? Úye yɛɛ ńnɑŋɛ pɔ́ hɛ pɔkɛ́ nɛ nní n wɑi? ");
INSERT INTO soy_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yeesu uu pɛɛ pi pɛsɛ rɛ: Nɛ lɑ kɛ́ nsɛ nɔ́ pisɛ. Nɔn tinɔ́ɔ nɛ́ m pɛsɛ, nɛ́ pɛɛ nɔ́ símisi ńnɑŋɛ mmɛ̃ kɑḿ nɛ lɛ̃ n wɑi. ");
INSERT INTO soy_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Nɛ lɑ kɛ́ nɔ́ pisɛ rɛ wóo Yohɑni tummɛ rɛ ukɛ́ pisoi míni wolɛ? Uléécɑɑ nɛ́ɛ pisoi pɛɛ u tummɛ? Api pɛɛ símɑɑnɛ rɛ: Tɔn nkpéni m mɑɑ rɛ Uléécɑɑ yɛɛ u tummɛ, u yɛ́ rɔ́ pisɛ rɛ: Kɑi pɛɛ íye wɑ kɑ́ni nɛ Yohɑni nsímɛ́ ŋmurɛi? ");
INSERT INTO soy_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Tɔn kɔ m mɑɑ rɛ pisoi pɛɛ u tummɛ, ɑ́i yɛ́ wɑ. Tɔ pɛɛ risoiwuí wurulɛ. Li we rɛ pisoi nnɛ́í yɛ Yohɑni nyɑ́nilɛ rɛ ɑntepu lo. ");
INSERT INTO soy_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Api pɛɛ mɛsɛ Yeesu rinɔ́ɔ pɛsɛ rɛ: Ári nyu. Uyɛ̃ uu kɔ pi pɛsɛ rɛ: Nɛ̃́ ɑ́m kɔ nɔ́ símisinɛ ńnɑŋɛ mmɛ̃ kɑḿ nɛ lɛ̃ n wɑi. ");
INSERT INTO soy_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yeesu uu kɔ pipisɛ pi kpɑ́ rɛ: Ń-ye kɑni kɛnyɑ́rũ nkɛ́-i yɛ̃́? Pi rɛ utisi unyinɛ yɛɛ pɛɛ piŋmɑ́nɛ pitɛ́ mɑ́, uu kɛyɑ́ɑ uŋmɑ́nɛ wɛ́ɛ́sɛ mɑɑ rɛ: Unɛ́ŋmɑ́nɛ, ɑ nɛni wɑɑsi ɑ hɑ ɑnɛ́léé nyɛ̃ kɑpi yɛ n sée rɛ fiinyi kɛcɑrɛ kɛ́mɛɛ kɛisi. ");
INSERT INTO soy_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Uŋmɑ́nɛ uu u pɛsɛ rɛ: Ám sĩ! Kɑi rinkpɑ́sɛ, uu kɛmúŋɛ́ consɛ, uu yisi uu wɑɑsi. ");
INSERT INTO soy_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Utisi uyɛ̃ uu kɔ uŋmɑ́nɛ tɔrɔɔ limɛcɔ mɑlɛ. Uyɛ̃ uu rɛ: Ɛɛɛ, nɛ kõ, Sɑ́ɑ. Amɑ́ úu pɛɛ nkpɑ́ni wɑɑsi. ");
INSERT INTO soy_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Yeesu uu pɛɛ pi pisɛ rɛ: Nɔ músu rɛ wóo pikɛtɛ́ kɛcɔpɛ usɑ́ɑ mɛlɑ wɑ? Api rɛ ufoí lo. Yeesu uu pɛɛ pi mɑɑ rɛ: Asei kɑm nní nɔ́ símisi rɛ pilɑmpooyɔɔ́ nɛ piwɑ́sɑ́nkɑí yɛ́ nɛ kɛkpéẽ nɔ́ wɑ ɑpi Uléécɑɑ iyɔɔpi kɛ́mɛɛ lompɔ. ");
INSERT INTO soy_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Li we rɛ Yohɑni Úniwolɛ yɛ nɔ́kɛnɛ́mɛɛ kɑlɛ uu ɑsei ncee nɔ́ nyísɛ, ɑ́ni nɛ kutu u ricɔ. Amɑ́ pilɑmpooyɔɔ́ nɛ piwɑ́sɑ́nkɑí ɑpi unsímɛ́ ŋmurɛi. Ani kɔ lɛ̃ nnɛ́í yɛ́nu, ɑmɑ́ ɑ́ni mɛfinɛ consɛ nɔkɛ́ unsímɛ́ ŋmurɛi. ");
INSERT INTO soy_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yeesu uu pimɑ́ɑ pi kpɑ́ rɛ: Ani kɔ kɛnyɑ́rũ kɛcɔ kutu ricɔ: Ucɑrɛte unyinɛ yɛɛ we, uu ɑléé nyɛ̃ kɑpi yɛ n sée rɛ fiinyi kɛcɑrɛ tɑmɛsi, uu mmɛlɛ wɑi uú nɛ kɛ kɔ́ɔ́nú. Uu kɔ kɛcɑrɛ kɛ-i kuhórɛ túni uu kɛ́tɑcɛrii mɔm kei kɑpi yɛ́ pítɑ n cɛ́rii. Uu kɔ limɛmɑ́ɑ́ kɛmɛ́rɛ́ cɑ́cɑ́ kɛnyinɛ mɔm uu pɛɛ pikɛikɔ́ wɛ́ɛ́si rɛ pikɛ́ kɛcɑrɛ kɛ̃ kɛcɑ́ɑ́ u m pɑílɛ̃ ukɛ́ ncée hɑ ukɛ́ kɑm. ");
INSERT INTO soy_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Kɑi ɑléépipi nyɛ̃ kutúũ n tu, uu upilɑsi yukusɛ rɛ pikɛ́ hɑ upikɛikɔ́ pɛ-i uɑléépipi u yɔ́ɔmɛ. ");
INSERT INTO soy_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pikɛikɔ́ pɛ̃ ɑpi pilɑ́si mpí cɔ́pii. Api usɛ kɑii ɑpi ucɔ kopu, ɑpi utɑ́ɑ́nũ ɑpɑrɛ tɑpisi uu kpi. ");
INSERT INTO soy_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ucɑrɛte uu kɔ pilɑ́si picɔ piyukusɛ kpɑ́, pɛ̃ pin kulúi we nɛ pifoí. Pikɛikɔ́ pɛ̃ ɑpi kɔ pɛ̃ wɑi yɑrɛ lɛ̃ kɑpi pilɑ́si foí n wɑ mɛcɔ. ");
INSERT INTO soy_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Uu picérei pɔɔnɛ uu uuŋmɑ́nɛ yukusɛ uu pikɛmɛɛ tum, un músu rɛ: Ḿpɑ́ likɛ́ íye wɑ, pi yɛ́ unɛ́ŋmɑ́nɛ wuri. ");
INSERT INTO soy_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Amɑ́ kɛ pikɛikɔ́ ɑpi uuŋmɑ́nɛ uyɛ̃ n yɛ̃́, ɑpi pimɛcɔpɛcirɛ n tee rɛ: Nkó yɛɛ mɑsí usɑ́ɑ mɛmɑ́ nnɛ́í te. Ani kɑm tɔkɛ́ u kpu tɔkɛ́ pɛɛ umɛmɑ́ n te. ");
INSERT INTO soy_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Kuu n tuipɔ, ɑpi u tini ɑpi kɛcɑrɛ ilúkɛ́ u sɑ́ ɑpi u kopu. ");
INSERT INTO soy_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Kɛ Yeesu uu pinyɑ́rũ ḿ mɑsí, uu pi pisɛ rɛ: Ucɑrɛte uyɛ̃ un hɑ n kɑ, yo kuu yɛ́ pikɛikɔ́ pɛ̃ wɑ? ");
INSERT INTO soy_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Api rinɔ́ɔ u yɔ́su rɛ: U pikɛikɔ́ kpɑ́kɑ́rɑ́ pɛ̃ mɛkópɛ kóninɛ. Pilicɔ ɑ́i yɛ́ nkpɑ́ni íwɛ u wɑ. Uu pɛɛ́ hɑ pikɛikɔ́ féé forii rɛ pikɛ́ kɛcɑrɛ kɛcɑ́ɑ́ u m pɑílɛ̃, ɑpipi ɑn m pi, ɑpi yɛ u túúni. ");
INSERT INTO soy_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Kei kɛ Yeesu uu pi pisɛ rɛ: Áni nsímɛ́ mmú píkɑi Uléécɑɑ Nsímɛ́ ritɛlɛ́ kɛ́mɛɛ kɛ́ɛ́nlɛ̃ tɛ: Tipɑrɛ kɛ pimɔ́mɛ ɑpi n fóm tɛɛ pɑnsɛ ricírɛ-cirɛ tɛɛ kɛnui-i ń wee? Upíimɑ yɛɛ lɛ̃ wɑ. Mɛwɑisɑŋɑ kuu rɔ́ n yɛ́nɛisɛ yɛ mɛ̃! ");
INSERT INTO soy_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yeesu uu kɔ pimɑ́ɑ pi kpɑ́ rɛ: Lɛ̃ nnyɑ, nɔ́ mpí, nɔ́ɔ nní Uléécɑɑ iyɔɔpi kɛ́mɛɛ ń we, pi yɛ́ ikɛmɛɛ nɔ́ lesɛ ɑpi mpuri féé mɛɛ Uléécɑɑ mɛlɑ n wɑi tonsɛ. ");
INSERT INTO soy_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Lin úye n fóm un tipɑrɛ tɛ̃ tinkpɔu, u yɛ́ selesi. Lin úye n fóm tin ukɛcɑ́ɑ́ n loó, ti yɛ́ u nɑ̃. ");
INSERT INTO soy_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Kɛ pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ nɛ Pifɑrisi ɑpi Yeesu sinyɑ́rũ sɛ̃ n kṍ, ɑpi céru rɛ pɛ̃ kuú nɛ mɑ́nɛ. ");
INSERT INTO soy_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Api pɛɛ icée n wɛ́ɛ́si pikɛ́ nɛ u tĩ, pin kɔ pɛɛ risoiwuí wuru rɛ pisoi yɛ u nyɑ́ni rɛ u ɑntepu lɛ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yeesu uu kɔ kɛnyɑ́rũ kɛcɔ pi kpɑ́ rɛ: ");
INSERT INTO soy_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Uléécɑɑ iyɔɔpi yɛ kɔ we yɑrɛ nsímɛ́ mmú: Uyɔ́ɔpi unyinɛ yɛɛ kɛyɑ́ɑ uuŋmɑ́nɛ yɛɛ unɔ́si n kpísi ɑnyɑ̃́ píimɑ wɑi. ");
INSERT INTO soy_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Uu upikɛikɔ́ tum tɛ pikɛ́ hɑ pisoi séleimɛ pikɛ́ ɑnyɑ̃́ ilukɛ li. Amɑ́ pisoi ɑpi isɑ́nɛséi iyɛ̃ yulu ɑpi ɑnyɑ̃́ wéntɛ. ");
INSERT INTO soy_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Uu kɔ pikɛikɔ́ picɔ pitumɛ kpɑ́ uu pi mɑɑ rɛ: Ani pisɑ́nɛ sée ɑni pi símisi rɛ: Anyɑ̃́ ilukɛ yɛ pipele mɑsilɛ. Anɛ́nɑ́ɑlɑ nɛ inɛ́sɛɛ kpɔkɔɔ́ kɑm kṍ. Ḿpɑ́ yo yɛ kɛ́yu wɑlɛ. Ani kɑm ɑni pinɔ́sikpikɛ́ ɑnyɑ̃́ ilukɛ li. ");
INSERT INTO soy_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ápi nkpɑ́ni isɑ́nɛséi iyɛ̃ kutu ricɔ. Ḿpɑ́ úye uu ulikɔ́-mɛ̃ tɔ́mpɔ. Picɔ ɑpi sicɑrɛ wɑikɛɛ, picɔ ɑpi ɑyɑ́ɑ tɔ́ŋɑɑpɔ ");
INSERT INTO soy_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","pitɔ́rɔɔ pɔ́ɔ pikɛikɔ́ pɛ̃ cɔ́pii ɑpi isɛi pi wɑisɛ ɑpi pɛɛ pi kóni. ");
INSERT INTO soy_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ai uyɔ́ɔpi kuwɔ́i wɑi, uu upisɔ́ɔ́cɑ tum ɑpí hɑ pisoi pɛ̃ kóni ɑpi pikuyu nnɑ ŋmɑɑsi. ");
INSERT INTO soy_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Uu pɛɛ upikɛikɔ́ picɔ mɑɑ rɛ: Anyɑ̃́ ilukɛ yɛ pipele mɑsilɛ, ɑmɑ́ pisɑ́nɛ ɑ́pi pɛɛ ikulukɛ tulɑɑlɛ̃. ");
INSERT INTO soy_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Lɛ̃ nnyɑ, ɑni sicéepɛnɛ-i léepɔ, nɔn píye n yɛ̃, ɑni kusɑ́nɛ pi séiri. ");
INSERT INTO soy_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Upikɛikɔ́ pɛ̃ ɑpi yisi ɑpi icée tóói ɑpi pisoi nnɛ́í kɑpi n yɛ̃́ sélei, pisɔnɛ nɛ pikópɛ, pisɑ́nɛ ɑpi pɛɛ kɛnyɑ̃́yɔ yipu. ");
INSERT INTO soy_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Kei kɛ uyɔ́ɔpi uu pɛɛ lompɔ rɛ ukɛ́ pisɑ́nɛ pɛ̃ yɑ́ɑ́si, uu usoi unyinɛ yɛnu yɛɛ úu inyɑ́nlũ n tɑnɑɑlɛ̃. ");
INSERT INTO soy_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Uu u pisɛ rɛ: Unɛ́sɑ́nɛ, íye kɑɑ wɑ ɑɑ́ nɛ nté lonti ɑ́ɑ kɔ inyɑ́nlũ tɑnɑɑlɛ̃? Ai utisi muuni uú n sɛ́ɛ́lɛ̃. ");
INSERT INTO soy_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Uyɔ́ɔpi uu pɛɛ pikɛikɔ́ mɑɑ rɛ: Ani ɑ́nɑ nɛ ɑnípɛ u pɑɑsi ɑni kɛtɑhɑi kuŋmɑhɑ-i u sɑ́pɔ. Kei kuu yɛ́ n téni un inĩ́ tɑkɑi. ");
INSERT INTO soy_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yeesu uu pɛɛ rɛ: Li we rɛ pisoi kulúi kɑpi sée, ɑmɑ́ pɛ̃ kɑpi pikɛcɔpɛ n wɛ́ɛ ɑ́pi pɛɛ kulúi we. ");
INSERT INTO soy_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Kei kɛ Pifɑrisi ɑpi pɛɛ símɑɑnɛ rɛ íye kɑpi yɛ́ nɛ Yeesu ripinɛ wɑ pikɛ́ nɛ unnɔɔsimɛ́ cirɛ u n tĩ́. ");
INSERT INTO soy_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Api pipirɛtiki pinyinɛ nɛ Erooti pipirɛtiki pinyinɛ lesɛ ɑpi tum tɛ pikɛ́ hɑ Yeesu mɑɑ rɛ: Upíimɑ, tɔ nyulɛ rɛ ɑsei ŋmɑnɛ kɑɑ yɛ símisi. Pɔ yɛ kɔ Uléécɑɑ ncee pisoi céesilɛ nɛ ɑsei. Ḿpɑ́ usoi ukɛ́ íye nsɑ́ ńnɑŋɛ m mɑ́, ɑ́ɑ yɛ uinipɛɛ n wuru pɔn nɛ símisi. ");
INSERT INTO soy_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Tɔ lɑ rɛ ɑ kɛpɔ́múŋɛ́ rɔ́ símisi tɔkɛ́ yɛ̃́ tɛ ncée yɛ we rɛ tɔkɛ́ yɛ Rɔm uyɔɔpi lɑmpoo hɛ́ɛ́lɛ nɛ́ɛ ɑ́ri kɑpɛ yɛ hɛ́ɛlɛ? ");
INSERT INTO soy_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Amɑ́ Yeesu pɔ̃́ nɛ pimɛsɔhɔ kópɛ kɑpi n wɑi pinyuwɛ mɑ́ɑ́lɛnlɛ. Uu pɛɛ pi mɑɑ rɛ: Nɔ́ kɛcɑ́ɑ́ kɛcɑ́ɑ́ mɛwɑi pikɔ́ mpí, yo nnyɑ kɑni nɛ́ peikɛɛ? ");
INSERT INTO soy_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ani nɛ siwóó sɛ̃ kɑni yɛ nɛ lɑmpoo n hɛ́ɛlɛ kɑm nkɛ̃́! Api mɛwóópipi mɛsɛ nɛ u hɑpɔ. ");
INSERT INTO soy_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Uu pɛɛ pi pisɛ rɛ: Úye riyu nɛ úye rinyiri tɛɛ nní mɛkɛcɑ́ɑ́ we? ");
INSERT INTO soy_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Api u pɛsɛ rɛ: Sesɑɑ lo. Kei kɛ Yeesu uu kɔ pi mɑɑ rɛ: In lɛ̃, ɑni Sesɑɑ likɔ́ Sesɑɑ pɑ, ɑni Uléécɑɑ likɔ́ Uléécɑɑ pɑ. ");
INSERT INTO soy_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Kuu lɛ̃ tinɔ́ɔ tɛ̃ pi m pɛsɛ, ɑi nnɔ́ɔ pi yipu ɑpi pɛɛ u yɑ́ ɑpi tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Kɛyɑ́ɑ kɛ̃ cirɛ kɛ Pisɑtusee ɑpi Yeesu kɛ́mɛɛ hɑ. Pisɑtusee pɛɛ tee rɛ pikpɔkpɔ ɑ́pi yɛ nkpɔ-i yisi. Api sĩ́ ɑpí hɑ Yeesu lɛɛpɔ, ɑpi u pisɛ rɛ: Sɑ́ɑ, Moisi yɛ mɑɑ rɛ: ");
INSERT INTO soy_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Unɔ́sikɔ́ úye un n kpu unsɑ́ kɛwɑ̃́ m mɑ́, li pisɛ rɛ uuwɑ̃ yɛɛ yɛ́ unɔ́si uyɛ̃ kukúmɑnnɔsi kpísi uu umɑ́ɑ mpuri wɑi. ");
INSERT INTO soy_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Too! Amɑ́ piŋmɑ́nɛ pinyinɛ pɛɛ pɛɛ kɛrɔ́cɔpɛ nté we. Pi pimɑ́rɛcɔ pisɛɛi lɛ. Umɑ́ɑ uu unɔ́si kpísi, uu kpi úu kɛwɑ̃́ yɛ̃. Uwɑ̃́ uu pɛɛ umɑ́ɑ ukúmɑnnɔsi kpísi. ");
INSERT INTO soy_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Uyɛ̃ uu kɔ limɛcɔ kpi, uu ukúmɑnnɔsi uyɛ̃ nɛ utɑ́ɑ́nũ yɑ́. Ai lɛ̃ n wɑi hɑ́i nɛ usɛ́ɛ́i-sɛ́ɛ́i kɛ́mɛɛ-pɔ. ");
INSERT INTO soy_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Pɛ̃ mɛmɑ́ɑ́, unɔ́si uyɛ̃ pɔ́ɔ kɔ kpi. ");
INSERT INTO soy_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Tɔ lɑ tɔkɛ́ nkpéni pɔ́ pisɛ rɛ kɛ pimɑ́rɛcɔ pisɛɛi pɛ̃ ɑpi nní pinnɛ́í unɔ́si uyɛ̃ n kpísi, pi uye unɔsi yɛ hɑ lo, kɛyɑ́ɑ kɛ̃ kɛ pikpɔkpɔ ɑpí hɑ nkpɔ kɛ́mɛɛ n yisinɛ? ");
INSERT INTO soy_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Kei kɛ Yeesu uu pɛɛ pi pɛsɛ rɛ: Lɛ̃ nnyɑ kɑni nɔ́mɛnɛ́círɛ kirɑɑsɛntɛ. Áni Nléécɑɑsimɛ́ ɑsei kómɛi, ɑ́ni kɔ Uléécɑɑ nnɑŋɛ nyu. ");
INSERT INTO soy_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kumúŋɛ́ kpɛ-i kɛ pikpɔkpɔ ɑpí hɑ n yisinɛ, pitisi ɑ́pi pinɔ́si kpíkɛsinɛ, pinɔ́si pɑ́ɑ kɔ pilɑ sɔ́ɔnkɛɛnɛ. Amɑ́ pimɛfinɛ yɛ́ hɑ n we yɑrɛ piléécɑɑtumɛ kɛyómɛcɑɑ-pɔ. ");
INSERT INTO soy_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Áni lɛ̃ kɛ Uléécɑɑ uu pikpɔkpɔ mɛyisɛ kɛcɑ́ɑ́ nɔ́ ḿ mɑ ɑpi Unsímɛ́ Ritɛlɛ́ kɛ́mɛɛ wɔ́lu kɛ́ɛ̃, nɛ́ɛ yo? U mɑɑ rɛ: ");
INSERT INTO soy_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Nɛ́ɛ Apirɑhɑm Uleecɑɑ nɛ Isɑɑki Uleecɑɑ nɛ Yɑkupu Uleecɑɑ. Uléécɑɑ úu pikpɔkpɔ Uleecɑɑ ɑmɑ́ u pinyɑ́nnyɑ̃́ Uleecɑɑ lɛ. ");
INSERT INTO soy_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Kɛ pisoi pɛ̃ nnɛ́í pɛɛ n cɑ́pinɛlɛ̃ pin kutu u cɔlɛ̃ ɑpi lɛ̃ n kṍ, uicélɑɑ iyɛ̃ ii pi loni ńsɔnɛ. ");
INSERT INTO soy_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Kɛ Pifɑrisi ɑpi n kṍ tɛ Yeesu yɛ Pisɑtusee feriyɛ uu sɛ́ɛ́sɛ, ɑpi cɑ́pinɛ. ");
INSERT INTO soy_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Pikɛcɔpɛ isé ucélɑɑ unyinɛ uu pɛɛ ripinɛ Yeesu wɑi uu u pisɛ rɛ: ");
INSERT INTO soy_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Ucélɑɑ, Uléécɑɑ iseé nnɛ́í kɛ́mɛɛ íye yɛɛ imɑ́ɑ? ");
INSERT INTO soy_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yeesu uu rɛ: A Upíimɑ, Upɔ́léécɑɑ n lɑ nɛ kɛpɔ́fɑ nnɛ́í, nɛ ipɔ́soi nnɛ́í, nɛ kɛpɔ́múŋɛ́ nnɛ́í. ");
INSERT INTO soy_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Iyɛɛ isé foí, iyɛɛ kɔ innɛ́í kɛcɔpɛ imɑ́ɑ. ");
INSERT INTO soy_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ilírũ yɛɛ ifoí iyɛ̃ mɛcɔ n sɑ́ yɛ nnyí: A upɔ́cɔ n lɑ yɑrɛ kɑɑ ripɔ́cúruu ń lɑ. ");
INSERT INTO soy_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Isé nnyí kɛtɛ́ yɛɛ isé nɛ ɑntepuyɛ icélɑɑ riyíkí. ");
INSERT INTO soy_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Kɛ Pifɑrisi ɑpi lɛ̃ n cɑ́pinɛ, Yeesu uu pɛɛ pi pisɛ rɛ: ");
INSERT INTO soy_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Íye kɑni uyɛ̃ kɛ Uléécɑɑ uu n wɛ́ɛ kɛcɑ́ɑ́ músu? Úye kɛpipi yɛ kɛ? Api u pɛsɛ rɛ Tɑfiti Kɛpipi yɛ kɛ. ");
INSERT INTO soy_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yeesu uu pɛɛ pi mɑɑ rɛ: In lɛ̃, íye kɑi wɑ kɛ Nfɑ́ɑsɔnɛ nn Tɑfiti mɛtɛ́í hɛ uú nɛ u séi rɛ Upíimɑ? Tɑfiti yɛ pɛɛ́ mɑɑ rɛ: ");
INSERT INTO soy_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Upíimɑ yɛ Unɛ́píimɑ mɑɑ rɛ: A kunɛ́lukɛ-lukɛ-mɛ̃ kɛ́yukɔɔ́tonɛ-i tonɛ hɑ́i nɛ kumúŋɛ́ kpɛ-i kɑm yɛ́ pipɔ́lɑ́ɑrɔ kɛpɔ́nyɑ́lɛ-i n cɔ. ");
INSERT INTO soy_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","In tɛ Tɑfiti yɛ mɛsei u sée rɛ Upíimɑ, íye kɛ uyɛ̃ cirɛ uu yɛ́ kɔ pɛɛ Tɑfiti Kɛpipi? ");
INSERT INTO soy_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Pifɑrisi pɛ̃ ɑ́pi fe pikɛ́ ńkɑ Yeesu pɛsɛ. Kɑí nɛ kei n kpísi, úkɑ úu yɛ pɛɛ kɑhɑ ukɛ́ nnyinɛ u pisɛ. ");
INSERT INTO soy_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Lɛ̃ mɛmɑ́ɑ́, Yeesu uu pɛɛ pisoi pɛɛ n cɑ́pinɛlɛ̃ nɛ upipirɛtiki-mɛ̃ pɑnsɛpɔ uu pi mɑɑ rɛ: ");
INSERT INTO soy_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Isé picélɑɑ nɛ Pifɑrisi kɑí pɛɛ́ we rɛ pikɛ́ isé kɛ Moisi uu nɔ́ ḿ pɑ ɑsei nɔ́ símisi. ");
INSERT INTO soy_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Li nɛ sɑ́ rɛ nɔkɛ́ piicélɑɑ rimúlú ɑni kɔ i tiki. Amɑ́ ɑ́ni kɑpɛ yɛ pimɛwɑi nɛ yírɑɑnɛ. Li we rɛ pɛ̃ nɛ yɛ picɔ céesi rɛ pikɛ́ piicélɑɑ ritiki, ɑmɑ́ piricuruu ɑ́pi yɛ pɛɛ i ritiki. ");
INSERT INTO soy_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Pi yɛ limúlɛ-mulɛ pɑɑsilɛ ɑpi picɔ yɑsɛ, piricuruu ɑ́pi yɛ pɛɛ líkɑ ricɑ. ");
INSERT INTO soy_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Pi ḿpɑ́ yo wɑi rɛ pisoi pikɛ́ yɛ pi yɛ̃ nnyɑ. Lɛ̃ nnyɑ kɑpi yɛ Nléécɑɑsimɛ́ silɔɔpi kɑpi ritii kɛcɑ́ɑ́ riḿmɛɛlú mɛpɛ́rɛ́ rikpɑ́sɛ ɑpi kɔ pisitukɑnkɑ ɑtimɛ nwɛ́pí mɛpɛ́rɛ́ kpɑ́sɛ ɑi picɔ sikɔ́ feriyɛ. ");
INSERT INTO soy_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Sitónɛ foí kɑpi yɛ kɛlukɛ kɛ́mɛɛ nɛ Pisuifi ɑyomɛyɑ́hɑɑlee-i n lɑ. ");
INSERT INTO soy_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Pi lɑ rɛ pisoi pikɛ́ ipɑkɑrɛ nɛ pi n yɑ́hɑɑnkɛɛ sicɑ́pinɛ kɛ́mɛɛ, pikɛ́ yɛ kɔ pi sée rɛ picélɑɑ. ");
INSERT INTO soy_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Amɑ́ nɔ̃́ ɑ́ni kɑpɛ yɛ tíyɛ pikɛ́ yɛ nɔ́ sée rɛ picélɑɑ. Nɔ nɔ́nnɛ́nɛ́í pimɑ́rɛcɔ lɛ. Usoi usɛ kóló yɛɛ kɔ nɔ́unɛ́célɑɑ. ");
INSERT INTO soy_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Áni kɑpɛ yɛ kɛtẽ kɛcɑ́ɑ́ úkɑ sée rɛ nɔ́unɛ́sɑ́ɑ. Nɔ́unɛ́sɑ́ɑ cirɛníŋɛ kɑni m mɑ́ yɛɛ kɛyómɛcɑɑ-pɔ we. ");
INSERT INTO soy_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Áni kɑpɛ yɛ tíyɛ pikɛ́ yɛ nɔ́ sée rɛ úyukɔɔ́. Nɔ́unɛ́yukɔɔ́ yɛ usɛ lɛ. Uyɛɛ nní uyɛ̃ kɛ Uléécɑɑ uu n wɛ́ɛ. ");
INSERT INTO soy_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nɔ́kɛnɛ́cɔpɛ uwɛ́ɛ́sɛ ukɛ́ pɑnsɛ nɔ́unɛ́kɛikɔ́. ");
INSERT INTO soy_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Úye un umɛcirɛ rintɑɑ́sɛ, li yɛ u ricɛpisɛlɛ. Úye un umɛcirɛ rincɛpisɛ, li yɛ u ritɑɑ́sɛlɛ. ");
INSERT INTO soy_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Íwɛ kɑni topori, nɔ́ isé picélɑɑ nɛ nɔ́ Pifɑrisi mpí. Nɔ kɛcɑ́ɑ́ kɛcɑ́ɑ́ mɛwɑi pikɔ́ lɛ! Nɔ yɛ pisoi ncée tɑ́pisilɛ rɛ ɑ́pi kɑpɛ Uléécɑɑ iyɔɔpi kɛ́mɛɛ lõ. Nɔ́rinɛ́cúruu ɑ́ni yɛ lompɔ, ɑ́ni kɔ pɛɛ pɛpɛɛ ń lɑ yɑ́nɛ pikɛ́ lompɔ. ");
INSERT INTO soy_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Íwɛ kɑni topori, nɔ́ isé picélɑɑ nɛ nɔ́ Pifɑrisi mpí. Nɔ kɛcɑ́ɑ́ kɛcɑ́ɑ́ mɛwɑi pikɔ́ lɛ! Nɔ́ɔ pikúmɑnnɔsi ɑnipɛ-i lɛ̃ kɑpi m mɑ́ yɔ́ɔi, ɑni yɛ kɔ pɛɛ kɛyómɛ yɑ́ɑ́si ɑi nɑ́ŋɑi pisoi pikɛ́ nɛ nɔ́ n yɛ̃́ nnyɑ. Lɛ̃ nnyɑ kɛ Uléécɑɑ uu íwɛ iyɛɛ íi icɔ m mɑ́ nɔ́ wɑinɛ. ");
INSERT INTO soy_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Íwɛ kɑni topori, nɔ́ isé picélɑɑ nɛ nɔ́ Pifɑrisi mpí. Nɔ kɛcɑ́ɑ́ kɛcɑ́ɑ́ mɛwɑi pikɔ́ lɛ! Kɛtẽ nkɛ́ nnɛ́í nɛ mínimɑɑ kɑni kɑ́lɛ̃ tɛ nɔkɛ́ usɛ unyinɛ yɛ̃ nɔkɛ́ u pɑnsɛsɛ nɔ́unɛ́pirɛtiki. Nɔn liute piyɛ́nɛ m mɑsí, ɑni tíyɛsɛ uu pɑnsɛ usoi nkó kɑí nɛ n sɑ́ rɛ pikɛ́ íwɛ tɛnɛcirɛ́ kɛlõ kɛ́mɛɛ íwɛ lukɛisɛ ikɛ́ nɔ́inɛ́kɔ́ n fe mɛtɛ́. ");
INSERT INTO soy_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Íwɛ kɑni topori, nɔ́ pinyíyɛ mpí, nɔ́ɔ nní pisoicɔ n séni! Nɔ yɛ mɑɑ rɛ: Úye un Uléécɑɑ kɛyɔ n sée uú nɛ wééri rɛ u yɛ́ linyinɛ wɑ, u yɛ́ fe uu lipiwɑi yɑ́. Amɑ́ úye un wurɑ yɛɛ Uléécɑɑ kɛyɔ-i ń we n sée uú nɛ wééri rɛ u yɛ́ linyinɛ wɑ, ncée ńn we rɛ ukɛ́ lipiwɑi riyɑ́. ");
INSERT INTO soy_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Nɔ́ piníri nɛ pinyíyɛ mpí! Wurɑ nɛ Uléécɑɑ kɛyɔ kɛɛ wurɑ uyɛ̃ m pɑnsɛsɛ Uléécɑɑ likɔ́, yo yɛɛ likɛtɛ́ kɛcɔpɛ ríyu mɑ́ nɛ licɔ? ");
INSERT INTO soy_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Nɔ yɛ kɔ mɑɑ rɛ: Úye un Uléécɑɑ kɛyɔ kɛ́mɛɛ kɛnyɔ́ɔnsɛhúúpi n sée uú nɛ wééri rɛ u yɛ́ linyinɛ wɑ, u yɛ́ fe uu lipiwɑi yɑ́. Amɑ́ úye un inyɔ́ɔnsɛsɛɛ yɛɛ kɛhúúpi kɛcɑ́ɑ́ ń lɑ́ɑlɛ̃ n sée uú nɛ wééri rɛ u yɛ́ linyinɛ wɑ, úu ncée mɑ́ ukɛ́ lipiwɑi riyɑ́. ");
INSERT INTO soy_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Nɔ́ pinyíyɛ mpí! Isɛɛ kɑpí nɛ n nyɔ́ɔnsɛ ɑpi kɛhúúpi kɛcɑ́ɑ́ lɑ́ɑ nɛ kɛhúúpi kɛɛ i m pɑnsɛsɛ Uléécɑɑ likɔ́, yo yɛɛ likɛtɛ́ kɛcɔpɛ ríyu mɑ́ nɛ licɔ? ");
INSERT INTO soy_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Lɛ̃ nnyɑ, úye un kɛnyɔ́ɔnsɛhúúpi n sée uú nɛ wééri, kɛlõ kɛ̃ nɛ lɛ̃ nnɛ́í lɛɛ kei ń we kuu sée uú nɛ wééri. ");
INSERT INTO soy_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Úye un Uléécɑɑ kɛyɔ n sée uú nɛ wééri, Uléécɑɑ kɛyɔ nɛ Uléécɑɑ yɛɛ kɛkɛmɛɛ ń we kuu sée uú nɛ wééri. ");
INSERT INTO soy_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Úye un kɛyómɛcɑɑ n sée uú nɛ wééri, Uléécɑɑ riyɔɔpitũ nɛ Uléécɑɑ yɛɛ rikɛcɑ́ɑ́ ń tṹ kuu sée uú nɛ wééri. ");
INSERT INTO soy_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Íwɛ kɑni topori, nɔ́ isé picélɑɑ nɛ nɔ́ Pifɑrisi mpí. Nɔ kɛcɑ́ɑ́ kɛcɑ́ɑ́ mɛwɑi pikɔ́ lɛ. Nɔ yɛ ḿpɑ́ yo hɔɔnɛlɛ, ɑní nɛ mɑnti nɛ ɑyɛ́hɛpɛi ncɔpuri pɛ́nɛ ɑni hɔ́ɔ́nɛ ɑwɛ́lɛ́ kɛfi, ɑni Uléécɑɑ kuwɛ́lɛ́ kusɛ pɑ. Amɑ́ ɑ́ni yɛ pɛɛ isé nnɛ́í kɛcɔpɛ ipíimɑ yɑrɛ nní ɑsei piwɛ́lɑɑ nɛ usoicɔ piwɛtu nɛ ɑsei pitiki nkɔ́ nɛ pikɛi wɑ. Lɛ̃ kɑí pɛɛ pisɛ rɛ nɔkɛ́ n tikilɛ̃ nɔn pɛɛ kɔ nɛ litɔ́rɔɔ licɔ nní wɑi. ");
INSERT INTO soy_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Nɔ́ pinyíyɛ mpí, nɔ́ɔ nní pisoicɔ n séni. Nɔ yɛ kúcɛrii nɛ ńsɔ lesɛlɛ, ɑni pɛɛ ísu nɛ pɛ́nɛ ɑni muuni. ");
INSERT INTO soy_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Íwɛ kɑni topori, nɔ́ isé picélɑɑ nɛ nɔ́ Pifɑrisi mpí! Nɔ kɛcɑ́ɑ́ kɛcɑ́ɑ́ mɛwɑi pikɔ́ lɛ. Nɔ we yɑrɛ mpí pɛɛ yɛ kɛhee nɛ kɛcɑ́ripi kɛpirɛ ŋmɑnɛ n hɛɛrɛ ɑpi kɛmɛ́ɛ yɑ́ mɛcɔ. Lɛ̃ kɑpi yɛ sikɛmɛɛ n li nɛ kɑpi yɛ ń ntí yɛ pɛɛ liyɑɑ-yɑɑ lɛ kɑpi n kɑ́ipinkɛɛ. ");
INSERT INTO soy_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Nɔ́ Pifɑrisi, pinyíyɛ mpí! Ani yɛ kɛhee nɛ kɛcɑ́ripi kɛ́mɛɛ mɛfoí hɛɛrɛ, kɛpirɛ yɛ́ pɛɛ limɛcɔ sɔnɛsi. ");
INSERT INTO soy_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Íwɛ kɑni topori, nɔ́ isé picélɑɑ nɛ nɔ́ Pifɑrisi mpí! Nɔ kɛcɑ́ɑ́ kɛcɑ́ɑ́ mɛwɑi pikɔ́ lɛ. Nɔ we yɑrɛ rikpíí mmɛlɛ kɑpi míni tomɛ́ n túkɛi ɑri pɛɛ́ n wɑriyɛ póí-póí ńsɔnɛ mɛcɔ, nɛ́ḿpɑ́kɑnɛ ɑsoikɔhɔ nɛ líkpɛrinkpɛkɔɔ́ lɛɛ rikɛmɛɛ yipɑɑlɛ̃. ");
INSERT INTO soy_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Limɛcɔ kɑní we. Nɔ pisoi kɛyu-i nyísɛlɛ̃ tɛ nɔ isé tíkilɛnlɛ, nɛ́ḿpɑ́kɑnɛ kɛcɑ́ɑ́ kɛcɑ́ɑ́ mɛwɑi nɛ mɛwɑi kópɛ mɛɛ nɔ́sinɛ́fɑ-i yipɑɑlɛ̃. ");
INSERT INTO soy_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Íwɛ kɑni topori, nɔ́ isé picélɑɑ nɛ nɔ́ Pifɑrisi mpí! Nɔ kɛcɑ́ɑ́ kɛcɑ́ɑ́ mɛwɑi pikɔ́ lɛ. Nɔ yɛ ɑntepuyɛ ɑkpíí mɔ́nlɛ ɑni pɛpɛɛ ɑsei n tíkilɛ̃ ɑkɔ́ sɔnukusɛ ");
INSERT INTO soy_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ɑni pɛɛ rɛ: Tɔn pɛɛ pirɔ́kpurɛ isoi kumúŋɛ́ kpɛ-i n we, ɑ́ri yɛ́ pɛɛ ŋmurɛi tɔkɛ́ pi rikpɑ́ tɔkɛ́ nɛ ɑntepuyɛ kṍ. ");
INSERT INTO soy_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Nɔ pɛɛ lɛ̃ nyísɛlɛ ɑni nɔ́rinɛ́cúruu yɑ́mnɛ rɛ nɔ pɛpɛɛ ɑntepuyɛ n kṍ sipirɛ̃ lɛ. ");
INSERT INTO soy_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Lɛ̃ nnyɑ, ɑni mɛsɛ nɔ́pinɛ́kpurɛ mɛwɑi kópɛ nɛ kɛ́yu mɑhɑ̃ nɛ kɛ́tɔ-pɔ! ");
INSERT INTO soy_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Nɔ́ iwɑ́ɑ kpɑ́kɑ́rɑ́ nnyí! Íye kɑni yɛ́ wɑ ɑ́ni yɛ́ nɛ nnɑ tɛnɛcirɛ́ kɛ́mɛɛ n lompɔ. ");
INSERT INTO soy_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ani kõ tɛ nɛ́ ɑntepuyɛ nɛ pisoi pɛɛ mɛwɛ́ɛ́sɛsɔhɔ m mɑ́ nɛ isé picélɑɑ kɛcirɛ nɔ́ pɑ́mɛ. Nɔ́ picɔ kṍ, ɑni picɔ kunɑpɛ́ɛ́kɔɔ́ kɛcɑ́ɑ́ kɑrii, ɑni kɔ nɔ́ɑnɛ́yómɛyɑ́hɑɑlee-i picɔ isɛ́í súúkɛɛ, ɑni kɔ picɔ ḿpɑ́ kuyu kúye-i n tikilɛ̃ nɔn wéékusɛlɛ̃. ");
INSERT INTO soy_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Lɛ̃ nnyɑ kɛ pɛ̃ nnɛ́í kɑni n kṍ ɑ́pi kɔ líkɑ wɑ nkpɔ nń nɛ nɔ́ tɛnɛnɛ, kɑi n kpíimɛ usɔnɛ Apɛɛli kɛ́mɛɛ ɑí nɛ sĩ Perekiyɑ uŋmɑ́nɛ Sɑkɑrii kɑni Uléécɑɑ kɛyɔ kɛ́mɛɛ kɛlõ sɔnɛ nɛ kɛnyɔ́ɔnsɛhúúpi kɛpɑ́ɑ́pɑ́ɑ́ ń kpu kɛ́mɛɛ-pɔ. ");
INSERT INTO soy_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Kɛ́ ɑsei nɔ́ símisi rɛ nfɑ́ɑni pisoi mpí pɛɛ mɛwɑi kópɛ mɛ̃ ɑkpɑnii yɛnnɛ. ");
INSERT INTO soy_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Lɛ̃ mɛmɑ́ɑ́, Yeesu uu pɛɛ Yerusɑlɛm pikɔ́ mɑɑ rɛ: Nɔ̃́ Yerusɑlɛm pikɔ́, nɔ yɛ ɑntepuyɛ kónlɛ ɑni kɔ pɛ̃ kɛ Uléécɑɑ uu nɔ́kɛnɛ́mɛɛ n tummɛ ɑpɑrɛ tɑpisi ɑni kóni. Mɛlɛ́ kɛsẽ kɑḿ pɛɛ́ lɑ kɛ́ nɔ́ cɑ́pinɛ yɑrɛ kɛ kucɑ̃́yɑhɑ ɑku yɛ kuɑmɛ́ŋ́ mɛtene kusipipi n tɑ̃ líkɑ ɑ́i yɛ si wɑ mɛcɔ ɑni yúlu? ");
INSERT INTO soy_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Lɛ̃ nnyɑ, Uléécɑɑ kɛyɔ yɛ́ mɛŋmɑnɛ n we úkɑ úu yɛ́ n we. ");
INSERT INTO soy_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ani kõ tɛ ɑ́ni nɛni piyɛ́nɛ nɛ́ kpɑ́nɛ likɛ́ hɑ nɛ tu kumúŋɛ́ kpɛ-i kɑni yɛ́ hɑ ḿ mɑɑ rɛ: Uléécɑɑ ukɛ́ uyɛɛ Upíimɑ rinyiri nɛ n wemɛ rikpɑ́! ");
INSERT INTO soy_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yeesu uu pɛɛ Uléécɑɑ kɛyɔ-i léeri un tɔ́su. Kei kɛ upipirɛtiki ɑpi pɛɛ́ nɛ u rikɔ rɛ pikɛ́ kɛmɛmɔmɛ u nyísɛ. ");
INSERT INTO soy_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Amɑ́ Yeesu pɔ́ɔ pɛɛ pi pɛsɛ rɛ: Lɛ̃ nnɛ́í kɑni nní n nyɑ́ni, ɑsei kɛcɑ́ɑ́, li sɔ́nti likɛ́ wɑ ripɑrɛ ríkɑ ɑ́ri yɛ́ ricɔ kɛcɑ́ɑ́ n tɔsilɛ̃. Linnɛ́í mmú yɛ sɔ́ntilɛ likɛ́ fori tɛ́kɛ́-tɛ́kɛ́. ");
INSERT INTO soy_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yeesu uu pɛɛ sĩ́ uú hɑ Olifiyee rikúú kɛcɑ́ɑ́ tonɛ. Upipirɛtiki ɑpi kei u kɑ́lɑɑpɔ ɑpi u pisɛ rɛ: A rɔ́ símisi píyei kɑi lɛ̃ wɑinɛ, nɛ yo kɑri yɛ́ kɔ nɛ ceri rɛ mɛpɔ́pɛɛmɛ mɛɛ lɛ̃ tu rɛ kɛtẽ kɛtɔ yɛ kɛ̃. ");
INSERT INTO soy_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yeesu uu pi pɛsɛ rɛ: Ani nɔ́mɛnɛ́círɛ tĩ ńsɔnɛ, ɑ́ni kɑpɛ tíyɛ unyinɛ ukɛ́ kuyúi nɔ́ tɑ̃. ");
INSERT INTO soy_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Pisoi kulúi yɛ́ sɔ́nɑɑmɛ usɛ usɛ, ɑpi yɛ rinɛ́nyíri nɛ pisoi mɛyɑ̃ kirɑɑsɛntɛ ɑpi yɛ pi mɑɑ rɛ: Nɛ́ɛ uyɛ̃ kɛ Uléécɑɑ uu n wɛ́ɛ. Lɛ̃ kɛ́mɛɛ kɑpi yɛ́ pisoi kulúi kuyúi tɑ̃. ");
INSERT INTO soy_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nɔ́ kṍ tɛ ɑtɔpi yɛ nɔ́kɛnɛ́kúrí nɛ́ɛ kɛtɑɑ-pɔ wɑi, ɑmɑ́ ɑ́ni kɑpɛ nfɑsimɛ́ tónɛ. Lɛ̃ kɑi m pisɛ rɛ likɛ́ wɑ kɑi lɛ̃ wɑi. Amɑ́ kɛ́tɔ ɑ́kɛ kɑhɑnɛ n tu. ");
INSERT INTO soy_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Nsoipuri nnyinɛ yɛ́ yisi nn nsoipuri ncɔ nɛ tɔpu, kɛyɔ́ɔpitẽ ɑkɛ kɛyɔ́ɔpitẽ kɛcɔ nɛ tɔpu, nkṹ nn silõ sinyinɛ leeri, kɛtẽ ɑkɛ silõ sinyinɛ yeŋesi. ");
INSERT INTO soy_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Lɛ̃ nnɛ́í yɛ we yɑrɛ kɛ mɛmɑ́rɛnlõ ɑmɛ yɛ unɔ́si pikɛ́hɛ̃ n kórɑɑnɛ. ");
INSERT INTO soy_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Pɛɛ́ uyɛ-i kɛ pisoi ɑpi yɛ́ nɔ́ kpísi ɑpi nɔ́pinɛ́lɑ́ɑrɔ ɑnipɛ-i wɑi, ɑpi íwɛ nɔ́ wɑi ɑpi nɔ́ kóni. Isoipuri nnɛ́í ii kɔ nɛ̃́ nnyɑ nɔ́inɛ́puri yulu. ");
INSERT INTO soy_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kei kɑi yɛ́ pɛɛ pisoi mɛyɑ̃ nɛ kɛlólɛ́-mɛ̃ hɑ, ɑpi pɛɛ́ n yɑ́mnɛntɛnɛ, ɑpi pɛɛ ipuri n yúinnɛ. ");
INSERT INTO soy_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Antepuyɛ nɔɔmɛ kulúi yɛ́ léemɛ ɑpi pisoi mɛyɑ̃ kirɑɑsɛntɛ. ");
INSERT INTO soy_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Mɛwɑi kópɛ yɛ́ kɛ́yu mɑhɑ̃, pisoi mɛyɑ̃ nlɑ nn pɛɛ hɑ́su. ");
INSERT INTO soy_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Amɑ́ úye un tinkɑ́hɑ́-kɑ́hɑ́ nɛ kɛ́tɔ-pɔ Uléécɑɑ yɛ́ uriyu lɔ. ");
INSERT INTO soy_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Uléécɑɑ iyɔɔpi Nsímɛ́ Kɛcirɛ mɛɛ kɛtẽ nnɛ́í kɛcɑ́ɑ́ kɔ́ɔ́núnɛ isoipuri nnɛ́í ikɛ́ kṍ. Lɛ̃ mɛmɑ́ɑ́, ḿpɑ́ yo kɛtɔ ɑkɛ pɛɛ tulu. ");
INSERT INTO soy_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Yeesu uu kɔ pimɑ́ɑ pi kpɑ́ rɛ: Antepu Tɑniyɛɛli yɛ pɛɛ́ mɑɑ rɛ kumúŋɛ́ kunyinɛ yɛ́ kɑm ɑni ncɑɑi píimɑ mɛɛ yɛ n cɔ́kɔi yɛnu nn kɛlõ sɔnɛ riyíkí-i tṹ. Úye un nsímɛ́ mmɛ̃ n kɛɛ̃, ukɛ́ musí ukɛ́ liɑsei kõ. ");
INSERT INTO soy_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Lin lɛ̃ n wɑ, pɛpɛɛ Yutee kɛtẽ kɛ́mɛɛ ń we pikɛ́ wuri ɑpi ɑyɔ́pɛ tɑɑ́. ");
INSERT INTO soy_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Uyɛɛ yɛ́ hɑ kulee ipirɑɑ kɛcɑ́ɑ́ ń we, ukɛ́ wuri úu kɑpɛ rɛ ukɛ́ nkpɑ́ni kukɛmɛɛ lompɔ ukɛ́ linyinɛ kpísi ukɛ́ nɛ ripɛ́nɛ. ");
INSERT INTO soy_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Uyɛɛ kɛcɑrɛ-i ń we, úu kɑpɛ nkpɑ́ni rɛ ukɛ́ wurimɛ ukɛ́ kɛ́yɔ-i ukɛtukɑnkɑ kpísi. ");
INSERT INTO soy_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Íwɛ kɛ pifɑni nɛ pimɑ́rɛni ɑpí hɑ siyɑ́ɑ sɛ-i topori. ");
INSERT INTO soy_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ani nɛ Uléécɑɑ tẽ́ tɛ úu kɑpɛ tíyɛ itóó iyɛ̃ ikɛ́ nnyiyɛ kumúŋɛ́ nɛ́ɛ kɛwéntɛyɑɑ kɛtúŋɛ́ rɔ́ lɛɛmɛ. ");
INSERT INTO soy_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Íwɛ píimɑ iyɛ̃ kɛ sisoipipi ɑsi kumúŋɛ́ kpɛ-i n lenɛ icɔ íi píkɑi léémɛlɛ̃ hɑ́i kɛtẽ kɛkorɑɑnɛ-mɛ nɛ nɛni-mɛ, iicɔ íi kɔ píkɑi léeri. ");
INSERT INTO soy_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Uléécɑɑ unsɑ́ pɛɛ síwɛyɑɑ sɛ̃ n hɑsi, úkɑ úu yɛ́ pɛɛ nfɑ́ɑ yɛ̃. Amɑ́ pɛ̃ kuu n wɛ́ɛ nnyɑ, u yɛ́ siyɑ́ɑ sɛ̃ hɑsi. ");
INSERT INTO soy_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Lɛ̃ nnyɑ, úye un nɔ́ m mɑɑ rɛ: Ani ripɑí, nté kɛ Kirisi uú we nɛ́ɛ uyɛɛ nkó nté-pɔ ɑ́ni kɑpɛ ŋmurɛi. ");
INSERT INTO soy_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Pikirisi nɔɔmɛ nɛ ɑntepuyɛ nɔɔmɛ yɛ leerinɛ pikɛ́ mɛ́mɑrɛ píimɑ lesɛ pikɛ́ nyísɛ, pikɛ́ kɔ mɛwɑisɑŋɑ wɑpisi hɑ́i lin pɛɛ kufee n we, pin yɛ́ fe ricuruu ɑpi pɛ̃ kɛ Uléécɑɑ uu n wɛ́ɛ kirɑɑsɛ. ");
INSERT INTO soy_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ani léisɛ rɛ nɛ pisímɛ́ nɔ́ li mɑsilɛ. ");
INSERT INTO soy_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Lɛ̃ nnyɑ, pin nɔ́ m mɑɑ rɛ: Ani ripɑí, uyɛɛ nkó kucɛsi kóimɑ-i, ɑ́ni kɑpɛ hɑ. Nɛ́ɛ pin nɔ́ m mɑɑ rɛ: Ani ripɑí, uyɛɛ nkó kulee-i pékɑɑlɛ̃, ɑ́ni kɑpɛ ŋmurɛi. ");
INSERT INTO soy_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Yɑrɛ kɛ kɛkónɛtɛ́hɛ ɑkɛ yɛ nní kɛléécɑɑ-pɔ n léemɛ ɑkɛ mɛyéne mɛsɛ yɛɛ́ri kɛtuŋɛleemɛ-pɔ ɑkɛ́ nɛ sĩ kɛtuŋɛlolɛ́-pɔ, limɛcɔ kɛ Usoi Kɛpipi ɑkɛ sɔ́nti. ");
INSERT INTO soy_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Li we yɑrɛ kɑpi yɛ ḿ mɑɑ rɛ: Kei kɛ isɑrɛ kópɛ ii ń we, kɛ ɑ́yemeekú ɑɑ yɛ cɑ́pinɛ. ");
INSERT INTO soy_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Yeesu uu kɔ pimɑ́ɑ pi kpɑ́ rɛ: Síwɛyɑɑ sɛ̃ mɛtɔ́mpɔ kɛ ituŋɛ ií sɔmɑɑnɛ, iwɑ́rɛ ii mɛtɛ́í pɑɑ, ɑwɑ́rɛpi ɑɑ kɛyómɛcɑɑ-pɔ poroiri, linɑŋɛ-nɑŋɛ lɛɛ kɛyómɛcɑɑ-pɔ ń we ɑi mɛyɑ̃́ yeŋesi. ");
INSERT INTO soy_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Linyinɛ ɑi pɛɛ kɛyómɛcɑɑ-pɔ nyísɛ rɛ Usoi Kɛpipi yɛ nyɑhɑimɛlɛ. Kei kɛ kɛtẽ nnɛ́í kɛcɑ́ɑ́ isoipuri ii yɛ́ pɛɛ itu lõ. Api pɛɛ Usoi Kɛpipi yɛnu, kɛn ɑhopɛ kɛcɑ́ɑ́ wemɛ nɛ kɛnnɑŋɛ nɛ kɛmɛyɔɔpi. ");
INSERT INTO soy_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Api pɛɛ rinɑ́ɑtɔ́ŋ mɑɑ ténsɛ, uu pɛɛ upitumɛ kɛtẽ ɑwɛ́lɛ́ nnɛ́í kɛ́mɛɛ túmɛi. Api pɛ̃ kuu n wɛ́ɛkɛɛ kɛtẽ nkɛ́ nɛ kɛkɛtɔ-pɔ cɑ́pinɛ. ");
INSERT INTO soy_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Yeesu uu kɔ pimɑ́ɑ pi kpɑ́ rɛ: Ani kúfikiyee kɛnyɑ́rũ icélɑɑ kutu ricɔ. Ku yɛ kun ilésɛ ŋmṹ n wɑiri, mɛpɛ́i mɛn n leeri, nɔ yɛ mɛsɛ nɛ mɛsɛ ceri rɛ kupii yɛ nyɑhɑimɛlɛ. ");
INSERT INTO soy_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Limɛcɔ kɑí we. Nɔn píyei lɛ̃ nnɛ́í mmɛ̃ n yɛ̃ lin n wɑi, ɑni ceri rɛ Usoi Kɛpipi yɛ nyɑhɑimɛlɛ, un tinɔnɔɔ nɛ kɔlɛ̃. ");
INSERT INTO soy_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Asei kɑm símisi: Pisoi kunɑi nkú ɑ́ku tɔ́sunɛ kɛlenɛ, nní nnɛ́í likɛ́ nɛ ń kɑm. ");
INSERT INTO soy_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kɛtẽ nɛ kɛyómɛ yɛ́ tɔsí, ɑmɑ́ ɑnɛ́nɔ́ɔ ɑ́ɑ mɛtɔ́ŋɛ́ mɑ́. ");
INSERT INTO soy_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Yeesu uu kɔ pimɑ́ɑ pi kpɑ́ rɛ: Amɑ́ in kɛtẽ mɛtɛnɛ nkɔ́, úkɑ úu likɛyɑɑ kɛ̃ nɛ́ɛ liituŋɛ iyɛ̃ nyu, ḿpɑ́ piléécɑɑtumɛ pɛɛ kɛyómɛcɑɑ ń we nɛ́ɛ Uléécɑɑ Kɛpipi ricuruu. Amɑ́ Usɑ́ɑ mɛcirɛ yɛɛ nyu. ");
INSERT INTO soy_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Kumúŋɛ́ kpɛ-i kɛ Usoi Kɛpipi ɑkɛ́ hɑ m pɛɛri, li hɑ wɑinɛ yɑrɛ kɑi Nowee nfɑɑ kɛ́mɛɛ n wɑ mɛcɔ. ");
INSERT INTO soy_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Nní kɑí pɛɛ Nowee nfɑɑ kɛ́mɛɛ wɑ: Kɛyɑ́ɑ kɛ̃ kɛ míni ɑmɛ́ pɛɛ kɛtẽ nnɛ́í rińfɛ kɛkɛ́ kɛlenɛ n tu, pisoi yɛ pɛɛ́ welɛ pin le pin níru, pin sɔ́ɔnnɛ, pin pisipipi pilɑ nɛ pinɔ́si pɑsii hɑ́i nɛ kɛyɑ́ɑ kɛ̃ kɛ Nowee uu kutɑ́kɑi kɛ́mɛɛ n lompɔ. ");
INSERT INTO soy_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ápi nkpɑ́ni ńkɑ musí, míni ɑmɛ́ hɑ nɛ weri ɑmɛ pinnɛ́í muuni. Limɛcɔ kɑí hɑ wɑinɛ pɛɛ́ uyɛ-i kɛ Usoi Kɛpipi ɑkɛ́ hɑ m pɛɛri. ");
INSERT INTO soy_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Pitisi pitɛ́ yɛ́ likumúŋɛ́ kpɛ-i kɛcɑrɛ-i n we, ɑi usɛ kpíípɔ ɑi ucɔ yɑ́. ");
INSERT INTO soy_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Pinɔ́si pitɛ́ yɛ́ n we pin nɑm, ɑi usɛ kpíípɔ ɑi ucɔ yɑ́. ");
INSERT INTO soy_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Lɛ̃ nnyɑ, ɑ́ni kɑpɛ lɔpilɛ, li we rɛ ɑ́ni nyu kɛyɑ́ɑ kɛ̃ kɛ Nɔ́unɛ́píimɑ uu m pɛɛrinɛ. ");
INSERT INTO soy_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ani ńsɔnɛ kõ tɛ úyɔsɑɑ un yɛ pɛɛ́ n nyu ituŋɛ iyɛ-i kɛ uyɑɑ uu kɛsinɛ n sɔ́nɛpɔ, u yɛ́ɛ́ pɛɛ n nyɑ́nilɛ úu yɛ́ tíyɛ uyɑɑ ukɛ́ kɛ́yɔ-i lompɔ. ");
INSERT INTO soy_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Lɛ̃ nnyɑ, nɔ́ɔkɛ́ nɔ́mɛnɛ́círɛ mɛsɛ́rɛ n cɑ́pinɛlɛ̃ nɔn nɛ mɛ̃́. Kumúŋɛ́ kpɛ-i kɑ́ni nɛ m músu kɛ Usoi Kɛpipi ɑkɛ pɛɛri. ");
INSERT INTO soy_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Yeesu uu pɛɛ upipirɛtiki pisɛ rɛ: Wóo ukɛikɔ́ yɛɛ ɑsei n tíkilɛ̃ un kɔ mɛsɔhɔ mɑ́? Uyɛɛ ukɛikɔ́ uyɛ̃ kɛ úyɔsɑɑ uu yɛ nɛ kɛ́yɔ rin-yɑ́ rɛ ukɛ́ kɛ m pɑílɛ̃, uu yɛ upikɛicɔ ilukɛ ńsɔnɛ wɑi yɑrɛ kɑi m pisɛ. ");
INSERT INTO soy_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","In tɛ úyɔsɑɑ yɛ ukɛikɔ́ uyɛ̃ lɛɛmɛ un mɛsei upikɛi kɛcɑ́ɑ́ we, u únɑrɛkomɛ lɛ! ");
INSERT INTO soy_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Kɛ́ ɑsei nɔ́ símisi ɑni kóm tɛ úyɔsɑɑ uyɛɛ nɛ ulikɔ́ nnɛ́í uukɛikɔ́ yɑ́nɛ rɛ ukɛ́ likɛcɑ́ɑ́ m pɑílɛ̃. ");
INSERT INTO soy_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Amɑ́ in tɛ ukɛikɔ́ kópɛ lo, u yɛ́ ukɛfɑ-i mɑɑ rɛ: Unɛ́yɔsɑɑ úu mɛkɛɛ sɔ́nti. ");
INSERT INTO soy_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Uu pɛɛ upikɛicɔ ipépi loni, u nɛ pítɑpomɛ ɑpi pɛɛ́ n le pin níru. ");
INSERT INTO soy_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Kɛyɑ́ɑ kɛ̃ nɛ ituŋɛ iyɛ̃ kɛ ukɛikɔ́ uyɛ̃ úu nɛ m músu kɛ́mɛɛ kɛ uuyɔsɑɑ uú hɑ sɔ́nti. ");
INSERT INTO soy_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Kei kuu yɛ́ pɛɛ ukɛikɔ́ uyɛ̃ lɑkɑsɛ uu íwɛ u wɑi yɑrɛ kɑpi yɛ kɛcɑ́ɑ́ kɛcɑ́ɑ́ mɛwɑi pikɔ́ n wɑ mɛcɔ. Kei kuu yɛ́ n téni un inĩ́ tɑkɑi. ");
INSERT INTO soy_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yeesu uu kɔ upipirɛtiki pimɑ́ɑ kpɑ́ rɛ: Lɛ̃ nnyɑ, Uléécɑɑ iyɔɔpi yɛ́ hɑ n we yɑrɛ nsímɛ́ mmú: Pikpére kɛfi pinyinɛ pɛɛ kɛyɑ́ɑ yisi rɛ pikɛ́ uŋmɑ́nɛ unyinɛ yɛɛ pinɔ́sikpikɛ́ ń lɑ mɛrí. Api sífirɑ́ɑ kpíkɛsi ɑpí nɛ pɛ́nɛ. ");
INSERT INTO soy_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Pikɛcɔpɛ pinupũ pɛɛ piníri, pinupũ picɔ pisɔhɔɔ. ");
INSERT INTO soy_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Kɛ piníri mpí ɑpi pisifirɑ́ɑ n kpísinɛ, ɑ́pi simɛkpɔ mɛ́kɑ mɛcɔ iyɑɑ wɑ pikɛ́ nɛ ripɛ́nɛ, ");
INSERT INTO soy_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ɑmɑ́ pisɔhɔɔ pɔ́ɔ pisifirɑ́ɑ mɛ súúkɛɛ ɑpi kɔ mɛcɔ sinúḿpi-i wɑi ɑpí nɛ pɛ́nɛ. ");
INSERT INTO soy_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Kɛ uŋmɑ́nɛ uyɛ̃ uú nɛ pikɑ́mɛ n nɑ́ŋɑisɛ, nnɔ̃ nn pi yɑ́ɑ́i ɑpi lɔpilɛntɛ. ");
INSERT INTO soy_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Kɛ kɛsinɛ ɑkɛ m pi, kɛcɑ́ɑ́ilɑ ɑkɛ́ lelu rɛ: Uŋmɑ́nɛ uyɛɛ nní wemɛ! Ani leepɔ ɑni u tɛ́pɛi! ");
INSERT INTO soy_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Pikpére pɛ̃ nnɛ́í ɑpi yisi ɑpi pisifirɑ́ɑ pinyɔ́ɔnsɛntɛ loni. ");
INSERT INTO soy_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Piníri mpí ɑpi pɛɛ pisɔhɔɔ pɛ̃ mɑɑ rɛ: Ani nɔ́mɛnɛ́kpɔ mɛ̃ tɔ́ hɛ, sírɔ́firɑ́ɑ yɛ lɑlɛ sikɛ́ kpí. ");
INSERT INTO soy_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Pisɔhɔɔ pɛ̃ pɔ́ɔ rɛ: Eehei! Mɛ nɛ tɔ́ risɑ́lɛ, ɑ́mɛ tisɛ tɔkɛ́ nɔ́ hɛ. Li kutɔsi we nɔkɛ́ piyɑ́i kɛ́mɛɛ hɑ ɑni kei nɔ́mɛnɛ́kɔ́ lɔlu. ");
INSERT INTO soy_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Kumúŋɛ́ kpɛ-i kɑpi pilɑlɛ n tɔ́su, uŋmɑ́nɛ uyɛ̃ un tuiri, u nɛ pinupũ pɛpɛɛ pimɛcirɛ n cɑ́pinɛlɛ̃ pin nɛ u mɛ̃́ ɑpi kɛsẽ́ kulee kpɛ-i kɑpi pinɔ́sikpikɛ́ ɑnyɑ̃́ n wɑi loni, ihɑ́nɑɑ ii hɑ́nɑɑpɔ. ");
INSERT INTO soy_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Likɛpirɛ, pikpére niri mpí pɔ́ɔ tuiri ɑpi cɑ́ɑ́i rɛ: Upíimɑ, ɑ rɔ́ hɑ́nnɛ! Upíimɑ, ɑ rɔ́ hɑ́nnɛ! ");
INSERT INTO soy_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Kei kɛ uŋmɑ́nɛ uyɛ̃ uu pi mɑɑ rɛ: Nɛ lɑ kɛ́ ɑsei nɔ́ símisi rɛ ɑ́m nɔ́ nyu! ");
INSERT INTO soy_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yeesu uu pɛɛ kpɑ́ rɛ: Lɛ̃ nnyɑ, nnɔ̃ ńn we. Li we rɛ ɑ́ni nyu kɛyɑ́ɑ kɛ́ye nɛ́ɛ ituŋɛ íye-i kɑm sɔ́nti. ");
INSERT INTO soy_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yeesu uu kɔ upipirɛtiki pimɑ́ɑ kpɑ́ rɛ: Uléécɑɑ iyɔɔpi yɛ́ hɑ n we yɑrɛ nsímɛ́ mmú: Utisi unyinɛ yɛɛ pɛɛ ncée pihɑ́pɛ lɑ, uu upikɛikɔ́ sélei uu umɛmɑ́ piɑnipɛ-i wɑi. ");
INSERT INTO soy_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Uu usɛ wurɑ mɛwóópipi sipehepi sinupũ pɑ, uu ucɔ wurɑ mɛwóópipi sipehepi sitɛ́ pɑ, uu utɑ́ɑ́nũ wurɑ mɛwóópipi kɛpehepi kɛsɛ pɑ. U ḿpɑ́ úye nnɑŋɛ nɛ musilɛ uú nɛ lɛ̃ kɑi m pisɛ u pɑ, uu pɛɛ yɑ́ uu tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ukɛikɔ́ uyɛɛ wurɑ mɛwóópipi sipehepi sinupũ ń yɔsí uu mɛsɛ nɛ mɛsɛ siwóó sɛ̃ kpísi uú nɛ kpéénsɛ, uu wurɑ mɛwóópipi sipehepi sinupũ sicɔ kulɑ́ɑ yɛnu. ");
INSERT INTO soy_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Uyɛɛ wurɑ mɛwóópipi sipehepi sitɛ́ ń yɔsí pɔ́ɔ kɔ limɛcɔ wɑi, uu wurɑ mɛwóópipi sipehepi sitɛ́ sicɔ kulɑ́ɑ yɛnu. ");
INSERT INTO soy_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Amɑ́ uyɛɛ wurɑ mɛwóópipi kɛpehepi kɛsɛ ń yɔsí pɔ́ɔ hɑ kuhórɛ túni uu ukɛisɑɑ siwóó sɛ̃ pésu. ");
INSERT INTO soy_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Kɑi siyɑ́ɑ sitɛ́ n wɑ, piukɛisɑɑ uu kúiri uu rɛ pikɛ́ ulikɔ́ kɛ́ɛ̃ ukɛ́ yɛ̃́. ");
INSERT INTO soy_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ukɛikɔ́ uyɛɛ wurɑ mɛwóópipi sipehepi sinupũ ń yɔsí uu ukɛisɑɑ kɛyúrí nyɔsɔ́pɔ nɛ wurɑ mɛwóópipi sipehepi sinupũ féé sicɔ, uu rɛ: Wurɑ mɛwóópipi sipehepi sinupũ kɑɑ́ pɛɛ nɛ́ pɑ. Áɑ yɛ̃ɛ, Upíimɑ? Wurɑ mɛwóópipi sipehepi sinupũ sicɔ yɛ nsí kɑm kulɑ́ɑ n yɛ̃́. ");
INSERT INTO soy_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Uukɛisɑɑ uu u mɑɑ rɛ: Nɛ pɑkɑrɛ! Pɔ ukɛikɔ́ sɔnɛ nɛ ɑsei ute lɛ. Likɑ́ripikɔɔ́-i kɑɑ nní wɑ lɛ̃ kɑi m pisɛ. Lɛ̃ nnyɑ, nɛ́ limɑ́ɑ-mɑɑ pɔ́ rimúísɛ. A lommɛ tɔkɛ́ ɑnyɑ̃́ li. ");
INSERT INTO soy_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ukɛikɔ́ uyɛɛ wurɑ mɛwóópipi sipehepi sitɛ́ ń yɔsí pɔ́ɔ kɔ nyɔsɔ́pɔ uu rɛ: Wurɑ mɛwóópipi sipehepi sitɛ́ kɑɑ́ pɛɛ nɛ́ pɑ, Upíimɑ! Áɑ yɛ̃ɛ? Wurɑ mɛwóópipi sipehepi sitɛ́ sicɔ yɛ nsí kɑm kulɑ́ɑ n yɛ̃́. ");
INSERT INTO soy_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Uukɛisɑɑ uu u mɑɑ rɛ: Nɛ pɑkɑrɛ! Pɔ ukɛikɔ́ sɔnɛ nɛ ɑsei ute lɛ. Likɑ́ripikɔɔ́-i kɑɑ nní wɑ lɛ̃ kɑi m pisɛ. Lɛ̃ nnyɑ nɛ́ limɑ́ɑ-mɑɑ pɔ́ rimúísɛ. A lommɛ tɔkɛ́ ɑnyɑ̃́ li. ");
INSERT INTO soy_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ai nkpéni yɑ́ uyɛɛ wurɑ mɛwóópipi kɛpehepi kɛsɛ ń yɔsí. Uyɛ̃ pɔ́ɔ kɔ nyɔsɔ́pɔ uu rɛ: Nɛ nyulɛ Upíimɑ rɛ mɛpɔ́kɔ́ ɑ́mɛ kusɑ pɔ́ɔ́lú. Kɛcɑrɛ kɛ-i kɑ́ɑ n lukɛsi kɑɑ yɛ kpɑsi. Kei kɑ́ɑ n fṍ kɑɑ yɛ kpéẽ. ");
INSERT INTO soy_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Lɛ̃ nnyɑ kɛ iwɑmɛ ii nɛ́ wɑ ɑm kɛtẽ kɛ́mɛɛ sipɔ́wóó kúlɛsi. Áɑ yɛ̃ɛ! Sipɔ́wóó sɛɛ nsí, ɑ yɔsí! ");
INSERT INTO soy_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Kei kɛ ukɛisɑɑ uu rinɔ́ɔ u pɛsɛ rɛ: Pɔ ukɛikɔ́ kópɛ nɛ ukɑ́nsoi lɛ! Kɑɑ lɛ̃ n nyu rɛ kɛcɑrɛ kɛ-i kɑ́m n lukɛsi kɑm yɛ kpɑsi. Nɛ́ɛ kei kɑ́m n fṍ kɑm yɛ kpéẽ. ");
INSERT INTO soy_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Pɔ yɛɛ pɛɛ sinɛ́wóó nɛ kɛwóóforɛ piyekei hɑlɛ, ɑḿ pɛɛ́ hɑ pɛɛri ɑm sinɛ́wóó sɛ̃ yɔ́su nɛ sikulɑɑ. ");
INSERT INTO soy_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ukɛisɑɑ uyɛ̃ uu pɛɛ pikɛikɔ́ picɔ mɑɑ rɛ: Ani mɛkɛɛ wurɑ mɛwóópipi kɛpehepi kɛ̃ uɑnipɛ-i yɔsí ɑni nkó yɛɛ nní wurɑ mɛwóópipi sipehepi kɛfi m mɑ́ kpɑ́. ");
INSERT INTO soy_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Li we rɛ nkó yɛɛ mɛyɑ̃́ m mɑ́ kɑpi yɛ pípɑ rikpɑ́ ɑí nɛ u fuu, ɑmɑ́ nkó yɛɛ úu líkɑ m mɑ́, pi yɛ lɛ̃ kuu m músu rɛ u mɑ́ ricuruu u yɔsilɛ. ");
INSERT INTO soy_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Amɑ́ ukɛikɔ́ nkó yɛɛ úu nní líkɑ n yóriyɛ likɔ́ lɛɛ rɛ ɑni u tĩ ɑni kɛtɑhɑi-mɛ̃ kuŋmɑhɑ-i u sɑ́pɔ. Kei kuu yɛ́ n téni un inĩ́ tɑkɑi. ");
INSERT INTO soy_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Yeesu uu kɔ pimɑ́ɑ pi kpɑ́ rɛ: Kɛyɑ́ɑ kɛ̃ kɛ Usoi Kɛpipi ɑkɛ́ hɑ kɛmmulɛ kɛ́mɛɛ n sɔ́nti nɛ piléécɑɑtumɛ nnɛ́í, kɛriyukɔɔ́tũ kɛcɑ́ɑ́ kɑkɛ́ hɑ tonɛnɛ. ");
INSERT INTO soy_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Kɛtẽ nkɛ́ kɛcɑ́ɑ́ isoipuri nnɛ́í yɛ́ hɑ kɛkɛyu-i n cɑ́pinɛlɛnlɛ, ɑkɛ pɛɛ pisoi nɛ pipicɔ kóólɛnɛ yɑrɛ kɛ usɛɛsẽ́ uu yɛ isɑ́ŋ nɛ ipoi n kóólɛnɛ. ");
INSERT INTO soy_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Uu pɛɛ isɑ́ŋ ukulukɛ-lukɛ-mɛ̃ wɑi uu ipoi ukumii-mɛ̃ wɑi. ");
INSERT INTO soy_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Kei kɛ uyɔ́ɔpi uu yɛ́ pɛɛ pɛpɛɛ ukulukɛ-lukɛ-mɛ̃ ń we mɑɑ rɛ: Nɔ́ mpí kɛ Unɛ́sɑ́ɑ Uléécɑɑ uu nní rinkpɑ́, ɑni kɑm ɑni iyɔ́ɔpi kuu hɑ́i kɛtẽ kɛkorɑɑnɛ-mɛ̃ n yekeilɛ̃ un nɛ nɔ́ mɛ̃́ yɔsí. ");
INSERT INTO soy_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Li we rɛ nkṹ yɛ nɛ́ wɑlɛ, ɑni nɛ́ hɛ ɑm le, nnírɛ́ nn nɛ́ wɑi, ɑni nɛ́ hɛ ɑm níru. Nɛ pɛɛ usɑ́nɛ lɛ, ɑni nɔ́sinɛ́yɔ-i kusɑ́nɛ nɛ́ yɔ́su, ");
INSERT INTO soy_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","nɛ pɛɛ mɛŋmɑnɛ welɛ, ɑni ilũ nɛ́ tɑni, nɛ pɛɛ pɔ́ɔ́lúlɛ, ɑni kɛnɛ́cɑ́ɑ́ pɑí. Nɛ pɛɛ kukpɑniilee-i welɛ, ɑní hɑpɔ ɑni nɛ́ lóólú. ");
INSERT INTO soy_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Kei kɛ pɛpɛɛ nní ɑsei n tíkilɛ̃ ɑpi yɛ́ pɛɛ rinɔ́ɔ yɔsí rɛ: Upíimɑ, kɛyɑ́ɑ kɛ́ye kɑri pɔ́ yɛ̃́ nkṹ nn pɔ́ we, ɑri pɔ́ hɛ ɑɑ le, nɛ́ɛ nnírɛ́ nn pɔ́ we, ɑri pɔ́ hɛ ɑɑ níru? ");
INSERT INTO soy_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kɛyɑ́ɑ kɛ́ye kɑɑ usɑ́nɛ, ɑri sirɔ́yɔ-i kusɑ́nɛ pɔ́ yɔ́su? Kɛyɑ́ɑ kɛ́ye kɑri pɔ́ yɛ̃́ pɔn mɛŋmɑnɛ we, ɑri ilũ pɔ́ tɑni? ");
INSERT INTO soy_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kɛyɑ́ɑ kɛ́ye kɑri pɔ́ yɛ̃́ pɔn pɔ́ɔ́lú nɛ́ɛ pɔn kukpɑniilee-i we, ɑri pɔ́ lóólú? ");
INSERT INTO soy_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Uyɔ́ɔpi yɛ́ pɛɛ rinɔ́ɔ pi pɛsɛ rɛ: Asei kɛcɑ́ɑ́, kɛ́ nɔ́ símisi rɛ lɛ̃ kɑni pinɛ́mɑ́rɛcɔ kɛcɔpɛ usíńsɑ́ unyinɛ n wɑ, nɛ̃́ kɑni lɛ̃ li wɑ. ");
INSERT INTO soy_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Kei kɛ uyɔ́ɔpi uu yɛ́ pɛɛ pɛpɛɛ ukumii-mɛ̃ ń we mɑɑ rɛ: Ani kɛnɛ́kúrí yisi ɑni kɛtɑɑ-pɔ rinyɔsɔ́. Uléécɑɑ yɛ ɑnɔ́ɔ nɔ́ wɑlɛ! Ani hɑ nnɑ tɛnɛcirɛ́ kɛ́mɛɛ lompɔ. Kei kɛ Uléécɑɑ uu n nyɔ́ɔnsɛ un nɛ Setɑni nɛ upitumɛ mɛ̃́. ");
INSERT INTO soy_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Nkṹ yɛ nɛ́ wɑlɛ, ɑ́ni nɛ́ hɛ kɛ́ li, nnírɛ́ nn nɛ́ wɑi, ɑ́ni nɛ́ hɛ kɛ́ n ntí. ");
INSERT INTO soy_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nɛ pɛɛ usɑ́nɛ lɛ, ɑ́ni nɔ́sinɛ́yɔ-i kusɑ́nɛ nɛ́ yɔsí. Nɛ pɛɛ mɛŋmɑnɛ welɛ, ɑ́ni ilũ nɛ́ tɑ̃. Nɛ pɛɛ pɔ́ɔ́lúlɛ nɛ́ɛ nɛ pɛɛ kukpɑniilee-i welɛ, ɑ́ni hɑpɔ nɔkɛ́ nɛ́ rilóólú. ");
INSERT INTO soy_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Kei kɛ pɛ̃ pɔ́ɔ kɔ rinɔ́ɔ yɔsí rɛ: Upíimɑ, kɛyɑ́ɑ kɛ́ye kɑri pɔ́ yɛ̃́ nkṹ nn pɔ́ we nɛ́ɛ nnírɛ́ nn pɔ́ we nɛ́ɛ pɔn usɑ́nɛ nɛ́ɛ pɔn mɛŋmɑnɛ we nɛ́ɛ pɔn pɔ́ɔ́lú nɛ́ɛ pɔn kukpɑniilee-i we, ɑ́ri pɛɛ́ nɛ kutu pɔ́ ricɔ? ");
INSERT INTO soy_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Kei kɛ uyɛ̃ uu yɛ́ kɔ pi pɛsɛ rɛ: Asei kɛcɑ́ɑ́, kɛ́ nɔ́ símisi rɛ lɛ̃ kɑ́ni pisíńsɑ́ pɛ̃ kɛcɔpɛ unyinɛ n wɑ, nɛ̃́ kɑ́ni lɛ̃ li wɑ. ");
INSERT INTO soy_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Api pɛɛ́ nɛ íwɛ tɛnɛcirɛ́ kɛ́mɛɛ pi tɔ́mpɔ, ɑmɑ́ pɛpɛɛ nní ɑsei n tíkilɛ̃ pɔ́ɔ pɛɛ nfɑ́ɑ tɛnɛcirɛ́ kɛ́mɛɛ lompɔ. ");
INSERT INTO soy_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Kɛ Yeesu uu lɛ̃ picélɑɑ ḿ mɑsí, uu pɛɛ upipirɛtiki mɑɑ rɛ: ");
INSERT INTO soy_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Nɔ yɛ̃ tɛ li tisɛ siyɑ́ɑ sitɛ́ pikɛ́ nɛ nkpɔ mɛlɔ́ɔ́ ɑnyɑ̃́ li. Kei kɑpi Usoi Kɛpipi pilɑ́ɑrɔ ɑnipɛ-i wɑinɛ, pɛ̃ pikɛ́ kunɑpɛ́ɛ́kɔɔ́ kɛcɑ́ɑ́ kɛ kɑrii. ");
INSERT INTO soy_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Kei kɛ pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ nɛ Pisuifi piwɛ́ɛ́sɛ ɑpi Uléécɑɑ usinɑ kɑpi yɛ n sée rɛ Kɑyifu kɛyɔcɔpɛ cɑ́pinɛ, ");
INSERT INTO soy_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ɑpi rinɔ́ɔ risɛ wɑi rɛ pikɛ́ mɛyɑɑ Yeesu tĩ pikɛ́ kpu. ");
INSERT INTO soy_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Api pɛɛ rɛ: Amɑ́ ɑ́i kɑpɛ pɛɛ ɑnyɑ̃́ kɛ́mɛɛ. Insɑ́ lɛ̃, pisoi pɛɛ n cɑ́pinɛlɛ̃ yɛ́ yisi ɑpi nyɛrɛ. ");
INSERT INTO soy_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yeesu uu Petɑnii kɛtẽ-mɛ̃ sĩ uú hɑ uyɔ̃́ Simɔɔ kɛyɔ-i topilɛ. ");
INSERT INTO soy_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Kɑpi n tṹ pin ilukɛ le, unɔ́si unyinɛ uu kɛnúḿpi sɔnɛ kɛnyinɛ kɛ́mɛɛ tulɑɑli nɛ́íkɔɔ́ píimɑ unyinɛ múípɔ uú nɛ sɔ́nɛpɔ uú nɛ Yeesu kɔ. Uu Yeesu riyu kɛcɑ́ɑ́ tulɑɑli uyɛ̃ kɔɔni. ");
INSERT INTO soy_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Kɛ upipirɛtiki ɑpi lɛ̃ n yɛ̃́, ɑ́i nɛ pi risɑ́, ɑpi pɛɛ unɔ́si uyɛ̃ mɑɑ rɛ: Yo picɑɑinkɛɛ yɛ nkpéni mpí? ");
INSERT INTO soy_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Pi yɛ́ pɛɛ fe ɑpi tulɑɑli nkó yɑ́i nnɛ́í píimɑ ɑpi lisiwóó sɛ̃ píwɛkɔɔ́ hɔ́ɔ́nɛ. ");
INSERT INTO soy_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yeesu uu céru rɛ lɛ̃ kɑpi símisi, uu pɛɛ pi mɑɑ rɛ: Yo nnyɑ kɑni lɛ̃ unɔ́si uyɛ̃ cɔ́ŋlɛ̃? Mɛwɑi sɔnɛ kuu nɛ́ wɑ. ");
INSERT INTO soy_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Likumúŋɛ́ rɛ ḿpɑ́ píyei kɛ nɔ́ nɛ píwɛkɔɔ́ ɑní we, ɑ́i ḿpɑ́ píyei kɛ tɔ́ nɛ nnɔ̃́ ɑrí we. ");
INSERT INTO soy_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Inɛ́piŋɛ kuu mɛncirɛ tulɑɑli fṍ pikɛ́ kɛlenɛ nhórɛ nɛ́ tɑ̃. ");
INSERT INTO soy_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Asei kɛcɑ́ɑ́, kɛ́ nɔ́ símisi rɛ ḿpɑ́ yei kɑpi kɛtẽ nnɛ́í kɛcɑ́ɑ́ Nsímɛ́ Kɛcirɛ yóólɛ̃, pi yɛ́ɛ́ unɔ́si nkó mɛwɑi mmɛ́ símisi ɑpí nɛ u n léisɛlɛ̃. ");
INSERT INTO soy_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Kei kɛ Yeesu pipirɛtiki kɛfi nɛ pitɛ́ pɛ̃ usɛ kɑpi yɛ n sée rɛ Yutɑsi Isikɑriyɔɔti uu pɛɛ yisi uu pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ lɛɛpɔ ");
INSERT INTO soy_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","uu pi pisɛ rɛ: Nɛn Yeesu nɔ́ɑnɛ́nípɛ-i n wɑ, yo kɑni yɛ́ nɛ́ pɑ? Pɛ̃ ɑpi mɛsɛ nɛ mɛsɛ kei nní nwóóweni mɛpipi ɑfɛɛtɑɑni kɛɛni ɑpi u múísɛ. ");
INSERT INTO soy_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kɑí nɛ kei n kpísi, Yutɑsi uu pɛɛ icée n wɛ́ɛ́si ukɛ́ nɛ Yeesu piɑnipɛ-i n wɑ. ");
INSERT INTO soy_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Anyɑ̃́ nyɛ-i kɑpi yɛ ɑkpɔ́nɔ́ nyɛɛ ɑ́ɑ pitɛ m mɑ́ n li kɛyɑɑ foí kɛ Yeesu pipirɛtiki ɑpi ukɛkúrí hɑ́pɔ, ɑpi u pisɛ rɛ: Yei kɑɑ́ lɑ tɔkɛ́ ɑnyɑ̃́ nyɛ̃ ilukɛ pɔ́ wɑ? ");
INSERT INTO soy_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Uu pi pɛsɛ rɛ: Ani kuyu-i kɔɔ́ kɛyɔ-i hɑpɔ ɑni u mɑɑ rɛ: Ucélɑɑ yɛ rɛ unkpɔ ituŋɛ yɛ tulɛ. Kɛpɔ́yɔ-i kɛ u nɛ upipirɛtiki ɑpi sɔ́nti pikɛ́ nkpɔ mɛlɔ́ɔ́ ɑnyɑ̃́ li! ");
INSERT INTO soy_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Upipirɛtiki ɑpi mɛsei lɛ̃ kuu pi ḿ mɑ wɑi, ɑpi nkpɔ mɛlɔ́ɔ́ ɑnyɑ̃́ ilukɛ wɑi. ");
INSERT INTO soy_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kɑi nnyɔ́ɔ́ ń wɑ, u nɛ upipirɛtiki kɛfi nɛ pitɛ́ pɛ̃ ɑpí tonɛ ɑpi ilukɛ n le. ");
INSERT INTO soy_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Kɛlukɛ kɛ-i kuu pi mɑɑ rɛ: Asei kɛcɑ́ɑ́, kɛ́ nɔ́ símisi rɛ nɔ́kɛnɛ́cɔpɛ unyinɛ yɛ́ nɛ́ tĩ́ uu pinɛ́lɑ́ɑrɔ ɑnipɛ-i wɑi. ");
INSERT INTO soy_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Kuu lɛ̃ ḿ mɑ, upipirɛtiki ɑpɔɔ ɑɑ mɛyíkíyiki cɑɑi ɑpi usɛ usɛ u m písɛi rɛ: Upíimɑ, yɑrɛ nɛ̃́ nɛ́ɛ? Ucɔ uu kɔ rɛ: Upíimɑ, yɑrɛ nɛ̃́ nɛ́ɛ? ");
INSERT INTO soy_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Kei kuu pɛɛ pi pɛsɛ rɛ: Tɔ́ nɛ uyɛ̃ tɔ́ɔ nní ricɑ́ripi risɛ-i n le yɛɛ sɔ́nti ukɛ́ pinɛ́lɑ́ɑrɔ ɑnipɛ-i nɛ́ wɑ. ");
INSERT INTO soy_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Usoi Kɛpipi yɛ kɛtẽ nkɛ́ kɛcɑ́ɑ́ tɔ́sulɛ yɑrɛ lɛ̃ kɑi Nléécɑɑsimɛ́ kɛ́mɛɛ kɛkɛcɑ́ɑ́ ń wɔ́lɑɑlɛ̃ mɛcɔ. Amɑ́ uyɛɛ pilɑ́ɑrɔ ɑnipɛ-i kɛ n wɑinɛ yɛ íwɛ toporilɛ. Li kutɔsi we ɑ́pi kɑpɛ pɛɛ liute m mɑri. ");
INSERT INTO soy_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yutɑsi yɛɛ pilɑ́ɑrɔ ɑnipɛ-i u n wɑinɛ pɔ́ɔ pɛɛ u pisɛ rɛ: Yɑrɛ nɛ́ɛ pɛɛ lo nɛ́ɛ, Upíimɑ? Yeesu uu rɛ: Yɑrɛ kɑɑ nní ḿ mɑ. ");
INSERT INTO soy_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Kɛ Yeesu nɛ upipirɛtiki ɑpi lɛ̃ n tṹ pin ilukɛ le, uu kukpɔ́nɔ́ kpísi uu kukɛcɑ́ɑ́ Uléécɑɑ pɔɔnɛsɛ uu ku kpɔ́kɔrinɛ uu pi pɑ uu rɛ: Inɛ́piŋɛ yɛ nnyí, ɑni yɔsí ɑni li. ");
INSERT INTO soy_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Uu lɛ̃ mɛmɑ́ɑ́ kɛpóripi kpísi uu kɛkɛcɑ́ɑ́ Uléécɑɑ pɔɔnɛsɛ uu pi pɑ uu rɛ: Ani yɔsí ɑni nɔ́nnɛ́nɛ́í n ntí. ");
INSERT INTO soy_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Mɛnɛ́nyɛ yɛ mmɛ́ mɛɛ n kɔɔnu pisoi mɛyɑ̃ nnyɑ rɛ Uléécɑɑ ukɛ́ piɑkópɛ pi sɑ́rɛi. Mɛ́nyɛ mɛ̃ kɑí nɛ ritiki Uléécɑɑ uú nɛ pisoi séi rɛ u nɛ pɛ̃ pikɛ́ kómɛinɛ. ");
INSERT INTO soy_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Kɛ́ nɔ́ símisi rɛ kɑí nɛ nɛni rimpɑ́, ɑ́m ɑléépipi pitɑ mpí pinírɛ́ kpɑ́nɛ likɛ́ hɑ nɛ tu kɛyɑ́ɑ kɛ̃ kɛ tɔ́ nɛ nnɔ̃́ ɑri yɛ́ hɑ kɔ pítɑ fɑlɛ Unɛ́sɑ́ɑ iyɔɔpi kɛ́mɛɛ ń ntí. ");
INSERT INTO soy_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Kuu lɛ̃ pisímɛ́ pi ḿ mɑsí ɑpi pɛɛ ipɑkɑrɛ siyomɛ n yom pin pɑkɑrɛntɛ, ɑpi wɑi ɑpi yisi ɑpi Olifiyee rikúú tɑɑ́. ");
INSERT INTO soy_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Kei kɛ Yeesu uu pɛɛ upipirɛtiki mɑɑ rɛ: Nɔ́ nɔ́nnɛ́nɛ́í kɛsinɛ nkɛ́ nɛ́ ŋmɛriyɛ ɑni wúrunkɛɛ. Li Uléécɑɑ ritɛlɛ́-i wɔ́lɑɑlɛ̃ tɛ: Nɛ́ usɛɛsẽ́ kpu, kusɛɛlee isɛɛ nnɛ́í ii kpíi. ");
INSERT INTO soy_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Yeesu uu kɔ kpɑ́ rɛ: Amɑ́ nɛn píyei nkpɔ kɛ́mɛɛ piyisɛ m mɑsí, nɛ́ hɑ Kɑlilee kɛtẽ-pɔ nɔ́ m mɛ̃́. ");
INSERT INTO soy_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Piyɛɛ uu rinɔ́ɔ yɔ́su uu rɛ: Ḿpɑ́ pisoi nnɛ́í pin pɔ̃́ nnyɑ kɛlólɛ́ n yɛ̃, nɛ̃́ ɑ́m yɛ́ píkɑi loó. ");
INSERT INTO soy_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yeesu uu u pɛsɛ rɛ: Asei kɛcɑ́ɑ́, kɛ́ pɔ́ símisi rɛ pɔ́ kɛsinɛ nkɛ́ cirɛ kɛsi mɛtɑɑni rɛ ɑ́ɑ nɛ́ nyu, icɑ̃́ ii kɛlenɛ kooi. ");
INSERT INTO soy_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Kei kɛ Piyɛɛ uu pɛɛ u mɑɑ rɛ: Ḿpɑ́ lin nkpɔ yɛ mu, tɔ́ nɛ mpɔ̃́ tɔkɛ́ kɛsẽ́ kpu, ɑ́m kuŋmɛriyɛ pɔ́ we. Pipirɛtiki nnɛ́í ɑpi limɛcɔ mɑlɛ. ");
INSERT INTO soy_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Lɛ̃ mɛmɑ́ɑ́, Yeesu nɛ upipirɛtiki ɑpi kɛlõ kɛnyinɛ kɑpi yɛ n sée rɛ Kɛtisemɑnee kɛ́mɛɛ tuipɔ. Uu upipirɛtiki mɑɑ rɛ: Ani nté n tũ nɛ́ɛkɛ́ rinyɔsɔ́ kɛ́ hɑ kɛyómɛ yɑ́ɑ́si. ");
INSERT INTO soy_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Uu Piyɛɛ nɛ Sepetee piŋmɑ́nɛ kɛtɛ́ kpísi uú nɛ pɛ́nɛ. Nfɑsimɛ́ píimɑ nɛ mpɔ́ɔcɑɑi nnyinɛ nn pɛɛ u tini. ");
INSERT INTO soy_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Kei kuu pɛɛ pi mɑɑ rɛ: Tinɛ́pɔ́ɔ yɛ cɑɑilɛnlɛ hɑ́i lin nɛ nkpɔ mɛnyínɛ we. Ani nté n tũ, ɑ́ni kɑpɛ lɔpilɛ, tɔkɛ́ kɛsẽ́ n nyɑ́ni. ");
INSERT INTO soy_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Kei kuu nkɑ́ripi nɛ kɛtɑɑ pi wɑ, uu wúlɑ uu kɛ́yu kɛtẽ kipi uu Uléécɑɑ yɑ́ɑ́si rɛ: Unɛ́sɑ́ɑ, pɔ́ fe ɑɑ ḿpɑ́ yo wɑi, ɑ nɛ ntóósi kɛporipi nkɛ́ kɛtɑɑ nɛ́ wɑ. Ḿpɑ́ nɛ lɛ̃, kɑpɛ mɛnɛ́pɔ́ɔlɑ wɑ, ɑmɑ́ mɛpɔ́kɔ́ wɑ. ");
INSERT INTO soy_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Kuu piyómɛyɑ́hɑɑ ḿ mɑsí, uu upipirɛtiki pɛ̃ kɛ́mɛɛ pɛɛpɔ, uu pi lɛɛpɔ pin lɔni. Uu pɛɛ Piyɛɛ pisɛ rɛ: Lɛ̃ nnyɑ, ɑ́ni nkpɑ́ni fe tɔ́ nɛ nnɔ̃́ tɔkɛ́ kɛnɑmpi kɛsɛ kɛsẽ́ n nyɑ́nii? ");
INSERT INTO soy_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ani n tũ nɔn nyɑ́ni nɔn kɛyómɛ yɑ́ɑ́si ɑ́ni kɑpɛ nɛ pipeikɛɛ kɛ́mɛɛ ń loó nnyɑ. Li kɛsoipipi ripɔ́ɔ we rɛ kɛkɛ́ yɛ lisɔnɛ wɑ, ɑmɑ́ kɛ pɛɛ rinɑ́rɛi mɑ́lɛ. ");
INSERT INTO soy_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Uu kɔ mɛlírũ nkɑ́ripi nɛ kɛtɑɑ pi wɑi, uu kɔ Uléécɑɑ yɑ́ɑ́si rɛ: Unɛ́sɑ́ɑ, in tɛ ɑ́ɑ yɛ́ ŋmurɛi ntóósi kɛporipi nkɛ́ kɛkɛ́ nɛ kɛtɑɑ nɛ́ wɑ rɛ nɛ mɛnírɛ́ kɛ mɑ́lɛ, mɛpɔ́lɑ mɛkɛ́ wɑ. ");
INSERT INTO soy_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Uu pɛɛri uu kɔ pi lɛɛri pin lɔni, likumúŋɛ́ rɛ piinipɛɛ yɛ mulɛsilɛ. ");
INSERT INTO soy_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Uu kɔ mɛtɑ́ɑ́nũ piyisɛ kpɑ́ uú nɛ kɛtɑɑ pi wɑi, uú hɑ kɔ mɛsɛ mɛ̃ nɛ Uléécɑɑ téni ");
INSERT INTO soy_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","uu pɛɛ kɔ upipirɛtiki kɛ́mɛɛ pɛɛpɔ uu pi mɑɑ rɛ: Nɛ́ntɛ nɔ nkpéni lɔnilɛ nɔn wéntɛlɛ̃? Ituŋɛ yɛ nkpéni tulɛ rɛ pikɛ́ Usoi Kɛpipi tĩ pikɛ́ pikópɛkɔɔ́ ɑnipɛ-i wɑ. ");
INSERT INTO soy_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ani yisi tɔkɛ́ u tɛ́pɛi. Uyɛɛ nɛ́ n kpísinɛ ukɛ́ pikópɛkɔɔ́ ɑnipɛ-i wɑ yɛ nyɑhɑimɛlɛ. ");
INSERT INTO soy_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Kɛ Yeesu uu lɛ̃ ń we un símisi, upipirɛtiki kɛfi nɛ pitɛ́ pɛ̃ kɛcɔpɛ usɛ kɑpi yɛ n sée rɛ Yutɑsi un tuipɔ nɛ risoiwuí, ɑtɛ́hɛ nɛ ɑpúnípi ɑn mulɛilɛ̃. Pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ nɛ Pisuifi piwɛ́ɛ́sɛ pɛɛ lɛ̃ pi tumpɔ. ");
INSERT INTO soy_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yutɑsi uyɛɛ pɛɛ piɑnipɛ-i Yeesu n wɑinɛ yɛ pɛɛ risoiwuí céesilɛ lɛ̃ kɑpi yɛ́ nɛ Yeesu n céri pikɛ́ tĩ́. Uu pɛɛ pi mɑɑ rɛ: Nɛn hɑ úye rimpirɑ ɑḿ u yɑ́ɑ́si, uyɛɛ lo. Ani u tĩ. ");
INSERT INTO soy_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Kuu n tuipɔ, uú nɛ Yeesu kɛ́mɛɛ n sɑirilɛ̃ uú hɑ u mɑɑ rɛ: Nɛ pɔ́ yɑ́ɑsi, Sɑ́ɑ! Uu pɛɛ u pirɑ uu u yɑ́ɑ́si. ");
INSERT INTO soy_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yeesu uu pɛɛ u mɑɑ rɛ: Unɛ́sɑ́nɛ, ɑ pikɛi pɛ̃ kɑɑ piwɑi ń kɑ mɛkɛɛ wɑ! Kei kɛ pɛ̃ ɑpi pɛɛ cɑ́pinɛpɔ, ɑpi Yeesu tini ɑpi múlú. ");
INSERT INTO soy_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Kei kɛ Yeesu upirɛtiki usɛ uu risɑɑpɔ uu ritɛ́hɛ kpeéu uu Uléécɑɑ usinɑ ukɛikɔ́ kutu seḿ. ");
INSERT INTO soy_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yeesu uu u mɑɑ rɛ: A ripɔ́tɛ́hɛ tɛ̃ tikukɑi-i pɛsɛpɔ. Li we rɛ pɛ̃ nnɛ́í pɛɛ nɛ ritɛ́hɛ n kóni, titɛ́hɛ kɑpi yɛ kɔ nɛ pɛ̃ kpu. ");
INSERT INTO soy_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Áɑ nyu rɛ nɛn pɛɛ nté Unɛ́sɑ́ɑ m pisɛ rɛ ukɛ́ nɛ́ lɛ́mmɛ, u yɛ́ pɛɛ nté nní piléécɑɑtumɛ nɛ́ pɑmɛ ɑi inɔŋ kɛfi nɛ itɛ́ fɑ́ɑuu? ");
INSERT INTO soy_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Nɛn nkpéni lɛ̃ n wɑ, li yɛ́ pɛɛ mmɛ̃ kɑpi nní Uléécɑɑ ritɛlɛ́-i n wɔ́i rɛ nní kɑi nní n wɑi kɑi pisɛ rɛ likɛ́ wɑ kɛcɑ́ɑ́ ritikii? ");
INSERT INTO soy_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Yeesu uu pɛɛ pisoi pɛɛ n cɑ́pinɛlɛ̃ mɑɑ rɛ: Nɔ ɑtɛ́hɛ nɛ ɑpúnípi nɛ pitínɛ nɛ́ kɑ yɑrɛ usoi kpɑ́ɑ́ree unyinɛ kɑni pitínɛ kɑ. Ḿpɑ́ kɛyɑ́ɑ kɛ́ye kɛ tɔ́ nɛ nnɔ̃́ ɑrí pɛɛ Uléécɑɑ kɛyɔ-i we nɛn céési, ɑ́ni nɛ́ tĩ́. ");
INSERT INTO soy_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Amɑ́ lɛ̃ kɛ ɑntepuyɛ ɑpi Nléécɑɑsimɛ́ kɛ́mɛɛ n wɔ́i likɛ́ nɛ n wɑ nnyɑ kɑi lɛ̃ wɑ. Kei kɛ upipirɛtiki nnɛ́í ɑpi pɛɛ u ŋmɛriyɛ ɑpi wuru. ");
INSERT INTO soy_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Pɛpɛɛ Yeesu n tĩ́ yɛ pɛɛ u kpísilɛ ɑpí nɛ Uléécɑɑ usinɑ Kɑyifu kɛyɔ sĩ. Kei kɛ isé picélɑɑ nɛ Pisuifi piwɛ́ɛ́sɛ ɑpí pɛɛ cɑ́pinɛlɛ̃. ");
INSERT INTO soy_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Piyɛɛ uu kɛtɑɑ-pɔ Yeesu n tikilɛ̃ uú nɛ Uléécɑɑ usinɑ kɛyɔcɔpɛ tulu, uu lompɔ uu pimɛ́rɛ́ kɛkúrí tonɛ un nɛ mɛ̃́ ukɛ́ yɛ̃́ lɛ̃ kɑi yɛ́ nɛ kɛ́tɔ ń kpu. ");
INSERT INTO soy_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ nɛ pitúhɑɑnɛ píimɑ nnɛ́í ɑpi pisoi wɛ́ɛ́si pɛɛ yɛ́ Yeesu nɛ nsímɛ́ rinkpɑ́rɑ́ pikɛ́ nɛ u ń kpu nnyɑ. ");
INSERT INTO soy_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Píseérɑkɔɔ́ nɔɔmɛ ɑpi cɑ́pinɛpɔ. Ḿpɑ́ nɛ lɛ̃, ɑ́pi ńkɑ yɛ̃ pikɛ́ nɛ u rikpɑ́rɑ́. Kɑi yɛ́ rinkpɑ́sɛ, pitisi pitɛ́ pinyinɛ ɑpí hɑpɔ ");
INSERT INTO soy_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ɑpi rɛ: Usoi nkó yɛ mɑɑ rɛ u yɛ́ fe uu Uléécɑɑ kɛyɔ foru uu siyɑ́ɑ sitɑɑni nɛ pimɔ́mɛ kɛ pɛsɛ. ");
INSERT INTO soy_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Kei kɛ Uléécɑɑ usinɑ uu pɛɛ yisi uu u mɑɑ rɛ: Nsímɛ́ mmú nnɛ́í kɛ pisoi mpí ɑpi nní kɛpɔ́cɑ́ɑ́ n símisi kɛ́mɛɛ, ń-ye kɑɑ yɛ̃́ pɔkɛ́ pɛsɛ? ");
INSERT INTO soy_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Yeesu uú n sɛ́ɛ́lɛ̃ lɛ́kɛ́-lɛ́kɛ́. Uléécɑɑ usinɑ uu pɛɛ u mɑɑ rɛ: Nɛ lɑ rɛ ɑ Uléécɑɑ yɛɛ n nyɑ́ni rinyiri sée ɑɑ́ nɛ wééri, in tɛ pɔ̃́ kɛ Uléécɑɑ uu wɛ́ɛ. Nɛ́ɛ pɔ́ɔ Uléécɑɑ Kɛpipii? ");
INSERT INTO soy_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yeesu uu u pɛsɛ rɛ: Lɛ̃ kɑɑ nní mɑ. Limɛmɑ́ɑ́, nɛ́ kɔ nɔ́ rikpɑ́sɛ rɛ kɑí nɛ nɛni n kpísi, nɔ́ Usoi Kɛpipi yɛ̃ kɛn Uléécɑɑ, ńnɑŋɛ nnɛ́í ute kulukɛ-lukɛ-mɛ̃ kɛ́yukɔɔ́tonɛ-i tṹ. Nɔ́ kɔ u yɛ̃ un kɛyómɛcɑɑ-pɔ ɑhopɛ kɛcɑ́ɑ́ tṹ un nɛ wemɛ. ");
INSERT INTO soy_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Kei kɛ Uléécɑɑ usinɑ uu pɛɛ uricuruu ilũ kuu n tɑnɑɑlɛ̃ cɛ́ɛ́rii ɑi nyísɛ rɛ li u tóósilɛ hɑ́i. Uu pɛɛ rɛ: Uléécɑɑ ŋmɑɑ kuu nní lɑ́mɑɑnkɛɛ. Ái nkpɑ́ni nkpéni pisɛ rɛ tɔkɛ́ píseérɑkɔɔ́ pinyinɛ wɛ́ɛ́si. Nɔ́rinɛ́cúruu yɛ ɑlɛ̃́ kuu Uléécɑɑ n lɑ́mɑɑnkɛɛ konlɛ. ");
INSERT INTO soy_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Lɛ̃ nnyɑ, íye kɑni músu? Api u pɛsɛ rɛ: Li nɛ sɑ́ rɛ pikɛ́ u kpu. ");
INSERT INTO soy_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Api pɛɛ mɛtɑ kɛ́yu-i pitúkɛntɛ u loni. Api ɑkpini u tini, picɔ ɑpi sipɛsɛ u kɑ́pɑ́ɑ́ ");
INSERT INTO soy_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ɑpi yɛ pɛɛ rɛ: Pɔ̃́ kɛ Uléécɑɑ uu n wɛ́ɛ, ɑ ŋmɔinu ɑɑ rɔ́ símisi nkɛ̃́ tɛ wóo pɔ́ pi? ");
INSERT INTO soy_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Kɛ Piyɛɛ uu kei lɛ̃ tipoo-i n tṹ, unɔ́si kɛikɔ́ unyinɛ uu léepɔ uu kei u lɛɛpɔ uu u mɑɑ rɛ: Nɛ pɔ́ɔ lo! Pɔ̃́ nɛ kɔ pɛɛ Kɑlilee ukɔ́ Yeesu uyɛ̃ tikilɛnlɛ. ");
INSERT INTO soy_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Uu pinnɛ́í inipɛɛ iyɛ-i kɛ́su uu rɛ: Nɛ̃́ ɑ́m nyu ń-ye kɑɑ símisi. ");
INSERT INTO soy_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Uu limɛmɑ́ɑ́ yisi uu rinɔnɔɔ-mɛ̃ sĩ. Unɔ́si kɛikɔ́ ucɔ pɔ́ɔ kɔ kei piyɛ́nɛ u kpɑ́ uu pɛpɛɛ kei n cɑ́pinɛlɛ̃ mɑɑ rɛ: Nkó pɔ̃́ nɛ kɔ pɛɛ Nɑsɑrɛti ukɔ́ Yeesu uyɛ̃ tikilɛnlɛ. ");
INSERT INTO soy_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Piyɛɛ uu kɔ pikɛ́ŋɛ kpɑ́ uu wééri rɛ: Ám usoi nkó nyu. ");
INSERT INTO soy_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Likɛ́ nɛ rinsɑ́sɛ, pɛpɛɛ kei ń we ɑpí nyɔsɔ́pɔ ɑpí nɛ u kɔ ɑpi u mɑɑ rɛ: Asei kɛcɑ́ɑ́, pɔ pisoi pɛ̃ usɛ lɛ. Mɛpɔ́símɛ́ kɛ́mɛɛ kɑi lɛ̃ nyísɛlɛ̃. ");
INSERT INTO soy_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Kei kɛ Piyɛɛ uu kɛ́si ŋmɑɑ uú nɛ kɛtẽ kpɛɛni uu wééri rɛ: Nɛ Uléécɑɑ, ɑ́m usoi nkó nyu. Mɛsɛ nɛ mɛsɛ, icɑ̃́ ii kooi. ");
INSERT INTO soy_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Piyɛɛ uu rinɔ́ɔ tɛ̃ kɛ Yeesu uú pɛɛ u ḿ mɑ léisɛ rɛ: Icɑ̃́ ikɛ́ kɛlenɛ n kooi, pɔ́ kɛsi mɛtɑɑni rɛ ɑ́ɑ nɛ́ nyu. Kei kɛ Piyɛɛ uu léepɔ uú nɛ mpɔ́ɔcɑɑi téni. ");
INSERT INTO soy_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kɑi kóso n weesi mmɑrɛ mɑrɛ, pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ nnɛ́í nɛ Pisuifi piwɛ́ɛ́sɛ ɑpi rinɔ́ɔ risɛ wɑi rɛ pikɛ́ Yeesu kpu. ");
INSERT INTO soy_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Kei kɑpi pɛɛ u pɑɑsi ɑpí nɛ Rɔm uyɔɔpi Pilɑti lɛɛpɔ. ");
INSERT INTO soy_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yutɑsi yɛɛ Yeesu n kpísi uu pilɑ́ɑrɔ ɑnipɛ-i wɑi uu yɛ́nu rɛ pi lɑ pikɛ́ Yeesu kpu. Ai u cɔ́ŋ, uu ukɛfɑ-i téni uu nwóóweni mɛpipi ɑfɛɛtɑɑni mɛ̃ kpísi uú nɛ pɛlɛ uú hɑ pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ nɛ Pisuifi piwɛ́ɛ́sɛ pɛ̃ pɑ. ");
INSERT INTO soy_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Uu pi mɑɑ rɛ: Nɛ ɑkópɛ wɑlɛ. Nɛ usoi yɛɛ úu líkɑ n cɑɑi yɑ́ɑ́ ɑḿ pɑ ɑpi kópu. Pɛ̃ ɑpi u pɛsɛ rɛ: Mpɔ́kɔ́ yɛ mmɛ̃! Ái nɛ tɔ̃́ yɛ̃! ");
INSERT INTO soy_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Uu pɛɛ siwóó sɛ̃ kpísi uu Uléécɑɑ kɛyɔ-i sɑ́, uu sĩ́ uú hɑ umɛcirɛ ńŋmɛ wɑi. ");
INSERT INTO soy_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ ɑpi siwóó sɛ̃ híni ɑpi rɛ: Kɑi nní mɛ́nyɛ kɛwóó nnyɑ, ncée ńn irɔ́sé kɛ́mɛɛ we rɛ pikɛ́ Uléécɑɑ kɛyɔ kuwóótɑkɑi kɛ́mɛɛ kɛ wɑipɔ. ");
INSERT INTO soy_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Api kómɛinɛ ɑpi pɛɛ kɛ kpísi ɑpí nɛ utúhumɔmɛ kɛ́mɛɛ kɛtẽ lɔlu rɛ pikɛ́ yɛ kei pisɑ́nɛ kulɛsi. ");
INSERT INTO soy_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Lɛ̃ nnyɑ kɑí nɛ kei n kpíimɛ nɛ nɛni-mɛ̃, pi kɛtẽ kɛ̃ sélei rɛ: mɛ́nyɛ kɛcɑrɛ. ");
INSERT INTO soy_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Lɛ̃ kɛ ɑntepu Yeremii uú pɛɛ Yeesu kɛcɑ́ɑ́ ḿ mɑ uu Uléécɑɑ nsímɛ́ ritɛlɛ́ kɛ́mɛɛ wɔ́lu kɑi wɑ rɛ: Pi nwóóweni mɛpipi ɑfɛɛtɑɑni mɛ̃ kpísilɛ. Mɛ̃ kɛ Isirɑyɛɛli pikɔ́ ɑpí musí rɛ pi yɛ́ ukɛcɑ́ɑ́ hɛ́ɛ́lɛ. ");
INSERT INTO soy_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Apí nɛ utúhumɔmɛ kɛ́mɛɛ kɛtẽ lɔlu. Lɛ̃ kɛ Upíimɑ uu rɛ kɛ́ pi símisi. ");
INSERT INTO soy_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Kɑpi uyɔɔpi Pilɑti kɛ́mɛɛ nɛ Yeesu pitúhɑɑnɛ ń hɑ, uyɔ́ɔpi uyɛ̃ uu u pisɛ rɛ: Pɔ́ɔ Pisuifi uyɔɔpii? Yeesu uu rinɔ́ɔ u yɔ́su rɛ: Mmɛ̃ kɑɑ nní mɑ. ");
INSERT INTO soy_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Amɑ́ kɛ pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ nɛ Pisuifi piwɛ́ɛ́sɛ ɑpí nɛ nsímɛ́ u rinkpɑ́rɑ́, úu ríkɑ pi pɛsɛ. ");
INSERT INTO soy_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Kei kɛ Pilɑti uu pɛɛ u pisɛ rɛ: Áɑ mmɛ̃ kɑpi nní nɛ pɔ́ n kpɑrɑi kómɛi, nɛ́ɛ? ");
INSERT INTO soy_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Uu kɔ lɛ̃ n sɛ́ɛ́lɛ̃ úu ríkɑ pɛsɛ. Ai pɛɛ Pilɑti pírí wɑi. ");
INSERT INTO soy_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ḿpɑ́ nkpɔ mɛlɔ́ɔ́ ɑnyɑ̃́ ɑ́ye, Pilɑti yɛ̀ɛ̀ ukpɑniikɔ́ uyɛ̃ kɛ risoiwuí ɑri ń lɑ ukɛ́ lesɛ ɑkpɑnii kɛ́mɛɛ lésɛlɛ. ");
INSERT INTO soy_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Utisi unyinɛ kɑpi ḿpɑ́ yei n nyu yɛ pɛɛ ɑnyɑ̃́ kumúŋɛ́ kpɛ-i ɑkpɑnii kɛ́mɛɛ welɛ. Pi yɛ u sée rɛ Yeesu Pɑrɑpɑsi. ");
INSERT INTO soy_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Pilɑti uu pɛɛ pisoi pɛɛ n cɑ́pinɛlɛ̃ pisɛ rɛ: Yeesu Pɑrɑpɑsi nɛ Yeesu kɑpi n sélei rɛ Kirisi kɛcɔpɛ, úye kɑní lɑ kɛ́ ɑkpɑnii kɛ́mɛɛ lesɛ? ");
INSERT INTO soy_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","U pɛɛ nyulɛ ŋmɑɑ ńsɔnɛ rɛ nfɑpɔlɛ nnyɑ kɑpi Yeesu uɑnipɛ-i wɑ. ");
INSERT INTO soy_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilɑti un kei lɛ̃ kɛtúhɑɑnɛ kɛ-i we, likɛ́ nɛ rinsɑ́sɛ, uunɔsi uu pisoi tumpɔ rɛ pikɛ́ u mɑɑ rɛ: Usoi nkó úu ncɑɑi ńkɑ wɑ. A unsímɛ́ kɛ́mɛɛ ɑpɔ́nípɛ mɑhɑ̃. Nɛ kɛsinɛ nkɛ́ uyɛ̃ nnyɑ kɛlɑ́rɛ́ kópɛ kɛnyinɛ kɛ́mɛɛ íwɛ lilɛ hɑ́i. ");
INSERT INTO soy_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ nɛ Pisuifi piwɛ́ɛ́sɛ pin likumúŋɛ́ kpɛ-i pisoi pitɑ́lɑɑnkɛɛ mɑsí rɛ pikɛ́ Pilɑti símisi rɛ ukɛ́ Pɑrɑpɑsi ɑkpɑnii kɛ́mɛɛ lesɛ uu Yeesu pɔ̃́ kopu. ");
INSERT INTO soy_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Uyɔ́ɔpi uu pipisɛ pi kpɑ́ rɛ: Pikɛtɛ́ kɛcɔpɛ, úye kɑní lɑ kɛ́ lesɛ? Api u pɛsɛ rɛ Pɑrɑpɑsi lo. ");
INSERT INTO soy_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Kɛ́ íye Yeesu kɑpi n sélei rɛ Kirisi pɔ̃́ wɑ? Api pinnɛ́í u pɛsɛ rɛ: A kunɑpɛ́ɛ́kɔɔ́ kɛcɑ́ɑ́ u kɑrii! ");
INSERT INTO soy_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Kei kuu kɔ pipisɛ pi rikpɑ́ rɛ: Ncɑɑi ń-ye kuu mpíí wɑ? Api pɛɛ sicɑ́ɑ́ilɑ nɑ́kíísɛ ŋmɑɑ rɛ: A kunɑpɛ́ɛ́kɔɔ́ kɛcɑ́ɑ́ u kɑrii! ");
INSERT INTO soy_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Kɛ Pilɑti uu n yɛ̃́ tɛ ḿpɑ́ un nɛ n símisi, ɑ́i nkpɑ́ni líkɑ yoriyɛnɛ, iwɔ́ɔ in mɛníŋɛ mɛyɑ̃́ cɑ́lɛ̃, uu míni kpísi uu pisoi nnɛ́í inipɛɛ-i ɑnípɛ nɑlɛ uu rɛ: Ái nɛ́ɛ ncée hɛ rɛ pikɛ́ usoi nkó yɛɛ úu ncɑɑi ńkɑ n wɑ kpu. Nɔ́nnɛ́kɔ́ yɛ mmɛ̃! ");
INSERT INTO soy_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Pisoi pɛɛ n cɑ́pinɛlɛ̃ nnɛ́í ɑpi u pɛsɛ rɛ: Ɛɛɛ! Tɔ́ nɛ sirɔ́wɑ̃́ tɔkɛ́ unkpɔ ncɔni n te! ");
INSERT INTO soy_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Kei kɛ Pilɑti uu pɛɛ ɑkpɑnii kɛ́mɛɛ Pɑrɑpɑsi pi lesɛ, uu tíyɛsɛ ɑpi Yeesu isɛ́í súúkɛɛ, uu pi u pɑ rɛ pikɛ́ hɑ kunɑpɛ́ɛ́kɔɔ́ kɛcɑ́ɑ́ kɑrii. ");
INSERT INTO soy_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Uyɔ́ɔpi pisɔ́ɔ́cɑ ɑpi Yeesu kpísi ɑpí nɛ kei kɑpi yɛ n túhɑɑnɛ lompɔ, pisɔ́ɔ́cɑ nnɛ́í ɑpi kei u kɑ́lɑɑpɔ. ");
INSERT INTO soy_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Api ilũ u mɑhɑni ɑpi kukpɛ́lɛnku wɛɛ́ u tɑni. ");
INSERT INTO soy_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Api pɛɛ sinípɛleépi rikɔŋ pɑrii ɑpi u kipisɛ, ɑpi kɔ kɛnɑɑpi kunípɛ lukɛ-lukɛ-mɛ̃ u múísɛ. Api pɛɛ ukɛyu-i wúlɑ ɑpi sɛ́nnyi ɑpi rɛ: Tɔ pɔ́ yɑ́ɑsi, Pisuifi uyɔɔpi! ");
INSERT INTO soy_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Api pɛɛ mɛtɑ u n túkɛntɛ. Api yɛ kɔ kɛnɑɑpi kɛ̃ kpísi ɑpí nɛ ríyu kɛcɑ́ɑ́ u pepu. ");
INSERT INTO soy_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Kɑpi nnyei u m mɑsí, ɑpi kukpɛ́lɛnku u mɑhɑni ɑpi uilũ pitɑnɛ u pɛsɛ ɑpí nɛ kunɑpɛ́ɛ́kɔɔ́ kɛcɑ́ɑ́ pikɑrii u tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Kɑpi kuyu-i n léeri pin nɛ Yeesu pikɑrii tɔ́su, ɑpí nɛ Sirɛɛni kɛtẽ utisi unyinɛ sɑ́nɛ. Pi yɛ u sée rɛ Simɔɔ. Api ńnɑŋɛ nɛ Yeesu kunɑpɛ́ɛ́kɔɔ́ u cɔnsɛ. ");
INSERT INTO soy_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Api pɛɛ́ hɑ nɛ kɛlõ kɛnyinɛ tulu. Pi yɛ kei sée rɛ Kɔlikɔtɑ. Liɑsei rɛ: Kúyu Koŋoo kɛlõ. ");
INSERT INTO soy_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Api pítɑ nɛ pitɛ tulɛ-tulɛ pinyinɛ cɔ́hɔnɛ ɑpi u pɑ rɛ ukɛ́ n ntí. Uu lélé uu yúlu rɛ úu nírunɛ. ");
INSERT INTO soy_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Api u kpísi ɑpí hɑ kunɑpɛ́ɛ́kɔɔ́ kɛcɑ́ɑ́ kɑrii, ɑpi pɑŋɑi ɑpí nɛ pimɛcɔpɛcirɛ uilũ hɔɔnɛntɛ. ... ");
INSERT INTO soy_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Api pɛɛ kei n tũ pin u mɛ̃́. ");
INSERT INTO soy_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Api kɛkpénkpélépi kɛnyinɛ kɛcɑ́ɑ́ wɔ́lu lɛ̃ nnyɑ kɑpi u ń kpu ɑpi kunɑpɛ́ɛ́kɔɔ́-i uriyu kɛcɑ́ɑ́ kɑrii. Pi wɔi rɛ: Nkó yɛɛ Yeesu, Pisuifi uyɔɔpi. ");
INSERT INTO soy_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Api pɛɛ kɔ limɛmɑ́ɑ́ pisoi kpɑ́ɑ́ree pitɛ́ pinyinɛ kɛsẽ́ kɑrii, ucɔ ukulukɛ-lukɛ-mɛ̃ ucɔ ukumii-mɛ̃ ɑpí nɛ u kɔ. ");
INSERT INTO soy_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Picéetɔŋɛ́ ɑpi u lɑ́mɑɑnkɛɛ ɑpi ríyu m pɔuli. ");
INSERT INTO soy_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Api yɛ u mɑɑ rɛ: Pɔɔ́ yɛ Uléécɑɑ kɛyɔ n forii ɑɑ siyɑ́ɑ sitɑɑni nɛ pimɔ́mɛ kɛ pɛsɛ, pɔn mɛsei Uléécɑɑ Kɛpipi, ɑ nkpéni ripɔ́yu lɔ ɑɑ kunɑpɛ́ɛ́kɔɔ́ kɛcɑ́ɑ́ súiri! ");
INSERT INTO soy_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ nɛ isé picélɑɑ nɛ Pisuifi piwɛ́ɛ́sɛ pɔ́ɔ kɔ limɛcɔ kɛcɑ́ɑ́ u nyɑ́nɛi ɑpi yɛ nɛ mɑɑ rɛ: ");
INSERT INTO soy_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","U picɔ yoriyɛntɛlɛ ɑmɑ́ úu pɛɛ fe ukɛ́ uricuruu yoriyɛ! Nɛ́ntɛ Isirɑyɛɛli Uyɔɔpi lo! Ukɛ́ kɔ kunɑpɛ́ɛ́kɔɔ́ kɛcɑ́ɑ́ súimɛ tɔkɛ́ pɛɛ́ nɛ kɛfɑ u tɛnɛ. ");
INSERT INTO soy_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Uléécɑɑ kuú nɛ ritɑ́ uu yɛ nɛ mɑɑ rɛ: Nɛ Uléécɑɑ Kɛpipi lɛ. Lɛ̃ nnyɑ, in tɛ Uléécɑɑ yɛ ukɛcɑ́ɑ́ kpɑ́lɛ̃, ukɛ́ nkpéni u yoriyɛ tɔkɛ́ yɛ̃́ nkɛ̃́! ");
INSERT INTO soy_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Hɑ́i ɑí nɛ pisoi kpɑ́ɑ́ree pɛ̃ kɛtɛ́ kɑpi kɛsẽ́ n kɑrii pɛ́nɛ ɑpi kɔ lɛ̃ u lɑ́misi. ");
INSERT INTO soy_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ituŋɛ kɛcírɛ kumúŋɛ́ hɑ́i nɛ kɛtúŋɛ́ mɛtɑɑni kumúŋɛ́ kɛ kuŋmɑhɑ ɑku kɛtẽ nnɛ́í kɛcɑ́ɑ́ cɔ̃. ");
INSERT INTO soy_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Kɑi kɛtúŋɛ́ mɛtɑɑni kumúŋɛ́ ń tu, Yeesu uu kɛcɑ́ɑ́ilɑ píimɑ kɛnyinɛ súúni rɛ Elii, Elii lɑmɑ sɑpɑtɑni? Lɛlɛɛ rɛ: Unɛ́léécɑɑ, Unɛ́léécɑɑ, yo nnyɑ kɑɑ nɛ́ ŋmɛriyɛ? ");
INSERT INTO soy_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Pisoi pɛɛ kei n cɑ́pinɛlɛ̃ kɛcɔpɛ, pinyinɛ ɑpi lɛ̃ kom ɑpi rɛ: Elii kuu nní sélei. ");
INSERT INTO soy_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Mɛsɛ nɛ mɛsɛ, pikɛcɔpɛ unyinɛ uu wuru uú hɑ sinɛ́ɛ̃ kpísi uu pítɑ nyɛpɛ-nyɛpɛ pinyinɛ fɛ uú nɛ kɛnɑɑpi kɛnyinɛ kɛcɑ́ɑ́ tuhu uu u pɑ rɛ ukɛ́ n ntí. ");
INSERT INTO soy_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Picɔ ɑpi pɛɛ rɛ: Ani riyɑ́ tɔkɛ́ yɛ̃́ tɛ Elii yɛ́ kɑm uu u yoriyɛ nɛ́ɛ. ");
INSERT INTO soy_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yeesu uu mɛyɑ̃́ pipupɛi kpɑ́ uu pɛɛ kpi. ");
INSERT INTO soy_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Likumúŋɛ́ kpɛ-i kɛ kusɑ́ŋɑ́ɑ́ kɑpí nɛ Uléécɑɑ kɛyɔ kɛ́mɛɛ n kénɛlɛ̃ ɑku ricɛɛ́rinɛ mɛtɛ́ hɑ́i kɛcɑ́ɑ́ nɛ mɛtene-pɔ. Kɛtẽ ɑkɛ yéŋesi, ɑpɑrɛcɑŋɑɑ ɑɑ forɛsi, ");
INSERT INTO soy_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ɑkpíí mɛyɑ̃ ɑɑ wúkulɛntɛ, Uléécɑɑ pisoi kulúi pɛɛ n kpí ɑpi yisikɛɛ. ");
INSERT INTO soy_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Api ɑkpíí kɛ́mɛɛ léenti. Kɛ Yeesu uu ń kɑ uu nkpɔ kɛ́mɛɛ yisi, ɑpi Uléécɑɑ kuyu lompɔ, pisoi mɛyɑ̃ ɑpi pi yɛnu. ");
INSERT INTO soy_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Kɛ Rɔm usɔ́ɔ́cɑ kpéẽ nɛ pisɔ́ɔ́cɑ picɔ pɛɛ kei ń we pin kɛsẽ́ Yeesu mɛ̃́ ɑpi n yɛ̃́ lɛ̃ kɛ kɛtẽ ɑkɛ n yéŋesi nɛ licɔ licɔ lɛɛ n wɑpisi, iwɑmɛ ii mɛyíkíyiki ŋmɑɑ pi loni ɑpi rɛ: Usoi nkó yɛ pɛɛ mɛsei Uléécɑɑ Kɛpipi lɛ. ");
INSERT INTO soy_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Pinɔ́si yɛ pɛɛ kulúi welɛ, pin kɛtɑɑ-pɔ nyɛnu pin nyɑ́nɛi. Pimɛyɑ̃ pɛɛ hɑ́i Kɑlilee-pɔ u ritikimɛ pin u lɛ́ni. ");
INSERT INTO soy_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Pikɛcɔpɛ pinyinɛ pɛɛ nní Mɑkitɑlɑ kuyu ukɔ́ Mɑɑri nɛ Yɑkupu nɛ Yosɛfi uni Mɑɑri nɛ Sepetee piŋmɑ́nɛ uni. ");
INSERT INTO soy_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Kɑi nnyɔ́ɔ́ n wɑ, utisi mɑ́mɑ́ uyɛ̃ kɑpi yɛ n sée rɛ Yosɛfi un Arimɑtee kuyu ukɔ́, uú hɑpɔ. Uyɛ̃ nɛ kɔ pɛɛ Yeesu upirɛtiki lɛ. ");
INSERT INTO soy_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Uu Pilɑti kɛ́mɛɛ sĩ́ uú hɑ u pisɛ rɛ ukɛ́ Yeesu u pɑ. Kei kɛ Pilɑti uu ŋmurɛi uu ncée hɛ rɛ pikɛ́ hɑ Yeesu u pɑ. ");
INSERT INTO soy_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yosɛfi uu Yeesu kpísi uu kɛsɑ́ŋɑ́ɑ́pi tomɛ́ kɛcirɛ-i wɑi ");
INSERT INTO soy_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","uú hɑ nɛ nhórɛ fɑlɛ kuu kupɑrɛpoo-i n wɑ kɛ́mɛɛ u finsɛ, uu pɛɛ mɛpɑrɛ píimɑ mɛnyinɛ pímiisɛ uu rinɔnɔɔ fi, uu pɛɛ yɑ́ uu tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Likumúŋɛ́ kpɛ-i, Mɑkitɑlɑ kuyu ukɔ́ Mɑɑri nɛ Mɑɑri ucɔ uyɛ̃ pɔ́ɔn kei rikpíí kɛyúrí tṹ. ");
INSERT INTO soy_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Kɛ kɛyɑ́ɑ kɛɛ yɛ nɛ kɛwéntɛyɑɑ n tisɛ ɑkɛ n tu, pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ nɛ Pifɑrisi ɑpi yisi ɑpi Pilɑti kɛyɔ sĩ, ");
INSERT INTO soy_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ɑpi u mɑɑ rɛ: Urɔ́sɑ́ɑ, tɔ léisɛ rɛ kɛ unɔ́ɔmɛ nkó uú pɛɛ nfɑ́ɑ m mɑ́, u pɛɛ́ mɑɑ rɛ u yɛ́ unkpɔ mɛmɑ́ɑ́ kɛyɑ́ɑ tɑ́ɑ́nũ tuŋɛ́ yisi. ");
INSERT INTO soy_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Lɛ̃ nnyɑ, ɑ ncée hɛ rɛ pisoi pikɛ́ hɑ siyɑ́ɑ sitɑɑni urikpíí ńsɔnɛ m mɛ̃́, upipirɛtiki ɑ́pi kɑpɛ nɛ u n yɑ́ɑi pikɛ́ lesɛ, pikɛ́ pɛɛ́ nɛ pisoi n kirɑɑsɛ rɛ: u nkpɔ kɛ́mɛɛ yisilɛ nnyɑ. Lin lɛ̃ n wɑ, nnɔ́ɔmɛ mmɛ̃ nɛ́ pɛɛ cɑɑi ɑi nfoí feriyɛ. ");
INSERT INTO soy_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilɑti uu pi pɛsɛ rɛ: Pimɛ́rɛ́ yɛ mpí! Ani nɛ pi hɑ pikɛ́ hɑ rikpíí m mɛ̃́ yɑrɛ kɑni ń lɑ. ");
INSERT INTO soy_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Kei kɑpi yisi ɑpí hɑ músu, ɑpi yɛ́nu lɛ̃ kɑpi yɛ́ pimɛ́rɛ́kɛi pɛ̃ n wɑ. Api mɛpɑrɛ mɛɛ rinɔnɔɔ n fílɛ̃ ńsɔnɛ kɑrii ɑpi pɛɛ pimɛ́rɛ́ tónsɛntɛ rɛ pikɛ́ m mɛ̃́. ");
INSERT INTO soy_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Kɛyɑ́ɑ kɛɛ nɛ kɛwéntɛyɑɑ rintíki kɛtúŋɛ́, Mɑɑri Mɑkitɑlɑ ukɔ́ nɛ Mɑɑri ucɔ ɑpi yisi rɛ pikɛ́ hɑ rikpíí rilóólú. ");
INSERT INTO soy_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Kei nní, kɛtẽ ɑkɛ yéŋesi, Upíimɑ uleecɑɑtumɛ unyinɛ uu kɛyómɛcɑɑ-pɔ súiri uu mɛpɑrɛ mɛɛ rikpíí rinɔnɔɔ n fílɛ̃ pímiisɛ uu rikɛcɑ́ɑ́ tonɛ. ");
INSERT INTO soy_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","U pɛɛ tɛ́lulɛ yɑrɛ kɛkónɛtɛ́hɛ, uilũ in wɑriyɛ póí-póí. ");
INSERT INTO soy_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Liiwɑmɛ píimɑ inyinɛ ii pimɛ́rɛ́ tini, ɑpi pɛɛ́ n tɛrii nfɑ́ɑ nń nɛ pɑ́rí yɑrɛ pi kpulɛ. ");
INSERT INTO soy_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Uléécɑɑtumɛ uyɛ̃ uu pɛɛ pinɔ́si pɛ̃ mɑɑ rɛ: Iwɑmɛ íi kɑpɛ nɔ̃́ n we. Nɛ yɛ̃ tɛ Yeesu uyɛ̃ kɑpi kunɑpɛ́ɛ́kɔɔ́ kɛcɑ́ɑ́ n kɑrii kɑni wɛ́ɛ́si. ");
INSERT INTO soy_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Úu nté we. U nkpɔ kɛ́mɛɛ yisilɛ yɑrɛ kuu ḿ mɑ. Ani kɑm ɑni kei kɑpí pɛɛ u n finsɛ yɛ̃, ");
INSERT INTO soy_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ɑni mɛkɛɛ sĩ ɑní hɑ upipirɛtiki símisi rɛ u nkpɔ kɛ́mɛɛ yisilɛ. U yɛ́ Kɑlilee-pɔ pi m mɛ̃́. Kei kɑni yɛ́ hɑ u yɛ̃. Mmɛ̃ kɑm m mɑ́ kɛ́ nɔ́ n símisi yɛ mmɛ̃. ");
INSERT INTO soy_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Api pɛɛ rikpíí kɛkúrí yisi, iwɑmɛ nɛ mpɔ́ɔnɑrɛ píimɑ nn pi we ɑpí hɑ mɛkɛɛ nsímɛ́ mmɛ̃ upipirɛtiki símisi. ");
INSERT INTO soy_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Likɛ́ nɛ rinsɑ́sɛ, Yeesu uú nɛ pinɔ́si pɛ̃ sɑ́nɛ uu pi mɑɑ rɛ: Nɛ nɔ́ yɑ́ɑsi. Api ukɛkúrí hɑpɔ, ɑpi wúlɑ ɑpi uɑnɑ tini ɑpí nɛ ríyu u wɑisɛ. ");
INSERT INTO soy_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yeesu uu pɛɛ pi mɑɑ rɛ. Iwɑmɛ íi kɑpɛ nɔ́ n we. Ani hɑ pinɛ́mɑ́rɛcɔ mɑɑ rɛ pikɛ́ Kɑlilee hɑ. Kei kɑpi yɛ́ hɑ nɛ́ yɛ̃́. ");
INSERT INTO soy_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Kumúŋɛ́ kpɛ-i kɛ pinɔ́si pɛ̃ ɑpi ncée ń we pin tɔ́su, rikpíí pimɛ́rɛ́ pinyinɛ ɑpi yisi ɑpi kuyu pɛlɛ, ɑpí hɑ pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ lɛ̃ nnɛ́í lɛɛ n wɑ kɛɛnkɛɛ. ");
INSERT INTO soy_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Pɛ̃ nɛ piwɛ́ɛ́sɛ ɑpí tonɛ ɑpi kómɛinɛ, ɑpi siwóó píimɑ sinyinɛ pimɛ́rɛ́ pɛ̃ hɛ ");
INSERT INTO soy_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ɑpi kɔ pi tɑ́lɑɑnkɛɛ rɛ pikɛ́ mɑɑ rɛ: Tɔ kɛsinɛ lɔpilɛlɛ, upipirɛtiki ɑpí weri ɑpi u yɑ́ɑ́i ɑpí nɛ tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Piwɛ́ɛ́sɛ pɛ̃ ɑpi kɔ pi kpɑ́ rɛ: Uyɔ́ɔpi píimɑ un lɛ̃ n kõ, tɔ́ u símisi uu kóm ɑ́ni yɛ́ ncɔ́ŋ ńkɑ yɛ̃. ");
INSERT INTO soy_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Pimɛ́rɛ́ pɛ̃ ɑpi mɛsei siwóó sɛ̃ yɔ́su ɑpi lɛ̃ kɑpi pi n céesi wɑi. Lɛ̃ nnyɑ kɛ nsímɛ́ mmɛ̃ nń we nɛ nɛni-mɛ nn nɛ Pisuifi kɛ́mɛɛ kɔ́ɔ́núlɛ̃. ");
INSERT INTO soy_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Yeesu pipirɛtiki kɛfi nɛ usɛ ɑpi yisi ɑpi Kɑlilee-pɔ riyɔ́pɛ tɛ-i kɛ Yeesu uú pɛɛ ḿ mɑɑ rɛ pikɛ́ hɑ sĩ. ");
INSERT INTO soy_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Kɑpi u n yɛ̃́, ɑpi u yɑ́ɑ́si ɑpi ukɛyu-i wúlɑ. Amɑ́ picɔ pin nɛ we pin céreisɛ. ");
INSERT INTO soy_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yeesu uú nɛ pi kɔ uu pi mɑɑ rɛ: Uléécɑɑ yɛ kɛyómɛcɑɑ-pɔ nɛ kɛtẽ nté ḿpɑ́ yo kɛcɑ́ɑ́ ńnɑŋɛ nɛ́ hɛlɛ. ");
INSERT INTO soy_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Lɛ̃ nnyɑ, ɑni isoipuri nnɛ́í kɛ́mɛɛ hɑ, ɑni tíyɛsɛ pisoi pikɛ́ kɛnɛ́pirɛ ritiki. Ani Sɑ́ɑ Uléécɑɑ nɛ Kɛpipi nɛ Nfɑ́ɑsɔnɛ rinyiri nɛ míni pi wolɛ. ");
INSERT INTO soy_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ani kɔ pi céési rɛ pikɛ́ isé iyɛ̃ nnɛ́í kɑm nɔ́ n kɑrii ritiki. Ani n nyu rɛ siyɑ́ɑ nnɛ́í kɑm nɔ́kɛnɛ́kúrí we kɛtẽ kɛkɛ́ hɑ nɛ tɛnɛ.");
INSERT INTO soy_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Nté kɑi wɔ́lɑɑlɛ̃ lɛ̃ kɛ Yeesu Kirisi, Uléécɑɑ Kɛpipi Nsímɛ́ Kɛcirɛ nn n kóri. ");
INSERT INTO soy_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Li ɑntepu Esɑyi ritɛlɛ́-i wɔ́lɑɑlɛ̃ tɛ: Nɛ́ unɛ́tumɛ kɛpɔ́kpéẽ wɑisɛ ukɛ́ ncée pɔ́ nyɔ́ɔnsɛ. ");
INSERT INTO soy_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Usoi rinɔɔ yɛ ri tɛɛ kucɛsi kóimɑ-i n yóólɛ̃ tɛ: Ani Upíimɑ ncee nyɔ́ɔnsɛ, ɑni usiceepi tɛ̃iisɛ. ");
INSERT INTO soy_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Lɛ̃ kɑi wɑ Yohɑni uu kucɛsi kóimɑ-i pisoi míni wolɛ, un pi símisi rɛ: Ani mɛfinɛ consɛ, ɑni tíyɛsɛ kɛ́ míni nɔ́ wolɛ, Uléécɑɑ uu nɔ́ɑnɛ́kópɛ nɔ́ sɑ́rɛi. ");
INSERT INTO soy_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Yutee kɛtẽ pikɔ́ nnɛ́í nɛ Yerusɑlɛm pikɔ́ nnɛ́í ɑpi ukɛmɛɛ́ n sɔ́nɑɑpɔ pin piɑkópɛ yɑ́mnɛntɛ, Yohɑni uu Yuritɛɛ nkoi kɛ́mɛɛ míni pi wolɛ. ");
INSERT INTO soy_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Kuyooyoo nkpíí kɛtukɑnkɑ kɛ Yohɑni uú pɛɛ tɑnɑɑlɛ̃ un kɛkónɛpɑmpi kɛhɑlɛ-i tɛ́lɛ̃. Apɑ́ɑ́ni nɛ mɛtɛ̃́ kuú pɛɛ le ");
INSERT INTO soy_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","un yóólɛ̃ tɛ: Uyɛɛ nɛ̃́ mɛmɑ́ɑ́ n sɔ́nti yɛ ńnɑŋɛ nɛ̃́ felɛ. Inɛ́soi íi tu rɛ kɛ́ ripɛ kɛ́ ukunɛ́ɛ́ri nŋmɛ fénnɛ. ");
INSERT INTO soy_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Míni kɛ nɛ́ɛ nɛ nɔ́ wólɛ, ɑmɑ́ Nfɑ́ɑsɔnɛ kɛ uyɛ̃ uu yɛ́ nɛ nɔ́ wolɛ. ");
INSERT INTO soy_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Yeesu uu pɛɛ Kɑlilee kuyu kunyinɛ kɑpi yɛ n sée rɛ Nɑsɑrɛti leeri, Yohɑni uu Yuritɛɛ nkoi kɛ́mɛɛ míni u wolɛ. ");
INSERT INTO soy_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Kɛ Yeesu uu mɛsɛ nɛ mɛsɛ míni-i n léemɛ, uu kɛyómɛ yɛnu kɛn wúkulɛlɛ̃, Nfɑ́ɑsɔnɛ nn ukɛcɑ́ɑ́ súiri yɑrɛ tilɔ́ɔlɑ̃. ");
INSERT INTO soy_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Uu rinɔ́ɔ kɛyómɛcɑɑ-pɔ komti rɛ: Pɔ́ɔ Kɛnɛ́pipi lɑlɑ kɛcirɛ. Nɛ pɔ́ wɛ́ɛlɛ. ");
INSERT INTO soy_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Mɛsɛ nɛ mɛsɛ Nfɑ́ɑsɔnɛ nń nɛ kucɛsi kóimɑ-pɔ Yeesu sĩ. ");
INSERT INTO soy_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Uu kei n we hɑ́i nɛ siyɑ́ɑ ɑfɛɛnɑ. Kei kɛ Setɑni uu u peikɛɛ. Icɑrɛsɛɛ kɛpɑ́ɑ́pɑ́ɑ́ kuu yɛ n we, piléécɑɑtumɛ pin ukɛcɑ́ɑ́ pɑílɛ̃. ");
INSERT INTO soy_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Kɑpi Yohɑni kukpɑniilee n tɑ̃ mɛmɑ́ɑ́, Yeesu uu Kɑlilee sĩ uu Uléécɑɑ Nsímɛ́ Kɛcirɛ n yóólɛ̃ ");
INSERT INTO soy_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","un símisi rɛ ituŋɛ yɛ tulɛ, Uléécɑɑ iyɔɔpi yɛ nyɑhɑimɛlɛ, ɑni mɛfinɛ consɛ ɑni Nsímɛ́ Kɛcirɛ ŋmurɛi. ");
INSERT INTO soy_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Kɛ Yeesu uu Kɑlilee kupiyɛ mɛcɑ́ɑ n tíkilɛ̃, uu Simɔɔ nɛ uuwɑ̃ Antiree yɛnu pin ɑnyɛŋ́ fóm pin nɛ ikpíntomɛ́ cɔ́pii. Pi pɛɛ pikpíntomɛ́cɔ́pii lɛ. ");
INSERT INTO soy_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yeesu uu pɛɛ pi mɑɑ rɛ: Ani nɛ́ ritiki, nɛ́ tíyɛsɛ ɑni pisoi pɛɛ yɛ́ nɛ́ rintíki wɛ́ɛ́si. ");
INSERT INTO soy_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Api mɛsɛ nɛ mɛsɛ piɑnyɛŋ́ sɑ́ ɑpi u tiki. ");
INSERT INTO soy_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Kɛ Yeesu uu nsẽ́ ń nɔŋ́lɛ̃, uú hɑ Sepetee sipipi Yɑkupu nɛ uuwɑ̃ Yohɑni yɛnu pin piɑnyɛŋ́ nyɔ́ɔnsɛ. ");
INSERT INTO soy_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yeesu uu mɛsɛ nɛ mɛsɛ pi séi, ɑpi piusɑɑ Sepetee nɛ pikɛikɔ́ kúninɔi-i tíyɛ ɑpi u tiki. ");
INSERT INTO soy_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yeesu nɛ upipirɛtiki ɑpi Kɑpɛrinɑwum sĩ. Yeesu uu mɛsɛ nɛ mɛsɛ kɛwéntɛyɑɑ kɛtúŋɛ́ Pisuifi kuyomɛyɑ́hɑɑlee loni uu pisoi picélɑɑ kɑ́pɑ́ɑ́. ");
INSERT INTO soy_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Pírí kɛ umɛcélɑɑ ɑmɛ kɛyɑ́ɑ kɛ̃ pisoi pɛ̃ nnɛ́í pɛɛ kutu u n cɔ́lɛ̃ we, likumúŋɛ́ rɛ umɛcélɑɑ nɛ isé picélɑɑ mɛcélɑɑ ɑ́mɛ sɑ́. Amɑ́ uyɛ̃ nɛ pɛɛ pisoi céésilɛ nɛ n-yɔ́ɔpinɑŋɛ. ");
INSERT INTO soy_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Kumúŋɛ́ kpɛ-i, usoi unyinɛ kɛ ɑníri ɑɑ m pɛkɛsi uu Pisuifi kuyomɛyɑ́hɑɑlee-i lompɔ, uu pupɛi rɛ: ");
INSERT INTO soy_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Ń-ye kɑɑ́ nɛ rɔ́ wɛ́ɛ́si, Nɑsɑrɛti ukɔ́ Yeesu? Pɔ kɑlɛ rɛ pɔkɛ́ rɔ́ nɑ̃́ɑ? Nɛ pɔ́ nyulɛ rɛ Uléécɑɑ yɛ pɔ́ wɛ́ɛlɛ uu iyɑɑ yekei. ");
INSERT INTO soy_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yeesu uu kuníri kpɛ̃ sɛmni uu rinɔ́ɔ ku hɛ rɛ: A kei risɛ́ɛ́, ɑɑ usoi uyɛ-i lelu. ");
INSERT INTO soy_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Kuníri kpɛ̃ ɑku usoi uyɛ̃ lémesi ɑku ukɛmɛɛ́ lelu kun pupukɛɛ. ");
INSERT INTO soy_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ai pinnɛ́í nnɔ́ɔ yipu ɑpí m písɛinɛ rɛ: Yoo nní? Icélɑɑ fɑlɛ inyinɛ yɛ nyi nɛ innɑŋɛ! Ḿpɑ́ ɑníri kuu rinɔ́ɔ hɛ, ɑ́ɑ yɛ ti rilɔ́ɔ́. ");
INSERT INTO soy_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Mɛsɛ nɛ mɛsɛ Yeesu nsímɛ́ nn Kɑlilee kɛtẽ nnɛ́í kɔ́ɔ́nú. ");
INSERT INTO soy_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Api Pisuifi kuyomɛyɑ́hɑɑlee-i léeri ɑpí nɛ Simɔɔ nɛ Antiree kɛyɔ n tɔ́su, Yɑkupu nɛ Yohɑni pin tikilɛ̃. ");
INSERT INTO soy_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Api Simɔɔ ulɔ́hɔ́ni lɛɛpɔ un finu nɛ kupiŋɛtoi. Kɛ Yeesu uu n tuipɔ, ɑpi unɔ́si uyɛ̃ nsímɛ́ u wɑi. ");
INSERT INTO soy_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yeesu uú nyɔsɔ́pɔ, uu ukunipɛ tini uu u yukusɛ. Kupiŋɛtoi ɑku mɛsɛ nɛ mɛsɛ tɛnɛ, uu yisi uu pikɛcɑ́ɑ́ pɑí. ");
INSERT INTO soy_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Mɛtuŋɛlolɛ́-mɑɑ́, pisoi ɑpí nɛ pitóikɔ́ ncɔpuri nɛ pinírihélɑɑ Yeesu lɛɛpɔ. ");
INSERT INTO soy_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kuyu pikɔ́ nnɛ́í ɑpi kɛ́yɔ kɛ̃ tipoo yipu. ");
INSERT INTO soy_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yeesu uu pisoi mɛyɑ̃ itói ncɔpuri pɔisɛntɛ, uu kɔ ɑníri mɛyɑ̃ lɑkɑsɛ. Úu tíyɛsɛ ɑníri ɑkɛ́ rinɔ́ɔ mɑlɛ, kɛ ɑricuruu ɑɑ u nyu nnyɑ. ");
INSERT INTO soy_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kɑi n weesi, Yeesu uú nɛ kɛsinɛ tɔrɔɔ kɛ́yɔ lelu. Uu iyɑɑ sĩ uú hɑ kei umɛcirɛ kɛyómɛ n yɑ́ɑ́si. ");
INSERT INTO soy_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simɔɔ nɛ upicɔ ɑpi pɛɛ piwɛ́lɑɑ u loni. ");
INSERT INTO soy_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Kɑpi u n yɛ̃́ ɑpi u mɑɑ rɛ: Pisoi nnɛ́í pɛɛ pɔ́ wɛ́ɛ́si. ");
INSERT INTO soy_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Amɑ́ Yeesu uu pi mɑɑ rɛ: Tɔkɛ́ kɛlõ féé hɑ, ɑyu ɑcɔ-i, li pisɛ rɛ kɛ́ kɔ kei Nléécɑɑsimɛ́ símisi, likumúŋɛ́ rɛ lɛlɛɛ nɛ nɛ́ kɑ. ");
INSERT INTO soy_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Lɛ̃ kɑi wɑ Yeesu uu Kɑlilee kɛtẽ nnɛ́í kɔ́ɔ́nú un Pisuifi ɑyomɛyɑ́hɑɑlee-i Nléécɑɑsimɛ́ símisi un ɑníri lɑkɑsɛ. ");
INSERT INTO soy_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Uyɔ̃́ unyinɛ uu Yeesu lɛɛpɔ uu ukɛyu-i wúlɑ uú nɛ u téni rɛ: Pɔn n lɑ, pɔ́ nɛ́ wolɛ ɑm funi. ");
INSERT INTO soy_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Uicɔ ii Yeesu íwɛ wɑi hɑ́i, Yeesu uu pɛɛ kunípɛ sɑɑpɔ uu u cɑ, uu lɛ̃ mɛmɑ́ɑ́ u mɑɑ rɛ: Nɛ lɑ rɛ ɑ peí. ");
INSERT INTO soy_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Mɛsɛ nɛ mɛsɛ, utisi uyɛ̃ kɛyɔ̃́ ɑkɛ tɛnɛ uu funi. ");
INSERT INTO soy_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yeesu uu lɛ̃ mɛmɑ́ɑ́ u cɛ́si uu u lɑkɑsɛ ");
INSERT INTO soy_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","un u kúrúrúsɛlɛ̃ tɛ: A ńsɔnɛ kutu ricɔ, kɑpɛ wɑ unyinɛ ukɛ́ mɛwɑi mɛ̃ kõ. Amɑ́ ɑ hɑ uyɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ mɛpɔ́círɛ nyísɛ ukɛ́ yɛ̃́ lɛ̃ kɑɑ ń we. Lɛ̃ mɛmɑ́ɑ́, ɑɑ inyɔ́ɔnsɛ kɛ Moisi isé ii m pisɛ wɑi pɔkɛ́ nɛ ḿpɑ́ úye nyísɛ rɛ pɔ peí. ");
INSERT INTO soy_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Amɑ́ utisi uyɛ̃ uu sĩ́ uu lɛ̃ nnɛ́í kɑi n wɑ ḿpɑ́ yei kɛ́ɛ́nkɛɛ. Lɛ̃ nnyɑ, Yeesu úu yɛ fe ukɛ́ umɛcirɛ riwúí-i pinyísɛ rikpɑ́, ɑmɑ́ iyɑɑ kuú le, kei kɛ úkɑ úu ń we. Pisoi pin ḿpɑ́ mɛ́ye léenti pin ukɛmɛɛ sɔ́nɑɑpɔ. ");
INSERT INTO soy_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Kɑi siyɑ́ɑ rinkɔ́ɔ́nú, Yeesu uu Kɑpɛrinɑwum-i pɛɛri. Pisoi ɑpi kóm tɛ kɛ́yɔ-i kuú we. ");
INSERT INTO soy_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Api cɑ́pinɛpɔ mɑ́ḿ, kɛ́nɑcɔpɛ ɑ́kɛ nkpɑ́ni ripoo ricuruu-i we. Yeesu un Nsímɛ́ Kɛcirɛ pi céési. ");
INSERT INTO soy_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Pinyinɛ ɑpí nɛ kɛ́kɑnkɑ́lɑ́kɑ́ u weri kɛ pisoi pinɑ ɑpi n topori. ");
INSERT INTO soy_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Amɑ́ ɑpi pɔɔnɛ pikɛ́ Yeesu kɛ nyísɛ, kɛ pisoi ɑpi kulúi ń tɔsí nnyɑ. Api kulee kpɛ-i kɛ Yeesu uu ń we piriyɛ, ɑpi kupólɛ kpɛ̃ kumúŋɛ́ kɛ Yeesu uu n nyɛnu kɛ́kɑnkɑ́lɑ́kɑ́ kɛ̃ cɛpisɛpɔ nɛ kɛrisɑ́ŋɑ́ɑ́pɔrɛ́. ");
INSERT INTO soy_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Kɛ Yeesu uu pinfɑtɛnɛ n yɛ̃́, uu kɛ́kɑnkɑ́lɑ́kɑ́ mɑɑ rɛ: Kɛnɛ́pipi, nɛ ɑpɔ́kópɛ pɔ́ sɑ́rɛi. ");
INSERT INTO soy_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Isé picélɑɑ pinyinɛ pɛɛ kei n tṹ ɑpi pisifɑ-i túhɑɑnɛ rɛ: ");
INSERT INTO soy_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Yo nnyɑ ŋmɑɑ kɛ usoi nkó uu nní lɛ̃ símisi? Uléécɑɑ kuu lɑ́misi. Wóo yɛ́ mpíí fe ukɛ́ ɑkópɛ sɑ́rɛi, Uléécɑɑ mɛmɑ́ɑ́? ");
INSERT INTO soy_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yeesu uu pinfɑsimɛ́ cérupɔ uu pi mɑɑ rɛ: Yo nnyɑ kɑni nfɑsimɛ́ mmú mpuri mɑ́? ");
INSERT INTO soy_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Kɛ́ kɛ́kɑnkɑ́lɑ́kɑ́ ḿ mɑɑ rɛ: Nɛ ɑpɔ́kópɛ pɔ́ sɑ́rɛi yɛɛ pɔ́ɔ́lú nɛ́ɛ kɛ́ kɛ ḿ mɑɑ rɛ: A yisi ɑɑ ripɔ́sɑ́ŋɑ́ɑ́pɔrɛ́ pílɛsi, ɑɑ sɔ́nɛ yɛɛ yɛ́ m pɔ́ɔ́lú? ");
INSERT INTO soy_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Nɛ lɑ kɛ́ nɔ́ céreisɛ rɛ Usoi Kɛpipi yɛ kɛtẽ kɛcɑ́ɑ́ ńnɑŋɛ mɑ́lɛ kɛkɛ́ nɛ pisoi ɑkópɛ pi sɑ́rɛi. ");
INSERT INTO soy_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Uu pɛɛ kɛ́kɑnkɑ́lɑ́kɑ́ rinɔ́ɔ pimɑ́ɑ kpɑ́ rɛ: Nɛ́ɛ pɔ́ mɑ, ɑ yisi ɑɑ ripɔ́sɑ́ŋɑ́ɑ́pɔrɛ́ pílɛsi ɑɑ́ kulu. ");
INSERT INTO soy_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Utisi uyɛ̃ uu ḿpɑ́ úye inipɛɛ-i yisi uu mɛsɛ nɛ mɛsɛ urisɑ́ŋɑ́ɑ́pɔrɛ́ sɑ́kɑɑ uú kulu. Ai pisoi mɑɑmɑ́ɑ́ci wɑi ɑpi Uléécɑɑ ríyu wɑisɛ pin mɑ́ikɛɛ rɛ: Ári píkɑi mɛwɑi mmɛ́ mɛcɔ yɛnɑɑlɛ̃. ");
INSERT INTO soy_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Kɛ Yeesu uu Kɑlilee kupiyɛ ritimɛ-mɛ̃ m pɛlɛ, pisoi kulúi ɑpi ukɛmɛɛ́ n sɔ́nɑɑpɔ un pi céési. ");
INSERT INTO soy_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Kuu n tɔ́su, uu Alifee uŋmɑ́nɛ Lefi yɛnu un lɑmpoo kɛyɔ́ɔ́-i tṹ. Yeesu uu u mɑɑ rɛ: A nɛ́ ritiki. Lefi uu yisi uu u tiki. ");
INSERT INTO soy_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Kɛ Yeesu uu Lefi kɛyɔ-i ilukɛ n le, u nɛ pilɑmpooyɔɔ́ mɛyɑ̃ nɛ pikópɛkɔɔ́ nɛ upipirɛtiki pɛɛ kɛsẽ́ li. Pisoi mɛyɑ̃ pɛɛ yɛ u n tikilɛ̃. ");
INSERT INTO soy_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Kɛ isé picélɑɑ pɛɛ Pifɑrisi kulɑmɑɑsinɛlee-i ń we ɑpi Yeesu n yɛ̃́ un nɛ pisoi pɛ̃ mpuri ilukɛ le, ɑpi upipirɛtiki mɑɑ rɛ: Yo nnyɑ kɛ Yeesu nɛ pilɑmpooyɔɔ́ nɛ pikópɛkɔɔ́ ɑpi kɛsẽ́ le? ");
INSERT INTO soy_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yeesu uu pinsímɛ́ kóm uu rinɔ́ɔ pi yɔ́su rɛ: Ái pisoi pɛɛ isɑrɛ n lɑ́ɑ́rú nnyɑ kɛ upɔisɛ uú we, ɑmɑ́ pitóikɔ́ nnyɑ kuú we. Ái pisoi pɛɛ ɑsei n tíkilɛ̃ piséi kɑḿ kɑ, ɑmɑ́ pikópɛkɔɔ́ nnyɑ kɑḿ kɑ. ");
INSERT INTO soy_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Kɛyɑ́ɑ kɛnyinɛ kɛ Yohɑni Úniwolɛ pipirɛtiki nɛ Pifɑrisi ɑpi ɑnɔ́ɔ pɑhɑɑlɛ̃, pisoi ɑpi pɛɛ́ hɑ Yeesu pisɛ rɛ: Yo nnyɑ kɛ Yohɑni Úniwolɛ pipirɛtiki nɛ Pifɑrisi ɑpi yɛ ɑnɔ́ɔ pɑɑsi, pɔ̃́ pikɔ́ ɑ́pi yɛ pɛɛ ɑ pɑɑsi? ");
INSERT INTO soy_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yeesu uu rinɔ́ɔ pi yɔ́su rɛ: Nɔ músu rɛ usoi yɛ́ pisɔ́ɔnnɛ ɑnyɑ̃́ n wɑi upisɑnɛ ɑpi pɛɛ ɑnɔ́ɔ m pɑhɑɑlɛ̃ɛ? Aɑí, mmɛ̃ ńn we. Kumúŋɛ́ kpɛ̃ nnɛ́í kɛ unɔ́sikɔ́ uu ɑnyɑ̃́ n wɑi, ɑ́pi ɑnɔ́ɔ pɑɑsinɛ. ");
INSERT INTO soy_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Amɑ́ kɛyɑ́ɑ yɛ wemɛ kɑpi yɛ́ unɔ́sikɔ́ pikɛcɔpɛ ń lesɛ. Kɛyɑ́ɑ kɛ̃ kɛn n tu, pi yɛ́ ɑnɔ́ɔ pɑɑsi. ");
INSERT INTO soy_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Úkɑ úu yɛ kusɑ́ŋɑ́ɑ́ fɑlɛ kɛpɑmpi nɛ kusɑ́ŋɑ́ɑ́ kpurɛ tɑ́pisi. Li yɛ kukpurɛ iŋmɛ túúnlɛ ɑi kupólɛ pérésɛ. ");
INSERT INTO soy_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Úkɑ úu yɛ kɔ pítɑ pelẽ kukónɛnuŋ́ kpurɛ-i súũ, lin lɛ̃ n wɑ, pítɑ pɛ̃ nɛ yɛ ɑnúŋ́ tikpɑ́fúsɛlɛ, ɑi wɑi pítɑ nɛ liɑnúŋ́ yɛ mɛ́woo wɑ. Amɑ́ kunúŋ́ fɑlɛ-i kɑpi yɛ pítɑ pelẽ súũ. ");
INSERT INTO soy_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Kɛwéntɛyɑɑ kɛtúŋɛ́ kɛnyinɛ kɛ Yeesu nɛ upipirɛtiki ɑpi imúí inyinɛ kɛcɑrɛ-i sɔ́nɛ. Upipirɛtiki ɑpi pɛɛ ricéetimɛ mɛpipi n kpééni pin nɛ tɔ́su. ");
INSERT INTO soy_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Pifɑrisi ɑpi pɛɛ Yeesu mɑɑ rɛ: A ripɑí mmɛ-i kɛ pipɔ́pirɛtiki ɑpi ń we. Yo nnyɑ kɛ pipɔ́pirɛtiki ɑpi lɛ̃ kɛ irɔ́sé ii kɛwéntɛyɑɑ kɛtúŋɛ́ n yúlu wɑi? ");
INSERT INTO soy_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yeesu uu rinɔ́ɔ pi yɔ́su rɛ: Áni lɛ̃ kɛ Tɑfiti uu n wɑ kɛyɑ́ɑ kɛ̃ kɛ nkṹ nn u nɛ upikɔ́ m pɛkɛsi píkɑi kɛ́ɛ́nlɛɛ? ");
INSERT INTO soy_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","U Uléécɑɑ kɛyɔ lonlɛ, uu ɑkpɔ́nɔ́ kɑpi Uléécɑɑ n yekei tɑkɑi. Apiyɑtɑɑ yɛɛ yɛ kumúŋɛ́ kpɛ-i Uléécɑɑ usinɑ. Irɔ́sé kɛ́mɛɛ, pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ ŋmɑnɛ pɛɛ ncée mɑ́ rɛ pikɛ́ ɑkpɔ́nɔ́ nyɛ̃ tɑkɑi. Ḿpɑ́ nɛ lɛ̃, Tɑfiti nɛ upikɔ́ yɛ ɑ tɑkɑilɛ. ");
INSERT INTO soy_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yeesu uu kɔ pimɑ́ɑ pi kpɑ́ rɛ: Ái kɛwéntɛyɑɑ nnyɑ kɑpi usoi wɑ, ɑmɑ́ usoi nsɔnɛ nnyɑ kɑpi kɛwéntɛyɑɑ wɑ. ");
INSERT INTO soy_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Lɛ̃ nnyɑ kɛ nɛ̃́ Usoi Kɛpipi ɑm kɛwéntɛyɑɑ ute. ");
INSERT INTO soy_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Lɛ̃ mɛmɑ́ɑ́, Yeesu uu kuyómɛyɑ́hɑɑlee-i pɛɛri. Utisi unyinɛ yɛ pɛɛ kei welɛ un kunípɛ kópɛ mɑ́. ");
INSERT INTO soy_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Pɛpɛɛ kɛyɑ́ɑ kɛ̃ kei ń we, ɑpi kutu n cɔlɛ̃ tɛ Yeesu yɛ́ kɛwéntɛyɑɑ kɛtúŋɛ́ utisi uyɛ̃ pɔisɛɛ? Likumúŋɛ́ rɛ kɛwɑ́ɑ́nɑ́ kɑpi yɛ n wɛ́ɛ́si pikɛ́ nɛ Yeesu n tĩ́. ");
INSERT INTO soy_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yeesu uu unípɛkópɛkɔɔ́ uyɛ̃ mɑɑ rɛ: A yisi, ɑ nyɛrɛ ḿpɑ́ úye ukɛ́ pɔ́ yɛ̃́. ");
INSERT INTO soy_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Yeesu uu pɛɛ pɛpɛɛ nní n nyɑ́nɛi pisɛ rɛ: Íye kɑi irɔ́sé kɛ́mɛɛ pisɛ? Li pisɛ rɛ tɔkɛ́ lisɔnɛ wɑ kɛwéntɛyɑɑ nɛ́ɛ likópɛ kɑi pisɛ rɛ tɔkɛ́ wɑ mɑ́? Li pisɛ rɛ tɔkɛ́ usoi nfɑɑ lɔ nɛ́ɛ li pisɛ rɛ tɔkɛ́ u kpu? Amɑ́ ɑ́pi ŋmurɛi pikɛ́ Yeesu rinɔ́ɔ yɔsí. ");
INSERT INTO soy_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yeesu uu pinnɛ́í nyɑ́nɛi, piicɔ ii kuwɔ́i u wɑi hɑ́i. Uripɔɔ ɑri cɑɑi, ɑtu kɑpi m mɑ́ nnyɑ. Yeesu uu lɛ̃ mɛmɑ́ɑ́ u utisi uyɛ̃ mɑɑ rɛ: A kupɔ́nípɛ nɛ́ rituŋɑ́mɛ. Kuu yɛ́ kunípɛ rińtuŋɑ́pɔ, kunípɛ ɑku pélu. ");
INSERT INTO soy_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Pifɑrisi ɑpi kuyómɛyɑ́hɑɑlee-i léeri, pi nɛ pɛpɛɛ Erooti kɛmúŋɛ́ ń tíkilɛ̃ ɑpi mɛsɛ nɛ mɛsɛ cɑ́pinɛ pikɛ́ yɛ̃́ tɛ íye kɑpi yɛ́ wɑ pikɛ́ nɛ Yeesu kpu. ");
INSERT INTO soy_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Lɛ̃ mɛmɑ́ɑ́, Yeesu uu kei pi yɑ́, u nɛ upipirɛtiki ɑpi Kɑlilee kupiyɛ ritimɛ sĩ. Kɑlilee pikɔ́ mɛyɑ̃ pɛɛ pɛɛ u tikilɛ̃. ");
INSERT INTO soy_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Yutee nɛ Yerusɑlɛm nɛ Itumee nɛ Yuritɛɛ mɛtɛ́ŋ́ nɛ Tiiri nɛ Sitɔɔ sitẽ pikɔ́ mɛyɑ̃ pɛɛ pɛɛ kɔ ukɛmɛɛ sɔ́nɑɑpɔ. Uliwɑiwɑi kɑpi n kṍ yɛɛ nɛ pi sɔ́nɑɑpɔ. ");
INSERT INTO soy_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Yeesu uu pɛɛ upipirɛtiki mɑɑ rɛ pikɛ́ kúninɔi kunyinɛ u nyɔ́ɔnsɛ, pisoi ɑ́pi kɑpɛ u nyikii nnyɑ. ");
INSERT INTO soy_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ái líkɑ, kuu pisoi m pɔisɛntɛ mɛyɑ̃́ nnyɑ kɛ pitóikɔ́ tɔrɔɔ ɑpi yɔ́ɔnɛpɔ, ḿpɑ́ úye un nɑ́ɑ́si ukɛ́ u ricɑ. ");
INSERT INTO soy_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ḿpɑ́ kumúŋɛ́ kúye-i kɛ ɑníri ɑɑ u yɛ̃, ɑ yɛ u riwulɑlɛ, ɑn pupukɛɛ rɛ: Pɔ Uléécɑɑ Kɛpipi lɛ. ");
INSERT INTO soy_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Yeesu uu rinɔ́ɔ ɑ hɛ nɛ ńnɑŋɛ rɛ: Áni kɑpɛ tíyɛsɛ unyinɛ ukɛ́ céri rɛ nɛ́ɛ úye. ");
INSERT INTO soy_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yeesu uu lɛ̃ mɛmɑ́ɑ́ riyɔ́pɛ tɑɑ́ uu pisoi pɛ̃ kuu ń lɑ séi ɑpi u tiki. ");
INSERT INTO soy_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Uu pisoi kɛfi nɛ pitɛ́ wɛ́ɛ. U pi wɛ́ɛlɛ rɛ u nɛ pɛ̃ pikɛ́ n we ukɛ́ yɛ kɔ pi tũ pikɛ́ nɛ Nléécɑɑsimɛ́ rikɔ́ɔ́nú. ");
INSERT INTO soy_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Uu kɔ ńnɑŋɛ pi hɛ pikɛ́ yɛ nɛ ɑníri lɑkɑsɛ. ");
INSERT INTO soy_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Pisoi kɛfi nɛ pitɛ́ pɛ̃ kuu n lésɛ pɛɛ Simɔɔ kɛ Yeesu uu rinyíri n hɛ rɛ Piyɛɛ, ");
INSERT INTO soy_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","nɛ Sepetee sipipi Yɑkupu nɛ uuwɑ̃ Yohɑni kɛ Yeesu uu rinyíri n hɛ rɛ Pɔwɑnɛrɛkɛsɛ. Tinyíri tɛ̃ ɑsei rɛ ikónɛ pisɛnkɛɛ. ");
INSERT INTO soy_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Nɛ Antiree nɛ Filipu nɛ Pɑtelemii nɛ Mɑtiyee nɛ Tomɑɑ, nɛ Alifee kɛpipi Yɑkupu, nɛ Tɑtee nɛ Simɔɔ yɛɛ pɛɛ ukuyu pimúlɛ́ kɛcɑ́ɑ́ n tɔpu, ");
INSERT INTO soy_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","nɛ Yutɑsi Isikɑriyɔɔti yɛɛ Yeesu n tĩ́ uu pilɑ́ɑrɔ ɑnipɛ-i wɑi. ");
INSERT INTO soy_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Lɛ̃ mɛmɑ́ɑ́, Yeesu uu kɛ́yɔ-i pɛɛri. Pisoi ɑpi kɔ pikɑ́lɑɑ u kpɑ́, u nɛ upipirɛtiki ɑ́pi pɛɛ kɛ́yu yɛ̃ pikɛ́ ilukɛ li. ");
INSERT INTO soy_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Kɛ Yeesu pikɔ́ ɑpi lɛ̃ n kṍ, ɑpi piwɛ́lɑɑ u sĩ pikɛ́ nɛ u kui pin músu rɛ li yɛ́ u m pɑnsɛlɛ. ");
INSERT INTO soy_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Uléécɑɑ isé picélɑɑ pɛɛ Yerusɑlɛm n léeri ɑpí m mɑ́ikɛɛ rɛ Pɛlisepulɛ kuu héesi. Api kɔ rɛ ɑníri uyɔɔpi nnɑŋɛ kuu yɛ nɛ ɑníri lɑkɑsɛ. ");
INSERT INTO soy_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yeesu uu pɛɛ pi séi uu kɛnyɑ́rũ pi mɑɑ rɛ: Íye kɛ Setɑni uu yɛ Setɑni lɑkɑsɛ mɑ́? ");
INSERT INTO soy_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kuyɔ́ɔpiyu kusɛ pisoi pin n tɔpu, kuyɔ́ɔpiyu kpɛɛ kpinɛ. ");
INSERT INTO soy_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Lɛ̃ cirɛ kɛ́yɔ kɛsɛ pisoi pin n tɔpu, kɛ́yɔ kɛɛ kpinɛ. ");
INSERT INTO soy_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","In lɛɛ ni, Setɑni un nɛ uricuruu n tɔpu, pihɔ́ɔnɛnɛ pin ukuyɔɔpiyu-i n we, unnɑŋɛ ńn nɔŋ́nɛ. Amɑ́ mɛ́woo knn wɑinɛ. ");
INSERT INTO soy_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Úye un n lɑ ukɛ́ unɑ́ŋɛ-nɑŋɛ kɛyɔ-i lõ ukɛ́ ulikɔ́ yɔsí, u yɛ unɑ́ŋɛ-nɑŋɛ uyɛ̃ íŋmɛ pɑɑsilɛ. Umɛpɑhɑɑ mɑɑ́ kuu yɛ́ fe uu lɛlɛɛ ukɛyɔ-i ń we nnɛ́í yɔ́su. ");
INSERT INTO soy_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Asei kɑm nɔ́ símisi, ɑkópɛ nnɛ́í nɛ ɑlɛ̃́ yɛ kusɑ́rɛi welɛ. ");
INSERT INTO soy_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Amɑ́ úye un Nfɑ́ɑsɔnɛ n lɑ́mɑɑnkɛɛ, ɑkópɛ nyɛ̃ ɑ́ɑ kusɑ́rɛi we, ɑtɛnɛcirɛ́ yɛ nyɛ. Mɛsɛ́rɛ kɑɑ yɛ́ u m pɔ́riilɛ̃. ");
INSERT INTO soy_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Kɑpi Yeesu ḿ mɑɑ rɛ u ɑníri héesilɛ nnyɑ kuu mmú pi rihɑɑ. ");
INSERT INTO soy_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Yeesu uni nɛ upiwɑ̃ ɑpi pɛɛ́ hɑpɔ, ɑpi kɛtɑhɑi nyɛrɛ, ɑpi usoi tumpɔ rɛ pikɛ́ u séemɛ. ");
INSERT INTO soy_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Aí nɛ sɑ́ pisoi kulúi pin Yeesu kɑ́lɑɑlɛ̃. Api pɛɛ u mɑɑ rɛ: A nyɛrɛ nkɛ̃́, upɔ́ni nɛ pipɔ́wɑ̃́ yɛ pɔ́ wɛ́ɛ́si. ");
INSERT INTO soy_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yeesu uu rinɔ́ɔ pi yɔ́su rɛ: Wóo unɛ́ni? Píye pɛɛ pinɛ́wɑ̃́? ");
INSERT INTO soy_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Uu pɛɛ lɛ̃ mɛmɑ́ɑ́ pisoi pɛɛ nní u n kɑ́lɑɑlɛ̃ wérii uu rɛ: Unɛ́ni nɛ pinɛ́wɑ̃́ yɛ mpí. ");
INSERT INTO soy_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Úye un Uléécɑɑ mɛlɑ n wɑi, uyɛɛ unɛ́wɑ̃́ nɛ́ɛ unɛ́yɛ́i nɛ́ɛ unɛ́ni. ");
INSERT INTO soy_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Kɛ Yeesu uu icélɑɑ Kɑlilee kupiyɛ ritimɛ-i n kpɑ́lɛ̃, pisoi kulúi ɑpi u kɑ́lisi ɑi tɔ́su uu mɛsɛ hɑ kúninɔi kɛcɑ́ɑ́ tonɛ. Míni kɛcɑ́ɑ́ kɛ kúninɔi kpɛ̃ ɑku tɔ́silɛ̃, pisoi pin mɛritimɛ nyɛnu. ");
INSERT INTO soy_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Sinyɑ́rũ kuú nɛ icélɑɑ mɛyɑ̃ pi céesi. Uu icélɑɑ iyɛ̃ kɛ́mɛɛ pi mɑɑ rɛ: ");
INSERT INTO soy_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Ani kutu ricɔ ɑni kóm! Utisi unyinɛ yɛɛ ilukɛpuri pifómɛ leemɛ. ");
INSERT INTO soy_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Kuu n fóm, ilukɛpuri icɔ ii ricéetimɛ-i lólu, sinúipi ɑsi i le. ");
INSERT INTO soy_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Icɔ ii kɛpɑrɛ kɛcɑ́ɑ́ kei kɛ ntɑɑi ńn m piyɛ lólu. Kɛ kɛtẽ ɑ́kɛ n címú nnyɑ, ipuri iyɛ̃ ii mɛsɛ nɛ mɛsɛ lɛlu. ");
INSERT INTO soy_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ntuŋɛ nn tɑpu. Kɛ iníŋí íi m pɑpisi nnyɑ, mɛlɛi ɑmɛ kóósi. ");
INSERT INTO soy_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Icɔ ii sinípɛleépi kɛpɑ́ɑ́pɑ́ɑ́ lóipɔ. Sinípɛleépi sɛ̃ ɑsi mɛlɛi hilɑ, ɑ́mɛ pɛɛ ɑpipi torɛsi. ");
INSERT INTO soy_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Amɑ́ ipuri icɔ ii kɛtẽ sɔnɛ nɛ sɑ́, ii lɛlu ii pɑpisi ii kɔ ɑpipi torɛsi, iwéhe icɔ ɑfɛɛtɑɑni, icɔ kuwóó nɛ kɛfi, icɔ pílɛ. ");
INSERT INTO soy_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yeesu uu pi mɑɑ rɛ: Úye un ukómɛ ukɛ́ kṍ. ");
INSERT INTO soy_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Kɛ Yeesu uu lɛ̃ mɛmɑ́ɑ́ iyɑɑ n léepɔ, pɛpɛɛ nɛ u n kɔ́lɛ̃ nɛ upipirɛtiki kɛfi nɛ pitɛ́ ɑpi u pisɛ rɛ ukɛ́ sinyɑ́rũ sɛ̃ ɑsei pi símisi. ");
INSERT INTO soy_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yeesu uu rinɔ́ɔ pi pɛsɛ rɛ: Nɔ̃́ nɛ Uléécɑɑ iyɔɔpi nsímɛ́ mɛɛ m pékɑɑlɛ̃ picére mɑsilɛ, ɑmɑ́ picɔ yɛ ḿpɑ́ yo kómɛilɛ yɑrɛ sinyɑ́rũ. ");
INSERT INTO soy_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Pi yɛ n wiilɛnlɛ, ɑmɑ́ ɑ́pi kɔ pɛɛ nyɑ́ni. Pi yɛ kutu n cɔlɛnlɛ, ɑmɑ́ ɑ́pi kɔ pɛɛ kómɛi. Lɛlɛɛ rɛ ɑ́pi yɛ ŋmurɛi pikɛ́ piisoi consɛ, Uléécɑɑ ukɛ́ piɑkópɛ pi sɑ́rɛi. ");
INSERT INTO soy_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yeesu uu pɛɛ pi mɑɑ rɛ: Áni kɛnyɑ́rũ kɛ̃ kõo? Nɔnsɑ́ kɛ n kõ, íye kɑni yɛ́ pɛɛ́ nɛ sitɔ́rɔɔ nsí nnɛ́í kṍ mɑ́? ");
INSERT INTO soy_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Kei kɛ Yeesu uu pɛɛ kɛnyɑ́rũ kɛ̃ ɑsei pi lesɛ rɛ: Li nkpɑ́ni yɑrɛ nléécɑɑsimɛ́ kɛ utisi uyɛ̃ uu fóm. ");
INSERT INTO soy_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Pisoi picɔ isoi yɛ ricéetimɛ tɛ̃ mɛcɔ welɛ. Pin nléécɑɑsimɛ́ n kõ, Setɑni uu mɛsɛ nɛ mɛsɛ nléécɑɑsimɛ́ kɑpi pikɛmɛɛ n fṍ kpóupɔ. ");
INSERT INTO soy_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Kɛpɑrɛtẽ kɛɛ we yɑrɛ pɛpɛɛ nléécɑɑsimɛ́ n kṍ ɑpi mɛsɛ nɛ mɛsɛ piɑkiŋ kɛ́mɛɛ n yɔ́su nɛ mpɔ́ɔnɑrɛ. ");
INSERT INTO soy_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Amɑ́ ɑ́pi yɛ tíyɛsɛ nkɛ́ pikɛmɛɛ iníŋí wɑ. Ńn yɛ pikɛmɛɛ nɑ́ŋɑi. Ncɔ́ŋ ń-ye nɛ́ɛ íwɛ íye in n kɑ nléécɑɑsimɛ́ nnyɑ, nfɑtɛnɛ nń nɛ pi kpi mɛsɛ nɛ mɛsɛ. ");
INSERT INTO soy_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Pisoi picɔ yɛ we yɑrɛ kɛtẽ kɛɛ sinípɛleépi m mɑ́. Pi yɛ nléécɑɑsimɛ́ kónlɛ, ");
INSERT INTO soy_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ɑmɑ́ kɛtẽ kɛcɑ́ɑ́ likɔ́ nfɑsimɛ́ nɛ lílɑlɑ lɛɛ rɔ́ n kírɑɑsɛntɛ nɛ mɛmɑ́ ɑi nléécɑɑsimɛ́ hílɑ, ńn yɛ pɛɛ kɛrɔ́mɛɛ líkɑ yoriyɛ. ");
INSERT INTO soy_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Pisoi picɔ pin we yɑrɛ kɛtẽ sɔnɛ. Pi yɛ nléécɑɑsimɛ́ kónlɛ ɑpi n yɔ́su nn pikɛmɛɛ pelu nn linyinɛ yoriyɛ. Nléécɑɑsimɛ́ nn picɔ kɛ́mɛɛ nkɑ́ripi wɑi, nn picɔ kɛ́mɛɛ nɛ kumúŋɛ́ wɑi, nn picɔ kɛ́mɛɛ mɛyɑ̃́ wɑi. ");
INSERT INTO soy_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yeesu uu lɛ̃ mɛmɑ́ɑ́ pi pisɛ rɛ: Unyinɛ yɛɛ kɛ́firɑ́ɑ risɛ́lɛ uu kucɑ́ri kɛ kipi nɛ́ɛ uu ukɛfinɛ mɛtene kɛ pésu mɑ́? Nɛ́ntɛ kɛlõ cɑ́cɑ́ kɑpi yɛ kɛ ritɔsi ɑkɛ pɛɛ ḿpɑ́ úye n kpɑ̃́iilɛ̃? ");
INSERT INTO soy_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Lɛ̃ nnɛ́í lɛɛ pɛɛ m pékɑɑlɛ̃ ɑi kúyɛnɛ wɑi, lɛ̃ kɛ ḿpɑ́ úye úu pɛɛ kúyɛnɛ ń we ɑi mɛtɛ́í kɛ́mɛɛ léeri. ");
INSERT INTO soy_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Úye un ukómɛ ukɛ́ kṍ. ");
INSERT INTO soy_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yeesu uu pimɑ́ɑ pi kpɑ́ rɛ: Ani nɔ́mɛnɛ́círɛ tĩ nɛ lɛ̃ nnɛ́í kɑni n kómɛi. Kulũ kpɛ̃ kɑni yɛ nɛ ḿ musí kɛ Uléécɑɑ uú nɛ nɔ́ músunɛ. Ticuruu u yɛ́ kusɑ́ nɔ́ rikpɑ́. ");
INSERT INTO soy_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Likumúŋɛ́ rɛ uyɛɛ m mɑ́ kɑpi yɛ pípɑ rikpɑ́ ɑmɑ́ úye unsɑ́ m mɑ́, ḿpɑ́ nkɑ́ripi ń-ye kuu mɑ́, pi n yɔ́sunɛ. ");
INSERT INTO soy_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yeesu uu pimɑ́ɑ kpɑ́ rɛ: Uléécɑɑ iyɔɔpi yɛ kɔ we yɑrɛ usoi unyinɛ yɛɛ ilukɛpuri ukɛcɑrɛ-i n fṍ. ");
INSERT INTO soy_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Lɛ̃ mɛmɑ́ɑ́, ḿpɑ́ un kɛsinɛ nɛ́ɛ kɛtúŋɛ́ n lɔni nɛ́ɛ un n nyɑ́ni, ilukɛpuri yɛ lɛlulɛ in pelu úu nyu lɛlɛɛ i m peisɛ. ");
INSERT INTO soy_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Kɛtẽ ticuruu kɛɛ ilukɛ peisɛ. Kuhɛ́rɛ kpɛɛ yɛ mɛfoí pi, lɛ̃ mɛmɑ́ɑ́ ripipi ɑri tórɛsi, ɑri mɛtɔ́rɔɔ pelu. ");
INSERT INTO soy_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Tin m pi, usoi uu ritɛ́hɛ múlú. Kúkpɑɑ kpɛɛ lɛ̃ tu. ");
INSERT INTO soy_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yo kɑri yɛ́ kɔ nɛ Uléécɑɑ iyɔɔpi múŋɛisɛnɛ? Kɛnyɑ́rũ kɛ́ye kɑri yɛ́ nɛ linsímɛ́ wɑ mɑ́? ");
INSERT INTO soy_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Uléécɑɑ iyɔɔpi yɛ we yɑrɛ mpuri yukɛ-yukɛ nnyinɛ. Kɛlukɑɑ-i, mmɛ mɛɛ yɛ kɛtẽ nnɛ́í kɛcɑ́ɑ́ ipuri kɛcɔpɛ nsíńsɑ́. ");
INSERT INTO soy_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Amɑ́ mɛlukɑɑ-mɑɑ́, n yɛ lɛlɛ nn pɑpisi nn wɑi kuléé kpɛɛ kɛcɑrɛ-i ɑcɔ mpiyɛ n fe. Nkuléé yɛɛ ilésɛ kɛcirɛ wɑlɛ, sinúipi ɑsi ikɛcɑ́ɑ́ ɑyɑ́mɛ́ wɑpisi. ");
INSERT INTO soy_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Sinyɑ́rũ nsí sicɔ kɛ Yeesu uu yɛ nɛ ḿpɑ́ úye céesi. Pɛpɛɛ kutu u n cɔ́lɛ̃ mɛkomɛ kuu yɛ ripɑí uú nɛ céési. ");
INSERT INTO soy_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Úu yɛ píkɑi símisi kúu kɛnyɑ́rũ n wɑ, ɑmɑ́ lin u nɛ upipirɛtiki ŋmɑnɛ rin-yɑ́, ḿpɑ́ yo ɑsei kuu yɛ pi lesɛ. ");
INSERT INTO soy_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Kɛyɑ́ɑ kɛ̃ cirɛ nnyɔ́ɔ́, Yeesu uu upipirɛtiki mɑɑ rɛ: Tɔkɛ́ míni kuwɛ́lɛ́ kucɔ-mɛ̃ hɑ. ");
INSERT INTO soy_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Api risoiwuí yɑ́, upipirɛtiki ɑpi kúninɔi kpɛ-i kuú pɛɛ n tṹ nɛ n tɛ́ŋ́lɛ̃. Áninɔi ɑcɔ ɑn kɔ pikɛyúrí we. ");
INSERT INTO soy_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Kei kɛ mɛyɔ píimɑ mɛnyinɛ ɑmɛ pipépɛ kori ɑ́niwɑlɛ́ ɑɑ kúninɔi-i n lééripɔ míni ɑmɛ pɛɛ ku n yipu. ");
INSERT INTO soy_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Kumúŋɛ́ kpɛ-i, Yeesu un kúninɔi kɛ́mɛɛ kɛpirɛ-pɔ we, un lɔni, tíyu tin tíyulɑɑ kɛcɑ́ɑ́ lɑ́ɑlɛ̃. Upipirɛtiki ɑpi pɛɛ u yóŋsɛ ɑpi u mɑɑ rɛ: Sɑ́ɑ, pɔ sɛ́ɛ́lɛnlɛ tɔkɛ́ kpii? ");
INSERT INTO soy_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yeesu uu yɑ́kɑ-yɑkɑ uu kuyɔ cɛ́si uu míni mɑɑ rɛ: Sɛ́ɛ́, ɑ niŋɛsi. Kuyɔ ɑku kéu ɑi níŋɛsi. ");
INSERT INTO soy_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yeesu uu lɛ̃ mɛmɑ́ɑ́ upipirɛtiki pisɛ rɛ: Yo nnyɑ kɛ iwɑmɛ ii nɔ́ wɑ? Nɔn nɛ nfɑtɛnɛ mɑ́ɑ? ");
INSERT INTO soy_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Amɑ́ ɑi iwɑmɛ píimɑ pi wɑi ɑpí m mɑ́ikɛɛnɛ rɛ: Usoi úye kɛcirɛ yɛ nkó kɑí nɛ kuyɔ nɛ míni ripɛ́nɛ lin u pɑkɑrɛlɛ̃? ");
INSERT INTO soy_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Lɛ̃ mɛmɑ́ɑ́, ɑpi Kɑlilee kupiyɛ tɛ́ŋ́ ɑpi Kerɑsɑɑ kɛtẽ loni. ");
INSERT INTO soy_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Kɛ Yeesu uu kúninɔi-i rincúlɑmɛ, uú nɛ usoi unyinɛ yɛɛ ɑkpíí-mɛ̃ n léeri sɑ́nɛ. Kunírilɑ̃ kunyinɛ kpɛɛ yɛ utisi uyɛ̃ m pɛkɛsi. ");
INSERT INTO soy_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Akpíí-i kuu yɛ n sói. Usoi uyɛ̃ úu kupɑhɑɑ we. Ḿpɑ́ ɑkpɑnii, ɑ́pi yɛ fe pikɛ́ u pɑɑsi. ");
INSERT INTO soy_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Mɛpehẽ kulúi kɑpi yɛ uɑnɑ nɛ nweni hɔpi ɑpi uɑnipɛ nɛ ɑkpɑnii pɑɑsi, ɑmɑ́ u yɛ ipehe iyɛ̃ nnɛ́í túúnlɛ. Úkɑ nnɑŋɛ ńn pɛɛ tulɑɑlɛ̃ nkɛ́ nɛ utisi uyɛ̃ tĩ. ");
INSERT INTO soy_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Kɛtúŋɛ́ nɛ kɛsinɛ kuu yɛ ɑkpíí-i nɛ ɑkúú kɛcɑ́ɑ́ n kɔɔnii un pupukɛɛ, un umɛcirɛ itói wɑi nɛ ɑpɑrɛ. ");
INSERT INTO soy_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Uu Yeesu kɛtɑɑ-pɔ yɛnu uu pɛɛ wurupɔ uú hɑ ukɛyu-i wúlɑ ");
INSERT INTO soy_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","uu pupɛi rɛ: Uléécɑɑ yɛɛ ḿpɑ́ yo kɛcɑ́ɑ́ n tṹ Kɛpipi Yeesu, tɔ́ nɛ mpɔ̃́ nɛ ń-ye? Nɛ nɛ pɔ́ ténilɛ, nɛ Uléécɑɑ rinyiri, kɑpɛ íwɛ nɛ́ wɑ. ");
INSERT INTO soy_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Yeesu yɛ kunírilɑ̃ kpɛ̃ tinɔ́ɔ hɛ rɛ kukɛ́ utisi uyɛ̃ kɛ́mɛɛ le. Lɛ̃ nnyɑ kɑku lɛ̃ mɑ́ikɛɛ. ");
INSERT INTO soy_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yeesu uu kɔ ku pisɛ rɛ: Íye kɑpi yɛ pɔ́ sée? Aku rinɔ́ɔ u yɔ́su rɛ: Pi yɛ nɛ́ sée rɛ kulúi, likumúŋɛ́ rɛ tɔ kulúi welɛ. ");
INSERT INTO soy_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Akú nɛ Yeesu téni rɛ úu kɑpɛ ɑ lɑkɑsɛ ɑkɛ́ kuyu kɛtɔ rilɔ́ɔ́. ");
INSERT INTO soy_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kúfɔŋlee píimɑ kunyinɛ yɛ pɛɛ kei rikúuésɑɑ-i túkurilɛ. ");
INSERT INTO soy_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Aníri ɑɑ pɛɛ́ nɛ Yeesu téni rɛ: A ncée rɔ́ hɛ tɔkɛ́ ɑ́fɔŋ nnyɛ́ lõ. ");
INSERT INTO soy_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yeesu uu ncée hɛ. Aníri ɑɑ utisi uyɛ-i léeri ɑɑ ɑ́fɔŋ loni. Kúfɔŋlee kpɛɛ tu yɑrɛ ɑ́fɔŋ ɑ́kotokú ɑtɛ́ (2.000). Áfɔŋ nyɛ̃ nnɛ́í ɑɑ wuru ɑɑ́ nɛ rikúú cɛ́pi ɑɑ́ hɑ nɛ mínimɑɑ-i kpúupɔ. ");
INSERT INTO soy_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Pisoi pɛɛ pɛɛ ɑ n séni ɑpi wuru ɑpí hɑ nɛ nsímɛ́ kuyu nɛ siyupi kɔ́ɔ́nú. Pisoi ɑpi sĩ́ pikɛ́ lɛlɛɛ n wɑ yɛ̃. ");
INSERT INTO soy_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Api Yeesu-i sĩ́ ɑpi utisi uyɛɛ pɛɛ ɑníri kulúi n héesi yɛnu un tũ nɛ ukɛyu cɑ́kɑ́-cɑ́kɑ́ un kɔ lɑpɑɑlɛ̃ ńsɔnɛ, ɑi iwɑmɛ pi wɑi. ");
INSERT INTO soy_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Pɛ̃ nnɛ́í inipɛɛ-i kɑi lɛ̃ n wɑpisi ɑpi lɛ̃ kɛ ɑníri ɑɑ́ nɛ utisi uyɛ-i ń le kɛɛnkɛɛ nɛ lɛ̃ kɑi ɑ́fɔŋ n wɑ. ");
INSERT INTO soy_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Api pɛɛ Yeesu suúlusɛ rɛ ukɛ́ pikɛteni-i le. ");
INSERT INTO soy_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Kɛ Yeesu uu kúninɔi-i n loni, utisi uyɛ̃ uu u suúlusɛ rɛ u yɛ́ u ritiki. ");
INSERT INTO soy_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yeesu úu ncée u hɛ, ɑmɑ́ u rinɔ́ɔ u hɛ rɛ: A kui ɑɑ pipɔ́kɔ́ lɛɛpɔ. Aɑ lɛ̃ kɛ Upíimɑ uu íwɛ pɔ́ n tẽ́ uu pɔ́ wɑi pi kɛɛnkɛɛ. ");
INSERT INTO soy_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Utisi uu mɛsei pɛlɛ uú hɑ nɛ nsímɛ́ mmɛ̃ kɔ́ɔ́nú kuwɛ́lɛ́ kpɛ-mɛ̃ kɑpi yɛ n sée rɛ Ayu Kɛfi kɛtẽ. Pɛ̃ nnɛ́í pɛɛ yɛ n kṍ, nnɔ́ɔ kɑi yɛ pi yi. ");
INSERT INTO soy_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Lɛ̃ mɛmɑ́ɑ́, Yeesu uú nɛ kúninɔi míni ritimɛ ricɔ tɛ́ŋ́. Pisoi kulúi ɑpi kɔ kei lɛ̃ u n kɑ́lɑɑlɛ̃. ");
INSERT INTO soy_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Kei kɛ Pisuifi kuyomɛyɑ́hɑɑlee uwɛ́ɛ́sɛ unyinɛ kɑpi yɛ n sée rɛ Yɑirusi uu Yeesu yɛ̃ uu uɑnɑ mɛtene wulɑ. ");
INSERT INTO soy_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Uú nɛ Yeesu mɛyɑ́nsei téni, uu rɛ: Kɛnɛ́kpérepi yɛ kɛkpɔ tulɛ, ɑ kɑm, ɑɑ ɑnípɛ kɛkɛcɑ́ɑ́ lɑ́ɑ likɛ́ kɛ yoriyɛ ɑ́kɛ kɑpɛ kpu. ");
INSERT INTO soy_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yeesu uú nɛ nsẽ́ u pɛ́nɛ. Pisoi kulúi pin u nyikii pin nɛ u tikilɛ̃. ");
INSERT INTO soy_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Kumúŋɛ́ kpɛ-i, unɔ́si unyinɛ kɛ mɛ́nyɛ ɑmɛ n foho hɑ́i iŋmɛ̃ kɛfi nɛ itɛ́-mɛ un kei we. ");
INSERT INTO soy_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Pipɔisɛ mɛyɑ̃ kuu rikɑ ɑi u pelu, usiwóó nnɛ́í ɑsi kɔ itói iyɛ-i tɛnɛ, úu kɔ pɛɛ peí. Amɑ́ itói in nɑ́kíísɛlɛ̃. ");
INSERT INTO soy_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Kuu nní Yeesu nsímɛ́ n kómɑɑlɛ̃, uu pɛɛ riwúí tɛ-i lompɔ uu kɛpirɛ-mɛ̃ Yeesu ilũ cɑ. ");
INSERT INTO soy_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Likumúŋɛ́ rɛ u ukɛfɑ-i pisímɛ́ mɑsí rɛ: Ḿpɑ́ Yeesu ilũ ŋmɑnɛ kɑm fe ɑḿ cɑ, nɛ́ peí. ");
INSERT INTO soy_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Kuu lɛ̃ tińcɑ, mɛ́nyɛ mɛɛ pɛɛ n foho ɑmɛ mɛsɛ nɛ mɛsɛ nyɛrɛ, uu pélu. ");
INSERT INTO soy_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yeesu uu cérupɔ rɛ unnɑŋɛ yɛ pikɛi yisilɛ. Uu riwúí tɛ̃ kɛcɔpɛ pɑnsɛ uu pisɛ rɛ: Wóo inɛ́lũ ticɑ? ");
INSERT INTO soy_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Upipirɛtiki ɑpi rinɔ́ɔ u yɔ́su rɛ: Pɔ nyɑ́nilɛ rɛ pisoi yɛ pɔ́ nyíkiilɛ̃, ɑɑ kɔ pɛɛ́ m písɛi rɛ wóo pɔ́ ricɑɑ? ");
INSERT INTO soy_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yeesu uu uilúkɛ́ pɑí ukɛ́ uyɛɛ u rińcɑ yɛ̃. ");
INSERT INTO soy_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Unɔ́si uyɛ̃ uu pitɛ́rii kɑ́pɑ́ɑ́ nɛ iwɑmɛ mɛpehẽ. U lɛlɛɛ n wɑ nyulɛ. Uu lɛ̃ nnyɑ Yeesu ɑnɑ mɛtene wulɑ uu ɑsei nnɛ́í u símisi. ");
INSERT INTO soy_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Amɑ́ Yeesu pɔ́ɔ u mɑɑ rɛ: Unɛ́kpére, mpɔ́fɑtɛnɛ yɛ pɔ́ yóriyɛlɛ. A n ŋme nɛ nkíŋniŋɛ ipɔ́tói ikɛ́ tɛnɛ. ");
INSERT INTO soy_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Úu kɑhɑnɛ nkpɑ́ni nsímɛ́ n tɛnɛ kɛ pisoi pɛɛ Pisuifi kuyomɛyɑ́hɑɑlee uwɛ́ɛ́sɛ uyɛ̃ kɛyɔ-i n léeri ɑpí mɑɑ rɛ: Kɛpɔ́wɑ̃́ yɛ nkpɔ mɑsilɛ. Yo nnyɑ kɑɑ nkpɑ́ni Ucélɑɑ mɛ́woo cɔ́ŋlɛ̃? ");
INSERT INTO soy_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Amɑ́ Yeesu úu nkpɑ́ni piɑnɔɔ nyɛ̃ kutu ricɔ, uu kuyómɛyɑ́hɑɑlee uwɛ́ɛ́sɛ mɑɑ rɛ: Kɛpɔ́wuu ɑ́kɛ kɑpɛ tɔ, mpɔ́kɔ́ yɛɛ rɛ ɑ nɛ kɛfɑ tɛnɛ. ");
INSERT INTO soy_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Lɛ̃ mɛmɑ́ɑ́, úu úkɑ ncée hɛ rɛ ukɛ́ u sɑrũ, insɑ́ Piyɛɛ nɛ Yɑkupu nɛ Yɑkupu uwɑ̃ Yohɑni. ");
INSERT INTO soy_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Kɑpi kuyómɛyɑ́hɑɑlee uwɛ́ɛ́sɛ uyɛ̃ kɛyɔ n tuipɔ, iwɔ́ɔ kɛ Yeesu uu kṍ. Pisoi yɛ pɛɛ ikpɔtu wɔ́riilɛ pin pupukɛɛ. ");
INSERT INTO soy_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Uu lompɔ uu pi mɑɑ rɛ: Yo nnyɑ kɑni iwɔ́ɔ likirɛlɛ̃ nɔn kɔ téni? Kɛkpérepi kɛ̃ ɑ́kɛ kpu ɑmɑ́ kɛ lɔnilɛ. ");
INSERT INTO soy_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Api pɛɛ Yeesu n sɛ́nnyi. Yeesu uu pɛɛ lɛ̃ mɛmɑ́ɑ́ pi lesɛri. U nɛ kɛwɑ̃́ kɛ̃ usɑɑ nɛ kɛuni nɛ upipirɛtiki pitɑɑni pɛ̃ kuú pɛɛ n tɛ́si ɑpi kei kɛ kɛwɑ̃́ kɛ̃ ɑkɛ́ ń we lompɔ. ");
INSERT INTO soy_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Uu kɛwɑ̃́ kunipɛ tini uu kɛ mɑɑ rɛ: Tɑlitɑ kum, li ɑsei rɛ kɛkpérepi, ɑ yisi, nɛ́ɛ rinɔ́ɔ pɔ́ hɛ. ");
INSERT INTO soy_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Kɛkpérepi ɑkɛ mɛsɛ nɛ mɛsɛ yisi ɑkɛ nsẽ́ kɑ́pɑ́ɑ́. Aŋmɛ̃ kɛfi nɛ ɑtɛ́ kɑkɛ yɛ m mɑ́. Kɑpi mɛwɑi mɛ̃ lɛ̃ n yɛ̃́, ɑi ḿpɑ́ úye nnɔ́ɔ yipu. ");
INSERT INTO soy_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yeesu uu lɛ̃ mɛmɑ́ɑ́ pi kúrúrúsɛ rɛ ɑ́pi kɑpɛ tíyɛsɛ unyinɛ ukɛ́ céri. Uu kɔ pimɑ́ɑ pi kpɑ́ rɛ pikɛ́ kɛkpérepi kɛ̃ ilukɛ hɛ. ");
INSERT INTO soy_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Kɛ Yeesu uu kɛlõ kɛ-i n yisi uu kuyu kpɛ-i kuu iwɑ̃́ n li kɛ́mɛɛ sĩ́, upipirɛtiki ɑpi u tiki. ");
INSERT INTO soy_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Kɛ kɛwéntɛyɑɑ kɛtúŋɛ́ ɑkɛ n tu, uu Pisuifi kuyomɛyɑ́hɑɑlee-i lompɔ uu pisoi n céési. Nsímɛ́ nn nnɔ́ɔ pisoi píimɑ pɛ̃ nnɛ́í pɛɛ kutu u n cɔ́lɛ̃ yipu. Apí m písɛinɛ rɛ: Yei kɛ nní yɛ nnɛ́í ɑi mpíí u léenti mɑ́? Mɛwɛ́ɛ́sɛsɔhɔ mɛ́ye mpuri kɑi nkó nní hɛ mɑ́? Íye kuú nɛ mɛwɑisɑŋɑ mmɛ́ mpuri wɑpisi mɑ́? ");
INSERT INTO soy_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","In nɛ Mɑɑri kɛpipi usɛ́rɛ́ɛ? Nɛ́ntɛ upiwɑ̃ pɛɛ Yɑkupu nɛ Yosee nɛ Yuuti nɛ Simɔɔ? Ái upiyɛi pɛɛ nní kɛrɔ́cɔpɛ wee? Nní nnɛ́í ɑi pi tɑpisi ɑ́pi nɛ Yeesu kɛfɑ tɛnɛ. ");
INSERT INTO soy_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yeesu uu pɛɛ rinɔ́ɔ pi pɛsɛ rɛ: Antepu kuyu cirɛ-i kɑpi yɛ u lómiisɛ. Umpuri pikɔ́ nɛ upiyɔkɔ́ pɛɛ ɑ́pi yɛ u wɑisɛ. ");
INSERT INTO soy_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Yeesu úu lɛ̃ mɛmɑ́ɑ́ fe ukɛ́ mɛwɑisɑŋɑ piwɑi rikpɑ́, insɑ́ pitóikɔ́ pinyinɛ kɛcɑ́ɑ́ kuu ɑnípɛ rinlɑ́ɑ uu pi pɔisɛ. ");
INSERT INTO soy_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ai Yeesu pírí wɑi kɑ́pi nɛ kɛfɑ u n tɛnɛ. Lɛ̃ mɛmɑ́ɑ́, Yeesu uu ɑyu ɑcɔ nyɛɛ nɛ kei n kɔ́lɛ̃ kɛ́mɛɛ sĩ́ uu ɑpisoi nléécɑɑsimɛ́ céési. ");
INSERT INTO soy_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Uu pɛɛ upipirɛtiki kɛfi nɛ pitɛ́ séi uu pi tum pitɛ́ pitɛ́, uu ńnɑŋɛ pi hɛ rɛ pikɛ́ ɑníri n lɑkɑsɛ. ");
INSERT INTO soy_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Uu rinɔ́ɔ pi hɛ rɛ: Áni kɑpɛ kunɑɑpi mɛmɑ́ɑ́ líkɑ rimúlú yɑrɛ ilukɛ nɛ́ɛ kulɔ́ɔ nɛ́ɛ kɛwóó rɛ ncée kɑni nɛ sĩ. ");
INSERT INTO soy_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Amɑ́ uu rɛ: Ani ɑnɛ́ɛ́ri mɛtɑnɛ mɛsɛ mɛsɛ tɑ́nti, ɑmɑ́ ɑ́ni kɑpɛ sitúkɑnkɑ sitɛ́ sitɛ́ tɑ́nti. ");
INSERT INTO soy_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Uu pimɑ́ɑ pi kpɑ́ rɛ: Nɔn kɛ́yɔ kɛ́ye-i n topilɛ, ɑni kei n tũ hɑ́i nɛ kumúŋɛ́ kpɛ-i kɑni kuyu kpɛ̃ n yisinɛ. ");
INSERT INTO soy_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Pisoi pin yei kusɑ́nɛ piyɔ́ɔ́ nɔ́ n yɛ̀ nɛ́ɛ kutu kɑ́pi nɔ́ ricɔ, nɔn n tɔ́su, ɑni nɔ́ɑnɛ́nɑ nkoŋo péi. Likɛ́ pi nyísɛ rɛ pi Uléécɑɑ nsímɛ́ pipɑkɑrɛ yɛ̀. ");
INSERT INTO soy_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Pipirɛtiki pɛ̃ ɑpi ncée pɔlɔ ɑpi pisoi nléécɑɑsimɛ́ n símisi pin tee rɛ pikɛ́ pimɛfinɛ consɛ. ");
INSERT INTO soy_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Aníri mɛyɑ̃ kɑpi lɑ́kɑsɛ, ɑpi pitóikɔ́ mɛyɑ̃ kɛcɑ́ɑ́ mɛ́kpɔ kɔɔni itói ii tɛnɛntɛ. ");
INSERT INTO soy_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Lɛ̃ kɑi wɑ Yeesu rinyiri ɑri ḿpɑ́ yei kɔ́ɔ́nú, uyɔ́ɔpi Erooti uú nɛ Yeesu nnɛ̃́ kóm. Pisoi ɑpi pɛɛ́ n símɑɑnkɛɛ rɛ: Yohɑni Úniwolɛ yɛ pikpɔkpɔ kɛ́mɛɛ yisilɛ, lɛ̃ nnyɑ kuu nní ńnɑŋɛ mɑ́ un mɛwɑisɑŋɑ wɑpisi. ");
INSERT INTO soy_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Picɔ pin mɑ́ikɛɛ rɛ Elii lo. Picɔ pɔ̃́ tɛ mɛkɛɛ ɑntepuyɛ kɛcɔpɛ usɛ unyinɛ lo. ");
INSERT INTO soy_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Amɑ́ kɛ Erooti uu lɛ̃ n kṍ, uu rɛ: Yohɑni uyɛ̃ tiyu kɑm n tíyɛsɛ ɑpi tɔ́lu yɛɛ yisi. ");
INSERT INTO soy_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Likumúŋɛ́ rɛ Erooti ricuruu yɛɛ rinɔ́ɔ hɛ ɑpi Yohɑni pɑɑsi ɑpi kukpɑniilee-i sɑ́pɔ. Ái líkɑ nnyɑ kɛ Erooti uu lɛ̃ wɑ. Erooti yɛ pɛɛ uumɑɑ Filipu unɔsi Erootiyɑti yɔsilɛ. ");
INSERT INTO soy_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Kɑi lɛ̃ n wɑ, Yohɑni uu pɛɛ u mɑɑ rɛ ɑ́i nɛ risɑ́ rɛ ukɛ́ uumɑɑ unɔsi yɔsí. ");
INSERT INTO soy_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Erootiyɑti uu lɛ̃ nnyɑ Yohɑni ukɛfɑ-i wɑi uu ncée wɛ́ɛ́si ukɛ́ nɛ u kpu. Amɑ́ úu fe. ");
INSERT INTO soy_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Kɛ Erooti uú pɛɛ Yohɑni m pɑkɑrɛlɛ̃ un kɔ nyu rɛ u ɑsei tikilɛnlɛ, uisoi in kɔ kɛcirɛ we nnyɑ, Erooti úu yɛ pɛɛ Yohɑni kɛcɑ́ɑ́ kṍ, un unsímɛ́ kutu n cɔlɛ̃ n yɛ u ricɔ́ŋlɛ, ḿpɑ́ nɛ lɛ̃ u kɔ pɛɛ mpikomɛ lɑlɛ. ");
INSERT INTO soy_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Amɑ́ kɛyɑ́ɑ sɔnɛ ɑkɛ Erootiyɑti leeri. Kɛ Erooti uu ukɛmɑrɛyɑɑ ɑnyɑ̃́ n wɑi, uu lɛ̃ nnyɑ sɔ́ɔ́ni uu ukuyu pinɑŋɛ-nɑŋɛ nɛ pisɔ́ɔ́cɑ piwɛ́ɛ́sɛ nɛ Kɑlilee kɛtẽ pisoi kɛcirɛ sélei. ");
INSERT INTO soy_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Kei kɛ Erootiyɑti ukpére uu kɛnyɑ́nkɑlɛ-i lompɔ uu yésu ɑi Erooti nɛ upisɑnɛ nnɛ́í lɑrisi. Uyɔ́ɔpi Erooti uu ukpére uyɛ̃ mɑɑ rɛ: A lɛlɛɛ ripɔ́ɔ pɔ́ ń we nɛ́ we, kɛ́ pɔ́ li hɛ. ");
INSERT INTO soy_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ai wɑi uú hɑ nɛ wééri rɛ: Pɔn yo nɛ́ n we, nɛ́ pɔ́ li hɛ, ḿpɑ́ in kɛnɛ́yɔ́ɔpitẽ kuwɛ́lɛ́, nɛ́ pɔ́ hɛ. ");
INSERT INTO soy_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Kɛ ukpére uyɛ̃ uu kɛkɑ́lɛ-i n léepɔ, uú hɑ úni pisɛ rɛ: Yo kɑm yɛ́ pisɛ? Uyɛ̃ uu u pɛsɛ rɛ: A Yohɑni Úniwolɛ riyu pisɛ. ");
INSERT INTO soy_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Uu mɛkɛɛkɛɛ uyɔ́ɔpi-mɛ̃ pɛlɛ uu u mɑɑ rɛ: Nɛ lɑ rɛ ɑ nfɑ́ɑni Yohɑni Úniwolɛ riyu kɛcɑ́ripi-i nɛ́ ritɔsi. ");
INSERT INTO soy_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Uyɔ́ɔpi ripɔɔ ɑri cɑɑi, ɑmɑ́ uɑwééri nɛ pisɑ́nɛ isɛi nnyɑ, ɑ́i kúyulɛ we. ");
INSERT INTO soy_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Uu mɛsɛ nɛ mɛsɛ uumɛ́rɛ́ usɛ yukusɛ rɛ ukɛ́ nɛ Yohɑni riyu u kɑm. Umɛ́rɛ́ uú hɑ uriyu tɔlu kukpɑniilee-i. ");
INSERT INTO soy_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Uu ríyu kɛ́pɛlɛntɛ kɛcɑ́ɑ́ tɔ́si uú hɑ ukpére uyɛ̃ ti múísɛ, ukpére pɔ́ɔ úni ri pɑ. ");
INSERT INTO soy_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Kɛ Yohɑni pipirɛtiki ɑpi lɛ̃ n kṍ, ɑpí weri ɑpi u kpísi ɑpí hɑ kulɛsi. ");
INSERT INTO soy_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yeesu pitumɛ ɑpi Yeesu kɛyúrí cɑ́pinɛ, ɑpi lɛ̃ nɛ lɛ̃ kɑpi n wɑpisi nɛ lɛ̃ kɑpi pisoi n céesi u kɛɛnkɛɛ. ");
INSERT INTO soy_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Pisoi pɛɛ Yeesu-i n sɔ́nɑɑpɔ nɛ pɛpɛɛ ukɛmɛɛ n léeri yɛ kulúi tɔsilɛ. U nɛ upipirɛtiki ɑ́pi yɛ pɛɛ nkpɑ́ni kɛ́yu yɛ̃ pikɛ́ ilukɛ li. Lɛ̃ nnyɑ kɛ Yeesu uu pipirɛtiki mɑɑ rɛ: Tɔkɛ́ iyɑɑ le, kei kɛ pisoi ɑ́pi ń we ɑní hɑ nkɑ́ripi wéntɛ. ");
INSERT INTO soy_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Api kúninɔi loni pikɛ́ kei kɛ úkɑ úu ń we hɑ. ");
INSERT INTO soy_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pisoi mɛyɑ̃ ɑpi pimɛtɔ́ŋɛ́ yɛ́nu ɑpi kɔ pi ceru. Ayu nyɛɛ nɛ pi n kɔ́lɛ̃ nnɛ́í pisoi ɑpi ntóó wɑi ɑpi kei kɑpi n sĩ́ pi fɔ́su. ");
INSERT INTO soy_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Kɛ Yeesu uu kúninɔi-i n léemɛ, uu pisoi kulúi yɛnu ɑi íwɛ u wɑi rɛ pi pɛɛ we yɑrɛ isɛɛ yɛɛ íi usẽ́ m mɑ́ nnyɑ. Uu mɛsɛ picélɑɑ pi loni ɑi nɑ́ŋɑi hɑ́i. ");
INSERT INTO soy_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kɛ ituŋɛ ii n tɛnɛ, upipirɛtiki ɑpí nɛ u kɔ ɑpi uu mɑɑ rɛ: Líkɑ ɑ́i kɛlõ nkɛ́-i we. Lɛ̃ mɛmɑ́ɑ́, ituŋɛ yɛ kɔ tɛnɛlɛ. ");
INSERT INTO soy_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","A pi mɑɑ rɛ pikɛ́ hɑ siyupi nɛ ɑyu nyɛɛ nɛ rɔ́ n kɔ́lɛ̃ kɛ́mɛɛ lilukɛ-lukɛ lɛ́ɛ́ri. ");
INSERT INTO soy_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yeesu uu rinɔ́ɔ pi yɔ́su rɛ: Ani nɔ́rinɛ́cúruu lilukɛ-lukɛ pi hɛ. Api u pisɛ rɛ: Tɔ nkpéni sínlɛ tɔkɛ́ nwóóweni mɛpipi pílɛ pílɛ mɛtɛ́ nɛ ɑkpɔ́nɔ́ lɔ ɑri pi pɑ pikɛ́ li nɛ́ɛ? ");
INSERT INTO soy_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yeesu uu pi pisɛ rɛ: Akpɔ́nɔ́ ɑlɛ́ kɑni mɑ́? Ani hɑ ripɑí. Api písɛinɛ ɑpi limɛmɑ́ɑ́ Yeesu rinɔ́ɔ yɔ́su rɛ: Akpɔ́nɔ́ ɑnupũ nɛ ikpíntomɛ́ itɛ́. ");
INSERT INTO soy_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Uu pɛɛ rinɔ́ɔ pi hɛ rɛ pikɛ́ mɛyúi pɛ́ni kɛcɑ́ɑ́ ɑwúí ɑwúí pi tonsɛ ");
INSERT INTO soy_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ɑpi ɑnɑ́i ɑnɑ́i túnti, ɑcɔ pisoi pílɛ pílɛ, ɑcɔ kuwóó kuwóó. ");
INSERT INTO soy_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Uu ɑkpɔ́nɔ́ ɑnupũ nɛ ikpíntomɛ́ itɛ́ iyɛ̃ kpísi, uu kɛyómɛ weríí, uu ilukɛ iyɛ̃ kɛcɑ́ɑ́ Uléécɑɑ pɔɔnɛsɛ. Uu lɛ̃ mɛmɑ́ɑ́ ɑkpɔ́nɔ́ kpɔ́kɔrinɛ uu upipirɛtiki pɑ rɛ pikɛ́ pisoi hɔɔnɛ. Uu kɔ ikpíntomɛ́ itɛ́ iyɛ̃ pinnɛ́í hɔ́ɔ́nɛ. ");
INSERT INTO soy_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Api pinnɛ́í le ɑpi lɛpu. ");
INSERT INTO soy_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Upipirɛtiki ɑpi ɑkpɔ́nɔ́ nɛ ikpíntomɛ́ keri cɑ́pinɛntɛ ɑi ɑnɛ́rɛ kɛfi nɛ ɑtɛ́ yipu. ");
INSERT INTO soy_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Pɛpɛɛ ilukɛ iyɛ̃ n li kɛ́mɛɛ pitisi yɛ lelɛ ɑ́kotokú ɑnupũ (5.000). ");
INSERT INTO soy_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Yeesu uu lɛ̃ mɛmɑ́ɑ́ mɛsɛ nɛ mɛsɛ upipirɛtiki rinɔ́ɔ hɛ rɛ pikɛ́ kúninɔi lõ pikɛ́ hɑ rikóitimɛ ricɔ-pɔ u m mɛ̃́, Petisɑyitɑ kuyu kuwɛ́ɛ́-mɛ̃, uyɛ̃ ukɛ́ pɛɛ kumúŋɛ́ kpɛ-i pisoi n kúúnsɛ. ");
INSERT INTO soy_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Kuu pisoi rin-yɑ́, uu riyɔ́pɛ tɑɑ́ ukɛ́ kɛyómɛ yɑ́ɑ́si. ");
INSERT INTO soy_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kɑi nnyɔ́ɔ́ ń wɑ, kúninɔi kun mínimɑɑ kɛcɔpɛ we. Yeesu pɔ́ɔn umɛcirɛ kɛtẽ mmɛ́ we. ");
INSERT INTO soy_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Uu yɛ́nu rɛ kúninɔi pitíkíí yɛ íwɛ pi wɑilɛ, likumúŋɛ́ rɛ mɛ̃ kɑpi n sĩ́ kɛ kuyɔ píimɑ kunyinɛ ɑku pépuri. Tiweeki kumúŋɛ́, uu pikuwɛ́lɛ́-mɛ̃ n sɔ́nɛpɔ míni kɛcɑ́ɑ́, un lɑ ukɛ́ pi rifɑɑu. ");
INSERT INTO soy_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Kɑpi u n yɛ̃́ un míni kɛcɑ́ɑ́ sɔ́nɛ, ɑpi músu rɛ kɛ́pirii-pirii kɛnyinɛ yɛ kɛ, ɑpi pipupukɛɛ loni. ");
INSERT INTO soy_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Pinnɛ́í pɛɛ mɛyíkíyiki u yɛ̃ ɑi pi túítúísɛ. Yeesu uu pɛɛ rinɔ́ɔ pi mɑɑ rɛ: Iwɑmɛ íi kɑpɛ nɔ́ wɑ, nɛ̃́ ŋmɑɑ lo. ");
INSERT INTO soy_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Uu limɛmɑ́ɑ́ kúninɔi-i pi lɛɛpɔ, kuyɔ ɑku kéu. Ai pírí pi wɑi hɑ́i ");
INSERT INTO soy_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","likumúŋɛ́ rɛ piɑkiŋ ntɑkɛ nnyɑ, ɑ́pi pɛɛ ɑkpɔ́nɔ́ mɛwɑisɑŋɑ mɛ̃ kõ. ");
INSERT INTO soy_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Mɛtɛ́ŋ́-mɑɑ́ ɑpi Kenesɑrɛti kɛtẽ tulu, ɑpi rikóitimɛ pikuninɔi kɑrii. ");
INSERT INTO soy_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Kɑpi kúninɔi-i n léemɛ, pisoi ɑpi mɛsɛ nɛ mɛsɛ Yeesu ceru. ");
INSERT INTO soy_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Api kɛtẽ kɛ̃ nnɛ́í kɔ́ɔ́nú, ɑpí yɛ pin n kõ tɛ u yei we, ɑpi kei nnɛ́í nɛ ɑsɑ́ŋɑ́ɑ́pɔrɛ́ kɛ́mɛɛ pitóikɔ́ u n sɔ́nɑɑpɔ. ");
INSERT INTO soy_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Pi yɛ kɛ́yɑɑ́lɑ-i pitóikɔ́ nɑ́ŋɑisɛlɛ siyupi nɛ ɑyu nɛ ɑwosoo nyɛ-i kuu n sɔ́nɛ ɑpí nɛ u n téni rɛ ukɛ́ tíyɛsɛ pitóikɔ́ pikɛ́ ḿpɑ́ ukɛtukɑnkɑ nnɔɔ ricɑ. U yɛ pɛ̃ nnɛ́í pɛɛ u rińcɑ pɔisɛntɛlɛ. ");
INSERT INTO soy_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","*Pifɑrisi nɛ *isé picélɑɑ pinyinɛ pɛɛ *Yerusɑlɛm n léeri ɑpi Yeesu kɛwúípi wɑi. ");
INSERT INTO soy_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Api upipirɛtiki pinyinɛ yɛnu pin ilukɛ le nɛ ɑnípɛ kpɛrinkpɛkɔɔ́, ɑ́pi piɑnipɛ nɑlɛ yɑrɛ kɑi piinyɛkii kɛ́mɛɛ m pisɛ. ");
INSERT INTO soy_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Kɛ Pifɑrisi nɛ *Pisuifi picɔ nnɛ́í ɑpi mɛyɑ́nsei pikpurɛ inyɛkii m múílɛ̃ nnyɑ, pinsɑ́ ńsɔnɛ n nɑlɛ, ɑ́pi yɛ li. ");
INSERT INTO soy_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Pin kɔ kuyɑ́ɑ n leemɛ, pi yɛ piinyɛkii mɛnɑlɛ mɛ̃ nɑlɛlɛ ɑpi kɛlenɛ le. Pi nɛ pimɛkpurɛwɑi mɛyɑ̃ yɑrɛ nní piheehɛɛrɛ nɛ sicɑ́ripi nɛ ɑpɔ́ri pihɛɛrɛ múílɛnlɛ. ");
INSERT INTO soy_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Pifɑrisi nɛ isé picélɑɑ ɑpi pɛɛ u pisɛ rɛ: Yo nnyɑ kɛ pipɔ́pirɛtiki ɑ́pi pirɔ́kpurɛ inyɛkii tikilɛ̃ pin nɛ ɑnípɛ kpɛrinkpɛkɔɔ́ ilukɛ le? ");
INSERT INTO soy_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yeesu uu rinɔ́ɔ pi pɛsɛ rɛ: Asei kɛ *ɑntepu *Esɑyi uu mɛkɛɛ-mɛ nɔ́nnɛ́símɛ́ yɛ́mmɛ. Nɔ kɛcɑ́ɑ́ kɛcɑ́ɑ́ mɛwɑi pikɔ́ lɛ yɑrɛ kɛ Esɑyi uu n wɔ́i rɛ Uléécɑɑ yɛ mɑɑ rɛ: Nnɔ́ɔ-i ŋmɑnɛ kɛ pisoi mpí ɑpi ríyu nɛ́ wɑisɛlɛ̃, ɑmɑ́ ɑ́pi pɛɛ pisifɑ-i nɛ nɛ́ kɔ́lɛ̃. ");
INSERT INTO soy_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Piiyɑ́hɑɑ yɛ likpɑ́rɑ́kɔɔ́ lɛ. Pi rinyɑlɛ pin sisoipipi inyɛkii kpísi pin céési yɑrɛ inɛ́kɔ́ yɛ nyi. ");
INSERT INTO soy_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Uléécɑɑ isé kɑni kɛpirɛ ritɔ ɑni sisoipipi inyɛkii m múílɛ̃. ");
INSERT INTO soy_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Uú nɔŋ́ tɛ: Ani riŋmɔ́ɔ́pú ɑni Uléécɑɑ isé kɛpirɛ tɔ ɑní nɛ nɔ́inɛ́nyɛ́kii picélɑɑ kɛ́yu mɑhɑni. ");
INSERT INTO soy_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ticuruu *Moisi yɛ mɛkɛɛ-mɛ mɑɑ rɛ: A upɔ́sɑ́ɑ nɛ upɔ́ni ríyu wɑisɛ. Uu kɔ rɛ úye un usɑ́ɑ nɛ́ɛ úni ɑnɔ́ɔ n wɑ, li pisɛ rɛ pikɛ́ liute kpu. ");
INSERT INTO soy_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Amɑ́ nɔ̃́ nɛ yɛ rɛ: Usoi un usɑ́ɑ nɛ́ɛ úni m mɑɑ rɛ: Lɛ̃ kuú pɛɛ́ ń lɑ ukɛ́ nɛ u lɛ̃́ Uléécɑɑ hɛlɛ, ");
INSERT INTO soy_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ɑ́ni yɛ liute riyɑ́ ukɛ́ linyinɛ licɔ piwɑi usɑ́ɑ nɛ́ɛ úni rikpɑ́. ");
INSERT INTO soy_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Mɛ́wee mɛ̃ yɛɛ tíyɛsɛlɛ ɑni Uléécɑɑ Nsímɛ́ cɔ́kɔi nɛ nɔ́inɛ́nyɛ́kii isé kɑni n yekeilɛ̃. Mɛwɑi mɛ̃ mɛcɔ kɑni n wɑpisi yɛ kɔ piyɛlɛ. ");
INSERT INTO soy_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yeesu uu limɛmɑ́ɑ́ pisoi picɑ́pinɛ kpɑ́ uu rɛ: Ani nɔ́nnɛ́nɛ́í kutu nɛ́ ricɔ ɑni kóm. ");
INSERT INTO soy_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Litɑhɑikɔ́ líkɑ ɑ́i we lɛɛ yɛ́ lin usoi kɛ́mɛɛ n lõ, ɑi Uléécɑɑ inipɛɛ-i mɛ́kpɛrinkpɛ u wɑisɛ, ɑmɑ́ lɛlɛɛ usoi kɛ́mɛɛ n léenti lɛɛ yɛ Uléécɑɑ inipɛɛ-i mɛ́kpɛrinkpɛ u wɑisɛ.  ");
INSERT INTO soy_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Úye un ukómɛ ukɛ́ kṍ. ");
INSERT INTO soy_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Kɛ Yeesu uu pisoi pɛ̃ kɛcɔpɛ n yisi, u nɛ upirɛtiki ɑpi kɛ́yɔ loni ɑpi kɛnyɑ́rũ kɛ̃ ɑsei u pisɛ. ");
INSERT INTO soy_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Uu rinɔ́ɔ pi pɛsɛ rɛ: Nɔ̃́ ticuruu ɑ́ni kɔ mɛsɔhɔ mɑ́ɑ? Lɛ̃ nnyɑ, ɑ́ni nyu rɛ lɛ̃ nnɛ́í lɛɛ usoi kɛ́mɛɛ n léeripɔ ɑ́i yɛ́ fe likɛ́ Uléécɑɑ inipɛɛ-i mɛ́kpɛrinkpɛ u wɑisɛɛ? ");
INSERT INTO soy_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Likumúŋɛ́ rɛ ɑ́i urikiŋ kɛ́mɛɛ kɑi léeripɔ, ɑmɑ́ kuloi-i le, uu kɔ pɛɛ́ cukú. Yeesu mɛmɑɑ mɛɛ nyísɛlɛ̃ tɛ ilukɛ nnɛ́í yɛ kulukɛ welɛ. ");
INSERT INTO soy_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Uu pimɑ́ɑ pi kpɑ́ rɛ lɛlɛɛ usoi kɛ́mɛɛ n léenti lɛɛ yɛ mɛ́kpɛrinkpɛ u wɑisɛ. ");
INSERT INTO soy_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Liriyíkí rɛ usoi kɛfɑ-i kɛ simúŋɛ́ kópɛ nfɑsimɛ́ nɛ iwɑ́sɑ́ nɛ piyɑɑ nɛ pisoikõ ");
INSERT INTO soy_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","nɛ ucɔ unɔsi nɛ́ɛ ucɔ ulɑ kuwɑ́ncɔ piwɑi nɛ mɛmɑ́ nnɑ́ɑ́pí nɛ rikpɑ́kɑ́rɑ́ nɛ piyɑɑlukɛ nɛ nturi nɛ inípɛɛ cɑɑ-cɑɑ nɛ picɔ ɑlɛ̃ nɛ rikɔ́kɔri nɛ píyuwɛ́lɑɑ ɑi léenti. ");
INSERT INTO soy_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Nní nnɛ́í, usoi kɛfɑ-i kɛ nní nnɛ́í ɑi léenti, lɛlɛɛ yɛ kɔ mɛ́kpɛrinkpɛ u wɑisɛ. ");
INSERT INTO soy_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Kɛ Yeesu uu kei n yisi, uu Tiiri kuyu kuwɛ́lɛ́-mɛ̃ sĩ. Uu kɛ́yɔ kɛnyinɛ-i tonɛ. Úu lɑ unyinɛ ukɛ́ u yɛ̃. Amɑ́ ḿpɑ́ nɛ lɛ̃, úu fe ukɛ́ umɛcirɛ pesí. ");
INSERT INTO soy_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Unɔ́si unyinɛ kɛwɑ̃ kɛɛ kuníri n héesi uu kóm pin Yeesu nsímɛ́ wɑi. Uu pɛɛ́ hɑ Yeesu kɛyu-i wúlɑ. ");
INSERT INTO soy_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Unɔ́si uyɛɛ usɑ́nɛ lɛ, úu *Usuifi. Sirii kɛteni-i kɑpi u mɑri. U Fenisii ukɔ́ lɛ. Uú nɛ Yeesu téni rɛ ukɛ́ uukpére kuníri lɑkɑsɛ. ");
INSERT INTO soy_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yeesu uu pɛɛ u mɑɑ rɛ: Ái nyɑḿ tɛ pikɛ́ siwɑ̃́ ilukɛ kpísi pikɛ́ sipɔpipi risɑ́. ");
INSERT INTO soy_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Unɔ́si uu rinɔ́ɔ u pɛsɛ rɛ: Mɛsei yɛ mɛ Sɑ́ɑ, ɑmɑ́ siwɑ̃́ sin pilukɛ m mɑsí, sipɔpipi yɛɛ lɛ̃ kɛ siwɑ̃́ ɑsi kɛteni-i m póroisɛ hínɛilɛ ɑsi le. ");
INSERT INTO soy_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yeesu uu pɛɛ u mɑɑ rɛ: Tipɔ́nɔ́ɔ ntí nnyɑ, ɑ n ŋme, kuníri yɛ upɔ́kpére kɛ́mɛɛ léepɔlɛ. ");
INSERT INTO soy_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Kuu kɛ́yɔ n kúi, uu kɛwɑ̃́ lɛɛpɔ kɛn nɛ kɛripɔɔ finu, kuníri kun tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yeesu uu limɛmɑ́ɑ́ Tiiri kɛtẽ yisi uu Sitɔɔ kuyu cɔpu, uu kuwɛ́lɛ́ kpɛ̃ kɑpi yɛ n sée rɛ Ayu Kɛfi kɛtẽ-mɛ̃ wɑlɑ́ uu Kɑlilee kupiyɛ-mɛ̃ pɛlɛ. ");
INSERT INTO soy_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Api pɛɛ́ nɛ utusuí yɛɛ úu nsímɛ́ n fe ńsɔnɛ Yeesu weri. Apí nɛ u téni rɛ ukɛ́ ɑnípɛ ukɛcɑ́ɑ́ rilɑɑ. ");
INSERT INTO soy_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yeesu uú nɛ iyɑɑ u lelu, uú nɛ pisoi kɛtɑɑ wɑi uu usinipɛpi ɑtu-i u tɑmpɔ uu rilémpi kɛcɑ́ɑ́ mɛtɑ u tɛŋ́. ");
INSERT INTO soy_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Uu lɛ̃ mɛmɑ́ɑ́ nfɑ́ɑ tɔ́ɔ́ri uu rɛ: Efɑɑtɑ, liɑsei rɛ: A tɑ́pilɛ. ");
INSERT INTO soy_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Mɛsɛ nɛ mɛsɛ uɑtu ɑɑ tɑ́pilɛ, tilémpi ɑri fénnɛ, uu nsímɛ́ loni ńsɔnɛ. ");
INSERT INTO soy_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yeesu uu lɛ̃ mɛmɑ́ɑ́ rinɔ́ɔ pi hɛ rɛ ɑ́pi kɑpɛ tíyɛsɛ unyinɛ ukɛ́ kṍ. Amɑ́ ḿpɑ́ Yeesu mɛmɑlɛ mɛ́ye kɛ pɛ̃ ɑpi nsímɛ́ piyóó ŋmɔ́ɔ́púlɛ̃. ");
INSERT INTO soy_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Pírí píimɑ kɑi mɛyɑ́nsei pi wɑ ɑpí m mɑ́ikɛɛ rɛ: Lɛ̃ nnɛ́í kuu n wɑ, ɑsɑɑ lo, ḿpɑ́ pitusuí, u yɛ pi komɛisɛlɛ, uu pɛ̃ ɑlempi nyɛɛ m pɑhɑɑlɛ̃ símɑɑsɛ. ");
INSERT INTO soy_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Pisoi kulúi ɑpi kɔ kumúŋɛ́ kpɛ-i picɑ́pinɛ kpɑ́ ńsɔnɛ ɑ́pi kɔ líkɑ mɑ́ pikɛ́ li. Yeesu uu upipirɛtiki séi uu pi mɑɑ rɛ: ");
INSERT INTO soy_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Pisoi mpí icɔ yɛ íwɛ nɛ́ welɛ. Siyɑ́ɑ sitɑɑni yɛ nsí kɑpi nɛ́ tíkilɛ̃ ɑ́pi kɔ líkɑ mɑ́ pikɛ́ li. ");
INSERT INTO soy_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Pimɛyɑ̃ yɛ kɛtɑɑ leerilɛ. Lɛ̃ nnyɑ, nɛn nkpéni nɛ nkṹ mmú pi m mɑɑ rɛ pikɛ́ kúi, pi yɛ́ hɑ nsẽ́ pɔɔnɛ. ");
INSERT INTO soy_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Kei kɛ upipirɛtiki ɑpi rinɔ́ɔ u yɔsí rɛ: Yei kɑri yɛ́ pisoi píimɑ mpí nnɛ́í ilukɛ yɛ̃ kɛlõ kóimɑ nkɛ́-i? ");
INSERT INTO soy_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yeesu uu pi pisɛ rɛ: Akpɔ́nɔ́ ɑlɛ́ kɑni mɑ́? Api rinɔ́ɔ yɔ́su rɛ: Asɛɛi. ");
INSERT INTO soy_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Uu limɛmɑ́ɑ́ pisoi pɛ̃ tinɔ́ɔ hɛ rɛ pikɛ́ kɛteni-i tonɛ, uu ɑkpɔ́nɔ́ ɑsɛɛi nyɛ̃ yɔ́su, uu ɑkɛcɑ́ɑ́ Uléécɑɑ pɔɔnɛsɛ uu pɛɛ ɑ kpɔ́kɔrinɛ uu upipirɛtiki ɑ pɑ pikɛ́ hɔ́ɔ́nɛntɛ, ɑpi pisoi ɑ hɔɔnɛ. ");
INSERT INTO soy_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Pi kɔ pɛɛ ikpíntomɛ́ inyinɛ mɑ́lɛ. Yeesu uu kɔ iyɛ̃ kɛcɑ́ɑ́ Uléécɑɑ pɔɔnɛsɛ uu rɛ pikɛ́ kɔ iyɛ̃ hɔɔnɛ. ");
INSERT INTO soy_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Api le ɑpi lɛpu, ɑpi ilukɛ pɔɔnɛ-pɔɔnɛ kɔ́ɔ́i ɑnɛ́rɛ ɑsɛɛi. ");
INSERT INTO soy_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Pisoi pɛɛ tu yɑrɛ ɑ́kotokú ɑnɑ (4.000). Kɑpi ḿ mɑsí, Yeesu uu pɛɛ rɛ pikɛ́ kúi. ");
INSERT INTO soy_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","U nɛ upipirɛtiki ɑpi mɛsɛ nɛ mɛsɛ kúninɔi loni ɑpi Tɑlimɑnutɑ kɛtẽ sĩ. ");
INSERT INTO soy_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Pifɑrisi ɑpi Yeesu lɛɛpɔ ɑpí nɛ íkɛŋɛnɛ u kɑ́pɑ́ɑ́ ɑpi pɛɛ ripinɛ u wɑi rɛ ukɛ́ nyísɛ rɛ Uléécɑɑ kɛ́mɛɛ kɛ unnɑŋɛ nn léeri. ");
INSERT INTO soy_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yeesu uu mɛyɑ̃́ nfɑ́ɑ tɔ́ɔ́ri, uu ukɛfɑ-i mɑɑ rɛ yo nnyɑ kɛ nfɑ́ɑni pisoi mpí ɑpi mɛwɑisɑŋɑ piyɛ́nɛ lɑ? Asei kɑm nɔ́ símisi, nfɑ́ɑni pisoi mpí ɑ́pi mɛwɑisɑŋɑ mɛ́kɑ yɛnunɛ. ");
INSERT INTO soy_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Uu lɛ̃ mɛmɑ́ɑ́ kei pi yɑ́ uu kúninɔi loni uu rikóitimɛ ricɔ sĩ. ");
INSERT INTO soy_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Upipirɛtiki yɛ pɛɛ ɑkpɔ́nɔ́ kɛcɑ́ɑ́ pɑlɛilɛ. Kusɛ ŋmɑnɛ kɑpi múílɛ̃ kúninɔi-i. ");
INSERT INTO soy_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yeesu uu rinɔ́ɔ pi hɛ rɛ: Ani nɔ́mɛnɛ́círɛ tĩ ńsɔnɛ nɛ Pifɑrisi nɛ Erooti nkpɔ́nɔ́tɔ pitɛ. ");
INSERT INTO soy_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Pipirɛtiki yɛ pimɛcɔpɛcirɛ símisi rɛ ɑ́pi ɑkpɔ́nɔ́ mɑ́. ");
INSERT INTO soy_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Kɛ Yeesu uu lɛ̃ n céri, uu pi pisɛ rɛ: Yo nnyɑ kɑni mɑ́ikɛɛ rɛ ɑ́ni ɑkpɔ́nɔ́ mɑ́? Ái kɑhɑnɛ nɔ́ rikpɑ̃́ii nɛ́ɛ ɑ́ni kɑhɑnɛ n ceri? Nɔ́ɑnɛ́tu yɛ tɑkɑsilɛɛ? ");
INSERT INTO soy_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nɔ inípɛɛ mɑ́lɛ, ɑ́ni kɔ pɛɛ nyɑ́ni, nɔ ɑtu mɑ́lɛ ɑ́ni kɔ pɛɛ kómɛi. Áni léisɛɛ? ");
INSERT INTO soy_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Kumúŋɛ́ kpɛ-i kɑm ɑkpɔ́nɔ́ n kpɔ́kɔrinɛ ɑm pisoi ɑ́kotokú ɑnupũ (5.000) hɔɔnɛ, ɑnɛ́rɛ ɑlɛ́ kɑni ilukɛ tɔrɔɔ yípũ ɑní nɛ tɔ́mpɔ? Api u mɑɑ rɛ ɑnɛ́rɛ kɛfi nɛ ɑtɛ́. ");
INSERT INTO soy_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yeesu uu kɔ pi pisɛ rɛ: Kɑm ɑkpɔ́nɔ́ ɑsɛɛi pisoi ɑ́kotokú ɑnɑ (4.000) n kpɔ́kɔrinɛ ní, ɑnɛ́rɛ ɑlɛ́ kɑni ilukɛ tɔrɔɔ yi? Api rɛ: Asɛɛi. ");
INSERT INTO soy_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Uu pɛɛ pi mɑɑ rɛ: Ái kɑhɑnɛ nɔ́ n hemnɛɛ? ");
INSERT INTO soy_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Kɛ Yeesu nɛ upipirɛtiki ɑpi Petisɑyitɑ n tu, pisoi ɑpí nɛ unyíyɛ unyinɛ u lɛɛpɔ ɑpí nɛ u téni rɛ ukɛ́ u ricɑ. ");
INSERT INTO soy_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yeesu uu unyíyɛ kunípɛ tini uu u tɔrɔi uú nɛ kuyu ilúkɛ́ sĩ́ uu pɛɛ mɛtɑ inípɛɛ-i u wɑi, uu ɑnípɛ ukɛcɑ́ɑ́ lɑ́ɑ uu u pisɛ rɛ: Pɔ linyinɛ nyɑ́nii? ");
INSERT INTO soy_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Unyíyɛ uú weríí uu rɛ: Nɛ pisoi nyɑ́nilɛ, ɑmɑ́ pi pɛɛ́ welɛ yɑrɛ ɑléé, pin sɔ́nɛ. ");
INSERT INTO soy_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yeesu uu uinipɛɛ pícɑ kpɑ́, kɛ unyíyɛ uu n nyɑ́nɛi tíkí-tíkí, uu pélu uu ḿpɑ́ yo n nyɑ́ni cɑ́í-cɑ́í. ");
INSERT INTO soy_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yeesu uu pɛɛ u mɑɑ rɛ ukɛ́ kúi, ɑmɑ́ úu kɑpɛ kuyu lõ. ");
INSERT INTO soy_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yeesu nɛ upipirɛtiki ɑpi Sesɑree Filipu siyupi kɛ́mɛɛ sĩ́. Uu ncée kɛ́mɛɛ pi pisɛ rɛ: Pisoi yɛ mɑ́ikɛɛ rɛ nɛ́ɛ úye? ");
INSERT INTO soy_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Pi mɑ́ikɛɛ rɛ pɔ́ɔ Yohɑni yɛɛ míni pisoi ń wolɛ, picɔ rɛ pɔ́ɔ Elii, picɔ rɛ pɔ ɑntepuyɛ kɛcɔpɛ unyinɛ lɛ. ");
INSERT INTO soy_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yeesu uu pi pisɛ rɛ: Nɔ̃́ ni? Nɔ mpíí mɑ́ikɛɛ rɛ nɛ́ɛ wóo? Piyɛɛ uu rinɔ́ɔ u yɔ́su rɛ pɔ̃́ kɛ Uléécɑɑ uu mɛkɛɛ-mɛ wɛ́ɛ. ");
INSERT INTO soy_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yeesu uu pi nyi rɛ ɑ́pi kɑpɛ linkɑ úkɑ símisi. ");
INSERT INTO soy_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Uu mɛncirɛ picélɑɑ pi koru rɛ li pisɛ rɛ Usoi Kɛpipi kɛkɛ́ mɛyɑ́nsei íwɛ li. Pisuifi piwɛ́ɛ́sɛ nɛ pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ nɛ isé picélɑɑ pikɛ́ kɛ ŋmɛriyɛ. Li kɔ pisɛ rɛ pikɛ́ kɛ kpu ɑkɛ kɔ kɛyɑ́ɑ tɑ́ɑ́nũ tuŋɛ́ yisi. ");
INSERT INTO soy_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","U símisilɛ ńsɔnɛ kpɑ̃́ii. Kei kɛ Piyɛɛ uu iyɑɑ u sée uu rɛ ɑ́i lɛ̃ kuu yɛ́ pɛɛ wɑ. ");
INSERT INTO soy_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yeesu uú ŋmɛɛlú uu upipirɛtiki pɑí uú nɛ Piyɛɛ cɛ́si rɛ: Setɑni, ɑ nɛ kɛtɑɑ nɛ́ wɑ, likumúŋɛ́ rɛ sipɔ́múŋɛ́ ɑ́si Uléécɑɑ sikɔ́, ɑmɑ́ sisoipipi sikɔ́ yɛ si. ");
INSERT INTO soy_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yeesu uu pɛɛ lɛ̃ mɛmɑ́ɑ́ pisoi nɛ upipirɛtiki séi uu pi mɑɑ rɛ: Uɑye un n lɑ ukɛ́ nɛ́ ritiki, ukɛ́ umɛcirɛ pípɑí riyɑ́, uu ukunɑpɛ́ɛ́kɔɔ́ yɑ uu pɛɛ nɛ̃́ tiki. ");
INSERT INTO soy_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ái líkɑ nnyɑ, úye un n lɑ ukɛ́ unfɑɑ lɔ, u n fómnilɛ, ɑmɑ́ úye un unfɑɑ n fóm nɛ̃́ nɛ Nsímɛ́ Kɛcirɛ nnyɑ, liute yɛɛ yɛ́ unfɑɑ lɔ. ");
INSERT INTO soy_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Usoi kulɑɑ yɛ kúye in tɛ u kɛtẽ nté mɛmɑ́ nnɛ́í yɛ̃́ uu pɛɛ kpi. ");
INSERT INTO soy_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Linyinɛ yɛ we kɛ usoi uu yɛ́ n hɛ́ɛ́lɛ ukɛ́ nɛ unfɑɑ n lɔɔ? ");
INSERT INTO soy_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Úye un nɛni inɛ́sɛi nɛ nnɛ́símɛ́ isɛi n wɑ, piwɑ́sɑ́nkɑí nɛ pikópɛkɔɔ́ mpí kɛcɔpɛ, Usoi Kɛpipi yɛ́ kɔ uisɛi wɑ, kɛn píyei m pɛɛri nɛ kɛusɑɑ mɛyɔɔpi nɛ piléécɑɑtumɛ. ");
INSERT INTO soy_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Uu pimɑ́ɑ pi kpɑ́ rɛ: Asei kɑm nɔ́ símisi, pinyinɛ yɛ nté welɛ pɛɛ yɛ́ Uléécɑɑ iyɔɔpi n yɛ̃́ in nɛ innɑŋɛ wemɛ ɑpi kɛlenɛ kpíni. ");
INSERT INTO soy_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Siyɑ́ɑ sikpuulũ mɛmɑ́ɑ́, Yeesu uu Piyɛɛ nɛ Yɑkupu nɛ Yohɑni kpísi ɑpí nɛ riyɔ́pɛ cɑ́cɑ́ rinyinɛ tɑɑ́ ɑpí hɑ kei pimɛcirɛ n we. Uipiŋɛ ii consɛ piinipɛɛ-i. ");
INSERT INTO soy_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Uilũ ií n tɛ́lu, ii wɑ́rɑrɑ póí-póí, ntómɛ́ mmɛ̃ ńn ncɔ mɑ́ kɛtẽ nkɛ́ nɛ kɛnkinii. ");
INSERT INTO soy_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Kei kɛ Elii nɛ Moisi ɑpi pɛɛ rikpɑ́fúmɛ, pi nɛ Yeesu pin yɔ́i. ");
INSERT INTO soy_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Piyɛɛ uu pɛɛ Yeesu mɑɑ rɛ: Sɑ́ɑ, li nyɑmlɛ rɛ tɔkɛ́ pɛɛ nté n we. Tɔ lɑ rɛ tɔkɛ́ sicɑ́ŋíípi sitɑɑni kɑrii, pɔ̃́ kɛsɛ, Moisi kɛsɛ, Elii kɛsɛ. ");
INSERT INTO soy_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Piyɛɛ úu nkpɑ́ni nyu mmɛ̃ kuu yɛ́ pɛɛ ḿ mɑlɛ, likumúŋɛ́ rɛ iwɑmɛ yɛ u nɛ Yeesu pipirɛtiki tɔrɔɔ wɑlɛ hɑ́i. ");
INSERT INTO soy_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Kuhopɛ kunyinɛ ɑkú weri ɑku pi hilɑ. Tinɔ́ɔ rinyinɛ ɑri kuhopɛ kpɛ-i léeri rɛ: Nkó yɛɛ Kɛnɛ́pipi lɑlɑ, ɑni kutu kɛ ricɔ. ");
INSERT INTO soy_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Mɛsɛ nɛ mɛsɛ ɑpi piilúkɛ́ nnɛ́í pɑ́ii, ɑmɑ́ ɑ́pi úkɑ yɛ̃, Yeesu yɛɛ pikɛkúrí ń we mɛmɑ́ɑ́. ");
INSERT INTO soy_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Kɑpi riyɔ́pɛ n cɛ́pilɛ̃, Yeesu uu rinɔ́ɔ pi hɛ rɛ ɑ́pi kɑpɛ tíyɛsɛ unyinɛ ukɛ́ lɛ̃ kɑpi n yɛ̃́ kõ hɑ́i nɛ kɛyɑ́ɑ kɛ̃ kɛ Usoi Kɛpipi ɑkɛ yɛ́ pikpɔkpɔ-i n yisi. ");
INSERT INTO soy_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Api nsímɛ́ mmɛ̃ nyi, ɑmɑ́ ɑpi pimɛcɔpɛcirɛ m písɛinɛ rɛ yoo pikpɔkpɔ kɛ́mɛɛ mɛyisɛ? ");
INSERT INTO soy_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Lɛ̃ mɛmɑ́ɑ́, upipirɛtiki ɑpi u pisɛ rɛ: Yo nnyɑ kɛ isé picélɑɑ ɑpi mɑ́ikɛɛ rɛ Elii yɛɛ pɛɛrinɛ likɛ́ kɛlenɛ kɛtẽ kɛtɔ tu? ");
INSERT INTO soy_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Uu pi pɛsɛ rɛ: Mɛsei yɛ mɛ rɛ Elii yɛ pɛɛrinɛ kɛlenɛ ukɛ́ ḿpɑ́ yo nyɔ́ɔnsɛ. Yo nnyɑ kɑi mpíí wɔ́lɑɑlɛ̃ tɛ Usoi Kɛpipi yɛ íwɛ lenɛ mɛyɑ̃́ ɑpi kɛipuri yulu? ");
INSERT INTO soy_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Amɑ́ nɛ lɑ kɛ́ nɔ́ símisi rɛ Elii yɛ pipɛɛmɛ mɑsilɛ pisoi ɑpí nɛ u wɑi lɛ̃ kɑpi ń lɑ yɑrɛ kɑi ukɛcɑ́ɑ́ n wɔ́lɑɑmɛlɛ̃. ");
INSERT INTO soy_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Kɑpi pipirɛtiki tɔrɔɔ n nyɑhɑipɔ, ɑpi pisoi kulúi yɛnu pin kɛwúípi pi wɑilɛ̃, isé picélɑɑ pin nɛ pi kɛŋɛnɛ. ");
INSERT INTO soy_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Kɛ pisoi ɑpi mɛsɛ nɛ mɛsɛ Yeesu n yɛ̃́, ɑi pi kɑikɑi, ɑpi pɛɛ n wúrunkɛɛpɔ pikɛ́ u yɑ́ɑ́si. ");
INSERT INTO soy_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yeesu uu upipirɛtiki pisɛ rɛ: Yoo mpíí nɔ́ nɛ pɛ̃ kɛŋɛnɛsɛ? ");
INSERT INTO soy_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Utisi unyinɛ uu pɛɛ riwúí tɛ-i rinɔ́ɔ yɔ́ɔri rɛ: Sɑ́ɑ, kɛpɔ́mɛɛ́ kɑrí nɛ kɛnɛ́pipi kɑ. Kuníri kpɛɛ kɛ n lõ yɛ nsímɛ́ kɛ pɔɔnɛsɛlɛnlɛ. ");
INSERT INTO soy_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ḿpɑ́ yei kɑi kɛ yisi, ku yɛ kɛtẽ kɛ tɑlɛ ɑkɛ ɑtɑlɑlɑɑ́ léeri, kɛn ɑnĩ́ tɑkɑi, ipiŋɛ ii nɑ́nu. Aḿ nɛ pipɔ́pirɛtiki téni rɛ pikɛ́ kuníri kpɛ̃ lɑkɑsɛ, ɑmɑ́ ɑ́pi fe. ");
INSERT INTO soy_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yeesu uu rinɔ́ɔ pi yɔ́su rɛ: Nɔ́ nfɑtɛnɛcirɛ́ pikɔ́ mpuri mmú, ituŋɛ ilɛ́ kɑm nɔ́kɛnɛ́mɛɛ pitónɛ kpɑ́nɛ? Ituŋɛ ilɛ́ kɑm yɛ́ lɛ̃ nɛ nɔ́ n kɑhɑri? Ani nɛ kɛwɑ̃́ nɛ́ kɑm. ");
INSERT INTO soy_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Apí nɛ kɛ u hɑpɔ. Kɛ kɛwɑ̃́ ɑkɛ Yeesu n yɛ̃́, kuníri ɑku kei nní kɛ lémesi, ɑkɛ kɛteni-i lólu ɑkɛ́ m pímiisɛ kɛn ɑtɑlɑlɑɑ́ léeri. ");
INSERT INTO soy_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yeesu uu kɛusɑɑ pisɛ rɛ: Píyei-mɛ kɑi yɛ nní kɛ wɑ? Uu rinɔ́ɔ yɔ́su rɛ: Hɑ́i uiwɑ̃-mɛ le. ");
INSERT INTO soy_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Mɛpehẽ kulúi kɛ kuníri kpɛ̃ ɑku yɛ nnɑ nɛ míni-i kɛ risɑ́pɔ kɛkɛ́ nɛ n kpu nnyɑ. Amɑ́ in tɛ pɔ́ fe ɑɑ linyinɛ wɑi, ɑ kɑm ɑɑ rɔ́ comɛ. A irɔ́wɛ ripɑí. ");
INSERT INTO soy_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yeesu uu rinɔ́ɔ u pɛsɛ rɛ: In tɛ pɔ́ fe nɛ́ɛ? Úye un nɛ ukɛfɑ Uléécɑɑ n tɛnɛ, úu líkɑ pɔɔnɛnɛ. ");
INSERT INTO soy_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Mɛsɛ nɛ mɛsɛ, kɛwɑ̃́ kɛ̃ usɑɑ u pupɛi rɛ: Nɛ̃́ nɛ kɛfɑ tɛnɛlɛ! Amɑ́ ɑ kɑm ɑ nɛ́ comɛ, nnɛ́fɑtɛnɛ ńn piyɛ. ");
INSERT INTO soy_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Kɛ Yeesu uu risoiwuí n yɛ̃́ tin u kɑ́lɑɑri, uu kuníri semni rɛ: Pɔ̃́ kuníri kpɛ̃, pɔ́ɔ yɛ ɑtusuí usoi n wɑisɛ ɑɑ nsímɛ́ u pɔɔnɛsɛ, ɑ kɛwɑ̃́ kɛ-i le, kɑpɛ píkɑi kɛkɛmɛɛ pɛɛpɔ, nɛ́ɛ rinɔ́ɔ pɔ́ hɛ. ");
INSERT INTO soy_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Akú lelu kun pupukɛɛ, kun kɔ kɛwɑ̃́ nɑnɛisɛlɛ̃. Kɛwɑ̃́ ɑkɛ́ n we yɑrɛ kɛ kpulɛ, pisoi mɛyɑ̃ ɑpi wɑisɛ rɛ kɛ kpulɛ. ");
INSERT INTO soy_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Amɑ́ Yeesu uu kɛkunipɛ múlú uu kɛ yukusɛ, ɑkɛ yisi ɑkɛ nyɛrɛ. ");
INSERT INTO soy_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Kɛ Yeesu uu lɛ̃ mɛmɑ́ɑ́ kɛ́yɔ n lõ, upipirɛtiki ɑpi pimpehencirɛ u pisɛ rɛ: Yo nnyɑ kɑ́ri fe tɔkɛ́ kuníri nkú lɑ́kɑsɛ? ");
INSERT INTO soy_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Uu pi mɑɑ rɛ: Kɛyómɛ mɛcirɛ kɛ usoi uu yɛ́ yɑ́ɑ́si uú nɛ kuníri nkú mpuri lɑkɑsɛ. ");
INSERT INTO soy_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Api kei yisi ɑpi Kɑlilee kɛtẽ tɛ́ŋ́. Yeesu úu pɛɛ́ lɑ pikɛ́ kei kuu ń we ceri. ");
INSERT INTO soy_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Likumúŋɛ́ rɛ u yɛ pɛɛ upipirɛtiki céésilɛ uu yɛ pi mɑɑ rɛ: Pi Usoi Kɛpipi tininɛ ɑpi pisoi ɑnipɛ-i kɛ wɑi pikɛ́ kɛ kpu. Kɛmɛkpɔ-mɑɑ́, kɛ yɛ́ kɛyɑ́ɑ tɑ́ɑ́nũ tuŋɛ́ nkpɔ kɛ́mɛɛ yisi. ");
INSERT INTO soy_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Amɑ́ Yeesu pipirɛtiki ɑ́pi mɛyu mɛ̃ kõ. Iwɑmɛ íi kɔ ŋmurɛi pikɛ́ pisɛ. ");
INSERT INTO soy_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Api Kɑpɛrinɑwum tulu. Kɑpi kɛ́yɔ n tu, Yeesu uu pi pisɛ rɛ: Yoo pɛɛ ncée kɛ́mɛɛ nɔ́ kɛ́ŋɛnɛsɛ? ");
INSERT INTO soy_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Amɑ́ ɑpi sɛ́ɛ́ keu. Ái líkɑ nnyɑ, pi pɛɛ ncée kɛ́mɛɛ kɛ́ŋɛnɛ rɛ úye yɛɛ pikɛcɔpɛ uwɛ́ɛ́sɛ? ");
INSERT INTO soy_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yeesu uu pɛɛ́ tonɛ, uu upipirɛtiki kɛfi nɛ pitɛ́ séi uu pi mɑɑ rɛ: Úye un n lɑ ukɛ́ ufoí, li pisɛ rɛ ukɛ́ nɔ́nnɛ́nɛ́í utɔrɔɔ uu nɔ́nnɛ́nɛ́í ukɛikɔ́. ");
INSERT INTO soy_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Uu kɛwɑ̃́ kɛnyinɛ kpísi uu pikɛcɔpɛ nyɛrɛsɛ, uu kɛ kpísi uu pɛ́kɛ́rí uu pɛɛ pi mɑɑ rɛ: ");
INSERT INTO soy_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Úye un siwɑ̃́ nsí kɛcɔpɛ kɛ́ye kusɑ́nɛ n yɔsí nɛ̃́ nnyɑ, tinɛ́cúruu kuu kusɑ́nɛ yɔsí, úye un kɔ kusɑ́nɛ nɛ́ n yɔsí, ɑ́i rinɛ́cúruu kuú yɔsí, ɑmɑ́ uyɛɛ nɛ́ n tummɛ kuú yɔsí. ");
INSERT INTO soy_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yohɑni uu u mɑɑ rɛ: Sɑ́ɑ, tɔ unyinɛ yɛnlɛ un ɑníri lɑkɑsɛ nɛ ripɔ́nyíri nnɑŋɛ úu kɔ pɛɛ rɔ́ tíkilɛ̃. Kúu rɔ́ n tíkilɛ̃ nnyɑ, ɑrí nɛ u yulu. ");
INSERT INTO soy_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Amɑ́ Yeesu uu rinɔ́ɔ yɔ́su rɛ: Áni kɑpɛ nɛ u yɛ̀, likumúŋɛ́ rɛ úkɑ úu we yɛɛ yɛ rinɛ́nyíri nɛ mɛwɑisɑŋɑ n wɑ uu kei nní cirɛ nnɛ́kópɛ símisi. ");
INSERT INTO soy_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Úye un kɛrɔ́pirɛ n we uyɛ̃ úu urɔ́lɑ́ɑrɔ. ");
INSERT INTO soy_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Kɑni nɛ̃́ Kirisi pikɔ́ nnyɑ, úye un kɔ rinɛ́nyíri nnyɑ míni nírɛ́-nirɛ́ nɔ́ n hɛ, ɑsei kɑm nɔ́ símisi, liute úu uihɛ́ɛ́ pɑɑnɛ. ");
INSERT INTO soy_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Amɑ́ úye un siwɑ̃́ sɛɛ nɛ nní kɛfɑ nɛ́ n tɛnɛ kɛnyinɛ ɑkópɛ n wɑisɛ, li kutɔsi we pikɛ́ rinɑ́ipɑrɛ mulɛ-mulɛ ńŋmɛ wɑ ɑpi ripɔ́ɔ u lɛsi ɑpi mínimɑɑ-i u sɑ́pɔ. ");
INSERT INTO soy_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","In tɛ kupɔ́nípɛ kpɛɛ ɑkópɛ pɔ́ wɑisɛ, ɑ ku riké. Li kutɔsi we ɑ nfɑ́ɑ yɛ̃ nɛ kunípɛ keri nɛ kɑɑ yɛ́ ɑnípɛ kɛtɛ́ m mɑ́ ɑɑ́ nɛ nnɑ kpɔcirɛ́ kɛlõ loni, kei kɛ nnɑ ńn yɛ píkɑi n kpu. ");
INSERT INTO soy_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Kei kɛ ɑpɑpi nyɛɛ yɛ ipiŋɛ n li ɑ́ɑ yɛ n kpí, kei kɛ nnɑ ńn yɛ kɔ n kpu. ");
INSERT INTO soy_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","In tɛ kupɔ́nɑ kpɛɛ ɑkópɛ pɔ́ wɑisɛ, ɑ ku riké, li kutɔsi we ɑ kúnɑ kusɛ m mɑ́ ɑɑ́ nɛ nfɑ́ɑ yɛnu nɛ kɑɑ yɛ́ ɑ́nɑ kɛtɛ́ m mɑ́ ɑpí nɛ nnɑ kpɔcirɛ́ kɛlõ kɛ́mɛɛ pɔ́ sɑ́pɔ, kei kɛ nnɑ ńn yɛ píkɑi n kpu. ");
INSERT INTO soy_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Kei kɛ ɑpɑpi nyɛɛ yɛ ipiŋɛ n li ɑ́ɑ yɛ n kpí, kei kɛ nnɑ ńn yɛ kɔ n kpu. ");
INSERT INTO soy_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","In tɛ mɛpɔ́nípɛɛ mɛɛ ɑkópɛ pɔ́ wɑisɛ, ɑ mɛ lesɛ ɑɑ kɛtɑɑ-pɔ fómni. Li kutɔsi we pɔkɛ́ Uléécɑɑ iyɔɔpi kɛ́mɛɛ lõ nɛ mɛnípɛɛ mɛsɛ nɛ kɑɑ yɛ́ inípɛɛ itɛ́ m mɑ́ ɑpi pɛɛ nnɑ kpɔcirɛ́ kɛlõ kɛ́mɛɛ pɔ́ sɑ́pɔ, kei kɛ nnɑ ńn yɛ píkɑi n kpu. ");
INSERT INTO soy_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Kei kɛ ɑpɑpi nyɛɛ yɛ ipiŋɛ n li ɑ́ɑ yɛ n kpí, kei kɛ nnɑ ńn yɛ kɔ n kpu. ");
INSERT INTO soy_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Likumúŋɛ́ rɛ: Pisoi nnɛ́í kɛcɑ́ɑ́ kɑpi nnɑ kɔɔnunɛ yɑrɛ kɑpi yɛ nní ilukɛ kɛcɑ́ɑ́ nnyɑ́si n fulɛi. ");
INSERT INTO soy_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Nnyɑ́si yɛ linyinɛ kɛcirɛ lɛ, ɑmɑ́ mmɛlõ mɛn n kpu, yo kɑpi yɛ nɛ n lɑrukusɛ? Ani nnyɑ́si mɛcɔ n lɑ́ɑ́rú, nkíŋniŋɛ nkɛ́ kɔ nɔ́kɛnɛ́cɔpɛ n we. ");
INSERT INTO soy_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yeesu uu ncée pɔlɔ uu Yutee kɛtẽ loni uu kɔ Yuritɛɛ rikoitimɛ ricɔ kuwɛ́lɛ́-mɛ̃ sĩ. Pisoi kulúi ɑpi kɔ pikɑ́lɑɑ u kpɑ́ uu kɔ pɛ̃ picélɑɑ loni yɑrɛ kuu yɛ n céesi. ");
INSERT INTO soy_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Pifɑrisi pinyinɛ ɑpí nɛ u kɔ pikɛ́ nɛ ripinɛ u n wɑ nnyɑ, ɑpi u pisɛ rɛ in tɛ ncée yɛ we rɛ utisi ukɛ́ uunɔsi yɛ. ");
INSERT INTO soy_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Uu rinɔ́ɔ pi pɛsɛ rɛ: Íye kɛ Moisi uu nɔ́ pisɛ rɛ ɑni wɑ? ");
INSERT INTO soy_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Api rinɔ́ɔ yɔ́su rɛ: Moisi yɛ utisi ncée hɛlɛ rɛ u yɛ́ fe uu pitúunnɛ ritɛlɛ́ unɔ́si wɔlu uu pɛɛ u yulu. ");
INSERT INTO soy_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yeesu uu pɛɛ pi mɑɑ rɛ: Nɔ́ɑnɛ́kíŋ ntɑkɛ nnyɑ kɛ Moisi uu isé nnyí nɔ́ wɔ́i. ");
INSERT INTO soy_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Amɑ́ ḿpɑ́ yo mɛwɑi kɛkorɑɑnɛ, Uléécɑɑ yɛ utisi nɛ unɔ́si wɑlɛ. ");
INSERT INTO soy_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Lɛ̃ nnyɑ kɛ utisi uu usɑ́ɑ nɛ úni yisinɛ uu unɔ́si kpísi ɑpi pɛ́nɛ, ");
INSERT INTO soy_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","u nɛ uyɛ̃ ɑpi pɑnsɛ ipiŋɛ isɛ. Kɑi nní lɛ̃ n wɑ, ɑ́pi nkpéni pitɛ́, ɑmɑ́ piipiŋɛ yɛ isɛ lɛ. ");
INSERT INTO soy_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Lɛ̃ nnyɑ usoi úu kɑpɛ lɛ̃ kɛ Uléécɑɑ uu rimpɛ́nɛ kóólɛnɛ. ");
INSERT INTO soy_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Kɑpi kɛ́yɔ ń hɑ, Yeesu pipirɛtiki ɑpi kɔ nsímɛ́ mmɛ̃ kɛcɑ́ɑ́ pipisɛ u kpɑ́. ");
INSERT INTO soy_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Uu pɛɛ pi mɑɑ rɛ: Úye un uunɔsi n yɛ̀ un uféé n kpísi, u nɛ unɔ́si foí púnnɛlɛ, iwɑ́sɑ́nkɑí kuu lɛ̃ wɑ. ");
INSERT INTO soy_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Unɔ́si un uulɑ n yɛ̀ un uféé n sɔ́ɔ̃, iwɑ́sɑ́nkɑí kuu lɛ̃ wɑ. ");
INSERT INTO soy_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Pisoi ɑpí nɛ Yeesu siwɑ̃́ lɛɛpɔ rɛ ukɛ́ si ricɑ. Amɑ́ upipirɛtiki ɑpí nɛ pi cɛ́si. ");
INSERT INTO soy_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Kɛ Yeesu uu lɛ̃ n yɛ̃́, ɑ́i nɛ u risɑ́, uu pi mɑɑ rɛ: Ani riyɑ́ siwɑ̃́ sikɛ́ kɛnɛ́mɛɛ́ kɑm, ɑ́ni kɑpɛ si tɑ́pisi, likumúŋɛ́ rɛ mpí pɛɛ simɛcɔ ń we pɛɛ yɛ́ Uléécɑɑ iyɔɔpi kɛ́mɛɛ lõ. ");
INSERT INTO soy_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Asei kɑm nɔ́ símisi, úye unsɑ́ Uléécɑɑ iyɔɔpi n ŋmurɛi yɑrɛ kɛ kɛwɑ̃́ ɑkɛ yɛ n ŋmurɛi, úu uiyɔɔpi kɛ́mɛɛ loninɛ. ");
INSERT INTO soy_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Uu pɛɛ lɛ̃ mɛmɑ́ɑ́ si sɑkɑɑ uu ɑnípɛ si lɑɑ uú nɛ rinɔ́ɔ sɔnɛ si tikisɛ. ");
INSERT INTO soy_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Kɛ Yeesu uu ncée m pɔ́lɔlɛ̃, utisi unyinɛ uu u tulu nɛ ntóó, uú hɑ ukɛyu-i wúlɑ uu pɛɛ u pisɛ rɛ: Sɑ́ɑ sɔnɛ, íye kɑm wɑinɛ kɛ́ nɛ nfɑ́ɑ tɛnɛcirɛ́ yɛ̃́? ");
INSERT INTO soy_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yeesu uu u mɑɑ rɛ: Yo nnyɑ kɑɑ nɛ́ sée rɛ Usɔnɛ? Úkɑ úu usɔnɛ, insɑ́ Uléécɑɑ mɛcirɛ. ");
INSERT INTO soy_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ḿpɑ́ likɛ́ íye wɑ, pɔ Uléécɑɑ isé nyulɛ rɛ: Kɑpɛ usoi kpu, kɑpɛ iwɑ́sɑ́ wɑ, kɑpɛ yɑ́ɑi, kɑpɛ nnɔ́ɔmɛ itɑnsei nyɛrɛ, kɑpɛ unyinɛ ncɑɑi ńkɑ wɑ, ɑ upɔ́sɑ́ɑ nɛ upɔ́ni ríyu wɑisɛ. ");
INSERT INTO soy_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Uu rinɔ́ɔ u yɔ́su rɛ: Sɑ́ɑ, hɑ́i inɛ́wɑ̃́-mɛ kɑm lɛ̃ múílɛ̃. ");
INSERT INTO soy_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yeesu uu u nyɑ́nɛi nɛ ńlɑ, uu pɛɛ u mɑɑ rɛ: Likɛi lisɛ lɛɛ pɔ́ pɑ́rílɛ̃, ɑ n ŋme ɑ lɛ̃ nnɛ́í kɑɑ m mɑ́ yɑ́ɑ́, ɑɑ siwóó sɛ̃ píwɛkɔɔ́ hɔ́ɔ́nɛ, pɔ́ pɛɛ mɛmɑ́ yɛ̃́ kɛyómɛcɑɑ-pɔ. Pɔn lɛ̃ piwɑi m mɑsí, ɑɑ pɛɛ́ weri ɑɑ nɛ́ tíki. ");
INSERT INTO soy_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Kɛ utisi uyɛ̃ uu ɑnɔ́ɔ nyɛ̃ n kṍ, kɛ ukunipɛ ɑku nní ḿ mulú nnyɑ, ukɛyu ɑkɛ cɔ́hɔnɛ uú nɛ mpɔ́ɔcɑɑi tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yeesu uu upipirɛtiki pɛɛ u n kɑ́lɑɑlɛ̃ nyɑ́nɛi, uu pi mɑɑ rɛ: Uléécɑɑ iyɔɔpi kɛ́mɛɛ pilonɛ yɛ nɛ pimɑ́mɑ́ pɑ́ɑ́pú kpɑ! ");
INSERT INTO soy_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Anɔ́ɔ nnyɛ́ ɑɑ Yeesu pipirɛtiki pírí wɑi. Amɑ́ Yeesu uu pimɑ́ɑ pi kpɑ́ rɛ: Sinɛ́pipi, ɑ tíyɛ Uléécɑɑ iyɔɔpi kɛ́mɛɛ pilonɛ yɛ pɔ́ɔ́lú kpɑ! ");
INSERT INTO soy_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kuyooyoo kun n lɑ kukɛ́ kɛhímpi kupolɛ-i lompɔ, li yɛ́ kutɔsi m purú nɛ kɛ umɑ́mɑ́ uu yɛ́ ń lɑ ukɛ́ Uléécɑɑ iyɔɔpi kɛ́mɛɛ n lompɔ. ");
INSERT INTO soy_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ai kɔ mɛyɑ́nsei pírí Yeesu pipirɛtiki kpɑ́, ɑpi pɛɛ́ m píseinɛ rɛ: In lɛɛ ni, wóo yɛ pɛɛ píyulɑlɛ yɛ̃? ");
INSERT INTO soy_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yeesu uu pi nyɑ́nɛi uu rɛ: Usoi kɛ́mɛɛ, lɛ̃ ɑ́i kuwɑi we, ɑmɑ́ ɑ́i Uléécɑɑ kɛ́mɛɛ. Likumúŋɛ́ rɛ ḿpɑ́ yo yɛ kuwɑi welɛ Uléécɑɑ kɛ́mɛɛ. ");
INSERT INTO soy_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Piyɛɛ uu pɛɛ u mɑɑ rɛ: A ripɑí kɑri lirɔ́kɔ́ nnɛ́í n tíyɛ tɔn pɔ́ tikilɛ̃. ");
INSERT INTO soy_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yeesu uu rinɔ́ɔ yɔ́su rɛ: Asei kɑm nɔ́ símisi, úkɑ úu we yɛɛ yɛ́ nɛ̃́ nɛ Nsímɛ́ kɛcirɛ nnyɑ, kɛ́yɔ nɛ pimɑ́ɑ nɛ piwɑ̃́, nɛ piyɛ́i nɛ píni nɛ pisɑ́ɑ nɛ siwɑ̃́ nɛ sicɑrɛ n tíyɛ ");
INSERT INTO soy_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","úu yɛ́ pɛɛ nɛni mɛwee mmɛ́-i síyɔ nɛ pimɑ́ɑ nɛ piwɑ̃́ nɛ piyɛ́i nɛ píni nɛ siwɑ̃́ nɛ sicɑrɛ mɛpehẽ pílɛ n yɛ̃́. Úu yɛ́ kɔ Yeesu pitiki iwɛ pɑɑ. U yɛ́ kɔ ɑŋmɛ̃ nyɛɛ n wémɛ kɛ́mɛɛ nfɑ́ɑ tɛnɛcirɛ́ yɛ̃́. ");
INSERT INTO soy_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Pifoí mɛyɑ̃ yɛ́ pitɔ́rɔɔ pɑnsɛ, pitɔ́rɔɔ mɛyɑ̃ ɑpi pifoí. ");
INSERT INTO soy_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ncée kɛ́mɛɛ kɑpí pɛɛ́ we pin Yerusɑlɛm-mɛ̃ sĩ. Yeesu un pikɛkpeẽ sɔ́nɛ, upipirɛtiki pin kɛwuu pirɑlɛ̃, iwɑmɛ in pɛpɛɛ pi n tíkilɛ̃ we. Yeesu uu kɔ upipirɛtiki kɛfi nɛ pitɛ́ kpísi uu lɛlɛɛ u n lɛɛrinɛ pi símisi ");
INSERT INTO soy_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","uu rɛ: Nɔ nyɑ́nii, Yerusɑlɛm kɑri nní símpɔ pikɛ́ hɑ kei Usoi Kɛpipi tĩ pikɛ́ pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ nɛ isé picélɑɑ ɑnipɛ-i wɑ, pɛ̃ pikɛ́ nɛ u túhɑɑnɛ ɑpi yekei rɛ pikɛ́ u kpu. Pi yɛ́ pɛpɛɛ ɑ́pi Uléécɑɑ m pɑkɑrɛlɛ̃ ɑnipɛ-i u wɑ. ");
INSERT INTO soy_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Pi yɛ́ mɛ́woo u nyɑ́nɛi ɑpi ukɛcɑ́ɑ́ mɛtɑ tukɛ, ɑpi isɛ́í u fopii ɑpi pɛɛ u kopu. Amɑ́ siyɑ́ɑ sitɑɑni mɛmɑ́ɑ́, u yɛ́ nkpɔ kɛ́mɛɛ yisi. ");
INSERT INTO soy_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sepetee sipipi kɛtɛ́, Yɑkupu nɛ Yohɑni ɑpí nɛ Yeesu kɔ ɑpi u mɑɑ rɛ: Sɑ́ɑ, tɔ lɑ rɛ ɑ lɛ̃ kɑri pɔ́ n welunɛ rɔ́ wɑ. ");
INSERT INTO soy_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Uu pi mɑɑ rɛ: Yo kɑni mpíí lɑ rɛ kɛ́ nɔ́ wɑ? ");
INSERT INTO soy_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Api u mɑɑ rɛ: Pɔn píyei ipɔ́yɔ́ɔpi kɛ́mɛɛ n tonɛ, tɔ lɑ rɛ ɑ tíyɛsɛ usɛ ukɛ́ kupɔ́lukɛ-lukɛ-mɛ̃ n tũ, ucɔ kupɔ́míi-mɛ̃. ");
INSERT INTO soy_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yeesu uu pi mɑɑ rɛ: Áni nyu lɛ̃ kɑni nní n welu. Nɔ́ fe ɑni ntóósi kɛporipi kɑm n nírunɛ níruu? Nɛ́ɛ nɔ́ fe ɑni íwɛ tɑkɑi yɑrɛ kɑm i n tɑkɑinɛ? ");
INSERT INTO soy_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Api rinɔ́ɔ yɔ́su rɛ: Tɔ́ li fe. Yeesu uu rinɔ́ɔ pi pɛsɛ rɛ: Mɛsei yɛ mɛ rɛ nɔ́ ntóósi kɛporipi kɑm n nírunɛ n ntí, tɛ íwɛ kɑm n tɑkɑinɛ kɑni tɑkɑinɛ. ");
INSERT INTO soy_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Amɑ́ in kunɛ́lukɛ-lukɛ nɛ́ɛ kunɛ́míi-mɛ̃ mɛtonɛ nkɔ́ mmú ɑ́i nɛ́ɛ yɛ́ tíyɛsɛ likɛ́ nɛ lɛ̃. Pɛ̃ nnyɑ kɛ sitónɛ sɛ̃ ɑsi n nyɔ́ɔnsɛlɛ̃ kuu si pɑnɛ. ");
INSERT INTO soy_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Kɛ Yeesu pipirɛtiki kɛfi tɔrɔɔ ɑpi lɛ̃ n kṍ, piɑpɔɔ ɑɑ́ nɛ Yɑkupu nɛ Yohɑni cɑɑi. ");
INSERT INTO soy_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yeesu uu pɛɛ pi séi uu pi mɑɑ rɛ: Nɔ nyulɛ rɛ pɛ̃ kɑpi n kpíilɛ̃ tɛ ɑyu piwɛ́ɛ́sɛ yɛ pinnɑŋɛ nɛ ɑ wéékusɛlɛnlɛ, pisoi kɛcirɛ pin pinnɑŋɛ ɑ nyísɛlɛ̃. ");
INSERT INTO soy_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Amɑ́ ɑ́i li mɛcɔ kɑi nɔ̃́ kɛ́mɛɛ we. Uɑye un n lɑ ukɛ́ nɔ́kɛnɛ́cɔpɛ uwɛ́ɛ́sɛ, ukɛ́ pɑnsɛ nɔ́unɛ́kɛikɔ́. ");
INSERT INTO soy_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Úye un kɔ nɔ́kɛnɛ́cɔpɛ ikpéẽ n lɑ, ukɛ́ nɔ́nnɛ́nɛ́í ulɑsi. ");
INSERT INTO soy_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Limɛcɔ kɛ Usoi Kɛpipi ɑ́kɛ kɑ rɛ pikɛ́ kɛ kɛisi, ɑmɑ́ kɛ kɑlɛ rɛ kɛkɛ́ picɔ kɛisi, ɑkɛ kɔ kɛnfɑɑ nɛ riwómɛ hɛ́ɛ́lɛ mɛyɑ̃́ mɛkɛ́ nɛ píyulɑlɛ ń yɛ̃́ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Api Yeriko tuipɔ. Kumúŋɛ́ kpɛ-i kɛ Yeesu nɛ upipirɛtiki nɛ risoiwuí ɑpi kuyu ń lelu, unyíyɛ unyinɛ yɛɛ n wélei kɑpi yɛ n sée rɛ Pɑtimee, Timee uŋmɑ́nɛ un ticéetimɛ tũ. ");
INSERT INTO soy_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Uu kóm tɛ Nɑsɑrɛti ukɔ́ Yeesu yɛɛ tɔ́su, uu sicɑ́ɑ́ilɑ kɑ́pɑ́ɑ́ rɛ: Tɑfiti kɛpipi, Yeesu, ɑ inɛ́wɛ ripɑí! ");
INSERT INTO soy_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Mɛyɑ̃́ ɑmɛ nɛ u cɛ́si rɛ ukɛ́ risɛ́ɛ́, ɑmɑ́ uu mɛyɑ̃́ cɑ́sɛ rɛ: Tɑfiti kɛpipi, ɑ inɛ́wɛ ripɑí! ");
INSERT INTO soy_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yeesu uu nyɛrɛ uu rɛ: Ani u séemɛ. Api unyíyɛ séipɔ, pin u mɑ́ikɛɛ rɛ: A n kɑhɑri, ɑ yisi, u pɔ́ séilɛ. ");
INSERT INTO soy_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Unyíyɛ uu ukɛtukɑnkɑ sɑ́ uu wɑ́kɑsi uu Yeesu-mɛ̃ sĩ, ");
INSERT INTO soy_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yeesu uu u pisɛ rɛ: Yo kɑɑ́ lɑ kɛ́ pɔ́ wɑ? Unyíyɛ uu rɛ: Unɛ́sɑ́ɑ, nɛ lɑ rɛ inɛ́nípɛɛ ikɛ́ yɛ yɛ̃. ");
INSERT INTO soy_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yeesu uu u mɑɑ rɛ: A n ŋme, mpɔ́fɑtɛnɛ yɛ pɔ́ yóriyɛ. Mɛsɛ nɛ mɛsɛ inípɛɛ ii wúkulɛ uu Yeesu tiki. ");
INSERT INTO soy_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Kumúŋɛ́ kpɛ-i kɑpi Yerusɑlɛm n nyɑhɑipɔ pin Pɛtifɑsee nɛ Petɑnii ɑyu kɛyúrí we, ɑléé nyɛ̃ kɑpi yɛ n sée rɛ Olifiyee rikúú kuwɛ́lɛ́-mɛ̃, Yeesu uu upipirɛtiki pitɛ́ tum ");
INSERT INTO soy_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","un pi tee rɛ: Ani kuyu kpɛɛ nní nɔ́kɛnɛ́yu ń wepɔ kɛ́mɛɛ hɑ. Nɔn píyei n tuipɔ, nɔ́ kɛminɑɑpipi kɛnyinɛ lɛɛpɔ kɛn torɑɑlɛ̃. Usoi úkɑ úu kɛ tonɛlɛ̃. Ani kɛ fénnɛ ɑní nɛ nɛ́ kɛ weri. ");
INSERT INTO soy_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Úye un nɔ́ m mɑɑ rɛ: Yo nnyɑ kɑni lɛ̃ wɑi? Ani rinɔ́ɔ u yɔ́su rɛ: Upíimɑ yɛɛ kɛ lɑ. U yɛ́ mɛsɛ nɛ mɛsɛ nɔ́ riyɑ́ ɑní nɛ nté kɛ weri. ");
INSERT INTO soy_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Api sĩ́ ɑpi kɛminɑɑpipi lɛɛpɔ ncée-i kɛn kɛtɑhɑi torɑɑlɛ̃ tinɔnɔɔ rinyinɛ kɛyúrí, ɑpi kɛ toriyɛ. ");
INSERT INTO soy_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Pɛpɛɛ kei ń we pinyinɛ ɑpi pi mɑɑ rɛ: Yo kɑni kei wɑi? Yo nnyɑ kɑni kɛminɑɑpipi kɛ̃ toriyɛ? ");
INSERT INTO soy_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Api rinɔ́ɔ yɔ́su yɑrɛ kɛ Yeesu uú pɛɛ ḿ mɑ. Api pi tíyɛ ɑpi tɔ́su. ");
INSERT INTO soy_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Apí nɛ kɛminɑɑpipi kɛ̃ Yeesu sĩ ɑpi kɛkɛcɑ́ɑ́ piilũ lɑɑi, Yeesu uu kɛ tonɛ. ");
INSERT INTO soy_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Pisoi mɛyɑ̃ ɑpi piilũ tɑ́ŋɛntɛ ncée kɛcɑ́ɑ́, picɔ ɑpi ɑpɛ́i kɑpi sicɑrɛ-i n kpɑ́si tɑ́ŋɛntɛ. ");
INSERT INTO soy_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Pisoi pɛɛ Yeesu kɛyu n sɔ́nɛ nɛ pɛpɛɛ ukɛpirɛ n tíkilɛ̃ pin pupukɛɛ rɛ: Osɑnnɑ! Ani Uléécɑɑ uyɛɛ n sɔ́nti nɛ Upíimɑ rinyiri ritɑɑ́sɛ. ");
INSERT INTO soy_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Uléécɑɑ ukɛ́ rinɔ́ɔ sɔnɛ uyɛɛ n sɔ́nti ukɛ́ urɔ́sɑ́ɑ Tɑfiti mɛcɔ iyɔ́ɔpi ń tonɛ ritikisɛ, Osɑnnɑ! Ani urinyiri kɛyómɛcɑɑ-pɔ ritɑɑ́sɛ. ");
INSERT INTO soy_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yeesu uu Yerusɑlɛm kuyu tulu, uu Uléécɑɑ kɛyɔ sĩ. Kɛ ituŋɛ ii n tɛnɛ nnyɑ, uu ḿpɑ́ yo pinyɑ́nɛi mɑ́su, u nɛ upipirɛtiki kɛfi nɛ pitɛ́ ɑpi Petɑnii tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kɑi n weesi, Yeesu nɛ upipirɛtiki ɑpi Petɑnii kuyu n leeri nkṹ nn Yeesu wɑi. ");
INSERT INTO soy_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Uu kɛtɑɑ-pɔ kúfikiyee yɛnu nɛ mɛpɛ́i. Uu rɛ u yɛ́ hɑ ɑpipi wɛ́ɛ́si. Amɑ́ kuu n tuipɔ, mɛpɛ́i ŋmɑnɛ kuu lɛɛpɔ, likumúŋɛ́ rɛ ituŋɛ iyɛ-i kɛ ɑléé nyɛ̃ ɑɑ yɛ m pi íi kɑhɑnɛ n tu. ");
INSERT INTO soy_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yeesu uu pɛɛ ku mɑɑ rɛ: Úkɑ úu kɑpɛ píkɑi ripɔ́pipi pilukɛ rikpɑ́. Upipirɛtiki ɑpi ɑnɔ́ɔ nyɛ̃ kom. ");
INSERT INTO soy_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Api lɛ̃ mɛmɑ́ɑ́ Yerusɑlɛm tulu, Yeesu uu Uléécɑɑ kɛyɔ loni. Uu pɛpɛɛ Uléécɑɑ kɛyɔ-i n yɑ́lisi nɛ pɛpɛɛ n lɛ́ɛ́ri pilɑ́kɑsɛ kɑ́pɑ́ɑ́, uu pɛpɛɛ siwóó n cɔhɔnɛ ɑtɑɑpili nɛ pilɔ́ɔlɑ̃yɑ́i situmpi lɑ́uli. ");
INSERT INTO soy_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Úu tíyɛsɛ unyinɛ ukɛ́ nɛ ilũ inyinɛ Uléécɑɑ kɛyɔ-mɛ̃ titiki. ");
INSERT INTO soy_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Uu pi céési rɛ: Li wɔlɑɑlɛ̃ tɛ: Pi yɛ́ kɛnɛ́yɔ sée rɛ sitẽ nnɛ́í pisoi kɛyomɛyɑ́hɑɑyɔ. Amɑ́ nɔ̃́ nɛ kɛ ripɔ́lɔ́sɛlɛ piyɑɑlukɛ kuhorɛ. ");
INSERT INTO soy_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ nɛ isé picélɑɑ ɑpi uɑnɔɔ nyɛ̃ kom, ɑpi ncée wɛ́ɛ́si pikɛ́ nɛ u kpu. Amɑ́ pin u wuru rɛ uicélɑɑ yɛ pɛɛ pisoi nnɛ́í pírí wɑ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kɑi nnyɔ́ɔ́ n wɑ, Yeesu nɛ upipirɛtiki ɑpi kuyu lelu. ");
INSERT INTO soy_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kɑi n weesi pin tɔ́su, Yeesu pipirɛtiki ɑpi kúfikiyee kpɛ̃ yɛnu kɑku n kóosi nɛ iníŋí-pɔ. ");
INSERT INTO soy_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Piyɛɛ uu lɛlɛɛ n wɑ léisɛ, uu Yeesu mɑɑ rɛ: Sɑ́ɑ, ɑ ripɑí, kuléé kɑɑ ɑnɔ́ɔ n wɑ yɛ kóosilɛ. ");
INSERT INTO soy_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yeesu uu upipirɛtiki rinɔ́ɔ yɔ́su rɛ: Ani nɛ Uléécɑɑ kɛfɑ tɛnɛ. ");
INSERT INTO soy_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Asei kɑm nɔ́ símisi: Úye un tikúú ntí m mɑɑ rɛ: A kei yisi ɑ hɑ mínimɑɑ-i ripɔlɔ, unsɑ́ ukɛfɑ-i n tíru, ɑmɑ́ un n wɑisɛ rɛ lɛ̃ kuu nní ḿ mɑ yɛ wɑinɛ, li yɛ́ mɛsei wɑ. ");
INSERT INTO soy_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Lɛ̃ nnyɑ kɑm nɔ́ tee rɛ: Ani yɛ wɑisɛ rɛ nɔ lɛ̃ nnɛ́í kɑni kɛyómɛyɑ́hɑɑ-i n welu piyɛ́nɛ mɑsilɛ, Uléécɑɑ yɛ́ kɔ nɔ́ li yɛnɛisɛ. ");
INSERT INTO soy_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Nɔn kɔ píyei n nyɛnu nɔn kɛyómɛ n yɑ́ɑ́si, nɔn nɛ unyinɛ nnyinɛ m mɑ́, ɑni u sɑ́rɛi, Nɔ́unɛ́sɑ́ɑ yɛɛ kɛyómɛcɑɑ-pɔ ń we ukɛ́ kɔ nɛ nɔ́rinɛ́cúruu ɑkópɛ nɔ́ n sɑ́rɛi nnyɑ. ");
INSERT INTO soy_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Amɑ́ nɔnsɑ́ yɛ ɑkópɛ n sɑ́rɛi, Nɔ́unɛ́sɑ́ɑ yɛɛ kɛyómɛcɑɑ-pɔ ń we úu kɔ nɔ́rinɛ́cúruu ɑkópɛ nɔ́ sɑ́rɛinɛ. ");
INSERT INTO soy_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Api kɔ Yerusɑlɛm pihɑ́pɛ kpɑ́, kumúŋɛ́ kpɛ-i kɛ Yeesu uu Uléécɑɑ kɛyɔ-i n kɔɔnii, pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ nɛ isé picélɑɑ nɛ Pisuifi piwɛ́ɛ́sɛ ɑpi u lɛɛpɔ. ");
INSERT INTO soy_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Api u mɑɑ rɛ: Ńnɑŋɛ ń-ye kɑɑ́ nɛ nní wɑi? Úye yɛɛ ńnɑŋɛ pɔ́ hɛ pɔkɛ́ nɛ nní n wɑi? ");
INSERT INTO soy_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yeesu uu rinɔ́ɔ pi yɔ́su rɛ: Kɛ́ nsɛ nɔ́ pisɛ. Nɔn tinɔ́ɔ nɛ́ m pɛsɛ, nɛ́ pɛɛ nɔ́ símisi ńnɑŋɛ mmɛ̃ kɑḿ nɛ lɛ̃ n wɑi. ");
INSERT INTO soy_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Uléécɑɑ nɛ́ɛ pisoi pɛɛ Yohɑni tummɛ rɛ ukɛ́ pisoi míni wolɛ? Ani rinɔ́ɔ nɛ́ pɛsɛ. ");
INSERT INTO soy_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Api pɛɛ pimɛcɔpɛcirɛ n kɛŋɛnɛ rɛ: Tɔn m mɑɑ rɛ: Uléécɑɑ, u yɛ́ mɑɑ rɛ: Kɑi pɛɛ íye wɑ kɑ́ni nɛ Yohɑni nsímɛ́ ŋmurɛi? ");
INSERT INTO soy_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Tɔn m mɑɑ rɛ: Pisoi, ɑ́i yɛ́ wɑ. Pi pɛɛ kuyu pikɔ́ wurulɛ, likumúŋɛ́ rɛ pinnɛ́í yɛ pɛɛ Yohɑni kpíilɛnlɛ yɑrɛ ɑntepu kɛcirɛ. ");
INSERT INTO soy_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Api Yeesu rinɔ́ɔ yɔ́su rɛ: Ári nyu, Yeesu pɔ́ɔ pi mɑɑ rɛ: Nɛ̃́ ɑ́m kɔ nɔ́ símisinɛ ńnɑŋɛ mmɛ̃ kɑḿ nɛ lɛ̃ n wɑi. ");
INSERT INTO soy_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yeesu uu pɛɛ lɛ̃ mɛmɑ́ɑ́ sinyɑ́rũ pi loni, uu rɛ: Utisi unyinɛ yɛɛ we, uu ɑléé nyɛ̃ kɑpi yɛ n sée rɛ fiinyi kɛcɑrɛ tɑmɛsi. Uu mmɛlɛ wɑi uú nɛ kɛ kɔ́ɔ́nú. Uu kɔ kɛcɑrɛ kɛ-i kuhórɛ túni uu kɛ́tɑcɛrii mɔm kei kɑpi yɛ́ pítɑ n cɛ́rii. Uu kɔ limɛmɑ́ɑ́ rikúsi cɑ́cɑ́ rinyinɛ mɔm uu pɛɛ pikɛikɔ́ wɛ́ɛ́si rɛ pikɛ́ kɛcɑrɛ kɛ̃ kɛcɑ́ɑ́ u m pɑílɛ̃ ukɛ́ ncée hɑ ukɛ́ kɑm. ");
INSERT INTO soy_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Kɑi ɑléépipi nyɛ̃ kutúũ n tu, uu ulɑ́si unyinɛ upikɛikɔ́ pɛ̃ kɛ́mɛɛ tumpɔ rɛ pikɛ́ ɑléépipi ɑnyinɛ u yɔ́ɔmɛ. ");
INSERT INTO soy_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Api u tini ɑpi kɑ́ii, ɑpi mɛnípɛ ŋmɑnɛ u lɑkɑsɛ. ");
INSERT INTO soy_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Uu kɔ ulɑ́si ucɔ pikɛmɛɛ tumpɔ, ɑpi uyɛ̃ tíyu kɛcɑ́ɑ́ kɑ́ii ɑpi u lɑ́misi. ");
INSERT INTO soy_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Uu utumɛ tɑ́ɑ́nũ tum, ɑpi uyɛ̃ kopu. Uu lɛ̃ mɛmɑ́ɑ́ pitumɛ mɛyɑ̃ túmɛipɔ, ɑpi picɔ kɑiinkɛɛ ɑpi kɔ picɔ kóni. ");
INSERT INTO soy_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ucɑrɛte uyɛ̃ uŋmɑ́nɛ lɑlɑ mɛcirɛ kɑí pɛɛ u pɔɔnɛ. Uu pɛɛ mɛtɔ́rɔɔ uyɛ̃ tumpɔ un tee rɛ: Pi yɛ́ unɛ́ŋmɑ́nɛ wuri. ");
INSERT INTO soy_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Amɑ́ pikɛikɔ́ pɛ̃ ɑpi símɑɑnɛ rɛ: Nkó yɛɛ mɑsí usɑ́ɑ ikulɑnlũ nnɛ́í te. Ani kɑm tɔkɛ́ u kpu ɑri pɛɛ uikulɑnlũ iyɛ̃ n te. ");
INSERT INTO soy_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Kuu n tuipɔ ɑpi u tini, ɑpi kópu ɑpi kɛcɑrɛ ilúkɛ́ u sɑ́. ");
INSERT INTO soy_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Íye kɛ ucɑrɛte uu wɑinɛ? U werinɛ ukɛ́ pikɛikɔ́ pɛ̃ kṍ uu ɑléé nyɛ̃ picɔ pɑ. ");
INSERT INTO soy_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Áni Uléécɑɑ Nsímɛ́ ritɛlɛ́ kɛ́mɛɛ kɛ́ɛ́nlɛ̃ tɛ: Tipɑrɛ kɛ pimɔ́mɛ ɑpi n fóm tɛɛ pɑnsɛ ticírɛ-cirɛ tɛɛ kɛnui-i ń wee? ");
INSERT INTO soy_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Upíimɑ yɛɛ lɛ̃ wɑ. Mɛwɑisɑŋɑ kuu rɔ́ n yɛ́nɛisɛ yɛ mɛ̃. ");
INSERT INTO soy_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Pisuifi piwɛ́ɛ́sɛ ɑpi céru rɛ pɛ̃ kɛ Yeesu kɛnyɑ́rũ ɑkɛ́ nɛ mɑ́nɛ. Api pɛɛ lɛ̃ kɑpi yɛ́ nɛ u n tĩ́ wɛ́ɛ́si, ɑmɑ́ risoiwuí ɑri iwɑmɛ pi wɑi. Api u tíyɛ ɑpi tɔ́su. ");
INSERT INTO soy_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Api Yeesu kɛ́mɛɛ Pifɑrisi pinyinɛ nɛ pɛpɛɛ Erooti kɛpirɛ ń we tumpɔ rɛ pikɛ́ ripinɛ u wɑ ɑpí nɛ uɑnɔɔlempi cirɛ u tini. ");
INSERT INTO soy_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Apí weri ɑpi Yeesu pisɛ rɛ: Sɑ́ɑ, tɔ yɛ̃ tɛ pɔ́ɔ ɑsei ute ɑ́ɑ kɔ úkɑ kɛwuu túúni. Likumúŋɛ́ rɛ ɑ́i pisoi mɛwee kɑɑ́ nɛ músu pɔn nɛ símisi. Pɔ yɛ kɔ Uléécɑɑ ncee pisoi céesilɛ nɛ ɑsei. Ncée yɛ we rɛ tɔkɛ́ yɛ Sesɑɑ lɑmpoo hɛ́ɛ́lɛɛ? Li pisɛ rɛ tɔkɛ́ yɛ hɛ́ɛ́lɛ nɛ́ɛ ɑ́ri kɑpɛ yɛ hɛ́ɛ́lɛ? ");
INSERT INTO soy_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Yeesu yɛɛ pikɛcɑ́ɑ́ kɛcɑ́ɑ́ mɛwɑi n nyu uu rinɔ́ɔ pi yɔ́su rɛ: Yo nnyɑ kɑni ripinɛ nɛ́ wɑi? Ani nɛ mɛwóópipi mɛnyinɛ nɛ́ kɑm kɛ́ mɛ yɛ̃. ");
INSERT INTO soy_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Apí nɛ mɛnyinɛ u hɑpɔ. Yeesu uu pɛɛ pi pisɛ rɛ: Úye riyu nɛ úye rinyiri yɛɛ kɛwóó nkɛ́ kɛcɑ́ɑ́ we? Api rinɔ́ɔ yɔ́su rɛ Sesɑɑ lo. ");
INSERT INTO soy_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Uu pɛɛ pi mɑɑ rɛ: Ani Sesɑɑ likɔ́ Sesɑɑ pɑ, ɑni Uléécɑɑ likɔ́ Uléécɑɑ pɑ. Urinɔɔ mɛyɔ́ɔ́ ɑmɛ mɛyɑ̃́ nnɔ́ɔ pi yipu. ");
INSERT INTO soy_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Pisɑtusee pɛɛ n tee rɛ pikpɔkpɔ ɑ́pi yɛ nkpɔ-i yisi, ɑpi Yeesu kɛ́mɛɛ sĩ́ ɑpi u pisɛ rɛ: ");
INSERT INTO soy_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Sɑ́ɑ, lɛ̃ kɛ Moisi uu isé ń wɔ́i yɛ nní: Úye umɑɑ un n kpu uu unɔ́si tíyɛ úu nɛ kɛwɑ̃́, uuwɑ̃ yɛɛ yɛ́ unɔ́si uyɛ̃ kukúmɑnnɔsi kpísi uu umɑ́ɑ mpuri wɑi. ");
INSERT INTO soy_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Pimɑ́rɛcɔ pisɛɛi pinyinɛ pɛɛ pɛɛ́ we. Ufoí uu unɔ́si kpísi uu kpi úu nɛ kɛwɑ̃́. ");
INSERT INTO soy_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ulírũ uu ukúmɑnnɔsi kpísi, uu kpi úu nɛ kɛwɑ̃́. Lɛ̃ mɛcɔ kɑi kɔ utɑ́ɑ́nũ titiki. ");
INSERT INTO soy_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Pikɛsɛɛi kɛ̃, úkɑ úu kɛwɑ̃́ nɛ u mɑri. Pɛ̃ mɛmɑ́ɑ́ unɔ́si uyɛ̃ pɔ́ɔ kɔ kpi. ");
INSERT INTO soy_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Pikpɔkpɔ kɛyisɛyɑɑ kɛtúŋɛ́, pikɛcɔpɛ úye yɛɛ yɛ́ unɔ́si n te, likumúŋɛ́ rɛ pikɛsɛɛi kɑpi kunɔ́si u kpíkɛsi. ");
INSERT INTO soy_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yeesu uu pi mɑɑ rɛ: Lɛ̃ nnyɑ kɑni nɔ́mɛnɛ́círɛ kírɑɑsɛntɛ: Áni Nléécɑɑsimɛ́ ɑsei kómɛi, ɑ́ni kɔ Uléécɑɑ nnɑŋɛ nyu. ");
INSERT INTO soy_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Mɛseisei kɛ̃ kɛ pisoi ɑpi pikpɔkpɔ kɛ́mɛɛ n yisinɛ, pitisi ɑ́pi pinɔ́si kpíkɛsinɛ, pinɔ́si pɔ̃́ ɑ́pi kɔ pilɑ sɔ́ɔnkɛɛnɛ, ɑmɑ́ pimɛfinɛ yɛ́ n we yɑrɛ piléécɑɑtumɛ kɛyómɛcɑɑ-pɔ. ");
INSERT INTO soy_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Yo nnyɑ kɑni tee rɛ pikpɔkpɔ ɑ́pi yɛ́ yisi? Áni kɛlõ kɛ-i kɑi Moisi ritɛlɛ́-i n wɔ́lɑɑlɛ̃ tɛ Uléécɑɑ yɛ kuhííhíí kpɛɛ ń torɛ kɛ́mɛɛ we un nɛ Moisi símisi kɛɛnlɛ̃ɛ? Li kei wɔ́lɑɑlɛ̃ tɛ, Uléécɑɑ yɛ Moisi mɑɑ rɛ: Nɛ́ɛ Apirɑhɑm Uleecɑɑ nɛ Isɑɑki Uleecɑɑ nɛ Yɑkupu Uleecɑɑ. ");
INSERT INTO soy_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Uléécɑɑ úu pikpɔkpɔ Uleecɑɑ, ɑmɑ́ u pinyɑ́nnyɑ̃́ Uleecɑɑ lɛ. Nɔ́nnɛ́púnnɛ yɛ piyɛlɛ. ");
INSERT INTO soy_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Uléécɑɑ isé ucélɑɑ unyinɛ yɛɛ pɛɛ Pisɑtusee nɛ Yeesu ikɛŋɛnɛ n kṍ, uu yɛ́nu rɛ Yeesu yɛ rinɔ́ɔ pi yɔsilɛ ńsɔnɛ, uú nɛ u kɔ, uu u pisɛ rɛ: Isé nnɛ́í kɛ́mɛɛ íye yɛɛ imɑ́ɑ? ");
INSERT INTO soy_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yeesu uu rinɔ́ɔ yɔ́su rɛ: Isé mɑɑ yɛ nnyí: Isirɑyɛɛli, ɑ kutu ricɔ, Upíimɑ, Urɔ́léécɑɑ, Upíimɑ yɛ ucírɛníŋɛ lɛ. ");
INSERT INTO soy_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","A Upíimɑ, Upɔ́léécɑɑ n lɑ nɛ kɛpɔ́fɑ nnɛ́í, nɛ ipɔ́soi nnɛ́í nɛ kɛpɔ́múŋɛ́ nnɛ́í nɛ mpɔ́nɑŋɛ nnɛ́í kɔ. ");
INSERT INTO soy_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ilírũ yɛ nnyí: A upɔ́cɔ n lɑ yɑrɛ kɑɑ ripɔ́cúruu ń lɑ mɛcɔ. Isé íkɑ íi we yɛɛ nnyí n fe. ");
INSERT INTO soy_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Isé ucélɑɑ uyɛ̃ uu u mɑɑ rɛ: Li nyɑmlɛ, sɑ́ɑ. Asei yɛ nyɛ kɑɑ́ mɑɑ rɛ Uléécɑɑ yɛ ucírɛníŋɛ lɛ úu kɔ ucɔ mɑ́. ");
INSERT INTO soy_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ḿpɑ́ úye ukɛ́ u n lɑ nɛ kɛfɑ nnɛ́í, nɛ mɛsɔhɔ nnɛ́í nɛ ńnɑŋɛ nnɛ́í kɔ. Ḿpɑ́ úye ukɛ́ kɔ uucɔ n lɑ yɑrɛ kuu uricuruu ń lɑ. Lɛ̃ nɛ isɛɛ kɑpi yɛ nɛ Uléécɑɑ n nyɔ́ɔnsɛ ɑpi tóroisɛ múkú-múkú nɛ inyɔ́ɔnsɛ icɔ nnɛ́í tɔsilɛ. ");
INSERT INTO soy_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Kɛ Yeesu uu n yɛ̃́ tɛ mɛsɔhɔ kuú nɛ rinɔ́ɔ yɔsí, uu u mɑɑ rɛ: Pɔ mɛpɔ́círɛ ńsɔnɛ cɑ́pinɛlɛ. Áɑ nɛ Uléécɑɑ kuyɔɔpiyu kɛtɑɑ we. Úkɑ úu pɛɛ ikɑri piwɑi rikpɑ́ ukɛ́ nnyinɛ u pisɛ. ");
INSERT INTO soy_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yeesu yɛ Uléécɑɑ kɛyɔ-i céésilɛ uu pi pisɛ rɛ: Íye kɛ isé picélɑɑ ɑpi yɛ́ fe ɑpí mɑɑ rɛ uyɛ̃ kɛ Uléécɑɑ uu n wɛ́ɛ yɛ Tɑfiti kɛpipi lɛ. ");
INSERT INTO soy_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Nfɑ́ɑsɔnɛ yɛ Tɑfiti ricuruu mɑɑsɛ rɛ: Upíimɑ yɛ Unɛ́píimɑ mɑɑ rɛ: A kunɛ́lukɛ-lukɛ-mɛ̃ kɛ́yukɔɔ́tonɛ-i tonɛ, hɑ́i nɛ kumúŋɛ́ kpɛ-i kɑm yɛ́ pipɔ́lɑ́ɑrɔ kɛpɔ́nyɑ́lɛ-i n cɔ. ");
INSERT INTO soy_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Tɑfiti ricuruu yɛɛ u sée rɛ \"Upíimɑ\". Íye kuu yɛ́ pɛɛ́ nɛ Tɑfiti kɛpipi? Pisoi kulúi yɛ pɛɛ kutu u cɔlɛnlɛ lin pi lɑ́ɑ́rú. ");
INSERT INTO soy_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Uicélɑɑ kɛ́mɛɛ kuu pi símisi rɛ: Ani nɛ isé picélɑɑ nɛ nɔ́mɛnɛ́círɛ tĩ. Pikɛ́ nɛ ɑtúkɑnkɑ cɑɑ-cɑɑ n kɔɔnii nɛ pisoi pikɛ́ pi n yɑ́hɑɑnkɛɛ ɑyɑ́ɑ kɛ́mɛɛ yɛɛ ripɔ́ɔ pi we. ");
INSERT INTO soy_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ayómɛyɑ́hɑɑlee sitonɛ foí nɛ kɛlukɛ kɛ́mɛɛ sitonɛ foí yɛɛ pilikɑ́ipi-kɑ́ipi. ");
INSERT INTO soy_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Pi yɛ lɛ̃ kɛ pikúmɑnnɔsi ɑpi m mɑ́ nnɛ́í yɔ́ɔilɛ ɑpi yɛ pɛɛ kɛyómɛ yɑ́ɑ́si mɛcɑ́ɑ yɑrɛ pi pisoi sɔnɛ lɛ. Uléécɑɑ yɛ́ nɛ pi túhɑɑnɛ uu íwɛ pi wɑi ɑ́i kumúŋɛ́ mɑ́. ");
INSERT INTO soy_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yeesu uu lɛ̃ mɛmɑ́ɑ́ Uléécɑɑ kɛyɔ-i, kei kɑpi yɛ ihɛɛ n sɑriipɔ kɛyúrí tonɛ. Uu lɛ̃ kɛ pisoi ɑpi siwóó n sɑriipɔ m pɑílɛ̃. Pimɑ́mɑ́ mɛyɑ̃ ɑpi mɛyɑ̃́ hɛkɛsi. ");
INSERT INTO soy_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ukúmɑnnɔsi unyinɛ pɔ́ɔ kɔ weri uu sitɑnkɑ́ sitɛ́ sɑ́pɔ. ");
INSERT INTO soy_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yeesu uu pɛɛ upipirɛtiki séi uu pi mɑɑ rɛ: Asei kɑm nɔ́ símisi, ukúmɑnnɔsi wɛkɔɔ́ nkó yɛ hɛlɛ ɑi ḿpɑ́ úye tɔ́su. ");
INSERT INTO soy_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Likumúŋɛ́ rɛ mpí nnɛ́í, lɛ̃ kɑ́pi nɛ líkɑ n wɑi kɑpi hɛ, ɑmɑ́ uyɛ̃ pɔ̃́, ulikɔ́ kɛcirɛ, lɛ̃ kuu m mɑ́ nnɛ́í ukɛ́ nɛ ilukɛ n lɔ kuu hɛ. ");
INSERT INTO soy_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Kɛ Yeesu uu Uléécɑɑ kɛyɔ-i n léeri, upirɛtiki usɛ uu u mɑɑ rɛ: Sɑ́ɑ, ɑ ripɑí, kɛ́yɔ kɛcirɛ nɛ ɑpɑrɛ sɔnɛ-sɔnɛ, nɛ́ɛ yo? ");
INSERT INTO soy_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yeesu uu rinɔ́ɔ u yɔ́su rɛ: Pɔ kɛ́yɔ píimɑ nkɛ́ nyɑ́nii? Li sɔ́nti likɛ́ wɑ ripɑrɛ ríkɑ ɑ́ri yɛ́ ricɔ kɛcɑ́ɑ́ n tɔsilɛ̃. Linnɛ́í mmú yɛ sɔ́ntilɛ likɛ́ fori tɛ́kɛ́-tɛ́kɛ́. ");
INSERT INTO soy_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Uu Olifiyee rikúú kɛcɑ́ɑ́ tonɛ Uléécɑɑ kɛyɔ kɛyu-mɛ̃. Piyɛɛ nɛ Yɑkupu nɛ Yohɑni nɛ Antiree mɛcirɛ nɛ uyɛ̃ pin we, ɑpi u pisɛ rɛ: ");
INSERT INTO soy_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","A rɔ́ símisi kumúŋɛ́ kpɛ-i kɛ lɛ̃ ɑi ń werinɛ. Yo yɛɛ rɔ́ nyísɛnɛ rɛ lɛ̃ nnɛ́í yɛ́ tɛnɛ? ");
INSERT INTO soy_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yeesu uu pɛɛ pi mɑɑ rɛ: Ani nɔ́mɛnɛ́círɛ tĩ ńsɔnɛ, ɑ́ni kɑpɛ tíyɛ unyinɛ ukɛ́ kuyúi nɔ́ tɑ̃. ");
INSERT INTO soy_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Pisoi mɛyɑ̃́ yɛ́ sɔ́nɑɑmɛ usɛ usɛ nɛ rinɛ́nyíri, ḿpɑ́ úye uu yɛ mɑɑ rɛ nɛ̃́ kɛ Uléécɑɑ uu wɛ́ɛ. Lɛ̃ kɛ́mɛɛ kɑpi yɛ́ pisoi kulúi kuyúi tɑ̃. ");
INSERT INTO soy_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Nɔn píyei n kõ tɛ ɑtɔpi yɛ nnyɑ́ɑ̃ nɛ kɛtɑɑ-pɔ wemɛ, ɑ́ni kɑpɛ nfɑsimɛ́ tónɛ, likumúŋɛ́ rɛ lɛlɛɛ sɔ́nti. Amɑ́ kɛ́tɔ ɑ́kɛ kɑhɑnɛ n tu. ");
INSERT INTO soy_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nsoipuri nnyinɛ yɛ́ yisi nn nsoipuri ncɔ nɛ tɔpu, kɛyɔ́ɔpitẽ ɑkɛ kɛyɔ́ɔpitẽ kɛcɔ nɛ tɔpu, kɛtẽ yɛ́ɛ́ silõ silõ yeŋesi, nkṹ yɛ́ kɔ wɑ. Limpɔlɛ yɛ́ n we yɑrɛ kɛ mɛmɑ́rɛnlõ ɑmɛ yɛ unɔ́si pikɛ́hɛ̃ n kórɑɑnɛ. ");
INSERT INTO soy_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ani nɔ́mɛnɛ́círɛ tĩ. Pi yɛ́ nɛ sitúhɑɑnɛ nɔ́ hɑ, ɑpí nɛ sipɔ́pí nɔ́ kɑ́ii ɑyómɛyɑ́hɑɑlee-i. Pi yɛ́ nɛ̃́ nnyɑ kuyu piwɛ́ɛ́sɛ kɛ́mɛɛ nɛ pitúhɑɑnɛ kɛ́mɛɛ nɔ́ sɔ́nɛ. Nɔ́ kɔ pikɛyu-i inɛ́tɑnsei li. ");
INSERT INTO soy_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Li pisɛ rɛ pikɛ́ Nsímɛ́ Kɛcirɛ isoipuri nnɛ́í riyóó kɛlenɛ. ");
INSERT INTO soy_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Pin nɔ́ n tĩ ɑpí nɛ kɛtúhɑɑnɛ nɔ́ sĩ́, ɑ́ni kɑpɛ pírí tónɛ kɛlenɛ nɛ mmɛ̃ kɑni yɛ́ m mɑɑ, ɑmɑ́ ɑni mmɛ mɛɛ kumúŋɛ́ kpɛ-i nɔ́ n kɑ mɑɑ, likumúŋɛ́ rɛ ɑ́i nɔ́ɔ símisi, ɑmɑ́ Nfɑ́ɑsɔnɛ yɛ mu. ");
INSERT INTO soy_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Usoi yɛ́ umɑ́ɑ nɛ́ɛ uwɑ̃́ tĩ uu tíyɛsɛ ɑpi u kopu. Pisɑ́ɑ yɛ́ kɔ limɛcɔ pisipipi wɑ. Siwɑ̃́ yɛ́ pisɑ́ɑ nɛ píni kɛcɑ́ɑ́ nyɛrɛ ɑsi tíyɛsɛ ɑpi pi kóni. ");
INSERT INTO soy_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Tinɛ́nyíri nnyɑ, ḿpɑ́ úye yɛ nɔ́inɛ́puri yulunɛ, ɑmɑ́ úye un tinkɑ́hɑ́-kɑ́hɑ́ hɑ́i nɛ kɛ́tɔ-pɔ, Uléécɑɑ yɛ́ u yoriyɛ. ");
INSERT INTO soy_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Kumúŋɛ́ kunyinɛ yɛ́ kɑm ɑni ncɑɑi píimɑ mɛɛ yɛ n cɔ́kɔi yɛnu, kei kɑ́i nɛ n sɑ́ rɛ nkɛ́ n we. Úye un nsímɛ́ mmɛ̃ n kɛɛ̃, ukɛ́ musí ukɛ́ liɑsei kõ. Lin lɛ̃ n wɑ, pɛpɛɛ Yutee kɛtẽ kɛ́mɛɛ ń we pikɛ́ wuri ɑpi ɑyɔ́pɛ tɑɑ́. ");
INSERT INTO soy_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Úye un kɛ́yɔ ipirɑɑ kɛcɑ́ɑ́ n we, úu kɑpɛ kɛ́yɔ-i ricɛpimɛ rɛ ukɛ́ linyinɛ kpísi. ");
INSERT INTO soy_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Úye un kɔ kɛcɑrɛ-i n we, úu kɑpɛ kɛpirɛ pɛlɛ rɛ ukɛ́ hɑ ukɛtukɑnkɑ kpísi. ");
INSERT INTO soy_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Íwɛ kɛ pifɑni nɛ pimɑ́rɛni ɑpí hɑ siyɑ́ɑ sɛ-i topori. ");
INSERT INTO soy_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ani kɛyómɛ yɑ́ɑ́si, ɑ́i kɑpɛ nnyiyɛ kumúŋɛ́ kɑ. ");
INSERT INTO soy_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Likumúŋɛ́ rɛ siyɑ́ɑ sɛɛ íwɛ píimɑ sikɔ́ lɛ. Kɛ Uléécɑɑ uú nɛ kɛtẽ n wɑ, ɑ́pi íwɛ iyɛ̃ icɔ yɛnɑɑlɛ̃, iicɔ íi kɔ píkɑi léeri. ");
INSERT INTO soy_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Uléécɑɑ unsɑ́ pɛɛ siyɑ́ɑ sɛ̃ n hɑsi, úkɑ úu yɛ́ pɛɛ nfɑ́ɑ yɛ̃. Pɛ̃ kuu n tɛ́si uú n te nnyɑ kuu si hɑsi. ");
INSERT INTO soy_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Úye un pɛɛ nɔ́ m mɑɑ rɛ: Ukirisi kɛ Uléécɑɑ uu n wɛ́ɛ yɛ nté nɛ́ɛ nté-pɔ welɛ, ɑ́ni kɑpɛ wɑisɛ. ");
INSERT INTO soy_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Likumúŋɛ́ rɛ pikirisi nɔɔmɛ nɛ ɑntepuyɛ nɔɔmɛ yɛ leerinɛ. Pi yɛ́ɛ́ mɛwɑisɑŋɑ nɛ mɛwɑi píimɑ wɑpisi pikɛ́ nɛ ḿpɑ́ pɛ̃ kɛ Uléécɑɑ uú n te pɔisɛ. ");
INSERT INTO soy_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Áni kɑpɛ lɔpilɛ, ḿpɑ́ yo kɑm nní mɛncirɛ nɔ́ símisi. ");
INSERT INTO soy_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Amɑ́ siyɑ́ɑ sɛ̃ kɛ́mɛɛ, íwɛ píimɑ iyɛ̃ mɛmɑ́ɑ́ kɛ ituŋɛ ií sɔmɑɑnɛ, iwɑ́rɛ ii mɛtɛ́í pɑɑ. ");
INSERT INTO soy_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Awɑ́rɛpi ɑɑ kɛyómɛcɑɑ-pɔ poroiri, linɑ́ŋɛ-nɑŋɛ lɛɛ kɛyómɛcɑɑ-pɔ ń we ɑi mɛyɑ̃́ yeŋesi. ");
INSERT INTO soy_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Pi yɛ́ pɛɛ Usoi Kɛpipi yɛ̃ kɛn ɑhopɛ kɛcɑ́ɑ́ wemɛ nɛ kɛnnɑŋɛ nɛ kɛmɛyɔɔpi. ");
INSERT INTO soy_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","U yɛ́ pɛɛ upitumɛ pɛɛ kɛtẽ nɛ kɛyómɛ-pɔ ń we ɑwɛ́lɛ́ nnɛ́í túmɛi ɑpi pɛ̃ kuu n wɛ́ɛkɛɛ kɛtẽ nkɛ́ nɛ kɛkɛtɔ-pɔ cɑ́pinɛ. ");
INSERT INTO soy_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ani kúfikiyee kɛnyɑ́rũ icélɑɑ kutu ricɔ. Ku yɛ kun ilésɛ ŋmṹ n wɑiri, mɛpɛ́i mɛn n leeri, nɔ yɛ mɛsɛ nɛ mɛsɛ ceri rɛ kupii yɛ nyɑhɑimɛlɛ. ");
INSERT INTO soy_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Limɛcɔ kɑí we, nɔn píyei likɛi nní mɛwɑi n yɛ̃, ɑni ceri rɛ Usoi Kɛpipi yɛ nyɑhɑimɛlɛ un tinɔnɔɔ nɛ kɔlɛ̃. ");
INSERT INTO soy_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Asei kɑm nɔ́ símisi: Pisoi kunɑi nkú ɑ́ku tɔ́sunɛ kɛlenɛ nní nnɛ́í likɛ́ nɛ ń kɑm. ");
INSERT INTO soy_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kɛtẽ nɛ kɛyómɛ yɛ́ tɔsí, ɑmɑ́ ɑnɛ́nɔ́ɔ ɑ́ɑ mɛtɔ́ŋɛ́ mɑ́. ");
INSERT INTO soy_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Amɑ́ in kɛtẽ mɛtɛnɛ nkɔ́, úkɑ úu likɛyɑɑ kɛ̃ nɛ́ɛ liituŋɛ iyɛ̃ nyu, ḿpɑ́ piléécɑɑtumɛ pɛɛ kɛyómɛcɑɑ-pɔ ń we nɛ́ɛ Uléécɑɑ Kɛpipi ricuruu. Amɑ́ Usɑ́ɑ mɛcirɛ yɛɛ nyu. ");
INSERT INTO soy_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ani nɔ́mɛnɛ́círɛ tĩ, ɑ́ni kɑpɛ ripɔ́ɔ fóm, (ɑni yɛ kɛyómɛ yɑ́ɑ́si), likumúŋɛ́ rɛ ɑ́ni nyu píyei kɛ liituŋɛ ii yɛ́ kɑm. ");
INSERT INTO soy_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Li yɛ́ n we yɑrɛ usoi yɛɛ ncée ń hɑ uu ukɛyɔ tíyɛ, uu upikɛikɔ́ ńnɑŋɛ hɛ, uu ḿpɑ́ úye pikɛi u múísɛ, uu rinɔnɔɔ umɛ́rɛ́ rinɔ́ɔ hɛ rɛ úu kɑpɛ ripɔ́ɔ fóm. ");
INSERT INTO soy_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Lɛ̃ nnyɑ, ɑ́ni kɑpɛ ripɔ́ɔ fóm, likumúŋɛ́ rɛ ɑ́ni nyu píyei kɛ úyɔsɑɑ uu pɛɛri, nnyɔ́ɔ́ nɛ́ɛ kɛsinɛ pele nɛ́ɛ mɛcɑ́nkooi nɛ́ɛ mmɑrɛ. ");
INSERT INTO soy_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ái kɑpɛ wɑ rɛ u mɛkɑ́ikɑi kɑ uu nɔ́ lɛɛri nnɔ̃ kɛ́mɛɛ. ");
INSERT INTO soy_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Lɛ̃ kɑm nní nɔ́ n símisi, ḿpɑ́ úye kɑḿ nɛ mɑ́nɛ, ɑ́ni kɑpɛ ripɔ́ɔ fóm. ");
INSERT INTO soy_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Li riyɑ́lɛ siyɑ́ɑ sitɛ́ Isirɑyɛɛli pikɔ́ pikɛ́ nɛ nkpɔ mɛlɔ́ɔ́ nɛ ɑkpɔ́nɔ́ nyɛɛ ɑ́ɑ pitɛ m mɑ́ ɑnyɑ̃́ li. Pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ nɛ isé picélɑɑ ɑpi ncée n wɛ́ɛ́si kɑpi yɛ́ nɛ Yeesu n tĩ́ nɛ mɛsɔhɔ pikɛ́ u kpu. ");
INSERT INTO soy_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Api símɑɑnɛ rɛ: Ái kɑpɛ ɑnyɑ̃́ kumúŋɛ́-i rɛ pisoi yɛ́ yisi ɑpi pitele wɑi nnyɑ. ");
INSERT INTO soy_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Kɛ Yeesu uu Petɑnii kuyu-i uyɔ̃́ Simɔɔ kɛyɔ kɛ́mɛɛ ń we un ilukɛ le, unɔ́si unyinɛ uu lompɔ. Unɔ́si uyɛ̃ un kɛnúḿpi sɔnɛ kɛɛ tulɑɑli pɑpɛ-pɑpɛ yɛɛ nnɛ́í píimɑ m mɑ́ múílɛ̃. Uu kɛnúḿpi kɛ̃ foru uu tulɑɑli Yeesu riyu kɛcɑ́ɑ́ kɔɔni. ");
INSERT INTO soy_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Mɛwɑi mɛ̃ ɑ́mɛ nɛ picɔ risɑ́, ɑpi pɛɛ pimɛcɔpɛcirɛ m mɑ́ikɛɛ rɛ: Linsɔnɛ yɛ ń-ye kuu nní tulɑɑli nkó n cɑɑi? ");
INSERT INTO soy_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Tɔ́ pɛɛ fe ɑri u yɑ́i nɛ nnɛ́í píimɑ ɑri siwóó sɛ̃ píwɛkɔɔ́ hɛ. Apí nɛ unɔ́si uyɛ̃ wɔ́ɔ́si. ");
INSERT INTO soy_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Amɑ́ Yeesu uu pi mɑɑ rɛ: Ani u riyɑ́. Yo nnyɑ kɑni u cɔ́ŋlɛ̃? Mɛwɑi sɔnɛ kuu nɛ́ wɑ. ");
INSERT INTO soy_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Likumúŋɛ́ rɛ ḿpɑ́ píyei kɛ nɔ́ nɛ píwɛkɔɔ́ ɑní we, nɔ́ fe ɑni lisɔnɛ pi wɑi pɛɛ́ uyɛ-i kɑni ń lɑ, ɑmɑ́ nɛ̃́, ɑ́i ḿpɑ́ píyei kɑm yɛ́ nɛ nɔ́ n we. ");
INSERT INTO soy_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Lɛ̃ kɛ unɔ́si nkó uu n fenɛ kuu wɑ. Inɛ́piŋɛ kuu mɛncirɛ tulɑɑli fṍ pikɛ́ kɛlenɛ nhórɛ i tɑ̃. ");
INSERT INTO soy_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Asei kɛcɑ́ɑ́, kɛ́ nɔ́ símisi rɛ ḿpɑ́ yei kɑpi kɛtẽ nnɛ́í kɛcɑ́ɑ́ Nsímɛ́ Kɛcirɛ yóólɛ̃, pi yɛ́ɛ́ unɔ́si nkó mɛwɑi mmɛ́ símisi ɑpí nɛ u n léisɛlɛ̃. ");
INSERT INTO soy_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yeesu pipirɛtiki kɛfi nɛ pitɛ́ kɛcɔpɛ usɛ kɑpi yɛ n sée rɛ Yutɑsi Isikɑriyɔɔti uú hɑ pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ lɛɛpɔ rɛ ukɛ́ Yeesu tĩ ukɛ́ pi rimúísɛ. ");
INSERT INTO soy_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Nkíŋniŋɛ kɑpí nɛ kutu u ricɔ ɑpi rinɔ́ɔ yekei rɛ pi yɛ́ siwóó u hɛ. Yutɑsi uu icée sɔnɛ wɛ́ɛ́si ukɛ́ nɛ Yeesu piɑnipɛ-i n wɑ. ");
INSERT INTO soy_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Kɛnyɑ̃́yɑɑ foí kɛ̃ kɑpi yɛ ɑkpɔ́nɔ́ nyɛɛ ɑ́ɑ pitɛ m mɑ́ n li, kɛyɑ́ɑ kɛ̃ kɑpi yɛ kɔ nkpɔ mɛlɔ́ɔ́ ɑnyɑ̃́ isɑŋ n kṍ, Yeesu pipirɛtiki ɑpi u pisɛ rɛ: Yei kɑɑ́ lɑ tɔkɛ́ hɑ ɑnyɑ̃́ ilukɛ pɔ́ wɑ? ");
INSERT INTO soy_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Uu upipirɛtiki pitɛ́ tum uu pi mɑɑ rɛ: Ani kuyu-i hɑ, utisi unyinɛ yɛɛ kɛcɔ́rípi nɛ míni n topori yɛ́ nɛ nɔ́ risɑ́nɛ, ɑni u ritiki. ");
INSERT INTO soy_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Un yei n lõ ɑni úyɔte mɑɑ rɛ: Urɔ́sɑ́ɑ yɛ pisɛ rɛ yei yɛ kulee kpɛ-i kɛ u nɛ upipirɛtiki ɑpi nkpɔ mɛlɔ́ɔ́ ɑnyɑ̃́ ilukɛ n lenɛ? ");
INSERT INTO soy_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","U yɛ́ kɛ́yɔ kɛcɑ́ɑ́ kulee mɑɑ kunyinɛ kɑpi ńsɔnɛ n nyɔ́ɔnsɛ nɔ́ nyísɛ. Ilũ kɑpi yɛ nɛ ɑnyɑ̃́ n li nnɛ́í yɛ kukɛmɛɛ́ welɛ. Kei kɑni yɛ́ ɑnyɑ̃́ ilukɛ wɑ. ");
INSERT INTO soy_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Yeesu pipirɛtiki ɑpi tɔ́su ɑpi kuyu tulu, ɑpi ḿpɑ́ yo lɛɛpɔ yɑrɛ kɛ Yeesu uú pɛɛ pi ḿ mɑ, ɑpi nkpɔ mɛlɔ́ɔ́ ɑnyɑ̃́ ilukɛ wɑi. ");
INSERT INTO soy_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kɑi nnyɔ́ɔ́ n wɑ, Yeesu nɛ upipirɛtiki kɛfi nɛ pitɛ́ ɑpí weri. ");
INSERT INTO soy_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Kumúŋɛ́ kpɛ-i kɑpi ilukɛ n le, Yeesu uú mɑɑ rɛ: Asei kɑm nɔ́ símisi, nɔ́kɛnɛ́cɔpɛ unyinɛ yɛɛ nɛ ilukɛ nɛ́ n le yɛ́ nɛ́ yɑ́ɑ́. ");
INSERT INTO soy_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Piɑpɔɔ ɑɑ cɑɑi ɑpi pɛɛ usɛ usɛ u m písɛi rɛ: Yɑrɛ nɛ̃́ nɛ́ɛ? ");
INSERT INTO soy_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Uu rinɔ́ɔ pi yɔ́su rɛ: Nɔ́ kɛfi nɛ pitɛ́ pɛ̃ usɛ lo, tɔ́ nɛ uyɛ̃ tɔɔ ricɑ́ripi risɛ-i n le. ");
INSERT INTO soy_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Usoi Kɛpipi yɛ tɔ́sulɛ yɑrɛ lɛ̃ kɑi kɛkɛcɑ́ɑ́ n wɔ́lɑɑmɛlɛ̃. Amɑ́ usoi nkó yɛɛ yɛ́ Usoi Kɛpipi n yɑ́ɑ́, íwɛ kɛ liute uu topori. Li kutɔsi we ɑ́pi kɑpɛ pɛɛ liute m mɑri. ");
INSERT INTO soy_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Kɑpi n le, Yeesu uu kukpɔ́nɔ́ kpísi, uu kukɛcɑ́ɑ́ Uléécɑɑ pɔɔnɛsɛ uu limɛmɑ́ɑ́ ku kpɔkɔ́ri uu pi ku pɑ uu rɛ: Ani yɔsí, inɛ́piŋɛ yɛ nnyí. ");
INSERT INTO soy_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Uu lɛ̃ mɛmɑ́ɑ́ kɛpóripi kpísi uu kɛkɛcɑ́ɑ́ Uléécɑɑ pɔɔnɛsɛ. Uu pi kɛ pɑ ɑpi pinnɛ́í níru. ");
INSERT INTO soy_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Uu pi mɑɑ rɛ: Mɛnɛ́nyɛ yɛ mmɛ́, mɛ́nyɛ mɛmɛɛ pisoi mɛyɑ̃ nnyɑ kɔɔnu, Uléécɑɑ uú nɛ pi séi rɛ u nɛ pɛ̃ pikɛ́ kómɛinɛ. ");
INSERT INTO soy_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Asei kɑm nɔ́ símisi, ɑ́m píkɑi ɑléépipi pitɑ mpí pinírɛ́ kpɑ́nɛ hɑ́i nɛ kɛyɑ́ɑ kɛ̃ kɑm yɛ́ pifɑ́lɛ ń ntí Uléécɑɑ iyɔɔpi kɛ́mɛɛ. ");
INSERT INTO soy_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Kuu lɛ̃ pisímɛ́ pi ḿ mɑsí, ɑpi pɛɛ ipɑkɑrɛ siyomɛ n yom pin pɑkɑrɛntɛ ɑpi wɑi ɑpi Olifiyee rikúú sĩ́. ");
INSERT INTO soy_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yeesu uu pi mɑɑ rɛ: Nɔ́ nɔ́nnɛ́nɛ́í kɛpirɛ nɛ́ ritɔ, likumúŋɛ́ rɛ li Nléécɑɑsimɛ́ ritɛlɛ́-i wɔ́lɑɑlɛ̃ tɛ: Nɛ́ usɛɛsẽ́ kpu, isɑ́ŋ pɔ́ɔ kpíi. ");
INSERT INTO soy_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Amɑ́ nɛn píyei nkpɔ kɛ́mɛɛ piyisɛ m mɑsí, nɛ́ hɑ Kɑlilee kɛtẽ-pɔ nɔ́ m mɛ̃́. ");
INSERT INTO soy_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Piyɛɛ uu u mɑɑ rɛ: Ḿpɑ́ pinnɛ́í pin kɛpirɛ pɔ́ rintɔ, ɑ́i nɛ nɛ̃́. ");
INSERT INTO soy_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yeesu uu u mɑɑ rɛ: Asei kɑm pɔ́ símisi, nɛni kɛsinɛ nkɛ́ cirɛ icɑ̃́ ikɛ́ kɛlenɛ mɛtɛ́ n kooi, pɔ́ kɛ́si nnɔ́ɔ mɛtɑɑni rɛ ɑ́ɑ nɛ́ nyu. ");
INSERT INTO soy_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Amɑ́ Piyɛɛ uú n kɛŋɑɑlɛ̃ tɛ: Ḿpɑ́ lin nkpɔ yɛ mu, tɔ́ nɛ mpɔ̃́ tɔkɛ́ kɛsẽ́ kpu, ɑ́m kuŋmɛriyɛ pɔ́ we. Pinnɛ́í ɑpi kɔ nsɛ mmɛ̃ m mɑ́ikɛɛ. ");
INSERT INTO soy_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yeesu nɛ upipirɛtiki ɑpi lɛ̃ mɛmɑ́ɑ́ kɛlõ kɛnyinɛ kɑpi yɛ n sée rɛ Kɛtisemɑnee sĩ. Uu upipirɛtiki mɑɑ rɛ: Ani nté n tũ, nɛ́ɛkɛ́ hɑ kɛyómɛ n yɑ́hɑɑpɔ. ");
INSERT INTO soy_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Uú nɛ Piyɛɛ nɛ Yɑkupu nɛ Yohɑni pɛ́nɛ. Kei kɛ iwɑmɛ nɛ mpɔ́ɔcɑɑi yíkíyiki nn u tĩ. ");
INSERT INTO soy_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Uu pi mɑɑ rɛ: Tinɛ́pɔ́ɔ yɛ cɑɑilɛnlɛ hɑ́i lin nɛ nkpɔ mɛnyínɛ we. Ani nté tonɛ ɑ́ni kɑpɛ lɔpilɛ. ");
INSERT INTO soy_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Uu lɛ̃ mɛmɑ́ɑ́ kɛyu-mɛ̃ nyɔsɔ́pɔ nkɑ́ripi, uu wúlɑ uu Uléécɑɑ yɑ́ɑ́si rɛ lin íye n we, ɑ tíyɛsɛ ḿpɔlɛ ituŋɛ iyɛ̃ íi kɑpɛ kɑ. ");
INSERT INTO soy_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Uu kɛyómɛ yɑ́ɑ́si rɛ: Unɛ́sɑ́ɑ, pɔ́ fe ɑɑ ḿpɑ́ yo wɑi, ɑ nɛ ntóósi kɛporipi nkɛ́ kɛtɑɑ nɛ́ wɑ. Ḿpɑ́ nɛ lɛ̃, kɑpɛ mɛnɛ́pɔ́ɔlɑ wɑ, ɑmɑ́ ɑ mɛpɔ́kɔ́ wɑ. ");
INSERT INTO soy_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Uu lɛ̃ mɛmɑ́ɑ́ upipirɛtiki-mɛ̃ pɛlɛ, uu pi lɛɛpɔ pin lɔni. Uu Piyɛɛ mɑɑ rɛ: Simɔɔ, pɔ lɔnilɛɛ? Áɑ nkpɑ́ni fe pɔkɛ́ n nyɑ́ni kɛnɑmpi kɛsɛɛ? ");
INSERT INTO soy_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ani n tũ nɔn nyɑ́ni nɔn kɛyómɛ yɑ́ɑ́si, ɑ́ni kɑpɛ nɛ pipeikɛɛ kɛ́mɛɛ ń loó nnyɑ. Li kɛsoipipi ripɔ́ɔ we rɛ kɛkɛ́ yɛ lisɔnɛ wɑ, ɑmɑ́ kɛ pɛɛ rinɑ́rɛi mɑ́lɛ. ");
INSERT INTO soy_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Uú nɛ kɛtɑɑ piwɑi pi kpɑ́, uú hɑ kɛyómɛ yɑ́ɑ́si, uu umɛwelɛ foí mɛ̃ mɛcɔ welu. ");
INSERT INTO soy_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Uu pɛɛri uu kɔ pi lɛɛri pin lɔni, likumúŋɛ́ rɛ piinipɛɛ yɛ mulɛsilɛ. Ápi ceri mmɛ̃ kɑpi yɛ́ rinɔ́ɔ u n yɔsí. ");
INSERT INTO soy_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Uu mɛtɑ́ɑ́nũ pɛɛri uu pi mɑɑ rɛ: Nɛ́ntɛ nɔ nkpéni lɔnilɛ nɔn wéntɛlɛ̃? Li lɛ̃ tulɛ, ituŋɛ yɛ tulɛ, lɛɛ nní, pi Usoi Kɛpipi pikópɛkɔɔ́ ɑnipɛ-i wɑlɛ. ");
INSERT INTO soy_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ani yisi tɔkɛ́ tɔsí, uyɛɛ nɛ́ n yɑ́inɛ yɛ nyɑhɑimɛlɛ. ");
INSERT INTO soy_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yeesu úu kɑhɑnɛ nsímɛ́ n tɛnɛ kɛ upipirɛtiki kɛfi nɛ pitɛ́ pɛ̃ usɛ kɑpi yɛ n sée rɛ Yutɑsi nɛ risoiwuí ɑpi mɛsɛ nɛ mɛsɛ rikpɑ́fúmɛ, pin ɑtɛ́hɛ nɛ ɑpúnípi mulɛilɛ̃. Pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ nɛ isé picélɑɑ nɛ Pisuifi piwɛ́ɛ́sɛ yɛɛ pi tumpɔ. ");
INSERT INTO soy_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yutɑsi yɛɛ pɛɛ piɑnipɛ-i Yeesu n wɑinɛ, yɛ pɛɛ risoiwuí mɛsɔhɔ mɛ̃ kuú nɛ u ń tininɛ céesilɛ. U pɛɛ pi céesi rɛ: Nɛn hɑ úye rimpirɑ ɑm u yɑ́ɑ́si, uyɛɛ lo, ɑni u tĩ, ɑni u múlú ńsɔnɛ ɑní nɛ tɔ́su. ");
INSERT INTO soy_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Kuu n tuipɔ uú nɛ mɛsɛ nɛ mɛsɛ Yeesu kɔ, uu rɛ: Sɑ́ɑ! Uu pɛɛ u pirɑ uu u yɑ́ɑ́si. ");
INSERT INTO soy_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Pisoi pɛ̃ ɑpi Yeesu kɛcɑ́ɑ́ kunípɛ wɑi ɑpi u tini. ");
INSERT INTO soy_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Kei kɛ Yeesu upirɛtiki usɛ uu risɑɑpɔ uu uritɛ́hɛ kpeéu, uu Uléécɑɑ usinɑ ukɛikɔ́ kutu seḿ. ");
INSERT INTO soy_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yeesu uu rinɔ́ɔ yɔ́su uu pi mɑɑ rɛ: Yo nnyɑ kɑni pitínɛ nɛ́ kɑ nɛ ɑtɛ́hɛ nɛ ɑpúnípi yɑrɛ usoi kpɑ́ɑ́ree? ");
INSERT INTO soy_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ḿpɑ́ kɛyɑ́ɑ kɛ́ye kɑm yɛ nɔ́kɛnɛ́cɔpɛ n we, nɛn Uléécɑɑ kɛyɔ-i céési, ɑ́ni nɛ́ tĩ́. Amɑ́ lɛ̃ kɑi Nléécɑɑsimɛ́ ritɛlɛ́-i n wɔ́lɑɑmɛlɛ̃ likɛ́ nɛ n wɑ nnyɑ kɑi lɛ̃ wɑi. ");
INSERT INTO soy_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Yeesu pipirɛtiki nnɛ́í ɑpi u ŋmɛriyɛ ɑpi wuru. ");
INSERT INTO soy_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Uŋmɑ́nɛ unyinɛ yɛ̀ɛ̀ pɛɛ Yeesu n tikilɛnlɛ un kusɑ́ŋɑ́ɑ́ ŋmɑnɛ yɑriilɛ̃. Api rɛ pikɛ́ u tĩ, ");
INSERT INTO soy_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","uu kusɑ́ŋɑ́ɑ́ tɔpíri uu mɛŋmɑnɛ wuru. ");
INSERT INTO soy_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Apí nɛ Yeesu Uléécɑɑ usinɑ kɛ́mɛɛ sĩ́. Kei kɛ pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ nɛ Pisuifi piwɛ́ɛ́sɛ nɛ isé picélɑɑ ɑpi pinnɛ́í cɑ́pinɛlɛ̃. ");
INSERT INTO soy_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Piyɛɛ uu kɛtɑɑ-pɔ Yeesu n tikilɛ̃ hɑ́i nɛ Uléécɑɑ usinɑ kɛyɔcɔpɛ-pɔ. U nɛ pimɛ́rɛ́ ɑpi kei kɛsẽ́ n tũ un nnɑ wéni. ");
INSERT INTO soy_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ nɛ pitúhɑɑnɛ píimɑ nnɛ́í ɑpi pisoi wɛ́ɛ́si pɛɛ yɛ́ Yeesu nɛ nsímɛ́ rinkpɑ́rɑ́. Pitúhɑɑnɛ pɛ̃ ɑ́pi nkópɛ ńkɑ yɛ̃ kɑpi yɛ́ nɛ u n kpu. ");
INSERT INTO soy_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Likumúŋɛ́ rɛ mɛyɑ̃́ mɛɛ nɛ nsímɛ́ u kpɑrɑi, ɑmɑ́ mmɛ̃ kɑpi n símisi ńn ncée nsɛ ritiki. ");
INSERT INTO soy_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Picɔ ɑpi yɛ yisi ɑpí nɛ u wɑ́ɑ́nɑ́ rɛ: ");
INSERT INTO soy_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Tɔ kõ un tee rɛ: Nɛ̃́ nɛ́ Uléécɑɑ kɛyɔ nkɛ́ kɛ usoi kunipɛ ɑku n wɑ fori, ɑm siyɑ́ɑ sitɑɑni kɛcɔpɛ kɛféé mɔm kɛ usoi kunipɛ ɑ́ku yɛ́ n wɑ. ");
INSERT INTO soy_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ḿpɑ́ nɛ kei ricuruu, pinsímɛ́ ńn ncée nsɛ ritiki. ");
INSERT INTO soy_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Uléécɑɑ usinɑ uu icɑ́pinɛ iyɛ̃ kɛcɔpɛ yisi uu Yeesu pisɛ rɛ: Áɑ rinɔ́ɔ ríkɑ yɔ́sunɛɛ? Mpɔ́kópɛ ń-ye kɛ pisoi mpí ɑpi nní símisi? ");
INSERT INTO soy_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yeesu uu sɛ́ɛ́, úu rinɔ́ɔ ríkɑ yɔsí. Uléécɑɑ usinɑ uu pipisɛ u kpɑ́ rɛ: Pɔ́ɔ uyɛ̃ kɛ Uléécɑɑ uu n wɛ́ɛ? Uléécɑɑ yɛɛ ipɑkɑrɛ n te Kɛpipii? ");
INSERT INTO soy_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yeesu uu rinɔ́ɔ yɔ́su rɛ: Nɛ́ɛ lo. Nɔ́ Usoi Kɛpipi yɛ̃ kɛn Uléécɑɑ, ńnɑŋɛ nnɛ́í ute kulukɛ-lukɛ-mɛ̃ kɛ́yukɔɔ́tonɛ-i tṹ. Nɔ́ kɔ kɛyómɛcɑɑ-pɔ ɑhopɛ kɛ́mɛɛ u yɛ̃ un nɛ wemɛ. ");
INSERT INTO soy_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Kei kɛ Uléécɑɑ usinɑ uu pɛɛ uricuruu ilũ kuu n tɑnɑɑlɛ̃ cɛ́ɛ́rii ɑi nyísɛ rɛ li u tóósilɛ hɑ́i uu rɛ: Píseérɑkɔɔ́ píye picɔ kɑri nkpéni wɛ́ɛ́si? ");
INSERT INTO soy_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nɔ konlɛ kuu Uléécɑɑ kɛcɑ́ɑ́ ɑnɔ́ɔ kópɛ n símisi. Íye kɑni músu? Pinnɛ́í ɑpí mɑɑ rɛ li nɛ sɑ́ rɛ pikɛ́ u kpu. ");
INSERT INTO soy_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Picɔ ɑpi ukɛcɑ́ɑ́ mɛtɑ pitúkɛntɛ loni, ɑpi ukɛyu pɑɑsi ɑpi ɑkpini pinɛ́i u kɑ́pɑ́ɑ́ pin u tee rɛ: A uyɛɛ lɛ̃ pɔ́ n wɑi ŋmɔinu! Pimɛ́rɛ́ ɑpi u tini ɑpí nɛ sipɛsɛ u tɛ́pɛi. ");
INSERT INTO soy_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Kumúŋɛ́ kpɛ-i kɛ Piyɛɛ uu mɛtene ripoo-i ń we, unɔ́si unyinɛ yɛɛ Uléécɑɑ usinɑ n kɛisi uú weri. ");
INSERT INTO soy_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Uu Piyɛɛ yɛnu un nnɑ wéni, uu ukɛyu-i nyɑ́nɛi uu u mɑɑ rɛ: Pɔ̃́ nɛ kɔ pɛɛ Nɑsɑrɛti ukɔ́ Yeesu uyɛ̃ tikilɛnlɛ. ");
INSERT INTO soy_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Uu kɛ́su rɛ: Ám nyu, ɑ́m mmɛ̃ kɑɑ ń lɑ pɔkɛ́ símisi kómɛi. Uu pɛɛ kei yisi uu kupookpɑŋɑ́-i sĩ́. ");
INSERT INTO soy_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Unɔ́si uyɛ̃ uu piyɛ́nɛ u kpɑ́ uu pɛpɛɛ kei ń we mɑɑ rɛ: U pisoi pɛ̃ usɛ lɛ. ");
INSERT INTO soy_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Piyɛɛ uu kɔ pikɛ́ŋɛ kpɑ́. Kɑi nkɑ́ripi rinkpɑ́sɛ, pɛpɛɛ kei ń we ɑpi pimɑ́ɑ u kpɑ́ rɛ: Mɛsei yɛ mɛ, pɔ pisoi pɛ̃ usɛ lɛ. Likumúŋɛ́ rɛ pɔ Kɑlilee ukɔ́ lɛ. ");
INSERT INTO soy_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Uu kɛ́su ŋmɑɑ uú nɛ kɛtẽ kpɛɛni uu wééri rɛ: Nɛ Uléécɑɑ, ɑ́m usoi nkó nyu. ");
INSERT INTO soy_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Icɑ̃́ ii mɛsɛ nɛ mɛsɛ mɛlírũ kooi, Piyɛɛ uu léisɛ rɛ Yeesu yɛ u mɑɑ rɛ: Icɑ̃́ ikɛ́ kɛlenɛ mɛtɛ́ n kooi, pɔ́ kɛ́si mɛtɑɑni rɛ ɑ́ɑ nɛ́ nyu. Kei kuu pɛɛ mɛsɛ nɛ mɛsɛ itu ripɛ. ");
INSERT INTO soy_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Piwɛ́ɛ́sɛ nnɛ́í ɑpi mmɑrɛ mɑrɛ cɑ́pinɛ: pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ nɛ Pisuifi piwɛ́ɛ́sɛ nɛ isé picélɑɑ nɛ pitúhɑɑnɛ píimɑ nnɛ́í. Kei kɑpi pɛɛ Yeesu pɑɑsi ɑpí nɛ u tɔ́su ɑpi Pilɑti ɑnipɛ-i u wɑi. ");
INSERT INTO soy_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilɑti uu u pisɛ rɛ: Pɔ́ɔ Pisuifi uyɔɔpii? Yeesu uu rinɔ́ɔ u yɔ́su rɛ: Mmɛ̃ kɑɑ nní mɑ. ");
INSERT INTO soy_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ ɑpí nɛ nsímɛ́ mɛyɑ̃ u kpɑrɑi. ");
INSERT INTO soy_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilɑti uu kɔ pipisɛ u kpɑ́ rɛ: Áɑ rinɔ́ɔ yɔ́sunɛɛ? A ripɑí mmɛ̃ nɛ mmɛ̃ kɑpi kɛpɔ́cɑ́ɑ́ n símisi. ");
INSERT INTO soy_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Yeesu úu rinɔ́ɔ ríkɑ piyɔ́ɔ́ rikpɑ́. Ai Pilɑti pírí wɑi. ");
INSERT INTO soy_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ḿpɑ́ nkpɔ mɛlɔ́ɔ́ ɑnyɑ̃́ ɑ́ye, Pilɑti yɛɛ pɛɛ ukpɑniikɔ́ uyɛ̃ kɛ pisoi ɑpi n wɛ́ɛ ɑkpɑnii tɔlɛ. ");
INSERT INTO soy_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Utisi unyinɛ kɑpi yɛ n sée rɛ Pɑrɑpɑsi yɛ kukpɑniilee-i welɛ nɛ pinyinɛ pɛɛ ɑ́pi pɛɛ uyɔ́ɔpi kɛcɑ́ɑ́ n kpɑ́lɛ̃. Pitele pinyinɛ-i kɑpi pɛɛ usoi kpu. ");
INSERT INTO soy_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Tisoiwuí ɑri Pilɑti-mɛ̃ tɔ́mpɔ, ɑpi lɛ̃ kuu yɛ ḿpɑ́ ɑnyɑ̃́ ɑ́ye pi n wɑ pisɛ. ");
INSERT INTO soy_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilɑti uu pi pisɛ rɛ: Nɔ́ lɑ kɛ́ Pisuifi uyɔɔpi ɑkpɑnii nɔ́ tɔɔ? ");
INSERT INTO soy_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Likumúŋɛ́ rɛ Pilɑti yɛ ceri rɛ nfɑpɔlɛ nnyɑ kɛ pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ ɑpi uɑnipɛ-i Yeesu wɑ. ");
INSERT INTO soy_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Amɑ́ pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ ɑpi pisoi Pilɑti-i teriipɔ pikɛ́ u ricɔ́ŋ ukɛ́ nɛ Pɑrɑpɑsi ɑkpɑnii tɔ. ");
INSERT INTO soy_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilɑti uu pipisɛ pi kpɑ́ rɛ: Íye kɑni mpíí lɑ ŋmɑɑ kɛ́ uyɛ̃ kɑni nní n sélei rɛ Pisuifi uyɔɔpi wɑ? ");
INSERT INTO soy_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Api pipupɛi kpɑ́ rɛ: A kunɑpɛ́ɛ́kɔɔ́ kɛcɑ́ɑ́ u kɑrii. ");
INSERT INTO soy_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilɑti uu pi mɑɑ rɛ: Ncɑɑi ń-ye kuu mpíí wɑ? Api mɛyɑ̃́ pipupɛi kpɑ́ rɛ: A kunɑpɛ́ɛ́kɔɔ́ kɛcɑ́ɑ́ u kɑrii. ");
INSERT INTO soy_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilɑti uu risoiwuí mɛpɔɔlɑ tiki uu Pɑrɑpɑsi ɑkpɑnii tɔlu. Kɑpi Yeesu nɛ isɛ́í pikɑ́ii ḿ mɑsí, ɑpi pisoi ɑnipɛ-i u wɑi rɛ pikɛ́ hɑ kunɑpɛ́ɛ́kɔɔ́ kɛcɑ́ɑ́ u kɑrii. ");
INSERT INTO soy_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Pisɔ́ɔ́cɑ ɑpí nɛ kɛ́yɔcɔpɛ, kei kɑpi yɛ n túhɑɑnɛ u sĩ ɑpi pisɔ́ɔ́cɑ tɔrɔɔ nnɛ́í séi. ");
INSERT INTO soy_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Api kuyɔ́ɔpikpɛlɛnku wɛɛ́ u tɑni ɑpi sinípɛleépi nɛ riyɔ́ɔpikɔŋ pɑrii ɑpi u kipisɛ. ");
INSERT INTO soy_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Api pɛɛ lɛ̃ mɛmɑ́ɑ́ u yɑ́hɑɑnkɛɛ rɛ: Tɔ pɔ́ yɑ́ɑsi, Pisuifi uyɔɔpi. ");
INSERT INTO soy_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Api ríyu kɛcɑ́ɑ́ nɛ kɛnɑɑpi u pepu ɑpi mɛtɑ ukɛcɑ́ɑ́ tukɛ, ɑpi ukɛyu-i ńsɔnɛ wulɑ ɑpi u yɑ́ɑ́si. ");
INSERT INTO soy_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Kɑpi kɛcɑ́ɑ́ pinyɑ́nɛi u ḿ mɑsí, ɑpi kuyɔ́ɔpikpɛlɛnku wɛɛ́ kpɛ̃ u lɑpilɛ ɑpi uilũ pitɑnɛ u pɛsɛ ɑpí nɛ kunɑpɛ́ɛ́kɔɔ́ kɛcɑ́ɑ́ pikɑrii u tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Api ucéetɔŋɛ́ unyinɛ yɛɛ sicɑrɛ-mɛ̃ n lééri ńnɑŋɛ Yeesu kunɑpɛ́ɛ́kɔɔ́ cɔnsɛ. Pi yɛ utisi uyɛ̃ sée rɛ Simɔɔ, Sirɛɛni kuyu ukɔ́ lo. Uyɛɛ Alɛkisɑntiri nɛ Rufuusi usɑɑ. ");
INSERT INTO soy_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Apí nɛ kɛlõ kɛ̃ kɑpi yɛ n sée rɛ Kɔlikɔtɑ Yeesu sĩ. Kɔlikɔtɑ ɑsei rɛ Kúyu Koŋoo kɛlõ. ");
INSERT INTO soy_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Api pítɑ kɑpí nɛ pitɛ kɑpi yɛ n sée rɛ miiri n cɔ́hɔnɛ u pɑ rɛ ukɛ́ n ntí, ɑmɑ́ úu n ntí. ");
INSERT INTO soy_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Api kunɑpɛ́ɛ́kɔɔ́ kɛcɑ́ɑ́ u kɑrii ɑpi uilũ hɔɔnɛ. Pi pɑŋɑilɛ ḿpɑ́ úye uú nɛ uikpíkɛ́kpikɛ́ céru. ");
INSERT INTO soy_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ituŋɛ in mɛsɛ ɑ́mɛ we kɛfi kumúŋɛ́ pepu kɑpi u kɑrii kunɑpɛ́ɛ́kɔɔ́ kɛcɑ́ɑ́. ");
INSERT INTO soy_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Api lɛ̃ nnyɑ kɑpi Yeesu ń kpu wɔlu rɛ: Pisuifi uyɔɔpi. ");
INSERT INTO soy_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","U nɛ pisoi kpɑ́ɑ́ree pitɛ́ pinyinɛ kɑpi kɛsẽ́ kɑrii, ucɔ ukulukɛ-lukɛ-mɛ̃, ucɔ ukumii-mɛ̃. ");
INSERT INTO soy_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Lɛ̃ kɑi Nléécɑɑsimɛ́ kɛ́mɛɛ rintíki yɛ lɛ̃: Piwɑikópɛkɔɔ́ kunɑi-i kɑpi u wɑ. ");
INSERT INTO soy_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Picéetɔŋɛ́ ɑpi u lɑ́mɑɑnkɛɛ pin tíyu pɔuli pin mɑ́ikɛɛ rɛ: Yéee! Pɔ́ɔ yɛ Uléécɑɑ kɛyɔ n fori ɑɑ siyɑ́ɑ sitɑɑni nɛ pimɔ́mɛ kɛ pɛsɛ, ");
INSERT INTO soy_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ɑ ripɔ́cúruu yoriyɛ ɑɑ kunɑpɛ́ɛ́kɔɔ́ kɛcɑ́ɑ́ súiri. ");
INSERT INTO soy_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ ricuruu nɛ isé picélɑɑ ɑpi kɛcɑ́ɑ́ u nyɑ́nɛi pin pimɛcɔpɛcirɛ tee rɛ: U picɔ yóriyɛntɛlɛ ɑmɑ́ úu pɛɛ fe ukɛ́ uricuruu yoriyɛ. ");
INSERT INTO soy_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ukirisi, Isirɑyɛɛli uyɔɔpi ukɛ́ nkpéni kunɑpɛ́ɛ́kɔɔ́ kɛcɑ́ɑ́ súimɛ tɔkɛ́ yɛ̃́ ɑrí nɛ kɛfɑ tɛnɛ. U nɛ pɛ̃ kɑpi kɛsẽ́ n kɑrii pɔ́ɔ kɔ u lɑ́mɑɑnkɛɛ. ");
INSERT INTO soy_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ituŋɛ kɛcírɛ kumúŋɛ́, kuŋmɑhɑ ɑku kɛtẽ nnɛ́í cɔni hɑ́i nɛ ituŋɛ mɛtɑɑni kumúŋɛ́-pɔ. ");
INSERT INTO soy_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Kɛtúŋɛ́ mɛtɑɑni kumúŋɛ́ kpɛ-i, Yeesu uu kɛcɑ́ɑ́ilɑ píimɑ kɛnyinɛ súúni rɛ: Eloi, Eloi, lɑmɑ sɑpɑtɑni? Lɛlɛɛ rɛ Uléécɑɑ, Uléécɑɑ, yo nnyɑ kɑɑ nɛ́ ŋmɛriyɛ? ");
INSERT INTO soy_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Pisoi pɛɛ kei n cɑ́pinɛlɛ̃ kɛcɔpɛ pinyinɛ ɑpi lɛ̃ kom ɑpi rɛ: Ani ripɑí, Elii kuu nní sélei. ");
INSERT INTO soy_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Kei kɛ pikɛcɔpɛ unyinɛ uu wuri uú hɑ pítɑ nyɛpɛ-nyɛpɛ pinyinɛ-i sinɛ́ɛ̃ fɛ uu kɛnɑɑpi tuhu uu u pɑ rɛ ukɛ́ n ntí un tee rɛ: Tɔkɛ́ yɛ̃́ nkɛ̃́, in tɛ Elii yɛ́ kɑm uu u súisɛri. ");
INSERT INTO soy_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Amɑ́ Yeesu uu mɛyɑ̃́ kɛpupɛilɑ seḿ uu pɛɛ kpi. ");
INSERT INTO soy_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Kusɑ́ŋɑ́ɑ́ kɑpí nɛ Uléécɑɑ kɛyɔ kɛ́mɛɛ n kénɛlɛ̃ ɑkú cɛɛ́rinɛ mɛtɛ́, kɛcɑ́ɑ́ nɛ mɛtene-pɔ. ");
INSERT INTO soy_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Kɛ Rɔm usɔ́ɔ́cɑ kpéẽ yɛɛ pɛɛ Yeesu kɛyu-i n nyɛnu uu unkpɔ mmɛ̃ n yɛ̃́ uu rɛ: Usoi nkó yɛ pɛɛ mɛsei Uléécɑɑ Kɛpipi lɛ. ");
INSERT INTO soy_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Pinɔ́si pinyinɛ yɛ kɔ pɛɛ welɛ pin kɛtɑɑ nyɑ́nɛi. Pinɔ́si pɛ̃ kɛcɔpɛ kɛ Mɑkitɑlɑ kuyu ukɔ́ Mɑɑri nɛ Mɑɑri Yɑkupu Síńsɑ́ nɛ Yosee uni nɛ Sɑlomee ɑpí pɛɛ we. ");
INSERT INTO soy_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Kɛ Yeesu uú pɛɛ Kɑlilee-pɔ ń we, pinɔ́si pɛ̃ pɛɛ yɛ pɛɛ u n tikilɛ̃ pin u kɛisi. Pinɔ́si picɔ yɛ kɔ pɛɛ u tikilɛnlɛ ɑpí nɛ Yerusɑlɛm sĩ. ");
INSERT INTO soy_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Nnyɔ́ɔ́ nn pitulɛ mɑsí kɛ Yosɛfi, Arimɑtee kuyu ukɔ́ uú kɑ. Yosɛfi yɛ pɛɛ pitúhɑɑnɛ pɛ̃ kɛ́mɛɛ usoi kɛcirɛ lɛ. Uyɛ̃ ticuruu yɛ kɔ pɛɛ Uléécɑɑ iyɔɔpi mɛkɑmɛ mɛ́nlɛ. Kɛyɑ́ɑ kɛ̃ ɑí nɛ sɑ́ ɑnyɑ̃́ isɔɔlú kɛyɑɑ yɛ kɛ, likɛ́ nɛ kóso weesi kɛwéntɛyɑɑ. Lɛ̃ nnyɑ kɛ Yosɛfi uu ikɑri wɑ uu Pilɑti kɛ́mɛɛ sĩ́ uú hɑ u pisɛ rɛ ukɛ́ Yeesu u pɑ. ");
INSERT INTO soy_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ai Pilɑti pírí wɑi kuú nɛ n kṍ tɛ Yeesu yɛ nkpɔ mɑsí. Uu Rɔm usɔ́ɔ́cɑ kpéẽ séi uu u pisɛ rɛ in tɛ li nɑ́ŋɑi kɛ Yeesu uú nɛ n kpu. ");
INSERT INTO soy_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Kɛ Rɔm usɔ́ɔ́cɑ kpéẽ uu pisímɑɑ u ḿ mɑsí lɛ̃ kɑi ń we, Pilɑti uu ncée hɛ rɛ pikɛ́ Yeesu kpísi pikɛ́ Yosɛfi pɑ. ");
INSERT INTO soy_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Uyɛ̃ uu kusɑ́ŋɑ́ɑ́ lɔlu uu kunɑpɛ́ɛ́kɔɔ́ kɛcɑ́ɑ́ Yeesu súisɛri uu kusɑ́ŋɑ́ɑ́ u pílɛsi uú hɑ rikpíí kɑpi kupɑrɛcɑŋɑɑ-i n wɑ kɛ́mɛɛ u yekei, uu pɛɛ lɛ̃ mɛmɑ́ɑ́ mɛpɑrɛ píimɑ mɛnyinɛ pímiisɛ uu rinɔnɔɔ fi. ");
INSERT INTO soy_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mɑkitɑlɑ kuyu ukɔ́ Mɑɑri nɛ Mɑɑri Yosee uni ɑpi kei kɑpi u n wɑipɔ n nyɑ́nɛi. ");
INSERT INTO soy_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Kɛ kɛwéntɛyɑɑ kɛtúŋɛ́ ɑkɛ ń tɔsí, Mɑkitɑlɑ kuyu ukɔ́ Mɑɑri nɛ Mɑɑri Yɑkupu uni nɛ Sɑlomee ɑpi tulɑɑli lɔlu pikɛ́ hɑ Yeesu yɑkɑsi. ");
INSERT INTO soy_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Kɛwéntɛyɑɑ ukóso, ɑpi mɛkɛɛkɛɛ mɛtuŋɛleemɛ rikpíí sĩ́. ");
INSERT INTO soy_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Api pimɛcɔpɛcirɛ písɛinɛ rɛ: Wóo yɛ́ hɑ ripɑrɛ tɛɛ rikpíí rinɔnɔɔ n fílɛ̃ tɔ́ pímiisɛ? ");
INSERT INTO soy_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Kɑpi yɛ́ inípɛɛ rinsíkɑ, ɑpi yɛ́nu rɛ li mɛpɑrɛcɑŋɑɑ mɛ̃ pímiisɛlɛ. ");
INSERT INTO soy_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Api rikpíí-i lompɔ ɑpi kɛŋmɑ́nɛpi kɛnyinɛ yɛnu kɛn kulukɛ-lukɛ-mɛ̃ tũ kɛn kɛtúkɑnkɑ tomɛ́ tɑnɑɑlɛ̃, iwɑmɛ ii pi wɑi. ");
INSERT INTO soy_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Akɛ pi mɑɑ rɛ: Iwɑmɛ íi kɑpɛ nɔ́ wɑ, nté Yeesu Nɑsɑrɛti kuyu ukɔ́ uyɛ̃ kɑpi kunɑpɛ́ɛ́kɔɔ́ kɛcɑ́ɑ́ n kɑrii kɑni wɛ́ɛ́si? U nkpɔ kɛ́mɛɛ yisilɛ, úu nté we. Ani nyɑ́nii, kɛlõ nkɛ́-i kɑpi u finsɛ. ");
INSERT INTO soy_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Amɑ́ ɑni hɑ Piyɛɛ nɛ upipirɛtiki tɔrɔɔ mɑɑ rɛ u yɛ́ hɑ Kɑlilee-pɔ pi m mɛ̃́, kei kɑpi yɛ́ hɑ u yɛ̃ yɑrɛ kuu pi n símɑɑlɛ̃. ");
INSERT INTO soy_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Api rikpíí-i léeri ɑpi ntóó sɛ́ pin tɛrii nɛ iwɑmɛ, ɑmɑ́ ɑ́pi úkɑ ríkɑ mɑ nɛ iwɑmɛ mɛpehẽ. ");
INSERT INTO soy_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Kɛ Yeesu uu kɛwéntɛyɑɑ ukóso mmɑrɛ nkpɔ kɛ́mɛɛ n yisi, u tíyɛsɛlɛ Mɑɑri Mɑkitɑlɑ uu mɛfoí u yɛnu. Mɑɑri Mɑkitɑlɑ uyɛ̃ kɛ́mɛɛ kuú pɛɛ ɑníri ɑsɛɛi lɑkɑsɛ. ");
INSERT INTO soy_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mɑɑri Mɑkitɑlɑ uú hɑ nsímɛ́ mmɛ̃ pɛpɛɛ pɛɛ Yeesu rintíki símisi. Pɛ̃ pin kumúŋɛ́ kpɛ-i nkpɔ tũ pin kɔ ténesi. ");
INSERT INTO soy_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Kɑpi n kṍ tɛ Yeesu yɛ nfɑ́ɑ mɑ́lɛ, tɛ Mɑɑri Mɑkitɑlɑ yɛ u yɛ̃, ɑ́pi nɛ kɛfɑ tɛnɛ. ");
INSERT INTO soy_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Lɛ̃ mɛmɑ́ɑ́, Yeesu uu mɛ́wee féé mɛcɔ kpísi uu tíyɛsɛ upipirɛtiki pitɛ́ pinyinɛ pɛɛ kɛcɑrɛ-mɛ̃ n sĩ́ ɑpi u yɛnu. ");
INSERT INTO soy_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Pɛ̃ ticuruu ɑpí weri ɑpi picɔ nsímɛ́ mmɛ̃ símisi, picɔ pɛ̃ ɑpi kɔ nɛ kɛfɑ tɛnɛ. ");
INSERT INTO soy_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Yeesu uu mɛtɔ́rɔɔ umɛcirɛ upipirɛtiki kɛfi nɛ usɛ nyísɛ kumúŋɛ́ kpɛ-i kɑpi ilukɛ n le. Uú nɛ pinfɑtɛnɛ kucírɛ́ nɛ pinkiŋtɑkɛ pi cɛ́si, kɑ́pi pɛpɛɛ pɛɛ nkpɔ kɛ́mɛɛ mɛyisɛ-mɑɑ́ u n yɛ̃́ nɛ kɛfɑ u tɛnɛ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Uu pɛɛ lɛ̃ mɛmɑ́ɑ́ pi mɑɑ rɛ: Ani kɛtẽ nnɛ́í rikɔ́ɔ́nú ɑni pisoi nnɛ́í Nsímɛ́ Kɛcirɛ símisi. ");
INSERT INTO soy_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Uléécɑɑ yɛ́ nkó yɛɛ nɛ kɛfɑ u n tɛnɛ uu kɔ míni wolɛ yoriyɛ. Amɑ́ u yɛ́ nɛ nkó yɛɛ úu nɛ kɛfɑ u n tɛnɛ túhɑɑnɛ ɑí nɛ u kpi. ");
INSERT INTO soy_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Mɛwɑisɑŋɑ kɛ pɛpɛɛ nɛ kɛfɑ Uléécɑɑ n tɛnɛ ɑpi yɛ́ ń wɑpisi yɛ mmɛ́: Pi yɛ́ rinɛ́nyíri nɛ ɑníri lɑkɑsɛ, ɑpi mɛyu féé símisi. ");
INSERT INTO soy_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Pin iwɑ́ɑ n cɔ́pii, íi yɛ́ líkɑ pi wɑ. Ḿpɑ́ pin kɔ linírɛ́-nirɛ́ lɛɛ yɛ́ n kpu n ntí, ɑ́i yɛ́ nkpɑ́ni líkɑ pi wɑi. Pi yɛ́ pitóikɔ́ kɛcɑ́ɑ́ ɑnípɛ rilɑɑ, pitóikɔ́ pɛ̃ ɑpi pélu. ");
INSERT INTO soy_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Kɛ Upíimɑ uu pisímɛ́ pi ḿ mɑsí, ɑi kɛyómɛcɑɑ-mɛ̃ u kpíípɔ uú hɑ Uléécɑɑ kulukɛ-lukɛ-mɛ̃ kɛ́yukɔɔ́tonɛ-i tonɛ. ");
INSERT INTO soy_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Upipirɛtiki ɑpi sĩ́ ɑpí hɑ ḿpɑ́ yei Nléécɑɑsimɛ́ símisi. Upíimɑ uu pikɛi pi n lɛ́ni, uu tíyɛ mɛwɑisɑŋɑ kɑpi n wɑpisi ɑmɛ pinsímɛ́ ɑsei n nyísɛ.");
INSERT INTO soy_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Umɑ́rɛcɔ Teofiili, pisoi mɛyɑ̃ yɛ mɛwɑi mɛɛ kɛrɔ́cɔpɛ n wɑpisi nkɔ́ piwɔ́lɛ peenlɛ. ");
INSERT INTO soy_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Pi mɛwɑi mɛ̃ nsímɛ́ tɔ́ ritɔ́sɛlɛ yɑrɛ lɛ̃ kɛ pɛpɛɛ kɛ́korɑɑnɛ-mɛ n yɛ̃́ pin nɛni nɛ Uléécɑɑ nsímɛ́ kɔ́ɔ́núlɛ̃ ɑpi rɔ́ n n kɛ́ɛnkɛɛ. ");
INSERT INTO soy_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Lɛ̃ nnyɑ kɛ rinɛ́cúruu ɑm ńsɔnɛ písɛi kɛ́ lɛ̃ nnɛ́í lɛɛ kɛ́korɑɑnɛ-mɛ n wɑ ceri, ɑi nɛ́ sɔnɛsi rɛ kɛ́ linkɔ́ pɔ̃́ umɑ́rɛcɔ Teofiili wɔi kélé-kélé. ");
INSERT INTO soy_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Nɛ wɔlulɛ nɔkɛ́ nɛ n céri rɛ icélɑɑ kɑɑ n kṍ yɛ nsímɛ́sei lɛ. ");
INSERT INTO soy_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Kumúŋɛ́ kpɛ-i kɛ Erooti uú pɛɛ Yutee kɛtẽ uyɔɔpi kɛ Uléécɑɑ unyɔ́ɔnsɛ unyinɛ kɑpi yɛ n sée rɛ Sɑkɑrii uú pɛɛ́ we. U pɛɛ Apiyɑ piléékɔɔ́ kunɑi ukɔ́ usɛ lɛ. Uunɔsi yɛ pɛɛ pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ uwɛ́ɛ́sɛ Arɔɔ kɛpirɛ ukɔ́ lɛ. Pi yɛ u sée rɛ Elisɑpɛti. ");
INSERT INTO soy_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Pikɛtɛ́ yɛ pɛɛ Uléécɑɑ inipɛɛ-i kɛcírɛ sɔ́nɛlɛ pin kɔ Upíimɑ isé nɛ uicélɑɑ nnɛ́í múílɛ̃ ńsɔnɛ. ");
INSERT INTO soy_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Amɑ́ ɑ́pi pɛɛ kɛwɑ̃́ mɑ́, Elisɑpɛti yɛ pɛɛ unyɑpi lɛ. Lɛ̃ mɛmɑ́ɑ́, u nɛ ulɑ kɛtɛ́ yɛ pɛɛ kpurunulɛ. ");
INSERT INTO soy_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Kɛyɑ́ɑ kɛnyinɛ kɑi Sɑkɑrii kunɑi mɛnyɔ́ɔnsɛ tu, uu pɛɛ kɛyɑ́ɑ kɛ̃ Uléécɑɑ kɛyu-i upinyɔ́ɔnsɛkɛi n wɑi. ");
INSERT INTO soy_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Lɛ̃ kɑi pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ inyɛkii-i m pisɛ kɑpi ritiki ɑpí nɛ Sɑkɑrii wɛ́ɛ rɛ ukɛ́ Uléécɑɑ kunyɔ́ɔnsɛlee lõ ukɛ́ tulɑɑli ŋmɑɑsi. ");
INSERT INTO soy_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Kumúŋɛ́ kpɛ-i kɑpi tulɑɑli n ŋmɑɑlɛ̃, pisoi riwúí yɛ pɛɛ cɑ́pinɛlɛnlɛ pin kɛtɑhɑi mmɛ́ kɛyómɛ yɑ́ɑ́si. ");
INSERT INTO soy_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Upíimɑ uleecɑɑtumɛ unyinɛ uu mɛsɛ nɛ mɛsɛ Sɑkɑrii kɛyu-i kpɑ́fúmɛ, uu kɛhúú kɛ-i kɑpi tulɑɑli n ŋmɑɑlɛ̃ kuwɛ́lɛ́ lukɛ-lukɛ-mɛ̃ nyɛrɛ. ");
INSERT INTO soy_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Kɛ Sɑkɑrii uu u n yɛ̃́, uú túí-túí, iwɑmɛ ii u tini. ");
INSERT INTO soy_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Amɑ́ Upíimɑ uléécɑɑtumɛ uu u mɑɑ rɛ: Sɑkɑrii, iwɑmɛ íi kɑpɛ pɔ́ wɑ. Uléécɑɑ yɛ ipɔ́welɛ konlɛ. Upɔ́nɔ́si Elisɑpɛti yɛ́ kɛwɑ́ntisi pɔ́ mɑ́ri ɑɑ rinyíri kɛ hɛ rɛ Yohɑni. ");
INSERT INTO soy_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Mɛyíkíyiki kɑkɛ ripɔ́pɔ́ɔ lɑrukusɛnɛ. Pisoi mɛyɑ̃ ɑpɔɔ yɛ́ kɔ lɑrisi nɛ kɛpimɑrɛ. ");
INSERT INTO soy_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Likumúŋɛ́ rɛ u yɛ́ kɑm uu Upíimɑ inipɛɛ-i wɑi usoi píimɑ unyinɛ. Fɛɛ̃́ nɛ pítɑ pomɛ-pomɛ píkɑ ɑ́pi unnɔɔ-i loninɛ. Nfɑ́ɑsɔnɛ yɛ́ mɛyɑ̃́ u n yipɑɑlɛnlɛ kumúŋɛ́ kpɛ-i kɑpi u n cuunsɛnɛ. ");
INSERT INTO soy_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","U yɛ́ Isirɑyɛɛli pikɔ́ mɛyɑ̃ pi-Uleecɑɑ, Upíimɑ-mɛ̃ pɛsɛmɛ. ");
INSERT INTO soy_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","U yɛ́ mɑsí Uléécɑɑ kɛyu-i n sɔ́nɛlɛ nɛ mɛwɛ́ɛ́sɛsɔhɔ nɛ ńnɑŋɛ kɛ Elii uú pɛɛ m mɑ́, uu pisɑ́ɑ nɛ pisiwɑ̃ nfɑsimɛ́ pɛ́nɛ, uu tíyɛsɛ pɛpɛɛ ɑsei pite mɛwɛ́ɛ́sɛsɔhɔ n hɑ́ikusɛ ɑpi pɛpɛɛ mɛ n tíkilɛ̃ kɛmúŋɛ́ ŋmurɛi. U lɛ̃ nnɛ́í wɑinɛ ukɛ́ nɛ nsoipuri mɛɛ Upíimɑ mɛkɑmɛ m mɛ̃́ n yɛ̃́ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Amɑ́ Sɑkɑrii uu uléécɑɑtumɛ mɑɑ rɛ: Íye kɑm yɛ́ nɛ ceri rɛ ɑsei yɛ nyɛ? Likumúŋɛ́ rɛ nɛ kpurunulɛ, unɛ́nɔ́si ricuruu yɛ kɔ kpurunulɛ. ");
INSERT INTO soy_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Uléécɑɑtumɛ uu rinɔ́ɔ u pɛsɛ rɛ: Nɛ́ɛ Kɑpiriyɛɛli, Uléécɑɑ kɛyu-i kɑḿ we nɛn upikɛi wɑi. U nɛ́ tummɛlɛ rɛ kɛ́ ifɑɑci kɛcirɛ nnyí pɔ́ símisi. ");
INSERT INTO soy_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Amɑ́ ɑ́ɑ nɛ nsímɛ́ kɑpi n yekei rɛ nkɛ́ kumúŋɛ́ kunyinɛ-i wɑ nɛ kɛfɑ tɛnɛ. Lɛ̃ nnyɑ kɑi yɛ́ ripɔ́lémpi pɑɑsi ɑ́ɑ yɛ́ fe pɔkɛ́ rinɔ́ɔ mɑlɛ hɑ́i nɛ kɛ̃ kɛ mɛwɑi mɛ̃ nnɛ́í ɑmɛ n wɑinɛ. ");
INSERT INTO soy_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Kumúŋɛ́ kpɛ̃ nnɛ́í kɛ́mɛɛ, pisoi pɛɛ n cɑ́pinɛlɛ̃ pin kɛtɑhɑi Sɑkɑrii mɛ̃́ yɛ pɛɛ pírí túnlɛ rɛ pi kunyɔ́ɔnsɛlee-i mɛyɑ̃́ nɑ́ŋɑi nnyɑ. ");
INSERT INTO soy_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Amɑ́ kuu n léemɛ, úu fe ukɛ́ rinɔ́ɔ pi mɑlɛ. Pisoi ɑpi céru rɛ Uléécɑɑ yɛ linyinɛ u yɛnɛisɛlɛ kunyɔ́ɔnsɛlee-i. Anípɛ kuú nɛ pi símisi, tilémpi tin pɑhɑɑlɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Kɛ Sɑkɑrii uu kumúŋɛ́ kpɛ̃ kɑi m pisɛ rɛ ukɛ́ Uléécɑɑ pikɛi wɑ kɛtɔ n tu, uu ukɛyɔ pɛlɛ. ");
INSERT INTO soy_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Kɑi rinkpɑ́sɛ, uunɔsi Elisɑpɛti uu fɑpisi, uu umɛcirɛ kɛ́yɔ-i pɛ́su hɑ́i nɛ iwɑ́rɛ inupũ kumúŋɛ́, un tee rɛ: ");
INSERT INTO soy_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Lɛ̃ kɛ Upíimɑ uu nɛ̃́ n wɑ yɛ nní: Li nkpéni ripɔ́ɔ u wɑ rɛ ukɛ́ lɛlɛɛ pɛɛ pisoi kɛcɔpɛ inɛ́sɛi n tesɛ nɛ́ lesɛ. ");
INSERT INTO soy_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Iwɑ́rɛ kpúúlũ kɛ́mɛɛ, Uléécɑɑ uu uléécɑɑtumɛ Kɑpiriyɛɛli Kɑlilee kɛtẽ kuyu kunyinɛ kɑpi yɛ n sée rɛ Nɑsɑrɛti kɛ́mɛɛ tum. ");
INSERT INTO soy_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ukpére unyinɛ yɛɛ úu utisi n nyu kɑpí pɛɛ Yosɛfi yɛlɛilɛ̃. Pi yɛ u sée rɛ Mɑɑri. Ukɛmɛɛ́ kɛ Uléécɑɑ uu u tũ. Yosɛfi yɛ pɛɛ uyɔ́ɔpi Tɑfiti kɛpirɛ ukɔ́ lɛ. ");
INSERT INTO soy_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Uléécɑɑtumɛ uyɛ̃ uu Mɑɑri kɛyɔ-i lompɔ, uu u mɑɑ rɛ: Nɛ pɔ́ yɑ́ɑsi, Uléécɑɑ yɛ ípɛɛlɛ́ɛ pɔ́ nyísɛlɛ un kɛpɔ́pirɛ we. ");
INSERT INTO soy_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Anɔ́ɔ nyɛ̃ ɑɑ Mɑɑri túí-túísɛ, un umɛcirɛ písɛi rɛ: Iyɑ́hɑɑ íye mpuri yɛ nnyí? ");
INSERT INTO soy_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Uléécɑɑtumɛ uu pɛɛ u mɑɑ rɛ: Mɑɑri, iwɑmɛ íi kɑpɛ pɔ́ wɑ, Uléécɑɑ yɛ uipɛɛlɛ́ɛ pɔ́ nyísɛlɛ. ");
INSERT INTO soy_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Pɔ kómɛi, pɔ fɑpisinɛ ɑɑ kɛwɑ́ntisi mɑru, ɑɑ kɛ séi rɛ Yeesu. ");
INSERT INTO soy_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Kɛ yɛ́ isoi wɑ ɑpi yɛ kɛ séi rɛ Uléécɑɑ yɛɛ ḿpɑ́ yo kɛcɑ́ɑ́ ń tṹ Kɛpipi. Upíimɑ Uléécɑɑ yɛ́ tíyɛsɛ ɑkɛ usɑ́ɑyɑhɑ Tɑfiti iyɔɔpi tonɛ. ");
INSERT INTO soy_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Kɛ yɛ́ Yɑkupu kɛpirɛ pikɔ́ kɛ́mɛɛ iyɔ́ɔpi tɛnɛcirɛ́ li. Kɛiyɔɔpi íi kɛ́tɔ mɑ́nɛ. ");
INSERT INTO soy_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mɑɑri uu uléécɑɑtumɛ mɑɑ rɛ: Íye kɑi yɛ́ lɛ̃ wɑ, ɑ́m utisi nyu? ");
INSERT INTO soy_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Uléécɑɑtumɛ uu rinɔ́ɔ u pɛsɛ rɛ: Uléécɑɑ Nfɑɑsɔnɛ yɛ kɛpɔ́cɑ́ɑ́ súirinɛ, Uléécɑɑ yɛɛ ḿpɑ́ yo kɛcɑ́ɑ́ ń tṹ uu unnyɛ́rɛ́ pɔ́ yɑ́rii. Lɛ̃ nnyɑ kɛwɑ̃́ kɛ̃ nɛ Uléécɑɑ kɛkɔ́ lɛ. Pi yɛ́ kɛ sée rɛ Uléécɑɑ Kɛpipi. ");
INSERT INTO soy_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Upɔ́mɑ́rɛcɔ Elisɑpɛti kɑpí pɛɛ n sélei rɛ unyɑpi ricuruu yɛ nɛ riwɛ́ɛ́sɛ kɛwɑ́ntisi kɛfɑ mɑ́lɛ. Uiwɑrɛ kpúúlũ kɛ́mɛɛ kuu nní we. ");
INSERT INTO soy_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Likumúŋɛ́ rɛ Uléécɑɑ úu líkɑ kupɔɔnɛ we. ");
INSERT INTO soy_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Kei kɛ Mɑɑri uu pɛɛ u pɛsɛ rɛ: Nɛ Upíimɑ ukɛikɔ́ lɛ. Likɛ́ wɑ yɑrɛ kɑɑ nní ḿ mɑ. Uléécɑɑtumɛ uu pɛɛ u yɑ́ uu tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Lisiyɑɑ sɛ-i, Mɑɑri uu mɛkɛɛkɛɛ Yutɑ kɛtẽ kɛɛ ɑkúú ḿ mɑ́ kuyu kunyinɛ ncee pɔlɔ. ");
INSERT INTO soy_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Uu Sɑkɑrii kɛyɔ-i lompɔ uu Elisɑpɛti yɑ́ɑ́si. ");
INSERT INTO soy_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Kumúŋɛ́ kpɛ-i kɛ Elisɑpɛti uu Mɑɑri iyɑ́hɑɑ n kṍ, kɛwɑ̃́ ɑkɛ ukɛfɑ-i lémesi, Nfɑ́ɑsɔnɛ nn Elisɑpɛti yipu ");
INSERT INTO soy_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","uu pupɛi rɛ: Uléécɑɑ yɛ lisɔnɛ pɔ́ wɑlɛ ɑi tɔ́su pinɔ́si tɔrɔɔ nnɛ́í. Uléécɑɑ rinɔɔ sɔnɛ yɛ kɛwɑ̃́ kɛ̃ kɑɑ m mɑ́runɛ kɛcɑ́ɑ́ welɛ. ");
INSERT INTO soy_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nɛ́ɛ úye Unɛ́píimɑ uni ukɛ́ nɛ pilóólú nɛ́ ń kɑm? ");
INSERT INTO soy_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kumúŋɛ́ kpɛ-i kɑm ipɔ́yɑ́hɑɑ n kṍ, kɛwɑ̃́ yɛ kɛnɛ́fɑ-i lémesilɛ nɛ mpɔ́ɔnɑrɛ. ");
INSERT INTO soy_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Pɔ únɑrɛkomɛ lɛ, kɑɑ́ nɛ kɛfɑ n tɛnɛ rɛ Upíimɑ yɛ lɛ̃ kuu ḿ mɑ ɑpi pɔ́ símisi wɑinɛ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mɑɑri uu pɛɛ rɛ: Nɛ lɑ kɛ́ Upíimɑ rinyiri ritɑɑ́sɛ, ");
INSERT INTO soy_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","tinɛ́pɔ́ɔ ɑrí nɛ Uléécɑɑ, Unɛ́yulɑlɛ lɑrisi. ");
INSERT INTO soy_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Likumúŋɛ́ rɛ u nɛ̃́ uukɛikɔ́ nɛɛ ɑ́m líkɑ n tulɑɑlɛ̃ íwɛ ténlɛ. Kɑí nɛ nɛni rimpɑ́, nsoipuri nnɛ́í yɛ́ nɛ́ mɑɑ rɛ únɑrɛkomɛ. ");
INSERT INTO soy_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Uléécɑɑ ńnɑŋɛ nnɛ́í ute yɛ likɛi sɔnɛ kɛcirɛ nɛ́ wɑlɛ. Urinyiri nsɔnɛ yɛ nɛ mmpehẽ lɛ. ");
INSERT INTO soy_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Uyɛɛ yɛ hɑ́i kɑí nɛ n wémɛ pɛpɛɛ u n wuru ɑnɑi íwɛ tẽ́. ");
INSERT INTO soy_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Uu mɛwɑi nɑŋɛ-nɑŋɛ wɑpisi nɛ unnɑŋɛ, uu unnɑŋɛ nyísɛ pɛpɛɛ ɑkɔ́kɔri m mɑ́ ɑpi kpíi. ");
INSERT INTO soy_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Uu piyɔ́ɔpi iyɔ́ɔpi-i lesɛ, uu pɛpɛɛ ɑ́pi líkɑ n tulɑɑlɛ̃ tɑɑ́sɛ. ");
INSERT INTO soy_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Uu pɛpɛɛ nkṹ n tṹ nɛ lisɔnɛ lɛpɛisɛ, uu pimɑ́mɑ́ lɑ́kɑsɛ mɛnípɛ ŋmɑnɛ. ");
INSERT INTO soy_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Uu upikɛikɔ́ Isirɑyɛɛli pikɔ́ picomɛ weri. ");
INSERT INTO soy_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Úu pɑlɛi rɛ ukɛ́ Apirɑhɑm nɛ ukɛpirɛ pikɔ́ íwɛ tẽ́ hɑ́i nɛ ḿpɑ́ píyei-pɔ yɑrɛ kuú pɛɛ pirɔ́kpurɛ ḿ mɑ. ");
INSERT INTO soy_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mɑɑri nɛ Elisɑpɛti ɑpí tonɛ hɑ́i nɛ iwɑrɛ itɑɑni kumúŋɛ́, uu lɛ̃ mɛmɑ́ɑ́ ukɛyɔ pɛlɛ. ");
INSERT INTO soy_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Kɛ Elisɑpɛti kɛmɑrɛ ɑkɛ n tu, uu kɛwɑ́ntisi mɑru. ");
INSERT INTO soy_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Elisɑpɛti pipɛrɛcɔ nɛ upimɑrɛcɔ ɑpi kóm tɛ Upíimɑ yɛ íwɛ u tẽ́, ɑi Elisɑpɛti mɛcɔ pi lɑrisi. ");
INSERT INTO soy_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Kɛyɑ́ɑ pɑ́hɑ-pɑhɑ tuŋɛ́, ɑpí nɛ kɛwɑ̃́ weri pikɛ́ kɛ riké, ɑpi músu rɛ pikɛ́ usɑ́ɑ rinyiri kɛ hɛ rɛ Sɑkɑrii. ");
INSERT INTO soy_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Amɑ́ úni uu rɛ: Aɑi, pi yɛ kɛ sée rɛ Yohɑni. ");
INSERT INTO soy_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Api u mɑɑ rɛ: Íye lɛ̃ mɑ́, úkɑ úu kɛpɔ́yɔ-i rinyíri tɛ̃ ticɔ mɑ́. ");
INSERT INTO soy_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Api pɛɛ́ nɛ ɑnípɛ usɑ́ɑ pisɛ rɛ íye kuú lɑ pikɛ́ yɛ kɛwɑ̃́ kɛ̃ sée. ");
INSERT INTO soy_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sɑkɑrii uu pisɛ rɛ pikɛ́ kukpɑ́ncúkú u pɑ. Kɑpi ku u ḿ pɑ, uu kukɛcɑ́ɑ́ wɔ́lu rɛ: Kɛrinyiri tɛɛ Yohɑni. Ai pinnɛ́í nnɔ́ɔ yipu. ");
INSERT INTO soy_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Mɛsɛ nɛ mɛsɛ, Sɑkɑrii rilempi ɑri fénnɛ, uu símisi uu Uléécɑɑ rinyiri tɑɑ́sɛ lin cɑ́lɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ai pɛɛ upipɛrɛcɔ nnɛ́í iwɑmɛ wɑi. Yutee kɛtẽ kɛɛ ɑkúú m mɑ́ nnɛ́í kɛ́mɛɛ, pisoi ɑpi mɛwɑi mɛ̃ nsímɛ́ nɛ n túntilɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Pɛ̃ nnɛ́í pɛɛ ifɑɑci iyɛ̃ n kṍ ɑpi ikɛcɑ́ɑ́ m músu pin pimɛcɔpɛcirɛ písɛinɛ rɛ: Íye kɛ kɛwɑ̃́ kɛ̃ ɑkɛ́ mɑsí nɛ tɛnɛnɛ? Asei kɛcɑ́ɑ́, Upíimɑ yɛ pɛɛ kɛkɛpirɛ welɛ. ");
INSERT INTO soy_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Nfɑ́ɑsɔnɛ nn kɛwɑ̃́ usɑɑ Sɑkɑrii yipu, uu Uléécɑɑ rinyiri nɛ pisímɛ́ loni rɛ: ");
INSERT INTO soy_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Upíimɑ, Isirɑyɛɛli pikɔ́ Uleecɑɑ rinyiri tikɛ́ n tɑɑ́lɛ̃ kuú nɛ upikɔ́ kutu rińcɔ uu piriyu lɔlu. ");
INSERT INTO soy_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","U uyóriyɛ yɛɛ ńnɑŋɛ m mɑ́ rɔ́ hɛlɛ uukɛikɔ́ Tɑfiti kɛyɔ kɛ́mɛɛ. ");
INSERT INTO soy_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","U pɛɛ hɑ́i mɛkɛɛ-mɛ nsímɛ́ mmɛ̃ ɑntepuyɛ kuu n wɛ́ɛ símɑɑsɛlɛ. ");
INSERT INTO soy_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","U rinɔ́ɔ yekei rɛ u yɛ́ pirɔ́lɑ́ɑrɔ nɛ pɛpɛɛ irɔ́puri n yúlu ɑnipɛ-i rɔ́ ŋmɛ́hɛrɛɛsɛ. ");
INSERT INTO soy_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Uléécɑɑ yɛ nfɑnɑrɛ pirɔ́sɑ́ɑyɑhɑ nyísɛlɛ, úu uricuruu rinɔ́ɔ kuu u nɛ pɛ̃ kɛcɔpɛ n yekei pɑlɛi. ");
INSERT INTO soy_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Likumúŋɛ́ rɛ Uléécɑɑ yɛ urɔ́sɑ́ɑyɑhɑ Apirɑhɑm wéeri rɛ ");
INSERT INTO soy_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","u yɛ́ pirɔ́lɑ́ɑrɔ ɑnipɛ-i rɔ́ lesɛ, uu tíyɛsɛ ɑ́ri yɛ́ nɛ iwɑmɛ u n yɑ́ɑ́si. ");
INSERT INTO soy_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ai tíyɛsɛ ɑrí n kpɑ̃́iilɛ̃ tɔn kɛcirɛ sɔ́nɛ uinipɛɛ-i hɑ́i nɛ ntɔ́fɑ́ɑ siyɑɑ kɛtɔ-pɔ. ");
INSERT INTO soy_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Pɔ̃́ kɛnɛ́wɑ̃́, pi yɛ́ pɔ́ sée rɛ Uléécɑɑ yɛɛ ḿpɑ́ yo kɛcɑ́ɑ́ ń tṹ ɑntepu. Likumúŋɛ́ rɛ pɔ́ɔ yɛ́ Upíimɑ kɛkpeẽ wɑ ɑɑ ncée u nyɔ́ɔnsɛ, ");
INSERT INTO soy_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ɑɑ upikɔ́ céreisɛ rɛ u yɛ́ piriyu lɔ uu piɑkópɛ pi sɑ́rɛi. ");
INSERT INTO soy_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Uléécɑɑ nfɑnɑrɛ toi-toi nnyɑ, u nɛ umɛtɛ́í sɔ́ntilɛ ɑmɛ rɔ́ kpɑ̃́ii yɑrɛ ntuŋɛ ");
INSERT INTO soy_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ukɛ́ pɛpɛɛ kuŋmɑhɑ-i nɛ pɛpɛɛ nkpɔ kuhorɛ-i ń we rikpɑ̃́iisɛ, uu ɑrɔ́nɑ nkíŋniŋɛ ncee tikisɛ. ");
INSERT INTO soy_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Kɛwɑ̃́ kɛn pɑpisi, kɛmɛsɔhɔ mɛn kɔ pɑpisi. Uu ɑcɛsi kóimɑ-i n finu hɑ́i nɛ kɛyɑ́ɑ kɛ̃ kuu upikɛi Isirɑyɛɛli pikɔ́ kɛcɔpɛ n kórɑɑnɛ. ");
INSERT INTO soy_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Kɛtẽ nnɛ́í uyɔɔpi Okusiti uu kumúŋɛ́ kpɛ-i rinɔ́ɔ hɛ rɛ pikɛ́ kɛtẽ nnɛ́í pisoi kɛɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Pikɛ́ɛ̃ pɛpɛɛ pifoí. Pi wɑlɛ kumúŋɛ́ kpɛ-i kɛ Kiriniisi uú pɛɛ Sirii kɛtẽ kɛcɑ́ɑ́ iyɔ́ɔpi n le. ");
INSERT INTO soy_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ḿpɑ́ úye uu ukuyu pikɛ́ɛ̃ sĩ. ");
INSERT INTO soy_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yosɛfi uu Kɑlilee kɛtẽ kɛ́mɛɛ Nɑsɑrɛti kuyu-i yisi uu Yutee kɛteni-i Tɑfiti kuyu kɑpi yɛ n sée rɛ Pɛtɛlɛhɛm sĩ. Kuyu kpɛ-i kɑpi uyɔ́ɔpi Tɑfiti mɑri. Yosɛfi ricuruu yɛ Tɑfiti kɛyɔ nɛ ukɛpirɛ ukɔ́ lɛ. ");
INSERT INTO soy_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Uu kei pikɛ́ɛ̃ sĩ, u nɛ uunɔsi felei-felei Mɑɑri yɛɛ kɛfɑ m mɑ́. ");
INSERT INTO soy_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Pin Pɛtɛlɛhɛm-i we, ukɛmɑrɛyɑɑ ɑkɛ tulu ");
INSERT INTO soy_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","uu ukɛwɑ̃ foí mɑ́ru kɛtisi, uu ɑsɑ́ŋɑ́ɑ́ kɛ yɑrii uu kuhɔpi kɛcɑ́ɑ́ kɛ finsɛ, kɑpi picéetɔŋɛ́ kulee-i kɛtónɛ m pɑɑ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Kɛlõ kɛsɛ kɛ-i kɛ pisɛɛsẽ́ pinyinɛ ɑpí pɛɛ kɛsinɛ we pin sicɑrɛ-i piisɛɛ kɛcɑ́ɑ́ pɑílɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Upíimɑ uleecɑɑtumɛ uu pikɛyu-i kpɑ́fúmɛ, Upíimɑ mɛyɔɔpi ɑmɛ́ n tɛ́lu mɛn kɛkɑ́lɛ pi wɑilɛ̃. Iwɑmɛ ii pi wɑi mɛyɑ́nsei. ");
INSERT INTO soy_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Uléécɑɑtumɛ uu pɛɛ pi mɑɑ rɛ: Iwɑmɛ íi kɑpɛ nɔ́ wɑ. Nsímɛ́ sɔnɛ mɛɛ yɛ́ Isirɑyɛɛli pikɔ́ nnɛ́í ripɔɔ mɛyɑ̃́ n níŋukusɛ kɑḿ nɛ nɔ́ kɑ. ");
INSERT INTO soy_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Nɛni kɛyɑɑ nkɛ́ kɑpi Tɑfiti kuyu-i Nɔ́unɛ́yulɑlɛ mɑri, uyɛ̃ kɛ Uléécɑɑ uu n wɛ́ɛ, Upíimɑ. ");
INSERT INTO soy_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Lɛ̃ kɑni yɛ́ nɛ u n céri yɛ nní: Nɔ́ kɛwɑ̃́ fɛnfɛ̃í lɛɛpɔ kɑpi kusɑ́ŋɑ́ɑ́ ḿ pílɛsi ɑpi kuhɔpi kɛcɑ́ɑ́ finsɛ. ");
INSERT INTO soy_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Mɛsɛ nɛ mɛsɛ, piléécɑɑtumɛ picɔ ɑpi ufoí nkó kɛcɑ́ɑ́ kpɑ́pɔ ɑpi kulúi wɑi, ɑpi pɛɛ Uléécɑɑ mɛyɔɔpi n yom tɛ ");
INSERT INTO soy_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Uléécɑɑ yɛɛ kɛyómɛcɑɑ-pɔ ipɑkɑrɛ te. Nkíŋniŋɛ nkɛ́ pɛ̃ kuu kɛtẽ kɛcɑ́ɑ́ ń lɑ kɛcɔpɛ n we. ");
INSERT INTO soy_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Kɛ piléécɑɑtumɛ ɑpi pi rin-yɑ́ ɑpi kɛyómɛcɑɑ-mɛ̃ pɛlɛ, pisɛɛsẽ́ ɑpi pɛɛ símɑɑnɛ rɛ: Tɔkɛ́ Pɛtɛlɛhɛm hɑ. Li pisɛ rɛ tɔkɛ́ lɛlɛɛ n wɑ kɛ Upíimɑ uu rɔ́ n céreisɛ yɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Api kei mɛkɛɛkɛɛ sĩ ɑpí hɑ Mɑɑri nɛ Yosɛfi lɛɛpɔ, kɛwɑ̃́ kɛn kuhɔpi kɛ́mɛɛ finu. ");
INSERT INTO soy_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Kɑpi kɛ n yɛ̃́, ɑpi lɛ̃ kɛ uléécɑɑtumɛ uu kɛwɑ̃́ kɛ̃ nsímɛ́ n símisi kɛɛnkɛɛ. ");
INSERT INTO soy_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Lɛ̃ kɛ pisɛɛsẽ́ ɑpi n símisi ɑi pɛ̃ nnɛ́í pɛɛ kutu pi n cɔ́lɛ̃ pírí wɑi. ");
INSERT INTO soy_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mɑɑri uu mmɛ̃ nnɛ́í ukɛfɑ-i múlú un nkɛcɑ́ɑ́ músu ńsɔnɛ. ");
INSERT INTO soy_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Pisɛɛsẽ́ ɑpi lɛ̃ mɛmɑ́ɑ́ nkúlɛcee pɔlɔ. Api Uléécɑɑ rinyiri tɑɑ́sɛ ɑpi umɛyɔɔpi n yom tɛ u tíyɛsɛ ɑpi kóm ɑpi kɔ yɛnu nnyɑ. Linnɛ́í yɛ wɑ yɑrɛ lɛ̃ kɛ uléécɑɑtumɛ uu pi n símisi. ");
INSERT INTO soy_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Siyɑ́ɑ sisɛɛi mɛmɑ́ɑ́, kɛwɑ̃́ kɛkéyɑɑ ɑkɛ tulu, ɑpi rinyíri kɛ hɛ rɛ Yeesu. Tinyíri tɛ̃ kɛ uléécɑɑtumɛ uu pi céesi Mɑɑri uu kɛlenɛ fɑpisi. ");
INSERT INTO soy_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Lɛ̃ mɛmɑ́ɑ́, ituŋɛ ii tulu rɛ pikɛ́ inyɛ́kii wɑ pikɛ́ nɛ pimɛcirɛ hɛɛrɛ yɑrɛ kɑi Moisi isé kɛ́mɛɛ m pisɛ, Mɑɑri nɛ Yosɛfi ɑpi pɛɛ́ nɛ kɛwɑ̃́ Yerusɑlɛm kuyu sĩ tɛ pikɛ́ Upíimɑ kɛ nyísɛ. ");
INSERT INTO soy_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Likumúŋɛ́ rɛ li Upíimɑ isé kɛ́mɛɛ wɔ́lɑɑlɛ̃ tɛ: Upíimɑ yɛɛ kɛwɑ́ntisi foí te. ");
INSERT INTO soy_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Api kɔ inyɔ́ɔnsɛ kɛ isé isɛ iyɛ̃ ii m pisɛ wɑi: Sikpéékpeepi sitɛ́ nɛ́ɛ ɑlɔ́ɔlɑ̃ síńsɑ́ ɑtɛ́ kɑpi yɛ́ nɛ wɑ. ");
INSERT INTO soy_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Utisi unyinɛ kɑpi yɛ n sée rɛ Simeyɔɔ yɛ pɛɛ Yerusɑlɛm-i welɛ. Utisi uyɛ̃ yɛ pɛɛ usoi sɔnɛ lɛ un Uléécɑɑ riwurɛ mɑ́ un uyɛ̃ kɑí pɛɛ m pisɛ rɛ ukɛ́ Isirɑyɛɛli yoriyɛ mɛ̃́. Nfɑ́ɑsɔnɛ yɛ pɛɛ ukɛmɛɛ́ welɛ. ");
INSERT INTO soy_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Uléécɑɑ uú nɛ Nfɑ́ɑsɔnɛ tiki uú nɛ u símisi rɛ u yɛ́ uyɛ̃ kɛ Upíimɑ uu n wɛ́ɛ uu tumti nɛ uinipɛɛ yɛ̃ uu kɛlenɛ kpi. ");
INSERT INTO soy_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Nfɑ́ɑsɔnɛ nn tíyɛsɛ Simeyɔɔ uu Uléécɑɑ kɛyɔ sĩ. Kɛ Yeesu pikɔ́ ɑpí nɛ u n hɑ́pɔ pikɛ́ inyɛ́kii iyɛ̃ kɛ isé ii m pisɛ wɑ, ");
INSERT INTO soy_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeyɔɔ uu u kpísi, uu Uléécɑɑ pɑkɑrɛ uu rɛ: ");
INSERT INTO soy_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Upíimɑ, tipɔ́nɔ́ɔ kɑɑ n yekei yɛ nkpéni lilɛ. Pɔ́ fe ɑɑ nkpéni nɛ̃́ upɔ́kɛikɔ́ tíyɛ ɑm nkíŋniŋɛ-i kpi. ");
INSERT INTO soy_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Likumúŋɛ́ rɛ nɛ nɛ inɛ́nípɛɛ pipɔ́yulɑlɛ yɛnlɛ. ");
INSERT INTO soy_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Pɔ Uyóriyɛ kpíimɛlɛ ɑɑ isoipuri nnɛ́í kɛyu-i wɑi. ");
INSERT INTO soy_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Uyɛɛ mɛtɛ́í mɛɛ yɛ́ n tíyɛsɛ kɛtẽ nnɛ́í ɑyu ɑɑ pɔ́ céru. Uyɛɛ yɛ́ tíyɛsɛ mpɔ́puri Isirɑyɛɛli rinyiri ɑrí tɑɑ́. ");
INSERT INTO soy_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Yeesu usɑɑ nɛ uuni ɑpi pírí wɑi nɛ lɛ̃ kɛ Simeyɔɔ uu Yeesu kɛcɑ́ɑ́ n símisi. ");
INSERT INTO soy_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeyɔɔ uu ɑnɔ́ɔ sɔnɛ pi tikisɛ, uu Yeesu uni Mɑɑri mɑɑ rɛ: Uléécɑɑ yɛ kɛwɑ̃́ nkɛ́ wɛ́ɛ rɛ kɛkɛ́ tíyɛsɛ pisoi mɛyɑ̃ pikɛ́ loó, pimɛyɑ̃ pikɛ́ kɔ Isirɑyɛɛli-i yisi. Kɛkɛɛ Uléécɑɑ linyísɛ-nyísɛ lɛɛ yɛ́ pisoi nɛ Uléécɑɑ kɛcɔpɛ m pɑ́sɑisɛnɛ. ");
INSERT INTO soy_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","U yɛ́ lɛ̃ kɛ pisoi mɛyɑ̃ ɑpi risɛ́ɛ́ nɛ pisifɑ-i m músu yɑ́mnɛ. Amɑ́ pɔ̃́ kɛuni, pɔ́ ntóósi kõ yɑrɛ kɛtɛ́hɛ kɑpi pɔ́ tuhu. ");
INSERT INTO soy_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Unɔ́si unyinɛ kɑpi yɛ n sée rɛ Aɑni yɛ kɔ pɛɛ́ welɛ. U ɑntepu lɛ. Fɑnuwɛɛli ukpére lo Asɛɛ kumɑrɛ-i. U pɛɛ kpurunulɛ ńsɔnɛ. Aŋmɛ̃ ɑsɛɛi kɛ u nɛ uulɑ pɛɛ n sɔ́ɔnnɛ unnɑŋɛ kɛ́mɛɛ ɑpi wɑ. ");
INSERT INTO soy_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Lɛ̃ mɛmɑ́ɑ́, uu ikúmɑnnɔsi tonɛ uú hɑ nɛ ɑŋmɛ̃ kuwóó nɛ ɑfɛɛtɑɑni nɛ ɑnɑ tulu. Úu yɛ píkɑi Uléécɑɑ kɛyɔ riyɑ́, ɑmɑ́ kɛtúŋɛ́ nɛ kɛsinɛ kuu yɛ Uléécɑɑ pikɛi n wɑi un ɑnɔ́ɔ pɑɑsi un welu. ");
INSERT INTO soy_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Uu kumúŋɛ́ kpɛ-i Uléécɑɑ kɛyɔ-i hɑpɔ uu Uléécɑɑ pipɑkɑrɛ loni. Uu pɛ̃ nnɛ́í pɛɛ pɛɛ m mɛ̃́ tɛ Uléécɑɑ ukɛ́ Yerusɑlɛm riyu lɔ kɛwɑ̃́ kɛ̃ nsímɛ́ símisi. ");
INSERT INTO soy_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Kɛ Yeesu pikɔ́ ɑpi lɛ̃ kɛ Upíimɑ isé ii m pisɛ rɛ pikɛ́ wɑ piwɑi ḿ mɑsí, ɑpí nɛ Kɑlilee u pɛlɛ, pikuyu Nɑsɑrɛti kɛ́mɛɛ. ");
INSERT INTO soy_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Kɛwɑ̃́ ɑkɛ́ m pɑpisi kɛn kɔ ńnɑŋɛ kpɑ́lɛ̃. Mɛwɛ́ɛ́sɛsɔhɔ píimɑ kuú pɛɛ mɑ́, Uléécɑɑ ipɛɛlɛ́ɛ in kɔ ukɛcɑ́ɑ́ we. ");
INSERT INTO soy_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ḿpɑ́ kuŋmɛ̃ kúye-i, Yeesu usɑɑ nɛ uuni yɛ̀ɛ̀ pɛɛ nkpɔ mɛlɔ́ɔ́ ɑnyɑ̃́ hɑlɛ Yerusɑlɛm-pɔ. ");
INSERT INTO soy_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Kumúŋɛ́ kpɛ-i, Yeesu yɛ pɛɛ ɑŋmɛ̃ kɛfi nɛ ɑtɛ́ mɑ́lɛ. Usɑ́ɑ nɛ úni ɑpí nɛ u pɛ́nɛ ɑpi ɑnyɑ̃́ sĩ́ yɑrɛ kɑpi yɛ ń hɑ. ");
INSERT INTO soy_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Kɛ ɑnyɑ̃́ ɑɑ n tɛnɛ, usɑ́ɑ nɛ úni ɑpi pɛlɛ, ɑmɑ́ Yeesu uu Yerusɑlɛm-i mɛ́suni, upikɔ́ ɑ́pi kɔ nkpɑ́ni céri. ");
INSERT INTO soy_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Api músu rɛ Yeesu yɛ́ pipisencɔ pinyinɛ rintikilɛ, ɑpi sɔ́nɛ yɑrɛ kɛyɑ́ɑ kɛsɛ kumúŋɛ́, ɑpi pɛɛ lɛ̃ mɛmɑ́ɑ́ pipimɑrɛcɔ nɛ pipisɑnɛ kɛ́mɛɛ piwɛ́lɑɑ u sĩ. ");
INSERT INTO soy_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Amɑ́ ɑ́pi u yɛ̃, ɑpi Yerusɑlɛm-mɛ̃ pɛlɛ pin piwɛ́lɑɑ u nɔŋ́lɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Api kɛyɑ́ɑ tɑ́ɑ́nũ tuŋɛ́ Uléécɑɑ kɛyɔ-i u yɛnu un isé picélɑɑ kɛcɔpɛ tũ un kutu pi cɔlɛ̃ un kɔ nsímɛ́ pi písɛi. ");
INSERT INTO soy_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Pírí kɛ Yeesu mɛsɔhɔ nɛ uɑnɔɔ mɛyɔ́ɔ́i ɑi pɛ̃ nnɛ́í pɛɛ kutu u n cɔ́lɛ̃ wɑ. ");
INSERT INTO soy_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Kɛ usɑ́ɑ nɛ úni ɑpi u n yɛ̃́, ɑi pírí pi wɑi, úni uu u mɑɑ rɛ: Kɛnɛ́wɑ̃́, yo nnyɑ kɑɑ lɛ̃ wɑ? Tɔ́ nɛ upɔ́sɑ́ɑ yɛ pɛɛ pɔ́ wɛ́ɛ́silɛ kɛrɔ́wuu kɛn túúni. ");
INSERT INTO soy_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Uu rinɔ́ɔ pi yɔ́su rɛ: Yo nnyɑ kɑni nɛ́ wɛ́ɛ́si? Áni nyu rɛ li pisɛ rɛ kɛ́ unɛ́sɑ́ɑ pikɛi wɑɑ? ");
INSERT INTO soy_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Amɑ́ ɑ́pi lɛ̃ kuu pi ḿ mɑ ɑsei kõ. ");
INSERT INTO soy_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Yeesu uu pi tiki ɑpi Nɑsɑrɛti pɛlɛ. U pɛɛ usɑ́ɑ nɛ úni pɑkɑrɛlɛnlɛ. Úni uu kɔ mɛwɑi mɛ̃ nnɛ́í ukɛfɑ-i n wɑilɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yeesu uú m pelu, umɛsɔhɔ mɛn kpɑ́lɛ̃ un kɔ isoi sɔnɛ le, Uléécɑɑ nɛ sisoipipi inipɛɛ-i, Uléécɑɑ ipɛɛlɛ́ɛ in kɔ ukɛcɑ́ɑ́ we. ");
INSERT INTO soy_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Kumúŋɛ́ kunyinɛ-i, Uléécɑɑ uu Sɑkɑrii uŋmɑ́nɛ Yohɑni kucɛsi kóimɑ-i rinɔ́ɔ mɑɑ. Rɔm uyɔɔpi píimɑ kɑpi yɛ n sée rɛ Tipɛɛ yɛ pɛɛ likumúŋɛ́ kpɛ-i iyɔ́ɔpi kɛ́mɛɛ ɑŋmɛ̃ kɛfi nɛ ɑnupũ piwɑi mɑsilɛ. Pɔnsi Pilɑti yɛɛ pɛɛ Yutee kɛtẽ kɛcɑ́ɑ́ pɑílɛ̃, Erooti pɔ́ɔn Kɑlilee kɛkɔ́ kɛcɑ́ɑ́ pɑílɛ̃. Uumɑɑ Filipu yɛɛ pɛɛ Itumee nɛ Tɑrɑkoni sitẽ kɛcɑ́ɑ́ pɑílɛ̃, Lisɑniyɑ un Apitɛɛni kɛtẽ kɛcɑ́ɑ́ pɑílɛ̃. Likumúŋɛ́ kpɛ-i kɛ Aɑni nɛ Kɑyifu ɑpí pɛɛ pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ. ");
INSERT INTO soy_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yohɑni uu Yuritɛɛ ɑyu pikɔ́ɔ́nú loni un yóólɛ̃ tɛ: Ani mɛfinɛ consɛ, ɑni tíyɛsɛ pikɛ́ míni nɔ́ wolɛ Uléécɑɑ ukɛ́ nɔ́ɑnɛ́kópɛ nɔ́ sɑ́rɛi. ");
INSERT INTO soy_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ai wɑi yɑrɛ lɛ̃ kɛ ɑntepu Esɑyi uú pɛɛ uritɛlɛ́ kɛ́mɛɛ n wɔ́i rɛ: Usoi rinɔɔ yɛ ri tɛɛ kucɛsi kóimɑ-i n yóólɛ̃ tɛ: Ani Upíimɑ ncee nyɔ́ɔnsɛ, ɑni uicee tɛ̃iisɛ ikɛ́ kɛcirɛ wɑ. ");
INSERT INTO soy_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ahórɛ-horɛ nnɛ́í yɛ sírunɛ, ɑkúú nɛ sikúúpi nnɛ́í ɑsi foru, icée sikɔ́ɔ́nú nnɛ́í ɑsi tɛ̃́ii, icée ɑhorɛ-horɛ nnɛ́í ɑɑ síru. ");
INSERT INTO soy_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ḿpɑ́ úye uu pɛɛ yɛ́nu rɛ Uléécɑɑ yɛ usoi riyu lɔlɛ. ");
INSERT INTO soy_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Asoiwuí ɑɑ Yohɑni kɛ́mɛɛ n sɔ́nɑɑpɔ ukɛ́ míni pi wolɛ. Uu pi mɑɑ rɛ: Nɔ́ ɑkpurii nnyɛ́! Wóo nɔ́ céesi rɛ nɔ́ fe ɑni Uléécɑɑ kɛtɑhɑi kɛɛ n tu kɑɑsɛ mɑ́? ");
INSERT INTO soy_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ani yɛ mɛwɑi mɛɛ n nyísɛlɛ̃ tɛ nɔ mɛfinɛ consɛ wɑ. Áni kɑpɛ nɔ́mɛnɛ́círɛ m mɑ́ikɛɛ rɛ: Apirɑhɑm yɛɛ urɔ́sɑ́ɑyɑhɑ. Uléécɑɑ yɛ́ fe uu wɑisɛ ɑpɑrɛ nnyɛ́ nní ɑɑ pɑnsɛ Apirɑhɑm sipirɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Isɔ isɔɔlu yɛ pilɛ ikɛ́ ɑléé sémni hɑ́i iníŋí-pɔ. Pi kuléé nkú kpɛɛ ɑ́ku ɑpipi sɔnɛ m mɑ́rɛi kénɛ ɑpi nnɑ-i sɑ́pɔ. ");
INSERT INTO soy_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Asoiwuí ɑɑ pɛɛ u pisɛ rɛ: In lɛɛ ni, íye kɑi nkpéni pisɛ rɛ tɔkɛ́ wɑ? ");
INSERT INTO soy_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Uu rinɔ́ɔ pi yɔ́su rɛ: Úye un sitúkɑnkɑ sitɛ́ m mɑ́, li pisɛ rɛ ukɛ́ uyɛɛ úu m mɑ́ kɛsɛ hɛ, úye un kɔ ilukɛ m mɑ́, li pisɛ rɛ ukɛ́ uucɔ yɛɛ úu m mɑ́ hɛ. ");
INSERT INTO soy_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Pilɑmpooyɔɔ́ ricuruu ɑpi símpɔ pikɛ́ míni pi wolɛ, ɑpi Yohɑni pisɛ rɛ: Urɔ́célɑɑ, íye kɑi pisɛ rɛ tɔ́ɔkɛ́ wɑ? ");
INSERT INTO soy_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Uu rinɔ́ɔ pi yɔ́su rɛ: Áni kɑpɛ yɛ lɛ̃ kɛ isé ii rinké rɛ pisoi pikɛ́ yɛ hɛ́ɛ́lɛ kɛcɑ́ɑ́ rilɑɑsɛ. ");
INSERT INTO soy_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Pisɔ́ɔ́cɑ pɔ̃́ ticuruu ɑpi u pisɛ rɛ: Tɔ̃́ ní, íye kɑi pisɛ rɛ tɔkɛ́ wɑ? Uu pi mɑɑ rɛ: Áni kɑpɛ yɛ úkɑ siwóó yɔsí nɛ ńnɑŋɛ nɛ́ɛ ɑní nɛ nsímɛ́ liute wɑ́ɑ́nɑ́, ɑmɑ́ ɑni nɛ nɔ́inɛ́hɛ́ɛ́ ripɑ́. ");
INSERT INTO soy_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Kuyu nnɛ́í yɛɛ pɛɛ tɑ́lɛ̃ tɛ lipíimɑ linyinɛ yɛ wɑinɛ. Ḿpɑ́ úye uu pɛɛ́ m músu rɛ nɛ́ɛ Yohɑni yɛɛ uyɛ̃ kɛ Uléécɑɑ uu n wɛ́ɛ. ");
INSERT INTO soy_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yohɑni uu pɛɛ pi mɑɑ rɛ: Míni kɛ nɛ́ɛ nɛ nɔ́ wólɛ, ɑmɑ́ unyinɛ yɛɛ ńnɑŋɛ nɛ́ n fe yɛ sɔ́nti. Inɛ́soi íi tu rɛ kɛ́ uɑnɛ́ɛ́ri nŋmɛ fénnɛ. Nfɑ́ɑsɔnɛ nɛ nnɑ kuu yɛ́ nɛ nɔ́ wolɛ. ");
INSERT INTO soy_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","U ukunipɛ-i kuhóólo kɑpi yɛ nɛ n cɑ́cɑi múílɛnlɛ ukɛ́ nɛ mɛpipi nɛ ɑcɔ́lɛ́ kóólɛnɛ. U mɛpipi risímɛ-i súúninɛ uu ɑyúi pɔ̃́ nnɑ mɛɛ ńn yɛ píkɑi n kpu kɛ́mɛɛ toroisɛ. ");
INSERT INTO soy_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yohɑni yɛ pɛɛ pisoi itisi kpɑriisɛlɛ un nɛ Nsímɛ́ Kɛcirɛ pi símisi. ");
INSERT INTO soy_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Erooti yɛ pɛɛ umɑ́rɛcɔ cirɛ unɔsi Erootiyɑti kpísilɛ uu kɔ mɛwɑi kópɛ mɛcɔ mɛyɑ̃ wɑpisi. Lɛ̃ nnɛ́í nnyɑ kɛ Yohɑni uú pɛɛ́ nɛ u cɛ́si. ");
INSERT INTO soy_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Erooti uu kɔ mɛwɑi kópɛ mɛcɔ kpɑ́ uu Yohɑni kukpɑniilee wɑi. ");
INSERT INTO soy_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Kɑpi pisoi nnɛ́í míni piwólɛ ḿ mɑsí, ɑpi kɔ Yeesu ricuruu wolɛ. Kumúŋɛ́ kpɛ-i kuu kɛyómɛ n yɑ́ɑ́si, ɑi kɛyómɛ hɑ́nnɛ. ");
INSERT INTO soy_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Nfɑ́ɑsɔnɛ nn ukɛcɑ́ɑ́ súiri yɑrɛ rilɔ́ɔlɑ̃, pin ti nyɑ́ni nɛ inípɛɛ. Tinɔ́ɔ ɑri kɛyómɛcɑɑ-pɔ mɑɑri rɛ: Pɔ́ɔ Kɛnɛ́pipi lɑlɑ kɛcirɛ. Ám yɛ kɛpɔ́cɑ́ɑ́ kṍ. ");
INSERT INTO soy_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Aŋmɛ̃ ɑfɛɛtɑɑni kumúŋɛ́ kɛ Yeesu uu mɑ́ uú nɛ upikɛi koru. Yɑrɛ kɑpí pɛɛ m músu, u pɛɛ Yosɛfi kɛpipi lɛ. Yosɛfi un Elii kɛpipi, ");
INSERT INTO soy_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elii un Mɑtɑti kɛpipi, Mɑtɑti un Lefi kɛpipi, Lefi un Mɛlisi kɛpipi, Mɛlisi un Yɑnɑyi kɛpipi, Yɑnɑyi un Yosɛfi kɛpipi, ");
INSERT INTO soy_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yosɛfi un Mɑtɑtiyɑsi kɛpipi, Mɑtɑtiyɑsi un Amosi kɛpipi, Amosi un Nɑhum kɛpipi, Nɑhum un Esili kɛpipi, Esili un Nɑkɑi kɛpipi, ");
INSERT INTO soy_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nɑkɑi un Mɑɑti kɛpipi, Mɑɑti un Mɑtɑtiyɑsi kɛpipi, Mɑtɑtiyɑsi un Simeyi kɛpipi, Simeyi un Yosee kɛpipi, Yosee un Yotɑ kɛpipi, ");
INSERT INTO soy_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yotɑ un Yowɑnɑɑ kɛpipi, Yowɑnɑɑ un Resɑ kɛpipi, Resɑ un Soropɑpɛɛli kɛpipi, Soropɑpɛɛli un Sɑlɑtiyɛɛli kɛpipi, Sɑlɑtiyɛɛli un Neri kɛpipi, ");
INSERT INTO soy_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri un Mɛlisi kɛpipi, Mɛlisi un Ati kɛpipi, Ati un Kosɑm kɛpipi, Kosɑm un Elimɑtɑm kɛpipi, Elimɑtɑm un Eri kɛpipi, ");
INSERT INTO soy_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eri un Yosuwee kɛpipi, Yosuwee un Eliyesɛɛ kɛpipi, Eliyesɛɛ un Sorim kɛpipi, Sorim un Mɑtɑtɑ kɛpipi, Mɑtɑtɑ un Lefi kɛpipi, ");
INSERT INTO soy_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lefi un Simeyɔɔ kɛpipi, Simeyɔɔ un Yutɑ kɛpipi, Yutɑ un Yosɛfi kɛpipi Yosɛfi un Yonɑm kɛpipi, Yonɑm un Eliyɑkim kɛpipi, ");
INSERT INTO soy_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyɑkim un Meleyɑ kɛpipi, Meleyɑ un Menɑ kɛpipi, Menɑ un Mɑtɑtɑ kɛpipi, Mɑtɑtɑ un Nɑtɑɑ kɛpipi, Nɑtɑɑ un Tɑfiti kɛpipi, ");
INSERT INTO soy_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Tɑfiti un Sese kɛpipi, Sese un Opɛti kɛpipi, Opɛti un Poosi kɛpipi, Poosi un Sɑlɑ kɛpipi, Sɑlɑ un Nɑsɔɔ kɛpipi, ");
INSERT INTO soy_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nɑsɔɔ un Aminɑtɑpi kɛpipi, Aminɑtɑpi un Atimɛɛ kɛpipi, Atimɛɛ un Esirɔm kɛpipi, Esirɔm un Fɑrɛsi kɛpipi, Fɑrɛsi un Yutɑ kɛpipi ");
INSERT INTO soy_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yutɑ un Yɑkupu kɛpipi, Yɑkupu un Isɑɑki kɛpipi, Isɑɑki un Apirɑhɑm kɛpipi, Apirɑhɑm un Terɑ kɛpipi, Terɑ un Nɑhɔɔ kɛpipi ");
INSERT INTO soy_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nɑhɔɔ un Seruki kɛpipi, Seruki un Rɑkɑu kɛpipi, Rɑkɑu un Fɑlɛki kɛpipi, Fɑlɛki un Epɛɛ kɛpipi, Epɛɛ un Sɑlɑ kɛpipi, ");
INSERT INTO soy_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sɑlɑ un Kenɑm kɛpipi, Kenɑm un Aripɑkisɑɑti kɛpipi, Aripɑkisɑɑti un Sɛm kɛpipi, Sɛm un Nowee kɛpipi, Nowee un Lemɛki kɛpipi, ");
INSERT INTO soy_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lemɛki un Mɑtusɑlɛm kɛpipi, Mɑtusɑlɛm un Enɔki kɛpipi, Enɔki un Yerɛti kɛpipi, Yerɛti un Mɑlɑleyɛɛli kɛpipi, Mɑlɑleyɛɛli un Kenɑɑ kɛpipi, ");
INSERT INTO soy_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenɑɑ un Enɔɔsi kɛpipi, Enɔɔsi un Sɛɛti kɛpipi, Sɛɛti un Atɑm kɛpipi, Atɑm un Uléécɑɑ kɛpipi. ");
INSERT INTO soy_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yeesu uu Yuritɛɛ nkoi-mɛ̃ n leeri Nfɑ́ɑsɔnɛ nn u yipɑɑlɛ̃. Nfɑ́ɑsɔnɛ nn u kpísi nń nɛ kucɛsi kóimɑ-mɛ̃ sĩ. ");
INSERT INTO soy_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Setɑni uú hɑ kei u peikɛɛ siyɑ́ɑ ɑfɛɛnɑ. Úu siyɑ́ɑ sɛ̃ kɛ́mɛɛ líkɑ li. Lɛ̃ mɛmɑ́ɑ́ nkṹ nn u wɑi. ");
INSERT INTO soy_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Setɑni uu pɛɛ u mɑɑ rɛ: Pɔn Uléécɑɑ Kɛpipi, ɑ rinɔ́ɔ ripɑrɛ ntí hɛ rikɛ́ ripɔ́lɔ́ kukpɔ́nɔ́. ");
INSERT INTO soy_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yeesu uu rinɔ́ɔ ku yɔ́su rɛ: Li rítɛlɛ́-i wɔ́lɑɑlɛ̃ tɛ: Ái ilukɛ ŋmɑnɛ yɛɛ yɛ usoi nfɑ́ɑ hɛ. ");
INSERT INTO soy_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Setɑni uú nɛ kɛlõ cɑ́cɑ́ u sĩ, uu mɛyéne mɛsɛ kɛtẽ nnɛ́í ɑyɔɔpiyu u nyísɛntɛ ");
INSERT INTO soy_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","uu u mɑɑ rɛ: Nɛ́ ɑyɔ́ɔpiyu nnyɛ́ nnɑŋɛ nɛ ɑmmulɛ pɔ́ hɛ. Anɛ́nípɛ-i kɑpi lɛ̃ nnɛ́í wɑ, nɛ́ fe ɑḿ uyɛ̃ kɑm ń lɑ hɛ. ");
INSERT INTO soy_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Pɔn nɛ́ rinwulɑ ɑɑ nɛ́ yɑ́ɑ́si, lɛ̃ nnɛ́í yɛ́ lipɔ́kɔ́ wɑ. ");
INSERT INTO soy_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yeesu uu rinɔ́ɔ ku yɔ́su rɛ: Li rítɛlɛ́-i wɔ́lɑɑlɛ̃ tɛ: Upíimɑ mɛcirɛ kóló kɑí nɛ sɑ́ rɛ usoi ukɛ́ riwulɑ ukɛ́ yɑ́ɑ́si. ");
INSERT INTO soy_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Kuníri ɑku lɛ̃ mɛmɑ́ɑ́ u kpɑ́ú nɛ Yerusɑlɛm-pɔ, ɑkú hɑ Uléécɑɑ kɛyɔ kɛcɑ́ɑ́ u tɔsi, ɑku u mɑɑ rɛ: Pɔn Uléécɑɑ Kɛpipi, ɑ kɛcɑ́ɑ́ nkɛ́-i mɛpɔ́círɛ risɑ́pɔ. ");
INSERT INTO soy_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Likumúŋɛ́ rɛ li rítɛlɛ́-i wɔ́lɑɑlɛ̃ tɛ: Uléécɑɑ yɛ́ upitumɛ rinɔ́ɔ hɛ ");
INSERT INTO soy_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Api pɔ́ yéu kupɔ́nɑ ɑ́ku kɑpɛ nɛ ripɑrɛ rinyinɛ rinkpɔ́u nnyɑ. ");
INSERT INTO soy_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yeesu uu rinɔ́ɔ u yɔ́su rɛ: Li rítɛlɛ́-i wɔ́lɑɑlɛ̃ tɛ: Kɑpɛ Upíimɑ Upɔ́léécɑɑ peikɛɛ pɔkɛ́ ukɛtɔ yɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Kɛ Setɑni uu mɛ́wee mpehẽ mpehẽ nɛ Yeesu m peikɛɛ, uu lɛ̃ mɛmɑ́ɑ́ nɛ kɛtɑɑ u wɑi un nɛ kɛpolɛ kɛcɔ mɛ̃́. ");
INSERT INTO soy_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yeesu uu Kɑlilee kɛtẽ pɛlɛ. Nfɑ́ɑsɔnɛ nnɑŋɛ nn ukɛcɑ́ɑ́ we. Urinyiri ɑri kɛtẽ kɛ̃ nnɛ́í kɔ́ɔ́nú. ");
INSERT INTO soy_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Uu ɑyómɛyɑ́hɑɑlee-i n céési, ḿpɑ́ úye un ríyu u wɑisɛ. ");
INSERT INTO soy_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yeesu uu Nɑsɑrɛti-i kɑpí pɛɛ u rimmúlú uú hɑ nɛ pɑpisi pɛlɛ. Uu kɛwéntɛyɑɑ tuŋɛ́ kuyómɛyɑ́hɑɑlee-i loni yɑrɛ kuu yɛ n lõ mɛcɔ. Uu yisi rɛ ukɛ́ Nléécɑɑsimɛ́ kɛ́ɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Api ɑntepu Esɑyi ritɛlɛ́ u múísɛ. Uu ripínnɛ uu yɛ́nu kei kɑi n wɔ́lɑɑlɛ̃ tɛ: ");
INSERT INTO soy_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Upíimɑ Nfɑɑsɔnɛ yɛ kɛnɛ́mɛɛ welɛ. U nɛ́ wɛ́ɛlɛ rɛ kɛ́ pɛpɛɛ nɛ mpɔ́ɔcɑɑi n tṹ ncɔ́ŋ pi lesɛ kɛ́ kɔ píwɛkɔɔ́ Nsímɛ́ Kɛcirɛ riyóó, kɛ́ pikpɑniikɔ́ símisi rɛ pi yɛ́ ɑkpɑnii kɛ́mɛɛ pi lesɛ, ɑm kɔ pinyíyɛ símisi rɛ pi yɛ́ kɑm ɑpi yɛ yɛnu. Am pɛ̃ kɑpi íwɛ n wɑi ŋmɛ́hɛrɛɛsɛ ");
INSERT INTO soy_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","tɛ kɛ́ kuŋmɛ̃ kpɛ̃ kɛ Upíimɑ uu uipɛɛlɛ́ɛ n nyísɛnɛ nkɔ́ símisi. ");
INSERT INTO soy_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yeesu uu lɛ̃ mɛmɑ́ɑ́ rítɛlɛ́ pílɛsi uu ukɛikɔ́ ri múísɛ uú tonɛ. Pisoi pɛ̃ nnɛ́í pɛɛ kuyómɛyɑ́hɑɑlee-i ń we ɑpi inípɛɛ u wii. ");
INSERT INTO soy_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Uu pɛɛ pi mɑɑ rɛ: Nléécɑɑsimɛ́ mmú kɑni nní n kṍ, nɛni kɛ rinɔ́ɔ tɛ̃ ɑri li. ");
INSERT INTO soy_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Anɔ́ɔ nyɛ̃ kɛ Yeesu uu m mɑ́ikɛɛ ɑɑ ḿpɑ́ úye loni, ɑi pírí pi wɑi kuú nɛ nsímɛ́ sɔnɛ mmú n símisi, ɑpi yɛ pɛɛ mɑɑ rɛ: In nɛ Yosɛfi Kɛpipii? ");
INSERT INTO soy_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yeesu uu pi mɑɑ rɛ: Nɛ nyu rɛ nɔ́ kɛnyɑ́rũ kɛɛ n tee rɛ “Upɔisɛ, ɑ mɛpɔ́círɛ pɔisɛ” nɛ́ mɑlɛ. Nɔ́ kɔ nɛ́ mɑɑ rɛ: Tɔ konlɛ lɛ̃ nɛ lɛ̃ kɑɑ Kɑpɛrinɑwum-pɔ n wɑpisi. A kɔ limɛcɔ kupɔ́yu-i wɑpisi. ");
INSERT INTO soy_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Uu lɛ̃ mɛmɑ́ɑ́ kpɑ́ rɛ: Asei kɑm nɔ́ símisinɛ: Ápi yɛ ɑntepu úkɑ kusɑ́nɛ yɔsí ukuyu cirɛ-i. ");
INSERT INTO soy_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Asei kɑm nɔ́ símisi, pikúmɑnnɔsi yɛ pɛɛ Elii kumúŋɛ́ piyɛlɛ Isirɑyɛɛli-i, kɛ nkpei nn n wɑ ɑŋmɛ̃ ɑtɑɑni nɛ kuwɛ́lɛ́ kumúŋɛ́, nkṹ píimɑ nn kuyu nnɛ́í loni. ");
INSERT INTO soy_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Uléécɑɑ úu pikúmɑnnɔsi pɛ̃ unyinɛ kɛ́mɛɛ Elii tũ, insɑ́ uyɛɛ Sitɔɔ kɛtẽ kɛ́mɛɛ Sɑrɛpitɑ-pɔ ń we. ");
INSERT INTO soy_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Piyɔ̃́ yɛ kɔ pɛɛ kulúi welɛ Isirɑyɛɛli-i ɑntepu Elisee kumúŋɛ́, ḿpɑ́ nɛ lɛ̃, piukɑ úu wolɛ ukɛ́ fũ, insɑ́ Sirii ukɔ́ Nɑɑmɑ mɛcirɛ. ");
INSERT INTO soy_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Kɛ pɛ̃ nnɛ́í pɛɛ kuyómɛyɑ́hɑɑlee-i ń we ɑpi lɛ̃ n kṍ, kuwɔ́i ɑku pi wɑi. ");
INSERT INTO soy_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Api yisi ɑpi u tɔrɔi ɑpí nɛ kuyu lelu, ɑpí nɛ rikúú tɛ̃ kɛcɑ́ɑ́ kɛ pikuyu ɑku m mɔ́mɑɑlɛ̃ tɑɑ́ rɛ pikɛ́ hɑ kei-pɔ u rilɑ́umɛ. ");
INSERT INTO soy_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Amɑ́ uu nnɑ́nnɑ́ri wɑi uu pikɛpɑ́ɑ́pɑ́ɑ́ tiki uu tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yeesu uu pɛɛ Kɑlilee kɛtẽ kɛ́mɛɛ Kɑpɛrinɑwum-pɔ sĩ. Uu kɛwéntɛyɑɑ kɛtúŋɛ́ pisoi Nléécɑɑsimɛ́ céési. ");
INSERT INTO soy_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Umɛcélɑɑ yɛ pɛɛ pírí pi welɛ, liriyíkí rɛ u céésilɛ nɛ ńnɑŋɛ. ");
INSERT INTO soy_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Kuyómɛyɑ́hɑɑlee kɛ́mɛɛ, unírihélɑɑ unyinɛ un we. Uu pipupukɛɛ kɑ́pɑ́ɑ́. ");
INSERT INTO soy_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Ah! Ń-ye kɑɑ́ nɛ rɔ́ wɛ́ɛ́si, Nɑsɑrɛti ukɔ́ Yeesu? Pɔ kɑlɛ rɛ pɔkɛ́ rɔ́ nɑ̃́ɑ? Nɛ pɔ́ nyulɛ rɛ Uléécɑɑ yɛ pɔ́ wɛ́ɛlɛ uu iyɑɑ yekei. ");
INSERT INTO soy_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yeesu uú nɛ ku cɛ́si uu ku mɑɑ rɛ: A risɛ́ɛ́ ɑɑ usoi uyɛ̃ kɛ́mɛɛ́ lelu. Kuníri ɑku pisoi kɛcɔpɛ kɛtẽ u tɑpu ɑku pɛɛ ukɛmɛɛ́ lelu ɑ́ku líkɑ u wɑ. ");
INSERT INTO soy_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ai pinnɛ́í nnɔ́ɔ yipu ɑpi pimɛcɔpɛcirɛ m mɑ́ikɛɛnɛ rɛ: kpí! Nsímɛ́ ń-ye mpuri yɛ mmú? Usoi nkó yɛ ɑníri rinɔ́ɔ hɛlɛ nɛ ńnɑŋɛ ɑɑ́ lelu. ");
INSERT INTO soy_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Api Yeesu rinyiri nɛ kɛtẽ kɛ̃ nnɛ́í kɔ́ɔ́nú. ");
INSERT INTO soy_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yeesu uu Pisuifi kuyomɛyɑ́hɑɑlee-i léeri uu Simɔɔ kɛyɔ sĩ, Simɔɔ ulɔ́hɔ́ni ipiŋɛ in mɛyɑ̃́ tolú lin u pɛkɛsi. Apí nɛ Yeesu téni rɛ ukɛ́ u pɔisɛ. ");
INSERT INTO soy_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Uu ukɛcɑ́ɑ́ pɛ, uu kupiŋɛtoi rinɔ́ɔ hɛ nɛ kuwɔ́i, kupiŋɛtoi ɑku u kpɑ̃́ii, uu mɛsɛ nɛ mɛsɛ yisi uu pikɛcɑ́ɑ́ pɑí. ");
INSERT INTO soy_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ituŋɛ mɛlólɛ́-mɑɑ́, pɛ̃ nnɛ́í pɛɛ itói ncɔpuri pitoikɔ́ m mɑ́ ɑpí nɛ Yeesu pi lɛɛpɔ. Uu ḿpɑ́ úye kɛcɑ́ɑ́ ɑnípɛ lɑɑ uu pi péisɛ. ");
INSERT INTO soy_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Aníri ɑɑ kɔ pisoi mɛyɑ̃ kɛ́mɛɛ́ lelu ɑn pupukɛɛ rɛ: Pɔ́ɔ Uléécɑɑ Kɛpipi. Amɑ́ Yeesu uú nɛ ɑ cɛ́si uu nsímɛ́ nɛ ɑ yulu, ɑníri ricuruu yɛ nyu rɛ Yeesu kɛ Uléécɑɑ uu wɛ́ɛ. ");
INSERT INTO soy_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Kɑi n weesi, Yeesu uu kuyu lelu uu kei kɛ úkɑ úu ń we sĩ. Tisoiwuí ɑri piwɛ́lɑɑ u loni. Kɑpi u n lɛɛpɔ, ɑpí n lɑ yɑrɛ ukɛ́ pikɛkúrí n we, úu kɑpɛ pi riyɑ́. ");
INSERT INTO soy_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Amɑ́ Yeesu uu pi mɑɑ rɛ: Li pisɛ rɛ kɛ́ Uléécɑɑ iyɔɔpi Nsímɛ́ Kɛcirɛ ɑyu ɑcɔ símisi. Lɛ̃ nnyɑ kɛ Uléécɑɑ uu nɛ́ tummɛ. ");
INSERT INTO soy_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Uu Kɑlilee Pisuifi ɑyomɛyɑ́hɑɑlee-i Nléécɑɑsimɛ́ n símisi. ");
INSERT INTO soy_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Kɛyɑ́ɑ kɛnyinɛ kɛ Yeesu uu Kenesɑrɛti kupiyɛ ritimɛ nyɛnu, pisoi pin u kɑ́lɑɑpɔ rɛ pikɛ́ Nléécɑɑsimɛ́ kutu ricɔ. ");
INSERT INTO soy_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Uu ɑ́ninɔi ɑtɛ́ kuritimɛ yɛnu, pikpíntomɛ́cɔ́pii pin ɑkɛmɛɛ léemɛ ɑpi piɑnyɛŋ́ n hɛɛrɛ. ");
INSERT INTO soy_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yeesu uu kúninɔi kusɛ-i loni ɑí nɛ sɑ́ Simɔɔ kukɔ́. Uu u mɑɑ rɛ ukɛ́ nɛ nkɑ́ripi ritímɛ kɛtɑɑ wɑ. Yeesu uu kúninɔi kɛ́mɛɛ tonɛ uu risoiwuí icélɑɑ koru. ");
INSERT INTO soy_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Kuu nsímɛ́ m mɑsí, uu Simɔɔ mɑɑ rɛ: A nɛ kúninɔi kɛcímɛ́-cimɛ́-mɛ̃ hɑ, nɔ́ nɛ pipɔ́séncɔ ɑni pɛɛ nɔ́ɑnɛ́nyɛŋ́ fóm ɑni ikpíntomɛ́ cɔ́pii. ");
INSERT INTO soy_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simɔɔ uu rinɔ́ɔ u yɔ́su rɛ: Sɑ́ɑ, kɛsinɛ nkɛ́ nnɛ́í kɑri kɛisi ɑ́ri kɔ pɛɛ líkɑ yɛ̃. Amɑ́ kɑi nní pɔ́ɔ rɛ kɛ́ ɑnyɛŋ́ fṍ, nɛ́ fṍ. ");
INSERT INTO soy_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Api ɑnyɛŋ́ fóm ɑpi ikpíntomɛ́ pɑɑ́lɑ íi kumúŋɛ́ mɑ́, ɑnyɛŋ́ ticuruu ɑɑ́ n cɛ́ɛ́rii. ");
INSERT INTO soy_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Api pipisencɔ pɛɛ kúninɔi kucɔ-i ń we séiri rɛ pikɛ́ pi lɛ̃́. Pɛ̃ ɑpí hɑpɔ ɑpi ɑ́ninɔi kɛtɛ́ ikpíntomɛ́ yipu, ɑ́ninɔi ricuruu ɑn lɑ ɑkɛ́ mirii. ");
INSERT INTO soy_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Kɛ Simɔɔ Piyɛɛ uu lɛ̃ n yɛ̃́, uu Yeesu kɛyu-i wúlɑ uu rɛ: Upíimɑ, ɑ nɛ kɛtɑɑ nɛ́ wɑ, nɛ ukópɛkɔɔ́ lɛ! ");
INSERT INTO soy_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Iwɑmɛ yɛ Simɔɔ nɛ pɛ̃ ticuruu pɛɛ ukɛkúrí ń we wɑlɛ, ikpíntomɛ́ píimɑ iyɛ̃ kɑpi kɛyɑ́ɑ kɛ̃ n cɔ́pii nnyɑ. ");
INSERT INTO soy_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Lɛ̃ cirɛ kɑi kɔ Simɔɔ pisencɔ Yɑkupu nɛ Yohɑni nɛ Sepetee sipipi wɑ. Amɑ́ Yeesu uu Simɔɔ mɑɑ rɛ: Iwɑmɛ íi kɑpɛ pɔ́ wɑ. Kɑí nɛ nɛni rimpɑ́, nɛ́ tíyɛsɛ ɑɑ pisoi pɛɛ yɛ́ nɛ́ rintíki wɛ́ɛ́si. ");
INSERT INTO soy_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Api pɛɛ piɑninɔi nɛ kɛtẽ-mɛ̃ sĩ, ɑpi ḿpɑ́ yo yɑ́ ɑpi Yeesu tiki. ");
INSERT INTO soy_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Kɛ Yeesu uu kuyu kunyinɛ-i ń we, utisi unyinɛ yɛɛ kɛyɔ̃́ m pɔ́ɔ́lú uú hɑpɔ. Kuu Yeesu n yɛ̃́, uu kɛteni-i pɑ uu kɛ́yu kɛtẽ tuhu uú nɛ u téni rɛ: Upíimɑ, pɔn n lɑ, pɔ́ nɛ́ wolɛ ɑm funi. ");
INSERT INTO soy_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yeesu uu kunípɛ sɑɑpɔ uu u cɑ uu rɛ: Nɛ lɑlɛ, ɑ peí! Kɛyɔ̃́ ɑkɛ mɛsɛ nɛ mɛsɛ tɛnɛ. ");
INSERT INTO soy_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yeesu uu rinɔ́ɔ u hɛ rɛ: Kɑpɛ úkɑ nsímɛ́ mmú símisi. Amɑ́ ɑ hɑ mɛpɔ́círɛ uyɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ nyísɛ ukɛ́ yɛ̃́ lɛ̃ kɑɑ ń we, ɑɑ limɛmɑ́ɑ́ ihɛɛ hɛ ɑɑ́ nɛ mɛpɔ́círɛ nyɔ́ɔnsɛ yɑrɛ kɑi Moisi isé kɛ́mɛɛ m pisɛ, ḿpɑ́ úye ukɛ́ yɛ̃́ tɛ pɔ peí. ");
INSERT INTO soy_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Yeesu rinyiri ɑri pɛɛ kumúŋɛ́ kpɛ-i kuyu n kɔ́ɔ́núlɛ̃ hɑ́i, ɑsoiwuí ɑɑ yɛ u kɑ́lisi ɑkɛ́ unsímɛ́ kutu ricɔ ukɛ́ kɔ nɛ ɑitoi ɑ pɔisɛ. ");
INSERT INTO soy_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Amɑ́ Yeesu uu yɛ kei kɛ pisoi ɑ́pi ń we sĩ uú hɑ kɛyómɛ yɑ́ɑ́si. ");
INSERT INTO soy_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Kɛyɑ́ɑ kɛnyinɛ kɛ Yeesu uú we un pisoi céési. Pifɑrisi nɛ pɛpɛɛ isé n nyu pin ukɛkúrí tṹ. Kɑlilee nɛ Yutee sitẽ ɑyu-i nɛ Yerusɑlɛm kɑpi léenti. Upíimɑ nnɑŋɛ yɛ pɛɛ Yeesu kɛcɑ́ɑ́ welɛ, un nɛ pisoi pɔisɛntɛ. ");
INSERT INTO soy_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Pisoi pinyinɛ ɑpí hɑpɔ pin kɛ́kɑnkɑ́lɑ́kɑ́ risɑ́ŋɑ́ɑ́pɔrɛ́ wɑilɛ̃. Api wɛ́ɛ́si lɛ̃ kɑpi yɛ́ nɛ kɛ́yɔ kɛ-i n lompɔ pikɛ́ Yeesu kɛyu-i kɛ yekei. ");
INSERT INTO soy_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Amɑ́ ɑ́pi ceri mɛ̃ kɑpi yɛ́ nɛ kɛ n lompɔ, kɛ pisoi ɑpi kulúi n tɔsí nnyɑ. Apí nɛ itúhɑɑ kɛcɑ́ɑ́ kɛ tɑɑ́, ɑpi itúhɑɑ péré, ɑpí nɛ risɑ́ŋɑ́ɑ́pɔrɛ́ tɛ̃ pisoi pɛɛ n cɑ́pinɛlɛ̃ kɛcɔpɛ Yeesu kɛyu-i cɛ́pisɛpɔ. ");
INSERT INTO soy_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Kɛ Yeesu uu pinfɑtɛnɛ n yɛ̃́, uu utóikɔ́ mɑɑ rɛ: Nɛ ɑpɔ́kópɛ pɔ́ sɑ́rɛi. ");
INSERT INTO soy_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Isé picélɑɑ nɛ Pifɑrisi ɑpi kɛmúŋɛ́ loni, pin tee rɛ: Usoi úye kɛcirɛ yɛ nkó un Uléécɑɑ lɑ́misi? Wóo yɛ́ fe ukɛ́ ɑkópɛ sɑ́rɛi? Uléécɑɑ mɛcirɛ yɛɛ yɛ́ fe. ");
INSERT INTO soy_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yeesu uu pinfɑsimɛ́ cérupɔ uu pi mɑɑ rɛ: Yo nnyɑ kɑni nfɑsimɛ́ mmú mpuri mɑ́? ");
INSERT INTO soy_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Anɔ́ɔ nnyɛ́ kɛtɛ́ kɛcɔpɛ, ríye tɛɛ fɑ́kú nɛ ricɔ. Kɛ usoi uu yɛ́ kɛ́kɑnkɑ́lɑ́kɑ́ ḿ mɑɑ rɛ: Nɛ ɑpɔ́kópɛ pɔ́ sɑ́rɛi nɛ́ɛ kuu yɛ́ kɛ ḿ mɑɑ rɛ: A yisi ɑ sɔ́nɛ? ");
INSERT INTO soy_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Nɛ lɑ pɔkɛ́ céri rɛ Usoi Kɛpipi yɛ kɛtẽ kɛcɑ́ɑ́ ńnɑŋɛ mɑ́lɛ kɛkɛ́ nɛ pisoi ɑkópɛ pi sɑ́rɛi. Uu pɛɛ kɛ́kɑnkɑ́lɑ́kɑ́ rinɔ́ɔ hɛ rɛ: A yisi ɑ ripɔ́sɑ́ŋɑ́ɑ́pɔrɛ́ pílɛsi ɑɑ́ kulu. ");
INSERT INTO soy_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Mɛsɛ nɛ mɛsɛ, usoi uu ḿpɑ́ úye kɛyu-i yisi uu risɑ́ŋɑ́ɑ́pɔrɛ́ tɛ̃ kɛ́mɛɛ kɑpí pɛɛ u n finsɛlɛ̃ sɑkɑɑ, uu nkúlɛcee pɔlɔ un Uléécɑɑ rinyiri tɑɑ́sɛlɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ai ḿpɑ́ úye nnɔ́ɔ yipu. Api Uléécɑɑ rinyiri tɑɑ́sɛ, iwɑmɛ ii pi súúni pin tee rɛ: Tɔ nɛni mɛwɑi kɛcirɛ yɛ̃! ");
INSERT INTO soy_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Lɛ̃ mɛmɑ́ɑ́, Yeesu uu léeri, uu ulɑmpooyɔɔ́ unyinɛ kɑpi yɛ n sée rɛ Lefi yɛnu un lɑmpoo kɛyɔ́ɔ-i tṹ. Yeesu uu u mɑɑ rɛ: A nɛ́ ritiki. ");
INSERT INTO soy_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lefi uu yisi uu linnɛ́í yɑ́ uu u tiki. ");
INSERT INTO soy_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lefi uu limɛmɑ́ɑ́ ilukɛ kɛcirɛ ukɛyɔ-i u wɑi. Pilɑmpooyɔɔ́ mɛyɑ̃ nɛ pisoi picɔ pin kɛsẽ́ kɛlukɛ kɛ-i we. ");
INSERT INTO soy_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ái nɛ Pifɑrisi nɛ isé picélɑɑ risɑ́, ɑpi Yeesu pipirɛtiki mɑɑ rɛ: Yo nnyɑ kɛ nɔ́ nɛ pilɑmpooyɔɔ́ nɛ pikópɛkɔɔ́ ɑni kɛsẽ́ le? ");
INSERT INTO soy_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yeesu uu rinɔ́ɔ pi yɔ́su rɛ: Pisoi pɛɛ isɑrɛ n lɑ́ɑ́rú ɑ́pi upɔisɛ pisɛ, ɑmɑ́ pitóikɔ́ pɛɛ upɔisɛ pisɛ. ");
INSERT INTO soy_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ám kɑ rɛ kɛ́ pisoi pɛɛ ɑsei n tíkilɛ̃ sée, ɑmɑ́ pikópɛkɔɔ́ nnyɑ kɑḿ kɑ rɛ pikɛ́ pimɛfinɛ consɛ. ");
INSERT INTO soy_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Pisoi pinyinɛ ɑpi Yeesu mɑɑ rɛ: Yo nnyɑ kɛ Yohɑni pipirɛtiki nɛ Pifɑrisi ɑpi yɛ ɑnɔ́ɔ pɑɑsi ɑpi yɛ kɔ kɛyómɛ yɑ́ɑ́si ḿpɑ́ píyei. Amɑ́ pɔ̃́ pipirɛtiki pin le pin kɔ níru? ");
INSERT INTO soy_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yeesu uu rinɔ́ɔ pi yɔ́su rɛ: Nɔ músu rɛ usoi yɛ́ unɔ́si kpísi un we, upisɑnɛ ɑpi pɛɛ ɑnɔ́ɔ pɑɑsii? Aɑi, mmɛ̃ ńn we. ");
INSERT INTO soy_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Li yɛ́ kɑm ɑpi kumúŋɛ́ kunyinɛ-i unɔ́sikɔ́ uyɛ̃ pikɛcɔpɛ lesɛ ɑpí nɛ tɔ́mpɔ. Pɛɛ́ uyɛ-i kɑpi yɛ́ pɛɛ ɑnɔ́ɔ pɑɑsi. ");
INSERT INTO soy_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yeesu uu kɛnyɑ́rũ pimɑ́ɑ pi kpɑ́ rɛ: Úkɑ úu yɛ kusɑ́ŋɑ́ɑ́ fɑlɛ kɛpɑmpi nɛ kusɑ́ŋɑ́ɑ́ kpurɛ tɑ́pisi. Lin lɛ̃ n wɑ, kusɑ́ŋɑ́ɑ́ fɑlɛ kuu lɛ̃ ticɛɛ́ri, kɛpɑ́mpi kɛ̃ kuu n lésɛ ɑ́kɛ kɔ kukpurɛ kɛ́mɛɛ wɑinɛ. ");
INSERT INTO soy_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Úkɑ úu yɛ pítɑ pelẽ kukónɛnuŋ́ kpurɛ-i súũ. Lin lɛ̃ n wɑ, pítɑ pɛ̃ nɛ yɛ ɑnúŋ́ tikpɑ́fúsɛlɛ, ɑi wɑi pítɑ nɛ liɑnúŋ́ yɛ mɛ́woo wɑ. ");
INSERT INTO soy_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Amɑ́ ɑnúŋ́ fɑlɛ-i kɑpi yɛ pítɑ pelẽ súũ. ");
INSERT INTO soy_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Úkɑ úu yɛ kɔ pítɑ fɑlɛ kɑ́ipi un pipelẽ pinírɛ́ m mɑsí. Pi yɛ rɛ pipelẽ pɛɛ pikɛcirɛ. ");
INSERT INTO soy_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Kɛwéntɛyɑɑ tuŋɛ́ kɛnyinɛ kɛ Yeesu uu kɛcɑrɛ kɛ́mɛɛ sɔ́nɛ un tɔ́su. Upipirɛtiki ɑpi mɛpipi n kpééni pin piɑnipɛ-i tɛkɛisɛ pin tɑkɑi. ");
INSERT INTO soy_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Pifɑrisi pinyinɛ ɑpi pi mɑɑ rɛ: Yo nnyɑ kɑni lɛ̃ kɛ isé ii ḿ mɑɑ rɛ pisoi ɑ́pi kɑpɛ yɛ kɛwéntɛyɑɑ kɛtúŋɛ́ wɑ wɑi? ");
INSERT INTO soy_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Kei kɛ Yeesu uu pɛɛ pi pɛsɛ rɛ: Lɛ̃ nnyɑ ɑ́ni lɛ̃ kɛ Tɑfiti uu kumúŋɛ́ kpɛ-i kɛ nkṹ nn u nɛ upikɔ́ n wɑ kɛɛnlɛ̃, nɛ́ɛ yo? ");
INSERT INTO soy_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","U Uléécɑɑ kɛyɔ-i lonlɛ uu ɑkpɔ́nɔ́ kɑpi Uléécɑɑ n yekei kpísi uu le, uu kɔ upikɔ́ pɑ, lin kɔ nɛ irɔ́sé-i wɔ́lɑɑlɛ̃ tɛ pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ ŋmɑnɛ pɛɛ yɛ́ fe ɑpi ɑ le. ");
INSERT INTO soy_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yeesu uu kɔ pimɑ́ɑ pi kpɑ́ rɛ: Nɛ̃́, Usoi Kɛpipi, nɛ́ɛ kɛwéntɛyɑɑ ute. ");
INSERT INTO soy_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Kɛwéntɛyɑɑ kɛtúŋɛ́ kɛcɔ kɛnyinɛ, Yeesu uu kuyómɛyɑ́hɑɑlee kunyinɛ-i loni un pisoi céési. Uu kei utisi unyinɛ lɛɛpɔ nɛ kunípɛ lukɛ-lukɛ kópɛ. ");
INSERT INTO soy_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Isé picélɑɑ nɛ Pifɑrisi ɑpi Yeesu kutu n cɔlɛ̃ pikɛ́ yɛ̃́ in tɛ u yɛ́ kɛwéntɛyɑɑ kɛtúŋɛ́ usoi pɔisɛ, likumúŋɛ́ rɛ pi pɛɛ kɛwɑ́ɑ́nɑ́ wɛ́ɛ́silɛ pikɛ́ nɛ ɑkópɛ u n lɑpɑɑsɛ. ");
INSERT INTO soy_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Amɑ́ Yeesu yɛ pɛɛ pinfɑsimɛ́ cérilɛ. Uu unípɛkópɛkɔɔ́ mɑɑ rɛ: A yisi ɑ nyɛrɛ ḿpɑ́ úye ukɛ́ pɔ́ yɛ̃́. Utisi uu yisi uu nyɛrɛ. ");
INSERT INTO soy_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yeesu uu pɛɛ pi mɑɑ rɛ: Nɛ nɔ́ pisɛ rɛ íye kɑi irɔ́sé kɛ́mɛɛ pisɛ? Li pisɛ rɛ tɔkɛ́ kɛwéntɛyɑɑ kɛtúŋɛ́ lisɔnɛ nɛ́ɛ likópɛ wɑ? Tɛ tɔkɛ́ usoi nfɑɑ lɔ nɛ́ɛ tɔkɛ́ u kpu? ");
INSERT INTO soy_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Uu pinnɛ́í nyɑ́nɛi uu pɛɛ limɛmɑ́ɑ́ usoi uyɛ̃ mɑɑ rɛ: A kupɔ́nípɛ rituŋɑ́mɛ. Uu kunípɛ tuŋɑ́pɔ, kunípɛ ɑku pélu. ");
INSERT INTO soy_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Amɑ́ ɑi mpí pɔ̃́ tóósi ɑpi pimɛcɔpɛcirɛ n kɛŋɛnɛ pin lɛ̃ kɑpi yɛ́ nɛ Yeesu n wɑ tɑikɛɛ. ");
INSERT INTO soy_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Yeesu uu likumúŋɛ́ kpɛ-i kɛkúúpi tɑɑ́ rɛ ukɛ́ kɛyómɛ yɑ́ɑ́si. Kɛsinɛ nnɛ́í kuu kei tonɛ un Uléécɑɑ yɑ́ɑ́si. ");
INSERT INTO soy_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kɑi n weesi, uu upipirɛtiki séi, uu pikɛcɔpɛ kɛfi nɛ pitɛ́ wɛ́ɛ uu pi séi rɛ pitumɛ. ");
INSERT INTO soy_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Pɛpɛɛ Simɔɔ kuu rinyíri n hɛ rɛ Piyɛɛ nɛ uyɛ̃ uwɑ̃ Antiree nɛ Yɑkupu nɛ Yohɑni nɛ Filipu nɛ Pɑtelemii ");
INSERT INTO soy_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","nɛ Mɑtiyee nɛ Tomɑɑ, nɛ Alifee kɛpipi Yɑkupu nɛ Simɔɔ yɛɛ ukuyu ń lɑ ");
INSERT INTO soy_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","nɛ Yɑkupu kɛpipi Yutɑsi Isikɑriyɔɔti yɛɛ ń kɑ uu kɛpirɛ Yeesu yɑ́i. ");
INSERT INTO soy_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yeesu nɛ upipirɛtiki ɑpi kɛkúúpi cɛpimɛ ɑpi kutẽ mmɛ́ weri, kei kɛ upipirɛtiki mɛyɑ̃ ɑpi ń we. Yutee kɛtẽ nnɛ́í pisoi mɛyɑ̃ pin kɔ kei we, nɛ Yerusɑlɛm pikɔ́ nɛ Tiiri nɛ Sitɔɔ mɛnimɑɑ ritimɛ ɑyu pikɔ́. ");
INSERT INTO soy_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Pi cɑ́pinɛmɛlɛ pikɛ́ Yeesu icélɑɑ kutu ricɔ, ɑpi kɔ piitoi pi pɔisɛ. Pɛ̃ kɛ ɑníri ɑɑ m pɛkɛsi ɑpi pélu. ");
INSERT INTO soy_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ḿpɑ́ úye uu nɑ́ɑ́si ukɛ́ u ricɑ, liriyíkí rɛ u pɛɛ ńnɑŋɛ nnyinɛ mɑ́lɛ un nɛ pinnɛ́í pɔisɛntɛ. ");
INSERT INTO soy_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yeesu uu upipirɛtiki inípɛɛ wii uu rɛ: Nɔ́ mpí nɔ́ɔ nní íwɛ m mɑ́, nɔ pínɑrɛkomɛ lɛ. Nɔ́ɔ Uléécɑɑ iyɔɔpi te. ");
INSERT INTO soy_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Nɔ́ mpí nɔ́ɔ nní nkṹ n tṹ, nɔ pínɑrɛkomɛ lɛ, nɔ kɛyɑ́ɑ lɛpunɛ. Nɔ́ mpí nɔ́ɔ nní n téni, nɔ kɛyɑ́ɑ sɛ́nnyinɛ. ");
INSERT INTO soy_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","In tɛ pisoi yɛ nɔ́inɛ́puri yulu, ɑpi nɔ́ lɑ́kɑsɛ, pin lɑ́misi pin kɔ nɔ́nnɛ́kópɛ símisi rɛ nɔ Usoi Kɛpipi nɛ kɛfɑ tɛnɛ nnyɑ, nɔ pínɑrɛkomɛ lɛ. ");
INSERT INTO soy_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Tikpɑ́kɑ́rɑ́ tɛ̃ ticɔ kɛ pipisɑɑ ɑpí pɛɛ ɑntepuyɛ wɑ. In tɛ lɛlɛɛ nɔ́ lɛɛmɛ, nɔ́rinɛ́pɔ́ɔ rikɛ́ n lɑ́ɑ́rú, ɑni nɛ mpɔ́ɔnɑrɛ cɔ, nɔ́inɛ́hɛɛ yɛ kɛyómɛcɑɑ-pɔ piyɛlɛ ɑ́i kumúŋɛ́ mɑ́. ");
INSERT INTO soy_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Amɑ́ nɔ́ mpí nɔ́ɔ nní ḿ mɑ́, íwɛ kɑni topori, nɔ nɔ́nnɛ́nɑrɛ pilukɛ mɑsilɛ. ");
INSERT INTO soy_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Nɔ́ mpí nɔ́ɔ nɛni nní n lɛpɑɑlɛ̃, íwɛ kɑni topori, nkṹ yɛ sɔ́ntilɛ nkɛ́ nɔ́ wɑ. Nɔ́ mpí nɔ́ɔ nɛni nní n sɛ́nnyi, íwɛ kɑni topori, nɔ mpɔ́ɔcɑɑi-i loninɛ ɑni ténisi. ");
INSERT INTO soy_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","In tɛ ḿpɑ́ úye yɛ nɔ́nnɛ́sɔnɛ símisi, íwɛ kɑni topori, likumúŋɛ́ rɛ lɛ̃ kɛ pipisɑɑ ɑpí pɛɛ ɑntepuyɛ nɔɔmɛ wɑi. ");
INSERT INTO soy_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Nɔ́ɔ nní kutu nɛ́ n cɔ́lɛ̃, nɛ nɔ́ símisilɛ rɛ ɑni nɔ́pinɛ́lɑ́ɑrɔ n lɑ, ɑni pɛpɛɛ nɔ́ n yúlu lisɔnɛ n wɑi, ");
INSERT INTO soy_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ɑni pɛpɛɛ ɑwééri nɔ́ n wɑi ɑnɔ́ɔ sɔnɛ ritikisɛ, ɑni pɛpɛɛ íwɛ nɔ́ n wɑi kɛcɑ́ɑ́ n welu. ");
INSERT INTO soy_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","In tɛ usoi yɛ kumɔ́rí kusɛ-i kɛpɛsɛ pɔ́ tɔ, ɑ kutɔ́rɔɔ u rituŋɑ́, usoi un kupɔ́kpɛ́lɛnku pɔ́ n yɔsíé, ɑ tíyɛsɛ ukɛ́ kɔ kɛpɔ́túkɑnkɑ tene kpísi. ");
INSERT INTO soy_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ḿpɑ́ úye yɛɛ linyinɛ pɔ́ we ɑ li u hɛ, úye un kɔ lipɔ́kɔ́ linyinɛ pɔ́ n yɔsí, kɑpɛ li u korí. ");
INSERT INTO soy_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Lɛ̃ kɑni ń lɑ picɔ pikɛ́ nɔ́ wɑ, ɑni yɛ limɛcɔ pi wɑ. ");
INSERT INTO soy_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","In tɛ pɛpɛɛ nɔ́ ń lɑ ŋmɑnɛ kɑní lɑ, ihɛ́ɛ́ íye icɔ kɑni pɛɛ mɛ̃́. Pikópɛkɔɔ́ ricuruu yɛ pɛpɛɛ pi ń lɑ lɑlɛ. ");
INSERT INTO soy_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","In tɛ pɛpɛɛ lisɔnɛ nɔ́ n wɑi ŋmɑnɛ kɑni yɛ lisɔnɛ wɑ, ihɛ́ɛ́ íye icɔ kɑni pɛɛ mɛ̃́? Pikópɛkɔɔ́ yɛ̀ɛ̀ kɔ lɛ̃ wɑlɛ. ");
INSERT INTO soy_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","In tɛ nɔ tɑ́lɛ̃ tɛ pɛ̃ kɑni n lonsɛ yɛ́ nɔ́ hɛ́ɛlɛ, ihɛ́ɛ́ íye icɔ kɑni pɛɛ mɛ̃́? Pikópɛkɔɔ́ ricuruu yɛ̀ɛ̀ pikópɛkɔɔ́ lonsɛlɛ pin tɑ́lɛ̃ tɛ pi yɛ́ lɛ̃ kɑpi n lonsɛ ritísí linyinɛ pi hɛ́ɛ́lɛ. ");
INSERT INTO soy_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Amɑ́ nɔ́ɔkɛ́ nɔ́pinɛ́lɑ́ɑrɔ n lɑ, ɑni lisɔnɛ pi n wɑi. Áni kɑpɛ yɛ n tɑ́lɛ̃ tɛ pi yɛ́ nɔ́ hɛ́ɛ́lɛ ɑni kɛlenɛ pi lonsɛ. Nɔ́ ihɛ́ɛ́ kɛcirɛ yɛ̃ ɑni pɔ́lɔ́ Uléécɑɑ yɛɛ ḿpɑ́ yo kɛcɑ́ɑ́ n tṹ sipipi, likumúŋɛ́ rɛ u pɛpɛɛ ɑ́pi rícere m mɑ́ nɛ pisoi kpɑ́kɑ́rɑ́ lɑlɛ. ");
INSERT INTO soy_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ani yɛ nɔ́mɛnɛ́cɔpɛcirɛ íwɛ ténɑɑnɛ yɑrɛ kɛ Nɔ́unɛ́sɑ́ɑ uu yɛ íwɛ nɔ́ n tẽ́ mɛcɔ. ");
INSERT INTO soy_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Áni kɑpɛ yɛ picɔ ɑkópɛ m pɑlɛ̃, Uléécɑɑ úu kɑpɛ kɔ nɛ nɔ̃́ ɑkópɛ m pɑ́lɛ̃ nnyɑ. Áni kɑpɛ yɛ picɔ nɛ túhɑɑnɛ, Uléécɑɑ úu kɑpɛ nɛ nɔ̃́ n túhɑɑnɛ nnyɑ. Ani yɛ picɔ ɑkópɛ pi sɑ́rɛi, Uléécɑɑ uu nɔ́ɑnɛ́kɔ́ nɔ́ sɑ́rɛi. ");
INSERT INTO soy_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ani yɛ picɔ hɛ, Uléécɑɑ uu nɔ́ hɛ. Pi nɔ́ músunɛ ɑi yipu ɑí wurɛ ɑpi tíŋɑ-tiŋɑ ɑpi nɔ́ kópɔ. Kɛmúŋɛ́ kɛ̃ kɑni yɛ nɛ picɔ ḿ musí kɑpi kɔ nɛ nɔ̃́ músunɛ. Ái líkɑ nnyɑ, Uléécɑɑ yɛ músunɛ ɑi yipu uu tíŋɑ-tiŋɑ uu tírii uu nɔ́ kópɔ. Kulũ kpɛ̃ kɑni yɛ nɛ picɔ ḿ musí kucɔ kɛ Uléécɑɑ uu kɔ nɛ nɔ̃́ músunɛ. ");
INSERT INTO soy_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yeesu uu kɔ kɛnyɑ́rũ kpɑ́ rɛ: Unyíyɛ úu yɛ́ fe ukɛ́ unyíyɛcɔ tɔrɔi. Lin lɛ̃ n wɑ, pinnɛ́í yɛ hɑ kuhórɛ-i lóipɔnɛ. ");
INSERT INTO soy_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Uyɛɛ pikɛi m peikɛɛ úu yɛ uyɛɛ pi u m peikɛɛsɛ n fe. Amɑ́ uyɛɛ pi m peikɛɛ un pikɛi n ceri ńsɔnɛ, u nɛ uyɛɛ pi u m peikɛɛsɛ yɛ́ n sɑ́. ");
INSERT INTO soy_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Yo nnyɑ kɑɑ kɛyúipi kɛɛ upɔ́mɑ́rɛcɔ mɛnipɛɛ-i ń we nyɑ́ni ɑ́ɑ pɛɛ kɛnɑwɛlɛ́pi kɛɛ mɛpɔ́kɔ́-i ń we nyɑ́ni? ");
INSERT INTO soy_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Íye kɑɑ yɛ́ fe ɑɑ upɔ́mɑ́rɛcɔ mɑɑ rɛ: Unɛ́mɑ́rɛcɔ, ɑ riyɑ́ kɛ́ kɛyúipi kɛɛ mɛpɔ́nípɛɛ-i ń we lesɛ, pɑ́ɑ pɛɛ kɛnɑwɛlɛ́pi kɛɛ mɛpɔ́nípɛɛ-i ń we lesɛ kɛlenɛ. A tíyɛ pɔ kɛcɑ́ɑ́ kɛcɑ́ɑ́ mɛwɑi mɑ́ kpɑ! Kɛnɑwɛlɛ́pi kɛɛ mɛpɔ́nípɛɛ-i ń we kɑɑ yɛ́ mɛfoí lesɛ ɑɑ pɛɛ ńsɔnɛ n nyɑ́ni ɑɑ́ nɛ kɛyúipi kɛɛ ucɔ mɛnipɛɛ-i ń we lesɛ. ");
INSERT INTO soy_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Kuléé kpɛɛ isɑrɛ n lɑ́ɑ́rú ɑ́ku yɛ ɑpipi kópɛ mɑri, kuléé toikɔ́ ɑ́ku yɛ kɔ ɑpipi sɔnɛ mɑri. ");
INSERT INTO soy_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Pi yɛ ḿpɑ́ kuléé kúye nɛ kuɑpipi cerilɛ. Ápi yɛ sinípɛleépi kɛcɑ́ɑ́ ɑfiiki tɔ, ɑ́pi yɛ kɔ ɑhííhíí kɛcɑ́ɑ́ ɑrɛɛsɛɛ tɔ. ");
INSERT INTO soy_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Lisɔnɛ kɛ usoi sɔnɛ uu yɛ ukɛfɑ-i lésɛmɛ, usoi kópɛ pɔ́ɔ likópɛ ukɛfɑ-i lésɛri, likumúŋɛ́ rɛ lɛlɛɛ usoi kɛfɑ-i n yipɑɑlɛ̃ kɛ nnɔ́ɔ nn yɛ símisi. ");
INSERT INTO soy_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Yo nnyɑ kɑni nɛ́ sélei rɛ Upíimɑ, Upíimɑ ɑ́ni pɛɛ lɛ̃ kɑm nɔ́ n céesi wɑi? ");
INSERT INTO soy_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ani tíyɛ kɛ́ nɔ́ nyísɛ lɛ̃ kɛ uyɛɛ nnɛ́símɛ́ kutu n cɔ́lɛ̃ un nɛ n kɛisi uú nɛ mɛnyínɛ ń we. ");
INSERT INTO soy_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Liute yɛ we yɑrɛ usoi yɛɛ kɛ́yɔ m mɔ́m uu túni ɑi cimisi uu kɛpɑrɛ tulu, uu kɛkɛcɑ́ɑ́ rikúi tɔsi. Kɛ ikói ii n yi ii wɑɑ, míni ɑmɛ kɛ fɛ, ɑmɑ́ ɑ́mɛ kɔ fe mɛkɛ́ kɛ ritiŋɑ-tiŋɑ, likumúŋɛ́ rɛ kɛ mɔmɑɑlɛnlɛ ńsɔnɛ. ");
INSERT INTO soy_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Amɑ́ uyɛɛ nnɛ́símɛ́ kutu n cɔ́lɛ̃ úu pɛɛ́ nɛ n kɛisi yɛ we yɑrɛ usoi yɛɛ kɛ́yɔ m mɔ́m uu ntɑɑi purɛ-purɛ kɛcɑ́ɑ́ kɛ tɔsi, rikúi ɑ́ri we. Kɛ ikói mɛni ɑmɛ kɛ rińfɛ, mɛsɛ nɛ mɛsɛ kɑkɛ tɔhɔ̃ ɑkɛ foru tɛ́kɛ́-tɛ́kɛ́. ");
INSERT INTO soy_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Kɛ Yeesu uu pisoi pɛɛ u n kɑ́lɑɑlɛ̃ ifɑɑci piwɑi ḿ mɑsí, uu yisi uu Kɑpɛrinɑwum tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Rɔm usɔ́ɔ́cɑ kpéẽ unyinɛ yɛ pɛɛ ukɛikɔ́ unyinɛ mɑ́lɛ, úu yɛ uukɛikɔ́ uyɛ̃ kɛcɑ́ɑ́ kṍ. Ukɛikɔ́ uyɛ̃ un pɔ́ɔ́lú, ticuruu un kɛkpɔ nyɑhɑi. ");
INSERT INTO soy_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Kɛ usɔ́ɔ́cɑ kpéẽ uyɛ̃ uu n kṍ pin Yeesu nsímɛ́ símisi, uu Pisuifi piwɛ́ɛ́sɛ tum tɛ pikɛ́ hɑ u séemɛ ukɛ́ uukɛikɔ́ pɔisɛ. ");
INSERT INTO soy_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Api Yeesu kɛ́mɛɛ tuipɔ ɑpí nɛ mɛyɑ̃́ u téni rɛ: Usoi uyɛɛ nɛ sɑ́ rɛ pɔkɛ́ u lɛ̃́. ");
INSERT INTO soy_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","U ntɔ́puri lɑlɛ ńsɔnɛ. Uyɛɛ kɔ kurɔ́yómɛyɑ́hɑɑlee mɔ̃. ");
INSERT INTO soy_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yeesu uu pɛɛ pi tikipɔ. Kuu kɛ́yɔ n nyɑhɑipɔ, usɔ́ɔ́cɑ kpéẽ uu upisɑnɛ tumpɔ rɛ pikɛ́ u mɑɑ rɛ: Upíimɑ, kɑpɛ mɛpɔ́círɛ ricɔ́ŋ. Ám nɛ sɑ́ rɛ pɔkɛ́ kɛnɛ́yɔ lõ. ");
INSERT INTO soy_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nɛ rinɛ́cúruu yɛnlɛ rɛ ɑ́m tu rɛ kɛ́ kɛpɔ́mɛɛ hɑpɔ. Amɑ́ ɑ rinɔ́ɔ hɛ unɛ́kɛikɔ́ ukɛ́ peí. ");
INSERT INTO soy_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nɛ̃́ ticuruu yɛ piwɛ́ɛ́sɛ mɑ́lɛ nɛn pi pɑkɑrɛlɛ̃, nɛn kɔ pisɔ́ɔ́cɑ mɑ́ pɛɛ nɛ̃́ m pɑkɑrɛlɛ̃, nɛn piunyinɛ m mɑɑ rɛ ukɛ́ mɛ́ye hɑ, u yɛ hɑlɛ. Nɛn kɔ ucɔ m mɑɑ rɛ ukɛ́ kɑm, u yɛ kɑlɛ. Nɛn kɔ unɛ́kɛikɔ́ m mɑɑ rɛ ukɛ́ linyinɛ wɑ, u yɛ li wɑlɛ. ");
INSERT INTO soy_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Kɛ Yeesu uu ɑnɔ́ɔ nyɛ̃ n kṍ, usɔ́ɔ́cɑ kpéẽ uyɛ̃ isoi ii u sɔnɛsi. Uu pɑnsɛ uu pisoi kulúi pɛɛ u n tíkilɛ̃ mɑɑ rɛ: Nɛ nɔ́ mɑɑ rɛ ḿpɑ́ Isirɑyɛɛli kɛ́mɛɛ, ɑ́m píkɑi nfɑtɛnɛ mmú ncɔ yɛnɑɑlɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Pɛ̃ kuu n tũ ɑpi kɛ́yɔ-i pɛɛpɔ ɑpi ukɛikɔ́ uyɛ̃ lɛɛpɔ un isɑrɛ lɑ́ɑ́rú. ");
INSERT INTO soy_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Kɑi kóso n weesi, Yeesu uu kuyu kunyinɛ kɑpi yɛ n sée rɛ Nɑini sĩ. Upipirɛtiki nɛ risoiwuí tin u tikilɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Kumúŋɛ́ kpɛ-i kuu kuyu kɛpoo n nyɑhɑipɔ, uu yɛ́nu pin nɛ kɛsoikópɛ pikúlɑɑ tɔ́su. Ukúmɑnnɔsi unyinɛ kɛwɑ̃ cirɛníŋɛ kɑpi lɛ̃ nɛ tɔ́su. Kuyu pikɔ́ kulúi pin nɛ unɔ́si uyɛ̃ tũ. ");
INSERT INTO soy_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Kɛ Yeesu uu u n yɛ̃́, íwɛ ii u wɑi uu u mɑɑ rɛ: Kɑpɛ tẽ́! ");
INSERT INTO soy_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Yeesu uú nyɔsɔ́pɔ uu ɑsoikópɛmulɛ cɑ, pɛpɛɛ n topori ɑpi nyɛrɛ, Yeesu uu rɛ: Kɛŋmɑ́nɛpi, nɛ rinɔ́ɔ pɔ́ hɛ, ɑ yisi! ");
INSERT INTO soy_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Kɛsoikópɛ ɑkɛ cɑ́ŋɑ́rɑ́ɑ́ ɑkɛ nsímɛ́ kɑ́pɑ́ɑ́. Yeesu uu kɛuni kɛ pɑ. ");
INSERT INTO soy_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Iwɑmɛ ii pinnɛ́í loni ɑpi Uléécɑɑ rinyiri tɑɑ́sɛ pin tee rɛ: Antepu píimɑ yɛ kɛrɔ́cɔpɛ rikpɑ́fúmɛlɛ. Uléécɑɑ yɛ kɑlɛ ukɛ́ umpuri comɛ! ");
INSERT INTO soy_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Nsímɛ́ mmɛ̃ nn Yutee kɛtẽ nnɛ́í nɛ kɛmɛkɔ sitẽ kɛ́mɛɛ kɔ́ɔ́nú rɛ lɛ̃ kɛ Yeesu uu wɑ. ");
INSERT INTO soy_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yohɑni pipirɛtiki ɑpi lɛ̃ nnɛ́í u símisi. Yohɑni uu pikɛcɔpɛ pitɛ́ séi, ");
INSERT INTO soy_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","uu Upíimɑ kɛ́mɛɛ pi tum tɛ pikɛ́ hɑ u pisɛ rɛ: Pɔ́ɔ usoi uyɛ̃ kɑpi mɛkɛɛ-mɛ n tee rɛ u sɔ́nti nɛ́ɛ unyinɛ ucɔ yɛ kɛpirɛ wemɛlɛ? ");
INSERT INTO soy_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Kɑpi Yeesu kɛ́mɛɛ n tuipɔ, ɑpi u mɑɑ rɛ: Yohɑni Úniwolɛ yɛɛ rɔ́ tummɛ rɛ tɔkɛ́ pɔ́ pisɛ rɛ: Pɔ́ɔ usoi uyɛ̃ kɑpi mɛkɛɛ-mɛ n tee rɛ u sɔ́nti nɛ́ɛ unyinɛ ucɔ yɛ kɛpirɛ wemɛlɛ? ");
INSERT INTO soy_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Kumúŋɛ́ kpɛ̃ kɛ́mɛɛ, Yeesu un pisoi mɛyɑ̃ itói pɔisɛntɛ, un ɑníri pi pɛ́sɛi un pinyíyɛ mɛyɑ̃ inipɛɛ wúkulɛntɛ. ");
INSERT INTO soy_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Uu pɛɛ Yohɑni pitumɛ mɑɑ rɛ: Ani mpɔ ɑni hɑ lɛ̃ kɑni n yɛ̃́ ɑni kɔ kom Yohɑni kɛɛnkɛɛ: Lɛlɛɛ rɛ pinyíyɛ yɛ nyɑ́nilɛ, síkɑnkɑ́lɑ́kɑ́ sin sɔ́nɛ, piyɔ̃́ pin wolɛ pin funi, pitusuí pin kómɛi, pikpɔkpɔ pin yisikɛɛ, piwɛ́kɔɔ́ pin kɔ Nsímɛ́ Kɛcirɛ kɛ pisoi ɑpi pi n yóólɛ̃ kómɛi. ");
INSERT INTO soy_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Úye unsɑ́ nɛ̃́ nnyɑ n loó, liute yɛ únɑrɛkomɛ lɛ. ");
INSERT INTO soy_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Kɛ Yohɑni pitumɛ ɑpi pitɔ́ŋɛ́ ḿ mɑsí, Yeesu uu Yohɑni nsímɛ́ pisoi pɛɛ n cɑ́pinɛlɛ̃ n símisi rɛ: Yo kɑni kucɛsi kóimɑ-i piyɛ́nɛ hɑ? Kɛkpɑ́pi kɛ kuyɔ ɑku n fíkiisɛɛ, nɛ́ɛ yo? ");
INSERT INTO soy_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Yɑrɛ yo kɑni pɛɛ piyɛ́nɛ hɑ? Usoi yɛɛ mɛlɑpɛ kɛcirɛ n lɑpɑɑlɛ̃ yɛɛ kei we, nɛ́ɛ yo? Amɑ́ siyɔ́ɔpiyɔ-i kɛ pɛpɛɛ ilũ nɛ́íkɔɔ́ n tɑ́nti pin isoi le ɑpí we. ");
INSERT INTO soy_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Yɑrɛ yo kɛcirɛ ŋmɑɑ kɑni pɛɛ piyɛ́nɛ hɑ? Antepu unyinɛ, nɛ́ɛ yo? Amɑ́ ɑsei kɛcɑ́ɑ́ uyɛ̃ kɑni nní ń yɛ̃́ nɛ ɑntepu felɛ. ");
INSERT INTO soy_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Likumúŋɛ́ rɛ Yohɑni nsímɛ́ kɑi Nléécɑɑsimɛ́ ritɛlɛ́-i wɔ́lɑɑlɛ̃ tɛ: Unɛ́tumɛ yɛ nkó kɑm n tummɛ ukɛ́ nɛ kɛkpéẽ pɔ́ wɑ ukɛ́ mpɔ́cée nyɔ́ɔnsɛ. ");
INSERT INTO soy_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yeesu uu pimɑ́ɑ kpɑ́ rɛ: Nɛ nɔ́ símisilɛ rɛ ɑ́pi unyinɛ mɑrɑɑlɛ̃ yɛɛ Yohɑni n fe, ḿpɑ́ nɛ lɛ̃, pɛpɛɛ Uléécɑɑ iyɔɔpi kɛ́mɛɛ ń we kɛcɔpɛ uyɛɛ n fíílɛ̃ yɛ u felɛ. ");
INSERT INTO soy_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Kuyu nnɛ́í nɛ pilɑmpooyɔɔ́ pɛɛ Yohɑni nsímɛ́ kutu rińcɔ ɑpi tíyɛsɛ uu míni pi wolɛ. Pi cerilɛ rɛ Uléécɑɑ yɛɛ ɑsei ute. ");
INSERT INTO soy_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Kɛ Pifɑrisi nɛ pɛpɛɛ Uléécɑɑ isé n nyu ɑpi ń yɛ̀ rɛ Yohɑni úu kɑpɛ míni pi wolɛ, li nyísɛlɛ rɛ lɛ̃ kɛ Uléécɑɑ uú nɛ pi ń lɑ kɑpi kɛpirɛ ritɔ. ");
INSERT INTO soy_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yeesu uu pimɑ́ɑ pi kpɑ́ rɛ: Úye kɑm yɛ́ nɛ nfɑ́ɑni pisoi múŋɛisɛnɛ? Úye kɑpí nɛ mɛnyínɛ we? ");
INSERT INTO soy_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Pi nkpɑ́ni yɑrɛ siwɑ̃́ sɛɛ kɛ́yɑɑ́lɑ-i n tṹ, si nɛ sisicɔ sin séleinɛ ɑsi yɛ rɛ: Tɔ ɑsũ símisilɛ, ɑni yúlu ɑ́ni yesi, ɑri sikpɔyomɛ yom, ɑ́ni tẽ́. ");
INSERT INTO soy_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Likumúŋɛ́ rɛ Yohɑni Úniwolɛ yɛ kɑlɛ úu yɛ ilukɛ li, úu yɛ kɔ pítɑ n ntí, ɑni rɛ u unírihélɑɑ lɛ. ");
INSERT INTO soy_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Usoi Kɛpipi pɔ́ɔ weri kɛn le kɛn níru, ɑni kɔ rɛ: Ani usoi nkó nyɑ́nii, pilukɛ nɛ pítɑ nkɔ́ ŋmɑnɛ mɛɛ uyɛ̃ we. Ticuruu u kɔ pilɑmpooyɔɔ́ nɛ piwɑikópɛkɔɔ́ picɔ usɑnɛ lɛ. ");
INSERT INTO soy_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Amɑ́ pɛpɛɛ u n ŋmurɛi yɛ nyísɛlɛnlɛ rɛ Uléécɑɑ mɛwɛ́ɛ́sɛsɔhɔ yɛ mɛ. ");
INSERT INTO soy_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ufɑrisi unyinɛ uu Yeesu séi rɛ pikɛ́ kɛsẽ́ ilukɛ li. Yeesu uu usoi uyɛ̃ kɛyɔ sĩ uú tonɛ uu le. ");
INSERT INTO soy_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Kuyu kpɛ̃ unɔsi unyinɛ yɛɛ mɛfinɛ kópɛ m mɑ́ un we. Kuu n kṍ tɛ Yeesu yɛ Ufɑrisi uyɛ̃ kɛyɔ-i we un ilukɛ le, uú nɛ kɛnúḿpi nɛ tulɑɑli mɛyipɛ sĩ ");
INSERT INTO soy_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","uu Yeesu kɛpirɛ nyɛrɛ, uɑnɑ-mɛ̃. Uú n téni uu Yeesu ɑnɑ mɛ́nini fɔlu, uu limɛmɑ́ɑ́ nɛ unnyúpi ɑ tinnɛntɛ, uu ɑ pirɑ uu tulɑɑli ɑkɛcɑ́ɑ́ kɔɔni. ");
INSERT INTO soy_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Kɛ Ufɑrisi uyɛɛ Yeesu kusɑ́nɛ n wɑi uu lɛ̃ n yɛ̃́, uu ukɛfɑ-i n tee rɛ: Usoi nkó un pɛɛ mɛsei ɑntepu, u yɛ́ pɛɛ unɔ́si nkó yɛɛ nní u n cɑ́rii ceri rɛ wóo lo, u yɛ́ kɔ pɛɛ céri isoi íye mpuri kuu le. Unɔ́si lo yɛɛ mɛfinɛ kópɛ m mɑ́. ");
INSERT INTO soy_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yeesu uu pɛɛ Ufɑrisi rinɔ́ɔ yɔ́su rɛ: Simɔɔ, nɛ nnyinɛ mɑ́lɛ kɛ́ pɔ́ mɑlɛ. Simɔɔ uu rinɔ́ɔ pɛsɛ rɛ: Sɑ́ɑ, ɑ mɑlɛ. ");
INSERT INTO soy_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yeesu uu rɛ: Pisoi pitɛ́ pɛɛ nɛ uwóólonsɛ riwómɛ mɑ́. Usɛ un nɛ riwómɛ u mɑ́ nwóóweni siwóó pílɛ pílɛ mɛnupũ, ucɔ pɔ́ɔn nɛ riwómɛ u mɑ́ nwóóweni mɛpipi kuwóó. ");
INSERT INTO soy_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Pikɛtɛ́ kɛ̃ úkɑ úu kɔ pɛɛ fenɛ ukɛ́ uriwomɛ hɛ́ɛ́lɛ. Uwóólonsɛ uu pikɛtɛ́ sɑ́rɛi. Pikɛtɛ́ kɛ̃ kɛcɔpɛ úye yɛɛ yɛ́ mɛyɑ́nsei uwóólonsɛ uyɛ̃ n lɑ? ");
INSERT INTO soy_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simɔɔ uu rinɔ́ɔ u yɔ́su rɛ: Nɛ músu rɛ uyɛ̃ tiwomɛ tɛɛ m piyɛ yɛɛ yɛ́ mɛyɑ̃́ u n lɑ. Yeesu uu rɛ: Pɔ ɑlɑri mɑ́lɛ. ");
INSERT INTO soy_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Uu lɛ̃ mɛmɑ́ɑ́ unɔ́si uyɛ̃-mɛ̃ pɑnsɛpɔ, uu Simɔɔ mɑɑ rɛ: Pɔ unɔ́si nkó yɛ̃́ɛ? Nɛ kɛpɔ́yɔ-i lommɛlɛ ɑ́ɑ míni nɛ́ hɛ rɛ kɛ́ ɑnɛ́nɑ rikɛ́, ɑmɑ́ uyɛ̃ nɛ ɑnɛ́nɑ umɛnini fɔilɛ uú nɛ unnyúpi ɑ tinnɛntɛ. ");
INSERT INTO soy_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Áɑ nɛ́ ripirɑ rɛ kusɑ́nɛ kɑɑ nɛ́ yɔ́su, ɑmɑ́ kɑḿ nɛ n lommɛ kuu nní nɛ́ yɑ́hɑɑnkɛɛ uú nɛ ɑnɛ́nɑ tini. ");
INSERT INTO soy_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Áɑ mɛ́kpɔ rinɛ́yu kɛcɑ́ɑ́ kɔɔnu , ɑmɑ́ uyɛ̃ nɛ tulɑɑli ɑnɛ́nɑ kɛcɑ́ɑ́ kɔɔnulɛ. ");
INSERT INTO soy_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Lɛ̃ nnyɑ kɑm pɔ́ tee rɛ: Ńlɑ píimɑ kuu nɛ́ ń nyísɛ yɛ nyísɛlɛ rɛ pi uɑkópɛ nnɛ́í u sɑ́rɛi. Amɑ́ uyɛ̃ kɑpi nkɑ́ripi n sɑ́rɛilɛ, nkɑ́ripi kuu yɛ unlɑ nyísɛ. ");
INSERT INTO soy_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yeesu uu pɛɛ unɔ́si uyɛ̃ mɑɑ rɛ: Nɛ ɑpɔ́kópɛ pɔ́ sɑ́rɛi. ");
INSERT INTO soy_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","U nɛ pɛpɛɛ kɛsẽ́ n le ɑpi pisifɑ-i n símisi rɛ: Usoi úye mpuri lo yɛɛ ɑkópɛ n sɑ́rikɛɛ? ");
INSERT INTO soy_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yeesu uu pɛɛ unɔ́si uyɛ̃ mɑɑ rɛ: Mpɔ́fɑtɛnɛ yɛ pɔ́ yóriyɛlɛ, ɑ n ŋme nɛ nkíŋniŋɛ. ");
INSERT INTO soy_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Lɛ̃ mɛmɑ́ɑ́ kɛ Yeesu uu ɑyu mɑɑ nɛ ɑyu síńsɑ́ rikɔ́ɔ́nú un Uléécɑɑ iyɔɔpi Nsímɛ́ Kɛcirɛ yóólɛ̃. Upirɛtiki kɛfi nɛ pitɛ́ ");
INSERT INTO soy_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","nɛ pinɔ́si pɛ̃ kuu ɑníri m pɛ́sɛi nɛ pɛ̃ kuu m pɔisɛntɛ pin u tikilɛ̃. Mɑɑri kɑpi n sélei rɛ Mɑkitɑlɑ ukɔ́ kɑpi ɑníri ɑsɛɛi m pɛsɛ nɛ ");
INSERT INTO soy_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Cusɑ yɛɛ Erooti kɛyɔ kɛcɑ́ɑ́ ḿ pɑílɛ̃ unɔsi Yohɑnɑ nɛ Susɑɑni nɛ pinɔ́si mɛyɑ̃ pɛɛ pɛɛ pilikɔ́ nɛ Yeesu nɛ upipirɛtiki n lɛ́ni. ");
INSERT INTO soy_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ayu kulúi kɛ́mɛɛ kɛ pisoi ɑpi yɛ pɛɛ léepɔ ɑpi Yeesu lɛɛpɔ. Kɛ pisoi ɑpi n cɑ́pinɛ, uu kɛnyɑ́rũ mɑɑ rɛ: ");
INSERT INTO soy_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Utisi unyinɛ yɛɛ ilukɛpuri pifómɛ leepɔ, icɔ ii ricéetimɛ lólu ɑpi ikɛcɑ́ɑ́ cɔpisi sinúipi ɑsi i le. ");
INSERT INTO soy_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ilukɛpuri icɔ ii kɛpɑrɛ kɛcɑ́ɑ́ lólu. Kii n lɛ, ii kóósi, kɛ ńniŋɛ ńn ń we nnyɑ. ");
INSERT INTO soy_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Icɔ ii sinípɛleépi kɛ́mɛɛ lóipɔ ii lɛlu, sinípɛleépi ɑsi mɛsɛ nɛ mɛsɛ i hilɑ. ");
INSERT INTO soy_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Amɑ́ ilukɛpuri icɔ ií nɛ kɛtẽ sɔnɛ sɑ́, ii lɛlu ii pɑpisi ii mɑ́ru ńsɔnɛ. Yeesu uu pimɑ́ɑ kpɑ́ rɛ: Ani kutu ricɔ ńsɔnɛ, úye un ukómɛ uu kóm. ");
INSERT INTO soy_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Yeesu pipirɛtiki ɑpi kɛnyɑ́rũ kɛ̃ ɑsei u pisɛ. ");
INSERT INTO soy_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Uu rinɔ́ɔ pi yɔ́su rɛ: Nɔ̃́ kɛ Uléécɑɑ uu uiyɔɔpi nsímɛ́ mɛɛ m pékɑɑlɛ̃ cereisɛ, úu pɛ̃ cereisɛ. Amɑ́ picɔ yɛ ḿpɑ́ yo kómɛilɛ yɑrɛ sinyɑ́rũ likɛ́ wɑ rɛ pi ńsɔnɛ pɑílɛ̃ ɑmɑ́ ɑ́pi kɔ pɛɛ ńsɔnɛ nyɑ́ni, pin ńsɔnɛ kutu cɔlɛ̃ ɑ́pi kɔ pɛɛ ńsɔnɛ kómɛi. ");
INSERT INTO soy_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Kɛnyɑ́rũ kɛ̃ ɑsei yɛ nnyɛ́: Ilukɛpuri yɛɛ Nléécɑɑsimɛ́. ");
INSERT INTO soy_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Pisoi pinyinɛ isoi yɛ ricéetimɛ tɛ̃ mɛcɔ welɛ. Pi yɛ konlɛ, ɑmɑ́ kuníri ɑkú weri ɑku nsímɛ́ mmɛ̃ pisifɑ-i lesɛ ɑ́pi kɑpɛ nɛ kɛfɑ n tɛnɛ likɛ́ pi n yóriyɛ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Picɔ yɛ kɛpɑrɛcɑɑ kɛ̃ mɛcɔ welɛ: Pi yɛ Nléécɑɑsimɛ́ kónlɛ ɑpi n yɔ́su nɛ mpɔ́ɔnɑrɛ, ɑmɑ́ ɑ́pi yɛ n tíyɛ nkɛ́ pikɛmɛɛ iníŋí wɑ, ɑ́pi yɛ kɛfɑ tɛnɛ likɛ́ nɑ́ŋɑi. Ncɔ́ŋ nn n kɑ, ɑpi nfɑtɛnɛ yɑ́lɑlɑpɔ. ");
INSERT INTO soy_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ilukɛpuri iyɛɛ sinípɛleépi-i ń loó yɛ we yɑrɛ pɛpɛɛ yɛ n kṍ, ɑmɑ́ ɑpi tíyɛsɛ nfɑsimɛ́ nɛ mɛmɑ́ nɛ kɛtẽ kɛcɑ́ɑ́ lilɑlɑ ɑi n hilɑ ɑ́pi yɛ pɛɛ rikɑ́hɑ́kɑ́hɑ́ nɛ kɛ́tɔ-pɔ. ");
INSERT INTO soy_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ilukɛpuri iyɛɛ kɛtẽ sɔnɛ-i ń loó yɛ we yɑrɛ pɛpɛɛ Nléécɑɑsimɛ́ kutu rińcɔ ɑpi pisifɑ-i n múlú, ɑpi n n tikilɛ̃ nɛ kɛfɑ kɛsɛ ɑpi ŋmɔ́ɔ́pú nn kulɑɑ pi wɑi. ");
INSERT INTO soy_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yeesu uu rɛ: Úkɑ úu yɛ kɛ́firɑ́ɑ risɛ́ uu kucɑ́ri kɛ kipi nɛ́ɛ uu kɛfinɛ mɛtene kɛ pésu. Amɑ́ kɛlõ cɑ́cɑ́ kɑpi yɛ kɛ ritɔsi likɛ́ nɛ n wɑ rɛ pɛ̃ nnɛ́í pɛɛ kɛ́yɔ-i n lompɔ yɛ mɛtɛ́í yɛ̃́. ");
INSERT INTO soy_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Lɛ̃ nnɛ́í lɛɛ pɛɛ m pékɑɑlɛ̃ ɑi kúyɛnɛ wɑi, lɛ̃ kɛ ḿpɑ́ úye úu pɛɛ kúyɛnɛ ń we ɑi mɛtɛ́í kɛ́mɛɛ léeri. ");
INSERT INTO soy_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ani nɔ́mɛnɛ́círɛ tĩ nɛ lɛ̃ kɑni yɛ nsímɛ́ n kṍ. Likumúŋɛ́ rɛ uyɛɛ m mɑ́ kɑpi yɛ pípɑ rikpɑ́, ɑmɑ́ úye unsɑ́ m mɑ́, nkɑ́ripi mmɛ̃ kuu m mɑ́ kɑpi u yɔ́sunɛ. ");
INSERT INTO soy_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yeesu uni nɛ upiwɑ̃ ɑpí weri ɑpi u lɛɛri, ɑmɑ́ ɑ́pi fe pikɛ́ ukɛmɛɛ tuipɔ, kɛ pisoi ɑpi kulúi ń tɔsí nnyɑ. ");
INSERT INTO soy_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Api pimɛkɑmɛ Yeesu símisi rɛ: Upɔ́ni nɛ pipɔ́wɑ̃́ yɛ kɛtɑhɑi nyɛnu pin lɑ pikɛ́ pɔ́ yɛ̃́. ");
INSERT INTO soy_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Amɑ́ Yeesu uu pinnɛ́í mɑɑ rɛ: Unɛ́ni nɛ pinɛ́wɑ̃́ pɛɛ nní pɛpɛɛ Uléécɑɑ Nsímɛ́ kutu n cɔ́lɛ̃ pin lɛ̃ knn pi m pisɛ tikilɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Kɛyɑ́ɑ kɛnyinɛ kɛ Yeesu nɛ upipirɛtiki ɑpi kúninɔi lõ uu pi mɑɑ rɛ: Tɔkɛ́ kupiyɛ kuwɛ́lɛ́ kucɔ-mɛ̃ hɑ. Api mɛ̃ tɛ́ŋ́. ");
INSERT INTO soy_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Kumúŋɛ́ kpɛ-i kɑpi n tɛ́ŋ́lɛ̃, Yeesu uu lɔpilɛ. Kuyɔ píimɑ kunyinɛ ɑku pipépɛ kɑ́pɑ́ɑ́. Míni ɑmɛ kúninɔi yipu lin nɛ nkpɔ pi wɛ́ɛ́si. ");
INSERT INTO soy_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Pipirɛtiki ɑpi Yeesu lɛɛpɔ ɑpi u yóŋsɛ ɑpi u mɑɑ rɛ: Sɑ́ɑ, Sɑ́ɑ, tɔ kpíninɛ! Yeesu uu yisi, uu kuyɔ nɛ ɑ́niwɑlɛ́ cɛ́si nɛ kuwɔ́i, ɑi níŋɛsi, ɑi sɛ́ɛ́ lɛ́kɛ́-lɛ́kɛ́. ");
INSERT INTO soy_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yeesu uu upipirɛtiki mɑɑ rɛ: Yei yɛ nɔ́nnɛ́fɑtɛnɛ? Amɑ́ iwɑmɛ ii pi wɑi, ɑsɛkɛ́ uu kɔ nnɔ́ɔ pi yipu ɑpi pimɛcɔpɛcirɛ m mɑ́ikɛɛnɛ rɛ: Usoi úye mpuri yɛ nkó, ɑí nɛ kuyɔ nɛ míni pɛ́nɛ lin u pɑkɑrɛlɛ̃ un tinɔ́ɔ n hɛ. ");
INSERT INTO soy_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Api Kerɑsɑɑ pikɔ́ kɛtẽ kɛɛ kupiyɛ mɛtɛ́ŋ́ mɛcɔ ń we kɛn Kɑlilee kɛtẽ lorólɛ̃ loni. ");
INSERT INTO soy_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Kɛ Yeesu uu kúninɔi-i rincúlɑmɛ, kuyu kpɛ̃ utisi unyinɛ uu u tɛ́pɛi. Hɑ́i mɛkɛɛ-mɛ kúu yɛ ilũ tɑ̃, ɑníri ɑn u pɛkɛsi. Úu pɛɛ kɛ́yɔ mɑ́, ɑmɑ́ ɑkpíí kɛ́mɛɛ kuú pɛɛ sói. ");
INSERT INTO soy_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Kuu Yeesu n yɛ̃́, uu pupɛi, uu uɑnui kɛcɑ́ɑ́ wúlɑ uu mɛyɑ̃́ mɑɑ rɛ: Tɔ́ nɛ mpɔ̃́ nɛ ń-ye, Uléécɑɑ yɛɛ ḿpɑ́ yo kɛcɑ́ɑ́ ń tṹ Kɛpipi Yeesu? Nɛ nɛ pɔ́ ténilɛ rɛ kɑpɛ íwɛ nɛ́ wɑ. ");
INSERT INTO soy_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ái líkɑ nnyɑ kuu lɛ̃ mɑlɛ, Yeesu yɛ rinɔ́ɔ hɛ rɛ ɑníri ɑkɛ́ ukɛmɛɛ́ le. Li yɛ lin nɛ u n yisi, pi yɛ ɑ́nɑ nɛ ɑnípɛ ɑkpɑnii u pɑɑsilɛ, ɑmɑ́ uu ɑ túúni, ɑníri ɑɑ kucɛsi kóimɑ-mɛ̃ u kpɑ́ú. ");
INSERT INTO soy_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yeesu uu u pisɛ rɛ: Íye kɑpi yɛ pɔ́ sée? Uu rinɔ́ɔ yɔ́su rɛ: Pi yɛ nɛ́ sée rɛ “kulúi”, likumúŋɛ́ rɛ ɑníri yɛ ukɛmɛɛ kulúi welɛ. ");
INSERT INTO soy_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Aníri nyɛ̃ ɑɑ́ nɛ Yeesu téni rɛ úu kɑpɛ nkpɔ kuhorɛ-mɛ̃ ɑ rilɑ́upɔ. ");
INSERT INTO soy_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Kúfɔŋlee píimɑ kunyinɛ kun tikúú kɛcɑ́ɑ́ we kun túkuri. Aníri ɑɑ́ nɛ Yeesu téni rɛ ukɛ́ tíyɛsɛ ɑkɛ́ ɑ́fɔŋ nyɛ̃-i lõ. Yeesu uu ncée ɑ hɛ. ");
INSERT INTO soy_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Aníri ɑɑ pɛɛ usoi uyɛ-i lelu ɑɑ ɑ́fɔŋ loni. Áfɔŋ ɑɑ kɛkúúcɑɑ-pɔ ntóó sɛ́ ɑɑ́ hɑ míni-i sɛ́ɛ́. ");
INSERT INTO soy_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Kɛ pisoi pɛɛ ɑ́fɔŋ n kpɑ́úlɛ̃ ɑpi lɛ̃ n yɛ̃́, ɑpi wuru ɑpí hɑ nɛ nsímɛ́ mmɛ̃ kuyu mɑɑ-i nɛ siyupi nnɛ́í-i kɔ́ɔ́nú. ");
INSERT INTO soy_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Pisoi ɑpi léeri pikɛ́ lɛlɛɛ n wɑ yɛ̃. Api Yeesu kɛ́mɛɛ tuipɔ ɑpi lɛɛpɔ utisi uyɛ̃ un peí, un Yeesu ɑnɑ kɛyúrí tṹ un lɑpɑɑlɛ̃, nɛ ukɛyu cɑ́kɑ́-cɑ́kɑ́. Iwɑmɛ ii pi wɑi. ");
INSERT INTO soy_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Pɛ̃ nnɛ́í inipɛɛ-i kɑi lɛ̃ n wɑpisi ɑpi lɛ̃ kɛ ɑníri ɑɑ́ nɛ utisi uyɛ-i ń le kɛɛnkɛɛ. ");
INSERT INTO soy_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kerɑsɑɑ kɛtẽ pikɔ́ nnɛ́íé ɑpi Yeesu mɑɑ rɛ ukɛ́ pikuyu-i le, kɛ iwɑmɛ ii pi n wɑ nnyɑ. Yeesu uu kúninɔi yopoi ukɛ́ tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Utisi uyɛ̃ kɛ ɑníri ɑɑ n tíyɛ uú nɛ Yeesu téni rɛ ukɛ́ ncée u hɛ ukɛ́ u ritiki, ɑmɑ́ Yeesu uu u lɑkɑsɛ uu u mɑɑ rɛ: ");
INSERT INTO soy_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","A kupɔ́yu pɛlɛ ɑɑ lɛ̃ kɛ Uléécɑɑ uu pɔ́ ń wɑ kɛɛnkɛɛ. Utisi uyɛ̃ uu sĩ́ uú hɑ kuyu nnɛ́í kɛ́mɛɛ lɛ̃ kɛ Yeesu uu u n wɑ símɑɑnkɛɛ. ");
INSERT INTO soy_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Kumúŋɛ́ kpɛ-i kɛ Yeesu uu kupiyɛ ritimɛ ricɔ-mɛ̃ n léemɛ un pɛɛri, pisoi pɛɛ pɛɛ n cɑ́pinɛlɛ̃ ɑpi u tɛ́pɛi. Pi nnɛ́í yɛ pɛɛ u mɛ́nlɛ. ");
INSERT INTO soy_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Utisi unyinɛ kɑpi yɛ n sée rɛ Yɑirusi uu pɛɛ́ weri. U pɛɛ ukuyu Pisuifi kuyomɛyɑ́hɑɑlee uwɛ́ɛ́sɛ lɛ. Uu Yeesu ɑnɑ mɛtene wulɑ uú nɛ u téni rɛ ukɛ́ ukɛyɔ-i hɑ rɛ ");
INSERT INTO soy_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ukɛwɑ̃ kpérepi cirɛníŋɛ kɛɛ m mɑ́ yɑrɛ ɑŋmɛ̃ kɛfi nɛ ɑtɛ́ yɛ lɑlɛ kɛkɛ́ kpu. Kumúŋɛ́ kpɛ-i kɛ Yeesu uu kei n sĩ́, pisoi pin ɑwɛ́lɛ́ nnɛ́í u nyikii pin nɛ u tikilɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Kumúŋɛ́ kpɛ-i, unɔ́si unyinɛ kɛ mɛ́nyɛ ɑmɛ n léenti hɑ́i iŋmɛ̃ kɛfi nɛ itɛ́-mɛ un kei we. Pipɔisɛ píimɑ nnɛ́í kuu rikɑ uu umɛmɑ́ nnɛ́í cɑɑi, ɑmɑ́ úkɑ úu fe ukɛ́ u pɔisɛ. ");
INSERT INTO soy_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Uu Yeesu kɛpirɛ-mɛ̃ nyɔsɔ́pɔ uu ukɛtukɑnkɑ ritimɛ cɑ. Kuu lɛ̃ tińcɑ, mɛ́nyɛ mɛɛ n foho ɑmɛ mɛsɛ nɛ mɛsɛ nyɛrɛ. ");
INSERT INTO soy_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yeesu uu pisɛ rɛ: Wóo nɛ́ ricɑ? Api pinnɛ́í kɛ́ŋɛsi rɛ ɑ́pi u ricɑ. Piyɛɛ uu rɛ: Sɑ́ɑ, pisoi yɛ pɔ́ kɑ́lɑɑlɛnlɛ ɑwɛ́lɛ́ nnɛ́í. ");
INSERT INTO soy_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Yeesu uú mɑɑ rɛ: Usoi yɛ nɛ́ ricɑlɛ. Liriyíkí rɛ nɛ ceri rɛ ńnɑŋɛ nnyinɛ yɛ kɛnɛ́mɛɛ́ lelɛ. ");
INSERT INTO soy_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Unɔ́si uu yɛ́nu rɛ li u yɑ́mnɛlɛ. Uu Yeesu-i sĩ́ un tɛrii uu uɑnɑ mɛtene wulɑ. Uu ḿpɑ́ úye kɛyu-i lɛ̃ nnyɑ kuu Yeesu rińcɑ nɛ lɛ̃ kuu mɛsɛ nɛ mɛsɛ ḿ peí símisi. ");
INSERT INTO soy_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yeesu uu u mɑɑ rɛ: Unɛ́kpére, mpɔ́fɑtɛnɛ mɛɛ pɔ́ yóriyɛ. A n ŋme nɛ nkíŋniŋɛ. ");
INSERT INTO soy_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Kumúŋɛ́ kpɛ-i kɛ Yeesu uu lɛ̃ n símisi, utumɛ un Yɑirusi kɛyɔ leeri uu Yɑirusi mɑɑ rɛ: Upɔ́kpére yɛ kpulɛ, kɑpɛ nkpɑ́ni urɔ́sɑ́ɑ pɛkɛsi. ");
INSERT INTO soy_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yeesu uu kóm, uu kuyómɛyɑ́hɑɑlee uwɛ́ɛ́sɛ Yɑirusi mɑɑ rɛ: Kɛpɔ́wuu ɑ́kɛ kɑpɛ tɔ, mpɔ́kɔ́ yɛɛ rɛ ɑ nɛ kɛfɑ tɛnɛ. Upɔ́kpére yɛ pélunɛ. ");
INSERT INTO soy_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Kɑpi kɛ́yɔ n tuipɔ, úu úkɑ ncée hɛ rɛ u nɛ uyɛ̃ pikɛ́ lompɔ, insɑ́ Piyɛɛ nɛ Yohɑni nɛ Yɑkupu nɛ kɛwɑ̃́ kɛ̃ usɑɑ nɛ kɛuni. ");
INSERT INTO soy_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ḿpɑ́ úye un téni kɛwɑ̃́ kɛ̃ nnyɑ. Yeesu uu pɛɛ́ mɑɑ rɛ: Áni kɑpɛ tẽ́, ɑ́kɛ kpu, kɛ lɔnilɛ. ");
INSERT INTO soy_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Api u n sɛ́nnyi, likumúŋɛ́ rɛ pi nyu rɛ kɛkpérepi yɛ kpulɛ. ");
INSERT INTO soy_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yeesu uu kɛkunipɛ tini, uu mɛyɑ̃́ pupɛi rɛ: Kɛwɑ̃́, ɑ yisi! ");
INSERT INTO soy_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Kɛwɑ̃́ nfɑɑ nn pɛɛri, ɑkɛ mɛsɛ nɛ mɛsɛ yisi. Yeesu uu rinɔ́ɔ hɛ rɛ pikɛ́ ilukɛ kɛ hɛ. ");
INSERT INTO soy_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ai kɛwɑ̃́ pikɔ́ nnɔ́ɔ yipu, ɑmɑ́ Yeesu uu rinɔ́ɔ pi hɛ rɛ ɑ́pi kɑpɛ lɛlɛɛ n wɑ úkɑ símisi. ");
INSERT INTO soy_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yeesu uu upitumɛ kɛfi nɛ pitɛ́ cɑ́pinɛ uu ńnɑŋɛ pi hɛ rɛ pikɛ́ ɑníri n fe ɑpi kɔ itói m pɔisɛntɛ. ");
INSERT INTO soy_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Uu pɛɛ pi tum tɛ pikɛ́ hɑ Uléécɑɑ iyɔɔpi nsímɛ́ símisi ɑpi pitóikɔ́ pɔisɛntɛ. ");
INSERT INTO soy_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Uu pi mɑɑ rɛ: Áni kɑpɛ linyinɛ rimúlú yɑrɛ kunɑɑpi nɛ́ɛ kulɔ́ɔ nɛ́ɛ ilukɛ nɛ́ɛ kɛwóó nɔkɛ́ nɛ ncée hɑ. Áni kɑpɛ sitúkɑnkɑ sitɛ́ sitɛ́ rimúlú. ");
INSERT INTO soy_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nɔn kɛ́yɔ kɛ́ye-i n topilɛ, ɑni kei n tũ hɑ́i nɛ nɔ́kɛnɛ́tɔ́ŋɛ́ tuŋɛ́. ");
INSERT INTO soy_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Pin yei kusɑ́nɛ piyɔ́ɔ́ nɔ́ n yɛ̀, ɑni pikuyu le, ɑni nɔ́ɑnɛ́nɑ nkoŋo péi likɛ́ nyísɛ rɛ pi Uléécɑɑ pipɑkɑrɛ yɛlɛ. ");
INSERT INTO soy_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Upitumɛ ɑpi tɔ́su, ɑpi ɑyu nnɛ́í kɛ́mɛɛ sɔ́nɛ ɑpi Nsímɛ́ Kɛcirɛ símisi pin ḿpɑ́ yei pitóikɔ́ pɔisɛntɛ. ");
INSERT INTO soy_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Uyɔ́ɔpi Erooti uu lɛ̃ nnɛ́í lɛɛ n wɑi nsímɛ́ kóm. Úu ceri lɛ̃ kuu yɛ́ m musí, likumúŋɛ́ rɛ pinyinɛ yɛ pɛɛ tee rɛ: Yohɑni Úniwolɛ yɛɛ pikpɔkpɔ-i yisi. ");
INSERT INTO soy_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Picɔ pin tee rɛ: Elii yɛɛ leemɛ. Picɔ pin kɔ tee rɛ: Pɛɛ mɛkɛɛ ɑntepu unyinɛ yɛɛ nkpɔ-i yisi. ");
INSERT INTO soy_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Amɑ́ Erooti uu rɛ: Nɛ tíyɛsɛlɛ ɑpi Yohɑni ríyu tɔlu. Usoi úye mpuri nsímɛ́ kɑm pɛɛ nní kómɛi mɑ́? Uú n wɛ́ɛ́si ukɛ́ Yeesu yɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Pitumɛ ɑpi pɛɛri ɑpi lɛ̃ nɛ lɛ̃ kɑpi n wɑpisi Yeesu kɛɛnkɛɛ. Uú nɛ pimɛcirɛ iyɑɑ lelu kuyu kpɛ̃ kɑpi yɛ n sée rɛ Petisɑyitɑ kɛkúrí. ");
INSERT INTO soy_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Amɑ́ pisoi pɛɛ n cɑ́pinɛlɛ̃ ɑpi kóm ɑpi u tiki. Yeesu uu Uléécɑɑ iyɔɔpi nsímɛ́ pi símisi uu kɔ pɛpɛɛ m pɔ́ɔ́lú pɔisɛntɛ. ");
INSERT INTO soy_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Kɛ ituŋɛ ii n tɛnɛ, upitumɛ kɛfi nɛ pitɛ́ ɑpí nɛ u kɔ ɑpi u mɑɑ rɛ: A pisoi mɑɑ rɛ pikɛ́ hɑ ɑyu nɛ siyupi sɛɛ nɛ nní rɔ́ ń kɔ́lɛ̃ kɛ́mɛɛ ilukɛ nɛ sifinɛ wɛ́ɛ́si, likumúŋɛ́ rɛ kucɛsi kɛcɔpɛ kɑri nté we. ");
INSERT INTO soy_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Amɑ́ Yeesu uu pi mɑɑ rɛ: Ani nɔ́rinɛ́cúruu lilukɛ-lukɛ pi hɛ. Api rinɔ́ɔ yɔ́su rɛ: Akpɔ́nɔ́ ɑnupũ nɛ ikpíntomɛ́ itɛ́ ŋmɑnɛ kɑri nté mɑ́. Nɛ́ɛ pɔ lɑ rɛ tɔkɛ́ hɑ pisoi mpí nnɛ́í ilukɛ lɔ? ");
INSERT INTO soy_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Pisoi ɑ́kotokú ɑnupũ (5.000) pɛɛ pɛɛ kei we. Yeesu uu upitumɛ mɑɑ rɛ: Ani pi tonsɛntɛ pisoi kuwóó kuwóó ɑnɑi. ");
INSERT INTO soy_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Pitumɛ ɑpi lɛ̃ kuu pi n forii wɑi, ɑpi pisoi tonsɛntɛ. ");
INSERT INTO soy_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yeesu uu ɑkpɔ́nɔ́ ɑnupũ nɛ ikpíntomɛ́ itɛ́ kpísi, uu kɛyómɛ weríí, uu ilukɛ iyɛ̃ kɛcɑ́ɑ́ Uléécɑɑ pɔɔnɛsɛ. Uu kpɔ́kɔrinɛ uu upitumɛ pɑ rɛ pikɛ́ pisoi pɛɛ n cɑ́pinɛlɛ̃ hɔɔnɛ. ");
INSERT INTO soy_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Pinnɛ́í ɑpi le ɑpi lɛpu. Upitumɛ ɑpi ɑkéri nyɛɛ m pɔɔnɛ cɑ́pinɛ ɑi ɑnɛ́rɛ kɛfi nɛ ɑtɛ́ yipu. ");
INSERT INTO soy_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Kɛyɑ́ɑ kɛnyinɛ kɛ Yeesu uu umɛcirɛ kɛyómɛ yɑ́ɑ́si, upipirɛtiki ɑpi u lɛɛpɔ, uu pi pisɛ rɛ: Pisoi yɛ mɑ́ikɛɛ rɛ nɛ́ɛ úye? ");
INSERT INTO soy_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Api rinɔ́ɔ yɔ́su rɛ: Pinyinɛ yɛ tee rɛ pɔ Yohɑni Úniwolɛ lɛ, picɔ rɛ pɔ Elii lɛ, picɔ pin kɔ tee rɛ pɔ pɛɛ mɛkɛɛ ɑntepu unyinɛ lɛ yɛɛ nkpɔ kɛ́mɛɛ n yisi. ");
INSERT INTO soy_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Yeesu uu pi pisɛ rɛ: Nɔ̃́ ní, nɔ mpíí rɛ nɛ́ɛ úye? Piyɛɛ uu rinɔ́ɔ yɔ́su rɛ: Pɔ́ɔ uyɛ̃ kɛ Uléécɑɑ uu n wɛ́ɛ. ");
INSERT INTO soy_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yeesu uu pi nyi rɛ ɑ́pi kɑpɛ úkɑ nsímɛ́ mmɛ̃ símisi. ");
INSERT INTO soy_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Uu pimɑ́ɑ kpɑ́ rɛ: Li pisɛ rɛ nɛ̃́ Usoi Kɛpipi kɛ́ mɛyɑ́nsei íwɛ li. Pisuifi piwɛ́ɛ́sɛ nɛ pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ nɛ isé picélɑɑ yɛ́ kɛ kɛsi. Li kɔ pisɛ rɛ pikɛ́ kɛ kpu ɑkɛ kɛyɑ́ɑ tɑ́ɑ́nũ tuŋɛ́ yisi. ");
INSERT INTO soy_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Uu pɛɛ pinnɛ́í mɑɑ rɛ: Úye un n lɑ ukɛ́ nɛ́ ritiki, ukɛ́ umɛcirɛ pípɑí riyɑ́ uu ḿpɑ́ kɛyɑ́ɑ kɛ́ye ukunɑpɛ́ɛ́kɔɔ́ n yɑlɛ̃, uu pɛɛ nɛ́ tíki. ");
INSERT INTO soy_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ái líkɑ nnyɑ, úye un n lɑ ukɛ́ unfɑɑ lɔ, u n fómnilɛ. Amɑ́ úye un nɛ̃́ nnyɑ unfɑɑ n fóm, liute yɛɛ yɛ́ unfɑɑ lɔ. ");
INSERT INTO soy_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Usoi kulɑɑ yɛ kúye in tɛ u kɛtẽ nté likɔ́ nnɛ́í yɛ̃́, uu pɛɛ kpi nɛ́ɛ uu umɛcirɛ ɑ́sɑ́lɑ́ú tɑni. ");
INSERT INTO soy_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Úye un nɛni inɛ́sɛi nɛ nnɛ́símɛ́ isɛi n wɑi, Usoi Kɛpipi yɛ́ kɔ uisɛi wɑ kɛn píyei kɛmɛyɔɔpi nɛ kɛusɑɑ nɛ piléécɑɑtumɛ kɛ Uléécɑɑ uu n wɛ́ɛ mɛyɔɔpi-i m pɛɛri. ");
INSERT INTO soy_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Asei kɑm nɔ́ símisi, pinyinɛ yɛ nté welɛ pɛɛ yɛ́ Uléécɑɑ mɛyɔɔpi n yɛ̃́ ɑpi kɛlenɛ kpíni. ");
INSERT INTO soy_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Kɛ Yeesu uu lɛ̃ pisímɛ́ ḿ mɑsí, ɑi wɑi yɑrɛ siyɑ́ɑ sipɑhɑ kumúŋɛ́, uu Yohɑni nɛ Yɑkupu kpísi uú nɛ rikúú tɑɑ́ pikɛ́ kɛyómɛ yɑ́ɑ́si. ");
INSERT INTO soy_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Kuu kɛyómɛ n yɑ́ɑ́si, ukɛyu ɑkɛ mɛ́wee consɛ, uilũ ii wɑ́rɑrɑ póí-póí. ");
INSERT INTO soy_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Mɛsɛ nɛ mɛsɛ, pisoi pitɛ́ pinyinɛ ɑpi Uléécɑɑ mɛyɔɔpi-i léeri, pi nɛ Yeesu pin yɔ́i. Pikɛi kɑi m pisɛ rɛ ukɛ́ wɑ nɛ unkpɔ Yerusɑlɛm-pɔ ifɑɑci kɑpi lɛ̃ wɑi. Pɛpɛɛ Moisi nɛ Elii. ");
INSERT INTO soy_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Piyɛɛ nɛ upicɔ pin nɛ nnɔ̃ kɛtɑɑ tu, ɑmɑ́ ɑpi yɑ́kɑ-yɑkɑ ɑpi Yeesu mɛyɔɔpi nɛ pisoi pitɛ́ pɛɛ ukɛkúrí ń nyɛnu yɛnu. ");
INSERT INTO soy_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Kɛ pisoi pɛ̃ ɑpi Yeesu rin-yɑ́, Piyɛɛ uu u mɑɑ rɛ: Sɑ́ɑ, li nyɑmlɛ rɛ tɔkɛ́ nté n we. Tɔ lɑ rɛ tɔkɛ́ sicɑ́ŋíípi sitɑɑni kɑrii, pɔ̃́ kɛsɛ, Moisi kɛsɛ, Elii kɛsɛ. Úu nkpɑ́ni nyu mmɛ̃ kuu n símisi. ");
INSERT INTO soy_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Kumúŋɛ́ kpɛ-i kuu lɛ̃ n símisi, kuhopɛ kunyinɛ ɑkú weri ɑku pi hilɑ. Kɛ pipirɛtiki ɑpi ń yɛ̃́ kuhopɛ kun lɛ̃ pi hilɑlɛ̃, iwɑmɛ ii pi loni. ");
INSERT INTO soy_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Tinɔ́ɔ rinyinɛ ɑri kuhopɛ kpɛ-i léeri rɛ: Nkó yɛɛ Kɛnɛ́pipi kɑm n wɛ́ɛ, ɑni kutu kɛ ricɔ! ");
INSERT INTO soy_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Kɑpi rinɔ́ɔ tɛ̃ lɛ̃ n kómɛi Yeesu ŋmɑnɛ kɑpi pɛɛ nyɑ́ni. Pipirɛtiki ɑpi sɛ́ɛ́, ɑ́pi kumúŋɛ́ kpɛ-i úkɑ lɛ̃ kɑpi n yɛ̃́ símisi. ");
INSERT INTO soy_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kɑi kóso n weesi, ɑpi rikúú cɛ́pimɛ, risoiwuí píimɑ rinyinɛ ɑri Yeesu tɛ́pɛipɔ. ");
INSERT INTO soy_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Utisi unyinɛ uu riwúí tɛ̃ kɛcɔpɛ sicɑ́ɑ́ilɑ kɑ́pɑ́ɑ́ rɛ: Sɑ́ɑ, nɛ nɛ pɔ́ téni rɛ ɑ kɛnɛ́wɑ̃́ kɛcɑ́ɑ́ ripɑí, kɛnɛ́círɛníŋɛ yɛ kɛ. ");
INSERT INTO soy_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Kuníri kunyinɛ kpɛɛ yɛ kɛ yisi, ɑkɛ mɛsɛ nɛ mɛsɛ pipupukɛɛ loni, ɑku kɛ kpɑpɑmnisɛ mɛyɑ̃́, ɑku ɑtɑlɑlɑɑ́ kɛ wɔ́isɛ. Áku yɛ mɛsɛ nɛ mɛsɛ kɛ riyɑ́, ku yɛ íwɛ kɛ wɑlɛ kɛlenɛ. ");
INSERT INTO soy_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Aḿ nɛ pipɔ́pirɛtiki téni rɛ pikɛ́ kuníri kpɛ̃ lɑkɑsɛ, ɑmɑ́ ɑ́pi fe. ");
INSERT INTO soy_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yeesu uu pɛɛ rɛ: Nɔ́ nfɑtɛnɛcirɛ́ nɛ pikpɑ́ɑ́ree mpuri mmú! Ituŋɛ ilɛ́ kɑm nɔ́kɛnɛ́mɛɛ pitónɛ kpɑ́nɛ? Ituŋɛ ilɛ́ kɑm yɛ́ lɛ̃ nɛ nɔ́ n kɑhɑri? Ani nɛ kɛwɑ̃́ kɛ̃ nté nɛ́ kɑm. ");
INSERT INTO soy_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Kɛ kɛwɑ̃́ ɑkɛ n nyɑhɑipɔ, kuníri ɑku kɛ pɛpirɛ ɑku kɛ lémesi mɛyɑ̃́. Amɑ́ Yeesu uú nɛ kuníri cɛ́si hɑ́i, uu kɛwɑ̃́ pɔisɛ uu kɛusɑɑ múísɛ. ");
INSERT INTO soy_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Uléécɑɑ nnɑŋɛ píimɑ nn ḿpɑ́ úye pírí wɑi. Yeesu mɛwɑi mɛ̃ mɛn kɔ lɛ̃ ḿpɑ́ úye pírí we, uu upipirɛtiki mɑɑ rɛ: ");
INSERT INTO soy_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Ani nkpéni ɑsei nyɛ̃ kɑm ń lɑ kɛ́ nɔ́ símisi rimúlú ńsɔnɛ. Pi yɛ́ Usoi Kɛpipi pisoi ɑnipɛ-i wɑ pikɛ́ kɛ kpu. ");
INSERT INTO soy_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Amɑ́ ɑ́pi nsímɛ́ mmɛ̃ kõ. Pi pi m pesilɛ rɛ ɑ́pi kɑpɛ n kõ, iwɑmɛ íi kɔ ŋmurɛi pikɛ́ nɛ Yeesu m pisɛ. ");
INSERT INTO soy_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Pipirɛtiki ɑpi pimɛcɔpɛcirɛ kɛyɑ́ɑ kɛnyinɛ n kɛŋɛnɛ pikɛ́ céri rɛ úye yɛɛ pikɛcɔpɛ uwɛ́ɛ́sɛ. ");
INSERT INTO soy_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yeesu uu pinfɑsimɛ́ céru. Uu pɛɛ kɛwɑ̃́ kɛnyinɛ kpísi uu ukɛkúrí nyɛrɛsɛ. ");
INSERT INTO soy_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Uu pi mɑɑ rɛ: Úye un nɛ̃́ nnyɑ kɛwɑ̃́ nkɛ́ kusɑ́nɛ n yɔsí, tinɛ́cúruu kuu kusɑ́nɛ yɔsí. Úye un kɔ kusɑ́nɛ nɛ́ n yɔsí, uyɛɛ nɛ́ n tummɛ kuu kɔ kusɑ́nɛ yɔsí. Likumúŋɛ́ rɛ úye un nɔ́kɛnɛ́cɔpɛ usíńsɑ́, uyɛɛ uwɛ́ɛ́sɛ. ");
INSERT INTO soy_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yohɑni uu rinɔ́ɔ yɔ́su rɛ: Sɑ́ɑ, tɔ unyinɛ yɛnlɛ yɛɛ ɑníri n lɑ́kɑsɛ nɛ ripɔ́nyíri nnɑŋɛ ɑrí n lɑ tɔkɛ́ nɛ u yɛ̀, kúu kɛrɔ́cɔpɛ ń we tɔn nɛ pɔ́ tíkilɛ̃ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Amɑ́ Yeesu uu rinɔ́ɔ u pɛsɛ rɛ: Áni kɑpɛ nɛ u yɛ̀, liriyíkí rɛ úye un nɔ́kɛnɛ́cɑ́ɑ́ n kpɑ́lɛ̃, uyɛ̃ úu nɔ́unɛ́lɑ́ɑrɔ. ");
INSERT INTO soy_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Kɛ kumúŋɛ́ kpɛ̃ kɛ Yeesu uu kɛyómɛ-mɛ̃ ń tɑɑ́nɛ ɑku n tu, Yeesu uu hɔ́ rɛ ukɛ́ Yerusɑlɛm hɑ. ");
INSERT INTO soy_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Uu pisoi pinyinɛ kɛkpéẽ tɔ́ŋsɛ, ɑpi Sɑmɑrii kuyu kunyinɛ sĩ tɛ pikɛ́ lɛ̃ nɛ lɛ̃ kɑi u m pisɛ u wɛ́ɛ́si ukɛ́ kɛlenɛ tuipɔ. ");
INSERT INTO soy_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Amɑ́ kuyu kpɛ̃ pikɔ́ ɑ́pi ŋmurɛi pikɛ́ kusɑ́nɛ u yɔsí, kuu Yerusɑlɛm-mɛ̃ n símpɔ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Kɛ upipirɛtiki Yɑkupu nɛ Yohɑni ɑpi lɛ̃ n yɛ̃́ ɑpi u mɑɑ rɛ: Upíimɑ, pɔ lɑlɛ rɛ tɔkɛ́ nnɑ rinɔ́ɔ hɛ nkɛ́ pikɛcɑ́ɑ́ cuunu nkɛ́ pi torɛɛ? ");
INSERT INTO soy_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yeesu uu pikuwɛ́lɛ́-mɛ̃ pɑnsɛpɔ uú nɛ pi cɛ́si uu pɛɛ pi mɑɑ rɛ: Áni nyu kɛmúŋɛ́ kɛkɛɛ nɔ́kɛnɛ́mɛɛ ń we. Usoi Kɛpipi ɑ́kɛ kɑ rɛ kɛkɛ́ pisoi fóm, ɑmɑ́ kɛ kɑlɛ rɛ kɛkɛ́ piɑyu lɔ. ");
INSERT INTO soy_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Api pɛɛ yisi ɑpi kuyu féé-mɛ̃ sĩ. ");
INSERT INTO soy_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Pin ncée-i we kɛ utisi unyinɛ uu Yeesu mɑɑ rɛ: Nɛ pɔ́ tíkinɛ kei kɑɑ n símpɔnɛ nnɛ́í. ");
INSERT INTO soy_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yeesu uu u mɑɑ rɛ: Sisɑ́ŋɑ́ yɛ siɑlééri mɑ́lɛ, sinúipi sin siɑyɑ́mɛ́ mɑ́, ɑmɑ́ nɛ̃́, Usoi Kɛpipi ɑ́m tíkɑ mɑ́ kɑm yɛ́ ríyu n tɑmpɔ kɛ́ wéntɛ. ");
INSERT INTO soy_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Uu usoi ucɔ mɑɑ rɛ: A nɛ́ ritiki. Amɑ́ usoi uu rɛ: Sɑ́ɑ, ɑ ncée nɛ́ hɛ kɛ́ hɑ unɛ́sɑ́ɑ kulɛsi kɛ́ pɛɛ kɛlenɛ pɔ́ ritiki. ");
INSERT INTO soy_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yeesu uu rinɔ́ɔ u pɛsɛ rɛ: A tíyɛ pikpɔkpɔ pikɛ́ pikpɔkpɔ kulɛsi, pɔ́ɔkɛ́ hɑ Uléécɑɑ iyɔɔpi nsímɛ́ símisi. ");
INSERT INTO soy_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Usoi ucɔ uu u mɑɑ rɛ: Nɛ pɔ́ tíkinɛ Upíimɑ, ɑmɑ́ ɑ ncée nɛ́ hɛ kɛ́ hɑ mɛnɛ́tɔ́ŋɛ́ pinɛ́kɔ́ símisi. ");
INSERT INTO soy_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yeesu uu pɛɛ u pɛsɛ rɛ: Uyɛɛ nɛ inɑ́ɑ n kɔ́lɔi un pɛɛ kɛpirɛ ŋmɛ́ɛ́ni úu nɛ sɑ́ rɛ ukɛ́ Uléécɑɑ iyɔɔpi kɛ́mɛɛ ukɛikɔ́. ");
INSERT INTO soy_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Lɛ̃ mɛmɑ́ɑ́, Upíimɑ uu pisoi kuwóó nɛ ɑfɛɛrɛ́ wɛ́ɛ uu pitɛ́ pitɛ́ pi tum ɑyu nɛ silõ nnɛ́í kɛ́mɛɛ kɑi m pisɛ rɛ uricuruu ukɛ́ kɔ sɔ́nɛ. ");
INSERT INTO soy_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Uu pi mɑɑ rɛ: Ilukɛ kɑpi ń kpɑsinɛ yɛ piyɛlɛ, ɑmɑ́ pikɛikɔ́ pɛɛ yɛ́ i n kpɑsi ɑ́pi piyɛ. Ani nɛ ucɑrɛte tẽ́ ukɛ́ pɛpɛɛ yɛ́ i n kpɑsi rikpɑ́. ");
INSERT INTO soy_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ani ncée kpísi! Nɛ nɔ́ tumlɛ rɛ ɑni isɑ́ŋ yɛɛ ɑ́kpɛ kɛcɔpɛ ń we mɛcɔ n sɔ́nɛ. ");
INSERT INTO soy_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Áni kɑpɛ siwóó nɛ́ɛ kulɔ́ɔ nɛ́ɛ ɑnɛ́ɛ́ri rimúlú, ɑ́ni kɑpɛ ncée-i nyɛrɛ rɛ nɔkɛ́ unyinɛ yɑ́ɑ́si. ");
INSERT INTO soy_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Nɔkɛ́ kɛlenɛ kɛ́yɔ kɛnyinɛ-i n lompɔ, ɑni yɛ mɑɑ rɛ: Nkíŋniŋɛ nkɛ́ kɛ́yɔ nkɛ́-i n we. ");
INSERT INTO soy_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","In tɛ nkíŋniŋɛ ukɔ́ unyinɛ yɛ kɛ́yɔ kɛ-i we, nɔ́nnɛ́kíŋniŋɛ yɛ́ u ritiki. Insɑ́ lɛ̃, nɔ́kɛnɛ́mɛɛ kɛ nɔ́nnɛ́kíŋniŋɛ nn pɛlɛnɛ. ");
INSERT INTO soy_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ani kɛ́yɔ kɛ-i tonɛ, ɑni lɛ̃ kɑpi kei nɔ́ n hɛ le ɑni níru, likumúŋɛ́ rɛ ukɛikɔ́ yɛ uihɛ́ɛ́ mɑ́lɛ. Áni kɑpɛ síyɔ n tɔrii. ");
INSERT INTO soy_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Nɔn kuyu kúye-i n lompɔ pin kusɑ́nɛ nɔ́ n yɔ́su, pin yo nɔ́ m pɑ, ɑni li. ");
INSERT INTO soy_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ani pitóikɔ́ m pɔisɛntɛ, ɑni kuyu pikɔ́ mɑɑ rɛ: Uléécɑɑ iyɔɔpi yɛ nɔ́ nyɑhɑimɛlɛ. ");
INSERT INTO soy_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Amɑ́ nɔn kuyu kúye-i n lompɔ pin piyɔ́ɔ́ nɔ́ n yɛ̀, ɑni icée-i léepɔ ɑní mɑɑ rɛ: ");
INSERT INTO soy_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Tɔ nɔ́kunɛ́yu nkoŋo mɛɛ ɑrɔ́nɑ riḿmɛɛlú nɔ́kɛnɛ́cɑ́ɑ́ ripéi. Ḿpɑ́ nɛ lɛ̃, ɑni ceri rɛ Uléécɑɑ iyɔɔpi yɛ nɛ nɔ́ rikɔlɛ. ");
INSERT INTO soy_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Asei kɑm nní nɔ́ símisi rɛ kɛyɑ́ɑ kɛ̃ kɛ Uléécɑɑ uu n sɔ́nti ukɛ́ nɛ pisoi n túhɑɑnɛ, Sotɔm pikɔ́ kɛ Uléécɑɑ uu nnɑ n ŋmɑɑsi iwɛ yɛ́ nɛ kuyu kpɛ̃ ikɔ́ kutɔsi wɑ. ");
INSERT INTO soy_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Nɔ̃́ Korɑsin pikɔ́, íwɛ kɑni topori. Nɔ̃́ Petisɑyitɑ pikɔ́, íwɛ kɑni topori! Likumúŋɛ́ rɛ mɛwɑisɑŋɑ kɑpi nɔ́kɛnɛ́mɛɛ n wɑpisi mɛn pɛɛ Tiiri nɛ Sitɔɔ kɛ́mɛɛ n wɑ, ɑi nní ń we pin piɑkópɛ kɛpirɛ ritɔ ɑpi ɑ́fɔrɔnti tɑni ɑpi pimɛcirɛ nfúrɔ̃ kɔikɛɛ likɛ́ nyísɛ rɛ pi consɛ. ");
INSERT INTO soy_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Lɛ̃ nnyɑ kɛ Tiiri nɛ Sitɔɔ pikɔ́ iwɛ ii yɛ́ hɑ kɛtúhɑɑnɛ kɛ́mɛɛ́ nɛ nɔ́inɛ́kɔ́ kutɔsi wɑ. ");
INSERT INTO soy_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ńté nɔ̃́ Kɑpɛrinɑwum pikɔ́, nɔ músu rɛ kɛléécɑɑ-mɛ̃ kɑní tɑɑ́lɛ̃? Ái nkpɑ́ni lɛ̃. Amɑ́ kukúlɑ̃yu-i kɛ Uléécɑɑ uu kɛtẽ-mɛ̃ nɔ́ lɑ́upɔlɛ. ");
INSERT INTO soy_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Uu upipirɛtiki pimɑ́ɑ kpɑ́ rɛ: Úye un kutu nɔ́ n cɔlɛ̃, nɛ̃́ kuu kutu cɔlɛ̃, úye un nɔ́ n yulu nɛ̃́ kuu yúlu. Úye un kɔ nɛ̃́ n yulu, uyɛɛ nɛ́ n tummɛ kuu yúlu. ");
INSERT INTO soy_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Pisoi kuwóó nɛ ɑfɛɛrɛ́ pɛ̃ kɑpi n tũ ɑpi pɛɛri nɛ mpɔ́ɔnɑrɛ, ɑpi rɛ: Sɑ́ɑ, ɑníri ricuruu yɛɛ rɔ́ pɑkɑrɛlɛ, tɔn tinɔ́ɔ ɑ n hɛ nɛ ripɔ́nyíri. ");
INSERT INTO soy_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yeesu uu rinɔ́ɔ pi yɔ́su rɛ: Nɛ pɛɛ Setɑni yɛnlɛ un kɛyómɛcɑɑ-pɔ lóiri yɑrɛ kɛkónɛsɛípi. ");
INSERT INTO soy_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ani kutu ricɔ! Nɛ́ɛ ńnɑŋɛ nɔ́ hɛ rɛ nɔkɛ́ iwɑ́ɑ nɛ inɑ̃ kɛcɑ́ɑ́ sɔ́nɛ ɑni ulɑ́ɑrɔ nnɑŋɛ nnɛ́í tɛ́kɛ́ɛ́ líkɑ ɑ́i yɛ́ kɔ nɔ́ wɑ. ");
INSERT INTO soy_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Amɑ́ ɑ́i kɑpɛ nɔ́ n lɑ́ɑ́rú rɛ ɑníri yɛ nɔ́ wuru nnyɑ. Lɛlɛɛ yɛ́ nɔ́ n lɑ́ɑ́rú lɛɛ rɛ Uléécɑɑ yɛ nɔ́ɑnɛ́nyíri uritɛlɛ́ kɛ́mɛɛ wɔ́i. ");
INSERT INTO soy_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Kumúŋɛ́ kpɛ-i, Nfɑ́ɑsɔnɛ nn Yeesu rikiŋ niŋukusɛ uú mɑɑ rɛ: Sɑ́ɑ, kɛtẽ nɛ kɛyómɛ Upiimɑ, nɛ pɔ́ pɑkɑrɛ rɛ pɔ tíyɛsɛ siwɑ̃́ síńsɑ́pi ɑsi nsímɛ́ mmɛ̃ kɑɑ pisɔhɔɔ nɛ pinyuwɛ ḿ pesí ɑsei kom. Pɔ́ɔ mpɔ́fɑnɑrɛ kɛ́mɛɛ lɑ rɛ likɛ́ lɛ̃ wɑ nnyɑ kɑi kɔ mɛsei lɛ̃ wɑ, Sɑ́ɑ. ");
INSERT INTO soy_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Unɛ́sɑ́ɑ yɛ ḿpɑ́ yo nnɛ́í nɛ́ pɑlɛ. Úkɑ ucɔ úu nɛ́ nyu Unɛ́sɑ́ɑ mɛmɑ́ɑ́. Úkɑ ucɔ úu kɔ Unɛ́sɑ́ɑ nyu insɑ́ nɛ̃́ Ukɛpipi nɛ pɛ̃ kɑm n tíyɛsɛ ɑpi u ceru. ");
INSERT INTO soy_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Yeesu uu lɛ̃ mɛmɑ́ɑ́ upipirɛtiki-mɛ̃ pɑnsɛpɔ uu pi mɑɑ rɛ: Pɛpɛɛ lɛ̃ kɑni nní n nyɑ́ni n nyɑ́ni yɛ pínɑrɛkomɛ lɛ. ");
INSERT INTO soy_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Asei kɛcɑ́ɑ́, ɑntepuyɛ nɛ piyɔ́ɔpi mɛyɑ̃ yɛ kɑ́ipilɛ pikɛ́ lɛ̃ kɑni n yɛ̃́ yɛ̃, ɑmɑ́ ɑ́pi li yɛ̃, ɑpi kɑ́ipi rɛ pikɛ́ lɛ̃ kɑni nní n kṍ kõ, ɑmɑ́ ɑ́pi li kõ. ");
INSERT INTO soy_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Isé ucélɑɑ unyinɛ uu rinɔ́ɔ mɑɑ un lɑ ukɛ́ Yeesu ripinɛ wɑ, uu u pisɛ rɛ: Sɑ́ɑ, íye kɑi pisɛ rɛ kɛ́ wɑ kɛ́ nɛ nfɑ́ɑ tɛnɛcirɛ́ n yɛ̃́? ");
INSERT INTO soy_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yeesu uu rinɔ́ɔ u yɔ́su rɛ: Íye kɑi irɔ́sé kɛ́mɛɛ wɔ́lɑɑlɛ̃? Kɑɑ yɛ isé ritɛlɛ́ n kɛ́ɛ̃, íye kɑɑ yɛ mpíí i kõ. ");
INSERT INTO soy_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Usoi uyɛ̃ uu rinɔ́ɔ yɔ́su rɛ: A Upíimɑ Upɔ́léécɑɑ n lɑ nɛ kɛpɔ́fɑ nnɛ́í, nɛ ipɔ́soi nnɛ́í, nɛ mpɔ́nɑŋɛ nnɛ́í nɛ kɛpɔ́múŋɛ́ nnɛ́í, ɑɑ kɔ upɔ́cɔ n lɑ yɑrɛ kɑɑ ripɔ́cúruu ń lɑ. ");
INSERT INTO soy_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yeesu uu pɛɛ u mɑɑ rɛ: Pɔ ńsɔnɛ rinɔ́ɔ nɛ́ pɛsɛlɛ. A lɛ̃ titiki, pɔ́ nfɑ́ɑ yɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Amɑ́ isé ucélɑɑ uu ɑlɑri n wɛ́ɛ́si uu lɛ̃ nnyɑ Yeesu pisɛ rɛ: Wóo unɛ́soicɔ? ");
INSERT INTO soy_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yeesu uu rinɔ́ɔ u pɛsɛ rɛ: Utisi unyinɛ yɛɛ kɛyɑ́ɑ Yerusɑlɛm leeri un Yeriko-mɛ̃ cɛpilɛ̃, piyɑɑ ɑpi u tini ɑpi uilũ yɔ́su ɑpi u kpɑfui ɑpi itói u wɑi, ɑpi kɛteni-i u lɑlɛi hɛihɛi ɑpi tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Aí nɛ sɑ́ uyɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ unyinɛ un ncée mmɛ̃ tikilɛ̃. Kuu utisi uyɛ̃ n yɛ̃́, uu kɛ́ŋɛ́ɛ́ uu fɑ́ɑu. ");
INSERT INTO soy_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Lefi ukɔ́ unyinɛ uu kɔ limɛcɔ kɛlõ kɛ-i tuipɔ, uu utisi uyɛ̃ yɛnu, uyɛ̃ uu kɔ kɛ́ŋɛ́ɛ́ uu fɑ́ɑu. ");
INSERT INTO soy_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Amɑ́ Sɑmɑrii ukɔ́ unyinɛ yɛɛ ncée mmɛ̃ n tíkimɛlɛ̃ uu utóikɔ́ uyɛ̃ kɛlõ tuipɔ. Kuu u n yɛ̃́, ɑi mɛyíkíyiki íwɛ u wɑi. ");
INSERT INTO soy_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Uú nyɔsɔ́pɔ uu mɛ́kpɔ nɛ fɛɛ̃́ uitoi kɛcɑ́ɑ́ kɔikɛɛ, uu i pɑhɑɑnkɛɛ. Uu lɛ̃ mɛmɑ́ɑ́ ukɛminɑɑ kɛcɑ́ɑ́ u tonsɛ uú nɛ picéetɔŋɛ́ kɛyɔ kɛnyinɛ-i u sĩ uú hɑ kei ukɛcɑ́ɑ́ pɑí. ");
INSERT INTO soy_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Kɑi n weesi, uu mɛwóópipi mɛtɛ́ lesɛ uu uyɛɛ picéetɔŋɛ́ kɛyɔ kɛcɑ́ɑ́ ḿ pɑílɛ̃ pɑ uu u mɑɑ rɛ: A usoi nkó kɛcɑ́ɑ́ ripɑí, nɛn hɑ píyei nté m pɛɛmɛ, nɛ́ riwómɛ tɛɛ n tisɛ pɔ́ hɛ́ɛ́lɛ. ");
INSERT INTO soy_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yeesu uu pimɑ́ɑ kpɑ́ rɛ: Pisoi pitɑɑni mpí kɛcɔpɛ úye yɛɛ uyɛ̃ kɛ piyɑɑ ɑpi nní itói n wɑ usoicɔ? ");
INSERT INTO soy_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Isé ucélɑɑ uu rinɔ́ɔ yɔ́su rɛ: Uyɛɛ kusoi u n wɑ yɛɛ uusoicɔ. Yeesu uu pɛɛ u mɑɑ rɛ: A n ŋme, ɑɑ yɛ limɛcɔ wɑi. ");
INSERT INTO soy_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","39","Kɛ Yeesu nɛ upipirɛtiki ɑpi pinsẽ ń nɔŋ́lɛ̃, ɑpi kuyu kunyinɛ tulu, unɔ́si unyinɛ kɑpi yɛ n sée rɛ Mɑritɑ un kei we, uu ukɛyɔ-i kusɑ́nɛ pi yɔ́su. Mɑritɑ yɛ pɛɛ uwɑ̃́ unyinɛ mɑ́lɛ ɑpi yɛ u séi rɛ Mɑɑri. U pɛɛ kei welɛ. Uu Upíimɑ ɑnɑ mɛtene tonɛ un uicélɑɑ kutu cɔlɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mɑritɑ pɔ́ɔn nɛ pisɔ́ɔ̃ kɛ́yu mɑhɑni. Uu yisi uu rɛ: Upíimɑ, ɑ́i pɔ́ cɔ́ŋlɛ̃ kɛ unɛ́wɑ̃́ uú nɛ mɛnɛ́círɛ pihúúkɛi n nyɑ́nɛii? A u mɑɑ rɛ ukɛ́ nɛ́ lɛ̃́. ");
INSERT INTO soy_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Upíimɑ uu u mɑɑ rɛ: Mɑritɑ, Mɑritɑ, pɔ mɛpɔ́círɛ ḿpɑ́ yo kɛ́mɛɛ picɔ́ŋ tɔsilɛ nɛ pinɑ́kɑɑnkɛɛ. ");
INSERT INTO soy_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Amɑ́ likɛi lisɛ kɑi usoi pisɛ. Likɛi kɛcirɛ kɛ Mɑɑri uu wɛ́ɛ, úkɑ úu yɛ́ fe ukɛ́ li u yɔsí. ");
INSERT INTO soy_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Kɛyɑ́ɑ kɛnyinɛ kɛ Yeesu uu kɛlõ kɛnyinɛ kɛyómɛ yɑ́ɑ́si. Kuu ḿ mɑsí, uupirɛtiki unyinɛ uu u pisɛ rɛ: Upíimɑ, ɑ piyómɛyɑ́hɑɑ rɔ́ céési yɑrɛ kɛ Yohɑni uu upipirɛtiki n céesi mɛcɔ. ");
INSERT INTO soy_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yeesu uu pi mɑɑ rɛ: Nɔn yɛ kɛyómɛ n yɑ́ɑ́sinɛ, ɑni yɛ mɑɑ rɛ: Sɑ́ɑ, tipɔ́nyíri tikɛ́ n kóólɛlɛ̃. Ipɔ́yɔ́ɔpi ikɛ́ lommɛ. ");
INSERT INTO soy_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","A ḿpɑ́ kɛyɑ́ɑ kɛ́ye ilukɛ rɔ́ hɛ. ");
INSERT INTO soy_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","A ɑrɔ́kópɛ rɔ́ sɑ́rɛi, Yɑrɛ kɛ tɔ́ɔ yɛ kɔ picɔ n sɑ́rɛi pin ɑkópɛ rɔ́ n wɑ mɛcɔ. Kɑpɛ tíyɛsɛ tɔkɛ́ pipeikɛɛ kɛ́mɛɛ loó. ");
INSERT INTO soy_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yeesu uu kɔ pimɑ́ɑ pi kpɑ́ rɛ: Nɔ́ unyinɛ un nkpéni usɑ́nɛ m mɑ́ uu kɛsinɛ u lɛɛpɔ uu u mɑɑ rɛ: Unɛ́sɑ́nɛ, ɑ ɑkpɔ́nɔ́ ɑtɑɑni nɛ́ lonsɛ. ");
INSERT INTO soy_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Unɛ́sɑ́nɛ unyinɛ yɛɛ ncée leeri uu kɛnɛ́yɔ-i weri, ɑ́m kɔ pɛɛ líkɑ mɑ́ kɛ́ u pɑ. ");
INSERT INTO soy_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","In n lɑ uusɑnɛ uyɛ̃ yɛ́ hɑ́i kɛ́yɔ kɛmɛɛ-pɔ rinɔ́ɔ u yɔ́ɔmɛ rɛ: Kɑpɛ nɛ́ ricɔ́ŋ! Nɛ rinɔnɔɔ hɑ́nɛsilɛ ɑm kɑ́, tɔ́ nɛ sinɛ́wɑ̃́ yɛ lonlɛ, ɑ́m fenɛ kɛ́ yisi kɛ́ ɑkpɔ́nɔ́ pɔ́ pɑ. ");
INSERT INTO soy_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Asei kɑm nɔ́ símisinɛ rɛ in n lɑ úu yɛ́ yisi ukɛ́ ɑ u pɑ rɛ u uusɑnɛ nnyɑ, ɑmɑ́ u yɛ́ yisi uu lɛ̃ nnɛ́í kɑi u m pisɛ u pɑ rɛ uusɑnɛ yɛ picɔ́ŋ u nɔŋ́lɛ̃ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Nɛ̃́ nɛ nɔ́ tee rɛ: Ani yɛ we, pi yɛ́ nɔ́ hɛ, ɑni yɛ wɛ́ɛ́si, nɔ́ yɛ̃́, ɑni yɛ rikóḿkóḿ, pi yɛ́ rinɔnɔɔ nɔ́ hɑ́nnɛ. ");
INSERT INTO soy_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Likumúŋɛ́ rɛ usoi uyɛɛ n we kɑpi yɛ hɛ, uyɛɛ n wɛ́ɛ́si yɛɛ yɛ yɛ̃, uyɛɛ rinkóḿkóḿ kɑpi yɛ hɑ́nnɛ. ");
INSERT INTO soy_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Nɛ́ɛ usɑ́ɑ úye kɛwɑ̃́ kɛɛ yɛ́ nkpíntomɛ́ u we, uu pɛɛ iwɑ́ɑ kɛ pɑ? ");
INSERT INTO soy_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Nɛ́ɛ úye yɛɛ yɛ́ ukɛwɑ̃ inɑ̃ hɛ, kɛn tipele u n we? ");
INSERT INTO soy_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ḿpɑ́ nɔ́ pikpɑ́ɑ́ree mpí, nɔ yɛ felɛ ɑni nɔ́sinɛ́pipi lisɔnɛ hɛ. Nɔ́ pɛɛ rɛ urɔ́sɑ́ɑ yɛɛ kɛyómɛcɑɑ-pɔ ń we yɛɛ yɛ́ pɛɛ mɛníŋɛ pɛpɛɛ Nfɑ́ɑsɔnɛ u m pisɛ pihɛɛ riyɑ́ɑ́? ");
INSERT INTO soy_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Kɛyɑ́ɑ kɛnyinɛ kɛ Yeesu uú we un kuníri kunyinɛ kpɛɛ utisi unyinɛ nsímɛ́ ḿ pɔɔnɛsɛlɛ̃ lɑkɑsɛ. Kɑku ń le, utisi uyɛ̃ uu nsímɛ́ loni ɑi pisoi pɛɛ n cɑ́pinɛlɛ̃ mɛyíkíyiki nnɔ́ɔ yipu. ");
INSERT INTO soy_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Amɑ́ pikɛcɔpɛ pinyinɛ ɑpí mɑɑ rɛ: Aníri uyɔɔpi Pɛlisepulɛ nnɑŋɛ kuu yɛ nɛ ɑníri lɑkɑsɛ! ");
INSERT INTO soy_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Amɑ́ picɔ pɔ́ɔn lɑ pikɛ́ ripinɛ u wɑ, ɑpi pɛɛ u pisɛ rɛ ukɛ́ mɛwɑisɑŋɑ mɛnyinɛ wɑ ukɛ́ nɛ nyísɛ rɛ Uléécɑɑ kɛ́mɛɛ kuu léeri. ");
INSERT INTO soy_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Amɑ́ Yeesu pɔ̃́ nɛ pɛɛ pikɛmúŋɛ́ nyulɛ. Uu pɛɛ pi mɑɑ rɛ: Kuyɔ́ɔpiyu kunyinɛ pisoi pin pimɛcɔpɛcirɛ n tɔpu, ku yɛ kpulɛ, kusiyɔ ɑsi kɛsɛ kɛsɛ lólɛsi. ");
INSERT INTO soy_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Lɛ̃ nnyɑ in tɛ Setɑni yɛ nɛ umɛcirɛ tɔpu, íye kɛ ukuyɔɔpiyu ɑku yɛ́ pɛɛ fe ɑkú nɛ n we? Nɔ mɑɑ rɛ Pɛlisepulɛ nnɑŋɛ kɑḿ nɛ ɑníri lɑkɑsɛ nnyɑ kɑm lɛ̃ mɑ. ");
INSERT INTO soy_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","In tɛ Pɛlisepulɛ yɛɛ ńnɑŋɛ nɛ́ hɛ kɑḿ nɛ ɑníri lɑkɑsɛntɛ, wóo pɛɛ nɔ́pinɛ́kɔ́ pɔ̃́ ńnɑŋɛ hɛ kɑpí nɛ ɑ lɑkɑsɛntɛ? Ani n nyu rɛ nɔ́pinɛ́kɔ́ cirɛ pɛɛ nɔ́ nyísɛnɛ rɛ ɑ́ni ɑlɑri mɑ́. ");
INSERT INTO soy_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Asei kɛcɑ́ɑ́, Uléécɑɑ nnɑŋɛ kɑḿ nɛ ɑníri lɑkɑsɛntɛ. Lɛlɛɛ nyísɛlɛ̃ tɛ Uléécɑɑ iyɔɔpi yɛ nɔ́kɛnɛ́mɛɛ pituimɛ mɑsilɛ. ");
INSERT INTO soy_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Usoi nɑŋɛ-nɑŋɛ un itɔpilũ m mɑ́ un nɛ ukɛyɔ m mɛ̃́, úkɑ úu yɛ́ fe ukɛ́ ulikɔ́ linyinɛ yɑ́ɑ́i. ");
INSERT INTO soy_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Amɑ́ unyinɛ un ńnɑŋɛ u n feriyɛ, liute yɛ̀ɛ̀ uitɔpilũ iyɛ̃ kuú pɛɛ́ nɛ n tɑ́lɛ̃ yɔsilɛ uu umɛmɑ́ mɛ̃ kpísi uu hɔ́ɔ́nɛntɛ. ");
INSERT INTO soy_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Nkó yɛɛ úu kɛnɛ́cɑ́ɑ́ n kpɑ́lɛ̃ yɛ ilɑ́ɑrɔ nɛ́ wɑilɛ, nkó yɛɛ úu picɑ́pinɛ nɛ́ n lɛ́ni yɛ hɑrɛsilɛ. ");
INSERT INTO soy_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Kuníri kun usoi kɛ́mɛɛ́ n le, kɛlõ kóimɑ kɛnyinɛ-i kɑku yɛ hɑ n kerɑɑi kun kɛwéntɛ wɛ́ɛ́si. Kunsɑ́ kɛwéntɛ n yɛ̃, ku yɛ kukɛfɑ-i mɑɑ rɛ: Nɛ kɛnɛ́yɔ kpurɛ kɑm n tíyɛmɛ-i pɛlɛnɛ. ");
INSERT INTO soy_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Kun m pɛɛpɔ, ɑku kɛ́yɔ lɛɛpɔ kɛn pééilɛ̃ kɛn kɔ nyɔ́ɔnsɛlɛ̃ cɑ́kɑ́-cɑ́kɑ́. ");
INSERT INTO soy_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Kei kɑku yɛ pɛɛ́ hɑ kuɑcɔ ɑsɛɛi nyɛɛ kuricuruu rikpɑ́kɑ́rɑ́ ń fe kpíipɔ ɑɑ́ nɛ kɛ́yɔ kɛ-i tonɛ. Lɛlɛɛ yɛ tíyɛsɛ kɛ liute uyɛ̃ mɛwee fɑlɛ ɑmɛ yɛ n cɑɑilɛ̃ ɑmɛ mɛkpurɛ mɛ-i kuú pɛɛ ń we tɔ́su. ");
INSERT INTO soy_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Kɛ Yeesu uu lɛ̃ pisímɛ́ ḿ mɑsí, unɔ́si unyinɛ uu riwúí kɛcɔpɛ mɑɑri rɛ: Unɔ́si uyɛ̃ kɛfɑ-i kɑɑ n tónɛ uu kɔ pɔ́ nyɛnsɛ yɛ únɑrɛkomɛ lɛ. ");
INSERT INTO soy_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yeesu uu rinɔ́ɔ u yɔ́su rɛ: Pɛpɛɛ yɛ Nléécɑɑsimɛ́ kutu rińcɔ ɑpi lɛ̃ knn m pisɛ tiki pɛɛ mɛníŋɛ pínɑrɛkomɛ. ");
INSERT INTO soy_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Kumúŋɛ́ kpɛ-i kɛ ɑsoiwuí ɑɑ Yeesu n kɑ́lɑɑlɛ̃, Yeesu uú mɑɑ rɛ: Nfɑ́ɑni kɛtẽ nkɛ́ pisoi yɛ cɑɑilɛnlɛ hɑ́i. Pi mɛwɑisɑŋɑ kórulɛ. Mɛwɑisɑŋɑ mɛ̃ kɛ ɑntepu Yonɑɑsi uu n yɛ̃́ mɛnyinɛcɔ kɑpi yɛ́ kɔ yɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Yɑrɛ kɛ Yonɑɑsi uu Niniifi pikɔ́ mɛwɑisɑŋɑ n nyísɛ, limɛcɔ kɛ Usoi Kɛpipi ɑkɛ yɛ́ nfɑ́ɑni kɛtẽ nkɛ́ pisoi mɛ nyísɛ. ");
INSERT INTO soy_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Kɛyɑ́ɑ kɛ̃ kɛ Uléécɑɑ uú nɛ pisoi n túhɑɑnɛnɛ, unɔ́siyɔɔpi yɛɛ Sɑɑpɑ kɛtẽ kɛcɑ́ɑ́ n tṹ yɛ́ hɑ yisi, uu nfɑ́ɑni kɛtẽ nkɛ́ pisoi ɑkópɛ pɑ. Li we rɛ uyɛɛ pɛɛ hɑ́i kɛtẽ kɛtɔ-pɔ leemɛlɛ uú weri rɛ ukɛ́ Sɑlomɔɔ mɛwɛ́ɛ́sɛsɔhɔ kõ. Uyɛɛ kɔ nté nní ń we yɛ kɔ pɛɛ Sɑlomɔɔ felɛ! ");
INSERT INTO soy_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Niniifi pikɔ́ yɛ́ hɑ kɛyɑ́ɑ kɛ̃ yisi, ɑpi nfɑ́ɑni kɛtẽ nkɛ́ pisoi ɑkópɛ pɑ. Li we rɛ kumúŋɛ́ kpɛ-i kɛ Yonɑɑsi uú pɛɛ Nléécɑɑsimɛ́ rin-yóó ɑpi kóm, pi pɛɛ mɛfinɛ consɛlɛ. Uyɛɛ nté nní ń we yɛ kɔ pɛɛ Yonɑɑsi felɛ. ");
INSERT INTO soy_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yeesu uu kɔ rɛ: Úkɑ úu yɛ kɛ́firɑ́ɑ risɛ́ uu kɛ pésu nɛ́ɛ uu kucɑ́ri kɛ kipi, ɑmɑ́ kɛlõ cɑ́cɑ́ kuu yɛ kɛ ritɔsi rɛ pɛpɛɛ n lompɔ pikɛ́ mɛtɛ́í yɛ̃́ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ipɔ́nípɛɛ yɛ ipɔ́piŋɛ kɛfirɑ́ɑ lɛ. Ipɔ́nípɛɛ in n nyɑ́ni ńsɔnɛ, ipɔ́piŋɛ nnɛ́í kɑi yɛ n kpɑ̃́iilɛ̃, ɑmɑ́ ipɔ́nípɛɛ insɑ́ ńsɔnɛ n nyɑ́ni, kuŋmɑhɑ-i kɛ ipɔ́piŋɛ ii yɛ́ n we. ");
INSERT INTO soy_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Lɛ̃ nnyɑ ɑ mɛpɔ́círɛ tĩ, mɛtɛ́í mɛɛ kɛpɔ́mɛɛ ń we ɑ́mɛ kɑpɛ nɛ riŋmɑhɑ rimpɔ́lɔ́ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ipɔ́piŋɛ nnɛ́í in mɛtɛ́í m mɑ́ kɛ ikɛlõ kɛ́kɑ ɑ́kɛ kuŋmɑhɑ-i we, innɛ́í yɛ́ mɛtɛ́í-i m pɔlɔlɛnlɛ yɑrɛ lɛ̃ kɛ kɛ́firɑ́ɑ ɑkɛ yɛ nɛ kɛmɛtɛ́í nnɛ́í pɔ n kpɑ̃́iilɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Kɛ Yeesu uu ń we un símisi, Ufɑrisi unyinɛ uu ukɛyɔ-i u séi rɛ pikɛ́ kɛsẽ́ ilukɛ li. Yeesu uu lompɔ uu pilukɛ kɑ́pɑ́ɑ́. ");
INSERT INTO soy_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ai Ufɑrisi uyɛ̃ pírí wɑi kɛ Yeesu uú nɛ n le úu kɔ pɛɛ ɑnípɛ nɑlɛ kɛlenɛ yɑrɛ kɛ piinyɛkii ii m pisɛ. ");
INSERT INTO soy_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Upíimɑ uu pɛɛ u mɑɑ rɛ: Lɛ̃ kɛ nɔ̃́ Pifɑrisi ɑni ń we yɛ lɛ̃. Kɛpóripi nɛ ricɑ́ripi kɛpirɛ kɑni yɛ hɛɛrɛ, ɑmɑ́ nɔ́sinɛ́fɑ kɛ́mɛɛ, piyɑɑ nɛ mɛwɑi kópɛ nfɑsimɛ́ mɛɛ yipɑɑlɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Nɔ piníri lɛ. In nɛ Uléécɑɑ yɛɛ kɛpirɛ n wɑ cirɛ yɛɛ kɔ kɛmɛ́ɛ wɑɑ? ");
INSERT INTO soy_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Lɛ̃ nnyɑ, ɑni lɛlɛɛ nɔ́sinɛ́póripi nɛ nɔ́ɑnɛ́cɑ́ripi-i ń we píwɛkɔɔ́ hɛkɛsi, li yɛ́ pɛɛ ḿpɑ́ yo nɔ́ sɔnukusɛ. ");
INSERT INTO soy_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Nɔ̃́ Pifɑrisi, íwɛ kɑni topori! Nɔ yɛ iyɛ́hɛ yɑrɛ mɑnti nɛ ruu nɛ ɑyɛ́hɛpɛi ncɔpuri ripɛ́nɛlɛ ɑni hɔ́ɔ́nɛ ɑwɛ́lɛ́ kɛfi, ɑni kuwɛ́lɛ́ kusɛ Uléécɑɑ pɑ. Amɑ́ ɑ́ni pɛɛ Uléécɑɑ ɑsei nɛ unlɑ wɑisɛlɛ̃. Lɛ̃ kɑi kɔ pɛɛ m pisɛ rɛ ɑni n wɑi nɔn kɔ pɛɛ́ nɛ litɔ́rɔɔ kɛcɑ́ɑ́ léisɛlɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Nɔ̃́ Pifɑrisi, íwɛ kɑni topori. Síyukɔɔ́tonɛ kɑni yɛ ɑyómɛyɑ́hɑɑlee-i n lɑ. Nɔ kɔ lɑ pikɛ́ yɛ kɛ́yɑɑ́lɑ-i nɔ́ n yɑ́hɑɑnkɛɛ. ");
INSERT INTO soy_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Íwɛ kɑni topori! Nɔ we yɑrɛ ihórɛ iyɛ̃ kɛcɑ́ɑ́ kɑpi n sɔ́nɛ ɑ́pi kɔ pɛɛ ikɛcɑ́ɑ́ nyu. ");
INSERT INTO soy_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Isé ucélɑɑ usɛ uu u mɑɑ rɛ: Sɑ́ɑ, pɔn lɛ̃ n símisi, tɔ̃́ kɑɑ kɔ lɛ̃ lɑ́misi. ");
INSERT INTO soy_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yeesu uu rinɔ́ɔ yɔ́su rɛ: Nɔ̃́ isé picélɑɑ, íwɛ kɛ nɔ́ɔ kɔ topori! Ncɔni mulɛ-mulɛ kɑni yɛ picɔ cɔnsɛ, ɑ́ni yɛ kɔ pɛɛ ḿpɑ́ fíí nɛ nɔ́kɛnɛ́nípɛpi ricɑ. ");
INSERT INTO soy_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Íwɛ kɑni topori! Akpíí sɔnɛ kɑni yɛ ɑntepuyɛ kɛ nɔ́pinɛ́sɑ́ɑyɑhɑ ɑpi n kṍ mɔ́mti. ");
INSERT INTO soy_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Nɔ́mɛnɛ́wɑi mɛɛ nyísɛlɛnlɛ rɛ lɛ̃ kɛ nɔ́pinɛ́sɑ́ɑyɑhɑ ɑpi n wɑ yɛ nɛ nɔ́ risɑ́lɛ, likumúŋɛ́ rɛ pi ɑntepuyɛ kónlɛ, nɔ́ɔ piɑkpíí mɔ́mti. ");
INSERT INTO soy_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Lɛ̃ nnyɑ kɛ Uléécɑɑ uú pɛɛ́ nɛ umɛwɛ́ɛ́sɛsɔhɔ mɑɑ rɛ: Nɛ̃́ Uléécɑɑ, nɛ́ ɑntepuyɛ nɛ pitumɛ pi pɑ, ɑpi pikɛcɔpɛ picɔ kóni ɑpi picɔ íwɛ wɑi. ");
INSERT INTO soy_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Kɑi nní lɛ̃, nfɑ́ɑni kɛtẽ nkɛ́ pisoi pɛɛ yɛ́ ɑntepuyɛ pɛɛ hɑ́i kɛtẽ kɛkorɑɑnɛ-mɛ n kpí nkpɔ nnyɑ ɑkpɑnii yɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Kɑi n kpíimɛ Apɛɛli nkpɔ-mɛ hɑ́i nɛ Sɑkɑrii kɑpi kɛnyɔ́ɔnsɛhúúpi nɛ Uléécɑɑ kɛyɔ kɛpɑ́ɑ́pɑ́ɑ́ ń kpu nkpɔ-pɔ. Asei kɑm nɔ́ símisi, nfɑ́ɑni kɛtẽ nkɛ́ pisoi mpí kɑpi ɑntepuyɛ pɛ̃ nkpɔ riwomɛ kórunɛ. ");
INSERT INTO soy_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Íwɛ kɑni topori, nɔ̃́ isé picélɑɑ! Nɔ rinɔnɔɔ tɛ̃ kɑpi yɛ nɛ rintíki ɑpí nɛ Uléécɑɑ céru kɛhɑ́nnɛ lesɛlɛ, nɔ̃́ ɑ́ni kɔ pɛɛ fenɛ nɔkɛ́ lompɔ, ɑni kɔ pɛɛ pɛpɛɛ pilompɔ ń lɑ ncée tɑ́pisi. ");
INSERT INTO soy_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Kɛ Yeesu uu kɛlõ kɛ-i n yisi, isé picélɑɑ nɛ Pifɑrisi ɑpí nɛ u wɔ́ɔsi, ɑpi isímɛ́ mpehẽ mpehẽ kɛcɑ́ɑ́ u m písɛisɛ. ");
INSERT INTO soy_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Api ɑpinɛ u n wɑpisi rɛ ukɛ́ nkópɛ nnyinɛ mɑlɛ. ");
INSERT INTO soy_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Kumúŋɛ́ kpɛ-i, pisoi ɑpi cɑ́pinɛ kulúi, ɑi tulu ricuruu pin ɑ́nɑ cɔpɑɑnɛ. Yeesu uu pɛɛ mɛfoí upipirɛtiki mɑɑ rɛ: Ani nɔ́mɛnɛ́círɛ tĩ nɛ Pifɑrisi nkpɔ́nɔ́tɔ pitɛ. Lɛlɛɛ rɛ pi kɛcɑ́ɑ́ kɛcɑ́ɑ́ mɛwɑi yɛ mɛ. ");
INSERT INTO soy_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Lɛ̃ nnɛ́í lɛɛ m pékɑɑlɛ̃ nɛ lɛ̃ nnɛ́í kɛ úkɑ úu n nyu yɛ́ kɑm ɑi mɛtɛ́í kɛ́mɛɛ léeri, ḿpɑ́ úye uu li yɛnu uu kɔ li ceru. ");
INSERT INTO soy_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Lɛ̃ nnyɑ, lɛ̃ kɑni yɛ́ mɛyɑɑ ḿ mɑlɛ, mɛtɛ́í-i kɑpi yɛ́ li kõ. Lɛ̃ nnɛ́í kɑni yɛ́ ɑlee kɛ́mɛɛ picɔ ɑtu-i rinwɛ́íwɛ́í, ɑlee nɛ itúhɑɑ kɛcɑ́ɑ́ kɑpi yɛ́ kɛyɑ́ɑ li riyóó. ");
INSERT INTO soy_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Nɛ nɔ̃́ pinɛ́sɑ́nɛ símisi rɛ: Áni kɑpɛ pɛpɛɛ yɛ usoi ń kpu, ɑmɑ́ ɑ́pi yɛ pɛɛ fe pikɛ́ linyinɛ licɔ wɑ n wuru. ");
INSERT INTO soy_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Kɛ́ nɔ́ céési uyɛ̃ kɑi m pisɛ rɛ nɔkɛ́ n wuru. Uléécɑɑ yɛɛ yɛ n fe uu usoi kopu, uu limɛmɑ́ɑ́ nnɑ tɛnɛcirɛ́ kɛ́mɛɛ u sɑ́pɔ kɑi pisɛ rɛ nɔkɛ́ n wuru. Ɛɛɛ, nɛ nɔ́ mɑɑ rɛ uyɛ̃ kɑi pisɛ rɛ nɔkɛ́ n wuru. ");
INSERT INTO soy_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","In nɛ sítɑnkɑ́ sitɛ́ kɑpi yɛ nɛ sinúipi yukɛ-yukɛ sinupũ lɔɔ? Ḿpɑ́ nɛ lɛ̃, Uléécɑɑ úu yɛ kɛ́kɑ kɛcɑ́ɑ́ pɑlɛi. ");
INSERT INTO soy_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Pi nɔ́nnɛ́nyúpi nnɛ́í ricuruu kɛɛnlɛ. Iwɑmɛ íi kɑpɛ yɛ nɔ́ wɑ. Nɔ Uléécɑɑ inipɛɛ-i ríyu mɑ́lɛ lin sinúipi yukɛ-yukɛ kulúi fe. ");
INSERT INTO soy_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Nɛ nɔ́ mɑɑ rɛ: Úye un pisoi kɛcɔpɛ n ŋmurɛi rɛ u unɛ́kɔ́ lɛ, nɛ̃́ Usoi Kɛpipi ricuruu yɛ́ Uléécɑɑ pileecɑɑtumɛ-i ŋmurɛi rɛ nɛ́ɛ u te. ");
INSERT INTO soy_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Amɑ́ úye un pisoi kɛyu-i n kɛsi rɛ úu nɛ́ nyu, nɛ̃́ Usoi Kɛpipi ricuruu yɛ́ Uléécɑɑ pileecɑɑtumɛ-i kɛ́si rɛ ɑ́m liute nyu. ");
INSERT INTO soy_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Úye un Usoi Kɛpipi ricuruu kɛcɑ́ɑ́ nkópɛ n símisi, pi yɛ́ ɑkópɛ nyɛ̃ liute sɑ́rɛi, ɑmɑ́ úye un Nfɑ́ɑsɔnɛ n lɑ́misi, liute ɑkópɛ ɑ́ɑ kusɑ́rɛi we. ");
INSERT INTO soy_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Pin píyei nɔ́ n tɔrɔi rɛ pi nɛ ɑyómɛyɑ́hɑɑlee-i nɛ́ɛ piyɔ́ɔpi-i nɛ́ɛ kuyu piwɛ́ɛ́sɛ-i pitúhɑɑnɛ nɔ́ sĩ́, ɑ́ni kɑpɛ pírí tónɛ nɛ mmɛ̃ kɑni yɛ́ hɑ ḿ mɑlɛ nɔkɛ́ nɛ kɛtɑhɑi ń le. ");
INSERT INTO soy_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Nfɑ́ɑsɔnɛ mɛɛ yɛ́ kumúŋɛ́ kpɛ-i mmɛ̃ kɑi m pisɛ rɛ nɔkɛ́ mɑlɛ nɔ́ céési. ");
INSERT INTO soy_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Unyinɛ uu riwúí kɛcɔpɛ Yeesu mɑɑri rɛ: Sɑ́ɑ, ɑ unɛ́mɑ́rɛcɔ mɑɑ rɛ tɔ́ nɛ uyɛ̃ tɔkɛ́ ikúlɑnlũ kɛ urɔ́sɑ́ɑ uú nɛ rɔ́ n tíyɛ hɔɔnɛ. ");
INSERT INTO soy_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yeesu uu rinɔ́ɔ u yɔ́su rɛ: Unɛ́sɑ́nɛ, wóo nɛ́ tĩ́ tɛ kɛ́ nɔ́nnɛ́símɛ́ n túhɑɑnɛ nɛ́ɛ kɛ́ yɛ ikúlɑnlũ nɔ́ hɔ́ɔ́nɛ? ");
INSERT INTO soy_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Uu pɛɛ lɛ̃ mɛmɑ́ɑ́ pinnɛ́í mɑɑ rɛ: Ani nɔ́mɛnɛ́círɛ tĩ nɛ mɛmɑ́ nnɑ́ɑ́pí. Ḿpɑ́ usoi un íye nsɑ́ m mɑ́, ɑ́i umɛmɑ́ mɛɛ unfɑɑ tesɛ. ");
INSERT INTO soy_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Uu pɛɛ kɛnyɑ́rũ pi wɑi rɛ: Umɑ́mɑ́ unyinɛ yɛɛ pɛɛ sitẽ mɑ́ sin ilukɛ u wɑi. ");
INSERT INTO soy_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Uu músu uu nfɑsimɛ́ wɑi rɛ: Íye kɑm wɑinɛ? Kɛwɑi ɑ́kɛ nɛ nɛ́ we kei kɑm yɛ́ inɛ́lukɛ nnɛ́í n súúkɛɛ. ");
INSERT INTO soy_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Uu lɛ̃ mɛmɑ́ɑ́ umɛcirɛ mɑɑ rɛ: Nɛ ɑnɛ́símɛ forɛsinɛ ɑm ɑmɑ́ɑ mɔ́mti, ɑm kei mɛnɛ́lukɛpipi nɛ linɛ́kɔ́ tɔrɔɔ nnɛ́í súúkɛɛ. ");
INSERT INTO soy_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Am pɛɛ limɛmɑ́ɑ́ mɛnɛ́círɛ mɑɑ rɛ: Nɛ mɛyíkíyiki nkpéni ilukɛ yɛɛ yɛ́ ɑŋmɛ̃ kulúi nɛ́ n wɑ mɑ́lɛ. Lɛ̃ nnyɑ nɛ́ n wéntɛlɛ̃ nɛn le nɛn níru nɛn mpɔ́ɔnɑrɛ-i we. ");
INSERT INTO soy_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Amɑ́ Uléécɑɑ uu u mɑɑ rɛ: Pɔ́ uníri nkó! Kɛsinɛ nkɛ́ cirɛ kɛ mpɔ́fɑ́ɑ nn kɛ́tɔ wɑinɛ. Lin lɛ̃ n wɑ, wóo yɛ́ pɛɛ lɛ̃ kɑɑ nní mɛpɔ́círɛ n yikikɛɛ n te? ");
INSERT INTO soy_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yeesu uu kpɑ́ rɛ: Limɛcɔ kɑi we nɛ uyɛɛ nní mɛmɑ́ umɛcirɛ n cɑ́pinɛ, ɑmɑ́ úu pɛɛ Uléécɑɑ kɛ́mɛɛ líkɑ mɑ́. ");
INSERT INTO soy_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yeesu uu pɛɛ upipirɛtiki mɑɑ rɛ: Lɛ̃ nnyɑ kɑm nɔ́ mɑɑ rɛ ɑ́ni kɑpɛ yɛ lɛ̃ kɑni yɛ́ n li nɔkɛ́ nɛ nfɑ́ɑ m mɑ́ nɛ ilũ kɑni yɛ́ nɔ́inɛ́piŋɛ kɛcɑ́ɑ́ ń yɑ́rii nfɑsimɛ́ wɑ. ");
INSERT INTO soy_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Likumúŋɛ́ rɛ nfɑ́ɑ yɛ ilukɛ felɛ, ipiŋɛ in ilũ fe. ");
INSERT INTO soy_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ani ɑ́kpɑɑ́ŋ-kpɑɑ́ŋ tipɑí, ɑ́ɑ yɛ lukɛsi ɑ́ɑ yɛ kɔ kpɑsi, ɑ́ɑ kɛlukɛyekei mɑ́ ɑ́ɑ kɔ risímɛ mɑ́, ɑmɑ́ Uléécɑɑ yɛ ɑ kpíniilɛ. Nɔ nɛ mɛyɑ́nsei sinúipi ríyu mɑ́lɛ. ");
INSERT INTO soy_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nɔ́ úye yɛɛ yɛ́ fe uu nfɑsimɛ́ wɑi uú hɑ nɛ unfɑɑ ɑŋmɛ̃ ḿpɑ́ nkɑ́ripi kpɑ́sɛ? ");
INSERT INTO soy_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","In tɛ ɑ́ni líkɑ kuwɑi we likɛi síńsɑ́ lɛ̃ kɛ́mɛɛ, yo nnyɑ kɑni pɛɛ litɔ́rɔɔ nní kɛ́mɛɛ nfɑsimɛ́ wɑi? ");
INSERT INTO soy_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ani sicɑrɛ sɛɛ yɛ n fɛlɛsi ripɑí nkɛ̃́. Mɛfɛlɛ mɛ̃ ɑ́mɛ yɛ pikɛi píkɑ wɑ ɑ́mɛ yɛ kɔ líkɑ yóõ, ɑmɑ́ kɛ́ nɔ́ símisi rɛ ḿpɑ́ nɛ lɛ̃, uyɔ́ɔpi Sɑlomɔɔ ricuruu nɛ umɛmɑ́ nnɛ́í úu pɛɛ ilũ inyinɛ mɑ́ yɛɛ ń nyɑḿ ɑi mɛfɛlɛ mɛnyinɛ tulu. ");
INSERT INTO soy_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Nɔ́ pisoi mpí nfɑtɛnɛ ńn piyɛ. In tɛ Uléécɑɑ yɛ mɛyúi mɛɛ nɛni kɛcɑrɛ-i ń we pin kɔ kóso nnɑ mɛ ŋmɑɑsinɛ lɛ̃ sɔnukusɛ, nɔ̃́ kɛcɑ́ɑ́ kúu yɛ́ mɛníŋɛ ripɑíí? ");
INSERT INTO soy_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Áni kɑpɛ nɔ́mɛnɛ́círɛ nfɑsimɛ́ tɑ̃ tɛ yo kɑni yɛ́ li nɛ́ɛ yo kɑni yɛ́ n ntí. Lɛ̃ ɑ́i kɑpɛ nfɑsimɛ́ nɔ́ n we. ");
INSERT INTO soy_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Pɛpɛɛ ɑ́pi Uléécɑɑ m pɑkɑrɛlɛ̃ pɛɛ lɛ̃ likɔ́ mɛsɛ́rɛ wɛ́ɛ́si. Amɑ́ Nɔ́unɛ́sɑ́ɑ yɛɛ kɛyómɛcɑɑ-pɔ ń we yɛ nyulɛ lɛlɛɛ nɔ́ ḿ pɑ́rílɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Uléécɑɑ iyɔɔpi kɑni yɛ́ mɛníŋɛ wɛ́ɛ́si, uu pɛɛ litɔ́rɔɔ nní nnɛ́í mpuri nɔ́ hɛ. ");
INSERT INTO soy_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Yeesu uu kɔ upipirɛtiki pimɑ́ɑ kpɑ́ rɛ: Áni kulúi we, ɑmɑ́ iwɑmɛ íi kɑpɛ nɔ́ wɑ. Li we rɛ Nɔ́unɛ́sɑ́ɑ yɛ lɑ rɛ ɑni uiyɔɔpi kɛ́mɛɛ lompɔ. ");
INSERT INTO soy_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ani nɔ́linɛ́kɔ́ yɑ́lisi ɑni lisiwóó píwɛkɔɔ́ hɔ́ɔ́nɛntɛ. Ani ɑwóólɔɔ kpɔcirɛ́ mulɛi, ɑni nɔ́mɛnɛ́círɛ mɛmɑ́ cɑ́pinɛ kɛyómɛcɑɑ-pɔ, kei kɑ́mɛ píkɑi m pɔlunɛ. Piyɑɑ ɑ́pi píkɑi mɛ cɑnɛ, ɑpɑpi ɑ́ɑ kɔ mɛ cɑɑinɛ. ");
INSERT INTO soy_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Likumúŋɛ́ rɛ kei kɛ nɔ́mɛnɛ́mɑ́ ɑmɛ ń we, kei kɛ nɔ́nnɛ́fɑsimɛ́ nn yɛ n we. ");
INSERT INTO soy_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ani nɔ́mɛnɛ́círɛ n cɑ́pinɛlɛ̃ nɔn nɛ we, ɑni nɔ́ɑnɛ́tɑmpɑ́lɑ sihɑlɛ n télɛ̃, ɑni nɔ́sinɛ́firɑ́ɑ n sɛ́lɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ani pikɛikɔ́ pɛɛ piuyɔsɑɑ m mɛ̃́ mɛcɔ n we. Pinɔ́sikpikɛ́ ɑnyɑ̃́ kuu léérinɛ ukɛ́ rinɔnɔɔ rikóḿkóḿ nɔkɛ́ mɛsɛ nɛ mɛsɛ u hɑ́nnɛ ukɛ́ lompɔ. ");
INSERT INTO soy_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Pínɑrɛkomɛ yɛ pi, pikɛikɔ́ pɛ̃ kɛ ukɛisɑɑ uu yɛ́ n lɛɛmɛ pin nɛ nyɑ́ni. Asei kɑm nɔ́ símisi, u umɛcirɛ nyɔ́ɔnsɛnɛ uu pi tonsɛ, uu ilukɛ pi wɑi rɛ pikɛ́ li. ");
INSERT INTO soy_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Un kɛsinɛcɔ nɛ likɛpirɛ n kɑ uu pi lɛɛri pin nyɑ́ni, pínɑrɛkomɛ yɛ pi. ");
INSERT INTO soy_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ani ńsɔnɛ ceri rɛ in tɛ kɛ́yɔ usɑɑ yɛ pɛɛ nyu ituŋɛ iyɛ-i kɛ uyɑɑ uu n sɔ́nti, u yɛ́ pɛɛ́ n nyɑ́nilɛ úu yɛ́ tíyɛ uyɑɑ ukɛ́ kulee fori ukɛ́ lompɔ. ");
INSERT INTO soy_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Nɔ́ɔkɛ́ nɔ́mɛnɛ́círɛ mɛsɛ́rɛ n cɑ́pinɛlɛ̃ nɔn nɛ mɛ̃́. Kumúŋɛ́ kpɛ-i kɑ́ni nɛ m músu kɛ Usoi Kɛpipi ɑkɛ pɛɛri. ");
INSERT INTO soy_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Piyɛɛ uu pɛɛ u mɑɑ rɛ: Upíimɑ, yɑrɛ tɔ̃́ ŋmɑnɛ nnyɑ kɑɑ kɛnyɑ́rũ nkɛ́ wɑ nɛ́ɛ nɛ pisoi tɔrɔɔ nnɛ́í? ");
INSERT INTO soy_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Upíimɑ uu rinɔ́ɔ yɔ́su rɛ: Wóo we yɑrɛ ukɛikɔ́ yɛɛ ɑsei n tíkilɛ̃ un kɔ mɛwɛ́ɛ́sɛsɔhɔ mɑ́? Uyɛɛ ukɛikɔ́ uyɛ̃ kɛ úyɔsɑɑ uu yɛ́ nɛ kɛ́yɔ rin-yɑ́ rɛ ukɛ́ kɛ m pɑílɛ̃, uu yɛ upikɛicɔ ilukɛ pɑ kumúŋɛ́ kpɛ-i kɑi m pisɛ. ");
INSERT INTO soy_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","In tɛ úyɔsɑɑ yɛ ukɛikɔ́ uyɛ̃ lɛɛmɛ un mɛsei upikɛi kɛcɑ́ɑ́ we, u únɑrɛkomɛ lɛ. ");
INSERT INTO soy_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Asei kɑm nɔ́ símisi: Úyɔsɑɑ yɛ ulikɔ́ nnɛ́í u múísɛnɛ rɛ ukɛ́ likɛcɑ́ɑ́ m pɑílɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Amɑ́ ukɛikɔ́ uyɛ̃ un umɛcirɛ m mɑɑ rɛ: Unɛ́yɔsɑɑ mɛkɑmɛ yɛ nɑ́ŋɑilɛ. Un upikɛicɔ pikpɑ́fii rinkɑ́pɑ́ɑ́, un le un pom, ");
INSERT INTO soy_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","kɛyɑ́ɑ kɛ̃ nɛ ituŋɛ iyɛ̃ kúu nɛ m músu kɛ́mɛɛ kɛ úyɔsɑɑ uú hɑ sɔ́nti. Kei kuu yɛ́ pɛɛ ukɛikɔ́ uyɛ̃ lɑkɑsɛ uu íwɛ u wɑi yɑrɛ kɑpi yɛ pɛpɛɛ ɑ́pi ɑsei n tíkilɛ̃ n wɑ mɛcɔ. ");
INSERT INTO soy_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ukɛikɔ́ nkó yɛɛ uuyɔsɑɑ mɛpɔɔlɑ n nyu, ɑmɑ́ úu kɔ pɛɛ píkɑi umɛcirɛ cɑ́pinɛnɛ ukɛ́ nɛ n we, úu kɔ pɛɛ uuyɔsɑɑ mɛlɑ wɑinɛ, pi yɛ́ liute mɛyɑ̃́ fɑpii. ");
INSERT INTO soy_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ukɛikɔ́ nkó yɛɛ úu úyɔsɑɑ lilɑlɑ n nyu uu pɛɛ ncɑɑi mɛɛ nɛ ipépi n sɑ́ wɑi, pi yɛ́ liute fíí fɑ́pii. Pin úye mɛyɑ̃́ m pɑ, mɛyɑ̃́ kɑpi liute pisɛnɛ, pin úye mɛyɑ̃́ timmúísɛ, mɛyɑ̃́ kɑpi liute kórunɛ. ");
INSERT INTO soy_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yeesu uu pimɑ́ɑ kpɑ́ rɛ: Nɛ kɑlɛ kɛ́ kɛtẽ kɛcɑ́ɑ́ nnɑ risɛ́. Li nkpɑ́ni yɑrɛ nkɛ́ pɛɛ pisɛ́ mɑ́ɑ́lɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Li kɔ pisɛ rɛ kɛ́ míni wolɛ. Lɛlɛɛ íwɛ iyɛ̃ kɑm n lenɛ. Mɛyíkíyiki kɑḿ lɑ rɛ liituŋɛ iyɛ̃ ikɛ́ pɛɛ pitulɛ m mɑ́ɑ́lɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Nɔ músu rɛ nkíŋniŋɛ kɑḿ nɛ kɛteni-i kɑɑ? Nɛ nɔ́ mɑɑ rɛ “ɑɑí”, ɑmɑ́ pikériinɛ kɑḿ nɛ nɔ́ kɑ. ");
INSERT INTO soy_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kɑí nɛ nɛni rimpɑ́, kɛ́yɔ kɛɛ pisoi pinupũ m mɑ́ yɛ́ rikénɛ, kuwɛ́lɛ́ kusɛ pitɑɑni, kuwɛ́lɛ́ kucɔ pitɛ́, pin nɛ tɔpu. ");
INSERT INTO soy_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Usɑ́ɑ yɛ́ nɛ ukɛpipi tɔ, kɛpipi pɔ́ɔ kɔ nɛ usɑ́ɑ tɔpu, úni uú nɛ uukpére tɔpu, ukpére pɔ́ɔ nɛ úni tɔpu, unyɑ́ɑni uú nɛ ufɔsi tɔpu, ufɔsi pɔ́ɔ nɛ unyɑ́ɑni tɔpu. ");
INSERT INTO soy_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yeesu uu kɔ pisoi pɛɛ n cɑ́pinɛlɛ̃ pimɑ́ɑ kpɑ́ rɛ: Kɑni yɛ ɑhopɛ n yɛ̃́ ɑn kɛtuŋɛlolɛ́-mɛ̃ leeri, nɔ yɛ mɛsɛ nɛ mɛsɛ mɑɑ rɛ: “Ikónɛ yɛ cuuninɛ”. Lɛ̃ kɑi yɛ kɔ mɛsei wɑ. ");
INSERT INTO soy_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Nɔn kɔ n yɛ̃ tɛ kuyɔ yɛ ituŋɛ kumii-mɛ̃ pepuri, nɔ yɛ mɑɑ rɛ: “Kutói yɛ wɑinɛ”. Lɛ̃ kɑi yɛ kɔ mɛsei wɑ. ");
INSERT INTO soy_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Nɔ́ kɛcɑ́ɑ́ kɛcɑ́ɑ́ mɛwɑi pikɔ́ mpí! Nɔ yɛ felɛ ɑni kɛtẽ nɛ kɛyómɛ mɛconsɛntɛ ceru. Yo nnyɑ kɑ́ni pɛɛ kumúŋɛ́ nkú-i kɑri nní ń we ɑsei kómɛi mɑ́? ");
INSERT INTO soy_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Yo nnyɑ kɑ́ni yɛ pɛɛ nɔ́rinɛ́cúruu lɛlɛɛ ɑsei m mɑ́ céri. ");
INSERT INTO soy_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Usoi un tiyɔ́ɔpipoo pɔ́ n sée, nɔn nsẽ́ timpɛ́nɛ rɛ kɛtúhɑɑnɛ kɑni sĩ́, li pisɛ rɛ pɔkɛ́ riŋmɔ́ɔ́pú ɑni kómɛinɛ ncée kɛcɔpɛ, upɔ́cɛ́cɔ úu kɑpɛ nɛ utúhɑɑnɛ-i pɔ́ n hɑ, utúhɑɑnɛ ukɛ́ pisɔ́ɔ́cɑ pɔ́ rimúísɛ, pisɔ́ɔ́cɑ pɔ́ɔkɛ́ kukpɑniilee-i pɔ́ rinsɑ́pɔ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Asei kɑm pɔ́ símisi, pɔn kukpɑniilee n lõ, ɑ́ɑ leerinɛ kɑ́ɑ riwómɛ nnɛ́í n hɛ́ɛlɛ hɑ́i nɛ kɛ́tɑnkɑ́ tɔrɔɔ-pɔ. ");
INSERT INTO soy_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Pisoi pinyinɛ ɑpi kumúŋɛ́ kpɛ-i Yeesu lɛɛpɔ, ɑpi u símisi lɛ̃ kɛ uyɔ́ɔpi Pilɑti uu rinɔ́ɔ n hɛ rɛ pikɛ́ Kɑlilee pikɔ́ pɛɛ ń we pin Uléécɑɑ inyɔ́ɔnsɛ wɑi kṍ. ");
INSERT INTO soy_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yeesu uu pi mɑɑ rɛ: Nɔ músu rɛ kɛ pisoi pɛ̃ ɑpi pikópɛkɔɔ́ píimɑ ɑpi Kɑlilee pikɔ́ tɔrɔɔ tɔ́su nnyɑ kɑpi lɛ̃ pi kṍo? ");
INSERT INTO soy_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nɛ nɔ́ mɑɑ rɛ “ɑɑí”, ɑmɑ́ nɔnsɑ́ mɛfinɛ n consɛ, nɔ nɔ́nnɛ́nɛ́í kpíninɛ pimɛcɔ. ");
INSERT INTO soy_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Pisoi pitɛ́ ɑ́pi we ɑfɛɛrɛ́ pɛ̃ kɛcɑ́ɑ́ kɛ Silowee kulee cɑ́cɑ́ ɑku ń loó ɑku kóni ní? Nɔ músu rɛ piɑkópɛ nyɛɛ Yerusɑlɛm kuyu pikɔ́ tɔrɔɔ ɑkɔ́ tɔsii? ");
INSERT INTO soy_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nɛ nɔ́ mɑɑ rɛ “ɑɑí”, ɑmɑ́ nɔnsɑ́ mɛfinɛ n consɛ, nɔ nɔ́nnɛ́nɛ́í kpíninɛ pimɛcɔ. ");
INSERT INTO soy_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yeesu uu lɛ̃ mɛmɑ́ɑ́ kɛnyɑ́rũ nkɛ́ pi mɑɑ rɛ: Utisi unyinɛ yɛɛ pɛɛ kúfikiyee kunyinɛ tɑmɑɑlɛ̃ uɑfikiyee kɛcɑrɛ kɛ́mɛɛ. Uu kɛyɑ́ɑ sĩ ukɛ́ kukɛcɑ́ɑ́ ɑpipi túúnu, ɑmɑ́ úu líkɑ yɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Uu pɛɛ uléétɑmɑɑ mɑɑ rɛ: A ripɑí, ɑŋmɛ̃ ɑtɑɑni yɛ nnyɛ́ kɑm sɔ́nɑɑri rɛ kɛ́ yɛ kúfikiyee nkú kɛcɑ́ɑ́ ɑpipi túúnu ɑ́m yɛ kɔ líkɑ yɛ̃. A ku riké. Yo nnyɑ kɑku yɛ́ mɛ́woo kɛtẽ nɛ́ n cɑɑi? ");
INSERT INTO soy_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Uléétɑmɑɑ uu u mɑɑ rɛ: Sɑ́ɑ, ɑ nɔŋɔni kuŋmɛ̃ nkú pikɑŋnɛ ku rikpɑ́, nɛ́ tṹ ɑm ku kɔ́ɔ́núsɛ, ɑm pɛɛ ntɑɑi mɛɛ mɛfɛ́nɛ m mɑ́ súúni. ");
INSERT INTO soy_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Lin lɛ̃ n wɑ, in n lɑ ku yɛ́ kɛlɑɑnɛ mɑri, insɑ́ lɛ̃ n wɑ, ɑɑ ku ké. ");
INSERT INTO soy_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Kɛwéntɛyɑɑ kɛtúŋɛ́ kɛnyinɛ kɛ Yeesu uu Pisuifi kuyomɛyɑ́hɑɑlee kunyinɛ-i céési. ");
INSERT INTO soy_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Unɔ́si toikɔ́ unyinɛ un kei we. Li wɑlɛ ɑŋmɛ̃ ɑtɛ́ ɑ́ɑ we ɑfɛɛrɛ́ kɛ kuníri kunyinɛ ɑkú nɛ u n lõ kun u kpɑrɑ́sɛlɛ̃ un kɛcírɛ pinyɛrɛ pɔɔnɛlɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Kɛ Yeesu uu unɔ́si uyɛ̃ n yɛ̃́, uu u séi uu u mɑɑ rɛ: Uléécɑɑ yɛ pɔ́ pɔisɛlɛ. ");
INSERT INTO soy_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Uu ɑnípɛ ukɛcɑ́ɑ́ lɑ́ɑ, unɔ́si uu mɛsɛ nɛ mɛsɛ kɛcírɛ nyɛrɛ uu Uléécɑɑ pítɑɑ́sɛ kɑ́pɑ́ɑ́. ");
INSERT INTO soy_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Amɑ́ ɑ́i nɛ kuyómɛyɑ́hɑɑlee uwɛ́ɛ́sɛ risɑ́, kɑi n wɑ rɛ Yeesu yɛ kɛwéntɛyɑɑ kɛtúŋɛ́ usoi pɔisɛ nnyɑ. Uu pɛɛ rinɔ́ɔ yɔ́su, uu risoiwuí mɑɑ rɛ: Siyɑ́ɑ sikpuulũ kɑri mɑ́, sɛ-i kɑi pisɛ rɛ tɔkɛ́ kɛisi. Lɛ̃ nnyɑ, ɑni yɛ siyɑ́ɑ sɛ-i kɑm pikɛ́ nɔ́ pɔisɛ, ɑ́i kɑpɛ pɛɛ kɛwéntɛyɑɑ kɛtúŋɛ́. ");
INSERT INTO soy_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Upíimɑ uu pɛɛ rinɔ́ɔ u yɔ́su rɛ: Nɔ kɛcɑ́ɑ́ kɛcɑ́ɑ́ mɛwɑi pikɔ́ lɛ. Ḿpɑ́ nɔ́ úye yɛ̀ɛ̀ kɛwéntɛyɑɑ kɛtúŋɛ́ kusɛɛlee-i uinɑɑ nɛ́ɛ ukɛminɑɑ toriyɛlɛ uú nɛ kɛ́ninirɛ́ sĩ́, nɛ́ɛ ɑ́i lɛ̃? ");
INSERT INTO soy_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Unɔ́si nkó yɛɛ nní Apirɑhɑm kɛpirɛ ukɔ́ kɛ Setɑni uu n tórɑɑlɛ̃ hɑ́i ɑŋmɛ̃ ɑtɛ́ ɑ́ɑ we ɑfɛɛrɛ́-mɛ, ɑ́i pisɛ rɛ pikɛ́ kɛwéntɛyɑɑ kɛtúŋɛ́ u toriyɛɛ? ");
INSERT INTO soy_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yeesu rinɔɔ mɛyɔ́ɔ́ mɛ̃ ɑmɛ upilɑɑrɔ isɛi wɑi hɑ́i, ɑmɑ́ risoiwuí nnɛ́í ripɔɔ ɑrí nɛ umɛwɑi píimɑ kuu n wɑpisi nnɛ́í lɑrisi. ");
INSERT INTO soy_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yeesu uú mɑɑ rɛ: Yo kɛ Uléécɑɑ iyɔɔpi ií nɛ mɛnyínɛ we? Yo kɑm yɛ́ fe kɛ́ nɛ i múŋɛisɛnɛ? ");
INSERT INTO soy_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","I we yɑrɛ mpuri yukɛ-yukɛ nnyinɛ kɛ usoi uu ukɛcɑrɛ-i n lukɛsi nn lɛlu, nn kuléé wɑi, sinúipi ɑsi kuilesɛ kɛcɑ́ɑ́ ɑyɑ́mɛ́ wɑpisi. ");
INSERT INTO soy_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yeesu uu pimɑ́ɑ kpɑ́ rɛ: Yo kɑm yɛ́ fe kɛ́ nɛ Uléécɑɑ iyɔɔpi múŋɛisɛnɛ? ");
INSERT INTO soy_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Uléécɑɑ iyɔɔpi yɛ kɔ we yɑrɛ nkpɔ́nɔ́tɔ pitɛ kɛ unɔ́si uu ntɔ píimɑ kɛ́mɛɛ n cɔ́hɔnɛpɔ uu pulu pikpɛ́ɛ ɑpi yisi. ");
INSERT INTO soy_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yeesu uu ɑyu mɑɑ nɛ ɑsíńsɑ́ n tɛŋni un céési un nɛ Yerusɑlɛm-mɛ̃ sĩ. ");
INSERT INTO soy_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Unyinɛ uu u pisɛ rɛ: Sɑ́ɑ, mɛsei yɛ mɛ rɛ pisoi nkɑ́ripi kɛ Uléécɑɑ uu yɛ́ yóriyɛɛ? Yeesu uu rinɔ́ɔ pi yɔ́su rɛ: ");
INSERT INTO soy_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Ani riŋmɔ́ɔ́pú ɑní nɛ rinɔnɔɔ tɛɛ m mɔ́kú-mɔ́kúlɛ̃ loni, ɑsei kɑm nɔ́ símisi. Mɛyɑ̃́ yɛ́ nɑ́ɑ́si rɛ mɛkɛ́ lompɔ, ɑmɑ́ ɑ́mɛ kɔ fenɛ. ");
INSERT INTO soy_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Úyɔte un píyei n yisi uu rinɔnɔɔ kɑ́, nɔ́ kɛtɑhɑi nyɛrɛ, ɑni rinɔnɔɔ n komnɛntɛ nɔn mɑ́ikɛɛ rɛ: Sɑ́ɑ, ɑ rɔ́ hɑ́nnɛ! Uu rinɔ́ɔ nɔ́ yɔ́su rɛ: Ám nyu rɛ nɔ yei pikɔ́ lɛ. ");
INSERT INTO soy_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ani pɛɛ u mɑɑ rɛ: Kɛsẽ́ kɑri li ɑri níru, ɑrɔ́yu icee kɛ́mɛɛ kɑɑ tóói pɔn céési. ");
INSERT INTO soy_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Uu pimɑ́ɑ nɔ́ kpɑ́ rɛ: Ám nyu rɛ nɔ yei pikɔ́ lɛ. Ani nɛ kɛtɑɑ nɛ́ wɑ, nɔ́ pɛ̃ nnɛ́í nɔ́ɔ nní likópɛ n wɑi. ");
INSERT INTO soy_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Kei kɑni yɛ́ ténesi, ɑni ɑnĩ́ tɑkɑi kumúŋɛ́ kpɛ-i kɑni yɛ́ Apirɑhɑm nɛ Isɑɑki nɛ Yɑkupu nɛ ɑntepuyɛ nnɛ́í n yɛ̃́ Uléécɑɑ iyɔɔpi-i, ɑi pɛɛ n we rɛ kɛtɑhɑi kɑpi nɔ́ fómpɔnɛ. ");
INSERT INTO soy_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Pisoi yɛ́ kɛtuŋɛleemɛ-mɛ̃ nɛ kɛtuŋɛlolɛ́-mɛ̃ nɛ ituŋɛ kumii-mɛ̃ nɛ ituŋɛ kulukɛ-lukɛ-mɛ̃ leemɛ ɑpi weri ɑpi Uléécɑɑ iyɔɔpi kɛ́mɛɛ tonɛ ɑpi ilukɛ le. ");
INSERT INTO soy_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ai pɛɛ wɑi rɛ pɛpɛɛ nɛni nní pitɔ́rɔɔ pinyinɛ yɛ́ hɑ pifoí, pɛpɛɛ nɛni nní pifoí ɑpí hɑ pitɔ́rɔɔ. ");
INSERT INTO soy_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Kumúŋɛ́ kpɛ-i, Pifɑrisi pinyinɛ ɑpí nɛ Yeesu kɔ ɑpi u mɑɑ rɛ: A nté yisi ɑɑ kɛlõ féé sĩ. Erooti yɛ lɑlɛ ukɛ́ tíyɛsɛ pikɛ́ pɔ́ kpu. ");
INSERT INTO soy_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yeesu uu rinɔ́ɔ pi yɔ́su rɛ: Ani n ŋme ɑni hɑ kɛsɑ́ŋɑ́ mpuri mmɛ̃ mɑɑ rɛ nɛ nɛni nɛ kóso ɑníri lɑkɑsɛntɛlɛ nɛn pisoi pɔisɛntɛ kɛ́ pɛɛ kɛyɑ́ɑ tɑ́ɑ́nũ tuŋɛ́ pikɛi mpí tɛnɛsɛ. ");
INSERT INTO soy_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Li pisɛ rɛ kɛ́ nɛni kɛyɑɑ nɛ kóso nɛ likɛweeki nnɛ́cée rinɔŋ́, likumúŋɛ́ rɛ ɑ́i nɛ sɑ́ rɛ ɑntepu ukɛ́ kɛlõ féé kpu kɑ́i Yerusɑlɛm-i. ");
INSERT INTO soy_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Nɔ̃́ Yerusɑlɛm pikɔ́, nɔ ɑntepuyɛ kónlɛ ɑni kɔ pɛ̃ kɛ Uléécɑɑ uu nɔ́kɛnɛ́mɛɛ n tummɛ ɑpɑrɛ tɑpisi ɑni kóni. Mɛlɛ́ kɛsẽ kɑḿ pɛɛ́ lɑ kɛ́ nɔ́ cɑ́pinɛ kɛ́ rimúlú líkɑ ɑ́i kɑpɛ nɔ́ wɑ, nɔkɛ́ n we yɑrɛ kɛ kucɑ̃́yɑhɑ ɑku yɛ kuɑmɛ́ŋ́ mɛtene kusipipi n tɑ̃ líkɑ ɑ́i yɛ́ si wɑ mɛcɔ, ɑni yúlu. ");
INSERT INTO soy_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Lɛ̃ nnyɑ kɑi yɛ́ nɔ́kɛnɛ́yɔ riyɑ́ kɛkɛ́ mɛŋmɑnɛ n nyɛnu. Ani kõ tɛ ɑ́ni nɛni piyɛ́nɛ nɛ́ kpɑ́nɛ likɛ́ hɑ nɛ tu kumúŋɛ́ kpɛ-i kɑni yɛ́ hɑ ḿ mɑɑ rɛ: Uléécɑɑ ukɛ́ uyɛɛ Upíimɑ rinyiri nɛ n wemɛ rikpɑ́! ");
INSERT INTO soy_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Kɛwéntɛyɑɑ kɛtúŋɛ́ kɛnyinɛ, Yeesu uu Pifɑrisi uwɛ́ɛ́sɛ unyinɛ kɛyɔ sĩ tɛ ukɛ́ ilukɛ li. Pɛpɛɛ kɛyɑ́ɑ kɛ̃ kei ń we ɑpi ńsɔnɛ u m pɑílɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Utisi unyinɛ yɛɛ mɛpílɛ́ itoi m pɔ́ɔ́lú un ukɛyu-i nyɛnu. ");
INSERT INTO soy_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yeesu uu nsímɛ́ kpísi uu isé pinyuwɛ nɛ Pifɑrisi pisɛ rɛ: Irɔ́sé yɛ ncée hɛ nɛ́ɛ íi hɛ rɛ pikɛ́ usoi kɛwéntɛyɑɑ kɛtúŋɛ́ pɔisɛ? ");
INSERT INTO soy_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Amɑ́ ɑ́pi ŋmurɛi pikɛ́ rinɔ́ɔ yɔsí. Yeesu uu pɛɛ utóikɔ́ kpísi uu u pɔisɛ uu u yɑ́pɔ. ");
INSERT INTO soy_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Uu pɛɛ pi mɑɑ rɛ: In tɛ nɔ́kɛnɛ́cɔpɛ unyinɛ kɛwɑ̃ nɛ́ɛ uinɑɑ yɛɛ kɛlúkɑnkɑ-i lóipɔ, liute úu yɛ́ mɛsɛ nɛ mɛsɛ kɛ pɔɔnɛmɛ ḿpɑ́ lin kɛwéntɛyɑɑ kɛtúŋɛ́ɛ? ");
INSERT INTO soy_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Api rinɔ́ɔ piyɔ́ɔ́ u pɔɔnɛ. ");
INSERT INTO soy_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yeesu uu yɛ́nu lɛ̃ kɛ pisɑ́nɛ kɑpi n sée ɑpi sitónɛ n wɛ́ɛkɛɛ. Uu pɛɛ pinnɛ́í kɛnyɑ́rũ nkɛ́ mɑɑ rɛ: ");
INSERT INTO soy_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Usoi un pisɔ́ɔnnɛ pilukɛ pɔ́ n sée, kɑpɛ hɑ kɛtónɛ kɛcirɛ kɛ́mɛɛ tónɛ. In n lɑ, pi yɛ́ úyukɔɔ́ unyinɛ yɛɛ pɔ́ n fe n sée. ");
INSERT INTO soy_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ai wɑi rɛ uyɛɛ nní nɔ́kɛnɛ́tɛ́ n sée uú weri uu rɛ: A kɛtónɛ kɛ̃ nɛ uyɛ̃ tiyɑ́. Isɛi kɑɑ yɛ́ hɑ pɛɛ́ nɛ kɛtónɛ tɔrɔɔ-i tonɛ. ");
INSERT INTO soy_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Amɑ́ li nyɑmlɛ rɛ usoi un kusɑ́nɛ pɔ́ n sée, ɑ hɑ kɛtónɛ tɔrɔɔ-i tonɛ, likɛ́ wɑ rɛ kumúŋɛ́ kpɛ-i kɛ uyɛɛ nní pɔ́ n sée uu ń kɑ, ukɛ́ pɔ́ mɑɑ rɛ: Unɛ́sɑ́nɛ, ɑ kɛ́yu-mɛ̃ kɑm kɛtónɛ kɛcirɛ kɛ́mɛɛ. Lin lɛ̃ n wɑ, pɔ́ pɛɛ pipɔ́sɑ́nɛcɔ kɛyu-i ríyu yɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Lɛ̃ nnyɑ úye un umɛcirɛ rintɑɑ́sɛ, li yɛ u ricɛpisɛlɛ. Úye un umɛcirɛ rincɛpisɛ, li yɛ u ritɑɑ́sɛlɛ. ");
INSERT INTO soy_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yeesu uu pɛɛ uyɛɛ kusɑ́nɛ u n sée mɑɑ rɛ: Pɔn pisoi pilukɛ n séinɛ, kɑpɛ yɛ pipɔ́sɑ́nɛ nɛ kupɔ́mɑ́rɛ pikɔ́ nɛ pipɔ́pɛ́rɛcɔ pɛɛ m mɑ́ sée. Pɛ̃ nɛ́ fe ɑpi kɔ pɔ̃́ kusɑ́nɛ séi. Lin lɛ̃ n wɑ, pi lɛ̃ kɑɑ pi ḿ pɑ pɔ́ pɛsɛlɛ. ");
INSERT INTO soy_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Amɑ́ pɔn ɑnyɑ̃́ ilukɛ n wɑi, ɑ yɛ píwɛkɔɔ́ nɛ pinɑ́rɛi nɛ síkɑnkɑ́lɑ́kɑ́ nɛ pinyíyɛ sélei. ");
INSERT INTO soy_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Pɔ́ pɛɛ mpɔ́ɔnɑrɛ yɛ̃, likumúŋɛ́ rɛ pɛ̃ ɑ́pi fenɛ pikɛ́ pɔ́ li pɛsɛ. Uléécɑɑ yɛɛ yɛ́ pɔ́ li pɛsɛ kumúŋɛ́ kpɛ-i kɛ pɛ̃ nnɛ́í pɛɛ umɛlɑ n wɑpisi ɑpi nkpɔ kɛ́mɛɛ n yisinɛ. ");
INSERT INTO soy_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Anɔ́ɔ nyɛ̃ mɛkomɛ-mɑɑ́, pɛ̃ nɛ pɛ̃ pɛɛ pɛɛ kɛsẽ́ ilukɛ n le usɛ uu Yeesu mɑɑ rɛ: Uyɛɛ yɛ́ hɑ Uléécɑɑ iyɔɔpi-i ilukɛ n li yɛ únɑrɛkomɛ lɛ. ");
INSERT INTO soy_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yeesu uu pɛɛ kɛnyɑ́rũ nkɛ́ u wɑi rɛ: Utisi unyinɛ yɛɛ kɛyɑ́ɑ ilukɛ kɛcirɛ sɔ́ɔnkɛɛ uu pisoi kulúi séi. ");
INSERT INTO soy_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Kɑi pilukɛ kumúŋɛ́ n tu, uu uukɛikɔ́ tum tɛ ukɛ́ hɑ pɛ̃ kuu n sélei mɑɑ rɛ: Ani kɑm, ḿpɑ́ yo yɛ nkpéni pipele mɑsilɛ. ");
INSERT INTO soy_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Amɑ́ pinnɛ́í mmɛ̃, ḿpɑ́ úye uu uncɔ́ŋ pinyísɛ koru. Ufoí uu ukɛikɔ́ mɑɑ rɛ: Nɛ kɛcɑrɛ lɔlɛ, li kɔ pɛɛ pisɛ rɛ kɛ́ hɑ kɛ yɛ̃. Lɛ̃ nnyɑ, ɑ u mɑɑ rɛ úu kɑpɛ wɔ́ɔsi. ");
INSERT INTO soy_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ucɔ uu u mɑɑ rɛ: Nɛ inɑ́ɑ lɑmɛ-lɑmɛ kɛfi lɔlɛ, nɛ lɑ kɛ́ nɛ pikɛi i peenu. Lɛ̃ nnyɑ, ɑ u mɑɑ rɛ úu kɑpɛ wɔ́ɔsi. ");
INSERT INTO soy_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ucɔ uu kɔ u mɑɑ rɛ: Nfɑ́ɑni kɑm unɔ́si kpísi, lɛ̃ nnyɑ kɑ́m fenɛ kɛ́ hɑ. ");
INSERT INTO soy_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ukɛikɔ́ uu uuyɔsɑɑ kɛ́mɛɛ pɛlɛ uú hɑ ɑnɔ́ɔ nyɛ̃ u símisi. Ai úyɔsɑɑ kuwɔ́i wɑi uu uukɛikɔ́ mɑɑ rɛ: A mɛkɛɛ ɑyɑ́ɑ-i nɛ icée kɛ́mɛɛ hɑ, ɑɑ píwɛkɔɔ́ nɛ pinɑ́rɛi nɛ pinyíyɛ nɛ síkɑnkɑ́lɑ́kɑ́ séleiri. ");
INSERT INTO soy_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Kɑi rinkpɑ́sɛ, ukɛikɔ́ uu pɛɛri uu úyɔsɑɑ mɑɑ rɛ: Nɛ lɛ̃ kɑɑ m pisɛ piwɑi mɑsilɛ, ɑmɑ́ sitónɛ yɛ kɔ pɔɔnɛlɛ. ");
INSERT INTO soy_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Úyɔsɑɑ uu pɛɛ ukɛikɔ́ mɑɑ rɛ: A sicɑrɛyupi siceepi ritiki ɑɑ pɛ̃ kɑɑ ncée-i n yɛ́ntinɛ nɛ kɛ́yu mɑhɑni pikɛ́ kɑm, kɛnɛ́yɔ kɛkɛ́ nɛ n yi nnyɑ. ");
INSERT INTO soy_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nɛ nɔ́ símisilɛ rɛ pɛ̃ nnɛ́í kɑḿ pɛɛ nní n sélei, úkɑ úu inɛ́lukɛ lenɛ. ");
INSERT INTO soy_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Asoiwuí píimɑ ɑn Yeesu tikilɛ̃ pin nsẽ́ pɛ́nɛlɛ̃, Yeesu uu pɑnsɛpɔ uu pi mɑɑ rɛ: ");
INSERT INTO soy_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Úye un kɛnɛ́mɛɛ n kɑ, li pisɛ rɛ ukɛ́ nɛ́ n lɑ ɑi tɔ́su uusɑɑ nɛ uuni nɛ uunɔsi nɛ usiwɑ̃ nɛ upiwɑ̃ nɛ upimɑɑ nɛ upiyɛi nɛ uricuruu isoi. Insɑ́ lɛ̃ úu fenɛ ukɛ́ unɛ́pirɛtiki. ");
INSERT INTO soy_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Nkó yɛɛ úu n ŋmurɛi ukɛ́ mɛnɛ́cɔ ukunɑpɛ́ɛ́kɔɔ́ cɔ̃ ukɛ́ nɛ nɛ́ ritiki, úu nɛ sɑ́ rɛ ukɛ́ unɛ́pirɛtiki. ");
INSERT INTO soy_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","In tɛ nɔ́kɛnɛ́cɔpɛ unyinɛ yɛ lɑ ukɛ́ kulee cɑ́cɑ́ mɔ̃́, liute yɛ̀ɛ̀ tonɛlɛ uu músu, uu yɛ́nu rɛ ɑlɛ́ kɛ pikɛi pɛ̃ ɑpi wɑ, ɑi tíyɛsɛ uu céru, in tɛ usiwóó yɛ piyɛ un yɛ́ fe uu pikɛi pɛ̃ kɛtɔ tulu. ");
INSERT INTO soy_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Insɑ́ lɛ̃, un tikúi n yekei kúu pɛɛ kulee cɑ́cɑ́ pimɔ́mɛ tɛnɛsɛ, pɛ̃ nnɛ́í pɛɛ yɛ́ lɛ̃ n yɛ̃́ yɛ́ u sɛ́nnyi. ");
INSERT INTO soy_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Pi yɛ́ mɑɑ rɛ: Usoi nkó yɛ pimɔ́mɛ korɑɑnɛ ɑmɑ́ úu fe ukɛ́ tɛnɛsɛ. ");
INSERT INTO soy_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Lɛ̃ cirɛ yɛ ni, uyɔ́ɔpi úye un n lɑ ukɛ́ hɑ nɛ ucɔ tɔ, u yɛ tonɛlɛ uu músu kɛlenɛ, in tɛ u yɛ́ nɛ upisoi ɑ́kotokú kɛfi (10.000) fe uú hɑ nɛ uulɑɑrɔ yɛɛ pisoi ɑ́kotokú ɑfɛɛrɛ́ (20.000) m mɑ́ tɔpu. ");
INSERT INTO soy_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Unsɑ́ n fenɛ, u yɛ uuyɔɔpicɔ-i pitumɛ tunlɛ úu kɑhɑnɛ u n nyɑhɑimɛ, uu u pisɛ rɛ pikɛ́ kómɛinɛ pikɛ́ ɑtɔpi riyɑ́. ");
INSERT INTO soy_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Yeesu uu pimɑ́ɑ kpɑ́ rɛ: Kɑi nní lɛ̃, nɔ́ úkɑ úu fenɛ ukɛ́ unɛ́pirɛtiki, liute unsɑ́ lɛ̃ kuu m mɑ́ nnɛ́í n ŋmɛriyɛ. ");
INSERT INTO soy_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Nnyɑ́si yɛ likɛi kɛcirɛ lɛ. Amɑ́ mmɛlõ mɛn n kpu, yo kɑpi yɛ nɛ n lɑrukusɛ? ");
INSERT INTO soy_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ńn pɛɛ kɛtẽ nɛ́ɛ mɛfɛ́nɛ kɛ́mɛɛ linyinɛ yoriyɛnɛ. Pi yɛ kɛtɑhɑi n fómpɔlɛ. Úye un ukómɛ, uu kóm. ");
INSERT INTO soy_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Pilɑmpooyɔɔ́ nnɛ́í nɛ pikópɛkɔɔ́ ɑpí nɛ Yeesu kɔ rɛ pikɛ́ kutu u ricɔ. ");
INSERT INTO soy_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ai Pifɑrisi nɛ isé picélɑɑ cɔ́ŋ pin mɑ́ikɛɛ rɛ: Usoi nkó yɛ kusɑ́nɛ pikópɛkɔɔ́ séelɛ pin kɛsẽ́ le! ");
INSERT INTO soy_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yeesu uu pɛɛ kɛnyɑ́rũ nkɛ́ pi mɑɑ rɛ: ");
INSERT INTO soy_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","In tɛ nɔ́kɛnɛ́cɔpɛ unyinɛ yɛ isɑ́ŋ pílɛ mɑ́, isɛ ii pɛɛ́ nɛ u pɔlu, liute úu yɛ isɛ íi we pílɛ nnyí tíyɛ uú hɑ isɛ nnyí yɛɛ nní ḿ pɔ piwɛ́lɑɑ sĩ hɑ́i uú hɑ nɛ i yɛnuu? ");
INSERT INTO soy_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Un kɔ i n yɛ̃, li yɛ u lɑrisilɛ uu i kpísi uú yɑ ");
INSERT INTO soy_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","uú nɛ kulu, uu pɛɛ upisɑnɛ nɛ upipɛrɛcɔ sélei uu pi mɑɑ rɛ: Ani ɑnyɑ̃́ nɛ́ lɛ̃́, nɛ inɛ́sɑ́ŋ iyɛɛ pɛɛ m pɔ heeilɛ. ");
INSERT INTO soy_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Lɛ̃ cirɛ yɛ ni, nɛ nɔ́ mɑɑ rɛ ukópɛkɔɔ́ usɛ mɛfinɛ mɛconsɛ yɛ ɑnyɑ̃́ píimɑ lɛ kɛyómɛcɑɑ-pɔ ɑi tɔ́su pisɔnɛ usɛ úu we pílɛ kɑ́i m pisɛ rɛ pikɛ́ mɛfinɛ consɛ. ");
INSERT INTO soy_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Nɛ́ɛ in tɛ unɔ́si unyinɛ yɛ nwóóweni mɛpipi kɛfi mɑ́, mɛsɛ ɑmɛ pɛɛ́ nɛ u pɔlu, unɔ́si uyɛ̃ úu yɛ kɛ́firɑ́ɑ risɛ́ uu kɛ́yɔ pééi, uu ńsɔnɛ kɛ perei uú hɑ nɛ mɛpipi mɛsɛ mɛ̃ yɛnuu? ");
INSERT INTO soy_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Un píyei mɛ n yɛ̃, u yɛ upisɑnɛ nɛ upipɛrɛcɔ séleilɛ uu pi mɑɑ rɛ: Ani ɑnyɑ̃́ nɛ́ lɛ̃́. Nɛ kɛwóó kɛɛ nɛ nɛ́ ḿ pɔ heeilɛ. ");
INSERT INTO soy_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Lɛ̃ cirɛ yɛ ni, nɛ nɔ́ mɑɑ rɛ ukópɛkɔɔ́ usɛ mɛfinɛ mɛconsɛ yɛ ɑnyɑ̃́ píimɑ lɛ piléécɑɑtumɛ kɛ́mɛɛ. ");
INSERT INTO soy_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yeesu uu pimɑ́ɑ kpɑ́ rɛ: Utisi unyinɛ yɛɛ pɛɛ piŋmɑ́nɛ pitɛ́ mɑ́. ");
INSERT INTO soy_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Usíńsɑ́ uu u mɑɑ rɛ: Unɛ́sɑ́ɑ, ɑ lɛ̃ kɑḿ mɑsí mɛpɔ́kpɔ-mɑɑ́ mɛpɔ́mɑ́ kɛ́mɛɛ n yɛ́nunɛ nɛ́ pɑ. Usɑ́ɑ uu pɛɛ umɛmɑ́ pikɛtɛ́ hɔ́ɔ́nɛ. ");
INSERT INTO soy_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Kɑi siyɑ́ɑ rinkɔ́ɔ́nú, uŋmɑ́nɛ síńsɑ́ uu ulikɔ́ nnɛ́í cɑ́pinɛntɛ uú nɛ kuyu tɑɑ-tɑɑ kunyinɛ sĩ, uú hɑ kei mɛfinɛ kópɛ-i loni ɑi wɑi rɛ u umɛmɑ́ cɑɑinkɛɛ. ");
INSERT INTO soy_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Kuu usiwóó nnɛ́í pilukɛ ḿ mɑsí, nkṹ píimɑ nnyinɛ nn kuyu kpɛ̃ loni, ḿpɑ́ yo ɑí pipɑ́rí u koru. ");
INSERT INTO soy_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Uu pɛɛ́ hɑ kuyu kpɛ̃ utisi unyinɛ kɛ́mɛɛ pikɛi loni. Uyɛ̃ uu usicɑrɛ-mɛ̃ u yekei rɛ ukɛ́ uɑfɔŋ kɛcɑ́ɑ́ m pɑílɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Li yɛ pɛɛ ripɔ́ɔ u wɑ rɛ ḿpɑ́ ɑ́fɔŋpomɛ́ kuu yɛ̃́ ukɛ́ li, ɑmɑ́ úkɑ úu yɛ kɔ ɑ u pɑ. ");
INSERT INTO soy_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Uu pɛɛ nfɑsimɛ́ loni, uu umɛcirɛ mɑɑ rɛ: Unɛ́sɑ́ɑ pikɛikɔ́ nnɛ́í yɛ̀ɛ̀ lilɛ ɑpi pɔɔnɛntɛ, nɛ́ɛn nɛ nté nkṹ kpinɛ. ");
INSERT INTO soy_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nɛ unɛ́sɑ́ɑ-i pɛlɛnɛ, ɑḿ hɑ u mɑɑ rɛ: Unɛ́sɑ́ɑ, nɛ nɛ Uléécɑɑ púnnɛlɛ ɑm kɔ nɛ pɔ̃́ púnnɛ. ");
INSERT INTO soy_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ám tu rɛ pɔkɛ́ nɛ́ kpísi yɑrɛ kɛpɔ́pipi. A nɛ́ rimúlú yɑrɛ upɔ́kɛikɔ́. ");
INSERT INTO soy_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Uu yisi ukɛ́ usɑ́ɑ-i pɛlɛ. Úu kɑhɑnɛ nkpɑ́ni kɛ́yɔ nɛ rinkɔ, usɑ́ɑ uu kɛtɑɑ-pɔ u yɛnu, ɑi íwɛ u wɑi, uu wurupɔ uú hɑ u pirɑ. ");
INSERT INTO soy_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Kɛwɑ̃́ ɑkɛ pɛɛ u mɑɑ rɛ: Unɛ́sɑ́ɑ, nɛ nɛ Uléécɑɑ púnnɛlɛ ɑm kɔ nɛ pɔ̃́ púnnɛ. Ám tu rɛ pɔkɛ́ nɛ́ kpísi yɑrɛ kɛpɔ́pipi. ");
INSERT INTO soy_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Amɑ́ usɑ́ɑ uu upikɛikɔ́ mɑɑ rɛ: Ani mɛkɛɛkɛɛ nɛ kukpɛ́lɛnku kɛcirɛ kɑm ɑni ku u tɑni, ɑni ukɛnipɛpi kɛpɑlɛ tɑni, ɑni ɑnɛ́ɛ́ri u tɑni. ");
INSERT INTO soy_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ani nɛ rinɑ́ɑlɑ kpɔkɔɔ́ kɑm, ɑni ri kopu tɔkɛ́ nɛ ilukɛ kɛcirɛ wɑ tɔkɛ́ li nɛ mpɔ́ɔnɑrɛ. ");
INSERT INTO soy_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ái líkɑ nnyɑ, unɛ́ŋmɑ́nɛ nkó yɛ pɛɛ kpulɛ, uu nɛni nfɑ́ɑ yɛnu, u pɛɛ pɔlɛ, ɑm nkpéni u heei. Api ɑnyɑ̃́ kóru nɛ mpɔ́ɔnɑrɛ. ");
INSERT INTO soy_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Kumúŋɛ́ kpɛ-i, utisi uyɛ̃ uŋmɑ́nɛ foí un sicɑrɛ-mɛ̃ wepɔ. Kuu kɛ́yɔ n nyɑhɑipɔ, uu inyɑ́nlũ nɛ nnyɑ́ɑ nnɛ̃́ kóm ");
INSERT INTO soy_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","uu ukɛikɔ́ usɛ séi uu u pisɛ rɛ yo nnyɑ kɑi lɛ̃ wɑi. ");
INSERT INTO soy_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ukɛikɔ́ uu rinɔ́ɔ u yɔ́su rɛ: Upɔ́wɑ̃́ yɛɛ pɛɛmɛ. Kɛ upɔ́sɑ́ɑ uu ukɛpipi n yɛ̃́ nɛ nsɑrɛnɑrɛ nnyɑ, uu pɛɛ rinɑ́ɑlɑ kpɔkɔɔ́ kopu. ");
INSERT INTO soy_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Uŋmɑ́nɛ foí uu pɛɛ wɔ́ɔ́si uu kɛ́yɔ pilonɛ yulu. Usɑ́ɑ uu léépɔ ukɛ́ kɛ́yɔ u tɑmpɔ. ");
INSERT INTO soy_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Amɑ́ uŋmɑ́nɛ uu usɑ́ɑ rinɔ́ɔ yɔ́su rɛ: A kutu ricɔ, ɑŋmɛ̃ yɛ kulúi wɑlɛ kɑm pɔ́ n kɛisi, ɑ́m kɔ píkɑi pɔ́ hɑ́ikusɛ. Ḿpɑ́ nɛ lɛ̃, ɑ́ɑ píkɑi ḿpɑ́ ripoilɑ nɛ́ hɛ rɛ tɔ́ nɛ pinɛ́sɑ́nɛ tɔkɛ́ nɛ ɑnyɑ̃́ li. ");
INSERT INTO soy_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Amɑ́ kɛ upɔ́ŋmɑ́nɛ nkó uu m pɛɛmɛ, upɔ́ŋmɑ́nɛ yɛɛ mɛpɔ́mɑ́ nnɛ́í ń cɑɑi nɛ piwɑ́sɑ́nkɑí pitóoi, uyɛ̃ kɑɑ rinɑ́ɑlɑ kpɔkɔɔ́ kpu. ");
INSERT INTO soy_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Usɑ́ɑ uu u mɑɑ rɛ: Kɛnɛ́wɑ̃́, tɔ́ nɛ mpɔ̃́ tɔ́ɔ ḿpɑ́ píyei we, pɔ́ɔ lɛ̃ kɑm m mɑ́ nnɛ́í te. ");
INSERT INTO soy_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Amɑ́ li pisɛ rɛ tɔkɛ́ ɑnyɑ̃́ kɛcirɛ wɑ nɛ mpɔ́ɔnɑrɛ rɛ upɔ́wɑ̃́ nkó yɛ pɛɛ kpulɛ, uu nkpéni nfɑ́ɑ yɛnu, u pɛɛ pɔlɛ, ɑm nkpéni u heei. ");
INSERT INTO soy_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yeesu uu kɔ upipirɛtiki mɑɑ rɛ: Umɑ́mɑ́ unyinɛ yɛɛ pɛɛ ukɛikɔ́ mɑ́, uu uɑnipɛ-i umɛmɑ́ wɑi. Pisoi ɑpi u símisi rɛ ukɛikɔ́ uyɛɛ umɛmɑ́ cɑɑinkɛɛlɛ. ");
INSERT INTO soy_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ukɛisɑɑ uu u séi uu u mɑɑ rɛ: Ń-ye kɑm nní kómɛi pin kɛpɔ́cɑ́ɑ́ símisi? A nɛ́ símisi lɛ̃ kɑɑ pipɔ́kɛi n kɛisi. Áɑ nkpéni linɛ́kɔ́ kɛcɑ́ɑ́ pípɑí kpɑ́nɛ. ");
INSERT INTO soy_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ukɛikɔ́ uu ukɛfɑ-i kɔpu rɛ: Unɛ́kɛisɑɑ yɛ pinɛ́kɛi-i nɛ́ lesɛnɛ. Íye kɑm wɑinɛ? Ám tikɔhɔ mɑ́ rɛ nɛ́ fe ɑm lum. Isɛi yɛ́ kɔ nɛ́ n we rɛ kɛ́ wélei. ");
INSERT INTO soy_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Too, nɛ́ céri lɛ̃ kɑm yɛ́ ń wɑ, ḿpɑ́ nɛnsɑ́ kɛyɑ́ɑ n kɛisi, pisoi pikɛ́ nɛ pisiyɔ-i kɛnɛ́cɑ́ɑ́ m pɑílɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Uu pɛ̃ nɛ pɛ̃ pɛɛ uukɛisɑɑ nɛ riwómɛ m mɑ́ sélei usɛ usɛ. Uu ufoí mɑɑ rɛ: Alɛ́ kɑɑ́ nɛ unɛ́yɔsɑɑ riwómɛ mɑ́? ");
INSERT INTO soy_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Uyɛ̃ uu u pɛsɛ rɛ: Mɛ́kpɔ sɔnɛ ɑpɔri pílɛ. Ukɛikɔ́ uyɛ̃ uu u mɑɑ rɛ: Tipɔ́wómɛtɛlɛ́ yɛ ntí, ɑ mɛkɛɛkɛɛ tonɛ ɑɑ wɔ́lu rɛ kuwóó yɛ ku. ");
INSERT INTO soy_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Uu lɛ̃ mɛmɑ́ɑ́ ucɔ pisɛ rɛ: Pɔ̃́ ní, ɑlɛ́ kɛ ripɔ́wómɛ ɑrí le? Uyɛ̃ uu rinɔ́ɔ yɔ́su rɛ: Mɛlukɛpipi ɑ́fɔrɔnti pílɛ. Ukɛikɔ́ uu u mɑɑ rɛ: Tipɔ́wómɛtɛlɛ́ yɛ ntí, ɑ wɔi rɛ ɑ́fɔrɔnti kuwóó nɛ ɑfɛɛtɑɑni. ");
INSERT INTO soy_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ukɛikɔ́ kópɛ uyɛ̃ uyɔsɑɑ uu u pɑkɑrɛ umɛsɔhɔ píimɑ mɛ̃ nnyɑ. Likumúŋɛ́ rɛ kɛtẽ nté pisoi yɛ piwóówɛ́lɑɑ ncee kɛ́mɛɛ mɛsɔhɔ nɛ pipicɔ sɔ́nɛlɛ ɑi tɔ́su pɛpɛɛ mɛtɛ́í kɛ́mɛɛ ń we. ");
INSERT INTO soy_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yeesu uu kpɑ́ rɛ: Nɛ̃́ nɛ nɔ́ mɑɑ rɛ: Ani kɛwóó kópɛ kpísi ɑní nɛ pisɑ́nɛ wɛ́ɛ́si. Kɛn n kɑ kɛn nɛ nɔ́ n ŋmɛ́hɛrɛɛ, Uléécɑɑ ukɛ́ síyɔ sɛɛ ɑ́si píkɑi n forunɛ kɛ́mɛɛ nɔ́ yɔsí. ");
INSERT INTO soy_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Uyɛɛ likɛi síńsɑ́ kɛ́mɛɛ ɑsei m mɑ́ yɛ kɔ limɑ́ɑ kɛ́mɛɛ ɑ mɑ́lɛ uyɛɛ úu likɛi síńsɑ́ kɛ́mɛɛ ɑsei m mɑ́ úu kɔ limɑ́ɑ kɛ́mɛɛ ɑ mɑ́. ");
INSERT INTO soy_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Nɔnsɑ́ mɛmɑ́ kópɛ pimúlɛ́ kɛ́mɛɛ ɑsei m mɑ́, wóo yɛ́ pɛɛ mɛyíkíyiki nɔ́ rimúísɛ? ");
INSERT INTO soy_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Pɔnsɑ́ kɔ ucɔ likɔ́ pimúlɛ́ kɛ́mɛɛ ɑsei m mɑ́, wóo yɛ́ pɛɛ pɔ̃́ likɔ́ pɔ́ rimúísɛ? ");
INSERT INTO soy_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ukɛikɔ́ úu fenɛ ukɛ́ pikɛisɑɑ pitɛ́ m mɑ́. U unyinɛ yulunɛ uu ucɔ n lɑ. U yɛ́ unyinɛ n tikilɛ̃ nɛ kɛfɑ kɛsɛ un ucɔ ipuri yulu. Áni yɛ́ fe nɔkɛ́ Uléécɑɑ nɛ siwóó n tikilɛ̃ kumúŋɛ́ kusɛ. ");
INSERT INTO soy_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Pifɑrisi ɑpi isímɛ́ iyɛ̃ nnɛ́í kóm. Kɑpi siwóó ń lɑ nnyɑ, ɑpi Yeesu sɛ́nnyi. ");
INSERT INTO soy_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yeesu uu pi mɑɑ rɛ: Nɔ pisoi lɛ pɛɛ yɛ sisoipipi inipɛɛ-i n wɑi yɑrɛ pisoi sɔnɛ, ɑmɑ́ Uléécɑɑ yɛ nɔ́sinɛ́fɑ nyulɛ. Lɛ̃ kɛ sisoipipi ɑsi yɛ n wɑisɛ yɑrɛ limɑ́ɑ-mɑɑ yɛ Uléécɑɑ inipɛɛ-i likópɛ lɛ. ");
INSERT INTO soy_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Moisi isé nɛ ɑntepuyɛ ɑtɛlɛ́ kɑpí pɛɛ n céesi yɛ kɛ́tɔ wɑlɛ Yohɑni Úniwolɛ kumúŋɛ́-i. Hɑ́i kumúŋɛ́ kpɛ-i-mɛ kɛ Uléécɑɑ iyɔɔpi Nsímɛ́ Kɛcirɛ nn pikɔ́ɔ́nú kóri, ḿpɑ́ úye un nɑ́ɑ́si ukɛ́ Uléécɑɑ iyɔɔpi-i lõ. ");
INSERT INTO soy_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Kɛtẽ nɛ kɛyómɛ mɛtɛnɛ yɛ́ wɛlɛsi ɑi tɔ́su kɛ Uléécɑɑ isé kɛwɔipi ɑkɛ yɛ́ n tɔsí. ");
INSERT INTO soy_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Úye un uunɔsi n lɑkɑsɛ uu uféé kpísi, liute yɛ iwɑ́sɑ́ wɑlɛ, uyɛɛ kɔ unɔ́si kɛ ulɑ uu n lɑ́kɑsɛ n kpísi yɛ kɔ iwɑ́sɑ́ wɑlɛ. ");
INSERT INTO soy_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Lɛ̃ mɛmɑ́ɑ́, Yeesu uu kɛnyɑ́rũ nkɛ́ pi wɑi rɛ: Utisi mɑ́mɑ́ unyinɛ yɛɛ pɛɛ́ we. Ilũ kɛcirɛ yɛɛ nnɛ́í m mɑ́ kuu yɛ tɑ̃. Ńnɑrɛ kɛ́mɛɛ kuú pɛɛ fɛ́lɛ̃ un kɔ ilukɛ sɔnɛ le. ");
INSERT INTO soy_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Utisi wɛkɔɔ́ unyinɛ kɑpi yɛ n sée rɛ Lɑsɑɑ kɛ sitóipi ɑsi ipiŋɛ nnɛ́í ḿ mɔ́mɑɑlɛ̃ un umɑ́mɑ́ kɛyɔ rinɔnɔɔ kɛyúrí finu. ");
INSERT INTO soy_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ai yɛ ripɔ́ɔ u wɑi rɛ ukɛ́ umɑ́mɑ́ ilukɛ poroi-poroi hĩ́ ukɛ́ li. Lɛ̃ mɛmɑ́ɑ́, sipɔpi sin sɔ́nɑɑpɔ sin uitoi lɑ́ni. ");
INSERT INTO soy_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Úwɛkɔɔ́ uu kɛyɑ́ɑ kpi, piléécɑɑtumɛ ɑpi u sɑkɑɑ ɑpí nɛ kɛlõ sɔnɛ kɛ̃ kɛ́mɛɛ kɛ Apirɑhɑm uu ń we sĩ. Umɑ́mɑ́ ricuruu uu kɔ kɛyɑ́ɑ kpi, ɑpi u kulɛsi. ");
INSERT INTO soy_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Umɑ́mɑ́ uu mɛyɑ̃́ íwɛ n le pikúlɑ̃ kuyu-i, uu inípɛɛ síkɑ uu kɛtɑɑ-pɔ Apirɑhɑm yɛnupɔ, Lɑsɑɑ un ukɛkúrí we. ");
INSERT INTO soy_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Uu pɛɛ pupɛi rɛ: Sɑ́ɑ Apirɑhɑm, ɑ íwɛ nɛ́ tẽ́ ɑɑ Lɑsɑɑ tumti rɛ ukɛ́ nɛ ukɛnipɛpi míni ritɑ ukɛ́ rinɛ́lémpi niŋukusɛ. Nɛ mɛyɑ́nsei íwɛ lelɛ nnɑ mmú kɛ́mɛɛ. ");
INSERT INTO soy_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Amɑ́ Apirɑhɑm uú mɑɑ rɛ: Kɛnɛ́wɑ̃́, ɑ léisɛ rɛ pɔ pɛɛ mɛyɑ́nsei ńnɑrɛ kómɛilɛ pɛɛ́ uyɛ-i kɑɑ́ pɛɛ kɛteni-i ń we. Kumúŋɛ́ kpɛ-i kɛ Lɑsɑɑ pɔ́ɔ pɛɛ íwɛ píimɑ tɑkɑi. Nkpéni kɑi urikiŋ niŋukusɛ, pɔ́ɔn íwɛ tɑkɑi. ");
INSERT INTO soy_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Lɛ̃ mɛmɑ́ɑ́, kuhórɛ-horɛ píimɑ yɛ tɔ́ nɛ nnɔ̃́ kénɛlɛnlɛ. Kɑi nní lɛ̃, pɛpɛɛ ń lɑnɛ rɛ pikɛ́ tɔ́ mmɛ́ yisi pikɛ́ nɔ́-mɛ̃ hɑ ɑ́pi fenɛ. Úkɑ úu kɔ fenɛ ukɛ́ kei kɑɑ nní ń we yisimɛ ukɛ́ tɔ́ mmɛ́ kɑm. ");
INSERT INTO soy_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Umɑ́mɑ́ uú mɑɑ rɛ: In lɛ̃, nɛ nɛ pɔ́ ténilɛ rɛ ɑ Lɑsɑɑ unɛ́sɑ́ɑ kɛyɔ-i tumpɔ. ");
INSERT INTO soy_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Nɛ kei piwɑ̃́ pinupũ mɑ́lɛ. Ukɛ́ hɑ ńsɔnɛ pi símisi ɑ́i kɑpɛ wɑ rɛ pɛ̃ ticuruu yɛ íwɛ kɛlõ nkɛ́-i kɑ. ");
INSERT INTO soy_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Apirɑhɑm uu rinɔ́ɔ yɔ́su rɛ: Pipɔ́wɑ̃́ yɛ Moisi nɛ ɑntepuyɛ ɑtɛlɛ́ mɑ́lɛ. Pikɛ́ ɑ kɛɛ̃ pikɛ́ kṍ. ");
INSERT INTO soy_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Umɑ́mɑ́ uu rɛ: Lɛ̃ ŋmɑnɛ ɑ́i tu, Sɑ́ɑ Apirɑhɑm. Amɑ́ in tɛ unyinɛ yɛ pikúlɑ̃ kuyu-i yisi uú hɑ pi lɛɛpɔ, pi yɛ́ pɛɛ mɛfinɛ consɛ. ");
INSERT INTO soy_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Pinsɑ́ n lɑ pikɛ́ Moisi nɛ ɑntepuyɛ ɑtɛlɛ́ kɛ́ɛ̃ pikɛ́ kṍ, ḿpɑ́ ukpɔkpɔ unyinɛ ukɛ́ pikpɔkpɔ kɛ́mɛɛ yisi, ɑ́pi pɑkɑrɛnɛ. ");
INSERT INTO soy_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yeesu uu upipirɛtiki mɑɑ rɛ: Mɛwɑi mɛɛ yɛ́ n tíyɛsɛ pisoi pikɛ́ nɛ ɑkópɛ n wɑ yɛ́ mɛsɛ́rɛ n welɛ. Amɑ́ úye un n tíyɛsɛ unyinɛ uú nɛ ɑkópɛ kɛ́mɛɛ loni, íwɛ kuu topori. ");
INSERT INTO soy_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Li kutɔsi we pikɛ́ rinɑ́ipɑrɛ mulɛ-mulɛ ńŋmɛ wɑ ɑpi ripɔ́ɔ u lɛsi ɑpi mínimɑɑ-i u sɑ́pɔ nɛ kuu yɛ́ siwɑ̃́ sɛ̃ kɛnyinɛ ɑkópɛ n wɑisɛ. ");
INSERT INTO soy_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ani ńsɔnɛ nɔ́mɛnɛ́círɛ tĩ! Upɔ́mɑ́rɛcɔ un nɛ pɔ́ m púnnɛ, ɑ ńsɔnɛ nɛ u símisi. Un n ceri rɛ u cɑɑilɛ, ɑ uɑkópɛ u sɑ́rɛi. ");
INSERT INTO soy_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ḿpɑ́ un nɛ pɔ́ m púnnɛntɛ mɛpehẽ mɛsɛɛi kɛyɑ́ɑ kɛsɛ kɛ́mɛɛ, uu yɛ ḿpɑ́ mɛpúnnɛ mɛ́ye nɛ pɔ́ téni rɛ u cɑɑilɛ, ɑ uɑkópɛ u sɑ́rɛi. ");
INSERT INTO soy_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Pitumɛ ɑpi Upíimɑ mɑɑ rɛ: A nfɑtɛnɛ tɔ́ rikpɑ́sɛ. ");
INSERT INTO soy_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Upíimɑ uu rinɔ́ɔ yɔ́su rɛ: Nɔn pɛɛ nfɑtɛnɛ m mɑ́ nkɛ́ m piyɛ yɑrɛ riléépipi síńsɑ́pi rinyinɛ, nɔ́ pɛɛ fe ɑni kuléé nkú mɑɑ rɛ: “A wɛhɛ ɑɑ́ hɑ mínimɑɑ-i nyɛrɛ” ɑku nɔ́rinɛ́nɔ́ɔ tiki. ");
INSERT INTO soy_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Tɔkɛ́ wɑisɛ rɛ nɔ́ unyinɛ yɛ ukɛikɔ́ mɑ́ un u cɑ́kɑripɔ nɛ́ɛ un uisɛɛ sémpɔ. Un píyei u n yɛmmɛ un kɛcɑrɛ n leeri, liute yɛ́ ukɛikɔ́ uyɛ̃ mɑɑ rɛ ɑ mɛkɛɛkɛɛ kɑm ɑ ilukɛ lii? ");
INSERT INTO soy_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Aɑí, ɑ́i yɛ́ lɛ̃ wɑ. Amɑ́ u mɛníŋɛ u mɑɑnɛ rɛ: A ilukɛ nɛ́ wɑ ɑɑ ilũ consɛ ɑɑ nɛ́ i yekei kɛ́ li, pɔ́ pɛɛ lɛ̃ mɛmɑ́ɑ́ fe ɑɑ ipɔ́kɔ́ le. ");
INSERT INTO soy_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","U yɛ́ fe uu uukɛikɔ́ yɑ́ɑ́si rɛ nɛ upikɛi kuú nɛ pikɛi pɛ̃ kɑí pɛɛ m pisɛ rɛ ukɛ́ wɑ n wɑɑ? ");
INSERT INTO soy_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Lɛ̃ cirɛ yɛ ni nɛ nɔ̃́ ticuruu. Nɔn píyei lɛ̃ kɑi m pisɛ rɛ nɔkɛ́ wɑ n wɑ, ɑni yɛ mɑɑ rɛ: Tɔ̃́ nɛ pikɛikɔ́ lɛ, ɑ́i pisɛ rɛ pikɛ́ rɔ́ pɔɔnɛsɛ. Lɛ̃ kɑi m pisɛ rɛ tɔkɛ́ wɑ kɑri wɑ. ");
INSERT INTO soy_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Kɛ Yeesu uu Yerusɑlɛm-mɛ̃ n sĩ́, uu Sɑmɑrii nɛ Kɑlilee ɑyu kɛpɑ́ɑ́pɑ́ɑ́ n tikilɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Uu kuyu kunyinɛ-i lompɔ, piyɔ̃́ kɛfi pinyinɛ ɑpi u tɛ́pɛipɔ ɑpi kɛtɑɑ-pɔ nyɛrɛ ");
INSERT INTO soy_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ɑpí m pupukɛɛ rɛ: Yeesu, Sɑ́ɑ, ɑ íwɛ rɔ́ tẽ́! ");
INSERT INTO soy_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yeesu uu pi yɛnu uu rɛ: Ani hɑ nɔ́mɛnɛ́círɛ pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ nyísɛ. Kɑpi kei-pɔ n sĩ́, ɑpi pelu. ");
INSERT INTO soy_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Kɛ piusɛ uu n céri rɛ u peilɛ, uu uɑnɑ kɛpirɛ pɛlɛ un Uléécɑɑ mɛyɔɔpi yom lin cɑ́lɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Uu Yeesu ɑnɑ mɛtene wulɑpɔ uu kɛ́yu kɛtẽ kɑm, uu u yɑ́ɑ́si rɛ nɛ upikɛi. Utisi uyɛɛ pɛɛ Sɑmɑrii ukɔ́ lɛ. ");
INSERT INTO soy_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yeesu uu pi mɑɑ rɛ: Nɛ́ntɛ pikɛfi kɑm pɔisɛ? Yei yɛ pɛɛ usɛ úu we kɛfi tɔrɔɔ mpí? ");
INSERT INTO soy_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Piukɑ úu nfɑsimɛ́ wɑ rɛ ukɛ́ pɛɛmɛ ukɛ́ Uléécɑɑ ríyu wɑisɛ rɛ nɛ upikɛi, insɑ́ usɑ́nɛ nkó mɛcirɛ. ");
INSERT INTO soy_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Yeesu uu lɛ̃ mɛmɑ́ɑ́ u mɑɑ rɛ ɑ yisi, ɑ n ŋme, mpɔ́fɑtɛnɛ yɛ pɔ́ yóriyɛlɛ. ");
INSERT INTO soy_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Pifɑrisi ɑpi Yeesu pisɛ rɛ: Píyei kɛ Uléécɑɑ iyɔɔpi ii sɔ́nti? Uu rinɔ́ɔ pi yɔ́su rɛ: Uléécɑɑ iyɔɔpi íi we rɛ nɔ́ fe ɑni imɛkɑmɛ yɛnu. ");
INSERT INTO soy_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ái rɛ pi yɛ́ nɔ́ mɑɑ rɛ: Ani ripɑí, nté kií we nɛ́ɛ nté-pɔ le. Ani ceri rɛ Uléécɑɑ iyɔɔpi yɛ nɔ́kɛnɛ́cɔpɛ welɛ. ");
INSERT INTO soy_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Uu pɛɛ pipirɛtiki mɑɑ rɛ: Kɛyɑ́ɑ yɛ sɔ́ntilɛ kɑni yɛ́ ń lɑ rɛ nɔkɛ́ ḿpɑ́ kɛyɑ́ɑ kɛsɛ Usoi Kɛpipi yɛ̃, ɑmɑ́ ɑ́ni yɛ́ kɔ kɛ yɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Pi yɛ́ nɔ́ mɑɑ rɛ: Nté nní kuú we nɛ́ɛ nté-pɔ kuú we, ɑmɑ́ ɑ́ni kɑpɛ kei hɑ, ɑ́ni kɑpɛ kɔ mɛ̃ wurupɔ. ");
INSERT INTO soy_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Yɑrɛ kɛ kɛkónɛsɛípi ɑkɛ yɛ nní mɛyéne mɛsɛ riń-yɛɛ́ri kɛyómɛ kɛtɔ nɛ kɛ́tɔ, ɑi kpɑ̃́ii mɛcɔ kɛ Usoi Kɛpipi ɑkɛ sɔ́nti. ");
INSERT INTO soy_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Amɑ́ li pisɛ rɛ kɛkɛ́ mɛyɑ̃́ íwɛ li, nfɑ́ɑni pisoi mpí pikɛ́ kɛ ŋmɛriyɛ. ");
INSERT INTO soy_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Lɛlɛɛ pɛɛ Nowee kumúŋɛ́ n wɑ licɔ lɛɛ Usoi Kɛpipi kumúŋɛ́ wɑinɛ. ");
INSERT INTO soy_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Pisoi yɛ pɛɛ lelɛ pin níru pin sɔ́ɔnnɛ pin pilɑ nɛ pinɔ́si pɑsiinɛ hɑ́i nɛ kɛyɑ́ɑ kɛ̃ kɛ Nowee uu kutɑ́kɑi kɛ́mɛɛ n lompɔ, ikónɛ mɑɑ ií nɛ weri, míni ɑmɛ pisoi kpísi. ");
INSERT INTO soy_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Li yɛ́ hɑ n we yɑrɛ Lɔti kumúŋɛ́: Pisoi yɛ pɛɛ lelɛ pin níru, pin lɛ́ɛ́ri pin kɔ yɑ́lisi, pin ɑléé tɑ́mɑɑnkɛɛ pin kɔ mɔ́mti. ");
INSERT INTO soy_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Amɑ́ kɛyɑ́ɑ kɛ̃ kɛ Lɔti uu Sotɔm-i ń le kɛ nnɑ nɛ linyinɛ yɑrɛ nfúrɔ̃ toi ɑi kɛyómɛcɑɑ-pɔ leemɛ ɑi pisoi kóni. ");
INSERT INTO soy_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Mɛsɛ mɛ̃ kɑí hɑ kɛyɑ́ɑ kɛ̃ kɛ Usoi Kɛpipi ɑkɛ́ hɑ n léerinɛ pikɛ́ kɛ yɛ̃ wɑinɛ. ");
INSERT INTO soy_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Úye un kɛyɑ́ɑ kɛ̃ ukulee ipirɑɑ kɛcɑ́ɑ́ n we, úu kɑpɛ rɛ ukɛ́ mɛtene ricɛpi ukɛ́ uilũ iyɛɛ kei ń we kpísi nɛ́ɛ, úye un sicɑrɛ-mɛ̃ n we, úu kɑpɛ rɛ ukɛ́ kɛ́yɔ pɛlɛ. ");
INSERT INTO soy_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ani Lɔti unɔsi nkɔ́ kɛcɑ́ɑ́ léisɛ. ");
INSERT INTO soy_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Úye un n lɑ ukɛ́ nfɑ́ɑ mɛsɛ́rɛ m mɑ́, u yɛ́ n fóm. Amɑ́ úye un unfɑɑ n fóm, u yɛ́ n yɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nɛ nɔ́ símisi rɛ kɛsinɛ kɛ̃, pisoi pitɛ́ yɛ́ kuhɑ̃́ kusɛ kɛcɑ́ɑ́ n finu, ɑí usɛ kpíípɔ ɑi ucɔ yɑ́. ");
INSERT INTO soy_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Pinɔ́si pitɛ́ yɛ́ n we pin nɑm ɑi usɛ kpíípɔ ɑi ucɔ yɑ́. ");
INSERT INTO soy_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Pitisi pitɛ́ yɛ́ likumúŋɛ́ kpɛ-i kɛcɑrɛ-i n we, ɑi usɛ kpíípɔ ɑi ucɔ yɑ́. ");
INSERT INTO soy_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Pipirɛtiki ɑpi u pisɛ rɛ: Upíimɑ, yei kɑí hɑ lɛ̃ wɑinɛ mɑ́? Uu rinɔ́ɔ yɔ́su rɛ: Kei kɛ isɑrɛ kópɛ ii ń we kɛ ɑ́yemeekú ɑɑ yɛ cɑ́pinɛ. ");
INSERT INTO soy_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yeesu uu lɛ̃ mɛmɑ́ɑ́ kɛnyɑ́rũ nkɛ́ pi wɑi ukɛ́ nɛ pi céési rɛ pikɛ́ yɛ ḿpɑ́ píyei Uléécɑɑ yɑ́ɑ́si, ɑ́i kɑpɛ yɛ píkɑi sikɑ̃́ pi wɑ. ");
INSERT INTO soy_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Uu rɛ: Kuyu kunyinɛ-i kɛ utúhɑɑnɛ unyinɛ uú pɛɛ we. Úu Uléécɑɑ wuru úu kɔ úkɑ pɑkɑrɛlɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ukúmɑnnɔsi unyinɛ un kɔ kuyu kpɛ-i we. Uu mɛsɛ́rɛ u n lɛɛkɛɛpɔ rɛ ukɛ́ u nɛ uucɛ́cɔ kɛtɑhɑi rikénɛ. Ḿpɑ́ píyei kuu yɛ u lɛɛpɔ uu u mɑɑ rɛ: A tɔ́ nɛ unɛ́cɛ́cɔ kɛtɑhɑi rikénɛ. ");
INSERT INTO soy_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ai nɑ́ŋɑi hɑ́i, ɑmɑ́ utúhɑɑnɛ úu nɛ kutu u cɔlɛ̃, uu pɛɛ kɛyɑ́ɑ umɛcirɛ mɑɑ rɛ mɛsei yɛ mɛ rɛ ɑ́m Uléécɑɑ wuru ɑ́m kɔ úkɑ pɑkɑrɛlɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Amɑ́ kɛ ukúmɑnnɔsi uu nní picɔ́ŋ nɛ́ n tɔ́ŋsɛ nnyɑ, li pisɛ rɛ kɛ́ lɛ̃ ɑlɑri u pɑ, insɑ́ lɛ̃, u yɛ́ pisɔ́nɑɑmɛ n nɔŋ́lɛnlɛ uú hɑ nɛ kunɔnkũ nɛ́ finsɛ. ");
INSERT INTO soy_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Upíimɑ uu lɛ̃ mɛmɑ́ɑ́ kpɑ́ rɛ: Ani lɛ̃ kɛ utúhɑɑnɛ kópɛ uyɛ̃ uu ḿ mɑ kutu ricɔ! ");
INSERT INTO soy_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Uléécɑɑ yɛɛ úu yɛ́ pɛɛ upikɔ́ ɑlɑri pɑ pin nɛ u n téni kɛtúŋɛ́ nɛ kɛsinɛɛ? U yɛ́ nɑ́ŋɑisɛ ukɛ́ nɛ pi n lɛ̃́ɛ? ");
INSERT INTO soy_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nɛ nɔ́ mɑɑ rɛ u yɛ́ mɛkɛɛkɛɛ ɑlɑri pi pɑ. Amɑ́ Usoi Kɛpipi kɛn píyei m pɛɛmɛ, kɛ yɛ́ pɛɛ kɛtẽ kɛcɑ́ɑ́ pisoi lɛɛmɛ pɛɛ nfɑtɛnɛ m mɑ́ɑ? ");
INSERT INTO soy_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yeesu uu kɛnyɑ́rũ pɛpɛɛ nní pimɛcirɛ n wɑisɛlɛ̃ yɑrɛ pisoi sɔnɛ pin picɔ kósɛlɛ̃ mɑɑ rɛ: ");
INSERT INTO soy_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Pisoi pitɛ́ pinyinɛ pɛɛ Uléécɑɑ kɛyɔ-i lompɔ rɛ pikɛ́ kɛyómɛ yɑ́ɑ́si, usɛ yɛ Ufɑrisi lɛ, ucɔ ulɑmpooyɔɔ́. ");
INSERT INTO soy_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ufɑrisi uu nyɛrɛ uu ukɛfɑ-i rɛ: Uléécɑɑ, nɛ pɔ́ yɑ́ɑsi kɑ́m nɛ pisoi tɔrɔɔ mɛnyínɛ ń we nnyɑ, pɛɛ piyɑɑ nɛ piwɑikópɛkɔɔ́ nɛ piwɑ́sɑ́nkɑí lɛ. Nɛ pɔ́ yɑ́ɑsi kɑ́m nɛ ń we yɑrɛ ulɑmpooyɔɔ́ nkó. ");
INSERT INTO soy_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Siyɑ́ɑ sisɛɛi kɛ́mɛɛ, sitɛ́ kɑm yɛ ɑnɔ́ɔ pɑɑsi, lɛ̃ nnɛ́í kɑm yɛ n yɛ̃́ kɑm yɛ hɔɔnɛ ɑwɛ́lɛ́ kɛfi ɑm kusɛ pɔ́ pɑ. ");
INSERT INTO soy_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ulɑmpooyɔɔ́ uyɛ̃ pɔ́ɔ kɛtɑɑ-pɔ nyɛrɛ, úu nkpɑ́ni kɛyómɛ-mɛ̃ inípɛɛ pisíkɑ peenu, ɑmɑ́ kɛwuu kuu ripirɑ uu rɛ: A nɛ̃́ ukópɛkɔɔ́ íwɛ tẽ́. ");
INSERT INTO soy_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yeesu uu kpɑ́ rɛ: Nɛ nɔ́ mɑɑ rɛ usoi nkó ukɛ́ kɛlenɛ n kúi, Uléécɑɑ yɛ uɑkópɛ u sɑ́rɛilɛ, ɑmɑ́ ɑ́i lɛ̃ Ufɑrisi wɑ. Likumúŋɛ́ rɛ úye un umɛcirɛ rintɑɑ́sɛ, li yɛ u ricɛpisɛlɛ, úye un umɛcirɛ rincɛpisɛ, li yɛ u ritɑɑ́sɛlɛ. ");
INSERT INTO soy_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Pisoi ɑpí nɛ siwɑ̃́ fɛnfɛ̃í ricuruu Yeesu hɑpɔ rɛ ukɛ́ si ricɑ. Pipirɛtiki ɑpi pi yɛnu, ɑpí nɛ pi cɛ́si. ");
INSERT INTO soy_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Amɑ́ Yeesu uu tíyɛsɛ ɑpí nɛ siwɑ̃́ u hɑpɔ, uu rɛ: Ani riyɑ́ siwɑ̃́ sikɛ́ kɛnɛ́mɛɛ kɑm, ɑ́ni kɑpɛ si tɑ́pisi. Likumúŋɛ́ rɛ mpí pɛɛ simɛcɔ ń we pɛɛ yɛ́ Uléécɑɑ iyɔɔpi kɛ́mɛɛ lõ. ");
INSERT INTO soy_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Asei kɑm nɔ́ símisi, úye unsɑ́ Uléécɑɑ iyɔɔpi n ŋmurɛi yɑrɛ kɛ kɛwɑ̃́ ɑkɛ yɛ n ŋmurɛi, úu ikɛmɛɛ loninɛ. ");
INSERT INTO soy_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Pisuifi uwɛ́ɛ́sɛ unyinɛ uu Yeesu pisɛ rɛ: Sɑ́ɑ sɔnɛ, íye kɑm wɑinɛ kɛ́ nɛ nfɑ́ɑ tɛnɛcirɛ́ yɛ̃́? ");
INSERT INTO soy_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yeesu uu u mɑɑ rɛ: Yo nnyɑ kɑɑ nɛ́ sée rɛ Usɔnɛ? Úkɑ úu usɔnɛ insɑ́ Uléécɑɑ mɛcirɛ. ");
INSERT INTO soy_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ḿpɑ́ likɛ́ íye wɑ, pɔ Uléécɑɑ isé nyulɛ rɛ: Kɑpɛ iwɑ́sɑ́ wɑ, kɑpɛ usoi kpu, kɑpɛ yɑ́ɑi, kɑpɛ nnɔ́ɔmɛ itɑnsei nyɛrɛ, ɑ upɔ́sɑ́ɑ nɛ upɔ́ni ríyu wɑisɛ? ");
INSERT INTO soy_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Utisi uu rinɔ́ɔ yɔ́su rɛ: Hɑ́i inɛ́wɑ̃́-mɛ kɑm lɛ̃ múílɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Kɛ Yeesu uu lɛ̃ pikómɛ ḿ mɑsí, uu u mɑɑ rɛ: Likɛi lisɛ lɛɛ pɔ́ pɑ́rílɛ̃. A lɛ̃ nnɛ́í kɑɑ m mɑ́ yɑ́ɑ́, ɑɑ siwóó sɛ̃ píwɛkɔɔ́ hɔ́ɔnɛ, pɔ́ pɛɛ kɛyómɛcɑɑ-pɔ mɛmɑ́ yɛ̃́. Pɔn lɛ̃ piwɑi m mɑsí, ɑɑ pɛɛ́ weri ɑɑ nɛ́ tíki. ");
INSERT INTO soy_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Amɑ́ kɛ utisi uu ɑnɔ́ɔ nyɛ̃ n kṍ, uripɔɔ ɑri mɛyɑ́nsei cɑɑi, ɑ́i líkɑ nnyɑ, u pɛɛ umɑ́mɑ́ píimɑ lɛ. ");
INSERT INTO soy_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Kɛ Yeesu uu n yɛ̃́ tɛ uripɔɔ yɛ cɑɑi, uu rɛ: A tíyɛ Uléécɑɑ iyɔɔpi kɛ́mɛɛ pilonɛ yɛ nɛ pimɑ́mɑ́ pɑ́ɑ́pú kpɑ! ");
INSERT INTO soy_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kuyooyoo kun n lɑ kukɛ́ kɛhímpi kupolɛ-i lompɔ, li yɛ́ kutɔsi m purú nɛ kɛ umɑ́mɑ́ uu yɛ́ ń lɑ ukɛ́ Uléécɑɑ iyɔɔpi kɛ́mɛɛ n lompɔ. ");
INSERT INTO soy_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Pɛpɛɛ pɛɛ kutu u n cɔ́lɛ̃ ɑpi rɛ: In lɛɛ ni, wóo yɛ pɛɛ píyulɑlɛ yɛ̃? ");
INSERT INTO soy_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yeesu uu rinɔ́ɔ pi yɔ́su rɛ: Lɛlɛɛ ɑ́i sisoipipi kɛ́mɛɛ kuwɑi ń we yɛ Uléécɑɑ kɛ́mɛɛ kuwɑi welɛ. ");
INSERT INTO soy_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Piyɛɛ uu pɛɛ rɛ: Lɛɛ nní, lɛ̃ kɑrí pɛɛ m mɑ́ kɑri tíyɛ ɑri pɔ́ tíki. ");
INSERT INTO soy_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yeesu uu pi mɑɑ rɛ: Asei kɑm nɔ́ símisi. Úye un Uléécɑɑ iyɔɔpi nnyɑ ukɛyɔ, nɛ́ɛ uunɔsi nɛ upiwɑ̃ nɛ upimɑɑ nɛ upimɑrɛcɔ, nɛ usiwɑ̃ tin-yɑ́, ");
INSERT INTO soy_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","liute yɛ́ nɛni mɛwee mmɛ́-i lɛ̃ mɛpehẽ kulúi yɛ̃ uu kɔ ɑŋmɛ̃ nyɛɛ n wemɛ kɛ́mɛɛ nfɑ́ɑ tɛnɛcirɛ́ yɛ́nu. ");
INSERT INTO soy_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yeesu uu upipirɛtiki kɛfi nɛ pitɛ́ séi uu pi mɑɑ rɛ: Tɔ Yerusɑlɛm sinlɛ. Kei kɛ lɛ̃ nnɛ́í kɛ ɑntepuyɛ ɑpi Usoi Kɛpipi kɛcɑ́ɑ́ ń wɔ́i ɑí hɑ wɑinɛ. ");
INSERT INTO soy_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Pi yɛ́ pɛpɛɛ ɑ́pi Uléécɑɑ n wuru ɑnipɛ-i kɛ wɑ ɑpi kɛcɑ́ɑ́ kɛ nyɑ́nɛi, ɑpi kɛ lɑ́misi, ɑpi kɛkɛcɑ́ɑ́ mɛtɑ tukɛ ");
INSERT INTO soy_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ɑpi nsɛ́í kɛ fɑpii ɑpi pɛɛ kɛ kopu, ɑmɑ́ kɛyɑ́ɑ tɑ́ɑ́nũ tuŋɛ́ ɑkɛ nkpɔ kɛ́mɛɛ yisi. ");
INSERT INTO soy_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Amɑ́ Yeesu pipirɛtiki ɑ́pi nsímɛ́ mmɛ̃ ɑsei kõ. Li ɑnɔ́ɔ nyɛ̃ ɑsei pi pesilɛ ɑ́pi nkpɑ́ni céri lɛ̃ nsímɛ́ kɛ Yeesu uu n símisi. ");
INSERT INTO soy_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Kɛ Yeesu uu Yeriko n nyɑhɑipɔ, unyíyɛ unyinɛ un ticéetimɛ tũ un wélei. ");
INSERT INTO soy_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Uu kóm tisoiwuí tin sɔ́nɛpɔ, uu pisɛ rɛ yoo ni? ");
INSERT INTO soy_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Api u símisi rɛ Nɑsɑrɛti ukɔ́ Yeesu yɛɛ kei tɔ́su. ");
INSERT INTO soy_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Uu pɛɛ pupɛi rɛ: Tɑfiti Kɛpipi Yeesu, ɑ inɛ́wɛ ripɑí! ");
INSERT INTO soy_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Pɛpɛɛ pɛɛ kɛkpéẽ n sɔ́nɛ ɑpí nɛ u cɛ́si rɛ ukɛ́ risɛ́ɛ́, ɑmɑ́ uu mɛyɑ̃́ cɑ́sɛ rɛ: Tɑfiti Kɛpipi, ɑ inɛ́wɛ ripɑí! ");
INSERT INTO soy_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yeesu uu nyɛrɛ, uu rinɔ́ɔ hɛ rɛ pikɛ́ nɛ u u kɑm. Kɛ unyíyɛ uu ukɛkúrí ń hɑ́pɔ, Yeesu uu u pisɛ rɛ: ");
INSERT INTO soy_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Yo kɑɑ́ lɑ kɛ́ pɔ́ wɑ? Uu rinɔ́ɔ yɔ́su rɛ: Sɑ́ɑ, nɛ lɑ rɛ inɛ́nípɛɛ ikɛ́ yɛ yɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yeesu uu u mɑɑ rɛ: Ipɔ́nípɛɛ ikɛ́ wúkulɛ! Mpɔ́fɑtɛnɛ yɛ pɔ́ yóriyɛlɛ. ");
INSERT INTO soy_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Mɛsɛ nɛ mɛsɛ, inípɛɛ ii wúkulɛ, uu Yeesu tiki un Uléécɑɑ mɛyɔɔpi yom. Tisoiwuí nnɛ́í ɑri lɛ̃ yɛnu, pɛ̃ ticuruu ɑpi kɔ Uléécɑɑ mɛyɔɔpi piyómɛ kɑ́pɑ́ɑ́. ");
INSERT INTO soy_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yeesu uu Yeriko-i lompɔ uu uncee n tɔ́su. ");
INSERT INTO soy_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Utisi unyinɛ kɑpi yɛ n sée rɛ Sɑsee un kuyu kpɛ-i we. U pɛɛ pilɑmpooyɔɔ́ uwɛ́ɛ́sɛ lɛ un kɔ umɑ́mɑ́. ");
INSERT INTO soy_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Uu nɑ́ɑ́si ukɛ́ uyɛ̃ kɑpi yɛ n sée rɛ Yeesu yɛ̃, ɑmɑ́ úu fe. Pisoi yɛ pɛɛ riwúí cɑ́pinɛlɛnlɛ, uyɛ̃ úu kɔ pɛɛ mɛcɑ́ɑ we. ");
INSERT INTO soy_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Uu pɛɛ kɛ́yu-mɛ̃ wuru uú hɑ kuléé kunyinɛ kɑpi yɛ n sée rɛ Sikomɔɔ yopoi ukɛ́ Yeesu yɛɛ kei n tíkinɛ yɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Kɛ Yeesu uu kɛlõ kɛ-i n tu, uu uinipɛɛ síkɑ uu Sɑsee mɑɑ rɛ: A mɛkɛɛkɛɛ súimɛ Sɑsee, li pisɛ rɛ kɛ́ nɛni kɛpɔ́yɔ-i tonɛ. ");
INSERT INTO soy_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sɑsee uu mɛkɛɛkɛɛ súiri uú hɑ kusɑ́nɛ u yɔ́su nɛ mpɔ́ɔnɑrɛ. ");
INSERT INTO soy_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ai pɛ̃ nnɛ́í pɛɛ lɛ̃ n yɛ̃́ pírí wɑi, ɑpi pɛɛ́ n tee rɛ: Ukópɛkɔɔ́ kɛyɔ kɛ usoi nkó uu nní lõ. ");
INSERT INTO soy_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Sɑsee un Upíimɑ kɛyúrí nyɛnu uu rɛ: A kutu ricɔ, Sɑ́ɑ nɛ́ mɛnɛ́mɑ́ rikénɛ ɑm kuwɛ́lɛ́ píwɛkɔɔ́ pɑ. Nɛn kɔ úye mɛnípɛɛ n li ɑm usiwóó yɔ́su, nɛ́ liute si hɛ́ɛ́lɛ mɛpehẽ mɛnɑ. ");
INSERT INTO soy_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yeesu uu u mɑɑ rɛ: Píyulɑlɛ yɛ nɛni kɛyɑɑ nkɛ́ kɛ́yɔ nkɛ́-i lommɛlɛ, ɑ́i líkɑ nnyɑ, Sɑsee ricuruu yɛ kɔ Apirɑhɑm kɛpirɛ ukɔ́ lɛ. ");
INSERT INTO soy_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Likumúŋɛ́ rɛ Usoi Kɛpipi yɛ kɑlɛ kɛkɛ́ pɛpɛɛ m pɔlɑɑlɛ̃ tiyu lɔ. ");
INSERT INTO soy_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Pisoi pɛɛ Yeesu kutu rińcɔ yɛ pɛɛ́ musí rɛ kuu nní nɛ Yerusɑlɛm tińkɔ nnyɑ, Uléécɑɑ yɛ lɛ̃ tuimɛlɛ ukɛ́ iyɔ́ɔpi n le pin u nyɑ́ni. Lɛ̃ nnyɑ kuu kɛnyɑ́rũ pi mɑɑ rɛ: ");
INSERT INTO soy_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Kɛ́yɔ kɛcirɛ usoi unyinɛ yɛɛ kuyu tɑɑ-tɑɑ kunyinɛ-i hɑ rɛ pikɛ́ iyɔ́ɔpi u tĩ ukɛ́ pɛɛ limɛmɑ́ɑ́ pɛɛmɛ. ");
INSERT INTO soy_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ukɛ́ kɛlenɛ ń tɔsí, uu upikɛikɔ́ kɛfi pinyinɛ séi uu ḿpɑ́ úye wurɑ kɛwóó múísɛ uu pi mɑɑ rɛ: Ani siwóó nsí nɛ kpéénsɛ hɑ́i nɛ mɛnɛ́pɛɛmɛ. ");
INSERT INTO soy_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Amɑ́ ukuyu pisoi ɑpi uipuri yulu, ɑpi pitumɛ yukusɛ pikɛ́ ukɛpirɛ ritikipɔ pikɛ́ rɛ: Ári lɑ rɛ usoi nkó ukɛ́ urɔ́yɔ́ɔpi. ");
INSERT INTO soy_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Api iyɔ́ɔpi u tini uu ukuyu pɛlɛ. Uu pɛɛ pikɛikɔ́ pɛ̃ kuú pɛɛ siwóó m mulɛisɛ séi rɛ ukɛ́ yɛ̃́ kulɑ́ɑ kpɛ̃ kɑpi n yɛ̃́. ");
INSERT INTO soy_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ufoí uú hɑpɔ uú mɑɑ rɛ: Sɑ́ɑ, wurɑ kɛwóó kɑɑ nɛ́ rimmúísɛ kulɑɑ yɛ wɑlɛ wurɑ siwóó kɛfi. ");
INSERT INTO soy_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Uyɔ́ɔpi uu u mɑɑ rɛ: Li nyɑmlɛ, ukɛikɔ́ sɔnɛ. Kɑɑ nní likɛi síńsɑ́ pimúlɛ́ ń céri ńsɔnɛ nnyɑ, nɛ́ ɑyu kɛfi pɔ́ pɑ ɑɑ ɑkɛcɑ́ɑ́ m pɑílɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ukɛikɔ́ lírũ uú hɑpɔ uu rɛ: Sɑ́ɑ, wurɑ kɛwóó kɑɑ nɛ́ rimmúísɛ kulɑɑ yɛ wɑlɛ wurɑ siwóó sinupũ. ");
INSERT INTO soy_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Uyɔ́ɔpi uú uyɛ̃ mɑɑ rɛ: Nɛ́ pɔ̃́ ɑyu ɑnupũ pɑ ɑɑ ɑkɛcɑ́ɑ́ m pɑílɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ukɛikɔ́ ucɔ uú hɑpɔ uu rɛ: Sɑ́ɑ, upɔ́wurɑ kɛwóó yɛ nkɛ́. Kɛnírípi-i kɑm kɛ pɑɑsi ɑm pésu. ");
INSERT INTO soy_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ipɔ́wɑmɛ yɛ nɛ́ wɑlɛ, kɑm mɛpɔ́kɔ́ n nyu rɛ ɑ́ɑ yɛ nkɑ̃́ usoi wɑ nnyɑ. Lɛ̃ kɑ́ɑ n yekei kɑɑ yɛ kpísi, lɛ̃ kɑ́ɑ n lukɛsi kɑɑ yɛ kpɑsi. ");
INSERT INTO soy_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Uyɔ́ɔpi uu u mɑɑ rɛ: Pɔ́ ukɛikɔ́ kópɛ nkó, ɑpɔ́nɔ́ɔ cirɛ kɑḿ nɛ kɛtɑhɑi pɔ́ pɛpirɛnɛ. Pɔ nyu rɛ ɑ́m yɛ usoi nkɑ̃́ wɑ, tɛ nɛ yɛ lɛ̃ kɑ́m n yekei kpísilɛ, ɑm lɛ̃ kɑ́m n lukɛsi kpɑsi. ");
INSERT INTO soy_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Yo nnyɑ kɑ́ɑ pɛɛ siwóó kɛyekei-i yekei? Nɛ́ pɛɛ fe ɑm mɛnɛ́pɛɛmɛ mmɛ́-i si yɔ́su nɛ kulɑ́ɑ. ");
INSERT INTO soy_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Uu pɛɛ pɛpɛɛ kei ń we mɑɑ rɛ: Ani wurɑ kɛwóó kɛ̃ yɔsí ɑni uyɛɛ mɛwóópipi kɛfi m mɑ́ múísɛ. ");
INSERT INTO soy_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Api u mɑɑ rɛ: Uyɛ̃ nɛ mɛwóópipi kɛfi mɑ́lɛ. ");
INSERT INTO soy_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Asei kɑm nɔ́ símisi, uyɛɛ m mɑ́ kɑpi yɛ pípɑ rikpɑ́, ɑmɑ́ úye unsɑ́ m mɑ́, nkɑ́ripi kuu m mɑ́ kɑpi u yɔ́sunɛ. ");
INSERT INTO soy_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Amɑ́ pinɛ́lɑ́ɑrɔ pɛɛ ɑ́pi nɛ iyɔ́ɔpi nɛ́ n lɑ pɔ̃́ nkɔ́ yɛ mmú: Ani nɛ nté pi kɑm ɑni kɛnɛ́yu-i pi kóni. ");
INSERT INTO soy_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Kɛ Yeesu uu lɛ̃ pisímɛ́ ḿ mɑsí, uu risoiwuí kɛkpeẽ wɑi un Yerusɑlɛm simpɔ. ");
INSERT INTO soy_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Kumúŋɛ́ kpɛ-i kuu Pɛtifɑsee nɛ Petɑnii ɑyu kuwɛ́lɛ́-mɛ̃ tikúú tɛ̃ kɑpi yɛ n sée rɛ Olifiyee rikúú kɛyúrí ń we, uu upipirɛtiki pitɛ́ tum ");
INSERT INTO soy_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","un pi tee rɛ: Ani kuyupi kpɛɛ nní kɛrɔ́yu ń wepɔ kɛ́mɛɛ hɑ. Nɔn kei n tuipɔ, nɔ́ kɛminɑɑpipi kɛnyinɛ lɛɛpɔ kɛn torɑɑlɛ̃. Usoi úkɑ úu kɛ tonɛlɛ̃. Ani kɛ fénnɛ ɑní nɛ nɛ́ kɛ weri. ");
INSERT INTO soy_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Úye un nɔ́ m pisɛ rɛ yo nnyɑ kɑni kɛ fénnɛ, ɑni liute mɑɑ rɛ Upíimɑ yɛɛ kɛ lɑ. ");
INSERT INTO soy_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Pitumɛ ɑpi sĩ́ ɑpí hɑ lɛɛpɔ yɑrɛ lɛ̃ kɛ Yeesu uu pi n símisi. ");
INSERT INTO soy_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Kumúŋɛ́ kpɛ-i kɑpi kɛminɑɑpipi n fénnɛ, kɛpite ɑpi pi mɑɑ rɛ: Yo nnyɑ kɑni kɛminɑɑpipi kɛ̃ toriyɛ? ");
INSERT INTO soy_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Api rinɔ́ɔ yɔ́su rɛ: Upíimɑ yɛɛ kɛ lɑ. ");
INSERT INTO soy_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Api kɛminɑɑpipi kɛ̃ nɛ sĩ, ɑpi kɛkɛcɑ́ɑ́ piilũ lɑɑi ɑpi Yeesu kɛkɛcɑ́ɑ́ tónsɛ. ");
INSERT INTO soy_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Kɑpi kɛ́yu-mɛ̃ n sĩ́, pisoi ɑpi piilũ ncée kɛcɑ́ɑ́ n tɑ́ŋɛntɛ. ");
INSERT INTO soy_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Kɑpi Yerusɑlɛm n nyɑhɑipɔ pin ncée mmɛɛ Olifiyee rikúú ń cɛ́pilɛ̃ tikilɛ̃ pipirɛtiki kulúi pɛɛ u n tíkilɛ̃, ɑpi Uléécɑɑ mɛyɔɔpi n yom lin cɑ́lɛ̃, mɛwɑisɑŋɑ mɛ̃ nnɛ́í kɑpi n yɛ́nti nnyɑ. ");
INSERT INTO soy_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Pi pɛɛ mɑ́ikɛɛ rɛ: Uléécɑɑ ukɛ́ Uyɔ́ɔpi uyɛɛ nɛ Upíimɑ rinyiri n sɔ́nti rikpɑ́. Nkíŋniŋɛ nkɛ́ kɛyómɛcɑɑ-pɔ n we, Uléécɑɑ rinyiri tikɛ́ kei-pɔ n tɑɑ́lɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Pifɑrisi pinyinɛ pɛɛ risoiwuí tɛ-i ń we ɑpi Yeesu mɑɑ rɛ: A pipɔ́pirɛtiki rinɔ́ɔ hɛ rɛ pikɛ́ risɛ́ɛ́. ");
INSERT INTO soy_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yeesu uu rinɔ́ɔ pi yɔ́su rɛ ḿpɑ́ pin tinsɛ́ɛ́, ɑpɑrɛ yɛ́ ricɑ́ɑ́i. ");
INSERT INTO soy_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Kɛ Yeesu uu Yerusɑlɛm kuyu n nyɑhɑipɔ, uu ku yɛnu, uu kpɛ̃ nnyɑ téni ");
INSERT INTO soy_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","un tee rɛ: Yerusɑlɛm, pɔn pɛɛ nɛni kɛyɑɑ nkɛ́ n ceri lɛlɛɛ yɛ́ nɛ nkíŋniŋɛ pɔ́ n kɑm! Amɑ́ li nkpéni pékɑɑlɛnlɛ, ɑ́ɑ yɛ́ fe pɔkɛ́ li yɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Siyɑ́ɑ sɛ-i kɛ pipɔ́lɑ́ɑrɔ ɑpi itɔpilũ kɛcirɛ nɛ kɛkɑ́ípi pɔ́ n wɑinɛ yɛ sɔ́ntilɛ, ɑpi ɑwɛ́lɛ́ nnɛ́í pɔ́ n cɔ́ŋlɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Pi yɛ́ nɔ́ nɛ pipɔ́kɔ́ nnɛ́í nɑ̃́ kpɑ́tɑ́-kpɑ́tɑ́, ɑ́pi ripɔ́pɑrɛ ríkɑ pɔ́ yɑ́nɛ tikɛ́ ricɔ kɛcɑ́ɑ́ n tɔsilɛ̃. Kɑ́ɑ kumúŋɛ́ kpɛ-i kɛ Uléécɑɑ uu picomɛ pɔ́ ń kɑ n ceri nnyɑ kɑi lɛ̃ pɔ́ wɑinɛ. ");
INSERT INTO soy_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yeesu uu Uléécɑɑ kɛyɔ loni uu pikpéensɛ pilɑ́kɑsɛ kɑ́pɑ́ɑ́ ");
INSERT INTO soy_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","un pi tee rɛ: Li wɔlɑɑlɛ̃ tɛ: Pi yɛ́ kɛnɛ́yɔ sée rɛ kɛyómɛyɑ́hɑɑyɔ. Amɑ́ nɔ̃́ nɛ kɛ ripɔ́lɔ́sɛlɛ piyɑɑlukɛ kuhorɛ! ");
INSERT INTO soy_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ḿpɑ́ kɛyɑ́ɑ kɛ́ye kɛ Yeesu uu yɛ Uléécɑɑ kɛyɔ-i n céési. Pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ nɛ isé picélɑɑ nɛ kuyu pisoi kɛcirɛ ɑpí n wɛ́ɛ́si pikɛ́ Yeesu kpu. ");
INSERT INTO soy_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Amɑ́ ɑ́pi ceri lɛ̃ kɑpi yɛ́ n wɑ likɛ́ nɛ lɛ̃, likumúŋɛ́ rɛ kuyu nnɛ́í yɛ pɛɛ kutu u cɔlɛnlɛ ńsɔnɛ. ");
INSERT INTO soy_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Kɛ Yeesu uu kɛyɑ́ɑ kɛnyinɛ Uléécɑɑ kɛyɔ-i n céési un Nsímɛ́ Kɛcirɛ símisi, pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ nɛ isé picélɑɑ nɛ kuyu piwɛ́ɛ́sɛ ɑpi kpɑ́fúpɔ ");
INSERT INTO soy_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ɑpi u pisɛ rɛ: A rɔ́ símisi, ńnɑŋɛ ń-ye kɑɑ́ nɛ nní wɑi? Wóo ncée pɔ́ hɛ rɛ ɑ lɛ̃ wɑ? ");
INSERT INTO soy_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yeesu uu pɛɛ pi pɛsɛ rɛ: Nɛ lɑ kɛ́ nsɛ nɔ́ pisɛ. Ani nɛ́ símisi: ");
INSERT INTO soy_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Nɛ lɑ kɛ́ nɔ́ pisɛ rɛ Uléécɑɑ nɛ́ɛ pisoi pɛɛ Yohɑni tummɛ rɛ ukɛ́ pisoi míni wolɛ? ");
INSERT INTO soy_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Api pimɛcɔpɛcirɛ n kɛŋɛnɛ rɛ: Tɔn nkpéni m mɑɑ rɛ Uléécɑɑ yɛɛ u tummɛ, u yɛ́ rɔ́ pisɛ rɛ: Kɑi pɛɛ íye wɑ kɑ́ri nɛ Yohɑni nsímɛ́ ŋmurɛi? ");
INSERT INTO soy_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Amɑ́ tɔn kɔ m mɑɑ rɛ: Pisoi pɛɛ u tummɛ, kuyu nnɛ́í pikɔ́ yɛ ɑpɑrɛ rɔ́ tɔ́ɔ́kɛɛnɛ ɑpi rɔ́ kóni, likumúŋɛ́ rɛ pi nɛ kɛfɑ tɛnɛlɛ rɛ Yohɑni yɛ ɑntepu lɛ. ");
INSERT INTO soy_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Api pɛɛ rinɔ́ɔ u yɔ́su rɛ: Ári nyu uyɛɛ píniwolɛ u n tummɛ. ");
INSERT INTO soy_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yeesu uu rinɔ́ɔ pi pɛsɛ rɛ: Nɛ̃́ ɑ́m nɔ́ símisinɛ ńnɑŋɛ mmɛ̃ kɑḿ nɛ lɛ̃ n wɑi. ");
INSERT INTO soy_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yeesu uu lɛ̃ mɛmɑ́ɑ́ kɛnyɑ́rũ nkɛ́ pisoi mɑɑ rɛ: Utisi unyinɛ yɛɛ we, uu ɑléé nyɛ̃ kɑpi yɛ n sée rɛ fiinyi kɛcɑrɛ tɑmɛsi uu pikɛikɔ́ wɛ́ɛsi rɛ pikɛ́ kɛkɛcɑ́ɑ́ m pɑílɛ̃, uu pɛɛ ncée tɑɑ-tɑɑ sĩ ukɛ́ hɑ nɑ́ŋɑipɔ. ");
INSERT INTO soy_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Kɑi ɑléépipi nyɛ̃ kutúũ n tu, uu ukɛikɔ́ unyinɛ pɛpɛɛ ɑléé nyɛ̃ kɛcɑrɛ kɛcɑ́ɑ́ ḿ pɑílɛ̃ kɛ́mɛɛ tum tɛ ukɛ́ hɑ ɑléépipi ɑnyinɛ u yɔ́ɔmɛ. Amɑ́ ɑpi u kɑii ɑpi mɛnípɛ ŋmɑnɛ u lɑkɑsɛ. ");
INSERT INTO soy_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ucɑrɛte uu kɔ ukɛikɔ́ féé tumpɔ, ɑmɑ́ pɛpɛɛ ɑléé nyɛ̃ kɛcɑ́ɑ́ ḿ pɑílɛ̃ ɑpi kɔ uyɛ̃ ticuruu kɑii ɑpi u lɑ́misi ɑpi mɛnípɛ ŋmɑnɛ u lɑkɑsɛ. ");
INSERT INTO soy_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Uu kɔ ukɛikɔ́ tɑ́ɑ́nũ pitumɛ kpɑ́, ɑpi uyɛ̃ pɔ̃́ itói wɑi ɑpi lɑ́kɑsɛ. ");
INSERT INTO soy_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ucɑrɛte uu pɛɛ rɛ: Íye kɑm nkpéni wɑinɛ? Nɛ́ unɛ́ŋmɑ́nɛ lɑlɑ tũ. In n lɑ, pi yɛ́ u wuri. ");
INSERT INTO soy_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Amɑ́ kɛ pɛpɛɛ ɑléé nyɛ̃ kɛcɑ́ɑ́ ḿ pɑílɛ̃ ɑpi u n yɛ̃́, ɑpi símɑɑnɛ rɛ: Nkó yɛɛ yɛ́ mɑsí usɑ́ɑ ikulɑnlũ nnɛ́í n te. Ani kɑm tɔkɛ́ u kpu ɑri pɛɛ ikúlɑnlũ iyɛ̃ n té. ");
INSERT INTO soy_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Api kɛcɑrɛ kɛ̃ ilúkɛ́ u lesɛpɔ, ɑpi u kopu. Íye kɛ ucɑrɛte uu wɑinɛ? ");
INSERT INTO soy_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","U sɔ́ntilɛ ukɛ́ pi kṍ, uu pisoi féé kɛcɑrɛ múísɛ. Kɛ pisoi ɑpi ɑnɔ́ɔ nyɛ̃ n kṍ, ɑpi rɛ: Asei kɛcɑ́ɑ́, ɑ́i lɛ̃ wɑinɛ. ");
INSERT INTO soy_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Amɑ́ Yeesu uu pi nyɑ́nɛi uu rɛ: In lɛɛ ni, lɛ̃ kɑpi nní Nléécɑɑsimɛ́ ritɛlɛ́ kɛ́mɛɛ n wɔ́i ɑsei rɛ íye? Ái pi wɔi rɛ: Tipɑrɛ kɛ pimɔ́mɛ ɑpi n fóm tɛɛ pɑnsɛ ricírɛ-cirɛ tɛɛ kɛnui-i ń wee? ");
INSERT INTO soy_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Lin úye n fóm un tipɑrɛ tɛ̃ tinkpɔu, u yɛ́ selesi. Lin úye n fóm tin ukɛcɑ́ɑ́ n loó, ti yɛ́ u nɑ̃. ");
INSERT INTO soy_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ nɛ isé picélɑɑ ɑpi kumúŋɛ́ kpɛ-i n wɛ́ɛ́si pikɛ́ Yeesu tĩ, ɑmɑ́ pin pɛɛ kuyu pikɔ́ wuru. Pi ceri rɛ pɛ̃ kɛ Yeesu kɛnyɑ́rũ ɑkɛ́ nɛ mɑ́nɛ. ");
INSERT INTO soy_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Api pɛɛ Yeesu pimúŋɑɑ loni. Api lɛ̃ nnyɑ pisoi pinyinɛ ukɛmɛɛ tumpɔ, ɑpí n wɑi yɑrɛ pisoi pɛɛ ɑsei n wɛ́ɛ́si. Li pɛɛ lɛ̃ wɑilɛ pikɛ́ nɛ n fe pikɛ́ u n tĩ́ pikɛ́ uyɔ́ɔpi yɛɛ ńnɑŋɛ m mɑ́ ukɛ́ nɛ u n túhɑɑnɛ ɑnipɛ-i u n wɑ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Api pɛɛ u pisɛ rɛ: Sɑ́ɑ, tɔ yɛ̃ tɛ lɛ̃ kɑɑ n símisi pɔn céesi yɛ ɑsei lɛ, ɑ́ɑ nkpɑ́ni usoi úkɑ kɛwuu túúni. Pɔ yɛ Uléécɑɑ ncee pisoi céesilɛ nɛ ɑsei. ");
INSERT INTO soy_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Lɛ̃ nnyɑ, ɑ rɔ́ símisi in tɛ irɔ́sé yɛ ncée hɛ rɛ pikɛ́ Sesɑɑ lɑmpoo hɛ́ɛlɛ nɛ́ɛ ɑ́pi kɑpɛ hɛ́ɛ́lɛ? ");
INSERT INTO soy_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Amɑ́ Yeesu uu pimɛsɔhɔ ceru, uu pi mɑɑ rɛ: ");
INSERT INTO soy_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Ani kɛwóó kɛnyinɛ nɛ́ nyísɛ nkɛ̃́. Úye ríyu nɛ úye rinyiri tɛɛ kɛkɛcɑ́ɑ́ we? Api rinɔ́ɔ yɔ́su rɛ Sesɑɑ lo. ");
INSERT INTO soy_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yeesu uu pɛɛ pi mɑɑ rɛ: In lɛ̃, ɑni Sesɑɑ likɔ́ Sesɑɑ pɑ, ɑni Uléécɑɑ likɔ́ Uléécɑɑ pɑ. ");
INSERT INTO soy_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ápi fe pikɛ́ u tĩ, mmɛ̃ kuu nní kuyu pikɔ́ kɛyu-i n símisi nnyɑ. Amɑ́ umɛyɔ́ɔ́ mɛ̃ ɑmɛ nnɔ́ɔ pi yipu ɑpi sɛ́ɛ́. ");
INSERT INTO soy_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Pisɑtusee pinyinɛ ɑpi Yeesu kɛ́mɛɛ hɑpɔ. Pɛpɛɛ múílɛ̃ tɛ pikpɔkpɔ ɑ́pi nkpɔ-i yisinɛ. ");
INSERT INTO soy_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Api nní Yeesu pisɛ rɛ: Sɑ́ɑ, lɛ̃ kɛ Moisi uu isé ń wɔ́i yɛ nní: Úye umɑɑ un n kpu uu unɔ́si tíyɛ úu nɛ kɛwɑ̃́, uuwɑ̃ yɛɛ yɛ́ unɔ́si uyɛ̃ kukúmɑnnɔsi kpísi uu umɑ́ɑ mpuri wɑi. ");
INSERT INTO soy_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Amɑ́ pimɑ́rɛcɔ pisɛɛi pinyinɛ pɛɛ pɛɛ́ we. Ufoí uu unɔ́si kpísi, uu kpi úu nɛ kɛwɑ̃́. ");
INSERT INTO soy_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ulírũ uu ukúmɑnnɔsi kpísi, ");
INSERT INTO soy_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","utɑ́ɑ́nũ pɔ́ɔ kɔ pikpíkɛ́ u kpɑ́, uyɛ̃ uu kɔ kpi. Pikɛsɛɛi kɛ̃ ɑpi lɛ̃ kukúmɑnnɔsi u kpíkɛsi ɑpi kpíni úkɑ úu kɔ pɛɛ́ nɛ kɛwɑ̃́ u mɑri. ");
INSERT INTO soy_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Unɔ́si pɔ́ɔ kɔ mɛtɔ́rɔɔ kpi. ");
INSERT INTO soy_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kɛyɑ́ɑ kɛ̃ kɛ pikpɔkpɔ ɑpi nkpɔ kɛ́mɛɛ n yisinɛ, pitisi pɛ̃ kɛsɛɛi kɛcɔpɛ úye yɛɛ yɛ́ hɑ uulɑ? Liriyíkí rɛ pinnɛ́í pɛɛ kunɔ́si u kpíkɛsi! ");
INSERT INTO soy_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yeesu uu rinɔ́ɔ pi yɔ́su rɛ: Kɛtẽ nté pitisi yɛ pinɔ́si kpíkɛsilɛ, pinɔ́si pɔ́ɔn kɔ pilɑ sɔ́ɔnkɛɛ. ");
INSERT INTO soy_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Amɑ́ pitisi nɛ pinɔ́si pɛɛ nɛ n sɑ́ rɛ pikɛ́ pikpɔkpɔ kɛ́mɛɛ yisi pikɛ́ hɑ kɛtẽ fɑlɛ-i n we ɑ́pi pinɔ́si kpíkɛsinɛ, ɑ́pi kɔ pilɑ sɔ́ɔnkɛɛnɛ. ");
INSERT INTO soy_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ápi píkɑi kpinɛ, piléécɑɑtumɛ kɑpí nɛ mɛnyínɛ we. Pi Uléécɑɑ sipipi lɛ, liriyíkí rɛ pi kpulɛ ɑpi kɔ nkpɔ kɛ́mɛɛ yisi. ");
INSERT INTO soy_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moisi yɛ pɛɛ pikpɔkpɔ mɛyisɛ nkpɔ kɛ́mɛɛ nkɔ́ pisímɛ́ mɑsilɛ uritɛlɛ́ tɛ-i kuu kuhííhíí kpɛɛ n torɛ nsímɛ́ ń símisi. U pɛɛ́ mɑɑ rɛ: Upíimɑ yɛ Apirɑhɑm Uleecɑɑ nɛ Isɑɑki Uleecɑɑ nɛ Yɑkupu Uleecɑɑ lɛ. ");
INSERT INTO soy_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Yeesu uu kpɑ́ rɛ: Uléécɑɑ úu pikpɔkpɔ Uleecɑɑ, ɑmɑ́ u pinyɑ́nnyɑ̃́ Uleecɑɑ lɛ. Liriyíkí rɛ uyɛ̃ nnyɑ kɛ pinnɛ́í ɑpi nyɑ́ni. ");
INSERT INTO soy_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Isé picélɑɑ pinyinɛ ɑpi rinɔ́ɔ yɔ́su ɑpí mɑɑ rɛ: Sɑ́ɑ, pɔ símisilɛ lin nyɑḿ. ");
INSERT INTO soy_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Lɛ̃ mɛmɑ́ɑ́, ɑ́pi ńkɑ ncɔ pipisɛ u peenu. ");
INSERT INTO soy_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yeesu uu pi mɑɑ rɛ íye kɛ usoi uu yɛ́ fe uú mɑɑ rɛ uyɛ̃ kɛ Uléécɑɑ uu n wɛ́ɛ yɛ Tɑfiti kɛpipi lɛ. ");
INSERT INTO soy_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Likumúŋɛ́ rɛ Tɑfiti yɛ siyómɛ ritɛlɛ́-i rihɑɑ rɛ: Upíimɑ yɛ Unɛ́píimɑ mɑɑ rɛ: A kunɛ́lukɛ-lukɛ-mɛ̃ kɛ́yukɔɔ́tonɛ-i tonɛ ");
INSERT INTO soy_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","hɑ́i nɛ kumúŋɛ́ kpɛ-i kɑm yɛ́ pipɔ́lɑ́ɑrɔ kɛpɔ́nyɑ́lɛ-i n cɔ. ");
INSERT INTO soy_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Tɑfiti yɛ̀ɛ̀ u sée rɛ Upíimɑ. Íye kɛ uyɛ̃ cirɛ uu yɛ́ kɔ pɛɛ Tɑfiti Kɛpipi? ");
INSERT INTO soy_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Kɛ risoiwuí nnɛ́í ɑri kutu n cɔ́lɛ̃, Yeesu uu upipirɛtiki mɑɑ rɛ: ");
INSERT INTO soy_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Ani isé picélɑɑ nɛ nɔ́mɛnɛ́círɛ tĩ. Pikɛ́ nɛ ɑtúkɑnkɑ cɑɑ-cɑɑ n kɔɔnii nɛ pisoi pikɛ́ ɑyɑ́ɑ kɛ́mɛɛ pi n yɑ́hɑɑnkɛɛ yɛɛ ripɔ́ɔ pi we. Ayómɛyɑ́hɑɑlee sitonɛ foí nɛ kɛlukɛ kɛ́mɛɛ sitonɛ foí kɑpí lɑ. ");
INSERT INTO soy_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Pi yɛ lɛ̃ kɛ pikúmɑnnɔsi ɑpi m mɑ́ nnɛ́í yɔ́ɔilɛ ɑpi yɛ pɛɛ kɛyómɛ yɑ́ɑ́si mɛcɑ́ɑ yɑrɛ pi pisoi sɔnɛ lɛ. Uléécɑɑ yɛ́ nɛ pi túhɑɑnɛ uu íwɛ pi wɑi ɑ́i kumúŋɛ́ mɑ́. ");
INSERT INTO soy_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yeesu uu inípɛɛ síkɑ, uú yɛ́nu pin kei kɑpi yɛ ihɛɛ Uléécɑɑ kɛyɔ-i n wɑ piihɛɛ sɑriipɔ. ");
INSERT INTO soy_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Uu kɔ ukúmɑnnɔsi wɛkɔɔ́ unyinɛ yɛnu un sítɑnkɑ́ sitɛ́ sɑ́pɔlɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Uu pɛɛ́ mɑɑ rɛ: Asei kɑm nɔ́ símisi, unɔ́si nkó yɛ hɛlɛ ɑi pisoi picɔ mpí tɔ́su. ");
INSERT INTO soy_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Likumúŋɛ́ rɛ lɛ̃ kɑ́pi nɛ líkɑ n wɑi kɛ mpí nnɛ́í ɑpi kei risɑ́pɔ, ɑmɑ́ ulikɔ́ kɛcirɛ, lɛ̃ kuu m mɑ́ nnɛ́í ukɛ́ nɛ ilukɛ n lɔ kɛ uyɛ̃ uu wɑipɔ. ");
INSERT INTO soy_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Pisoi pinyinɛ ɑpi Uléécɑɑ kɛyɔ nsímɛ́ n símisi pin tee rɛ kɛ nyɑmlɛ hɑ́i, nɛ kɛɑpɑrɛ kɛcirɛ nɛ ilũ kɑpi Uléécɑɑ n hɛkɛsi. Amɑ́ Yeesu uú mɑɑ rɛ: ");
INSERT INTO soy_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Siyɑ́ɑ yɛ sɔ́ntilɛ kɛ ɑpɑrɛ nyɛɛ nní ń tɔ́siinɛlɛ̃ tikɑ ɑ́ri m mɛ́suninɛ. Lɛ̃ kɑni nní n nyɑ́ni yɛ sɔ́ntilɛ likɛ́ fori tɛ́kɛ́-tɛ́kɛ́. ");
INSERT INTO soy_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Api pɛɛ u pisɛ rɛ: Sɑ́ɑ, píyei kɛ lɛ̃ nnɛ́í ɑí hɑ sɔ́nti? Yo yɛɛ yɛ́ kumúŋɛ́ kpɛ-i kɛ lɛ̃ nnɛ́í ɑí hɑ n sɔ́nti rɔ́ nyísɛ? ");
INSERT INTO soy_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yeesu uu rinɔ́ɔ yɔ́su rɛ: Ani nɔ́mɛnɛ́círɛ tĩ ńsɔnɛ, ɑ́ni kɑpɛ tíyɛ unyinɛ ukɛ́ kuyúi nɔ́ tɑ̃. Likumúŋɛ́ rɛ pisoi mɛyɑ̃́ yɛ́ sɔ́nɑɑmɛ nɛ rinɛ́nyíri pin tee rɛ: “Nɛ́ɛ uyɛ̃ kɛ Uléécɑɑ uu n wɛ́ɛ”. Likumúŋɛ́ yɛ kɔ nyɑhɑimɛlɛ, ɑmɑ́ ɑ́ni kɑpɛ pi ritiki. ");
INSERT INTO soy_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Nɔn píyei ɑtɔpi nɛ pitele nnɛ̃́ n kõ, nɔ́sinɛ́wuu ɑ́si kɑpɛ tɔ. Li pisɛ rɛ lɛ̃ nnɛ́í likɛ́ kɑm kɛlenɛ, ɑmɑ́ kɛtẽ kɛtɔ ɑ́kɛ kɑhɑnɛ n tu. ");
INSERT INTO soy_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Uu pɛɛ lɛ̃ mɛmɑ́ɑ́ kpɑ́ rɛ: Nsoipuri nnyinɛ yɛ́ yisi nn nsoipuri ncɔ nɛ tɔpu, kɛyɔ́ɔpitẽ ɑkɛ kɛyɔ́ɔpitẽ kɛcɔ nɛ tɔpu. ");
INSERT INTO soy_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kɛtẽ yɛ́ yéŋesi ɑ́i nyɑḿ, itói yɛɛ n tɛŋni nɛ nkṹ nn silõ silõ leeri, mɛwɑi mɛwɑi mɛɛ iwɑmɛ ń we yɛ́ kɔ wɑpisi, nɛ linyísɛ-nyísɛ lɛɛ kɛyómɛcɑɑ-pɔ n léeri yɛ́ kɔ wɑpisi. ");
INSERT INTO soy_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Amɑ́ likɛ́ kɛlenɛ lɛ̃ n wɑ, pi yɛ́ nɔ́ cɔ́pii ɑpi íwɛ nɔ́ wɑi piyómɛyɑ́hɑɑ nnyɑ, ɑpi ɑyómɛyɑ́hɑɑlee-i nɛ piyɔ́ɔpi nɛ kuyu piwɛ́ɛ́sɛ kɛ́mɛɛ nɛ nɔ́ túhɑɑnɛ ɑpi nɛ̃́ nnyɑ kukpɑniilee nɔ́ wɑi. ");
INSERT INTO soy_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Lɛlɛɛ yɛ́ kɛpolɛ nɔ́ hɛ nɔkɛ́ nɛ ɑnɛ́seérɑ n lesɛ. ");
INSERT INTO soy_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Lɛ̃ nnyɑ, ɑni m múílɛ̃ ńsɔnɛ. Áni kɑpɛ mmɛ̃ kɑni yɛ́ ḿ mɑlɛ nɔkɛ́ nɛ nsímɛ́ kɛ́mɛɛ ń le kɛcɑ́ɑ́ m músu. ");
INSERT INTO soy_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Nɛ́ rinɛ́cúruu ɑnɔ́ɔ nyɛ̃ kɑi m pisɛ rɛ nɔkɛ́ mɑlɛ nɛ mɛwɛ́ɛ́sɛsɔhɔ nɔ́ hɛ, ɑi tíyɛsɛ nɔ́unɛ́lɑ́ɑrɔ úkɑ úu yɛ́ fe ukɛ́ nɔ́nnɛ́kɔ́ rikósɛ. ");
INSERT INTO soy_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Nɔ́pinɛ́sɑ́ɑ nɛ nɔ́pinɛ́ni nɛ nɔ́pinɛ́wɑ̃́ nɛ nɔ́pinɛ́mɑ́ɑ nɛ nɔ́pinɛ́mɑ́rɛcɔ nɛ nɔ́pinɛ́sɑ́nɛ yɛ́ nɔ́pinɛ́lɑ́ɑrɔ ɑnipɛ-i nɔ́ wɑ ɑpi nɔ́mɛnɛ́yɑ̃́ kóni. ");
INSERT INTO soy_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Tinɛ́nyíri nnyɑ, ḿpɑ́ úye yɛ nɔ́inɛ́puri yulunɛ. ");
INSERT INTO soy_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Amɑ́ ḿpɑ́ nɔ́nnɛ́nyúpi nsɛ ńn pɔlunɛ. ");
INSERT INTO soy_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ani n ŋmɔ́ɔ́púlɛ̃, lɛlɛɛ yɛ́ tíyɛsɛ ɑní nɛ nɔ́nnɛ́fɑ́ɑ lɔlu. ");
INSERT INTO soy_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Nɔn hɑ píyei n yɛ̃ ɑtɔpilee ɑn Yerusɑlɛm kɛkɑ́ípi wɑilɛ̃, ɑni ceri rɛ umɛforɛ yɛ nnyɑ́ɑ̃ wɑlɛ. ");
INSERT INTO soy_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Pɛɛ́ uyɛ-i, pɛpɛɛ Yutee-i ń we yɛ́ hɑ wúrumpɔ, ɑpi ɑkúú-mɛ̃ tɑɑ́, pɛpɛɛ Yerusɑlɛm kuyu kɛcɔpɛ ń we, ɑpi kɛtɑɑ sĩ, pɛpɛɛ sicɑrɛ-mɛ̃ ń we ɑ́pi fenɛ pikɛ́ kuyu-mɛ̃ kuimɛ. ");
INSERT INTO soy_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Likumúŋɛ́ rɛ siyɑ́ɑ sɛ̃ kɛ́mɛɛ kɛ Uléécɑɑ uu sisoipipi mɛwɑi kópɛ si cɛɛinɛ. Sikɛmɛɛ́ kɛ lɛ̃ nnɛ́í lɛɛ ɑ́tɛlɛ́-i n wɔ́lɑɑlɛ̃ ɑi wɑinɛ. ");
INSERT INTO soy_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Íwɛ kɛ pifɑni nɛ pimɑ́rɛni ɑpí hɑ siyɑ́ɑ sɛ-i topori. Mpɔ́ɔcɑɑi píimɑ yɛ hɑ kuyu kpɛ-i wenɛ, Uléécɑɑ yɛ́ kuyu kpɛ̃ pikɔ́ ukuwɔi nyísɛ. ");
INSERT INTO soy_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Pi yɛ́ nɛ ɑtɛ́hɛ cɑɑcɑɑ pi kṍ, ɑpi sitẽ nnɛ́í kɛ́mɛɛ ilɑ́si pi cɔ́pii, piyómɛyɑ́hɑɑcirɛ́ ɑpi Yerusɑlɛm cɔpisi hɑ́i nɛ siyɑ́ɑ sɛ̃ kɛtɔ-pɔ. ");
INSERT INTO soy_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Li yɛ́ ituŋɛ nɛ iwɑ́rɛ nɛ ɑwɑ́rɛpi-i linyinɛ nyísɛ. Mpɔ́ɔcɑɑi yɛ́ kɛtẽ kɛcɑ́ɑ́ pisoi nnɛ́í lõ, mínimɑɑ iwɔɔ píimɑ ii nfɑsimɛ́ pi tɑni. ");
INSERT INTO soy_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Pisoi yɛ́ nɛ iwɑmɛ kpí pin lɛlɛɛ kɛtẽ kɛcɑ́ɑ́ n sɔ́nti nfɑsimɛ́ wɑi, likumúŋɛ́ rɛ li yɛ́ kɛyómɛcɑɑ-pɔ linɑŋɛ-nɑŋɛ lémesi. ");
INSERT INTO soy_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Pi yɛ́ pɛɛ Usoi Kɛpipi yɛ̃ kɛn kuhopɛ kɛcɑ́ɑ́ wemɛ nɛ kɛnnɑŋɛ nɛ kɛmɛyɔɔpi. ");
INSERT INTO soy_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Mɛwɑi mɛ̃ mɛn hɑ piwɑi n korɑɑnɛnɛ, ɑni kɛcírɛ nyɛrɛ ɑni ɑ́yu síkɑ, likumúŋɛ́ rɛ nɔ́kɛnɛ́ŋmɛ́hɛrɛɛ yɛ lɛ̃ tulɛ. ");
INSERT INTO soy_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yeesu uu lɛ̃ mɛmɑ́ɑ́ kɛnyɑ́rũ nkɛ́ pi wɑi rɛ: Ani kúfikiyee nkú nɛ ɑléécɔ nnɛ́í ripɑí. ");
INSERT INTO soy_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Nɔn píyei n yɛ̃ ɑpɛ́i fɑlɛ ɑn n torɑɑlɛ̃, nɔ yɛ nɔ́rinɛ́cúruu cerilɛ rɛ kupii yɛ nyɑhɑilɛ. ");
INSERT INTO soy_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Lɛ̃ cirɛ yɛ ni, nɔn hɑ píyei n yɛ̃ mɛwɑi mɛ̃ mɛn n wɑpisi, ɑni ceri rɛ Uléécɑɑ iyɔɔpi yɛ nyɑhɑilɛ. ");
INSERT INTO soy_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Asei kɑm símisi: Pisoi kunɑi nkú ɑ́ku tɔ́sunɛ kɛlenɛ nní nnɛ́í likɛ́ nɛ ń kɑm. ");
INSERT INTO soy_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kɛtẽ nɛ kɛyómɛ yɛ́ tɔsí, ɑmɑ́ ɑnɛ́nɔ́ɔ ɑ́ɑ mɛtɔ́ŋɛ́ mɑ́. ");
INSERT INTO soy_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Ani nɔ́mɛnɛ́círɛ tĩ, ɑ́ni kɑpɛ tíyɛsɛ nɔ́nnɛ́fɑsimɛ́ nkɛ́ mɛyɑ́nsei ɑnyɑ̃́ nɛ pítɑnirɛ́-mɛ̃ pɛlɛ. Áni kɑpɛ kɔ mɛyɑ́nsei kɛtẽ kɛcɑ́ɑ́ likɔ́ nfɑsimɛ́ n wɑi. Insɑ́ lɛ̃, kɛtúhɑɑnɛyɑɑ yɛ́ nɔ́ rikɑikɑi ");
INSERT INTO soy_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","yɑrɛ ripinɛ. Likumúŋɛ́ rɛ kɛtẽ nté pisoi nnɛ́í kɛ kɛyɑ́ɑ kɛ̃ ɑkɛ lɛɛrinɛ. ");
INSERT INTO soy_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Áni kɑpɛ lɔpilɛ, ɑni yɛ ḿpɑ́ píyei Uléécɑɑ we nɔkɛ́ nɛ ńnɑŋɛ n yɛ̃́, ɑní nɛ lɛ̃ nnɛ́í lɛɛ n wɑpisinɛ kɛ́mɛɛ ŋmɛ́hɛrɛɛ ɑni kɔ hɑ nɛ Usoi Kɛpipi kɛyu-i nyɛrɛ. ");
INSERT INTO soy_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Kɛtúŋɛ́ kɛ Yeesu uu yɛ pɛɛ Uléécɑɑ kɛyɔ-i céesi, ɑmɑ́ lin kɛsinɛ n wɑ, uú hɑ kɛkúúpi kɑpi yɛ n sée rɛ Olifiyee rikúú kɛcɑ́ɑ́ n we. ");
INSERT INTO soy_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Kuyu pikɔ́ nnɛ́í ɑpi yɛ mmɑrɛ mɑrɛ Uléécɑɑ kɛyɔ-i weri pikɛ́ kutu u ricɔ. ");
INSERT INTO soy_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Kɛ ɑnyɑ̃́ nyɛ-i kɑpi yɛ ɑkpɔ́nɔ́ nyɛɛ ɑ́ɑ pitɛ m mɑ́ n li ɑɑ n nyɑhɑimɛ, ");
INSERT INTO soy_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ nɛ isé picélɑɑ ɑpi ncée n wɛ́ɛ́si kɑpi yɛ́ nɛ Yeesu ń kpu, ɑmɑ́ pin pɛɛ kuyu pikɔ́ wuru. ");
INSERT INTO soy_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Setɑni uu Yutɑsi kɑpi yɛ n sée rɛ Isikɑriyɔɔti loni. U pɛɛ pipirɛtiki kɛfi nɛ pitɛ́ pɛ̃ usɛ lɛ. ");
INSERT INTO soy_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yutɑsi nɛ pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ nɛ kuyómɛyɑ́hɑɑlee pimɛ́rɛ́ piwɛ́ɛ́sɛ ɑpi lɛ̃ kuu yɛ́ Yeesu n tĩ́ ukɛ́ piɑnipɛ-i n wɑ kɛcɑ́ɑ́ kómɛinɛ. ");
INSERT INTO soy_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ai pi lɑrisi ńsɔnɛ ɑpi rinɔ́ɔ yekei rɛ pi yɛ́ siwóó u hɛ́ɛ́lɛ. ");
INSERT INTO soy_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yutɑsi uu ŋmurɛi uu icée sɔnɛ n wɛ́ɛ́si ukɛ́ nɛ Yeesu pi rimúísɛ risoiwuí ɑ́ri kɑpɛ n nyu. ");
INSERT INTO soy_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Kɛyɑ́ɑ kɛ̃ kɑpi yɛ ɑkpɔ́nɔ́ nyɛɛ ɑ́ɑ pitɛ m mɑ́ n li, kɛyɑ́ɑ kɛ̃ kɑpi yɛ kɔ nkpɔ mɛlɔ́ɔ́ ɑnyɑ̃́ isɑŋ n kṍ ɑkɛ tulu. ");
INSERT INTO soy_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yeesu uu pɛɛ Piyɛɛ nɛ Yohɑni tum uu rɛ: Ani hɑ nkpɔ mɛlɔ́ɔ́ ɑnyɑ̃́ ilukɛ rɔ́ wɑ tɔkɛ́ li. ");
INSERT INTO soy_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Api u pisɛ rɛ: Yei kɑɑ́ lɑ tɔkɛ́ hɑ liilukɛ wɑ? ");
INSERT INTO soy_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Uu rinɔ́ɔ pi yɔ́su rɛ: Ani kutu ricɔ: Nɔn hɑ píyei kuyu n lompɔnɛ, utisi unyinɛ yɛɛ kɛcɔ́rípi nɛ míni n topori yɛ́ nɛ nɔ́ risɑ́nɛ. Ani u ritiki hɑ́i nɛ kɛ́yɔ kɛ-i kuú hɑ n loninɛ. ");
INSERT INTO soy_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ani úyɔte mɑɑ rɛ: Urɔ́sɑ́ɑ yɛ pɔ́ pisɛ rɛ yei yɛ kulee kpɛ-i kɛ u nɛ upipirɛtiki ɑpi nkpɔ mɛlɔ́ɔ́ ɑnyɑ̃́ ilukɛ n lenɛ? ");
INSERT INTO soy_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","U yɛ́ kɛ́yɔ kɛcɑ́ɑ́ kulee mɑɑ kunyinɛ kɑpi n nyɔ́ɔnsɛ nɔ́ nyísɛ. Kei kɑni yɛ́ ɑnyɑ̃́ ilukɛ wɑ. ");
INSERT INTO soy_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Api símpɔ ɑpi ḿpɑ́ yo lɛɛpɔ yɑrɛ kɛ Yeesu uú pɛɛ pi ḿ mɑ, ɑpi nkpɔ mɛlɔ́ɔ́ ɑnyɑ̃́ ilukɛ wɑi. ");
INSERT INTO soy_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Kɛ ituŋɛ ii n tu, Yeesu nɛ upitumɛ ɑpí tonɛ rɛ pikɛ́ li. ");
INSERT INTO soy_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Uu pi mɑɑ rɛ: Li pɛɛ mɛyɑ́nsei ripɔ́ɔ nɛ́ wɑ rɛ tɔkɛ́ kɛsẽ́ nkpɔ mɛlɔ́ɔ́ ɑnyɑ̃́ ilukɛ nnyí li kɛ́ kɛlenɛ íwɛ li! ");
INSERT INTO soy_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Asei kɑm nɔ́ símisi rɛ ɑ́m pilukɛ i kpɑ́nɛ hɑ́i nɛ kumúŋɛ́ kpɛ-i kɛ Uléécɑɑ uu yɛ́ uiyɔɔpi kɛ́mɛɛ rɔ́ i n wɑ ɑri pɛɛ iɑsei nnɛ́í kóm. ");
INSERT INTO soy_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Uu pɛɛ kɛpóripi nɛ pítɑ kpísi uu Uléécɑɑ pɔɔnɛsɛ uu rɛ ɑni yɔsí ɑni hɔɔnɛ. ");
INSERT INTO soy_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Asei kɑm nɔ́ símisi rɛ ɑ́m píkɑi ɑléépipi pitɑ mpí pinírɛ́ kpɑ́nɛ hɑ́i nɛ kɛyɑ́ɑ kɛ̃ kɑm yɛ́ Uléécɑɑ iyɔɔpi kɛ́mɛɛ pi ń ntí. ");
INSERT INTO soy_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Uu kukpɔ́nɔ́ kpísi, kuu Uléécɑɑ m pɔɔnɛsɛ mɛmɑ́ɑ́, uu ku kpɔkɔ́ri uu pi ku pɑ uu rɛ: Inɛ́piŋɛ yɛ nnyí kɑm nɔ̃́ nnyɑ m pɑ́lɛ̃. Ani yɛ lɛ̃ wɑ ɑní nɛ kɛnɛ́cɑ́ɑ́ léisɛ. ");
INSERT INTO soy_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ilukɛ mɛlukɛ-mɑɑ́, uu kɔ kɛ́tɑporipi pi pɑ uu rɛ: Mɛnɛ́nyɛ yɛ mmɛ́, mɛ́nyɛ mɛɛ nɔ̃́ nnyɑ n kɔɔnu Uléécɑɑ uú nɛ nɔ́ séi rɛ nɔ́ nɛ uyɛ̃ ɑni kómɛinɛ. ");
INSERT INTO soy_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Amɑ́ ɑni ripɑí, uyɛɛ nɛ́ n yɑ́inɛ yɛ nté welɛ, tɔ́ nɛ uyɛ̃ tɔn kɛsẽ́ le. ");
INSERT INTO soy_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Mɛsei yɛ mɛ rɛ Usoi Kɛpipi yɛ tɔ́sulɛ yɑrɛ kɑi kɛkɛcɑ́ɑ́ n wɔ́lɑɑmɛlɛ̃. Amɑ́ usoi nkó yɛɛ yɛ́ Usoi Kɛpipi n yɑ́ɑ́, íwɛ kɛ liute uu topori. ");
INSERT INTO soy_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Api pɛɛ pimɛcɔpɛcirɛ pipísɛinɛ koru rɛ pikɛcɔpɛ úye yɛɛ yɛ́ mɛwɑi mɛ̃ wɑ. ");
INSERT INTO soy_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Pipirɛtiki ɑpi íkɛŋɛnɛ kɑ́pɑ́ɑ́ rɛ pikɛ́ yɛ̃́ tɛ pikɛcɔpɛ úye yɛɛ yɛ́ uwɛ́ɛ́sɛ. ");
INSERT INTO soy_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yeesu uu pi mɑɑ rɛ: Sitẽ piyɔɔpi yɛ sikɛcɑ́ɑ́ túnlɛ, pɛpɛɛ sikɛcɑ́ɑ́ iyɔ́ɔpi n le yɛ̀ɛ̀ tíyɛlɛ ɑpi pi n sélei rɛ “lisɔnɛ piwɑi.” ");
INSERT INTO soy_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Amɑ́ ɑ́i kɑpɛ lɛ̃ nɔ́kɛnɛ́mɛɛ́ n we. Nɔ́kɛnɛ́cɔpɛ úyukɔɔ́ kɑi pisɛ rɛ ukɛ́ usíńsɑ́. Li pisɛ rɛ úyukɔɔ́ ukɛ́ n we yɑrɛ ukɛikɔ́. ");
INSERT INTO soy_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ukɛikɔ́ yɛɛ ilukɛ n wɑi nɛ uyɛ̃ kuu ilukɛ n wɑi kɛcɔpɛ úye yɛɛ úyukɔɔ́? Ái uyɛ̃ kuu i n wɑii? Too, nɛ̃́ nɛ nɔ́kɛnɛ́cɔpɛ we yɑrɛ ukɛikɔ́ uyɛɛ ilukɛ n wɑi. ");
INSERT INTO soy_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Nɔ nɛ́ ritikilɛ nɛ ɑsei, nɔn kɑhɑri tɔ́ nɛ nnɔ̃́ tɔn nɛ ituŋɛ iyɛ-i kɑi nɛ́ ḿ peikɛɛ kɛ́mɛɛ we. ");
INSERT INTO soy_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Lɛ̃ nnyɑ kɑm Uléécɑɑ iyɔɔpi nɔ́ pɑnɛ yɑrɛ kɛ Unɛ́sɑ́ɑ uu nɛ́ i ḿ pɑ mɛcɔ. ");
INSERT INTO soy_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Tɔ́ nɛ nnɔ̃́ yɛ́ inɛ́yɔ́ɔpi-i kɛsẽ́ tonɛ ɑri le ɑri kɔ níru, ɑni sinɛ́yɔ́ɔpitonɛ-i tonɛ ɑni Isirɑyɛɛli ɑmɑrɛ kɛfi nɛ ɑtɛ́ nyɛ̃ túhɑɑnɛ. ");
INSERT INTO soy_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Simɔɔ, Simɔɔ, ɑ kutu ricɔ, Setɑni yɛ ncée we rɛ ukɛ́ pɔ́ pɑ́ŋɑi yɑrɛ kɑpi yɛ ɑsírɛ́ m pɑ́ŋɑi ɑpi ɑcɔ́lɛ́ lésɛ. ");
INSERT INTO soy_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Amɑ́ nɛ nɛ Uléécɑɑ pɔ́ tẽ́ tɛ ɑ́i kɑpɛ wɑ rɛ mpɔ́fɑtɛnɛ yɛ nɛ pɔ́ kpu. Amɑ́ pɔn píyei kɛnɛ́mɛɛ m pɛɛmɛ, ɑ pipɔ́mɑ́rɛcɔ itisi rikpɑ́sɛ. ");
INSERT INTO soy_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Piyɛɛ uu u mɑɑ rɛ: Upíimɑ, nɛ ŋmurɛi rɛ ḿpɑ́ in kukpɑniilee yɛ ku kɛ́ pɔ́ ritiki, nɛ́ɛ ḿpɑ́ nkpɔ yɛ mu tɔkɛ́ kɛsẽ́ kpu. ");
INSERT INTO soy_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yeesu uu rɛ: Piyɛɛ, nɛ pɔ́ mɑɑ rɛ icɑ̃́ ikɛ́ kɛlenɛ n kooi, pɔ́ mɛpehẽ mɛtɑɑni kɛsi rɛ ɑ́ɑ nɛ́ nyu. ");
INSERT INTO soy_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yeesu uu pɛɛ pi mɑɑ rɛ: Kɑm nɔ́ n tũ, ɑ́ni kɛwóó nɛ kulɔ́ɔ nɛ ɑnɛ́ɛ́ri rimmúlú, linyinɛ yɛ nɔ́ ripɑ́rílɛɛ? Api rɛ: Líkɑ ɑ́i tɔ́ ripɑ́rí. ");
INSERT INTO soy_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Uu pɛɛ pi mɑɑ rɛ: Amɑ́ úye un nkpéni kɛwóó m mɑ́, li pisɛ rɛ ukɛ́ kɛ rimúlú, úye un kɔ kulɔ́ɔ m mɑ́, li pisɛ rɛ ukɛ́ ku kpísi. Úye unsɑ́ kɔ titɔpitɛ́hɛ m mɑ́, li pisɛ rɛ ukɛ́ uilũ yɑ́ɑ́ uú nɛ risɛ lɔlu. ");
INSERT INTO soy_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Likumúŋɛ́ rɛ rinɔ́ɔ tɛ̃ kɑi kɛnɛ́cɑ́ɑ́ rítɛlɛ́-i n wɔ́lɑɑlɛ̃ tɛ: Pi piwɑikópɛkɔɔ́ kɛcɔpɛ u yekei yɛ wɑlɛ. Lɛlɛɛ kɛnɛ́cɑ́ɑ́ n wɔ́lɑɑmɛlɛ̃ yɛ tulɛ. ");
INSERT INTO soy_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Pipirɛtiki ɑpi u mɑɑ rɛ: Upíimɑ, ɑtɔpitɛ́hɛ ɑtɛ́ yɛ nnyɛ́. Uu rinɔ́ɔ pi yɔ́su rɛ: Li wɑlɛ. ");
INSERT INTO soy_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yeesu uu yisi uu Olifiyee rikúú kɛcɑ́ɑ́ sĩ́ yɑrɛ kuu yɛ pɛɛ kei n sɔ́nɛ mɛcɔ. Upipirɛtiki ɑpi u tiki. ");
INSERT INTO soy_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Kɑpi kɛlõ kɛ̃ n tuipɔ, uu pi mɑɑ rɛ: Ani yɛ kɛyómɛ yɑ́ɑ́si ɑ́ni kɑpɛ nɛ pipeikɛɛ kɛ́mɛɛ ń loó nnyɑ. ");
INSERT INTO soy_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Uu lɛ̃ mɛmɑ́ɑ́ nɛ kɛtɑɑ pi wɑi, tinɑ̃ tɛɛ pikɛcɔpɛ ń we yɛ tu yɑrɛ kunípɛ ripɑrɛ mɛfomɛ kumúŋɛ́, uú hɑ wulɑ uu kɛyómɛ yɑ́ɑ́si rɛ: ");
INSERT INTO soy_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Sɑ́ɑ, in tɛ pɔ ŋmurɛi, ɑ tíyɛsɛ ntóósi kɛporipi nkɛ́ kɛkɛ́ nɛ kɛtɑɑ nɛ́ wɑ. Ḿpɑ́ nɛ lɛ̃, ɑ́i kɑpɛ mɛnɛ́lɑ mɛɛ yɛ́ wɑ, ɑmɑ́ likɛ́ mɛpɔ́kɔ́. ");
INSERT INTO soy_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Uléécɑɑtumɛ uu pɛɛ kɛyómɛcɑɑ-pɔ kpɑ́fúmɛ rɛ ukɛ́ itisi u hɛ. ");
INSERT INTO soy_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Mpɔ́ɔcɑɑi píimɑ nn Yeesu tini, uú nɛ piyómɛyɑ́hɑɑ kɛ́yu m mɑhɑnlɛ̃, urikɑhɑ ɑri pɔ́lɔ́ yɑrɛ mɛ́nyɛ, tin cɔlɔi. ");
INSERT INTO soy_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Kuu piyómɛyɑ́hɑɑ ḿ mɑsí, uu upipirɛtiki-mɛ̃ pɛlɛ uu pi lɛɛpɔ pin lɔni nɛ mpɔ́ɔcɑɑi. ");
INSERT INTO soy_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Uu pi mɑɑ rɛ: Yo nnyɑ kɑni lɔni? Ani yisi ɑni kɛyómɛ yɑ́ɑ́si ɑ́i kɑpɛ wɑ rɛ nɔ pipeikɛɛ-i lóipɔ. ");
INSERT INTO soy_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Un kei lɛ̃ símisi risoiwuí ɑri tuipɔ, upipirɛtiki kɛfi nɛ pitɛ́ pɛ̃ usɛ kɑpi yɛ n sée rɛ Yutɑsi un pikɛyu we. Uú nɛ Yeesu kɔ uu u pirɑ. ");
INSERT INTO soy_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Amɑ́ Yeesu uu u mɑɑ rɛ: Pɔ́ Usoi Kɛpipi ripirɑ ɑɑ́ nɛ pilɑ́ɑrɔ ɑnipɛ-i kɛ wɑi, nɛ́ɛ yo? ");
INSERT INTO soy_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Kɛ Yeesu pisencɔ ɑpi n yɛ̃́ lɛlɛɛ n wɑinɛ, ɑpi u pisɛ rɛ: Upíimɑ, tɔkɛ́ ɑtɛ́hɛ kpísii? ");
INSERT INTO soy_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Piusɛ uu Uléécɑɑ usinɑ ukɛikɔ́ kutu lukɛ-lukɛ seḿ. ");
INSERT INTO soy_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Amɑ́ Yeesu uu rɛ: Áni kɑpɛ lɛ̃ tikpɑ́, li wɑlɛ. Uu usoi uyɛ̃ kutu cɑ uu u pɔisɛ. ");
INSERT INTO soy_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yeesu uu lɛ̃ mɛmɑ́ɑ́ pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ nɛ pimɛ́rɛ́ uwɛ́ɛ́sɛ nɛ kuyu piwɛ́ɛ́sɛ pɛɛ pitínɛ u n hɑ́pɔ mɑɑ rɛ: Li pisɛ rɛ nɔkɛ́ pitínɛ nɛ́ kɑm nɔn ɑtɛ́hɛ nɛ ɑpúnípi mulɛilɛ̃ yɑrɛ usoi kpɑ́ɑ́ree? ");
INSERT INTO soy_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Siyɑ́ɑ nnɛ́í kɛ tɔ́ nɛ nnɔ̃́ ɑri yɛ kɛsẽ́ Uléécɑɑ kɛyɔ-i n we, ɑ́ni kei ncée wɛ́ɛsi nɔkɛ́ nɛ nɛ́ tĩ́. Amɑ́ ituŋɛ nnyí yɛ nɔ́ nɛ kuŋmɑhɑ uyɔɔpi ikɔ́ lɛ. ");
INSERT INTO soy_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Api Yeesu tini ɑpí nɛ Uléécɑɑ usinɑ kɛyɔ sĩ, Piyɛɛ un kɛtɑɑ-pɔ pi tikilɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Api kɛ́yɔcɔpɛ nnɑ wénesi ɑpí tonɛ, Piyɛɛ uu pɛpɛɛ nnɑ n wéni kɛcɔpɛ tonɛ. ");
INSERT INTO soy_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Unɔ́si kɛikɔ́ unyinɛ uu u yɛnu un nnɑ kɛkúrí tṹ, uu u nyɑ́nɛi tíḿḿ uu rɛ: Usoi nkó ricuruu yɛ pɛɛ Yeesu tikilɛnlɛ. ");
INSERT INTO soy_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Piyɛɛ uu kɛ́su, uu unɔ́si uyɛ̃ mɑɑ rɛ: Ám u nyu, unɔ́si. ");
INSERT INTO soy_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Kɑi rinkpɑ́sɛ, unyinɛ ucɔ uu u yɛnu uu rɛ: Pɔ pisoi pɛ̃ usɛ lɛ! Amɑ́ Piyɛɛ uu rinɔ́ɔ yɔ́su rɛ: Ám pikɛcɔpɛ we. ");
INSERT INTO soy_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Likɛ́ nɛ mɛsɛ pipépɛ rinkpɑ́, unyinɛ ucɔ uu kɔ ń-yupɑpɛ nɛ pimɑ́ɑ kpɑ́ rɛ: Asei kɛcɑ́ɑ́, usoi nkó yɛ pɛɛ u tikilɛnlɛ, likumúŋɛ́ rɛ u Kɑlilee ukɔ́ lɛ. ");
INSERT INTO soy_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Amɑ́ Piyɛɛ uu rinɔ́ɔ yɔ́su rɛ: Ám nyu lɛ̃ kɑɑ ń lɑ pɔkɛ́ mɑlɛ. Kumúŋɛ́ kpɛ-i kuu nní n símisi, icɑ̃́ ii kooi. ");
INSERT INTO soy_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Upíimɑ uu pɛɛ́ ŋmɛɛlú uu Piyɛɛ weríí. Piyɛɛ uu léisɛ rɛ Upíimɑ yɛ u mɑɑ rɛ: Icɑ̃́ ikɛ́ kɛlenɛ n kooi, pɔ́ kɛsi mɛtɑɑni rɛ ɑ́ɑ nɛ́ nyu. ");
INSERT INTO soy_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Kei kɛ Piyɛɛ uu léepɔ uú nɛ mpɔ́ɔcɑɑi téni. ");
INSERT INTO soy_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Pisoi pɛɛ pɛɛ Yeesu m mɛ̃́ ɑpi kɛcɑ́ɑ́ u nyɑ́nɛi ɑpi u kɑii. ");
INSERT INTO soy_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Api kɛ́yu u pi, ɑpi u mɑɑ rɛ: Wóo pɔ́ kɑ́ii, ɑ ŋmɔinu. ");
INSERT INTO soy_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Api kɔ ɑlɛ̃́ u kpɑ́ mɛyɑ̃́. ");
INSERT INTO soy_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Kɑi n weesi, Pisuifi piwɛ́ɛ́sɛ nɛ pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ nɛ isé picélɑɑ ɑpi cɑ́pinɛ. Api nɛ Yeesu pikɛtúhɑɑnɛ píimɑ-i sĩ́. ");
INSERT INTO soy_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Api u pisɛ rɛ: Pɔ́ɔ uyɛ̃ kɛ Uléécɑɑ uu n wɛ́ɛ? A rɔ́ símisi. Uu rinɔ́ɔ yɔ́su rɛ: Nɛn nɔ́ m mɑɑ rɛ lɛɛ ni, ɑ́ni ŋmurɛinɛ. ");
INSERT INTO soy_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Nɛn kɔ nnyinɛ nɔ́ m pisɛ, ɑ́ni rinɔ́ɔ nɛ́ yɔ́sunɛ. ");
INSERT INTO soy_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Amɑ́ kɑí nɛ nkpéni rimpɑ́, nɔ́ Usoi Kɛpipi yɛ̃ kɛn Uléécɑɑ, ńnɑŋɛ nnɛ́í ute kulukɛ-lukɛ-mɛ̃ kɛ́yukɔɔ́tonɛ-i tṹ. ");
INSERT INTO soy_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Pinnɛ́í ɑpi pɛɛ rɛ: Lɛ̃ nnyɑ, pɔ Uléécɑɑ Kɛpipi lɛɛ? Uu rinɔ́ɔ yɔ́su rɛ: Lɛ̃ kɑni nní mɑ, nɛ Uléécɑɑ Kɛpipi lɛ. ");
INSERT INTO soy_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Api pɛɛ rɛ: Píseérɑkɔɔ́ píye picɔ kɑri nkpéni wɛ́ɛ́si? Tirɔ́cúruu yɛ uɑnɔɔlempi konlɛ! ");
INSERT INTO soy_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Pisoi nnɛ́í pɛɛ n cɑ́pinɛlɛ̃ ɑpi yisi ɑpí nɛ Yeesu Pilɑti kɛ́mɛɛ sĩ́. ");
INSERT INTO soy_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Api kei nɛ nsímɛ́ u wɑ́ɑ́nɑ́ pin tee rɛ: Tɔ usoi nkó lɛɛpɔlɛ un kurɔ́yu pikɔ́ tɑ́lisi rɛ pikɛ́ ncée kópɛ ritiki. U pi símɑɑnkɛɛ rɛ ɑ́pi kɑpɛ lɑmpoo Rɔm uyɔɔpi Sesɑɑ hɛ́ɛlɛ, un kɔ tee rɛ uyɛ̃ kɛ Uléécɑɑ uu wɛ́ɛ, uyɔ́ɔpi. ");
INSERT INTO soy_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilɑti uu u pisɛ rɛ: Pɔ́ɔ Pisuifi uyɔɔpii? Yeesu uu rinɔ́ɔ u yɔ́su rɛ: Mmɛ̃ kɑɑ nní mɑ. ");
INSERT INTO soy_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilɑti uu pɛɛ pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ nɛ risoiwuí mɑɑ rɛ: Ám ncɑɑi ńkɑ nyɑ́ni mɛɛ yɛ́ usoi nkó ɑkpɑnii n tɑ̃. ");
INSERT INTO soy_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Amɑ́ ɑpi pimɑ́ikɛɛ n kpɑ́lɛ̃ nɛ ńnɑŋɛ rɛ: Usoi nkó yɛɛ kuyu pikɔ́ pihɑ́ikusɛ tɑ́lɑɑnkɛɛ, Kɑlilee-pɔ kuu kóri uu Yutee kɛtẽ nnɛ́í cɔpu uú nɛ nté tuiri. ");
INSERT INTO soy_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Kɛ Pilɑti uu ɑnɔ́ɔ nyɛ̃ n kṍ, uu pisɛ rɛ: Usoi nkó yɛ Kɑlilee ukɔ́ lɛɛ? ");
INSERT INTO soy_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Kuu n céri rɛ Erooti yɛɛ Kɑlilee kɛtẽ-pɔ Yeesu uyɔɔpi, uu Yeesu u pɑ́ɑ́ipɔ, liriyíkí rɛ Erooti ricuruu yɛ siyɑ́ɑ sɛ̃ kumúŋɛ́-i Yerusɑlɛm-i welɛ. ");
INSERT INTO soy_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Kɛ Erooti uu Yeesu n yɛ̃́, ɑi u lɑrisi, liriyíkí rɛ u pɛɛ mɛkɛɛ-mɛ Yeesu nnɛ̃́ kómɛilɛ lin tipɔ́ɔ u we rɛ ukɛ́ u yɛ̃. U pɛɛ tɑ́lɛ̃ tɛ Yeesu yɛ́ uinipɛɛ-i mɛwɑisɑŋɑ mɛnyinɛ wɑ. ");
INSERT INTO soy_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Uu u písɛisɛ ɑi nɑ́ŋɑi, ɑmɑ́ Yeesu úu rinɔ́ɔ ríkɑ u yɔsí. ");
INSERT INTO soy_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ nɛ isé picélɑɑ pin kei we pin nɛ Yeesu isímɛ́ piwɑɑnɑi kɛ́yu mɑhɑni. ");
INSERT INTO soy_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Erooti nɛ upisɔ́ɔ́cɑ ɑpi kɛcɑ́ɑ́ u nyɑ́nɛi ɑpi u n sɛ́nnyi yɑrɛ kɛsoi kpɑ́rɑ́pi. Api kɛtúkɑnkɑ kɛcirɛ u tɑni ɑpi Pilɑti-mɛ̃ u pɛsɛpɔ. ");
INSERT INTO soy_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Erooti nɛ Pilɑti yɛ pɛɛ pilɑ́ɑrɔ lɛ, ɑmɑ́ ɑpi kɛyɑ́ɑ kɛ̃ kusɑ́nɛ tonɛ. ");
INSERT INTO soy_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilɑti uu pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ nɛ kuyu piyukɔɔ́ nɛ kuyu pikɔ́ cɑ́pinɛ, ");
INSERT INTO soy_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","uu pi mɑɑ rɛ: Nɔ nɛ usoi nkó nɛ́ kɑlɛ nɔn tee rɛ u pisoi tɑ́lisi rɛ pikɛ́ ncée kópɛ ritiki. Too, nɔ́kɛnɛ́yu-i kɑm u písɛi ɑ́m kɔ ncɑɑi kɑni rɛ u wɑi ńkɑ yɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Erooti úu kɔ uncɑɑi ńkɑ yɛ̃, liriyíkí rɛ u rɔ́ u pɛsɛmɛlɛ. Kɑi nní lɛ̃, usoi nkó úu ncɑɑi ńkɑ mɑ́ mɛɛ yɛ́ ń tíyɛsɛ pikɛ́ u ń kpu. ");
INSERT INTO soy_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Lɛ̃ nnyɑ nɛ́ tíyɛsɛ ɑpi kuyíyɑɑ u fɑpii ɑm lɛ̃ mɛmɑ́ɑ́ u tíyɛ. ");
INSERT INTO soy_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Li pɛɛ tílɑsi lɛ rɛ Pilɑti ukɛ́ ukpɑniikɔ́ usɛ pi riyɑ́ ḿpɑ́ nkpɔ mɛlɔ́ɔ́ ɑnyɑ̃́ ɑ́ye. ");
INSERT INTO soy_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Api pinnɛ́í pipupukɛɛ kpɑ́ rɛ: A usoi nkó rɔ́ kpu ɑɑ Pɑrɑpɑsi yɑ́! ");
INSERT INTO soy_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Pihɑ́ikusɛ mɛwɑi mɛnyinɛ kɛ Pɑrɑpɑsi pɔ́ɔ pɛɛ kuyu-i tɑmmɛ uu kɔ usoi kopu. Lɛ̃ nnyɑ kɑpí pɛɛ uyɛ̃ kukpɑniilee tɑ̃. ");
INSERT INTO soy_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Kɛ Pilɑti uu nní ń lɑ ukɛ́ Yeesu ŋmɛ́hɛrɛɛsɛ nnyɑ, uu risoiwuí nɛ pisímɛ́ kpɑ́. ");
INSERT INTO soy_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Amɑ́ ɑpi pupɛi rɛ: A kunɑpɛ́ɛ́kɔɔ́ kɛcɑ́ɑ́ u kɑrii, ɑ kunɑpɛ́ɛ́kɔɔ́ kɛcɑ́ɑ́ u kɑrii. ");
INSERT INTO soy_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilɑti uu mɛtɑ́ɑ́nũ pimɑ́ɑ pi kpɑ́ rɛ: Ncɑɑi ń-ye kuu mpíí wɑ? Ám ncɑɑi ńkɑ ukɛcɑ́ɑ́ yɛ̃́ mɛɛ yɛ́ ń tíyɛsɛ pikɛ́ nɛ u ń kpu. Lɛ̃ nnyɑ nɛ́ tíyɛsɛ pikɛ́ nɛ kuyíyɑɑ u kɑii ɑm pɛɛ u yɑ́pɔ. ");
INSERT INTO soy_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Amɑ́ ɑpi pipupukɛɛ nɔŋ́ tɛ pikɛ́ Yeesu kunɑpɛ́ɛ́kɔɔ́ kɛcɑ́ɑ́ kɑrii. Ai Pilɑti feriyɛ. ");
INSERT INTO soy_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilɑti uu hɔ́ rɛ ukɛ́ lɛ̃ kɑpi u m pisɛ pi wɑ. ");
INSERT INTO soy_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Uu usoi uyɛ̃ kɑpi n tee rɛ ukɛ́ riyɑ́ yɑ́, uu Yeesu pi múísɛ rɛ pikɛ́ nɛ u li lɛ̃ kɑpi ń lɑ. Uyɛ̃ kuu nní rin-yɑ́ yɛ pɛɛ pihɑ́ikusɛ mɛwɑi mɛnyinɛ kuyu-i tɑmmɛlɛ uu kɔ usoi kopu. Lɛ̃ nnyɑ kɑpí pɛɛ uyɛ̃ kukpɑniilee tɑ̃. ");
INSERT INTO soy_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Kɑpí nɛ Yeesu n tɔ́su, ɑpí nɛ Sirɛɛni kuyu ukɔ́ unyinɛ kɑpi yɛ n sée rɛ Simɔɔ sɑ́nɛ un sicɑrɛ-mɛ̃ leeri. Api u tini ɑpi Yeesu kunɑpɛ́ɛ́kɔɔ́ u cɔnsɛ rɛ ukɛ́ nɛ u n tikilɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Pisoi kulúi nɛ pinɔ́si pin u tikilɛ̃. Pinɔ́si pin siwuu pirɑlɛ̃ pin nɛ ukɛcɑ́ɑ́ téni pin kɔ nɛ u tikilɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yeesu uu pinɔ́si kuwɛ́lɛ́-mɛ̃ pɑnsɛpɔ uu rɛ: Yerusɑlɛm pinɔsi, ɑ́ni kɑpɛ nɛ̃́ nnyɑ n ténisi. Amɑ́ ɑni nɔ́rinɛ́cúruu nɛ nɔ́sinɛ́wɑ̃́ nnyɑ ténisi. ");
INSERT INTO soy_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Likumúŋɛ́ rɛ siyɑ́ɑ yɛ sɔ́ntilɛ, sɛ-i kɑpi yɛ́ ḿ mɑɑ rɛ: Pinɔ́si nyɑpi pɛɛ ɑ́pi píkɑi m mɑ́rɑɑlɛ̃ ɑ́pi kɔ píkɑi n nyɛnsɛlɛ̃ yɛ pínɑrɛkomɛ lɛ. ");
INSERT INTO soy_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Pisoi yɛ́ pɛɛ ɑkúú pimɑ́ikɛɛ lõ tɛ: Ani kɛrɔ́cɑ́ɑ́ loó, ɑpi sikúúpi mɑ́ikɛɛ rɛ: Ani tɔ́ yɑ́rii. ");
INSERT INTO soy_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Likumúŋɛ́ rɛ pin nɛ́ɛ ń we yɑrɛ kunɑ ŋmṹ nní n wɑ, íye kɑpi yɛ́ pɛɛ nɔ́ɔ nní ń we yɑrɛ kunɑ kóimɑ pɔ̃́ wɑ? ");
INSERT INTO soy_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Api kɔ nɛ piwɑikópɛkɔɔ́ pitɛ́ pinyinɛ n tɔ́su pikɛ́ hɑ pi nɛ Yeesu kɛsẽ́ kpu. ");
INSERT INTO soy_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Kɑpi kɛlõ kɛ̃ kɑpi yɛ n sée rɛ Kúyu Koŋoo n tu, ɑpi kei Yeesu kunɑpɛ́ɛ́kɔɔ́ kɛcɑ́ɑ́ kɑrii, ɑpi kɔ piwɑikópɛkɔɔ́ pitɛ́ pɛ̃ kɑrikɛɛ ɑnɑpɛ́ɛ́kɔɔ́ kɛcɑ́ɑ́, usɛ ukulukɛ-lukɛ, ucɔ ukumii-mɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yeesu uu pɛɛ rɛ: Sɑ́ɑ, ɑ piɑkópɛ pi sɑ́rɛi, likumúŋɛ́ rɛ ɑ́pi nyu lɛ̃ kɑpi n wɑi. Api pɑŋɑi ɑpí nɛ pimɛcɔpɛcirɛ uilũ hɔɔnɛntɛ. ");
INSERT INTO soy_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Piyukɔ́ pin kei nyɛnu pin nyɑ́nɛi. Pisuifi piwɛ́ɛ́sɛ ɑpi kɛcɑ́ɑ́ u nyɑ́nɛi pin tee rɛ: U picɔ yoriyɛntɛlɛ, ukɛ́ uricuruu yoriyɛ, in tɛ u Kirisi lɛ, uyɛ̃ kɛ Uléécɑɑ uu n wɛ́ɛ. ");
INSERT INTO soy_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Pisɔ́ɔ́cɑ ricuruu ɑpi kɛcɑ́ɑ́ u nyɑ́nɛi ɑpí nɛ u kɔ ɑpi pítɑ nyɛpɛ-nyɛpɛ pinyinɛ u tuŋɑ́ ");
INSERT INTO soy_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ɑpi rɛ: Pɔn Pisuifi uyɔɔpi, ɑ ripɔ́cúruu yoriyɛ. ");
INSERT INTO soy_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Api pɛɛ uriyu kɛcɑ́ɑ́ wɔ́lu rɛ: Nkó yɛɛ Pisuifi uyɔɔpi. ");
INSERT INTO soy_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Uwɑikópɛkɔɔ́ usɛ kɑpi kunɑpɛ́ɛ́kɔɔ́ kɛcɑ́ɑ́ ń kɑriilɛ̃ uu u lɑ́misi un tee rɛ: Nɛ́ntɛ pɔ́ɔ uyɛ̃ kɛ Uléécɑɑ uu n wɛ́ɛ? A ripɔ́cúruu yoriyɛ ɑɑ kɔ tɔ̃́ yoriyɛ! ");
INSERT INTO soy_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Amɑ́ ucɔ nkó uú nɛ u cɛ́si rɛ: Pɔn nɛ Uléécɑɑ wuruu? Pɔ́ɔ nní uɑkpɑnii ɑcɔ kɛ́mɛɛ ń we. ");
INSERT INTO soy_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Tɔ̃́ ɑkpɑnii piwɑi yɛ nɛ risɑ́lɛ, likumúŋɛ́ rɛ mɛrɔ́wɑi kópɛ kulɑɑ kɑri nní le, ɑmɑ́ uyɛ̃ úu ncɑɑi ńkɑ wɑ. ");
INSERT INTO soy_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Uu limɛmɑ́ɑ́ kpɑ́ rɛ: Yeesu ɑ kɛnɛ́cɑ́ɑ́ léisɛ pɔn píyei ipɔ́yɔ́ɔpi pilukɛ n wemɛ. ");
INSERT INTO soy_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yeesu uu rinɔ́ɔ u yɔ́su rɛ: Asei kɑm pɔ́ símisi, nɛni kɛyɑɑ nkɛ́, tɔ́ nɛ mpɔ̃́ nɛ pi Uléécɑɑ iyɔɔpi kɛ́mɛɛ. ");
INSERT INTO soy_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Ituŋɛ kɛcírɛ kumúŋɛ́, kuŋmɑhɑ ɑku kɛtẽ nnɛ́í kɛcɑ́ɑ́ cɔni hɑ́i nɛ ituŋɛ mɛtɑɑni kumúŋɛ́-pɔ. Kusɑ́ŋɑ́ɑ́ kɑpí nɛ Uléécɑɑ kɛyɔ n kénɛlɛ̃ ɑku kɛcɔpɛ cɛɛ́rinɛ. ");
INSERT INTO soy_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yeesu uu mɛyɑ̃́ pupɛi rɛ: Sɑ́ɑ, nɛ nnɛ́fɑ́ɑ ɑpɔ́nípɛ-i wɑ. Kuu ɑnɔ́ɔ nyɛ̃ pimɑ́ɑ ḿ mɑsí, uu kpi. ");
INSERT INTO soy_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Rɔm usɔ́ɔ́cɑ wɛ́ɛ́sɛ uu lɛ̃ nnɛ́í lɛɛ n wɑpisi yɛnu, uu Uléécɑɑ ríyu wɑisɛ uu rɛ: Asei kɛcɑ́ɑ́, usoi nkó yɛ pɛɛ ɑsei ute lɛ. ");
INSERT INTO soy_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Pɛ̃ nnɛ́í pɛɛ pɛɛ ń kɑ ɑwúí ɑwúí pikɛ́ nyɑ́nɛi, ɑpi lɛlɛɛ n wɑ yɛnu, ḿpɑ́ úye uu pɛɛ pɛlɛ un mpɔ́ɔcɑɑi nɛ kɛwuu pirɑlɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Yeesu pisɑnɛ nnɛ́í nɛ pinɔ́si pɛɛ pɛɛ u n sɑ́rummɛ hɑ́i Kɑlilee-pɔ, ɑpi iyɑɑ-pɔ nyɛrɛ ɑpi lɛlɛɛ n wɑi n nyɑ́nɛi. ");
INSERT INTO soy_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Pisuifi kuyu Arimɑtee kɛ́mɛɛ kɛ utisi unyinɛ uú pɛɛ́ we. Pi yɛ u sée rɛ Yosɛfi. U pɛɛ kɛtúhɑɑnɛ píimɑ uwɛ́ɛ́sɛ usɛ lɛ, ɑmɑ́ lɛ̃ kɛ upiwɛ́ɛ́sɛcɔ ɑpi rinhɔ́ ɑpi wɑi ɑ́i nɛ u risɑ́. Utisi uyɛ̃ nɛ pɛɛ ɑsei ute lɛ un kɔ Uléécɑɑ iyɔɔpi mɛkɑmɛ mɛ̃́. ");
INSERT INTO soy_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Uu Pilɑti kɛ́mɛɛ sĩ́ uú hɑ u pisɛ rɛ ukɛ́ Yeesu u pɑ. ");
INSERT INTO soy_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Uu limɛmɑ́ɑ́ kunɑpɛ́ɛ́kɔɔ́ kɛcɑ́ɑ́ Yeesu súisɛri, uu kusɑ́ŋɑ́ɑ́ u pílɛsi uu nhórɛ kɑpi kupɑrɛcɑŋɑɑ-i n wɑ kɛ́mɛɛ u finsɛ. Ápi nhórɛ mmɛ-i úkɑ kulɑɑlɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Kɛyɑ́ɑ kɛɛ nɛ risɑ́lɛ kɛwéntɛyɑɑ usé, kɛwéntɛyɑɑ kɛn nɛ korɑɑnɛnɛ. ");
INSERT INTO soy_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Pinɔ́si pɛɛ pɛɛ Yeesu n sɑ́rummɛ hɑ́i Kɑlilee-mɛ nɛ Yosɛfi ɑpi rikpíí-i símpɔ pikɛ́ yɛ̃́ lɛ̃ kɑpi Yeesu n finsɛ. ");
INSERT INTO soy_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Api pɛɛ kɛ́yɔ pɛlɛ ɑpí hɑ mɛ́kpɔ nɛ tulɑɑli ncɔpuri wɑi pikɛ́ Yeesu níŋɛsi. Amɑ́ ɑpi kɛwéntɛyɑɑ kɛtúŋɛ́ wéntɛ yɑrɛ kɛ isé ii m pisɛ ɑpi kɛlenɛ simpɔ. ");
INSERT INTO soy_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Kɛwéntɛyɑɑ ukóso kɛmɑrɛsinɛ, pinɔ́si ɑpi mɛ́kpɔ nɛ tulɑɑli kɑpi n wɑ múlú ɑpí nɛ rikpíí símpɔ. ");
INSERT INTO soy_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Api lɛɛpɔ lin tipɑrɛ tɛɛ pɛɛ rikpíí n fílɛ̃ pímiisɛ ɑi iyɑɑ yekei. ");
INSERT INTO soy_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Api lompɔ ɑmɑ́ ɑ́pi Upíimɑ Yeesu lɛɛpɔ. ");
INSERT INTO soy_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ápi ceri íye kɑpi yɛ́ wɑ. Kumúŋɛ́ kpɛ-i kɛ pisoi pitɛ́ pinyinɛ ɑpi rikpɑ́fúmɛ pin ilũ yɛɛ n tɛ́lu tɑnɑɑlɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Kɛ iwɑmɛ ii pi n wɑ ɑpi kpɑ́rɑi, pisoi pɛ̃ ɑpi pi mɑɑ rɛ: Yo nnyɑ kɑni pikpɔkpɔ kɛcɔpɛ uyɛɛ n nyɑ́ni wɛ́ɛ́si? ");
INSERT INTO soy_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Úu nté we, u nkpɔ kɛ́mɛɛ yisilɛ un nfɑ́ɑ mɑ́. Ani léisɛ lɛ̃ kuu nɔ́ ḿ mɑ pɛɛ́ uyɛ-i kuú pɛɛ Kɑlilee-pɔ ń we. ");
INSERT INTO soy_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Li pisɛ rɛ pikɛ́ pikópɛkɔɔ́ ɑnipɛ-i Usoi Kɛpipi wɑ, ɑpi kunɑpɛ́ɛ́kɔɔ́ kɛcɑ́ɑ́ kɛ kɑrii Uléécɑɑ ukɛ́ kɛyɑ́ɑ tɑ́ɑ́nũ tuŋɛ́ nkpɔ kɛ́mɛɛ kɛ yukusɛ. ");
INSERT INTO soy_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Api pɛɛ Yeesu ɑnɔɔ léisɛ. ");
INSERT INTO soy_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Api rikpíí-i yisi ɑpi lɛ̃ nnɛ́í pipirɛtiki kɛfi nɛ usɛ nɛ picɔ nnɛ́í kɛ́ɛ́nkɛɛ. ");
INSERT INTO soy_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Mɑɑri Mɑkitɑlɑ ukɔ́ nɛ Yohɑnɑ nɛ Yɑkupu uni Mɑɑri yɛ pɛɛ pi. Pi nɛ pinɔ́si picɔ pɛɛ pɛɛ kɛsẽ́ ń we ɑpi nsímɛ́ pitumɛ kɛɛni. ");
INSERT INTO soy_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Amɑ́ pitumɛ ɑpi pinɔ́si nsímɛ́ mmɛ̃ yɛnu rɛ nnírisimɛ́ yɛ mu, ɑ́pi pɛɛ pɑkɑrɛ. ");
INSERT INTO soy_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Kumúŋɛ́ kpɛ-i, Piyɛɛ uu yisi uu rikpíí-mɛ̃ wurupɔ, uú kpɑrɑ́pɔ uu ɑsɑ́ŋɑ́ɑ́ ŋmɑnɛ yɛnu ɑn cúlɛ̃. Uu pɛɛ ukɛyɔ pɛlɛ. Lɛ̃ nnɛ́í lɛɛ nní n wɑpisi lin nnɔ́ɔ u yipɑɑlɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Kɛyɑ́ɑ kɛ̃ cirɛ, pipirɛtiki pitɛ́ ɑpi kɛyupi kɛnyinɛ kɑpi yɛ n sée rɛ Emɑyusi n simpɔ. Ituŋɛ nwɔi mɛkɔ́ɔ́nú mɛtɛ́ kɑpi yɛ kei nɛ Yerusɑlɛm sɔ́nɛ. ");
INSERT INTO soy_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Lɛ̃ nnɛ́í lɛɛ pɛɛ n wɑpisi nsímɛ́ kɑpí pɛɛ símisi. ");
INSERT INTO soy_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Kumúŋɛ́ kpɛ-i kɑpi lɛ̃ n símisi pin kɛŋɛnɛ, Yeesu ricuruu uú nɛ pi kɔ ɑpi kɛsẽ́ n sɔ́nɛ, ");
INSERT INTO soy_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","pin u nyɑ́ni ɑmɑ́ linyinɛ lin pi hilɑlɛ̃ ɑ́pi pɛɛ u ceri. ");
INSERT INTO soy_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yeesu uu pi pisɛ rɛ: Yo yɛɛ nɔ́ kɛ́ŋɛnɛsɛ nɔn nɛ sɔ́nɛ? Api nyɛrɛ nɛ mpɔ́ɔcɑɑi. ");
INSERT INTO soy_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Pikɛcɔpɛ unyinɛ kɑpi yɛ n sée rɛ Keleopɑsi uu u mɑɑ rɛ: Yɑrɛ pɔ̃́ mɛcirɛ yɛɛ Yerusɑlɛm kuyu-i we ɑ́ɑ nyu lɛlɛɛ siyɑ́ɑ tɔrɔɔ nsí kɛ́mɛɛ kuyu kpɛ-i n wɑii? ");
INSERT INTO soy_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yeesu uu pi pisɛ rɛ: Yɑrɛ mɛwɑi mɛ́ye mpuri yɛ mɛ? Api rinɔ́ɔ u yɔ́su rɛ: Lɛlɛɛ Nɑsɑrɛti ukɔ́ Yeesu n lɛɛmɛ mɑ́. Antepu lo yɛɛ ńnɑŋɛ m mɑ́. U Uléécɑɑ nɛ pisoi kɛyu-i unnɑŋɛ nyísɛlɛ uliwɑiwɑi nɛ uɑnɔɔlempi kɛ́mɛɛ. ");
INSERT INTO soy_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ nɛ kurɔ́yu piyukɔɔ́ ɑpi u tini ɑpi nsímɛ́ u cɔnsɛ ɑi wɑi rɛ pikɛ́ u kpu. Api kunɑpɛ́ɛ́kɔɔ́ kɛcɑ́ɑ́ u kɑrii. ");
INSERT INTO soy_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Tɔ pɛɛ tɑ́lɛ̃ tɛ uyɛɛ yɛ́ Isirɑyɛɛli riyu lɔ. Amɑ́ kɛyɑ́ɑ tɑ́ɑ́nũ yɛ nkɛ́ kɛ mɛwɑi mɛ̃ ɑmɛ́ nɛ n wɑpisi. ");
INSERT INTO soy_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Asei kɛcɑ́ɑ́, kɛrɔ́cɔpɛ, pinɔ́si pinyinɛ yɛ tíyɛlɛ ɑi pírí rɔ́ wɑi. Kɛmɑrɛsinɛ kɑpi rikpíí-i hɑ. ");
INSERT INTO soy_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Amɑ́ ɑ́pi u lɛɛpɔ. Api pɛɛri ɑpi rɔ́ símisi rɛ piléécɑɑtumɛ pinyinɛ yɛ pikɛyu-i rikpɑ́fúmɛlɛ ɑpi pi mɑɑ rɛ u nyɑ́nilɛ. ");
INSERT INTO soy_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Pirɔ́séncɔ pinyinɛ ɑpi rikpíí-i símpɔ ɑpi lɛɛpɔ yɑrɛ lɛ̃ kɛ pinɔ́si ɑpi rɔ́ ń kɛ́ɛ̃. Amɑ́ ɑ́pi pɛɛ uricuruu yɛ̃. ");
INSERT INTO soy_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yeesu uu pɛɛ pi mɑɑ rɛ: Nɔ́ piníri mpí, ɑ tíyɛ nɔ́ ɑtu mɑ́ ɑ́ni lɑ nɔkɛ́ mmɛ̃ kɛ ɑntepuyɛ ɑpi nɔ́ n símisi nɛ kɛfɑ tɛnɛ. ");
INSERT INTO soy_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ái pɛɛ pisɛ rɛ uyɛ̃ kɛ Uléécɑɑ uu n wɛ́ɛ ukɛ́ lɛ̃ íwɛ li uu kɛlenɛ umɛyɔɔpi-i lonii? ");
INSERT INTO soy_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Uu pɛɛ limɛmɑ́ɑ́ mmɛ̃ nnɛ́í kɑi uriyu kɛcɑ́ɑ́ ɑ́tɛlɛ́-i n wɔ́lɑɑlɛ̃ pi kpɑ̃́iisɛ, Moisi ritɛlɛ́ kuú nɛ kori uú nɛ ɑntepuyɛ ɑkɔ́ tɛnɛsɛ. ");
INSERT INTO soy_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Kɑpi kuyu kpɛ-i kɑpi n símpɔ n nyɑhɑi, Yeesu uu wɑi yɑrɛ u lɑlɛ ukɛ́ kɛtɑɑ-tɑɑ hɑ. ");
INSERT INTO soy_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Amɑ́ ɑpi u nyɛrɛsɛ pin tee rɛ: A kɛrɔ́kúrí tonɛ, li nnyɔ́ɔ́ wɑlɛ kɛsinɛ ɑkɛ nyɑhɑi. Uu kɛ́yɔ pi tiki ɑpí hɑ kɛsẽ́ tonɛ. ");
INSERT INTO soy_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Apí tonɛ rɛ pikɛ́ ilukɛ li, uu kukpɔ́nɔ́ kpísi uu Uléécɑɑ pɔɔnɛsɛ uu pɛɛ ku kpɔkɔ́rinɛ uu pi ku pɑ. ");
INSERT INTO soy_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Piinipɛɛ ii pɛɛ wúkulɛ ɑpi u ceru, ɑmɑ́ uu pikɛyu kɛ-i mílu. ");
INSERT INTO soy_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Api pimɛcɔpɛcirɛ m mɑ́ikɛɛnɛ rɛ: Pɔ̃́ tɛ piyo kɛ nsímɛ́ kuú pɛɛ ncée-i n símisi nɛ Nléécɑɑsimɛ́ ɑsei kuú pɛɛ rɔ́ ń símisi nn tɔ lõ ŋmɑɑ. ");
INSERT INTO soy_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Api mɛsɛ nɛ mɛsɛ yisi ɑpi Yerusɑlɛm simpɔ. Api pipirɛtiki kɛfi nɛ usɛ nɛ pipisencɔ lɛɛpɔ pin cɑ́pinɛlɛ̃, ");
INSERT INTO soy_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","pin tee rɛ: Mɛsei yɛ mɛ, Upíimɑ yɛ nkpɔ kɛ́mɛɛ yisilɛ uu tíyɛsɛ Simɔɔ uu u yɛnu! ");
INSERT INTO soy_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Pɛ̃ ticuruu ɑpi lɛlɛɛ ncée-i n wɑ pi kɛɛnkɛɛ nɛ lɛ̃ kɑi n wɑ ɑpí nɛ Yeesu ceru kumúŋɛ́ kpɛ-i kuú pɛɛ kukpɔ́nɔ́ rińkpɔkɔ́rinɛ. ");
INSERT INTO soy_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ápi kɑhɑnɛ nkpɑ́ni nsímɛ́ n tɛnɛ, Yeesu ricuruu uu pikɛcɔpɛ kpɑ́fúmɛ uu pi mɑɑ rɛ: Nɔ́ɑnɛ́kíŋ ɑkɛ́ n niŋú. ");
INSERT INTO soy_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Pikɛwuu ɑkɛ tɔ́lu, iwɑmɛ píimɑ ii pi tini, likumúŋɛ́ rɛ li pi wɑ yɑrɛ kuníri kunyinɛ kɑpi nyɑ́ni. ");
INSERT INTO soy_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Amɑ́ Yeesu uu pi mɑɑ rɛ: Yo nnyɑ kɑi nɔ́ ricɔ́ŋ? Yo nnyɑ kɑni nɔ́sinɛ́fɑ-i tíru? ");
INSERT INTO soy_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ani ɑnɛ́nípɛ nɛ ɑnɛ́nɑ ripɑí. Mɛsei nɛ́ɛ lo. Ani nɛ́ ricɑ ɑni yɛ́nu. Kuníri ɑ́ku ipiŋɛsɑrɛ nɛ́ɛ ɑkɔhɔ mɑ́, yɑrɛ kɑni nní lɛ̃ nnɛ́í kɛnɛ́cɑ́ɑ́ n nyɑ́ni. ");
INSERT INTO soy_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Uu ɑnɔ́ɔ nyɛ̃ mɑlɛ uu uɑnipɛ nɛ uɑnɑ pi nyísɛ. ");
INSERT INTO soy_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Mpɔ́ɔnɑrɛ nɛ pírí píimɑ yɛɛ pi ń we nnyɑ, ɑ́pi nkpɑ́ni fe pikɛ́ nsímɛ́ mmɛ̃ pɑkɑrɛ. Uu pi pisɛ rɛ: Nɔ nté lilukɛ-lukɛ linyinɛ mɑ́lɛɛ? ");
INSERT INTO soy_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Api nkpíntomɛ́ ŋmɑ́ɑ́-ŋmɑ́ɑ́ keri u pɑ. ");
INSERT INTO soy_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Uu n kpísi uu tɑkɑi piinipɛɛ-i. ");
INSERT INTO soy_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Uu pɛɛ pi mɑɑ rɛ: Mmɛ̃ kɑḿ pɛɛ nɔ́ ń símisi kumúŋɛ́ kpɛ-i kɑrí pɛɛ kɛsẽ́ ń we yɛ mmú. Li pisɛ rɛ lɛ̃ nnɛ́í kɑi kɛnɛ́cɑ́ɑ́ n wɔ́lɑɑlɛ̃ Moisi isé kɛ́mɛɛ nɛ ɑntepuyɛ ɑtɛlɛ́ kɛ́mɛɛ nɛ siyómɛ ɑtɛlɛ́ kɛ́mɛɛ likɛ́ wɑ. ");
INSERT INTO soy_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Uu pɛɛ mɛsɔhɔ pi tɑ́pilɛ pikɛ́ nɛ Nléécɑɑsimɛ́ ɑsei n kṍ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Uu pi mɑɑ rɛ: Lɛ̃ kɑi n wɔ́lɑɑlɛ̃ yɛ nní: Li pisɛ rɛ uyɛ̃ kɛ Uléécɑɑ uu n wɛ́ɛ ukɛ́ íwɛ li, uu pɛɛ kɛyɑ́ɑ tɑ́ɑ́nũ tuŋɛ́ pikpɔkpɔ kɛ́mɛɛ yisi. ");
INSERT INTO soy_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Li kɔ pisɛ rɛ pikɛ́ urinyiri nɛ sitẽ nnɛ́í kɛ́mɛɛ pisoi riyóó rɛ pikɛ́ mɛfinɛ consɛ Uléécɑɑ ukɛ́ piɑkópɛ pi sɑ́rɛi. Amɑ́ Yerusɑlɛm kuyu kɑpi yɛ́ nɛ korɑɑnɛ. ");
INSERT INTO soy_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Nɔ́ɔ lɛ̃ piseérɑkɔɔ́. ");
INSERT INTO soy_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Iyɛɛ nnyí, ihɛɛ iyɛ̃ kɛ Unɛ́sɑ́ɑ uu rinhɔ́ rɛ u yɛ́ nɔ́ hɛ. Nɛ́ɛ rinɛ́cúruu nɔ́ i pɑmɛnɛ. Amɑ́ li pisɛ rɛ nɔkɛ́ kuyu-i n tũ hɑ́i nɛ kumúŋɛ́ kpɛ-i kɛ kɛyómɛcɑɑ nnɑŋɛ nn yɛ́ nɔ́kɛnɛ́cɑ́ɑ́ n súimɛ. ");
INSERT INTO soy_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Yeesu uu limɛmɑ́ɑ́ nɛ kuyu iyɑɑ pi simpɔ, Petɑnii kɛkúrí, uu ɑnípɛ síkɑ uu rinɔ́ɔ sɔnɛ pi tikisɛ. ");
INSERT INTO soy_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Kumúŋɛ́ kpɛ-i kuu rinɔ́ɔ sɔ́nɛ pi n tíkisɛlɛ̃, uú nɛ pi tɔlu, ɑi kɛyómɛ-mɛ̃ u sɑkɑɑpɔ. ");
INSERT INTO soy_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Pɛ̃ ɑpi Uléécɑɑ yɑ́ɑ́si ɑpi pɛɛ Yerusɑlɛm pɛlɛ nɛ mpɔ́ɔnɑrɛ píimɑ. ");
INSERT INTO soy_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Api yɛ pɛɛ mɛsɛ́rɛ Uléécɑɑ kɛyɔ-i n cɑ́pinɛlɛ̃ pin Uléécɑɑ pɑkɑrɛntɛ.");
INSERT INTO soy_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Uléécɑɑ ukɛ́ kɛlenɛ ḿpɑ́ yo n wɑ, Tinɔ́ɔ yɛ pɛɛ welɛ. Tinɔ́ɔ nɛ Uléécɑɑ pɛɛ pɛɛ́ we. Tinɔ́ɔ yɛ pɛɛ Uléécɑɑ lɛ. ");
INSERT INTO soy_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ti nɛ Uléécɑɑ pɛɛ pɛɛ́ we Uléécɑɑ uu kɛlenɛ ḿpɑ́ yo wɑi. ");
INSERT INTO soy_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Tɛ̃ kɛ Uléécɑɑ uú nɛ ritiki uú nɛ ḿpɑ́ yo wɑi. Líkɑ ɑ́i we kɛ Uléécɑɑ uu n wɑ kɑ́i pɛɛ tɛ̃ kuú nɛ ritiki. ");
INSERT INTO soy_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Tɛtɛɛ nfɑ́ɑ riyíkí mɛɛ pisoi mɛtɛ́í n wɑi. ");
INSERT INTO soy_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Mɛtɛ́í ɑmɛ kuŋmɑhɑ-i léeri, ɑmɑ́ kuŋmɑhɑ ɑ́ku fe kukɛ́ mɛ yɑrii. ");
INSERT INTO soy_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Uléécɑɑ uu kɛyɑ́ɑ utisi unyinɛ tum. Pi yɛ u sée rɛ Yohɑni. ");
INSERT INTO soy_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","U kɑlɛ rɛ ukɛ́ mɛtɛ́í mɛ̃ pisoi nyísɛ, ḿpɑ́ úye ukɛ́ nɛ kɛfɑ mɛ tɛnɛ. ");
INSERT INTO soy_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ái uricuruu ŋmɑɑ yɛɛ mɛtɛ́í, ɑmɑ́ u kɑlɛ rɛ ukɛ́ mɛtɛ́í mɛ̃ nsímɛ́ pisoi símisi. ");
INSERT INTO soy_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Mɛtɛ́í mɛ̃ mɛcirɛ ŋmɑnɛ mɛɛ mɛtɛ́í yíkíyiki. Mɛ kɛtẽ kɛcɑ́ɑ́ kɑlɛ rɛ mɛkɛ́ pisoi nnɛ́í n kpɑ̃́iilɛ̃. ");
INSERT INTO soy_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Tinɔ́ɔ yɛ kɛtẽ kɛcɑ́ɑ́ kɑlɛ. Tɛ̃ kɛ Uléécɑɑ uú nɛ ritiki uú nɛ kɛ wɑi, ɑmɑ́ kɑri ń kɑ, kɛtẽ pikɔ́ ɑ́pi ri ceri. ");
INSERT INTO soy_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Tinɔ́ɔ yɛ tipikɔ́ kɛ́mɛɛ kɑlɛ, ɑmɑ́ tipikɔ́ ɑ́pi ri yɔsí. ");
INSERT INTO soy_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Amɑ́ pɛ̃ nnɛ́í pɛɛ ri ń yɔsí ɑpí nɛ kɛfɑ ri tɛnɛ kɑri ńnɑŋɛ hɛ rɛ pikɛ́ pɑnsɛ Uléécɑɑ sipipi. ");
INSERT INTO soy_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ái mɛsoimɑrɛ kɑpi pi mɑri nnyɑ, ɑ́i kɔ lɛ̃ kɛ pisoi ɑpi ń lɑ pikɛ́ yɛ pisiwɑ̃ mɑri nnyɑ kɑpi fe ɑpi lɛ̃ pɑnsɛ. Ápi pɑnsɛ Uléécɑɑ sipipi yɑrɛ kɛ sisoipipi ɑsi yɛ m mɑ́ri nɛ́ɛ yɑrɛ kɛ sisoipipi ɑsi ń lɑ mɛcɔ. Amɑ́ Uléécɑɑ yɛɛ umɛlɑ kɛ́mɛɛ nfɑ́ɑ fɑlɛ pi hɛ. ");
INSERT INTO soy_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Tinɔ́ɔ yɛ pɑnsɛlɛ kɛsoipipi tin kɛrɔ́cɔpɛ tũ. Ti ípɛɛlɛ́ɛ mɑ́lɛ tin kɔ nsímɛ́sei mɑ́ ńsɔnɛ. Tɔ umɛyɔɔpi yɛnlɛ. Mɛyɔ́ɔpi kɛ Kɛpipi cirɛníŋɛ ɑkɛ Sɑ́ɑ Uléécɑɑ kɛ́mɛɛ n yɛ̃́. ");
INSERT INTO soy_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohɑni yɛ ukɛcɑ́ɑ́ ɑseérɑ lesɛlɛ uu cɑ́ɑ́i rɛ: Nkó nsímɛ́ kɑḿ mɑɑ rɛ: Uyɛɛ kɛnɛ́pirɛ n wemɛ yɛ nɛ́ felɛ. Uyɛ̃ nɛ pɛɛ́ welɛ ɑpi kɛlenɛ nɛ̃́ mɑru. ");
INSERT INTO soy_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","U ípɛɛlɛ́ɛ rɔ́ nyísɛlɛ uu lɛ̃ nnɛ́í kuu m mɑ́ rɔ́ hɛ fɑɑlɑɑ, líkɑ ɑ́i tɔ́ ripɑ́rí. ");
INSERT INTO soy_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Asei kɛcɑ́ɑ́, Moisi kɛ Uléécɑɑ uú nɛ ritiki uú nɛ isé rɔ́ pɑ. Amɑ́ Yeesu Kirisi kuú nɛ ritiki uú nɛ ípɛɛlɛ́ɛ rɔ́ nyísɛ uu kɔ nsímɛ́sei rɔ́ símisi. ");
INSERT INTO soy_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Úkɑ úu Uléécɑɑ yɛ́nɑɑlɛ̃. Insɑ́ Ukɛpipi cirɛníŋɛ kɛɛ ukɛmɛɛ́ ń we, kɛn kɔ Uléécɑɑ, kɛɛ rɔ́ u nyísɛ. ");
INSERT INTO soy_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yohɑni ɑseérɑ kuu n lésɛ yɛ nnyɛ́: Pɛɛ́ uyɛ-i kɛ Pisuifi piwɛ́ɛ́sɛ pɛɛ Yerusɑlɛm–i ń we ɑpi pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ nɛ Lefi mpuri pikɔ́ n tũ tɛ pikɛ́ hɑ u pisɛ rɛ uyɛɛ úye? ");
INSERT INTO soy_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yohɑni úu kɛsi, u pinnɛ́í kɛyu-i ɑseérɑ lesɛlɛ rɛ: Ái nɛ̃́ Yohɑni kɛ Uléécɑɑ uu wɛ́ɛ. ");
INSERT INTO soy_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Kei kɑpi kɔ pipisɛ u rikpɑ́ rɛ: Pɔ mpíí úye kɛcirɛ lɛ? Pɔ́ɔ Elii nɛ́ɛ? Uu rɛ: Eehei. Api kɔ pipisɛ u kpɑ́ rɛ: Pɔ́ɔ ɑntepu uyɛ̃, nɛ́ɛ yo? Uu rɛ: Eehei. ");
INSERT INTO soy_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Api kɔ pipisɛ u kpɑ́ rɛ: Pɔ́ɔ pɛɛ nkpéni úye ŋmɑɑ? A rɔ́ símisi tɔkɛ́ hɑ pɛpɛɛ rɔ́ n tummɛ símisi. Pɔ ripɔ́cúruu ŋmɑɑ mpíí rɛ pɔ́ɔ úye kɛcirɛ? ");
INSERT INTO soy_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Kei kɛ Yohɑni uu pɛɛ pi pɛsɛ rɛ: Nɛ́ɛ nní uyɛ̃ nsímɛ́ kɛ ɑntepu Esɑyi uú pɛɛ n tee rɛ: Unyinɛ yɛ kucɛsi kóimɑ-i yóólɛ̃ tɛ ɑni Upíimɑ ncee ritɛ̃iisɛ. ");
INSERT INTO soy_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Pɛ̃ kɑpí pɛɛ Yohɑni kɛ́mɛɛ n tũ yɛ pɛɛ Pifɑrisi lɛ. ");
INSERT INTO soy_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Pɛ̃ ɑpi pɛɛ u pisɛ rɛ: In tɛ ɑ́i pɔ̃́ kɛ Uléécɑɑ uu wɛ́ɛ, ɑ́i kɔ pɔ́ɔ Elii, ɑ́ɑ kɔ ɑntepu uyɛ̃, yo nnyɑ kɑɑ pɛɛ pisoi míni wolɛ? ");
INSERT INTO soy_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yohɑni uu pɛɛ pi pɛsɛ rɛ: Míni kɛ nɛ́ɛ pisoi wolɛ. Amɑ́ unyinɛ yɛ nɔ́kɛnɛ́cɔpɛ nkɛ́-i welɛ kɑ́ni n nyu. ");
INSERT INTO soy_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","U kɛnɛ́pirɛ wemɛlɛ un nɛ́ fe. Inɛ́soi íi tu rɛ kɛ́ ukunɛ́ɛ́ri nŋmɛ fénnɛ. ");
INSERT INTO soy_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Petɑnii kɛyupi kɛɛ Yuritɛɛ mɛtɛ́ŋ́ kɛtuŋɛleemɛ kuwɛ́ɛ́-mɛ̃ ń we kɛ́mɛɛ kɛ lɛ̃ nnɛ́í ɑi lɛ̃ wɑi. Kei kɛ Yohɑni uu yɛ pɛɛ Yuritɛɛ nkoi kɛ́mɛɛ pisoi míni wolɛ. ");
INSERT INTO soy_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Kɑi kóso n weesi, Yohɑni uu Yeesu yɛnu un ukɛkúrí wépɔ, uu rɛ: Ani ripɑí, Uléécɑɑ Risɑŋpipi yɛɛ yɛ pisoi nnɛ́í ɑkópɛ n lésɛ yɛ ntí. ");
INSERT INTO soy_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Uyɛ̃ kɑḿ pɛɛ tee rɛ: Unyinɛ yɛ kɛnɛ́pirɛ wemɛlɛ un nɛ́ fe. Uyɛ̃ nɛ pɛɛ́ welɛ ɑpi kɛlenɛ nɛ̃́ mɑru. ");
INSERT INTO soy_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nɛ pɛɛ lɛ̃ símisilɛ ɑ́m nyu úye kɛcirɛ lo. Amɑ́ nɛ nkpéni kɑlɛ nɛn Isirɑyɛɛli pikɔ́ míni wolɛ pikɛ́ nɛ u n céri nnyɑ. ");
INSERT INTO soy_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yohɑni uu kɔ kpɑ́ rɛ: Nɛ Uléécɑɑ Nfɑɑsɔnɛ yɛnlɛ nn kɛyómɛcɑɑ-pɔ súiri yɑrɛ tilɔ́ɔlɑ̃ ɑrí nɛ ukɛcɑ́ɑ́ tonɛ. ");
INSERT INTO soy_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ám pɛɛ kɑhɑnɛ n ceri rɛ uyɛɛ úye kɛcirɛ, ɑmɑ́ Uléécɑɑ yɛɛ nɛ́ n tummɛ rɛ kɛ́ pisoi míni wolɛ yɛ nɛ́ mɑɑ rɛ: Pɔ́ Uléécɑɑ Nfɑɑsɔnɛ yɛ̃ nn súiri nn unyinɛ kɛcɑ́ɑ́ tonɛ. Uyɛɛ sɔ́nti ukɛ́ Uléécɑɑ Nfɑɑsɔnɛ pisoi hɛ pikɛ́ nkɛmɛɛ́ m pɔlɔlɛ̃. ");
INSERT INTO soy_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Yohɑni uu kɔ kpɑ́ rɛ: Nɛ nkpéni li yɛnlɛ. Lɛ̃ nnyɑ kɑm ɑseérɑ lesɛ rɛ uyɛɛ Uléécɑɑ Kɛpipi. ");
INSERT INTO soy_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Kɑi kóso n weesi, Yohɑni nɛ upipirɛtiki pitɛ́ pinyinɛ ɑpi kɛlõ kɛ-i n we. ");
INSERT INTO soy_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Yohɑni uu Yeesu yɛnu un tɔ́su uu rɛ: Ani ripɑí, Uléécɑɑ Risɑŋpipi yɛ ntí. ");
INSERT INTO soy_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Kɛ Yohɑni pipirɛtiki pitɛ́ pɛ̃ ɑpi lɛ̃ n kṍ, ɑpi yisi ɑpi Yeesu tiki. ");
INSERT INTO soy_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yeesu uú ŋmɛɛlú uu yɛ́nu rɛ pi u tikilɛnlɛ, uu pi pisɛ rɛ: Yo kɑni wɛ́ɛ́si? Pɛ̃ ɑpi kɔ uyɛ̃ pisɛ rɛ: Yei kɑɑ́ we, Rɑɑpi? Rɑɑpi ɑsei nyɛɛ Ucélɑɑ. ");
INSERT INTO soy_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Uu pɛɛ pi mɑɑ rɛ: Ani kɑm ɑni yɛ̃. Api yisi ɑpi u tiki ɑpí hɑ yɛnu kei kuu n sói. Api kɛyɑ́ɑ kɛ̃ ukɛkúrí kei tonɛ. Inyɔ́ɔ́tuŋɛ kɛfi nɛ mɛkpuulũ kumúŋɛ́-i kɑi lɛ̃ wɑi. ");
INSERT INTO soy_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Pipirɛtiki pitɛ́ pɛɛ pɛɛ Yohɑni nsímɛ́ n kṍ ɑpi yisi ɑpi Yeesu tiki, usɛ yɛɛ Simɔɔ Piyɛɛ uwɑ̃ Antiree. ");
INSERT INTO soy_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Antiree uu mɛfoí umɑ́ɑ Simɔɔ piwɛ́lɑɑ sĩ kɛlenɛ. Uú nɛ u sɑ́nɛ uu u mɑɑ rɛ: Tɔ Umɛsii yɛnlɛ. Mɛsii ɑsei nyɛɛ uyɛ̃ kɛ Uléécɑɑ uu n wɛ́ɛ. ");
INSERT INTO soy_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Uu pɛɛ umɑ́ɑ kpísi uú nɛ Yeesu lɛɛpɔ, Yeesu uú hɑ u nyɑ́nɛi tíḿḿ uu rɛ: Pɔ́ɔ Yonɑɑsi uŋmɑ́nɛ Simɔɔ. Pikɛ́ yɛ nkpéni pɔ́ sée rɛ Sefɑɑsi. Liɑsei rɛ Ripɑrɛ. ");
INSERT INTO soy_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Kɑi kóso n weesi, Yeesu uu hɔ́ rɛ u yɛ́ Kɑlilee kɛtẽ-pɔ hɑ. Kuu n tɔ́su, uú nɛ Filipu sɑ́nɛ uu u mɑɑ rɛ: A yisi ɑ nɛ́ ritiki. ");
INSERT INTO soy_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipu yɛ Petisɑyitɑ kɛyupi ukɔ́ lɛ Antiree nɛ Piyɛɛ mɛcɔ. ");
INSERT INTO soy_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipu pɔ́ɔ kɔ nɛ Nɑtɑnɑyɛɛli sɑ́nɛ uu u mɑɑ rɛ: Tɔ uyɛ̃ nsímɛ́ mɛɛ Moisi isé ritɛlɛ́-i n wɔ́lɑɑlɛ̃, ɑntepuyɛ ɑpi kɔ n símisi yɛnlɛ. Uyɛɛ Yosɛfi uŋmɑ́nɛ, Nɑsɑrɛti ukɔ́ Yeesu. ");
INSERT INTO soy_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nɑtɑnɑyɛɛli uu u mɑɑ rɛ: Lisɔnɛ linyinɛ yɛ́ fe ɑi Nɑsɑrɛti-pɔ leerii? Filipu uu u pɛsɛ rɛ: A kɑm ɑ nɛ ipɔ́nípɛɛ yɛ̃. ");
INSERT INTO soy_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yeesu uu Nɑtɑnɑyɛɛli yɛnu un ukɛkúrí sɔ́nɛpɔ uu rɛ: Isirɑyɛɛli ukɔ́ yíkíyiki ŋmɑɑ yɛ nkó. Úu piyɑɑlukɛ mɑ́. ");
INSERT INTO soy_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Kei kɛ Nɑtɑnɑyɛɛli uu pɛɛ Yeesu pisɛ rɛ: Yei kɑɑ nɛ́ nyu? Yeesu uu u pɛsɛ rɛ: Hɑ́i kɑɑ́ pɛɛ kúfikiyee riyíkí ń tṹ, nɛ pɛɛ pɔ́ nyulɛ Filipu uu kɛlenɛ pɔ́ séi. ");
INSERT INTO soy_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nɑtɑnɑyɛɛli uu pɛɛ Yeesu mɑɑ rɛ: Ucélɑɑ, pɔ Uléécɑɑ Kɛpipi lɛ. Pɔ́ɔ Isirɑyɛɛli uyɔɔpi! ");
INSERT INTO soy_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yeesu uu u pɛsɛ rɛ: Nɛ́ntɛ kɑm pɔ́ ḿ mɑɑ rɛ hɑ́i kɑɑ́ pɛɛ kúfikiyee riyíkí ń tṹ kɑm pɔ́ yɛ̃́ nnyɑ kɑɑ́ nɛ kɛfɑ nɛ́ tɛnɛ? Pɔ́ kɑm ɑɑ lɛ̃ litɔ́ŋɛ́-tɔŋɛ́ yɛ́nu. ");
INSERT INTO soy_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Asei kɛcɑ́ɑ́, kɛ́ nɔ́ símisi rɛ nɔ́ kɑm ɑni kɛyómɛcɑɑ yɛ́nu kɛn wúkulɛlɛ̃, piléécɑɑtumɛ pin nɛ̃́ Usoi Kɛpipi kɛcɑ́ɑ́ tóói pin nɛ kɛyómɛcɑɑ tɑ́ɑ́i pin kɔ nɛ súlɑɑri! ");
INSERT INTO soy_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Siyɑ́ɑ sitɑɑni mɛmɑ́ɑ́, ɑpi pinɔ́sikpikɛ́ ɑnyɑ̃́ Kɑlilee kɛtẽ-pɔ Kɑnɑɑ kuyu-i n wɑi. Yeesu uni un ɑnyɑ̃́ nyɛ-i we. ");
INSERT INTO soy_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Pi Yeesu nɛ upipirɛtiki pɔ̃́ kɔ kei kusɑ́nɛ séelɛ. ");
INSERT INTO soy_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Pítɑ ɑpí weri ɑpi kumúŋɛ́ kunyinɛ-i tɛnɛ. Úni uu pɛɛ u mɑɑ rɛ: Pítɑ yɛ nɛ pi tɛnɛlɛ. ");
INSERT INTO soy_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yeesu uu u pɛsɛ rɛ: Unɔ́si! Nɛ nyulɛ, ɑ́i pɔ́ɔ yɛ́ nɛ́ símisi lɛ̃ kɑm yɛ́ ń wɑ. Inɛ́tuŋɛ íi kɑhɑnɛ n tu. ");
INSERT INTO soy_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Kei kɛ úni uu pɛɛ upikɛikɔ́ pɛɛ kei ń we mɑɑ rɛ: Ani lɛ̃ nnɛ́í kuu nɔ́ m pisɛnɛ wɑ. ");
INSERT INTO soy_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Mɛpɛ́rɛ́ ɑpɔri ɑkpuulũ ɑnyinɛ yɛ pɛɛ welɛ. Kei kɛ Pisuifi ɑpi yɛ míni wɑ ɑpí nɛ pimɛcirɛ nyɔ́ɔnsɛ. Ḿpɑ́ kupɔ́ri kúye yɛ́ fe ɑku ɑ́nicɑri ɑtɛ́ nɛ́ɛ ɑtɑɑni yɔ́su. ");
INSERT INTO soy_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yeesu uu upikɛikɔ́ mɑɑ rɛ: Ani míni lṹ, ɑni ɑpɔ́ri nnyɛ́ yípũ. Pɛ̃ ɑpi mɛsei lúni ɑi ɑ yípuni ɑí wurɛ. ");
INSERT INTO soy_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Yeesu uu pɛɛ pi mɑɑ rɛ: Ani nkpéni kpɛhɛ̃ ɑní hɑ uyɛɛ ɑnyɑ̃́ ilukɛ kɛcɑ́ɑ́ m pɑílɛ̃ pɑ. Pɛ̃ ɑpi kpɛhɛni ɑpí hɑ u pɑ. ");
INSERT INTO soy_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Kɑpi u ḿ pɑ, uu lélé míni mɛn pɑnsɛ pítɑ. Úu nyu kei kɛ pítɑ pɛ̃ ɑpi n léeri. Amɑ́ pikɛikɔ́ pɛɛ n kpɛhɛ̃ ɑpí nɛ hɑpɔ pɔ́ɔn n nyu kei kɑpi n léeri. Kei kɛ uyɛɛ ɑnyɑ̃́ ilukɛ kɛcɑ́ɑ́ m pɑílɛ̃ uu pɛɛ unɔ́sikɔ́ uyɛ̃ sée, ");
INSERT INTO soy_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","uu u mɑɑ rɛ: Pítɑ lɑri-lɑri kɛ pisoi ɑpi yɛ nɛ pinírɛ́ kórɑɑnɛ. Pin n lɛ, ɑpi pɛɛ pikópɛ lesɛri. Amɑ́ pítɑ lɑri-lɑri kɛ pɔ́ɔ yekei ɑí nɛ nkpéni tulu! ");
INSERT INTO soy_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Lɛ̃ kɛ Yeesu uu Kɑlilee kɛteni-i Kɑnɑɑ-pɔ mɛwɑisɑŋɑ piwɑi kori. Lɛ̃ kuú nɛ ummulɛ nyísɛ upipirɛtiki ɑpi pɛɛ́ nɛ kɛfɑ u tɛnɛ. ");
INSERT INTO soy_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Lɛ̃ mɛmɑ́ɑ́, Yeesu nɛ úni nɛ upimɑrɛcɔ nɛ upipirɛtiki ɑpi yisi ɑpi Kɑpɛrinɑwum tɔ́mpɔ ɑpí hɑ kei siyɑ́ɑ sinyinɛ wɑi, ɑ́pi nɑ́ŋɑi. ");
INSERT INTO soy_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Kɛ Pisuifi nkpɔ mɛlɔ́ɔ́ ɑnyɑ̃́ ɑɑ nnyɑ́ɑ̃ n wɑ, Yeesu uu pɛɛ yisi uu Yerusɑlɛm tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Uu kei Uléécɑɑ kɛyɔ kɛ́mɛɛ pikpéensɛ lɛɛpɔ pin inɑ́ɑ nɛ isɑ́ŋ nɛ ɑlɔ́ɔlɑ̃ yɑ́i, picɔ pɔ́ɔn túntilɛ̃ pin nɛ siwóó foru. ");
INSERT INTO soy_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Kei kuu íŋmɛ kpísi uú nɛ nsɛ́í wɑi uú nɛ pi nɛ piisɑŋ nɛ piinɑɑ Uléécɑɑ kɛyɔ kɛ́mɛɛ lɑ́kɑsɛ ɑpí lelu. Uu piwóóforɛ ɑtɑɑpili lɑ́uli, siwóó ɑsi yɛ́kɑ́ɑ́. ");
INSERT INTO soy_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Uu pɛɛ pilɔ́ɔlɑ̃yɑ́i pɔ̃́ mɑɑ rɛ: Kɛ́ nté nɔ́ pɑɑ nfɑ́ɑni, ɑ́ni kɑpɛ Unɛ́sɑ́ɑ kɛyɔ kuyɑ́ɑ pɑnsɛsɛ. ");
INSERT INTO soy_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Kei kɛ upipirɛtiki ɑpi pɛɛ nsímɛ́ mmú mɛɛ Nléécɑɑsimɛ́ ritɛlɛ́ kɛ́mɛɛ n wɔ́lɑɑlɛ̃ léisɛ rɛ: Hɑi Uléécɑɑ! Lɛ̃ kɑm nní kɛpɔ́yɔ ń lɑ yɛ nɛ́ torɛlɛ yɑrɛ nnɑ. ");
INSERT INTO soy_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Kei kɛ Pisuifi piwɛ́ɛ́sɛ ɑpi pɛɛ u pisɛ rɛ: Mɛwɑisɑŋɑ mɛ́ye kɑɑ yɛ́ fe ɑɑ wɑi ɑɑ́ nɛ rɔ́ nyísɛ rɛ pɔ ncée mɑ́lɛ pɔkɛ́ lɛ̃ wɑ? ");
INSERT INTO soy_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yeesu uu pi pɛsɛ rɛ: Ani Uléécɑɑ kɛyɔ nkɛ́ fori kɛ́ siyɑ́ɑ sitɑɑni nɛ pimɔ́mɛ kɛ pɛsɛ. ");
INSERT INTO soy_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Api u pisɛ rɛ: Aŋmɛ̃ ɑfɛɛnɑ nɛ ɑkpuulũ kɑpí nɛ kɛ́yɔ nkɛ́ mɔ̃́. Kɛ̃ kɛ pɔ́ɔ músu rɛ pɔ́ fe ɑɑ siyɑ́ɑ sitɑɑni nɛ mɔmm? ");
INSERT INTO soy_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Nɛ́ḿpɑ́kɑnɛ umɛcirɛ kuú pɛɛ́ nɛ lɛ̃ mɑ́nɛ kuú nɛ Uléécɑɑ kɛyɔ nkɔ́ símisi. ");
INSERT INTO soy_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Kɛ Uléécɑɑ uu Yeesu nkpɔ kɛ́mɛɛ n yukusɛ, upipirɛtiki ɑpi pɛɛ léisɛ rɛ u pɛɛ ɑnɔ́ɔ nyɛ̃ mɑlɛ. Api pɛɛ Nléécɑɑsimɛ́ nɛ ɑnɔ́ɔ nyɛ̃ kɛ uricuruu uu ḿ mɑ nɛ kɛfɑ tɛnɛ. ");
INSERT INTO soy_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Nkpɔ mɛlɔ́ɔ́ ɑnyɑ̃́ kumúŋɛ́, Yeesu un Yerusɑlɛm-i we. Pisoi ɑpi mɛwɑisɑŋɑ kuu n wɑpisi yɛ́nti ɑpi pɛɛ́ nɛ kɛfɑ u tɛnɛ. ");
INSERT INTO soy_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Amɑ́ kɛ Yeesu pɔ́ɔ pikɛmúŋɛ́ nnɛ́í n nyu nnyɑ, úu nɛ ripɔ́ɔ pi lɑrisi. ");
INSERT INTO soy_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ái we rɛ pikɛ́ pisoi kɛcɑ́ɑ́ nsímɛ́ u símisi. Uricuruu yɛ lɛlɛɛ sisoipipi sifɑ-i ń we nyulɛ. ");
INSERT INTO soy_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Utisi unyinɛ yɛɛ pɛɛ́ we, ɑpi yɛ u séi rɛ Nikotɛm. U pɛɛ Pifɑrisi kunɑi kɛ́mɛɛ welɛ un kɔ Pisuifi uwɛ́ɛ́sɛ usɛ unyinɛ. ");
INSERT INTO soy_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Uu kɛsinɛ kɛnyinɛ Yeesu-i sĩ́ uú hɑ u mɑɑ rɛ: Ucélɑɑ, tɔ nyulɛ rɛ Uléécɑɑ yɛɛ pɔ́ tummɛ rɛ ɑ rɔ́ céési. Uléécɑɑ unsɑ́ usoi kɛpirɛ n we, úu yɛ́ fe ukɛ́ mɛwɑisɑŋɑ mmɛ́ kɑɑ nní n wɑi mɛcɔ n wɑi. ");
INSERT INTO soy_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yeesu uu u pɛsɛ rɛ: Kɛ́ pɔ́ símisi ɑsei kɛcɑ́ɑ́ rɛ pinsɑ́ úye pimɑ́rɛ rinkpɑ́, úu Uléécɑɑ iyɔɔpi yɛnunɛ. ");
INSERT INTO soy_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Kei kɛ Nikotɛm uu pɛɛ u pisɛ rɛ: Íye kɑpi yɛ́ kɔ fe ɑpi usoi yɛɛ pikpurũ ḿ mɑsí pimɑ́rɛ kpɑ́? Yɑrɛ u yɛ́ fe uu kɔ úni kɛfɑ-i pɛɛpɔ ɑpi kɔ pimɑ́rɛ u kpɑ́ nɛ́ɛ? ");
INSERT INTO soy_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yeesu uu u pɛsɛ rɛ: Kɛ́ pɔ́ símisi ɑsei kɛcɑ́ɑ́ rɛ pinsɑ́ míni nɛ Uléécɑɑ Nfɑɑ kɛcɑ́ɑ́ rintiki pikɛ́ nɛ usoi pimɑ́rɛ rikpɑ́, úu Uléécɑɑ iyɔɔpi yɛnunɛ. ");
INSERT INTO soy_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Lɛ̃ kɛ kɛsoipipi ɑkɛ m mɑ́ri yɛ lisoikɔ́ lɛ. Lɛ̃ kɛ Uléécɑɑ Nfɑɑ nn nfɑ́ɑ n hɛ yɛ Nfɑ́ɑsɔnɛ likɔ́ lɛ. ");
INSERT INTO soy_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ái kɑpɛ pírí pɔ́ wɑ rɛ nɛ mɑɑ rɛ li pisɛ rɛ pikɛ́ pimɑ́rɛ nɔ́ rikpɑ́ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Kuyɔ kun yei n lɑ, kei kɑku yɛ m pepu, ɑɑ kunnɛ̃́ n kómɛi, ɑmɑ́ ɑ́ɑ pɛɛ nyu mɛ́ye kɑku léeri, mɛ́ye kɑku sĩ́. Limɛcɔ kɛ uyɛ̃ kɛ Uléécɑɑ Nfɑɑ nn nfɑ́ɑ n hɛ pɔ́ɔ kɔ we. ");
INSERT INTO soy_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Kei kɛ Nikotɛm uu kɔ pipisɛ u rikpɑ́ rɛ: Íye kɑi yɛ́ fe ɑi lɛ̃ wɑi? ");
INSERT INTO soy_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yeesu uu u pɛsɛ rɛ: Pɔ Isirɑyɛɛli kɛtẽ kɛ́mɛɛ ucélɑɑ wɛ́ɛ́sɛ lɛ. Yo nnyɑ kɑ́ɑ pɛɛ liɑsei kómɛi? ");
INSERT INTO soy_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Kei kɛ Yeesu uu pɛɛ u mɑɑ rɛ: Kɛ́ pɔ́ símisi ɑsei kɛcɑ́ɑ́ rɛ lɛ̃ kɑri n nyu nkɔ́ kɑri símisi. Lɛ̃ kɑri n yɛ̃́ kɛcɑ́ɑ́ kɑri ɑseérɑ lesɛ. Amɑ́ nɔ̃́ ɑ́ni lɑ nɔkɛ́ ɑrɔ́seérɑ nyɛ̃ ŋmurɛi. ");
INSERT INTO soy_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nɛ yɛ nɛn lɛlɛɛ kɛtẽ nté n wɑi nsímɛ́ nɔ́ n símisi, ɑ́ni yɛ ŋmurɛi. Íye kɑni yɛ́ pɛɛ fe ɑni ŋmurɛi in tɛ nɛ lɛlɛɛ kɛyómɛcɑɑ-pɔ n wɑi nsímɛ́ nɔ́ símisi? ");
INSERT INTO soy_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Úkɑ úu píkɑi kɛyómɛcɑɑ hɑ́pɑɑlɛ̃, insɑ́ Usoi Kɛpipi kɛɛ kɛyómɛcɑɑ-pɔ n léeri mɛcirɛ. ");
INSERT INTO soy_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Moisi yɛ pɛɛ nweni ŋmɔhɔ nɛ iwɑ́ɑ wɑlɛ uu kucɛsi kóimɑ-i kunɑ kɛcɑ́ɑ́ kɔ́lɔ. Limɛcɔ kɑpi sɔ́nti pikɛ́ Usoi Kɛpipi kunɑ kɛcɑ́ɑ́ rikɔlɔ. ");
INSERT INTO soy_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Úye un pɛɛ́ nɛ kɛfɑ u n tɛnɛ, liute ukɛ́ nɛ nfɑ́ɑ tɛnɛcirɛ́ n yɛ̃́ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Li we rɛ Uléécɑɑ yɛ pisoi mɛyíkíyiki lɑlɛ hɑ́i uú nɛ Ukɛpipi Cirɛníŋɛ pɑmɛ rɛ úye un nɛ kɛfɑ kɛ n tɛnɛ, liute úu kɑpɛ pɔ, ɑmɑ́ ukɛ́ nfɑ́ɑ tɛnɛcirɛ́ yɛ̃́. ");
INSERT INTO soy_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Asei kɛcɑ́ɑ́, Uléécɑɑ úu Ukɛpipi kɛtẽ kɛcɑ́ɑ́ tummɛ rɛ kɛkɛ́ nɛ pisoi túhɑɑnɛ likɛ́ nɛ pi kpu. Amɑ́ u kɛ tummɛlɛ rɛ kɛkɛ́ piriyu lɔ. ");
INSERT INTO soy_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Úye un nɛ kɛfɑ kɛ n tɛnɛ, Uléécɑɑ úu yɛ́ uyɛ̃ nɛ túhɑɑnɛ likɛ́ nɛ u kpu, ɑmɑ́ úye unsɑ́ nɛ kɛfɑ kɛ n tɛnɛ, Uléécɑɑ yɛ nɛ uyɛ̃ pitúhɑɑnɛ mɑsilɛ rɛ úu Uléécɑɑ Kɛpipi Cirɛníŋɛ rinyiri nɛ kɛfɑ tɛnɛ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Lɛlɛɛ n tíyɛsɛ kɛ Uléécɑɑ uú nɛ pisoi n túhɑɑnɛnɛ yɛɛ rɛ mɛtɛ́í yɛ kɛtẽ kɛcɑ́ɑ́ léemɛlɛ, kɛ pisoi ɑpi mɛwɑi kópɛ n wɑi nnyɑ, ɑpi mɛtɛ́í yúlu ɑpi pɛɛ kuŋmɑhɑ mɛyɑ̃́ n lɑ. ");
INSERT INTO soy_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Li we rɛ nkó yɛɛ mɛwɑi kópɛ n wɑi yɛ mɛtɛ́í kɔ́hɔlɛ, úu yɛ nɛ mɛ rikɔ, un wuru rɛ ɑ́i kɑpɛ umɛwɑi kópɛ yɑ́mnɛ. ");
INSERT INTO soy_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Amɑ́ nkó yɛɛ nsímɛ́sei n tíkilɛ̃ yɛ̀ɛ̀ mɛtɛ́í kɛ́mɛɛ léepɔlɛ likɛ́ nyísɛ rɛ Uléécɑɑ kɛ́mɛɛ kɛ umɛwɑi nnɛ́í ɑmɛ léeri. ");
INSERT INTO soy_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Lɛ̃ mɛmɑ́ɑ́, Yeesu uu yisi u nɛ upipirɛtiki ɑpi Yutee kɛtẽ-mɛ̃ tɔ́mpɔ. U nɛ pɛ̃ ɑpi kei siyɑ́ɑ sinyinɛ wɑi un pisoi míni wolɛ. ");
INSERT INTO soy_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yohɑni pɔ̃́ nɛ kɔ pɛɛ Enɔɔ kuyu-i welɛ uu yɛ pisoi míni wolɛ. Ái kei nɛ Sɑlim kuyu kɛtɑɑ we. Míni yɛ pɛɛ kei mɛyɑ̃́ welɛ. Pisoi pin pɛɛ mɛsɛ́rɛ ukɛmɛɛ sɔ́nɑɑpɔ un míni pi wolɛ. ");
INSERT INTO soy_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ápi pɛɛ kɑhɑnɛ likumúŋɛ́ kpɛ-i u n tĩ pikɛ́ kpɑnii. ");
INSERT INTO soy_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Yohɑni pipirɛtiki pinyinɛ nɛ Usuifi unyinɛ ɑpi pɛɛ kɛyɑ́ɑ inyɛ́kii kɑpi yɛ nɛ usoi n nyɔ́ɔnsɛ kɛcɑ́ɑ́ nsímɛ́ pɑ́sɑinɛ. ");
INSERT INTO soy_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Apí nɛ Yohɑni lɛɛpɔ ɑpi u mɑɑ rɛ: Ucélɑɑ, pɔ nɔ́ nɛ utisi uyɛ̃ nɔ́ɔ pɛɛ Yuritɛɛ nkoi mɛtɛ́ŋ́-mɛ̃ ń we, ɑɑ ukɛcɑ́ɑ́ ɑseérɑ lesɛ léisɛɛ? Uyɛɛ nní we un míni pisoi wolɛ, pinnɛ́í pin ukɛmɛɛ sɔ́nɑɑpɔ! ");
INSERT INTO soy_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yohɑni uu pi pɛsɛ rɛ: Uléécɑɑ un ńnɑŋɛ pɔ́ n hɛ rɛ ɑ nɛ linyinɛ wɑ mɛcirɛ kɑɑ yɛ fe ɑɑ li wɑi. ");
INSERT INTO soy_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nɔ́rinɛ́cúruu yɛ́ fe ɑni ɑseérɑ kɛnɛ́cɑ́ɑ́ lesɛ rɛ nɛ pɛɛ́ mɑɑ rɛ: Ái nɛ́ɛ Kirisi kɛ Uléécɑɑ uu n wɛ́ɛ. Amɑ́ Uléécɑɑ yɛ nɛ́ tummɛlɛ rɛ kɛ́ nɛ uyɛ̃ kuu n wɛ́ɛ kɛkpéẽ wɑimɛ. ");
INSERT INTO soy_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Nkó yɛɛ unɔ́si n kpísi yɛɛ unɔ́sikɔ́. Amɑ́ unɔ́sikɔ́ uyɛ̃ usɑnɛ pɔ̃́ nɛ yɛ ukɛkúrí n welɛ un unɔ́sikɔ́ mɛtẽ kómɛi lin u lɑ́ɑ́rú. Limɛcɔ ŋmɑɑ kɑi nní mɛyíkíyiki nɛ́ lɑ́ɑ́rú, uyɛ̃ kɛ Uléécɑɑ uu n wɛ́ɛ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Li nɛ sɑ́ rɛ uyɛ̃ tinyiri tikɛ́ n tɑɑ́lɛ̃, tinɛ́kɔ́ tikɛ́ n cɛpilɛ̃. ");
INSERT INTO soy_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Nkó yɛɛ kɛyómɛcɑɑ-pɔ n léeri yɛ ḿpɑ́ úye felɛ. Nkó yɛɛ kɛtẽ nté ń we yɛ kɛtẽ nté ukɔ́ lɛ. Kɛtẽ nté likɔ́ nsímɛ́ kuu yɛ n símisi. Nkó yɛɛ kɛyómɛcɑɑ-pɔ n léeri yɛ ḿpɑ́ úye felɛ. ");
INSERT INTO soy_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Lɛ̃ kuu n yɛ̃́ uu kɔ kom ɑseérɑ kuu lésɛ, ɑmɑ́ úkɑ úu kɔ pɛɛ lɛ̃ kuu ḿ mɑ ŋmurɛi. ");
INSERT INTO soy_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Uyɛɛ lɛ̃ kuu ḿ mɑ n ŋmurɛi yɛ mɑlɛ uu wééri rɛ Uléécɑɑ yɛ ɑsei lɛ. ");
INSERT INTO soy_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Li we rɛ Uléécɑɑ nsímɛ́ kuu ḿ mɑ kɛ uutumɛ uu yɛ símisi. Lɛ̃ nnyɑ kɛ Uléécɑɑ uu yɛ uyɛ̃ kuu n tũ Nfɑ́ɑsɔnɛ hɛ ɑ́i kumúŋɛ́ mɑ́. ");
INSERT INTO soy_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Sɑ́ɑ Uléécɑɑ yɛ Ukɛpipi lɑlɛ uu ḿpɑ́ yo kɛɑnipɛ-i wɑi. ");
INSERT INTO soy_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nkó yɛɛ Uléécɑɑ Kɛpipi nɛ kɛfɑ n tɛnɛ yɛ nfɑ́ɑ tɛnɛcirɛ́ mɑ́lɛ. Nkó yɛɛ kɛnkɔ́ n kɛ́su úu yɛ́ nfɑ́ɑ mmɛ̃ yɛ̃. Amɑ́ Uléécɑɑ yɛ nɛ u wɔ́lɑɑlɛnlɛ. ");
INSERT INTO soy_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Pifɑrisi ɑpi kóm tɛ Yeesu yɛ pipirɛtiki mɛyɑ̃́ yɛnlɛ un kɔ pisoi mɛyɑ̃́ míni wolɛ ɑi tɔ́su Yohɑni pikɔ́. ");
INSERT INTO soy_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Asei kɛcɑ́ɑ́, Yeesu ricuruu úu pɛɛ úkɑ míni wolɛ. Upipirɛtiki pɛɛ yɛ pɛɛ pisoi wolɛ. ");
INSERT INTO soy_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Kɛ Yeesu uu n kṍ tɛ lɛ̃ kɛ pisoi ɑpi símɑɑnkɛɛ, uu Yutee kɛteni-i yisi uu Kɑlilee kɛtẽ-mɛ̃ pɛlɛ. ");
INSERT INTO soy_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Uncee yɛ pɛɛ kɔ Sɑmɑrii kɛtẽ-mɛ̃ cɔlɛ nń nɛ kei lompɔ. ");
INSERT INTO soy_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Uu pɛɛ Sɑmɑrii kɛyupi kɛnyinɛ kɑpi yɛ n sée rɛ Sisɑɑ tulu. Ái kei nɛ kɛcɑrɛ kɛ̃ kɛ Yɑkupu uú pɛɛ uuŋmɑ́nɛ Yosɛfi n hɛ kɛtɑɑ we. ");
INSERT INTO soy_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Kei kɛ Yɑkupu kɛlukɑnkɑ ɑkɛ́ pɛɛ́ we. Kɛtúŋɛ́ kɛfi nɛ mɛtɛ́ kumúŋɛ́ kɛ Yeesu uu kei tuipɔ, nsẽ́ nn u pelɑɑlɛ̃, uu pɛɛ kɛlúkɑnkɑ kɛ̃ kɛkúrí tonɛ. ");
INSERT INTO soy_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Sɑmɑrii kɛtẽ unɔsi unyinɛ uu pínilṹ hɑpɔ. Yeesu uu pɛɛ u mɑɑ rɛ: A míni nɛ́ hɛ kɛ́ n ntí. ");
INSERT INTO soy_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Upipirɛtiki pɔ̃́ nɛ pɛɛ likumúŋɛ́ kpɛ-i lilukɛ-lukɛ piwɛ́lɑɑ hɑlɛ kuyu-pɔ. ");
INSERT INTO soy_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Sɑmɑrii kɛtẽ unɔsi uyɛ̃ uu pɛɛ Yeesu mɑɑ rɛ: Íye kɛ pɔ̃́ Usuifi, ɑɑ yɛ́ fe ɑɑ nɛ̃́ Sɑmɑrii ukɔ́ mɑɑ rɛ kɛ́ míni pɔ́ hɛ pɔkɛ́ n ntí? Pisuifi nɛ Sɑmɑrii pikɔ́ ɑ́pi yɛ pɛɛ rikɔnɛ. ");
INSERT INTO soy_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yeesu uu u pɛsɛ rɛ: Pɔn pɛɛ lɛ̃ kɛ Uléécɑɑ uu yɛ n hɛ n nyu, pɔn kɔ pɛɛ uyɛɛ nní pɔ́ m pisɛ rɛ ɑ míni u hɛ n nyu, pɔ́ɔ yɛ pɛɛ u pisɛ rɛ ukɛ́ míni pɔ́ hɛ, uu pɛɛ míni mɛɛ yɛ nfɑ́ɑ n hɛ pɔ́ hɛ. ");
INSERT INTO soy_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Unɔ́si uyɛ̃ uu u mɑɑ rɛ: Upíimɑ, kɛlúkɑnkɑ nkɛ́ ɑ́kɛ kusɑ címú, ɑ́ɑ kɔ líkɑ mɑ́ pɔkɛ́ nɛ lṹ. Íye kɑɑ yɛ́ pɛɛ fe ɑɑ́ nɛ míni mɛɛ yɛ nfɑ́ɑ n hɛ yɛnu? ");
INSERT INTO soy_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Urɔ́sɑ́ɑyɑhɑ Yɑkupu yɛɛ kɛlúkɑnkɑ nkɛ́ nɛ rɔ́ tíyɛ. U nɛ usipipi nɛ uɑsɛɛlee yɛɛ pɛɛ míni mɛ̃ n ntílɛ. Yɑrɛ pɔ músu rɛ pɔ Yɑkupu felɛ nɛ́ɛ? ");
INSERT INTO soy_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yeesu uu u pɛsɛ rɛ: Nnírɛ́ yɛ́ usoi nkó yɛɛ míni mmɛ́ ń ntí piwɑi rikpɑ́. ");
INSERT INTO soy_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Amɑ́ nnírɛ́ ńn píkɑi nkó kɛ nɛ́ɛ míni n hɛ uu mɛ níru piwɑi kpɑ́nɛ. Míni mɛ̃ kɑm u n hɛnɛ yɛ ukɛmɛɛ pɑnsɛnɛ ńnihɔi mɛɛ yɛ nfɑ́ɑ tɛnɛcirɛ́ n hɛ. ");
INSERT INTO soy_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Kei kɛ unɔ́si uyɛ̃ uu pɛɛ u mɑɑ rɛ: Upíimɑ, ɑ mɛpɔ́ni mɛ̃ nɛ́ hɛ nnírɛ ńn kɑpɛ yɛ kɔ piwɑi nɛ́ rikpɑ́. Pɛɛ́ uyɛ-i, ɑ́i pɛɛ pisɛ rɛ kɛ́ yɛ kɔ nté pínilṹ pɛɛmɛ. ");
INSERT INTO soy_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yeesu uu pɛɛ u mɑɑ rɛ: A n ŋme ɑ hɑ upɔ́lɑ séemɛ ɑɑ́ weri. ");
INSERT INTO soy_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Unɔ́si uyɛ̃ uu u pɛsɛ rɛ: Ám ulɑ mɑ́. Yeesu uu pɛɛ u mɑɑ rɛ: Pɔ ɑlɑri mɑ́lɛ pɔkɛ́ rɛ ɑ́ɑ ulɑ mɑ́. ");
INSERT INTO soy_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Pilɑ pinupũ kɑɑ pisɔ́ɔ̃ mɑsí. Nɔ́ nɛ utisi uyɛɛ kɔ nkpéni ń we úu kɔ upɔ́lɑ. Pɔ ɑsei mɑ́lɛ. ");
INSERT INTO soy_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Unɔ́si uu pɛɛ u pɛsɛ rɛ: Upíimɑ, nɛ yɛ̃ tɛ pɔ ɑntepu lɛ. ");
INSERT INTO soy_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Tiyɔ́pɛ ntí kɛcɑ́ɑ́ kɛ tɔ̃́ pisɑɑyɑhɑ ɑpí pɛɛ Uléécɑɑ yɑ́ɑsi. Amɑ́ nɔ̃́ Pisuifi ɑni rɛ Yerusɑlɛm-i kɑi pisɛ rɛ pikɛ́ yɛ Uléécɑɑ yɑ́ɑ́si. ");
INSERT INTO soy_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yeesu uu pɛɛ u mɑɑ rɛ: A kõ tɛ nú unɔ́si, li ituŋɛ inyinɛ-i sɔ́ntilɛ, ɑ́i pɛɛ pisɛ rɛ riyɔ́pɛ ntí-i nɛ́ɛ Yerusɑlɛm-pɔ kɑni yɛ́ɛ́ Sɑ́ɑ Uléécɑɑ yɑ́ɑ́si. ");
INSERT INTO soy_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nɔ̃́ Sɑmɑrii pikɔ́, ɑ́ni Uléécɑɑ uyɛ̃ kɑni n yɑ́ɑ́si nyu. Tɔ̃́ Pisuifi yɛ Uléécɑɑ uyɛ̃ kɑri n yɑ́ɑ́si nyulɛ. Tɔ̃́ Pisuifi kɛ́mɛɛ kɛ píyulɑlɛ ɑpi léeri. ");
INSERT INTO soy_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Amɑ́ li ituŋɛ inyinɛ-i sɔ́ntilɛ, ticuruu li pikɑ́mɛ mɑsilɛ. Pɛpɛɛ Sɑ́ɑ Uléécɑɑ n yɑ́ɑ́si yɛ́ɛ́ nɛ piisoi nnɛ́í u yɑ́ɑ́si nɛ ɑsei. Pɛpɛɛ lɛ̃ u n yɑ́ɑ́si kuu wɛ́ɛ́si. ");
INSERT INTO soy_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Uléécɑɑ yɛ Nfɑ́ɑsɔnɛ lɛ. Lɛ̃ nnyɑ, li pisɛ rɛ pɛpɛɛ u n yɑ́ɑ́si pikɛ́ yɛ nɛ piisoi nnɛ́í ritiki ɑpí nɛ u yɑ́ɑ́si nɛ ɑsei. ");
INSERT INTO soy_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Unɔ́si uyɛ̃ uu pɛɛ Yeesu mɑɑ rɛ: Nɛ nyulɛ rɛ uyɛ̃ kɛ Uléécɑɑ uu n wɛ́ɛ yɛ wemɛlɛ. Uyɛ̃ kɑpi yɛ sée rɛ Kirisi. Un píyei n kɑ, u yɛ́ linnɛ́í tɔ́ riyóó. ");
INSERT INTO soy_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yeesu uu pɛɛ u mɑɑ rɛ: Nɛ́ɛ nɛ nní pɔ́ n símisi, nɛ́ɛ liute uyɛ̃. ");
INSERT INTO soy_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Yeesu pipirɛtiki ɑpi likumúŋɛ́ kpɛ-i tuipɔ, ɑi nnɔ́ɔ pi yipu rɛ pi u yɛ̃ un nɛ unɔ́si unyinɛ símisi nnyɑ. Amɑ́ piukɑ úu kɑhɑ ukɛ́ u pisɛ rɛ: Yo kɑɑ ukɛmɛɛ wɛ́ɛ́si nɛ́ɛ yo nnyɑ kɑɑ́ nɛ u símisi? ");
INSERT INTO soy_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Unɔ́si uyɛ̃ uu pɛɛ ukɛnintúhu kei yɑ́ uu kuyu pɛlɛ uú hɑ pisoi símisi rɛ: ");
INSERT INTO soy_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Ani kɑm ɑni usoi unyinɛ yɛ̃ yɛɛ mɛnɛ́wɑi nnɛ́í kɑm n wɑpisi nɛ́ n kɛ́ɛ́nkɛɛ. In n lɑ, ɑ́i nkpéni uyɛ̃ kɛ Uléécɑɑ uu wɛ́ɛ? ");
INSERT INTO soy_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Api pɛɛ kuyu-i léenti ɑpi símpɔ ɑpí hɑ Yeesu lɛɛpɔ. ");
INSERT INTO soy_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Upipirɛtiki ɑpi pɛɛ likumúŋɛ́ kpɛ-i u kpukɛisɛ rɛ: Ucélɑɑ, ɑ kɑm ɑ li. ");
INSERT INTO soy_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Kei kuu pɛɛ pi pɛsɛ rɛ: Ilukɛ inyinɛ kɑ́ni n nyu kɑm mɛlukɛ mɑ́. ");
INSERT INTO soy_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Kei kɛ upipirɛtiki ɑpi pɛɛ pimɛcɔpɛcirɛ pipísɛinɛ lõ tɛ: Nɛ́ɛ unyinɛ yɛ nɛ ilukɛ u kɑlɛ uu le? ");
INSERT INTO soy_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yeesu uu pɛɛ pi mɑɑ rɛ: Inɛ́lukɛ yɛɛ rɛ kɛ́ uyɛɛ nɛ́ n tummɛ mɛlɑ n wɑi, kɛ́ kɔ pikɛi pɛ̃ kuu nɛ́ n forii n wɑi nɛ kɛ́tɔ-pɔ. ");
INSERT INTO soy_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Nɔ́rinɛ́cúruu nɔ́ɔ yɛ mɑɑ rɛ: Li tisɛ iwɑ́rɛ inɑ likɛ́ nɛ kúkpɑɑ tu. Kɛ́ nɔ́ símisi rɛ ɑni ńsɔnɛ ripɑí ɑni yɛ́nu rɛ ilukɛ yɛ sicɑrɛ-i pipele mɑsilɛ rɛ pikɛ́ i kpɑsi. ");
INSERT INTO soy_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ticuruu ukpɑ́ɑ yɛ welɛ un uihɛ́ɛ́ yɔ́su, un kɔ ilukɛ kuu n kpɑ́si cɑ́pinɛntɛ rɛ ikɛ́ nfɑ́ɑ tɛnɛcirɛ́ yɛ̃́. Kei kɛ ulukɑɑ nɛ ukpɑ́ɑ ɑpɔɔ ɑɑ yɛ́ pɛɛ kɛsẽ́ n lɑ́ɑ́rú. ");
INSERT INTO soy_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Lɛ̃ kɛ́mɛɛ, mɛyu mmɛ́ yɛ ɑsei lɛ rɛ: Ucɔ yɛɛ yɛ lukɛsi, ucɔ uú kpɑsi! ");
INSERT INTO soy_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nɛ nɔ́ tunlɛ rɛ ɑni hɑ kɛcɑrɛ kɛ-i kɑ́ni pikɛi píkɑ n wɑ kɛ́mɛɛ kpɑsi. Picɔ pɛɛ kei kɛisi, nɔ́ɔ nkpéni weri ɑni pipikɛi kulɑɑ n le. ");
INSERT INTO soy_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Sɑmɑrii pikɔ́ mɛyɑ̃ yɛ nɛ Yeesu kɛfɑ tɛnɛlɛ rɛ unɔ́si uyɛɛ mɑɑ rɛ: Lɛ̃ nnɛ́í kɑm n wɑ kuu nɛ́ símisi. ");
INSERT INTO soy_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Lɛ̃ nnyɑ kɑpi Yeesu-i hɑ́pɔ ɑpi u pisɛ rɛ ukɛ́ pikɛkúrí kɛtónɛ rikpɑ́. Uu ŋmurɛi uu pikɛkúrí tonɛ siyɑ́ɑ sitɛ́. ");
INSERT INTO soy_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Kɛ Yeesu uu uricuruu nɛ unnɔɔ nsímɛ́ pi n símisi nnyɑ, pisoi kulúi píimɑ picɔ ɑpi kɔ nɛ kɛfɑ u tɛnɛ. ");
INSERT INTO soy_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Api yɛ pɛɛ unɔ́si uyɛ̃ mɑɑ rɛ: Ái nsímɛ́ mmɛ̃ kɑɑ rɔ́ n símisi ŋmɑnɛ nnyɑ kɑrí nɛ kɛfɑ Yeesu tɛnɛ. Amɑ́ tɔ uricuruu konlɛ un símisi, ɑri céru rɛ u mɛsei pisoi nnɛ́í Uyulɑlɛ lɛ. Lɛ̃ nnyɑ kɑrí nɛ kɛfɑ u tɛnɛ. ");
INSERT INTO soy_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Kɛ Yeesu uu siyɑ́ɑ sitɛ́ sɛ̃ kei n tónɛ, uu yisi uu Kɑlilee kɛtẽ-mɛ̃ tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yeesu ricuruu yɛ pɛɛ́ mɑɑ rɛ: Ápi yɛ ɑntepu úkɑ ukɛtẽ cirɛ-i n wɑisɛlɛ̃. ");
INSERT INTO soy_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Amɑ́ kuu Kɑlilee kɛteni-i n tuipɔ, kei pikɔ́ yɛ kusɑ́nɛ u yɔsilɛ ńsɔnɛ, kɛ pɛ̃ ŋmɑɑ ɑpí pɛɛ Yerusɑlɛm-pɔ nkpɔ mɛlɔ́ɔ́ ɑnyɑ̃́ ń hɑ ɑpi lɛ̃ nnɛ́í kuu n wɑ yɛnu nnyɑ. ");
INSERT INTO soy_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yeesu uu pɛɛ Kɑlilee kɛtẽ-pɔ Kɑnɑɑ kuyu-i pɛlɛ. Kei kuú pɛɛ wɑ míni ɑmɛ pɑnsɛ pítɑ. Uyɔ́ɔpi usɔ́ɔ́cɑ wɛ́ɛ́sɛ unyinɛ yɛɛ pɛɛ Kɑpɛrinɑwum-pɔ we, uuŋmɑ́nɛ un pɔ́ɔ́lú. ");
INSERT INTO soy_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Kuu n kṍ tɛ Yeesu yɛ Yutee kɛtẽ-pɔ yisi uu Kɑlilee kɛteni-i hɑpɔ, uu ukɛmɛɛ sĩ́ uú hɑ u welu rɛ ukɛ́ Kɑpɛrinɑwum hɑpɔ ukɛ́ uuŋmɑ́nɛ yɛɛ nɛ nkpɔ n nɑ́ɑ́si pɔisɛ. ");
INSERT INTO soy_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yeesu uu pɛɛ u pisɛ rɛ: Nɔnsɑ́ mɛwɑisɑŋɑ nɛ mɛwɑi píimɑ n yɛ̃, ɑ́ni yɛ́ fe nɔkɛ́ nɛ kɛfɑ nɛ́ tɛnɛ, nɛ́ɛ yo. ");
INSERT INTO soy_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Uyɔ́ɔpi usɔ́ɔ́cɑ uyɛ̃ uu Yeesu pɛsɛ rɛ: Upíimɑ, ɑ kɛnɛ́yɔ hɑ unɛ́ŋmɑ́nɛ ukɛ́ kɛlenɛ kpu. ");
INSERT INTO soy_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Kei kɛ Yeesu uu pɛɛ u mɑɑ rɛ: A n ŋme ɑ kui, upɔ́ŋmɑ́nɛ yɛ nfɑ́ɑ mɑ́lɛ. Uu Yeesu nsímɛ́ mmɛ̃ ŋmurɛi, uu yisi uú kulu. ");
INSERT INTO soy_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Kuu nkúlɛcee n kpísi, upikɛikɔ́ ɑpí nɛ u sɑ́nɛ ɑpi u mɑɑ rɛ: Upɔ́ŋmɑ́nɛ yɛ nfɑ́ɑ mɑ́lɛ. ");
INSERT INTO soy_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Uu pi pisɛ rɛ: Ituŋɛ íye kumúŋɛ́ kɛ uipiŋɛ ii kutɔsi piwɑi korɑɑnɛ? Api rɛ: Sé kɛtúŋɛ́, mɛsɛ kumúŋɛ́ kɛ kupiŋɛtoi ɑku ukɛcɑ́ɑ́ le. ");
INSERT INTO soy_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Usɑ́ɑ uyɛ̃ uu pɛɛ léisɛ rɛ ituŋɛ iyɛ-i ŋmɑɑ kɛ Yeesu uu sé u mɑɑ rɛ: Upɔ́ŋmɑ́nɛ yɛ nfɑ́ɑ mɑ́lɛ. Lɛ̃ nnyɑ kɛ u nɛ ukɛyɔ pikɔ́ nnɛ́í ɑpi Yeesu nɛ kɛfɑ tɛnɛ. ");
INSERT INTO soy_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Kɛ Yeesu uu Yutee kɛtẽ-pɔ n léemɛ uu Kɑlilee kɛteni-i pɛɛri, mɛwɑisɑŋɑ lírũ mɛcɔ kuu n wɑ yɛ mɛ̃. ");
INSERT INTO soy_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Lɛ̃ mɛmɑ́ɑ́, Pisuifi ɑnyɑ̃́ ɑnyinɛ yɛ pɛɛ kumúŋɛ́ kpɛ-i Yerusɑlɛm-i welɛ. Yeesu uu yisi uu sĩ́. ");
INSERT INTO soy_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Kúnipɔrɛ kunyinɛ yɛ kuyu kpɛ-i Isɑ́ŋ Tinɔnɔɔ kɛkúrí welɛ. Pi yɛ kupɔ́rɛ kpɛ̃ Epiree mɛyu kɛ́mɛɛ sée rɛ Pɛtɛsitɑ. Akúsi sipolɛ sinupũ kɑkú mɑ́. ");
INSERT INTO soy_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Pitóikɔ́ kulúi, pinyíyɛ nɛ síkɑnkɑ́lɑ́kɑ́ nɛ pipɑ́íkɔɔ́ yɛ pɛɛ imɛlɛ iyɛ̃ mɛtene fíntilɛnlɛ pin mɛ̃́ tɛ míni mɛkɛ́ lémesi. ");
INSERT INTO soy_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Uléécɑɑtumɛ unyinɛ yɛɛ pɛɛ kɛyɑ́ɑ kɛyɑ́ɑ súimɛlɛ uu míni pɔkɔi. Utóikɔ́ úye un mɛpɔ́kɔi-mɑɑ́ mɛfoí míni mɛ-i n lompɔ, ḿpɑ́ itói íye kuu pɔ́ɔ́lú, u yɛ peilɛ. ");
INSERT INTO soy_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Utisi unyinɛ yɛ pɛɛ kei welɛ. Kuú nɛ m pɔ́ɔ́lúmɛ, li wɑlɛ iŋmɛ̃ itɛ́ íi we ɑfɛɛnɑ. ");
INSERT INTO soy_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Kɛ Yeesu uu u n yɛ̃́ un kei finu, uu kɔ kom tɛ kuú nɛ m pɔ́ɔ́lúmɛ ɑ́i kusɑ nɑ́ŋɑi, uu u pisɛ rɛ: Pɔ lɑ pɔkɛ́ peii? ");
INSERT INTO soy_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Utóikɔ́ uyɛ̃ uu u pɛsɛ rɛ: Upíimɑ, ɑ́m úkɑ mɑ́ rɛ míni mɛn n lémesi ukɛ́ mɛkɛmɛɛ nɛ́ tɑmpɔ. Nɛ yɛ nɑ́ɑsilɛ, kɛ́ n tuipɔ, unyinɛ un nɛ́ fɔsí. ");
INSERT INTO soy_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Kei kɛ Yeesu uu pɛɛ u mɑɑ rɛ: A yisi ɑ ripɔ́sɑ́ŋɑ́ɑ́pɔrɛ́ kpísi ɑɑ sɔ́nɛ. ");
INSERT INTO soy_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Utisi uyɛ̃ uu mɛsɛ nɛ mɛsɛ pélu, uu urisɑ́ŋɑ́ɑ́pɔrɛ́ kpísi uu nsẽ́ kɑ́pɑ́ɑ́. Kɛwéntɛyɑɑ tuŋɛ́ kɑí pɛɛ lɛ̃ wɑi. ");
INSERT INTO soy_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Pisuifi piwɛ́ɛ́sɛ ɑpi utisi uyɛɛ nní ḿ peí mɑɑ rɛ: Nɛni yɛ kɛwéntɛyɑɑ lɛ. Lɛ̃ nnyɑ irɔ́sé kɛ́mɛɛ, ncée ńn we rɛ pɔkɛ́ ripɔ́sɑ́ŋɑ́ɑ́pɔrɛ́ cɔ̃. ");
INSERT INTO soy_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Uu pi pɛsɛ rɛ: Utisi uyɛɛ nɛ́ m pɔisɛ yɛ nɛ́ mɑɑ rɛ: A ripɔ́sɑ́ŋɑ́ɑ́pɔrɛ́ kpísi ɑɑ sɔ́nɛ. ");
INSERT INTO soy_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Api u pisɛ rɛ: Wóo liute uyɛɛ pɔ́ ḿ mɑɑ rɛ: A ripɔ́sɑ́ŋɑ́ɑ́pɔrɛ́ kpísi ɑɑ sɔ́nɛ? ");
INSERT INTO soy_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Uu pi pɛsɛ rɛ úu nkpɑ́ni u nyu. Úu mɛsei fe ukɛ́ u ceri. Yeesu yɛ pɛɛ pisoi riwúí tɛɛ kei ń we kɛ́mɛɛ lompɔlɛ uú nɛ tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Lɛ̃ mɛmɑ́ɑ́, Yeesu uu yisi uu Uléécɑɑ kɛyɔ sĩ u nɛ utisi uyɛɛ ḿ peí ɑpí hɑ sɑ́nɛ. Yeesu uu pɛɛ u mɑɑ rɛ: Kɑɑ nní ḿ peí, kɑpɛ kɔ ɑkópɛ piwɑi rikpɑ́sɛ, lɛ̃ lifee-fee ɑ́i kɑpɛ nɛ pɔ́ n wɑ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Utisi uyɛ̃ uu pɛɛ sĩ́ uú hɑ Pisuifi piwɛ́ɛ́sɛ símisi rɛ Yeesu yɛɛ u pɔisɛ. ");
INSERT INTO soy_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Lɛ̃ nnyɑ kɛ Pisuifi piwɛ́ɛ́sɛ ɑpi Yeesu pitele wɑ rɛ yo nnyɑ kuu kɛwéntɛyɑɑ tuŋɛ́ lɛ̃ wɑ. ");
INSERT INTO soy_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Kei kɛ Yeesu uu pi pɛsɛ rɛ: Unɛ́sɑ́ɑ Uléécɑɑ yɛ nɛ pikɛi kɛcɑ́ɑ́ welɛ nɛ́ɛn kɔ pikɛi kɛcɑ́ɑ́ we. ");
INSERT INTO soy_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Anɔ́ɔ nyɛ̃ nnyɑ, Pisuifi piwɛ́ɛ́sɛ ɑpi pɛɛ mɛyɑ̃́ piwɛ́lɑɑ nɛ ŋmɔ́ɔ́pú rɛ pikɛ́ Yeesu kpu. Ái rɛ kuu kɛwéntɛyɑɑ kɛcɑ́ɑ́ isé rinlɔ́ɔ́ ŋmɑnɛ nnyɑ, ɑmɑ́ kuu kɔ ḿ mɑɑ rɛ Uléécɑɑ yɛ uusɑɑ lɛ, lin pɛɛ nyísɛlɛ̃ tɛ u nɛ uyɛ̃ nɛ sɑ́lɛ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yeesu uu kɔ pimɑ́ɑ pi kpɑ́ rɛ: Asei kɑm nní nɔ́ símisi rɛ nɛ̃́ Uléécɑɑ Kɛpipi, ɑ́m nnɛ́nɑŋɛ cirɛ nɛ fenɛ kɛ́ linyinɛ wɑ. Lɛ̃ kɛ Unɛ́sɑ́ɑ Uléécɑɑ uu yɛ n wɑ ɑm yɛ́nu ŋmɑnɛ kɑm yɛ fe ɑm wɑi. Lɛ̃ nnɛ́í kɛ Unɛ́sɑ́ɑ uu n wɑi kɛ́ nɛ́ɛ kɔ wɑi. ");
INSERT INTO soy_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Sɑ́ɑ Uléécɑɑ yɛ Ukɛpipi lɑlɛ, uu pɛɛ lɛ̃ nnɛ́í kuu yɛ n wɑ kɛ nyísɛntɛ. U kɔ mɛwɑi mɛɛ mmɛ́ n fe pinyísɛ kɛ kpɑ́nɛ likɛ́ pɛɛ nnɔ́ɔ nɔ́ yi. ");
INSERT INTO soy_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Yɑrɛ kɛ Unɛ́sɑ́ɑ uu yɛ pikpɔkpɔ n yukusɛ uu nfɑ́ɑ pi hɛ mɛcɔ kɛ Ukɛpipi ɑkɛ yɛ kɛn píye n lɑ, ɑkɛ pɛ̃ nfɑ́ɑ hɛ. ");
INSERT INTO soy_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Limɛcɔ, Sɑ́ɑ Uléécɑɑ úu yɛ nɛ úkɑ túhɑɑnɛ. Amɑ́ Ukɛpipi kuu ńnɑŋɛ hɛ rɛ kɛkɛ́ nɛ pisoi nnɛ́í túhɑɑnɛ, ");
INSERT INTO soy_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","pisoi nnɛ́í pikɛ́ nɛ Uléécɑɑ Kɛpipi ríyu n wɑisɛ yɑrɛ kɑpi Uléécɑɑ ríyu n wɑisɛ mɛcɔ nnyɑ. Nkó yɛɛ úu Uléécɑɑ Kɛpipi ríyu n wɑisɛ, úu kɔ Uléécɑɑ yɛɛ kɛ n tummɛ ríyu wɑisɛ. ");
INSERT INTO soy_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Asei kɑm nní nɔ́ símisi rɛ nkó yɛɛ yɛ nnɛ́símɛ́ kutu rincɔ uú nɛ uyɛɛ nɛ́ n tummɛ kɛfɑ tɛnɛ yɛ nfɑ́ɑ tɛnɛcirɛ́ yɛ́nlɛ. Ápi nɛ mɛtúhɑɑnɛ u mɑ́. U nkpɔ kɛ́mɛɛ pilélɛ mɑsilɛ uu nfɑ́ɑ tɛnɛcirɛ́ yɛ́nu. ");
INSERT INTO soy_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Asei kɑm nní nɔ́ símisi rɛ kumúŋɛ́ kunyinɛ yɛ sɔ́ntilɛ, ticuruu ku pikɑ́mɛ mɑsilɛ. Pɛɛ́ uyɛ-i kɛ pikpɔkpɔ ɑpi yɛ́ Uléécɑɑ Kɛpipi mɛtẽ n kṍ. Pɛpɛɛ n kṍ ɑpi nfɑ́ɑ yɛnu. ");
INSERT INTO soy_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Uléécɑɑ yɛɛ nfɑ́ɑ te. Limɛcɔ kuu Ukɛpipi ńnɑŋɛ hɛ rɛ kɛkɛ́ nfɑ́ɑ n te. ");
INSERT INTO soy_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Nɛ Usoi Kɛpipi lɛ nnyɑ kuu ncée nɛ́ hɛ rɛ kɛ́ nɛ sisoipipi túhɑɑnɛ. ");
INSERT INTO soy_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ái kɑpɛ nkpɑ́ni pírí nɔ́ wɑ. Kumúŋɛ́ kunyinɛ yɛ sɔ́ntilɛ, pɛpɛɛ n kúlɑɑnkɛɛlɛ̃ pikɛ́ mɛnɛ́tẽ kõ, ");
INSERT INTO soy_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ɑpi pɛɛ nkpɔ kɛ́mɛɛ yisi. Pɛpɛɛ piisoi kɛ́mɛɛ lisɔnɛ n wɑ ɑpi nfɑ́ɑ tɛnɛcirɛ́ yɛ́nu. Api pɛpɛɛ piisoi kɛ́mɛɛ ɑkópɛ n wɑ pɔ̃́ nɛ túhɑɑnɛ ɑí nɛ pi kpi. ");
INSERT INTO soy_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ám yɛ́ fe kɛ́ nnɛ́nɑŋɛ cirɛ nɛ linyinɛ wɑ. Lɛ̃ kɛ Uléécɑɑ uu nɛ́ ń símisi kɑm yɛ nɛ ripɑí ɑḿ nɛ túhɑɑnɛ. Mɛnɛ́túhɑɑnɛ yɛ ɑsei mɑ́lɛ rɛ ɑ́m wɛ́ɛ́si kɛ́ mɛnɛ́lɑ wɑ nnyɑ, ɑmɑ́ uyɛɛ nɛ́ n tummɛ mɛkɔ́ kɑm wɛ́ɛ́si kɛ́ wɑ. ");
INSERT INTO soy_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Yeesu uu kɔ pimɑ́ɑ pi kpɑ́ rɛ: In tɛ nɛ̃́ ŋmɑnɛ nɛ́ɛ kɛnɛ́cɑ́ɑ́ ɑseérɑ lesɛ, nnɔ́ɔmɛ yɛ mu. ");
INSERT INTO soy_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Amɑ́ nɛ úseérɑkɔɔ́ mɑ́lɛ yɛɛ ɑseérɑ kɛnɛ́cɑ́ɑ́ n lésɛ. Nɛ kɔ nyulɛ rɛ ɑsei kuu símisi. ");
INSERT INTO soy_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Nɔ pisoi Yohɑni kɛ́mɛɛ tunlɛ rɛ pikɛ́ kɛnɛ́cɑ́ɑ́ nkɔ́ kṍ, uu kɔ ɑsei lesɛ uu símisi. ");
INSERT INTO soy_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nɛ̃́ ɑ́m písɛi rɛ unyinɛ ukɛ́ kɛnɛ́cɑ́ɑ́ ɑseérɑ lesɛ. Amɑ́ nɛ lɑ rɛ likɛ́ nɔ́rinɛ́yu lɔ nnyɑ kɑm Yohɑni ɑseérɑ kuu kɛnɛ́cɑ́ɑ́ n lésɛ símisi. ");
INSERT INTO soy_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohɑni pɔ̃́ nɛ we yɑrɛ kɛ́firɑ́ɑ kɑpi rinsɛ́, kɛmɛtɛ́í ɑmɛ nɔ́ kpɑ̃́ii. Lɛ̃ nnyɑ kɑni kɛmɛtɛ́í mɛ̃ nnyɑ ituŋɛ inyinɛ-i mpɔ́ɔnɑrɛ yɛ̃ nkɑ́ripi. ");
INSERT INTO soy_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Amɑ́ ɑseérɑ ŋmɑɑ yɛ kɛnɛ́cɑ́ɑ́ welɛ, ɑn Yohɑni ɑkɔ́ kuu kɛnɛ́cɑ́ɑ́ n lésɛ fe. Lɛlɛɛ nní pikɛi kɛ Unɛ́sɑ́ɑ uu nɛ́ n forii nɛn wɑi. Piricuruu ŋmɑɑ pɛɛ ɑseérɑ kɛnɛ́cɑ́ɑ́ lesɛ rɛ Sɑ́ɑ Uléécɑɑ yɛɛ nɛ́ tummɛ. ");
INSERT INTO soy_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Unɛ́sɑ́ɑ uyɛɛ nɛ́ n tummɛ yɛ uricuruu kɛnɛ́cɑ́ɑ́ ɑseérɑ lesɛlɛ. Áni kɛtumɛ umɛtẽ komɑɑlɛ̃, ɑni kɔ ukɛyu yɛnɑɑlɛ̃. ");
INSERT INTO soy_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Áni kɔ unsímɛ́ ńsɔnɛ múílɛ̃. Li we rɛ ɑ́ni nɛ̃́ kɛ Sɑ́ɑ Uléécɑɑ uu n tummɛ nɛ kɛfɑ tɛnɛlɛ̃. ");
INSERT INTO soy_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Nɔ yɛ Nléécɑɑsimɛ́ kɛ́mɛɛ pereilɛ nɔn músu rɛ nɔ́ nkɛmɛɛ nfɑ́ɑ tɛnɛcirɛ́ yɛ̃́. Ani kõ tɛ mmɛ̃ cirɛ mɛɛ kɛnɛ́cɑ́ɑ́ ɑseérɑ lesɛ. ");
INSERT INTO soy_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Áni kɔ pɛɛ́ lɑ nɔkɛ́ kɛnɛ́mɛɛ kɑm nɔkɛ́ nfɑ́ɑ mmɛ̃ yɛ̃. ");
INSERT INTO soy_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ái pisoi ipɑkɑrɛ kɑm wɛ́ɛ́si. ");
INSERT INTO soy_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Nɛ nɔ́ nyulɛ. Áni nɔ́sinɛ́fɑ-i Uléécɑɑ lɑ. ");
INSERT INTO soy_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Unɛ́sɑ́ɑ rinyiri kɑḿ nɛ kɑ, ɑmɑ́ ɑni piyɔ́ɔ́ nɛ́ yúlu. Amɑ́ unyinɛ un nté nɛ urinyiri n kɑ, nɔ́ uyɛ̃ yɔsí. ");
INSERT INTO soy_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Nɔ yɛ n lɑlɛ nɔkɛ́ nɔ́mɛnɛ́cɔpɛcirɛ m pɑkɑrɛntɛnɛ. Áni lɑ Uléécɑɑ ŋmɑnɛ ukɛ́ nɔ́ m pɑkɑrɛntɛ. Lɛ̃ nnyɑ kɑ́ni yɛ́ fe nɔkɛ́ nɛ kɛfɑ nɛ́ tɛnɛ. ");
INSERT INTO soy_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Áni kɑpɛ m músu rɛ nɛ́ɛ hɑ Unɛ́sɑ́ɑ Uléécɑɑ kɛ́mɛɛ tíyɛsɛnɛ nɔkɛ́ ɑkópɛ yɛ̃. Amɑ́ Moisi uyɛ̃ kɑní nɛ ripɔ́ɔ n lɑ́ɑ́rú yɛɛ hɑ tíyɛsɛnɛ nɔkɛ́ ɑkópɛ yɛ̃. ");
INSERT INTO soy_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kɛnɛ́cɑ́ɑ́ nsímɛ́ kɛ Moisi uu wɔ́i. Nɔn pɛɛ mɛyíkíyiki Moisi nsímɛ́ n ŋmurɛi, nɔ́ pɛɛ kɔ nnɛ́kɔ́ ŋmurɛi. ");
INSERT INTO soy_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Amɑ́ in tɛ ɑ́ni mmɛ̃ kɛ Moisi uu n wɔ́i ŋmurɛi, íye kɑni yɛ́ pɛɛ nnɛ́kɔ́ ŋmurɛi? ");
INSERT INTO soy_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Lɛ̃ mɛmɑ́ɑ́, Yeesu uu Kɑlilee kupiyɛ kɑpi yɛ kɔ n sée rɛ Tiperiyɑɑti mɛnimɑɑ tɛ́ŋ́ uu ritímɛ ricɔ-mɛ̃ sĩ. ");
INSERT INTO soy_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Pisoi kulúi píimɑ pinyinɛ yɛ pɛɛ u tikilɛnlɛ, kɑpi n yɛ̃́ tɛ u mɛwɑisɑŋɑ wɑpisi un pitóikɔ́ pɔisɛntɛ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Kei kɛ Yeesu uu pɛɛ riyɔ́pɛ ritɑɑ́ u nɛ upipirɛtiki ɑpí hɑ tonɛ. ");
INSERT INTO soy_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Pisuifi nkpɔ mɛlɔ́ɔ́ ɑnyɑ̃́ yɛ pɛɛ́ uyɛ-i nyɑhɑimɛlɛ. ");
INSERT INTO soy_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yeesu uú weríí uu yɛ́nu rɛ pisoi kulúi píimɑ yɛ ukɛmɛɛ sɔ́nɑɑpɔ, uu pɛɛ Filipu mɑɑ rɛ: Yei kɑri yɛ́ ilukɛ yɛɛ yɛ́ pisoi mpí nnɛ́í mɛlukɛ n tu lɔ? ");
INSERT INTO soy_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Sikɔ́rí kuú nɛ lɛ̃ mɑ ukɛ́ peẽ ukɛ́ yɛ̃́ tɛ íye kɛ Filipu uu yɛ́ u pɛsɛ. Uricuruu yɛ pɛɛ nyulɛ lɛ̃ kuu n wɑinɛ. ");
INSERT INTO soy_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipu uu u pɛsɛ rɛ: Ḿpɑ́ tɔkɛ́ nwóóweni mɛpipi pílɛ pílɛ mɛtɛ́ nɛ ilukɛ lɔ ɑ́i nkpɑ́ni ḿpɑ́ úye nkɑ́ripi nkɑ́ripi mɛlukɛ tulunɛ. ");
INSERT INTO soy_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Uupirɛtiki ucɔ, Simɔɔ Piyɛɛ uwɑ̃ kɑpi yɛ n sée rɛ Antiree pɔ́ɔ pɛɛ u mɑɑ rɛ: ");
INSERT INTO soy_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Kɛwɑ̃́ ŋmɑ́nɛpi kɛnyinɛ yɛ nkɛ́ nté kɛn ɑkpɔ́nɔ́ ɑnupũ nɛ ikpíntomɛ́ itɛ́ múílɛ̃. Yɑrɛ yo kɛ lɛ̃ ɑi yɛ́ nkpɑ́ni pisoi kulúi píimɑ nkú wɑ? ");
INSERT INTO soy_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Kei kɛ Yeesu uu pɛɛ rɛ: Ani pisoi pɛ̃ mɑɑ rɛ pikɛ́ tonɛ. Mɛyúi ɑ́mɛ pɛɛ kusɑ kɛlõ kɛ-i piyɛ. Api pɛɛ túnti, ɑí lelu pisoi ɑ́kotokú ɑnupũ kumúŋɛ́ (5.000). ");
INSERT INTO soy_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Kei kuu ɑkpɔ́nɔ́ kpísi uu ɑkɛcɑ́ɑ́ Uléécɑɑ pɔɔnɛsɛ uu pɛɛ pɛpɛɛ kei ń we ɑ hɔɔnɛ. Uu kɔ limɛcɔ ikpíntomɛ́ wɑi, ɑi pinnɛ́í mɛlukɛ tulu. ");
INSERT INTO soy_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Kɑpi pinnɛ́í ń li ɑpi lɛpu, Yeesu uu pɛɛ upipirɛtiki mɑɑ rɛ: Ani ɑkéri tɔrɔɔ kɔ́ɔ́i, líkɑ ɑ́i kɑpɛ pɔ. ");
INSERT INTO soy_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Api ɑkpɔ́nɔ́ ɑnupũ nyɛ̃ kɑpi n li ɑtɔrɔɔ kɔ́ɔ́i ɑi ɑnɛ́rɛ kɛfi nɛ ɑtɛ́ yipu. ");
INSERT INTO soy_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Kɛ pisoi pɛ̃ ɑpi mɛwɑisɑŋɑ kɛ Yeesu uu n wɑpisi n yɛ̃́, ɑpi pɛɛ́ n símɑɑnkɛɛ rɛ: Mɛsei, usoi nkó yɛɛ ɑntepu kɑpi n tee rɛ u kɛtẽ kɛcɑ́ɑ́ sɔ́nti. ");
INSERT INTO soy_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yeesu pɔ́ɔ céru rɛ pi sɔ́ntilɛ pikɛ́ u tĩ pikɛ́ ńnɑŋɛ iyɔ́ɔpi u tonsɛ. Uu lɛ̃ nnyɑ riyɔ́pɛ pítɑɑ́ pɛlɛ uú hɑ umɛcirɛ n tũ. ");
INSERT INTO soy_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Kɑi nnyɔ́ɔ́ n wɑ, Yeesu pipirɛtiki ɑpi cɛ́pi ɑpí hɑ kupiyɛ ritimɛ n we. ");
INSERT INTO soy_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Api kúninɔi loni ɑpi kupiyɛ n tɛ́ŋ́lɛ̃ pin Kɑpɛrinɑwum kuwɛ́ɛ́-mɛ̃ sĩ. Kɛsinɛ yɛ pɛɛ likumúŋɛ́ kpɛ-i piwɑi mɑsilɛ, Yeesu úu kɔ pɛɛ kɑhɑnɛ pikɛkúrí n hɑpɔ. ");
INSERT INTO soy_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Kei kɛ mɛyɔ píimɑ mɛnyinɛ ɑmɛ pipépɛ lõ, míni ɑmɛ pɛɛ́ n tɔɔnkɛɛ. ");
INSERT INTO soy_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Kɑpi kúninɔi rintíkíí yɑrɛ kilomɛtiri pinupũ kumúŋɛ́, ɑpi Yeesu yɛnu un míni kɛcɑ́ɑ́ sɔ́nɛ un nɛ pikɛkúrí wépɔ, iwɑmɛ ii pi wɑi. ");
INSERT INTO soy_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Kei kɛ Yeesu uu pɛɛ pi mɑɑ rɛ: Nɛ́ɛ lo, iwɑmɛ íi kɑpɛ nɔ́ wɑ! ");
INSERT INTO soy_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Api pɛɛ́ n lɑ pikɛ́ kúninɔi kɛ́mɛɛ u kpísi. Amɑ́ kúninɔi ɑku kei nní mɛsɛ nɛ mɛsɛ kei kɑpi n sĩ́ tulu. ");
INSERT INTO soy_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Kɑi kóso n weesi, pisoi riwúí tɛɛ kupiyɛ ritimɛ tɛ-i m mɛ́sũ ɑri yɛ́nu rɛ kúninɔi kusɛ kpɛɛ yɛ kei n we, Yeesu úu kɔ ku lõ u nɛ upipirɛtiki pikɛ́ nɛ kɛsẽ́ tɔ́mpɔ. Upipirɛtiki ŋmɑnɛ pɛɛ pɛɛ tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Amɑ́ ɑ́ninɔi ɑcɔ yɛ pɛɛ Tiperiyɑɑti kɛtẽ-mɛ̃ leemɛlɛ ɑɑ kei kɛ Upíimɑ uú pɛɛ ɑkpɔ́nɔ́ kɛcɑ́ɑ́ Uléécɑɑ m pɔɔnɛsɛ ɑpi pɛɛ ɑ le tuipɔ. ");
INSERT INTO soy_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Kɛ pisoi riwúí tɛ̃ ɑri n yɛ̃́ tɛ Yeesu nɛ upipirɛtiki ɑ́pi kei we, ɑpi pɛɛ piricuruu ɑ́ninɔi nyɛ̃ loni ɑpí nɛ Kɑpɛrinɑwum-pɔ Yeesu piwɛ́lɑɑ sĩ. ");
INSERT INTO soy_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Api kupiyɛ ritimɛ ricɔ-mɛmpɔ Yeesu lɛɛpɔ ɑpi u pisɛ rɛ: Píyei kɑɑ nté tuimɛ, Ucélɑɑ? ");
INSERT INTO soy_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yeesu uu pi pɛsɛ rɛ: Asei kɛcɑ́ɑ́, kɛ́ nɔ́ símisi rɛ ɑ́i rɛ kɑni mɛwɑisɑŋɑ kɑm n wɑpisi n yɛ̃́ nnyɑ kɑni nɛ́ wɛ́ɛ́si, ɑmɑ́ kɑni ɑkpɔ́nɔ́ ń li ɑni lɛpu nnyɑ kɑni nɛ́ wɛ́ɛ́si. ");
INSERT INTO soy_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Áni kɑpɛ ilukɛ yɛɛ yɛ n fɔ́ni nnyɑ n nɑ́ɑ́si, ɑmɑ́ ɑni ilukɛ yɛɛ íi yɛ píkɑi n fɔ́ni ii yɛ kɔ pɛɛ nfɑ́ɑ tɛnɛcirɛ́ hɛ nnyɑ n nɑ́ɑ́si. Usoi Kɛpipi kɛɛ yɛ́ ilukɛ iyɛ̃ nɔ́ hɛ, li we rɛ Sɑ́ɑ Uléécɑɑ yɛ unwɔi ukɛcɑ́ɑ́ wɑlɛ. ");
INSERT INTO soy_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Api u pisɛ rɛ: Íye kɑri yɛ́ wɑ tɔkɛ́ nɛ pikɛi pɛ̃ kɛ Uléécɑɑ uu ń lɑ piwɑi n fe? ");
INSERT INTO soy_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yeesu uu pi pɛsɛ rɛ: Uléécɑɑ pikɛi kuu nɔ́ m pisɛ yɛ mpí rɛ ɑni nɛ uyɛ̃ kuu n tummɛ kɛfɑ tɛnɛ. ");
INSERT INTO soy_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Api u mɑɑ rɛ: Mɛwɑisɑŋɑ mɛ́ye kɑɑ yɛ́ wɑ tɔkɛ́ yɛ̃́ tɔkɛ́ pɛɛ́ nɛ kɛfɑ pɔ́ tɛnɛ? Mɛwɑi mɛ́ye kɑɑ wɑinɛ? ");
INSERT INTO soy_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Pirɔ́sɑ́ɑyɑhɑ yɛ iléécɑɑlukɛ kucɛsi kóimɑ-i lilɛ yɑrɛ kɑi Nléécɑɑsimɛ́ kɛ́mɛɛ n wɔ́lɑɑlɛ̃ tɛ: Ilukɛ yɛɛ kɛyómɛcɑɑ-pɔ n léeri kuu pi hɛ rɛ pikɛ́ li. ");
INSERT INTO soy_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yeesu uu pi pɛsɛ rɛ: Asei kɛcɑ́ɑ́, kɛ́ nɔ́ símisi ɑni kóm tɛ ɑ́i Moisi yɛɛ iléécɑɑlukɛ nɔ́ hɛ, ɑmɑ́ Unɛ́sɑ́ɑ yɛɛ ilukɛ yɛɛ mɛyíkíyiki kɛyómɛcɑɑ-pɔ n léeri nɔ́ hɛ. ");
INSERT INTO soy_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ilukɛ kɛ Uléécɑɑ uu yɛ n hɛ yɛɛ nní uyɛɛ kɛyómɛcɑɑ-pɔ n léeri uu yɛ pisoi nfɑ́ɑ hɛ. ");
INSERT INTO soy_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Api u mɑɑ rɛ: Upíimɑ, ɑ mɛsɛ́rɛ ilukɛ iyɛ̃ tɔ́ n hɛ. ");
INSERT INTO soy_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Kei kɛ Yeesu uu pɛɛ pi símisi rɛ: Nɛ́ɛ nní lɛ̃ ilukɛ iyɛɛ yɛ nfɑ́ɑ n hɛ. Nkṹ ńn píkɑi nkó yɛɛ kɛnɛ́mɛɛ ń kɑ wɑinɛ. Nnírɛ́ ńn kɔ píkɑi nkó yɛɛ nɛ kɛfɑ nɛ́ n tɛnɛ wɑinɛ. ");
INSERT INTO soy_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Amɑ́ nɛ nɔ́ símisilɛ: Nɔ nɛ́ yɛ́nlɛ, ḿpɑ́ nɛ lɛ̃, ɑ́ni nɛ kɛfɑ tɛnɛ. ");
INSERT INTO soy_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Pɛ̃ nnɛ́í kɛ Unɛ́sɑ́ɑ uu nɛ́ m pɑ yɛ kɛnɛ́mɛɛ sɔ́ntilɛ, ɑ́m pikɛcɔpɛ úkɑ mpuri mɛ́yulɛ mɑ́. ");
INSERT INTO soy_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Li we rɛ ɑ́m kɛyómɛcɑɑ-pɔ súimɛ rɛ kɛ́ mɛnɛ́lɑ wɑ, ɑmɑ́ uyɛɛ nɛ́ n tummɛ mɛlɑ kɑm piwɑi kɑ. ");
INSERT INTO soy_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Uyɛɛ nɛ́ n tummɛ mɛlɑ yɛ kɔ pɛɛ mmɛ́ rɛ ɑ́m kɑpɛ pɛ̃ kuu nɛ́ m pɑ kɛcɔpɛ úkɑ fóm, ɑmɑ́ u lɑ rɛ kɛ́ hɑ kɛyɑ́ɑ tɔrɔɔ kɛtúŋɛ́ nkpɔ kɛ́mɛɛ pi yukusɛ. ");
INSERT INTO soy_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Unɛ́sɑ́ɑ yɛ lɑ rɛ nkó yɛɛ Ukɛpipi n yɛ̃́ uú nɛ kɛfɑ kɛ tɛnɛ ukɛ́ nfɑ́ɑ tɛnɛcirɛ́ m mɑ́. Nɛ kɔ pɛɛ liute kɛyɑ́ɑ tɔrɔɔ kɛtúŋɛ́ nkpɔ kɛ́mɛɛ yukusɛnɛ. ");
INSERT INTO soy_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Pisuifi ɑpi Yeesu nɛ ŋmúlɑɑnkɛɛ rɛ u mɑɑ rɛ: Nɛ́ɛ nní lɛ̃ ilukɛ iyɛɛ kɛyómɛcɑɑ-pɔ n léeri nnyɑ. ");
INSERT INTO soy_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Api pɛɛ́ m písɛinɛ rɛ: Ái Yosɛfi uŋmɑ́nɛ Yeesuu? Tɔ usɑ́ɑ nɛ úni nyulɛ. Íye kuu yɛ́ pɛɛ́ mɑɑ rɛ: Kɛyómɛcɑɑ-pɔ kuu léeri? ");
INSERT INTO soy_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Kei kɛ Yeesu uu pɛɛ pi mɑɑ rɛ: Ani lɛ̃ nɔ́mɛnɛ́cɔpɛcirɛ piŋmúlɑɑnkɛɛ tíyɛ. ");
INSERT INTO soy_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Úkɑ úu yɛ́ fe ukɛ́ kɛnɛ́mɛɛ kɑm, insɑ́ Sɑ́ɑ yɛɛ nɛ́ n tummɛ yɛɛ nɛ kɛnɛ́mɛɛ u kɑ. Nɛ́ kɔ ḿpɑ́ úye yɛɛ kɛnɛ́mɛɛ ń kɑ kɛyɑ́ɑ tɔrɔɔ kɛtúŋɛ́ nkpɔ kɛ́mɛɛ yukusɛ. ");
INSERT INTO soy_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Li ɑntepuyɛ ɑtɛlɛ́-i wɔ́lɑɑlɛ̃ tɛ: Uléécɑɑ yɛ́ pinnɛ́í céési. Nkó yɛɛ Sɑ́ɑ kutu rińcɔ uu uicélɑɑ kom, yɛɛ yɛ́ kɛnɛ́mɛɛ kɑm. ");
INSERT INTO soy_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Lɛ̃ ɑ́i nyísɛ rɛ unyinɛ yɛ Sɑ́ɑ yɛnɑɑlɛ̃. Amɑ́ uyɛɛ Uléécɑɑ kɛ́mɛɛ n léeri mɛcirɛ yɛɛ u yɛnɑɑlɛ̃. ");
INSERT INTO soy_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Asei kɛcɑ́ɑ́, kɛ́ nɔ́ símisi ɑni kóm tɛ nkó yɛɛ nɛ kɛfɑ nɛ́ n tɛnɛ yɛ nfɑ́ɑ tɛnɛcirɛ́ mɑ́lɛ. ");
INSERT INTO soy_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nɛ́ɛ ilukɛ iyɛɛ yɛ nfɑ́ɑ n hɛ. ");
INSERT INTO soy_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nɔ́pinɛ́sɑ́ɑyɑhɑ yɛ pɛɛ kucɛsi kóimɑ-i mɑɑni lilɛ, ḿpɑ́ nɛ lɛ̃, ɑpi kɔ pɛɛ kpíni. ");
INSERT INTO soy_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ilukɛ iyɛɛ kɛyómɛcɑɑ-pɔ n léeri yɛ nnyí nté. Nkó yɛɛ i n li úu píkɑi kpinɛ. ");
INSERT INTO soy_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nɛ́ɛ ilukɛ iyɛɛ kɛyómɛcɑɑ-pɔ n léemɛ ii yɛ pisoi nfɑ́ɑ hɛ. Ḿpɑ́ úye yɛɛ ilukɛ iyɛ̃ li, nfɑ́ɑ tɛnɛcirɛ́ kuu yɛ́ yɛ̃́. Inɛ́piŋɛ yɛɛ ilukɛ iyɛ̃ kɑm u n hɛnɛ. Nɛ i hɛlɛ rɛ kɛtẽ nnɛ́í pisoi pikɛ́ nfɑ́ɑ yɛ̃ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Kuu lɛ̃ ḿ mɑ, Pisuifi ɑpi picɛ́ŋɑɑnkɛɛ loni pin pimɛcɔpɛcirɛ písɛinɛ rɛ: Íye nnyɑ kɛ nkó uu yɛ́ mɑɑ rɛ u yɛ́ uipiŋɛ rɔ́ hɛ ɑri le? ");
INSERT INTO soy_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Kei kɛ Yeesu uu pɛɛ pi mɑɑ rɛ: Asei kɛcɑ́ɑ́, kɛ́ nɔ́ símisi ɑni kóm tɛ nɔnsɑ́ Usoi Kɛpipi ipiŋɛ n li, nɔnsɑ́ kɔ kɛmɛnyɛ n ntí, ɑ́ni nfɑ́ɑ mɑ́. ");
INSERT INTO soy_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Usoi nkó yɛɛ inɛ́piŋɛ n li uu kɔ mɛnɛ́nyɛ níru yɛ nfɑ́ɑ tɛnɛcirɛ́ yɛ́nlɛ. Nɛ hɑ kɛyɑ́ɑ tɔrɔɔ kɛtúŋɛ́ nkpɔ kɛ́mɛɛ u yukusɛnɛ. ");
INSERT INTO soy_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Li we rɛ inɛ́piŋɛ yɛ ilukɛ yíkíyiki lɛ, mɛnɛ́nyɛ pɔ́ɔn kɔ linírɛ́-nirɛ́ yíkíyiki. ");
INSERT INTO soy_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Usoi nkó yɛɛ inɛ́piŋɛ n li uu kɔ mɛnɛ́nyɛ níru yɛ kɛnɛ́mɛɛ welɛ nɛ́ɛn kɔ ukɛmɛɛ we. ");
INSERT INTO soy_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Sɑ́ɑ yɛɛ nɛ́ n tummɛ yɛɛ nfɑ́ɑ ute. Uyɛ̃ nnyɑ kɑm nfɑ́ɑ mɑ́. Limɛcɔ, úye un inɛ́piŋɛ n li, u nɛ̃́ nnyɑ nfɑ́ɑ yɛnunɛ. ");
INSERT INTO soy_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ilukɛ iyɛɛ kɛyómɛcɑɑ-pɔ n léeri yɛ iyɛ̃. Íi iyɛ̃ kɛ nɔ́pinɛ́sɑ́ɑyɑhɑ ɑpí pɛɛ n li, ḿpɑ́ nɛ lɛ̃, ɑpi kɔ pɛɛ kpíni mɛcɔ we. Amɑ́ nkó yɛɛ nnyí n li yɛ mɛsɛ́rɛ nfɑ́ɑ mɑ́nɛ. ");
INSERT INTO soy_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Kumúŋɛ́ kpɛ-i kɛ Yeesu uú pɛɛ Kɑpɛrinɑwum-pɔ Pisuifi kuyomɛyɑ́hɑɑlee-i pisoi n céési kuu ɑnɔ́ɔ nyɛ̃ mɑ. ");
INSERT INTO soy_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Kɛ upipirɛtiki ɑpi ɑnɔ́ɔ nyɛ̃ n kṍ, pimɛyɑ̃ ɑpi rɛ: Nsímɛ́ mmú yɛ ḿpɑpɛ tɔsilɛ. Wóo yɛ́ mmú kutu n cɔlɛ̃? ");
INSERT INTO soy_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yeesu uu céru rɛ upipirɛtiki yɛ nsímɛ́ mmɛ̃ kɛcɑ́ɑ́ ŋmúlɑɑkɛɛlɛ. Uu pɛɛ pi mɑɑ rɛ: Li nɔ́ ricɔ́ŋlɛ mɛyɑ̃́, nɛ́ɛ yo? ");
INSERT INTO soy_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","In lɛ̃, nɔn píye Usoi Kɛpipi n yɛ̃ kɛn kei kɑkɛ́ pɛɛ ń we pítɑɑ́ m pɛlɛ ní, íye kɑi yɛ́ pɛɛ nɔ́ wɑ? ");
INSERT INTO soy_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Uléécɑɑ Nfɑɑsɔnɛ mɛɛ yɛ nfɑ́ɑ hɛ. Kɛsoipipi ɑ́kɛ yɛ́ líkɑ fe. Amɑ́ ɑnɔ́ɔ nnyɛ́ kɑm nní nɔ́ ḿ mɑ yɛ Nfɑ́ɑsɔnɛ ɑkɔ́ lɛ nyɛɛ yɛ nfɑ́ɑ n hɛ. ");
INSERT INTO soy_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Amɑ́ pinyinɛ ɑ́pi nɔ́kɛnɛ́cɔpɛ nɛ kɛfɑ nɛ́ tɛnɛ. Ái líkɑ nnyɑ kuu lɛ̃ mɑlɛ. U hɑ́i mɛkɛɛ-mɛ pɛpɛɛ ɑ́pi n ŋmurɛinɛ nɛ uyɛɛ n sɔ́nti ukɛ́ pilɑ́ɑrɔ ɑnipɛ-i u n wɑ nyulɛ. ");
INSERT INTO soy_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Uu kɔ pimɑ́ɑ pi kpɑ́ rɛ: Lɛ̃ nnyɑ kɑm nɔ́ mɑɑ rɛ úkɑ úu we yɛɛ yɛ́ n fe uu kɛnɛ́mɛɛ weri insɑ́ Unɛ́sɑ́ɑ yɛɛ ncée u hɛ. ");
INSERT INTO soy_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kɑí nɛ kei n kpísi, upipirɛtiki mɛyɑ̃ ɑpi kɛpirɛ u tɔ ɑ́pi yɛ pɛɛ pitíki u rikpɑ́. ");
INSERT INTO soy_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Uu pɛɛ upipirɛtiki kɛfi nɛ pitɛ́ pɛ̃ pisɛ rɛ: Nɔ̃́ ní, nɔ̃́ ɑ́ni lɑ nɔkɛ́ tɔ́mpɔɔ? ");
INSERT INTO soy_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simɔɔ Piyɛɛ uu u pɛsɛ rɛ: Upíimɑ, úye ucɔ kɛ́mɛɛ kɑri yɛ́ nkpɑ́ni hɑ? Kɛpɔ́mɛɛ́ kɛ nsímɛ́ mɛɛ yɛ nfɑ́ɑ tɛnɛcirɛ́ n hɛ nń we. ");
INSERT INTO soy_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Tɔ nɛ kɛfɑ pɔ́ tɛnɛlɛ ɑri yɛ́nu rɛ pɔ̃́ kɛ Uléécɑɑ uu wɛ́ɛ uu tumti. ");
INSERT INTO soy_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yeesu uu pɛɛ pi mɑɑ rɛ: Ái nɛ́ɛ nɔ́ kɛfi nɛ pitɛ́ mpí wɛ́ɛɛ? Ḿpɑ́ nɛ lɛ̃, usɛ yɛ nɔ́kɛnɛ́cɔpɛ kuníri lɛ! ");
INSERT INTO soy_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Simɔɔ Isikɑriyɔɔti uŋmɑ́nɛ Yutɑsi nsímɛ́ kuu lɛ̃ símisi. U kɛfi nɛ pitɛ́ pɛ̃ usɛ lɛ. Ḿpɑ́ nɛ lɛ̃, uyɛɛ sɔ́nti ukɛ́ pilɑ́ɑrɔ ɑnipɛ-i u wɑ. ");
INSERT INTO soy_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Lɛ̃ mɛmɑ́ɑ́, Yeesu uu Kɑlilee kɛtẽ kɔ́ɔ́nú. Úu pɛɛ́ hɑ ukɛ́ Yutee kɛkɔ́ rikɔ́ɔ́nú rɛ Pisuifi piwɛ́ɛ́sɛ yɛ wɛ́ɛ́si pikɛ́ u kpu nnyɑ. ");
INSERT INTO soy_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Pisuifi ɑnyɑ̃́ nyɛ̃ kɛ́mɛɛ kɑpi yɛ sicɑ́ŋíípi kɛ́mɛɛ n sói yɛ kɔ pɛɛ nyɑhɑimɛlɛ. ");
INSERT INTO soy_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Upimɑrɛcɔ ɑpi pɛɛ u mɑɑ rɛ: A nté yisi ɑɑ Yutee kɛtẽ-pɔ sĩ, pipɔ́pirɛtiki pɔ́ɔkɛ́ kɔ pikɛi kɑɑ n wɑi yɛ̃! ");
INSERT INTO soy_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Úkɑ úu yɛ umɛwɑi m pékesi un kɔ pɛɛ́ lɑ kuyu kukɛ́ u ceri. Lɛ̃ nnyɑ, ɑ tíyɛ kɛtẽ nnɛ́í pisoi pikɛ́ mɛpɔ́wɑi mmɛ́ yɛ̃́. ");
INSERT INTO soy_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Asei kɛcɑ́ɑ́, upimɑrɛcɔ ricuruu pɑ́ɑ pɛɛ kɔ nɛ kɛfɑ u tɛnɛlɛ̃. ");
INSERT INTO soy_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Kei kɛ Yeesu uu pɛɛ pi mɑɑ rɛ: Inɛ́tuŋɛ íi kɑhɑnɛ n tu. Amɑ́ in nɔ́ɔ, ḿpɑ́ ituŋɛ íye yɛ nɛ nɔ́ sɑ́lɛ. ");
INSERT INTO soy_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Kɛtẽ nté pisoi ɑ́pi nɔ́inɛ́puri yulu, ɑmɑ́ pi nɛ̃́ ipuri yululɛ rɛ nɛ we nɛn pi símisi rɛ pimɛwɑi ɑ́mɛ nyɑḿ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Nɔ́ɔkɛ́ n ŋme ɑni hɑ ɑnyɑ̃́ li. Nɛ̃́ ɑ́m kei simpɔ kɛlenɛ. Inɛ́tuŋɛ íi kɑhɑnɛ n tu. ");
INSERT INTO soy_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Kuu lɛ̃ pisímɛ́ pi ḿ mɑsí, uu Kɑlilee kɛteni-i mɛ́suni. ");
INSERT INTO soy_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Kɛ Yeesu pimɑrɛcɔ ɑpi ɑnyɑ̃́ nyɛ̃ ń hɑ, uricuruu pɔ́ɔ kɔ yisi uu sĩ́, úu tíyɛ pikɛ́ u n nyɑ́ni, uu pɛɛ n we yɑrɛ u pékesilɛ. ");
INSERT INTO soy_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Pisuifi piwɛ́ɛ́sɛ yɛ pɛɛ ɑnyɑ̃́ nyɛ-i u wɛ́lɑɑnkɛɛlɛ ɑpi yɛ pɛɛ rɛ: Yei kuú we? ");
INSERT INTO soy_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Pisoi pɛɛ n cɑ́pinɛlɛ̃ yɛ pɛɛ unsímɛ́ ŋmúlɑɑnkɛɛnɛlɛ. Pinyinɛ ɑpi yɛ rɛ: Usoi sɔnɛ lo. Picɔ ɑpi rɛ: Eehei, pisoi kuu kírɑɑsɛntɛ. ");
INSERT INTO soy_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Amɑ́ úkɑ úu pɛɛ unsímɛ́ símisi likɛ́ n cɑ́lɛ̃. Pisuifi piwɛ́ɛ́sɛ kɑpí pɛɛ lɛ̃ wuru. ");
INSERT INTO soy_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Anyɑ̃́ siyɑɑ sin kɛcɔpɛ pitulɛ mɑsí kɛ Yeesu uu Uléécɑɑ kɛyɔ hɑ uú hɑ n céési. ");
INSERT INTO soy_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ai Pisuifi pírí wɑi ɑpi yɛ pɛɛ rɛ: Usoi nkó úu icélɑɑ íkɑ yɔsí, íye kɑi pɛɛ wɑ kuú nɛ nní ńsɔnɛ Nléécɑɑsimɛ́ nyu? ");
INSERT INTO soy_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yeesu uu pi pɛsɛ rɛ: Icélɑɑ nnyí kɑm nní pisoi m pɑ́lɛ̃ íi kɛnɛ́mɛɛ léeri, ɑmɑ́ Uléécɑɑ yɛɛ nɛ́ n tummɛ kɛ́mɛɛ kii léeri. ");
INSERT INTO soy_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Úye un n lɑ ukɛ́ Uléécɑɑ mɛlɑ wɑ, u yɛ́ céri rɛ Uléécɑɑ kɛ́mɛɛ kɛ icélɑɑ nnyí ii léeri nɛ́ɛ nnɛ́nɔ́ɔsimɛ́ cirɛ yɛ mu. ");
INSERT INTO soy_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Nkó yɛɛ unnɔɔsimɛ́ cirɛ n símisi yɛ lɑlɛ pikɛ́ ríyu u wɑisɛ. Amɑ́ nkó yɛɛ ń lɑ pikɛ́ uyɛɛ u n tummɛ ríyu wɑisɛ yɛ ɑsei mɑ́lɛ. Nnɔ́ɔmɛ ńkɑ ńn ukɛmɛɛ́ we. ");
INSERT INTO soy_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ńté Moisi yɛ isé nɔ́ pɑ mɑ́? Nɔ́ úkɑ úu kɔ pɛɛ isé iyɛ̃ tikilɛ̃. Yo nnyɑ kɑni pɛɛ́ lɑ nɔkɛ́ nɛ́ kpu? ");
INSERT INTO soy_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Pisoi pɛɛ n cɑ́pinɛlɛ̃ ɑpi u pɛsɛ rɛ: Pɔ kuníri héesilɛ. Wóo lɑ ukɛ́ pɔ́ kpu? ");
INSERT INTO soy_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yeesu uu pi pɛsɛ rɛ: Mɛwɑi mɛsɛ kɑm wɑ ɑi nɔ́nnɛ́nɛ́í pírí wɑi. ");
INSERT INTO soy_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moisi yɛɛ isé nɔ́ pɑ rɛ ɑni yɛ siwɑ́ntisi kérii, ɑ́i kɔ pɛɛ uyɛɛ nɛ li kori, hɑ́i nɔ́pinɛ́kpurɛ foí-mɛ kɑi léeri. Ani kɔ ŋmurɛi, hɑ́i ricuruu ɑni yɛ kɛwéntɛyɑɑ tuŋɛ́ usoi ké. ");
INSERT INTO soy_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","In tɛ nɔ yɛ ŋmurɛi ɑni kɛwéntɛyɑɑ tuŋɛ́ kɛwɑ́ntisi ké, ɑ́i kɔ pɛɛ Moisi isé kɑni rilɔ́ɔ́, yo nnyɑ kɑni pɛɛ́ nɛ nɛ́ wɔ́lɑɑlɛ̃ tɛ nɛ kɛsoipipi nɛ kɛriyu kɛwéntɛyɑɑ tuŋɛ́ pɔisɛ? ");
INSERT INTO soy_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Áni kɑpɛ yɛ usoi kɛyu ripɑí ɑní nɛ u túhɑɑnɛ, ɑmɑ́ ɑni yɛ ɑsei kɛmúŋɛ́ ritiki ɑní nɛ túhɑɑnɛ. ");
INSERT INTO soy_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Yerusɑlɛm pikɔ́ pinyinɛ ɑpi rɛ: Ái utisi nkó kɑpi wɛ́ɛ́si pikɛ́ kpuu? ");
INSERT INTO soy_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Uyɛɛ nkó un nɛ uripɔɔ símisi lin cɑ́lɛ̃, úkɑ úu kɔ ríkɑ u mɑ! Yɑrɛ pirɔ́yɔ́ɔpi yɛ cerilɛ rɛ mɛsei uyɛ̃ kɛ Uléécɑɑ uu n wɛ́ɛ nɛ́ɛ? ");
INSERT INTO soy_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Tɔ nkó pɔ̃́ kɛleemɛ nyulɛ. Amɑ́ uyɛ̃ kɛ Uléécɑɑ uu n wɛ́ɛ un píyei n kɑ, úkɑ úu yɛ́ céri mɛ́ye kuu léeri. ");
INSERT INTO soy_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yeesu yɛ pɛɛ Uléécɑɑ kɛyɔ-i welɛ un likumúŋɛ́ kpɛ-i céési. Uu pupɛi rɛ: Mɛsei kɑni nɛ́ nyu nɔn kɔ kɛnɛ́leemɛ nyu, nɛ́ɛ yo? Ḿpɑ́ nɛ lɛ̃, ɑ́i mɛnɛ́lɑ kɛcɑ́ɑ́ kɑḿ nɛ kɑ. Amɑ́ uyɛɛ nɛ́ n tummɛ yɛ ɑsei mɑ́lɛ. Áni uyɛ̃ nyu. ");
INSERT INTO soy_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nɛ̃́ nɛ u nyulɛ. Ukɛmɛɛ́ kɑm léeri. Uyɛɛ nɛ́ tummɛ. ");
INSERT INTO soy_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Kɛ Yeesu uu lɛ̃ ḿ mɑ nnyɑ, ɑpi pɛɛ́ n lɑ pikɛ́ u tĩ. Amɑ́ úkɑ úu kɑhɑ ukɛ́ u ricɑ, kɛ uituŋɛ íi pɛɛ kɑhɑnɛ nní n tu nnyɑ. ");
INSERT INTO soy_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Pisoi mɛyɑ̃ ɑpi riwúí tɛ̃ kɛcɔpɛ nɛ kɛfɑ u tɛnɛ ɑpí mɑɑ rɛ: Uyɛ̃ kɛ Uléécɑɑ uu n wɛ́ɛ un píyei n kɑ, yɑrɛ u yɛ́ mɛwɑisɑŋɑ wɑpisi ɑi tɔ́su lɛ̃ kɛ utisi nkó uu nní n wɑpisii? ");
INSERT INTO soy_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Pifɑrisi ɑpi lɛ̃ kɛ pisoi ɑpi riwúí kɛ́mɛɛ Yeesu kɛcɑ́ɑ́ ń wɛirɛsɛntɛnɛ kom. Pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ nɛ Pifɑrisi ɑpi pɛɛ Uléécɑɑ kɛyɔ pimɛ́rɛ́ pinyinɛ tum tɛ pikɛ́ hɑ Yeesu tĩ. ");
INSERT INTO soy_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yeesu uu pɛɛ rɛ: Nkɑ́ripi kɛ tɔ́ nɛ nnɔ̃́ ɑri kɛtónɛ kpɑ́nɛ ɑm pɛɛ limɛmɑ́ɑ́ uyɛɛ nɛ́ n tummɛ kɛ́mɛɛ pɛlɛ. ");
INSERT INTO soy_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Nɔ́ kɑm ɑni nɛ́ wɛ́ɛ́si, ɑmɑ́ ɑ́ni yɛ́ pɛɛ nɛ́ yɛ̃́. Li we rɛ ɑ́ni yɛ́ fe nɔkɛ́ kei kɑm yɛ́ hɑ ń we hɑ. ");
INSERT INTO soy_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Pisuifi ɑpi pɛɛ pimɛcɔpɛcirɛ m písɛinɛ rɛ: Yei kuu sĩ́ kɑ́ri yɛ́ fe tɔkɛ́ u yɛ̃? Nɛ́ɛ Pisuifi pɛɛ Pikirɛki kɛtẽ kɛcɑ́ɑ́ n yɛkɑɑlɛ̃ kɛ́mɛɛ kuu sĩ́ ukɛ́ hɑ Pikirɛki n céési? ");
INSERT INTO soy_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Tɛ íye kuu nní mɑɑ rɛ: Nɔ́ kɑm ɑni nɛ́ wɛ́ɛ́si, ɑmɑ́ ɑ́ni yɛ́ pɛɛ nɛ́ yɛ̃́. Li we rɛ ɑ́ni yɛ́ fe nɔkɛ́ kei kɑm yɛ́ hɑ ń we hɑpɔ? ");
INSERT INTO soy_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Anyɑ̃́ kɛyɑɑ tɔrɔɔ kɛɛ sinnɛ́í kɛcɔpɛ kɛyɑ́ɑ píimɑ. Kɛ̃ kɛ Yeesu uu pisoi kɛyu-i nyɛrɛ uu pupɛi rɛ: Nnírɛ́ nn úye n we, ukɛ́ kɛnɛ́mɛɛ kɑm ukɛ́ míni n ntí. ");
INSERT INTO soy_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Míni mɛɛ yɛ nfɑ́ɑ n hɛ yɛ́ nkó yɛɛ nɛ kɛfɑ nɛ́ n tɛnɛ kɛ́mɛɛ n leerilɛ mɛn wɔ́lu yɑrɛ ńnihɔi, yɑrɛ kɑi Nléécɑɑsimɛ́ ritɛlɛ́ kɛ́mɛɛ n wɔ́lɑɑlɛ̃ mɛcɔ. ");
INSERT INTO soy_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Uléécɑɑ Nfɑɑsɔnɛ kɛ pɛpɛɛ nɛ kɛfɑ u n tɛnɛ ɑpi yɛ́ ń yɔsí nkɔ́ kɛ Yeesu uu lɛ̃ símisi. Ápi pɛɛ kɑhɑnɛ likumúŋɛ́ kpɛ-i Nfɑ́ɑsɔnɛ n yɔsí, kɛ Uléécɑɑ úu pɛɛ kɑhɑnɛ Yeesu ríyu n wɑisɛ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Kɛ pisoi pɛɛ n cɑ́pinɛlɛ̃ kɛcɔpɛ pinyinɛ ɑpi ɑnɔ́ɔ nyɛ̃ n kṍ, ɑpi rɛ: Mɛsei usoi nkó yɛɛ ɑntepu uyɛɛ pɛɛ n sɔ́nti. ");
INSERT INTO soy_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Picɔ pɔ́ɔ rɛ: Uyɛ̃ kɛ Uléécɑɑ uu wɛ́ɛ. Kei kɛ picɔ pɔ́ɔ kɔ rɛ: Uyɛ̃ kɛ Uléécɑɑ uu n wɛ́ɛ yɛ́ fe uu pɛɛ Kɑlilee-pɔ leerii? ");
INSERT INTO soy_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ńté li Nléécɑɑsimɛ́ ritɛlɛ́ kɛ́mɛɛ wɔ́lɑɑlɛ̃ tɛ: Uyɛ̃ kɛ Uléécɑɑ uu n wɛ́ɛ yɛ Tɑfiti kɛpirɛ̃ lɛ? Pɛtɛlɛhɛm kuyu-i kɛ Tɑfiti uú pɛɛ ń we kɑpi u mɑrunɛ. ");
INSERT INTO soy_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Lɛ̃ nnyɑ kɛ pisoi ɑpi Yeesu kɛcɑ́ɑ́ ɑnɔ́ɔ ɑkɔ́ ɑkɔ́ símɑɑnkɛɛ. ");
INSERT INTO soy_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Pinyinɛ yɛ pɛɛ pikɛcɔpɛ lɑlɛ pikɛ́ u tĩ, ɑmɑ́ úkɑ úu pɛɛ kɑhɑ ukɛ́ u ricɑ. ");
INSERT INTO soy_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Uléécɑɑ kɛyɔ pimɛ́rɛ́ ɑpi yisi ɑpi pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ nɛ Pifɑrisi kɛ́mɛɛ pɛlɛ. Pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ nɛ Pifɑrisi ɑpi pi pisɛ rɛ: Yo nnyɑ kɑ́ni u tĩ nɔkɛ́ nɛ kɑm? ");
INSERT INTO soy_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Api pi pɛsɛ rɛ: Nɛ kɛweesi, usoi úkɑ úu símɑɑlɛ̃ yɑrɛ usoi nkó mɛcɔ. ");
INSERT INTO soy_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Kei kɛ Pifɑrisi ɑpi pɛɛ pi pisɛ rɛ: Yɑrɛ nɔ̃́ nɛ kɔ tíyɛlɛ uu kɔ nɔ̃́ feriyɛɛ? ");
INSERT INTO soy_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Yɑrɛ pirɔ́yɔ́ɔpi nɛ tɔ̃́ Pifɑrisi kɛcɔpɛ usɛ unyinɛ yɛ nɛ kɛfɑ u tɛnɛlɛ nɛ́ɛ? ");
INSERT INTO soy_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Amɑ́ risoiwuí ntí tɛɛ nní u n tíkilɛ̃ ɑ́ri isé nyu. Uléécɑɑ yɛ lɛ̃ nnyɑ ɑnɔ́ɔ ri wɑlɛ. ");
INSERT INTO soy_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Pifɑrisi kɛcɔpɛ usɛ kɑpi yɛ n sée rɛ Nikotɛm yɛ pɛɛ kei welɛ. U pinyinɛ-i Yeesu kɛ́mɛɛ hɑ́pɑɑlɛnlɛ. Uyɛɛ pi mɑɑ rɛ: ");
INSERT INTO soy_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Irɔ́sé íi ncée hɛ rɛ pikɛ́ usoi ɑkópɛ pɑ ɑ́pi kɑhɑnɛ unkɔ́ n kõ, nɛ́ɛ ɑ́pi kɑhɑnɛ n ceri lɛ̃ kuu n wɑ. ");
INSERT INTO soy_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Kei kɑpi pɛɛ u pisɛ rɛ: Nɛ́ntɛ pɔ̃́ nɛ kɔ nkpéni Kɑlilee ukɔ́ lɛ, nɛ́ɛ yo. A ńsɔnɛ Nléécɑɑsimɛ́ ritɛlɛ́ kɛ́ɛ̃ ɑɑ kóm tɛ ɑntepu úkɑ úu píkɑi Kɑlilee-pɔ leemɛlɛ̃. ");
INSERT INTO soy_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Lɛ̃ mɛmɑ́ɑ́, ḿpɑ́ úye uu yisi uú kulu. ");
INSERT INTO soy_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Kɛ pisoi ɑpi n kúũ, Yeesu pɔ́ɔ yisi uu Olifiyee rikúú tɑɑ́. ");
INSERT INTO soy_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Uu kɛmɑrɛsinɛ yisi uu Uléécɑɑ kɛyɔ-i pɛlɛ, pisoi ɑpi u kɑ́lɑɑpɔ. Uu pɛɛ́ tonɛ uu pi n céési. ");
INSERT INTO soy_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Kei kɛ isé picélɑɑ nɛ Pifɑrisi ɑpí nɛ unɔ́si unyinɛ hɑpɔ rɛ pi u torilɛ un iwɑ́sɑ́ wɑi. Api riwúí kɛcɔpɛ u nyɛrɛsɛ, ");
INSERT INTO soy_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ɑpi Yeesu mɑɑ rɛ: Ucélɑɑ, pi unɔ́si nkó tórilɛ un iwɑ́sɑ́ wɑi. ");
INSERT INTO soy_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moisi yɛ isé rɔ́ pɑ rɛ tɔkɛ́ yɛ lipinɔsi pɛ̃ ɑpɑrɛ tɑpisi tɔkɛ́ kpu. Ń-ye kɛ pɔ́ɔ yɛ̃́? ");
INSERT INTO soy_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Tinɔ́ɔ kɑpi lɛ̃ wɛ́ɛ́si nnyɑ kɑpi lɛ̃ u pisɛ pikɛ́ nɛ nnyinɛ n yɛ̃́ pikɛ́ nɛ pitele u n wɑ nnyɑ. Amɑ́ Yeesu uú pɛ, uu kɛnípɛpi nɛ ntɑɑi kɛ́mɛɛ piwɔ́lɛ kɑ́pɑ́ɑ́. ");
INSERT INTO soy_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Kɑpi ń we pin pipísɛisɛ nɛ kɛ́yu u mɑhɑni nnyɑ, Yeesu uu yisi uu kɛcírɛ nyɛrɛ uu pi mɑɑ rɛ: Uyɛɛ úu nɔ́kɛnɛ́cɔpɛ nkɛ́-i ɑkópɛ n wɑilɛ̃ ukɛ́ mɛfoí ripɑrɛ u tɔ́ɔ́ri. ");
INSERT INTO soy_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Uu kɔ pípɛ kpɑ́ uu ntɑɑi kɛ́mɛɛ piwɔ́lɛ nɔŋ́. ");
INSERT INTO soy_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Kɑpi ɑnɔ́ɔ nyɛ̃ n kṍ, piwɛ́ɛ́sɛ ɑpi pinnɛ́í kpíi usɛ usɛ. Piwɛ́ɛ́sɛ kɑí nɛ kori ɑí nɛ siwɑ̃́ pɑ́ɑ́lɑ́, ɑi pɛɛ nkpéni unɔ́si uyɛ̃ mɛcirɛ kɛcɔpɛ yɑ́, u nɛ Yeesu pin we. ");
INSERT INTO soy_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yeesu uu pɛɛ yisi uu nyɛrɛ uu u pisɛ rɛ: Unɔ́si, yei kɑpí we? Úkɑ úu ɑkópɛ pɔ́ pɑɑ? ");
INSERT INTO soy_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Uu u pɛsɛ rɛ: Úkɑ úu we, Upíimɑ. Yeesu uu u mɑɑ rɛ: Nɛ̃́ ɑ́m kɔ ɑkópɛ pɔ́ pɑnɛ. A n ŋme ɑɑ tɔ́mpɔ. Amɑ́ kɑpɛ kɔ ɑkópɛ piwɑi rikpɑ́. ");
INSERT INTO soy_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yeesu uu kɔ pisoi pɛɛ n cɑ́pinɛlɛ̃ pimɑ́ɑ kpɑ́ rɛ: Nɛ̃́ nɛ pisoi nnɛ́í mɛtɛ́í lɛ. Nkó yɛɛ nɛ́ n tíkilɛ̃ úu píkɑi kuŋmɑhɑ kɛ́mɛɛ sɔ́nɛnɛ, ɑmɑ́ mɛtɛ́í mɛɛ yɛ nfɑ́ɑ n hɛ kuu yɛ́ m mɑ́. ");
INSERT INTO soy_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Kei kɛ Pifɑrisi ɑpi pɛɛ u mɑɑ rɛ: Pɔ́ɔ ripɔ́cúruu kɛpɔ́cɑ́ɑ́ ɑseérɑ lesɛ. In lɛ̃, ɑ́i nsímɛ́sei kɑɑ símisi. ");
INSERT INTO soy_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yeesu uu pi pɛsɛ rɛ: Ḿpɑ́ kɑm tinɛ́cúruu kɛnɛ́cɑ́ɑ́ nsímɛ́ n símisi, nsímɛ́sei yɛ mu. Li we rɛ nɛ nyulɛ kei kɑm n léeri nɛ kei kɑm n sĩ́. Amɑ́ nɔ̃́ ɑ́ni nyu kei kɑm n léeri nɛ kei kɑm n sĩ́. ");
INSERT INTO soy_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Sisoipipi mɛtúhɑɑnɛ mɛcɔ kɛ nɔ́ɔ túhɑɑnɛ. Nɛ̃́ ɑ́m úkɑ nɛ túhɑɑnɛ. ");
INSERT INTO soy_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Amɑ́ in tɛ nɛ nɛ unyinɛ túhɑɑnɛ, ɑsei kɑm tíkilɛ̃ nɛn nɛ u túhɑɑnɛ. Li we rɛ ɑ́i mɛnɛ́círɛ nɛ́ɛ nɛ u túhɑɑnɛ, tɔ́ nɛ Unɛ́sɑ́ɑ yɛɛ nɛ́ n tummɛ yɛ pi. ");
INSERT INTO soy_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Li nɔ́inɛ́sé kɛ́mɛɛ wɔ́lɑɑlɛ̃ tɛ pisoi pitɛ́ pin linyinɛ kɛcɑ́ɑ́ nsɛ n símisi, nsímɛ́sei yɛ mu. ");
INSERT INTO soy_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nɛ̃́ nɛ rinɛ́cúruu kɛcɑ́ɑ́ ɑseérɑ lesɛlɛ, Unɛ́sɑ́ɑ yɛɛ nɛ́ n tummɛ un kɔ kɛnɛ́cɑ́ɑ́ ɑseérɑ lesɛ. ");
INSERT INTO soy_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Api pɛɛ u pisɛ rɛ: Yei kɛ Upɔ́sɑ́ɑ uú we? Yeesu uu pi pɛsɛ rɛ: Áni nɛ́ nyu ɑ́ni kɔ Unɛ́sɑ́ɑ nyu. Nɔn pɛɛ nɛ́ n nyu, nɔ́ kɔ pɛɛ Unɛ́sɑ́ɑ pɔ̃́ kɔ n nyu. ");
INSERT INTO soy_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yeesu yɛ ɑnɔ́ɔ nnyɛ́ mɑlɛ un Uléécɑɑ kɛyɔ kɛ́mɛɛ ɑwóótɑkɑi kɛyúrí we un Nléécɑɑsimɛ́ céési. Kɛ uituŋɛ íi pɛɛ kɑhɑnɛ n tu nnyɑ, úkɑ úu u tĩ. ");
INSERT INTO soy_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yeesu uu kɔ pimɑ́ɑ pi kpɑ́ rɛ: Nɛ tɔ́sulɛ. Nɔ́ kɑm ɑni nɛ́ wɛ́ɛ́si ɑ́ni yɛ́ nɛ́ yɛ̃́, ɑní nɛ nɔ́ɑnɛ́kópɛ kpíni. Áni yɛ́ fe nɔkɛ́ kei kɑm n símpɔ hɑ. ");
INSERT INTO soy_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Pisuifi ɑpi pɛɛ pimɛcirɛ m písɛinɛ rɛ: Kuu nní m mɑɑ rɛ ɑ́ri yɛ́ fe tɔkɛ́ kei kuu n símpɔ hɑ, yɑrɛ u lɑlɛ ukɛ́ umɛcirɛ kpu nɛ́ɛ? ");
INSERT INTO soy_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yeesu uu pi mɑɑ rɛ: Nɔ̃́ nɛ mɛtene nté pikɔ́ lɛ, nɛ́ɛn kɛcɑ́ɑ́-pɔ ukɔ́. Nɔ̃́ nɛ kɛtẽ nté pikɔ́ lɛ, nɛ̃́ ɑ́m kɛtẽ nté ukɔ́. ");
INSERT INTO soy_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Lɛ̃ nnyɑ kɑm nɔ́ mɑɑ rɛ nɔnsɑ́ n ŋmurɛi rɛ nɛ́ɛ ḿpɑ́ píyei uwee, nɔ nɛ nɔ́ɑnɛ́kópɛ kpíninɛ. ");
INSERT INTO soy_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Kei kɑpi pɛɛ u pisɛ rɛ: Pɔ́ɔ mpíí úye kɛcirɛ? Yeesu uu pi pɛsɛ rɛ: Tɛ íye kɑm mpíí mɛkɛɛ-mɛ nɔ́ símɑɑri? ");
INSERT INTO soy_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nɛ nɔ́kɛnɛ́cɑ́ɑ́ nsímɛ́ mɑ́lɛ mɛyɑ̃́ kɛ́ símisi kɛ́ kɔ nɛ nɔ́ túhɑɑnɛ. Amɑ́ mmɛ̃ kɑm uyɛɛ nɛ́ n tummɛ kɛ́mɛɛ n kṍ ŋmɑnɛ kɑm pisoi símisi. Asei kɛ uyɛ̃ uu símisi. ");
INSERT INTO soy_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Amɑ́ ɑ́pi nkpɑ́ni céri rɛ Usɑ́ɑ nsímɛ́ kuu símisi. ");
INSERT INTO soy_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yeesu uu pɛɛ pi mɑɑ rɛ: Nɔn píyei Usoi Kɛpipi rintɑɑ́sɛ, nɔ́ pɛɛ céri rɛ nɛ́ɛ ḿpɑ́ píyei uwee. Nɔ́ kɔ ceri rɛ ɑ́m linɛ́kɔ́ cirɛ líkɑ wɑi, ɑmɑ́ lɛ̃ kɛ Sɑ́ɑ uu nɛ̃́ n céesi kɑm símisi. ");
INSERT INTO soy_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Tɔ́ nɛ uyɛɛ nɛ́ n tummɛ tɔ́ɔ kɛsẽ́ we. Lɛ̃ kuu ń lɑ ŋmɑnɛ kɑm yɛ wɑ. Lɛ̃ nnyɑ, úu nɛ́ riyɑ́ kɛ́ mɛnɛ́círɛ n we. ");
INSERT INTO soy_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Kɛ Yeesu uu lɛ̃ n símisi, pisoi mɛyɑ̃ ɑpí nɛ kɛfɑ u tɛnɛ. ");
INSERT INTO soy_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Kei kɛ Yeesu uu pɛɛ Pisuifi pɛɛ nɛ kɛfɑ u n tɛnɛ mɑɑ rɛ: Nɔn nnɛ́símɛ́ n tikilɛ̃, nɔ pinɛ́pirɛtiki yíkíyiki lɛ. ");
INSERT INTO soy_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Nɔ́ pɛɛ nsímɛ́sei ceri, nsímɛ́sei mmɛ̃ nn tíyɛsɛ ɑni nɔ́mɛnɛ́círɛ n te. ");
INSERT INTO soy_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Api u pɛsɛ rɛ: Tɔ Apirɑhɑm siyɑsɛ lɛ, ɑ́ri kɔ píkɑi unyinɛ ilɑsi tonɛlɛ̃. Yo nnyɑ kɑɑ pɛɛ rɛ: Nɔ́ kɑm ɑni nɔ́mɛnɛ́círɛ n te? ");
INSERT INTO soy_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yeesu uu pi pɛsɛ rɛ: Asei kɛcɑ́ɑ́, kɛ́ nɔ́ símisi rɛ usoi nkó yɛɛ ɑkópɛ n wɑi yɛ ɑkópɛ ulɑsi lɛ. ");
INSERT INTO soy_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ulɑ́si úu yɛ mɛsɛ́rɛ kɛ́yɔ kɛ-i kɑpi u m múílɛ̃ n we. Úyɔpipi yɛɛ yɛ mɛsɛ́rɛ kɛ́yɔ-i n we. ");
INSERT INTO soy_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Lɛ̃ nnyɑ, Kɛpipi kɛn ilɑ́si kɛ́mɛɛ nɔ́ n lesɛ, nɔ mɛyíkíyiki nɔ́mɛnɛ́círɛ telɛ. ");
INSERT INTO soy_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nɛ nyulɛ rɛ nɔ Apirɑhɑm siyɑsɛ lɛ. Amɑ́ nɔ kɔ pɛɛ́ lɑ nɔkɛ́ nɛ́ kpu rɛ ɑ́ni nnɛ́símɛ́ ŋmurɛi nnyɑ. ");
INSERT INTO soy_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Lɛ̃ kɛ nɛ́ɛ Unɛ́sɑ́ɑ kɛ́mɛɛ n yɛ̃́ nkɔ́ kɛ nɛ́ɛ símisi. Lɛ̃ kɛ nɔ́ɔ kɔ nɔ́unɛ́sɑ́ɑ kɛ́mɛɛ n kṍ kɛ nɔ́ɔ kɔ wɑ. ");
INSERT INTO soy_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Api u pɛsɛ rɛ: Apirɑhɑm yɛ urɔ́sɑ́ɑ lɛ. Yeesu uu pi mɑɑ rɛ: In tɛ nɔ Apirɑhɑm sipipi lɛ, ɑni Apirɑhɑm mɛwɑi n wɑi. ");
INSERT INTO soy_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Mɛnɛ́wɑi nnɛ́í yɛɛ rɛ kɛ́ nsímɛ́sei kɑm Uléécɑɑ kɛ́mɛɛ n kṍ nɔ́ ritɛ́ŋ́sɛ. Amɑ́ ḿpɑ́ nɛ lɛ̃, nɔ kɔ pɛɛ wɛ́ɛ́silɛ nɔkɛ́ nɛ́ kpu. Apirɑhɑm úu pɛɛ lɛ̃ wɑi! ");
INSERT INTO soy_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Amɑ́ nɔ́unɛ́sɑ́ɑ sei mɛwɑi mɛcɔ kɛ́ nɔ́ɔ wɑi. Kei kɑpi pɛɛ Yeesu pɛsɛ rɛ: Ári siwɑ́sɑ́nkɑipipi. Usɑ́ɑ usɛ kóló kɑri mɑ́. Uyɛɛ nní Uléécɑɑ. ");
INSERT INTO soy_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yeesu uu pi mɑɑ rɛ: Uléécɑɑ un pɛɛ mɛsei Nɔ́unɛ́sɑ́ɑ, nɔ yɛɛ pɛɛ nɛ́ n lɑ rɛ ukɛmɛɛ kɑm léeri nɛn kɔ uyɛ̃ nnyɑ nté we. Ái mɛnɛ́lɑ kɛ́mɛɛ kɑḿ kɑ. Uyɛɛ nɛ́ tummɛ. ");
INSERT INTO soy_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Yo nnyɑ kɑ́ni lɛ̃ kɑm nɔ́ n símisi ɑsei kómɛi? Kɑ́ni yɛ́ n fe nɔkɛ́ nnɛ́nɔ́ɔsimɛ́ kutu rińcɔ nnyɑ yɛ ni. ");
INSERT INTO soy_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Kuníri kpɛɛ nɔ́unɛ́sɑ́ɑ. Nɔ́unɛ́sɑ́ɑ mɛlɑ kɑni kɔ lɑ nɔkɛ́ n wɑi. Hɑ́i mɛkɛɛ-mɛ kuu usoikṍ. Úu yɛ ɑsei ritiki. Li we rɛ ɑsei ɑ́ɑ ukɛmɛɛ́ we. U yɛ un nnɔ́ɔmɛ n wɑi kɑí nɛ u sɑ́. U unɔ́ɔmɛ lɛ. Uyɛɛ kɔ nnɔ́ɔmɛ nnɛ́í riyíkí. ");
INSERT INTO soy_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Kɑi nní lɛ̃ ń we nnyɑ kɑ́ni yɛ nsímɛ́sei kɛ nɛ́ɛ n símisi ŋmurɛi. ");
INSERT INTO soy_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Nɔ́ úye yɛɛ yɛ́ fe uu nɛ́ nyísɛ rɛ nɛ ɑkópɛ wɑ? In tɛ nsímɛ́sei kɑm símisi, yo nnyɑ kɑ́ni pɛɛ́ nɛ kɛfɑ nɛ́ tɛnɛ? ");
INSERT INTO soy_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Usoi nkó yɛɛ Uléécɑɑ ukɔ́, yɛ̀ɛ̀ Uléécɑɑ nsímɛ́ kutu ricɔlɛ. Kɛ nɔ̃́ ɑ́ni nní upikɔ́ nnyɑ kɑ́ni Uléécɑɑ Nsímɛ́ kutu cɔlɛ̃. ");
INSERT INTO soy_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Pisuifi ɑpi pɛɛ Yeesu pɛsɛ rɛ: Ái tɔ mɛsei ɑlɑri mɑ́lɛ tɔkɛ́ mɑɑ rɛ pɔ Sɑmɑrii ukɔ́ lɛ ɑɑ kɔ ɑníri héésii? ");
INSERT INTO soy_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Uu pi pɛsɛ rɛ: Ám ɑníri héesi, ɑmɑ́ Unɛ́sɑ́ɑ kɑm tíyu wɑisɛ, nɔ́ɔn pɛɛ tinɛ́kɔ́ kópu! ");
INSERT INTO soy_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ám wɛ́ɛ́si kɛ́ rinɛ́cúruu ríyu wɑisɛ. Unyinɛ yɛɛ wɛ́ɛ́si ukɛ́ ríyu nɛ́ wɑisɛ. Uyɛɛ kɔ utúhɑɑnɛ. ");
INSERT INTO soy_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Asei kɛcɑ́ɑ́, kɛ́ nɔ́ símisi rɛ nkó yɛɛ nnɛ́símɛ́ rimmúlú úu píkɑi kpinɛ. ");
INSERT INTO soy_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Kei kɛ Pisuifi ɑpi pɛɛ u mɑɑ rɛ: Tɔ nkpéni mɛyíkíyiki yɛ́nlɛ rɛ pɔ ɑníri héesilɛ. Apirɑhɑm yɛ kpulɛ, ɑntepuyɛ pɔ́ɔ kɔ kpíni. Pɔ́ɔ pɛɛ nkpéni rɛ nkó yɛɛ mpɔ́símɛ́ rintíki úu píkɑi kpinɛ! ");
INSERT INTO soy_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Yɑrɛ pɔ̃́ nɛ urɔ́sɑ́ɑ Apirɑhɑm yɛɛ n kpu felɛ nɛ́ɛ? Antepuyɛ pɔ̃́ nɛ kɔ kpínlɛ. Yɑrɛ pɔ́ɔ pɛɛ úye? ");
INSERT INTO soy_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yeesu uu pɛɛ pi pɛsɛ rɛ: In tɛ nɛ́ɛ rinɛ́cúruu ríyu wɑisɛ, ɑ́m yɛ́ ríyu yɛ̃. Amɑ́ Unɛ́sɑ́ɑ uyɛ̃ kɑni ḿ mɑɑ rɛ uyɛɛ Nɔ́unɛ́léécɑɑ yɛɛ ríyu nɛ́ wɑisɛ. ");
INSERT INTO soy_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Áni kɔ pɛɛ u nyu. Amɑ́ nɛ̃́ nɛ u nyulɛ. Nɛn m mɑɑ rɛ ɑ́m u nyu, nɛ lɛ̃ wɑlɛ nɔ́mɛnɛ́cɔ unɔ́ɔmɛ. Amɑ́ nɛ̃́ nɛ u nyulɛ nɛn kɔ unsímɛ́ tíkilɛ̃. ");
INSERT INTO soy_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Nɔ́unɛ́sɑ́ɑ Apirɑhɑm yɛ pɛɛ́ nɛ mpɔ́ɔnɑrɛ cuunkɛɛlɛ rɛ u yɛ́ kɑm uu kɛnɛ́kɑ́mɛyɑɑ yɛnu. Uu kɔ mɛsei kɛ yɛnu, urikiŋ ɑri níŋɛsi hɑ́i. ");
INSERT INTO soy_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Kei kɛ Pisuifi ɑpi pɛɛ u pisɛ rɛ: Pɑ́ɑ kɑhɑnɛ nkpɑ́ni iŋmɛ̃ kuwóó n tu, pɔn pɛɛ tee rɛ pɔ Apirɑhɑm yɛnɑɑlɛ̃, nɛ́ɛ yo? ");
INSERT INTO soy_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yeesu uu pi mɑɑ rɛ: Asei kɛcɑ́ɑ́, kɛ́ nɔ́ símisi rɛ Apirɑhɑm ukɛ́ kɛlenɛ ń we, nɛ̃́ nɛ pɛɛ́ welɛ. ");
INSERT INTO soy_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Kei kɑpi pɛɛ ɑpɑrɛ kpísi rɛ pikɛ́ u tɑpisi. Amɑ́ uú nɛ pi pɔlu uu Uléécɑɑ kɛyɔ-i léepɔ uu tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Kɛ Yeesu uu ncée-i ń we un tɔ́su, uu utisi unyinɛ kɑpi m mɑ́ri unyíyɛ yɛnu. ");
INSERT INTO soy_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Upipirɛtiki ɑpi u pisɛ rɛ: Ucélɑɑ, wóo kɛcirɛ yɛɛ ɑkópɛ wɑ nnyɑ kɑpí nɛ utisi nkó mɑ́ri unyíyɛ? Uricuruu ɑkópɛ nnyɑ nɛ́ɛ pɛpɛɛ u m mɑ́ri ɑkópɛ nnyɑ? ");
INSERT INTO soy_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yeesu uu pi pɛsɛ rɛ: Ái uɑkópɛ nnyɑ, ɑ́i kɔ pɛpɛɛ u m mɑ́ri ɑkópɛ nnyɑ. Lɛ̃ kɑi yɛ́ n wɑ Uléécɑɑ nnɑŋɛ nkɛ́ nɛ ukɛcɑ́ɑ́ ń we lin nyɑ́ni nnyɑ kuu unyíyɛ. ");
INSERT INTO soy_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Kɛ ituŋɛ ii nní ń we, li pisɛ rɛ tɔkɛ́ uyɛɛ nɛ́ n tummɛ pikɛi wɑ. Kɛsinɛ yɛ wɑinɛ, úkɑ úu yɛ́ pɛɛ fe ukɛ́ kɛisi. ");
INSERT INTO soy_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Kumúŋɛ́ nkú-i kɑm nní kɛtẽ kɛcɑ́ɑ́ ń we, nɛ́ɛ kɛtẽ kɛcɑ́ɑ́ mɛtɛ́í. ");
INSERT INTO soy_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Kuu ɑnɔ́ɔ nyɛ̃ pimɑ́ɑ ḿ mɑsí, uu kɛteni-i mɛtɑ tukɛ uú nɛ sipɛ́rɛ́pi wɑi, uu unyíyɛ uyɛ̃ inipɛɛ pɔ́rii, ");
INSERT INTO soy_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","uu pɛɛ u mɑɑ rɛ: A n ŋme ɑ hɑ Silowee kupɔrɛ-pɔ lihí. Silowee ɑsei rɛ Utumɛ. Uu mɛsei yisi uu sĩ́ uú hɑ líhu. Kuú hɑ m pɛɛmɛ, uu pɛɛ́ n nyɑ́ni. ");
INSERT INTO soy_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Upipɛrɛcɔ nɛ pɛpɛɛ n nyu rɛ u pɛɛ wéleilɛ, ɑpi pɛɛ́ m písɛinɛ rɛ: Ái nkó yɛɛ pɛɛ tṹ un wéleii? ");
INSERT INTO soy_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Picɔ ɑpi yɛ rɛ: Uyɛɛ lo. Picɔ ɑpi rɛ ɑɑí, mɛnyínɛ kɑpi wenɛ. Uricuruu uu pɛɛ rɛ: Nɛ̃́ ŋmɑɑ lo. ");
INSERT INTO soy_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Api pɛɛ u pisɛ rɛ: Íye kɑi wɑ kɛ ipɔ́nípɛɛ ií nɛ nkpéni nyɑ́ni? ");
INSERT INTO soy_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Uu pi pɛsɛ rɛ: Utisi uyɛ̃ kɑpi yɛ n sée rɛ Yeesu yɛɛ sipɛ́rɛ́pi wɑ, uu inípɛɛ nɛ́ pɔ́rii uu pɛɛ nɛ́ mɑɑ rɛ: “A n ŋme ɑ hɑ Silowee kupɔrɛ-pɔ lihí.” Am sĩ́ ɑḿ hɑ líhu, ɑm pɛɛ́ n nyɑ́ni. ");
INSERT INTO soy_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Api u pisɛ rɛ: Yei kɛ utisi uyɛ̃ uú we? Uu pi pɛsɛ rɛ: Ám nyu. ");
INSERT INTO soy_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Api pɛɛ utisi uyɛɛ pɛɛ mɛkɛɛ n nyíinlɛ̃ nɛ Pifɑrisi kɛ́mɛɛ sĩ́. ");
INSERT INTO soy_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Kɛyɑ́ɑ kɛ̃ kɛ Yeesu uu sipɛ́rɛ́pi n wɑ uú nɛ inípɛɛ u wúkulɛ yɛ pɛɛ kɛwéntɛyɑɑ lɛ. ");
INSERT INTO soy_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Pifɑrisi pɔ́ɔ kɔ pipísɛi u kpɑ́ rɛ íye kɑi wɑ kuú nɛ nkpéni nyɑ́ni? Uu pi mɑɑ rɛ: Sipɛ́rɛ́pi kuu inípɛɛ nɛ́ pɔ́rii, ɑm sĩ́ ɑḿ hɑ líhu, ɑm pɛɛ nkpéni n nyɑ́ni. ");
INSERT INTO soy_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Lɛ̃ nnyɑ kɛ pikɛcɔpɛ pinyinɛ ɑpí mɑɑ rɛ: Utisi uyɛɛ mɛwɑi mmɛ́ n wɑ úu yɛ́ fe ukɛ́ Uléécɑɑ-i n leeri. Kúu nní kɛwéntɛyɑɑ isé rintíki nnyɑ. Picɔ ɑpi rɛ: Íye kɛ ukópɛkɔɔ́ uu yɛ́ fe uu mɛwɑisɑŋɑ mmɛ́ mɛcɔ wɑi? Kei kɑpi pɛɛ ɑnɔ́ɔ ɑkɔ́ ɑkɔ́ nɛ rikénɛ. ");
INSERT INTO soy_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Pifɑrisi ɑpi kɔ unyíyɛ uyɛ̃ pipisɛ kpɑ́ rɛ: Íye kɛ pɔ́ɔ utisi uyɛɛ inípɛɛ pɔ́ m pɔisɛ kɛcɑ́ɑ́ músu? Uu rɛ: Antepu lo. ");
INSERT INTO soy_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ḿpɑ́ nɛ lɛ̃, Pisuifi piwɛ́ɛ́sɛ ɑ́pi pɛɛ lɑ pikɛ́ kṍ tɛ u pɛɛ unyíyɛ lɛ kuu kɔ nkpéni nyɑ́ni. Api pɛɛ upikɔ́ séi ");
INSERT INTO soy_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ɑpi pi pisɛ rɛ: Nɔ́unɛ́ŋmɑ́nɛ uyɛ̃ kɑni n tee rɛ nɔ u mɑrilɛ unyíyɛ yɛ mɛsei nkóo? Íye kɑi wɑ kuu kɔ nɛ nkpéni nyɑ́ni? ");
INSERT INTO soy_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Upikɔ́ ɑpi pi pɛsɛ rɛ: Tɔ u nyulɛ rɛ u kɛrɔ́pipi. Tɔ kɔ u mɑrilɛ unyíyɛ. ");
INSERT INTO soy_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Amɑ́ ɑ́ri nyu lɛ̃ kɑi n wɑ kuú nɛ nkpéni n nyɑ́ni, ɑ́ri kɔ nyu wóo u pɔisɛ. Ani u pisɛ, úu kɛwɑ̃́, u yɛ́ fe uu uriyu kɛcɑ́ɑ́ nkɔ́ símisi. ");
INSERT INTO soy_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Pisuifi piwɛ́ɛ́sɛ kɑpi wuru nnyɑ kɑpi lɛ̃ mɑ. Li we rɛ Pisuifi piwɛ́ɛ́sɛ yɛ pɛɛ kómɛinɛlɛ rɛ úye un m mɑɑ rɛ Yeesu kɛ Uléécɑɑ uu wɛ́ɛ, pikɛ́ liute kuyómɛyɑ́hɑɑlee-i lesɛ. ");
INSERT INTO soy_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Lɛ̃ nnyɑ kɛ upikɔ́ ɑpí mɑɑ rɛ: Úu kɛwɑ̃́, ɑni uricuruu pisɛ! ");
INSERT INTO soy_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Pifɑrisi ɑpi kɔ uyɛ̃ kɑpi m mɑ́ri unyíyɛ pipísɛi kpɑ́ ɑpi u mɑɑ rɛ: A ɑsei símisi likɛ́ Uléécɑɑ rinyiri ritɑɑ́sɛ. In tɔ́ɔ, tɔ nyulɛ ŋmɑɑ rɛ utisi uyɛɛ ukópɛkɔɔ́ lɛ. ");
INSERT INTO soy_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Uu pɛɛ pi pɛsɛ rɛ: Un ukópɛkɔɔ́, nɛ̃́ ɑ́m nyu. Amɑ́ likɛi lisɛ kɑm nyu rɛ nɛ pɛɛ unyíyɛ lɛ nɛn kɔ pɛɛ nkpéni nyɑ́ni. ");
INSERT INTO soy_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Api pɛɛ u pisɛ rɛ: Yo kuu pɔ́ wɑ? Íye kuú nɛ inípɛɛ pɔ́ wúkulɛ? ");
INSERT INTO soy_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Uu pi pɛsɛ rɛ: Nɛ pisímɛ́ nɔ́ mɑsilɛ ɑ́ni kutu nɛ́ ricɔ. Yo nnyɑ kɑní lɑ kɛ́ kɔ pisímɛ́ rikpɑ́ nɔkɛ́ kṍ? Nɛ́ɛ nɔ̃́ nɛ kɔ lɑlɛ nɔkɛ́ pɑnsɛ upipirɛtiki? ");
INSERT INTO soy_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Kei kɑpi ɑlɛ̃́ u rikɑ́pɑ́ɑ́ ɑpi rɛ: Pɔ́ɔ uyɛ̃ upirɛtiki. Amɑ́ tɔ̃́ nɛ Moisi pipirɛtiki lɛ. ");
INSERT INTO soy_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tɔ nyulɛ rɛ Uléécɑɑ yɛ nɛ Moisi símisilɛ. Amɑ́ ɑ́ri nyu ricuruu mɛ́ye kɛ nkó pɔ́ɔ léeri. ");
INSERT INTO soy_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Unyíyɛ yɛɛ ḿ peí uu pi mɑɑ rɛ: Lɛlɛɛ pírí nɛ́ ń we yɛɛ rɛ ɑ́ni nyu mɛ́ye kuu léeri, uu kɔ pɛɛ tíyɛsɛ inɛ́nípɛɛ ií n nyɑ́ni. ");
INSERT INTO soy_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tɔ nyulɛ rɛ Uléécɑɑ úu yɛ ukópɛkɔɔ́ nɛ kutu ricɔ, ɑmɑ́ nkó yɛɛ ríyu u n wɑisɛlɛ̃ un umɛlɑ wɑi kuu yɛ kutu ricɔ. ");
INSERT INTO soy_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kɑí nɛ n wemɛ, ɑ́ri píkɑi kómɑɑlɛ̃ tɛ unyinɛ yɛ tíyɛsɛ usoi kɑpi m mɑ́ri unyíyɛ uu yɛ kɔ yɛnu. ");
INSERT INTO soy_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Utisi nkó unsɑ́ pɛɛ Uléécɑɑ kɛ́mɛɛ n leeri, úu yɛ́ pɛɛ fe ukɛ́ linyinɛ wɑ. ");
INSERT INTO soy_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Api u pɛsɛ rɛ: Hɑ́i kɑpí nɛ pɔ́ ḿ mɑ́ri kɑɑ ɑkópɛ kɛ́mɛɛ pɔ́lɔlɛ̃. Pɔ́ɔ yɛ́ pɛɛ nkpéni tɔ̃́ céési, nɛ́ɛ yo? Api pɛɛ kuyómɛyɑ́hɑɑlee-i u lesɛ. ");
INSERT INTO soy_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yeesu uu kóm tɛ pi utisi uyɛ̃ lesɛ. Uú nɛ utisi uyɛ̃ sɑ́nɛ uu u pisɛ rɛ: Pɔ Usoi Kɛpipi nɛ kɛfɑ tɛnɛlɛ̃ɛ? ");
INSERT INTO soy_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Uu Yeesu pɛsɛ rɛ: Uyɛɛ úye, Upíimɑ? A nɛ́ símisi kɛ́ nɛ kɛfɑ u tɛnɛ. ");
INSERT INTO soy_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yeesu uu u pɛsɛ rɛ: Uyɛ̃ kɑɑ nní nyɑ́ni, uyɛɛ nní nɛ pɔ́ símisi. ");
INSERT INTO soy_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Kei kuu pɛɛ rɛ: Nɛ nɛ kɛfɑ pɔ́ tɛnɛlɛ, Upíimɑ. Uu pɛɛ Yeesu kɛnyɑlɛ-i wúlɑ uu ríyu u wɑisɛ. ");
INSERT INTO soy_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yeesu uu pɛɛ rɛ: Nɛ kɛtẽ kɛcɑ́ɑ́ kɑlɛ kɛ́ nɛ pisoi túhɑɑnɛ, pɛpɛɛ n nyíinlɛ̃ pikɛ́ n nyɑ́ni, pɛpɛɛ n nyɑ́ni pɔ́ɔkɛ́ nyíinu. ");
INSERT INTO soy_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Pifɑrisi pinyinɛ yɛ pɛɛ ukɛkúrí welɛ. Kɑpi ɑnɔ́ɔ nyɛ̃ n kṍ, ɑpi u pisɛ rɛ: Yɑrɛ tɔ̃́ nɛ kɔ pinyíyɛ lɛ, nɛ́ɛ íye? ");
INSERT INTO soy_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yeesu uu pi pɛsɛ rɛ: Nɔn pɛɛ pinyíyɛ, ɑ́ni yɛ́ pɛɛ ɑkópɛ m mɑ́. Amɑ́ nɔ yɛ mɑɑ rɛ nɔ nyɑ́nilɛ nnyɑ kɛ nɔ́ɑnɛ́kópɛ ɑɑ nɔ́kɛnɛ́cɑ́ɑ́ we. ");
INSERT INTO soy_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yeesu uu rɛ: Asei kɛcɑ́ɑ́, kɛ́ nɔ́ símisi rɛ usoi nkó yɛɛ úu rinɔnɔɔ-mɛ̃ nɛ kusɑ́ŋlee-i n lompɔ, ɑmɑ́ uu pɛɛ kuwɛ́lɛ́ féé nɛ lompɔ yɛ uyɑɑ nɛ usoi kpɑ́ɑ́ree lɛ. ");
INSERT INTO soy_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Amɑ́ nkó yɛɛ nɛ rinɔnɔɔ n lompɔ yɛɛ usɛɛsẽ́. ");
INSERT INTO soy_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Tinɔnɔɔ umɛ́rɛ́ yɛ̀ɛ̀ usɛɛsẽ́ tinɔnɔɔ hɑ́nnɛlɛ, isɑ́ŋ ii umɛtẽ kom, uyɛ̃ uu pɛɛ ḿpɑ́ uisɑŋ íye rinyiri séi uú nɛ i leepɔ. ");
INSERT INTO soy_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Un uikɔ́ nnɛ́í pilésɛpɔ m mɑsí, uu pɛɛ ikɛkpeẽ wɑi. Kii nní umɛtẽ n nyu nnyɑ, ii pɛɛ u n tikilɛ̃. ");
INSERT INTO soy_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Íi yɛ píkɑi usoi nkó kíi n nyu ritiki. Amɑ́ kɛtɑɑ-pɔ kii yɛ u kɑɑsɛ, kíi nní pisɑ́nɛ mɛtẽ n nyu nnyɑ. ");
INSERT INTO soy_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yeesu uu kɛnyɑ́rũ nkɛ́ pisoi pɛɛ kutu u n cɔ́lɛ̃ wɑi, ɑmɑ́ ɑ́pi ceri lɛ̃ kuu ń lɑ ukɛ́ mɑlɛ. ");
INSERT INTO soy_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yeesu uu kɔ pimɑ́ɑ pi kpɑ́ rɛ: Asei kɛcɑ́ɑ́, kɛ́ nɔ́ símisi rɛ nɛ́ɛ kusɑ́ŋlee rinɔnɔɔ. ");
INSERT INTO soy_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Pɛ̃ nnɛ́í pɛɛ ń kɑ ɑpí nɛ nɛ́ tisɛ yɛ piyɑɑ nɛ pisoi kpɑ́ɑ́ree lɛ, ɑmɑ́ isɑ́ŋ íi nɛ kutu pi ricɔ. ");
INSERT INTO soy_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nɛ́ɛ rinɔnɔɔ. Uyɛɛ nɛ́ mmɛ́ rintíki uú nɛ lompɔ ríyu kɑi yɛ́ lɔ. U yɛ́ɛ́ lompɔlɛ uu lééri uu kɔ lilukɛ-lukɛ m mɑ́. ");
INSERT INTO soy_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Piyɑɑ nɛ pikópɛ nɛ picɑɑinkɛɛ ŋmɑnɛ nnyɑ kɛ uyɑɑ uu yɛ kɑ. Amɑ́ nɛ̃́ nɛ kɑlɛ rɛ isɑ́ŋ ikɛ́ nfɑ́ɑ yɛ̃ nkɛ́ nɛ i m pom. ");
INSERT INTO soy_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Nɛ́ɛ usɛɛsẽ́ sɔnɛ. Usɛɛsẽ́ sɔnɛ yɛ̀ɛ̀ felɛ uu uisɛɛ nkpɔ yɔ́su uu kpi. ");
INSERT INTO soy_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Usɑ́nɛ kɑpi n kpísi un kɛisi úu usɛɛsẽ́ yíkíyiki, ɑ́i kɔ uyɛɛ usɛɛte. U yɛ kúkpɛ yɛnlɛ kun wemɛ, uu isɑ́ŋ yɑ́ uu wuru. Kúkpɛ pɔ́ɔ pɛɛ isɑ́ŋ lɑkɑsɛntɛ ɑku yɛ́kɑ́ɑ́sɛ. ");
INSERT INTO soy_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Kɑi nní siwóó ŋmɑnɛ nnyɑ kuu kɛisi, úu isɑ́ŋ kɛcɑ́ɑ́ nfɑsimɛ́ ńkɑ wɑi. ");
INSERT INTO soy_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Nɛ́ɛ usɛɛsẽ́ sɔnɛ. Nɛ inɛ́sɑ́ŋ nyulɛ, iyɛ̃ in kɔ nɛ́ nyu ");
INSERT INTO soy_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","yɑrɛ kɛ Unɛ́sɑ́ɑ uu nɛ́ n nyu nɛ́ɛn kɔ Unɛ́sɑ́ɑ uyɛ̃ nyu mɛcɔ. Nɛ́ fe ɑm inɛ́sɑ́ŋ nkpɔ yɔ́su ɑm kpi. ");
INSERT INTO soy_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Nɛ kɔ isɑ́ŋ icɔ mɑ́lɛ yɛɛ íi kusɑ́ŋlee nkú-i ń we. Li pisɛ rɛ kɛ́ kɔ iyɛ̃ wɛ́lɑɑmɛ. I yɛ́ mɛnɛ́tẽ kõ, ɑi wɑi kusɑ́ŋlee kusɛ nɛ usɛɛsẽ́ usɛ. ");
INSERT INTO soy_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Sɑ́ɑ yɛ nɛ́ lɑlɛ rɛ nɛ ŋmurɛi rɛ kɛ́ kpu kɛ́ pɛɛ kɔ nfɑ́ɑ piyɛ́nɛ rikpɑ́ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Úkɑ úu nfɑ́ɑ nɛ́ yɔ́su. Nɛ́ɛ rinɛ́cúruu ŋmurɛi rɛ kɛ́ kpu. Nɛ ńnɑŋɛ mɑ́lɛ nɛn yɛ́ kpu ɑm kɔ limɛmɑ́ɑ́ nfɑ́ɑ yɛnu. Lɛ̃ kɛ Unɛ́sɑ́ɑ uu nɛ́ n forii rɛ kɛ́ wɑ yɛ lɛ̃. ");
INSERT INTO soy_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Nsímɛ́ mmɛ̃ nnyɑ, Pisuifi ɑpi kɔ Yeesu kɛcɑ́ɑ́ ɑnɔ́ɔ ɑkɔ́ ɑkɔ́ n símɑɑnkɛɛ. ");
INSERT INTO soy_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Pimɛyɑ̃ ɑpi rɛ: U ɑníri héesilɛ, u isɔhɔ torilɛ. Yo nnyɑ kɑni kutu u cɔlɛ̃? ");
INSERT INTO soy_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Picɔ ɑpi rɛ: Un pɛɛ ɑníri n héesi, úu yɛ́ pɛɛ nní n símisi. Kuníri yɛ́ fe ɑku unyíyɛ inipɛɛ wúkulɛɛ? ");
INSERT INTO soy_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Nnyiyɛ kumúŋɛ́-i kɑpi kɛyɑ́ɑ kɛnyinɛ Yerusɑlɛm-i Uléécɑɑ kɛyɔ inyɔ́ɔnsɛ ɑnyɑ̃́ wɑi. ");
INSERT INTO soy_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yeesu un we un Uléécɑɑ kɛyɔ-i Sɑlomɔɔ imɛlɛ ɑpolɛ mɛtene nyɛ́rɛi. ");
INSERT INTO soy_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Pisuifi ɑpi pɛɛ kɛkɑ́lɛ u wɑi ɑpi u pisɛ rɛ: Nɛ kɛyo-pɔ kɑɑ yɛ́ lɛ̃ tɔ́ n sɛ́ɛ́lɛ̃ tɔn tɑ́ikɛɛ? In tɛ pɔ́ɔ uyɛ̃ kɛ Uléécɑɑ uu n wɛ́ɛ, ɑ rɔ́ símisi kɛkéripi cɑ́kɑ́-cɑ́kɑ́. ");
INSERT INTO soy_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yeesu uu pi pɛsɛ rɛ: Nɛ lɛ̃ pisímɛ́ nɔ́ mɑsilɛ ɑni yúlu. Mɛwɑi kɑḿ nɛ Unɛ́sɑ́ɑ nnɑŋɛ n wɑpisi yɛ nyísɛlɛ rɛ ɑsei kɑm símisi. ");
INSERT INTO soy_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Amɑ́ kɛ nɔ̃́ ɑ́ni nní inɛ́sɑ́ŋ nnyɑ, ɑ́ni ŋmurɛi. ");
INSERT INTO soy_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Inɛ́sɑ́ŋ yɛ̀ɛ̀ mɛnɛ́tẽ konlɛ. Nɛ̃́ nɛ kɔ i nyulɛ, ii yɛ kɔ nɛ́ tíki. ");
INSERT INTO soy_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nfɑ́ɑ tɛnɛcirɛ́ kɑm i hɛ, íi píkɑi kpinɛ, úkɑ úu yɛ́ kɔ fe ukɛ́ ɑnɛ́nípɛ-i i yɔsí. ");
INSERT INTO soy_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Unɛ́sɑ́ɑ yɛɛ nɛ́ i ḿ pɑ yɛ ḿpɑ́ úye felɛ. Úkɑ úu yɛ́ fe ukɛ́ Unɛ́sɑ́ɑ ɑnipɛ-i i yɔsí. ");
INSERT INTO soy_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Tɔ nɛ Sɑ́ɑ tɔ́ yɛ usoi usɛ lɛ. ");
INSERT INTO soy_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Kei kɛ Pisuifi ɑpi kɔ ɑpɑrɛ pikpíkɛ́ rikpɑ́ rɛ pikɛ́ u tɑpisi. ");
INSERT INTO soy_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yeesu uu pɛɛ pi mɑɑ rɛ: Nɛ mɛwɑi sɔnɛ mɛyɑ̃ mɛɛ Sɑ́ɑ kɛ́mɛɛ n léeri nɔ́ nyísɛlɛ. Mɛkɛcɔpɛ mɛ́ye nnyɑ kɑní lɑ nɔkɛ́ ɑpɑrɛ nɛ́ tɑpisi? ");
INSERT INTO soy_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Api u pɛsɛ rɛ: Ái mɛwɑi sɔnɛ mɛ́kɑ nnyɑ kɑrí lɑ tɔkɛ́ ɑpɑrɛ pɔ́ tɑpisi tɔkɛ́ kpu, ɑmɑ́ kɑɑ Uléécɑɑ n lɑ́mɑɑnkɛɛ nnyɑ yɛ ni. Pɔ̃́ kɛsoipipi, ɑɑ mɛpɔ́círɛ n nyɑ́ni rɛ pɔ́ Uléécɑɑ lɛ. ");
INSERT INTO soy_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yeesu uu pi pɛsɛ rɛ: Ái nɔ́inɛ́sé kɛ́mɛɛ wɔ́lɑɑlɛ̃ tɛ Uléécɑɑ yɛ mɑɑ rɛ: Nɔ kɛyómɛcɑɑ sipipi lɛɛ? ");
INSERT INTO soy_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Tɔ nyulɛ rɛ ɑ́pi yɛ́ fe pikɛ́ lɛ̃ kɛ Nléécɑɑsimɛ́ ritɛlɛ́ ɑri ḿ mɑ tinnɛ. Isé ritɛlɛ́ yɛ pɛ̃ kɛ Uléécɑɑ uú pɛɛ́ nɛ n símisi sée rɛ kɛyómɛcɑɑ sipipi. ");
INSERT INTO soy_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Sɑ́ɑ yɛɛ nɛ̃́ wɛ́ɛ uu kɛtẽ kɛcɑ́ɑ́ nɛ́ tumti. Yo nnyɑ kɑm yɛ́ mɑɑ rɛ nɛ Uléécɑɑ Kɛpipi lɛ ɑni pɛɛ rɛ Uléécɑɑ kɑm lɑ́mɑɑnkɛɛ? ");
INSERT INTO soy_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","In tɛ ɑ́i Unɛ́sɑ́ɑ mɛwɑi kɑm wɑi, ɑ́ni kɑpɛ nɛ kɛfɑ nɛ́ tɛnɛ. ");
INSERT INTO soy_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Amɑ́ in tɛ mɛ̃ kɑm wɑi, ḿpɑ́ nɔnsɑ́ n lɑ nɔkɛ́ nɛ kɛfɑ nɛ́ tɛnɛ, ɑni kɔ mɛ̃ kerí nɛ kɛfɑ tɛnɛ, ɑni pɛɛ kɛkéripi ceru rɛ Unɛ́sɑ́ɑ yɛ kɛnɛ́mɛɛ welɛ, nɛ́ɛn kɔ Unɛ́sɑ́ɑ kɛ́mɛɛ we. ");
INSERT INTO soy_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Api kɔ n nɑ́ɑ́si pikɛ́ u tĩ, ɑmɑ́ uú nɛ pi ŋmɛ́hɛrɛɛ. ");
INSERT INTO soy_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Kei kɛ Yeesu uu kɔ yisi uu Yuritɛɛ nkoi pitɛ́ŋ́ pɛlɛ, uú hɑ kei kɛ Yohɑni uú pɛɛ mɛkɛɛ pisoi míni n wólɛ tonɛ. ");
INSERT INTO soy_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Pisoi kulúi pin kei ukɛmɛɛ sɔ́nɑɑpɔ ɑpi yɛ rɛ: Yohɑni úu mɛwɑisɑŋɑ mɛ́kɑ wɑ. Amɑ́ mmɛ̃ nnɛ́í kuu utisi nkó kɛcɑ́ɑ́ ḿ mɑ yɛ ɑsei ritikilɛ. ");
INSERT INTO soy_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Kei kɛ pisoi mɛyɑ̃ ɑpi pɛɛ́ nɛ Yeesu kɛfɑ tɛnɛ. ");
INSERT INTO soy_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Utisi unyinɛ yɛɛ pɛɛ́ we un pɔ́ɔ́lú, ɑpi yɛ u séi rɛ Lɑsɑɑ. Mɑɑri nɛ umɑ́ɑ Mɑritɑ kuyu Petɑnii-pɔ kuú pɛɛ́ we. ");
INSERT INTO soy_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mɑɑri uyɛɛ Upíimɑ ɑnɑ tulɑɑli kɔɔnu uú nɛ unnyúpi tinnɛ. Uuyɛi Lɑsɑɑ yɛɛ pɛɛ pɔ́ɔ́lú. ");
INSERT INTO soy_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Lɑsɑɑ piyɛi pɛ̃ kɛtɛ́ ɑpi Yeesu kɛ́mɛɛ tum ɑpí hɑ u mɑɑ rɛ: Upíimɑ, usoi uyɛ̃ kɑɑ nní ń lɑ yɛ pɔ́ɔ́lúlɛ. ");
INSERT INTO soy_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Kɛ Yeesu uu nsímɛ́ mmɛ̃ n kṍ, uu rɛ: Ái nkpɔ itoi kuu pɔ́ɔ́lú, ɑmɑ́ Uléécɑɑ ukɛ́ nɛ ríyu n yɛ̃́ nnyɑ kuu pɔ́ɔ́lú. Kei kɑi yɛ́ kɔ nɛ Uléécɑɑ Kɛpipi ríyu wɑisɛ. ");
INSERT INTO soy_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yeesu yɛ pɛɛ Mɑritɑ nɛ uwɑ̃́ Mɑɑri nɛ Lɑsɑɑ lɑlɛ. ");
INSERT INTO soy_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Kuu pikómɛ ḿ mɑsí rɛ Lɑsɑɑ yɛ pɔ́ɔ́lú mɛmɑ́ɑ́, uu kei kuú pɛɛ ń we siyɑ́ɑ sitɛ́ kɛtónɛ kpɑ́. ");
INSERT INTO soy_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Uu pɛɛ upipirɛtiki mɑɑ rɛ: Tɔkɛ́ Yutee kɛtẽ-mɛ̃ pɛlɛ. ");
INSERT INTO soy_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Upipirɛtiki ɑpi u pɛsɛ rɛ: Ucélɑɑ, ɑ́i kɑhɑnɛ n nɑ́ŋɑi kɛ Pisuifi ɑpí pɛɛ kei-pɔ lɑ pikɛ́ ɑpɑrɛ pɔ́ tɑpisi pikɛ́ kpu. Kei kɑɑ kɔ lɑ pɔkɛ́ pɛlɛ nɛ́ɛ? ");
INSERT INTO soy_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yeesu uu pi pɛsɛ rɛ: Kɑi yɛ nní n weesi, ituŋɛ yɛɛ leemɛlɛ nɛ́ɛ íi yɛ leemɛ? Úye un nɛ mɛtuŋɛtɛí n sɔ́nɛ, úu yɛ rikpɔu. Li we rɛ u yɛ kɛtẽ nkɛ́ kɛcɑ́ɑ́ mɛtɛ́í n nyɑ́nilɛ. ");
INSERT INTO soy_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Amɑ́ úye un kɛsinɛ n sɔ́nɛ, u yɛ rikpɔulɛ rɛ mɛtɛ́í ɑ́mɛ ukɛmɛɛ́ we nnyɑ. ");
INSERT INTO soy_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Kɛ Yeesu uu lɛ̃ pimɑ́ɑ ḿ mɑsí, uu kɔ kpɑ́ rɛ: Urɔ́sɑ́nɛ Lɑsɑɑ yɛ lɔnilɛ. Nɛ sinlɛ kɛ́ hɑ u yóŋsɛ. ");
INSERT INTO soy_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Upipirɛtiki ɑpi u mɑɑ rɛ: Upíimɑ, in tɛ u lɔnilɛ, u yɛ́ peí. ");
INSERT INTO soy_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Lɑsɑɑ nkpɔ nsímɛ́ kɛ Yeesu uu lɛ̃ tee. Upipirɛtiki pɔ́ɔn músu rɛ nnɔni yíkíyiki nsímɛ́ kuu símisi. ");
INSERT INTO soy_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Yeesu uu pɛɛ pi luru rɛ: Lɑsɑɑ yɛ kpulɛ. ");
INSERT INTO soy_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nɔ̃́ nnyɑ kɑi nɛ́ lɑ́ɑ́rú rɛ ɑ́m pɛɛ likumúŋɛ́ kpɛ-i kei we. Li lɛ̃ wɑlɛ rɛ nɔkɛ́ nɛ kɛfɑ nɛ́ n tɛnɛ nnyɑ. Tɔkɛ́ nkpéni ukɛmɛɛ tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Kei kɛ Tomɑɑ kɑpi rinyíri n hɛ rɛ Úsikɑ uu pɛɛ pipirɛtiki tɔrɔɔ mɑɑ rɛ: Ani mpɔ tɔ́ɔkɛ́ kɔ hɑ, tɔ́ nɛ uyɛ̃ tɔkɛ́ hɑ kɛsẽ́ kpu. ");
INSERT INTO soy_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Kɛ Yeesu uu n tuipɔ, uu kóm tɛ Lɑsɑɑ yɛ nhórɛ kɛ́mɛɛ siyɑ́ɑ sinɑ piwɑi mɑsilɛ. ");
INSERT INTO soy_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Petɑnii yɛ nɛ Yerusɑlɛm kɔlɛnlɛ yɑrɛ kilomɛtiri pitɑɑni kumúŋɛ́. ");
INSERT INTO soy_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Pisuifi mɛyɑ̃ yɛ pɛɛ Mɑritɑ nɛ Mɑɑri piyɑ́hɑɑ kɑlɛ pikɛ́ piuyɛi nkpɔ pi riyɑ́kɑsɛ. ");
INSERT INTO soy_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Kɛ Mɑritɑ uu n kṍ tɛ Yeesu yɛ nnyɑ́ɑ̃ wɑimɛ, uu yisi uu u tɛ́pɛi, Mɑɑri pɔ́ɔ kɛ́yɔ-i tonɛ. ");
INSERT INTO soy_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mɑritɑ uu Yeesu mɑɑ rɛ: Upíimɑ, pɔn pɛɛ nté n we, unɛ́yɛ́i úu yɛ́ pɛɛ kpu. ");
INSERT INTO soy_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Amɑ́ nɛ nyulɛ rɛ ḿpɑ́ nkpéni, Uléécɑɑ yɛ́ lɛ̃ nnɛ́í kɑɑ u m pisɛnɛ pɔ́ pɑ. ");
INSERT INTO soy_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yeesu uu u mɑɑ rɛ: Upɔ́yɛ́i yɛ nkpɔ kɛ́mɛɛ yisinɛ. ");
INSERT INTO soy_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mɑritɑ uu rɛ: Nɛ nyulɛ rɛ u yɛ́ kɑm uu kɛyɑ́ɑ tɔrɔɔ kɛtúŋɛ́ kɛ pikpɔkpɔ ɑpi n yisinɛ yisi. ");
INSERT INTO soy_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yeesu uu u mɑɑ rɛ: Nɛ́ɛ yɛ pikpɔkpɔ yukusɛ, nɛ́ɛ kɔ nfɑ́ɑ. Usoi nkó yɛɛ nɛ kɛfɑ nɛ́ n tɛnɛ yɛ nfɑ́ɑ wɑinɛ, ḿpɑ́ un píyei n kpu. ");
INSERT INTO soy_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Nkó yɛɛ nfɑ́ɑ m mɑ́ un pɛɛ́ nɛ kɛfɑ nɛ́ tɛnɛlɛ̃ úu píkɑi kpinɛ. Pɔ lɛ̃ ŋmurɛii? ");
INSERT INTO soy_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Mɑritɑ uu u pɛsɛ rɛ: Ɛɛɛ Upíimɑ, nɛ nɛ kɛfɑ tɛnɛ rɛ pɔ̃́ kɛ Uléécɑɑ uu wɛ́ɛ. Pɔ́ɔ Uléécɑɑ Kɛpipi kɛɛ kɛtẽ kɛcɑ́ɑ́ mɛ́kɑmɛ m mɑ́. ");
INSERT INTO soy_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Kɛ Mɑritɑ uu lɛ̃ pimɑ́ɑ ḿ mɑsí, uu yisi uu tɔ́mpɔ, uú hɑ uwɑ̃́ Mɑɑri séi uu u wɛ́í-wɛ́í rɛ: Ucélɑɑ yɛ kɑlɛ, u pɔ́ séilɛ. ");
INSERT INTO soy_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Kɛ Mɑɑri uu lɛ̃ n kṍ, uu mɛsɛ nɛ mɛsɛ yisi uu Yeesu tɛ́pɛi. ");
INSERT INTO soy_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yeesu úu pɛɛ kɑhɑnɛ kuyu kpɛ-i n lompɔ. Kei kɛ Mɑritɑ uú pɛɛ́ nɛ u rinsɑ́nɛ cirɛ kuú pɛɛ́ kɔ nɛ lɛ̃ we. ");
INSERT INTO soy_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Pisuifi pɛɛ pɛɛ Mɑɑri kɛyɔ-i ń we pin nkpɔ u yɑ́ɑ́si, ɑpi yɛ́nu rɛ u riwɑkɑsilɛ uu léepɔ. Api yisi ɑpi u tiki. Pi pɛɛ lɛ̃ músulɛ rɛ rikpíí-i kuu sĩ́ ukɛ́ hɑ tẽ́. ");
INSERT INTO soy_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Kɛ Mɑɑri uu kei kɛ Yeesu uu ń we n tuipɔ, uu uɑnɑ mɛtene lólu uu u mɑɑ rɛ: Upíimɑ, pɔn pɛɛ nté n we, unɛ́yɛ́i úu yɛ́ pɛɛ kpu. ");
INSERT INTO soy_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Kɛ Yeesu uu n yɛ̃́ tɛ Mɑɑri yɛ ténilɛ, Pisuifi pɛɛ u rintíkipɔ pɔ́ɔn kɔ téni, ɑi u lémesi uripɔɔ ɑri cɑɑi hɑ́i, ");
INSERT INTO soy_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","uu pɛɛ pi pisɛ rɛ: Yei kɑni u wɑ? Api u pɛsɛ rɛ: A kɑm ɑ yɛ̃, Upíimɑ. ");
INSERT INTO soy_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yeesu uu téni. ");
INSERT INTO soy_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Pisuifi ɑpi pɛɛ rɛ: A tíyɛ u pɛɛ u lɑ kpɑ! ");
INSERT INTO soy_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Pikɛcɔpɛ pinyinɛ pɔ́ɔ rɛ: Uyɛɛ unyíyɛ inipɛɛ n wúkulɛ úu yɛ́ pɛɛ fe uu wɑi usoi nkó úu yɛ kpuu? ");
INSERT INTO soy_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ai Yeesu pilémɑɑ kpɑ́, uripɔɔ ɑri cɑɑi hɑ́i uu yisi uu rikpíí-i tɔ́mpɔ. Kupɑrɛpoo kunyinɛ yɛ ku kɑpi nnɔ́ɔ-i mɛpɑrɛ rińfi. ");
INSERT INTO soy_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yeesu uu pi mɑɑ rɛ: Ani kɛpɑrɛ lesɛ. Ukpɔkpɔ uyɛi, Mɑritɑ uu Yeesu mɑɑ rɛ: U nkpéni pikpɑ́hɑi mɑsí, Upíimɑ. Kuú nɛ n kpu, li siyɑ́ɑ sinɑ piwɑi mɑsilɛ. ");
INSERT INTO soy_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yeesu uu u pɛsɛ rɛ: Ám pɔ́ mɑɑ rɛ pɔn nɛ kɛfɑ n tɛnɛ, pɔ́ yɛ̃́ tɛ Uléécɑɑ yɛ ríyu mɑ́lɛɛ? ");
INSERT INTO soy_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Kei kɑpi pɛɛ kɛpɑrɛ wúkulɛ, Yeesu uu kɛléécɑɑ weríí uu rɛ: Sɑ́ɑ, nɛ pɔ́ pɔɔnɛsɛ rɛ pɔ nɛ kutu nɛ́ ricɔ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nɛ̃́ nɛ nyulɛ rɛ mɛsɛ́rɛ kɑɑ́ nɛ kutu nɛ́ cɔ́lɛ̃. Amɑ́ pisoi riwúí píimɑ ntí tɛɛ nní nɛ́ n kɑ́lɑɑlɛ̃ nnyɑ kɑm lɛ̃ mɑ rɛ pikɛ́ fe pikɛ́ nɛ kɛfɑ tɛnɛ rɛ pɔ́ɔ nɛ́ tummɛ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Kuu lɛ̃ pimɑ́ɑ ḿ mɑsí, uu cɑ́ɑ́i ɑi cɑ́ rɛ: Lɑsɑɑ, ɑ leemɛ! ");
INSERT INTO soy_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Usoi uu kei nní yisi uu léeri, uɑnɑ nɛ uɑnipɛ ɑn sisɑ́ŋɑ́ɑ́pɑmpi pílɑɑnkɛɛlɛ̃, ukɛyu kɛn kusɑ́ŋɑ́ɑ́ yɑ́riilɛ̃. Yeesu uu pɛɛ pi mɑɑ rɛ: Ani u fénnɛntɛ ɑni u yɑ́ ukɛ́ tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Pisuifi mɛyɑ̃ pɛɛ Mɑɑri kɛyɔ-i n hɑ́pɔ ɑpi lɛ̃ kɛ Yeesu uu n wɑ yɛnu, ɑpí nɛ kɛfɑ u tɛnɛ. ");
INSERT INTO soy_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Amɑ́ picɔ pɔ́ɔ sĩ́, ɑpí hɑ lɛ̃ kɛ Yeesu uu n wɑ Pifɑrisi kɛɛnkɛɛ. ");
INSERT INTO soy_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Kei kɛ pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ nɛ Pifɑrisi ɑpi pitúhɑɑnɛ píimɑ cɑ́pinɛ ɑpi rɛ: Íye kɑri wɑinɛ? Usoi nkó yɛ mɛwɑisɑŋɑ wɑpisilɛ hɑ́i! ");
INSERT INTO soy_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Tɔn n tíyɛ un lɛ̃ n wɑi, pisoi nnɛ́í yɛ́ nɛ kɛfɑ u tɛnɛ, Rɔm pikɔ́ ɑpi pɛɛ́ weri ɑpi Uléécɑɑ kɛyɔ foru ɑpí nɛ kurɔ́yu pɛ́nɛ. ");
INSERT INTO soy_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Pisuifi piwɛ́ɛ́sɛ pɛ̃ usɛ kɑpi yɛ sée rɛ Kɑyifu. Uyɛɛ pɛɛ kuŋmɛ̃ kpɛ̃ Uléécɑɑ isinɑ tũ. Uyɛ̃ uu pɛɛ pi mɑɑ rɛ: Áni ńkɑ kómɛi! ");
INSERT INTO soy_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Áni yɛ̃ tɛ li nɛ kutɔsi nɔ́ we rɛ usoi usɛ ukɛ́ nɔ́nnɛnɛ́í nkpɔ kpu, kuyu nnɛ́í ɑ́ku kɑpɛ nɛ mɛ́woo rinsɛ́ɛ́ nnyɑɑ? ");
INSERT INTO soy_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ái rɛ ukɛmúŋɛ́ cirɛ kuú nɛ lɛ̃ mɑ. Kɑi nní uyɛɛ pɛɛ likumúŋɛ́ kpɛ-i Uléécɑɑ usinɑ nnyɑ kuú nɛ Uléécɑɑ rinyiri símisi rɛ Yeesu yɛɛ Pisuifi kɛcɑ́ɑ́ kpinɛ. ");
INSERT INTO soy_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ái kɔ Pisuifi kɛcɑ́ɑ́ ŋmɑnɛ nnyɑ kuu kpinɛ, ɑmɑ́ li pisɛ rɛ ukɛ́ kpu ukɛ́ nɛ Uléécɑɑ sipipi sɛɛ kɛtẽ nnɛ́í kɛcɑ́ɑ́ n yɛkɑɑlɛ̃ cɑ́pinɛ sikɛ́ pɑnsɛ pisoi pisɛ. ");
INSERT INTO soy_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kɑí nɛ kɛyɑ́ɑ kɛ̃ n kpísi, Pisuifi piwɛ́ɛ́sɛ ɑpi rinɔ́ɔ risɛ wɑi rɛ pikɛ́ Yeesu kpu. ");
INSERT INTO soy_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Lɛ̃ nnyɑ, Yeesu úu yɛ pɛɛ Pisuifi kɛcɔpɛ pinyɛ́rɛi rikpɑ́ pikɛ́ u n nyɑ́ni. Uu pɛɛ yisi uu kɛtẽ kɛnyinɛ kɛɛ nɛ kucɛsi kóimɑ n kɔ́lɛ̃-mɛ̃ tɛ́ŋ́, u nɛ upipirɛtiki ɑpí hɑ kei-pɔ n we. Pi yɛ kei sée rɛ Efirɑyim. ");
INSERT INTO soy_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Isirɑyɛɛli pikɔ́ nkpɔ mɛlɔ́ɔ́ ɑnyɑ̃́ yɛ pɛɛ nyɑhɑimɛlɛ. Lɛ̃ nnyɑ kɛ kei pikɔ́ mɛyɑ̃ ɑpi yisi ɑpi Yerusɑlɛm sĩ tɛ pikɛ́ hɑ inyɔ́ɔnsɛ inyɛkii wɑ ɑnyɑ̃́ ɑkɛ́ kɛlenɛ tu. ");
INSERT INTO soy_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Api Yeesu wɛ́lɑɑnkɛɛ, ɑpi pɛɛ Uléécɑɑ kɛyɔ-i n we pin pɛɛ pimɛcɔpɛcirɛ písɛinɛ rɛ: Ń-ye kɑni músu? Yɑrɛ u yɛ́ kɑm nɛ́ɛ úu yɛ́ kɑm? ");
INSERT INTO soy_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ nɛ Pifɑrisi yɛ pɛɛ rinɔ́ɔ pihɛɛ mɑsilɛ rɛ: Úye un ukɛlõ n nyu, ukɛ́ símisi pikɛ́ fe pikɛ́ u tĩ. ");
INSERT INTO soy_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Lin tisɛlɛ̃ siyɑ́ɑ sikpuulũ pikɛ́ kɛlenɛ nkpɔ mɛlɔ́ɔ́ ɑnyɑ̃́ li, Yeesu uu yisi uu Petɑnii tɔ́mpɔ. Kei kɛ Lɑsɑɑ kuú pɛɛ pikpɔkpɔ kɛ́mɛɛ n yukusɛ uú we. ");
INSERT INTO soy_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Api kusɑ́nɛ u wɑi, Mɑritɑ un ilukɛ hɔɔnɛntɛ, Lɑsɑɑ pɔ́ɔn pɛpɛɛ ilukɛ kɛlukɛ-i Yeesu kɛkúrí ń tṹ kɛcɔpɛ we. ");
INSERT INTO soy_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mɑɑri uu pɛɛ tulɑɑli pɑpɛ-pɑpɛ yɛɛ nnɛ́í píimɑ m mɑ́ kɛnúḿpi kpísi, uu Yeesu ɑnɑ kɛcɑ́ɑ́ kɔɔni uu pɛɛ unnyúpi nɛ Yeesu ɑnɑ tinnɛ. Tulɑɑli kukpɑ́hɑ́ ɑku kɛ́yɔ yipu. ");
INSERT INTO soy_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Yeesu pipirɛtiki kɛcɔpɛ usɛ kɑpi yɛ n sée rɛ Yutɑsi Isikɑriyɔɔti yɛɛ ń kɑ uu Yeesu pilɑ́ɑrɔ ɑnipɛ-i wɑi, uu pɛɛ rɛ: ");
INSERT INTO soy_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Yo nnyɑ kɑ́pi tulɑɑli pɑpɛ-pɑpɛ nkó yɑ́ɑ́ nɛ nnɛ́í píimɑ pikɛ́ siwóó píwɛkɔɔ́ hɛ? ");
INSERT INTO soy_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ái rɛ píwɛkɔɔ́ nfɑsimɛ́ kuu wɑi nnyɑ kuu lɛ̃ mɑ. U pɛɛ uyɑɑ lɛ. Kuu nní kuwóólɔɔ m múílɛ̃ nnyɑ, u yɛ pɛɛ lɛ̃ kɑpi kɛ́mɛɛ n wɑipɔ yɑ́ɑilɛ. ");
INSERT INTO soy_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yeesu uu u mɑɑ rɛ: A unɔ́si nkó riyɑ́ sɛ́ɛ́ɛ! U lɛ̃ wɑlɛ un nɛ kɛyɑ́ɑ kɛ̃ kɑpi nhórɛ-i nɛ́ n tɑninɛ músu. ");
INSERT INTO soy_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Mɛsɛ́rɛ kɛ píwɛkɔɔ́ ɑpi yɛ́ nɔ́kɛnɛ́kúrí n we, ɑmɑ́ nɛ̃́ ɑ́m mɛsɛ́rɛ nɔ́kɛnɛ́kúrí wenɛ. ");
INSERT INTO soy_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Pisuifi kulúi yɛ pɛɛ kṍ tɛ Yeesu yɛ Petɑnii-i we. Api sĩ́ kulúi, ɑ́i uyɛ̃ ŋmɑnɛ nnyɑ, ɑmɑ́ pikɛ́ kɔ nɛ Lɑsɑɑ kuu pikpɔkpɔ kɛ́mɛɛ n yukusɛ n yɛ̃́ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ ɑpi símisi ɑí tonɛ rɛ pikɛ́ kɔ Lɑsɑɑ pɔ̃́ kɔ kpu ");
INSERT INTO soy_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","rɛ Pisuifi mɛyɑ̃ yɛ pɛɛ pi yɑ́lɛnlɛ pin uyɛ̃ nnyɑ Yeesu nɛ kɛfɑ tɛnɛ. ");
INSERT INTO soy_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Kɑi kóso n weesi, pisoi kulúi píimɑ pɛɛ nkpɔ mɛlɔ́ɔ́ ɑnyɑ̃́ pinyɑ́nɛi n hɑ́pɔ, ɑpi kóm tɛ Yeesu yɛ Yerusɑlɛm-i sɔ́nɛpɔ. ");
INSERT INTO soy_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Api pinnɛ́í ɑtɛnɛpɑi kpɑsi ɑpi síkɑ ɑpí nɛ u tɛ́pɛi, pin cɑ́ɑ́i rɛ: Osɑnnɑ! Ani uyɛɛ n sɔ́nti nɛ Upíimɑ rinyiri ritɑɑ́sɛ. Uyɛɛ Isirɑyɛɛli pikɔ́ uyɔɔpi. ");
INSERT INTO soy_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yeesu uu kɛminɑɑpipi kɛnyinɛ yɛnu, uu kɛkɛcɑ́ɑ́ tonɛ yɑrɛ kɑi n wɔ́lɑɑlɛ̃ tɛ: ");
INSERT INTO soy_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Nɔ̃́ Siyɔɔ kuyu pikɔ́, iwɑmɛ íi kɑpɛ nɔ́ wɑ. Ani ripɑí, nɔ́unɛ́yɔ́ɔpi yɛɛ nní kɛminɑɑyɑhɑ kɛpipi kɛcɑ́ɑ́ tṹ un nɛ wemɛ. ");
INSERT INTO soy_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Upipirɛtiki ɑ́pi pɛɛ lɛlɛɛ n wɑi ɑsei kõ kɛlenɛ. Amɑ́ kɛ Uléécɑɑ uu Yeesu ríyu n wɑisɛ kɑpi pɛɛ léisɛ rɛ lɛ̃ kɛ pisoi ɑpi nní u n wɑ kɑí pɛɛ mɛkɛɛ-mɛ ukɛcɑ́ɑ́ wɔ́lɑɑlɛ̃. ");
INSERT INTO soy_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Pɛ̃ nnɛ́í pɛɛ pɛɛ Yeesu kɛkúrí ń we kumúŋɛ́ kpɛ-i kuú pɛɛ Lɑsɑɑ nhórɛ-i n sée uu lésɛri uu kɔ pikpɔkpɔ kɛ́mɛɛ u yukusɛ, ɑpi lɛ̃ kɑpi n yɛ̃́ pisoi kɛɛnkɛɛ. ");
INSERT INTO soy_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Lɛ̃ nnyɑ kɛ pisoi riwúí ɑri pitɛ́pɛi u hɑ. Pisoi yɛ pɛɛ kónlɛ rɛ u mɛwɑisɑŋɑ mɛ̃ wɑlɛ. ");
INSERT INTO soy_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Pifɑrisi ɑpi pɛɛ símɑɑnɛ rɛ: Nɔ nyɑ́ni rɛ mɛ́woo kɑni wɑi. Pisoi nnɛ́í pɛɛ nní u tikilɛ̃. ");
INSERT INTO soy_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Pikirɛki pinyinɛ pɔ̃́ nɛ kɔ pɛɛ ɑnyɑ̃́ kumúŋɛ́ kpɛ-i pɛpɛɛ Yerusɑlɛm ń hɑ pikɛ́ hɑ Uléécɑɑ yɑ́ɑ́si kɛcɔpɛ welɛ. ");
INSERT INTO soy_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Api Kɑlilee kɛtẽ-pɔ Petisɑyitɑ ukɔ́ Filipu kɛkúrí nyɔsɔ́pɔ ɑpi u mɑɑ rɛ: Urɔ́sɑ́ɑ, tɔ pɛɛ́ lɑ rɛ tɔkɛ́ Yeesu yɛ̃. ");
INSERT INTO soy_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipu uu sĩ́ uú hɑ lɛ̃ Antiree símisi, pikɛtɛ́ ɑpí hɑ nɛ Yeesu símisi. ");
INSERT INTO soy_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yeesu uu pi pɛsɛ rɛ: Li nkpéni ituŋɛ tulɛ rɛ Usoi Kɛpipi kɛkɛ́ ríyu yɛ̃. ");
INSERT INTO soy_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Asei kɛcɑ́ɑ́, kɛ́ nɔ́ símisi rɛ tilukɛpipi tinsɑ́ n loó tikɛ́ kpu, timɛcirɛ kɑri yɛ n we. Amɑ́ tin n kpu, ti yɛ ɑpipi kulúi mɑrilɛ. ");
INSERT INTO soy_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Nkó yɛɛ unfɑɑ ń lɑ yɛ́ kɑm uu n fómni. Amɑ́ nkó yɛɛ úu kɛtẽ nté unfɑɑ n kpísi ukɛ́ wɑisɛ linyinɛ, úu n fómninɛ, ɑmɑ́ nfɑ́ɑ tɛnɛcirɛ́ kuu yɛ́nunɛ. ");
INSERT INTO soy_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Úye un n lɑ ukɛ́ pikɛi nɛ́ wɑ, ukɛ́ nɛ́ n tikilɛ̃. Kei kɑm ń we kɛ unɛ́kɛikɔ́ pɔ́ɔ kɔ sɔ́nti ukɛ́ n we. Úye un pikɛi nɛ́ n wɑi, Sɑ́ɑ yɛ́ ríyu u wɑisɛ. ");
INSERT INTO soy_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Lɛ̃ mɛmɑ́ɑ́, Yeesu uu pɛɛ rɛ: Tinɛ́pɔ́ɔ yɛ nkpéni cɑɑilɛnlɛ. Nɛ́ nkpéni rɛ íye? Tɛ Sɑ́ɑ, kɑpɛ tíyɛ kɛ́ ntóósi ituŋɛ nnyí kɛ́mɛɛ lompɔ nɛ́ɛ? Lɛ̃ nnyɑ kɑm kɔ pɛɛ́ kɑ. ");
INSERT INTO soy_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Sɑ́ɑ, ɑ ripɔ́nyíri ritɑɑ́sɛ! Kei kɛ mɛtẽ mɛnyinɛ ɑmɛ kɛyómɛcɑɑ-pɔ leemɛ ɑmɛ rɛ: Nɛ pítɑɑ́sɛ ri mɑsilɛ, nɛ́ kɔ pítɑɑ́sɛ rikpɑ́nɛ. ");
INSERT INTO soy_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Pisoi pɛɛ kei n cɑ́pinɛlɛ̃ ɑpi lɛ̃ kom ɑpi rɛ: Ikónɛ yɛɛ ŋmurɛi. Picɔ ɑpi rɛ: Uléécɑɑtumɛ unyinɛ yɛɛ nɛ u símisi! ");
INSERT INTO soy_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Kei kɛ Yeesu uu pɛɛ pi mɑɑ rɛ: Ái nɛ̃́ nnyɑ kɛ mɛtẽ mmɛ́ ɑmɛ léemɛ, ɑmɑ́ nɔ̃́ nnyɑ yɛ ni. ");
INSERT INTO soy_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Nkpéni kɛ ituŋɛ ii tu rɛ pikɛ́ nɛ kɛtẽ nkɛ́ pisoi túhɑɑnɛ. Nkpéni kɛ ituŋɛ ii tu rɛ pikɛ́ kɛtẽ uyɔɔpi lɑkɑsɛ. ");
INSERT INTO soy_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Amɑ́ kumúŋɛ́ kpɛ-i kɑpi kɛléécɑɑ nɛ́ n síkɑnɛ, nɛ̃́ nɛ́ tíyɛsɛ pisoi nnɛ́í ɑpi kɛnɛ́mɛɛ weri. ");
INSERT INTO soy_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Nkpɔ mmɛ̃ kuu n sɔ́nti ukɛ́ ń kpu nsímɛ́ kuu lɛ̃ pi símisi. ");
INSERT INTO soy_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Pisoi pɛɛ n cɑ́pinɛlɛ̃ ɑpi u pɛsɛ rɛ: Tɔ irɔ́sé ritɛlɛ́-i kɛ́ɛ́nlɛ rɛ mɛsɛ́rɛ kɛ uyɛ̃ kɛ Uléécɑɑ uu n wɛ́ɛ uu yɛ́ nfɑ́ɑ m mɑ́. Yo nnyɑ kɛ pɔ́ɔ pɛɛ rɛ: Li pisɛ rɛ pikɛ́ Usoi Kɛpipi kɛléécɑɑ risíkɑ? Wóo pɛɛ nkpéni Usoi Kɛpipi kɛ̃? ");
INSERT INTO soy_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yeesu uu pi pɛsɛ rɛ: Mɛtɛ́í yɛ kɔ nɛ nɔ́kɛnɛ́cɔpɛ welɛ. Amɑ́ ɑ́mɛ pɛɛ nɑ́ŋɑinɛ. Ani nkpéni kɛ mɛtɛ́í ɑmɛ nní ń we n sɔ́nɛ, kuŋmɑhɑ ɑ́ku kɑpɛ nɛ nɔ́ rinkɑ́ikɑi nnyɑ. Nkó yɛɛ kuŋmɑhɑ-i n sɔ́nɛ úu nyu mɛ́ye kuu sĩ́. ");
INSERT INTO soy_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Lɛ̃ nnyɑ, kɑni nkpéni nní mɛtɛ́í m mɑ́, ɑni nɛ kɛfɑ mɛ tɛnɛ nɔkɛ́ nɛ m pɑnsɛ mɛtɛ́í sipipi nnyɑ. Kɛ Yeesu uu lɛ̃ pimɑ́ɑ ḿ mɑsí, uu tɔ́mpɔ uú nɛ kɛtɑɑ pi wɑi uú hɑ pésu. ");
INSERT INTO soy_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ḿpɑ́ kuu mɛwɑisɑŋɑ kulúi pikɛyu-i n wɑpisi, ɑ́pi ŋmurɛi pikɛ́ nɛ kɛfɑ u tɛnɛ. ");
INSERT INTO soy_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Lɛ̃ kɛ ɑntepu Esɑyi uú pɛɛ mɛkɛɛ ḿ mɑ kɑi lɛ̃ wɑ rɛ: Upíimɑ, wóo ntɔ́símɛ́ kɑri n símisi ŋmurɛi? Úye kɛ Upíimɑ uu unnɑŋɛ kuú nɛ n kɛisi nyísɛ? ");
INSERT INTO soy_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Lɛlɛɛ n tíyɛsɛ kɑ́pi yɛ́ nɛ n fe pikɛ́ nɛ kɛfɑ n tɛnɛ yɛɛ lɛ̃ kɛ Esɑyi uu kɔ ḿ mɑɑ rɛ: ");
INSERT INTO soy_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Uléécɑɑ yɛ pi nyiinsɛlɛ rɛ ɑ́pi kɑpɛ nɛ n nyɑ́ni nnyɑ. U pimɛsɔhɔ yɑriilɛ rɛ ɑ́pi kɑpɛ nɛ líkɑ ɑsei n kṍ nnyɑ. Insɑ́ lɛ̃, pi yɛ́ ukɛmɛɛ́ hɑ uu pi pɔisɛ. ");
INSERT INTO soy_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Kɛ Esɑyi uu Upíimɑ mɛyɔɔpi n yɛ̃́ nnyɑ kuu fe uu lɛ̃ mɑlɛ. ");
INSERT INTO soy_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ḿpɑ́ nɛ lɛ̃, Pisuifi piwɛ́ɛ́sɛ kɛcɔpɛ, mɛyɑ̃́ yɛ pɛɛ́ nɛ kɛfɑ Yeesu tɛnɛlɛ. Amɑ́ Pifɑrisi nnyɑ, ɑ́pi yɛ pɛɛ pisoi kɛcɔpɛ lɛ̃ mɑ rɛ pi yɛ́ kuyómɛyɑ́hɑɑlee-i pi lɑkɑsɛ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Pi pɛɛ́ lɑlɛ pisoi pikɛ́ yɛ ríyu pi wɑisɛ ɑi tɔ́su kɛ Uléécɑɑ uu yɛ́ ríyu pi n wɑisɛ. ");
INSERT INTO soy_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Lɛ̃ mɛmɑ́ɑ́, Yeesu uu pɛɛ cɑ́ɑ́i rɛ: Nkó yɛɛ nɛ kɛfɑ nɛ́ n tɛnɛ úu nɛ nɛ̃́ ŋmɑnɛ kɛfɑ tɛnɛ. Asei kɛcɑ́ɑ́, uyɛɛ nɛ́ n tummɛ kuu kɔ nɛ kɛfɑ tɛnɛ. ");
INSERT INTO soy_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Nkó yɛɛ nɛ́ n nyɑ́ni yɛ uyɛɛ nɛ́ n tummɛ nyɑ́nilɛ. ");
INSERT INTO soy_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nɛ̃́ nɛ mɛtɛ́í lɛ. Nɛ kɛtẽ kɛcɑ́ɑ́ kɑlɛ rɛ uyɛɛ nɛ kɛfɑ nɛ́ n tɛnɛ úu kɑpɛ kuŋmɑhɑ-i n we. ");
INSERT INTO soy_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Úye un nnɛ́símɛ́ n kõ unsɑ́ n tintiki, ɑ́i nɛ́ɛ nɛ u túhɑɑnɛnɛ. Ám kɛtẽ kɛcɑ́ɑ́ kɑ rɛ kɛ́ nɛ pisoi túhɑɑnɛ, ɑmɑ́ nɛ kɑ rɛ kɛ́ piriyu lɔ. ");
INSERT INTO soy_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Nkó yɛɛ nɛ́ ń yɛ, úu kɔ nnɛ́símɛ́ pɑkɑrɛlɛ̃ yɛ utúhɑɑnɛ mɑ́lɛ. Nsímɛ́ mmɛ̃ kɑm nní n símisi mɛɛ hɑ nɛ kɛyɑ́ɑ tɔrɔɔ kɛtúŋɛ́ u túhɑɑnɛnɛ. ");
INSERT INTO soy_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ái kɛnɛ́múŋɛ́ cirɛ kɑḿ nɛ símisi. Amɑ́, Sɑ́ɑ yɛɛ nɛ́ n tummɛ yɛɛ uricuruu lɛ̃ kɑm yɛ́ n símisi nɛ lɛ̃ kɛcɑ́ɑ́ kɑm yɛ́ n céési nɛ́ forii. ");
INSERT INTO soy_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nɛ kɔ nyu rɛ lɛ̃ kuu n forii yɛ̀ɛ̀ nfɑ́ɑ tɛnɛcirɛ́ hɛlɛ. Lɛ̃ nnyɑ, nɛ yɛ lɛ̃ kɑm n símisi símisilɛ yɑrɛ kɛ Unɛ́sɑ́ɑ uu nɛ́ ń forii. ");
INSERT INTO soy_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Lin nɛ weesinɛ pikɛ́ nɛ nkpɔ mɛlɔ́ɔ́ ɑnyɑ̃́ li, Yeesu un nyu rɛ uituŋɛ yɛ tulɛ rɛ ukɛ́ kɛtẽ nkɛ́ kɛcɑ́ɑ́ yisi ukɛ́ Usɑ́ɑ-i pɛlɛ, uu pɛɛ upisoi pɛɛ kɛtẽ kɛcɑ́ɑ́ ń we un pi lɑ, mɛyɑ́nsei pílɑ kpɑ́ nɛ kɛ́tɔ-pɔ. ");
INSERT INTO soy_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Kɑi nnyɔ́ɔ́ n wɑ, u nɛ upipirɛtiki pin tũ pin ilukɛ le. Kuníri pɔ́ɔn Simɔɔ Isikɑriyɔɔti uŋmɑ́nɛ Yutɑsi kɛfɑ-i piwɑi mɑsí rɛ ukɛ́ u tĩ ukɛ́ upilɑɑrɔ pɑ. ");
INSERT INTO soy_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yeesu ricuruu yɛ pɛɛ nyulɛ rɛ Sɑ́ɑ Uléécɑɑ kɛ́mɛɛ kuu léeri, ukɛmɛɛ́ kuu kɔ pɛlɛ, un kɔ nyu rɛ Sɑ́ɑ Uléécɑɑ yɛ ḿpɑ́ yo uɑnipɛ-i wɑlɛ. ");
INSERT INTO soy_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Uu pɛɛ kɛlukɛ-i yisi uu ukutukɑnkɑ cícɑɑ́ mɑhɑni uu kúpɔpɔú kpísi uu kɛhɑlɛ-i té ");
INSERT INTO soy_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","uu pɛɛ limɛmɑ́ɑ́ kucɑ́ri mɑɑ kunyinɛ-i míni súúni, uu upipirɛtiki ɑnɑ pihɛɛrɛ loni, uu kɔ nɛ kúpɔpɔú kuu kɛhɑlɛ-i rinté pitínnɛntɛ loni. ");
INSERT INTO soy_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Uu Simɔɔ Piyɛɛ tulu, uyɛ̃ uu u mɑɑ rɛ: Pɔ̃́ Upíimɑ, ɑ́i pɔ́ɔ yɛ́ pɛɛ mɛníŋɛ nɛ̃́ ɑ́nɑ hɛɛrɛ! ");
INSERT INTO soy_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yeesu uu pɛɛ u pɛsɛ rɛ: Áɑ lɛ̃ kɑm nní n wɑi ɑsei kómɛi kɛlenɛ. Amɑ́ pɔ́ kɑm ɑɑ kɛpirɛ kom. ");
INSERT INTO soy_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Piyɛɛ uu u mɑɑ rɛ: Ái we kpɑ́rɑ́ɑ rɛ pɔkɛ́ nɛ̃́ ɑ́nɑ hɛɛrɛ. Yeesu uu u pɛsɛ rɛ: Nɛnsɑ́ kɔ pɔ́ n hɛɛrɛ, tɔ́ nɛ mpɔ̃́ ɑ́ri yɛ́ fe tɔkɛ́ linyinɛ ripɛ́nɛ. ");
INSERT INTO soy_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Kei kɛ Simɔɔ Piyɛɛ uu pɛɛ u mɑɑ rɛ: In lɛɛ ni, ɑ́i ɑ́nɑ ŋmɑnɛ kɑɑ yɛ́ nɛ́ hɛɛrɛ, Upíimɑ, nɛ ɑnípɛ nɛ ríyu kɑɑ yɛ́ nɛ ripɛ́nɛ! ");
INSERT INTO soy_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Usoi nkó yɛɛ piwólɛ ḿ mɑsí úu yɛ kɔ n wɛ́ɛ́si ukɛ́ piwólɛ rikpɑ́. Insɑ́ ɑ́nɑ kuu yɛ́ hɛɛrɛ. U uipiŋɛ nnɛ́í wólɛlɛ uu funi. Nɔ̃́ nɛ piwólɛ mɑsilɛ ɑni funi, ɑmɑ́ ɑ́i pɛɛ nɔ́nnɛ́nɛ́í. ");
INSERT INTO soy_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yeesu yɛ pɛɛ uyɛɛ pilɑ́ɑrɔ ɑnipɛ-i u n wɑinɛ pinyuwɛ mɑ́ɑ́lɛnlɛ. Lɛ̃ nnyɑ kuú mɑɑ rɛ: Amɑ́ ɑ́i pɛɛ nɔ́nnɛ́nɛ́í kɑni wólɛ ɑni funi. ");
INSERT INTO soy_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Kuu upipirɛtiki ɑnɑ pihɛɛrɛ ḿ mɑsí uu kɔ ukutukɑnkɑ cícɑɑ́ pitɑnɛ pɛsɛ, uu kɛlukɛ-i kɛtónɛ pɛlɛ, uu pi pisɛ rɛ: Nɔ lɛ̃ kɑm nní nɔ́ n wɑ ɑsei konlɛ nníí? ");
INSERT INTO soy_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nɔ nɛ́ sélei rɛ Ucélɑɑ nɛ Upíimɑ. Nɔ ɑlɑri mɑ́lɛ. Nɛ mɛsei lɛ̃ lɛ. ");
INSERT INTO soy_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nɛ́ɛ nní Nɔ́unɛ́píimɑ nɛ Nɔ́unɛ́célɑɑ. Nɛ́ɛn ɑ́nɑ nɔ́ n hɛɛrɛ, li pisɛ rɛ nɔ́ɔkɛ́ yɛ kɔ nɔ́mɛnɛ́cɔpɛcirɛ ɑ́nɑ hɛɛrɛntɛnɛ. ");
INSERT INTO soy_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nɛ lɛ̃ nɔ́ nyísɛlɛ nɔ́ɔkɛ́ yɛ kɔ nɛ n wɑpɑɑnɛ yɑrɛ kɑm nɔ́ n wɑ mɛcɔ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Asei kɛcɑ́ɑ́, kɛ́ nɔ́ símisi rɛ ukɛikɔ́ úu yɛ ukɛisɑɑ n fe. Utumɛ úkɑ úu yɛ uyɛɛ u n tũ n fe. ");
INSERT INTO soy_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nɔ nkpéni lɛ̃ nnɛ́í nyulɛ. Nɔ kpére likɛcɑ́ɑ́ sɔ́nɛ, nɔ́ nkíŋniŋɛ yɛ̃. ");
INSERT INTO soy_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ái nɔ́nnɛ́nɛ́í kɑḿ nɛ mɑ́nɛ. Nɛ pɛ̃ kɑm n wɛ́ɛ nyulɛ. Amɑ́ li pisɛ rɛ lɛlɛɛ Nléécɑɑsimɛ́ ritɛlɛ́-i n wɔ́lɑɑlɛ̃ likɛ́ wɑ. Lɛlɛɛ rɛ: Tɔ́ nɛ uyɛ̃ tɔ́ɔ ricɑ́ripi risɛ-i ilukɛ n le yɛ nɛ nɛ́ pɑnsɛ. ");
INSERT INTO soy_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nɛ nkpéni nsímɛ́ mmú nɔ́ símisilɛ nkɛ́ kɛlenɛ kɑm. Nn píyei n kɑ, ɑni pɛɛ ŋmurɛi rɛ nɛ́ɛ ḿpɑ́ píyei uwee. ");
INSERT INTO soy_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Asei kɛcɑ́ɑ́, kɛ́ nɔ́ símisi rɛ uyɛɛ unɛ́tumɛ ń yɔsí yɛ nɛ́ yɔsilɛ. Uyɛɛ kɔ nɛ́ ń yɔsí yɛ uyɛɛ nɛ́ n tummɛ yɔsilɛ. ");
INSERT INTO soy_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Kɛ Yeesu uu ɑnɔ́ɔ nyɛ̃ pimɑ́ɑ ḿ mɑsí, uripɔɔ ɑri cɑɑi uu rɛ: Asei kɛcɑ́ɑ́, kɛ́ nɔ́ símisi rɛ nɔ́kɛnɛ́cɔpɛ unyinɛ yɛ́ pinɛ́lɑ́ɑrɔ ɑnipɛ-i nɛ́ wɑ. ");
INSERT INTO soy_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Kei kɛ upipirɛtiki ɑpi pɛɛ síyu-i pinyɑ́nɛinɛ lõ pin písɛinɛ rɛ úye kuú nɛ mɑ́nɛ? ");
INSERT INTO soy_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Likumúŋɛ́ kpɛ-i, Yeesu pipirɛtiki kɛcɔpɛ usɛ kuú pɛɛ mɛyɑ̃́ ń lɑ un ukɛcɑ́ɑ́ finu. ");
INSERT INTO soy_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simɔɔ Piyɛɛ uu ukuwɛ́ɛ́-mɛ̃ pɑípɔ uu u pisɛ rɛ úye kuú nɛ mɑ́nɛ. ");
INSERT INTO soy_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Kei kɛ uyɛ̃ uu pɛɛ Yeesu kɛcɑ́ɑ́ finɛpɔ uu u pisɛ rɛ: Upíimɑ, úye kɑɑ́ nɛ mɑ́nɛ? ");
INSERT INTO soy_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yeesu uu u pɛsɛ rɛ: Nɛ́ kɛkpɔ́nɔ́pi iyɛ́hɛ ritɑ. Uyɛ̃ kɑm kɛ ḿ pɑnɛ, uyɛɛ lo. Uu pɛɛ kɛkpɔ́nɔ́pi iyɛ́hɛ tɑ uu Simɔɔ Isikɑriyɔɔti uŋmɑ́nɛ Yutɑsi kɛ pɑ. ");
INSERT INTO soy_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Kɛ Yutɑsi uu kɛkpɔ́nɔ́pi kɛ̃ lɛ̃ ń yɔsí, Setɑni uu u loni. Yeesu uu pɛɛ u mɑɑ rɛ: A hɑ mɛkɛɛ lɛ̃ kɑɑ mɛwɑi m mɑ́ wɑ. ");
INSERT INTO soy_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Pɛ̃ nnɛ́í pɛɛ kɛlukɛ kɛ-i ń we kɛcɔpɛ úkɑ úu kõ yo nnyɑ kuu lɛ̃ u mɑ. ");
INSERT INTO soy_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yutɑsi yɛɛ pɛɛ pikuwóólɔɔ múílɛ̃. Lɛ̃ nnyɑ kɛ pimɛyɑ̃ ɑpi musí rɛ Yeesu yɛ u pisɛlɛ rɛ ukɛ́ hɑ lɛ̃ kɑi ɑnyɑ̃́ kɛ́mɛɛ pi m pisɛ lɔ. Picɔ pɔ́ɔ músu rɛ nɛ́ɛ u u mɑɑ rɛ ukɛ́ linyinɛ kpísi ukɛ́ píwɛkɔɔ́ pɑ. ");
INSERT INTO soy_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yutɑsi uu kɛkpɔ́nɔ́pi kpísi uu mɛsɛ nɛ mɛsɛ leepɔ. Likumúŋɛ́ kpɛ-i, lin kɛsinɛ wɑ. ");
INSERT INTO soy_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Kɛ Yutɑsi uu piléepɔ ḿ mɑsí, Yeesu uu rɛ: Li nkpéni Usoi Kɛpipi ríyu wɑisɛ, ɑi kɔ kɛ̃ nnyɑ Uléécɑɑ pɔ̃́ kɔ ríyu wɑisɛ. ");
INSERT INTO soy_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Lin uyɛ̃ nnyɑ Uléécɑɑ ríyu n wɑisɛ, Uléécɑɑ ricuruu yɛ́ kɔ uyɛ̃ ríyu wɑisɛ. Ái kɔ nɑ́ŋɑinɛ ukɛ́ nɛ lɛ̃ n wɑ. ");
INSERT INTO soy_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Sinɛ́pipi, nkɑ́ripi kɑm kɔ nɔ́kɛnɛ́mɛɛ pitónɛ kpɑ́nɛ. Nɔ́ kɑm ɑni nɛ́ wɛ́ɛ́si. Yɑrɛ kɑm Pisuifi pimɑ́ɑ ḿ mɑsí rɛ: Áni yɛ́ fe nɔkɛ́ kei kɑm n sĩ́ hɑ, limɛcɔ kɑm kɔ nkpéni nɔ̃́ mɑɑnɛ. ");
INSERT INTO soy_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Isé fɑlɛ kɑm nɔ́ pɑ́lɛ̃ tɛ: Ani n lɑkɑɑnɛ. Nɔ́ɔkɛ́ kɔ n lɑkɑɑnɛ yɑrɛ kɛ nɛ́ɛ nɔ́ ń lɑ mɛcɔ. ");
INSERT INTO soy_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nɔn n lɑkɑɑnɛ kɛ ḿpɑ́ úye uu yɛ́ yɛ̃́ tɛ nɔ pinɛ́pirɛtiki lɛ. ");
INSERT INTO soy_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simɔɔ Piyɛɛ uu pɛɛ u pisɛ rɛ: Yei kɑɑ sĩ́, Upíimɑ? Yeesu uu u pɛsɛ rɛ: Áɑ yɛ́ nkpɑ́ni fe pɔkɛ́ kei kɑm n sĩ́ hɑ, ɑmɑ́ pɔ́ kɑm ɑɑ kɛpirɛ nɛ́ tíkipɔ. ");
INSERT INTO soy_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Kei kɛ Piyɛɛ uu kɔ u pisɛ rɛ: Yo nnyɑ kɑ́m yɛ́ fe kɛ́ nkpéni pɔ́ ritiki, Upíimɑ? Tɛ in nkpɔ yɛ mu, nɛ́ mpɔ́kpɔ kpu! ");
INSERT INTO soy_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yeesu uu u pɛsɛ rɛ: In tɛ nkpɔ yɛ mu, pɔ́ nnɛ́kpɔ kpu, nɛ́ɛ yo? Asei kɛcɑ́ɑ́, kɛ́ pɔ́ símisi rɛ icɑ̃́ ikɛ́ kɛlenɛ n kooi, pɔ́ kɛ́si mɛtɑɑni rɛ ɑ́ɑ nɛ́ nyu. ");
INSERT INTO soy_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yeesu uu kɔ upipirɛtiki pimɑ́ɑ kpɑ́ rɛ: Nɔ́rinɛ́pɔ́ɔ ɑ́ri kɑpɛ n cɑɑilɛ̃. Ani Uléécɑɑ nɛ kɛfɑ tɛnɛ ɑni kɔ nɛ̃́ nɛ kɛfɑ tɛnɛ. ");
INSERT INTO soy_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Sitónɛ yɛ Unɛ́sɑ́ɑ kɛyɔ-i kulúi welɛ. Nɛ sinlɛ kɛ́ hɑ kɛtónɛ nɔ́ nyɔ́ɔnsɛ. Insɑ́ pɛɛ lɛ̃, ɑ́m yɛ́ pɛɛ nɔ́ símisi rɛ nɛ sinlɛ kɛ́ hɑ kɛtónɛ nɔ́ nyɔ́ɔnsɛ. ");
INSERT INTO soy_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nɛn n hɑ kɛtónɛ pinyɔ́ɔnsɛ nɔ́ m mɑsí, nɛ pɛɛrilɛ kɛ́ nɔ́ kpísi kɛ́ nɛ ripɛ́nɛ, nɔ́ɔkɛ́ kɔ nɛ kei kɑm ń we n we nnyɑ. ");
INSERT INTO soy_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Nɔ kɔ kei kɑm n sĩ́ ncee nyulɛ. ");
INSERT INTO soy_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomɑɑ uu pɛɛ u mɑɑ rɛ: Upíimɑ, ɑ́ri nyu kei kɑɑ n sĩ́, íye kɑri yɛ́ wɑ tɔkɛ́ nɛ lincee n nyu? ");
INSERT INTO soy_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yeesu uu u pɛsɛ rɛ: Nɛ́ɛ ncée, nɛ́ɛ nsímɛ́sei, nɛ́ɛ nfɑ́ɑ. Úkɑ úu we yɛɛ yɛ́ Sɑ́ɑ Uléécɑɑ-i ń hɑ kɑ́i nɛ̃́ kuú nɛ ritiki. ");
INSERT INTO soy_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nɔn pɛɛ nɛ́ n nyu, nɔ́ pɛɛ kɔ Unɛ́sɑ́ɑ n nyu. Kɑí nɛ nɛni n kpísi, nɔ u nyulɛ ɑni kɔ u yɛnu. ");
INSERT INTO soy_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipu pɔ́ɔ pɛɛ rɛ: Upíimɑ, pɔ kpére Sɑ́ɑ rɔ́ nyísɛ, lɛɛ nɛ rɔ́ piyɛ. ");
INSERT INTO soy_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yeesu uu u mɑɑ rɛ: Filipu, hɑ́i ɑ́i nɛni-mɛ kɛ tɔ́ nɛ nnɔ̃́ ɑrí we, ɑ́ɑ kɔ pɛɛ nɛ́ nyuu? Nkó yɛɛ nɛ́ n yɛ̃́ yɛ Unɛ́sɑ́ɑ yɛnlɛ. Íye kɑi wɑ kɑɑ pɛɛ́ nɛ mɑɑ rɛ kɛ́ Sɑ́ɑ nɔ́ nyísɛ? ");
INSERT INTO soy_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Áɑ nɛ kɛfɑ tɛnɛ rɛ tɔ́ nɛ Unɛ́sɑ́ɑ yɛ pɛ́nɛlɛnlɛ, nɛn ukɛmɛɛ we uyɛ̃ un kɔ kɛnɛ́mɛɛ we nɛ́ɛ yo? Nsímɛ́ mmú kɑm nní kɔ n símisi ńn kɛnɛ́mɛɛ léeri. Amɑ́ Sɑ́ɑ yɛɛ kɛnɛ́mɛɛ ń we yɛɛ umɛwɑi wɑi. ");
INSERT INTO soy_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ani nɛ kɛfɑ tɛnɛ rɛ nɛ Unɛ́sɑ́ɑ kɛ́mɛɛ welɛ, Unɛ́sɑ́ɑ pɔ́ɔn kɔ kɛnɛ́mɛɛ we. Ḿpɑ́ nɔnsɑ́ nɛ lɛ̃ kɛfɑ n tɛnɛnɛ, ɑni nɛ lɛ̃ kɑm n wɑi nnyɑ kɛfɑ nɛ́ tɛnɛ. ");
INSERT INTO soy_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Asei kɛcɑ́ɑ́, kɛ́ nɔ́ símisi rɛ nkó yɛɛ nɛ kɛfɑ nɛ́ n tɛnɛ pɔ̃́ nɛ́ kɔ mɛnɛ́wɑi mɛcɔ wɑ. Ticuruu u yɛ́ mɛnɛ́kɔ́ mɛtɔ́ŋɛ́-tɔŋɛ́ wɑ rɛ Unɛ́sɑ́ɑ kɛ́mɛɛ kɑm tɔ́su nnyɑ. ");
INSERT INTO soy_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Lɛ̃ nnɛ́í kɑni yɛ́ nɛ rinɛ́nyíri m pisɛ, nɛ li wɑinɛ Sɑ́ɑ ukɛ́ nɛ Kɛpipi nnyɑ ríyu yɛ̃. ");
INSERT INTO soy_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nɔn yɛ yo mpuri nɛ rinɛ́nyíri m pisɛ, nɛ́ nɔ́ li pɑ. ");
INSERT INTO soy_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Yeesu uu kɔ pimɑ́ɑ pi kpɑ́ rɛ: Nɔn nɛ́ n lɑ, nɔ́ yɛ inɛ́sé ritiki. ");
INSERT INTO soy_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nɛ̃́ nɛ́ pɛɛ Sɑ́ɑ we rɛ ukɛ́ Ucomɛ nɔ́ pɑ ukɛ́ mɛsɛ́rɛ nɔ́kɛnɛ́mɛɛ n we. ");
INSERT INTO soy_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Uyɛɛ nní nsímɛ́sei Nfɑɑsɔnɛ. Kɛtẽ nkɛ́ pisoi ɑ́pi yɛ́ fe pikɛ́ n yɔsí. Ápi n nyɑ́ni, ɑ́pi kɔ n nyu. Amɑ́ nɔ̃́ nɛ n nyulɛ rɛ n nɔ́kɛnɛ́kúrí we. Nɔ́ nɛ mmɛ̃ nɛ́ ripɛ́nɛ nń nɛ nɔ́kɛnɛ́mɛɛ n we nnyɑ. ");
INSERT INTO soy_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ám nɔ́mɛnɛ́círɛ yɑ́nɛ yɑrɛ sikúmɑmpipi. Nɛ nɔ́kɛnɛ́mɛɛ pɛɛrilɛ. ");
INSERT INTO soy_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Li tisɛ nkɑ́ripi, kɛtẽ nkɛ́ pisoi ɑ́pi yɛ́ pɛɛ piyɛ́nɛ nɛ́ rikpɑ́. Amɑ́ nɔ̃́ nɛ́ nɛ́ yɛ̃́ tɛ nɛ nfɑ́ɑ mɑ́lɛ nnyɑ. Nɔ̃́ nɛ kɔ sɔ́ntilɛ nɔkɛ́ nfɑ́ɑ m mɑ́ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Likɛyɑɑ kɛ̃ kɑni yɛ́ céri rɛ tɔ́ nɛ Unɛ́sɑ́ɑ yɛ pɛ́nɛlɛnlɛ, nɛn ukɛmɛɛ we, nɔ́ɔn kɛnɛ́mɛɛ we, nɛ́ɛn kɔ nɔ́kɛnɛ́mɛɛ we. ");
INSERT INTO soy_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nkó yɛɛ inɛ́sé ḿ múílɛ̃ un i tikilɛ̃ yɛɛ nɛ́ lɑ. Unɛ́sɑ́ɑ yɛ́ kɔ uyɛɛ nɛ́ n lɑ n lɑ. Nɛ̃́ nɛ́ kɔ u n lɑ ɑm kɔ mɛnɛ́círɛ u nyísɛ. ");
INSERT INTO soy_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yuuti, ɑ́i Yutɑsi Isikɑriyɔɔti, uu u mɑɑ rɛ: Upíimɑ, íye kɑɑ yɛ́ mɛpɔ́círɛ rɔ́ nyísɛ ɑ́ɑ yɛ́ pɛɛ kɛtẽ nkɛ́ pisoi mɛpɔ́círɛ nyísɛ? ");
INSERT INTO soy_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yeesu uu u pɛsɛ rɛ: Úye un nɛ́ n lɑ, u yɛ́ nnɛ́símɛ́ rimúlú. Unɛ́sɑ́ɑ yɛ́ u n lɑ. Tɔ́ nɛ Unɛ́sɑ́ɑ ɑri ukɛkúrí sĩ́, ɑrí hɑ ukɛmɛɛ́ n we. ");
INSERT INTO soy_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nkó yɛɛ úu nɛ́ ń lɑ úu yɛ nnɛ́símɛ́ rimúlú. Nsímɛ́ mmú kɑm nní nɔ́ n símisi ńn kɔ pɛɛ kɛnɛ́mɛɛ léeri, ɑmɑ́ Sɑ́ɑ yɛɛ nɛ́ n tummɛ kɛ́mɛɛ le. ");
INSERT INTO soy_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Kumúŋɛ́ nkú-i kɛ tɔ́ nɛ nnɔ̃́ ɑri nkpéni nní ń we kɛ́mɛɛ kɑm lɛ̃ nɔ́ símisi. ");
INSERT INTO soy_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Nɔ́unɛ́comɛ yɛɛ nní Nfɑ́ɑsɔnɛ kɛ Sɑ́ɑ Uléécɑɑ uú nɛ rinɛ́nyíri m pɑ́mɛnɛ. Mmɛ mɛɛ ḿpɑ́ yo nɔ́ céésinɛ nn kɔ lɛ̃ nnɛ́í kɑm nɔ́ n símisi nɔ́ léisɛ. ");
INSERT INTO soy_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Nɛ nkpéni nkíŋniŋɛ nɛ nɔ́ riyɑ́. Nnɛ́kíŋniŋɛ kɑm nɔ́ n hɛ. Ái sisoipipi mɛhɛɛ mɛcɔ kɑm nɔ́ hɛ. Nɔ́rinɛ́pɔ́ɔ ɑ́ri kɑpɛ cɑɑi, iwɑmɛ íi kɑpɛ kɔ nɔ́ n we. ");
INSERT INTO soy_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Yɑrɛ kɑm nɔ́ ḿ mɑɑ rɛ: Nɛ́ nɔ́ riyɑ́ ɑḿ hɑ kɔ nɔ́kɛnɛ́mɛɛ pɛɛri. Nɔn nɛ́ n lɑ, kɑm nní Unɛ́sɑ́ɑ kɛ́mɛɛ n sĩ́, li yɛ́ pɛɛ nɔ́ n lɑ́ɑ́rúlɛ rɛ nɛ ukɛmɛɛ sĩ́ nnyɑ. Unɛ́sɑ́ɑ yɛ nɛ́ felɛ. ");
INSERT INTO soy_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nɛ nsímɛ́ mmú nnɛ́í nɔ́ símisilɛ nkɛ́ kɛlenɛ kɑm tɛ nn píyei n kɑ, nɔkɛ́ nɛ kɛfɑ n tɛnɛ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ám nkpéni nɛ mɛyɑ̃́ pisímɛ́ nɔ́ kpɑ́nɛ. Kɛtẽ nkɛ́ uyɔɔpi yɛ wemɛlɛ. Úu ńnɑŋɛ ńkɑ kɛnɛ́cɑ́ɑ́ mɑ́. ");
INSERT INTO soy_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Amɑ́ kɛtẽ nkɛ́ pisoi pikɛ́ nɛ n céri rɛ nɛ Sɑ́ɑ lɑlɛ nnyɑ kɑm yɛ lɛ̃ kuu yɛ nɛ́ ḿ mɑ wɑ. Ani nté yisi tɔkɛ́ ncée kpísi. ");
INSERT INTO soy_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yeesu uu pimɑ́ɑ pi kpɑ́ rɛ: Nɛ̃́ nɛ fiinyi kuléé riyíkí lɛ, Unɛ́sɑ́ɑ yɛɛ kuute. ");
INSERT INTO soy_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","U yɛ ḿpɑ́ nlésɛ ń-ye mɛɛ kɛnɛ́cɑ́ɑ́ n tórɑɑlɛ̃ ńn yɛ pɛɛ mɑ́ri rikélɛ uu kɔ iyɛɛ m mɑ́ru hɛ́ru, ii pɛɛ mɛyɑ̃́ pimɑ́rɛ kpɑ́. ");
INSERT INTO soy_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Icélɑɑ nnyí kɑm nní nɔ́ ḿ pɑ yɛ pihɛ́rɛ́ nɔ́ mɑsilɛ ɑni pɛɛ nkpɑ́ni cɑ́kɑ́-cɑ́kɑ́. ");
INSERT INTO soy_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Tɔkɛ́ m pɛ́nɛlɛ̃ nɔn kɛnɛ́mɛɛ we yɑrɛ kɛ nɛ́ɛ nɔ́kɛnɛ́mɛɛ ń we mɛcɔ. Nlésɛ nnsɑ́ nɛ kuléé n torɑɑlɛ̃, ńn yɛ fe nkɛ́ mmɛcirɛ n we nń nɛ ɑpipi mɑru. Limɛcɔ kɛ nɔ̃́ ɑ́ni yɛ́ fe nɔkɛ́ linyinɛ yoriyɛ nɔnsɑ́ nɛ nɛ́ m pɛ́nɛlɛ̃. ");
INSERT INTO soy_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Nɛ́ɛ kuléé riyíkí, nɔ́ɔ ilésɛ. Nkó yɛɛ nɛ nɛ́ m pɛ́nɛlɛ̃ un nɛ we yɑrɛ kɛ nɛ́ɛ ukɛmɛɛ ń we mɛcɔ yɛɛ yɛ linyinɛ yoriyɛ. Insɑ́ nɛ̃́, ɑ́ni yɛ́ fe nɔkɛ́ ɑpipi torɛsi. ");
INSERT INTO soy_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Úye unsɑ́ nɛ nɛ́ m pɛ́nɛlɛ̃ ukɛ́ nɛ n we, pi yɛ kɛtɑhɑi-mɛmpɔ u fómpɔlɛ yɑrɛ nlésɛ, uu kóósi ɑpi pɛɛ ilésɛ kóimɑ iyɛ̃ cɑ́pinɛ ɑpi nnɑ sɛ́ ií torɛ. ");
INSERT INTO soy_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Nɔn nɛ nɛ́ m pɛ́nɛlɛ̃ nɔn nɛ kɛnɛ́mɛɛ n we, nnɛ́símɛ́ nn kɔ nɔ́kɛnɛ́mɛɛ n we, ɑni yɛ lɛ̃ kɑni ń lɑ pisɛ, pi yɛ́ nɔ́ li pɑ. ");
INSERT INTO soy_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nɔn ɑpipi mɛyɑ̃́ n torɛsi, nɔ lɛ̃ nyísɛlɛ rɛ nɔ pinɛ́pirɛtiki lɛ. Unɛ́sɑ́ɑ uu pɛɛ ríyu yɛnu. ");
INSERT INTO soy_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nɛ nɔ́ lɑlɛ yɑrɛ kɛ Sɑ́ɑ uu nɛ́ ń lɑ mɛcɔ. Ani ńlɑ mmɛ̃ kɛ́mɛɛ n we. ");
INSERT INTO soy_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nɔn inɛ́sé m múílɛ̃, nnɛ́lɑ kɛ́mɛɛ kɑni lɛ̃ we yɑrɛ kɑm Unɛ́sɑ́ɑ isé rimmúlú ɑm pɛɛ unlɑ kɛ́mɛɛ n we mɛcɔ. ");
INSERT INTO soy_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Nɛ lɛ̃ nɔ́ símisilɛ nɔkɛ́ nɛ mɛnɛ́cɔ mpɔ́ɔnɑrɛ m mɑ́, nɔ́nnɛ́pɔ́ɔnɑrɛ nkɛ́ kɔ n we nɛ nkɛtɔ-pɔ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Isé iyɛ̃ kɑm nɔ́ ḿ pɑ́lɛ̃ yɛɛ rɛ: Ani n lɑkɑɑnɛ yɑrɛ kɑm nɔ́ ń lɑ mɛcɔ. ");
INSERT INTO soy_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Lɛlɛɛ n fe kɛ usoi uu yɛ nɛ n nyísɛ rɛ u ńlɑ píimɑ mɑ́lɛ yɛɛ rɛ: Usoi ukɛ́ unfɑɑ cirɛ kpísi ukɛ́ upisɑnɛ riyu kɛcɑ́ɑ́ hɛ. ");
INSERT INTO soy_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nɔn yɛ lɛ̃ kɑm nɔ́ m pisɛ n wɑ, nɔ pinɛ́sɑ́nɛ lɛ. ");
INSERT INTO soy_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ám nkpéni piséi nɔ́ kpɑ́nɛ rɛ pikɛikɔ́. Ukɛikɔ́ úu yɛ n nyu lɛ̃ kɛ ukɛisɑɑ uu n wɑi. Lɛ̃ nnɛ́í kɛ Unɛ́sɑ́ɑ uu nɛ́ n nyísɛ kɑm nɔ́ céesi. Lɛ̃ nnyɑ kɑm nɔ́ sée rɛ pinɛ́sɑ́nɛ. ");
INSERT INTO soy_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ái nɔ́ɔ nɛ́ wɛ́ɛ, nɛ́ɛ nɔ́ wɛ́ɛ ɑm nɔ́ tum tɛ ɑni n ŋme ɑni hɑ pikɛi wɑ likɛ́ yóriyɛ ḿpɑ́ píyei-pɔ. Lɛ̃ kɛ́mɛɛ, Unɛ́sɑ́ɑ yɛ́ pɛɛ lɛ̃ nnɛ́í kɑni yɛ́ nɛ rinɛ́nyíri u m pisɛ nɔ́ pɑ. ");
INSERT INTO soy_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Lɛ̃ nnyɑ, lɛ̃ kɑm nɔ́ m pisɛ yɛɛ rɛ ɑni n lɑkɑɑnɛ. ");
INSERT INTO soy_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Yeesu uu kɔ pimɑ́ɑ pi kpɑ́ rɛ: Kɛtẽ nkɛ́ pikɔ́ pin nɔ́inɛ́puri n yulu, ɑni ceri rɛ inɛ́puri kɑpi mɛfoí yɛ̀ kɛlenɛ. ");
INSERT INTO soy_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nɔn pɛɛ kɛtẽ nkɛ́ pikɔ́, pi yɛ́ pɛɛ nɔ́inɛ́puri n lɑ rɛ nɔ pipikɔ́ nnyɑ. Amɑ́ kɑ́ni nní kɛtẽ nkɛ́ pikɔ́, ɑm kɔ nɔ́ wɛ́ɛ, nɔ́ nɛ pɛ̃ ɑ́ni pɛɛ líkɑ pɛ́nɛlɛ̃ nnyɑ, ɑ́pi pɛɛ nɔ́inɛ́puri lɑ. ");
INSERT INTO soy_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ani rinɔ́ɔ tɛ̃ kɑm nɔ́ ḿ mɑ léisɛ rɛ: “Ukɛikɔ́ úu yɛ ukɛisɑɑ n fe. Pin nɛ́ n wéékusɛlɛ̃, ɑni n nyu rɛ pi kɔ nɔ̃́ wéékusɛnɛ, pin yɛ nnɛ́símɛ́ rimmúlú, pi yɛ́ kɔ nɔ̃́ nkɔ́ rimúlú.” ");
INSERT INTO soy_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Amɑ́ nɛ̃́ nnyɑ kɑpi lɛ̃ nnɛ́í nɔ́ wɑinɛ, kɑ́pi nní uyɛɛ nɛ́ n tummɛ n nyu nnyɑ. ");
INSERT INTO soy_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Nɛnsɑ́ pɛɛ́ n kɑ, nɛnsɑ́ pɛɛ kɔ pi n símisi, ɑ́pi yɛ́ pɛɛ ɑkópɛ m mɑ́. Ápi nkpéni ńkɑ mɑ́ pikɛ́ nɛ piɑkópɛ yɑrii. ");
INSERT INTO soy_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nkó yɛɛ inɛ́puri n yúlu yɛ kɔ Unɛ́sɑ́ɑ ipuri yululɛ. ");
INSERT INTO soy_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nɛnsɑ́ pɛɛ pikɛcɔpɛ mɛwɑi n wɑpisi kɛ úkɑ mpuri úu n wɑilɛ̃, ɑ́pi yɛ́ pɛɛ ɑkópɛ m mɑ́. Amɑ́ pi nkpéni mɛ yɛnlɛ ɑpi kɔ pɛɛ tɔ́ nɛ Unɛ́sɑ́ɑ ipuri yulu. ");
INSERT INTO soy_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Lɛlɛɛ piisé kɛ́mɛɛ n wɔ́lɑɑlɛ̃ likɛ́ nɛ n wɑ nnyɑ kɑi lɛ̃ wɑi. Lɛlɛɛ rɛ: Mɛ́woo kɑpi inɛ́puri yulu. ");
INSERT INTO soy_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ucomɛ yɛɛ n sɔ́nti yɛɛ nní nsímɛ́sei Nfɑɑsɔnɛ kɑḿ nɛ Sɑ́ɑ rinyiri nɔ́kɛnɛ́mɛɛ n tumtinɛ. Sɑ́ɑ kɛ́mɛɛ kuu léeri ukɛ́ kɛnɛ́cɑ́ɑ́ ɑseérɑ lesɛ. ");
INSERT INTO soy_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Nɔ̃́ nɛ́ kɛnɛ́cɑ́ɑ́ ɑseérɑ lesɛ rɛ tɔ́ nɛ nnɔ̃́ tɔ́ɔ hɑ́i kɛ́korɑɑnɛ-mɛ we nnyɑ. ");
INSERT INTO soy_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Nɛ lɛ̃ nɔ́ símisilɛ rɛ ɑ́ni kɑpɛ nɛ Uléécɑɑ ncee kɛ́mɛɛ ń loó nnyɑ. ");
INSERT INTO soy_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Pi yɛ́ kɑm ɑpi ɑyómɛyɑ́hɑɑlee kɛ́mɛɛ nɔ́ lɑ́kɑsɛ. Ticuruu li kumúŋɛ́ kunyinɛ-i sɔ́nti kɛ usoi uu yɛ́ un nɔ́ n kpu, uú m músu rɛ Uléécɑɑ kuu lɛ̃ inyɔ́ɔnsɛ wɑi. ");
INSERT INTO soy_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Kɑ́pi píkɑi Unɛ́sɑ́ɑ nɛ́ɛ nɛ̃́ n nyu nnyɑ kɑpi lɛ̃ wɑinɛ. ");
INSERT INTO soy_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nɛ lɛ̃ nɔ́ símisilɛ rɛ lin n kɑ lin lɛ̃ n wɑi, nɔkɛ́ nɛ n léisɛ rɛ nɛ nɔ́ símisi nnyɑ. Tɔ́ nɛ nnɔ̃́ tɔ́ɔ pɛɛ́ we nnyɑ kɑ́m hɑ́i kɛ́korɑɑnɛ-mɛ nɔ́ símisi. ");
INSERT INTO soy_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Yeesu uu kɔ pimɑ́ɑ pi kpɑ́ rɛ: Uyɛɛ nɛ́ n tummɛ kɛ́mɛɛ kɑm nkpéni nní tɔ́su, nɔ́ úkɑ úu kɔ nɛ́ pisɛnɛ rɛ: Mɛ́ye kɑɑ sĩ́? ");
INSERT INTO soy_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Kɑm lɛ̃ nɔ́ n símisi nnyɑ kɛ nɔ́ɑnɛ́pɔ́ɔ ɑɑ lɛ̃ mɛyɑ̃́ cɑɑi. ");
INSERT INTO soy_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ḿpɑ́ nɛ lɛ̃, nɛ́ nsímɛ́sei nɔ́ símisi: Nɛn n tɔ́mpɔ, li yɛ́ nɔ́ rilɑɑ ɑi tɔ́su. Li we rɛ nɛnsɑ́ n tɔ́mpɔ, ucomɛ úu pɛɛ nɔ́kɛnɛ́mɛɛ sɔ́nti. Amɑ́ nɛn n tɔ́mpɔ, nɛ́ nɔ́ u tummɛ. ");
INSERT INTO soy_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Un píyei n kɑ, u yɛ́ kɛtẽ nkɛ́ pisoi ɑkópɛ pi nyísɛ. U yɛ́ kɔ lɛ̃ kɑpi yɛ n sée rɛ ɑsei nɛ lɛ̃ kɛ Uléécɑɑ uu yɛ́ nɛ usoi n túhɑɑnɛ pi símisi. ");
INSERT INTO soy_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Piɑkópɛ yɛ nnyɛ́ rɛ ɑ́pi nɛ kɛfɑ nɛ́ tɛnɛlɛ̃. ");
INSERT INTO soy_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Asei nyɛɛ rɛ Unɛ́sɑ́ɑ-i kɑm sĩ́, ɑ́ni kɔ piyɛ́nɛ nɛ́ kpɑ́nɛ. ");
INSERT INTO soy_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","U yɛ́ lɛ̃ kɛ Uléécɑɑ uu yɛ nɛ usoi n túhɑɑnɛ pi símisi. Lɛlɛɛ rɛ u nɛ kɛtẽ nkɛ́ uyɔɔpi pitúhɑɑnɛ mɑsilɛ. ");
INSERT INTO soy_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Nɛ nsímɛ́ mɛyɑ̃́ mɑ́lɛ kɛ́ nɔ́ símisi. Amɑ́ nkɛmɛɛ pikomɛ yɛ́ nkpéni nɛ nɔ́ pɔlɛsi. ");
INSERT INTO soy_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Nsímɛ́sei Nfɑɑsɔnɛ mmɛ̃ nn píyei n kɑ, n yɛ́ tíyɛsɛ ɑni nsímɛ́sei nnɛ́í kóm. Ái nnnɑŋɛ cirɛ knn nɛ símisinɛ, ɑmɑ́ lɛ̃ nnɛ́í knn n kṍ knn nɔ́ símisinɛ, nn kɔ lɛlɛɛ mɑsí kɛpirɛ n wɑinɛ nɔ́ símisi. ");
INSERT INTO soy_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","N sɔ́ntilɛ nkɛ́ ríyu nɛ́ wɑisɛ. Li we rɛ mmɛ̃ kɑm n símisi knn sɔ́nti nkɛ́ nɔ́ ritɛ́ŋ́sɛ. ");
INSERT INTO soy_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Lɛ̃ nnɛ́í kɛ Unɛ́sɑ́ɑ uu m mɑ́ yɛ linɛ́kɔ́ lɛ. Lɛ̃ nnyɑ kɑḿ mɑɑ rɛ mmɛ̃ kɑm n símisi kɛ nsímɛ́sei Nfɑɑsɔnɛ mmɛ̃ nn sɔ́nti nkɛ́ nɔ́ ritɛ́ŋ́sɛ. ");
INSERT INTO soy_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yeesu uu kɔ pimɑ́ɑ pi kpɑ́ rɛ: Li tisɛ nkɑ́ripi, ɑ́ni yɛ́ kɔ piyɛ́nɛ nɛ́ rikpɑ́, ɑi kɔ nkɑ́ripi kpɑ́sɛ, ɑni kɔ piyɛ́nɛ nɛ́ kpɑ́. ");
INSERT INTO soy_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Kei kɛ upipirɛtiki kɛcɔpɛ pinyinɛ ɑpi pɛɛ pipísɛinɛ lõ tɛ: Nsímɛ́ mmú kuu nní ń símisi ɑsei rɛ íye? U rɛ: Li tisɛ nkɑ́ripi, ɑ́ni yɛ́ kɔ piyɛ́nɛ nɛ́ rikpɑ́, ɑi kɔ nkɑ́ripi kpɑ́sɛ, ɑni kɔ pɛɛ piyɛ́nɛ nɛ́ kpɑ́. Li we rɛ Unɛ́sɑ́ɑ-i kɑm sĩ́. ");
INSERT INTO soy_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Lɛ̃ kuu nní ḿ mɑɑ rɛ “li tisɛ nkɑ́ripi” ɑsei rɛ íye? Ári nyu lɛ̃ kuu n símisi. ");
INSERT INTO soy_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yeesu un nyu rɛ pi lɑlɛ pikɛ́ nsímɛ́ u pisɛ, uu pɛɛ pi mɑɑ rɛ: Nɔ nɔ́mɛnɛ́cɔpɛcirɛ písɛinɛ rɛ nɛ mɑɑ rɛ “li tisɛ nkɑ́ripi, ɑ́ni yɛ́ kɔ piyɛ́nɛ nɛ́ rikpɑ́, ɑi kɔ nkɑ́ripi kpɑ́sɛ, ɑni kɔ pɛɛ piyɛ́nɛ nɛ́ kpɑ́, nɛ́ɛ yo?” ");
INSERT INTO soy_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Asei kɛcɑ́ɑ́, kɛ́ nɔ́ símisi rɛ nɔ́ kɑm ɑni yɛ téni nɔ́ɑnɛ́pɔ́ɔ ɑɑ kɔ cɑɑi, ɑmɑ́ kɛtẽ nkɛ́ pikɔ́ pin nkíŋniŋɛ kɛ́mɛɛ we. Nɔ́ kɑm ɑni mpɔ́ɔcɑɑi kɛ́mɛɛ n we, ɑmɑ́ nɔ́nnɛ́pɔ́ɔcɑɑi yɛ́ kɑm nn pɑnsɛ mpɔ́ɔnɑrɛ. ");
INSERT INTO soy_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Unɔ́si yɛ̀ɛ̀ un kɛ́mɑrɛ-i n we, uripɔɔ yɛ̀ɛ̀ n cɑɑilɛnlɛ rɛ ituŋɛ yɛ tu rɛ ukɛ́ íwɛ píimɑ li nnyɑ. Amɑ́ un pimɑ́rɛ m mɑsí, uu uiwɛ pɑlɛi. Li yɛ u n lɑ́ɑ́rúlɛ rɛ u kɛwɑ̃́ mɑri nnyɑ. ");
INSERT INTO soy_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Limɛcɔ kɛ nɔ̃́ ɑpɔɔ ɑɑ kɔ nkpéni cɑɑilɛ̃. Amɑ́ nɛ sɔ́nti kɛ́ kɔ piyɛ́nɛ nɔ́ rikpɑ́, nɔ́ɑnɛ́kíŋ ɑkɛ́ pɛɛ níŋɛsi, úkɑ úu yɛ́ kɔ fe ukɛ́ mpɔ́ɔnɑrɛ mmɛ̃ nɔ́ lesɛ. ");
INSERT INTO soy_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Áni likɛyɑɑ kɛ̃ ńkɑ pipisɛ kɔ nɛ́ kpɑ́nɛ. Asei kɛcɑ́ɑ́, kɛ́ nɔ́ símisi rɛ Sɑ́ɑ yɛ́ lɛ̃ nnɛ́í kɑni yɛ́ rinɛ́nyíri nɛ u n we nɔ́ pɑ. ");
INSERT INTO soy_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Hɑ́i nɛ nɛni-mɛ ɑ́ni kɑhɑnɛ rinɛ́nyíri nɛ linyinɛ n we. Lɛ̃ nnyɑ, ɑni yɛ we ukɛ́ nɔ́ hɛ nɔ́nnɛ́pɔ́ɔnɑrɛ nkɛ́ n we nɛ nkɛtɔ-pɔ. ");
INSERT INTO soy_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Yeesu uu kɔ upipirɛtiki pimɑ́ɑ kpɑ́ rɛ: Sinyɑ́rũ kɑḿ nɛ nsímɛ́ nnɛ́í nɔ́ símisi. Kumúŋɛ́ kunyinɛ yɛ́ kɑm ɑ́m yɛ́ pɛɛ lɛ̃ nɔ́ n símisi, ɑmɑ́ ɑm yɛ pɛɛ Sɑ́ɑ kɛcɑ́ɑ́ nsímɛ́ nɔ́ símisi kpɑ̃́ii. ");
INSERT INTO soy_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Nɔ́ hɑ likɛyɑɑ kɛ̃ tinɛ́nyíri nɛ linyinɛ Sɑ́ɑ we. Ám mɑɑ rɛ nɛ́ nɔ̃́ nnyɑ u risuúlusɛ. ");
INSERT INTO soy_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Kɑni nɛ́ ń lɑ nnyɑ, Sɑ́ɑ ricuruu yɛ kɔ nɔ̃́ lɑlɛ, ɑni kɔ nɛ kɛfɑ tɛnɛ rɛ Uléécɑɑ kɛ́mɛɛ kɑm léeri nnyɑ. ");
INSERT INTO soy_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Sɑ́ɑ kɛ́mɛɛ kɑm léeri kɑḿ nɛ kɛtẽ kɛcɑ́ɑ́ kɑ. Nɛ nkpéni lɛ̃ kɛtẽ nté yisilɛ kɛ́ Sɑ́ɑ kɛ́mɛɛ pɛlɛ. ");
INSERT INTO soy_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Kei kɛ upipirɛtiki ɑpi pɛɛ u mɑɑ rɛ: Pɔ nkpéni rɔ́ símisilɛ lin kpɑ̃́iilɛ̃, ɑ́ɑ nkpéni nɛ sinyɑ́rũ tɔ́ símisi. ");
INSERT INTO soy_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Tɔ nkpéni cérilɛ rɛ pɔ ḿpɑ́ yo nyulɛ, ɑ́i nkpɑ́ni we pikɛ́ nnyinɛ pɔ́ pisɛ. Lɛ̃ nnyɑ kɑrí nɛ kɛfɑ tɛnɛ rɛ Uléécɑɑ kɛ́mɛɛ kɑɑ léeri. ");
INSERT INTO soy_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yeesu uu pi pɛsɛ rɛ: Nɔ nkpéni nɛ kɛfɑ tɛnɛlɛ, nɛ́ɛ yo? ");
INSERT INTO soy_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Kumúŋɛ́ kunyinɛ yɛ́ kɑm, ticuruu ku pikɑ́mɛ mɑsilɛ, kɑni yɛ́ mɛkɔ́ mɛkɔ́ rinkpíi ɑni mɛnɛ́círɛ yɑ́. Amɑ́ ɑ́m mɛnɛ́círɛ we, Sɑ́ɑ yɛ kɛnɛ́kúrí welɛ. ");
INSERT INTO soy_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nɛ lɛ̃ nnɛ́í nɔ́ símisilɛ rɛ ɑni nɛ tɔ́ nɛ nnɔ̃́ kupɛ́nɛcɔ kɛ́mɛɛ nkíŋniŋɛ-i n we nnyɑ. Nɔ sɔ́ntilɛ nɔkɛ́ kɛtẽ nkɛ́ kɛcɑ́ɑ́ íwɛ píimɑ nɛ m pɑnsɛntɛ, ɑmɑ́ ɑni n kɑhɑri, nɛ kɛtẽ kɛcɑ́ɑ́ ńnɑŋɛ nnɛ́í piferiyɛ mɑsilɛ. ");
INSERT INTO soy_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Kɛ Yeesu uu lɛ̃ pisímɛ́ ḿ mɑsí, uu pɛɛ kɛléécɑɑ-mɛ̃ weríí uu rɛ: Ituŋɛ yɛ tulɛ, Sɑ́ɑ. A Kɛpɔ́pipi ríyu wɑisɛ, kɛ̃ kɛkɛ́ kɔ pɔ̃́ tíyu wɑisɛ. ");
INSERT INTO soy_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Pɔ sisoipipi nnɛ́í kɛcɑ́ɑ́ ńnɑŋɛ kɛ hɛlɛ rɛ kɛkɛ́ pɛ̃ nnɛ́í kɑɑ kɛɑnipɛ-i n wɑ nfɑ́ɑ tɛnɛcirɛ́ hɛ. ");
INSERT INTO soy_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Nfɑ́ɑ tɛnɛcirɛ́ mɛɛ pikɛ́ pɔ́ céri rɛ mɛpɔ́círɛ pɔ́ɔ Uléécɑɑ sei, pikɛ́ kɔ Yeesu Kirisi kɑɑ n tummɛ ceri. ");
INSERT INTO soy_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nɛ kɛtẽ kɛcɑ́ɑ́ ríyu pɔ́ wɑisɛlɛ ɑm kɔ pikɛi kɑɑ nɛ́ ń forii wɑi. ");
INSERT INTO soy_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Lɛ̃ nnyɑ Sɑ́ɑ, ɑ nkpéni kɛpɔ́yu-i ríyu tɛ̃ kɑḿ pɛɛ kɛpɔ́mɛɛ m mɑ́ ɑɑ kɛlenɛ kɛtẽ nkɛ́ wɑi nɛ́ wɑisɛ. ");
INSERT INTO soy_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Nɛ tíyɛsɛlɛ pisoi pɛ̃ kɑɑ kɛtẽ kɛcɑ́ɑ́ n lésɛ ɑɑ ɑnɛ́nípɛ-i wɑi ɑpi pɔ́ céru. Pɔ́ɔ pɛɛ pi te, ɑɑ pi kpísi ɑɑ ɑnɛ́nípɛ-i wɑi pin mpɔ́símɛ́ múílɛ̃. ");
INSERT INTO soy_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Pi nkpéni cérilɛ rɛ kɛpɔ́mɛɛ kɛ lɛ̃ nnɛ́í kɑɑ nɛ́ ḿ pɑ ɑi léeri. ");
INSERT INTO soy_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Nsímɛ́ mmɛ̃ kɑɑ nɛ́ ḿ pɑ kɑm pi símisi ɑpi ŋmurɛi ɑpi kɔ mɛyíkíyiki céru rɛ kɛpɔ́mɛɛ́ kɑm léeri, ɑpi kɔ nɛ kɛfɑ tɛnɛ rɛ pɔ́ɔ nɛ́ tummɛ. ");
INSERT INTO soy_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Pɛ̃ kɛcɑ́ɑ́ kɑm pɔ́ yɑ́ɑ́si. Ái kɛtẽ nkɛ́ pikɔ́ kɛcɑ́ɑ́ kɑm yɑ́ɑ́si, ɑmɑ́ pɛ̃ kɑɑ ɑnɛ́nípɛ-i n wɑ kɛcɑ́ɑ́ kɑm pɔ́ yɑ́ɑ́si rɛ pɔ́ɔ pɛ̃ te nnyɑ. ");
INSERT INTO soy_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Pɔ́ɔ lɛ̃ nnɛ́í kɑm m mɑ́ te. Nɛ́ɛ kɔ lɛ̃ nnɛ́í kɛ pɔ́ɔ m mɑ́ te. Lɛlɛɛ kɔ nyísɛlɛ̃ tɛ pɔ pikɛmɛɛ ríyu nɛ́ wɑisɛlɛ. ");
INSERT INTO soy_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ám kɔ nkpéni kɛtẽ kɛcɑ́ɑ́ we, ɑmɑ́ pɛ̃ nɛ kɔ nɛ kɛkɛcɑ́ɑ́ welɛ. Kɛpɔ́mɛɛ́ kɛ nɛ́ɛ tɔ́su. Sɑ́ɑ Uléécɑɑ, Uléécɑɑ yɛɛ úu ɑkópɛ m mɑ́, ɑ pi rimúlú pikɛ́ rinɔ́ɔ risɛ m mɑ́ yɑrɛ kɛ tɔ́ nɛ mpɔ̃́ ɑri m mɑ́ mɛcɔ. ");
INSERT INTO soy_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Kɛ tɔ́ nɛ pɛ̃ ɑrí pɛɛ ń we, tipɔ́nyíri kɑḿ pɛɛ́ nɛ pɛ̃ kɑɑ nɛ́ rimmúísɛ kɛcɑ́ɑ́ pɑílɛ̃. Nɛ pɛɛ pikɛcɑ́ɑ́ ripɑilɛ ńsɔnɛ, piukɑ úu pɔ, insɑ́ uyɛ̃ kɑi n wɑimɛ rɛ ukɛ́ pɔ yɑrɛ kɑi Nléécɑɑsimɛ́ ritɛlɛ́ kɛ́mɛɛ n wɔ́lɑɑlɛ̃ mɛcirɛ. ");
INSERT INTO soy_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ncée-i kɑm nní lɛ̃ we nɛn kɛpɔ́mɛɛ tɔ́su. Kumúŋɛ́ nkú-i kɑm nní kɛtẽ kɛcɑ́ɑ́ ń we kɛlenɛ nnyɑ kɑm lɛ̃ pi símisi rɛ mpɔ́ɔnɑrɛ kɑm m mɑ́ nkɛ́ pi wɑ nɛ nkɛtɔ-pɔ. ");
INSERT INTO soy_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nɛ̃́ nɛ mpɔ́símɛ́ pi céesilɛ kɛtẽ nté pikɔ́ ɑpi piipuri yulu rɛ ɑ́pi kɛtẽ nté pikɔ́, yɑrɛ kɛ nɛ̃́ ɑ́m kɔ kɛtẽ nté ukɔ́ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ám pɔ́ welu rɛ ɑ kɛtẽ nkɛ́ kɛcɑ́ɑ́ pi yukusɛ, ɑmɑ́ nɛ pɔ́ welu rɛ ɑ pikɛcɑ́ɑ́ ripɑí ukpɑ́ɑ́ree Setɑni úu kɑpɛ pi ricɑ. ");
INSERT INTO soy_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ápi kɛtẽ nté pikɔ́, yɑrɛ kɛ nɛ̃́ ɑ́m kɔ kɛtẽ nté ukɔ́ mɛcɔ. ");
INSERT INTO soy_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","A nsímɛ́sei kpísi ɑɑ́ nɛ pi pɑnsɛsɛ pipɔ́kɔ́ nɛ kɛ́tɔ-pɔ. Mpɔ́símɛ́ mɛɛ ɑsei. ");
INSERT INTO soy_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Yɑrɛ kɑɑ kɛtẽ nté pisoi kɛ́mɛɛ nɛ́ n tũ mɛcɔ kɛ nɛ́ɛ kɔ kɛtẽ nté pisoi kɛ́mɛɛ pi tũ. ");
INSERT INTO soy_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Nɛ pɛ̃ nnyɑ mɛnɛ́círɛ kpísilɛ ɑm pɔ́ pɑ rɛ nsímɛ́sei nkɛ́ tíyɛsɛ pɛ̃ pɔ́ɔkɛ́ kɔ pimɛcirɛ kpísi pikɛ́ pɑnsɛsɛ pipɔ́kɔ́. ");
INSERT INTO soy_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Ái kɔ pɛ̃ ŋmɑnɛ nnyɑ kɑm pɔ́ welu, ɑmɑ́ pɛ̃ kɑpi n sɔ́nti pikɛ́ nsímɛ́ rin-yóó pikɛ́ nɛ kɛfɑ nɛ́ tɛnɛ nnyɑ kɑm pɔ́ welu. ");
INSERT INTO soy_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nɛ pɔ́ welu rɛ ɑ tíyɛsɛ pikɛ́ rinɔ́ɔ risɛ wɑ. Yɑrɛ kɛ pɔ̃́ Sɑ́ɑ, ɑɑ kɛnɛ́mɛɛ ń we nɛ́ɛn kɔ kɛpɔ́mɛɛ we, pɛ̃ pikɛ́ kɔ m pɛ́nɛlɛ̃ pin nɛ kɛrɔ́mɛɛ́ we kɛtẽ nté pikɔ́ pikɛ́ nɛ n céri rɛ pɔ́ɔ nɛ́ tummɛ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Mɛyɔ́ɔpi mɛ̃ kɑɑ nɛ́ ń hɛ kɑm pi hɛ pikɛ́ nɛ rinɔ́ɔ risɛ m mɑ́ yɑrɛ kɛ tɔ́ nɛ mpɔ̃́ ɑri m mɑ́ mɛcɔ. ");
INSERT INTO soy_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nɛ nɛ pi pɛ́nɛlɛnlɛ nɛn nɛ pikɛmɛɛ́ we, pɔ́ɔn kɔ nɛ nɛ̃́ pɛ́nɛlɛ̃ pɔn nɛ kɛnɛ́mɛɛ́ we. Lɛ̃ kɛ́mɛɛ́ kɑpi yɛ́ fe ɑpi rinɔ́ɔ risɛ m mɑ́ nɛ kɛ́tɔ-pɔ, kɛtẽ nté pisoi ɑpi kɔ nɛ ceru rɛ pɔ́ɔ nɛ́ tummɛ, pɔn kɔ pi lɑ yɑrɛ kɑɑ nɛ́ ń lɑ mɛcɔ. ");
INSERT INTO soy_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Sɑ́ɑ, nɛ lɑ rɛ pɛ̃ kɑɑ nɛ́ rimmúísɛ pikɛ́ hɑ kei kɑm ń wenɛ n we, pikɛ́ nɛ mɛyɔ́ɔpi mɛ̃ kɑɑ nɛ́ n hɛ n yɛ̃́ nnyɑ. Pɔ́ɔ nɛ́ mɛ hɛ rɛ pɔ nɛ́ lɑlɛ ɑɑ kɛlenɛ kɛtẽ wɑi nnyɑ. ");
INSERT INTO soy_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Sɑ́ɑ ɑsei ute, kɛtẽ nkɛ́ pikɔ́ ɑ́pi pɔ́ nyu. Amɑ́ nɛ̃́ nɛ pɔ́ nyulɛ, mpí pɔ́ɔ kɔ ceru rɛ pɔ́ɔ nɛ́ tummɛ. ");
INSERT INTO soy_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nɛ tíyɛsɛlɛ ɑpi ripɔ́nyíri ceru, nɛn kɔ we nɛn wɑi rɛ pikɛ́ picére ti rikpɑ́, ńlɑ mmɛ̃ kɑɑ nɛ́ ń lɑ nkɛ́ nɛ pikɛmɛɛ́ n we kɛ́ kɔ nɛ pi m pɛ́nɛlɛ̃ nɛn nɛ pikɛmɛɛ́ we nnyɑ. ");
INSERT INTO soy_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Kɛ Yeesu uu lɛ̃ pisímɛ́ ḿ mɑsí, u nɛ upipirɛtiki ɑpi yisi ɑpi Seturɔɔ kɛfɑŋɑɑ mɛtɛ́ŋ́-mɛ̃ sĩ ɑpí hɑ kɛléécɑrɛ kɛnyinɛ kɛɛ kei ń we kɛ́mɛɛ lompɔ. ");
INSERT INTO soy_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yutɑsi yɛɛ Yeesu n yɑ́ɑ́ yɛ kei nyulɛ. Yeesu nɛ upipirɛtiki yɛ̀ɛ̀ pɛɛ kei mɛsɛ́rɛ cɑ́pinɛlɛ. ");
INSERT INTO soy_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Kei kɛ Yutɑsi uu yisi uu pisɔ́ɔ́cɑ kpísi uu kɔ Uléécɑɑ kɛyɔ pimɛ́rɛ́ kɛ pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ nɛ Pifɑrisi ɑpi n tumpɔ nɛ pɛ́nɛ, pin iyúipukɛ nɛ sífirɑ́ɑ nɛ itɔpilũ mulɛilɛ̃. ");
INSERT INTO soy_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yeesu yɛ pɛɛ lɛlɛɛ u n wɑinɛ pinyuwɛ mɑ́ɑ́lɛnlɛ, uu pɛɛ́ nɛ nyɔsɔ́pɔ uu pi pisɛ rɛ: Úye kɑni wɛ́ɛ́si? ");
INSERT INTO soy_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Api u pɛsɛ rɛ: Nɑsɑrɛti ukɔ́ Yeesu. Uu pɛɛ pi pɛsɛ rɛ: Nɛ́ɛ lo! Yutɑsi yɛɛ u n yɑ́ɑ́ yɛ pɛɛ kei welɛ lin nɛ lɛ̃ wɑi. ");
INSERT INTO soy_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Kumúŋɛ́ kpɛ-i kɛ Yeesu uú pɛɛ pi ḿ mɑɑ rɛ: Nɛ́ɛ lo, pi ipírɛ̃ pírɛ̃ nɛ sɔ́nɛlɛ ɑpí hɑ nɛ lólu. ");
INSERT INTO soy_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yeesu uu kɔ pipisɛ pi kpɑ́ rɛ: Úye kɑni wɛ́ɛ́si? Api rɛ: Nɑsɑrɛti ukɔ́ Yeesu. ");
INSERT INTO soy_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yeesu uu pɛɛ pi pɛsɛ rɛ: Ńté nɛ nɔ́ mɑɑ rɛ nɛ́ɛ lo. In tɛ nɛ̃́ kɑni mɛsei wɛ́ɛ́si, ɑni picɔ riyɑ́ pikɛ́ tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Lɛ̃ kuú pɛɛ mɛkɛɛ ḿ mɑ likɛ́ nɛ n wɑ nnyɑ kuu lɛ̃ mɑ. U pɛɛ́ mɑɑ rɛ: Pɛ̃ kɑɑ nɛ́ rimmúísɛ, úkɑ úu nɛ nɛ́ pɔ. ");
INSERT INTO soy_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simɔɔ Piyɛɛ yɛ pɛɛ ritɛ́hɛ cɑɑcɑɑ múílɛnlɛ. Uu ri mɑhɑni uu Uléécɑɑ usinɑ ukɛikɔ́ usɛ kutu lukɛ-lukɛ seḿ. Pi yɛ ukɛikɔ́ uyɛ̃ sée rɛ Mɑlikuusi. ");
INSERT INTO soy_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Kei kɛ Yeesu uu pɛɛ Piyɛɛ mɑɑ rɛ: A ripɔ́tɛ́hɛ kukɑi kɛ́mɛɛ pɛsɛpɔ. Íwɛ iyɛ̃ kɛ Unɛ́sɑ́ɑ uu wɑ rɛ kɛ́ li. Ám kɑpɛ pɛɛ i li, nɛ́ɛ íye? ");
INSERT INTO soy_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Pisɔ́ɔ́cɑ pɛ̃ nɛ piukpeenwɑi nɛ Pisuifi pimɛ́rɛ́ ɑpi pɛɛ Yeesu tini ɑpi pɑɑsi ");
INSERT INTO soy_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ɑpí nɛ Anɑ kɛyɔ u sĩ kɛlenɛ. Anɑ yɛ pɛɛ Kɑyifu yɛɛ kumúŋɛ́ kpɛ-i isínɑ n tṹ ulɔ́hɔ́ lɛ. ");
INSERT INTO soy_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kɑyifu yɛɛ pɛɛ Pisuifi piwɛ́ɛ́sɛ mɛsɔhɔ rikpɑ́ rɛ: Li kutɔsi we rɛ usoi usɛ ukɛ́ kuyu nnɛ́í nkpɔ kpu. ");
INSERT INTO soy_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Pi pɛɛ lɛ̃ nɛ Yeesu tɔ́sulɛ, Simɔɔ Piyɛɛ nɛ uupirɛtikicɔ unyinɛ pin Yeesu tikilɛ̃. Usínɑ yɛ pɛɛ upirɛtiki ucɔ uyɛ̃ nyulɛ. Lɛ̃ nnyɑ kuu fe u nɛ Yeesu ɑpi kucɔ usínɑ kɛyɔ-i lompɔ. ");
INSERT INTO soy_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Amɑ́ kɛtɑhɑi kɛ Piyɛɛ pɔ́ɔ nyɛrɛ uú nɛ ripoo kɔ. Kei kɛ uupirɛtikicɔ uyɛ̃ kɛ usínɑ uu nní ń nyu uu pɛɛ léemɛ uú nɛ unɔ́sikɛikɔ́ uyɛɛ ripoo-i m mɛ̃́ símisi uu pɛɛ Piyɛɛ tɑmpɔ. ");
INSERT INTO soy_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Unɔ́si uyɛ̃ uu pɛɛ Piyɛɛ pisɛ rɛ: Ńté pɔ̃́ nɛ kɔ utisi uyɛ̃ upirɛtiki lɛ? Piyɛɛ uu rɛ: Aɑí, ɑ́m utisi uyɛ̃ upirɛtiki. ");
INSERT INTO soy_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Nnyiyɛ yɛ pɛɛ likumúŋɛ́ kpɛ-i welɛ. Pikɛikɔ́ nɛ pimɛ́rɛ́ ɑpi pɛɛ nkɑlɛnɑ wɑi ɑpi kɛkɑ́lɛ wɑi pin pɛɛ wéni. Piyɛɛ pɔ́ɔ kɔ pikɛmɛɛ́ hɑpɔ uú n tũ un nnɑ wéni. ");
INSERT INTO soy_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Usínɑ uu Yeesu upipirɛtiki nɛ uicélɑɑ kɛcɑ́ɑ́ písɛisɛ. ");
INSERT INTO soy_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yeesu uu u pɛsɛ rɛ: Ḿpɑ́ úye kɛyu-i kɑm símisi ɑm kɔ mɛsɛ́rɛ Pisuifi ɑyomɛyɑ́hɑɑlee-i nɛ Uléécɑɑ kɛyɔ-i kɛ Pisuifi nnɛ́í ɑpi yɛ n cɑ́pinɛ céesi. Ám kɛtumɛ ńkɑ mɛyɑɑ mɑ. ");
INSERT INTO soy_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Yo nnyɑ kɑɑ pɛɛ nɛ́ písɛisɛ? Pɛpɛɛ n kṍ nɛn símisi kɑɑ yɛ́ pisɛ rɛ yo kɛcɑ́ɑ́ kɑm pi símisi. Pɛ̃ nɛ nyulɛ ńsɔnɛ lɛ̃ kɛ nɛ́ɛ ḿ mɑ. ");
INSERT INTO soy_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Kɛ pimɛ́rɛ́ pɛ̃ usɛ uu lɛ̃ n kṍ, uu Yeesu kɛpɛsɛ tɔlu uu u pisɛ rɛ: Lɛ̃ kɑɑ yɛ́ pɛɛ usínɑ rinɔ́ɔ pɛsɛɛ? ");
INSERT INTO soy_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yeesu uu pɛɛ u mɑɑ rɛ: In tɛ ɑ́m ńsɔnɛ símisi, ɑ nɛ́ símisi kei kɑm m púnnɛ. Amɑ́ in tɛ nɛ ńsɔnɛ símisilɛ, yo nnyɑ kɑɑ pɛɛ nɛ́ pi? ");
INSERT INTO soy_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Anɑ uu pɛɛ u kpísi un lɛ̃ pɑhɑɑlɛ̃ uú nɛ usínɑ Kɑyifu u pɑpɔ. ");
INSERT INTO soy_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simɔɔ Piyɛɛ yɛ pɛɛ likumúŋɛ́ kpɛ-i welɛ un nnɑ wéni. Api u pisɛ rɛ: Ńté pɔ̃́ nɛ kɔ utisi uyɛ̃ upirɛtiki lɛ? Uu kɛ́su uu rɛ: Aɑí, ɑ́m utisi uyɛ̃ upirɛtiki. ");
INSERT INTO soy_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Usínɑ ukɛikɔ́ usɛ yɛ pɛɛ utisi uyɛ̃ kɛ Piyɛɛ uu kutu rińseḿ umɑrɛcɔ lɛ. Uu pɛɛ Piyɛɛ pisɛ rɛ: Ái nɔ́ nɛ uyɛ̃ kɑm ɑléé kɛcɑrɛ-pɔ yɛ̃́ɛ? ");
INSERT INTO soy_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Piyɛɛ uu kɔ Yeesu pikɛ́ŋɛ kpɑ́. Mɛsɛ nɛ mɛsɛ, icɑ̃́ ii kooi. ");
INSERT INTO soy_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Api mmɑrɛ mɑrɛ Kɑyifu kɛyɔ-i Yeesu kpísi ɑpí nɛ riyɔ́ɔpipoo sĩ. Amɑ́ Pisuifi piwɛ́ɛ́sɛ ɑ́pi pɛɛ lompɔ rɛ ɑ́i kɑpɛ mɛ́kpɛrinkpɛ pi wɑisɛ, ɑ́pi yɛ́ pɛɛ fe pikɛ́ nkpɔ mɛlɔ́ɔ́ ɑnyɑ̃́ li nnyɑ. ");
INSERT INTO soy_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Lɛ̃ nnyɑ kɛ Pilɑti uu léepɔ uu pi lɛɛpɔ, uu pi pisɛ rɛ: Ń-ye kɑni nɛ usoi nkó túhɑɑnɛ? ");
INSERT INTO soy_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Api u pɛsɛ rɛ: Usoi nkó unsɑ́ pɛɛ mɛwɑi kópɛ n wɑi, ɑ́ri yɛ́ pɛɛ ɑpɔ́nípɛ-i u wɑ. ");
INSERT INTO soy_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Kei kɛ Pilɑti uu pɛɛ pi mɑɑ rɛ: In lɛ̃, ɑni u kpísi ɑní nɛ nɔ́rinɛ́cúruu u túhɑɑnɛ yɑrɛ kɑi nɔ́inɛ́sé kɛ́mɛɛ m pisɛ. Pisuifi ɑpi u pɛsɛ rɛ: Ári ncée mɑ́ tɔkɛ́ unyinɛ kpu. ");
INSERT INTO soy_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Tinɔ́ɔ tɛ̃ kɛ Yeesu uú pɛɛ ḿ mɑ uú nɛ nkpɔ mmɛ̃ kuu n kpinɛ kɛcɑ́ɑ́ símisi kɑi lɛ̃ titiki. ");
INSERT INTO soy_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilɑti uu riyɔ́ɔpipoo-i lompɔ uu Yeesu pisɛ rɛ: Pɔ́ɔ Pisuifi Uyɔɔpii? ");
INSERT INTO soy_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yeesu uu rɛ: Pɔ́ɔ ripɔ́cúruu lɛ̃ pisɛ nɛ́ɛ unyinɛ yɛɛ nnɛ́símɛ́ pɔ́ símisi? ");
INSERT INTO soy_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilɑti uu rɛ: Pɔ nyu rɛ nɛ̃́ nɛ Usuifi lɛɛ? Mpɔ́puri pikɔ́ nɛ pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ pɛɛ ɑnɛ́nípɛ-i pɔ́ wɑ. Yo kɑɑ mpíí wɑ? ");
INSERT INTO soy_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yeesu uu rɛ: Kɛnɛ́yɔ́ɔpitẽ ɑ́kɛ kɛtẽ nté kɛkɔ́. Nɛn pɛɛ kɛtẽ nté iyɔɔpi n le, pinɛ́kɛikɔ́ yɛ́ pɛɛ kɛnɛ́cɑ́ɑ́ ɑtɔpi wɑ rɛ ɑ́pi kɑpɛ Pisuifi ɑnipɛ-i nɛ́ wɑ nnyɑ. Amɑ́ inɛ́yɔ́ɔpi íi nkpɑ́ni kɛtẽ nté ikɔ́. ");
INSERT INTO soy_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Kei kɛ Pilɑti uu pɛɛ u pisɛ rɛ: Lɛ̃ nnyɑ, pɔ uyɔ́ɔpi lɛɛ? Yeesu uu rɛ: Lɛ̃ kɑɑ nní mɑ. Nɛ uyɔ́ɔpi lɛ. Pi nɛ́ mɑ́rilɛ ɑm kɛtẽ kɛcɑ́ɑ́ weri rɛ kɛ́ nsímɛ́sei kɛcɑ́ɑ́ símisi. Nkó yɛɛ nsímɛ́sei m mɑ́ yɛ̀ɛ̀ kutu nɛ́ ricɔlɛ. ");
INSERT INTO soy_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilɑti uu u pisɛ rɛ: Yo kɑpi yɛ sée rɛ nsímɛ́sei? Kɛ Pilɑti uu lɛ̃ Yeesu pipisɛ ḿ mɑsí, uu yisi uu piléepɔ kpɑ́ uu Pisuifi lɛɛpɔ, uu pi mɑɑ rɛ: Nɛ̃́ ɑ́m yɛ̃ yo kuu cɑɑi nnyɑ kɑpi yɛ́ nɛ u ń kpu. ");
INSERT INTO soy_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Amɑ́ li nɔ́kɛnɛ́mɛɛ inyɛ́kii lɛ rɛ kɛ́ yɛ ḿpɑ́ nkpɔ mɛlɔ́ɔ́ ɑnyɑ̃́ ɑ́ye kɛ́mɛɛ ukpɑniikɔ́ usɛ unyinɛ ɑkpɑnii tɔ. Nɔ lɑ rɛ kɛ́ Pisuifi Uyɔɔpi ɑkpɑnii nɔ́ tɔɔ? ");
INSERT INTO soy_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Api pɛɛ picɑ́ɑ́i kpɑ́ rɛ: Aɑí, ɑ́i uyɛ̃, ɑ Pɑrɑpɑsi ɑkpɑnii rɔ́ tɔ. Pɑrɑpɑsi yɛ pɛɛ kɔ usoi kpɑ́ɑ́ree lɛ. ");
INSERT INTO soy_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Kei kɛ Pilɑti uu pɛɛ ncée hɛ rɛ pikɛ́ Yeesu tĩ pikɛ́ isɛ́í u súúkɛɛ. ");
INSERT INTO soy_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Pisɔ́ɔ́cɑ ɑpi inípɛ nɛ riyɔ́ɔpikɔŋ yóóni ɑpi u kipisɛ, ɑpi kɔ kukpɛ́lɛnku wɛɛ́ nyɑii kpísi ɑpi u tɑni. ");
INSERT INTO soy_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Api pɛɛ ukɛkúrí nyɔsɔ́pɔ ɑpi yɛ pɛɛ rɛ: Tɔ pɔ́ yɑ́ɑsi, Pisuifi uyɔɔpi! Apí nɛ sipɛsɛ u tɔlu. ");
INSERT INTO soy_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilɑti uu kɔ piléepɔ kpɑ́, uu pisoi pɛɛ n cɑ́pinɛlɛ̃ mɑɑ rɛ: Uyɛɛ nkó kɑḿ nɛ kɛtɑhɑi nɔ́ léemɛ nɔkɛ́ céri rɛ ɑ́m yɛ̃ yo kuu cɑɑi nnyɑ kɑpi yɛ́ nɛ u ń kpu. ");
INSERT INTO soy_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Yeesu uu pɛɛ léepɔ un tiyɔ́ɔpikɔŋ kɑpí nɛ inípɛ n yóõ kipilɛ̃ un kɔ kukpɛ́lɛnku wɛɛ́ nyɑii tɑnɑɑlɛ̃. Pilɑti uu pɛɛ pi mɑɑ rɛ: Usoi uyɛɛ nkó! ");
INSERT INTO soy_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Kɛ pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ nɛ pimɛ́rɛ́ ɑpi u n yɛ̃́ ɑpi cɑ́ɑ́i rɛ: A kunɑpɛ́ɛ́kɔɔ́ kɛcɑ́ɑ́ u kɑrii! A kunɑpɛ́ɛ́kɔɔ́ kɛcɑ́ɑ́ u kɑrii! Kei kɛ Pilɑti uu pɛɛ pi mɑɑ rɛ: Ani nɔ́rinɛ́cúruu u kpísi ɑní hɑ kɑrii. Nɛ̃́ ɑ́m yɛ̃ yo kuu cɑɑi nnyɑ kɑpi yɛ́ nɛ u ń kpu. ");
INSERT INTO soy_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Pisuifi ɑpi u pɛsɛ rɛ: Tɔ isé inyinɛ mɑ́lɛ yɛɛ m pisɛ rɛ ukɛ́ kpu rɛ u umɛcirɛ wɑisɛ Uléécɑɑ Kɛpipi nnyɑ. ");
INSERT INTO soy_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Kɛ Pilɑti uu ɑnɔ́ɔ nyɛ̃ n kṍ, iwɑmɛ ii mɛyɑ̃́ pilonɛ u kpɑ́. ");
INSERT INTO soy_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Uu riyɔ́ɔpipoo-i lompɔ uu Yeesu pisɛ rɛ: Pɔ yei ukɔ́ lɛ? Amɑ́ Yeesu úu rinɔ́ɔ u yɔsí. ");
INSERT INTO soy_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilɑti uu pɛɛ u mɑɑ rɛ: Áɑ lɑ pɔkɛ́ rinɔ́ɔ nɛ́ yɔsí, nɛ́ɛ yo? Áɑ nyu rɛ nɛ́ fe ɑm tíyɛsɛ ɑpi pɔ́ yɑ́ nɛ́ɛ ɑm tíyɛsɛ ɑpi kunɑpɛ́ɛ́kɔɔ́ kɛcɑ́ɑ́ pɔ́ kɑrii? ");
INSERT INTO soy_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yeesu uu pɛɛ u pɛsɛ rɛ: Áɑ ńnɑŋɛ ńkɑ kɛnɛ́cɑ́ɑ́ mɑ́, insɑ́ mmɛ̃ kɛ Uléécɑɑ uu pɔ́ ḿ pɑ rɛ ɑ kɛnɛ́cɑ́ɑ́ m mɑ́. Lɛ̃ nnyɑ kɛ uyɛɛ ɑpɔ́nípɛ-i nɛ́ ń wɑ ɑkópɛ ɑɑ ɑpɔ́kɔ́ fe. ");
INSERT INTO soy_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Kɑí nɛ kumúŋɛ́ kpɛ-i n kpísi, Pilɑti uu pɛɛ́ n wɛ́ɛ́si ukɛ́ Yeesu riyɑ́pɔ. Amɑ́ Pisuifi ɑpi sicɑ́ɑ́ilɑ loni rɛ: Pɔn u rin-yɑ́pɔ, ɑ́ɑ pɛɛ Rɔm uyɔɔpi usɑnɛ! Usoi nkó yɛɛ umɛcirɛ n nyɑ́ni rɛ uyɔ́ɔpi yɛ Rɔm uyɔɔpi ulɑɑrɔ lɛ. ");
INSERT INTO soy_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Kɛ Pilɑti uu ɑnɔ́ɔ nyɛ̃ n kṍ, uú nɛ Yeesu kɛtɑhɑi leepɔ, uu pɛɛ́ hɑ kei kɑpi yɛ n sée rɛ ɑsɛ́hɛ́wɛɛ́pi kɛlõ riyɔ́ɔpitũ kɛcɑ́ɑ́ tonɛ. Pi yɛ kɛlõ kɛ̃ Mɛ́-epiree kɛ́mɛɛ sée rɛ Kɑpɑtɑ. ");
INSERT INTO soy_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Likɛ́ nɛ n weesi pikɛ́ nkpɔ mɛlɔ́ɔ́ ɑnyɑ̃́ n li, ituŋɛ kɛcírɛ kumúŋɛ́ kɑí pɛɛ lɛ̃ we. Pilɑti uu Pisuifi mɑɑ rɛ: Nɔ́unɛ́yɔ́ɔpi yɛ nkó! ");
INSERT INTO soy_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Amɑ́ ɑpi pɛɛ sicɑ́ɑ́ilɑ loni rɛ: A kpu! A kpu! A kunɑpɛ́ɛ́kɔɔ́ kɛcɑ́ɑ́ u kɑrii! Pilɑti uu pi pisɛ rɛ: Kɛ́ nɔ́unɛ́yɔ́ɔpi kunɑpɛ́ɛ́kɔɔ́ kɛcɑ́ɑ́ kɑrii? Pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ ɑpi u pɛsɛ rɛ: Rɔm uyɔɔpi mɛmɑ́ɑ́, ɑ́ri uyɔ́ɔpi úkɑ ucɔ mɑ́. ");
INSERT INTO soy_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Uu pɛɛ Yeesu kpísi uu piɑnipɛ-i wɑi rɛ pikɛ́ hɑ u kɑrii. Api pɛɛ Yeesu kpísi ɑpí nɛ tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yeesu uu uricuruu kunɑpɛ́ɛ́kɔɔ́ kpɛ̃ kɛcɑ́ɑ́ kɑpi u n kɑriinɛ cɔni uú nɛ kuyu-i léepɔ, uú nɛ kɛlõ kɛ̃ kɑpi yɛ n sée rɛ Kúyu Koŋoo sĩ. Pi yɛ kei nɛ Mɛ́-epiree sée rɛ Kɔlikɔtɑ. ");
INSERT INTO soy_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Kei kɑpi u nɛ pisoi pitɛ́ pinyinɛ ɑnɑpɛ́ɛ́kɔɔ́ kɛcɑ́ɑ́ kɑrii, ucɔ uilúkɛ́ isɛ, ucɔ icɔ, Yeesu kunɑpɛ́ɛ́kɔɔ́ ɑku pɛɛ kɛcɔpɛ n we. ");
INSERT INTO soy_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilɑti uu kɔ tíyɛsɛ ɑpi kɛkpénkpélépi kɛcɑ́ɑ́ wɔ́lu ɑpi kunɑpɛ́ɛ́kɔɔ́ kɛcɑ́ɑ́ kɑrii. Pi kɛkɛcɑ́ɑ́ wɔ́i rɛ: Nɑsɑrɛti ukɔ́ Yeesu, Pisuifi uyɔɔpi. ");
INSERT INTO soy_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Pisuifi mɛyɑ̃ ɑpi iwɔ́i iyɛ̃ kɛɛni, kɑí nɛ kei kuyu n kɔ́lɛ̃ nnyɑ. Mɛ́-epiree nɛ Mɛ́lɑtɛɛ nɛ Mɛ́kirɛki kɑpí nɛ wɔi. ");
INSERT INTO soy_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Pisuifi pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ ɑpi Pilɑti mɑɑ rɛ: Pi wɔi rɛ Pisuifi Uyɔɔpi, ɑmɑ́ ɑ wɔi rɛ u mɑɑ rɛ: Nɛ Pisuifi Uyɔɔpi lɛ. ");
INSERT INTO soy_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilɑti uu pi pɛsɛ rɛ: Lɛ̃ kɑm n wɔ́i kɑm wɔ́i. ");
INSERT INTO soy_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Kɛ pisɔ́ɔ́cɑ ɑpi Yeesu kunɑpɛ́ɛ́kɔɔ́ kɛcɑ́ɑ́ pikɑrii ḿ mɑsí, ɑpi uilũ kpísi ɑpi hɔ́ɔ́nɛ ɑpi ɑfiri ɑnɑ wɑi, ḿpɑ́ usɔ́ɔ́cɑ úye uu rifiri risɛ kpísi. Api kɔ ukukpɛlɛnku wɛɛ́ nyɑii kpɛɛ ɑ́ku nnyɛlɑɑ m mɑ́ kpísi. Mɛsɑmɛ kɑpi ku yóõ kɛcɑ́ɑ́ nɛ mɛtene-pɔ. ");
INSERT INTO soy_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Api pɛɛ pimɛcɔpɛcirɛ n tee rɛ: Ári kɑpɛ ku ricɛɛ́ri. Amɑ́ tɔkɛ́ pɑŋɑi ɑrí nɛ yɛnu uyɛɛ yɛ́ ku n kpísi. Li lɛ̃ wɑlɛ likɛ́ nɛ lɛlɛɛ Nléécɑɑsimɛ́ ritɛlɛ́ kɛ́mɛɛ n wɔ́lɑɑlɛ̃ kɛcɑ́ɑ́ rintíki nnyɑ. Li wɔlɑɑlɛ̃ tɛ: Pi inɛ́lũ hɔɔnɛ ɑpi pɑŋɑi ɑpí nɛ uyɛɛ yɛ́ kunɛ́kpɛ́lɛnku wɛɛ́ nyɑii n kpísi yɛnu. Lɛ̃ kɛ pisɔ́ɔ́cɑ ɑpi n wɑ yɛ lɛ̃. ");
INSERT INTO soy_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Kunɑpɛ́ɛ́kɔɔ́ kpɛ̃ kɛcɑ́ɑ́ kɛ Yeesu uú pɛɛ n kɑriilɛ̃ kɛkúrí kɛ úni nɛ úni uwɑ̃ nɛ Kulopɑɑsi unɔsi Mɑɑri nɛ Mɑkitɑlɑ kuyu ukɔ́ Mɑɑri ɑpí pɛɛ nyɛnu. ");
INSERT INTO soy_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yeesu uu úni yɛnu, uupirɛtiki uyɛ̃ kuú pɛɛ ń lɑ pɔ́ɔn úni kɛkúrí nyɛnu. Yeesu uu úni mɑɑ rɛ: Unɔ́si, upɔ́ŋmɑ́nɛ yɛ nɛni nkó. ");
INSERT INTO soy_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Uu kɔ uupirɛtiki uyɛ̃ mɑɑ rɛ: Upɔ́ni yɛ nɛni nkó. Kɑí nɛ kei n kpísi, uyɛ̃ uu pɛɛ Yeesu uni kpísi uu ukɛyɔ-i yekei. ");
INSERT INTO soy_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Kɛ Yeesu uu n yɛ̃́ tɛ u lɛ̃ nnɛ́í kuu piwɑi ń kɑ piwɑi mɑsilɛ, uu rɛ: Nnírɛ́ yɛ nɛ́ welɛ. Likɛ́ nɛ lɛlɛɛ Nléécɑɑsimɛ́ ritɛlɛ́ kɛ́mɛɛ n wɔ́lɑɑlɛ̃ kɛcɑ́ɑ́ rintíki nnyɑ kuu lɛ̃ mɑ. ");
INSERT INTO soy_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Kulũ kunyinɛ yɛ pɛɛ kei kɛkúrí nɛ pítɑ nyɛpɛ-nyɛpɛ mɛyipɛ yisunulɛ. Pisɔ́ɔ́cɑ ɑpi kuyúi kpɛ̃ kɑpi yɛ n sée rɛ isɔɔpi kɛkpɑ́pi kpísi, ɑpi sinɛ́ɛ̃ sinyinɛ pítɑ nyɛpɛ-nyɛpɛ pɛ̃ fɛ ɑpi kɛkɛcɑ́ɑ́ tuhu ɑpí nɛ Yeesu nnɔɔ kuwɛ́ɛ́-mɛ̃ sĩ. ");
INSERT INTO soy_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yeesu uu pítɑ nyɛpɛ-nyɛpɛ pɛ̃ sɔɔmú uu pɛɛ rɛ: Ḿpɑ́ yo yɛ piwɑi mɑsilɛ. Kuu lɛ̃ ḿ mɑ, uu pɛɛ kpɑrɑ́, nfɑ́ɑ nn tɛnɛ. ");
INSERT INTO soy_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Likɛweesi kɛɛ kɛwéntɛyɑɑ kɛtúŋɛ́. Kɛwéntɛyɑɑ kɛ̃ nɛ kɔ pɛɛ kɛyɑ́ɑ píimɑ lɛ. Sisoikópɛ ɑ́si kɑpɛ nɛ kɛwéntɛyɑɑ kɛ̃ kɛtúŋɛ́ kunɑpɛ́ɛ́kɔɔ́ kɛcɑ́ɑ́ ń kɔ́lɔilɛ̃ nnyɑ, ɑpi Pilɑti pisɛ rɛ ukɛ́ tíyɛsɛ pikɛ́ ɑpɑ́í si selesi ɑpi pɛɛ si súisɛntɛ. ");
INSERT INTO soy_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Pisɔ́ɔ́cɑ ɑpi pɛɛ́ hɑpɔ ɑpi pisoi pitɛ́ pɛ̃ nɛ Yeesu kɑpi kɛsẽ́ u kɑrii ufoí ɑpɑ́í selu, ɑpi kɔ ulírũ ɑkɔ́ selu. ");
INSERT INTO soy_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Api Yeesu-i tuipɔ. Kɑpi n yɛ̃́ tɛ u pikpɔ mɑsilɛ nnyɑ, ɑ́pi pɛɛ ɑpɑ́í u sei. ");
INSERT INTO soy_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Amɑ́ pisɔ́ɔ́cɑ pɛ̃ usɛ uu ilúkɛ́-i kupɑ́ŋ́ u tuhu uu luru, mɛsɛ nɛ mɛsɛ, mɛ́nyɛ nɛ míni ɑmɛ léeri. ");
INSERT INTO soy_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Uyɛɛ mɛwɑi mɛ̃ n yɛ̃́ yɛ mɑɑ rɛ ɑsei yɛ nyɛ. Lɛ̃ kuu ḿ mɑ yɛ kɔ ɑsei lɛ. Uyɛɛ nyulɛ rɛ ɑsei kuu símisi. U símisilɛ rɛ nɔ́ɔkɛ́ kɔ nɛ kɛfɑ tɛnɛ. ");
INSERT INTO soy_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Li lɛ̃ wɑlɛ likɛ́ nɛ lɛlɛɛ Nléécɑɑsimɛ́ ritɛlɛ́ kɛ́mɛɛ n wɔ́lɑɑlɛ̃ tintíki nnyɑ. Lɛlɛɛ rɛ: Ápi ukukɔhɔ kúkɑ selunɛ. ");
INSERT INTO soy_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Li kɔ rikɛlõ kɛcɔ-i wɔ́lɑɑlɛ̃ tɛ: Pi yɛ́ kɑm ɑpi yɛ uyɛ̃ kɑpi ilúkɛ́ n luri kuwɛ́ɛ́-mɛ̃ n nyɑ́nɛi. ");
INSERT INTO soy_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Lɛ̃ mɛmɑ́ɑ́, Arimɑtee kuyu ukɔ́ kɑpi yɛ n sée rɛ Yosɛfi uu Pilɑti ncée welu rɛ ukɛ́ Yeesu kpísi ukɛ́ hɑ kulɛsi. Pilɑti uu ŋmurɛi. Pisuifi iwɑmɛ yɛ pɛɛ Yosɛfi uyɛ̃ welɛ, úu pɛɛ lɛ̃ nnyɑ nyísɛlɛ̃ tɛ u Yeesu upirɛtiki lɛ. Uyɛɛ hɑ uu Yeesu kpísi uú nɛ tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikotɛm yɛɛ kɛsinɛ kɛnyinɛ Yeesu kɛ́mɛɛ ń hɑ, pɔ́ɔ kɔ tulɑɑliyɛ pɛ̃ kɑpi yɛ n sée rɛ miiri nɛ ɑlowɛɛsi mɛcɔ́hɔnɛ sikiloo ɑfɛɛtɑɑni kumúŋɛ́ nɛ hɑpɔ. ");
INSERT INTO soy_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Pikɛtɛ́ ɑpi Yeesu kpísi ɑpi sisɑ́ŋɑ́ɑ́pɑmpi pílɛsi, ɑpi tulɑɑliyɛ pɛ̃ u fom yɑrɛ kɑpi yɛ pɛɛ Pisuifi inyɛkii kɛ́mɛɛ usoi n kúlɛsi mɛcɔ. ");
INSERT INTO soy_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Kei kɑpi Yeesu kunɑpɛ́ɛ́kɔɔ́ kɛcɑ́ɑ́ n kɑrii kɛkúrí kɛ kɛléécɑrɛ kɛnyinɛ ɑkɛ́ pɛɛ́ we. Nhórɛ fɑlɛ nnyinɛ kɛ́mɛɛ kɑ́pi úkɑ n wɑilɛ̃ yɛ pɛɛ kɛléécɑrɛ kɛ-i welɛ. ");
INSERT INTO soy_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Likɛweesi kɛɛ Pisuifi kɛwéntɛyɑɑ. Nhórɛ nn kɔ nɛ kei kɔlɛ̃. Api lɛ̃ nnyɑ kei Yeesu wɑipɔ. ");
INSERT INTO soy_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Kɛwéntɛyɑɑ ukóso, Mɑkitɑlɑ kuyu ukɔ́ Mɑɑri uu kɛmɑrɛsinɛ yisi, lin hiihiilɛ̃ uu nhórɛ-i sĩ́, uu yɛnu rɛ pi ripɑrɛ kɑpi nhórɛ rińfi lesɛlɛ. ");
INSERT INTO soy_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Uu itóó wɑi uú nɛ Simɔɔ Piyɛɛ nɛ uupirɛtikicɔ uyɛ̃ kɛ Yeesu uú pɛɛ mɛyɑ̃́ ń lɑ lɛɛpɔ, uu pi mɑɑ rɛ: Pi Upíimɑ nhórɛ kɛ́mɛɛ lésɛlɛ, ɑ́ri nyu yei kɑpi u wɑ. ");
INSERT INTO soy_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Kei kɛ Piyɛɛ nɛ uupirɛtikicɔ uyɛ̃ ɑpi yisi ɑpi nhórɛ-i sĩ́. ");
INSERT INTO soy_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Api pikɛtɛ́ itóó wɑi, ɑmɑ́ ucɔ uyɛ̃ uu Piyɛɛ fɑɑu uú hɑ nhórɛ-i mɛfoí tulu. ");
INSERT INTO soy_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Uú fo uu lóólúpɔ, uu sisɑ́ŋɑ́ɑ́pɑmpi yɛnu sin kɛteni-i lɑɑnu, ɑmɑ́ úu pɛɛ lompɔ. ");
INSERT INTO soy_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simɔɔ Piyɛɛ yɛɛ u n tíkilɛ̃ pɔ́ɔ kɔ tuipɔ. Uyɛ̃ uu nhórɛ-i lompɔ uu sisɑ́ŋɑ́ɑ́pɑmpi sɛ̃ kɛteni-i yɛ́nu. ");
INSERT INTO soy_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Uu kɔ kusɑ́ŋɑ́ɑ́ kpɛ̃ kɑpí pɛɛ Yeesu ríyu m pɑɑsi yɛnu kun pílɑɑlɛ̃ kun kumɛcirɛ kɛlõ iyɑɑ yisunu, sisɑ́ŋɑ́ɑ́pɑmpi ɑ́si kei we. ");
INSERT INTO soy_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Kei kɛ uupirɛtiki ucɔ uyɛɛ pɛɛ mɛfoí nhórɛ-i n tuipɔ pɔ́ɔ kɔ lompɔ, uu yɛ́nu uu pɛɛ́ nɛ kɛfɑ tɛnɛ. ");
INSERT INTO soy_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Asei kɛcɑ́ɑ́, hɑ́i nɛ kumúŋɛ́ kpɛ-i, ɑ́pi pɛɛ kɑhɑnɛ lɛlɛɛ Nléécɑɑsimɛ́ ritɛlɛ́ kɛ́mɛɛ n wɔ́lɑɑlɛ̃ ɑsei n kõ tɛ li pisɛ rɛ Yeesu ukɛ́ pikpɔkpɔ kɛ́mɛɛ yisi. ");
INSERT INTO soy_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Lɛ̃ mɛmɑ́ɑ́, pipirɛtiki pɛ̃ kɛtɛ́ ɑpi yisi ɑpí kulu. ");
INSERT INTO soy_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mɑɑri pɔ́ɔ pɛɛ kɛtɑhɑi-pɔ nhórɛ kɛkúrí tonɛ uú n téni. Kuu lɛ̃ ń we un téni, uú fo uu nhórɛ kɛ́mɛɛ lóólúpɔ. ");
INSERT INTO soy_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Uu piléécɑɑtumɛ pitɛ́ pinyinɛ yɛnu pin ilũ tomɛ́ tɑnɑɑlɛ̃ pin nɛ kei kɑpí pɛɛ Yeesu n finsɛ tũ, ucɔ ríyu-mɛ̃, ucɔ ɑ́nɑ-mɛ̃. ");
INSERT INTO soy_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Api u pisɛ rɛ: Yo nnyɑ kɑɑ téni, unɔ́si? Uu pi pɛsɛ rɛ: Pi Unɛ́píimɑ kpísilɛ ɑpí nɛ tɔ́mpɔ, ɑ́m pɛɛ nyu yei kɑpi u wɑ. ");
INSERT INTO soy_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Kuu lɛ̃ ḿ mɑ, uu pɛɛ kɛpirɛ-mɛ̃ weríí uu Yeesu yɛnu un nyɛnu, úu kɔ ceri rɛ uyɛɛ lo. ");
INSERT INTO soy_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Kei kɛ Yeesu uu pɛɛ u pisɛ rɛ: Yo nnyɑ kɑɑ téni, unɔ́si? Úye kɑɑ wɛ́ɛ́si? Uu pɛɛ músu rɛ uyɛɛ kɛléécɑrɛ kɛcɑ́ɑ́ ḿ pɑílɛ̃ lo. Lɛ̃ nnyɑ kuu u pɛsɛ rɛ: Urɔ́sɑ́ɑ, in tɛ pɔ́ɔ u kpísi ɑɑ́ nɛ tɔ́mpɔ, ɑ nɛ́ símisi kei kɑɑ u n wɑ kɛ́ hɑ u kpísi. ");
INSERT INTO soy_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Kei kɛ Yeesu uu pɛɛ u sée rɛ: Mɑɑri! Uu pɛɛ ukuwɛ́ɛ́-mɛ̃ pɑnsɛpɔ uú nɛ Mɛ́-epiree u pɛsɛ rɛ: Rɑpuni. Liɑsei rɛ Ucélɑɑ. ");
INSERT INTO soy_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yeesu uu u mɑɑ rɛ: Kɑpɛ nɛ́ ricɑ, ɑ́m kɑhɑnɛ Unɛ́sɑ́ɑ kɛ́mɛɛ rintɑɑ́. Amɑ́ ɑ hɑ pinɛ́mɑ́rɛcɔ símisi rɛ Unɛ́sɑ́ɑ yɛɛ kɔ nní Nɔ́unɛ́sɑ́ɑ nɛ Unɛ́léécɑɑ un kɔ Nɔ́unɛ́léécɑɑ kɛ́mɛɛ kɑḿ tɑɑ́lɛ̃. ");
INSERT INTO soy_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Kei kɛ Mɑkitɑlɑ kuyu ukɔ́ Mɑɑri uu pɛɛ́ hɑ pipirɛtiki símisi rɛ u Upíimɑ yɛnlɛ. Uu pɛɛ lɛ̃ kɛ Upíimɑ uu u n símisi pi símisi. ");
INSERT INTO soy_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Kɛwéntɛyɑɑ kɛ̃ ukóso, Yeesu pipirɛtiki pin nnyɔ́ɔ́ mmɛ̃ kɛ́yɔ kɛnyinɛ-i cɑ́pinɛlɛ̃. Pisuifi iwɑmɛ yɛ pɛɛ pi welɛ. Api lɛ̃ nnyɑ hɑ́nɑɑnkɛɛ ɑpi pɛɛ kɛ́mɛɛ n we. Kei kɛ Yeesu uu pɛɛ pikɛcɔpɛ leemɛ uu pi mɑɑ rɛ: Nɔ́ɑnɛ́kíŋ ɑkɛ́ n niŋú! ");
INSERT INTO soy_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Kuu lɛ̃ pi ḿ mɑ, uu pɛɛ uɑnipɛ nɛ uilúkɛ́ pi nyísɛ. Upipirɛtiki rikiŋ ɑri níŋɛsi rɛ pi Upíimɑ yɛ̃ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Kei kɛ Yeesu uu kɔ pimɑ́ɑ pi rikpɑ́ rɛ: Nɔ́ɑnɛ́kíŋ ɑkɛ́ n niŋú! Yɑrɛ kɛ Unɛ́sɑ́ɑ uu nɛ́ n tummɛ mɛcɔ kɛ nɛ́ɛ kɔ nɔ̃́ tum. ");
INSERT INTO soy_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Kuu lɛ̃ pimɑ́ɑ ḿ mɑsí, uu pikɛcɑ́ɑ́ fúupɔ uu rɛ: Ani Nfɑ́ɑsɔnɛ yɔsí. ");
INSERT INTO soy_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nɔn yɛ píye ɑkópɛ n sɑ́rɛi, Uléécɑɑ yɛ́ kɔ piɑkópɛ pi sɑ́rɛi. Nɔn yɛ rɛ ɑ́ni pinyinɛ ɑkópɛ sɑ́rɛinɛ, Uléécɑɑ pɑ́ɑ kɔ piɑkópɛ pi sɑ́rɛinɛ. ");
INSERT INTO soy_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomɑɑ kɑpi yɛ n sée rɛ Úsikɑ yɛ Yeesu pipirɛtiki kɛfi nɛ pitɛ́ pɛ̃ kɛcɔpɛ usɛ lɛ. Uyɛ̃ úu pɛɛ kumúŋɛ́ kpɛ-i kɛ Yeesu uu pikɛmɛɛ́ n hɑ́pɔ we. ");
INSERT INTO soy_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Upipirɛtikicɔ ɑpi pɛɛ u mɑɑ rɛ: Tɔ Upíimɑ yɛnlɛ. Uu pi pɛsɛ rɛ: Nɛnsɑ́ ihímɛ ɑpolɛ uɑnipɛ-i n yɛ̃ kɛ kɛnípɛpi tɑhɑmpɔ, kɛ́ kɔ kunɛ́nípɛ nɛ uilúkɛ́ ricɑ, ɑ́m yɛ́ ŋmurɛi. ");
INSERT INTO soy_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Siyɑ́ɑ sipɑhɑ mɛmɑ́ɑ́, pipirɛtiki pɛ̃ ɑpi kɔ kɛ́yɔ-i n cɑ́pinɛlɛ̃ kɛsẽ́ nɛ Tomɑɑ. Pin kɔ nɛ hɑ́nɑɑnkɛɛ, Yeesu uu kɔ pikɛcɔpɛ piléemɛ kpɑ́ uu nyɛrɛ, uu pi mɑɑ rɛ: Nɔ́ɑnɛ́kíŋ ɑkɛ́ n niŋú! ");
INSERT INTO soy_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Uu pɛɛ Tomɑɑ mɑɑ rɛ: A kɛpɔ́nípɛpi nté tɑhɑmpɔ ɑɑ ɑnɛ́nípɛ pɑí, ɑɑ kɔ kupɔ́nípɛ nɛ inɛ́lúkɛ́ cɑ. A lɛ̃ pitírɛ́ tíyɛ ɑɑ́ nɛ nkpéni kɛfɑ tɛnɛ. ");
INSERT INTO soy_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Kei kɛ Tomɑɑ uu pɛɛ u pɛsɛ rɛ: Unɛ́píimɑ nɛ Unɛ́léécɑɑ! ");
INSERT INTO soy_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yeesu uu u mɑɑ rɛ: Kɑɑ nɛ́ ń yɛ̃́ nnyɑ kɑɑ́ nɛ kɛfɑ nɛ́ tɛnɛ. Pɛpɛɛ ɑ́pi nɛ́ ń yɛ̃́, pin kɔ pɛɛ́ nɛ kɛfɑ nɛ́ tɛnɛlɛ̃ pɛɛ pínɑrɛkomɛ. ");
INSERT INTO soy_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yeesu yɛ kɔ upipirɛtiki inipɛɛ-i mɛwɑisɑŋɑ mɛyɑ̃ ncɔpuri wɑpisilɛ mɛɛ ɑ́mɛ rítɛlɛ́ ntí-i n wɔ́lɑɑlɛ̃. ");
INSERT INTO soy_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pi lɛlɛɛ nní rikɛmɛɛ ń we wɔilɛ rɛ nɔkɛ́ nɛ n ŋmurɛi rɛ Yeesu kɛ Uléécɑɑ uu n wɛ́ɛ nnyɑ. Uyɛɛ kɔ Uléécɑɑ Kɛpipi. Nɔn nɛ kɛfɑ u n tɛnɛ, nɔ́ urinyiri nnyɑ nfɑ́ɑ yɛ̃. ");
INSERT INTO soy_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Lɛ̃ mɛmɑ́ɑ́, Yeesu uu pɛɛ kɛtumɛ Tiperiyɑɑti kupiyɛ ritimɛ umɛcirɛ upipirɛtiki nyísɛ. Lɛ̃ kuu umɛcirɛ pi n nyísɛ yɛ nní: ");
INSERT INTO soy_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simɔɔ Piyɛɛ nɛ Tomɑɑ kɑpi yɛ n sée rɛ Úsikɑ nɛ Nɑtɑnɑyɛɛli yɛɛ Kɑlilee kɛteni-i Kɑnɑɑ-pɔ ń we nɛ Sepetee piŋmɑ́nɛ nɛ upipirɛtiki pitɛ́ picɔ yɛ pɛɛ cɑ́pinɛlɛnlɛ. ");
INSERT INTO soy_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simɔɔ Piyɛɛ uu pi mɑɑ rɛ: Ikpíntomɛ́ kɑm picɔ́pii tɔ́su. Api u pɛsɛ rɛ: Tɔ̃́ nɛ́ kɔ pɔ́ ritiki ɑri kɛsẽ́ sĩ. Kei kɑpi yisi ɑpí hɑ kúninɔi loni ɑpi tɔ́mpɔ. Amɑ́ ɑ́pi kɛsinɛ kɛ̃ líkɑ tĩ. ");
INSERT INTO soy_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Kɑi piweesi n kórɑɑnɛ, Yeesu un kei kupiyɛ ritimɛ we, ɑmɑ́ upipirɛtiki ɑ́pi pɛɛ céri rɛ Yeesu lo. ");
INSERT INTO soy_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Kei kuu pɛɛ pi pisɛ rɛ: Nɔ ikpíntomɛ́ yɛ̃́ ɑni cɔ́pii, sinɛ́wɑ̃́? Api rɛ: Eehei! ");
INSERT INTO soy_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Uu pi mɑɑ rɛ: Ani kúninɔi kulukɛ-lukɛ-mɛmpɔ kunyɛŋ́ fṍ, nɔ́ linyinɛ tĩ. Api mɛsei kunyɛŋ́ fom ɑpi ikpíntomɛ́ tini ɑi ku yipu péḿ, ɑ́pi fe ricuruu pikɛ́ míni-i ku pɔnnɛ kɛ ikpíntomɛ́ ii kulúi ń we nnyɑ. ");
INSERT INTO soy_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Kei kɛ upirɛtiki uyɛ̃ kɛ Yeesu uú pɛɛ ń lɑ uu pɛɛ Piyɛɛ mɑɑ rɛ: Asé Upíimɑ lo! Kɛ Simɔɔ Piyɛɛ uu lɛ̃ n kṍ tɛ Upíimɑ lo, uu uilũ kuú pɛɛ m mɑhɑ̃ un pɛɛ mɛŋmɑnɛ ikpíntomɛ́ cɔ́pii pitɑnɛ pɛsɛ uú nɛ míni-i kpúupɔ. ");
INSERT INTO soy_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Pi pɛɛ kɛtẽ kóimɑ nɛ kɛtɑɑ welɛ yɑrɛ ɑpɑ́hɑ pílɛ kumúŋɛ́. Upipirɛtikicɔ ɑpi léeri, ɑpi pɛɛ kunyɛŋ́ nɛ ikpíntomɛ́ mɛyipɛ pɑsɑi ɑpi lésɛpɔ. ");
INSERT INTO soy_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Kɑpi kúninɔi kɛ́mɛɛ ń suí, ɑpi kupiyɛ ritimɛ nkɑlɛnɑ lɛɛpɔ, ikpíntomɛ́ nɛ ɑkpɔ́nɔ́ ɑn nkɛcɑ́ɑ́ lɑ́ɑlɛ̃. ");
INSERT INTO soy_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yeesu uu pi mɑɑ rɛ: Ani ikpíntomɛ́ iyɛ̃ kɑni n cɔ́pii kɛ́mɛɛ nɛ inyinɛ kɑm. ");
INSERT INTO soy_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simɔɔ Piyɛɛ uu kúninɔi kɛ́mɛɛ lompɔ uú hɑ kunyɛŋ́ nɛ ikpíntomɛ́ mɑɑmɑɑ mɛyipɛ súisɛri, ií lelu pílɛ nɛ kuwóó nɛ itɑɑni. Amɑ́ ḿpɑ́ nɛ imɛsɑ́ mɛ̃, kunyɛŋ́ ɑ́ku ricɛɛ́ri. ");
INSERT INTO soy_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yeesu uu pɛɛ pi séi uu rɛ: Ani kɑm ɑni li. Uupirɛtiki úkɑ úu kɔ pɛɛ kɑhɑ ukɛ́ u pisɛ rɛ: Pɔ́ɔ wóo? Pi pɛɛ nyulɛ rɛ Upíimɑ lo. ");
INSERT INTO soy_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yeesu uú nɛ pi kɔ, uu kukpɔ́nɔ́ kpísi uu pi hɔɔnɛ, uu kɔ ikpíntomɛ́ pi hɔɔnɛ. ");
INSERT INTO soy_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Kɛ Yeesu uú nɛ pikpɔkpɔ kɛ́mɛɛ n yisi, mɛtɑ́ɑ́nũ yɛ mɛ̃ kuu lɛ̃ umɛcirɛ upipirɛtiki nyísɛ. ");
INSERT INTO soy_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Kɑpi pilukɛ ḿ mɑsí, Yeesu uu pɛɛ Simɔɔ Piyɛɛ pisɛ rɛ: Yonɑɑsi uŋmɑ́nɛ Simɔɔ, pɔ nɛ́ lɑ ɑi tɔ́su lɛ̃ kɛ picɔ mpí ɑpi nɛ́ ń lɑɑ? Uu rɛ: Ɛɛɛ, Upíimɑ, tipɔ́cúruu yɛ nyulɛ rɛ nɛ pɔ́ lɑlɛ. Yeesu uu pɛɛ u mɑɑ rɛ: In lɛ̃, ɑ sinɛ́sɑ́ŋpi kɛcɑ́ɑ́ ńsɔnɛ m pɑílɛ̃. ");
INSERT INTO soy_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Uu kɔ mɛlírũ pipisɛ u kpɑ́ rɛ: Yonɑɑsi uŋmɑ́nɛ Simɔɔ, pɔ nɛ́ lɑɑ? Piyɛɛ uu u pɛsɛ rɛ: Ɛɛɛ, Upíimɑ, tipɔ́cúruu yɛ nyulɛ rɛ nɛ pɔ́ lɑlɛ. Yeesu uu u mɑɑ rɛ: In lɛ̃, ɑ inɛ́sɑ́ŋ ńsɔnɛ n séni. ");
INSERT INTO soy_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Uu kɔ mɛtɑ́ɑ́nũ pipisɛ u kpɑ́ rɛ: Yonɑɑsi uŋmɑ́nɛ Simɔɔ, pɔ nɛ́ lɑɑ? Simɔɔ Piyɛɛ ripɔɔ ɑri cɑɑi rɛ mɛtɑ́ɑ́nũ yɛ mmɛ́ kuu lɛ̃ u pisɛ rɛ “pɔ́ nɛ́ lɑɑ” nnyɑ. Uu pɛɛ u pɛsɛ rɛ: Pɔ ḿpɑ́ yo nyulɛ, Upíimɑ, pɔ kɔ nyulɛ rɛ nɛ pɔ́ lɑlɛ. Yeesu uu pɛɛ u mɑɑ rɛ: In lɛ̃, ɑ inɛ́sɑ́ŋ kɛcɑ́ɑ́ ńsɔnɛ m pɑílɛ̃. ");
INSERT INTO soy_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Asei kɛcɑ́ɑ́, kɛ́ pɔ́ símisi rɛ kɑɑ́ pɛɛ iŋmɑ́nɛ ń we, pɔ́ɔ yɛ pɛɛ ripɔ́cúruu kupɔ́tɑmpɑ́lɑ rité ɑɑ kei kɑɑ ń lɑ sĩ. Amɑ́ pɔn n kpurunu, pɔ́ pɛɛ ɑnípɛ risíkɑ, ucɔ uu pɔ́ ku pɑɑsi uú nɛ kei kɑ́ɑ ń lɑnɛ pɔ́ sĩ́. ");
INSERT INTO soy_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","U lɛ̃ mɑlɛ ukɛ́ nɛ nyísɛ lɛ̃ kɛ Piyɛɛ uu n kpinɛ likɛ́ nɛ Uléécɑɑ ríyu n wɑisɛ. Kuu lɛ̃ pisímɛ́ u ḿ mɑsí, uu pɛɛ u mɑɑ rɛ: A nɛ́ ritiki. ");
INSERT INTO soy_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Piyɛɛ uu kɛpirɛ ŋmɛɛlú uu upirɛtiki uyɛ̃ kɛ Yeesu uú pɛɛ ń lɑ yɛnu un pi tikipɔlɛ̃. Uyɛɛ pɛɛ ilukɛ kɛlukɛ-i Yeesu kɛcɑ́ɑ́ n finɛpɔ uu u pisɛ rɛ: Upíimɑ, wóo pilɑ́ɑrɔ ɑnipɛ kɛ́mɛɛ pɔ́ wɑinɛ? ");
INSERT INTO soy_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Kɛ Piyɛɛ uu lɛ̃ u n yɛ̃́, uu Yeesu pisɛ rɛ: Nkó ní, Upíimɑ, yo kɛ uyɛ̃ uú nɛ kɛ́tɔ kopunɛ? ");
INSERT INTO soy_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yeesu uu u pɛsɛ rɛ: Nɛn n lɑ rɛ ukɛ́ n we kɛ́ hɑ nɛ pɛɛmɛ, ɑi yei nɛ pɔ́ yɛ́nu? Pɔ́ɔkɛ́ nɛ́ ritiki. ");
INSERT INTO soy_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Lɛ̃ nnyɑ, nsímɛ́ nn piyómɛyɑ́hɑɑ kɛ́mɛɛ kɔ́ɔ́nú rɛ upirɛtiki uyɛ̃ úu kpinɛ. Ái kɔ rɛ Yeesu yɛ u mɑɑ rɛ úu kpinɛ, ɑmɑ́ u pɛɛ rɛ: Nɛn n lɑ rɛ ukɛ́ n we kɛ́ hɑ nɛ pɛɛmɛ, ɑi yei nɛ pɔ́ yɛnu? ");
INSERT INTO soy_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Upirɛtiki uyɛ̃ ticuruu yɛɛ ɑseérɑ lesɛ uu nsímɛ́ mmɛ̃ wɔlu. Tɔ kɔ nyulɛ rɛ lɛ̃ kuu n yɛ̃́ uú mɑlɛ yɛ nsímɛ́sei lɛ. ");
INSERT INTO soy_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yeesu yɛ kɔ mɛwɑi mɛyɑ̃ mɛcɔ wɑpisilɛ. Pin pɛɛ mɛnnɛ́í n wɔlunɛ mɛsɛ mɛsɛ, ɑ́m musí rɛ ɑ́tɛlɛ́ nyɛ̃ nnɛ́í kɑpi yɛ́ n wɔ́i yɛ́ kɛtẽ nkɛ́ nnɛ́í kɛcɑ́ɑ́ kɛwɑi yɛ̃.");
INSERT INTO soy_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Unɛ́sɑ́nɛ Teofiili, nɛ rítɛlɛ́ foí kɛ́mɛɛ pɔ́ símisilɛ lɛ̃ nnɛ́í kɛ Yeesu uu piwɑi nɛ picélɑɑ n kórɑɑnɛ ");
INSERT INTO soy_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","hɑ́i nɛ kɛyɑ́ɑ kɛ̃ kɑi kɛyómɛcɑɑ-mɛ̃ u n kpíipɔ. Ukɛ́ kɛlenɛ rińtɑɑ́, u upitumɛ kuu n wɛ́ɛ uicélɑɑ pɑlɛ nɛ Nfɑ́ɑsɔnɛ nnɑŋɛ. ");
INSERT INTO soy_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","U umɛkpɔ-mɑɑ́ mɛ́wee mpehẽ mpehẽ kɛ́mɛɛ umɛcirɛ pi nyísɛlɛ pikɛ́ céri rɛ u nfɑ́ɑ mɑ́lɛ. Siyɑ́ɑ ɑfɛɛnɑ kuu pi rikpɑ́fúmɛ uu Uléécɑɑ iyɔɔpi nsímɛ́ pi símisi. ");
INSERT INTO soy_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Kɛyɑ́ɑ kɛnyinɛ kɑpi kɛsẽ́ we nɛ Yeesu, uu pɛɛ isé nnyí pi pɑ rɛ: Áni kɑpɛ yisi nɔkɛ́ Yerusɑlɛm nɛ kɛtɑɑ wɑ, ɑmɑ́ ɑni lisɔnɛ lɛ̃ kɑni n kṍ nɛn símisi rɛ Sɑ́ɑ Uléécɑɑ yɛ nɛ nɔ́ mɛ̃́ kutu ricɔ. ");
INSERT INTO soy_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Míni ŋmɑnɛ kɛ Yohɑni uu nɔ́ wólɛ. Amɑ́ li tisɛ nkɑ́ripi, Uléécɑɑ ukɛ́ nɛ Nfɑ́ɑsɔnɛ nɔ́ wolɛ. ");
INSERT INTO soy_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Pɛpɛɛ pɛɛ Yeesu kɛyúrí n cɑ́pinɛlɛ̃ ɑpi pɛɛ u pisɛ rɛ: Kumúŋɛ́ kpɛ-i kɑɑ Isirɑyɛɛli kɛyɔɔpitẽ pɛsɛrinɛɛ, Upíimɑ? ");
INSERT INTO soy_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Uu pi pɛsɛ rɛ: Ái nɔ́nnɛ́kɔ́ ńkɑ rɛ nɔkɛ́ mɛwɑi mɛɛ n sɔ́nti kumúŋɛ́ nɛ mɛituŋɛ n nyu. Sɑ́ɑ Uléécɑɑ yɛɛ lɛ̃ nɛ uricuruu nnɑŋɛ yekei. ");
INSERT INTO soy_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Amɑ́ Nfɑ́ɑsɔnɛ nn nɔ́kɛnɛ́cɑ́ɑ́ n súimɛ, nɔ́ ńnɑŋɛ nnyinɛ yɛ̃, ɑni pɛɛ pɑnsɛ pinɛ́tɑnsei Yerusɑlɛm kuyu-i nɛ Yutee kɛtẽ kɛcɑ́ɑ́ nnɛ́í nɛ Sɑmɑrii kɛtẽ kɛcɑ́ɑ́, hɑ́i nɛ kɛtẽ nnɛ́í kɛtɔ-pɔ. ");
INSERT INTO soy_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Kɛ Yeesu uu rinɔ́ɔ tɛ̃ pimɑ́ɑ ḿ mɑsí, ɑi kɛyómɛcɑɑ-mɛ̃ u kpíípɔ, ḿpɑ́ úye un u nyɑ́nɛipɔ ɑhopɛ ɑnyinɛ ɑɑ́ weri ɑɑ́ nɛ u yɑrii ɑpi pɛɛ u pɑɑpɔ. ");
INSERT INTO soy_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Pin kei nní lɛ̃ we pin kɛléécɑɑ inípɛɛ wiilɛ̃ un tɔ́su kɛ pitisi pitɛ́ pinyinɛ pɛɛ ilũ tomɛ́ n tɑnɑɑlɛ̃ ɑpi pikɛyúrí rikpɑ́fúmɛ. ");
INSERT INTO soy_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Pitisi pɛ̃ ɑpi pi mɑɑ rɛ: Yo nnyɑ kɛ nɔ̃́ Kɑlilee pikɔ́ mpí ɑni nní nyɛnu nɔn kɛléécɑɑ-mɛ̃ nyɑ́nɛi. Lɛ̃ kɑi nní nɔ́kɛnɛ́cɔpɛ nkɛ́-i Yeesu uyɛ̃ kɛléécɑɑ-mɛ̃ n kpíipɔ nɔn nyɑ́ni mɛcɔ kuú hɑ pɛɛri. ");
INSERT INTO soy_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Pitumɛ ɑpi pɛɛ kɛlõ kɛ̃ kɑpi yɛ n sée rɛ Olifiyee rikúú yisi ɑpi Yerusɑlɛm pɛlɛ. Tikúú tɛɛ nɛ Yerusɑlɛm kɔlɛnlɛ. Lirinɑ̃ nɛ sɑ́ yɑrɛ kilomɛtiri usɛ. ");
INSERT INTO soy_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Kɑpi n tuipɔ, ɑpi kulee kunyinɛ-i tɑɑ́ kɛ́yɔ kɛnyinɛ kɛcɑ́ɑ́-pɔ. Kei kɑpi yɛ cɑ́pinɛ. Pɛpɛɛ kei n cɑ́pinɛlɛ̃ pɛɛ Piyɛɛ nɛ Yohɑni nɛ Yɑkupu nɛ Antiree nɛ Filipu nɛ Tomɑɑ nɛ Pɑtelemii nɛ Mɑtiyee nɛ Alifee uŋmɑ́nɛ Yɑkupu nɛ Simɔɔ yɛɛ ukuyu ń lɑ nɛ Yɑkupu uŋmɑ́nɛ Yuuti ");
INSERT INTO soy_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","nɛ Yeesu uni Mɑɑri nɛ pinɔ́si picɔ pinyinɛ nɛ Yeesu piwɑ̃. Pinnɛ́í mmɛ̃ pɛɛ rinɔ́ɔ risɛ wɑ ɑpi yɛ cɑ́pinɛ ɑpí nɛ piyómɛyɑ́hɑɑ n ŋmɔ́ɔ́púlɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Likumúŋɛ́ kpɛ-i, Piyɛɛ uu kɛyɑ́ɑ kɛnyinɛ yisi, piyómɛyɑ́hɑɑ pílɛ nɛ ɑfɛɛrɛ́ pinyinɛ pin cɑ́pinɛlɛ̃, uu pikɛcɔpɛ mɑɑ rɛ: ");
INSERT INTO soy_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Pimɑ́rɛcɔ, li pisɛ rɛ lɛ̃ kɛ Nfɑ́ɑsɔnɛ nn Nléécɑɑsimɛ́ ritɛlɛ́ kɛ́mɛɛ n símisi likɛ́ wɑ. Nfɑ́ɑsɔnɛ yɛ Yutɑsi kɛcɑ́ɑ́ Tɑfiti rinɔ́ɔ rinyinɛ mɑɑsɛlɛ. Yutɑsi uyɛɛ pɑnsɛ pɛpɛɛ Yeesu n tĩ́ ukpeenwɑi. ");
INSERT INTO soy_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","U pɛɛ urɔ́cɔ usɛ lɛ, tɔn kɛsẽ́ pikɛi pisɛ mpí wɑi. ");
INSERT INTO soy_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Siwóó sɛ̃ kuu usoi ń kpu ɑpi u hɛ́ɛ́lɛ kuú nɛ kɛcɑrɛ lɔ, uu pɛɛ kei lóiri uu ríyu mɛfoí kɛtẽ fɑpi, uu kɛcɔpɛ kpɑ́fú, ɑnyɔ́hɔ nnɛ́í ɑɑ cúmɛ. ");
INSERT INTO soy_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Yerusɑlɛm pikɔ́ nnɛ́í pɛɛ mɛwɑi mɛ̃ kõ, hɑ́i ɑpí nɛ kɛcɑrɛ kɛ̃ sée rɛ Hɑkɛlitɑmɑ, lɛlɛɛ rɛ unyinɛ mɛnyɛ yɛ kei kɔɔnu. ");
INSERT INTO soy_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ticuruu li Ipɑkɑrɛ Siyomɛ kɛ́mɛɛ wɔ́lɑɑlɛ̃ tɛ: Ukɛyɔ kɛkɛ́ mɛŋmɑnɛ tonɛ! Úkɑ úu kɑpɛ kɛkɛmɛɛ tónɛ! Li kɔ wɔlɑɑlɛ̃ tɛ: Usoi féé ukɛ́ upikɛi yɔsí uú nɔŋ́! ");
INSERT INTO soy_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Kumúŋɛ́ kpɛ̃ nnɛ́í kɛ Upíimɑ Yeesu uú pɛɛ kɛrɔ́mɛɛ ń we, pisoi pinyinɛ yɛ pɛɛ ḿpɑ́ yei rɔ́ tíkilɛnlɛ. ");
INSERT INTO soy_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Hɑ́i kɛ Yohɑni uú nɛ míni u n wólɛ nɛ pɛɛ́ uyɛi-mɛ kɑi kɛrɔ́cɔpɛ nkɛ́-i u n kpíipɔ ɑí nɛ kɛyómɛcɑɑ sĩ́, pisoi pinyinɛ yɛ pɛɛ rɔ́ tíkilɛnlɛ. Lɛ̃ nnyɑ, li pisɛ rɛ pisoi pɛ̃ kɛcɔpɛ usɛ ukɛ́ kɛrɔ́mɛɛ n we ukɛ́ mɛrɔ́cɔ itɑnsei li rɛ Yeesu yɛ nkpɔ kɛ́mɛɛ yisi. ");
INSERT INTO soy_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Kei kɑpi pɛɛ pisoi pitɛ́ sée ɑpi nyɛrɛsɛ. Pɛpɛɛ Yosɛfi Pɑrisɑpɑsi kɑpi yɛ kɔ n sée rɛ Yusituusi. Ulírũ yɛɛ Mɑtiyɑsi. ");
INSERT INTO soy_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Api pɛɛ kɛyómɛ yɑ́ɑ́si rɛ: Upíimɑ, pɔ́ɔ pisoi nnɛ́í sifɑ kɛ́mɛɛ nyu. A pisoi pitɛ́ mpí kɛcɔpɛ uyɛ̃ kɑɑ n wɛ́ɛ rɔ́ nyísɛ ");
INSERT INTO soy_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ukɛ́ pɑnsɛ utumɛ uu Yutɑsi pikɛi yɔ́su uú nɔŋ́. Yutɑsi yɛ ukɛtonɛ riyɑ́lɛ uu sĩ́ kei kɑí nɛ u rinsɑ́ rɛ ukɛ́ tonɛ. ");
INSERT INTO soy_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Kei kɑpi pɛɛ pɑŋɑi ɑi Mɑtiyɑsi tini, uu pɛɛ Yeesu pitumɛ kɛfi nɛ usɛ pɛ̃ kɛcɑ́ɑ́ kpɑ́pɔ. ");
INSERT INTO soy_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Kɑi Pɑntekooti kɛyɑɑ ń tu, piyómɛyɑ́hɑɑ nnɛ́í ɑpi kɛlõ kɛsɛ cɑ́pinɛ. ");
INSERT INTO soy_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Mɛsɛ nɛ mɛsɛ, nnɛ̃́ nnyinɛ nn kɛyómɛcɑɑ-pɔ leeri yɑrɛ kuyɔ pɑpɛ-pɑpɛ kunyinɛ kpɛɛ pepu. Aku kɛ́yɔ kɛ-i kɑpi n tṹ nnɛ́í yipu. ");
INSERT INTO soy_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Api linyinɛ yɛnu yɑrɛ inɑlempi, ɑi pi kpɑ́fúmɛ, ɑi yɛ́kɑ́ɑ́, ɑi ḿpɑ́ úye kɛcɑ́ɑ́ tonɛ. ");
INSERT INTO soy_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Nfɑ́ɑsɔnɛ nn pɛɛ pinnɛ́í yipu nn pikɛmɛɛ ń we. Kei kɑpi pɛɛ mɛyu mpehẽ mpehẽ kɛ Nfɑ́ɑsɔnɛ nn pi n hɛ pisímɛ́ lõ. ");
INSERT INTO soy_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Pisuifi pɛɛ Uléécɑɑ likɔ́ ń lɑ yɛ pɛɛ Yerusɑlɛm-i welɛ. Isoipuri nnyí nnɛ́í yɛɛ kɛtẽ kɛcɑ́ɑ́ ń we ɑyu kɛ́mɛɛ kɑpi léemɛ ɑpí weri. ");
INSERT INTO soy_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Kɛ nnɛ̃́ nn lɛ̃ ń le, pisoi ɑpi cɑ́pinɛ riwúí. Piyómɛyɑ́hɑɑ ɑpi pɛɛ mɛyu mpehẽ mpehẽ n símisi. Pɛpɛɛ n cɑ́pinɛlɛ̃ pin pɛɛ pimɛyu kɛ́mɛɛ kómɛi, ɑi nnɔ́ɔ pi yipu hɑ́i. ");
INSERT INTO soy_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ai pɛɛ mɛ́woo pi wɑi, ɑi kɔ mɛyíkíyiki nnɔ́ɔ pi yipu ɑpi pɛɛ rɛ: Nɛ́ntɛ pisoi mpí nnɛ́í pɛɛ nní n símisi yɛ Kɑlilee pikɔ́ lɛ? ");
INSERT INTO soy_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Kɑi pɛɛ íye wɑ kɛ ntɔ́nɛ́í mmú, ḿpɑ́ úye uu pɛɛ́ nɛ umɛyu kɛ́mɛɛ pi kómɛi? ");
INSERT INTO soy_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Kɛrɔ́cɔpɛ nkɛ́-i, pinyinɛ yɛ Pɑritɛsi nɛ Metii nɛ Elɑm sitẽ leerilɛ. Picɔ yɛ Mesopotɑmii pikɔ́ lɛ nɛ Yutee pikɔ́ nɛ Kɑpɑtɔɔsi pikɔ́ nɛ Pɔnti pikɔ́ nɛ Asii kɛtẽ pikɔ́ ");
INSERT INTO soy_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","nɛ Firisii nɛ Pɑmfilii nɛ Esipiti nɛ Lipii kɛtẽ kɛɛ Sirɛɛni mɛmpɔ ń we pikɔ́. Picɔ pɔ́ɔn Rɔm kuyu-pɔ leeri, ");
INSERT INTO soy_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","nɛ Kirɛɛti nɛ Arɑpii sitẽ-pɔ. Picɔ yɛ Pisuifi yíkíyiki lɛ, picɔ yɛ pɑnsɛlɛ Pisuifi pin Moisi isé tíkilɛ̃. Ḿpɑ́ nɛ lɛ̃, ntɔ́nɛ́í mmú, ḿpɑ́ úye yɛ pɛɛ umɛyu kɛ́mɛɛ pi kómɛilɛ pin mɛwɑi píimɑ kɛ Uléécɑɑ uu n wɑ símisi. ");
INSERT INTO soy_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ai pi nnɛ́í muuni tíḿḿ, ɑpi pɛɛ mɛ́woo ń we pin písɛinɛ rɛ: Nsímɛ́ ń-ye kɛcirɛ yɛ mmú? ");
INSERT INTO soy_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Amɑ́ picɔ pɔ́ɔ piyómɛyɑ́hɑɑ pɛ̃ sɛ́nnyi pin tee rɛ: Pítɑ lɑri ŋmɑɑ pɛɛ nní pi pomɑɑlɛ̃! ");
INSERT INTO soy_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Piyɛɛ uu pɛɛ yisi u nɛ pitumɛ kɛfi nɛ usɛ ɑpi nyɛrɛ, uu rinɔ́ɔ cɑ́sɛ uu pisoi pɛɛ n cɑ́pinɛlɛ̃ mɑɑ rɛ: Nɔ̃́ Pisuifi nɛ nɔ́ pitɔ́rɔɔ mpí nnɛ́í nɔ́ɔ nní Yerusɑlɛm kuyu-i ń we, ɑni nnɛ́símɛ́ ńsɔnɛ kutu ricɔ ɑni kóm! ");
INSERT INTO soy_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Pisoi mpí ɑ́pi pomɑɑlɛ̃ yɑrɛ kɑni nní n kpɑ́rɑ́lɛ̃. Li mmɑrɛ tɔsilɛ, mɛsɛ ɑ́mɛ we kɛfi ŋmɑnɛ kɑí pi yɑrɛ kɑni nní n nyɑ́ni. ");
INSERT INTO soy_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Lɛ̃ kɛ ɑntepu Yowɛɛli uú pɛɛ mɛkɛɛ ḿ mɑ yɛɛ nɛni nkpéni nní wɑi. Lɛlɛɛ rɛ: ");
INSERT INTO soy_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Uléécɑɑ yɛ mɑɑ rɛ Unfɑɑsɔnɛ yɛ́ siyɑ́ɑ tɔrɔɔ kɛ́mɛɛ ḿpɑ́ úye kɛcɑ́ɑ́ súimɛ. Nɔ́pinɛ́ŋmɑ́nɛ nɛ nɔ́pinɛ́kpére ɑpí nɛ Uléécɑɑ rinyiri símisi. Pinɑ́ŋɛ-nɑŋɛ ɑpi mɛ́wee yɛ́nti, piwɛ́ɛ́sɛ ɑpi lɑ́rikɛɛ. ");
INSERT INTO soy_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Mɛyíkíyiki kɑm tíyɛsɛnɛ Nnɛ́fɑ́ɑsɔnɛ nkɛ́ likɛyɑɑ kɛ̃ pinɛ́kɛikɔ́ tisi nɛ pinɔ́si kɛcɑ́ɑ́ súimɛ, ɑpi pɛɛ pɑnsɛ ɑntepuyɛ. ");
INSERT INTO soy_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nɛ́ mɛwɑisɑŋɑ kɛyómɛcɑɑ-pɔ wɑ, ɑm mɛwɑi píimɑ kɛtẽ nté wɑpisi: Mɛ́nyɛ yɛ́ kɔikɛɛ, nnɑ nń torɛ, ɑ́nyɔ ŋmɔhɔ ɑɑ hílɑ líkí-líkí. ");
INSERT INTO soy_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ituŋɛ ii pɑnsɛ riŋmɔ́hɔ, iwɑ́rɛ pɔ́ɔ wɔ́ŋɔɔ yɑrɛ mɛ́nyɛ, Upíimɑ kɛyɑɑ ɑkɛ kɛlenɛ weri. Kɛyɑ́ɑ píimɑ nɛ kɛ́yukɔɔ́ yɛ kɛ. ");
INSERT INTO soy_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Úye un pɛɛ́ uyɛ-i Upíimɑ rinyiri n sée, uu u yoriyɛ. ");
INSERT INTO soy_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Ani mmú kutu ricɔ, Isirɑyɛɛli pikɔ́! Uléécɑɑ yɛ Nɑsɑrɛti ukɔ́ Yeesu isoi pɑkɑrɛlɛ. Uléécɑɑ yɛ nɛ u ritikilɛ uú nɛ nɔ́kɛnɛ́cɔpɛ mɛwɑisɑŋɑ nɛ mɛwɑi píimɑ wɑpisi yɑrɛ kɑni nní nɔ́rinɛ́cúruu n nyu. ");
INSERT INTO soy_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Uyɛ̃ kɑpi nɔ́ɑnɛ́nípɛ-i wɑ yɑrɛ kɛ Uléécɑɑ uu mɛkɛɛ-mɛ umɛnyuwɛ kɛcɑ́ɑ́ n yekei, ɑni pɛpɛɛ ɑ́pi Uléécɑɑ n wuru u pɑ ɑpi kunɑpɛ́ɛ́kɔɔ́ kɛcɑ́ɑ́ u kɑrii ɑní nɛ u kopu. ");
INSERT INTO soy_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Amɑ́ Uléécɑɑ uu nkpɔ ɑnipɛ-i u yɔ́su uu nkpɔ kɛ́mɛɛ u yukusɛ. Ncée ńn we rɛ nkpɔ nkɛ́ u m múílɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Tɑfiti yɛ Yeesu kɛcɑ́ɑ́ mɑɑ rɛ: Mɛsɛ́rɛ kɑm kɛnɛ́yu-i Upíimɑ nyɑ́ni, ɑ́m kɑpɛ nɛ n tɛ́rii nnyɑ kuu kunɛ́lukɛ-lukɛ-mɛ̃ kɛ́yukɔɔ́tonɛ-i we. ");
INSERT INTO soy_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Lɛ̃ nnyɑ kɛ rinɛ́pɔ́ɔ ɑri lɑ́ɑ́rú, nɛn tinɛ́kíŋ kɛ́mɛɛ yóm. Ḿpɑ́ nɛn n kpu, nɛ nɛ pɔ́ tɑ́lɛnlɛ. ");
INSERT INTO soy_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Pɔ̃́ Upíimɑ, ɑ́ɑ yɛ́ pikpɔkpɔ kɛ́mɛɛ nɛ́ riyɑ́. Áɑ yɛ́ ŋmurɛi upɔ́kɛikɔ́ sɔnɛ ukɛ́ fɔ́ni. ");
INSERT INTO soy_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Pɔ ifɑ́ɑcee nɛ́ nyísɛlɛ. Mɛpɔ́wee kɛnɛ́kúrí yɛ nkíŋniŋɛ nɛ́ hɛlɛ. ");
INSERT INTO soy_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Pimɑ́rɛcɔ, ɑni ncée nɛ́ hɛ kɛ́ ukpurɛ Tɑfiti nkɔ́ nɔ́ símisi kɛ́ rikpɑ̃́iisɛ rɛ u kpulɛ ɑpi u kulɛsi, tɔn kɔ urikpíí nyu nɛ nɛni-mɛ. ");
INSERT INTO soy_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","U pɛɛ ɑntepu lɛ un nyu rɛ Uléécɑɑ yɛ rinɔ́ɔ yekeilɛ uu wééri rɛ ukɛpirɛ̃ kɛnyinɛ kɛɛ mɑsí uiyɔɔpi tonɛnɛ, ");
INSERT INTO soy_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Kirisi mɛyisɛ nkpɔ kɛ́mɛɛ kɛ Tɑfiti uu lɛ̃ yɛ̃. Linsímɛ́ kuú pɛɛ lɛ̃ símisi kuú nɛ mɑɑ rɛ: Uléécɑɑ úu yɛ́ pikpɔkpɔ kɛ́mɛɛ u riyɑ́, úu yɛ́ ŋmurɛi ukɛ́ fɔ́ni. ");
INSERT INTO soy_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Tɔ ntɔ́nɛ́í mmú yɛ́nlɛ lɛ̃ kɛ Uléécɑɑ uu nkpɔ kɛ́mɛɛ Yeesu uyɛ̃ n lésɛ. ");
INSERT INTO soy_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Uléécɑɑ yɛ ukulukɛ-lukɛ-mɛ̃ u ritɑɑ́sɛlɛ. Sɑ́ɑ Uléécɑɑ uu kɔ Nfɑ́ɑsɔnɛ kuú pɛɛ n yekeilɛ̃ u pɑ. Mmɛ̃ kuu nní kɛrɔ́cɑ́ɑ́ súisɛmɛ yɑrɛ kɑni nní n nyɑ́ni nɔn kɔ kómɛi. ");
INSERT INTO soy_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Tɑfiti úu kɛyómɛcɑɑ ritɑɑ́, ɑmɑ́ uricuruu yɛ pɛɛ́ mɑɑ rɛ: Upíimɑ Uléécɑɑ yɛ Unɛ́píimɑ mɑɑ rɛ: A kunɛ́lukɛ-lukɛ-mɛ̃ kɛ́yukɔɔ́tonɛ-i tonɛ ");
INSERT INTO soy_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","likɛ́ hɑ nɛ tu pɛɛ́ uyɛ-i kɑm yɛ́ n tíyɛsɛ ɑɑ pipɔ́lɑ́ɑrɔ tɛlɛisɛ. ");
INSERT INTO soy_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Isirɑyɛɛli pikɔ́ nnɛ́í pikɛ́ kṍ ńsɔnɛ rɛ Yeesu uyɛ̃ kɑni kunɑpɛ́ɛ́kɔɔ́ kɛcɑ́ɑ́ n kɑrii kɛ Uléécɑɑ uu pɑnsɛsɛ Upíimɑ nɛ Ukirisi. ");
INSERT INTO soy_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Kɑpi nsímɛ́ mmɛ̃ n kṍ, nn pi loni suu nɛ ɑkɔhɔ-pɔ ɑpi pɛɛ Piyɛɛ nɛ pitumɛ picɔ mɑɑ rɛ: Íye kɑri yɛ́ nkpéni wɑ, pimɑ́rɛcɔ? ");
INSERT INTO soy_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Uyɛ̃ uu pi pɛsɛ rɛ: Ani mɛfinɛ consɛ pikɛ́ ḿpɑ́ nɔ́ úye míni wolɛ nɛ Yeesu rinyiri, Uléécɑɑ ukɛ́ nɔ́ɑnɛ́kópɛ nɔ́ sɑ́rɛi uu kɔ Nfɑ́ɑsɔnɛ nɔ́ hɛ. ");
INSERT INTO soy_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Li we rɛ lisɔnɛ lɛ̃ kɛ Upíimɑ Uléécɑɑ uu ḿ mɑɑ rɛ u yɛ́ pisoi wɑ kuú nɛ nɔ́ nɛ nɔ́sinɛ́wɑ̃́ nɛ pitɑɑ-tɑɑ kulúi píimɑ kpɛ̃ nnɛ́í kuu n séirinɛ mɛ̃́. ");
INSERT INTO soy_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Piyɛɛ uu kɔ ɑnɔ́ɔ ɑcɔ pi mɑ́ikɛɛ uú nɛ ɑsei pi komɛisɛ uu kɔ nɛ pi n ŋmɔ́ɔ́púsɛlɛ̃. U yɛ pi mɑɑ rɛ: Ani mɛwɑi kópɛ kunɑi pikɔ́ mpí kɛ́mɛɛ nɔ́mɛnɛ́círɛ lesɛ. ");
INSERT INTO soy_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Pisoi mɛyɑ̃ ɑpi Piyɛɛ nsímɛ́ mmɛ̃ ŋmurɛi ɑpi míni wolɛ. Kɛyɑ́ɑ kɛ̃, pisoi ɑ́kotokú ɑtɑɑni kumúŋɛ́ pɛɛ piyómɛyɑ́hɑɑ pɛ̃ kɛcɑ́ɑ́ rikpɑ́pɔ. ");
INSERT INTO soy_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Piyómɛyɑ́hɑɑ yɛ pɛɛ pitumɛ icélɑɑ kɛ́mɛɛ ŋmɔ́ɔ́púlɛnlɛ, pin tinɔ́ɔ risɛ mɑ́, pin kɛsẽ́ ilukɛ le, pin kɔ kɛyómɛ yɑ́ɑ́si. ");
INSERT INTO soy_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Pitumɛ yɛ pɛɛ mɛwɑisɑŋɑ mɛyɑ̃́ nɛ mɛwɑi píimɑ wɑpisilɛ. Ḿpɑ́ úye un pɛɛ pɑkɑrɛntɛ rɛ Uléécɑɑ yɛɛ pikɛi wɑi! ");
INSERT INTO soy_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Pɛ̃ nnɛ́í pɛɛ Yeesu nɛ kɛfɑ n tɛnɛ yɛ pɛɛ kɛlõ kɛsɛ welɛ, ɑpi rinɔ́ɔ risɛ wɑi ɑpi yɛ pilikɔ́ nnɛ́í hɔ́ɔ́nɛ. ");
INSERT INTO soy_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Pi yɛ pɛɛ pisitẽ nɛ pilikɔ́ nnɛ́í yɑ́lisilɛ, ɑpi ḿpɑ́ úye ncɔ́ŋ pɑí ɑpí nɛ lisiwóó sɛ̃ hɔɔnɛntɛ. ");
INSERT INTO soy_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Pi pɛɛ kómɛinɛlɛ pin siyɑ́ɑ nnɛ́í mɛsɛ́rɛ Uléécɑɑ kɛyɔ-i cɑ́pinɛlɛ̃. Pi pɛɛ síyɔ sɔ́nɑɑnɛlɛ pin kɛsẽ́ le, pin kɔ Uléécɑɑ ilukɛ nɛ kɛfɑ kɛsɛ hɔɔnɛ lin pi lɑ́ɑ́rú. ");
INSERT INTO soy_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Pi pɛɛ Uléécɑɑ pɑkɑrɛlɛnlɛ, ḿpɑ́ úye un nɛ kɛfɑ pi fénnɛlɛ̃, Upíimɑ un pɛɛ ḿpɑ́ kɛyɑ́ɑ kɛ́ye pisoi ɑyu lɔlu un pikɛcɑ́ɑ́ kpɑriisɛpɔ. ");
INSERT INTO soy_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Kɛtúŋɛ́ kɛnyinɛ, lin mɛtɑɑni pipépɛ mɑsí kɛ Piyɛɛ nɛ Yohɑni ɑpi yisi ɑpi Uléécɑɑ kɛyɔ-i piyómɛyɑ́hɑɑ sĩ. ");
INSERT INTO soy_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Pisoi pinyinɛ yɛ pɛɛ́ nɛ utisi unyinɛ sɔ́nɑɑpɔlɛ, ɑpi yɛ Uléécɑɑ kɛyɔ rinɔnɔɔ-i u tonsɛ un pɛɛ kei picéetɔŋɛ́ wélei. Pi yɛ rinɔnɔɔ tɛ̃ sée rɛ Rinɔnɔɔ Sɔnɛ. Pi utisi uyɛ̃ mɑrilɛ kɛ́kɑnkɑ́lɑ́kɑ́. ");
INSERT INTO soy_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Kuu Piyɛɛ nɛ Yohɑni n yɛ̃́ pin lɑ pikɛ́ kɛ́yɔ-i lompɔ, uu kunípɛ pi welé. ");
INSERT INTO soy_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Piyɛɛ nɛ Yohɑni ɑpi u nyɑ́nɛi tíḿḿ, Piyɛɛ uu pɛɛ u mɑɑ rɛ: A tɔ́ riweríi! ");
INSERT INTO soy_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Uu pi pɑí ńsɔnɛ un nɛ mɛ̃́ tɛ u yɛ́ pikɛmɛɛ linyinɛ yɔsí. ");
INSERT INTO soy_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Kei kɛ Piyɛɛ uu pɛɛ u mɑɑ rɛ: Nɛ̃́ ɑ́m siwóó mɑ́, ɑ́m kɔ wurɑ mɑ́. Amɑ́ lɛ̃ kɑm m mɑ́ kɑm Nɑsɑrɛti ukɔ́ Yeesu Kirisi rinyiri nɛ pɔ́ pɑ́lɛ̃: A yisi ɑɑ sɔ́nɛ! ");
INSERT INTO soy_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Piyɛɛ uu kunípɛ lukɛ-lukɛ u tini uu nyɛrɛsɛ. Mɛsɛ nɛ mɛsɛ, ɑ́nɑ nɛ ɑnui ɑ pɑpisi, ");
INSERT INTO soy_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","uu yóósi uu cuuni uu nsẽ́ kɑ́pɑ́ɑ́, u nɛ pɛ̃ ɑpí nɛ Uléécɑɑ kɛyɔ suupɔ, un sɔ́nɛ, un cuunkɛɛ un kɔ Uléécɑɑ pɑkɑrɛntɛ. ");
INSERT INTO soy_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Pisoi pɛɛ n cɑ́pinɛlɛ̃ ɑpi u yɛnu un sɔ́nɛ un Uléécɑɑ pɑkɑrɛntɛ. ");
INSERT INTO soy_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Pisoi ɑpi céru rɛ uyɛɛ yɛ pɛɛ Uléécɑɑ kɛyɔ-i Rinɔnɔɔ Sɔnɛ-i n tũ un wélei. Mɛwɑi mɛ̃ ɑmɛ pisoi nnɛ́í nnɔ́ɔ yipu ɑi kɔ pírí pi wɑi kɑí nɛ lɛ̃ u n wɑ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Kɛ utisi uyɛ̃ uu lɛ̃ Piyɛɛ nɛ Yohɑni n lonɑɑlɛ̃, pisoi nnɛ́í ɑpí pehé ɑpi pikuwɛ́ɛ́-mɛ̃ kɛlõ kɛ̃ kɑpi yɛ n sée rɛ Sɑlomɔɔ ɑpookpɑŋɑ́-mɛ̃ n sĩ, lin nnɔ́ɔ pi yipɑɑlɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Kɛ Piyɛɛ uu lɛ̃ n yɛ̃́, uu pi pisɛ rɛ: Pimɑ́rɛcɔ Isirɑyɛɛli pikɔ́, yo nnyɑ kɛ utisi nkó pipélɛ́ ɑpi nní nnɔ́ɔ nɔ́ yipɑɑlɛ̃? Yo nnyɑ kɑni rɔ́ nyɑ́nɛi yɑrɛ tɔ́ɔ ntɔ́nɑŋɛ cirɛ nɛ u pɔisɛ nɛ́ɛ tɔ́ɔ Uléécɑɑ kɛ́mɛɛ ɑsei tikilɛ̃ nnyɑ kɛ usoi nkó uu yisi uu sɔ́nɛ. ");
INSERT INTO soy_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Pirɔ́sɑ́ɑyɑhɑ Apirɑhɑm nɛ Isɑɑki nɛ Yɑkupu Uleecɑɑ yɛɛ uukɛikɔ́ Yeesu ríyu wɑisɛ. Nɔ́rinɛ́cúruu nɔ́ɔ u tĩ ɑni n-yɔ́ɔpinɑŋɛ pikɔ́ ɑnipɛ-i u wɑi, uyɔ́ɔpi Pilɑti uu rɛ ukɛ́ u riyɑ́ ɑni yúlu. ");
INSERT INTO soy_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Amɑ́ nɔ́ɔ pɛɛ usoi yɛɛ úu ɑkópɛ m mɑ́ nɛ ɑsei ute yulu ɑni pɛɛ mɛníŋɛ Pilɑti pisɛ rɛ pikɛ́ usoikṍ nɔ́ lésɛmɛ. ");
INSERT INTO soy_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Nɔ tíyɛsɛlɛ ɑpi uyɛɛ yɛ nfɑ́ɑ n hɛ kopu, Uléécɑɑ uu pikpɔkpɔ kɛ́mɛɛ u yukusɛ irɔ́nípɛɛ ii u yɛnu. ");
INSERT INTO soy_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Kɛfɑ kɑrí nɛ Yeesu n tɛnɛ nnyɑ kɛ urinyiri ɑri usoi nkó kɑni nní n nyɑ́ni nɔn kɔ nyu pɑpukusɛ. Kɛfɑ kɑrí nɛ u n tɛnɛ yɛɛ tíyɛsɛ kɛ usoi nkó uú peí cɑ́kɑ́-cɑ́kɑ́ yɑrɛ kɑni nní n nyɑ́ni. ");
INSERT INTO soy_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Amɑ́ pimɑ́rɛcɔ, nɛ nyulɛ ńsɔnɛ rɛ nɔ́ nɛ nɔ́pinɛ́yɔ́ɔpi ɑ́ni nyu kɛlenɛ kɑní nɛ lɛ̃ Yeesu wɑ. ");
INSERT INTO soy_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Nsímɛ́ mmɛ̃ kɛ Uléécɑɑ uú pɛɛ mɛkɛɛ-mɛ ɑntepuyɛ nnɛ́í ḿ mɑ́ɑsɛ mɛɛ nkpéni nní wɑi. Lɛlɛɛ rɛ li pisɛ rɛ uyɛ̃ kɛ Uléécɑɑ uu wɛ́ɛ ukɛ́ íwɛ li. ");
INSERT INTO soy_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Lɛ̃ nnyɑ, ɑni mɛfinɛ consɛ ɑni nɔ́mɛnɛ́círɛ Uléécɑɑ pɑ ukɛ́ nɔ́ɑnɛ́kópɛ nɔ́ sɑ́rɛi. ");
INSERT INTO soy_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Upíimɑ yɛ́ pɛɛ tíyɛsɛ ɑni kumúŋɛ́ kunyinɛ-i hóó uu pɛɛ uyɛ̃ kuu hɑ́i mɛkɛɛ-mɛ n wɛ́ɛ uu yekei nɔ́ pɑ́mɛ. Uyɛɛ Kirisi Yeesu. ");
INSERT INTO soy_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Uyɛɛ yɛ́ kɛyómɛcɑɑ-pɔ n we kɛlenɛ, hɑ́i nɛ kumúŋɛ́ kpɛ-i kɛ Uléécɑɑ uu ḿpɑ́ yo m pɛsɛrinɛ yɑrɛ kɑi pɛɛ ń we yɑrɛ kuú pɛɛ mɛkɛɛ-mɛ uɑntepuyɛ kuu n wɛ́ɛ m mɑ́ɑsɛ. ");
INSERT INTO soy_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moisi yɛ pɛɛ́ mɑɑ rɛ: Nɔ́unɛ́léécɑɑ Upíimɑ yɛ́ ɑntepu unyinɛ nɔ́ pɑ́mɛ yɑrɛ nɛ̃́, un nɔ́nnɛ́puri ukɔ́. Ani mmɛ̃ nnɛ́í kuu nɔ́ n símisinɛ kutu ricɔ. ");
INSERT INTO soy_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Úye unsɑ́ kutu u rincɔ, pikɛ́ Uléécɑɑ pikɔ́ kɛcɔpɛ u lesɛ ɑpi kópu. ");
INSERT INTO soy_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Antepuyɛ nnɛ́í pɛɛ hɑ́i ɑntepu Sɑmuyɛɛli-i-mɛ n símɑɑri ɑí nɛ nɛni tulu yɛ siyɑ́ɑ nsí nsímɛ́ mɑlɛ. ");
INSERT INTO soy_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Nɔ́ɔ lɛ̃ kɛ Uléécɑɑ uu ɑntepuyɛ m mɑ́ɑsɛ rɛ u nɛ nɔ́ mɛ̃́ te. Uléécɑɑ yɛ nɛ nkómɛinɛ nɔ́pinɛ́sɑ́ɑ séelɛ pɛɛ́ uyɛ-i kuú pɛɛ Apirɑhɑm ḿ mɑɑ rɛ: Pipɔ́pírɛ̃ kɑḿ nɛ tikinɛ kɛ́ nɛ kɛtẽ nnɛ́í nsoipuri rikpɑ́. Nɔ́ɔ kɔ nkómɛinɛ mmɛ̃ te. ");
INSERT INTO soy_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nɔ̃́ nnyɑ kɛ Uléécɑɑ uu uukɛikɔ́ wɛ́ɛ uu nɔ́kɛnɛ́mɛɛ u tumti kɛlenɛ. U u tummɛlɛ nɔ̃́ nnyɑ rɛ ukɛ́ nɔ́ rikpɑ́ uu pɛɛ ḿpɑ́ nɔ́ úye uɑkópɛ-i u lesɛ. ");
INSERT INTO soy_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Piyɛɛ nɛ Yohɑni pin kei lɛ̃ pisoi símisi, mɛsɛ nɛ mɛsɛ, pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ nɛ Uléécɑɑ kɛyɔ umɛ́rɛ́ wɛ́ɛ́sɛ nɛ Pisɑtusee pin tuipɔ. ");
INSERT INTO soy_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Li pɛɛ mɛyɑ̃́ pi pɔ́ɔ́lúlɛ rɛ pitumɛ pɛ̃ kɛtɛ́ yɛ we pin pisoi céési pin kɔ pi símisi rɛ Yeesu yɛ pikpɔkpɔ kɛ́mɛɛ yisi, lin pɛɛ nyísɛlɛ̃ tɛ pikpɔkpɔ yɛ́ fe ɑpi yisi. ");
INSERT INTO soy_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Lɛ̃ nnyɑ kɑpi pitumɛ pɛ̃ kɛtɛ́ tĩ́ ɑpi hɑ́nɛsi ɑí nɛ weesi rɛ ituŋɛ yɛ pilólɛ́ mɑsí nnyɑ. ");
INSERT INTO soy_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Amɑ́ ḿpɑ́ nɛ lɛ̃, pɛpɛɛ pitumɛ pɛ̃ icélɑɑ n kṍ mɛyɑ̃ nɛ pɛɛ́ nɛ kɛfɑ i tɛnɛlɛ, ɑpi tulu yɑrɛ pitisi ɑ́kotokú ɑnupũ kumúŋɛ́. ");
INSERT INTO soy_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Kɑi n weesi, Pisuifi piyukɔɔ́ nɛ pipiwɛ́ɛ́sɛ nɛ isé picélɑɑ ɑpí hɑ Yerusɑlɛm-pɔ cɑ́pinɛ. ");
INSERT INTO soy_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Uléécɑɑ usinɑ Anɑ nɛ ukɛyɔ pikɔ́ nnɛ́í nɛ Kɑyifu nɛ Yohɑni nɛ Alɛkisɑntiri pɛɛ kɔ pɛɛ kei we. ");
INSERT INTO soy_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Api Piyɛɛ nɛ Yohɑni lesɛri pikɛ́ nɛ pi túhɑɑnɛ, ɑpi kɛcɔpɛ pi nyɛrɛsɛ ɑpi pi pisɛ rɛ: Ńnɑŋɛ ń-ye nɛ́ɛ úye kɛcirɛ rinyiri kɑní nɛ lɛ̃ wɑ? ");
INSERT INTO soy_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Nfɑ́ɑsɔnɛ nn Piyɛɛ yipu uu pɛɛ pi mɑɑ rɛ: Nɔ̃́ Isirɑyɛɛli kuyu piyɔɔpi nɛ piwɛ́ɛ́sɛ! ");
INSERT INTO soy_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Mɛwɑi sɔnɛ kɑri utisi nkó wɑ nnyɑ kɑpi nɛni kɛyɑɑ nkɛ́ rɔ́ písɛi rɛ íye kɑi wɑ kuú nɛ peí? ");
INSERT INTO soy_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Lɛ̃ nnyɑ, nɔ́nnɛ́nɛ́í mmú nɛ Isirɑyɛɛli pikɔ́ picɔ nnɛ́í ɑni kõ tɛ Nɑsɑrɛti ukɔ́ Yeesu Kirisi uyɛ̃ kɑni kunɑpɛ́ɛ́kɔɔ́ kɛcɑ́ɑ́ ń kɑrii, Uléécɑɑ uu pikpɔkpɔ kɛ́mɛɛ u yukusɛ rinyíri nnɑŋɛ kɑrí nɛ utisi nkó péisɛ, kuu nní isɑrɛ lɑ́ɑ́rú un nɔ́kɛnɛ́yu-i nyɛnu. ");
INSERT INTO soy_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yeesu uyɛ̃ kɛcɑ́ɑ́ kɑi wɔ́lɑɑlɛ̃ tɛ: Tipɑrɛ tɛ̃ kɛ nɔ̃́ pimɔ́mɛ ɑni n fómpɔ, tɛɛ nkpéni pɑnsɛ tikɛcirɛ tɛɛ kɛnui-i ń we. ");
INSERT INTO soy_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Uyɛ̃ mɛmɑ́ɑ́, úyulɑlɛ úkɑ ucɔ úu we. Uléécɑɑ úu rinyíri ríkɑ ricɔ kɛtẽ nkɛ́ kɛcɑ́ɑ́ pɑ kɑri yɛ́ n sée likɛ́ nɛ tirɔ́yu n lɔ. ");
INSERT INTO soy_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Piyɛɛ nɛ Yohɑni ɑ́pi mɛnyuwɛ píimɑ mɛ́kɑ mɑ́ ɑ́pi kɔ píyukɔɔ́ píkɑ. Amɑ́ piripɔɔ kɑpi pɛɛ́ nɛ símisi nɛ itisi. Kɛ pitúhɑɑnɛ ɑpi lɛ̃ n yɛ̃́, ɑi pi muuni simm, ɑpi kɔ ceru rɛ Piyɛɛ nɛ Yohɑni yɛ pɛɛ́ nɛ Yeesu sɔ́nɛlɛ. ");
INSERT INTO soy_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Kɑpi usoi yɛɛ ḿ peí n nyɑ́ni un pikɛkúrí nyɛnu nnyɑ, pitúhɑɑnɛ pɛ̃ ɑ́pi pɛɛ nyu ń-ye kɑpi yɛ́ mɑlɛ. ");
INSERT INTO soy_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Api pɛɛ Piyɛɛ nɛ Yohɑni kɛtúhɑɑnɛ kɛ-i lɑ́kɑsɛ, ɑpi pɛɛ kei n we pin pimɛcɔpɛcirɛ nsímɛ́ píŋirisɛ. ");
INSERT INTO soy_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Api pɛɛ m písɛinɛ rɛ: Íye kɑri pisoi mpí wɑinɛ? Yerusɑlɛm kuyu nnɛ́í yɛ pikómɛ mɑsí rɛ pi mɛwɑisɑŋɑ píimɑ wɑ. Ári yɛ́ fe tɔkɛ́ kɛ́si. ");
INSERT INTO soy_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Lɛ̃ nnyɑ, nsímɛ́ mmɛ̃ ńn kɑpɛ nɛ pikɔ́ɔ́nú rinkpɑ́, tɔkɛ́ nɛ pi yɛ ɑri pi cɛ́si rɛ ɑ́pi kɑpɛ úkɑ mpuri nɛ Yeesu uyɛ̃ tinyiri ńkɑ pisímɛ́ rikpɑ́. ");
INSERT INTO soy_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Kei kɑpi pɛɛ pi séepɔ ɑpí nɛ pi yulu rɛ ɑ́pi kɑpɛ Yeesu nnɑŋɛ nɛ picélɑɑ rikpɑ́. Ápi kɑpɛ yɛ ricuruu urinyiri sée. ");
INSERT INTO soy_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Piyɛɛ nɛ Yohɑni ɑpi pi pɛsɛ rɛ: Nɔ̃́ ticuruu ɑni ripɑí nkɛ̃́ tɛ li nɛ Uléécɑɑ kɛ́mɛɛ sɑ́ rɛ usoi ukɛ́ nɔ́ pɑkɑrɛ nɛ́ɛ Uléécɑɑ kuu yɛ́ pɑkɑrɛ? ");
INSERT INTO soy_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Nɔ́ɔ yɛ́ nkpéni mmɛ̃ ceri. Tɔ̃́ ɑ́ri yɛ́ fe tɔkɛ́ lɛ̃ kɑri n yɛ̃́ ɑri kɔ kom pisímɛ́ riyɑ́. ");
INSERT INTO soy_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Kei kɛ pitúhɑɑnɛ pɛ̃ ɑpi kɔ picɛ́ pi rikpɑ́ ɑpi pi yɑ́ ɑpi tɔ́mpɔ. Ápi ńkɑ yɛ̃ kɑpi yɛ́ nɛ rinwɑ́ɑ́nɑ́ pikɛ́ nɛ kutu pi rimpɑ́sɑ. Pisoi mɛyɑ̃ yɛ pɛɛ́ welɛ pin mɛwɑi mɛɛ nní n wɑ nnyɑ Uléécɑɑ pɑkɑrɛntɛ. ");
INSERT INTO soy_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Utisi uyɛ̃ kɑpi nní nɛ Uléécɑɑ nnɑŋɛ m pɔisɛ ɑŋmɛ̃ yɛ ɑfɛɛnɑ rifɑɑulɛ. ");
INSERT INTO soy_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Kɑpi Piyɛɛ nɛ Yohɑni rin-yɑ́, ɑpi yisi ɑpi pipisoi lɛɛpɔ ɑpi lɛ̃ kɛ pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ nɛ Isirɑyɛɛli piwɛ́ɛ́sɛ ɑpi pi ḿ mɑ pi kɛɛni. ");
INSERT INTO soy_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Kɛ pipisoi pɛ̃ ɑpi lɛ̃ n kṍ, ɑpi rinɔ́ɔ risɛ wɑi ɑpi Uléécɑɑ yɑ́ɑ́si rɛ: Upíimɑ Utɛnɛcirɛ́, pɔ́ɔ kɛtẽ nɛ kɛyómɛ nɛ mínimɑɑ nɛ lɛ̃ nnɛ́í lɛɛ ḿpɑ́ yei ń we wɑ. ");
INSERT INTO soy_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Mpɔ́fɑ́ɑsɔnɛ kɑɑ́ nɛ ritiki ɑɑ́ nɛ urɔ́sɑ́ɑyɑhɑ Tɑfiti upɔ́kɛikɔ́ mɑɑsɛ rɛ: Yo nnyɑ kɛ mpuri sɑnɛ pikɔ́ ɑpi kɛtẽ kɛcɑ́ɑ́ pɑnsɛntɛ? Yo kɛcirɛ nnyɑ kɛ sisoipipi ɑsi simúŋɛ́ kópɛ wɑi? ");
INSERT INTO soy_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Kɛtẽ kɛcɑ́ɑ́ piyɔɔpi yɛ pimɛcirɛ cɑ́pinɛ rɛ pikɛ́ ɑtɔpi leemɛ. Piyɔ́ɔpi ɑpi rinɔ́ɔ risɛ wɑi rɛ pikɛ́ nɛ Upíimɑ nɛ uyɛ̃ kuu n wɛ́ɛ tɔ. ");
INSERT INTO soy_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Mɛyíkíyiki kɛ Erooti nɛ Pɔnsi Pilɑti nɛ Isirɑyɛɛli pikɔ́ nɛ mpuri sɑnɛ pikɔ́ ɑpi Yerusɑlɛm nté rinɔ́ɔ risɛ wɑ rɛ pikɛ́ nɛ upɔ́kɛikɔ́ Yeesu kɑɑ n wɛ́ɛ tɔ. ");
INSERT INTO soy_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Lɛ̃ kɑɑ mɛkɛɛ-mɛ m musí, ɑɑ́ nɛ mpɔ́nɑŋɛ yekei kɑpi nkpéni lɛ̃ wɑ. ");
INSERT INTO soy_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Lɛ̃ nnyɑ, ɑ nkpéni pipicɛ́ ńsɔnɛ kutu ricɔ, Upíimɑ ɑɑ tíyɛsɛ pipɔ́kɛikɔ́ pikɛ́ itisi nɛ mpɔ́símɛ́ riyóó. ");
INSERT INTO soy_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","A mpɔ́nɑŋɛ nyísɛ pitóikɔ́ pikɛ́ pélesi, ɑɑ mɛwɑisɑŋɑ nɛ mɛwɑi píimɑ upɔ́kɛikɔ́ Yeesu kɑɑ n wɛ́ɛ rinyiri nɛ wɑpisi. ");
INSERT INTO soy_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Kɑpi lɛ̃ piyómɛyɑ́hɑɑ ḿ mɑsí, kɛlõ kɛ-i kɑpi n cɑ́pinɛlɛ̃ ɑkɛ yéŋesi. Nfɑ́ɑsɔnɛ nn pinnɛ́í yipu ɑpi pɛɛ itisi nɛ Uléécɑɑ nsímɛ́ n yóólɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Pisoi kulúi kpɛ̃ nnɛ́í pɛɛ nɛ Yeesu kɛfɑ n tɛnɛ yɛ pɛɛ kɛfɑ pɛ́nɛlɛnlɛ pin kɔ kɛmúŋɛ́ kɛsɛ mɑ́. Úkɑ úu yɛ pɛɛ mɑɑ rɛ u linyinɛ umɛcirɛ te. Ḿpɑ́ yo kɑpí pɛɛ pɛ́nɛlɛ̃ pin te. ");
INSERT INTO soy_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Uléécɑɑ yɛ pɛɛ pitumɛ ńnɑŋɛ hɛlɛ pin nɛ nyísɛ rɛ Upíimɑ Yeesu yɛ nkpɔ kɛ́mɛɛ yisilɛ, Uléécɑɑ un pɛɛ Kirisi pikɔ́ nnɛ́í mɛyɑ̃́ kpɑ́lɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Líkɑ ɑ́i pɛɛ piukɑ pɑ́rílɛ̃. Pɛpɛɛ sicɑrɛ nɛ́ɛ síyɔ m mɑ́ yɛ̀ɛ̀ pɛɛ si yɑ́ɑlɛ ɑpí nɛ lisiwóó cɑ́pinɛpɔ ");
INSERT INTO soy_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ɑpi pitumɛ pɑ. Pɛ̃ pɔ́ɔ ḿpɑ́ úye ncɔ́ŋ pɑí ɑpí nɛ si hɔɔnɛntɛ. ");
INSERT INTO soy_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Pi pɛɛ Lefi mpuri ukɔ́ unyinɛ Siipuru kɛtẽ-pɔ mɑrilɛ. Pi yɛ u sée rɛ Yosɛfi. Pitumɛ pɔ́ɔ rinyíri u hɛ rɛ Pɑrinɑpɑsi. Liɑsei rɛ uyɛɛ yɛ picɔ rinŋmɔ́ɔ́púsɛ. ");
INSERT INTO soy_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Uyɛ̃ uu kɔ ukɛcɑrɛ yɑ́i uú nɛ lisiwóó hɑpɔ uu pitumɛ pɑ. ");
INSERT INTO soy_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Utisi unyinɛ nɛ uunɔsi pɛɛ pɛɛ́ we. Pi yɛ u sée rɛ Anɑniyɑsi, ɑpi unɔ́si pɔ̃́ tɛ Sɑfirɑ. Utisi uyɛ̃ uu ukɛcɑrɛ yɑ́i. ");
INSERT INTO soy_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","U nɛ unɔ́si ɑpi kómɛinɛ ɑpi siwóó hɑ́su ɑpi pésu, uu pɛɛ́ nɛ sitɔ́rɔɔ sĩ uú hɑ pitumɛ pɑ. ");
INSERT INTO soy_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Piyɛɛ uu pɛɛ u pisɛ rɛ: Anɑniyɑsi, íye kɑi wɑ kɛ Setɑni uu lɛ̃ pɔ́ lõ uú hɑ nɛ Nfɑ́ɑsɔnɛ kirɑɑsɛ ɑɑ kɛcɑrɛ siwóó hɑ́su ɑɑ pésu? ");
INSERT INTO soy_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Pɔkɛ́ kɛlenɛ kɛcɑrɛ kɛ̃ n yɑ́ɑ́, ɑ́i pɔ́ɔ kɛ tee? Kɛmɛyɑ́i-mɑɑ́, ɑ́i pɔ́ɔ kɛsiwóó tee? Yo nnyɑ kɑɑ nkpɑ́ni mɛwɑi kópɛ mmɛ́ ripɔ́yu-i wɑ? A kõ tɛ ɑ́i sisoipipi kɑɑ kírɑɑsɛ, Uléécɑɑ lo kɑɑ kírɑɑsɛ. ");
INSERT INTO soy_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Kɛ Anɑniyɑsi uu lɛ̃ n kṍ, uu lólu uu kpi. Iwɑmɛ píimɑ inyinɛ ii pɛ̃ nnɛ́í pɛɛ lɛ̃ n kṍ loni. ");
INSERT INTO soy_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Piŋmɑ́nɛ ɑpi yisi ɑpi kusɑ́ŋɑ́ɑ́ u pilɑɑ ɑpi sɑ́kɑɑ ɑpí nɛ leepɔ ɑpí hɑ kulɛsi. ");
INSERT INTO soy_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ituŋɛ mɛkɔ́ɔ́nú mɛtɑɑni mɛmɑ́ɑ́, unɔ́si un tuipɔ úu nyu rɛ linyinɛ yɛ wɑ. ");
INSERT INTO soy_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Piyɛɛ uu u mɑɑ rɛ: A nɛ́ símisi nkɛ̃́ tɛ nnɛ́í mmú kɑni nɔ́kɛnɛ́cɑrɛ yɑ́ɑ, nɛ́ɛ yo? Uu rɛ: Ɛɛɛ, mmɛɛ mu! ");
INSERT INTO soy_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Piyɛɛ uu u mɑɑ rɛ: Yo nnyɑ kɑni kómɛinɛ ɑní nɛ Upíimɑ Nfɑɑsɔnɛ peeni? Áɑ nyɑ́nii, pɛpɛɛ upɔ́lɑ n kúlɛsi ɑnɑ kɑm nní kómɛi pin lonti. Pi kɔ lɛ̃ nɛ pɔ̃́ tɔ́sulɛ. ");
INSERT INTO soy_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Kei nní, unɔ́si uu Piyɛɛ ɑnɑ nyɛ-i lólu uu kpi. Piŋmɑ́nɛ pɛ̃ pikɛ́ nɛ n lompɔ un pikpɔ mɑsí, ɑpi u kpísi ɑpí hɑ ulɑ kɛkúrí kulɛsi. ");
INSERT INTO soy_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Iwɑmɛ píimɑ inyinɛ ii Kirisi pikɔ́ nnɛ́í nɛ pɛpɛɛ nsímɛ́ mmɛ̃ n kṍ loni. ");
INSERT INTO soy_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Pitumɛ yɛ pɛɛ mɛwɑisɑŋɑ nɛ mɛwɑi píimɑ pisoi inipɛɛ-i wɑpisilɛ. Pɛpɛɛ Uléécɑɑ nɛ kɛfɑ n tɛnɛ yɛ pɛɛ rinɔ́ɔ risɛ wɑlɛ ɑpi yɛ kei kɑpi yɛ n sée rɛ Sɑlomɔɔ ɑpookpɑŋɑ́-i n cɑ́pinɛlɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Úkɑ ucɔ úu yɛ pɛɛ mɛ́woo kɑhɑ ukɛ́ pi lɛɛpɔ, ḿpɑ́ nɛ lɛ̃, pisoi ɑ́pi pɛɛ kɔ kusɑ pi wɑisɛlɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Pitisi nɛ pinɔ́si kulúi pɛɛ Upíimɑ nɛ kɛfɑ n tɛnɛ ɑpi pɛɛ mɛsɛ́rɛ pi n kpɑriisɛpɔ ɑpí nɛ kulúi kpɑ́. ");
INSERT INTO soy_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Pisoi ɑpi yɛ pɛɛ́ nɛ pitóikɔ́ icée-i léépɔ ɑpi pisifinɛ nɛ ɑsɑ́ŋɑ́ɑ́pɔrɛ́ kɛcɑ́ɑ́ pi finsɛntɛ rɛ Piyɛɛ un píyei kei n tɔ́su, ukumííri kukɛ́ ḿpɑ́ usɛ unyinɛ yɑrii. ");
INSERT INTO soy_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Pisoi kulúi ɑpi kɔ ɑyu nyɛɛ nɛ Yerusɑlɛm n kɔ́lɛ̃ yisi ɑpí nɛ pitóikɔ́ nɛ pinírihélɑɑ wúrunkɛɛpɔ, ɑpi kɔ pinnɛ́í pélesi. ");
INSERT INTO soy_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Kɑi lɛ̃ n wɑ, Uléécɑɑ usinɑ nɛ Pisɑtusee pɛɛ ukɛkúrí ń we ɑpi kufɑtoi píimɑ nɛ nyɛrɛ rɛ pikɛ́ pitumɛ cɔ́pii. ");
INSERT INTO soy_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Api mɛsei pi cɔ́pii ɑpi kuyu kukpɑniilee kɛ́mɛɛ pi hɑ́nɛsi. ");
INSERT INTO soy_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Amɑ́ kɑi kɛsinɛ n wɑ, Upíimɑ uleecɑɑtumɛ unyinɛ uu sĩ́ uú hɑ kukpɑniilee hɑ́nnɛ uu pi lesɛpɔ, uu pi mɑɑ rɛ: ");
INSERT INTO soy_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Ani Uléécɑɑ kɛyɔ-i hɑ, ɑní hɑ nsímɛ́ mɛɛ yɛ nfɑ́ɑ n hɛ kɛ Yeesu uú nɛ ń kɑ nnɛ́í pisoi símisi. ");
INSERT INTO soy_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Pitumɛ ɑpi mɛsei ŋmurɛi ɑpi mmɑrɛ mɑrɛ yisi ɑpi Uléécɑɑ kɛyɔ sĩ ɑpí hɑ pisoi picélɑɑ kɑ́pɑ́ɑ́. Uléécɑɑ usinɑ nɛ pɛpɛɛ ukɛkúrí ń we ɑpi tuiri ɑpi pitúhɑɑnɛ wɛ́ɛ́sɛ nɛ Isirɑyɛɛli piwɛ́ɛ́sɛ nnɛ́í icɑ́pinɛ séi. Kei kɑpi pisoi tũ ɑpí hɑ pitumɛ pɛ̃ kukpɑniilee-i kpíípɔ. ");
INSERT INTO soy_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Kɛ pɛ̃ ɑpi ń hɑ, ɑ́pi kukpɑniilee-i pi yɛ̃. Api pɛɛ pɛɛri ɑpi pi mɑɑ rɛ: ");
INSERT INTO soy_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Tɔ kukpɑniilee lɛɛpɔlɛ kun ńsɔnɛ hɑ́nɑɑlɛ̃, pimɛ́rɛ́ pɔ́ɔn kɔ ɑnɔnɔɔ-i tɑ́pɑɑlɛ̃. Amɑ́ kɑri n hɑ́nnɛ, ɑ́ri úkɑ kɛmɛ́ɛ yɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Kɛ Uléécɑɑ kɛyɔ umɛ́rɛ́ wɛ́ɛ́sɛ nɛ pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ ɑpi lɛ̃ n kṍ, ɑi mɛ́woo pi wɑi, ɑpi pɛɛ lɛ̃ kɑi yɛ́ nɛ kɛ́tɔ ń kpu kɛcɑ́ɑ́ m músu. ");
INSERT INTO soy_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Kei kɛ unyinɛ uú kɑ uu pi mɑɑ rɛ: Nɔ kómɛii! Pisoi pɛ̃ kɑni kukpɑniilee-i n wɑ pɛɛ nní Uléécɑɑ kɛyɔ-i nyɛnupɔ pin pisoi céési. ");
INSERT INTO soy_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Umɛ́rɛ́ wɛ́ɛ́sɛ nɛ pimɛ́rɛ́ picɔ ɑpi pɛɛ yisi, ɑ́pi rikɔhɔ mɛkɔ́ wɑ ɑpí hɑ pi kpíípɔ ɑpí nɛ hɑpɔ, pin wuru rɛ pin pitumɛ pɛ̃ nɛ rikɔhɔ n wɑi, pisoi yɛ́ ɑpɑrɛ pi tɑpisi ɑpi pi kóni. ");
INSERT INTO soy_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Kɑpí nɛ pi n hɑ́pɔ, ɑpi kɛtúhɑɑnɛ píimɑ-i pi séi. Uléécɑɑ usinɑ uu pɛɛ nsímɛ́ pipísɛi pi kɑ́pɑ́ɑ́ ");
INSERT INTO soy_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","rɛ: Kɑrí nɛ nɔ́ ń yɛ̀ ɑrí nɛ kɛtẽ kpɛɛni rɛ ɑ́ni kɑpɛ usoi uyɛ̃ tinyiri nɛ n céési, íye kɑni wɑ? Nɔ welɛ nɔn Yerusɑlɛm kuyu nnɛ́í icélɑɑ iyɛ̃ nɔŋ́lɛ̃ ḿpɑ́ úye ukɛ́ kṍ, nɔn kɔ lɑ rɛ unkpɔ iwɛ ikɛ́ nɛ rɔ́ tɛnɛ! ");
INSERT INTO soy_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Piyɛɛ nɛ pitumɛ picɔ ɑpi pi pɛsɛ rɛ: Li nɛ sɑ́ rɛ usoi ukɛ́ Uléécɑɑ pɑkɑrɛ nɛ kuu yɛ́ pisoi m pɑkɑrɛ. ");
INSERT INTO soy_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Yeesu uyɛ̃ kɑni kunɑ kɛcɑ́ɑ́ n kɑrii kɛ pirɔ́sɑ́ɑ Uleecɑɑ uu nkpɔ kɛ́mɛɛ yukusɛ. ");
INSERT INTO soy_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Uléécɑɑ yɛ ukulukɛ-lukɛ-mɛ̃ kɛ́yukɔɔ́ tonɛ-i u ritɑɑ́sɛlɛ uu u wɑisɛ Uyɔ́ɔpi nɛ Úyulɑlɛ. Uyɛ̃ kuú lɑ ukɛ́ Isirɑyɛɛli pikɔ́ nyísɛ rɛ pikɛ́ ritiki ɑpí nɛ piɑkópɛ kɛpirɛ tɔ uu pɛɛ pi sɑ́rɛi. ");
INSERT INTO soy_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Tɔ́ɔ nsímɛ́ mmɛ̃ pitɑnsei, Nfɑ́ɑsɔnɛ kɛ Uléécɑɑ uu pɛpɛɛ u m pɑkɑrɛlɛ̃ n hɛ pɔ̃́ nɛ kɔ itɑnsei lelɛ. ");
INSERT INTO soy_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Kɛ pitúhɑɑnɛ ɑpi lɛ̃ n kṍ, ɑi pi fukɔɔmɛ ɑpi rɛ pi yɛ́ pitumɛ pɛ̃ kṍ. ");
INSERT INTO soy_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Amɑ́ Ufɑrisi unyinɛ yɛ pɛɛ pitúhɑɑnɛ pɛ̃ kɛcɔpɛ welɛ. Pi yɛ u sée rɛ Kɑmɑliyɛɛli. Isé ucélɑɑ unyinɛ lo kɛ ḿpɑ́ úye uu n wɑisɛlɛ̃. Uyɛɛ pitúhɑɑnɛ píimɑ pɛ̃ kɛcɔpɛ yisi uu rɛ pikɛ́ pitumɛ pɛ̃ lesɛpɔ nkɑ́ripi kɛlenɛ. ");
INSERT INTO soy_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Kɑpi pi n lésɛpɔ, uu pɛɛ pɛpɛɛ n cɑ́pinɛlɛ̃ mɑɑ rɛ: Nɔ̃́ Isirɑyɛɛli pikɔ́, ɑni nɔ́mɛnɛ́círɛ tĩ nɛ mɛwɑi mɛ̃ kɑni nní ń lɑ nɔkɛ́ pisoi pɛ̃ wɑ. ");
INSERT INTO soy_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ái kɑhɑnɛ nkpɑ́ni n nɑ́ŋɑi kɛ Teetɑsi uu léemɛ un pɔ́lɔ́lɛ̃ tɛ u úyukɔɔ́ píimɑ unyinɛ lɛ. Pisoi pílɛ pílɛ mɛnɑ kumúŋɛ́ pɛɛ u ritiki. Api u kopu. Pɛ̃ nnɛ́í pɛɛ pɛɛ́ unkɔ́ n tíkilɛ̃ ɑpi kpíi, piukɑ úu nɛni tisɛlɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Uyɛ̃ kɛpirɛ, Kɑlilee ukɔ́ Yutɑsi pɔ́ɔ pikɛ́ɛ̃ ituŋɛ kumúŋɛ́ léeri, uu pisoi kulúi kpɑ́ú ɑpi u n tikilɛ̃. Uyɛ̃ uu kɔ kpi, pɛpɛɛ pɛɛ́ u n tíkilɛ̃ pɔ́ɔ kɔ kpii. ");
INSERT INTO soy_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Lɛ̃ nnyɑ, nɛ lɑ kɛ́ nkpéni nɔ́ símisi rɛ ɑ́ni kɑpɛ nɛ pisoi mpí kutu n cɔlɛ̃. Ani pi riyɑ́ pikɛ́ tɔ́mpɔ. In tɛ sisoipipi kɛ́mɛɛ kɛ pisimúŋɛ́ nɛ piliwɑiwɑi nní ɑi léeri, mɛ́woo kɑi wɑinɛ. ");
INSERT INTO soy_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Amɑ́ in tɛ Uléécɑɑ-i kɑi léeri, ńnɑŋɛ ń-ye kɛ nɔ́ɔ mɑ́ nɔkɛ́ nɛ linyinɛ pi wɑ. Ani nɔ́mɛnɛ́círɛ tĩ, ɑ́i kɑpɛ kɑ likɛ́ wɑ rɛ nɔ nɛ Uléécɑɑ tɔpu. ");
INSERT INTO soy_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Api mɛsei unkɔ́ kóm ɑpi u tiki. Api pɛɛ pitumɛ pɛ̃ séipɔ ɑpi rinɔ́ɔ hɛ rɛ pikɛ́ sipɔ́pí pi yɛ́ɛ́riinɛ ɑpí nɛ pi yulu rɛ ɑ́pi kɑpɛ Yeesu rinyiri nɛ pisoi pisímɛ́ rikpɑ́, ɑpi pɛɛ pi yɑ́ ɑpi tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Pitumɛ ɑpi mpɔ́ɔnɑrɛ nɛ pitúhɑɑnɛ pɛ̃ kɛkúrí yisi, lin pi lɑ́ɑ́rú rɛ Uléécɑɑ yɛɛ yɛ̃ tɛ pɛ̃ kɑí nɛ sɑ́ rɛ pikɛ́ Yeesu nnyɑ íwɛ li. ");
INSERT INTO soy_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ḿpɑ́ kɛweesi kɛ́ye kɛ pitumɛ ɑpi pɛɛ Uléécɑɑ kɛyɔ-i nɛ síyɔ kɛ́mɛɛ Nsímɛ́ Kɛcirɛ picélɑɑ nɛ mpiyóó ŋmɔ́ɔ́púlɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Yeesu pipirɛtiki ɑpi kumúŋɛ́ kpɛ-i kulúi wɑi ńsɔnɛ. Upipirɛtiki pɛɛ Mɛ́kirɛki n símisi ɑpi Pi-epiree nɛ n téni rɛ pi ḿpɑ́ kɛyɑ́ɑ kɛ́ye ilukɛ kɑpi yɛ n hɔ́ɔnɛ kɛ́mɛɛ pipikumɑnnɔsi mɛnípɛɛ le. ");
INSERT INTO soy_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Kei kɛ Yeesu pitumɛ kɛfi nɛ pitɛ́ pɛ̃ ɑpi upipirɛtiki riwúí tɛ̃ sée ɑpi cɑ́pinɛ ɑpi pi mɑɑ rɛ: Ái nɛ sɑ́ rɛ tɔ́ɔkɛ́ Nléécɑɑsimɛ́ piyóó nɛ sikɑ̃́ wɑ tɔkɛ́ hɑ ilukɛ pihɔɔnɛ nɛ kutu n cɔlɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Lɛ̃ nnyɑ pimɑ́rɛcɔ, ɑni nɔ́kɛnɛ́cɔpɛ pitisi pisɛɛi pɛ̃ kɑní nɛ isoi sɔnɛ n nyu lesɛ. Nfɑ́ɑsɔnɛ nkɛ́ kɔ pi n yipɑɑlɛ̃, pikɛ́ kɔ mɛwɛ́ɛ́sɛsɔhɔ m mɑ́, tɔkɛ́ pikɛi pɛ̃ piɑnipɛ-i wɑ. ");
INSERT INTO soy_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Tɔ́ɔkɛ́ pɛɛ́ uyɛ-i nɛ piyómɛyɑ́hɑɑ nɛ Nléécɑɑsimɛ́ piyóó n ŋmɔ́ɔ́púlɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Tinɔ́ɔ tɛ̃ ɑri pinnɛ́í lɑrisi, ɑpi pikɛcɔpɛ pisoi pisɛɛi lesɛ. Pɛpɛɛ Etiyɛɛni yɛɛ Uléécɑɑ nɛ kɛfɑ mɛyɑ̃́ n tɛnɛlɛ̃, Nfɑ́ɑsɔnɛ nn kɔ u yipɑɑlɛ̃. Uyɛ̃ nɛ Filipu nɛ Purokɔɔ nɛ Nikɑnɔɔ nɛ Timɔɔ nɛ Pɑrimenɑɑsi nɛ Antiyɔɔsi ukɔ́ kɑpi yɛ n sée rɛ Nikolɑɑ. U pɛɛ mɛkɛɛ Pisuifi kɛyomɛ yɑ́ɑsilɛ uu kɛlenɛ pɑnsɛ Yeesu upirɛtiki. ");
INSERT INTO soy_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Kɑpi pi n lésɛ, ɑpi pi kpísi ɑpí nɛ pitumɛ lɛɛpɔ, pɛ̃ ɑpi pikɛcɑ́ɑ́ kɛyómɛ yɑ́ɑ́si ɑpi kɔ ɑnípɛ pikɛcɑ́ɑ́ lɑ́ɑ. ");
INSERT INTO soy_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Nléécɑɑsimɛ́ nn ḿpɑ́ yei n kɔ́ɔ́núlɛ̃, Yeesu pipirɛtiki pin mɛyɑ̃́ kulúi wɑi Yerusɑlɛm kuyu-i, ɑí nɛ pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ mɛyɑ̃ pɛ́nɛ ɑpi Yeesu nɛ kɛfɑ tɛnɛ. ");
INSERT INTO soy_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Uléécɑɑ yɛ pɛɛ Etiyɛɛni mɛyɑ̃́ ípɛɛlɛ́ɛ nyísɛlɛ uu kɔ ńnɑŋɛ u hɛ un nɛ mɛwɑisɑŋɑ nɛ mɛwɑi píimɑ pisoi kɛcɔpɛ wɑpisi. ");
INSERT INTO soy_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Pisuifi kuyómɛyɑ́hɑɑlee pikɔ́ pinyinɛ kɑpi yɛ pɛɛ sée rɛ: Pɛpɛɛ ilɑ́si kɛ́mɛɛ ń le kɛyɔ. Alɛkisɑntiri nɛ Silisii nɛ Asii kɛtẽ pikɔ́ yɛ pi. Pikɛcɔpɛ, pitisi pinyinɛ ɑpi nsímɛ́ nnyinɛ kɛcɑ́ɑ́ nɛ Etiyɛɛni íkɛŋɛnɛ wɑi. ");
INSERT INTO soy_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Amɑ́ ɑ́pi yɛ́ fe pikɛ́ nɛ Etiyɛɛni kɛŋɛnɛ, mɛwɛ́ɛ́sɛsɔhɔ kɛ Nfɑ́ɑsɔnɛ nn u n hɛ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Api pɛɛ pisoi pinyinɛ kulɛi rɛ pikɛ́ ukɛcɑ́ɑ́ nnɔ́ɔmɛ wɑ rɛ pi kõ un Moisi nɛ Uléécɑɑ ɑlɛ̃́ fɑ́ɑ́nii. ");
INSERT INTO soy_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Api kɔ kuyu pisoi nɛ kuyu piwɛ́ɛ́sɛ nɛ isé picélɑɑ itɑ́í súúni ɑpi yisi ɑpi nyɛrɛ, ɑpi sĩ́ ɑpí hɑ Etiyɛɛni tini ɑpí nɛ kɛtúhɑɑnɛ píimɑ-i sĩ́. ");
INSERT INTO soy_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Api kɔ pinɔ́ɔmɛ pinyinɛ nɛ hɑpɔ rɛ pikɛ́ íseérɑkɔɔ́ li pikɛ́ nɛ u rikpɑ́rɑ́ rɛ: Mɛsɛ́rɛ kɛ utisi nkó uu Uléécɑɑ kɛyɔ nɛ isé ɑlɛ̃́ fɑ́ɑ́nii. ");
INSERT INTO soy_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Tɔ konlɛ un símɑɑnkɛɛ rɛ Nɑsɑrɛti ukɔ́ Yeesu uyɛ̃ nɛ́ Uléécɑɑ kɛyɔ fori uu kɔ inyɛ́kii kɛ Moisi uú nɛ rɔ́ n tíyɛ consɛ. ");
INSERT INTO soy_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Pɛ̃ nnɛ́í pɛɛ kɛtúhɑɑnɛ píimɑ kɛ-i ń we yɛ pɛɛ Etiyɛɛni kɛ́yu-i nyɑ́nɛilɛ ɑpi yɛ́nu rɛ ukɛyu yɛ uléécɑɑtumɛ kɛkɔ́ mɛcɔ welɛ. ");
INSERT INTO soy_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Uléécɑɑ usinɑ uu pɛɛ Etiyɛɛni pisɛ rɛ: Lɛɛ ni mɛseii? ");
INSERT INTO soy_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Etiyɛɛni uu rɛ: Nɔ̃́ pinɛ́mɑ́rɛcɔ nɛ pinɛ́sɑ́ɑ, ɑni kutu ricɔ ńsɔnɛ ɑni kóm! Uléécɑɑ, mɛyɔ́ɔpi ute yɛ urɔ́sɑ́ɑ Apirɑhɑm tikpɑ́fúmɛlɛ pɛɛ́ uyɛ-i kuú pɛɛ Mesopotɑmii-pɔ ń we, uu kɛlenɛ Hɑrɑɑni-pɔ finɛ. ");
INSERT INTO soy_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Uu pɛɛ u mɑɑ rɛ: A kɛpɔ́tẽ nɛ kupɔ́mɑ́rɛ riyɑ́ ɑɑ kɛtẽ kɛ̃ kɑm pɔ́ n nyísɛnɛ kɛ́mɛɛ sĩ́. ");
INSERT INTO soy_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Apirɑhɑm uu pɛɛ Kɑlitee kɛtẽ yisi uú hɑ Hɑrɑɑni-pɔ finɛ. Usɑ́ɑ mɛkpɔ-mɑɑ́, Uléécɑɑ uu kei u kpísi uú nɛ kɛtẽ nkɛ́-i kɑni nɛni nní ń we weri. ");
INSERT INTO soy_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Uléécɑɑ úu kei kɛtẽ u hɛ. Ḿpɑ́ kɛ́nɑcɔpɛ ritísí, úu u hɛ rɛ ukɛ́ kei ripɛ́ɛ́lú. Amɑ́ uu pɛɛ rinɔ́ɔ yekei rɛ u yɛ́ kɛnnɛ́í u nɛ mɑsí upipirɛ̃ pɑ ɑpí n te. Úu kɔ pɛɛ kumúŋɛ́ kpɛ-i kɛwɑ̃́ mɑ́. ");
INSERT INTO soy_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Lɛ̃ kɛ Uléécɑɑ uu u ḿ mɑ yɛ nní: Kucɔ̃yu-pɔ kɛ pipɔ́pírɛ̃ ɑpí mɑsí finɛnɛ, ɑpi ilɑ́si pi tini, ɑpi íwɛ pi wɑi ɑŋmɛ̃ pílɛ pílɛ mɛnɑ. ");
INSERT INTO soy_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Amɑ́ nɛ́ nɛ mpuri mmɛɛ ilɑ́si pi n tininɛ túhɑɑnɛ ɑpi pɛɛ limɛmɑ́ɑ́ léeri ɑpí weri ɑpi nté kɛlõ nkɛ́-i nɛ́ yɑ́ɑ́si. ");
INSERT INTO soy_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Kei kɛ Uléécɑɑ uu pɛɛ u nɛ Apirɑhɑm kɛcɔpɛ rinɔ́ɔ yekei rɛ ukɛ́ riké. Lɛ̃ nnyɑ kɑpi Isɑɑki mɑri Apirɑhɑm uu pɛɛ kɛyɑ́ɑ pɑ́hɑ-pɑhɑ tuŋɛ́ u ké. Isɑɑki pɔ́ɔ kɔ uuŋmɑ́nɛ Yɑkupu ké. Yɑkupu pɔ́ɔ kɔ limɛcɔ upiŋmɑ́nɛ kɛfi nɛ pitɛ́ pɛ̃ kérii. Pɛpɛɛ nní pirɔ́kpurɛ kɛfi nɛ pitɛ́ pɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Pikpurɛ pɛ̃ ɑpi pikɛcɔpɛ usɛ kɑpi yɛ n sée rɛ Yosɛfi nɛ kɛfɑ tóósi ɑpi u yɑ́i, uú hɑ Esipiti-pɔ ilɑ́si le. Amɑ́ Uléécɑɑ yɛ pɛɛ Yosɛfi kɛkúrí welɛ, uu ncɔ́ŋ nnɛ́í kɛ́mɛɛ u lesɛ ");
INSERT INTO soy_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","uú nɛ kɛfɑ u fénnɛ uu mɛwɛ́ɛ́sɛsɔhɔ u hɛ. Esipiti uyɔɔpi uu Esipiti kɛtẽ kɛcɑ́ɑ́ iyɔ́ɔpi u tonsɛ uu kɔ ukɛyɔ likɔ́ nnɛ́í kpísi uu uɑnipɛ-i wɑi. ");
INSERT INTO soy_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Nkṹ nnyinɛ nn Esipiti kɛtẽ nnɛ́í nɛ Kɑnɑɑ kɛtẽ loni. Pirɔ́sɑ́ɑyɑhɑ ɑpi íwɛ píimɑ le, ɑ́pi yɛ yɛ̃ pikɛ́ li. ");
INSERT INTO soy_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Yɑkupu uu kóm tɛ mɛlukɛpipi yɛ Esipiti kɛtẽ-pɔ we, uu pirɔ́sɑ́ɑyɑhɑ tum mɛfoí. ");
INSERT INTO soy_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Kɑpi mɛlírũ n hɑ́pɔ, Yosɛfi uu tíyɛsɛ upimɑrɛcɔ ɑpi u ceru. Esipiti uyɔɔpi pɔ́ɔ kɔ Yosɛfi riyíkí céru. ");
INSERT INTO soy_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yosɛfi uu pɛɛ tum ɑpi usɑ́ɑ Yɑkupu séipɔ nɛ ukumɑrɛ nnɛ́í pisoi kuwóó nɛ ɑfɛɛrɛ́ nɛ pinupũ. ");
INSERT INTO soy_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yɑkupu uu yisi u nɛ pirɔ́sɑ́ɑyɑhɑ picɔ ɑpí hɑ Esipiti kɛteni-i finɛ ɑpí hɑ nɛ kei kpíni. ");
INSERT INTO soy_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Api pi cɔni ɑpí nɛ Sikɛm kuyu sĩ ɑpí hɑ kei rikpíí kɛ Apirɑhɑm uu Hɑmɔɔ piŋmɑ́nɛ-i nɛ usiwóó ń lɔ kɛ́mɛɛ pi kulɛsi. ");
INSERT INTO soy_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Kɛ rinɔ́ɔ kɛ Uléécɑɑ uú pɛɛ Apirɑhɑm n yekei ituŋɛ ii n nyɑhɑiri, ntɔ́puri nn pɛɛ mɛyɑ̃́ kulúi n wɑi Esipiti kɛtẽ kɛcɑ́ɑ́. ");
INSERT INTO soy_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Uyɔ́ɔpi fɑlɛ unyinɛ yɛɛ úu píkɑi Yosɛfi nkɔ́ ńkɑ n kómɑɑlɛ̃ uu Esipiti kɛteni-i iyɔ́ɔpi tonɛ. ");
INSERT INTO soy_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Uyɔ́ɔpi uyɛ̃ uu ntɔ́puri nɛ isɔhɔɔcee tóói uu pirɔ́sɑ́ɑyɑhɑ íwɛ lukɛisɛ, hɑ́i un nɑ́ɑ́si yɑrɛ pikɛ́ pisipipi riyɑ́ sikɛ́ kpí. ");
INSERT INTO soy_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Likumúŋɛ́ kpɛ-i kɑpi Moisi mɑri un Uléécɑɑ inipɛɛ-i nyɑḿ. Iwɑ́rɛ itɑɑni kɑpi usɑ́ɑ kɛyɔ-i u kpínii. ");
INSERT INTO soy_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Api limɛmɑ́ɑ́ u fómni, Esipiti uyɔɔpi ukpére uu u kpísi uu nyɔ́lu yɑrɛ uricuruu yɛɛ u mɑri. ");
INSERT INTO soy_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Esipiti pikɔ́ mɛnyuwɛ nnɛ́í kɑpi u céesi, unsímɛ́ nɛ umɛwɑi ɑmɛ tíyɛsɛ uu ńnɑŋɛ m mɑ́. ");
INSERT INTO soy_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Kuu iŋmɛ̃ ɑfɛɛnɑ n yɛ̃́, uu rɛ u yɛ́ hɑ upimɑrɛcɔ Isirɑyɛɛli pikɔ́ rilóólú. ");
INSERT INTO soy_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Kuu n hɑ́pɔ, uu Esipiti ukɔ́ unyinɛ lɛɛpɔ un Isirɑyɛɛli ukɔ́ unyinɛ kɑii. Uu unɑ́rɛi kɛcɑ́ɑ́ kpɑ́ uu Esipiti ukɔ́ uyɛ̃ kɑii uyɛ̃ uú hɑ nɛ kpi. ");
INSERT INTO soy_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moisi yɛ pɛɛ músu rɛ upimɑrɛcɔ Isirɑyɛɛli pikɔ́ yɛ́ kṍ tɛ uyɛ̃ kɛ Uléécɑɑ uú lɑ ukɛ́ nɛ ritiki ukɛ́ nɛ ilɑ́si kɛ́mɛɛ pi lesɛ. Nɛ́ḿpɑ́kɑnɛ upimɑrɛcɔ ɑ́pi lɛ̃ kõ. ");
INSERT INTO soy_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Moisi uu kɔ kɛyɑ́ɑ lírũ tuŋɛ́ Isirɑyɛɛli pikɔ́ pitɛ́ lɛɛpɔ pin cɛ́ŋɛsi, uu pɛɛ́ hɑpɔ rɛ ukɛ́ pi yoriyɛ. Uu pi pisɛ rɛ: Nɔ pisoi pisɛ lɛ, pinɛ́sɑ́nɛ! Yo nnyɑ kɑni pɛɛ cɛ́ŋɛsi? ");
INSERT INTO soy_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Uyɛɛ pɛɛ ucɔ n íwɛ n wɑi uu pɑnsɛpɔ uu Moisi lɑ́upɔ uu u pisɛ rɛ: Wóo iyɔ́ɔpi pɔ́ tónsɛ rɛ ɑ irɔ́símɛ́ n túhɑɑnɛ? ");
INSERT INTO soy_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Pɔ lɑlɛ pɔkɛ́ nɛ́ kpu yɑrɛ kɑɑ sé Esipiti ukɔ́ ń kpu, nɛ́ɛ íye? ");
INSERT INTO soy_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Kɛ Moisi uu ɑnɔ́ɔ nyɛ̃ n kṍ, uu wuru uú hɑ Mɑtiyɑɑ kɛtẽ-pɔ tonɛ. Kei kuu piŋmɑ́nɛ pitɛ́ mɑ́ri. ");
INSERT INTO soy_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Iŋmɛ̃ ɑfɛɛnɑ mɛmɑ́ɑ́, Moisi uu pɛɛ kɛyɑ́ɑ kɛnyinɛ kucɛsi kóimɑ-i Sinɑyi riyɔpɛ kɛkúrí n we. Kei kɛ Uléécɑɑtumɛ unyinɛ uu kuhííhíí kunyinɛ kɛcɔpɛ inɑlempi kɛ́mɛɛ u rikpɑ́fúmɛ. ");
INSERT INTO soy_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Kɛ Moisi uu lɛ̃ n yɛ̃́, ɑi mɛnyinɛ u wɑi. Uu rɛ ukɛ́ rinyɔsɔ́pɔ ukɛ́ hɑ mɛwɑi mɛ̃ nyɑ́nɛi. Uu Uléécɑɑ rinɔɔ kom tɛ: ");
INSERT INTO soy_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Nɛ́ɛ pipɔ́sɑ́ɑyɑhɑ Uleecɑɑ, nɛ Apirɑhɑm nɛ Isɑɑki nɛ Yɑkupu Uleecɑɑ. Moisi uu pɛɛ iwɑmɛ nɛ n tɛrii úu kɑhɑ ukɛ́ riweríi. ");
INSERT INTO soy_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Upíimɑ uu u mɑɑ rɛ: A ɑpɔ́nɛ́ɛ́ri mɑhɑ̃, li we rɛ kɛlõ kɛ-i kɑɑ nní n nyɛnu yɛ Uléécɑɑ ripɔhɔ lɛ. ");
INSERT INTO soy_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nɛ Esipiti kɛteni-i nnɛ́puri iwɛ yɛnlɛ, ɑm kɔ piiŋmɔpi kom. Lɛ̃ nnyɑ kɑḿ kɑ kɛ́ pi yoriyɛ. Lɛ̃ nnyɑ, ɑ nkpéni kɑm kɛ́ Esipiti kɛtẽ-pɔ pɔ́ tũ. ");
INSERT INTO soy_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Moisi uyɛ̃ kɛ Isirɑyɛɛli pikɔ́ ɑpí pɛɛ n kɛ́si, ɑpi u mɑɑ rɛ: Wóo iyɔ́ɔpi nɛ itúhɑɑnɛ pɔ́ tónsɛ? Uyɛ̃ cirɛ kɛ Uléécɑɑ uu tummɛ rɛ ukɛ́ piuyɔɔpi, ukɛ́ kɔ ilɑ́si kɛ́mɛɛ pi lesɛ. Uléécɑɑtumɛ uyɛɛ kuhííhíí kɛcɔpɛ inɑlempi kɛ́mɛɛ u rinkpɑ́fúmɛ yɛɛ u lɛ́ninɛ. ");
INSERT INTO soy_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moisi yɛɛ Isirɑyɛɛli pikɔ́ Esipiti kɛteni-i lésɛmɛ. Iŋmɛ̃ ɑfɛɛnɑ kɛ́mɛɛ kuú nɛ Esipiti kɛteni-i nɛ Míni-Wɛɛ́-Kukoi kɛ́mɛɛ nɛ kucɛsi kóimɑ-i mɛwɑisɑŋɑ nɛ mɛwɑi píimɑ mɛ̃ wɑpisi. ");
INSERT INTO soy_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Uyɛ̃ cirɛ yɛɛ pɛɛ Isirɑyɛɛli pikɔ́ símisi rɛ: Uléécɑɑ yɛ́ ɑntepu unyinɛ nɔ́ pɑ́mɛ yɑrɛ nɛ̃́ un nɔ́nnɛ́puri ukɔ́. ");
INSERT INTO soy_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Kɛ Isirɑyɛɛli pikɔ́ ɑpí pɛɛ kucɛsi kóimɑ-i n cɑ́pinɛ, uyɛɛ pɛɛ pirɔ́sɑ́ɑyɑhɑ nɛ Uléécɑɑtumɛ yɛɛ Sinɑyi riyɔpɛ kɛcɑ́ɑ́–pɔ u n símɑɑri kɛcɔpɛ we. Uléécɑɑ nsímɛ́ mɛɛ yɛ nfɑ́ɑ n hɛ kuú pɛɛ yɔ́su un tɔ́ pɑ́lɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Amɑ́ pirɔ́sɑ́ɑyɑhɑ ɑ́pi pɛɛ́ lɑ pikɛ́ u pɑkɑrɛ, ɑpi uipuri yulu ɑpí n kɑ́ípi pikɛ́ Esipiti pɛlɛ. ");
INSERT INTO soy_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Api pɛɛ Arɔɔ mɑɑ rɛ: A piléécɑɑ rɔ́ mɔ̃́ pɛɛ yɛ́ kɛrɔ́yu-i n sɔ́nɛ, li we rɛ ɑ́ri nyu lɛlɛɛ Moisi uyɛɛ nní Esipiti kɛtẽ-pɔ rɔ́ n lésɛmɛ n wɑ. ");
INSERT INTO soy_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Api kɛyɑ́ɑ kɛ̃ tinɑ́ɑpipi mɔm, ɑpi ri nyɔ́ɔnsɛ, ɑpi piɑnipɛ limɔmɛ-mɔmɛ lɛ̃ ɑnyɑ̃́ wɑi, piɑkiŋ ɑɑ niŋɛsi. ");
INSERT INTO soy_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Amɑ́ Uléécɑɑ uu kɛpirɛ pi tɔ uu pi yɑ́ ɑpi ituŋɛ nɛ iwɑ́rɛ nɛ ɑwɑ́rɛpi n yɑ́ɑ́si yɑrɛ kɑi ɑntepuyɛ ɑtɛlɛ́-i n wɔ́lɑɑlɛ̃. Li kei wɔlɑɑlɛ̃ tɛ: Nɔ̃́ Isirɑyɛɛli pikɔ́, nɛ̃́ kɑni iŋmɛ̃ ɑfɛɛnɑ kɛ́mɛɛ kucɛsi kóimɑ-i isɛɛ nɛ nyɔ́ɔnsɛntɛ ɑni kɔ licɔ licɔ hɛkɛsii? ");
INSERT INTO soy_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Amɑ́ piléé kɑpi yɛ n sée rɛ Molɔki kucɑ́ŋíí nɛ nɔ́pinɛ́léé Refɑɑ riwɑrɛpi kɑní pɛɛ topori. Lɛ̃ kɑní sɛrí nɔn nɛ pi yɑ́ɑ́si. Lɛ̃ nnyɑ kɑm nɔ́ lésɛnɛ kɛ́ nɛ Pɑpilɔɔni kɛtẽ kɛpirɛ-mɛmpɔ hɑ. ");
INSERT INTO soy_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Pirɔ́sɑ́ɑyɑhɑ yɛ pɛɛ kucɛsi kóimɑ-i kucɑ́ŋíí mɑ́lɛ kpɛɛ n nyísɛlɛ̃ tɛ Uléécɑɑ yɛ tɔ́ nɛ uyɛ̃ kɛcɔpɛ rinɔ́ɔ yekeilɛ. Ku pɛɛ́ welɛ yɑrɛ kpɛ̃ kɛ Uléécɑɑ uú pɛɛ Moisi n símisi rɛ ukɛ́ wɑ. U pɛɛ Moisi mɑɑ rɛ ukɛ́ kpɛ̃ kuú pɛɛ n yɛ̃́ kucɔ wɑ. ");
INSERT INTO soy_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Pirɔ́sɑ́ɑyɑhɑ yɛ kucɑ́ŋíí kpɛ̃ nɛ pipipirɛ̃ tíyɛlɛ. Pɛɛ́ uyɛ-i kɛ Yosuwee uú pɛɛ pi n kpɑ́úlɛ̃ kɑpí pɛɛ́ nɛ ku ripɛ́nɛ ɑpí nɛ kɛtẽ kɛɛ pikɛyu-mɛmpɔ ń we tɛ́ŋ́. Kɛtẽ kɛ̃ pikɔ́ kɛ Uléécɑɑ uú pɛɛ lɑ́kɑsɛ. Kucɑ́ŋíí kpɛ̃ ɑku lɛ̃ Kɑnɑɑ-i n we ɑí nɛ Tɑfiti kumúŋɛ́ tulu. ");
INSERT INTO soy_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Uléécɑɑ yɛ pɛɛ́ nɛ Tɑfiti kɛfɑ fénnɛlɛ. Tɑfiti uu pɛɛ u pisɛ rɛ ukɛ́ ncée u hɛ ukɛ́ kɛ́yɔ mɔ̃ kɛkɛ́ wɑ kei kɛ Yɑkupu Uleecɑɑ uu ń we. ");
INSERT INTO soy_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Amɑ́ Sɑlomɔɔ yɛɛ kɑ uu kɛ́yɔ u mɔm. ");
INSERT INTO soy_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ḿpɑ́ nɛ lɛ̃, Uléécɑɑ yɛɛ ḿpɑ́ yo kɛcɑ́ɑ́ ń tṹ, úu síyɔ kɛ pisoi ɑpi m mɔ̃́ kɛ́mɛɛ sói. Yɑrɛ kɛ ɑntepu Esɑyi uu ḿ mɑɑ rɛ: ");
INSERT INTO soy_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Upíimɑ yɛ mɑɑ rɛ Kɛyómɛcɑɑ yɛ rinɛ́yɔ́ɔpitũ lɛ, kɛtẽ pɔ́ɔ kɛnɛ́nɑcɔpɛ kɛ́yɔ kɛ́ye kɛ nɔ́ɔ yɛ́ nɛ́ mɔ̃́? Yei kɑm yɛ́ tonɛ kɛ́ nɛ n wéntɛ? ");
INSERT INTO soy_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ái rinɛ́cúruu nɛ́ɛ lɛ̃ nnɛ́í wɑɑ? ");
INSERT INTO soy_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Etiyɛɛni uu kɔ pimɑ́ɑ pi kpɑ́ rɛ: Nɔ́ pisoi mpí ɑtii yɛ pɑ́ɑ́púlɛ hɑ́i. Nɔ́ ɑkíŋ tɑkɑ́lɛ, nɔ́ɑnɛ́tu ɑ́ɑ yɛ kɔ nsímɛ́ kṍ. Nɔ́pinɛ́sɑ́ɑyɑhɑ mɛcɔ kɑni nní we nɔn Nfɑ́ɑsɔnɛ rinɔɔ kɛsu. ");
INSERT INTO soy_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Antepu úye mpuri kɛ nɔ́pinɛ́sɑ́ɑyɑhɑ ɑ́pi wéékusɛlɛ̃? Pɛ̃ nnɛ́í pɛɛ n símisi rɛ Asei ute yɛ wemɛ kɑpi kṍ. Asei ute uyɛ̃ kɛ nɔ́ɔ kɔ nkpéni nní pilɑ́ɑrɔ ɑnipɛ-i wɑ ɑni u kopu. ");
INSERT INTO soy_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Uléécɑɑ yɛ nɛ piléécɑɑtumɛ ritikilɛ uú nɛ uisé nɔ́ pɑ, ɑmɑ́ ɑ́ni i ritiki. ");
INSERT INTO soy_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Kɛ pɛpɛɛ pɛɛ kɛtúhɑɑnɛ-i ń we ɑpi lɛ̃ n kṍ, ɑi kuwɔ́i pi fukɔɔmɛ ɑpi pɛɛ Etiyɛɛni nsímɛ́ mmɛ̃ nɛ ɑnĩ́ n tɑkɑi. ");
INSERT INTO soy_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Amɑ́ Etiyɛɛni pɔ́ɔ pɛɛ kɛléécɑɑ inípɛɛ n tɑpɑɑlɛ̃, Nfɑ́ɑsɔnɛ nn u yipɑɑlɛ̃ un nɛ Uléécɑɑ mɛyɔɔpi nɛ Yeesu yɛɛ Uléécɑɑ kulukɛ-lukɛ-mɛ̃ kɛ́yukɔɔ́tonɛ-i n nyɛnu nyɑ́nɛi. ");
INSERT INTO soy_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Kei kuu pɛɛ rɛ: Nɛ kɛyómɛcɑɑ nyɑ́nilɛ kɛn wúkulɛlɛ̃, Usoi Kɛpipi kɛn Uléécɑɑ kulukɛ-lukɛ-mɛ̃ kɛ́yukɔɔ́tonɛ-i nyɛnu. ");
INSERT INTO soy_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Kuu lɛ̃ ḿ mɑ, ɑpi kɛpupɛilɑ píimɑ kɛnyinɛ té ɑpi ɑtu tɑ́pisi ɑpi pinnɛ́í kɛsẽ́ pehépɔ ɑpi u fílí, ");
INSERT INTO soy_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ɑpi u lɑkɑsɛ ɑpí nɛ kuyu iyɑɑ leepɔ ɑpi ɑpɑrɛ u tɑpisi ɑpi kópu. Pɛpɛɛ kei ń we ɑpi pisitukɑnkɑ cícɑɑ́ mɑ́hɑni ɑpi uŋmɑ́nɛ unyinɛ kɑpi yɛ n sée rɛ Sɔɔli pɑ uu si m mɛ̃́. ");
INSERT INTO soy_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Pi Etiyɛɛni ɑpɑrɛ tɑpisilɛ un we un kɔ nɛ kɛyómɛ yɑ́ɑ́si. Uu rɛ: Upíimɑ Yeesu, ɑ nnɛ́fɑ́ɑ yɔsí, ");
INSERT INTO soy_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","uu pɛɛ ɑnui kɛcɑ́ɑ́ wúlɑ uu mɛsɔ́ri pupɛi rɛ: Upíimɑ, kɑpɛ ɑkópɛ nnyɛ́ piriyu kɛcɑ́ɑ́ wɑ. Kuu lɛ̃ pimɑ́ɑ ḿ mɑsí, uu pɛɛ kpi. ");
INSERT INTO soy_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Etiyɛɛni nkpɔ mmɛ̃ nń nɛ Sɔɔli sɑ́. Likɛyɑɑ kɛ̃ cirɛ kɑpi Yerusɑlɛm kuyomɛyɑ́hɑɑlee pikɔ́ piwéékusɛ korɑɑnɛ ɑi wɔ́ŋɔɔ. Pinnɛ́í ɑpi Yutee sitẽ nɛ Sɑmɑrii sitẽ kɛcɑ́ɑ́ yɛ́kɑ́ɑ́, ɑi yɑ́ pitumɛ ŋmɑnɛ. ");
INSERT INTO soy_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Pisoi pɛɛ Uléécɑɑ likɔ́ ń lɑ pɛɛ Etiyɛɛni kulɛsi ɑpi nkpɔ tonɛ ɑpi ukɛcɑ́ɑ́ téni hɑ́i. ");
INSERT INTO soy_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sɔɔli pɔ́ɔn ŋmɔ́ɔ́púlɛ̃ tɛ ukɛ́ Uléécɑɑ icɑ́pinɛ kpu. Síyɔ kuú pɛɛ kɔ́ɔ́núlɛ̃ un Kirisi pikɔ́ cɔ́pii, pitisi nɛ pinɔ́si, un kukpɑniilee súúni. ");
INSERT INTO soy_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Pɛpɛɛ rin-yɛ́kɑɑ yɛ pɛɛ kɛtẽ kɔ́ɔ́núlɛnlɛ pin Nsímɛ́ Kɛcirɛ yóólɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipu uu yisi uú hɑ Sɑmɑrii kuyu mɑɑ-i yóó rɛ Yeesu yɛɛ uyɛ̃ kɛ Uléécɑɑ uu n wɛ́ɛ. ");
INSERT INTO soy_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Pisoi nnɛ́í yɛ pɛɛ rinɔ́ɔ risɛ wɑlɛ pin Filipu kutu cɔlɛ̃. Pi pɛɛ kómɛilɛ rɛ u mɛwɑisɑŋɑ wɑpisi, ɑpi kɔ mɛ yɛnu. ");
INSERT INTO soy_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Aníri yɛ pɛɛ pisoi mɛyɑ̃ kɛ́mɛɛ lelɛ ɑn pupukɛɛ. Síkɑnkɑ́lɑ́kɑ́ nɛ pipɑ́íkɔɔ́ kulúi yɛ pɛɛ pélesilɛ. ");
INSERT INTO soy_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ai pɛɛ lɛ̃ nnyɑ pisoi n lɑ́ɑ́rú kuyu kpɛ-i. ");
INSERT INTO soy_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Utisi unyinɛ yɛɛ hɑ́i mɛkɛɛ-mɛ kuyu kpɛ-i we, ɑpi yɛ u séi rɛ Simɔɔ. U pɛɛ mɛtɑrɛwɑi wɑpisilɛ ɑi yɛ Sɑmɑrii pikɔ́ nnɔ́ɔ yipu. U kɔ pɛɛ umɛcirɛ kpíilɛnlɛ rɛ u úyukɔɔ́ unyinɛ lɛ. ");
INSERT INTO soy_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Pisoi nnɛ́í, kɑi n kpísi siwɑ̃́ nɛ piwɛ́ɛ́sɛ yɛ pɛɛ u wɑisɛlɛnlɛ hɑ́i. Api yɛ mɑɑ rɛ: Uléécɑɑ nnɑŋɛ kɑpi yɛ n sée rɛ ńnɑŋɛ mɑɑ mɛɛ usoi nkó kɛ́mɛɛ we. ");
INSERT INTO soy_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Hɑ́i mɛkɛɛ-mɛ kɛ umɛtɑrɛwɑi ɑmɛ nnɔ́ɔ pi yipɑɑlɛ̃. Api pɛɛ lɛ̃ nnyɑ u n wɑisɛlɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Amɑ́ kɛ Filipu uu Uléécɑɑ iyɔɔpi nɛ Yeesu Kirisi kɛcɑ́ɑ́ Nsímɛ́ Kɛcirɛ pi n símisi ɑpi ŋmurɛi, pi tíyɛsɛlɛ ɑpi míni pi wolɛ, kɑi n kpísi pitisi nɛ pinɔ́si. ");
INSERT INTO soy_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simɔɔ uyɛ̃ ticuruu pɔ́ɔ kɔ nɛ Nsímɛ́ Kɛcirɛ mmɛ̃ kɛfɑ tɛnɛ ɑpi míni u wolɛ. Uu pɛɛ Filipu n tikilɛ̃ un mɛwɑisɑŋɑ nɛ mɛwɑi píimɑ kɛ uyɛ̃ uu n wɑpisi nyɑ́nɛi mɛn nnɔ́ɔ u yipɑɑlɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Pitumɛ pɛɛ Yerusɑlɛm-i ń we ɑpi kóm tɛ Sɑmɑrii kɛtẽ pikɔ́ yɛ Nléécɑɑsimɛ́ yɔsí. Api pɛɛ Piyɛɛ nɛ Yohɑni kei tumpɔ. ");
INSERT INTO soy_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Pikɛtɛ́ kɛ̃ ɑpi yisi ɑpi sĩ́ ɑpí hɑ nɛ Uléécɑɑ welu rɛ ukɛ́ Sɑmɑrii pikɔ́ pɛ̃ Nfɑ́ɑsɔnɛ hɛ. ");
INSERT INTO soy_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Nfɑ́ɑsɔnɛ ńn pɛɛ kɑhɑnɛ likumúŋɛ́ kpɛ-i úkɑ kɛcɑ́ɑ́ n súimɛ. Míni ŋmɑnɛ kɑpí pɛɛ́ nɛ Yeesu rinyiri pi wolɛ. ");
INSERT INTO soy_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Kei kɛ Piyɛɛ nɛ Yohɑni ɑpi pɛɛ ɑnípɛ pikɛcɑ́ɑ́ rilɑɑ, Nfɑ́ɑsɔnɛ nn pɛɛ pi loni. ");
INSERT INTO soy_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Kɛ Simɔɔ uu n yɛ̃́ tɛ pitumɛ yɛ pisoi kɛcɑ́ɑ́ ɑnípɛ rilɑɑ Nfɑ́ɑsɔnɛ nn pi loni, uú nɛ siwóó hɑpɔ uu pitumɛ pɛ̃ mɑɑ rɛ: ");
INSERT INTO soy_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Ani kɔ nɛ̃́ ńnɑŋɛ mmɛ̃ hɛ kɛ́ yɛ nɛn úye kɛcɑ́ɑ́ ɑnípɛ rinlɑɑ, ukɛ́ Nfɑ́ɑsɔnɛ yɔsí. ");
INSERT INTO soy_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Amɑ́ Piyɛɛ uu u pɛsɛ rɛ: Nɔ́ nɛ sipɔ́wóó sɛ̃ ɑni ɑ́sɑ́lɑ́ú wɑ. Pɔ musí rɛ pɔ́ fe ɑɑ Uléécɑɑ lihɛɛhɛɛ nɛ siwóó lɔluu? ");
INSERT INTO soy_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Lipɔ́kɔ́ líkɑ ɑ́i nté we, ɑ́ɑ kɔ líkɑ kɛcɑ́ɑ́ nté ncée mɑ́. Li we rɛ ɑ́ɑ Uléécɑɑ kɛ́mɛɛ ɑsei mɑ́. ");
INSERT INTO soy_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","A kɛpɔ́múŋɛ́ kópɛ kɛpirɛ ritɔ ɑɑ Upíimɑ nɛ téni rɛ lin kusɑ́rɛi n we, ukɛ́ kɛmúŋɛ́ kɛ̃ pɔ́ sɑ́rɛi. ");
INSERT INTO soy_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Nɛ nyɑ́ni yɑrɛ nfɑsimɛ́ kópɛ nɛ rikpɑ́kɑ́rɑ́ kɑɑ n fɑnɑɑlɛ̃ yɛ pɔ́ múílɛnlɛ yɑrɛ ulɑ́si. ");
INSERT INTO soy_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Kei kɛ Simɔɔ uu pɛɛ rinɔ́ɔ yɔsí rɛ: Ani nɔ́rinɛ́cúruu nɛ Upíimɑ nɛ́ tẽ́, lɛ̃ kɑni nní ḿ mɑ ɑ́i kɑpɛ nɛ nɛ́ n wɑ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Kɛ Piyɛɛ nɛ Yohɑni ɑpi Sɑmɑrii kuyu kpɛ-i Upíimɑ nsímɛ́ piyóó nɛ picélɑɑ ḿ mɑsí, ɑpi yisi ɑpi Yerusɑlɛm pɛlɛ, pin ncée-i siyupi mɛyɑ̃ kɛ́mɛɛ Sɑmɑrii kɛtẽ kɛcɑ́ɑ́ Yeesu Nsímɛ́ kɛcirɛ yóólɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Upíimɑ uleecɑɑtumɛ unyinɛ uu Filipu mɑɑ rɛ: A yisi ɑɑ ituŋɛ kumii-mɛ̃ pɑnsɛ ɑɑ Yerusɑlɛm ncee mɛɛ Kɑsɑɑ n cɛ́pilɛ̃ kpísi. Ápi yɛ ncée mmɛ̃ titiki. ");
INSERT INTO soy_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Filipu uu mɛsɛ nɛ mɛsɛ yisi uu tɔ́mpɔ, uú nɛ ncée Etiyopii kɛtẽ utisi unyinɛ sɑ́nɛ. Ukɑwe píimɑ unyinɛ lo . Uyɛɛ Etiyopii unɔsiyɔɔpi Kɑntɑɑsi mɛmɑ́ nnɛ́í kɛcɑ́ɑ́ pɑílɛ̃. U Yerusɑlɛm-i kɑlɛ rɛ ukɛ́ Uléécɑɑ yɑ́ɑ́si ");
INSERT INTO soy_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","un pɛɛ nkpéni kulu, un ukɛsɑnnɔipi kɛcɑ́ɑ́ tṹ un ɑntepu Esɑyi ritɛlɛ́ kɛ́ɛ́ni. ");
INSERT INTO soy_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Nfɑ́ɑsɔnɛ nn Filipu mɑɑ rɛ: A kɛnɔ́ipi nkɛ́ kɛkúrí hɑpɔ. ");
INSERT INTO soy_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filipu uú nɛ itóó nyɔsɔ́pɔ uu kóm Etiyopii ukɔ́ uyɛ̃ un ɑntepu Esɑyi ritɛlɛ́ kɛ́ɛ́ni. Filipu uu u pisɛ rɛ: Pɔ lɛ̃ kɑɑ n kɛ́ɛ́ni ɑsei kómɛii? ");
INSERT INTO soy_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Utisi uu rɛ: Unyinɛ unsɑ́ nɛ́ n lɛ̃́, íye kɑm yɛ́ nɛ kõ? Uu pɛɛ Filipu séi rɛ ukɛ́ hɑpɔ ukɛ́ kɛsɑnnɔipi kɛ́mɛɛ ukɛkúrí tonɛ. ");
INSERT INTO soy_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Li Uléécɑɑ Nsímɛ́ kɛlõ kɛ̃ kuu n kɛ́ɛ́ni kɛ́mɛɛ wɔ́lɑɑlɛ̃ tɛ: Pi nɛ u tɔ́sulɛ yɑrɛ kɑpi yɛ kusɑ́ŋyɑhɑ n tɔ́rɔi pin nɛ pikópɛ sĩ, un sɛ́ɛ́lɛ̃ yɑrɛ risɑ́ŋpipi kɑpi nkpíí ń nyɑ́lu, úu rinɔ́ɔ wúkulɛ. ");
INSERT INTO soy_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Apí nɛ u túhɑɑnɛ ɑpi u cɛpisɛ, úu pɛɛ nkpɑ́ni líkɑ tu. Wóo yɛ́ pɛɛ nkpɑ́ni upipirɛ̃ tinɔɔ mɑɑ? Pi kɛtẽ kɛcɑ́ɑ́ unfɑɑ lesɛlɛ. ");
INSERT INTO soy_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Kuu lɛ̃ pikɛ́ɛ̃ m mɑsí, uu pɛɛ Filipu pisɛ rɛ: A risuúlu ɑ nɛ́ símisi nkɛ̃́ tɛ úye nsímɛ́ kɛ ɑntepu nkó uu nní símisi. Uricuruu kuú nɛ mɑ́nɛ nɛ́ɛ unyinɛ nsímɛ́ kuu símisi? ");
INSERT INTO soy_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Kei kɛ Filipu uu pɛɛ́ nɛ ɑntepu Esɑyi nsímɛ́ mmɛ̃ riwɑ́ɑ́nɑ́ uú nɛ Yeesu nsímɛ́ kɛcirɛ u símisi. ");
INSERT INTO soy_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Api nsẽ́ nɔŋ́ ɑpí hɑ nɛ míni kɛlõ kɛnyinɛ tulu. Ukɑwe píimɑ uyɛ̃ uu pɛɛ rɛ: Míni yɛ mmɛ́ nní. Yo icɔ yɛɛ pɑ́rílɛ̃ kɛ́ nɛ míni ń wolɛ? ");
INSERT INTO soy_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipu uu u pɛsɛ rɛ: In tɛ pɔ nɛ kɛpɔ́fɑ nnɛ́í nsímɛ́ mmú tɛnɛ, pi yɛ́ fe ɑpi míni pɔ́ wolɛ. Utisi uu rɛ: Nɛ nɛ kɛfɑ tɛnɛ rɛ Yeesu Kirisi yɛ Uléécɑɑ Kɛpipi lɛ. ");
INSERT INTO soy_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Uu kɛsɑnnɔipi nyɛrɛsɛ, u nɛ Filipu ɑpi míni-i lompɔ, Filipu uu míni u wolɛ. ");
INSERT INTO soy_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Kɑpi míni-i n léepɔ, Upíimɑ Nfɑɑsɔnɛ nn Filipu kpíípɔ, ukɑwe uyɛ̃ úu pɛɛ piyɛ́nɛ u rikpɑ́. Uyɛ̃ uu kɔ mpɔ́ɔnɑrɛ nɛ uncee nɔŋ́. ");
INSERT INTO soy_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filipu pɔ́ɔ hɑ Asɔɔti kɛtẽ-pɔ leeri. Uu pɛɛ kei ɑyu nnɛ́í nyɛɛ ncée-i ń we kɛ́mɛɛ Nsímɛ́ Kɛcirɛ n yóólɛ̃ uú hɑ nɛ Sesɑree kɛtẽ tulu. ");
INSERT INTO soy_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Sɔɔli úu pɛɛ kusɑ kumúŋɛ́ kpɛ-i Upíimɑ pipirɛtiki nɛ kɛfɑ pɔ́ɔ́lú un wɛ́ɛ́si ukɛ́ pi kṍ. Uu yisi uu lɛ̃ nnyɑ Uléécɑɑ usinɑ lɛɛpɔ, ");
INSERT INTO soy_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","uu rɛ uyɛ̃ ukɛ́ ɑ́tɛlɛ́ u wɑ ɑkɛ́ ncée u hɛ ukɛ́ hɑ Tɑmɑɑsi-pɔ Pisuifi ɑyomɛyɑ́hɑɑlee rikɑ. Un kei píye n lɛɛpɔ pɛɛ Upíimɑ ncee n tíkilɛ̃, pitisii, pinɔ́sii, ukɛ́ fe ukɛ́ pi cɔ́pii ukɛ́ pɑhɑɑnkɛɛ ukɛ́ nɛ Yerusɑlɛm tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Kuu ncée n kpísi un nɛ Tɑmɑɑsi nyɑhɑipɔnɛ kɛ mɛtɛ́í mɛnyinɛ ɑmɛ mɛyéne mɛsɛ kɛyómɛcɑɑ-pɔ leemɛ ɑmɛ tɑpu ɑmɛ́ nɛ u kɔ́ɔ́nú. ");
INSERT INTO soy_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Uu kɛteni-i lólu, uu pɛɛ rinɔ́ɔ rinyinɛ kom tin tee rɛ: Sɔɔli, Sɔɔli, yo kɛcirɛ nnyɑ kɑɑ lɛ̃ nɛ́ wéékusɛlɛ̃? ");
INSERT INTO soy_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sɔɔli uu pɛɛ pisɛ rɛ: Pɔ́ɔ úye, Upíimɑ? Upíimɑ uu rinɔ́ɔ u yɔ́su rɛ: Nɛ́ɛ Yeesu uyɛ̃ kɑɑ nní ń we pɔn wéékusɛlɛ̃. Áɑ yɛ nkpɑ́ni fe pɔkɛ́ nɛ nkpɔ mɛlõ tɔpiriinkɛɛ. Un tɛrii lin nnɔ́ɔ u yipɑɑlɛ̃, uu pɛɛ́ mɑɑ rɛ: Upíimɑ, yo kɑɑ́ lɑ kɛ́ wɑ? Kei kɛ Upíimɑ uu pɛɛ́ mɑɑ rɛ: ");
INSERT INTO soy_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","A yisi ɑɑ kuyu-i lompɔ. Pɔn n lompɔ, pi yɛ́ pɛɛ pɔ́ símisi lɛ̃ kɑɑ yɛ́ ń wɑ. ");
INSERT INTO soy_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Sɔɔli pisencɔ ɑpi nyɛrɛ pírí, rinɔ́ɔ ɑ́ri we. Amɑ́ pi pɛɛ rinɔ́ɔ kómɛilɛ ɑ́pi pɛɛ úkɑ nyɑ́ni. ");
INSERT INTO soy_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sɔɔli uu yisi uu ɑnípɛɛ wii úu pɛɛ líkɑ nyɑ́ni. Api pɛɛ kunípɛ u múlú ɑpi u tɔrɔi ɑpí nɛ Tɑmɑɑsi sĩ. ");
INSERT INTO soy_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Siyɑ́ɑ sitɑɑni kuu wɑ úu yɛ líkɑ yɛ̃, úu yɛ líkɑ li úu yɛ kɔ líkɑ n ntí. ");
INSERT INTO soy_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Kirisi upirɛtiki unyinɛ yɛ pɛɛ Tɑmɑɑsi-i welɛ, ɑpi yɛ u séi rɛ Anɑniyɑsi. Upíimɑ uu kɛyɑ́ɑ kɛnyinɛ u kpɑ́fúmɛ uu u séi rɛ: Anɑniyɑsi! Anɑniyɑsi! Uu rɛ: Nɛ́ɛ nkó, Upíimɑ! ");
INSERT INTO soy_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Upíimɑ uu u mɑɑ rɛ: A yisi ɑ ncée mmɛ̃ kɑpi yɛ n sée rɛ Kɛcirɛ kpísi ɑɑ́ hɑ Yutɑsi kɛyɔ-i Tɑrisi ukɔ́ uyɛ̃ kɑpi yɛ n sée rɛ Sɔɔli kɛcɑ́ɑ́ pisɛ. U welɛ un kɛyómɛ yɑ́ɑ́si. ");
INSERT INTO soy_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ai u nyísɛ rɛ utisi unyinɛ kɑpi yɛ n sée rɛ Anɑniyɑsi yɛ lompɔ uu ɑnípɛ ukɛcɑ́ɑ́ lɑ́ɑ rɛ uyɛ̃ Sɔɔli inipɛɛ ikɛ́ yɛ kɔ yɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Anɑniyɑsi uu rɛ: Upíimɑ, nɛ konlɛ pisoi mɛyɑ̃ pin símisi rɛ utisi uyɛ̃ úu kusɑ pipɔ́soi pɛɛ Yerusɑlɛm-pɔ ń we rikpɑ́kɑ́rɑ́ wɑpisi. ");
INSERT INTO soy_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ pɛɛ ncée u hɛ rɛ ukɛ́ nté kɑm ukɛ́ pɛ̃ nnɛ́í pɛɛ pɔ́ n yɑ́ɑ́si cɔ́pii. ");
INSERT INTO soy_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Amɑ́ Upíimɑ uu u pɛsɛ rɛ: A n ŋme. Nɛ usoi uyɛ̃ wɛ́ɛlɛ rɛ ukɛ́ pinɛ́kɛi wɑ. U yɛ́ tíyɛsɛ mpuri sɑnɛ pikɔ́ nɛ pipiyɔɔpi nɛ pɛɛ́ nɛ Isirɑyɛɛli pikɔ́ ɑpi rinɛ́nyíri ceru. ");
INSERT INTO soy_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Nɛ́ rinɛ́cúruu u símisi rɛ u yɛ́ kɛnɛ́cɑ́ɑ́ íwɛ ncɔpuri li. ");
INSERT INTO soy_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Kei kɛ Anɑniyɑsi uu pɛɛ ncée kpísi uú hɑ Yutɑsi kɛyɔ lompɔ, uu Sɔɔli kɛcɑ́ɑ́ ɑnípɛ lɑɑ uu rɛ: Unɛ́mɑ́rɛcɔ Sɔɔli, kɑɑ́ pɛɛ ncée n tíkimɛlɛ̃ pɔn nté wémɛ kɛ Upíimɑ uu pɔ́ rikpɑ́fúmɛ. Uyɛɛ nɛ́ tummɛ rɛ ipɔ́nípɛɛ ikɛ́ yɛ kɔ nkpéni yɛ̃́, Nfɑ́ɑsɔnɛ nkɛ́ kɔ pɔ́ lõ. ");
INSERT INTO soy_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Kei nní, linyinɛ ɑi uinipɛɛ kɛcɑ́ɑ́ lɑ́pilɛ yɑrɛ ikpíntomɛ́ ɑwéé ɑi lólu, uu pɛɛ nkpéni n nyɑ́ni. Uu yisi ɑpi míni u wolɛ ");
INSERT INTO soy_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","uu pɛɛ ilukɛ le uu ńnɑŋɛ yɛnu. Sɔɔli uu Yeesu pipirɛtiki kɛ́mɛɛ Tɑmɑɑsi-i siyɑ́ɑ wɑi. ");
INSERT INTO soy_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Uu pɛɛ kei nní yisi uu síyɔ sɛ-i kɛ Pisuifi ɑyomɛyɑ́hɑɑlee ɑɑ ń we kɑ uu yóó rɛ Yeesu yɛɛ Uléécɑɑ Kɛpipi. ");
INSERT INTO soy_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ai pɛ̃ nnɛ́í pɛɛ u n kómɛi nnɔ́ɔ yipu ɑpi yɛ pɛɛ rɛ: Ái nkó yɛɛ yɛ lɛ̃ Yerusɑlɛm-pɔ pɛpɛɛ rinyíri ntí n sélei n wéékusɛlɛ̃ɛ? Nɛ́ntɛ u kɔ nté kɑlɛ rɛ ukɛ́ lipite pɛ̃ cɔ́pii ukɛ́ nɛ pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ lɛɛpɔ? ");
INSERT INTO soy_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Pɛɛ́ kɛ Sɔɔli uu ńnɑŋɛ piyɛ́nɛ rikpɑ́ uu yɛ nɛ Pisuifi pɛɛ Tɑmɑɑsi-i ń we nsímɛ́ feriyɛ uu pi sɛ́ɛ́sɛ. U yɛ pi nyísɛ rɛ Yeesu yɛɛ Úyulɑlɛ kɛ Uléécɑɑ uu n wɛ́ɛ. ");
INSERT INTO soy_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Kɑi nkɑ́ripi n nɑ́ŋɑi, Pisuifi ɑpi símɑɑnɛ ɑí tonɛ rɛ pikɛ́ Sɔɔli kpu. ");
INSERT INTO soy_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ai Sɔɔli kutu-i loni rɛ pi u wɛ́ɛ́si. Kɛtúŋɛ́ nɛ kɛsinɛ kɑpi pɛɛ kuyu sipoo mɛ̃́ pikɛ́ nɛ u ń kpu nnyɑ. ");
INSERT INTO soy_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Upipirɛtiki ɑpi pɛɛ kɛsinɛ mɛnɛ́rɛ mɛnyinɛ-i u wɑi ɑpí nɛ kuyu mmɛlɛ kɛpirɛ-mɛ̃ u súisɛpɔ. ");
INSERT INTO soy_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Kɛ Sɔɔli uu Yerusɑlɛm n tuipɔ, uu Yeesu pipirɛtiki picɔ pitíki peeni, ɑmɑ́ pinnɛ́í pin pɛɛ u wuru. Ápi pɑkɑrɛlɛ̃ tɛ u mɛsei Yeesu upirɛtiki. ");
INSERT INTO soy_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Kei kɛ Pɑrinɑpɑsi uu mɛsɛ u kpísi uú nɛ pitumɛ lɛɛpɔ, uu lɛ̃ kɛ Upíimɑ uu umɛcirɛ n lésɛ uu Tɑmɑɑsi ncee-i Sɔɔli nyísɛ nɛ lɛ̃ kuú nɛ u n símisi pi kɛɛni. Uu kɔ lɛ̃ kɛ Sɔɔli uu Tɑmɑɑsi-pɔ nɛ ikɑri Nléécɑɑsimɛ́ nɛ Yeesu rinyiri rin-yóó pi símisi. ");
INSERT INTO soy_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Kɑí nɛ kei n kpísi, Sɔɔli nɛ pitumɛ pɛ̃ pɛɛ pɛɛ Yerusɑlɛm-i sɔ́nɛsi, un nɛ ikɑri Nléécɑɑsimɛ́ nɛ Upíimɑ rinyiri yóólɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","U nɛ Pisuifi pɛɛ Mɛ́kirɛki n símisi yɛ̀ɛ̀ pɛɛ ifɑɑci wɑlɛ. Amɑ́ pɛ̃ pin pɛɛ wɛ́ɛ́si pikɛ́ u kpu. ");
INSERT INTO soy_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Kɛ piyómɛyɑ́hɑɑ picɔ ɑpi lɛ̃ n céri, ɑpi u kpísi ɑpí nɛ Sesɑree-mɛ̃ u sĩ ɑpi Tɑrisi-mɛ̃ u tɔ́ŋsɛpɔ. ");
INSERT INTO soy_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Úkɑ úu pɛɛ kumúŋɛ́ kpɛ-i Yeesu pikɔ́ cɔ́ŋlɛ̃ Yutee nɛ Kɑlilee nɛ Sɑmɑrii kɛtẽ nnɛ́í kɛcɑ́ɑ́. Pi pɛɛ ikɑri kpɑriisɛnɛlɛ pin kɔ Upíimɑ riwurɛ mɑ́lɛ. Nfɑ́ɑsɔnɛ nn pi lɛ́ni pin kulúi kpɑ́lɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Piyɛɛ yɛ pɛɛ ḿpɑ́ yei kuyu-i sɔ́nɛlɛ, uú nɛ kɛyɑ́ɑ kɛnyinɛ Yeesu pikɔ́ pɛɛ Litɑ kuyu-i ń we kɛ́mɛɛ tulu. ");
INSERT INTO soy_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Uu kei utisi unyinɛ kɑpi yɛ n sée rɛ Enee lɛɛpɔ. U kɛ́kɑnkɑ́lɑ́kɑ́ lɛ. Li wɑ iŋmɛ̃ ipɑhɑ kuú nɛ kɛfinɛ kɛcɑ́ɑ́ n finu úu yɛ fe ukɛ́ sɔ́nɛ. ");
INSERT INTO soy_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Piyɛɛ uu u mɑɑ rɛ: Yeesu Kirisi yɛ pɔ́ pɔisɛlɛ, Enee. A yisi ɑ ripɔ́cúruu kɛpɔ́finɛ riwɛ́pí. Enee uu kei nní mɛsɛ nɛ mɛsɛ yisi. ");
INSERT INTO soy_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Litɑ pikɔ́ nɛ Sɑɑrɔɔ pikɔ́ nnɛ́í ɑpi u yɛnu ɑpi pimɛcirɛ Upíimɑ pɑ ɑpí nɛ Upíimɑ kɛfɑ tɛnɛ. ");
INSERT INTO soy_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Yɑfɑ-pɔ kɛ unɔ́si unyinɛ uú pɛɛ́ we. Pi yɛ u sée rɛ Tɑpitɑ. Pi yɛ rinyíri tɛ̃ Mɛ́kirɛki kɛ́mɛɛ tuisɛ rɛ Tɔrikɑɑsi Uyɛ̃ nkɔ́ mɛɛ rɛ ukɛ́ ḿpɑ́ píyei lisɔnɛ n wɑi ukɛ́ kɔ pisoi n hɛkɛsi. ");
INSERT INTO soy_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Uu likumúŋɛ́ kpɛ-i kɑ́ɑ́si uu kpi. Kɑpi piwólɛ u m mɑsí, ɑpi kɛ́yɔ kɛcɑ́ɑ́-pɔ kulee kunyinɛ-i kɛléécɑɑ-pɔ u finsɛ. ");
INSERT INTO soy_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Yeesu pipirɛtiki pɛɛ Yɑfɑ-pɔ ń we yɛ pɛɛ kónlɛ rɛ Piyɛɛ yɛ Litɑ-pɔ we. Litɑ yɛ kɔ nɛ Yɑfɑ kɔ́lɛnlɛ. Api pɛɛ pisoi pitɛ́ lesɛ ɑpi Piyɛɛ kɛ́mɛɛ tum tɛ pikɛ́ u mɑɑ rɛ ukɛ́ mɛkɛɛ pikɛmɛɛ wurupɔ. ");
INSERT INTO soy_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Piyɛɛ uu wɑ́kɑsi u nɛ pɛ̃ ɑpi tóoisɛnɛ ɑpi tɔ́mpɔ. Kuu n tuipɔ, ɑpí nɛ kɛ́yɔ kɛcɑ́ɑ́ kulee kpɛ-i u tɑɑ́pɔ. Pikúmɑnnɔsi nnɛ́í ɑpí nyɔsɔ́pɔ ɑpi itu nɛ u kɑ́lisi. Api sitúkɑnkɑ nɛ ɑkpɛ́lɛnku nyɛ̃ kɛ Tɔrikɑɑsi uú pɛɛ nfɑ́ɑ m mɑ́ un yóóni u nyísɛntɛ. ");
INSERT INTO soy_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Kei kɛ Piyɛɛ uu pɛɛ pinnɛ́í lésɛpɔ, uu wúlɑ uu kɛyómɛ yɑ́ɑ́si. Uu pɛɛ ukpɔkpɔ-mɛ̃ pɑnsɛpɔ uu rɛ: Tɔrikɑɑsi, ɑ yisi. Tɔrikɑɑsi uu inípɛɛ wúkulɛ. Kuu Piyɛɛ n yɛ̃́, uu yisi uú tonɛ. ");
INSERT INTO soy_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Piyɛɛ uu kunípɛ u tini uu u lɛ́ni uu yisi. Uu pɛɛ limɛmɑ́ɑ́ piyómɛyɑ́hɑɑ nɛ pikúmɑnnɔsi pɛ̃ séi uu Tɔrikɑɑsi nɛ unfɑɑ pi nyísɛ. ");
INSERT INTO soy_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Nsímɛ́ mmɛ̃ nn Yɑfɑ kuyu nnɛ́í kɔ́ɔ́nú, pisoi mɛyɑ̃ ɑpi Upíimɑ nɛ kɛfɑ tɛnɛ. ");
INSERT INTO soy_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Piyɛɛ uu Yɑfɑ-i ukónɛfukɛi Simɔɔ kɛyɔ-i tonɛ ɑi siyɑ́ɑ wɑi ńsɔnɛ. ");
INSERT INTO soy_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Utisi unyinɛ yɛɛ pɛɛ Sesɑree-pɔ we, ɑpi yɛ u séi rɛ Kɔrinɛɛ. U pɛɛ Rɔm usɔ́ɔ́cɑ kpéẽ unyinɛ lɛ. U pɛɛ pisoi pílɛ kutɔpilee uwɛ́ɛ́sɛ lɛ. ");
INSERT INTO soy_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","U nɛ ukɛyɔ nnɛ́í yɛ pɛɛ Uléécɑɑ likɔ́ lɑlɛ. U yɛ pɛɛ píwɛkɔɔ́ ulikɔ́ mɛyɑ̃́ hɛkɛsilɛ un kɔ mɛsɛ́rɛ Uléécɑɑ yɑ́ɑ́si. ");
INSERT INTO soy_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Kɛyɑ́ɑ kɛnyinɛ kuu kɛtúŋɛ́cɔ mɛtɑɑni kumúŋɛ́ Uléécɑɑtumɛ unyinɛ mɛ́yɛnɛ mɛnyinɛ-i yɛ̃́ cɑ́kɑ́-cɑ́kɑ́. Uléécɑɑtumɛ uyɛ̃ uu ukɛyɔ-i lompɔ uu u séi rɛ Kɔrinɛɛ! ");
INSERT INTO soy_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kɔrinɛɛ uu pɛɛ iwɑmɛ nɛ uléécɑɑtumɛ uyɛ̃ n nyɑ́nɛi uú nɛ u pisɛ rɛ: Nɛ mɛyo-mɛ, Upíimɑ? Uléécɑɑtumɛ uu u pɛsɛ rɛ: Uléécɑɑ yɛ ipɔ́welɛ konlɛ uu kɔ lɛ̃ kɑɑ píwɛkɔɔ́ n lɛ́ni yɛnu. Úu yɛ́ pɔ́ pɑlɛi. ");
INSERT INTO soy_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","A nkpéni pisoi tũ pikɛ́ hɑ Yɑfɑ-pɔ utisi uyɛ̃ kɑpi yɛ n sée rɛ Simɔɔ ɑpi kɔ rinyiri u hɛ rɛ Piyɛɛ séemɛ. ");
INSERT INTO soy_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ukónɛfukɛi uyɛ̃ kɑpi yɛ n sée rɛ Simɔɔ kɛyɔ-i kuú we mínimɑɑ ritimɛ-pɔ. ");
INSERT INTO soy_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Kɛ uléécɑɑtumɛ uyɛ̃ uu lɛ̃ n símisi uu tɔ́mpɔ, Kɔrinɛɛ uu upikɛikɔ́ pitɛ́ pinyinɛ séi. Ukutɔpilee kɛ́mɛɛ usɔ́ɔ́cɑ unyinɛ yɛ pɛɛ Uléécɑɑ likɔ́ lɑlɛ ńsɔnɛ. Uu kɔ uyɛ̃ séi. ");
INSERT INTO soy_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Uu lɛlɛɛ n wɑ nnɛ́í pi kɛɛni uu pɛɛ Yɑfɑ-pɔ pi tum. ");
INSERT INTO soy_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ai ncée pi weesi pin Yɑfɑ lɑpɔ. Piyɛɛ uu ituŋɛ kɛcírɛ kumúŋɛ́ kɛ́yɔ cɑ́cɑ́ ipirɑɑ yopoi rɛ ukɛ́ kɛyómɛ yɑ́ɑ́si. ");
INSERT INTO soy_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Nkṹ nn u wɑi uu rɛ u yɛ́ ilukɛ li. Kɑpi ń we pin ilukɛ iyɛ̃ wɑi, ɑi u wɑi yɑrɛ kɛnípɛɛhee. ");
INSERT INTO soy_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Uu yɛ́nu kɛyómɛ kɛn wúkulɛlɛ̃, linyinɛ lin cɛpimɛlɛ ɑí nɛ kɛteni-i tuiri yɑrɛ kusɑ́ŋɑ́ɑ́ mɑɑmɑɑ kunyinɛ kɑpi n tɑ́ŋɛ pin kuɑtimɛ kɛnɑ mulɛilɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ánɑ ɑnɑ likɔ́ nní ncɔpuri nɛ lɛlɛɛ m múŋui ncɔpuri nɛ sinúipi ncɔpuri yɛɛ pɛɛ kɛmɛ́ɛ we. ");
INSERT INTO soy_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ai rinɔ́ɔ u mɑɑri rɛ: Piyɛɛ, ɑ yisi, ɑ kṍ ɑɑ le. ");
INSERT INTO soy_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Piyɛɛ uu rinɔ́ɔ pɛsɛ rɛ: Kɑ́sɑ, ɑ́m píkɑi irɔ́sé kɛ́mɛɛ icírí inyinɛ lukɑɑlɛ̃, Upíimɑ! ");
INSERT INTO soy_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ai kɔ mɛlírũ pimɑ́ɑ u kpɑ́ rɛ: Lɛ̃ kɛ Uléécɑɑ uú ḿ mɑɑ rɛ lilukɛ-lukɛ, pɑ́ɑ kɑpɛ li mɑɑ rɛ icírí. ");
INSERT INTO soy_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Mɛpehẽ mɛtɑɑni kɑi lɛ̃ wɑ, ɑi pɛɛ limɛmɑ́ɑ́ kusɑ́ŋɑ́ɑ́ kpɛ̃ kɛyómɛcɑɑ-mɛ̃ kpíípɔ. ");
INSERT INTO soy_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Piyɛɛ uú n we un umɛcirɛ písɛi rɛ mɛ́yɛnɛ mɛ̃ ɑsei yɛ nkpéni ɑ́ye. Likumúŋɛ́ kpɛ-i, pisoi pɛ̃ kɛ Kɔrinɛɛ uu n tumpɔ pɔ́ɔn Simɔɔ kɛyɔ wɛ́lɑɑpɔ ɑpí nɛ kɛripoo tuipɔ mɛsɛ nɛ mɛsɛ. ");
INSERT INTO soy_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Api séi ɑpi pisɛ rɛ kei kɛ Simɔɔ kɑpi rinyíri n hɛ rɛ Piyɛɛ uú wee? ");
INSERT INTO soy_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Piyɛɛ un we un mɛyɛ́nɛ mɛ̃ kɛcɑ́ɑ́ músu, Nfɑ́ɑsɔnɛ nn u mɑɑ rɛ: Pitisi pitɑɑni pinyinɛ yɛ mpí pin pɔ́ wɛ́ɛ́si. ");
INSERT INTO soy_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","A yisi ɑ ricɛpipɔ, nɔ́ nɛ pɛ̃ ɑni mɛsɛ nɛ mɛsɛ tɔ́mpɔ. Nɛ́ɛ pi tumpɔ. ");
INSERT INTO soy_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Kei kɛ Piyɛɛ uu pɛɛ súipɔ uu pitisi pɛ̃ mɑɑ rɛ: Nɛ́ɛ Piyɛɛ uyɛ̃ kɑni n wɛ́ɛ́si. Nɛ́ɛ usoi uyɛ̃ kɑni n wɛ́ɛ́si. Nɛ mɛyo-mɛ? ");
INSERT INTO soy_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Api rɛ: Rɔm usɔ́ɔ́cɑ kpéẽ Kɔrinɛɛ yɛɛ rɔ́ tummɛ. U usoi kɛcirɛ lɛ, un kɔ Uléécɑɑ pɑkɑrɛlɛ̃. Pisuifi nnɛ́í yɛ ukɛcɑ́ɑ́ ńsɔnɛ símisilɛ. Uléécɑɑtumɛ unyinɛ yɛɛ u símisi rɛ ukɛ́ pɔ́ sée ɑɑ́ hɑ ukɛyɔ-i nfɑsimɛ́ kɑɑ m mɑ́mɛ u símisi. ");
INSERT INTO soy_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Piyɛɛ u kɛ́yɔ pi tɑni uu kulee pi hɛ ɑpi finɛ. Kɑi kóso n weesi, uu yisi uu pi tiki ɑpi kɛsẽ́ tɔ́mpɔ. Pimɑ́rɛcɔ pinyinɛ pɛɛ Yɑfɑ-i ń we pɔ́ɔ kɔ yisi ɑpi u sɑruni. ");
INSERT INTO soy_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Liukóso kɑpi Sesɑree tu, Kɔrinɛɛ un ukɛyɔ-i upikɔ́ nɛ upisɑnɛ cɑ́pinɛlɛ̃ un nɛ pi mɛ̃́. ");
INSERT INTO soy_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Kɛ Piyɛɛ uu n tuipɔ, Kɔrinɛɛ uu u tɛ́pɛi, uu wúlɑ nɛ kɛtẽ-pɔ uú nɛ ipɑkɑrɛ u yɑ́ɑ́si. ");
INSERT INTO soy_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Piyɛɛ uu u yukusɛ uu nyɛrɛsɛ uu rɛ: A yisi ɑ nyɛrɛ! Nɛ̃́ nɛ kɔ kɛsoipipi lɛ. ");
INSERT INTO soy_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","U nɛ Kɔrinɛɛ pin lɛ̃ ifɑɑci wɑi uú hɑ nɛ kɛ́yɔ lompɔ, uu lɛɛpɔ pisoi pin cɑ́pinɛlɛ̃ kulúi ");
INSERT INTO soy_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","uu pi mɑɑ rɛ: Nɔ́rinɛ́cúruu yɛ nyulɛ rɛ Usuifi úu ncée mɑ́ upiyomɛyɑ́hɑɑ nnyɑ, u nɛ mpuri sɑnɛ ukɔ́ unyinɛ pikɛ́ n sɔ́nɛ, nɛ́ɛ ukɛ́ yɛ ukɛyɔ rilóólú. Amɑ́ Uléécɑɑ yɛ nɛ̃́ símisilɛ rɛ ɑ́i nyɑḿ tɛ kɛ́ m músu rɛ unyinɛ yɛ icírí nɛ́ɛ úkpɛrinkpɛkɔɔ́. ");
INSERT INTO soy_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Lɛlɛɛ tíyɛsɛ, kɑni kɛnɛ́mɛɛ n tumpɔ rɛ pikɛ́ nɛ́ sée, ɑ́m nkpɑ́ni pipɑ́kɑ́-pɑ́kɑ́ peẽ. Nɛ lɑ kɛ́ nkpéni nɔ́ pisɛ rɛ ń-ye kɑní nɛ nɛ́ séi? ");
INSERT INTO soy_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kɔrinɛɛ uu pɛɛ rinɔ́ɔ u yɔ́su rɛ: Siyɑ́ɑ sinɑ yɛ nsí kɑm ituŋɛ nnyí icɔ-i, kɛtúŋɛ́cɔ mɛtɑɑni kumúŋɛ́ nkú-i kɛnɛ́yɔ-i we nɛn kɛyómɛ yɑ́ɑ́si. Mɛsɛ nɛ mɛsɛ, ɑḿ pɑí utisi unyinɛ un ilũ tɑnɑɑlɛ̃ in tɛ́lu un nɛ kɛnɛ́kúrí nyɛnu. ");
INSERT INTO soy_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Uu nɛ́ mɑɑ rɛ: Uléécɑɑ yɛ ipɔ́welɛ yɔsilɛ, Kɔrinɛɛ. U lɛ̃ kɑɑ lipɔ́kɔ́ pisoi n hɛkɛsi yɛnlɛ. ");
INSERT INTO soy_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Lɛ̃ nnyɑ, ɑ pisoi tũ pikɛ́ hɑ Yɑfɑ-pɔ Simɔɔ kɑpi rinyíri n hɛ rɛ Piyɛɛ séemɛ. Ukónɛfukɛi uyɛ̃ kɑpi yɛ n sée rɛ Simɔɔ kɛyɔ-i kuú we mínimɑɑ ritimɛ-pɔ! ");
INSERT INTO soy_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Am pɛɛ mɛsɛ nɛ mɛsɛ pisoi tumpɔ rɛ pikɛ́ pɔ́ séemɛ. Li nɛ́ lɑrisilɛ hɑ́i rɛ pɔ́ kɑ. Ntɔ́nɛ́í mmú, Uléécɑɑ inipɛɛ-i kɑri nkpéni nní we, tɔn kutu cɔlɛ̃ tɔkɛ́ kṍ tɛ ń-ye kɛ Upíimɑ uu pɔ́ mɑ́ɑmɛ rɛ ɑ rɔ́ símisi. ");
INSERT INTO soy_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Kei kɛ Piyɛɛ uu pɛɛ rinɔ́ɔ yɔsí uu rɛ: Nkpéni kɑm mɛyíkíyiki kṍ tɛ Uléécɑɑ úu pisoi nɛ picɔ kóólɛnɛ. ");
INSERT INTO soy_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ḿpɑ́ mpuri ń-ye ukɔ́ yɛ kpére u pɑkɑrɛlɛ̃ un ɑsei tikilɛ̃, u yɛ liute n lɑlɛ. ");
INSERT INTO soy_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Yeesu Kirisi kuu tummɛ rɛ ukɛ́ Isirɑyɛɛli pikɔ́ Nsímɛ́ Kɛcirɛ símisi rɛ u nɛ nkíŋniŋɛ pi kɑ. Yeesu Kirisi uyɛɛ pisoi nnɛ́í Upíimɑ. ");
INSERT INTO soy_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Kɛ Yohɑni uu Nléécɑɑsimɛ́ piyóó nɛ pisoi píniwolɛ ḿ mɑsí, nɔ yɛnlɛ lɛlɛɛ Kɑlilee kɛteni-i n wɑ ɑí hɑ nɛ Yutee kɛtẽ nnɛ́í yɔ́su. ");
INSERT INTO soy_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Uléécɑɑ yɛ pɛɛ Nɑsɑrɛti ukɔ́ Yeesu kɛpirɛ welɛ. U pɛɛ Nfɑ́ɑsɔnɛ ukɛmɛɛ wɑlɛ nn ńnɑŋɛ u hɛ, un nɛ ḿpɑ́ yei sɔ́nɛ un lisɔnɛ wɑi, un pisoi nnɛ́í kɛ kuníri ɑku m múílɛ̃ pɔisɛntɛ. ");
INSERT INTO soy_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Tɔ́ɔ lɛ̃ nnɛ́í kuu Pisuifi kuyu-i nɛ Yerusɑlɛm-i n wɑ piseérɑkɔɔ́. Pi kunɑpɛ́ɛ́kɔɔ́ kɛcɑ́ɑ́ u kɑriilɛ ɑpí nɛ u kopu. ");
INSERT INTO soy_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Amɑ́ Uléécɑɑ uu kɛyɑ́ɑ tɑ́ɑ́nũ tuŋɛ́ nkpɔ kɛ́mɛɛ u yukusɛ, uu fe uu umɛcirɛ lesɛ uu kɛrɔ́cɔpɛ pinyinɛ nyísɛ ɑpi yɛ́nu rɛ u nkpɔ kɛ́mɛɛ yisilɛ. ");
INSERT INTO soy_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ái pɛɛ rɛ pisoi nnɛ́í kuu umɛcirɛ nyísɛ, ɑmɑ́ tɔ̃́ kɛ Uléécɑɑ uu mɛkɛɛ-mɛ n lésɛ rɛ tɔkɛ́ piseérɑkɔɔ́ kuu umɛcirɛ nyísɛ ɑri u yɛnu. Umɛyisɛ-mɑɑ́, tɔ kɛsẽ́ tonɛlɛ ɑri le ɑri níru nɛ uyɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Uu kɔ rɔ́ forii rɛ tɔkɛ́ Nsímɛ́ Kɛcirɛ Pisuifi símisi pikɛ́ céri rɛ uyɛ̃ kɛ Uléécɑɑ uu lésɛ rɛ ukɛ́ pinyɑ́nnyɑ̃́ nɛ pikpɔkpɔ túhɑɑnɛ. ");
INSERT INTO soy_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Antepuyɛ nnɛ́í yɛ unsímɛ́ símisilɛ ɑpi péhelɛ rɛ úye un nɛ kɛfɑ u n tɛnɛ, uyɛ̃ nnyɑ, Uléécɑɑ yɛ liute ɑkópɛ sɑ́rɛi. ");
INSERT INTO soy_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Kumúŋɛ́ kpɛ-i kɛ Piyɛɛ uu lɛ̃ n símisi, Nfɑ́ɑsɔnɛ nn pɛ̃ nnɛ́í pɛɛ uɑnɔɔ nyɛ̃ kutu n cɔ́lɛ̃ kɛcɑ́ɑ́ súiri. ");
INSERT INTO soy_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Pisuifi pɛɛ Yeesu nɛ kɛfɑ n tɛnɛ yɛ pɛɛ Piyɛɛ sɑrunlɛ. Ai nnɔ́ɔ pi yipu rɛ Uléécɑɑ yɛ kɔ mpuri sɑnɛ pikɔ́ Nfɑ́ɑsɔnɛ hɛ. ");
INSERT INTO soy_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Mɛsei kɛ Pisuifi pɛ̃ ɑpí pɛɛ kómɛi mpuri sɑnɛ pikɔ́ mpí pin mɛyu sɑŋɑ mɛnyinɛ símɑɑnkɛɛ pin kɔ siyómɛ nɛ Uléécɑɑ pɑkɑrɛntɛ. Kei kɛ Piyɛɛ uu pɛɛ rɛ: ");
INSERT INTO soy_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Mɛrɔ́cɔ kɛ Uléécɑɑ uu pisoi mpí Nfɑ́ɑsɔnɛ hɛ. Tɔ́ pɛɛ nkpéni fe ɑrí nɛ pi yulu rɛ ɑ́pi kɑpɛ míni wolɛɛ? ");
INSERT INTO soy_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Kei kɛ Piyɛɛ uu rinɔ́ɔ hɛ rɛ pikɛ́ Yeesu Kirisi rinyiri nɛ míni pi wolɛ. Lɛ̃ mɛmɑ́ɑ́, ɑpi pɛɛ u pisɛ rɛ ukɛ́ pikɛmɛɛ siyɑ́ɑ sinyinɛ wɑ. ");
INSERT INTO soy_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Pitumɛ nɛ Kirisi pikɔ́ pɛɛ Yutee kɛteni-i ń we ɑpi kóm tɛ mpuri sɑnɛ pikɔ́ pɔ̃́ nɛ kɔ Uléécɑɑ Nsímɛ́ yɔsí. ");
INSERT INTO soy_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Kɛ Piyɛɛ uu Yerusɑlɛm m pɛɛpɔ, Pisuifi pɛɛ Yeesu nɛ kɛfɑ n tɛnɛlɛ̃ ɑ́pi kɛ́yu u pɑ. ");
INSERT INTO soy_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Pi u mɑɑ rɛ: Pɔ pikécirɛ́ kɛyɔ lompɔ, nɔ́ nɛ pɛ̃ ɑni kɛlõ kɛsɛ le! ");
INSERT INTO soy_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Kei kɛ Piyɛɛ uu pɛɛ lɛlɛɛ n wɑ pi kɛɛnkɛɛ nɛ kɛ́tɔ-pɔ, uu rɛ: ");
INSERT INTO soy_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Yɑfɑ-pɔ kɑḿ pɛɛ́ kɛ́yɔ kɛnyinɛ-i we nɛn kɛyómɛ yɑ́ɑ́si, ɑi nɛ́ wɑi yɑrɛ kɛnípɛɛhee, ɑi linyinɛ nɛ́ nyísɛ lin kɛnɛ́mɛɛ wémɛ. Likɛi lɛɛ welɛ yɑrɛ kusɑ́ŋɑ́ɑ́ mɑɑmɑɑ kunyinɛ kɑpi n tɑ́ŋɛ pin kuɑtimɛ kɛnɑ mulɛilɛ̃. Ai pɛɛ kɛyómɛcɑɑ n leeri lin cɛpimɛlɛ̃ ɑí weri ɑí nɛ nɛ́ kɔ. ");
INSERT INTO soy_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Am kusɑ́ŋɑ́ɑ́ kpɛ̃ kɛ́mɛɛ ńsɔnɛ pɑí, ɑm ɑ́nɑ ɑnɑ likɔ́ nní ncɔpuri nɛ liyúikɔ́ ncɔpuri nɛ lɛlɛɛ m múŋui ncɔpuri nɛ sinúipi ncɔpuri yɛnu. ");
INSERT INTO soy_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Kei kɑi rinɔ́ɔ nɛ́ mɑ́ɑmɛ rɛ: Piyɛɛ, ɑ yisi, ɑ kṍ ɑɑ le! ");
INSERT INTO soy_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Amɑ́ ɑm tinɔ́ɔ yɔ́su rɛ: Kɑ́sɑ, ɑ́m píkɑi irɔ́sé kɛ́mɛɛ icírí inyinɛ lukɑɑlɛ̃, Upíimɑ. ");
INSERT INTO soy_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ai kɔ mɛlírũ kɛyómɛcɑɑ-pɔ pimɑ́ɑ kpɑ́ rɛ: Lɛ̃ kɛ Uléécɑɑ uu ḿ mɑɑ rɛ lilukɛ-lukɛ, pɑ́ɑ kɑpɛ li mɑɑ rɛ icírí. ");
INSERT INTO soy_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Mɛpehẽ mɛtɑɑni kɑi lɛ̃ wɑ, ɑi pɛɛ limɛmɑ́ɑ́ kusɑ́ŋɑ́ɑ́ kpɛ̃ kɛyómɛcɑɑ-mɛ̃ kpíípɔ. ");
INSERT INTO soy_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Likumúŋɛ́ kpɛ-i, pisoi pitɑɑni pinyinɛ ɑpi kei nní weri ɑpi kɛ́yɔ kɛ-i kɑri ń we ripoo-i nyɛrɛ. Sesɑree-pɔ kɑpi lɛ̃ pi tumti. ");
INSERT INTO soy_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Nfɑ́ɑsɔnɛ nn nɛ́ mɑɑ rɛ kɛ́ yisi kɛ́ mɛsɛ nɛ mɛsɛ pi ritiki. Pimɑ́rɛcɔ pikpuulũ mpí ɑpi yisi ɑpi nɛ́ sɑ́runi ɑrí hɑ nɛ kɛsẽ́ Kɔrinɛɛ kɛyɔ-i lompɔ. ");
INSERT INTO soy_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Uyɛ̃ uu rɔ́ kɛ́ɛ́nkɛɛ lɛ̃ kuu uléécɑɑtumɛ ukɛyɔ-i n yɛ̃́ un u tee rɛ ukɛ́ pisoi tũ pikɛ́ hɑ Yɑfɑ-pɔ Simɔɔ kɑpi rinyíri n hɛ rɛ Piyɛɛ sée. ");
INSERT INTO soy_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","U yɛ́ nsímɛ́ u símisi mɛɛ yɛ́ u nɛ ukɛyɔ pikɔ́ nnɛ́í n yóriyɛ. ");
INSERT INTO soy_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Kɑm nsímɛ́ n kpísi, Nfɑ́ɑsɔnɛ nn pikɛcɑ́ɑ́ súiri yɑrɛ knn lɛ̃ kɛ́korɑɑnɛ kɛrɔ́cɑ́ɑ́ n súimɛ. ");
INSERT INTO soy_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Kei kɑm pɛɛ Upíimɑ rinɔɔ ntí léisɛ rɛ: Míni ŋmɑnɛ kɛ Yohɑni uu nɔ́ wólɛ. Amɑ́ Nfɑ́ɑsɔnɛ kɛ Uléécɑɑ uu nɔ́ wolɛnɛ. ");
INSERT INTO soy_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Kɑri Upíimɑ Yeesu Kirisi nɛ kɛfɑ n tɛnɛ, Uléécɑɑ uu Nfɑ́ɑsɔnɛ rɔ́ hɛ. Mmɛ̃ kuu kɔ nkpéni pɛ̃ hɛ. Wóo pɛɛ nkpéni nɛ̃́ kɛ́ nɛ Uléécɑɑ n kɛ́ŋɛnɛ? ");
INSERT INTO soy_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Kɑpi ɑnɔ́ɔ nyɛ̃ n kṍ, ɑpi piɑkiŋ niŋukusɛ ɑpi Uléécɑɑ ríyu wɑisɛ ɑpi rɛ: In lɛ̃, mɛsei yɛ mɛ rɛ Uléécɑɑ yɛ ŋmurɛilɛ rɛ mpuri sɑnɛ pikɔ́ pɔ́ɔkɛ́ kɔ piɑkópɛ kɛpirɛ ritɔ pikɛ́ nfɑ́ɑ yíkíyiki yɛ̃́. ");
INSERT INTO soy_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Kumúŋɛ́ kpɛ-i kɑpí pɛɛ Etiyɛɛni ń kpu, pi pɛɛ pɛpɛɛ Kirisi nɛ kɛfɑ n tɛnɛ wéékusɛlɛnlɛ hɑ́i. Ai tíyɛsɛ picɔ ɑpi wúrunkɛɛ ɑpí nɛ Fenisii kɛtẽ nɛ Siipuru nɛ Antiyɔɔsi tulu, ɑmɑ́ pin pɛɛ Pisuifi ŋmɑnɛ Nléécɑɑsimɛ́ símisi. ");
INSERT INTO soy_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ḿpɑ́ nɛ lɛ̃, Siipuru nɛ Sirɛɛni pikɔ́ pinyinɛ yɛ yisilɛ ɑpi Antiyɔɔsi sĩ ɑpí hɑ Upíimɑ Yeesu Nsímɛ́ Kɛcirɛ Pikirɛki símisi. ");
INSERT INTO soy_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Upíimɑ nnɑŋɛ nn pi lɛ́ni, pisoi mɛyɑ̃ ɑpí nɛ kɛfɑ u tɛnɛ ɑpi mɛfinɛ consɛ. ");
INSERT INTO soy_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Kirisi pikɔ́ pɛɛ Yerusɑlɛm-i ń we ɑpi lɛ̃ kom, ɑpi Pɑrinɑpɑsi Antiyɔɔsi-pɔ tum. ");
INSERT INTO soy_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Kuu n tuipɔ, uu yɛ́nu lɛ̃ kɛ Uléécɑɑ uu pɛpɛɛ nɛ Kirisi kɛfɑ n tɛnɛlɛ̃ tinkpɑ́, ɑi u lɑrisi uu pi ŋmɔ́ɔ́púsɛ rɛ pikɛ́ Upíimɑ nɛ kɛfɑ kɛsɛ n tikilɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Pɑrinɑpɑsi yɛ pɛɛ mɛyíkíyiki usoi sɔnɛ lɛ. Nfɑ́ɑsɔnɛ nn u yipɑɑlɛ̃ un kɔ nfɑtɛnɛ mɑ́. Lɛ̃ nnyɑ kɛ pisoi mɛyɑ̃ ɑpi ŋmurɛi ɑpi Upíimɑ nɛ kɛfɑ tɛnɛ. ");
INSERT INTO soy_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Pɑrinɑpɑsi uu limɛmɑ́ɑ́ yisi uu Tɑrisi-pɔ Sɔɔli piwɛ́lɑɑ sĩ. ");
INSERT INTO soy_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Kuu u n yɛ̃́, uu u kpísi uú nɛ Antiyɔɔsi u sĩ. Api kei Uléécɑɑ icɑ́pinɛ iyɛ-i kuŋmɛ̃ nɛ kuriyu wɑi pin Nléécɑɑsimɛ́ pisoi mɛyɑ̃ céési. Antiyɔɔsi uyɛ-i kɑpi mɛfoí foí Yeesu Kirisi pipirɛtiki rinyíri hɛ rɛ Kirisi pikɔ́. ");
INSERT INTO soy_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Kumúŋɛ́ kpɛ-i kɛ ɑntepuyɛ pinyinɛ ɑpi Yerusɑlɛm yisi ɑpi Antiyɔɔsi sĩ. ");
INSERT INTO soy_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Nfɑ́ɑsɔnɛ nn piusɛ unyinɛ kɑpi yɛ n sée rɛ Akɑpuusi céési uu yóó rɛ nkṹ píimɑ nnyinɛ yɛ́ kɛtẽ nnɛ́í kɛcɑ́ɑ́ wɑ. Nkṹ mmɛ̃ nń weri nn mɛsei Kulooti iyɔɔpi kumúŋɛ́-i wɑi. ");
INSERT INTO soy_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Kei kɛ Yeesu pipirɛtiki pɛɛ Antiyɔɔsi-i ń we ɑpi símɑɑnɛ ɑí tonɛ rɛ pikɛcɔpɛ, ḿpɑ́ úye ukɛ́ lɛ̃ kuu yɛ́ n fe tɔhɔ pikɛ́ nɛ pimɑ́rɛcɔ pɛɛ Yutee-pɔ ń we lɛ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Api mɛsei lɛ̃ wɑi, ɑpi Pɑrinɑpɑsi nɛ Sɔɔli tum ɑpi sĩ́ ɑpí hɑ ítɔhɔ iyɛ̃ nɛ pi lɛ́ni ɑpi pipiwɛ́ɛ́sɛ pɑ. ");
INSERT INTO soy_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Likumúŋɛ́ kpɛ-i kɛ uyɔ́ɔpi Erooti uu Kirisi pikɔ́ pinyinɛ piwéékusɛ lõ. ");
INSERT INTO soy_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Uu tíyɛsɛ ɑpi ritɛ́hɛ nɛ Yohɑni umɑɑ Yɑkupu kopu. ");
INSERT INTO soy_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Kuu n yɛ̃́ tɛ lɛ̃ ŋmɑɑ kɛ Pisuifi ɑpí pɛɛ ń lɑ kuu lɛ̃ wɑ, uu kɔ tíyɛsɛ ɑpi ɑnyɑ̃́ nyɛ-i kɑpi yɛ ɑkpɔ́nɔ́ nyɛɛ ɑ́ɑ pitɛ m mɑ́ n li kɛ́mɛɛ Piyɛɛ pɔ̃́ tini. ");
INSERT INTO soy_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Kɑpi lɛ̃ u n tĩ́ ɑpi kpɑnii, ɑpi pisɔ́ɔ́cɑ siwúípi sinɑ wɑi, ḿpɑ́ kɛ́ye kɛ́mɛɛ pisɔ́ɔ́cɑ pinɑ, pin nɛ u mɛ̃́. Nkpɔ mɛlɔ́ɔ́ ɑnyɑ̃́ mɛmɑ́ɑ́ kɑpi lɛ̃ nɛ músu rɛ pikɛ́ ḿpɑ́ úye inipɛɛ-i u túhɑɑnɛ. ");
INSERT INTO soy_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Kɛ Piyɛɛ uu lɛ̃ kukpɑniilee-i ń we pin u mɛ̃́, Kirisi pikɔ́ pin ukɛcɑ́ɑ́ Uléécɑɑ welu mɛwéntɛ ɑ́mɛ we. ");
INSERT INTO soy_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Kɛsinɛ kɛɛ n weesinɛ Erooti ukɛ́ nɛ Piyɛɛ n túhɑɑnɛ kɛ́mɛɛ kɛ Piyɛɛ uu pisɔ́ɔ́cɑ pitɛ́ kɛpɑ́ɑ́pɑ́ɑ́ we un loni. Anípɛ kɛtɛ́ kɑpí pɛɛ ɑkpɑnii u wɑilɛ̃ pin nɛ u pɑhɑɑlɛ̃, pimɛ́rɛ́ pɔ́ɔn kɔ kukpɑniilee rinɔnɔɔ-i nyɛnu pin mɛ̃́. ");
INSERT INTO soy_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Mɛsɛ nɛ mɛsɛ, Upíimɑ uleecɑɑtumɛ unyinɛ uu lompɔ, mɛtɛ́í ɑmɛ kukpɑniilee yipu. Uléécɑɑtumɛ uyɛ̃ uu Piyɛɛ ilúkɛ́ pɛ́pɛ́ uu u yóŋsɛ, uu u mɑɑ rɛ: A riwɑkɑsi! Akpɑnii kɑpí pɛɛ́ nɛ u m pɑhɑɑlɛ̃ ɑɑ kei nní uɑnipɛ-i léeri ɑɑ súrii. ");
INSERT INTO soy_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Uléécɑɑtumɛ uu pɛɛ u mɑɑ rɛ: A kupɔ́tɑmpɑ́lɑ rité ɑɑ ɑpɔ́nɛ́ɛ́ri tɑni. Piyɛɛ uu mɛsei lɛ̃ wɑi. Uléécɑɑtumɛ uu kɔ rɛ: A kupɔ́kpɛ́lɛnku tɑ̃ ɑɑ yisi ɑɑ nɛ́ tíki. ");
INSERT INTO soy_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Piyɛɛ uu u tiki ɑpi léépɔ, lin u we yɑrɛ kɛlɑ́rɛ́. Úu pɛɛ músu rɛ mɛsei yɛ mɛ. ");
INSERT INTO soy_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Api pimɛ́rɛ́ foí fɑ́ɑu, ɑpi pilírũ kpɑ́ ɑpi pɛɛ nweni rinɔnɔɔ kɑpi yɛ nɛ kuyu-mɛ̃ n léepɔ tulu, tɛ̃ ɑri timɛcirɛ hɑ́nnɛpɔ ɑpi léépɔ. Api ncée kpísi pin tɔ́su. Kei nní, uu Piyɛɛ inipɛɛ-i pɔlu. ");
INSERT INTO soy_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Kɑi Piyɛɛ n hemnɛ kuu pɛɛ yɛ̃́ tɛ mɛwɑi yɛ wɑlɛ. Kei kuu pɛɛ rɛ: Nkpéni kɑm yɛ̃́ tɛ mɛsei yɛ mɛ. Uléécɑɑ yɛ uléécɑɑtumɛ tummɛlɛ uu Erooti ɑnipɛ-i nɛ́ lesɛ, uu kɔ mmɛ̃ kɛ Pisuifi ɑpí pɛɛ́ nɛ nɛ́ ń lɑ kɛ́mɛɛ nɛ́ lesɛ. ");
INSERT INTO soy_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Kɛ Piyɛɛ uu n yɛ̃́ mmɛ̃ kɛ́mɛɛ kuu ń we, uu Yohɑni kɑpi rinyíri n hɛ rɛ Mɑriki uni Mɑɑri kɛyɔ sĩ. Pisoi kulúi yɛ pɛɛ kei cɑ́pinɛlɛnlɛ pin kɛyómɛ yɑ́ɑ́si. ");
INSERT INTO soy_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Kuu n hɑpɔ uu kɛ́yɔ ripoo pepu, unɔ́si kɛikɔ́ unyinɛ kɑpi yɛ n sée rɛ Rooti uu sĩ́ ukɛ́ hɑ yɛ̃ tɛ wóo lo? ");
INSERT INTO soy_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Uu Piyɛɛ mɛtẽ ceru. U yɛ́ ripoo hɑ́nnɛlɛ nɛ́ɛ, uú nyɑ uu mpɔ́ɔnɑrɛ nɛ itóó nɛ kɛ́yɔ-mɛ̃ pɛɛpɔ, uú hɑ rɛ Piyɛɛ yɛ kɑ un tipoo-pɔ we. ");
INSERT INTO soy_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Pɛpɛɛ kei n cɑ́pinɛlɛ̃ ɑpi u mɑɑ rɛ u isɔhɔ torilɛ. Amɑ́ uu kɛ́yu mɑhɑni ŋmɑɑ rɛ mɛsei yɛ mɛ. Api rɛ in lɛ̃, ukumííri yɛ ku. ");
INSERT INTO soy_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Piyɛɛ un lɛ̃ we un tipoo pepu. Kɑpi n hɑ́nnɛ ɑpi u yɛnu, piipiŋɛ ii nnyiyɛ loni. ");
INSERT INTO soy_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Uu kunípɛ nɛ pi símisi rɛ pikɛ́ n sɛ́ɛ́lɛ̃ ɑ́pi kɑpɛ ríkɑ mɑ. Uu kɔ pi símisi lɛ̃ kɛ Upíimɑ uu kukpɑniilee-i u n lésɛ. Uu kɔ pimɑ́ɑ pi kpɑ́ rɛ pikɛ́ hɑ Yɑkupu nɛ pimɑ́rɛcɔ picɔ lɛ̃ símisi. Kuu lɛ̃ pisímɛ́ pi ḿ mɑsí, uu yisi uu kɛlõ féé tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Kɑi n weesi, ɑi pisɔ́ɔ́cɑ pɛ̃ kɛcɔpɛ nɔkɔrɛ hɑ́i, ɑpi pɛɛ́ m písɛinɛ rɛ mɛ́ye kɛ Piyɛɛ uu lõ? ");
INSERT INTO soy_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Erooti uu pɛɛ rinɔ́ɔ hɛ rɛ pikɛ́ u wɛ́ɛ́si. Amɑ́ ɑpi u wɛ́ɛ́si ɑ́pi u yɛ̃. Kei kuu pɛɛ pimɛ́rɛ́ pɛ̃ sée uú nɛ pi túhɑɑnɛ uu rɛ pikɛ́ pi kṍ. Uu pɛɛ limɛmɑ́ɑ́ Yutee kɛteni-i yisi uú hɑ Sesɑree kɛteni-i siyɑ́ɑ wɑi. ");
INSERT INTO soy_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Erooti yɛ pɛɛ́ nɛ Tiiri pikɔ́ nɛ Sitɔɔ pikɔ́ wɔ́lɑɑlɛnlɛ. Pɛ̃ ɑpi rinɔ́ɔ risɛ wɑi rɛ pikɛ́ hɑ u yɛ̃. Api lɛ̃ nnyɑ uyɔ́ɔpi pimɛ́rɛ́ uwɛ́ɛ́sɛ Pilɑsituusi kópóó, ɑpi yɛ́ntinɛ uú nɛ kɛkpéẽ pi wɑi pikɛ́ hɑ nɛ u kpurɛi. Ái mɛ́woo, uyɔ́ɔpi Erooti kɛtẽ kɛ́mɛɛ likɔ́ nfɑɑ kɑpi mɑ́. ");
INSERT INTO soy_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Kɛyɑ́ɑ kɛ̃ kɑpi yɛ́ rinsɑ́nɛ ɑkɛ tulu. Erooti uú hɑ umɛyɔɔpilɑpɛ tɑni uu uriyɔɔpitũ kɛcɑ́ɑ́ tonɛ uu pɛɛ́ nɛ pisoi riwúí nɛ mɛyɑ̃́ n símisi. ");
INSERT INTO soy_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Kei kɛ pisoi ɑpi ipɑkɑrɛ riwɔɔ rɛ: Uléécɑɑ rinɔɔ yɛ ntí, ɑ́i kɛsoipipi rikɔ́. ");
INSERT INTO soy_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Kúu n céri rɛ Uléécɑɑ ŋmɑnɛ yɛɛ ipɑkɑrɛ te nnyɑ, Upíimɑ uleecɑɑtumɛ unyinɛ uu kei nní u fɑpi uu lɑlɛi, ɑpɑpi ɑɑ u tɑkɑi uú hɑ nɛ kpi. ");
INSERT INTO soy_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Nléécɑɑsimɛ́ nn pɛɛ likumúŋɛ́ kpɛ-i kɔ́ɔ́nú ɑpi ḿpɑ́ yei n kom. ");
INSERT INTO soy_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Kɛ Pɑrinɑpɑsi nɛ Sɔɔli pɔ́ɔ lɛ̃ nnyɑ kɑpi Yerusɑlɛm-i pi n tumpɔ piwɑi ḿ mɑsí, ɑpi yisi ɑpi Yohɑni kɑpi rinyíri n hɛ rɛ Mɑriki nɛ pɛ́nɛ ɑpí nɛ Antiyɔɔsi pɛlɛ. ");
INSERT INTO soy_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antepuyɛ nɛ pisoi pɛɛ Nléécɑɑsimɛ́ n céési yɛ pɛɛ Antiyɔɔsi-pɔ Uléécɑɑ icɑ́pinɛ-i welɛ. Pɛpɛɛ Pɑrinɑpɑsi nɛ Simeyɔɔ kɑpi yɛ kɔ n sée rɛ Uŋmɔ́hɔ nɛ Sirɛɛni ukɔ́ Lusiyuusi nɛ Mɑnɑyɛɛni nɛ Sɔɔli. Mɑnɑyɛɛni nɛ Kɑlilee uyɔɔpi Erooti pɛɛ kɛsẽ́ iwɑ̃́ li. ");
INSERT INTO soy_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Kɛyɑ́ɑ kɛnyinɛ kɑpi ɑnɔ́ɔ pɑɑsi pin Upíimɑ nɛ welu. Nfɑ́ɑsɔnɛ nn pi mɑɑ rɛ: Ani Pɑrinɑpɑsi nɛ Sɔɔli iyɑɑ lesɛ pikɛ́ pikɛi pɛ̃ kɑm pi ḿ pɑ wɑ. ");
INSERT INTO soy_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Kɑpi pinɔ́ɔpɑhɑɑ nɛ piwelɛ ḿ mɑsí, ɑpi ɑnípɛ pikɛcɑ́ɑ́ lɑ́ɑ ɑpí nɛ pi tum, ɑpi tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Nfɑ́ɑsɔnɛ nn Pɑrinɑpɑsi nɛ Sɔɔli tum, ɑpi Selesii-pɔ sĩ ɑpi kei kúninɔi loni ɑpí nɛ míni kɛpɑ́ɑ́pɑ́ɑ́ kɛtẽ kɑpi yɛ n sée rɛ Siipuru sĩ. ");
INSERT INTO soy_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Kɑpi Sɑlɑmini n tu ɑpi Pisuifi ɑyomɛyɑ́hɑɑlee-i Nléécɑɑsimɛ́ piyóó kɑ́pɑ́ɑ́. Yohɑni yɛ pɛɛ pikɛmɛɛ́ welɛ un pi lɛ́ni. ");
INSERT INTO soy_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Api míni kɛpɑ́ɑ́pɑ́ɑ́ kɛtẽ kɛ̃ kɔ́ɔ́nú ɑpi tɛnɛ ɑpí hɑ Pɑfoosi tulu. Kei kɑpí pɛɛ́ nɛ Usuifi unyinɛ kɑpi yɛ n sée rɛ Pɑɑri-Yeesu risɑ́nɛ. Uyɛ̃ nɛ mɛtɑrɛwɑi ukɔ́ nɛ ɑntepu nɔɔmɛ lɛ. ");
INSERT INTO soy_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Siipuru kɛtẽ uyɔɔpi Sɛrikiyuusi Pɔɔlusi kɛyɔ-i kuú pɛɛ́ we. Uyɛ̃ nɛ usɔhɔɔ píimɑ lɛ. Uu tíyɛsɛ ɑpi Pɑrinɑpɑsi nɛ Sɔɔli u séipɔ rɛ li ripɔ́ɔ u wɑ rɛ ukɛ́ Nléécɑɑsimɛ́ kṍ. ");
INSERT INTO soy_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Mɛtɑrɛwɑi ukɔ́ uyɛ̃ uu pi m púnɛisɛntɛ un nɑ́ɑ́si rɛ úyukɔɔ́ uyɛ̃ úu kɑpɛ nɛ Yeesu kɛfɑ tɛnɛ. Pi yɛ Mɛ́kirɛki nɛ urinyiri tuisɛ rɛ Elimɑɑsi, lɛlɛɛ rɛ mɛtɑrɛwɑi ukɔ́. ");
INSERT INTO soy_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Nfɑ́ɑsɔnɛ yɛ pɛɛ Sɔɔli kɑpi yɛ kɔ n sée rɛ Pɔɔli yipɑɑlɛnlɛ. Kei kuu pɛɛ Elimɑɑsi uyɛ̃ ńsɔnɛ riwii ");
INSERT INTO soy_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","uu u mɑɑ rɛ: Pɔ́ unɔ́ɔmɛ nɛ uyɑɑlukɛ nkó. Kuníri kɛpipi nkɛ́, pɔ́ɔ ḿpɑ́ lisɔnɛ líye n ŋmɛ́lu. Pɔ nɛ welɛ pɔn Upíimɑ simúŋɛ́ cirɛ-cirɛ hɑ́rɛsi, nɛ́ɛ yo? ");
INSERT INTO soy_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","A nkpéni kutu ricɔ ɑɑ kóm. Upíimɑ yɛ́ pɔ́ pi ɑɑ nyíini ɑɑ kɔ ntuŋɛ mɛtɛ́í pɑɑ siyɑ́ɑ sinyinɛ. Kei nní lɛ̃, kuŋmɑhɑ ɑku Elimɑɑsi hilɑ, uu yɛ toóri toóri un unyinɛ wɛ́ɛ́si yɛɛ yɛ́ u n tɔ́rɔi. ");
INSERT INTO soy_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Kɛ uyɔ́ɔpi uyɛ̃ uu lɛ̃ n yɛ̃́, uú nɛ Upíimɑ kɛfɑ tɛnɛ. Li we rɛ Upíimɑ kɛcɑ́ɑ́ icélɑɑ iyɛ̃ nɛ u lonnɛ ńsɔnɛ. ");
INSERT INTO soy_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pɔɔli nɛ upisencɔ ɑpi Pɑfoosi-i kúninɔi loni ɑpí nɛ Pɑmfilii kɛtẽ-pɔ Pɛriki kuyu sĩ. Yohɑni uu kei pi yɑ́ uu Yerusɑlɛm pɛlɛ. ");
INSERT INTO soy_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Pɔɔli nɛ Pɑrinɑpɑsi pɔ́ɔ pikɛtɛ́ kei yisi ɑpi sɔ́nɛ ɑpi Pisitii kɛtẽ-pɔ Antiyɔɔsi kuyu sĩ. Api kɛwéntɛyɑɑ tuŋɛ́ Pisuifi kuyomɛyɑ́hɑɑlee-i lompɔ ɑpí tonɛ. ");
INSERT INTO soy_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Unyinɛ uu isé ɑtɛlɛ́ nɛ ɑntepuyɛ ɑkɔ́ pisoi inipɛɛ-i kɛ́ɛ́ni. Kuu pikɛ́ɛ̃ ḿ mɑsí, kuyómɛyɑ́hɑɑlee piwɛ́ɛ́sɛ ɑpi Pɔɔli nɛ Pɑrinɑpɑsi kɛ́mɛɛ tum ɑpí hɑ pi mɑɑ rɛ: Pimɑ́rɛcɔ, nɔn nnyinɛ m mɑ́ nɔkɛ́ nɛ pisoi ikɑri rikpɑ́sɛ, nɔ́ fe ɑni nkpéni símisi. ");
INSERT INTO soy_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Kei kɛ Pɔɔli uu yisi uu kunípɛ síkɑ uu pisoi sɛ́ɛ́sɛ uu rɛ: Nɔ̃́ Isirɑyɛɛli pikɔ́ nɛ nɔ́ pitɔ́rɔɔ mpí nɔ́ɔ Uléécɑɑ n wuru, ɑni kutu ricɔ ɑni kóm! ");
INSERT INTO soy_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Isirɑyɛɛli Uleecɑɑ yɛ pɛɛ pirɔ́kpurɛ wɛ́ɛlɛ, uu tíyɛsɛ ɑpi kulúi wɑi, pɛɛ́ uyɛ-i kɑpí pɛɛ Esipiti kɛteni-i ilɑ́si n tṹ. Uu pɛɛ́ nɛ unnɑŋɛ kei pi yukusɛ. ");
INSERT INTO soy_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Uu kucɛsi kóimɑ-i pikɛcɑ́ɑ́ pɑí iŋmɛ̃ ɑfɛɛnɑ. ");
INSERT INTO soy_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Uu limɛmɑ́ɑ́ mpuri nsɛɛi Kɑnɑɑ kɛteni-i kópu uu nsitẽ cɑ́pinɛ uu upisoi pɑ rɛ pikɛ́ n te. ");
INSERT INTO soy_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ai lɛ̃ n we ɑí nɛ tulu iŋmɛ̃ pílɛ pílɛ mɛnɑ nɛ iŋmɛ̃ kuwóó kumúŋɛ́. Uu pɛɛ limɛmɑ́ɑ́ pikpéenwɑi pi hɛ, ɑi kpísi ɑí hɑ nɛ ɑntepu Sɑmuyɛɛli ituŋɛ tulu. ");
INSERT INTO soy_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Lɛ̃ mɛmɑ́ɑ́, ɑpi Uléécɑɑ pisɛ rɛ ukɛ́ uyɔ́ɔpi pi tĩ. Kei kuu pɛɛ Pɛnyɑmɛɛ kumɑrɛ ukɔ́, Kiisi uŋmɑ́nɛ Sɑuuli iyɔ́ɔpi tonsɛ iŋmɛ̃ ɑfɛɛnɑ. ");
INSERT INTO soy_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Kuu Sɑuuli iyɔ́ɔpi n lɑpilɛ, uu Yesee uŋmɑ́nɛ Tɑfiti i pɑ uu rɛ: Nɛ nkpéni Yesee uŋmɑnɛ Tɑfiti yɛɛ nɛ nɛ́ rinsɑ́ yɛ́nlɛ. U yɛɛ yɛ́ mɛnɛ́lɑ nnɛ́í wɑ. ");
INSERT INTO soy_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Tɑfiti kɛpirɛ̃ kɛsɛ kɛ Uléécɑɑ uu Isirɑyɛɛli pikɔ́ pɑ rɛ kɛkɛ́ pi yoriyɛ yɑrɛ kuú pɛɛ ḿ mɑɑ rɛ li yɛ́ wɑ. Kɛkɛɛ Yeesu. ");
INSERT INTO soy_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Yeesu ukɛ́ kɛlenɛ ń kɑm, Yohɑni yɛ pɛɛ riyóólɛ uu Isirɑyɛɛli pikɔ́ nnɛ́í símisi rɛ pikɛ́ piɑkópɛ kɛpirɛ ritɔ pikɛ́ míni wolɛ. ");
INSERT INTO soy_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Yohɑni ukɛ́ nɛ upikɛi kɛtɔ n tu, u mɑɑ rɛ: Nɔ músu rɛ nɛ́ɛ wóo? Ái nɛ́ɛ uyɛ̃ kɑni m mɛ̃́. Uyɛ̃ nɛ kɛpirɛ wemɛlɛ. Nɛ̃́ ɑ́m tu ricuruu rɛ kɛ́ ripɛ kɛ́ uɑnɛ́ɛ́ri kɛŋmɛpi fénnɛ. ");
INSERT INTO soy_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Pɔɔli uu kɔ kpɑ́ rɛ: Pimɑ́rɛcɔ, ntɔ́nɛ́í kɛ Uléécɑɑ uu nsímɛ́ mmú pɑ́lɛ̃ ukɛ́ nɛ rɔ́ yóriyɛ, nɔ̃́ Apirɑhɑm sipirɛ̃ nɛ nɔ́ pitɔ́rɔɔ mpí nɔ́ɔ nní Uléécɑɑ n wuru. ");
INSERT INTO soy_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Mɛsei kɛ Yerusɑlɛm pikɔ́ nɛ pipiyɔɔpi ɑpi Yeesu yɛ̀, ɑ́pi kɔ ɑntepuyɛ nsímɛ́ kɑpi ḿpɑ́ kɛwéntɛyɑɑ kɛ́ye n kɛ́ɛ́ni riyíkí kṍ. Amɑ́ kɑpi Yeesu ń kpu, lɛlɛɛ nsímɛ́ mmɛ̃ kɛ́mɛɛ ń we kɑpi lɛ̃ wɑ. ");
INSERT INTO soy_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ápi kɔ ńkɑ yɛ̃, mmɛ̃ nnyɑ kɑpi yɛ́ u ń kpu, ɑmɑ́ pi pɛɛ Pilɑti pisɛ rɛ ukɛ́ u kpu. ");
INSERT INTO soy_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Lɛ̃ kɑi Nléécɑɑsimɛ́ kɛ́mɛɛ Yeesu kɛcɑ́ɑ́ n wɔ́lɑɑlɛ̃ kɑpi lɛ̃ wɑ. Api pɛɛ limɛmɑ́ɑ́ kunɑpɛ́ɛ́kɔɔ́ kɛcɑ́ɑ́ u súisɛ ɑpi u kpísi ɑpi nhórɛ-i wɑi. ");
INSERT INTO soy_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Amɑ́ Uléécɑɑ uu pikpɔkpɔ kɛ́mɛɛ u yukusɛ. ");
INSERT INTO soy_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Pɛpɛɛ hɑ́i Kɑlilee-pɔ u n sɑ́rũ ɑpí nɛ Yerusɑlɛm sĩ kuu siyɑ́ɑ kulúi umɛcirɛ nyísɛ. Pɛpɛɛ kɔ nɛni nní upiseérɑkɔɔ́ Isirɑyɛɛli pikɔ́ inipɛɛ-i. ");
INSERT INTO soy_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Nsímɛ́ Kɛcirɛ mmú kɛ Uléécɑɑ uú pɛɛ yekei rɛ u yɛ́ pirɔ́kpurɛ pɑ. Mmɛ̃ kɑrí nɛ nɔ́ kɑ. ");
INSERT INTO soy_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Mmɛ̃ kuu nní nkpéni tɔ̃́ pipipirɛ̃ wɑ. Li we rɛ u Yeesu nkpɔ kɛ́mɛɛ yukusɛlɛ yɑrɛ kɑi Ipɑkɑrɛ Siyomɛ ritɛlɛ́ lírũ kɛ́mɛɛ n wɔ́lɑɑlɛ̃ tɛ: Pɔ́ɔ Kɛnɛ́pipi, nɛ́ɛ nɛni pɔ́ mɑ́ri. ");
INSERT INTO soy_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Uléécɑɑ yɛ pɛɛ mɛkɛɛ-mɛ mɑɑ rɛ u yɛ́ pikpɔkpɔ kɛ́mɛɛ u yukusɛ úu kɑpɛ nɛ píkɑi n fɔ́ni nnyɑ. Lɛ̃ kuu Tɑfiti mɑɑ rɛ: Nɛ́ lisɔnɛ kɛcirɛ lɛɛ ɑ́i n fɔ́nunɛ nɔ́ pɑ. Tinɔ́ɔ sɔnɛ kɑḿ pɛɛ Tɑfiti n yekei yɛ tɛ̃. Lisɔnɛ kɛcirɛ lɛɛ ɑ́i yɛ píkɑi n cɑɑi kɑḿ pɛɛ Tɑfiti m pɑnɛ kɑm nɔ́ pɑnɛ. ");
INSERT INTO soy_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Lɛ̃ nnyɑ kɛ Tɑfiti uu kɔ kɛlõ kɛcɔ mɑɑ rɛ: Áɑ yɛ́ ŋmurɛi upɔ́lɑlɑ ukɛ́ nhórɛ kɛ́mɛɛ fɔ́ni. ");
INSERT INTO soy_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Tɑfiti uyɛ̃ yɛ pɛɛ uisoi kɛ́mɛɛ Uléécɑɑ mɛlɑ wɑlɛ. Kuu n kpu, ɑpi upisɑɑyɑhɑ kɛ́mɛɛ u kulɛsi uu fɔ́nu. ");
INSERT INTO soy_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Amɑ́ uyɛ̃ kɛ Uléécɑɑ uu pikpɔkpɔ kɛ́mɛɛ n yukusɛ úu fɔni. ");
INSERT INTO soy_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Pimɑ́rɛcɔ, li tu rɛ ɑni ńsɔnɛ kõ tɛ uyɛɛ tíyɛsɛ kɑpí nɛ nɛni ɑkópɛ pisɑ́rɛi nsímɛ́ nɔ́ símisi. ");
INSERT INTO soy_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Uyɛɛ tíyɛsɛ kɛ úye uu yɛ un nɛ kɛfɑ u n tɛnɛ, Uléécɑɑ uu liute ɑkópɛ u sɑ́rɛi. Moisi isé íi fe ikɛ́ usoi ɑkópɛ sɑ́rɛi. ");
INSERT INTO soy_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Lɛ̃ nnyɑ, ɑni nɔ́mɛnɛ́círɛ tĩ, ɑ́ni kɑpɛ tíyɛ lɛ̃ kɛ ɑntepuyɛ ɑpi piɑtɛlɛ́-i n wɔ́i likɛ́ nɔ́ wɑ. Lɛlɛɛ rɛ: ");
INSERT INTO soy_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Nɔ́ kupɑkɑrɛcirɛ́ pikɔ́ mpí, ɑni kutu ricɔ ɑni kóm likɛ́ nɔ́ riyɔɔ, ɑni itóó nɛ mílɛsi. Nɔ́nnɛ́fɑ́ɑ mmú kɛ́mɛɛ kɑḿ lɑ kɛ́ mɛwɑi mɛnyinɛ wɑ kɛ unyinɛ uu yɛ́ un nɔ́ n símisi ɑ́ni yɛ́ pɑkɑrɛ. ");
INSERT INTO soy_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Kɛ Pɔɔli nɛ Pɑrinɑpɑsi ɑpi kuyómɛyɑ́hɑɑlee-i n léepɔ, ɑpi kɔ pi séi rɛ pikɛ́ kɛwéntɛyɑɑ kɛcɔ pɛɛpɔ pikɛ́ nsímɛ́ nsɛ mmɛ̃ pisímɛ́ pi rikpɑ́. ");
INSERT INTO soy_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Icɑ́pinɛ mɛmɑ́ɑ́, Pisuifi yíkíyiki kulúi nɛ pitɛ́ŋ́ tɛ́ŋ́ pɛɛ Pisuifi kɛyomɛ n yɑ́ɑ́si ɑpi yisi ɑpi Pɔɔli nɛ Pɑrinɑpɑsi tiki. Pɛ̃ ɑpi ikɑri pi hɛ rɛ ɑ́pi kɑpɛ tíyɛ unyinɛ ukɛ́ Uléécɑɑ kɛfɑ kuú nɛ pi n fénnɛ ncee kɛ́mɛɛ pi fóm. ");
INSERT INTO soy_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Kɑi kɛwéntɛyɑɑ kɛcɔ kɛ̃ n tu, li wɑ yɑrɛ Antiyɔɔsi kuyu pisoi nnɛ́í pɛɛ cɑ́pinɛ pikɛ́ Nléécɑɑsimɛ́ kṍ. ");
INSERT INTO soy_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Kɛ Pisuifi ɑpi riwúí tɛ̃ n yɛ̃́, pikɛfɑ ɑkɛ tóósi ɑpi pɛɛ lɛ̃ kɛ Pɔɔli uu n símisi n kɛsu pin kɔ u lɑ́misi. ");
INSERT INTO soy_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pɔɔli nɛ Pɑrinɑpɑsi ɑpi kɛ́yu kpɑ̃́iisɛ ɑpi pi símisi rɛ: Nɔ̃́ kɑí nɛ sɑ́ rɛ Nléécɑɑsimɛ́ nkɛ́ mɛfoí tu kɛlenɛ. Kɑni nní n n kɛ́su nɔn kɔ nɔ́mɛnɛ́círɛ nɛ nfɑ́ɑ tɛnɛcirɛ́ lómiisɛ nnyɑ, tɔ́ mɛsɛ nɛ mpuri sɑnɛ pikɔ́-mɛ̃ m pɛlɛ. ");
INSERT INTO soy_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Lɛ̃ kɛ Upíimɑ uu rɔ́ n forii rɛ tɔkɛ́ wɑ yɛ nní: Nɛ pɔ́ lésɛlɛ rɛ ɑ pɑnsɛ mɛtɛ́í ɑɑ isoipuri nnɛ́í n kpɑ̃́iilɛ̃, pinnɛ́í pikɛ́ píyulɑlɛ yɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Kɛ mpuri sɑnɛ pikɔ́ ɑpi ɑnɔ́ɔ nyɛ̃ n kṍ, ɑi pi lɑrisi ɑpi Upíimɑ nsímɛ́ pɑkɑrɛ. Pɛ̃ nnɛ́í kɛ Uléécɑɑ uú nɛ nfɑ́ɑ tɛnɛcirɛ́ n sée, ɑpí nɛ Yeesu kɛfɑ tɛnɛ. ");
INSERT INTO soy_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Upíimɑ nsímɛ́ yɛ pɛɛ kumúŋɛ́ kpɛ-i kɛtẽ kɛ̃ nnɛ́í kɛcɑ́ɑ́ kɔ́ɔ́núlɛnlɛ. ");
INSERT INTO soy_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Amɑ́ Pisuifi ɑpi pinɔ́si yukɔɔ́ pɛɛ Uléécɑɑ n yɑ́ɑ́si nɛ kuyu piwɛ́ɛ́sɛ tɑ́lɑɑnkɛɛ ɑpi yisi ɑpi Pɔɔli nɛ Pɑrinɑpɑsi piwéékusɛ kɑ́pɑ́ɑ́, ɑpi pikɛteni-i pi lɑkɑsɛ. ");
INSERT INTO soy_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Pɔɔli nɛ Pɑrinɑpɑsi ɑpi yisi ɑpí hɑ kuyu ripoo-pɔ pinnɑtɑɑi péi-péi ɑpi pikuwɛ́ɛ́-mɛ̃ yɑɑpɔ, ɑi wɑi rɛ piɑkópɛ ɑkɛ́ nɛ pi risɛ́ɛ́. Pɔɔli nɛ Pɑrinɑpɑsi ɑpi yɑ́ ɑpi Ikoniyɔm kuyu-mɛ̃ tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Nfɑ́ɑsɔnɛ nɛ mpɔ́ɔnɑrɛ pɔ́ɔn pɛɛ Yeesu pipirɛtiki pɛɛ Antiyɔɔsi-i ń we yipɑɑlɛ̃ ńsɔnɛ. ");
INSERT INTO soy_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pɔɔli nɛ Pɑrinɑpɑsi ɑpi kɔ Ikoniyɔm-pɔ Pisuifi kuyomɛyɑ́hɑɑlee loni, ɑpi kɛ́yu kpɑ̃́iisɛ ɑpi símisi Pisuifi mɛyɑ̃ nɛ Pikirɛki mɛyɑ̃ ɑpi ŋmurɛi ɑpi Yeesu nɛ kɛfɑ tɛnɛ. ");
INSERT INTO soy_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Amɑ́ Pisuifi picɔ pɛɛ ɑ́pi n ŋmurɛi pikɛ́ nɛ kɛfɑ u tɛnɛ ɑpi mpuri sɑnɛ pikɔ́ tɑ́lɑɑnkɛɛ rɛ pikɛ́ Pɔɔli nɛ Pɑrinɑpɑsi kɛcɑ́ɑ́ simúŋɛ́ kópɛ wɑ. ");
INSERT INTO soy_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ḿpɑ́ nɛ lɛ̃, pɛ̃ nɛ Ikoniyɔm-i tónɛlɛ ɑi siyɑ́ɑ wɑi. Api itisi nɛ n símisi pin nɛ Upíimɑ tɑ́lɛ̃. Upíimɑ yɛ pɛɛ ńnɑŋɛ pi hɛlɛ pin nɛ mɛwɑisɑŋɑ nɛ mɛpíimɑ wɑpisi, ɑi yɛ nyísɛ rɛ mɛsei kɛ Upíimɑ uu pisoi ípɛɛlɛ́ɛ nyísɛ. ");
INSERT INTO soy_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Kuyu pikɔ́ ɑpi kei nní kénɛ mɛtɛ́. Picɔ rɛ Pisuifi nkɔ́ mɛɛ wɑ, picɔ rɛ pitumɛ nkɔ́ mɛɛ wɑ. ");
INSERT INTO soy_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Pisuifi nɛ mpuri sɑnɛ pikɔ́ nɛ kuyu piwɛ́ɛ́sɛ ɑpi pimɛcirɛ cɑ́pinɛ pikɛ́ Pɔɔli nɛ Pɑrinɑpɑsi íwɛ wɑ pikɛ́ ɑpɑrɛ pi tɔ́ɔ́kɛɛ pikɛ́ pi kṍ. ");
INSERT INTO soy_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Kɑi lɛ̃ Pɔɔli nɛ Pɑrinɑpɑsi kutu-i n lompɔ, ɑpi músu tíḿḿ, ɑpi wuru ɑpí hɑ Likɑyonii kɛtẽ-pɔ Lisitiri nɛ Tɛripu ɑyu-i nɛ ɑkɛkúrí pékesi ");
INSERT INTO soy_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ɑpi kei Nsímɛ́ Kɛcirɛ n yóólɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Lisitiri-pɔ kɛ utisi unyinɛ uú pɛɛ we. Hɑ́i kɑpí nɛ u m mɑ́ri úu píkɑi sɔ́nɛlɛ̃. U kɛ́kɑnkɑ́lɑ́kɑ́ lɛ, uu yɛ pɛɛ́ n tũ. ");
INSERT INTO soy_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Uu pɛɛ Pɔɔli nsímɛ́ kutu n cɔlɛ̃. Kei kɛ Pɔɔli uu u nyɑ́nɛi ńsɔnɛ uu yɛ́nu rɛ nfɑtɛnɛ yɛ u tulɑɑlɛnlɛ un yɛ́ fe uu pélu. ");
INSERT INTO soy_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Pɔɔli uu rinɔ́ɔ cɑ́sɛ uu u mɑɑ rɛ: A yisi ɑɑ ɑpɔ́nɑ kɛcɑ́ɑ́ kɛcírɛ nyɛrɛ. Utisi uu yisi uu cuuni uu nsẽ́ kɑ́pɑ́ɑ́. ");
INSERT INTO soy_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Kɛ pisoi ɑpi Pɔɔli mɛwɑi mɛ̃ n yɛ̃́, ɑpi kei pikɔ́ mɛyu, Mɛ́likɑyoniyɛɛ nɛ pupɛi rɛ: Piléé yɛ mɛsoi sɔ́nɛmɛ ɑpí nɛ rɔ́ lɛɛri. ");
INSERT INTO soy_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Api rɛ Pɑrinɑpɑsi yɛɛ Seusi. Kɑi nní Pɔɔli yɛɛ pɛɛ símisi nnyɑ ɑpi rɛ uyɛɛ Hɛrimɛɛsi. ");
INSERT INTO soy_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Piléé pɛ̃ kɑpi yɛ n sée rɛ Seusi kɛyɔ yɛ pɛɛ welɛ kuyu ritimɛ-pɔ. Uléékɔɔ́ yɛɛ kei pi n nyɔ́ɔnsɛ uu ɑnɑ́ɑlɑ mɛfɛlɛ torɑɑnkɛɛ uu tɔ́rikɛɛ uú nɛ kɛ́yɔ kɛ̃ tinɔnɔɔ-i hɑpɔ, u nɛ pisoi pɛɛ n cɑ́pinɛlɛ̃ ɑpí n nɑ́ɑ́si pikɛ́ Pɑrinɑpɑsi nɛ Pɔɔli nyɔ́ɔnsɛ. ");
INSERT INTO soy_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Kɛ Pɑrinɑpɑsi nɛ Pɔɔli ɑpi lɛ̃ n kṍ, ɑpi pisitukɑnkɑ cɛ́ɛ́rii ɑi nyísɛ rɛ ɑ́i nɛ pi risɑ́, ɑpi pɛɛ riwúí tɛ̃ kɛcɔpɛ sɔɔpɔ pin cɛ́si rɛ: ");
INSERT INTO soy_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Nɔ́ pisoi mpí, yo kɑni lɛ̃ wɑi? Tɔ̃́ nɛ kɔ nɔ́mɛnɛ́cɔ sisoipipi lɛ. Nsímɛ́ kɛcirɛ kɑrí nɛ nɔ́ kɑ tɔn nɔ́ tee rɛ ɑ́ni lisɛ́rɛ́-sɛrɛ́ nní nkɔ́ riyɑ́. Líwookɔɔ́ yɛ ni. Ani nɔ́mɛnɛ́círɛ Uléécɑɑ yɛɛ nfɑ́ɑ n te pɑ. Uyɛɛ kɛtẽ nɛ kɛyómɛ nɛ mínimɑɑ nɛ likɛmɛɛ likɔ́ wɑ. ");
INSERT INTO soy_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","U mɛkɛɛ-mɛ pirɔ́kpurɛ kɛ́mɛɛ-pɔ pisoi nnɛ́í riyɑ́lɛ rɛ pikɛ́ pimɛpɔɔlɑ n wɑi, ");
INSERT INTO soy_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","ḿpɑ́ nɛ lɛ̃, mɛsɛ́rɛ kuu pɛɛ mɛwɑi sɔnɛ nɔ́ wɑi rɛ ɑni nɛ kei u n nyɑ́ni. Uu yɛ kɛyómɛcɑɑ-pɔ ikónɛ nɔ́ hɛri, liituŋɛ in kɔ n tu, uu ilukɛ nɔ́ hɛ. Uu yɛ kɔ lilukɛ-lukɛ nɔ́ hɛ uu kɔ tíyɛsɛ ɑni mpɔ́ɔnɑrɛ yɛnu. ");
INSERT INTO soy_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ḿpɑ́ kɛ Pɔɔli nɛ Pɑrinɑpɑsi ɑpi lɛ̃ ḿ mɑ, li nɛ pi pɑpisilɛ ɑpi kɛlenɛ fe ɑpi inyɔ́ɔnsɛ iyɛ̃ yulu. ");
INSERT INTO soy_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Pisuifi pinyinɛ ɑpi Antiyɔɔsi yɛɛ Pisitii-pɔ ń we nɛ Ikoniyɔm-i yisi ɑpi sĩ́, pi nɛ pisoi kulúi ɑpí hɑ kómɛinɛ. Api Pɔɔli ɑpɑrɛ tɔ́ɔ́kɛɛ rɛ pikɛ́ u kpu. Api pɛɛ limɛmɑ́ɑ́ u pulu ɑpí nɛ kuyu ilúkɛ́ léépɔ, pin músu rɛ u kpulɛ. ");
INSERT INTO soy_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Amɑ́ kɛ Yeesu pipirɛtiki ɑpi ukɛkúrí ń cɑ́pinɛpɔ, uu yisi uu kuyu sĩ. Kɑi kóso n weesi, u nɛ Pɑrinɑpɑsi ɑpi Tɛripu kuyu tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pɔɔli nɛ Pɑrinɑpɑsi ɑpi Tɛripu kuyu-i Nsímɛ́ Kɛcirɛ yóó, pisoi mɛyɑ̃ ɑpi Yeesu tiki. Api pɛɛ limɛmɑ́ɑ́ yisi ɑpi Lisitiri nɛ Ikoniyɔm nɛ Antiyɔɔsi yɛɛ Pisitii-pɔ ń we pɛlɛ. ");
INSERT INTO soy_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Kɑpi kei n tuipɔ, ɑpi Yeesu pipirɛtiki pɛɛ kei ń we ikɑri kpɑ́sɛ rɛ pikɛ́ n ŋmɔ́ɔ́púlɛ̃. Api yɛ kɔ pi mɑɑ rɛ pi yɛ́ íwɛ píimɑ li pikɛ́ kɛlenɛ Uléécɑɑ iyɔɔpi kɛ́mɛɛ lompɔ. ");
INSERT INTO soy_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Pɔɔli nɛ Pɑrinɑpɑsi ɑpi ḿpɑ́ Uléécɑɑ icɑ́pinɛ íye-i piwɛ́ɛ́sɛ tonsɛntɛ. Pi nɛ pɛ̃ ɑpi ɑnɔ́ɔ pɑɑsi ɑpi kɛyómɛ yɑ́ɑ́si ɑpi pɛɛ limɛmɑ́ɑ́ pi kpísi ɑpi Upíimɑ kɑpí nɛ kɛfɑ n tɛnɛ ɑnipɛ-i wɑi. ");
INSERT INTO soy_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Kɛ Pɔɔli nɛ Pɑrinɑpɑsi ɑpi kei Pisitii kɛtẽ kɛ-i n yisi, ɑpi Pɑmfilii kɛkɔ́-mɛ̃ loni. ");
INSERT INTO soy_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Api Pɛriki-pɔ Nléécɑɑsimɛ́ pisoi símisi, ɑpi kei yisi ɑpi Atɑlii tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Kei kɑpi pɛɛ kúninɔi lõ ɑpí nɛ Sirii kɛtẽ-pɔ Antiyɔɔsi sĩ. Kei kɑpi pɛɛ Uléécɑɑ ɑnipɛ-i pi wɑ ɑpi u welu rɛ ukɛ́ ípɛɛlɛ́ɛ pi nyísɛ pikɛ́ fe pikɛ́ pipikɛi wɑ yɑrɛ kɑpi nní n wɑ. ");
INSERT INTO soy_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Kɑpi Antiyɔɔsi kei n tuipɔ, ɑpi Uléécɑɑ icɑ́pinɛ pikɔ́ cɑ́pinɛ, ɑpi lɛ̃ nnɛ́í kɛ Uléécɑɑ uú nɛ pɛ̃ tintiki uu wɑi pi kɛɛni, nɛ lɛ̃ kuu n tíyɛsɛ mpuri sɑnɛ pikɔ́ pɔ́ɔ kɔ Yeesu nɛ kɛfɑ tɛnɛ. ");
INSERT INTO soy_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Pɔɔli nɛ Pɑrinɑpɑsi ɑpi Yeesu pipirɛtiki kɛ́mɛɛ tonɛ siyɑ́ɑ kulúi. ");
INSERT INTO soy_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Kirisi pikɔ́ pinyinɛ ɑpi kɛyɑ́ɑ kɛnyinɛ Yutee kɛtẽ-pɔ yisi ɑpi Antiyɔɔsi sĩ, ɑpí hɑ Kirisi pikɔ́ picɔ mɑɑ rɛ: Nɔnsɑ́ n kérii yɑrɛ kɛ Moisi isé ii m pisɛ, ɑ́ni yɛ́ píyulɑlɛ yɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pɔɔli nɛ Pɑrinɑpɑsi ɑpi pi kɛsu, íkɛŋɛnɛ píimɑ inyinɛ ii likɛcɑ́ɑ́ pikɛcɔpɛ leeri. Api símisi ɑí tonɛ rɛ Pɔɔli nɛ Pɑrinɑpɑsi nɛ pinyinɛ picɔ pikɛ́ Yerusɑlɛm hɑ, pi nɛ pitumɛ nɛ piwɛ́ɛ́sɛ pikɛ́ hɑ kɛsẽ́ nsímɛ́ mmɛ̃ tipɑí. ");
INSERT INTO soy_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Uléécɑɑ icɑ́pinɛ pikɔ́ ɑpi pikɛcɑ́ɑ́ pɑí ɑpí nɛ ncée tiki. Api Fenisii nɛ Sɑmɑrii sitẽ-mɛ̃ tiki, ɑpi lɛ̃ kɛ mpuri sɑnɛ pikɔ́ ɑpi Upíimɑ rintíki pisoi símisi. Nsímɛ́ mmɛ̃ nn Kirisi pikɔ́ nnɛ́í lɑrisi hɑ́i. ");
INSERT INTO soy_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Kɑpi Yerusɑlɛm n tuipɔ, Uléécɑɑ icɑ́pinɛ pikɔ́ nɛ pipiwɛ́ɛ́sɛ nɛ pitumɛ pɛɛ pi yɔsí. Api Yerusɑlɛm pikɔ́ pɛ̃ símisi lɛ̃ nnɛ́í kɛ Uléécɑɑ uú nɛ pi rintíki uú nɛ wɑi. ");
INSERT INTO soy_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Amɑ́ Pifɑrisi pinyinɛ pɛɛ Yeesu nɛ kɛfɑ n tɛnɛ ɑpi pɛɛ yisi ɑpi rɛ: Li pisɛ rɛ mpuri sɑnɛ pikɔ́ pɛɛ Yeesu nɛ kɛfɑ n tɛnɛ pikɛ́ kérii tílɑsi, pikɛ́ kɔ Moisi isé ritiki. ");
INSERT INTO soy_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Pitumɛ nɛ piwɛ́ɛ́sɛ ɑpi cɑ́pinɛ rɛ pikɛ́ nsímɛ́ mmɛ̃ tipɑí. ");
INSERT INTO soy_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Kɑpi nsímɛ́ m pɑ́sɑinɛ ɑi nɑ́ŋɑi mɛmɑ́ɑ́ kɛ Piyɛɛ uu pɛɛ rinɔ́ɔ yɔsí, uu rɛ: Pimɑ́rɛcɔ, nɔ́rinɛ́cúruu yɛ yɛnlɛ rɛ ɑ́i nɛni-mɛ kɛ Uléécɑɑ uu nɔ́kɛnɛ́cɔpɛ nkɛ́-i nɛ́ wɛ́ɛ rɛ kɛ́ mpuri sɑnɛ pikɔ́ Nsímɛ́ Kɛcirɛ riyóó pikɛ́ nnɛ́nɔ́ɔ-i n kõ, pikɛ́ kɔ nɛ kɛfɑ n tɛnɛ. ");
INSERT INTO soy_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Uléécɑɑ yɛɛ nyu lɛlɛɛ pisoi sifɑ-i ń we. Uyɛɛ kɔ pɛ̃ Unfɑɑsɔnɛ hɛ yɑrɛ kuu tɔ̃́ n hɛ mɛcɔ. U lɛ̃ nyísɛlɛ rɛ pɛ̃ nɛ kɔ pɑnsɛlɛ upisoi. ");
INSERT INTO soy_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Úu tɔ́ nɛ pɛ̃ kɛcɔpɛ kóólɛnɛ. Lɛ̃ nnyɑ kuu pinfɑtɛnɛ nnyɑ piɑkiŋ hɛɛrɛ ɑɑ funi. ");
INSERT INTO soy_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Yo nnyɑ kɑni nkpéni Uléécɑɑ peikɛɛ nɔkɛ́ yɛ̃́, nɔn ncɔni kɛ úkɑ úu hɑ́i pirɔ́sɑ́ɑ-i-mɛ nɛ tɔ́-i n fe ukɛ́ ń cɔ̃ Yeesu pipirɛtiki nyikisɛlɛ̃? ");
INSERT INTO soy_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Amɑ́ Upíimɑ Yeesu ipɛɛlɛ́ɛ nnyɑ kɑrí nɛ kɛfɑ tɛnɛ rɛ tɔ̃́ nɛ kɔ pimɛcɔ píyulɑlɛ yɛnlɛ. ");
INSERT INTO soy_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Pɛpɛɛ n cɑ́pinɛlɛ̃ nnɛ́í ɑpi sɛ́ɛ́ keu, ɑpi pɛɛ Pɑrinɑpɑsi nɛ Pɔɔli kutu n cɔlɛ̃ pin mɛwɑisɑŋɑ nɛ mɛwɑi píimɑ kɛ Uléécɑɑ uú nɛ pi rintíki uu mpuri sɑnɛ pikɔ́ kɛcɔpɛ wɑpisi kɛɛnkɛɛ. ");
INSERT INTO soy_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Kɑpi pisímɛ́ ḿ mɑsí, Yɑkupu uu rinɔ́ɔ yɔ́su uu rɛ: Ani kutu nɛ́ ricɔ, pimɑ́rɛcɔ. ");
INSERT INTO soy_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simɔɔ yɛ rɔ́ símisilɛ lɛ̃ kɛ Uléécɑɑ ricuruu uu hɑ́i mɛkɛɛ-mɛ mpuri sɑnɛ pikɔ́ kɛcɔpɛ umpuri kuu n te n wɛ́ɛ. ");
INSERT INTO soy_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Antepuyɛ ɑnɔɔ kɑi lɛ̃ titiki yɑrɛ kɑi n wɔ́lɑɑlɛ̃. Li wɔlɑɑlɛ̃ tɛ: ");
INSERT INTO soy_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Lɛ̃ mɛmɑ́ɑ́, nɛ Tɑfiti kɛyɔ kɛɛ n fori yukusɛnɛ, ɑm ncɑɑi nnɛ́í nyɔ́ɔnsɛ. Nɛ́ pimɔ́mɛ kɛ pɛsɛ. ");
INSERT INTO soy_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Kei kɛ pisoi tɔrɔɔ ɑpi yɛ́ pɛɛ nɛ̃́ Upíimɑ wɛ́ɛ́si. Lɛlɛɛ isoipuri nnɛ́í kɑm n sée rɛ ikɛ́ pɑnsɛ inɛ́kɔ́. Nɛ̃́ Upíimɑ rinɔɔ yɛ tɛ̃, ");
INSERT INTO soy_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","nɛ́ɛ tíyɛsɛ kɛ pisoi ɑpi hɑ́i mɛkɛɛ-mɛ mɛwɑi mɛ̃ ceri. ");
INSERT INTO soy_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Lɛ̃ nnyɑ kɛ nɛ̃́ Yɑkupu, ɑm músu rɛ ɑ́ri ncée mɑ́ tɔkɛ́ mpuri sɑnɛ pikɔ́ pɛɛ pimɛcirɛ Uléécɑɑ ḿ pɑ Pisuifi isé rinyikisɛ. ");
INSERT INTO soy_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Amɑ́ tɔkɛ́ pi wɔipɔ ɑri pi símisi rɛ ɑ́pi kɑpɛ yɛ inyɔ́ɔnsɛsɑrɛ li. I tɔ̃́ kɛ́mɛɛ ikpɛ́rinkpɛkɔɔ́ lɛ. Pikɛ́ pimɛcirɛ tĩ, ɑpi yɛ sɔ́ɔnnɛ yɑrɛ kɛ isé ii m pisɛ. Ápi kɑpɛ yɛ isɛɛ kɑ́pi rimpɑ́ li, ɑ́pi kɑpɛ yɛ kɔ mɛ́nyɛ li. ");
INSERT INTO soy_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Kɑí pɛɛ mɛkɛɛ ń we, pisoi yɛɛ pɛɛ ḿpɑ́ kuyu kúye-i Moisi isé riyóólɛ, ɑpi yɛ kɔ ḿpɑ́ kɛwéntɛyɑɑ kɛ́ye kɛtúŋɛ́ kuyómɛyɑ́hɑɑlee-i i kɛɛni. ");
INSERT INTO soy_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Pitumɛ nɛ piwɛ́ɛ́sɛ nɛ Uléécɑɑ icɑ́pinɛ pikɔ́ nnɛ́í ɑpi yɛ́nu rɛ li nyɑm tɛ pikɛ́ pikɛcɔpɛ pisoi lesɛ pikɛ́ Pɔɔli nɛ Pɑrinɑpɑsi ritikisɛ pikɛ́ nɛ Antiyɔɔsi pi tũ. Kei kɑpi pɛɛ Yuuti kɑpi yɛ kɔ n sée rɛ Pɑrisɑpɑsi nɛ Silɑsi lesɛ. Pipicɔ yɛ pɛɛ pi wɑisɛlɛnlɛ ńsɔnɛ. ");
INSERT INTO soy_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Piɑnipɛ-i kɑpi rítɛlɛ́ tɛ̃ wɑ. Pi rikɛmɛɛ wɔ́i rɛ: Tɔ̃́ nɔ́pinɛ́mɑ́rɛcɔ, pitumɛ nɛ piwɛ́ɛ́sɛ, tɔ nɔ̃́ pimɑ́rɛcɔ, nɔ́ɔ yɛ ɑ́ni nní Pisuifi nɔn Antiyɔɔsi-pɔ nɛ Sirii nɛ Silisii kɛteni-i we yɑ́ɑsi ńsɔnɛ. ");
INSERT INTO soy_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Tɔ kõ tɛ pisoi pinyinɛ yɛ kɛrɔ́mɛɛ nté yisipɔ ɑpi nɔ́ lɛɛpɔ, ɑpi pinsímɛ́ kɛ́mɛɛ nɔ́ɑnɛ́pɔ́ɔ cɑɑisɛ ɑpi kɔ nɔ́sinɛ́wuu tɔisɛ. Ani kõ tɛ ɑ́i tɔ́ɔ pi tumpɔ. ");
INSERT INTO soy_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Lɛ̃ nnyɑ kɑri kómɛinɛ rɛ li nyɑm tɛ tɔkɛ́ pisoi lesɛ tɔkɛ́ pirɔ́mɑ́rɛcɔ lɑlɑ Pɑrinɑpɑsi nɛ Pɔɔli ritikisɛ tɔkɛ́ nɛ nɔ́kɛnɛ́mɛɛ pi tumpɔ. ");
INSERT INTO soy_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Pɑrinɑpɑsi nɛ Pɔɔli ɑ́pi nkpɔ iwɑmɛ wɑ Upíimɑ Yeesu Kirisi pikɛi kɑpi n wɑi nnyɑ. ");
INSERT INTO soy_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Tɔ Yuuti nɛ Silɑsi nɔ́kɛnɛ́mɛɛ tumpɔ rɛ pikɛ́ nɛ pinnɔɔ nsímɛ́ mmɛ̃ kɑri n wɔ́i nɔ́ símisi. ");
INSERT INTO soy_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Li we rɛ tɔ́ nɛ Nfɑ́ɑsɔnɛ yɛ yɛ̃ tɛ ɑ́i nyɑḿ tɛ tɔkɛ́ ncɔni féé nnyinɛ mɛ́woo nɔ́ rinyikisɛ ɑ́i kɔ lɛ̃ kɑi pisɛ. ");
INSERT INTO soy_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Lɛlɛɛ nɛ n sɑ́ rɛ tɔkɛ́ nɔ́ pisɛ yɛ nní: Áni kɑpɛ yɛ inyɔ́ɔnsɛsɑrɛ nɛ́ɛ mɛ́nyɛ nɛ́ɛ isɑrɛ kɑ́pi rimpɑ́ pikɛ́ mɛ́nyɛ lesɛ li. Ani kɔ nɔ́mɛnɛ́círɛ tĩ, ɑni yɛ sɔ́ɔnnɛ yɑrɛ kɛ isé ii m pisɛ. Tɔ mɛmɑ́rɛcɔ nɛ kɛfɑ kɛsɛ nɔ́ yɑ́ɑsi! ");
INSERT INTO soy_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Pɔɔli nɛ Pɑrinɑpɑsi nɛ Yuuti nɛ Silɑsi ɑpi yisi ɑpi Antiyɔɔsi tɔ́mpɔ. Kɑpi n hɑ́pɔ, ɑpi kei piyómɛyɑ́hɑɑ nnɛ́í cɑ́pinɛ ɑpi rítɛlɛ́ tɛ̃ pi pɑ. ");
INSERT INTO soy_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Kɑpi pinnɛ́í kɛyu-i ri n kɛ́ɛ̃, ɑi ḿpɑ́ úye ikɑri wɑisɛ ɑi kɔ piɑkiŋ niŋukusɛ. ");
INSERT INTO soy_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yuuti nɛ Silɑsi ricuruu yɛ pɛɛ ɑntepuyɛ lɛ. Api nsímɛ́ nsímɛ́ Antiyɔɔsi pikɔ́ símɑɑnkɛɛ ɑpí nɛ ikɑri pi kpɑ́sɛ rɛ pikɛ́ nɛ nfɑtɛnɛ n ŋmɔ́ɔ́púlɛ. ");
INSERT INTO soy_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Api kei siyɑ́ɑ sinyinɛ wɑi. Pimɑ́rɛcɔ ɑpi pɛɛ limɛmɑ́ɑ́ pi yɑ́ ɑpi pɛpɛɛ pi n tumpɔ kɛ́mɛɛ pɛɛsɛ nɛ piripɔɔ. ");
INSERT INTO soy_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Amɑ́ Silɑsi pɔ́ɔ rɛ u yɛ́ kei tonɛ. ");
INSERT INTO soy_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pɔɔli nɛ Pɑrinɑpɑsi pɔ́ɔ hɑ Antiyɔɔsi-i tonɛ, pi nɛ picɔ pinyinɛ pin pisoi céési pin kɔ Upíimɑ nsímɛ́ kɛcirɛ yóólɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Kɑpi Antiyɔɔsi-i n tónɛ ɑi siyɑ́ɑ wɑi, Pɔɔli uu Pɑrinɑpɑsi mɑɑ rɛ pikɛ́ silõ sɛ̃ nnɛ́í kɑpi Upíimɑ nsímɛ́ nɛ rinkɔ́ɔ́nú pɛɛsɛ pikɛ́ hɑ yɛ̃ tɛ íye kɛ Yeesu pikɔ́ ɑpi kei we. ");
INSERT INTO soy_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Pɑrinɑpɑsi uú n lɑ ukɛ́ nɛ Yohɑni kɑpi rinyíri n hɛ rɛ Mɑriki ripɛ́nɛ. ");
INSERT INTO soy_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Amɑ́ Pɔɔli pɔ́ɔ yúlu rɛ ɑ́pi kɑpɛ kɔ nkpéni pikpíkɛ́ u rikpɑ́ ukɛ́ pi ritiki, li we rɛ u pɛɛ mɛfoí hɑ́i Pɑmfilii-pɔ pi ŋmɛriyɛlɛ úu pi ritiki pikɛ́ hɑ nɛ pipikɛi kɛtɔ tu. ");
INSERT INTO soy_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ai wɑi rɛ li Pɔɔli nɛ Pɑrinɑpɑsi símɑɑsɛ, hɑ́i ɑpí nɛ likɛcɑ́ɑ́ túúnnɛ. Pɑrinɑpɑsi uu Mɑriki kpísi ɑpi kúninɔi loni ɑpi Siipuru tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pɔɔli pɔ́ɔ Silɑsi kuséncɔ wɛ́ɛ, Yeesu pikɔ́ ɑpí nɛ pi welu rɛ Uléécɑɑ ukɛ́ pi sɑrumpɔ. Api pɛɛ ncée kpísi ɑpi tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Api Sirii nɛ Silisii sitẽ kuwɛ́ɛ́-mɛ̃ tiki, pin Uléécɑɑ icɑ́pinɛ ŋmɔ́ɔ́púsɛlɛ̃ tɛ ikɛ́ Uléécɑɑ ncee kɛ́mɛɛ pɑpisi. ");
INSERT INTO soy_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pɔɔli uu yisi uu Tɛripu sĩ, uu kɔ Lisitiri tulu. Yeesu upirɛtiki unyinɛ yɛ pɛɛ kei welɛ ɑpi u séi rɛ Timotee. Úni yɛ Usuifi lɛ un kɔ Kirisi nɛ kɛfɑ tɛnɛlɛ̃. Amɑ́ usɑ́ɑ pɔ̃́ nɛ Ukirɛki lɛ. ");
INSERT INTO soy_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Yeesu pikɔ́ pɛɛ Lisitiri nɛ Ikoniyɔm-pɔ ń we yɛ pinsímɛ́ kɛ́mɛɛ u pɑkɑrɛntɛlɛ hɑ́i. ");
INSERT INTO soy_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Ai Pɔɔli ripɔ́ɔ wɑi rɛ ukɛ́ kuséncɔ u wɛ́ɛ. Uu u kpísi uu Pisuifi pɛɛ kei-pɔ kɑpi n sĩ́ ń we nnyɑ u ké. Pinnɛ́í yɛ pɛɛ nyulɛ rɛ usɑ́ɑ yɛ Ukirɛki lɛ. ");
INSERT INTO soy_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Kɑpi n tɔ́su, ɑyu kɛ́mɛɛ kɑpi ritiki. Api yɛ lɛ̃ nɛ lɛ̃ kɛ pitumɛ nɛ piwɛ́ɛ́sɛ ɑpi Yerusɑlɛm-pɔ n símisi ɑí tonɛ Kirisi pikɔ́ pɛɛ kei ń we tɛ́ŋ́sɛ. Api kɔ pi mɑɑ rɛ pikɛ́ yɛ likɛcɑ́ɑ́ sɔ́nɛ. ");
INSERT INTO soy_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Uléécɑɑ icɑ́pinɛ pikɔ́ ɑpi pɛɛ́ nɛ nfɑtɛnɛ nɛ kɛ́yu n sĩ pin kɔ ḿpɑ́ kɛweesi kɛ́ye kulúi kpɑ́lɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Nfɑ́ɑsɔnɛ ńn Pɔɔli nɛ upicɔ ncée hɛ rɛ pikɛ́ Asii sitẽ kɛcɑ́ɑ́ Nléécɑɑsimɛ́ riyóó. Lɛ̃ nnyɑ kɑpi Firisii nɛ Kɑlɑsii sitẽ-mɛ̃ titɛ́ŋ́. ");
INSERT INTO soy_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Kɑpi nɛ Miisii kɛtẽ tińkɔ, ɑpi Pitinii kɛkɔ́-mɛ̃ pihɑ́pɛ peeni. Amɑ́ Yeesu Nfɑɑsɔnɛ ńn lincee pi hɛ. ");
INSERT INTO soy_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Api mɛsɛ Miisii kei tikipɔ ɑpí nɛ Turowɑɑsi sĩ. Kei yɛ ɑ́ninɔi kɛnyɛrɛ lɛ. ");
INSERT INTO soy_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Kei kɑi kɛsinɛ Pɔɔli mɛ́yɛnɛ mɛnyinɛ nyísɛ: Mɑsetuwɑɑni ukɔ́ unyinɛ kuu yɛ̃́ un nyɛnu un u welu rɛ ukɛ́ risuúlu ukɛ́ pikuyu-mɛ̃ titikipɔ ukɛ́ pi yoriyɛ. ");
INSERT INTO soy_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pɔɔli mɛyɛnɛ mɛ̃ mɛmɑ́ɑ́, ɑri pɛɛ́ n lɑ tɔkɛ́ Mɑsetuwɑɑni kɛtẽ hɑ. Li we rɛ tɔ picére mɑsilɛ rɛ Uléécɑɑ yɛ rɔ́ sée rɛ tɔkɛ́ hɑ Nsímɛ́ Kɛcirɛ kei pikɔ́ símisi. ");
INSERT INTO soy_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ari Turowɑɑsi-i kúninɔi loni ɑrí nɛ míni kɛpɑ́ɑ́pɑ́ɑ́ kɛtẽ kɑpi yɛ n sée rɛ Sɑmotirɑsi-mɛ̃ n sɑirilɛ̃. Ai kóso weesi, ɑri Neyɑpolisi-mɛ̃ tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ari kei yisi ɑri Filipu tɔ́mpɔ. Mɑsetuwɑɑni kɛtẽ kuyu foí yɛ kpɛ̃ kɛlõ kɛ-i. Rɔm pikɔ́ n-yɔɔpinɑŋɛ kɛtẽ yɛ kɛ. Tɔ kei siyɑ́ɑ sinyinɛ wɑlɛ. ");
INSERT INTO soy_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ari kɛwéntɛyɑɑ tuŋɛ́ kuyu iyɑɑ leepɔ ɑri nkói-mɛ̃ sĩ, kei kɑri m músu yɑrɛ Pisuifi yɛɛ cɑ́pinɛ ɑpi kɛyómɛ yɑ́ɑ́si. Kɑri n hɑ́pɔ ɑri kei pinɔ́si lɛɛpɔ pin cɑ́pinɛlɛ̃, ɑrí tonɛ ɑri Nléécɑɑsimɛ́ pi símisi. ");
INSERT INTO soy_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Pi yɛ pinɔ́si pɛ̃ usɛ sée rɛ Liiti. U pɛɛ Uléécɑɑ likɔ́ lɑlɛ. Tiyɑtiiri kuyu kuu léeri. Asɑ́ŋɑ́ɑ́ wɛɛ́ nyɑii kɛcirɛ kuu yɑ́i. Kuu kutu rɔ́ n cɔ́lɛ̃, Upíimɑ uu mɛsɔhɔ u hɛ ukɛ́ nɛ Pɔɔli nsímɛ́ kṍ. ");
INSERT INTO soy_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ari u nɛ ukɛyɔ pikɔ́ nnɛ́í míni wolɛ. Uu pɛɛ kusɑ́nɛ rɔ́ séi uu rɔ́ mɑɑ rɛ: Nɔn mɛsei n yɛ̃ tɛ nɛ Upíimɑ nɛ kɛfɑ tɛnɛ, ɑni kɛnɛ́yɔ lommɛ ɑní tonɛ! Uú nɛ kɛ́yu rɔ́ mɑhɑni, ɑri mɛsɛ ŋmurɛi. ");
INSERT INTO soy_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Kɛyɑ́ɑ kɛnyinɛ kɑri kɛyómɛyɑ́hɑɑ-i sĩ́ ɑrí nɛ ukpére kɛikɔ́ unyinɛ sɑ́nɛ. U ɑníri héesilɛ uu yɛ nɛ lɛlɛɛ kóso-pɔ n wɑinɛ yɛnu. Lipikɛi pɛ̃ pin upiyɔte siwóó wɑi ńsɔnɛ. ");
INSERT INTO soy_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Kei kuu yisi uu tɔ́ nɛ Pɔɔli n tikilɛ̃ un cɑ́ɑ́i rɛ: Pisoi mpí yɛ Uléécɑɑ yɛɛ ḿpɑ́ yo kɛcɑ́ɑ́ ń tṹ pikɛikɔ́ lɛ. Ncée mɛɛ yɛ n yóriyɛ kɑpi nní nɔ́ nyísɛ! ");
INSERT INTO soy_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Uu lɛ̃ n wɑi ɑí nɛ siyɑ́ɑ kɔ́ɔ́nú. Ai Pɔɔli pelu uu ukpére uyɛ̃-mɛ̃ pɑnsɛpɔ, uu kuníri kpɛɛ u n tíkilɛ̃ mɑɑ rɛ: Nɛ Yeesu Kirisi rinyiri kɛ́mɛɛ, nɛ rinɔ́ɔ pɔ́ hɛ rɛ ɑ ukpére nkó kɛ́mɛɛ le. Aku mɛsɛ nɛ mɛsɛ lelu. ");
INSERT INTO soy_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Kɛ ukpére kɛikɔ́ uyɛ̃ piyɔte ɑpi n yɛ̃́ tɛ pikulɑɑ yɛ lɛ̃ tɛnɛlɛ, ɑpi Pɔɔli nɛ Silɑsi kɛ́yɑɑ́lɑ-i tini ɑpí nɛ kuyu piwɛ́ɛ́sɛ lɛɛpɔ. ");
INSERT INTO soy_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Apí nɛ Rɔm pikɔ́ pitúhɑɑnɛ-i pi tɔ́mpɔ ɑpí hɑ rɛ: Pisuifi mpí pɛɛ ńcɔkɔi nɛ kurɔ́yu lommɛ. ");
INSERT INTO soy_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Pi welɛ pin inyɛ́kii inyinɛ rɔ́ céési. Ncée ńn kɔ we rɛ tɔ̃́ Rɔm pikɔ́ tɔkɛ́ i ŋmurɛi nɛ́ɛ tɔkɛ́ i ritiki. ");
INSERT INTO soy_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Tiwúí tɛ̃ ɑrí nɛ Pɔɔli nɛ Silɑsi wɔ́ɔ́si ńsɔnɛ. Pitúhɑɑnɛ ɑpi rinɔ́ɔ hɛ rɛ pikɛ́ Pɔɔli nɛ Silɑsi ilũ mɑhɑ̃ pikɛ́ isɛ́í pi súúkɛɛ. ");
INSERT INTO soy_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Kɑpi lɛ̃ pi n fɑ́pii, ɑpi kukpɑniilee pi tɑni ɑpi kuumɛ́rɛ́ rinɔ́ɔ hɛ rɛ ukɛ́ pi m mɛ̃́ ńsɔnɛ. ");
INSERT INTO soy_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Kɑpi lɛ̃ uyɛ̃ ḿ mɑ, uyɛ̃ uu kɛ́mɛɛ-mɛmpɔ kɛleepi kɛnyinɛ-i pi wɑi uu piɑnɑ nɛ ɑnɑkulɛ torɑɑnkɛɛ. ");
INSERT INTO soy_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Kɑi kɛsinɛcɔ kumúŋɛ́ n tu, Pɔɔli nɛ Silɑsi ɑpi yisi ɑpi kɛyómɛ n yɑ́ɑsi pin yom pin Uléécɑɑ pɑkɑrɛntɛ, pikpɑniikɔ́ picɔ pin kutu pi cɔlɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Kei nní, kɛtẽ ɑkɛ piyéŋɑɑ loni, ɑi kukpɑniilee rikui tiŋɑ-tiŋɑ. Ai ihɑ́nɑɑ nnɛ́í mɛsɛ nɛ mɛsɛ hɑ́nnɛntɛ ɑi pikpɑniikɔ́ ɑkpɑnii nnɛ́í fénnɛntɛ. ");
INSERT INTO soy_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Kɛ umɛ́rɛ́ uú hɑ n yisi uu yɛ́nu rɛ kukpɑniilee ihɑ́nɑɑ nnɛ́í yɛ hɑ́nnɛntɛlɛnlɛ, uu ritɛ́hɛ kpeéumɛ ukɛ́ umɛcirɛ kpu, un músu rɛ pikpɑniikɔ́ yɛ ŋmɛ́hɛrɛɛlɛ ɑpi wúrunkɛɛ. ");
INSERT INTO soy_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pɔɔli uu pɛɛ unnɑŋɛ nnɛ́í nɛ cɑ́ɑ́i rɛ: Kɑpɛ líkɑ mɛpɔ́círɛ wɑ, tɔ́ɔ mpí nté ntɔ́nɛ́í. ");
INSERT INTO soy_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Kei kɛ umɛ́rɛ́ uu pɛɛ rɛ pikɛ́ nnɑ u ritɛɛ́lɛ. Kɑpi u rińtɛɛ́lɛ, uú nɛ kɛleepi kɛmɛɛ-pɔ n tɔ́su, uú nɛ iwɑmɛ n tɛrii uú hɑ nɛ Pɔɔli nɛ Silɑsi kɛyu-i wúlɑ. ");
INSERT INTO soy_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Uu pi lesɛpɔ uu pi pisɛ rɛ: Yo kɑi pisɛ rɛ kɛ́ wɑ kɛ́ nɛ píyulɑlɛ yɛ̃, pinɛ́sɑ́ɑ? ");
INSERT INTO soy_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Api u pɛsɛ rɛ: A Upíimɑ Yeesu nɛ kɛfɑ tɛnɛ, pɔ́ píyulɑlɛ yɛ̃, nɔ́ nɛ kɛpɔ́yɔ pikɔ́. ");
INSERT INTO soy_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Api pɛɛ u nɛ ukɛyɔ pikɔ́ nnɛ́í Upíimɑ nsímɛ́ yóó. ");
INSERT INTO soy_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Umɛ́rɛ́ uyɛ̃ uu kɛsinɛ kɛ̃ cirɛ pi kpísi uú hɑ piitoi pi hɛɛrɛ. Lɛ̃ mɛmɑ́ɑ́, Pɔɔli nɛ Silɑsi ɑpi u nɛ ukɛyɔ pikɔ́ nnɛ́í míni wolɛ. ");
INSERT INTO soy_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Uú nɛ Pɔɔli nɛ Silɑsi ukɛyɔ sĩ uú hɑ kusɑ́nɛ pi wɑi. U nɛ ukɛyɔ pikɔ́ nnɛ́í ɑkiŋ ɑɑ níŋɛsi rɛ pi nɛ Uléécɑɑ kɛfɑ tɛnɛ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Kɑi n weesi, Rɔm pikɔ́ pitúhɑɑnɛ ɑpi pikɑwe tum tɛ pikɛ́ hɑ umɛ́rɛ́ mɑɑ rɛ ukɛ́ Pɔɔli nɛ Silɑsi riyɑ́pɔ. ");
INSERT INTO soy_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Uyɛ̃ uu yisi uú hɑ Pɔɔli símisi rɛ Rɔm pikɔ́ pitúhɑɑnɛ yɛ mɑɑ rɛ ukɛ́ ɑkpɑnii kɛ́mɛɛ pi lesɛ. Lɛ̃ nnyɑ, pikɛ́ nkpéni léépɔ pikɛ́ nkíŋniŋɛ-i ń we. ");
INSERT INTO soy_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Kei kɛ Pɔɔli uu pikɑwe pɛ̃ mɑɑ rɛ: Kutúhɑɑnɛcirɛ́ kɑpi riwúí kɛ́mɛɛ nɛ isɛ́í rɔ́ kɑ́ii ɑpí hɑ rɔ́ hɑ́nɛsi, tɔn kɔ nɛ pimɛcɔ Rɔm pikɔ́. Pi nkpéni lɑlɛ pikɛ́ kɔ mɛyɑɑ tɔ́ riyɑ́pɔ, nɛ́ɛ íye? Ái yɛ́ lɛ̃ wɑ! Pikɛ́ piricuruu kɑm pikɛ́ rɔ́ lésɛpɔ. ");
INSERT INTO soy_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Pikɑwe pɛ̃ ɑpí nɛ ɑnɔ́ɔ nyɛ̃ pɛlɛ ɑpí hɑ Rɔm pikɔ́ pitúhɑɑnɛ símisi. Kɑpi n kṍ tɛ Pɔɔli nɛ Silɑsi yɛ Rɔm kɛtẽ pikɔ́ lɛ, iwɑmɛ ii pi loni. ");
INSERT INTO soy_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Api pɛɛ piricuruu sĩ, ɑpí hɑ rɛ pɛ̃ kɑí nɛ kpu. Api kukpɑniilee-i Pɔɔli nɛ Silɑsi lesɛpɔ ɑpi pi suúlusɛ rɛ pikɛ́ kuyu-i le. ");
INSERT INTO soy_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Kɛ Pɔɔli nɛ Silɑsi ɑpi kukpɑniilee kpɛ-i n léepɔ, Liiti kɛyɔ kɑpí hɑ kɛlenɛ. Kɑpi kei Yeesu pikɔ́ n yɛ̃́, ɑpi kɔ ikɑri pɛ̃ kpɑ́sɛ ɑpi pɛɛ yisi ɑpi ncée kpísi ɑpi tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Kɑpi Liiti kɛyɔ-i n yisi, ɑpi Amfipoliisi nɛ Apolonii cɔpu ɑpí nɛ Tɛsɑloniki tulu. Pisuifi yɛ kei kuyómɛyɑ́hɑɑlee mɑ́lɛ. ");
INSERT INTO soy_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pɔɔli uu kei hɑpɔ yɑrɛ kuu yɛ n wɑ, u nɛ pɛpɛɛ kei ń we pin yɔ́i. Uu siwéntɛyɑɑ sitɑɑni nɔŋ́sɛnɛ ");
INSERT INTO soy_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","uú nɛ Nléécɑɑsimɛ́ kɛ́mɛɛ pi céési uu kɔ pi nyísɛ rɛ uyɛ̃ kɛ Uléécɑɑ uu n wɛ́ɛ yɛ íwɛ píimɑ mɛlukɛ mɑ́lɛ, ukɛ́ pɛɛ kɔ pikpɔkpɔ kɛ́mɛɛ yisi. Uu kɔ kpɑ́ rɛ: Yeesu kɑm nɔ́ n tee yɛɛ nní Kirisi. ");
INSERT INTO soy_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Pɛpɛɛ kutu u n cɔ́lɛ̃ kɛ́mɛɛ, pinyinɛ ɑpí nɛ nsímɛ́ mmɛ̃ kɛfɑ tɛnɛ, ɑpi Pɔɔli nɛ Silɑsi tiki. Ai kɔ nɛ Pikirɛki mɛyɑ̃ pɛɛ Uléécɑɑ n yɑ́ɑ́si pɛ́nɛ nɛ pɛɛ́ nɛ pinɔ́si yukɔɔ́ kulúi. ");
INSERT INTO soy_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Kei kɛ Pisuifi kɛfɑ ɑkɛ tóosi ɑpí hɑ siwɑiyulɛ sinyinɛ kɔ́ɔ́i ɑpí nɛ kuyu n lémɑɑlɛ̃. Api kɔ yisi ɑpi Yɑsɔɔ kɛyɔ-i Pɔɔli nɛ Silɑsi piwɛ́lɑɑ sĩ, pin músu rɛ pin pi n tĩ, pikɛ́ hɑ nɛ riwúí kɛ́mɛɛ pi túhɑɑnɛ. ");
INSERT INTO soy_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Kɑpi pi m pɑɑ, ɑpi pɛɛ Yɑsɔɔ nɛ Yeesu pikɔ́ picɔ cɔ́pii ɑpí nɛ kuyu pitúhɑɑnɛ lɛɛpɔ pin cɑ́ɑ́i rɛ: Pisoi mpí pɛɛ kɛtẽ nnɛ́í cɔ́kɔi. Pi kɔ kɛrɔ́mɛɛ nté tuimɛlɛ. ");
INSERT INTO soy_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Yɑsɔɔ uu pi yɔ́su pin ukɛyɔ-i we! Ápi Rɔm uyɔɔpi isé wɑisɛlɛ̃. Pi pɔ́lɔ́lɛ̃ tɛ unyinɛ ucɔ yɛ we, ɑpi yɛ u séi rɛ Yeesu. Tɛ uyɛɛ uyɔ́ɔpi wɛ́ɛ́sɛ. ");
INSERT INTO soy_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Anɔ́ɔ nyɛ̃ ɑɑ riwúí tɛ̃ nɛ kuyu piwɛ́ɛ́sɛ cɔ́ŋ mɛyíkíyiki. ");
INSERT INTO soy_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Api Yɑsɔɔ nɛ upicɔ riwómɛ ké ɑpi hɛ́ɛ́lɛ ɑpi kɛlenɛ pi yɑ́. ");
INSERT INTO soy_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Kɑi kɛsinɛ n wɑ, Yeesu pikɔ́ ɑpi Pɔɔli nɛ Silɑsi Peeree-mɛ̃ tɔ́ŋsɛ. Kɛ pɛ̃ ɑpi Peeree-i n tuipɔ, ɑpí nɛ Pisuifi kuyomɛyɑ́hɑɑlee n sɑirilɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Pisuifi pɛɛ kei ń we isoi yɛ nyɑmlɛ ɑi tɔ́su Tɛsɑloniki pikɔ́ ikɔ́. Api kɛfɑ kɛsɛ nɛ Nléécɑɑsimɛ́ yɔ́su, ɑpi yɛ ḿpɑ́ kɛyɑ́ɑ kɛ́ye Uléécɑɑ ritɛlɛ́ kɛ́ɛ́ni pikɛ́ yɛ̃́ tɛ mmɛ̃ kɑpi nní pi n símisi yɛ mɛsei lɛ̃ɛ. ");
INSERT INTO soy_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Pimɛyɑ̃ pɛɛ Yeesu nɛ kɛfɑ tɛnɛ, ɑí nɛ Pikirɛki pɛ́nɛ, pinɔ́si yukɔɔ́ nɛ pitisi kulúi. ");
INSERT INTO soy_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Amɑ́ kɛ Pisuifi pɛɛ Tɛsɑloniki-pɔ ń we ɑpi n kṍ tɛ Pɔɔli yɛ kɔ Peeree-pɔ Nléécɑɑsimɛ́ yóólɛ̃, ɑpi yisi ɑpi sĩ́ ɑpí hɑ pisoi tɑ́lɑɑnkɛɛ ɑpi Pɔɔli kɑ́pɑ́ɑ́. ");
INSERT INTO soy_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Kei kɛ Yeesu pikɔ́ ɑpi Pɔɔli mínimɑɑ kuwɛ́ɛ́-mɛ̃ tɔ́ŋsɛ, Silɑsi nɛ Timotee pɔ́ɔ kei tonɛ. ");
INSERT INTO soy_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Pɛpɛɛ Pɔɔli n sɑ́rũ yɛ nɛ Atɛɛni u tulɛ ɑpi kɛlenɛ pɛɛsɛ. Pɔɔli uu pi pɑ́ɑ́i rɛ pikɛ́ hɑ Silɑsi nɛ Timotee símisi rɛ pikɛ́ mɛkɛɛ u lɛɛpɔ. ");
INSERT INTO soy_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Kɛ Pɔɔli uu Atɛɛni-i ń we un Silɑsi nɛ Timotee mɛ̃́, uu yɛ́nu rɛ piléé ncɔpuri yɛ kuyu yipɑɑlɛnlɛ. Uripɔɔ ɑri mɛyíkíyiki cɑɑi. ");
INSERT INTO soy_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Lɛ̃ nnyɑ, u nɛ Pisuifi nɛ pɛpɛɛ Uléécɑɑ n wuru ɑpi yɛ pɛɛ kuyómɛyɑ́hɑɑlee-i ń yɔ́i. Ḿpɑ́ kɛyɑ́ɑ kɛ́ye kuu yɛ un píye kɛ́yɑɑ́lɑ-i n lɛɛpɔ, u nɛ pɛ̃ ɑpi likɛcɑ́ɑ́ n yɔ́i. ");
INSERT INTO soy_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Mɛfinɛ simúŋɛ́ sinyinɛ pikɔ́ kɑpi yɛ sée rɛ Epikuriyɛ nɛ Sitoyisiyɛ. Pɔɔli nɛ simúŋɛ́ sɛ̃ pikpeẽ yɛɛ kɔ yɔ́ɔlɛ. Api yɛ pɛɛ rɛ: Uwɔ́ɔcɔni nkó yɛ mpíí rɛ íye nɛɛ́? Picɔ ɑpi rɛ: Li nkpɑ́ni yɑrɛ piléé sɑnɛ pinyinɛ nsímɛ́ kuu símisi. Mɛsei, Yeesu Nsímɛ́ Kɛcirɛ kɛ Pɔɔli uú pɛɛ yóólɛ̃ un kɔ yóólɛ̃ tɛ pikpɔkpɔ yɛ́ kɑm ɑpi yisi. ");
INSERT INTO soy_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Kei kɑpi pɛɛ u kpísi ɑpí nɛ kɛcɑ́pinɛ kɛ̃ kɑpi yɛ n sée rɛ Areyopɑɑsi sĩ ɑpi rɛ: A icélɑɑ fɑlɛ iyɛ̃ kɑɑ́ nɛ ń kɑ rɔ́ símisi tɔkɛ́ kṍ nkɛ̃́! ");
INSERT INTO soy_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Mɛsɛ́rɛ kɑɑ nsímɛ́ cerémpɔɔnɛ nnyinɛ rɔ́ símisi. Tɔ nɛni lɑlɛ tɔkɛ́ likɛmɛɛ ripéré tɔkɛ́ ńsɔnɛ yɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Mɛyíkíyiki kɛ Atɛɛni pikɔ́ nnɛ́í nɛ pisɑ́nɛ pɛɛ kuyu-i ń we ɑpi yɛ ḿpɑ́ kɛweesi kɛ́ye n tũ pin nfɑ́lɛ mɛɛ ń kɑ símisi nɛ́ɛ pin kutu n cɔlɛ̃. Ápi lɛ̃ mɛmɑ́ɑ́ likɛikɛi líkɑ licɔ mɑ́. ");
INSERT INTO soy_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pɔɔli uu yisi uu pikɛyu-i nyɛrɛ uu rɛ: Nɛ yɛ̃ tɛ nɔ̃́ Atɛɛni pikɔ́, nɔ mɛyíkíyiki piléényɔ́ɔnsɛ lɑlɛ hɑ́i. ");
INSERT INTO soy_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Nɛ nɔ́kunɛ́yu-i nyɛ́rɛilɛ ɑm nɔ́sinɛ́nyɔ́ɔnsɛ yɛ́nti. Kei ricuruu kɑḿ nɛ kɛnyɔ́ɔnsɛ kɛnyinɛ-i yɛ̃́ lin wɔlɑɑlɛ̃ tɛ: Uléécɑɑ unyinɛ kɑ́ri n nyu. Uléécɑɑ uyɛ̃ kɑni nní n yɑ́ɑ́si ɑ́ni kɔ pɛɛ u nyu kɑḿ lɑ kɛ́ nɔ́ céreisɛ. ");
INSERT INTO soy_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Uléécɑɑ uyɛɛ kɛtẽ nɛ kɛyómɛ nɛ kɛkɛmɛɛ likɔ́ wɑ. Uyɛɛ Upíimɑ kɛtẽ nɛ kɛyómɛcɑɑ-pɔ. Úu ɑwosoo kɛ pisoi ɑpi n wɑ kɛ́mɛɛ sói. ");
INSERT INTO soy_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Líkɑ mpuri ɑ́i u pɑ́rílɛ̃ kɛsoipipi kɛkɛ́ nɛ u m pɑsii un le yɑrɛ linyinɛ yɛ u cɔ́ŋlɛ̃. Uyɛɛ yɛ ḿpɑ́ úye nfɑ́ɑ nɛ ḿpɑ́ yo nnɛ́í lɛɛ kɛtẽ kɛcɑ́ɑ́ ń we hɛ. ");
INSERT INTO soy_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Usoi usɛ kuu mɛfoí wɑ, uú nɛ u tiki uú nɛ pisoi nnɛ́í wɑi rɛ pikɛ́ kɛtẽ nnɛ́í kɛcɑ́ɑ́ finɛ. Uu ituŋɛ pi kériinɛ uu kɔ kɛtẽ kɑpi yɛ́ n finɛ pi hɔɔnɛ. ");
INSERT INTO soy_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","U lɛ̃ wɑlɛ rɛ pisoi pikɛ́ fe pikɛ́ u wɛ́ɛ́si, ḿpɑ́ pin n cɑriinkɛɛ, in n lɑ pi yɛ́ hɑ nɛ u yɛ̃. Amɑ́ mɛyíkíyiki mmɛ́, Uléécɑɑ úu tɔ́ úkɑ nɛ kɛtɑɑ we. ");
INSERT INTO soy_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Uyɛɛ yɛ nfɑ́ɑ rɔ́ hɛ, uyɛɛ kɔ tíyɛsɛ kɑri ḿpɑ́ yo wɑi tɔn kɔ we. Lɛ̃ kɛ nɔ́pinɛ́yómɛni pinyinɛ ɑpí mɑɑ rɛ: Tɔ̃́ nɛ kɔ Uléécɑɑ sipipi lɛ. ");
INSERT INTO soy_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Kɑri nní usipipi nnyɑ, ɑ́ri yɛ́ fe tɔkɛ́ musí rɛ u we yɑrɛ wurɑ nɛ́ɛ nwóóweni nɛ́ɛ ripɑrɛ kɛ kɛsoipipi ɑkɛ́ nɛ kɛmɛsɔhɔ nɛ kɛkɛmúŋɛ́ ń sɛrí rɛ likɛ́ n nyɑḿ. ");
INSERT INTO soy_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Pisoi yɛ pɛɛ kuŋmɑhɑ-i welɛ pin nɛ lɛ̃ nnɛ́í wɑi. Uléécɑɑ úu kuŋmɑhɑ kumúŋɛ́ kpɛ̃ kpísi ukɛ́ nɛ linyinɛ wɑ. Amɑ́ nkpéni kuu sisoipipi nnɛ́í séi rɛ sin yei ń we, sikɛ́ mɛfinɛ consɛ. ");
INSERT INTO soy_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Li we rɛ u kɛyɑ́ɑ kɛ̃ kuu pisoi nnɛ́í nɛ ɑsei n túhɑɑnɛnɛ piyekei mɑsilɛ, uu kɔ uyɛɛ itúhɑɑnɛ ń tonɛnɛ piwɛ́ɛ mɑ́su. Pikpɔkpɔ kɛ́mɛɛ kuu liute yukusɛ uú nɛ ḿpɑ́ úye nyísɛ rɛ uyɛ̃ kuu itúhɑɑnɛ tĩ. ");
INSERT INTO soy_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Kɑpi n kṍ Pɔɔli un pikpɔkpɔ kɛ́mɛɛ piyisɛ nsímɛ́ símisi, picɔ ɑpi u sɛ́nnyi, picɔ ɑpi rɛ: Mɛcɔ mɛcɔ kɑri yɛ́ hɑ mpɔ́símɛ́ mmɛ̃ kutu ricɔ. ");
INSERT INTO soy_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Pɔɔli uu pɛɛ pi yɑ́ uu tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Ḿpɑ́ nɛ lɛ̃, picɔ yɛ nɛ u konlɛ ɑpi ŋmurɛi ɑpí nɛ kɛfɑ tɛnɛ: Pɛpɛɛ nní Areyopɑɑsi kɛcɑ́pinɛ uwɛ́ɛ́sɛ usɛ kɑpi yɛ n sée rɛ Teniisi nɛ unɔ́si unyinɛ kɑpi yɛ n sée rɛ Tɑmɑriisi nɛ picɔ picɔ. ");
INSERT INTO soy_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Pɔɔli uu limɛmɑ́ɑ́ Atɛɛni-i yisi uu Korɛnti sĩ. ");
INSERT INTO soy_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Kei kuu Usuifi unyinɛ kɑpi yɛ n sée rɛ Akilɑsi nɛ risɑ́nɛ. Pɔnti kɛteni-i kɑpi u mɑri. Itɑlii kɛtẽ kuú pɛɛ lɛ̃ leeri nɛ uunɔsi Pirisili rɛ uyɔ́ɔpi wɛ́ɛ́sɛ Kulooti yɛ rinɔ́ɔ hɛ rɛ Pisuifi nnɛ́í pikɛ́ Rɔm kɛteni-i le nnyɑ. Pɔɔli uu yisi uu pi lɛɛpɔ. ");
INSERT INTO soy_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Pi pɛɛ kɛsẽ́ pikónɛfukɛi lɛ. Kɑpi nní pikɛi pisɛ n wɑi nnyɑ, uu pikɛmɛɛ́ tonɛ ɑpi pɛɛ kɛsẽ́ n kɛisi. ");
INSERT INTO soy_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ḿpɑ́ kɛwéntɛyɑɑ kɛtúŋɛ́ kɛ́ye kɛ Pɔɔli uu yɛ Pisuifi kuyomɛyɑ́hɑɑlee-i nɛ Pisuifi nɛ Pikirɛki n tũ, un nɑ́ɑ́si pikɛ́ kṍ pikɛ́ unkɔ́ ŋmurɛi. ");
INSERT INTO soy_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Kɛ Silɑsi nɛ Timotee ɑpi Mɑsetuwɑɑni kɛtẽ-pɔ n yisimɛ ɑpi Korɛnti-i Pɔɔli lɛɛri kuu pɛɛ mɛyíkíyiki Nsímɛ́ Kɛcirɛ piyóó nɛ kutu ricɔ, un Pisuifi nyísɛlɛ̃ tɛ Yeesu yɛɛ usoi uyɛ̃ kɛ Uléécɑɑ uu n wɛ́ɛ. ");
INSERT INTO soy_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Kɛ Pisuifi ɑpí nɛ u n kɛ́ŋɛnɛ pin kɔ u lɑ́misi nnyɑ, uu uilũ kuu n tɑnɑɑlɛ̃ nkoŋo pikuwɛ́ɛ́-mɛ̃ péipɔ uu pi mɑɑ rɛ nɔ̃́ kɑí nɛ tɛnɛnɛ. Nɔn m pɔ, nɔ́ɔ nɔ́mɛnɛ́círɛ fóm, ɑ́i nɛ́ɛ linyinɛ wɑ. Mpuri sɑnɛ pikɔ́-mɛ̃ kɑm nkpéni nní lɛ̃ tɔ́su. ");
INSERT INTO soy_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Kuu pikɛkúrí kei n yisi, uú nɛ utisi unyinɛ kɑpi yɛ n sée rɛ Tituusi Yusituusi kɛyɔ n tɔ́su. Tituusi yɛ Uléécɑɑ pɑkɑrɛlɛnlɛ, ukɛyɔ kɛn kɔ Pisuifi kuyomɛyɑ́hɑɑlee kɛkúrí we. ");
INSERT INTO soy_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kirisipuusi yɛ pɛɛ kuyómɛyɑ́hɑɑlee uwɛ́ɛ́sɛ lɛ. U nɛ ukɛyɔ pikɔ́ nnɛ́í ɑpi Upíimɑ nɛ kɛfɑ tɛnɛ. Korɛnti pikɔ́ mɛyɑ̃ pɛɛ Pɔɔli nsímɛ́ n kṍ pɔ́ɔ kɔ Upíimɑ nɛ kɛfɑ tɛnɛ. Pɔɔli uu míni pi wolɛ. ");
INSERT INTO soy_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Pɔɔli uu kɛsinɛ kɛnyinɛ kɛlɑ́rɛ́-i yɛ́nu Upíimɑ un nɛ u símisi rɛ: Iwɑmɛ íi kɑpɛ pɔ́ wɑ. A nsímɛ́ nɛ riŋmɔ́ɔ́pú. Kɑpɛ risɛ́ɛ́! ");
INSERT INTO soy_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Nɛ kɛpɔ́kúrí welɛ. Úkɑ úu fenɛ ukɛ́ pɔ́ ricɔ́ŋ, li we rɛ pinɛ́soi yɛ kuyu kpɛ-i kulúi welɛ. ");
INSERT INTO soy_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Lɛ̃ nnyɑ kɛ Pɔɔli uu kei kuŋmɛ̃ kusɛ nɛ kuwɛ́lɛ́ tónɛ uu pisoi Nléécɑɑsimɛ́ céési. ");
INSERT INTO soy_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Kumúŋɛ́ kpɛ-i kɛ Rɔm ukɔ́ Kɑliyɔɔ uú pɛɛ Akɑyii kɛteni-i iyɔ́ɔpi n tṹ kɛ Pisuifi ɑpi rinɔ́ɔ risɛ wɑ, ɑpi yisi ɑpi Pɔɔli kɛcɑ́ɑ́ nyɛrɛ, ɑpi u tini ɑpí nɛ pitúhɑɑnɛ sĩ. ");
INSERT INTO soy_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Apí hɑ Kɑliyɔɔ mɑɑ rɛ: Utisi nkó yɛɛ nɑ́ɑ́si rɛ pisoi pikɛ́ unkɔ́ kṍ pikɛ́ yɛ mɛyɑ́hɑɑ féé mɛnyinɛ mɛɛ ɑ́mɛ isé n tíkilɛ̃ Uléécɑɑ yɑ́ɑ́si. ");
INSERT INTO soy_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pɔɔli uu rɛ ukɛ́ rinɔ́ɔ yɔsí, ɑí nɛ sɑ́ Kɑliyɔɔ ricuruu uu pi pɛsɛ rɛ: Nɔ̃́ Pisuifi, in pɛɛ rɛ piyɑɑ nɛ́ɛ mɛwɑi kópɛ mɛnyinɛ kuu wɑ kɑní nɛ nɛ́ u kɑ, nɛ́ pɛɛ níŋɛsi ɑm kutu nɔ́ cɔ yɑrɛ kɑi m pisɛ. ");
INSERT INTO soy_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Amɑ́ in ɑnɔ́ɔlempi nɛ́ɛ ɑnyíri nɛ́ɛ nɔ́rinɛ́cúruu isé kɛcɑ́ɑ́ ikɛŋɛnɛ, nɔ́ɔ yɛ́ mmɛ̃ ceri ɑni wɑi. Ám lɑ kɛ́ lɛ̃ yɛ mpuri itúhɑɑnɛ li! ");
INSERT INTO soy_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Kei kuu pɛɛ kɛtúhɑɑnɛ kɛ-i pi lɑkɑsɛ. ");
INSERT INTO soy_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Pinnɛ́í ɑpi pɛɛ kuyómɛyɑ́hɑɑlee uwɛ́ɛ́sɛ Sɔsitɛɛni tini ɑpi kɛtúhɑɑnɛ kɛ-i ipépi u loni. Ḿpɑ́ nɛ lɛ̃, ɑ́i nkpɑ́ni uyɔ́ɔpi Kɑliyɔɔ mɛ́kɑ wɑ. ");
INSERT INTO soy_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pɔɔli uu kɔ Korɛnti-i Yeesu pikɔ́ kɛ́mɛɛ kɛtónɛ kpɑ́ ɑi siyɑ́ɑ kɔ́ɔ́nú. Uu limɛmɑ́ɑ́ pi yɑ́ u nɛ Pirisili nɛ Akilɑsi ɑpi kúninɔi loni pin nɛ Sirii kɛtẽ tɔ́su. Pikɛ́ kɛlenɛ n tɔ́mpɔ, Pɔɔli yɛ pɛɛ Sɛnikirɛɛsi-pɔ uriyu rikoósilɛ, rinɔ́ɔ kuu Uléécɑɑ n yekei kɛcɑ́ɑ́ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Api Efɛɛsi tuipɔ, Pɔɔli uu kei upisencɔ yɑ́. Uu Pisuifi kuyomɛyɑ́hɑɑlee loni u nɛ Pisuifi ɑpi kei n yɔ́i. ");
INSERT INTO soy_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Pɛ̃ ɑpi u pisɛ rɛ ukɛ́ siyɑ́ɑ sinyinɛ pikɛkúrí tonɛ. ");
INSERT INTO soy_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Amɑ́ úu ŋmurɛi, uu pɛɛ pi pɛsɛ rɛ: Li pisɛ rɛ kɛ́ hɑ ɑnyɑ̃́ nnyɛ́ nyɛɛ nní ń wemɛ Yerusɑlɛm-pɔ li. Uléécɑɑ un n lɑ, nɛ́ nɔ́kɛnɛ́mɛɛ pɛɛmɛ. Uu pɛɛ kúninɔi Efɛɛsi-i loni uu tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Kuú hɑ Sesɑree-pɔ ń suí, Yerusɑlɛm kuú nɛ risɑiri uú hɑ piyómɛyɑ́hɑɑ yɑ́ɑ́si uu pɛɛ kɛlenɛ Antiyɔɔsi sĩ. ");
INSERT INTO soy_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Uu kei tonɛ ɑi siyɑ́ɑ wɑi, uu pɛɛ Kɑlɑsii nɛ Firisii sitẽ-mɛ̃ tiki un Yeesu pikɔ́ nnɛ́í pɛɛ kei ń we ikɑri kpɑ́sɛlɛ̃ tɛ pikɛ́ nɛ nfɑtɛnɛ n ŋmɔ́ɔ́púlɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Usuifi unyinɛ yɛɛ we ɑpi yɛ u séi rɛ Apoloosi. Alɛkisɑntiri-pɔ kɑpi u mɑri. U nsímɛ́ nyulɛ ńsɔnɛ un kɔ Nléécɑɑsimɛ́ ɑtɛlɛ́ nyu ɑ́i nkɑ́ripi. Uu kɛyɑ́ɑ yisi uu Efɛɛsi sĩ. ");
INSERT INTO soy_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","U Upíimɑ nsímɛ́ nyulɛ ńsɔnɛ, un Yeesu nkɔ́ céési un kɔ símisi téí-téí yɑrɛ lɛ̃ kɑi n wɔ́lɑɑlɛ̃. Amɑ́ lɛ̃ kɛ Yohɑni uu pisoi míni n wólɛ ŋmɑnɛ kɛcɑ́ɑ́ kuu nyu. ");
INSERT INTO soy_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Uu kuyómɛyɑ́hɑɑlee-i lompɔ uú nɛ uripɔɔ n símisi. Kɛ Pirisili nɛ Akilɑsi ɑpi lɛ̃ n kṍ un símisi, ɑpi u séi ɑpí nɛ pikɛyɔ sĩ ɑpí hɑ Uléécɑɑ ncee u kpɑ̃́iisɛ téí-téí. ");
INSERT INTO soy_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Uu pɛɛ limɛmɑ́ɑ́ rɛ u lɑ ukɛ́ Akɑyii kɛtẽ-mɛ̃ hɑ. Piyómɛyɑ́hɑɑ ɑpi u ŋmɔ́ɔ́púsɛ, ɑpi kɔ kei-pɔ pikɔ́ rítɛlɛ́ wɔ́lu rɛ un n hɑpɔ, pikɛ́ mɛmɑ́rɛcɔ ńsɔnɛ u yɔsí. Kuu kei n tuipɔ, pɛ̃ nnɛ́í kɛ Uléécɑɑ uu ípɛɛlɛ́ɛ n nyísɛ ɑpí nɛ Yeesu kɛfɑ tɛnɛ kuu yóriyɛ ɑ́i kumúŋɛ́ mɑ́. ");
INSERT INTO soy_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","U yɛ pɛɛ kɛyu rikpɑ̃́iisɛlɛ uu ḿpɑ́ úye kɛyu-i Pisuifi nsímɛ́ kɛ́su, uú nɛ Nléécɑɑsimɛ́ ɑtɛlɛ́ tíki uu pi cereisɛ rɛ Yeesu kɛ Uléécɑɑ uu wɛ́ɛ. ");
INSERT INTO soy_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Kumúŋɛ́ kpɛ-i kɛ Apoloosi uú pɛɛ Korɛnti-i ń we, Pɔɔli yɛ pɛɛ yisilɛ uu Asii ɑyɔpɛ silõ lɔ́ɔ́ uu Efɛɛsi sĩ, uu kei Yeesu pipirɛtiki pinyinɛ yɛnu. ");
INSERT INTO soy_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Uu pi pisɛ rɛ: Kɑni Yeesu nɛ kɛfɑ n tɛnɛ, Uléécɑɑ yɛ Nfɑ́ɑsɔnɛ nɔ́ hɛɛ? Api u pɛsɛ rɛ: Ticuruu ɑ́ri Nfɑ́ɑsɔnɛ nkɔ́ ńkɑ komɑɑlɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Uu kɔ pipisɛ pi kpɑ́ rɛ: Míni mɛ́ye mpuri kɑpi pɛɛ nɔ́ wólɛ? Api rɛ Yohɑni mɛni kuu pisoi n wólɛ kɑpi rɔ́ wólɛ. ");
INSERT INTO soy_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pɔɔli uu pɛɛ pi mɑɑ rɛ: Pɛpɛɛ n ŋmurɛi rɛ pi yɛ́ mɛfinɛ consɛ kɛ Yohɑni uu yɛ pɛɛ míni wolɛ. Uu yɛ kɔ Isirɑyɛɛli pikɔ́ mɑɑ rɛ pikɛ́ Yeesu yɛɛ mɑsí ukɛpirɛ n sɔ́nti nɛ kɛfɑ tɛnɛ. ");
INSERT INTO soy_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Kɛ pipirɛtiki pɛ̃ ɑpi ɑnɔ́ɔ nyɛ̃ n kṍ, ɑpi tíyɛsɛ ɑpi Upíimɑ Yeesu rinyiri nɛ míni pi wolɛ. ");
INSERT INTO soy_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pɔɔli uu ɑnípɛ pikɛcɑ́ɑ́ lɑ́ɑ, Nfɑ́ɑsɔnɛ nn pikɛcɑ́ɑ́ súiri. Api pɛɛ mɛyu mpehẽ mpehẽ pisímɛ́ loni pin kɔ nɛ Uléécɑɑ rinyiri pisoi símisi. ");
INSERT INTO soy_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Pinnɛ́í yɛ pɛɛ wɑlɛ pitisi kɛfi nɛ pitɛ́. ");
INSERT INTO soy_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pɔɔli uu kuyómɛyɑ́hɑɑlee-i lompɔ, uu kɛ́yu kpɑ̃́iisɛ uu iwɑrɛ itɑɑni nɛ Uléécɑɑ iyɔɔpi kɛcɑ́ɑ́ pi símisi cɑ́kɑ́-cɑ́kɑ́ rɛ pikɛ́ kṍ. ");
INSERT INTO soy_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Amɑ́ pinyinɛ pɔ́ɔn pɛɛ yúlu rɛ ɑ́pi nɛ kɛfɑ tɛnɛnɛ, pin kɔ Upíimɑ icélɑɑ iyɛ̃ tiwúí kɛ́mɛɛ sɛ́nnyi pin lɑ́misi. Pɔɔli uu mɛsɛ upipirɛtiki kpísi uú nɛ kei nyɔsɔ́, uu yɛ pɛɛ ḿpɑ́ kɛyɑ́ɑ kɛ́ye utisi unyinɛ kɑpi yɛ n sée rɛ Tirɑnuusi ripoo-i isúkuli kɛ́mɛɛ pi n céési. ");
INSERT INTO soy_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ai wɑi iŋmɛ̃ itɛ́ nɛ iriyu. Lɛlɛɛ tíyɛsɛ kɛ Pisuifi nɛ Pikirɛki nnɛ́í pɛɛ Asii kɛteni-i ń we ɑpi Upíimɑ nsímɛ́ kṍ. ");
INSERT INTO soy_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Uléécɑɑ yɛ pɛɛ kumúŋɛ́ kpɛ-i Pɔɔli nɛ ritikilɛ uú nɛ mɛwɑisɑŋɑ wɑpisi. ");
INSERT INTO soy_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Lɛ̃ ɑi tíyɛsɛ ricuruu pisoi ɑpi yɛ ilũ nɛ sinírípi sɛɛ Pɔɔli rińcɑ kpísi ɑpí hɑ pitóikɔ́ kɛcɑ́ɑ́ lɑ́ɑ, ɑpi pélu, ɑníri ɑɑ kɔ lelu. ");
INSERT INTO soy_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Kei kɛ Pisuifi pinyinɛ pɛɛ n kɔɔnii pin pisoi ɑníri pɛ́sɛi pɔ́ɔ kɔ rɛ pi yɛ́ Upíimɑ Yeesu rinyiri sée ɑpí nɛ pisoi ɑníri pɛ́sɛi. Api yɛ pɛɛ ɑ mɑɑ rɛ: Nɛ Yeesu uyɛ̃ nsímɛ́ kɛ Pɔɔli uu n yóólɛ̃ tinyiri nɛ rinɔ́ɔ nɔ́ hɛ rɛ ɑni pisoi mpí kɑni nní n cɔ́ŋlɛ̃ kɛ́mɛɛ le. ");
INSERT INTO soy_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Pisuifi pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ uwɛ́ɛ́sɛ usɛ kɑpi yɛ n sée rɛ Sefɑ piŋmɑ́nɛ pisɛɛi pɛɛ mɛwɑi mɛ̃ lɛ̃ wɑi. ");
INSERT INTO soy_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Amɑ́ kuníri ɑku kɛyɑ́ɑ kɛnyinɛ pi pɛsɛ rɛ: Nɛ Yeesu nyulɛ, nɛn kɔ Pɔɔli isoi nyu. Nɔ̃́ ní, nɔ́ɔ pɛɛ mpíí píye? ");
INSERT INTO soy_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Kei kɛ unírihélɑɑ uyɛ̃ uu yisi uu pi kɑ́pɑ́ɑ́, uu pinnɛ́í rikɔhɔ feriyɛ. Uu rikpɑ́kɑ́rɑ́ nɛ íwɛ pi wɑi ɑpí hɑ nɛ itói yɔ́ɔi, ɑi tɔ́su ɑpí nɛ ukɛyɔ-i mɛŋmɑnɛ popirimɛ ɑpi itóó súúni. ");
INSERT INTO soy_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Pisuifi nɛ Pikirɛki pɛɛ Efɛɛsi-i ń we ɑpi kóm tɛ lɛ̃ kɑi wɑ. Iwɑmɛ ii pi loni, pisoi ɑpi pɛɛ Upíimɑ Yeesu rinyiri mɛyɑ̃́ n tɑɑ́sɛlɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Pɛpɛɛ pikɛmɛɛ Kirisi nɛ kɛfɑ n tɛnɛ mɛyɑ̃ ɑpi yɛ pɛɛ sĩ́ ɑpí hɑ pisoi kɛcɔpɛ lɛ̃ kɑpi n wɑpisi yɑ́mnɛntɛ. ");
INSERT INTO soy_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Pɛpɛɛ pɛɛ mɛŋmɑnɛiwɑi n wɑi mɛyɑ̃ pɔ́ɔ kɔ nɛ piɑtɑrɛtɛlɛ́ sɔ́nɑɑpɔ ɑpi pisoi kɛcɔpɛ nnɑ ɑ ŋmɑkɑɑnkɛɛ. Pi ɑsilɑlɛwoó kɛ́ɛ́nlɛ ɑí lelu mɛwóópipi ɑ́kotokú kuwóó (50.000). ");
INSERT INTO soy_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Lɛ̃ kɛ Upíimɑ nnɑŋɛ nn tíyɛsɛ unsímɛ́ nń nɛ ḿpɑ́ yei kɔ́ɔ́nú ńsɔnɛ. ");
INSERT INTO soy_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Lɛ̃ mɛmɑ́ɑ́, Pɔɔli uu pɛɛ kɛmúŋɛ́ wɑi rɛ ukɛ́ Mɑsetuwɑɑni nɛ Akɑyii sitẽ-mɛ̃ cɔ ukɛ́ nɛ Yerusɑlɛm tu. Uu rɛ un kei n tu, li kɔ pisɛ rɛ ukɛ́ Rɔm kuyu rilóólú. ");
INSERT INTO soy_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Uu pɛɛ pisoi pɛɛ pikɛi u n lɛ́ni kɛcɔpɛ pitɛ́ yukusɛ uu Mɑsetuwɑɑni-pɔ tum. Pɛ̃ kuu n tũ pɛɛ Timotee nɛ Erɑsiti. Uricuruu uu nkɑ́ripi Asii kɛteni-i kɛtónɛ kpɑ́. ");
INSERT INTO soy_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ńcɔkɔi píimɑ nnyinɛ nn likumúŋɛ́ kpɛ-i Upíimɑ ncee pitiki kɛcɑ́ɑ́ nnyɑ Efɛɛsi kuyu-i léeri. ");
INSERT INTO soy_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Utisi unyinɛ yɛɛ pɛɛ kei we, ɑpi yɛ u séi rɛ Temetiriisi. U pɛɛ úyu lɛ. Piléé pinyinɛ kɑpi yɛ pɛɛ kɔ kei n sée rɛ Aritemiisi siwosoopi kuu yɛ pɛɛ́ nɛ yírɑɑnɛ uu sisiyukɛ-yukɛ nɛ nwóóweni yuhu yɑrɛ sítumpiwɛɛ́u. Upikɛi pɛɛ pɛɛ u nɛ upinípɛkɛikɔ́cɔ kulɑ́ɑ wɑilɛ ńsɔnɛ. ");
INSERT INTO soy_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Uu kɛyɑ́ɑ kɛnyinɛ upikɛicɔ pɛ̃ nnɛ́í cɑ́pinɛ uu pi mɑɑ rɛ: Pinɛ́sɑ́nɛ, nɔ́rinɛ́cúruu yɛ nyulɛ rɛ pirɔ́kɛi mpí kɑrí nɛ le. ");
INSERT INTO soy_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Nɔ́rinɛ́cúruu yɛ kɔ nyɑ́nilɛ nɔn kɔ kómɛi rɛ ɑ́i nkpɑ́ni Efɛɛsi nté ŋmɑnɛ, ɑmɑ́ Asii kɛtẽ nnɛ́í kɛcɑ́ɑ́ kɛ Pɔɔli uyɛ̃ uu pisoi tɑ́lɑɑnkɛɛ ɑpi ŋmurɛi rɛ ɑ́pi yɛ́ piléé kɛ sisoipipi ɑsi ń sɛrí nɛ kutu n cɔlɛ̃, tɛ ɑ́i Uléécɑɑ. ");
INSERT INTO soy_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Tɔnsɑ́ piwɑi n ceri, mɛwɑi mɛ̃ nɛ́ pirɔ́kɛi riyu kpu, ɑmɛ pirɔ́lééyɑhɑ píimɑ Aritemiisi kɑpi Asii nnɛ́í nɛ sitẽ sicɔ-pɔ n yɑ́ɑ́si fíísɛ, úkɑ úu yɛ pɛɛ pi n wɑisɛlɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Kɛ pisoi pɛɛ n cɑ́pinɛlɛ̃ ɑpi ɑnɔ́ɔ nyɛ̃ n kṍ, ɑi kuwɔ́i pi feriyɛ ɑpi cɑ́ɑ́i rɛ: Lipíimɑ lɛɛ Efɛɛsi piléé Aritemiisi! ");
INSERT INTO soy_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ńcɔkɔi nn pɛɛ kuyu nnɛ́í yipu. Pisoi ɑpi kómɛinɛ ɑpí nɛ kɛkpíntɑhɑi n sɑirilɛ̃, ɑpi Pɔɔli pisencɔ Mɑsetuwɑɑni pikɔ́ pitɛ́ tini ɑpí nɛ pɛ́nɛpɔ. Pɛpɛɛ Kɑyusi nɛ Arisitɑriki. ");
INSERT INTO soy_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pɔɔli uú n lɑ ukɛ́ pisoi pɛɛ n cɑ́pinɛlɛ̃ kɛyu-i léépɔ, ɑmɑ́ Yeesu pipirɛtiki ɑpí nɛ u yulu. ");
INSERT INTO soy_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Aí nɛ upisɑnɛ Asii pikɑwe píimɑ pinyinɛ pɛ́nɛ ɑpi ukɛmɛɛ pisoi tumpɔ ɑpí nɛ u kɛsu rɛ úu kɑpɛ kɛkpíntɑhɑi kɛ-i lompɔ. ");
INSERT INTO soy_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Pisoi yɛ pɛɛ welɛ pin kɛcɑ́pinɛ kɛ-i mɛ́woo cɑ́ɑ́i, úkɑ úu ucɔ nkɔ́ kómɛi, lin pi túírɛsɛntɛ. Pimɛyɑ̃ ɑ́pi kɔ nyu lɛlɛɛ kei pi n cɑ́pinɛsɛlɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Kei kɛ Pisuifi pinyinɛ ɑpi Alɛkisɑntiri kɛ́yu-mɛ̃ titépɔ, pisoi ɑpi pɛɛ́ m músu rɛ uyɛɛ nɛ ńcɔkɔi mmɛ̃ kɑ. Alɛkisɑntiri pɔ́ɔ pɛɛ kunípɛ síkɑ rɛ u lɑ ukɛ́ uriyu hɛɛrɛ. ");
INSERT INTO soy_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Kɛ pisoi ɑpi n céri rɛ Alɛkisɑntiri yɛ Usuifi lɛ, ɑpi pɛɛ rinɔ́ɔ risɛ wɑi ɑpí n cɑ́ɑ́i rɛ: Efɛɛsi piléé Aritemiisi pɛɛ Lipíimɑ! Api lɛ̃ n cɑ́ɑ́i ɑí nɛ ituŋɛ mɛkɔ́ɔ́nú mɛtɛ́ tulu. ");
INSERT INTO soy_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Kuyu utɛlɛwɔlɛ uu fe uu pisoi sɛ́ɛ́sɛ, uu pɛɛ pisɛ rɛ: Nɔ̃́ Efɛɛsi pikɔ́, wóo yɛ úu kɛtẽ kɛcɑ́ɑ́ nyu rɛ Efɛɛsi kuyu pikɔ́ pɛɛ pilééyɑhɑ píimɑ Aritemiisi nɛ pikɛyu kɛɛ kɛléécɑɑ-pɔ n lóimɛ kɛcɑ́ɑ́ pɑílɛ̃? ");
INSERT INTO soy_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Úkɑ úu we yɛɛ yɛ́ nsímɛ́ mmɛ̃ n kɛ́si. Lɛ̃ nnyɑ, ɑni nɔ́ɑnɛ́kíŋ niŋukusɛ, ɑ́ni kɑpɛ ń-yɔɔnɛ-yɔɔnɛ nɛ linyinɛ wɑ. ");
INSERT INTO soy_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Pisoi mpí kɑní nɛ ń kɑ ɑ́pi kurɔ́yómɛyɑ́hɑɑlee-i líkɑ cɑɑi, ɑ́pi kɔ pirɔ́léé Aritemiisi lɑ́mɑɑnkɛɛ. ");
INSERT INTO soy_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","In tɛ úyu Temetiriisi nɛ upikɛicɔ yɛ unyinɛ nɛ nsímɛ́ mɑ́, sitúhɑɑnɛyɑɑ yɛ welɛ, pitúhɑɑnɛ pin kɔ we. Pi yɛ́ fe ɑpi kei kɛtɑhɑi u séi ɑpí nɛ pi túhɑɑnɛ. ");
INSERT INTO soy_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Nɔn kɔ pɛɛ ń-ye ncɔ m mɑ́, tɔ́ hɑ riyɔ́ɔpipoo-i mmɛ̃ símisi yɑrɛ kɑi m pisɛ. ");
INSERT INTO soy_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Insɑ́ lɛ̃, lɛlɛɛ nɛni kɛyɑɑ nkɛ́ nní ń wɑ yɛ́ tíyɛsɛ ɑrí n we yɑrɛ pitencɔkɔi. Ári yɛ́ ńkɑ yɛ̃ tɔkɛ́ símisi likɛ́ nɛ n nyísɛ rɛ tɔ ɑlɑri mɑ́lɛ tɔkɛ́ nní n cɑ́pinɛlɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Tinɔ́ɔ tɛ̃ kuú mɑ uú nɛ pisoi kpiisɛ. ");
INSERT INTO soy_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Kɛ ńcɔkɔi nn Efɛɛsi-i rińfɑ, Pɔɔli uu Yeesu pipirɛtiki cɑ́pinɛ uu ikɑri pi kpɑ́sɛ, uu pɛɛ yisi uu Mɑsetuwɑɑni kɛtẽ-mɛ̃ tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Kuu n tuipɔ, u nɛ kei pikɔ́ ɑpi yɔ́i uú nɛ ikɑri pi kpɑ́sɛ, uu kɔ Kirɛɛsi kɛtẽ-mɛ̃ tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Uu kei tonɛ iwɑ́rɛ itɑɑni. Kɑi n tu rɛ ukɛ́ kúninɔi lõ ukɛ́ Sirii kɛtẽ-mɛ̃ hɑ kuu kṍ tɛ Pisuifi yɛ kómɛinɛlɛ rɛ pikɛ́ u kpu. Uu rɛ u yɛ́ mɛsɛ Mɑsetuwɑɑni-mɛ̃ pɛɛsɛ. ");
INSERT INTO soy_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Upisencɔ ɑnyiri yɛ nnyɛ́: Peeree kuyu ukɔ́, Piruusi uŋmɑ́nɛ kɑpi yɛ n sée rɛ Sopɑtɛɛri nɛ Tɛsɑloniki pikɔ́ mpí: Arisitɑriki nɛ Sekɔntusi nɛ Tɛripu ukɔ́ Kɑyusi nɛ Timotee nɛ Asii kɛtẽ pikɔ́ mpí: Tisiiki nɛ Torofim. ");
INSERT INTO soy_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Pɛpɛɛ kɛkpéẽ nɛ rɔ́ wɑ ɑpí hɑ Turowɑɑsi-pɔ rɔ́ m mɛ̃́. ");
INSERT INTO soy_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Anyɑ̃́ nyɛ-i kɑpi yɛ ɑkpɔ́nɔ́ nyɛɛ ɑ́ɑ pitɛ m mɑ́ n li mɛtɛnɛ-mɑɑ́ kɛ tɔ́ɔ Filipu hɑ ɑrí hɑ kei kúninɔi loni. Siyɑ́ɑ sinupũ kɑri ncée wɑ ɑrí nɛ Turowɑɑsi-i pi lɛɛpɔ. Ari kei kɛsẽ́ tonɛ siyɑ́ɑ sisɛɛi. ");
INSERT INTO soy_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Kɛwéntɛyɑɑ ukóso kɑri cɑ́pinɛlɛ̃ tɔn ɑkpɔ́nɔ́ hɔ́ɔ́nɛ Pɔɔli ukɛ́ nɛ liukóso kui. Lɛ̃ nnyɑ kuu yɔ́i kɛsinɛ ɑkɛ́ hɑ nɛ pelu. ");
INSERT INTO soy_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Kɛ́yɔ kɛcɑ́ɑ́ kulee kunyinɛ-i kɑrí pɛɛ cɑ́pinɛlɛ̃, sífirɑ́ɑ kulúi sin sɛriilɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Kɛ Pɔɔli uu lɛ̃ piyɔ́i ń nɔŋ́lɛ̃, nnɔ̃ píimɑ nnyinɛ nn uŋmɑ́nɛ unyinɛ kɑpi yɛ n sée rɛ Itiikusi kpɑ́píí. Kulee kɛpolɛ kɛkúrí kuú pɛɛ tṹ. Ai u hii uú hɑ kɛléécɑɑyɔ mɛtɔ́si tɑ́ɑ́nũ kulee kpɛ-i lóiri. Apí hɑpɔ ɑpi u yukusɛ un pikpɔ mɑsí. ");
INSERT INTO soy_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pɔɔli uu cɛ́pipɔ uú hɑ wulɑ uu u sɑkɑɑ uu múlú uu rɛ: Nɔ́kɛnɛ́wuu ɑ́kɛ kɑpɛ tɔ, u nɛ nfɑ́ɑ mɑ́lɛ. ");
INSERT INTO soy_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Pɔɔli uu yisi uu pítɑɑ́ pɛlɛ, uú hɑ ɑkpɔ́nɔ́ hɔ́ɔ́nɛ uu le. Uu kɔ nsímɛ́ nɔŋ́ ɑí nɛ kpɑ̃́ii, uu pɛɛ yisi uu tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Api uŋmɑ́nɛ uyɛ̃ pɔ̃́ nɛ kulu nɛ unfɑɑ. Ḿpɑ́ úye rikiŋ ɑri lɛ̃ nnyɑ niŋɛsi hɑ́i. ");
INSERT INTO soy_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Ari ntɔ́nɛ́í kúninɔi loni ɑrí hɑ Asoosi-pɔ Pɔɔli mɛ́ru. Uyɛɛ wɛ́ɛ rɛ u yɛ́ sɔ́nɛ uú hɑ pɛɛ kei-pɔ kúninɔi loni. ");
INSERT INTO soy_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Kuu Asoosi-i rɔ́ n lɛɛpɔ, ɑri kei kɛsẽ́ kúninɔi loni ɑrí nɛ Mitilɛɛni sĩ. ");
INSERT INTO soy_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Ari kei yisi ɑri liukóso mmɑrɛ Ciyoo kɛtẽ nɛ kɔ. Ari liukóso Sɑmoosi tulu. Ai weesi ɑri pɛɛ Milɛti tulu. ");
INSERT INTO soy_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pɔɔli ricuruu yɛ pɛɛ rɛ úu Efɛɛsi-i nyɛrɛnɛ, ɑ́i kɑpɛ nɛ Asii kɛteni-i mɛ́woo u n nɑ́ŋɑisɛ nnyɑ. U pɛɛ yɔ́ɔnɛlɛ rɛ un n fe, ukɛ́ Pɑntekooti kɛtúŋɛ́ Yerusɑlɛm tu. ");
INSERT INTO soy_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Pɔɔli uu pɛɛ Milɛti-i pisoi yukusɛ uu tum tɛ pikɛ́ hɑ Efɛɛsi-pɔ Uléécɑɑ icɑ́pinɛ piwɛ́ɛ́sɛ u séemɛ. ");
INSERT INTO soy_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Kɛ pɛ̃ ɑpi ukɛkúrí ń kɑ, Pɔɔli uu pi mɑɑ rɛ: Nɔ́rinɛ́cúruu yɛ nyulɛ isoi iyɛ̃ kɑḿ nɛ nɔ́ ń le hɑ́i kɛyɑ́ɑ foí kɛ̃-mɛ kɑm Asii kɛtẽ kúnɑ n cɔ. ");
INSERT INTO soy_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Nɛ mɛnɛ́círɛ ricɛpisɛlɛ nɛn nɛ Upíimɑ pikɛi wɑi, Pisuifi pin wɛ́ɛ́si pikɛ́ nɛ́ kpu, ɑpi íwɛ nɛ́ wɑi nɛn mɛ́nini nɛ ncɔ́ŋ kɛ́mɛɛ we. ");
INSERT INTO soy_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Tiwúí kɛ́mɛɛ nɛ nɔ́sinɛ́yɔ-i kɑm lɛlɛɛ yɛ́ nɔ́ n yóriyɛ nɔ́ símisi, ɑ́m líkɑ nɔ́ pesí. ");
INSERT INTO soy_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Pisuifi nɛ Pikirɛki kɑm sée ɑm símisi rɛ pikɛ́ Uléécɑɑ inipɛɛ-i mɛfinɛ consɛ ɑpi Urɔ́píimɑ Yeesu nɛ kɛfɑ tɛnɛ. ");
INSERT INTO soy_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Nɛ nkpéni lɛ̃ Nfɑ́ɑsɔnɛ rinɔɔ tikilɛnlɛ nɛn nɛ Yerusɑlɛm tɔ́su, ɑ́m kɔ nyu yo yɛɛ kei nɛ́ mɛ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Amɑ́ Nfɑ́ɑsɔnɛ yɛ ḿpɑ́ kuyu kúye-i nɛ́ símisilɛ nn kɔ nɛ́ nyísɛ rɛ ɑkpɑnii nɛ íwɛ píimɑ yɛ kei-pɔ nɛ́ mɛ̃́. ");
INSERT INTO soy_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Nnɛ́fɑ́ɑ ricuruu nn nɛ́ cɔ́ŋlɛ. Nɛ kpére pinɛ́kɛi nɛ kɛ́tɔ tu, ɑm lɛ̃ kɛ Upíimɑ Yeesu uu nɛ́ m pisɛ nɛ kɛfɑ kɛsɛ wɑi, li nɛ nɛ́ risɑ́. Pikɛi pɛpɛɛ nní rɛ kɛ́ riyóó rɛ Uléécɑɑ ipɛɛlɛ́ɛ kuu rɔ́ n nyísɛ yɛ Nsímɛ́ kɛcirɛ lɛ. ");
INSERT INTO soy_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Nɛ yɛ̃ tɛ mɛtɔ́rɔɔ kɑm nní nɔ́kɛnɛ́cɔpɛ we. Nɔ́ nɛ picɔ pɛ̃ nnɛ́í kɑm Uléécɑɑ iyɔɔpi nsímɛ́ rin-yóó ɑ́ni nɛni píkɑi piyɛ́nɛ nɛ́ kpɑ́nɛ. ");
INSERT INTO soy_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Lɛ̃ nnyɑ kɑḿ lɑ kɛ́ nɛni kɛyɑɑ nkɛ́ nɔ́ símisi nɔkɛ́ kṍ tɛ: Nɔ́ úye un m pɔ, ɑ́i kɛnɛ́mɛɛ léeri. ");
INSERT INTO soy_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Li we rɛ nɛ lɛ̃ nnɛ́í kɛ Uléécɑɑ uu n yekei rɛ ukɛ́ wɑ nɔ́ símisilɛ ɑ́m líkɑ nɔ́ pesí. ");
INSERT INTO soy_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ani nɔ́mɛnɛ́círɛ tĩ ńsɔnɛ, ɑni kɔ Uléécɑɑ pikɔ́ imɛ́rɛ́ kɛ Nfɑ́ɑsɔnɛ nn nɔ́ ń tĩ́ tɛ ɑni n séni kɛcɑ́ɑ́ m pɑílɛ̃. Uléécɑɑ yɛɛ uricuruu kɛpipi mɛnyɛ nɛ pisoi pɑnsɛsɛ upikɔ́. Ani ńsɔnɛ pi m múílɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Nɛ nyulɛ rɛ pisoi kpɑ́ɑ́ree pinyinɛ yɑrɛ ɑ́kpɛ yɛ́ mɛnɛ́tɔ́mpɔ-mɑɑ́ nɔ́ ripimɛ, ɑpi nɔ́kɛnɛ́cɔpɛ pinyinɛ cɔ́pii. ");
INSERT INTO soy_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Pinyinɛ ricuruu yɛ́ nɔ́kɛnɛ́cɔpɛ yisi, ɑpi nnɔ́ɔmɛsimɛ́ nɛ Yeesu pipirɛtiki pinyinɛ feriyɛ ɑpi pincee pi tikisɛ. ");
INSERT INTO soy_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Lɛ̃ nnyɑ, ɑ́ni kɑpɛ lɔpilɛ. Áni kɑpɛ pɑlɛi rɛ iŋmɛ̃ itɑɑni nnɛ́í kɑm yɛ kɛtúŋɛ́ nɛ kɛsinɛ pinyinɛ-i nɛ mɛ́nini icélɑɑ nɔ́ m pehelɛntɛ. ");
INSERT INTO soy_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Nɛ nkpéni Uléécɑɑ nɛ uipɛɛlɛ́ɛ nsímɛ́ ɑnipɛ-i nɔ́ wɑ. Uyɛɛ ńnɑŋɛ mɑ́ ukɛ́ nɛ nfɑtɛnɛ kɛ́mɛɛ nɔ́ n ŋmɔ́ɔ́púsɛlɛ̃. Uyɛɛ yɛ́ kɔ lisɔnɛ kuú nɛ upisoi nnɛ́í m mɛ̃́ nɔ́ hɛ. ");
INSERT INTO soy_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ám úkɑ siwóó nɛ́ɛ úkɑ uwurɑ nɛ́ɛ úkɑ mɛlɑpɛ kɑ́ipi. ");
INSERT INTO soy_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Nɔ́rinɛ́cúruu yɛ nyulɛ rɛ ɑnɛ́nípɛ nnyɛ́ kɑḿ nɛ kɛisi tɔ́ nɛ pinɛ́séncɔ ɑrí nɛ ntɔ́cɔ́ŋ nnɛ́í wɑi. ");
INSERT INTO soy_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Nɛ lɛ̃ nɔ́ nyísɛlɛ rɛ lɛ̃ kɑi pisɛ rɛ usoi ukɛ́ kɛisi uú nɛ píwɛkɔɔ́ n lɛ́ni. Ani kɔ Upíimɑ Yeesu rinɔɔ ntí kɛcɑ́ɑ́ léisɛ. Uyɛ̃ ŋmɑɑ yɛɛ rɛ: Uyɛɛ n hɛ yɛ mpɔ́ɔnɑrɛ mɑ́lɛ ɑi tɔ́su uyɛɛ ihɛɛ n yɔ́su. ");
INSERT INTO soy_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Kɛ Pɔɔli uu lɛ̃ pimɑ́ɑ ḿ mɑsí, u nɛ pɛ̃ ɑpi wúlɑ ɑpi kɛyómɛ yɑ́ɑ́si. ");
INSERT INTO soy_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Pinnɛ́í ɑpi pɛɛ limɛmɑ́ɑ́ ténisi ɑpí nɛ Pɔɔli pirɑ ɑpi mɛtɔ́rɔɔ u yɑ́ɑ́si rɛ Uléécɑɑ ukɛ́ u sɑrumpɔ. ");
INSERT INTO soy_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Kɛ Pɔɔli uú pɛɛ ḿ mɑɑ rɛ ɑ́pi nɛni píkɑi piyɛ́nɛ u kpɑ́nɛ nnyɑ kɛ piɑpɔɔ ɑɑ lɛ̃ sei mɛyɑ̃́ cɑɑilɛ̃. Api pɛɛ yisi ɑpi u sɑruni ɑpí nɛ kúninɔi-i tulu. ");
INSERT INTO soy_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Kɛ tɔ́ nɛ pɛ̃ ɑri kei lɛ̃ icée n hɔ́ɔnɛnɛ, ɑri kúninɔi loni ɑrí nɛ mɛsɛ nɛ mɛsɛ Kɔɔsi n sɑirilɛ̃. Ai weesi, ɑri Rootɛsi tɔ́mpɔ ɑri kei yisi nɛ Pɑtɑrɑ-pɔ. ");
INSERT INTO soy_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ari kei kúninɔi yɛnu kun Fenisii kɛtẽ-mɛ̃ sĩ. Ari kpɛ̃ loni ɑrí nɛ tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Kɑri Siipuru kɛtẽ kɛɛ míni kɛpɑ́ɑ́pɑ́ɑ́ ń we n yɛ́mpɔ, ɑri kɛ yɑ́ ɑri kumíi-mɛ̃ tiki hɑ́i nɛ Sirii kɛtẽ-pɔ, ɑrí nɛ Tiiri tulu. Kei kɛ kúninɔi ɑku kuilũ topilɛnɛ. ");
INSERT INTO soy_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ari kei Yeesu pipirɛtiki lɛɛpɔ, ɑri pikɛkúrí tonɛ siyɑ́ɑ sisɛɛi. Nfɑ́ɑsɔnɛ nn pi símisi ɑpi Pɔɔli mɑɑ rɛ úu kɑpɛ Yerusɑlɛm hɑ. ");
INSERT INTO soy_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Amɑ́ kɛ siyɑ́ɑ sɛ̃ ɑsi n tɔ́mpɔ, ɑri yisi ɑri kɔ nsẽ́ nɔŋ́. Api pinnɛ́í yisi nɛ pipinɔsi nɛ pisiwɑ̃ ɑpi rɔ́ sɑ́runi ɑpí nɛ kuyu leepɔ. Ari kei mínimɑɑ ritimɛ wulɑ ɑri kɛyómɛ yɑ́ɑ́si. ");
INSERT INTO soy_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Ari pɛɛ limɛmɑ́ɑ́ yɑ́hɑɑnɛ ɑrí nɛ kpii. Tɔ́ɔ kúninɔi loni, pɛ̃ ɑpi pisiyɔ kúúni. ");
INSERT INTO soy_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Tiiri-i kɑri mɛtɔ́rɔɔ kúninɔi lõ ɑrí nɛ Putolemɑyisi sĩ. Ari kei Yeesu pikɔ́ yɑ́ɑ́si ɑrí nɛ kɛyɑ́ɑ kɛsɛ pikɛmɛɛ́ tonɛ. ");
INSERT INTO soy_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Kɑi n weesi, ɑri yisi ɑri Sesɑree tulu. Arí hɑ Filipu yɛɛ Nsímɛ́ Kɛcirɛ nɛ n kɔ́ɔ́núlɛ̃ kɛyɔ-i tonɛ. U pisoi pisɛɛi pɛ̃ kɑpí pɛɛ Yerusɑlɛm-pɔ n wɛ́ɛ usɛ lɛ. ");
INSERT INTO soy_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","U pɛɛ pikpére pinɑ mɑ́lɛ pɛɛ ɑ́pi utisi n nyu. Pi yɛ pɛɛ Uléécɑɑ rinyiri nɛ símisilɛ. ");
INSERT INTO soy_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Tɔn kei lɛ̃ we lin siyɑ́ɑ kulúi wɑi kɛ ɑntepu uyɛ̃ kɑpi yɛ n sée rɛ Akɑpuusi uu Yutee kɛtẽ-pɔ leemɛ uu kɛrɔ́mɛɛ́ weri. ");
INSERT INTO soy_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Uu Pɔɔli kutɑmpɑ́lɑ kpísi uu ɑ́nɑ nɛ ɑnípɛ hɔpu uu rɛ: Nfɑ́ɑsɔnɛ yɛ mɑɑ rɛ nní mɛcɔ kɛ Pisuifi ɑpí hɑ Yerusɑlɛm-pɔ kutɑmpɑ́lɑ nkú ute íŋmɛ hɔpunɛ, ɑpi pɛɛ limɛmɑ́ɑ́ mpuri sɑnɛ pikɔ́ ɑnipɛ-i u wɑi. ");
INSERT INTO soy_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Kɑri ɑnɔ́ɔ nyɛ̃ n kṍ, tɔ́ nɛ Sesɑree-pɔ Yeesu pikɔ́ ɑri Pɔɔli súúluisɛ rɛ úu kɑpɛ Yerusɑlɛm hɑ. ");
INSERT INTO soy_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Pɔɔli uu pɛɛ rɔ́ pɛsɛ rɛ: Yo nnyɑ kɑni téni nɔn lɑ nɔkɛ́ inɛ́piŋɛ riyɔɔsɛ? Ái pihɔpɛ ŋmɑnɛ kɛ nɛ́ɛ nɛ mɛnɛ́círɛ cɑ́pinɛlɛ̃ nɛn mɛ̃́. Lin kɔ n wɑ rɛ kɛ́ Upíimɑ Yeesu kɛcɑ́ɑ́ Yerusɑlɛm-pɔ kpu, nɛ we. ");
INSERT INTO soy_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Kɑri umɛkɔ́ m pɔɔnɛ, ɑri sɛ́ɛ́ ɑri pɛɛ mɛsɛ mɑɑ rɛ Upíimɑ mɛlɑ mɛkɛ́ wɑ. ");
INSERT INTO soy_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Kɑri kɛlõ kɛ-i siyɑ́ɑ sinyinɛ n tónɛ, ɑri mɛrɔ́círɛ cɑ́pinɛ ɑri Yerusɑlɛm tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Yeesu pipirɛtiki pɛɛ Sesɑree-i ń we kɛcɔpɛ pinyinɛ ɑpi yisi ɑpi rɔ́ sɑ́runi ɑpí nɛ Siipuru ukɔ́ unyinɛ kɛyɔ rɔ́ sĩ́ tɛ pikɛ́ kei rɔ́ yɔsí. Pi yɛ u sée rɛ Mɑnɑsɔɔ. Hɑ́i ɑ́i nɛni-mɛ kuu Yeesu tikilɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Kɑri Yerusɑlɛm n tuipɔ, Yeesu pikɔ́ ɑpí nɛ mpɔ́ɔnɑrɛ rɔ́ yɔ́su. ");
INSERT INTO soy_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Kɑi kóso n weesi, Pɔɔli uu rɔ́ tíki ɑri Yɑkupu kɛyɔ sĩ. Piwɛ́ɛ́sɛ picɔ nnɛ́í pɔ́ɔ kɔ kei cɑ́pinɛpɔ. ");
INSERT INTO soy_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pɔɔli uu yisi uu pi yɑ́ɑ́si uu pɛɛ lɛ̃ nɛ lɛ̃ kɛ Uléécɑɑ uú nɛ upikɛi rintíki uú nɛ mpuri sɑnɛ pikɔ́ kɛcɔpɛ wɑi pi kɛɛnkɛɛ kélé-kélé. ");
INSERT INTO soy_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Kɑpi lɛ̃ n kṍ, ɑpi Uléécɑɑ pɑkɑrɛ, ɑpi pɛɛ Pɔɔli mɑɑ rɛ: Pɔ nyɑ́nii, umɑ́rɛcɔ! Pisuifi yɑrɛ pílɛ pílɛ ɑ́kotokú kɛfi kumúŋɛ́ pɛɛ nté Upíimɑ nɛ kɛfɑ tɛnɛ pin kɔ irɔ́sé tíkilɛ̃ ńsɔnɛ. ");
INSERT INTO soy_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Pi kɔ pɛɛ pi símisilɛ rɛ pɔ yɛ Pisuifi pɛɛ mpuri sɑnɛ pikɔ́ kɛcɔpɛ ń we céésilɛ rɛ ɑ́pi kɑpɛ yɛ Moisi isé wɑisɛ, tɛ lɛ̃ nnyɑ, ɑ́pi kɑpɛ yɛ siwɑ̃́ tiké, ɑ́pi kɑpɛ yɛ kɔ inyɛ́kii wɑ. ");
INSERT INTO soy_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Tɔkɛ́ nkpéni ń-ye kpísi? Ḿpɑ́ likɛ́ íye wɑ, pi yɛ́ kṍ tɛ pɔ kɑ. ");
INSERT INTO soy_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Lɛ̃ nnyɑ, ɑ mmɛ̃ kɑri nní pɔ́ m mɑɑnɛ ritiki. Pitisi pinɑ pinyinɛ yɛ nté kɛrɔ́cɔpɛ welɛ pɛɛ rinɔ́ɔ n yekei rɛ pi yɛ́ pimɛcirɛ Uléécɑɑ pɑ. ");
INSERT INTO soy_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Pirinɔɔ tɛ̃ ituŋɛ yɛ tɔ́mpɔlɛ. A pi kpísi, nɔ́ nɛ pɛ̃ ɑni kɛsẽ́ píyufunɛ inyɔ́ɔnsɛ wɑi, ɑɑ lɛ̃ kɑpí nɛ n nyɔ́ɔnsɛnɛ kɛcɑ́ɑ́ hɛ́ɛ́lɛ. Kei kɛ pisoi ɑpi yɛ́ pɛɛ yɛ̃́ tɛ lɛ̃ kɑpi kɛpɔ́cɑ́ɑ́ n símɑɑnkɛɛ yɛ nnɔ́ɔmɛ lɛ, ɑpi kɔ yɛnu rɛ pɔ̃́ ticuruu yɛ Moisi isé tíkilɛnlɛ. ");
INSERT INTO soy_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Tɔ mpuri sɑnɛ pikɔ́ pɛɛ Kirisi pikɔ́ m pɑnsɛ pɔ̃́ títɛlɛ́ piwɔ́lɛ mɑsilɛ ɑri pi símisi rɛ tɔ símɑɑnɛlɛ ɑí tonɛ rɛ ɑ́pi kɑpɛ yɛ inyɔ́ɔnsɛsɑrɛ nɛ́ɛ mɛ́nyɛ li. Aɑpi kɑpɛ yɛ kɔ isɛɛ kɑ́pi rimpɑ́ piké mɛ́nyɛ lesɛ isɑrɛ li. Pikɛ́ kɔ pimɛcirɛ tĩ, ɑ́pi kɑpɛ iwɑ́sɑ́ n wɑi. ");
INSERT INTO soy_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Kɑi kóso n weesi, Pɔɔli uu pitisi pɛ̃ kpísi ɑpí hɑ kɛsẽ́ ɑkópɛ pihɛɛrɛ inyɛkii wɑi uu pɛɛ Uléécɑɑ kɛyɔ loni uu kumúŋɛ́ kpɛ-i kɛ inyɔ́ɔnsɛ tɔrɔɔ siyɑɑ ɑsí hɑ n tɛnɛnɛ pisoi símisi. ");
INSERT INTO soy_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Siyɑ́ɑ sisɛɛi sɛ̃ kɑpi yɛ nɛ ɑ́yu n fũ sin nɛ kɛtɔ́ŋɛ́ tuinɛ, Pisuifi pinyinɛ pɛɛ Asii kɛtẽ-pɔ n léeri ɑpi Uléécɑɑ kɛyɔ-i Pɔɔli yɛnu. Api pisoi nnɛ́í tɑ́lɑɑnkɛɛ ɑpi u tini. ");
INSERT INTO soy_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Apí n cɑ́ɑ́i rɛ: Isirɑyɛɛli pikɔ́, ɑni kɑm ɑni rɔ́ lɛ̃́! Usoi uyɛɛ ḿpɑ́ yei nɛ ḿpɑ́ úye Isirɑyɛɛli pikɔ́ kɛcɑ́ɑ́ nsímɛ́ kópɛ n símisi un kɔ tee rɛ úkɑ úu kɑpɛ yɛ Moisi isé nɛ Uléécɑɑ kɛyɔ nkɛ́ wɑisɛ yɛ nkó. U nkpéni ntɔ́rɔɔ sei nɛ Pikirɛki kei lonlɛ uu kɔ kɛlõ sɔnɛ kɛ̃ mɛ́kpɛrinkpɛ wɑisɛ. ");
INSERT INTO soy_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Pi pɛɛ kuyu kɛ́mɛɛ Pɔɔli nɛ Efɛɛsi ukɔ́ kɑpi yɛ n sée rɛ Turɔfim yɛnlɛ ɑpi pɛɛ́ m músu rɛ Pɔɔli yɛ nɛ Uléécɑɑ kɛyɔ u lompɔlɛ. ");
INSERT INTO soy_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Ai kuyu nnɛ́í nɔ́kɔrɛ, pisoi ɑpi ɑwɛ́lɛ́ nnɛ́í n léenti pin kɑ́lɑɑpɔ. Pisoi ɑpi Pɔɔli tini ɑpí nɛ Uléécɑɑ kɛyɔ iyɑɑ leepɔ ɑpi mɛsɛ nɛ mɛsɛ kɛ hɑ́nɛsi. ");
INSERT INTO soy_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Pin pɛɛ nkpéni nɑ́ɑ́si pikɛ́ u kpu. Nsímɛ́ nn Rɔm pisɔ́ɔ́cɑ uwɛ́ɛ́sɛ kutu-i loni rɛ Yerusɑlɛm kuyu nnɛ́í yɛ nɔkɔrɛ. ");
INSERT INTO soy_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Uyɛ̃ uu mɛsɛ nɛ mɛsɛ pisɔ́ɔ́cɑ kpéẽ nɛ pisɔ́ɔ́cɑ picɔ cɑ́pinɛ uú nɛ riwúí-mɛ̃ wurupɔ. Kɑpi usɔ́ɔ́cɑ wɛ́ɛ́sɛ nɛ pisɔ́ɔ́cɑ picɔ n yɛ̃́, ɑpi pɛɛ Pɔɔli ipépi yɑ́. ");
INSERT INTO soy_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Usɔ́ɔ́cɑ wɛ́ɛ́sɛ uyɛ̃ uu pɛɛ nyɔsɔ́pɔ uú nɛ Pɔɔli kɔ, uu u tini uu rinɔ́ɔ hɛ rɛ pikɛ́ ɑkpɑnii ɑtɛ́ nɛ u pɑɑsi. Uu pɛɛ pisoi pɛɛ n lémɑɑlɛ̃ pisɛ rɛ: Úye kɛcirɛ lo? Yo kuu mpíí wɑ? ");
INSERT INTO soy_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Amɑ́ pisoi ɑpi pɛɛ mɛ́woo nɛ mɛcɔ n cɑ́ɑ́i, úkɑ úu kɔ ucɔ nkɔ́ kómɛi. Usɔ́ɔ́cɑ wɛ́ɛ́sɛ úu pɛɛ ńkɑ kómɛi. Uu mɛsɛ upisɔ́ɔ́cɑ rinɔ́ɔ hɛ rɛ pikɛ́ Pɔɔli kpísi pikɛ́ nɛ pisɔ́ɔ́cɑ kɛyɔ hɑ. ");
INSERT INTO soy_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Kɛ Pɔɔli uu sitɑ́kui kɑpi yɛ nɛ kulee rińtɑɑ́ n tu, pisɔ́ɔ́cɑ ɑpi rikpɑ́kɑ́rɑ́ kɛ pisoi ɑpí nɛ u ń lɑ nnyɑ u sɑkɑɑ. ");
INSERT INTO soy_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Pisoi riwúí yɛ pɛɛ u tikilɛnlɛ pin cɑ́ɑ́i rɛ: Ani u kpu! ");
INSERT INTO soy_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Kɑpi ń lɑ pikɛ́ Pɔɔli nɛ pisɔ́ɔ́cɑ kɛyɔ lõ, uu usɔ́ɔ́cɑ wɛ́ɛ́sɛ pisɛ rɛ: Nɛ ncée mɑ́ kɛ́ símisii? Usɔ́ɔ́cɑ wɛ́ɛ́sɛ uu u pisɛ rɛ: Pɔ́ Mɛ́kirɛki kómɛilɛɛ? ");
INSERT INTO soy_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Lɛ̃ nnyɑ, ɑ́i pɔ́ɔ Esipiti ukɔ́ uyɛɛ sé nní ńcɔkɔi nɛ ń kɑ uu pisoi kṍ ɑ́kotokú ɑnɑ kpísi uú nɛ kucɛsi kóimɑ loni rɛ pikɛ́ ɑtɔpi u lɛ̃́ɛ? ");
INSERT INTO soy_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pɔɔli uu u pɛsɛ rɛ: Nɛ̃́ nɛ Usuifi lɛ. Silisii kɛtẽ-pɔ, Tɑrisi kuyu-i kɑpi nɛ́ mɑ́ri. Ḿpɑ́ yei-pɔ kɑku kɔ ríyu mɑ́. Nɛ pɔ́ we rɛ ɑ ncée nɛ́ hɛ kɛ́ risoiwuí ntí rinɔ́ɔ mɑɑ. ");
INSERT INTO soy_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Usɔ́ɔ́cɑ wɛ́ɛ́sɛ uu ncée u hɛ rɛ ukɛ́ símisi. Pɔɔli uu sitɑ́kui kɛcɑ́ɑ́ nyɛrɛ uu pisoi pɛ̃ kunípɛ síkɑ rɛ pikɛ́ risɛ́ɛ́. Api pinnɛ́í sɛ́ɛ́ keu. Pɔɔli uu pɛɛ pimɛyu kɑpi yɛ n sée rɛ Mɛ́-epiree nɛ rinɔ́ɔ pi mɑɑ rɛ: ");
INSERT INTO soy_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Pinɛ́sɑ́ɑ nɛ pinɛ́mɑ́rɛcɔ, nɛ lɑ kɛ́ nkpéni rinɛ́yu hɛɛrɛ. ");
INSERT INTO soy_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Kɑpi n céri rɛ pimɛyu kɑpi yɛ n sée rɛ Mɛ́-epiree kuú nɛ pi símisi, ɑpi pisɛ́ɛ́ nyɔ́ɔnsɛ. Uu rɛ: ");
INSERT INTO soy_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Nɛ Usuifi lɛ, Silisii kɛtẽ-pɔ, Tɑrisi kuyu-i kɑpi nɛ́ mɑ́ri. Amɑ́ Yerusɑlɛm nté kɑpi nɛ́ rimúlú. Kɑmɑliyɛɛli yɛɛ pɛɛ unɛ́célɑɑ. Uyɛɛ nɛ́ céesi lɛ̃ kɑm yɛ́ pirɔ́sɑ́ɑ isé rintíki kélé-kélé. Ám yɛ pɛɛ Uléécɑɑ likɔ́ nɛ ɑkpɛ́ri wɑ, yɑrɛ kɑ́ni yɛ nní nɛ ɑkpɛ́ri li n wɑ mɛcɔ. ");
INSERT INTO soy_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Nɛ yɛ pɛpɛɛ Yeesu n tíkilɛ̃ n wéékusɛlɛnlɛ ɑḿ hɑ nɛ pi kóni. Nɛ yɛ pɛɛ pitisi nɛ pinɔ́si cɔ́piilɛ ɑm pɑhɑɑnkɛɛ ɑm kukpɑniilee wɑi. ");
INSERT INTO soy_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Uléécɑɑ usinɑ nɛ kuyu piwɛ́ɛ́sɛ yɛ́ fe ɑpí nɛ nnɛ́nɔ́ɔ símisi rɛ ɑ́m kirɑɑsɛ. Piricuruu yɛ ɑ́tɛlɛ́ nɛ Tɑmɑɑsi nɛ́ tumɑɑlɛnlɛ rɛ kɛ́ fe kɛ́ Yeesu pikɔ́ pɛɛ kei ń we cɔ́pii kɛ́ pɑhɑɑnkɛɛ kɛ́ nɛ Yerusɑlɛm hɑ kɛ́ hɑ íwɛ pi wɑ. ");
INSERT INTO soy_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Kɑm pɛɛ kɛyɑ́ɑ kɛnyinɛ ncée kpísi, kɛ́ nɛ Tɑmɑɑsi n nyɑhɑipɔ, ituŋɛ in lɑ ikɛ́ kɛcírɛ tu. Kei kɛ mɛtɛ́í píimɑ mɛnyinɛ ɑmɛ kɛyómɛcɑɑ-pɔ mɛsɛ nɛ mɛsɛ leemɛ ɑmɛ tɑpu ɑmɛ́ nɛ nɛ́ kɔ́ɔ́nú. ");
INSERT INTO soy_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Am kɛteni-i lólu, ɑm kóm lin nɛ́ tee rɛ: Sɔɔli, Sɔɔli, yo kɛcirɛ nnyɑ kɑɑ lɛ̃ nɛ́ wéékusɛlɛ̃? ");
INSERT INTO soy_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Am pɛɛ pisɛ rɛ: Pɔ́ɔ úye, Upíimɑ? Uu rinɔ́ɔ nɛ́ yɔ́su rɛ: Nɛ́ɛ Nɑsɑrɛti ukɔ́ Yeesu kɑɑ nní ń we pɔn wéékusɛlɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Pinɛ́séncɔ ɑpi mɛtɛ́í mɛ̃ yɛnu, ɑmɑ́ ɑ́pi pɛɛ uyɛɛ nɛ nɛ́ n símisi rinɔɔ ríkɑ kõ. Kei kɑm pɛɛ rɛ: ");
INSERT INTO soy_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Kɛ́ íye wɑ, Upíimɑ? Upíimɑ uu nɛ́ pɛsɛ rɛ: A yisi, ɑ Tɑmɑɑsi hɑ. Pi yɛ́ hɑ kei-pɔ pɔ́ símisi lɛ̃ kɑɑ yɛ́ n wɑ. ");
INSERT INTO soy_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Kɛ mɛtɛ́í píimɑ mɛ̃ ɑmɛ nɛ́ n nyíinsɛ nnyɑ, pinɛ́séncɔ ɑpi kunípɛ nɛ́ múlú ɑpi tɔ́rɔi ɑpí nɛ Tɑmɑɑsi sĩ. ");
INSERT INTO soy_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Utisi unyinɛ yɛ pɛɛ kei welɛ ɑpi yɛ u séi rɛ Anɑniyɑsi. U pɛɛ Uléécɑɑ isé tíkilɛnlɛ ńsɔnɛ. Pisuifi nnɛ́í pɛɛ Tɑmɑɑsi-i ń we yɛ pɛɛ ukɛcɑ́ɑ́ ɑnɔ́ɔ sɔnɛ símisilɛ. ");
INSERT INTO soy_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Uu kɛnɛ́kúrí weri uu nɛ́ mɑɑ rɛ: Unɛ́mɑ́rɛcɔ Sɔɔli, ipɔ́nípɛɛ ikɛ́ nkpéni wúkulɛ. Kei nní kɛ inɛ́nípɛɛ ii wúkulɛ ɑm u yɛnu. ");
INSERT INTO soy_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Uu kɔ kpɑ́ rɛ: Pirɔ́sɑ́ɑ Uleecɑɑ yɛ tíyɛsɛlɛ rɛ ɑ umɛlɑ ceri ɑɑ kɔ ɑsei ute ceru ɑɑ liute nkɔ́ kóm, ");
INSERT INTO soy_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","tɛ li we rɛ pɔ́ɔ yɛ́ mɑsí pisoi nnɛ́í inipɛɛ-i uiseérɑkɔɔ́ li ɑɑ lɛ̃ kɑɑ n yɛ̃́ nɛ kɑɑ n kṍ pi símisi. ");
INSERT INTO soy_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Uu pɛɛ nɛ́ pisɛ rɛ: Yo nnyɑ kɑɑ nkpéni kɔ pɛɛ nɑ́ŋɑisɛ? A yisi pikɛ́ míni pɔ́ wolɛ ɑɑ Yeesu rinyiri séi ukɛ́ ɑpɔ́kópɛ pɔ́ sɑ́rɛi. ");
INSERT INTO soy_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Pɔɔli uu kɔ kpɑ́ rɛ: Kɑm Yerusɑlɛm m pɛlɛ, nɛ Uléécɑɑ kɛyɔ-i hɑlɛ ɑm kɛyómɛ yɑ́ɑ́si. Kɑm ń we nɛn kɛyómɛ yɑ́ɑ́si, ɑm lólu yɑrɛ kɛnípɛɛhee kɛɛ nɛ́ tĩ́. ");
INSERT INTO soy_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Upíimɑ kɑm yɛ̃́ uu nɛ́ mɑɑ rɛ: A mɛkɛɛ Yerusɑlɛm kuyu-i le. Pisuifi ɑ́pi yɛ́ mmɛ̃ kɑɑ kɛnɛ́cɑ́ɑ́ n símisinɛ ŋmurɛi. ");
INSERT INTO soy_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Kei kɑm pɛɛ u pɛsɛ rɛ: Piricuruu yɛ nyulɛ, Upíimɑ rɛ nɛ pɛɛ Pisuifi ɑyomɛyɑ́hɑɑlee kɑlɛnlɛ nɛn pɛpɛɛ pɔ́ n tíkilɛ̃ cɔ́pii nɛn kukpɑniilee wɑi nɛn kɔ pi kɑiinkɛɛ. ");
INSERT INTO soy_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Tinɛ́cúruu yɛ pɛɛ welɛ kumúŋɛ́ kpɛ-i kɑpí pɛɛ úseérɑkɔɔ́ Etiyɛɛni mɛnyɛ n kɔɔni. Pimɛwɑi mɛɛ pɛɛ́ nɛ nɛ́ risɑ́lɛ ɑm pɛpɛɛ nní u n kópu ilũ múlú. ");
INSERT INTO soy_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Upíimɑ uu pɛɛ nɛ́ mɑɑ rɛ: A yisi, kɛtɑɑ-pɔ kɑḿ lɑ kɛ́ pɔ́ tũ, mpuri sɑnɛ pikɔ́ kɛ́mɛɛ. ");
INSERT INTO soy_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Pisoi riwúí tɛ̃ ɑri Pɔɔli kutu n cɔlɛ̃ ɑí nɛ kumúŋɛ́ kpɛ-i kuu ɑnɔ́ɔ nyɛ̃ ḿ mɑ tulu. Kei kɑpi sicɑ́ɑ́ilɑ lõ tɛ: Ani kpu. Ái nɛ sɑ́ rɛ nkó ukɛ́ nfɑ́ɑ m mɑ́! ");
INSERT INTO soy_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ai kuwɔ́i pi wɑi ɑpi pɛɛ m pupukɛɛ pin piilũ mɑ́hɑni pin fóŋɛɛ pin nkoŋo yukusɛ. ");
INSERT INTO soy_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Kei kɛ Rɔm pisɔ́ɔ́cɑ uwɛ́ɛ́sɛ uu pɛɛ rinɔ́ɔ hɛ rɛ pikɛ́ Pɔɔli nɛ pisɔ́ɔ́cɑ kɛkɑlɛ-i lompɔ pikɛ́ isɛ́í u súúkɛɛ ukɛ́ símisi úu lɑ. Pɛɛ́ uyɛ-i, pi yɛ́ pɛɛ céri lɛ̃ nnyɑ kɛ pisoi ɑpi n cɑ́ɑ́i pin nɛ u téni. ");
INSERT INTO soy_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Amɑ́ kɑpi u m pɑɑsi rɛ pikɛ́ u kɑii, uu usɔ́ɔ́cɑ kpéẽ pisɛ rɛ: Nɔ ncée mɑ́ rɛ nɔkɛ́ Rɔm kɛtẽ ukɔ́ kɛ nsímɛ́ ńn kɑhɑnɛ n kpu isɛ́í súúkɛɛ? ");
INSERT INTO soy_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Kɛ usɔ́ɔ́cɑ kpéẽ uyɛ̃ uu lɛ̃ n kṍ, uu sĩ́ uú hɑ usɔ́ɔ́cɑ wɛ́ɛ́sɛ símisi rɛ: Usoi uyɛɛ Rɔm ukɔ́ lɛ, íye kɑɑ nkpéni wɑinɛ? ");
INSERT INTO soy_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Kei kɛ usɔ́ɔ́cɑ wɛ́ɛ́sɛ uyɛ̃ uu pɛɛ Pɔɔli kɛkúrí hɑ́pɔ uu u pisɛ rɛ: A nɛ́ símisi kɛ́ kṍ tɛ pɔ Rɔm ukɔ́ lɛɛ. Pɔɔli uu rɛ: Ɛɛɛ! ");
INSERT INTO soy_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Usɔ́ɔ́cɑ wɛ́ɛ́sɛ uu kɔ kpɑ́ rɛ: Siwóó píimɑ kɛ nɛ́ɛ hɛ́ɛlɛ ɑḿ nɛ pɑnsɛ kɛyupipi. Pɔɔli uu rɛ: Nɛ̃́ nɛ hɑ́i kɛnɛ́mɑrɛ-mɛ kɛyupipi lɛ. ");
INSERT INTO soy_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Pɛpɛɛ pɛɛ ń lɑ pikɛ́ u n kɑ́ii ukɛ́ símisi ɑpi mɛsɛ nɛ mɛsɛ ukɛkúrí yisi. Iwɑmɛ ii usɔ́ɔ́cɑ wɛ́ɛ́sɛ ricuruu loni, kuu n yɛ̃́ tɛ u tíyɛsɛ ɑpi Pɔɔli pɑɑsi ɑpi kɑ́ii un kɔ nɛ Rɔm ukɔ́ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Kɑi kóso n weesi, usɔ́ɔ́cɑ wɛ́ɛ́sɛ uú n lɑ ukɛ́ yɛ̃́ lɛ̃ kɛ Pɔɔli uu n wɑ kɛ Pisuifi ɑpí nɛ pitele u n sɛ́lɛ̃. Uu ɑkpɑnii kɛ́mɛɛ u lesɛ uu pɛɛ rinɔ́ɔ hɛ rɛ pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ nɛ pitúhɑɑnɛ píimɑ nnɛ́í pikɛ́ cɑ́pinɛ. Uu pɛɛ tíyɛsɛ ɑpí nɛ Pɔɔli hɑpɔ uu pikɛcɔpɛ u nyɛrɛsɛ. ");
INSERT INTO soy_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pɔɔli uu pitúhɑɑnɛ píimɑ pɛ̃ inípɛɛ tɑpu uu pɛɛ rɛ: Pimɑ́rɛcɔ, nɛ inɛ́soi kɛ́mɛɛ Uléécɑɑ inipɛɛ-i ńsɔnɛ kɛisilɛ hɑ́i nɛ nɛni-mɛ. Kɛfɑ kɛsɛ kɑḿ nɛ u tikilɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Kei kɛ Uléécɑɑ usinɑ Anɑniyɑsi uu pɛɛ pɛpɛɛ Pɔɔli kɛkúrí ń we rinɔ́ɔ hɛ rɛ pikɛ́ nnɔ́ɔ kɛcɑ́ɑ́ u pi. ");
INSERT INTO soy_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Pɔɔli uu pɛɛ rɛ: Pɔ̃́ kɛ Uléécɑɑ uu pépunɛ, pɔ́ mmɛlɛ tomɛ́ mmú. Pɔ kei tũ tɛ pɔkɛ́ isé ritiki pɔkɛ́ nɛ nɛ́ túhɑɑnɛ, ɑ́i pɔkɛ́ isé rikɛ́ŋɛ́ɛ́ ɑɑ rinɔ́ɔ hɛ rɛ pikɛ́ nɛ́ kɑ́ii! ");
INSERT INTO soy_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Pɛpɛɛ nɛ u n kɔ́lɛ̃ ɑpi rɛ: Uléécɑɑ usinɑ yɛɛ Uléécɑɑ pikɛi n wɑi kɑɑ nní lɑ́mɑɑnkɛɛ! ");
INSERT INTO soy_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pɔɔli uu rɛ: Ám nyu rɛ Uléécɑɑ usinɑ lo, pimɑ́rɛcɔ. Li Uléécɑɑ ritɛlɛ́-i wɔ́lɑɑlɛ̃ tɛ kɑpɛ kupɔ́yu uyukɔɔ́ kɛcɑ́ɑ́ nkópɛ n símɑɑnkɛɛ. ");
INSERT INTO soy_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Pɔɔli yɛ pɛɛ picére mɑ́ɑ́lɛnlɛ rɛ Pisɑtusee nɛ Pifɑrisi pɛɛ kɛtúhɑɑnɛ kɛ-i kɛsẽ́ we. Lɛ̃ nnyɑ kuu kɛtúhɑɑnɛ kɛ-i ricɑ́ɑ́i rɛ: Nɛ Ufɑrisi lɛ, pimɑ́rɛcɔ! Unɛ́sɑ́ɑ pɔ̃́ kɔ Ufɑrisi. Kɑm n tɑ́lɛ̃ tɛ Uléécɑɑ yɛ nkpɔ kɛ́mɛɛ pikpɔkpɔ yukusɛnɛ nnyɑ kɑpí nɛ nté nɛ́ túhɑɑnɛ. ");
INSERT INTO soy_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Ukɛ́ nɛ lɛ̃ pimɑ́ɑ ḿ mɑsí, Pifɑrisi nɛ Pisɑtusee pin nsímɛ́ pipɑ́sɑinɛ rikɑ́pɑ́ɑ́, pisoi ɑpi kénɛ, ḿpɑ́ píye nɛ pikunɑi. ");
INSERT INTO soy_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Pisɑtusee ɑ́pi yɛ ŋmurɛi rɛ pikpɔkpɔ yɛ̀ɛ̀ nkpɔ kɛ́mɛɛ yisi, ɑ́pi yɛ kɔ ŋmurɛi rɛ piléécɑɑtumɛ nɛ lifɑ́ɑkɔ́ lɛɛ ɑ́i nní kúyɛnɛ ń we yɛ we. Amɑ́ Pifɑrisi pɔ̃́ nɛ yɛ linnɛ́í ŋmurɛilɛ. ");
INSERT INTO soy_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Iwɔ́ɔ ii cɔni, isé picélɑɑ pinyinɛ pɛɛ Pifɑrisi kunɑi-mɛ̃ ń we ɑpi yisi ɑpi kɛ́su ɑpí nɛ kɛtẽ kpɛɛni ɑpi rɛ: Ári usoi nkó nkópɛ ńkɑ nyɑ́ni. In n lɑ, lifɑ́ɑkɔ́ lɛɛ ɑ́i kúyɛnɛ ń we nɛ́ɛ uléécɑɑtumɛ unyinɛ yɛɛ nɛ u símisi. ");
INSERT INTO soy_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Iwɔ́ɔ ií tɑɑ́, hɑ́i ɑí nɛ usɔ́ɔ́cɑ wɛ́ɛ́sɛ iwɑmɛ wɑi rɛ ɑ́pi kɑpɛ nté lɛ̃ n wɑi ɑpí nɛ Pɔɔli cɛ́ɛ́riinɛ. Uu lɛ̃ nnyɑ pisɔ́ɔ́cɑ rinɔ́ɔ hɛ rɛ pikɛ́ riwúí-i lompɔ pikɛ́ Pɔɔli lesɛpɔ pikɛ́ nɛ pisɔ́ɔ́cɑ kɛkɑlɛ u hɑ. ");
INSERT INTO soy_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Kɛsinɛ ɑkɛ wɑi, Upíimɑ uu Pɔɔli kɛkúrí nyɔsɔ́pɔ uu rɛ: A ikɑri wɑ. Lɛ̃ kɑɑ nní Yerusɑlɛm nté inɛ́seérɑkɔɔ́ n li, li we rɛ pɔkɛ́ limɛcɔ Rɔm-pɔ i li. ");
INSERT INTO soy_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Kɑi kóso n weesi, Pisuifi pinyinɛ ɑpi cɑ́pinɛ ɑpí ŋmulɑɑnɛ ɑpi Uléécɑɑ kɛyu-i wééri rɛ pinsɑ́ Pɔɔli n kpu, ɑ́pi líkɑ mɛlélé mɑ́. ");
INSERT INTO soy_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Pɛpɛɛ lɛ̃ tińŋmulɑɑnɛ yɛ pisoi ɑfɛɛnɑ rifɑɑulɛ. ");
INSERT INTO soy_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Api yisi ɑpí hɑ pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ nɛ kuyu piwɛ́ɛ́sɛ lɛɛpɔ, ɑpi pi mɑɑ rɛ: Tɔ mɛrɔ́círɛ kpísilɛ ɑri hɛ, ɑri Uléécɑɑ kɛyu-i wééri rɛ tɔnsɑ́ Pɔɔli n kpu, ɑ́ri líkɑ mɛlélé mɑ́. ");
INSERT INTO soy_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Lɛ̃ nnyɑ, nɔ́ nɛ pitúhɑɑnɛ tɔrɔɔ, ɑni ńsɔnɛ kómɛinɛ, ɑni kpɑ́rɑ́ ɑní hɑ usɔ́ɔ́cɑ wɛ́ɛ́sɛ pisɛ rɛ ukɛ́ nɛ Pɔɔli nɔ́ kɑm nɔkɛ́ nsímɛ́ mmɛ̃ tipérésɛ nɔkɛ́ yɛ̃́ nkɛ̃́. Tɔ̃́ nɛ mɛrɔ́círɛ picɑ́pinɛ mɑ́ɑ́lɛnlɛ rɛ tɔkɛ́ ncée u riké tɔkɛ́ u kpu. ");
INSERT INTO soy_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Kei kɛ Pɔɔli umɛrɛpi unyinɛ uu nsímɛ́ mmɛ̃ kõ, uu yisi uu pisɔ́ɔ́cɑ kɛkɑlɛ sĩ, uu lompɔ uú hɑ Pɔɔli kutu-i wɑi. ");
INSERT INTO soy_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Pɔɔli uu pɛɛ usɔ́ɔ́cɑ kpéẽ usɛ séi uu u mɑɑ rɛ: A uŋmɑ́nɛ nkó usɔ́ɔ́cɑ wɛ́ɛ́sɛ kɛ́mɛɛ sɑ́rumpɔ. U lɑlɛ ukɛ́ nnyinɛ u símisi! ");
INSERT INTO soy_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Usɔ́ɔ́cɑ kpéẽ uyɛ̃ uú nɛ usɔ́ɔ́cɑ wɛ́ɛ́sɛ kɛ́mɛɛ Pɔɔli umɛrɛpi sĩ uú hɑ rɛ: Ukpɑniikɔ́ Pɔɔli yɛɛ nɛ́ sée uu nɛ́ mɑɑ rɛ kɛ́ uŋmɑ́nɛ nkó nɛ kɛpɔ́mɛɛ kɑm tɛ u nnyinɛ mɑ́lɛ ukɛ́ pɔ́ símisi. ");
INSERT INTO soy_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Kei kɛ usɔ́ɔ́cɑ wɛ́ɛ́sɛ uyɛ̃ uu uŋmɑ́nɛ uyɛ̃ sée, uu kunípɛ u tini ɑpí nɛ iyɑɑ leepɔ. Uu pɛɛ u pisɛ rɛ: Ń-ye kɑɑ́ lɑ pɔkɛ́ nɛ́ símisi? ");
INSERT INTO soy_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Uŋmɑ́nɛ uyɛ̃ uu rɛ: Pisuifi pɛɛ rinɔ́ɔ risɛ wɑ rɛ pikɛ́ rikpɑ́rɑ́ pikɛ́ kóso pɔ́ pisɛ rɛ ɑ Pɔɔli nɛ kɛtúhɑɑnɛ píimɑ-i hɑpɔ kɛkɛ́ unsímɛ́ mmɛ̃ ńsɔnɛ ripérésɛ pikɛ́ yɛ̃́ nkɛ̃́. ");
INSERT INTO soy_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Pin n kɑ, kɑpɛ nɛ kutu pi ricɔ. Li we rɛ pikɛcɔpɛ, pisoi yɛ ɑfɛɛnɑ rifɑɑu pɛɛ ń lɑ pikɛ́ Pɔɔli tĩ. Pi wéérilɛ rɛ pinsɑ́ u n kpu, ɑ́pi líkɑ mɛlukɛ nɛ́ɛ mɛnírɛ́ mɑ́. Pi pimɛcirɛ picɑ́pinɛ mɑ́ɑ́lɛnlɛ, tipɔ́nɔ́ɔ ŋmɑnɛ kɑpi nkpéni mɛ̃́. ");
INSERT INTO soy_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Usɔ́ɔ́cɑ wɛ́ɛ́sɛ uu pɛɛ uŋmɑ́nɛ uyɛ̃ mɑɑ rɛ: Kɑpɛ tíyɛ unyinɛ ukɛ́ kṍ tɛ pɔ mmú nɛ́ símisi. Uu pɛɛ rɛ ukɛ́ nkpéni n ŋme ukɛ́ tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Usɔ́ɔ́cɑ wɛ́ɛ́sɛ uu pɛɛ limɛmɑ́ɑ́ pisɔ́ɔ́cɑ kpéẽ pitɛ́ séi uu pi mɑɑ rɛ: Ani pisɔ́ɔ́cɑ pílɛ pílɛ mɛtɛ́ nɛ pisɑntonɛ kuwóó nɛ ɑfɛɛrɛ́ nɛ pipɑ́ŋ́kɔɔ́ pílɛ pílɛ mɛtɛ́ cɑ́pinɛ pikɛ́ n nyu rɛ pi yɛ́ fe ɑpi kɛsinɛ mɛsɛ ɑ́mɛ we kɛfi kumúŋɛ́ Sesɑree tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Ani kɔ isɑ̃ nyɔ́ɔnsɛ yɛɛ yɛ́ nɛ uyɔ́ɔpi píimɑ Felikisi kɛ́mɛɛ Pɔɔli n tu líkɑ ɑ́i yɛ́ u n wɑ. ");
INSERT INTO soy_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Usɔ́ɔ́cɑ wɛ́ɛ́sɛ uu kɔ rítɛlɛ́ wɔ́lu uu pi múísɛ rɛ pikɛ́ hɑ Felikisi pɑ. Lɛ̃ kuu n wɔ́i yɛ nní. ");
INSERT INTO soy_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Nɛ pɔ́ yɑ́ɑsi, Upíimɑ Felikisi. Nɛ́ɛ Kulooti Lisiyɑɑsi. Nɛ́ɛ rítɛlɛ́ ntí pɔ́ wɔ́lu. ");
INSERT INTO soy_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Pisuifi yɛ usoi nkó kɑm nní pɔ́ m pɑ́pɔlɛ̃ tinlɛ rɛ pikɛ́ u kpu. Kei kɑm pɛɛ kṍ tɛ u Rɔm kɛtẽ ukɔ́ lɛ, ɑm pɛɛ́ nɛ pinɛ́sɔ́ɔ́cɑ hɑpɔ ɑm u comɛ. ");
INSERT INTO soy_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Am pɛɛ rɛ kɛ́ kṍ tɛ ń-ye kɛcirɛ kɛ Pisuifi ɑpí nɛ u cɛ́si, ɑm pɛɛ u kpísi ɑḿ nɛ pikɛtúhɑɑnɛ píimɑ sĩ. ");
INSERT INTO soy_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Kei kɑm pɛɛ céri rɛ piisé kɛcɑ́ɑ́ kɑpi nsímɛ́ pɑ́sɑinɛ. Ám unkópɛ ńkɑ yɛ̃ kɑpi yɛ́ nɛ usoi ń kpu nɛ́ɛ kɑpi yɛ́ nɛ ɑkpɑnii u n wɑ. ");
INSERT INTO soy_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Am kɔ limɛmɑ́ɑ́ kóm tɛ Pisuifi yɛ ŋmúlɑɑnkɛɛ rɛ pi yɛ́ u kpu. Lɛ̃ nnyɑ kɑm mɛsɛ nɛ mɛsɛ pɔ́ u pɑpɔlɛ̃, ɑm kɔ upiteecɔ símisi rɛ pikɛ́ hɑ kɛpɔ́mɛɛ kɛtɑhɑi u sée. ");
INSERT INTO soy_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Pisɔ́ɔ́cɑ ɑpi usɔ́ɔ́cɑ wɛ́ɛ́sɛ rinɔɔ kuu n hɛ tiki, ɑpi Pɔɔli kpísi ɑpi kɛsinɛ nɛ Antipɑtiriisi u tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Kɑi kóso n weesi, pisɔ́ɔ́cɑ pɛɛ ɑ́nɑ n sɔ́nɛ ɑpi pikɛkɑlɛ-i pɛɛsɛ, pisɑntonɛ ŋmɑnɛ ɑpí nɛ Pɔɔli tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Kɑpi Sesɑree n tuipɔ, pisɑntonɛ ɑpi rítɛlɛ́ uyɔ́ɔpi píimɑ Felikisi pɑ, ɑpi kɔ Pɔɔli u nyísɛ. ");
INSERT INTO soy_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Kɛ uyɔ́ɔpi píimɑ uu rítɛlɛ́ pikɛ́ɛ̃ ḿ mɑsí, uu Pɔɔli pisɛ rɛ u kuwɛ́lɛ́ kúye ukɔ́ lɛ? Kuu n kṍ tɛ Silisii ukɔ́ lo, ");
INSERT INTO soy_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","uu u mɑɑ rɛ: Pipɔ́teecɔ pin n kɑ, nɛ́ pɛɛ pɔ́ písɛisɛ ɑm kóm. Uu pɛɛ rinɔ́ɔ hɛ rɛ pikɛ́ Pɔɔli kpísi pikɛ́ hɑ Erooti kɛyɔ-pɔ hɑ́nɛsi. ");
INSERT INTO soy_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Ai wɑi siyɑ́ɑ sinupũ, Uléécɑɑ usinɑ Anɑniyɑsi nɛ kuyu piwɛ́ɛ́sɛ pinyinɛ nɛ usímɛ́yɔɔ́ unyinɛ kɑpi yɛ n sée rɛ Tɛrituluusi ɑpi Sesɑree-i hɑpɔ. Api uyɔ́ɔpi píimɑ Felikisi-i sĩ́ tɛ pikɛ́ hɑ Pɔɔli kɛtɑhɑi sée. ");
INSERT INTO soy_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Uyɔ́ɔpi uu Pɔɔli séipɔ, Tɛrituluusi uu yisi uu picɛ́ u kɑ́pɑ́ɑ́, uu uyɔ́ɔpi mɑɑ rɛ: Urɔ́sɑ́ɑ, uyɔ́ɔpi píimɑ! Pɔ́ɔ tíyɛsɛ kɑri nkíŋniŋɛ-i we hɑ́i ɑ́i nɛni-mɛ. Kɛtẽ kɑɑ ńsɔnɛ m múílɛ̃ nnyɑ kɛ nconsɛ mɛyɑ̃ nn kɛrɔ́tẽ nkɛ́ kɛcɑ́ɑ́ wɑ rɛ likɛ́ nɛ kɛ sɔnɛsi. ");
INSERT INTO soy_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Tɔ pɑkɑrɛ! Nɛ pipɔ́kɛi nɛ lɛ̃ kɑɑ mɛsɛ́rɛ nɛ ḿpɑ́ yei rɔ́ n wɑi. ");
INSERT INTO soy_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Ám lɑ kɛ́ kɔ picɔ́ŋ pɔ́ rikpɑ́. Amɑ́ nɛ rikɔ́ŋ pɔ́ wúkulɛ rɛ ɑ kɔ nɛ kɛfɑ rɔ́ fénnɛ, ɑɑ nkɑ́ripi kutu rɔ́ cɔ. ");
INSERT INTO soy_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Tɔ yɛ̃ tɛ utisi nkó yɛ likpɑ́ɑ́ree linyinɛ lɛ. Uyɛɛ Nɑsɑrɛti pikɔ́ mɛkóólɛ icɑ́pinɛ uyukɔɔ́. Kɛtẽ nnɛ́í Pisuifi kɛcɔpɛ kuu ńcɔkɔi tɑnɑɑlɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Ticuruu u pɛɛ nɑ́ɑ́silɛ ukɛ́ Uléécɑɑ kɛyɔ mɛ́kpɛrinkpɛ wɑisɛ, kɑri pɛɛ́ nɛ u tĩ. Tɔ pɛɛ́ lɑlɛ tɔkɛ́ nɛ u túhɑɑnɛ yɑrɛ kɛ irɔ́sé ii m pisɛ. ");
INSERT INTO soy_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Amɑ́ usɔ́ɔ́cɑ wɛ́ɛ́sɛ Lisiyɑɑsi uú weri uú nɛ ńnɑŋɛ ɑrɔ́nípɛ-i u yɔ́su. ");
INSERT INTO soy_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Uu pɛɛ Pɔɔli piteecɔ pɛ̃ mɑɑ rɛ pikɛ́ nɛ nsímɛ́ pɔ́ lɛɛmɛ. Pɔn tipɔ́cúruu Pɔɔli m písɛisɛ, pɔ́ yɛ̃́ tɛ mmɛ̃ kɑrí nɛ u n cɛ́si yɛ ɑsei lɛ. ");
INSERT INTO soy_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Pisuifi tɔrɔɔ ɑpi yisi ɑpi Tɛrituluusi kɛcɑ́ɑ́ kpɑ́ ɑpi rɛ mɛsei, lɛ̃ kɑi li. ");
INSERT INTO soy_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Kei kɛ uyɔ́ɔpi píimɑ Felikisi uu pɛɛ́ nɛ kunípɛ Pɔɔli rinɔ́ɔ hɛ rɛ ukɛ́ unkɔ́ símisi. Pɔɔli uu rɛ: Urɔ́sɑ́ɑ uyɔ́ɔpi, nɛ nyulɛ rɛ hɑ́i ɑ́i nɛni-mɛ kɑɑ kɛrɔ́tẽ nkɛ́ kɛcɑ́ɑ́ itúhɑɑnɛ le. Lɛ̃ nnyɑ kɑḿ nɛ kɛfɑ kɛsɛ kɛpɔ́yu-i rinɛ́yu hɛɛrɛnɛ. ");
INSERT INTO soy_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Pɔ́ fe ɑɑ ripɔ́cúruu pisɛ ɑɑ kóm tɛ kɑḿ nɛ Yerusɑlɛm-i ń kɑ, siyɑ́ɑ kɛfi nɛ sitɛ́ yɛ nsí. Uléécɑɑ kɑm piyɑ́hɑɑ kɑ. ");
INSERT INTO soy_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Úkɑ úu kɛyɑ́ɑ kɛnyinɛ nɛ́ lɛɛpɔ, tɔ́ nɛ unyinɛ tɔn Uléécɑɑ kɛyɔ-i nɛ́ɛ kuyómɛyɑ́hɑɑlee-i nɛ́ɛ kuyu-i we tɔn yɔ́i nɛ́ɛ tɔn pisoi kupɑkɑrɛcirɛ́ tɑ́lɑɑnkɛɛ. ");
INSERT INTO soy_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Pisoi mpí ɑ́pi yɛ́ ńkɑ yɛ̃ pikɛ́ rɛ mmɛ̃ kɑpí nɛ nkpéni nté nɛ́ cɛ́si. ");
INSERT INTO soy_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Amɑ́ nɛ́ kɛpɔ́yu-i ɑsei símisi rɛ nɛ ncée fɑlɛ mmɛ̃ kɑpi nní n kpíilɛ̃ tɛ mɛkóólɛ icɑ́pinɛ ukɔ́ lɛ. Amɑ́ pirɔ́sɑ́ɑ Uleecɑɑ kɑm pɛɛ yɑ́ɑ́si nɛn kɔ lɛ̃ nnɛ́í lɛɛ isé nɛ ɑntepuyɛ ɑtɛlɛ́ kɛ́mɛɛ n wɔ́lɑɑlɛ̃ nɛ kɛfɑ tɛnɛlɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Lɛ̃ kɑm n tɑ́lɛ̃ kɛ pɛ̃ ticuruu pɔ́ɔ kɔ tɑ́lɛ̃ tɛ Uléécɑɑ yɛ pisoi sɔnɛ nɛ pikópɛ pɛɛ n kpí nkpɔ kɛ́mɛɛ yukusɛ. ");
INSERT INTO soy_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Lɛ̃ nnyɑ kɑm mɛsɛ́rɛ ŋmɔ́ɔ́púlɛ̃ tɛ kɛ́ Uléécɑɑ n tikilɛ̃ nɛ kɛfɑ kɛsɛ. ");
INSERT INTO soy_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Kɑḿ nɛ nté n yisi, li iŋmɛ̃ kulúi wɑlɛ. Nɛ nɛni pɛɛmɛ rɛ kɛ́ nnɛ́puri pikɔ́ linyinɛ hɛ, kɛ́ kɔ nyɔ́ɔnsɛ kɛ́ nɛ Uléécɑɑ yɑ́ɑ́si. ");
INSERT INTO soy_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Lɛ̃ kɑḿ pɛɛ́ nɛ Uléécɑɑ kɛyɔ-i kpɑrɑ́lɛ̃ kɑpí nɛ nɛ́ lɛɛpɔ, nɛn ɑkópɛ pihɛɛrɛ inyɛkii piwɑi mɑ́ɑmɛ. Tisoiwuí ríkɑ ɑ́ri pɛɛ kɛnɛ́kúrí cɑ́pinɛlɛ̃. Ám kɔ pɛɛ ńcɔkɔi ńkɑ wɑi. ");
INSERT INTO soy_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Pisuifi pinyinɛ pɛɛ Asii kɛtẽ-pɔ leemɛ ɑpi kei nɛ́ lɛɛri. In pɛpɛɛ pɛɛ nnyinɛ mɑ́ pikɛ́ nɛ nɛ́ cɛ́si, pɛ̃ kɑi pɛɛ́ nɛ sɑ́ rɛ pikɛ́ kɛpɔ́mɛɛ kɑm. ");
INSERT INTO soy_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Nɛ́ɛ pɛpɛɛ nté nní ń we pikɛ́ símisi nkɛ̃́ tɛ kɑri kɛtúhɑɑnɛ píimɑ-i pitúhɑɑnɛ ń hɑ, nkópɛ ń-ye kɑpi kɛnɛ́cɑ́ɑ́ yɛ̃́? ");
INSERT INTO soy_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Nɛ́ɛ nnɛ́kópɛ kɑm nɛni n wɑ mɛɛ lɛ̃ kɑm kɛtúhɑɑnɛ kɛcɔpɛ rin-yóó rɛ: Kɑm n ŋmurɛi rɛ pikpɔkpɔ yɛ̀ɛ̀ nkpɔ kɛ́mɛɛ yisilɛ nnyɑ kɑpi nkpéni nɛ nɔ́kɛnɛ́yu-i nɛ́ túhɑɑnɛ. ");
INSERT INTO soy_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Felikisi yɛ pɛɛ Kirisi ncee kɛcɑ́ɑ́ nyulɛ. Uu nsímɛ́ piké nɛ yɑ́ uu pitúhɑɑnɛ kɛyɑ́ɑ tɛ́ŋ́sɛ, uu pɛpɛɛ Pɔɔli kɛtɑhɑi n sée mɑɑ rɛ: Usɔ́ɔ́cɑ wɛ́ɛ́sɛ Lisiyɑɑsi un píyei n kɑ, nɛ́ pɛɛ nɔ́nnɛ́símɛ́ ripérésɛ ńsɔnɛ. ");
INSERT INTO soy_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Uu pɛɛ usɔ́ɔ́cɑ kpéẽ tinɔ́ɔ hɛ rɛ ukɛ́ Pɔɔli kukpɑniilee-i wɑ ukɛ́ ukɛcɑ́ɑ́ m pɑílɛ̃, ɑmɑ́ ukɛ́ nɛ kɛ́yu u m purú, úu kɑpɛ yɛ yɛ̀ rɛ upikɔ́ ɑ́pi kɑpɛ u lɛ̃́. ");
INSERT INTO soy_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Pɔɔli uu kei lɛ̃ n we ɑí nɛ siyɑ́ɑ sinyinɛ kɔ́ɔ́nú. Uyɔ́ɔpi píimɑ Felikisi nɛ unɔ́si Turisii ɑpí hɑpɔ. Unɔ́si uyɛɛ Usuifi lɛ. Uyɔ́ɔpi Felikisi uu tum ɑpi Pɔɔli u séipɔ, uu u pisɛ rɛ ukɛ́ u símisi, yo kɑpi yɛ rɛ usoi yɛ Kirisi Yeesu nɛ kɛfɑ tɛnɛ? ");
INSERT INTO soy_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Kɛ Pɔɔli uu ɑsei pitiki nɛ lɛ̃ kɛ usoi uu yɛ́ umɛcirɛ rimmúlú nɛ lɛ̃ kɛ Uléécɑɑ uu pisoi n túhɑɑnɛnɛ nsímɛ́ ń lõ, ɑi Felikisi cɔ́ŋ. Kei kuu pɛɛ Pɔɔli mɑɑ rɛ: Pɔ́ fe ɑɑ nkpéni lɛ̃ tɔ́mpɔ. Nɛn píyei kɛ́yu n yɛ̃, nɛ́ kɔ pɔ́ sée. ");
INSERT INTO soy_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","U pɛɛ́ lɛ̃ tɑ́lɛ̃ tɛ Pɔɔli ukɛ́ siwóó u hɛ. Lɛ̃ nnyɑ kuu mɛsɛ́rɛ u séleipɔ pin yɔ́i. ");
INSERT INTO soy_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Ai lɛ̃ n we iŋmɛ̃ itɛ́ ií nɛ tɔ́mpɔ. Pɔrisuusi Fɛsituusi uu Felikisi ripɔhɔ iyɔ́ɔpi tonɛ. Felikisi uu Pisuifi mpɔɔnɑrɛ n lɑ, uu lɛ̃ nnyɑ Pɔɔli kukpɑniilee-i n yɑ́lɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Fɛsituusi uu Sesɑree kɛteni-i hɑpɔ uu siyɑ́ɑ sitɑɑni wɑi, uu pɛɛ limɛmɑ́ɑ́ yisi uu Yerusɑlɛm tɔ́mpɔ. ");
INSERT INTO soy_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Kei kɛ pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ nɛ Pisuifi pɛɛ kuyu iwɛ́ɛ́sɛ n tṹ ɑpi yisi ɑpi ukɛmɛɛ́ Pɔɔli kɛtɑhɑi séi. ");
INSERT INTO soy_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Api kɔ u welu rɛ ukɛ́ nɛ pi kõ ukɛ́ ncée pi hɛ pikɛ́ Pɔɔli nɛ Yerusɑlɛm pɛɛpɔ. Tipinɛ kɑpi lɛ̃ wɑ pikɛ́ nɛ ncée u ń kpu. ");
INSERT INTO soy_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Fɛsituusi uu pi pɛsɛ rɛ Pɔɔli yɛ Sesɑree-pɔ kpɑniilɛnlɛ. Uyɛ̃ ticuruu yɛ́ kɔ nfɑ́ɑni kei pɛlɛ. ");
INSERT INTO soy_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Uu kɔ pi kpɑ́ rɛ: Nɔ́pinɛ́yukɔɔ́ pikɛ́ nɛ́ ritiki. In tɛ usoi nkó yɛ linyinɛ cɑɑi, pikɛ́ hɑ kɛtɑhɑi u sée. ");
INSERT INTO soy_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fɛsituusi uu Yerusɑlɛm-i tonɛ siyɑ́ɑ sipɑhɑ nɛ́ɛ kɛfi kumúŋɛ́ uu pɛɛ kɛlenɛ Sesɑree pɛlɛ. Kɑi kóso n weesi, uu kɛtúhɑɑnɛ-i sĩ́ uú tonɛ, uu tum ɑpi Pɔɔli kpíípɔ. ");
INSERT INTO soy_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Kuu n hɑ́pɔ, Pisuifi pɛɛ Yerusɑlɛm n léépɔ ɑpí hɑpɔ, ɑpi u kɑ́lisi ɑpi nsímɛ́ píimɑ nnyinɛ nɛ kɛtɑhɑi u séi. Ńn kusɑ kulúi we. Amɑ́ piukɑ úu fe ukɛ́ nyísɛ rɛ ɑsei kɑpi símisi. ");
INSERT INTO soy_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Pɔɔli pɔ́ɔ kɛ́su uu rɛ: Ám nɛ Pisuifi isé nɛ́ɛ Uléécɑɑ kɛyɔ nɛ́ɛ Rɔm uyɔɔpi Sesɑɑ púnnɛ. ");
INSERT INTO soy_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Fɛsituusi uu Pisuifi mpɔɔnɑrɛ n lɑ, uu lɛ̃ nnyɑ Pɔɔli pisɛ rɛ: Pɔ ŋmurɛi rɛ pikɛ́ nɛ Yerusɑlɛm pɔ́ hɑ pikɛ́ hɑ kei-pɔ kɛnɛ́mɛɛ́ nɛ nsímɛ́ mmú pɔ́ túhɑɑnɛɛ? ");
INSERT INTO soy_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pɔɔli uu u pɛsɛ rɛ: Sesɑɑ ripoo-i kɑm nní nyɛnu, kei kɑi nɛ sɑ́ rɛ pikɛ́ nɛ nɛ́ túhɑɑnɛ. Tipɔ́cúruu yɛ nyulɛ ńsɔnɛ rɛ ɑ́m Pisuifi líkɑ cɑɑi. ");
INSERT INTO soy_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Nɛn ncɑɑi nnyinɛ n wɑ kɑpi yɛ nɛ usoi ń kpu, ɑ́m nkpɔ kɛsu. Amɑ́ in tɛ pi nɛ nɛ́ rikpɑ́rɑ́lɛ, úkɑ úu ncée mɑ́ ukɛ́ piɑnipɛ-i nɛ́ ritépɔ. Nɛ pisɛ rɛ pikɛ́ nɛ nnɛ́símɛ́ Sesɑɑ kɛ́mɛɛ tu. ");
INSERT INTO soy_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Fɛsituusi nɛ pɛpɛɛ mɛsɔhɔ u n kpɑriisɛ ɑpi símɑɑnɛ, uu pɛɛ Pɔɔli mɑɑ rɛ: Pɔ rɛ mpɔ́símɛ́ nkɛ́ Sesɑɑ kɛ́mɛɛ tu. Lɛ̃ nnyɑ, Sesɑɑ kɛ́mɛɛ kɑɑ yɛ́ kɔ hɑ. ");
INSERT INTO soy_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Ai siyɑ́ɑ kulúi kɔ́ɔ́nú, uyɔ́ɔpi Akiripɑ nɛ uyɛ́i Pereniisi ɑpi Sesɑree-i Fɛsituusi piyɑ́hɑɑ sĩ. ");
INSERT INTO soy_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Kɑpi siyɑ́ɑ kulúi n wɑ, Fɛsituusi uu Pɔɔli nsímɛ́ mmɛ̃ kpísi uu Akiripɑ símisi. Uu rɛ: Felikisi yɛɛ pɛɛ nté iyɔ́ɔpi n tónɛ uú nɛ nɛ́ tisɛ yɛ ukpɑniikɔ́ unyinɛ kulee wɑilɛnlɛ nɛ nɛni-mɛ. ");
INSERT INTO soy_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Kɑm Yerusɑlɛm ń hɑ, pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ nɛ Pisuifi pɛɛ kuyu iwɛ́ɛ́sɛ n tṹ ɑpi kɛnɛ́mɛɛ kɛtɑhɑi u séi ɑpi rɛ kɛ́ wɑ unsímɛ́ nkɛ́ kpu. ");
INSERT INTO soy_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Kei kɑm pɛɛ pi pɛsɛ rɛ: Rɔm pikɔ́ kɛ́mɛɛ, usoi un linyinɛ n cɑɑi, ncée ńn we rɛ pikɛ́ u kpu, pinsɑ́ kɑhɑnɛ u n túhɑɑnɛ. Li pisɛ rɛ u nɛ upiteecɔ pikɛ́ tonɛ kɛlenɛ ukɛ́ uriyu hɛɛrɛ. ");
INSERT INTO soy_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Lɛ̃ nnyɑ kɑpi nté nɛ́ ritikimɛ. Ám nkpɑ́ni nɑ́ŋɑisɛ. Kɑi kóso n weesi, ɑḿ nɛ mɛsɛ nɛ mɛsɛ kɛtúhɑɑnɛ n tɔ́su ɑḿ hɑ tonɛ, ɑm tum ɑpi utisi nkó kpííri. ");
INSERT INTO soy_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Kɛ upiteecɔ ɑpi ń kɑ, ɑ́pi fe pikɛ́ nkópɛ nnyinɛ kɑḿ pɛɛ́ nɛ u m músu nyísɛ. ");
INSERT INTO soy_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Amɑ́ piinyɛkii nsímɛ́ nɛ utisi unyinɛ yɛɛ n kpu ɑpi yɛ u séi rɛ Yeesu kɛ Pɔɔli pɔ́ɔ n tee rɛ u nfɑ́ɑ mɑ́lɛ nkɔ́ ŋmɑnɛ kɛcɑ́ɑ́ kɑpi kɛ́ŋɛnɛ. ");
INSERT INTO soy_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Ai mɛ́woo nɛ́ wɑi, ɑ́m pɛɛ céru íye kɑm yɛ́ nɛ li wɑ. Lɛ̃ nnyɑ kɑm tɛ kɛ́ Pɔɔli pisɛ rɛ un n lɑ, ukɛ́ Yerusɑlɛm hɑ pikɛ́ hɑ nɛ kei-pɔ u túhɑɑnɛ. ");
INSERT INTO soy_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Amɑ́ Pɔɔli uu yúlu uu rɛ u lɑ rɛ Rɔm uyɔɔpi Sesɑɑ ricuruu ukɛ́ nsímɛ́ kɛcɑ́ɑ́ ripɑí. Lɛ̃ nnyɑ kɑm tɛ pikɛ́ kukpɑniilee-i u n yɑ́lɛ̃ kɛ́ kɑm kɛ́ nɛ Sesɑɑ u pɑpɔ. ");
INSERT INTO soy_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Kei kɛ Akiripɑ uu pɛɛ Fɛsituusi mɑɑ rɛ: Nɛ pɛɛ́ lɑ kɛ́ rinɛ́cúruu utisi nkó kutu ricɔ. Fɛsituusi uu u pɛsɛ rɛ: Kóso kɑɑ yɛ́ kutu u ricɔ. ");
INSERT INTO soy_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Kɑi kóso n weesi, Akiripɑ nɛ Pereniisi ɑpi mɛyɔ́ɔpilɑpɛ tɑni, pi nɛ pipipirɛtiki ɑpi kɛnɔŋlɑ wɑi ɑpí nɛ kutúhɑɑnɛlee lompɔ, pisɔ́ɔ́cɑ wɛ́ɛ́sɛ nɛ kuyu piyukɔɔ́ pin tikilɛ̃. Fɛsituusi uu rinɔ́ɔ hɛ ɑpi Pɔɔli kpíípɔ. ");
INSERT INTO soy_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Fɛsituusi uu pɛɛ rɛ: Uyɔ́ɔpi Akiripɑ nɛ nɔ́ pitɔ́rɔɔ mpí nɔ́ɔ nní ń kɑ, ɑni utisi nkó ripɑí ńsɔnɛ. Pisuifi riwúí nnɛ́í yɛ kɑlɛ ɑpi Yerusɑlɛm-pɔ nɛ nté kɛnɛ́mɛɛ kɛtɑhɑi u séi, pin cɑ́ɑ́i rɛ ɑ́i nɛ sɑ́ rɛ usoi nkó ukɛ́ kɔ nfɑ́ɑ rikpɑ́. ");
INSERT INTO soy_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Nɛ nsímɛ́ mmɛ̃ tipérélɛ ɑm yɛ́nu rɛ úu ncɑɑi ńkɑ wɑ kɑpi yɛ nɛ usoi ń kpu. Amɑ́ kɛ uricuruu uu m pisɛ rɛ pikɛ́ nɛ unsímɛ́ Rɔm uyɔɔpi kɛ́mɛɛ tu nnyɑ kɑm ŋmurɛi rɛ pikɛ́ nɛ kei u hɑ. ");
INSERT INTO soy_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Ám nyu íye kɛcirɛ kɑm yɛ́ utisi nkó kɛcɑ́ɑ́ wɔ́i kɛ́ nɛ upíimɑ símɑɑpɔ. Lɛ̃ nnyɑ ricuruu kɑḿ nɛ nɔ́kɛnɛ́mɛɛ u kɑ. Pɔ̃́, uyɔ́ɔpi Akiripɑ kɛ́mɛɛ kɑḿ nɛ u kɑ rɛ pɔn pipísɛisɛ u m mɑsí, nɛ́ nnyinɛ yɛ̃ ɑm títɛlɛ́-i wɔ́lu. ");
INSERT INTO soy_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Ái nɛ sɑ́ rɛ kɛ́ mɛ́woo ukpɑniikɔ́ nɛ Rɔm uyɔɔpi-i hɑ, kɑ́m pɛɛ lɛ̃ nnyɑ kɑpi pitele u n wɑi n wɔ́i. ");
INSERT INTO soy_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Akiripɑ uu pɛɛ Pɔɔli mɑɑ rɛ: Pɔ nkpéni ncée mɑ́lɛ pɔkɛ́ ripɔ́yu hɛɛrɛ tɔkɛ́ kṍ. Pɔɔli uu pɛɛ kunípɛ síkɑ, uu nsímɛ́ kpísi uu rɛ: ");
INSERT INTO soy_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","Uyɔ́ɔpi Akiripɑ, li nɛni kɛyɑ́ɑ nkɛ́ nɛ́ lɑ́ɑ́rú rɛ nɛ́ ncée yɛ̃ ɑm nsímɛ́ nnɛ́í kɛ Pisuifi ɑpí nɛ nɛ́ rinkpɑ́rɑ́ kɛpɔ́yu-i símisi. ");
INSERT INTO soy_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Li we rɛ pɔ Pisuifi inyɛkii nɛ piisímɛ́ kɛcɑ́ɑ́ kɑpi n kɛ́ŋɛnɛntɛ mɛyíkíyiki ńsɔnɛ nyulɛ. Lɛ̃ nnyɑ, nɛ rikɔ́ŋ pɔ́ wúkulɛ rɛ ɑ niŋɛsi ɑɑ kutu nɛ́ cɔ. ");
INSERT INTO soy_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Pisuifi nnɛ́í yɛ nyulɛ lɛ̃ kɑm hɑ́i inɛ́ŋmɑ́nɛ-mɛ nnɛ́puri pikɔ́ kɛcɔpɛ nɛ Yerusɑlɛm kɛ́mɛɛ inɛ́soi n li. ");
INSERT INTO soy_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Hɑ́i ɑ́i nɛni-mɛ kɑpi nɛ́ nyu. Pin n lɑ, piricuruu yɛ́ nɛ pinnɔɔ símisi rɛ nɛ pɛɛ Pifɑrisi kɛ́mɛɛ welɛ. Tɔ́ɔ yɛ ɑ́ri pɛɛ pirɔ́yómɛyɑ́hɑɑ isé nɛ ɑkpɛ́ri wɑi. ");
INSERT INTO soy_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Kɑm n tɑ́lɛ̃ tɛ Uléécɑɑ yɛ́ lɛ̃ kuu pirɔ́sɑ́ɑyɑhɑ ḿ mɑ wɑ nnyɑ kɑpí nɛ nté nní nɛ́ túhɑɑnɛ. ");
INSERT INTO soy_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Isirɑyɛɛli pikɔ́ ipuri kɛfi nɛ itɛ́ iyɛ̃ pɔ̃́ nɛ kɔ mɛsɛ́rɛ kɛsinɛ nɛ kɛtúŋɛ́ Uléécɑɑ yɑ́ɑ́silɛ in nɛ tɑ́lɛ̃ tɛ i yɛ́ lɛ̃ kuu mɛkɛɛ-mɛ pirɔ́sɑ́ɑyɑhɑ ḿ mɑ yɛ̃. Kɑm likɛcɑ́ɑ́ n tɑ́lɛ̃ nnyɑ kɛ Pisuifi ɑpi pitele nɛ́ wɑi, uyɔ́ɔpi Akiripɑ! ");
INSERT INTO soy_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Yo nnyɑ kɛ nɔ̃́ Pisuifi ɑ́ni pɛɛ́ lɑ nɔkɛ́ ŋmurɛi rɛ Uléécɑɑ yɛ́ fe uu mɛyíkíyiki pikpɔkpɔ yukusɛ? ");
INSERT INTO soy_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Tinɛ́cúruu ŋmɑɑ yɛ pɛɛ́ musilɛ rɛ kɛ́ ńnɑŋɛ nɛ tɑ́pɑɑnkɛɛ úkɑ úu kɑpɛ Nɑsɑrɛti ukɔ́ Yeesu rinyiri nɛ kɛfɑ tɛnɛ. ");
INSERT INTO soy_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Lɛ̃ kɑm Yerusɑlɛm-pɔ n wɑ yɛ lɛ̃. Nɛ rinɛ́cúruu ŋmɑɑ Uléécɑɑ pikɔ́ mɛyɑ̃ kukpɑniilee tɑnlɛ. Pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ pɛɛ yɛ ncée nɛ́ hɛ rɛ kɛ́ lɛ̃ wɑ. Pin kɔ n lɑ pikɛ́ pi kṍ, li yɛ pɛɛ́ nɛ nɛ́ risɑ́lɛ. ");
INSERT INTO soy_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Nɛ yɛ pɛɛ ɑyómɛyɑ́hɑɑlee rikɑlɛ ɑḿ hɑ kei íwɛ pi n wɑi, nɛn nɑ́ɑ́si rɛ pikɛ́ pinfɑtɛnɛ kɛsi. Kunɛ́fɑtoi yɛ pɛɛ pikɛcɑ́ɑ́ tɔsilɛ, hɑ́i ricuruu ɑm yɛ pi n wéékusɛlɛ̃ nɛ ɑcɔ̃yu-pɔ. ");
INSERT INTO soy_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Limɛkɔ́-i kɛ pɛpɛɛ yɛ Uléécɑɑ inyɔ́ɔnsɛ n wɑ piwɛ́ɛ́sɛ ɑpi kɛyɑ́ɑ kɛnyinɛ rítɛlɛ́ nɛ́ rimúísɛ ɑpi ncée nɛ́ hɛ ɑm yisi ɑm Tɑmɑɑsi sĩ. ");
INSERT INTO soy_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Ituŋɛ kɛcírɛ kumúŋɛ́, nɛn ncée-i we, uyɔɔpi Akiripɑ. Kei kɑm mɛtɛ́í mɛnyinɛ yɛ̃ mɛn kɛyómɛcɑɑ-pɔ leeri, mɛn tɑpɑɑlɛ̃, mɛn ituŋɛ mɛtɛ́í fe ɑmɛ́ nɛ tɔ́ nɛ pinɛ́séncɔ kɔ́ɔ́nú. ");
INSERT INTO soy_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Ari ntɔ́nɛ́í kɛteni-i lólu, ɑm pɛɛ kóm, lin nɛ Mɛ-epiree nɛ́ tee rɛ: Sɔɔli, Sɔɔli, yo nnyɑ kɑɑ nɛ́ wéékusɛlɛ̃? Mɛ́woo kɑɑ́ nɛ nɛ́ tɔpiriinkɛɛ yɑrɛ kɛminɑɑ. ");
INSERT INTO soy_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Kei kɑm pɛɛ pisɛ rɛ: Pɔ́ɔ úye, Upíimɑ? Uu nɛ́ pɛsɛ rɛ: Nɛ́ɛ Yeesu kɑɑ ń we pɔn wéékusɛlɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","A nkpéni yisi ɑɑ nyɛrɛ. Lɛ̃ nnyɑ kɑm mɛnɛ́círɛ pɔ́ n nyísɛ yɛ nní: Nɛ lɑ rɛ ɑ pɑnsɛ unɛ́kɛikɔ́, ɑɑ yɛ kɔ́ɔ́nú ɑɑ lɛ̃ kɑɑ nɛni nní nɛ́ n yɛ̃́ nɛ lɛ̃ kɑm n sɔ́nti kɛ pɔ́ n nyísɛ picɔ símisi. ");
INSERT INTO soy_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Mpɔ́puri pikɔ́, Pisuifi kɛcɔpɛ kɑm pɔ́ lesɛnɛ kɛ́ mpuri sɑnɛ pikɔ́ kɛ́mɛɛ pɔ́ tũ. ");
INSERT INTO soy_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Nɛ pɔ́ tum tɛ ɑ hɑ piinipɛɛ wúkulɛ ɑɑ kuŋmɑhɑ-i pi lesɛ ɑɑ́ nɛ mɛtɛ́í-i pi sĩ. A kɔ Setɑni ɑnipɛ-i pi lesɛ ɑɑ́ nɛ Uléécɑɑ kɛ́mɛɛ pi sĩ. In tɛ pi nɛ kɛfɑ nɛ́ tɛnɛlɛ̃, Uléécɑɑ yɛ́ piɑkópɛ pi sɑ́rɛi uu kɔ lisɔnɛ kuú nɛ upikɔ́ m mɛ̃́ pi hɛ. ");
INSERT INTO soy_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Lɛ̃ kɛ́mɛɛ, ɑ́m pɛɛ lɛ̃ kɑi kɛyómɛcɑɑ-pɔ nɛ́ n nyísɛmɛ kɛsi, uyɔ́ɔpi Akiripɑ! ");
INSERT INTO soy_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Amɑ́ Tɑmɑɑsi pikɔ́ nɛ Yerusɑlɛm pikɔ́ kɑm Nléécɑɑsimɛ́ mɛfoí riyóó, ɑm pɛɛ limɛmɑ́ɑ́ Yutee kɛtẽ tɔrɔɔ pikɔ́ nnɛ́í nɛ sitẽ sicɔ pikɔ́ yóó. Nɛ pi símisi rɛ pikɛ́ mɛfinɛ consɛ pikɛ́ Uléécɑɑ-mɛ̃ pɑnsɛpɔ ɑpí n wɑi likɛ́ n nyísɛlɛ̃ tɛ pi mɛfinɛ consɛlɛ. ");
INSERT INTO soy_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Nsímɛ́ mmɛ̃ nnyɑ kɛ Pisuifi ɑpi Uléécɑɑ kɛyɔ-i nɛ́ tĩ́, pin wɛ́ɛ́si pikɛ́ nɛ́ kpu. ");
INSERT INTO soy_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Amɑ́ hɑ́i nɛ nɛni-mɛ, Uléécɑɑ yɛ nɛ́ nɛn nɛ we nɛn uiseérɑkɔɔ́ le, ḿpɑ́ úye, siwɑ̃́ nɛ piwɛ́ɛ́sɛ siyu-i. Ám yɛ nféé ńkɑ mɑ, lɛ̃ kɛ ɑntepuyɛ nɛ Moisi ɑpi mɛkɛɛ-mɛ n yɛ̃́ ɑpi símisi rɛ li wemɛ mɛmɑ́ɑ́. ");
INSERT INTO soy_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Nɛ yɛ mɑɑ rɛ: Uyɛ̃ kɛ Uléécɑɑ uu n wɛ́ɛ yɛ́ kɑm uu íwɛ le, uu kpi uu ufoí pikpɔkpɔ kɛ́mɛɛ yisi. Uyɛɛ yɛ́ nsímɛ́ mɛɛ mɛtɛ́í ḿ mɑ́ Pisuifi nɛ mpuri sɑnɛ pikɔ́ hɛ. ");
INSERT INTO soy_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Pɔɔli un lɛ̃ we un uriyu hɛɛrɛ, Fɛsituusi uu cɑ́ɑ́ipɔ rɛ: Pɔ isɔhɔ torilɛ, Pɔɔli! Mɛpɔ́nyuwɛ píimɑ yɛ isɔhɔ pɔ́ tóroisɛlɛ. ");
INSERT INTO soy_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Kei kɛ Pɔɔli uu pɛɛ rinɔ́ɔ u yɔsí rɛ: Ám isɔhɔ tori, urɔ́sɑ́ɑ! Mmú kɑm nní n símisi yɛ mɛníŋɛ nsímɛ́ sɔnɛ lɛ nn kɔ ɑsei tikilɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Nɛ nyulɛ rɛ uyɔ́ɔpi Akiripɑ yɛ nní nnɛ́í lɛɛ nní ń wɑ pikómɛ mɑ́ɑ́lɛnlɛ. Lɛ̃ nnyɑ kɑḿ nɛ rinɛ́pɔ́ɔ ukɛyu-i símisi. Ái mɛpíílú mɛnyinɛ-i kɑi kɛlõ kuŋmɑhɑ-i lɛ̃ wɑ. ");
INSERT INTO soy_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Pɔ ɑntepuyɛ nsímɛ́ nɛ kɛfɑ tɛnɛlɛ̃ɛ, uyɔ́ɔpi Akiripɑ? Nɛ nyulɛ rɛ pɔ nɛ kɛfɑ n tɛnɛlɛnlɛ. ");
INSERT INTO soy_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Akiripɑ uu pɛɛ Pɔɔli pɛsɛ rɛ: Pɔ lɑlɛ pɔkɛ́ nɛ́ feriyɛ kɛ́ nté nní pɑnsɛ Kirisi ukɔ́! ");
INSERT INTO soy_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pɔɔli uu rɛ: Lin yɛ́ nfɑ́ɑni nɛ́ɛ lin yɛ́ píyei-pɔ, li kpére lɛ̃ wɑ! Nɛ Uléécɑɑ welu rɛ ɑ́i kɑpɛ pɔ̃́ ŋmɑnɛ, ɑmɑ́ likɛ́ nɔ́nnɛ́nɛ́í mmú nɔ́ɔ nɛni nní kutu nɛ́ n cɔ́lɛ̃, nɔ́ɔ yɛ́ mɛnɛ́cɔ n we. Akpɑnii nnyɛ́ ŋmɑnɛ ɑkɛ́ nɔ́ ripɑ́rí. ");
INSERT INTO soy_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Kei kɛ uyɔ́ɔpi Akiripɑ nɛ uyɔ́ɔpi píimɑ Fɛsituusi nɛ Pereniisi nɛ pɛ̃ nnɛ́í pɛɛ kei kɛsẽ́ ń we ɑpi pɛɛ yisi, ");
INSERT INTO soy_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","ɑpi iyɑɑ leepɔ, ɑpi pɛɛ pimɛcɔpɛcirɛ n tee rɛ: Usoi nkó úu líkɑ cɑɑi kɑpi yɛ́ nɛ usoi ń kpu nɛ́ɛ kɑpi yɛ́ nɛ ɑkpɑnii u n wɑ. ");
INSERT INTO soy_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Kei kɛ Akiripɑ uu pɛɛ Fɛsituusi mɑɑ rɛ: Usoi nkó unsɑ́ pɛɛ́ m pisɛ rɛ pikɛ́ nɛ Rɔm uyɔɔpi Sesɑɑ kɛ́mɛɛ u hɑ, pi yɛ́ pɛɛ fe ɑpi u yɑ́pɔ. ");
INSERT INTO soy_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Kɑi n símisi ɑí tonɛ rɛ kúninɔi kɑri yɛ́ lõ ɑrí nɛ Itɑlii sĩ, ɑpi Pɔɔli nɛ pikpɑniikɔ́ picɔ pinyinɛ kpísi ɑpi usɔ́ɔ́cɑ kpéẽ unyinɛ kɑpi yɛ n sée rɛ Yuliisi ɑnipɛ-i wɑi. U Rɔm kutɔpilee kpɛ̃ kɑpi yɛ n sée rɛ Rɔm uyɔɔpi kutɔpilee kɛ́mɛɛ úyukɔɔ́ usɛ lɛ. ");
INSERT INTO soy_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Atirɑmiiti kuyu kɛ kúninɔi kpɛ̃ kɑri n lõ ɑku lééri kun Asii sitẽ ɑninɔi sinyɛrɛ kɑnɛi. Ari ku loni ɑri tɔ́mpɔ. Mɑsetuwɑɑni ukɔ́ unyinɛ yɛɛ Tɛsɑloniki-pɔ ń we ɑpi yɛ u séi rɛ Arisitɑriki yɛ pɛɛ kɛrɔ́mɛɛ welɛ. ");
INSERT INTO soy_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Ari liukóso Sitɔɔ kuyu tulu. Yuliisi yɛ pɛɛ Pɔɔli ńnɑrɛ wɑilɛ. Uu ncée u hɛ rɛ ukɛ́ upisɑnɛ rilóólú, un yɛ yo n lɑ, pikɛ́ fe pikɛ́ yɛ nɛ kutu u ricɔ. ");
INSERT INTO soy_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Kɑri kei n yisi tɔn tɔ́su, kuyɔ ɑku kɛrɔ́yu-mɛ̃ m pepuri, ɑri pɛɛ Siipuru kuwɛ́ɛ́ kpɛ̃ mɛ̃ kɛ kuyɔ ɑ́ku ń we tiki. ");
INSERT INTO soy_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Ari pɛɛ Silisii nɛ Pɑmfilii mɛnimɑɑ tɛ́ŋ́ ɑrí nɛ Lisii kɛteni-i Miiri kuyu tulu. ");
INSERT INTO soy_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Rɔm usɔ́ɔ́cɑ kpéẽ uyɛ̃ uu kei kúninɔi kucɔ kunyinɛ yɛnu kpɛɛ Alɛkisɑntiri n lééri kun Itɑlii-mɛ̃ sĩ. Uu kpɛ-i rɔ́ tɑni. ");
INSERT INTO soy_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Siyɑ́ɑ kulúi kɑri nnɑ́nnɑ́ri nɛ kúninɔi sɔ́nɛ. Íwɛ píimɑ kɑri li ɑri kɛlenɛ Kiniiti tulu. Kuyɔ ɑ́ku ŋmurɛi tɔkɛ́ lɛ̃ n tikilɛ̃ tɔkɛ́ nɛ kɛ́yu-mɛ̃ hɑ. Ari pɛɛ mɛsɛ Sɑlimonee kuwɛ́ɛ́-mɛ̃ míni kɛpɑ́ɑ́pɑ́ɑ́ kɛtẽ kɑpi yɛ n sée rɛ Kirɛɛti mɛcɑ́ɑ tiki. ");
INSERT INTO soy_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Ari íwɛ píimɑ le ɑrí nɛ rikóitimɛ kɑnɛi ɑrí nɛ kɛlõ kɛnyinɛ tulu. Pi yɛ kei sée rɛ Áninɔi-Kɛnyɛrɛ-Sɔnɛ. Lɑsee kuyu kɑí nɛ kɔlɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Ái kusɑ rɔ́ nɑ́ŋɑisɛ. Anɔ́ɔpɑhɑɑ kɛyɑɑ yɛ pɛɛ pitɔ́mpɔ mɑsilɛ. Kúninɔi pilonɛ nɛ ncée pinɔŋ́ yɛ́ fe ɑpí nɛ nkpɔ weri. ");
INSERT INTO soy_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","Lɛ̃ nnyɑ kɛ Pɔɔli uu kúninɔi pikɛikɔ́ símisi ńsɔnɛ pikɛ́ kṍ. U pi mɑɑ rɛ: Pinɛ́sɑ́nɛ, nɛ yɛ̃ tɛ ntɔ́cée mmú pitiki yɛ́ nɛ nkpɔ rɔ́ kɑm. Kúninɔi nɛ ilũ kɑku n topori yɛ mɛyɑ̃ cɑɑinkɛɛnɛ. Ái nkpɑ́ni ilũ nɛ kúninɔi ŋmɑnɛ, ɑmɑ́ nɛ tɔ́ɔpi. ");
INSERT INTO soy_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Amɑ́ Rɔm usɔ́ɔ́cɑ kpéẽ uyɛ̃ uu kúninɔi utíkíí nɛ kuute nkɔ́ nɛ kutu n cɔlɛ̃ ɑi tɔ́su Pɔɔli nkɔ́ kuu ḿ mɑ. ");
INSERT INTO soy_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Ai kɔ yɑ́, ɑ́ninɔi kɛnyɛrɛ ɑ́kɛ pɛɛ́ nyɑḿ tɛ pikɛ́ kei nnyiyɛ píimɑ kumúŋɛ́-i siyɑ́ɑ wɑ. Kúninɔi pikɔ́ mɛyɑ̃ ɑpi pɛɛ lɛ̃ nnyɑ rɛ pi yɛ́ kei yisi. Pi lɛ̃ pɛɛ nɑ́ɑ́silɛ rɛ lin íye n we, pikɛ́ Kirɛɛti ɑninɔi kɛnyɛrɛ kɛ̃ kɑpi yɛ n sée rɛ Fenikisi tu, ɑ́ninɔi kɛnyɛrɛ kɛɛ ituŋɛ kɛlólɛ́ ɑwɛ́lɛ́ kɛtɛ́-mɛ̃ kɛ́yu pɑlɛnlɛ̃. Kei kɑpi lɑ pikɛ́ nnyiyɛ píimɑ kumúŋɛ́-i siyɑ́ɑ wɑ. ");
INSERT INTO soy_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Kɛ kúninɔi ɑku lɛ̃ n nyɛnu lin nɑ́ŋɑi, kɛyɔpi kɛnyinɛ ɑkɛ ituŋɛ kumii-mɛ̃ pepuri, ɑpi músu rɛ pi yɛ́ fe ɑpi nkpéni lɛ̃ kɑpi ń lɑ wɑi. Api pɛɛ kɛsɑ́u kɑpi yɛ nɛ kúninɔi n nyɛrɛsɛ sɑkɑɑ ɑpi ncée kpísi. Api míni kɛpɑ́ɑ́pɑ́ɑ́ kɛtẽ kɑpi yɛ n sée rɛ Kirɛɛti n kɑnɛi. ");
INSERT INTO soy_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Mɛsɛ nɛ mɛsɛ, kuyɔ kunyinɛ kɑpi yɛ n sée rɛ Erɑkilɔɔ ɑku míni kɛpɑ́ɑ́pɑ́ɑ́ kɛtẽ-mɛmpɔ pepuri nɛ ńnɑŋɛ. ");
INSERT INTO soy_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Ai kúninɔi kpɑ́ú lin nɛ tɔ́su, ɑ́i kunyɛrɛsɛ we. Ari mɛsɛ yɑ́ ɑí nɛ rɔ́ n tɔ́su. ");
INSERT INTO soy_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Ari míni kɛpɑ́ɑ́pɑ́ɑ́ kɛtẽ síńsɑ́pi kɛnyinɛ kɛkúrí tɔ́mpɔ. Pi yɛ kɛ̃ sée rɛ Kulotɑɑ. Ari pɛɛ nɑ́ɑ́si ɑrí nɛ fe ɑri kɛnɔ́ipi kɑpi yɛ nɛ pisoi n léisɛ lesɛ. ");
INSERT INTO soy_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Kúninɔi pikɛikɔ́ ɑpi kúninɔi kɛ́mɛɛ kɛ tɑmpɔ. Api pɛɛ limɛmɑ́ɑ́ iŋmɛ pɑhɑɑnkɛɛ ɑpí nɛ kúninɔi kɔ́ɔ́nú. Iwɑmɛ ii pi wɑi rɛ ɑ́pi kɑpɛ hɑ Lipii mɛnimɑɑ ritimɛ rinyɛnɛtũ tinyinɛ rikɑm. Api pɛɛ kusɑ́ŋɑ́ɑ́ mɑɑmɑɑ kpɛɛ kuyɔ n wɑi cɛpisɛ. Api nnɑ́nnɑ́ri n sɔ́nɛ pin kuyɔ tikilɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Kuyɔ ɑku lɛ̃ tɔ́ m pepu kun ḿpɑpɛ kpɑ́lɛ̃ ɑí nɛ rɔ́ weesi, ɑpi pɛɛ mɛsɛ ilũ kɛ kúninɔi ɑku n topori n hɑsu pin míni-i sɑriipɔ. ");
INSERT INTO soy_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Kɑi kɔ piweesi rinkpɑ́, ɑpi kúninɔi ikɛilũ inyinɛ pifóŋɛɛ kɑ́pɑ́ɑ́. ");
INSERT INTO soy_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Ai wɑi siyɑ́ɑ kulúi, ituŋɛ nɛ ɑwɑ́rɛpi ɑ́ɑ kúyɛnɛ wɑ, mɛyɔ mɛn lɛ̃ nɛ ńnɑŋɛ pepu, ɑri pɛɛ́ m músu rɛ ntɔ́kɔ́ yɛ tɛnɛlɛ. ");
INSERT INTO soy_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Ai nɑ́ŋɑi, tɔ́ úkɑ úu ilukɛ li. Pɔɔli uu pɛɛ yisi uu pisoi kɛcɔpɛ nyɛrɛ uu rɛ: Pinɛ́sɑ́nɛ, nɔn pɛɛ nnɛ́kɔ́ kutu rincɔ, tɔ yɛɛ pɛɛ Kirɛɛti-pɔ tonɛ ɑ́ri yɛ ɑ́sɑ́lɑ́ú píimɑ nnyɛ́ nɛ risɑ́nɛ tɔkɛ́ nɛ ilũ fóŋɛɛ. ");
INSERT INTO soy_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Lɛ̃ nnyɑ, kɛ́ nkpéni nɔ́ símisi ɑni rikíŋ tɑ́pisi ńsɔnɛ. Nɔ́ úkɑ úu kpinɛ. Kúninɔi ŋmɑnɛ kpɛɛ ɑ́sɑ́lɑ́ú wɑinɛ. ");
INSERT INTO soy_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Uléécɑɑ uyɛɛ nɛ́ n te nɛn kɔ u kɛisi Uleecɑɑtumɛ yɛ kɛsinɛ nkɛ́ kɛnɛ́mɛɛ kɑlɛ. ");
INSERT INTO soy_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Uu nɛ́ mɑɑ rɛ: Iwɑmɛ íi kɑpɛ pɔ́ wɑ, Pɔɔli! Pɔ Sesɑɑ kɛ́mɛɛ pitúhɑɑnɛ sinlɛ pɑ́í! Pɔ̃́ kɛ Uléécɑɑ uu n lɑ nnyɑ, u yɛ́ kɔ pipɔ́séncɔ nnɛ́í nfɑ́ɑ tíyɛ. ");
INSERT INTO soy_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Lɛ̃ nnyɑ, ɑni ikɑri wɑ, pinɛ́sɑ́nɛ. Nɛ nɛ kɛfɑ tɛnɛlɛ̃ tɛ lɛ̃ kɛ Uléécɑɑ uu ḿ mɑ kɑi lenɛ. ");
INSERT INTO soy_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Amɑ́ kuyɔ yɛ́ rɔ́ lesɛ ɑku míni kɛpɑ́ɑ́pɑ́ɑ́ kɛtẽ kɛnyinɛ ritimɛ sɑ́. ");
INSERT INTO soy_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Kɑrí nɛ n wemɛ, sisinɛ kɛfi nɛ sinɑ kɑri lɛ̃ Metitɛrɑnee mɛnimɑɑ kɛ́mɛɛ wɑ, mɛyɔ mɛn tɔ́ kpɑ́úlɛ̃. Ai kɛsinɛcɔ kumúŋɛ́ kúninɔi pikɛikɔ́ wɑi yɑrɛ tɔ nɛ kɛtẽ kóimɑ kɛnyinɛ nnyɑ́ɑ̃ wɑlɛ. ");
INSERT INTO soy_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Api mɛ́ŋmɛ kɑpi yɛ nɛ míni mɛcímɑ́ ḿ musí kpísi ɑpi fóm, ɑpi yɛ́nu rɛ simɛtiri ɑfɛɛtɑɑni nɛ sisɛɛi kɑmɛ címú. Api kɛ́yu-mɛ̃ nyɔsɔ́pɔ ɑpi kɔ pimúŋɛ́ kpɑ́, ɑpi yɛ́nu simɛtiri sitɛ́ ɑ́si we ɑfɛɛtɑɑni. ");
INSERT INTO soy_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Api pɛɛ́ n wuru rɛ kúninɔi ɑ́ku kɑpɛ ɑpɑrɛcɑŋɑɑ ɑnyinɛ rikɑm. Api pɛɛ lɛ̃ nnyɑ sisɑ́u sinɑ kɑpi yɛ nɛ kúninɔi n nyɛrɛsɛ kɛpirɛ-mɛ̃ cɛpisɛpɔ, ɑpi pɛɛ m mɛ̃́ pin yɔɔnɛ rɛ likɛ́ weesi. ");
INSERT INTO soy_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Kúninɔi pikɛikɔ́ yɛ pɛɛ lɑlɛ pikɛ́ léepɔ pikɛ́ wuri. Lɛ̃ nnyɑ kɑpi kɛnɔ́ipi kɛ̃ kɑpi yɛ nɛ pisoi n léisɛ míni-i ricɛpisɛ ɑpi pɛɛ kpɑ́rɑ́ rɛ pi lɑlɛ pikɛ́ hɑ nɛ kɛsɑ́u kɛ́yu-mɛ̃ ku nyɛrɛsɛ. ");
INSERT INTO soy_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Pɔɔli uu Rɔm usɔ́ɔ́cɑ kpéẽ nɛ pisɔ́ɔ́cɑ picɔ mɑɑ rɛ: Pisoi pɛ̃ pinsɑ́ kúninɔi kɛ́mɛɛ n tonɛ, ɑ́ni nkpɔ-i mɛ́lelɛ mɑ́. ");
INSERT INTO soy_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Pisɔ́ɔ́cɑ ɑpi pɛɛ mɛ́ŋmɛ mɛɛ kɛnɔ́ipi kɑpi yɛ nɛ n léisɛ m múílɛ̃ seḿ, ɑpi kɛ yɑ́ ɑkɛ lólu. ");
INSERT INTO soy_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Likɛ́ kɛlenɛ n weesi, Pɔɔli uu pinnɛ́í mɑɑ rɛ pikɛ́ ilukɛ li. Uu rɛ: Siyɑ́ɑ kɛfi nɛ sinɑ yɛ nsí kɑni nɛ mpɔ́ɔcɑɑi tũ nɔn mɛ̃́ ɑ́ni kɔ líkɑ li. ");
INSERT INTO soy_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Nɛ lɑ kɛ́ nɔ́ símisi rɛ ɑni ilukɛ li. Li pisɛ rɛ nɔkɛ́ li nɔkɛ́ nɛ nfɑ́ɑ m mɑ́. Nɔ́ úkɑ nnyúpi ricuruu ńn ríyu kɛcɑ́ɑ́ wɛhɛnɛ. ");
INSERT INTO soy_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Kuu lɛ̃ ḿ mɑ, uu kukpɔ́nɔ́ kpísi, uu pinnɛ́í inipɛɛ-i Uléécɑɑ pɑkɑrɛ uu pɛɛ ku kpɔkɔ́ri uu pilukɛ kɑ́pɑ́ɑ́. ");
INSERT INTO soy_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Kei kɑpi pɛɛ pinnɛ́í ikɑri wɑ ɑpi ilukɛ le. ");
INSERT INTO soy_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Ntɔ́nɛ́í yɛ pɛɛ kúninɔi kpɛ-i wɑlɛ pisoi pílɛ pílɛ mɛtɛ́ nɛ kuwóó nɛ ɑfɛɛrɛ́ nɛ pikpuulũ (276). ");
INSERT INTO soy_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Kɛ ḿpɑ́ úye uu pilukɛ ḿ mɑsí uu lɛpu, ɑpi mɛlukɛpipi mɛɛ kúninɔi-i ń we n hɑsu pin mínimɑɑ-i sɑriipɔ rɛ kúninɔi kukɛ́ nkɑ́ripi fɑkɑsi. ");
INSERT INTO soy_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Kɑi n weesi, kúninɔi pikɛikɔ́ ɑ́pi kɛtẽ kɛ̃ ceri, ɑmɑ́ ɑpi kɛtɑɑ-pɔ kɛtenpɑmpi kɛnyinɛ yɛnupɔ nɛ kɛkɛcɑ́ɑ́ kunyɛnɛ lɑii ɑí nɛ sĩ. Api pɛɛ rɛ pin n fe, pi yɛ́ wɑ kúninɔi ɑkú hɑ kei tɑsi. ");
INSERT INTO soy_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Lɛ̃ nnyɑ kɑpi sisɑ́u fénnɛ ɑpi mínimɑɑ-i sɑriipɔ. Api kɔ ɑ́ŋmɛ kɑpi yɛ nɛ kúninɔi kɛtíkíí m pɑɑsi fénnɛ. Api kɔ lɛ̃ mɛmɑ́ɑ́ kúninɔi kɛyu-mɛ̃ kusɑ́ŋɑ́ɑ́ tórɛsi ɑpi síkɑ, kuyɔ ɑku pɛɛ kúninɔi n télɛ̃ lin nɛ kɛnyɛnɛpɑmpi kɛ̃-mɛ̃ sĩ. ");
INSERT INTO soy_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Amɑ́ ɑpi sĩ́ ɑpí hɑ ínisɑ̃ itɛ́ kɛpɑ́ɑ́pɑ́ɑ́ rinyɛnɛtũ tinyinɛ tɑkɑ́ri, kúninɔi riyu ɑri kei lompɔ ɑí tini síḿ, ɑ́i pɛɛ kunyɔ́kɔ-nyɔkɔ we. Ániwɑlɛ́ nɑŋɛ-nɑŋɛ ɑnyinɛ pɔ́ɔ pɛɛ kɛpirɛ-mɛ̃ ku n forɛsi. ");
INSERT INTO soy_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Kɑi pisɔ́ɔ́cɑ iwɑmɛ n wɑ rɛ pikpɑniikɔ́ yɛ́ wééri ɑpi wúrunkɛɛ nnyɑ, ɑpi pɛɛ́ n lɑ pikɛ́ pi kṍ. ");
INSERT INTO soy_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Kɛ Rɔm usɔ́ɔ́cɑ kpéẽ uu ń lɑ ukɛ́ Pɔɔli riyu lɔ nnyɑ, uú nɛ pi yulu rɛ ɑ́pi kɑpɛ lɛ̃ wɑ. Uu pɛɛ rinɔ́ɔ hɛ rɛ pɛpɛɛ piwéeri n nyu pikɛ́ mɛfoí rikpuu ɑpí nɛ rikóitimɛ tɛ́ŋ́. ");
INSERT INTO soy_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Amɑ́ pitɔ́rɔɔ pikɛ́ ɑkpénkpélé nɛ kúninɔi siwɛ́lɛ́pi kɛcɑ́ɑ́ túnti ɑpí nɛ pi tiki. Lɛ̃ kɑri mɛsei ntɔ́nɛ́í wɑ ɑrí nɛ kɛtẽ kóimɑ tulu ɑ́i úkɑ ríkɑ kpu. ");
INSERT INTO soy_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Kɑi nkpɔ-i rɔ́ n lésɛ mɛmɑ́ɑ́ kɑri pɛɛ kṍ tɛ pi yɛ míni kɛpɑ́ɑ́pɑ́ɑ́ kɛtẽ kɛ̃ sée rɛ Mɑliti. ");
INSERT INTO soy_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Kei pikɔ́ ɑpi kɛfɑ fénnɛ ɑpi ńsɔnɛ rɔ́ yɔ́su. Kɛ ikónɛ ii picuũ n kóri nnyiyɛ nn wɑi nnyɑ, ɑpi nnɑ píimɑ nnyinɛ wɑi ɑpi rɔ́ yɔ́su, ɑri kɛkɑ́lɛ wɑi ɑrí nɛ n kɔ́ɔ́nú. ");
INSERT INTO soy_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pɔɔli uu pɛɛ yisi uú hɑ sinɑɑpi pɑɑ́lɑmɛ rɛ ukɛ́ nnɑ-i risɑ́pɔ, tikpurii rinyinɛ tin sinɑɑpi sɛ-i we. Kɛ nnɑ kutoi ɑku ri n lɛɛpɔ, ɑri lééri ɑri Pɔɔli kunipɛ yéu. ");
INSERT INTO soy_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Kɛ kɛtẽ kɛ̃ pikɔ́ ɑpi n yɛ̃́ iwɑ́ɑ iyɛ̃ in Pɔɔli kunipɛ sɑŋɑ́rilɛ̃, ɑpi pɛɛ pimɛcɔpɛcirɛ n tee rɛ: Ḿpɑ́ likɛ́ íye wɑ, usoi nkó yɛ usoikṍ unyinɛ lɛ. Míni-i kuu nní nkpɔ-i ŋmɛ́hɛrɛɛri. Amɑ́ Uléécɑɑ yɛɛ ɑsei n tíkilɛ̃ úu ŋmurɛi ukɛ́ nfɑ́ɑ li. ");
INSERT INTO soy_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Amɑ́ Pɔɔli pɔ́ɔ iwɑ́ɑ nnɑ-i mɛ́pɛ́pɔ, ɑ́i kɔ nkpɑ́ni mɛ́kɑ u wɑ. ");
INSERT INTO soy_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Api pɛɛ́ m mɛ̃́ yɑrɛ pikɛ́ u yɛ̃ un píni un nɛ sĩ nɛ́ɛ u yɛ́ mɛsɛ nɛ mɛsɛ kei nní loolɛ uu kpi. Api mɛ́rɛsi ɑi nɑ́ŋɑi, líkɑ ɑ́i u wɑ. Api pɛɛ mɛsɛ kɛmúŋɛ́ consɛ ɑpi rɛ piléé pinyinɛ yɛ pi. ");
INSERT INTO soy_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Kei kɛkúrí kɛ kɛtẽ kɛ̃ uyukɔɔ́ foí kɛyɔ ɑkɛ́ pɛɛ́ we. Pi yɛ u sée rɛ Pupiliyuusi. Uyɛ̃ uu kei nfɑnɑrɛ nɛ kusɑ́nɛ rɔ́ wɑi, ɑri kei finɛ siyɑ́ɑ sitɑɑni. ");
INSERT INTO soy_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Pupiliyuusi usɑɑ yɛ pɛɛ kumúŋɛ́ kpɛ-i pɔ́ɔ́lúlɛ un nɛ kupiŋɛtoi nɛ nlurɛ yɑrɛ ɑ́kpɑsɛhɛ́ finu. Pɔɔli uu sĩ́ uú hɑ u lóólú, uu ukɛcɑ́ɑ́ kɛyómɛ yɑ́ɑ́si uu ɑnípɛ ukɛcɑ́ɑ́ lɑ́ɑ uú nɛ u pɔisɛ. ");
INSERT INTO soy_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Lɛ̃ mɛmɑ́ɑ́, kɛtẽ kɛ̃ pitóikɔ́ picɔ ɑpí weri ɑpi Pɔɔli yɛnu, uu pi pɔisɛ. ");
INSERT INTO soy_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Api ḿpɑ́ yo nɛ ríyu rɔ́ wɑisɛ hɑ́i. Kɑri n tɔ́su, ɑpi lɛ̃ kɑi rɔ́ m pisɛ tɔkɛ́ nɛ ncée rintíki nnɛ́í rɔ́ pɑ́sii. ");
INSERT INTO soy_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Iwɑ́rɛ itɑɑni kɑri kei wɑ. Ari pɛɛ limɛmɑ́ɑ́ kúninɔi kunyinɛ kpɛɛ Alɛkisɑntiri n lééri loni ɑrí nɛ tɔ́mpɔ. Nnyiyɛ kumúŋɛ́-i kɑkú pɛɛ Mɑliti-i nyɛrɛ. Pi kukɛcɑ́ɑ́ písikɑ ɑyu lesɛlɛ. ");
INSERT INTO soy_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Kɑri Sirɑkuusi n tu, ɑri kei tonɛ siyɑ́ɑ sitɑɑni. ");
INSERT INTO soy_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Ari kei yisi ɑri mínimɑɑ mɛcɑ́ɑ kɑnɛi ɑrí nɛ Rekiyo tulu. Kuyɔ ɑku liukóso ituŋɛ kumii-mɛ̃ pepuri, ɑri pɛɛ siyɑ́ɑ sitɛ́ ŋmɑnɛ kpísi ɑrí nɛ Pusoli tulu. ");
INSERT INTO soy_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Ari kuyu kpɛ-i pirɔ́cɔ Yeesu pikɔ́ yɛ́nu, ɑpi rɔ́ pisɛ rɛ tɔkɛ́ kei siyɑ́ɑ sisɛɛi pikɛmɛɛ́ tonɛ. Kei kɑri pɛɛ yisi ɑrí nɛ Rɔm tulu. ");
INSERT INTO soy_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Yeesu pikɔ́ pɛɛ Rɔm-i ń we yɛ pɛɛ kɛrɔ́cɑ́ɑ́ nyulɛ. Api hɑ́i Apiyusi kuyɑɑ-i nɛ kei kɑpi yɛ n sée rɛ Sisɑ́nɛyɔ Sitɑɑni-i rɔ́ tɛ́pɛi. Kɛ Pɔɔli uu pi n yɛ̃́, uu Uléécɑɑ pɑkɑrɛ, ɑi kɔ ikɑri u kpɑ́sɛ. ");
INSERT INTO soy_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Kɑri Rɔm-i n tuipɔ, usɔ́ɔ́cɑ kpéẽ uu usɔ́ɔ́cɑ wɛ́ɛ́sɛ ɑnipɛ-i pikpɑniikɔ́ wɑi ɑpi Pɔɔli ncée hɛ rɛ ukɛ́ umɛcirɛ kɛlõ tonɛ nɛ usɔ́ɔ́cɑ yɛɛ yɛ́ u m mɛ̃́. ");
INSERT INTO soy_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Kɑpi Rɔm-i n tuipɔ siyɑ́ɑ sitɑɑni mɛmɑ́ɑ́, Pɔɔli uu Pisuifi piyukɔɔ́ pɛɛ kei ń we cɑ́pinɛ. Kɑpi n cɑ́pinɛpɔ, uu pi mɑɑ rɛ: Pimɑ́rɛcɔ, ɑ́m ɑkópɛ ɑ́kɑ ntɔ́puri mmú wɑ, ɑ́m kɔ pirɔ́sɑ́ɑ isé íkɑ rilɔ́ɔ́, ḿpɑ́ nɛ lɛ̃, pi Yerusɑlɛm-pɔ nɛ́ tínlɛ ɑpi Rɔm pikɔ́ ɑnipɛ-i wɑi. ");
INSERT INTO soy_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Rɔm pikɔ́ ɑpí nɛ nɛ́ túhɑɑnɛ, ɑ́pi ńkɑ yɛ̃ kɑpi yɛ́ nɛ nɛ́ ń kpu. Api pɛɛ rɛ pikɛ́ nɛ́ riyɑ́pɔ. ");
INSERT INTO soy_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Amɑ́ Pisuifi ɑpi yúlu, ɑm pɔɔnɛ ɑm mɛsɛ rɛ Sesɑɑ kɑḿ lɑ ukɛ́ hɑ nɛ nɛ́ túhɑɑnɛ. Ái rɛ nnɛ́puri pikɔ́ kɑḿ lɑ kɛ́ pitele wɑ. ");
INSERT INTO soy_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Lɛ̃ nnyɑ kɑm tɛ kɛ́ nɔ́ yɛ̃́ kɛ́ kɔ rinɔ́ɔ nɔ́ mɑɑ nɔkɛ́ kṍ tɛ lɛ̃ kɛ Isirɑyɛɛli pikɔ́ ɑpi n tɑ́lɛ̃ nnyɑ kɑm nté nní ɑkpɑnii-i we. ");
INSERT INTO soy_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Kei kɑpi pɛɛ u pɛsɛ rɛ: Ápi mpɔ́kɔ́ ńkɑ kɛcɑ́ɑ́ Yutee-pɔ rítɛlɛ́ ríkɑ rɔ́ wɔ́imɛ, urɔ́mɑ́rɛcɔ úkɑ úu kɔ kei-pɔ leemɛ ukɛ́ kɑm ukɛ́ kɛpɔ́cɑ́ɑ́ nnyinɛ rɔ́ kɛ́ɛ̃ nɛ́ɛ ukɛ́ mpɔ́kópɛ nnyinɛ rɔ́ símisi. ");
INSERT INTO soy_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Amɑ́ tɔ lɑ rɛ pɔ̃́ ŋmɑɑ ɑ nkpéni mmɛ̃ kɑɑ m músu rɔ́ símisi. Tɔ kõ tɛ ḿpɑ́ yei kɑpi mpɔ́yómɛyɑ́hɑɑcee mmɛ̃ kɑɑ nní ń tíkilɛ̃ yulu. ");
INSERT INTO soy_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Pi nɛ Pɔɔli ɑpi kɛyɑ́ɑ yekei. Kɑi likɛyɑɑ kɛ̃ n tu, ɑpi sĩ́ kulúi ɑpi Pɔɔli lɛɛpɔ kɛ́yɔ kɛ-i kuu n sói. Uu mmɑrɛ hɑ́i nɛ kɛsinɛcɔ-pɔ Uléécɑɑ iyɔɔpi kɛcɑ́ɑ́ pi símisi, uu yɛ Moisi isé nɛ ɑntepuyɛ ɑtɛlɛ́ nɛ tiki un nɛ pi nɑ́ɑ́si rɛ pikɛ́ Yeesu nɛ kɛfɑ tɛnɛ. ");
INSERT INTO soy_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Picɔ ɑpí mmɛ̃ kuu pi n símisi ŋmurɛi, picɔ ɑpi pikómɛ yulu. ");
INSERT INTO soy_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Kɑpi lɛ̃ n tɔ́su ɑ́pi kómɛinɛ, Pɔɔli uu pɛɛ kɛkéripi pi mɑɑ rɛ: Asei kɛ Nfɑ́ɑsɔnɛ nń nɛ ɑntepu Esɑyi ritiki nń nɛ nɔ́pinɛ́sɑ́ɑ mɑɑ rɛ: ");
INSERT INTO soy_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","A mpuri mmú pikɔ́-i hɑ, ɑɑ pi mɑɑ rɛ: Nɔ́ yɛ ńsɔnɛ kutu ricɔ ɑmɑ́ ɑ́ni yɛ́ɛ́ ɑsei kõ nɔ́ yɛ ńsɔnɛ nyɑ́nɛi ɑmɑ́ ɑ́ni yɛ́ɛ́ yɛ̃. ");
INSERT INTO soy_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Li we rɛ mpuri mmú pikɔ́ ɑkiŋ yɛ tɑkɑsilɛ, pi pimɛcirɛ ɑtu tɑ́pisilɛ, ɑpi inípɛɛ wúkɛsi rɛ piɑtu ɑ́ɑ kɑpɛ yɛ kõ, piinipɛɛ íi kɑpɛ yɛ kɔ yɛ̃. Pimɛsɔhɔ ɑ́mɛ kɑpɛ yɛ kɔ líkɑ ceri nnyɑ. Pɛɛ́ uyɛ-i, ɑ́pi yɛ pɛɛ nɛ̃́ Uléécɑɑ kɛ́mɛɛ kɑm kɛ́ pi pɔisɛ. ");
INSERT INTO soy_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Pɔɔli uu kɔ pimɑ́ɑ pi kpɑ́ rɛ pikɛ́ kṍ tɛ mpuri sɑnɛ pikɔ́ pɛɛ ń-yulɑlɛsimɛ́ kɛ Uléécɑɑ uu m pɑ́mɛ te. Pɛ̃ nɛ́ kutu n ticɔ. ");
INSERT INTO soy_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Kuu lɛ̃ pimɑ́ɑ m mɑsí, Pisuifi ɑpi ncée kpɔu ɑpí n kɛŋɛnɛpɔ pin nɛ tɔ́su. ");
INSERT INTO soy_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pɔɔli uu iŋmɛ̃ itɛ́ kɛ́yɔ kɛ-i kuu ń we un hɛ́ɛ́lɛ kɛ́mɛɛ tonɛ. Uu kei pɛpɛɛ ukɛmɛɛ́ n sɔ́nɑɑpɔ nnɛ́í yɔ́ɔ́i. ");
INSERT INTO soy_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Uléécɑɑ iyɔɔpi nsímɛ́ kuú pɛɛ yóólɛ̃ un kɔ Upíimɑ Yeesu Kirisi nkɔ́ pisoi céési nɛ uripɔɔ, líkɑ ɑ́i kɔ u pɛkɛsi.");
INSERT INTO soy_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Nɛ̃́ Kirisi Yeesu ukɛikɔ́ Pɔɔli, nɛ́ɛ rítɛlɛ́ ntí nɔ́ wɔ́lu. Uléécɑɑ yɛɛ nɛ́ sée rɛ kɛ́ pɑnsɛ utumɛ. U nɛ́ wɛ́ɛlɛ rɛ kɛ́ Unsímɛ́ Kɛcirɛ riyóó. ");
INSERT INTO soy_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Uléécɑɑ yɛ pɛɛ hɑ́i mɛkɛɛ-mɛ Uléécɑɑ Nsímɛ́ ɑtɛlɛ́ kɛ́mɛɛ ɑntepuyɛ mɑɑsɛ rɛ u yɛ́ Nsímɛ́ Kɛcirɛ mmɛ̃ tɔ́ pɑ. ");
INSERT INTO soy_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Ukɛpipi Urɔ́píimɑ kɛcɑ́ɑ́ nsímɛ́ yɛ mu. Pi u mɑrilɛ mɛsoi. U uyɔ́ɔpi Tɑfiti kɛpirɛ̃ lɛ. ");
INSERT INTO soy_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Kɛ Uléécɑɑ uu pikpɔkpɔ kɛ́mɛɛ u n yukusɛ nnyɑ kuu u sée rɛ Ukɛpipi, uu kɔ Unfɑɑsɔnɛ nɛ tiki uú nɛ linnɑŋɛ u hɛ. ");
INSERT INTO soy_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Urɔ́píimɑ Yeesu Kirisi kɛ Uléécɑɑ uú nɛ ritiki uú nɛ ípɛɛlɛ́ɛ nɛ́ nyísɛ rɛ kɛ́ pɑnsɛ utumɛ, kɛ́ kɔ tíyɛsɛ ipuri nnɛ́í pisoi pikɛ́ Kirisi rinyiri nnyɑ nɛ kɛfɑ tɛnɛ, pikɛ́ pɛɛ uyɛ̃ Uléécɑɑ m pɑkɑrɛlɛ̃. ");
INSERT INTO soy_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Nɔ́ mpí kɛ Yeesu Kirisi uu nní n sée, nɔ̃́ nɛ kɔ lipite pɛ̃ kɛ́mɛɛ́ welɛ. ");
INSERT INTO soy_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Nɔ̃́ Rɔm pikɔ́ mpí nnɛ́í kɛ Uléécɑɑ uu nní ń lɑ uu kɔ nɔ́ wɛ́ɛ rɛ ɑni pɑnsɛ upikɔ́ kɑm títɛlɛ́ ntí wɔ́lu. Urɔ́sɑ́ɑ Uléécɑɑ nɛ Urɔ́píimɑ Yeesu Kirisi pikɛ́ ípɛɛlɛ́ɛ nɔ́ nyísɛ ɑpi nkíŋniŋɛ nɔ́ hɛ! ");
INSERT INTO soy_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Pi kɛtẽ nkɛ́ nnɛ́í nɔ́nnɛ́fɑtɛnɛ nsímɛ́ símisilɛ ńsɔnɛ. Lɛ̃ nnyɑ kɑḿ lɑ kɛ́ nɛ Yeesu Kirisi ritiki kɛ́ nɛ nɔ̃́ nnyɑ Uléécɑɑ pɔɔnɛsɛ kɛlenɛ. ");
INSERT INTO soy_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Uléécɑɑ uyɛ̃ kɑm n yɑ́ɑ́si nɛn Ukɛpipi Nsímɛ́ Kɛcirɛ yóólɛ̃ yɛ́ itɑnsei nɛ́ li rɛ mɛsɛ́rɛ kɑm nɔ́nnɛ́símɛ́ símisi ");
INSERT INTO soy_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","nɛn kɔ ḿpɑ́ píyei nɔ́kɛnɛ́cɑ́ɑ́ yɑ́ɑ́si. Nɛ yɛ pisɛ rɛ ukɛ́ lɛ̃ umɛlɑ kɛ́mɛɛ ncée nɛ́ hɛ kɛ́ nɔ́kɛnɛ́mɛɛ́ hɑpɔ. ");
INSERT INTO soy_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Lɛ̃ nnyɑ, li pɛɛ mɛyíkíyiki ripɔ́ɔ nɛ́ we rɛ kɛ́ piyɛ́nɛ nɔ́ hɑpɔ kɛ́ lɛ̃ kɛ Nfɑ́ɑsɔnɛ nn nɛ́ n hɛ nɔ́ ritɛ́ŋ́sɛ nɔkɛ́ iníŋí wɑ. ");
INSERT INTO soy_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Nɛ lɑ kɛ́ mɑɑ rɛ nɛ nɔ́kɛnɛ́mɛɛ sɔ́nɛpɔlɛ rɛ nfɑtɛnɛ mmɛ̃ kɛ tɔ́ nɛ nnɔ̃́ ɑri kɛsẽ́ m mɑ́ nkɛ́ tíyɛsɛ tɔkɛ́ ikɑri kpɑriisɛnɛ. ");
INSERT INTO soy_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Pimɑ́rɛcɔ, nɛ lɑ rɛ ɑni kõ tɛ nɛ pɛɛ mɛnɛ́círɛ cɑ́pinɛlɛ kɛ́ pilóólú nɔ́ hɑpɔ, ɑmɑ́ hɑ́i nɛ nkpéni-mɛ ɑ́m kɑhɑnɛ ncée n yɛ̃. Nɛ pɛɛ́ lɑ rɛ pinɛ́kɛi pikɛ́ kɔ nɔ̃́ kɛ́mɛɛ kulɑ́ɑ wɑ yɑrɛ kɑpi kɛtẽ kɛcɑ́ɑ́ isoipuri icɔ kɛ́mɛɛ kulɑ́ɑ n wɑ mɛcɔ. ");
INSERT INTO soy_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Li nɛ́ pisɛ rɛ kɛ́ ḿpɑ́ píye kɛ́mɛɛ́ hɑ, ɑyu nɛ sicɑrɛ kɛ́mɛɛ pisoi nɛ pisɔhɔɔ nɛ pɛpɛɛ ɑ́pi líkɑ n nyu kɛ́mɛɛ kɑi pisɛ rɛ kɛ́ hɑ. ");
INSERT INTO soy_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Lɛ̃ nnyɑ kɑi ripɔ́ɔ nɛ́ we rɛ kɛ́ kɔ nɔ́ mpí nɔ́ɔ nní Rɔm kuyu-i ń we Nsímɛ́ Kɛcirɛ riyóó. ");
INSERT INTO soy_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Nsímɛ́ Kɛcirɛ mmɛ̃ ńn isɛi nɛ́ we. Ńnɑŋɛ nnyinɛ yɛ mu kɛ Uléécɑɑ uu yɛ nɛ pɛ̃ nnɛ́í pɛɛ nɛ kɛfɑ u n tɛnɛlɛ̃ ɑyu n lɔ. Pisuifi kuú nɛ korɑɑnɛ uú nɛ mpuri sɑnɛ pikɔ́ kɛ́mɛɛ tulu. ");
INSERT INTO soy_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Asei kɛcɑ́ɑ́, kei kɑi yɛ nɛ nyísɛ rɛ Uléécɑɑ yɛ̀ɛ̀ pisoi pɑnsɛsɛlɛ ɑsei pite. Uyɛɛ nɛ Uléécɑɑ kɛfɑ n tɛnɛlɛ̃ mɛcirɛ kóló kuu yɛ nfɑtɛnɛ mmɛ̃ ŋmɑnɛ nnyɑ yɛ̃ tɛ u ɑsei ute lɛ. Lɛ̃ kɑi nní Nléécɑɑsimɛ́ ritɛlɛ́-i wɔ́lɑɑlɛ̃ tɛ: Nkó yɛɛ nfɑtɛnɛ nnyɑ m pɑnsɛ ɑsei ute yɛɛ nfɑ́ɑ mɑ́. ");
INSERT INTO soy_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Uléécɑɑ kuwɔi yɛ kɛyómɛcɑɑ-pɔ wemɛlɛ. Pɛpɛɛ ɑ́pi u n wɑisɛlɛ̃ ɑ́pi kɔ umɛlɑ tikilɛ̃ pɛɛ yɛ́ nɛ ku risɑ́nɛ. Pi nsímɛ́sei nyulɛ, ɑmɑ́ pin pɛɛ pimɛwee kópɛ nɛ tɑ́pɑɑlɛ̃ tɛ pisoi ɑ́pi kɑpɛ ɑsei ceri. ");
INSERT INTO soy_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Pi lɛ̃ kɛ kɛsoipipi ɑkɛ yɛ́ ń fe ɑkɛ Uléécɑɑ kɛcɑ́ɑ́ céru pinyuwɛ mɑ́ɑ́lɛnlɛ. Likumúŋɛ́ rɛ Uléécɑɑ ricuruu yɛɛ li pi cereisɛ. ");
INSERT INTO soy_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Asei kɛcɑ́ɑ́, Uléécɑɑ likɔ́ ɑ́i kúyɛnɛ we, ɑmɑ́ umɛwɑi kɛ́mɛɛ kuu yɛ umɛcirɛ lesɛ uu nyísɛ kɛsoipipi ɑkɛ́ nɛ u yɛnu. Uyɛɛ kɛtẽ nɛ kɛyómɛ wɑ nnyɑ, pi yɛ́ fe ɑpi kei nɛ yɛnu rɛ u ńnɑŋɛ tɛnɛcirɛ́ mɑ́lɛ un kɔ Uléécɑɑ. Sisoipipi ɑ́si yɛ́ ncée yɛ̃ sikɛ́ rɛ ɑ́si likɛcɑ́ɑ́ nyu. ");
INSERT INTO soy_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Si Uléécɑɑ nyulɛ, ɑmɑ́ ɑ́si yɛ pɛɛ ríyu u wɑisɛ, ɑ́si yɛ kɔ u pɔɔnɛsɛ yɑrɛ kɑsi yɛ́ pɛɛ u m pɔɔnɛsɛ rɛ u Uléécɑɑ nnyɑ. Amɑ́ inírisimɛ́ kɛ pisoi ɑpí nɛ mɛ́sunu ɑpí nɛ pimɛcirɛ fómni, pikɛmúŋɛ́ ɑkɛ pɛɛ kuníri kɑpi m mɑ́ nnyɑ kuŋmɑhɑ-i lompɔ. ");
INSERT INTO soy_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Pin pimɛcirɛ nyɑ́ni yɑrɛ pi mɛwɛ́ɛ́sɛsɔhɔ mɑ́lɛ, nɛ́mpɑ́kɑnɛ piníri ŋmɑɑ yɛ pi. ");
INSERT INTO soy_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Api yúlu rɛ ɑ́pi yɛ́ riwulɑ pikɛ́ Uléécɑɑ kpɔcirɛ́ pɑkɑrɛ, ɑpí nyɑ ɑpi consɛ ɑpi pɛɛ kɛsoipipi kɛɛ yɛ n kpu nɛ sinúipi nɛ ɑ́nɑ ɑnɑ likɔ́ nɛ límuŋui-muŋui sɛ́ru rɛ piléé ɑpi yɛ wulɑ ɑpi lɛ̃ pɑkɑrɛ. ");
INSERT INTO soy_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Lɛ̃ nnyɑ kɛ Uléécɑɑ uu pi riyɑ́ rɛ pikɛ́ mɛ́kpɛrinkpɛwɑi kɑpi pisifɑ-i m músu n wɑi pikɛ́ nɛ piipiŋɛ cirɛ isɛi m pɔ́rii. ");
INSERT INTO soy_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Pi nnɔ́ɔmɛ likɔ́ kpísi ɑpí nɛ Uléécɑɑ kɛcɑ́ɑ́ nsímɛ́sei consɛ, ɑpi wúlɑ ɑpi lɛ̃ kɛ Uléécɑɑ uu n wɑ yɑ́ɑ́si, ɑpi pɛɛ Uléécɑɑ yɛɛ ḿpɑ́ yo n wɑ piyɑ́hɑɑ yulu, in kɔ nɛ uricuruu kɑí nɛ sɑ́ rɛ pikɛ́ yɑ́ɑ́si hɑ́i nɛ ḿpɑ́ píyei-pɔ. Amí. ");
INSERT INTO soy_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Lɛ̃ nnyɑ kɛ Uléécɑɑ uu pisɛicirɛ́kɛi pi tɑ̃, pinɔ́si ɑpi pipilɑ yɑ́, pi nɛ pinɔ́sicɔ ɑpí hɑ n sói, ɑ́i kɔ pɛɛ́ nɛ sɑ́ rɛ likɛ́ lɛ̃. ");
INSERT INTO soy_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Pitisi pɔ́ɔ kɔ limɛcɔ pipinɔsi yɑ́, ɑpí hɑ nɛ nnɑ́ɑ́pí pipitisicɔ n sói, lin pisoi isɛi we. Lɛ̃ nnyɑ, pimɛmɑrɛ kópɛ mɛ̃ kulɑɑ kɑpi lɛ̃ yɛ̃. ");
INSERT INTO soy_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Kɑ́pi nní n wɛ́ɛ́si pikɛ́ Uléécɑɑ céri nnyɑ, Uléécɑɑ yɛ pi riyɑ́lɛ pikɛmúŋɛ́ ɑkɛ cɔ́kɔi, ɑpi pɛɛ́ n wɑpisi ɑ́i nɛ sɑ́. ");
INSERT INTO soy_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Mɛwɑi kópɛ ncɔpuri nɛ rikpɑ́kɑ́rɑ́ nɛ nwóónɑɑpí nɛ kufɑtoi kpɛɛ pisifɑ-i we. Pikɑ́ipinkɛɛ nɛ pisoikṍ nɛ pipɑ́sɑinɛ nɛ piyɑɑlukɛ nɛ mɛ́mɑrɛ kópɛ mɛɛ pisifɑ-i cɔpɑɑlɛ̃. Pimɛcɔpɛcirɛ kɑpi wɔ́hɑɑnɛ, pin ɑ́yu kónɑɑnɛ, ");
INSERT INTO soy_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","pin kɔ Uléécɑɑ ilɑ́ɑrɔ wɑi. Ápi yɛ úkɑ wɑisɛ, pin ɑ́yu wɛ́ɛ́si, pin pimɛcirɛ nyísɛ. Pi mɛwɑi kópɛ piwɑi kɛ́mɛɛ pelɑɑlɛnlɛ, ɑ́pi yɛ pisɑ́ɑ nɛ píni pɑkɑrɛ. ");
INSERT INTO soy_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Ái we rɛ usoi ukɛ́ nɛ pi ritɑ́, ɑ́pi ńlɑ mɑ́ ɑ́pi yɛ líkɑ nɑrɛsi ɑ́pi yɛ íwɛ tẽ́. ");
INSERT INTO soy_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Pi kɔ pɛɛ isé kɛ Uléécɑɑ uu n yekei nyulɛ. I mɑɑ rɛ pɛpɛɛ limɛwɑi mɛ̃ n wɑi yɛ nɛ sɑ́ rɛ pikɛ́ pi kṍ. Pi kɔ pɛɛ li wɑilɛ. Lɛ̃ mɛmɑ́ɑ́, pi yɛ kɔ pɛpɛɛ lɛ̃ n wɑi kɛcɑ́ɑ́ rikpɑ́lɛ. ");
INSERT INTO soy_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Ḿpɑ́ pɔn usoi úye mpuri, pɔ́ nkó pɔ́ɔ nní nɛ picɔ n túhɑɑnɛ pɔn ɑkópɛ pi pɑlɛ̃, ɑ́i we rɛ pikɛ́ íwɛ pɔ́ tẽ́. Pɔ́ɔ nní nɛ picɔ n túhɑɑnɛ pɔn ɑkópɛ pi pɑlɛ̃, mɛpɔ́círɛ kɑɑ lɛ̃ ɑkópɛ pɑlɛ̃. Liriyíkí rɛ pɔ́ɔ nní nɛ picɔ n túhɑɑnɛ, pɔ̃́ nɛ kɔ pimɛcɔ wɑilɛ. ");
INSERT INTO soy_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Tɔ mɛyíkíyiki nyulɛ rɛ nsímɛ́sei kɛ Uléécɑɑ uu yɛ nɛ pɛpɛɛ lɛ̃ n wɑi túhɑɑnɛ. ");
INSERT INTO soy_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Pɔ́ nkó pɔ́ɔ nní nɛ pɛpɛɛ lɛ̃ n wɑi n túhɑɑnɛ pɔn kɔ pimɛcɔ wɑi, pɔ músu rɛ pɔ̃́ nɛ́ Uléécɑɑ kɛtɑhɑi kɛ́mɛɛ́ lee? ");
INSERT INTO soy_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Nɛ́ɛ Uléécɑɑ mɛwɑi sɔnɛ píimɑ nɛ uisoi niŋɛ-niŋɛ nɛ unfɑnɑrɛ kɑɑ lómiisɛ. Áɑ nyu rɛ umɛwɑi sɔnɛ píimɑ mɛɛ lɑ rɛ ɑ mɛfinɛ consɛɛ? ");
INSERT INTO soy_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Amɑ́ ripɔ́kíŋ ntɑkɛ nɛ kɑɑ n yúlu rɛ ɑ́ɑ yɛ́ mɛfinɛ consɛ nnyɑ, mɛpɔ́círɛ kɑɑ lɛ̃ kuwɔ́i píimɑ cɑ́pinɛ kɛyɑ́ɑ kɛ̃ kɛ Uléécɑɑ uú nɛ nsímɛ́sei ukuwɔi kɛ́mɛɛ pisoi n túhɑɑnɛnɛ. ");
INSERT INTO soy_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Kɛtúhɑɑnɛ kɛ-i kɛ Uléécɑɑ uu yɛ́ ḿpɑ́ úye mɛwɑi ihɛ́ɛ́ u pɑ. ");
INSERT INTO soy_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Uu pɛpɛɛ lisɔnɛ piwɑi nɛ n ŋmɔ́ɔ́púlɛ̃ nfɑ́ɑ tɛnɛcirɛ́ hɛ. Pi lɛ̃ wɑilɛ rɛ ukɛ́ umɛyɔɔpi pi hɛ ukɛ́ kɔ ríyu pi wɑisɛ ukɛ́ kɔ tíyɛsɛ pikɛ́ pɑnsɛ picɑɑicirɛ́. ");
INSERT INTO soy_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Amɑ́ Uléécɑɑ yɛ́ pɛpɛɛ nɛ u n kɛ́ŋɛnɛ ɑ́pi lɑ pikɛ́ nsímɛ́sei kutu ricɔ, pin pɛɛ lɛlɛɛ ɑ́i nɛ n sɑ́ kutu cɔlɛ̃ kɛcɑ́ɑ́ ukuwɔi píimɑ súisɛ. ");
INSERT INTO soy_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Píwɛlukɛ nɛ nwuutúũ mɛɛ mpí nnɛ́í pɛɛ mɛwɑi kópɛ n wɑi likɔ́. Pisuifi kɑí nɛ mɛfoí mɑ́nɛ, ɑi pɛɛ́ nɛ mpuri sɑnɛ pikɔ́ kpɑ́. ");
INSERT INTO soy_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Tíyu nɛ ipɑkɑrɛ nɛ nkíŋniŋɛ mɛɛ mpí nnɛ́í pɛɛ lisɔnɛ n wɑi likɔ́. Pisuifi kɑí nɛ mɛfoí mɑ́nɛ, ɑi pɛɛ́ nɛ mpuri sɑnɛ pikɔ́ kpɑ́. ");
INSERT INTO soy_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Uléécɑɑ úu pisoi nɛ picɔ kóólɛnɛ. ");
INSERT INTO soy_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Mpí nnɛ́í pɛɛ ɑ́pi isé kɛcɑ́ɑ́ n nyu ɑpí nɛ ɑkópɛ wɑi yɛ kpíninɛ ɑ́pi ikɛcɑ́ɑ́ nɛ pi túhɑɑnɛnɛ. Amɑ́ pɛpɛɛ ikɛcɑ́ɑ́ ń nyu ɑpí nɛ ɑkópɛ wɑi yɛ kpíninɛ ɑpi ikɛcɑ́ɑ́ nɛ pi túhɑɑnɛ. ");
INSERT INTO soy_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Asei kɛcɑ́ɑ́, ɑ́i mpí pɛɛ yɛ isé kutu ŋmɑnɛ rińcɔ pɛɛ Uléécɑɑ inipɛɛ-i ɑsei pite. Amɑ́ mpí pɛɛ isé n tíkilɛ̃ kɑpi yɛ hɑ mɑɑ rɛ ɑsei pite. ");
INSERT INTO soy_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","In tɛ mpuri sɑnɛ pikɔ́ pɛɛ ɑ́pi Uléécɑɑ isé n nyu yɛ pɛɛ isé iyɛ̃ tikilɛ̃, li wɑ yɑrɛ i pisifɑ kɛ́mɛɛ́ welɛ pin nɛ i sɔ́nɛ, ḿpɑ́ kɑ́pi nní i n nyu. ");
INSERT INTO soy_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Pi lɛ̃ nyísɛlɛ rɛ lɛlɛɛ isé iyɛ̃ kɛ́mɛɛ ń we yɛ pisifɑ kɛ́mɛɛ́ welɛ. Pikɛmúŋɛ́ yɛ̀ɛ̀ pi nyísɛlɛ ɑpi céru rɛ pi yɛ pinyinɛ-i ɑkópɛ wɑlɛ, ɑkɛ yɛ kɔ pinyinɛ-i ɑlɑri pi pɑ. ");
INSERT INTO soy_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Lɛlɛɛ hɑ leerinɛ kɛyɑ́ɑ kɛ̃ kɛ Uléécɑɑ uu Nsímɛ́ Kɛcirɛ kɑm n yóólɛ̃ ḿ pɑínɛ uú nɛ pisoi túhɑɑnɛ. Kirisi Yeesu kuú nɛ tikinɛ uú nɛ lɛ̃ nnɛ́í kɛ pisoi ɑpi n wɑi pin pékesi kɛcɑ́ɑ́ pi túhɑɑnɛ. ");
INSERT INTO soy_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Pɔ́ nkó pɔ́ɔ nní mɛpɔ́círɛ rinyíri n hɛ rɛ Usuifi, pɔn nɛ isé tɑ́lɛ̃, pɔn Uléécɑɑ nnyɑ rikɔ́kɔri wɑi, ");
INSERT INTO soy_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","pɔn umɛlɑ nyu, pɔ̃́ kuu uisé kɛ́mɛɛ n céesi rɛ ɑ yɛ lɛlɛɛ licɔ nɛ kɛkpéẽ ń we ceri, ");
INSERT INTO soy_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","pɔ́ɔ nní mɛpɔ́círɛ n nyɑ́ni rɛ pɔ́ɔ pinyíyɛ tɔrikɛɛ, pɔn kɔ pɛpɛɛ kuŋmɑhɑ kɛ́mɛɛ ń we mɛtɛ́í, ");
INSERT INTO soy_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","nɛ piníri nɛ siwɑ̃́ ucélɑɑ, rɛ pɔ isé kɛ́mɛɛ mɛnyuwɛ nɛ nsímɛ́sei yɛ̃ nnyɑ, ");
INSERT INTO soy_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","pɔ nkpéni nní lɛ̃ picɔ céesilɛ, ɑɑ pɛɛ mɛpɔ́círɛ picélɑɑ pɔɔnɛ. Pɔ yɛ rɛ ɑ́pi kɑpɛ yɛ yɑ́ɑi, ɑmɑ́ pɔ́ɔn pɛɛ yɑ́ɑ́i! ");
INSERT INTO soy_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Pɔ yɛ kɔ rɛ ɑ́pi kɑpɛ yɛ iwɑ́sɑ́ wɑ, ɑmɑ́ pɔ́ɔn pɛɛ iwɑ́sɑ́ wɑi! Pɔ yɛ rɛ pɔ piléé kɔ́hɔlɛ, pɔn kɔ pɛɛ pilikɔ́ yɑ́ɑ́inkɛɛ! ");
INSERT INTO soy_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Pɔ́ɔ nní isé nnyɑ rikɔ́kɔri n wɑi, pɔ yɛ kɔ isé rilɔ́ɔ́lɛ ɑɑ́ nɛ Uléécɑɑ riyu kopu. ");
INSERT INTO soy_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Li Nléécɑɑsimɛ́ kɛ́mɛɛ wɔ́lɑɑlɛ̃ tɛ: Nɔ̃́ nnyɑ, Uléécɑɑ rinyiri yɛ mpuri sɑnɛ pikɔ́ kɛ́mɛɛ cɑɑilɛ. ");
INSERT INTO soy_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Asei kɛcɑ́ɑ́, in tɛ nɔ isé tíkilɛ̃ kɛ piké ɑpi yɛ́ kulɑ́ɑ nɔ́ wɑ. In tɛ nɔ isé rilɔ́ɔ́, nɔ́pinɛ́ké yɛ we yɑrɛ kukécirɛ́. ");
INSERT INTO soy_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","In tɛ ukécirɛ́ yɛ lɛ̃ kɛ isé ii m pisɛ kɛcɑ́ɑ́ sɔ́nɛ, ɑ́ni yɛ̃ tɛ ukukécirɛ́ yɛ́ Uléécɑɑ kɛ́mɛɛ́ n we yɑrɛ pi u rikélɛɛ? ");
INSERT INTO soy_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Mpuri kécirɛ́ ukɔ́ un isé n tikilɛ̃, úu yɛ́ tíyɛsɛ pɔ́ nkó pɔ́ɔ nní isé n nyu ɑ́ɑ yɛ pɛɛ i ritiki, pɔn kɔ kélɛ̃, ɑɑ yɛ́nu rɛ pɔ ɑkópɛ mɑ́lɛɛ? ");
INSERT INTO soy_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Lɛ̃ nnyɑ, ɑ́i ipiŋɛ kɛcɑ́ɑ́ piké mpí pɛɛ yɛ nyísɛ rɛ usoi yɛ Usuifi lɛ. Ái kɔ ipiŋɛ kɛcɑ́ɑ́ piké mpí pɛɛ piké yíkíyiki. ");
INSERT INTO soy_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Amɑ́ lɛ̃ kɛ usoi uu kɛfɑ kɛ́mɛɛ ń we lɛɛ yɛ nyísɛ rɛ u Usuifi lɛ. Lɛ̃ kɑpi yɛ mɑɑ rɛ usoi yɛ mɛyíkíyiki kélɛnlɛ. Uléécɑɑ Nfɑɑsɔnɛ mɛké yɛ mɛ̃, ɑ́i isé mɛkɔ́. Ái pisoi kɛ́mɛɛ́ kɛ Usuifi uyɛ̃ mpuri ipɑkɑrɛ ii yɛ leemɛ, ɑmɑ́ Uléécɑɑ kɛ́mɛɛ le. ");
INSERT INTO soy_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","In lɛɛ ni, kulɑ́ɑ yɛ kúye rɛ usoi ukɛ́ Usuifi? Yo kɛ piké ɑpi yɛ yoriyɛ? ");
INSERT INTO soy_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Kulɑ́ɑ yɛ linnɛ́í kɛ́mɛɛ́ welɛ ɑ́ku kumúŋɛ́ mɑ́. Kufoí yɛɛ rɛ Pisuifi kɛ Uléécɑɑ uú nɛ mɛfoí símisi uu Unsímɛ́ piɑnipɛ-i wɑi. ");
INSERT INTO soy_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Asei yɛ kɔ nyɛ rɛ pikɛcɔpɛ pinyinɛ ɑ́pi ɑsei ritiki. Lɛ̃ nnyɑ, piɑsei kutikicirɛ́ yɛ́ tíyɛsɛ Uléécɑɑ pɔ́ɔ kɔ ɑsei pitíki yɑ́ɑ́? ");
INSERT INTO soy_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Ái nkpɑ́ni lɛ̃. Ái céreisɛ rɛ ḿpɑ́ usoi úye yɛ unɔ́ɔmɛ lɛ, ɑmɑ́ Uléécɑɑ pɔ̃́ nɛ ɑsei tikilɛnlɛ. Li likɛcɑ́ɑ́ wɔ́lɑɑlɛ̃ tɛ: Li pisɛ rɛ ɑpɔ́nɔ́ɔ ɑkɛ́ n nyísɛlɛ̃ tɛ pɔ ɑsei ute lɛ. Ńkɑ ńn wenɛ kɑpi yɛ́ nɛ mɛpɔ́túhɑɑnɛ kɛ́mɛɛ pɔ́ n cɛ́si. ");
INSERT INTO soy_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Amɑ́ in tɛ ɑrɔ́sei kutikicirɛ́ yɛ́ tíyɛsɛ ɑi nyísɛ rɛ Uléécɑɑ yɛ ɑsei tikilɛnlɛ, tɔ́ pɛɛ mɑɑ rɛ íye? Tɛ kɛ Uléécɑɑ uu yɛ́ nní likɛcɑ́ɑ́ ukuwɔi rɔ́ ń nyísɛ nnyɑ, úu ɑsei tikilɛ̃ɛ? Lɛ̃ kɛ sisoipipi ɑsi yɛ m pisɛ mɛcɔ kɑm nní pisɛ. ");
INSERT INTO soy_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Ái nkpɑ́ni lɛ̃. In pɛɛ lɛ̃, íye kɛ Uléécɑɑ uu yɛ́ nɛ pisoi nnɛ́í túhɑɑnɛ? ");
INSERT INTO soy_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","In tɛ nnɛ́nɔ́ɔmɛ yɛ́ tíyɛsɛ ɑi nyísɛ rɛ Uléécɑɑ yɛ ɑsei tikilɛnlɛ, ɑi kɔ ríyu u wɑisɛ, yo nnyɑ kɛ Uléécɑɑ uu yɛ́ pɛɛ kɔ nɛ rɔ́ túhɑɑnɛ rɛ tɔ pikópɛkɔɔ́ lɛ? ");
INSERT INTO soy_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Yo nnyɑ kɑ́ri yɛ́ fe tɔkɛ́ mɑɑ rɛ: Lɛ̃ nnyɑ, tɔkɛ́ ɑkópɛ wɑ lisɔnɛ likɛ́ nɛ ɑkɛmɛɛ léemɛ? Pisoi pinyinɛ pɛɛ tirɔ́yu n kópu yɛ rɛ tɔ́ɔ yɛ lɛ̃ mɑ. Uléécɑɑ yɛ ɑlɑri mɑ́lɛ ukɛ́ lɛ̃ nnyɑ lipite kutu ripɑsɑ. ");
INSERT INTO soy_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Tɔ́ nkpéni mɑɑ rɛ íye? Tɛ tɔ̃́, Pisuifi yɛ mpuri sɑnɛ pikɔ́ fe, nɛ́ɛ íye? Ái nkpɑ́ni lɛ̃. Tɔ pisímɛ́ mɑsilɛ rɛ ɑkópɛ yɛ ńnɑŋɛ mɑ́lɛ ɑn nɛ kɛsẽ́ Pisuifi nɛ mpuri sɑnɛ pikɔ́ múílɛ̃. ");
INSERT INTO soy_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Li Nléécɑɑsimɛ́ ritɛlɛ́ kɛ́mɛɛ wɔ́lɑɑlɛ̃ tɛ: Usoi úkɑ úu ɑsei tikilɛ̃. Ḿpɑ́ ucírɛníŋɛ yíkíyiki nkó nní úu we. ");
INSERT INTO soy_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Úkɑ mpuri úu mɛsɔhɔ mɑ́. Úkɑ mpuri úu Uléécɑɑ wɛ́ɛ́si. ");
INSERT INTO soy_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Pinnɛ́í yɛ ncée kɛcirɛ pitíki riyɑ́lɛ. Api kɛsẽ́ pinnɛ́í isoi kpɑ́rɑ́ n wɑi. Úkɑ mpuri úu lisɔnɛ wɑi, ḿpɑ́ ucírɛníŋɛ yíkíyiki nkó nní úu we. ");
INSERT INTO soy_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Pinnɔɔsimɛ́ yɛ rikpíí lɛ tɛɛ n hɑ́ɑlɛ̃. Piɑlempi kɑpí nɛ nnɔ́ɔmɛ wɑpisi. Mɛlõ yɛ pinnɔɔ-i kúlɑɑlɛnlɛ yɑrɛ iwɑ́ɑ yɛɛ n kóni. ");
INSERT INTO soy_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Awéeri nɛ nsímɛ́ kópɛ yɛɛ pinnɔɔ-i yipɑɑlɛ̃. ");
INSERT INTO soy_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Piɑnɑ ɑ́ɑ kusɑ mɛ́nyɛ pikɔikɛɛ kɛ́mɛɛ wɛ́lú. ");
INSERT INTO soy_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Ḿpɑ́ yei kɑpi lompɔ, picɑɑinkɛɛ nɛ picɔ íwɛ piwɑi yɛɛ pilikɔ́. ");
INSERT INTO soy_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Ápi ncée mɛɛ yɛ nɛ nkíŋniŋɛ ń kɑ nyu. ");
INSERT INTO soy_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Ápi piisoi kɑpi n le kɛ́mɛɛ Uléécɑɑ wuru. ");
INSERT INTO soy_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Tɔ kɔ pɛɛ nkpéni nyulɛ rɛ li Uléécɑɑ isé kɛ́mɛɛ wɔ́lɑɑlɛ̃ tɛ pɛpɛɛ isé mɛtíki m mɑ́ nnyɑ kɛ isé iyɛ̃ ii wɔ́lɑɑlɛ̃, nsímɛ́ nkɛ́ nɛ ḿpɑ́ úye n lukɑɑlɛ̃ nnyɑ. Sisoipipi nnɛ́í yɛ Uléécɑɑ inipɛɛ-i sikópɛkɔɔ́ lɛ. ");
INSERT INTO soy_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Úkɑ mpuri úu fe ukɛ́ lɛ̃ kɛ isé ii m pisɛ wɑ. Lɛ̃ nnyɑ kɛ úkɑ úu yɛ́ fe ukɛ́ Uléécɑɑ kɛ́mɛɛ ɑlɑri yɛ̃. Isé yɛ tíyɛsɛlɛ usoi uu céru rɛ u ukópɛkɔɔ́ lɛ. ");
INSERT INTO soy_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Lɛ̃ kɛ isé ricuruu nɛ ɑntepuyɛ ɑpí pɛɛ mɛkɛɛ-mɛ ḿ mɑ yɛɛ nkpéni nní wɑ. Uléécɑɑ úu nɛ isé ritiki ukɛ́ nɛ sisoipipi wɑisɛ ɑsei pite. ");
INSERT INTO soy_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Pɛ̃ nnɛ́í pɛɛ lɛ̃ kuú nɛ Yeesu Kirisi rintíki uu wɑi ŋmɑnɛ kóló nɛ kɛfɑ n tɛnɛ kuu yɛ sée rɛ ɑsei pite. Likumúŋɛ́ rɛ Uléécɑɑ úu pisoi nɛ picɔ kɛcɔpɛ kóólɛnɛ. ");
INSERT INTO soy_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Sisoipipi nnɛ́í yɛ ɑkópɛ wɑlɛ, ɑsi Uléécɑɑ mɛyɔɔpi pɑɑ. ");
INSERT INTO soy_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Amɑ́ Uléécɑɑ yɛ uipɛɛlɛ́ɛ kɛ́mɛɛ pi pɑnsɛsɛlɛ ɑsei pite, fɑɑlɑɑ ɑ́pi kɔ líkɑ hɛ́ɛlɛ. Yeesu Kirisi yɛɛ umɛcirɛ kpísi uu hɛ nnyɑ kɛ Uléécɑɑ uú nɛ piɑyu lɔ. ");
INSERT INTO soy_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Uyɛ̃ kɛ Uléécɑɑ uu wɛ́ɛ rɛ ukɛ́ umɛnyɛ nɛ inyɔ́ɔnsɛ wɑ ikɛ́ pɛ̃ nnɛ́í pɛɛ umɛnyɛ mɛ̃ nɛ kɛfɑ n tɛnɛ ɑkópɛ sɑ́rɛi ukɛ́ nɛ nyísɛ rɛ u ɑsei ute lɛ. Úu pɛɛ mɛkɛɛ piɑkópɛ ɑkpɑnii pi wɑ. U pɛɛ́ nɛ kɛ́yu pi purulɛ. ");
INSERT INTO soy_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Lɛ̃ kuú nɛ nyísɛ rɛ u ɑsei tikilɛnlɛ, úu nkpɑ́ni consɛ. Uléécɑɑ yɛ kɔ lɑlɛ ukɛ́ nfɑ́ɑni kɛtẽ nkɛ́ kɛ́mɛɛ nyísɛ rɛ u kɔ nɛ urinɔɔ kuu ḿ mɑ kɛcɑ́ɑ́ welɛ. Likumúŋɛ́ rɛ pɛ̃ nnɛ́í pɛɛ Yeesu nɛ kɛfɑ n tɛnɛlɛ̃ ŋmɑnɛ kuu yɛ yɛ̃ tɛ ɑsei pite. ");
INSERT INTO soy_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Tɔ̃́, Pisuifi yɛ pɛɛ nnyinɛ mɑ́ tɔkɛ́ nɛ picɔ rikɔ́kɔri n wɑii? Aɑi, ńkɑ ńn we! Isé pitiki nnyɑ nɛ́ɛ mɛwɑi sɔnɛ nnyɑ? Ái nkpɑ́ni lɛ̃. Likumúŋɛ́ rɛ ɑ́i isé kɑi pisɛ rɛ usoi ukɛ́ ritiki, ɑmɑ́ nfɑtɛnɛ kɑi pisɛ rɛ usoi ukɛ́ m mɑ́. ");
INSERT INTO soy_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Tɔ kɔ yɛ̃ tɛ ɑ́i kɛ kɛsoipipi ɑkɛ yɛ́ lɛ̃ kɛ isé ii m pisɛ n wɑ nnyɑ kɑkɛ yɛ́ Uléécɑɑ kɛyu-i ɑsei m mɑ́, ɑmɑ́ kɑkɛ́ nɛ kɛfɑ n tɛnɛ nnyɑ kɑkɛ yɛ́ ɑsei m mɑ́. ");
INSERT INTO soy_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Nɛ́ɛ Uléécɑɑ yɛ Pisuifi ŋmɑnɛ Uleecɑɑ lɛ? Yɑrɛ úu mpuri sɑnɛ pikɔ́ Uleecɑɑ, nɛ́ɛ íye? Ɛɛɛ, u kɔ mpuri sɑnɛ pikɔ́ Uleecɑɑ lɛ, ɑsei kɛcɑ́ɑ́. ");
INSERT INTO soy_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Uléécɑɑ usɛ yɛɛ we yɛɛ nfɑtɛnɛ nnyɑ pikéké pɑnsɛsɛnɛ ɑsei pite. Limɛcɔ kuu pikécirɛ́ nfɑtɛnɛ nnyɑ pɑnsɛsɛnɛ ɑsei pite. ");
INSERT INTO soy_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Yɑrɛ tɔ nkpéni lɛ̃ mɑɑ rɛ nfɑtɛnɛ nnyɑ, isé nkɔ́ yɛ pɛɛ tɛnɛlɛ nɛ́ɛ? Ái nkpɑ́ni lɛ̃! Tɔ mɛníŋɛ isé nnɑŋɛ nnɛ́í i pɑlɛnlɛ. ");
INSERT INTO soy_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Tɔ́ nkpéni urɔ́sɑ́ɑyɑhɑ Apirɑhɑm pɔ̃́ nkɔ́ mɑɑ rɛ íye? Yo kuu Uléécɑɑ kɛ́mɛɛ yɛ̃́? ");
INSERT INTO soy_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","In pɛɛ Apirɑhɑm liwɑiwɑi nnyɑ kɛ Uléécɑɑ uu u pɑnsɛsɛ ɑsei ute, Apirɑhɑm yɛ́ pɛɛ fe uu lirikɔkɔri n wɑi. Amɑ́ ɑ́i nkpɑ́ni lɛ̃ we Uléécɑɑ kɛ́mɛɛ. ");
INSERT INTO soy_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Nléécɑɑsimɛ́ ritɛlɛ́ yɛ mɑɑ rɛ: Apirɑhɑm uú nɛ Uléécɑɑ kɛfɑ tɛnɛ, Uléécɑɑ uu lɛ̃ nnyɑ u pɑnsɛsɛ ɑsei ute. ");
INSERT INTO soy_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Ápi yɛ kɔ nkó yɛɛ pikɛi n wɑ uu liihɛ́ɛ́ yɔ́su mɑɑ rɛ fɑɑlɑɑ kɑpi u hɛ. Ulikɔ́ yɛ ni kɑpi u pɑ. ");
INSERT INTO soy_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Amɑ́ nkó yɛɛ úu pikɛi píkɑ n wɑ ukɛ́ nɛ m pɑnsɛ ɑsei ute un pɛɛ́ nɛ uyɛɛ yɛ ukópɛkɔɔ́ m pɑnsɛsɛ ɑsei ute kɛfɑ tɛnɛlɛ̃, liute yɛ̀ɛ̀ unfɑtɛnɛ nnyɑ pɑnsɛlɛ ɑsei ute. ");
INSERT INTO soy_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Lɛ̃ kɛ Tɑfiti uu tee rɛ nkó yɛɛ úu pikɛi píkɑ n wɑ, Uléécɑɑ uu pɛɛ́ nɛ u pɑnsɛsɛ ɑsei ute yɛ únɑrɛkomɛ lɛ. ");
INSERT INTO soy_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","Pɛ̃ nnɛ́í kɛ Uléécɑɑ uu ɑkópɛ n sɑ́rɛi uu kɔ ɑkɛcɑ́ɑ́ yɑ́rii yɛ pínɑrɛkomɛ lɛ. ");
INSERT INTO soy_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Usoi nkó ɑkópɛ kɛ Upíimɑ úu n kɛ́ɛ́ni yɛ únɑrɛkomɛ lɛ! ");
INSERT INTO soy_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Pikéké ŋmɑnɛ kɑpi tee rɛ pi pínɑrɛkomɛ lɛ nɛ́ɛ nɛ pikécirɛ́ pɔ̃́ kɔ? Tɔ pimɑ́ɑ mɑsilɛ rɛ kɛfɑ kɛ Apirɑhɑm uú nɛ Uléécɑɑ n tɛnɛ nnyɑ kɛ Uléécɑɑ uu u pɑnsɛsɛ ɑsei ute. ");
INSERT INTO soy_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Íye kuú pɛɛ́ we Uléécɑɑ uú nɛ u kpísi rɛ ɑsei ute? U pɛɛ kélɛ̃ nɛ́ɛ úu kélɛ̃? Ápi pɛɛ kɑhɑnɛ u rinké. Úu pɛɛ kélɛ̃. ");
INSERT INTO soy_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Kɛpirɛ kɑpi u riké ɑi nyísɛ rɛ Uléécɑɑ yɛ unfɑtɛnɛ nnyɑ u pɑnsɛsɛlɛ ɑsei ute ɑpi kɛlenɛ u ké. Apirɑhɑm yɛ lɛ̃ nnyɑ pɑnsɛlɛ pɛpɛɛ Uléécɑɑ nɛ kɛfɑ n tɛnɛlɛ̃ usɑɑ úu kɔ pɛɛ kélɛ̃. Yɑrɛ kɛ Uléécɑɑ uu Apirɑhɑm m pɑnsɛsɛ ɑsei ute úu kɔ pɛɛ kélɛ̃ mɛcɔ kuu kɔ pɛ̃ pɑnsɛsɛ. ");
INSERT INTO soy_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Apirɑhɑm yɛ kɔ pikéké usɑɑ lɛ. Ái pɛɛ pikéké nnɛ́í. Amɑ́ u pɛpɛɛ nfɑtɛnɛ m mɑ́ yɑrɛ kuú m mɑ́ ɑpi kɛlenɛ u ké usɑɑ lɛ. ");
INSERT INTO soy_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Asei kɛcɑ́ɑ́, ɑ́i isé kɛ Apirɑhɑm uu pitíki fe nnyɑ kɛ Uléécɑɑ uu yekei rɛ u nɛ upipirɛ̃ yɛ́ mɑsí kɛtẽ nnɛ́í n te. Amɑ́ kuu nfɑtɛnɛ m mɑ́ Uléécɑɑ uú nɛ u pɑnsɛsɛ ɑsei ute nnyɑ yɛ ni. ");
INSERT INTO soy_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","In tɛ isé kɛ usoi uu yɛ ritiki uú nɛ lɛ̃ kɛ Uléécɑɑ uu n yekei rɛ u yɛ́ wɑ yɛnu, nfɑtɛnɛ ńn pɛɛ líkɑ yoriyɛ, urinɔɔ kuu n yekei yɛ pɛɛ mɛ́woo wɑlɛ. ");
INSERT INTO soy_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Li we rɛ isé yɛ Uléécɑɑ kuwɔi yukusɛlɛ. Isé insɑ́ n we, ɑ́pi yɛ mɑɑ rɛ pi i rilɔ́ɔ́. ");
INSERT INTO soy_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Lɛ̃ nnyɑ, nfɑtɛnɛ mɛɛ yɛ tíyɛsɛ usoi uú nɛ lɛ̃ kɛ Uléécɑɑ uu n yekei rɛ u yɛ́ wɑ yɛnu. Ípɛɛlɛ́ɛ ihɛɛ yɛ nyi. Lɛ̃ nnyɑ, rinɔ́ɔ yekei yekei tɛ̃ pɔ̃́ nɛ kɔ Apirɑhɑm pipirɛ̃ nnɛ́í rikɔ́ lɛ, ɑ́i pɛpɛɛ isé n tíkilɛ̃ ŋmɑnɛ, ɑmɑ́ nɛ pɛpɛɛ urɔ́sɑ́ɑ Apirɑhɑm mɛcɔ nfɑtɛnɛ m mɑ́ yɛ pi. U ntɔ́nɛ́í usɑɑ lɛ. ");
INSERT INTO soy_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Li Nléécɑɑsimɛ́ kɛ́mɛɛ ukɛcɑ́ɑ́ wɔ́lɑɑlɛ̃ tɛ: Nɛ pɔ́ kpísilɛ ɑm wɑisɛ isoipuri kulúi usɑɑ. U ntɔ́nɛ́í usɑɑ lɛ Uléécɑɑ kuú nɛ kɛfɑ n tɛnɛ kɛyu-i. Uléécɑɑ uyɛɛ yɛ pikpɔkpɔ nfɑ́ɑ n hɛ, uu wɑi lɛlɛɛ ɑ́i pɛɛ ń we, ɑí weri. ");
INSERT INTO soy_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","U pɛɛ́ nɛ Uléécɑɑ tɑ́lɛnlɛ un nɛ mɛ̃́ tɛ Uléécɑɑ yɛ́ u wɑisɛ isoipuri kulúi usɑɑ. Li we rɛ Uléécɑɑ yɛ pɛɛ u mɑɑ rɛ: Pipɔ́pírɛ̃ yɛ́ mɑsí kulúi n we. Ái kɔ pɛɛ lɛ̃ kutɑ́ we ukɛ́ nɛ m mɛ̃́. ");
INSERT INTO soy_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Apirɑhɑm nfɑtɛnɛ yɛ pɛɛ́ nɛ welɛ nn pɑ́ɑ́pú, ɑmɑ́ un kɔ nɛ ɑŋmɛ̃ pílɛ kumúŋɛ́ mɑ́. U kɔ pɛɛ nyulɛ rɛ u nɛ nkpɔ nnyɑ́ɑ̃ piwɑi mɑsilɛ, úu yɛ́ nkpéni fe ukɛ́ kɛwɑ̃́ yɛ̃. Unɔ́si Sɑrɑ pɑ́ɑ kɔ nkpéni kuwɑ́nmɑrɛ we. ");
INSERT INTO soy_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Amɑ́ ḿpɑ́ nɛ lɛ̃, úu Uléécɑɑ rinɔɔ kɛsi, ɑmɑ́ u mɛníŋɛ nfɑtɛnɛ píimɑ nɛ Uléécɑɑ ríyu wɑisɛlɛ úu nkpɑ́ni ritiŋɑ-tiŋɑ. ");
INSERT INTO soy_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","U nɛ kɛfɑ tɛnɛlɛ rɛ Uléécɑɑ yɛ ńnɑŋɛ mɑ́lɛ ukɛ́ nɛ lɛ̃ kuu n yekei rɛ u yɛ́ wɑ wɑ. ");
INSERT INTO soy_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Lɛ̃ nnyɑ kɛ Uléécɑɑ pɔ́ɔ kɔ u pɑnsɛsɛ ɑsei ute. ");
INSERT INTO soy_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Tinɔ́ɔ ntí kɑpi nní ń wɔ́i rɛ: Uléécɑɑ yɛ u pɑnsɛsɛ ɑsei ute, ɑ́i uyɛ̃ ŋmɑnɛ nnyɑ kɑpi wɔ́i rɛ Uléécɑɑ yɛ u pɑnsɛsɛ ɑsei ute. ");
INSERT INTO soy_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Tɔ́ mpí kuu nní ḿ pɑnsɛsɛ ɑsei pite, tɔ̃́ nnyɑ kɑpi kɔ lɛ̃ wɔi rɛ tɔ Uléécɑɑ uyɛɛ Urɔ́píimɑ Yeesu pikpɔkpɔ kɛ́mɛɛ n yukusɛ nɛ kɛfɑ tɛnɛ nnyɑ. ");
INSERT INTO soy_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Arɔ́kópɛ nnyɑ kuu tíyɛ ɑpi u kopu, Uléécɑɑ uu u yukusɛ rɛ ukɛ́ rɔ́ pɑnsɛsɛ ɑsei pite. ");
INSERT INTO soy_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Ntɔ́fɑtɛnɛ nnyɑ kɛ Uléécɑɑ uu rɔ́ pɑnsɛsɛ ɑsei pite. Nkíŋniŋɛ yɛ nkpéni tɔ́ nɛ uyɛ̃ kɛcɔpɛ welɛ. Urɔ́píimɑ Yeesu Kirisi yɛɛ tíyɛsɛ kɑi lɛ̃ wɑ. ");
INSERT INTO soy_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Uyɛɛ tíyɛsɛ kɛ Uléécɑɑ uu nfɑtɛnɛ nnyɑ uipɛɛlɛ́ɛ ncee rɔ́ hɛ ɑri fe ɑrí nɛ pɛ́nɛ ńsɔnɛ. Li nkpéni tɔ́ lɑ́ɑ́rúlɛ rɛ tɔ́ kɑm ɑri umɛyɔɔpi kɛ́mɛɛ kɛtónɛ yɛnu. ");
INSERT INTO soy_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Hɑ́i nɛ nkpéni ricuruu kɑri nní íwɛ n le, li rɔ́ lɑ́ɑ́rúlɛ ɑ́i kumúŋɛ́ mɑ́. Tɔ nyulɛ rɛ íwɛ kɛ́mɛɛ kɛ usoi uu yɛ piŋmɔ́ɔ́pú peikɛɛ, ");
INSERT INTO soy_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","uu piŋmɔ́ɔ́pú kɛ́mɛɛ Uléécɑɑ pitíki ceru nɛ ɑsei, uu ɑsei pitiki kɛ́mɛɛ fe uu yɛ Uléécɑɑ nɛ n tɑ́lɛ̃ un mɛ̃́. ");
INSERT INTO soy_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Uléécɑɑ pitɑ́ ɑ́pi yɛ́ rɔ́ kírɑɑsɛ. Nfɑ́ɑsɔnɛ mmɛ̃ kuu rɔ́ n hɛ kuú nɛ unlɑ ɑrɔ́kíŋ kɛ́mɛɛ wɑ. ");
INSERT INTO soy_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Kɑ́ri pɛɛ ńnɑŋɛ m mɑ́ tɔkɛ́ nɛ ɑkópɛ kɛ́mɛɛ le kɛ Kirisi uu pikópɛkɔɔ́ nkpɔ yɔsí uu kpi. Uléécɑɑ yɛɛ liituŋɛ iyɛ̃ yekei. ");
INSERT INTO soy_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Li pɛɛ pɑ́ɑ́púlɛ pikɛ́ nɛ usoi sɔnɛ ricuruu nkpɔ ń yɔsí. In n lɑ, unyinɛ yɛ́ pɛɛ fe uu ikɑri wɑi uu usoi sɔnɛ unyinɛ nkpɔ yɔ́su uu kpi. ");
INSERT INTO soy_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Amɑ́ lɛ̃ kɛ́mɛɛ kɛ Uléécɑɑ uu rɔ́ n nyísɛ rɛ u rɔ́ lɑlɛ yɛ nní: Kɑrí pɛɛ ɑrɔ́kópɛ kɛ́mɛɛ ń we kɛ Kirisi uu ntɔ́kpɔ yɔsí uu kpi. ");
INSERT INTO soy_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Kɛ Uléécɑɑ uu nkpéni nní Kirisi inyɔ́ɔnsɛ mɛnyɛ nnyɑ rɔ́ m pɑnsɛsɛ ɑsei pite, ɑ́i céreisɛ rɛ Kirisi yɛ́ kɔ Uléécɑɑ kuwɔi kɛ́mɛɛ rɔ́ lesɛ. ");
INSERT INTO soy_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Pɛɛ́ uyɛ-i kɑrí pɛɛ Uléécɑɑ pilɑɑrɔ kɛ Uléécɑɑ uu Ukɛpipi nkpɔ nɛ ilɑ́ɑrɔ iyɛ̃ kpu. Kuu nkpéni nní ilɑ́ɑrɔ iyɛ̃ pikópɛ ḿ mɑsí, ɑ́i céreisɛ rɛ u yɛ́ kɔ Ukɛpipi nfɑɑ nɛ tirɔ́yu lɔ. ");
INSERT INTO soy_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Lɛ̃ mɛmɑ́ɑ́, li kɔ nkpéni rɔ́ lɑ́ɑ́rúlɛ lin kɔ rikɔ́kɔri rɔ́ we rɛ tɔ́ nɛ Uléécɑɑ yɛ l