﻿USE sofia;
DROP TABLE IF EXISTS sofia.sor_vpl;
CREATE TABLE sor_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES sor_vpl WRITE;
INSERT INTO sor_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","4","Dwaynandɨ, Jakob gɨ sumɨw gɨ mɨn i Israyel dɨndaw nə ha gɨ abɨragɨ mɨn mana gɨ sɨn̰a dɨ Ejibtɨ me i ta: Ruben me Simiyõ me Lebi me Juda me Isakar me Jabilon me Benjami me Dan me Neptali me Gad me Aser me. Nare nə ta di, wi kaw wol nare duwa nə kɨrə daa hargɨ mɨn. ");
INSERT INTO sor_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Jakob dɨndaw me mwàgɨraw me pad da, nem nare gɨnɨn̰ wurgɨsubu. Me Jakob gorndɨw gɨ  Josep da, ilə alə sɨn̰a dɨ Ejibtɨ lə pii ɗɨm. ");
INSERT INTO sor_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Ɨr̰ɨ Josep me chamraw nə pad di me margɨ bam. Nare nə ta di mar ꞌyen̰ bam pad swaa dayyə. ");
INSERT INTO sor_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Me nare nə Israyel di yə̀ dine ꞌyarbar nan̰ me gɨr̰ɨ ha gɨ dɨrəgɨ pii pii, me i nare nə àl dwana nan̰e me ca. Cendi ꞌyarbar ꞌwonbɨ sɨn̰a dɨ Ejibtɨ di dɨdɨ daa. ");
INSERT INTO sor_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Caga da, i dole gɨ geche gɨ dɨrway me yala dam lam dwãr̰ĩ sɨn̰a dɨ Ejibtɨ lə an̰ju. Dole gɨ ta di ꞌwocn̰ Josep di bədə. ");
INSERT INTO sor_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","An̰ji waygɨ nare duwa ba da: «Yarna, nare nə Israyel di yala ꞌyarbar nan̰e me àl dwana nan̰ ɗoyndɨ bam me ca. ");
INSERT INTO sor_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Kal də kan̰jang kojɨgə mɨn dɨ idɨ ɨməgɨ gɨr̰ə day gaba hára pii pii di bam. Də àlnang yande bədə da, ɗan̰ wála gɨ say dara ɨndara da, cendi ha bwara woni mar̰ande ɨnda gɨndəgɨ lə jara ganandɨ me ha ɓɨr̰ɨn̰ə hára kala sɨn̰a ɨnda di bam.» ");
INSERT INTO sor_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Mwom da, nare nə Ejibtɨ di piy gechide woni yɨbə nare nə Israyel gɨ dwana dara ba àlna giyə gɨ wome gaba biyə dwana day bam. I yande me, nare nə Israyel awɨw nɨm gɨ dole gɨ Ejibtɨ di ciri dɨ gechide dɨ idɨ gama mani. Ciri dɨ ta di, gɨ ꞌwogɨdɨ Pitom me Ramses me. ");
INSERT INTO sor_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Me mana gɨ gɨ gɨlgɨ gɨ nare nə Israyel dɨrəgɨ nan̰ yande kaw, cendi ꞌyarbar sɨn̰a dɨ Ejibtɨ lə ha gɨ dɨrəgɨ pii pii u sɨn̰a day di dɨdɨ bam pad. I dara ta di me nare nə Ejibtɨ di ɨlgɨ nɨm. ");
INSERT INTO sor_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Mwom da, cendi àl nare nə Israyel di kwaynani nan̰ ɗoy bam bi. ");
INSERT INTO sor_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Cendi gɨlgɨ dɨrəgɨ gɨ giyə gɨ wome nan̰ gaba bwariya jirbe me, piyə gɨ dirɨngəl me, giyə gɨ bam yiga lə gɨ dɨrəw jiga jiga pad me ca. Wamani gɨ ta di pad da, i dara àlagɨ̀ nɨm gɨ kwaynani. ");
INSERT INTO sor_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Namde woni yàa kwandagɨ nənə nare nə Ebɨrə day sɨr ilə. Namde nə ta di, dɨ mɨn gɨ ꞌwogɨdɨ Chipɨra me, dɨ mɨn ɗang gɨ ꞌwogɨdɨ Puwa me. Wála mɨn, dole gɨ Ejibtɨ di u bɨw waygɨ ba da: ");
INSERT INTO sor_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","«Mana gɨ anə dara yàa nare nə Ebɨrə namdagɨ da, yarna dwe di le. Dwe di ina i abe da, ꞌyánaw bam, me ina i deme da, kalnadɨ dɨ bɨlnə le.» ");
INSERT INTO sor_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Me namde woni yàa kwandagɨ di lán̰ɨw Mãr̰ĩ le, cendi àl mani nə dole waygɨ di bədə, ꞌyə dine nə abje di bədə, kalgɨ pad bɨl. ");
INSERT INTO sor_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Ɨr̰ɨ dole di ꞌwaga namde woni yàa kwandagɨ di sɨwə me ùrgɨ ba da: «Dana me anə àl yande mo? Dana me anə kal dine nə abje di bɨl mo?» ");
INSERT INTO sor_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Namde woni yàa kwandagɨ di cow lə diiyə ba da: «Nare nə Ebɨrə namdagɨ da, i ya namde nənə nare nə Ejibtɨ day de bədə, cendi àl dwana nan̰e. Mana gɨ deme dɨ idɨ yàa kondɨdɨ ba dɨ hára dara yàdɨ le sɨn̰ da, tandi yə̀ bam pii dɨrədɨ lə ɗɨm.» ");
INSERT INTO sor_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Mwom da, Mãr̰ĩ àl ladni gɨ namde woni yàa kwandagɨ di, me cor nare nə Israyel di ꞌyarbar ha gɨ dɨrəgɨ pii pii me, àl dwana nan̰ me ca. ");
INSERT INTO sor_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Me mana gɨ Mãr̰ĩ yər dara namde woni yàa kwandagɨ di ba lán̰ɨw an̰ju gɨ Mãr̰ĩ di le mwom da, an̰ji ꞌyàgɨ́ dine di ꞌyarbar nan̰. ");
INSERT INTO sor_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Me dole di u bɨw waygɨ nare duwa pad ba da: «Dine nə man̰ nə abje nə nare nə Ebɨrə ha yàgɨ pad da, bwanagɨ kurayyə, me nə namde pad da, kalnagɨ gɨ bɨlnə.» ");
INSERT INTO sor_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Abe mɨn gɨ gɨndɨw i gangle gɨnə Lebiyə me u deme dɨ gɨndɨdɨ i gangle gɨ ta lə di me ca. ");
INSERT INTO sor_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Deme dɨ ta di u gudi me yə̀ dwe gɨ abe. Mana gɨ tandi yər dwe di ladɨ nan̰e mwom da, tandi budɨw àl duru subu. ");
INSERT INTO sor_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Me tandi nem budəw bɨraa bɨraa bədə. Ɨr̰ɨ tandi ha ꞌwoo kɨrangè gɨ gɨ awɨw gɨ dɨrwa me, tandi ɗagdɨw dur̰u lə tarɨwə dara ɨməgɨ gɨ nimi n̰irɨngə hára lə dalawə bam me, ál dwe di lə dwalɨn̰yə. Mwom da, tandi u kɨrangè di ha chə́w mana gɨ dɨrwa dalawə sura, kuray gɨ Nil bɨwə. ");
INSERT INTO sor_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Dwe gɨ man̰ di chidɨw ɗɨbɨ bam hin̰e dara yara i na gaa ba ha àlala mo? ");
INSERT INTO sor_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Ɓam mwom da, dole gɨ Ejibtɨ durməw ha gɨr ha chə́ə kurayyə dara ba dɨ wiy sɨdɨ bam. Me woni àladɨ́ giyə da, kɨdɨbər day kuray bɨwə cab cab. Mana gɨ dole durməw di ba dɨ yər kɨrangè di mana gɨ dɨrwa dalawə mwom da, tandi giy idɨ àladɨ́ giyə dɨ mɨn ba hana unə kɨrangè di. ");
INSERT INTO sor_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Mana gɨ ba dɨ tɨn̰ kɨrangè di bɨw bam mwom da, tandi yər dwe gɨ man̰ gɨ abe ilə nulə gura lə. Ɨr̰ɨ dɨrədɨ ꞌyəngɨdɨ dwe di dɨwə me way ba da: «Ta di i nare nə Ebɨrə dwe day.» ");
INSERT INTO sor_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Mwom da, dwe di chidɨw waydɨ dole durməw di ba da: «Də ùr ba nə hana kan̰jɨnay deme dɨ Ebɨrə ba hane ꞌyànaw dwe di nãy ɨsɨnəy gandɨw mo?» ");
INSERT INTO sor_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Dole durməw di codɨ lə diiyə ba da: «Ha, kan̰jan!» Me dwe di chidɨw ha gɨr ha ꞌwaga dwe di iw duwa gang. ");
INSERT INTO sor_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Dole durməw waydɨ deme di ba da: «U dwe di ha gandɨw, də ha ꞌyàw nãy, ɨsɨn gandɨw, me nə ha ꞌywagay gwayni diya.» Me deme di u dwe di ha gandɨw gɨr ha ꞌyàw nãy ɨsɨw nɨm. ");
INSERT INTO sor_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Mana gɨ dwe di dɨrəw naa mwom da, tandi uw ha gandɨw ꞌyàdɨ dole durməw. Dole durməw di u dwe di cow gɨdɨw ya gorndɨdɨ gɨ yàa de. Tandi ꞌwogɨ́w sumɨw «Moyis», sumi gɨ ta di wun i ya «ꞌwoo gɨ mani» de. Tandi ꞌwogɨw yande dara tandi way ba dɨ ꞌwów i nimiyə. ");
INSERT INTO sor_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Mana gɨ Moyis gɨdɨ geche mwom da, wála mɨn, an̰ji so ha dara ba a ha yara war̰aw nə Ebɨrə. Gɨr alə ta da, an̰ji yər gɨ ilə gɨləgɨ war̰aw nə Ebɨrə di dɨrəgɨ lə gɨ giyə gɨ wome. An̰ji yər gun gɨ Ejibtɨ ilə gwaba wiləw gɨ Ebɨrə lə. ");
INSERT INTO sor_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Mana gɨ Moyis ꞌwun̰ tulɨw ka me ka me yər gun mɨn kaw ilə bədə mwom da, an̰ji gobɨ gun gɨ Ejibtɨ di ꞌyəw bam me, muw budɨw dodə gawsɨni dalawə. ");
INSERT INTO sor_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Sanga dɨra da, an̰ji dɨmə iche me yər war̰aw nə Ebɨrə sɨr ilə jara lə. Me an̰ji wayɨw gɨ gwale duwa ha lə bədə di ba da: «Dana me mə gobɨ chendɨm di yande mo?» ");
INSERT INTO sor_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","An̰ji cow Moyis lə diiyə ba da: «I wi me ꞌyàm gasɨnani me chɨ́m aba àlanin sariya me mo? Labaa, mə ùr ba mə ꞌyənne ya tanga ba mə ꞌyáa gɨ gun gɨ Ejibtɨ di de me ca mo?» Mwom da, Moyis lán̰a àlɨw me ɨrɨm dusɨwə ba da: «I sɨdɨ, gwale gɨ ta di, nare ꞌwocn̰ɨwe.» ");
INSERT INTO sor_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","18","Mana gɨ dole gɨ Ejibtɨ di doy gwale gɨ ta di mwom da, an̰ji ùr ba ꞌyə Moyis di bam. Me Moyis di wà dara bɨlə sɨw mana gɨ dole di ɨsəwə. An̰ji ha dama budə sɨw mana gɨ sɨn̰a dɨ Madiyannə. Sɨn̰a dɨ Madiyannə di, aba bwasa Mãr̰ĩ mɨn ilə, gɨ ꞌwogɨw Rewel. Dɨndaw nə namde ilə wurgɨsubu. Wála mɨn, Moyis ha dama bɨla bɨwə. Rewel dɨndaw di háragɨ dara wada nimi bwaa pɨrda lə ꞌyàgɨ́ gɨ bage nənə abɨragɨ duwa ba chàna. Ɨr̰ɨ woni gama bage nə ɗang hára ꞌyorgɨ bam, mwom da, Moyis so wagɨ aba bwasa Mãr̰ĩ dɨndaw di lə, me ꞌyàgɨ́ bage day di nimi cendi chə̀. Mana gɨ dɨndaw cwara hára ꞌyow ulay mwom da, abɨragɨ di ùrgɨ ba da: «I man me laba da, anə cwara hára ulay kaláng yande mo?» ");
INSERT INTO sor_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Me cendi cow lə diiyə ba da: «Abe mɨn, i gun gɨ sɨn̰a dɨ Ejibtɨ lə, me kɨdənin daa woni gama bage ɨsɨragɨ lə, me wada nimi di nan̰ ꞌyàgɨ́ bage ɨnda di chàa an̰ju me ca.» ");
INSERT INTO sor_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Abɨragɨ di ùrgɨ ba da: «Abe di ilə we mo? Dana me anə kalaw wara alə ta mo? Cwarna hana walnaw, kalɨw a hane damna wamna mani ganandɨ.» ");
INSERT INTO sor_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Moyis yɨ gwale duwa di me dam gandɨw. Mwom da, Rewel di ꞌyàw durməw dɨ gɨ ꞌwogɨdɨ Sepora me, an̰ji udɨ deme. ");
INSERT INTO sor_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Me tandi yə̀w dwe gɨ abe me, Moyis ꞌwogɨw sumɨw Gerchom, gɨndɨw dɨ biyə da, i «mɨje». An̰ji ꞌwogɨw yande dara an̰ji way ba i mɨje gɨ ba yala dam i sɨn̰a dɨ nare dayyə. ");
INSERT INTO sor_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Targɨn̰ ɗang, àl wála nan̰ da, dole gɨ Ejibtɨ di mar bam me, nare nə Israyel di ilə gɨlə dɨrɨn̰yə nan̰e me ilə bwaa gura me ca, dara kwaynani day di yala ɗoy dɨdəgɨ le. Me ꞌwaga gɨ cendi ꞌwogɨ Mãr̰ĩ di, mar̰ɨjagɨ so bɨraa yá ɨndara Mãr̰ĩ sumɨwə daa. ");
INSERT INTO sor_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Mãr̰ĩ doy nulə gɨ cendi nul sɨdəgɨ ꞌwogɨw nɨm di mwom da, ɨr̰ɨ dusɨw guw daa mana gɨ mɨlan dɨ an̰ji tanga yɨ gɨ Abɨraham me Isak me Jakob me di dɨdə. ");
INSERT INTO sor_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Mãr̰ĩ yər nare nə Israyel di bɨraa me ꞌwocn̰ wamani day di me ca. ");
INSERT INTO sor_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Moyis gɨdɨ aba gama bage nənə dyaməw abadɨ gɨ Jetɨro duwa. Jetɨro i aba bwasa Mãr̰ĩ mana gɨ sɨn̰a dɨ Madiyannə. Wála mɨn, Moyis ha gama bage mana gɨ dɨn tuldɨ dɨ alə ta lə kur̰a dɨnə Mãr̰ĩ duwa sɨdə ib. Kur̰a dɨ ta di, gɨ ꞌwogɨdɨ Horeb. ");
INSERT INTO sor_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Mana gɨ ta lə da, paja gɨnə Aba dama gɨ dɨrəw bɨr̰ɨn̰ duwa dɨmə gɨra gɨlɨw sɨw mana gɨ dùwa dɨ ꞌyo bilɨm bilɨm dwar̰ɨ lə. Me mani nə Moyis yərgɨ da, an̰ji yər i dùwa dɨ ꞌyo mana gɨ habda gɨ ɗwag ɗwag dalawə me ul habda gɨ ta di bədə. ");
INSERT INTO sor_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Yande da, Moyis ɨrɨm dusɨwə ba da: «Nə kwongɨ ha yara mani nə ɗan̰a nə i ta di. Dùwa di ilə ꞌywaa lə me, ul habda gɨ ɗwag ɗwag di bədə, dana mo?» ");
INSERT INTO sor_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Aba dama gɨ dɨrəw bɨr̰ɨn̰ yər dara Moyis ilə kwanga lə dara hára yara mani nə ta di mwom da, an̰ji ꞌwogɨw mana gɨ habda gɨ ɗwag ɗwag di dalawə ba da: «Moyis! Moyis!» Me Moyis doyɨw lə diiyə ba da: «Wóy!» ");
INSERT INTO sor_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","An̰ji wayɨw Moyis da: «Hare mana gɨ ka lə di ib bədə, n̰ir̰ɨbɨ gɨbande bam gɨdammə, dara mana gɨ mə ɗɨbɨ lə ka di, i mana ni gɨ nə biyɨw kalɨw jiga. ");
INSERT INTO sor_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Ɨndi di, nə i Mãr̰ĩ gɨnə abam duwa. Nə i Mãr̰ĩ gɨnə Abɨraham duwa me, gɨnə Isak duwa me, gɨnə Jakob duwa me ca.» Me Moyis di budɨ dɨrəw le, dara lán̰a àlɨwe, an̰ji nem ꞌwoo dɨrəw daa yara gɨ Mãr̰ĩ bədə. ");
INSERT INTO sor_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayaw Moyis ɗang bi ba da: «Nə yər nare ni nə Israyel gɨlə day gɨ dɨrɨn̰ mana gɨ sɨn̰a dɨ Ejibtɨ lə me, nə doy gura day gɨ cendi bo dara gwaba gɨ nare nə Ejibtɨ gobɨgɨ di me ca. Wamani day di, nə ꞌwocn̰ com. ");
INSERT INTO sor_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","I ta di me nə chə́ə yala nɨm dara kɨdəgɨ nɨm daa nare nə Ejibtɨ ɨsɨragɨ lə me, ba nə wolgɨ ha gandagɨ sɨn̰a dɨ lade dɨ ɓɨleyə. I sɨn̰a dɨ nãy me dùmbu me chow lə nan̰e. Sɨn̰a dɨ ta di, i dɨnə nare nə Kanan day me, Hiti day me, Amori day me, Perisi day me, Hibi day me, Yebus day me ca. ");
INSERT INTO sor_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","I sɨdɨ, gura gɨnə nare nə Israyel day di nɨm yá ɨndara sumɨnnə daa. Me gɨlə day gɨ dɨrɨn̰ gɨ nare nə Ejibtɨ gɨlgɨ gandɨw di kaw, nə yər gɨ dɨrən me ca. ");
INSERT INTO sor_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Caga ka, so daa, ha, nə giyɨm dole gɨ Ejibtɨ sɨwə dara ba mə walna nare ni nə Israyel gandɨna gandagɨ bam sɨn̰a dɨ Ejibtɨ lə.» ");
INSERT INTO sor_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Me Moyis di wayɨw Mãr̰ĩ ba da: «Ɨndi da, nə i wi me nə ha hára ꞌywaa dole gɨ Ejibtɨ dara wàla gɨ nare nə Israyel ganda gandagɨ bam sɨn̰a dɨ Ejibtɨ lə di mo?» ");
INSERT INTO sor_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Ɨr̰ɨ Mãr̰ĩ wayɨw ba da: «Nə ha ꞌya lə gandɨm. Me mani nə ha àlala me mə ha ꞌwacn̰a nɨm dara ba nə giyəm ɨndi di me i ta: Dawa dɨ mə dara wàla nare nə Israyel ganda gandagɨ bam sɨn̰a dɨ Ejibtɨ lə da, anə ha mɨlawdan mana gɨ kur̰a dɨ i ka di dɨdə.» ");
INSERT INTO sor_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Moyis wayɨw Mãr̰ĩ ba da: «Ladɨ. Nə ha hára ꞌywaa nare nə Israyel wayagɨ da: “I Mãr̰ĩ gɨnə mwágɨrang day me giyən sɨdəngə di an̰ju.” Me cendi ùrnən ba da: “Mãr̰ĩ gaba giyəm di sumɨw i man mo?” da, nə ha cwagɨ lə diiyə man mo?» ");
INSERT INTO sor_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Mwom da, Mãr̰ĩ wayɨw Moyis ba da: «Nə i gun gɨ nə ilə. Doy, gwale gɨ mə ha wayagɨ nare nə Israyel di, i ta: “An̰ji gɨ ꞌwogɨ sumɨwNə ilə me giyən sɨdəngə an̰ju.” ");
INSERT INTO sor_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Ɗang da, mə ha wayagɨ da: “I Mãr̰ĩ gɨnə mwágɨrang day, Mãr̰ĩ gɨnə Abɨraham duwa me, gɨnə Isak duwa me, gɨnə Jakob duwa me giyən sɨdəngə an̰ju. Sumɨw i Aba dama gɨ dɨrəw bɨr̰ɨn̰.” Ta di me i sumɨn di gɨ dɨrɨn̰ bɨr̰ɨn̰. Nare gɨ swaa day swaa day ha ꞌwagan gɨ sumi gɨ ta di gɨ dɨrɨn̰ bɨr̰ɨn̰. ");
INSERT INTO sor_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Caga da, so daa! Mə ha dáya nare nə Israyel nə dɨrəgɨ nagdɨ dodə me, mə waygɨ da: “I Aba dama gɨ dɨrəw bɨr̰ɨn̰ di me gɨlən sɨw. I Mãr̰ĩ gɨnə mwágɨrang day, Mãr̰ĩ gɨnə Abɨraham duwa me, gɨnə Isak duwa me, gɨnə Jakob duwa me ca. An̰ji way ba a u bɨw ba a ha wangə dara mani nə nare nə Ejibtɨ ilə àlang gandagɨ lə mana gɨ sɨn̰a dayyə di. ");
INSERT INTO sor_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","An̰ji way ba a ha walang ganda gandang bam sɨn̰a dɨ Ejibtɨ dɨ gɨ gɨləng dɨrəng lə di, me ba a ha hára gandang mana gɨ sɨn̰a dɨ i nare nə Kanan day me, Hiti day me, Amori day me, Perisi day me, Hibi day me, Yebus day me ca. I sɨn̰a dɨ nãy me dùmbu me chow lə nan̰e.” ");
INSERT INTO sor_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Mwom da, nare nə Israyel nə dɨrəgɨ nagdɨ di ha yəə gwale dɨma di le me, anə ha hára mɨn ꞌywaa dole gɨ Ejibtɨ di me anə ha wayaw ba da: “Aba dama gɨ dɨrəw bɨr̰ɨn̰ gɨ i Mãr̰ĩ gɨnə nare nə Ebɨrə day hára gɨra ꞌyonin. Me caga da, nə háranin ùrɨm dara ba mə kalnanin bɨrmə, nə àlnin wála subu bɨrmə lə dara hára dɨn dwar̰ɨ lə. Nə ùrnin ba nə hanin bwasa Aba dama gɨ dɨrəw bɨr̰ɨn̰ gɨ i Mãr̰ĩ nin di.” ");
INSERT INTO sor_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Me nə ꞌwocn̰ com, dole gɨ Ejibtɨ di ha ɨməng hára di i bam. Dwana dɨ geche dara ɗwaya dɨw le bá do me an̰ji ha kalang anə ha hára sɨn̰. ");
INSERT INTO sor_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Yande da, nə ha yáa ɨsən mana gɨ sɨn̰a dɨ Ejibtɨ lə àla mani nə àl lán̰a nan̰ nə dɨrəgɨ jiga jiga lə mwom da, an̰ji ha kalang anə ha hára sɨn̰. ");
INSERT INTO sor_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Nə ha àla kal nare nə Ejibtɨ àlna gandang dusi dɨ lade dara daran ɨndi, me mana gɨ anə ha swaa daa dara hára da, anə ha hára i ɨsɨrang pəgɨn̰ bədə. ");
INSERT INTO sor_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Deme dɨ we we kaw ha ùrə idɨ ciri dɨra bɨdɨ me, idɨ dama gandɨdɨ kɨrə mɨn me mani day nə gɨ ɗangr̰ɨgɨ gɨ tuda me gɨ jindar me, barge day me ca. Mani nə ta di, anə ha ꞌyàgɨ́ dɨndɨrang nə abje me nə namde me, kalgɨ gɨ hurbɨna sɨdəgɨ lə. Ta di da, anə ha laya i mani nə ꞌywaa nənə nare nə Ejibtɨ day hára nɨm ɨsɨrangə.» ");
INSERT INTO sor_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Ɨr̰ɨ Moyis cow Mãr̰ĩ lə diiyə ba da: «Ladɨ, me gaa nare nə Israyel ha ùrə ba gɨ doy gwale ni bədə me, yɨw bədə me som. Gaa cendi ha wayan ba da: “Aba dama gɨ dɨrəw bɨr̰ɨn̰ di gɨləm sɨw alə we mo?”» ");
INSERT INTO sor_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Me Aba dama gɨ dɨrəw bɨr̰ɨn̰ di ùrɨw ba da: «I na ilə ɨsəmmə ta di mo?» An̰ji wayɨw da: «I cilang.» ");
INSERT INTO sor_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","An̰ji wayɨw da: «Ál cilang di dodə sɨn̰a lə.» Mwom da, Moyis ál cilang di dodə sɨn̰a lə me, cilang di gɨdɨ kwalà, mwom da, Moyis gur wà daa. ");
INSERT INTO sor_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw ba da: «Yə́ ɨsəm yɨ kwalà di widɨw.» Moyis yə́ ɨsəw yɨ kwalà di me, kwalà di cor gɨdɨ cilang ɨsəwə bi. ");
INSERT INTO sor_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: «Mani nə ta di, mə ha àlagɨ̀ i dara gɨləgɨ gɨ nare nə Israyel di ba yɨnə gɨ gwale dɨma gɨ ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ di ba nə gɨləm sɨn ꞌyang, ɨndi gɨ nə i Mãr̰ĩ gɨnə mwágɨragɨ day, gɨnə Abɨraham duwa me, gɨnə Isak duwa me, gɨnə Jakob duwa me ca.» ");
INSERT INTO sor_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Ɗang da, Aba dama gɨ dɨrəw bɨr̰ɨn̰ di wayɨw Moyis bi ba da: «Hurə ɨsəm barge dalawə korgɨn̰ jorgɨmə.» Me Moyis hurə ɨsəw barge dalawə korgɨn̰ jorgɨwə di me biyə ɨsəw di bam bi da, ɨsəw di sabar cagɨm bam pad, me wusɨ kəng ya duru de me ca. ");
INSERT INTO sor_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Mãr̰ĩ wayɨw Moyis ɗang bi ba da: «Hurə ɨsəm barge dalawə korgɨn̰ jorgɨmə bi.» Me Moyis hurə ɨsəw barge dalawə korgɨn̰ jorgɨwə di bi, me mana gɨ ba a biyə ɨsəw di bam bi da, ɨsəw di cor ladɨ ya gɨ pii de bi. ");
INSERT INTO sor_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: «Nare nə Israyel di kalna dusɨrəgɨ gwale dɨma dɨwə dara mani nə dan̰a nə mə ha àlagɨ̀ dɨrɨn̰ nə piiyə di bədə kaw, cendi ha dwaya gwale dɨma di me ha yə̀w dara mani nə dan̰a nə mə ha àlagɨ̀ nə dii sɨrrə di. ");
INSERT INTO sor_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Me cendi kalna dusɨrəgɨ mani nə dan̰a nə sɨr nə ta di dɨdəgɨ lə bədə me, dwayna gwale dɨma bədə me da, udɨ nimi nə kuray gɨ Nil lə me, mə dol nimi di dodə sɨn̰a lə, mwom da, nimi nə ta di ha cwara gɨdə bare.» ");
INSERT INTO sor_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Me Moyis wayɨw Aba dama gɨ dɨrəw bɨr̰ɨn̰ di ba da: «Ay, aba ciri ni, kalɨn yag! Ɨndi da, waya gɨ gwale womɨn nan̰e. Waya gɨ gwale waman duwa gɨ ta di, i wála gɨ tanga lə mɨra bədə me, gɨ tanga dɨ ta lə mɨra bədə me, i wála gɨ mə diy gɨ gɨnɨn̰ wayan gwale lə di mɨra bədə me ca. Bɨn me dilesɨn me nu le gɨ waya gɨ gwale.» ");
INSERT INTO sor_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: «I wi me ɗangr̰ɨw gun gɨ gɨsage bɨw di mo? I wi me i aba gɨdə gun mɨm labaa aba ɗugɨrə gun di mo? I wi me àl gun yər mana labaa gɨdɨw gɨ boy mo? Mani nə ta di, nə àlgɨ ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ di gaa bədə mo? ");
INSERT INTO sor_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Caga da, so ha! Nə ha ꞌya lə gandɨm waya dɨma gɨ gwaleyə me, nə ha gɨləm mani nə mə ha wayagɨ di ɨndi.» ");
INSERT INTO sor_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Ɨr̰ɨ Moyis cow wayɨw Aba dama gɨ dɨrəw bɨr̰ɨn̰ di ba da: «Ay, aba ciri ni, kalɨn yag! Kal mə giy gun gɨ ɗang gɨ dɨrəm ùrɨw an̰ju.» ");
INSERT INTO sor_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Mana gɨ ta lə da, Aba dama gɨ dɨrəw bɨr̰ɨn̰ di dusɨw so nan̰e Moyis dɨwə me wayɨw ba da: «Ɓag chendɨm gɨ Arõ gɨ i gun gɨ Lebi ilə gaa bədə mo? An̰ji da, nə ꞌwocn̰ dara bɨw hɨbal le gɨ waya gɨ gwale. Yər, caga ka kaw, an̰ji swaa yala lə bɨrmə lə dara hára ꞌywam. Me mana gɨ an̰ji hane me, unə dɨrəw daa yarnam da, sɨw ha ꞌywalaw nan̰e. ");
INSERT INTO sor_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Mwom da, mə ha kɨbəw gwale di me, mə ha kalaw gwale di ɨsəwə. Me ɨndi da, nə ha ꞌya lə gandang waya dɨma gɨ gwaleyə me waya duwa gɨ gwaleyə me, nə ha gɨləng mani nə anə ha àlagɨ̀ di ɨndi me ca. ");
INSERT INTO sor_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","An̰ji ha wayagɨ nare gwale mana dɨma lə. An̰ji ha gɨdə aba cɨmə bɨm, me ɨjɨm da, mə ha ꞌya i ya Mãr̰ĩ ba a wayɨw gɨ aba cɨməw bɨw gwale ta de me ca. ");
INSERT INTO sor_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Me cilang gɨ ta di da, uw ɨsəmmə. I gɨ cilang gɨ ta di me mə ha àla nɨm gɨ mani nə dan̰a di.» ");
INSERT INTO sor_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Mwom da, Moyis cwara hára ꞌyo dyaməw abadɨ gɨ Jetɨro me wayɨw da: «Kalɨn bɨrmə ɗe! Nə ùr ba nə cor ha i sɨn̰a dɨ Ejibtɨ lə bi dara yara gɨ war̰an nə Israyel, gaa cendi dam ilə bɨ̀ra mɨ̀ndagɨ mo?» Me Jetɨro wayɨw da: «Ha labiya!» ");
INSERT INTO sor_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Dara mana gɨ Moyis wara nɨm sɨn̰a dɨ Madiyannə sɨn̰ da, Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw ba da: «So, mə cor ha mana gɨ sɨn̰a dɨ Ejibtɨ lə bi, dara nare nə tanga ùr ba gɨ ꞌyəm di, margɨ bam pad ɗɨm.» ");
INSERT INTO sor_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Mwom da, Moyis wol dyaməw me, dɨndaw me daa me laygɨ chɨ́gdɨgɨ kura dɨdə me, corgɨ hargɨ dara hára sɨn̰a dɨ Ejibtɨ lə. An̰ji u cilang gɨnə Mãr̰ĩ duwa di ha nɨm ɨsəwə. ");
INSERT INTO sor_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Mana gɨ Moyis ɨndər bɨrmə lə dara hára da,  Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw ba da: «Yər, mani pad nə dan̰a nə nə ꞌyàm dwana dɨ idɨ àlagɨ̀ ɨsəmmə ta di, mə gɨrnə dole gɨ Ejibtɨ dɨrəwə da, àlgɨ le. Me ɨndi da, nə ha àla dole di kal dɨw wayna le, a ɨmnəgɨ nare nə Israyel di ganda gaba hára bam sɨn̰a dɨ Ejibtɨ lə. ");
INSERT INTO sor_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Mə ha wayaw dole di ba da: “Doy gwale gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw di me i ta: Nare nə Israyel di, i ya gorndɨn de, i gorndɨn gɨ man̰jɨli. ");
INSERT INTO sor_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Nə wayɨm: Kal gorndɨn gɨ man̰jɨli a hana dara mɨlawdan. Me mə ɨmnəw hára bam da, nə ha ꞌyáa dɨma gɨ man̰jɨli bam.”» ");
INSERT INTO sor_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Mana gɨ Moyis ilə hára lə me gɨr bɨrmə lə da, an̰ji ha ꞌya wála dodə mwom da, Aba dama gɨ dɨrəw bɨr̰ɨn̰ gɨra ꞌyow me ùr ba a ꞌyəw bam. ");
INSERT INTO sor_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Moyis dyaməw dɨ Sepora di u gɨla gɨ balo me sawɨw gɨ gorndɨdɨ ban̰a. Tandi u dwe di dyanaw bɨdɨ dɨ tandi sawdɨ di me ɓɨlɨw abəw gɨdawə me way ba da: «Mə i tɨrən gɨ bare gɨ ta di me ɓamɨndɨ.» ");
INSERT INTO sor_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ di kal Moyis pəgɨn̰. I dara gwale gɨnə sawa gɨ ban̰a di me Sepora wayɨw gɨ Moyis ba i tɨrədɨ gɨ bare me ba ɓamgɨ. ");
INSERT INTO sor_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayaw Arõ ba hana ꞌywana Moyis mana gɨ dɨn dwar̰ɨ lə, me an̰ji ha gɨra ha ꞌywaa chendɨw di mana gɨ kur̰a dɨnə Mãr̰ĩ duwa lə mwom da, an̰ji jirmɨw yɨw sɨwə. ");
INSERT INTO sor_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Moyis kɨbɨw Arõ gwale pad gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayaw gandɨw dara an̰ju ba waynaw di, me mani nə dan̰a nə an̰ji ɨrmɨw dara an̰ju ba àlna di me ca. ");
INSERT INTO sor_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Ɨr̰ɨ nə Moyis day gɨ Arõ borgɨ bɨrmə lə hargɨ ca. Mana gɨ cendi gɨr sɨn̰a dɨ Ejibtɨ lə mwom da,  cendi dáy nare nə Israyel nə dɨrəgɨ nagdɨ pad dodə ");
INSERT INTO sor_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","me, Arõ di kɨbɨgɨ gwale gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayaw Moyis di daa pad me, an̰ji àl mani nə dan̰a di mana gɨ dɨrəgɨ lə me ca. ");
INSERT INTO sor_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Nare nə Israyel di kal dusɨrəgɨ mana gɨ gwale duwa di dɨwə. Mana gɨ cendi doy dara Aba dama gɨ dɨrəw bɨr̰ɨn̰ di ba yər gɨlə day gɨ dɨrɨn̰ di me, ba yala wagɨ lə me mwom da, cendi piy gubɨrəgɨ ɨbdər dodə dɨrəwə me mɨlawdɨw nɨm. ");
INSERT INTO sor_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Targɨn̰ ɗang da, nə Moyis day gɨ Arõ hargɨ ꞌywaa dole gɨ Ejibtɨ me wayɨw ba da: «Doy gwale gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ gɨ i Mãr̰ĩ gɨnə nare nə Israyel day wayɨw di me i ta: “Kal nare ni nə Israyel di, gɨ gandɨna hana mana gɨ dɨn dwar̰ɨ lə dara àlan gɨ sii ꞌywala.”» ");
INSERT INTO sor_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Ɨr̰ɨ dole di cogɨ waygɨ ba da: «Aba dama gɨ dɨrəw bɨr̰ɨn̰ di da, i wi me nə ha dwaya gwale duwa me, nə ha kala nɨm gɨ nare nə Israyel ba gandɨna hana nɨm di mo? Nə ꞌwocn̰ Aba dama gɨ dɨrəw bɨr̰ɨn̰ gɨ ta di bədə. Me nə ha kala nare nə Israyel di ha ganda hára bədə me ca.» ");
INSERT INTO sor_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Nə Moyis day gɨ Arõ wayɨw dole di bi ba da: «Mãr̰ĩ gɨnə nenin nə nare nə Ebɨrə nin di gɨlənin sɨw. Yande da, nə ùrɨmnin dara ba mə kalnanin bɨrmə, nə àlnin wála subu bɨrmə lə dara hára dɨn dwar̰ɨ lə. Nə ùrnin ba nə hanin bwasa Aba dama gɨ dɨrəw bɨr̰ɨn̰ gɨ i Mãr̰ĩ nin di, dara kal mwom gɨ gale bɨw, labaa say ꞌyánanin bam bədə.» ");
INSERT INTO sor_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Me dole gɨ Ejibtɨ di waygɨ ba da: «Moyis me Arõ me, ɓag ꞌyeni anə ùr ba nə ɨmgɨ nare nə Israyel di àla gɨ giyə day bam, dana mo? Cwarna hana mana gɨ giyə dan gɨ kwaynaniyə di bi. ");
INSERT INTO sor_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Wála gɨ caga lə da, nare nə ta di yala ꞌyarbar nan̰e sɨn̰a dɨ Ejibtɨ lə me, anə ùr cendi ba kalna àla gɨ giyə gɨ kwaynani di bam ɗɨm mo?» ");
INSERT INTO sor_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Wála gɨ ta lə di dog, dole gɨ Ejibtɨ waygɨ gechide woni yɨbə nare nə Israyel gɨ dwana giyə gɨ kwaynaniyə di me, nare woni ɗɨbə kwandagɨ nə Israyel dɨrəgɨ lə giyə lə me ba da: ");
INSERT INTO sor_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","«Pii da, i ꞌyeni me anə magdɨ mãyã ꞌyàgɨ́ nare nə Israyel piy gɨ dirɨngəl. Me caga ka da, kalnagɨ gɨ hana magdɨna mãyã di cendi. ");
INSERT INTO sor_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Me yɨbɨnəgɨ kalgɨ gɨ piynə dirɨngəl bwarna nɨm dɨ cendi piydɨ pii pii di bá, mɨn kaw, biynəgɨ bam bədə, dara cendi i nare nə gendəgə. I dara gendəgə day di me cendi ùr ba gɨ ha bwasa gɨ Mãr̰ĩ day di. ");
INSERT INTO sor_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Àlnagɨ hwaynagɨ nan̰ giyə gɨ àla lə me, gɨ ɨrmɨnə giyə di dɨwə me, yande mwom da, cendi ha kala ɨrmə day mana gɨ gwale gɨ kulagɨ dɨwə bədə ɗɨm.» ");
INSERT INTO sor_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Mwom da, gechide woni yɨbə nare nə Israyel gɨ dwana giyə lə di me, nare woni ɗɨbə kwandagɨ nə Israyel dɨrəgɨ lə me ganda hára waygɨ nare nə Israyel di ba da: «Dwayna, gwale gɨ dole gɨ Ejibtɨ wayɨw di me i ta: “Caga da, an̰ji ha magdang sulu bədə ɗɨm. ");
INSERT INTO sor_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Anə ha kan̰ja sulu di ꞌyeni gang mana gɨ anə ha ꞌywaa lə di. Me anə ha piyə dirɨngəl di bwarna nɨm ya dɨ gɨ ɨrməng pii di de kɨrab, mɨn kaw, ba a biyəng bam bədə.”» ");
INSERT INTO sor_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Ɨr̰ɨ nare nə Israyel di cɨgdɨ ha mana gɨ sɨn̰a dɨ Ejibtɨ gɨndɨdɨ lə pad dara magda gɨ bugi ɨrmɨw sulu. ");
INSERT INTO sor_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Gechide woni yɨbə nare nə Israyel gɨ dwana giyə lə di ur̰ɨgɨ sɨdəgɨ daa me waygɨ ba da: «Àlna giyə di le kaláng kaláng ꞌyan̰aw bam! Wála mɨn bá bá da, piynə dirɨngəl di bwarna nɨm dɨ anə piydɨ pii wála gɨ gɨ ꞌyàng gɨ sulu lə di.» ");
INSERT INTO sor_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Gechide woni yɨbə nare nə Israyel gɨ dwana giyə lə di gobɨ nare nə cendi tanga chɨ́gdɨgɨ kwandagɨ nə Israyel dɨrəgɨ lə di me waygɨ ba da: «Tanga me laba me da, anə piy dirɨngəl di bor nɨm dɨ gɨ ɨrməng gandɨdɨ di bədə, dana mo? Pii da, anə piye.» ");
INSERT INTO sor_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Mwom da, nare woni ɗɨbə kwandagɨ nə Israyel dɨrəgɨ lə di ha nulbəw dole gɨ Ejibtɨ di me wayɨw ba da: «Dana me mə àlnin nenin woni àlam giyə di yande mo? ");
INSERT INTO sor_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Caga da, gɨ magdɨnin nenin woni àlam giyə di sulu bədə, me gɨ waynin ba nə piynənin dirɨngəl di le. Caga dwara kaw, gɨ gwaba woni àlam giyə di le. Nare dɨma di àl i àcn̰a!» ");
INSERT INTO sor_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Ɨr̰ɨ dole gɨ Ejibtɨ waygɨ woni ɗɨbə kwandagɨ nə Israyel dɨrəgɨ lə di ba da: «ꞌYeni da, anə i nare nə gendəgə! I sɨdɨ, anə i gendəgə ꞌyang! I yande me anə way nɨm anə banə ha i bwasa Aba dama gɨ dɨrəw bɨr̰ɨn̰ di. ");
INSERT INTO sor_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Caga da, hana àlna giyə! Gɨ ha magdang sulu di bədə. Me anə ha piyə dirɨngəl di bwara nɨm dɨ anə piydɨ pii pii di bá!» ");
INSERT INTO sor_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Nare woni ɗɨbə kwandagɨ nə Israyel dɨrəgɨ lə di yala yər dara ba gɨ i gɨ wamani gɨ geche, gɨ waygɨ ba piynə dirɨngəl di bwarna gɨ dɨ cendi piydɨ pii wála mɨn dalawə bá bá di, mɨn kaw, ba gɨ biygɨ bam bədə. ");
INSERT INTO sor_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Mana gɨ nare woni ɗɨbə kwandagɨ nə Israyel dɨrəgɨ lə di ba gɨ dɨmə iche ciri bɨdɨ dɨnə doleyə di mwom da, cendi gɨra ɓamar jisgɨ gɨ nə Moyis day gɨ Arõ nə ilə gamagɨ lə ciri bɨdə di. ");
INSERT INTO sor_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Mwom da, nare woni ɗɨbə kwandagɨ nə Israyel dɨrəgɨ lə di waygɨ da: «Kal Aba dama gɨ dɨrəw bɨr̰ɨn̰ me yarna mani nə anə àlagɨ̀ di me, a kalnang pəgɨn̰ bədə me ca. I dara darang ꞌyeni di me, dole gɨ Ejibtɨ day gɨ nə woni àlaw giyə me ùr ba gɨ yərnin dɨrəgɨ lə bədə bɨr̰ɨn̰ ta di. I ya anə banə ꞌyàgɨ́ sugɨnə ɨsɨragɨ lə dara ba ꞌyánanin nɨm de.» ");
INSERT INTO sor_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Ɨr̰ɨ Moyis co dɨrəw Aba dama gɨ dɨrəw bɨr̰ɨn̰ dɨwə me wayɨw ba da: «Aba ciri ni, dana me mə gɨlgɨ nare nə Israyel di dɨrəgɨ yande mo? Dana me mə giyən ka di mo? ");
INSERT INTO sor_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Mana gɨ nə yala ꞌyo gɨ dole gɨ Ejibtɨ dara wayaw gwale gɨ sumɨm bá da, an̰ji so gɨlgɨ nare dɨma nə Israyel di dɨrəgɨ nan̰, me ɨjɨm mə àl mani mɨn dara kɨdəgɨ nɨm daa bədə!» ");
INSERT INTO sor_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: «Caga ka da, mə ha yara mani nə nə ha àlaw dole gɨ Ejibtɨ di gɨ dɨrəm. Gɨ ɨsən gaba dwana da, dole di ha kala nare nə Israyel ba gandɨna bam sɨn̰a duwa dɨ Ejibtɨ lə di. Gɨ ɨsən gaba dwana di, an̰ji ha ꞌywaragɨ cendi ba dɨmnə bam kalna sɨn̰a duwa di.» ");
INSERT INTO sor_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Ɨr̰ɨ Mãr̰ĩ wayɨw Moyis ɗang bi ba da: «Ɨndi di, nə i an̰ju gɨ ꞌwogɨ sumɨw “Aba dama gɨ dɨrəw bɨr̰ɨn̰” di. ");
INSERT INTO sor_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Tanga pii da, nə gɨləgɨ nə Abɨraham me, Isak me, Jakob me sɨn, ba nə i Mãr̰ĩ gaba dwana. Me sumɨn gɨ “Aba dama gɨ dɨrəw bɨr̰ɨn̰” di da, nə gɨləgɨ gandɨw bədə. ");
INSERT INTO sor_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Nə yɨ gandagɨ mɨlan, nə biygɨ bɨn dara ba nə ꞌyàgɨ́ sɨn̰a dɨ Kanan, dɨ i sɨn̰a day bədə dɨ cendi cɨmdɨ dam lə di. ");
INSERT INTO sor_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Ɗang kaw, nə doy nulə gɨ nare nə Israyel nul dara kwaynani dɨ nare nə Ejibtɨ àlgɨ di mwom da, nə ɨrɨm mana gɨ mɨlan dɨ nə yəə gɨ mwágɨragɨ di dɨdə. ");
INSERT INTO sor_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Yande da, mə ha wayagɨ nare nə Israyel gwale gɨ sumɨn ba da: “Ɨndi di, nə i Aba dama gɨ dɨrən bɨr̰ɨn̰ di! Giyə gɨ wome gɨ nare nə Ejibtɨ chə́ng dɨdəngə ta di, nə ha kɨdəng daa dalawə. Nə ha kɨrəng daa kwaynani dɨ cendi ilə àlang gandɨdɨ lə ta di. Nə ha kɨrəng daa gɨ ɨsən gaba dwana me, nə ha agɨ sariya dɨ wome nan̰ me ca. ");
INSERT INTO sor_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Nə ha layang cwang nare ni me, nə ha ꞌya i Mãr̰ĩ dan me ca. I ta di me anə ha ꞌwacn̰a nɨm dara ɨndi di, ba nə i Aba dama gɨ dɨrən bɨr̰ɨn̰ gɨ nə i Mãr̰ĩ dan di, an̰ju gaba kɨdəng daa mana gɨ giyə gɨ wome gɨ nare nə Ejibtɨ chə́ng gandɨw dɨdəngə di dalawə. ");
INSERT INTO sor_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Ɗang da, nə ha layang bwang mana gɨ sɨn̰a dɨ tanga nə biyəgɨ nə Abɨraham me Isak me, Jakob me bɨn ba nə ha ꞌyàgɨ́ di lə. I ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ di me nə ꞌyàng sɨn̰a dɨ ta di, kaldɨ dɨ gɨdɨnə dan.”» ");
INSERT INTO sor_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Moyis ha wayagɨ nare nə Israyel gwale gɨ ta di, me cendi yɨ gwale duwa di bədə, dara kwaynani dɨ wome di ɗoy dɨdəgɨ le. ");
INSERT INTO sor_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: ");
INSERT INTO sor_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","«Ha wayaw dole gɨ Ejibtɨ di a kalna nare nə Israyel gɨ gandɨna bam mana gɨ sɨn̰a duwa lə di.» ");
INSERT INTO sor_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Me Moyis cow lə diiyə ba da: «Nare nə Israyel kaw, yɨ gwale ni bədə dimm, dole gɨ Ejibtɨ da, ha yəə gwale ni ɨndi gɨ waya gɨ gwale womɨn ka di man mo?» ");
INSERT INTO sor_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ waygɨ nə Moyis day gɨ Arõ ba da: «Hana waynagɨ nare nə Israyel me dole gɨ Ejibtɨ me, dara kal anə gandɨ gɨ nare nə Israyel di bam sɨn̰a dɨ Ejibtɨ lə.» ");
INSERT INTO sor_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Dwaynandɨ gechide nə tanga pii yara war̰agɨ nə Israyel nə sabar dodə di dɨdəgɨ sumdəgɨ: Jakob gorndɨw gɨ man̰jɨli gɨ gɨ ꞌwogɨw Ruben gangle duwa gɨ sabar dodə di me i ta: Dɨndaw woni yara war̰agɨ dɨdəgɨ da, i nə Enok me, Palu me, Hesɨron me, Karmi me ca. ");
INSERT INTO sor_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Simiyõ gangle duwa gɨ sabar dodə di me i ta: Dɨndaw woni yara war̰agɨ dɨdəgɨ da, i nə Yemuwel me, Yamin me, Ohad me, Yakin me, Sowar me, Sawul gɨ iw i deme dɨ sɨn̰a dɨ Kanan lə me ca. ");
INSERT INTO sor_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Dwaynandɨ, Lebi dɨndaw me mwàgɨraw sumdəgɨ me i ta: Dɨndaw da, i Gerchon me, Kehat me, Merari me. Me Lebi di dam sɨn̰a dɨdə ka àl aliya aru gɨ gɨnɨn̰ subu gɨ dii wurgɨsubu (137). ");
INSERT INTO sor_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Gerchon dɨndaw da, i nə Libɨni day gɨ Chimey. Wi kaw, i geche gaba yara war̰aw dɨdəgɨ bá bá. ");
INSERT INTO sor_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Kehat dɨndaw da, i nə Amram me, Isar me, Ebɨron me, Ujel me. Kehat dam sɨn̰a dɨdə ka àl aliya aru gɨ gɨnɨn̰ subu gɨ dii subu (133). ");
INSERT INTO sor_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Merari dɨndaw da, i nə Mali me Muchi me. Cendi nə pad ta di me i Lebi gangle duwa gɨ sabar dodə jiga jiga di. ");
INSERT INTO sor_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram di u Yokebed deme. Yokebed di i awaw, me tandi yə̀w nə Arõ day gɨ Moyis. Me an̰ji dam sɨn̰a dɨdə ka àl aliya aru gɨ gɨnɨn̰ subu gɨ dii wurgɨsubu (137). ");
INSERT INTO sor_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Isar dɨndaw da, i nə Kore me, Nebeg me, Jigɨri me. ");
INSERT INTO sor_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Ujel dɨndaw da, i nə Michayel me, Elsaban me, Sitɨri me. ");
INSERT INTO sor_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Arõ di u deme dɨ gɨ ꞌwogɨdɨ Elicheba dɨ i Aminadab durməw. Tandi i Nachon chidɨw. Me tandi yə̀w Arõ di nə Nadab me, Abiyu me, Eliyajar me, Itamar me. ");
INSERT INTO sor_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Kore dɨndaw woni yara war̰agɨ dɨdəgɨ da, i nə Asir me, Elkana me, Abiyasap me. ");
INSERT INTO sor_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eliyajar gɨ i Arõ gorndɨw, u Putiyel durməw dɨ mɨn deme. Me tandi yə̀w Eliyajar di dwe gɨ gɨ ꞌwogɨw Piniyas. Ta di me i gechide woni yara war̰agɨ nə sabar dodə dɨdəgɨ nə i nare nə Lebi di. ");
INSERT INTO sor_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","I nə Arõ day gɨ Moyis di me Aba dama gɨ dɨrəw bɨr̰ɨn̰ waygɨ ba da: «Walna nare nə Israyel gandɨna gandagɨ bam sɨn̰a dɨ Ejibtɨ lə gɨ bɨrmə duwa kɨrab kɨrab.» ");
INSERT INTO sor_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","I nə Moyis day gɨ Arõ di me hargɨ ꞌywaa dole gɨ Ejibtɨ wayɨw dara ba kalna nare nə Israyel di ba gandɨna bam sɨn̰a duwa dɨ Ejibtɨ lə. ");
INSERT INTO sor_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Wála gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis gwale mana gɨ sɨn̰a dɨ Ejibtɨ lə da, ");
INSERT INTO sor_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","an̰ji wayɨw ba da: «Ɨndi di, nə i Aba dama gɨ dɨrən bɨr̰ɨn̰ di. Ha wayaw dole gɨ Ejibtɨ di gwale pad gɨ nə wayɨm gandɨw di.» ");
INSERT INTO sor_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Me Moyis cow Aba dama gɨ dɨrəw bɨr̰ɨn̰ di lə diiyə ba da: «Ɨndi da, waya gɨ gwale womɨnne, ta di me dole gɨ Ejibtɨ di ha yəə gwale ni gɨ nə ha wayaw di man man mo?» ");
INSERT INTO sor_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: «Yər, nə com gɨdɨm gun gɨ i ya Mãr̰ĩ gɨnə dole gɨ Ejibtɨ duwa de, me chendɨm gɨ Arõ da, ha ꞌya i aba cɨmə bɨm me ca. ");
INSERT INTO sor_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Ɨjɨm gɨ Moyis da, mə ha wayaw chendɨm gɨ Arõ gwale gɨ nə u bɨn wayɨm gandɨw pad di, me chendɨm gɨ Arõ di, hana cɨmnəw dole gɨ Ejibtɨ gwale di daa dara an̰ju ba kalna nare nə Israyel ba gandɨna bam sɨn̰a duwa lə di. ");
INSERT INTO sor_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Me ɨndi da, nə ha àla dole di kal dɨw wayna le. Nə ha àla mani nə àl lán̰a me mani nə dan̰a me mana gɨ sɨn̰a dɨ Ejibtɨ lə kaw, ");
INSERT INTO sor_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","an̰ji ha yəə gwale dan di bədə. Yande da, nə ha àsa ɨsən gaba dwana mana gɨ sɨn̰a dɨ Ejibtɨ dɨdə me, nə ha agɨ nare dɨra sariya dɨ wome nan̰ me ca. Ɨr̰ɨ nə ha dɨməgɨ nare ni nə Israyel bam sɨn̰a dɨ Ejibtɨ lə gɨ bɨrmə duwa kɨrab kɨrab. ");
INSERT INTO sor_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Ta di me nare nə Ejibtɨ ha ꞌwacn̰a dara ɨndi di, ba nə i Aba dama gɨ dɨrən bɨr̰ɨn̰ di. Cendi ha ꞌwacn̰an i dawa dɨ nə dara àsa ɨsən gaba dwana mana gɨ sɨn̰a day dɨdə me nə ha dɨməgɨ nare ni nə Israyel bam dwar̰agɨ lə di.» ");
INSERT INTO sor_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Mani nə Aba dama gɨ dɨrəw bɨr̰ɨn̰ u bɨw waygɨ nə Moyis day gɨ Arõ ba àlnagɨ di me, cendi àlgɨ yande dige dige. ");
INSERT INTO sor_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Wála gɨ nə Moyis day gɨ Arõ ha wayaw dole gɨ Ejibtɨ gwale lə di da, Moyis aliya duwa nem gɨnɨn̰ dunasɨr (80) me, Arõ duwa da, nem gɨnɨn̰ dunasɨr gɨ dii subu (83) me ca. ");
INSERT INTO sor_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ waygɨ nə Moyis day gɨ Arõ ba da: ");
INSERT INTO sor_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","«Mana gɨ dole gɨ Ejibtɨ ùrnə anə banə àlna mani nə dan̰a da, wayɨw Arõ a unə cilang duwa álnaw dole di dɨrəwə, me cilang di ha cwara gɨdə kwalà.» ");
INSERT INTO sor_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Moyis day gɨ Arõ hargɨ gɨrgɨ doleyə di me, àlgɨ mani nə Aba dama gɨ dɨrəw bɨr̰ɨn̰ ꞌwoo bɨw wayagɨ cendi ba àlnagɨ̀ di. Arõ u cilang di álgɨ nə dole day gɨ nə woni àla gandɨw giyə dɨrəgɨ lə me, cilang di cor gɨdɨ kwalà. ");
INSERT INTO sor_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Ɨr̰ɨ dole di kaw, ꞌwaga nare duwa woni ꞌwacn̰a mani me, woni àla bəli me, nare nə Ejibtɨ nə ta di, gɨra àl mani nə dan̰a gɨ monəni day wun ya nənə Arõ duwa de me ca. ");
INSERT INTO sor_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Wi kaw gɨra ál cilang duwa dodə sɨn̰a lə bá bá, me cilangde day di kaw cor kɨdɨ kwalàle me ca. Me cilang gɨnə Arõ duwa chə́gdɨ nə day di bam. ");
INSERT INTO sor_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Yande pad kaw, dole àl dii dɨ woye, an̰ji gɨn̰ yəə gɨ gwale gɨnə Moyis day gɨ Arõ di bam com, ya tanga Aba dama gɨ dɨrəw bɨr̰ɨn̰ ba a waya nɨm de. ");
INSERT INTO sor_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: «Dole gɨ Ejibtɨ di àl dii dɨ woye me gɨn̰ kala gɨ nare nə Israyel di dara cendi ba gandɨna kalna sɨn̰a dɨ Ejibtɨ di bam bədə mwom da, ");
INSERT INTO sor_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","sanga gɨ jomni cor̰ər̰ə mana gɨ an̰ji dara dɨmə hára kuray bɨwə da, mə dɨm ha gamaw alə dɨrəwə pii kuray di bɨwə. U cilang gɨ dee cwara gɨdə kwalà ka di daa ɨsəmmə me, ");
INSERT INTO sor_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","wayɨw dole di da: “Aba dama gɨ dɨrəw bɨr̰ɨn̰ gɨ i Mãr̰ĩ gɨnə nare nə Ebɨrə day giyən sɨmmə ba nə hane waynam ba mə kalna nare duwa di gɨ hana dɨn dwar̰ɨ lə dara mɨlawdaw, me caga ka kaw, ba mə gɨn̰ dwaya gɨ gwale duwa di bam. ");
INSERT INTO sor_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","I dara ta di me, doy, gwale gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw di me i ta: Caga ka da, mə ha ꞌwacn̰a dara an̰ji ba i Aba dama gɨ dɨrəw bɨr̰ɨn̰ di. Nə ha awra nimi nə kurayyə gɨ cilang gɨ i ɨsənnə ka di me, nimi di ha cwara gɨdə bare. ");
INSERT INTO sor_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Gòche ha mara bam kuray dalawə me, nimi nə kurayyə ha biyə àcn̰e me ca. Nare nə Ejibtɨ ha nyama chàa nimi duwa di bədə.”» ");
INSERT INTO sor_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba waynaw Arõ ba unə cilang duwa daa me, ba yána ɨsəw ɨjɨnə nimi nə sɨn̰a dɨ Ejibtɨ lə bá bá, mana gɨ kurayyə me, kuray suləlɨn̰ duwa lə me, modɨdeyə me bɨlaleyə me ca. Mana pad gɨ nimi ina lə da, nimi di ba ha cwara gɨdə bare. Bare ba ha ꞌya lə mana gɨ sɨn̰a dɨ Ejibtɨ dɨdə pad. Dáge day nə gɨ ɗangr̰ɨgɨ gɨ habde me nə gɨ ɗangr̰ɨgɨ gɨ kur̰a me kaw, bare ba ha ꞌya lə dwar̰agɨ lə me ca. ");
INSERT INTO sor_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Moyis day gɨ Arõ àl mani nə Aba dama gɨ dɨrəw bɨr̰ɨn̰ waygɨ cendi ba àlnagɨ di. Arõ u cilang di daa me, awɨr gɨ nimi nə kurayyə di mana gɨ nə dole day gɨ nə woni àla gandɨw giyə di dɨrəgɨ lə. Mwom da, nimi di pad cor gɨdɨ bare. ");
INSERT INTO sor_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Gòche mar bam kuray dalawə me, nimi nə kurayyə biy àcn̰e me ca. Nare nə Ejibtɨ nem chàa nimi nə kurayyə di bədə. Bare ilə sɨn̰a dɨ Ejibtɨ dwar̰ɨ lə pad. ");
INSERT INTO sor_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Me nare woni àla charwa nə Ejibtɨ di àl mani gɨ monəni day ya ta de dige dige me ca. Me dole àl dii dɨ woye, an̰ji gɨn̰ yəə gɨ gwale gɨnə Moyis day gɨ Arõ di bam com, ya tanga Aba dama gɨ dɨrəw bɨr̰ɨn̰ ba a waya nɨm de. ");
INSERT INTO sor_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","An̰ji cogɨ tarɨw me, ɨndər yá ulay duwa lə, dolɨw gɨ gwale day di bədə. ");
INSERT INTO sor_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Me nare pad nə Ejibtɨ piy bɨlale mana gɨ kuray bɨwə cab cab ba gɨ ꞌyo nimi nə chàa, dara cendi nem chàa gɨ nimi nə kurayyə di bədə. ");
INSERT INTO sor_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Aba dama gɨ dɨrəw bɨr̰ɨn̰ àl kuray di wamani gɨ bare di nem wála wurgɨsubu mwom da, ");
INSERT INTO sor_vpl VALUES ("EX7_26","003_7_26","EXO","7","26","26","an̰ji wayɨw Moyis ba da: «Ha ꞌywaa dole gɨ Ejibtɨ me wayɨw da: “Doy, gwale gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw di me i ta: Kal nare ni nə Israyel di, gɨ gandɨna hana le dara mɨlawdan. ");
INSERT INTO sor_vpl VALUES ("EX7_27","003_7_27","EXO","7","27","27","Me mə ɨmnəgɨ hára bam bi da, nə ha bwaa bɨlay ꞌyarbara mana gɨ sɨn̰a dɨ wama dɨma lə pad. ");
INSERT INTO sor_vpl VALUES ("EX7_28","003_7_28","EXO","7","28","28","Bɨlay ha ꞌyarbara kuray dalawə me, ha ganda bam kuray dalawə parba hára dama bɨdang dɨma lə me, kulu dɨma gɨ ꞌya lə me, solbə dɨma lə me, ciri dɨnə woni àla gandɨm giyə lə me, ciri dɨnə nare dɨma lə pad me, mana gɨ gɨ piyɨm gɨ mapa dɨma lə me, mana gɨ mani nə gɨ koy gɨ burə gaba piyə mapa lə me ca. ");
INSERT INTO sor_vpl VALUES ("EX7_29","003_7_29","EXO","7","29","29","Bɨlay di ha parba nagda daa sɨmmə me, nagda nare dɨma nə Ejibtɨ lə pad sɨdəgɨ lə me, woni àla gandɨm giyə sɨdəgɨ lə me ca.”» ");
INSERT INTO sor_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba waynaw Arõ ba unə cilang duwa daa me, ba yána ɨsəw ɨjɨnə nimi nə sɨn̰a dɨ Ejibtɨ lə bá bá, mana gɨ kurayyə me, kuray suləlɨn̰ duwa lə me, modɨdeyə me ca, kal bɨlay di nagɨna parbɨna hana ꞌwanna sɨn̰a dɨ Ejibtɨ dɨdɨ daa pad. ");
INSERT INTO sor_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Mwom da, Arõ di yəə ɨsəw ɨjɨ nimi nə sɨn̰a dɨ Ejibtɨ lə me, bɨlay di naga daa kurayyə hára ꞌwon sɨn̰a dɨ Ejibtɨ dɨdɨ daa. ");
INSERT INTO sor_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Me nare woni àla charwa nə Ejibtɨ àl monəni day me, bɨlay ganda hára ꞌwon sɨn̰a dɨ Ejibtɨ dɨdɨ daa me ca. ");
INSERT INTO sor_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Ɨr̰ɨ dole di ꞌwaga Moyis day gɨ Arõ sɨwə me waygɨ ba da: «Amsɨna Aba dama gɨ dɨrəw bɨr̰ɨn̰ di kal a ꞌywarna bɨlay di bam hən̰ sɨnnə me nare ni sɨdəgɨ lə me. Mwom da, nə ha kala nare dan nə Israyel di gɨ hana le dara bwasaw.» ");
INSERT INTO sor_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Me Moyis cow dole di lə diiyə ba da: «Ladɨ! Ɨrmɨn wála gaba amsa Mãr̰ĩ di ɨjɨm, me nə ha amsa Mãr̰ĩ dara daram me, dara woni àlam giyə me, dara nare nə ciri dɨma dɨdə me. Kal Aba dama gɨ dɨrəw bɨr̰ɨn̰ di a ꞌywarna bɨlay di bam bɨdang dɨma lə me, ciri dɨma dwar̰ɨ lə me, kal bɨlay di hana damna kurayyə mɨra.» ");
INSERT INTO sor_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","An̰ji wayɨw ba àlna sanga. Ɨr̰ɨ Moyis wayɨw ba da: «Nə ha àla mani di le ya ba mə way nɨm de. Yande do me, mə ha ꞌwacn̰a dara gun gaba bwara gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ gɨ i Mãr̰ĩ nin di da, ba ilə bədə. ");
INSERT INTO sor_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Bɨlay di ha kalam me, ha kala ciri dɨma me, ha kala woni àla gandɨm giyə me, ha kala nare nə ciri dɨma dɨdə di me, ha dama i kurayyə mɨra.» ");
INSERT INTO sor_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Moyis day gɨ Arõ gandɨgɨ bam bɨdang dɨnə doleyə di, mwom da, Moyis soy ꞌwogɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ dara ba ꞌywarna bɨlay gɨ an̰ji bwaw gandɨw dole di bam. ");
INSERT INTO sor_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Mwom da, Aba dama gɨ dɨrəw bɨr̰ɨn̰ àl mani nə Moyis ùrɨw an̰ju ba àlnaw di. Bɨlay di marbɨ bam mana gɨ kululi dwar̰agɨ lə me, ciri dwar̰ɨ lə me, dàgeyə me. ");
INSERT INTO sor_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Gɨ lay bɨlay di hogdɨw daa daa, me sɨn̰a dɨ Ejibtɨ dɨdɨ biy ɗwa me ca. ");
INSERT INTO sor_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Me mana gɨ dole di yər dara mani di ba yala biya le mwom da, an̰ji àl dii dɨ woye bi, gɨn̰ dwaya gɨ gwale gɨnə Moyis day gɨ Arõ di bam, ya tanga Aba dama gɨ dɨrəw bɨr̰ɨn̰ ba a waya nɨm de. ");
INSERT INTO sor_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba waynaw Arõ ba unə cilang duwa daa me, ba yána ɨsəw awɨrna sɨn̰a me kal usɨsɨ dɨra ba gɨdɨnə bede mana gɨ sɨn̰a dɨ Ejibtɨ dɨdə pad. ");
INSERT INTO sor_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Ɨr̰ɨ cendi àl ya ta de di. Arõ u cilang duwa di me, yə́ ɨsəw awɨr gɨ sɨn̰a. Me usɨsɨ gɨnə sɨn̰a di cor gɨdɨ bede me, bede di wom nare me, wom mwagɨne me. Usɨsɨ gɨnə sɨn̰a dɨ Ejibtɨ lə pad kɨdɨ bede. ");
INSERT INTO sor_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Nare woni àla charwa nə Ejibtɨ gɨrsɨ dara ba gɨ àl mani nə dan̰a nə ya ta de di gɨ monəni day di me ca. Me cendi nem àla bədə. Me bede wom nare me, wom mwagɨne me ca. ");
INSERT INTO sor_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Ɨr̰ɨ woni àla charwa di wayɨw dole di ba da: «Ta di, i Mãr̰ĩ ɨsəw gaba dwana me àl mani nə ta di.» Me dole di àl dii dɨ woye, gɨn̰ dwaya gɨ gwale gɨnə Moyis day gɨ Arõ di bam com, ya tanga Aba dama gɨ dɨrəw bɨr̰ɨn̰ ba a waya nɨm de. ");
INSERT INTO sor_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: «Sanga gɨ jomni cor̰ər̰ə da, so daa, mə ha ɗɨbə dole gɨ Ejibtɨ di dɨrəwə pii bɨrmə duwa gaba hára kurayyə. Mana gɨ an̰ji dara ganda hára kurayyə da, mə ha wayaw da: “Doy, gwale gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw di me i ta: Kal nare ni nə Israyel di, gɨ gandɨna hana le dara mɨlawdan. ");
INSERT INTO sor_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Me mə ɨmnəgɨ hára bam da, nə ha bwam don̰ gaba ɗwagda mana dɨmmə me, woni àla gandɨm giyə dɨdəgɨ lə me, nare nə ciri dɨma dɨdə dɨdəgɨ lə me, ciri dɨma dwar̰ɨ lə me. Don̰ di ha ꞌyarbara kɨrə dɨma lə me, kɨrə nə nare nə Ejibtɨ dayyə me, mana gɨ sɨn̰a dɨ Ejibtɨ dɨdə me. ");
INSERT INTO sor_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Me wála gɨ ta lə di, tulɨn̰ dɨ Gochen dɨ nare ni nə Israyel dam lə da, don̰ gaba ɗwagda mana di ha ꞌya lə bədə. Yande do me mə ha ꞌwacn̰a dara ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ di, ba nə ilə sɨn̰a dɨma lə di ꞌyang. ");
INSERT INTO sor_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Yande da, wamani gɨ ha àla nare dɨma da, ha àla nare ni bədə. I sanga me nə ha àla mani nə dan̰a nə ta di.”» ");
INSERT INTO sor_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Aba dama gɨ dɨrəw bɨr̰ɨn̰ àl mani nə an̰ji waya gwale day di. Don̰ gaba ɗwagda mana di dɨmə gɨ gɨr̰ə nan̰ bor kɨrə nə doleyə me, kɨrə nə woni àla gandɨw giyə lə me, kɨrə nə nare nə Ejibtɨ dayyə pad me ca. Don̰ gaba ɗwagda mana di àl wamani nan̰ sɨn̰a dɨ Ejibtɨ dɨdə pad. ");
INSERT INTO sor_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Ɨr̰ɨ dole di ꞌwaga Moyis day gɨ Arõ sɨwə me waygɨ ba da: «Hana bwasɨna Mãr̰ĩ dan di, me bwasɨnaw sɨn̰a dɨ ka di dɨdə.» ");
INSERT INTO sor_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Moyis cow dole di lə diiyə ba da: «Nə nemnin àla yande bədə, dara bwasa nin gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ gɨ i Mãr̰ĩ nin di àl nare nə Ejibtɨ ɨn̰ama le. Gaa nə àlnanin bwasa gɨ ya ta de di dɨrəgɨ lə da, cendi ha jaranin gɨ kur̰a ꞌyánin bam bədə mo? ");
INSERT INTO sor_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Me ùrnin i àla wála subu hára lə bɨrmə lə dara hára dɨn dwar̰ɨ lə me, Aba dama gɨ dɨrəw bɨr̰ɨn̰ gɨ i Mãr̰ĩ nin di ha gɨlənin bɨrmə gaba bwasaw di an̰ju me nə hanin àla nɨm.» ");
INSERT INTO sor_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Ɨr̰ɨ dole di waygɨ da: «Ladɨ! Nə ha kalang anə ha hára bwasa Aba dama gɨ dɨrəw bɨr̰ɨn̰ gɨ i Mãr̰ĩ dan di mana gɨ dɨn dwar̰ɨ lə di le. Ɗɨm da, hana hən̰ bədə. Me amsɨna Mãr̰ĩ daran.» ");
INSERT INTO sor_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Moyis cow dole di lə diiyə ba da: «Nə dara ganda bam ciri dɨma lə da, nə ha amsa Aba dama gɨ dɨrəw bɨr̰ɨn̰ dara daram. Sanga da, an̰ji ha ꞌywara don̰ gaba ɗwagda mana di bam kɨrə dɨma lə me, kɨrə nə woni àla gandɨm giyə lə me, kɨrə nə nare nə sɨn̰a dɨma lə me ca. Me kal lamanin ɗi! Mə ha waya da: “Gandɨna hana le dara bwasa gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ di” me, ɨr̰ɨ mə gɨra ha ɨmənin bam da, ladɨ bədə.» ");
INSERT INTO sor_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Moyis di ganda bam ciri dɨnə doleyə di me amsɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰. ");
INSERT INTO sor_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Ɨr̰ɨ, Aba dama gɨ dɨrəw bɨr̰ɨn̰ di, àl mani nə Moyis ùrɨw ba àlnaw di. An̰ji ꞌyor don̰ gaba ɗwagda mana di bam dole sɨwə me, woni àla gandɨw giyə sɨdəgɨ lə me, nare nə sɨn̰a duwa lə sɨdəgɨ lə me ca. Don̰ gaba ɗwagda mana di mɨn kaw, wor lə bədə. ");
INSERT INTO sor_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Ta di kaw, dole di àl dii dɨ woye, ɨmgɨ nare nə Israyel ganda di bam com. ");
INSERT INTO sor_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: «Ha ꞌywaa dole gɨ Ejibtɨ me wayɨw da: “Doy, gwale gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ gɨ i Mãr̰ĩ gɨnə nare nə Ebɨrə day wayɨw di me i ta: Kal nare ni nə Israyel di, gɨ gandɨna hana le dara mɨlawdan.” ");
INSERT INTO sor_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Me mə ɨmnəgɨ hára bam bi me, mə ajɨmarna dara gamagɨ sɨmmə jang sɨn̰ da, ");
INSERT INTO sor_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","an̰ju Gaba dama gɨ dɨrəw bɨr̰ɨn̰ di, ba a ha àsa mwom gɨ geche mana gɨ mani dɨma nə paga nə dam bam: nə leme me, kura me, jambal me, labje me, bage me, dɨdəgɨ lə. ");
INSERT INTO sor_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","An̰ju Gaba dama gɨ dɨrəw bɨr̰ɨn̰ di, ba a ha àsa angal duwa yara mani nə paga nənə nare nə Israyel day me, nənə nare nə Ejibtɨ day me. Mani nə paga nənə nare nə Israyel day da, mɨn tenene kaw, ba ha mara bam bədə. ");
INSERT INTO sor_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Me an̰ju Gaba dama gɨ dɨrəw bɨr̰ɨn̰ di, ba a ɨrɨm wála gɨ ba a ha àla gɨ mani nə ta di mana gɨ sɨn̰a dɨ Ejibtɨ lə di, ba i sanga.» ");
INSERT INTO sor_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Me sanga dɨra da, Aba dama gɨ dɨrəw bɨr̰ɨn̰ àsɨ mwom di. Me mani nə paga nənə nare nə Ejibtɨ day pad mar bam, me nənə nare nə Israyel day da, mɨn tenene kaw, mar bam bədə. ");
INSERT INTO sor_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Mwom da, dole di ùrbɨ dara mani nə paga made day di me, an̰ji yər dara mani nə paga nənə nare nə Israyel day da, mɨn tenene kaw, ba mar bam bədə. Ta di kaw, dole di àl dii dɨ woye, ɨmgɨ nare nə Israyel ganda di bam com. ");
INSERT INTO sor_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ waygɨ nə Moyis day gɨ Arõ ba da: «Layna dɨbɨrɨn̰ dɨ mana gaba wáa dirɨngəl lə ꞌwanbɨna ɨsɨrang daa, me kal Moyis chɨgdɨnədɨ daa mana gɨ dole di dɨrəwə. ");
INSERT INTO sor_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Dɨbɨrɨn̰ di ha cwara gɨdə usɨsɨ me ha cagda daa sɨn̰a dɨ Ejibtɨ dɨdə pad. Dɨbɨrɨn̰ di ha hára gɨ mwom gɨ bwaa me gɨdɨ diyabe mana gɨ nare sɨdəgɨ lə me, mwagɨne nənə nare nə Ejibtɨ day sɨdəgɨ lə me ca.» ");
INSERT INTO sor_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Ɨr̰ɨ Moyis day gɨ Arõ lay dɨbɨrɨn̰ dɨ mana gaba wáa dirɨngəl lə di ꞌwanba ɨsɨragɨ daa, me hára nɨm dole di dɨrəwə, me Moyis chɨ́gdɨdɨ daa. Mwom da, dɨbɨrɨn̰ di cor gɨdɨ usɨsɨ me cəgdɨ daa me hára gɨ mwom gɨ bwaa me gɨdɨ diyabe mana gɨ nare sɨdəgɨ lə me mwagɨne sɨdəgɨ lə me ca. ");
INSERT INTO sor_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Woni àla charwa nə Ejibtɨ di nem hára ꞌywaa Moyis bədə, dara cendi kaw, diyabe di sabɨgɨ le ya ba sabɨ nɨm gɨ nare pad nə Ejibtɨ di de me ca. ");
INSERT INTO sor_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ àl dole di dɨw woy, yande me, dole di gɨn̰ dwaya gwale gɨnə Moyis day gɨ Arõ di bam com, ya tanga Aba dama gɨ dɨrəw bɨr̰ɨn̰ di ba a wayaw nɨm gɨ Moyis ta de. ");
INSERT INTO sor_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: «Sanga gɨ jomni cor̰ər̰ə da, so ha ꞌywaa dole gɨ Ejibtɨ me wayɨw da: “Doy, gwale gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ gɨ i Mãr̰ĩ gɨnə nare nə Ebɨrə day wayɨw di me i ta: Kal nare ni nə Israyel di, gɨ gandɨna hana le dara mɨlawdan. ");
INSERT INTO sor_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Caga ka da, nə ha àsam wamani gɨ dɨrəw jiga jiga àlnam me, àlna woni àla gandɨm giyə me, àlna nare dɨma nə Ejibtɨ me, dara kal mə ꞌwacn̰ana dara gun mɨn sɨn̰a dɨdə ka gaba bwara gandɨn da, ilə bədə. ");
INSERT INTO sor_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Me dee nə àsɨnam mwom gɨ gale bɨw gɨ ɨsən gaba dwana da, ɨjɨm me, nare dɨma me da, dee anə ilə sɨn̰a dɨdə ka bədə ɗɨm. ");
INSERT INTO sor_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Me yər, nə kalɨm mə wor dam lə bɨ̀ra sɨn̰a dɨdə ka sɨn̰ ta di, i dara ba mə ꞌwacn̰ana dwana ni me, kal sumɨn ꞌwagɨna nɨm sɨn̰a dɨdə ka pad me ca. ");
INSERT INTO sor_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Caga ka di, mə ajɨmarna ɨmnəgɨ nare ni nə Israyel di hára bam com da, ");
INSERT INTO sor_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","sanga gɨ dawa dɨ ya ka de da, nə ha ꞌwāa gɨna gɨ gabe gɨ dwana. Mana gɨ nare diy gɨnɨn̰ dam nɨm sɨn̰a dɨ Ejibtɨ lə bá da, mãr̰ĩ ꞌwāa duwa gɨ dwana gɨ ya ta de di, dii mɨn kaw, gun yərɨw bədə sɨn̰. ");
INSERT INTO sor_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Caga ka da, mani dɨma nə paga me mani dɨma nə ꞌywaa me nə ilə bam pad da, bogɨ kulə. Me nare me, mani nə paga me, nə ina lə kulə bədə me warnay bam da, mãr̰ĩ ꞌwāa duwa gɨ gɨna gɨ gabe di ha ꞌyágɨ bam pad.”» ");
INSERT INTO sor_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Woni àla giyə gɨ dole nə yab yɨ gwale gɨnə Aba dama gɨ dɨrəw bɨr̰ɨn̰ di me ꞌyolɨm bo woni àlagɨ́ giyə me, paga day me kulə. ");
INSERT INTO sor_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Me woni àsa dɨdəgɨ mana gɨ gwale gɨnə Aba dama gɨ dɨrəw bɨr̰ɨn̰ di dɨwə bədə da, kala woni àlagɨ́ giyə me, paga day me wara bam. ");
INSERT INTO sor_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: «U ɨsəm gɨl daa me nə ha ꞌwāa gɨna gɨ gabe mana gɨ sɨn̰a dɨ Ejibtɨ dɨdə pad, mana gɨ nare dɨra dɨdəgɨ lə me, mwagɨne dɨdəgɨ lə me, swagə nə yiga pad nə sɨn̰a dɨ Ejibtɨ lə dɨdəgɨ lə me.» ");
INSERT INTO sor_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Mwom da, Moyis u cilang duwa gɨl daa me, Aba dama gɨ dɨrəw bɨr̰ɨn̰ di ɨr̰ɨn̰jɨ me ꞌwō gɨna gɨ gabe me, jər dùwa mana gɨ sɨn̰a dɨdə me. Aba dama gɨ dɨrəw bɨr̰ɨn̰ di ꞌwō gɨna gɨ gabe mana gɨ sɨn̰a dɨ Ejibtɨ dɨdə pad. ");
INSERT INTO sor_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Mãr̰ĩ ꞌwāa gɨna gɨ gabe di me jara dùwa me gɨ dwana nan̰e. Mana gɨ nare diy gɨnɨn̰ dam nɨm sɨn̰a dɨ Ejibtɨ lə bá da, mãr̰ĩ ꞌwāa duwa gɨ gɨna gɨ gabe gɨ ya ta di, pii da, dii mɨn kaw, gun yaraw bədə sɨn̰. ");
INSERT INTO sor_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Mana gɨ sɨn̰a dɨ Ejibtɨ lə pad da, gɨna gɨ gabe di gobɨ mani pad nə wara bam: gwaba nare me, mani nə paga me, swagə me, piy habde nə bɨ̀ra pad daa me ca. ");
INSERT INTO sor_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","I tulɨn̰ dɨ Gochennə dɨ nare nə Israyel dam lə di mɨra me, Mãr̰ĩ ꞌwō gɨna gɨ gabe di lə bədə. ");
INSERT INTO sor_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Mwom da, dole di ꞌwaga Moyis day gɨ Arõ me waygɨ ba da: «Caga ka da, nə yala ꞌwocn̰ dara ba nə àl i mani nə àcn̰e. Aba dama gɨ dɨrəw bɨr̰ɨn̰ di me i gun gɨ tɨba an̰ju. Ɨndi me, nare ni me da, gwale nin ha lə bədə. ");
INSERT INTO sor_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Amsɨna Aba dama gɨ dɨrəw bɨr̰ɨn̰ di kal a hwayna ɨr̰ɨn̰jə di me, ꞌwāa gɨ gɨna gɨ gabe di me. Mwom da, nə ha kalang anə ha ganda hára le, gun ha ɨməng hára bam bədə ɗɨm.» ");
INSERT INTO sor_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Moyis wayɨw dole di ba da: «Mana gɨ nə gandɨna bam ciriyə mwom da, nə ha laya ɨsan daa amsa gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ di me, an̰ji ha hwaya ɨr̰ɨn̰jə di me, ꞌwāa gɨ gɨna gɨ gabe di me ca. Dara kal mə ꞌwacn̰ana dara sɨn̰a di, ba i Aba dama gɨ dɨrəw bɨr̰ɨn̰ di duwa. ");
INSERT INTO sor_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Caga ka kaw, nə ꞌwocn̰ dara ɨjɨm me, woni àla gandɨm giyə me, anə ha lán̰aw Mãr̰ĩ Gaba dama gɨ dɨrəw bɨr̰ɨn̰ di bədə com.» ");
INSERT INTO sor_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Mani nə gɨ yigɨgɨ dara ɗangr̰a gɨ barge me, swagə nə gɨ ꞌwogɨgɨ orjɨ me, myandara bam, dara swagə nə orjɨ di dɨmə dɨdəgɨ le ɗɨm me, mani nə gɨ yigɨgɨ dara ɗangr̰a gɨ barge di kaw, hoo le ɗɨm me ca. ");
INSERT INTO sor_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Ɨr̰ɨ geme me, swagə nə ɗang nə wun ya geme de me da, myandara bam bədə, dara cendi naa i targɨn̰. ");
INSERT INTO sor_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Moyis dɨmə bam iche kɨrə nə doleyə me bam ciriyə me mwom da, lay ɨsaw daa me amsɨ gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ me, mãr̰ĩ hoy ɨr̰ɨn̰jə di me ꞌwāa gɨ gɨna gɨ gabe di me ꞌwāa gɨ nimi di me ɗɨm. ");
INSERT INTO sor_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Mana gɨ dole di yala yər dara mãr̰ĩ ꞌwāa duwa gɨ nimi di me, ꞌwāa duwa gɨ gɨna gɨ gabe di me, ɨr̰ɨn̰jə duwa di me yala ɗɨbɨ dodə mwom da, an̰ji wor ajɨmar àl àcn̰a di com me àl dii dɨ woye di me, woni àla gandɨw giyə di kaw, àl ya an̰ju di de me ca. ");
INSERT INTO sor_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Dole di àl dii dɨ woye, ɨmgɨ nare nə Israyel ganda di bam com, ya tanga Aba dama gɨ dɨrəw bɨr̰ɨn̰ ba a wayaw gɨ Moyis ba waynagɨ nɨm ta de. ");
INSERT INTO sor_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: «Ha ꞌywaa dole gɨ Ejibtɨ di. Nə àláw ɨndi me dɨw woy nɨm day gɨ nə nare duwa woni àla gandɨw giyə di. Nə àl yande dara ba nə àl nɨm gɨ mani ni nə dan̰a mana gɨ dwar̰agɨ lə ");
INSERT INTO sor_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","me i dara ba mə kɨbɨnəgɨ dɨndam me, mwàgɨram me, mani ni nə nə àlagɨ́ nare nə Ejibtɨ di me, mani ni nə dan̰a nə nə àlagɨ̀ dwar̰agɨ lə dara gɨlə gɨ dwana ni di me ca. I yande me, anə ha ꞌwacn̰a dara ɨndi di, ba nə i Aba dama gɨ dɨrən bɨr̰ɨn̰ di.» ");
INSERT INTO sor_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Ɨr̰ɨ Moyis day gɨ Arõ di hargɨ ꞌywaa dole gɨ Ejibtɨ di me wayɨw ba da: «Doy, gwale gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ gɨ i Mãr̰ĩ gɨnə nare nə Ebɨrə day wayɨw di me i ta: Mə ha gɨn̰ə àsa gɨ dɨm dodə dɨrənnə bam bɨraa wála ɨndi na sɨn̰ mo? Kal nare ni nə Israyel di, gɨ gandɨna hana le dara mɨlawdan. ");
INSERT INTO sor_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Me mə ɨmnəgɨ hára bam com sɨn̰ da, sanga nə ha bwam sɨba dɨ diw mana gɨ sɨn̰a dɨ wama dɨma lə. ");
INSERT INTO sor_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Diw di ha n̰ara ꞌyarbara ꞌwana sɨn̰a dɨdɨ daa, gun ha nyama yara sɨn̰a dɨdɨ bədə bɨr̰ɨn̰. Tandi ha wama swagə nə tanga mãr̰ĩ ꞌwāa duwa gɨ gɨna gɨ gabe kalgɨ wor bɨl di bam pad. Habde dan nə dam bam di, tandi ha wamagɨ bam pad. ");
INSERT INTO sor_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Tandi ha ꞌwanba kululi dɨma dwar̰agɨ daa me, ha ꞌwanba kululi nənə woni àla gandɨm giyə day daa me, kululi nənə nare pad nə Ejibtɨ day daa me ca. Abɨram me, mwágɨram nə pii ɓɨg me, mana gɨ dam nɨm sɨn̰a dɨdə bɨraa yala caga ka kaw, wor yara wamani gɨ ya ta de di sɨn̰.» Mana gɨ ta lə da, Moyis so dɨm ha iche kal dole di. ");
INSERT INTO sor_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Ɨr̰ɨ woni àla giyə gɨ dole di wayɨw dole di ba da: «Abe gɨ ta di ha àlandɨ wamani di i bɨraa mɨndi na sɨn̰ mo? Kal nare nə Israyel di gɨ hana le dara mɨlawda gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ gɨ i Mãr̰ĩ day di le. Mə ꞌwocn̰ dara sɨn̰a ɨnda dɨ Ejibtɨ di ilə myandara bam ta bədə mo?» ");
INSERT INTO sor_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Ɨr̰ɨ gɨ ꞌwaga nə Moyis day gɨ Arõ cwagɨ hára nɨm dole di sɨwə bi. Me dole di waygɨ ba da: «Hana le dara mɨlawda gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ gɨ i Mãr̰ĩ dan di. Ɗɨm da, nare woni hára di, i nə wi mo?» ");
INSERT INTO sor_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Moyis cow lə diiyə ba da: «Nə hanin hára le pad ninnə: Nare nin nə sɨdəgɨ wor dɨnani me, war̰anin nə halbe me, dɨndɨranin nə abje me nə namde me. Nə hanin hára gɨ mani nin nə paga nə dine me, nə gechide me ca. Dara nə hanin àla sii ꞌywala gaba àsaw Aba dama gɨ dɨrəw bɨr̰ɨn̰ sumi gɨ ꞌwaga dɨwə.» ");
INSERT INTO sor_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","11","Dole di waygɨ ba da: «Anə ɨrɨm ba nə ha kalang anə banə ha hára dan gɨ nə dɨndɨrang di le pad bá? Ina yande da, kal Aba dama gɨ dɨrəw bɨr̰ɨn̰ di a ina lə gandang! Me i yande bədə bɨr̰ɨn̰. Anə kan̰jɨ i gwale. Anə ha hára pad dannə bədə. Kal abje me hana cendi mɨra dara mɨlawda gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ di, dara ta di me i mani nə anə ùrgɨ di.» Cor gɨ ꞌywaragɨ bam dole di dɨrəwə. ");
INSERT INTO sor_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: «Yə́ ɨsəm mana gɨ sɨn̰a dɨ Ejibtɨ dɨdə dara kal sɨba dɨ diw hane. Dɨ hane ꞌyarbarna sɨn̰a dɨ Ejibtɨ dɨdə me wamna mani pad nə tanga mãr̰ĩ ꞌwāa duwa gɨ gɨna gɨ gabe ꞌyágɨ bədə di bam me ca.» ");
INSERT INTO sor_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Moyis u cilang duwa gɨl daa sɨn̰a dɨ Ejibtɨ dɨdə mwom da, Aba dama gɨ dɨrəw bɨr̰ɨn̰ biyə gale tulɨn̰ dɨ jomniyə. Gale di wà hɨrɨm daa me, mana walɨw daa me ca. Sanga gɨ jomni da, gale di laya diw yala nɨm. ");
INSERT INTO sor_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Diw di ɓɨr̰ɨn̰ə hára mu sɨn̰a dɨ Ejibtɨ dɨdə daa gwam, me u mana bam pad. Diw dɨ ta di, gɨr̰ə dɨra da, dii mɨn kaw, gun yaradɨ pii bədə sɨn̰, me ɗan̰ gun ha yaradɨ ɗang bədə bɨr̰ɨn̰ me ca. ");
INSERT INTO sor_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Diw di mu sɨn̰a dɨ Ejibtɨ di dɨdɨ daa gwam me, gun yər sɨn̰a dɨdɨ bədə me. Tandi wom chemde nə bɨ̀ra bam pad me, habde yàa day nə tanga mãr̰ĩ ꞌwāa gɨna gɨ gabe me kalgɨ wor di bam pad me. Mana gɨ sɨn̰a dɨ Ejibtɨ lə pad di, habde nə bɨ̀ra bajɨragɨ me swagə nə yiga me da, hin̰e kaw, wor lə bədə. ");
INSERT INTO sor_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Ɨr̰ɨ dole di ꞌwaga nə Moyis day gɨ Arõ sɨwə kaláng me waygɨ ba da: «Nə àl àcn̰a gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ gɨ i Mãr̰ĩ dan di me, gandang ꞌyeni me ca. ");
INSERT INTO sor_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Caga da, kalna dusɨrəng hɨlalna dɨnnə lə dii mɨn ɗang bi me, amsɨna Aba dama gɨ dɨrəw bɨr̰ɨn̰ gɨ i Mãr̰ĩ dan di, kal a unən wamani gaba háran gɨ made gɨ ta di bam dɨnnə.» ");
INSERT INTO sor_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Moyis dɨmə bam kɨrə nə doleyə di me, amsɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ di ");
INSERT INTO sor_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","me, Aba dama gɨ dɨrəw bɨr̰ɨn̰ di biyə gale gɨ geche swaa gɨndɨw tulɨn̰ dɨ turgɨ lə. Gale gɨ ta di, lay diw di bam pad ya gandɨdɨ bwadɨ kuray gɨ gɨ ꞌwogɨw Kuray gaba Dɨrwa dalawə. Diw di mɨn kaw, wor lə sɨn̰a dɨ Ejibtɨ dɨdə bədə ɗɨm. ");
INSERT INTO sor_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Cor Aba dama gɨ dɨrəw bɨr̰ɨn̰ àl dole di dɨw woy, me dole di ɨmgɨ nare nə Israyel ganda di bam com. ");
INSERT INTO sor_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: «U ɨsəm gɨl daa me, kal dilɨm dɨ geche ɨbɨnə sɨn̰a dɨ Ejibtɨ daa kɨdab. Kal ina i dilɨm dɨ gun yarna mana bədə bɨr̰ɨn̰ me dɨmdarna daa pəgɨn̰ mad mad me ca.» ");
INSERT INTO sor_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Moyis di u ɨsəw gɨl daa mwom da, dilɨm dɨ geche yala ɨbɨ sɨn̰a dɨ Ejibtɨ daa kɨdab, àl wála subu bá. ");
INSERT INTO sor_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Wála gɨ subu di dalawə da, gun nem yara gɨ jaw bədə me, biy dɨgɨlaw daa ha mana gɨ ɗangə bədə me ca. Ɨr̰ɨ mana gɨ nare nə Israyel dam lə da, mana ácn̰e pɨrang. ");
INSERT INTO sor_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Mwom da, dole di ꞌwaga Moyis sɨwə me wayɨw ba da: «Hana le dara mɨlawda gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ di. Kal dɨndɨrang kaw hana le gandang me ca. Ɗɨm da, mani dan nə paga nə dine me, nə gechide me da, kalnagɨ dodə ka.» ");
INSERT INTO sor_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Me Moyis wayɨw dole di ba da: «Bədə. I ɨjɨm gang me mə ha ꞌyànin mani nə paga woni bwasa gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ gɨ i Mãr̰ĩ nin di me, woni ulə àlaw gɨ sarga di me ca. ");
INSERT INTO sor_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Nə hanin laya mani nin nə paga di daa hára nɨmme me ca, mɨn tenene kaw, ha wara dodə bədə. Dara nə wornin yala alə ta sɨn̰ da, nə ꞌwocn̰ɨnin i mani nə paga nə we me, nə hanin an̰jiragɨ kwandagɨ dwar̰agɨ lə àlaw gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ sarga di bədə.» ");
INSERT INTO sor_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Cor Aba dama gɨ dɨrəw bɨr̰ɨn̰ àl dole di dɨw woy, me dole di ɨmgɨ nare nə Israyel di ganda gaba hára di bam com. ");
INSERT INTO sor_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Dole di wayɨw Moyis ba da: «Ha bam hən̰ tulɨnnə! Àsɨ angal dɨma le! Cware hare sɨnnə ɗang bədə ɗɨm! Wála gɨ mə cwarnay hane sɨnnə ɗang da, mə ha mara le.» ");
INSERT INTO sor_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Moyis cow lə diiyə ba da: «Ladɨ. Nə ha cwara hára sɨmmə ɗang bədə bɨr̰ɨn̰, ya ba mə way nɨm de.» ");
INSERT INTO sor_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: «Nə ha cwara àsaw dole gɨ Ejibtɨ di me nare duwa nə Ejibtɨ di me wamani mɨn ɗang. Mwom da, an̰ji ha kalang anə ha hára le me, i hára mɨra bədə, an̰ji ha ꞌywarang i bam sɨn̰a duwa lə di, gɨ dɨrɨn̰ bɨr̰ɨn̰. ");
INSERT INTO sor_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Me mə ha wayagɨ nare nə Israyel kal abe gɨ we we kaw, ba hana ùrnə aba ciri duwa bɨdɨ me, deme dɨ we we kaw, ba hana ùrnə idɨ ciri dɨra bɨdɨ me mani nə gɨ ɗangr̰ɨgɨ gɨ tuda me, gɨ jindar me.» ");
INSERT INTO sor_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","I dara Aba dama gɨ dɨrəw bɨr̰ɨn̰ di me, nare nə Ejibtɨ àl gɨ dusi dɨ lade gɨ nare nə Israyel. Ɓag kaw, Moyis di i gun gɨ geche mana gɨ nare woni àla giyə gɨ dole dɨrəgɨ lə me, nare nə Ejibtɨ dɨrəgɨ lə me ca. ");
INSERT INTO sor_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Ɨr̰ɨ Moyis wayɨw dole di ba da: «Doy, gwale gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw di me i ta: “Gɨ changa dwar̰ɨ da, nə ha hára jàa sɨn̰a dɨ Ejibtɨ dɨdə, ");
INSERT INTO sor_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","mwom da, dine nə man̰jɨli pad nə Ejibtɨ ha mara bam, so mana gɨ dole gɨ dam gage gɨ dwãr̰ĩyə gorndɨw gɨ man̰jɨli, bɨraa hára nɨm kóy dɨ idɨ ɨgə kɨrə nə doleyə dwe dɨra gɨ man̰jɨli me. Mani nə paga dɨndɨragɨ nə abje nə gɨ yə̀gɨ dɨrɨn̰ nə piiyə bá bá kaw, ha mara bam me ca. ");
INSERT INTO sor_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Mana gɨ sɨn̰a dɨ Ejibtɨ dɨdə da, gɨ ha bwaa gura lə nan̰e. Gura gɨ ta di, dii mɨn kaw, gun dwayaw bədə sɨn̰ me, ɗan̰ kaw, ha ꞌya lə bədə bɨr̰ɨn̰ me ca. ");
INSERT INTO sor_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Ɗɨm da, nare nə Israyel ciri dayyə da, gɨ ha dwaya dogdə gurə gɨ gunnə bədə me, gurə gɨ mani nə paga lə bədə me ca. Ta di me anə ha ꞌwacn̰a dara ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ di ba nə àlang ꞌyeni nare nə Ejibtɨ mani nə jiga me, ba nə àlgɨ nare nə Israyel kaw mani nə jiga me ca.”» ");
INSERT INTO sor_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Me Moyis wayɨw dole di ba da:  «Mana gɨ ta lə da, woni àla gandɨm giyə pad di ha hára bwara piyə gubɨrəgɨ dodə gɨdannə mɨrgən nɨm ba da: “Dɨm gɨ nare dɨma woni pamam di, hana le bam hən̰!” Me mana gɨ ta lə di dog, nə ha ganda hára.» Moyis dusɨw so nan̰e me dɨmə bam kɨrə nə doleyə di. ");
INSERT INTO sor_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: «Dole gɨ Ejibtɨ di ha dwaya gwale dan bədə. Ta di me nə ha àla gɨ mani nə dan̰a dii gɨr̰ə nan̰ mana gɨ sɨn̰a dɨ Ejibtɨ lə di sɨn̰.» ");
INSERT INTO sor_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Moyis day gɨ Arõ àla mani nə dan̰a gɨr̰ɨ nan̰ mana gɨ dole di dɨrəwə. Me Aba dama gɨ dɨrəw bɨr̰ɨn̰ àl dole di dɨw woy, me dole di ɨmgɨ nare nə Israyel di ganda gɨ bam sɨn̰a duwa lə hára di com. ");
INSERT INTO sor_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Aba dama gɨ dɨrəw bɨr̰ɨn̰ waygɨ nə Moyis day gɨ Arõ gwale mana gɨ sɨn̰a dɨ Ejibtɨ lə ba da: ");
INSERT INTO sor_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","«Duru gɨ ka di, ha ꞌya i duru dan gɨ dɨrɨn̰ nə piiyə gɨnə aliya duwa. ");
INSERT INTO sor_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Hana waynagɨ chamrang nə Israyel pad dayyə da: Duru gɨ ka di ꞌwoo duwa gɨ mwaj lə da, nare ciri day dwar̰ɨ lə bá bá da, gɨ yɨnə gəgɨr̰ɨn̰ gɨ dwe, bədə kaw, gwa gɨ dwe bá bá. ");
INSERT INTO sor_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Me nare nə dam kɨrə mɨn di gɨr̰ɨnə nyamna wama gɨ gəgɨr̰ɨn̰ di bam pad bədə da, kalgɨ gɨ ɓamarna daa gɨ woni ciri day bɨdɨ nə dam tuləgɨ lə ib. Me gɨ yarna gɨr̰ə day di le do, me gɨ ɓɨr̰ɨn̰ə gəgɨr̰ɨn̰ labaa gwa di gɨ ha nyamagɨ wama cherni dayyə bá bá di sɨn̰. ");
INSERT INTO sor_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Anə ha ɓɨr̰ə i gəgɨr̰ɨn̰ labaa gwa gaba aliya mɨn gɨ mani nə àcn̰e hin̰e kaw ilə sɨwə bədə. ");
INSERT INTO sor_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Anə ha gama gəgɨr̰ɨn̰je di bɨraa wála gɨ mwaj dii wodɨ gɨnə duru gɨ ta di duwa lə. Me wála gɨ ta lə di, dawa ɗwanda dɨra lə da, ꞌyeni nare nə Israyel pad dannə ciri dan dwar̰ɨ lə bá bá da, anə ha kundɨbə gəgɨr̰ɨn̰je di. ");
INSERT INTO sor_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Anə dara kundɨbə da, anə ha ꞌwoo bare daa me, ciri dɨ anə ha wama kabni di lə dwar̰ɨ lə bá bá da, anə ha ɗagda bare di kululi bɨdəgɨ nə icheyə daa me tulɨn̰yə tulɨn̰yə me ca. ");
INSERT INTO sor_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Kabni di, anə ha wagdawe me, anə ha wamaw gɨ changa dɨ ta lə di dog, gɨ mapa gɨ dɨban musbu me, gɨ mani bajɨragɨ nə ɗan̰e me ca. ");
INSERT INTO sor_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Anə ha wama kabni di gɨ bɨ̀ra bədə me, anə ha hangdaw bədə me ca. Me anə ha wagdawe duwa lə gɨ nə gɨdaw me, dɨw me, nudəw me pad. ");
INSERT INTO sor_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Anə ha kala kabni di wála daa hin̰e bədə bɨr̰ɨn̰, me walna daa sanga da, anə ha uləw i bam. ");
INSERT INTO sor_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Mana gɨ anə dara wama da, magdɨna wamdang daa me, hurbɨna gɨbande dan gɨdɨrangə me, layna cilangde dan ɨsɨrangə me. Kal anə wom ꞌyen̰ bam kaláng dara bɨr̰ɨn̰yə hára. Ha ꞌya i sii ꞌywala gɨnə kɨrara gɨ daa kwaynaniyə gaba àsan ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ sumi gɨ ꞌwaga dɨnnə. ");
INSERT INTO sor_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Changa dɨ laba lə da, nə ha jàa sɨn̰a dɨ Ejibtɨ dɨdə. Me nə ha ꞌyáa dine nə man̰jɨli bam pad me nə ha ꞌyáa mani nə paga dɨndɨragɨ nə gɨ yə̀gɨ dɨrɨn̰ nə piiyə bam pad me ca. I yande di me nə ha agɨ nɨm gɨ domde nə sɨn̰a dɨ Ejibtɨ lə pad sariya dɨ wome nan̰ me ca. Ɨndi di, nə i Aba dama gɨ dɨrən bɨr̰ɨn̰. ");
INSERT INTO sor_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Nə ha jàa sɨn̰a dɨ Ejibtɨ dɨdə dara àsagɨ gɨ nare dɨra wamani. Me ꞌyeni da, bare di ha ꞌya i mani woni gɨlə ciri dɨ anə dam lə di. Mana gɨ nə dara yara bare gɨ ta di mwom da, nə ha cilangang daa. Wamani gɨ ta di ha àlang bədə. ");
INSERT INTO sor_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Gɨ aliya aliya wála gɨ ta lə di da, anə ha àla sii ꞌywala dara àsan ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ di sumi gɨ ꞌwaga dɨnnə, dara kal dusɨrəng gunəng nɨm daa mana gɨ mani nə àlal di dɨdəgɨ lə. Ta di me i bii gɨ ꞌwoo gɨ dam gɨ dɨrəw bɨr̰ɨn̰. Kal ꞌyeni nare nə Israyel gɨ swaa dan bá bá da, kalna dusɨrəng dɨwə gɨ dɨrɨn̰ bɨr̰ɨn̰.» ");
INSERT INTO sor_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","«Wála wurgɨsubu dalawə da, anə ha wama i mapa gɨ dɨban musbu. Wála gɨ dɨrɨn̰ nə piiyə da, anə ha laya musbu gɨ kɨrə dannə pad bwaw bam. Me gun gɨ wamna mapa gɨ gɨ àlɨw gɨ musbu di wála gɨ wurgɨsubu di dalawə da, kal gɨ ꞌywarnaw bam nare nə Israyel di dwar̰agɨ lə. ");
INSERT INTO sor_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Wála gɨ dɨrɨn̰ nə piiyə me, gɨ wurgɨsubu lə me da, anə ha dayara dara àsan ɨndi gɨ Mãr̰ĩ sumi gɨ ꞌwaga dɨnnə. Wála gɨ ta lə di, anə ha ɓɨlə ɨsɨrang giyə lə bədə bɨr̰ɨn̰. Me wi kaw, àlna i mani duwa nə wama mɨra. ");
INSERT INTO sor_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Anə ha àla sii ꞌywala gɨnə mapa gɨ dɨban musbu di kal dusɨrəng gunəng daa dara i wála gɨ ta di dalawə ɗən̰ me nə dɨməgɨ nare dan nə Israyel bam sɨn̰a dɨ Ejibtɨ lə di gɨ bɨrmə duwa kɨrab kɨrab. Ta di me i bii gɨ ꞌwoo gɨ dam gɨ dɨrəw bɨr̰ɨn̰. Kal ꞌyeni nare nə Israyel gɨ swaa dan bá bá da, kalna dusɨrəng dɨwə gɨ dɨrɨn̰ bɨr̰ɨn̰. ");
INSERT INTO sor_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","So wála gɨ mwaj dii wodɨ gɨnə duru gɨ mɨnnə gɨ dawa ɗwanda dɨra lə bɨraa ha wála gɨnɨn̰ sɨr gɨ dii mɨn gɨ dawa ɗwanda dɨra lə da, anə ha wama i mapa gɨ dɨban musbu mɨra. ");
INSERT INTO sor_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Wála wurgɨsubu gɨ ta di dalawə da, kal musbu hin̰e kaw, ina lə kɨrə dannə bədə. Me gun gɨ wamna mapa gɨ gɨ àlɨw gɨ musbu da, ina i mɨje gɨ dam dannə labaa gun gɨ ulay kaw, kal gɨ ꞌywarnaw bam nare nə Israyel di dwar̰agɨ lə. ");
INSERT INTO sor_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Anə ha wama mapa gɨ gɨ àlɨw gɨ musbu bədə. Me mana dan gɨ anə dam lə bá bá da, anə ha wama i mapa gɨ dɨban musbu mɨra.» ");
INSERT INTO sor_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Ɨr̰ɨ Moyis ꞌwaga nare nə Israyel nə dɨrəgɨ nagdɨ me waygɨ ba da: «Nare nə dam ciri dwar̰ɨ lə bá bá da, gɨ yɨnə gəgɨr̰ɨn̰ gɨ dwe labaa gwa gɨ dwe me, gɨ kundɨnə dara àla gɨ sii ꞌywala gɨnə kɨrara gɨ daa kwaynaniyə di. ");
INSERT INTO sor_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Anə ha chawa habda gɨ isop gangr̰aw me anə ha sow mana gɨ bare gɨ gəgɨr̰ɨn̰ gɨ gɨ bow mana gɨ pɨrayyə di me, anə ha ɗagda bare di mana gɨ kululi bɨdəgɨ nə icheyə daa me tulɨn̰yə tulɨn̰yə me. Kal gun mɨn gɨ ciri dan dwar̰ɨ lə gandɨna iche bədə, bɨraa jomni bá. ");
INSERT INTO sor_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Me mana gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ ha hára jàa gɨ Ejibtɨ dɨdə dara àlagɨ́ nare dɨra wamani me dara yara bare gɨ kululi bɨdəgɨ nə icheyə daa me tulɨn̰yə tulɨn̰yə me da, an̰ji ha cilanga daa, ha kala paja duwa gaba àla wamani ha dɨmə hára ciri dan dwar̰ɨ lə bədə. ");
INSERT INTO sor_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","I bii gɨ ꞌwoo gɨ dam gɨ dɨrəw bɨr̰ɨn̰. ꞌYeni me mwàgɨrang pad me da, anə ha kala dusɨrəng dɨwə. ");
INSERT INTO sor_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Mana gɨ anə dara hára ganda sɨn̰a dɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ biyəng bɨw way ba a ha ꞌyàng gandɨdɨ le di dɨdə mwom da, anə ha àla mani nə ta di. ");
INSERT INTO sor_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Me dɨndɨrang ùrnəng da, mani nə anə àlgɨ ta di, gɨndəgɨ ba i man mo da, ");
INSERT INTO sor_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","anə ha wayagɨ da: “I bwasa gɨnə sii ꞌywala gɨnə kɨrara gɨ daa kwaynaniyə dara àsaw Aba dama gɨ dɨrəw bɨr̰ɨn̰ sumi gɨ ꞌwaga dɨwə. An̰ji tanga cilanga ciri dɨnə nendɨ nə Israyel ɨnda di daa, wála gɨ an̰ji jàa gɨ Ejibtɨ dɨdə àla nare dɨra wamani, me kalandɨ nendɨ nə Israyel pəgɨn̰ di.”» Ɨr̰ɨ nare nə Israyel di piy gubɨrəgɨ dodə me, mɨlawdɨ gɨ Mãr̰ĩ ");
INSERT INTO sor_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","me, borgɨ hargɨ àla mani nə Aba dama gɨ dɨrəw bɨr̰ɨn̰ ɨrmɨgɨ nə Moyis day gɨ Arõ di yande dige dige me ca. ");
INSERT INTO sor_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Gɨ changa dwar̰ɨ da, Aba dama gɨ dɨrəw bɨr̰ɨn̰ ꞌyə dine nə abje nə man̰jɨli pad nə Ejibtɨ bam, so dole gɨ dam gage gɨ dwãr̰ĩyə gorndɨw gɨ man̰jɨli, bɨraa hára gun gɨ gɨ yɨw àsɨw dangeyə dwe duwa gɨ man̰jɨli me. Mani day nə paga dɨndɨragɨ nə abje nə gɨ yə̀gɨ dɨrɨn̰ nə piiyə kaw, an̰ji ꞌyəgɨ bam me ca. ");
INSERT INTO sor_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Changa dɨ ta lə di, dole gɨ Ejibtɨ me, woni àla gandɨw giyə me, nare pad nə Ejibtɨ me, ɓɨr̰in̰ɨgɨ daa bo gura, dara ciri dɨnə nare nə Ejibtɨ day dɨ made ilə dwar̰ɨ lə bədə da, ilə bədə. ");
INSERT INTO sor_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Changa dwar̰ɨ dɨ ta di lə, dole gɨ Ejibtɨ ꞌwaga nə Moyis day gɨ Arõ me waygɨ ba da: «Swana daa! Gandɨna bam sɨn̰a niyə. ꞌYeni me nare dan nə Israyel di me, hana le dara mɨlawda gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ di, ya anə banə waya nɨm de. ");
INSERT INTO sor_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Layna mani dan nə paga nə dine me, nə gechide me hana nɨm ɨsɨrangə, ya anə banə waya nɨm de. Me amsɨnan Mãr̰ĩ dan kal a piynə bɨw dɨnnə.» ");
INSERT INTO sor_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Nare nə Ejibtɨ ɨrɨm dusɨrəgɨ lə ba gɨ ha mara i bam pad. Cendi ur̰ɨgɨ nare nə Israyel di sɨdəgɨ daa, waygɨ cendi ba gandɨna bam kaláng sɨn̰a dayyə di. ");
INSERT INTO sor_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","I dara ta di me nare nə Israyel lay burə day gɨ cendi kurədɨw dɨban musbu dara piyə gɨ mapa di daa ɨsɨragɨ lə. Cendi magdɨ dásabe day woni piyə gɨ mapa di daa gɨ barge day me, lay chɨ́gdɨ kundɨrəgɨ lə, me hargɨ nɨm. ");
INSERT INTO sor_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Nare nə Israyel àl mani nə Moyis waygɨ di. Cendi amsɨgɨ nare nə Ejibtɨ mani nə gɨ ɗangr̰ɨgɨ gɨ tuda me, gɨ jindar me, barge me ca. ");
INSERT INTO sor_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","I dara Aba dama gɨ dɨrəw bɨr̰ɨn̰ di me, nare nə Ejibtɨ àl nɨm gɨ dusi dɨ lade gɨ nare nə Israyel me ꞌyàgɨ́ gɨ mani nə cendi ùrgɨ ɨsɨragɨ lə di. Mwom da, nare nə Israyel lay mani nə ꞌywaa nənə nare nə Ejibtɨ day yá nɨm ɨsɨragɨ lə. ");
INSERT INTO sor_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Nare nə Israyel di so kal ciri dɨ Ramses dara hára ciri dɨ Sukot lə. Cendi nem ya abje dubu aru aru kubi (600 000) de, dɨban āsa gɨ namde me dine me. ");
INSERT INTO sor_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Nare nə gɨndəgɨ ɗang nan̰ kaw ha gandagɨ mɨn, me mani day nə paga nə dine me, nə gechide me gɨr̰ɨ nan̰e me ca. ");
INSERT INTO sor_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Ɨr̰ɨ cendi ɓabdɨ bangaso gɨ dɨban musbu gɨ burə gɨ cendi kuradaw daa mana gɨ sɨn̰a dɨ Ejibtɨ lə di. I burə gɨ dɨban musbu, dara mana gɨ gɨ ꞌywaragɨ le cendi ba dɨmnə bam kaláng sɨn̰a dɨ Ejibtɨ lə di mwom da, cendi ꞌywaa bɨrmə gaba ɓyada gɨ burə gɨ cendi kuradaw di ba swadɨna bá bədə. Me cendi ꞌywaa bɨrmə gaba laya sadɨ ɨsɨragɨ lə bədə me ca. ");
INSERT INTO sor_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Nare nə Israyel di damagɨ sɨn̰a dɨ Ejibtɨ lə àla aliya aru aru wodɨ gɨ gɨnɨn̰ subu (430). ");
INSERT INTO sor_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Me aliya gɨ aru aru wodɨ gɨ gɨnɨn̰ subu di ꞌyan̰a duwa lə wála gɨ ta di dalawə ɗən̰ da, nare nə Israyel nə i nare nənə Aba dama gɨ dɨrəw bɨr̰ɨn̰ duwa di, dɨməgɨ bam sɨn̰a dɨ Ejibtɨ lə gɨ bɨrmə duwa kɨrab kɨrab. ");
INSERT INTO sor_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Changa dɨ ta lə da, Aba dama gɨ dɨrəw bɨr̰ɨn̰ wála daa baj dara dɨmə gɨ nare nə Israyel bam sɨn̰a dɨ Ejibtɨ lə. Yande da, nare nə Israyel di kaw gɨ swaa day bá bá da, ha wála daa changa dɨ ta lə di me ca, dara àsaw gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ sumi gɨ ꞌwaga dɨwə. ");
INSERT INTO sor_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Ɨr̰ɨ aba dama gɨ dɨrəw bɨr̰ɨn̰ waygɨ nə Moyis day gɨ Arõ ba da: «Yarna, bɨrmə gaba àla gɨ sii ꞌywala gɨnə kɨrara gɨ daa kwaynaniyə di me i ta: Kal gun gɨ gɨndɨw i Israyel bədə da, a wamna mani nə gɨ àlgɨ dara sii ꞌywala gɨnə kɨrara gɨ daa kwaynaniyə di bədə. ");
INSERT INTO sor_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Ina i kwaya gɨ anə kɨləwe kaw, sawnaw ban̰a bam do me a wamna mani nə ta di sɨn̰. ");
INSERT INTO sor_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Ɗɨm da, mɨje gɨ gɨndɨw i Israyel bədə gɨ hára daa gɨ gɨdaw me, aba àla giyə gɨ gɨ ꞌyogɨw gursɨ duwa le me da, kalgɨ gɨ wamna mani nə ta di bədə me ca. ");
INSERT INTO sor_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Me gəgɨr̰ɨn̰ gɨ dwe gɨ anə ha kundəw ciri dan dwar̰ɨ lə bá bá ta di, wamna kabni duwa kululi dan dwar̰agɨ lə mɨra, dɨmnə gɨ kabni di iche bədə. Kabni di da, anə ha aja guchen̰ duwa ichə bam bədə me ca. ");
INSERT INTO sor_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Nare nə Israyel pad dayyə ha àla sii ꞌywala gɨ ta di le. ");
INSERT INTO sor_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Ɗɨm da, gun gɨ gɨndɨw i Israyel bədə gɨ damna i ciri gandang me ùrnə ba a àlna sii ꞌywala dara àsaw Aba dama gɨ dɨrəw bɨr̰ɨn̰ sumi gɨ ꞌwaga dɨwə di gandang da, kal abje nə kɨrə duwa lə pad, gɨ sabɨnagɨ ban̰a bam do me, an̰ji ha àla sii ꞌywala di ya gun gɨ Israyel de sɨn̰. Gun gɨ sawna ban̰a bədə da, a wamna mani nə ta di bədə. ");
INSERT INTO sor_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","ꞌYeni nare nə Israyel me, nare nə ɗang nə dam ciri gandang me, anə ha ꞌwoo bii gɨ ꞌwoo gɨ ta di mɨn tenene àla gandɨw giyə.» ");
INSERT INTO sor_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Mwom da, nare nə Israyel pad àl mani nə Aba dama gɨ dɨrəw bɨr̰ɨn̰ ɨrməgɨ nə Moyis day gɨ Arõ di yande dige dige. ");
INSERT INTO sor_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Ɨr̰ɨ wála gɨ ta di dalawə ɗən̰ da, Aba dama gɨ dɨrəw bɨr̰ɨn̰ dɨməgɨ nare nə Israyel di bam sɨn̰a dɨ Ejibtɨ lə gɨ bɨrmə duwa kɨrab kɨrab. ");
INSERT INTO sor_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: ");
INSERT INTO sor_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","«Nare nə Israyel dɨndɨragɨ nə abje nə man̰jɨli pad me, mani day nə paga dɨndɨragɨ nə abje nə gɨ yə̀gɨ dɨrɨn̰ nə piiyə pad me da, anə ha biyən gandagɨ jiga. Cendi i ni ɨndi.» ");
INSERT INTO sor_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Ɨr̰ɨ Moyis waygɨ nare nə Israyel ba da: «Kal dusɨrəng gunəng daa wála gɨ anə ganda nɨm bam mana gɨ kwaynaniyə sɨn̰a dɨ Ejibtɨ lə di dɨwə. Dara i Aba dama gɨ dɨrəw bɨr̰ɨn̰ di gɨ ɨsəw gaba dwana di me dɨməng nɨm bam. Me wála gɨ ta lə di da, mapa gɨ gɨ àlɨ̀w gɨ musbu da, anə ha wama bədə. ");
INSERT INTO sor_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Wála gɨ anə so bor bɨrmə lə dara ganda hára di, i duru gɨ swagə ganda day gɨ dɨdəgɨ lə. ");
INSERT INTO sor_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Yande da, mana gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ dara ganda gandang sɨn̰a dɨnə nare nə Kanan dayyə me, nə Hiti dayyə me, nə Amori dayyə me, nə Hibi dayyə me, nə Yebus dayyə me, dɨ i sɨn̰a dɨ an̰ji biygɨ mwágɨrang bɨw dara ba a ha ꞌyàng gandɨdɨ le di da, anə ha àla sii ꞌywala mɨlawda gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ di duru gɨ ta di dalawə. I sɨn̰a dɨ nãy me dùmbu me chow lə nan̰e. ");
INSERT INTO sor_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Wála wurgɨsubu dalawə pad da, anə ha wama i mapa gɨ dɨban musbu mɨra. Ɨr̰ɨ wála gɨ wurgɨsubu lə da, anə ha àla sii ꞌywala dara àsaw Aba dama gɨ dɨrəw bɨr̰ɨn̰ di sumi gɨ ꞌwaga dɨwə. ");
INSERT INTO sor_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Wála wurgɨsubu dalawə di, anə ha wama i mapa gɨ dɨban musbu mɨra. Sɨn̰a dan dɨdə pad da, gɨ ha ꞌywaa mapa gɨ gɨ àlɨ̀w gɨ musbu lə bədə me, musbu kaw ina lə bədə me ca. ");
INSERT INTO sor_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Wála gɨ ta lə di, anə ha biyəgɨ dɨndɨrang sii ꞌywala gɨ ta di gɨndɨw wayagɨ da: “Də àlang i mani nə tanga Aba dama gɨ dɨrəw bɨr̰ɨn̰ àlandɨ gandagɨ wála gɨ də gandang nɨm bam sɨn̰a dɨ Ejibtɨ lə di.” ");
INSERT INTO sor_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Sii ꞌywala gɨ ta di, i ya láya dɨ anə magdɨdɨ ɨsɨrangə me, jin̰jɨrəngə me ta de dara anə banə yarnagɨ mwom da, dusɨrəng ba gunəng daa bii gɨ ꞌwoo gɨnə Aba dama gɨ dɨrəw bɨr̰ɨn̰ duwa di dɨwə, me anə ha waya gwale duwa le. Dara i Aba dama gɨ dɨrəw bɨr̰ɨn̰ gɨ ɨsəw gaba dwana di me, dɨməng nɨm bam sɨn̰a dɨ Ejibtɨ lə di. ");
INSERT INTO sor_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Aliya bá bá, wála gɨ ta di nyamna da, anə ha àla mani nə nə wayang gwale day di le kɨrab kɨrab.» ");
INSERT INTO sor_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","«Wála gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ dara ganda gandang sɨn̰a dɨ nare nə Kanan dayyə ya ba a biyə bɨw waya ba a ha ꞌyàgɨ́ gandɨdɨ mwágɨrang me ꞌyeni me da, ");
INSERT INTO sor_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","anə ha ꞌyàw Aba dama gɨ dɨrəw bɨr̰ɨn̰ di dɨndɨrang nə abje nə man̰jɨli me, mani dan nə paga dɨndɨragɨ nə abje nə gɨ yə̀gɨ dɨrɨn̰ nə piiyə me sarga, dara cendi i duwa an̰ju. ");
INSERT INTO sor_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Kura gɨ dwe gɨ gɨ yə̀w dɨrɨn̰ nə piiyə da, anə ha kɨlangaw gɨ gəgɨr̰ɨn̰ gɨ dwe. Me anə ùrnə kɨlangaw bədə da, ajɨna gɨgɨnaw ꞌyánaw bam. Me dɨndɨrang nə abje nə man̰jɨli kaw, anə ha ꞌyàa gursɨ bɨdəgɨ me ca. ");
INSERT INTO sor_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Me mana gɨ ɗan̰ dɨndɨrang ùrnəng ba da: “Də àlang yande dana mo?” da, waynagɨ da: “I Aba dama gɨ dɨrəw bɨr̰ɨn̰ gɨ ɨsəw gaba dwana me, dɨməndɨ nɨm bam mana gɨ kwaynaniyə sɨn̰a dɨ Ejibtɨ lə. ");
INSERT INTO sor_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Wála gɨ dole gɨ Ejibtɨ àla dii dɨ woye, ɨməndɨ ganda gaba hára bam da, Aba dama gɨ dɨrəw bɨr̰ɨn̰ ꞌyáa dine nə abje nə man̰jɨli nə sɨn̰a dɨ Ejibtɨ lə bam pad, bɨraa hára mani nə paga dɨndɨragɨ nə abje nə gɨ yə̀gɨ dɨrɨn̰ nə piiyə. I ta di me, mani nə paga nə abje nə gɨ yə̀gɨ dɨrɨn̰ nə piiyə da, də àlɨ́w ɨnda gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ sarga. Me dɨndɨrandɨ nə abje nə man̰jɨli da, də ꞌyàng gursɨ bɨdəgɨ me ca.” ");
INSERT INTO sor_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Sarga dɨ ta di, i ya láya dɨ i ya láya dɨ anə magdɨdɨ ɨsɨrangə me, jin̰jɨrəngə me ta de dara anə banə yarnagɨ mwom da, dusɨrəng ba gunəng daa Aba dama gɨ dɨrəw bɨr̰ɨn̰ di dɨwə, dara i an̰ji, gɨ ɨsəw gaba dwana di me, dɨməng nɨm bam sɨn̰a dɨ Ejibtɨ lə di.» ");
INSERT INTO sor_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Mana gɨ dole gɨ Ejibtɨ kal nare nə Israyel gandɨ dara hára da, Mãr̰ĩ ha gandagɨ gɨ bɨrmə gɨ sɨn̰a dɨnə nare nə Pilisi day gɨ i bɨrmə gɨ tɨba di bədə. Dara Mãr̰ĩ ɨrɨm dusɨwə ba da: «Nare nə Israyel di gɨrnə ɓamarna gɨ nare me jarna gandagɨ say da, ɨm gaa cendi gɨra ha basa i bagɨn me, ha ùrə ba gɨ cor ha i sɨn̰a dɨ Ejibtɨ lə di bi som.» ");
INSERT INTO sor_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","I ta di me an̰ji kalgɨ cendi kwongɨ nɨm gɨ bɨrmə gɨ dɨn dwar̰ɨ lə ɨjɨ kuray gɨ gɨ ꞌwogɨw Kuray gaba Dɨrwa. Nare nə Israyel di ɓɨr̰ɨn̰ kal sɨn̰a dɨ Ejibtɨ di me, bor ha nɨm gɨ bɨrmə duwa kɨrab kɨrab. ");
INSERT INTO sor_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Moyis lay guchindi nənə Josep duwa daa ɨsəwə ha nɨm. Dara tanga Josep di waygɨ chamraw ba da: «Mãr̰ĩ ha kalang bam bədə, an̰ji ha wang i lə bá. Sɨrgɨnə sɨdəng, wála gɨ anə dara hára da, layna guchindi ni daa ɨsɨrangə hana nɨm.» ");
INSERT INTO sor_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Ɨr̰ɨ nare nə Israyel di ɓɨr̰ɨn̰ kal ciri dɨ Sukot bam me, hargɨ gɨr ha ɗangr̰a kundi day mana mɨn gɨ gɨ ꞌwogɨw Etam gɨ i mana gɨ dɨn bɨdə ib. ");
INSERT INTO sor_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Me Aba dama gɨ dɨrəw bɨr̰ɨn̰ ɨndər dɨrəgɨ lə ha gandagɨ. Gɨ dawa da, an̰ji àsɨgɨ sawe dɨrəgɨ lə dara gɨləgɨ gɨ bɨrmə me, gɨ changa da, an̰ji àsɨ dùwa dɨrəgɨ lə ácn̰ɨgɨ mana bam, dara cendi ba hana nɨm gɨ dawa me, gɨ changa me ca. ");
INSERT INTO sor_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Sawe gɨ i dɨrəgɨ lə gɨ dawa ta di, aa bam bədə, ilə gandagɨ bɨr̰ɨn̰, me dùwa dɨ ácn̰ɨgɨ mana gɨ changa ta di kaw, ilə dɨrəgɨ lə budɨ bam bədə me ca. ");
INSERT INTO sor_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: ");
INSERT INTO sor_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","«Waygɨ nare nə Israyel gɨ cwarnay hane ɗangr̰ɨna kundi day di mana mɨn gɨ gɨ ꞌwogɨw Piyarot gɨ dam Migɨdol bulə day gɨ kuray gɨ gecheyə. I mana gɨ ta lə di me cendi ha ɗangr̰a kundi day dama nɨm lə mana gɨ gɨ ꞌwogɨw Baal Sepon dɨrəwə ib, kuray gɨ geche di bɨwə. ");
INSERT INTO sor_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Me dole gɨ Ejibtɨ di ha ɨrmə dara ꞌyeni nare nə Israyel di anə banə nol i bam. Dɨn dwar̰ɨ ba yá yɨbənge som. ");
INSERT INTO sor_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Nə ha àla dole di kal dɨw wayna le, kal a ꞌywarnang tarangə. Ɨr̰ɨ nə ha gɨlə dwana ni dɨ idɨ àla lán̰a dɨwə me, asɨngar duwa pad dɨdəgɨ lə me ɓugdɨgɨ dodə me ca. Yande da, nare nə Ejibtɨ pad ha ꞌwacn̰a dara ɨndi di, nə i Aba dama gɨ dɨrən bɨr̰ɨn̰ di.» Me nare nə Israyel àl mani di ya Moyis ba wayagɨ nɨm de dige dige. ");
INSERT INTO sor_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Mana gɨ gɨ wayɨw dole gɨ Ejibtɨ di, nare nə Israyel ba wagɨ yá le mwom da, an̰ji day gɨ nə woni àla gandɨw giyə co ɨrmə day nare nə Israyel di dɨdəgɨ lə way ba da: «Ɓag də àlang i na yande mo? Də kalang nare nə Israyel woni àla kwaynani ɨnda di wagɨ yá dana mo?» ");
INSERT INTO sor_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Mwom da, dole di u pus duwa dɨ idɨ jara say magdɨdɨ daa me, lay nare duwa woni jara say ha gandɨw me ca. ");
INSERT INTO sor_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","An̰ji an̰jir pus duwa dɨ ladɨbe dɨ idɨ jara say di nem aru aru kubi (600) me, pus dɨ ɗang dɨnə nare nə Ejibtɨ day kaw, ha gandɨw me ca. Pus dɨ idɨ jara say di dwar̰ɨ lə bá bá da, nare subu subu damdɨ lə. ");
INSERT INTO sor_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ àl dole gɨ Ejibtɨ di àl dii dɨ woye ꞌyor nare nə Israyel di taragɨ lə. Me nare nə Israyel di gandɨ bam sɨn̰a dɨ Ejibtɨ lə da, sɨdəgɨ ꞌyolgɨ dara ba gɨ i labiya ɗɨm. ");
INSERT INTO sor_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Nare woni jara say nənə dole gɨ Ejibtɨ duwa ꞌyor nare nə Israyel di taragɨ lə gɨ leme day pad me, gɨ pus pad me, woni ajila gɨ leme me, asɨngar nə ɗang pad me ca. Cendi gɨr ha ꞌywaa nare nə Israyel di damgɨ lə Piyarot gɨ i mana gɨ Baal Sepon dɨrəwə tɨba, kuray gɨ geche bɨwə ib. ");
INSERT INTO sor_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Mana gɨ dole gɨ Ejibtɨ di ha gɨr nare nə Israyel sɨdəgɨ lə ib mwom da, cendi u dɨrəgɨ daa yərɨw me gu: «Ay, nare nə Ejibtɨ di pamandɨ yala tarandɨ lə!» Lán̰a àlgɨ̀ nan̰e me, cendi sojɨ ꞌwogɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ mar̰ɨjagɨ daa nan̰, ");
INSERT INTO sor_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","me cendi wayɨw Moyis ba da: «Mə walanin yala nɨm dara ba nə marnanin bam dɨn dwar̰ɨ lə ka dana mo? Mana gɨ sɨn̰a dɨ Ejibtɨ lə da, mana gaba mugdə nare ilə nan̰ bədə mo? Mə walanin ganda nɨm bam sɨn̰a dɨ Ejibtɨ lə di dana mo? ");
INSERT INTO sor_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Tanga mana gɨ də warang nɨm sɨn̰a dɨ Ejibtɨ lə sɨn̰ di da, nə wayamnin ba mə kalnanin mana mɨn gaa bədə mo, ba nə àlgɨnin nare nə Ejibtɨ kwaynani di lə jang gaa bədə mo? Ta di biya ɗoy made dɨ nə ilənin maradɨ lə bam dɨn dwar̰ɨ lə ka di bam.» ");
INSERT INTO sor_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Ɨr̰ɨ Moyis waygɨ da: «Lán̰ɨna bədə! Ɗɨbɨnə wayna le mana mɨn jang me, anə ha yara kɨdə gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ ha kɨdəng daa laba di! Nare nə Ejibtɨ nə anə yərgɨ laba ka di, ɗan̰ anə ha yaragɨ ɗang bədə bɨr̰ɨn̰! ");
INSERT INTO sor_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","ꞌYeni da, damna bɨdəng mɨgɨmi àlna mani mɨn bədə. I Aba dama gɨ dɨrəw bɨr̰ɨn̰ di me ha jara say bɨdəng an̰ju.» ");
INSERT INTO sor_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: «Mə soy ꞌwogɨn ɨndi bá dana mo? Waygɨ nare nə Israyel di gɨ bwarna bɨrmə lə hana le. ");
INSERT INTO sor_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Ɨjɨm da, u cilang dɨma gɨl daa kurayyə jə̀ bɨrmə me, nare nə Israyel ha hára wayniyə kuray dalawə cilangaw nɨm. ");
INSERT INTO sor_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Me ɨndi ni da, nə ha àla nare nə Ejibtɨ di kal dɨdəgɨ wayna le, gɨ bwarna kurayyə di ꞌywarnang tarangə. Mwom da, nə ha gɨlə dwana ni dɨ idɨ àla lán̰a mana gɨ dole day gɨ nə asɨngar duwa dɨdəgɨ lə me, pus duwa dɨdə me, nare woni ajila gɨ leme dɨdəgɨ lə me, ɓugdɨgɨ dodə. ");
INSERT INTO sor_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Me mana gɨ nə gɨlnə dwana ni dɨ idɨ àla lán̰a dole dɨwə me, pus duwa dɨdə me, nare woni ajila gɨ leme dɨdəgɨ lə me, ɓugdɨgɨ dodə di mwom da, nare nə Ejibtɨ di ha ꞌwacn̰a dara ɨndi di, nə i Aba dama gɨ dɨrən bɨr̰ɨn̰ di.» ");
INSERT INTO sor_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Paja gɨ daa gɨnə Mãr̰ĩ duwa gɨ pii ɨndara nare nə Israyel dɨrəgɨ lə di, cwara hára ɨndər taragɨ lə ha gandagɨ me, sawe gɨ pii ɨbə mana dɨrəgɨ lə di kaw, cwara hára ɨbɨ mana taragɨ lə me ca. ");
INSERT INTO sor_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Sawe gɨ ta di, ɨbɨ mana gɨ nare nə Ejibtɨ bulə day gɨ nare nə Israyel lə sabɨgɨ dodə korgɨn̰ sɨr. Tulɨn̰ dɨ nare nə Ejibtɨ dayyə da, sawe di cor gɨdɨ dilɨm me, tulɨn̰ dɨ nare nə Israyel dayyə da, sawe di cor ácn̰ɨgɨ mana bam gɨ changa. I yande me, changa dɨ ta di dwar̰ɨ lə pad da, nare nə tulɨn̰ dɨ alə ta lə nyama hára kwandagɨ nə ka sɨdəgɨ lə bədə me, nə ka kaw, nem hára alə ta bədə me ca. ");
INSERT INTO sor_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Ɨr̰ɨ Moyis u ɨsəw gɨl ɨjɨ kuray di dalawə mwom da, changa dɨ ta di dwar̰ɨ lə pad Aba dama gɨ dɨrəw bɨr̰ɨn̰ biyə gale gɨ dwana tulɨn̰ dɨ jomniyə me, gale di tojɨ nimi bam ka me, ka me jəgɨ bɨrmə kuray dalawə. ");
INSERT INTO sor_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Mwom da, nare nə Israyel bor ha wayniyə kuray dalawə. Me nimi nə kurayyə di dayar daa ɨsɨragɨ gɨ abeyə me, gɨ jeleyə me, wun ya gər gɨ hoy ta de. ");
INSERT INTO sor_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Nare nə Ejibtɨ ꞌyor nare nə Israyel di taragɨ lə. Leme nənə dole duwa pad me, pus duwa pad me, woni ajila gɨ leme pad me bor ha taragɨ lə kuray dalawə. ");
INSERT INTO sor_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Ɨr̰ɨ gɨ manapɨr da, Aba dama gɨ dɨrəw bɨr̰ɨn̰ gɨ ilə mana gɨ saweyə me dùwa lə me di, kal dɨrəw yər nare nə Ejibtɨ ladɨ me cendi cor kɨjabɨ sɨdəgɨ cendi woni ciri gang. ");
INSERT INTO sor_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Aba dama gɨ dɨrəw bɨr̰ɨn̰ mendɨ pus day di gɨdadɨ bam ɨmdɨ wàa kaláng bam mwom da, cendi sojɨ ba da: «Ay, cwarnandɨ bi, wànandɨ le hən̰ gɨ nare nə Israyel di, dara Aba dama gɨ dɨrəw bɨr̰ɨn̰ di ilə wagɨ lə jara ganandɨ say.» ");
INSERT INTO sor_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: «Yə́ ɨsəm ɨjɨ kuray me, kal nimi nə kurayyə di cwarnay mana dayyə bi layna nare nə Ejibtɨ di me, pus day di me, woni ajila gɨ leme di me bam.» ");
INSERT INTO sor_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Moyis yə́ ɨsəw gɨl ɨjɨ kuray me, mana ba a wal bam ɗɨm da, nimi nə kurayyə di cwara mana dayyə bi. Me nare nə Ejibtɨ woni ꞌywaragɨ di, cwara ba gɨ wà le mwom da, jisgɨ yande, cendi ꞌyo nimi ilə dɨrəgɨ lə me, Aba dama gɨ dɨrəw bɨr̰ɨn̰ nongr̰ɨgɨ bogɨ nimiyə. ");
INSERT INTO sor_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Nimi nə kurayyə di lay pus di me, woni ajila gɨ leme me, asɨngar nənə dole duwa pad me ca. Nare pad nə bor yá kurayyə ꞌyor nare nə Israyel taragɨ lə ta di, nimi laygɨ ꞌyəgɨ bam pad, gun mɨn tenene kaw wor bɨl bədə. ");
INSERT INTO sor_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Me nare nə Israyel da, ha day wayniyə kuray di dalawə me cilangɨw nɨm. Me nimi nə kurayyə di dayar daa ɨsɨragɨ gɨ abeyə me, gɨ jeleyə me, wun ya gər gɨ hoy ta de. ");
INSERT INTO sor_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Wála gɨ ta lə di, Aba dama gɨ dɨrəw bɨr̰ɨn̰ kɨdə nare nə Israyel daa nare nə Ejibtɨ ɨsɨragɨ lə. Mwom da, nare nə Israyel di yər nare nə Ejibtɨ kumbɨ day ꞌya lə mana gɨ kuray bɨwə. ");
INSERT INTO sor_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Mana gɨ ta lə di, nare nə Israyel yər Aba dama gɨ dɨrəw bɨr̰ɨn̰ ɨsəw duwa gaba dwana gɨ an̰ji jər gɨ say gɨ nare nə Ejibtɨ di mwom da, cendi lán̰ɨw me, kal dusɨrəgɨ dɨwə me, Moyis gɨ i aba àlaw giyə di dɨwə me ca. ");
INSERT INTO sor_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Mwom da, Moyis day gɨ nə nare nə Israyel tu diri dɨ idɨ bwaw Aba dama gɨ dɨrəw bɨr̰ɨn̰ sɨwə ba da: «Nə ùr ba nə tu diri bow Aba dama gɨ dɨrəw bɨr̰ɨn̰ di sɨwə, dara an̰ji àla abnani dɨ geche. An̰ji bwaa leme me woni ajilagɨ me kurayyə. ");
INSERT INTO sor_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Aba dama gɨ dɨrəw bɨr̰ɨn̰ da, i dwana ni me, i gun gɨ nə ha tow diri bwaw sɨwə me, dara an̰ji kɨdən daa. An̰ji i Mãr̰ĩ ni, nə ha bwaw sɨwə! An̰ji i Mãr̰ĩ gɨnə aban duwa, nə ha ꞌwagaw gɨ jilay dara gasɨnani duwa. ");
INSERT INTO sor_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Aba dama gɨ dɨrəw bɨr̰ɨn̰ di i aba jara say gaba dwana. Sumɨw da, i Aba dama gɨ dɨrəw bɨr̰ɨn̰! ");
INSERT INTO sor_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","An̰ji nwangr̰a pus dɨ idɨ jara say dɨnə dole gɨ Ejibtɨ duwa me asɨngar duwa pad me bwagɨ kurayyə. Woni jara say duwa woni dwana marbɨ bam mana gɨ kuray gaba Dɨrwa dalawə. ");
INSERT INTO sor_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Ku gɨnə nimi day gobɨ dɨdəgɨ lə, me cendi ɗondɨbɨ dodə nimi gɨndəgɨ lə ya kur̰a de. ");
INSERT INTO sor_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Ɨjɨm Gaba dama gɨ dɨrəm bɨr̰ɨn̰ di, ɨsəm gɨ abe gɨlə dwana duwa. Ɨsəm gɨ abe dɨlan̰a woni mar̰ande dɨma ꞌyágɨ bam. ");
INSERT INTO sor_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Ɨjɨm da, mə i gun gɨ geche ꞌyang, mə ɓugdə woni mar̰ande dɨma bam. Dusi dɨma dɨ swaa di uləgɨ bam ya dùwa ba dɨ ul nɨm gɨ chemde ta de. ");
INSERT INTO sor_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Mə koo gale gɨ geche da, nimi dayara daa mana mɨn me, ku day da, dayara hwaa daa wunə ya gər ta de. Ku di ilə gwaba lə, nimi nə kuray don duwa lə di gemsara daa. ");
INSERT INTO sor_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Woni mar̰ande nin waya ba da: “ꞌYwarnandɨ gandagɨ le taragɨ lə, də hárang ꞌywagɨ le. Də hárang chaba mani day nə ꞌywaa bam ɨsə sɨdəndɨ lə. Də hárang ꞌyágɨ bam gɨ sugɨnəne ɨnda nə sore me ca.” ");
INSERT INTO sor_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Me ɨjɨm Gaba dama gɨ dɨrəm bɨr̰ɨn̰ di, mə koo gale dɨma gɨ geche mana gɨ kurayyə, me kuray di laygɨ me, cendi ɗondɨbɨ dodə nimi nə ɗungeyə ya biri de. ");
INSERT INTO sor_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","I mãr̰ĩ gɨ we me wunɨm ɨjɨm Gaba dama gɨ dɨrəm bɨr̰ɨn̰ di mo? I wi me ladɨ wun mɨnaw jiga ya ɨjɨm de me, gɨ ha bwaw nɨm gɨ jilay mo? Gasɨnani dɨma da, àl lán̰a nan̰e me, mə àl mani nə dan̰a me ca. ");
INSERT INTO sor_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Mə ꞌwoo ɨsəm gɨ abe daa da, sɨn̰a mugdɨ woni mar̰ande nin dodə. ");
INSERT INTO sor_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Gɨ dusi dɨma dɨ lade di, mə ɨndara nare dɨma nə mə kɨdəgɨ daa di dɨrəgɨ lə, dwana dɨma wolgɨ ha gandagɨ mana gɨ lade gɨ wun mɨnaw jiga gɨ mə dam lə di. ");
INSERT INTO sor_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Mana gɨ nare nə sɨn̰a dɨ ɗangə ba gɨ doy gwale gɨ ta di da, lán̰a àlgɨ, sɨdəgɨ sadɨgɨ tag tag. Nare nə Pilisi, lán̰a ɓugdɨgɨ dodə. ");
INSERT INTO sor_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Dolgə nənə nare nə Edom day, lán̰a àlgɨ̀ le me, woni dwana nənə nare nə Mowab day kaw, lán̰a àlgɨ̀ nan̰e me, nare nə Kanan sɨdəgɨ wagɨ nan̰e me ca. ");
INSERT INTO sor_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","I ɨjɨm Gaba dama gɨ dɨrəm bɨr̰ɨn̰ di me, mə àl mani nə dan̰a gɨ ɨsəm gaba dwana me, lán̰a ɓugdɨgɨ nɨm dodə. Cendi kɨdɨ nare nə mɨm nem àla mani mɨn bədə, bɨraa nare dɨma ha cilangɨ bam bá do, nare nə mə kɨdəgɨ daa di ha gɨndəgɨ saw nɨm bam bá do. ");
INSERT INTO sor_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Ɨjɨm Gaba dama gɨ dɨrəm bɨr̰ɨn̰ di, mə ha wàla nare dɨma hára gandagɨ chə́gɨ kur̰a dɨma dɨ sɨm dɨdə, dara cendi ba damna lə. I mana gɨ mə ɗangr̰ɨ dara ba mə dam lə, ɨjɨm gɨ Aba ciri nin. I mana gɨ ta lə di me mə chɨ́ kulu dɨma gɨ mə biyɨw kalɨw jiga di gɨndɨw lə me ca. ");
INSERT INTO sor_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","I sɨdɨ,  Aba dama gɨ dɨrəw bɨr̰ɨn̰ di ha lama dwãr̰ĩ i gɨ dɨrɨn̰ bɨr̰ɨn̰!» ");
INSERT INTO sor_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Mana gɨ leme nənə dole gɨ Ejibtɨ duwa me, pus duwa dɨ idɨ jara say me, nare duwa woni ajila gɨ leme me, ba gɨ bor ya kuray dalawə da, Aba dama gɨ dɨrəw bɨr̰ɨn̰ cwaa nimi nə kurayyə di dɨdəgɨ lə bi. Me nare nə Israyel day da, ha wayniyə cilangɨ gɨ kuray di. ");
INSERT INTO sor_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Ɨr̰ɨ Miriyam dɨ i idɨ cɨmə Mãr̰ĩ bɨw, tandi i Arõ chidɨw, u ban̰jil dɨra daa tu. Me namde nə Israyel pad lay ban̰jil day ɨsɨragɨ lə dɨmə pamdɨ gɨ n̰ar̰a tardɨ lə me ca. ");
INSERT INTO sor_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miriyam ugɨ kwandagɨ diri ba da: «Tunə diri bwanaw Aba dama gɨ dɨrəw bɨr̰ɨn̰ di sɨwə, dara an̰ji àla abnani dɨ geche. An̰ji bwaa leme me woni ajilagɨ me kurayyə.» ");
INSERT INTO sor_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Ɨr̰ɨ Moyis so gɨ nare nə Israyel di daa mana gɨ kuray gaba Dɨrwa di bɨwə me, ha gandagɨ ɨjɨ mana gɨ dɨn dwar̰ɨ dɨ gɨ ꞌwogɨdɨ Chur. Cendi àl wála subu hára lə dɨn dwar̰ɨ lə me, cendi ꞌyo nimi nə chàa bədə. ");
INSERT INTO sor_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Ɨr̰ɨ cendi gɨr mana mɨn gɨ gɨ ꞌwogɨw Mara. Mana gɨ Mara da, nimi ilə me cendi nem chàa gɨ nimi nə ta di bədə, dara nimi di ɗan̰e. I ta di me, gɨ ꞌwogɨ nɨm gɨ mana gɨ ta di «Mara» di, gɨndɨw dɨ biyə da, i «ɗan̰a». ");
INSERT INTO sor_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Mwom da, nare nə Israyel ɓɨr̰ɨn̰ hɨrajɨw Moyis ba da: «Ka da, də hárang chàa i na mo?» ");
INSERT INTO sor_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Ɨr̰ɨ Moyis soy ꞌwogɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ me, an̰ji gɨlɨw habda bɨw mwom da, Moyis u habda bɨw di àl nimi nə ta lə di me, nimi di cor gɨdɨ nə lade. I mana gɨ ta lə di me Aba dama gɨ dɨrəw bɨr̰ɨn̰ ꞌyàgɨ́ nɨm gɨ nare nə Israyel bii gɨ ꞌwoo lə me, mani nə cendi ba àlnagɨ lə me ca. I mana gɨ ta lə di me, an̰ji gɨrsəgɨ dara yara gɨ dusɨrəgɨ dɨ cendi kaldɨ dɨwə di me ca. ");
INSERT INTO sor_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","An̰ji waygɨ ba da: «Anə àlna ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ gɨ nə i Mãr̰ĩ dan di bɨn me, anə àlna mani nə tɨba dɨrənnə me, anə àlna bii ni gɨ ꞌwoo di gɨ bɨrmə duwa ladɨ me, anə àlna mani pad nə nə ɨrməng gandagɨ di gɨ bɨrmə day bá bá me da, mwom gɨ nə bwagɨ nare nə Ejibtɨ ta di, mɨn tenene kaw, nə ha àsang gandɨw bədə bɨr̰ɨn̰. Dara i ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ di me, nə i aba swang daa mwom dannə ɨndi.» ");
INSERT INTO sor_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Ɨr̰ɨ nare nə Israyel di yala mana mɨn gɨ gɨ ꞌwogɨw Elim. Mana gɨ ta lə di nimi gɨndəgɨ swaa lə jiga jiga nem mwaj dii sɨr me, tumbur gɨnɨn̰ wurgɨsubu me ilə. Cendi ɗangr̰ɨ kundi day mana gɨ ta lə di me, damdɨ nɨm lə nimi bɨdəgɨ lə ib ib. ");
INSERT INTO sor_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Ɨr̰ɨ nare nə Israyel pad dayyə cɨmə daa kala mana gɨ Elim di bam gɨra ha dama dɨn dwar̰ɨ dɨ gɨ ꞌwogɨdɨ Sin. Sin di, dam i Elim bulə day gɨ Sinayyə. I gɨ wála mwaj bii jii gɨnə duru gɨ sɨrrə gɨ cendi dɨmə nɨm bam sɨn̰a dɨ Ejibtɨ lə di. ");
INSERT INTO sor_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Mana gɨ dɨn dwar̰ɨ lə di da, nare nə Israyel pad dayyə hɨrajɨgɨ nə Moyis day gɨ Arõ. ");
INSERT INTO sor_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Cendi waygɨ ba da: «Dee Aba dama gɨ dɨrəw bɨr̰ɨn̰ ꞌyánanin bam sɨn̰a dɨ Ejibtɨ lə da, biya. Alə ta di, nə wamanin kabni gɨ ꞌwanba ɓɨsabe daa me mapa me ɨbdənin. Ɨr̰ɨ caga ka da, anə walanin pad ninnə hára nɨm dɨn dwar̰ɨ lə ka dara cherni ba ꞌyánanin bam mo?» ");
INSERT INTO sor_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: «Nə ha ꞌwāa mapa daa siyaya lə bwang dodə me, gɨ wála wála da, wi kaw ha laya nyama wama duwa gɨ wála mɨnnə bá bá. Nə ha àla yande dara gɨrsəng yara gɨ dusɨrəng, dara gaa anə ha pama bii ni gɨ ꞌwoo di labaa, anə ha pamaw bədə mo? ");
INSERT INTO sor_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Me wála gɨ kubiyə da, anə hana dara laya gɨ mapa di da, anə ha layaw nyama wama gaba wála sɨrrə. Anə ha layaw ɗwaya wála gɨ pii piiyə di bam.» ");
INSERT INTO sor_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Ɨr̰ɨ nə Moyis day gɨ Arõ waygɨ nare nə Israyel pad ba da: «Turgɨ dɨ laba lə da, anə ha ꞌwacn̰a dara ba i Aba dama gɨ dɨrəw bɨr̰ɨn̰ di me ba dɨməng bam sɨn̰a dɨ Ejibtɨ lə di an̰ju. ");
INSERT INTO sor_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Me sanga gɨ jomni da, anə ha yara ꞌywagda gɨnə Aba dama gɨ dɨrəw bɨr̰ɨn̰ duwa, dara an̰ji doy hɨraja gɨ anə hɨrajaw di. Dara nenin da, nə nemnin nare na me, anə hɨrajɨnin mo?» ");
INSERT INTO sor_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Moyis waygɨ ba da: «Turgɨ dɨ laba lə da, Aba dama gɨ dɨrəw bɨr̰ɨn̰ di ha ꞌyàng kabni anə ha wama me, sanga gɨ jomni kaw, an̰ji ha ꞌyàng mapa anə ha wama ɨbdə me ca. Əw, hɨraja gɨ anə hɨrajaw di yá ɨndara sumɨwə. Nenin da, nə nemnin nare na me, anə hɨrajɨnin mo? Anə hɨrajɨnin i nenin bədə, me anə hɨrajɨw i Aba dama gɨ dɨrəw bɨr̰ɨn̰.» ");
INSERT INTO sor_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Ɨr̰ɨ Moyis wayɨw Arõ ba da: «Waygɨ nare nə Israyel pad dayyə gɨ chidɨbɨnə daa Aba dama gɨ dɨrəw bɨr̰ɨn̰ di dɨrəwə ib, dara an̰ji dwaya hɨraja gɨ cendi hɨrajɨw di.» ");
INSERT INTO sor_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Mana gɨ Arõ ilə wayagɨ nare nə Israyel pad dayyə gwaleyə da, cendi co dɨrəgɨ ɨjɨ dɨn dwar̰ɨ lə me, jisgɨ yande da, cendi yər ꞌywagda gɨnə Aba dama gɨ dɨrəw bɨr̰ɨn̰ duwa mana gɨ siyaya dalawə. ");
INSERT INTO sor_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: ");
INSERT INTO sor_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","«Nə doy nare nə Israyel hɨraja day gɨ cendi hɨrajɨn di. Ha wayagɨ da: Turgɨ dɨ laba lə da, anə ha wama kabni me, sanga gɨ jomni kaw, anə ha ꞌywaa mapa nan̰ wama ɨbdə me ca. I ta di me, anə ha ꞌwacn̰a dara ɨndi di, ba nə i Aba dama gɨ dɨrən bɨr̰ɨn̰ gɨ nə i Mãr̰ĩ dan di.» ");
INSERT INTO sor_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Gɨ turgɨ da, guy ɓɨr̰ɨn̰ə gɨra bor ꞌyarbar mana gɨ nare nə Israyel dam lə pad, me sanga gɨ jomni da, mana gɨ cendi dam lə di tarɨwə cab cab da, u chichiri ən̰ daa. ");
INSERT INTO sor_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Mana gɨ chichiri di bor bam ɗɨm da, cor mani nə burgədə ɓani hin̰e hin̰e wun ya swagə dɨrəgɨ de wor ilə dodə sɨn̰a lə. ");
INSERT INTO sor_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Mana gɨ nare nə Israyel di ba gɨ yər mani di mwom da, cendi ùrbɨ sɨdəgɨ ba da: «Mani nə ta di, i na yande mo?» Dara cendi ꞌwocn̰ mani di bədə. Ɨr̰ɨ Moyis waygɨ da: «Ta di, i mapa gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ ꞌyàng dara anə banə wamna. ");
INSERT INTO sor_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Dwayna, mani nə Aba dama gɨ dɨrəw bɨr̰ɨn̰ ɨrməng gandagɨ di me, i ta: Layna kal nyamna wama gɨnə gun mɨnnə bá bá. Gun mɨn da, laynaw nyamna ya koro mɨn mɨn de. Gun gaba laya di, a layna ɨrmɨnə gɨ nare nə dam gandɨw kundi dalawə mɨn di gɨr̰ə dayyə.» ");
INSERT INTO sor_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Nare nə Israyel di àl ya ba gɨ ɨrmɨgɨ nɨm de. Nə mɨn lay day nan̰ me, nə yab lay day ɓani me ca. ");
INSERT INTO sor_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Mana gɨ cendi ɨrɨm mani nə cendi layagɨ di da, gun gaba laya nan̰ da, worɨw bɨl dodə bədə, me gun gaba laya ɓani da, wama di jalɨw bədə me ca. Wi kaw lay mana gɨ dwana duwa dɨ idɨ wama lə bá bá. ");
INSERT INTO sor_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Ɨr̰ɨ Moyis waygɨ nare nə Israyel ba da: «Kal gun gamna mani nə wama nə ta di walna daa bədə.» ");
INSERT INTO sor_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Cor nare nə yab yɨ gwale gɨnə Moyis duwa di bədə, me gam mani di wal daa, mwom da, mani di bo dan̰ me ɗo le me ca. Ɨr̰ɨ Moyis dusɨw so dɨdəgɨ lə. ");
INSERT INTO sor_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Gɨ jomni bá bá da, cendi lay nem wama dayyə. Me dawa ən mwom da, mani nə wor dodə sɨn̰a lə di cor lon̰ər bam. ");
INSERT INTO sor_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Me wála gɨ kubiyə da, cendi lay mani di nem wama gaba wála sɨr. Gun mɨn da, cendi layɨw mani di nem ya koro sɨr sɨr de. Mwom da, gechide woni yara nare nə Israyel dɨdəgɨ pad hára gɨra cɨmɨw Moyis daa. ");
INSERT INTO sor_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Me an̰ji cogɨ lə diiyə ba da: «Ta di i mani nə Aba dama gɨ dɨrəw bɨr̰ɨn̰ ɨrməng gandagɨ di ɓag. Dara sanga da, i wála gaba bwaa gwayni, i wála duwa an̰ju. Ɓabdɨna mani nə ùr ɓabda me, hangdɨna mani nə ùr hangda le me ca. Anə wamna me gɨndəgɨ nə wor dodə da, bwanagɨ gamnagɨ dara sanga.» ");
INSERT INTO sor_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Mwom da, cendi gam mani gɨndəgɨ nə wor di bɨraa sanga, ya Moyis ba a wayagɨ nɨm de. Mani di bo dan̰ bədə me, ɗo bədə me ca. ");
INSERT INTO sor_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Ɨr̰ɨ wála gɨ wurgɨsubu lə da,  Moyis waygɨ da: «Mani gɨndəgɨ nə wor nə anə gamgɨ daa di, wamnagɨ laba ɗɨm, dara laba da, i wála gaba bwaa gwayni dara àsaw Aba dama gɨ dɨrəw bɨr̰ɨn̰ di sumi gɨ ꞌwaga dɨwə. Laba da, anə ha ꞌywaa mani nə anə womgɨ di bam iche bədə. ");
INSERT INTO sor_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Wála kubi dalawə da, anə ha laya mani nə anə womgɨ di. Me wála gɨ wurgɨsubu lə da, i wála gaba bwaa gwayni, anə ha ꞌywagɨ bədə.» ");
INSERT INTO sor_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Cor wála gɨ wurgɨsubu lə di, nare nə Israyel nə yab gandɨ ha dara laya gɨ mani nə wama di, me cendi ꞌywaa mani mɨn bədə. ");
INSERT INTO sor_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: «Anə ha gɨn̰ə yəə gɨ bii ni gɨ ꞌwoo me gɨlə ni me bam di, i bɨraa mindi na bá mo? ");
INSERT INTO sor_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Yarna, nə ꞌyàng wála gaba bwaa gwayni di, i dara anə banə bwana gwayni. I dara yande me wála gɨ kubiyə da, nə ꞌyàng mani nə wama gaba wála sɨr. Me wála gɨ wurgɨsubu lə da, wi kaw damna ulay duwa lə. Gun mɨn kaw, dɨmnə iche bədə.» ");
INSERT INTO sor_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","I ta di me, wála gɨ wurgɨsubu lə da, nare nə Israyel dam bo gwayni di. ");
INSERT INTO sor_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Ɨr̰ɨ nare nə Israyel ꞌwogɨw wama gɨ ta di sumɨw «man», gɨndɨw dɨ biyə i «Mani nə ta di, i na yande mo?». Man di wun ya swagə dɨrəgɨ nə burgədə nə ɓani hin̰e hin̰e de. Mə wamnaw da,  ꞌywala duwa wun ya bangaso gɨ gɨ piyɨw gɨ dùmbu ta de. ");
INSERT INTO sor_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Ɨr̰ɨ Moyis waygɨ nare nə Israyel ba da: «Dwayna, mani nə Aba dama gɨ dɨrəw bɨr̰ɨn̰ ɨrməng gandagɨ di me i ta: Ɨrmɨnə man di koro mɨn bwanaw daa gamnagɨ mwàgɨrang, dara ɗan̰ cendi ha yara mapa gɨ nə ꞌyàng anə wama mana gɨ dɨn dwar̰ɨ lə, wála gɨ nə dɨməng nɨm bam sɨn̰a dɨ Ejibtɨ lə di.» ");
INSERT INTO sor_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Moyis wayɨw Arõ ba da: «U ɓɨsa mɨn me, mə lay man di koro mɨn bo lə me, mə ha chə́w Aba dama gɨ dɨrəw bɨr̰ɨn̰ dɨrəwə dara kal warnagɨ dɨndɨrang me mwàgɨrang me ca.» ");
INSERT INTO sor_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Arõ àl mani nə Aba dama gɨ dɨrəw bɨr̰ɨn̰ ɨrmɨw Moyis di. An̰ji u ɓɨsa gɨ man ilə dwalɨn̰yə di ha chə́w mana gɨ sandug dɨnə Mãr̰ĩ duwa dɨ idɨ gama mani woni mɨlan di dɨrədɨ lə dara kal ba gɨ gamnaw lə mana gɨ ta lə di. ");
INSERT INTO sor_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Nare nə Israyel wom man di bam dɨn dwar̰ɨ lə bɨraa dɨməgɨ nɨm sɨn̰a dɨ idɨ dama lə di bá àl aliya gɨnɨn̰ wodɨ. Cendi wom man di bɨraa gɨrgɨ nɨm pale gɨ sɨn̰a dɨ Kanan lə di bá. ");
INSERT INTO sor_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Gun mɨn da, gɨ ɨrmɨw man di le gɨ koro mɨn bá bá. Koro dɨ ta di, gɨ ꞌwogɨdɨ gɨ bii gɨ ebɨrə «omer» me, omer dalaw mwaj da, u i «epa» dalaw mɨn. ");
INSERT INTO sor_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Ɨr̰ɨ nare nə Israyel pad dayyə kal dɨn dwar̰ɨ dɨ Sin di bam cɨmgɨ hargɨ pii pii mana gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ bɨw gɨ ɨrmɨgɨ nɨm lə di bá bá. Wála mɨn, cendi ha gɨra ɗangr̰a mana day gaba dama mana mɨn gɨ gɨ ꞌwogɨw Repidim. Me mana gɨ ta lə di, cendi ꞌyo nimi nə chàa bədə. ");
INSERT INTO sor_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Mwom da, cendi nasɨ gɨ Moyis wayɨw ba da: «ꞌyànin nimi nə chə̀ninne!» Me an̰ji cogɨ lə diiyə ba da: «Dana me anə nasɨbɨ gandɨn yande mo? Anə gɨrsə Aba dama gɨ dɨrəw bɨr̰ɨn̰ dana mo?» ");
INSERT INTO sor_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Me nare nə Israyel di, machè àlgɨ̀ nan̰e me, cendi àlɨ́w Moyis gwale ba da: «Mə cɨmənin daa sɨn̰a dɨ Ejibtɨ lə di dana mo? Mə ùr dara nenin me, dɨndɨranin me, mani nin nə paga me da, machè ba ꞌyánanin bam pad mo?» ");
INSERT INTO sor_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Ɨr̰ɨ Moyis soy ꞌwogɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ ba da: «Nare nə Israyel di da, nə ha àlagɨ́ i man mo? Wor ib da, cendi ha jaran gɨ kur̰a ꞌyán i bam.» ");
INSERT INTO sor_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Me Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: «Wol nare nə Israyel nə dɨrəgɨ nagdɨ yab gandɨm me, ɨndər nare nə Israyel di dɨrəgɨ lə. U cilang dɨma gɨ mə awra gɨ nimi nə kuray gɨ Nil di daa ɨsəmmə, me bwarna hana. ");
INSERT INTO sor_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Me ɨndi da, nə ha ɗɨbə lə alə dɨrəmmə pii kur̰a dɨ gɨ ꞌwogɨdɨ Horeb dɨdə. Mə gɨra ha awra kur̰a di me, nimi ha ganda mana gɨ kur̰a lə di mwom da, nare nə pad ta di ha chàa.» Me Moyis àl mani nə Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw gandagɨ di mana gɨ nare nə Israyel nə dɨrəgɨ nagdɨ di dɨrəgɨ lə. ");
INSERT INTO sor_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Mwom da, an̰ji ꞌwogɨw mana gɨ ta di sumɨw «Masa» me «Meriba» me. Masa di, gɨ bii dayyə da, gɨndɨw dɨ biyə i «Gɨrsə» me, Meriba da, i «nasa» me ca. Dara nare nə Israyel di nasa gɨ Moyis me, gɨrsə Aba dama gɨ dɨrəw bɨr̰ɨn̰ me ca. Cendi way ba da: «Aba dama gɨ dɨrəw bɨr̰ɨn̰ di, ilə dwar̰andɨ lə labaa, ilə bədə mo?» ");
INSERT INTO sor_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Wála mɨn, nare nə Amalek hára jər say gɨ nare nə Israyel mana gɨ Repidim. ");
INSERT INTO sor_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Mwom da, Moyis ꞌwogɨ Josuwe me wayɨw ba da: «An̰jirɨndɨ abje woni dwana woni jara say kwandagɨ dwar̰agɨ lə me, mə gandɨ ha jara say gɨ nare nə Amalek. Me ɨndi da, sanga nə ha hára naga ɗɨbə daa kur̰a dɨdə gɨ cilang gɨnə Mãr̰ĩ di ɨsənnə.» ");
INSERT INTO sor_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Josuwe àl mani nə Moyis wayɨw gandagɨ di. An̰ji gandɨ ha jara say gɨ nare nə Amalek. Me Moyis me Arõ me Hur me da, nagɨ day ha daa kur̰a dɨdə. ");
INSERT INTO sor_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Mana gɨ Moyis unə ɨsəw daa da, nare nə Israyel àl dwana nan̰. Me mana gɨ an̰ji àsɨna ɨsəw di dodə da, i nare nə Amalek me àl dwana nan̰ cendi. ");
INSERT INTO sor_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Moyis di dar̰ɨn̰jaw cor maru mwom da, Arõ day gɨ Hur ꞌwoo kur̰a àsɨw me, an̰ji dam kur̰a di dɨdə. Arõ yɨ dar̰aw mɨn daa me, Hur kaw yɨ duwa dɨ mɨn daa me ca. Cendi yɨbɨ dar̰ɨn̰jaw di daa bɨraa dawa ɗondɨ nɨm bá. ");
INSERT INTO sor_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Me Josuwe àla abnani ꞌyáa nare nə Amalek bam gɨ sugɨnəne nə sore. ");
INSERT INTO sor_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: «Jangɨ mani nə àlal ta di dodə maktubu lə gam daa, dara kal nare nɨmnəgɨ bam bədə. Me mə wayɨw Josuwe ba nə ha myanda nare nə Amalek bam gɨ dɨrɨn̰ bɨr̰ɨn̰. Sɨn̰a dɨdə ka da, gun mɨn kaw dusɨw ha gow daa dɨdəgɨ lə bədə ɗɨm.» ");
INSERT INTO sor_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Ɨr̰ɨ Moyis aw mana gaba bwasa Mãr̰ĩ mana gɨ ta lə di, me ꞌwogɨw sumɨw ba: «Aba dama gɨ dɨrəw bɨr̰ɨn̰ ꞌyàn bɨrmə nə àla abnani.» ");
INSERT INTO sor_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Me an̰ji way ɗang ba da: «Nare nə Amalek swaa gɨ say gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ di, yande da, Aba dama gɨ dɨrəw bɨr̰ɨn̰ ha jara gandagɨ le gɨ swaa day bá bá gɨ dɨrɨn̰ bɨr̰ɨn̰.» ");
INSERT INTO sor_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Ɨr̰ɨ Jetɨro gɨnə Moyis dyaməw abadɨ gɨ i aba bwasa Mãr̰ĩ mana gɨ sɨn̰a dɨ Madiyannə doy mani nə Mãr̰ĩ àlgɨ̀ pad dara waw gɨ Moyis lə me, wagɨ gɨ nare nə Israyel nə i nare duwa di lə me. An̰ji doy dara ba i man me Aba dama gɨ dɨrəw bɨr̰ɨn̰ ba dɨmə nare nə Israyel bam sɨn̰a dɨ Ejibtɨ lə mo? ");
INSERT INTO sor_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Mwom da, an̰ji wala durməw dɨ Sepora dɨ Moyis udɨ deme di hára gandɨdɨ. Tandi, tanga Moyis codɨ ꞌwò abadɨ sɨwə. ");
INSERT INTO sor_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","An̰ji wàla Sepora dɨndadɨ nə sɨr di daa me ca. Dine nə sɨr di, Moyis ꞌwogɨw gɨ man̰jɨli sumɨw Gerchom, gɨ bii dayyə da, gɨndɨw dɨ biyə i «mɨje». An̰ji ꞌwogɨw yande dara an̰ji way ba i mɨje gɨ ba yala dam i sɨn̰a dɨ nare dayyə. ");
INSERT INTO sor_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Me aba tarɨw da, an̰ji ꞌwogɨw sumɨw Eliyejer, gɨndɨw dɨ biyə i «Mãr̰ĩ ni i aba wannə». An̰ji way ba da: «Mãr̰ĩ gɨnə aban duwa gɨra wannə kɨdən daa dole gɨ Ejibtɨ sugɨnə duwa dɨ chere bɨdə.» ");
INSERT INTO sor_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Jetɨro wol dine nə sɨr di me, durməw dɨ Moyis dyaməw di me, ha gandagɨ ꞌywaa gɨ Moyis mana gɨ dɨn dwar̰ɨ dɨ i kur̰a dɨnə Mãr̰ĩ duwa tuldɨ lə ib, mana gɨ Moyis dam lə di. ");
INSERT INTO sor_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Jetɨro giy ha wayaw Moyis ba da: «I ɨndi mwám gɨ Jetɨro di. Nə yalam gɨ dyam me dɨndadɨ nə sɨr di me ca.» ");
INSERT INTO sor_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Mwom da, Moyis dɨmə hára ꞌyo mwáw di me, piy gubɨrəw dodə dɨrəwə me, jirmɨw yɨw nɨm sɨwə. Ɨr̰ɨ wi kaw ùr jaw labiya duwa, labiya duwa mwom da, cendi dɨm ha kundi gɨnə Moyis duwa dalawə. ");
INSERT INTO sor_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Ɨr̰ɨ Moyis kɨbɨw mwáw di mani pad nə Aba dama gɨ dɨrəw bɨr̰ɨn̰ àláw dole gɨ Ejibtɨ me, àlagɨ́ nare nə Ejibtɨ me, dara nare nə Israyel di. An̰ji kɨbɨw wamani pad gɨ ba gɨ ꞌywaw hára lə bɨrmə lə, me ba i gɨ bɨrmə gɨ man me, Aba dama gɨ dɨrəw bɨr̰ɨn̰ ba kɨdəgɨ nɨm daa di mo? ");
INSERT INTO sor_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Jetɨro sɨw ꞌyolɨw nan̰e dara ladni gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ àla gɨ nare nə Israyel kɨdəgɨ nɨm daa nare nə Ejibtɨ ɨsɨragɨ lə di. ");
INSERT INTO sor_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","An̰ji way ba da: «Kal Aba dama gɨ dɨrəw bɨr̰ɨn̰ gaba kɨdəng daa kwaynaniyə dole gɨ Ejibtɨ ɨsəwə me, nare nə Ejibtɨ ɨsɨragɨ lə me di, sumɨw ꞌwagɨna! ");
INSERT INTO sor_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Caga ka da, nə ꞌwocn̰ dara Aba dama gɨ dɨrəw bɨr̰ɨn̰ di gasɨnani duwa ɗoy domde nə nare bosɨgɨ ɨrmɨgɨ mãr̰ĩ day bam pad. An̰ji gɨləgɨ nare nə Ejibtɨ gasɨnani duwa di wála gɨ cendi gɨləgɨ gɨ nare nə Israyel dɨrəgɨ lə di.» ");
INSERT INTO sor_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Ɨr̰ɨ Jetɨro gɨnə Moyis mwáw di, u mani woni ulə àláw gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ di sarga me woni bwasaw nɨm me. Arõ day gɨ nə nare nə Israyel nə dɨrəgɨ nagdɨ hára wom mani nə bwasa di gɨ Jetɨro gɨnə Moyis mwáw di mɨn Mãr̰ĩ dɨrəwə. ");
INSERT INTO sor_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Sanga dɨra da, Moyis dam ilə àlagɨ́ nare nə Israyel sariya lə. Me nare nə Israyel di dam gɨ jomni bɨraa turgɨ bá, ɓedɨ dara ba gɨ hára dɨrəwə. ");
INSERT INTO sor_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Mana gɨ Moyis mwáw di yər wamani gɨ Moyis ꞌyow dara nare nə Israyel dɨdəgɨ di mwom da, an̰ji wayɨw Moyis ba da: «Mə àl giyə dɨma di i man yande dara nare di mo? Mə dam gasɨnaniyə di mɨnam mɨn tenene dana me, nare nə pad ta di hára ꞌyarbar dɨrəmmə ɗɨbɨ ɓedɨm gɨ jomni bɨraa turgɨ bá yande dana mo?» ");
INSERT INTO sor_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Moyis cow lə diiyə ba da: «Nare di hára ꞌyon dara Mãr̰ĩ ba waynagɨ i gwale. ");
INSERT INTO sor_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Mana gɨ nare di ꞌywana gwale lə bulə dayyə da, cendi hára ꞌyon mwom da, nə agɨ gwale day di me, nə gɨlgɨ bii gɨ ꞌwoo gɨnə Mãr̰ĩ duwa me, nə gɨlgɨ mani nə Mãr̰ĩ ɨrməgɨ di bá bá me ca.» ");
INSERT INTO sor_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Cor Moyis mwáw di wayɨw ba da: «Mani nə mə àlgɨ̀ ta di, ladɨ bədə. ");
INSERT INTO sor_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Mə àl yande ta di, dwana dɨma ha ꞌyan̰a i bam me, nare nə ilə gandɨm di kaw, dwana day ha ꞌyan̰a i bam me ca. Dara giyə gɨ mə ilə àlàwə ta di wom nan̰e. Mɨnam mɨn da, mə ha nyama àlàw ꞌyan̰a lada bədə. ");
INSERT INTO sor_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Caga da, doy, nə ilə gɨsəmmə, me kal Mãr̰ĩ ina lə gandɨm. Ɨjɨm da, ɗɨbɨ nare nə Israyel di dɨrəgɨ lə, me mə wayɨw Mãr̰ĩ gwale day. ");
INSERT INTO sor_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Mə ha gɨləgɨ bii gɨ ꞌwoo gɨnə Mãr̰ĩ duwa me, mani nə Mãr̰ĩ ɨrməgɨ di bá bá me ca. Mə ha gɨləgɨ bɨrmə gɨ cendi ha ꞌwów me mani nə àla nə lade me ca. ");
INSERT INTO sor_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Ɗang da, mə an̰jir abje nə nem àla mani me, nə lán̰ɨw Mãr̰ĩ me, nare sɨdəgɨ nə tɨba me, woni ùrə gun ba ꞌyànagɨ́ gursɨ dara ba myandɨnaw gɨ gwale bam bədə me ca. Nare nə ya ta de di, mə ha chɨ́gdəgɨ gechide nənə nare nə sabar dodə nem dubu me, nə nem aru me, nə nem gɨnɨn̰ jii me, nə nem mwaj day me ca. ");
INSERT INTO sor_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Cendi ha agɨ nare nə Israyel di sariya gɨ wála wála cendi. Me gwale gɨ wome da, gɨ hane nɨm dɨrəmmə ɨjɨm, me gwale gɨ wome bədə da, gɨ ɗangr̰ɨnaw cendi. I yande me, giyə di ha hɨbalam daa sɨn̰, dara cendi um giyə gɨ yab bam. ");
INSERT INTO sor_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Mə àlna yande me, Mãr̰ĩ ùrnə me da, mə ha ꞌywaa dwana dɨ idɨ àla giyə dɨma di ladɨ, me nare nə pad ta di kaw, ha cwara hára ulay dayyə gɨ labiya me ca.» ");
INSERT INTO sor_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Moyis yɨ gɨsəni gɨnə dyaməw abadɨ duwa di me, àl mani pad nə an̰ji wayɨw di me ca. ");
INSERT INTO sor_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","An̰ji an̰jir abje nə nem àla mani mana gɨ nare nə Israyel dwar̰agɨ lə pad, me chɨ́gdɨgɨ gechide nənə nare nə sabar dodə nem nare dubu me, nə nem aru me, nə nem gɨnɨn̰ jii me, nə nem mwaj me di day me ca. ");
INSERT INTO sor_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Gechide nə ta di, agɨ nare sariya le gɨ wála wála. Gwale gɨ wome da, cendi háraw gɨ Moyis me, gɨ wome bədə da, a sariya duwa cendi me ca. ");
INSERT INTO sor_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Ɨr̰ɨ Moyis kalɨw dyaməw abadɨ di bɨrmə, an̰ji cor ha ulay sɨn̰a duwa lə bi. ");
INSERT INTO sor_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Ɨr̰ɨ nare nə Israyel cɨm kal mana gɨ gɨ ꞌwogɨw Repidim di bam. Duru gɨ subu gɨ cendi dɨmə nɨm bam sɨn̰a dɨ Ejibtɨ lə wála duwa gɨ mɨnnə da, cendi gɨra ha dama dɨn dɨ gɨ ꞌwogɨdɨ Sinayyə. Cendi ɗangr̰ɨ kundi day mana gɨ kur̰a dɨrədɨ lə tɨba me dam nɨm lə dɨn di dwar̰ɨ lə. ");
INSERT INTO sor_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Ɨr̰ɨ Moyis ilə naga lə dara hára daa kur̰a dɨdə ꞌywaa Mãr̰ĩ mwom da, Aba dama gɨ dɨrəw bɨr̰ɨn̰ ꞌwagaw daa kur̰a dɨdə di me wayɨw ba da: «Doy, gwale gɨ mə ha wayagɨ nare nə Israyel nə i Jakob mwàgɨraw di me i ta: ");
INSERT INTO sor_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Anə yara mani nə nə àlagɨ̀ mana gɨ sɨn̰a də Ejibtɨ lə di gɨ dɨrəng dan. Nə àla i man me, nə layang nɨm daa bajɨmannə ya dugɨr̰i ba dɨ lay gɨ dɨndadɨ de, hára nɨm sɨnnə ka di. ");
INSERT INTO sor_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Caga ka di, anə yɨnə gwale ni àlna gɨ giyə me, anə ɗɨbɨnə mana gɨ mɨlan dɨ nə yɨ gandang di lə jang me da, anə ha lada le dɨrənnə mana gɨ nare nə gɨndəgɨ wor pad di dwar̰agɨ lə. Sɨn̰a dɨdɨ ka pad da, i ni ɨndi, ");
INSERT INTO sor_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","me ꞌyeni pad dannə da, anə ha ꞌya i woni bwasan ɨndi gɨ Mãr̰ĩ me, anə ha ꞌya i nare ni nə nə biygɨ kalgɨ mɨ́ndagɨ jiga me ca. Ta di me i gwale gɨ mə ha wayagɨ nare nə Israyel di.» ");
INSERT INTO sor_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Ɨr̰ɨ Moyis cwara hára mana day gɨ dama lə di bi, me ꞌwaga nare nə Israyel nə dɨrəgɨ nagdɨ me cɨmgɨ gwale gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayaw gandɨw di daa pad. ");
INSERT INTO sor_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Nare nə Israyel di pad, dáy bɨdəgɨ mɨn way ba da: «Əw, mani pad nə Aba dama gɨ dɨrəw bɨr̰ɨn̰ waynin gandagɨ di, nə hanin àlagɨ̀ le.» Mwom da, Moyis ha cɨməw Aba dama gɨ dɨrəw bɨr̰ɨn̰ gwale gɨ nare nə Israyel cow lə diiyə di. ");
INSERT INTO sor_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Me Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: «Doy, nə hára lə gɨ sɨn ni ꞌywam mana gɨ sawe gɨ nan̰ dalawə waya gandɨm gwale, dara kal nare di dwayna gwale gɨ nə ha wayam di. Mwom da, cendi ha kala dusɨrəgɨ dɨmmə ɨjɨm me ca gɨ dɨrɨn̰ bɨr̰ɨn̰.» Ɨr̰ɨ Moyis cwara hára cɨmɨw Aba dama gɨ dɨrəw bɨr̰ɨn̰ gwale gɨnə nare nə Israyel day di. ");
INSERT INTO sor_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: «Cor ha wayagɨ nare nə Israyel di kalgɨ gɨ ɗangr̰ɨna sɨdəgɨ wunnə mɨ́ndagɨ jiga laba me, sanga me, gɨ wiyna barge day bam me ca. ");
INSERT INTO sor_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Kalgɨ gɨ ɗangr̰ɨna sɨdəgɨ dara sanga dɨ ta dɨra da, nə ha chə́ə hára lə mana gɨ kur̰a dɨ Sinay dɨdə, nare nə Israyel dɨrəgɨ lə pad. ");
INSERT INTO sor_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Me mə ha jàgɨ mana kur̰a tardɨ lə liwdɨ daa, me mə ha wayagɨ da: Àsɨna angal dan ladɨ le! Kal gun nagɨna kur̰a dɨ ta di dɨdə bədə me, a chidɨnə sɨdə ib ɓɨlnədɨ bədə me ca. Gun gɨ ɓɨlnədɨ da, an̰ji ùr i ꞌyáa gɨ bam. ");
INSERT INTO sor_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Gun gɨ ta di, ꞌyáa duwa da, gun ɓɨlnəw gɨ ɨsəw bədə. Gɨ jarnaw gɨ kur̰a labaa, gɨ usɨr̰ɨnəw gɨ ɗeche ꞌyánaw nɨm. Ina i mani nə paga labaa, gun gɨ gɨsage kaw, gɨ kalnaw daa bədə. Me i dawa dɨ pɨdɨm dara nɨmə bá do me, nare nə yab ha naga hára daa kur̰a dɨdə di sɨn̰.» ");
INSERT INTO sor_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Ɨr̰ɨ Moyis chə́ə daa kur̰a lə di hára ꞌyo nare nə Israyel di me, waygɨ cendi ba ɗangr̰ɨna sɨdəgɨ wunnə mɨ́ndagɨ jiga me, cendi ba wiyna barge day bam me ca. ");
INSERT INTO sor_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Me an̰ji waygɨ ba da: «Ɗangr̰ɨna sɨdənge dara sanga dɨ ta di me, kalna ꞌya gɨ namdang ɗi me ca!» ");
INSERT INTO sor_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Ɨr̰ɨ sanga dɨ ta dɨra gɨ jomni da, mãr̰ĩ ɨr̰ɨn̰jɨ me, wur̰ɨn̰jɨ me, sawe gɨ geche mu kur̰a daa me, gɨ doy pɨdɨm nɨmə dɨra gɨ dwana. Mwom da, nare nə Israyel pad nə dam mana gɨ ta lə di sɨdəgɨ sadɨgɨ, dara lán̰a àlgɨ̀ le. ");
INSERT INTO sor_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Moyis dɨmə gɨ nare nə Israyel di bam mana day gɨ dama lə, ha gandagɨ dara hára ꞌywaa Mãr̰ĩ. Cendi hára gɨra ɗɨbɨ dodə kur̰a gɨndɨdɨ lə bam hin̰e. ");
INSERT INTO sor_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Mwom da, kur̰a dɨ Sinay di, sawe mudɨ daa dara Aba dama gɨ dɨrəw bɨr̰ɨn̰ di chə́ə yala dɨbə lə dɨdə, dùwa dwar̰ɨ lə. Sawe gɨ ta di wun ya dùwa ba dɨ ur̰ɨ nɨm mana gaba wáa dirɨngəl lə me sawe dɨra gandɨ daa de. Me kur̰a di sɨdɨ dɨra pad gɨgdər daa gɨ dwana. ");
INSERT INTO sor_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Pɨdɨm di ilə nɨmə lə nan̰ nan̰, me mana gɨ Moyis waynaw Mãr̰ĩ gwale da, Mãr̰ĩ kaw cow lə diiyə gɨ ɨr̰ɨn̰jə me ca. ");
INSERT INTO sor_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Aba dama gɨ dɨrəw bɨr̰ɨn̰ chə́ə hára ɗɨbə kur̰a dɨ Sinay dɨdɨ dɨ daa lə, me ꞌwogɨ Moyis ba hana, me Moyis nagɨ ha. ");
INSERT INTO sor_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: «Chɨ́ cor ha dodə bi, mə ha wayagɨ nare nə Israyel di, kalgɨ gɨ ꞌywalmɨnay hane sɨnnə dara yaran bədə. Cendi ꞌywalmɨnay hane da, nare nan̰ dwar̰agɨ lə ha mara le. ");
INSERT INTO sor_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Ina i woni bwasa Mãr̰ĩ kaw, kalgɨ gɨ ɗangr̰ɨna sɨdəgɨ wunnə mɨ́ndagɨ jiga do, pəgɨn̰ bədə da, ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ di, nə ha ꞌyágɨ le me ca.» ");
INSERT INTO sor_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Moyis wayɨw Aba dama gɨ dɨrəw bɨr̰ɨn̰ ba da: «Nare nə Israyel di ha naga hára daa kur̰a dɨ Sinay di dɨdə bədə. Dara i ɨjɨm gɨ sɨm dɨma me mə u bɨm waynin daa ba nə jànanin mana liwnə kur̰a di daa me, ba nə yarnadɨnin nɨm ba wun i mɨnadɨ jiga me ca.» ");
INSERT INTO sor_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: «Chɨ́ ha dodə bi, me nagɨnay hane dan gɨ Arõ ca. Me woni bwasa Mãr̰ĩ me nare nə Israyel di me da, kalgɨ gɨ ꞌywalmɨnay hane dara yaran ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ di bədə. Cendi ꞌywalmɨnay hane da, nə ha ꞌyágɨ le.» ");
INSERT INTO sor_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Ɨr̰ɨ Moyis chə́ə hára bi ꞌyo nare nə Israyel di me waygɨ gwale gɨ ta di. ");
INSERT INTO sor_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Me gwale gɨ Mãr̰ĩ waygɨ nare nə Israyel di me i ta: ");
INSERT INTO sor_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","«Ɨndi di, nə i Aba dama gɨ dɨrən bɨr̰ɨn̰ gɨ nə i Mãr̰ĩ dan di. I ɨndi di me nə dɨməng bam sɨn̰a dɨ Ejibtɨ lə dɨ tanga anə àla kwaynani lə di. ");
INSERT INTO sor_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Anə ha hɨrwə dwama ɨrməw mãr̰ĩ dara ɓaman nɨm bədə. ");
INSERT INTO sor_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Anə ha ɗangr̰a mani nə daa siyaya lə dúndɨrəgɨ labaa, nə dodə sɨn̰a dɨdə dúndɨrəgɨ labaa, nə nimiyə dúndɨrəgɨ gɨdəgɨ dwama dan bədə. ");
INSERT INTO sor_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Anə ha piyə gubɨrəng dodə mani nə ta di dɨrəgɨ lə mɨlawdagɨ bədə, dara ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ gɨ nə i Mãr̰ĩ dan di, nə i aba halgɨni. Gun gɨ àlna mani nə hana lə bədə dɨrənnə da, nə ha àsaw wamani dɨwə. Me wamani gɨ ta di ha pama aba gɨn̰ən bam di bɨraa mage duwa nə dii subu lə labaa, nə dii wodɨ lə bá. ");
INSERT INTO sor_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Me gun gɨ ùrnən me unə bii ni gɨ ꞌwoo di àlna gandɨw giyə me da, nə ha àla gandɨw ladni me, ladni dɨ ta di ha pama mage duwa bɨraa hára nə dubu lə bá. ");
INSERT INTO sor_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ gɨ nə i Mãr̰ĩ dan di, anə ha kubə sumɨn dodə yag yag bədə. Gun gɨ kubɨnə sumɨn dodə yag yag da, nə ha kalaw pəgɨn̰ bədə. ");
INSERT INTO sor_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Kalna ɨrmə dan mana gɨ wála gaba bwaa gwayni dɨwə. Biynəw kalnan gandɨw gɨ dɨrəw jiga ɨndi gɨ Mãr̰ĩ. ");
INSERT INTO sor_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","I wála kubi dalawə me anə ha àla giyə dan lə pad. ");
INSERT INTO sor_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Ɗɨm da, wála gɨ wurgɨsubu lə da, i wála gaba bwaa gwayni gɨ nə àlɨw wun mɨnaw jiga: i wála ni dara àsan ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ gɨ nə i Mãr̰ĩ dan di sumi gɨ ꞌwaga dɨnnə di. Wála gɨ ta di dalawə da, gun mɨn tenene àlna giyə bədə: Ɨjɨm me, gorndɨm me, durməm me, kwaya dɨma me, kóy dɨma me, mani dɨma nə paga me, gun gɨ gɨndɨw i Israyel bədə gɨ dam ciri gandang me da, gun mɨn tenene àlna giyə bədə. ");
INSERT INTO sor_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Dara i wála kubi dalawə me ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ di nə àsɨ daa me, sɨn̰a me, kuray me, nə bo nɨm gɨ mani pad nə ilə dwar̰agɨ lə di me ca. Ɨr̰ɨ wála gɨ wurgɨsubu lə da, nə hoy giyə ni di. I ta di me, wála gaba bwaa gwayni da, ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ di, nə biy bɨn wála gaba bwaa gwayni di dɨwə, nə biyɨw kalɨw gɨ dɨrəw jiga: i wála ni ɨndi. ");
INSERT INTO sor_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Àlgɨ nə abam day gɨ im horɨmbə do me, mə ha dama sɨn̰a dɨ ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ gɨ nə i Mãr̰ĩ dɨma di nə ha ꞌyàm gandɨdɨ di dɨdə tarɨm ha yāa sɨn̰. ");
INSERT INTO sor_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Mə ha ꞌyáa gun gɨ ùrə dɨma bədə. ");
INSERT INTO sor_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Mə ha kan̰ja gun dyaməw bədə. ");
INSERT INTO sor_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Mə ha mĩyə gun mani duwa bədə. ");
INSERT INTO sor_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Mə ha sawa gwale àsaw jam gun dɨwə bədə. ");
INSERT INTO sor_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Kal dɨrəm mana gɨ ciri dɨnə jam gun duwa dɨdə bədə me, deme dɨnə jam gun duwa dɨdə bədə me, kwaya duwa dɨwə bədə me, kóy duwa dɨdə bədə me, labe duwa dɨwə bədə me, kura duwa dɨdə bədə me. Kal dɨrəm mana gɨ mani duwa nə ꞌywaa mɨn tenene dɨdəgɨ lə bədə.» ");
INSERT INTO sor_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Ɨr̰ɨ nare nə Israyel pad doy ɨr̰ɨn̰jɨ gɨnə mãr̰ĩ duwa di me, pɨdɨm nɨmə dɨra gɨ nan̰ nan̰ di me. Cendi yər wur̰ɨn̰jɨ gɨnə mãr̰ĩ duwa me, sawe mu kur̰a di daa gwam. Me mana gɨ cendi yər mani nə ta di mwom da, sɨdəgɨ sadɨgɨ, dara lán̰a àlgɨ̀ le, cendi ɗɨbɨ bam hən̰ gɨ kur̰a di. ");
INSERT INTO sor_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Cendi wayɨw Moyis ba da: «Waynin gwale di ɨjɨm me nə hanin yəə gwale di àla gɨ giyə. Dara ina i Mãr̰ĩ sɨw duwa bɨr̰ɨn̰ me waynanin gwale da, nə hanin mara le.» ");
INSERT INTO sor_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Me Moyis waygɨ ba da: «Lán̰ɨna bədə! Mãr̰ĩ hára i dara gɨrsəng yara gɨ dusɨrəng. Kal anə banə lán̰ɨnawe me anə banə àlna àcn̰a bədə.» ");
INSERT INTO sor_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Mwom da, nare nə Israyel pad ɗɨbə bam hən̰, ɨr̰ɨ Moyis duwa da, chidə hára dilɨm dɨnə sawe duwa dɨ Mãr̰ĩ ɗɨbɨ lə dwalɨn̰yə di sɨdə ib. ");
INSERT INTO sor_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: «Doy, gwale gɨ mə ha wayagɨ nare nə Israyel di me i ta: Nə wayang gwale daa siyaya lə, anə dwaya. ");
INSERT INTO sor_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Anə ha ɗangr̰a domde gɨ tuda labaa gɨ jindar dara bwasagɨ ɓaman nɨm ɨndi bədə. ");
INSERT INTO sor_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Me anə ha ɗangr̰a mana gaba bwasan gɨ jirbe dara ulə gɨ mani nə paga nə dine me, nə gechide me bwasan nɨm, me dara àlan gɨ sarga dɨ idɨ labiya lə me ca. Mana gɨ we weyə gɨ nə gɨlnəng gandɨw dara anə banə hɨrwɨnən lə da, nə ha hára lə ꞌywang me, nə ha biyə bɨn dɨdəngə me. ");
INSERT INTO sor_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Anə awna mana gaba bwasan di gɨ kur̰a da, pɨlnə kur̰a di ɗangr̰ɨnadɨ le bədə. Dara mani nə anə pɨldɨ ɗangr̰ɨdɨ nɨm di, codɨ i kur̰a dɨ idɨ awa gɨ mana ni bədə ɗɨm. ");
INSERT INTO sor_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Anə ɗangr̰ɨna mana gaba bwasan da, awnaw hwana daa nan̰ bədə, dara kal gun nagɨna le do me hana nɨm lə sɨn̰ bədə. Gun di gɨndɨw ha wara pɨden̰yə.» ");
INSERT INTO sor_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ɗang bi ba da: «Doy, bii gɨ ꞌwoo gɨ mə ha cɨməgɨ nare nə Israyel di me i ta: ");
INSERT INTO sor_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Gun gɨ kɨlnə kwaya gɨ gɨndɨw i gun gɨ Ebɨrə da, an̰ji ha àla giyə gɨ kwaynani di bɨraa aliya kubi. Me aliya gɨ wurgɨsubu lə da, an̰ji ha dɨmə bam kwaynaniyə di pəgɨn̰ me, ha ùrəw i ꞌywaga gɨ mani bá dara kɨdə gɨ sɨw bədə. ");
INSERT INTO sor_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Kwaya di ina i gun gɨ dyaməw ina lə bədə me hane àlna nɨm gɨ giyə gɨ kwaynani di da, an̰ji ha dɨmə bam kwaynaniyə di mɨnaw duwa. Me an̰ji ina i gun gɨ dyaməw ina lə me hane àlna nɨm gɨ giyə gɨ kwaynani di da, an̰ji ha dɨmə bam kwaynaniyə di day gɨ dyaməw di ca. ");
INSERT INTO sor_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Ina i kwaya di aba ciri duwa me unəw deme an̰ju me deme di yànaw dine nə abje labaa nə namde da, deme di me dine di me, ha waraw i aba ciri duwa di. Ɨr̰ɨ kwaya di ha dɨmə bam kwaynaniyə di mɨnaw duwa. ");
INSERT INTO sor_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Me kwaya di wayna da: “Aba ciri ni di me, dyaman di, me dɨndan di me, nə ùrgɨ le, nə ùr ba nə dɨm bam kwaynaniyə di mɨnan ni bədə” da, ");
INSERT INTO sor_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","aba ciri duwa di ha hára gandɨw Mãr̰ĩ dɨrəwə, me ha hára gandɨw kulu duwa bɨwə ib me ca. Mana gɨ kulu bɨwə di, aba ciri duwa ha ꞌwoo biri gɨ bɨw cobɨ me ha gow gɨ sumɨw bam. Yande mwom da, kwaya di ha dama gɨ aba ciri duwa di gɨ dɨrɨn̰ bɨr̰ɨn̰. ");
INSERT INTO sor_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Gun gɨ ꞌyàna durməw gɨ kɨlnədɨ dara ba àlna kwaynani da, tandi ɗan̰ ha dɨmə bam kwaynaniyə di ya kòy nə abje ba gɨ dɨm nɨm bam kwaynaniyə de bədə. ");
INSERT INTO sor_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Me aba ciri dɨra di kɨlnədɨ dara gɨdədɨ dyaməw me tandi gɨra ꞌywalnaw bədə da, an̰ji ha cwaw gandɨdɨ abadɨ dara ba kɨdɨnədɨ daa bi. Aba ciri dɨra di ha nyama ꞌyàw gandɨdɨ gun gɨ gɨndɨw i mɨje dara ba kɨlnədɨ bədə. An̰ji àlna yande da, i ya an̰ji ba lamdɨ le de. ");
INSERT INTO sor_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Labaa, aba ciri di kɨlnəw gandɨdɨ i gorndɨw dara ba unədɨ deme da, an̰ji ha àladɨ́ i mani nə ya ba gɨ àlgɨ̀ nɨm gɨ dine nə mware nə gɨ laygɨ namde ta de me ca. ");
INSERT INTO sor_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Me aba ciri di kɨlnə kóy dɨ ɗang dara gɨdədɨ dyaməw dɨ pii di dɨdə kaw, an̰ji ha kɨlanga mani mɨn nə àla gɨ dyaməw dɨ pii di bam bədə: An̰ji ha ꞌyàdɨ́ mani nə wama me, barge me, ha ꞌya gandɨdɨ deme gɨ abe me ca. ");
INSERT INTO sor_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Me mani nə subu nə ta di an̰ji gɨn̰ɨnə àladɨ́ nə mɨn bam da, tandi nem dɨmə bam kwaynaniyə di pəgɨn̰ hára dɨban ꞌywagaw.» ");
INSERT INTO sor_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","«Gun gɨ ajɨna jaw gun ꞌyánaw da, an̰ji kaw ùr i ꞌyáa gɨ bam me ca. ");
INSERT INTO sor_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Me gun gɨ ta di ina gɨ ɨrmə gaba ꞌyáa gɨ jaw gun bədə me, ina i ɨndi gɨ Mãr̰ĩ di me nə chɨ́nəw ɨsəwə ɨndi me an̰ji ꞌyánaw nɨm da, nə ha gɨləm mana gɨ gun gaba ꞌyáa jaw di ha wàa hára bɨlə gɨ sɨw lə. ");
INSERT INTO sor_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Me gun gɨ yɨnə jaw gun gɨ mar̰ande me ꞌyánaw nɨm gɨ kojɨgə me wàna hana dara bɨlə gɨ sɨw, ina i mana gaba bwasan tulɨwə ib kaw, hana yɨnəw biynəw hane nɨm: An̰ji ùr i ꞌyáa gɨ bam. ");
INSERT INTO sor_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Gun gɨ gwabɨna abəw labaa iw da, an̰ji ùr i ꞌyáa gɨ bam. ");
INSERT INTO sor_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Gun gɨ mĩynə jaw gun hana kɨlnəw bam labaa, gamnaw lə kɨrə duwa lə sɨn̰ kaw, an̰ji ùr i ꞌyáa gɨ bam. ");
INSERT INTO sor_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Gun gɨ cadɨna abəw labaa iw da, an̰ji ùr i ꞌyáa gɨ bam.» ");
INSERT INTO sor_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","«Mana gɨ nare jarna me, bulə dayyə ta di, gɨ mɨn ajɨna jaw gɨ ɨsəw labaa mwagɨna kur̰a ɨsəwə me ajɨnaw gabɨnawe mɨra me an̰ji marna bədə me, ");
INSERT INTO sor_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","gɨra swana jigdɨnə sɨw gɨ habda hana daa da, gun gaba ajaw gabaw dodə di, gwale ilə dɨwə bədə. Me an̰ji ha ꞌywagaw aba gabara dodə di mani dara wála duwa gaba giyə gɨ an̰ji mendɨw bam di. Ɗang da, an̰ji ha swaa aba gabara dodə di daa wamani duwa lə di. ");
INSERT INTO sor_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Kwaya gɨ aba ciri duwa ajɨnaw gɨ cilang me marna bam da, kal gɨ àlna aba ciri duwa di wamani lə biiyə. Ina i kóy kaw, ha àlala i yande me ca. ");
INSERT INTO sor_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Me kwaya gɨ aba ciri duwa ajɨw di àlna wála mɨn labaa sɨr do me marna sɨn̰ da, gɨ àlna aba ciri duwa di wamani bədə, dara i gursɨ duwa dɨ an̰ji kɨləw nɨm di me bow sɨw bam. ");
INSERT INTO sor_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Nare jarna say me dɨmnə deme dɨ i gɨ gudi me, dɨmə gɨ cendi dɨmdɨ di àlnadɨ yàna pii wála dɨra gaba yàa di dɨrəwə, me yàna i labiya da, woni dɨmədɨ di ha ꞌywagaw tɨrədɨ mani nə an̰ji ha sawagɨ di woni aa sariya dɨrəgɨ lə. ");
INSERT INTO sor_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Me deme di labaa dwe dɨra ꞌywana wamani da, woni ꞌyàdɨ́ wamani di, kal gɨ àlnagɨ́ wamani lə biiyə. Gun gɨ ꞌyána gun da, gɨ ꞌyánaw bam me ca. ");
INSERT INTO sor_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Gun gɨ gunəw gun dudɨw bam da, gɨ gunəw duwa bam me ca. Gun gɨ ajɨna gun sandaw biynəw bam da, gɨ ajɨnaw duwa biynəw bam me ca. Gun gɨ biynəw gun dar̰aw labaa, dɨgɨlaw bam da, gɨ biynəw duwa bam me ca. ");
INSERT INTO sor_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Gun gɨ ulnə gun gɨ dùwa da, gɨ ulnəw gɨ dùwa me ca. Gun gɨ ajɨna gun diya da, gɨ ajɨnaw diya lə biiyə me ca. Gun gɨ ajɨna jaw gun da, gɨ ajɨnaw lə biiyə me ca. ");
INSERT INTO sor_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Kwaya gɨ aba ciri duwa ajɨnaw dudɨw gunəw bam da, aba ciri duwa di ha kalaw dɨmə bam kwaynaniyə dɨw pəgɨn̰ dara dudɨw dɨ gur bam di. Ina i kóy kaw, ha àlala i yande me ca. ");
INSERT INTO sor_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Kwaya gɨ aba ciri duwa ajɨnaw sandaw biynəw bam da, aba ciri duwa di ha kalaw dɨmə bam kwaynaniyə dɨw pəgɨn̰ dara sandaw nə biyər bam di. Ina i kóy kaw, ha àlala i yande me ca. ");
INSERT INTO sor_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Gun gɨ labe duwa ꞌwayna abe labaa deme ꞌyána da, gɨ jarna labe di gɨ kur̰a ꞌyánaw bam. Me kabni duwa da, gun mɨn kaw ha wama bədə. Me aba labe di, gwale ilə dɨwə bədə. ");
INSERT INTO sor_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Me labe di ina i gɨ man̰e gaba dɨmdə nare le pii pii, me aba ciri duwa di àsɨna dɨw lə gamaw lə ladɨ bədə me labe di ꞌwayna gun ꞌyánaw da, kal gɨ jarna labe gɨ ta di gɨ kur̰a ꞌyánaw bam me, gɨ ꞌyána aba ciri duwa di bam me ca. ");
INSERT INTO sor_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Me aba labe di, gɨ ꞌyànáw bɨrmə dara an̰ju ba ꞌywagɨna mani dara kɨdə gɨ sɨw daa da, an̰ji ha ꞌywaga mani pad nə gɨ sawɨw gandagɨ dɨwə ta di le. ");
INSERT INTO sor_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Labe ꞌwayna i dwe gɨ abe labaa dwe dɨ deme ꞌyána kaw, gɨ àlna i bii gɨ ꞌwoo gɨ ta di me ca. ");
INSERT INTO sor_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Labe ꞌwayna kwaya ꞌyánaw da, kal aba labe di ꞌywagɨnaw aba ciri duwa chile dɨ tuda gɨnɨn̰ subu. Ina i kóy kaw, ha àlala i yande me ca. Me labe da, kal gɨ jarnaw gɨ kur̰a ꞌyánaw bam me ca. ");
INSERT INTO sor_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Gun gɨ tɨn̰ɨnə bɨla bɨw bam kalna pəgɨn̰ labaa, biynə bɨla me kalna bɨw pəgɨn̰ me labe labaa kura hane ɨndarna lə da, ");
INSERT INTO sor_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","kal aba bɨla di ꞌywagɨnaw aba labe labaa kura di gursɨ mana gɨ dwana dɨnə labe labaa kura di lə. Ɨr̰ɨ kumbɨ dɨnə labe labaa dɨnə kura di ha waraw i aba bɨla di duwa ɗɨm. ");
INSERT INTO sor_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Gun gɨ labe duwa ꞌwayna gɨnə jaw duwa ꞌyánaw da, kal woni labje di ca kɨlnə labe gaba ꞌwaya jaw ꞌyáw di bam me ɨsənnə gursɨ di sɨdəgɨ lə korgɨn̰ ca. Kumbɨ dɨnə labe di kaw, cendi ha ɨsədɨ sɨdəgɨ lə korgɨn̰ ca me ca. ");
INSERT INTO sor_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Me labe di gɨ ꞌwacn̰awe pii dara ba i aba jara say, me aba ciri duwa àsɨna dɨw lə gamawə ladɨ bədə me, ꞌwayna gɨnə gun duwa ꞌyánaw da, labe gaba ꞌwaya jaw ꞌyáw di aba ciri duwa ꞌywagɨna jaw labe lə biiyə me, kumbɨ dɨnə labe di ha waraw i aba ꞌywaga di duwa ɗɨm.» ");
INSERT INTO sor_vpl VALUES ("EX21_37","003_21_37","EXO","21","37","37","«Gun gɨ mĩynə labe labaa dɨmən̰ labaa cange ꞌyána le labaa kɨlnə bam da, kal mẽ di ꞌywagɨna labje jii labe gɨ mɨn di bɨwə, labaa, ina i dɨmən̰ labaa cange da, a ꞌywagɨna bage wodɨ lə biiyə me ca.» ");
INSERT INTO sor_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","«Mẽ di ina lə ɓwalba kulu bam dara mĩyə gɨ mani gɨ changa me mə ꞌywanaw lə me, mə gwabɨnaw me an̰ji gɨra marna da, ɨjɨm gaba gwabaw me an̰ji mar nɨm di, ùrɨm ꞌywaga gɨ made duwa bədə. ");
INSERT INTO sor_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Me mẽ di ina lə mĩyə maniyə gɨ dawa me mə ꞌywanaw lə me, mə gwabɨnaw me an̰ji gɨra marna da, made duwa di i ɨjɨm gaba gwabaw di dɨmmə. Mẽ gɨ mĩynə mani da, ùrɨw i ꞌywaga gɨ mani nə an̰ji mĩyəgɨ di daa. Me mani duwa woni ꞌywaga di ina lə bədə da, ùr i kɨləw bam ya kwaya de dara ꞌywaga gɨ mani nə an̰ji mĩyəgɨ di. ");
INSERT INTO sor_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","An̰ji mĩynə i labe labaa, kura labaa, dɨmən̰ labaa, cange me gɨ gɨra ꞌywana mani nə an̰ji mĩyəgɨ ta di ɨsəwə bɨ̀ra sɨn̰ da, kal a ꞌyànaw aba ciri gɨnə mani nə an̰ji mĩyəgɨ di sɨr.» ");
INSERT INTO sor_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","«Gun hana gamna mani duwa nə paga yiga duwa lə me cendi cilangɨna hana wamna gun gɨ ɗang swagə duwa labaa yabɨr̰a duwa bam da, aba mani nə paga di ha ꞌywagaw aba swagə di swagə duwa dɨdəgɨ nə lade labaa, yabɨr̰a yàa duwa gɨ lade lə biiyə. ");
INSERT INTO sor_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Gun gɨ gɨrnə dùwa me, dùwa di yɨnə jimdi me wana hana ulnə gun gɨ ɗang swagə duwa nə naa me gɨ gɨlgɨ dodə ɗɨm labaa, nə gɨ wor gɨləgɨ dodə sɨn̰ labaa, nə wor naa sɨn̰ da, aba gɨrə dùwa di ha ꞌywagaw aba swagə di le. ");
INSERT INTO sor_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Gun ꞌyànaw jaw gursɨ labaa mani dara an̰ju ba gamnawe kɨrə duwa lə, me mẽ hane mĩynə bam da, kal mẽ di ꞌywagɨna mani di le dii sɨr. ");
INSERT INTO sor_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Me mẽ di, gun ꞌywanaw bədə da, aba gama mani kɨrə duwa lə di ha hára ɗɨbə ɨndi gɨ Mãr̰ĩ dɨrənnə me, an̰ji ha sɨrgə sɨw dara ba a u mani di an̰ju bədə. ");
INSERT INTO sor_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Mana gɨ nare sɨr gagɨna gwale labe dɨwə labaa, kura dɨdə labaa, dɨmən̰ dɨdə labaa, cange dɨdə labaa, barge dɨwə labaa, mani nə we we nə nol bam dɨdəgɨ lə, wi kaw wayna ba i duwa duwa da, kal nare nə sɨr nə ta di hane ɨndi gɨ Mãr̰ĩ dɨrənnə. Me gun gɨ nə dara wayaw da, mani di ba i duwa bədə da, gun gɨ ta di ha ꞌywagaw jaw gɨ mani i duwa di, dii sɨr. ");
INSERT INTO sor_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Gun ꞌyànaw jaw kura labaa, labe labaa, dɨmən̰ labaa, cange labaa, mani nə paga nə ɗang gama, me mani di marna bam labaa, mani day biyarna bam labaa, mẽ mĩynəgɨ bam me gun gɨ ɗang yarna gandɨw bədə da, ");
INSERT INTO sor_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","aba gama mani di ha sɨrgə sɨw gɨ ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ di sumɨn ba a yɨ mani nə paga di an̰ju bədə. Mwom da, aba mani nə paga di ha yəə gwale gɨ an̰ji sɨrgɨ gɨ sɨw di le me, gun gɨ gɨ ꞌyàw mani gama di ha ꞌywagaw mani bədə ɗɨm. ");
INSERT INTO sor_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","Ɗɨm da, mani nə paga di, gɨ mĩynəgɨ i kɨrə nə aba gamagɨ lə da, an̰ji ha ꞌywagaw aba ciri day di le. ");
INSERT INTO sor_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Ina i mwagɨna gɨ man̰e me yɨnə mani nə paga di wamnagɨ an̰ju da, aba gamagɨ di unəy kabni day gɨ wor di daa hane gɨlnəw aba ciri day di le. Mwom da, aba gamagɨ di ha ꞌywagaw aba ciri day di mani bədə ɗɨm. ");
INSERT INTO sor_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Gun yɨnəy mani nə paga nənə jaw gun duwa me, mani nə paga di mani day biyarna bam ɨsəwə labaa, marna bam me, aba ciri day di yarna gɨ dɨrəw duwa bədə da, aba ꞌwàa yəə di ꞌywagɨnaw aba ciri day di le. ");
INSERT INTO sor_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Ɗɨm da, aba ciri day di yarna gɨ dɨrəw duwa da, aba ꞌwàa yəə di ha ꞌywagaw aba ciri day di mani bədə ɗɨm. Gun gɨ ꞌwàna yɨnə mani nə paga nənə jaw gun duwa me ꞌyànáw i mani me yɨnəy nɨm me, mani nə paga di mani day biyarna bam labaa, marna bam da, aba ꞌwàa yəə di ha ꞌywagaw aba ciri day di mani bədə ɗɨm. Dara mani nə an̰ji ꞌyàw me yəə nɨm gɨ mani nə paga di nemme ɗɨm. ");
INSERT INTO sor_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Gun gɨ lamna dwe dɨ more dɨ ꞌwocn̰ abe dii mɨn bədə, dɨ gun wor àla mogɨni dɨra sɨn̰ me, ina gandɨdɨ da, gun gɨ ta di ha ꞌywagaw abadɨ mál dɨra le me, ha ꞌwódɨ deme me ca. ");
INSERT INTO sor_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Me dwe dɨ more di abadɨ ɨmnəw ꞌwódɨ gɨ deme bam kaw, an̰ji ha ꞌywaga gɨndɨdɨ ya mál dɨ idɨ ꞌwoo gɨ dwe dɨ more dɨ dii mɨn kaw ꞌwocn̰ abe bədə sɨn̰ di de me ca.» ");
INSERT INTO sor_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","«Deme dɨ idɨ àla bəli da, kalnadɨ daa bədə, ꞌyánadɨ bam. ");
INSERT INTO sor_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Gun gɨ ina gɨ mani nə paga da, an̰ji ùr i ꞌyáa gɨ bam. ");
INSERT INTO sor_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Gun gɨ àlnagɨ́ domde sarga ɓamnan nɨm ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ di da, an̰ji ùr i myandaw gɨ bam gɨndɨw duwa lə bɨr̰ɨn̰, dara sarga da, ùr i àlan ɨndi mɨn tenene mɨra.» ");
INSERT INTO sor_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","«Mɨje nə gɨndəgɨ i Israyel bədə nə hára dam gandang ciri da, bɨlnəgɨ ya anə banə i woni ciri day de bədə me, gɨlnəgɨ dɨrəgɨ bədə me ca. Dara ꞌyeni di kaw, tanga anə ꞌya i mɨje mana gɨ sɨn̰a dɨ Ejibtɨ lə di me. ");
INSERT INTO sor_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Gɨlnəgɨ namde nə wambɨ me bagondə me dɨrəgɨ bədə. ");
INSERT INTO sor_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Anə gɨlnəgɨ dɨrəgɨ me, cendi swajɨna ꞌwagɨnan ba nə wanagɨ lə da, nə ha dwaya ꞌwaga day di le me, ");
INSERT INTO sor_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","dusɨn ha swaa le dɨdəngə me, nə ha ꞌyáng bam sayyə. Mwom da, i namdang me ha wara wambɨ cendi me, dɨndɨrang kaw ha wara bagondə me ca. ");
INSERT INTO sor_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Mə ꞌyànaw chendɨm gɨ Israyel gɨ bugɨr kwale da, àl gandɨw ya woni bwaa gursɨ day iya de bədə: Ùrɨw gursɨ dɨma di sɨdɨ mɨra, kal ùrəw gɨ nimi dɨra lə diiyə ɗi. ");
INSERT INTO sor_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Gun dyangɨnam barge duwa gɨ dɨsa dara ꞌwoo gɨ kwale ɨsəmmə da, cow barge di daa bi do me kal dawa ɗwandɨna sɨn̰. ");
INSERT INTO sor_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Dara i barge duwa gɨ ta di mɨn tenene duwa lə, me mə ꞌyànáw bədə da, an̰ji gɨra ha bwaa i na dɨwə gɨ changa mo? An̰ji swayna ꞌwagɨnan ba nə wanawə da, nə ha dwaya ꞌwaga duwa di le, nə ha wawə, dara nə i aba yara nare n̰agɨni day.» ");
INSERT INTO sor_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","«Ɨndi gɨ Mãr̰ĩ da, anə ha cadɨban bədə me, gechide dan woni ɗɨbə dɨrəngə kaw, anə ha waya gwale day gɨ àcn̰e bədə me ca. ");
INSERT INTO sor_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Wála gɨ swagə dan dara naa da, anə ha ꞌwoo dɨdəgɨ hára nɨm kaláng chə́n dɨrənnə me, anə chidɨnə yabɨr̰a dan yàa duwa kaw, unən hane nɨm kaláng chɨ́nən dɨrənnə me ca. Dɨndɨrang nə abje nə man̰jɨli kaw, anə ha biyən gandagɨ jiga. ");
INSERT INTO sor_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Ina i mani dan nə paga kaw, anə ha àla i ya ta de me ca. Labje dan me, dɨmən̰je dan me, bage dan nə mee me yàna dɨndɨragɨ nə dɨrɨn̰ nə piiyə da, anə ha kalagɨ idəgɨ gɨndəgɨ lə wála wurgɨsubu, me wála gɨ dunasɨrrə da, anə ha ꞌyàn gandagɨ àlán gɨ sarga. ");
INSERT INTO sor_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Anə ha ꞌya i nare ni nə wun mɨ́ndagɨ jiga. Mwagɨna gɨ man̰e yɨnə jaw mwagɨna wamna me kabni duwa warna kaw, anə ha wama bədə, anə ha ꞌyàgɨ́ i gɨrade bam.» ");
INSERT INTO sor_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","«Gwale gɨ mə dwayna gɨ i kulagɨ da, kal hára cɨmdəw daa pəgɨn̰ mad mad ɗi. Gun gɨ gwale duwa hana lə bədə da, kal bɨləw bɨw sarni ɗi. ");
INSERT INTO sor_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Nare nə gɨr̰e ùrnə ba gɨ àlna i mani nə àcn̰e da, kal pama taragɨ ɗi. Me gwale ina lə gaba ùrə aa sariya me nare nə gɨr̰e ina lə pama i gwale gɨ kulagɨ da, kal ɨndara taragɨ lə dara myanda gɨ gwale sɨw bam ɗi. ");
INSERT INTO sor_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Gun ina i gɨ bugɨr kaw, mana gɨ sariya lə me gwale duwa ladɨna bədə da, kal wawə dara biyəw gɨ gwale bam dɨwə ɗi. ");
INSERT INTO sor_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Ina i aba mar̰ande dɨma kaw, labe duwa labaa, kura duwa nwalna bam me, mə ɓamarna gɨ mani nə nole di da, yɨgɨ daa hare nɨm ꞌyàw aba ciri day. ");
INSERT INTO sor_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Mə ɓamarna gɨ aba mar̰ande dɨma gɨ kura duwa hudɨr nudɨ nan̰ me kura di ɨndər dodə da, kalɨw bam bədə, wawə yəə gɨ kura duwa di lə daa. ");
INSERT INTO sor_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Gun ina i gɨ bugɨr kaw, sariya lə da, kalna myandaw gɨ gwale duwa sɨw bam ɗi. ");
INSERT INTO sor_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Hurna sɨdəng mana gɨ gwale gɨ kulagɨ lə bədə, me gun gɨ àlna mani mɨn bədə, labaa, aba àla mani nə tɨba da, myalnaw made bədə. Gun gɨ àlna mani nə ta di da, ɨndi gɨ Mãr̰ĩ, nə ha kalaw pəgɨn̰ bədə. ");
INSERT INTO sor_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Kalna ùrə gɨ mani nə pəgɨn̰ ɗi. Dara mani nə pəgɨn̰ di bugɨ nare nə dɨrəgɨ yər mana ladɨ pɨrang dɨrəgɨ bam me, mendɨgɨ nare nə tɨba gwale day bam me. ");
INSERT INTO sor_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Gun gɨ gɨndɨw i Israyel bədə gɨ damna gandang ciri da, gɨlnəw dɨrəw bədə. Anə ꞌwocn̰ dama gɨnə gun gɨ mɨje duwa le com, dara tanga ꞌyeni di kaw, anə ꞌya i mɨje mana gɨ sɨn̰a dɨ Ejibtɨ lə di me ca.» ");
INSERT INTO sor_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","«Anə ha gɨsə swagə dàge dannə me anə ha n̰ilbəgɨ me aliya kubi dalawə, ");
INSERT INTO sor_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","ɨr̰ɨ aliya gɨ wurgɨsubu lə da, anə ha bwagɨ dàge dan di gwayni. Nare nə bugɨr ha n̰ilə swagə nə munɨ munɨ wamagɨ me, mwagɨne kaw ha wama nə nɨmdər wor nare di taragɨ lə me ca. Ina i dàge nə yabɨr̰a labaa, nə olib kaw, anə ha àla yande me ca. ");
INSERT INTO sor_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","I wála kubi dalawə me anə ha àla giyə dan lə pad me, wála gɨ wurgɨsubu lə da, anə ha bwaa i gwayni, dara kal labje dan me, kura dan me, bwana gwayni me, kòy dan me nare nə gɨndəgɨ i Israyel bədə nə dam ciri gandang me kaw, bwana gwayni me ca.» ");
INSERT INTO sor_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","«Anə ha àsa angal dan ladɨ le mana gɨ gwale gɨ ɨndi gɨ Mãr̰ĩ nə wayang gandɨw pad di dɨwə. Hɨrwɨnə domde nənə nare nə ɗang day bədə me, gunə sumdəgɨ bɨdəngə bədə bɨr̰ɨn̰ me ca. ");
INSERT INTO sor_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Aliya bá bá dalawə da, anə ha hára àla sii ꞌywala gaba àsán ɨndi gɨ Mãr̰ĩ sumi gɨ ꞌwaga dɨnnə dii subu. ");
INSERT INTO sor_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Dɨrɨn̰ nə piiyə da, anə ha àla sii ꞌywala gɨnə mapa gɨ dɨban musbu. I duru gɨ swagə ganda day gɨ dɨdəgɨ lə di me anə ha wama i mapa gɨ dɨban musbu mɨra àla wála wurgɨsubu, ya ba nə ɨrməng nɨm ta de. Dara i duru gɨ ta di dalawə me, anə dɨmə nɨm bam sɨn̰a dɨ Ejibtɨ lə di. Kal gun hane ꞌywanan ɨsəw pəgɨn̰ bədə. ");
INSERT INTO sor_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Ɗang da, anə ha àla sii ꞌywala gɨnə n̰ilbə gɨ swagə. Sii ꞌywala gɨ ta di, anə ha àlàw i mana gɨ anə n̰ilbɨnə swagə dan nə dɨrɨn̰ nə piiyə nə anə yigɨgɨ di. Targɨn̰ da, anə ha àla sii ꞌywala gaba cəə yabɨr̰a yàa duwa me gaba ara olib yàa duwa me. Sii ꞌywala gɨ ta di, anə ha àlàw i aliya bɨw gɨ ꞌyen̰eyə. Anə ha àlàw mana gɨ anə layna mani dan nə yiga pad hana nɨm ulay ɗɨm. ");
INSERT INTO sor_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Aliya dalawə bá bá da, abje nə Israyel pad hane ꞌywanan ɨndi gɨ Aba ciri dan Gaba dama gɨ dɨrən bɨr̰ɨn̰ di dii subu. ");
INSERT INTO sor_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Anə kundɨbɨnə mani nə paga dara àlán gɨ sarga da, ɓamnagɨ gɨ mapa gɨ anə àlɨ̀w gɨ musbu bədə. Anə ha gama mani nə anə kundɨbɨgɨ àl gɨ sarga di swani day wála daa sanga bədə. ");
INSERT INTO sor_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Swagə dan nə yiga nə naa dɨrɨn̰ nə piiyə da, anə ha ꞌwoo dɨdəgɨ hára nɨm ꞌyàn ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ gɨ nə i Mãr̰ĩ dan di mana gɨ kulu niyə. Anə kundɨnə cange gɨ dwe da, anə ha hangdaw gɨ nãy nənə iw bədə.» ");
INSERT INTO sor_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","«Dwayna, nə ha giyə paja ni gɨ daa mɨn ɨndarna dɨrəngə bɨrmə lə gamnang hana gandang dɨmnə mana gɨ sɨn̰a dɨ nə ɗangr̰ang gandɨdɨ lə di bá. ");
INSERT INTO sor_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Dwayna gwale bɨwə me, yɨnəw jawe me, kɨdɨnəw dɨrəw bədə me ca. Anə kɨdɨnəw dɨrəw da, an̰ji ha kalang pəgɨn̰ bədə. Dara an̰ji àl mani i gɨ ɨndi gɨ Mãr̰ĩ sumɨn. ");
INSERT INTO sor_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Anə dwayna gwale bɨwə me, anə àlna mani nə nə wayang gandagɨ di gɨ bɨrmə day me da, nə ha ꞌya i aba mar̰ande gɨnə woni mar̰ande dan pad day me, nə ha jara say gɨ woni jara gandang say me ca. ");
INSERT INTO sor_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Paja ni di ha ɨndara dɨrəngə bwang hára gandang dɨmə sɨn̰a dɨnə nare nə Amori dayyə me, nə Hiti dayyə me, nə Perisi dayyə me, nə Kanan dayyə me, nə Hibi dayyə me, nə Yebus dayyə me. Nə ha ꞌyáa nare nə ta di bam dara kalang gɨ mana gaba dama. ");
INSERT INTO sor_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Me nare nə ta di, anə ha piyə gubɨrəng dodə domde day dɨrəgɨ lə bədə me, anə ha bwasagɨ bədə me, anə ha ꞌwoo bɨrmə day gɨ cendi uw dara bwasa gɨ domde day di bədə me ca. Me anə ha ichɨbə domde day di dúndɨrəgɨ bam me, anə ha cubə kur̰a dɨ gɨ jogdɨdɨ daa ɨrmɨdɨ dwama day di bam me ca. ");
INSERT INTO sor_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Anə ha bwasa i ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ gɨ nə i Mãr̰ĩ dan di mɨn tenene mɨra. Mwom da, nə ha piyə bɨn dɨdəngə ꞌyàng mani nə wama nan̰ me, nə chàa nan̰ me, nə ha ꞌywara mwom bam sɨdəngə me ca. ");
INSERT INTO sor_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Mana gɨ sɨn̰a dannə da, deme mɨn kaw ha sɨlə bam bədə me, ha dama madɨri bədə me ca. Nə ha kalang anə ha dama tarang ha yāa le sɨn̰a dɨdə ka. ");
INSERT INTO sor_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Mana gɨ anə gɨrnə sɨn̰a dɨ anə ilə hára lə di ib mwom da, nə ha bwagɨ nare dɨra lán̰a gɨndəgɨ lə. Nare pad nə anə ha hára dayyə ta di, nə ha cagdagɨ bam me, woni mar̰ande dan pad da, anə ha yara taragɨ gidiyə me ca. ");
INSERT INTO sor_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Nə ha giyə madɨgər̰ə pii dɨrəngə kal ɗwagdɨna nare nə Hibi di me, nə Kanan di me, nə Hiti di me ꞌywarnagɨ daa pii dɨrəngə. ");
INSERT INTO sor_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Me nə ha ꞌywaragɨ daa pad aliya mɨn dalawə bədə. Nə ꞌywarnagɨ daa aliya mɨn dalawə da, sɨn̰a di ha wara i bodə me, mwagɨne nə bam ha ꞌyarbara lə nan̰e me ha jibange. ");
INSERT INTO sor_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Me nə ha ꞌywaragɨ daa dɨrəngə ɓani ɓani, bɨraa wála gɨ anə dara yàa ꞌyarbara ꞌwanba sɨn̰a di dɨdɨ daa gɨdədɨ dan bá do. ");
INSERT INTO sor_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Nə ha ɨrməng sɨn̰a dan di pale dɨra ha ɓɨlə le, so kuray gaba Dɨrwa di lə bɨraa hára kuray gɨ Geche gɨ nare nə Pilisi dam lə bɨwə, me so dɨn dwar̰ɨ dɨ Sinayyə bɨraa hára kuray gɨ gɨ ꞌwogɨw Epɨrat lə bá. Nə ha ꞌyàng nare nə sɨn̰a dɨ wama gɨ ta lə di ɨsɨrangə me, anə ha ꞌywaragɨ daa dɨrəngə. ");
INSERT INTO sor_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Me anə ha yəə mɨlan gɨ nare nə ta di bədə me, gɨ domde day bədə me ca. ");
INSERT INTO sor_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Kalnagɨ damna gandang ciri dannə bədə. Dara cendi damna gandang da, cendi ha lamang bwang àla gɨ àcn̰a gandɨn dara anə ha bwasa domde day.» ");
INSERT INTO sor_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: «Wol Arõ me, Nadab me, Abiyu me, nare nə Israyel nə dɨrəgɨ nagdɨ gɨnɨn̰ wurgɨsubu me gandɨm, me nagɨnay hane ꞌywanan daa kur̰a dɨdə. Me mana gɨ anə warnay bam hən̰ sɨn̰ da, anə ha piyə gubɨrəng dodə dɨrənnə. ");
INSERT INTO sor_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","I ɨjɨm Moyis mɨn tenene me, mə ha chidə hára sɨnnə ib. Me nare nə hára gandɨm da, ha hára sɨnnə ib bədə me, nare nə Israyel nə pad di kaw, ha naga hára daa kur̰a lə di gandang bədə me ca.» ");
INSERT INTO sor_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Ɨr̰ɨ Moyis ha cɨməgɨ nare nə Israyel gwale pad gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw gandɨw di me bii gɨ ꞌwoo pad gɨ an̰ji ɨrməw gandɨw di me. Mwom da, nare nə Israyel di pad dayyə dáy bɨdəgɨ mɨn way ba da: «Əw, mani pad nə Aba dama gɨ dɨrəw bɨr̰ɨn̰ waynin gandagɨ di, nə hanin àlagɨ̀ le.» ");
INSERT INTO sor_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Ɨr̰ɨ Moyis jangɨ gwale gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw pad di dodə, me sanga gɨ jomni cor̰ər̰ə da, an̰ji aw mana gaba bwasa Mãr̰ĩ mana gɨ kur̰a gɨndɨdɨ lə me, lay kur̰a dɨ ɓolbəre mwaj dii sɨr jogdɨdɨ kɨrdɨ ɨrɨm gɨ gangle gɨ mwaj dii sɨr gɨnə nare nə Israyel day. ");
INSERT INTO sor_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Ɨr̰ɨ an̰ji giy dine nə moso nə Israyel dara ba hana ulnə mani àlnáw gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ sarga me, ba kundɨbɨnə labje nə abje nə jorbe àlna gɨ sarga dɨ idɨ labiya me ca. ");
INSERT INTO sor_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Moyis bo bare gɨnə mani nə gɨ kundɨbɨgɨ di pɨrayyə me, an̰ji u hin̰e chɨ̀gdɨ mana gaba bwasa Mãr̰ĩ dɨwə. ");
INSERT INTO sor_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Mwom da, an̰ji u maktubu dɨ idɨ mɨlan dɨ Mãr̰ĩ yɨ gɨ nare nə Israyel di ɨsəwə me, āsɨgɨ gandɨdɨ mar̰ɨjaw daa nan̰, me cendi cow lə diiyə ba da: «Əw, mani pad nə Aba dama gɨ dɨrəw bɨr̰ɨn̰ waynin gandagɨ di, nə hanin àlagɨ̀ le, me nə hanin àla bɨw di le me ca.» ");
INSERT INTO sor_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Ɨr̰ɨ Moyis u bare gɨ wor di ɨsəwə me, chɨ̀gdɨgɨ nare di dɨdəgɨ lə me way ba da: «Ta di me i bare gɨ Mãr̰ĩ yɨ nɨm gandang mɨlan, ꞌyàng nɨm gɨ bii duwa gɨ ꞌwoo gɨ pad ta di.» ");
INSERT INTO sor_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Targɨn̰ ɗang da, Moyis wol Arõ me, Nadab me, Abiyu me, nare nə Israyel nə dɨrəgɨ nagdɨ nə gɨnɨn̰ wurgɨsubu di me nagɨgɨ ha daa kur̰a dɨdə. ");
INSERT INTO sor_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Cendi yər Mãr̰ĩ gɨnə cendi nə Israyel day di. Me dodə gɨdawə da, mana wun ya ba gɨ ɗangr̰ɨw i gɨ kur̰a dɨ lade dɨ idɨ sumi dɨ ꞌyogdɨ nan̰ ya siyaya ba a ácn̰ nɨm ta de. ");
INSERT INTO sor_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Me Mãr̰ĩ di àl nare nə Israyel nə dɨrəgɨ nagdɨ di wamani bədə. Cendi yərɨw me, wom me, chə̀ me. ");
INSERT INTO sor_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: «Nagay hare kwa daa sɨnnə kur̰a dɨdə ka me dam lə. Nə ha ꞌyàm kur̰a dɨ ɓɨdɨr̰a ɓɨdɨr̰a dɨ nə jangang bii ni gɨ ꞌwoo lə di me mani pad nə nə ɨrməng gandagɨ di me dara ba mə hana gɨlnəgɨ nare nə Israyel di.» ");
INSERT INTO sor_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Moyis so wol Josuwe gaba wawə giyə lə di me, Moyis di nagɨ ha daa kur̰a dɨnə Mãr̰ĩ duwa lə di dɨdə. ");
INSERT INTO sor_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Mana gɨ Moyis ùr ba a nagɨ ha daa kur̰a dɨdə da, an̰ji waygɨ nare nə Israyel nə dɨrəgɨ nagdɨ di ba da: «Gamnanin mana gɨ ka lə di jang bɨraa nə cwaranin hára ꞌywang nɨm bá. Arõ me, Hur me da, ha wara gandang. Me gun ina i gɨ gwale lə da, a hane nɨm ꞌywanagɨ cendi.» ");
INSERT INTO sor_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Moyis nagɨ ha daa kur̰a dɨdə. Me sawe mu kur̰a di daa gwam. ");
INSERT INTO sor_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","ꞌYwagda gɨnə Aba dama gɨ dɨrəw bɨr̰ɨn̰ duwa ilə mana gɨ kur̰a dɨ Sinay di dɨdə me, sawe di kaw mudɨ daa bɨraa wála kubi bá. Ɨr̰ɨ wála gɨ wurgɨsubu lə da, Aba dama gɨ dɨrəw bɨr̰ɨn̰ ꞌwogɨ Moyis mana gɨ sawe di dalawə. ");
INSERT INTO sor_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Me nare nə Israyel dɨrəgɨ lə da, ꞌywagda gɨnə Aba dama gɨ dɨrəw bɨr̰ɨn̰ duwa di wun ya dùwa dɨ idɨ ulə mani ta de mana gɨ daa kur̰a dɨdə. ");
INSERT INTO sor_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Ɨr̰ɨ Moyis gandɨ ya sawe di dalawə ilə naga hára lə pii pii kur̰a di dɨdə. An̰ji dama daa kur̰a di dɨdə àla wála gɨnɨn̰ wodɨ. ");
INSERT INTO sor_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: ");
INSERT INTO sor_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","«Waygɨ nare nə Israyel gɨ salnay mani day nə ꞌywaa yab ꞌyànán. Nare woni ꞌyàn mani day nə ꞌywaa di, wi kaw ꞌyàna gɨ ùrə duwa. ");
INSERT INTO sor_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Mani nə cendi ha salan gandagɨ di me i ta: jindar me, tuda me, biri gɨ bor ngɨr ngɨr me, ");
INSERT INTO sor_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","chire gɨ bor ngɨr ngɨr me, gɨ kwamge me, gɨ wusɨ bəliyə me, chire gɨ ɗang gɨ lade me, wudɨn̰ nənə bage nə mee day me, ");
INSERT INTO sor_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","gare gɨ kulajɨ gɨnə gəgɨr̰ɨn̰je gɨ gɨ borɨwe me, gare gɨ kulajɨ gɨ ɗang gɨ lade nan̰ me, habde nə chelbe me, ");
INSERT INTO sor_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","swani gɨnə lamba dɨra me, habde dur̰u day dɨ biy ꞌyol dara ɓamagɨ àla gɨ swani ni gaba tidɨrə diiyə me dara gwasa nɨm me, ");
INSERT INTO sor_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","kur̰a dɨ komɨn̰ dɨ idɨ sumi me, dɨ ɗang dɨ ladɨbe dara sɨrandaw gɨ woni bwasan geche day barge duwa gaba hura bwasan nɨm di me dara sɨrandaw gɨ bos duwa gɨ jorgɨwə me ca. ");
INSERT INTO sor_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Nare nə Israyel di ha ɗangr̰an mana ni gɨ wun mɨnaw jiga gɨ nə ha dama nɨm lə dwar̰agɨ lə. ");
INSERT INTO sor_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Nə ha gɨləm kundi gɨ nə ha dama lə di dúndɨw me, mani duwa pad dúndɨrəgɨ me. Mwom da, anə ha ɗangr̰a ya ta de dige dige.» ");
INSERT INTO sor_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","«Anə ha ɗangr̰a sandug gɨ habde nə chelbe. Charni dɨra ha nyama dar̰e mɨn gɨ tulɨn̰ me, ɓɨlnani dɨra ha nyama dar̰e mɨn me, hwaa dɨra kaw ha nyama dar̰e mɨn me ca. ");
INSERT INTO sor_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Anə ha ɗangr̰a jindar sɨdɨ dɨ wed ɨbdədɨ dwar̰ɨ lə me tardɨ lə me. Anə ha ɗangr̰a jindar bɨdə mɨdən̰ gugɨrədɨ nɨm daa. ");
INSERT INTO sor_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Anə ha n̰urə kulɨm wodɨ gɨ jindar bwadɨ sandug di dugdɨdɨ dɨ wodɨ lə. Anə ha bwadɨ kulɨm di sɨr dugdɨdɨ dɨ ka lə me, sɨr dugdɨdɨ dɨ ta lə me. ");
INSERT INTO sor_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Ɨr̰ɨ anə ha saba habde nə chelbe sɨr ɗangr̰agɨ me, anə ha ɗangr̰a jindar ɨbdəgɨ sɨdəgɨ lə me. ");
INSERT INTO sor_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Anə ha hurba habde nə ta di mana gɨ kulɨm di dalawə ka me, ka me, dara yɨbə ugdə gɨ sandug di daa hára nɨm. ");
INSERT INTO sor_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Anə ha kala habde nə ta di mana gɨ kulɨm di dalawə jang, anə ha piyəgɨ dodə bədə. ");
INSERT INTO sor_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Sandug di dwar̰ɨ lə da, anə ha bwaa kur̰a dɨ ɓɨdɨr̰a ɓɨdɨr̰a dɨ nə ha janga bii ni gɨ ꞌwoo gaba yəə gandang mɨlan di lə. ");
INSERT INTO sor_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Anə ha ɗangr̰a sandug di bɨdɨ gɨ jindar sɨdɨ dɨ wed. Charni dɨra ha nyama dar̰e mɨn gɨ tulɨn̰ me, ɓɨlnani dɨra ha nyama dar̰e mɨn me ca. ");
INSERT INTO sor_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Anə ha ichə mani nə daa nə bajɨmagɨ ilə nə gɨ ꞌwogɨgɨ cherubẽ dúndɨrəgɨ sɨr gɨ jindar sandug di bɨdə, tulɨn̰ dɨ ka lə me, dɨ ka lə me ca. ");
INSERT INTO sor_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Cherubẽ nə sɨr ta di, anə ha gwabagɨ i sandug di bɨdə mɨn ꞌywaragɨ hára daa, gɨ mɨn tuldɨ dɨ ka lə me, gɨ mɨn tuldɨ dɨ ka lə me ca. ");
INSERT INTO sor_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Cherubẽ nə ta di, wi kaw ha cwaa dɨrəw ɨjə jaw sandug di dɨdə me ha dàra bajɨmaw daa sandug di dɨdə dara gamadɨ nɨm, me wi kaw ha yara dɨrəw dodə sandug di bɨdɨ lə me ca. ");
INSERT INTO sor_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Sandug di dwar̰ɨ lə da, anə ha bwaa kur̰a dɨ ɓɨdɨr̰a ɓɨdɨr̰a dɨ nə ha janga bii ni gɨ ꞌwoo gaba yəə gandang mɨlan di lə me, anə ha ꞌwoo sandug bɨdɨ di ɨbə sandug di dɨdə ɗyasadɨ nɨm daa. ");
INSERT INTO sor_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","I daa sandug di dɨdə me nə hára ɗɨbə lə, mana gɨ cherubẽ nə sɨr di bulə dayyə. I mana gɨ ta lə di me, nə ha wayam mani nə nə ùr nare nə Israyel ba àlnagɨ̀ bá bá di lə.» ");
INSERT INTO sor_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","«Anə ha ɗangr̰a tabɨl gɨ habde nə chelbe. Charni dɨra ha nyama dar̰e tuldɨ sɨr me, ɓɨlnani dɨra ha nyama dar̰e tuldɨ mɨn me, hwaa dɨra kaw ha nyama dar̰e mɨn me ca. ");
INSERT INTO sor_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Anə ha ɗangr̰a jindar sɨdɨ dɨ wed ɨbdədɨ sɨdə me, anə ha ɗangr̰a jindar bɨdə mɨdən̰ gugɨrədɨ nɨm daa me ca. ");
INSERT INTO sor_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Anə ha ɗangr̰a habde nə dugdɨdɨ lə cab cab, ɓɨlnani day ha nyama ɓɨlnani gɨnə ɨsəm dalaw mɨn me, anə ha ɗangr̰a jindar ɨbdəgɨ sɨdəgɨ lə mɨdən̰ gugɨrəgɨ nɨm daa me ca. ");
INSERT INTO sor_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Anə ha ɗangr̰a kulɨm wodɨ gɨ jindar bwadɨ tabɨl di dugdɨdɨ dɨ ɨrmər gɨ gɨdadɨ nə wodɨ di lə. ");
INSERT INTO sor_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","28","Kulɨm gɨ ta di, anə ha hurbaw i habde nə tabɨl dugdɨdɨ lə cab cab di sɨdəgɨ lə ib ib. Anə ha saba habde nə chelbe sɨr ɗangr̰agɨ me, anə ha ɗangr̰a jindar ɨbdəgɨ sɨdəgɨ lə me ca. Anə ha hurba habde nə ta di mana gɨ kulɨm di dalawə dara yɨbə ugdə gɨ tabɨl di daa hára nɨm. ");
INSERT INTO sor_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Tabɨl dɨ ta di, anə ha ɗangr̰adɨ subɨra dɨra me, kob dɨra me, pɨr̰ɨm dɨra me, anə ha ɗangr̰a mani woni bwan ɨndi gɨ Mãr̰ĩ gani gɨnə yabɨr̰a yàa duwa me. Mani nə pad ta di, anə ha ɗangr̰agɨ gɨ jindar sɨdɨ dɨ wed. ");
INSERT INTO sor_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Tabɨl dɨ ta di dɨdə da, anə ha chɨ́gdə mapa ni lə dara kal mapa di ina lə dɨrənnə gɨ wála wála.» ");
INSERT INTO sor_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","«Anə ha ɗangr̰a mani nə gangr̰agɨ wurgɨsubu nə gɨ chɨ́gdɨ lamba lə diiyə gɨ jindar sɨdɨ dɨ wed. Mani di gɨdɨragɨ me, sɨdəgɨ gɨ korgɨn̰ gɨ gangr̰e agdɨ lə me, kob day me, gur̰iya day me, mani nə wun ya habda hoo duwa de me, ha ꞌya lə. Anə ha ichəgɨ i gɨ jindar mɨn. ");
INSERT INTO sor_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Mani di sɨdəgɨ gɨ korgɨn̰yə da, gangr̰agɨ kubi ha ꞌya lə, nə subu ha agda hára tulɨn̰ dɨ ka lə me, nə subu ha agda hára tulɨn̰ dɨ ka lə me ca. ");
INSERT INTO sor_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Gangr̰agɨ nə kubi ta di, gangr̰agɨ gɨ mɨnnə bá bá da, kob ilə gur̰iya gɨ subu di sɨwə bá bá me, mani dɨra nə wun ya habda hoo duwa de kaw ha ꞌya lə bá bá me ca. ");
INSERT INTO sor_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Me mani di sɨdəgɨ gɨ korgɨn̰yə da, kob wodɨ gɨ gur̰iya me gɨ mani dɨra nə wun ya habda hoo duwa de me ha ꞌya lə. ");
INSERT INTO sor_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Mana gɨ mani gangr̰agɨ nə sɨr nə ha agda hára ka me, ka me ta di, gur̰iya ha ꞌya lə gɨndəgɨ lə bá bá. Gangr̰agɨ nə kubi ta di, gur̰iya ha ꞌya lə gɨndəgɨ lə gɨndəgɨ lə. ");
INSERT INTO sor_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Mani di gur̰iya day me gangr̰agɨ di me da, ha ichara i gɨ jindar mɨn, i gɨ jindar sɨdɨ dɨ wed. ");
INSERT INTO sor_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Anə ha ɗangr̰agɨ mani nə gangr̰agɨ wurgɨsubu di lamba day lə wurgɨsubu me ca. Me anə ha chɨ́gdə lamba di mani di dɨdəgɨ lə dara kal ácn̰ana mana bam mani di dɨrəgɨ lə. ");
INSERT INTO sor_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Anə ha ɗangr̰a mani woni jana lamba chire dɨra gɨ ꞌyo bam ɗɨm me, mani woni bwaa dɨbɨrɨn̰ dɨnə chire gɨ ꞌyo bam ɗɨm di lə me, gɨ jindar sɨdɨ dɨ wed. ");
INSERT INTO sor_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Anə ha ɗangr̰a mani nə gangr̰agɨ wurgɨsubu di me mani day nə pad di me i gɨ jindar sɨdɨ dɨ wed dɨ noo dɨra nem kilo gɨnɨn̰ subu. ");
INSERT INTO sor_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Ɨjɨm gɨ Moyis da, kal dɨrəm giyə gɨ nare ha àlàw ta di dɨwə, kal giyə di àlalna wunnə ya mani dúndɨrəgɨ nə nə ilə gɨləm gandagɨ lə kur̰a dɨdə ka di de dige dige.» ");
INSERT INTO sor_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: «Kundi gɨ nə ha dama lə da, anə ha ɗangr̰aw i gɨ barge mwaj gɨ anə kuw gɨ chire gɨ lade me, chire gɨ bor ngɨr ngɨr me, gɨ kwamge me, gɨ wusɨ bəliyə me. Barge gɨ mwaj di, anə ha kow sɨrandaw wunnə mani nə daa nə bajɨmagɨ ilə nə gɨ ꞌwogɨgɨ cherubẽ dúndɨrəgɨ. Ha ꞌya i giyə gɨnə mwar̰ə woni ꞌwacn̰a koo barge ladɨ day. ");
INSERT INTO sor_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Barge gɨ mwaj ta di, barge mɨn bá bá da, charni duwa ha nyama dar̰e mwaj dii dunasɨr gɨ tulɨn̰ me, ɓɨlnani duwa ha nyama dar̰e sɨr gɨ tulɨn̰ me. Barge di charni duwa me, ɓɨlnani duwa me, ha bwara mɨn pad. ");
INSERT INTO sor_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Anə ha busə barge gɨ jii r̰yandaw daa mɨn me, gɨ wor jii di kaw, anə ha busəw r̰yandaw daa mɨn me ca. ");
INSERT INTO sor_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","5","Barge gɨ jii gɨ busər r̰endər daa ta di, anə ha busəw gɨ bii lə ced chire gɨ lade gɨ bor ngɨr ngɨr gɨ kon̰bər daa gɨnɨn̰ jii bɨwə me, gɨ wor jii di kaw, anə ha busəw gɨ pii chire gɨ lade gɨ bor ngɨr ngɨr gɨ kon̰bər daa gɨnɨn̰ jii bɨwə me ca. Anə ha busəw bwara gɨ jaw di ca ca. ");
INSERT INTO sor_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Ɨr̰ɨ anə ha ɗangr̰a mani nə bɨdəgɨ kongdɨ gɨnɨn̰ jii gɨ jindar me, anə ha r̰yanda barge gɨ sɨr di daa gɨ mani nə bɨdəgɨ kongdɨ di. I yande me kundi di ha gɨdə mani mɨn. ");
INSERT INTO sor_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Ɨr̰ɨ anə ha koo barge gɨ wudɨn̰ nənə bage nə mee dara dàra kundi di dɨwə. Anə ha koo barge di i mwaj dii mɨn. ");
INSERT INTO sor_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Barge mɨn da, charni duwa ha nyama dar̰e gɨnɨn̰ sɨr me, ɓɨlnani duwa ha nyama dar̰e sɨr gɨ tulɨn̰ me. Barge gɨ mwaj dii mɨn ta di, charni duwa me, ɓɨlnani duwa me, ha bwara i mɨn pad. ");
INSERT INTO sor_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Anə ha busə barge gɨ jii r̰yandaw daa mɨn me, gɨ wor kubi di kaw, anə ha busəw r̰yandaw daa mɨn me ca. Me barge gaba kubiyə gɨ anə ha r̰yandaw gɨ jaw ta di, anə ha bwaa bɨw gɨ mɨn hára kundi ni di bɨw gaba ganda lə. ");
INSERT INTO sor_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Barge gɨ jii gɨ busər r̰endər daa ta di, anə ha busəw gɨ bii lə ced chire gɨ lade gɨ kon̰bər daa gɨnɨn̰ jii bɨwə me, gɨ wor kubi di kaw, anə ha busəw gɨ pii chire gɨ lade gɨ kon̰bər daa gɨnɨn̰ jii bɨwə me ca. ");
INSERT INTO sor_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Ɨr̰ɨ anə ha ɗangr̰a mani nə bɨdəgɨ kongdɨ gɨnɨn̰ jii gɨ biri gɨ bor ngɨr ngɨr me, anə ha hurba mani nə bɨdəgɨ kongdɨ daa ta di mana gɨ chire gɨ lade gɨ kon̰bər daa di sɨwə dara r̰yanda gɨ barge gɨ sɨr di daa. I yande me barge gɨ kundi ni dɨwə di ha gɨdə mani mɨn. ");
INSERT INTO sor_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Barge gɨ wudɨn̰ nənə bage nə mee di da, charni duwa ha ɗwaya kundi di le. Yande da, barge di bɨw gɨ wor dodə da, anə ha bwaw hára kundi ni di tarɨwə. ");
INSERT INTO sor_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Barge di ɓɨlnani duwa kaw ha ɗwaya barge gɨ pii gɨ anə ha kow gɨ chire gɨ lade di bam. Yande da, anə ha bwaw hára mana gɨ kundi gɨ nə ha dama lə di tulɨw dɨ ka lə me, dɨ ka lə me, ɗwaya jaw gɨ pii di bam dar̰e mɨn tuldɨ. I yande me barge di ha dàrara kundi ni dɨwə ladɨ bulag sɨn̰. ");
INSERT INTO sor_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Ɨr̰ɨ anə ha ɗangr̰a mani woni dàra kundi ni di dɨwə gɨ gare gɨ kulajɨ gɨnə gəgɨr̰ɨn̰je day gɨ gɨ borɨwe me, anə ha ɗangr̰a mani gɨ gare gɨ kulajɨ gɨ ɗang gɨ lade nan̰ me, anə ha dàragɨ kwandagɨ nə pii pad di dɨdəgɨ lə. ");
INSERT INTO sor_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Ɨr̰ɨ anə ha saba chelbe pɨlbəgɨ me anə ha jwagdagɨ dɨrəgɨ daa ɗangr̰an gɨ kundi gɨ nə ha dama lə di. ");
INSERT INTO sor_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Habde nə ta di, mɨn da, charni duwa ha nyama dar̰e wurgɨsubu gɨ tulɨn̰ me, ɓɨlnani duwa ha nyama dar̰e mɨn me. ");
INSERT INTO sor_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Habda mɨn da, anə ha ɗangr̰aw bɨw sɨr sɨr gaba hura dodə gɨdawə. Habde nənə kundi ni nə pad ta di, anə ha ɗangr̰agɨ yande. ");
INSERT INTO sor_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Anə ha ɗangr̰a habde gɨnɨn̰ sɨr kundi ni tulɨw dɨ ɨsay gɨ abeyə me, ");
INSERT INTO sor_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","anə ha ɗangr̰agɨ gɨdɨragɨ gɨnɨn̰ wodɨ gɨ tuda me. Habda mɨn da, anə ha ɗangr̰aw gɨdaw sɨr sɨr woni huraw lə yə̀w jwagaw nɨm dɨrəw daa, bor gɨ habda bɨw gɨ sɨr gaba hura gɨdaw lə di. ");
INSERT INTO sor_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Kundi ni tulɨw dɨ ɨsay gɨ jeleyə kaw, anə ha ɗangr̰a habde gɨnɨn̰ sɨr me, ");
INSERT INTO sor_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","gɨdɨragɨ gɨ tuda gɨnɨn̰ wodɨ me. Habda mɨn da, anə ha ɗangr̰aw gɨdaw di sɨr sɨr. ");
INSERT INTO sor_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Kundi ni tarɨwə, tulɨw dɨ turgɨ lə da, anə ha ɗangr̰a habde kubi lə me, ");
INSERT INTO sor_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","anə ha ɗangr̰a habde nə jiga sɨr lə me, mɨn mana gɨ dugdɨw dɨ targɨn̰ dɨ mɨnnə me, gɨ mɨn ɗang mana gɨ dugdɨw dɨ targɨn̰ dɨ ɗangə di me ca. ");
INSERT INTO sor_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Habde nə ta di, ha r̰yandara i dodə gɨndəgɨ lə gɨ kwandagɨ nə kundi ni dugdɨwə, me gɨra ha r̰yandara daa dɨdəgɨ lə kulɨm mɨn dalawə. Dugdɨw dɨ ɗangə di kaw, ha àlala i yande me ca. ");
INSERT INTO sor_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","I yande me habde dunasɨr me gɨdɨragɨ nə tuda mwaj dii kubi me ha ꞌya lə kundi tarɨw dɨ turgɨ lə. Habda mɨn da, gɨdaw i sɨr sɨr. ");
INSERT INTO sor_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Ɨr̰ɨ anə ha saba chelbe pɨlbə ɗangr̰agɨ woni dagɨla kwandagɨ nə dɨrəgɨ daa tɨba tɨba sɨdəgɨ lə yɨbəgɨ nɨm daa. Kundi ni tulɨw dɨ mɨnnə da, anə ha ɗangr̰a habde di i jii me, ");
INSERT INTO sor_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","tulɨw dɨ ɗangə kaw, anə ha ɗangr̰a habde nə woni dagɨla kwandagɨ nə dɨrəgɨ daa tɨba tɨba sɨdəgɨ lə yɨbəgɨ nɨm daa di jii me, tarɨwə, tulɨw dɨ turgɨ lə kaw, anə ha ɗangr̰a habde di i jii me ca. ");
INSERT INTO sor_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Kundi ni tulbəw nə subu lə di da,  habda gaba dagɨla kwandaw nə dɨrəgɨ daa tɨba tɨba sɨbɨr̰əgɨ lə bɨrad da, kal ina i habda mɨn gɨ chere swana kundi ni bɨw gɨ ka lə gandɨna bɨw gɨ alə ta lə bá. ");
INSERT INTO sor_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Habde woni jwagda dɨrəgɨ daa me, woni dagɨla kwandagɨ nə dɨrəgɨ daa tɨba tɨba di sɨdəgɨ lə yɨbɨgɨ nɨm daa me da, anə ha ɗangr̰a jindar ɨbdəgɨ sɨdəgɨ lə me, anə ha n̰urə kulɨm gaba hurba habde woni dagɨla kwandagɨ nə dɨrəgɨ daa tɨba tɨba di sɨdəgɨ lə yə̀gɨ daa di gɨ jindar me ca. ");
INSERT INTO sor_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Ɨjɨm gɨ Moyis da, gɨlgɨ nare ɗangr̰a gɨ kundi gɨ nə ha dama lə di, kal gɨ ɗangr̰ɨnaw bwarna gɨ kundi dúndɨw dɨ nə gɨləm gandɨdɨ kur̰a dɨdə ka di dige dige. ");
INSERT INTO sor_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Anə ha koo barge gɨ geche gɨ chire gɨ bor ngɨr ngɨr me, gɨ kwamge me, gɨ wusɨ bəliyə me, chire gɨ ɗang gɨ lade nan̰ me. Anə ha kow sɨrandaw wunnə mani nə daa nə bajɨmagɨ ilə nə gɨ ꞌwogɨgɨ cherubẽ dúndɨrəgɨ. Ha ꞌya i giyə gɨnə mwar̰ə woni ꞌwacn̰a koo barge ladɨ day. ");
INSERT INTO sor_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Anə ha saba chelbe wodɨ pɨlbəgɨ me, anə ha ɗangr̰a jindar ɨbdəgɨ sɨdəgɨ lə me, anə ha ɗangr̰agɨ gɨdɨragɨ wodɨ gɨ tuda me, anə ha hurbagɨ lə jwagdagɨ nɨm dɨrəgɨ daa. Ɨr̰ɨ anə ha maa barge di habde nə wodɨ di sɨdəgɨ lə gɨ mani nə bɨdəgɨ kongdɨ nə anə ha ɗangr̰agɨ gɨ jindar di. ");
INSERT INTO sor_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Anə ha maa barge di mana gɨ mani nə bɨdəgɨ kongdɨ di bɨdəgɨ gɨ dodə lə. I mana gɨ barge gɨ ta di tarɨwə me anə ha chə́ə sandug ni dɨ idɨ gama kur̰a dɨ ɓɨdɨr̰a ɓɨdɨr̰a dɨ nə ha janga bii ni gɨ ꞌwoo gaba yəə gandang mɨlan di lə. Barge gɨ ta di da, ha ꞌya i aba saba kundi ni di dodə korgɨn̰ sɨr. Mana gɨ mɨn da, i mana ni gɨ wun mɨnaw jiga me, gɨ mɨn ɗang da, i gɨ wun mɨnaw jiga ɗoy bam me. ");
INSERT INTO sor_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Anə ha ꞌwoo sandug bɨdɨ di ɨbə sandug di dɨdə ɗyasadɨ nɨm daa chə́dɨ mana gɨ wun mɨnaw jiga ɗoy bam di lə. ");
INSERT INTO sor_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Anə ha chə́ə tabɨl dɨ idɨ chɨ́gdən ɨndi gɨ Mãr̰ĩ mapa lə diiyə di mana gɨ barge di dɨrəwə, kundi ni di dalawə tulɨn̰ dɨ ɨsay gɨ jeleyə, me anə ha chə́ə mani nə gangr̰agɨ wurgɨsubu nə gɨ chɨ́gdɨ lamba lə diiyə di mana gɨ tabɨl di dɨrədɨ lə ɗən̰, kundi ni di dalawə tulɨn̰ dɨ ɨsay gɨ abeyə me. ");
INSERT INTO sor_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Anə ha koo barge gɨ geche gaba maa kundi ni bɨwə sɨrandaw gɨ chire gɨ bor ngɨr ngɨr me, gɨ kwamge me, gɨ wusɨ bəliyə me, chire gɨ ɗang gɨ lade nan̰ me. Ha ꞌya i giyə gɨnə mwar̰ə woni ꞌwacn̰a sɨranda ladɨ day. ");
INSERT INTO sor_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Anə ha saba chelbe jii pɨlbəgɨ me, anə ha ɗangr̰a jindar ɨbdəgɨ sɨdəgɨ lə me. Anə ha n̰urə gɨdɨragɨ jii gɨ biri gɨ bor ngɨr ngɨr me, anə ha hurbagɨ lə jwagdagɨ nɨm dɨrəgɨ daa. Ɨr̰ɨ anə ha maa barge di habde nə jii di sɨdəgɨ lə gɨ mani nə bɨdəgɨ kongdɨ nə anə ha ɗangr̰agɨ gɨ jindar di.» ");
INSERT INTO sor_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: «Anə ha ɗangr̰a mana gaba bwasan gɨ habde nə chelbe. Charni duwa me, ɓɨlnani duwa me, ha bwara le, ha nyama dar̰e subu gɨ tulɨn̰ tulɨn̰. Hwaa duwa da, ha nyama dar̰e sɨr. ");
INSERT INTO sor_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Mana gaba bwasan di, anə ha ɗangr̰aw dugdɨw dɨ wodɨ dɨ ha swara daa ya hugdi de. Hugdi nə ta di ha swaa i sɨwə gang. Anə ha ichə biri gɨ bor ngɨr ngɨr huraw tarɨwə me ca. ");
INSERT INTO sor_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Ɗang da, anə ha ɗangr̰aw mani woni laya dɨbɨrɨn̰ dɨ gɨ ul mani nə paga lə di bam me, pel me, kob dɨ idɨ ꞌwoo bare me, mani woni cwagda kabni gɨ dùwa lə daa daa me, mani woni laya gur̰ɨn̰ə me ca. Mani nə pad ta di, anə ha ɗangr̰agɨ i gɨ biri gɨ bor ngɨr ngɨr. ");
INSERT INTO sor_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Mana gaba bwasan di, anə ha ɗangr̰aw biri dagɨlaw jaw sɨwə sɨwə me, anə ha ɗangr̰a kulɨm wodɨ hurbaw dugdɨw dɨ wodɨ lə biri di sɨwə sɨwə me. ");
INSERT INTO sor_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Anə ha hura biri di mana gaba bwasan di korgɨn̰ sɨbɨr̰əwə bɨrad. Biri gɨ ta di ha ꞌya i mana gɨ bɨw gɨ mɨdən̰ gɨndɨw dɨ dodə lə. ");
INSERT INTO sor_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Ɨr̰ɨ mana gaba bwasan di, anə ha sabaw habde nə chelbe sɨr pɨlbəgɨ ɗangr̰agɨ me, anə ha ichə biri gɨ bor ngɨr ngɨr hurbagɨ sɨdəgɨ lə me ca. ");
INSERT INTO sor_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Anə ha hurba habde nə ta di mana gɨ kulɨm di dalawə dara yɨbəgɨ ugdə gɨ mana gaba bwasan di daa hára nɨm. ");
INSERT INTO sor_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Mana gaba bwasan di, anə ha ɗangr̰aw gɨ habde kala dalaw gubu, kal wunnə ya dúndɨw dɨ nə gɨləm gandɨdɨ mana gɨ kur̰a dɨdə ka di de dige dige.» ");
INSERT INTO sor_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","«Anə ha aja ciri jáa gɨ kundi gɨ nə ha dama lə di daa dara kal ciri dwar̰ɨ ina lə. Anə ha jáw i gɨ barge gɨ gɨ kuw gɨ chire gɨ lade. Tuldɨ dɨ ɨsay gɨ abeyə da, ciri di charni dɨra ha nyama dar̰e gɨnɨn̰ kubi gɨ dii kubi. ");
INSERT INTO sor_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","11","Anə ha koo barge di me, pɨlbə habde woni hurba dɨrəgɨ daa tɨba tɨba dara maa gɨ barge di lə gɨnɨn̰ sɨr me, ɗangr̰a gɨdɨragɨ woni yɨbəgɨ daa gɨ biri gɨ bor ngɨr ngɨr gɨnɨn̰ sɨr me ca. Me mani day nə bɨdəgɨ kongdɨ woni yəə barge dàraw nɨm daa di me, biri day gaba maa gɨ barge me da, anə ha ɗangr̰a i gɨ tuda. Kundi di tulɨw dɨ ɨsay gɨ jeleyə kaw, ha ꞌya yande me ca. ");
INSERT INTO sor_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Ciri dɨ jə́ kundi ni daa di, ɓɨlnani dɨra dɨ tulɨn̰ dɨ turgɨ lə da, barge gaba jádɨ nɨm di nem dar̰e gɨnɨn̰ subu gɨ dii subu. Anə ha koo barge di me, pɨlbə habde woni hurba dɨrəgɨ daa tɨba tɨba dara maa gɨ barge di lə mwaj me, ɗangr̰a gɨdɨragɨ woni yɨbəgɨ daa mwaj me ca. ");
INSERT INTO sor_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Ciri di ɓɨlnani dɨra dɨ tulɨn̰ dɨ jomniyə kaw, ha nyama dar̰e gɨnɨn̰ subu gɨ dii subu me ca. ");
INSERT INTO sor_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","15","Ciri bɨdɨ ha ꞌya lə tulɨn̰ dɨ ta lə di. Ciri bɨdɨ di tuldɨ dɨ mɨn da, barge dɨra charni duwa ha nyama dar̰e mwaj. Anə ha koo barge di me, pɨlbə habde woni hurba dɨrəgɨ daa tɨba tɨba dara maa gɨ barge di lə subu me, ɗangr̰a gɨdɨragɨ woni yɨbəgɨ daa gɨ biri gɨ bor ngɨr ngɨr subu me ca. Ciri bɨdɨ di tuldɨ dɨ ɗangə di kaw, ha ꞌya yande me ca. ");
INSERT INTO sor_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Ciri bɨdɨ di sɨdɨ dɨra da, anə ha koo barge gɨ geche sɨrandaw gɨ chire gɨ bor ngɨr ngɨr me, gɨ kwamge me, gɨ wusɨ bəliyə me, chire gɨ ɗang gɨ lade nan̰ me dara maa lə. Ha ꞌya i giyə gɨnə mwar̰ə woni ꞌwacn̰a sɨranda barge ladɨ day. Barge gɨ ta di charni duwa da, ha nyama dar̰e mwaj dii subu. Anə ha dàraw i mana gɨ habde nə hurbər dɨrəgɨ daa tɨba tɨba wodɨ sɨdəgɨ lə. Habde nə wodɨ ta di, anə ha hurbagɨ i mana gɨ biri gɨ bor ngɨr ngɨr gɨ anə ha hurbaw dodə wodɨ sɨwə. ");
INSERT INTO sor_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Habde pad nə hurbər dɨrəgɨ daa tɨba tɨba liw ciri daa di da, mani day nə bɨdəgɨ kongdɨ woni yəə barge dàraw nɨm daa di me, biri gaba maa gɨ barge me di da, anə ha ɗangr̰a i gɨ tuda me, gɨdɨragɨ da, anə ha ɗangr̰agɨ i gɨ biri gɨ bor ngɨr ngɨr me ca. ");
INSERT INTO sor_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Ciri di charni dɨra ha nyama dar̰e gɨnɨn̰ kubi gɨ dii kubi gɨ tulɨn̰ me, ɓɨlnani dɨra ha nyama dar̰e gɨnɨn̰ subu gɨ dii subu me, hwaa dɨra kaw, ha nyama dar̰e subu gɨ tulɨn̰ me ca. Barge dɨra da, anə ha kow gɨ chire gɨ lade me, mani woni yɨbə habde nə hurbər dɨrəgɨ daa tɨba tɨba da, anə ha ɗangr̰agɨ i gɨ biri gɨ bor ngɨr ngɨr me ca. ");
INSERT INTO sor_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Kundi gɨ nə ha dama lə di me, ciri dɨ liw daa di me da, anə ha ɗangr̰a mani day pad i gɨ biri gɨ bor ngɨr ngɨr me, mani day woni ɓabɨr̰a dodə dara magdagɨ nɨm kaw, anə ha ɗangr̰agɨ i gɨ biri gɨ bor ngɨr ngɨr me ca.» ");
INSERT INTO sor_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","«Ɨjɨm gɨ Moyis da, mə ha wayagɨ nare nə Israyel kal gɨ ꞌyànám swani sɨw gɨ wed gɨ lade nan̰ gɨnə habda gɨ olib duwa. Swani di ha bwara lamba dɨ wurgɨ subu di lə dara kɨrə gɨ dùwa lə gɨ turgɨ bá bá. ");
INSERT INTO sor_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","I kundi gaba ɓamara gandɨn ɨndi gɨ Mãr̰ĩ dalawə di me, Arõ day gɨ nə dɨndaw di ha ɗangr̰a lamba di me chɨ́gdɨdɨ mana dɨra lə, mana gɨ barge gaba lɨgə sandug ni dɨ idɨ gama kur̰a dɨ idɨ mɨlan ɨnda di dɨrəwə. Lamba di, ha dama i gɨ ꞌywaa jang ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ di dɨrənnə gɨ turgɨ bɨraa mana ha wála nɨm. Ta di me i bii gɨ ꞌwoo gɨ dam gɨ dɨrəw bɨr̰ɨn̰. Kal ꞌyeni nare nə Israyel gɨ swaa dan bá bá da, kalna dusɨrəng bii gɨ ꞌwoo di dɨwə gɨ dɨrɨn̰ bɨr̰ɨn̰.» ");
INSERT INTO sor_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: «Ɨjɨm gɨ Moyis di, ꞌwagay chendɨm gɨ Arõ day gɨ nə dɨndaw nə Nadab me, Abiyu me, Eliyajar me Itamar me sɨmmə. Mə ha biyəgɨ bam jiga nare nə Israyel dwar̰agɨ lə dara kal cendi ina i woni bwasan. ");
INSERT INTO sor_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Mə ha kow Arõ barge gaba sumi gɨ wun mɨnaw jiga gɨ wundər gɨ giyə duwa gɨ àla di. ");
INSERT INTO sor_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Yande da, mə ha wayagɨ mwar̰ə pad nə nə ꞌyàgɨ́ dɨrɨn̰ naa dɨ idɨ koo gɨ barge gɨ ta di. I cendi me ha kow Arõ barge di dara ba gɨ biynəw chɨ́nəw nɨm jiga giyə duwa gaba bwasan lə. ");
INSERT INTO sor_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Barge gɨ cendi ha kow di me i ta: bos duwa gɨ jorgɨwə me, barge gaba hura bwasan me, gumaj duwa me, gumaj gɨ jaw dalawə gɨ sɨrande me, barge gaba lyagɨra dii daa me, mani woni maa wamdeyə me. Cendi ha kow Arõ day gɨ nə dɨndaw barge gɨ wun mɨnaw jiga di dara cendi ba bwasɨnan nɨm. ");
INSERT INTO sor_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Cendi ha koo barge di gɨ chire gɨ lade me, chire gɨ bor ngɨr ngɨr me, gɨ kwamge me, gɨ wusɨ bəliyə me, ha sɨrandaw gɨ jindar me ca.» ");
INSERT INTO sor_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","«Barge gaba hura bwasa gɨ Mãr̰ĩ da, ha ꞌya i giyə gɨnə mwar̰ə woni ꞌwacn̰a koo barge ladɨ day. Cendi ha koo barge di i gɨ chire gɨ bor ngɨr ngɨr me, gɨ kwamge me, gɨ wusɨ bəliyə me, chire gɨ ɗang gɨ lade nan̰ me, ha sɨrandaw gɨ jindar me ca. ");
INSERT INTO sor_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Gɨ ha koo sade sɨr woni yə̀w nɨm daa bar̰ɨmawə ka me, ka me. ");
INSERT INTO sor_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Sade woni yə̀w maw nɨm dodə tarɨwə kaw, gɨ ha kogɨ ya ta de me ca: gɨ ha koo i gɨ chire gɨ bor ngɨr ngɨr me, gɨ kwamge me, gɨ wusɨ bəliyə me, chire gɨ ɗang gɨ lade nan̰ me, gɨ ha sɨrandagɨ gɨ jindar me ca. Sade nə ta di, ha swaa i barge gaba hura bwasa gɨ Mãr̰ĩ di sɨwə mɨn. ");
INSERT INTO sor_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Anə ha laya kur̰a dɨ komɨn̰ dɨ idɨ sumi sɨr me, anə ha janga Israyel dɨndaw sumdəgɨ lə sɨdə. ");
INSERT INTO sor_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Anə ha janga sumi kubi kur̰a dɨ mɨnnə me, kubi kur̰a dɨ ɗangə me. Sumi di ha pama jaw tarɨw gɨ yàa duwa, yàa duwa. ");
INSERT INTO sor_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Gun gaba ꞌwacn̰a janga sumi kur̰a sɨdə ladɨ ha janga Israyel dɨndaw sumdəgɨ di mana gɨ kur̰a dɨ sɨr di sɨdə me, ha ɗangr̰a mani sɨr bar̰ɨmawə ka me, ka me woni yəə kur̰a di daa gɨ jindar. ");
INSERT INTO sor_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Anə ha maa kur̰a dɨ sɨr di mana gɨ barge gaba hura bwasa gɨ Mãr̰ĩ sade duwa nə bar̰ɨmawə di. Kur̰a dɨ ta di, sumi gɨnə gangle gɨnə nare nə Israyel day nə mwaj dii sɨr di ilə sɨdə. I ta di me Arõ ha hura sumdəgɨ mana gɨ bar̰ɨmawə ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ di dɨrənnə, me ha ꞌya i mani woni gon dusɨn daa dɨdəngə.» ");
INSERT INTO sor_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","«Anə ha ɗangr̰a mani sɨr woni yəə bos gɨ woni bwasa Mãr̰ĩ geche day ha hura jorgɨwə daa gɨ jindar me, ");
INSERT INTO sor_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","anə ha ɗangr̰a sul sɨr gɨ jindar sɨdɨ dɨ wed, wunnə ya sade nə lɨmə de. Anə ha maa sul di mana gɨ mani nə sɨr woni yəə bos gɨ jorgɨwə daa di sɨdəgɨ lə. ");
INSERT INTO sor_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Anə ha ɗangr̰a bos gɨ woni bwasa Mãr̰ĩ geche day ha hura jorgɨwə. Bos gɨ ta di, an̰ji ha bwaa mani woni yara ɨrmə ni ɨndi gɨ Mãr̰ĩ lə. Ha ꞌya i giyə gɨnə mwar̰ə woni ꞌwacn̰a ɗangr̰a mani ladɨ day. Anə ha ɗangr̰aw ya anə banə ha ɗangr̰a gɨ barge gaba hura bwasa gɨ Mãr̰ĩ ta de: Anə ha ɗangr̰aw gɨ chire gɨ bor ngɨr ngɨr me, gɨ kwamge me, gɨ wusɨ bəliyə me, chire gɨ ɗang gɨ lade nan̰ me, anə ha sɨrandaw gɨ jindar me ca. ");
INSERT INTO sor_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Anə ha ɗangr̰aw kwajaw daa dudi sɨr mwom da, charni duwa me, ɓɨlnani duwa me, ha bwara le, ha nyama ɨsəm dalaw charni duwa mɨn gɨ tulɨn̰ tulɨn̰. ");
INSERT INTO sor_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Anə ha hurba kur̰a dɨ ladɨbe dɨ idɨ sumi kɨrədɨ ɗar̰ar̰a ɗar̰ar̰a wodɨ bos di sɨwə. Kur̰a dɨ kɨrər mana gɨ piiyə da, ha ꞌya i kur̰a dɨ komɨn̰ kivbing me, dɨ labe swani duwa me, dɨ dwaga bajadɨ me. ");
INSERT INTO sor_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Kur̰a dɨ kɨrər mana gɨ sɨrrə da, ha ꞌya i kur̰a dɨ gichəw cilɨm me, dɨ ꞌyogde me, dɨ ꞌyele ꞌyil me. ");
INSERT INTO sor_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Kur̰a dɨ kɨrər mana gɨ subu lə da, ha ꞌya i kur̰a dɨ buchi me, dɨ sɨrande me, dɨ bor ngɨr ngɨr me. ");
INSERT INTO sor_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Kur̰a dɨ kɨrər mana gɨ wodɨ lə da, ha ꞌya i kur̰a dɨ wusɨ bəliyə me, dɨ komɨn̰ me, dɨ gichəw sɨlɨm sɨlɨm me. Kur̰a dɨ ta di, mani woni yɨbədɨ dodə bos sɨwə di, anə ha ɗangr̰agɨ i gɨ jindar. ");
INSERT INTO sor_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Kur̰a di, ha ꞌya i mwaj dii sɨr ɨrmər gɨ gangle gɨnə nare nə Israyel day di. Kur̰a mɨn sɨdə bá da, anə ha janga Israyel gorndɨw mɨn sumɨw lə bá bá. Giyə gɨ ta di, ha ꞌya gɨnə gun gaba ꞌwacn̰a janga sumi kur̰a sɨdə ladɨ duwa. ");
INSERT INTO sor_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Bos dugdɨwə da, anə ha ɗangr̰a sul sɨr gɨ jindar sɨdɨ dɨ wed, wunnə ya sade nə lɨmə de me, ");
INSERT INTO sor_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","anə ha n̰urə kulɨm sɨr gɨ jindar hurbaw bos di dugdɨw dɨ sɨr dɨ daa lə me ca. ");
INSERT INTO sor_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Anə ha bwaa sul gɨ sɨr di bɨw mana gɨ kulɨm gɨ sɨr gɨ bos dugdɨw dɨ daa lə ka me, ka me. ");
INSERT INTO sor_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Me bɨw gɨ ɗang da, anə ha bwaa mana gɨ mani sɨr woni yəə bos di daa barge gaba hura bwasa gɨ Mãr̰ĩ di sɨwə me ca. Mani woni yəə bos daa ta di i mana gɨ barge gaba hura bwasa gɨ Mãr̰ĩ sade duwa nə bar̰ɨmawə di. Anə ha bwaa sul di i mana gɨ barge di dɨrəwə. ");
INSERT INTO sor_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Anə ha n̰urə kulɨm sɨr gɨ jindar hurbaw bos dugdɨw dɨ sɨr dɨ dodə lə, tulɨw dɨ korgɨn̰ dɨ ɓɨləl gɨ barge gaba hura bwasa gɨ Mãr̰ĩ di. ");
INSERT INTO sor_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Anə ha n̰urə kulɨm sɨr gɨ jindar ɗang bi hurbaw mana gɨ barge gaba hura bwasa gɨ Mãr̰ĩ sade duwa nə bar̰ɨmawə bɨdəgɨ nə dodə lə. Anə ha hura kulɨm di i mana gɨ barge di dɨrəwə, sade duwa woni yə̀w maw nɨm dodə tarɨwə di dɨdəgɨ lə. ");
INSERT INTO sor_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Anə ha maa sade nə bor ngɨr ngɨr mana gɨ kulɨm gɨnə bos duwa di bɨwə me gɨnə barge gaba hura bwasa gɨ Mãr̰ĩ bɨwə me ɓamagɨ daa, dara kal bos di ba damna mana gɨ barge gaba hura bwasa gɨ Mãr̰ĩ sade duwa woni yə̀w maw nɨm dodə tarɨwə di dɨdəgɨ lə mana mɨn jang. ");
INSERT INTO sor_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","I ta di me, mana gɨ Arõ dara ganda mana ni gɨ wun mɨnaw jiga lə da, an̰ji ha hura Israyel dɨndaw sumdəgɨ mana gɨ bos gɨ jorgɨwə ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ di dɨrənnə, me ha ꞌya i mani woni gon dusɨn daa dɨdəngə. ");
INSERT INTO sor_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Ɨjɨm gɨ Moyis da, mə ha bwaa mani woni ꞌwacn̰a ɨrmə ni nə gɨ ꞌwogɨgɨ “urim” me “tumim” me mana gɨ bos lə di. Yande da, mana gɨ Arõ hane ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ di dɨrənnə bá bá da, cendi ha ꞌya lə jorgɨwə. I ta di me, mani woni ꞌwacn̰a ɨrmə ni nare nə Israyel dɨdəgɨ lə da, an̰ji ha huragɨ jorgɨwə gɨ wála wála ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ di dɨrənnə.» ");
INSERT INTO sor_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","«Gumaj gaba hura barge gaba hura bwasa gɨ Mãr̰ĩ dalawə di sɨw duwa pad da, anə ha kow gɨ chire gɨ bor ngɨr ngɨr. ");
INSERT INTO sor_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Anə ha kala bɨw gɨ woni bwasan geche day ha hura gɨ dɨw lə. Bɨw gɨ ta di, i aba ꞌwacn̰a koo barge ladɨ me ha bagaw daa an̰ju dara kal ba chawarna bam bədə. ");
INSERT INTO sor_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Gumaj bɨw gɨ dodə lə cab cab da, anə ha magda habda gɨ gɨ ꞌwogɨw gɨrənad yàa duwa dúndɨw me, dendɨle me. Gɨrənad yàa duwa da, anə ha ɗangr̰aw i gɨ chire gɨ bor ngɨr ngɨr me, gɨ kwamge me, gɨ wusɨ bəliyə me. Dendɨle da, anə ha ɗangr̰adɨ i gɨ jindar. ");
INSERT INTO sor_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Dendɨle di me gɨrənad di me da, anə ha magdagɨ kɨlangagɨ le kɨlangagɨ le. ");
INSERT INTO sor_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Arõ ha hura gumaj gɨ ta di sɨwə hára nɨm dɨrənnə mana ni gɨ nə biyɨw kalɨw wun mɨnaw jiga lə ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ di dara àlán gɨ giyə ni. Mana gɨ an̰ji dara dɨmə hára kulə me, dara dɨmə bam iche me da, gɨ ha dwaya dendɨle nɨmə dɨra me an̰ji ha mara bədə. ");
INSERT INTO sor_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Anə ha ɗangr̰a mani gɨ jindar sɨdɨ dɨ wed me, gun gaba ꞌwacn̰a janga sumi jindar sɨdə ladɨ ha janga sɨdəgɨ lə ba da: Aba dama gɨ dɨrəw bɨr̰ɨn̰ biyən chɨ́n jiga. ");
INSERT INTO sor_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Anə ha maa mani nə ta di gɨ sade nə bor ngɨr ngɨr mana gɨ barge gɨ woni bwasa Mãr̰ĩ geche day legɨrɨw dɨwə bɨw gɨ jin̰jɨwə dɨwə. ");
INSERT INTO sor_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Yande da, mana gɨ Arõ hane ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ di dɨrənnə bá bá da, cendi ha ꞌya lə jin̰jɨwə. I ta di me mani nə nare nə Israyel biygɨ chɨ́n jiga me hára nɨm ꞌyàn di, ina i gɨ bɨrmə day bədə kaw, nə yarna mani di lə jin̰jɨwə di mwom da, nə ha yəə mani di le ɨsɨragɨ lə gɨ dusɨn dɨ lade me, Arõ di ha ꞌywaa wamani bədə. ");
INSERT INTO sor_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Anə ha koo gumaj gɨ woni bwasa Mãr̰ĩ geche day ha hura jaw dalawə gɨ chire gɨ lade me, barge gɨ an̰ji ha lyagɨra dɨwə di kaw, anə ha kow gɨ chire gɨ lade me ca. Me mani woni maa wamdawə da, anə ha kogɨ sɨrandagɨ le.» ");
INSERT INTO sor_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","«Arõ dɨndaw kaw, anə ha kogɨ i barge gaba sumi gɨ wun mɨnaw jiga gɨ wundər gɨ giyə day gɨ àla di. Anə ha kogɨ gumaj me, mani woni maa wamdagɨ lə me, mani woni hura dɨdəgɨ lə me ca. ");
INSERT INTO sor_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Ɨjɨm gɨ Moyis di, mə ha huraw chendɨm gɨ Arõ me, dɨndaw me barge sɨdəgɨ lə. Mə ha tidɨrəgɨ swani dɨdəgɨ lə me, mə ha chɨ́gdəgɨ giyə day gɨ àla lə. Mə ha biyən gandagɨ jiga me, cendi ha àla i giyə gaba bwasan. ");
INSERT INTO sor_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Anə ha kogɨ galsõ gɨ chire gɨ lade dara lɨgə gɨ gɨndəgɨ. Galsõ di charni duwa ha swaa wamdagɨ lə hára durbəgɨ lə bá. ");
INSERT INTO sor_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Arõ day gɨ nə dɨndaw ha hura mani nə ta di sɨdəgɨ lə i wála gɨ cendi ha hára dɨrənnə bá bá dara àlán gɨ giyə ni: Mana gɨ cendi gandɨna hana kundi gaba ɓamara gandɨn ɨndi gɨ Mãr̰ĩyə labaa, cendi hana mana gaba bwasan lə da, cendi ha hura mani nə ta di sɨdəgɨ lə. Cendi àlna yande mwom da, gwale ha ꞌya lə dɨdəgɨ lə bədə me, cendi ha mara bədə me ca. Ta di me i bii gɨ ꞌwoo gɨ dam gɨ dɨrəw bɨr̰ɨn̰. Kal Arõ me, dɨndaw me, gɨ swaa day bá bá me da, kalna dusɨrəgɨ bii gɨ ꞌwoo di dɨwə gɨ dɨrɨn̰ bɨr̰ɨn̰.» ");
INSERT INTO sor_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","«Ɨjɨm gɨ Moyis di, mani nə mə ha àlagɨ̀ dara chɨ́gdə gɨ nə Arõ day gɨ nə dɨndaw giyə day gaba bwasan lə di me i ta: Mə ha yəə labe gɨ abe mɨn me, gəgɨr̰ɨn̰je sɨr me. Kal mani nə paga nə ta di, mani nə àcn̰e hin̰e kaw ina lə sɨdəgɨ lə bədə. ");
INSERT INTO sor_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Mə ha joo burə gɨ geme me, mə ha piyə gɨ mapa gɨ dɨban musbu me, bangaso gɨ dɨban musbu gɨ mə ha kwayaw gɨ swani me, bangaso gɨ dine gɨ dɨban musbu gɨ mə ha tidɨrəw swani sɨwə me ca. ");
INSERT INTO sor_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Mə ha bwaa mani nə mə ha piyəgɨ ta di pad kɨrangè mɨn dalawə me, mə ha yəə labe di me, gəgɨr̰ɨn̰je nə sɨr di me, ɓamagɨ háran nɨm dɨrənnə. ");
INSERT INTO sor_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Mə ha hára gɨ Arõ day gɨ nə dɨndaw di kundi gaba ɓamara gandɨn ɨndi gɨ Mãr̰ĩ di bɨwə me, kalgɨ gɨ wiyna sɨdəgɨ bam. ");
INSERT INTO sor_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Ɨr̰ɨ mə ha laya barge gaba bwasan ɨndi gɨ Mãr̰ĩ di huraw Arõ sɨwə, barge gɨ ta di, i barge gɨ gumaj dalawə me, gumaj me, barge gaba hura bwasa gɨ Mãr̰ĩ me, bos gɨ jorgɨwə me. Mə ha maw wamdaw daa gɨ sade nənə barge gaba hura bwasan nɨm di me ca. ");
INSERT INTO sor_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Mə ha lyagɨraw barge gaba lyagɨra gɨ dii daa dɨwə me, mə ha huraw mani nə gɨ ɗangr̰ɨgɨ gɨ jindar me gɨ jangɨ lə sɨdəgɨ lə ba, Aba dama gɨ dɨrəw bɨr̰ɨn̰ biyən chɨ́n jiga di barge gɨ mə legɨrɨw dɨwə di bɨwə me ca. ");
INSERT INTO sor_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Ɨr̰ɨ mə ha ꞌwoo swani ni gaba tidɨrə diiyə tidɨrəw dɨwə biyəw chə́w nɨm giyə duwa lə jiga. ");
INSERT INTO sor_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Ɨr̰ɨ mə ha hára gɨ Arõ dɨndaw di dɨrənnə me, mə ha hurbagɨ barge day di sɨdəgɨ lə me ca. ");
INSERT INTO sor_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Mə ha magdagɨ nə Arõ day gɨ nə dɨndaw mani woni ma wamde daa wamdagɨ lə me, mə ha lyagɨragɨ barge gaba lyagɨra gɨ dii daa dɨdəgɨ lə me ca. So wála gɨ ta lə di da, cendi ha ꞌya i woni bwasan gɨ dɨrɨn̰ bɨr̰ɨn̰. Ta di me i bii gɨ ꞌwoo gɨ dam gɨ dɨrəw bɨr̰ɨn̰. Me mani nə mə ha àlagɨ̀ dara chɨ́gdə gɨ nə Arõ day gɨ nə dɨndaw giyə day gaba bwasan lə di me i ta: ");
INSERT INTO sor_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Mə ha yəə labe di hára nɨm mana gɨ ciri dɨ jə́ kundi gaba ɓamara gandɨn ɨndi gɨ Mãr̰ĩ daa di bɨdɨ dɨ korgɨn̰yə me, nə Arõ day gɨ nə dɨndaw ha bwaa ɨsɨragɨ labe di dɨwə. ");
INSERT INTO sor_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Mwom da, mə ha kundəw ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ dɨrənnə mana gɨ ciri dɨ jə́ kundi gaba ɓamara gandɨn daa di bɨdə. ");
INSERT INTO sor_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Mə ha udə bare gɨnə labe di hin̰e ɗagda habde nənə mana gaba bwasan di dugdɨw dɨ wodɨ dɨ sor daa ya hugdi de di sɨdəgɨ lə gɨ dunɨm me, bare di gɨndɨw dɨ wor pad da, mə ha dwalaw dodə mana gaba bwasan di gɨdawə me ca. ");
INSERT INTO sor_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Mə ha biyə swani gɨ labe nudəw nə dineyə me nə gecheyə me, mə ha sawa chara bɨw di me, swagə nə dór̰e me swani day gɨ sɨdəgɨ lə me ca. Mə ha ulə mani nə ta di bam pad mana gaba bwasan di dɨwə. ");
INSERT INTO sor_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Ɗɨm da, labe di kabni duwa me, gare duwa me, nudəw me da, mə ha layagɨ hára nɨm bam mana dan gɨ dama di tarɨwə me, mə ha uləgɨ bam. Ta di, i sarga dɨ idɨ biyəgɨ woni bwasan àcn̰a day bam di. ");
INSERT INTO sor_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Ɗang da, mə ha yəə gəgɨr̰ɨn̰ di mɨn me, nə Arõ day gɨ nə dɨndaw ha bwaa ɨsɨragɨ dɨwə. ");
INSERT INTO sor_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Mə ha kundə gəgɨr̰ɨn̰ di me, mə ha ꞌwoo bare duwa chìgdəw mana gaba bwasan di tarɨwə cab cab gugɨrəw nɨm daa. ");
INSERT INTO sor_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Mə ha saba kabni gɨnə gəgɨr̰ɨn̰ di dodə me, mə ha bwaa ɓama gɨ dɨw ca mana gaba bwasan di dɨwə me, mə ha bujə nudəw bam me, mə ha wiya gɨdaw bam me bwaa lə kabni di dɨwə. ");
INSERT INTO sor_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Mə ha ulə gəgɨr̰ɨn̰ di bam pad mana gaba bwasan di dɨwə. Ta di me i mani woni ulə àlán gɨ ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ sarga di. I sarga dɨ ɨr̰aw dɨra ꞌyolɨn ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ di. ");
INSERT INTO sor_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Ɨr̰ɨ mə ha yəə gəgɨr̰ɨn̰ gɨ wor mɨn di me, nə Arõ day gɨ nə dɨndaw ha bwaa ɨsɨragɨ dɨwə. ");
INSERT INTO sor_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Mə ha kundə gəgɨr̰ɨn̰ di me, mə ha ꞌwoo bare duwa me, mə ha ɗaw Arõ sumɨw gɨ ɨsəw gɨ abeyə bɨw gɨ dodə ced lə me, mana gɨ dɨndaw dayyə me ca. Mə ha ɗagdagɨ bare di mana gɨ gɨm day gɨ geche gɨ ɨsɨragɨ gɨ abeyə bá bá me, gɨ geche gɨ gɨdɨragɨ nə abjeyə bá bá me ca. Mə ha chìgdə bare gɨndɨw gɨ wor di mana gaba bwasan tarɨwə cab cab gugɨrəw nɨm daa. ");
INSERT INTO sor_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Mə ha udə bare gɨ i mana gaba bwasan dɨwə di hin̰e me, mə ha ꞌwoo swani ni gaba tidɨrə diiyə di hin̰e me chìgdəw Arõ dɨwə me, barge duwa lə me. Mə ha chɨ̀gdəgɨ dɨndaw dɨdəgɨ lə me, barge dayyə me ca. Yande da, Arõ me, barge duwa me, dɨndaw me, barge day me kaw, gɨ ha biyən gandagɨ chə́n jiga me ca. ");
INSERT INTO sor_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Mə ha biyə swani gɨnə gəgɨr̰ɨn̰ di me, mə ha sawa widɨw me, mə ha biyə swani gɨ labe nudəw nə dineyə me nə gecheyə me, mə ha sawa chara bɨw me, mə ha biyə swagə nə dór̰e nə sɨr me swani day me, durɨw dɨ ɨsəw gɨ abeyə me. Sarga dɨ ka di, i dɨ idɨ chə́ə woni bwasan ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ di giyə dayyə. ");
INSERT INTO sor_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Mana gɨ kɨrangè gɨ chə́n ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ di dɨrənnə gɨ gɨ bo mani nə gɨ piygɨ dɨban musbu di dalawə da, mə ha ꞌwoo mapa gɨ dɨban musbu mɨn me, bangaso gɨ gɨ piyɨw gɨ swani mɨn me, bangaso gɨ dine mɨn me. ");
INSERT INTO sor_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Mani nə ta di pad, mə ha ꞌyàgɨ́ nə Arõ day gɨ dɨndaw ɨsɨragɨ lə me, mə ha wayagɨ kalgɨ gɨ laynagɨ daa ꞌyànán ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ di sarga. ");
INSERT INTO sor_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Ɗang da, mə ha cwara laya mani di bam ɨsɨragɨ lə bi bwagɨ mana gaba bwasan di dɨwə mani nə mə ulgɨ pii àlán gɨ sarga di dɨdəgɨ lə uləgɨ nɨm bam. I sarga dɨ ɨr̰aw dɨra ꞌyolɨn ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ di. ");
INSERT INTO sor_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Gəgɨr̰ɨn̰ gɨ mə ha kundəw targɨn̰ dara chə́ə gɨ Arõ giyə duwa gaba bwasan lə di da, mə ha ꞌwoo jorgɨw daa ꞌyàn ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ di sarga. Me kabni gɨ ta di ha waram i dɨma ɨjɨm. ");
INSERT INTO sor_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Gəgɨr̰ɨn̰ gɨ mə ha kundəw targɨn̰ dara chə́ə gɨ nə Arõ day gɨ dɨndaw giyə day gaba bwasan lə di da, mə ha ꞌwoo jorgɨw me, durɨw me daa ꞌyàn ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ di sarga. Mə ha chə́n gandagɨ jiga. ");
INSERT INTO sor_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Mani nə ta di, i Arõ duwa me, i dɨndaw gɨ swaa day bá bá day me. I ta di me, mana gɨ nare nə Israyel dara kundɨbə mani nə paga dara àlán gɨ ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ sarga dɨ idɨ labiya da, cendi ha ꞌyàw Arõ me, ha ꞌyàgɨ́ mwàgɨraw me, kabni gɨ ta di le bá bá. Ta di i bii gɨ ꞌwoo gɨ dam gɨ dɨrəw bɨr̰ɨn̰. ");
INSERT INTO sor_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Mana gɨ Arõ dara mara bam da, barge duwa gaba hura bwasan nɨm di ha waragɨ i dɨndaw me mwàgɨraw me. Wála gɨ gɨ dara tidɨrəgɨ swani dɨdəgɨ lə chɨ́gdəgɨ giyə day gaba bwasan lə di mwom da, cendi ha hura barge gɨ ta di. ");
INSERT INTO sor_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Arõ gorndɨw gɨ ɗan̰ gɨ ha chə́w woni bwasa Mãr̰ĩ geche day abəw tarɨwə di, ha hura barge gɨnə abəw duwa gaba bwasan di sɨwə wála wurgɨsubu bá do me ha dɨmə hára kundi gaba ɓamara gandɨn ɨndi gɨ Mãr̰ĩ dalawə dara àlán gɨ giyə mana ni gɨ nə biyɨw kalɨw wun mɨnaw jiga lə di. ");
INSERT INTO sor_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Ɨr̰ɨ mə ha laya kabni gɨnə gəgɨr̰ɨn̰ gɨ mə kundɨw targɨn̰ dara chə́ə gɨ woni bwasan giyə day gaba bwasan lə di hára nɨm hangdaw mana gɨ gɨ biyɨw kalɨw jiga ciri dɨ jə́ kundi ni daa dwar̰ɨ lə. ");
INSERT INTO sor_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Arõ day gɨ nə dɨndaw ha wama kabni gɨ ta di gɨ mapa gɨ ilə kɨrangèyə di mana gɨ kundi gaba ɓamara gandɨn ɨndi gɨ Mãr̰ĩ di bɨwə. ");
INSERT INTO sor_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","I ta di me cendi ha wama mani nə gɨ àlgɨ̀ sarga dɨ idɨ piyə àcn̰a day bam me, chə́gɨ nɨm jiga giyə day gaba bwasannə di me. I cendi mɨra me ha wama mani nə ta di, gun gɨ ɗang da, ha wama bədə, dara i mani ni nə gɨ biyɨn kalɨn gandagɨ ɨndi gɨ Mãr̰ĩ jiga. ");
INSERT INTO sor_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Kabni di me, mapa di me, warna bɨlnə dodə me walna daa da, mə ha uləgɨ bam, dara i mani ni nə gɨ biyɨn kalɨn gandagɨ ɨndi gɨ Mãr̰ĩ jiga. ");
INSERT INTO sor_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Mə ha àlagɨ́ nə Arõ day gɨ nə dɨndaw mani woni chɨ́gdəgɨ giyə day gaba bwasan lə di ya ba nə ɨrmɨm nɨm de dige dige bɨraa wála wurgɨsubu bá. ");
INSERT INTO sor_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Wála mɨn bá bá da, mə ha kundə labe gɨ abe àla gɨ sarga dɨ idɨ biyəw mana gaba bwasan àcn̰a duwa bam me, dɨ idɨ wiyaw bam me. Mə ha tidɨrəw swani dɨwə dara biyɨw jiga dara àlán gɨ giyə ni. ");
INSERT INTO sor_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Sarga dɨ idɨ biyəw mana gaba bwasan àcn̰a duwa bam di, mə ha àladɨ̀ i wála wurgɨsubu bá. Yande da, mana gaba bwasan di, ha ꞌya i ni ɨndi mɨra, anə ha biyəw kalaw gɨ dɨrəw jiga dara àlán gɨ ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ giyə ni lə. Gun labaa, mani na nə dara ɓɨlə mana gɨ ta di da, ha ꞌywaa i wamani.» ");
INSERT INTO sor_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","«Ɗang da, mani nə anə ha àlán gɨ sarga mana gaba bwasan dɨwə di me i ta: Wála mɨn bá bá da, anə ha kundɨbə gəgɨr̰ɨn̰je nə dine sɨr sɨr nə aliya day mɨn mɨn ulə àlán gɨ sarga. Mani nə ta di, anə ha àlagɨ̀ le gɨ dɨrɨn̰ bɨr̰ɨn̰. ");
INSERT INTO sor_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Anə ha kundə gəgɨr̰ɨn̰ gɨ mɨn gɨ jomni me, gɨ mɨn ɗang gɨ turgɨ dawa ɗwanda dɨra lə me ca. ");
INSERT INTO sor_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Gəgɨr̰ɨn̰ gɨ anə ha kundəw gɨ jomni di da, anə ha ɓamaw gɨ burə gɨ geme cembɨlde subu gɨ gɨ bow swani sɨw gɨ wed gɨ lade nan̰ gɨnə habda gɨ olib duwa litɨr mɨn gɨ tulɨn̰ dɨwə hawn̰ɨw nɨm daa me, gɨ gani gɨ yabɨr̰a yàa duwa litɨr mɨn gɨ tulɨn̰ me. ");
INSERT INTO sor_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Gəgɨr̰ɨn̰ gɨ anə ha kundəw gɨ turgɨ di kaw, anə ha ɓamaw gɨ mani nə ya anə banə àl gɨ jomni di de me ca. Anə ha ulə mani nə ta di bam àlán gɨ ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ sarga di. I sarga dɨ ɨr̰aw dɨra ꞌyolɨn ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ di. ");
INSERT INTO sor_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Ta di me i bwasa gɨ anə ha àlàw gɨ swaa dan bá bá mana gɨ kundi ni gaba ɓamara gandɨn di bɨwə, ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ di dɨrənnə. I mana gɨ ta lə di me, nə ha ɓamara gandang ꞌyeni nare nə Israyel  lə me, nə ha wayam ɨjɨm gɨ Moyis  gwale lə me ca. ");
INSERT INTO sor_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","I mana gɨ ta lə di me, nə ha ɓamara gɨ nare nə Israyel lə mwom da, ꞌywagda ni ha cwaa mana gɨ ta di gɨdəw mana ni gɨ nə biyɨw kalɨw mɨnaw jiga. ");
INSERT INTO sor_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Nə ha cwaa kundi gaba ɓamara gandɨn di me, mana gaba bwasan di me, kalagɨ wunə mɨ́ndagɨ jiga me, nə ha biyə Arõ day gɨ nə dɨndaw kalagɨ mɨ́ndagɨ jiga dara cendi ba àlna giyə day gaba bwasan di me ca. ");
INSERT INTO sor_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Nə ha dama lə nare nə Israyel dwar̰agɨ lə me, nə ha ꞌya i Mãr̰ĩ day me. ");
INSERT INTO sor_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Yande mwom da, cendi ha ꞌwacn̰a dara ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ di, ba nə i Mãr̰ĩ day, ɨndi gɨ nə dɨməgɨ bam sɨn̰a dɨ Ejibtɨ lə dara ba nə dam lə dwar̰agɨ lə. Ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ di, ɨndi di me nə i Mãr̰ĩ day.» ");
INSERT INTO sor_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: «Anə ha ɗangr̰a mana gaba gwasa. Anə ha ɗangr̰aw i gɨ habde nə chelbe. ");
INSERT INTO sor_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Charni duwa me, ɓɨlnani duwa me, ha bwara le, ha nyama dar̰e tuldɨ mɨn mɨn. Hwaa duwa da, ha nyama dar̰e tuldɨ sɨr. Anə ha ɗangr̰aw dugdɨw dɨ wodɨ di ha swara daa ya hugdi de. Hugdi nə ta di ha swaa i sɨwə gang. ");
INSERT INTO sor_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Anə ha ɗangr̰a jindar sɨdɨ dɨ wed huraw sɨwə me, dɨwə me, hugdəwə di me. Anə ha ɗangr̰a jindar sɨdɨ dɨ wed bɨwə mɨdən̰ gugɨrəw nɨm daa me ca. ");
INSERT INTO sor_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Anə ha n̰urə kulɨm gɨ jindar sɨr huraw dugdɨw dɨ ka lə me, dɨ ta lə me. Anə ha hurba kulɨm gɨ ta di i mana gɨ tulbəwə dodə bɨw gɨ mɨdən̰ di gɨndɨwə dara hurba gɨ habde woni yɨbə ugdəw daa hára nɨm. ");
INSERT INTO sor_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Habde nə ta di, anə ha saba i chelbe ɗangr̰agɨ me, anə ha ɗangr̰a jindar hurbagɨ sɨdəgɨ lə. ");
INSERT INTO sor_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Anə ha chə́ə mana gaba gwasa di mana gɨ barge gaba lɨgə sandug dɨ idɨ gama kur̰a dɨ idɨ mɨlan ɨnda di dɨrəwə. I sandug dɨ nə ha ꞌywam ɨjɨm gɨ Moyis lə di. ");
INSERT INTO sor_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Gɨ jomni bá bá Arõ hana dara kwagda lamba dɨ wurgɨsubu di sɨdɨ bam da, an̰ji ha gwasa le bá bá me, ");
INSERT INTO sor_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","gɨ turgɨ bá bá an̰ji hana dara kɨrə dùwa lamba lə kaw, an̰ji ha gwasa le bá bá me ca. Gɨ swaa dan bá bá da, anə ha gwasa le ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ di dɨrənnə gɨ dɨrɨn̰ bɨr̰ɨn̰. ");
INSERT INTO sor_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Mana gaba gwasa di da, anə ha ulə mani nə gwasa nə gɨ ɗangr̰ɨgɨ daran ɨndi gɨ bɨrmə gɨ nə ɨrmɨw ɨndi mɨra, mani nə gwasa nə ɗang da, anə ha ulə lə bədə. Me anə ha ulən mani woni àla gɨ sarga lə bədə me, anə ha ulən swagə nə yiga lə bədə me, anə ha dwalan mani nə nimi lə diiyə bədə me ca. ");
INSERT INTO sor_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Aliya mɨn dalawə da, Arõ ha àla sarga dɨ idɨ biyəw mana gaba gwasan àcn̰a duwa bam. An̰ji ha ꞌwoo bare gɨnə sarga dɨ idɨ biyəgɨ nare àcn̰a day bam di chìgdəw mana gaba gwasa di hugdəwə. Gɨ swaa dan bá bá da, anə ha àla mani nə ta di. Mana gɨ ta di, i ni ɨndi mɨra, anə ha biyəw kalaw gɨ dɨrəw jiga dara àlán gɨ giyə ni lə.» ");
INSERT INTO sor_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: ");
INSERT INTO sor_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","«Mana gɨ mə ha āsa nare nə Israyel da, kal wi kaw ꞌywagɨnan ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ di mani dara kɨdə gɨ sɨw daa. Dara kal wamani ꞌywana gun wála gɨ āsa lə di bədə. ");
INSERT INTO sor_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Gun gɨ sumɨw ha ꞌya lə āsa lə di da, kal a wunə chile dɨ tuda dɨ noo dɨra nem gɨram jii mɨn. I chile dɨ gɨ àl gɨ giyə mana gɨ kulu niyə tuldɨ. Chile dɨ gɨ wudɨ ta di, anə ꞌyàn i ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ di. ");
INSERT INTO sor_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Abje nə Israyel pad nə aliya day so gɨnɨn̰ sɨr ha daa nə sumdəgɨ ha ꞌya lə āsa lə da, ha ꞌywagan ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ di mani nə ta di. ");
INSERT INTO sor_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Aba ꞌywaa mani ha ꞌyàa nan̰ ɗwaya chile dɨ tuda tuldɨ dɨ nə ɨrmɨdɨ di bam bədə me, aba ꞌywaa mani bədə kaw ha ꞌyàa duwa ɓani bədə me ca. Wi kaw, ha ꞌyàn ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ di chile dɨ nə sawdɨ ta di bá bá dara kɨdə gɨ sɨw daa. ");
INSERT INTO sor_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Mana gɨ nare nə Israyel di dara ꞌyàm chile dɨ ta di pad mwom da, mə ha ꞌwódɨ ɗangr̰a gɨ kundi gaba ɓamara gandɨn ɨndi gɨ Mãr̰ĩ di. Ha ꞌya i mani woni gon ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ di dusɨn daa nare nə Israyel di dɨdəgɨ lə dara mani nə cendi ꞌyàn kɨdə gɨ sɨdəgɨ daa di.» ");
INSERT INTO sor_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: ");
INSERT INTO sor_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","«Anə ha ɗangr̰a mani nə ɓɨle nə wun ya dása de dara saba gɨ sii. Anə ha ɗangr̰a mani nə ta di i gɨ biri gɨ bor ngɨr ngɨr me, gɨdɨragɨ kaw, ha ꞌya i biri gɨ bor ngɨr ngɨr me ca. Anə ha chə́gɨ i mana gɨ kundi gaba ɓamara gandɨn ɨndi gɨ Mãr̰ĩ bulə day gɨ mana gaba bwasan lə. Ɨr̰ɨ anə ha bwaa nimi dwar̰agɨ lə. ");
INSERT INTO sor_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Mwom da, Arõ day gɨ nə dɨndaw ha udə nimi nə ta di saba gɨ sɨdəgɨ. ");
INSERT INTO sor_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Mana gɨ cendi gandɨna dara hára kundi ni gaba ɓamara gandɨn lə da, cendi ha saba sɨdəgɨ bam gɨ nimi nə ta di mwom da, cendi ha mara bədə. Cendi hana mana gaba bwasan lə dara ulə gɨ mani woni àlán gɨ ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ sarga kaw, ");
INSERT INTO sor_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","cendi ha saba sɨdəgɨ bam dara kal cendi marna bədə. Ta di me i bii gɨ ꞌwoo gɨ dam gɨ dɨrəw bɨr̰ɨn̰. Kal Arõ me, dɨndaw me, gɨ swaa day bá bá me da, kalna dusɨrəgɨ bii gɨ ꞌwoo di dɨwə gɨ dɨrɨn̰ bɨr̰ɨn̰.» ");
INSERT INTO sor_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: ");
INSERT INTO sor_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","«Mə ha laya mani nə lade nə biy ꞌyol nə kili day wom nan̰: Mə ha ꞌwoo dur̰u dɨnə habda gɨ gɨ ꞌwogɨw mir duwa kilo jii me, mə ha joo burə gɨnə habda gɨ gɨ ꞌwogɨw kinamum gɨ biy ꞌyol nan̰ duwa kilo sɨr gɨ tulɨn̰ me, mə ha laya dɨrwa gɨ biy ꞌyol nan̰ kilo sɨr gɨ tulɨn̰ me, ");
INSERT INTO sor_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","mə ha joo burə gɨnə habda gɨ gɨ ꞌwogɨw kas kilo jii, i kilo dɨ gɨ ɨrɨm gɨ mani mana gɨ kulu niyə di, me mə ha udə swani gɨnə habda gɨ olib litɨr kubi me ca. ");
INSERT INTO sor_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Mani nə ta di, gun gaba ꞌwacn̰a dáya gɨ mani woni àla gɨ swani gɨ lade ha ɓamagɨ àla gɨ swani gaba tidɨrə diiyə dara biyə gɨ mani chə́n ɨndi gɨ Mãr̰ĩ jiga. ");
INSERT INTO sor_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","I swani gɨ ta di me, mə ha chìgdə̀w kundi gaba ɓamara gandɨn ɨndi gɨ Mãr̰ĩ sɨwə dara biyəw chə́n gandɨw jiga me, mə ha tidɨrədɨ sandug ni dɨ idɨ gama kur̰a dɨ idɨ mɨlan ɨnda sɨdə me ca. ");
INSERT INTO sor_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","Mə ha tidɨrədɨ tabɨl dɨ idɨ chɨ́gdən mapa sɨdə me, mani dɨra woni chɨ́gdə dɨdə pad sɨdəgɨ lə me, mani nə gangr̰agɨ wurgɨsubu nə gɨ chɨ́gdɨ lamba lə sɨdəgɨ lə me mani day pad sɨdəgɨ lə me, mana gaba gwasa sawe sɨwə me ca. ");
INSERT INTO sor_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","Mə ha tidɨrəw mana gaba bwasan me, mani duwa pad me sɨdəgɨ lə. Mə ha tidɨrəgɨ mani nə ɓɨle woni bwaa nimi sɨdəgɨ lə me gɨdɨragɨ lə me ca. ");
INSERT INTO sor_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Mə ha biyə mani nə ta di chə́n gandagɨ ɨndi gɨ Mãr̰ĩ jiga. Mani nə ta di, i ni ɨndi mɨra, anə ha biyəgɨ kalagɨ gɨ dɨrəgɨ jiga dara àlán gɨ giyə ni. Ina i gun labaa, mani me ɓɨlnəgɨ da, ha ꞌywaa i wamani. ");
INSERT INTO sor_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Mə ha tidɨrəgɨ nə Arõ day gɨ nə dɨndaw swani gɨ ta di dɨdəgɨ lə dara biyəgɨ chə́gɨ mɨ́ndagɨ jiga dara ꞌyàgɨ́ gɨ giyə day gaba bwasan di ɨsɨragɨ lə. ");
INSERT INTO sor_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Ɨr̰ɨ mə ha wayagɨ nare nə Israyel da: “Swani gɨ ka di, i swani ni gaba tidɨrə diiyə dara biyə gɨ mani chə́n ɨndi gɨ Mãr̰ĩ jiga. Gɨ swaa dan bá bá da, anə ha gamaw dara àla gɨ giyə ni ɨndi mɨra. ");
INSERT INTO sor_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Kal gun ɗana swani gɨ ta di sɨwə bədə me, gun kan̰jɨna bɨrmə gaba dáya mani dara ba a gɨdəgɨ swani gɨ ya ta de di bədə me ca. Swani gɨ ta di, anə ha gaman gandɨw jiga. I ni ɨndi gɨ dɨrɨn̰ bɨr̰ɨn̰. ");
INSERT INTO sor_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Gun gɨ kan̰jɨna bɨrmə gaba dáya mani dara gɨdəgɨ swani gɨ ya ta de di labaa, ɗanaw jaw gun gɨ pəgɨn̰ sɨwə da, kal gɨ ꞌywarnaw bam nare nə Israyel dwar̰agɨ lə.”» ");
INSERT INTO sor_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: «Mə ha laya mani dɨrəgɨ jiga jiga nə biy ꞌyol: Mə ha ꞌwoo dur̰u dɨnə habda gɨ gɨ ꞌwogɨw sɨtora duwa me, onisa duwa me, galbanum duwa me, mə ha ꞌwoo dur̰u gɨnə habda gɨ sawe duwa wusɨ me, kal bwarna mɨn. ");
INSERT INTO sor_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Mani nə ta di, ha ꞌya i giyə gɨnə gun gaba ꞌwacn̰a dáya gɨ mani woni gwasa ladɨ. An̰ji ha ɓamagɨ me, ha bwaa wàla lə gɨdəgɨ mani sɨdəgɨ nə wed dara àlán gɨ giyə ni. ");
INSERT INTO sor_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Mani nə mə dáygɨ ta di, mə ha joo yab yawagɨ gɨdəgɨ burə me, mə ha ꞌwoo burə di hára nɨm chə́ə mana gɨ sandug dɨ idɨ gama kur̰a dɨ idɨ mɨlan ɨnda di dɨrədɨ lə, kundi gaba ɓamara gandɨn ɨndi gɨ Mãr̰ĩyə di. I sandug dɨ nə ha ꞌywam ɨjɨm gɨ Moyis lə di. Mani woni gwasa nə ta di, i ni ɨndi mɨra, anə ha biyəgɨ kalagɨ gɨ dɨrəgɨ jiga dara àlán gɨ giyə ni. ");
INSERT INTO sor_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Mani woni gwasa nə ta di, kal gun dáynagɨ gɨdɨnəgɨ ya ta de dige dige dara àla gɨ giyə duwa gɨ sɨw ɗi. Anə ha kalan gandagɨ mɨ́ndagɨ jiga, cendi i ni, ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ di. ");
INSERT INTO sor_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Gun gɨ kan̰jɨna bɨrmə gaba dáya mani gɨdəgɨ ya mani woni gwasa nə ta di de dara biyə day ba ꞌyolɨwe da, kal gɨ ꞌywarnaw bam nare nə Israyel dwar̰agɨ lə.» ");
INSERT INTO sor_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: ");
INSERT INTO sor_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","«Doy, nə biy Besalel gɨnə Uri gorndɨw, i Hur mwàw, gɨ gɨndɨw i gangle gɨnə Juda lə di. ");
INSERT INTO sor_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Nə ꞌwon dusɨw daa gɨ dúndi ni me, ꞌyàw dɨrɨn̰ naa me, ꞌwacn̰a gɨ mani me. Nə ꞌyàw mwãr̰ãni dɨ idɨ àla gɨ mani nə jiga jiga pad me. ");
INSERT INTO sor_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","An̰ji nem ɨrmə mani woni àla me, ꞌwocn̰ àla giyə gɨnə jindar le me, tuda le me, biri gɨ bor ngɨr ngɨr le me. ");
INSERT INTO sor_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","An̰ji ꞌwocn̰ janga gɨ mani kur̰a dɨ lade dɨ idɨ sumi sɨdə me, magdadɨ mani sɨdəgɨ lə me, ꞌwocn̰ pɨlbə gɨ habde le me ca. An̰ji ꞌwocn̰ àla gɨ mani nə jiga jiga le pad. ");
INSERT INTO sor_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Ɗang da, nə biy Oliyab gɨnə Aysamak gorndɨw dara ba wanawə giyə lə di. Oliyab di gɨndɨw i gangle gɨnə Dannə. Me nə ꞌyàgɨ́ mwar̰ə nə ɗang pad dɨrɨn̰ naa dara ba àlna gɨ mani pad nə nə ɨrmɨm gandagɨ di. ");
INSERT INTO sor_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Mani di i: kundi gaba ɓamara gandɨn ɨndi gɨ Mãr̰ĩ di me, sandug ni dɨ idɨ gama kur̰a dɨ idɨ mɨlan ɨnda di me bɨdɨ gaba ɗyasadɨ daa di me, mani nənə kundi ni duwa pad di me, ");
INSERT INTO sor_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","tabɨl me mani dɨra di me, mani nə gangr̰agɨ wurgɨsubu nə gɨ chɨ́gdɨ lamba lə diiyə nə ɗangr̰ar gɨ jindar sɨdɨ dɨ wed di me mani day nə jiga jiga pad di me, mana gaba gwasa sawe di me, ");
INSERT INTO sor_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","mana gaba ulə mani nə paga dara bwasan nɨm di me mani duwa pad di me, mani nə ɓɨle woni bwaa nimi me gɨdɨragɨ di me, ");
INSERT INTO sor_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","barge gaba hura àlán gɨ giyə di me, barge gɨ wun mɨnaw jiga gɨnə woni bwasan geche day gɨ Arõ duwa di me, barge gɨnə dɨndaw day gaba hura àla gɨ giyə gaba bwasan di me, ");
INSERT INTO sor_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","swani ni gaba tidɨrə diiyə di me, mani woni gwasa kulu ni dalaw di me ca. Mwar̰ə di ha àla mani di ya ba nə ɨrmɨm nɨm de dige dige.» ");
INSERT INTO sor_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: ");
INSERT INTO sor_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","«Gwale gɨ mə ha wayagɨ nare nə Israyel di me i ta: “Wála gaba bwaa gwayni di, anə ha biyəw kalaw jiga, dara i mani woni gwong dusɨrəng daa ꞌyeni me, mwàgɨrang me, gɨ swaa dan bá bá dara ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ di, nə biyəng kalang jiga dara anə ina i nare ni. ");
INSERT INTO sor_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Yande da, anə ha biyə wála gaba bwaa gwayni di kalaw jiga, yarnaw ya wála gɨ pəgɨn̰ de bədə. Gun gɨ yarnaw ya wála gɨ pəgɨn̰ de da, an̰ji ùr i ꞌyáa gɨ bam. I sɨdə, ina i wi wi gɨ àlna giyə wála gɨ ta lə da, kal gɨ ꞌywarnaw bam nare nə Israyel di dwar̰agɨ lə. ");
INSERT INTO sor_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Anə ha àla giyə wála kubi dalawə mɨra, me wála gɨ wurgɨsubu lə da, i wála gaba bwaa gwayni, anə ha biyəw kalan gandɨw jiga ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ di. Ina i wi wi gɨ àlna giyə wála gɨ ta lə da, an̰ji ùr i ꞌyáa gɨ bam. ");
INSERT INTO sor_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Nare nə Israyel ha biyə wála gaba bwaa gwayni di kalaw jiga. Cendi gɨ swaa day bá bá da, ha yaraw ba i wála gɨ geche kwandaw dwar̰agɨ lə. Ta di i bii gɨ ꞌwoo gɨ nə yɨ nɨm gandang mɨlan gɨ dɨrɨn̰ bɨr̰ɨn̰ di. ");
INSERT INTO sor_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Wála gaba bwaa gwayni di da, gɨl i mɨlan dɨ ilə bulə ɨnda lə, ɨndi me ꞌyeni nare nə Israyel me, gɨ dɨrɨn̰ bɨr̰ɨn̰. Dara ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ di, nə àsɨ daa me sɨn̰a me di, i wála kubi dalawə. Me wála gɨ wurgɨsubu lə da, nə hoy àla gɨ giyə di, nə bo gwayni.”» ");
INSERT INTO sor_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Mana gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayaw Moyis gwale mana gɨ kur̰a dɨ Sinay dɨdə bam pad mwom da, an̰ji lay kur̰a dɨ ɓɨdɨr̰a ɓɨdɨr̰a sɨr ꞌyàw Moyis di ɨsəwə. I kur̰a dɨ an̰ju gɨ Mãr̰ĩ me jangɨ bii duwa gɨ ꞌwoo lə sɨdə di gɨ ɨsəw duwa an̰ju. ");
INSERT INTO sor_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Mana gɨ nare nə Israyel di yər dara Moyis ba chə́ə daa kur̰a dɨdə hára dodə kaláng bədə mwom da, cendi dayar dodə Arõ tulɨwə me wayɨw ba da: «So daa, mə ɗangr̰ɨndɨ dwama kal a ɨndarna dɨrəndɨ lə hana ganandɨ. Dara Moyis gaba dɨməndɨ bam sɨn̰a dɨ Ejibtɨ lə gɨ ta di, i na gaa yá àlàw som kaw, də ꞌwacn̰ang bədə.» ");
INSERT INTO sor_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Ɨr̰ɨ Arõ waygɨ ba da: «Piynəy mani nə sumiyə nə gɨ ɗangr̰ɨgɨ gɨ jindar nə namdang sumdəgɨ lə me, dɨndɨrang nə abje me nə namde me sumdəgɨ lə me, hane nɨm ꞌyànán.» ");
INSERT INTO sor_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Mwom da, nare nə Israyel pad piyə mani nə sumiyə nə gɨ ɗangr̰ɨgɨ gɨ jindar nə sumdəgɨ lə di hára nɨm ꞌyàw Arõ. ");
INSERT INTO sor_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Arõ di lay mani nə jindar di ɨsɨragɨ lə me ha n̰urə jindar di ɗangr̰ɨ nɨm gɨ labe gɨ dwe dúndɨw. Mwom da, nare nə Israyel di way ba da: «Israyel, yarnandɨ Mãr̰ĩ ɨnda gɨ dɨməndɨ bam sɨn̰a dɨ Ejibtɨ lə di me i ta!» ");
INSERT INTO sor_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Mana gɨ Arõ yər yande mwom da, an̰ji aw mana gaba bwasa dwama gɨ labe gɨ dwe dúndɨw di dɨrədɨ lə me way ba da: «Sanga da, də hárang àla sii ꞌywala gaba àsáw Aba dama gɨ dɨrəw bɨr̰ɨn̰ di sumi gɨ ꞌwaga dɨwə.» ");
INSERT INTO sor_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Sanga gɨ jomni cor̰ər̰ə da, nare nə Israyel hára gɨ mani woni ulə àla gɨ sarga me, woni àla gɨ sarga dɨ idɨ labiya me ca. Ɨr̰ɨ cendi dam dodə wom me, chə̀ me, mwom da, ɓɨr̰ɨn̰əgɨ daa àl sii ꞌywala. ");
INSERT INTO sor_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: «Chɨ́ cor ha dodə bi kaláng, dara nare dɨma nə mə dɨməgɨ bam sɨn̰a dɨ Ejibtɨ lə di àl àcn̰a gɨ geche. ");
INSERT INTO sor_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Cendi so kaláng gɨn̰ bɨrmə gɨ nə gɨləgɨ gandɨw di bam. Cendi u biri lon̰ɨw n̰urɨw ɗangr̰ɨ gɨ labe gɨ dwe dúndɨw me, piy gubɨrəgɨ dodə dɨrəwə me mɨlawdɨw me, àlɨ́w sarga me way ba da: “Israyel, yarnandɨ Mãr̰ĩ ɨnda gɨ dɨməndɨ bam sɨn̰a dɨ Ejibtɨ lə di me i ta!”» ");
INSERT INTO sor_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ɗang ba da: «Nə yər nare nə Israyel di, cendi i nare nə dɨdəgɨ woy nan̰e! ");
INSERT INTO sor_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Caga ka da, kalɨn mana mɨn jang! Dusɨn ha swaa le dɨdəgɨ lə me, nə ha ꞌyágɨ bam pad. Me ɨjɨm da, nə ha cwam gɨdəm nare nə ꞌyarbare nan̰ mwágɨragɨ.» ");
INSERT INTO sor_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Ɨr̰ɨ Moyis wayɨw Aba dama gɨ dɨrəw bɨr̰ɨn̰ gɨ i Mãr̰ĩ duwa di gwale gaba hɨlalaw dusɨw ba da: «Aba dama gɨ dɨrəw bɨr̰ɨn̰, dana me dusɨm so mana gɨ nare dɨma nə mə dɨməgɨ bam sɨn̰a dɨ Ejibtɨ lə gɨ ɨsəm gaba dwana dɨ idɨ àla lán̰a a mo? ");
INSERT INTO sor_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Mə àlna nare di yande da, nare nə Ejibtɨ ha waya ba i gɨ ɨrmə gɨ àcn̰e me ba mə laya gɨ nare nə Israyel di gandagɨ nɨm bam sɨn̰a dayyə di me, ba mə ha gandagɨ wama gɨ ciri dɨ kur̰a dɨdə dara ꞌyágɨ bam, cendi ba ina lə sɨn̰a dɨdə bədə ɗɨm da, ladɨ le mo? Yande da, kal dusɨm hɨlal, me u bɨm way dara ba mə ha àla nare nə Israyel di wamani bədə ɗɨm. ");
INSERT INTO sor_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Kal dusɨm gunəm daa moso dɨma nə Abɨraham me, Isak me, Jakob me dɨdəgɨ lə. I ɨjɨm di me, mə sɨrgəgɨ sɨm wayagɨ ba da: “Nə ha kala mwàgɨrang ha ꞌyarbara ya dechu dɨ daa de. Nə u bɨn way ba nə ha ꞌyàgɨ́ sɨn̰a dɨ nə waygɨ gwale dɨra di le. Sɨn̰a di ha waragɨ i dɨba day gɨ dɨrɨn̰ bɨr̰ɨn̰.”» ");
INSERT INTO sor_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ di u bɨw way ba a ha àlagɨ́ nare nə Israyel wamani gɨ an̰ji ùr dee ba a àlgɨ́ di bədə ɗɨm. ");
INSERT INTO sor_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Ɨr̰ɨ Moyis chə́ə daa kur̰a lə di, hára dodə. An̰ji laya kur̰a dɨ ɓɨdɨr̰a ɓɨdɨr̰a sɨr dɨ bii gɨ ꞌwoo gɨ Mãr̰ĩ yɨ gɨ mɨlan gɨ nare nə Israyel di ɨsəwə. Kur̰a dɨ ta di, janga ilə tuldɨ dɨ ka lə me ka lə me, ");
INSERT INTO sor_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","i Mãr̰ĩ me àl giyə dɨra an̰ju. I Mãr̰ĩ sɨw duwa me jangɨ bii duwa gɨ ꞌwoo di lə sɨdə gɨ ɨsəw duwa an̰ju. ");
INSERT INTO sor_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Mana gɨ Josuwe gaba waw Moyis lə giyə lə di  doy nare nə Israyel bo gura mana day gɨ dama lə mwom da, an̰ji wayɨw Moyis ba da: «Doy, gura gɨ say nɨm lə mana ɨnda gɨ dama lə!» ");
INSERT INTO sor_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Me Moyis cow lə diiyə ba da: «Bədə, ta di i gura gɨ abnani bədə me, i gura gɨnə woni ꞌywaa wamani day bədə me ca. Me nə doy i gura gaba sii ꞌywala.» ");
INSERT INTO sor_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Mana gɨ nə Moyis day gɨ Josuwe  hára gɨra mana day gɨ dama lə di ib da, Moyis yər labe gɨ dwe dúndɨw me, nare di ilə n̰ar̰a lə me, mwom da, dusɨw so le. An̰ji bwaa kur̰a dɨ ɓɨdɨr̰a ɓɨdɨr̰a dɨ an̰ji yə̀dɨ ɨsəwə di bam hára dodə ichɨbər bam kur̰a dɨ an̰ji chə́ə lə di gɨndɨdɨ lə. ");
INSERT INTO sor_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","An̰ji u labe gɨ dwe dúndɨw dɨ nare nə Israyel ɗangr̰ɨw di àsɨ dùwa lə me, yo gɨdɨ dɨbɨrɨn̰. An̰ji lay dɨbɨrɨn̰ di bodɨ nimiyə me ꞌyàgɨ́ nare nə Israyel di chə̀. ");
INSERT INTO sor_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Ɨr̰ɨ Moyis wayɨw Arõ ba da: «Nare nə Israyel di àlám i na me, mə bogɨ àla gɨ àcn̰a gɨ geche gɨ ya ta de di lə mo?» ");
INSERT INTO sor_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Arõ cow lə diiyə ba da: «Aba ciri ni, nə amsɨm ɗe! Kal dusɨm swana bədə. Mə ꞌwocn̰ com dara nare nə Israyel di, i nare nə àla gɨ àcn̰a da, womgɨ bədə bɨr̰ɨn̰. ");
INSERT INTO sor_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Cendi wayɨn ba da: “Ɗangr̰ɨndɨ dwama kal a ɨndarna dɨrəndɨ lə hana ganandɨ, dara Moyis gaba dɨməndɨ bam sɨn̰a dɨ Ejibtɨ lə gɨ ta di, i na gaa yá àlàw som kaw, də ꞌwacn̰ang bədə.” ");
INSERT INTO sor_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","I ta di me, nə waygɨ da: “Gun gɨ jindar duwa ina lə da, a piynəy ꞌyànán.” Mwom da, cendi piyə mani day nə sumiyə ꞌyàn me, nə bogɨ dùwa lə me labe gɨ dwe di dúndɨw ganda.» ");
INSERT INTO sor_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Moyis yala ꞌwocn̰ dara Arõ ba kal nare nə Israyel di ba àl gɨ mani gɨ bɨrmə day bədə, cendi àl mani nə dɨrəgɨ ùr. Yande da, woni mar̰ande day ba ha ꞌywaa bɨrmə gaba àlagɨ̀ ichɨn̰. ");
INSERT INTO sor_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Moyis ha ɗɨbə mana day gɨ dama di bɨwə me soy mar̰ɨjaw daa nan̰ ba da: «Gun gɨ ina i aba ùrə Aba dama gɨ dɨrəw bɨr̰ɨn̰ gwale duwa da, a hane ꞌywanan!» Mwom da, nare nə gangle gɨnə Lebiyə pad da, hára dayar tulɨwə. ");
INSERT INTO sor_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Moyis way ba da: «Dwayna, gwale gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ gɨ i Mãr̰ĩ ɨnda nendɨ nə Israyel wayɨw di me i ta: Kal wi wi kaw unə sugɨnə duwa dɨ chere mana gɨndɨwə me, a wàna hana mana dan gɨ dama bɨw gɨ alə ta lə bá me cwarne hane. Anə ha ꞌyáa woni mɨlawda dwama bam. Ina i chamrang labaa, kwandang moso labaa, woni ciri dan bɨdɨ kaw, kalnagɨ bədə.» ");
INSERT INTO sor_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Nare nə gangle gɨnə Lebiyə di àl mani nə Moyis waygɨ gandagɨ di me, wála gɨ ta lə di, nare nə Israyel mar nem ya dubu dubu subu (3 000) de. ");
INSERT INTO sor_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Yande mwom da, Moyis waygɨ nare nə Lebi di ba da: «Wála gɨ laba lə da, gɨ chɨ́gdəng giyə gɨnə Aba dama gɨ dɨrəw bɨr̰ɨn̰ duwa lə. Dara dɨndɨrang dan gang labaa, chamrang kaw, anə kalagɨ bədə. Yande da, Aba dama gɨ dɨrəw bɨr̰ɨn̰ piy bɨw dɨdəngə wála gɨ laba lə.» ");
INSERT INTO sor_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Ɨr̰ɨ sanga da, Moyis waygɨ nare nə Israyel ba da: «Anə bwasa labe gɨ dwe dúndɨw da, anə àla àcn̰a gɨ geche. Caga da, nə nagɨ cor ha i daa kur̰a dɨdə di bi dara ꞌywaa Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayaw gwale dan sɨn̰, gaa an̰ji ha biyəng àcn̰a dan di bam som.» ");
INSERT INTO sor_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Mwom da, Moyis cor ha ꞌywaa Aba dama gɨ dɨrəw bɨr̰ɨn̰ di me wayɨw ba da: «Ay, Aba dama gɨ dɨrəw bɨr̰ɨn̰, nare nə Israyel di àla àcn̰a gɨ geche. Cendi ɗangr̰ɨ dwama gɨ jindar. ");
INSERT INTO sor_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Caga da, nə amsɨm ɗe! Kal dusɨm hɨlal mana gɨ àcn̰a day di dɨwə. Mə kalna dusɨm hɨlalna a dɨdəgɨ lə bədə da, mendɨ sumɨn gɨ mə jangɨw mana gɨ maktubu dɨma dɨ mə jangɨ gɨ nare dɨma sumdəgɨ lə di bam.» ");
INSERT INTO sor_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Aba dama gɨ dɨrəw bɨr̰ɨn̰ cow lə diiyə ba da: «Yande bədə. I gun gaba àla mani nə àcn̰e gandɨn di me, nə ha myanda sumɨw bam mana gɨ maktubu lə di an̰ju. ");
INSERT INTO sor_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Caga da, so ha! Mə ha ɨndara nare nə Israyel di dɨrəgɨ lə ha gandagɨ mana gɨ nə ɨrmɨm gandɨwə di. Me paja ni gɨ daa ha ɨndara dɨrəmmə. Me wála gɨ nə dara ùrə ba nə àl nare di wamani da, nə ha àlagɨ́ wamani dara àcn̰a day di sɨn̰.» ");
INSERT INTO sor_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Aba dama gɨ dɨrəw bɨr̰ɨn̰ àl nare nə Israyel wamani i dara cendi wayaw Arõ ba ɗangr̰ɨnagɨ labe gɨ dwe dúndɨw ba gɨ ɨrmɨw Mãr̰ĩ day di. ");
INSERT INTO sor_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: «So daa, mə ha le! Ɨjɨm me, nare nə Israyel nə mə dɨməgɨ bam sɨn̰a dɨ Ejibtɨ lə di me, hana kalna mana gɨ ka di bam, me hana mana gɨ sɨn̰a dɨ nə biyɨw Abɨraham bii me, Isak bii me, Jakob bii me, ba nə ha ꞌyàgɨ́ i mwàgɨragɨ di lə. ");
INSERT INTO sor_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Nə ha giyə paja ni gɨ daa dɨrəngə me, nə ha ꞌywara nare nə Kanan bam me, nə Amori bam me, nə Hiti bam me, nə Perisi bam me, nə Hibi bam me, nə Yebus bam me ca. ");
INSERT INTO sor_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Hana mana gɨ sɨn̰a dɨ nãy me dùmbu me chow lə nan̰ di lə. Me ɨndi da, nə ha ꞌya lə dwar̰angə bwang hára nɨm bədə, dara anə i nare nə dɨdəng woy nan̰e. Nə hana gandang da, gaa nə ha ꞌyáng bam bɨrmə lə som.» ");
INSERT INTO sor_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Mana gɨ nare nə Israyel di ba gɨ doy gwale gɨ wome gɨ ta di mwom da, dɨrəgɨ àl n̰agɨni, ɨr̰ɨ gun mɨn kaw hurə barge duwa gaba àla gɨ sii ꞌywala sɨwə bədə. ");
INSERT INTO sor_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","I sɨdɨ, dee Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayaw Moyis pii ba waynagɨ nare nə Israyel ba da: «Anə i nare nə dɨdəng woy nan̰e. Nə ina lə dwar̰angə bwanang hana nɨm ɓam yande da, gaa nə ha ꞌyáng bam kaláng som. Caga ka da, n̰ir̰ɨbɨnə barge dan gɨ anə hurbə àl gɨ sii ꞌywala di bwana dodə me, nə ha ꞌwacn̰a mani nə nə ha àla gandang.» ");
INSERT INTO sor_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Mana gɨ nare nə Israyel swaa kala kur̰a dɨ Horeb bam mwom da, cendi hurbə barge day gaba àla gɨ sii ꞌywala di sɨdəgɨ lə bədə ɗɨm. ");
INSERT INTO sor_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Me mana gɨ cendi ɗangr̰a mana day gaba dama di bá bá mwom da, Moyis ha ɗangr̰a duwa kundi mɨn bam mana day gaba dama di tulɨwə bam ched, me ꞌwogɨ́w sumɨw «kundi gaba ɓamara gɨ Mãr̰ĩ». Nare pad nə ùrnə ba gɨ ùrnə Aba dama gɨ dɨrəw bɨr̰ɨn̰ gwale da, cendi dɨmə bam iche me, ha i mana gɨ kundi gɨ ta lə di. ");
INSERT INTO sor_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Me mana gɨ Moyis dɨmnə dara hára kundi gɨ ta lə di da, nare pad dɨmə iche ɗɨbdɨ daa kundi day di bɨwə yər gɨ tarɨw bɨraa an̰ji dɨm ha nɨm kundi di dalawə bá do. ");
INSERT INTO sor_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Me Moyis dɨmnə hana kundi di dalawə mwom da, sawe chə́ə hára mu kundi di bɨw daa me, Aba dama gɨ dɨrəw bɨr̰ɨn̰ ilə wayɨw Moyis gwaleyə me ca. ");
INSERT INTO sor_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Nare nə Israyel di yər sawe mõõ gɨ kundi bɨw daa lə mwom da, cendi ɓɨr̰ɨn̰ daa pad dayyə, wi wi kaw piy gubɨrəw dodə kundi duwa bɨwə dara mɨlawda gɨ Mãr̰ĩ. ");
INSERT INTO sor_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Me Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis gwale bɨwə ya gun ba wayɨw gɨ jaw gun gwale de. Ɨr̰ɨ Moyis dɨmə iche cor ha mana day gɨ dama lə di bi me, maché gɨ Josuwe gɨnə Nun gorndɨw gaba wawə giyə lə di duwa da, wara dama lə kundi di dalawə jang. ");
INSERT INTO sor_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Moyis wayɨw Aba dama gɨ dɨrəw bɨr̰ɨn̰ ba da: «Doy, Aba dama gɨ dɨrəw bɨr̰ɨn̰! Mə wayan ba nə hana gɨ nare nə Israyel di me, mə gɨlɨn gun gɨ mə ha giyəw dara ba hana gandɨn di bədə. Me i ɨjɨm di me mə wayan ba mə ꞌwocn̰ɨnne gɨ sumɨn pad me, sɨm ba ꞌyolɨmme dɨnnə me ca. ");
INSERT INTO sor_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Caga da, sɨm ꞌywalnamme dɨnnə da, gɨlɨn bɨrmə dɨma kal nə ꞌwocn̰ mani nə mə ùr ba mə àlgɨ̀ di mwom da, nə ha ꞌwacn̰amme me, sɨm ha ꞌywalam dɨnnə bi me ca. Yər nare nə Israyel di, i nare dɨma.» ");
INSERT INTO sor_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: «Ɨndi gɨ sɨn ni me, nə ha hára gandɨm me, nə ha kalam mə ha dama dusɨm dodə.» ");
INSERT INTO sor_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Moyis cor wayɨw ɗang bi ba da: «Mə hana gandanin ɨjɨm gɨ sɨm dɨma bədə da, kal wayanin ba nə swananin hana kalna mana gɨ ka di bam ɗi. ");
INSERT INTO sor_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Mə bwananin hana nɨm bədə da, i na me ha gɨlə dara ɨndi di me, nare nə dɨma di me, sɨm ba ꞌyolɨmme dɨdəninnə di mo? Mə hana gandanin da, nenin nare dɨma nə Israyel di, nə hanin wunə mɨnanin jiga gɨ nare nə gɨndəgɨ jiga jiga pad nə ilə sɨn̰a dɨdə ka di.» ");
INSERT INTO sor_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: «Mani nə mə ùr ba nə àlnám di, nə ha àlám gandagɨ le, dara sɨn ꞌyolɨnne dɨmmə me, nə ꞌwocn̰ɨmme gɨ sumɨm pad me ca.» ");
INSERT INTO sor_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Moyis wayɨw Aba dama gɨ dɨrəw bɨr̰ɨn̰ ba da: «Nə amsɨm ɗe! Gɨlɨn ꞌywagda dɨma di, kal nə yər.» ");
INSERT INTO sor_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: «Nə ha hára dɨrəmmə me, nə ha gɨləm ladni ni me, nə ha gɨləm sumɨn gɨ ɓag gɨ “Aba dama gɨ dɨrəw bɨr̰ɨn̰” di me. Nə àl dusi dɨ lade gɨ gun gɨ nə ùr ba nə àl gandɨw dusi dɨ lade me, gun gɨ nə ùr ba nə yər n̰agɨni duwa kaw, nə yər n̰agɨni duwa le me ca.» ");
INSERT INTO sor_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","An̰ji wayɨw Moyis ɗang bi ba da: «Mə ha nyama yara dɨrən bədə, dara gun gɨ gɨsage da, ha nyama yaran me ha dama nɨm bɨ̀ra me bədə.» ");
INSERT INTO sor_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: «Yər, mana i tulɨnnə ib ta, ha ɗɨbə kur̰a dɨ ta di dɨdə. ");
INSERT INTO sor_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Me mana gɨ ꞌywagda ni di dara hára mwom da, nə ha àsam mana gɨ kur̰a gubu dɨra lə, nə ha àsa ɨsən dɨmmə budəm bɨraa nə dara hára sawa bam bá do. ");
INSERT INTO sor_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Mwom da, nə ha ꞌwoo ɨsən bam dɨmmə me, mə ha yara i tarɨn. Me dɨrən da, gun ha nyama yaragɨ bədə.» ");
INSERT INTO sor_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: «Pɨl kur̰a ɗangr̰ɨdɨ ɓɨdɨr̰a ɓɨdɨr̰a sɨr wunnə ya dɨ pii dɨ mə ichɨbədɨ bam di de. Me nə ha janga gwale gɨ nə jangaw kur̰a dɨ piiyə di lə sɨdə. ");
INSERT INTO sor_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Ɗangr̰ɨ sɨm dara sanga gɨ jomni. Gɨ jomni cor̰ər̰ə da, mə ha naga hára daa kur̰a dɨ Sinay dɨdə me, mə ha hára dɨrənnə ɗɨbə kur̰a di dɨdɨ dɨ daa ced lə, gaman lə. ");
INSERT INTO sor_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Me kal gun mɨn nagɨna hana gandɨm bədə. Kur̰a di dɨdə pad da, kal gɨ yarna gun gɨ ɗang mɨn tenene lə bədə. Ina i mani nə paga nə dine labaa, nə gechide kaw, ɗɨbɨnə wamna lə tuldɨ lə ib bədə me ca.» ");
INSERT INTO sor_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Ɨr̰ɨ Moyis pɨl kur̰a ɗangr̰ɨdɨ ɓɨdɨr̰a ɓɨdɨr̰a sɨr ya dɨ pii di de. An̰ji so gɨ jomni cor̰ər̰ə ha naga daa kur̰a dɨ Sinay dɨdə gɨ kur̰a dɨ sɨr di ɨsəwə, ya Aba dama gɨ dɨrəw bɨr̰ɨn̰ ba a wayaw nɨm de. ");
INSERT INTO sor_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Aba dama gɨ dɨrəw bɨr̰ɨn̰ chə́ə mana gɨ sawe dalawə hára ɗɨbɨ Moyis tulɨwə ib me gu sumɨw gɨ «Aba dama gɨ dɨrəw bɨr̰ɨn̰» di daa. ");
INSERT INTO sor_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Aba dama gɨ dɨrəw bɨr̰ɨn̰ ha Moyis dɨrəwə me way mar̰ɨjaw daa ba da: «Ɨndi, nə i Aba dama gɨ dɨrən bɨr̰ɨn̰! Nə i Mãr̰ĩ gaba yara nare n̰agɨni day me, aba àla dusi dɨ lade me, nə i gun gɨ dusɨn so kaláng bədə me, nə i aba àla dwani nan̰ me, aba àla ladni nan̰ me ca. ");
INSERT INTO sor_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Ladni ni di ha ꞌya lə gun dɨwə bɨraa mage duwa nə dubu lə bá. Gun gaba àláw jaw gun wamani labaa, gaba gɨn̰ə bii ni gɨ ꞌwoo bam labaa, gaba àla àcn̰a da, nə kal dusɨn hɨlal le dɨwə. Ɗɨm da, gun gaba àla mani nə ha lə bədə da, nə kalɨw pəgɨn̰ ya gun gaba àla mani bədə de bədə. Gun gɨ àlna mani nə hana lə bədə da, nə ha àsaw wamani dɨwə me, wamani gɨ ta di, ha pama dɨndaw bɨraa hára nɨm mage duwa nə dii subu labaa nə dii wodɨ lə bá.» ");
INSERT INTO sor_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Mana gɨ ta lə dog, Moyis piy gubɨrəw dodə me lɨngɨ dɨw dodə ɓɨl sɨn̰a dara mɨlawda gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰, ");
INSERT INTO sor_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","me way ba da: «Aba ciri ni, nə amsɨm ɗe! Sɨm ꞌywalnamme dɨnnə da, bonin ha gandanin. I sɨdɨ, nare nə ta di, dɨdəgɨ woy nan̰e. Kal dusɨm hɨlal mani nin nə àcn̰e me nə ha lə bədə di me, dɨdəgɨ lə. Yərnin nə inin mani dɨma nə ꞌywaa.» ");
INSERT INTO sor_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: «Doy, nə u bɨn ɨndi, nə way dara ba nə yɨ gandang mɨlan. Nə ha àla mani nə dan̰a nare dɨma nə pad ta di dɨrəgɨ lə. Mani nə dan̰a nə ta di, dii mɨn kaw àlal mana gɨ sɨn̰a dɨdə ka bədə me, mana gɨ nare nə ɗang nə gɨndəgɨ jiga jiga pad dwar̰agɨ lə bədə me ca. Mwom da, nare nə Israyel nə ɗɨbɨ liwɨm daa pad ta di, ha yara mani nə dan̰a nə àl lán̰a nan̰ nə nə àlgɨ̀ gandɨm ta di gɨ dɨrəgɨ day. ");
INSERT INTO sor_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Mani nə nə wayang gandagɨ laba ta di, yɨnəgɨ ladɨ le àlna gɨ giyə. Dwayna, nə ha ꞌywara nare nə Amori me, nə Kanan me, nə Hiti me, nə Perisi me, nə Hibi me, nə Yebus me daa dɨrəngə. ");
INSERT INTO sor_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Àsɨna angal dan ladɨ le! Kalna yəə mɨlan gɨ nare nə anə ilə hára dama ciri dayyə ta di ɗi. Anə yɨnə gandagɨ da, cendi ha lamang yɨbənge ya boy ba yɨ gɨ mani de. ");
INSERT INTO sor_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Me ꞌyeni da, anə ha cubə mana day gaba bwasa gɨ domde  bam me, anə ha cubə kur̰a dɨ cendi jogdɨdɨ daa ɨrmɨdɨ dwama day di bam me, anə ha sawa habda gɨnə dwama gɨ gɨ ꞌwogɨw Achera bam me ca. ");
INSERT INTO sor_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Anə ha piyə gubɨrəng dodə nare domde day dɨrəgɨ lə bədə, dara ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ di sumɨn i Aba halgɨni. I sɨdɨ, nə i Mãr̰ĩ gaba halgɨni ꞌyang. ");
INSERT INTO sor_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Yande da, kalna yəə mɨlan gɨ nare nə sɨn̰a dɨ ta lə di ɗi. Anə yɨnə gandagɨ mɨlan da, wála gɨ cendi dara àlagɨ́ domde day sarga da, cendi ha ꞌwagang anə ha hára wama gandagɨ mani day nə cendi àl gɨ sarga di le me ca. ");
INSERT INTO sor_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Kalna yəə gandagɨ mɨlan ɗi, dara anə yɨnə gandagɨ mɨlan da, anə ha laya dɨndɨragɨ nə namde ꞌyàgɨ́ dɨndɨrang di me, dɨndɨragɨ di ha lama dɨndɨrang bwagɨ bwasa gɨ domde day di lə me ca. ");
INSERT INTO sor_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Anə ha n̰urə mani dúndɨrəgɨ gɨ biri ɨrməgɨ dwama bədə. ");
INSERT INTO sor_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Anə ha àla sii ꞌywala gɨnə mapa gɨ dɨban musbu. Wála wurgɨsubu gɨnə duru gɨ swagə ganda day gɨ dɨdəgɨ lə di da, anə ha wama mapa gɨ dɨban musbu mɨra, ya ba nə wayang nɨm de. Dara i duru gɨ ta di dalawə me, nə dɨməng nɨm bam sɨn̰a dɨ Ejibtɨ lə di. ");
INSERT INTO sor_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Dine nə abje nə man̰jɨli pad da, i ni ɨndi. Ina mani nə paga nə dine labaa nə gechide dɨndɨragɨ nə abje nə gɨ yə̀gɨ dɨrɨn̰ nə piiyə pad kaw, i ni ɨndi me ca. Anə ha ꞌyàn gandagɨ sarga. ");
INSERT INTO sor_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Ɗɨm da, kura dwe dɨra gɨ abe gɨ gɨ yə̀w dɨrɨn̰ nə piiyə da, anə ha yəə gəgɨr̰ɨn̰ labaa cange gɨ dwe ꞌyán bɨw me ca. Me anə ùrnə dara kɨlangaw bədə da, anə ha aja gɨgɨnaw ꞌyáw bam. Me dɨndɨrang nə abje nə man̰jɨli pad da, anə ha ꞌyàa gursɨ bɨdəgɨ. Kal gun hane ꞌywanan ɨsəw pəgɨn̰ bədə. ");
INSERT INTO sor_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","I wála kubi dalawə me anə ha àla giyə dan lə pad, ɗɨm da, wála gɨ wurgɨsubu lə da, anə ha bwaa i gwayni. Ina i wála gaba yiga lə labaa, gaba n̰ilə swagə lə kaw, àlna giyə bədə. ");
INSERT INTO sor_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Anə ha àla sii ꞌywala gɨnə n̰ilbə gɨ swagə mana gɨ anə n̰ilnə geme dan gɨ naa dɨrɨn̰ nə piiyə di. Ɗang da, aliya ꞌyan̰a duwa lə da, anə ha àla sii ꞌywala gaba cəə yabɨr̰a yàa duwa me gaba ara olib yàa duwa me ca. ");
INSERT INTO sor_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Aliya mɨn dalawə da, abje nə Israyel pad hane dɨrənnə dii subu, ɨndi gɨ nə i Aba ciri dan gɨ nə i Aba dama gɨ dɨrən bɨr̰ɨn̰ Mãr̰ĩ gɨnə ꞌyeni nə Israyel dan di. ");
INSERT INTO sor_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Nə ha ꞌywara nare nə gɨndəgɨ jiga jiga daa dɨrəngə sɨn̰a day dɨ cendi dam lə di me, nə ha àla sɨn̰a dan di ha cwara ɓɨlə le me ca. Gun mɨn kaw ha ùrə dara chabadɨ bam ɨsɨrangə wála gɨnə sii ꞌywala gɨ subu lə ta di gɨ anə ha hára nɨm ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ gɨ nə i Mãr̰ĩ dan di dɨrənnə bədə. ");
INSERT INTO sor_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Mana gɨ anə dara kundɨbə mani nə paga dara àlán gɨ sarga da, ɓamna kabni day gɨ mapa gɨ anə àlɨ̀w gɨ musbu di daa bədə. Anə ha gama mani nə anə kundɨbɨgɨ dara sii ꞌywala gɨnə kɨrara gɨ daa kwaynaniyə di kabni day wála daa sanga bədə me ca. ");
INSERT INTO sor_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Swagə dan nə yiga nə naa dɨrɨn̰ nə piiyə da, anə ha ꞌwoo dɨdəgɨ hára nɨm ꞌyàn ɨndi Gaba dama gɨ dɨrən bɨr̰ɨn̰ gɨ nə i Mãr̰ĩ dan di mana gɨ kulu niyə. Anə kundɨnə cange gɨ dwe da, anə ha hangdaw gɨ nãy nənə iw bədə.» ");
INSERT INTO sor_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: «Jangɨ gwale gɨ ta di dodə, dara i gwale gɨ ta di me nə yɨ nɨm gandɨm mɨlan ɨjɨm me, nare nə Israyel di me.» ");
INSERT INTO sor_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Moyis dama gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ daa kur̰a dɨ Sinay dɨdə àla wála gɨnɨn̰ wodɨ. An̰ji wama mani bədə me, chàa nimi bədə me ca. An̰ji janga gwale gaba yəə gɨ mɨlan di mana gɨ kur̰a dɨ ɓɨdɨr̰a ɓɨdɨr̰a di sɨdə, i bii gɨ ꞌwoo gɨ mwaj di. ");
INSERT INTO sor_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Ɨr̰ɨ Moyis chə́ə daa kur̰a dɨ Sinay dɨdə hára dodə. An̰ji yɨbə kur̰a dɨ ɓɨdɨr̰a ɓɨdɨr̰a sɨr dɨ bii gɨ ꞌwoo gɨ Mãr̰ĩ yɨ gɨ mɨlan gɨ nare nə Israyel ilə sɨdə di ɨsəwə me, dɨrəw ácn̰e me, dara Aba dama gɨ dɨrəw bɨr̰ɨn̰ waya gandɨw gwale, me an̰ji ꞌwocn̰ dara dɨrəw ba ácn̰e bədə. ");
INSERT INTO sor_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Mana gɨ nə Arõ day gɨ nə nare nə Israyel pad ba gɨ yər Moyis di dɨrəw ácn̰e da, lán̰a àlgɨ̀ le me, cendi chidɨbə hára Moyis di sɨwə ib ib bədə. ");
INSERT INTO sor_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Ɨr̰ɨ Moyis ꞌwagagɨ sɨwə me, Arõ day gɨ nə gechide nənə nare nə Israyel day hára ꞌyow, me an̰ji waygɨ gwale. ");
INSERT INTO sor_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Targɨn̰ ɗang da, nare nə Israyel pad chidɨbə hára Moyis sɨwə ib ib me, an̰ji waygɨ bii gɨ ꞌwoo gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ ꞌyàw gandɨw daa kur̰a dɨ Sinay dɨdə di pad. ");
INSERT INTO sor_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Mana gɨ Moyis ba a waygɨ gwale di bam pad mwom da, an̰ji bo barge gɨ ladɨwe dɨrəwə budɨ gɨ dɨrəw. ");
INSERT INTO sor_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Mana gɨ ta lə bá da, Moyis gandɨna hana kundi gaba ɓamara gɨ Mãr̰ĩyə  dara waya gandɨw gwale da, an̰ji lay barge di bam dɨrəwə bɨraa ganda duwa gɨ icheyə bá. An̰ji gandɨnay iche da, waygɨ nare nə Israyel mani nə Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayaw bá bá dara an̰ju ba cɨmnəgɨ daa di. ");
INSERT INTO sor_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Nare nə Israyel yər Moyis dɨrəw ácn̰e mwom da, an̰ji bo barge gɨ ladɨwe di dɨrəwə bi. I mana gɨ an̰ji gandɨna dara hára ꞌywaa Aba dama gɨ dɨrəw bɨr̰ɨn̰ dara waya gandɨw gwale bá do me, lay barge di bam dɨrəwə sɨn̰. ");
INSERT INTO sor_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Ɨr̰ɨ Moyis ꞌwaga nare nə Israyel pad dáygɨ dodə me waygɨ ba da: «Dwayna, gwale gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayang anə banə unə àlna gɨ giyə di me i ta: ");
INSERT INTO sor_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Anə ha àla giyə dan i wála kubi dalawə me, wála gɨ wurgɨsubu lə da, anə ha biyəw chə́w jiga, an̰ji i wála gaba bwaa gwayni dara àsaw gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ sumi gɨ ꞌwaga dɨwə. Me gun gɨ àlna giyə wála gɨ ta lə di da, ùr i ꞌyáa gɨ bam. ");
INSERT INTO sor_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Mana dan gɨ anə damna lə bá bá da, gun ha lama dùwa ciri duwa dwar̰ɨ lə wála gaba bwaa gwayniyə di bədə.» ");
INSERT INTO sor_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Ɨr̰ɨ Moyis waygɨ nare nə Israyel pad ba da: «Dwayna gwale gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw di me i ta: ");
INSERT INTO sor_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Nare nə Israyel salnay mani day nə ꞌywaa yab ꞌyànán. Nare woni ꞌyàn mani day nə ꞌywaa di, wi kaw ꞌyàna gɨ ùrə duwa. Mani nə cendi ha salan gandagɨ di me i ta: jindar me, tuda me, biri gɨ bor ngɨr ngɨr me, ");
INSERT INTO sor_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","chire gɨ bor ngɨr ngɨr me, gɨ kwamge me, gɨ wusɨ bəliyə me, chire gɨ ɗang gɨ lade me, wudɨn̰ nənə bage nə mee day me, ");
INSERT INTO sor_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","gare gɨ kulajɨ gɨnə gəgɨr̰ɨn̰je gɨ gɨ borɨwe me, gare gɨ kulajɨ gɨ ɗang gɨ lade nan̰ me, habde nə chelbe me, ");
INSERT INTO sor_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","swani gɨnə lamba dɨra me, habde dur̰u day dɨ biy ꞌyol dara ɓamagɨ àla gɨ swani ni gaba tidɨrə diiyə me dara gwasa nɨm me, ");
INSERT INTO sor_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","kur̰a dɨ komɨn̰ dɨ idɨ sumi me, dɨ ɗang dɨ ladɨbe me dara sɨrandaw gɨ woni bwasan geche day barge duwa gaba hura bwasan nɨm di me, dara sɨrandaw gɨ bos duwa gɨ jorgɨwə di me ca. ");
INSERT INTO sor_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Mwar̰ə pad nə ilə dwar̰angə di gɨ hane ɗangr̰ɨna mani pad nə Aba dama gɨ dɨrəw bɨr̰ɨn̰ u bɨw waygɨ di. ");
INSERT INTO sor_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Mwar̰ə di ha ɗangr̰a i mana duwa gɨ an̰ji ha dama lə di: Kundi duwa di sɨw di me, barge me gare me gaba dàrba dɨw dɨ daa lə di me, mani nə bɨdəgɨ kongdɨ me, habde duwa woni jwagda dɨrəgɨ daa tɨba tɨba me, habde woni dagɨla kwandagɨ nə dɨrəgɨ daa tɨba tɨba di sɨdəgɨ lə yɨbəgɨ nɨm daa me, habde woni hurba dɨrəgɨ daa dara maa gɨ barge gaba maa kundi bɨwə me gaba saba kundi dalaw dodə korgɨn̰ sɨr me, gɨdɨragɨ woni yɨbəgɨ dodə wàya me ca. ");
INSERT INTO sor_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Cendi ha ɗangr̰asandug dɨnə Mãr̰ĩ duwa me, habde dɨra woni hurba dugdɨdɨ lə yɨbə ugdədɨ nɨm me, bɨdɨ gaba ɗyasadɨ nɨm daa me, barge gaba saba kundi dalaw dodə korgɨn̰ sɨr me. ");
INSERT INTO sor_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","Cendi ha ɗangr̰atabɨl ni me habde dɨra woni hurba dugdɨdɨ lə yɨbə ugdədɨ nɨm me, mani pad woni chɨ́gdə tabɨl di dɨdə me, mapa gaba chɨ́gdən ɨndi gɨ Mãr̰ĩ di me. ");
INSERT INTO sor_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","Cendi ha ɗangr̰a mani nə gangr̰agɨ wurgɨsubu nə gɨ chɨ́gdɨ lamba lə diyə di me, mani woni àla gɨ giyə gɨnə lamba dɨra di me, lamba day me, swani gɨnə lamba me. ");
INSERT INTO sor_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","Cendi ha ɗangr̰amana gaba gwasa me habde duwa woni hurba dugdɨwə yɨbə ugdəw nɨm me, swani gɨnə Mãr̰ĩ duwa gaba tidɨrə diiyə me, mani woni gwasa me ca. Cendi ha koo barge gaba maa kundi di bɨwə me. ");
INSERT INTO sor_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","Cendi ha ɗangr̰a mana gaba ulə mani nə paga woni àláw gɨ Mãr̰ĩ sarga me, biri duwa gɨ bor ngɨr ngɨr gɨ dagɨlal jaw sɨwə sɨwə me, habde duwa woni hurba dugdɨwə yɨbə ugdəw nɨm me, mani duwa pad woni àla gɨ giyə me ca. Cendi ha ɗangr̰a mani nə ɓɨle woni bwaa nimi me gɨdɨragɨ me. ");
INSERT INTO sor_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","Cendi ha ɗangr̰a barge gaba jáa gɨ kundi daa me, habde woni hurba dɨrəgɨ daa maa gɨ barge di lə me, gɨdɨragɨ me, barge gaba maa ciri dɨ ajar daa di bɨdə me, ");
INSERT INTO sor_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","biri gaba ɓabɨr̰a dodə dara hurba gɨ habde nənə kundi di me, nə liw ciri daa di me, sade day woni magdagɨ me ca. ");
INSERT INTO sor_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Cendi ha ɗangr̰a barge gaba hura àla gɨ giyə mana gɨ kundi gɨnə Mãr̰ĩ duwa lə me, barge gaba sumi gɨ wun mɨnaw jiga gɨnə woni bwasan geche day gɨ Arõ me, barge gɨnə dɨndaw day gaba hura àla gɨ giyə gaba bwasa Mãr̰ĩ di me ca.» ");
INSERT INTO sor_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Ɨr̰ɨ nare nə Israyel pad dayyə ɓɨr̰ɨn̰ daa cəgdɨ yá kal Moyis di ");
INSERT INTO sor_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","me, nare pad nə dusɨrəgɨ ladɨbɨ nə ùr àla gɨ giyə di laya mani day háraw nɨm gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ dara ba gɨ ɗangr̰ɨnaw gɨ kundi duwa gaba ɓamara gandɨw di me, mani duwa pad woni àla giyə dalawə me, ba gɨ kunə gɨ barge gaba sumi gɨ wun mɨnaw jiga gɨnə woni bwasaw day di me ca. ");
INSERT INTO sor_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Abje me namde me woni dusi dɨ dwani hára gɨ mani woni sumi jiga jiga nə gɨ ɗangr̰ɨgɨ gɨ jindar. Nə mɨn hára gɨ mani woni ɓabɨr̰a barge sɨwə me, nə mɨn mani nə sumiyə labaa woni bwaa kunən̰yə me, nə mɨn kulɨm me ca. Nare nə ta di, hára lay jindar day di daa ꞌyàw Aba dama gɨ dɨrəw bɨr̰ɨn̰ sarga. ");
INSERT INTO sor_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Nare nə chire day gɨ bor ngɨr ngɨr labaa, gɨ kwamge labaa, gɨ wusɨ bəliyə labaa, gɨ ɗang gɨ lade nan̰ labaa, wudɨn̰ nənə bage nə mee day labaa, gare gɨ kulajɨ gɨnə gəgɨr̰ɨn̰je day gɨ gɨ borɨwe labaa, gare gɨ kulajɨ gɨ ɗang gɨ lade nan̰ ilə da, cendi laya hára nɨm. ");
INSERT INTO sor_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Nare nə bo tuda labaa, biri gɨ bor ngɨr ngɨr dara ꞌyàw Aba dama gɨ dɨrəw bɨr̰ɨn̰ da, cendi laya hára nɨm. Nare nə habde day nə chelbe woni àla gɨ giyə gɨnə kundi di ilə kaw, cendi laya hára nɨm me ca. ");
INSERT INTO sor_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Namde nə mwar̰ə lɨmə chire gɨ bor ngɨr ngɨr me, gɨ kwamge me, gɨ wusɨ bəliyə me, gɨ ɗang gɨ lade nan̰ me, laya hára nɨm. ");
INSERT INTO sor_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Namde nə ɗang nə mwar̰ə nə dusɨrəgɨ ladɨbɨ lɨmə chire gɨ wudɨn̰ nənə bage nə mee day me laya hára nɨm me ca. ");
INSERT INTO sor_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Gechide nənə nare nə Israyel day laya kur̰a dɨ komɨn̰ dɨ idɨ sumi me, dɨ ɗang dɨ ladɨbe me dara maw gɨ woni bwasa Mãr̰ĩ geche day barge gaba hura bwasa gɨ Mãr̰ĩ sɨwə me, bos duwa gɨ jorgɨwə sɨwə me. ");
INSERT INTO sor_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Cendi hára gɨ habde dur̰u day dɨ biy ꞌyol dara ɓamagɨ àla gɨ swani gɨnə lamba dɨra me, dara àla gɨ swani gɨnə Mãr̰ĩ gaba tidɨrə diiyə me, dara gwasa nɨm me ca. ");
INSERT INTO sor_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Nare nə Israyel pad, nə abje me, nə namde me, nə i gɨ dusi dɨ dwani da, laya mani gɨ ùrə day háraw gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ dara ba gɨ àlnáw gɨ giyə duwa gɨ an̰ji wayaw Moyis ba àlnáw di. ");
INSERT INTO sor_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Ɨr̰ɨ Moyis waygɨ nare nə Israyel ba da: «Dwayna, Aba dama gɨ dɨrəw bɨr̰ɨn̰ biyə Besalel gɨnə Uri gorndɨw, i Hur mwàw, gɨ gɨndɨw i gangle gɨnə Juda lə. ");
INSERT INTO sor_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","An̰ji ꞌwana dusɨw daa gɨ dúndi duwa ꞌyàw dɨrɨn̰ naa me, ꞌwacn̰a gɨ mani me, ꞌyàw mwãr̰ãni dɨ idɨ àla gɨ mani nə jiga jiga pad me. ");
INSERT INTO sor_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Besalel nem ɨrmə mani woni àla me ꞌwocn̰ àla giyə gɨnə jindar le me, tuda le me, biri gɨ bor ngɨr ngɨr le me. ");
INSERT INTO sor_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","An̰ji ꞌwocn̰ janga gɨ mani kur̰a dɨ lade dɨ idɨ sumi sɨdə me magdadɨ mani sɨdəgɨ lə me, ꞌwocn̰ pɨlbə gɨ habde le me ca. An̰ji ꞌwocn̰ àla gɨ mani nə jiga jiga le pad. ");
INSERT INTO sor_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Ɗang da, Aba dama gɨ dɨrəw bɨr̰ɨn̰ ꞌyàw ꞌwacn̰a gaba gɨləgɨ gɨ nare mwãr̰ãni dɨ idɨ àla gɨ giyə gɨ ta di me, Oliyab gɨnə Aysamak gorndɨw gɨ gɨndɨw i gangle gɨnə Dannə kaw, an̰ji ꞌyàw ꞌwacn̰a gaba gɨləgɨ gɨ nare mwãr̰ãni dɨ ta di me ca. ");
INSERT INTO sor_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Aba dama gɨ dɨrəw bɨr̰ɨn̰ ꞌyàgɨ́ nare nə ta di mwãr̰ãni dɨ idɨ ꞌwacn̰a janga gɨ mani kur̰a dɨ idɨ sumi sɨdə me, ɗangr̰a gɨ mani me, koo gɨ wudɨn̰ sɨrandagɨ bor ngɨr ngɨr me, kwamge me, wusɨ bəliyə me. Cendi ꞌwocn̰ lɨmə gɨ chire gɨ lade. An̰ji ꞌyàgɨ́ mwãr̰ãni dɨ idɨ ɨrmə mani woni àla me, dɨ idɨ àla gɨ mani jiga jiga pad me. ");
INSERT INTO sor_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Aba dama gɨ dɨrəw bɨr̰ɨn̰ ꞌyàgɨ́ nə Besalel day gɨ Oliyab me, mwar̰ə nə ɗang pad me dɨrɨn̰ naa me, ꞌwacn̰a gɨ mani me, dara cendi ba àlna giyə gaba ɗangr̰a mani woni àláw gɨ giyə mana gɨ kundi duwa lə di. Kal cendi ba àlna ya ba a wayagɨ nɨm de dige dige.» ");
INSERT INTO sor_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Mwom da, Moyis ꞌwaga nə Besalel day gɨ Oliyab me, mwar̰ə nə ɗang pad me nə Aba dama gɨ dɨrəw bɨr̰ɨn̰ ꞌyàgɨ́ dɨrɨn̰ naa me nə wur dusɨrəgɨ dara àla gɨ giyə di. ");
INSERT INTO sor_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Ɨr̰ɨ Moyis ꞌyàgɨ́ nare nə ta di mani pad nə nare nə Israyel hára nɨm ꞌyàw dara ɗangr̰a gɨ kundi gɨnə Mãr̰ĩ di. Gɨ jomni bá bá da, nare di hára gɨ mani ꞌyàw Moyis di gɨ ùrə day. ");
INSERT INTO sor_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Ɨr̰ɨ mwar̰ə pad nə ilə ɗangr̰a kundi gɨnə Mãr̰ĩ di wi wi kaw kala àla gɨ giyə duwa di ɗi me, ");
INSERT INTO sor_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","cendi ha wayaw Moyis ba da: «Nare di laya mani woni ɗangr̰a gɨ kundi gɨnə Mãr̰ĩ di yala nɨm ɗoy ɨrmə gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ ɨrməgɨ di bam.» ");
INSERT INTO sor_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Mana gɨ ta lə di, Moyis u bɨw way ba gɨ waynagɨ nare mana day gɨ dama lə di ba da: «Ina i abe labaa, deme kaw, kal gun mɨn hane gɨ mani duwa woni ɗangr̰a gɨ kundi gɨnə Mãr̰ĩ di bədə ɗɨm.» Mwom da, nare nə Israyel di hára gɨ mani woni ɗangr̰a gɨ kundi gɨnə Mãr̰ĩ duwa di bədə ɗɨm. ");
INSERT INTO sor_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Dara mani di nem àla gɨ giyə di le, gɨndəgɨ wor bɨl dodə. ");
INSERT INTO sor_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Mwar̰ə di ɗangr̰ɨ mani pad dodə dara ɗangr̰a gɨ kundi gɨ Mãr̰ĩ ha dama lə di: Cendi ku barge mwaj gɨ chire gɨ lade me, chire gɨ bor ngɨr ngɨr me, gɨ kwamge me, gɨ wusɨ bəliyə me. Barge gɨ mwaj di, cendi kuw sɨrandaw wun mani nə daa nə bajɨmagɨ ilə nə gɨ ꞌwogɨgɨ cherubẽ dúndɨrəgɨ. Giyə day gɨ cendi àlaw di, i giyə gɨnə woni ꞌwacn̰a koo barge ladɨ day. ");
INSERT INTO sor_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Barge gɨ mwaj ta di, barge mɨn bá bá da, charni duwa nem dar̰e mwaj dii dunasɨr gɨ tulɨn̰ me, ɓɨlnani duwa nem dar̰e sɨr gɨ tulɨn̰ me. Barge di charni duwa me, ɓɨlnani duwa me, bor mɨn pad. ");
INSERT INTO sor_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Cendi busɨ barge gɨ jii r̰endɨw daa mɨn me, gɨ wor jii di kaw, busɨw r̰endɨw daa mɨn me ca. ");
INSERT INTO sor_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","12","Barge gɨ jii gɨ busər r̰endər daa ta di, cendi busɨw gɨ bii lə ced chire gɨ lade gɨ bor ngɨr ngɨr gɨ kon̰bər daa gɨnɨn̰ jii bɨwə me, gɨ wor jii di kaw, cendi busɨw gɨ pii chire gɨ lade gɨ bor ngɨr ngɨr gɨ kon̰bər daa gɨnɨn̰ jii bɨwə me ca. Cendi busɨw bor gɨ jaw di ca ca. ");
INSERT INTO sor_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Ɨr̰ɨ cendi ɗangr̰ɨ mani nə bɨdəgɨ kongdɨ gɨnɨn̰ jii gɨ jindar me, cendi r̰endɨ barge gɨ sɨr di daa gɨ mani nə bɨdəgɨ kongdɨ di, mwom da, kundi di gɨdə mani mɨn. ");
INSERT INTO sor_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Ɗang da, cendi ku barge gɨ wudɨn̰ nənə bage nə mee dara dàra kundi di dɨwə. Cendi ku barge di i mwaj dii mɨn. ");
INSERT INTO sor_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Barge mɨn da, charni duwa nem dar̰e gɨnɨn̰ sɨr me, ɓɨlnani duwa nem dar̰e sɨr gɨ tulɨn̰ me. Barge gɨ mwaj dii mɨn ta di, charni duwa me, ɓɨlnani duwa me, bor le mɨn pad. ");
INSERT INTO sor_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Cendi busɨ barge gɨ jii r̰endɨw daa mɨn me, gɨ wor kubi di kaw, cendi busɨw r̰endɨw daa mɨn me ca. ");
INSERT INTO sor_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Barge gɨ jii gɨ busər r̰endər daa ta di, cendi busɨw gɨ biiyə ced chire gɨ lade gɨ kon̰bər daa gɨnɨn̰ jii bɨwə me, gɨ wor kubi di kaw, busɨw gɨ pii chire gɨ lade gɨ kon̰bər daa gɨnɨn̰ jii bɨwə me ca. ");
INSERT INTO sor_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Ɗang da, cendi ɗangr̰ɨ mani nə bɨdəgɨ kongdɨ gɨnɨn̰ jii gɨ biri gɨ bor ngɨr ngɨr dara r̰yanda gɨ barge gɨ sɨr di daa. I yande me barge gɨ kundi dɨwə di cor gɨdɨ mani mɨn. ");
INSERT INTO sor_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Ɗang da, cendi ɗangr̰ɨ mani woni dàra kundi di dɨwə gɨ gare gɨ kulajɨ gɨnə gəgɨr̰ɨn̰je day gɨ gɨ borɨwe me, ɗangr̰ɨ mani gɨ gare gɨ kulajɨ gɨ ɗang gɨ lade nan̰ dara dàragɨ kwandagɨ nə pii di dɨdəgɨ lə. ");
INSERT INTO sor_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Ɨr̰ɨ cendi sabɨ chelbe pɨlbɨgɨ dara jwagdagɨ dɨrəgɨ daa ɗangr̰a gɨ kundi gɨ Mãr̰ĩ ha dama lə di. ");
INSERT INTO sor_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Habde nə ta di, mɨn da, charni duwa nem dar̰e wurgɨsubu gɨ tulɨn̰ me, ɓɨlnani duwa nem dar̰e mɨn me. ");
INSERT INTO sor_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Habda mɨn da, cendi ɗangr̰ɨw bɨw sɨr sɨr gaba huraw nɨm dodə gɨdawə. Habde nənə kundi woni hurba dodə ta di, ɗangr̰ar i yande pad. ");
INSERT INTO sor_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Cendi ɗangr̰ɨ habde gɨnɨn̰ sɨr kundi tulɨw dɨ ɨsay gɨ abeyə me, ");
INSERT INTO sor_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","ɗangr̰ɨgɨ gɨdɨragɨ gɨnɨn̰ wodɨ gɨ tuda me. Habda mɨn da, cendi ɗangr̰ɨw gɨdaw sɨr sɨr woni huraw lə yə̀w jwagaw nɨm dɨrəw daa, bor gɨ habda bɨw gɨ sɨr gaba hura gɨdaw lə di. ");
INSERT INTO sor_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Kundi tulɨw dɨ ɨsay gɨ jeleyə kaw, cendi ɗangr̰ɨ habde gɨnɨn̰ sɨr me, ");
INSERT INTO sor_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","gɨdɨragɨ gɨ tuda gɨnɨn̰ wodɨ me. Habda mɨn da, cendi ɗangr̰ɨw gɨdaw di sɨr sɨr. ");
INSERT INTO sor_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Kundi tarɨwə, tulɨw dɨ turgɨ lə da, cendi ɗangr̰ɨ habde kubi lə me, ");
INSERT INTO sor_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","ɗangr̰ɨ habde nə jiga sɨr lə, mɨn mana gɨ dugdɨw dɨ targɨn̰ dɨ mɨnnə me, gɨ mɨn ɗang mana gɨ dugdɨw dɨ targɨn̰ dɨ ɗangə di me ca. ");
INSERT INTO sor_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Habde nə ta di r̰endər i dodə gɨndəgɨ lə gɨ kwandagɨ nə kundi dugdɨwə me, r̰endər daa dɨdəgɨ lə kulɨm mɨn dalawə. Dugdɨw dɨ ɗangə di kaw, àlal i yande me ca. ");
INSERT INTO sor_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","I yande me habde dunasɨr me gɨdɨragɨ nə tuda mwaj dii kubi me ilə kundi tarɨw dɨ turgɨ lə. Habda mɨn da, gɨdaw i sɨr sɨr. ");
INSERT INTO sor_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Ɨr̰ɨ cendi sabɨ chelbe pɨlbɨgɨ ɗangr̰ɨgɨ woni dagɨla kwandagɨ nə dɨrəgɨ daa tɨba tɨba di sɨdəgɨ lə yə̀gɨ nɨm daa. Kundi tulɨw dɨ mɨnnə da, cendi ɗangr̰ɨ habde di i jii me, ");
INSERT INTO sor_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","tulɨw dɨ ɗangə kaw, cendi ɗangr̰ɨ habde di i jii me, tarɨwə, tulɨw dɨ turgɨ lə kaw, cendi ɗangr̰ɨ habde di i jii me ca. ");
INSERT INTO sor_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Habda gaba dagɨla kwandaw nə dɨrəgɨ daa tɨba tɨba sɨbɨr̰əgɨ lə bɨrad da, i habda mɨn gɨ chere gɨ swaa i kundi bɨw gɨ ka lə bɨraa dɨm bɨw gɨ alə ta lə bá. ");
INSERT INTO sor_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Habde woni jwagda dɨrəgɨ daa me, woni dagɨla kwandagɨ nə dɨrəgɨ daa tɨba tɨba di sɨdəgɨ lə yɨbɨgɨ nɨm daa me da, cendi ɗangr̰ɨ jindar ɨbdɨgɨ sɨdəgɨ lə me, n̰urbɨ kulɨm gaba hurba habde woni dagɨla kwandagɨ nə dɨrəgɨ daa tɨba tɨba di sɨdəgɨ lə dara yɨbəgɨ nɨm daa di gɨ jindar me ca. ");
INSERT INTO sor_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Ɨr̰ɨ mwar̰ə di ku barge gɨ geche gɨ chire gɨ bor ngɨr ngɨr me, gɨ kwamge me, gɨ wusɨ bəliyə me, chire gɨ ɗang gɨ lade nan̰ me, sɨrandɨw wun ya mani nə daa nə bajɨmagɨ ilə nə gɨ ꞌwogɨgɨ cherubẽ dúndɨrəgɨ de. Giyə day gɨ cendi àlàw di, i giyə gɨnə woni ꞌwacn̰a koo barge ladɨ me sɨrandaw me day. ");
INSERT INTO sor_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Ɗang da, cendi sabɨ chelbe wodɨ woni hurba dɨrəgɨ daa maa gɨ barge di lə. Cendi ɗangr̰ɨ jindar ɨbdɨgɨ sɨdəgɨ lə me, n̰ur gɨdɨragɨ wodɨ gɨ tuda dara hurbagɨ lə jwagdagɨ nɨm dɨrəgɨ daa me, ɗangr̰ɨgɨ mani nə bɨdəgɨ kongdɨ gɨ jindar dara maa gɨ barge di me ca. ");
INSERT INTO sor_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Mwar̰ə di ku barge gɨ geche gaba maa kundi bɨwə sɨrandɨw gɨ chire gɨ bor ngɨr ngɨr me, gɨ kwamge me, gɨ wusɨ bəliyə me, chire gɨ ɗang gɨ lade nan̰ me. Giyə day gɨ cendi àlàw di, i giyə gɨnə woni ꞌwacn̰a koo barge ladɨ me sɨrandaw me day. ");
INSERT INTO sor_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Ɗang da, cendi sabɨ habde jii woni hurba dɨrəgɨ daa maa gɨ barge di lə. Cendi ɗangr̰ɨ jindar ɨbdɨgɨ dɨdəgɨ dɨ daa lə me, n̰ur gɨdɨragɨ jii gɨ biri gɨ bor ngɨr ngɨr dara hurbagɨ lə jwagdagɨ nɨm dɨrəgɨ daa me. Ɗang da, cendi ɗangr̰ɨgɨ biri day gaba maa gɨ barge gɨ jindar me, ɗangr̰ɨ mani nə bɨdəgɨ kongdɨ dara maa gɨ barge di lə me ca. ");
INSERT INTO sor_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Ɗang da, Besalel ɗangr̰ɨ sandug dɨnə Mãr̰ĩ duwa di gɨ habde nə chelbe. Charni dɨra nem dar̰e mɨn gɨ tulɨn̰ me, ɓɨlnani dɨra nem dar̰e mɨn me, hwaa dɨra kaw nem dar̰e mɨn me ca. ");
INSERT INTO sor_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","An̰ji ɗangr̰ɨ jindar sɨdɨ dɨ wed ɨbdɨdɨ dwar̰ɨ lə me tardɨ lə me. An̰ji ɗangr̰ɨ jindar bɨdə mɨdən̰ gugɨrɨdɨ nɨm daa. ");
INSERT INTO sor_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","An̰ji n̰ur kulɨm wodɨ gɨ jindar bodɨ sandug di dugdɨdɨ lə. An̰ji bodɨ kulɨm di sɨr dugdɨdɨ dɨ ka lə me, sɨr dugdɨdɨ dɨ ta lə me. ");
INSERT INTO sor_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","An̰ji sabɨ habde nə chelbe sɨr ɗangr̰ɨgɨ me, ɗangr̰ɨ jindar ɨbdɨgɨ sɨdəgɨ lə me. ");
INSERT INTO sor_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","An̰ji hurbə habde nə ta di mana gɨ kulɨm di dalawə ka me, ka me, dara yɨbə ugdə gɨ sandug di daa hára nɨm. ");
INSERT INTO sor_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","An̰ji ɗangr̰ɨ sandug di bɨdɨ gɨ jindar sɨdɨ dɨ wed. Charni dɨra nem dar̰e mɨn gɨ tulɨn̰ me, ɓɨlnani dɨra nem dar̰e mɨn me ca. ");
INSERT INTO sor_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","An̰ji ichɨ mani nə daa nə bajɨmagɨ ilə nə gɨ ꞌwogɨgɨ cherubẽ dúndɨrəgɨ sɨr gɨ jindar sandug di bɨdə, tulɨn̰ dɨ ka lə me, dɨ ka lə me ca. ");
INSERT INTO sor_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Cherubẽ nə sɨr ta di, an̰ji gobɨgɨ ꞌyorgɨ i sandug di bɨdə mɨn ha daa, gɨ mɨn tuldɨ dɨ ka lə me, gɨ mɨn tuldɨ dɨ ka lə me ca. ");
INSERT INTO sor_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Cherubẽ nə ta di, wi kaw co dɨrəw ɨjɨ jaw sandug di dɨdə me dàr bajɨmaw daa sandug di dɨdə dara gamadɨ nɨm me, wi kaw yər dɨrəw dodə sandug di bɨdə me ca. ");
INSERT INTO sor_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Ɗang da, Besalel ɗangr̰ɨ tabɨl dɨ idɨ chɨ́gdəw Mãr̰ĩ mapa di gɨ habde nə chelbe. Charni dɨra nem dar̰e tuldɨ sɨr me, ɓɨlnani dɨra nem dar̰e tuldɨ mɨn me, hwaa dɨra kaw, nem dar̰e mɨn me ca. ");
INSERT INTO sor_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","An̰ji ɗangr̰ɨ jindar sɨdɨ dɨ wed ɨbdɨdɨ sɨdə me, ɗangr̰ɨ jindar bɨdə mɨdən̰ gugɨrədɨ nɨm daa me ca. ");
INSERT INTO sor_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","An̰ji ɗangr̰ɨ habde nə dugdɨdɨ lə cab cab, ɓɨlnani day nem ɓɨlnani gɨnə ɨsəm dalaw mɨn me, ɗangr̰ɨ jindar ɨbdɨgɨ sɨdəgɨ lə mɨdən̰ gugɨrɨgɨ nɨm daa me ca. ");
INSERT INTO sor_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","An̰ji ɗangr̰ɨ kulɨm wodɨ gɨ jindar bodɨ tabɨl di dugdɨdɨ dɨ ɨrmər gɨ gɨdadɨ nə wodɨ di lə. ");
INSERT INTO sor_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","15","Kulɨm gɨ ta di, an̰ji hurbəw i habde nə tabɨl dugdɨdɨ lə cab cab di sɨdəgɨ lə ib ib. An̰ji sabɨ habde nə chelbe sɨr ɗangr̰ɨgɨ me, ɗangr̰ɨ jindar ɨbdɨgɨ sɨdəgɨ lə me ca. An̰ji hurbɨ habde nə ta di mana gɨ kulɨm di dalawə dara yɨbə ugdə gɨ tabɨl di daa hára nɨm. ");
INSERT INTO sor_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","An̰ji ɗangr̰ɨ mani woni chɨ́gdə tabɨl dɨdə: subɨra dɨra me, kob dɨra me, pɨr̰ɨm dɨra me, mani woni bwaw Mãr̰ĩ gani gɨnə yabɨr̰a yàa duwa me. Mani nə pad ta di, an̰ji ɗangr̰ɨgɨ i gɨ jindar sɨdɨ dɨ wed. ");
INSERT INTO sor_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Ɗang da, Besalel ɗangr̰ɨ mani nə gangr̰agɨ wurgɨsubu nə gɨ chɨ́gdɨ lamba lə diiyə gɨ jindar sɨdɨ dɨ wed. Mani di gɨdɨragɨ me, sɨdəgɨ gɨ korgɨn̰ gɨ gangr̰e agdɨ lə me, kob day me, gur̰iya day me, mani nə wun ya habda hoo duwa de me, ilə. An̰ji ichɨgɨ i gɨ jindar mɨn. ");
INSERT INTO sor_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Mani di sɨdəgɨ gɨ korgɨn̰yə da, gangr̰agɨ kubi ilə, nə subu agdɨ ha tulɨn̰ dɨ ka lə me, nə subu agdɨ ha tulɨn̰ dɨ ka lə me ca. ");
INSERT INTO sor_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Gangr̰agɨ nə kubi ta di, gangr̰agɨ gɨ mɨnnə bá bá da, kob ilə gur̰iya gɨ subu di sɨwə bá bá me, mani dɨra nə wun ya habda hoo duwa de kaw ilə bá bá me ca. ");
INSERT INTO sor_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Me mani di sɨdəgɨ gɨ korgɨn̰yə da, kob wodɨ gɨ gur̰iya me gɨ mani dɨra nə wun ya habda hoo duwa de me, ilə. ");
INSERT INTO sor_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Mana gɨ mani gangr̰agɨ nə sɨr nə agdɨ ha ka me, ka me ta di, gur̰iya ilə gɨndəgɨ lə bá bá. Gangr̰agɨ nə kubi ta di, gur̰iya ilə gɨndəgɨ lə gɨndəgɨ lə. ");
INSERT INTO sor_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Mani di gur̰iya day me, gangr̰agɨ di me da, ichər i gɨ jindar mɨn, i gɨ jindar sɨdɨ dɨ wed. ");
INSERT INTO sor_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","An̰ji ɗangr̰ɨgɨ lamba day dɨ wurgɨsubu di me, mani woni jana lamba chire dɨra gɨ ꞌyo bam ɗɨm di me, mani woni bwaa dɨbɨrɨn̰ dɨnə chire gɨ ꞌyo bam ɗɨm di lə me, gɨ jindar sɨdɨ dɨ wed. ");
INSERT INTO sor_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","An̰ji ɗangr̰ɨ mani nə gangr̰agɨ wurgɨsubu di me, mani day nə pad di me, i gɨ jindar sɨdɨ dɨ wed dɨ noo dɨra nem kilo gɨnɨn̰ subu. ");
INSERT INTO sor_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Ɗang da, Besalel ɗangr̰ɨ mana gaba gwasa. An̰ji ɗangr̰ɨw i gɨ habde nə chelbe. Charni duwa me, ɓɨlnani duwa me, bor mɨn, nem dar̰e tuldɨ mɨn mɨn. Hwaa duwa da, nem dar̰e tuldɨ sɨr. An̰ji ɗangr̰ɨ habde nə dugdɨwə wodɨ sor daa ya hugdi de. Hugdi nə ta di so i mana gaba gwasa di sɨwə mɨn. ");
INSERT INTO sor_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","An̰ji ɗangr̰ɨ jindar sɨdɨ dɨ wed hurəw sɨwə me, dɨwə me, hugdəwə di me, ɗangr̰ɨ jindar sɨdɨ dɨ wed bɨwə mɨdən̰ gugɨrɨw nɨm daa me ca. ");
INSERT INTO sor_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","An̰ji n̰ur kulɨm gɨ jindar sɨr hurbəw dugdɨw dɨ ka lə me, sɨr dugdɨw dɨ ta lə me ca. An̰ji hurbə kulɨm gɨ ta di i mana gɨ tulbəwə dodə bɨw gɨ mɨdən̰ di gɨndɨwə dara hurba gɨ habde woni yɨbə ugdəw daa hára nɨm. ");
INSERT INTO sor_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Habde nə ta di, an̰ji sabɨ i chelbe ɗangr̰ɨgɨ me, ɗangr̰ɨ jindar hurbəgɨ sɨdəgɨ lə. ");
INSERT INTO sor_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Ɗang da, an̰ji ɓam mani àlɨw gɨ Mãr̰ĩ swani duwa gaba tidɨrə diiyə me, ɓam habde dur̰u day àl gɨ mani woni gwasa nə lade nan̰ me ca. I giyə gɨnə aba ɓama mani àla gɨ swani di duwa. ");
INSERT INTO sor_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Cendi ɗangr̰ɨ mana gaba bwasa Mãr̰ĩ gɨ i mana gaba ulə mani nə paga àláw gɨ Mãr̰ĩ sarga gɨ habde nə chelbe. Charni duwa me, ɓɨlnani duwa me, bor mɨn, nem dar̰e subu gɨ tulɨn̰ tulɨn̰. Hwaa duwa da, nem dar̰e sɨr. ");
INSERT INTO sor_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Cendi ɗangr̰ɨw dugdɨw dɨ wodɨ di sor ya hugdi de. Hugdi nə ta di so i sɨwə gang. Cendi ɗangr̰ɨ biri gɨ bor ngɨr ngɨr hurəw tarɨwə me ca. ");
INSERT INTO sor_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Ɗang da, cendi ɗangr̰ɨ mani woni àla giyə gɨnə mana gaba bwasa Mãr̰ĩ di duwa. Mani di, i mani woni laya dɨbɨrɨn̰ dɨ gɨ ul mani nə paga lə di bam me, pel me, kob dɨ idɨ ꞌwoo bare me, mani woni cwagda kabni gɨ dùwa lə daa daa me, mani woni laya gur̰ɨn̰ə me ca. Mani nə pad ta di, cendi ɗangr̰ɨgɨ i gɨ biri gɨ bor ngɨr ngɨr. ");
INSERT INTO sor_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Mana gaba bwasa Mãr̰ĩ di, cendi ɗangr̰ɨ́w biri gɨ bor ngɨr ngɨr dagɨlɨ́w jaw sɨwə sɨwə me, cendi hurə biri di mana gaba bwasa Mãr̰ĩ di korgɨn̰ sɨbɨr̰əwə bɨrad. Biri gɨ ta di i mana gɨ bɨw gɨ mɨdən̰ gɨndɨw dɨ dodə lə. ");
INSERT INTO sor_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Ɗang da, cendi n̰ur kulɨm wodɨ hurbəw dugdɨw dɨ wodɨ lə biri di sɨwə sɨwə dara hurba gɨ habde kulɨm di dalawə. ");
INSERT INTO sor_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Ɨr̰ɨ cendi sabɨ habde nə chelbe sɨr pɨlgɨ ɗangr̰ɨgɨ me, ichə biri gɨ bor ngɨr ngɨr hurbəgɨ sɨdəgɨ lə me ca. ");
INSERT INTO sor_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Cendi hurbə habde nə ta di mana gɨ kulɨm di dalawə dara yɨbəgɨ ugdə gɨ mana gaba bwasa Mãr̰ĩ di daa hára nɨm. Mana gaba bwasa Mãr̰ĩ di, cendi ɗangr̰ɨw gɨ habde me, kal dalaw gubu. ");
INSERT INTO sor_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Ɗang da, cendi ɗangr̰ɨ mani nə ɓɨle woni bwaa nimi gɨ biri gɨ bor ngɨr ngɨr me, ɗangr̰ɨgɨ gɨdɨragɨ woni chə́gɨ me gɨ biri gɨ bor ngɨr ngɨr me ca. Biri gɨ ta di, gɨ lay i gudɨram gɨnə namde woni àla giyə mana gɨ kundi gaba ɓamara gɨ Mãr̰ĩ bɨwə di day me àl nɨm. ");
INSERT INTO sor_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Ɨr̰ɨ cendi ɗangr̰ɨ mani dodə dara aja ciri liwə kundi gɨnə Mãr̰ĩ duwa di daa me, kala ciri dwar̰ɨ ba ina lə me ca. Cendi ku barge gaba jádɨ nɨm gɨ chire gɨ lade. Tuldɨ dɨ ɨsay gɨ abeyə da, ciri di charni dɨra nem dar̰e gɨnɨn̰ kubi gɨ dii kubi. ");
INSERT INTO sor_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","11","Cendi ku barge di me, pɨlbɨ habde woni hurba dɨrəgɨ daa tɨba tɨba dara maa gɨ barge di lə gɨnɨn̰ sɨr me, ɗangr̰ɨ gɨdɨragɨ woni yɨbəgɨ daa gɨ biri gɨ bor ngɨr ngɨr gɨnɨn̰ sɨr me ca. Me mani day nə bɨdəgɨ kongdɨ woni yəə barge di dàraw nɨm daa di me, biri day gaba maa gɨ barge me da, cendi ɗangr̰ɨ i gɨ tuda. Kundi di tulɨw dɨ ɨsay gɨ jeleyə kaw, i yande me ca. ");
INSERT INTO sor_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Ciri di ɓɨlnani dɨra dɨ tulɨn̰ dɨ turgɨ lə da, barge gaba jádɨ nɨm di nem dar̰e gɨnɨn̰ subu gɨ dii subu. Cendi ku barge di me, pɨlbɨ habde woni hurba dɨrəgɨ daa tɨba tɨba dara maa gɨ barge di lə mwaj me, ɗangr̰ɨ gɨdɨragɨ woni yɨbəgɨ daa mwaj me ca. Me cendi ɗangr̰ɨ mani nə bɨdəgɨ kongdɨ woni yəə barge dàraw daa di me, biri gaba maa gɨ barge ɓamaw gɨ habde nə dɨrəgɨ daa tɨba tɨba di me i gɨ tuda. ");
INSERT INTO sor_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Ciri di ɓɨlnani dɨra dɨ tulɨn̰ dɨ jomniyə kaw, nem dar̰e gɨnɨn̰ subu gɨ dii subu me ca. ");
INSERT INTO sor_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","15","Ciri bɨdɨ ilə tulɨn̰ dɨ ta lə di. Ciri bɨdɨ di tuldɨ dɨ mɨn da, barge dɨra charni duwa nem dar̰e mwaj. Cendi ku barge di me, pɨlbɨ habde woni hurba dɨrəgɨ daa tɨba tɨba dara maa gɨ barge di lə subu me, ɗangr̰ɨ gɨdɨragɨ woni yɨbəgɨ daa gɨ biri gɨ bor ngɨr ngɨr subu me ca. Ciri bɨdɨ di tuldɨ dɨ ɗangə di kaw, i yande me ca. ");
INSERT INTO sor_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Barge gaba jáa ciri daa pad di, gɨ kuw i gɨ chire gɨ lade. ");
INSERT INTO sor_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Habde pad woni hurba dɨrəgɨ daa tɨba tɨba liw ciri daa gɨdɨragɨ da, cendi ɗangr̰ɨgɨ i gɨ biri gɨ bor ngɨr ngɨr me, mani day nə bɨdəgɨ kongdɨ woni yəə barge dàraw nɨm daa di me, biri day gaba maa gɨ barge me di da, cendi ɗangr̰ɨgɨ i gɨ tuda me, habde woni hurba dɨrəgɨ daa tɨba tɨba di dɨdəgɨ dɨ daa lə da, ɗangr̰ar i gɨ tuda me ca. Habde pad nə hurbər dɨrəgɨ daa tɨba tɨba woni liwə ciri daa di da, biri gaba maa barge gɨ gɨ ɗangr̰ɨw gɨ tuda di ilə dwar̰agɨ lə bá bá. ");
INSERT INTO sor_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Ciri bɨdɨ di sɨdɨ dɨra da, cendi koo barge gɨ geche sɨrandɨw gɨ chire gɨ bor ngɨr ngɨr me, gɨ kwamge me, gɨ wusɨ bəliyə me, chire gɨ ɗang gɨ lade nan̰ me, dara maa lə. Giyə day gɨ cendi àlaw di, i giyə gɨnə woni ꞌwacn̰a sɨranda barge ladɨ day. Barge gɨ ta di charni duwa da, nem dar̰e mwaj dii subu me, ɓɨlnani duwa kaw nem dar̰e subu gɨ tulɨn̰ me, ya barge gɨnə ciri sɨdɨ di dɨra de me ca. ");
INSERT INTO sor_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Barge gɨ geche gɨ ta di, habde duwa woni hurba dɨrəgɨ daa tɨba tɨba wodɨ dara maw lə me, gɨdɨragɨ woni yɨbəgɨ daa me da, cendi ɗangr̰ɨgɨ i gɨ biri gɨ bor ngɨr ngɨr. Mani nə bɨdəgɨ kongdɨ woni yəə barge dàraw daa me, biri gaba maa gɨ barge di me da, cendi ɗangr̰ɨgɨ i gɨ tuda. Me habde woni hurba dɨrəgɨ daa tɨba tɨba di dɨdəgɨ dɨ daa da, cendi ɗangr̰ɨ tuda hurbəgɨ lə. ");
INSERT INTO sor_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Mani woni ɓabɨr̰a dodə pad dara magda gɨ kundi gɨnə Mãr̰ĩ duwa di me, ciri dɨ ajar daa dɨwə di me da, gɨ ɗangr̰ɨgɨ i gɨ biri gɨ bor ngɨr ngɨr. ");
INSERT INTO sor_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","23","Besalel gɨnə Uri gorndɨw, i Hur mwàw gɨ gɨndɨw i gangle gɨnə Juda lə di me àl mani pad nə Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba àlnagɨ̀ di. Aba waw lə àla gɨ giyə lə da, i Oliyab gɨ nə Aysamak gorndɨw gɨ gɨndɨw i gangle gɨnə Dannə. An̰ji duwa da, i aba ꞌwacn̰a janga gɨ mani kur̰a dɨ idɨ sumi sɨdə me, ɗangr̰a gɨ mani me, koo gɨ wudɨn̰ sɨrandagɨ gɨ chire gɨ bor ngɨr ngɨr me, kwamge me, wusɨ bəliyə me. An̰ji ꞌwocn̰ lɨmə gɨ chire gɨ lade. I Moyis me ɨrmɨgɨ nare nə Lebi dara cendi ba āsɨna mani nə gɨ ɗangr̰ɨ gɨ kundi gɨ Mãr̰ĩ dam lə, gɨ i mana gaba gama mani woni mɨlan dɨ Mãr̰ĩ yɨ gɨ nare nə Israyel di. Nare nə Lebi di àl giyə gɨ ta di. I Itamar gɨnə Arõ gɨ i aba bwasa Mãr̰ĩ gorndɨw di me, gɨlgɨ bɨrmə an̰ju. Dwaynandɨ mani nə cendi ɗangr̰ɨ gɨ kundi di me i ta: ");
INSERT INTO sor_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Jindar pad dɨ nare nə Israyel sala hára ꞌyàa me gɨ ɗangr̰ɨ gɨ kundi gɨnə Mãr̰ĩ duwa di, noo dɨra nem ya kilo dubu mɨn (1 000) de, i kilo dɨ gɨ ɨrɨm gɨ mani mana gɨ kulu gɨnə Mãr̰ĩyə di. ");
INSERT INTO sor_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Tuda pad dɨ nare nə Israyel nə gɨ āsagɨ me sala hára ꞌyàa di, noo dɨra nem kilo dubu subu gɨ aru aru wodɨ gɨ gɨnɨn̰ sɨr (3 420), i kilo dɨ gɨ ɨrɨm gɨ mani mana gɨ kulu gɨnə Mãr̰ĩyə di. ");
INSERT INTO sor_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Nare nə Israyel nə gɨ āsagɨ di, i abje pad nə aliya day nem gɨnɨn̰ sɨr labaa nə aliya day ɗoy gɨnɨn̰ sɨr bam. Nare nə sumdəgɨ jangar dodə da, nem dubu aru aru kubi gɨ mɨn mɨn subu gɨ aru aru jii gɨ gɨnɨn̰ jii (603 550). Nare nə pad ta di, wi wi kaw hára ꞌyàa tuda dɨ noo dɨra nem chile dɨ tuda tuldɨ mɨn mɨn, i chile dɨ gɨ àl gɨ giyə mana gɨ kulu gɨnə Mãr̰ĩyə di. ");
INSERT INTO sor_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","I gɨ tuda dɨ noo dɨra nem kilo dubu subu gɨ aru aru wodɨ (3 400) me mwar̰ə n̰ur gɨ habde nə jogdər dɨrəgɨ daa tɨba tɨba nənə kundi gɨnə Mãr̰ĩ duwa di me, habde woni hurba dɨrəgɨ daa dara maa gɨ barge gaba saba kundi dalaw dodə me di, gɨdɨragɨ nə aru (100) di. Habda mɨn gɨdaw da, u i kilo gɨnɨn̰ subu gɨ dii wodɨ, wodɨ (34). ");
INSERT INTO sor_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Tuda dɨ noo dɨra nem kilo gɨnɨn̰ sɨr (20) dɨ wor dodə di me, cendi ɗangr̰ɨ gɨ mani nə bɨdəgɨ kongdɨ woni yəə barge dàraw daa di me, gɨ biri gaba maa gɨ barge di me, habde nə hurbər dɨrəgɨ daa tɨba tɨba di dɨdəgɨ dɨ daa da, cendi ɗangr̰ɨ tuda hurbəgɨ lə me ca. ");
INSERT INTO sor_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Biri pad gɨ bor ngɨr ngɨr gɨ nare nə Israyel sala hára ꞌyàa da, noo duwa nem kilo dubu sɨr gɨ aru aru wodɨ (2 400). ");
INSERT INTO sor_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","I gɨ biri gɨ ta di me mwar̰ə n̰ur gɨ habde nə jogdər dɨrəgɨ daa tɨba tɨba woni yəə barge gɨ gɨ maw kundi gɨnə Mãr̰ĩ duwa bɨwə gɨdɨragɨ me, ɗangr̰ɨ gɨ mana gaba bwasa Mãr̰ĩ me biri duwa gɨ dagɨlal jaw sɨwə sɨwə di me, ɗangr̰ɨ gɨ mani duwa pad woni àla gɨ giyə di me, ");
INSERT INTO sor_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","ɗangr̰ɨ gɨ habde nə jogdər dɨrəgɨ daa tɨba tɨba woni yəə barge gɨ gɨ maw mana gɨ ciri dɨ idɨ jáa kundi daa bɨdɨ di gɨdɨragɨ me, ɗangr̰ɨ gɨ habde nə jogdər dɨrəgɨ daa tɨba tɨba nənə ciri dɨ idɨ jáa kundi daa di gɨdɨragɨ me, ɗangr̰ɨ gɨ biri gaba ɓabɨr̰a dodə dara magda gɨ kundi di me, magda gɨ ciri dɨ idɨ jáa kundi daa di me ca. ");
INSERT INTO sor_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Gɨ chire gɨ bor ngɨr ngɨr me, gɨ kwamge me, gɨ wusɨ bəliyə me da, gɨ ku gɨ barge gaba hura àla gɨ giyə mana gɨ kundi gɨnə Mãr̰ĩyə di. Gɨ ku barge gaba sumi gɨ wun mɨnaw jiga gɨnə aba bwasa Mãr̰ĩ gɨ Arõ duwa di me ca. Mwar̰ə di àl mani di ya Aba dama gɨ dɨrəw bɨr̰ɨn̰ ba a ɨrməw gɨ Moyis de dige dige. ");
INSERT INTO sor_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Barge gaba hura bwasa gɨ Mãr̰ĩ da, mwar̰ə kuw i gɨ chire gɨ bor ngɨr ngɨr me, gɨ kwamge me, gɨ wusɨ bəliyə me, chire gɨ ɗang gɨ lade nan̰ me, cendi sɨrandɨw gɨ jindar me ca. ");
INSERT INTO sor_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Cendi gobɨ jindar di ɓɨl bam me, sabdɨ dodə hin̰e lirem lirem me, sɨrandɨ gɨ chire gɨ bor ngɨr ngɨr me, gɨ wusɨ bəliyə me, chire gɨ lade gɨ ɗang me ca. Giyə day gɨ cendi àlaw di, i giyə gɨnə woni ꞌwacn̰a koo barge ladɨ day. ");
INSERT INTO sor_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Cendi ku sade sɨr woni yə̀w nɨm daa bar̰ɨmawə ka me, ka me. ");
INSERT INTO sor_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Sade woni yə̀w maw nɨm dodə tarɨwə kaw, cendi kugɨ ya ta de me ca: gɨ kugɨ i gɨ chire gɨ bor ngɨr ngɨr me, gɨ kwamge me, gɨ wusɨ bəliyə me, chire gɨ ɗang gɨ lade nan̰ me, gɨ sɨrandɨgɨ gɨ jindar me ca. Sade nə ta di, so i barge gaba hura bwasa gɨ Mãr̰ĩ di sɨwə mɨn. Nare àl mani di ya Aba dama gɨ dɨrəw bɨr̰ɨn̰ ba a ɨrməw gɨ Moyis ta de dige dige. ");
INSERT INTO sor_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Cendi laya kur̰a dɨ komɨn̰ dɨ idɨ sumi sɨr ɗangr̰ɨdɨ me, janga Israyel dɨndaw sumdəgɨ lə sɨdə. Giyə gɨ ta di, i gɨnə gun gaba ꞌwacn̰a janga sumi kur̰a sɨdə ladɨ duwa. Ɨr̰ɨ gɨ ɗangr̰ɨ mani woni yɨbə kur̰a di dodə bar̰ɨmawə i gɨ jindar. ");
INSERT INTO sor_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Cendi maa kur̰a dɨ sɨr di mana gɨ barge gaba hura bwasa gɨ Mãr̰ĩ sade duwa nə bar̰ɨmawə di. Kur̰a dɨ ta di, sumi gɨnə gangle gɨnə nare nə Israyel day nə mwaj dii sɨr di ilə sɨdə. Cendi àl mani di ya Aba dama gɨ dɨrəw bɨr̰ɨn̰ ba a ɨrməw gɨ Moyis de dige dige. ");
INSERT INTO sor_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Mwar̰ə ɗangr̰ɨ bos gɨ woni bwasa Mãr̰ĩ geche day ha hura jorgɨwə. Giyə day gɨ cendi àlaw di, i giyə gɨnə woni ꞌwacn̰a ɗangr̰a mani ladɨ day. Cendi ɗangr̰ɨw ya ba gɨ ɗangr̰a gɨ barge gaba hura bwasa gɨ Mãr̰ĩ di ta de: Gɨ ɗangr̰ɨ̀w i gɨ chire gɨ bor ngɨr ngɨr me, gɨ kwamge me, gɨ wusɨ bəliyə me, chire gɨ ɗang gɨ lade nan̰ me, gɨ sɨrandɨw gɨ jindar me ca. ");
INSERT INTO sor_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Gɨ ɗangr̰ɨ̀w kojɨw daa dudi sɨr, mwom da, charni duwa me, ɓɨlnani duwa me, bor mɨn, nem ɨsəm dalaw charni duwa mɨn gɨ tulɨn̰ tulɨn̰. ");
INSERT INTO sor_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Gɨ hurbə kur̰a dɨ ladɨbe dɨ idɨ sumi kɨrdɨ ɗar̰ar̰a ɗar̰ar̰a wodɨ bos di sɨwə. Kur̰a dɨ kɨrər mana gɨ piiyə da, i kur̰a dɨ komɨn̰ kivbing me, dɨ labe swani duwa me, dɨ dwaga bajadɨ me. ");
INSERT INTO sor_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Kur̰a dɨ kɨrər mana gɨ sɨrrə da, i kur̰a dɨ gichəw cilɨm me, dɨ ꞌyele ꞌyil me, dɨ ꞌyogde me. ");
INSERT INTO sor_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Kur̰a dɨ kɨrər mana gɨ subu lə da, i kur̰a dɨ buchi me, dɨ sɨrande me, dɨ bor ngɨr ngɨr me. ");
INSERT INTO sor_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Kur̰a dɨ kɨrər mana gɨ wodɨ lə da, i kur̰a dɨ wusɨ bəliyə me, dɨ komɨn̰ me, dɨ gichəw sɨlɨm sɨlɨm me. Kur̰a dɨ ta di, mani woni yɨbədɨ dodə bos sɨwə di, gɨ ɗangr̰ɨgɨ i gɨ jindar. ");
INSERT INTO sor_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Kur̰a di, i mwaj dii sɨr ɨrmər gɨ gangle gɨnə nare nə Israyel day di. Kur̰a mɨn sɨdə bá da, gɨ jangɨ Israyel gorndɨw mɨn sumɨw lə bá bá. Giyə gɨ ta di, i gɨnə gun gaba ꞌwacn̰a janga sumi kur̰a sɨdə ladɨ duwa. ");
INSERT INTO sor_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Bos dugdɨwə da, gɨ ɗangr̰ɨ sul gɨ jindar sɨdɨ dɨ wed, wun ya sade nə lɨmə de me, ");
INSERT INTO sor_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","ɗangr̰ɨ mani sɨr woni yəə bos di daa me, n̰ur kulɨm sɨr gɨ jindar hurbəw bos di dugdɨw dɨ sɨr dɨ daa lə me ca. ");
INSERT INTO sor_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Gɨ bo sul gɨ sɨr di bɨw mana gɨ kulɨm gɨ bos dugdɨw dɨ daa lə ka me, ka me. ");
INSERT INTO sor_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Me bɨw gɨ ɗang da, gɨ bow mana gɨ mani nə sɨr woni yəə bos daa  barge gaba hura bwasa gɨ Mãr̰ĩ di sɨwə me ca. Mani woni yəə bos daa nə ta di i mana gɨ barge gaba hura bwasa gɨ Mãr̰ĩ sade duwa nə bar̰ɨmawə di. Gɨ bo sul di i mana gɨ barge di dɨrəwə. ");
INSERT INTO sor_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Gɨ n̰ur kulɨm sɨr gɨ jindar hurbəw bos dugdɨw dɨ sɨr dɨ dodə lə, tulɨw dɨ korgɨn̰ dɨ ɓɨləl gɨ barge gaba hura bwasa gɨ Mãr̰ĩ di. ");
INSERT INTO sor_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Gɨ n̰ur kulɨm sɨr gɨ jindar ɗang bi hurbəw mana gɨ barge gaba hura bwasa gɨ Mãr̰ĩ sade duwa nə bar̰ɨmawə bɨdəgɨ nə dodə lə. Gɨ hurə kulɨm di i mana gɨ barge di dɨrəwə, sade duwa woni yə̀w maw nɨm dodə tarɨwə di dɨdəgɨ lə. ");
INSERT INTO sor_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Gɨ maa sade nə bor ngɨr ngɨr mana gɨ kulɨm gɨnə bos duwa di bɨwə me, gɨnə barge gaba hura bwasa gɨ Mãr̰ĩ di bɨwə me ɓamgɨ daa, dara kal bos di ba damna mana gɨ barge gaba hura bwasa gɨ Mãr̰ĩ sade duwa woni yə̀w maw nɨm dodə tarɨwə di dɨdəgɨ lə mana mɨn jang, ya Aba dama gɨ dɨrəw bɨr̰ɨn̰ ba a ɨrməw gɨ Moyis de. ");
INSERT INTO sor_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Gumaj gaba hura barge gaba hura bwasa gɨ Mãr̰ĩ di dalawə sɨw duwa pad da, gɨ kuw gɨ chire gɨ bor ngɨr ngɨr. I aba ꞌwacn̰a koo barge ladɨ me kuw an̰ju. ");
INSERT INTO sor_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Gɨ kal bɨw gɨ woni bwasa Mãr̰ĩ geche day hurə gɨ dɨw lə. Bɨw gɨ ta di, gɨ bagɨw daa ladɨ dara ba chawarna bam bədə. ");
INSERT INTO sor_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Gumaj di bɨw gɨ dodə lə cab cab da, cendi magdɨ habda gɨ gɨ ꞌwogɨw «gɨrənad» yàa duwa dúndɨw lə. Gɨrənad yàa duwa dúndɨw di da, cendi ɗangr̰ɨw i gɨ chire gɨ bor ngɨr ngɨr me, gɨ kwamge me, gɨ wusɨ bəliyə me, chire gɨ ɗang gɨ lade nan̰ me. ");
INSERT INTO sor_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","26","Ɗang da, gɨ ɗangr̰ɨ dendɨle gɨ jindar sɨdɨ dɨ wed. Dendɨle di me, gɨrənad di me da, gɨ magdɨgɨ kɨlangagɨ le kɨlangagɨ le gumaj di bɨw gɨ dodə lə, dara Arõ ba hurna àlna gɨ giyə ya Aba dama gɨ dɨrəw bɨr̰ɨn̰ ba a ɨrməw gɨ Moyis de. ");
INSERT INTO sor_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Ɗang da, cendi kugɨ nə Arõ day gɨ nə dɨndaw barge day gɨ ɗang. Giyə day gɨ cendi àlaw di, i giyə gɨnə woni ꞌwacn̰a koo barge ladɨ day. Cendi ku gumaj gɨ jaw dalawə gɨ chire gɨ lade nan̰ me, ");
INSERT INTO sor_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","barge gaba lyagɨra dɨdəgɨ lə di gɨ chire gɨ lade nan̰ me, gɨ ku mani woni hura dɨdəgɨ lə kaw gɨ chire gɨ lade nan̰ me, galsõ day kaw gɨ chire gɨ lade me ca. ");
INSERT INTO sor_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Gɨ kugɨ mani woni maa wamdagɨ lə sɨrandɨgɨ́ gɨ chire gɨ lade nan̰ me, chire gɨ bor ngɨr ngɨr me, gɨ kwamge me, gɨ wusɨ bəliyə me ca. Giyə day gɨ cendi àlaw di, i giyə gɨnə woni ꞌwacn̰a sɨranda barge ladɨ day, ya Aba dama gɨ dɨrəw bɨr̰ɨn̰ ba a ɨrməw gɨ Moyis de. ");
INSERT INTO sor_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Gɨ ɗangr̰ɨ mani gɨ jindar sɨdɨ dɨ wed me, jangɨ mani lə sɨdəgɨ lə ba da: Aba dama gɨ dɨrəw bɨr̰ɨn̰ biyən chɨ́n jiga. I gun gaba ꞌwacn̰a janga sumi jindar sɨdə ladɨ me jangɨ an̰ju. ");
INSERT INTO sor_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Gɨ hurə mani nə ta di magɨ gɨ sade nə bor ngɨr ngɨr mana gɨ barge gɨ woni bwasa Mãr̰ĩ geche day legɨrɨw dɨwə bɨw gɨ jin̰jɨwə dɨwə, ya Aba dama gɨ dɨrəw bɨr̰ɨn̰ ba a ɨrməw gɨ Moyis de. ");
INSERT INTO sor_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Ta di me, i giyə gaba ɗangr̰a kundi gɨ Mãr̰ĩ ha dama lə gɨ i kundi gaba ɓamara gɨ Mãr̰ĩ di ꞌyan̰a duwa. Nare nə Israyel àla mani nə Aba dama gɨ dɨrəw bɨr̰ɨn̰ ɨrməw Moyis di yande dige dige. ");
INSERT INTO sor_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Gɨ ꞌwoo kundi gɨ Mãr̰ĩ ha dama lə gɨ mani duwa pad di hára ꞌyàw Moyis. Kundi di mani duwa nə jiga jiga pad di me i ta: Kundi di sɨw duwa me, mani duwa nə bɨdəgɨ kongdɨ me, habde duwa woni jwagda dɨrəgɨ daa tɨba tɨba me, woni dagɨla kwandagɨ nə dɨrəgɨ daa tɨba tɨba di sɨdəgɨ lə yɨbəgɨ nɨm daa me, habde woni hurba dɨrəgɨ daa tɨba tɨba dara maa gɨ barge gaba maa kundi bɨwə me gaba saba kundi dalaw dodə korgɨn̰ sɨr me, gɨdɨragɨ woni yɨbəgɨ dodə wàya me, ");
INSERT INTO sor_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","gare gɨ kulajɨ gɨnə gəgɨr̰ɨn̰je day gɨ gɨ borɨwe gaba dàra kundi dɨwə me, gare gɨ kulajɨ gɨ ɗang gɨ lade nan̰ gaba dàra kundi dɨwə me, barge gaba saba kundi dalaw dodə korgɨn̰ sɨr me, ");
INSERT INTO sor_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","sandug dɨ idɨ gama kur̰a dɨ idɨmɨlan dɨnə Mãr̰ĩ day gɨ nare nə Israyel me, habde dɨra woni hurba dugdɨdɨ lə ugdədɨ nɨm me, bɨdɨ gaba ɗyasadɨ nɨm daa me, ");
INSERT INTO sor_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","tabɨl dɨnə Mãr̰ĩ me, mani pad woni chɨ́gdə dɨdə me, mapa gaba chɨ́gdəw Mãr̰ĩ me, ");
INSERT INTO sor_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","mani nə gangr̰agɨ wurgɨsubu nə gɨ ɗangr̰ɨgɨ gɨ jindar sɨdɨ dɨ wed dara chɨ́gdə gɨ lamba lə diiyə me, lamba dɨ gɨ chɨ́gdɨdɨ kɨrdɨ me, mani woni àla gɨ giyə gɨnə lamba dɨra di me, swani gɨnə lamba dɨra me, ");
INSERT INTO sor_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","mana gaba gwasa gɨ gɨ ɗangr̰ɨw gɨ jindar me, swani gɨnə Mãr̰ĩ duwa gaba tidɨrə diiyə me, mani woni gwasa me, barge gaba maa kundi bɨwə me, ");
INSERT INTO sor_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","mana gaba bwasa Mãr̰ĩ gɨ gɨ ɗangr̰ɨw gɨ biri gɨ bor ngɨr ngɨr me, biri duwa gɨ bor ngɨr ngɨr gɨ dagɨlal jaw sɨwə sɨwə me, habde duwa woni hurba dugdɨwə ugdəw hára nɨm me, mani duwa pad woni àla gɨ giyə me, mani nə ɓɨle woni bwaa nimi me gɨdɨragɨ me, ");
INSERT INTO sor_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","barge gaba jáa gɨ kundi daa me, habde woni hurba jwagdagɨ dɨrəgɨ daa tɨba tɨba me, gɨdɨragɨ me, barge gaba maa ciri dɨ gɨ ajɨdɨ daa di bɨdə me, sade woni maa habde nə jogdər dɨrəgɨ daa tɨba tɨba me, biri gaba ɓabɨr̰a dodə dara magda gɨ ciri di me, mani pad woni àla gɨ giyə kundi gɨnə Mãr̰ĩ gɨ i kundi gaba ɓamara gɨ Mãr̰ĩ di dalawə me, ");
INSERT INTO sor_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","barge gaba hura àla gɨ giyə mana gɨ kundi gɨnə Mãr̰ĩ duwa lə me, barge gaba sumi gɨ wun mɨnaw jiga gɨnə woni bwasa Mãr̰ĩ geche day gɨ Arõ duwa me, barge gɨnə dɨndaw day gaba hura àla gɨ giyə gaba bwasa Mãr̰ĩ di me ca. ");
INSERT INTO sor_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Giyə gɨ pad ta di, nare nə Israyel àlàw ya Aba dama gɨ dɨrəw bɨr̰ɨn̰ ba a ɨrməw Moyis di de dige dige. ");
INSERT INTO sor_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Me Moyis yər giyə gɨ nare nə Israyel àlàw di wun ya Aba dama gɨ dɨrəw bɨr̰ɨn̰ ba a ɨrməw nɨm ta de dige dige mwom da, an̰ji piy bɨw nare di dɨdəgɨ lə. ");
INSERT INTO sor_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw Moyis ba da: ");
INSERT INTO sor_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","«Duru gɨ mɨn wála duwa gɨ mɨnnə da, waygɨ mwar̰ə  gɨ ɓabɨr̰ɨna kundi gɨ nə ha dama lə gɨ i kundi gaba ɓamara gandɨn lə di daa. ");
INSERT INTO sor_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Gɨ unə sandug ni dɨ idɨ gama kur̰a dɨ idɨ mɨlan ɨnda di chɨ́nə budɨnə barge gɨ jər kundi ni dalawə dara sabaw nɨm dodə korgɨn̰ sɨr di tarɨwə. ");
INSERT INTO sor_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Gɨ unə tabɨl ni di hane nɨm chɨ́nədɨ me, gɨ layna mapa ni di hane nɨm chɨ́gdɨnəw kɨrnəw lə dɨdə me. Gɨ unə mani nə gangr̰agɨ wurgɨsubu woni chɨ́gdə gɨ lamba lə diiyə di hane chɨ́gdɨnə gɨ lamba lə diiyə me, gɨ kɨrnə dùwa lə. ");
INSERT INTO sor_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Gɨ unə mana gaba gwasa gɨ gɨ ɗangr̰ɨw gɨ jindar di hane chɨ́nə sandug ni di dɨrədɨ lə. Mwom da, gɨ mana barge kundi ni di bɨwə. ");
INSERT INTO sor_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Gɨ unə mana gaba ulə mani nə paga dara bwasan nɨm di chɨ́nə kundi ni gaba dama gɨ i kundi gaba ɓamara gandɨn di bɨwə. ");
INSERT INTO sor_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Gɨ chɨ́nə mani nə ɓɨle woni bwaa nimi di mana gɨ kundi gaba ɓamara gandɨn di bulə day gɨ mana gaba bwasan lə di me, gɨ bwana nimi lə. ");
INSERT INTO sor_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Gɨ ajɨna ciri kundi ni di dɨwə liwnəw daa me, gɨ mana barge mana gɨ ciri di bɨdə me ca. ");
INSERT INTO sor_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Ɨjɨm gɨ Moyis di,  mə ha ꞌwoo swani ni gaba tidɨrə diiyə di chìgdəw kundi gɨ nə ha dama lə di sɨwə me mani duwa pad woni àla giyə di sɨdəgɨ lə me ca. Ta di me mə ha biyə kundi di me, mani duwa nə pad di me kalagɨ wunə mɨ́ndagɨ jiga, mwom da, kundi di ha cwara gɨdə wunə mɨnaw dara àla gɨ giyə ni. ");
INSERT INTO sor_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Mə ha tidɨrəw mana gaba ulə mani nə paga àlán gɨ sarga di swani sɨwə me, mani duwa pad woni àla gɨ giyə di sɨdəgɨ lə me ca. Ta di me mə ha biyə mana gaba bwasa me, mani duwa nə pad di me kalagɨ wunə mɨ́ndagɨ jiga, mwom da, cendi ha ꞌya i ni ɨndi mɨra, anə ha biyəgɨ kalagɨ gɨ dɨrəgɨ jiga dara àlán gɨ giyə ni. ");
INSERT INTO sor_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Mə ha tidɨrəgɨ mani nə ɓɨle woni bwaa nimi di swani sɨdəgɨ lə me, gɨdɨragɨ lə me. Ta di me mə ha biyə mani nə ɓɨle woni bwaa nimi di kalagɨ wunə mɨ́ndagɨ jiga. ");
INSERT INTO sor_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Mə ha wala Arõ day gɨ nə dɨndaw hára gandagɨ kundi gaba ɓamara gandɨn ɨndi gɨ Mãr̰ĩ di bɨwə, kalgɨ gɨ wiyna sɨdəgɨ bam do. ");
INSERT INTO sor_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Ɨr̰ɨ mə ha huraw Arõ barge duwa gaba sumi gɨ wun mɨnaw jiga di sɨwə me, mə ha tidɨrəw swani dɨwə biyəw kalaw gɨ dɨrəw jiga dara kalɨw a àlna giyə duwa gaba bwasan di. ");
INSERT INTO sor_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Mə ha wala Arõ dɨndaw di hára nɨm huragɨ barge day di sɨdəgɨ lə me ca. ");
INSERT INTO sor_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Mə ha tidɨrəgɨ swani dɨdəgɨ lə ya ba mə ha tidɨrəw gɨ abɨragɨ dɨwə ta de. I yande do me, gɨ swaa day bá bá da, cendi ha àla nɨm gɨ giyə gaba bwasan di gɨ dɨrɨn̰ bɨr̰ɨn̰.» ");
INSERT INTO sor_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Moyis àl mani nə Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayaw gandagɨ di yande dige dige. ");
INSERT INTO sor_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","I wála gɨ mɨn gɨnə duru gɨ mɨn gɨnə aliya gɨ sɨrrə gɨ nare nə Israyel dɨmə nɨm bam sɨn̰a dɨ Ejibtɨ lə di me, gɨ ɓabɨr̰ɨ nɨm gɨ kundi gɨ Mãr̰ĩ ha dama lə di daa. ");
INSERT INTO sor_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Moyis waygɨ mwar̰ə me, cendi ɓabɨr̰ɨ kundi di daa. Cendi ɓabɨr̰ɨ gɨdaw me, hurbə habde woni jwagda dɨrəgɨ daa tɨba tɨba me, bo habde woni dagɨla kwandagɨ nə dɨrəgɨ daa tɨba tɨba sɨdəgɨ lə yɨbəgɨ nɨm daa me, jogdɨ habde woni maa barge gaba jàa kundi dalaw dara sabaw korgɨn̰ sɨr di daa me, woni maa barge gɨ kundi bɨwə di daa me ca. ");
INSERT INTO sor_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Ɨr̰ɨ cendi dàr barge me, gare me, kundi di dɨwə, ya Aba dama gɨ dɨrəw bɨr̰ɨn̰ ba a ɨrməw gɨ Moyis de. ");
INSERT INTO sor_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Ɨr̰ɨ Moyis lay kur̰a dɨ ɓɨdɨr̰a ɓɨdɨr̰a dɨ gɨ jangɨ bii gɨ ꞌwoo gɨnə Mãr̰ĩ gaba yəə mɨlan gɨ nare nə Israyel di lə sɨdə di bodɨ mana gɨ sandug dɨnə Mãr̰ĩ duwa di dwar̰ɨ lə me, gɨ lay habde woni hurba dugdɨdɨ lə di hurbədɨ daa me, gɨ ɗesɨ sandug di bɨdɨ daa. ");
INSERT INTO sor_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Ɨr̰ɨ gɨ u sandug di chɨ́dɨ kundi di dalawə me, gɨ jə̀ barge gaba saba kundi dalaw dodə korgɨn̰ sɨr di dara lɨgə gɨ sandug di, ya Aba dama gɨ dɨrəw bɨr̰ɨn̰ ba a ɨrməw gɨ Moyis de. ");
INSERT INTO sor_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Gɨ chɨ́ tabɨl dɨ idɨ chɨ́gdəw gɨ Mãr̰ĩ mapa lə di mana gɨ kundi gaba ɓamara gɨ Mãr̰ĩ di tulɨw dɨ ɨsay gɨ jeleyə, barge di dɨrəwə. ");
INSERT INTO sor_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Gɨ chɨ́gdɨ mapa gɨnə Mãr̰ĩ duwa kɨrɨw tabɨl di dɨdə Aba dama gɨ dɨrəw bɨr̰ɨn̰ di dɨrəwə, ya an̰ji ba a ɨrməw gɨ Moyis de. ");
INSERT INTO sor_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Gɨ chɨ́ mani nə gangr̰agɨ wurgɨsubu woni chɨ́gdə gɨ lamba lə diiyə mana gɨ kundi di tulɨw dɨ ɨsay gɨ abeyə, tabɨl di dɨrədɨ lə ɗən̰ me, ");
INSERT INTO sor_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","gɨ kɨr dùwa lamba lə Aba dama gɨ dɨrəw bɨr̰ɨn̰ di dɨrəwə, ya an̰ji ba a ɨrməw gɨ Moyis de. ");
INSERT INTO sor_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Gɨ chɨ́ mana gaba gwasa gɨ gɨ ɗangr̰ɨw gɨ jindar di mana gɨ kundi di dalawə barge gɨ gɨ jə̀w dara saba gɨ kundi dalaw dodə korgɨn̰ sɨr di dɨrəwə. ");
INSERT INTO sor_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Gɨ ju mani woni gwasa nənə Mãr̰ĩ duwa di bo mana gaba gwasa di dɨwə gosɨ nɨm, ya Aba dama gɨ dɨrəw bɨr̰ɨn̰ ba a ɨrməw gɨ Moyis de. ");
INSERT INTO sor_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","29","Ɨr̰ɨ gɨ ma barge mana gɨ kundi gaba ɓamara gɨ Mãr̰ĩ gɨ i kundi gɨ Mãr̰ĩ ha dama lə di bɨwə. Gɨ chɨ́ mana gaba ulə mani nə paga woni àláw gɨ Mãr̰ĩ sarga mana gɨ kundi di bɨwə, mwom da, gɨ ꞌyə mani nə paga ulgɨ bosɨ gɨ Mãr̰ĩ me, gɨ jo burə gɨnə swagə day hára ꞌyàw sarga me ca, ya Aba dama gɨ dɨrəw bɨr̰ɨn̰ ba a ɨrməw gɨ Moyis de. ");
INSERT INTO sor_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Gɨ chɨ́ mani woni bwaa nimi lə di mana gɨ kundi di bulə day gɨ mana gaba bwasa Mãr̰ĩyə me, gɨ bo nimi woni saba sii di lə, ");
INSERT INTO sor_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","dara kal Moyis me, Arõ day gɨ nə dɨndaw me, ba sabɨna gɨ sɨdəgɨ. ");
INSERT INTO sor_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Mana gɨ cendi gandɨna dara hára kundi dalawə labaa mana gaba bwasa Mãr̰ĩyə bá bá da, cendi sabɨ i sɨdəgɨ bam do, ya Aba dama gɨ dɨrəw bɨr̰ɨn̰ ba a ɨrməw gɨ Moyis de. ");
INSERT INTO sor_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Targɨn̰ ꞌyan̰a lə da, gɨ ajɨ ciri liw gɨ kundi di me, mana gaba bwasa Mãr̰ĩ di me daa, ɨr̰ɨ gɨ ma barge mana gɨ ciri di bɨdə. I yande me Moyis àl gɨ giyə di ꞌyen̰ nɨm bam pad di. ");
INSERT INTO sor_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Ɨr̰ɨ sawe di mu kundi gaba ɓamara gɨ Mãr̰ĩ di daa gwam me, ꞌywagda gɨnə Aba dama gɨ dɨrəw bɨr̰ɨn̰ duwa kaw ꞌwon kundi duwa di dalaw daa me ca. ");
INSERT INTO sor_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Me Moyis nem ganda hára kundi di dalawə bədə, dara sawe di muw daa me, ꞌywagda gɨnə Aba dama gɨ dɨrəw bɨr̰ɨn̰ duwa kaw ꞌwon dalaw daa me ca. ");
INSERT INTO sor_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Mana gɨ sawe di cɨmnə daa kundi di dɨwə bá bá do me, nare nə Israyel cɨm ha pii pii sɨn̰. ");
INSERT INTO sor_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Me sawe di cɨmnə daa kundi di dɨwə bədə da, cendi ɓɨr̰ɨn̰ ha bədə me ca. Cendi ɓedɨ wála gɨ sawe di dara cɨmə daa kundi di dɨwə bá do me, cendi bɨr̰ɨn̰ bor bɨrmə lə ha pii sɨn̰. ");
INSERT INTO sor_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Cɨmdə day gɨ daa daa lə di, gɨ dawa da, sawe gɨnə Aba dama gɨ dɨrəw bɨr̰ɨn̰ duwa mu kundi di daa gwam me, gɨ changa da, dùwa ácn̰ sawe di dalawə, nare nə Israyel di dɨrəgɨ lə pad, mana day gɨ cendi damdɨ lə di bá bá.");
INSERT INTO sor_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","Wála gɨ woni àla sariya lam gɨ dwãr̰ĩ mana gɨ sɨn̰a dɨ Israyel dɨdə da, badɨgara dɨ geche gɨra ɨndər. Mana gɨ ta lə da, abe mɨn gɨ ciri duwa Betɨlehem sɨn̰a dɨ Juda lə, sogɨ day gɨ dyaməw me, dɨndaw sɨr me ba gɨ ha dama mana gɨ sɨn̰a dɨ Mowab lə. ");
INSERT INTO sor_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","Abe gɨ ta di, gɨ ꞌwogɨw Elimelek, me dyaməw, gɨ ꞌwogɨdɨ Nomi, me dɨndaw nə abje nə sɨr di, gɨ mɨn gɨ ꞌwogɨw Malon me, gɨ ɗang, gɨ ꞌwogɨw Kilyon me ca. Nare nə ta di gɨndəgɨ i mage nənə Epɨrata gɨ ciri duwa i Betɨlehem sɨn̰a dɨ Juda lə. Mana gɨ cendi gɨra sɨn̰a dɨ Mowab lə da, cendi dam lə. ");
INSERT INTO sor_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Targɨn̰ ɗang da, Elimelek gɨnə Nomi tɨrədɨ di mar bam me, tandi wor dam wambɨ mɨnadɨ gɨ dɨndadɨ nə abje nə sɨr di. ");
INSERT INTO sor_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Dɨndadɨ nə sɨr di lay namde nə sɨn̰a dɨ Mowab lə, dɨ mɨn gɨ ꞌwogɨdɨ Orpa me, dɨ ɗang gɨ ꞌwogɨdɨ Rut me ca. Cendi dam mana gɨ ta lə di nem ya aliya mwaj de. ");
INSERT INTO sor_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Ɨr̰ɨ Malon me Kilyon me margɨ bam ca dayyə ca, me Nomi di wor dam mɨnadɨ dɨban dɨndadɨ nə sɨr di me, tɨrədɨ di me ca. ");
INSERT INTO sor_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Wála mɨn, Nomi doy dara Aba dama gɨ dɨrəw bɨr̰ɨn̰ ba àl ladni gɨ nare duwa nə sɨn̰a dɨra lə, ba ꞌyàgɨ́ mani nə wama me. Mana gɨ ta lə da, tandi sogɨ gɨ nugɨradɨ nə sɨr di mana gɨ Mowab ba gɨ cor ha sɨn̰a dɨra lə di bi. ");
INSERT INTO sor_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Cendi sogɨ mana gɨ sɨn̰a dɨ cendi dam lə di hargɨ mɨn gɨ nugɨradɨ nə sɨr di ba gɨ cor ha sɨn̰a dɨ Juda lə di. ");
INSERT INTO sor_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Mana gɨ cendi gɨr bɨrmə lə da, Nomi waygɨ nugɨradɨ ba da: «Cwarna hana ulay dannə ɗɨm, kal wi kaw cwarna hana kɨrə nə iw lə. Kal Aba dama gɨ dɨrəw bɨr̰ɨn̰ àlna gandang dusi dɨ lade ya ꞌyeni anə banə àlgɨ́ nɨm gɨ tɨrgang nə mar bam ta de me, ya anə banə àl nɨm gandɨn ɨndi de me ca. ");
INSERT INTO sor_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Kal wi kaw, Aba dama gɨ dɨrəw bɨr̰ɨn̰ ꞌyànáw abe me, ꞌywana ꞌywala mana gɨ ciri duwa dwar̰ɨ lə kɨrə nə tɨrəwə me ca.» Ɨr̰ɨ tandi yɨbɨ nugɨradɨ di sɨdə, me nugɨradɨ di sojɨ gura mar̰ɨjagɨ daa nan̰, ");
INSERT INTO sor_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","me cendi waydɨ da: «Bədə, nə haynin gandi mɨn sɨn̰a dɨnə war̰ay dayyə di bá!» ");
INSERT INTO sor_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Nomi cor waygɨ da: «Dɨndani ni woni, cwarna hana ulay dannə bi, anə ùr ba nə ha gandɨn ɗang àla na mo? Caga da, aliya ni gaba yàa dine nə abje nə ɗan̰ ha layang da, ilə ɗang mo? ");
INSERT INTO sor_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Nə amsang dɨndan ni woni, cwarna hana ulay dannə. Nə hal nan̰e, ꞌwoo ni gɨ abe ilə bədə ɗɨm. Dee nə ɨrmɨnə dusɨnnə ba nə nem changa dɨ laba lə dog ꞌya gɨ abe me yàa dine nə abje me kaw, ");
INSERT INTO sor_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","anə ha nyama ɓyadagɨ dara cendi ba jwarbɨna bá mo? Anə ha yəə sɨdəng gɨn̰ə laya abje nə ɗang bam mo? Àlna yande bədə. Dɨndan, ɨndi da, wamani ni ɗoy gɨ dan bam, Aba dama gɨ dɨrəw bɨr̰ɨn̰ yáa ɨsəw àsan wamani dɨ geche di i dɨnnə ɨndi.» ");
INSERT INTO sor_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Deme nugɨradɨ nə sɨr di nul gura gɨ mar̰ɨjagɨ daa nan̰ ɗang. Targɨn̰ ɗang da, Orpa di yɨ nuwadɨ di sɨdə ɨr̰ɨ cor ha nə war̰adɨ lə ɗɨm. Me Rut dɨra da, wor gandɨdɨ jang. ");
INSERT INTO sor_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Nomi waydɨ Rut da: «Yər, halay di cor yá ꞌywaa war̰adɨ me ꞌywaa mãr̰ĩ gɨnə war̰adɨ day me ca. Mɨndi kaw, cor ha gandɨdɨ me.» ");
INSERT INTO sor_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Ɨr̰ɨ Rut codɨ waydɨ da: «Kal ajɨmara gandɨn dara ba nə cwarna hana kalnay bam ɗi. Mana gɨ də hana lə da, ɨndi kaw, nə ha hára lə me, mana gɨ də damna lə da, ɨndi kaw, nə ha dama lə me ca. War̰ay da, ha ꞌya i war̰an ni me, Mãr̰ĩ diya kaw, ha ꞌya i Mãr̰ĩ ni me ca. ");
INSERT INTO sor_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Mana gɨ dɨ marna lə da, nə ha mara lə me, i mana gɨ ta lə di me gɨ ha mõn lə di me ca. Nə kalnay bam da, Aba dama gɨ dɨrəw bɨr̰ɨn̰ àsɨnán wamani gɨ geche dɨnnə, kal ina i made mɨn tenene me agdɨndɨ tandi.» ");
INSERT INTO sor_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Mana gɨ Nomi yər dara Rut ùr ba dɨ ha i gandɨdɨ bá da, tandi hoy ajɨmara gɨ gwale di. ");
INSERT INTO sor_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Cendi hargɨ ca dayyə dɨmgɨ Betɨlehem bá. Mana gɨ cendi gɨr kɨrə Betɨlehem da, nare nə ciri dɨdə pad yɨbdɨ dɨdəgɨ me, namde ùrbɨ sɨdəgɨ ba da: «Ɓag deme dɨ ta di i Nomi di mo?» ");
INSERT INTO sor_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Me Nomi cogɨ waygɨ da: «ꞌWagɨnan sumi gɨ Nomi gɨ gɨndɨw i sii ꞌywala di bədə ɗɨm, me ꞌwagɨnan sumɨn Mara gɨ gɨndɨw i wamani ɗɨm. Dara Mãr̰ĩ gaba dwana di àsɨ́n wamani gɨ geche dɨnnə. ");
INSERT INTO sor_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Mana gɨ nə so ka da, nə ha i gɨ mani ni nan̰ ɨsənnə, me Aba dama gɨ dɨrəw bɨr̰ɨn̰ àlan nə cwara ɨsən pəgɨn̰. ꞌWagɨnan Nomi bədə ɗɨm, dara Aba dama gɨ dɨrəw bɨr̰ɨn̰ di àsɨ́n wamani dɨnnə, i sɨdɨ, Mãr̰ĩ gaba dwana con idɨ n̰agɨni ɗɨm.» ");
INSERT INTO sor_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","I yande me Nomi swaa kala sɨn̰a dɨ Mowab bam ba dɨ cor ha sɨn̰a dɨra lə day gɨ nuwadɨ dɨ Rut dɨ gɨndɨdɨ i Mowab di me ca. Wála gɨ cendi gɨra Betɨlehem da, nare ilə gɨlə swagə nə gɨ ꞌwogɨgɨ «orjɨ» lə ɗɨm. ");
INSERT INTO sor_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Nomi tɨrədɨ gɨ Elimelek wiləw mɨn ilə. I abe gaba ꞌywaa mani, gɨ nare àlɨw horɨmbə nan̰, gɨ ꞌwogɨw Boos. ");
INSERT INTO sor_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Wála mɨn, Rut dɨ Mowab di waydɨ nuwadɨ dɨ Nomi da: «Kalɨn bɨrmə nə ha bam yiga lə surama swagə mana gɨ yiga gɨnə gun gɨ àlna gandɨn ladniyə.» Nomi codɨ waydɨ da: «Ha ɓáy, durmən.» ");
INSERT INTO sor_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Rut so ha bam yiga lə surama swagə woni gɨləgɨ taragɨ lə. Yiga gɨ tandi surəm swagə lə ta di cor i gɨnə abe gɨ gɨ ꞌwogɨw Boos gɨnə Elimelek wiləw di duwa. ");
INSERT INTO sor_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Ɓam da, Boos swaa Betɨlehem yala bam yiga lə di me ca. An̰ji waygɨ woni gɨlə swagə di ba da: «Kal Aba dama gɨ dɨrəw bɨr̰ɨn̰ damna gandang.» Ɨr̰ɨ woni gɨlə swagə di cow wayɨw da: «Kal Aba dama gɨ dɨrəw bɨr̰ɨn̰ piynə bɨw dɨmmə me ca.» ");
INSERT INTO sor_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Boos ùr geche gɨnə woni gɨlə swagə day di ba da: «Dwe dɨ deme dɨ ta di i wi durməw mo?» ");
INSERT INTO sor_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Abe di cow wayɨw da: «I dwe dɨ Mowab dɨ swaa gɨ Nomi mana gɨ Mowab yala gandɨdɨ di. ");
INSERT INTO sor_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Tandi gɨra ùrnin ba nə kalnadɨnin ba dɨ surəm me ba dɨ lay swagə nə agdɨ bor dodə woni magdagɨ daa taragɨ lə ta di. Tandi yala i gɨ jomni bá, me caga kaw, tandi ɗɨbɨ i daa, dam dodə dunə bo gwayni ɓani yande mɨra.» ");
INSERT INTO sor_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Ɨr̰ɨ Boos waydɨ Rut da: «Doy gwale ni, durmən: Ha surama mana gɨ yiga gɨ ɗangə bədə, ɗɨbɨ lə ka jang surəm mana gɨ namde woni àlán giyə di taragɨ lə. ");
INSERT INTO sor_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Àsɨ angal diya ladɨ le, yər yiga di mana duwa gɨ abje gɨl swagə lə di, pam namde woni layagɨ daa di taragɨ. Nə u bɨn ꞌyàgɨ́ moso woni àlán giyə di ba jibɨnay bədə. Machè àlnày da, ha chàa nimi mana gɨ pɨr̰ɨmdi nə moso ni udɨbɨ nimi bo lə ta di.» ");
INSERT INTO sor_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Mana gɨ Boos way gwale bam da, Rut ɨbər dodə sɨn̰a lə me wayɨw da: «Ɨndi dɨ nə i deme dɨ mɨji di, dana me mə àl gandɨn ladni yande pad me, mani ni nə àla ꞌyolɨm yande me mo?» ");
INSERT INTO sor_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Boos codɨ waydɨ da: «Mani diya nə də àlgɨ̀ gɨ nuway mana gɨ tɨrəy mar nɨm bam bá da, nare wayɨn gwale day ladɨ. Me nə ꞌwocn̰ dara də swaa kala abay bam me iy bam me sɨn̰a diya dɨ yàa bam me, də yala dam mana gɨ nare nə də ꞌwocn̰ɨgɨ dii mɨn pii bədə dwar̰agɨ lə. ");
INSERT INTO sor_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Kal Aba dama gɨ dɨrəw bɨr̰ɨn̰ ꞌywagɨnay gwayni diya dara mani nə pad nə də àlgɨ̀ ta di. Əw, kal Aba dama gɨ dɨrəw bɨr̰ɨn̰ gɨ i Mãr̰ĩ gɨnə nare nə Israyel day gɨ də yala dam dun duwa lə di ꞌywagɨnay gwayni diya gɨ bɨrmə duwa.» ");
INSERT INTO sor_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Rut cow wayɨw da: «Aba ciri ni, ɨjɨm da, sɨm ꞌywalam dɨnnə me mə àla gandɨn dusi dɨ lade da, mə hurən abnani dusɨnnə. Mə wayɨn gwale gɨ ɨndər dusɨnnə ɨndi dɨ nə i dwe dɨma di. Ɓag da, namde woni àlám giyə ta di kaw, ɨndi nə bor gandagɨ bədə.» ");
INSERT INTO sor_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Dawa dɨ idɨ wama mani nə wama di nem mwom da, Boos waydɨ Rut da: «Hare də wamang mani. U mapa tulɨw su mana gɨ bɨ̀ra lə.» Ɨr̰ɨ Rut hára gɨra dam dodə woni gɨlə swagə di tuləgɨ lə me, Boos u swagə dɨrəgɨ nə gɨ wágɨ di ꞌyàdɨ tandi wom cherni dɨra lə me, gam gɨndəgɨ nə wor di daa. ");
INSERT INTO sor_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Ɨr̰ɨ tandi cor ha surama lə di bi me, Boos u bɨw waygɨ woni gɨlə swagə di ba da: «Kalnadɨ dɨ surəm. Ina i mana gɨ swagə nə gɨ magdɨgɨ jogdɨgɨ daa ta di dwar̰agɨ lə kaw, àlnadɨ́ gwale bədə. ");
INSERT INTO sor_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Swagə nə anə dajɨgɨ daa daa ta di kaw, susɨgɨnə nə yab dodə kaldɨ dɨ lay. Gun àlnadɨ́ gwale bədə pa pa.» ");
INSERT INTO sor_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Rut surəm mana gɨ yiga gɨnə Boos lə bɨraa turgɨ me, tandi gobɨ surama dɨra di bam me bo orjɨ dɨrəw nem ya koro mwaj bii jii de. ");
INSERT INTO sor_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Tandi ꞌwoo swagə di hára nɨm ulay, gɨldɨ nuwadɨ mani nə tandi ꞌywagɨ surama lə di. Wama dɨra gɨ tandi wama ɨbə me gɨndɨw wara di kaw, tandi u ꞌyàdɨ́ me ca. ");
INSERT INTO sor_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Nomi ùrdɨ da: «Labaa da, də ꞌwò surama i yiga gɨnə wiyə mo? Də àla giyə i we mo? Kal Mãr̰ĩ piynə bɨw mana gɨ gun gaba àla gandi ladni ta di dɨwə.» Rut kɨbɨdɨ nuwadɨ mana dɨra gɨ ba dɨ àla giyə lə labaa di ba da: «Nə àla giyə i mana gɨ yiga gɨnə abe gɨ gɨ ꞌwogɨw Boos lə.» ");
INSERT INTO sor_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Nomi waydɨ nuwadɨ di ba da: «Kal Aba dama gɨ dɨrəw bɨr̰ɨn̰ gɨ gam dusi duwa dɨ lade gɨ nendɨ nə də warang bɨ̀ra me nare nə mar bam me di, piynə bɨw dɨwə.» Me tandi àsɨdɨ́ lə diiyə ɗang ba da: «Boos di i wilandɨ ɨnda gɨ ib yande me, i woni yara dɨdəndɨ di gun day gɨ mɨn me ca.» ");
INSERT INTO sor_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Rut deme dɨ Mowab waydɨ ɗang: «An̰ji wayɨn ba nə suramana le woni àláw giyə di taragɨ lə jang bɨraa swagə di ꞌyan̰a dayyə bá.» ");
INSERT INTO sor_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Yande da, Nomi waydɨ Rut da: «Ladɨ, durmən ni dɨdɨ, ha àla giyə gɨ namde duwa woni àláw giyə ta di lə jang. Də hana yiga gɨnə gun gɨ ɗangə da, ga də ha ꞌywaa wamani som.» ");
INSERT INTO sor_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","I yande me Rut dam gɨ namde woni àla giyə nənə Boos duwa mɨn, tandi surəm lə bɨraa swagə nə orjɨ di ꞌyan̰a dayyə me, nə geme di ꞌyan̰a dayyə bá me. Tandi dam lə gɨ nuwadɨ di jang. ");
INSERT INTO sor_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Wála mɨn, Nomi waydɨ nuwadɨ dɨ Rut da: «Durmən, i giyə ni gaba kan̰jay mana gɨ dama gɨ lade gɨ də ha dama gɨ sii ꞌywala. ");
INSERT INTO sor_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Ya ba dɨ ꞌwocn̰ nɨm de, Boos gɨ də àl giyə mana gɨ yiga duwa lə gɨ namde woni àláw giyə mɨn ta di, an̰ji i wilandɨ. Laba gɨ changa da, an̰ji ha huyə swagə duwa nə orjɨ di le bam mana gaba gwaba swagə lə. ");
INSERT INTO sor_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Wiy sɨy bam me ɗa swani gɨ biyey sɨyyə me hurə barge diya gɨ lade sɨyyə me, so ha mana gɨ an̰ji gobɨ gɨ swagə duwa lə ta di. Ɗɨm da, jang gɨ an̰ji wor wama mani me chàa me ꞌyan̰a sɨn̰ da, kalɨw a ꞌwacn̰ana dara ba dɨ yala lə bədə sɨn̰. ");
INSERT INTO sor_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Mana gɨ an̰ji dara ꞌya dodə mwom da, yər mana duwa gɨ ꞌya di ladɨ le. Chidey sɨwə ib me, lay borgə duwa di daa me, i dodə mana gɨ gɨdawə. Targɨn̰ ɗang da, i an̰ji me ha wayay mani nə də ha àlagɨ̀ di.» ");
INSERT INTO sor_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Rut codɨ waydɨ da: «Mani nə də wayɨn ta di pad, nə ha hára àlagɨ̀ le.» ");
INSERT INTO sor_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Yande mwom da, tandi so ha mana gaba gwaba swagə gɨnə Boos lə di me, gɨra àl mani nə nuwadɨ wayadɨ gandagɨ ta di dige dige. ");
INSERT INTO sor_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Boos wom me chə̀ me, sɨw ꞌyolɨw me, ɨr̰ɨ so ha ꞌya mana gɨ swagə duwa nə orjɨ dɨrəgɨ nə gɨ ꞌyargɨ daa di tuləgɨ lə. Rut n̰ilanga gɨra lay borgə duwa di bɨdɨ daa me i dodə mana gɨ gɨdawə. ");
INSERT INTO sor_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Gɨ changa dwar̰ɨ mwom da, Boos par lán̰a me, dudɨw a daa me, mana gɨ an̰ji u dɨw daa da, yər deme mɨn ilə dodə gɨdawə. ");
INSERT INTO sor_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Ɨr̰ɨ an̰ji ùrdɨ da: «I wi mo?» Tandi cow wayɨw da: «I ɨndi dwe dɨma dɨ Rut di. Bon barge dɨma bɨw dɨ nə budɨn nɨm le, dara mə i aba yara dɨn ɨjɨm.» ");
INSERT INTO sor_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Boos waydɨ da: «Kal Aba dama gɨ dɨrəw bɨr̰ɨn̰ piynə bɨw dɨyyə durmən, mani nə də àlgɨ̀ ka nə də ùr ba nə yarna diy le di, gɨl dara dusɨy ba i mɨn nuway day gɨ nə war̰adɨ dɨdəgɨ lə ɗoy mani nə də àlgɨ̀ pii di bam. Də kan̰ja yəə gɨ mɨlan gɨ moso bədə. Woni ꞌywaa mani labaa nə bugɨr kaw, də kan̰jagɨ bədə. ");
INSERT INTO sor_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Caga da, durmən, kal lán̰a ɗi. Mani nə də waynagɨ da, nə ha àláyye dara nare pad yəri dara ba dɨ i deme sɨdɨ dɨ idɨ horɨmbə. ");
INSERT INTO sor_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","I sɨdɨ ꞌyang, nə i woni yara dɨdəng gun day gɨ mɨn, ɗɨm da, tɨrəy wiləw gɨ ib ɗoyɨn bam ilə. ");
INSERT INTO sor_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","I wal dodə ka me, sanga gɨ jomni me, də ha ɨnda yara, gun gɨ ta di gaa ùrnə ba a yarna diy an̰ju da, a yarna. An̰ji ùrnə bədə da, nə u bɨn ꞌyày mana gɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ gɨ ilə bɨ̀ra dɨrəwə, nə ha yara diy di ɨndi. Caga da, i dodə jang bɨraa gɨ jomni do.» ");
INSERT INTO sor_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Rut i dodə Boos gɨdawə bɨraa jomni bá, me manapɨr dɨ gun yər jaw ꞌwocn̰ɨw bədə sɨn̰ da, tandi so daa. Dara Boos way kal nare ba ꞌwacn̰ana dara deme ba gɨra i tulɨwə mana gaba gwaba swagə lə ka bədə. Dara nare di gaa ba ha waya ba a i gandɨdɨ le ɗɨm mo. ");
INSERT INTO sor_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Boos waydɨ da: «Biyəy barge diya gɨ diya gɨ jaw dɨwə di me, yɨw ladɨ le.» Tandi yɨ barge dɨra di me, an̰ji ajɨbadɨ orjɨ di nan̰ bodɨ barge dɨra lə di. An̰ji yɨdɨ chidɨ daa dɨdə me, an̰ji cor ha ulay ciri dwar̰ɨ lə. ");
INSERT INTO sor_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Rut di cor ha ulay nə nuwadɨ lə me, nuwadɨ di ùrdɨ da: «Mani di àlala i man mo, durmən?» Me Rut kɨbɨdɨ nuwadɨ di mani nə Boos àla gandɨdɨ di daa pad. ");
INSERT INTO sor_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Tandi waydɨ ɗang ba da: «An̰ji ꞌyàn swagə nə ta di nan̰ me, wayɨn da: “Də cwarna hana ꞌywana nuway di ɨsəy pəgɨn̰ da, ladɨ bədə.”» ");
INSERT INTO sor_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Nomi waydɨ da: «Dam lə ka jang, durmən, bɨraa də ha yara gwale di gaa ha àlala i man mo. Abe gɨ ta di ɗangr̰ɨna gwale gɨ ta di laba dog bədə da, dusɨw ha ꞌya dodə bədə.» ");
INSERT INTO sor_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Boos so ha dama ciri bɨdə mana gɨ nare dayar ɗangr̰ɨ gɨ gwaleyə. Elimelek wiləw gɨ ibden̰ gɨ Boos waydɨ Rut gwale duwa di hára dɨmə, ɨr̰ɨ Boos yaraw me ꞌwagaw: «Ɨjɨm di, hare dam dodə.» Me abe di hára gɨra dam dodə. ");
INSERT INTO sor_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Boos ꞌwaga nare nə gechide nə ciri dɨdə mwaj ba hana damna gandagɨ me mwom da, cendi gɨra dam dodə me ca. ");
INSERT INTO sor_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Ɨr̰ɨ an̰ji wayɨw Elimelek wiləw di ba da: «Nomi dɨ swaa mana gɨ sɨn̰a dɨnə nare nə Mowab dayyə cwara yala ulay di, caga tandi ùr ba dɨ kɨl yiga gɨnə wilandɨ gɨ Elimelek duwa di bam. ");
INSERT INTO sor_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Ɨndi da, nə ùr ba nə àsɨ́m gwale gɨ ta di dusɨmmə me nə ɨrɨm ba nə wayɨm ba mə kɨlnə yiga di ɨjɨm caga ka mana gɨ nare nə gechide nə ciri dɨdə me nə ɗang nə dam ganandɨ me dɨrəgɨ lə ka. Caga da, mə ùrnə ba mə kɨlnə yiga gɨnə wiləm di le da, kɨl. Mə ùrnə bədə le, wayɨn daa kal nə ꞌwocn̰, dara gun gɨ ɗang gaba ɗwayam bam gɨ ha kɨlə yiga di pii dɨrəmmə da, ilə bədə, me tarɨmmə da, i ɨndi.» Abe di cow wayɨw da: «Nə ùr ba nə kɨl yiga di le.» ");
INSERT INTO sor_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Boos wayɨw da: «Mə kɨlnə yiga di gɨ Nomi mwom da, mə u aba mara dyaməw dɨ Rut dɨ Mowab deme le me ca, dara kal aba mara di sumɨw warna daa jang gɨ bɨrmə gɨ mage duwa day me cendi ba wamna dɨba duwa di me ca.» ");
INSERT INTO sor_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Abe di cow wayɨw da: «Ina yande da, nə nem kɨlə yiga di bədə, dara mani ni nə ꞌywaa ha cwara targɨn̰. Kɨl yiga gɨ dee nə ha kɨləw ɨndi di le ɨjɨm ma, dara ɨndi da, nə nem kɨləw bədə ɗɨm.» ");
INSERT INTO sor_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Tanga pii mana gɨ sɨn̰a dɨ Israyel lə da, nare kɨlnə mani labaa kɨlangɨna dɨba da, gun mɨn biy gɨbande duwa nə gɨdawə ꞌyàw jaw gɨl dara wi kaw, ba u bɨw ꞌyàw jaw le. Cendi àl yande dara gwale di ba ɗangr̰ar ꞌyen̰ye ɗɨm. ");
INSERT INTO sor_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","I dara yande me, mana gɨ abe di wayɨw Boos ba kɨlnə yiga dɨ mwom da, an̰ji biy gɨbande di ꞌyàw. ");
INSERT INTO sor_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Boos so waygɨ nare nə gechide nə ciri dɨdə di me, nə pad nə dam gandagɨ di me ba da: «ꞌYeni, anə yər gɨ dɨrəng dan me, anə doy gɨ sumdəng dan me, laba da, mani nə ꞌywaa pad nə tanga i Nomi tɨrədɨ gɨ Elimelek duwa me, dɨndadɨ nə Kilyon day gɨ Malon day me da, nə kɨlgɨ le pad ɗɨm. ");
INSERT INTO sor_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Me Rut dɨ Mowab dɨ wambɨ dɨnə Malon dyaməw di kaw, nə udɨ le me ca. Nə àl yande dara kal sumɨw me dɨba duwa me warna lə daa jang gɨ bɨrmə gɨnə mage duwa day me, dara sumɨw nɨmarna bam chamraw bɨdəgɨ lə bədə me nare nə ciri dɨdə bɨdəgɨ lə bədə me ca. ꞌYeni, anə yər gɨ dɨrəng dan me, anə doy gɨ sumdəng dan laba me ca.» ");
INSERT INTO sor_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Mwom da, nare nə gechide di me nare nə pad nə ilə ciri bɨdə ta di me cow wayɨw da: «Əw, nə yərnin gɨ dɨrənin nin me, nə doynin gɨ sumdənin me. Kal Aba dama gɨ dɨrəw bɨr̰ɨn̰ piynə bɨw mana gɨ deme dɨ ilə hára dama kɨrə dɨma lə ta di dɨdə me kaldɨ dɨ wunnə ya igɨrəndɨ nə Rachel day gɨ Leya nə yə̀ nare nə Israyel pad ta dɨ de. Ɨjɨm gɨ mə i mage gɨnə Epɨrata, kal mani dɨma nə ꞌywaa ꞌyarbarna nan̰ me, sumɨm nɨmnə mana gɨ ciri dɨ Betɨlehem lə pad me ca. ");
INSERT INTO sor_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Kal Aba dama gɨ dɨrəw bɨr̰ɨn̰ ꞌyànang dine nan̰ gɨ deme dɨ mə udɨ ta di ya dine nənə Peres gɨ Tamar yə̀w gandɨw tɨrədɨ gɨ Juda ta di de.» ");
INSERT INTO sor_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","I yande me Boos u Rut deme. An̰ji ɓamar gandɨdɨ mwom da, Aba dama gɨ dɨrəw bɨr̰ɨn̰ wudɨ gudi me, tandi yə̀ dwe gɨ abe. ");
INSERT INTO sor_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Namde nə Betɨlehem waydɨ Nomi da: «Kal də bow ɨnda Aba dama gɨ dɨrəw bɨr̰ɨn̰ jilay, dara laba da, an̰ji ꞌyày aba gamay. Kal mwày di sumɨw ꞌwagɨna mana gɨ sɨn̰a dɨ Israyel lə. ");
INSERT INTO sor_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","An̰ji ha cwara gɨdə gun gaba ꞌyày sii ꞌywala, me wála gɨ də halna da, an̰ji ha gamay an̰ju me ca. Dee də yàna dine nə abje wurgɨsubu kaw, nuway dɨ idɨ ùrəy me yə̀y gɨ mwày gɨ ta di, tandi ɗoy dine nə ta di bam.» ");
INSERT INTO sor_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Nomi u dwe di yɨw jorgɨdɨ lə, me gamɨw tandi. ");
INSERT INTO sor_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Namde woni ciri dɨra bɨdɨ di waygɨ nare pad ba: «Nomi ꞌyo mwàdɨ gɨ gɨdɨ ya gorndɨdɨ de!» Cendi ꞌwogɨw dwe di sumɨw Obed. Obed i Jese abəw, me Jese i dole gɨ geche gɨDabid abəw me ca. ");
INSERT INTO sor_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Yarna Peres mwàgɨraw sumdəgɨ: Peres i Esɨron abəw. ");
INSERT INTO sor_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Esɨron i Ram abəw. Ram i Aminadab abəw. ");
INSERT INTO sor_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Aminadab i Nachon abəw. Nachon i Salma abəw. ");
INSERT INTO sor_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Salma i Boos abəw. Boos i Obed abəw. ");
INSERT INTO sor_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Obed i Jese abəw. Jese i Dabid abəw.");
INSERT INTO sor_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Wála mɨn, Aba dama gɨ dɨrəw bɨr̰ɨn̰ ꞌwogɨ Jonas gɨnə Amitay gorndɨw me wayɨw ba da: ");
INSERT INTO sor_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","«So daa, ha mana gɨ Ninib dɨ i ciri dɨ geche, me soy berni waygɨ nare dɨra gwale ilə dɨdəgɨ lə dara àcn̰a day di swaa bɨraa yala ꞌyon daa.» ");
INSERT INTO sor_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Ɨr̰ɨ Jonas di so wà dara ba a ha mana gɨ ciri dɨ Tarsis lə, Aba dama gɨ dɨrəw bɨr̰ɨn̰ dɨrəwə bam hən̰. An̰ji gɨr mana gɨ ciri dɨ Japa dɨ i kuray gɨ geche bɨwə, me ꞌyo bɨrwa gɨ geche gɨ ilə hára mana gɨ Tarsis di. An̰ji ꞌyogɨ kili duwa me nagɨ gɨ nare di dara hára Tarsis, Aba dama gɨ dɨrəw bɨr̰ɨn̰ di bam hən̰. ");
INSERT INTO sor_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Me Aba dama gɨ dɨrəw bɨr̰ɨn̰ di ku gale gɨ geche mana gɨ kuray gɨ geche dalawə, me gale di biyara me nimi gɨgdɨ bɨrwa di me, bɨrwa di ùr ba a agdɨ bam. ");
INSERT INTO sor_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Nare woni ꞌwaya bɨrwa di, lán̰a àlgɨ. Wi kaw amsɨ dwama duwa, dwama duwa, me cendi lay hudɨr gɨ bɨrwa dalawə jərbɨ mana gɨ kurayyə dara bɨrwa ba hɨbalna daa. Mana gɨ ta lə da, Jonas chɨ́ duwa yá ꞌya nuni nə geche bɨrwa dalawə ilag. ");
INSERT INTO sor_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Mwom da, geche gɨ mana gɨ bɨrwa dalawə chidɨ sɨwə ib nuw daa me wayɨw ba da: «Dara na me mə i dɨma nuni mo? So daa, amsɨ dwama dɨma, ɨm gaa dwama gɨ ta di ha yara n̰agɨni ɨnda gaa də marang bədə mo?» ");
INSERT INTO sor_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Cendi wajɨbɨ gwale bulə dayyə ba da: «Hane, kunəndɨ dure də yarang nɨm sɨn̰, gaa i wi me hárandɨ gɨ wamani di mo.» Cendi ku dure di, me yɨ i Jonas. ");
INSERT INTO sor_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Mwom da, cendi wayɨw da: «Ɨjɨm gaba háranin gɨ wamani gɨ ta di, mə i wi mo? Giyə dɨma i na mo? Mə swaa i we mo? Ciri dɨma i we mo? Gɨndɨm i gun gɨ we mo?» ");
INSERT INTO sor_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","An̰ji cogɨ lə diiyə ba da: «Nə i Ebɨrə me nə lán̰ɨw i Aba dama gɨ dɨrəw bɨr̰ɨn̰ gɨ i Mãr̰ĩ gɨ daa gaba àsa kuray me, sɨn̰a me ca di.» ");
INSERT INTO sor_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","An̰ji waygɨ ba a wada yala budɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ dɨrəwə bam hən̰. I yande me nare nə ta di, lán̰a àlgɨ nan̰e me, wayɨw ba da: «Dara na me mə àl yande mo?» ");
INSERT INTO sor_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Gale di ilə gɨgdə nimi di lə com com mwom da, cendi ùrɨw ba da: «Nə àlnamnin man me gale di ha ɗɨbə nɨm dodə mo?» ");
INSERT INTO sor_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","An̰ji cogɨ lə diiyə ba da: «Unɨn álnan kuray di dalawə me, gale di ha ɗɨbə dodə. Nə ꞌwocn̰ com, i dara ɨndi me gale gɨ ta di biyara hára ꞌywang nɨm.» ");
INSERT INTO sor_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Me nare di ꞌwoy bɨrwa di dara hára nɨm daa wayniyə, me cendi nem bədə dara gale di ilə gɨgdə nimi di lə com com. ");
INSERT INTO sor_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Ɨr̰ɨ cendi soy ꞌwogɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ di me wayɨw ba da: «Aba dama gɨ dɨrəw bɨr̰ɨn̰, abe gɨ ta di àlnin mani mɨn bədə me, nə hanin álaw i kurayyə. I mani nə ɨjɨm Gaba dama gɨ dɨrəm bɨr̰ɨn̰ me mə ɨrmɨgɨ di. Yande da, nə amsɨmnin ɗe! Kal nə marnin bam dara dɨw duwa bədə. Me bare duwa warna dɨdəninnə bədə me ca.» ");
INSERT INTO sor_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Mwom da, cendi u Jonas álɨw kuray dalawə me, gale gɨgdə duwa gɨ nimi di ɗɨbɨ dodə. ");
INSERT INTO sor_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Nare nə ta di, lán̰ɨw Aba dama gɨ dɨrəw bɨr̰ɨn̰ di nan̰e. Cendi àlɨw sarga me, sɨrgɨ sɨdəgɨ ɗan̰ ba gɨ ha àlaw i mani sɨn̰. ");
INSERT INTO sor_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Mana gɨ cendi u Jonas àsɨw kurayyə mwom da, Aba dama gɨ dɨrəw bɨr̰ɨn̰ giyə dòche gɨ geche gɨra chə̀ Jonas bam ilag. Me Jonas i mana gɨ dòche nudəwə àl wála subu. ");
INSERT INTO sor_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","Jonas di i mana gɨ dòche nudəwə me amsɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ gɨ i Mãr̰ĩ duwa ba da: ");
INSERT INTO sor_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","«Mana gɨ wamani ni gɨ gecheyə da, nə soy ꞌwogɨm i ɨjɨm Gaba dama gɨ dɨrəm bɨr̰ɨn̰ di, me mə doy ꞌwaga ni di. Mana gɨ nə dam nare nə mare dúndɨrəgɨ dwar̰agɨ lə da, nə soy ꞌwogɨm dara ba mə wanan daa, me mə doy mar̰ɨjan, mə wannə. ");
INSERT INTO sor_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Pii, mə álɨn mana gɨ kuray gɨ geche don duwa lə, nimi wan dɨn bam, me ku day ilə gwaba lə dɨnnə. ");
INSERT INTO sor_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","I ta di me, nə way nɨm ba nə ꞌyorər i bam hən̰ mana gɨ sɨmmə di. Ɨr̰ɨ nə ùr ba nə cor yər kulu dɨma gɨ mə dam lə di. ");
INSERT INTO sor_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Nimi yɨn bər̰u niyə gɨləj, ɗungə day ɨmɨn hwaya bam. Bogɨr̰e legɨrər dɨnnə. ");
INSERT INTO sor_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Nə chɨ́ bɨraa yá ɓɨlə kur̰a gɨndɨdɨ dodə kuray don duwa lə bá. Munɨ bɨw ɗesər daa dɨnnə gɨ dɨrəm bɨr̰ɨn̰. Me mə ꞌwon daa bɨraa mana gɨ ɓengə, ɨjɨm gɨ Mãr̰ĩ ni Gaba dama gɨ dɨrəm bɨr̰ɨn̰ di. ");
INSERT INTO sor_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Mana gɨ dúndɨn gandɨ bam sɨnnə da, nə ɨrɨm ɨjɨm Gaba dama gɨ dɨrəm bɨr̰ɨn̰ dɨmmə. Amsa ni di yá bɨraa ɨndara sumɨmmə daa mana gɨ kulu dɨma gɨ mə dam lə di. ");
INSERT INTO sor_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Woni dama dara buraga gɨ domde nə i mani nə pəgɨn̰ da, cendi com ɨjɨm gɨ Mãr̰ĩ gɨ daa gɨ aba ùrəgɨ di taragɨ. ");
INSERT INTO sor_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Me ɨndi da, nə ha àlam sarga àlam gɨ dóche me, nə ha àlam mani nə nə u bɨn waygɨ di me. Ɓɨlə da, i ɨjɨm Gaba dama gɨ dɨrəm bɨr̰ɨn̰ dɨma.» ");
INSERT INTO sor_vpl VALUES ("JH2_11","033_2_11","JON","2","11","11","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw dòche me, dòche di hur̰ɨ Jonas àsɨw daa wayniyə. ");
INSERT INTO sor_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Ɨr̰ɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ ꞌwogɨ Jonas wayɨw gwale gaba dii sɨrrə ba da: ");
INSERT INTO sor_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","«So daa, ha mana gɨ Ninib dɨ i ciri dɨ geche me, soygɨ nare dɨra berni gwale gɨ nə wayɨm di.» ");
INSERT INTO sor_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Mwom da, Jonas so daa ha mana gɨ Ninib ya Aba dama gɨ dɨrəw bɨr̰ɨn̰ ba wayɨw nɨm de. Ninib da, i ciri dɨ geche nan̰e, ùr i wála subu hára lə gɨ gɨdam do me, mə ꞌyo bɨdɨ gɨ ꞌyen̰ye sɨn̰. ");
INSERT INTO sor_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Jonas diy gɨnɨn̰ wála gɨ mɨnnə ilə hára lə me sojɨ berni dɨrəw daa, way da: «Wor wála gɨnɨn̰ wodɨ da, Ninib ha myandara i bam.» ");
INSERT INTO sor_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Mwom da, nare nə Ninib kal dusɨrəgɨ Mãr̰ĩ dɨwə. Cendi way ba da: «Wamnandɨ mani bədə!» Me cendi hurbə barge gɨ n̰agɨni gɨ sogɨme sɨdəgɨ lə, so nare nə halbeyə bɨraa hára dine nə ꞌyəngə bá. ");
INSERT INTO sor_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Nõ di ɨndər dole gɨ geche gɨ Ninib sumɨwə. Me an̰ji so daa mana gɨ gage duwa gɨ dwãr̰ĩyə, n̰ir̰ɨ barge duwa gɨ dwãr̰ĩ di bam sɨwə me, hurbə barge gɨ n̰agɨni gɨ gɨ busɨw gɨ suwal sɨwə me dam nɨm mana gɨ dɨbɨrɨn̰yə. ");
INSERT INTO sor_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Ɨr̰ɨ, dole day gɨ nə nare duwa nə gechide u bɨdəgɨ way ba gɨ swaynagɨ nare nə Ninib berni ba da: «Kal nare me, mani nə paga nə labje me, bage me, wamna mani bədə me, wamna chími bədə me chàna nimi bədə me ca. ");
INSERT INTO sor_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Kal nare hurbɨna barge gɨ n̰agɨni sɨdəgɨ lə me, magdɨnagɨ mani nə paga sɨdəgɨ lə me, bwanaw Mãr̰ĩ gura nan̰ me. Wi kaw kalna mani duwa nə àcn̰e nə àlgɨ di bam me, gɨlə gɨ gɨlgɨ kwandaw dɨrəgɨ di bam me ca. ");
INSERT INTO sor_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Də ꞌwacn̰ang bədə, gaa Mãr̰ĩ ha cwaa ɨrmə duwa me, ha àla ganandɨ dusi dɨ lade ɗang, dara ba də marnang nɨm bədə mo?» ");
INSERT INTO sor_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Mãr̰ĩ yər dara nare nə Ninib kal mani day nə àcn̰e di bam da, an̰ji co ɨrmə duwa me, wamani gɨ an̰ji dee ùr ba a àlgɨ́ di me, an̰ji àlɨw bədə ɗɨm. ");
INSERT INTO sor_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Jonas yər Mãr̰ĩ àl nare nə Ninib wamani bədə da, sɨw ꞌyolɨw bədə me, dusɨw mendɨ bam bɨr̰ɨn̰. ");
INSERT INTO sor_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","An̰ji amsɨ Aba dama gɨ dɨrəw bɨr̰ɨn̰ me wayɨw ba da: «Ay, Aba dama gɨ dɨrəw bɨr̰ɨn̰, ta di me i mani nə nə wayagɨ mana gɨ nə wara nɨm sɨn̰a niyə sɨn̰ di bədə mo? Nə ꞌwocn̰ com: Mə i Mãr̰ĩ gaba àla dwani me, mə i aba yara nare n̰agɨni day me ca. Dusɨm kaw so kaláng bədə me. Mə i gun gɨ dusɨm ladɨ gɨ dɨrɨn̰ bɨr̰ɨn̰. Mə ɨrɨm dee ba mə àl wamani me, mə àl bədə. I ta di me nə ɨrɨm ba nə wà ha nɨm Tarsis di. ");
INSERT INTO sor_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Caga da, Aba dama gɨ dɨrəw bɨr̰ɨn̰, u hwaya ni! Made da, nə ùrdɨ ɗoy dama gɨ dɨr̰ɨn̰a lə bam.» ");
INSERT INTO sor_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Aba dama gɨ dɨrəw bɨr̰ɨn̰ cow lə diiyə ba da: «Dusɨm so ta di da, mə àl ladɨ le mo?» ");
INSERT INTO sor_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Ɨr̰ɨ Jonas dɨm ha dama Ninib tuldɨ dɨ jomniyə me, ɗangr̰ɨ kundi me dam dun duwa lə dara ba a yərgɨ mani nə ba hára lə mana gɨ ciriyə di. ");
INSERT INTO sor_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Mãr̰ĩ Gaba dama gɨ dɨrəw bɨr̰ɨn̰ àsɨ pəngə Jonas dɨwə àlɨw gɨ dun hɨlalɨw gɨ dusɨw. Mwom da, Jonas àl sii ꞌywala gɨ geche dara pəngə dɨ ta di. ");
INSERT INTO sor_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Me sanga gɨ jomni cor̰ər̰ə da, Mãr̰ĩ giyə gɨ dan̰ gɨra wom pəngə sabɨradɨ bam, me pəngə di woy bam. ");
INSERT INTO sor_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Mana gɨ dawa ba dɨ gandɨ daa mwom da, Mãr̰ĩ giyə gale gɨ ur̰e swaa tulɨn̰ dɨ jomniyə me, dawa a Jonas dɨwə me, àlɨw ya ba dɨ ꞌyəwe de. Yande da, an̰ji ùr i made me wayɨw Mãr̰ĩ ba da: «Made da, biya ɗoy dama gɨ dɨr̰ɨn̰a lə bam.» ");
INSERT INTO sor_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Mãr̰ĩ wayɨw Jonas: «Dusɨm so dara pəngə dɨ ta di da, ladɨ le mo?» An̰ji cow lə diiyə ba da: «Əw, dusɨn so ta di, ladɨ le, nə ùr i made.» ");
INSERT INTO sor_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Me Aba dama gɨ dɨrəw bɨr̰ɨn̰ wayɨw ba da: «Pəngə dɨ idɨ dun dɨ ta di, jor gɨ changa mɨn me woy sanga gɨ changa me ca. Ɨjɨm, mə àl giyə dɨra mɨn tenene bədə kaw, dɨrəm ꞌyəngɨm daradɨ. ");
INSERT INTO sor_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Ɨr̰ɨ ɨndi da, mə ùr dara dɨrən ba ꞌyangɨnan Ninib dɨdə bədə mo? Ninib i ciri dɨ geche dɨ nare dɨra ɗoy dubu aru gɨ gɨnɨn̰ sɨr (120 000) bam nə ꞌwocn̰ an̰jira gɨ mani nə lade me nə àcn̰e me bədə, me mwagɨne kaw gɨr̰ɨ nan̰e me ca da, dɨrən ꞌyangɨnan dɨdəgɨ lə bədə mo?»");
INSERT INTO sor_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Dwaynandɨ Jesu Kris mwágɨraw sumdəgɨ: Jesu i Dabid mwàw me Abɨraham mwàw me. ");
INSERT INTO sor_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abɨraham i Isak abəw. Isak i Jakob abəw. Jakob i nə Juda day gɨ nə chamraw abɨragɨ. ");
INSERT INTO sor_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda i nə Peres day gɨ Jara abɨragɨ, me idəgɨ da, i Tamar. Peres i Esɨrom abəw. Esɨrom i Aram abəw. ");
INSERT INTO sor_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram i Aminadab abəw. Aminadab i Nason abəw. Nason i Salmon abəw. ");
INSERT INTO sor_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon i Boos abəw. Boos iw da, i Rahab. Boos i Obed abəw. Obed iw da, i Rut. Obed i Jese abəw. ");
INSERT INTO sor_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jese i dole gɨ Dabid abəw. Dabid i Salmõ abəw. Salmõ iw da, i aba mara gɨ Uri dyaməw. ");
INSERT INTO sor_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salmõ i Robowam abəw. Robowam i Abiya abəw. Abiya i Asa abəw. ");
INSERT INTO sor_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa i Yosapat abəw. Yosapat i Yoram abəw. Yoram i Ojiyas abəw. ");
INSERT INTO sor_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ojiyas i Yotam abəw. Yotam i Akas abəw. Akas i Esekiyas abəw. ");
INSERT INTO sor_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekiyas i Manase abəw. Manase i Amon abəw. Amon i Josiyas abəw. ");
INSERT INTO sor_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiyas i Yekoniya day gɨ nə chamraw abɨragɨ. Mana gɨ ta lə da, gɨ lay nare nə Israyel cɨmgɨ daa, hára nɨm mana gɨ sɨn̰a dɨ Babilonnə. ");
INSERT INTO sor_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Cɨmə day gɨ cendi cɨm ha mana gɨ Babilon di tarɨwə mwom da, Yekoniya gɨra ha yàa Salatiyel. Salatiyel i Jorobabel abəw. ");
INSERT INTO sor_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Jorobabel i Abiyud abəw. Abiyud i Eliyakim abəw. Eliyakim i Ajor abəw. ");
INSERT INTO sor_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ajor i Sadok abəw. Sadok i Akim abəw. Akim i Eliyud abəw. ");
INSERT INTO sor_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyud i Eliyajar abəw. Eliyajar i Matan abəw. Matan i Jakob abəw. ");
INSERT INTO sor_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jakob i Josep abəw. Josep i Mari tɨrədɨ. Me Mari i Jesu gɨ gɨ ꞌwogɨw Kris di iw. Kris gɨndɨw dɨ biyə da, iDole gɨ Mãr̰ĩ biyəw di. ");
INSERT INTO sor_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ta di mwom da, nare dayar daa pad da, i mage mwaj dii wodɨ so Abɨrahammə bɨraa hára Dabid lə. So mana gɨ Dabid lə bɨraa hára laya day gɨ gɨ layagɨ hára gandagɨ mana gɨ Babilon da, i mage mwaj dii wodɨ ɗang. So mana gɨ Babilon bɨraa hára Dole gɨ Mãr̰ĩ biyəw gɨ Kris di lə da, i mage mwaj dii wodɨ ɗang bi. ");
INSERT INTO sor_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Dwaynandɨ Jesu Kris da, gɨ yə̀w i man mo? Mari dɨ i iw di, i Josep me àl mogɨni dɨra an̰ju, me pii gɨ cendi wor laya ciri sɨn̰ da, Mari i gɨ gudi. Tandi u gudi di i gɨ dwana dɨnə dúndi dɨnə Mãr̰ĩ duwa dɨra. ");
INSERT INTO sor_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Aba àla mogɨni dɨra gɨ Josep da, i gun gɨ tɨba Mãr̰ĩ dɨrəwə me ùr ba a àsɨdɨ Mari jawe dɨdə nare dɨrəgɨ lə bədə. Mwom da, an̰ji ùr ba biy sɨw bam gɨ budə sɨway gɨn̰dɨ bam. ");
INSERT INTO sor_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Mana gɨ ba ilə ɨrmə lə yande jang sɨn̰ da, paja gɨ daa gɨnə Aba ciri gɨ Mãr̰ĩ duwa dɨmə gɨra àsɨw chine mana gɨ nuniyə me wayɨw da: «Josep gɨnə dole gɨ Dabid mwàw, kal lán̰a dara ꞌwoo gɨ dyam dɨ Mari di ɗi. Dara dwe gɨ ilə nudədɨ lə ta di hára i gɨ dwana dɨnə dúndi dɨnə Mãr̰ĩ duwa dɨra. ");
INSERT INTO sor_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Gorndɨdɨ gɨ tandi ha yàw di, mə ha ꞌwagaw sumɨw “Jesu”, gɨndɨw dɨ biyə da, iAba kɨdə nare daa. Dara i an̰ji me ha kɨdə nare duwa daa mana gɨ àcn̰a dayyə.» ");
INSERT INTO sor_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ta di me i mani nə tanga Aba ciri gɨ Mãr̰ĩ wayɨw aba cɨmə bɨw gwale day di me yala àlal kɨrab. ");
INSERT INTO sor_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","An̰ji waya ba da: «Yarna, dwe dɨ more dɨ ꞌwocn̰ abe dii mɨn bədə sɨn̰ ha ꞌwoo gudi me ha yàa dwe gɨ abe. Gɨ ha ꞌwagaw sumɨw Emanuwel», gɨndɨw dɨ biyə da, i «Mãr̰ĩ ilə ganandɨ». ");
INSERT INTO sor_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Me mana gɨ Josep ba a a daa nuniyə mwom da, an̰ji àl mani nə paja gɨ daa gɨnə Aba ciri gɨ Mãr̰ĩ duwa wayɨw gandagɨ di. An̰ji wàla dyaməw di hára nɨm ulay duwa lə, ");
INSERT INTO sor_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","me an̰ji ɓamar gandɨdɨ deme gɨ abe bədə, bɨraa tandi yə̀ nɨm gɨ dwe gɨ abe di dodə bá. Ɨr̰ɨ Josep ꞌwogɨw dwe di sumɨw Jesu. ");
INSERT INTO sor_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesu da, gɨ yə̀w i mana gɨ ciri dɨ Betɨlehem dɨ wama gɨ Judeyə, i wála gɨ dole gɨ Erod lam gɨ dwãr̰ĩyə. Wála mɨn da, nare nə gɨndəgɨ i Juwib bədə woni ꞌwacn̰a dechu swaa tulɨn̰ dɨ jomniyə hára mana gɨ ciri dɨ geche dɨ Jursalemmə. ");
INSERT INTO sor_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Cendi ùr nare ba da: «Dole gɨnə nare nə Juwib day gɨ gɨ yə̀w caga ka di da, i we mo? Nə yaranin dechu duwa dɨmə lə tulɨn̰ dɨ jomniyə, me nə háranin nɨm dara mɨlawdaw.» ");
INSERT INTO sor_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Mana gɨ dole gɨ Erod ba a doy gwale di yande da, dusɨw cubɨwe, day gɨ nə nare nə Jursalem di pad me ca. ");
INSERT INTO sor_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Dole di ꞌwaga woni bwasa Mãr̰ĩ gechide day pad me woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa pad me sɨwə me ùrgɨ ba da: «Dole gɨnə nare nə Juwib day gɨ Mãr̰ĩ biyəw gɨ Kris di da, gɨ ha yàw i we mo?» ");
INSERT INTO sor_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Cendi cow lə diiyə ba da: «An̰ji, gɨ ha yàw i mana gɨ Betɨlehem wama gɨ Judeyə. Nə ꞌwocn̰ɨnin dara aba cɨmə Mãr̰ĩ bɨw jangɨ lə Maktubu dɨnə Mãr̰ĩ duwa lə pii ba da: ");
INSERT INTO sor_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Mɨndi dɨ Betɨlehem dɨ wama gɨ Judeyə da, də i ciri dɨ dwe bɨr̰ɨn̰ mana gɨ kwanday ciri dɨ gechide dɨ wama gɨ Jude dwar̰agɨ lə bədə, dara gɨ ha yàa dole gɨnə nare nə Juwib day i diya lə mɨndi. An̰ji ha ꞌya i aba gaman nare ni nə Israyel ya aba gama mani nə paga de.”» ");
INSERT INTO sor_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ɨr̰ɨ Erod ꞌwogɨ nare woni ꞌwacn̰a dechu di gɨ budə sɨway, me ùrgɨ cendi ba yara dechu di ácn̰a lə i mindi na mo? ");
INSERT INTO sor_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ɗang da, an̰ji giygɨ mana gɨ Betɨlehem me waygɨ da: «Hana ùrbɨnə dwe di mana duwa ladɨ le, me anə ꞌywanaw da, cwarnay hane waynan, dara ɨndi kaw, nə ùr ba nə ha mɨlawdawe me ca.» ");
INSERT INTO sor_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Mana gɨ dole gɨ Erod ba a waygɨ yande mwom da, cendi bor bɨrmə lə ilə háragɨ lə da, mana gɨ ta lə dog, cendi yər dechu dɨ cendi yaradɨ pii tulɨn̰ dɨ jomniyə di ɨndər dɨrəgɨ lə gɨlgɨ bɨrmə. Tandi ha gɨra ha ɗɨbə mana gɨ kulu gɨ dwe ilə di dɨwə ɗən̰. ");
INSERT INTO sor_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Mana gɨ ba gɨ yər dechu di da, sɨdəgɨ ꞌyolgɨ nan̰e. ");
INSERT INTO sor_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Cendi ba gɨ gandɨ ha kulə da, yər dwe di day gɨ iw dɨ Mari ca ilə. Mwom da, cendi piy gubɨrəgɨ dodə dɨrəwə me mɨlawdɨw nɨm. Targɨn̰ ɗang da, cendi tɨn̰bə magɨlale day bɨdəgɨ bam me lay jindar me mani woni gwasa nə biy ꞌyol nə kili day wom nan̰ me swani gɨ gɨ ꞌwogɨw mir gaba biyə ꞌywala gɨ kili duwa wom nan̰ me ꞌyàw. ");
INSERT INTO sor_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Mwom da, Mãr̰ĩ gɨra àsɨgɨ chine nuniyə waygɨ cendi ba cwarna gɨ Erod dɨwə bədə ɗɨm. Ɨr̰ɨ cendi u bɨrmə gɨ ɗang me ha nɨm ulay mana gɨ sɨn̰a dayyə. ");
INSERT INTO sor_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Mana gɨ woni ꞌwacn̰a dechu di ba gɨ cor yá da, paja gɨ daa gɨnə Aba ciri gɨ Mãr̰ĩ duwa dɨmə gɨra me àsɨw Josep chine mana gɨ nuniyə wayɨw ba da: «So daa, u dwe di me wol iw di me, wana hana kaláng mana gɨ sɨn̰a dɨ Ejibtɨ lə. Damnay alə ta bɨraa ɗan̰ wála gɨ nə ha wayam ba mə cwarnay hane bá do. Dara Erod kan̰jɨ bɨrmə dara ba a ꞌyə dwe di i bam.» ");
INSERT INTO sor_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Mwom da, Josep so daa, u dwe di me wol iw di me gɨ changa dɨ ta lə di dog, me hargɨ mana gɨ Ejibtɨ. ");
INSERT INTO sor_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","An̰ji dama alə ta di bɨraa Erod mar bam bá do me Mãr̰ĩ wayɨw an̰ju ba cwarnay hane sɨn̰. Ta di me i mani nə tanga Aba ciri gɨ Mãr̰ĩ wayɨw aba cɨmə bɨw gwale day di me yala àlal kɨrab. An̰ji waya ba da: «Nə ꞌwogɨ gorndɨn ba dɨmnə kalna Ejibtɨ bam.» ");
INSERT INTO sor_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ɨr̰ɨ Erod ba yər dara woni ꞌwacn̰a dechu di ba àlɨw i məng da, dusɨw so nan̰e. An̰ji giy ba ꞌyána dine nə abje nə ciri duwa dɨ Betɨlehemmə me ciri dɨ tulbədɨ lə pad me bam. I dine nə gɨ yə̀gɨ dɨrway bɨraa hára aliya gɨ sɨrrə bá ɨrɨm nɨm ya wála gɨ nare woni ꞌwacn̰a dechu ba gɨ wayɨw nɨm gɨ gwaleyə di de. ");
INSERT INTO sor_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ta di me i mani nə tanga aba cɨmə Mãr̰ĩ bɨw gɨ Jeremi waya gwale day di me yala àlal kɨrab. An̰ji waya ba da: ");
INSERT INTO sor_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Mana gɨ ciri dɨ Rama lə da, gɨ doy gura gɨ mir̰endi me wuwuyu me nɨmə lə nan̰. Rachelnul gura nan̰ me ùr gun ba hɨlalnadɨ dusɨdɨ bədə, dara dɨndadɨ di mɨn kaw, wor lə bədə.» ");
INSERT INTO sor_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Mana gɨ made dɨnə Erod duwa tardɨ lə da, paja gɨ daa gɨnə Aba ciri gɨ Mãr̰ĩ duwa dɨmə gɨra àsɨw Josep chine nuniyə mana gɨ sɨn̰a dɨ Ejibtɨ lə ");
INSERT INTO sor_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","me wayɨw da: «So daa, u dwe di me wol iw daa me mə cor ha gandagɨ mana gɨ sɨn̰a dɨ Israyel lə. Dara woni ùrə ba gɨ ꞌyə dwe di mar bam ɗɨm.» ");
INSERT INTO sor_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Josep so daa, me u dwe di me wol iw di me, cor ha mana gɨ sɨn̰a dɨ Israyel lə. ");
INSERT INTO sor_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Me mana gɨ Josep ba a doy i dole gɨ Erod gorndɨw gɨ Arkelayus ba lam dwãr̰ĩ mana gɨ wama gɨ Judeyə abəw mana duwa lə da, an̰ji lán̰ dara hára gɨ Jude di. Mwom da, Mãr̰ĩ gɨra àsɨw chine me wayɨw ba swana daa, hana mana gɨ wama gɨ Galileyə. ");
INSERT INTO sor_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Yande da, an̰ji ha dama mana gɨ ciri dɨ Najaret lə. Ta di me i mani nə tanga woni cɨmə Mãr̰ĩ bɨw waya gwale day di me yala àlal kɨrab. Woni cɨmə Mãr̰ĩ bɨw waya ba da: «Gɨ ha ꞌwagaDole gɨ Mãr̰ĩ biyəw gɨ Krisdi ba i gun gɨ Najaret.» ");
INSERT INTO sor_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Aliya gɨ ta lə da, Jã gaba àlagɨ́ nare batem dɨm ha dɨn dwar̰ɨ lə mana gɨ wama gɨ Judeyə, me an̰ji àsɨ berni ba da: ");
INSERT INTO sor_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","«Kalna àcn̰a dan di bam me hane ꞌywana Mãr̰ĩ, dara wála duwa gaba lama dwãr̰ĩ di yala ib ɗɨm.» ");
INSERT INTO sor_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Aba cɨmə Mãr̰ĩ bɨw gɨ Esayi waya pii dara mani nə Jã ba ha àlagɨ̀ di. Esayi way ba da: «Gun soy berni mana gɨ dɨn dwar̰ɨ lə ba da: “Aba ciri gɨ Mãr̰ĩ hára lə! Ɗangr̰ɨnaw bɨrmə, kalɨw a inə i tɨba!”» ");
INSERT INTO sor_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Me Jã di da, i gun gɨ hurə i barge gɨ gɨ ɗangr̰ɨw i gɨ wudɨn̰ nənə jambal dɨra me, an̰ji ma wamdaw i gɨ gare gɨ kulajɨ me, an̰ji wom i sɨba me dùmbu dɨ bam me ca. ");
INSERT INTO sor_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Nare nə ciri dɨ geche dɨ Jursalemmə me, nə wama gɨ Judeyə pad me, nə wama gɨ kuray gɨ Jurde tulbəwə bá bá me, hára ꞌyow. ");
INSERT INTO sor_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Cendi piy àcn̰a day gɨndɨw daa nare dɨrəgɨ lə do me Jã àlgɨ́ batem mana gɨ kuray gɨ Jurdeyə sɨn̰. ");
INSERT INTO sor_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Mana gɨ Jã ba a yər dara i nare nan̰ nə gɨ ꞌwogɨgɨ Parise me Saduse me hára ꞌyow dara ba àlnagɨ́ batem mwom da, an̰ji waygɨ da: «Mɨgay dɨndadɨ nə gá! Anə ɨrɨm dara anə ba ha bɨlə sɨdəng daa sariya dɨnə Mãr̰ĩyə di le ɓa? I wi wayang yande mo? ");
INSERT INTO sor_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Anə ùrnə dara sariya ba yɨbɨnəng bədə da, àlna mani nə lade. Gɨlnə dara anə banə kala àcn̰a dan di bam ɗɨm me banə yala ꞌyo Mãr̰ĩ. Yande da, anə ha wunə i ya habda gɨ lade ba a bo gɨ yàa duwa de. ");
INSERT INTO sor_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Kalna ɨrmə dusɨrəngə anə banə ꞌyo i bɨlə ɗɨm dara anə banə i Abɨraham mwàgɨraw ɗi. Dwayna, nə wayang: Kur̰a dɨ ɓolbəre dɨ ta di, Mãr̰ĩ nem cwadɨ Abɨraham mwàgɨraw. ");
INSERT INTO sor_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Bɨgame ilə habde gɨndəgɨ lə ɗɨm dara sabagɨ bam led led. Habda gɨ we we gɨ yàna ladɨna bədə da, gɨ ha sawaw bam dodə gɨndɨwə led àsaw dùwa lə.» ");
INSERT INTO sor_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ɨr̰ɨ Jã waygɨ nare nə gɨr̰e ba da: «Ɨndi da, nə àlang batem i gɨ nimi, gɨl dara anə banə kala mani dan nə àcn̰e di bam me anə banə yala ꞌyo i Mãr̰ĩ ɗɨm. Me tarɨnnə da, gun gɨ ɗang gɨ dwana duwa ɗoy dɨ ni bam hára lə. Gun gɨ ta di i gɨ geche gɨ ɨndi da, nə nem àsa dɨgɨlan mana gɨ dɨgɨlaw duwa dɨ an̰ji àsɨdɨ dodə dɨdə bədə. An̰ji duwa da, ha hára àlang batem i gɨ Dúndi dɨnə Mãr̰ĩ duwa me gɨ dùwa me ca. ");
INSERT INTO sor_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","An̰ji yɨ ɗagɨna dɨ idɨ huyə swagə di ɨsəwə dara huyə gɨ chìmi bam me kala gɨ swagə dɨrəgɨ. An̰ji ha laya swagə dɨrəgɨ di bwagɨ ɓecheyə, me ha ulə chìmi bam mana gɨ dùwa dɨ budə dɨra gɨ bam ilə bədə bɨr̰ɨn̰yə.» ");
INSERT INTO sor_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Wála mɨn, Jesu swaa kala wama gɨ Galile bam me hára kuray gɨ Jurde bɨwə. An̰ji hára mana gɨ Jã sɨwə dara ba àlnaw batem. ");
INSERT INTO sor_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Me Jã di ùr bədə me wayɨw da: «Dee i ɨndi me nə ha ùrəm ɨjɨm ba mə àlnan batem me, cor i man me ɨjɨm me mə hára ꞌyon ɨndi dara ba nə àlnam batem mo?» ");
INSERT INTO sor_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesu cow lə diiyə wayɨw ba da: «Wála gɨ laba lə da, gɨn̰ bam bədə. Ladni duwa da, àlndɨ yande dara i mani nə Mãr̰ĩ ùrgɨ ba àlalna di.» Mwom da, Jã gɨn̰ bam bədə me àlɨw Jesu batem di. ");
INSERT INTO sor_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Mana gɨ Jesu ganda daa nimiyə mwom da, mana gɨ ta lə dog, daa tɨn̰ər bam pɨrang me Jesu yər Dúndi dɨnə Mãr̰ĩ duwa chə́ə dɨwə ya kogəl de, gɨra dam dɨwə. ");
INSERT INTO sor_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Mwom da, gun mar̰ɨjaw nɨmə daa, me mar̰ɨje di way da: «Ta di i gorndɨn, dusɨn ùrɨw nan̰e, me sɨn ꞌyolɨn dɨwə me ca.» ");
INSERT INTO sor_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ɗang da, dúndi dɨnə Mãr̰ĩ duwa ha gɨ Jesu mana gɨ bam dɨn dwar̰ɨ lə dara Sidan ba gɨrsɨnəw nɨm, gaa ba dɨ ha nyama lamaw àsaw àla gɨ àcn̰a lə mo? ");
INSERT INTO sor_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jesu wom mani bədə gɨ dawa me gɨ changa me àl wála gɨnɨn̰ wodɨ da, cherni àlɨw nan̰e. ");
INSERT INTO sor_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Me Sidan dɨ idɨ gɨrsə nare di chidɨ hára sɨwə me wayɨw da: «Mə ina i Mãr̰ĩ gorndɨw ꞌyang da, waydɨ kur̰a dɨ ta di dɨ cwarna gɨdɨnəm hayeme mə wom.» ");
INSERT INTO sor_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Me Jesu codɨ lə diiyə waydɨ ba da: «Gɨ jangɨ lə Maktubu dɨnə Mãr̰ĩyə way ba da: “I gɨ haye mɨra me gun gɨ gɨsage ha nyama bɨlə nɨm gɨ sɨw sɨn̰a dɨdə ka bədə. Me i gwale gɨ pad gɨ gandɨ mana gɨ Mãr̰ĩ bɨwə.”» ");
INSERT INTO sor_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Mwom da, Sidan wol Jesu ha gandɨw mana gɨ ciri dɨ Jursalemmə dɨ i ciri dɨnə Mãr̰ĩ duwa, gɨra ha chə́w daa kulu gaba bwasa Mãr̰ĩ mana duwa gɨ hoy cog dɨwə, ");
INSERT INTO sor_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","me wayɨw ba da: «Mə ina i Mãr̰ĩ gorndɨw ꞌyang da, par mana gɨ ka lə di ɨndər dodə me mə ha ꞌywaa wamani bədə, dara gɨ jangɨ lə Maktubu dɨnə Mãr̰ĩyə way ba da: “Mãr̰ĩ ha wayagɨ paja duwa nə daa ba yɨnəm daa gɨ ɨsɨragɨ dara kal dɨgɨlam ba ajarna kur̰a lə hin̰e bədə bɨr̰ɨn̰.”» ");
INSERT INTO sor_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Me Jesu codɨ lə diiyə waydɨ ba da: «Gɨ jangɨ lə Maktubu dɨnə Mãr̰ĩyə di way ba da: “Mə ha gɨrsə Aba ciri dɨma gɨ Mãr̰ĩ bədə.”» ");
INSERT INTO sor_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ɗang da, Sidan wol Jesu ha gandɨw daa kur̰a dɨ hoy dɨdə cog, me gɨlɨw ciri dɨ sɨn̰a gɨndɨdɨ lə pad gɨ mani dɨra nə woni sumi me ca, ");
INSERT INTO sor_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","me wayɨw ba da: «Mə piynə gubɨrəm dodə dɨrənnə me mə mɨlawdɨnan me da, nə ha ꞌyàm mani nə i pad ta di le.» ");
INSERT INTO sor_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Me Jesu waydɨ da: «Ha bam ched, Sidan. Nə ha mɨlawday bədə,  dara gɨ jangɨ lə Maktubu dɨnə Mãr̰ĩyə way ba da: “I Aba ciri dɨma gɨ Mãr̰ĩ mɨn me mə ha piyə gubɨrəm dodə dɨrəwə me, mə ha mɨlawdaw an̰ju mɨn tenene me ca.”» ");
INSERT INTO sor_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ɨr̰ɨ Sidan di so ya kalɨw, me i Paja nənə Mãr̰ĩ duwa nə daa chidɨ hára Jesu sɨwə ib me gamɨw me. ");
INSERT INTO sor_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Wála mɨn, Jesu doy dara ba gɨ yɨ Jã Batis àsɨw dangeyə. Mwom da, an̰ji so cor dara hára ulay wama gɨ Galileyə. ");
INSERT INTO sor_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Me an̰ji so kal ciri dɨ Najaret bam, me ha dama mana gɨ ciri dɨ Kapernom, dɨ i kuray gɨ ɓɨle gɨ Galile bɨwə, i wama gɨ Jabilonnə me Neptaliyə me ca. ");
INSERT INTO sor_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ta di me i mani nə tanga Mãr̰ĩ wayɨw aba cɨmə bɨw gɨ Esayi gwale day di me yala àlal kɨrab. An̰ji waya ba da: ");
INSERT INTO sor_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Dwayna, ꞌyeni nare nə wama gɨ Jabilonnə me wama gɨ Neptaliyə me, ꞌyeni nə anə dam kuray gɨ ɓɨle tulbəwə me kuray gɨ Jurde dugdɨw dɨ alə ta lə me, ꞌyeni nə wama gɨ Galileyə nə i nare nə gɨndəgɨ jiga jiga me. ");
INSERT INTO sor_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ꞌYeni nare woni dama dɨban ꞌwacn̰a gɨ Mãr̰ĩ da, Mãr̰ĩ ha gɨləng bɨrmə gaba ꞌywaa bɨlə. ꞌYeni nare woni dama mana gɨ made ɨsədɨ lə da, Mãr̰ĩ ha kɨdəng daa.» ");
INSERT INTO sor_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","So wála gɨ ta lə da, Jesu diy gɨnɨn̰ ilə àsagɨ nare berni. An̰ji waygɨ da: «Kalna àcn̰a dan di bam me hane ꞌywana Mãr̰ĩ, dara wála duwa gaba lama dwãr̰ĩ di yala ib ɗɨm.» ");
INSERT INTO sor_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Wála mɨn, Jesu ha mana gɨ kuray gɨ ɓɨle gɨ Galile bɨwə cab cab, me yər abje sɨr, i nə Simõ gɨ gɨ ꞌwogɨw Piyer di day gɨ chendɨw gɨ Andɨre. Cendi i nare woni ūrə, ilə bwaa law dayyə mana gɨ kuray dalawə. ");
INSERT INTO sor_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesu waygɨ ba da: «Kalna ūrə gɨ gòche di ɗi, me hane pamna tarɨn, kal nə cwang woni kan̰jan nare.» ");
INSERT INTO sor_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Mana gɨ ta lə di dog, cendi bo law day di dodə me pam tarɨw. ");
INSERT INTO sor_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Mana gɨ ba a ha chidɨ pii hin̰e da, an̰ji yər abje sɨr ɗang bi, i nə Jak day gɨ chendɨw gɨ Jã, nə i Jebede dɨndaw. Cendi dam bɨrwa day dalawə day gɨ nə abɨragɨ mɨn me ilə ɗangr̰a law day di lə. Me Jesu waygɨ da: «Hane, pamna tarɨn». ");
INSERT INTO sor_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Mana gɨ ta lə di dog, cendi kal bɨrwa day di me abɨragɨ di me bam, me pam Jesu tarɨw. ");
INSERT INTO sor_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesu ha mana gɨ wama gɨ Galileyə pad, me an̰ji gɨlgɨ nare mani mana gɨ kululi day woni amsa Mãr̰ĩyə. An̰ji waygɨ Nõ dɨ lade dɨ Mãr̰ĩ lam gɨ dwãr̰ĩ, me an̰ji so nare daa mana gɨ mwom day gɨ dɨrəw jiga jiga lə pad me wamani day gɨ dɨrəw jiga jiga gɨ cogɨ nare tuləgɨ lə daa pad me ca. ");
INSERT INTO sor_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","I ta di me gɨ ꞌwogɨ Jesu sumɨw gɨ ꞌyole mana gɨ sɨn̰a dɨ Siri gɨndɨdɨ lə pad. Gɨ háraw gɨ nare pad woni gɨlə dɨrɨn̰ ya woni mwom me, wamani gɨ dɨrəw jiga jiga gɨ cogɨ nare tuləgɨ me, nə dúndi dɨ àcn̰e widɨbɨgɨ me, woni jumgɨl me ca; gɨ háraw gɨ nare nə r̰egɨdu, me Jesu sogɨ daa. ");
INSERT INTO sor_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Nare nə gɨr̰e nan̰ ilə bwaa Jesu lə me. Cendi swaa i wama gɨ Galileyə me, wama gɨ gɨ ꞌwogɨw «Ciri dɨ mwaj» lə me, ciri dɨ Jursalemmə me, wama gɨ Judeyə me, wama gɨ kuray gɨ Jurde dugdɨw dɨ alə ta lə me ca. ");
INSERT INTO sor_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Mana gɨ Jesu yər nare nə gɨr̰e yala ꞌyow da, an̰ji nagɨ ha daa kur̰a dɨdə me dam dodə, me woni gɨrsə gwale duwa chidɨbə daa sɨwə ib ib. ");
INSERT INTO sor_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Mwom da, Jesu diy gɨnɨn̰ ilə gɨləgɨ maniyə. An̰ji waygɨ ba da: ");
INSERT INTO sor_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Nare nə ꞌwocn̰ dusɨrəgɨ lə dara ba gɨ i nə bugɨr pəgɨn̰ Mãr̰ĩ dɨrəwə da, dam i gɨ sii ꞌywala, dara ciri dɨ daa da, i day cendi. ");
INSERT INTO sor_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Nare woni nulə gura da, dam i gɨ sii ꞌywala, dara Mãr̰ĩ ha hɨlalagɨ dusɨrəgɨ le. ");
INSERT INTO sor_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Nare nə hɨlale jwam da, dam i gɨ sii ꞌywala, dara Mãr̰ĩ ha ꞌyàgɨ́ sɨn̰a duwa di le. ");
INSERT INTO sor_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Nare nə i gɨ cherni gaba àla mani nə tɨba Mãr̰ĩ dɨrəwə da, dam i gɨ sii ꞌywala, dara an̰ji ha wagɨ lə àla gɨ mani duwa nə tɨba lə di le. ");
INSERT INTO sor_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Nare nə yər kwandagɨ n̰agɨni day da, dam i gɨ sii ꞌywala, dara Mãr̰ĩ kaw, ha yara n̰agɨni day di le me ca. ");
INSERT INTO sor_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Nare nə dusɨrəgɨ wusɨ ladɨ da, dam i gɨ sii ꞌywala dara ɗan̰ cendi ha yara Mãr̰ĩ di gɨ dɨrəgɨ day. ");
INSERT INTO sor_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Nare woni ɗangr̰a kwandagɨ nə i gɨ gwale bulə dayyə dara ba damna gɨ labiya da, dam i gɨ sii ꞌywala dara Mãr̰ĩ ha ꞌwagagɨ cendi ba i dɨndaw. ");
INSERT INTO sor_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Nare nə gɨ gɨlgɨ dɨrəgɨ dara cendi ba àl mani nə tɨba Mãr̰ĩ dɨrəwə da, dam i gɨ sii ꞌywala, dara ciri dɨ daa da, i day cendi. ");
INSERT INTO sor_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","ꞌYeni da, mana gɨ nare cadɨbɨnang labaa, gɨlnəng dɨrəng labaa, sabɨnang gwale gɨ kulagɨ jiga jiga bwanang dɨdəngə dara ɨndi gɨ Jesu da, anə dam i gɨ sii ꞌywala. ");
INSERT INTO sor_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Àlna sii ꞌywala me ajɨna pide nan̰ me, dara ꞌywaga dan gɨ geche gamangə daa Mãr̰ĩ sɨwə. Yarna, ꞌyeni di, anə wun i ya woni cɨmə Mãr̰ĩ bɨw nə pii ba gɨ gɨlgɨ gɨ dɨrəgɨ ta de me ca.» ");
INSERT INTO sor_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«ꞌYeni da, anə i ya wàla de mana gɨ nare nə sɨn̰a dɨdə ka dwar̰agɨ lə. Me wàla di hɨranga duwa biyarna bam mwom da, gɨ ha àlaw man me ha cwara hɨranga ɗang bi mo? Ladni duwa hin̰e kaw, ilə bədə ɗɨm. Gɨ ha twaw i bam iche, me nare ha hára ilə diiyə. ");
INSERT INTO sor_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","ꞌYeni da, anə i ya ácn̰a gɨnə lamba dɨra de mana gɨ nare nə sɨn̰a dɨdə ka dwar̰agɨ lə. Ciri dɨ geche damna daa kur̰a dɨdə da, nem lɨgara dodə ɗang mo? Nem lɨgara bədə. ");
INSERT INTO sor_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ácn̰a gɨnə lamba dɨra di kaw, i yande me ca. Gɨ u lamba me gɨ ha ɨbədɨ ɗagɨna dɨdə dara budədɨ nɨm dodə bədə. Me gɨ chidɨ i daa mani dɨdəgɨ lə dara nare pad nə dam mana gɨ kulə ta di ba yarna gɨ mana. ");
INSERT INTO sor_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","ꞌYeni di kaw, kal ácn̰a dan di ácn̰ana le nare dɨrəgɨ lə yande me ca. Yande do me cendi ha yara gɨ mani dan nə àla nə lade ya ba gɨ yər nɨm gɨ ácn̰a gɨnə lamba dɨra di de, me cendi ha ꞌwaga gɨ Abɨrang gɨ Mãr̰ĩ gaba dama daa di sumɨw sɨn̰.» ");
INSERT INTO sor_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«Gaa anə ɨrɨm dusɨrəngə dara ba nə hára sɨn̰a lə ka dara myanda gɨ bii gɨ ꞌwoo gɨnə Moyis duwa bam, labaa gwale gɨnə woni cɨmə Mãr̰ĩ bɨw day bam mo da, kalna ɨrmə dusɨrəngə yande ɗi. Nə hára i dara myandagɨ bam bədə, me i dara kal mani di ba àlalna le. ");
INSERT INTO sor_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Dwayna, nə wayang i gwale sɨw: Mana gɨ daa me dodə me wor ilə sɨn̰ da, biyə gɨ mani bam hin̰e mana gɨ janga gɨ bii gɨ ꞌwoo lə da, ilə bədə, bɨraa mani di pad ha àlala nɨm bá. ");
INSERT INTO sor_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Yande da, gun gɨ cilangɨna bii gɨ ꞌwoo di gɨ dwe hin̰e mɨn daa kwandaw dwar̰agɨ lə me gɨlnəgɨ nare ba cilangɨna daa me ca da, gun gɨ ta di, gɨ ha yaraw ba i gun gɨ ɓani kwandaw dwar̰agɨ lə ciri dɨ daa lə. Me gun gɨ yɨnə bii gɨ ꞌwoo di me gɨlnəgɨ nare ba yɨnə me ca da, an̰ji gɨ ha yaraw ba i gun gɨ geche ciri dɨ daa lə. ");
INSERT INTO sor_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nə wayang: Anə yɨnə bii gɨ ꞌwoo di ɗwayna nare woni gɨləw di bam me nare nə Parise di bam me bədə da, anə ha ganda hára ciri dɨ daa lə di bədə bɨr̰ɨn̰.» ");
INSERT INTO sor_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«Anə dwaya dara Moyis ba waygɨ mwágɨrandɨ nə pii mana gɨ bii gɨ ꞌwoo lə ba gun ba ꞌyána jaw gun gɨ ùrə duwa bədə. Gun gɨ ba ꞌyána jaw gun gɨ ùrə duwa da, gɨ ha hára gandɨw i mana gɨ sariya lə, me sariya ha yə̀we. ");
INSERT INTO sor_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Me ɨndi da, nə wayang: Gun gɨ dusɨw swana jaw gun dɨwə da, gɨ ha hára gandɨw i sariya lə, me sariya ha yə̀we. Ɗang da, gun gɨ cadɨna jaw gun ba “mə samar” kaw, gɨ ha hára gandɨw i mana gɨ woni aa sariya dɨrəgɨ lə, me sariya ha yə̀we. Me gun gɨ cadɨna jaw gun ba “mə i məng” kaw, an̰ji ùr i àsa gɨ dùwa dɨ budə dɨra gɨ bam ilə bədə bɨr̰ɨn̰yə di me ca. ");
INSERT INTO sor_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Yande da, mana gɨ mə hana dara ꞌyàa sarga dɨma mana gaba bwasa Mãr̰ĩyə me dusɨm gunəm dara jam dusɨw ba nawe dɨmmə da, ");
INSERT INTO sor_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","chɨ́ mani dɨma woni ꞌyàa sarga di dodə mana gaba bwasa Mãr̰ĩ di bɨwə do. Cor ha ꞌywaa jam di anə ɗar̰ɨ gwale dan di bam do me mə cwara hára ꞌyàw Mãr̰ĩ sarga dɨma di sɨn̰. ");
INSERT INTO sor_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Mə hana dara hára mana gɨ sariya lə dan gɨ aba àla gandɨm gwale da, mana gɨ anə wor hára lə bɨrmə lə sɨn̰ da, ɗangr̰ɨ gandɨw gwale di bam kaláng. Pəgɨn̰ bədə da, an̰ji ha ꞌyàm aba àla sariya di ɨsəwə me, ɨr̰ɨ aba àla sariya di ha ꞌyàm asɨngar ɨsəwə me, gɨ ha hára àsam dangeyə. ");
INSERT INTO sor_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Doy, nə wayɨm i gwale sɨw: Mə ꞌywagɨna gursɨ dɨ dɨmə di ꞌyan̰ɨna bam pad bədə da, mə ha dɨmə bam dangeyə di bədə bɨr̰ɨn̰.» ");
INSERT INTO sor_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«Anə dwaya dara Moyis ba way mana gɨ bii gɨ ꞌwoo lə ba gun ba kan̰jɨna jaw dyaməw bədə. ");
INSERT INTO sor_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Me ɨndi da, nə wayang: Gun gɨ yarna jaw dyaməw gɨ ɨrmə gaba ùrə dara ba ha ꞌya gandɨdɨ le da, gun gɨ ta di i gandɨdɨ le dusɨwə ɗɨm. ");
INSERT INTO sor_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Inam i dudɨm dɨ ɨsəm gɨ abeyə me lamnam álnam àla gɨ àcn̰a lə da, biydɨ áldɨ bam hən̰. Biyə gɨ dudɨm mɨn bam da, ladɨ ɗoy gɨ Mãr̰ĩ ha álam dùwa dɨ budə dɨra ilə bədə bɨr̰ɨn̰yə di gɨ sɨm lə de pad bam. ");
INSERT INTO sor_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Inam i ɨsəm gɨ abe me lamnam àsɨnam àla gɨ àcn̰a lə da, sawɨw álɨw bam hən̰. Sawa gɨ ɨsəm mɨn bam da, ladɨ ɗoy gɨ Mãr̰ĩ ha àsam mana gɨ dùwa dɨ budə dɨra ilə bədə bɨr̰ɨn̰yə di gɨ sɨm de pad bam.» ");
INSERT INTO sor_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«Moyis way mana gɨ bii duwa gɨ ꞌwoo lə ba gun gɨ ba ana gɨ dyaməw bam da, kal an̰ju ba ꞌyànadɨ maktubu dɨ idɨ agda bam ɨsədɨ lə. ");
INSERT INTO sor_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Me ɨndi da, nə wayang: Abe gɨ ꞌywarna dyaməw dɨ i gɨ abe gɨ ɗang bədə bam da, an̰ji nogdɨ ba hana àlna àcn̰a gɨ gichɨni. Ɗang da, abe gɨ unə deme dɨ tɨrədɨ ꞌywaradɨ bam da, an̰ji àl i àcn̰a gɨ gichɨni di me ca. I ya an̰ji kaw, ba i i gɨ jaw dyaməw de me ca.» ");
INSERT INTO sor_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«Anə dwaya ɗang dara Moyis waygɨ mwágɨrandɨ nə pii mana gɨ bii gɨ ꞌwoo lə ba da, gun gɨ ba sɨrgɨnə sɨw gɨ Aba ciri gɨ Mãr̰ĩ sumɨw da, ba kalna bam bədə, me an̰ji ba gamna mani nə an̰ji sɨrgɨ gɨ sɨw di lə jang. ");
INSERT INTO sor_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Me ɨndi da, nə wayang: Sɨrgɨnə sɨdəng bədə bɨr̰ɨn̰. Sɨrgɨnə sɨdəng gɨ daa sumdɨ bədə, dara daa di i gage gɨ dwãr̰ĩ gɨnə Mãr̰ĩ duwa. ");
INSERT INTO sor_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Me sɨrgɨnə sɨdəng gɨ sɨn̰a sumdɨ bədə, dara sɨn̰a di, i mana gɨ Mãr̰ĩ bo gɨdaw lə me ca. Sɨrgɨnə sɨdəng gɨ ciri dɨ geche dɨ Jursalem sumdɨ bədə, dara Jursalem di, i ciri dɨnə Dole gɨ geche gɨ Mãr̰ĩ di duwa. ");
INSERT INTO sor_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Me sɨrgɨnə sɨdəng gɨ dɨdəng bədə me ca, dara anə nem cwaa wudɨn̰ nə dɨdəng mɨn tenene kaw, burage bədə me gɨsage bədə me ca. ");
INSERT INTO sor_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Nyamna gaba goo “əw” da, gunə “əw”, nyamna gaba goo “bədə” da, gunə “bədə” me ca. Mani nə nwagang sɨrgɨ gɨ sɨdəngə ta di, i ɨrmə gɨnə Sidan dɨra.» ");
INSERT INTO sor_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«Anə dwaya dara Moyis way mana gɨ bii duwa gɨ ꞌwoo lə ba da, gun ba gunəm dudɨm bam da, ba gɨ gunəw duwa lə biiyə me ca, gun ba ajɨnam sandam biynəm bam da, ba gɨ ajɨnaw duwa biynəw bam me ca. ");
INSERT INTO sor_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Me ɨndi da, nə wayang: Gun àlnang wamani da, cwarna àlnaw wamani lə biiyə bədə. Gun ajɨna gajam nə ɨsəm gɨ abeyə da, cow gajam nə ɨsəm gɨ jeleyə kalɨw a ajɨna lə bi me ca. ");
INSERT INTO sor_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Gun sawnam gwale dɨmmə mana gɨ sariya lə dara ba a lay gumaj dɨma gɨ jaw dalawə da, kalɨw a layna barge dɨma gɨ mə hurəw jaw dɨwə di lə me ca. ");
INSERT INTO sor_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Gun yɨnəm gɨ dwana dara ba mə unə hudɨr hana nɨm dɨgɨlay dubu mɨn da, ha nɨm gandɨw dɨgɨlay dubu sɨr. ");
INSERT INTO sor_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Gun amsɨnam mani da, ꞌyàw, me gun ùrnəm ꞌwáa kaw, ɨmɨw bam bədə me ca.» ");
INSERT INTO sor_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«Anə dwaya dara woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa way ba mə ha ùrə jam gun me ba mə ha ɨlə aba mar̰ande dɨma le. ");
INSERT INTO sor_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Me ɨndi da, nə wayang: Ùrnə woni mar̰ande danne, me amsɨna Mãr̰ĩ dara nare woni gɨləng dɨrəng me ca. ");
INSERT INTO sor_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","I ya ta de me anə ha gɨlə nɨm dara anə banə i Abɨrang gɨ Mãr̰ĩ gaba dama daa di dɨndaw sɨn̰. An̰ji kaw, kal dawa gandɨ nare woni àla mani nə lade dɨdəgɨ lə me woni àla mani nə àcn̰e dɨdəgɨ lə me ca. An̰ji ꞌwogɨ nare woni àla mani nə tɨba nimi me woni àla mani nə tɨba bədə kaw, an̰ji ꞌwogɨ nimi me ca. ");
INSERT INTO sor_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Dwayna, anə ùrnə i nare woni ùrəng mɨra da, anə ɓedɨ i ꞌywaga dan gɨ na Mãr̰ĩyə di mo? Nare woni salaw dole gɨ geche gɨ Rom mani di kaw, àl i yande me ca. ");
INSERT INTO sor_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Anə àlnagɨ́ i chamrang mɨra labiya da, anə àl i na nə lade nan̰ ɗoy bam mo? Nare woni ꞌwacn̰a Mãr̰ĩ gɨ ɓag bədə di kaw, cendi àl i ya ta de me ca. ");
INSERT INTO sor_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Abɨrang gɨ Mãr̰ĩ gaba dama daa i gun gɨ lade nan̰ bɨr̰ɨn̰. Yande da, ꞌyeni di kaw, ina i nare nə ladɨbe ya an̰ji ba i nɨm gun gɨ lade di de me ca.» ");
INSERT INTO sor_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«Àsɨna angal dan. Mana gɨ anə àlna i mani nə tɨba Mãr̰ĩ dɨrəwə da, kalna àlagɨ̀ daa pɨden̰yə nare dɨrəgɨ lə dara ba gɨ yarnang nɨm ɗi. Anə àlna mani di daa pɨden̰yə nare dɨrəgɨ lə da, Abɨrang gɨ Mãr̰ĩ gaba dama daa di ha ꞌywagang gwayni dan bədə. ");
INSERT INTO sor_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Yande da, mana gɨ mə ꞌyànaw gun gɨ bugɨr mani da, kal jajɨra daa dara nare pad ba yarnam nɨm ɗi. I nare nə gwale ꞌyol bɨdəgɨ me dusɨrəgɨ dɨ korgɨn̰ i jiga me àl yande mana gɨ kululi woni amsa Mãr̰ĩyə me mana gɨ bɨrmə dalawə me dara nare ba ꞌwagɨna gɨ sumdəgɨ. Dwayna, nə wayang i gwale sɨw: Cendi ꞌyo ꞌywaga day di bam ɗɨm. ");
INSERT INTO sor_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Me ɨjɨm da, mana gɨ mə ꞌyànaw gun gɨ bugɨr mani gɨ ɨsəm gɨ abe da, kal ɨsəm gɨ jele ꞌwacn̰ana mani nə mə ꞌyàw gandagɨ di bədə. ");
INSERT INTO sor_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Kal mani nə mə ꞌyàgɨ́ di ina i gɨ budə do me Abam gɨ Mãr̰ĩ gaba dama daa gaba yara mani nə budə lə di, ha ꞌywagam gwayni dɨma sɨn̰.» ");
INSERT INTO sor_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«Nare nə gwale ꞌyol bɨdəgɨ lə me dusɨrəgɨ dɨ korgɨn̰ i jiga ùr ɗɨbə gɨ daa mana gɨ kululi woni amsa Mãr̰ĩyə me bɨrmə jirang duwa lə me, amsɨ nɨm gɨ Mãr̰ĩ dara kal nare pad ba yarnagɨ nɨm. Amsɨna Mãr̰ĩ ya nare nə ta di de bədə. Dwayna, nə wayang i gwale sɨw: Cendi ꞌyo ꞌywaga day di bam ɗɨm. ");
INSERT INTO sor_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Me ɨjɨm da, mana gɨ mə ùrnə ba mə amsɨna Mãr̰ĩ da, gandɨ ha kulu dɨma lə mɨnam me ɗesɨ bii daa me amsɨ nɨm gɨ Abam gɨ Mãr̰ĩ gɨ ilə mana gɨ budə lə ta di. Me an̰ji gaba yara mani nə budə lə ta di ha ꞌywagam gwayni dɨma. ");
INSERT INTO sor_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Mana gɨ nare woni ꞌwacn̰a Mãr̰ĩ gɨ ɓag bədə di amsɨna mãr̰ĩ day da, cendi ajɨmar nɨm lə, ajɨmar nɨm lə. Me ꞌyeni da, amsɨna ya nare nə ta di de bədə. Ɨrmə dayyə da, cendi ɨrɨm ba gɨ wayna gwale ꞌyarbarna nan̰ da, mãr̰ĩ day ba ha ꞌyàgɨ́ mani nə cendi ùrəgɨ di le, me i sɨdɨ bədə. ");
INSERT INTO sor_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Àlna ya cendi de bədə, dara Abɨrang gɨ Mãr̰ĩ di ꞌwocn̰ mani nə jalang di le pii do me anə ùrɨw sɨn̰. ");
INSERT INTO sor_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Dwayna i man me anə ha amsa Mãr̰ĩ mo: Abɨranin gɨ Mãr̰ĩ gaba dama daa, kal nare ꞌwacn̰ana dara sumɨm ba wun i mɨnaw jiga. ");
INSERT INTO sor_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kal wála dɨma gaba lama dwãr̰ĩ di hane ɗɨm. Kal nare nə sɨn̰a dɨdə ka àlna mani nə dusɨm ùr ya cendi nə daa ba gɨ àl nɨm de. ");
INSERT INTO sor_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","ꞌyànin haye nə womnin gɨ wála wála. ");
INSERT INTO sor_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Kal dusɨm hɨlal àcn̰a nin gɨ nə àlɨ̀wnin di dɨwə ya ba nə kalnin gɨ dusɨrənin hɨlal nare àcn̰a day gɨ àl gandanin dɨwə ta de me ca. ");
INSERT INTO sor_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kal mani mɨn lamnanin bwananin àla gɨ àcn̰a lə bədə me kɨdɨnin daa Sidan ɨsədɨ lə. Dara dwãr̰ĩ me dwana me sumi gɨ ꞌwaga me i dɨma gɨ dɨrɨn̰ bɨr̰ɨn̰. Amen. ");
INSERT INTO sor_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Yarna, anə kalna dusɨrəng hɨlalna nare àcn̰a day dɨwə da, Abɨrang gɨ Mãr̰ĩ gaba dama daa di kaw, ha kala dusɨw hɨlala àcn̰a dan di dɨwə me ca. ");
INSERT INTO sor_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Me anə kalna dusɨrəng hɨlalna nare àcn̰a day dɨwə bədə da, Abɨrang gɨ Mãr̰ĩ di kaw, ha kala dusɨw hɨlala àcn̰a dan dɨwə bədə me ca.» ");
INSERT INTO sor_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«Mana gɨ anə unə asiyam da, àlna dɨrəng n̰agɨni ya nare nə gwale ꞌyol bɨdəgɨ lə me dusɨrəgɨ dɨ korgɨn̰ i jiga de bədə: Cendi àl sɨdəgɨ n̰agɨni dara kal nare pad ba yarnagɨ nɨm ba gɨ u i asiyam. Dwayna, nə wayang i gwale sɨw: Cendi ꞌyo ꞌywaga day di bam ɗɨm. ");
INSERT INTO sor_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Me ɨjɨm da, mana gɨ mə unə asiyam da, wiy dɨrəm bam me ɗa swani gaba biyə ꞌywala dɨmmə me. ");
INSERT INTO sor_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Kal gun mɨn kaw ꞌwacn̰ana dara ba mə u i asiyam bədə. Me kal Abam gɨ Mãr̰ĩ gɨ ilə mana gɨ budə lə di ꞌwacn̰ana an̰ju mɨn tenene, me an̰ji gaba yara mani nə budə lə ta di ha ꞌywagam gwayni dɨma an̰ju.» ");
INSERT INTO sor_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«Dajɨna mani nə ꞌywaa nə dodə sɨn̰a dɨdə ka bədə, dara dɨgɨn̰e me maru me nem myandagɨ i bam labaa, miidi nem ɓwalba kulə bɨw me nem mĩyəgɨ i bam me ca. ");
INSERT INTO sor_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Me dajɨna mani nə ꞌywaa nə daa Mãr̰ĩyə, dara i mana gɨ dɨgɨn̰e me maru me nem myandagɨ bam bədə me, miidi kaw, nem ɓwalba kulu bɨw mĩyəgɨ bam bədə me ca. ");
INSERT INTO sor_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Nə way yande dara mana gɨ mani dɨma nə ꞌywaa pad ilə ta di, dusɨm ha ꞌya lə dɨwə.» ");
INSERT INTO sor_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Dɨrɨn̰ da, i ya lamba dɨ idɨ ácn̰a gun sɨw ta de: Dɨrəm ina labiya da, i ya ba mə dam i mana gɨ ácn̰a lə de me ca. ");
INSERT INTO sor_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Me dɨrəm di yarna ladɨ bədə da, sɨm pad kaw, i mana gɨ dilɨmmə ya kulə gɨ lamba ácn̰ dalaw bam bədə ta de. Yande da, ácn̰a gɨ i sɨmmə ta di ácn̰ana bədə da, dilɨm dɨ i mana gɨ sɨmmə ta di i dilɨm dɨ ꞌyang ꞌyang.» ");
INSERT INTO sor_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«Gun mɨn nem àlagɨ́ dolgə sɨr giyə bədə. An̰ji ha ùrə gɨ mɨn nan̰ me ha gɨn̰ə gɨ mɨn bam, labaa ha yəə gɨ mɨn nan̰ me ha àla gɨ mɨn ichɨn̰ me ca. Anə nem àlaw Mãr̰ĩ giyə me gɨdɨ kwaya gɨnə gursɨ dɨra me ca bədə.» ");
INSERT INTO sor_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«I dara ta di me nə wayang da: Kalna nulbə gɨ sɨdəng dara haye gɨ anə ha wama bɨlə nɨm di ɗi, me barge gɨ anə ha hura sɨdəngə di ɗi me ca. Gun dama duwa gɨ dɨrəw bɨ̀ra sɨn̰a dɨdə ka da, ladni duwa ɗoy mani nə wama bam bədə ɓa? Me gun sɨw gɨ doni kaw, ladni duwa ɗoy barge gɨ hura bam me bədə ɓa? ");
INSERT INTO sor_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Yarna dirbi sɨn̰. Cendi gɨsɨ swagə bədə me, n̰il swagə bogɨ ɓecheyə bədə me kaw, Abɨrang gɨ Mãr̰ĩ gaba dama daa di ɨsɨgɨ ta bədə mo? Me ꞌyeni nə nare da, anə ɗoygɨ bam hən̰ Mãr̰ĩ dɨrəwə bədə mo? ");
INSERT INTO sor_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ɗang da, i wi dwar̰angə, dara nulbə duwa gɨ sɨw di, me chidɨ nɨm gɨ wála duwa gɨ dam nɨm sɨn̰a dɨdə daa pii hin̰e mo? ");
INSERT INTO sor_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Me gwale gɨnə barge da, i dara na me anə nulbɨ sɨdəng daraw mo? Yarna balawrang hoo duwa gɨ an̰ji huw sɨn̰. An̰ji àl giyə bədə me ku barge bədə me ca. ");
INSERT INTO sor_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Me nə wayang: Dole gɨ Salmõ gɨ mani duwa ꞌyarbar nan̰ ta kaw, dii mɨn hurə barge gɨ lade gɨ ya balawrang hoo duwa di de bədə. ");
INSERT INTO sor_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ay, ꞌyeni nare nə dusɨrəng dɨ kala Mãr̰ĩ dɨwə i ɓani nə gá! Chemde nə bam nə dam laba me, sanga gɨ ha bwagɨ dùwa lə kaw, Mãr̰ĩ hurnagɨ barge gɨ lade sɨdəgɨ lə da, ꞌyeni nə nare da, an̰ji ha hurang barge sɨdəngə bədə man man mo? ");
INSERT INTO sor_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Yande da, nulbɨnə sɨdəng bədə, me kalna waya gɨ “Də hárang wama i na mo? Də hárang chàa i na mo? Də hárang hura i na mo?” di ɗi. ");
INSERT INTO sor_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Mani nə ta di pad da, i nare woni ꞌwacn̰a Mãr̰ĩ gɨ ɓag bədə me kan̰jɨgɨ dɨban bwaa gɨ gwayni cendi. Me ꞌyeni da, Abɨrang gɨ Mãr̰ĩ gaba dama daa di ꞌwocn̰ mani pad nə jalang ta di com. ");
INSERT INTO sor_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Yande da, kan̰jɨna dara kal Mãr̰ĩ lamna dwãr̰ĩ duwa dɨdəngə me kan̰jɨna àla gɨ mani nə tɨba Mãr̰ĩ dɨrəwə pii do me, mani nə ɗang di da, Mãr̰ĩ ha ꞌyàng gandagɨ lə diiyə sɨn̰. ");
INSERT INTO sor_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Yande da, nulbɨnə sɨdəng dara wála gɨ sanga bədə. Dara wála gɨ sanga da, i gɨ nulbə duwa gɨ sii lə jiga sɨn̰. Wála bá bá i gɨ wamani duwa.» ");
INSERT INTO sor_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«Kalna yara gɨ kwandang àcn̰a day ɗi. Anə yarna kwandang àcn̰a day bədə da, Mãr̰ĩ kaw, ha yara àcn̰a dan bədə me ca. ");
INSERT INTO sor_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Dara Mãr̰ĩ ha yara àcn̰a dan ya anə banə yər gɨ kwandang àcn̰a day di de me ca. An̰ji ha ɨrməng àcn̰a dan di ya anə banə ɨrmɨgɨ gɨ kwandang àcn̰a day di de dige dige. ");
INSERT INTO sor_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Mə yər sogɨlə gɨ hin̰e ɨndər jam dudɨwə me, ɨr̰ɨ cor mə yər dɨma habda gɨ geche gɨ gɨr̰angar dudɨmmə ta di bədə, dana mo? ");
INSERT INTO sor_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Cor man me mə wayɨw chendɨm ba da: “Kal nə um sogɨlə bam dudɨmmə” me, ɨr̰ɨ habda gɨ geche gɨr̰angar ilə dudɨmmə mo? ");
INSERT INTO sor_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ɨjɨm gɨ gwale ꞌyol bɨmmə, me dusɨm dɨ korgɨn̰ i jiga gá! U habda gɨ geche gɨ gɨr̰angar dudɨmmə ta di bam kal mə yər mana ladɨ do me, mə uw chendɨm duwa di bam dudɨwə sɨn̰. ");
INSERT INTO sor_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Mani nənə Mãr̰ĩ duwa da, ꞌyànagɨ́ nare nə i ya gɨrade de bədə, dara cendi ha cwara dɨdəngə yɨdɨbənge. Diyè dan dɨ kili dɨra wom nan̰ da, bwanadɨ gochəng gɨdadɨ lə bədə, dara tandi ha ɗɨrbədɨ i dodə.» ");
INSERT INTO sor_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«Amsɨnaw Mãr̰ĩ, me an̰ji ha ꞌyàng. Kan̰jɨna le, me anə ha ꞌywaa. Ajɨnaw Mãr̰ĩ bii me, bii ha tɨn̰arang bam. ");
INSERT INTO sor_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Dara gun gɨ amsɨna mani da, Mãr̰ĩ ha ꞌyàwe. Gun gɨ kan̰jɨna mani kaw, ha ꞌywaa le me, gun gɨ gwabɨna bii kaw, gɨ ha tɨn̰əwe me ca. ");
INSERT INTO sor_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Dwar̰angə da, gun gɨ gorndɨw amsɨnaw mapa da, an̰ji ha ꞌwoo gɨla ꞌyàw ɨsəwə mo? ");
INSERT INTO sor_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ɗang da, ùrnəw i dòche da, ha yəə kwalà ꞌyàw ɨsəwə mo? ");
INSERT INTO sor_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","ꞌYeni nə dusɨrəng àcn̰ ta kaw, anə ꞌwocn̰ ꞌyàgɨ́ gɨ dɨndɨrang mani nə lade. Inam yande da, Abɨrang gɨ Mãr̰ĩ gaba dama daa di ha ꞌyàgɨ́ dɨndaw mani nə lade nə cendi ùrɨw di bədə man man mo? ");
INSERT INTO sor_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Dwayna, maktubu dɨ bii gɨ ꞌwoo gɨnə Moyis duwa me woni cɨmə Mãr̰ĩ bɨw me gɨlə day i ta: Mani pad nə anə ùr nare ba àlnang gandagɨ da, ꞌyeni kaw, àlnagɨ nare di yande me ca.» ");
INSERT INTO sor_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","«Gandɨna hana gɨ ciri bɨdɨ dɨ ɓaniyə, dara tandi ha i gandang mana gɨ bɨlə lə. Bɨrmə gɨ ha ciri bɨdɨ dɨ ɓaniyə da, hára duwa womme, me i nare nə ɓani hɨrin̰ja me u bɨrmə gɨ ta di hárɨw cendi. Me bɨrmə gɨ ɓɨle bung kaw, ilə me ca. Bɨrmə gɨ ɓɨle gɨ ta di ha i ciri bɨdə dɨ ɓɨleyə, me hára duwa wom bədə. Nare nə gɨr̰e nan̰ me hárɨw me ha i gandagɨ dùwa dɨ budə dɨra gɨ bam ilə bədə bɨr̰ɨn̰yə.» ");
INSERT INTO sor_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Àsɨna angal dan dara woni cwaa sɨdəgɨ ba gɨ i woni cɨmə Mãr̰ĩ bɨw. Cendi hára ꞌywang me ha hɨlal jwam co sɨdəgɨ ya dɨmən̰je de, me dusɨrəgɨ dɨ korgɨn̰ i ya mĩ de. ");
INSERT INTO sor_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Anə ha ꞌwacn̰agɨ i mana gɨ mani day nə àla lə ya anə banə ꞌwocn̰ gɨ habda mana gɨ yàa duwa lə ta de. Gɨ ar mongo yàa duwa mana gɨ jirbə dɨwə bədə, me dwaga yàa dɨra kaw, gɨ ar mana gɨ chele dɨdə bədə me ca. ");
INSERT INTO sor_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","I ta di me habda gɨ lade da, yə̀ i yàa gɨ lade, me habda gɨ àcn̰e da, yə̀ i yàa gɨ àcn̰e me ca. ");
INSERT INTO sor_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Habda gɨ lade da, nem yàa yàa gɨ àcn̰e bədə, me habda gɨ àcn̰e kaw, nem yàa yàa gɨ lade bədə me ca. ");
INSERT INTO sor_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Habde pad nə yàna yàa gɨ lade bədə da, gɨ ha sabagɨ bam led led bwagɨ dùwa lə. ");
INSERT INTO sor_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","I ta di me nə wayang nɨm, woni cwaa sɨdəgɨ ba gɨ i woni cɨmə Mãr̰ĩ bɨw da, anə ha ꞌwacn̰agɨ i mana gɨ mani day nə àla lə.» ");
INSERT INTO sor_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«Nare pad woni ꞌwagan ba “Aba ciri nin, Aba ciri nin” da, ha ganda ciri dɨ daa lə di bədə, me i nare woni àla mani nə Aban gɨ Mãr̰ĩ gaba dama daa dusɨw ùrgɨ di me ha ganda lə cendi. ");
INSERT INTO sor_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Wála gɨ Mãr̰ĩ dara àla sariya di da, nare nan̰ ha wayan ba da: “Aba ciri nin, aba ciri nin, i gɨ sumɨm ɨjɨm me nə cɨmənin nɨm gɨ Mãr̰ĩ bɨw me, nə ꞌywaranin nɨm gɨ dúndi dɨ àcn̰e bam nare sɨdəgɨ lə me, nə àlanin nɨm gɨ mani nə dan̰a nan̰ me ta dimm mə ꞌwocn̰ɨnin bədə mo?” ");
INSERT INTO sor_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Mwom da, nə ha wayagɨ daa pɨden̰yə: “Nə ꞌwacn̰ang bədə bɨr̰ɨn̰. Hana bam hən̰! Anə i woni àla mani nə bor gɨ bɨrmə gɨnə Mãr̰ĩ duwa bədə.”» ");
INSERT INTO sor_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«Caga da, gun gɨ dwayna gwale ni gɨ nə wayɨw di me unəw àlna gɨ giyə da, wun i ya gun gaba dɨrɨn̰ naa gɨ pol kulu duwa gɨndɨw dodə cog ꞌyo sɨn̰a dɨ woye do me aw nɨm sɨn̰ ta de. ");
INSERT INTO sor_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Mana gɨ Mãr̰ĩ ꞌwō nan̰ me kuray biyara ɗɨbɨ gɨndɨwə me gale gɨ geche awɨr kulu di kaw, kulu di jur bam bədə, dara kulu di gɨndɨw poləl i dodə me awar i sɨn̰a dɨ woye dɨdə. ");
INSERT INTO sor_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Me gun gɨ we we gɨ dwayna gwale ni gɨ nə wayɨw di me unəw àlna gɨ giyə bədə da, an̰ji wun i ya gun gɨ məng gɨ àsɨ kulu duwa gɨndɨw daa sɨn̰a dɨ woye bədə dɨdə ta de. ");
INSERT INTO sor_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Mana gɨ Mãr̰ĩ ꞌwō nan̰ me kuray bɨlan̰ daa me gale gɨ geche awɨr kulu di da, kulu di jur bam. Me jurə duwa di i gɨ dɨrɨn̰ bɨr̰ɨn̰.» ");
INSERT INTO sor_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Mana gɨ Jesu way gwale gɨ ta di ꞌyen̰ bam mwom da, gɨlə duwa di ꞌyàgɨ́ nare nə gɨr̰e di ɨrmə nan̰e. ");
INSERT INTO sor_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Dara gɨlə duwa gɨ mani di i gɨ dwana, wundər gɨ gɨlə gɨnə nare woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa di bədə. ");
INSERT INTO sor_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Mana gɨ Jesu way gwale duwa di ꞌyen̰ bam pad da, an̰ji chə́ə dodə kur̰a dɨdə me nare nə gɨr̰e nan̰ pam tarɨw. ");
INSERT INTO sor_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Mwom da, gun mɨn gɨ cagɨm àlɨw dɨmə hára piy gubɨrəw dodə Jesu dɨrəwə me ꞌwogɨw wayɨw da: «Aba ciri ni, dɨrəm ùrnə da, mə nem sɨr̰ɨn sɨn bam cwan gɨdən gun gɨ lade bi.» ");
INSERT INTO sor_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ɨr̰ɨ Jesu yəə ɨsəw ɓɨl aba cagɨm di sɨw me wayɨw da: «Nə ùre, kal sɨm di sɨr̰ɨnə bam.» Mana gɨ ta lə di dog, cagɨm di sɨr̰ɨ bam abe di sɨwə. ");
INSERT INTO sor_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ɨr̰ɨ Jesu wayɨw da: «Doy ladɨ! Wayɨw gun mɨn kaw daa bədə! Me ha gɨləw aba bwasa Mãr̰ĩ sɨm me mə ha àla sarga dɨ bii gɨ ꞌwoo gɨnə Moyis duwa ɨrɨm dara gwale gɨnə cagɨm di. Ta di me, nare pad ha ꞌwacn̰a dara cagɨm dɨma di ba sɨr̰ɨ i bam sɨmmə ɗɨm, me ba mə cor gɨdɨ i gun gɨ lade Mãr̰ĩ dɨrəwə di sɨn̰ me ca.» ");
INSERT INTO sor_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Targɨn̰ ɗang, Jesu ba a gɨr ciri dɨ Kapernommə da, asɨngar nə Rom geche day mɨn hára sɨwə ib me amsɨw ");
INSERT INTO sor_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","me wayɨw ba da: «Aba ciri ni, aba àlan giyə ni ilə dodə mwom mana gɨ ulay. An̰ji piyər r̰egɨdu me gɨl dɨrɨn̰ nan̰e.» ");
INSERT INTO sor_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Me Jesu wayɨw da: «Ladɨ, nə ha hára swaw i daa.» ");
INSERT INTO sor_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Me asɨngar geche day di cow lə diiyə wayɨw ba da: «Aba ciri ni, nə nem gun gɨ mə ha hára dɨmə kɨrə niyə bá bədə. Way gwale mɨn gɨ bɨm mɨra me, kwaya ni di ha swaa daa. ");
INSERT INTO sor_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nə way yande dara ɨndi kaw, gechide ni ilə dɨnnə, me ɨndi, nə i geche gɨnə asɨngar day me ca. Nə waynaw gɨ mɨn ba hana da, an̰ji ha le. Me nə waynaw gɨ mɨn ɗang ba hane da, an̰ji hára le me ca. Me nə waynaw kwaya ni ba àlna mani nə ya ta de kaw, an̰ji àlgɨ le.» ");
INSERT INTO sor_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Mana gɨ Jesu ba a doy gwale di yande mwom da, sɨw ꞌyolɨw gwale duwa gɨ waya di dɨwə me, an̰ji waygɨ woni bwaw di ba da: «Dwayna, nə wayang i gwale sɨw: Mana gɨ nare nə Israyel dwar̰agɨ lə da, gun gaba kala dusɨw dɨnnə ya abe gɨ Rom gɨ ta di de da, dii mɨn kaw, nə wor ꞌywaa sɨn̰. ");
INSERT INTO sor_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","12","Nare nə Israyel nə ɓag dee ha dama ciri dɨ daa lə di, gɨ ha ꞌywaragɨ bam iche bwagɨ mana gɨ dilɨm dɨ yə̄ gɨ Mãr̰ĩyə di. Mana gɨ ta di, i mana gaba nulə gura me, yɨdɨbə sande lə me ca. Nə wayang: Nare nan̰ nə gɨndəgɨ i nare nə Israyel bədə me, ɨr̰ɨ cendi ha swaa tulɨn̰ dɨ jomniyə me, dɨ turgɨ lə me, ha dama wama bɨwə gɨ mwágɨrandɨ nə gechide nə Abɨraham me, Isak me, Jakob me, alə daa ciri dɨnə Mãr̰ĩyə di.» ");
INSERT INTO sor_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Mwom da, Jesu wayɨw asɨngar geche day di ba da: «Cor ha ulay dɨma lə. Mə kal dusɨm dɨnnə dara ba nə ha swam aba àlam giyə daa, me ꞌyang, kal mani di àlalnam ya ba mə kal gɨ dusɨm lə diiyə ta de.» Mana gɨ ta lə dog da, aba àlaw geche gɨnə asɨngar day giyə di ꞌyo labiya. ");
INSERT INTO sor_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Targɨn̰ ɗang da, Jesu ha mana gɨ kɨrə nə Piyerrə, me an̰ji ꞌyo Piyer dyaməw idɨ i dodə me, sɨdɨ ur̰ɨ le. ");
INSERT INTO sor_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Me an̰ji yɨ ɨsədɨ me, sɨdɨ gɨ ur̰e di chɨ́ hɨlal dodə. Ɨr̰ɨ tandi so daa me àlɨw mɨjəni. ");
INSERT INTO sor_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Gɨ turgɨ bɨdɨ, gɨ háraw gɨ Jesu nare nan̰ nə dúndi dɨ àcn̰e jibagɨ, me Jesu way gwale gɨ bɨw mɨra me ꞌyor nɨm gɨ dúndi dɨ àcn̰e di bam nare sɨdəgɨ lə me, nare woni mwom kaw, an̰ji sogɨ daa pad me ca. ");
INSERT INTO sor_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ta di me i mani nə tanga aba cɨmə Mãr̰ĩ bɨw gɨ Esayi waya gwale day di me yala àlal kɨrab. An̰ji waya ba da: «An̰ji kɨdəndɨ daa mani woni cwandɨ nare tuləgɨ di ɨsɨragɨ lə, me piyəndɨ mwom ɨnda di bam sɨdəndɨ lə me ca.» ");
INSERT INTO sor_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Wála mɨn, Jesu yər nare nə gɨr̰e liwɨw daa mwom da, an̰ji waygɨ woni gɨrsə gwale duwa di ba da: «Cilangɨnandɨ kuray gɨ ɓɨle, hanandɨ dugdɨw dɨ alə ta lə!» ");
INSERT INTO sor_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Mana gɨ ta lə di, aba gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa gɨ mɨn chidɨ Jesu sɨwə me wayɨw ba da: «Aba gɨlənin mani, mana gɨ we we gɨ mə hana lə kaw, nə ha pama i tarɨm.» ");
INSERT INTO sor_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesu cow lə diiyə ba da: «Babasa kaw, gubdɨr̰i day gaba ꞌya ilə me, dirbi nə daa kaw, ciri day ilə me ca. Ɗɨm da, ɨndi gɨ Gun gorndɨw da, mana ni gɨ sɨn gaba hura dɨn ilə bədə.» ");
INSERT INTO sor_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Aba gɨrsə gwale gɨnə Jesu duwa gɨ mɨn ɗang wayɨw Jesu ba da: «Aba ciri ni, kalɨn bɨrmə nə ha mõõ aban bam do.» ");
INSERT INTO sor_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ɨr̰ɨ Jesu cow lə diiyə gɨ gwale gɨ diri ba da: «Hare, pam tarɨn me, kal nare nə mare munə made day cendi.» ");
INSERT INTO sor_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ɨr̰ɨ, Jesu nagɨ dam bɨrwa lə me, woni gɨrsə gwale duwa kaw ilə bwawə me ca. ");
INSERT INTO sor_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Mana gɨ ba gɨ gɨr kuray gɨ ɓɨle gɨ Galile don duwa lə mwom da, mana gɨ ta lə dog, gale gɨ geche biyara hára ꞌyogɨ me, nimi wujabar bor bɨrwa dalawə àl dara ꞌwana daa, me Jesu da, i duwa nuni. ");
INSERT INTO sor_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Mwom da, woni gɨrsə gwale duwa chidɨbə sɨwə ib me, nuw daa me wayɨw da: «Aba ciri nin, də ilə marangə; bɨlnin daa!» ");
INSERT INTO sor_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Me Jesu waygɨ ba da: «Ay, ꞌyeni nare nə dusɨrəng dɨ kala dɨnnə i ɓani nə gá! Anə lán̰ yande dana mo?» Mwom da, Jesu so daa me ɨr̰ɨn̰ kuray me gale me, mana cor hɨlal kajaj. ");
INSERT INTO sor_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Me woni gɨrsə gwale duwa di yɨbdɨ dɨdəgɨ me way ba da: «Gun gɨ ta di i gɨ man me, gale day gɨ nimi nə kurayyə kaw, doy gwale bɨwə mo?» ");
INSERT INTO sor_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Mana gɨ Jesu ba a ha gɨr kuray gɨ ɓɨle gɨ Galile dugdɨw dɨ alə ta lə mana gɨ sɨn̰a dɨ nare nə ciri dɨ Gadara dayyə mwom da, abje sɨr nə dúndi dɨ àcn̰e widɨbəgɨ swagə mana gɨ munɨniyə me hára saw dɨrəw daa. Cendi, gwale day wom nan̰e. Gun mɨn kaw nem hára gɨ bɨrmə gɨ ta di bədə. ");
INSERT INTO sor_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Caga da, cendi sojɨ mar̰ɨjagɨ daa nan̰ way ba da: «Ay! Mãr̰ĩ gorndɨw, mə ùr i na sɨdəninnə mo? Mə hára àlnin wamani wála gɨ Mãr̰ĩ ɨrmɨnin gandɨw di dɨrəwə pii mo?» ");
INSERT INTO sor_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Mana gɨ ta lə di, gochəng dɨ gɨr̰e ɗɨbɨ ilə wama lə bam tulɨn̰yə hin̰e yande. ");
INSERT INTO sor_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Mwom da, dúndi dɨ àcn̰e di mɨrgɨw Jesu me wayɨw ba da: «Mə ꞌywarnanin bam da, giynin mana gɨ gochəng dɨ gɨr̰e dɨ ta di sɨdə.» ");
INSERT INTO sor_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesu waydɨ dúndi dɨ àcn̰e di: «Dɨmnə, hana.» Mwom da, dúndi dɨ àcn̰e di dɨm bam abje nə sɨr di sɨdəgɨ lə me gandɨ ha bwara mana gɨ gochəng di sɨdə. Mana gɨ ta lə di dog, gochəng ɓɨr̰ɨn̰ daa kur̰a dɨdə, wada bor kurayyə, chə̀ nimi marbɨ bam. ");
INSERT INTO sor_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Mana gɨ nare woni gama gochəng di yər yande mwom da, wagɨ kaláng gɨrgɨ mana gɨ ciriyə me, biygɨ nare mani pad nə gɨra àlal di me nare woni widɨbə nə sɨr di gwale day me ca. ");
INSERT INTO sor_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Mana gɨ ta lə di da, nare pad nə ciri dɨ gecheyə di gandɨgɨ ha ꞌywaa Jesu, me mana gɨ cendi yərɨw mwom da, mɨrgɨw an̰ju ba hana kalnagɨ sɨn̰a day ɗi. ");
INSERT INTO sor_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jesu day gɨ nə woni gɨrsə gwale duwa nagɨgɨ dam bɨrwa dalawə me cilangɨgɨ kuray gɨ ɓɨle gɨ Galile dara cwara hára ulay dayyə mana gɨ ciri dɨ Kapernommə. ");
INSERT INTO sor_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Mwom da, nare ꞌwów Jesu abe gɨ r̰egɨdu gɨ jãr̰ĩ gɨra álɨw dɨrəwə. Jesu di yər nare nə ta di kala day gɨ dusɨrəgɨ dɨwə di mwom da, an̰ji wayɨw abe gɨ r̰egɨdu di ba da: «Jan maché, yɨ sɨm woy. Àcn̰a dɨma biyər bam ɗɨm.» ");
INSERT INTO sor_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Mwom da, woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa nə yab wajɨ gwale dusɨrəgɨ lə ba da: «Gun gɨ ta di gagɨ sɨw gɨ Mãr̰ĩ àlɨw nɨm məng!» ");
INSERT INTO sor_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Me Jesu ꞌwocn̰ ɨrmə day di com me waygɨ da: «Dara na me anə ɨrɨm ɨrmə gɨ àcn̰e dusɨrəngə yande mo? ");
INSERT INTO sor_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Wayaw gɨ gun “Àcn̰a dɨma biyər bam ɗɨm”, labaa “So daa, me ha” da, i gwale gɨ we me wom nan̰ mo? ");
INSERT INTO sor_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ladɨ, nə ùr dara anə ba ꞌwacn̰ana dara ɨndi gɨ Gun gorndɨw di, ba nə i gɨ dwana dɨ idɨ piyəgɨ nare àcn̰a day bam mana gɨ sɨn̰a dɨdə ka. Yande da, nə ha àla mani nə anə yərgɨ ba wom nan̰e di.» Me an̰ji wayɨw abe gɨ r̰egɨdu di ba da: «So daa, u jãr̰ĩ dɨma di daa me, mə cor ha ulay dɨma lə ɗɨm.» ");
INSERT INTO sor_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Mana gɨ ta lə di dog, abe gɨ r̰egɨdu di ꞌyo labiya me so daa, ha ulay duwa lə. ");
INSERT INTO sor_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Mana gɨ nare nə gɨr̰e di ba gɨ yər yande da, lán̰a àlgɨ, me cendi ꞌwogɨ Mãr̰ĩ sumɨw dara an̰ji ꞌyàgɨ́ nare dwana dɨ ya ta de di. ");
INSERT INTO sor_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Targɨn̰ ɗang da, Jesu so daa, ilə hára lə me yər abe mɨn gɨ gɨ ꞌwogɨw Matiyə dam lə mana gaba salaw dole gɨ geche gɨ Rom maniyə dara sala gɨ mani. Jesu wayɨw da: «Sway daa, hare, pam tarɨn.» Me Matiyə di so daa me pam tarɨw. ");
INSERT INTO sor_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ɗang da, Jesu day gɨ nə woni gɨrsə gwale duwa hargɨ dara wama mani kɨrə nə Matiyə lə. Mana gɨ cendi dam ilə wama maniyə da, nare nan̰ woni salaw dole gɨ geche gɨ Rom mani me, nə àcn̰e nə ɗang me, dam ilə wama lə gandagɨ me ca. ");
INSERT INTO sor_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mana gɨ nare nə gɨ ꞌwogɨgɨ Parise ba gɨ yər yande mwom da, cendi waygɨ woni gɨrsə gwale gɨnə Jesu duwa di ba da: «Aba gɨləng mani di wom mani gɨ woni salaw dole gɨ geche gɨ Rom mani me gɨ nare nə àcn̰e nə ɗang mɨn me, dana mo?» ");
INSERT INTO sor_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Me Jesu doy gwale day di me waygɨ nare nə Parise di ba da: «Nare nə sɨdəgɨ i labiya da, cendi kan̰jɨ dogtər bədə. I nare nə sɨdəgɨ i mwom me kan̰jɨ dogtər cendi. ");
INSERT INTO sor_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Hana kan̰jɨna gwale gɨndɨw gɨ Mãr̰ĩ wayaw ba: “Nə ùr anə banə yarna kwandang n̰agɨni day. Yara gɨ kwandang n̰agɨni day da, ladɨ ɗoy àlán gɨ sarga bam.”» Jesu ajɨmar ilə wayagɨ lə: «Dwayna, hára ni gɨ sɨn̰a dɨdə ka da, i dara ꞌwaga gɨ nare nə ꞌwocn̰ dusɨrəgɨ lə ba gɨ i nare nə àcn̰e. Me nare nə ɨrɨm dusɨrəgɨ lə ba gɨ i nə tɨba Mãr̰ĩ dɨrəwə da, nə hára i dara ꞌwagagɨ cendi bədə.» ");
INSERT INTO sor_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Mana gɨ ta lə da, woni gɨrsə gwale gɨnə Jã Batis duwa hára ꞌyo Jesu me wayɨw da: «Nenin me nare nə Parise me nə unin asiyam daa daa, me woni gɨrsə gwale dɨma da, u day asiyam di bədə, dana mo?» ");
INSERT INTO sor_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ɨr̰ɨ Jesu cogɨ lə diiyə gɨ gwale gɨ diri ba da: «I man me aba àla dyamdɨrani kwandaw moso ha dama àla n̰agɨni mana gɨ an̰ji kaw ilə gandagɨ me mo? Me wála gɨ ɗang mɨn hára lə. Wála gɨ ta di, gɨ ha biyə aba àla dyamdɨrani di bam dwar̰agɨ lə do me, cendi ha ꞌwoo asiyam di sɨn̰.» ");
INSERT INTO sor_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Jesu way gwale gɨ diri ɗang bi ba da: «Gun mɨn ha ꞌwoo barge gɨ dɨrway bɨw àlaw nɨm gɨ barge gɨ mar̰ɨnge mabɨla bədə, dara barge gɨ dɨrway bɨw di ha chawa gɨ mar̰ɨnge di bam. Me chawara gɨ ta di ha ɗwaya gɨ pii bam bi. ");
INSERT INTO sor_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Gun mɨn kaw, ha bwaa gani gɨ dɨrway gɨ ilə sugdɨ lə mana gɨ ɗɨjili gɨ mar̰ɨngeyə bədə, dara ɗɨjili di ha jara bam, me gani di ha chawa bwara bam, me ɗɨjili kaw, ha myandara bam me ca. Me gɨ bwana gani gɨ sugde i ɗɨjili gɨ dɨrwayyə an̰ju da, ca dayyə ca igɨ gɨ ladni sɨn̰.» ");
INSERT INTO sor_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Mana gɨ Jesu waygɨ gwale di yande mwom da, geche mɨn gɨnə nare nə Juwib day hára piy gubɨrəw dodə Jesu dɨrəwə me wayɨw ba da: «Durmən mare caga ka, hare bo ɨsam dɨdə, me tandi ha cwara bɨlə le.» ");
INSERT INTO sor_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Mwom da, Jesu so daa me, ilə pama tarɨw day gɨ nə woni gɨrsə gwale duwa. ");
INSERT INTO sor_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Ɨr̰ɨ, mana gɨ Jesu ilə hára lə da, deme mɨn dɨ gɨl dɨrɨn̰ dara bare ha sɨdə àl aliya mwaj dii sɨr ilə. Tandi way dusɨdɨ lə ba da: «Nə ɓɨlnə i barge duwa mɨra kaw, nə ha ꞌywaa labiya», me tandi kwanga hára Jesu tarɨwə me ɓɨl chire gɨ barge duwa bɨwə. ");
INSERT INTO sor_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesu co dɨrəw yərdɨ me waydɨ da: «Yɨ sii we, chidɨn! Də kal dusi dɨnnə da, də ꞌyo labiya ɗɨm.» Me mana gɨ ta lə di dog, tandi ꞌyo labiya. ");
INSERT INTO sor_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jesu hára gɨra kɨrə nə Jayrus lə di mwom da, nare nə gɨr̰e ilə hurba delbe nə made me hɨraja lə nan̰ me ca. ");
INSERT INTO sor_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jesu yər yande me waygɨ ba da: «Dɨmnə iche! Dwe dɨ more di mare bədə, me i i nuni.» Ɨr̰ɨ nare di àlɨw məng. ");
INSERT INTO sor_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Mana gɨ gɨ ꞌyor nare nə gɨr̰e di iche da, Jesu gandɨ ha kulu gɨ dwe dɨ more ilə di, an̰ji yɨ ɨsədɨ daa me bɨdɨ a daa me tandi so daa. ");
INSERT INTO sor_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ɨr̰ɨ gɨ way nõ duwa dɨ ta di mana gɨ wama gɨ ta lə di pad. ");
INSERT INTO sor_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Mana gɨ Jesu ba a so kal mana gɨ ta di bam dara hára mwom da, nare nə dɨrəgɨ bu sɨr ilə pama tarɨw me sojɨ ꞌwogɨw ba da: «Ɨjɨm, dole gɨ Dabid mwàw, yər n̰agɨni nin ɗe!» ");
INSERT INTO sor_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Mana gɨ Jesu ba a gɨr ulay mwom da, nare nə dɨrəgɨ bu di chidɨbə sɨwə, me an̰ji ùrgɨ ba da: «Anə kal dusɨrəng dɨnnə dara ba nə nem ꞌyàng labiya di le mo?» Cendi cow lə diiyə ba da: «Əw, aba ciri nin.» ");
INSERT INTO sor_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Mwom da, Jesu ɓɨlbɨ dɨrəgɨ me way da: «Kal mani di àlalna gandang ya anə banə kal nɨm gɨ dusɨrəng dɨnnə ta de me ca.» ");
INSERT INTO sor_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Mana gɨ ta lə dog, dɨrəgɨ di tɨn̰bər bam me cendi yərbɨ mana ladɨ pɨrang pɨrang. Me Jesu yəgdɨ sumdəgɨ me waygɨ ba da: «Mani nə àlal gandang ta di, waynaw gun mɨn daa bədə ɗe!» ");
INSERT INTO sor_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ɨr̰ɨ nare nə ta di doy bədə me cor gandɨ ha wayagɨ nare mani nə Jesu àl gandagɨ di daa mana gɨ wama gɨ ta lə di pad. ");
INSERT INTO sor_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Mana gɨ nare nə dɨrəgɨ bu sogɨ daa ilə hára lə da, gɨ háraw gɨ Jesu abe gɨ dúndi dɨ àcn̰e ɨmɨw waya gwale bam. ");
INSERT INTO sor_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesu ꞌyorɨw abe gɨ ta di dúndi dɨ àcn̰e di bam sɨwə me abe di so ilə waya gwaleyə. Mani nə ta di ꞌyàgɨ́ nare nə gɨr̰e ɨrmə me wajɨ gwale bulə dayyə ba da: «Mani nə ya ta de da, nə yərgɨnin mana gɨ sɨn̰a dɨ Israyel lə dii mɨn bədə sɨn̰.» ");
INSERT INTO sor_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Me nare nə gɨ ꞌwogɨgɨ Parise wajɨ ba da: «I dúndi dɨ àcn̰e geche day me ꞌyàw abe gɨ ta di dwana dɨ idɨ ꞌywara gɨ dúndi dɨ àcn̰e bam tandi.» ");
INSERT INTO sor_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesu kɨdər ciri dɨ gechideyə me dɨ dineyə me pad. An̰ji gɨlgɨ nare mani mana gɨ kululi day woni amsa Mãr̰ĩyə me, waygɨ Nõ dɨ lade dɨ Mãr̰ĩ lam gɨ dwãr̰ĩ duwa me, an̰ji so nare daa mana gɨ mwom day gɨ dɨrəw jiga jiga lə pad me wamani day gɨ dɨrəw jiga jiga gɨ cogɨ nare tuləgɨ di daa pad me ca. ");
INSERT INTO sor_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Mana gɨ Jesu yər nare nə gɨr̰e nan̰ di da, dɨrəw ꞌyəngɨw dɨdəgɨ lə nan̰e, dara cendi, ɨrmə ꞌyogɨ nan̰e, me ꞌwocn̰ mani mɨn woni àla bədə me ca. Nare nə ta di wun ya dɨmən̰je nə aba gamagɨ ilə bədə ta de. ");
INSERT INTO sor_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Mwom da, Jesu waygɨ woni gɨrsə gwale duwa ba da: «Swagə woni ùrə n̰ilə ilə nan̰e, ɗɨm da, woni n̰ilə swagə di gɨr̰ɨ nan̰ bədə. ");
INSERT INTO sor_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Yande da, amsɨna Mãr̰ĩ gɨ i aba swagə di dara kal a kɨjɨne nare woni n̰ilə swagə duwa nə ɗang lə bi.» ");
INSERT INTO sor_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Targɨn̰ ɗang da, Jesu ꞌwogɨ woni gɨrsə gwale duwa nə mwaj dii sɨr di sɨwə. An̰ji ꞌyàgɨ́ dwana dɨ idɨ ꞌywara gɨ dúndi dɨ àcn̰e bam nare sɨdəgɨ lə me, swaa gɨ nare daa mwom day gɨ dɨrəw jiga jiga lə me wamani day gɨ dɨrəw jiga jiga gɨ cogɨ nare tuləgɨ lə me ca. ");
INSERT INTO sor_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Woni gɨrsə gwale gɨnə Jesu duwa nə ta di, an̰ji ꞌwogɨgɨ paja duwa me ca.Paja duwa nə mwaj dii sɨr nə ta di sumdəgɨ me i ta: Dɨrɨn̰ nə piiyə da, i Simõ gɨ gɨ ꞌwogɨw Piyer me chendɨw gɨ Andɨre me, Jak day gɨ chendɨw gɨ Jã nə i Jebede dɨndaw me, ");
INSERT INTO sor_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilip me Bartelemi me, Toma me Matiyə gɨ i aba salaw dole gɨ geche gɨRom mani me, Jak gɨ i Alpe gorndɨw me Tade me, ");
INSERT INTO sor_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simõ gɨ i gun gɨ day gɨ nə kwandaw nə ùr nare nə Juwib ba damna gɨ dɨdəgɨ day me, Judas Iskariyot gaba ꞌyàa Jesu woni mar̰ande duwa ɨsɨragɨ lə di me ca. ");
INSERT INTO sor_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","I nare nə mwaj dii sɨr nə ta di me Jesu kɨjɨgɨ mana gɨ ciriyə ciriyə di. An̰ji waygɨ mani nə cendi ba àlna bá bá me ꞌyàgɨ́ gɨsəni me ca. An̰ji waygɨ ba da: «Nare nə gɨndəgɨ i Juwib bədə da, hana ciri dayyə bədə, me hana ciri dɨ Samariyə bədə me ca. ");
INSERT INTO sor_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Me hana nare nə Israyel sɨdəgɨ lə cendi. Cendi i ya dɨmən̰je nə nole de. ");
INSERT INTO sor_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Mana gɨ we we gɨ anə hana lə da, àsɨnagɨ nare berni waynagɨ wála gɨ Mãr̰ĩ ha lama gɨ dwãr̰ĩ di, ba yala i ib ɗɨm. ");
INSERT INTO sor_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Swana nare nə mwom daa me, swana nare nə mare daa me, nare woni cagɨm kaw, sɨr̰ɨbɨnəgɨ cagɨm day di bam sɨdəgɨ lə me, ꞌywarnagɨ nare dúndi dɨ àcn̰e bam sɨdəgɨ lə me ca. Nə ꞌyàng dwana di pəgɨn̰ da, ꞌyeni kaw, ꞌyànagɨ nare pəgɨn̰ me ca. ");
INSERT INTO sor_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Anə dara hára da, unə jindar ɨsɨrangə bədə me, gursɨ bədə me, chile dɨ ɓani ɓani kaw, bwanadɨ bagɨra lə bədə me ca. ");
INSERT INTO sor_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Magɨla dan gaba hára mɨjəniyə kaw, unə ɨsɨrangə bədə me ca. Hurbɨna barge mɨn mɨn mɨra sɨdəngə me, layna gɨ ɗang bədə. Layna gɨbande bədə me, unə cilang ɨsɨrangə bədə me ca, dara aba àla giyə da, ɓag kaw, an̰ji ꞌyo wama duwa le. ");
INSERT INTO sor_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Mana gɨ anə gandɨna hana mana gɨ ciri dɨ gecheyə labaa, dɨ dweyə bá bá da, kan̰jɨna gun gɨ ùr dara yə̀ng mana gɨ sɨwə do me anə ha dama gandɨw sɨn̰. Me damna mana gɨ gun gɨ ta di kɨrə duwa lə jang bɨraa swaa dan gaba hára ciri dɨ ɗangə bá. ");
INSERT INTO sor_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Anə dara dɨmə nare kɨrə dayyə da, àlnagɨ nare nə kɨrə ta di labiya waynagɨ da: “Kal hɨlala jwam damna gandang!” ");
INSERT INTO sor_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nare nə ciri dwar̰ɨ lə di ùrnə ba gɨ yɨnəng sɨdəgɨ lə da, kal labiya dan di àlna giyə ciri day di dwar̰ɨ lə. Me nare di gɨn̰ɨnə yə̀ng sɨdəgɨ lə bam da, kal labiya dan di àlna giyə ciri day dwar̰ɨ lə bədə me ca. ");
INSERT INTO sor_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Mana gɨ nare yɨnəng bədə me dwayna gwale dan gɨ anə wayɨw di bədə me da, hana kalna mana gɨ ta di, labaa ciri dɨ ta di bam, me ɓwabɨnagɨ usɨsɨ gɨ gɨdɨrangə kalnagɨ dɨdə me ca. ");
INSERT INTO sor_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Dwayna, nə wayang i gwale sɨw: Wála gɨ Mãr̰ĩ dara àla sariya di da, ha wama gɨ nare nə ciri dɨ ta lə di nan̰e ɗwaya wamani gɨnə ciri dɨ Sodom day gɨ Gomor bam sɨn̰.» ");
INSERT INTO sor_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«Dwayna, nə kɨjəng ya dɨmən̰je de mana gɨ r̰igɨm dalawə. Damna gɨ naa ya kwalàle de, me man̰ɨna bədə ya kogəl de me ca. ");
INSERT INTO sor_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Gamna sɨdənge dara nare di: Gɨ ha yɨbəng ꞌyàgɨ́ woni àla sariya ɨsɨragɨ lə, me gɨ ha gwabang gɨ bɨr̰aw mana gɨ kululi day woni amsa Mãr̰ĩyə me ca. ");
INSERT INTO sor_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Gɨ ha hára gandang woni wama ciri dɨrəgɨ lə me dolgə dɨrəgɨ lə me dara daran ɨndi. I ta di me anə ha biyəgɨ gɨ gwale gɨ nə wayɨw me mani nə nə àlgɨ di me mana gɨ cendi dɨrəgɨ lə, me mana gɨ nare nə i Juwib bədə dɨrəgɨ lə me ca. ");
INSERT INTO sor_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Mana gɨ gɨ dara yɨbəng ꞌyàgɨ́ woni dwana ɨsɨragɨ lə dara àlang sariya da, kalna hára dara gwale gɨ anə ha waya di ɗi, me hàrna dara “Də hárang waya i man mo?” di bədə me. Dara dawa dɨ ta lə da, i Mãr̰ĩ me ha ꞌyàng gwale gɨ waya di an̰ju. ");
INSERT INTO sor_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","I ꞌyeni me anə ha waya gwale di bədə me, i Dúndi dɨnə Abɨrang gɨ Mãr̰ĩ duwa me ha waya gwale di bɨdəngə tandi. ");
INSERT INTO sor_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Gun chendɨw duwa gang kaw ha wayagɨ nare woni dwana ba yɨnəw ꞌyánaw bam. Dwe abəw kaw, ha àla gɨ gorndɨw yande dige dige me ca. Dine nə yàa da, ha kɨdə woni mar̰ande gɨ war̰agɨ woni yàgɨ, me cendi ha wayagɨ nare woni dwana ba yɨbɨnəgɨ ꞌyánagɨ bam. ");
INSERT INTO sor_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nare pad ha ɨlənge dara daran ɨndi. Me gun gɨ yɨnə sɨw wàyna kalna dusɨw dɨnnə bɨraa ꞌyan̰a lə da, Mãr̰ĩ ha ꞌyàw bɨlə. ");
INSERT INTO sor_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Mana gɨ gɨ gɨlnəng dɨrəng ciri dɨ mɨnnə da, cɨmnə hana dɨ ɗangə. Dwayna, nə wayang i gwale sɨw: Mana gɨ ɨndi gɨ Gun gorndɨw di, nə cwarnay hane da, anə ha harba ciri dɨ Israyel lə di pad bədə sɨn̰. ");
INSERT INTO sor_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Aba gɨrsə mani da, ɗoy aba gɨləw mani bədə. Kwaya kaw, ɗoy aba ciri duwa bədə me ca. ");
INSERT INTO sor_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Aba gɨrsə mani cwarna gɨdɨnə ya aba gɨləw mani di de da, sɨw ha ꞌywalawe. Me kwaya cwarna gɨdɨnə ya aba ciri duwa di de da, sɨw ha ꞌywalawe me ca. Gɨ waynaw aba ciri ba an̰ju ba i Sidan da, nare duwa nə kɨrə da, gɨ ha ꞌwagagɨ day man mo?» ");
INSERT INTO sor_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«Yande da, lán̰ɨnagɨ nare nə ta di bədə. Mani nə nare gamgɨ dusɨrəgɨ lə pad da, ha dɨmə daa me, nə gɨ àlgɨ budə lə kaw, gɨndəgɨ ha piyara daa pad me ca. ");
INSERT INTO sor_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Gwale gɨ nə waynang gandɨw gɨ changa da, cwarna waynaw daa gɨ dawa ɗən̰ ɗən̰. Gwale gɨ nə àsɨ bɨn sumdəngə n̰amɨw nɨm kaw, nagɨna daa kulu dɨwə swajɨnaw gɨ berni daa pɨden̰yə me ca. ");
INSERT INTO sor_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Kalna lán̰agɨ gɨ nare ɗi. Cendi da, nem ꞌyáa gun sɨw gɨ doni mɨra, me nem ꞌyáa dúndɨw bədə. Me lán̰ɨnaw Mãr̰ĩ an̰ju, dara an̰ji duwa da, nem ulə sɨdəng me dúndɨrəng me mana gɨ dùwa dɨ budə dɨra gɨ bam ilə bədə bɨr̰ɨn̰yə di bam pad. ");
INSERT INTO sor_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ɓag da, gɨ ɓam dirbi nə tẽtẽ sɨr kɨlgɨ bam gɨ chile dɨ ɓani gaa bədə mo? I sɨdɨ, dirbi nə ta di mɨn dwar̰agɨ lə kaw ɨndarna dodə sɨn̰a lə da, i ùrə gɨnə Abɨrang gɨ Mãr̰ĩ duwa lə do. ");
INSERT INTO sor_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Me ꞌyeni dan da, wudɨn̰ nə dɨdəng kaw, Mãr̰ĩ ꞌwocn̰ gɨr̰ə day le me ca. ");
INSERT INTO sor_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Yande da, lán̰ɨna bədə: Anə ꞌyolɨw Mãr̰ĩ nan̰ ɗoy dirbi nə gɨr̰e bam.» ");
INSERT INTO sor_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«I dara yande di me, gun gɨ wayna daa nare dɨrəgɨ lə ba a i gun ni da, ɨndi kaw, nə ha waya daa mana gɨ Aban gaba dama daa di dɨrəwə an̰ju ba i gun ni me ca. ");
INSERT INTO sor_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Me gun gɨ bɨlnə bɨw sarni wayna daa nare dɨrəgɨ lə ba a ꞌwocn̰ɨn bədə da, ɨndi kaw, nə ha waya daa ba nə ꞌwocn̰ɨw bədə mana gɨ Aban gaba dama daa di dɨrəwə me ca.» ");
INSERT INTO sor_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«Kalna ɨrmə dusɨrəngə dara ba nə yalang i gɨ labiya sɨn̰a dɨdə ka ɗi. Nə yalang i gɨ labiya bədə, me nə yalang i gɨ sugɨnə dɨ idɨ say. ");
INSERT INTO sor_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nə yala agda i nə dwe day gɨ abəw bam, deme day gɨ durmədɨ bam, deme dɨ dɨrway day gɨ nuwadɨ bam. ");
INSERT INTO sor_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nare nə dam gandɨm kɨrə mɨn kaw, ha ɨləmmedara daran ɨndi. ");
INSERT INTO sor_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Gun gɨ ùrnə abəw labaa iw nan̰ ɗwaynan ɨndi bam da, an̰ji ha nyama gɨdə gun ni bədə, labaa gun gɨ ùrnə gorndɨw labaa durməw nan̰ ɗwaynan ɨndi bam da, an̰ji ha nyama gɨdə gun ni bədə me ca. ");
INSERT INTO sor_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Gun gɨ unə habda duwa gɨ dagɨla dɨwə me pamnan nɨm bədə me da, an̰ji ha nyama gɨdə gun ni bədə. ");
INSERT INTO sor_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Gun gɨ ùrnə bɨlə gɨ sɨw duwa dodə sɨn̰a dɨdə ka da, an̰ji ha nwala bɨlə duwa gaba dama gɨ dɨrəw bɨr̰ɨn̰ di i bam, me gun gɨ gɨn̰ɨnə bɨlə gɨ sɨw gɨ sɨn̰a dɨdə ka di bam dara daran ɨndi da, an̰ji ha ꞌywaa bɨlə gaba dama gɨ dɨrəw bɨr̰ɨn̰ di le.» ");
INSERT INTO sor_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Gun gɨ yɨnəng gɨ dwani da, an̰ji yɨn i ɨndi, me gun gɨ yɨnən ɨndi gɨ dwani da, an̰ji yɨ i aba giyən di. ");
INSERT INTO sor_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Gun gɨ yɨnə aba cɨmə Mãr̰ĩ bɨw gɨ dwani dara an̰ji ba i aba cɨmə Mãr̰ĩ bɨw da, gun gɨ ta di ha ꞌywaa gwayni duwa bwara gɨ aba cɨmə Mãr̰ĩ bɨw duwa di mɨn me. Gun gɨ yɨnə aba àla mani nə tɨba Mãr̰ĩ dɨrəwə gɨ dwani dara an̰ji ba i aba àla mani nə tɨba Mãr̰ĩ dɨrəwə da, gun gɨ ta di ha ꞌywaa gwayni duwa bwara gɨ aba àla mani nə tɨba Mãr̰ĩ dɨrəwə duwa di mɨn me ca. ");
INSERT INTO sor_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Dwayna, nə wayang i gwale sɨw: Aba gɨrsə gwale ni gɨ nyamna mani bədə nare dɨrəgɨ lə, me gun gɨ we we gɨ ꞌyànaw nimi nə chàa nə hɨlale, inam i maniyə ɓani mɨra kaw, dara an̰ji ba i aba gɨrsə gwale ni da, gun gɨ ta di ha ꞌywaa gwayni duwa le bá.» ");
INSERT INTO sor_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Mana gɨ Jesu ꞌyàgɨ́ woni gɨrsə gwale duwa nə mwaj dii sɨr di gɨsəni ꞌyen̰ bam mwom da, an̰ji so daa mana gɨ ta lə di me ha mana gɨ ciri dɨ jiga jiga dɨ wama gɨ ta lə di dara gɨləgɨ gɨ nare mani me àsagɨ gɨ berni me ca. ");
INSERT INTO sor_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Jã Batis duwa da, i dangeyə. An̰ji dwaya mani nə Jesu Kris àlgɨ di, me an̰ji giyə woni gɨrsə gwale duwa nə yab dara ba hane ùrnəw ba da: ");
INSERT INTO sor_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","«I ɨjɨm me mə i gun gɨ woni cɨmə Mãr̰ĩ bɨw nə pii way gwale duwa ba hára lə di, labaa nə ɓyadɨnanin i gun gɨ ɗang mo?» ");
INSERT INTO sor_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ɨr̰ɨ Jesu di cogɨ lə diiyə waygɨ ba da: «Cwarna hana waynaw Jã di mani nə anə doygɨ gɨ sumdəng me, anə yərgɨ gɨ dɨrəng me di: ");
INSERT INTO sor_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Nare nə dɨrəgɨ bu kaw, cor yər mana me, nə majɨgəndɨ kaw, ha daa tɨba tɨba me, nare nə cagɨm àlgɨ kaw, cagɨm sɨr̰ɨbɨ bam sɨdəgɨ lə me, nə sumdəgɨ ɗugɨr kaw, doy gwale me, nare nə mare kaw, bɨdəgɨ agdɨ daa me, nare nə bugɨr kaw, gɨ waygɨ Nõ dɨ lade me ca. ");
INSERT INTO sor_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Me gun gɨ dusɨw ina sɨr sɨr dɨnnə bədə da, an̰ji dam i gɨ sii ꞌywala.» ");
INSERT INTO sor_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Mana gɨ woni gɨrsə gwale gɨnə Jã duwa di cor ya ɗɨm da, Jesu waygɨ nare nə gɨr̰e di gwale gɨnə Jã duwa ba da: «Anə ꞌwò dara yara i na mana gɨ dɨn dwar̰ɨ lə di mo? Anə ꞌwò dara yara i dɨrwa gɨ gale gɨgdɨw cow ka me, ka me di mo? Bədə. ");
INSERT INTO sor_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ɓag da, anə ꞌwò dara yara i na mo? Anə ꞌwò dara yara i gun gɨ hurə barge gɨ lade mo? To, nare woni hurba barge gɨ ladɨbe da, dam i bɨdang dɨnə dolgə lə gaa bədə mo? ");
INSERT INTO sor_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ɓag da, anə ꞌwò dara yara i na mo? Aba cɨmə Mãr̰ĩ bɨw mo? I sɨdɨ, me nə wayang: Jã i aba cɨmə Mãr̰ĩ bɨw ꞌyang, me an̰ji duwa da, ɗoy aba cɨmə Mãr̰ĩ bɨw bam. ");
INSERT INTO sor_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Dara an̰ji i paja gɨ Mãr̰ĩ way gwale duwa mana gɨ Maktubu duwa lə ba da: “Doy, nə giy paja ni ya lə dɨrəmmə dara ba ɗangr̰ɨnam bɨrmə dɨma bam ladɨ.” ");
INSERT INTO sor_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Dwayna, nə wayang i gwale sɨw: Mana gɨ nare nə namde yə̀gɨ dodə sɨn̰a dɨdə ka dwar̰agɨ lə da, gun mɨn gɨ geche gaba ɗwaya Jã gaba àlagɨ́ nare batem bam da, ilə bədə. Me wála gɨ caga ka lə da, gun ina gɨ pəgɨn̰ me kalna Mãr̰ĩ lamnadwãr̰ĩ dɨwə da, an̰ji i gɨ geche ɗoy Jã di bam. ");
INSERT INTO sor_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Mana gɨ aliya gɨ ɓɨg gɨ Jã yala nɨm me àlgɨ gɨ nare batem bɨraa dawa dɨ laba lə da, nare nə àcn̰e gɨn̰ dwãr̰ĩ dɨ daa bam gɨ dwana me, ùr ba gɨ chəbɨdɨ lamdɨ cendi. ");
INSERT INTO sor_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Woni cɨmə Mãr̰ĩ bɨw pad me bii gɨ ꞌwoo gɨnə Moyis duwa me waya gwale gɨnə dwãr̰ĩ dɨ daa di bɨraa aliya gɨ Jã yala nɨm ka di bá. ");
INSERT INTO sor_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Me anə ùrnə banə kalna dusɨrəng gwale ni dɨwə da, Eli gɨ gɨ way gwale duwa ba hára lə di, i Jã. ");
INSERT INTO sor_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Gun gɨ sumdəw woni dwaya gwale ina lə da, kal a dwayna. ");
INSERT INTO sor_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ɓag da, nare nə caga ka di da, nə ha ꞌwogɨ ɨrməgɨ i gɨ nare nə we mo? Nə ha ɨrməgɨ i gɨ dine woni dama wun̰jɨ bur̰əgɨ lə me, ꞌwogɨdɨ kwandagɨ ba da: ");
INSERT INTO sor_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Nə tongnin mani nə too me, anə n̰ar̰ɨ lə diiyə bədə. Nə tongnin diri dɨ made kaw, anə nul lə diiyə bədə me ca.” ");
INSERT INTO sor_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Nə way yande dara, mana gɨ Jã di gɨra duwa lə da, an̰ji wom mani bədə, me chə̀ gani bədə me mwom da, nare way ba, dúndi dɨ àcn̰e ba ilə dɨwə. ");
INSERT INTO sor_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Me mana gɨ ɨndi gɨ Gun gorndɨw, nə gɨra da, nə wom mani me, nə chə̀ gani me ca da, cor nare way ba nə dam i dara wama me chàa gɨ gani me bɨr̰ɨn̰ ɗɨm, ba nə ɓamar i gɨ woni salaw dole gɨ geche gɨ Rom mani me, nare nə àcn̰e nə ɗang me ca. Me nə wayang da: Dɨrɨn̰ naa nənə Mãr̰ĩ duwa da, gɨ ꞌwocn̰ɨgɨ i gɨ mani day nə àla lə.» ");
INSERT INTO sor_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ɨr̰ɨ, Jesu ilə ɨr̰ɨn̰jə nare nə ciri dɨ gechide nə yab lə; i ciri dɨ an̰ji àl mani nə dan̰a nan̰ lə dɨdə bá bá, me nare dɨra gɨn̰ kala gɨ àcn̰a day di bam com me, cendi gɨn̰ hára gaba ꞌywaa Mãr̰ĩ bam me ca. ");
INSERT INTO sor_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","An̰ji waygɨ da: «ꞌYeni nare nə ciri dɨ Korasin, wamani ilə dɨdəngə! ꞌYeni nare nə ciri dɨ Besada kaw, wamani ilə dɨdəngə me ca! Dara mani nə dan̰a nə nə àlagɨ̀ mana gɨ dwar̰angə ꞌyeni da, dee nə àlnagɨ i mana gɨ ciri dɨ Tirrə me ciri dɨ Sidonnə me da, nare day dee kal àcn̰a day di bam ɓɨg ɗɨm me cendi dee ha hára ꞌywaa Mãr̰ĩ. Cendi dee hurbə barge gɨ gɨ busɨw gɨ suwal sɨdəgɨ lə me cubɨ dɨbɨrɨn̰ basa dɨdəgɨ lə dama nɨm n̰agɨniyə di me ca. ");
INSERT INTO sor_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","I ta di me, nə wayang nɨm ba, wála gɨ Mãr̰ĩ dara àla sariya di da, ha wama gandang nan̰e ɗwaya nare nə ciri dɨ Tirrə bam me, nə ciri dɨ Sidonnə di bam me ca. ");
INSERT INTO sor_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Me mɨndi ciri dɨ Kapernom da, də ɨrɨm diya Mãr̰ĩ ba a ha ꞌwóy hára nɨm i daa ɓa? Bədə. An̰ji ha chə́y i mana gɨ bengə. Dara mani nə dan̰a nə nə àlgɨ̀ dɨyyə mɨndi di, dee nə àlnagɨ i ciri dɨ Sodom dɨdə tandi da, laba ka kaw, tandi dee wor ilə sɨn̰. ");
INSERT INTO sor_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","I ta di me nə wayang nɨm: Wála gɨ Mãr̰ĩ dara àla sariya di da, ꞌyeni nare nə ciri dɨ Kapernommə da, ha wama gandang ɗwaya nare nə ciri dɨ Sodommə di bam.» ");
INSERT INTO sor_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Mana gɨ ta lə da, Jesu wayɨw Mãr̰ĩ ba da: «Ay, Aban, aba ciri gɨ mani nə daa me nə dodə me i ɨsəwə, nə àlɨ́m dóche, dara nare woni dɨrɨn̰ naa me, nə woni ꞌwacn̰a mani me da, mə budɨgɨ mani nə ta di dodə, me cor mə gɨlgɨ gandagɨ i dine nə ꞌyəng daa cendi. ");
INSERT INTO sor_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Əw, Aban, ta di me i mani nə lade nə dɨrəm ùrgɨ di.» ");
INSERT INTO sor_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ɨr̰ɨ, Jesu waygɨ nare ba da: «Aban gɨ Mãr̰ĩ bon mani pad ɨsənnə. Gun mɨn kaw, ꞌwocn̰ɨn ɨndi gɨ Gorndɨw di bədə, i Aban mɨn tenene me ꞌwocn̰ɨn an̰ju. Gun mɨn kaw, ꞌwocn̰ Aban di bədə, me i ɨndi gɨ Gorndɨw me nə ꞌwocn̰ɨw ɨndi, me i nare nə nə ùr dara ba nə gɨlgɨ Aban di le do me cendi ha ꞌwacn̰aw sɨn̰.» ");
INSERT INTO sor_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ɗang da, Jesu way ba da: «ꞌYeni nare pad nə hudɨr gɨ nugde ilə dɨdəngə me, gwayni àlang da, hane ꞌywanan, me ɨndi, nə ha laya hudɨr dan gɨ nugde di chɨ́gdəng dodə me, anə ha bwaa gwayni. ");
INSERT INTO sor_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nə i aba àsa dɨn dodə me, dusɨn so kaláng bədə me ca. Yande da, unə gɨlə ni gɨ nə gɨləng gandɨw di me, kɨdɨnə woni gɨrsə gwale ni me ca. I yande do me anə ha ꞌywaa bwaa gɨ gwayni di sɨn̰. ");
INSERT INTO sor_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","I sɨdɨ, gɨlə ni gɨ mani gɨ nə gɨləng gandɨw da, wom bədə me, hudɨr ni kaw, hɨbal le me ca.» ");
INSERT INTO sor_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Wála gɨ ta lə da, Jesu day gɨ nə woni gɨrsə gwale duwa ha jə̀ gɨ dàge nə gemeyə dwar̰agɨ lə; i gɨ wála gaba bwaa gwayni gɨnə nare nə Juwib dayyə. Me woni gɨrsə gwale duwa di, cherni àlgɨ le. Mwom da, cendi piy geme dɨw di me gogɨl dɨrəw wom. ");
INSERT INTO sor_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mana gɨ nare nə gɨ ꞌwogɨgɨ Parise ba gɨ yər yande mwom da, cendi wayɨw Jesu ba da: «Yər woni gɨrsə gwale dɨma di de! Cendi ilə àla i mani nə bii ɨnda gɨ ꞌwoo ɨm àla day bam wála gaba bwaa gwayniyə.» ");
INSERT INTO sor_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesu waygɨ ba da: «Anə āsɨ mani nə Dabid àlgɨ̀ di mana gɨ Maktubu dɨnə Mãr̰ĩyə bədə mo? Dabid me woni bwaw me, wála mɨn, cherni àlgɨ̀. ");
INSERT INTO sor_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","An̰ji dɨm ha kulu gɨnə Mãr̰ĩyə me lay mapa gɨ gɨ chɨ́gdɨw Mãr̰ĩ kulə di, me cendi wom. Ɓag da, an̰ji me woni bwaw di me, dee nem wama gɨ mapa gɨ ta di bədə, me i woni bwasa Mãr̰ĩ mɨra me wom mapa gɨ ta di cendi. Me mani nə Dabid àlgɨ̀ ta di, i àcn̰a Mãr̰ĩ dɨrəwə bədə. ");
INSERT INTO sor_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Labaa, anə āsɨ mana gɨ bii gɨ ꞌwoo lə gɨ way dara woni bwasa Mãr̰ĩ me wála gaba bwaa gwayni di me bədə mo? Wála gaba bwaa gwayniyə di kaw, woni bwasa Mãr̰ĩ àl giyə mana gɨ kulu gaba bwasa Mãr̰ĩyə di le. Ta di, cendi ilə cilanga i bii gɨ ꞌwoo gɨnə wála gaba bwaa gwayniyə di daa. Me mani nə cendi àlgɨ̀ ta di, àl i mani nə àcn̰e Mãr̰ĩ dɨrəwə bədə. ");
INSERT INTO sor_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Me nə wayang: Caga ka di, gun gaba ɗwaya kulu gaba bwasa Mãr̰ĩ bam di ilə. ");
INSERT INTO sor_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Dwayna, mana gɨ Maktubu dɨnə Mãr̰ĩ duwa dwar̰ɨ lə, an̰ji way da: “Nə ùr anə banə yarna kwandang n̰agɨni day. Yara gɨ kwandang n̰agɨni day da, ladɨ ɗoy àlán gɨ sarga bam.” Dee anə ꞌwacn̰ana gwale gɨ ta di gɨndɨwe da, woni gɨrsə gwale ni di, anə dee ha bwagɨ gwale dɨdəgɨ lə bədə. Mani nə cendi àlgɨ̀ ta di, i nə àcn̰e Mãr̰ĩ dɨrəwə bədə. ");
INSERT INTO sor_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Dwayna, ɨndi gɨ Gun gorndɨw di, nə i wála gaba bwaa gwayni di aba ciri duwa.» ");
INSERT INTO sor_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ɨr̰ɨ, Jesu so kal mana gɨ ta di bam me ha gɨr mana gɨ kulu day gaba amsa Mãr̰ĩyə. An̰ji gandɨ ha kulə. ");
INSERT INTO sor_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Mana gɨ ta lə di, abe mɨn gɨ ɨsəw mar bam ilə. Mwom da, nare nə gɨ ꞌwogɨgɨ Parise ùr Jesu di ba da: «Bii ɨnda gɨ ꞌwoo lə da, gɨ nem swaa gun gaba mwom daa wála gaba bwaa gwayniyə di le mo?» Ɨrmə dayyə ɓag kaw, cendi kan̰jɨ ba gɨ ꞌyo gwale gɨ àcn̰e bɨwə dara ba gɨ ha gandɨw woni àla sariya dɨrəgɨ lə. ");
INSERT INTO sor_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ɨr̰ɨ Jesu ùrgɨ ba da: «I wi mana gɨ dwar̰angə me dɨmən̰ duwa mɨn ɨndarna gubu gɨ ɗungeyə gɨ wála gaba bwaa gwayniyə da, ha ꞌwódɨ daa bədə mo? ");
INSERT INTO sor_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Me gun gɨ gɨsage da, ladɨ ɗoy dɨmən̰ di bam bədə mo? Yande da, bii ɨnda gɨ ꞌwoo kal bɨrmə dara ba mə àlna ladni mana gɨ wála gaba bwaa gwayniyə di le me ca.» ");
INSERT INTO sor_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ɨr̰ɨ, Jesu wayɨw abe gɨ ɨsəw mar bam di: «Yə́ ɨsəm dodə!» Me an̰ji yə́ ɨsəw dodə, me ɨsəw di cor gɨdɨ ladɨ ya gɨ mɨn di de me ca. ");
INSERT INTO sor_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Mwom da, nare nə Parise di gandagɨ iche mana gɨ kulu gaba amsa Mãr̰ĩyə di me, dayar gagɨ gwale dara ba gɨ ha àla i man dara ꞌyáa gɨ Jesu bam mo? ");
INSERT INTO sor_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Me mana gɨ Jesu ba a doy dara cendi ma gwale ba gɨ ꞌyəwe mwom da, an̰ji cɨm kal mana gɨ ta di bam me yá. Ɨr̰ɨ, nare nə gɨr̰e nan̰ pam tarɨw me, an̰ji so nare nə mwom daa dwar̰agɨ lə pad. ");
INSERT INTO sor_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Cor, an̰ji ɨr̰ɨn̰ nare di waygɨ cendi ba gɨlnəw daa bədə. ");
INSERT INTO sor_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ta di me i mani nə tanga Aba ciri gɨ Mãr̰ĩ wayɨw aba cɨmə bɨw gɨ Esayi gwale day di me yala àlal kɨrab. An̰ji waya ba da: ");
INSERT INTO sor_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Yarna aba àlan giyə ni, nə biyəw me, dusɨn ùrɨw nan̰e. Nə chɨ́wDúndi ni mana gɨ dɨwə, me an̰ji ha gɨləgɨ nare nə sɨn̰a gɨndɨdɨ lə pad bɨrmə gɨ lade tɨba. ");
INSERT INTO sor_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","An̰ji ha kan̰ja gun gwale bədə me, an̰ji ha swaja gwale daa kəndɨrəj kəndɨrəj bədə me ca. Gɨ ha dwaya mar̰ɨjaw mana gɨ bɨrmə dalawə bədə. ");
INSERT INTO sor_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Dɨrwa gɨ kojəre kaw, an̰ji ha aw bam bədə. Lamba dɨ ina lə ꞌywaa lə ɓani hin̰e kaw, an̰ji ha budədɨ bam bədə me ca. An̰ji ha àla yande di bɨraa dara mani pad àlalna gɨ bɨrmə day tɨba bá. ");
INSERT INTO sor_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Me nare nə gɨndəgɨ jiga jiga pad sɨn̰a dɨdə ka ha kala ɨrmə day dɨwə an̰ju. ");
INSERT INTO sor_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Targɨn̰ ɗang da, gɨ háraw gɨ Jesu abe mɨn gɨ dɨrəw bu me i mɨm me ca. I dúndi dɨ àcn̰e me àlɨw yande tandi. Jesu sow daa, me abe di cor way gwale me yər mana ladɨ pɨrang me ca. ");
INSERT INTO sor_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nare nə gɨr̰e di yɨbdɨ dɨdəgɨ me, wajɨbɨ gwale bulə dayyə ba da: «Ɓag da, abe gɨ ta di i dole gɨ Dabid mwàwgɨ də ilə ɓyadawə di bədə ɓa?» ");
INSERT INTO sor_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Me nare nə gɨ ꞌwogɨgɨ Parise doy gwale gɨ ta di me way day ba da: «Abe gɨ ta di ꞌyorbɨ dúndi dɨ àcn̰e bam nare sɨdəgɨ lə di, i Sidan dɨ i dúndi dɨ àcn̰e geche day me ꞌyàw dwana dɨ ta di tandi.» ");
INSERT INTO sor_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesu ꞌwocn̰ ɨrmə day di com, me waygɨ da: «Nare nə wama gɨ mɨnnə jarna say gɨ sɨdəgɨ day da, wama gɨ ta di ha myandara i bam. Nare nə ciri dɨdə labaa chebni dɨ kɨrə jarna say gɨ sɨdəgɨ day kaw, ciri dɨ ta di labaa chebni dɨ kɨrə di kaw, ha wara dama lə jang bədə. ");
INSERT INTO sor_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ina i Sidan me ꞌywarna kondɨdɨ Sidan bam da, tandi jər say gɨ sɨdɨ dɨra gang. Yande da, dwãr̰ĩ dɨra di ha wara lə man ɗang mo? ");
INSERT INTO sor_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Anə way ba ɨndi di, ba i gɨ dwana dɨnə Sidan dɨra me ba nə ꞌyor gɨ dúndi dɨ àcn̰e di. Me ina yande da, woni gɨrsə gwale dan di, i wi me ꞌyàgɨ́ dwana me ꞌyor nɨm gɨ dúndi dɨ àcn̰e bam di mo? Yarna, i nare dan di gang me ha waya dara gwale dan gɨ anə wayɨw ta di ba ha lə bədə. ");
INSERT INTO sor_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Me ina i gɨ Dúndi dɨnə Mãr̰ĩ duwa me nə ꞌywarna gɨ dúndi dɨ àcn̰e bam mwom da, ta di gɨl dara dwãr̰ĩ dɨnə Mãr̰ĩ duwa kaw, yala ꞌywang ɗɨm. ");
INSERT INTO sor_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ɗang kaw, mə ùrnə ba mə gandɨna hana mana gɨ gun gaba dwana kɨrə duwa lə dara laya gɨ mani duwa nə ꞌywaa bam da, mə ha àla i man mo? Mə magdɨ gun gaba dwana di dodə do me mə ha chaba mani duwa nə kɨrə ta di bam pad sɨn̰. ");
INSERT INTO sor_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Gun gɨ ina i gun ni bədə da, an̰ji i aba ɨlən me, gun gɨ wanannə dáya gɨ swagə daa lə bədə kaw, an̰ji i aba lyasɨragɨ bam jiga jiga me ca. ");
INSERT INTO sor_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","I dara yande me nə wayang nɨm Mãr̰ĩ ha kala dusɨw hɨlala nare àcn̰a day gɨ jiga jiga dɨwə le, me àcn̰a day gɨ cadɨbɨw nɨm kaw, an̰ji ha kala dusɨw hɨlala lə diiyə me ca, me nare nə cadɨbɨna i Dúndi duwa da, an̰ji ha kala dusɨw hɨlala dɨdəgɨ lə bədə bɨr̰ɨn̰. ");
INSERT INTO sor_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Gun gɨ wayna ɨndi gɨ Gun gorndɨw gwale ni gɨ àcn̰e kaw, Mãr̰ĩ ha kala dusɨw hɨlala le dɨwə, me gun gɨ wayna dúndi dɨnə Mãr̰ĩ duwa gwale dɨra gɨ àcn̰e da, an̰ji ha ꞌywaa dusi dɨ hɨlale dɨnə Mãr̰ĩ di laba bədə me sanga bədə me ca.» ");
INSERT INTO sor_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«Dwayna, habda gɨ lade da, yəə ladɨ le, me habda gɨ àcn̰e kaw, yə̀ àcn̰e me ca. Habda gɨ àcn̰e, labaa gɨ lade kaw, gɨ ꞌwocn̰ɨw i dara yàa duwa. ");
INSERT INTO sor_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mɨgay dɨndadɨ nə gá! ꞌYeni anə àcn̰e, me i man me anə ha waya gwale gɨ lade mo? Dara gun bɨw da, way i gwale gɨ ꞌwana dusɨw daa. ");
INSERT INTO sor_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Gun gɨ lade da, way i gwale gɨ lade gɨ ꞌwon dusɨw dɨ korgɨn̰ daa, me gun gɨ dusɨw àcn̰ da, way i gwale gɨ àcn̰e gɨ ꞌwon dusɨw dɨ korgɨn̰ daa me ca. ");
INSERT INTO sor_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nə wayang: Wála gɨ Mãr̰ĩ dara àla sariya di da, an̰ji ha ùrə nare ba biynəw gwale gɨ wadɨnani pad gɨ cendi tanga wayɨw di daa. ");
INSERT INTO sor_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","I dara gwale dɨma gɨ waya me Mãr̰ĩ ha yaram nɨm ba mə i gun gɨ tɨba, ɗang kaw, i dara gwale dɨma gɨ waya me Mãr̰ĩ ha yaram nɨm ba mə i gun gɨ àcn̰e me ca.» ");
INSERT INTO sor_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ɨr̰ɨ, woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa me nare nə Parise me hára ꞌyo Jesu me wayɨw ba da: «Aba gɨlənin mani, nə ùrnin ba mə àlnanin mani nə dan̰a, nə yərninne!» ");
INSERT INTO sor_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Mwom da, an̰ji waygɨ ba da: «ꞌYeni nare nə caga ka, anə i nare nə àcn̰e, me anə i woni cwaw Mãr̰ĩ tarang ta di me, anə ùrɨn mani nə dan̰a ɗe! Nə ha àlang mani mɨn nə dan̰a nə ɗang bədə, i mani nə dan̰a nə wun ya nə pii àlal gɨ aba cɨmə Mãr̰ĩ bɨw gɨ Jonas ta di de mɨra. ");
INSERT INTO sor_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ha ꞌya ya Jonas tanga ba a dam nɨm dòche gɨ geche nudəwə wála subu ta di de me, ɨndi gɨ Gun gorndɨw di kaw, nə ha àla wála subu mana gɨ munɨ lə di me ca. ");
INSERT INTO sor_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Wála gɨ Mãr̰ĩ dara àla sariya di da, nare nə ciri dɨ Ninib lə ha swaa daa nare nə caga ka dɨrəgɨ lə me ha waya cendi ba i nare nə àcn̰e. Dara nare nə Ninib di tuni pii doy berni dɨnə Jonas duwa me kala àcn̰a day di bam me yala ꞌyo Mãr̰ĩ. Ɨr̰ɨ, caga ka da, gun gɨ ɗoy Jonas bam ilə. ");
INSERT INTO sor_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Wála gɨ Mãr̰ĩ dara àla sariya di da, doli dɨ geche dɨ wama gɨ tulɨn̰ dɨ ɨsay gɨ abeyə di, ha swaa ɗɨbə daa nare nə caga ka dɨrəgɨ lə me ha waya cendi ba i nare nə àcn̰e. Dara tandi tanga swaa i sɨn̰a dɨ yēyə hən̰ hára dara dwaya dɨrɨn̰ naa nənə dole gɨ Salmõ duwa. Ɨr̰ɨ, caga ka da, gun gɨ ɗoy Salmõ bam ilə.» ");
INSERT INTO sor_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«Mana gɨ dúndi dɨ àcn̰e dɨmnə bam gun sɨwə mwom da, tandi ha kɨdɨbara bam kudɨmi dalawə kan̰ja mana gaba dama bwaa gwayni, me tandi ꞌyo bədə. ");
INSERT INTO sor_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ɨr̰ɨ, tandi ɨrɨm dusɨdɨ lə ba da: “Ladni duwa da, nə cwara hára mana ni gɨ nə dama lə pii me nə kalaw di bi.” Dúndi dɨ àcn̰e di cwara me ꞌyo mana di i pəgɨn̰, tojər bam kwa dɨrədɨ lə me, mani kaw, ɗangr̰ar ladɨ me ca. ");
INSERT INTO sor_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ɨr̰ɨ tandi ha laya dúndi dɨ àcn̰e wurgɨsubu ɗang dɨ gwale dɨra wom ɗoy dɨra bam, ɓamara gandɨdɨ mɨn háragɨ gɨra mana gɨ ta lə di me damgɨ lə. Ɨr̰ɨ, widɨbə gɨnə gun gɨ ta di, cor àlɨw nan̰ ɗoy gɨ pii bam bi. Mani nə ha ꞌywaa nare nə àcn̰e nə caga ka di kaw, ha wunə i yande dige dige me ca.» ");
INSERT INTO sor_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Mana gɨ Jesu ilə wayagɨ nare nə gɨr̰e di gwaleyə sɨn̰ da, iw day gɨ nə chamraw yala ɗɨbə ilə iche dara ba gɨ wayɨw gwale. ");
INSERT INTO sor_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Mwom da, gun mɨn hára wayɨw da: «Im me chamram me ilə iche, cendi ùr ba gɨ wayɨm i gwale.» ");
INSERT INTO sor_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Me Jesu di wayɨw: «I wi me i in mo? I nə wi me i chamran di mo?» ");
INSERT INTO sor_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ɨr̰ɨ an̰ji gɨl ɨsəw woni gɨrsə gwale duwa di dɨdəgɨ lə me waygɨ nare nə gɨr̰e di ba da: «Yarna, in me chamran me di, i ka. ");
INSERT INTO sor_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Dara gun gaba àla mani nə Aban gaba dama daa dusɨw ùrgɨ da, an̰ji me i chendɨn, i chidɨn, i in.» ");
INSERT INTO sor_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Wála gɨ ta lə da, Jesu dɨmə kɨrə hára iche me ha dama kuray gɨ ɓɨle bɨwə dara gɨləgɨ gɨ nare gwale gɨnə Mãr̰ĩ duwa. ");
INSERT INTO sor_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Nare nə gɨr̰e hára dayar tulɨwə, i ta di me an̰ji nagɨ dam nɨm bɨrwa dalawə. Nare nə gɨr̰e di ɗɨbdɨ day daa nimi bɨdəgɨ lə. ");
INSERT INTO sor_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","An̰ji gɨlgɨ mani nan̰ i gɨ gwale gɨ diri. An̰ji waygɨ da: «Dwayna! Abe mɨn so ba a ha chìgdə swagə yiga lə. ");
INSERT INTO sor_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Mana gɨ an̰ji ilə chìgdə lə da, swagə dɨrəgɨ nə yab wujabar bor mana gɨ bɨrmə lə me, dirbi gɨra tɨgɨgɨ chə́gdɨgɨ bam car. ");
INSERT INTO sor_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","6","Swagə dɨrəgɨ nə mɨn da, wujabar day bor mana gɨ gɨndara lə. Cendi gandɨ daa kaláng mɨ̀ndagɨ, me ꞌyo bɨrmə gaba bwaa sabɨragɨ hára dodə cog bədə dara sɨn̰a dɨ lade di yengɨ le. Yande da, mana gɨ dawa gɨra ən dɨdəgɨ lə da, swagə nə ta di woy bam. ");
INSERT INTO sor_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Swagə dɨrəgɨ nə mɨn ɗang bi bor day mana gɨ chemde woni jimdi dwar̰agɨ lə. Cendi dɨm daa, me chemde woni jimdi di so yɨgɨ daa swamama ɨmgɨ jwara bam. ");
INSERT INTO sor_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Me swagə dɨrəgɨ nə mɨn bor day sɨn̰a dɨ ladeyə. Cendi dɨm jor naa dɨrəgɨ, me swagə nə ta di dɨdəgɨ lə mɨn da, dɨrəgɨ ꞌyarbar nan̰e. Nə mɨn àl dɨrəgɨ nem aru, nə mɨn ɗang àl dɨrəgɨ nem gɨnɨn̰ kubi, nə mɨn ɗang bi àl dɨrəgɨ nem gɨnɨn̰ subu. ");
INSERT INTO sor_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Gun gɨ sumdəw woni dwaya gwale ina lə da, kal a dwayna.» ");
INSERT INTO sor_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Mwom da, woni gɨrsə gwale gɨnə Jesu duwa di chidɨbə Jesu sɨwə ib ib me ùrbɨw ba da: «I dana me mə gɨlgɨ nare mani di i gɨ gwale gɨ diri mo?» ");
INSERT INTO sor_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","An̰ji cogɨ lə diiyə waygɨ ba da: «ꞌYeni da, Mãr̰ĩ àl gandang ladni; an̰ji gɨləng gwale sɨw gɨ budə lə dara lama duwa gɨ dwãr̰ĩ di ɗɨm, me gɨlgɨ nare nə ɗang bədə. ");
INSERT INTO sor_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Dara gun gɨ mani duwa ina lə da, gɨ ha ꞌyàw lə diiyə nan̰ ɗang bi, me mani duwa ha bɨlbə dodə. Me gun gɨ duwa ina lə bədə da, nə hin̰e ɨsəwə ta di kaw, gɨ ha ꞌwoo i bam. ");
INSERT INTO sor_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Nə gɨlgɨ mani gɨ gwale gɨ diri di da, i dara cendi un̰bɨ me yər bədə, domən̰dɨ me doy bədə, me ꞌwocn̰ gwale di gɨndɨw bədə me ca. ");
INSERT INTO sor_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ta di me i gwale gɨnə Mãr̰ĩ duwa gɨ wayɨw aba cɨmə bɨw gɨ Esayi di me yala àlal gandagɨ kɨrab. Mãr̰ĩ way da: “Anə ha dwaya, me anə ha ꞌwacn̰a gɨndɨw bədə. Anə ha un̰bə gɨ dɨrəng, me anə ha yara bədə me ca. ");
INSERT INTO sor_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Dara ꞌyeni nare nə caga ka di, dɨdəng woy nan̰e. Anə hurbə dùndɨrəng sumdəngə me anə ɗesɨbɨ dɨrəng daa me, dara sumdəng ba dwayna bədə, me dɨrəng kaw, ba yarna bədə me ca. Anə gɨn̰ gaba ꞌwacn̰a mani gɨndəgɨ bam me cwara gaba hára ꞌywan bam me ca. I ta di me nə ꞌyo gɨ bɨrmə gaba bɨləng nɨm daa bədə di.”» ");
INSERT INTO sor_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Me Jesu waygɨ woni gɨrsə gwale duwa ba da: «Me ꞌyeni da, anə dam i gɨ sii ꞌywala, dara dɨrəng yərre me, sumdəng kaw, doyye me ca. ");
INSERT INTO sor_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Dwayna, nə wayang i gwale sɨw: Woni cɨmə Mãr̰ĩ bɨw nə ɓɨg nan̰ me nare nə ɗang nə tɨba Mãr̰ĩ dɨrəwə nan̰, tanga ùr ba gɨ yər mani nə anə yərgɨ caga ka di, me ꞌyogɨ yərgɨ bədə, cendi ùr ba gɨ doy gwale gɨ anə doyɨw caga ka di me, doyɨw bədə me ca.» ");
INSERT INTO sor_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«ꞌYeni da, dwayna gwale gɨ diri gɨnə aba chə̀ə swagə duwa di gɨndɨw. ");
INSERT INTO sor_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Swagə dɨrəgɨ nə wujabar bor bɨrmə lə di, wun i ya gun gɨ doy berni dɨnə dwãr̰ĩ dɨ daa me ꞌwocn̰ gɨndɨdɨ bədə ta de. Sidan hára gɨra biy gwale gɨ ilə dusɨwə di bam. ");
INSERT INTO sor_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Swagə nə mɨn nə bor day gɨndara lə da, i gun gɨ doy gwale gɨnə Mãr̰ĩ duwa me, yɨw gɨ sii ꞌywala kaláng maa, ");
INSERT INTO sor_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","me kal gwale di bo sabɨraw dusɨwə bədə. An̰ji i gun gɨ yɨ sɨw woy bədə. Mana gɨ wamani ꞌywanaw dara gwale gɨnə Mãr̰ĩ da, an̰ji so kaláng gɨn̰ gwale gɨnə Mãr̰ĩ duwa di bam. ");
INSERT INTO sor_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Nə mɨn nə wujabar day bor mana gɨ chemde woni jimdi dwar̰agɨ lə da, i gun gɨ doy gwale gɨnə Mãr̰ĩ duwa di maa, ɨr̰ɨ an̰ji ɨrɨm mana gɨ wamani gɨ jiga jiga gɨ sɨn̰a dɨdə ka dɨwə, an̰ji kan̰jɨ ꞌywaa gɨ sɨn̰a dɨdə ka gɨ i mani nə pəgɨn̰ yag. I yande me ɨrmə pad gɨ an̰ji ɨrmɨw di da, yɨ gwale gɨnə Mãr̰ĩ gɨ dusɨwə di daa swamama ɨmɨw àla gandɨw giyə bam. ");
INSERT INTO sor_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Me swagə nə bor day daga dalawə sɨn̰a dɨ ladeyə da, i nare nə doy gwale gɨnə Mãr̰ĩ duwa me ꞌwocn̰ gɨndɨw ladɨ. Cendi i ya swagə dɨdəgɨ nə mɨn nə bo dɨrəgɨ aru me, nə mɨn gɨnɨn̰ kubi me, nə mɨn gɨnɨn̰ subu me ta de.» ");
INSERT INTO sor_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesu waygɨ gwale gɨ diri gɨ ɗang bi ba da: «Dwãr̰ĩ dɨ daa da, wun i ya abe mɨn gɨ gɨsɨ swagə duwa nə lade mana gɨ daga duwa lə ta de. ");
INSERT INTO sor_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Me gɨ changa dwar̰ɨ dɨ nare pad i nuni da, aba mar̰ande duwa ha gɨsəw barɨm lə swagə nə lade di dɨdəgɨ lə me, kal sɨw ya. ");
INSERT INTO sor_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Mana gɨ swagə di gandɨ dɨdəgɨ da, gɨ yər barɨm kaw, gandɨ ilə me ca. ");
INSERT INTO sor_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Mwom da, kòy nənə aba daga di hára gɨra ùrɨw ba da: “Aba ciri nin, ɓag da, tanga mə gɨsɨ i swagə nə lade mana gɨ daga dɨma lə di gaa bədə mo? Me ɨr̰ɨ, barɨm da, swaa duwa i gɨndɨw we mo?” ");
INSERT INTO sor_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","An̰ji waygɨ ba da: “I aba mar̰ande ni me àl mani nə ta di.” Ɨr̰ɨ, kòy di ùrɨw ba da: “Yande da, gaa mə ùr ba nə hananin piynə barɨm di bam mo?” ");
INSERT INTO sor_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Me an̰ji cogɨ lə diiyə ba da: “Bədə, piynə barɨm di caga ka bədə sɨn̰, dara anə piynəw caga ka da, anə ha piyə swagə di ɓamagɨ gɨ barɨm di mɨn. ");
INSERT INTO sor_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Kalnagɨ gɨ jwarna le ca dayyə bɨraa wála gaba n̰ilə gɨ dɨdəgɨ lə bá. Dawa dɨ ta lə da, nə ha wayagɨ woni n̰ilə swagə di, gɨ ajɨna barɨm di bam pii, magdɨnaw daa ulnəw bam do me gɨ n̰ilnə swagə di bwanan gandagɨ ɓecheyə sɨn̰.”» ");
INSERT INTO sor_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesu di waygɨ nare gwale gɨ diri gɨ ɗang bi ba da: «Dwãr̰ĩ dɨ daa da, wun i ya habda gɨ mutardɨ dɨrəw nə gun ugɨ ha mõgɨ mana gɨ daga duwa lə ta de. ");
INSERT INTO sor_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Dɨrəw di i ɓani hin̰e hin̰e ɗoy kwandaw habde dɨrəgɨ nə pad bam, me mana gɨ cendi gandɨ daa da, jorbɨ nan̰ ɗoy habde pad bam, me gɨdə habda gɨ geche gɨ dirbi nə daa kaw, ɗangr̰ɨ ciri day gangr̰awə damdɨ lə.» ");
INSERT INTO sor_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesu waygɨ gwale gɨ diri gɨ ɗang bi ba da: «Dwãr̰ĩ dɨ daa wun i ya musbu gɨ deme juw bow burə gɨ koro mwaj dɨwə dara àla gɨ mapa ta de. Mana gɨ tandi koyɨw ɓamɨw daa mɨn mwom da, burə di sodɨ daa pad duwa lə.» ");
INSERT INTO sor_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Mani nə pad ta di, Jesu gɨlgɨ nare i gɨ gwale gɨ diri. Inam i nare nə gɨr̰e da, dɨban gwale gɨ diri da, Jesu tɨn̰ bɨw waygɨ gwale bədə bɨr̰ɨn̰. ");
INSERT INTO sor_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ta di me i gwale gɨ tanga Mãr̰ĩ wayɨw aba cɨmə bɨw di me yala àlal kɨrab. An̰ji waya ba: «Nə ha gɨləgɨ mani i gɨ gwale gɨ diri, nə ha wayagɨ mani nə i budɨ lə ɓɨg wála gɨ nə diy gɨ mani gɨndəgɨ bá di daa.» ");
INSERT INTO sor_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Targɨn̰ ɗang da, Jesu di so kal nare nə gɨr̰e di ɗɨm me ha gɨr ulay. Mwom da, woni gɨrsə gwale duwa hára tulɨwə ib me wayɨw ba da: «Biynin gwale gɨnə barɨm gɨ daga lə di gɨndɨw daa.» ");
INSERT INTO sor_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","An̰ji waygɨ ba da: «Aba gɨsə swagə nə lade di da, i ɨndi gɨ Gun gorndɨw. ");
INSERT INTO sor_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Daga di, i sɨn̰a gɨndɨdɨ pad. Swagə nə lade di, i nare nə kal Mãr̰ĩ lam dwãr̰ĩ duwa dɨdəgɨ lə. Barɨm di, i nare nənə Sidan dɨra. ");
INSERT INTO sor_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Aba mar̰ande gaba gɨsə barɨm di, i Sidan. N̰ilə gɨ swagə di, i dɨr̰ɨn̰a ꞌyan̰a dɨra. Woni n̰ilə swagə di, i Paja nənə Mãr̰ĩ duwa nə daa. ");
INSERT INTO sor_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Aja gɨ barɨm layaw uləw bam duwa lə ta di, dɨr̰ɨn̰a ꞌyan̰a dɨra lə kaw, ha àlala i yande me ca. ");
INSERT INTO sor_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ɨndi gɨ Gun gorndɨw di, nə ha kɨjə paja ni nə daa hára lə, me cendi gɨra ha ꞌywara nare woni lama kwandagɨ bwagɨ àla gɨ àcn̰a lə me woni àla àcn̰a me bam mana gɨ ciri dɨnə Mãr̰ĩyə. ");
INSERT INTO sor_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Paja ni nə daa ha hára gandagɨ kaláng bwagɨ mana gɨ dùwa dɨ budə dɨra gɨ bam ilə bədə bɨr̰ɨn̰yə di. Mana gɨ ta di i mana gaba nulə gura me yɨdɨbə sande lə me ca. ");
INSERT INTO sor_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Wála gɨ ta lə da, nare nə i tɨba Mãr̰ĩ dɨrəwə da, cendi ha ꞌywagda le ya dawa de mana gɨ ciri dɨnə Abɨragɨ gɨ Mãr̰ĩyə. Gun gɨ sumdəw woni dwaya gwale ina lə da, kal a dwayna.» ");
INSERT INTO sor_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«Dwãr̰ĩ dɨ daa da, wun i ya sungɨ dɨ mani woni sumi ba ilə dwar̰ɨ lə me mur nɨm mana gɨ daga dalawə ta de. Wála mɨn, gun mɨn ha gɨr mana gɨ daga dalawə di me ꞌyo sungɨ dɨ ta di. Ɨr̰ɨ, an̰ji codɨ mudɨ dodə bi me ɨndər yá, me sɨw ꞌyolɨw nan̰e. Mwom da, an̰ji kɨl mani duwa nə ꞌywaa bam pad me ha kɨlə gɨ daga gɨ ta di. ");
INSERT INTO sor_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Dwayna bi, dwãr̰ĩ dɨ daa da, wun i ya abe mɨn gaba àla kenge kan̰jɨ diyè dɨ idɨ sumi ta de. ");
INSERT INTO sor_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Wála mɨn, an̰ji ꞌyo dɨ mɨn dɨ kili dɨra wom nan̰, me an̰ji gɨra ha kɨlə mani duwa nə ꞌywaa bam pad me kɨl nɨm gɨ diyè dɨ idɨ sumi dɨ ta di.» ");
INSERT INTO sor_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«Ɗang bi, dwãr̰ĩ dɨ daa da, wun i ya nare woni ùrə bo gɨ law day mana gɨ kurayyə dara laya gɨ gòche ta de. Law day di lay gòche nə dɨrəgɨ jiga jiga. ");
INSERT INTO sor_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Mana gɨ law di ba dɨ lay gòche di ꞌwon dwar̰ɨ daa mwom da, woni ùrə di surdɨ ha nɨm daa wayniyə. Targɨn̰ ɗang da, cendi dam liw law day di daa me ilə an̰jira gòche di lə: Gòche nə ladɨbe da, cendi bogɨ i kɨrangé dayyə me, nə àcn̰e da, cendi bogɨ bam me ca. ");
INSERT INTO sor_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Dɨr̰ɨn̰a ꞌyan̰a dɨra lə di kaw, ha wunə i yande dige dige me ca: Paja nənə Mãr̰ĩ duwa nə daa hára lə cagda nare nə àcn̰e gɨ nare nə tɨba Mãr̰ĩ dɨrəwə di le. ");
INSERT INTO sor_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Mwom da, gɨ ha bwaa nare nə àcn̰e di mana gɨ dùwa dɨ budə dɨra gɨ bam ilə bədə bɨr̰ɨn̰yə di. Mana gɨ ta di, i mana gaba nulə gura me, yɨdɨbə sande lə me ca.» ");
INSERT INTO sor_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ɨr̰ɨ, Jesu ùr woni gɨrsə gwale duwa ba da: «Anə ꞌwocn̰ gwale gɨ nə wayang gandɨw pad ta di gɨndɨw mo?» Cendi cow lə diiyə: «Əw, nə ꞌwocn̰ɨninne.» ");
INSERT INTO sor_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ɨr̰ɨ an̰ji waygɨ ba: «I ta di me aba gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa gɨ we we kaw, mana gɨ an̰ji ꞌywana gɨlə gɨ mani nə ɨrɨm dara dwãr̰ĩ dɨ daa me yɨnəw gɨ ɨsaw sɨr da, an̰ji wun i ya geche gɨ ciri dwar̰ɨ lə ta de. Geche gɨ ta di, biy mani nə dɨrway me nə aliye me mana gɨ sungɨ duwa dwar̰ɨ lə.» ");
INSERT INTO sor_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Mana gɨ Jesu way gwale gɨ diri di ꞌyen̰ bam pad mwom da, an̰ji kal sɨw ɨndər yá. ");
INSERT INTO sor_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ɨr̰ɨ, an̰ji cor ha mana gɨ Najaret, dɨ i ciri dɨ tanga an̰ji ɨsər lə ɓag, me an̰ji so ilə gɨləgɨ nare mani mana gɨ kulu day gaba amsa Mãr̰ĩyə. Me gɨlə duwa gɨ mani di ꞌyàgɨ́ nare di ɨrmə nan̰e, me cendi way da: «Ɓag da, i wi me ꞌyàw duwa dɨrɨn̰ naa nə ta di mo? I wi me ꞌyàw dwana dɨ idɨ àla gɨ mani nə dan̰a nə ya ta de di mo? ");
INSERT INTO sor_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ɓag da, an̰ji i aba pɨlbə habde di gorndɨw gaa bədə mo? An̰ji iw di i Mari gaa bədə mo? Me chamraw i nə Jak me Josep me Simõ me Jud me gaa bədə mo? ");
INSERT INTO sor_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Chamraw nə namde pad dayyə kaw, dam lə ganandɨ ka bədə ɓa? Me an̰ji ꞌywaa dwana dɨ ta di pad i we mo?» ");
INSERT INTO sor_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ta di me i mani nə ɨmgɨ nare nə Najaret kala gɨ dusɨrəgɨ Jesu dɨwə bam di. Ɨr̰ɨ, Jesu di waygɨ da: «Aba cɨmə Mãr̰ĩ bɨw da, nare nə we we kaw, ùrɨwe, me nare nə ciri duwa dɨdə me war̰aw duwa gang me da, gɨn̰ɨw i bam.» ");
INSERT INTO sor_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","I ta di me Jesu àl nɨm gɨ mani nə dan̰a ciri duwa dɨdə nan̰ bədə di, dara nare di gɨn̰ kala gɨ dusɨrəgɨ dɨwə bam. ");
INSERT INTO sor_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Wála gɨ ta lə da, Erod gɨ i dole gɨ wama gɨ Galileyə di, doy Jesu sumɨw gɨ ꞌwogɨ nan̰ di, ");
INSERT INTO sor_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","me an̰ji waygɨ woni àlaw giyə di ba da: «Gun gɨ ta di, ha ꞌya i Jã gaba àlagɨ́ nare batem di me dɨmə daa nare nə mare dwar̰agɨ lə. I ta di me an̰ji ꞌyo gɨ dwana dɨ idɨ àla gɨ mani nə dan̰a nə ta di.» ");
INSERT INTO sor_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","I sɨdɨ, Erod tanga yəə Jã àsaw dangeyə. An̰ji giy nare yɨw magdɨw àsɨw dangeyə dara gwale gɨnə deme dɨ gɨ ꞌwogɨdɨ Erodiyad dɨ Erod chəbɨdɨ chendɨw gɨ Pilip lə di. ");
INSERT INTO sor_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Me Jã di wajɨw Erod di le bá bá ba da: «Bii ɨnda gɨ ꞌwoo lə da, chaba gɨ malam gɨdədɨ gɨ dyam da, dol bədə.» ");
INSERT INTO sor_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Yande mwom da, Erod di ùr ba ꞌyə Jã di le, me an̰ji lán̰gɨ i nare, dara Jã di, cendi ɨrmɨw ba i aba cɨmə Mãr̰ĩ bɨw. ");
INSERT INTO sor_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Cor wála mɨn, Erod àl sii ꞌywala gɨnə yàa duwa di me an̰ji ꞌwogɨ nare nan̰. Mwom da, Erodiyad durmədɨ n̰ar̰ɨ mana gɨ nare nə gɨ ꞌwagagɨ di dɨrəgɨ lə me, n̰ar̰a dɨra di ꞌyolɨw Erod di nan̰e. ");
INSERT INTO sor_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ta di me an̰ji sɨrgɨdɨ sɨw dara tandi ba ùrnəw i na kaw, ba a ha ꞌyàdɨ le. ");
INSERT INTO sor_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Idɨ gɨsədɨ waydɨ tandi ba ùrnə Jã dɨw. Mwom da, tandi wayɨw Erod di: «Sawɨn Jã gaba àlagɨ́ nare batem di dɨw àsɨn subɨra lə háran nɨm kwa.» ");
INSERT INTO sor_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Gwale gɨ ta lə di, dole sɨw mar bam, me dara an̰ji sɨrgɨdɨ sɨw nare di dɨrəgɨ lə da, an̰ji ꞌya bɨrmə ba ꞌyànadɨ le ");
INSERT INTO sor_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","me an̰ji giy ha sawa Jã dɨw mana gɨ dangeyə di. ");
INSERT INTO sor_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Me gɨ àsɨ Jã dɨw di subɨra lə me ꞌwoo hára ꞌyàdɨ dwe dɨ more di, me tandi ha nɨm ꞌyàdɨ idɨ. ");
INSERT INTO sor_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Woni gɨrsə gwale gɨnə Jã duwa hára u kumbɨ duwa ha nɨm mõõ dodə. Ɨr̰ɨ cendi hargɨ cɨməw Jesu mani nə àlal di. ");
INSERT INTO sor_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Mana gɨ Jesu doy gwale gɨ ta di da, so day gɨ nə woni gɨrsə gwale duwa kal mana gɨ ta di bam me, dam bɨrwa lə dara ba gɨ ha nɨm bam mɨ́ndagɨ, hən̰ gɨ nare. Me nare nə gɨr̰e doy gwale duwa me ɓɨr̰ɨn̰ ciriyə jiga jiga pam tarɨw gɨ gɨdɨragɨ. ");
INSERT INTO sor_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Mana gɨ Jesu ba a chə́ə dodə bɨrwa lə da, an̰ji yər nare nə gɨr̰e di mwom da, dɨrəw ꞌyəngɨw dɨdəgɨ lə, me so nare day woni mwom daa me. ");
INSERT INTO sor_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Yala turgɨ ɗɨm da, woni gɨrsə gwale duwa chidɨbə sɨwə me wayɨw da: «Dawa ꞌyen̰ye me, mana gɨ ka di i bam dɨn dwar̰ɨ lə. Cəgdɨ nare nə gɨr̰e di daa ɗɨm, kalgɨ gɨ hana ciriyə ciriyə kɨlnə mani nə wama.» ");
INSERT INTO sor_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Cor Jesu waygɨ da: «Cendi hana da, ladɨ bədə. ꞌyànagɨ mani nə wama di ꞌyeni gang!» ");
INSERT INTO sor_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ɨr̰ɨ cendi wayɨw da: «Nə inin gɨ mapa jii me gòche sɨr me mɨra ilə ka.» ");
INSERT INTO sor_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Me an̰ji waygɨ da: «Hane nɨm ꞌyànan kwa.» ");
INSERT INTO sor_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Mwom da, Jesu waygɨ nare di ba damna dodə chemde dɨdəgɨ lə ta, ɨr̰ɨ an̰ji lay mapa gɨ jii di me gòche nə sɨr di me, u dɨrəw yər daa me àlɨ́w Mãr̰ĩ dóche me, ɓolbɨ mapa di dodə me, ꞌyàgɨ́ woni gɨrsə gwale duwa di me cendi ɨsɨgɨ nare nə gɨr̰e di. ");
INSERT INTO sor_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nare nə pad ta di wom mapa di ɨbdɨ. Woni gɨrsə gwale gɨnə Jesu di lay mapa gɨndɨw dɨ wor dodə di ꞌwonbɨ kɨrangé mwaj dii sɨr daa. ");
INSERT INTO sor_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Nare nə wom mani ta di nem i ya abje dubu jii de, dɨban āsa gɨ namde me dine me ca. ");
INSERT INTO sor_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Mana gɨ ta lə dog, Jesu waygɨ woni gɨrsə gwale duwa gɨ dwana ba nagɨna daa bɨrwa lə ba hana dɨrəwə kuray dugdɨw dɨ alə ta lə, mana gɨ an̰ji ba ilə cagda gɨ nare nə gɨr̰e daa lə di. ");
INSERT INTO sor_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ɨr̰ɨ, mana gɨ nare nə gɨr̰e di cəgdɨ yá mwom da, Jesu nagɨ ha daa kur̰a dɨdə dara amsa gɨ Mãr̰ĩ bam mɨnaw, hən̰ gɨ nare. Mana gɨ mana ba ur̰in̰ ɗɨm da, an̰ji ilə mana gɨ ta lə di, mɨnaw mɨn tenene. ");
INSERT INTO sor_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Mana gɨ ta lə da, bɨrwa di yāa le gɨ mana gɨ wayni di, me gɨgdər nan̰e dara gale di wà ɨjɨw nan̰e, me nimi di gobɨw nan̰e me ca. ");
INSERT INTO sor_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Mana wor ib dara wála da, Jesu ha nimi dɨdəgɨ lə ɨjɨ gɨ woni gɨrsə gwale duwa. ");
INSERT INTO sor_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Me cendi yərɨw hára lə nimi dɨdəgɨ lə da, dusɨrəgɨ cubɨgɨ ɗɨn̰ ɗɨn̰ me lán̰a àlgɨ nan̰e me ca. Cendi way ba i dúndi me, cendi ilə swaja r̰ur̰u gɨ lán̰a. ");
INSERT INTO sor_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Mana gɨ ta lə dog, Jesu waygɨ da: «Yɨnə sɨdəng woye, i ɨndi! Lán̰ɨna bədə!» ");
INSERT INTO sor_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Mwom da, Piyer u gwale wayɨw Jesu ba da: «Aba ciri ni, ina i ɨjɨm ꞌyang da, kalɨn nə ha nimi dɨdəgɨ lə, nə ha ꞌywam.» ");
INSERT INTO sor_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesu wayɨw da: «Hare!» Mwom da, Piyer chɨ́ dodə bɨrwa lə di me ha nimi dɨdəgɨ lə ɨjɨ gɨ Jesu. ");
INSERT INTO sor_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Me Piyer yər gale wà nan̰ da, lán̰a àlɨw, ɨr̰ɨ an̰ji ilə dara ɗwanda nimiyə. Mwom da, an̰ji soy r̰ur̰u ba da: «Aba ciri ni, wannə ɗe!» ");
INSERT INTO sor_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Mana gɨ ta lə dog da, Jesu yəə ɨsəw yɨw me wayɨw da: «Ay, ɨjɨm gɨ dusɨm dɨ kala dɨnnə i ɓani gá! Mə gagɨ gwale dusɨmmə, dana mo?» ");
INSERT INTO sor_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ɨr̰ɨ ca dayyə ca nagɨgɨ daa bɨrwa lə di, me gale di ɗɨbɨ dodə. ");
INSERT INTO sor_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Woni gɨrsə gwale gɨnə Jesu nə ilə bɨrwa lə di piy gubɨrəgɨ dodə Jesu dɨrəwə me wayɨw da: «I sɨdɨ: Mə i Mãr̰ĩ gorndɨw ꞌyang.» ");
INSERT INTO sor_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Mana gɨ ba gɨ cilangɨ kuray gɨ ɓɨle di bam da, cendi yala mana gɨ wayniyə sɨn̰a dɨ Gɨnesaret lə. ");
INSERT INTO sor_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Nare nə sɨn̰a dɨ ta lə di, cor ꞌwocn̰ Jesu me way nõ duwa dɨ an̰ji yala nɨm wama gɨ ta lə di pad. Ɨr̰ɨ, gɨ háraw gɨ nare woni mwom pad. ");
INSERT INTO sor_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Gɨ mɨrgɨw ba kalna nare nə woməre di ba ɓɨlnə i chire gɨ barge duwa bɨwə mɨra, me cendi nə pad nə ɓɨlbɨ da, ꞌyo labiya. ");
INSERT INTO sor_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Targɨn̰ ɗang da, nare nə gɨ ꞌwogɨgɨ Parise me nə woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa me swagə mana gɨ ciri dɨ geche dɨJursalemmə ha ꞌywaa Jesu. Cendi wayɨw ba da: ");
INSERT INTO sor_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Woni gɨrsə gwale dɨma da, lán̰dɨ hada dɨnə mwágɨrandɨ day bədə, dana mo? Yər, cendi wom mani dɨban wiya gɨ ɨsɨragɨ bam ta di, bor gɨ hada di bədə.» ");
INSERT INTO sor_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ɨr̰ɨ Jesu waygɨ da: «Me ꞌyeni di, anə ùr hada dan nan̰ me anə gɨn̰ lán̰aw gɨ bii gɨ ꞌwoo gɨnə Mãr̰ĩ duwa bam, dana mo? ");
INSERT INTO sor_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ɓag ɓag da, Mãr̰ĩ way mana gɨ bii gɨ ꞌwoo lə ba da: “Àlgɨ nə abam day gɨ im horɨmbə”, me an̰ji way ɗang bi ba da: “Gun gɨ cadɨbɨna abəw labaa iw da, ùr i ꞌyáa gɨ bam.” ");
INSERT INTO sor_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Me ꞌyeni da, anə gɨlgɨ nare dan, gun ba nem wayagɨ nə abəw day gɨ iw ba da: “Mani nə ɨsənnə nə dee nə ha ꞌyàng dara ba nə wang nɨm lə di, nə u bɨn ꞌyàw i Mãr̰ĩ sarga ɗɨm.” ");
INSERT INTO sor_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ɨr̰ɨ, anə way da, gun gɨ àlna yande da, an̰ji àl gɨ abəw labaa iw horɨmbə bədə kaw, gwale ilə bədə. Yande da, gɨləgɨ gɨ nare hada dan di da, anə mendɨ i gwale gɨnə Mãr̰ĩ duwa bam. ");
INSERT INTO sor_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","ꞌYeni nare nə gwale ꞌyol bɨdəngə me dusɨrəng dɨ korgɨn̰ i jiga nə gá! Aba cɨmə Mãr̰ĩ bɨw gɨ Esayi jangɨ gwale dan daa pɨrang mana gɨ Maktubu dɨnə Mãr̰ĩyə ba da: “Mãr̰ĩ way da: ");
INSERT INTO sor_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‹Nare nə ta di àlɨn horɨmbə i gɨ bɨdəgɨ mɨra, me dusɨrəgɨ dɨ korgɨn̰ da, i jiga gandɨn. ");
INSERT INTO sor_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Hɨrwən day di i mani nə pəgɨn̰ yag. Dara mani nə cendi gɨlgɨ nare di, i ɨrmə gɨnə nare day mɨra.›”» ");
INSERT INTO sor_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Mwom da, Jesu ꞌwaga nare nə gɨr̰e di sɨwə me waygɨ da: «Kalna sumdəng ladɨ le, dwayna gwale ni gɨ nə ilə wayang gandɨw lə ka di me ꞌwacn̰ana gɨndɨw ladɨ le: ");
INSERT INTO sor_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Mani nə gandɨ ha gun bɨwə da, ha cwaa gun ba i gɨ àcn̰e Mãr̰ĩ dɨrəwə bədə. Me i mani nə swaa gun dusɨw dɨ korgɨn̰yə me ganda nɨm bɨwə di me cow gɨ àcn̰e Mãr̰ĩ dɨrəwə cendi.» ");
INSERT INTO sor_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Mwom da, woni gɨrsə gwale gɨnə Jesu duwa chidɨbə sɨwə me wayɨw ba da: «Gwale dɨma gɨ mə wayɨw ta di nagɨ nare nə Parise di dusɨrəgɨ le da, mə ꞌwocn̰ bədə mo?» ");
INSERT INTO sor_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ɨr̰ɨ an̰ji cogɨ lə diiyə waygɨ ba da: «Habde pad nə Aban gɨ Mãr̰ĩ gaba dama daa di me ɗyawnagɨ an̰ju bədə da, gɨ ha piyəgɨ i bam. ");
INSERT INTO sor_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Kalnagɨ le. Cendi i ya nare nə dɨrəgɨ bu me ba surbɨ gɨ kwandagɨ nə ɗang nə dɨrəgɨ bu me ta de. Me gun gɨ dɨrəw bunə le me surnə jaw gɨ dɨrəw bu me da, cendi ha bwara gubu lə ca dayyə ca.» ");
INSERT INTO sor_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Mwom da, Piyer wayɨw Jesu ba da: «Biynin gwale gɨ diri gɨ ta di gɨndɨw daa.» ");
INSERT INTO sor_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ɨr̰ɨ Jesu cor ùrɨw ba da: «ꞌYeni di kaw, anə i woni ꞌwacn̰a mani gɨndəgɨ bədə sɨn̰ me ca mo? ");
INSERT INTO sor_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Mani pad nə gandɨ ha mana gɨ gun bɨwə da, ha i mana gɨ nudəwə, me targɨn̰ ɗang da, cendi gandɨ ha i mana gaba ꞌwada lə, anə ꞌwocn̰ yande bədə ɓa? ");
INSERT INTO sor_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Me mani nə ganda gun bɨwə da, i nə swaa i alə dusɨw dɨ korgɨn̰yə, i cendi me co gun ba i gɨ àcn̰e Mãr̰ĩ dɨrəwə di cendi. ");
INSERT INTO sor_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Dara i mana gɨ gun dusɨw dɨ korgɨn̰yə me ɨrmə gɨ àcn̰e swaa lə: ꞌYáa gɨ gun gɨ ùrə dɨma me, kan̰ja gɨ jam dyaməw labaa, kan̰ja gɨ kondi tɨrədɨ me, delme dɨ idɨ kan̰ja namde labaa abje me, mĩyni me, sabaw gɨ jam gwale bwaw dɨwə me, widɨru me. ");
INSERT INTO sor_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ta di me i mani woni cwaa gun àcn̰ mana gɨ Mãr̰ĩ dɨrəwə di. Me wama gɨ mani dɨban wiya gɨ ɨsam bam da, com gun gɨ àcn̰e Mãr̰ĩ dɨrəwə bədə.» ");
INSERT INTO sor_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Targɨn̰ ɗang da, Jesu so kal mana gɨnə nare nə Juwib day di bam me ha mana gɨ wama gɨ Tirrə me gɨ Sidonnə me. ");
INSERT INTO sor_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ɨr̰ɨ, deme mɨn dɨ i Juwib bədə dam lə wama gɨ ta lə di. Tandi ha ɨjɨ Jesu me soy ꞌwogɨw ba da: «Aba ciri ni, ɨjɨm gɨ dole gɨ Dabid mwàw, yər n̰agɨni ni ɗe! Dúndi dɨ àcn̰e ilə durmən sɨdə me widɨbɨdɨ nan̰e.» ");
INSERT INTO sor_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Me Jesu àsɨdɨ gwale mɨn lə diiyə bədə. Woni gɨrsə gwale duwa chidɨbə sɨwə me wayɨw ba da: «ꞌYor deme dɨ ta di bam, tandi ilə pama tarandɨ lə me ilə swaja ꞌwagandɨ lə dɨban bwaa gɨ gwayni!» ");
INSERT INTO sor_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ɨr̰ɨ Jesu way ba da: «Mãr̰ĩ giyən i dara nare nə Israyel dɨdəgɨ mɨra. Cendi i ya dɨmən̰je nə nole de.» ");
INSERT INTO sor_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Deme di hára piy gubɨrədɨ dodə Jesu dɨrəwə me wayɨw ba da: «Aba ciri ni, wan daa ɗe!» ");
INSERT INTO sor_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ɨr̰ɨ an̰ji codɨ lə diiyə gɨ gwale gɨ diri waydɨ ba da: «Chaba gɨ haye gɨnə dine woni ciri day me bwagɨ gɨ gɨrade da, ladɨ bədə.» ");
INSERT INTO sor_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Deme di wayɨw da: «I sɨdɨ, Aba ciri ni, me ɓag da, gɨrade di wom i haye gɨ ɓolbər bor dodə tabɨl dɨnə woni ciri day gɨndɨdɨ lə gaa bədə mo?» ");
INSERT INTO sor_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Mwom da, Jesu waydɨ deme di: «Ay, chidɨn! Də kala dusɨy dɨnnə nan̰e! Yande da, mani nə dɨ ùrgɨ di, kal àlalna gandi ya ba dɨ ùr nɨm de me ca.» Me mana gɨ ta lə dog, dúndi dɨ àcn̰e di dɨm bam dwe di sɨdə me tandi ꞌyo labiya. ");
INSERT INTO sor_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesu so kal wama gɨ ta di bam me, cwara hára bi. An̰ji ha i kuray gɨ ɓɨle gɨ Galile bɨwə. Ɨr̰ɨ, an̰ji nagɨ ha daa kur̰a dɨdə me dam dodə. ");
INSERT INTO sor_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Me nare nə gɨr̰e nan̰ hára ꞌyow. Nare nə ta di dwar̰agɨ lə da, nə r̰egɨdu me nə dɨrəgɨ bu me, nə mɨm me, nare nə wamani gɨ dɨrəw jiga jiga gɨ cogɨ nare tuləgɨ me nə mwom nə ɗang nan̰ me ca, gɨ hára gandagɨ bow Jesu dɨrəwə, me an̰ji sogɨ daa. ");
INSERT INTO sor_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Cor nare nə mɨm di way gwale me, nare nə wamani gɨ dɨrəw jiga jiga gɨ cogɨ nare tuləgɨ kaw, ꞌyo labiya me, nə r̰egɨdu kaw, ɓɨr̰ɨn̰ ha daa me, nə dɨrəgɨ bu kaw, yərbɨ mana ladɨ pɨrang pɨrang me. Mwom da, mani nə ta di ꞌyàgɨ́ nare nə gɨr̰e di ɨrmə nan̰e. Ɨr̰ɨ cendi ɓɨr̰ɨn̰ ilə bwaw Mãr̰ĩ gɨnə nare nə Israyel day di jilay. ");
INSERT INTO sor_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Mwom da, Jesu ꞌwaga woni gɨrsə gwale duwa sɨwə me waygɨ ba da: «Dɨrən ꞌyəngɨn nare nə gɨr̰e nə ka di dɨdəgɨ lə. Cendi i gandɨn laba wála subu pad, me ꞌyo mani nə wama bədə. Nə ha nyama kalagɨ dara ba cwarna hana gɨ cherni yande bədə. Dwana day ilə bədə, cendi gaa ha gabdara bam bɨrmə lə som.» ");
INSERT INTO sor_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ɨr̰ɨ woni gɨrsə gwale duwa di wayɨw da: «Nə hanin ꞌywaa mani nə wama i we dara ꞌyàgɨ́ nare nə gɨr̰e nə ta di ha wama ɨbdə nɨm mana gɨ dɨn dwar̰ɨ lə ka di mo?» ");
INSERT INTO sor_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesu ùrgɨ da: «Caga da, anə i gɨ mapa ɨndi ilə mo?» Cendi wayɨw ba i wurgɨsubu, me gòche nə dine ɓani ba ilə me ca. ");
INSERT INTO sor_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ɨr̰ɨ, Jesu waygɨ nare nə gɨr̰e di ba damna dodə sɨn̰a lə. ");
INSERT INTO sor_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Mwom da, an̰ji lay mapa gɨ wurgɨsubu di me gòche di me daa ɨsəwə me, àlɨw Mãr̰ĩ dóche lə diiyə. Mwom da, ɓolbɨ mapa di dodə me ꞌyàgɨ́ woni gɨrsə gwale duwa di me cendi ɨsɨgɨ nare nə gɨr̰e di. ");
INSERT INTO sor_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nare nə pad ta di wom mapa me gòche di me ɨbdə. Ɨr̰ɨ gɨndɨw wor bɨl dodə bi, me gɨ lay ꞌwonbɨ kɨrangé wurgɨsubu daa. ");
INSERT INTO sor_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nare nə wom mapa me gòche me di nem abje dubu wodɨ, dɨban āsa gɨ namde me dine me ca. ");
INSERT INTO sor_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Targɨn̰ ɗang da, Jesu cɨgdɨ nare nə gɨr̰e di daa me, kal sɨw nagɨ mana gɨ bɨrwa lə me ha mana gɨ wama gɨ Magadannə. ");
INSERT INTO sor_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Wála mɨn, nare nə gɨ ꞌwogɨgɨ Parise me nə Saduse me hára gɨra ꞌyo Jesu me ùrɨw gwale gaba twaw dara dwaya gɨ gwale bɨwə dara ba gɨ yɨw nɨm. Yande da, cendi ùrɨw ba àlnagɨ mani nə dan̰a nə ba gɨlnəgɨ dara an̰ju ba i gun gɨ Mãr̰ĩ ba giyəw an̰ju di. ");
INSERT INTO sor_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Me Jesu di cogɨ lə diiyə waygɨ ba da: «Mana gɨ dawa ɗwandɨna bam ɗɨm me siyaya gɨ daa bwarna me da, anə way bá, sanga da, mana ba ha lada le. ");
INSERT INTO sor_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Labaa, gɨ jomni cor̰ər̰ə, siyaya gɨ daa bwarna ngɨr ngɨr da, anə way bá, laba da, mana gɨra ba ha àcn̰a le. Mana gɨ anə yarna siyaya ɓam da, anə ꞌwocn̰ dara mana gɨra ba ha àlala i yande. Me mani nə àlal caga ka di, anə ꞌwocn̰ gɨndəgɨ bədə, dana mo? ");
INSERT INTO sor_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ꞌYeni nare nə caga ka, anə i nare nə àcn̰e, me anə i woni cwaw Mãr̰ĩ tarang ta di, me anə ùrɨn mani nə dan̰a ɗe! Nə ha àlang mani mɨn nə dan̰a nə ɗang bədə, i mani nə dan̰a nə pii àlal gɨ aba cɨmə Mãr̰ĩ bɨw gɨ Jonas ta di de mɨra.» Me ɨr̰ɨ Jesu so daa kalgɨ me ha yá nɨm. ");
INSERT INTO sor_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Mana gɨ Jesu day gɨ nə woni gɨrsə gwale duwa di ilə hára dara cilanga mana gɨ kuray gɨ ɓɨle gɨ Galile dugdɨw dɨ alə ta lə da, woni gɨrsə gwale duwa di nɨmə laya gɨ mapa ɨsɨragɨ lə bam. ");
INSERT INTO sor_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Me mana gɨ cendi ilə cilanga kurayyə da,  Jesu waygɨ ba da: «Àsɨna angal dan, gamna sɨdənge dara musbu gɨnə nare nə Parise me nə Saduse day me!» ");
INSERT INTO sor_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ɨr̰ɨ woni gɨrsə gwale duwa di ɨrɨm day an̰ji ba way i dara musbu gɨnə mapa duwa, dara ba gɨ laya mapa bədə di. ");
INSERT INTO sor_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesu ꞌwocn̰ ɨrmə day di com, me an̰ji waygɨ ba da: «Ay, ꞌyeni nare nə dusɨrəng dɨ kala dɨnnə i ɓani nə gá! I dana me anə ɨrɨm gwale dusɨrəngə, alə ba nə way i dara anə ba i gɨ mapa lə bədə di mo? ");
INSERT INTO sor_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Anə wor ꞌwacn̰a mani gɨndəgɨ sɨn̰ mo? Mapa gɨ jii mɨra me anə ɨsəgɨ nare nə dubu jii wama da, dusɨrəng gwong lə diiyə bədə mo? Gɨndɨw wara dodə di, anə laya ꞌwanba kɨrangé ɨndi na mo? ");
INSERT INTO sor_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Me mapa gɨ wurgɨsubu me anə ɨsəgɨ nare nə dubu wodɨ wama di me, gɨndɨw wara dodə, anə laya ꞌwanba kɨrangé ɨndi na mo? ");
INSERT INTO sor_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","I dana me mana gɨ nə wayang anə banə gamna sɨdənge dara musbu gɨnə nare nə Parise me nə Saduse me day di da, anə ꞌwocn̰ gɨndɨw bədə me anə way ba nə wayang i dara mapa mo?» ");
INSERT INTO sor_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Mana gɨ ta lə da, woni gɨrsə gwale duwa yala ꞌwocn̰ ɗɨm dara an̰ji ba waygɨ i dara musbu gɨnə mapa duwa bədə, me ba waygɨ i dara gɨlə gɨ mani gɨnə nare nə Parise day me gɨnə Saduse day me. ");
INSERT INTO sor_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Mana gɨ Jesu ha gɨr mana gɨ wama gɨ ciri dɨ gɨ ꞌwogɨdɨ «Sesare dɨnə Pilip» lə da, an̰ji so ùr woni gɨrsə gwale duwa di ba da: «Caga da, nare di way i man dara ɨndi gɨ Gun gorndɨw di mo? Ba nə i wi ɓag mo?» ");
INSERT INTO sor_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Woni gɨrsə gwale duwa di cow lə diiyə ba da: «Nare nə mɨn da, way ba mə i Jã gaba àlagɨ́ nare batem, me nə yab da, way day ba mə i aba cɨmə Mãr̰ĩ bɨw gɨ Eli, nə yab ɗang bi da, way day ba mə i aba cɨmə Mãr̰ĩ bɨw gɨJeremi, labaa ba mə i woni cɨmə Mãr̰ĩ bɨw nə pii gun day gɨ ɗang.» ");
INSERT INTO sor_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","An̰ji ùrgɨ ɗang bi ba da: «Me ꞌyeni dan da, anə way ba nə i wi di ɓag mo?» ");
INSERT INTO sor_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Mwom da, Simõ Piyer cow lə diiyə wayɨw ba da: «Ɨjɨm da, mə i Dole gɨ Mãr̰ĩ biyəw gɨ Kris di, Mãr̰ĩ gaba dama gɨ dɨrəw bɨ̀ra bɨr̰ɨn̰ di gorndɨw.» ");
INSERT INTO sor_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Mwom da, Jesu di wayɨw ba da: «Simõ gɨnə Jonas gorndɨw, mə dam i gɨ sii ꞌywala! Nə way yande dara i gun gɨ gɨsage me gɨləm gwale gɨ ta di bədə, me i Aban gɨ Mãr̰ĩ gaba dama daa di me gɨləm mani nə ta di an̰ju. ");
INSERT INTO sor_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Yande da, ɨndi, nə wayɨm i daa: Ɨjɨm di, sumɨm i Piyer, gɨndɨw dɨ biyə i kur̰a,  me i kur̰a dɨ ta di dɨdə me nə ha biyə kulu ni lə diiyə. Made kaw, ha nyama àla kulu di mani mɨn bədə. ");
INSERT INTO sor_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nə ha ꞌyàm lakɨle gɨnə ciri dɨ daa bɨdɨ di ɨsəmmə: Mani pad nə mə managɨ dodə sɨn̰a lə ka da, gɨ ha magɨ daa Mãr̰ĩyə me ca. Me mani pad nə mə awrɨnagɨ daa dodə sɨn̰a lə ka da, gɨ ha awragɨ daa alə daa me ca.» ");
INSERT INTO sor_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Mwom da, Jesu yəgdɨ woni gɨrsə gwale duwa di sumdəgɨ dara ba waynaw gun mɨn daa bədə pa pa dara ba a i Dole gɨ Mãr̰ĩ biyəw gɨ Kris di. ");
INSERT INTO sor_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","So wála gɨ ta lə da, Jesu diy gɨnɨn̰ ilə wayagɨ woni gɨrsə gwale duwa di daa wang ba da: «Ha ùrən i hára gɨ Jursalem bá, me gechide nənə nare nə Juwib day me, woni bwasa Mãr̰ĩ gechide day me woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa me, ha gɨlən dɨrən nan̰e do me cendi ha ꞌyán nɨm sɨn̰. Me wála gɨ subu lə da, nə ha dɨmə daa munɨ lə.» ");
INSERT INTO sor_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Mwom da, Piyer wol Jesu ha gandɨw bam tulɨn̰yə hin̰e me sogdɨw nɨm ba da: «Aba ciri, kal Mãr̰ĩ gamnamme! Mani nə yande ha àlam bədə bɨr̰ɨn̰!» ");
INSERT INTO sor_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Me ɨr̰ɨ Jesu di cow Piyer dɨrəw me wayɨw ba da: «Ha bam ched tulɨnnə, Sidan gá! Mə ilə wudɨban i gɨdan bɨrmə gɨnə Mãr̰ĩyə. Ɨrmə dɨma da, wundər gɨ ɨrmə gɨnə Mãr̰ĩ duwa bədə, me wundər i gɨnə nare day.» ");
INSERT INTO sor_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Mwom da, Jesu di waygɨ woni gɨrsə gwale duwa di ba da: «Gun gɨ ùrnə ba a pamna tarɨn da, kal a ɨrmɨnə dɨw duwa lə an̰ju gang bədə, me a unə habda duwa gɨ dagɨla dɨwə me pamnan nɨm. ");
INSERT INTO sor_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Dara gun gɨ ùrnə bɨlə gɨ sɨw duwa dodə sɨn̰a dɨdə ka da, an̰ji ha nwala bɨlə duwa gaba dama gɨ dɨrəw bɨr̰ɨn̰ di i bam. Me gun gɨ gɨn̰ɨnə bɨlə gɨ sɨw gɨ sɨn̰a dɨdə ka di bam dara daran ɨndi da, an̰ji ha ꞌywaa bɨlə gaba dama gɨ dɨrəw bɨr̰ɨn̰ di le. ");
INSERT INTO sor_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Gun da, dee ꞌywana mani nə sɨn̰a dɨdə ka pad le me, ꞌywana bɨlə gaba dama gɨ dɨrəw bɨr̰ɨn̰ di bədə da, ladni duwa ilə na lə mo? Labaa, gun ha ꞌyàw Mãr̰ĩ i na dara kɨlə gɨ bɨlə duwa gaba dama gɨ dɨrəw bɨr̰ɨn̰ di mo? ");
INSERT INTO sor_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Dara ɨndi gɨ Gun gorndɨw di, nə hára lə gɨ nə paja ni nə daa gɨ ꞌywagda gɨnə Aban gɨ Mãr̰ĩ di, me wála gɨ ta lə da, nə ha ꞌyàw wi kaw, mani bwara gɨ mani duwa nə an̰ji àlagɨ̀ di bá bá. ");
INSERT INTO sor_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Dwayna, nə wayang i gwale sɨw: Nare nə yab nə ilə dwar̰angə caga ka di ha yara cwara ni gɨ dwãr̰ĩ di gɨ dɨrəgɨ do me cendi ha mara bam sɨn̰.» ");
INSERT INTO sor_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Wála kubi tarɨwə da, Jesu wol Piyer me Jak day gɨ chendɨw gɨ Jã me ha gandagɨ bam tulɨn̰yə hin̰e, mana gɨ kur̰a dɨ hoy dɨdə bam mɨ́ndagɨ. ");
INSERT INTO sor_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Mana gɨ cendi i mɨ́ndagɨ kur̰a dɨdə mwom da, Jesu sɨw kɨlangar bam wun jiga mana gɨ dɨrəgɨ lə. Dɨrəw da, ácn̰ ya dawa de, me barge duwa cor wusɨ wusə gɨ àl lán̰a ya dawa ácn̰a dɨra gɨ mana de. ");
INSERT INTO sor_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Me jisgɨ yande, cendi yər woni cɨmə Mãr̰ĩ bɨw nə pii nə Moyis day gɨ Eli ilə waya gwaleyə gɨ Jesu. ");
INSERT INTO sor_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Mwom da, Piyer wayɨw Jesu ba da: «Aba ciri nin, dama ɨnda gɨ ka di da, ladɨ nan̰e. Mə ùrnə le da, nə ha ɗangr̰a kundi subu, mɨn dɨma me mɨn ɗang Moyis duwa me, mɨn ɗang bi, Eli duwa me.» ");
INSERT INTO sor_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Mana gɨ an̰ji ilə waya gwaleyə sɨn̰ da, siyaya gɨ ꞌyogde biyara mugɨ daa kɨdab me cendi doy gwale nɨm siyaya dalawə ba da: «Ta di me i gorndɨn. Dusɨn ùrɨw nan̰e me, sɨn ꞌyolɨn dɨwə me ca. Dwayna gwale duwa!» ");
INSERT INTO sor_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Mana gɨ woni gɨrsə gwale gɨnə Jesu duwa di ba gɨ doy gwale gɨ ta di da, lán̰a àlgɨ nan̰e me cendi bor əbdər dɨrəgɨ dodə sɨn̰a lə. ");
INSERT INTO sor_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Me Jesu di hára sɨdəgɨ lə ib me ɓɨlbɨgɨ gɨ ɨsəw me waygɨ ba da: «Ɓɨr̰ɨn̰ɨnə daa, lán̰ɨna bədə!» ");
INSERT INTO sor_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Mwom da, cendi piy dɨrəgɨ daa me yər i Jesu mɨnaw mɨn tenene mɨra. ");
INSERT INTO sor_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Mana gɨ cendi ilə chə́ə nɨm dodə kur̰a lə di da, Jesu waygɨ ba da: «Mani nə anə yaragɨ ta di, cɨmnəw gun mɨn gwale day daa bədə pa pa bɨraa dawa dɨ ɨndi gɨ Gun gorndɨw di nə dɨmnə nɨm daa nare nə mare dwar̰agɨ lə bá do.» ");
INSERT INTO sor_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ɗang da, woni gɨrsə gwale duwa di ùrɨw ba da: «Yande da, i dara na ɓag me woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa way ba Eli ba hára lə bá do me Dole gɨ Mãr̰ĩ biyəw gɨ Kris di ba hára sɨn̰ di mo?» ");
INSERT INTO sor_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Me an̰ji cogɨ lə diiyə waygɨ ba da: «I sɨdɨ. Eli di hára lə bá dara ɗangr̰a gɨ mani pad gɨ bɨrmə day. ");
INSERT INTO sor_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Me nə wayang daa: Eli di da, an̰ji gɨra ɗɨm me nare ꞌwocn̰ɨw bədə. Cor cendi àlɨw mani pad nə dɨrəgɨ ùr. Me ɨndi gɨ Gun gorndɨw di kaw, cendi ha gɨlən dɨrən yande me ca.» ");
INSERT INTO sor_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Mana gɨ ta lə da, woni gɨrsə gwale duwa di ꞌwocn̰ dara an̰ji ba waygɨ i dara Jã gaba àlagɨ́ nare batem di. ");
INSERT INTO sor_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Mana gɨ Jesu day gɨ nə woni gɨrsə gwale duwa nə subu di chɨ́gdəgɨ dodə kur̰a lə da, cendi yala mana mɨn gɨ nare nə gɨr̰e dayar lə me hára sɨdəgɨ lə ib. Mwom da, abe mɨn hára Jesu tulɨwə ib piy gubɨrəw dodə dɨrəwə me wayɨw ba da: ");
INSERT INTO sor_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","«Aba ciri, yər n̰agɨni dɨnə gorndɨn di ɗe! Jumgɨl àlɨwe me gɨl dɨrɨn̰ nan̰e. An̰ji ɓugdər mana gɨ dùwa lə me nimiyə me jwab jwab. ");
INSERT INTO sor_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Dee nə walagɨ gandɨw woni gɨrsə gwale dɨma gɨra nɨm me cendi nem gaba swaw daa bədə.» ");
INSERT INTO sor_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Mwom da, Jesu so way ba da: «ꞌYeni nare nə àcn̰e me nə kal dusɨrəng dɨnnə bədə me nə gá! Nə ha dama gandang àla wála ɨndi na mo? Nə ha ꞌwóng dɨn bam bɨraa mindi na mo? Walnan dwe di hane nɨm kwa!» ");
INSERT INTO sor_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Mwom da, Jesu ɨr̰ɨn̰ dúndi dɨ àcn̰e dɨ idɨ àla dwe jumgɨl di, me tandi gandɨ bam dwe di sɨwə me, mana gɨ ta lə dog da, dwe di kaw, ꞌyo labiya me ca. ");
INSERT INTO sor_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Mana gɨ woni gɨrsə gwale gɨnə Jesu duwa di worgɨ mɨ́ndagɨ gɨ Jesu da, cendi hára sɨwə ib me ùrɨw ba da: «I dana me nenin da, nə nyamanin ꞌywara dúndi dɨ ta di bam bədə mo?» ");
INSERT INTO sor_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Me Jesu cogɨ lə diiyə ba da: «I dara dusi dan dɨ kala Mãr̰ĩ dɨwə i ɓani. Dwayna, nə wayang i gwale sɨw: Dusi dan dɨ kala Mãr̰ĩ dɨwə di, ina i ɓani hin̰e ya habda gɨ mutardɨ dɨrəw de mɨra kaw, anə waynadɨ kur̰a dɨ ta di ba da: “Cɨm daa mana gɨ ka lə me ha dama mana gɨ alə ta lə” kaw, tandi ha cɨmə le. Mani mɨn nə ha nyama bɨləng àla da, ilə bədə. ");
INSERT INTO sor_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Me dúndi dɨ ya ta de di da, gɨ ꞌyordɨ bam gun sɨwə i gɨ amsa gɨ Mãr̰ĩ me gɨ ꞌwoo gɨ asiyam me.» ");
INSERT INTO sor_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Wála mɨn, mana gɨ woni gɨrsə gwale gɨnə Jesu duwa di dayar gandɨw dodə mɨn mana gɨ wama gɨ Galileyə da, an̰ji waygɨ ba da: «Ɨndi gɨ Gun gorndɨw di, gɨ ha ꞌyàn nare ɨsɨragɨ lə. ");
INSERT INTO sor_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Cendi ha ꞌyán bam me, wála gɨ subu lə da, nə ha dɨmə daa munɨ lə.» Mana gɨ woni gɨrsə gwale gɨnə Jesu duwa ba gɨ doy gwale gɨ ta di mwom da, sɨdəgɨ wagɨ le. ");
INSERT INTO sor_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ɨr̰ɨ, Jesu day gɨ nə woni gɨrsə gwale duwa di yalagɨ mana gɨ ciri dɨ Kapernommə. Mwom da, nare woni dáya lombo gɨnə kulu gaba bwasa Mãr̰ĩ hára Piyer sɨwə ib me ùrɨw ba da: «Ɓag da, aba ciri dan di ꞌyogɨ lombo gɨnə kulu gaba bwasa Mãr̰ĩ di bədə mo?» ");
INSERT INTO sor_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Piyer waygɨ ba: «An̰ji ꞌyogɨ le.» Me mana gɨ Piyer yala kɨrə da, Jesu so ùrɨw gwale gɨnə lombo di pii ba da: «Simõ, mə ɨrɨm i man mo? I nə wi me ꞌyogɨgɨ dolgə nə sɨn̰a dɨdə ka lombo di mo? I woni ciri labaa i nare nə mɨje mo?» ");
INSERT INTO sor_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","An̰ji cow lə diiyə ba da: «I nare nə mɨje.» Jesu wayɨw da: «Ladɨ. Me inam yande da, ladni duwa da, woni ciri dee ꞌyogɨgɨ lombo di bədə. ");
INSERT INTO sor_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Me nare woni dáya lombo gɨnə kulu gaba bwasa Mãr̰ĩ di ha ùrə yande bədə. Kal də mendɨgɨ dusɨrəgɨ bədə. Yande da, ha ūrə lə gɨ kuy mana gɨ kuray gɨ ɓɨleyə, me dòche gɨ mə ha yə̀w dɨrɨn̰ nə piiyə da, tɨn̰ bɨw bam me, mə ha ꞌywaa chile mɨn bɨwə. Udɨ, me ha ꞌywagandɨ lombo di bɨdəndɨ ca ɨnda lə.» ");
INSERT INTO sor_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Dawa dɨ ta lə di, woni gɨrsə gwale gɨnə Jesu duwa di hára Jesu sɨwə ib me ùrɨw ba da: «I wi ɓag me i geche nan̰ ɗoy bam ciri dɨ daa lə di mo?» ");
INSERT INTO sor_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ɨr̰ɨ, Jesu ꞌwaga dwe gɨ ꞌyəng gɨra chɨ́w dwar̰agɨ lə ");
INSERT INTO sor_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","me waygɨ da: «Dwayna, nə wayang i gwale sɨw: Anə kɨlangɨna ɨrmə dan bam kɨdɨnə ya dine nə ꞌyəng de bədə da, ganda dan gaba hára gɨ ciri dɨ daa lə da, ilə bədə bɨr̰ɨn̰. ");
INSERT INTO sor_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Me gun gɨ hurna dɨw dodə ya dwe gɨ ꞌyəng gɨ ta di de da, ha ꞌya i geche mana gɨ ciri dɨ daa lə. ");
INSERT INTO sor_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Gun gɨ yɨnə dwe gɨ ꞌyəng gɨ ya gɨ ta di de gɨ dwani gɨ sumɨn da, an̰ji yɨn i ɨndi gɨ dwani.» ");
INSERT INTO sor_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","«Chamran nə nem mani bədə nare dɨrəgɨ lə nə kal dusɨrəgɨ dɨnnə ta di, me gun gɨ lamna gun day gɨ mɨn dwar̰agɨ lə àsɨnaw àla gɨ àcn̰a lə da, gun gɨ ta di, gɨ manaw kur̰a dɨ jore dɨ nu nan̰ kunəwə me gɨ unəw àlnaw mana gɨ nimi nə kuray gɨ geche don duwa lə kaw, womme bədə sɨn̰. ");
INSERT INTO sor_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Nare nə sɨn̰a dɨdə ka, wamani ꞌyogɨ le, dara mani woni lama nare bwagɨ mana gɨ àla gɨ àcn̰a lə da, ilə nan̰e ꞌyang. Mani nə ta di da, ha ꞌya lə bá, ɗɨm da, gun gɨ hane gɨ mani nə ta di lamna gɨ kwandaw bwanagɨ àla gɨ àcn̰a lə di da, wamani ha ꞌywawe! ");
INSERT INTO sor_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Inam i ɨsəm mɨn labaa dɨgɨlam mɨn me lamnam àsɨnam àla gɨ àcn̰a lə da, sabɨgɨ bogɨ bam hən̰. Hára gɨ mana gɨ bɨlə gaba dama gɨ dɨrəw bɨr̰ɨn̰yə gɨ ɨsəm mɨn labaa gɨ dɨgɨlam mɨn da, ladɨ nan̰ ɗoy kala gɨ ɨsam lə ca labaa gɨ gɨdam lə ca me gɨ ha àsam nɨm mana gɨ dùwa dɨ ꞌywaa dɨra budə bam bədə bɨr̰ɨn̰yə di. ");
INSERT INTO sor_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Inam i dudɨm mɨn me lamnam àsɨnam àla gɨ àcn̰a lə da, biydɨ àsɨdɨ bam hən̰. Hára gɨ mana gɨ bɨlə gaba dama gɨ dɨrəw bɨr̰ɨn̰yə gɨ dudɨm mɨn da, ladɨ nan̰ ɗoy kala gɨ dɨrəm lə ca me gɨ ha àsam nɨm mana gɨ dùwa dɨ budə dɨra ilə bədə bɨr̰ɨn̰yə di. ");
INSERT INTO sor_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Àsɨna angal dan ladɨ le! Kalna àla gɨ gun mɨn gɨ nem mani bədə nare dɨrəgɨ lə gɨ ta di ichɨn̰ ɗi. Nə wayang i gwale sɨw: Paja nə daa woni gamagɨ ɗɨbɨ lə Aban gaba dama daa dɨrəwə bɨr̰ɨn̰ dɨban bwaa gɨ gwayni.» ");
INSERT INTO sor_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","«Dwayna, ɨndi gɨ Gun gorndɨw di, nə hára i dara kan̰ja nare nə nole dara ba nə ꞌyàgɨ́ bɨlə. ");
INSERT INTO sor_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Anə ɨrɨm i man mo? Gun mɨn ina i gɨ dɨmən̰je aru me dɨ mɨn ana nwalna bam da, an̰ji ha kala nə wor gɨnɨn̰ dunamɨn gɨ dii dunamɨn di mana gɨ kur̰a lə dara hára kan̰ja dɨ nol bam di bədə mo? ");
INSERT INTO sor_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Əw, dwayna, nə wayang i gwale sɨw: Dawa dɨ an̰ji ꞌywanadɨ da, an̰ji ha àla sii ꞌywala dara dɨmən̰ dɨ mɨn ta di ɗwaya nə gɨnɨn̰ dunamɨn gɨ dii dunamɨn nə nol bədə ta di bam. ");
INSERT INTO sor_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Yande da, Abɨrang gaba dama daa di kaw, ùr dara gun mɨn gɨ nem mani bədə nare dɨrəgɨ lə ta di, ba nwalna bam bədə.» ");
INSERT INTO sor_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«Chendɨm àlna àcn̰a da, ha mɨnam mɨn ꞌywaw wayaw àcn̰a duwa di bɨwə sɨr dannə. An̰ji dwayna gwale dɨma da, mə cwaw yala gandɨw sɨmmə bi. ");
INSERT INTO sor_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Me an̰ji dwayna gwale dɨma bədə da, wol gun mɨn labaa nare sɨr gandɨm me cwarna hana ꞌywanaw. Àl yande dara gwale pad gɨ anə ha wayaw da, kal nare sɨr labaa subu damna lə me dwayna me ca. ");
INSERT INTO sor_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","An̰ji gɨn̰ɨnə dwaya gwale day di bam da, ha wayagɨ nare nənə Mãr̰ĩ duwa nə dayar daa. Gun gɨ ta di gɨn̰ɨnə dwaya nare nənə Mãr̰ĩ duwa nə dayar daa di gwale day bam bi com da, yərɨw ya gun gaba àla àcn̰a nan̰ ya woni ꞌwacn̰a Mãr̰ĩ gɨ ɓag bədə me woni salaw dole gɨ geche gɨRom mani de me ca. ");
INSERT INTO sor_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Dwayna, nə wayang i gwale sɨw: Mani pad nə anə managɨ dodə sɨn̰a lə ka da, gɨ ha magɨ daa Mãr̰ĩyə me ca. Me mani pad nə anə awrɨnagɨ daa dodə sɨn̰a lə ka da, gɨ ha awragɨ daa alə daa me ca. ");
INSERT INTO sor_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Dwayna, nə wayang i gwale sɨw ɗang bi: Nare sɨr dwar̰angə sɨn̰a dɨdə ka gwale day bwarna mɨn me amsɨnaw nɨm gɨ Aban gaba dama daa mani da, an̰ji ha ꞌyàgɨ́ le. ");
INSERT INTO sor_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Dara mana gɨ nare sɨr labaa subu dayarna gɨ sumɨn ni ɨndi da, ɨndi kaw, nə ilə dwar̰agɨ lə me ca.» ");
INSERT INTO sor_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Mana gɨ ta lə da, Piyer chidɨ Jesu sɨwə ib me ùrɨw da: «Aba ciri ni, chendɨn àlna gandɨn àcn̰a da, nə ha kala dusɨn hɨlala dɨwə dii ɨndi na mo? Hana bɨraa dii wurgɨsubu mo?» ");
INSERT INTO sor_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesu cow wayɨw da: «Bədə, nə wayɨm: hana bɨraa dii wurgɨsubu mɨra bədə, me hana bɨraa dii gɨnɨn̰ wurgɨsubu gɨnɨn̰ wurgɨsubu dii wurgɨsubu. ");
INSERT INTO sor_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Dwayna, dwãr̰ĩ dɨ daa di, wun ya dole gɨ geche day gɨ nə kòy duwa de. Wála mɨn, dole di ꞌwaga kòy duwa ba hane waynaw mani nə cendi ba àl gɨ gursɨ duwa dɨ ɨsɨragɨ lə ta di. ");
INSERT INTO sor_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Mana gɨ an̰ji so dara āsa gursɨ di mwom da, gɨ háraw gɨ kwaya mɨn gɨ dee ha ꞌywagaw kwale gursɨ dɨ milyo gɨr̰ɨ nan̰ɗoy dɨw bam bɨr̰ɨn̰. ");
INSERT INTO sor_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Kwaya di ꞌyo mani woni ꞌywagaw di bədə mwom da, aba ciri duwa di u bɨw way da, cendi ba kɨlnəw bam day gɨ dyaməw ca me dɨndaw me mani duwa nə ꞌywaa pad me dara ꞌywaga gɨ kwale gɨ dɨwə di. ");
INSERT INTO sor_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ɨr̰ɨ, kwaya di so ɨndər dodə dole di gɨdawə me ɨbər dɨrəw dodə me nulbɨw ba: “Un dɨm bam hin̰e ɗe! Sawɨn wála me nə ha ꞌywagam kwale dɨma di pad.” ");
INSERT INTO sor_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Aba ciri duwa di dɨrəw ꞌyəngɨw me kalɨw an̰ju ba hana ma, kalɨw kwale di bam ɗɨm. ");
INSERT INTO sor_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Mana gɨ kwaya di dɨmə iche hin̰e mwom da, gɨra ꞌyo jaw kwaya gɨ dee ha ꞌywagaw kwale duwa gɨ ɓani. An̰ji yɨ bɨr̰ɨw duwa madad me soy ba da: “ꞌYogɨn kwale ni!” ");
INSERT INTO sor_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Jaw kwaya di so ɨndər dodə gɨdawə me nulbɨw ba da: “Un dɨm bam hin̰e ɗe! Sawɨn wála me nə ha ꞌywagam kwale dɨma di pad.” ");
INSERT INTO sor_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ɨr̰ɨ an̰ji gɨn̰ dwaya gwale duwa di bam. An̰ji ha gɨ jaw di àsaw dangeyə bɨraa jaw di ba ꞌywagɨnaw kwale duwa gɨ ta di bam bá do. ");
INSERT INTO sor_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Kwandagɨ kòy nə ɗang yər mani nə àlal ta di gɨ dɨrəgɨ. Cendi cor dɨrəgɨ ꞌyəngɨgɨ nan̰ me ha kɨbəw aba ciri day gwale di daa pad. ");
INSERT INTO sor_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Yande da, aba ciri day di ꞌwaga kwaya gaba àla mani nə ta di sɨwə me wayɨw: “Kwaya gɨ àcn̰e gá! Nə kalɨm kwale ni gɨ dɨmmə di bam dara mə nulbɨn nan̰e, ");
INSERT INTO sor_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","me mə yər dɨma jam kwaya di n̰agɨni duwa ya ba nə yara gɨ n̰agɨni dɨma ta de me bədə mo?” ");
INSERT INTO sor_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Aba ciri duwa di dusɨw so nan̰e. Ɨr̰ɨ, yɨw ꞌyàgɨ́ woni gama dange ɨsɨragɨ lə ba gɨlnəw dɨrəw dangeyə bɨraa an̰ju ba ꞌywagɨna kwale gɨ dɨwə di bam pad do.» ");
INSERT INTO sor_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Me Jesu àsɨ duwa lə diiyə ba da: «Gun gɨ we we gɨ kalna dusɨw hɨlalna chendɨw dɨwə gɨ dusi dɨ mɨn bədə da, Aban gaba dama daa kaw, ha àlang ya dole ba a àl gɨ kwaya duwa gɨ àcn̰e ta di de me ca.» ");
INSERT INTO sor_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Mana gɨ Jesu gɨl mani duwa nə ta di ꞌyen̰ bam mwom da, so kal wama gɨ Galile di me ha mana gɨ tulɨn̰ dɨ Judeyə dɨ i kuray gɨ Jurde dugdɨw dɨ alə ta lə. ");
INSERT INTO sor_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Nare nə gɨr̰e nan̰ pamɨw tarɨwə me mana gɨ ta lə di, an̰ji ilə swaa nare woni mwom daa. ");
INSERT INTO sor_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Mana gɨ ta lə da, nare nə gɨ ꞌwogɨgɨ Parise yab hára Jesu sɨwə ib me ùrɨw nɨm gwale gaba twaw dara dwaya gɨ gwale bɨwə dara ba gɨ yɨw nɨm. Yande da, cendi ùrɨw ba da: «Bii ɨnda gɨ ꞌwoo lə da, gɨ ꞌyàa bɨrmə dara abe ba ꞌywana gwale gɨ we we kaw, ba ꞌywarna gɨ deme bam mo?» ");
INSERT INTO sor_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ɨr̰ɨ an̰ji cogɨ lə diiyə waygɨ ba da: «Anə āsɨ gwale gɨ gɨ jangɨw Maktubu dɨnə Mãr̰ĩyə bədə mo? Gɨ jangɨ way da: Diyə gɨ mani gɨndəgɨ lə da, Aba bwaa mani di ɗar̰ɨ nare nə gɨsɨgədə abe me deme me ");
INSERT INTO sor_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ɨr̰ɨ an̰ji way da, ba i dara yande me abe ba ha swaa kala abəw me iw me bam me ba ha ɓamara gɨ dyaməw, me nare nə sɨr ta di cor gɨdɨ i gun mɨn ɗɨm. ");
INSERT INTO sor_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","I ta di me cendi i nare sɨr bədə me gɨdɨ i gun mɨn tenene ɗɨm. Yande da, mani nə Mãr̰ĩ day gɨ an̰ju da, kal gun anagɨ bam bədə.» ");
INSERT INTO sor_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Me nare nə Parise cor ùrɨw ɗang: «Ina yande da, dana me Moyis way gun ba ana gɨ dyaməw bam da, kal an̰ju ba ꞌyànadɨ maktubu dɨ idɨ agda bam ɨsədɨ lə mo?» ");
INSERT INTO sor_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesu cogɨ lə diiyə: «I dara dɨdəng wayni dɨra me Moyis kalang gɨ bɨrmə anə banə agdɨna nɨm gɨ namdang bam ta di. Me diyə gɨ mani gɨndəgɨ lə da, i ya ta de bədə. ");
INSERT INTO sor_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nə wayang daa: Gun gɨ ana gɨ dyaməw dɨ i gɨ abe gɨ ɗang bədə bam me unə dɨ ɗang da, an̰ji àl i àcn̰a gɨ gichɨni. I ya an̰ji ba i gɨ jaw dyaməw de.» ");
INSERT INTO sor_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ɨr̰ɨ, woni gɨrsə gwale gɨnə Jesu duwa di wayɨw da: «Gwale gɨnə abe day gɨ dyaməw ina yande da, ladni duwa da, ꞌwoo gɨ deme dee ina lə bədə.» ");
INSERT INTO sor_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesu cogɨ lə diiyə ba da: «Nare pad nem yəə gwale gɨ ta di bədə, me i cendi nə Mãr̰ĩ ꞌyàgɨ́ dwana dɨ idɨ yəə sɨdəgɨ di mɨra. ");
INSERT INTO sor_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Gwale gɨ jiga jiga gaba ɨməgɨ abje laya gɨ namde di ilə: Nə mɨn da, i nyama gɨ bədə yàa dayyə bá, nə mɨn da, i nare ɨmgɨ cendi, cendi piygɨ madɨrə, nə mɨn ɗang da, kal laya gɨ namde ɗi dara dwãr̰ĩ dɨ daa. Gun gɨ nyamna yəə gɨlə gɨ mani gɨ ta di da, a yɨnə!» ");
INSERT INTO sor_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ɓam mwom da, nare hára gɨ dine nə ꞌyəng ꞌyàw Jesu dara an̰ju ba bwana ɨsaw dɨdəgɨ lə me ba amsɨna Mãr̰ĩ daragɨ. Me woni gɨrsə gwale gɨnə Jesu duwa di sogdɨgɨ nare di le. ");
INSERT INTO sor_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Me Jesu duwa da, cor waygɨ woni gɨrsə gwale duwa di ba da: «Kalne dine di gɨ hane ꞌywanan, ɨmnəgɨ bam bədə. Dara i nare nə wun ya cendi de me nem dɨmə hára ciri dɨ daa lə di cendi.» ");
INSERT INTO sor_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Mwom da, Jesu bwaa ɨsaw dine dɨdəgɨ lə me ɨndər bɨrmə lə yá. ");
INSERT INTO sor_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Mwom da, dwe gɨ maché chidɨ Jesu sɨwə ib me ùrɨw ba da: «Aba gɨlənin mani, nə ha àla i na nə lade me nə ha ꞌywaa nɨm gɨ bɨlə gaba dama gɨ dɨrəw bɨr̰ɨn̰ di mo?» ");
INSERT INTO sor_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesu ùrɨw ba da: «Dana me mə ùrɨn gwale gɨnə mani nə lade di mo? Ina i dara ladni da, i gun mɨn tenene me i gɨ lade. I Mãr̰ĩ. Mə ùrnə ꞌywaa gɨ bɨlə gaba dama gɨ dɨrəw bɨr̰ɨn̰ di da, àl bii gɨ ꞌwoo gɨnə Moyis duwa di.» ");
INSERT INTO sor_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Dwe gɨ maché di cor ùr Jesu ba da: «Nə ha àla bii duwa gɨ ꞌwoo di i gɨ man man mo?» Jesu cow lə diiyə ba: «Ladɨ, mə ha ꞌyáa gun gɨ ùrə dɨma bədə, mə ha kan̰ja gun dyaməw bədə, mə ha mĩyə bədə, mə ha sawaw gun gwale àsaw dɨwə bədə. ");
INSERT INTO sor_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Àlgɨ nə abam day gɨ im horɨmbə me, ùr jam gun ya sɨm dɨma gang de me ca.» ");
INSERT INTO sor_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ɨr̰ɨ dwe gɨ maché di wayɨw da: «Mani nə pad ta di, nə àlgɨ ɗɨm. Me i na me wor gɨ nə ha àla ɗang mo?» ");
INSERT INTO sor_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesu wayɨw ba da: «Mə ùrnə ba mə ina i gun gɨ lade nan̰ bɨr̰ɨn̰ da, ha mə ha kɨlə mani dɨma nə ꞌywaa bam, me gursɨ day da, ɨsɨgɨ nare nə bugɨr. Yande me, mə ha ꞌywaa mani nə ꞌywaa daa Mãr̰ĩ sɨwə sɨn̰. Me hare, pam tarɨn.» ");
INSERT INTO sor_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Mana gɨ dwe gɨ maché di ba a doy Jesu gwale duwa gɨ ta di mwom da, sɨw mar bam ledede me ɨndər yá, dara an̰ji, mani duwa nə ꞌywaa di ꞌyarbar nan̰e. ");
INSERT INTO sor_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Mwom da, Jesu waygɨ woni gɨrsə gwale duwa ba da: «Dwayna, nə wayang i gwale sɨw: Gun gaba ꞌywaa mani da, ganda duwa gaba hára gɨ ciri dɨ daa lə da, womɨw nan̰e. ");
INSERT INTO sor_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","I sɨdɨ, nə wayang bi: Jambal dɨmnə libara gaba busə mani gubu duwa lə kaw, wom bədə sɨn̰. Me gun gaba ꞌywaa mani da, ganda duwa gaba hára gɨ ciri dɨ daa lə da, wom nan̰ ɗoy bam.» ");
INSERT INTO sor_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Mana gɨ woni gɨrsə gwale duwa di ba gɨ doy yande da, gwale di ɗoy dɨdəgɨ me, cendi wajɨ ba da: «Me ina i yande da, i wi me ha nyama ꞌywaa bɨlə di mo?» ");
INSERT INTO sor_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Mwom da, Jesu yərbɨgɨ me waygɨ ba da: «Nare da, wom ɗoy dɨdəgɨ le, me Mãr̰ĩ da, mani mɨn nə ɗoy dɨw da, ilə bədə.» ");
INSERT INTO sor_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ɨr̰ɨ Piyer wayɨw ba da: «Me nenin da, nə kalanin mani pad bam taraninnə dara pama tarɨm. Nin da, ha ꞌya i man mo?» ");
INSERT INTO sor_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesu waygɨ ba da: «Dwayna, ꞌyeni nə anə pama tarɨn di, nə wayang i gwale sɨw: Wála gɨ Mãr̰ĩ dara cwaa daa me sɨn̰a me dɨrway da, ɨndi gɨ Gun gorndɨw di nə ha dama mana gɨ gage ni gɨ dwãr̰ĩ gaba sumiyə di. Mwom da, ꞌyeni di kaw, anə ha dama gagege nə dwãr̰ĩ nə mwaj dii sɨrrə àlagɨ́ nare nə Israyel gangle day gɨ mwaj dii sɨr di sariya. ");
INSERT INTO sor_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Nare pad nə swaa kala ciri day, labaa chamragɨ nə abje labaa nə namde, labaa abɨragɨ labaa igɨrəgɨ, labaa dɨndɨragɨ labaa dàge day bam dara sumɨn ɨndi da, cendi ha ꞌywaa mani nə ta di dii aru me ha ꞌywaa bɨlə gaba dama gɨ dɨrəw bɨr̰ɨn̰ di le me ca. ");
INSERT INTO sor_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ɨr̰ɨ nare nan̰ nə caga i pii cendi da, ha cwara ꞌya i nə targɨn̰ dwar̰agɨ lə, me nare nan̰ nə caga i targɨn̰ da, ha cwara ꞌya i nə pii dwar̰agɨ lə me ca.» ");
INSERT INTO sor_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","«Yarna, dwãr̰ĩ dɨ daa da, wun i ya mani nə nə ilə wayang gandagɨ lə ta de: Aba ciri gaba daga mɨn gandɨ gɨ jomni cor̰ər̰ə dara laya nare woni àlaw giyə daga duwa gɨ yabɨr̰a lə. ");
INSERT INTO sor_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Mana gɨ an̰ji ꞌyo nə yab mwom da,  an̰ji waygɨ ba ha ꞌywagagɨ wi kaw, gursɨ dɨ idɨ ꞌywagaw gun mɨn gwayni duwa gɨnə giyə gɨ àla hɨrmə mɨn dalawə di, me cendi ùre. Ɨr̰ɨ, an̰ji giygɨ mana gɨ daga duwa lə di. ");
INSERT INTO sor_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ɓam gɨ dawa bɨdə dɨ jomni da, an̰ji gandɨ iche bi me yər nare nə ɗang nə dam pəgɨn̰ mana gaba dayara lə ");
INSERT INTO sor_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","me waygɨ ba da: “ꞌYeni di kaw, hana àlnan giyə daga ni gɨ yabɨr̰a lə di me, nə gɨra ha ꞌywagang gwayni dan gɨ bɨrmə duwa.” ");
INSERT INTO sor_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Me cendi hargɨ giyə lə di. Gɨ dawa dɨ ciri dwar̰ɨ lə da, aba ciri di gandɨ iche ɗang bi me yər nare nə ɗang nə dam pəgɨn̰ mana gaba dayara lə me giygɨ mana gɨ daga duwa lə me waygɨ ba a ha ꞌywagagɨ gɨ bɨrmə duwa. Gɨ dawa dɨ pagare kaw, an̰ji àl yande me. ");
INSERT INTO sor_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Targɨn̰ ɗang kaw, gɨ dawa yá ꞌyan̰a nɨm bam ɗɨm, an̰ji gandɨ iche ɗang bi me, yər nare nə ɗang dama lə pəgɨn̰ mana gaba dayara lə me an̰ji ùrgɨ ba da: “Dana me anə dam hɨrɨm mana gɨ ka lə di dɨban àla gɨ mani mo?” ");
INSERT INTO sor_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Me cendi cow lə diiyə ba da: “I dara gun mɨn layanin giyə gɨ àla lə di bədə.” Mwom da, aba ciri di waygɨ da: “ꞌYeni di kaw, hana àlnan giyə mana gɨ daga ni gɨ yabɨr̰a lə di me.” ");
INSERT INTO sor_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Mana gɨ dawa ɗwanda dɨra lə da, aba ciri di wayɨw aba gamaw gursɨ duwa ba da: “ꞌWagay woni àlan giyə di kwa sɨmmə. ꞌYogɨgɨ wi kaw gursɨ duwa bá bá, diy gɨnɨn̰ ꞌyogɨgɨ cendi nə dee nə laygɨ giyə lə targɨn̰ des di bɨraa mə ha ꞌyan̰a nɨm gɨ cendi nə dee nə laygɨ pii di.” ");
INSERT INTO sor_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Yande mwom da, cendi nə dee gɨ laygɨ gɨ dawa ꞌyan̰a dɨra lə di, wi kaw hára ꞌyo gursɨ dɨ idɨ ꞌywagaw gun mɨn gwayni duwa gɨnə giyə gɨ àla hɨrmə mɨn dalawə pad. ");
INSERT INTO sor_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Mana gɨ cendi woni àla giyə nə dee gɨ laygɨ giyə lə pii hára dara ꞌwoo gursɨ day da, cendi ɨrmə dusɨrəgɨ lə ba gɨ ha ꞌywaa nan̰ ɗwaya kwandagɨ bam. Ɨr̰ɨ gɨ ꞌyàgɨ́ wi kaw gursɨ dɨ idɨ ꞌywagaw gun mɨn gwayni duwa gɨnə giyə gɨ àla hɨrmə mɨn dalawə di me ca. ");
INSERT INTO sor_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","12","Mana gɨ cendi ilə ꞌwoo gursɨ dayyə di da, sɨdəgɨ ꞌyolgɨ bədə me, cendi n̰amdɨ gwale bulə dayyə me wayɨw aba ciri di ba da: “Woni àla giyə nə ta di hára targɨn̰ cendi, àl giyə ɓam yande mɨra, me ɨr̰ɨ mə ꞌyogɨgɨ gursɨ bor gɨ nenin nə nə àlnin giyə nan̰ gɨ jomni bɨraa hɨrɨm daa dawa dɨrədɨ lə. Ta di ladɨ mo?” ");
INSERT INTO sor_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Me aba ciri di cow gun gɨ mɨn dwar̰agɨ lə lə diiyə wayɨw ba da: “Jan maché, nə àl gandɨm i mani nə àcn̰e bədə. Gursɨ dɨ idɨ ꞌywagaw gun mɨn gwayni duwa gɨnə giyə gɨ àla hɨrmə mɨn dalawə di da, dee mə ùrə le bədə mo? ");
INSERT INTO sor_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Yande da, u mani dɨma me ha mana dɨma lə. Dusɨn ùr ꞌyàw an̰ju gɨ hára giyə lə targɨn̰ di gursɨ ya ɨjɨm de, me dolɨm na mo? ");
INSERT INTO sor_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ɨndi di, nə nem gaba àla gɨ mani ni nə ꞌywaa mani nə dɨrən ùr bədə mo? Labaa, mə àl i halgɨni dara ladni ni gɨ nə àl di mo?”» ");
INSERT INTO sor_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Mana gɨ ta lə da, Jesu waygɨ nare ba da: «Gwale gɨ nə wayang ba nare nə caga i pii cendi da, ba ha cwara ꞌya i nə targɨn̰, me nare nə caga i targɨn̰ da, ba ha cwara ꞌya i nə pii me ca da, ha ꞌya yande.» ");
INSERT INTO sor_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Cendi ilə bɨrmə lə nagɨgɨ dara hára Jursalem da, Jesu wol woni gɨrsə gwale duwa nə mwaj dii sɨr di mɨ́ndagɨ me waygɨ ba da: ");
INSERT INTO sor_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Dwayna, də ilə nagang hárang i Jursalem. Mana gɨ ciri dɨ ta lə di me ɨndi gɨ Gun gorndɨw di, gɨ ha yə̀n ꞌyàgɨ́ woni bwasa Mãr̰ĩ gechide day me woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa me ɨsɨragɨ lə. Cendi ha ma bɨdəgɨ dara ba gɨ ꞌyánan, ");
INSERT INTO sor_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","me gɨra ha ꞌyàgɨ́ nare nə i Juwib bədə ɨsɨragɨ lə dara cendi ba àlnan məng me ba gwabɨnan gɨ bɨr̰aw me ba ɓyangɨnan ɓabɨr̰ɨnan daa habda gɨ dagɨla sɨwə. Me wála gɨ subu lə da, nə ha dɨmə daa munɨ lə me ca.» ");
INSERT INTO sor_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Mwom da, Jebede dyaməw chidɨ gɨ dɨndadɨ nə sɨr nə Jak day gɨ Jã di Jesu sɨwə ib me gɨra piy gubɨrədɨ dodə dɨrəwə dara amsaw gɨ mani. ");
INSERT INTO sor_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesu waydɨ da: «Də ùr i na mo?» Tandi wayɨw ba da: «Yər dɨndan nə sɨr ta di. Wála gɨ mə dara dama dwãr̰ĩ dɨma lə da, kal gun mɨn damna ɨsəm gɨ abeyə me, gɨ mɨn ɨsəm gɨ jeleyə me ca.» ");
INSERT INTO sor_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesu waygɨ dine nə sɨr di ba da: «ꞌYeni da, mani nə anə amsɨgɨ ta di da, anə ꞌwocn̰ gɨndəgɨ bədə. Gaa gɨlə gɨ dɨrɨn̰ gɨ nə ha gɨləw di da, anə ha nyamaw mɨnang mo?» Cendi wayɨw ba: «Nə hanin nyama le.» ");
INSERT INTO sor_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesu cor waygɨ da: «I sɨdɨ. Anə ha gɨlə dɨrɨn̰ gɨ nə ha gɨləw di le. Me dara mana dan gaba dama, gun mɨn ɨsən gɨ abeyə me gɨ mɨn ɨsən gɨ jeleyə me da, nə nem ɨrməng gandɨw ɨndi bədə. Mana gɨ ta di igɨ i nare nə Aban gɨ Mãr̰ĩ ɗangr̰ɨgɨ gandɨw di day.» ");
INSERT INTO sor_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Mana gɨ woni gɨrsə gwale duwa nə wor mwaj di ba gɨ doy yande da, dusɨrəgɨ nagɨ nə Jak day gɨ chendɨw gɨ Jã dɨdəgɨ lə. ");
INSERT INTO sor_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Mwom da, Jesu ꞌwagagɨ sɨwə pad dayyə me waygɨ ba da: «Anə ꞌwocn̰ com dara dolgə nənə nare nə sɨn̰a gɨndɨdɨ lə pad da, cendi bɨl nare day ya ba gɨ i woni ciri day de. Me nare woni dwana kaw, gɨlgɨ kwandagɨ nə nare dɨrəgɨ me ca. ");
INSERT INTO sor_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Me bulə dannə da, kal ina yande bədə. Ladni duwa da, gun gɨ ùrnə ba a ina geche dan da, kal a ina aba kɨjəgɨ kwandaw. ");
INSERT INTO sor_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Gun gɨ ùrnə ba a ina i gɨ pii bulə dannə an̰ju da, kal a cwarna kwaya dan. ");
INSERT INTO sor_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","I yande me ɨndi gɨ Gun gorndɨw di kaw, nə hára i dara nare ba wanannə cendi bədə, me nə hára i dara wagɨ gɨ nare lə ɨndi me ꞌwoo gɨ sɨn ꞌyàdɨ made dara kɨdə gɨ nare nan̰ daa me ca.» ");
INSERT INTO sor_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Mana gɨ Jesu day gɨ nə woni gɨrsə gwale duwa dɨmgɨ bam ciri dɨ Jeriko lə dara hára da, nare nə gɨr̰e nan̰ pam tarɨw. ");
INSERT INTO sor_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Mana gɨ ta lə da, nare nə dɨrəgɨ bu sɨr dam ilə bɨrmə dugdɨwə. Mana gɨ cendi doy dara ba i Jesu me ba ha hára jàa gɨ ka da, cendi sojɨ mar̰ɨjagɨ daa ba da: «Aba ciri nin! Aba ciri nin! Dole gɨ Dabid mwàw! Yər n̰agɨni nin ɗe!» ");
INSERT INTO sor_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Nare nə gɨr̰e di àlgɨ gwale ba ɗyasɨna bɨdəgɨ daa. Ɨr̰ɨ, cendi sojɨ mar̰ɨjagɨ daa nan̰ ɗoy gɨ pii bam bi ba da: «Aba ciri nin! Aba ciri nin! Dole gɨ Dabid mwàw! Yər n̰agɨni nin ɗe!» ");
INSERT INTO sor_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jesu ɗɨbɨ dodə me ꞌwogɨgɨ ùrgɨ ba da: «Anə ùr ba nə àlnang i na mo?» ");
INSERT INTO sor_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Cendi wayɨw da: «Aba ciri nin, tin̰ɨnin dɨrənin bam!» ");
INSERT INTO sor_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesu yər n̰agɨni day me ɓɨlbɨ dɨrəgɨ di. Mana gɨ ta lə dog, cendi yərbɨ mana pəgɨn̰ pɨrang pɨrang, me cendi pam tarɨw. ");
INSERT INTO sor_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ɨr̰ɨ Jesu day gɨ nə woni gɨrsə gwale duwa chidəgɨ yala ib gɨ ciri dɨ dwe dɨ Betɨpage dɨ i ciri dɨ geche dɨ Jursalem tuldɨ lə ib. Cendi hargɨ ɨjɨ kur̰a dɨ Olib lə. Mwom da, Jesu giy woni gɨrsə gwale duwa sɨr pii dɨrəwə. ");
INSERT INTO sor_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","An̰ji waygɨ ba da: «Hana mana gɨ ciri dɨ ꞌya dɨrəngə ta di. Anə gɨrnə lə da, anə ha ꞌywaa kura dɨ deme gɨ dwe dɨra gɨndɨdɨ lə, gɨ madɨ ɗɨbɨ lə. Awrɨnadɨ daa, hane gandɨdɨ ꞌyànan. ");
INSERT INTO sor_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Me gun ùrnəng anə banə àl yande dana mo da, waynaw da: “I Aba ciri nin me ùr an̰ju.” Mwom da, gun gɨ ta di ha kalang anə hára gandagɨ le kaláng me ca.» ");
INSERT INTO sor_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ta di me i mani nə tanga Mãr̰ĩ wayɨw aba cɨmə bɨw gwale day di me yala àlal kɨrab. An̰ji way da: ");
INSERT INTO sor_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Waynagɨ nare nə ciri dɨ gɨ ꞌwogɨdɨ Siyõda: Yarna, dole dan gɨ geche yala dara darang ꞌyeni. An̰ji i aba angal, an̰ji ajila kura dɨdə, me dwe dɨra dɨwə me ca. ");
INSERT INTO sor_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Woni gɨrsə gwale gɨnə Jesu duwa di hargɨ me cendi ha àla mani di ya an̰ji ba ɨrməgɨ nɨm de. ");
INSERT INTO sor_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Cendi hára gɨ kura dɨ deme di me dwe dɨra di me, ɨr̰ɨ cendi darbɨgɨ barge day taragɨ lə me Jesu ajil dam lə diiyə. ");
INSERT INTO sor_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Mana gɨ ta lə da, nare nə gɨr̰e nan̰ ilə me ca. Nə yab dwar̰agɨ lə da, darbɨ barge day dodə bɨrmə dalawə, me nə mɨn da, saba day habde bajɨragɨ basɨ dodə bɨrmə lə me ca. ");
INSERT INTO sor_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Nare woni hára pii Jesu dɨrəwə me woni pama tarɨw me da, sojɨ day r̰ur̰u ba da: «Sumi gɨ ꞌwaga i dole gɨ Dabid mwàw duwa! Kal Aba ciri gɨ Mãr̰ĩ biynəw an̰ju gɨ hára lə gɨ sumɨw di bɨw dɨwə, biynəw bɨw dɨwə. Sumi gɨ ꞌwaga i Mãr̰ĩ gaba dama daa cog duwa!» ");
INSERT INTO sor_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Mana gɨ Jesu yala mana gɨ Jursalem ɗɨm da, nare nə ciri dɨdə pad sɨdəgɨ sadɨgɨ le dara hára yara me cendi ùrbɨ sɨdəgɨ ba da: «Gun gɨ ta di i wi mo?» ");
INSERT INTO sor_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Me nare nə gɨr̰e woni bwaw di cogɨ lə diiyə ba da: «I aba cɨmə Mãr̰ĩ bɨw gɨ Jesu gɨ Najaret dɨ wama gɨ Galileyə di.» ");
INSERT INTO sor_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Targɨn̰ ɗang da, Jesu gandɨ ha ciri dwar̰ɨ dɨ kulu gaba bwasa Mãr̰ĩ ilə di. Mana gɨ ta lə di, an̰ji yər nare woni kɨlə mani bam me woni kɨlə me ilə, me an̰ji so ilə ꞌywaragɨ lə pad. An̰ji togdɨgɨ woni kɨlanga gursɨ tabɨl day bam me, woni kɨlə kogəl bam kaw, lesɨrɨgɨ gagege day bam me ca. ");
INSERT INTO sor_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Me an̰ji waygɨ ba da: «Mãr̰ĩ way mana gɨ Maktubu duwa lə ba da: Gɨ ha ꞌwaga kulu ni di ba i kulu gaba amsa Mãr̰ĩ. Me ɨr̰ɨ ꞌyeni dan da, anə cow dan mana gaba budə gɨnə miidi day.» ");
INSERT INTO sor_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Mwom da, nare nə dɨrəgɨ bu me nə majɨgəndɨ me chidɨbə daa Jesu sɨwə ib ib hára ꞌyow ciri dwar̰ɨ dɨ kulu gaba bwasa Mãr̰ĩ ilə di, me an̰ji ꞌyàgɨ́ labiya. ");
INSERT INTO sor_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Dine kaw ilə, cendi ilə swaja lə ba da: «Sumi gɨ ꞌwaga i dole gɨ Dabid mwàw duwa!» Mana gɨ woni bwasa Mãr̰ĩ gechide day me woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa me yər mani nə dan̰a nə Jesu àlgɨ̀ ta di me doy dine di ilə swaja lə me da, dusɨrəgɨ womgɨ le, ");
INSERT INTO sor_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","me cendi wayɨw Jesu ba da: «Gaa mə doy gwale gɨ cendi nə dine wayɨw ta di mo?» Me Jesu di cogɨ lə diiyə ba da: «Əw, nə doy, me ꞌyeni da, dii mɨn anə āsa gwale gɨ gɨ jangɨw mana gɨ Maktubu dɨnə Mãr̰ĩyə di bədə ɓa? Gɨ jangɨw ba da: I dine nə ꞌyəng me dine nə man̰ me mə ꞌyàgɨ́ jilay di bɨdəgɨ lə cendi ba bwanam nɨm.» ");
INSERT INTO sor_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ɨr̰ɨ an̰ji kalgɨ mana gɨ ta lə me so dɨm kal ciri dɨ geche dɨ Jursalem di bam me ha mana gɨ ciri dɨ Betani wála lə. ");
INSERT INTO sor_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Sanga gɨ jomni cor̰ər̰ə da, Jesu cwara dara hára ciri dɨ geche dɨ Jursalemmə bi, me cherni àlɨwe. ");
INSERT INTO sor_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Mwom da, an̰ji yər dwaga dam lə mana gɨ bɨrmə dugdɨwə me, an̰ji chidɨ hára gɨndɨdɨ lə me ꞌyo yàa dɨra bədə, i bajadɨ mɨra. Mwom da, an̰ji sɨrgɨ dwaga di ba da: «Caga ka da, də ha yàa ɗang bədə bɨr̰ɨn̰!» Mana gɨ ta lə di dog, dwaga di so woy bam kwam. ");
INSERT INTO sor_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Woni gɨrsə gwale duwa di ba gɨ yər yande da, ɨrɨmdɨ gwale nan̰e me way ba da: «I man me dwaga di so woy bam mana gɨ ta lə dog yande mo?» ");
INSERT INTO sor_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ɨr̰ɨ Jesu cogɨ lə diiyə waygɨ ba da: «Dwayna, nə wayang i gwale sɨw: Wála gɨ anə kalna dusɨrəng Mãr̰ĩ dɨwə dɨban gaga gɨ gwale dusɨrəngə mwom da, anə ha nyama àla mani nə nə àl gɨ dwaga ta di me ca. Me i mani nə ta di mɨra bədə. Anə waynadɨ kur̰a dɨ ta di ba biyarna daa mana gɨ ka lə di ba cɨmnə daa hana ɨndarna kuray gɨ geche dalawə kaw, mani nə ta di ha àlala le. ");
INSERT INTO sor_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Mani nə we we nə anə amsɨnaw Mãr̰ĩ me anə kalna dusɨrəng dara an̰ji ba ha ꞌyànge da, anə ha ꞌywagɨ le.» ");
INSERT INTO sor_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jesu gandɨ ha kɨrə ciri dwar̰ɨ dɨ kulu gaba bwasa Mãr̰ĩ ilə di me ilə gɨlə maniyə. Mana gɨ ta lə da, woni bwasa Mãr̰ĩ gechide day me gechide nənə nare nə Juwib day me chidɨbə hára Jesu sɨwə ib ib me ùrbɨw ba da: «I gɨ dwana dɨ we me mə àl nɨm gɨ mani nə ta di mo? I wi me ꞌyàm bɨrmə me mə àl nɨm gɨ mani nə ta di mo?» ");
INSERT INTO sor_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesu waygɨ ba da: «Ɨndi kaw, nə ha ùrəng gwale mɨn tenene ka sɨn̰. Anə cwanan lə diiyə da, ɨndi kaw, nə ha wayang dwana ni dɨ nə àl gɨ mani nə ta di sɨn̰ me ca. ");
INSERT INTO sor_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","I wi me giyə Jã gɨra àlgɨ nare batem di mo? I Mãr̰ĩ, labaa i nare nə gɨsɨgədə mo?» Mwom da, cendi ilə wajɨba gwale bulə dayyə ba da: «Də cwanaw ɨnda lə diiyə ba i Mãr̰ĩ da, an̰ji ha wayandɨ ba də yə̀ng gwale gɨ Jã wayɨw di bədə, dana mo? ");
INSERT INTO sor_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Me də waynang ba i nare nə gɨsɨgədə da, də lán̰gɨ ɨnda i nare nə gɨr̰e di, dara cendi pad ɨrɨm dara Jã ba i aba cɨmə Mãr̰ĩ bɨw.» ");
INSERT INTO sor_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Mwom da, cendi cor wayɨw Jesu di da: «Nə ꞌwocn̰ɨnin bədə.» Me an̰ji waygɨ da: «Yande da, ɨndi kaw, nə ha wayang dwana ni dɨ nə àl nɨm gɨ mani nə ta di bədə me ca.» ");
INSERT INTO sor_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesu waygɨ gwale gɨ ɗang: «Anə ɨrɨm man dara gwale gɨ nə ilə wayaw lə ka di mo? Abe mɨn i gɨ dine sɨr. An̰ji ha wayɨw gorndɨw gɨ pii ba da: “Gorndɨn, laba da, ha àla giyə mana gɨ daga ni gɨ yabɨr̰a lə di!” ");
INSERT INTO sor_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Gorndɨw di cow lə diiyə ba da: “Nə ùr bədə”, ɨr̰ɨ targɨn̰ ɓam da, an̰ji ɨrɨm gwale duwa di me co dusɨw me so ha mana gɨ daga lə di. ");
INSERT INTO sor_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Abe di ɨr̰ɨ chidɨ hára wayɨw gorndɨw gaba dii sɨrrə di yande me ca. Gorndɨw di wayɨw da: “Əw, aban, nə ha le”, me ɨr̰ɨ gɨn̰ hára bam.» ");
INSERT INTO sor_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Jesu ùr nare di ba da: «Dine nə sɨr ta di dwar̰agɨ lə da, i gɨ we me yɨ gwale abəw di bɨwə mo?» Cendi cow lə diiyə ba da: «I gɨ pii ta di.» Mwom da, an̰ji waygɨ ba da: «Dwayna, nə wayang i gwale sɨw: Nare woni salaw dole gɨ geche gɨRom mani me nare woni kaya me da, ha ganda hára mana gɨ ciri dɨnə Mãr̰ĩyə di dɨrəngə pii cendi. ");
INSERT INTO sor_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Dara Jã Batis di hára ꞌywang dara gɨləng bɨrmə gɨ tɨba, me anə yəə gwale duwa bədə. Ɨr̰ɨ i nare woni salaw dole gɨ geche gɨ Rom mani me nare woni kaya me cwara yəə gwale duwa cendi. Me ꞌyeni da, anə yara cendi yəə gwale gɨnə Jã duwa gɨ dɨrəng ladɨ ta kaw, anə co dusɨrəng dara yəə gɨ gwale duwa bədə com.» ");
INSERT INTO sor_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","«Dwayna gwale gɨ diri ɗang bi: Abe mɨn daga duwa ilə, me an̰ji ɗɨlbɨ yabɨr̰a lə me jə̀ daga di daa me ca. An̰ji ɗangr̰ɨ mana gaba chidə gɨ nimi duwa. An̰ji aw mana hoo daa dara ɗɨbə gamaw nɨm me ca. Targɨn̰ ɗang da, an̰ji kalgɨ daga di woni àla giyə ɨsɨragɨ lə me yá mɨjəniyə. ");
INSERT INTO sor_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Mana gɨ wála gaba cəə yabɨr̰a yàa duwa di nem mwom da, aba ciri di giygɨ woni àla giyə gɨnə yabɨr̰a di kòy duwa, dara cendi ba junəw yabɨr̰a yàa duwa di me ba kalna day me ca. ");
INSERT INTO sor_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ɨr̰ɨ woni àla giyə gɨnə yabɨr̰a di yɨbɨ kòy nə ta di dodə, gobɨ gɨ mɨn me ꞌyə gɨ mɨn ɗang bam me jər gaba subu gɨ kur̰a ꞌyəw bam me ca. ");
INSERT INTO sor_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Yande da, aba ciri gaba yiga di giygɨ kòy nə ɗang gɨr̰ɨ nan̰ ɗoy nə pii bam kaw, woni àla giyə gɨnə yabɨr̰a di àlagɨ̀ ya ba gɨ àl nɨm nə pii di de. ");
INSERT INTO sor_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Mani nə ta di pad taragɨ lə da, an̰ji giy gɨ gorndɨw gɨ nudəw, me ɨrɨm dusɨwə ba gorndɨw da, cendi ba ha yə̀w jawe som. ");
INSERT INTO sor_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Cor mana gɨ woni àla giyə gɨnə yabɨr̰a di ba gɨ yər gorndɨw mwom da, cendi wajɨbɨ gwale bulə dayyə ba da: “Ta di me i aba wama dɨba duwa sanga di! Hane, ꞌyánandɨ gandɨw bam, me dɨba di ha warandɨ ɨnda.” ");
INSERT INTO sor_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Me cendi yɨw surɨw ha nɨm bam iche daga di tarɨwə me, ꞌyəw bam.» ");
INSERT INTO sor_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Mana gɨ ta lə da, Jesu ùr nare woni dwaya gwale duwa di ba da: «Yande da, wála gɨ aba ciri gaba yabɨr̰a di gɨrnay da, an̰ji ha àla woni àla giyə gɨnə yabɨr̰a nə ta di man mo?» ");
INSERT INTO sor_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Nare cow Jesu lə diiyə ba da: «An̰ji ha ꞌyágɨ bam, dɨrəw ha ꞌyangaw dɨdəgɨ lə bədə, dara dusɨrəgɨ àcn̰e. Ɨr̰ɨ, an̰ji ha ꞌwoo daga di ꞌyàgɨ́ woni àla giyə nə ɗang ɨsɨragɨ lə. Cendi nə ta di ha ꞌyàw yàa duwa wála gɨ naa duwa lə.» ");
INSERT INTO sor_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Me Jesu cor waygɨ da: «Dii mɨn, anə āsa gwale gɨ gɨ jangɨw mana gɨ Maktubu dɨnə Mãr̰ĩyə bədə mo? Gɨ jangɨw ba da: Kur̰a dɨ woni awa kululi gɨn̰dɨ bam di yala gɨdɨ kur̰a sɨdɨ dɨ lade dɨ idɨ yəə kulu di daa tandi. I Aba ciri gɨ Mãr̰ĩ me àl mani nə ta di an̰ju. I mani nə lade nan̰ nə ɗoy dɨdəndɨ bam me Mãr̰ĩ àlgɨ me dɨ yarang gandagɨ gɨ dɨrəndɨ ta di.» ");
INSERT INTO sor_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Me Jesu waygɨ da: «I dara ta di me nə wayang gwale daa wang: ꞌYeni da, gɨ ha ꞌywarang bam mana gɨ ciri dɨnə Mãr̰ĩyə di me, gɨ ha bwaa nare nə ɗang woni dwaya gwale bɨwə me ꞌwoo àla gɨ giyə lə cendi. ");
INSERT INTO sor_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Me gwale gɨnə kur̰a dɨra da, gun gɨ we we gɨ ɨndarna kur̰a dɨ ta di dɨdə da, dɨw ha ichara bam, me gun gɨ tandi ɨndarna dɨwə da, tandi ha dɨlan̰aw bam mɨgɨlag me ca.» ");
INSERT INTO sor_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Mana gɨ woni bwasa Mãr̰ĩ gechide day me, nare nə gɨ ꞌwogɨgɨ Parise me, doy gwale gɨ diri gɨ Jesu wayɨw di da, cendi ꞌwocn̰ com dara an̰ji ba way gwale di i dara daragɨ cendi. ");
INSERT INTO sor_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Me cendi kan̰jɨ bɨrmə dara ba gɨ yɨ nɨm gɨ Jesu, me cendi lán̰gɨ i nare nə gɨr̰e di, dara Jesu di, cendi ɨrmɨw ba i aba cɨmə Mãr̰ĩ bɨw. ");
INSERT INTO sor_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ɨr̰ɨ Jesu waygɨ gwale gɨ diri ɗang bi ba da: ");
INSERT INTO sor_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Dwãr̰ĩ dɨ daa da, wun i ya dole gɨ geche mɨn ba àlɨw gɨ gorndɨw dyamdɨrani ta de. ");
INSERT INTO sor_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Dole di giy kòy duwa ba hana ꞌwagɨna nare nə ba a ꞌwogɨgɨ pii di ba haneye dyamdɨraniyə di ɗɨm. Me nare di gɨn̰ə hára bam. ");
INSERT INTO sor_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","An̰ji giy kòy duwa nə ɗang bi ba hana waynagɨ nare nə ba ꞌwogɨgɨ pii di ba da: “Caga da, nə ɗorbɨ mani nə wama nə dyamdɨrani di naa le ɗɨm. Nə kunbɨ labje ni me mani nə paga nə ənbe woni swani me ca. Mani nə wama di pad naa le ɗɨm. Yande da, haneye dyamdɨraniyə di ɗɨm!” ");
INSERT INTO sor_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Me nare di àsɨ dɨdəgɨ lə bədə, me cor yá mana day gɨ dɨrəgɨ ùr. Gɨ mɨn yá daga lə me, gɨ mɨn yá àla kenge duwa lə me, ");
INSERT INTO sor_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","nare nə wor da, yɨbɨ kòy di gɨlgɨ dɨrəgɨ me ꞌyəgɨ bam me ca. ");
INSERT INTO sor_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Mana gɨ ta lə da, dole di dusɨw naw nan̰e me giy asɨngar duwa ha ꞌyáa nare woni ꞌyáa kòy duwa di bam me kɨrgɨ dùwa ciri day dɨdə me ca. ");
INSERT INTO sor_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ɗang da, an̰ji waygɨ kòy duwa di ba da: “Mani nə wama woni dyamdɨrani di naa le ɗɨm, me nare nə nə ꞌwogɨgɨ di nem wamagɨ bədə. ");
INSERT INTO sor_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Yande da, hana bɨrmə jirang duwa lə me nare nə anə ꞌywanagɨ dɨrəngə pad mwom da, ꞌwagɨnagɨ gɨ hane dyamdɨraniyə di.” ");
INSERT INTO sor_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Kòy di bor ha bɨrmə lə, me nare nə cendi ꞌyogɨ pad da, cendi dáyagɨ, nə àcn̰e me nə ladɨbe me ca. Cendi gɨra ꞌwon kulu gaba dyamdɨrani di daa. ");
INSERT INTO sor_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Mwom da, dole di dɨmə hára kulə dara yara nare nə gɨ dáyagɨ di. Ɨr̰ɨ an̰ji yər gun mɨn dam lə kwandaw dwar̰agɨ lə me hurə barge gaba dyamdɨrani di sɨwə bədə. ");
INSERT INTO sor_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","An̰ji ùrɨw da: “Jan maché, mə àla i man me mə dɨmə hára kulə ka dɨban hura barge gaba dyamdɨrani di sɨmmə mo?” Abe di ꞌyo gwale gaba àsaw lə diiyə bədə. ");
INSERT INTO sor_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ɨr̰ɨ dole di waygɨ kòy duwa di ba da: “Yɨnəw magdɨnaw gɨdaw me ɨsaw me daa me unəw àsɨnaw bam iche mana gɨ dilɨmmə. Mana gɨ ta di i mana gaba nulə gura me yɨdɨbə sande lə me ca.”» ");
INSERT INTO sor_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Me Jesu way da: «Nare nə gɨ ꞌwogɨgɨ da, gɨr̰ɨ nan̰e, me nə gɨ an̰jirɨgɨ da, i ɓani hin̰e mɨra.» ");
INSERT INTO sor_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Mana gɨ ta lə da, nare nə gɨ ꞌwogɨgɨ Parise biy sɨdəgɨ ha bam hin̰e me wajɨbɨ gwale bulə dayyə gaa ba gɨ ha ùrə Jesu i gwale gɨ we me ba gɨ ꞌyo gɨ gwale bɨwə ba gɨ yɨw nɨm mo? ");
INSERT INTO sor_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Yande da, cendi giyɨw woni gɨrsə gwale day nə yab day gɨ nə nare nə yab nənə dole gɨ Erod duwa me. Nare nə gɨ giyəgɨ di, ha wayaw Jesu da: «Aba gɨlənin mani, nə ꞌwocn̰ɨninne dara mə i aba waya gwale sɨw, me mə gɨlgɨ nare gwale sɨw gɨ Mãr̰ĩ ùr nare ba àlna di gɨ bɨrmə duwa. Mə àl yande dɨban lán̰aw gɨ gun, dara dolɨm gɨ nare nə ladɨbe bədə me ca. ");
INSERT INTO sor_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Yande da, waynin ɨrmə dɨma daa sɨn̰: Gaa ꞌywagaw gɨ dole gɨ geche gɨ Rom lombo da, ladɨ le, labaa ladɨ bədə mo?» ");
INSERT INTO sor_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Me Jesu di ꞌwocn̰ ɨrmə day gɨ àcn̰e di com me, an̰ji cogɨ lə diiyə ba da: «ꞌYeni nare nə gwale ꞌyol bɨdəngə me dusɨrəng dɨ korgɨn̰ i jiga nə gá! I dara na me anə ùrɨn gwale gaba gɨrsən nɨm yande mo? ");
INSERT INTO sor_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Gɨlnən chile dɨ gursɨ mɨn dɨ idɨ ꞌywaga lombo di kwa sɨn̰.» Cendi gɨlɨw gursɨ dɨ chile mɨn dɨ gɨ ꞌwogɨdɨ deniye di. ");
INSERT INTO sor_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Mwom da, an̰ji ùrgɨ ba da: «Mana gɨ chile dɨ ka di sɨdə da, i wi dɨw me sumɨw me ilə mo?» ");
INSERT INTO sor_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Cendi wayɨw ba i dole gɨ geche gɨ Rom dɨw. Mwom da, Jesu waygɨ da: «Ladɨ! Yande da, mani nənə dole duwa da, ꞌyànaw dole di, me mani nənə Mãr̰ĩ duwa kaw, ꞌyànaw Mãr̰ĩ di le me ca.» ");
INSERT INTO sor_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Mana gɨ nare di ba gɨ doy gwale gɨ Jesu waygɨ ta di mwom da, cendi ɨrɨmdɨ gwale nan̰e me cendi ɓɨr̰ɨn̰ kal Jesu di me borgɨ ya. ");
INSERT INTO sor_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Wála gɨ ta lə di dog, nare nə gɨ ꞌwogɨgɨ Saduse chidɨbə Jesu sɨwə ib ib. Cendi ɨrɨm day ba nare nə mare da, Mãr̰ĩ ba ha dɨməgɨ daa munɨ lə bədə bɨr̰ɨn̰. Me cendi ùr Jesu ba da: ");
INSERT INTO sor_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«Aba gɨlənin mani, yər, Moyis way ba da: Abe gɨ ba unə deme me yàna gandɨdɨ dine bədə me marna bam da, chendɨw ba unə wambɨ di me ba yànaw gɨ chendɨw gɨ mar bam di dine. ");
INSERT INTO sor_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Caga da, doy: Mana gɨ dwar̰aninnə da, chebni dɨ nare wurgɨsubu ilə. Chandragɨ gɨ geche u deme me mar bam dɨban yàa gandɨdɨ dine. An̰ji kalɨw chendɨw wambɨ di. ");
INSERT INTO sor_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Chendɨw gaba dii sɨrrə udɨ kaw, mar yande me, gɨ aba dii subu lə kaw, àlal yande me, bɨraa gɨ aba dii wurgɨsubu lə bá. Chamre nə wurgɨsubu di margɨ bam pad dayyə pad dɨban yàa gandɨdɨ dine. ");
INSERT INTO sor_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Taragɨ lə da, deme di kaw, wála dɨra nem me tandi mar bam me ca. ");
INSERT INTO sor_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Yande da, wála gɨ Mãr̰ĩ ha dɨmə gɨ nare daa munɨ lə da, nare nə wurgɨsubu ta di dwar̰agɨ lə da, tandi ha ꞌya i gɨ we dyaməw mo? Dara cendi nə pad ta di, tanga i tɨrgadɨ.» ");
INSERT INTO sor_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Me Jesu waygɨ da: «ꞌYeni da, dɨdəng nol i bam! Anə ꞌwocn̰ Maktubu dɨnə Mãr̰ĩ duwa bədə me dwana duwa di bədə me ca. ");
INSERT INTO sor_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Yarna, ɗan̰ wála gɨ Mãr̰ĩ ha dɨmə gɨ nare daa munɨ lə da, abje day gɨ nə namde ha laya sɨdəgɨ bədə. Cendi ha dama i ya Paja nənə Mãr̰ĩ duwa nə daa de, alə daa mana gɨ Mãr̰ĩ tulɨwə. ");
INSERT INTO sor_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Dara gwale gɨ Mãr̰ĩ ha dɨmə gɨ nare daa munɨ lə da, anə āsɨ gwale gɨ Mãr̰ĩ wayang gandɨw di bədə mo? An̰ji way ba da: ");
INSERT INTO sor_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Ɨndi di, nə i Mãr̰ĩ gɨnə Abɨrahamduwa me gɨnəIsakduwa me gɨnəJakobduwa me ca.”» Me Jesu waygɨ ba da: «Mãr̰ĩ di, i Mãr̰ĩ gɨnə nare nə mare day bədə, me i Mãr̰ĩ gɨnə nare nə dam bɨ̀ra day.» ");
INSERT INTO sor_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Mana gɨ nare nə gɨr̰e di ba gɨ doy gwale gɨ Jesu waygɨ gandɨw da, cendi ɨrɨmdɨ gwale nan̰ dara gɨlə duwa gɨ mani di. ");
INSERT INTO sor_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Mana gɨ nare nə gɨ ꞌwogɨgɨ Parise doy dara Jesu gwale duwa gɨ cogɨ nare nə Saduse lə diiyə me cendi ꞌyo gwale gaba wayaw ɗang bədə mwom da, cendi nə Parise di dayar dodə. ");
INSERT INTO sor_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Me gun day mɨn dwar̰agɨ lə gɨ aba gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa hára ꞌyo Jesu ùrɨw gwale gaba twaw dara dwaya gɨ gwale bɨwə dara ba gɨ yɨw nɨm. Yande da, an̰ji ùrɨw ba da: ");
INSERT INTO sor_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Aba gɨlənin mani, mana gɨ bii ɨnda gɨ ꞌwoo lə da, bii gɨ ꞌwoo gɨ geche gaba ɗwaya kwandaw bam da, i gɨ we mo?» ");
INSERT INTO sor_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesu cow lə diiyə ba da: «Mə ha ùrə Aba ciri dɨma gɨ Mãr̰ĩ gɨ dusɨm mɨn tenene, gɨ dúndɨm pad, gɨ ɨrmə dɨma pad me ca. ");
INSERT INTO sor_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ta di me i bii gɨ ꞌwoo gɨ geche gaba ɗwaya kwandaw bam di. ");
INSERT INTO sor_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Me gɨ ɗang gaba dii sɨr gɨ ya jaw gɨ pii de di me i ka: Mə ha ùrə jam gun ya sɨm dɨma de. ");
INSERT INTO sor_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mani pad nə bii gɨ ꞌwoo gɨnə Moyis duwa me woni cɨmə Mãr̰ĩ bɨw me waygɨ da, dayar ilə gwale gɨ sɨr gɨ ka di dalawə.» ");
INSERT INTO sor_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Jesu yər dara nare nə Parise dayar dodə mwom da, an̰ji ɨr̰ɨ ùrgɨ duwa ba da: ");
INSERT INTO sor_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Anə ɨrɨm man dara dole gɨ Mãr̰ĩ biyəw gɨ Kris di mo? An̰ji i wi mwàw mo?» Cendi cow lə diiyə, an̰ju ba i dole gɨDabid mwàw. ");
INSERT INTO sor_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jesu waygɨ da: «Ɨr̰ɨ ina yande da, cor i man me Dúndi dɨnə Mãr̰ĩ duwa nogɨ Dabid gɨndɨw daa ꞌwogɨ Kris di ba i aba ciri duwa mo? Dara Dabid di way da: ");
INSERT INTO sor_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Aba ciri gɨ Mãr̰ĩ wayɨw aba ciri ni ba da: Hare, mə dam ɨsən gɨ abeyə bɨraa nə ha bwam woni mar̰ande dɨma dodə gɨdammə bá do.” ");
INSERT INTO sor_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Dabid ꞌwagɨna Dole gɨ Mãr̰ĩ biyəw gɨ Kris di ba i aba ciri duwa da, i dana me gɨ ꞌwogɨw ba i Dabid mwàw ɗang tugu mo?» ");
INSERT INTO sor_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Gun mɨn kaw nem cwaw gwale lə diiyə bədə. Me wála gɨ ta lə di bá da, cendi lán̰ye, gun mɨn kaw nem ùrɨw gwale gɨ ɗang bədə ɗɨm. ");
INSERT INTO sor_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Targɨn̰ ɗang da, Jesu waygɨ nare nə gɨr̰e me woni gɨrsə gwale duwa di me ba da: ");
INSERT INTO sor_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa me nare nə Parise me da, gɨləgɨ gɨ nare bii gɨ ꞌwoo gɨnə Moyis duwa da, i giyə day. ");
INSERT INTO sor_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Yande da, mani nə cendi waynang pad da, dwayna me unə àlna gɨ giyə me ca. Me mani day nə cendi àlgɨ̀ da, kalna àlagɨ̀ ɗi! Dara cendi way gwale gɨ bɨdəgɨ mɨra me àl mani nə cendi waygɨ di bədə. ");
INSERT INTO sor_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Cendi dajɨ hudɨr gɨ nugde chɨ́gdɨgɨ nare dɨdəgɨ lə, me cendi day da, gɨ dùndɨrəgɨ kaw, cendi ɓɨlɨw wagɨ nɨm lə bədə. ");
INSERT INTO sor_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Mani nə cendi àlgɨ̀ pad da, àl i dara nare ba yarnagɨ nɨm. I yande me láya day dɨ cendi magdɨ jin̰jɨrəgɨ lə me dar̰ɨn̰jagɨ lə me ɗɨbɨ amsɨ gɨ Mãr̰ĩ da, jorbɨ nan̰ ɗoy kwandagɨ day bam. Chire gɨ barge day bɨwə da, cendi ɗangr̰ɨw sor nan̰ ɗoy kwandagɨ day bam me ca. ");
INSERT INTO sor_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Mana gɨ nare dayarna gɨ gɨr̰ə dara wama mani da, cendi ùr dama i mana gɨ pii gɨ ladeyə. Me mana gɨ kululi woni amsa Mãr̰ĩyə kaw, cendi ùr dama i mana gɨ lade gaba sumiyə me ca. ");
INSERT INTO sor_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Mana gaba dayara gɨnə nare nə ciri dɨdə pad dayyə da, cendi ùr dara nare ba àlnagɨ́ labiya gɨ horɨmbə nare dɨrəgɨ lə me ba ꞌwagɨnagɨ “woni gɨlənin mani” me ca. ");
INSERT INTO sor_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Me ꞌyeni da, ùrnə dara nare ba ꞌwagɨnang “woni gɨlənin mani” bədə, dara dan da, aba gɨləng mani da, i ɨndi mɨn tenene, me ꞌyeni nə pad da, anə i chamre: anə bor i mɨn. ");
INSERT INTO sor_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ꞌwagɨna gun mɨn dodə sɨn̰a dɨdə ka “abɨranin” bədə, dara dan da, abɨrang da, i mɨn tenene, i Abɨrang gɨ Mãr̰ĩ gaba dama daa di. ");
INSERT INTO sor_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kal nare ꞌwagɨnang “woni gɨlənin gwale” bədə, dara aba gɨləng gwale da, i mɨn tenene, i Dole gɨ Mãr̰ĩ biyəw gɨ Kris di. ");
INSERT INTO sor_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Gun gɨ ùrnə ba ina geche dwar̰angə da, a cwarna gɨdɨnə gun dan gaba kɨjə an̰ju. ");
INSERT INTO sor_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Dara gun gɨ unə dɨw daa an̰ju gaba ciri da, gɨ ha huraw dɨw di dodə, me gun gɨ hurna dɨw dodə da, gɨ ha biyəw gandɨdɨ daa. ");
INSERT INTO sor_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","ꞌYeni nare woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa me, ꞌyeni nare nə Parise me, anə i nare nə gwale ꞌyol bɨdəngə me dusɨrəng dɨ korgɨn̰ da, i jiga! Wamani ha ꞌywange, dara ciri dɨ daa di, anə ɗesɨ bɨdɨ daa ɨmgɨ nare ganda gɨ lə bam. ꞌYeni di kaw, anə ha ganda lə bədə me, nare nə ùrnə ba gɨ gandɨna hana lə kaw, anə ɨmgɨ bam me ca. ");
INSERT INTO sor_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","ꞌYeni nare woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa me, ꞌyeni nare nə Parise me, anə i nare nə gwale ꞌyol bɨdəngə me dusɨrəng dɨ korgɨn̰ da, i jiga! Wamani ha ꞌywange! Dara anə chəbɨ namde nə wambɨ mani day nə ꞌywaa bam pad, me anə ɗɨbɨ amsɨ gɨ Mãr̰ĩ bɨraa bɨraa bɨraa gɨləgɨ gɨ nare sɨdəng. Me ɗan̰ da, sariya dan ha wama nan̰e ɗwaya bam. ");
INSERT INTO sor_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","ꞌYeni nare woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa me, ꞌyeni nare nə Parise me, anə i nare nə gwale ꞌyol bɨdəngə me dusɨrəng dɨ korgɨn̰ da, i jiga! Wamani ha ꞌywange! Dara anə kɨdɨbər mana gɨ kurayyə me wayniyə me dara kan̰ja gɨ nare bwagɨ bɨrmə dan gɨnə Mãr̰ĩyə, me mana gɨ anə ꞌywana i gun mɨn tenene kaw, anə àlɨw gɨdɨw gun gaba ùrə àsa dùwa lə ɗwaya dan bam dii sɨr. ");
INSERT INTO sor_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","ꞌYeni woni gɨləgɨ nare bɨrmə nə dɨrəng bu nə ga, wamani ha ꞌywange! Dara anə way ba, gun ba sɨrgɨnə sɨw gɨ kulu gaba bwasa Mãr̰ĩ ba a ha àla mani nə ya ta de me ba àlna bədə kaw, mani ba ha àlaw bədə, me gun gɨ ba sɨrgɨnə sɨw gɨ jindar dɨ gɨ chɨ́gdɨdɨ mana gɨ kulu gaba bwasa Mãr̰ĩyə me àlna mani di bədə da, gwale ba ilə dɨwə. ");
INSERT INTO sor_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","ꞌYeni nə məngde nə dɨrəng bu nə gá! Jindar dɨ gɨ chɨ́gdɨdɨ kulu gaba bwasa Mãr̰ĩyə ta di me kulu gaba bwasa Mãr̰ĩ di me da, mani nə ta di, i nə we me ɗoy kwandagɨ bam mo? I kulu gaba bwasa Mãr̰ĩ di me àl jindar dɨ ta di gɨdɨdɨ wun mɨnadɨ jiga ta di bədə mo? ");
INSERT INTO sor_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Anə way bi ba, gun ba sɨrgɨnə sɨw gɨ mana gaba bwasa Mãr̰ĩ ba a ha àla mani nə ya ta de me ba àlna bədə kaw, mani ba ha àlaw bədə, me gun gɨ ba sɨrgɨnə sɨw gɨ mani nə dwani nə gɨ chɨ́gdɨgɨ mana gaba bwasa Mãr̰ĩ dɨwə me àlna mani di bədə da, gwale ba ilə dɨwə. ");
INSERT INTO sor_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","ꞌYeni nare nə dɨrəng bu nə gá! Mana gaba bwasa Mãr̰ĩ di me mani nə gɨ bosɨ gɨ Mãr̰ĩ di me da, i nə we me ɗoy kwandagɨ bam mo? I mana gaba bwasa Mãr̰ĩ di me àl mani nə gɨ bosɨ gɨ Mãr̰ĩ di wun mɨ́ndagɨ jiga di bədə mo? ");
INSERT INTO sor_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Yande da, gun gɨ sɨrgɨnə sɨw gɨ mana gaba bwasa Mãr̰ĩ di da, an̰ji sɨrgɨ sɨw gandɨw me sɨrgɨ sɨw i gɨ mani pad nə gɨ chɨ́gdəgɨ lə dɨwə di me ca. ");
INSERT INTO sor_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Me gun gɨ sɨrgɨnə sɨw gɨ kulu gaba bwasa Mãr̰ĩ da, an̰ji sɨrgɨ sɨw gɨ kulu gaba bwasa Mãr̰ĩ di me sɨrgɨ sɨw i gɨ Mãr̰ĩ gaba dama lə di me ca. ");
INSERT INTO sor_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Me gun gɨ sɨrgɨnə sɨw gɨ daa da, sɨrgɨ sɨw i gɨ gage gɨ dwãr̰ĩ gɨ Mãr̰ĩ dam lə diiyə di me sɨrgɨ sɨw i gɨ Mãr̰ĩ gaba dama gage dɨwə di me ca. ");
INSERT INTO sor_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","ꞌYeni nare woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa me, ꞌyeni nare nə Parise me, anə i nare nə gwale ꞌyol bɨdəngə me dusɨrəng dɨ korgɨn̰ da, i jiga! Wamani ha ꞌywange! Dara chemde nə ɓani ɓani woni bwaa bɨ̀ra lə kaw, nə nyamna mwaj da, anə ɓɨr̰ɨ bɨdəgɨ mɨn mɨn hára ꞌyàw Mãr̰ĩ com mɨnang, ɨr̰ɨ cor, bii gɨ ꞌwoo gɨnə Moyis duwa gɨ ɓag gɨ lade da, anə kalɨw ɗi. Nə way yande dara mani nə àla ya nə àla gɨ mani nə tɨba nə Mãr̰ĩ ùrgɨ di me, yara gɨ nare n̰agɨni day me, kala gɨ dusɨm mɨn Mãr̰ĩ dɨwə me ta de da, anə kal àla day ɗi. Ɓag da, dee anə ha àla i mani nə ta di do me anə ha àla nə ɗang nə wor di sɨn̰. ");
INSERT INTO sor_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","ꞌYeni woni gɨləgɨ nare bɨrmə nə dɨrəng bu nə gá! Anə chidɨ gani dan bam dara gaa don̰ ba ilə dwalɨn̰yə mo, me ɨr̰ɨ anə chə́ə jambal gɨ sɨdə de pad. ");
INSERT INTO sor_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","ꞌYeni nare woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa me, ꞌyeni nare nə Parise me, anə i nare nə gwale ꞌyol bɨdəngə me dusɨrəng dɨ korgɨn̰ da, i jiga! Wamani ha ꞌywange! Dara anə wujɨ ɗogdər̰e dan me dásabe dan me taragɨ bam ladɨ sɨlag sɨlag me, ɨr̰ɨ dwar̰agɨ nə korgɨn̰ da, anə ꞌwonbɨgɨ daa gɨ mani nə anə mɨjəgɨ di me gɨ dusɨrəng dɨ harni di me ca. ");
INSERT INTO sor_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ɨjɨm gɨ Parise gɨ dɨrəm bu gá! Wiy ɗagɨna dɨma me subɨra dɨma me dwar̰agɨ bam ladɨ, mwom da, taragɨ di ha cwara lada me. ");
INSERT INTO sor_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","ꞌYeni nare woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa me, ꞌyeni nare nə Parise me, anə i nare nə gwale ꞌyol bɨdəngə me dusɨrəng dɨ korgɨn̰ da, i jiga! Wamani ha ꞌywange! Dara anə wun i ya munɨni nə gɨ ɗagdəgɨ mani nə burage taragɨ lə me wusɨbɨ nɨm kəng kəng ta de. Taragɨ nə iche da, ladɨbɨ le, me dwar̰agɨ nə korgɨn̰ da, i guchindi nənə nare nə mare day me mani nə use me ilə cendi mɨra. ");
INSERT INTO sor_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","ꞌYeni di kaw, anə wun yande di me, dara nare dɨrəgɨ lə da, anə àl sɨdəng ya ba anə i nare nə tɨba Mãr̰ĩ dɨrəwə de, me dusɨrəng dɨ korgɨn̰ da, i jiga. Anə i nare nə gwale ꞌyol bɨdəngə me dusɨrəng dɨ korgɨn̰ da, i jiga, me anə i woni àla àcn̰a me ca. ");
INSERT INTO sor_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","ꞌYeni nare woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa me, ꞌyeni nare nə Parise me, anə i nare nə gwale ꞌyol bɨdəngə me dusɨrəng dɨ korgɨn̰ da, i jiga! Wamani ha ꞌywange! Anə awdɨgɨ woni cɨmə Mãr̰ĩ bɨw munɨni day ladɨbɨ me anə sɨrandɨ munɨni nənə nare nə tɨba Mãr̰ĩ dɨrəwə day ladɨbɨ me ca, ");
INSERT INTO sor_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","me anə way ba da: “Tanga wála gɨnə mwágɨrandɨ dayyə da, dee nə inanin lə gandagɨ da, dee nə hanin ɓamara gandagɨ mɨn dara ꞌyáa gɨ woni cɨmə Mãr̰ĩ bɨw di bədə.” ");
INSERT INTO sor_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Yande da, gwale dan gɨ anə wayɨw ta di, anə way gɨ bɨdəng dan ꞌyeni gang ba anə ba i woni ꞌyáa woni cɨmə Mãr̰ĩ bɨw di mwàgɨragɨ. ");
INSERT INTO sor_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ladɨ! Mani nə mwágɨrang àlgɨ ta di, ꞌyeni da, àlnagɨ ɗwayna bam! ");
INSERT INTO sor_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Kwalàle nə mɨgay dɨndadɨ nə gá! I man me anə ɨrɨm dara anə banə ha bɨlə sɨdəng daa dùwa dɨnə Mãr̰ĩ duwa dɨ budə dɨra gɨ bam ilə bədə bɨr̰ɨn̰ di mo? ");
INSERT INTO sor_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","I dara yande me, dwayna: Nə ha kɨjəng woni cɨmə Mãr̰ĩ bɨw me nare nə dɨrəgɨ nagdɨ woni ꞌwacn̰a gwale me woni gɨləng bii gɨ ꞌwoo gɨnə Mãr̰ĩ duwa me ca. Nare nə ta di pad dwar̰agɨ lə da, anə ha ꞌyáa nə mɨn bam me, nə yab da, anə ha ɓyangdagɨ ɓabɨr̰agɨ daa habde nə dagɨla sɨdəgɨ lə me, anə ha gwaba nə mɨn ɗang gɨ bɨr̰aw mana gɨ kululi dan woni amsa Mãr̰ĩyə me, anə ha pamdagɨ taragɨ lə mana gɨ ciriyə bá bá dara gɨləgɨ gɨ dɨrəgɨ me ca. ");
INSERT INTO sor_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Yande da, wamani pad gɨnə woni ꞌyáa nare nə tɨba Mãr̰ĩ dɨrəwə day di, ha ꞌywang ꞌyeni, swaa made dɨnə Abel gɨ i gun gɨ tɨba Mãr̰ĩ dɨrəwə bá hára mana gɨ made dɨnə Jakari gɨnə Baraki gorndɨw lə gɨ anə ꞌyəw i mana gɨ kulu gaba bwasa Mãr̰ĩyə bulə day gɨ mana gaba bwasa Mãr̰ĩyə. ");
INSERT INTO sor_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Dwayna, nə wayang i gwale sɨw: Wamani gɨnə woni ꞌyáa nare nə pad ta di day da, ha ꞌywaa nare nə caga ka di le me.» ");
INSERT INTO sor_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«Ay, nare nə Jursalem, nare nə Jursalem, ꞌyeni nə anə ꞌyə woni cɨmə Mãr̰ĩ bɨw bam, me nare nə Mãr̰ĩ kɨjəng gandagɨ kaw, anə jərgɨ gɨ kur̰a ꞌyəgɨ bam me ca! Nə kan̰jɨ bɨrmə bá ba nə dáyang dodə ya dure ba dɨ day gɨ dɨndadɨ gɨndɨdɨ lə ta de. Me ꞌyeni da, anə gɨn̰ə bam com! ");
INSERT INTO sor_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Yande da, dwayna: Mãr̰ĩ ha gɨn̰ə ciri dan di bam. ");
INSERT INTO sor_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","I sɨdɨ, nə wayang: Wor i ib anə ha yaran bədə bɨraa wála gɨ anə ha waya da: “Kal Aba ciri gɨ Mãr̰ĩ biynəw an̰ju gɨ hára lə gɨ sumɨw di bɨw dɨwə, biynəw bɨw dɨwə” bá do.» ");
INSERT INTO sor_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Targɨn̰ ɗang da, Jesu dɨm bam ciri dwar̰ɨ dɨ kulu gaba bwasa Mãr̰ĩ ilə di me yá. Mana gɨ ba a yá bam hin̰e mwom da, woni gɨrsə gwale duwa chidɨbə sɨwə ib ib me gɨlɨw ciri di ladni dɨra dɨ gɨ awdɨ nɨm di. ");
INSERT INTO sor_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ɨr̰ɨ Jesu waygɨ da: «Anə yər mani nə pad ta di mo? Dwayna, nə wayang i gwale sɨw: Mani pad nə i ta di ha myandara i bam. Kur̰a mɨn tenene kaw, ha wara daa kondɨdɨ dɨdə bədə.» ");
INSERT INTO sor_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Mana gɨ Jesu gɨra dam mana gɨ kur̰a dɨ Olib dɨdə mwom da, woni gɨrsə gwale duwa hára ꞌyow mɨ́ndagɨ me ùrɨw ba da: «Waynin daa: I mindi na me mani nə ta di ha àlala mo? I mani na me ha gɨlənin cwara dɨma di me dɨr̰ɨn̰a ꞌyan̰a dɨra di me mo?» ");
INSERT INTO sor_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesu cogɨ waygɨ da: «Àsɨna angal dan ladɨ le! Kalna gun mɨn lamnang bwanang bam bədə! ");
INSERT INTO sor_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Nə way yande dara nare nan̰ ha ꞌwoo sumɨn hára nɨm lə, me wi kaw, ha waya ba Dole gɨ Mãr̰ĩ biyəw gɨ Kris di, ba i an̰ju, me cendi ha lama nare nan̰ bwagɨ bam. ");
INSERT INTO sor_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Anə ha dwaya gwale gɨnə say dɨ tuləngə ib me, dɨ mana gɨ hən̰yə gwale dɨra me. Mana gɨ ta lə da, àsɨna angal dan, kalna àla lán̰a ɗi. Mani nə ya ta de di ha àlala le bá, ɗɨm da, i dɨr̰ɨn̰a ꞌyan̰a dɨra bədə sɨn̰. ");
INSERT INTO sor_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Nare nə wama gɨ ciri dɨ mɨnnə ha swaa jara say gɨ kwandagɨ nə ciri dɨ wama gɨ ɗangə me, dole gɨ mɨn ha jara say gɨ jaw dole gɨ ɗang me ca. Badɨgara dɨ geche ha ɨndara ciriyə jiga jiga, me sɨn̰a kaw, ha gɨgdara mana lə jiga jiga me ca. ");
INSERT INTO sor_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Wamani gɨ pad ta di, wun i ya yàa ba jəgdɨ gɨ deme dɨrɨn̰ nə piiyə ta de sɨn̰. ");
INSERT INTO sor_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Mana gɨ ta lə da, gɨ ha gɨləng dɨrəng me gɨ ha ꞌyáng bam me ca. Nare nə gɨndəgɨ jiga jiga pad ha ɨlənge dara daran ɨndi. ");
INSERT INTO sor_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","I ta di me nare nan̰ ha gɨn̰ə dusi day dɨ kala dɨnnə di bam. Cendi ha yɨbə kwandagɨ ꞌyàgɨ́ woni mar̰ande day ɨsɨragɨ lə me cendi ha ɨlə sɨdəgɨ le me ca. ");
INSERT INTO sor_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Woni cwaa sɨdəgɨ ya woni cɨmə Mãr̰ĩ bɨw de nan̰ hára lə, me cendi ha lama nare nan̰ bwagɨ bam. ");
INSERT INTO sor_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Àcn̰a di ha jwara hára i pii pii. Yande da, nare nan̰ dwani day di kaw, ha cwara hɨlala le ɗeng ɗeng me ca. ");
INSERT INTO sor_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Me gun gɨ yɨnə sɨw wàyna kalna dusɨw dɨnnə bɨraa ꞌyan̰a lə da, Mãr̰ĩ ha ꞌyàw bɨlə. ");
INSERT INTO sor_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Nõ dɨ lade dɨnə dwãr̰ĩ dɨnə Mãr̰ĩ duwa di da, gɨ ha wayadɨ mana gɨ sɨn̰a gɨndɨdɨ lə pad dara nare nə gɨndəgɨ jiga jiga pad ba dwayna. Ta di do me dɨr̰ɨn̰a ꞌyan̰a dɨra di hára lə sɨn̰.» ");
INSERT INTO sor_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«Wála mɨn, anə ha yara mani nə àl ɨn̰ama woni myanda mana bam di nə aba cɨmə Mãr̰ĩ bɨw gɨ Daniyel way gwale day di ha ꞌya lə kulu gaba bwasa Mãr̰ĩyə di. Gun gaba āsa gwale gɨ ta di da, kal a ꞌwacn̰ana gɨndɨw ladɨna! ");
INSERT INTO sor_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Wála gɨ ta lə da, nare nə i mana gɨ wama gɨ Judeyə da, gɨ wana hana daa kur̰a dɨdə. ");
INSERT INTO sor_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Gun gɨ damna daa mana gɨ kulu duwa dɨwə da, a chɨ́nə dodə dara laya gɨ mani nə ilə kulə di bədə ɗɨm. ");
INSERT INTO sor_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Me gun gɨ ina lə bam yiga lə kaw, a cwarnay hane ulay dara laya gɨ barge duwa di bədə ɗɨm me ca. ");
INSERT INTO sor_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Wála gɨ ta lə di, owe namde woni gudi gudi me woni ꞌyàgɨ́ dɨndɨragɨ nãy me! Wamani ha ꞌywagɨ le! ");
INSERT INTO sor_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Amsɨna Mãr̰ĩ dara kal wàa dan di ɨndarna gɨ urni bədə me gɨ wála gaba bwaa gwayniyə bədə me ca. ");
INSERT INTO sor_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Dara wála gɨ ta lə da, ha ꞌya i gɨlə gɨ dɨrɨn̰ gɨ geche gɨ dii mɨn kaw, gun ꞌyow bədə ɓɨgden̰ diyə gɨ mani pad gɨndəgɨ lə bɨraa laba. Ɗan̰ kaw, gɨlə gɨ dɨrɨn̰ gɨ ya ta de di ha ꞌya lə ɗang bədə bɨr̰ɨn̰. ");
INSERT INTO sor_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","I sɨdɨ, wála gaba gɨlə dɨrɨn̰ gɨ ta lə da, Aba ciri gɨ Mãr̰ĩ di dee ɨrmɨnə me junə wála gɨ yab bwana bam bədə da, gun mɨn gɨ dee ha ꞌywaa bɨlə duwa da, ilə bədə. Me an̰ji ɨrmə dara ba a ha joo wála gɨ yab di bam ɗɨm dara nare nə an̰ji an̰jiragɨ dara ba ina i duwa di. ");
INSERT INTO sor_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Wála gɨ ta lə da, nare ha wayang “Yarna, Dole gɨ Mãr̰ĩ biyəw gɨ Kris di, i ka”, labaa “Dole gɨ Mãr̰ĩ biyəw gɨ Kris di, ilə ta.” Gun gɨ waynang yande da, yɨnə gwale duwa di bədə. ");
INSERT INTO sor_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Dara nare woni kulagɨ ha ɓɨr̰ɨn̰ə. Nə mɨn da, ha wayang Dole gɨ Mãr̰ĩ biyəw gɨ Kris di, ba i cendi, me i kulagɨ. Nə yab da, ha wayang ba gɨ i woni cɨmə Mãr̰ĩ bɨw, me i kulagɨ. Cendi ha àla mani nə dan̰a me mani nə ɗoy nare dɨdəgɨ bam me dara lama gɨ nare. Cendi dee ꞌywana bɨrmə da, dee ha lama nare nə Mãr̰ĩ an̰jirɨgɨ di le me ca. ");
INSERT INTO sor_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Dwayna, nə wayang daa pii. ");
INSERT INTO sor_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Mana gɨ gun dara wayang da: “Yarna, Dole gɨ Mãr̰ĩ biyəw gɨ Kris di, ba ilə alə dɨn dwar̰ɨ lə” da, hana lə bədə. Labaa, gun waynang da, an̰ji ba ilə budə lə mana lə mɨn da, yɨnə gwale duwa di bədə me ca. ");
INSERT INTO sor_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Dara wála gɨ Gun gorndɨw di cwarnay hane da, ha wunə i ya Mãr̰ĩ ba a wur̰ɨn̰ me ácn̰ gɨ mana so tulɨn̰ dɨ dawa ganda dɨra lə bɨraa ha nɨm tulɨn̰ dɨ dawa ɗwanda dɨra lə ta de. ");
INSERT INTO sor_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Dara mana gɨ we we gɨ kumbɨ ina lə da, duni ha dayara lə me ca.» ");
INSERT INTO sor_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«Wála gaba gɨlə dɨrɨn̰ di tarɨwə dog da, mana ha gɨdə dilɨm kɨdab dara dawa ha aa bədə me, duru kaw, ha ácn̰a mana bədə me, dechu kaw, ha bwara dodə me, mani nə daa pad woni dwana kaw, ha gɨgdara daa me ca. ");
INSERT INTO sor_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Mana gɨ ta lə da, gɨ ha yara mani nə ha gɨlə cwara gɨnə Gun gorndɨw duwa di daa mana gɨ siyaya lə. Ɨr̰ɨ nare nə gɨndəgɨ jiga jiga sɨn̰a gɨndɨdɨ lə pad ha nulbə sɨdəgɨ, me cendi ha yara Gun gorndɨw di chə́ə lə daa siyaya dalawə hára nɨm dodə gɨ dwana me gɨ ꞌywagda duwa gɨ nan̰ me ca. ");
INSERT INTO sor_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ɨr̰ɨ, an̰ji ha kɨjə Paja duwa nə daa dara cendi ba hurbɨna pɨdɨm dɨ idɨ nɨmə nan̰ dáynaw gɨ nare duwa nə an̰ji an̰jiragɨ di dodə mana mɨn, so mana gɨ tulɨn̰ dɨ jomniyə me dɨ turgɨ lə me ɨsay gɨ abeyə me ɨsay gɨ jeleyə me ca. ");
INSERT INTO sor_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Ɨrmɨnə gwale gɨnə dwaga dɨra yarna sɨn̰. Mana gɨ gangr̰adɨ nə dine dara kubə daa me bajadɨ cwarna kulaje me da, anə ꞌwocn̰ dara marsɨni ba i ib ɗɨm. ");
INSERT INTO sor_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Cwara gɨnə Gun gorndɨw di kaw, ha wunə i yande di me ca: Mana gɨ anə dara yara mani nə dee nə wayang gwale day pii di dara àlala da, ɨrmɨnə dara Gun gorndɨw di yala lə ib ɗɨm, an̰ji ilə ciri bɨdə. ");
INSERT INTO sor_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Dwayna, nə wayang i gwale sɨw: Mani nə pad ta di dara àlala da, nare nə caga ka di ha mara bam pad pii dɨrəgɨ lə bədə sɨn̰. ");
INSERT INTO sor_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Daa me, sɨn̰a me, ha myandara i bam, me gwale ni da, ha myandara bam bədə bɨr̰ɨn̰.» ");
INSERT INTO sor_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«Mani nə ta di, wála day labaa dawa day dɨ cendi ha àlala lə da, gun mɨn kaw, ꞌwocn̰ɨgɨ bədə. Paja nənə Mãr̰ĩ duwa nə daa kaw, ꞌwocn̰ɨgɨ bədə, Mãr̰ĩ gorndɨw kaw, ꞌwocn̰ɨgɨ bədə me ca. I Abəw gɨ Mãr̰ĩ mɨn tenene me ꞌwocn̰ɨgɨ an̰ju. ");
INSERT INTO sor_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Dawa dɨ Gun gorndɨw di cwarnay hane da, mani ha àlala wunə i ya nə tanga àlal wála gɨnə Nuwe duwa lə ta de. ");
INSERT INTO sor_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Dara wála gɨ nimi nə geche yala bədə sɨn̰ da, nare dam wom me chə̀ me, lay namde me, wur dɨndɨragɨ nə namde abjeyə me, bɨraa wála gɨ Nuwe gɨra gandɨ nɨm bɨrwa gɨ geche dalawə bá. ");
INSERT INTO sor_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Cendi ɨrɨm dara mani mɨn ba ha àlagɨ̀ bədə, bɨraa hára nɨm wála gɨ nimi nə geche gɨra laygɨ ꞌyəgɨ nɨm bam pad. Cwara gɨnə Gun gorndɨw duwa di kaw, ha wunə yande di dige dige me ca. ");
INSERT INTO sor_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Dawa dɨ ta lə da, abje sɨr ha ɗɨbə yiga dalawə ca. Gɨ ha ɓɨr̰ə gɨ mɨn hára nɨm, me gɨ ha kala gɨ mɨn wara dodə. ");
INSERT INTO sor_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Namde sɨr ha ɗɨbə ɨgə lə gine bɨwə. Gɨ ha ɓɨr̰ə dɨ mɨn hára nɨm, me gɨ ha kala dɨ mɨn dodə me ca.» ");
INSERT INTO sor_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","«Yande da, damna dɨrəng bɨ̀ra jang, dara wála gɨ Aba ciri dan hára nɨm lə di da, anə ꞌwocn̰ɨw bədə. ");
INSERT INTO sor_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Anə ꞌwocn̰ com, gun gaba ciri dee ꞌwacn̰ana changa dwar̰ɨ dɨ ya ta deyə mẽ ba hára lə mĩyəwə da, an̰ji ha dama i dɨrəw bɨ̀ra jang dara ɨməw ɓwalba gɨ bii dɨmə kɨrə duwa lə di bam. ");
INSERT INTO sor_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Inam yande da, ꞌyeni di kaw, ɗangr̰ɨna sɨdəng damna dɨrəng bɨ̀ra, dara ɨndi gɨ Gun gorndɨw di, nə ha cwara i gɨ dawa dɨ anə ɨrɨm lə bədə.» ");
INSERT INTO sor_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«Kwaya gɨ dusɨw mɨn me gɨ dɨrəw naa me da, i gɨ man mo? I gun gɨ aba ciri duwa bow giyə gaba gama kwandaw pad ɨsəwə me ba ɨsɨnəgɨ mani nə wama gɨ bɨrmə duwa bá bá me kal sɨw yá mɨjəniyə. ");
INSERT INTO sor_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kwaya gɨ aba ciri duwa cwarnay gɨrnəy ꞌywanaw ilə àla giyə gɨ an̰ji ɨrmɨw pii di lə da, kwaya gɨ ta di dam i gɨ sii ꞌywala. ");
INSERT INTO sor_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Dwayna, nə wayang i gwale sɨw: Aba ciri duwa ha bwaw mani duwa nə ꞌywaa pad ɨsəwə. ");
INSERT INTO sor_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Me an̰ji dee ina i kwaya gɨ àcn̰e me wayna dusɨwə ba da: “Aba ciri ni hára gang bədə sɨn̰”, ");
INSERT INTO sor_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","me an̰ji damna dara gwaba gɨ kwandaw kòy di me dara wama me chàa me gɨ woni widɨbə gani me ca da, ");
INSERT INTO sor_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ɨr̰ɨ aba ciri duwa di cwara hára i gɨ wála gɨ an̰ji gamɨw lə bədə me i gɨ dawa dɨ an̰ji ꞌwocn̰ɨdɨ bədə me ca. ");
INSERT INTO sor_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Mana gɨ ta lə da, aba ciri duwa ha ꞌywaraw bam iche me, ha àsaw wamani gɨ gecheyə ɓamaw gɨ nare nə gwale ꞌyol bɨdəgɨ lə, me dusɨrəgɨ dɨ korgɨn̰ i jiga mɨn. Mana gɨ ta di i mana gaba nulə gura me yɨdɨbə sande lə me ca.» ");
INSERT INTO sor_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","«Wála gɨ ta lə da, dwãr̰ĩ dɨ daa di ha wunə i ya dine nə mware nə mwaj nə lay lamba day me ha nɨm dara sawa gɨ aba ꞌwoo deme dɨrəw daa ta de. ");
INSERT INTO sor_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Nə jii korgɨn̰ dayyə da, i nə məng, me nə jii da, i woni dɨrɨn̰ naa me ca. ");
INSERT INTO sor_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Mware nə jii nə məng di lay lamba day di dɨban laya gɨ swani ɨsɨragɨ lə. ");
INSERT INTO sor_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Me nə jii nə woni dɨrɨn̰ naa ta di lay lamba day di me mɨrda gɨ swani ilə dwalɨn̰yə ɨsɨragɨ lə me ca. ");
INSERT INTO sor_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ɨr̰ɨ aba ꞌwoo deme di hára kaláng bədə, me mware di, nuni àlgɨ me, bor i nuni pad. ");
INSERT INTO sor_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Gɨ changa dwar̰ɨ da, gɨ soy nɨm ba: “Dwayna, aba ꞌwoo deme di yala ɗɨm! Gandɨna, hana sawna dɨrəw daa!” ");
INSERT INTO sor_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Mwom da, mware nə mwaj di ɓɨr̰ɨn̰ daa pad me ɗangr̰ɨ lamba day di me ca. ");
INSERT INTO sor_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Me mware nə məng di waygɨ kwandagɨ woni dɨrɨn̰ naa di ba da: “ꞌYànanin swani dan di hin̰e, dara lamba nin di ilə budə bam.” ");
INSERT INTO sor_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Me cendi nə woni dɨrɨn̰ naa di cogɨ lə diiyə ba da: “Bədə. Swani di ha nyamanin me ha nyamang ꞌyeni me bədə. ꞌYeni dan da, wana hana kɨlnə le woni kenge ɨsɨragɨ lə.” ");
INSERT INTO sor_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Mana gɨ mware nə jii di yá kɨlə lə da, aba ꞌwoo deme di kaw yala me. Woni dɨrɨn̰ naa di gandɨ yá gandɨw kulu gaba àla dyamdɨraniyə di me gɨ ɗesɨ bii daa. ");
INSERT INTO sor_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Targɨn̰ ɗang da, mware nə məng di aja day gɨnɨn̰ yala me sojɨ ba da: “Aba ciri nin, aba ciri nin, tin̰ɨnin bii bam ɗe!” ");
INSERT INTO sor_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Me an̰ji cogɨ lə diiyə waygɨ ba da: “Dwayna, nə wayang i gwale sɨw: Nə ꞌwacn̰ang bədə bɨr̰ɨn̰!”» ");
INSERT INTO sor_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ɨr̰ɨ Jesu waygɨ woni gɨrsə gwale duwa ba da: «Yande da, damna dɨrəng bɨ̀ra, dara anə ꞌwocn̰ wála ni gaba cwara di bədə me, dawa ni di kaw, bədə me ca.» ");
INSERT INTO sor_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«Ɗang kaw, dwãr̰ĩ dɨ daa di, ha wunə ya abe mɨn ba a so ha nɨm mɨjəniyə ta de. An̰ji ꞌwaga kòy duwa di me ꞌyàgɨ́ mani duwa nə ꞌywaa ɨsɨragɨ lə. ");
INSERT INTO sor_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","An̰ji ꞌyàw wi wi kaw, mana gɨ dwana duwa lə, dwana duwa lə. An̰ji ꞌyàw gɨ mɨn gursɨ milyo jii me gɨ mɨn ɗang milyo sɨr me gaba subu lə milyo mɨn me ca. Ɨr̰ɨ kal sɨw yá mɨjəniyə di. ");
INSERT INTO sor_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Kwaya gaba ꞌywaa milyo jii di so kaláng ha àla gɨ kenge me ꞌywaa kondɨdɨ milyo jii lə diiyə ɗang. ");
INSERT INTO sor_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","An̰ju gaba ꞌywaa milyo sɨr di kaw, àl yande me, ꞌywaa kondɨdɨ milyo sɨr lə diiyə me. ");
INSERT INTO sor_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Me aba ꞌywaa milyo mɨn di ha pwala gubu mu gursɨ dɨnə aba ciri duwa di dodə. ");
INSERT INTO sor_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Àl wála nan̰ mwom da, aba ciri day di cwara hára ulay me ꞌwagagɨ ba hane waynaw mani nə cendi ba àl gɨ gursɨ duwa dɨ ɨsɨragɨ lə di. ");
INSERT INTO sor_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","An̰ju gaba ꞌywaa milyo jii di chidɨ hára sɨwə ib me gɨlɨw gursɨ di nimi dɨra dɨ an̰ji ꞌywaa ɗang milyo jii lə diiyə me ca, me wayɨw da: “Aba ciri ni, yər gursɨ dɨ mə ꞌyàn milyo jii di, nə ꞌywaa nimi dɨra milyo jii lə diiyə me ca, yər i ta.” ");
INSERT INTO sor_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Aba ciri duwa di wayɨw da: “Ladɨ nan̰e, mə i kwaya gɨ lade gɨ gun nem kala dusɨw dɨmmə. Mana gɨ mani nə ɓaniyə kaw, mə gɨlə dara ba mə i gun gɨ gun nem kala dusɨw dɨmmə ꞌyang. Yande da, nə ha ꞌyàm mani nə nan̰ ɗang ɨsəmmə. Hare dam àl sii ꞌywala gandɨn ɨndi gɨ aba ciri dɨma di.” ");
INSERT INTO sor_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","An̰ju gɨ aba ꞌywaa milyo sɨr di kaw, ha ɗɨbɨ dɨrəwə me wayɨw ba da: “Aba ciri ni, yər gursɨ dɨ mə ꞌyàn milyo sɨr di, nə ꞌywaa nimi dɨra lə diiyə milyo sɨr me ca, yər i ta.” ");
INSERT INTO sor_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Aba ciri duwa di wayɨw da: “Ladɨ nan̰e, mə i kwaya gɨ lade gɨ gun nem kala dusɨw dɨmmə. Mana gɨ mani nə ɓaniyə kaw, mə gɨlə dara ba mə i gun gɨ gun nem kala dusɨw dɨmmə ꞌyang. Yande da, nə ha ꞌyàm mani nə nan̰ ɗang ɨsəmmə. Hare dam àl sii ꞌywala gandɨn ɨndi gɨ aba ciri dɨma di.” ");
INSERT INTO sor_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Targɨn̰ ɗang da, kwaya gaba ꞌywaa milyo mɨn di chidɨ hára sɨwə ib me wayɨw da: “Aba ciri ni, nə ꞌwocn̰ dara mə i gun gɨ gwale dɨma womme. Mana gɨ mə gɨsə swagə lə bədə kaw, mə n̰il le com, me mana gɨ mə chɨgdɨnə swagə lə bədə kaw, mə dajɨ le com me. ");
INSERT INTO sor_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Yande da, lán̰a àlɨnne me nə ꞌwò pwala gubu mõõ gɨ gursɨ dɨma di dodə sɨn̰a lə. Yər, u gursɨ dɨma di, i ta.” ");
INSERT INTO sor_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Me aba ciri duwa di wayɨw da: “Kwaya gɨ àcn̰e gaba gendəgə ga, mə ꞌwocn̰ dara mana gɨ nə gɨsə swagə lə bədə kaw, nə n̰il le, me mana gɨ nə chɨgdɨnə swagə lə bədə kaw, nə dajɨ le com. ");
INSERT INTO sor_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Inam yande da, ladni duwa, dee mə ha àsan gursɨ ni di mana gaba gama gursɨ lə. Mwom da, cwara niyə da, dee nə ha ꞌywaa gursɨ ni sɨdɨ me nimi dɨra lə diiyə me ca. ");
INSERT INTO sor_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Yande da, unə gursɨ dɨ milyo mɨn ta di bam ɨsəwə me ꞌyànaw an̰ju gaba milyo mwaj di lə diiyə. ");
INSERT INTO sor_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Dara gun gɨ we we gɨ mani duwa ina lə da, gɨ ha ꞌyàw lə diiyə nan̰ ɗang bi, me mani duwa di ha bɨlbə dodə. Me gun gɨ mani duwa ina lə bədə da, nə hin̰e ɨsəwə ta di kaw, gɨ ha ꞌwoo i bam. ");
INSERT INTO sor_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Kwaya gɨ àcn̰e gɨ ta di da, unəw àsɨnaw bam iche mana gɨ dilɨmmə. Mana gɨ ta di i mana gaba nulə gura me yɨdɨbə sande lə me ca.”» ");
INSERT INTO sor_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","«Wála gɨ Gun gorndɨw cwarnay hane mana gɨ ꞌywagda duwa gɨ nan̰ dalawə me gɨ paja duwa nə daa pad me da, gɨra ha dama mana gɨ gage duwa gɨ dwãr̰ĩ gɨ ꞌyogdeyə. ");
INSERT INTO sor_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Mwom da, nare nə gɨndəgɨ jiga jiga sɨn̰a gɨndɨdɨ lə pad ha dayara dodə dɨrəwə. Ɨr̰ɨ an̰ji ha ɨsəgɨ dodə korgɨn̰ sɨr ya aba gama bage ba a cəgdɨ nɨm gɨ dɨmən̰je gɨ bage nə mee bam jiga jiga ta de. ");
INSERT INTO sor_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","An̰ji ha bwaa dɨmən̰je di ɨsəw gɨ abeyə me, bage nə mee da, ha bwagɨ ɨsəw gɨ jeleyə me. ");
INSERT INTO sor_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Targɨn̰ ɗang da, dole di ha wayagɨ cendi nə ɨsəw gɨ abeyə di ba da: “ꞌYeni nə Aban gɨ Mãr̰ĩ biy bɨw dɨdəngə di, hane damna ciri dɨ Mãr̰ĩ lam gɨ dwãr̰ĩ duwa lə. Ciri dɨ ta di, i dɨba dan dɨ an̰ji ɗangr̰ang gandɨdɨ ɓɨgden̰ diyə gɨ sɨn̰a gɨndɨdɨ lə bá. ");
INSERT INTO sor_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Dara tanga pii, cherni àlan da, anə ꞌyàn mani nə wama. Machè àlan da, anə ꞌyàn nimi nə chàa. Nə ꞌya i mɨje da, anə yə̀n sɨdəngə àlan mɨjəni. ");
INSERT INTO sor_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Barge ilə sɨnnə bədə da, anə ꞌyàn barge gɨ hura. Nə ꞌya mwom da, anə gaman lada. Gɨ yə̀n àsan dangeyə da, anə ꞌwò yaran.” ");
INSERT INTO sor_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Mwom da, cendi nə tɨba Mãr̰ĩ dɨrəwə di, ha cwaw lə diiyə ba da: “Aba ciri nin, i mindi na me nə yaramnin cherni àlam me nə ꞌyàmnin mani nə wama di mo? Labaa, machè àlam me nə ꞌyàmnin nimi nə chàa di mo? ");
INSERT INTO sor_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","I mindi na me mə ꞌya i mɨje me nə yə̀mnin sɨdəninnə àlam mɨjəni di mo? Labaa, barge ilə sɨmmə bədə me nə ꞌyàmnin barge gɨ hura di mo? ");
INSERT INTO sor_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","I mindi na me mə ꞌya mwom labaa mə ꞌya dangeyə me nə gɨranin yərɨm di me mo?” ");
INSERT INTO sor_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ɨr̰ɨ dole di ha cwagɨ lə diiyə wayagɨ ba da: “Dwayna, nə wayang i gwale sɨw: Mani nə anə àlgɨ̀ bá bá ta di, anə àlnaw i chendɨn gɨ nem mani bədə nare dɨrəgɨ lə kaw, anə àlan i ɨndi.” ");
INSERT INTO sor_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Targɨn̰ ɗang da, dole di ha wayagɨ nare nə ɨsəw gɨ jeleyə di ba da: “Hana bam ched tulɨnnə, ꞌyeni nə Mãr̰ĩ sɨrgəng di, me hana mana gɨ dùwa dɨ budə dɨra gɨ bam ilə bədə bɨr̰ɨn̰yə, dɨ gɨ ɗangr̰ɨdɨ i Sidan day gɨ nə kwandadɨ dúndi dɨ àcn̰e di. ");
INSERT INTO sor_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Dara tanga pii cherni àlan kaw, anə ꞌyàn mani nə wama bədə, me machè àlan kaw, anə ꞌyàn nimi nə chàa bədə me ca. ");
INSERT INTO sor_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Tanga pii, nə ꞌya i mɨje kaw, anə àlan mɨjəni bədə. Barge ilə sɨnnə bədə kaw, anə ꞌyàn barge gɨ hura bədə. Nə ꞌya mwom labaa, nə ꞌya dangeyə kaw, anə gaman lada bədə.” ");
INSERT INTO sor_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Mwom da, cendi ha cwara day ùrɨw ba da: “Aba ciri, i mindi na me nə yaramnin cherni àlam, labaa machè àlam me di mo? Nə yaramnin mə ꞌya i mɨje, labaa barge ilə sɨmmə bədə me di mo? Nə yaramnin mə ꞌya mwom, labaa mə ꞌya dangeyə me nə gɨn̰ənin hára gaba wam lə bam di mo?” ");
INSERT INTO sor_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Mwom da, dole di ha cwagɨ lə diiyə ba da: “Dwayna, nə wayang i gwale sɨw: Mani nə ta di anə gɨn̰ɨnə àlaw i gun gɨ nem mani bədə nare dɨrəgɨ lə da, anə gɨn̰ àlan i ɨndi bam.” ");
INSERT INTO sor_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Me cendi woni gɨn̰ə àla mani nə ta di bam da, ha hára i mana gɨ gɨlə gɨ dɨrɨn̰ gɨ ꞌyan̰a duwa ilə bədə bɨr̰ɨn̰ di lə, me cendi nə tɨba Mãr̰ĩ dɨrəwə da, ha hára day i mana gɨ bɨlə gaba dama gɨ dɨrɨn̰ bɨr̰ɨn̰yə me ca.» ");
INSERT INTO sor_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Mana gɨ Jesu gɨl mani duwa nə ta di ꞌyen̰ bam pad mwom da, an̰ji waygɨ woni gɨrsə gwale duwa ba da: ");
INSERT INTO sor_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Anə ꞌwocn̰ dara wor wála sɨr da, ha ꞌya isii ꞌywala gɨnə kɨrara gɨ daa kwaynaniyə duwa. I wála gɨ ta lə di me ɨndi gɨ Gun gorndɨw di, gɨ ha ꞌyàn woni mar̰ande ni ɨsɨragɨ lə dara cendi ba ɓyangɨnan ɓabɨr̰ɨnan daa habda gɨ dagɨla sɨwə.» ");
INSERT INTO sor_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Mana gɨ ta lə da, woni bwasa Mãr̰ĩ gechide day me gechide nə ɗang nənə nare nə Juwib day me dayar kɨrə nə woni bwasa Mãr̰ĩ geche dayə. An̰ji, gɨ ꞌwogɨw Kayip. ");
INSERT INTO sor_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Cendi pad dayyə ma gwale ɨrɨm dara ba gɨ kan̰jɨ kojɨgə dara ba gɨ yɨ gɨ Jesu me ba gɨ ꞌyəw nɨm. ");
INSERT INTO sor_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Me cendi way ba da: «Ladni duwa da, yɨnəndɨ gandɨw wála gaba sii ꞌywala lə ɗən̰ bədə, dara gaa nare di ha swaa ganandɨ gɨ gwale som.» ");
INSERT INTO sor_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesu ilə mana gɨ ciri dɨ Betani kɨrə nə abe mɨn gɨ gɨ ꞌwogɨw Simõ gaba cagɨmmə. ");
INSERT INTO sor_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Me mana gɨ Jesu ilə wama maniyə da, deme mɨn chidɨ hára sɨwə ib yəə mɨrda gɨ lade ɨsədɨ lə. Mɨrda gɨ ta di, swani gɨ habda gɨ bii ꞌyol nan̰ me kili duwa kaw, wom nan̰ me ca ilə dwalɨn̰yə. Tandi tidɨrɨw Jesu dɨwə. ");
INSERT INTO sor_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Mana gɨ woni gɨrsə gwale duwa yər yande da, dusɨrəgɨ nagɨ le me cendi wajɨ gwale bulə dayyə ba da: «Tandi mendɨ swani di bam yande, dana mo? ");
INSERT INTO sor_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Swani gɨ ta di, dee gɨ kɨlnəw bam da, gursɨ duwa di ha nan̰a le! Dee də ha ꞌyàgɨ́ nare nə bugɨr da, ladɨ bədə mo?» ");
INSERT INTO sor_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesu doy gwale day di me waygɨ da: «Anə jiba deme di yande dana mo? Mani nə tandi àl gandɨn ta di, àl i giyə gɨ lade. ");
INSERT INTO sor_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Nare nə bugɨr da, anə ha ꞌywagɨ le tuləngə gɨ wála wála, me ɨndi da, anə ha ꞌywan gɨ wála wála tuləngə bədə ɗɨm. ");
INSERT INTO sor_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Tandi tidɨrən swani sɨnnə ta di, i dara ɗangr̰a gɨ mõõ ni pii. ");
INSERT INTO sor_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Dwayna, nə wayang i gwale sɨw: Mana gɨ gɨ ha waya Nõ dɨ lade dɨ ta di sɨn̰a gɨndɨdɨ lə jiga jiga pad da, deme di kaw, gɨ ha waya gwale dɨra le dara mani nə tandi àl ta di, me nare dusɨrəgɨ ha ɨrmə dɨdə bi bi me ca.» ");
INSERT INTO sor_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ɨr̰ɨ, woni gɨrsə gwale gɨnə Jesu duwanə mwaj dii sɨr di gun day gɨ mɨn, an̰ju gɨ gɨ ꞌwogɨw Judas Iskariyot di, ha ꞌywaa woni bwasa Mãr̰ĩ gechide day ");
INSERT INTO sor_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","me an̰ji ùrgɨ ba da: «Nə ꞌyànang Jesu di ɨsɨrangə ɨndi da, anə ha ꞌyàn i na mo?» Woni bwasa Mãr̰ĩ gechide day di àsɨw gursɨ day dɨ chile gɨnɨn̰ subu ꞌyàw. ");
INSERT INTO sor_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","So i wála gɨ ta lə di me Judas di kan̰jɨ bɨrmə dara ꞌyàgɨ́ gɨ Jesu di ɨsɨragɨ lə. ");
INSERT INTO sor_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Wála gɨ dɨrɨn̰ nə piiyə gɨnə sii ꞌywala gɨnə mapa gɨ dɨban musbu da, woni gɨrsə gwale gɨnə Jesu duwa hára ùrɨw ba da: «Mə ùr ba nə hananin àlnam mani nə wama woni sii ꞌywala gɨnə kɨrara gɨ daa kwaynaniyə di i we mo?» ");
INSERT INTO sor_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Me an̰ji waygɨ da: «Hana mana gɨ ciri dɨ Jursalem kɨrə nə bidiyə me waynaw da: “Aba gɨlənin mani wayɨm ba da: ‹Dawa ni yala nemme ɗɨm. I kɨrə dɨma lə me nə hanin àla sii ꞌywala gɨnə kɨrara gɨ daa di lə gɨ nə woni gɨrsə gwale ni di.›”» ");
INSERT INTO sor_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Me woni gɨrsə gwale gɨnə Jesu duwa di hargɨ gɨra ha àla mani di ya Jesu ba ɨrməgɨ nɨm de, me cendi àl mani nə wama woni sii ꞌywala di lə. ");
INSERT INTO sor_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Gɨ turgɨ dawa ɗwanda dɨra lə da, Jesu dam ilə wama bɨwə day gɨ nə woni gɨrsə gwale duwa nə mwaj dii sɨr di mɨn. ");
INSERT INTO sor_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Me mana gɨ cendi ilə wama maniyə da, Jesu waygɨ ba da: «Dwayna, nə wayang i gwale sɨw: Gun mɨn dwar̰angə ha ꞌyàn woni mar̰ande ni ɨsɨragɨ lə.» ");
INSERT INTO sor_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Mwom da, woni gɨrsə gwale duwa di sɨdəgɨ mar bam ledede me cendi ùrbɨw mɨn mɨn ba da: «Aba ciri ni, gaa i ɨndi mo? Gaa i ɨndi mo?» ");
INSERT INTO sor_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Me Jesu cogɨ lə diiyə waygɨ ba da: «Gun mɨn gɨ hurə ɨsəw dása lə gandɨn mɨn ta di me i aba gɨra ha ꞌyàn woni mar̰ande ni ɨsɨragɨ lə an̰ju. ");
INSERT INTO sor_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","I sɨdɨ, ɨndi gɨ Gun gorndɨw di, nə ha mara le ꞌyang ya Maktubu dɨnə Mãr̰ĩ duwa ba way nɨm dara daran ta de. Me an̰ju gaba ꞌyàn woni mar̰ande ni ɨsɨragɨ lə di da, wamani ha ꞌywawe. Dee gɨ yànaw bədə kaw, dee biyawe.» ");
INSERT INTO sor_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judas gaba ꞌyàw woni mar̰ande duwa ɨsɨragɨ lə di, ùr duwa Jesu ba da: «Aba gɨlənin mani, gaa i ɨndi mo?» Me Jesu cow lə diiyə wayɨw ba da: «Mə way gwale gɨ ta di ɨjɨm gang.» ");
INSERT INTO sor_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Mana gɨ cendi ilə wama maniyə da, Jesu u mapa daa ɨsəwə me àlɨ́w Mãr̰ĩ dóche, me ɓolbɨ dodə, me ꞌyàgɨ́ woni gɨrsə gwale duwa di, me waygɨ ba da: «Unə, wamna, ta di i doni gɨ sɨn.» ");
INSERT INTO sor_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Targɨn̰ ɗang da, an̰ji u kob dɨ gani gɨnəyabɨr̰ayàa duwa ilə dwalɨn̰yə ɨsəwə me an̰ji àlɨw Mãr̰ĩ dóche do me u ꞌyàgɨ́ woni gɨrsə gwale duwa me waygɨ ba da: «Unə, chàna pad dannə pad. ");
INSERT INTO sor_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Dara ta di i bare ni gɨ Mãr̰ĩ yɨ gɨ mɨlan gɨ nare. I bare gɨ bor dodə dara nare nə gɨr̰e dɨdəgɨ dara Mãr̰ĩ kalna dusɨw hɨlalna àcn̰a day dɨwə. ");
INSERT INTO sor_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nə wayang daa: Caga da, nə ha chàa gani gɨ yabɨr̰a yàa duwa di ɗang bədə ɗɨm, bɨraa i wála gɨ ɗan̰ nə ha chàa gandang gɨ dɨrway alə ciri dɨnə Aban gɨ Mãr̰ĩyə.» ");
INSERT INTO sor_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ɨr̰ɨ targɨn̰ ɗang da, cendi tu diri dɨ idɨ bwaw gɨ Mãr̰ĩ jilay me cendi dɨmgɨ iche dara hára kur̰a dɨ Olib dɨdə. ");
INSERT INTO sor_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Mana gɨ ta lə da, Jesu waygɨ woni gɨrsə gwale duwa di ba da: «Changa dɨ laba lə di, mani ha àlanne me, pad dannə pad, anə ha bwara bam mana gɨ dusi dan dɨ kala dɨnnə di lə. Nə way yande dara Mãr̰ĩ way mana gɨ Maktubu duwa lə ba da: “Nə ha ꞌyáa aba gama dɨmən̰je di bam me, dɨmən̰je nə aba gamagɨ dáygɨ daa mana mɨn di, ha cagda daa dɨdəgɨ lə jiga jiga.” ");
INSERT INTO sor_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Me wála gɨ nə dara dɨmə daa munɨ lə mwom da, nə ha hára dɨrəngə gamang alə wama gɨ Galileyə.» ");
INSERT INTO sor_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ɨr̰ɨ Piyer wayɨw ba da: «Kwandan nə pad di bwarna bam dusi day dɨ kala mana gɨ dɨmmə di lə dara mani nə hára lə àlammə di kaw, ɨndi da, nə ha ɨndara bam dusi ni dɨ kala mana gɨ dɨmmə di bədə bɨr̰ɨn̰.» ");
INSERT INTO sor_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesu cow lə diiyə ba da: «Doy, nə wayɨm i gwale sɨw: Changa dɨ laba lə da, mana gɨ gɨray wor hɨrdə sɨn̰ da, mə ha bɨlə bɨm sarni ba mə ꞌwocn̰ɨn bədə dii subu.» ");
INSERT INTO sor_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Piyer cor wayaw ɗang bi ba da: «Nə ha bɨlə bɨn sarni dɨmmə bədə bɨr̰ɨn̰! Ina i made kaw, nə mar i gandɨm.» Me kwandaw nə woni gɨrsə gwale gɨnə Jesu duwa nə pad di kaw, way day yande me ca. ");
INSERT INTO sor_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Mwom da, Jesu hargɨ gɨ nə woni gɨrsə gwale duwa gɨrgɨ mana mɨn gɨ gɨ ꞌwogɨw Gesemani me, an̰ji waygɨ ba da: «ꞌYeni da, damna dodə mana gɨ ka lə, me ɨndi da, nə ha ni i alə ta dara amsa gɨ Mãr̰ĩ.» ");
INSERT INTO sor_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Me an̰ji wol Piyer me Jebede dɨndaw nə sɨr me mɨra ha gandɨw. An̰ji so ilə nulə sɨwə me lán̰a àlɨw nan̰e me ca. ");
INSERT INTO sor_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Mwom da, an̰ji waygɨ ba da: «Sɨn mar mara gɨ nə ꞌwocn̰ sɨn bədə bɨr̰ɨn̰. Damna mana gɨ ka lə di, me damna dɨrəng bɨ̀ra gandɨn!» ");
INSERT INTO sor_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Me an̰ji chidɨ ha bam hin̰e me kal sɨw ɨbər dodə sɨn̰a lə, me amsɨ gɨ Mãr̰ĩ ba da: «Aban, ladɨna dɨrəmmə da, chidɨ gɨlə gɨ dɨrɨn̰ gɨ ta di ha nɨm bam sɨnnə. Ladɨna bədə da, àl gandɨn mani nə dɨrəm ùr ɨjɨm, kal àla nə ùrə niyə ɗi.» ");
INSERT INTO sor_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ɨr̰ɨ Jesu cwara hára woni gɨrsə gwale duwa nə subu di sɨdəgɨ lə me ꞌyogɨ cendi ilə ꞌya nuniyə. Mwom da, an̰ji wayɨw Piyer ba da: «ꞌYeni da, dawa dɨ mɨn tenene dwar̰ɨ lə mɨra dimm, anə nem dama dɨrəng bɨ̀ra gandɨn bədə mo? ");
INSERT INTO sor_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Damna dɨrəng bɨ̀ra, me amsɨna Mãr̰ĩ dara mana gɨ mani ꞌywanang da, kal lamnang bwanang àla gɨ àcn̰a lə bədə. Dara gun gɨ gɨsage i gɨ ɨrmə gaba àla mani nə lade, me dwana duwa dɨ sɨw dɨ idɨ àlagɨ̀ nɨm di nem bədə.» ");
INSERT INTO sor_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","An̰ji chidɨ ha bam hin̰e bi gaba dii sɨrrə me kal sɨw amsɨ Mãr̰ĩ bi ba da: «Aban, ladɨna dɨrəmmə dara chidə gɨ wamani di hára nɨm bam sɨnnə bədə me mə ùrnə dara ba nə chànawe da, àl mana gɨ ùrə dɨma lə ɨjɨm.» ");
INSERT INTO sor_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ɨr̰ɨ Jesu cwara hára ꞌyo woni gɨrsə gwale duwa di bi, me ꞌyogɨ ꞌya gɨ nuniyə. Cendi nem dama dɨrəgɨ bɨ̀ra bədə dara nuni àlgɨ nan̰e. ");
INSERT INTO sor_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yər yande da, Jesu so kalgɨ me chidɨ yá bam hin̰e bi gaba dii subu lə. Mwom da, amsɨ Mãr̰ĩ, me way gwale gɨ ya dee ba a wayaw nɨm pii di de bi. ");
INSERT INTO sor_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Mana gɨ ba a cwara hára woni gɨrsə gwale duwa di tuləgɨ lə bi mwom da, an̰ji waygɨ ba da: «Anə i i nuni bi me, anə bo i gwayni me mo? Caga da, dawa di yala nemme ɗɨm. Ɨndi gɨ Gun gorndɨw di, gɨ ha ꞌyàn nare woni àla àcn̰a ɨsɨragɨ lə. ");
INSERT INTO sor_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Swana daa, hanandɨ le! Yarna, gun gaba ꞌyàn woni mar̰ande ni ɨsɨragɨ lə di yala ɗɨm.» ");
INSERT INTO sor_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Mana gɨ Jesu wor ilə waya gwaleyə bɨwə sɨn̰ da, Judas gɨ i woni gɨrsə gwale gɨnə Jesu duwa nə mwaj dii sɨr di gun day gɨ mɨn di, hára yala gɨ nare nə gɨr̰e nan̰ tarɨwə. Cendi i gɨ sugɨnəne nə sore me cilangde me ɨsɨragɨ lə. I woni bwasa Mãr̰ĩ gechide day me gechide nə ɗang nənə nare nə Juwib day me giyəgɨ cendi. ");
INSERT INTO sor_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas gaba ꞌyàgɨ́ Jesu ɨsɨragɨ lə di dee ɨrməgɨ le pii ɗɨm dara mani nə ba a ha àla dara gɨləgɨ nɨm gandɨw di. An̰ji wayagɨ ba da: «Gun gɨ nə gɨra dara yə̀w sɨnnə chichɨmə gajawya ba nə ùrɨw nan̰e de da, i an̰ji, yɨnəw.» ");
INSERT INTO sor_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Mana gɨ ta lə dog me Judas ha ɨjɨ Jesu me wayɨw ba da: «Nə àlɨm labiya, aba gɨlənin mani!» do me an̰ji yɨw sɨwə chichɨm nɨm gɨ gajaw sɨn̰. ");
INSERT INTO sor_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Me Jesu cow wayɨw ba da: «Jan maché, mani nə mə hára dara àlagɨ̀ ka di, àlgɨ le maa ɗɨm!» Mwom da, nare di chidɨbə sɨwə ib ib me ɓɨr̰ɨn̰ lawar Jesu dɨwə me yɨw nɨm. ");
INSERT INTO sor_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Mana gɨ ta lə di, woni hára gɨ Jesu di gun day gɨ mɨn dɨmə jisgɨ biy sugɨnə duwa me ajɨ gɨ kwaya gɨnə woni bwasa Mãr̰ĩ geche day duwa di sumɨw led saw àl bam. ");
INSERT INTO sor_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Mana gɨ ta lə da, Jesu wayɨw gun duwa gɨ ta di ba da: «Hurə sugɨnə dɨma di daa mana dɨra lə bi, dara nare pad woni ꞌyáa kwandagɨ gɨ sugɨnəne da, ha mara i made dɨ sugɨnə me ca. ");
INSERT INTO sor_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Mə ɨrɨm dara nə nem gaba ꞌwaga Aban gɨ Mãr̰ĩ bədə mo? Dee nə ꞌwagɨnaw da, mana gɨ ta lə di dog, an̰ji dee ha giyən paja duwa nə daa ya dubu dubu ɨndi na de gɨra ha wannə. ");
INSERT INTO sor_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Me dee nə ꞌwagɨnawe da, mani nə Maktubu dɨnə Mãr̰ĩ duwa way gwale day ba ha àlala le yande bá da, cendi ha àlala i man man mo?» ");
INSERT INTO sor_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Dawa dɨ ta lə da, Jesu waygɨ nare nə gɨr̰e di ba da: «Anə hára gɨ sugɨnəne nə sore me cilangde me ɨsɨrangə dara yə̀n gɨ dwana hára nɨm ya ba nə i mẽ de. Gɨ wála wála, nə dam lə ciri dwar̰ɨ dɨ kulu gaba bwasa Mãr̰ĩ ilə dara gɨlə gɨ mani kaw, anə yə̀n bədə. ");
INSERT INTO sor_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Me mani nə ta di pad àlal yande dara gwale gɨ woni cɨmə Mãr̰ĩ bɨw jangɨw Maktubu dɨnə Mãr̰ĩyə pii di me yala àlal an̰ju.» Mana gɨ ta lə da, woni gɨrsə gwale gɨnə Jesu di pad dayyə ɓɨr̰ɨn̰ wà daa kalɨw bam. ");
INSERT INTO sor_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Nare woni yəə Jesu di wolɨw ha gandɨw mana gɨ woni bwasa Mãr̰ĩ geche day gɨ gɨ ꞌwogɨw Kayip dɨrəwə. I mana gɨ ta lə di me woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa me gechide nə ɗang nənə nare nə Juwib day me dayar lə. ");
INSERT INTO sor_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Piyer duwa da, wara bam targɨn̰ hən̰ me ha pam gɨ Jesu tarɨw bɨraa ha nɨm kɨrə ciri dɨnə woni bwasa Mãr̰ĩ geche day duwa lə bá. An̰ji dɨm ha kɨrə dama woni àlaw geche giyə dwar̰agɨ lə, dara yara gɨ mani di gaa ba ha ꞌyan̰a i man mo? ");
INSERT INTO sor_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Woni bwasa Mãr̰ĩ gechide day me nare woni àla sariya nə ɗang nənə Juwib day pad me kan̰jɨ gwale gɨ kulagɨ dara bwaw Jesu dɨwə ba gɨ ꞌyəw nɨm. ");
INSERT INTO sor_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Me nare woni kulagɨ nan̰ hára sabɨ gwale bow Jesu dɨwə kaw, woni bwasa Mãr̰ĩ gechide day me woni àla sariya nə ɗang pad dayyə me ꞌyo gwale mɨn gaba ꞌyáw nɨm bədə. Targɨn̰ ꞌyan̰a lə da, nare sɨr hára ");
INSERT INTO sor_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","way ba da: «Abe gɨ ta di way ba a nem cubə kulu gaba bwasa Mãr̰ĩ di bam me ba a ha cwara awaw daa bi wála subu dalawə.» ");
INSERT INTO sor_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Woni bwasa Mãr̰ĩ geche day di so daa me wayɨw Jesu ba da: «Gwale gɨ nare way dara daram ta di, mə àsɨ dɨma gwale mɨn lə diiyə bədə mo?» ");
INSERT INTO sor_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Me Jesu dam bɨw mɨgɨmi kur̰ad. Ɨr̰ɨ woni bwasa Mãr̰ĩ geche day di wayɨw ba da: «Nə ùrɨm gɨ Mãr̰ĩ gaba dama gɨ dɨrəw bɨ̀ra sumɨw, waynin daa: Ɨjɨm di me mə i Dole gɨ Mãr̰ĩ biyəw gɨ Kris di mo? Mãr̰ĩ gorndɨw di mo?» ");
INSERT INTO sor_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesu cow lə diiyə ba da: «Mə way gwale gɨ ta di ɨjɨm gang. Me nə wayang daa: So caga ka da, anə ha yara Gun gorndɨwdama lə mana gɨ Mãr̰ĩ gaba dwana pad ɨsəw gɨ abeyə.Me anə ha yaraw cwara lə gɨ ꞌywagda duwa mana gɨ siyaya gɨ daa dalawə me ca.» ");
INSERT INTO sor_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Mana gɨ ta lə da, woni bwasa Mãr̰ĩ geche day di so chəbɨ barge gɨ sɨwə bam me way da: «An̰ji cadɨbɨ i Mãr̰ĩ! Də ùrəng nare woni cɨməndɨ gwale nə ɗang bədə ɗɨm! Anə doy widɨru gɨ an̰ji cadɨbɨ gɨ Mãr̰ĩ ta di gɨ sumdəng dan ꞌyeni ɗɨm. ");
INSERT INTO sor_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Anə ɨrɨm i man daraw mo?» Cendi cow lə diiyə ba da: «An̰ji ùr i ꞌyáa gɨ bam.» ");
INSERT INTO sor_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ɗang da, nare nə mɨn ɓɨsɨbɨw lade dɨrəwə me gobɨw gɨ ɨsɨragɨ me. Nə yab da, gobɨ gajaw ");
INSERT INTO sor_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","me wayɨw da: «Ɨjɨm gɨ Dole gɨ Mãr̰ĩ biyəw gɨ Kris di, mə ina i aba cɨmə Mãr̰ĩ bɨw ꞌyang da, waynin daa: I wi me ajɨm ta di mo? I wi me ajɨm ta di mo?» ");
INSERT INTO sor_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Mana gɨ ta lə da, Piyer dam duwa iche ciri dwar̰ɨ lə. Me deme mɨn dɨ idɨ àla giyə ciri dɨ ta di dwar̰ɨ lə chidɨ hára sɨwə ib me wayɨw da: «Ɨjɨm di kaw, mə i gɨ Jesu gɨ Galile di mɨn me ca.» ");
INSERT INTO sor_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Me Piyer bɨl bɨw sarni daa nare dɨrəgɨ lə pad ba da: «Nə ꞌwocn̰ gwale gɨ dɨ wayɨw ta di gɨndɨw bədə.» ");
INSERT INTO sor_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ɗang da, an̰ji ha ɨjɨ ciri bɨdɨ dara ganda iche me deme dɨ mɨn ɗang dɨ idɨ àla giyə ciri dɨ ta di dwar̰ɨ lə yərɨw me waygɨ nare nə ilə mana gɨ ta lə di ba da: «An̰ju gɨ ta di i gɨ Jesu gɨ Najaret di mɨn me ca.» ");
INSERT INTO sor_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ɨr̰ɨ Piyer bɨl bɨw sarni ɗang bi me sɨrgɨ sɨw me ba da: «Nə ꞌwocn̰ abe gɨ ta di bədə.» ");
INSERT INTO sor_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ɓam targɨn̰ da, nare nə ilə mana gɨ ta lə di chidɨbə Piyer sɨwə ib ib me wayɨw da: «ꞌYang, ɨjɨm di kaw, mə i aba hára gɨ Jesu di me ca. Gɨ ꞌwocn̰ɨm i dara mar̰ɨjam woni waya gwale.» ");
INSERT INTO sor_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Mwom da, Piyer so waygɨ: «Nə sɨrgɨ sɨn! Nə wayna i kulagɨ da, Mãr̰ĩ yɨnən dange: Nə ꞌwocn̰ abe gɨ ta di bədə!» Mana gɨ ta lə dog gɨray hɨrdɨ me. ");
INSERT INTO sor_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Mwom da, Piyer dusɨw guw daa gwale gɨnə Jesu duwa gɨ wayaw gandɨw pii di dɨwə. An̰ji wayaw ba da: «Pii gɨ gɨray wor hɨrdə sɨn̰ da, mə ha bɨlə bɨm sarni dɨm subu ba mə ꞌwocn̰ɨn bədə.» Ɨr̰ɨ Piyer dɨmə iche me nul nulə gɨ àcn̰e. ");
INSERT INTO sor_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Mana wal bam gɨ jomni cor̰ər̰ə da, woni bwasa Mãr̰ĩ gechide day me gechide nə ɗang nənə nare nə Juwib day me dayar dodə mana mɨn maa gwale gaba ꞌyáa Jesu di. ");
INSERT INTO sor_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Mwom da, cendi yɨw magdɨw me ha gandɨw ꞌyàw gun gɨRomgɨ gɨ ꞌwogɨw Pilat gɨ gɨ chɨ́w dole wama gɨJudeyə̀ ɨsəwə. ");
INSERT INTO sor_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ɨr̰ɨ Judas gaba ꞌyàa Jesu woni mar̰ande duwa ɨsɨragɨ lə di ba a yər dara ba gɨ maa gwale dara ꞌyáa gɨ Jesu di bam da, an̰ji bo bagɨn me an̰ji ha cwagɨ woni bwasa Mãr̰ĩ gechide day me gechide nə ɗang nənə nare nə Juwib day me gursɨ day dɨ chile gɨnɨn̰ subu di daa. ");
INSERT INTO sor_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Me an̰ji waygɨ ba da: «Nə ꞌyàng gun gɨ àl mani mɨn bədə anə banə ꞌyánaw bam ta di, nə àl i àcn̰a.» Me cendi cow lə diiyə ba da: «Gwale gɨ ta di, dolnin bədə. Ta di i gwale dɨma ɨjɨm.» ");
INSERT INTO sor_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ɨr̰ɨ Judas di cor ha bwaa gursɨ di bam mana gɨ kulu gaba bwasa Mãr̰ĩ dalawə me kal sɨw ha bwaa sade ꞌyáa sɨw bam. ");
INSERT INTO sor_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Me woni bwasa Mãr̰ĩ gechide day di lay gursɨ di daa me way ba da: «Də nem bwaa gursɨ dɨ ta di ɓamadɨ gɨ kondɨdɨ dɨ kulu gaba bwasa Mãr̰ĩ di daa mɨn bədə, dara ta di i gursɨ dɨ bare.» ");
INSERT INTO sor_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Cendi ɨrɨm me ma gwale ba gursɨ dɨ ta di, ba gɨ kɨl gɨ daga gɨnə aba awa dáge duwa me ba gɨ cow mana gaba mõõ nare nə mɨje. ");
INSERT INTO sor_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","I dara yande me, daga gɨ ta di, caga ka kaw, gɨ wor ꞌwogɨw i «daga gaba bare». ");
INSERT INTO sor_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ta di me i mani nə tanga aba cɨmə Mãr̰ĩ bɨw gɨ Jeremi waya gwale day di me yala àlal kɨrab. An̰ji waya ba da: «Cendi ꞌwoo gursɨ dɨ chile gɨnɨn̰ subu ta di, i gursɨ dɨ nare nəIsrayelɨrmədɨ pii dara kɨlə gɨ gun gɨ ta di. ");
INSERT INTO sor_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Cendi ꞌyàgɨ́ gursɨ dɨ ta di dara ba gɨ kɨlnə gɨ daga gɨnə aba awa dáge duwa di, ya Aba ciri gɨ Mãr̰ĩ ba wayan nɨm de.» ");
INSERT INTO sor_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Me Jesu ɗɨbɨ mana gɨ dole gɨ Pilat dɨrəwə me an̰ji ùrɨw ba da: «Ɨjɨm di me mə i dole gɨnə Juwib day di mo?» Jesu cow lə diiyə ba da: «Mə way gwale gɨ ta di ɨjɨm gang.» ");
INSERT INTO sor_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Woni bwasa Mãr̰ĩ gechide day me gechide nə ɗang nənə nare nə Juwib day me hára sabɨw Jesu gwale bow dɨwə kaw, an̰ji àsɨgɨ gwale mɨn lə diiyə bədə. ");
INSERT INTO sor_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ɨr̰ɨ Pilat wayɨw da: «Gwale gɨ pad gɨ nare bom dɨmmə ta dimm, mə doy bədə mo?» ");
INSERT INTO sor_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Me Jesu di cow dole gɨ Pilat di gwale mɨn tenene mana gɨ gwale pad gɨ gɨ bow dɨwə ta di lə bədə. Yande da, Pilat ɨrɨm gwale nan̰e. ");
INSERT INTO sor_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Mana gɨ wála gaba àla sii ꞌywala gɨnə kɨrara gɨ daa kwaynaniyə gɨnə Juwib dayyə da, Pilat gɨrgɨ i dange mɨn daa bá bá. I dange gɨ nare nə gɨr̰e di ùrɨw cendi do me an̰ji gɨrɨw daa sɨn̰. ");
INSERT INTO sor_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Wála gɨ ta lə di da, dange mɨn gɨ sumɨw ꞌwogɨ nan̰ ilə. Sumɨw i Barabas. ");
INSERT INTO sor_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nare di dayar gɨr̰ɨ nan̰, me Pilat di ùrgɨ ba da: «Nare nə sɨr ta di dwar̰agɨ lə da, anə ùr ba nə gɨrnəng i gɨ we daa mo? Barabas, labaa Jesu gɨ gɨ ɨrɨm ba i Dole gɨ Mãr̰ĩ biyəw gɨ Kris di mo?» ");
INSERT INTO sor_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ɓag kaw, Pilat ꞌwocn̰ com dara i dusi dɨ halgɨni me cendi ba yəə gɨ Jesu hára ꞌyàw nɨm gandɨw ɨsəwə ta di. ");
INSERT INTO sor_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Mana gɨ Pilat wor dam lə mana gaba aa sariya lə sɨn̰ da, dyaməw giyə gun gɨra wayɨw ba da: «Gun gɨ ta di àl mani mɨn tenene bədə. Kal hura sɨm mana gɨ gwale duwa lə ɗi, dara changa dɨ tanga lə da, chine gɨ àcn̰e àlɨn nan̰e dara daraw!» ");
INSERT INTO sor_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Woni bwasa Mãr̰ĩ gechide day me gechide nə ɗang nənə nare nə Juwib day di me nogɨ nare nə gɨr̰e di gɨndəgɨ daa dara ba waynaw ba gɨrnə Barabas daa me, ba ꞌyána Jesu bam me ca. ");
INSERT INTO sor_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Dole di cor u gwale ùrgɨ ba da: «Nare nə sɨr ta di, anə ùr ba nə gɨrnəng i gɨ we daa mo?» Cendi ɓɨr̰ɨn̰ bo gura ba da: «Gɨr Barabas! Gɨr Barabas!» ");
INSERT INTO sor_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ɨr̰ɨ Pilat ùrgɨ da: «Me Jesu gɨ gɨ ɨrɨm ba i Dole gɨ Mãr̰ĩ biyəw gɨ Kris di da, anə ùr ba nə àlnaw man mo?» Cendi pad dayyə cow lə diiyə ba da: «Ɓengɨw ɓabɨr̰ɨw daa habda gɨ dagɨla sɨwə! Ɓengɨw ɓabɨr̰ɨw daa habda gɨ dagɨla sɨwə!» ");
INSERT INTO sor_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilat ùrgɨ ɗang ba da: «Me an̰ji àl i mani na nə àcn̰e mo?» Cor cendi ɓɨr̰ɨn̰ bo gura daa nan̰ nan̰ ɗang bi ba da: «Ɓengɨw ɓabɨr̰ɨw daa habda gɨ dagɨla sɨwə! Ɓengɨw ɓabɨr̰ɨw daa habda gɨ dagɨla sɨwə!» ");
INSERT INTO sor_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Mana gɨ Pilat yər dara nare nə gɨr̰e di ba doy gwale duwa bədə, me gura day di ba nɨm nan̰ nan̰ me da, an̰ji ꞌwoo nimi me wiy gɨ ɨsaw bam nare nə gɨr̰e di dɨrəgɨ lə me waygɨ ba da: «Bare gɨnə gun gɨ ta di duwa da, yɨ dɨn ɨndi bədə. Me i gwale dan ꞌyeni.» ");
INSERT INTO sor_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Me nare nə gɨr̰e di pad cow wayɨw da: «Kal bare duwa di warna dɨdəninnə nenin me warna dɨndɨranin dɨdəgɨ lə me ca.» ");
INSERT INTO sor_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Mana gɨ ta lə da, Pilat di gɨrgɨ Barabas di daa, ɨr̰ɨ Jesu da, an̰ji kal gɨ gobɨw gɨ bɨr̰aw do me ꞌyàgɨ́ gandɨw dara ba gɨ hana ɓengɨnaw ɓabɨr̰anaw daa habda gɨ dagɨla sɨwə sɨn̰. ");
INSERT INTO sor_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Asɨngar nənə dole gɨ Pilat duwa di yɨ Jesu ha nɨm kɨrə bɨdang dɨnə dole duwa lə di, me dajaw kwandagɨ asɨngar nə pad di tulɨwə. ");
INSERT INTO sor_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Cendi n̰ir̰ɨbɨw barge duwa bam sɨwə me cor hurəw barge gɨ kwamge sɨwə ɨrmɨw nɨm ya dole de. ");
INSERT INTO sor_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Cendi ku jagɨwa gɨ habde gangr̰agɨ woni jimdi hurəw dɨwə me, u dɨrwa hurəw ɨsəw gɨ abeyə me ca. Ɗang da, cendi hára piy gubɨrəgɨ dodə dɨrəwə me àlɨw nɨm gɨ məng wayɨw ba da: «Labiya, dole gɨnə Juwib day!» ");
INSERT INTO sor_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Cendi ɓɨsɨbɨw lade sɨwə me u dɨrwa gɨ ɨsəwə di gobɨ gɨ dɨw me ca. ");
INSERT INTO sor_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Mana gɨ cendi àlɨw məng di bam pad mwom da, cendi n̰ir̰ɨw barge gɨ kwamge di bam sɨwə, me cor hurbəw barge duwa di sɨwə bi me dɨm ha gandɨw dara ɓyangaw ɓabɨr̰aw daa habda gɨ dagɨla sɨwə. ");
INSERT INTO sor_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Mana gɨ asɨngar di gandɨ gɨ Jesu di bam ciri tuldɨ lə hin̰e mwom da, cendi ɓamar gɨ abe gɨ ciri duwa i Siren gɨ sumɨw Simõ. Cendi yɨw gɨ dwana ba unə habda gɨ dagɨla gɨnə Jesu duwa di. ");
INSERT INTO sor_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Cendi hargɨ gandɨ mana mɨn gɨ gɨ ꞌwogɨw Golgota, gɨndɨw dɨ biyə da, i «mana gaba dii kungɨng dɨra». ");
INSERT INTO sor_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Mana gɨ ta lə da, cendi ꞌyàw Jesu gani gɨ yabɨr̰a yàa duwa gɨ gɨ ɓamɨw gɨ dɨrɨn̰ ba chàna. An̰ji ɨm yər me gɨn̰ chàa bam. ");
INSERT INTO sor_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Targɨn̰ ɗang da, cendi ɓengɨw ɓabɨr̰ɨw daa habda gɨ dagɨla sɨwə. Ɨr̰ɨ, cendi gobɨ jagi me ɨsɨ gɨ barge duwa di sɨdəgɨ lə me ca. ");
INSERT INTO sor_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ɨr̰ɨ, cendi damdɨ lə dodə dara gamaw nɨm. ");
INSERT INTO sor_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Cendi ɓabɨr̰ɨ mani daa Jesu dɨwə me jangɨ lə siiyə dara biyə gɨ made duwa di gɨndɨdɨ. Mani nə gɨ jangɨgɨ di, way ba da: Ta di i Jesu, dole gɨnə Juwib day di. ");
INSERT INTO sor_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Asɨngar di ɓengɨdɨ miidi nə gechide sɨr ɓabɨr̰ɨgɨ lə daa habde nə dagɨla sɨdəgɨ lə Jesu tulɨwə, gɨ mɨn ɨsəw gɨ abeyə me, gɨ mɨn ɨsəw gɨ jeleyə me ca. ");
INSERT INTO sor_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Nare nə ha jə̀ gɨ lə ta di gɨgdɨ dɨdəgɨ, me àl Jesu məng me wayɨw ba da: ");
INSERT INTO sor_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","«Cheye! Ɨjɨm gɨ mə way ba mə ha cubə kulu gaba bwasa Mãr̰ĩ di bam me, ba mə ha cwara awaw daa bi wála subu dalawə di, kɨdɨ sɨm daa gɨ ɨsəm dɨma gang! Mə ina i Mãr̰ĩ gorndɨw ꞌyang da, chə́y dodə habda gɨ dagɨla di sɨwə!» ");
INSERT INTO sor_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Woni bwasa Mãr̰ĩ gechide day di kaw, àlɨw məng day gɨ nə woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa di me gechide nə ɗang nənə nare nə Juwib day pad me ca. ");
INSERT INTO sor_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Cendi way ba da: «An̰ji kɨdə nare nə ɗang daa me nem kɨdə sɨw duwa gang bədə mo? Ina i dole gɨnə Israyel day da, a chɨ́nə dodə habda gɨ dagɨla di lə caga ka dɨ yarang do me də hárang kala dusɨrəndɨ dɨwə sɨn̰. ");
INSERT INTO sor_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","An̰ji kal dusɨw Mãr̰ĩ dɨwə. Yande da, Mãr̰ĩ di ùrnəwe da, a kɨdɨnəw daa caga ka, dara an̰ji way ba a i Mãr̰ĩ gorndɨw.» ");
INSERT INTO sor_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Miidi nə gɨ ɓengdɨgɨ ɓabɨr̰əgɨ daa tulɨwə di kaw, àlɨw məng yande di dige dige me ca. ");
INSERT INTO sor_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Mana gɨ dawa ba dɨ ɗɨbɨ ciri dwar̰ɨ lə da, mana gɨdɨ dilɨm kɨdab sɨn̰a gɨndɨdɨ lə pad, bɨraa dawa pagar nɨm bá. ");
INSERT INTO sor_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ɨr̰ɨ mana gɨ dawa ba dɨ pagar nem dawa subu ɗɨm da, Jesu soy mar̰ɨjaw daa nan̰: «Eli, Eli, lema sabagtani?» Gɨndɨw dɨ biyə way ba da: «Mãr̰ĩ ni, Mãr̰ĩ ni, dana me mə kalɨn bam mo?» ");
INSERT INTO sor_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nare nə ɗɨbɨ lə mana gɨ ta lə di da, nə yab dwar̰agɨ lə doy me way ba da: «An̰ji ꞌwogɨ i aba cɨmə Mãr̰ĩ bɨw gɨ Eli!» ");
INSERT INTO sor_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Mana gɨ ta lə di dog, gun day mɨn wà gɨ gidi gɨra ha laya mani nə wun ya chire de, su mana gɨ gani gɨ yale gɨnə yabɨr̰a yàa duwa lə. Ɨr̰ɨ an̰ji hurə mani di mana gɨ dɨrwa bɨwə me u gɨlɨw Jesu bɨwə dara ba chichɨmɨnə. ");
INSERT INTO sor_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Cor nare nə ɗang wayɨw ba da: «Kal jang! Də yarang gaa Eli di hára lə kɨdəw daa sɨn̰ mo?» ");
INSERT INTO sor_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Me Jesu soy swaya gɨ geche mɨn ɗang bi me bɨw som. ");
INSERT INTO sor_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Mana gɨ ta lə di dog da, barge gɨ geche gɨ gɨ jə̀w mana gɨ Kulu gaba bwasa Mãr̰ĩ dalawə dara sabaw nɨm dodə di, chowər dodə korgɨn̰ sɨr, swaa daa hára dodə ced. Sɨn̰a gɨgdər, me kur̰a kaw, jəgdər bam me ca. ");
INSERT INTO sor_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Munɨni bɨdəgɨ kaw, tɨn̰bər bam, me nare nan̰ nə kal dusɨrəgɨ mɨn Mãr̰ĩ dɨwə me mar nɨm kaw, ɓɨr̰ɨn̰ə daa madeyə me ca. ");
INSERT INTO sor_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Wála gɨ Jesu gandɨ daa munɨ lə da, cendi kaw, gandɨ daa munɨni dayyə me hargɨ ciri dɨ Jursalemmə dɨ i ciri dɨnə Mãr̰ĩ duwa, me nare nə gɨr̰e kaw, yərgɨ me. ");
INSERT INTO sor_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Asɨngar nə Rom geche day gɨ nə kwandaw woni gama Jesu di ba gɨ yər sɨn̰a gɨgdara lə me mani pad nə àlal di me da, lán̰a àlgɨ nan̰e me cendi way ba da: «I sɨdɨ, gun gɨ ta di i Mãr̰ĩ gorndɨw ꞌyang!» ");
INSERT INTO sor_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Namde nan̰ kaw, ɗɨbə hən̰ ilə yara lə. I cendi nə pama Jesu ɓɨgden̰ mana gɨ wama gɨ Galileyə bá yala nɨm ka dara àlaw gɨ giyə di. ");
INSERT INTO sor_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Namde nə ta di dwar̰agɨ lə da, i Mari dɨ ciri dɨra i Magdala me, Mari dɨ nə Jak day gɨ Josep idəgɨ me, Jebede dɨndaw idəgɨ me ilə. ");
INSERT INTO sor_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Gɨ dawa dɨ turgɨ da, abe mɨn gaba ꞌywaa mani nan̰ gɨ gɨ ꞌwogɨw Josep hára gɨra. Ciri duwa i Arimate me an̰ji kaw, i aba gɨrsə gwale gɨnə Jesu duwa me ca. ");
INSERT INTO sor_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","An̰ji ha ꞌywaa dole gɨ Pilat me ùrɨw Jesu kumbɨ duwa. Me Pilat waygɨ nare duwa ba ꞌyànaw kumbɨ di. ");
INSERT INTO sor_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Josep u kumbɨ di me legɨrɨ daa gɨ bagda dɨ bure dɨ dɨrway ");
INSERT INTO sor_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","me an̰ji u ha àsa mana gɨ munɨ gɨ dɨrway gɨ dii mɨn gɨ wor àsa gun lə dalawə sɨn̰. Munɨ gɨ ta di, an̰ji ɗangr̰ɨw i duwa an̰ju gaba ciri mana gɨ kur̰a dwar̰ɨ lə. Mana gɨ an̰ji àsɨw lə mwom da, an̰ji nongr̰ɨ kur̰a dɨ jore ɗesɨ gɨ munɨ di bɨw daa me kal sɨw ya. ");
INSERT INTO sor_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Me Mari dɨ ciri dɨra i Magdala di me, Mari dɨ ɗang me, damgɨ lə dodə mana gɨ ta lə munɨ di dɨrəwə tɨba. ");
INSERT INTO sor_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Sanga dɨra da, wála gaba ɗangr̰a sii dara wála gaba bwaa gwayni di ꞌyen̰ bam mwom da, wála gaba bwaa gwayni di nemme ɗɨm. Mwom da, woni bwasa Mãr̰ĩ gechide day me nare nə gɨ ꞌwogɨgɨ Parise me dayargɨ pad nə dole gɨ Pilat lə. ");
INSERT INTO sor_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Cendi wayɨw da: «Dole, dusɨrənin gunin mani mɨn dɨdəgɨ lə. Aba kulagɨ gɨ ta di, mana gɨ an̰ji wor nɨm gɨ dɨrəw sɨn̰ da, way ba a àlna wála subu mwom da, ba a ha dɨmə i daa munɨ lə. ");
INSERT INTO sor_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Yande da, u bɨm way dara kal asɨngar gamna munɨ di ladɨ le bɨraa wála subu bá do, pəgɨn̰ bədə da, woni gɨrsə gwale duwa gɨra hára biyə kumbɨ duwa di hára nɨm me, gɨra ha cwara wayagɨ nare di an̰ji ba dɨm daa munɨ lə. Me kulagɨ dɨ targɨn̰ ka di da, ha nan̰a ɗwaya dɨ pii di bam.» ");
INSERT INTO sor_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilat waygɨ da: «Yarna, asɨngar i ta, hana gamna munɨ di ya dɨrəng ba ùr nɨm de.» ");
INSERT INTO sor_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Cendi bor ha munɨ lə di, me r̰ey kur̰a dɨ munɨ bɨwə di bɨdɨ dodə, me kal asɨngar ɗɨbɨ gamɨw me ca. ");
INSERT INTO sor_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Wála gaba bwaa gwayni di tarɨwə da, i dɨmas. Gɨ jomni cor̰ər̰ə da, Mari dɨ Magdala me Mari dɨ ɗang di me, borgɨ hargɨ dara yara gɨ munɨ gɨnə Jesu di. ");
INSERT INTO sor_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Mana gɨ ta lə dog, jisgɨ yande da, sɨn̰a gɨgdər daa gɨ dwana! Paja gɨ daa gɨnə Aba ciri gɨ Mãr̰ĩ duwa mɨn swaa daa chə́ə hára nongr̰ɨ kur̰a dɨ gɨ ɗesɨ gɨ munɨ bɨw di àsɨdɨ bam tulɨn̰yə, me dam lə diiyə me. ");
INSERT INTO sor_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Sɨw ꞌyogdɨ le ya Mãr̰ĩ wur̰ɨn̰ə duwa de, me barge duwa kaw, wusɨ le kəng ya duru de me ca. ");
INSERT INTO sor_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Asɨngar woni gama munɨ di, lán̰a àlgɨ nan̰e me, sɨdəgɨ sadɨgɨ tag tag me, cendi bor dodə wun ya nare nə mare de. ");
INSERT INTO sor_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ɨr̰ɨ, paja gɨ daa di waygɨ namde di ba da: «ꞌYeni da, àlna lán̰a bədə! Nə ꞌwocn̰ dara anə kan̰jɨ i Jesu, an̰ju gɨ gɨ ɓengɨw ɓabɨr̰ɨw daa habda gɨ dagɨla sɨwə di. ");
INSERT INTO sor_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","An̰ji ilə ka bədə, dara an̰ji dɨm daa munɨ lə ya ba a wayang nɨm pii ta de. Hane, yarna mana gɨ tanga gɨ àsɨ gɨ kumbɨ duwa lə di. ");
INSERT INTO sor_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Me hana kaláng waynagɨ woni gɨrsə gwale duwa di, an̰ji ba dɨm daa nare nə mare dwar̰agɨ lə me, an̰ji ba yá gamagɨ lə alə wama gɨ Galileyə. Cendi ba gɨrnə alə ta da, ba ha yaraw. Ta di me i gwale gɨ nə wayang di.» ");
INSERT INTO sor_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Mwom da, namde di borgɨ kaláng yalgɨ kal munɨ di bam. Lán̰a àlgɨ nan̰e me sɨdəgɨ kaw, ꞌyolgɨ nan̰e me ca. Cendi wagɨ gɨ gidi dara hára cɨməgɨ gɨ woni gɨrsə gwale gɨnə Jesu duwa di. ");
INSERT INTO sor_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Mana gɨ ta lə dog jisgɨ yande da, Jesu hára sawa namde di dɨrəgɨ daa me waygɨ ba da: «Nə àlang labiya!» Ɨr̰ɨ cendi chidɨbə hára piy gubɨrəgɨ dodə dɨrəwə, yɨbɨ gɨdaw me mɨlawdɨw nɨm. ");
INSERT INTO sor_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ɨr̰ɨ an̰ji waygɨ ba da: «Lán̰ɨna bədə! Hana waynagɨ chamran di kalgɨ gɨ hana mana gɨ wama gɨ Galileyə, cendi ba ha yaran i alə ta.» ");
INSERT INTO sor_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Mana gɨ namde di ilə hára lə bɨrmə lə mwom da, asɨngar woni gama munɨ di, nə yab háragɨ dara cɨməgɨ woni bwasa Mãr̰ĩ gechide day mani pad nə àlal ta di daa. ");
INSERT INTO sor_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Mwom da, woni bwasa Mãr̰ĩ gechide day di ꞌwaga gechide nə ɗang nənə nare nə Juwib day me dayar gandagɨ maa gwale me ꞌyàgɨ́ asɨngar di gursɨ nan̰ ");
INSERT INTO sor_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","me gɨsɨgɨ dodə ba kal cendi ba hana wayna ba gɨ changa ba gɨ i nuni da, woni gɨrsə gwale duwa ba gɨra mĩy kumbɨ duwa di u yá nɨm. ");
INSERT INTO sor_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Me cendi waygɨ ɗang ba da: «Ɗan̰ dole gɨ Pilat di dwayna gwale gɨ ta di kaw, nə hananin ꞌwacn̰a bɨrmə gaba biyəw gwale gɨ lade dara kal anə ꞌywana gwale bədə.» ");
INSERT INTO sor_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Mwom da, asɨngar di yɨ gursɨ di me, àl mani nə gɨ waygɨ cendi ba àlnagɨ di. I ta di me, laba laba kaw, gwale gɨ woni gɨrsə gwale gɨnə Jesu duwa ba mĩy kumbɨ duwa bam ta di, nare nə Juwib ilə wayawə sɨn̰. ");
INSERT INTO sor_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Woni gɨrsə gwale gɨnə Jesu duwa nə mwaj dii mɨn di hargɨ gɨr mana gɨ wama gɨ Galileyə kur̰a dɨ tanga Jesu waygɨ ba hana lə di dɨdə. ");
INSERT INTO sor_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Mana gɨ ba gɨ yərɨw mwom da, cendi piy gubɨrəgɨ dodə dɨrəwə me mɨlawdɨw, me nə yab da, ilə gaga gwaleyə dusɨrəgɨ lə. ");
INSERT INTO sor_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Mwom da, Jesu chidɨ sɨdəgɨ lə me waygɨ ba da: «Dwana pad dɨ daa me dɨ dodə me da, Mãr̰ĩ ꞌyàn gandɨdɨ i ɨsənnə ɨndi. ");
INSERT INTO sor_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Yande da, hana sɨn̰a gɨndɨdɨ lə pad: Cwana nare nə gɨndəgɨ jiga jiga pad kalgɨ gɨ kɨdɨnə woni gɨrsə gwale ni, me àlnagɨ batem gɨ Aban gɨ Mãr̰ĩ sumɨw me ɨndi gɨ Gorndɨw sumɨn me gɨ Dúndi duwa sumdɨ me ca. ");
INSERT INTO sor_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Gɨlnəgɨ kalgɨ gɨ àlna bɨn gɨ nə wayang gandɨw di bá bá. Me dwayna: Ɨndi da, nə ilə gandang gɨ wála wála bɨraa dɨr̰ɨn̰a ꞌyan̰a dɨra lə bá.»");
INSERT INTO sor_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","2","Dwaynandɨ Nõ dɨ lade dɨnə Jesu Kris gɨnə Mãr̰ĩ gorndɨw duwa di. Mani di diy gɨnɨn̰ i ya aba cɨmə Mãr̰ĩ bɨw gɨ Esayi ba jangɨ nɨm gɨ gwale day mana gɨ maktubu lə pii de: Mãr̰ĩ wayɨw gorndɨw ba da: «Doy, nə giy paja ni yá lə dɨrəmmə dara ba ɗangr̰ɨnam bɨrmə dɨma bam ladɨ. ");
INSERT INTO sor_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Paja gɨ ta di i gun gaba swaya berni mana gɨ dɨn dwar̰ɨ lə ba da: Aba ciri gɨ Mãr̰ĩ hára lə! Ɗangr̰ɨnaw bɨrmə, kalɨw a inə i tɨba!» ");
INSERT INTO sor_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Gun gɨ ta di, i Jã gaba àlagɨ́ nare batem mana gɨ dɨn dwar̰ɨ lə. An̰ji waygɨ nare cendi ba àlna batem dara ba gɨlnə cendi ba kal i àcn̰a day bam me, ba ùr ba gɨ ꞌyo i Mãr̰ĩ. I yande do me Mãr̰ĩ ba ha kala dusɨw hɨlala àcn̰a day dɨwə sɨn̰. ");
INSERT INTO sor_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Nare pad nə wama gɨ Judeyə me nə ciri dɨ geche dɨ Jursalemə me, dɨmə hára ꞌyo Jã. Cendi piy àcn̰a day gɨndɨw daa nare dɨrəgɨ lə do me an̰ji àlgɨ́ batem mana gɨ kuray gɨ Jurdeyə sɨn̰. ");
INSERT INTO sor_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jã di da, i gun gɨ hurə i barge gɨ gɨ ɗangr̰ɨw i gɨ wudɨn̰ nənə jambal dɨra, me an̰ji ma wamdaw i gɨ gare gɨ kulajɨ me, an̰ji wom i sɨba me dùmbu dɨ bam me ca. ");
INSERT INTO sor_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","An̰ji àsɨgɨ nare berni waygɨ ba da: «Tarɨnnə da, gun gɨ ɗang gɨ dwana duwa ɗoy dɨ ni bam hára lə. Gun gɨ ta di i gɨ geche gɨ ɨndi da, nə nem àsa dɨgɨlan mana gɨ dɨgɨlaw duwa dɨ an̰ji àsɨdɨ dodə dɨdə bədə. ");
INSERT INTO sor_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ɨndi da, nə àlang batem i gɨ nimi, me an̰ji duwa da, gɨra ha àlang batem i gɨ dúndi dɨnə Mãr̰ĩ duwa.» ");
INSERT INTO sor_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Wála gɨ ta lə da, Jesu swaa mana gɨ ciri dɨ Najaret dɨ i wama gɨ Galileyə, me gɨra ꞌyo Jã Batis mana gɨ kuray gɨ Jurdeyə, me Jã àlɨ́w nɨm gɨ batem. ");
INSERT INTO sor_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Mana gɨ Jesu ilə dɨmə lə daa nimiyə da, an̰ji yər siyaya gɨ daa tɨn̰ər bam. Ɗang kaw, an̰ji yər dúndi dɨnə Mãr̰ĩ duwa hára chɨ́ dɨwə wun ya kogəl de. ");
INSERT INTO sor_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Gwale nɨmə daa siyaya dalawə ba da: «Ɨjɨm da, mə i gorndɨn. Dusɨn ùrɨm nan̰e, me sɨn kaw ꞌyolɨn dɨmmə me ca.» ");
INSERT INTO sor_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Mana gɨ ta lə di dog da, dúndi dɨnə Mãr̰ĩ duwa nogɨ Jesu gɨndɨw ha nɨm bam dɨn dwar̰ɨ lə. ");
INSERT INTO sor_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","An̰ji dam mana gɨ ta lə di bɨraa àl wála gɨnɨn̰ wodɨ me Sidan gɨrsɨw nɨm lə, gaa ba dɨ ha nyama lamaw àsàw àla gɨ àcn̰a lə mo? An̰ji dam i mwagɨne nə bam dwar̰agɨ lə me, paja nənə Mãr̰ĩ duwa nə daa gamɨw cendi. ");
INSERT INTO sor_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Wála mɨn ɗang da, gɨ yɨ Jã Batis àsɨ̀w dangeyə. Mwom da, Jesu cwara hára mana gɨ wama gɨ Galileyə. An̰ji waygɨ nare Nõ dɨ lade dɨnə Mãr̰ĩ duwa ba da: ");
INSERT INTO sor_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","«Wála gɨ Mãr̰ĩ ɨrmɨw di, yala nem ɗɨm. Wála duwa gaba lama dwãr̰ĩ di yala ib ɗɨm. Yande da, kalna àcn̰a dan di bam me hane ꞌywana Mãr̰ĩ, me kalna dusɨrəng mana gɨ Nõ dɨ lade di dɨdə me ca.» ");
INSERT INTO sor_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Wála mɨn, Jesu ha mana gɨ kuray gɨ ɓɨle gɨ Galile bɨwə cab cab me, yər nə Simõ day gɨ chendɨw gɨ Andɨre. Cendi i nare woni ūrə, ilə bwaa law dayyə mana gɨ kuray dalawə. ");
INSERT INTO sor_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesu waygɨ ba da: «Kalna ūrə gɨ gòche di ɗi, me hane pamna tarɨn, kal nə cwang woni kan̰jan nare.» ");
INSERT INTO sor_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Mana gɨ ta lə di dog da, cendi bo law day di dodə me pam tarɨw. ");
INSERT INTO sor_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Mana gɨ ba a ha chidɨ pii hin̰e da, an̰ji yər nə Jak day gɨ chendɨw gɨ Jã, nə i Jebede dɨndaw. Cendi kaw dam bɨrwa day dalawə me ilə ɗangr̰a law dayyə. ");
INSERT INTO sor_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ɨr̰ɨ Jesu ꞌwogɨgɨ me cendi swaa kala abɨragɨ gɨ Jebede day gɨ nə woni wagɨ lə ūrə lə di bam bɨrwa dalawə, me pam tarɨw. ");
INSERT INTO sor_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ɨr̰ɨ Jesu day gɨ nə nare nə an̰ji dee ꞌwagagɨ di gɨrgɨ mana gɨ ciri dɨ Kapernom. Mana gɨ wála gaba bwaa gwayniyə da, Jesu gandɨ ha kulu gaba amsa Mãr̰ĩ gɨnə nare nə Juwib dayyə me, an̰ji gɨlgɨ nare gwale gɨnə Mãr̰ĩ duwa. ");
INSERT INTO sor_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Gɨlə duwa gɨ mani di ꞌyàgɨ́ nare ɨrmə nan̰e, dara i gɨ dwana, wundər gɨ gɨlə gɨnə nare woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa di bədə. ");
INSERT INTO sor_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Mana gɨ nare nə ilə kulə dwaya gwale gɨnə Jesu lə di da, gun mɨn gɨ dúndi dɨ àcn̰e widɨbɨw kaw ilə dwar̰agɨ lə me. Gun gɨ ta di sojɨ mar̰ɨjaw daa nan̰ way ba: ");
INSERT INTO sor_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«Jesu gɨ Najaret, mə ùr i na sɨdəninnə mo? Mə hára i dara myandanin bam mo? Ɨndi da, nə ꞌwocn̰ɨmme: Mə i Gun gɨ wun mɨnaw jiga gɨ Mãr̰ĩ giyəm di!» ");
INSERT INTO sor_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ɨr̰ɨ Jesu ɨr̰ɨn̰ dúndi dɨ àcn̰e gɨ dwana me waydɨ ba da: «Ɗesɨ biy daa me gandɨ bam abe di sɨwə!» ");
INSERT INTO sor_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Mwom da, dúndi dɨ àcn̰e di gɨgdɨ abe di daa gɨ dwana me, soy daa nan̰ me, kal sɨdɨ gandɨ nɨm bam abe di sɨwə sɨn̰. ");
INSERT INTO sor_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Nare nə ilə kulə pad di da, lán̰a àlgɨ̀ dara mani di ꞌyàgɨ́ ɨrmə, me ùrbɨ sɨdəgɨ ba da: «Mani nə àlal ka di da, i nə man yande mo? Gun gɨ ka di, gɨləndɨ duwa i mani nə dɨrway me i gɨ dwana me ca! Dúndi dɨ àcn̰e kaw, an̰ji waydɨ gwale me tandi doy gwale bɨwə!» ");
INSERT INTO sor_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","I ta di me Jesu sumɨw ꞌwogɨ nɨm mana gɨ wama gɨ Galileyə pad kaláng yande. ");
INSERT INTO sor_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Mana gɨ Jesu swaa kulu gaba amsa Mãr̰ĩyə da, an̰ji ɗɨgɨ daa ced ha kɨrə nə Simõ day gɨ Andɨreyə. Jak day gɨ Jã kaw, ilə gandɨw me. ");
INSERT INTO sor_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Mana gɨ kɨrə di da, Simõ dyaməw idɨ ilə dodə mwom, sɨdɨ ur̰ɨ nan̰e. Gɨ wayɨw Jesu gwale dɨra. ");
INSERT INTO sor_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ɨr̰ɨ Jesu ha ꞌywadɨ. An̰ji yɨ ɨsədɨ, kaldɨ so daa, me sɨdɨ gɨ ur̰e di chɨ́ hɨlal dodə me, tandi so daa àlgɨ́ mɨjəni me. ");
INSERT INTO sor_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Gɨ turgɨ bɨdɨ, mana gɨ dawa ba dɨ ɗondɨ bam mwom da, wála gaba bwaa gwaynigɨnəJuwibday di kaw, ꞌyen̰ye ɗɨm. Mwom da, gɨ layaw Jesu nare woni mwom gɨ dɨrəw jiga jiga pad hára nɨm, me nare nə dúndi dɨ àcn̰e gɨlgɨ dɨrəgɨ pad me ca. ");
INSERT INTO sor_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Nare pad nə ciri dɨ Kapernommə hára dayar gɨr̰ɨ nan̰ mana gɨ ciri dɨnə Simõ bɨdə. ");
INSERT INTO sor_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesu so nare nan̰ nə i gɨ mwom gɨ jiga jiga di daa me, ꞌyorgɨ nare nan̰ dúndi dɨ àcn̰e di bam sɨdəgɨ lə me ca. An̰ji ɨmdɨ dúndi dɨ àcn̰e waya gɨ gwale bam, dara tandi ꞌwocn̰ɨw ba i Dole gɨ Mãr̰ĩ biyəw gɨ Kris di. ");
INSERT INTO sor_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Sanga gɨ mana pɨr, mana wor ur̰ɨn̰e sɨlɨm sɨn̰ da, Jesu so gandɨ ha bam dɨn dwar̰ɨ lə mɨnaw, me an̰ji dam amsɨ gɨ Mãr̰ĩyə. ");
INSERT INTO sor_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simõ day gɨ nə kwandaw moso sogɨ hargɨ kan̰jaw daa kaláng. ");
INSERT INTO sor_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Mana gɨ cendi gɨr ha ꞌywaw mwom da, wayɨw ba da: «Cware bi! Nare nə pad di ilə kan̰jammə.» ");
INSERT INTO sor_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Me Jesu cogɨ lə diiyə waygɨ ba da: «Nə cor bədə; me hane, də hárang mana gɨ ciri dɨ bam tulɨn̰yə tulɨn̰yə, dara nare dɨra kaw, ùrɨn i wayagɨ gɨ Nõ dɨ lade di me ca. I dara yande ɓag me nə hára nɨm.» ");
INSERT INTO sor_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ɨr̰ɨ cendi ha mana gɨ ciri dɨ wama gɨ Galileyə mɨn mɨn pad. An̰ji àsɨgɨ nare berni mana gɨ kululi day woni amsa Mãr̰ĩyə me, ꞌyorgɨ nare dúndi dɨ àcn̰e di bam sɨdəgɨ lə me ca. ");
INSERT INTO sor_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Wála mɨn da, gun mɨn gɨ cagɨm àlɨ̀w hára Jesu dɨrəwə ib. An̰ji piy gubɨrəw dodə dɨrəwə me amsɨw ba da: «Aba ciri ni, dɨrəm ùrnə da, mə nem sɨr̰ɨn sɨn bam cwan gɨdən gun gɨ lade bi.» ");
INSERT INTO sor_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesu dɨrəw ꞌyəngɨw me, yəə ɨsəw ɓɨl aba cagɨm di sɨw me, wayɨw da: «Nə ùre. Kal sɨm di sɨr̰ɨnə bam!» ");
INSERT INTO sor_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Mana gɨ ta lə di dog me mwom gɨ cagɨm di sɨr̰ɨ bam abe di sɨwə, an̰ji cor gun gɨ lade ɗɨm. ");
INSERT INTO sor_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Ɨr̰ɨ Jesu yəə abe di sumɨw nan̰e me wayɨw ba da: «Doy ladɨ! Cɨmɨw gun daa bədə! Me ha gɨləw aba bwasa Mãr̰ĩ sɨm me, mə ha àla sarga dɨ bii gɨ ꞌwoo gɨnə Moyis duwa ɨrɨm dara gwale gɨnə cagɨm di. Ta di me nare pad ha ꞌwacn̰a dara cagɨm dɨma di ba sɨr̰ɨ i bam sɨmmə ɗɨm me, ba mə cor gɨdɨ i gun gɨ lade Mãr̰ĩ dɨrəwə di sɨn̰ me ca.» ");
INSERT INTO sor_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ɨr̰ɨ abe di so ha me ha cɨmdəgɨ nare gwale di daa pəgɨn̰ yag yag me, nare pad kaw ꞌwocn̰ mani nə gɨ àlaw gandagɨ di com. I dara yande di me Jesu ùr gaba gɨlə gɨ sɨw daa mana gɨ ciriyə bədə di. Ɨr̰ɨ an̰ji dam nɨm tulɨn̰yə bam dɨn dwar̰ɨ lə me, nare nə swaa ciri dayyə jiga jiga kaw hára ꞌyow nɨm. ");
INSERT INTO sor_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Mana gɨ Jesu àla wála ɓani bam di mwom da, an̰ji swaa cwara hára mana gɨ ciri dɨ Kapernom bi. Me mana gɨ nare ꞌwocn̰ dara an̰ji ba yala lə kɨrə da, ");
INSERT INTO sor_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","cendi hára dayar gɨr̰ɨ nan̰ kɨrə me ciri bɨdə iche me kaw, mana gaba dama yengɨ daa. Me Jesu waygɨ gwale gɨnə Mãr̰ĩ duwa. ");
INSERT INTO sor_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Mwom da, nare nə ɗang sɨdəgɨ wodɨ dɨbala gun gɨ r̰egɨdu hára nɨm dara gɨləw gandɨw. ");
INSERT INTO sor_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Me cendi ꞌyo bɨrmə gaba hára gɨləw gandɨw Jesu di bədə bɨr̰ɨn̰, dara nare di gɨr̰ɨ nan̰e. Yande da, cendi nagɨ ha daa kulu dɨwə me ɓolbɨ kulu di dɨw bam me kal gubu me nol gɨ aba mwom di gɨ gɨsa duwa gɨ ꞌya sɨwar ha àsáw nɨm Jesu dɨrəwə. ");
INSERT INTO sor_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesu di yər nare nə ta di kala day gɨ dusɨrəgɨ dɨwə di mwom da, an̰ji wayɨw abe gɨ r̰egɨdu di ba da: «Jan maché, àcn̰a dɨma biyər bam ɗɨm.» ");
INSERT INTO sor_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Mana gɨ nare di dwar̰agɨ lə da, woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa kaw dam ilə me. Mana gɨ ba gɨ doy gwale gɨnə Jesu duwa gɨ ta di mwom da, cendi ɨrɨmdɨ gwale dusɨrəgɨ lə me wajɨ ba da: ");
INSERT INTO sor_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Gun gɨ ta di way gwale yande dana mo? An̰ji gagɨ sɨw gɨ Mãr̰ĩ me àlɨw nɨm məng! Gun gaba biyəw gun àcn̰a bam da, i Mãr̰ĩ mɨn tenene mɨra bədə mo?» ");
INSERT INTO sor_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesu di da, ꞌwocn̰ ɨrmə day di com me waygɨ ba da: «Dara na me anə ɨrɨm ya ta de mo? ");
INSERT INTO sor_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Wayaw gɨ gun gɨ r̰egɨdu “Àcn̰a dɨma biyər bam ɗɨm”, labaa “So daa, me u gɨsa dɨma daa, ha nɨm” da, i gwale gɨ we me wom nan̰ mo? ");
INSERT INTO sor_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ladɨ, nə ùr dara anə ba ꞌwacn̰ana dara ɨndi gɨ Gun gorndɨw di, ba nə i gɨ dwana dɨ idɨ piyəgɨ nare àcn̰a day bam mana gɨ sɨn̰a dɨdə ka. Yande da, nə ha àla mani nə anə yərgɨ ba wom nan̰e di.» Me an̰ji wayɨw abe gɨ r̰egɨdu di ba da: ");
INSERT INTO sor_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«Nə wayɨm ɨjɨm: So daa, u gɨsa dɨma daa ɨsəmmə, me cor ha ulay dɨma lə ɗɨm!» ");
INSERT INTO sor_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Mana gɨ ta lə dog, abe gɨ r̰egɨdu di so daa cud nare dɨrəgɨ lə, u gɨsa duwa me ha yá nɨm ulay. Ɨr̰ɨ nare pad nə yər abe gɨ r̰egɨdu di hára lə yá da, yɨbdɨ dɨdəgɨ me, ꞌwogɨ Mãr̰ĩ sumɨw way ba da: «Laba da, də yarang mani nə dii mɨn kaw, də yərgɨ bədə sɨn̰ di ɗɨm. Mãr̰ĩ da, i geche an̰ju ꞌyang!» ");
INSERT INTO sor_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Targɨn̰ ɗang da, Jesu cwara hára kuray gɨ ɓɨle gɨ Galile bɨwə. Nare nə gɨr̰e hára ꞌyow me an̰ji gɨlgɨ gwale gɨnə Mãr̰ĩ duwa. ");
INSERT INTO sor_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Mana gɨ an̰ji ilə hára lə da, yər Lebi gɨnə Alpe gorndɨw dam lə mana duwa gaba salaw dole gɨ geche gɨ Rom maniyə, me an̰ji wayɨw Lebi ba da: «Sway daa, hare, pam tarɨn!» Me Lebi di so daa me pam tarɨw. ");
INSERT INTO sor_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Targɨn̰ ɗang da, Jesu ilə wama mani mana gɨ kɨrə nə Lebiyə, me woni gɨrsə gwale duwa me nare nə ɗang nan̰ me, dam wom gandɨw mani mɨn. I nare woni salaw dole gɨ geche gɨ Rom mani me, nare nə àcn̰e nə ɗang me, dara cendi pam Jesu gɨ gɨr̰ə nan̰. ");
INSERT INTO sor_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Mwom da, nare nə yab woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa ilə. Cendi i nare nənə nare nə gɨ ꞌwogɨgɨ̀ Parise. Mana gɨ cendi yər Jesu wama gɨ maniyə gɨ nare woni salaw dole gɨ Rom mani, me nare nə àcn̰e nə ɗang me da, cendi waygɨ woni gɨrsə gwale gɨnə Jesu duwa ba da: «Aba ciri dan di wom mani gɨ nare woni salaw dole gɨ geche gɨ Rom mani me nare nə àcn̰e nə ɗang mɨn me dana mo?» ");
INSERT INTO sor_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Mana gɨ Jesu doy gwale day di mwom da, an̰ji waygɨ ba da: «Nare nə sɨdəgɨ i labiya da, cendi kan̰jɨ dogtər bədə. I nare nə sɨdəgɨ i mwom me kan̰jɨ dogtər cendi. Hára ni gɨ sɨn̰a dɨdə ka da, i dara ꞌwaga gɨ nare nə ꞌwocn̰ dusɨrəgɨ lə ba gɨ i nare nə àcn̰e. Me nare nə ɨrɨm dusɨrəgɨ lə ba gɨ i nə tɨba Mãr̰ĩ dɨrəwə da, nə hára i dara ꞌwagagɨ cendi bədə.» ");
INSERT INTO sor_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Woni gɨrsə gwale gɨnəJã Batis duwa me nare nə gɨ ꞌwogɨgɨ̀Parise me, ugɨ asiyam le jwab jwab. Nare yər yande mwom da, nə mɨn hára ùr Jesu ba da: «Woni gɨrsə gwale gɨnə Jã Batis me woni gɨrsə gwale gɨnə nare nə Parise day me ilə ꞌwoo asiyammə, me ɨjɨm da, woni gɨrsə gwale dɨma u day bədə dana mo?» ");
INSERT INTO sor_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Mwom da, Jesu cogɨ lə diiyə gɨ gwale gɨ diri ba da: «I man me aba àla dyamdɨrani kwandaw moso ha ꞌwoo asiyam mana gɨ an̰ji kaw ilə gandagɨ me mo? Mana gɨ an̰ji ilə gandagɨ sɨn̰ da, cendi ha ꞌwoo asiyam bədə. ");
INSERT INTO sor_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Me wála gɨ ɗang mɨn hára lə. Wála gɨ ta lə di, gɨ ha biyə aba dyamdɨrani di bam dwar̰agɨ lə hára gandɨw, do me, cendi ha ꞌwoo asiyam di sɨn̰.» ");
INSERT INTO sor_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","An̰ji waygɨ gwale gɨ diri ɗang ba da: «Gun mɨn ha ꞌwoo barge gɨ dɨrway bɨw dara àsa gɨ mabɨla mana gɨ barge gɨ mar̰ɨngeyə bədə. Dara barge gɨ dɨrway bɨw di, ha chawa gɨ mar̰ɨnge di bam. Me chawara gɨ ta di ha ɗwaya gɨ pii bam bi. ");
INSERT INTO sor_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Me gun mɨn kaw ha bwaa gani gɨ dɨrway gɨ ilə sugdə lə mana gɨ ɗɨjili gɨ mar̰ɨngeyə bədə me ca, dara gani gɨ ilə sugdə lə di ha jaa ɗɨjili gɨ mar̰ɨnge di bam bɨr̰ɨn̰. Gani di me ɗɨjili di me ha myandara i bam. Me ladni duwa da, gɨ bo gani gɨ ilə sugdə lə mana gɨ ɗɨjili gɨ dɨrwayyə.» ");
INSERT INTO sor_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Wála mɨn gɨ i wála gaba bwaa gwayni gɨnə Juwib day da, Jesu day gɨ nə woni gɨrsə gwale duwa jàgɨ dàge nə geme dwar̰agɨ lə. Woni gɨrsə gwale duwa, mana gɨ ilə háragɨ lə da, cendi ar geme dɨw wom. ");
INSERT INTO sor_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ɨr̰ɨ nare nə gɨ ꞌwogɨgɨ Parise wayɨw Jesu da: «Yər woni gɨrsə gwale dɨma di de! Cendi ilə àla i mani nə bii ɨnda gɨ ꞌwoo ɨm àla day bam wála gaba bwaa gwayniyə di dana mo?» ");
INSERT INTO sor_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Mwom da, Jesu cogɨ lə diiyə: «Anə āsɨ mani nə Dabid àlgɨ̀ di mana gɨ Maktubu dɨnə Mãr̰ĩyə bədə mo? Wála mɨn, an̰ji, cherni àlɨ̀w me, nare woni bwaw kaw, cherni àlgɨ̀ me ca. Mani day nə wama ilə bədə. ");
INSERT INTO sor_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","An̰ji dɨm ha kulu gɨnə Mãr̰ĩyə. I aliya gɨ Abiyatar i nɨm woni bwasa Mãr̰ĩ geche day. Dabid wom mapa gɨ gɨ chɨ́gdɨw Mãr̰ĩ me ꞌyàgɨ́ nare duwa di me ca. Ɓag da, bii ɨnda gɨ ꞌwoo lə da, i woni bwasa Mãr̰ĩ me wom cendi mɨra. Me mani nə Dabid àlgɨ̀ ta di, i àcn̰a Mãr̰ĩ dɨrəwə bədə.» ");
INSERT INTO sor_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Me Jesu waygɨ ɗang ba da: «Mãr̰ĩ àl wála gaba bwaa gwayni di, i dara wagɨ gɨ nareyə, me an̰ji àl wála gaba bwaa gwayni di dara ꞌyàgɨ́ gɨ nare wamani bədə. ");
INSERT INTO sor_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","I dara yande me ɨndi gɨ Gun gorndɨw di, wála gaba bwaa gwayni di kaw, nə i aba ciri duwa ɨndi.» ");
INSERT INTO sor_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Targɨn̰ ɗang da, Jesu cor gandɨ mana gɨ kulu gaba amsa Mãr̰ĩ gɨnə nare nə Juwib dayyə bi. Gun gɨ ɨsəw mar bam ilə me. ");
INSERT INTO sor_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Nare nə gɨ ꞌwogɨgɨ Parise kaw ilə, cendi àsɨ angal day yər gɨ Jesu dara gaa an̰ju ba ha swaa aba mwom di daa wála gaba bwaa gwayniyə mo? Ɨrmə dayyə ɓag kaw, cendi kan̰jɨ ba gɨ ꞌyo gwale gɨ àcn̰e bɨwə dara ba gɨ ha gandɨw woni àla sariya dɨrəgɨ lə. ");
INSERT INTO sor_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ɨr̰ɨ Jesu wayɨw abe gɨ ɨsəw mar bam di ba da: «So ɗɨbɨ daa nare dɨrəgɨ lə!» ");
INSERT INTO sor_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Me an̰ji ùr nare di ba da: «Wála gaba bwaa gwayniyə da, bii ɨnda gɨ ꞌwoo kal bɨrmə dara ba mə àlna i mani nə lade, labaa ba mə àlna i nə àcn̰e mo? Dara ba mə bɨlnə gun daa, labaa ba mə ꞌyánaw bam mo?» Me gun mɨn kaw àsɨw gwale lə diiyə bədə. ");
INSERT INTO sor_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Mwom da, Jesu cor yərgɨ pad dayyə gɨ man̰a, me sɨw kaw ꞌyolɨw dɨdəgɨ lə bədə, dara nare nə ta di dɨdəgɨ woy nan̰e. Mwom da, an̰ji wayɨw abe di ba da: «Yə́ ɨsəm dodə!», me an̰ji yə́ ɨsəw dodə. Mana gɨ ta lə dog da, an̰ji ꞌyo labiya. ");
INSERT INTO sor_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Me nare nə Parise di dɨməgɨ iche, hargɨ kaláng ꞌywaa nare nənə dole gɨ Erod duwa dara ba gɨ ha àla i man dara ꞌyáa gɨ Jesu bam mo? ");
INSERT INTO sor_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Targɨn̰ ɗang da, Jesu day gɨ nə woni gɨrsə gwale duwa hargɨ gɨr mana gɨ kuray gɨ ɓɨle gɨ Galile bɨwə. Nare nan̰ pamɨw tarɨwə. Nare nə gɨr̰e nə ta di dwar̰agɨ lə da, nə yab swaa i wama gɨ Galileyə, me nə yab da, swaa i wama gɨ Judeyə ");
INSERT INTO sor_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","me, nə yab da, swaa i ciri dɨ geche dɨ Jursalemə, me nə yab swaa i wama gɨ Idumeyə, me nə yab ɗang da, swaa gangɨr gɨnə kuray gɨ Jurdeyə, me nə yab da, swaa i ciri dɨ Tir me Sidon me tulbədɨ lə. Mana gɨ cendi doy mani nə Jesu àlgɨ̀ di da, cendi háragɨ pad dara yara gɨ dɨrəgɨ day. ");
INSERT INTO sor_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Mana gɨ Jesu yər nare di gɨr̰ɨ nan̰ da, an̰ji waygɨ woni gɨrsə gwale duwa ba da: «Unən bɨrwa hane nɨm, dara kal nare di ɗɨrbɨnən bədə.» ");
INSERT INTO sor_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","An̰ji way yande dara mana gɨ an̰ji dee swaa nare nə mwom nan̰ daa pii da, nare pad nə mwom jiga jiga ilə gɨləgɨ dɨrəgɨ lə da, ꞌyolɨm dara ba gɨ hára sɨwə ib ba gɨ ɓɨlbɨ sɨw. ");
INSERT INTO sor_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Mana gɨ nare nə dúndi dɨ àcn̰e àlgɨ̀ kaw ba gɨ yər Jesu mwom da, dúndi dɨ àcn̰e di nogɨgɨ me cendi piy gubɨrəgɨ dodə dɨrəwə me sojɨ mar̰ɨjagɨ daa way ba: «Ɨjɨm, mə i Mãr̰ĩ gorndɨw!» ");
INSERT INTO sor_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Me an̰ji ɨr̰ɨn̰ dúndi dɨ àcn̰e waydɨ tandi ba gɨlnəw daa bədə. ");
INSERT INTO sor_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Targɨn̰ ɗang da, Jesu nagɨ ha daa kur̰a dɨdə. An̰ji ꞌwogɨ nare nə an̰ji ùr ba gɨrsɨnə gwale duwa, me cendi hára sɨwə. ");
INSERT INTO sor_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Mwom da, an̰ji an̰jir nare nə mwaj dii sɨr mana gɨ kwandagɨ dwar̰agɨ lə. An̰ji ꞌwogɨgɨ́ sumdəgɨ ɗang ba i «paja» duwa. An̰ji an̰jir nare nə mwaj dii sɨr nə ta di dara ba ina i gandɨw, me ɗan̰ ba a ha kɨjəgɨ dara waya gɨ Nõ dɨ lade dɨnə Mãr̰ĩ duwa, ");
INSERT INTO sor_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","me ba a ha ꞌyàgɨ́ dwana dɨ idɨ ꞌywara dúndi dɨ àcn̰e bam me ca. ");
INSERT INTO sor_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Me nare nə mwaj dii sɨr nə ta di sumdəgɨ i ta: Simõ gɨ Jesu ꞌwogɨw Piyer di, ");
INSERT INTO sor_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","me Jak day gɨ chendɨw gɨ Jã, nə i Jebede dɨndaw me Jesu ꞌwogɨgɨ «Bwanerje», gɨndɨw dɨ biyə da, way i ba «nare nə wun ya ɨr̰in̰ə gɨnə Mãr̰ĩ duwa de», me ");
INSERT INTO sor_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andɨre, me Pilip, me Bartelemi, me Matiyə, me Toma, me Jak gɨnə Alpe gorndɨw, me Tade, me Simõ gɨ i gun gɨ day gɨ nə kwandaw nə ùr nare nə Juwib ba damna gɨ dɨdəgɨ day ");
INSERT INTO sor_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","me, Judas Iskariyot gaba ꞌyàa Jesu woni mar̰ande duwa ɨsɨragɨ lə di me ca. ");
INSERT INTO sor_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Targɨn̰ ɗang bi da, Jesu day gɨ nə woni gɨrsə gwale duwa cwara hára ulay. Nare nan̰ ɗang bi hára dayar gandɨw. Me Jesu day gɨ nə woni gɨrsə gwale duwa ꞌyo bɨrmə gaba wama mani nə wama bədə. ");
INSERT INTO sor_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Mana gɨ Jesu war̰aw ba gɨ doy yande da, cendi way an̰ji ba cor mendɨ i bam ɗɨm, me cendi swaa daa hára dara walaw gɨ dwana hára nɨm ulay. ");
INSERT INTO sor_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ɨr̰ɨ nare nə mɨn nə woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa swaa mana gɨ Jursalem. Cendi gɨra way ba da: «Sidan ilə Jesu sɨwə, i tandi dɨ i dúndi dɨ àcn̰e geche day me ꞌyàw dwana dɨ idɨ ꞌywara dúndi dɨ àcn̰e bam.» ");
INSERT INTO sor_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Mwom da, Jesu ꞌwogɨ woni gɨlə bii gɨ ꞌwoo nə ta di, me an̰ji waygɨ gwale gɨ diri ba da: «I man me Sidan ha ꞌywara sɨdɨ dɨra bam gang tugu mo? ");
INSERT INTO sor_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Wála gɨ nare nə wama gɨ mɨnnə jarna say gɨ sɨdəgɨ day da, wama gɨ ta di ha dama lada bədə. ");
INSERT INTO sor_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Me mana gɨ nare nə ciri dwar̰ɨ lə mɨn damna dara jara say gɨ sɨdəgɨ day da, ciri dɨ ta di ha ꞌya lə bədə. ");
INSERT INTO sor_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Me Sidan jarna gɨ sɨdɨ dɨra gang, labaa yɨnə sɨdɨ daa mɨn bədə da, dwana dɨra ha ꞌya lə nan̰ mo? Bədə. Dwana dɨra ha ꞌyan̰a i bam bɨr̰ɨn̰. ");
INSERT INTO sor_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Mana gɨ mə ùrnə ba mə gandɨna hana mana gɨ gun gaba dwana kɨrə duwa lə dara chaba mani duwa nə ꞌywaa bam da, ladni duwa da, mə ha magda gun gaba dwana di dodə, do me, mə ha chaba mani duwa nə ꞌywaa nə kɨrə ta di bam pad sɨn̰. ");
INSERT INTO sor_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Dwayna, nə wayang i gwale sɨw: Mãr̰ĩ ha kala dusɨw hɨlala nare àcn̰a day gɨ jiga jiga dɨwə di le. Àcn̰a day gɨ cadɨbɨw nɨm kaw, an̰ji ha kala dusɨw hɨlala lə diiyə me ca, ");
INSERT INTO sor_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","me gun gɨ cadɨbɨna i dúndi duwa da, an̰ji ha kala dusɨw hɨlala àcn̰a duwa gɨ ta di dɨwə bədə. Gun gɨ ta di àcn̰a duwa di wor ilə dɨwə gɨ dɨrɨn̰ bɨr̰ɨn̰.» ");
INSERT INTO sor_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesu waygɨ woni gɨlə bii gɨ ꞌwoo yande i dara cendi waya ba an̰ji ba i gɨ dúndi dɨ àcn̰e lə sɨwə. ");
INSERT INTO sor_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Targɨn̰ ɗang da, Jesu iw me chamraw me háragɨ gɨra ciri dɨ Jesu ilə. Cendi ɗɨbɨ iche me giyɨw gun mana gɨ kɨrə ba ꞌwagɨnaw. ");
INSERT INTO sor_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Nare nan̰ dam ilə gandɨw, me gɨ wayɨw: «Yər, im me chamram me ilə iche, cendi ùrɨmme.» ");
INSERT INTO sor_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Me Jesu cogɨ lə diiyə waygɨ ba da: «I wi me i in, i nə wi me i chamran mo?» ");
INSERT INTO sor_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Mwom da, an̰ji kal sɨw yər nare nə dam liwɨw daa ta di ɓam, me way ba da: «Yarna, in me chamran me, i ka. ");
INSERT INTO sor_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Dara gun gaba àla mani nə Mãr̰ĩ dusɨw ùrgɨ da, an̰ji me i chendɨn, i chidɨn, i in.» ");
INSERT INTO sor_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Targɨn̰ ɗang da, Jesu so ilə gɨləgɨ nare gwale gɨnə Mãr̰ĩ duwa lə ɗang bi kuray gɨ ɓɨle gɨ Galile bɨwə. Nare ꞌyarbar nan̰e mana gɨ tulɨwə. Yande mwom da, an̰ji kal sɨw nagɨ ha bɨrwa dalawə dama lə me ɗɨbə nɨm nimiyə. Me nare nə pad da, dam day kuray di bɨwə wayniyə. ");
INSERT INTO sor_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Me Jesu di gɨlgɨ nare mani nan̰ i gɨ gwale gɨ diri. Me mana gɨ gɨlə duwa gɨ ka lə da, an̰ji waygɨ ba da: ");
INSERT INTO sor_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Dwayna ladɨ! Abe mɨn so ba a ha chìgdə swagə yiga lə. ");
INSERT INTO sor_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Mana gɨ an̰ji ilə chìgdə lə da, swagə dɨrəgɨ nə yab wujabar bor mana gɨ bɨrmə lə me, dirbi gɨra tɨgɨgɨ chə́gdɨgɨ bam car. ");
INSERT INTO sor_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","6","Swagə dɨrəgɨ nə mɨn da, wujabar day bor mana gɨ gɨndara lə. Cendi gandɨ daa kaláng mɨ̀ndagɨ, me ꞌyo bɨrmə gaba bwaa sabɨragɨ hára dodə cog bədə, dara sɨn̰a dɨ lade di yengɨ le. Yande da, mana gɨ dawa gɨra ən dɨdəgɨ lə da, swagə nə ta di woy bam. ");
INSERT INTO sor_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Swagə dɨrəgɨ nə mɨn ɗang bi bor day mana gɨ chemde woni jimdi dwar̰agɨ lə. Cendi dɨm daa, me chemde woni jimdi di so yɨgɨ daa swamama ɨmgɨ jwara bam me cendi gandɨ dɨdəgɨ bədə. ");
INSERT INTO sor_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Me swagə dɨrəgɨ nə mɨn bor day mana gɨ sɨn̰a dɨ ladeyə. Cendi gandɨ jor ladɨ me naa dɨrəgɨ me ca. Swagə nə ta di dɨdəgɨ lə mɨn da, dɨrəgɨ ꞌyarbar nan̰e. Nə mɨn àl dɨrəgɨ nem gɨnɨn̰ subu, nə mɨn ɗang àl dɨrəgɨ nem gɨnɨn̰ kubi, nə mɨn ɗang bi àl dɨrəgɨ nem aru.» ");
INSERT INTO sor_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Me Jesu waygɨ ɗang bi ba da: «Gun gɨ sumdəw woni dwaya gwale ina lə da, kal a dwayna.» ");
INSERT INTO sor_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ɨr̰ɨ Jesu day gɨ nə woni gɨrsə gwale duwa nə mwaj dii sɨr di me, nare nə yab nə ilə hára gandɨwə sɨn̰ di me gɨrgɨ bam tulɨn̰yə ched da, cendi so ùr Jesu gwale duwa gɨ an̰ji wayɨw gɨ diri di gɨndɨw. ");
INSERT INTO sor_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Me Jesu cogɨ lə diiyə waygɨ ba da: «ꞌYeni da, Mãr̰ĩ gɨləng gwale sɨw gɨ budə lə dara lama duwa gɨ dwãr̰ĩ di ɗɨm, me nare nə iche da, nə gɨlgɨ mani pad di i gɨ gwale gɨ diri. ");
INSERT INTO sor_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ta di me i mani nə aba cɨmə Mãr̰ĩ bɨw jangɨ nɨm gɨ gwale day pii mana gɨ Maktubu dɨnə Mãr̰ĩyə, me yala àlal nɨm. An̰ji way ba da: “Cendi un̰bɨ me yər bədə, domən̰dɨ me doy bədə, me ꞌwocn̰ gwale di gɨndɨw bədə me ca. I yande me cendi ha ꞌywaa gɨ bɨrmə gaba cwara nɨm Mãr̰ĩ sɨwə bədə, me Mãr̰ĩ kaw, ha kala dusɨw hɨlala àcn̰a day dɨwə bədə me ca.”» ");
INSERT INTO sor_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Me Jesu waygɨ ɗang bi ba da: «Gwale gɨ diri gɨ nə wayang gandɨw dara aba chìgdə swagə di da, anə ꞌwacn̰ana gɨndɨw bədə sɨn̰ da, gwale gɨ diri gɨ ɗang gɨ nə ha wayang gandɨw da, anə ha ꞌwacn̰aw mɨnang kaw mo? ");
INSERT INTO sor_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Dwayna! Aba chìgdə swagə di da, i aba waya gwale gɨnə Mãr̰ĩ duwa. ");
INSERT INTO sor_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Swagə dɨrəgɨ nə bor mana gɨ bɨrmə lə da, wun i ya nare nə doy gwale gɨnə Mãr̰ĩ duwa mɨ̀ndagɨ, me ɨr̰ɨ Sidan hára kaláng biy gwale gɨ cendi dwayaw di bam dusɨrəgɨ lə. ");
INSERT INTO sor_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Swagə dɨrəgɨ nə bor mana gɨ gɨndara lə di da, i nare nə doy gwale gɨnə Mãr̰ĩ duwa, cendi yɨw gɨ sii ꞌywala kaláng mɨ̀ndagɨ, ");
INSERT INTO sor_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","me kal gwale di bo sabɨraw dusɨrəgɨ lə bədə. Cendi i nare nə yɨ sɨdəgɨ woy bədə. Mana gɨ wamani ꞌywanagɨ, labaa nare gɨlnəgɨ dɨrəgɨ dara gwale gɨnə Mãr̰ĩ duwa mwom da, cendi so kaláng gɨn̰ gwale gɨnə Mãr̰ĩ duwa di bam. ");
INSERT INTO sor_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Swagə dɨrəgɨ nə bor mana gɨ chemde woni jimdi dwar̰agɨ lə di da, i nare nə doy gwale gɨnə Mãr̰ĩ duwa di me, ");
INSERT INTO sor_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ɨr̰ɨ cendi ɨrɨm mana gɨ wamani gɨ jiga jiga gɨ sɨn̰a dɨdə ka dɨwə, cendi kan̰jɨ ꞌywaa gɨ sɨn̰a dɨdə ka gɨ i mani nə pəgɨn̰ yag, me cendi kal ɨrmə day mana gɨ mani nə ɗang ɗang dɨdəgɨ lə me ca. I yande me ɨrmə gɨ pad gɨ cendi ɨrmɨw di da, yɨ gwale gɨnə Mãr̰ĩ gɨ dusɨrəgɨ lə di daa swamama ɨmgɨ àla gandɨw giyə bam. ");
INSERT INTO sor_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Swagə nə bor sɨn̰a dɨ ladeyə da, i nare nə doy gwale gɨnə Mãr̰ĩ duwa me yɨw gɨ ɨsɨragɨ sɨr me àl gandɨw giyə me ca. Cendi da, wun ya swagə dɨdəgɨ nə mɨn nə àl dɨrəgɨ nem gɨnɨn̰ subu de, labaa nə ɗang nə àl dɨrəgɨ nem gɨnɨn̰ kubi de, labaa nə ɗang bi nə àl dɨrəgɨ nem aru de me ca.» ");
INSERT INTO sor_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesu waygɨ nare ɗang bi ba da: «Gun unə lamba dɨ dùwa gɨrər lə da, i dara ɨbədɨ mani dɨdə bədə, labaa i dara chə́dɨ mana gɨ solbə gɨndəgɨ lə mo? Bədə. Me ɓag da, i dara chə́dɨ mani dɨdəgɨ lə daa dara kal ba ácn̰ana mana bam. ");
INSERT INTO sor_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","I ya ta de di me mani pad nə i budɨ lə caga ka da, ɗan̰ gɨ ha yaragɨ daa pɨden̰yə, me mani nə nare ùr kwandagɨ ba ꞌwacn̰ana bədə kaw, ɗan̰ Mãr̰ĩ ha gɨləgɨ daa pɨden̰yə me ca. ");
INSERT INTO sor_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Gun gɨ sumdəw woni dwaya gwale ina lə da, kal a dwayna.» ");
INSERT INTO sor_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Me Jesu waygɨ gwale ɗang bi ba da: «Àsɨna angal dan ladɨ le mana gɨ mani pad nə nə wayang gwale day di dɨdəgɨ lə: I mani nə anə ɨrɨm gɨ mani ꞌyàgɨ́ gɨ kwandang ta di gang me, sanga Mãr̰ĩ ha ɨrməng nɨm lə yande di me, an̰ji ha ꞌyàng lə diiyə ɗang bi me ca. ");
INSERT INTO sor_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Dara gun gɨ mani duwa ina lə da, gɨ ha ꞌyàw lə diiyə bi. Me gun gɨ mani duwa ina lə bədə da, nə hin̰e nə ilə ɨsəwə ta di kaw, gɨ ha ꞌwogɨ i bam ɨsəwə.» ");
INSERT INTO sor_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesu waygɨ nare gwale ɗang bi ba da: «Dwãr̰ĩ dɨnə Mãr̰ĩ duwa da, wun i ya gun mɨn ba a gɨsɨ gɨ swagə mana gɨ daga duwa lə ta de. ");
INSERT INTO sor_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Mwom da, an̰ji ina i nuni gɨ changa, labaa damna bɨ̀ra gɨ dawa kaw, swagə dɨrəgɨ di gandɨ daa me jor me dɨban ꞌwacn̰a duwa. ");
INSERT INTO sor_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","I sɨn̰a me àl giyə dɨra gaba ganda swagə dɨrəgɨ di daa, me jor nɨm di me tandi. Me swagə di gandɨ gɨ dɨdəgɨ naa nɨm gɨ dɨrəgɨ mana gɨ dɨdəgɨ lə. ");
INSERT INTO sor_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Me mana gɨ swagə di dɨrəgɨ naa ɗɨm da, gun gaba gɨsə swagə di u kur̰ang kaláng me ha dara n̰iləgɨ ɗɨm, dara wála day gaba n̰ilə di nemme ɗɨm.» ");
INSERT INTO sor_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesu waygɨ nare gwale ɗang bi ba da: «Dwãr̰ĩ dɨnə Mãr̰ĩ duwa da, də ɨrməng gandɨdɨ ya na de mo? Labaa, ba də wayang gwale dɨra də ɨrmɨw gɨ gwale gɨ diri gɨ we mo? ");
INSERT INTO sor_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Dwãr̰ĩ dɨnə Mãr̰ĩ duwa da, wun i ya habda gɨ mutardɨ dɨrəw de. Dɨrəw di i ɓani hin̰e hin̰e ɗoy kwandaw habde nə caga ka dɨrəgɨ bam pad. ");
INSERT INTO sor_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Me mana gɨ gɨ gɨsɨnə dɨrəw dodə da, gandɨ daa me jor gɨdɨ ɗoy habde nə gɨndəgɨ wor nə gɨ ɗɨlbɨgɨ dara hangda gɨ bɨ̀ra di bam pad. An̰ji agdɨ gangr̰aw nan̰ me ꞌya dun nan̰ dɨ dirbi nə daa kaw, ɗangr̰ɨ ciri day dam lə me ca.» ");
INSERT INTO sor_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesu waygɨ nare gwale gɨnə Mãr̰ĩ duwa gɨ gwale gɨ diri nan̰ yande. An̰ji waygɨ gwale di yande bor gɨ dwana day dɨ idɨ ꞌwacn̰a gwale gɨndɨw. ");
INSERT INTO sor_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Inam i nare nə gɨr̰e da, dɨban gwale gɨ diri da, Jesu tɨn̰ bɨw waygɨ gwale bədə bɨr̰ɨn̰, me mana gɨ an̰ji inə mɨ́ndagɨ gɨ woni gɨrsə gwale duwa da, an̰ji biygɨ gwale gɨ diri di gɨndɨw daa. ");
INSERT INTO sor_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Wála gɨ ta lə dog, gɨ turgɨ pɨram da, Jesu waygɨ woni gɨrsə gwale duwa ba da: «Cilangɨnandɨ kuray gɨ ɓɨle, hanandɨ dugdɨw dɨ alə ta lə!» ");
INSERT INTO sor_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Mana gɨ cendi so kal nare nə gɨr̰e di dodə ɗɨm da, woni gɨrsə gwale duwa di ꞌwoy bɨrwa gɨ Jesu dam lə di ha gandɨw. Bɨrwa nə ɗang kaw, ilə hára lə gandagɨ me ca. ");
INSERT INTO sor_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ɓam da, gale gɨ geche biyara kaláng, u nimi bo bɨrwa dalawə, wor hin̰e dara ꞌwanaw daa. ");
INSERT INTO sor_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Me Jesu di da, i duwa i nuni bɨrwa widɨwə cilangɨ dɨw daa. Nɨma woni gɨrsə Jesu gwale duwa di nuw daa me wayɨw da: «Aba gɨlənin mani, də ilə marangə da, nam dusɨm bədə mo?» ");
INSERT INTO sor_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Mwom da, Jesu so daa, ɨr̰ɨn̰ gale di me waygɨ nimi nə kurayyə di me ba da: «Hwayna le! Ɗɨbɨnə dodə!» Mana gɨ ta lə da, gale ɗɨbɨ dodə ɗeg, me mana hɨlal kajaj. ");
INSERT INTO sor_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jesu waygɨ woni gɨrsə gwale duwa da: «Anə lán̰ yande dana mo? Anə kal dusɨrəng dɨnnə bədə sɨn̰ mo?» ");
INSERT INTO sor_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Cendi lán̰a àlgɨ nan̰, me cor ùrbɨ sɨdəgɨ: «Gun gɨ ta di i wi ɓag me, gale day gɨ nimi nə kurayyə kaw, doy gwale bɨwə mo?» ");
INSERT INTO sor_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ɨr̰ɨ Jesu day gɨ nə woni gɨrsə gwale duwa gɨrgɨ mana gɨ kuray gɨ ɓɨle gɨ Galile dugdɨw dɨ alə ta lə, wama gɨ Gerasa lə. ");
INSERT INTO sor_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Me mana gɨ Jesu chə́ə dodə bɨrwa dalawə da, abe mɨn gɨ dúndi dɨ àcn̰e widɨbɨw swaa mana gɨ munɨniyə hára sawa dɨrəw daa. ");
INSERT INTO sor_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Abe gɨ ta di, ciri duwa dɨ dama i mana gɨ munɨniyə. Gun mɨn kaw nem magdaw dodə bədə. Gɨ sul kaw, gɨ nem magdaw dodə bədə. ");
INSERT INTO sor_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Gɨ wála wála gɨ bow kaya kaya gɨdawə me sul ɨsawə me kaw, an̰ji agdɨgɨ bam. Ɨr̰ɨ gun gɨ ɗang gɨ nem yə̀w biyəw bɨw dodə, ilə bədə. ");
INSERT INTO sor_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Gɨ dawa me gɨ changa me, an̰ji kɨdɨbər munɨniyə me kur̰a dɨdə me, dosbɨ sɨw jarbe gɨ gɨlale me, sojɨbɨ r̰ur̰u me ca. ");
INSERT INTO sor_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","An̰ji yara Jesu hára lə hən̰ da, wada gɨra piy gubɨrəw dodə dɨrəwə. ");
INSERT INTO sor_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Mwom da, Jesu waydɨ dúndi dɨ àcn̰e di ba da: «Dɨm bam abe di sɨwə!» Me dúndi dɨ àcn̰e di soy mar̰ɨjadɨ daa nan̰ ba da: «Ɨjɨm Jesu gɨnə Mãr̰ĩ gaba dama mani pad dɨdəgɨ lə gorndɨw, mə ùr i na sɨnnə mo? Nə wayɨm gɨ Mãr̰ĩ sumɨw: Gɨlɨn dɨrən bədə!» ");
INSERT INTO sor_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Mwom da, Jesu ùrdɨ ba da: «Gɨ ꞌwogi man mo?» Tandi wayɨw: «Gɨ ꞌwogɨn “Gɨr̰ə”, dara nə gɨr̰ɨnin nan̰e.» ");
INSERT INTO sor_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Me tandi mɨrgɨw Jesu dara ba ꞌywarnagɨ bwanagɨ hən̰ bədə. ");
INSERT INTO sor_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Mana gɨ ta lə di, gochəng gɨmər ilə wama lə kur̰a tuldɨ lə. ");
INSERT INTO sor_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Dúndi dɨ àcn̰e di mɨrgɨw Jesu da: «Kalnin nə hanin gochəng dɨ ta di sɨdə.» ");
INSERT INTO sor_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jesu kalgɨ ba hana. Ɨr̰ɨ cendi dɨm bam abe di sɨwə, ha bwara gochəng sɨdə. Gochəng ɓɨr̰ɨn̰ə daa kur̰a tuldɨ lə, wada bor kurayyə, chə̀ nimi marbɨ bam. Gochəng di nem i ya dubu sɨr de. ");
INSERT INTO sor_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Nare woni gama gochəng di wà ha ciri dɨ gechideyə me dɨ dineyə me cɨməgɨ nare mani nə àlal di gwale day, ɨr̰ɨ nare di hargɨ dara yara mani di gɨ dɨrəgɨ. ");
INSERT INTO sor_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Mana gɨ cendi gɨra Jesu tulɨwə ib da, cendi yər abe gɨ dúndi dɨ àcn̰e widɨbɨw nan̰ pii di dam lə dodə, dɨrəw biyər dodə, hurə barge sɨwə, cor lán̰a àlgɨ̀ le. ");
INSERT INTO sor_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Nare woni yara mani nə àl abe me gochəng me gɨ dɨrəgɨ da, kɨbɨgɨ kwandagɨ gwale di, ");
INSERT INTO sor_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ɨr̰ɨ cendi mɨrgɨw Jesu an̰ju ba hana kalnagɨ sɨn̰a day ɗi. ");
INSERT INTO sor_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Mana gɨ Jesu nagɨ dam bɨrwa lə dara hára ɗɨm da, abe gɨ widɨbɨ pii di mɨrgɨw ba kalnaw ba a ha gandɨw. ");
INSERT INTO sor_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Me Jesu ɨmɨw hára gandɨw bam me wayɨw da: «Cor, ha ulay dɨma lə ꞌywaa war̰am me, waygɨ mani nə Aba ciri gɨ Mãr̰ĩ àl gandɨm me, yara gɨ an̰ji yər n̰agɨni dɨma di me.» ");
INSERT INTO sor_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Mwom da, abe di cor ha waya mani nə Jesu àl gandɨw mana gɨ wama gɨ gɨ ꞌwogɨw Ciri dɨ mwaj dalawə, ɨr̰ɨ nare dam yər kəmə duwa. ");
INSERT INTO sor_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Mana gɨ Jesu day gɨ nə woni gɨrsə gwale duwa cwaragɨ bi gɨ bɨrwa gɨra mana gɨ kuray gɨ ɓɨle dugdɨw dɨ ka lə bi da, nare nan̰ dayar gandɨw bi mana gɨ kuray di bɨwə. ");
INSERT INTO sor_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Mwom da, abe mɨn gɨ gɨ ꞌwogɨw Jayrus, an̰ji i geche gɨnə kulu gaba amsa Mãr̰ĩ gɨnə nare nə Juwib day, swaa hára. Me mana gɨ an̰ji bo dɨrəw ca yər Jesu da, an̰ji piy gubɨrəw dodə dɨrəwə ");
INSERT INTO sor_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","me mɨrgɨw nɨm ba da: «Hare ɗe! Hare ɗe! Durmən womər nan̰e, ilə dara mara le. Hare, mə ha bwadɨ ɨsam dɨdə dara kal dɨ ꞌywana labiya me dɨ damna nɨm bɨ̀ra.» ");
INSERT INTO sor_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Me Jesu so ha gɨ abe di. Nare nan̰ bow ha gandɨw me dɨmdɨw daa pəgɨn̰ mad mad mana gɨ hára lə di. ");
INSERT INTO sor_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Mana gɨ nare nə gɨr̰e nə ta di dwar̰agɨ lə da, deme mɨn dɨ bare ha sɨdə nem aliya mwaj dii sɨr kaw ilə me ca. ");
INSERT INTO sor_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Tandi hoy sɨdɨ nan̰ mana gɨ harba gɨ dogtər sɨdəgɨ lə, mendɨ ɨsɨdɨ bam pad kaw, ꞌyo labiya bədə. Ɨr̰ɨ bare di cor ha sɨdə nan̰ bi. ");
INSERT INTO sor_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Me mana gɨ deme di doy gwale gɨ gɨ way dara Jesu mwom da, tandi way dusɨdɨ lə ba da: «Nə ɓɨlnə i barge duwa mɨra kaw, nə ha ꞌywaa labiya.» Me tandi kwanga hára Jesu tarɨwə nare dwar̰agɨ lə me ɓɨl gɨ Jesu barge duwa. ");
INSERT INTO sor_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Mana gɨ ta lə dog, bare di ha sɨdə bədə ɗɨm. Tandi kaw ꞌwocn̰ dog dara ba dɨ ꞌyo i labiya ɗɨm. ");
INSERT INTO sor_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Me mana gɨ ta lə dog da, Jesu kaw ꞌwocn̰ dusɨwə dara dwana duwa dɨ yab ba dɨm bam. Ɨr̰ɨ an̰ji co dɨrəw tarɨwə yər gɨ nare di me ùrgɨ ba da: «I wi me ɓɨlɨn mo?» ");
INSERT INTO sor_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Me woni gɨrsə gwale duwa cow lə diiyə wayɨw ba da: «Mə yər nare di gɨr̰ɨ nan̰e, cendi dɨmdər gandɨm daa pəgɨn̰ mad mad ta me, mə ùr aba ɓɨləm ɗang tugu mo?» ");
INSERT INTO sor_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Me Jesu kal sɨw ꞌwun̰bɨ tulbəw dara gaa ba a yər gɨ gun gaba ɓɨləw di. ");
INSERT INTO sor_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ɨr̰ɨ deme dɨ idɨ ɓɨləw di, lán̰a àldɨ̀, sɨdɨ sadɨdɨ tag tag, dara tandi ꞌwocn̰ mani nə yala àlal gandɨdɨ di, me tandi hára gɨra piy gubɨrədɨ dodə Jesu dɨrəwə me wayɨw gwale dɨra sɨw daa pad. ");
INSERT INTO sor_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Me ɨr̰ɨ an̰ji waydɨ ba da: «Chidɨn, də kala dusi dɨnnə da, də ꞌyo labiya ɗɨm. Ha le labiya. Mwom diya di kaw kaliye ɗɨm.» ");
INSERT INTO sor_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Mana gɨ Jesu ilə wayadɨ deme gwaleyə jang sɨn̰ da, nare nə yab swaa kɨrə nə Jayrus lə, me cendi wayɨw Jayrus ba da: «Durməm di mare ɗɨm. Mə hoy aba gɨləndɨ mani hára lə ɗang dana mo?» ");
INSERT INTO sor_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Me Jesu doy gwale day di com, me an̰ji wayɨw Jayrus ba da: «Kal àla lán̰a ɗi, me kal dusɨm mɨn dɨnnə.» ");
INSERT INTO sor_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Me mana gɨ Jesu so dara hára kɨrə nə Jayrus lə da, an̰ji ɨmgɨ nare nə bwaw di hára gandɨw bam, me kal i nə Piyer me Jak day gɨ chendɨw gɨ Jã me mɨra ha gandɨw. ");
INSERT INTO sor_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Mana gɨ cendi hára yala mana gɨ ciri dɨnə Jayrus lə ɗɨm da, Jesu yər nare ilə nulə lə me ilə swaja wuwuyu me. ");
INSERT INTO sor_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","An̰ji gandɨ ha kɨrə me waygɨ nare ba da: «I dana me anə nul nan̰ yande mo? Dwe dɨ more di mare bədə, me i i nuni.» ");
INSERT INTO sor_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ɨr̰ɨ nare di àlɨ̀w məng. Mwom da, an̰ji ꞌyor nare nə gɨr̰e di bam iche, me wol dwe di abadɨ day gɨ idɨ me woni gɨrsə gwale duwa nə subu di me mɨra ha gandɨw. An̰ji gandɨ ha mana gɨ dwe di gɨndɨdɨ lə. ");
INSERT INTO sor_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","An̰ji yɨ dwe di ɨsədɨ me waydɨ ba da: «Talita kum!» Gɨndɨw dɨ biyə way ba da: Dwe dɨ more, nə wayi: So daa! ");
INSERT INTO sor_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Mana gɨ ta lə dog, dwe di bɨdɨ a daa me, tandi so daa ilə hára lə. Dwe di, aliya dɨra i mwaj dii sɨr. Ɨr̰ɨ nare pad nə ilə me yər mani nə dan̰a nə Jesu àlgɨ di da, yɨbdɨ dɨdəgɨ me, ɗɨbɨ yər kəmə duwa. ");
INSERT INTO sor_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Me Jesu yəgdɨ sumdəgɨ nan̰e dara cendi ba cɨmnəw gun mani nə ba a àlgɨ ka di daa bədə. Me an̰ji waygɨ ɗang ba: «ꞌYànadɨ́ dwe di mani nə wama.» ");
INSERT INTO sor_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Targɨn̰ ɗang da, Jesu swaa kala ciri dɨ Kapernom bam me hára gɨra mana gɨ Najaret, dɨ i ciri dɨ tanga an̰ji ɨsər lə ɓag. Woni gɨrsə gwale duwa kaw bwaw yala gandɨw me ca. ");
INSERT INTO sor_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Me mana gɨ wála gaba bwaa gwayniyə da, an̰ji ha mana gɨ kulu gaba amsa Mãr̰ĩyə me so ilə gɨləgɨ nare mani. Nare nan̰ nə doy gwale duwa di da, gwale di ꞌyàgɨ́ ɨrmə nan̰e, me cendi way ba da: «I wi me gɨləw duwa mani nə ta di pad yande mo? Dɨrɨn̰ naa nə ta di, i man yande mo? An̰ji ꞌywagɨ i we mo? Dwana duwa dɨ idɨ àla gɨ mani nə dan̰a nə ta di da, ꞌywadɨ duwa i we yande ɓara? ");
INSERT INTO sor_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ɓag da, an̰ji tanga i aba pɨlbə habde gaa bədə mo? An̰ji i Mari gorndɨdɨ gaa bədə mo? An̰ji i nə Jak me Jose me Jud me Simõ me chandragɨ gaa bədə mo? Chamraw nə namde kaw ilə ganandɨ ka gaa bədə mo?» I dara yande di me nare nə Najaret di gɨn̰ nɨm gaba kala gɨ dusɨrəgɨ mana gɨ Jesu dɨwə bam. ");
INSERT INTO sor_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","I ta di me an̰ji waygɨ nɨm ba da: «Gun gaba cɨmə Mãr̰ĩ bɨw da, i nare nə ɗang mɨra me àlɨ́w horɨmbə cendi. Me war̰aw duwa gang nə dam gandɨw ciri dɨdə mɨn, labaa chamraw duwa gang nə dam gandɨw kɨrə mɨn kaw, àlɨ́w horɨmbə bədə ɓag.» ");
INSERT INTO sor_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","I dara yande me Jesu bo gɨ ɨsaw nare nə woməre nə yab dɨdəgɨ lə mɨra me sogɨ nɨm daa mwom dayyə, me an̰ji nem gaba àla gɨ mani nə dan̰a nə ɗang mana gɨ Najaret bədə. ");
INSERT INTO sor_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Me an̰ji ɨrɨm nan̰e dara nare di gɨn̰ kala gɨ dusɨrəgɨ dɨwə bam. Ɗang bi da, Jesu so ha ciri dɨ dine dɨ mana gɨ Najaret tulbədɨ lə bá bá dara gɨləgɨ nare mani. ");
INSERT INTO sor_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Me wála mɨn da, an̰ji ꞌwaga paja duwa nə mwaj dii sɨr di sɨwə me, an̰ji so kɨjɨgɨ sɨdəgɨ sɨr sɨr dara cendi ba hana àsɨnagɨ nare berni. An̰ji ꞌyàgɨ́ dwana dɨ idɨ ꞌywara gɨ dúndi dɨ àcn̰e bam nare sɨdəgɨ lə me ca. ");
INSERT INTO sor_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","An̰ji waygɨ ba da: «Unə sadɨ ɨsɨrangə bədə, magɨla bədə. Gursɨ kaw, unə ɨsɨrangə bədə. Me unə i cilang ɨsɨrangə ");
INSERT INTO sor_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","me hurbɨna gɨbande gɨdɨrangə. Me barge da, layna i mɨn mɨn mɨra.» ");
INSERT INTO sor_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","An̰ji waygɨ ɗang bi dara mani nə cendi ba hana àlnagɨ: «Ciri dɨ mɨn dɨ yɨnəng gɨ dwani kɨrə dɨra lə da, cɨmnə daa hana mana gɨ ciri dɨ ɗangə bədə, me damna lə mana gɨ ciri dɨ ta lə di jang ɓedɨna gɨ wála gaba swaa kala gɨ mana gɨ ta di nyamna nɨm bá. ");
INSERT INTO sor_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Me mana gɨ ciri dɨ anə dɨmnə lə me nare dɨra ùrnəng bədə me gɨn̰ɨnə dwaya gɨ gwale dan bam me da, swana daa, hana pii, kalna ciri dɨ ta di me ɓwabɨnagɨ nare dɨra usɨsɨ gɨ gɨdɨrangə bwanagɨ dodə. Mana gɨ anə àlnagɨ nare di yande da, cendi ha ꞌwacn̰a dara Mãr̰ĩ sɨw ba ꞌyolɨw dɨdəgɨ lə bədə.» ");
INSERT INTO sor_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Mwom da, paja nənə Jesu duwa di ɓɨr̰ɨn̰ cəgdɨ ha me, ha wayagɨ nare ba kalna àcn̰a day bam me ba hane ꞌywana Mãr̰ĩ ɗɨm. ");
INSERT INTO sor_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Cendi ꞌyorgɨ nare dúndi dɨ àcn̰e nan̰ bam me cendi ɓɨlbɨgɨ nare nə woməre nan̰ swani sɨdəgɨ lə me sogɨ nɨm daa mwom dayyə me ca. ");
INSERT INTO sor_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Wála gɨ ta lə da, Jesu sumɨw ꞌwogɨ nan̰e mana gɨ nare bɨdəgɨ lə. Yande da, dole gɨ gɨ ꞌwogɨw Erod kaw, doy gwale gɨnə Jesu duwa di me. Nare nə mɨn da, way ba: «I Jã gaba àlagɨ́ nare batem di me ba dɨmə daa nare nə mare dwar̰agɨ lə an̰ju. I ta di me an̰ji ꞌyo gɨ dwana dɨ idɨ àla gɨ mani nə dan̰a nə ta di.» ");
INSERT INTO sor_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Nare nə yab da, way ba i aba cɨmə Mãr̰ĩ bɨw gɨ pii gɨ gɨ ꞌwogɨw Eli, me nare nə yab ɗang da, way ba i aba cɨmə Mãr̰ĩ bɨw mɨn gɨ wun ya woni cɨmə Mãr̰ĩ bɨw nə pii di de. ");
INSERT INTO sor_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Mana gɨ Erod ba a doy yande da, an̰ji way duwa ba da: «Jã Batis di, i ɨndi sɨn ni me tanga nə waygɨ nare yɨw saw dɨw ꞌyəw bam ka di, me dɨmə daa nare nə mare dwar̰agɨ lə an̰ju.» ");
INSERT INTO sor_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","I sɨdɨ, Erod tanga yəə Jã àsaw dangeyə. An̰ji giy nare yɨw magdɨw àsɨw dangeyə dara gwale gɨnə deme dɨ gɨ ꞌwogɨdɨ Erodiyad, dɨ Erod chəbɨdɨ chendɨw gɨ Pilip lə gɨdɨdɨ dyaməw di. Me Jã di wajɨw Erod di le bá bá ba da: «Bii ɨnda gɨ ꞌwoo lə da, chaba gɨ malam di gɨdədɨ gɨ dyam da, dol bədə.» ");
INSERT INTO sor_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Me Erodiyad di kaw, dusɨdɨ womdɨ nan̰e mana gɨ Jã dɨwə. Tandi ɨlɨwe me ùr ba dɨ ꞌyəwe me ca. Me tandi ꞌyo bɨrmə gaba ꞌyáw di bədə sɨn̰, ");
INSERT INTO sor_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","dara Erod di kaw wor yɨw Jã di jaweye sɨn̰. An̰ji ꞌwocn̰ dara Jã ba i gun gɨ tɨba Mãr̰ĩ dɨrəwə, me ba i aba kɨbə Mãr̰ĩ bɨw gɨ bɨrmə duwa me ca. I ta di me an̰ji àlɨw gɨ mani mɨn tenene ɗang bədə di. Me mana gɨ Erod di ba a dwayna gwale mana gɨ Jã bɨwə da, an̰ji ꞌwocn̰ mani mɨn nə ha àla bədə. Yande pad kaw, Jã gwale duwa di ꞌyolɨw Erod di le. ");
INSERT INTO sor_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Me wála mɨn da, Erodiyad di ꞌyo bɨrmə gaba ꞌyáa gɨ Jã di. I wála gaba àla sii ꞌywala gɨnə yàa gɨnə Erod duwa lə. An̰ji ɗorbɨ mani nə wama dara ꞌyàgɨ́ nare nə an̰ji ꞌwagagɨ di. An̰ji ꞌwaga i nare nə gechide nə ciri duwa dɨdə, me gechide nənə asɨngar day me nare nə ladɨbe nə Galile me ca. ");
INSERT INTO sor_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Mwom da, dwe dɨ more dɨ i Erodiyad durmədɨ gandɨ mana gɨ kulu gɨ cendi dam lə di, me tandi n̰ar̰ɨ nare dɨrəgɨ lə. N̰ar̰a dɨra di ꞌyolgɨ nə Erod day gɨ nare pad nə dam ilə wama gandɨw maniyə di. Yande da, Erod so waydɨ dwe dɨ more di ba da: «Mani nə dɨrəy ùrnəgɨ da, wayɨn daa, nə ha ꞌyày gandagɨ le!» ");
INSERT INTO sor_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ɗang bi, an̰ji sɨrgɨdɨ sɨw ba da: «Nə ha ꞌyày mani nə də ha ùrən di le, inam i dwãr̰ĩ ni tuldɨ kaw, nə ha sawa ꞌyàyye.» ");
INSERT INTO sor_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Dwe dɨ more di dɨmə iche, me gɨra waydɨ idɨ ba da: «Nə ùrnəw i na mo?» Idɨ di codɨ lə diiyə ba da: «Ùrɨw Jã gaba àlagɨ́ nare batem di dɨw.» ");
INSERT INTO sor_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Me dwe dɨ more cwara bi kaláng mana gɨ dole di sɨwə, me tandi wayɨw ba da: «Nə ùr ba mə sawnan Jã gaba àlagɨ́ nare batem di dɨw àsɨnan mana gɨ subɨra lə ꞌyànan caga caga ka.» ");
INSERT INTO sor_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ɨr̰ɨ dole di sɨw mar bam ledede, me an̰ji nem gaba ɨmədɨ mani nə tandi ùrɨw di bam bədə, dara an̰ji dee sɨrgɨdɨ sɨw mana gɨ nare dɨrəgɨ lə. ");
INSERT INTO sor_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Mana gɨ ta lə dog, an̰ji wayɨw asɨngar gɨ mɨn ba hana sawnaw Jã dɨw hane nɨm. Mwom da, asɨngar di so ha mana gɨ kulu gɨ dangeyə sawa Jã di dɨw ");
INSERT INTO sor_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","àsa mana gɨ subɨra lə me ꞌwoo hára nɨm ꞌyàdɨ dwe dɨ more di, me tandi ha nɨm ꞌyàdɨ idɨ. ");
INSERT INTO sor_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Mana gɨ woni gɨrsə gwale gɨnə Jã duwa dwaya made duwa mwom da, cendi swaa hára u kumbɨ duwa ha nɨm àsa munɨ lə. ");
INSERT INTO sor_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Mana gɨ paja nənə Jesu duwa cwara day gɨ biyə gaba àsa berniyə da, cendi dayar mana gɨ Jesu sɨwə ilə wayaw mani nə ba gɨ àlagɨ̀ me mani nə ba gɨ gɨləgɨ nare di me pad daa. ");
INSERT INTO sor_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Me mana gɨ ka lə da, nare nə so cendi sɨdəgɨ lə ka kaw ilə hára lə nan̰e, me nə hára dara ꞌywagɨ kaw, gɨr̰ɨ nan̰e, me ɨmgɨ bɨrmə gaba wama gɨ mani bam me ca. Mwom da, ɨr̰ɨ Jesu waygɨ woni gɨrsə gwale duwa ba da: «ꞌYeni, hane, də hárang bam mɨnandɨ, me anə ha bwaa gwayni lə hin̰e me.» ");
INSERT INTO sor_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Mwom da, cendi nagɨ mana gɨ bɨrwa dalawə, cendi mɨra, me cilangɨgɨ kuray gɨ ɓɨle dara ba gɨ ha nɨm bam mɨ́ndagɨ, hən̰ gɨ nare. ");
INSERT INTO sor_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Me nare nan̰ yərgɨ hára lə me ꞌwocn̰ɨgɨ com me ca. Yande da, nare nan̰ nə ciriyə pad wà gɨ gɨdɨragɨ yá Jesu day gɨ nə paja duwa di dɨrəgɨ lə mana gɨ cendi ilə hára lə di. ");
INSERT INTO sor_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Mana gɨ Jesu ba a chə́ə dodə bɨrwa lə da, an̰ji yər nare nə gɨr̰e ilə mana gɨ ta lə di ɗɨm. Me dɨrəw ꞌyəngɨw dɨdəgɨ lə nan̰e, dara cendi wun ya dɨmən̰je nə aba gamagɨ ilə bədə ta de, me an̰ji gɨlgɨ mani nan̰e me. ");
INSERT INTO sor_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Mana gɨ dawa ilə pagara lə ɗɨm da, woni gɨrsə gwale duwa di hára tulɨwə ib me wayɨw ba da: «Dawa di yala pagare ɗɨm. Mana gɨ ka lə di kaw, i bam dɨn dwar̰ɨ lə. ");
INSERT INTO sor_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Yande da, cəgdɨ nare di daa ɗɨm, kalgɨ gɨ hana mana gɨ ciri dɨ dineyə labaa dɨ gechideyə dɨ i tulbəndɨ lə ka di gɨ hana kɨlnə mani nə wama gɨ wamna.» ");
INSERT INTO sor_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Me ɨr̰ɨ Jesu di waygɨ ba da: «Yande da, ꞌyànagɨ nare di mani nə wama ꞌyeni.» Me cendi cow lə diiyə bi ba da: «Me gaa nə hanin kɨlə mapa i gɨ gursɨ dɨ idɨ àla gɨ giyə wála aru sɨr ka di, me nə ꞌyàgɨnin gɨ wom nɨm mo?» ");
INSERT INTO sor_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesu waygɨ bi ba da: «Anə i gɨ mapa ɨndi na ilə mo? Hana, yarna.» Cendi yər me cow wayɨw lə diiyə ba da: «Nə inin gɨ mapa jii me gòche sɨr me ilə.» ");
INSERT INTO sor_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yande mwom da, Jesu waygɨ woni gɨrsə gwale duwa ba da: «Waynagɨ nare nə pad ta di, kalgɨ gɨ sabarna dodə jiga jiga me gɨ damna dodə mana gɨ chemde nə bɨ̀ra nə i ta di dɨdəgɨ lə.» ");
INSERT INTO sor_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Mwom da, nare di sabar dam dodə sɨdəgɨ nem aru me gɨnɨn̰ jii me. ");
INSERT INTO sor_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Me Jesu di lay mapa gɨ jii di me gòche nə sɨr di me ɨsəwə me u dɨrəw yər daa me àlɨ́w Mãr̰ĩ dóche lə diiyə. Mwom da, an̰ji ɓolbɨ mapa di dodə, me ꞌyàgɨ́ woni gɨrsə gwale duwa dara ba ꞌyànagɨ nare di. An̰ji ɨsɨgɨ woni gɨrsə gwale duwa gòche nə sɨr di lə diiyə. Ɨr̰ɨ cendi ɨsɨgɨ nare nə gɨr̰e di mapa di me gòche di me wom. ");
INSERT INTO sor_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nare nə gɨr̰e nə pad ta di wom mapa gɨ ta di gɨ gòche di ɨbdɨ, ");
INSERT INTO sor_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","me mapa di me gòche di me wor ɓɨl dodə. Mapa di gɨ gòche nə wor dodə di, gɨ laygɨ ꞌwonbɨ kɨrangé mwaj dii sɨr bi. ");
INSERT INTO sor_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Me nare nə woni wama mapa di me gòche di me dwar̰agɨ lə da, abje nem dubu jii. ");
INSERT INTO sor_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Mana gɨ ta lə dog da, Jesu waygɨ woni gɨrsə gwale duwa gɨ dwana ba nagɨna mana gɨ bɨrwa lə me, ba cilangɨna kuray gɨ ɓɨle di daa me, ba hana dɨrəwə alə kuray dugdɨw dɨ ta lə dɨ ɨjɨ ciri dɨ Besada. Dawa dɨ ta di lə kaw, ba a ha cagda nare nə gɨr̰e nə ta di i daa ɗɨm. ");
INSERT INTO sor_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Me an̰ji cəgdɨ nare di daa, me kal sɨw nagɨ ha daa kur̰a dɨdə dara amsa gɨ Mãr̰ĩ. ");
INSERT INTO sor_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Mana gɨ mana ba ur̰in̰ ɗɨm da, woni gɨrsə gwale duwa da, yalagɨ gɨ bɨrwa di i mana gɨ kuray don duwa lə ɗən̰ sɨn̰. Me Jesu duwa da, wara i mɨnaw mana gɨ daa wayniyə sɨn̰. ");
INSERT INTO sor_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","An̰ji yər woni gɨrsə gwale duwa di ꞌwaya gɨ bɨrwa di womgɨ nan̰e, dara gale di wada hára ɨjəgɨ le. Mana gɨ ta lə da, gɨ manapɨr da, Jesu swaa hára chə́ə kurayyə di me ha gɨ gɨdaw nimi dɨdəgɨ lə ɨjəgɨ nɨm. Me mana gɨ an̰ji ilə dara cilanga woni gɨrsə gwale duwa di lə da, cendi yərɨw hára gɨ nimi dɨdəgɨ lə di. ");
INSERT INTO sor_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Cendi pad yərɨw yande me ɨrɨm gaa ba i dúndi me ba hára tandi. Lán̰a àlgɨ nan̰e me cendi sojɨ r̰ur̰u. Mwom da, Jesu di waygɨ daa kaláng ba da: «Yɨnə sɨdəng wayna, i ɨndi! Lán̰ɨna bədə!» ");
INSERT INTO sor_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","An̰ji nagɨ bɨrwa di lə, dam dodə mana gɨ tuləgɨ lə, me gale di ɗɨbɨ dodə. Mwom da, woni gɨrsə gwale duwa di, yɨbdɨ dɨdəgɨ, ");
INSERT INTO sor_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","dara cendi ꞌwocn̰ mani nə Jesu dee àlagɨ̀ pii ɨsə gɨ mapa lə di gɨndəgɨ bədə sɨn̰. Cendi gɨn̰ ꞌwacn̰a gɨ mani gɨndəgɨ bam. ");
INSERT INTO sor_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Mana gɨ Jesu day gɨ nə woni gɨrsə gwale duwa cilangɨgɨ kuray gɨ ɓɨle di bam ɗɨm da, cendi yala mana gɨ wayniyə sɨn̰a dɨ Gɨnesaret lə. Cendi ɗondɨ bɨrwa di gawsɨniyə. ");
INSERT INTO sor_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Me mana gɨ ba gɨ chɨ́gdɨ dodə bɨrwa lə da, nare nə sɨn̰a dɨ ta lə di ꞌwocn̰ Jesu di com. ");
INSERT INTO sor_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Me ɨr̰ɨ nare di ɓɨr̰ɨn̰ wà ha mana gɨ ciri dɨ wama gɨ ta lə bá bá. Mana pad gɨ nare dwayna Jesu ba yala lə da, gɨ layɨw nare nə woməre gɨ gɨsabe day nə ꞌya hára nɨm. ");
INSERT INTO sor_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Mana gɨ ciri dɨ gechideyə labaa dɨ dineyə labaa dɨ ɓani cwan̰ cwan̰yə dɨ Jesu ha lə bá bá da, nare layaw woni mwom bow gandagɨ dɨrəwə mana gaba dayara lə me mɨrgɨw ba kalna nare nə woməre di ba ɓɨlbɨnə i chire gɨ barge duwa bɨwə mɨra, me cendi nə pad nə ɓɨlbɨ da, ꞌyo labiya. ");
INSERT INTO sor_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Nare nə gɨ ꞌwogɨgɨ Parise me nə yab ɗang woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa me swaa mana gɨ ciri dɨ geche dɨJursalem me, hára gɨra dam Jesu tulɨwə. ");
INSERT INTO sor_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Me cendi yər woni gɨrsə gwale gɨnə Jesu duwanə yab wom mani gɨ ɨsɨragɨ nə àcn̰e. Ɨsɨragɨ nə àcn̰e, gɨndɨw dɨ biyə da, i: cendi wom mani dɨban wiya gɨ ɨsɨragɨ bam ladɨ ya hada dɨnə nare nə Juwib ba dɨ ɨrɨm nɨm de. ");
INSERT INTO sor_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ɓag da, nare nə Parise di me nare nə ɗang pad nə Juwib di me da, lán̰dɨ i hada dɨnə mwágɨragɨ nə pii di le, i dara yande me cendi wiy ɨsɨragɨ bam ladɨ le do me wom gɨ mani sɨn̰. ");
INSERT INTO sor_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Mana gɨ cendi swanay sug lə kaw, cendi sabɨ sɨdəgɨ bam ya te hada dayyə de do me wom mani sɨn̰. Cendi lán̰gɨ mani nan̰ nə ɗang nə àla nə hada dayyə di le, ya wiya day gɨ mani woni wama mani me woni chàa mani me ta de. ");
INSERT INTO sor_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","I yande di me nare nə Parise me woni gɨlə bii gɨ ꞌwoo di me ùr gɨ Jesu ba da: «I dara na me woni gɨrsə gwale dɨma di àl mani nə wundər gɨ hada dɨnə mwágɨrandɨ bədə yande mo? Cendi wom mani gɨ ɨsɨragɨ nə àcn̰e bɨr̰ɨn̰ dana mo?» ");
INSERT INTO sor_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ɨr̰ɨ Jesu cogɨ lə diiyə ba da: «ꞌYeni nare nə gwale ꞌyol bɨdəngə, me dusɨrəng dɨ korgɨn̰ i jiga nə gá! Aba cɨmə Mãr̰ĩ bɨw gɨ Esayi jangɨ gwale dan daa pɨrang mana gɨ Maktubu dɨnə Mãr̰ĩyə ba da: “Mãr̰ĩ way da: ‹Nare nə ta di àlɨ́n horɨmbə i gɨ bɨdəgɨ mɨra, me dusɨrəgɨ dɨ korgɨn̰ da, i jiga gandɨn. ");
INSERT INTO sor_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Hɨrwən day di i mani nə pəgɨn̰ yag. Dara mani nə cendi gɨlgɨ nare di, i ɨrmə gɨnə nare day mɨra.›”» ");
INSERT INTO sor_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Jesu waygɨ bi ba da: «ꞌYeni da, anə kala bii gɨ ꞌwoo gɨnə Mãr̰ĩ duwa bam, me anə dam mana gɨ hada dɨnə nare dayyə. ");
INSERT INTO sor_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Əw, anə ꞌyo bɨrmə gaba gɨn̰ə gɨ bii gɨ ꞌwoo gɨnə Mãr̰ĩ duwa bam bɨr̰ɨn̰ dara gama gɨ hada dan! ");
INSERT INTO sor_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ɨrmɨnə ladɨ le! Moyis way mana gɨ bii gɨ ꞌwoo lə ba da: “Àlgɨ́ nə abam day gɨ im horɨmbə”, me an̰ji way ɗang bi ba da: “Gun gɨ cadɨbɨna abəw labaa iw da, ùr i ꞌyáa gɨ bam.” ");
INSERT INTO sor_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Me ꞌyeni da, anə gɨlgɨ nare dan, gun ba nem wayagɨ nə abəw day gɨ iw ba da: “Mani nə ɨsənnə nə dee nə ha ꞌyàng dara ba nə wang nɨm lə di, nə u bɨn ꞌyàw i Mãr̰ĩ korban ɗɨm.” Korban da, gɨndɨw dɨ biyə i sarga. ");
INSERT INTO sor_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Yande da, anə kalgɨ nare bɨrmə ba àlna dwani gɨ abɨragɨ bədə me gɨ idəgɨ bədə me. ");
INSERT INTO sor_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Yande bi kaw, anə yɨ hada dan ladɨ me anə mendɨ gɨ gwale gɨnə Mãr̰ĩ duwa bam. Me anə àl mani nan̰ ɗang nə àcn̰e nə wun yande bi.» ");
INSERT INTO sor_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ɨr̰ɨ Jesu di ꞌwaga nare nə gɨr̰e di sɨwə bi me waygɨ ba da: «ꞌYeni nə pad ka diya, kalna sumdəng ladɨ le, dwayna gwale ni gɨ nə ilə wayang gandɨwə ka di me, ꞌwacn̰ana gɨndɨw ladɨ le! ");
INSERT INTO sor_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Mani mɨn tenene nə swaa iche me gandɨ ha gun sɨwə me cow gɨ àcn̰e Mãr̰ĩ dɨrəwə da, ilə bədə bɨr̰ɨn̰. Me i mani nə swaa gun dusɨw dɨ korgɨn̰yə me i woni cwaw gɨ àcn̰e Mãr̰ĩ dɨrəwə cendi.  ");
INSERT INTO sor_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Gun gɨ sumdəw woni dwaya gwale ina lə da, kal a dwayna.» ");
INSERT INTO sor_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ɓam mwom da, Jesu so kal nare nə gɨr̰e di dodə me ha ulay. Me woni gɨrsə gwale duwa cor ùrɨw gwale gɨ diri gɨ an̰ji dee wayaw caga ka di gɨndɨw. ");
INSERT INTO sor_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Me an̰ji waygɨ ba da: «ꞌYeni di kaw, anə i woni ꞌwacn̰a mani gɨndəgɨ bədə yande me mo? Mani nə swaa iche me gandɨ ha gun sɨwə da, nem cwaa gun gɨ ta di gɨ àcn̰e Mãr̰ĩ dɨrəwə bədə. Anə ꞌwocn̰ yande bədə ɓa? ");
INSERT INTO sor_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Mani nə ta di gandɨ ha i mana gɨ gun dusɨwə bədə, me cendi gandɨ ha i nudəwə, me ɗang bi da, cendi gandɨ ha i bam mana gaba ꞌwada lə.» Yande da, Jesu way daa ba mani mɨn tenene nə wama nə co gun gɨdɨw gɨ àcn̰e Mãr̰ĩ dɨrəwə da, ba ilə bədə. ");
INSERT INTO sor_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Me an̰ji waygɨ ɗang bi ba da: «I mani nə swaa gun dusɨw dɨ korgɨn̰yə me i woni cwaw gɨ àcn̰e Mãr̰ĩ dɨrəwə cendi. ");
INSERT INTO sor_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Dara i mana gɨ gun dusɨw dɨ korgɨn̰yə me ɨrmə gɨ àcn̰e swaa lə: delme dɨ idɨ kan̰ja namde labaa abje me, mĩyni me, ꞌyáa gɨ gun gɨ ùrə dɨma me, ");
INSERT INTO sor_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","kan̰ja gɨ jam dyaməw labaa kan̰ja gɨ kondi tɨrədɨ me, ùrə gɨ mani nan̰, dusi dɨ àcn̰e, kojɨgə dɨ idɨ lama mana, àla gɨ mani nə àl jawe, harni, widɨru, ꞌwaga gɨ sii, àla gɨ mani dɨban ɨrmə gɨ gɨndəgɨ. ");
INSERT INTO sor_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Àcn̰a pad gɨ ta di swaa i gun dusɨw dɨ korgɨn̰yə me cow nɨm gun gɨ àcn̰e Mãr̰ĩ dɨrəwə di.» ");
INSERT INTO sor_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jesu so kal mana gɨnə nare nə Juwib day di bam hára yala i mana gɨ wama gɨ Tirrə. An̰ji gandɨ ha kɨrə ciri dɨ mɨnnə me ùr dara nare ba ꞌwacn̰ana hára duwa gɨ kɨrə di bədə. Me nare di ꞌwocn̰ com dara an̰ju ba yá lə kɨrə. ");
INSERT INTO sor_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Yande da, deme mɨn dɨ durmədɨ dúndi dɨ àcn̰e gɨldɨ dɨrədɨ dwaya gwale duwa me tandi swaa kaláng hára piy gubɨrədɨ dodə Jesu dɨrəwə. ");
INSERT INTO sor_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Deme dɨ ta di i Juwib bədə, gɨ yə̀dɨ i mana gɨ Siri dɨ i mana gɨ wama gɨ Penisiyə. Tandi amsɨ Jesu dara ba ꞌywarnadɨ durmədɨ dúndi dɨ àcn̰e bam sɨdə. ");
INSERT INTO sor_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jesu codɨ lə diiyə gɨ gwale gɨ diri waydɨ ba da: «Kal dine woni ciri gɨ wom haye day ɨbdɨ ladɨ le, dara chaba gɨ haye gɨnə dine woni ciri day me bwagɨ gɨ gɨrade da, ladɨ bədə.» ");
INSERT INTO sor_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ɨr̰ɨ deme di wayɨw ba da: «Aba ciri ni, ɓag kaw, gɨrade di wom i haye gɨ ɓolbər dine ɨsɨragɨ lə bor dodə tabɨl gɨndɨdɨ lə.» ");
INSERT INTO sor_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","An̰ji waydɨ bi ba da: «Dara gwale diya gɨ ta di da, dúndi dɨ àcn̰e di gandɨ bam durməy di sɨdə ɗɨm. Ha le ulay diya lə ɗɨm!» ");
INSERT INTO sor_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Deme di so ha ulay me gɨra ha ꞌywaa durmədɨ di ilə dodə solbə lə me, dúndi dɨ àcn̰e di kaw gandɨ bam sɨdə ɗɨm me ca. ");
INSERT INTO sor_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ɗang kaw, Jesu so daa kal wama gɨ Tir bam. An̰ji ha gandɨ gɨ Sidon dɨdə me cilangɨ gɨ wama gɨ gɨ ꞌwogɨw Ciri dɨ mwaj dɨwə. Me an̰ji ha nɨm ɨjɨ kuray gɨ ɓɨle gɨ Galile sɨn̰. ");
INSERT INTO sor_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Mana gɨ ta lə da, nare ꞌwów Jesu abe mɨn gɨ ɗugɨre gɨ way gwale ladɨ bədə hára nɨm. Me nare di amsɨ Jesu ba da: «Àsɨ ɨsəm dɨwə!» ");
INSERT INTO sor_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesu wol abe di ha nɨm bam hin̰e nare nə gɨr̰e di tuləgɨ lə. An̰ji hurə dùnɨw ka me ka me mana gɨ sumdəwə, ɗang da, ɓɨsɨ láde dùnɨwə me ɓɨl gɨ abe di dilesɨw gɨ dùnɨw dɨ láde ilə di. ");
INSERT INTO sor_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Mwom da, an̰ji u dɨrəw yər gɨ siyaya gɨ daa, me biy góche me wayɨw abe di ba da: «Epata!», gɨndɨw dɨ biyə ba da: «Tɨn̰ər bam!» ");
INSERT INTO sor_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Mana gɨ ta lə dog da, abe di sumdəw tɨn̰ər bam, dilesɨw kaw awrar daa, me an̰ji cor way gwale ladɨ pɨrang me ca. ");
INSERT INTO sor_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Mana gɨ ta lə da, Jesu yəgdɨ nare pad nə ilə di sumdəgɨ ba hana cɨmnəw gun daa bədə pa pa. Me mana gɨ an̰ji wajɨgɨ yande kaw, cendi ha cɨməgɨ kwandagɨ daa pii pii com, ");
INSERT INTO sor_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","dara mani nə an̰ji àlgɨ̀ ka di da, ꞌyàgɨ́ ɨrmə gɨ geche nan̰e bɨr̰ɨn̰. Yande da, cendi way ba da: «Mani duwa pad nə an̰ji àlgɨ̀ da, i nə lade nan̰e. An̰ji tɨn̰gɨ nare nə ɗugɨre sumdəgɨ bam me, nare nə mɨm bɨdəgɨ daa me ca!» ");
INSERT INTO sor_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Wála mɨn ɗang da, nare nə gɨr̰e nan̰ dayar Jesu tulɨwə bi, me mani day nə wama ilə bədə. Mwom da, Jesu ꞌwogɨ woni gɨrsə gwale duwa di sɨwə me waygɨ ba da: ");
INSERT INTO sor_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Dɨrən ꞌyəngɨn nare nə gɨr̰e nə ka di dɨdəgɨ lə. Cendi i gandɨn laba wála subu pad, me ꞌyo mani nə wama bədə. ");
INSERT INTO sor_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Me nə kalnagɨ cwarna ulay dayyə bi gɨ cherni yande da, cendi ha gabdara bam bɨrmə lə. Nə yab dwar̰agɨ lə da, swaa i hən̰.» ");
INSERT INTO sor_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Mwom da, woni gɨrsə gwale duwa di cow lə diiyə ba da: «Me caga da, də hárang ꞌywaa mapa di i we mana gɨ dɨn dwar̰ɨ lə ka di me də hárang ꞌyàgɨ́ gɨ ha wama ɨbdə nɨm di mo?» ");
INSERT INTO sor_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesu di cor ùrgɨ ba da: «Caga da, anə i gɨ mapa ɨndi ilə mo?» Cendi wayɨw ba da: «Mapa wurgɨsubu ilə.» ");
INSERT INTO sor_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ɨr̰ɨ Jesu waygɨ nare di ba damna dodə sɨn̰a lə. An̰ji lay mapa gɨ wurgɨsubu di daa ɨsəwə, me àlɨ́w Mãr̰ĩ dóche lə diiyə, do me ɓolbɨ mapa di dodə, me ꞌyàgɨ́ woni gɨrsə gwale duwa di dara ba ɨsɨnəgɨ nare di. Me woni gɨrsə gwale duwa di yɨ mapa Jesu ɨsəwə me ɨsɨgɨ nare nə gɨr̰e di. ");
INSERT INTO sor_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Gòche nə dine kaw ilə ɓani, me Jesu lay gòche di me àlɨ́w Mãr̰ĩ dóche dɨdəgɨ lə me, waygɨ woni gɨrsə gwale duwa di ba da: «Ɨsɨnəgɨ nare di gòche nə ta di lə diiyə me ca!» ");
INSERT INTO sor_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nare nə gɨr̰e di wom mapa me gòche di me ɨbdə. Ɨr̰ɨ gɨndɨw wor bɨl dodə bi, me gɨ lay ꞌwonbɨ kɨrangé wurgɨsubu daa. ");
INSERT INTO sor_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Nare nə woni wama mapa gɨ gòche nə ta di, i nare dubu wodɨ. I yande do me Jesu di kalgɨ nare di cəgdɨ ha nɨm ulay dayyə sɨn̰. ");
INSERT INTO sor_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ɨr̰ɨ an̰ji day gɨ nə woni gɨrsə gwale duwa di nagagɨ dam bɨrwa lə me hargɨ nɨm mana gɨ wama gɨ Dalmanuta lə. ");
INSERT INTO sor_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Me nare nə gɨ ꞌwogɨgɨ Parise hára ꞌyo Jesu me gagɨ gandɨw gwale gaba gɨrsəw. Cendi ùrɨw ba àlnagɨ mani nə dan̰a nə ba gɨlnəgɨ dara an̰ju ba i gun gɨ Mãr̰ĩ ba giyəw an̰ju di. ");
INSERT INTO sor_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Mwom da, Jesu bo góche gɨ geche me waygɨ ba da: «I dara na me nare nə caga di ùrɨn mani nə dan̰a mo? Dwayna, nə wayang i gwale sɨw: Cendi ha yara mani mɨn nə dan̰a nə ùrgɨ di bədə.» ");
INSERT INTO sor_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Me ɨr̰ɨ Jesu so kal nare nə Parise di bam. Me an̰ji day gɨ nə woni gɨrsə gwale duwa di hargɨ naga bɨrwa lə bi me, hargɨ nɨm kuray dugdɨw dɨ alə ta lə. ");
INSERT INTO sor_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Me woni gɨrsə gwale gɨnə Jesu duwanɨmə laya gɨ mapa nan̰ ɨsɨragɨ lə bam, cendi ꞌwoo i mapa mɨn mɨra àsa lə bɨrwa di lə di. ");
INSERT INTO sor_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesu duwa da, waygɨ dara mani nə cendi ba àlnagɨ̀: «Dwayna, àsɨna angal dan! Gamna sɨdənge dara musbu gɨnə nare nə Parise day me gɨnə dole gɨ Erod duwa me ca!» ");
INSERT INTO sor_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Yande da, cendi wajɨ bulə dayyə gaa an̰ji ba way i dara mapa day ba ilə bədə di mo? ");
INSERT INTO sor_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesu ꞌwocn̰ ɨrmə day di com, me waygɨ ba da: «I dana me anə ɨrɨmdɨ gwale dusɨrəngə, alə ba nə way i dara anə ba i gɨ mapa lə bədə di mo? Anə wor ꞌwacn̰a mani gɨndəgɨ sɨn̰ mo? Dɨdəng woye ɓa? I dana me anə gɨn̰ ꞌwacn̰a gɨ mani gɨndəgɨ bam yande mo? ");
INSERT INTO sor_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Dɨrəng ilə me anə yər gɨ mani bədə yande mo? Sumdəng ilə me anə doy gɨ gwale bədə dana mo? Dusɨrəng gwong daa mana gɨ maniyə bədə mo? ");
INSERT INTO sor_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ɨrmɨnə: Pii mana gɨ nə ɓwalba mapa gɨ jii me, nə ɨsəgɨ nare nə dubu jii di me gɨndɨw wara dodə, anə laya gɨndɨw dɨ wara dodə ꞌwanba kɨrangé ɨndi na mo?» Cendi wayɨw ba: «I mwaj dii sɨr.» ");
INSERT INTO sor_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","«Me mana gɨ nə ɓwalba mapa gɨ wurgɨsubu dodə me, nə ɨsəgɨ nare nə dubu wodɨ di me, gɨndɨw wara dodə da, anə laya gɨndɨw dɨ wara dodə di ꞌwanba kɨrangé ɨndi na mo?» Cendi way ba: «I wurgɨsubu.» ");
INSERT INTO sor_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ɨr̰ɨ an̰ji waygɨ ba da: «Anə ꞌwocn̰ mani nə ta di gɨndəgɨ bədə com sɨn̰ mo?» ");
INSERT INTO sor_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Mana gɨ Jesu day gɨ nə woni gɨrsə gwale duwa hargɨ gɨr mana gɨ Besada mwom da, nare walaw abe mɨn gɨ dɨrəw bu hára nɨm, me cendi amsɨw dara an̰ju ba ɓɨlnəw gɨ ɨsəw. ");
INSERT INTO sor_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Mwom da, Jesu yɨ abe gɨ dɨrəw bu di ɨsəw, wolɨw ha nɨm ciri gogɨr dɨra lə, me an̰ji ɓɨsɨw lade mana gɨ dɨrəwə me, bo ɨsaw dɨwə me ùrɨw ba da: «Gaa mə yər mani mo?» ");
INSERT INTO sor_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Me abe di tɨn̰ dɨrəw daa me way ba da: «Nə yər i nare; nə yərgɨ wun ya habde de, me ilə harba lə.» ");
INSERT INTO sor_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesu di cor bo ɨsaw abe di dɨrəwə ɗang bi, me mana gɨ abe di tɨn̰ dɨrəw bam ɗang bi da, an̰ji ꞌyo labiya me yər mana ladɨ pɨrang me ca! ");
INSERT INTO sor_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Me Jesu wayɨw ba da: «Cor ha ulay dɨma lə ɗɨm, me u bɨrmə gɨ ciri dɨ Besada di dɨdə bədə!» ");
INSERT INTO sor_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Mwom da, Jesu day gɨ nə woni gɨrsə gwale duwa di sogɨ gandɨgɨ dara hára mana gɨ ciri dɨ dine dɨ i ciri dɨ gɨ ꞌwogɨdɨ «Sesare dɨnə Pilip» tuldɨ lə. Me mana gɨ bɨrmə lə da, an̰ji so ùr woni gɨrsə gwale duwa ba da: «Caga da, nare di way ba nə i wi ɓag mo?» ");
INSERT INTO sor_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Me woni gɨrsə gwale duwa di wayɨw ba da: «Nare nə mɨn da, way ba mə i Jã gaba àlagɨ́ nare batem; nə yab da, way day ba mə i aba cɨmə Mãr̰ĩ bɨw gɨ Eli, nə yab ɗang bi da, way day ba mə i woni cɨmə Mãr̰ĩ bɨw nə pii gun day gɨ ɗang.» ");
INSERT INTO sor_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","An̰ji ùrgɨ ɗang bi ba da: «Me ꞌyeni dan da, anə way ba nə i wi ɓag di mo?» Ɨr̰ɨ Piyer wayɨw ba da: «Ɨjɨm da, mə i Dole gɨ Mãr̰ĩ biyəw gɨ Kris di.» ");
INSERT INTO sor_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Mwom da, Jesu yəgdɨ woni gɨrsə gwale duwa sumdəgɨ dara cendi ba cɨmnəw gun mɨn kaw gwale gɨ ta di daa bədə. ");
INSERT INTO sor_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ɗang bi da, Jesu so waygɨ woni gɨrsə gwale duwa di daa pɨrang ba da: «Ɨndi gɨ Gun gorndɨw di, ha ùrən i gɨlə gɨ dɨrɨn̰ nan̰e. Gechide nənə nare nə Juwib day me, woni bwasa Mãr̰ĩ gechide day me, woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa me, ha gɨn̰ən bam. Gɨ ha ꞌyán bam, me wála gɨ subu lə da, nə ha dɨmə daa munɨ lə.» ");
INSERT INTO sor_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Mana gɨ an̰ji waygɨ daa yande pɨrang mwom da, Piyer wolɨw ha nɨm bam tulɨn̰yə hin̰e me sogdɨw nɨm. ");
INSERT INTO sor_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Me Jesu co dɨrəw yər woni gɨrsə gwale duwa di me sogdɨw Piyer ba da: «Ha bam ched tulɨnnə, Sidan gá! Ɨrmə dɨma da, wundər gɨ ɨrmə gɨnə Mãr̰ĩ duwa bədə, me wundər i gɨ ɨrmə gɨnə nare day.» ");
INSERT INTO sor_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ɨr̰ɨ Jesu ꞌwogɨ nare nə gɨr̰e day gɨ nə woni gɨrsə gwale duwa sɨwə me waygɨ ba da: «Gun gɨ ùrnə ba a pamna tarɨn da, kal a ɨrmɨnə dɨw duwa lə an̰ju gang bədə, me a unə habda duwa gɨ dagɨla dɨwə me pamnan nɨm. ");
INSERT INTO sor_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Gun gɨ ùrnə bɨlə gɨ sɨw daa sɨn̰a dɨdə ka da, an̰ji gɨn̰ bɨlə gaba dama gɨ dɨrəw bɨr̰ɨn̰ di bam. Me gun gɨ gɨn̰ɨnə bɨlə duwa gɨ sɨw sɨn̰a dɨdə ka bam daran ɨndi me dara Nõ dɨ lade di me da, an̰ji ha ꞌywaa bɨlə gaba dama gɨ dɨrəw bɨr̰ɨn̰ di le. ");
INSERT INTO sor_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Gun da, dee ꞌywana mani nə sɨn̰a dɨdə ka pad le, me ꞌywana bɨlə gaba dama gɨ dɨrəw bɨr̰ɨn̰ bədə da, ladni duwa ilə na lə mo? ");
INSERT INTO sor_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Gun ha ꞌyàw Mãr̰ĩ i na dara kɨlə gɨ bɨlə duwa gaba dama gɨ dɨrəw bɨr̰ɨn̰ di mo? ");
INSERT INTO sor_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Nare nə caga ka i nə àcn̰e me nə woni cwaw Mãr̰ĩ taragɨ me. Gun gɨ lán̰ɨna waya nare nə ta di dɨrəgɨ lə ba a i gun ni me ba a kal dusɨw gwale niyə me da, ɨndi gɨ Gun gorndɨw di kaw, sanga wála gɨ nə cwarnay gɨ ꞌywagda gɨnə Aban duwa me gɨ paja duwa nə daa me ca da, nə ha waya an̰ju ba i gun ni bədə me ca.» ");
INSERT INTO sor_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Me an̰ji waygɨ gwale gɨ ɗang ba da: «Dwayna, nə wayang i gwale sɨw: Nare nə yab nə ilə dwar̰angə caga ka di, cendi ha yara Mãr̰ĩ lama duwa gɨ dwãr̰ĩ gɨ dwana di gɨ dɨrəgɨ day do me cendi ha mara sɨn̰.» ");
INSERT INTO sor_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Wála kubi tarɨwə da, Jesu wol Piyer me Jak me Jã me mɨra, ha gandagɨ bam tulɨn̰yə hin̰e, mana gɨ kur̰a dɨ hoy dɨdə bam mɨ́ndagɨ, hən̰ gɨ nare. Mana gɨ cendi i mɨ́ndagɨ kur̰a dɨdə mwom da, Jesu sɨw kɨlangar bam wun jiga mana gɨ dɨrəgɨ lə. ");
INSERT INTO sor_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Barge duwa da, cor ꞌyogdɨ ꞌywagda gɨ àl lán̰a nan̰e me wusɨ kəng. Wusɨnani gɨ ta di, gun mɨn gɨ sɨn̰a dɨdə ka nem àlàw bədə. ");
INSERT INTO sor_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Me jisgɨ yande da, woni gɨrsə gwale duwa nə subu di yər woni cɨmə Mãr̰ĩ bɨw nə pii nə Eli day gɨ Moyis kaw ilə waya gwaleyə gɨ Jesu me. ");
INSERT INTO sor_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Mwom da, Piyer wayɨw Jesu ba da: «Aba gɨlənin mani, dama ɨnda gɨ ka di da, ladɨ nan̰e. Kalnin nə ɗangr̰ɨnin kundi subu, mɨn dɨma, me mɨn ɗang Moyis duwa, me mɨn ɗang bi, Eli duwa me.» ");
INSERT INTO sor_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Me gwale gɨ Piyer wayɨw ta di, an̰ji way i gwale gɨ bɨrmə duwa bədə, dara an̰ji day gɨ nə kwandaw di, lán̰a cor àlgɨ̀ le. ");
INSERT INTO sor_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ɨr̰ɨ cendi yər siyaya mugɨ daa kɨdab, me doy gwale nɨm siyaya di dalawə way ba da: «Ta di me i gorndɨn, dusɨn ùrɨw nan̰e. Dwayna gwale bɨwə!» ");
INSERT INTO sor_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Mana gɨ ta lə dog, woni gɨrsə gwale gɨnə Jesu duwa di, yərbɨ mana, me cendi yər gun mɨn gɨ ɗang ilə bədə, me i Jesu di mɨn tenene ilə gandagɨ an̰ju. ");
INSERT INTO sor_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Mana gɨ cendi ilə chə́ə nɨm dodə kur̰a lə di da, Jesu waygɨ woni gɨrsə gwale duwa cendi ba cɨmnəw gun mani nə cendi ba yaragɨ gɨ dɨrəgɨ ka di gwale day daa bədə pa pa, bɨraa kal an̰ju gɨ Gun gorndɨw di ba a dɨmnə nɨm daa nare nə mare dwar̰agɨ lə bá. ");
INSERT INTO sor_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Cendi gam gwale gɨ an̰ji waygɨ di dusɨrəgɨ lə, me ùrbɨ i sɨdəgɨ dara gwale gɨ «swaa gɨ daa mana gɨ nare nə mare dwar̰agɨ lə» di da, gɨndɨw ba i man mo? ");
INSERT INTO sor_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ɗang da, cendi ùr Jesu ba da: «Woni gɨlə bii gɨ ꞌwoo way ba Eli ba hára lə bá do me Dole gɨ Mãr̰ĩ biyəw gɨ Kris di ba hára sɨn̰ di da, i dara na ɓag di mo?» ");
INSERT INTO sor_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Mwom da, Jesu waygɨ ba da: «I sɨdɨ. Eli di hára lə bá dara ɗangr̰a gɨ mani pad gɨ bɨrmə day. Inam yande da, i man me gɨ jangɨ Maktubu dɨnə Mãr̰ĩyə way ba Gun gorndɨw di ba ha gɨlə dɨrɨn̰ nan̰e, me ba gɨ ha gɨn̰əw bam me mo? ");
INSERT INTO sor_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ɓag da, nə wayang daa: Eli di da, an̰ji gɨra ɗɨm, me nare àlɨ́w mani pad nə dɨrəgɨ ùr. I ta di me gwale gɨ gɨ jangɨw lə mana gɨ Maktubu dɨnə Mãr̰ĩyə pii dara daraw di, yala àlal nɨm.» ");
INSERT INTO sor_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Mana gɨ Jesu day gɨ nə woni gɨrsə gwale duwa nə subu di cwaragɨ yala mana gɨ woni gɨrsə gwale duwa nə wor dodə di sɨdəgɨ lə ib da, cendi yər nare nə gɨr̰e nan̰ ilə gandagɨ liwgɨ daa, me woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa kaw, ilə gaga gwaleyə gandagɨ. ");
INSERT INTO sor_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Mana gɨ nare di ba gɨ yər Jesu hára yala mwom da, sɨdəgɨ ꞌyolgɨ, cendi wà kaláng saw Jesu dɨrəw daa dara àlaw gɨ labiya. ");
INSERT INTO sor_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesu di ùrgɨ ba da: «Anə gagɨ gwale gɨ woni gɨrsə gwale ni da, i gwale na mo?» ");
INSERT INTO sor_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Mwom da, gun mɨn nare dwar̰agɨ lə cow lə diiyə ba da: «Aba gɨlənin mani, nə walam gorndɨn gɨ dúndi dɨ àcn̰e ɨmɨw waya gɨ gwale bam yala nɨm lə. ");
INSERT INTO sor_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Mana gɨ we weyə kaw, dúndi dɨ ta di swanaw daa, ɨndəw i dodə, bɨw sugdɨ le me yɨdɨbə sandaw me sɨw kaw, mar bam woy pəgɨn̰ kagaga me. Dee nə amsɨ woni gɨrsə gwale dɨma dara ba ꞌywarnaw dúndi dɨ ta di bam kaw, cendi nem ꞌywaraw gandɨdɨ bədə.» ");
INSERT INTO sor_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Mwom da, Jesu waygɨ ba da: «ꞌYeni nare nə caga woni kala dusɨrəng dɨnnə bədə nə gá! Nə ha dama gandang àla wála ɨndi na mo? Nə ha ꞌwóng dɨn bam bɨraa mindi na mo? Walnan dwe di hane nɨm!» ");
INSERT INTO sor_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Cendi walaw dwe di hára nɨm, me mana gɨ dúndi dɨ àcn̰e di ba dɨ bo dɨrədɨ ca yər Jesu da, tandi u dwe di gɨ dwana ɨndəw dodə, dwe di habdɨ dodə sɨn̰a lə, me bɨw kaw sugdɨ me ca. ");
INSERT INTO sor_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Mwom da, Jesu ùr dwe di abəw ba da: «Mani nə ta di àlɨ̀w i mindi na mo?» An̰ji cow lə diiyə ba da: «Mani di àlɨ̀w i ɓɨg mana gɨ an̰ji wor nɨm gɨ dɨnani duwa bá. ");
INSERT INTO sor_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Dúndi dɨ ta di ɓugdɨw mana gɨ duwa lə me nimiyə me ilə dara ꞌyáw nɨm ta di. Me dee mə nyamna gaba àláw maniye da, yər n̰agɨni nin me waninnə!» ");
INSERT INTO sor_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesu wayɨw ba da: «Dana me mə way ba “dee nə nyamna” ba mo? Gun gɨ kalna dusɨw dɨnnə da, nə nem àláw mani pad le.» ");
INSERT INTO sor_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Mana gɨ ta lə dog da, dwe di abəw so soy mar̰ɨjaw daa nan̰ way ba da: «Nə kal dusɨn dɨmmə! Me wannə, dusi ni dɨ kala di i ɓani sɨn̰.» ");
INSERT INTO sor_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Mana gɨ Jesu ilə waya gwaleyə gɨ dwe di abəw da, nare ilə hára lə dajara nan̰ nan̰. Mana gɨ Jesu yərgɨ yande da, an̰ji ɨr̰ɨn̰ dúndi dɨ àcn̰e waydɨ ba da: «Dúndi dɨ idɨ ɨməw dwe waya gɨ gwale bam me dwaya gɨ gwale bam di me! I ɨndi me nə wayi: Dɨm bam dwe di sɨwə, me cwaray sɨwə ɗang bi bədə ɗɨm!» ");
INSERT INTO sor_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Mwom da, dúndi di so soy daa nan̰, nongr̰ɨ dwe di ɨndəw dodə gɨ dwana, do me tandi dɨm nɨm bam dwe di sɨwə, kal dwe di wun gun gɨ mare. Nare nan̰ way dwe di ba mare. ");
INSERT INTO sor_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Me Jesu yɨ dwe di ɨsəw dara ba swana daa, me an̰ji so ɗɨbɨ daa. ");
INSERT INTO sor_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Mwom da, Jesu so ha kɨrə. Me mana gɨ woni gɨrsə gwale duwa ilə gandɨw kɨrə mɨ́ndagɨ da, cendi ùrɨw: «I dana me nenin da, nə nyamanin ꞌywara dúndi dɨ ta di bam bədə mo?» ");
INSERT INTO sor_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesu cogɨ lə diiyə ba da: «Dúndi dɨ ya ta de di da, i gɨ amsa gɨ Mãr̰ĩ me gɨ ꞌyordɨ nɨm bam gun sɨwə.» ");
INSERT INTO sor_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ɨr̰ɨ Jesu day gɨ nə woni gɨrsə gwale duwa sogɨ daa kal mana gɨ ka di bam, me cendi ha jə̀ gɨ wama gɨ Galile dɨwə. Me Jesu da, ùr dee gun mɨn kaw ba ꞌwacn̰ana bədə, ");
INSERT INTO sor_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","dara an̰ji ilə gɨləgɨ i woni gɨrsə gwale duwa mani. An̰ji waygɨ ba da: «Ɨndi gɨ Gun gorndɨw di da, gɨ ha ꞌyàn nare ɨsɨragɨ lə. Cendi ha ꞌyán bam. Me mana gɨ cendi dara ꞌyán bam da, wála gɨ subu lə da, nə ha dɨmə daa munɨ lə.» ");
INSERT INTO sor_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Woni gɨrsə gwale duwa di ꞌwocn̰ gwale gɨ ta di gɨndɨw bədə, me cendi lán̰ ùrɨw bam. ");
INSERT INTO sor_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Jesu day gɨ nə woni gɨrsə gwale duwa yalagɨ ciri dɨ Kapernommə ɗɨm. Me mana gɨ cendi i kɨrə da, Jesu ùrgɨ ba da: «Dee anə gagɨ gwale bɨrmə lə da, i gwale na mo?» ");
INSERT INTO sor_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Me cendi àsɨ́w gwale lə diiyə bədə. Ɓag da, mana gɨ bɨrmə lə di, cendi dee gaga dara ꞌwacn̰a, i wi me dwar̰agɨ lə da, ba i geche mo. ");
INSERT INTO sor_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ɨr̰ɨ Jesu kal sɨw dam dodə ꞌwaga woni gɨrsə gwale duwa nə mwaj dii sɨr di sɨwə ib me waygɨ ba da: «Gun gɨ ùrnə ba a ina i gɨ pii an̰ju da, kal a cwana sɨw gun gɨ i kwandaw nə pad ka di taragɨ lə, me aba kɨjəgɨ me ca.» ");
INSERT INTO sor_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ɨr̰ɨ Jesu di wàla dwe gɨ ꞌyəng chɨ́w dwar̰agɨ lə, yɨw sɨwə me waygɨ woni gɨrsə gwale duwa ba da: ");
INSERT INTO sor_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Gun gɨ yɨnə gun gɨ wun ya dwe gɨ ka di de gɨ dwani dara daran ɨndi da, an̰ji yɨn i ɨndi. Me gun gɨ yɨnən gɨ dwani yande da, an̰ji yɨn i ɨndi mɨra bədə, me yɨ i aba giyən di.» ");
INSERT INTO sor_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jã wayɨw Jesu ba da: «Aba gɨlənin mani, dee nə yaranin gun mɨn ꞌywara dúndi dɨ àcn̰e bam nare sɨdəgɨ lə gɨ sumɨm, me nə kan̰janin ba nə ɨməwnin bam, dara an̰ji i ganandɨ mɨn bədə.» ");
INSERT INTO sor_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Me Jesu wayɨw ba da: «Ɨmnəw bam bədə. Dara gun gɨ àlna mani nə dan̰a gɨ sumɨn da, an̰ji i gun gɨ ha waya gwale ni gɨ àcn̰e kaláng bədə. ");
INSERT INTO sor_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Gun gɨ ɨlnəndɨ bədə da, an̰ji i gun ɨnda. ");
INSERT INTO sor_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Dwayna, nə wayang i gwale sɨw: Gun gɨ ꞌyànang nimi nə chàa dara anə ba i nare nənə Kris duwa da, inam i maniyə ɓani yande hin̰e mɨra kaw, an̰ji ha ꞌywaa gwayni duwa le bá.» ");
INSERT INTO sor_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","«Chamran nə nem mani bədə nare dɨrəgɨ lə nə kal dusɨrəgɨ dɨnnə ta di, me gun gɨ lamna gun day gɨ mɨn dwar̰agɨ lə àsɨnaw àla gɨ àcn̰a lə da, gun gɨ ta di, gɨ manaw kur̰a dɨ jore dɨ nu nan̰ kunəwə me gɨ unəw àlnaw mana gɨ nimi nə kuray gɨ gecheyə kaw, womme bədə sɨn̰. ");
INSERT INTO sor_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Inam i ɨsəm mɨn me lamnam àsɨnam àla gɨ àcn̰a lə da, saw álɨw bam! Hára gɨ mana gɨ bɨlə gaba dama gɨ dɨrəw bɨr̰ɨn̰yə gɨ ɨsəm mɨn da, ladɨ nan̰ ɗoy kala gɨ ɨsam lə ca me, mə ha nɨm dùwa dɨ budə dɨra gɨ bam ilə bədə bɨr̰ɨn̰yə di.  ");
INSERT INTO sor_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Mana gɨ ta lə da, dan̰ dɨ idɨ mara bədə bɨr̰ɨn̰ dɨ idɨ wama nare kumbɨ day ilə, me dùwa dɨ budə dɨra gɨ bam ilə bədə bɨr̰ɨn̰ ilə me ca. ");
INSERT INTO sor_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Inam i dɨgɨlam mɨn me lamnam àsɨnam àla gɨ àcn̰a lə tandi da, sawdɨ áldɨ bam! Hára gɨ mana gɨ bɨlə gaba dama gɨ dɨrəw bɨr̰ɨn̰yə gɨ dɨgɨlam mɨn da, ladɨ nan̰ ɗoy kala gɨ gɨdam lə ca me, gɨ ha àsam nɨm dùwa dɨ budə dɨra gɨ bam ilə bədə bɨr̰ɨn̰yə di.  ");
INSERT INTO sor_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Mana gɨ ta lə da, dan̰ dɨ idɨ mara bədə bɨr̰ɨn̰ dɨ idɨ wama nare kumbɨ day ilə, me dùwa dɨ budə dɨra gɨ bam ilə bədə bɨr̰ɨn̰ ilə me ca. ");
INSERT INTO sor_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Inam i dudɨm mɨn me lamnam àsɨnam àla gɨ àcn̰a lə da, biydɨ áldɨ bam! Ganda hára gɨ ciri dɨnə Mãr̰ĩyə gɨ dudɨm mɨn da, ladɨ nan̰ ɗoy kala gɨ dɨrəm lə ca me, gɨ ha àsam nɨm mana gɨ dùwa dɨ budə dɨra ilə bədə bɨr̰ɨn̰yə di. ");
INSERT INTO sor_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Mana gɨ ta lə da, dan̰ dɨ idɨ mara bədə bɨr̰ɨn̰ dɨ idɨ wama nare kumbɨ day ilə, me dùwa dɨ budə dɨra gɨ bam ilə bədə bɨr̰ɨn̰ ilə me ca. ");
INSERT INTO sor_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Dùwa ul biri maru duwa bam gɨdɨw gɨ lade. Wàla kaw, gɨ bow wama lə dara wama di ba ꞌywalna nɨm. I ya ta di de me Mãr̰ĩ àsɨw gun gɨ we we kaw wamani dara ba ɗangr̰ɨnaw gɨdɨnəw gun gɨ lade. ");
INSERT INTO sor_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Wàla da, i mani nə lade me, mana gɨ wàla di hɨranga duwa biyarna bam da, gɨ ha àlaw man me ha cwara hɨranga ɗang bi mo? Kal anə wun i ya wála gɨ ꞌyole de mana gɨ nare dwar̰agɨ lə, me yɨnə sɨdəng gɨ dwani me ca.» ");
INSERT INTO sor_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Mwom da, Jesu day gɨ nə woni gɨrsə gwale duwa di swagɨ daa mana gɨ Kapernom dara hára wama gɨ Judeyə me kuray gɨ Jurde dugdɨw dɨ alə ta lə me ca. Mwom da, nare nan̰ gɨra dayar gandɨw ɗang bi me, an̰ji gɨlgɨ gwale gɨnə Mãr̰ĩ duwa, ya ba a àl nɨm pii pii de. ");
INSERT INTO sor_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Mana gɨ ta lə da, nare nə gɨ ꞌwogɨgɨ Parise hára Jesu sɨwə ib me ùrɨw nɨm gɨ gwale gaba gɨrsəw ba da: «Bɨrmə ɨnda gɨnə Mãr̰ĩyə da,  abe nem agda gɨ dyaməw bam mo?» ");
INSERT INTO sor_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ɨr̰ɨ Jesu di kal sɨw ùrgɨ ba da: «Mana gɨ bii gɨ ꞌwoo lə da, Moyis wayang ba man mo?» ");
INSERT INTO sor_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Cendi cow lə diiyə wayɨw ba da: «An̰ji kalnin bɨrmə ba abe gɨ ba ùrnə ꞌywara gɨ dyaməw bam bɨr̰ɨn̰ da, kal an̰ju ba ꞌyànadɨ maktubu dɨ idɨ agda bam ɨsədɨ lə me, an̰ju ba agdɨna gandɨdɨ sɨn̰.» ");
INSERT INTO sor_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ɨr̰ɨ Jesu waygɨ ba da: «I dara dɨdəng wayni dɨra me Moyis kalang gɨ bɨrmə anə àl nɨm yande ta di. ");
INSERT INTO sor_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Me mana gɨ Mãr̰ĩ diy gɨ mani pad gɨndəgɨ da, an̰ji ɗar̰ɨ nare nə gɨsɨgədə abe me deme me. ");
INSERT INTO sor_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","I dara yande me abe ha swaa kala abəw day gɨ iw bam, ha ɓamara nɨm gɨ dyaməw me, ");
INSERT INTO sor_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","cendi gɨdɨ ya gun mɨn tenene de. Yande da, cendi i nare sɨr bədə me cor i gun mɨn tenene ɗɨm. ");
INSERT INTO sor_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Yande da, mani nə Mãr̰ĩ dáygɨ an̰ju da, kal gun anagɨ bam bədə.» ");
INSERT INTO sor_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Targɨn̰ da, mana gɨ Jesu igɨ kɨrə gɨ nə woni gɨrsə gwale duwa da, cendi ùrɨw ɗang bi dara gwale gɨnə agda gɨ deme bam di. ");
INSERT INTO sor_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesu waygɨ ba da: «Gun gɨ ana gɨ dyaməw bam me unə dɨ ɗang da, an̰ji àl i àcn̰a gɨ dyaməw dɨ pii di. I ya an̰ji ba i i gɨ jaw dyaməw de. ");
INSERT INTO sor_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Deme kaw, dɨ swana gɨn̰ɨnə tɨrədɨ bam me unə abe gɨ ɗang da, tandi àl i àcn̰a gɨ tɨrədɨ gɨ pii di. I ya tandi ba i i gɨ kondɨdɨ tɨrədɨ de me ca.» ");
INSERT INTO sor_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ɗang da, nare hára gɨ dine nə ꞌyəng ꞌyàw Jesu dara an̰ju ba ɓɨlbɨnə sɨdəgɨ me ba amsɨna Mãr̰ĩ daragɨ. Me woni gɨrsə gwale gɨnə Jesu duwadi sogdɨgɨ nare di le. ");
INSERT INTO sor_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Mana gɨ Jesu ba a yər yande da, dusɨw naw me, waygɨ ba da: «Kalnay dine di gɨ hane ꞌywanan, ɨmnəgɨ bam bədə. Dara i nare nə wun ya cendi de me nem dɨmə hára ciri dɨnə Mãr̰ĩ duwa lə di cendi. ");
INSERT INTO sor_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Dwayna, nə wayang i gwale sɨw: Gun gɨ kalna Mãr̰ĩ lamna dwãr̰ĩ duwa dɨwə ya dwe gɨ ꞌyəng de bədə da, an̰ji ha ganda hára ciri dɨnə Mãr̰ĩyə di bədə.» ");
INSERT INTO sor_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Mwom da, Jesu lay dine nə ꞌyəng di yɨbɨgɨ daa jorgɨwə me, bogɨ ɨsaw dɨdəgɨ lə me, piygɨ bɨw dɨdəgɨ lə. ");
INSERT INTO sor_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Mana gɨ Jesu ɨndər bɨrmə lə dara hára mwom da, abe mɨn wada gɨ gidi gɨra piy gubɨrəw dodə dɨrəwə me ùrɨw ba da: «Aba gɨlənin mani gɨ lade, nə ha àla i man me nə ha ꞌywaa nɨm gɨ bɨlə gaba dama gɨ dɨrəw bɨr̰ɨn̰ di mo?» ");
INSERT INTO sor_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesu wayɨw da: «Mə ꞌwogɨn ba nə i gun gɨ lade dana mo? Gun gɨ lade da, i Mãr̰ĩ mɨn tenene. ");
INSERT INTO sor_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Mə ꞌwocn̰ mani nə bii gɨ ꞌwoo gɨnə Mãr̰ĩ duwa waygɨ di com: ba mə ꞌyána gun gɨ ùrə dɨma bədə, ba mə kan̰jɨna gun dyaməw bədə, ba mə mĩynə bədə, ba mə sawnaw gun gwale àsɨnaw dɨwə bədə, ba mə àlnaw jam gun mani nə àcn̰e bədə, ba mə àlnagɨ nə abam day gɨ im horɨmbə me.» ");
INSERT INTO sor_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Abe di wayɨw da: «Aba gɨlənin mani, mani nə pad ta di, nə àlgɨ̀ le ɓɨg dɨnani niyə bá.» ");
INSERT INTO sor_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesu yərɨw bɨraa, me dusɨw ùrɨw nan̰e, me wayɨw ba da: «Mani mɨn worɨm àla ilə sɨn̰: Ha mə ha kɨlə mani dɨma nə ꞌywaa bam pad me, gursɨ day da, ɨsɨgɨ nare nə bugɨr. Yande me, mə ha ꞌywaa mani nə ꞌywaa daa Mãr̰ĩ sɨwə. Me hare, pam tarɨn.» ");
INSERT INTO sor_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ɨr̰ɨ Jesu gwale duwa gɨ ta di ꞌyolɨw bədə bɨr̰ɨn̰ me, sɨw mar bam ledede me, ɨndər yá, dara an̰ji, mani duwa nə ꞌywaa di ꞌyarbar nan̰e. ");
INSERT INTO sor_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesu yərbɨ woni gɨrsə gwale duwa nə tulbəwə di me waygɨ ba da: «Ay! Nare woni ꞌywaa mani da, ganda day gaba hára ciri dɨnə Mãr̰ĩyə da, wom nan̰e.» ");
INSERT INTO sor_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Woni gɨrsə gwale duwa di, dusɨrəgɨ nagɨ dara gwale gɨ an̰ji waygɨ gandɨw di. Me Jesu waygɨ ɗang bi: «Dɨndan, ganda gaba hára ciri dɨnə Mãr̰ĩyə da, wom nan̰e. ");
INSERT INTO sor_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Jambal dɨmnə libara gaba busə mani gubu duwa lə kaw, wom bədə sɨn̰. Me gun gaba ꞌywaa mani da, ganda duwa gaba hára gɨ ciri dɨnə Mãr̰ĩyə da, wom nan̰ ɗoy bam.» ");
INSERT INTO sor_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Gwale gɨ ta di ɗoy woni gɨrsə gwale gɨnə Jesu dɨdəgɨ bam me, cendi wajɨ gwale bulə dayyə ba da: «Me inam i yande da, i wi me ha nyama ꞌywaa bɨlə di mo?» ");
INSERT INTO sor_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesu yərbɨgɨ me waygɨ da: «Nare da, wom ɗoy dɨdəgɨ le, me Mãr̰ĩ da, wom gandɨw bədə. Mani mɨn nə ɗoy Mãr̰ĩ dɨw da, ilə bədə.» ");
INSERT INTO sor_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Mwom da, Piyer wayɨw da: «Me nenin da, nə kalanin mani pad bam taraninnə dara pama tarɨm. Nin da, ha ꞌya i man mo?» ");
INSERT INTO sor_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesu wayɨw ba da: «Dwayna, nə wayang i gwale sɨw: Gun gɨ kalna ciri duwa me, chamraw nə abje me nə namde me, iw me abəw me dɨndaw labaa dàge duwa bam dara daran ɨndi me dara Nõ dɨ lade di me da, ");
INSERT INTO sor_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Mãr̰ĩ ha bwaw gun gɨ ta di mani nə pad ta di lə diiyə dii aru caga dama duwa gɨ sɨn̰a dɨdə ka: nə ciri, nə chamraw nə abje me nə namde me, nə igɨrəw me, nə dine, nə dàge me ca. Gun gɨ ta di, ha gɨlə i dɨrɨn̰ me ca. Me ɗan̰ sanga da, an̰ji ha ꞌywaa i bɨlə gaba dama gɨ dɨrəw bɨr̰ɨn̰. ");
INSERT INTO sor_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Nare nan̰ nə caga i nə pii cendi da, ha cwara ꞌya i nə targɨn̰ dwar̰agɨ lə, me nare nan̰ nə caga i targɨn̰ da, ha cwara ꞌya i nə pii dwar̰agɨ lə me ca.» ");
INSERT INTO sor_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Cendi ilə bɨrmə lə dara hára Jursalem. I Jesu me ha dɨrəgɨ lə. Woni gɨrsə gwale duwa di ɨrɨmdɨ gwale nan̰e me, woni pama taragɨ da, lán̰a àlgɨ le. Ɨr̰ɨ Jesu cor wol woni gɨrsə gwale duwa nə mwaj dii sɨr di bi mɨ́ndagɨ me ilə wayagɨ gwaleyə dara mani nə mɨra ba ha ꞌywawe di. ");
INSERT INTO sor_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","An̰ji waygɨ da: «Dwayna, də ilə nagang hára i Jursalem. Mana gɨ ciri dɨ ta lə di me ɨndi gɨ Gun gorndɨw di, gɨ ha yə̀n ꞌyàgɨ́ woni bwasa Mãr̰ĩ gechide day me, woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa me ɨsɨragɨ lə. Cendi ha maa bɨdəgɨ dara ba gɨ ꞌyánan, me gɨra ha ꞌyàn nare nə i Juwib bədə ɨsɨragɨ lə. ");
INSERT INTO sor_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Cendi ha àlan məng, ha ɓɨsɨbən lade sɨnnə, ha gwaban gɨ bɨr̰aw me ha ꞌyánne. Me wála gɨ subu lə da, nə ha dɨmə daa munɨ lə.» ");
INSERT INTO sor_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Targɨn̰ ɗang da, nə Jak day gɨ Jã nə i Jebede dɨndaw hára Jesu tulɨwə ib me wayɨw ba da: «Aba gɨlənin mani, mani nə nə ilənin ùrəmmə ta di da, nə ùrnin ba mə àlnanin gandagɨ le.» ");
INSERT INTO sor_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","An̰ji ùrgɨ ba da: «Anə ùr ba nə àlnang i na mo?» ");
INSERT INTO sor_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Cendi wayɨw ba da: «Wála gɨ mə dara dama mana dɨma gɨ ꞌyogdeyə da, kalnin nə damnin gun mɨn ɨsəm gɨ abeyə, me gun mɨn ɨsəm gɨ jeleyə me ca.» ");
INSERT INTO sor_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Me Jesu waygɨ da: «ꞌYeni da, mani nə anə amsɨgɨ ta di da, anə ꞌwocn̰ gɨndəgɨ bədə. Gaa gɨlə gɨ dɨrɨn̰ gɨ nə ha gɨləw di da, anə ha nyamaw mɨnang mo? Labaa, gaa anə ha nyama ùrə batem dɨ wamani dɨ gɨ ha àlan gandɨdɨ di mɨnang mo?» ");
INSERT INTO sor_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Cendi wayɨw ba: «Nə hanin nyama le.» Mwom da, Jesu di waygɨ ba da: «I sɨdɨ. Anə ha gɨlə dɨrɨn̰ gɨ nə ha gɨləw di le, me batem dɨ gɨ ha àlan gandɨdɨ di, gɨ ha àlang ꞌyeni me ca. ");
INSERT INTO sor_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Me dara mana dan gaba dama, gun mɨn ɨsən gɨ abeyə me, gɨ mɨn ɨsən gɨ jeleyə me da, nə nem ɨrməng gandɨw ɨndi bədə. Mana gɨ ta di igɨ i nare nə Mãr̰ĩ ɗangr̰ɨgɨ gandɨw di day.» ");
INSERT INTO sor_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Mana gɨ woni gɨrsə gwale duwa nə wor mwaj di ba gɨ doy gwale gɨ ta di da, dusɨrəgɨ nagɨ nə Jak day gɨ Jã di dɨdəgɨ lə. ");
INSERT INTO sor_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Mwom da, Jesu ꞌwagagɨ sɨwə pad dayyə me waygɨ ba da: «Anə ꞌwocn̰ com dara nare nə gɨ ɨrmɨgɨ ba i dolgə nənə nare nə sɨn̰a gɨndɨdɨ lə pad da, cendi bɨl nare day ya ba gɨ i woni ciri day de. Me nare woni dwana kaw, gɨlgɨ kwandagɨ nə nare dɨrəgɨ me ca. ");
INSERT INTO sor_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Me bulə dannə da, kal ina yande bədə. Ladni duwa da, gun gɨ ùrnə ba a ina geche dan da, kal a ina aba kɨjəgɨ kwandaw. ");
INSERT INTO sor_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Me gun gɨ ùrnə ba a ina i gɨ pii bulə dannə an̰ju da, kal a cwarna kwaya gɨnə kwandaw day pad. ");
INSERT INTO sor_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Yarna, ɨndi gɨ Gun gorndɨw di kaw, nə hára i dara nare ba wanannə cendi bədə, me nə hára i dara wagɨ gɨ nare lə ɨndi me ꞌwoo gɨ sɨn ꞌyàdɨ made dara kɨdə gɨ nare nan̰ daa me ca.» ");
INSERT INTO sor_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jesu day gɨ nə woni gɨrsə gwale duwa gɨragɨ mana gɨ ciri dɨ Jeriko lə, me mana gɨ cendi gandɨ bam ciri dɨ ta di lə dara hára pii da, nare nan̰ ha gandagɨ dara bwagɨ. Abe gɨ boy mɨn gɨ gɨ ꞌwogɨw Bartime, gɨ i Time gorndɨw, dam lə bɨrmə dugdɨwə amsa lə. ");
INSERT INTO sor_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Mana gɨ an̰ji doy dara ba i Jesu gɨ Najaret me ba yala an̰ju da, an̰ji so soy mar̰ɨjaw daa nan̰ ba da: «Jesu gɨnə dole gɨ Dabid mwàw, yər n̰agɨni ni ɗe!» ");
INSERT INTO sor_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Mwom da, nare nan̰ àlɨw gwale an̰ju ba ɗyasɨna bɨw daa, ɨr̰ɨ an̰ji cor soy mar̰ɨjaw daa nan̰ ɗoy gɨ pii bam bi ba da: «Dole gɨ Dabid mwàw, yər n̰agɨni ni ɗe!» ");
INSERT INTO sor_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Mwom da, Jesu di ɗɨbɨ dodə me waygɨ nare ba da: «ꞌwagɨnan abe gɨ ta di kwa!» Nare di ꞌwaga abe gɨ boy di me wayɨw ba da: «Yɨ sɨm woy! So daa, an̰ji ꞌwogɨmme.» ");
INSERT INTO sor_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Mana gɨ an̰ji ba doy yande da, kal barge duwa gɨ geche dodə me so daa pɨlam ha ɨjɨ Jesu. ");
INSERT INTO sor_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Me Jesu di wayɨw da: «Mə ùr ba nə àlnam i na mo?» Abe gɨ boy di cow lə diiyə ba da: «Aba gɨlənin mani, tin̰ɨn dɨrən bam. Nə ùr ba nə cor yər mana bi.» ");
INSERT INTO sor_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesu wayɨw da: «Mə kala dusɨm dɨnnə da, mə ꞌyo labiya, me ha le maa ɗɨm.» Mana gɨ ta lə dog da, abe gɨ boy di yər mana pəgɨn̰ pɨrang me kal sɨw pam Jesu tarɨw. ");
INSERT INTO sor_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ɨr̰ɨ Jesu day gɨ nə woni gɨrsə gwale duwa chidɨ yala ib gɨ ciri dɨ dine dɨ Betɨpageyə me, dɨ Betaniyə me, dɨ i ib gɨ ciri dɨ geche dɨ Jursalem di. Cendi hargɨ ɨjɨ kur̰a dɨ Olib lə. Mwom da, Jesu giy woni gɨrsə gwale duwa sɨr pii dɨrəwə, ");
INSERT INTO sor_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","me waygɨ da: «Hana mana gɨ ciri dɨ ꞌya dɨrəngə ta di! Anə dara ganda lə da, anə ha ꞌywaa kura gɨ dwe gɨ maw ɗɨbɨ lə, dii mɨn kaw, gun wor ajilaw sɨn̰. Awrɨnaw daa, hane nɨm. ");
INSERT INTO sor_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Me gun ùrnəng, anə banə àl yande dana mo da, waynaw da: “I Aba ciri nin me ùr an̰ju. An̰ji ha cwang gandɨwe kaláng me ca.”» ");
INSERT INTO sor_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Woni gɨrsə gwale duwa nə sɨr di hargɨ me gɨra ha ꞌywaa kura gɨ dwe di gɨ maw ɗɨbɨ lə iche ciri bɨdə bɨrmə lə, me cendi awrɨw daa. ");
INSERT INTO sor_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Nare yab nə ilə ta di ùrgɨ da: «Anə àl i na yande mo? Anə awɨr kura di dana mo?» ");
INSERT INTO sor_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ɨr̰ɨ cendi cogɨ gwale gɨ Jesu wayagɨ gandɨw di mwom da, gɨ kalgɨ ha. ");
INSERT INTO sor_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Cendi hára gɨ kura gɨ dwe di ꞌyàw Jesu me, darbɨw barge day tarɨwə me Jesu ajil dam lə diiyə. ");
INSERT INTO sor_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Nare nan̰ da, darbɨ barge day dodə bɨrmə dalawə, me nə mɨn da, basɨ day baje baje nə bɨ̀ra nə cendi sabagɨ bam ta di me. ");
INSERT INTO sor_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Nare woni hára pii Jesu dɨrəwə me woni pama tarɨw me da, sojɨ day r̰ur̰u ba da: «Sumi gɨ ꞌwaga i Mãr̰ĩ duwa! Kal Aba ciri gɨ Mãr̰ĩ biynəw an̰ju gɨ hára gɨ sumɨw di bɨw dɨwə, biynəw bɨw dɨwə! ");
INSERT INTO sor_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Kal Mãr̰ĩ biynə busɨ dwãr̰ĩ dɨ hára di dɨdə, i dwãr̰ĩ dɨnə mwágɨrandɨ gɨ Dabid duwa. Sumi gɨ ꞌwaga i Mãr̰ĩ gaba dama daa cog duwa.» ");
INSERT INTO sor_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ɨr̰ɨ Jesu yala mana gɨ Jursalem me gandɨ ha kulu gaba bwasa Mãr̰ĩyə. An̰ji yərbɨ tulbəw tulbəw bam pad mwom da, an̰ji ha dara hára Betani gɨ woni gɨrsə gwale duwa nə mwaj dii sɨr di, dara dawa ꞌyen̰ye ɗɨm. ");
INSERT INTO sor_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Sanga dɨra da, cendi so kal Betani bam mwom da, Jesu cherni àlɨwe. ");
INSERT INTO sor_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Mwom da, an̰ji yər dwaga alə hən̰ bajadɨ kubə ladɨ me, ya yara gaa yàa dɨra ba ilə mo. Mana gɨ ba a gɨra dwaga di gɨndɨdɨ lə ib da, yər i bajadɨ mɨra, dara i wála gɨnə dwaga dɨra gaba yàa bədə sɨn̰. ");
INSERT INTO sor_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Mwom da, Jesu sɨrgɨ dwaga di ba da: «Caga ka da, də ha yàa ɗang bədə bɨr̰ɨn̰! Gun mɨn kaw, ha ꞌywaa yàa diya wama bədə ɗɨm!» Me woni gɨrsə gwale duwa di doy gwale gɨ ta di. ");
INSERT INTO sor_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ɨr̰ɨ Jesu day gɨ nə woni gɨrsə gwale duwa cwara yala Jursalem bi ɗɨm. Jesu gandɨ ha ciri dwar̰ɨ dɨ kulu gaba bwasa Mãr̰ĩ ilə di. Mana gɨ ta lə di, an̰ji yər nare woni kɨlə mani bam me woni kɨlə me ilə, me an̰ji so ilə ꞌywaragɨ lə. An̰ji togdɨgɨ woni kɨlanga gursɨ tabɨl day bam me, woni kɨlə kogəl day bam da, an̰ji lesɨrɨgɨ gagege day bam me ca. ");
INSERT INTO sor_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Me an̰ji kal gun mɨn kaw, u mani di cilangɨ nɨm bədə. ");
INSERT INTO sor_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ɨr̰ɨ an̰ji ilə gɨləgɨ nare maniyə me waygɨ ba da: «Ɓag da, Mãr̰ĩ way mana gɨ Maktubu duwa lə ba da: “Gɨ ha ꞌwaga kulu ni di ba i kulu gaba amsa Mãr̰ĩ gɨnə nare nə gɨndəgɨ jiga jiga pad day.” Me ꞌyeni dan da, anə cow dan mana gaba budə gɨnə miidi day.» ");
INSERT INTO sor_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Woni bwasa Mãr̰ĩ gechide day me woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa me doy gwale gɨ ta di me kan̰jɨ bɨrmə ba gɨ ha àla i man dara ꞌyáa gɨ Jesu di mo? Cendi lán̰ɨwe dara gɨlə duwa gɨ mani di ɨndər nare di dusɨrəgɨ lə nan̰e. ");
INSERT INTO sor_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Gɨ turgɨ dawa ɗwanda dɨra lə da, Jesu day gɨ nə woni gɨrsə gwale duwa dɨmgɨ bam ciri dɨ Jursalemmə di. ");
INSERT INTO sor_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Sanga gɨ jomni dɨra da, cendi ha jə̀ bɨrmə lə me yər dwaga dɨ ta di dama lə, me tandi woy bam bɨr̰ɨn̰ ya sabɨradɨ lə ced. ");
INSERT INTO sor_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Piyer dusɨw guw dara mani nə pii àlal di, me wayɨw Jesu da: «Aba gɨlənin mani, yər dwaga dɨ tanga mə sɨrgɨdɨ di cor woy bam bɨr̰ɨn̰.» ");
INSERT INTO sor_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Mwom da, Jesu waygɨ woni gɨrsə gwale duwa ba da: «Kalna dusɨrəng Mãr̰ĩ dɨwə! ");
INSERT INTO sor_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Dwayna, nə wayang i gwale sɨw: Mana gɨ gun waynadɨ kur̰a dɨ ta di ba biyarna mana gɨ ka lə cɨmnə daa hana ɨndarna kuray gɨ geche dalawə, me an̰ji gagɨna gwale dusɨwə bədə, me kalna dusɨw Mãr̰ĩ dɨwə dara gwale gɨ ta di ba ha àlala le da, Mãr̰ĩ ha àlawe. ");
INSERT INTO sor_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","I dara ta di me nə wayang nɨm: Mani nə we we nə anə amsɨna Mãr̰ĩ dara ba àlnang da, kalna dusɨrəng dɨwə dara an̰ji ba ꞌyàng mani nə ta di le ɗɨm, me Mãr̰ĩ ha ꞌyàng gandagɨ le. ");
INSERT INTO sor_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Me mana gɨ anə ɗɨbɨnə daa dara amsa Mãr̰ĩ me anə ina gɨ gwale lə gɨ gun da, kalna dusɨrəng hɨlalna dɨwə do me, Abɨrang gɨ Mãr̰ĩ gaba dama daa di kaw, ha kala dusɨw hɨlala àcn̰a dan dɨwə sɨn̰.  ");
INSERT INTO sor_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Me anə kalna dusɨrəng hɨlalna kwandang àcn̰a day dɨwə bədə da, Abɨrang gɨ Mãr̰ĩ gaba dama daa di kaw, ha kala dusɨw hɨlala àcn̰a dan dɨwə bədə me ca.» ");
INSERT INTO sor_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jesu day gɨ nə woni gɨrsə gwale duwa cwaragɨ hára Jursalem bi. Mana gɨ Jesu kɨdɨbər mana gɨ ciri dwar̰ɨ dɨ kulu gaba bwasa Mãr̰ĩ ilə di da, woni bwasa Mãr̰ĩ gechide day me, woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa me, gechide nənə nare nə Juwib day nə ɗang me, chidɨbə hára Jesu sɨwə ib ib. ");
INSERT INTO sor_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ɨr̰ɨ cendi ùrbɨw ba da: «I gɨ dwana dɨ we me, mə àl nɨm gɨ mani nə ta di mo? I wi me ꞌyàm bɨrmə me, mə àl nɨm gɨ mani nə ta di mo?» ");
INSERT INTO sor_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesu cogɨ lə diiyə ba da: «Nə ha ùrəng gwale mɨn tenene ka. Cwanan lə diiyə do me ɨndi di kaw, nə ha wayang dwana ni dɨ nə àl gɨ mani nə ta di sɨn̰. ");
INSERT INTO sor_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","I wi me giyə Jã gɨra àlgɨ nare batem di mo? I Mãr̰ĩ, labaa i nare nə gɨsɨgədə mo? Cwanan lə diiyə.» ");
INSERT INTO sor_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Mwom da, cendi ilə wajɨba gwale bulə dayyə ba da: «Də cwanaw ɨnda lə diiyə ba i Mãr̰ĩ da, an̰ji ha wayandɨ ba dɨ yə̀ng gwale gɨ Jã wayɨw di bədə, dana mo? ");
INSERT INTO sor_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Me də waynang ba i nare nə gɨsɨgədə da, i na gaa ha àlandɨ som?» Cendi lán̰gɨ i nare nə gɨr̰e di dara nare nə pad di ɨrɨm dara Jã di ba i aba cɨmə Mãr̰ĩ bɨw ꞌyang. ");
INSERT INTO sor_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Mwom da, cendi cor wayɨw Jesu di da: «Nə ꞌwocn̰ɨnin bədə.» Me an̰ji waygɨ da: «Yande da, ɨndi kaw, nə ha wayang dwana ni dɨ nə àl nɨm gɨ mani nə ta di bədə me ca.» ");
INSERT INTO sor_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ɨr̰ɨ Jesu so ilə wayagɨ gechide nənə nare nə Juwib day di gwale gɨ diri ba da: «Abe mɨn daga duwa ilə, me an̰ji ɗɨlbɨ yabɨr̰a lə, me jə̀ daga di daa me ca. An̰ji ɗangr̰ɨ mana gaba chidə gɨ yabɨr̰a nimi duwa ilə me, aw mana hoo daa dara ɗɨbə gamaw nɨm me ca. Targɨn̰ ɗang da, an̰ji kalgɨ daga di woni àla giyə ɨsɨragɨ lə, me ya mɨjəniyə. ");
INSERT INTO sor_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Mana gɨ wála gaba cəə yabɨr̰a yàa duwa nem mwom da, aba ciri di giygɨ woni àla giyə gɨnə yabɨr̰a di kwaya duwa mɨn, dara cendi ba junəw yabɨr̰a yàa duwa di me ba kalna day me ca. ");
INSERT INTO sor_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ɨr̰ɨ cendi yɨ kwaya di gobɨw me ꞌyorɨw daa ɨsəw pəgɨn̰. ");
INSERT INTO sor_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Mwom da, aba ciri di cor giygɨ kwaya gɨ ɗang bi. An̰ji gɨ ta di kaw, cendi gobɨ dɨw me àlɨw àcn̰ me ca. ");
INSERT INTO sor_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Aba ciri giygɨ gun gɨ ɗang kaw, cendi yɨw ꞌyəw bam, ɨr̰ɨ an̰ji kɨjɨ kòy nan̰ ɗang bi kaw, cendi gobɨ nə yab me ꞌyə nə yab bam me ca. ");
INSERT INTO sor_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Kwaya di, mɨn kaw, worɨw lə bədə. Ka da, wor i gorndɨw gɨ nudəw gɨ mɨn tenene gɨ dusɨw ùrɨw nan̰ di ɗɨm. Me an̰ji giygɨ gandɨw targɨn̰, me way dusɨwə bá, ka da, cendi ba ha yə̀w jawe som. ");
INSERT INTO sor_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ɨr̰ɨ woni àla giyə gɨnə yabɨr̰a di wajɨ gwale bulə dayyə ba da: “Ta di me i aba wama dɨba duwa sanga di! Hane ꞌyánandɨ gandɨw bam, me dɨba di ha warandɨ ɨnda.” ");
INSERT INTO sor_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Mwom da, cendi yɨ gorndɨw di ꞌyəw bam me àsɨ kumbɨ duwa mana gɨ daga gɨnə yabɨr̰a duwa di tarɨwə bam iche.» ");
INSERT INTO sor_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Mana gɨ ta lə da, Jesu ùr nare woni dwaya gwale duwa ba da: «Yande da, aba ciri gɨnə yabɨr̰a di ha àla i man mo? An̰ji hára gɨ sɨw duwa me, ha ꞌyáa woni àla giyə gɨnə yabɨr̰a nə ta di bam, me ha ꞌwoo daga di ꞌyàgɨ́ nə ɗang ɨsɨragɨ lə. ");
INSERT INTO sor_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Anə āsɨ gwale gɨ gɨ jangɨw mana gɨ Maktubu dɨnə Mãr̰ĩyə di bədə mo? Gɨ jangɨ ba da: Kur̰a dɨ woni awa kululi gɨn̰dɨ bam di, yala gɨdɨ kur̰a sɨdɨ dɨ idɨ yəə kulu di daa tandi. ");
INSERT INTO sor_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","I Aba ciri gɨ Mãr̰ĩ me àl mani nə ta di an̰ju. I mani nə lade nan̰ nə ɗoy dɨdəndɨ bam me Mãr̰ĩ àlgɨ, me dɨ yarang gandagɨ gɨ dɨrəndɨ ta di.» ");
INSERT INTO sor_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Gechide nənə nare nə Juwib day di ꞌwocn̰ com dara Jesu ba way gwale gɨ diri gɨ ta di i dara daragɨ cendi. Ta di me cendi kan̰jɨ bɨrmə dara ba gɨ yɨ nɨm gɨ Jesu. Ɨr̰ɨ cendi lán̰gɨ i nare nə gɨr̰e di, me borgɨ yá me kalɨw ɗi. ");
INSERT INTO sor_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Targɨn̰ ɗang da, gechide nənə nare nə Juwib day ùr ba gɨ gɨrsə Jesu ba gɨ doy gwale bɨwə me ba gɨ yɨw nɨm. Ta di me cendi giyɨw nare nə yab nə gɨ ꞌwogɨgɨ Parise me, nare nə yab nənə dole gɨ Erod duwa me. ");
INSERT INTO sor_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Mwom da, cendi gɨra ùrɨw ba da: «Aba gɨlənin mani, nə ꞌwocn̰ɨninne dara mə i aba waya gwale sɨw dɨban lán̰aw gɨ gun, dara dolɨm gɨ nare nə ladɨbe bədə me ca. Me mə gɨlgɨ nare gwale sɨw gɨ Mãr̰ĩ ùr nare ba àlna di gɨ bɨrmə duwa. Waynin daa sɨn̰! Ɓag da, ꞌywagaw gɨ dole gɨ geche gɨ Rom lombo da, ladɨ le mo? Də ꞌyogɨw ɨnda, labaa dɨ ꞌyogɨw ɨnda bədə mo?» ");
INSERT INTO sor_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Me Jesu ꞌwocn̰ com dara cendi i nare woni waya gwale gɨ bɨdəgɨ mɨra me dusɨrəgɨ i jiga, mwom da, an̰ji waygɨ ba da: «I dara na me anə ùrɨn gwale gaba twan nɨm yande mo? Unɨn gursɨ dɨ chile dɨ deniye mɨn, hane nɨm ꞌyànan, nə ùr ba nə yərdɨ le.» ");
INSERT INTO sor_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Cendi ꞌwów chile di gɨra nɨm ꞌyàw mwom da, an̰ji ùrgɨ ba da: «Mana gɨ chile dɨ ka di sɨdə da, i wi dɨw me sumɨw me ilə mo?» Cendi wayɨw ba i dole gɨ geche gɨ Rom. ");
INSERT INTO sor_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yande da, Jesu waygɨ da: «Mani nənə dole duwa da, ꞌyànaw dole di, me mani nənə Mãr̰ĩ duwa kaw, ꞌyànaw Mãr̰ĩ di le me ca.» Ɨr̰ɨ Jesu gwale duwa di ꞌyàgɨ́ ɨrmə nan̰e. ");
INSERT INTO sor_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Targɨn̰ ɗang da, nare nə mɨn nə gɨ ꞌwogɨgɨ Saduse hára ꞌyo Jesu. Cendi ɨrɨm day ba nare nə mare da, Mãr̰ĩ ba ha dɨməgɨ daa munɨ lə bədə bɨr̰ɨn̰. Me cendi ùr Jesu ba da: ");
INSERT INTO sor_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Aba gɨlənin mani, yər, Moyis jangɨndɨ mana gɨ bii ɨnda gɨ ꞌwoo lə, ba abe gɨ ba unə deme me ba yàna gandɨdɨ dwe bədə me ba marna bam da, chendɨw ba unə dyaməw di, me ba yànaw gɨ chendɨw gɨ mar bam di dine. ");
INSERT INTO sor_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Caga da, doy: Wála mɨn, chebni dɨ nare wurgɨsubu ilə. Chandragɨ gɨ geche u deme me mar bam dɨban yàa gɨ dine. ");
INSERT INTO sor_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Gɨ aba dii sɨrrə u aba mara di dyaməw, me an̰ji kaw, mar bam dɨban yàa gandɨdɨ dine me ca. Mani nə ta di àlal yande bi gɨ aba dii subu lə di me, ");
INSERT INTO sor_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","nə wor di me ca. Chamre nə wurgɨsubu di margɨ bam pad dayyə pad dɨban yàa gandɨdɨ dine. Taragɨ lə da, deme di kaw, wála dɨra nem, me tandi mar bam me ca. ");
INSERT INTO sor_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Yande da, wála gɨ Mãr̰ĩ ha dɨmə gɨ nare nə mare daa munɨ lə da, tandi ha ꞌya i gɨ we dyaməw mo? Dara cendi nə pad ta di, tanga i tɨrgadɨ.» ");
INSERT INTO sor_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Me Jesu waygɨ da: «ꞌYeni da, dɨdəng nol i bam! I dara anə ꞌwocn̰ Maktubu dɨnə Mãr̰ĩ duwa bədə me dwana duwa di bədə me ca. ");
INSERT INTO sor_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Yarna, ɗan̰ wála gɨ Mãr̰ĩ ha dɨmə gɨ nare daa munɨ lə da, abje day gɨ nə namde ha laya sɨdəgɨ bədə me cendi ha dama i ya Paja nənə Mãr̰ĩ duwa nə daa de, alə daa mana gɨ Mãr̰ĩ tulɨwə. ");
INSERT INTO sor_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Gwale gɨnə nare nə mare dɨmə day gɨ daa munɨ lə da, anə āsa mana gɨ maktubu dɨnə Moyis duwa lə di bədə mo? Ɨrmɨnə gwale gɨnə habda gɨ ɗwag ɗwag gɨ dùwa ꞌyo dɨwə di. Mana gɨ ta lə di me Mãr̰ĩ wayɨw Moyis ba da: “Nə i Mãr̰ĩ gɨnəAbɨrahamduwa me, gɨnəIsakduwa me, gɨnəJakobduwa me ca.” ");
INSERT INTO sor_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Mãr̰ĩ di, i Mãr̰ĩ gɨnə nare nə mare day bədə, me i gɨnə nare nə dam bɨ̀ra day. I sɨdɨ, dɨdəng nol i bam bɨr̰ɨn̰.» ");
INSERT INTO sor_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Aba gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa mɨn doy gwale gɨ cendi gagɨw di, me an̰ji yər dara Jesu cogɨ lə diiyə ladɨ me ca. Mwom da, an̰ji chidɨ Jesu sɨwə me ùrɨw ba da: «Mana gɨ bii ɨnda gɨ ꞌwoo lə da, gɨ we me ɗoy kwandaw bam pad di mo?» ");
INSERT INTO sor_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ɨr̰ɨ Jesu cow lə diiyə ba da: «Bii gɨ ꞌwoo gɨ ɗoy kwandaw bam pad di me i ta: “Dwayna, ꞌyeni nare nəIsrayel, Aba ciri gɨ Mãr̰ĩ di, i Mãr̰ĩ ɨnda. Aba ciri gɨ Mãr̰ĩ di i an̰ju mɨn tenene. ");
INSERT INTO sor_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Mwom da, mə ha ùrə Aba ciri gɨ Mãr̰ĩ dɨma gɨ dusɨm mɨn, gɨ dúndɨm pad, gɨ ɨrmə dɨma pad me gɨ dwana dɨma pad me ca.” ");
INSERT INTO sor_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Me targɨn̰ ɗang da: “Mə ha ùrə jam gun ya sɨm dɨma gang de.” Bii gɨ ꞌwoo kwandaw dwar̰agɨ lə gaba ɗwaya gɨ sɨr ta di bam da, ilə bədə.» ");
INSERT INTO sor_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Mwom da, aba gɨlə bii gɨ ꞌwoo wayɨw Jesu ba da: «Ladɨ nan̰e, aba gɨlənin mani, mə way i sɨdɨ. Aba ciri gɨ Mãr̰ĩ da, i an̰ju mɨn tenene, gɨ ɗang ilə bədə. ");
INSERT INTO sor_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Yande da, ùrɨw gɨ dusɨm dɨ mɨn, gɨ ɨrmə dɨma pad, gɨ dwana dɨma pad me, ùrə gɨ jam gun ya sɨm dɨma de me ca da, ladɨ ɗoy ulə gɨ mwagɨna bwasa gɨ Mãr̰ĩ bam me, ɗoy àlaw gɨ Mãr̰ĩ sarga dɨ ɗang pad me di bam.» ");
INSERT INTO sor_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesu ꞌwocn̰ dara an̰ji cow i gwale gɨ lade lə diiyə mwom da, cor wayɨw ba da: «Wor i ib mə ha kala Mãr̰ĩ lama dwãr̰ĩ duwa dɨmmə.» Targɨn̰ ɗang da, cendi lán̰ye, gun mɨn kaw, nem ùrɨw gwale gɨ ɗang bədə ɗɨm. ");
INSERT INTO sor_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Me mana gɨ Jesu ilə gɨlə mani mana gɨ ciri dwar̰ɨ dɨ kulu gaba bwasa Mãr̰ĩ ilə lə da, an̰ji ùr nare di ba da: «I man me woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa way ba Dole gɨ Mãr̰ĩ biyəw gɨ Kris di, ba i dole gɨ Dabid mwàw mo? ");
INSERT INTO sor_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dabid gɨ sɨw duwa gang kaw, Dúndi dɨnə Mãr̰ĩ duwa nogɨ gɨndɨw daa me an̰ji way daa pɨden̰yə ba da: “Aba ciri gɨ Mãr̰ĩ wayɨw aba ciri ni ba da: Hare, mə dam ɨsən gɨ abeyə bɨraa nə ha bwam woni mar̰ande dɨma dodə gɨdammə bá do.” ");
INSERT INTO sor_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dabid sɨw duwa gang ꞌwagɨna Dole gɨ Mãr̰ĩ biyəw gɨ Kris di ba i aba ciri duwa da, dana me gɨ ꞌwogɨ Kris di ba i Dabid mwàw ɗang tugu mo?» Nare nə gɨr̰e nan̰ ilə dwaya Jesu gwale duwa gɨ sii ꞌywala. ");
INSERT INTO sor_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Mana gɨ gɨlə duwa gɨ maniyə da, an̰ji way da: «Àsɨna angal danne! Àlna mani ya woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa ba gɨ àl nɨm de bədə. Cendi ùr hurba gɨ barge gɨ gechide gaba sumi kɨdɨbər nɨm me, ùr ba gɨ àlnagɨ labiya gɨ horɨmbə nare dɨrəgɨ lə mana gaba dayara lə me. ");
INSERT INTO sor_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Cendi ùr dama gɨ mana gaba sumiyə kululi woni amsa Mãr̰ĩyə, me wama gɨ maniyə kaw, cendi ùr i mana gaba sumi me ca. ");
INSERT INTO sor_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Cendi chəbɨ namde nə wambɨ mani day bam, me ɗang da, cendi ɗɨbɨnə dara amsa gɨ Mãr̰ĩ da, amsɨ bɨraa bɨraa bɨraa dara gɨlə gɨ sɨdəgɨ ba gɨ i nə ladɨbe cendi. Me sanga da, sariya day ha wama nan̰e.» ");
INSERT INTO sor_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Mana gɨ kɨrə ciri dwar̰ɨ dɨ kulu gaba bwasa Mãr̰ĩ ilə da, mana mɨn gɨ nare hára gɨ gursɨ day àl gɨ dwani gɨ Mãr̰ĩ ilə. Me Jesu dam co dɨrəw me ilə yara gɨ mani nə cendi ilə àlagɨ̀ lə di. Nare nan̰ woni ꞌywaa mani da, ꞌya gursɨ day ꞌyarbar. ");
INSERT INTO sor_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ɨr̰ɨ deme dɨ wambɨ dɨ i bugɨr hára dɨra ꞌya chile sɨr dɨ nem àla gɨ mani bədə. ");
INSERT INTO sor_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Mwom da, Jesu ꞌwogɨ woni gɨrsə gwale duwa me waygɨ ba da: «Dwayna, nə wayang i gwale sɨw: Deme dɨ wambɨ dɨ bugɨr dɨ ta di bo gursɨ dɨra ɗoy nare day di bam pad. ");
INSERT INTO sor_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Nə way yande dara nare di, i gursɨ day dɨ wor dodə sɨr̰ɨgɨm me, cendi hára ꞌya sɨn̰. Me tandi da, mani pad jaldɨ le, me cor ꞌya i mani pad nə ilə kɨrə dɨra lə dara ɨsə gɨ sɨdɨ di bam.» ");
INSERT INTO sor_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Mana gɨ Jesu ganda bam iche ciri dwar̰ɨ dɨ kulu gaba bwasa Mãr̰ĩ ilə di da, aba gɨrsə gwale duwa gɨ mɨn wayɨw ba da: «Aba gɨlənin mani, yər kur̰a dɨ ladɨbe dɨ gechide dɨ gɨ aw gɨ ciri dɨ ka di de! Ciri di, gɨ awdɨ ladɨ nan̰e!» ");
INSERT INTO sor_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ɨr̰ɨ Jesu wayɨw da: «Əw, me ciri dɨ geche dɨ mə yərdɨ ta di, kur̰a dɨ gɨ awdɨ nɨm di mɨn tenene kaw, sanga ha wara lə kondɨdɨ dɨdə bədə. Mani pad nə i ta di ha myandara i bam.» ");
INSERT INTO sor_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Mwom da, Jesu ha dama mana gɨ kur̰a dɨ Olib dɨdə me cwaa dɨrəw ɨjɨ kulu gaba bwasa Mãr̰ĩ di. Me Piyer me Jak me Jã me Andɨre me ha ꞌywaw bam tulɨn̰yə hin̰e, me ùrɨw nɨm ba da: ");
INSERT INTO sor_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Waynin daa: I mindi na me mani nə ta di ha àlala mo? I mani na me ha gɨlənin wála day gɨ ba hára lə di ba yala nem ɗɨm di mo?» ");
INSERT INTO sor_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ɨr̰ɨ Jesu waygɨ da: «Àsɨna angal dan ladɨ le! Kalna gun mɨn lamnang bwanang bam bədə! ");
INSERT INTO sor_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Nare nan̰ ha ꞌwoo sumɨn hára nɨm lə me, wi kaw, ha waya ba Dole gɨ Mãr̰ĩ biyəw gɨ Kris di, ba i an̰ju, me cendi ha lama nare nan̰ bwagɨ bam. ");
INSERT INTO sor_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Mana gɨ anə dara dwaya gwale gɨnə say dɨ tuləngə ib me, dɨ mana gɨ hən̰yə gwale dɨra me kaw, kalna àla lán̰a ɗi, dara mani nə ya ta de di ha àlala le bá, ɗɨm da, i dɨr̰ɨn̰a ꞌyan̰a dɨra bədə sɨn̰. ");
INSERT INTO sor_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nare nə wama gɨ ciri dɨ mɨnnə ha swaa jara say gɨ kwandagɨ nə ciri dɨ wama gɨ ɗangə me, dole gɨ mɨn ha jara say gɨ jaw dole gɨ ɗang me ca. Sɨn̰a ha gɨgdara mana lə jiga jiga, me badɨgara dɨ geche kaw, ha ɨndara ciriyə jiga jiga me ca. Wamani gɨ ta di, wun i ya yàa ba jəgdɨ gɨ deme dɨrɨn̰ nə piiyə ta de sɨn̰. ");
INSERT INTO sor_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","ꞌYeni di, àsɨna angal dan ladɨ le! Gɨ ha yɨbəng ꞌyàgɨ́ woni àla sariya nənə nare nə Juwib day ɨsɨragɨ lə, gɨ ha gwabang mana gɨ kululi day woni amsa Mãr̰ĩyə, gɨ ha hára gandang woni wama ciri dɨrəgɨ lə me dolgə dɨrəgɨ lə me dara daran ɨndi. I ta di me anə ha biyəgɨ gɨ gwale gɨ nə wayɨw me mani nə nə àlgɨ di me. ");
INSERT INTO sor_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Dara wála ꞌyan̰a duwa lə da, kal nare nə gɨndəgɨ jiga jiga pad sɨn̰a dɨdə ka dwayna Nõ dɨ lade di le do. ");
INSERT INTO sor_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Me mana gɨ gɨ dara yɨbəng hára gandang ꞌyàgɨ́ woni dwana ɨsɨragɨ lə dara àlang sariya da, kalna hára pii dara gwale gɨ anə ha wayaw di ɗi. Anə gɨra ha waya i gwale gɨ Mãr̰ĩ ha ꞌyàng gandɨw an̰ju, dara gwale gɨ ha ganda bɨdəngə di da, i gɨ dan gɨ sɨdəng bədə, me i gɨ Dúndi dɨnə Mãr̰ĩ duwa dɨra. ");
INSERT INTO sor_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Gun chendɨw duwa gang kaw ha wayagɨ nare woni dwana ba yɨnəw ꞌyánaw bam. Dwe abəw kaw, ha àla gɨ gorndɨw yande dige dige me ca. Dine nə yàa da, ha kɨdə woni mar̰ande gɨ war̰agɨ woni yàgɨ, me cendi ha wayagɨ nare woni dwana ba yɨbɨnəgɨ ꞌyánagɨ bam. ");
INSERT INTO sor_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nare pad ha ɨlənge dara daran ɨndi. Me gun gɨ yɨnə sɨw wàyna kalna dusɨw dɨnnə bɨraa ꞌyan̰a lə da, Mãr̰ĩ ha ꞌyàw bɨlə.» ");
INSERT INTO sor_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«Wála mɨn, anə ha yara mani nə àl ɨn̰ama woni myanda mana bam di ꞌya lə mana gɨ dee cendi ha ꞌya lə bədə. Gun gaba āsa gwale gɨ ta di da, kal a ꞌwacn̰ana gɨndɨw ladɨna! Wála gɨ ta lə da, kal nare nə i mana gɨ wama gɨ Judeyə da, gɨ wana hana daa kur̰a dɨdə. ");
INSERT INTO sor_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Gun gɨ damna daa mana gɨ kulu duwa dɨwə da, a chɨ́nə dodə dara laya gɨ mani nə ilə kulə di bədə ɗɨm. ");
INSERT INTO sor_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Me gun gɨ ina lə bam yiga lə kaw, a cwarnay hane ulay dara laya gɨ barge duwa bədə ɗɨm me ca. ");
INSERT INTO sor_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Wála gɨ ta lə di, owe namde woni gudi gudi me, woni ꞌyàgɨ́ dɨndɨragɨ nãy me! Wamani ha ꞌywagɨ le! ");
INSERT INTO sor_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Amsɨna Mãr̰ĩ dara kal mani nə ta di hane wála gɨ urniyə bədə. ");
INSERT INTO sor_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Dara wála gɨ ta lə da, ha ꞌya i gɨlə gɨ dɨrɨn̰ gɨ geche gɨ dii mɨn kaw, gun ꞌyow bədə mana gɨ ɓɨgden̰ gɨ Mãr̰ĩ bo gɨ mani pad bɨraa laba. Ɗan̰ kaw, gɨlə gɨ dɨrɨn̰ gɨ ya ta de ha ꞌya lə ɗang bədə bɨr̰ɨn̰. ");
INSERT INTO sor_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","I sɨdɨ, wála gaba gɨlə dɨrɨn̰ gɨ ta lə da, Aba ciri gɨ Mãr̰ĩ di dee ɨrmɨnə me junə wála gɨ yab bwana bam bədə da, gun mɨn gɨ dee ha ꞌywaa bɨlə duwa da, ilə bədə. Me an̰ji ɨrmə dara ba a ha joo wála gɨ yab di bam ɗɨm dara nare nə an̰ji an̰jiragɨ dara ba ina i duwa di. ");
INSERT INTO sor_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Wála gɨ ta lə da, nare ha wayang “Yarna, Dole gɨ Mãr̰ĩ biyəw gɨ Kris di, i ka”, labaa “Yarna, Dole gɨ Mãr̰ĩ biyəw gɨ Kris di, ilə ta.” Gun gɨ waynang yande da, yɨnə gwale duwa di bədə. ");
INSERT INTO sor_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Dara nare woni kulagɨ ha ɓɨr̰ɨn̰ə daa nan̰e. Nə mɨn da, ha wayang Dole gɨ Mãr̰ĩ biyəw gɨ Kris di, ba i cendi, me i kulagɨ. Nə yab da, ha wayang ba gɨ i woni cɨmə Mãr̰ĩ bɨw, me i kulagɨ. Cendi ha àla mani nə dan̰a me mani nə ɗoy nare dɨdəgɨ bam me dara lama gɨ nare. Cendi dee ꞌywana bɨrmə da, ha lama nare nə Mãr̰ĩ an̰jirɨgɨ di le me ca. ");
INSERT INTO sor_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Yande da, ꞌyeni di, àsɨna angal dan ladɨ le. Nə wayang daa pii dara mani pad nə hára lə di ɗɨm.» ");
INSERT INTO sor_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«Me wála gɨ ta lə da, gɨlə gɨ dɨrɨn̰ gɨ ta di tarɨwə da, mana ha gɨdə dilɨm kɨdab dara dawa ha aa bədə me, duru kaw, ha ácn̰a mana bədə me, ");
INSERT INTO sor_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","dechu kaw, ha bwara dodə, me mani nə daa pad woni dwana kaw, ha gɨgdara daa me ca. ");
INSERT INTO sor_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Mana gɨ ta lə dog, nare ha yara Gun gorndɨw di chə́ə lə daa siyaya dalawə hára nɨm dodə gɨ ꞌywagda duwa gɨ nan̰ me ca. ");
INSERT INTO sor_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","An̰ji ha kɨjə Paja nənə Mãr̰ĩ duwa nə daa mana lə pad dara dáya gɨ nare nə an̰ji an̰jiragɨ di dodə mana mɨn, so mana gɨ tulɨn̰ dɨ jomniyə me, dɨ turgɨ lə me, ɨsay gɨ abeyə me, ɨsay gɨ jeleyə me ca. ");
INSERT INTO sor_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ɨrmɨnə gwale gɨnə dwaga dɨra yarna sɨn̰. Mana gɨ gangr̰adɨ nə dine dara kubə daa me bajadɨ cwarna kulaje me da, anə ꞌwocn̰ dara marsɨni ba i ib ɗɨm. ");
INSERT INTO sor_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Cwara gɨnə Gun gorndɨw di kaw, ha wunə i yande di me ca: Mana gɨ anə dara yara mani nə dee nə wayang gwale day pii di dara àlala da, ɨrmɨnə dara Gun gorndɨw di yala lə ib ɗɨm, an̰ji ilə ciri bɨdə. ");
INSERT INTO sor_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Dwayna, nə wayang i gwale sɨw: Mani nə pad ta di dara àlala da, nare nə caga ka di ha mara bam pad pii dɨrəgɨ lə bədə sɨn̰. ");
INSERT INTO sor_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Daa me, sɨn̰a me, ha myandara i bam me gwale ni da, ha myandara bam bədə bɨr̰ɨn̰. ");
INSERT INTO sor_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Mani nə ta di, wála day labaa dawa day dɨ cendi ha àlala lə da, gun mɨn kaw, ꞌwocn̰ɨgɨ bədə. Paja nənə Mãr̰ĩ duwa nə daa kaw, ꞌwocn̰ɨgɨ bədə, me Mãr̰ĩ gorndɨw kaw, ꞌwocn̰ɨgɨ bədə me ca. I Abəw gɨ Mãr̰ĩ mɨn tenene me ꞌwocn̰ɨgɨ an̰ju. ");
INSERT INTO sor_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Àsɨna angal dan ladɨ le me damna dɨrəng bɨ̀ra, dara dawa dɨ ta di hára dɨra da, anə ꞌwocn̰ɨdɨ bədə. ");
INSERT INTO sor_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Mani di ha àlala wunə i ya abe mɨn gɨ so ha mɨjəniyə ta de. An̰ji kalgɨ kòy duwa ciri di ɨsɨragɨ lə me ꞌyàgɨ́ wi kaw, giyə duwa, giyə duwa, me an̰ji wayɨw aba gama ciri bɨdɨ ba damna dɨrəw bɨ̀ra jang me ca. ");
INSERT INTO sor_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Yande da, damna dɨrəng bɨ̀ra jang, dara dawa dɨ aba ciri di cwara nɨm di da, anə ꞌwocn̰ɨdɨ bədə. Gaa ha ꞌya gɨ turgɨ, labaa gɨ changa dwar̰ɨ, labaa gɨray hɨrdə duwa lə, labaa gɨ manapɨr som. ");
INSERT INTO sor_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mana gɨ an̰ji cwarnay jisgɨ yande da, kal an̰ji ꞌywanang ꞌya gɨ nuniyə bədə. ");
INSERT INTO sor_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Gwale gɨ nə wayɨw ka di, nə wayang i ꞌyeni di pad: Damna dɨrəng bɨ̀ra jang!» ");
INSERT INTO sor_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Wor wála sɨr da, i wála gaba àla sii ꞌywala gɨ kɨrara gɨ daa kwaynaniyə gɨnə nare nə Juwib day me, sii ꞌywala gɨnə mapa gɨ dɨban musbu me ca. Woni bwasa Mãr̰ĩ gechide day me woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa me kan̰jɨ kojɨgə dara ba gɨ yɨ gɨ Jesu ꞌyəw nɨm. ");
INSERT INTO sor_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Dara cendi way ba da: «Ladni duwa da, yɨnəndɨ gandɨw wála gaba àla sii ꞌywala lə ɗən̰ bədə, dara gaa nare di ha swaa ganandɨ gɨ gwale som.» ");
INSERT INTO sor_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Mana gɨ ta lə da, Jesu ilə ciri dɨ Betani, mana gɨ kɨrə nə abe mɨn gɨ gɨ ꞌwogɨw Simõ gaba cagɨmmə. Me mana gɨ Jesu ilə wama maniyə da, deme mɨn hára yəə mɨrda gɨ lade ɨsədɨ lə. Mɨrda gɨ ta di, swani gɨ lade gɨ habda gɨ bii ꞌyol nan̰ me kili duwa kaw, wom nan̰ me ilə dwalɨn̰yə. Tandi ɓol mɨrda di bɨw bam me tidɨrɨw Jesu swani di dɨwə. ");
INSERT INTO sor_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ɨr̰ɨ nare nə mɨn nə ilə ta di, dusɨrəgɨ nagɨ le me wajɨ gwale bulə dayyə ba da: «Ta di da, ladni duwa da, i na lə mo? Tandi mendɨ swani gɨ lade di bam! ");
INSERT INTO sor_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Swani gɨ ta di, dee gɨ kɨlnəw bam da, gursɨ duwa nem dɨnə aba àla giyə aliya mɨn dalawə. Ta di, dee də ɨsɨgɨ ɨnda nare nə bugɨr gursɨ dɨ ta di ɗena, ladɨ bədə mo?» Me cendi ilə n̰ama deme di lə. ");
INSERT INTO sor_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Me Jesu waygɨ da: «Kalna deme di mana mɨn! Dana me anə jibadɨ mo? Mani nə tandi àl dara daran ɨndi ta di, i giyə gɨ lade. ");
INSERT INTO sor_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Dwayna, nare nə bugɨr da, ilə gandang gɨ wála wála, anə ha àla gandagɨ ladni wála gɨ dɨrəng ùr. Me ɨndi da, anə ha ꞌywan targɨn̰ ɗang bədə. ");
INSERT INTO sor_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Tandi àl i mani nə tandi nem àlagɨ̀. Tandi tidɨrɨn swani sɨnnə bam pii ta di, tandi ɗangr̰ɨ i sɨn pii do me gɨ ha mõn sɨn̰. ");
INSERT INTO sor_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Dwayna, nə wayang i gwale sɨw: Mana gɨ gɨ ha waya Nõ dɨ lade di sɨn̰a gɨndɨdɨ lə jiga jiga pad ta di da, deme di kaw, gɨ ha waya gwale dɨra le dara mani nə tandi àl ta di, me nare dusɨrəgɨ ha ɨrmə dɨdə bi bi me ca.» ");
INSERT INTO sor_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Mwom da, Judas Iskariyot gɨ i woni gɨrsə gwale gɨnə Jesu duwanə mwaj dii sɨr gun day gɨ mɨn, ha wayagɨ woni bwasa Mãr̰ĩ gechide day ba a ha ꞌyàgɨ́ Jesu ɨsɨragɨ lə me cendi ba yɨnəw. ");
INSERT INTO sor_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Mana gɨ cendi doy yande da, sɨdəgɨ ꞌyolgɨ nan̰e me, ɨrmɨw ba gɨ ha ꞌyàw gursɨ. Mwom da, Judas di kan̰jɨ bɨrmə dara ꞌyàgɨ́ gɨ Jesu di ɨsɨragɨ lə. ");
INSERT INTO sor_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Wála gɨ dɨrɨn̰ nə piiyə gɨnə sii ꞌywala gɨnə mapa gɨ dɨban musbu da, i wála gɨ gɨ ꞌyəgdɨ i gəgɨr̰ɨn̰je nə dine bosɨ nɨm gɨ sii ꞌywala gɨ kɨrara gɨ daa kwaynaniyə di. Mwom da, woni gɨrsə gwale gɨnə Jesu duwaùrɨw da: «Mə ùr ba nə hananin àlnam mani nə wama woni sii ꞌywala gɨnə kɨrara gɨ daa kwaynaniyə di i we mo?» ");
INSERT INTO sor_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Mwom da, Jesu giy woni gɨrsə gwale duwa nə sɨr pii me waygɨ da: «Hana mana gɨ ciri dɨ Jursalemmə. Gun mɨn go nimi pɨr̰ɨmmə hára sawa dɨrəng daa. Pamna tarɨw. ");
INSERT INTO sor_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ciri dɨ an̰ji gandɨna hana lə da, waynaw aba ciri di da: “Aba gɨlənin mani wayanin ba nə ùrnəmnin bá, kulu gɨ ba a ha wama mani woni sii ꞌywala gɨnə kɨrara gɨ daa, day gɨ nə woni gɨrsə gwale duwa lə di, ba i we mo?” ");
INSERT INTO sor_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Mana gɨ ciri dɨ ta lə di da,  kulu mɨn gɨ gɨ aw daa jaw dɨwə ilə. Aba ciri di ha gɨləng gandɨw. I kulu gɨ ɓɨle me gɨ ɗangr̰ɨ mani pad ilə ɗɨm. I mana gɨ ta lə me, anə ha àlandɨ mani nə wama woni sii ꞌywala di lə.» ");
INSERT INTO sor_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ɨr̰ɨ woni gɨrsə gwale gɨnə Jesu duwa di hargɨ me gɨrgɨ Jursalem di me ha ꞌywaa mani di lə ya Jesu ba wayagɨ nɨm de, me àla mani nə wama woni sii ꞌywala di. ");
INSERT INTO sor_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Gɨ turgɨ dawa ɗwanda dɨra lə da, Jesu hára gɨ nə woni gɨrsə gwale duwa nə mwaj dii sɨr di. ");
INSERT INTO sor_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Cendi dam dodə dara mani nə wama di me ilə wamagɨ lə mwom da, Jesu waygɨ da: «Dwayna, nə wayang i gwale sɨw: ꞌYeni nə anə ilə wama gandɨn mani ta di, gun mɨn dwar̰angə ha ꞌyàn woni mar̰ande ni ɨsɨragɨ lə.» ");
INSERT INTO sor_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Woni gɨrsə gwale duwa di, lán̰a yala àlgɨ, me ùrbɨ Jesu mɨn mɨn ba da: «Gaa i ɨndi mo? Gaa i ɨndi mo?» ");
INSERT INTO sor_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesu waygɨ ba da: «I gun dan mɨn dwar̰angə ꞌyeni woni gɨrsə gwale ni nə mwaj dii sɨr di gaba hura ɨsəw dása lə gandɨn ta di. ");
INSERT INTO sor_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","I sɨdɨ, ɨndi gɨ Gun gorndɨw di, nə ha mara le ꞌyang, ya Maktubu dɨnə Mãr̰ĩ duwa ba way nɨm dara daran ta de. Me an̰ju gaba ꞌyàn woni mar̰ande ni ɨsɨragɨ lə di da, wamani ha ꞌywawe. Dee gɨ yànaw bədə kaw, dee biyawe.» ");
INSERT INTO sor_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Mana gɨ Jesu day gɨ nə woni gɨrsə gwale duwa ilə wama maniyə di mwom da, Jesu u mapa me àlɨ́w Mãr̰ĩ dóche me, ɓolbɨ dodə me, ꞌyàgɨ́ me, waygɨ ba da: «Unə, ta di i doni gɨ sɨn.» ");
INSERT INTO sor_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Targɨn̰ ɗang da, an̰ji u kob dɨ gani gɨyabɨr̰ayàa duwa ilə dwalɨn̰yə ɨsəwə me, àlɨ́w Mãr̰ĩ dóche me ꞌyàgɨ́ woni gɨrsə gwale duwa me cendi chə̀ pad dayyə pad. ");
INSERT INTO sor_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Mwom da, an̰ji waygɨ ba da: «Ta di, i bare ni. An̰ji bor dodə dara nare nə gɨr̰e dɨdəgɨ. I bare gɨ Mãr̰ĩ yɨ gɨ mɨlan gɨ nare duwa. ");
INSERT INTO sor_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Dwayna, nə wayang i gwale sɨw: Caga da, nə ha chàa gani gɨ yabɨr̰a yàa duwa di ɗang bədə ɗɨm, bɨraa i wála gɨ ɗan̰ nə ha chàa gɨ dɨrway alə ciri dɨnə Mãr̰ĩyə ɗɨm.» ");
INSERT INTO sor_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ɨr̰ɨ targɨn̰ ɗang da, cendi tu diri dɨ idɨ bwaw Mãr̰ĩ jilay me, cendi dɨmgɨ iche dara hára kur̰a dɨ Olib dɨdə. ");
INSERT INTO sor_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ɨr̰ɨ Jesu waygɨ woni gɨrsə gwale duwa di ba da: «Mani ha àlala le me pad dannə pad, anə ha bwara bam mana gɨ dusi dan dɨ kala dɨnnə di lə. Nə way yande dara Mãr̰ĩ way mana gɨ Maktubu duwa lə ba da: “Nə ha ꞌyáa aba gama dɨmən̰je di bam me, dɨmən̰je nə aba gamagɨ dáygɨ daa mana mɨn di, ha cagda daa dɨdəgɨ lə jiga jiga.” ");
INSERT INTO sor_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Me wála gɨ nə dara dɨmə daa munɨ lə mwom da, nə ha hára gamang alə wama gɨ Galileyə.» ");
INSERT INTO sor_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ɨr̰ɨ Piyer wayɨw ba da: «Kwandan nə pad ta di kalnam bam kaw, ɨndi da, nə ha kalam bam bədə bɨr̰ɨn̰.» ");
INSERT INTO sor_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Me Jesu wayɨw ba da: «Doy, nə wayɨm i gwale sɨw: Changa dɨ laba lə di, mə ha bɨlə bɨm sarni dɨnnə ba mə ꞌwocn̰ɨn bədə, ba mə ꞌwocn̰ɨn bədə, dii subu, do me gɨray ha hɨrdə dɨw sɨr sɨn̰.» ");
INSERT INTO sor_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Me Piyer ajɨmar ilə waya lə: «Nə ha bɨlə bɨn sarni dɨmmə bədə bɨr̰ɨn̰! Inam i made kaw, nə mar i gandɨm!» Me kwandaw nə pad di kaw, way day yande me ca. ");
INSERT INTO sor_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ɨr̰ɨ Jesu hargɨ gɨ nə woni gɨrsə gwale duwa gɨrgɨ mana mɨn gɨ gɨ ꞌwogɨw Gesemani me, an̰ji waygɨ ba da: «ꞌYeni da, damna dodə mana gɨ ka lə, me ɨndi da, nə ha ni i alə ta dara amsa gɨ Mãr̰ĩ.» ");
INSERT INTO sor_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Mana gɨ an̰ji ha dara amsa Mãr̰ĩ da, an̰ji wol Piyer me Jak me Jã me gandɨw. Ɨr̰ɨ an̰ji so ilə nulə sɨwə me lán̰a àlɨw nan̰e ");
INSERT INTO sor_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","me waygɨ ba da: «Sɨn mar mara gɨ nə ꞌwocn̰ sɨn bədə bɨr̰ɨn̰. Damna mana gɨ ka lə di, me damna dɨrəng bɨ̀ra!» ");
INSERT INTO sor_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","An̰ji chidɨ ha pii hin̰e me kal sɨw ɨbər dodə sɨn̰a lə, me amsɨ Mãr̰ĩ ba ladɨna dɨrəwə da, an̰ju ba chidɨnəw dawa dɨ idɨ gɨlə gɨ dɨrɨn̰ di hana nɨm bam. ");
INSERT INTO sor_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","An̰ji way da: «Baba, Aban, ɨjɨm da, mə nem àla mani pad. Yande da, chidɨn gɨlə gɨ dɨrɨn̰ gɨ ta di ha nɨm bam. Me àl gandɨn mani nə dɨrəm ùr ɨjɨm, me mani nə nə ùrgɨ ɨndi da, ɨrɨm dɨdəgɨ lə bədə.» ");
INSERT INTO sor_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ɨr̰ɨ Jesu cwara hára woni gɨrsə gwale duwa nə subu di sɨdəgɨ lə me, ꞌyogɨ cendi ilə ꞌya nuniyə. Mwom da, an̰ji wayɨw Piyer ba da: «Simõ, mə i i nuni mo? Dawa mɨn dwar̰ɨ lə mɨra dimm, mə nem dama dɨrəm bɨ̀ra bədə mo? ");
INSERT INTO sor_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Damna dɨrəng bɨ̀ra me amsɨna Mãr̰ĩ dara mana gɨ mani ꞌywanang da, kal lamnang bwanang àla gɨ àcn̰a lə bədə. Dara gun gɨ gɨsage i gɨ ɨrmə gaba àla mani nə lade, me dwana duwa dɨ sɨw dɨ idɨ àlagɨ̀ nɨm di nem bədə.» ");
INSERT INTO sor_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jesu chidɨ ha bam hin̰e bi me amsɨ Mãr̰ĩ ya gɨ pii di de bi. ");
INSERT INTO sor_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ɨr̰ɨ an̰ji cwara hára ꞌyo woni gɨrsə gwale duwa di, me ꞌyogɨ ꞌya gɨ nuniyə. Cendi nem dama dɨrəgɨ bɨ̀ra bədə dara nuni àlgɨ nan̰e, me cendi ꞌyo gwale mɨn gaba wayaw bədə me ca. ");
INSERT INTO sor_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Jesu chidɨ ha bam hin̰e gaba dii subu lə me cwara hára bi. An̰ji waygɨ woni gɨrsə gwale duwa ba da: «Anə i i nuni bi me anə bo i gwayni me mo? Caga da, dawa di yala nemme ɗɨm. Ɨndi gɨ Gun gorndɨw di, gɨ ha ꞌyàn nare woni àla àcn̰a ɨsɨragɨ lə. ");
INSERT INTO sor_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Swana daa, hanandɨ le! Yarna, gun gaba ꞌyàn woni mar̰ande ni ɨsɨragɨ lə di, yala ɗɨm.» ");
INSERT INTO sor_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Mana gɨ Jesu ilə waya gwale di lə sɨn̰ da, Judas gɨ i woni gɨrsə gwale duwa nə mwaj dii sɨr gun day gɨ mɨn di, hára yala gɨ nare nan̰ tarɨwə. Cendi laya sugɨnəne nə sore me cilangde me ɨsɨragɨ lə. I woni bwasa Mãr̰ĩ gechide day me woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa me gechide nə ɗang nənə nare nə Juwib day me giyəgɨ cendi. ");
INSERT INTO sor_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas gaba ꞌyàgɨ́ Jesu ɨsɨragɨ lə di dee ɨrməgɨ le pii ɗɨm dara mani nə ba ha àla dara gɨləgɨ nɨm gandɨw di. An̰ji wayagɨ ba da: «Gun gɨ nə gɨra dara yə̀w sɨnnə chichɨmə gajaw ya ba nə ùrɨw nan̰e de da, i an̰ji, yɨnəw, hana gandɨw me gamnaw ladɨ le me ca!» ");
INSERT INTO sor_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Mana gɨ ta lə dog me Judas ha ɨjɨ Jesu me wayɨw ba da: «Aba gɨlənin mani!», do me an̰ji yɨw sɨwə chichɨm nɨm gɨ gajaw sɨn̰. ");
INSERT INTO sor_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Mana gɨ ta lə di dog da, nare di ɓɨr̰ɨn̰ lawar Jesu dɨwə me yɨw nɨm. ");
INSERT INTO sor_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ɨr̰ɨ aba gɨrsə gwale duwa gɨ mɨn di biyə sugɨnə duwa dɨ chere me ajɨ gɨ kwaya gɨnə woni bwasa Mãr̰ĩ geche day duwa di sumɨw led saw àl bam. ");
INSERT INTO sor_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesu di waygɨ woni yə̀w di ba da: «Anə hára gɨ sugɨnəne nə sore me cilangde me ɨsɨrangə dara yə̀n gɨ dwana hára nɨm ya ba nə i mẽ de. ");
INSERT INTO sor_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Gɨ wála wála, nə ilə gandang mana gɨ ciri dwar̰ɨ dɨ kulu gaba bwasa Mãr̰ĩ ilə dara gɨlə gɨ mani kaw, anə yə̀n bədə. Me mani nə ta di pad àlal yande dara gwale gɨ gɨ jangɨw mana gɨ Maktubu dɨnə Mãr̰ĩyə pii di me yala àlal an̰ju.» ");
INSERT INTO sor_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Mana gɨ ta lə da, woni gɨrsə gwale gɨnə Jesu di pad dayyə ɓɨr̰ɨn̰ wà daa kalɨw bam. ");
INSERT INTO sor_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Me dwe gɨ maché mɨn ilə, an̰ji pam Jesu tarɨw an̰ju. An̰ji legɨr sɨw daa gɨ barge, me nare di yɨw. ");
INSERT INTO sor_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Me dwe gɨ maché di, awɨr barge gɨ sɨwə di kalgɨ nare di bam ɨsɨragɨ lə, me an̰ji wà daa ya nɨm sɨw pəgɨn̰. ");
INSERT INTO sor_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Mwom da, gɨ ha gɨ Jesu mana gɨ kɨrə nə woni bwasa Mãr̰ĩ geche dayə. Mana gɨ kɨrə di, woni bwasa Mãr̰ĩ geche day me gechide nə ɗang nənə nare nə Juwib day me, woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa me dayar dama lə pad. ");
INSERT INTO sor_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Piyer duwa da, wara bam targɨn̰ hən̰ me ha pam gɨ Jesu tarɨw bɨraa ha nɨm kɨrə ciri dɨnə woni bwasa Mãr̰ĩ geche day duwa lə bá. Mana gɨ kɨrə di da, woni àlaw geche giyə dam ilə wunə duwa lə me, Piyer ha dama wunə gandagɨ. ");
INSERT INTO sor_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Woni bwasa Mãr̰ĩ gechide day me, nare woni àla sariyanə ɗang nənə Juwib day pad me, kan̰jɨ gwale gɨ kulagɨ dara bwaw Jesu dɨwə ba gɨ ꞌyəw nɨm. Me cendi ꞌyo gwale mɨn bədə. ");
INSERT INTO sor_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","I dara nare nan̰ sabɨw Jesu gwale gɨ kulagɨ bow dɨwə, me cendi gang kaw, gwale day di bor mɨn bədə me ca. ");
INSERT INTO sor_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Nə mɨn ɓɨr̰ɨn̰ daa sabɨw gwale gɨ kulagɨ me bow dɨwə ba da: ");
INSERT INTO sor_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«An̰ji dee waya ba a ha joo kulu gaba bwasa Mãr̰ĩ gɨ nare biyəw ta di bam, me wála subu dalawə da, ba ha biyə gɨ ɗang daa gɨ i nare me, ba ha biyəw cendi bədə. Nenin, nə dwayanin gɨ sumdənin nin.» ");
INSERT INTO sor_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Me mana gɨ gwale day gɨ waya lə kaw, gwale day di bor mɨn bədə com. ");
INSERT INTO sor_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ɨr̰ɨ woni bwasa Mãr̰ĩ geche day di so daa nare dɨrəgɨ lə me ùr gɨ Jesu da: «Gwale gɨ nare way dara daram ta di, mə àsɨ dɨma gwale mɨn lə diiyə bədə mo?» ");
INSERT INTO sor_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Kaw Jesu di dam bɨw mɨgɨmi kur̰ad, wayɨw gwale mɨn lə diiyə bədə. Mwom da, ɨr̰ɨ woni bwasa Mãr̰ĩ geche day di ùrɨw ɗang bi ba da: «Ɨjɨm di me mə i Dole gɨ Mãr̰ĩ biyəw gɨ Kris di mo? Mãr̰ĩ gɨ nə bownin jilay gorndɨw di mo?» ");
INSERT INTO sor_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Me Jesu di cow lə diiyə ba da: «Əw, i ɨndi di, me ɗan̰ anə ha yara Gun gorndɨw di dama lə mana gɨ Mãr̰ĩ gaba dwana pad ɨsəw gɨ abeyə. Me anə ha yaraw chə̀ə lə daa siyaya dalawə hára nɨm dodə.» ");
INSERT INTO sor_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Mana gɨ ta lə da, woni bwasa Mãr̰ĩ geche day di so chəbɨ barge gɨ sɨwə bam me way ba da: «Də ùrəng nare woni cɨməndɨ gwale nə ɗang bədə ɗɨm! ");
INSERT INTO sor_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Anə doy widɨru gɨ an̰ji cadɨbɨ gɨ Mãr̰ĩ ta di gɨ sumdəng dan ꞌyeni ɗɨm. Anə ɨrɨm i man daraw mo?» Nare pad way da, an̰ji ba i gun gɨ àcn̰e, ba ùr i ꞌyáa gɨ bam, me ");
INSERT INTO sor_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","nare nə mɨn kwandagɨ dwar̰agɨ lə da, ɓɨr̰ɨn̰ ɓɨsɨbɨw lade sɨwə, maw dɨrəw daa, gobɨw gɨ ɨsɨragɨ me wayɨw da: «Mə ina i aba cɨmə Mãr̰ĩ bɨw ꞌyang da, waynin daa: I wi me ajɨm ta di mo? I wi me ajɨm ta di mo?» Me woni àlaw geche gɨnə woni bwasa Mãr̰ĩ giyə di dɨm gɨ Jesu iche me gobɨ gajaw me ca. ");
INSERT INTO sor_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Mana gɨ cendi ilə mana gaba aa sariya lə da,  Piyer duwa da, wor dodə ciri dwar̰ɨ lə sɨn̰. Deme mɨn dɨ idɨ àla giyə kɨrə nə woni bwasa Mãr̰ĩ geche dayə di gɨra ");
INSERT INTO sor_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","yər Piyer ilə wunə duwa lə. Mwom da, tandi yərɨw ɗerr me wayɨw ba da: «Ɨjɨm di kaw, mə i gun gɨnə Jesu gɨ Najaret di me ca!» ");
INSERT INTO sor_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Me Piyer bɨl bɨw sarni me way ba da: «Gwale gɨ dɨ wayɨw ta di, nə ꞌwocn̰ gɨndɨw bədə bɨr̰ɨn̰.» Mwom da, ɨr̰ɨ ganda iche gɨra ɗɨbɨ ciri di bɨdə. Mana gɨ ta lə da, gɨray kaw, hɨrdɨ me. ");
INSERT INTO sor_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ɨr̰ɨ deme di yərɨw bi me wayɨw ɗang mana gɨ nare nə ilə di dɨrəgɨ lə ba da: «Abe gɨ ta di i woni gɨrsə gwale gɨnə Jesu duwa gun day gɨ mɨn.» ");
INSERT INTO sor_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Me Piyer di bɨl bɨw sarni bi. Ɓam yande da, nare nə ilə ta di kaw, wayɨw Piyer ɗang ba da: «ꞌYang, mə i gandagɨ mɨn, dara ɨjɨm di kaw, mə i gun gɨ Galile di me.» ");
INSERT INTO sor_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Mwom da, Piyer ɗɨbɨ ilə wayagɨ lə ba da: «Nə sɨrgɨ sɨn: Nə ꞌwocn̰ abe gɨ ta di bədə. Nə wayna i kulagɨ da, kal Mãr̰ĩ yɨnən dange.» ");
INSERT INTO sor_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Mana gɨ ta lə dog da, gɨray hɨrdɨ ɗang gaba dii sɨr. Ɨr̰ɨ Piyer dusɨw guw daa gwale gɨnə Jesu duwa gɨ wayaw gandɨw pii di dɨwə. An̰ji wayaw ba da: «Pii gɨ gɨray wor hɨrdə dɨw sɨr sɨn̰ da, mə ha bɨlə bɨm sarni dɨnnə dɨm subu ba mə ꞌwocn̰ɨn bədə.» Ɨr̰ɨ Piyer nul gura nan̰e. ");
INSERT INTO sor_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Mana wal bam, gɨ jomni cor̰ər̰ə da, woni bwasa Mãr̰ĩ gechide day me, gechide nə ɗang nənə nare nə Juwib day me, woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa me, woni àla sariya nənə nare nə Juwib day nə ɗang pad me, dayar maa gwale gaba ꞌyáa Jesu di. Mwom da, cendi yɨw magdɨw me ha gandɨw ꞌyàw dole gɨ gɨ ꞌwogɨw Pilat. ");
INSERT INTO sor_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilat di ùr Jesu ba da: «Ɨjɨm di me mə i dole gɨnə Juwib day di mo?» Jesu di cow lə diiyə wayɨw ba da: «Mə way gwale gɨ ta di ɨjɨm gang.» ");
INSERT INTO sor_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ɨr̰ɨ woni bwasa Mãr̰ĩ gechide day di sabɨw Jesu gwale nan̰ ɗang bi bow dɨwə. ");
INSERT INTO sor_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Me Pilat di ùrɨw ɗang bi me wayɨw ba da: «Mə way gwale mɨn bədə mo? Mə doy gwale gɨ pad gɨ cendi bom dɨmmə ta di bədə mo?» ");
INSERT INTO sor_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Me Jesu di àsɨgɨ gwale mɨn lə diiyə bədə. Ɨr̰ɨ Pilat cor ɨrɨm gwale nan̰e. ");
INSERT INTO sor_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Mana gɨ wála gɨnə nare nə Juwib day gaba àla sii ꞌywala gɨnə kɨrara gɨ daa kwaynaniyə da, Pilat to gɨr i gun gɨ dange mɨn daa bá bá, i gun gɨ dange gɨ nare di me ùr ba gɨ gɨrnəw daa cendi do. ");
INSERT INTO sor_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Me wála gɨ ta lə da, abe mɨn gɨ gɨ ꞌwogɨw Barabas ilə dangeyə gɨ kwandaw mɨn. Cendi tanga swaa gɨ gwale gɨ nare nə Rom me ꞌyáa nɨm gɨ gun. ");
INSERT INTO sor_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Nare nə gɨr̰e di so ha ɗɨbə bɨdang dɨnə Pilat lə me ùrɨw nɨm an̰ju ba gɨrnəgɨ gun mɨn daa ya to an̰ju ba àl nɨm pii pii ta de. ");
INSERT INTO sor_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Mwom da, Pilat di cor ùrgɨ ba da: «Anə ùr ba nə gɨrnəng i dole gɨnə Juwib day di daa mo?» ");
INSERT INTO sor_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","An̰ji ꞌwocn̰ com dara i dusi dɨ halgɨni me woni bwasa Mãr̰ĩ gechide day di ba yəə gɨ Jesu hára ꞌyàw nɨm gandɨw ɨsəwə ta di. ");
INSERT INTO sor_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ɨr̰ɨ woni bwasa Mãr̰ĩ gechide day di nogɨ nare nə gɨr̰e di gɨndəgɨ daa, dara cendi ba wayna daa, an̰ju ba gɨrnə i Barabas daa an̰ju. ");
INSERT INTO sor_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Me Pilat di ùrgɨ ɗang bi ba da: «Nə àlna i na gɨ an̰ju gɨ anə ꞌwogɨw dole gɨnə Juwib day di mo?» ");
INSERT INTO sor_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ɗang bi da, cendi sojɨ mar̰ɨjagɨ daa nan̰ me way ba da: «Ɓengɨw ɓabɨr̰ɨw daa habda gɨ dagɨla sɨwə! Ɓengɨw ɓabɨr̰ɨw daa habda gɨ dagɨla sɨwə!» ");
INSERT INTO sor_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Me Pilat di ùrgɨ bi: «Ɓag da, an̰ji àl i na nə àcn̰e mo?» Kaw, cendi sojɨ mar̰ɨjagɨ daa nan̰ nan̰ bi ba da: «Ɓengɨw ɓabɨr̰ɨw daa habda gɨ dagɨla sɨwə! Ɓengɨw ɓabɨr̰ɨw daa habda gɨ dagɨla sɨwə!» ");
INSERT INTO sor_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilat di ùr dara nare sɨdəgɨ ba ꞌywalnagɨ le mwom da, an̰ji gɨrgɨ Barabas daa, me Jesu da, an̰ji kal asɨngar gobɨw gɨ bɨr̰aw do me ꞌyàgɨ́ gandɨw dara ba hana ɓengɨnaw ɓabɨr̰anaw nɨm daa habda gɨ dagɨla sɨwə sɨn̰. ");
INSERT INTO sor_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ɨr̰ɨ nɨma nə asɨngar di yɨ Jesu ha nɨm kɨrə bɨdang dɨnə Pilat lə di, me ꞌwaga kwandagɨ asɨngar nə pad di lə. ");
INSERT INTO sor_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Cendi diy gɨnɨn̰ dara ba gɨ àl Jesu məng. Cendi hurəw barge gɨ kwamge sɨwə ɨrmɨw ya dole de, me ku jagɨwa dɨ habde gangr̰agɨ nə jimdi hurəw dɨwə me ca. ");
INSERT INTO sor_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Mwom da, cendi ɗɨbɨ ilə àlaw labiya ba da: «Nə àlámnin labiya, dole gɨnə Juwib day!» ");
INSERT INTO sor_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Me cendi gobɨ dɨw gɨ dɨrwa me, ɓɨsɨbɨw lade sɨwə me, piy gubɨrəgɨ dodə dɨrəwə me, ajɨbɨ dɨrəgɨ dodə sɨn̰a lə me ca. ");
INSERT INTO sor_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Mana gɨ cendi àlɨw məng di bam pad mwom da, cendi n̰ir̰ɨw barge gɨ kwamge di bam sɨwə, me cor hurbəw barge duwa di sɨwə bi. Ɨr̰ɨ cendi dɨm gandɨw iche dara ɓyangaw ɓabɨr̰aw daa habda gɨ dagɨla sɨwə. ");
INSERT INTO sor_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Mana gɨ cendi ilə háragɨ lə da, cendi ɓamar gɨ abe mɨn gɨ ciri dɨ gɨ ꞌwogɨdɨ Siren. Abe di, gɨ ꞌwogɨw Simõ, i nə Alesandɨr day gɨ Rupu abɨragɨ. An̰ji swaa i bam. Asɨngar di yɨw gɨ dwana ba unə habda gɨ dagɨla gɨnə Jesu di. ");
INSERT INTO sor_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Cendi ha gɨ Jesu mana gɨ mana mɨn gɨ gɨ ꞌwogɨw Golgota, gɨndɨw dɨ biyə i «mana gaba dii kungɨng dɨra». ");
INSERT INTO sor_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ɨr̰ɨ cendi àl Jesu ba chàna gani gɨ yabɨr̰a yàa duwa gɨ ɓamɨw gɨ charwa dɨ gɨ ꞌwogɨdɨ mirdara ba chɨ́nəw wamani dodə, me an̰ji gɨn̰ chàa bam. ");
INSERT INTO sor_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ɗang da, asɨngar di ɓengɨ Jesu ɓabɨr̰ɨw daa habda gɨ dagɨla sɨwə. Ɨr̰ɨ cendi gobɨ jagi ba gɨ yər nɨm gaa i wi me ba ha wama barge duwa gɨ we we mo? Mwom da, i wi kaw, lay barge duwa gɨ an̰ji wom di bá bá. ");
INSERT INTO sor_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","I gɨ dawa dunamɨn gɨ jomni dɨra mana gɨ gɨ ɓengɨw ɓabɨr̰ɨw nɨm daa habda gɨ dagɨla sɨwə di. ");
INSERT INTO sor_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Gɨ jangɨ mana gɨ maniyə dara biyə gɨ gwale gɨ gɨ bow dɨwə di gɨndɨw dɨ gɨ ꞌyəw nɨm di ba da: Dole gɨnə Juwib day. ");
INSERT INTO sor_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Asɨngar di ɓengɨdɨ ɓabɨr̰ɨ miidi nə gechide sɨr daa habde nə dagɨla sɨdəgɨ lə Jesu tulɨwə, gɨ mɨn ɨsəw gɨ abeyə me, gɨ mɨn ɨsəw gɨ jeleyə me ca.  ");
INSERT INTO sor_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","I ya ta de di me gwale gɨ gɨ jangɨw mana gɨ Maktubu dɨnə Mãr̰ĩyə di yala àlal nɨm kɨrab. Gɨ jangɨ ba da: «Gɨ āsɨw i mana gɨ nare woni ꞌyáa mana di dwar̰agɨ lə.» ");
INSERT INTO sor_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Nare nə ha jə̀ gɨ lə ta di, gɨgdɨ dɨdəgɨ, me àl Jesu məng me wayɨw ba da: «Cheye, Ɨjɨm gɨ mə way ba mə ha cubə kulu gaba bwasa Mãr̰ĩ di bam me ba mə ha cwara awaw daa wála subu dalawə di, ");
INSERT INTO sor_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","kɨdɨ sɨm daa gɨ ɨsəm dɨma gang, me chə́y dodə habda gɨ dagɨla di sɨwə.» ");
INSERT INTO sor_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Woni bwasa Mãr̰ĩ gechide day di me, woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa di me kaw, àlɨw məng me ca. Cendi wajɨ gwale bulə dayyə ba da: «An̰ji kɨdə nare nə ɗang daa me nem kɨdə sɨw duwa daa gang bədə mo? ");
INSERT INTO sor_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Dole gɨnə nare nə Israyel day gɨ Mãr̰ĩ biyəw gɨ Kris di, kal a chɨ́nə dodə caga ka habda gɨ dagɨla di sɨwə ɗɨm. Də yarnang yande do me də hárang kala dusɨrəndɨ dɨwə sɨn̰.» Me cendi nə gɨ ɓengdɨgɨ ɓabɨr̰ɨgɨ daa habde nə dagɨla sɨdəgɨ lə di kaw, àlɨw məng me ca. ");
INSERT INTO sor_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Mana gɨ dawa ba dɨ ɗɨbɨ ciri dwar̰ɨ lə da, mana gɨdɨ dilɨm kɨdab sɨn̰a gɨndɨdɨ lə pad, bɨraa dawa pagar nɨm bá. ");
INSERT INTO sor_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ɨr̰ɨ mana gɨ dawa ba dɨ pagar nem dawa subu ɗɨm da, Jesu soy mar̰ɨjaw daa nan̰: «Elowi, Elowi, lema sabagtani?» Gɨndɨw dɨ biyə way i ba da: «Mãr̰ĩ ni, Mãr̰ĩ ni, dana me mə kalɨn bam mo?» ");
INSERT INTO sor_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Nare nə ɗɨbɨ lə mana gɨ ta lə di da, nə yab dwar̰agɨ lə doy me way ba da: «An̰ji ꞌwogɨ i aba cɨmə Mãr̰ĩ bɨw gɨ Eli!» ");
INSERT INTO sor_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ɨr̰ɨ gun day mɨn dwar̰agɨ lə wà gɨ gidi, gɨr ha laya mani nə gɨ ꞌwogɨgɨ «eponjɨ» sɨw mana gɨ gani gɨ yale gɨnə yabɨr̰a yàa duwa lə. Mwom da, an̰ji hurə eponjɨ di mana gɨ dɨrwa bɨwə me gɨlɨw Jesu dara ba chichɨmɨnə. Ɨr̰ɨ an̰ji gang way da: «Kalna jang, də yarang sɨn̰ Eli di gaa hára lə biyəw chə́w dodə mo?» ");
INSERT INTO sor_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Cor Jesu soy swaya gɨ geche mɨn me bɨw som. ");
INSERT INTO sor_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Mana gɨ ta lə da, barge gɨ geche gɨ gɨ jə̀w mana gɨ kulu gaba bwasa Mãr̰ĩ dalawə dara sabaw nɨm dodə di chowər dodə korgɨn̰ sɨr, swaa daa hára dodə ced. ");
INSERT INTO sor_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Asɨngar nə Rom geche day mɨn ɗɨbɨ lə Jesu di dɨrəwə me yər dara an̰ji mar made dɨ ya ta de di mwom da, an̰ji way da: «I sɨdɨ, gun gɨ ta di i Mãr̰ĩ gorndɨw ꞌyang.» ");
INSERT INTO sor_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Namde yab kaw, ɗɨbə bam hən̰ ilə yara lə. Namde nə ta di dwar̰agɨ lə da, i nə Mari dɨ ciri dɨra i Magdala, me Mari dɨ nə Jak gɨ gɨ ꞌwogɨw gɨ dwe di day gɨ chendɨw gɨ Jose idəgɨ, me Salome me ca. ");
INSERT INTO sor_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","I cendi me pii pama Jesu tarɨw me gamɨw ladɨ mana gɨ an̰ji wara nɨm wama gɨ Galileyə di. Namde nə ɗang nan̰ nə pii bwaw naga hára nɨm mana gɨ Jursalem kaw, ilə me ca. ");
INSERT INTO sor_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Mana gɨ dawa ba dɨ cor turgɨ da, Josep gɨ ciri duwa i Arimate, hára. An̰ji i woni àla sariya nənə nare nə Juwib day gun day gɨ mɨn gɨ nare àlɨw horɨmbə nan̰e. An̰ji kaw, ɓedɨ i wála gɨ Mãr̰ĩ ha lama gɨ dwãr̰ĩ duwa lə di me ca. Caga da, wála gɨ ta di i wála gaba ɗangr̰a sii gɨ nare nə Juwib ɗangr̰ɨ gɨ sɨdəgɨ dara sanga da, i wála day gaba bwaa gwayni di. Mwom da, an̰ji yɨ sɨw abnani me ha ꞌywaa Pilat me ùrɨw dara ba kalnaw bɨrmə ba a u Jesu kumbɨ duwa. ");
INSERT INTO sor_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ɨr̰ɨ Pilat di doy dara Jesu ba mar bam ɗɨm da, an̰ji ɨrɨm gwale nan̰e. An̰ji ꞌwaga asɨngar nə Rom geche day di me ùrɨw, Jesu di ba mar i ɓɨgden̰ mo? ");
INSERT INTO sor_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Me mana gɨ asɨngar nə Rom geche day di cow lə diiyə ba an̰ji ba mare ɗɨm da, Pilat kalɨw Josep bɨrmə ba unə Jesu kumbɨ duwa di. ");
INSERT INTO sor_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ɨr̰ɨ Josep ha kɨlə bagda, me biyə Jesu kumbɨ duwa mana gɨ habda gɨ dagɨla sɨwə dodə me, legɨrɨw daa me àsɨw nɨm mana gɨ munɨ gɨ gɨ polɨw mana gɨ kur̰a dwar̰ɨ lə. Targɨn̰ ɗang da, an̰ji nongr̰ɨ kur̰a dɨ geche ɗesɨ gɨ munɨ di bɨw daa. ");
INSERT INTO sor_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Me Mari dɨ ciri dɨra i Magdala me, Mari dɨ Jose iw me, yər mana gɨ gɨ àl gɨ kumbɨ dɨnə Jesu lə di. ");
INSERT INTO sor_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Mana gɨ wála gaba bwaa gwayni gɨnə nare nə Juwib day di ba ꞌyen̰ bam mwom da, Mari dɨ Magdala me, Mari dɨ Jak iw me, Salome me, kɨlgɨ swani gɨ gɨ ɓamɨw gɨ mani jiga jiga gɨ bii ꞌyol nan̰ dara hára ɗadɨ kumbɨ dɨnə Jesu. ");
INSERT INTO sor_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Gɨ dɨmas gɨ jomni cor̰ər̰ə dawa ganda dɨra gɨ daa lə da, cendi ha ɨjɨ mana gɨ munɨ lə di. ");
INSERT INTO sor_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Cendi wajɨ gwale bulə dayyə ba da: «I wi me ha nwangr̰andɨ kur̰a dɨ gɨ ɨbdɨ mana gɨ munɨ bɨwə di bam mo?» ");
INSERT INTO sor_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ɨr̰ɨ cendi u dɨrəgɨ daa mwom da, kur̰a dɨ munɨ bɨwə di nongr̰ər bam ɗɨm! Ɓag da, kur̰a dɨ ta di jor nan̰e. ");
INSERT INTO sor_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Cendi gandɨ ha mana gɨ munɨ di dalawə me yər dwe gɨ maché dam lə mana gɨ munɨ lə di ɨsay gɨ abeyə, hurə barge gɨ geche gɨ burage kəng yande. Mwom da, lán̰a àlgɨ. ");
INSERT INTO sor_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Me dwe gɨ maché di waygɨ ba da: «Àlna lán̰a bədə! Nə ꞌwocn̰ dara anə kan̰jɨ i Jesu gɨ Najaret, an̰ji gɨ gɨ ɓengɨw ɓabɨr̰ɨw daa habda gɨ dagɨla sɨwə di. Me an̰ji dɨm daa munɨ lə ɗɨm, an̰ji ilə ka bədə. Yarna mana gɨ tanga gɨ àsɨw lə di. ");
INSERT INTO sor_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Caga da, hana waynaw Piyer me woni gɨrsə gwale gɨnə Jesu duwa nə ɗang di me Jesu ba ya gamagɨ lə alə wama gɨ Galileyə. Cendi ba gɨrnə alə ta da, ba ha yaraw, ya an̰ji ba wayagɨ nɨm pii de.» ");
INSERT INTO sor_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Mwom da, namde di dɨmdɨ iche mana gɨ munɨ lə di, wagɨ gɨ gidi. Sɨdəgɨ sadɨgɨ daa tag tag me, gwale nolgɨ bam me, cendi tɨn̰ bɨdəgɨ wayɨw gun mɨn kaw gwale gɨ ta di daa bədə, dara lán̰a àlgɨ nan̰e. ");
INSERT INTO sor_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Mana gɨ Jesu dɨmə nɨm daa munɨ lə gɨ wála gɨ dɨmas gɨ jomni da, an̰ji gɨldɨ i Mari dɨ Magdala sɨw do. I tandi me an̰ji tanga ꞌywaradɨ dúndi dɨ àcn̰e wurgɨsubu bam sɨdə di. ");
INSERT INTO sor_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Tandi ha gɨra ha ꞌywaa cendi nə tanga basɨ Jesu harbɨ gandɨw di dara wayagɨ ba dɨ yara Jesu ba i bɨ̀ra. Mana gɨ tandi ha gɨra ꞌywagɨ mwom da, cendi dam ilə nulə lə me àla n̰agɨniyə me ca. ");
INSERT INTO sor_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Mwom da, tandi waygɨ ba Jesu di ba ilə bɨ̀ra me ba dɨ yaraw me ca kaw, cendi yɨ gwale dɨra di bədə. ");
INSERT INTO sor_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Targɨn̰ ɗang da, mana gɨ woni gɨrsə gwale gɨnə Jesu duwanə sɨr ilə hára lə dara hára bam da, Jesu di gɨlgɨ sɨw wun jiga hin̰e. ");
INSERT INTO sor_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Cendi cwara ꞌyo kwandagɨ bi me waygɨ nõ dɨ ta di kaw, kwandagɨ di yɨ gwale day di bədə com. ");
INSERT INTO sor_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Targɨn̰ ɗang da, Jesu gɨlgɨ woni gɨrsə gwale duwa nə mwaj dii mɨn di sɨw, mana gɨ cendi dam ilə wama maniyə. An̰ji sogdɨgɨ dara dii day dɨ woye dɨ cendi gɨn̰ nɨm gɨ yəə gɨ gwale gɨnə woni yaraw ba a i bɨ̀ra di bam. ");
INSERT INTO sor_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ɨr̰ɨ an̰ji waygɨ da: «Hana mana gɨ sɨn̰a gɨndɨdɨ lə pad, waynagɨ nare pad Nõ dɨ lade di. ");
INSERT INTO sor_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Gun gɨ dara kala dusɨw lə diiyə me àlna batem me da, an̰ji ha ꞌywaa bɨlə. Gun gɨ kalna dusɨw lə diiyə bədə da, Mãr̰ĩ ha bwaw gwale dɨwə dara ba hana nɨm dùwa dɨ idɨ budə bam bədə bɨr̰ɨn̰yə di. ");
INSERT INTO sor_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Me cendi nə ha kala dusɨrəgɨ lə diiyə da, yarna mani nə dan̰a nə àl lán̰a nə ha gɨləgɨ nare ba ha ꞌwacn̰agɨ nɨm: I gɨ sumɨn me cendi ha ꞌywara gɨ dúndi dɨ àcn̰e bam nare sɨdəgɨ lə, me ha waya bii gɨ ɗang gɨ dii mɨn cendi ꞌwocn̰ɨw bədə me. ");
INSERT INTO sor_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Cendi ha nyama yɨbə kwalàle gɨ ɨsɨragɨ, me chàna charwa dɨ idɨ ꞌyáa mana kaw, ha àlagɨ̀ mani mɨn bədə bɨr̰ɨn̰. Cendi ha bwaa ɨsɨragɨ nare woni mwom sɨdəgɨ lə, me woni mwom di ha ꞌywaa labiya.» ");
INSERT INTO sor_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Targɨn̰ ɗang da, mana gɨ Aba ciri gɨ Jesu waygɨ yande mwom da, Mãr̰ĩ uw yá nɨm daa dama ɨsəw gɨ abeyə. ");
INSERT INTO sor_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Woni gɨrsə gwale gɨnə Jesu duwa day da, ha waya Nõ dɨ lade di ciriyə jiga jiga. Aba ciri gɨ Jesu di wagɨ lə me ꞌyàgɨ́ dwana dɨ idɨ àla gɨ mani nə dan̰a me ca. I ya ta de me an̰ji gɨl nɨm dara gwale day di ba i gwale sɨw.");
INSERT INTO sor_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Nə àlɨ́m labiya, jan maché Tiyopil! Nare nan̰ janga maana dɨnə mani pad nə àlala mana gɨ dwar̰andɨ lə di. ");
INSERT INTO sor_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Cendi jangɨ i mani nə nare woni yaragɨ gɨ dɨrəgɨ ɓɨgden̰ diyə gɨ gɨnɨn̰yə me wayndɨ gwale day me, kɨdɨ woni àsa berni dɨ gwale gɨnə Mãr̰ĩ duwa me ca. ");
INSERT INTO sor_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Yande da, ɨndi kaw, nə kan̰ja gwale gɨ ta di gɨndɨw naa, mana gɨ diyə gɨ gɨnɨn̰yə bá, me nə jangɨm nɨm dodə maktubu lə kɨrab kɨrab ꞌyàm ɨjɨm Tiyopil gɨ nə yərɨm ba mə i gun dɨrənnə di me ca. ");
INSERT INTO sor_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Nə jangɨm i dara kal mə ꞌwacn̰ana ladɨ dara gɨlə gɨ gɨ gɨləm gandɨw di, ba i gwale sɨw ꞌyang. ");
INSERT INTO sor_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Wála gɨ dole gɨ Erod lam gɨ dwãr̰ĩ mana gɨ wama gɨ Judeyə da, aba bwasa Mãr̰ĩ mɨn gɨ gɨ ꞌwogɨw Jakari ilə. Nare woni bwasa Mãr̰ĩ nə gɨ sabɨgɨ abe gɨ gɨ ꞌwogɨw Abiya gɨndɨwə di, an̰ji i gun day. Jakari di dyaməw sumdɨ i Elisabet. Tandi i aba bwasa Mãr̰ĩ gɨ pii gɨ gɨ ꞌwogɨw Arõ mwàw. ");
INSERT INTO sor_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Cendi ca dayyə ca, i nare nə tɨba Mãr̰ĩ dɨrəwə, me yɨ bii gɨ ꞌwoo gɨnə Aba ciri gɨ Mãr̰ĩ duwa pad gɨ bɨrmə duwa kɨrab kɨrab me ca. ");
INSERT INTO sor_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ɨr̰ɨ, cendi yə̀ dwe bədə, dara Elisabet di i madɨri, me cendi ca dayyə ca halbɨ le ɗɨm. ");
INSERT INTO sor_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Wála mɨn, Jakari ilə mana gɨ kulu gaba bwasa Mãr̰ĩyə dara àla gɨ giyə gɨnə Mãr̰ĩ duwa. I wála gɨnə Jakari day gɨ nə kwandaw nə gɨ sabɨgɨ Abiya gɨndɨwə di me ha bwasa Mãr̰ĩ cendi. ");
INSERT INTO sor_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Gɨ wála wála da, cendi gobɨ jagi dara ꞌywaa gɨ gun gɨ ba dɨmnə kulə dara gwasa gɨ sawe ya woni bwasa Mãr̰ĩ ba gɨ àl nɨm de, me wála gɨ ta lə da, jagi di, yɨ i Jakari. ");
INSERT INTO sor_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Dawa dɨ idɨ gwasa di nem da, nare nə gɨr̰e pad ɗɨbɨ day iche me amsɨ nɨm gɨ Mãr̰ĩ. ");
INSERT INTO sor_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Mana gɨ Jakari ilə kulə ɗɨm da, paja gɨnə Aba ciri gɨ Mãr̰ĩ duwa gɨ daa dɨmə gɨra ɗɨbɨ mana gaba gwasa lə di tulɨw dɨ ɨsay gɨ abeyə me gɨlɨw sɨw. ");
INSERT INTO sor_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Mana gɨ Jakari yərɨw ɗɨbə lə da, lán̰a àlɨwe sɨw sadɨw tag tag me ca. ");
INSERT INTO sor_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ɨr̰ɨ, paja gɨ daa di wayɨw da: «Jakari, kal àla lán̰a ɗi! Mãr̰ĩ doy amsa dɨma di le. Dyam dɨ Elisabet ha yàm dwe gɨ abe, me mə ha ꞌwagáw sumɨw Jã. ");
INSERT INTO sor_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Sɨm ha ꞌywalam nan̰e dara dwe gɨ ta di, me nare nan̰ ha aja pide dara yàa duwa di me ca. ");
INSERT INTO sor_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","An̰ji ha gɨdə i gun gɨ geche mana gɨ Aba ciri gɨ Mãr̰ĩ dɨrəwə. An̰ji ha chàa gani gɨ yabɨr̰a yàa duwa bədə me, gani gɨ man̰e kaw, an̰ji ha ɓɨlə bɨwə bədə bɨr̰ɨn̰ me ca. Dúndi dɨnə Mãr̰ĩ duwa me ha ꞌwana dusɨw daa mana gɨ an̰ji wor nɨm iw nudədɨ lə jang sɨn̰. ");
INSERT INTO sor_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","An̰ji ha cwaa nare nə Israyel nan̰ hára nɨm mana gɨ Aba ciri day gɨ Mãr̰ĩ gɨndɨwə. ");
INSERT INTO sor_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","An̰ji ha hára pii Aba ciri dɨrəwə dara ɗangr̰aw bɨrmə. An̰ji ha àla giyə duwa i gɨ dwana dɨnə aba cɨmə Mãr̰ĩ bɨw gɨ Eli duwa, me gɨ dusi dɨ wun ya duwa de me ca. An̰ji ha àla yande dara dáya dine day gɨ nə abɨragɨ daa mɨn dara gwale day ba bwarna, me dara cwaa gɨ nare woni gɨn̰ə Mãr̰ĩ bɨw bam, ba cwana ɨrmə day dara ba ùrnə àla gɨ mani nə tɨba Mãr̰ĩ dɨrəwə me ca. Yande da, an̰ji ha ɗangr̰a nare ba ɗɨbɨnə ib dara yəə gɨ Aba ciri gɨ Mãr̰ĩ sɨdəgɨ lə.» ");
INSERT INTO sor_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Jakari ùr paja gɨ daa di ba da: «Nə ha ꞌwacn̰a i man mo? Dara nin gɨ dyaman ca ninnə ca, nə halbɨninne ɗɨm.» ");
INSERT INTO sor_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ɨr̰ɨ paja di cor wayɨw da: «Ɨndi, nə i Gabɨriyel. Nə ɗɨbɨ lə Mãr̰ĩ dɨrəwə ib dara àláw gɨ giyə duwa. I an̰ji me giyən dara ba nə hane waynam nõ dɨ lade dɨ ka di. ");
INSERT INTO sor_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Me yər, ɨjɨm, mə gɨn̰ yəə gɨ gwale ni di bam. Yande da, mə ha gɨdə i mɨm. Mə ha nyama waya gwale bədə bɨraa ɗan̰ mani nə nə wayɨm gwale day di, àlalna bá do. ꞌYang, mani di ha àlala i gɨ wála gɨ Mãr̰ĩ ɨrmɨw di bá.» ");
INSERT INTO sor_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Mana gɨ ta lə da, nare woni ɗɨbə iche di, ɓedɨ Jakari bɨraa bɨraa, me cendi ɨrɨmdɨ gwale nan̰e dara an̰ji dama kulə di tarɨw yə̄. ");
INSERT INTO sor_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Mana gɨ an̰ji dɨmə iche ɗɨm da, an̰ji nem wayagɨ gɨ nare gwale bədə. An̰ji gɨdɨ i mɨm, gɨlbɨgɨ i ɨsaw mɨra. Mwom da, cendi ꞌwocn̰ com Mãr̰ĩ ba gɨləw i mani mana gɨ kulə. ");
INSERT INTO sor_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Mana gɨ wála duwa gaba àla giyə mana gɨ kulu gaba bwasa Mãr̰ĩyə di ꞌyen̰ bam pad ɗɨm da, an̰ji cor ha ulay duwa lə. ");
INSERT INTO sor_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Àl wála ɓani da, dyaməw dɨ Elisabet di u gudi me, tandi budɨbɨ sɨdɨ le nem ya duru jii de do. Tandi way da: ");
INSERT INTO sor_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Aba ciri gɨ Mãr̰ĩ yər n̰agɨni niye me ꞌyàn gudi gɨ ta di. An̰ji biyɨn jawe bam dɨnnə nare dɨrəgɨ lə.» ");
INSERT INTO sor_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Mana gɨ Elisabet gudi dɨra nem duru kubi mwom da, Mãr̰ĩ giy paja duwa gɨ daa gɨ Gabɨriyel mana gɨ ciri dɨ gɨ ꞌwogɨdɨ Najaret, wama gɨ Galileyə. ");
INSERT INTO sor_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","An̰ji giyɨw mana gɨ dwe dɨ more dɨ dii mɨn ꞌwocn̰ abe bədə sɨn̰ sɨdə. Dwe dɨ ta di, i abe mɨn gɨ gɨ ꞌwogɨw Josep me àl mogɨni dɨra. Josep da, i dole gɨ pii gɨ gɨ ꞌwogɨwDabid mwàw. Dwe dɨ more di, gɨ ꞌwogɨdɨ Mari. ");
INSERT INTO sor_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Paja di dɨm ha ꞌywadɨ, me waydɨ ba da: «Labiya! Kal sɨy ꞌyoli, mɨndi dɨ Mãr̰ĩ àl gandi dwani. Aba ciri gɨ Mãr̰ĩ ilə gandi.» ");
INSERT INTO sor_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mana gɨ Mari doy gwale gɨ ta di da, dusɨdɨ cubɨdɨ le, me tandi way da: «Labiya dɨ ta di da, gɨndɨdɨ i man yande mo?» ");
INSERT INTO sor_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Paja gɨ daa di waydɨ da: «Mari, kal àla lán̰a ɗi. Mãr̰ĩ sɨw ꞌyolɨw dɨyyə, an̰ji yəri ba də i deme dɨ lade dɨrəwə. ");
INSERT INTO sor_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Yər, də ha ꞌwoo gudi me, də ha yàa dwe gɨ abe me, də ha ꞌwagaw sumɨw Jesu. ");
INSERT INTO sor_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","An̰ji ha ꞌya i gun gɨ geche me, gɨ ha ꞌwagaw Mãr̰ĩ gaba dama mani pad dɨdəgɨ lə gorndɨw, me Aba ciri gɨ Mãr̰ĩ ha chə́w gage gɨ dwãr̰ĩ gɨnə mwáw gɨ Dabid duwa dɨwə me ca. ");
INSERT INTO sor_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","An̰ji ha lama dwãr̰ĩ mana gɨ Jakob mwàgɨraw dɨdəgɨ lə gɨ dɨrɨn̰ bɨr̰ɨn̰. ꞌYang, dwãr̰ĩ duwa da, ꞌyan̰a dɨra gɨ bam ha ꞌya lə bədə bɨr̰ɨn̰.» ");
INSERT INTO sor_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ɨr̰ɨ Mari wayɨw paja gɨ daa di ba da: «Mani nə ta di, ha àlala i man mo? Dara nə ꞌwocn̰ abe dii mɨn bədə sɨn̰.» ");
INSERT INTO sor_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Paja di codɨ waydɨ ba da: «I dúndi dɨnə Mãr̰ĩ duwa me ha chə́ə dɨyyə, me Mãr̰ĩ gaba dama mani pad dɨdəgɨ lə dwana duwa ha àla giyə sɨyyə me ca. I dara yande me, dwe gɨ də ha yàw di, ha ꞌya i gun gɨnə Mãr̰ĩ duwa gɨ wun mɨnaw jiga, me gɨ ha ꞌwagaw Mãr̰ĩ gorndɨw me ca. ");
INSERT INTO sor_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Yər, wiləy dɨ Elisabet dɨ gɨ way gwale dɨra ba i madɨri, dɨ hal le ɗɨm ta kaw, i gɨ gudi gaba duru kubi. Ɗan̰ ha yàa i dwe gɨ abe. ");
INSERT INTO sor_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Dara mani mɨn nə bɨl Mãr̰ĩ àla da, ilə bədə.» ");
INSERT INTO sor_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mari cor wayɨw paja di ba da: «Ɨndi, nə i dwe dɨnə Aba ciri gɨ Mãr̰ĩ duwa, kal mani di àlalna ya ba mə wayɨn nɨm de.» Ɨr̰ɨ paja gɨ daa di so yá kaldɨ. ");
INSERT INTO sor_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Àl wála ɓani mwom da, Mari so kaláng ha mana gɨ ciri dɨ dam kur̰a dɨdə, wama gɨ Judeyə. ");
INSERT INTO sor_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Tandi gɨra ha dɨmə kɨrə nə Jakariyə me àldɨ́ Elisabet labiya. ");
INSERT INTO sor_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Mana gɨ tandi doy Mari labiya dɨra di mwom da, dwe gɨ nudədɨ lə di cogdɨ sɨw me, dúndi dɨnə Mãr̰ĩ duwa gɨra ꞌwon dusɨdɨ daa me ca, ");
INSERT INTO sor_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","mwom da, Elisabet sojɨ gwale daa pəng pəng me way ba da: «Mari, Mãr̰ĩ àl gandi dwani nan̰ ɗoy kwanday namde bam pad me, àl dwani gɨ dwe gɨ nudəyyə di me ca. ");
INSERT INTO sor_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ɨndi da, nə i wi me mɨndi dɨ Aba ciri ni iw, də hára dara yaran mo? ");
INSERT INTO sor_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nə way yande dara mana gɨ nə doy labiya diya di mwom da, dwe gɨ nudənnə cogdɨ sɨw àl sii ꞌywala nan̰e me ca. ");
INSERT INTO sor_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Mani nə Aba ciri gɨ Mãr̰ĩ wayay gwale day da, də kala dusi dɨdəgɨ lə ba ha àlala le. Də dam i gɨ sii ꞌywala!» ");
INSERT INTO sor_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Me Mari way da: «Nə tɨn̰ bɨn bow Aba ciri ni gɨ Mãr̰ĩ jilay, dara an̰ji i gun gɨ geche, ");
INSERT INTO sor_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","me sɨn ꞌyolɨn nan̰e mana gɨ Mãr̰ĩ ni dɨwə, dara an̰ji i aba bɨlən. ");
INSERT INTO sor_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","An̰ji yər n̰agɨni ni ɨndi dɨ nə i kóy duwa dɨ nə nem mani bədə nare dɨrəgɨ lə di. I sɨdɨ, so ka ha pii da, nare gɨ jwara day, jwara day ha waya ba nə dam i gɨ sii ꞌywala, ");
INSERT INTO sor_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","dara Mãr̰ĩ gaba dwana àlán mani nə gechide me, sumɨw kaw, wun i mɨnaw jiga me ca. ");
INSERT INTO sor_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Dusi dɨ lade dɨnə Mãr̰ĩ duwa da, dam i gɨ nare woni àláw horɨmbə gɨ jwara day, jwara day. ");
INSERT INTO sor_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Mãr̰ĩ àl mani gɨ ɨsəw gaba dwana me, cəgdɨ nare woni ꞌwaga sɨdəgɨ daa pad me ca. ");
INSERT INTO sor_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","An̰ji nongr̰ɨ dolgə nə gechide mana gɨ gagege day nə dwãr̰ĩyə ɓugdɨgɨ dodə me, lay nare nə n̰agɨni chɨ́gdɨgɨ lə diiyə. ");
INSERT INTO sor_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","An̰ji ꞌyàgɨ́ nare woni cherni mani nan̰ me, nare woni ꞌywaa mani da, an̰ji ꞌyorgɨ daa ɨsɨragɨ pəgɨn̰. ");
INSERT INTO sor_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","An̰ji yala wagɨ nare duwa nə Israyel nə i woni àláw giyə lə. An̰ji nɨm dusi duwa dɨ lade di bam bədə gɨ dɨrɨn̰ bɨr̰ɨn̰, ya ba a biygɨ gɨ mwágɨrandɨ nə pii bɨw nə Abɨraham me mwàgɨraw me ta de.» Ta di me, i diri dɨ Mari tudɨ di. ");
INSERT INTO sor_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mari dam gɨ Elisabet nem ya duru subu de, do me tandi so cor ha ulay dɨra lə sɨn̰. ");
INSERT INTO sor_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Me Elisabet di, wála dɨra gaba yàa yala nem, me tandi yə̀ dwe gɨ abe. ");
INSERT INTO sor_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Woni ciri dɨra bɨdɨ me war̰adɨ me, doy dara Aba ciri gɨ Mãr̰ĩ ba yər n̰agɨni dɨra ꞌyàdɨ́ dwe mwom da, cendi gɨra àl sii ꞌywala gandɨdɨ me ca. ");
INSERT INTO sor_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Mana gɨ gɨ yə̀w àl wála dunasɨr mwom da, nare di hára ꞌyogɨ kɨrə dara ba gɨ ha sawaw ban̰a. Cendi ùr dee ba gɨ ꞌwogɨ̀w «Jakari», sumi gɨnə abəw duwa. ");
INSERT INTO sor_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ɨr̰ɨ iw di waygɨ ba da: «Bədə. Gɨ ha ꞌwagaw Jã.» ");
INSERT INTO sor_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Mwom da, cendi cor waydɨ ba da: «I wi war̰ay dwar̰agɨ lə gɨ ꞌwogɨw yande mo?» ");
INSERT INTO sor_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ɨr̰ɨ cendi gɨlbɨw abəw di ɨsɨragɨ, ùrɨw gaa an̰ju ba ha ꞌwagáw dwe di sumɨw man mo? ");
INSERT INTO sor_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Jakari ùrgɨ ba unəw habda gɨ gɨ pɨlɨw dara janga gɨ maniyə di, cendi uw me, an̰ji jangɨ lə ba da: «Sumɨw i Jã.» Mwom da, nare di pad yɨbdɨ dɨdəgɨ. ");
INSERT INTO sor_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Mana gɨ ta lə di dog, Jakari dilesɨw awrar bam me tɨn̰ bɨw way gwale me, bow Mãr̰ĩ jilay me ca. ");
INSERT INTO sor_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Mana gɨ ta lə da, woni ciri day bɨdɨ lán̰a àlgɨ̀ me, mani nə àlal ta di pad, gɨ way nõ day mana gɨ ciri dɨ damdɨ kur̰a dɨdə pad, wama gɨ Judeyə. ");
INSERT INTO sor_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Nare pad nə doy mani nə àlal ta di da, cendi ɨrɨmdɨ gwale dusɨrəgɨ lə nan̰e me ùrbɨ sɨdəgɨ ba da: «Dwe gɨ ta di, ɓag da, ha gɨdə i na mo?» Dara cendi yər dara Aba ciri gɨ Mãr̰ĩ àsɨ ɨsəw dɨwə. ");
INSERT INTO sor_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Jakari gɨ i dwe abəw di, dúndi dɨnə Mãr̰ĩ duwa ꞌwon dusɨw daa me, nogɨ gɨndɨw me, an̰ji way ba da: ");
INSERT INTO sor_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Kal Aba ciri gɨ Mãr̰ĩ gɨnə nare nə Israyel day sumɨw ꞌwagɨna, dara an̰ji wandɨ lə nendɨ nə də ꞌyang i nare duwa me kɨdəndɨ daa me ca. ");
INSERT INTO sor_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","An̰ji giyəndɨ aba bɨlə nare gɨ i aba dwana. An̰ji giyəw mana gɨ mage nənə dole gɨ Dabid gɨ i aba àláw giyə dwar̰agɨ lə. ");
INSERT INTO sor_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Gwale gɨ ta di, i mani nə tanga pii ɓɨg an̰ji ꞌwoo bɨw ba a ha àlagɨ̀ le, me giyə nare duwa woni cɨmə bɨw ba waynagɨ nare gwale day di. ");
INSERT INTO sor_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","An̰ji way ba a ha kɨdəndɨ daa woni mar̰ande ɨnda ɨsɨragɨ lə me, woni ɨləndɨ ɨsɨragɨ lə me ca. ");
INSERT INTO sor_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","I ta di me an̰ji yara mwágɨrandɨ nə pii ɓɨg n̰agɨni day, me dusɨw guw daa mana gɨ mɨlan dɨ wun jiga dɨ an̰ji yɨ gɨ mwágɨrandɨ di dɨdə me ca. ");
INSERT INTO sor_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","I mani nə an̰ji tanga sɨrgɨ gɨ sɨw wayɨw mwágɨrandɨ gɨ Abɨraham ba a ha àlagɨ̀ di me an̰ji àlndɨ. ");
INSERT INTO sor_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","An̰ji way ba wála gɨ ba a ha kɨdəndɨ daa woni mar̰ande ɨnda ɨsɨragɨ lə mwom da, ba də àlnáw giyə dɨban dusi dɨ lán̰a, ");
INSERT INTO sor_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ba də damnang gɨ dusi dɨ wuse her, me ba də inang nare nə tɨba dɨrəwə wála gɨ də warang dam nɨm sɨn̰a dɨdə ka sɨn̰ di. ");
INSERT INTO sor_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Caga da, ɨjɨm gɨ gorndɨn di, gɨ ha ꞌwagam aba cɨmə Mãr̰ĩ gaba dama mani pad dɨdəgɨ lə bɨw, dara mə ha hára pii Aba ciri dɨrəwə dara ɗangr̰aw gɨ bɨrmə duwa. ");
INSERT INTO sor_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Me mə ha gɨləgɨ nare duwa ba ꞌwacn̰ana an̰ji ba ha kala dusɨw hɨlala àcn̰a day dɨwə me ba ha ꞌyàgɨ́ bɨlə me ca. ");
INSERT INTO sor_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Dara Mãr̰ĩ ɨnda di, i aba yara nare n̰agɨni day me, i aba àla ladni me ca. I ta di me an̰ji ha giyəndɨ nɨm gɨ aba bɨləndɨ ya dawa ba dɨ dɨmə nɨm daa ta de. ");
INSERT INTO sor_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","An̰ji ha giyəndɨ gandɨw dara ba ácn̰anagɨ nare nə dam dilɨmmə mana bam me, nare nə dam made ɨsədɨ lə kaw, an̰ji ha kɨdəgɨ daa me ca, dara kal ba də hanang nɨm mana gɨ bɨrmə gɨ hɨlale jwammə.» Ta di me, i diri dɨ Jakari tudɨ di. ");
INSERT INTO sor_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ɨr̰ɨ, dwe di jor gɨdə gun me, ꞌwocn̰ mani gɨndəgɨ naa me ca. An̰ji so ha dama dɨn dwar̰ɨ lə bɨraa wála gɨ an̰ji gɨra àsɨgɨ gɨ nare nə Israyel berni daa pɨden̰yə. ");
INSERT INTO sor_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Wála gɨ ta lə da, dole gɨ geche gɨ Rom gɨ gɨ ꞌwogɨw Ogis u bɨw waygɨ woni giyə duwa ba hana āsɨnaw nare nə lew duwa lə pad. ");
INSERT INTO sor_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Āsa gɨ nare gɨ ta di i gɨ dɨrɨn̰ daa, àlal i wála gɨ Kirinus gɨ i gun gɨ Ogis ꞌwów hára chɨ́w dole dara ba lamna dwãr̰ĩ mana gɨ wama gɨ Siriyə. ");
INSERT INTO sor_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Gun gɨ we we kaw, so ha mana gɨ ciri duwa lə, ciri duwa lə me, gɨ ha jangaw gɨ sumɨw di lə sɨn̰. ");
INSERT INTO sor_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","I dara ta di me, Josep kaw so mana gɨ ciri dɨ Najaret, dɨ i wama gɨ Galileyə, ba a nagɨ ha mana gɨ ciri dɨ Betɨlehem, dɨ i wama gɨ Judeyə. Ciri dɨ ta di, i ciri dɨnə dole gɨ pii gɨ gɨ ꞌwogɨwDabid duwa me, Josep i Dabid di mwàw me ca. ");
INSERT INTO sor_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Cendi ha day gɨ dyaməw dɨ Mari ca, dara ba gɨ ha janga sumdəgɨ. Me Mari da, i gɨ gudi lə nudədɨ lə ɗɨm. ");
INSERT INTO sor_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Wála gɨ cendi wor dam lə Betɨlehem sɨn̰ da, Mari wála dɨra gaba yàa yala nem. ");
INSERT INTO sor_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Tandi yə̀ gorndɨdɨ gɨ man̰jɨli me, tandi legɨrɨw daa gɨ barge me àsɨw mana gɨ mani nə gɨ ɗangr̰ɨgɨ dara bwagɨ gɨ mani nə paga chími lə di dwar̰agɨ lə. Dara mana gɨ kulu gɨnə mɨje dayyə da, mana gaba ꞌya yengɨ daa. ");
INSERT INTO sor_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Mana gɨ ciri dɨ Betɨlehem tuldɨ lə ib ib da, nare woni gama bage dam lə bam, dara gama gɨ bage day gɨ changa. ");
INSERT INTO sor_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Paja gɨ daa gɨnə Aba ciri gɨ Mãr̰ĩ duwa mɨn dɨmə jisgɨ dɨdəgɨ lə ꞌyogɨ, me ꞌywagda gɨnə Mãr̰ĩ duwa ácn̰ɨgɨ mana bam sɨdəgɨ lə ɗən̰ ɗən̰. Ɨr̰ɨ lán̰a cor àlgɨ̀ nan̰e. ");
INSERT INTO sor_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Me paja gɨ daa di waygɨ da: «Kalna àla lán̰a ɗi. Dwayna, nə hára wayang i nõ dɨ lade dɨ nare dan nə Israyel pad, sɨdəgɨ ha ꞌywalagɨ nan̰e. ");
INSERT INTO sor_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Changa dɨ laba lə da, gɨ yàng aba bɨlə mana mɨn mana gɨ ciri dɨnə Dabid lə. I Aba ciri ɨnda, an̰ji i Dole gɨ Mãr̰ĩ biyəw gɨ Kris di. ");
INSERT INTO sor_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Dwayna, anə ha ꞌwacn̰aw i man mo? Anə yarna dwe gɨ man̰ gɨ gɨ legɨrɨw daa gɨ barge me, gɨ àsɨw mana gɨ mani nə gɨ ɗangr̰ɨgɨ dara bwagɨ gɨ mani nə paga chími lə dwar̰agɨ lə da, i an̰ji.» ");
INSERT INTO sor_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Mana gɨ ta lə dog da, paja nə daa nə ɗang nə gɨr̰e nan̰ dɨmə gɨra dayar gɨ paja gɨ pii di daa mɨn. Cendi tu diri me bow gɨ Mãr̰ĩ jilay ba da: ");
INSERT INTO sor_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Kal Mãr̰ĩ gaba dama daa cog sumɨw ꞌwagɨna me, nare nə Mãr̰ĩ ùrgɨ sɨn̰a dɨdə ka da, gɨ damna gɨ hɨlala jwam me ca.» ");
INSERT INTO sor_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Mana gɨ paja di ɓɨr̰ɨn̰ yá daa kal woni gama bage di mwom da, cendi wajɨbɨ gwale bulə dayyə ba da: «Caga da, hanandɨ mana gɨ Betɨlehem bá. Də hárang yara mani nə àlal nə Aba ciri gɨ Mãr̰ĩ wayndɨ gwale day ta di gɨ dɨrəndɨ.» ");
INSERT INTO sor_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Cendi swaa kaláng hára me, gɨra ꞌyo nə Mari day gɨ Josep me dwe gɨ man̰ di gɨ àsɨw ilə dodə mana gɨ mani nə gɨ ɗangr̰ɨgɨ dara bwagɨ gɨ mani nə paga chími lə di dwar̰agɨ lə. ");
INSERT INTO sor_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Mana gɨ cendi hára gɨra yər dwe gɨ man̰ di mwom da, cendi biygɨ woni dama dɨwə gwale gɨ paja gɨ daa wayagɨ gandɨw dara dwe di. ");
INSERT INTO sor_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nare pad nə doy gwale gɨ woni gama bage kɨbɨgɨ gandɨw ta di da, ꞌyàgɨ́ ɨrmə nan̰e. ");
INSERT INTO sor_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Me Mari dɨra da, yɨ gwale gɨ ta di pad, gam dusɨdɨ lə me, dusɨdɨ gudɨ dɨwə daa daa me ca. ");
INSERT INTO sor_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ɨr̰ɨ woni gama bage di cor ha mana dayyə, me ꞌwogɨ Mãr̰ĩ sumɨw me tu diri bow gɨ jilay dɨrəgɨ daa, dara mani nə cendi dwayagɨ me yaragɨ di me ca. Mani nə ta di wun ya paja gɨ daa gɨnə Mãr̰ĩ duwa ba wayagɨ nɨm pii di de dige dige! ");
INSERT INTO sor_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Mana gɨ dwe gɨ man̰ di àl wála dunasɨr mwom da, gɨ sawɨw ban̰a bam me, gɨ ꞌwogɨ́w sumɨw Jesu me ca. Sumi gɨ ta di, i gɨ paja gɨ daa gɨnə Mãr̰ĩ duwa ꞌwogɨ́w gandɨw wála gɨ iw wor ꞌwoo gɨ gudi duwa sɨn̰ di. ");
INSERT INTO sor_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Wála gɨ bii gɨ ꞌwoo gɨnə Moyis duwa way dara sarga dɨnə namde woni yàa day di nem mwom da, Josep day gɨ Mari u dwe di me hargɨ nɨm mana gɨ ciri dɨ geche dɨJursalem. Cendi ha mana gɨ kulu gaba bwasa Mãr̰ĩyə dara àla sarga di. Sarga dɨ ta di, bii gɨ ꞌwoo gɨnə Aba ciri gɨ Mãr̰ĩ duwa ùr i kogəl dɨ bare sɨr labaa dɨ kergede sɨr. Ɗang kaw, cendi hára gɨ man̰ di dara ba gɨ gɨlnəw daa Aba ciri gɨ Mãr̰ĩ dɨrəwə me ca, dara bii gɨ ꞌwoo gɨnə Aba ciri gɨ Mãr̰ĩ duwa way ba da: «Dwe gɨ abe gɨ man̰jɨli da, mə ha ꞌyàw gandɨw i Aba ciri gɨ Mãr̰ĩ». ");
INSERT INTO sor_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Wála gɨ ta lə da, abe mɨn dam lə Jursalem, sumɨw i Simiyõ. Abe gɨ ta di, i gun gɨ tɨba Mãr̰ĩ dɨrəwə me àlɨ́w Mãr̰ĩ horɨmbə me ca. An̰ji dam ba a ɓedɨ aba hɨlalagɨ nare nə Israyel dusɨrəgɨ di bá me, dúndi dɨnə Mãr̰ĩ duwa ilə gandɨw me ca. ");
INSERT INTO sor_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Abe gɨ ta di, dúndi dɨnə Mãr̰ĩ duwa wayaw pii, an̰ji ba ha yara Dole gɨ Aba ciri gɨ Mãr̰ĩ biyəw gɨ Kris di gɨ dɨrəw bá, do me an̰ju ba ha mara sɨn̰. ");
INSERT INTO sor_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Wála gɨ nə Mari day gɨ tɨrədɨ gɨrgɨ kulu gaba bwasa Mãr̰ĩyə gɨ dwe gɨ man̰ di dara àla mani nə bii gɨ ꞌwoo gɨnə Mãr̰ĩ duwa ba way nɨm de da, dúndi dɨnə Mãr̰ĩ duwa nogɨ Simiyõ gɨndɨw daa dara ba hana mana gɨ kulu gaba bwasa Mãr̰ĩyə di me ca. ");
INSERT INTO sor_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simiyõ gɨra da, u man̰ di yɨw sɨwə me, bow Mãr̰ĩ jilay ba da: ");
INSERT INTO sor_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Aba ciri ni, caga da, ɨndi gɨ kwaya dɨma nə marna le kaw, nə ha hára i gɨ hɨlala jwam. Mani nə mə biyən gɨ bɨm pii di, mə àlgɨ̀ ɗɨm. ");
INSERT INTO sor_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Dara dɨrən yər aba bɨlə nare gɨ mə giyəw di ɗɨm. ");
INSERT INTO sor_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Aba bɨlə nare gɨ ta di, i gɨ mə ɗangr̰ɨw chɨ́w dara nare nə gɨndəgɨ jiga jiga sɨn̰a dɨdə pad di. ");
INSERT INTO sor_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","An̰ji wun ya mana gɨ ácn̰e gaba gɨləgɨ nare woni ꞌwacn̰am bədə sɨm pɨden̰yə ta de. Me i dara an̰ji me nare ha bwanin nɨm sɨdəninnə, nenin nə nare dɨma nə Israyel di.» ");
INSERT INTO sor_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Gwale gɨ Simiyõ wayɨw dara dwe di da, ꞌyàgɨ́ nə abəw day gɨ iw ɨrmə nan̰e. ");
INSERT INTO sor_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","An̰ji piy bɨw dɨdəgɨ lə me waydɨ Mari da: «Yər, gorndi gɨ ta di, nare nan̰ nə Israyel ha gɨn̰ə gwale duwa bam me, ha ɓugdara bam me, woni ùrə gwale duwa da, an̰ji ha yɨbəgɨ ɗɨbdɨ daa Mãr̰ĩ dɨrəwə me ca. An̰ji ha gɨdə gun gaba gɨlə Mãr̰ĩ sɨw, me nare nan̰ ha ùrɨw bədə. ");
INSERT INTO sor_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Yande da, an̰ji ha gɨlə ɨrmə gɨnə nare day gɨ budɨw dusɨrəgɨ dɨ korgɨn̰yə daa pɨden̰yə. Mɨndi dɨ Mari da, də ha jiba nan̰ me, dusi ha myanda bam ya gun ba ꞌwoy i gɨ sugɨnə de.» ");
INSERT INTO sor_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Mana gɨ kulu gaba bwasa Mãr̰ĩyə da, deme mɨn dɨ idɨ cɨmə Mãr̰ĩ bɨw kaw ilə, gɨ ꞌwogɨdɨ An. Tandi i gangle gɨnə Aser lə, me abadɨ, gɨ ꞌwogɨw Panuwel. Tandi hal nan̰e. Mana gɨ tandi so gɨ dɨnani dɨra da, u abe mɨn tenene dam gandɨw àl aliya wurgɨsubu me, ");
INSERT INTO sor_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","tɨrədɨ di mar bam. Caga da, mana gɨ aliya dɨra nem gɨnɨn̰ dunasɨr gɨ dii wodɨ kaw, tandi wor dam wambɨ com. Dii mɨn yande, tandi jal hára gɨ kulu gaba bwasa Mãr̰ĩyə bədə. Tandi àl giyə gɨnə Mãr̰ĩ duwa gɨ dawa me gɨ changa me, u asiyam amsɨw nɨm me ca. ");
INSERT INTO sor_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Dawa dɨ Simiyõ wor ilə wayagɨ nə Jesu war̰aw gwaleyə sɨn̰ da, tandi gɨra yər dwe di me bow Mãr̰ĩ jilay. Me nare pad woni dama ɓyada gun gaba kɨdə ciri dɨ Jursalem daa da, tandi waygɨ dwe gɨ ta di gwale duwa. ");
INSERT INTO sor_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Mana gɨ Jesu war̰aw àl mani nə bii gɨ ꞌwoo gɨnə Aba ciri gɨ Mãr̰ĩ duwa ɨrmɨgɨ di bam pad mwom da, cendi cor ha ulay dayyə Najaret wama gɨ Galileyə di bi. ");
INSERT INTO sor_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ɨr̰ɨ dwe di jor gɨdə gun, dɨrəw kaw naa me, Mãr̰ĩ àl gandɨw dwani nan̰ me ca. ");
INSERT INTO sor_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Gɨ aliya bá bá da, Jesu war̰aw ha i mana gɨ Jursalem dara àla gɨ sii ꞌywala gɨnə kɨrara gɨ daa kwaynaniyə gɨnə nare nə Juwib day. ");
INSERT INTO sor_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Mana gɨ Jesu aliya duwa nem mwaj dii sɨr ɗɨm da, war̰aw so ha gandɨw ba gɨ ha àla sii ꞌywala gɨ ta di, ya hada dayyə de. ");
INSERT INTO sor_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Mana gɨ sii ꞌywala di ꞌyen̰ bam mwom da, cendi cor ba gɨ ha ulay. Ɨr̰ɨ gwarndagɨ gɨ Jesu di wor dodə Jursalem taragɨ lə me, war̰aw di ꞌwocn̰ bədə. ");
INSERT INTO sor_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Cendi ɨrɨm dara an̰ji ba ilə hára lə kwandaw dwar̰agɨ lə. Mana gɨ cendi hargɨ bɨraa turgɨ mwom da, cendi kan̰jɨw mana gɨ war̰agɨ dwar̰agɨ lə me, woni ꞌwacn̰a day dwar̰agɨ lə me kaw, ");
INSERT INTO sor_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","cendi ꞌyow bədə. Mwom da, cendi kan̰jɨw dɨrəgɨ daa cor ha nɨm Jursalem di bi. ");
INSERT INTO sor_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Àl wála subu mwom da, cendi ꞌyow mana gɨ kulu gaba bwasa Mãr̰ĩyə, dam lə mana gɨ woni gɨləgɨ nare mani dwar̰agɨ lə. An̰ji dam doy gwale day me ùrgɨ gwale gɨ ùrə me ca. ");
INSERT INTO sor_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Nare pad woni dama dwaya gwale duwa da, yɨbdɨ dɨdəgɨ dara ꞌwacn̰a duwa gɨ mani gɨndəgɨ me gwale duwa gɨ an̰ji cogɨ lə diiyə di me ca. ");
INSERT INTO sor_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Mana gɨ war̰aw yərɨw dama lə mwom da, cendi yɨbdɨ dɨdəgɨ, me iw wayɨw da: «Dwe ga, mə àlnín i na yande yag ɗɨm? Yər, nin gɨ abam ca, nə kan̰jamnin i kan̰ja gɨ dusɨrənin saw nimi bɨr̰ɨn̰ ta bədə mo?» ");
INSERT INTO sor_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","An̰ji cogɨ lə diiyə waygɨ da: «Anə jiba sɨdəng kan̰jɨn i dana mo? Ùrɨn i dama gɨ kulu gɨnə Aban duwa lə da, anə ꞌwocn̰ bədə mo?» ");
INSERT INTO sor_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","War̰aw di, doy gwale duwa gɨ ta di me, cendi ꞌwocn̰ gɨndɨw bədə. ");
INSERT INTO sor_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ɨr̰ɨ Jesu di swaa gandagɨ cwaragɨ hára mana gɨ Najaret me, an̰ji doy gwale bɨdəgɨ lə. Iw dɨ Mari da, yɨ mani nə àlal ta di pad dusɨdɨ lə. ");
INSERT INTO sor_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesu duwa da, jor gɨdə gun me, dɨrəw kaw naa ha pii pii me ca. Mãr̰ĩ yərɨw ba i gun gɨ lade dɨrəwə me, nare kaw yərɨw ba i gun gɨ lade dɨrəgɨ lə me, ha nɨm pii pii. ");
INSERT INTO sor_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Wála mɨn, Mãr̰ĩ wayɨw Jã gɨnə Jakari gorndɨw gwale bam dɨn dwar̰ɨ lə. I aliya gɨ mwaj bii jii gɨ dole gɨ geche gɨ Rom gɨ gɨ ꞌwogɨw Tiber lam gɨ dwãr̰ĩ duwa me, Pons Pilat lam duwa dwãr̰ĩ mana gɨ wama gɨ Judeyə, me Erod lam duwa dwãr̰ĩ mana gɨ wama gɨ Galileyə me, chendɨw gɨ Pilip lam duwa dwãr̰ĩ mana gɨ wama gɨ Iture me Tɨrakoni me, Lisanas lam duwa dwãr̰ĩ mana gɨ wama gɨ Abilennə me ca. Aliya gɨ ta lə di da, i Han day gɨ Kayip me i woni bwasa Mãr̰ĩ gechide day cendi. ");
INSERT INTO sor_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Mana gɨ Mãr̰ĩ wayɨw Jã yande mwom da, an̰ji kɨdɨbər mana gɨ kuray gɨ Jurde dugdɨw dɨ alə ta lə me, dɨ ka lə me, an̰ji waygɨ nare, cendi ba àlna batem dara ba gɨlnə cendi ba kal i àcn̰a day bam me ba ùr ba gɨ ꞌyo i Mãr̰ĩ. I yande do me Mãr̰ĩ ba ha kala dusɨw hɨlala àcn̰a day dɨwə sɨn̰. ");
INSERT INTO sor_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Mani nə Jã àlgɨ́ di da, i mani nə tanga aba cɨmə Mãr̰ĩ bɨw gɨ Esayi jangɨ gwale day mana gɨ Maktubu dɨnə Mãr̰ĩ duwa lə ɓɨg di. An̰ji way ba da: «Gun soy berni mana gɨ dɨn dwar̰ɨ lə ba da: “Aba ciri gɨ Mãr̰ĩ hára lə! Ɗangr̰ɨnaw bɨrmə, kalɨw a inə i tɨba!” ");
INSERT INTO sor_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Mana gɨ chɨ́gɨde dodə da, gɨ ha twagdaw daa me, gɨ hogde da, gɨ ha dɨrsəw dodə me, bɨrmə gɨ dogde da, gɨ ha jagdaw ɗɨbdɨ tɨba tɨba me, bɨrmə gɨ àcn̰e kur̰ɨjam kur̰ɨjam kaw, gɨ ha ywagdaw dodə ledede ledede me ca. ");
INSERT INTO sor_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Me nare pad ha yara Aba bɨlə mana gɨ swaa Mãr̰ĩ sɨwə gɨ dɨrəgɨ me ca.» ");
INSERT INTO sor_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Nare nan̰ nə ciri dɨdə hára ꞌyo Jã dara ba àlnagɨ́ batem. Ɨr̰ɨ Jã di waygɨ ba da: «Mɨgay dɨndadɨ nə gá! Anə ɨrɨm dara anə ba ha bɨlə sɨdəng daa sariya dɨnə Mãr̰ĩyə di le ɓa? I wi wayang yande mo? ");
INSERT INTO sor_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Anə ùrnə dara sariya ba yɨbɨnəng bədə da, àlna mani nə lade. Gɨlnə dara anə banə kal àcn̰a dan di bam ɗɨm. Yande da, anə ha wunə i ya habde nə ladɨbe ba gɨ bo gɨ yàa day de. Kalna ɨrmə dusɨrəngə anə banə ꞌyo i bɨlə ɗɨm dara anə banə i Abɨraham mwàgɨraw ɗi. Dwayna, nə wayang: Kur̰a dɨ ɓolbəre dɨ ta di, Mãr̰ĩ nem cwadɨ Abɨraham mwàgɨraw. ");
INSERT INTO sor_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Caga kaw, bɨgame ilə habde gɨndəgɨ lə ib ib ɗɨm dara sabagɨ bam led led. Habda gɨ we we gɨ yàna ladɨna bədə da, gɨ ha sawaw bam dodə gɨndɨwə led àsaw dùwa lə.» ");
INSERT INTO sor_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Mana gɨ ta lə da, nare nə gɨr̰e ùr Jã ba da: «Ina yande da, nə hanin àla i man mo?» ");
INSERT INTO sor_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","An̰ji cogɨ lə diiyə waygɨ da: «Gun gɨ gumaj duwa ina sɨr da, a ɓɨr̰ɨn̰ə mɨn ꞌyànáw jaw gɨ duwa ilə bədə. Gun gɨ mani duwa nə wama ina lə da, a unə hin̰e ꞌyànáw jaw gɨ duwa ilə bədə me ca.» ");
INSERT INTO sor_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Nare woni salaw dole gɨ geche gɨ Rom mani kaw, hára ꞌyo Jã ba àlnagɨ́ batem di me ca. Cendi kaw ùrɨw da: «Aba gɨlənin mani, nə ha àlanin i man mo?» ");
INSERT INTO sor_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Jã cogɨ waygɨ da: «Dawa dɨ anə salna mani da, kalna sala ɗwaya ɨrmə gɨ gɨ ɨrməng di bam ɗi.» ");
INSERT INTO sor_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Asɨngar kaw ùrɨw da: «Me nenin da, nə ha àlanin i man mo?» Jã cogɨ waygɨ da: «Kalna chaba gɨ gun mani duwa ɗi me, sawnaw gun gwale dɨwə dara kudəw nɨm bədə me ca, me gamna gursɨ dan dɨ gɨ ꞌywagang duru lə mɨra.» ");
INSERT INTO sor_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Nare woni dwaya gwale gɨnə Jã di da, dam ɓedɨ mani nə geche ba hára lə, me cendi ɨrɨmdɨ gwale dusɨrəgɨ lə, gaa Jã di, ba i Dole gɨ Mãr̰ĩ biyəw gɨ Kris di som? ");
INSERT INTO sor_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Jã cor waygɨ pad dayyə ba da: «Ɨndi da, nə àlang batem i gɨ nimi mɨra. Me gun gɨ ɗan̰ hára lə, dwana duwa ɗoy dɨ ni bam. Gun gɨ ta di i gɨ geche gɨ ɨndi da, nə nem àsa dɨgɨlan mana gɨ dɨgɨlaw duwa dɨ an̰ji àsɨdɨ dodə dɨdə bədə. An̰ji duwa da, ha àlang batem gɨ dúndi dɨnə Mãr̰ĩ duwa me, gɨ dùwa me ca. ");
INSERT INTO sor_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","An̰ji yəə ɗagɨna dɨ idɨ huyə swagə di ɨsəwə dara huyə gɨ chìmi bam me kala gɨ swagə dɨrəgɨ. An̰ji ha laya swagə dɨrəgɨ di bwagɨ ɓeche duwa lə, me ha ulə chìmi bam mana gɨ dùwa dɨ budə dɨra gɨ bam ilə bədə bɨr̰ɨn̰yə di me ca.» ");
INSERT INTO sor_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ɨr̰ɨ, Jã gɨsɨ nare gɨ gwale gɨ ɗang nan̰ me an̰ji waygɨ Nõ dɨ lade me ca. ");
INSERT INTO sor_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Me dole gɨ Erod chəbɨ chendɨw dyaməw dɨ Erodiyad me, àl mani nə ɗang nə àcn̰e nan̰ me, mwom da, Jã wayɨw an̰ju ba àl mani nə ta di da, ba ꞌyolɨw Mãr̰ĩ bədə. ");
INSERT INTO sor_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ɨr̰ɨ, mana gɨ Erod doy gwale gɨ ta di da, àl àcn̰a gɨ geche lə diiyə ɗang bi: yɨ Jã àsɨw dangeyə. ");
INSERT INTO sor_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Wála gɨ gɨ wor yəə Jã dange sɨn̰ da,  nare nan̰ gɨra àl batem me, Jesu kaw, Jã àlɨ́w batem me ca. Mana gɨ Jesu wor nimi dwar̰agɨ lə sɨn̰ me amsɨ Mãr̰ĩ me ca da, daa tɨn̰ər bam, ");
INSERT INTO sor_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","me dúndi dɨnə Mãr̰ĩ duwa chə́ə gɨ sɨdɨ dɨra wun ya kogəl de, gɨra chɨ́ dɨwə. Mana gɨ ta lə di dog da, gwale nɨmə daa siyaya dalawə ba da: «Ɨjɨm da, mə i gorndɨn. Dusɨn ùrɨm nan̰e, me sɨn kaw, ꞌyolɨn dɨmmə me ca.» ");
INSERT INTO sor_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesu di, mana gɨ diy giyə duwa gɨndɨw da, aliya duwa nem ya gɨnɨn̰ subu de. An̰ji, nare ɨrmɨw ba i Josep gorndɨw. Josep di i Eli gorndɨw, ");
INSERT INTO sor_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli i Matat gorndɨw, Matat Lebi gorndɨw, Lebi i Melki gorndɨw, Melki i Yanay gorndɨw, Yanay i Josep gorndɨw, ");
INSERT INTO sor_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josep i Matatiyas gorndɨw, Matatiyas i Amos gorndɨw, Amos i Nawum gorndɨw, Nawum i Esɨli gorndɨw, Esɨli i Nagay gorndɨw, ");
INSERT INTO sor_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagay i Mat gorndɨw, Mat i Matatiyas gorndɨw, Matatiyas i Semeyin gorndɨw, Semeyin i Yosek gorndɨw, Yosek i Yoda gorndɨw, ");
INSERT INTO sor_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda i Yowanan gorndɨw, Yowanan i Resa gorndɨw, Resa i Jorobabel gorndɨw, Jorobabel i Salatiyel gorndɨw, Salatiyel i Neri gorndɨw, ");
INSERT INTO sor_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri i Melki gorndɨw, Melki i Adi gorndɨw, Adi i Kosam gorndɨw, Kosam i Elmadam gorndɨw, Elmadam i Er gorndɨw, ");
INSERT INTO sor_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er i Jesu gorndɨw, Jesu i Elijer gorndɨw, Elijer i Yorim gorndɨw, Yorim i Matat gorndɨw, Matat i Lebi gorndɨw, ");
INSERT INTO sor_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lebi i Simiyõ gorndɨw, Simiyõ i Juda gorndɨw, Juda i Josep gorndɨw, Josep i Yonam gorndɨw, Yonam i Eliyakim gorndɨw, ");
INSERT INTO sor_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakim i Meleya gorndɨw, Meleya i Mena gorndɨw, Mena i Matata gorndɨw, Matata i Natam gorndɨw, Natam i Dabid gorndɨw, ");
INSERT INTO sor_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dabid i Jese gorndɨw, Jese i Obed gorndɨw, Obed i Boos gorndɨw, Boos i Sala gorndɨw, Sala i Nason gorndɨw, ");
INSERT INTO sor_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naso i Aminadab gorndɨw, Aminadab i Adɨmin gorndɨw, Adɨmin i Arni gorndɨw, Arni i Esɨrom gorndɨw, Esɨrom i Peres gorndɨw, Peres i Juda gorndɨw, ");
INSERT INTO sor_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda i Jakob gorndɨw, Jakob i Isak gorndɨw, Isak i Abɨraham gorndɨw, Abɨraham i Tera gorndɨw, Tera i Nawor gorndɨw, ");
INSERT INTO sor_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nawor i Seruk gorndɨw, Seruk i Rewu gorndɨw, Rewu i Peleg gorndɨw, Peleg i Eber gorndɨw, Eber i Sala gorndɨw, ");
INSERT INTO sor_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala i Kaynam gorndɨw, Kaynam i Arpasad gorndɨw, Arpasad i Sem gorndɨw, Sem i Nuwe gorndɨw, Nuwe i Lemek gorndɨw, ");
INSERT INTO sor_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lemek i Matusalem gorndɨw, Matusalem i Enok gorndɨw, Enok i Yered gorndɨw, Yered i Malalel gorndɨw, Malalel i Kaynam gorndɨw, ");
INSERT INTO sor_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kaynam i Enoch gorndɨw, Enoch i Set gorndɨw, Set i Adam gorndɨw, Adam i Mãr̰ĩ gorndɨw me ca. ");
INSERT INTO sor_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Dúndi dɨnə Mãr̰ĩ duwa ꞌwon Jesu dusɨw daa, me an̰ji so kal kuray gɨ Jurde di bam. Ɨr̰ɨ dúndi di wolɨw ha gandɨw bam dɨn dwar̰ɨ lə. ");
INSERT INTO sor_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Mana gɨ dɨn dwar̰ɨ lə di, an̰ji àl wála gɨnɨn̰ wodɨ me Sidan ilə gɨrsəwə, gaa ba dɨ ha nyama lamaw àsàw àla gɨ àcn̰a lə mo? Wála gɨ gɨnɨn̰ wodɨ dalawə ta di, an̰ji wom mani bədə. Me wála gɨ ta di ꞌyen̰ bam mwom da, cherni àlɨ̀w. ");
INSERT INTO sor_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ɨr̰ɨ Sidan wayɨw ba da: «Ɨjɨm, mə ina i Mãr̰ĩ gorndɨw ꞌyang da, waydɨ kur̰a dɨ ta di, dɨ cwarna gɨdɨnəm haye me mə wom.» ");
INSERT INTO sor_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Me Jesu codɨ lə diiyə waydɨ ba da: «Gɨ jangɨ lə Maktubu dɨnə Mãr̰ĩyə way ba da: “I gɨ haye mɨra me gun gɨ gɨsage ha nyama bɨlə nɨm gɨ sɨw sɨn̰a dɨdə ka bədə.”» ");
INSERT INTO sor_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ɗang da, Sidan ha gɨ Jesu daa kur̰a dɨ hoy dɨdə cog, me gɨlɨw ciri dɨ sɨn̰a gɨndɨdɨ lə ka bam pad gang yande, ");
INSERT INTO sor_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","me wayɨw ba da: «Yər, nə ha ꞌyàm ciri dɨ ta di dwana dɨra me mani dɨra nə woni sumi me ɨsəmmə. Gɨ ꞌyàn i ɨsənnə ɨndi, me gun gɨ dɨrən ùrnəw da, nə ha ꞌyàwe. ");
INSERT INTO sor_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Yande da, ɨjɨm mə piynə gubɨrəm dodə dɨrənnə mɨlawdɨnan da, nə ha ꞌyàm mani nə pad ta di le.» ");
INSERT INTO sor_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesu codɨ lə diiyə waydɨ ba da: «Gɨ jangɨ lə Maktubu dɨnə Mãr̰ĩyə way ba da: “I Aba ciri dɨma gɨ Mãr̰ĩ mɨn tenene me, mə ha piyə gubɨrəm dodə dɨrəwə, me mə ha mɨlawdaw an̰ju mɨn tenene me ca.”» ");
INSERT INTO sor_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Sidan ha gɨ Jesu ɗang bi mana gɨ ciri dɨJursalem, me gɨra ha chə́w daa kulu gaba bwasa Mãr̰ĩ mana duwa gɨ hoy cog dɨwə me wayɨw ba da: «Mə ina i Mãr̰ĩ gorndɨw ꞌyang da, par mana gɨ ka lə di ɨndər dodə me mə ha ꞌywaa wamani bədə, ");
INSERT INTO sor_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","dara gɨ jangɨ lə Maktubu dɨnə Mãr̰ĩyə way ba da: “Mãr̰ĩ ha wayagɨ paja duwa nə daa ba gamnamme.” ");
INSERT INTO sor_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Me gɨ jangɨ lə ɗang bi ba da: “Cendi ha yə̀m daa gɨ ɨsɨragɨ dara kal dɨgɨlam ba ajarna kur̰a lə hin̰e bədə bɨr̰ɨn̰.”» ");
INSERT INTO sor_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesu codɨ lə diiyə waydɨ ba da: «Gɨ jangɨ lə Maktubu dɨnə Mãr̰ĩyə di me ba da: “Mə ha gɨrsə Aba ciri dɨma gɨ Mãr̰ĩ bədə.”» ");
INSERT INTO sor_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Mana gɨ Sidan gɨrsə Jesu gɨ mani nə jiga jiga di bam pad mwom da, tandi so yá kalɨw, ɓedɨ wála gɨ ɗangə ɗɨm. ");
INSERT INTO sor_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Targɨn̰ ɗang da, Jesu cwara hára mana gɨ wama gɨ Galileyə gɨ dwana dɨnə dúndi dɨnə Mãr̰ĩ duwa dɨra. Ɨr̰ɨ sumɨw ꞌwogɨ mana gɨ wama gɨ ta lə di pad. ");
INSERT INTO sor_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","An̰ji gɨlgɨ nare mani mana gɨ kululi day woni amsa Mãr̰ĩyə. Mwom da, nare pad bow gɨ jilay me ca. ");
INSERT INTO sor_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ɨr̰ɨ Jesu cwara hára mana gɨ ciri dɨ Najaret lə. I ciri dɨ ta di me an̰ji tanga jor lə di. An̰ji gɨra ha dɨmə kulu gaba amsa Mãr̰ĩyə gɨ wála gaba bwaa gwayniyə, ya to ba a àl nɨm wála gaba bwaa gwayniyə bá bá de. An̰ji so ɗɨbɨ daa dara āsa gɨ Maktubu dɨnə Mãr̰ĩ duwa. ");
INSERT INTO sor_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Gɨ u maktubu dɨnə aba cɨmə Mãr̰ĩ bɨw gɨ Esayi duwa dɨ gɨ legɨrɨdɨ daa ꞌyàw ɨsəwə, mwom da, an̰ji awrɨdɨ bam me ꞌyo i mana gɨ gɨ jangɨ lə ba da: ");
INSERT INTO sor_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Dúndi dɨnə Aba ciri gɨ Mãr̰ĩ duwa ilə gandɨn, daraan̰ji biyəntidɨrɨn swani dɨnnə dara ba nə waynagɨ nare nə bugɨr nõ dɨ lade. An̰ji giyən dara ba nə hane waynagɨ kòy nə gɨ layagɨ sayyə cendi ba ha kɨrara i daa ɗɨm me, an̰ji giyən dara ba nə hane waynagɨ nare nə dɨrəgɨ bu, cendi ba ha yara mana me, nare nə kwandagɨ gɨlgɨ dɨrəgɨ kaw, ba nə ha kɨdəgɨ daa me ca. ");
INSERT INTO sor_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Me an̰ji giyən dara ba nə waynagɨ nare dara aliya gɨ an̰ju gɨ Aba ciri gɨ Mãr̰ĩ ba a ha àla gandagɨ dwani lə di, ba yala nemme ɗɨm.» ");
INSERT INTO sor_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ɨr̰ɨ Jesu legɨr maktubu di daa bi, me ꞌyàw aba àla giyə mana gɨ kulu gaba amsa Mãr̰ĩyə di ɨsəwə, mwom da, dam dodə. Ɨr̰ɨ nare pad nə dam lə kulə ta di, bo dɨrəgɨ pad yərɨw. ");
INSERT INTO sor_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Mwom da, an̰ji kal sɨw waygɨ ba da: «Gwale gɨnə Mãr̰ĩ duwa gɨ anə doyɨw ka di, laba da, yala àlal ɗɨm!» ");
INSERT INTO sor_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Nare nə ta di pad bow sɨwə. Gwale gɨ lade gɨ ganda bɨwə di ꞌyàgɨ́ ɨrmə nan̰e, me cendi ùrbɨ sɨdəgɨ ba da: «Dwe gɨ ta di, i Josep gorndɨw di gaa bədə mo?» ");
INSERT INTO sor_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ɨr̰ɨ Jesu waygɨ ba da: «Nə ꞌwocn̰ com dara anə ha wayan i gwale gɨ diri ba da: “Dogtər, so sɨm dɨma daa ɨjɨm gang!” Me anə ha wayan: “Mani nə ɗan̰a nə mə àlagɨ̀ mana gɨ Kapernom da, nə doynin gwale day. Yande da, àlgɨ̀ mana gɨ ka, ulay dɨma lə di me ca!”» ");
INSERT INTO sor_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Me Jesu cor waygɨ ɗang bi ba da: «Dwayna, nə wayang i gwale sɨw: Aba cɨmə Mãr̰ĩ bɨw gɨ we we kaw gɨrnay mana gɨ ulay duwa lə da, nare gɨn̰ yə̀w gɨ sɨdəgɨ lə i bam ɓag. ");
INSERT INTO sor_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ɗang da, tanga wála gɨnə aba cɨmə Mãr̰ĩ bɨw gɨEliyə da, Mãr̰ĩ ꞌwō bədə nem aliya subu gɨ duru kubi. Badɨgara dɨ geche gɨra ɨndər mana gɨ sɨn̰a dɨ Israyel lə di pad. Me dwayna, nə wayang i gwale sɨw: Wála gɨ ta lə di, namde nə wambɨ nan̰ ilə sɨn̰a dɨ Israyel lə, ");
INSERT INTO sor_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ɨr̰ɨ Mãr̰ĩ giy Eli di mana gɨ deme dɨ wambɨ dɨ Israyel mɨn sɨdə bədə, me giyɨw deme dɨ wambɨ mɨn dɨ ciri dɨra gɨ ꞌwogɨdɨ Sarpat dɨ i wama gɨ Sidonnə sɨdə tandi. ");
INSERT INTO sor_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ɗang bi, tanga wála gɨnə aba cɨmə Mãr̰ĩ bɨw gɨ Elise duwa lə da, nare nan̰ woni cagɨm ilə sɨn̰a dɨ Israyel lə. Me dwar̰agɨ lə ta di, Mãr̰ĩ sɨr̰ɨw gun day mɨn cagɨm gɨ sɨwə di bam bədə, cor an̰ji sɨr̰ɨw i Nama gɨ i gun gɨ Siri di cagɨm duwa bam an̰ju.» ");
INSERT INTO sor_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Mana gɨ nare nə dam kulə pad ta di ba gɨ doy gwale duwa gɨ ta di mwom da, pad dayyə pad dusɨrəgɨ nagɨ nan̰e. ");
INSERT INTO sor_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Mwom da, cendi ɓɨr̰ɨn̰ daa me nongr̰ɨw dɨm nɨm bam iche. Ciri day di, gɨ piydɨ i daa kur̰a dɨ hoy dɨdə, me cendi ha gandɨw daa dɨdə cog dara ba gɨ nwangr̰aw àsàw dodə. ");
INSERT INTO sor_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Cor Jesu cwara hára jə̀ gɨ dwar̰agɨ lə me u bɨrmə ɨndər yá. ");
INSERT INTO sor_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ɨr̰ɨ Jesu so ha mana gɨ ciri dɨ Kapernom dɨ i wama gɨ Galileyə. An̰ji gɨra ha gɨləgɨ nare gwale gɨnə Mãr̰ĩ duwa wála gaba bwaa gwayniyə, mana gɨ kulu gaba amsa Mãr̰ĩyə. ");
INSERT INTO sor_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Me gɨlə duwa gɨ mani di ꞌyàgɨ́ nare ɨrmə nan̰e, dara i gɨ dwana. ");
INSERT INTO sor_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Mana gɨ kulə di, gun mɨn gɨ dúndi dɨ àcn̰e widɨbɨw kaw ilə. An̰ji so soy mar̰ɨjaw daa nan̰ ba da: ");
INSERT INTO sor_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Ay, Jesu gɨ Najaret, mə ùr i na sɨdəninnə mo? Mə hára i dara myandanin bam mo? Nə ꞌwocn̰ɨm com, mə i Gun gɨ wun mɨnaw jiga gɨ Mãr̰ĩ giyəm di.» ");
INSERT INTO sor_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ɨr̰ɨ Jesu ɨr̰ɨn̰ dúndi dɨ àcn̰e gɨ dwana me waydɨ ba da: «Ɗesɨ biy daa me gandɨ bam abe di sɨwə!» Mwom da, dúndi dɨ àcn̰e di u abe di ɨndəw dodə nare dwar̰agɨ lə do me gandɨ bam sɨwə dɨban àláw gɨ wamani. ");
INSERT INTO sor_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nare nə pad di, cor lán̰a àlgɨ̀ nan̰e me, wajɨbɨ gwale bulə dayyə ba da: «Gwale gɨ ta di, i gwale na yande ɓara? Gun gɨ ta di i gun gɨ geche, ɨr̰ɨn̰ dúndi dɨ àcn̰e di me waydɨ gɨ dwana me, tandi dɨm bam abe di sɨwə!» ");
INSERT INTO sor_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Mwom da, Jesu sumɨw ꞌwogɨ mana gɨ ciri dɨ wama gɨ ta lə di pad. ");
INSERT INTO sor_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ɨr̰ɨ Jesu so kal kulu gaba amsa Mãr̰ĩ di bam me, ha gɨr kɨrə nə Simõ lə, me Simõ dyaməw idɨ i mwom, sɨdɨ ur̰ɨ nan̰e. Mwom da, nare nə ilə kɨrə ta di amsɨw dara an̰ju ba àlna mani daradɨ. ");
INSERT INTO sor_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ɨr̰ɨ Jesu di ɗimbɨl dɨdə me ɨr̰ɨn̰ mwom gɨ sii ur̰e di, me sɨdɨ di chɨ́ hɨlal dodə. Mana gɨ ta lə dog, tandi so daa àlgɨ́ mɨjəni. ");
INSERT INTO sor_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Mana gɨ dawa ba dɨ ɗondɨ bam mwom da, gɨ háraw gɨ Jesu nare woni mwom gɨ dɨrəw jiga jiga bow gandagɨ dɨrəwə, me an̰ji bo ɨsaw dɨdəgɨ lə mɨn mɨn pad me sogɨ nɨm daa. ");
INSERT INTO sor_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Dúndi dɨ àcn̰e kaw, gandɨ bam nare nan̰ sɨdəgɨ lə me bo gura ba da: «Ɨjɨm, mə i Mãr̰ĩ gorndɨw!» Ɨr̰ɨ, Jesu ɨr̰in̰dɨ gɨ dwana, me ɨmdɨ waya gɨ gwale bam, dara tandi ꞌwocn̰ an̰ji ba i Dole gɨ Mãr̰ĩ biyəw gɨ Kris di. ");
INSERT INTO sor_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Mana gɨ mana ba a wal bam mwom da, Jesu so ha bam dɨn dwar̰ɨ lə mɨnaw. Me nare nə gɨr̰e nan̰ bɨr̰ɨn̰ kan̰jɨw me gɨra ha ꞌywaw. Mwom da, cendi ùr ba gɨ ɨməw dodə dara an̰ju ba hana kalnagɨ bam bədə. ");
INSERT INTO sor_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Me Jesu waygɨ da: «Ùrɨn i hára gɨ ciri dɨ ɗangə ɗangə dara wayagɨ gɨ nare nõ dɨ lade dɨ Mãr̰ĩ lam gɨ dwãr̰ĩ duwa di me ca. I dara ta di me Mãr̰ĩ giyən nɨm.» ");
INSERT INTO sor_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ɨr̰ɨ an̰ji àsɨ berni mana gɨ kululi woni amsa Mãr̰ĩyə sɨn̰a dɨnə nare nə Juwib dayyə pad. ");
INSERT INTO sor_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Wála mɨn, Jesu gɨra ɗɨbɨ kuray gɨ ɓɨle gɨ Gɨnesaret bɨwə waygɨ nare gwale gɨnə Mãr̰ĩ duwa. Nare nə gɨr̰e hára dara dwaya gwale duwa di, me cendi chɨbɨw ɨmɨw mana gaba cwaa sɨw bam. ");
INSERT INTO sor_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Mana gɨ ta lə da, Jesu yər bɨrwa sɨr ilə kuray bɨwə. Bɨrwa gɨ sɨr gɨ ta di, woni ciri duwa chɨ́gdɨ dodə dara wuja gɨ law day bam. ");
INSERT INTO sor_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Bɨrwa gɨ mɨn da, i gɨnə Simõ duwa. Jesu nagɨ bɨrwa gɨ ta di dalawə me, ꞌwaga Simõ ba hane ꞌwaynaw chidɨnəw hana nɨm korgɨn̰ hin̰e. Mana gɨ cendi gɨr korgɨn̰ mwom da, Jesu dam dodə bɨrwa dalawə me gɨlgɨ nare nə gɨr̰e nə ɗɨbɨ kuray bɨwə di mani. ");
INSERT INTO sor_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Mana gɨ an̰ji way gwale duwa ꞌyen̰ bam pad mwom da, an̰ji wayɨw Simõ: «ꞌWoy bɨrwa di ha gandɨw donə me, ɨjɨm me kwandam di me, jàna law dan di ūrnə mɨndang ɗɨm.» ");
INSERT INTO sor_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simõ cow wayɨw da: «Aba ciri nin, nə ūrnin mana walnin daa baj kaw, nə ꞌyonin mani mɨn bədə. Yande kaw, mə wayɨn mwom da, nə ha jàa law di dodə.» ");
INSERT INTO sor_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Cendi jə̀ law di me, law di lay gòche ꞌwon dwar̰ɨ daa àl dara chabara bam. ");
INSERT INTO sor_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ɨr̰ɨ cendi gɨlgɨ kwandagɨ nə bɨrwa gɨ ɗangə di ɨsɨragɨ ꞌwagagɨ ba hane wanagɨ lə. Kwandagɨ di gɨra ꞌyogɨ me, cendi lay gòche di ꞌwonbɨ bɨrwa di daa ca duwa lə àl dara ɗwanba dodə. ");
INSERT INTO sor_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Mana gɨ Simõ Piyer yər mani nə ta di mwom da, an̰ji hára gɨra piy gubɨrəw dodə Jesu dɨrəwə me wayɨw da: «Aba ciri ni, chidɨ bam sɨnnə hin̰e, dara ɨndi da, nə i gun gɨ àcn̰e.» ");
INSERT INTO sor_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simõ way yande dara lán̰a àlgɨ̀ le pad day gɨ nə kwandaw nə ɗɨbɨgɨ mɨn di, dara gòche nə law layagɨ àl lán̰a ta di. ");
INSERT INTO sor_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Simõ kwandaw woni ūrə gandɨw nə Jak day gɨ Jã nə i Jebede dɨndaw di kaw, lán̰a àlgɨ̀ me. Ɨr̰ɨ Jesu wayɨw Simõ da: «Kal lán̰a ɗi. Caga ka da, mə ha kan̰jan i nare, mə ha ūrə gòche bədə ɗɨm.» ");
INSERT INTO sor_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Mana gɨ ta di lə da, cendi surə bɨrwa di kalɨw daa wayniyə me, kal mani day di bam pad me, borgɨ pam Jesu tarɨw. ");
INSERT INTO sor_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Wála mɨn, mana gɨ Jesu ilə ciri dɨ mɨn dɨ wama gɨ Galileyə da, yər, jisgɨ yande, gun gɨ cagɨm sabɨw nan̰ yərɨw me gɨra ɨndər dodə dɨrəwə me amsɨw ba da: «Aba ciri ni, dɨrəm ùrnə da, mə nem sɨr̰ɨn sɨn bam cwan gɨdən gun gɨ lade bi.» ");
INSERT INTO sor_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ɨr̰ɨ Jesu yəə ɨsəw ɓɨl aba cagɨm di sɨw me wayɨw da: «Nə ùre, kal sɨm di sɨr̰ɨnə bam.» Mana gɨ ta lə di dog, aba cagɨm di sɨw sɨr̰ɨ bam kɨvbap. ");
INSERT INTO sor_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jesu wayɨw da, an̰ju ba cɨmnəw gun gwale gɨ ta di daa bədə, me an̰ju ba hana gɨlnə sɨw aba bwasa Mãr̰ĩ dɨrəwə me, an̰ju ba hana àlna sarga dɨ cagɨm sɨr̰ə nɨm bam sɨwə di, ya bii gɨ ꞌwoo gɨnə Moyis duwa ba ɨrɨm nɨm de. Ta di me nare pad ha ꞌwacn̰a dara ba cagɨm di ba sɨr̰ɨ i bam sɨwə me, an̰ju ba cor gɨdɨ i gun gɨ lade Mãr̰ĩ dɨrəwə sɨn̰ me ca. ");
INSERT INTO sor_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Me mana gɨ ta lə da, Jesu nõ duwa nɨm nare sumdəgɨ lə nan̰ nan̰ ɗoy dɨ pii bam. Gɨ wála wála da, nare nə gɨr̰e nan̰ hára dara dwaya gwale duwa me dara an̰ju ba swanagɨ daa mwom dayyə me ca. ");
INSERT INTO sor_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Me an̰ji duwa da, biy sɨw yá bam dɨn dwar̰ɨ lə me amsɨ gɨ Mãr̰ĩ me. ");
INSERT INTO sor_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Wála mɨn, Jesu ilə gɨləgɨ nare maniyə. Tulɨwə da, nare nə gɨ ꞌwogɨgɨ Parise me woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa me dam ilə dwaya gwale duwa lə. Nare nə ta di swaa i ciri dɨ wama gɨ Galileyə me gɨ Judeyə me, ciri dɨ Jursalem me ca. Aba ciri gɨ Mãr̰ĩ ꞌyàw Jesu dwana dɨ idɨ swaa gɨ nare daa mwom dayyə ɨsəwə, me an̰ji so gɨ nare nan̰ daa mwom dayyə. ");
INSERT INTO sor_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Jisgɨ yande, nare nə mɨn dɨbala gun gɨ r̰egɨdu gɨ jãr̰ĩ me gɨra kan̰jɨ bɨrmə ba gɨ dɨm gandɨw kulə ba gɨ ha àsaw Jesu dɨrəwə di. ");
INSERT INTO sor_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Me cendi ꞌyo bɨrmə bədə, dara nare ꞌyarbar nan̰e. Mwom da, cendi nagɨ daa kulu gɨ dange dɨwə me, ɓolbɨ kulu dɨw bam me, ꞌwoo aba mwom gɨ jãr̰ĩ duwa di, nwalaw àsɨw dodə Jesu dɨrəwə nare nə gɨr̰e dwar̰agɨ lə. ");
INSERT INTO sor_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesu di yər nare nə ta di kala day gɨ dusɨrəgɨ dɨwə di mwom da, an̰ji wayɨw aba mwom di ba da: «Jan maché, àcn̰a dɨma biyər bam ɗɨm.» ");
INSERT INTO sor_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Nare nə Parise me woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa di dam ɨrɨmdɨ gwale dusɨrəgɨ lə ba da: «Gun gɨ ta di i wi me, gagɨ sɨw gɨ Mãr̰ĩ àlɨw nɨm məng yande ɓara? Gun gaba biyəw gun àcn̰a bam da, i Mãr̰ĩ mɨn tenene mɨra bədə mo?» ");
INSERT INTO sor_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesu ꞌwocn̰ ɨrmə day com me, cogɨ waygɨ da: «Dara na me anə ɨrɨmdɨ gwale dusɨrəngə yande mo? ");
INSERT INTO sor_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Wayaw gɨ gun “Àcn̰a dɨma biyər bam ɗɨm”, labaa “So daa, me ha” da, i gwale gɨ we me wom nan̰ mo? ");
INSERT INTO sor_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ladɨ, nə ùr dara anə ba ꞌwacn̰ana dara ɨndi gɨ Gun gorndɨw ba nə i gɨ dwana dɨ idɨ piyəgɨ nare àcn̰a day bam mana gɨ sɨn̰a dɨdə ka. Yande da, nə ha àla mani nə anə yərgɨ ba wom nan̰e di.» Me an̰ji wayɨw abe gɨ r̰egɨdu di ba da: «Nə wayɨm: So daa, u jãr̰ĩ dɨma di daa me, mə cor ha ulay dɨma lə ɗɨm.» ");
INSERT INTO sor_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Mana gɨ ta lə di dog, abe gɨ r̰egɨdu di so daa nare dɨrəgɨ lə, u jãr̰ĩ duwa di daa me, an̰ji so ɨndər ha ulay duwa lə, ꞌwogɨ Mãr̰ĩ gɨ jilay dɨrəw daa. ");
INSERT INTO sor_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nare pad yɨbdɨ dɨdəgɨ me ꞌwogɨ Mãr̰ĩ gɨ jilay me ca. Cendi, lán̰a àlgɨ̀ me, way da: «Wála gɨ laba lə da, də yarang mani nə dan̰a nə dii mɨn də yərgɨ bədə sɨn̰ di!» ");
INSERT INTO sor_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Targɨn̰ ɗang da, Jesu swaa dɨmə iche me gɨra ha ꞌywaa abe mɨn gaba salaw dole gɨ geche gɨRom mani. Abe di, gɨ ꞌwogɨ̀w Lebi, dam lə mana duwa gaba sala maniyə di. Jesu wayɨw da: «Sway daa, hare, pam tarɨn!» ");
INSERT INTO sor_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ɨr̰ɨ Lebi di so kal mani duwa bam pad me an̰ji pam Jesu tarɨw. ");
INSERT INTO sor_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ɓam da, Lebi ɗorbɨ mani nə wama nan̰ me ꞌwaga gɨ Jesu kɨrə duwa lə. Mana gɨ wama gɨ ta di bɨwə da, nare nan̰ woni salaw dole gɨ geche gɨ Rom mani me, nare nə ɗang kaw, ilə gandagɨ me ca. ");
INSERT INTO sor_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Nare nə gɨ ꞌwogɨgɨ̀ Parise me, nare day nə mɨn nə i woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa me, n̰amdɨ gwale dodə me so waygɨ woni gɨrsə gwale gɨnə Jesu duwaba da: «ꞌYeni da, anə wom mani me chə̀ mani me gɨ nare woni salaw dole gɨ geche gɨ Rom mani me nare nə àcn̰e nə ɗang me mɨn, man man mo?» ");
INSERT INTO sor_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesu cogɨ waygɨ da: «Nare nə sɨdəgɨ i labiya da, cendi kan̰jɨ dogtər bədə. I nare nə sɨdəgɨ i mwom me kan̰jɨ dogtər cendi. ");
INSERT INTO sor_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ɨndi da, hára ni gɨ sɨn̰a dɨdə ka da, i dara ꞌwaga gɨ nare nə ꞌwocn̰ dusɨrəgɨ lə ba gɨ i nare nə àcn̰e ba kalna àcn̰a day di bam me ba hane ꞌywana Mãr̰ĩ. Me nare nə ɨrɨm dusɨrəgɨ lə ba gɨ i nə tɨba Mãr̰ĩ dɨrəwə da, nə hára i dara ꞌwagagɨ cendi bədə.» ");
INSERT INTO sor_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Nare di ùr Jesu da: «Woni gɨrsə gwale gɨnə Jã Batis duwa me, woni gɨrsə gwale nənə Parise day me, ugɨ asiyam me amsɨ gɨ Mãr̰ĩ jwab jwab me ca. Cor man me, nə dɨma wom day mani me chə̀ me ca mo?» ");
INSERT INTO sor_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesu cogɨ waygɨ gɨ gwale gɨ diri ba da: «Gun nem wayagɨ aba àla dyamdɨrani kwandaw moso ba unə asiyam mana gɨ an̰ji kaw ilə gandagɨ me mo? Bədə. ");
INSERT INTO sor_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Me wála gɨ ɗang mɨn hára lə. Wála gɨ ta di, gɨ ha biyə aba àla dyamdɨrani di bam dwar̰agɨ lə hára gandɨw do me cendi ha ꞌwoo asiyam di sɨn̰.» ");
INSERT INTO sor_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jesu cor waygɨ gwale gɨ diri ɗang ba da: «Gun mɨn ha ꞌwoo barge gɨ dɨrway bɨw dara àsa gɨ mabɨla mana gɨ barge gɨ mar̰ɨngeyə bədə. Dara gun di àlna yande da, an̰ji mendɨ barge gɨ dɨrway di bam, me gɨ an̰ji àsɨw mabɨla di kaw, ha ladaw barge gɨ mar̰ɨnge di bədə, dara cendi wundər bədə. ");
INSERT INTO sor_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Gun mɨn kaw ha bwaa gani gɨ dɨrway gɨ ilə sugdɨ lə mana gɨ ɗɨjili gɨ mar̰ɨngeyə bədə me ca, dara gani gɨ ilə sugdə lə di, ha jaa ɗɨjili gɨ mar̰ɨnge di bam bɨr̰ɨn̰. Me gani di ha chawa bwara bam me, ɗɨjili di kaw ha myandara bam me ca. ");
INSERT INTO sor_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Me ladni duwa da, gɨ bo gani gɨ ilə sugdə lə mana gɨ ɗɨjili gɨ dɨrwayyə. ");
INSERT INTO sor_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Nare woni chàa gani gɨ kàlang da, ùr gɨ dɨrway bədə. Cendi way ba i gɨ kàlang me, ba ꞌyol an̰ju.» ");
INSERT INTO sor_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Wála mɨn gɨ i wála gaba bwaa gwayni gɨnə Juwib day da, Jesu day gɨ nə woni gɨrsə gwale duwa ilə jàgɨ gɨ dàge dwar̰agɨ lə. Woni gɨrsə gwale duwa piy geme me gogɨlɨw gɨ ɨsɨragɨ wom. ");
INSERT INTO sor_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ɨr̰ɨ nare nə gɨ ꞌwogɨgɨ̀ Parise nə yab yərgɨ wama lə me waygɨ da: «Anə àl mani nə bii ɨnda gɨ ꞌwoo ɨm àla day bam gɨ wála gaba bwaa gwayniyə yande dana mo?» ");
INSERT INTO sor_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesu cogɨ waygɨ da: «Anə āsɨ mani nə Dabid àlgɨ̀ di mana gɨ Maktubu dɨnə Mãr̰ĩyə bədə mo? Dabid me woni bwaw me, wála mɨn, cherni àlgɨ̀. ");
INSERT INTO sor_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","An̰ji dɨm ha kulu gɨnə Mãr̰ĩyə me, lay mapa gɨ gɨ chɨ́gdɨw Mãr̰ĩ kulə di wom, me ꞌyàgɨ́ nare duwa di me ca. Ɓag da, mapa gɨ ta di, i woni bwasa Mãr̰ĩ me nem wamaw cendi mɨra. Me mani nə Dabid àlgɨ̀ ta di, i àcn̰a Mãr̰ĩ dɨrəwə bədə.» ");
INSERT INTO sor_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jesu waygɨ ɗang bi ba da: «Ɨndi gɨ Gun gorndɨw di, nə i wála gaba bwaa gwayni di aba ciri duwa.» ");
INSERT INTO sor_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Wála gaba bwaa gwayni gɨ ɗangə da, Jesu dɨm ha kulu gaba amsa Mãr̰ĩ gɨnə Juwib dayyə me ilə gɨləgɨ nare maniyə. Nare di dwar̰agɨ lə da, gun mɨn gɨ ɨsəw gɨ abe mar bam ilə me ca. ");
INSERT INTO sor_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa me, nare nə Parise me, dam ilə àsa angal day yara, gaa Jesu ba ha swaa aba mwom di daa gɨ wála gaba bwaa gwayniyə di mo? Ɨrmə dayyə ɓag kaw, cendi kan̰jɨ ba gɨ ꞌyo gwale gɨ àcn̰e bɨwə dara ba gɨ ha gandɨw woni àla sariya dɨrəgɨ lə. ");
INSERT INTO sor_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Me Jesu da, ꞌwocn̰ ɨrmə day com. An̰ji wayɨw abe gɨ ɨsəw mar bam di ba da: «So ɗɨbɨ daa nare dɨrəgɨ lə.» Me an̰ji so ɗɨbɨ daa. ");
INSERT INTO sor_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ɨr̰ɨ Jesu waygɨ ba da: «Nə ùrəng sɨn̰: Ɓag da, wála gaba bwaa gwayniyə da, bii ɨnda gɨ ꞌwoo kal bɨrmə dara ba mə àlna i mani nə lade labaa, ba mə àlna i nə àcn̰e mo? Ùr dara ba mə bɨlnə gun daa labaa, ba mə kalnaw ba marna bam mo?» ");
INSERT INTO sor_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jesu co dɨrəw mana gɨ nare dɨdəgɨ lə yərbɨgɨ mɨn mɨn pad, me wayɨw abe di: «Yə́ ɨsəm di dodə!» An̰ji yə́ ɨsəw di dodə me, ɨsəw di cor ladɨ mana duwa lə bi. ");
INSERT INTO sor_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ɨr̰ɨ woni gɨlə bii gɨ ꞌwoo me, nare nə Parise me, dusɨrəgɨ nagɨ nan̰ Jesu dɨwə me, cendi gagɨ gwale dɨwə me ɨrɨm mani nə ba gɨ ha àláw nɨm me ca. ");
INSERT INTO sor_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Wála mɨn da, Jesu so nagɨ ha daa kur̰a dɨdə dara amsa gɨ Mãr̰ĩ. An̰ji amsɨ Mãr̰ĩ di bɨraa mana walɨw daa baj. ");
INSERT INTO sor_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Gɨ jomni da, an̰ji ꞌwaga woni gɨrsə gwale duwa sɨwə ib, me gɨra an̰jir nə yab dwar̰agɨ lə mwaj dii sɨr me ꞌwogɨgɨ́ sumdəgɨ ɗang ba i paja duwa. ");
INSERT INTO sor_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Nare nə ta di i nə Simõ gɨ an̰ji ꞌwagáw sumɨw Piyer di, me chendɨw gɨ Andɨre me, Jak me Jã me, Pilip me Bartelemi me, ");
INSERT INTO sor_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matiyə me Toma me, Jak gɨnə Alpe gorndɨw me, Simõ gɨ gɨ ꞌwogɨw «gun gɨ day gɨ nə kwandaw nə ùr nare nə Juwib ba damna gɨ dɨdəgɨ day» me, ");
INSERT INTO sor_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas gɨnə Jak gorndɨw me, Judas Iskariyot gaba ꞌyàa Jesu woni mar̰ande duwa ɨsɨragɨ lə di me ca. ");
INSERT INTO sor_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Mana gɨ Jesu day gɨ nə paja duwa di, chə́gɨ daa kur̰a dɨdə, gɨra ɗɨbɨgɨ dodə kur̰a mana dɨra gɨ dodə gɨ ɓɨleyə da, woni gɨrsə gwale duwa nə gɨr̰e me nare nə ꞌyarbar nan̰ me ilə. Nare nə ta di, swaa i mana gɨ wama gɨ Judeyə me, ciri dɨ Jursalem me, ciri dɨ dam kuray gɨ geche bɨwə wama gɨ Tirrə me gɨ Sidonnə me ca. ");
INSERT INTO sor_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Cendi hára i dara dwaya gɨ gwale gɨ Jesu wayɨw me, dara an̰ju ba swanagɨ daa mwom dayyə me ca. Woni dúndi dɨ àcn̰e ilə sɨdəgɨ lə kaw, an̰ji ꞌyorgɨ gandɨdɨ bam. ");
INSERT INTO sor_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Nare nə pad ta di kan̰jɨ bɨrmə dara ba gɨ ɓɨlbɨ sɨw. Dara gun ba ɓɨlnə sɨw da, dwana duwa gandɨ ꞌyorɨw mwom bam sɨwə. ");
INSERT INTO sor_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ɨr̰ɨ Jesu co dɨrəw yər woni gɨrsə gwale duwa me waygɨ ba da: «ꞌYeni nare nə bugɨr da, anə dam i gɨ sii ꞌywala, dara anə nem dɨmə hára ciri dɨnə Mãr̰ĩyə ꞌyeni. ");
INSERT INTO sor_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ꞌYeni nə cherni àlang caga ka da, anə dam i gɨ sii ꞌywala, dara anə ha wama mani ɨbdə le. ꞌYeni nə anə ilə bwaa gura caga ka da, anə dam i gɨ sii ꞌywala, dara anə ha piyə baya pəgɨn̰. ");
INSERT INTO sor_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Mana gɨ nare ɨlnəng labaa, ꞌywarnang bam sɨdəgɨ lə labaa, cadɨbɨnang labaa, myandɨnang sumdəng bam dara ɨndi gɨ Gun gorndɨw da, anə dam i gɨ sii ꞌywala. ");
INSERT INTO sor_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Mani nə ya ta de di àlnana gandang da, kalna sɨdəng ꞌywalnange, me ajɨna pide me ca, dara ꞌywaga dan gɨ geche gamangə daa Mãr̰ĩ sɨwə. Yarna, woni gɨləng dɨrəng ta di mwágɨragɨ nə pii kaw, gɨlgɨ woni cɨmə Mãr̰ĩ bɨw nə pii di dɨrəgɨ yande me ca. ");
INSERT INTO sor_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Me ꞌyeni woni ꞌywaa mani da, wamani ha ꞌywange. Anə ꞌyo ꞌywala dan bam ɗɨm. ");
INSERT INTO sor_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ꞌYeni woni wama mani ɨbdə caga ka da, wamani ha ꞌywange. Cherni ha àlange. ꞌYeni woni piyə baya caga ka kaw, wamani ha ꞌywange. Anə ha dama n̰agɨniyə me gura lə me ca. ");
INSERT INTO sor_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Wála gɨ nare pad wayna gwale dan gɨ lade da, wamani ha ꞌywange. Yarna, mwágɨragɨ nə pii kaw, way gwale gɨ lade yande dara woni cwaa sɨdəgɨ ba gɨ i woni cɨmə Mãr̰ĩ bɨw di me ca.» ");
INSERT INTO sor_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«Me ꞌyeni nə anə dam ilə dwaya gwale niyə da, dwayna, nə ilə wayangə: Ùrnə woni mar̰ande danne, me woni ɨləng kaw, cwarna àlnagɨ́ ladni com. ");
INSERT INTO sor_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Woni sɨrgəng da, piynə bɨdəng dɨdəgɨ lə me, woni waya gwale dan gɨ àcn̰e kaw, amsɨna Mãr̰ĩ daragɨ me ca. ");
INSERT INTO sor_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Gun ajɨna gajam nə mɨn da, cow nə ɗang kalɨw a ajɨ lə me ca. Gun layna gumaj dɨma gɨ geche bam da, kalɨw a lay gumaj dɨma gɨ jaw dalawə di lə me ca. ");
INSERT INTO sor_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Gun gɨ we we amsɨnam mani da, ꞌyàw, me gun unə mani dɨma da, ùrɨw dara ba cwanam daa bədə me ca. ");
INSERT INTO sor_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mani nə anə ùr nare ba àlnáng gandagɨ da, ꞌyeni kaw, àlnagɨ́ nare di yande me ca. ");
INSERT INTO sor_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Anə ùrnə i nare woni ùrəng mɨra da, ꞌywala duwa ilə na lə Mãr̰ĩ dɨrəwə mo? Nare nə àcn̰e kaw ùr i woni ùrəgɨ me ca. ");
INSERT INTO sor_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Anə àlna ladni gɨ woni àlang ladni mɨra da, ꞌywala duwa ilə na lə Mãr̰ĩ dɨrəwə mo? Nare nə àcn̰e kaw àl yande me ca bədə mo? ");
INSERT INTO sor_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Anə ꞌwánagɨ i nare nə anə ɨrɨm sanga ba ha cwang mani di daa bi mɨra da, ꞌywala duwa ilə na lə Mãr̰ĩ dɨrəwə mo? Woni àla àcn̰a kaw ꞌwogɨ kwandagɨ woni àla àcn̰a di mani me, ɨrɨm sanga ba gɨ ha ꞌywaa i daa bi bədə mo? ");
INSERT INTO sor_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ɨr̰ɨ ꞌyeni da, ùrnə woni mar̰ande danne me àlna gandagɨ ladni me ca. Anə ꞌwánaw gun mani da, ɨrmɨnə dara ba cwanang daa bá bədə. Anə àlna yande mwom da, Mãr̰ĩ ha ꞌywagang gwayni dan nan̰a le, me anə ha ꞌya i Mãr̰ĩ gaba dama mani dɨdəgɨ lə pad dɨndaw, dara an̰ji kaw i aba àla ladni gɨ nare nə gun ꞌyàgɨ́ mani kaw nem àláw dóche bədə me, nə dusɨrəgɨ ur̰in̰ me ca. ");
INSERT INTO sor_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Yarna nare n̰agɨni day, ya Abɨrang gɨ Mãr̰ĩ ba a yər gɨ nare n̰agɨni day de me ca.» ");
INSERT INTO sor_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«Kalna yara gɨ kwandang àcn̰a day ɗi. Anə yarna kwandang àcn̰a day bədə da, Mãr̰ĩ kaw ha yara àcn̰a dan bədə me ca. Kalna waya da, gun gɨ ta di, ba i gɨ àcn̰e ɗi, me Mãr̰ĩ kaw ha waya anə banə i nə àcn̰e bədə me ca. Kalna dusɨrəng hɨlalna kwandang àcn̰a day dɨwə, me ꞌyeni kaw, Mãr̰ĩ ha kala dusɨw hɨlala àcn̰a dan dɨwə me ca. ");
INSERT INTO sor_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","ꞌYànagɨ́ kwandang mani, me ꞌyeni di kaw, Mãr̰ĩ ha ꞌyàng me ca. Ha wunə ya an̰ji ba u gɨ ɗagɨna dɨ sabɨra ɗengsang gɨ mani ꞌwon daa ꞌyàng nɨm ta de. Əw, i mani nə anə ɨrɨm gɨ mani ꞌyàgɨ́ gɨ kwandang ta di gang me, sanga Mãr̰ĩ ha ɨrməng nɨm lə yande di dige dige me ca.» ");
INSERT INTO sor_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesu cor waygɨ gwale gɨ diri ɗang ba da: «Gun gɨ dɨrəw bu da, sur jaw gɨ dɨrəw bu man man mo? An̰ji surnəw da, cendi ha bwara gubu lə ca dayyə ca bədə mo? ");
INSERT INTO sor_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Aba gɨrsə gun gwale duwa da, ɗoy aba gɨləw gwale di bam mo? Bədə. Me gun gɨ gɨrsɨnə mani ladɨna da, an̰ji ha bwara i gɨ aba gɨləw di. ");
INSERT INTO sor_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Mə yər sogɨlə gɨ hin̰e ɨndər jam dudɨwə me, ɨr̰ɨ cor mə yər habda gɨ geche gɨ gɨr̰angar dudɨm dɨma lə gang ta di bədə, dana mo? ");
INSERT INTO sor_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Cor man me, mə wayɨw chendɨm ba da: “Chendɨn, kal nə um sogɨlə bam dudɨmmə” me, ɨr̰ɨ mə yər habda gɨ geche gɨ gɨr̰angar dudɨmmə di bədə mo? Ɨjɨm gɨ gwale ꞌyol bɨmmə, me dusɨm dɨ korgɨn̰ i jiga gá! U habda gɨ geche gɨ gɨr̰angar dudɨmmə ta di bam kal mə yər mana ladɨ do me, mə uw chendɨm duwa di bam dudɨwə sɨn̰.» ");
INSERT INTO sor_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«Habda gɨ lade da, ha yàa yàa gɨ àcn̰e man mo? Me, habda gɨ àcn̰e da, ha yàa yàa gɨ lade man mo? ");
INSERT INTO sor_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Habda gɨ we we kaw, gɨ ꞌwocn̰ɨw i dara yàa duwa. Gun nem cəə dwaga yàa dɨra mana gɨ chele dɨdə bədə, me gun nem cəə yabɨr̰a yàa duwa mana gɨ garja dɨwə bədə me ca. ");
INSERT INTO sor_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Gun gɨ dusɨw ladɨ da, way i gwale gɨ lade gɨ ꞌwon dusɨw dɨ korgɨn̰ daa, me gun gɨ dusɨw àcn̰ da, way i gwale gɨ àcn̰e gɨ ꞌwon dusɨw dɨ korgɨn̰ daa me ca. Dara gun bɨw da, way i gwale gɨ ꞌwana dusɨw daa.» ");
INSERT INTO sor_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«Anə ꞌwogɨn “Aba ciri nin, Aba ciri nin!” me, anə àl mani nə nə wayang gandagɨ di bədə, dana mo? ");
INSERT INTO sor_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Gun gɨ hane sɨnnə dwayna gwale ni me unəw àlna gɨ giyə da, nə ha gɨləng gun gɨ an̰ji wunɨw di. ");
INSERT INTO sor_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","An̰ji wun i ya gun gaba awa kulu gɨ pol kulu duwa di gɨndɨw ɗungɨ dodə me àsɨ kulu di gɨndɨw sɨn̰a dɨ woye dɨdə ta de. Wála mɨn, kuray biyara gɨ dwana hára ɗɨbə kulu di gɨndɨwə kaw, nem jow bam bədə, dara gɨndɨw di poləl yá dodə cog. ");
INSERT INTO sor_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ɗɨm da, aba dwaya gwale gɨ nə wayɨw di me unəw àlna gɨ giyə bədə da, wun i ya aba àsa kulu duwa daa sɨn̰a dɨdə pəgɨn̰, dɨban pwala gɨ gɨndɨw dodə ta de. Wála gɨ kuray biyara gɨra dɨbə gɨndɨwə mwom da, kulu di jur bam kaláng ɓam, ɨr̰ɨ sɨn̰a wor ꞌyara lə, tandi mɨra.» ");
INSERT INTO sor_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Mana gɨ Jesu way gwale duwa di ꞌyen̰ bam pad nare nə gɨr̰e dɨrəgɨ lə mwom da, an̰ji so ha mana gɨ ciri dɨ Kapernom. ");
INSERT INTO sor_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ciri dɨ ta lə di, kwaya gɨnə asɨngar nə Rom geche day duwa mɨn i mwom gɨ made. Kwaya gɨ ta di, aba ciri duwa ùrɨw nan̰e. ");
INSERT INTO sor_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Mana gɨ geche gɨnə asɨngar day di doy gwale gɨ gɨ way dara Jesu mwom da, an̰ji so kɨjɨw gechide nənə Juwib day yab, ba hana mɨrgɨnəw dara ba hane swanaw kwaya duwa di daa mwommə. ");
INSERT INTO sor_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Mana gɨ cendi gɨra ꞌyo Jesu mwom da, cendi mɨrgɨw ba da: «Geche gɨnə asɨngar day gɨ ta di, i gun gɨ lade nan̰e. Yande da, sow kwaya duwa di daa ɗe! ");
INSERT INTO sor_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Dara an̰ji ùr nare ɨnda nə Juwib nan̰e. I an̰ji me aw kulu gaba amsa Mãr̰ĩ gɨ ka di an̰ju.» ");
INSERT INTO sor_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jesu so ha gandagɨ mɨn. Mana gɨ an̰ji gɨra ib gɨ ciri dɨnə asɨngar geche day duwa lə di mwom da, asɨngar geche day di giyəw kwandaw moso ba hana waynaw da: «Aba ciri ni, kal hwaya sɨm nan̰ ɗi, dara ɨndi da, nə nem gun gɨ mə ha hára dɨmə kɨrə niyə bá bədə. ");
INSERT INTO sor_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","I dara ta di me, nə yər sɨn nə nem hára nɨm gɨ sɨn ni ꞌywam bədə di. Me way gwale mɨn gɨ bɨm mɨra, kal kwaya ni di swana daa. ");
INSERT INTO sor_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nə way yande dara ɨndi kaw, gechide ni ilə dɨnnə, me ɨndi, nə i geche gɨnə asɨngar day me ca. Nə waynaw gɨ mɨn ba hana da, an̰ji ha le. Me nə waynaw gɨ ɗang ba hane da, an̰ji hára le me ca. Me nə waynaw kwaya ni ba àlna mani nə ya ta de kaw, an̰ji àlgɨ̀ le.» ");
INSERT INTO sor_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Mana gɨ Jesu doy gwale gɨnə geche gɨnə asɨngar nə Rom day di mwom da, sɨw ꞌyolɨw gwale duwa gɨ waya di dɨwə, me an̰ji co dɨrəw yər nare nə gɨr̰e nə woni pamaw di me waygɨ ba da: «Dwayna, nə wayang daa: Mana gɨ nare nə Israyel dwar̰agɨ lə da, gun gaba kala dusɨw dɨnnə ya abe gɨ Rom gɨ ta di de da, dii mɨn kaw, nə wor ꞌywaa sɨn̰.» ");
INSERT INTO sor_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Mana gɨ nare nə geche gɨnə asɨngar day kɨjəgɨ di cor ha ulay mwom da, cendi ꞌyo aba mwom di so daa labiya pəgɨn̰. ");
INSERT INTO sor_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Targɨn̰ ɗang da, Jesu so ha mana gɨ ciri dɨ gɨ ꞌwogɨdɨ Nayin. Woni gɨrsə gwale duwa me nare nə gɨr̰e nan̰ me ha gandɨw. ");
INSERT INTO sor_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Mana gɨ an̰ji gɨra ciri bɨdə ib mwom da, ꞌyo nare dɨbala gun gɨ mare dara hára mõw bam. Gun gɨ ta di i deme dɨ wambɨ gorndɨdɨ gɨ mɨn tenene. Nare nə ciri dwar̰ɨ lə nan̰ pam gun gɨ mare di tarɨw me ca. ");
INSERT INTO sor_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Mana gɨ Aba ciri gɨ Jesu yər aba mara di iw da, dɨrəw ꞌyəngɨw me waydɨ ba da: «Kal nulə ɗi.» ");
INSERT INTO sor_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ɨr̰ɨ an̰ji chidɨ gɨra gun gɨ mare di sɨwə ib me ɓɨl jãr̰ĩ di gɨ ɨsəw, ɨr̰ɨ woni ꞌwów di ɗɨbɨ dodə. An̰ji way da: «Dwe gɨ maché, nə wayɨm, so daa!» ");
INSERT INTO sor_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Aba mara di bɨw a daa, so dam daa me way gwale. Mwom da, Jesu wol dwe di ha ꞌyàdɨ iw. ");
INSERT INTO sor_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Nare pad nə yər mani nə ta di, lán̰a àlgɨ̀ nan̰e me ꞌwogɨ Mãr̰ĩ gɨ jilay me way ba da: «Aba cɨmə Mãr̰ĩ bɨw gɨ geche yala lə dwar̰andɨ lə!» me, «Mãr̰ĩ yala dara yara nare duwa me wagɨ lə!» me ca. ");
INSERT INTO sor_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Gwale gɨnə Jesu duwa gɨ ta di nõ duwa nɨm mana gɨ ciri dɨ sɨn̰a dɨnə nare nə Juwib dayyə me sɨn̰a dɨ tulbədɨ lə bá bá me ca. ");
INSERT INTO sor_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Woni gɨrsə gwale gɨnə Jã duwa di kɨbɨw mani nə àlal ta di pad, me an̰ji ꞌwaga nə sɨr kwandagɨ dwar̰agɨ lə, ");
INSERT INTO sor_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","me giygɨ ba hana ùrnə Aba ciri gɨ Jesu an̰ju ba i gun gɨ woni cɨmə Mãr̰ĩ bɨw nə pii ba way ba hára lə di labaa, ba gɨ ɓyadɨna i gun gɨ ɗang mo? ");
INSERT INTO sor_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Mana gɨ cendi ha gɨr Jesu sɨwə ib mwom da, wayɨw da: «I Jã gaba àlagɨ́ nare batem me giyənin ba nə ùrnəmnin da, ɨjɨm ba mə i gun gɨ woni cɨmə Mãr̰ĩ bɨw nə pii way gwale duwa ba hára lə di, labaa nə ɓyadɨnanin i gun gɨ ɗang mo?» ");
INSERT INTO sor_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Mana gɨ ta lə da, Jesu ilə swaa nare nan̰ daa mwom day gɨ dɨrəw jiga jiga lə me, majɨgani dayyə me, nə dúndi dɨ àcn̰e ilə sɨdəgɨ lə kaw, an̰ji ꞌyorgɨ gandɨdɨ bam me, nare nan̰ nə dɨrəgɨ bu kaw, yər mana me ca. ");
INSERT INTO sor_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ɨr̰ɨ, an̰ji cogɨ waygɨ nare nə Jã kɨjəgɨ di ba da: «Cwarna hana waynaw Jã di mani nə anə yərgɨ gɨ dɨrəng me, anə doygɨ gɨ sumdəng me di: Nare nə dɨrəgɨ bu kaw, cor yər mana me, nə majɨgəndɨ kaw, ha daa tɨba tɨba me, nare nə cagɨm àlgɨ kaw, cagɨm sɨr̰ɨbɨ bam sɨdəgɨ lə me, nə sumdəgɨ ɗugɨr kaw, doy gwale me, nə mare kaw, bɨdəgɨ agdɨ daa me, nare nə bugɨr kaw, gɨ waygɨNõ dɨ lademe ca. ");
INSERT INTO sor_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Me gun gɨ dusɨw ina sɨr sɨr dɨnnə bədə da, an̰ji dam i gɨ sii ꞌywala.» ");
INSERT INTO sor_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Mana gɨ nare nə Jã kɨjəgɨ di cor ya ulay ɗɨm da, Jesu waygɨ nare nə gɨr̰e di gwale gɨnə Jã duwa ba da: «Anə ꞌwò dara yara i na mana gɨ dɨn dwar̰ɨ lə di mo? Anə ꞌwò dara yara i dɨrwa gɨ gale gɨgdɨw cow ka me, ka me di mo? Bədə. ");
INSERT INTO sor_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ɓag da, anə ꞌwò dara yara i na mo? Anə ꞌwò dara yara i gun gɨ hurə barge gɨ lade mo? To, nare woni hurba barge gɨ ladɨbe me dam ꞌywala lə me ca da, dam i bɨdang dɨnə dolgə lə gaa bədə mo? ");
INSERT INTO sor_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ɓag da, anə ꞌwò dara yara i na mo? Aba cɨmə Mãr̰ĩ bɨw mo? I sɨdɨ, me nə wayang: Jã i aba cɨmə Mãr̰ĩ bɨw ꞌyang, me an̰ji duwa da, ɗoy aba cɨmə Mãr̰ĩ bɨw bam. ");
INSERT INTO sor_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Dara an̰ji i paja gɨ Mãr̰ĩ way gwale duwa mana gɨ Maktubu duwa lə ba da: “Doy, nə giy paja ni ya lə dɨrəmmə dara ba ɗangr̰ɨnam bɨrmə dɨma bam ladɨ.” ");
INSERT INTO sor_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Dwayna, nə wayang: Mana gɨ nare nə namde yə̀gɨ dodə sɨn̰a dɨdə ka dwar̰agɨ lə da, gun mɨn gɨ geche gaba ɗwaya Jã bam da, ilə bədə. Me wála gɨ caga ka lə da, gun ina gɨ pəgɨn̰ me kalna Mãr̰ĩ lamna dwãr̰ĩ duwa dɨwə da, an̰ji i gɨ geche ɗoy Jã di bam. ");
INSERT INTO sor_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Nare nə pad di me, woni salaw dole gɨ geche gɨ Rom mani me ca nə doy gwale gɨ Jã waygɨ gandɨw da, kal sɨdəgɨ an̰ji àlgɨ batem. Cendi àl yande gɨl nɨm dara Mãr̰ĩ gwale duwa, ba i gwale sɨw. ");
INSERT INTO sor_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ɨr̰ɨ, nare nə Parise me, nare woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa me ca da, gɨn̰ day àla gɨ mani nə Mãr̰ĩ ùr ba a àl gandagɨ di bam. Ta di me, cendi gɨn̰ nɨm àla gɨ batem dɨnə Jã duwa bam di. ");
INSERT INTO sor_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Nare nə caga ka di da, nə ha ꞌwogɨ ɨrməgɨ i gɨ nare nə we mo? Cendi wun i ya nə wi de mo? ");
INSERT INTO sor_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Cendi wun ya dine nə ꞌyəng nə woni dama wun̰jɨ bur̰əgɨ lə me, ꞌwogɨdɨ sɨdəgɨ ka me ka me ba da: “Nə tongnin mani nə too me, anə n̰ar̰ɨ lə diiyə bədə me, nə tongnin diri dɨ made kaw, anə nul lə diiyə bədə me ca.” ");
INSERT INTO sor_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Nə way yande dara, mana gɨ Jã gaba àlagɨ́ nare batem di gɨra duwa lə da, an̰ji wom mani bədə me, chə̀ gani bədə me mwom da, anə way bá, dúndi dɨ àcn̰e ba ilə dɨwə. ");
INSERT INTO sor_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Me mana gɨ ɨndi gɨ Gun gorndɨw, nə gɨra da, nə wom mani me, nə chə̀ gani me ca da, cor anə way ba nə dam i dara wama me chàa gɨ gani me bɨr̰ɨn̰ ɗɨm, ba nə yɨ mɨlan i gɨ woni salaw dole gɨ geche gɨ Rom mani me, nare nə àcn̰e nə ɗang me ca. ");
INSERT INTO sor_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Me nə wayang da: Woni pama dɨrɨn̰ naa nənə Mãr̰ĩ duwa gɨ bɨrmə duwa da, gɨlgɨ nare dara cendi ba i mani nə lade.» ");
INSERT INTO sor_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Abe mɨn gɨ Parise ꞌwogɨ Jesu ba hana wamna mani nə wama gandɨw. An̰ji dɨm kɨrə duwa lə me damgɨ wama bɨwə. ");
INSERT INTO sor_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ɨr̰ɨ deme mɨn dɨ nare pad ꞌwocn̰ɨdɨ dara mani dɨra nə àla nə àcn̰e ilə ciri dɨ ta lə di. Mana gɨ tandi dwaya dara Jesu ba dam lə wama bɨwə kɨrə nə abe gɨ Parise di lə da, jisgɨ yande tandi ꞌwoo mɨrda gɨ lade ɨsədɨ lə me hára nɨm. Mɨrda gɨ ta di, swani gɨ habda gɨ bii ꞌyol nan̰ ꞌwon daa. ");
INSERT INTO sor_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Tandi gɨra ɗɨbɨ Jesu tarɨwə me piy gubɨrədɨ dodə gɨdawə me, nul gura, dɨrədɨ nimi day di ɨn̰ Jesu gɨdaw daa me tandi sarɨw bam gɨ wudɨn̰ nə dɨdɨ, me chichɨm gɨdaw me tidɨrɨw swani gɨdawə me ca. ");
INSERT INTO sor_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Mana gɨ Parise gɨ ꞌwaga Jesu ta di ba yərdɨ yande da, an̰ji ɨrɨm dusɨwə ba da: «Dee gun gɨ ta di inam i aba cɨmə Mãr̰ĩ bɨw ꞌyang da, an̰ji dee ha ꞌwacn̰a dara deme dɨ idɨ ɓɨlbə sɨw ta di, ba i deme dɨ àcn̰e.» ");
INSERT INTO sor_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ɨr̰ɨ, Jesu cor wayɨw da: «Simõ, nə ùr ba nə wayɨm gwale mɨn.» Simõ cow wayɨw ba da: «Way, aba gɨlənin mani.» ");
INSERT INTO sor_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesu wayɨw da: «Wála mɨn, gun mɨn ꞌyàgɨ́ nare sɨr gursɨ kwale. Gɨ mɨn dee ha ꞌywagaw i sag aru aru jii me, gɨ ɗang dee ha ꞌywagaw sag gɨndɨw jii me ca. ");
INSERT INTO sor_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Mana gɨ nare nə ta di ꞌyo gursɨ dɨ idɨ cwaw aba ꞌyàgɨ́ kwale di daa bədə mwom da, an̰ji kalgɨ gursɨ di bam ca dayyə ca. Ɨrmə dɨma lə da, mana gɨ nare nə sɨr nə ta di dwar̰agɨ lə da, i gɨ we me ha ùrə abe gɨ ta di nan̰ mo?» ");
INSERT INTO sor_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simõ cow wayɨw da: «Ɨrmə niyə da, i gun gɨ gɨ kalɨw gursɨ nan̰ bam dɨwə ta di.» Jesu cor wayɨw da: «Mə way i gwale sɨw.» ");
INSERT INTO sor_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ɨr̰ɨ, Jesu co dɨrəw ɨjɨ deme di me wayɨw Simõ da: «Mə yər deme dɨ ta di mo? Nə yala kɨrə dɨma lə kaw, mə ꞌyàn nimi nə sabɨ gɨ gɨdan bam bədə. Me deme dɨ ta di, sabɨn gɨdan bam gɨ nimi nə dɨrədɨ me, sarɨn bam gɨ wudɨn̰ nə dɨdɨ me ca. ");
INSERT INTO sor_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Mana gɨ nə yala nɨm kɨrə dɨma lə da, mə chichɨm gajan bədə. Me deme dɨ ta di hoy chichɨmə gɨ gɨdan bədə. ");
INSERT INTO sor_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ɨjɨm da, mə tidɨrɨn swani dɨnnə bədə me, deme dɨ ta di, tidɨrɨn dɨra swani gɨ bii ꞌyol gɨdannə. ");
INSERT INTO sor_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","I dara ta di me nə wayɨm da: I dara àcn̰a dɨra gɨ nan̰ gɨ biyara bam dɨdə ta di me dusɨdɨ ùrɨn nɨm nan̰ ta di. Me gun gɨ àcn̰a duwa gɨ biyara bam di ina i ɓani da, an̰ji kaw ha ùrə aba biyəw àcn̰a duwa bam di i ɓani me ca.» ");
INSERT INTO sor_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jesu cor waydɨ deme da: «Àcn̰a diya biyər bam dɨyyə ɗɨm.» ");
INSERT INTO sor_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ɨr̰ɨ, nare nə dam gandɨw wama bɨwə mɨn di ùrbɨ sɨdəgɨ ba da: «Gun gɨ ta di i wi me way ba a biygɨ nare àcn̰a day bam di mo?» ");
INSERT INTO sor_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Me Jesu waydɨ deme da: «Də kala dusi dɨnnə da, də ꞌyo bɨlə ɗɨm. Ha labiya!» ");
INSERT INTO sor_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Àl wála ɓani da, Jesu so ha ciri dɨ gechideyə me dɨ dineyə me àsɨgɨ nare berni me waygɨ Nõ dɨ lade dɨ Mãr̰ĩ lam gɨ dwãr̰ĩ duwa di. Woni gɨrsə gwale duwa nə mwaj dii sɨr di ha gandɨw me, ");
INSERT INTO sor_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","namde nə mɨn nə an̰ji ꞌyorgɨ dúndi dɨ àcn̰e bam sɨdəgɨ lə me, nə an̰ji sogɨ daa mwom day gɨ dɨrəw jiga jiga lə me, bow ha gandɨw me ca. Namde nə ta di, i nə Mari dɨ gɨ ꞌwogɨdɨ «Mari dɨ Magdala», dɨ an̰ji ꞌyordɨ dúndi dɨ àcn̰e wurgɨsubu bam sɨdə me, ");
INSERT INTO sor_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Jan dɨnə Kuja gɨ i geche gɨ kɨrə nə dole gɨ Erod lə dyaməw me, Susan me, namde nə ɗang me. Namde nə ta di, day mani day wagɨ nɨm gɨ nə Jesu day gɨ nə woni gɨrsə gwale duwa lə giyə dayyə me ca. ");
INSERT INTO sor_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Nare dayar Jesu sɨwə nan̰ me nə swaa ciriyə jiga jiga kaw, hára dara dwaya gwale duwa me ca. An̰ji so waygɨ gwale gɨ diri ba da: ");
INSERT INTO sor_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Dwayna! Abe mɨn so ba a ha chìgdə swagə yiga lə. Mana gɨ an̰ji ilə chìgdə lə mwom da, swagə dɨrəgɨ nə yab wujabar bor mana gɨ bɨrmə lə me, nare ɗɨrbɨgɨ dodə gɨ gɨdɨragɨ me dirbi nə daa kaw, gɨra tɨgɨgɨ chə́gdɨgɨ bam me ca. ");
INSERT INTO sor_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Swagə dɨrəgɨ nə mɨn da, wujabar day bor mana gɨ gɨndara lə. Cendi dɨm me gɨra woy bam, dara tubɨ ilə gɨndəgɨ lə nan̰ bədə. ");
INSERT INTO sor_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Swagə dɨrəgɨ nə mɨn ɗang bi bor mana gɨ chemde woni jimdi dwar̰agɨ lə, chemde di so yɨgɨ daa swamama ɨmgɨ jwara bam. ");
INSERT INTO sor_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Me swagə dɨrəgɨ nə mɨn bor mana gɨ sɨn̰a dɨ ladeyə. Cendi dɨm jor ladɨ me naa dɨrəgɨ me ca. Swagə nə ta di dɨdəgɨ mɨn da, dɨrəgɨ ꞌyarbar nem ya aru de.» Ɨr̰ɨ Jesu way gɨ mar̰ɨjaw daa nan̰ ba da: «Gun gɨ sumdəw woni dwaya gwale ina lə da, kal a dwayna.» ");
INSERT INTO sor_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Woni gɨrsə gwale gɨnə Jesu duwa di ùrɨw gwale gɨ diri gɨ ta di gɨndɨw. ");
INSERT INTO sor_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesu waygɨ ba da: «ꞌYeni da, Mãr̰ĩ àl gandang ladni; an̰ji gɨləng gwale sɨw gɨ budə lə dara lama duwa gɨ dwãr̰ĩ di ɗɨm. Me nare nə ɗang da, nə waygɨ gandɨw i gɨ gwale gɨ diri. Yande da, cendi un̰bɨ me yər bədə, domən̰dɨ me doy bədə me ca. ");
INSERT INTO sor_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Me dwayna gwale gɨ diri gɨ ta di gɨndɨw. Swagə da, i gwale gɨnə Mãr̰ĩ duwa. ");
INSERT INTO sor_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Swagə woni bwara bɨrmə lə da, i nare nə doy gwale gɨnə Mãr̰ĩ duwa me Sidan biyɨw bam dusɨrəgɨ lə ɨmgɨ kala gɨ dusɨrəgɨ dɨ idɨ ꞌywaa gɨ bɨlə bam. ");
INSERT INTO sor_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Swagə woni bwara gɨndara lə da, i nare nə doy gwale gɨnə Mãr̰ĩ duwa gɨ sii ꞌywala mɨ̀ndagɨ me, cendi kal gwale di bo sabɨraw dusɨrəgɨ lə bədə. Cendi kal dusɨrəgɨ Mãr̰ĩ dɨwə wála ɓani mɨra, me wála gɨ Sidan gɨrsɨnəgɨ mwom da, cendi wà gɨn̰ gwale gɨnə Mãr̰ĩ di bam. ");
INSERT INTO sor_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Swagə nə wujabar bor mana gɨ chemde woni jimdi dwar̰agɨ lə da, i nare nə doy gwale gɨnə Mãr̰ĩ duwa ladɨ me cor ha mana dayyə. Ɨrmə gɨ gwale me, mál me, ꞌywala gɨ sɨn̰a dɨdə me yɨgɨ daa swamama ɨmgɨ jwara me naa gɨ dɨdəgɨ bam me ca. ");
INSERT INTO sor_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Swagə nə bor mana gɨ sɨn̰a dɨ ladeyə da, i nare nə doy gwale gɨnə Mãr̰ĩ duwa me yɨw gɨ dusɨrəgɨ dɨ wuse her, cendi yɨ gwale gɨ ta di gɨ ɨsɨragɨ sɨr me, ɗɨbɨ woy nɨm me, ha nɨm pii pii me bo gɨ dɨrəgɨ nan̰ me ca.» ");
INSERT INTO sor_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Jesu waygɨ ɗang bi ba da: «Gun gɨr dùwa lamba lə me ɨbədɨ mani dɨdə lə bədə me, udɨ chɨ́dɨ solbə gɨndəgɨ lə bədə me ca. Me ɓag da, gɨ udɨ chɨ́dɨ i daa mani dɨdəgɨ lə daa dara ba ácn̰anagɨ nare woni dɨmə kulə mana. ");
INSERT INTO sor_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","I sɨdɨ, mani nə i budɨ lə caga ka da, ɗan̰ gɨ ha yaragɨ daa pɨden̰yə me, mani nə nare ùr kwandagɨ ba ꞌwacn̰ana bədə kaw, ɗan̰ Mãr̰ĩ ha gɨləgɨ daa pɨden̰yə me ca. ");
INSERT INTO sor_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Yande da, àsɨna angal dan mana gɨ gwale gɨ nə ilə wayawə di, dara gun gɨ mani duwa ina lə da, gɨ ha ꞌyàw lə diiyə bi me, gun gɨ mani duwa ina lə bədə da, mani nə hin̰e nə an̰ji ɨrɨm ba ꞌyogɨ ta di kaw, gɨ ha ꞌwógɨ i bam me ca.» ");
INSERT INTO sor_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesu iw me chamraw me hára ba gɨ ꞌyowe, me cendi ꞌyo bɨrmə gaba chidə hára sɨwə ib bədə, dara nare ꞌyarbar nan̰e. ");
INSERT INTO sor_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Gɨ gɨra wayɨw da: «Im me chamram me ɗɨbɨgɨ lə iche ùr ba gɨ ꞌyomme.» ");
INSERT INTO sor_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ɨr̰ɨ Jesu cogɨ waygɨ da: «In me chamran me da, i nare woni dwaya gwale gɨnə Mãr̰ĩ duwa me uw àl gɨ giyə me di.» ");
INSERT INTO sor_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Wála mɨn, Jesu nagɨ dam bɨrwa lə gɨ nə woni gɨrsə gwale duwa mɨn me, an̰ji waygɨ da: «Cilangɨnandɨ kuray gɨ ɓɨle, hanandɨ dugdɨw dɨ alə ta lə!» Me cendi hargɨ. ");
INSERT INTO sor_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Mana gɨ cendi ilə ꞌwaya bɨrwa hára nɨmə da, Jesu i duwa nuni. Ɨr̰ɨ gale gɨ geche biyara gɨra u nimi bo bɨrwa dalawə ꞌwon daa àl dara ɗwanda le. ");
INSERT INTO sor_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Woni gɨrsə gwale duwa di chidɨbə sɨwə ib ib me, nuw daa, me wayɨw da: «Aba ciri nin, aba ciri nin, də ilə marangə!» An̰ji a daa me ɨr̰ɨn̰ gale day gɨ nimi di me, cendi ɗɨbɨ dodə ɗeg me mana cor hɨlal kajaj. ");
INSERT INTO sor_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ɨr̰ɨ an̰ji waygɨ da: «Ta di me dusi dan dɨ kala di ilə we dɨra mo?» Cendi lán̰a àlgɨ̀ me, mani di ꞌyàgɨ́ ɨrmə nan̰e me, wajɨbɨ gwale bulə dayyə ba da: «Gun gɨ ta di i wi ɓag mo? An̰ji ɨr̰ɨn̰ gale me nimi me kaw, cendi doy gwale bɨwə!» ");
INSERT INTO sor_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Mana gɨ Jesu day gɨ nə woni gɨrsə gwale duwa cilangɨ kuray gɨ ɓɨle di mwom da, cendi gɨrgɨ sɨn̰a dɨ nare nə Gerasa day dɨ i wama gɨ Galile dɨrəwə tɨba ta di. ");
INSERT INTO sor_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Mana gɨ Jesu chə́ə bɨrwa lə bo gɨdaw dodə sɨn̰a lə mwom da, gun mɨn gɨ ciri dɨ ta lə gɨ dúndi dɨ àcn̰e nan̰ widɨbɨw hára saw dɨrəw daa. Gun gɨ ta di àl aliya nan̰ hurə barge sɨwə bədə me, dam ulay bədə me ca. Mana duwa gɨ dama da, i munɨniyə. ");
INSERT INTO sor_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Abe gɨ ta di, dúndi dɨ àcn̰e di gɨlɨw dɨrəw i ɓɨgden̰ nan̰e, gɨ bow sul ɨsawə me kaya kaya gɨdawə me kaw, an̰ji agdɨgɨ bam me, dúndi dɨ àcn̰e di uw ha nɨm bam dɨn dwar̰ɨ lə. Mana gɨ an̰ji yara Jesu hára lə mwom da, hára əbər dodə dɨrəwə soy gura me way gwale mar̰ɨjaw daa nan̰ ba da: «Ɨjɨm, Jesu gɨnə Mãr̰ĩ gaba dama mani pad dɨdəgɨ lə gorndɨw, mə ùr i na sɨnnə mo? Nə amsɨm ɗe: Kal gɨlən dɨrən ɗi!» Abe gɨ ta di way yande dara Jesu waydɨ dúndi dɨ àcn̰e di ba dɨmnə bam sɨwə. ");
INSERT INTO sor_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ɨr̰ɨ Jesu ùrɨw ba da: «Gɨ ꞌwogɨm man mo?» An̰ji wayɨw da: «Gɨ ꞌwogɨn Gɨr̰ə.» Abe di way yande dara dúndi dɨ àcn̰e dɨ gɨlɨw dɨrəw di, gɨr̰ɨ nan̰e sɨwə. ");
INSERT INTO sor_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Dúndi dɨ àcn̰e di amsɨ Jesu ba ꞌywarnagɨ bwanagɨ bengə bədə. ");
INSERT INTO sor_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Mana gɨ ta di tulɨwə da, gochəng gɨmər ilə wama lə kur̰a dɨdə me, gochəng di gɨr̰ɨ le. Dúndi dɨ àcn̰e di mɨrgɨw Jesu ba kalnagɨ ba gɨ ha gochəng sɨdə me, an̰ji kalgɨ ha. ");
INSERT INTO sor_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Dúndi dɨ àcn̰e di dɨmə bam gun di sɨwə ha bwara gochəng sɨdə me, gochəng dɨ gɨr̰e di ɓɨr̰ɨn̰ daa kur̰a dɨdə wada bor kurayyə chə̀ nimi marbɨ bam. ");
INSERT INTO sor_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Mana gɨ nare woni gama gochəng di ba gɨ yər mani nə àlal ta di da, cendi wà ha ciri dɨ gechideyə me dɨ dineyə me cɨməgɨ nare mani nə àlal di gwale day. ");
INSERT INTO sor_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Nare di dɨmə hára dara yara mani nə àlal ta di gɨ dɨrəgɨ. Mana gɨ cendi gɨra Jesu tulɨwə ib da, cendi yər abe gɨ dúndi dɨ àcn̰e dɨm bam sɨwə di dam lə dodə, dɨrəw biyər dodə, hurə barge sɨwə, cor lán̰a àlgɨ̀ le. ");
INSERT INTO sor_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Nare woni yara mani nə àlal di gɨ dɨrəgɨ da, kɨbɨgɨ kwandagɨ ba i man me aba widɨbə di dɨrəw ba biyər dodə ɗɨm mo. ");
INSERT INTO sor_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Mana gɨ ta lə di, nare nə sɨn̰a dɨ Gerasa lə pad amsɨ Jesu ba hana kalnagɨ sɨn̰a day ɗi, dara cendi lán̰a àlgɨ̀ nan̰e. Ɨr̰ɨ Jesu so ba a ha ajila daa bɨrwa lə dara ba a ha le. ");
INSERT INTO sor_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mana gɨ Jesu ilə hára lə mwom da, abe gɨ dúndi dɨ àcn̰e dɨm bam sɨwə di amsɨw ba kalnaw ba a ha gandɨw me, Jesu wayɨw da: «Bədə, ");
INSERT INTO sor_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","cor ha ulay dɨma lə me mə ha kɨbəgɨ nare mani nə Mãr̰ĩ àl gandɨm ta di daa pad.» Ɨr̰ɨ abe gɨ ta di so ha cɨmdəgɨ nare mani nə Jesu àl gandɨw ta di mana gɨ ciriyə pad. ");
INSERT INTO sor_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Mana gɨ Jesu cwara hára kuray dugdɨw dɨ ka lə bi da, nare nə gɨr̰e saw dɨrəw daa dara cendi dee dam ɓedɨw lə dodə. ");
INSERT INTO sor_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Mana gɨ ta lə da, abe mɨn gɨ gɨ ꞌwogɨw Jayrus gɨra. Abe gɨ ta di i geche gɨnə kulu gaba amsa Mãr̰ĩ gɨnə nare nə Juwib day. An̰ji hára gɨra piy gubɨrəw dodə Jesu dɨrəwə me amsɨw ba hane kɨrə duwa lə, ");
INSERT INTO sor_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","dara durməw dɨ mɨn tenene dɨ aliya dɨra nem i ya mwaj dii sɨr de di ba àl dara mara le. Jesu ɨndər dara hára kɨrə nə abeyə di me, nare nə gɨr̰e di dɨmdɨw daa ka me, ka me. ");
INSERT INTO sor_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nare di dwar̰agɨ lə da, deme mɨn dɨ bare ha sɨdə àl aliya mwaj dii sɨr ilə. Tandi mendɨ ɨsədɨ bam nan̰ harba gɨ dogtər sɨdəgɨ lə kaw, mwom dɨra di hoydɨ bədə. ");
INSERT INTO sor_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Tandi kwanga Jesu tarɨwə gɨra ɓɨl chire gɨ barge duwa bɨwə, me mana gɨ ta lə dog bare di ha sɨdə bədə ɗɨm. ");
INSERT INTO sor_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ɨr̰ɨ Jesu ùr nare di da: «I wi me ɓɨlɨn mo?» Cendi pad bɨl bɨdəgɨ sarni me, Piyer wayɨw da: «Aba ciri ni, nare nə gɨr̰e nə liwɨm daa dɨmdɨm ka me, ka me, ta me, mə ùr aba ɓɨləm ɗang tugu mo?» ");
INSERT INTO sor_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ɨr̰ɨ Jesu waygɨ da: «Gun ɓɨlɨnne. Nə yər dwana ni dɨ yab dɨm bam.» ");
INSERT INTO sor_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Deme dɨ ta di yər dara gɨndɨdɨ ba biyər i daa da, sɨdɨ sadɨdɨ tag tag me, hára gɨra piy gubɨrədɨ dodə Jesu dɨrəwə, kɨbɨw gwale dɨra daa nare dɨrəgɨ lə pad dara na me ba dɨ ɓɨl barge duwa bɨw me i man me ba dɨ ꞌyo gɨ labiya di dog me mo. ");
INSERT INTO sor_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesu waydɨ da: «Chidɨn, də kala dusi dɨnnə da, də ꞌyo labiya ɗɨm. Ha le labiya!» ");
INSERT INTO sor_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Mana gɨ Jesu ilə wayadɨ deme gwale di lə jang sɨn̰ da, gun swaa kɨrə nə Jayrus lə gɨra wayɨw Jayrus di ba da: «Durməm di mare ɗɨm. Hoy aba gɨləndɨ mani hára lə ɗang bədə ɗɨm.» ");
INSERT INTO sor_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ɨr̰ɨ Jesu doy gwale gɨ ta di me wayɨw Jayrus ba da: «Kal àla lán̰a ɗi, kal dusɨm mɨn dɨnnə, me durməm di ha swaa daa pəgɨn̰.» ");
INSERT INTO sor_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Mana gɨ Jesu gɨra kɨrə nə Jayrus lə mwom da, an̰ji ɨmgɨ nare dɨmə gandɨw kulə bam, an̰ji kal i Piyer me Jã me Jak me dwe di abadɨ me idɨ me mɨra ha gandɨw. ");
INSERT INTO sor_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Nare pad bo gura me àl n̰agɨni me dara dwe di, ɨr̰ɨ Jesu waygɨ da: «Kalna nulə ɗi, tandi mare bədə me, i i nuni.» ");
INSERT INTO sor_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ɨr̰ɨ nare di àlɨ̀w məng, dara cendi ꞌwocn̰ dara tandi ba mare ꞌyang. ");
INSERT INTO sor_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ɨr̰ɨ Jesu yɨ dwe di ɨsədɨ me waydɨ gɨ mar̰ɨjaw daa nan̰ ba da: «Durmən, so daa!» ");
INSERT INTO sor_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Tandi bɨdɨ a daa me so daa dog. Jesu waygɨ war̰adɨ di cendi ba ꞌyànadɨ́ mani nə wama. ");
INSERT INTO sor_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","War̰adɨ di, yɨbdɨ dɨdəgɨ me, ɗɨbɨ yər kəmə duwa. Ɨr̰ɨ Jesu yəgdɨ sumdəgɨ cendi ba cɨmnəw gun mani nə àlal ta di daa bədə. ");
INSERT INTO sor_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Targɨn̰ ɗang da, Jesu ꞌwaga paja duwa nə mwaj dii sɨr sɨwə me, ꞌyàgɨ́ dwana me gasɨnani dɨ idɨ ꞌywara dúndi dɨ àcn̰e bam nare sɨdəgɨ lə me, swaa gɨ nare daa mwom dayyə me ca. ");
INSERT INTO sor_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ɨr̰ɨ an̰ji kɨjɨgɨ ba hana àsɨnagɨ nare berni dɨnə dwãr̰ĩ dɨnə Mãr̰ĩ duwa me, ba swana nare daa mwom dayyə me ca. ");
INSERT INTO sor_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Me an̰ji waygɨ da: «Anə ilə hára lə da, unə mani mɨn ɨsɨrangə bədə: cilang bədə me, magɨla bədə me, sadɨ bədə, me gursɨ bədə, me layna gumaj sɨr sɨr bədə me ca. ");
INSERT INTO sor_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ciri dɨ anə dɨmnə lə me, gun ꞌwagɨnang hana nɨm kɨrə duwa lə da, damna lə kɨrə ta di jang, bɨraa swaa dan gaba hára ciri dɨ ɗangə bá. ");
INSERT INTO sor_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Mana gɨ ciri dɨ anə dɨmnə lə me nare dɨra yɨnəng sɨdəgɨ lə bədə da, ɓɨr̰ɨn̰ɨnə hana pii me, ɓwabɨnagɨ usɨsɨ gɨ gɨdɨrangə kalnagɨ dodə. Ta di ha gɨləgɨ dara Mãr̰ĩ dusɨw ba nawe dɨdəgɨ lə.» ");
INSERT INTO sor_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","I yande me paja nənə Jesu duwa sogɨ ha nɨm ciriyə bá bá. Ciri dɨ we we dɨ cendi dɨmnə lə da, way Nõ dɨ lade dɨnə Mãr̰ĩ duwa me, so nare daa mwom dayyə me ca. ");
INSERT INTO sor_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Wála gɨ ta di lə da, Erod Antipas gɨ i dole gɨ wama gɨ Galileyə doy gwale gɨ gɨ way dara mani nə Jesu àlgɨ̀ pad ta di me, dusɨw cubɨw nan̰e. Dara nare nə yab way da, Jesu di,  ba i Jã Batis me ba dɨmə daa nare nə mare dwar̰agɨ lə me, ");
INSERT INTO sor_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","nare nə mɨn way day ba i aba cɨmə Mãr̰ĩ bɨw gɨ pii gɨ gɨ ꞌwogɨw Eli me ba cwara yala an̰ju, nə mɨn ɗang way day ba i woni cɨmə Mãr̰ĩ bɨw nə pii gun day gɨ mɨn ɗang me ba dɨmə daa nare nə mare dwar̰agɨ lə an̰ju. ");
INSERT INTO sor_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Erod way da: «Jã di, nə ꞌwocn̰ dara an̰ji mar bam, dara i ɨndi sɨn ni me tanga nə waygɨ nare yɨw saw dɨw bam ka me, gun gɨ gɨ way gwale duwa ta di, i wi ɗang tugu mo?» Me an̰ji kan̰jɨ bɨrmə ùr ba yər Jesu di. ");
INSERT INTO sor_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Wála gɨ paja nənə Jesu duwa nə an̰ji kɨjɨgɨ di cwara gɨra da, kɨbɨw mani nə cendi ba gɨ àlagɨ̀ pad di daa me, an̰ji wolgɨ ha nɨm bam mɨ́ndagɨ ciri dɨ gɨ ꞌwogɨdɨ Besada tuldɨ lə ib. ");
INSERT INTO sor_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ɨr̰ɨ nare nə gɨr̰e doy gwale duwa me pamɨw tarɨwə. An̰ji yɨgɨ sɨwə waygɨ gwale gɨnə dwãr̰ĩ dɨnə Mãr̰ĩ duwa me, nare woni ùrə labiya da, an̰ji sogɨ daa mwom dayyə me ca. ");
INSERT INTO sor_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Mana gɨ dawa àl dara ɗwanda mwom da, paja nənə Jesu duwa nə mwaj dii sɨr di gɨra ꞌyow me wayɨw da: «Cəgdɨ nare di daa ɗɨm, kalgɨ gɨ hana ciri dɨ gechideyə me dɨ dineyə me dɨ i tulbəndɨ lə ta di, gɨ hana kan̰ja mana gɨ ꞌya me mani nə wama me, dara ka di, də ꞌyang i bam dɨn dwar̰ɨ lə.» ");
INSERT INTO sor_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Me Jesu cogɨ waygɨ da: «ꞌYànagɨ́ mani nə wama di ꞌyeni gang.» Cendi cor wayɨw da: «Ɨsɨraninnə ka da, i mapa jii me gòche sɨr me mɨra. Mə ùr dara ba nə hananin kɨlnəgɨ nare nə gɨr̰e nə ta di mani nə wama wunəgɨ mo?» ");
INSERT INTO sor_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Nare nə ta di dwar̰agɨ lə da, nare nə abje nem ya dubu jii de. Ɨr̰ɨ Jesu waygɨ woni gɨrsə gwale duwa ba da: «Kalnagɨ gɨ damna dodə sabarna ya nare gɨnɨn̰ jii jii de.» ");
INSERT INTO sor_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Woni gɨrsə gwale duwa di doy gwale bɨwə me kalgɨ dam dodə pad dayyə. ");
INSERT INTO sor_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jesu lay mapa gɨ jii di me gòche nə sɨr di me ɨsəwə, me u dɨrəw daa àlɨ́w Mãr̰ĩ dóche dara mani nə wama nə ta di. An̰ji ɓolbɨ mapa di me gòche di me dodə me ꞌyàgɨ́ woni gɨrsə gwale duwa ɨsɨgɨ nare nə gɨr̰e nə ta di. ");
INSERT INTO sor_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nare di pad wom ɨbdə me, gɨndɨw wor dodə, gɨ lay ꞌwonbɨ kɨrangé mwaj dii sɨr daa. ");
INSERT INTO sor_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Wála mɨn, Jesu ilə amsa Mãr̰ĩyə bam hin̰e me, woni gɨrsə gwale duwa ilə gandɨw me ca. An̰ji ùrgɨ ba da: «Caga da, nare nə gɨr̰e di way ba nə i wi ɓag mo?» ");
INSERT INTO sor_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Cendi cow wayɨw da: «Nare nə mɨn da, way ba mə i Jã gaba àlagɨ́ nare batem, nə mɨn way day ba mə i aba cɨmə Mãr̰ĩ bɨw gɨ Eli me, nə mɨn ɗang way day ba mə i woni cɨmə Mãr̰ĩ bɨw nə pii gun day gɨ mɨn ɗang me ba dɨmə daa nare nə mare dwar̰agɨ lə.» ");
INSERT INTO sor_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ɨr̰ɨ Jesu cor ùrgɨ da: «Me ꞌyeni da, anə ɨrɨm dan ba nə i wi mo?» Piyer cow wayɨw da: «Ɨjɨm, mə i dole gɨ Mãr̰ĩ biyəw gɨ Kris di.» ");
INSERT INTO sor_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Me Jesu yəgdɨ sumdəgɨ dara cendi ba cɨmnəw gun mɨn kaw gwale gɨ ta di daa bədə me, ");
INSERT INTO sor_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","an̰ji cor waygɨ ɗang: «Ɨndi gɨ Gun gorndɨw di, ha ùrən i gɨlə gɨ dɨrɨn̰ nan̰e. Gechide nənə nare nə Juwib day me, woni bwasa Mãr̰ĩ gechide day me, woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa me, ha gɨn̰ən bam. Gɨ ha ꞌyán bam me, wála gɨ subu lə da, nə ha dɨmə daa munɨ lə.» ");
INSERT INTO sor_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ɨr̰ɨ Jesu waygɨ nare nə pad di ba da: «Gun gɨ ùrnə ba a pamna tarɨn da, kal a ɨrmɨnə dɨw duwa lə an̰ju gang bədə, a unə habda duwa gɨ dagɨla dɨwə gɨ wála bá bá me pamnan nɨm. ");
INSERT INTO sor_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Dara gun gɨ ùrnə bɨlə gɨ sɨw duwa dodə sɨn̰a dɨdə ka da, an̰ji ha nwala bɨlə duwa gaba dama gɨ dɨrəw bɨr̰ɨn̰ di bam, me gun gɨ gɨn̰ɨnə bɨlə duwa gɨ sɨn̰a dɨdə ka di bam dara daran da, an̰ji ha ꞌywaa bɨlə gaba dama gɨ dɨrəw bɨr̰ɨn̰ di le. ");
INSERT INTO sor_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Gun da, dee ꞌywana mani nə sɨn̰a dɨdə ka pad le, me ꞌywana bɨlə gaba dama gɨ dɨrəw bɨr̰ɨn̰ di bədə labaa myandɨna dúndɨw bam da, ladni duwa ilə na lə mo? ");
INSERT INTO sor_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Gun gɨ lán̰ɨna waya ba a i gun ni me ba a kal dusɨw gwale niyə me da, ɨndi gɨ Gun gorndɨw di kaw, sanga wála gɨ nə cwarnay gɨ ꞌywagda ni me ꞌywagda gɨnə Aban duwa me gɨ nə paja duwa nə daa day me ca da, nə ha waya an̰ju ba i gun ni bədə me ca. ");
INSERT INTO sor_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Dwayna, nə wayang i gwale sɨw: Nare nə yab nə ilə dwar̰angə caga ka di, cendi ha yara dwãr̰ĩ dɨnə Mãr̰ĩ duwa gɨ dɨrəgɨ do me cendi ha mara sɨn̰.» ");
INSERT INTO sor_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Mana gɨ Jesu way gwale gɨ ta di nem ya wála dunasɨr de da, an̰ji wol Piyer me Jã me Jak me, cendi nagɨgɨ ha daa kur̰a dɨdə dara amsa gɨ Mãr̰ĩ. ");
INSERT INTO sor_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Mana gɨ an̰ji ilə amsa Mãr̰ĩyə da, dɨrəw cor kɨlangar wun jiga me, barge duwa gɨdɨ burage kəng me ꞌyogdɨ nan̰ me ca. ");
INSERT INTO sor_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Mana gɨ ta lə jisgɨ yande da, nare sɨr ɗɨbɨ ilə waya gwaleyə gandɨw. Nare nə ta di i woni cɨmə Mãr̰ĩ bɨw nə pii nə Moyis day gɨ Eli. ");
INSERT INTO sor_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Cendi dɨmə gɨ ꞌywagda gɨnə Mãr̰ĩ sɨdəgɨ lə me, way gwale gɨ Jesu dara made dɨ ɗan̰ an̰ju ba ha maradɨ mana gɨ Jursalem dara ꞌyan̰a gɨ giyə duwa di. ");
INSERT INTO sor_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Mana gɨ ta lə da, Piyer day gɨ nə kwandaw nə sɨr di bor igɨ i nuni me, mana gɨ dɨrəgɨ a daa mwom da, cendi yər ꞌywagda gɨnə Jesu duwa me, nare nə sɨr nə ɗɨbɨ gandɨw di me ca. ");
INSERT INTO sor_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Mana gɨ nare nə sɨr di ilə hára lə mwom da, Piyer wayɨw Jesu da: «Aba ciri nin, dama ɨnda gɨ ka di da, ladɨ nan̰e. Kalnin nə ɗangr̰ɨnin kundi subu; mɨn dɨma me, mɨn Moyis duwa me, mɨn Eli duwa me ca.» Me an̰ji ꞌwocn̰ gwale gɨ wayɨw ta di gɨndɨw bədə. ");
INSERT INTO sor_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Mana gɨ an̰ji ilə waya gwaleyə mwom da, siyaya swaa mugɨ daa gwam, me mana gɨ cendi ɗɨbə siyaya dalawə da, woni gɨrsə gwale duwa di, lán̰a àlgɨ̀ le. ");
INSERT INTO sor_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Gun mɨn mar̰ɨjaw nɨmə daa siyaya lə ba da: «Ta di me i gorndɨn, i an̰ji me nə biyəw. Dwayna gwale bɨwə!» ");
INSERT INTO sor_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Mana gɨ gun mar̰ɨjaw di nɨm bam mwom da, gun mɨn kaw, ilə bədə, wor i Jesu mɨnaw mɨn tenene. Woni gɨrsə gwale duwa di, dam bɨdəgɨ mɨgɨmi wála gɨ ta lə di me, cɨmɨw gun mɨn mani nə cendi yərgɨ di daa bədə. ");
INSERT INTO sor_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Sanga dɨra da, Jesu day gɨ nə woni gɨrsə gwale duwa swagɨ daa kur̰a dɨdə. Mana gɨ cendi ilə chə́gdə dodə da, nare nə gɨr̰e nan̰ hára gɨra ꞌyow. ");
INSERT INTO sor_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Mana gɨ nare nə gɨr̰e di dwar̰agɨ lə da, gun mɨn soy mar̰ɨjaw daa nan̰ ba da: «Aba gɨlənin mani, nə amsɨm, yər gorndɨn de! I an̰ji mɨn tenene duwa lə. ");
INSERT INTO sor_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Me dúndi dɨ àcn̰e àlbɨwe. Wála gɨ swanaw mwom da, an̰ji soy gura me, dúndi di uw ɨndəw dodə me, habdɨ dodə, me bɨw sugdɨ le me, kalɨw kaláng bədə me ca. Àlɨw kalɨw i made bɨdə bá. ");
INSERT INTO sor_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nə amsɨ woni gɨrsə gwale dɨma ba ꞌywarnaw dúndi di bam kaw, cendi nem ꞌywaradɨ bədə.» ");
INSERT INTO sor_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesu waygɨ da: «Hay! ꞌYeni nare nə àcn̰e nə kal dusɨrəng dɨnnə bədə me nə gá! Nə ha dama gandang àla wála ɨndi na mo? Nə ha ꞌwóng dɨn bam bɨraa mindi na mo?» Ɨr̰ɨ an̰ji wayɨw abe di ba hane gɨ gorndɨw di kwa. ");
INSERT INTO sor_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Mana gɨ dwe di ilə hára dara ꞌywaa Jesu da, dúndi dɨ àcn̰e di uw ɨndəw dodə sɨn̰a lə me habdɨ me ca. Jesu ɨr̰ɨn̰ dúndi dɨ àcn̰e di gɨ dwana ba dɨmnə bam dwe di sɨwə. An̰ji so dwe di daa me yɨw ꞌyàw gandɨw abəw. ");
INSERT INTO sor_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Nare pad nə yər mani nə ta di, yɨbdɨ dɨdəgɨ dara Mãr̰ĩ ba i gun gɨ geche. Mana gɨ nare worgɨ lə yɨbə dɨdəgɨ lə dara mani nə Jesu àlgɨ̀ di sɨn̰ da, an̰ji waygɨ woni gɨrsə gwale duwa ba da: ");
INSERT INTO sor_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Kalna sumdəng ladɨna dwayna gwale gɨ nə ilə wayangə: Ɨndi gɨ Gun gorndɨw da, gɨ ha yə̀n ꞌyàgɨ́ nare ɨsɨragɨ lə.» ");
INSERT INTO sor_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Me woni gɨrsə gwale duwa di ꞌwocn̰ gwale gɨ ta di gɨndɨw bədə. Gɨ budɨgɨ gandɨw dodə dara cendi ba ꞌwacn̰ana gɨndɨw daa bədə me, cendi lán̰ ùrə gɨ Jesu gwale gɨ ta di gɨndɨw me ca. ");
INSERT INTO sor_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ɨr̰ɨ woni gɨrsə gwale gɨnə Jesu duwaso ilə gaga gwaleyə bá, dwar̰agɨ lə ka da, i wi me ba i geche mo? ");
INSERT INTO sor_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesu ꞌwocn̰ gwale gɨ cendi ilə ɨrmə lə dusɨrəgɨ lə com mwom da, an̰ji ꞌwoo dwe gɨ ꞌyəng gɨra chɨ́w tulɨwə ");
INSERT INTO sor_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","me, waygɨ da: «Gun gɨ yɨnə dwe gɨ ꞌyəng gɨ ta di gɨ dwani gɨ sumɨn da, yɨn i ɨndi gɨ dwani me, gun gɨ yɨnən ɨndi gɨ dwani da, yɨ i aba giyən di me ca. Dwayna, gun gɨ àsɨna dɨw dodə ꞌyeni nə pad ka di dwar̰angə da, i gun gɨ geche an̰ju.» ");
INSERT INTO sor_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Mana gɨ ta lə da, Jã u gwale way ba da: «Aba ciri nin, dee nə yaranin gun mɨn ꞌywara dúndi dɨ àcn̰e bam nare sɨdəgɨ lə gɨ sumɨm me, nə kan̰janin ba nə ɨməwnin bam, dara an̰ji ilə pamammə gandanin mɨn bədə.» ");
INSERT INTO sor_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesu cow wayɨw da: «Ɨmnəw bam bədə, dara gun gɨ ɨlnəng bədə da, an̰ji i gun dan.» ");
INSERT INTO sor_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Wála gɨnə Jesu duwa gɨ ba gɨ ha biyəw hára nɨm daa di wor ib ɗɨm da, an̰ji way ba, wamna sii ya man de kaw, ba a ha i mana gɨ ciri dɨJursalem bá. ");
INSERT INTO sor_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","An̰ji kɨjɨ nare ba hana dɨrəwə pii. Cendi ha me gɨrgɨ mana gɨ ciri mɨn dɨ wama gɨ Samariyə ba gɨ ha ɗangr̰aw mana dɨrəwə pii. ");
INSERT INTO sor_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ɨr̰ɨ nare nə Samari di gɨn̰ yə̀w sɨdəgɨ lə bam, dara an̰ji ùr ba a ha i Jursalem. ");
INSERT INTO sor_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Mana gɨ woni gɨrsə gwale duwa nə Jã day gɨ Jak doy gwale gɨ ta di mwom da, cendi way da: «Aba ciri nin, mə ùr ba nə waynanin dara dùwa dɨ daa ba hane ulnəgɨ bam gɨdɨnəgɨ dɨbɨrɨn̰ mo?» ");
INSERT INTO sor_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jesu co dɨrəw dɨdəgɨ lə me àlgɨ́ gwale nan̰e. ");
INSERT INTO sor_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ɨr̰ɨ cendi cɨmgɨ hargɨ ciri dɨ ɗangə. ");
INSERT INTO sor_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Mana gɨ cendi ilə hára lə bɨrmə lə da, gun mɨn wayɨw Jesu ba da: «Mana gɨ we we gɨ mə hana lə kaw, nə ha pama i tarɨm.» ");
INSERT INTO sor_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesu cow wayɨw da: «Babasa kaw, gubdɨr̰i day gaba ꞌya ilə me, dirbi nə daa kaw, ciri day ilə me ca. Ɗɨm da, ɨndi gɨ Gun gorndɨw da, mana ni gɨ sɨn gaba hura dɨn ilə bədə.» ");
INSERT INTO sor_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jesu wayɨw gun mɨn ɗang: «Pam tarɨn!» Gun di wayɨw da: «Aba ciri ni, kalɨn bɨrmə nə ha mõõ aban bam do.» ");
INSERT INTO sor_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesu cow wayɨw ba da: «Kal nare nə mare munə made day cendi, me ɨjɨm da, ha àsagɨ nare berni dɨnə dwãr̰ĩ dɨnə Mãr̰ĩ duwa.» ");
INSERT INTO sor_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Gun gɨ mɨn ɗang wayɨw da: «Aba ciri ni, nə ha pamamme. Ɗɨm da, kalɨn nə ha cɨməgɨ nare nə kɨrə niyə daa do.» ");
INSERT INTO sor_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesu cow wayɨw da: «Gun gɨ bwana ɨsaw yɨnə cheri ilə yiga nɨm lə me byalna tarɨw da, an̰ji nem àla giyə dara dwãr̰ĩ dɨnə Mãr̰ĩ duwa bədə.» ");
INSERT INTO sor_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Targɨn̰ ɗang da, Aba ciri gɨ Jesu an̰jir woni gɨrsə gwale duwa nə ɗang gɨnɨn̰ wurgɨsubu gɨ dii sɨr me kɨjɨgɨ sɨr sɨr dɨrəwə pii mana gɨ ciri dɨ an̰ji ha hára lə bá bá. ");
INSERT INTO sor_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","An̰ji waygɨ gɨ gwale gɨ diri ba da: «Swagə woni ùrə n̰ilə ilə nan̰e, ɗɨm da, woni n̰ilə swagə di gɨr̰ɨ nan̰ bədə. Yande da, amsɨna Mãr̰ĩ gɨ i aba swagə di dara kal a kɨjɨne nare woni n̰ilə swagə duwa nə ɗang lə bi. ");
INSERT INTO sor_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Hana! Yarna, nə kɨjəng ya dɨmən̰je nə dine de mana gɨ r̰igɨm dalawə. ");
INSERT INTO sor_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Anə ilə hára lə da, unə gursɨ ɨsɨrangə bədə, magɨla bədə me, layna gɨbande bədə me, ɗɨbdɨnə dodə bɨrmə lə dara àlagɨ́ gɨ nare labiya bədə me ca. ");
INSERT INTO sor_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Anə dara dɨmə gun ciri duwa dwar̰ɨ lə da, àlnáw labiya waynaw ba kal hɨlala jwam damna gandɨw. ");
INSERT INTO sor_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Gun gɨ dusɨw ladɨ gaba yə̀ng sɨwə ina lə ciri dwar̰ɨ lə da, labiya dan di ha àla giyə ciri duwa di dwar̰ɨ lə. Ɗɨm da, gun gɨ ya ta de di ina lə bədə da, labiya dan di ha àla giyə ciri dɨ ta di dwar̰ɨ lə bədə me ca. ");
INSERT INTO sor_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ciri dɨ gun yɨnəng lə da, damna lə jang. Kalna cɨmdə daa daa ɗi. Mani nə ina lə ciri dɨ ta di dwar̰ɨ lə da, wamna me chàna me ca. Dara gun gaba àlám giyə da, ùr i ꞌywagaw gɨ gwayni duwa le. ");
INSERT INTO sor_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ciri dɨ we we dɨ anə gandɨna lə me nare yɨnəng sɨdəgɨ lə da, wamna mani pad nə gɨ ꞌyàng gandagɨ di le. ");
INSERT INTO sor_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Swana nare woni mwom nə ciri dɨ ta lə di daa me, waynagɨ nare da: “Wála gɨ Mãr̰ĩ ha lama dwãr̰ĩ duwa di, chidɨ yalang ib ɗɨm!” ");
INSERT INTO sor_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ɗɨm da, ciri dɨ we we dɨ anə gandɨna lə me nare gɨn̰ɨnə yə̀ng sɨdəgɨ lə bam da, hana mana gɨ bur̰əgɨ lə me waynagɨ da: ");
INSERT INTO sor_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Usɨsɨ gɨ ciri dan dɨdə gɨ lagdɨ gɨdɨraninnə kaw, nə ɓwabangnin kaláng dodə. Me dwayna ladɨna: Wála gɨ Mãr̰ĩ ha lama dwãr̰ĩ duwa di, yala ib ɗɨm.” ");
INSERT INTO sor_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nə wayang daa wang: Wála gɨ Mãr̰ĩ dara àla sariya di da, ha wama gandang nan̰e ɗwaya nare nə ciri dɨ Sodomə bam.» ");
INSERT INTO sor_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","«ꞌYeni nare nə ciri dɨ Korasin, wamani ha ꞌywange! ꞌYeni nare nə ciri dɨ Besada kaw, wamani ha ꞌywang me ca! Dara mani nə dan̰a nə nə àlagɨ̀ mana gɨ dwar̰angə ꞌyeni da, dee nə àlnagɨ̀ i mana gɨ ciri dɨ Tirrə me ciri dɨ Sidonnə me da, nare day dee kal àcn̰a day di bam ɓɨg ɗɨm me cendi dee ha hára ꞌywaa Mãr̰ĩ. Cendi dee hurbə barge gɨ gɨ busɨw gɨ suwal sɨdəgɨ lə me cubɨ dɨbɨrɨn̰ basa dɨdəgɨ lə dama nɨm n̰agɨniyə di me ca. ");
INSERT INTO sor_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","I ta di me wála gɨ Mãr̰ĩ dara àla sariya di da, ha wama gandang nan̰e ɗwaya nare nə ciri dɨ Tirrə bam me, nə ciri dɨ Sidonnə bam me ca. ");
INSERT INTO sor_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Me mɨndi ciri dɨ Kapernom da, də ɨrɨm diya Mãr̰ĩ ba ha ꞌwóy hára nɨm i daa ɓa? Bədə. An̰ji ha chə́y i mana gɨ bengə.» ");
INSERT INTO sor_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jesu cor waygɨ woni gɨrsə gwale duwa ɗang ba da: «Gun gɨ dwayna gwale dan da, doy i gwale ni ɨndi. Me gun gɨ gɨn̰ɨnə gwale dan bam da, gɨn̰ i gwale ni ɨndi bam me, gun gɨ gɨn̰ɨnə gwale ni bam da, gɨn̰ i aba giyən di gwale duwa bam me ca.» ");
INSERT INTO sor_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ɨr̰ɨ woni gɨrsə gwale gɨnə Jesu duwanə gɨnɨn̰ wurgɨsubu gɨ dii sɨr di cwaragɨ hára ꞌyo Jesu gɨ sii ꞌywala me, cendi gɨra wayɨw da: «Aba ciri nin, nə ꞌwònin gɨ sumɨm ɨjɨm da, dúndi dɨ àcn̰e kaw doy gwale bɨdəninne!» ");
INSERT INTO sor_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesu cor waygɨ da: «Nə yara Sidan ɨndara lə daa kaláng ya Mãr̰ĩ wur̰ɨn̰ə duwa de. ");
INSERT INTO sor_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Dwayna: Nə ꞌyàng dwana dɨ idɨ ɗɨrbə kwalàle me dorni me dodə gɨ gɨdɨrang, me dɨ idɨ ɗwaya idɨ mar̰ande dɨ Sidan dwana dɨra bam me, mani nə àcn̰e mɨn kaw, ha àlang bədə me ca. ");
INSERT INTO sor_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ɗɨm da, kalna aja pide dara dúndi dɨ àcn̰e dwaya dɨra gɨ doy gwale bɨdəngə di ɗi. Ladni duwa da, ajɨna pide dara sumdəng gɨ Mãr̰ĩ jangɨw ilə alə daa di.» ");
INSERT INTO sor_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Mana gɨ ta lə di dog, dúndi dɨnə Mãr̰ĩ duwa hurəw Jesu sii ꞌywala sɨwə me, an̰ji way da: «Ay, Aban, aba ciri gɨ mani nə daa me nə dodə me i ɨsəwə, nə àlɨ́m dóche, dara nare woni dɨrɨn̰ naa me, nə woni ꞌwacn̰a mani me da, mə budɨgɨ mani nə ta di dodə, me cor mə gɨlgɨ gandagɨ i dine nə ꞌyəng daa cendi. Əw, Aban, ta di me i mani nə lade nə dɨrəm ùrgɨ di.» ");
INSERT INTO sor_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ɨr̰ɨ Jesu waygɨ nare ba da: «Aban gɨ Mãr̰ĩ bon mani pad ɨsənnə. Gun mɨn kaw, ꞌwocn̰ɨn ɨndi gɨ Gorndɨw di bədə, i Aban mɨn tenene me ꞌwocn̰ɨn an̰ju. Gun mɨn kaw ꞌwocn̰ Aban di bədə, me i ɨndi gɨ Gorndɨw me nə ꞌwocn̰ɨw ɨndi, me i nare nə nə ùr dara ba nə gɨlgɨ Aban di le do me cendi ha ꞌwacn̰aw sɨn̰.» ");
INSERT INTO sor_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ɨr̰ɨ Jesu co dɨrəw woni gɨrsə gwale duwa dɨdəgɨ lə me waygɨ cendi mɨra ba da: «Nare nə yər mani nə anə yərgɨ gɨ dɨrəng ta di da, dam i gɨ sii ꞌywala. ");
INSERT INTO sor_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nə wayang yande dara woni cɨmə Mãr̰ĩ bɨw nə ɓɨg nan̰ me, dolgə nə pii me, tanga ùr ba gɨ yər mani nə anə yərgɨ caga ka di me, ꞌyogɨ yərgɨ bədə, cendi ùr ba gɨ doy gwale gɨ anə doyɨw caga ka di me, doyɨw bədə me ca.» ");
INSERT INTO sor_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Wála mɨn, aba gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa ùr ba a gɨrsɨ Jesu me ùrɨw ba da: «Aba gɨlənin mani, nə ha àla i man me nə ha ꞌywaa gɨ bɨlə gaba dama gɨ dɨrɨn̰ bɨr̰ɨn̰ di mo?» ");
INSERT INTO sor_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesu wayɨw da: «Gɨ jangɨ i gwale na mana gɨ bii ɨnda gɨ ꞌwoo lə mo? Mə āsɨ gwale di yər gɨndɨw i man man mo?» ");
INSERT INTO sor_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Abe di cow wayɨw da: «Ba mə ha ùrə Aba ciri dɨma gɨ Mãr̰ĩ gɨ dusɨm mɨn tenene me, gɨ dúndɨm pad me, gɨ dwana dɨma pad me, gɨ ɨrmə dɨma pad me ca. Ɗang da, ba mə ha ùrə jam gun ya sɨm dɨma de me ca.» ");
INSERT INTO sor_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesu cow wayɨw ɗang ba da: «Gwale gɨ mə wayɨw ta di i sɨdɨ ꞌyang. Ha àla yande me, mə ha ꞌywaa bɨlə gaba dama gɨ dɨrɨn̰ bɨr̰ɨn̰ di sɨn̰.» ");
INSERT INTO sor_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ɨr̰ɨ aba gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa di ùr ba a gɨl dara ùrə duwa di, ba i gɨ bɨrmə duwa da, an̰ji ùr Jesu ba da: «Jan gun da, i wi mo?» ");
INSERT INTO sor_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesu cow wayɨw gwale gɨ diri ba da: «Wála mɨn, abe gɨ Juwib mɨn swaa ciri dɨ Jursalem chə́ə ba a ha mana gɨ ciri dɨ Jeriko, ɨr̰ɨ an̰ji gɨra ɨndər mana gɨ miidi ɨsɨragɨ lə. Cendi yɨw n̰ir̰ɨbɨw mani bam sɨwə me lay mani duwa bam pad me gobɨw kalɨw made bɨdɨ lə me kal sɨdəgɨ yá yala day. ");
INSERT INTO sor_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ɨr̰ɨ aba bwasa Mãr̰ĩgɨ Juwib mɨn swaa mana gɨ Jursalem ba a hára mana gɨ Jeriko me, ꞌwoo bɨrmə gɨ ta di me, dɨgɨlaw gɨra ajɨw abe di dɨwə, an̰ji yərɨw ꞌya lə bɨrmə dugdɨwə me ꞌwoy bam bɨrmə dugdɨw dɨ alə ta lə ha kalɨw bam. ");
INSERT INTO sor_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Gun gɨ Lebi mɨn ɗang gaba wagɨ nare woni bwasa Mãr̰ĩ lə giyə dayyə swaa ꞌwoo bɨrmə gɨ ta di me, dɨgɨlaw gɨra ajɨw abe di dɨwə kaw, an̰ji yərɨw ꞌya lə me ꞌwoy bam bɨrmə dugdɨw dɨ alə ta lə ha kalɨw bam me ca. ");
INSERT INTO sor_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ɨr̰ɨ abe mɨn gɨ Samari swaa ba a ha mana gɨ Jeriko me dɨgɨlaw gɨra ajɨw dɨwə. Me mana gɨ an̰ji yərɨw ꞌya lə da, dɨrəw ꞌyəngɨw dɨwə. ");
INSERT INTO sor_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","An̰ji chidɨ sɨwə ib me, tidɨrɨw swani me gani gɨnə yabɨr̰a yàa duwa me diyabe duwa di dɨrəgɨ lə. Ɨr̰ɨ maw daa gɨ barge me, uw chɨ́w daa kura duwa dɨdə me, ha gandɨw mana gɨ kululi nə mɨje dayyə me, dam gamɨw lə. ");
INSERT INTO sor_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Sanga dɨra da, an̰ji biy chile dɨ deniye sɨr ꞌyàw aba kulu di me wayɨw da: “Gamɨn abe gɨ ta di ladɨ le. Mani na nə mə myandɨnagɨ tarɨnnə ɗang kaw, cwara niyə da, nə gɨra ha ꞌywagam daa pad.”» ");
INSERT INTO sor_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Mana gɨ ta lə da, Jesu ùr aba gɨlə bii gɨ ꞌwoo di ba da: «Ɨrmə dɨma lə da, mana gɨ nare nə subu nə ta di dwar̰agɨ lə da, i gɨ we me yər abe gɨ miidi gobɨw di ba i jaw gun di mo?» ");
INSERT INTO sor_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Aba gɨlə bii gɨ ꞌwoo di cow wayɨw da: «I aba yara n̰agɨni duwa ta di.» Jesu wayɨw da: «Ladɨ. Ha, mə ha àla yande dige dige me ca.» ");
INSERT INTO sor_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Mana gɨ Jesu day gɨ nə woni gɨrsə gwale duwa worgɨ lə hára lə bɨrmə lə dara hára Jursalem sɨn̰ da, an̰ji gɨra dɨm ciri dɨ mɨnnə me, deme mɨn dɨ gɨ ꞌwogɨdɨ Martɨ ilə. Tandi yɨw àlɨ́w mɨjəni kɨrə dɨra lə. ");
INSERT INTO sor_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Martɨ di, chidɨdɨ mɨn dɨ gɨ ꞌwogɨdɨ Mari ilə. Tandi gɨra dam dodə Aba ciri gɨ Jesu gɨdawə ilə dwaya gwale gɨ an̰ji ilə wayawə. ");
INSERT INTO sor_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Martɨ dɨra da, dam kɨdɨbər dara àla gɨ giyə gɨnə mɨje day, ɨr̰ɨ tandi gɨra wayɨw Jesu ba da: «Aba ciri ni, mə yər kɨdɨbara gɨ nə kɨdɨbər mɨnan ta dimm, mə kal chidɨn dɨ Mari dam dodə da, ladɨ mo? Waydɨ kaldɨ dɨ swana wanannə!» ");
INSERT INTO sor_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Aba ciri di codɨ waydɨ da: «Martɨ, Martɨ, də jiba sii me dɨ sadɨ me dara àla gɨ mani nə gɨr̰e. ");
INSERT INTO sor_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ɗɨm da, mani mɨn tenene me i nə lade nan̰ cendi. Mari ɓɨr̰ə dɨra i mani nə lade di, me gun ha chabagɨ bam ɨsədɨ lə bədə.» ");
INSERT INTO sor_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Wála mɨn, Jesu dam ilə amsa Mãr̰ĩ mana gɨ mɨnnə. Mana gɨ amsa duwa di ꞌyen̰ bam da, aba gɨrsə gwale duwa mɨn gɨra ùrɨw ba da: «Aba ciri nin, gɨlnin amsa gɨ Mãr̰ĩ di, ya Jã Batis ba gɨlgɨ gɨ woni gɨrsə gwale duwa de me.» ");
INSERT INTO sor_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesu waygɨ da: «Mana gɨ anə dara amsa da, wayna da: “Abɨranin gɨ Mãr̰ĩ, kal nare ꞌwacn̰ana dara sumɨm ba wun i mɨnaw jiga. Kal wála dɨma gaba lama dwãr̰ĩ di hane ɗɨm. ");
INSERT INTO sor_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ꞌyànin haye nə womnin gɨ wála wála. ");
INSERT INTO sor_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Kal dusɨm hɨlal àcn̰a nin gɨ nə àlɨ̀wnin di dɨwə, dara nenin kaw, nə kalnin dusɨrənin hɨlal woni àla gandanin mani nə àcn̰e dɨdəgɨ lə me ca. Me kal mani mɨn lamnanin bwananin àla gɨ àcn̰a lə bədə.”» ");
INSERT INTO sor_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jesu waygɨ ɗang ba da: «Yarna, ya dwar̰angə da, gun mɨn jaw maché ina lə me an̰ji hane ꞌywanaw gɨ changa dwar̰ɨ me waynaw da: “Jan maché, ꞌwán mapa subu, ");
INSERT INTO sor_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","dara jan maché swaa mɨjəniyə yala ilə sɨnnə me mani mɨn nə woni ꞌyàw ilə bədə.” ");
INSERT INTO sor_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ɨr̰ɨ jaw maché di cwanaw gɨ gɨndɨw kulə lə diiyə ba da: “Kal jiban ɗi! Kulu bɨw ɗesər daa me, nin gɨ nə dɨndan kaw, nə inin i nuni ɗɨm me ca, nə nem gaba swaa hára ꞌyàm mapa di bədə ɗɨm.” ");
INSERT INTO sor_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","I sɨdɨ, nə wayang: Dee an̰ji swana wunəw dara ba i jaw maché bədə kaw, an̰ji ha swaa ꞌyàw mani pad nə an̰ji ùrgɨ di dara ajɨmara gɨ an̰ji ajɨmar gandɨw di. ");
INSERT INTO sor_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Yande da, ɨndi, nə wayang: Amsɨna mani, Mãr̰ĩ ha ꞌyànge. Kan̰jɨna mani, anə ha ꞌywaa le. Gwabɨna kulu bɨw, gɨ ha tin̰ənge me ca. ");
INSERT INTO sor_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Dara gun gɨ amsɨna mani da, Mãr̰ĩ ha ꞌyàwe. Gun gɨ kan̰jɨna mani kaw, an̰ji ha ꞌywaa le me, gun gɨ gwabɨna bii kaw, gɨ ha tɨn̰əwe me ca. ");
INSERT INTO sor_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","I wi dwar̰angə me dwe duwa ùrnəw dòche da, an̰ji ha yəə kwalà ꞌyàw ɨsəwə mo? Dwe di amsɨnaw mapa da, an̰ji ha ꞌwoo gɨla ꞌyàw ɨsəwə mo? ");
INSERT INTO sor_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Labaa, dwe di ùrnəw gasa da, an̰ji ha yəə dorni ꞌyàw ɨsəwə mo? ");
INSERT INTO sor_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","ꞌYeni nə dusɨrəng àcn̰ ta kaw, anə ꞌwocn̰ ꞌyàgɨ́ gɨ dɨndɨrang mani nə lade me, Abɨrang gɨ Mãr̰ĩ gaba dama daa da, ha ꞌyàgɨ́ woni ùrɨw dúndi duwa dɨ cendi amsɨw di bədə man man mo?» ");
INSERT INTO sor_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Wála mɨn, Jesu ꞌyor dúndi dɨ àcn̰e dɨ ɨmɨw abe waya gɨ gwale bam sɨwə. Mana gɨ dúndi dɨ àcn̰e di dɨm bam sɨwə mwom da, gun di so way gwale me, nare nə gɨr̰e di yɨbdɨ dɨdəgɨ. ");
INSERT INTO sor_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Me nare nə yab way day da: «I Sidan dɨ i dúndi dɨ àcn̰e geche day me ba ꞌyàw dwana dɨ idɨ ꞌywara gɨ dúndi dɨ àcn̰e bam tandi.» ");
INSERT INTO sor_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Nare nə ɗang ùr ba gɨ gɨrsɨwe, me cendi ùrɨw an̰ju ba àla mani nə dan̰a mɨn nə ba gɨlnəgɨ dara an̰ju ba i gun gɨ Mãr̰ĩ ba giyəw an̰ju di. ");
INSERT INTO sor_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ɨr̰ɨ Jesu ꞌwocn̰ ɨrmə day com me waygɨ da: «Nare nə wama gɨ mɨnnə jarna say gɨ sɨdəgɨ day da, wama gɨ ta di ha myandara i bam me, kululi duwa kaw, ha cubara bam bwara kwandagɨ dɨdəgɨ lə ka me, ka me. ");
INSERT INTO sor_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Cor anə way dan ba i Sidan me ba ꞌyàn dwana tandi me ba nə ꞌyor gɨ dúndi dɨ àcn̰e di. Me ina i Sidan me jarna say gɨ sɨdɨ dɨra gang da, dwãr̰ĩ dɨra ha wara lə man ɗang mo? ");
INSERT INTO sor_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ɗang da, ɨndi, nə ꞌywarna dúndi dɨ àcn̰e di bam i gɨ dwana dɨnə Sidan dɨra da, woni gɨrsə gwale dan da, i wi me ꞌyàgɨ́ dwana me ꞌyor nɨm gɨ dúndi dɨ àcn̰e bam di mo? Yarna, i nare dan di gang me ha waya dara gwale dan gɨ anə wayɨw ta di ba ha lə bədə. ");
INSERT INTO sor_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Me ina i gɨ dwana dɨnə Mãr̰ĩ duwa me nə ꞌywarna gɨ dúndi dɨ àcn̰e bam mwom da, ta di gɨl dara dwãr̰ĩ dɨnə Mãr̰ĩ duwa kaw, yala ꞌywang ɗɨm. ");
INSERT INTO sor_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Gun gaba dwana gɨ mani duwa woni jara say ina lə me an̰ji gamna ciri duwa dwar̰ɨ ladɨna me da, mani duwa nə ꞌywaa dam i labiya, mani mɨn àlgɨ̀ bədə. ");
INSERT INTO sor_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ɗɨm da, gun gɨ dwana duwa ɗwaynaw bam me jarna gandɨw da, an̰ji ha laya mani duwa nə say nə an̰ji kal dusɨw dɨdəgɨ lə di bam me, ha laya mani duwa nə ꞌywaa bam pad ɨsəgɨ nare bam me ca. ");
INSERT INTO sor_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Gun gɨ ina i gun ni bədə da, an̰ji i aba ɨlən me, gun gɨ wanannə dáya gɨ swagə daa lə bədə kaw, an̰ji i aba lyasɨragɨ bam jiga jiga me ca.» ");
INSERT INTO sor_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«Mana gɨ dúndi dɨ àcn̰e dɨmnə bam gun sɨwə mwom da, tandi ha kɨdɨbara bam kudɨmi dalawə kan̰ja mana gaba dama bwaa gwayni. Tandi ꞌywaa mana mɨn bədə me way dusɨdɨ lə ba da: “Ladni duwa da, nə cwara hára mana ni gɨ nə dama lə pii me nə kalaw di bi.” ");
INSERT INTO sor_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Dúndi dɨ àcn̰e di cwara me ꞌyo mana di tojər bam kwa dɨrədɨ lə me, mani kaw ɗangr̰ar ladɨ me ca. ");
INSERT INTO sor_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ɨr̰ɨ tandi ha laya dúndi dɨ àcn̰e wurgɨsubu ɗang dɨ gwale dɨra wom ɗoy dɨra bam, ɓamara gandɨdɨ mɨn háragɨ gɨra mana gɨ ta lə di me damgɨ lə. Ɨr̰ɨ widɨbə gɨnə gun gɨ ta di, cor àlɨ̀w nan̰ ɗoy gɨ pii bam bi.» ");
INSERT INTO sor_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Mana gɨ Jesu ilə waya gwale gɨ ta di lə sɨn̰ da, deme mɨn mana gɨ nare dwar̰agɨ lə so wayɨw gwale mar̰ɨjadɨ daa ba da: «Deme dɨ idɨ yàm me ꞌyàm nãy me ca da, dam i gɨ sii ꞌywala!» ");
INSERT INTO sor_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ɨr̰ɨ Jesu codɨ waydɨ da: «I nare woni dwaya gwale gɨnə Mãr̰ĩ duwa me ꞌwów àla gɨ giyə me, dam i gɨ sii ꞌywala cendi.» ");
INSERT INTO sor_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Mana gɨ nare dayar gɨr̰ɨ nan̰ Jesu tulɨwə da, an̰ji so way da: «Nare nə caga ka i nare nə àcn̰e! Cendi ùr ba nə àlnagɨ́ mani nə dan̰a me, nə ha àlagɨ́ bədə. Cendi ha yara i mani nə dan̰a nə wun ya nə pii àlal gɨ aba cɨmə Mãr̰ĩ bɨw gɨ Jonas ta di de mɨra ɗɨm. ");
INSERT INTO sor_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Mani nə dan̰a nə àl Jonas da, gɨlgɨ nare nə ciri dɨ Ninib dara i Mãr̰ĩ me ba giyəw an̰ju. I yande me mani nə ha àlan ɨndi gɨ Gun gorndɨw di kaw, ha gɨləng ꞌyeni nare nə caga ka dara ba i Mãr̰ĩ me ba giyən an̰ju. ");
INSERT INTO sor_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Wála gɨ Mãr̰ĩ dara àla sariya di da, doli dɨ geche dɨ wama gɨ tulɨn̰ dɨ ɨsay gɨ abeyə di ha swaa ɗɨbə daa nare nə caga ka dɨrəgɨ lə me ha waya cendi ba i nare nə àcn̰e. Dara tandi tanga swaa i sɨn̰a dɨ yēyə hən̰ hára dara dwaya dɨrɨn̰ naa nənə dole gɨ Salmõ duwa. Ɨr̰ɨ caga ka da, gun gɨ ɗoy Salmõ bam ilə. ");
INSERT INTO sor_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Wála gɨ Mãr̰ĩ dara àla sariya di da, nare nə ciri dɨ Ninib lə ha swaa daa nare nə caga ka dɨrəgɨ lə me ha waya cendi ba i nare nə àcn̰e. Dara nare nə Ninib di tuni pii doy berni dɨnə Jonas duwa me kala àcn̰a day di bam me yala ꞌyo Mãr̰ĩ. Ɨr̰ɨ, caga ka da, gun gɨ ɗoy Jonas bam ilə.» ");
INSERT INTO sor_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","«Gun mɨn gɨr dùwa lamba lə me chɨ́dɨ budə lə bədə me, ɨbdɨ mani dɨdə bədə me ca. Ladni duwa da, gɨ udɨ chɨ́dɨ i daa mani dɨdəgɨ lə dara nare woni dɨmə kɨrə da, ba yarna gɨ mana.» ");
INSERT INTO sor_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","«Dɨrəm da, i ya lamba dɨnə sɨm duwa de. Dɨrəm ina labiya da, sɨm pad kaw, i ya ba dam i mana gɨ ácn̰a lə de me ca. Me dɨrəm ina labiya bədə da, sɨm di kaw, i ya ba dam i dilɨmmə de me ca. ");
INSERT INTO sor_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Àsɨ angal dɨma ladɨ le, kal dùwa dɨ ácn̰ sɨmmə ta di cwarna gɨdɨnə dilɨm bədə. ");
INSERT INTO sor_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Sɨm pad damna mana gɨ ácn̰eyə me tulɨw hin̰e kaw, warna dilɨmmə bədə da, an̰ji ha dama mana gɨ ácn̰eyə pad. Ha wunə ya lamba ba dɨ ácn̰ɨm nɨm gɨ mana ta de me ca.» ");
INSERT INTO sor_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Mana gɨ Jesu wor ilə waya gwaleyə jang sɨn̰ da, abe gɨ Parise mɨn ꞌwogɨw an̰ju ba hana wamna mani kɨrə duwa lə me, Jesu dɨm kɨrə me dam wama bɨwə. ");
INSERT INTO sor_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Abe gɨ Parise di yər Jesu wama gɨ haye lə dɨban wiya gɨ ɨsaw bam ya hada day ba ɨrɨm nɨm de bədə da, an̰ji ɨrɨm gwale nan̰e. ");
INSERT INTO sor_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Aba ciri gɨ Jesu wayɨw da: «ꞌYeni nə Parise da, anə wujɨ ɨsɨrang bam ladɨ ya hada dan ba ɨrɨm nɨm de me, dusɨrəng dɨ korgɨn̰ da, ꞌwonbɨ daa gɨ ɨrmə gɨ mĩyni me dusi dɨ ur̰ɨn̰e me ca. Wun ya anə banə wujɨ gɨ ɗogdər̰e me dásabe me taragɨ bam me, dwar̰agɨ nə korgɨn̰ da, wor gɨ gichɨni ta de. ");
INSERT INTO sor_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","ꞌYeni nare woni ɨrmə gwale bədə nə gá! Mãr̰ĩ gaba ɗar̰a mani taragɨ nə iche da, ɗar̰ɨ dwar̰agɨ nə korgɨn̰ bədə mo? ");
INSERT INTO sor_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ladni duwa da, ꞌyànagɨ́ nare nə n̰agɨni mani gɨ dusɨrəng dɨ wuse her an̰ju me, sɨdəng pad kaw, ha wusə her Mãr̰ĩ dɨrəwə me ca. ");
INSERT INTO sor_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","ꞌYeni nə Parise da, wamani ha ꞌywange! Dara chemde nə ɓani ɓani woni bwaa bɨ̀ra lə kaw, nə nyamna mwaj da, anə ɓɨr̰ɨ bɨdəgɨ mɨn mɨn hára ꞌyàw Mãr̰ĩ com mɨnang, ɨr̰ɨ cor anə gɨn̰ yəə gɨ kwandang nare gɨ bɨrmə duwa ladɨ bam me, anə gɨn̰ ùrə gɨ Mãr̰ĩ gɨ dusɨrəng mɨn bam me ca. Ɓag da, dee anə ha àla i mani nə ta di do me anə ha àla nə ɗang nə wor di sɨn̰. ");
INSERT INTO sor_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","ꞌYeni nə Parise da, wamani ha ꞌywange! Dara anə ùr dama gɨ mana gaba sumiyə kululi woni amsa Mãr̰ĩyə me, anə ùr nare ba àlnáng labiya gɨ horɨmbə nare dɨrəgɨ lə mana gaba dayara lə me ca. ");
INSERT INTO sor_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","ꞌYeni nə Parise da, wamani ha ꞌywange! Dara anə wun i ya munɨni nə gɨ hurbəgɨ mani dɨdəgɨ lə bədə me nare ꞌwocn̰ɨgɨ bədə me ha dɨdəgɨ lə ɗɨrbɨgɨ dodə ta de.» ");
INSERT INTO sor_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Mana gɨ ta lə da, gun mɨn mana gɨ woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa u gwale wayɨw Jesu da: «Aba gɨlənin mani, gwale gɨ mə wayɨw ta da, mə cadɨbɨnin i nenin me ta bədə mo?» ");
INSERT INTO sor_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesu cow wayɨw da: «Əw, ꞌyeni woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa kaw, wamani ha ꞌywange! Dara anə chɨ́gdɨgɨ nare hudɨr gɨ nugde dɨdəgɨ lə me, ɨr̰ɨ, gɨ dùndɨrəng yande hin̰e kaw, anə ɓɨlɨw wagɨ nɨm lə bədə. ");
INSERT INTO sor_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Wamani ha ꞌywange! Anə awdɨgɨ woni cɨmə Mãr̰ĩ bɨw nə pii munɨni day ladɨbɨ, cor i mwágɨrang nə pii me ꞌyəgɨ cendi gang. ");
INSERT INTO sor_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Anə àl yande gɨl nɨm dara mani nə mwágɨrang àl ta di ꞌywalange. Cendi day da, ꞌyəgɨ me, ꞌyeni dan da, anə awdɨ munɨni day daa me ca. ");
INSERT INTO sor_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","I dara ta di me Mãr̰ĩ gɨ aba dɨrɨn̰ naa waya pii ba da: “Nə ha kɨjəgɨ nare ni nə Juwib woni cɨmə bɨn me paja ni me ca. Ɨr̰ɨ nare nə Juwib di, ha ꞌyáa nə mɨn bam me, ha gɨləgɨ nə yab dɨrəgɨ me ca.” ");
INSERT INTO sor_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","I dara yande me nare nə caga ka da, gɨ ha ùrəgɨ bare gɨnə woni cɨmə Mãr̰ĩ bɨw nə pii day gɨ bor bam wála gɨ Mãr̰ĩ àsɨ gɨ sɨn̰a lə bá, ");
INSERT INTO sor_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","swaa made dɨnə Abel lə bá hára mana gɨ made dɨnə Jakari gɨ gɨ ꞌyəw mana gɨ kulu gɨnə Mãr̰ĩ bulə day gɨ mana gaba bwasa Mãr̰ĩyə. Nə wayang daa wang: Nare nə ta di bare day da, gɨ ha ùrəw i nare nə caga ka di ɨsɨragɨ lə. ");
INSERT INTO sor_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","ꞌYeni woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa da, wamani ha ꞌywange! Dara anə u lakɨle gaba tin̰əgɨ nare kulu gaba ꞌwacn̰a Mãr̰ĩ bɨw budɨ bam. Anə gɨn̰ dɨmə gɨ kulu gɨ ta lə di bam me, nare nə ùr ba gɨ dɨm kulə di kaw, anə ɨmgɨ bɨrmə bam me ca.» ");
INSERT INTO sor_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Mana gɨ Jesu dɨmə iche mwom da, woni gɨlə bii gɨ ꞌwoo me nare nə Parise me dusɨrəgɨ nagɨ nan̰ dɨwə me ùrbɨw gwale jiga jiga me ca. ");
INSERT INTO sor_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Cendi ùrbɨw yande tow nɨm gaa ba gɨ ꞌyo gwale gɨ àcn̰e bɨwə gaba yə̀w nɨm mo? ");
INSERT INTO sor_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Wála gɨ ta lə da, nare dayar nan̰ nem dubu dubu me, nə yab ɗɨrbɨ kwandagɨ gɨ gɨdɨragɨ daa pəgɨn̰ mad mad. Jesu u gwale waygɨ woni gɨrsə gwale duwa ba da: «Gamna sɨdənge dara musbu gɨnə nare nə Parise day. Cendi i nare nə gwale ꞌyol bɨdəgɨ lə, me dusɨrəgɨ dɨ korgɨn̰ i jiga. Pamna mani day nə àla bədə. ");
INSERT INTO sor_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Dara mani nə nare gamgɨ dusɨrəgɨ lə pad da, ha dɨmə daa me, nə gɨ àlgɨ̀ budə lə kaw, gɨndəgɨ ha piyara daa pad me ca. ");
INSERT INTO sor_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","I dara ta di me gwale gɨ anə wayɨw budɨ lə da, gɨ ha dwayaw daa pɨden̰yə ɗən̰ ɗən̰ me, gɨ anə dam kulə bo bɨdəng nare sumdəgɨ lə n̰amɨw nɨm kaw, gɨ ha swajaw daa pɨden̰yə pəng pəng nare dɨrəgɨ lə me ca. ");
INSERT INTO sor_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Nə wayang i ꞌyeni nə kwandan moso: Kalna lán̰agɨ gɨ nare ɗi. Cendi da, nem ꞌyáa gun sɨw gɨ doni mɨra me ha nyama gaba àláw mani mɨn targɨn̰ ɗang bədə. ");
INSERT INTO sor_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Yarna, nə gɨləng gun gɨ anə ha lán̰aw di: Lán̰ɨnaw Mãr̰ĩ an̰ju, dara an̰ji duwa da, nem ꞌyáng me nem bwaa dúndɨrəng mana gɨ dùwa dɨ budə dɨra gɨ bam ilə bədə bɨr̰ɨn̰yə di. Əw, nə wayang: I an̰ji me lán̰ɨnaw. ");
INSERT INTO sor_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Dirbi nə tẽtẽ kaw, gɨ ɓamgɨ jii me gɨ kɨlgɨ bam gɨ chile dɨ ɓani sɨr gaa bədə mo? Yande kaw, dirbi nə ta di, mɨn dwar̰agɨ lə kaw, Mãr̰ĩ nɨmgɨ bam bədə. ");
INSERT INTO sor_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ɗang da, wudɨn̰ nə dɨdəng kaw, Mãr̰ĩ ꞌwocn̰ gɨr̰ə day le me ca. Yande da, lán̰ɨna bədə! Anə ꞌyolɨw Mãr̰ĩ nan̰ ɗoy dirbi nə gɨr̰e bam. ");
INSERT INTO sor_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Nə wayang daa: Gun gɨ wayna daa nare dɨrəgɨ lə ba a i gun ni da, ɨndi gɨ Gun gorndɨw kaw, nə ha waya daa Paja nənə Mãr̰ĩ duwa nə daa dɨrəgɨ lə, an̰ju ba i gun ni me ca. ");
INSERT INTO sor_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ɗɨm da, gun gɨ bɨlnə bɨw sarni wayna daa nare dɨrəgɨ lə ba a ꞌwocn̰ɨn bədə da, ɨndi kaw, nə ha waya daa paja nənə Mãr̰ĩ duwa nə daa dɨrəgɨ lə ba nə ꞌwocn̰ɨw bədə me ca. ");
INSERT INTO sor_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Gun gɨ wayna ɨndi gɨ Gun gorndɨw gwale ni gɨ àcn̰e kaw, Mãr̰ĩ ha kala dusɨw hɨlala dɨwə me, aba cadɨba dúndi dɨnə Mãr̰ĩ duwa da, an̰ji ha ꞌywaa dusi dɨ hɨlale Mãr̰ĩ sɨwə bədə. ");
INSERT INTO sor_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Wála gɨ gɨ dara hára gandang kululi woni amsa Mãr̰ĩyə dara àlang sariya, labaa dara hára gandang dolgə lə labaa woni dwana dɨrəgɨ lə kaw, kalna hára dara gwale gɨ anə ha wayaw me bɨlə gɨ sɨdəng daa me di ɗi. ");
INSERT INTO sor_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Dara i dúndi dɨnə Mãr̰ĩ duwa me ha gɨləng gwale gɨ anə ha wayaw mana gɨ ta lə di dog tandi.» ");
INSERT INTO sor_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Gun mɨn mana gɨ nare nə gɨr̰e dwar̰agɨ lə wayɨw Jesu da: «Aba gɨlənin mani, wayɨw chendɨn kalɨw a ɨsɨnənin dɨba dɨ abɨranin kalnin gandɨdɨ di bam.» ");
INSERT INTO sor_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesu cow wayɨw ba da: «Jan maché, i wi me chɨ́n geche gaba ang gwale labaa, aba ɨsəng mani dodə mo?» ");
INSERT INTO sor_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ɨr̰ɨ Jesu waygɨ nare ba da: «Àsɨna angal dan dara ùrə gɨ mani nə ꞌywaa nə ꞌyarbare. Gun da, dee mani duwa nə ꞌywaa ꞌyarbarna ya man de kaw, cendi nem bɨləw bədə.» ");
INSERT INTO sor_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ɨr̰ɨ Jesu waygɨ gwale gɨ diri ba da: «Gun mɨn gaba ꞌywaa mani gɨ yiga duwa naw swagə ꞌyarbar nan̰ ilə. ");
INSERT INTO sor_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Mwom da, an̰ji dam ɨrɨm gwale dusɨwə ba da: “Mana ni gaba bwaa swagə di yen daa me, nə ha àla i man mo?” ");
INSERT INTO sor_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ɨr̰ɨ an̰ji way da: “Yər, mani nə nə ha àlagɨ̀ di me i ta: Nə ha ichɨbə ɓechibe ni bam pad me, nə ha piyə nə gechide ɗang me, nə ha bwaa gɨ swagə ni di lə me, nə ha dáya gɨ mani ni nə ꞌywaa nə ɗang pad lə me ca. ");
INSERT INTO sor_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Targɨn̰ ɗang da, nə ha waya dusɨnnə ba da: Dúndɨn, mani diya woni wama aliya nan̰ dalawə ꞌyarbar nan̰e. Dam, də wom me, də chə̀ me, də bo gwayni, də ajɨ pide sɨn̰a dɨdə.” ");
INSERT INTO sor_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ɨr̰ɨ Mãr̰ĩ cor wayɨw da: “Məng gá! Changa dɨ laba lə da, mə ha mara le! Yande da, mani dɨma nə ꞌywaa nə mə dajɨbɨgɨ di, ha waraw i wi mo?”» ");
INSERT INTO sor_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Me Jesu way ɗang ba da: «Gun gɨ kan̰jɨna ꞌywaa dara sɨw duwa gang me kan̰jɨ ꞌywaa gɨ daa Mãr̰ĩ sɨwə bədə da, ha wunə ya ta di de me ca.» ");
INSERT INTO sor_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ɨr̰ɨ Jesu waygɨ woni gɨrsə gwale duwa ba da: «I dara ta di me nə wayang da: Kalna nulbə gɨ sɨdəng dara haye gɨ anə ha wama bɨlə nɨm di ɗi, me barge gɨ anə ha hura sɨdəngə di ɗi. ");
INSERT INTO sor_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Dara gun dama duwa gɨ dɨrəw bɨ̀ra sɨn̰a dɨdə ka da, ladni duwa ɗoy mani nə wama bam, me gun sɨw gɨ doni kaw, ladni duwa ɗoy barge gɨ hura bam me ca. ");
INSERT INTO sor_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ɨrmɨnə gàa dɨwə sɨn̰: An̰ji yigɨ swagə bədə, me n̰il bədə me, dogɨlɨn̰ duwa kaw, ilə bədə me ca. Ɓechibe duwa ilə bədə kaw, Mãr̰ĩ ɨsɨw ta bədə mo? Me ꞌyeni nə nare da, anə ɗoy dirbi bam hən̰ Mãr̰ĩ dɨrəwə bədə mo? ");
INSERT INTO sor_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ɗang da, i wi dwar̰angə, dara nulbə duwa gɨ sɨw di, me chidɨ nɨm gɨ wála duwa gɨ dam nɨm sɨn̰a dɨdə daa pii hin̰e mo? ");
INSERT INTO sor_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ina yande da, dee dwana dan nyamna dara àla mani nə hin̰er̰u bədə da, dara na me anə nulbə sɨdəng dara mani nə ɗang di mo? ");
INSERT INTO sor_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Yarna balawrang hoo duwa gɨ an̰ji huw sɨn̰. An̰ji àl giyə bədə me ku barge bədə me ca. Me nə wayang: Dole gɨ Salmõ gɨ mani duwa ꞌyarbar nan̰ ta kaw, dii mɨn hurə barge gɨ lade gɨ ya balawrang hoo duwa di de bədə. ");
INSERT INTO sor_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ay, ꞌyeni nare nə dusɨrəng dɨ kala Mãr̰ĩ dɨwə i ɓani nə gá! Chemde nə bam nə dam laba me, sanga gɨ ha bwagɨ dùwa lə kaw, Mãr̰ĩ hurnagɨ barge gɨ lade sɨdəgɨ lə da, ꞌyeni nə nare da, an̰ji ha hurang barge sɨdəngə bədə man man mo? ");
INSERT INTO sor_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Yande da, ꞌyeni, kalna nulbə gɨ sɨdəng mani nə wama dɨdəgɨ lə ɗi me, kalna nulbə gɨ sɨdəng mani nə chàa dɨdəgɨ lə ɗi me ca. Ɨrmɨnə mani nə ya ta de di dɨdəgɨ lə nan̰ bədə me ca. ");
INSERT INTO sor_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Mani nə ta di pad da, i nare woni ꞌwacn̰a Mãr̰ĩ gɨ ɓag bədə me kan̰jɨgɨ dɨban bwaa gɨ gwayni cendi sɨn̰a dɨdə ka. Me ꞌyeni da, Abɨrang gɨ Mãr̰ĩ ꞌwocn̰ mani pad nə jalang ta di com. ");
INSERT INTO sor_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Yande da, kan̰jɨna dara kal Mãr̰ĩ lamna dwãr̰ĩ duwa dɨdəngə pii do me, mani nə ɗang di da, Mãr̰ĩ ha ꞌyàng gandagɨ lə diiyə sɨn̰.» ");
INSERT INTO sor_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","«ꞌYeni nə anə wun ya dɨmən̰je nə dayar ɓani kab de da, kalna lán̰a ɗi, dara Abɨrang gɨ Mãr̰ĩ ùr ba a kalang anə ha dama ciri duwa lə di le. ");
INSERT INTO sor_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Kɨlnə mani dan nə ꞌywaa bam me, gursɨ day da, ɨsɨnəgɨ woni n̰agɨni. Kan̰jɨna mál dɨ idɨ myandara bam bədə tandi. Dáyna mál dan bwanadɨ daa Mãr̰ĩyə, dara i mana gɨ mẽ ha mĩyədɨ bədə me, dɨgɨn̰e kaw, ha ladɨ bədə me ca. ");
INSERT INTO sor_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Nə way yande dara mana gɨ mani dan nə ꞌywaa pad ilə ta di, dusɨrəng ha ꞌya lə dɨwə me ca.» ");
INSERT INTO sor_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«Hurbɨna barge dan gɨ giyə sɨdəngə damna nɨm me, kalna lamba dan damna gɨ ꞌywaa jang me ca. ");
INSERT INTO sor_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Damna wunə ya woni àla giyə nə dam ɓedɨ aba ciri day gɨ ya dyamdɨraniyə cwara duwa ta de. Mana gɨ an̰ji gɨrnəy me ajɨna kulu bɨw me da, cendi ɓɨr̰ɨn̰ kaláng tɨn̰ɨw bam. ");
INSERT INTO sor_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Woni àla giyə nə aba ciri day cwarnay gɨrnəy ꞌywanagɨ bɨ̀ra da, cendi dam i gɨ sii ꞌywala! Dwayna, nə wayang i gwale sɨw: Aba ciri di ha cwara hura barge gɨ giyə di sɨwə me, ha kalagɨ dama dodə me, ha hára dwar̰agɨ lə mɨn mɨn ɨsəgɨ mani nə wama me ca. ");
INSERT INTO sor_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Aba ciri di cwarnay hane gɨ changa dwar̰ɨ labaa, gɨ manapɨr ib me, ꞌywanagɨ bɨ̀ra da, woni àla giyə nə ta di, dam i gɨ sii ꞌywala. ");
INSERT INTO sor_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Anə ꞌwocn̰ com, gun gaba ciri dee ꞌwacn̰ana dara mẽ ba hára lə mĩyəwə gɨ dawa dɨ ya ta de da, an̰ji ha dama dɨrəw bɨ̀ra ɨməw ɓwalba gɨ bii dɨmə kɨrə duwa lə di bam. ");
INSERT INTO sor_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","ꞌYeni kaw, ɗangr̰ɨna sɨdəng damna dɨrəng bɨ̀ra, dara ɨndi gɨ Gun gorndɨw di, nə ha cwara i gɨ dawa dɨ anə ɨrɨm lə bədə.» ");
INSERT INTO sor_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Piyer ùr Jesu ba da: «Aba ciri nin, gwale gɨ diri gɨ mə wayɨw ta di da, mə waynin i nenin mɨra labaa, mə waygɨ i nare pad mo?» ");
INSERT INTO sor_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Aba ciri gɨ Jesu way da: «Gun gaba gama mani gɨ dusɨw mɨn me gɨ dɨrəw naa me da, i gɨ man mo? I gun gɨ aba ciri duwa ha bwaw giyə gɨ aba ɨsəgɨ nare nə kɨrə duwa lə mani nə wama mana gɨ dawa day nem lə bá bá. ");
INSERT INTO sor_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kwaya gɨ aba ciri duwa cwarnay gɨrnəy ꞌywanaw ilə àla giyə gɨ an̰ji ɨrmɨw piiyə da, kwaya gɨ ta di dam i gɨ sii ꞌywala. ");
INSERT INTO sor_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","I sɨdɨ, nə wayang: Aba ciri duwa ha bwaw mani duwa nə ꞌywaa pad ɨsəwə. ");
INSERT INTO sor_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Me dee kwaya di wayna dusɨwə ba da: “Aba ciri ni hára gang bədə sɨn̰” me an̰ji damna dara gwaba kwandaw kòy nə abje me nə namde me, kal sɨw dam wom me chə̀ widɨbɨ nɨm an̰ju gang me da, ");
INSERT INTO sor_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ɨr̰ɨ aba ciri duwa di cwara hára i gɨ wála gɨ an̰ji gamɨw lə bədə me, i gɨ dawa dɨ an̰ji ꞌwocn̰ɨdɨ bədə me ca. Mana gɨ ta lə da, aba ciri duwa di ha ꞌywaraw bam iche me, ha àsaw wamani gɨ gecheyə ɓamaw gɨ nare nə cow Mãr̰ĩ taragɨ. ");
INSERT INTO sor_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Kwaya gɨ ꞌwocn̰ mani nə aba ciri duwa ùrgɨ di com me, an̰ji àlnagɨ̀ bədə me, ɗangr̰ɨna mani gamna gɨ cwara duwa bədə me da, aba ciri duwa di ha gwabaw nan̰e. ");
INSERT INTO sor_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Me kwaya gɨ ꞌwocn̰ mani nə aba ciri duwa ùrgɨ di bədə, me àlna mani nə àcn̰e da, gɨ ha gwabaw ɓaniye. Gun gɨ gɨ ꞌyànáw mani ɨsəwə nan̰ da, gɨ ha ùrəw mani nan̰ me ca.» ");
INSERT INTO sor_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","«Nə hára dara gɨrə dùwa mana gɨ sɨn̰a dɨdə ka. Ay, dùwa di dee gɨrnənə le ɗɨm ɗe! ");
INSERT INTO sor_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Me ɨndi da, ùrɨn i àla gɨ batem mɨn dɨ wamani me, nə dam i gɨ hára bɨraa ɗan̰ mani nə ta di àlal nɨm bá. ");
INSERT INTO sor_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ɨrmə dannə da, anə way ba nə yalang i gɨ labiya sɨn̰a dɨdə ka ɓa? Bədə. Me nə wayang: Hára ni da, agdɨ nare bam. ");
INSERT INTO sor_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","So caga ka da, nare jii damna kɨrə mɨn da, ha agda i bam, nə subu ha bwaa gɨndəgɨ ɨlə nə sɨr le me, nə sɨr ha ɨlə nə subu le me ca. ");
INSERT INTO sor_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Dwe abəw ha ɨləwe me, dwe ha ɨlə abəwe me ca. Dwe idɨ ha ɨlədɨ le me, durmədɨ kaw, ha ɨlədɨ le me ca. Dwe nuwadɨ ha ɨlədɨ le me, deme dɨ dɨrway ha ɨlə nuwadɨ le me ca.» ");
INSERT INTO sor_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesu waygɨ nare nə gɨr̰e nan̰ di ɗang bi ba da: «Anə yarna mãr̰ĩ swanay gɨndɨwə da, anə way, an̰ji ba ha ꞌwāa le me, an̰ji hára ꞌwō ꞌyang me ca. ");
INSERT INTO sor_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Me mana gɨ anə yarna gale wanəy ɨsay gɨ abeyə da, anə way mana ba ha ur̰ə nan̰e, me mana di gɨra ur̰ɨ ꞌyang me ca. ");
INSERT INTO sor_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","ꞌYeni nare nə gwale ꞌyol bɨdəngə, me dusɨrəng dɨ korgɨn̰ i jiga nə gá! Anə ꞌwocn̰ mani nə àlal sɨn̰a dɨdə me nə daa me ca, me dara na me anə ꞌwocn̰ mani nə ilə àlal lə caga ka di gɨndəgɨ bədə mo?» ");
INSERT INTO sor_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","«Dara na me ꞌyeni gang, mani nə àla nə i gɨ bɨrmə day da, anə ꞌwocn̰ɨgɨ bədə ɓara? ");
INSERT INTO sor_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","I ya aba àla gandɨm gwale ꞌwagɨnam mana gɨ sariya lə da, mana gɨ anə wor hára lə bɨrmə lə sɨn̰ da, ɗangr̰ɨ gandɨw gwale gɨ mar̰ɨjam nə hɨlale, pəgɨn̰ bədə da, an̰ji ha hára gandɨm aba àla sariya dɨrəwə me, aba àla sariya di ha yə̀m ꞌyàgɨ́ asɨngar ɨsɨragɨ lə me, asɨngar di ha hára àsam dangeyə. ");
INSERT INTO sor_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nə wayɨm daa wang: Mə ꞌywagɨna gursɨ dɨ dɨmə di ꞌyan̰ɨna bam pad bədə da, mə ha dɨmə bam dangeyə di bədə bɨr̰ɨn̰.» ");
INSERT INTO sor_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Wála gɨ ta di lə da, nare yab chidɨbə Jesu sɨwə me kɨbɨw gwale gɨnə dole gɨ Pilat duwa gɨ ꞌyáa gɨ nare nə Galile wála gɨ cendi dam ilə bwasaw Mãr̰ĩyə. ");
INSERT INTO sor_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesu cogɨ lə diiyə ba da: «Ɨrmə dannə da, anə way ba made dɨ ꞌyáa nare nə Galile nə ta di da, gɨl i dara àcn̰a day ba ɗoy nare nə Galile nə ɗang pad day bam mo? ");
INSERT INTO sor_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nə wayang: I yande bədə. Me anə kalna àcn̰a dan bam bədə me anə hane ꞌywana Mãr̰ĩ bədə da, ꞌyeni di kaw, anə ha mara bam pad ya cendi di de me ca. ");
INSERT INTO sor_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Labaa, ɨrmə dannə da, nare nə mwaj dii dunasɨr nə kulu gɨ hoy gɨ ciri dɨ Siloweyə jur dɨdəgɨ lə ꞌyəgɨ bam di da, anə way cendi ba àl àcn̰a nan̰ ɗoy nare pad nə gɨndəgɨ wor nə Jursalem di bam mo? ");
INSERT INTO sor_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nə wayang: I yande bədə. Me anə kalna àcn̰a dan bam bədə me anə hane ꞌywana Mãr̰ĩ bədə da, ꞌyeni di kaw, anə ha mara bam pad ya cendi di de me ca.» ");
INSERT INTO sor_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ɨr̰ɨ Jesu waygɨ gwale gɨ diri ba da: «Dwaga ɗɨləl lə abe mɨn daga duwa gɨ yabɨr̰a dalawə. An̰ji kɨdɨbara dara ba a ar dwaga di yàa dɨra me, tandi yə̀ bədə. ");
INSERT INTO sor_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Yande da, an̰ji so wayɨw aba àla giyə daga gɨ yabɨr̰a lə ba da: “Yər, laba da, nem aliya subu pad, nə kɨdɨbara dara ba nə ar dwaga di yàa dɨra me, tandi yə̀ bədə. Caga da, sawdɨ bam, dara tandi dam ɨm mana bam pəgɨn̰.” ");
INSERT INTO sor_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Abe di cow wayɨw da: “Aba ciri ni, kaldɨ aliya gɨ laba lə do. Nə ha pwala gɨndɨdɨ bam bwadɨ ichɨn̰yə yara nɨm sɨn̰. ");
INSERT INTO sor_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Nə àldɨ́ yande yər nɨm, ɗan̰ gaa dɨ ha yàa som. Tandi yàna bədə do me, mə ha sawadɨ bam sɨn̰.”» ");
INSERT INTO sor_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Wála gaba bwaa gwayni gɨnə nare nə Juwib dayyə mɨn, Jesu ilə gɨləgɨ nare mani mana gɨ kulu gaba amsa Mãr̰ĩyə. ");
INSERT INTO sor_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Mana gɨ nare di dwar̰agɨ lə da, deme mɨn dɨ dúndi dɨ àcn̰e biydɨ gwangrang nem aliya mwaj dii dunasɨr ilə. Tandi gongɨ i dodə nem biyə dɨrədɨ daa bədə. ");
INSERT INTO sor_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Me mana gɨ Jesu ba a yərdɨ mwom da, ꞌwagadɨ sɨwə me waydɨ ba da: «Chidɨn, kal mwom diya di biyarna bam sɨyyə ɗɨm!» ");
INSERT INTO sor_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Me an̰ji lay ɨsaw ɓɨl sɨdɨ me, mana gɨ ta lə dog, tandi so yər daa tɨba me, tandi so ilə bwaw Mãr̰ĩ jilayyə. ");
INSERT INTO sor_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ɨr̰ɨ geche gɨnə kulu gaba amsa Mãr̰ĩ di dusɨw naw dara Jesu ba so deme daa wála gaba bwaa gwayniyə me, so waygɨ nare nə gɨr̰e di ba da: «Wála gaba àla giyə da, i kubi. Hane wála gɨ ta lə di me gɨ swanang nɨm daa mwom dannə di. Hane wála gaba bwaa gwayniyə bədə, dara wála gɨ ta di, àla gɨ giyə ilə bədə.» ");
INSERT INTO sor_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Aba ciri gɨ Jesu cow wayɨw da: «ꞌYeni nare nə gwale ꞌyol bɨdəngə, me dusɨrəng dɨ korgɨn̰ i jiga nə gá! I wi dwar̰angə me, awɨr labe duwa labaa, kura duwa daa mana gɨ gir̰eyə ha nɨm ꞌyàw nimi gɨ wála gaba bwaa gwayniyə bədə mo? ");
INSERT INTO sor_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Me deme dɨ i Abɨraham mwàw dɨ ta di, Sidan madɨ dodə àl aliya mwaj dii dunasɨr da, gɨ nem awradɨ daa gɨ wála gaba bwaa gwayniyə di bədə mo?» ");
INSERT INTO sor_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jesu gwale duwa gɨ cogɨ lə diiyə ta di, woni mar̰ande duwa da, jawe yɨbɨgɨ le, ɨr̰ɨ nare nə gɨr̰e day da, sɨdəgɨ ꞌyolgɨ nan̰e dara mani nə lade nan̰ nə Jesu àlgɨ̀ ta di. ");
INSERT INTO sor_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ɨr̰ɨ Jesu way ba da: «Dwãr̰ĩ dɨnə Mãr̰ĩ duwa da, wun i ya na de mo? Labaa, nə ha ꞌwódɨ ɨrmədɨ i gɨ na mo? ");
INSERT INTO sor_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Dwãr̰ĩ dɨnə Mãr̰ĩ duwa wun i ya habda gɨ mutardɨ dɨrəw nə gun ugɨ gɨsɨgɨ mana gɨ daga duwa lə ta de. Mutardɨ dɨrəw nə ɓani hin̰e di gandɨ daa me jor gɨdɨ habda gɨ geche gɨ dirbi nə daa ɗangr̰ɨ ciri day mana gɨ gangr̰awə dam lə.» ");
INSERT INTO sor_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jesu cor way ɗang bi: «Nə ha ꞌwoo dwãr̰ĩ dɨnə Mãr̰ĩ duwa di ɨrmədɨ i gɨ na tugu mo? ");
INSERT INTO sor_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Dwãr̰ĩ dɨnə Mãr̰ĩ di wun i ya musbu gɨ deme juw bow burə gɨ koro mwaj dɨwə dara àla gɨmapa ta de. Mana gɨ tandi koyɨw ɓamɨw daa mɨn mwom da, burə di sodɨ daa pad duwa lə.» ");
INSERT INTO sor_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesu ha dara hára ciri dɨ Jursalem da, an̰ji ha jə̀ gɨ ciri dɨ gechideyə me dɨ dineyə me, gɨlgɨ nare mani dɨrəw daa. ");
INSERT INTO sor_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Wála mɨn, gun mɨn ùrɨw ba da: «Aba ciri nin, nare woni ꞌywaa bɨlə da, ha ꞌya i ɓani mɨra mo?» An̰ji cogɨ waygɨ nare nə pad ta di ba da: ");
INSERT INTO sor_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Jarna le dara dɨmə gɨ ciri bɨdɨ dɨ ɓaniyə an̰ju. Nə wayang yande dara nare nan̰ ha kan̰ja dara ba gɨ dɨm gɨ ciri bɨdɨ dɨ ta di, me cendi ha nyama bədə. ");
INSERT INTO sor_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Wála gɨ aba ciri di dara swaa daa me dara ɗyasa bii daa dej mwom da, ꞌyeni nə gɨndəng wor iche da, anə ha gwaba bii di bɨraa bɨraa me, anə ha waya ba da: “Aba ciri nin, aba ciri nin, tin̰ɨnin bii bam ɗe!” Me an̰ji ha wayang da: “Nə ꞌwacn̰ang bədə.” ");
INSERT INTO sor_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ɨr̰ɨ anə ha wayaw ba da: “Nenin, tanga nə wamanin gandɨm me nə chànin gandɨm me ca gaa bədə mo? Ɨjɨm kaw, tanga mə gɨləgɨ nare mani mana gɨ ciri ninnə gaa bədə mo?” ");
INSERT INTO sor_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ɨr̰ɨ an̰ji ha cwara wayang ɗang ba da: “Nə ꞌwacn̰ang bədə. Hana bam hən̰ tulɨnnə pad, anə i nare woni àla àcn̰a.” ");
INSERT INTO sor_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Mana gɨ ta lə di, anə ha yara Abɨraham me Isak me Jakob me woni cɨmə Mãr̰ĩ bɨw pad me mana gɨ ciri dɨnə Mãr̰ĩ duwa lə, me ꞌyeni dan da, gɨ ha ꞌywarang bwang bam iche. Mana gɨ ta di i mana gaba nulə gura me yɨdɨbə sande lə me ca. ");
INSERT INTO sor_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Nare ha swaa tulɨn̰ dɨ jomniyə me, dɨ turgɨ lə me, ɨsay gɨ abeyə me gɨ jeleyə me. Cendi ha dama wama bɨwə alə daa ciri dɨnə Mãr̰ĩyə di. ");
INSERT INTO sor_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Yarna, nare yab nə i targɨn̰ caga ka da, ha cwara nə pii cendi. Me nare yab nə i nə pii caga ka da, ha cwara nə targɨn̰ me ca.» ");
INSERT INTO sor_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Wála gɨ ta di lə da, nare nə gɨ ꞌwogɨgɨ Parise nə yab chidɨbə hára Jesu sɨwə me wayɨw ba da: «Cɨm kal ciri dɨ ka di, me ha bam hən̰, dara dole gɨ Erod ùr ba a ꞌyəmme.» ");
INSERT INTO sor_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesu cogɨ waygɨ ba da: «Hana waynaw aba lama mana gɨ ta di da: Laba da, nə ꞌyor dúndi dɨ àcn̰e bam nare sɨdəgɨ lə me, nə so nare daa mwom dayyə me. Sanga kaw, nə ha àla yande bi. Me wála gɨ subu lə da, nə ha ꞌyan̰a giyə ni di le ɗɨm. ");
INSERT INTO sor_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Me wála gɨ laba lə me sanga me kondɨdɨ me da, ùrɨn i ꞌwoo gɨ bɨrmə ɨjə Jursalem, dara gɨ ꞌyána aba cɨmə Mãr̰ĩ bɨw ciri dɨ ɗangə da, ha lə bədə. ");
INSERT INTO sor_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ay, nare nə Jursalem, nare nə Jursalem, ꞌyeni nə anə ꞌyə woni cɨmə Mãr̰ĩ bɨw bam, me nare nə Mãr̰ĩ kɨjəng gandagɨ kaw, anə jərgɨ gɨ kur̰a ꞌyəgɨ bam me ca! Nə kan̰jɨ bɨrmə bá ba nə dáyang dodə ya dure ba dɨ day gɨ dɨndadɨ gɨndɨdɨ lə ta de. Me ꞌyeni da, anə gɨn̰ə bam com! ");
INSERT INTO sor_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Yande da, dwayna: Mãr̰ĩ ha gɨn̰ə ciri dan di bam. I sɨdɨ, nə wayang: Anə ha yaran bədə bɨraa ɗan̰ anə ha waya da: “Kal Aba ciri gɨ Mãr̰ĩ biynəw an̰ju gɨ hára lə gɨ sumɨw di bɨw dɨwə, biynəw bɨw dɨwə” bá do.» ");
INSERT INTO sor_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Wála mɨn gaba bwaa gwayniyə da, geche gɨnə Parise day mɨn ꞌwaga Jesu ba hane wamna mani kɨrə duwa lə. Nare woni dama gandɨw wama bɨwə di ꞌyar yərɨw. ");
INSERT INTO sor_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Mana gɨ ta lə da, abe mɨn gɨ sɨw sodɨbɨ kaw ilə me ca. ");
INSERT INTO sor_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesu u gwale ùr woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa me nare nə Parise me ba da: «Mana gɨ bii ɨnda gɨ ꞌwoo lə da, gɨ nem swaa gun daa mwommə wála gaba bwaa gwayniyə, labaa gɨ sow bədə mo?» ");
INSERT INTO sor_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Cendi àsɨw gwale mɨn lə diiyə bədə. Ɨr̰ɨ Jesu ɓɨl aba mwom di sɨw me, sow daa me, wayɨw an̰ju ba hana ulay duwa lə. ");
INSERT INTO sor_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ɨr̰ɨ Jesu co dɨrəw me waygɨ da: «Inam i wála gaba bwaa gwayniyə kaw, i wi mana gɨ dwar̰angə ka, gorndɨw labaa labe duwa ɨndarna bɨla lə da, an̰ji ha ꞌwów daa kaláng bədə mo?» ");
INSERT INTO sor_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ta di kaw, cendi ꞌyo gwale mɨn gaba àsaw lə diiyə bədə. ");
INSERT INTO sor_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jesu dam yər dara nare pad nə gɨ ꞌwagagɨ dara ba hane wamna mani di ba kan̰jɨ i mana gɨ lade gaba sumi mwom da, an̰ji u gwale gɨ diri waygɨ ba da: ");
INSERT INTO sor_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Wála gɨ gun ꞌwagɨnam ba mə hane wamna haye gɨ dyamdɨrani da, kal kan̰ja mana gɨ lade dama lə pii bɨr̰ɨn̰ ɗi, dara gaa nare nə an̰ji ꞌwagagɨ ta di, gun mɨn gɨ geche gaba ɗwayam bam ilə som. ");
INSERT INTO sor_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Aba ꞌwagang ca dannə ta di gɨra ha wayam ba da: “So daa, kalɨw gun gɨ ta di mana”, ɨr̰ɨ mə ha swaa gɨ jawe hára dama targɨn̰. ");
INSERT INTO sor_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ladni duwa da, mana gɨ gun ꞌwagɨnam dyamdɨraniyə da, ha dama targɨn̰, me aba ꞌwagam di gɨrnay me waynam da: “Jan maché, sway, hare dam mana gɨ ladeyə kwa pii ka!”, ta di do me nare nə gɨ ꞌwagagɨ pad di ha àsam sumi gɨ ꞌwaga dɨmmə sɨn̰. ");
INSERT INTO sor_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Dwayna, gun gɨ unə dɨw daa an̰ju gaba ciri da, Mãr̰ĩ ha huraw dɨw di dodə, me gun gɨ hurna dɨw dodə da, Mãr̰ĩ ha biyəw gandɨdɨ daa me ca.» ");
INSERT INTO sor_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ɨr̰ɨ Jesu wayɨw gun gaba ꞌwagaw di ba da: «Mə ꞌwagɨna gun wama gɨ dawa lə labaa gɨ turgɨ lə da, kal ꞌwaga kwandam moso me, chamram me, war̰am me, woni ciri dɨma bɨdɨ woni ꞌywaa mani me mɨra ɗi. Dara gaa cendi ha cwara ꞌwagam ba mə hane wamna lə biiyə me da, cendi ꞌyogɨm gwayni dɨma di daa ɗɨm. ");
INSERT INTO sor_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ladni duwa da, wála gɨ mə ùrnə ba mə ꞌyànagɨ́ nare mani nə wama da, ꞌwagay nare nə bugɨr me, nə r̰egɨdu me, nə majɨgəndɨ me, nə dɨrəgɨ bu me ca. ");
INSERT INTO sor_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Mə àlna yande da, mə ha dama i gɨ sii ꞌywala! Dara nare nə ta di ha ꞌywaa mani woni ꞌyàm lə biiyə bədə, i Mãr̰ĩ me ɗan̰ ha ꞌywagam an̰ju wála gɨ nare nə tɨba dɨrəwə dara dɨmə daa munɨ lə.» ");
INSERT INTO sor_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Nare nə dam gɨ Jesu wama bɨwə me doy gwale duwa di, gun day mɨn wayɨw da: «Gun gɨ ɗan̰ dara hára wama mani daa ciri dɨnə Mãr̰ĩyə da, ha dama i gɨ sii ꞌywala.» ");
INSERT INTO sor_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ɨr̰ɨ Jesu cow wayɨw da: «Wála mɨn, abe mɨn ɗorbɨ haye me ꞌwaga nare nan̰ ba hane wamna haye di. ");
INSERT INTO sor_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Dawa dɨ haye di nagdɨ mwom da, an̰ji giy kwaya duwa mɨn ba hana waynagɨ nare di ba haneye dara haye di ba naa le ɗɨm. ");
INSERT INTO sor_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ɨr̰ɨ nare nə an̰ji ꞌwagagɨ di gɨn̰ə bam pad dayyə pad. Gɨ mɨn wayɨw da: “Nə kɨl daga ni ilə me, ùrɨn i hára yaraw lə. Kal dusɨm hɨlal dɨnnə.” ");
INSERT INTO sor_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Gɨ ɗang way da: “Nə kɨl labje ni mwaj ilə me, nə ha i gɨrsəgɨ lə. Nə amsɨm ɗe: Kal dusɨm hɨlal dɨnnə.” ");
INSERT INTO sor_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Gɨ mɨn ɗang bi way duwa ba: “Nə u deme dɨ dɨrway caga caga ka ilə. Ta di me nə nem hára bədə.” ");
INSERT INTO sor_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Kwaya di cwara hára kɨbɨw aba ciri duwa di gwale gɨ nare wayaw ta di daa pad. Ɨr̰ɨ aba ciri di dusɨw naw me, wayɨw kwaya di ba da: “Ha kaláng mana gɨ ciri dwar̰ɨ lə me bur̰əgɨ lə me walay nare nə bugɨr me nə majɨgəndɨ me nə dɨrəgɨ bu me nə r̰egɨdu me hare gandagɨ.” ");
INSERT INTO sor_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ɓam yande da, kwaya di hára wayɨw aba ciri duwa di ba da: “Aba ciri ni, mani nə mə wayɨn ba nə àlna di, nə àlgɨ̀ ɗɨm me, mana gaba dama di wor lə sɨn̰.” ");
INSERT INTO sor_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Aba ciri di wayɨw kwaya duwa di ba da: “Ha mana gɨ bɨrmə lə me gər tarɨwə cab cab me, walay nare kalgɨ gɨ hára ꞌwon kulu ni dalaw daa bá. ");
INSERT INTO sor_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Dwayna, nə wayang, nare nə nə ꞌwagagɨ pii me gɨn̰ə hára bam ta di, gun day mɨn ha nyama ɓɨlə haye gɨ nə ɗorɨw ta di bɨwə bədə.”» ");
INSERT INTO sor_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Mana gɨ Jesu ilə hára lə bɨrmə lə gɨ nare nə gɨr̰e di mwom da, an̰ji co dɨrəw yərgɨ me waygɨ da: ");
INSERT INTO sor_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Gun gɨ ùrnə ba a gɨdɨnə aba gɨrsə gwale ni da, kal a ùrnən ɨndi ɗwayna abəw bam me, iw bam me, dyaməw bam me, dɨndaw bam me, chamraw nə abje me nə namde me bam me, sɨw duwa an̰ju gang bam me ca. An̰ji àlna yande bədə da, nem gɨdə aba gɨrsə gwale ni bədə. ");
INSERT INTO sor_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Gun gɨ unə habda duwa gɨ dagɨla dɨwə me pamnan nɨm bədə me da, an̰ji ha nyama gɨdə aba gɨrsə gwale ni bədə. ");
INSERT INTO sor_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ɨrmɨnə ladɨ le: Gun mɨn dwar̰angə ùrnə ba awna kulu gɨ geche da, kalɨw a damna dodə àsɨna gursɨ duwa di gaa ha nyama ꞌyan̰aw kulu di maa mo. ");
INSERT INTO sor_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Pəgɨn̰ bədə da, an̰ji swana yande bɨr̰ɨn̰ àsɨna kulu di gɨndɨw me ꞌyan̰ɨnaw bədə da, nare pad nə yarna kulu gɨndɨw gɨ ta di da, ha piyəw baya me ");
INSERT INTO sor_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ha waya da: “Yarna! Abe gɨ ta di, i gun gɨ àsɨ kulu gɨndɨw me nem ꞌyan̰aw bədə di!” ");
INSERT INTO sor_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ya dole mɨn ùrnə ba hana jirmənə jaw gɨ dole say da, an̰ji dam dodə yər gaa asɨngar duwa nə dubu mwaj di da, nem jara say gɨ asɨngar nə dubu gɨnɨn̰ sɨr nənə jaw dole duwa di mo? ");
INSERT INTO sor_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","An̰ji yarna dwana duwa nyamna bədə da, mana gɨ jaw dole di warnay hən̰ sɨn̰ da, an̰ji kɨjɨ nare ha ꞌywaw dara ba gɨ ɗangr̰ɨ gwale kal ba gɨ dam labiya. ");
INSERT INTO sor_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Yande da, gun gɨ gɨn̰ɨnə mani duwa nə ꞌywaa bam bədə da, an̰ji kaw ha nyama gɨdə aba gɨrsə gwale ni bədə me ca.» ");
INSERT INTO sor_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«Wála da, i mani nə lade, me mana gɨ wàla di hɨranga duwa biyarna bam mwom da, gɨ ha àláw man me ha cwara hɨranga ɗang bi mo? ");
INSERT INTO sor_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","An̰ji àl giyə mɨn bədə ɗɨm, gɨ bwanaw yiga lə kaw, gur duwa gaba swaa swagə ilə bədə ɗɨm. Giyə duwa i twaa gɨ bam iche ɗɨm. Gun gɨ sumdəw woni dwaya gwale ina lə da, kal a dwayna.» ");
INSERT INTO sor_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Nare woni salaw dole gɨ geche gɨ Rom mani me, woni àla àcn̰a nə ɗang me dayar pad Jesu tulɨwə dara dwaya gɨ gwale duwa. ");
INSERT INTO sor_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ɨr̰ɨ nare nə gɨ ꞌwogɨgɨ Parise me woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa me, n̰amdɨ gwale ba da: «Gun gɨ ta di, i man me yɨ nare woni àla àcn̰a sɨwə me wom gandagɨ mani me ca mo?» ");
INSERT INTO sor_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ɨr̰ɨ Jesu waygɨ gwale gɨ diri ba da: ");
INSERT INTO sor_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Gun mɨn mana gɨ dwar̰angə pagɨna dɨmən̰je aru, me dɨ mɨn ana nwalna bam da, an̰ji ha kala nə gɨnɨn̰ dunamɨn gɨ dii dunamɨn di dodə, me ha hára kan̰ja dɨ mɨn dɨ ta di bɨraa ꞌywadɨ bá do bədə mo? ");
INSERT INTO sor_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Mana gɨ an̰ji ꞌywanadɨ mwom da, ha ꞌwódɨ àsadɨ kunəwə gɨ sii ꞌywala. ");
INSERT INTO sor_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","An̰ji cwarnay hane ulay da, gɨra ha ꞌwaga kwandaw moso me, woni ciri duwa bɨdɨ me, ha wayagɨ da: “Àlnandɨ sii ꞌywala, dara dɨmən̰ ni dɨ nwala bam di, nə ꞌywadɨ ɗɨm.” ");
INSERT INTO sor_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nə wayang, alə daa ciri dɨnə Mãr̰ĩyə kaw, ha wunə i yande me ca: Gun mɨn gaba àla àcn̰a kalna àcn̰a duwa bam me hane ꞌywana Mãr̰ĩ da, gɨ ha àla sii ꞌywala gɨ geche ɗwaya nare nə gɨnɨn̰ dunamɨn gɨ dii dunamɨn nə i tɨba Mãr̰ĩ dɨrəwə nə ùrgɨ bwaa gɨ bɨdəgɨ ɗang bədə di bam.» ");
INSERT INTO sor_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","«Ɗang da, ya deme mɨn gursɨ dɨra ina lə chile mwaj me, chile mɨn sɨr̰ɨnə nwalna bam da, tandi ha gɨrə dùwa lamba lə me, ha twaja gɨ kulu dalaw di bam kan̰jadɨ nɨm angal angal bɨraa ꞌywadɨ bá do bədə mo? ");
INSERT INTO sor_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Mana gɨ tandi ꞌywanadɨ mwom da, tandi ha ꞌwaga kwandadɨ mware me woni ciri dɨra bɨdɨ me, wayagɨ da: “Àlnandɨ sii ꞌywala, dara gursɨ ni dɨ dee nol bam di, nə yala ꞌyodɨ ɗɨm.” ");
INSERT INTO sor_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nə wayang, alə daa ciri dɨnə Mãr̰ĩyə kaw, ha wunə i yande di me ca: Gun mɨn gaba àla àcn̰a kalna àcn̰a duwa bam me hane ꞌywana Mãr̰ĩ da, paja nənə Mãr̰ĩ duwa nə daa ha àla sii ꞌywala nan̰e me ca.» ");
INSERT INTO sor_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesu u gwale gɨ diri waygɨ ɗang bi ba da: «Abe mɨn, dɨndaw nə abje sɨr ilə. ");
INSERT INTO sor_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Wála mɨn da, gɨ dwe wayɨw abəw da: “Aban, ɨsɨnin mani nə ɗan̰ ha waranin dɨba di bam gɨ dɨrəm dɨma.” Ɨr̰ɨ abəw di kaw, so ɨsɨgɨ dɨba di bam me ca. ");
INSERT INTO sor_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Àl wála ɓani da, gɨ dwe di day mani duwa di kɨlgɨ bam me so ha mana gɨ ciri dɨ ɗang dɨ yēyə. Mana gɨ ta lə di, an̰ji àl mani nə ha gɨ bɨrmə day bədə, me mendɨ mani duwa di bam pad. ");
INSERT INTO sor_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Wála gɨ an̰ji mendɨ mani duwa nə ꞌywaa di bam pad mwom da, badɨgara dɨ geche ɨndər mana gɨ ciri dɨ ta lə di, ɨr̰ɨ mani pad yala jalɨw ɗɨm. ");
INSERT INTO sor_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","An̰ji so ha ꞌywaa gun mɨn mana gɨ ciri dɨ ta lə di ba ꞌyànaw giyə. Mwom da, gun di giyɨw ba hana bam gamnaw gochəng. ");
INSERT INTO sor_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","An̰ji ùr ba a wom mani nə gochəng womgɨ di me, gun mɨn kaw ꞌyàw bədə. ");
INSERT INTO sor_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ɨr̰ɨ an̰ji dam ɨrɨm gwale dusɨwə me way ba da: “Woni àla giyə ɨndi na mana gɨ kɨrə nə abannə wom ɨbdɨ me, mani gɨndəgɨ wor bɨlbɨ dodə me, cor man me, ɨndi nə mar cherni ka mo? ");
INSERT INTO sor_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Caga da, nə ha cwara hára ꞌywaa aban di me, nə ha wayaw da: Aban, nə àl i àcn̰a Mãr̰ĩ dɨrəwə me, ɨjɨm dɨrəmmə me ca. ");
INSERT INTO sor_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Caga da, nə nem gɨ mə yərɨn ya gorndɨm de bədə ɗɨm. Me con ya gun dɨma gaba àlám giyə ta de.” ");
INSERT INTO sor_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","An̰ji so cor ba a ha ꞌywaa abəw di. Mana gɨ an̰ji wor bɨrmə lə hən̰ sɨn̰ da, abəw di yaraw hára lə me, dɨrəw ꞌyəngɨw dɨwə me wada hára saw dɨrəw daa jirmɨw yə̀w sɨwə. ");
INSERT INTO sor_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ɨr̰ɨ gorndɨw di wayɨw da: “Aban, nə àl i àcn̰a Mãr̰ĩ dɨrəwə me, ɨjɨm dɨrəmmə me ca. Nə nem gɨ mə yərɨn ya gorndɨm de bədə ɗɨm.” ");
INSERT INTO sor_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Cor abəw di waygɨ kòy duwa ba da: “Wana kaláng, laynay barge gɨ lade hurnaw sɨwə me, hurnaw kulɨm ɨsəwə me gɨbande gɨdawə me ca. ");
INSERT INTO sor_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Yɨnə labe gɨ dwe gɨ əne, ꞌyánaw me, də wamang me də ajang pide me ca. ");
INSERT INTO sor_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Dara gorndɨn gɨ anə yərɨw ta di, i ya ba mare me ba dɨmə i daa munɨ lə ta de. An̰ji tanga nol i bam me, nə yala ꞌyow bi.” Mana gɨ ta lə di, cendi diy gɨnɨn̰ ilə àla sii ꞌywala lə. ");
INSERT INTO sor_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ɨr̰ɨ gorndɨw gɨ geche di wara duwa i bam yiga lə. Mana gɨ an̰ji swaa bam gɨra ciri gogɨr dɨra lə ib mwom da, an̰ji doy mani nə too nɨmə day me n̰ar̰a me ca. ");
INSERT INTO sor_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","An̰ji ꞌwaga aba àla giyə kɨrə nə abəwə mɨn me, ùrɨw dara mani nə àlal kɨrə nə abəwə di. ");
INSERT INTO sor_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Aba àla giyə di cow wayɨw da: “I chendɨm gɨ dwe di cwara yala bi, me abam ꞌyə labe gɨ dwe gɨ əne, dara chendɨm di, ba a yala ꞌyow gɨ labiya.” ");
INSERT INTO sor_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Cor gorndɨw gɨ geche di, dusɨw naw me gɨn̰ hára gɨ kɨrə bam. Ɨr̰ɨ abəw di dɨmə iche gɨra mɨrgɨw, an̰ju ba hane kɨrə. ");
INSERT INTO sor_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ɨr̰ɨ an̰ji wayɨw abəw di ba da: “Nə dam gandɨm aliya nan̰, nə àlɨ́m giyə ya kwaya de, me nə gɨn̰ bɨm bam bədə bɨr̰ɨn̰ me ca kaw, dii mɨn yande mə ꞌyàn cange dɨ dwe dara ba nə ꞌyána àlna gɨ sii ꞌywala gɨ kwandan moso bədə. ");
INSERT INTO sor_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Cor gorndɨm gɨ cwara yala ta di, i gɨ ꞌwoo wama mani dɨma nə ꞌywaa bam pad gɨ namde nə kaya, me mə ꞌyəw labe gɨ dwe gɨ əne an̰ju mo?” ");
INSERT INTO sor_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Abəw di wayɨw ba da: “Gorndɨn, ɨjɨm, mə ilə gandɨn gɨ wála wála, mani ni nə ꞌywaa pad kaw, i dɨma ɨjɨm. ");
INSERT INTO sor_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Yande da, ca ɨnda lə ca, dee ùrndɨ i àla gɨ sii ꞌywala dara chendɨm gɨ ta di. An̰ji i ya ba mar i bam me ba dɨmə daa munɨ lə ta de. An̰ji nol i bam me, nə yala ꞌyow bi.”» ");
INSERT INTO sor_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ɨr̰ɨ Jesu waygɨ woni gɨrsə gwale duwa gwale gɨ diri ɗang ba da: «Gun gaba ꞌywaa mani mɨn ꞌyàw aba gama mani, mani duwa nə ꞌywaa ɨsəwə. Me nare gɨra wayɨw ba gun duwa gɨ ta di, ba mendɨw mani duwa nə ɨsəwə di bam. ");
INSERT INTO sor_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Aba ciri duwa di ꞌwagaw hára nɨm sɨwə me wayɨw da: “Nə doy nare wayɨn gwale dɨma nan̰ yande, dana mo? Caga da, àsɨn mani ni nə nə ꞌyàm ɨsəmmə di daa pad, dara nə ha kalam, mə ha àlán giyə ni di bədə ɗɨm.” ");
INSERT INTO sor_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Aba gama mani di ɨrɨm dusɨwə ba da: “Aba ciri ni di ha ꞌywaran bam da, nə ha àla i man man mo? Dwana ni dɨ idɨ yiga ilə bədə. Nə hana amsɨna mani le, i jawe me ca. ");
INSERT INTO sor_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","A! Nə ꞌwocn̰ mani nə nə ha àlagɨ̀ me, nare ha yə̀n nɨm sɨdəgɨ lə wála gɨ aba ciri ni ꞌywarnan bam giyə duwa lə di.” ");
INSERT INTO sor_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Mana gɨ ta lə da, aba gama mani di ꞌwaga nare nə an̰ji ꞌyàgɨ́ mani nənə aba ciri duwa lə dɨdəgɨ lə di mɨn mɨn hára nɨm sɨwə. Me an̰ji ùr gɨ pii ba da: “Mani nənə aba ciri ni di ilə dɨmmə ɨndi na mo?” ");
INSERT INTO sor_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Aba ꞌwoo kwale di wayɨw ba da: “Gɨyaye nə swani aru ilə dɨnnə.” Me an̰ji cow wayɨw da: “Dam dodə, u maktubu dɨma kaláng me, jangɨ gɨnɨn̰ jii.” ");
INSERT INTO sor_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ɨr̰ɨ an̰ji wayɨw gɨ mɨn ɗang ba da: “Ɨjɨm da, kwale di i ɨndi na dɨmmə mo?” Me an̰ji wayɨw da: “Suwal gɨ geme aru.” Aba gama mani di cor wayɨw da: “Dam dodə, u maktubu dɨma me, jangɨ gɨnɨn̰ dunasɨr.” ");
INSERT INTO sor_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Aba ciri di dam yər maché duwa gɨ àcn̰e di kojɨgə duwa dɨ an̰ji àldɨ̀ me bow sɨwə, dara an̰ji àla mani gɨ dɨrɨn̰ naa. I sɨdɨ, nare nə sɨn̰a dɨdə ka da, àl mani gɨ dɨrɨn̰ naa nan̰ gɨ kwandagɨ ɗoy nare nə dam mana gɨ ácn̰e gɨnə Mãr̰ĩ duwa lə bam.» ");
INSERT INTO sor_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Me Jesu waygɨ da: «Dwayna, ɨndi da, nə wayang: ꞌYeni da, unə ꞌywaa dan gɨ sɨn̰a dɨdə ka gaba lama mana di yɨnə gɨ mɨlan gɨ kwandang nare. Yande da, wála gɨ mani di ꞌyan̰ɨna bam ɨsɨrangə kaw, gɨ ha yə̀ng nɨm mana gaba dama gɨ dɨrɨn̰ bɨr̰ɨn̰yə di. ");
INSERT INTO sor_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Yarna, gun gɨ mə nem kala dusɨm dɨwə mani nə ɓaniyə da, nə gechideyə kaw, mə ha nyama kala dusɨm dɨwə me ca. Me gun gɨ àlna mani nə ɓani gɨ bɨrmə day bədə da, mani nə gechide kaw, an̰ji ha àlagɨ̀ gɨ bɨrmə day bədə me ca. ");
INSERT INTO sor_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Mani nə ꞌywaa woni lama mana nə sɨn̰a dɨdə ka, anə àlnagɨ̀ gɨ bɨrmə duwa bədə da, i wi me ha kala dusɨw dɨdəngə ꞌyàng mani sɨdəgɨ nə lade nə daa ɨsɨrangə mo? ");
INSERT INTO sor_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Labaa, mani nənə gun duwa nə ꞌyàng ɨsɨrangə me anə àlnagɨ̀ gɨ bɨrmə day bədə da, nə dan nə gɨ ɨrɨm ba gɨ ha ꞌyàng da, i wi me ha ꞌyàng gandagɨ ɨsɨrangə mo? ");
INSERT INTO sor_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Kwaya mɨn nem àlagɨ́ dolgə sɨr giyə bədə. An̰ji ha ùrə gɨ mɨn nan̰ me ha gɨn̰ə gɨ mɨn bam, labaa ha yəə gɨ mɨn nan̰ me ha àla gɨ mɨn ichɨn̰ me ca. Anə nem àláw Mãr̰ĩ giyə me gɨdɨ kwaya gɨnə gursɨ dɨra me ca bədə.» ");
INSERT INTO sor_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Mana gɨ Jesu way gwale duwa di ꞌyen̰ bam pad mwom da, nare nə gɨ ꞌwogɨgɨ Parise nə doy gwale gɨ an̰ji wayɨw di àlɨ̀w məng, dara cendi ùr gursɨ nan̰e. ");
INSERT INTO sor_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ɨr̰ɨ an̰ji waygɨ da: «ꞌYeni da, anə ùr dara nare ba yarnang anə banə i nare nə tɨba Mãr̰ĩ dɨrəwə, me Mãr̰ĩ da, ꞌwocn̰ dusɨrəng dɨ korgɨn̰ com. Dwayna, mani nə nare yərgɨ ba i nə lade da, Mãr̰ĩ yərgɨ ba i mani nə àl ɨn̰ama.» ");
INSERT INTO sor_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","«Bii gɨ ꞌwoo gɨnə Moyis duwa me berni dɨnə woni cɨmə Mãr̰ĩ bɨw day me da, gɨlgɨ nare bɨrmə cendi bɨraa hára nɨm wála gɨnə Jã Batis lə bá. So wála gɨnə Jã Batis lə da, gɨ way i nõ dɨ dwãr̰ĩ dɨnə Mãr̰ĩ duwa gwale dɨra, me wi wi kaw, jər dara ba a gandɨ ha mana gɨ ciri dɨnə Mãr̰ĩyə di gɨ dwana.» ");
INSERT INTO sor_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","«Siyaya me sɨn̰a me myandara day gɨ bam da, wom bədə, me biyə gɨ mani bam hin̰e mana gɨ janga gɨ bii gɨ ꞌwoo lə da, ilə bədə.» ");
INSERT INTO sor_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","«Gun gɨ ꞌywarna dyaməw bam me hana unə dɨ ɗang da, an̰ji àl i àcn̰a gɨ gichɨni. I ya an̰ji ba i i gɨ jaw dyaməw de. Ɗang tugu, gun gɨ unə deme dɨ tɨrədɨ ꞌywaradɨ bam da, an̰ji àl i àcn̰a gɨ gichɨni di me ca. I ya an̰ji kaw, ba i i gɨ jaw dyaməw de me ca.» ");
INSERT INTO sor_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","«Wála mɨn da, abe mɨn gaba ꞌywaa mani ilə; an̰ji hurbə i barge gɨ ladɨbe gɨ ꞌyogde gɨ kili duwa wom nan̰ sɨwə jwab jwab. Me gɨ wála wála da, an̰ji àl i sii ꞌywala me ca. ");
INSERT INTO sor_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Abe gɨ bugɨr mɨn gɨ sɨw sabar jarbe gɨ gɨ ꞌwogɨw Lajar hára igdɨ ciri duwa bɨdə. ");
INSERT INTO sor_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","An̰ji ùr dee ba tɨgdɨ haye gɨ susɨgɨ dodə tabɨl gɨndɨdɨ lə wom dara ꞌyáa gɨ cherni duwa, ɨr̰ɨ gɨrade kaw, hára lagdɨ diyabe duwa me ca. ");
INSERT INTO sor_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Wála mɨn da, abe gɨ bugɨr di mar me Paja nənə Mãr̰ĩ duwa nə daa uw ha nɨm chə́w Abɨraham tulɨwə. Me aba ꞌywaa mani di kaw, mar me gɨ muw bam me ca. ");
INSERT INTO sor_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Mana gɨ bengə da, aba ꞌywaa mani di gɨl dɨrɨn̰ nan̰e, me mana gɨ ba a u dɨrəw daa mwom da, yər Abɨraham ɗɨbɨ lə hən̰ me Lajar ilə tulɨwə me ca. ");
INSERT INTO sor_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ɨr̰ɨ aba ꞌywaa mani di soy daa nan̰ ba da: “Aban gɨ Abɨraham, yər n̰agɨni ni ɗe! Giyəy Lajar kalɨw a sunə dùnɨw nimiyə hane ɓɨlnən dilesɨnnə ɗe, dara nə gɨl dɨrɨn̰ nan̰e dùwa dɨ ka di dɨrədɨ lə.” ");
INSERT INTO sor_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abɨraham wayɨw da: “Gorndɨn, ɨrɨm dara tanga pii da, mə ꞌywaa ꞌywala dɨma bam sɨn̰a dɨdə ɗɨm, me Lajar duwa da, tanga ꞌywaa i wamani. Ɨr̰ɨ caga, mana gɨ ka di lə da, gɨ yala àsɨw hɨlala dusɨwə me, ɨjɨm da, mə wor i gɨlə gɨ dɨrɨn̰yə ɗɨm. ");
INSERT INTO sor_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ɗang kaw, beng gɨ geche ilə dwar̰andɨ lə. Beng gɨ ta di, i yande dara gun nin ùrnə le kaw, nem cilangaw hára sɨdəngə bədə me, ꞌyeni kaw, anə nem cilangaw hára sɨdəninnə bədə me ca.” ");
INSERT INTO sor_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Aba ꞌywaa mani di wayɨw Abɨraham ba da: “Ina yande da, aban, nə amsɨm ɗe: Giy Lajar kalɨw a hana kɨrə nə abannə, ");
INSERT INTO sor_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","dara chamran jii wara lə. A hana waynagɨ mani nə ꞌyon ka di gwale day, kal cendi gɨ hane mana gaba gɨlə dɨrɨn̰ gɨ ka lə di lə bədə ɗɨm.” ");
INSERT INTO sor_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ɨr̰ɨ Abɨraham cow wayɨw da: “Kalgɨ gɨ dwayna gwale gɨnə Moyis duwa me gɨnə woni cɨmə Mãr̰ĩ bɨw day me ɗɨm.” ");
INSERT INTO sor_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Aba ꞌywaa mani di cor wayɨw da: “Yande bədə, aban gɨ Abɨraham, me gun dɨmnə daa nare nə mare dwar̰agɨ lə hana waynagɨ da, cendi ha kala àcn̰a day bam me ha hára ꞌywaa Mãr̰ĩ sɨn̰.” ");
INSERT INTO sor_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ɨr̰ɨ Abɨraham cor wayɨw da: “Cendi dwayna gwale gɨnə Moyis duwa bədə me gɨnə woni cɨmə Mãr̰ĩ bɨw day bədə me da, gun dɨmnə daa nare nə mare dwar̰agɨ lə hana waynagɨ kaw, cendi ha yəə gwale duwa bədə com.”» ");
INSERT INTO sor_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ɨr̰ɨ Jesu waygɨ woni gɨrsə gwale duwa ba da: «Sɨn̰a dɨdə ka da, mani woni lama nare bwagɨ àla gɨ àcn̰a lə ha ꞌya lə bá. Ɗɨm da, gun gɨ hane gɨ mani nə ta di lamna gɨ kwandaw bwanagɨ àla gɨ àcn̰a lə di da, wamani ha ꞌywawe! ");
INSERT INTO sor_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Gun gɨ nem mani bədə nare dɨrəgɨ lə kaw, gun gɨ lamnaw àsɨnaw àla gɨ àcn̰a lə da, aba lamaw di, gɨ manaw kur̰a dɨ jore dɨ noy nan̰ kunəwə me gɨ unəw álnaw mana gɨ nimi nə kuray gɨ gecheyə kaw, womme bədə sɨn̰. ");
INSERT INTO sor_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Yande da, àsɨna angal dan ladɨ le!» «Chendɨm àlna àcn̰a da, gɨsɨwe. An̰ji ꞌwacn̰ana ba a àl i àcn̰a da, kal dusɨm hɨlal dɨwə. ");
INSERT INTO sor_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","An̰ji àlna gandɨm àcn̰a dii wurgɨsubu wála mɨn dalawə me, cwarnay hane ꞌywanam dii wurgɨsubu wála gɨ ta di dalawə me ùrnəm dusi dɨ hɨlale da, kal dusɨm hɨlal dɨwə.» ");
INSERT INTO sor_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Paja nənə Aba ciri gɨ Jesu duwa wayɨw ba da: «Àl kal dusi nin dɨ kala di dɨ jwarna le.» ");
INSERT INTO sor_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ɨr̰ɨ Aba ciri gɨ Jesu di cogɨ waygɨ ba da: «Dee dusi dan dɨ kala di ina i ɓani hin̰e ya habda gɨ mutardɨ dɨrəw de mɨra kaw, anə ha nyama wayaw habda gɨ dam i ta di ba biyarna daa gɨ sabɨraw ɓurag, ba hana ɗɨlalna kuray dalawə kaw, an̰ji ha biyara hára ɗɨlala le.» ");
INSERT INTO sor_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","«Ya gun mɨn dwar̰angə kwaya duwa gaba yigaw labaa gamaw mani nə paga ina lə. Mana gɨ an̰ji swanay bam gɨrnəy da, aba ciri duwa di ha wayaw ba hane kaláng, ba wamna mani mo? ");
INSERT INTO sor_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Bədə, an̰ji ha wayaw ba da: “Ɗorɨn haye, me huray barge dɨma gɨ ɗang me, hare ɗwagɨr̰an ni ꞌyàn nə wom me nə chə̀ me bam do me, mə ha wama me mə ha chàa dɨma me sɨn̰.” ");
INSERT INTO sor_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ɓag da, kwaya àlna mani nə aba ciri duwa wayaw ba àlnagɨ̀ da, aba ciri duwa di ha àláw dóche mo? An̰ji ha àláw dóche bədə. ");
INSERT INTO sor_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","ꞌYeni kaw, ha ꞌya i yande di me ca. Wála gɨ anə àlna mani nə aba ciri dan gɨ Mãr̰ĩ ùrnə anə banə àlnagɨ̀ da, wayna da: “Nə inin kòy dɨma nə woni dama dɨrəmmə nə pəgɨn̰ yande, nə àlanin i mani nə ùrnin i àla mɨra.”» ");
INSERT INTO sor_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Mana gɨ Jesu ha dara hára Jursalem da, an̰ji jə̀ i gɨ wama gɨ Samari bulə day gɨ Galileyə. ");
INSERT INTO sor_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Mana gɨ an̰ji dɨm ciri mɨn dɨdə da, woni cagɨm mwaj ha saw dɨrəw daa, me gɨra ɗɨbɨgɨ bam hən̰ gandɨw. ");
INSERT INTO sor_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Cendi amsɨw gɨ mar̰ɨjagɨ daa nan̰ ba da: «Jesu, aba ciri nin, yər n̰agɨni nin ɗe!» ");
INSERT INTO sor_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesu yərgɨ me waygɨ ba da: «Hana gɨlnəgɨ woni bwasa Mãr̰ĩ sɨdəng.» Mana gɨ cendi ilə hára lə mwom da, cagɨm day di sɨr̰ɨbɨ bam sɨdəgɨ lə. ");
INSERT INTO sor_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Mana gɨ gɨ mɨn dwar̰agɨ lə yər dara cagɨm di ba sɨr̰ɨ bam sɨwə da, an̰ji cwara gɨdaw dɨdəgɨ lə mɨjag bow Mãr̰ĩ jilay gɨ mar̰ɨjaw daa nan̰. ");
INSERT INTO sor_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","An̰ji gɨra piy gubɨrəw dodə Jesu dɨrəwə me ɨbər dodə me àlɨ́w dóche. Me aba cagɨm gɨ ta di, i gun gɨ Samari. ");
INSERT INTO sor_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jesu u gwale way da: «Dee nare nə cagɨm sɨr̰ɨbɨ bam sɨdəgɨ lə di i mwaj gaa bədə mo? Me nə dunamɨn di, we day mo? ");
INSERT INTO sor_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Gun gɨ ɗang mɨn kaw, cwara gɨra àlɨ́w Mãr̰ĩ dóche bədə, i mɨje gɨ ta di mɨn duwa lə mo?» ");
INSERT INTO sor_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ɨr̰ɨ Jesu wayɨw da: «So daa, ha le! Mə kala dusɨm dɨnnə da, mə ꞌyo labiya.» ");
INSERT INTO sor_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Wála mɨn, nare nə gɨ ꞌwogɨgɨ Parise ùr Jesu ba da: «Dwãr̰ĩ dɨnə Mãr̰ĩ duwa da, hára i mindi na mo?» An̰ji cogɨ waygɨ ba da: «Dwãr̰ĩ dɨnə Mãr̰ĩ duwa da, gun ha yara hára dɨra gɨ dɨrəw bədə. ");
INSERT INTO sor_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Gun ha wayang da, hane, tandi ba i ka, labaa, ba i alə ta da, i yande bədə. Ɨrmɨnə ladɨ le, dara Mãr̰ĩ ilə lama dwãr̰ĩ duwa di lə dwar̰angə ka ɗɨm.» ");
INSERT INTO sor_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ɨr̰ɨ an̰ji waygɨ woni gɨrsə gwale duwa di ba da: «Ɗan̰ wála mɨn hára lə. Wála gɨ ta lə di, anə ha ùrə dara anə banə yər wála mɨn tenene gɨnə ɨndi gɨ Gun gorndɨw ni di kaw, anə ha yaraw bədə.» ");
INSERT INTO sor_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","«Gɨ ha wayang ba da, Kris di ba ilə ka, labaa, ba ilə alə ta da, hana lə bədə me, wana kaláng hana lə bədə me ca. ");
INSERT INTO sor_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Dara wála gɨ ɨndi gɨ Gun gorndɨw nə cwarnay hane da, ha wunə i ya Mãr̰ĩ ba a wur̰ɨn̰ me ácn̰ gɨ siyaya bam so tulɨn̰ dɨ ka lə bɨraa ha tulɨn̰ dɨ alə ta lə de. ");
INSERT INTO sor_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pii pa da, ùrɨn i gɨlə gɨ dɨrɨn̰ nan̰ me, nare nə caga ka lə di kaw ha gɨn̰ən bam do me ca.» ");
INSERT INTO sor_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","«Wála gɨ ɨndi gɨ Gun gorndɨw di, nə cwarnay hane da, mani ha àlala wunə i ya nə tanga àlal wála gɨnə Nuwe duwa lə ta de. ");
INSERT INTO sor_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Wála gɨ ta di lə da, nare dam wom me chə̀ me, lay namde me wur dɨndɨragɨ nə namde abjeyə me, bɨraa wála gɨ Nuwe gɨra gandɨ nɨm bɨrwa gɨ geche dalawə bá. Ɨr̰ɨ, nimi nə geche gɨra laygɨ ꞌyəgɨ bam pad. ");
INSERT INTO sor_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ɗang kaw, cwara gɨnə ɨndi gɨ Gun gorndɨw ni di da, ha wunə i ya tanga pii ɓɨg wála gɨnə Lot duwa lə ta de me ca. Nare wom me, chə̀ me, kɨl mani me, kɨl mani day bam me, yɨgɨ swagə me, aw kululi me ca. ");
INSERT INTO sor_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ɨr̰ɨ wála gɨ Lot dɨmə bam ciri dɨ Sodommə da, Mãr̰ĩ ꞌwāa dùwa duwa ya nimi de ɓamadɨ gɨ kur̰a dɨ dùwa sɨdə mɨn gɨra ul nare bam pad. ");
INSERT INTO sor_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Wála gɨ ɨndi gɨ Gun gorndɨw nə dara dɨmə gɨlə sɨn di kaw, ha dɨmə i jisgɨ nare dɨdəgɨ lə ya tanga mani ba dɨm nɨm nare dɨdəgɨ lə wála gɨnə Nuwe day gɨ Lot lə ta de me ca.» ");
INSERT INTO sor_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","«Wála gɨ ta lə da, gun gɨ ina lə daa kulu duwa dɨwə da, a chɨ́nə dodə dara laya gɨ mani duwa nə ilə dodə di bədə ɗɨm. Me gun gɨ ina i bam yiga lə kaw, a cwarnay hane ulay bi bədə ɗɨm me ca. ");
INSERT INTO sor_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ɨrmɨnə gwale gɨnə Lot dyaməw dɨra dɨwə! ");
INSERT INTO sor_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Gun gɨ ùrnə dara ba a bɨl sɨw duwa dodə sɨn̰a dɨdə ka da, an̰ji ha nwala bɨlə duwa gaba dama gɨ dɨrəw bɨr̰ɨn̰ di i bam. Me gun gɨ gɨn̰ɨnə bɨlə gɨ sɨw gɨ sɨn̰a dɨdə ka di bam da, an̰ji ha ꞌywaa bɨlə gaba dama gɨ dɨrəw bɨr̰ɨn̰ di le.» ");
INSERT INTO sor_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","«Dwayna, nə wayang: Wála gɨ ɨndi gɨ Gun gorndɨw di nə cwarnay hane da, nare sɨr ina solbə lə ca da, gɨ ha ɓɨr̰ə gɨ mɨn hára nɨm me, gɨ ha kala gɨ mɨn dodə me. ");
INSERT INTO sor_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Namde sɨr ha ɗɨbə gine bɨwə ɨgə lə, gɨ ha ɓɨr̰ə dɨ mɨn hára nɨm me, gɨ ha kala dɨ mɨn dodə me. ");
INSERT INTO sor_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Abje sɨr ha ɗɨbə daga dalawə mɨn yiga lə: Gɨ ha ɓɨr̰ə gɨ mɨn hára nɨm me, gɨ ha kala gɨ mɨn dodə me ca.» ");
INSERT INTO sor_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ɨr̰ɨ woni gɨrsə gwale duwa di ùrɨw ba da: «Aba ciri nin, mani nə ta di ha àlala i mana gɨ weyə mo?» An̰ji cogɨ lə diiyə waygɨ gɨ gwale gɨ diri ba da: «Mana gɨ we we gɨ kumbɨ ina lə da, duni ha dayara lə me ca.» ");
INSERT INTO sor_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesu waygɨ woni gɨrsə gwale duwa gwale gɨ diri cendi ba amsɨna Mãr̰ĩ ajɨmarna nɨm me ba kalna sɨdəgɨ ba wànagɨ bədə me ca. ");
INSERT INTO sor_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","An̰ji waygɨ da: «Mana gɨ ciri dɨ gecheyə mɨn, aba àla sariya mɨn gɨ lán̰ɨw Mãr̰ĩ bədə me dolɨw gɨ gun bədə me ca ilə. ");
INSERT INTO sor_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ciri dɨ ta lə di kaw, deme mɨn dɨ wambɨ ilə me ca. Tandi hára ꞌyow gɨ wála wála me wayɨw da: “Aba mar̰ande ni jiban nan̰e. Wannə, anin sariya di bam.” ");
INSERT INTO sor_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Wála nan̰, an̰ji gɨn̰ gwale dɨra di bam. Ɨr̰ɨ targɨn̰ ɗang da, an̰ji ɨrɨm dusɨwə ba da: “Nə lán̰ɨw Mãr̰ĩ bədə me, dolɨn gɨ gun bədə me ca kaw, ");
INSERT INTO sor_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","wambɨ dɨ ta di jiban nan̰e. Yande da, nə ha wadɨ lə adɨ sariya di bam le dara kaldɨ dɨ cwarnay ɗugɨrɨnən sumdɨn ɗang bədə ɗɨm.”» ");
INSERT INTO sor_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Me aba ciri gɨ Jesu way ɗang ba da: «Aba àla sariya gɨ ta di, i gɨ àcn̰e, me ɨrmɨnə gwale gɨ an̰ji wayɨw di dɨwə. ");
INSERT INTO sor_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Me Mãr̰ĩ da, nare duwa nə an̰ji an̰jirɨgɨ nə ilə bwaw gura lə gɨ dawa me gɨ changa me, anə ɨrɨm dara ba ha wagɨ lə bədə mo? An̰ji ha wagɨ lə kaláng bədə man man mo? ");
INSERT INTO sor_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nə wayang: Mãr̰ĩ ha wagɨ lə kaláng ma, ɗɨm da, wála gɨ ɨndi gɨ Gun gorndɨw, nə cwarnay da, gaa nə ha ꞌywaa nare woni kala dusɨrəgɨ Mãr̰ĩ dɨwə dodə sɨn̰a dɨdə ka di mo?» ");
INSERT INTO sor_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Nare nə yər sɨdəgɨ ba gɨ i nə tɨba Mãr̰ĩ dɨrəwə me, yər kwandagɨ ya ichɨn̰ de me ca da, Jesu waygɨ gwale gɨ diri mɨn ɗang ba da: ");
INSERT INTO sor_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«Nare sɨr nagɨ ha kulu gaba bwasa Mãr̰ĩyə dara amsa gɨ Mãr̰ĩ, gɨ mɨn i Parise me, gɨ mɨn i aba salaw dole gɨ geche gɨ Rom mani me ca. ");
INSERT INTO sor_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Abe gɨ Parise di so ɗɨbɨ daa me amsɨ Mãr̰ĩ dusɨwə ba da: “Mãr̰ĩ, nə àlɨ́m dóche, dara ɨndi da, nə i ya nare nə ɗang de bədə. Nare nə ta di i miidi me, i nə tɨba bədə me, i woni kan̰ja namde me ca. Nə i ya aba salaw dole gɨ geche gɨ Rom mani gɨ alə ta di de bədə me ca. ");
INSERT INTO sor_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ɨndi da, dɨmas dwar̰ɨ lə mɨn da, nə u asiyam dɨn sɨr, me mani ni nə ꞌywaa pad nə nem mwaj da, nə ɓɨr̰ɨ mɨn ꞌyàw Mãr̰ĩ me ca.” ");
INSERT INTO sor_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ɨr̰ɨ aba salaw dole gɨ geche gɨ Rom mani di ɗɨbə bam hin̰e, an̰ji lán̰ ꞌwoo gɨ dɨrəw yara daa. An̰ji gobɨ nudəw me way dusɨwə ba da: “Mãr̰ĩ ni, yər n̰agɨni ni ɗe! Nə i gun gɨ àcn̰e.”» ");
INSERT INTO sor_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ɨr̰ɨ, Jesu waygɨ nare da: «Dwayna, nə wayang: I aba salaw dole gɨ geche gɨ Rom mani di me gɨdɨ gɨ tɨba Mãr̰ĩ dɨrəwə an̰ju me cwara hára ulay duwa lə. Me gɨ Parise da, àcn̰a wor lə dɨwə com. Dara gun gɨ unə dɨw daa an̰ju gaba ciri da, gɨ ha yə̀w huraw gandɨdɨ dodə me, gun gɨ hurna dɨw dodə da, gɨ ha biyəw gandɨdɨ daa me ca.» ");
INSERT INTO sor_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Dine nə man̰ kaw, nare layagɨ hára nɨm ꞌyàw Jesu dara an̰ju ba ɓɨlbɨnə sɨdəgɨ me ba amsɨna Mãr̰ĩ daragɨ. Me woni gɨrsə gwale duwa yər yande da, cendi sogdɨgɨ le. ");
INSERT INTO sor_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ɨr̰ɨ Jesu waygɨ cendi ba hane gɨ dine nə ꞌyəng nə ta di sɨwə me, waygɨ woni gɨrsə gwale duwa da: «Kalne dine di gɨ hane ꞌywanan, ɨmnəgɨ bam bədə. Dara i nare nə wun ya cendi de me nem dɨmə hára lew dɨ dwãr̰ĩ dɨnə Mãr̰ĩ duwa lə di cendi. ");
INSERT INTO sor_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Dwayna, nə wayang i gwale sɨw: Gun gɨ kalna Mãr̰ĩ lamna dwãr̰ĩ duwa dɨwə ya dwe gɨ ꞌyəng de bədə da, an̰ji ha ganda hára ciri dɨnə Mãr̰ĩyə di bədə bɨr̰ɨn̰.» ");
INSERT INTO sor_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Geche gɨnə nare nə Juwib day mɨn gɨra ꞌyo Jesu me ùrɨw ba da: «Aba gɨlənin mani gɨ lade, nə ha àla i man me nə ha ꞌywaa gɨ bɨlə gaba dama gɨ dɨrɨn̰ bɨr̰ɨn̰ di mo?» ");
INSERT INTO sor_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesu cow wayɨw da: «Mə ꞌwogɨn ba nə i gun gɨ lade, dana mo? Gun gɨ lade da, i Mãr̰ĩ mɨn tenene. ");
INSERT INTO sor_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Mə ꞌwocn̰ mani nə bii gɨ ꞌwoo gɨnə Mãr̰ĩ duwa waygɨ di com: ba mə kan̰jɨna gun dyaməw bədə, ba mə ꞌyána gun gɨ ùrə dɨma bədə, ba mə mĩynə bədə, ba mə sawnaw gun gwale àsɨnaw dɨwə bədə, ba mə àlnagɨ́ nə abam day gɨ im horɨmbə me.» ");
INSERT INTO sor_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Abe di cow wayɨw da: «Mani nə pad ta di, nə àlgɨ̀ le ɓɨg dɨnani niyə bá.» ");
INSERT INTO sor_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Mana gɨ Jesu doy gwale duwa di mwom da, wayɨw da: «Mani mɨn worɨm àla ilə sɨn̰: Kɨl mani dɨma nə ꞌywaa bam pad me, gursɨ day da, ɨsɨgɨ nare nə bugɨr. Yande me, mə ha ꞌywaa mani daa Mãr̰ĩ sɨwə sɨn̰. Me hare, pam tarɨn.» ");
INSERT INTO sor_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Mana gɨ abe di ba a doy yande da, sɨw mar bam ledede, dara mani duwa nə ꞌywaa di ꞌyarbar nan̰e. ");
INSERT INTO sor_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Mana gɨ Jesu yərɨw sɨw mar bam mwom da, an̰ji wayɨw da: «Ay! Nare woni ꞌywaa mani, ganda day gaba hára ciri dɨnə Mãr̰ĩyə da, wom nan̰e. ");
INSERT INTO sor_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Jambal dɨmnə libara gaba busə mani gubu duwa lə kaw, wom bədə sɨn̰. Me gun gaba ꞌywaa mani ganda duwa hára gɨ ciri dɨnə Mãr̰ĩyə da, wom nan̰ ɗoy bam.» ");
INSERT INTO sor_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Nare nə dam doy gwale duwa di way da: «Me inam i yande da, i wi me ha nyama ꞌywaa bɨlə di mo?» ");
INSERT INTO sor_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesu cogɨ waygɨ da: «Mani nə ɗoy nare dɨdəgɨ da, ɗoy Mãr̰ĩ dɨw bədə.» ");
INSERT INTO sor_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Piyer cow wayɨw da: «Yər, nenin da, nə kalanin mani nin bam pad dara pama tarɨm. Nin da, ha ꞌya i man mo?» ");
INSERT INTO sor_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesu waygɨ da: «Dwayna, nə wayang i gwale sɨw: Gun gɨ kalna ciri duwa bam labaa, dyaməw bam labaa, chamraw bam labaa, war̰aw bam labaa, dɨndaw bam dara dwãr̰ĩ dɨnə Mãr̰ĩ duwa da, ");
INSERT INTO sor_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","gun gɨ ta di ha ꞌywaa mani nə an̰ji kalagɨ bam ta di ꞌyarbara nan̰ daa bi caga ka me, ɗan̰ wála gɨ sɨn̰a dara cwara dɨrway da, an̰ji ha ꞌywaa bɨlə gaba dama gɨ dɨrɨn̰ bɨr̰ɨn̰ me ca.» ");
INSERT INTO sor_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesu wol woni gɨrsə gwale duwa nə mwaj dii sɨr di mɨ́ndagɨ me waygɨ da: «Dwayna, də ilə nagang dara hára Jursalem ɗɨm, me gwale gɨ pad gɨ woni cɨmə Mãr̰ĩ bɨw jangɨw ɓɨg dara ɨndi gɨ Gun gorndɨw di, ha àlala lə. ");
INSERT INTO sor_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Gɨ ha yə̀n ꞌyàgɨ́ nare nə i Juwib bədə ɨsɨragɨ lə. Cendi ha àlàn məng me ha cadɨban me ha ɓɨsɨbən láde sɨnnə me ca. ");
INSERT INTO sor_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Cendi ha gwaban gɨ bɨr̰aw me ha ꞌyán bam me, ɨr̰ɨ wála gɨ subu lə da, nə ha dɨmə daa munɨ lə me ca.» ");
INSERT INTO sor_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ɨr̰ɨ woni gɨrsə gwale duwa di ꞌwocn̰ gwale duwa gɨ an̰ji wayɨw ta di gɨndɨw hin̰e bədə bɨr̰ɨn̰. Gwale duwa gɨ ta di gɨndɨw budərgɨ i dodə me, cendi ꞌwocn̰ mani nə an̰ji waygɨ gandagɨ gɨndəgɨ bədə me ca. ");
INSERT INTO sor_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jesu day gɨ nə woni gɨrsə gwale duwa hargɨ gɨrgɨ ib gɨ ciri dɨ Jeriko. Abe mɨn gɨ dɨrəw bu dam lə bɨrmə dugdɨwə amsa lə. ");
INSERT INTO sor_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Mana gɨ an̰ji doy nare nə gɨr̰e di gɨdɨragɨ mwom da, an̰ji ùrgɨ ba da: «I na àlal yande mo?» ");
INSERT INTO sor_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Nare di wayɨw ba i Jesu gɨ Najaret me ba ilə hára lə an̰ju. ");
INSERT INTO sor_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Mana gɨ abe gɨ dɨrəw bu di doy yande da, so soy mar̰ɨjaw daa ba da: «Jesu gɨnə dole gɨDabid mwàw, yər n̰agɨni ni ɗe!» ");
INSERT INTO sor_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Nare woni hára pii kwandagɨ dɨrəgɨ lə di àlɨ́w gwale an̰ju ba ɗyasɨna bɨw daa, ɨr̰ɨ an̰ji cor soy mar̰ɨjaw daa nan̰ ɗoy gɨ pii bam bi ba da: «Dole gɨ Dabid mwàw, yər n̰agɨni ni ɗe!» ");
INSERT INTO sor_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jesu ɗɨbɨ dodə me waygɨ nare di ba walnaw abe gɨ dɨrəw bu di hane nɨm. Mana gɨ an̰ji gɨra Jesu sɨwə ib mwom da, an̰ji ùrɨw ba da: ");
INSERT INTO sor_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Mə ùr ba nə àlnám i na mo?» An̰ji cow wayɨw da: «Aba ciri ni, tin̰ɨn dɨrən bam. Nə ùr ba nə cor yər mana bi.» ");
INSERT INTO sor_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ɨr̰ɨ Jesu wayɨw da: «Kal dɨrəm di yarna mana. Mə kala dusɨm dɨnnə da, mə ꞌyo labiya ɗɨm.» ");
INSERT INTO sor_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Mana gɨ ta lə di dog, an̰ji yər mana pɨrang me, so pam Jesu tarɨw me, bow Mãr̰ĩ jilay me, nare nə yər mani nə àlal ta di bow Mãr̰ĩ jilay me ca. ");
INSERT INTO sor_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Targɨn̰ da, Jesu ha jə̀ gɨ ciri dɨ Jeriko dɨdə. ");
INSERT INTO sor_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Mana gɨ ciri dɨ ta lə di, abe mɨn gɨ gɨ ꞌwogɨw Jache ilə. Abe gɨ ta di, i geche gɨnə nare woni salaw dole gɨ geche gɨ Rom mani day me, an̰ji i aba ꞌywaa mani nan̰. ");
INSERT INTO sor_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","An̰ji kan̰jɨ bɨrmə ùr ba yər Jesu di, ba i gun gɨ man mo? Me an̰ji nem yaraw bədə, dara nare gɨr̰ɨ nan̰e me, an̰ji i gun gɨ mwange me ca. ");
INSERT INTO sor_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","An̰ji wà ha pii haga daa habda dɨwə dara ba yər gɨ Jesu, dara Jesu di ba ha ꞌwoo i bɨrmə gɨ ta di me, ba ha hára nɨm. ");
INSERT INTO sor_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Mana gɨ Jesu ha gɨr mana gɨ ta lə da, an̰ji u dɨrəw daa yər Jache me, ꞌwogɨw wayɨw ba da: «Jache, chə́y dodə kaláng, dara laba da, ùrɨn i wála gɨ kɨrə dɨma lə.» ");
INSERT INTO sor_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Jache chə́ə dodə kaláng me wol Jesu ha nɨm kɨrə duwa lə gɨ sii ꞌywala. ");
INSERT INTO sor_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Mana gɨ nare di ba gɨ yər yande mwom da, pad dayyə pad n̰amdɨ gwale dodə ba da: «An̰ji ha ꞌya wála kɨrə nə gun gɨ àcn̰eyə!» ");
INSERT INTO sor_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ɨr̰ɨ Jache so ɗɨbɨ daa Aba ciri gɨ Jesu dɨrəwə me wayɨw da: «Aba ciri ni, yər: Mani ni nə ꞌywaa pad da, nə ha joo tuləgɨ ꞌyàgɨ́ nare nə bugɨr. Me gun gɨ nə salna mani duwa gɨ bɨrmə day bədə da, nə ha ꞌywagaw lə diiyə dii wodɨ.» ");
INSERT INTO sor_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ɨr̰ɨ Jesu wayɨw ba da: «Wála gɨ laba lə da, Mãr̰ĩ ꞌyàm bɨlə ɨjɨm me nare nə kɨrə dɨma lə di me. Dara ɨjɨm di kaw, mə i Abɨraham mwàw me ca. ");
INSERT INTO sor_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Dwayna, ɨndi gɨ Gun gorndɨw di, nə hára i dara kan̰ja gɨ nare nə nole dara ba nə ꞌyàgɨ́ bɨlə.» ");
INSERT INTO sor_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Mana gɨ nare nə gɨr̰e di ba ilə dwaya gwale gɨ ta di lə mwom da, Jesu u gwale gɨ diri waygɨ, dara an̰ji yala i ib gɨ ciri dɨ Jursalem me an̰ji ꞌwocn̰ ɨrmə day com. Nare di ɨrɨm an̰ji ba gɨrnə Jursalem mwom da, dwãr̰ĩ dɨnə Mãr̰ĩ duwa di kaw, ba ha dɨmə lə mana gɨ ta lə di dog me ca. ");
INSERT INTO sor_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Yande da, an̰ji waygɨ ba da: «Abe mɨn war̰aw gɨndəgɨ i dolgə. An̰ji so ba a ha sɨn̰a dɨ hən̰yə dara ba gɨ chɨ́nəw dole gɨ geche do me ba a cwara hára lam dwãr̰ĩ di sɨn̰a duwa lə sɨn̰. ");
INSERT INTO sor_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Mwom da, an̰ji ꞌwaga kòy duwa mwaj kwandagɨ dwar̰agɨ lə ꞌyàgɨ́ wi kaw, jindar mɨn mɨn, me waygɨ ba da: “Hana àlna gɨ kenge bɨraa cwara niyə bá.” ");
INSERT INTO sor_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ɨr̰ɨ nare nə sɨn̰a duwa lə di ùrɨw bədə. Me cendi giy nare tarɨwə ba hana waynaw dole gɨ geche da, ba gɨ ùr abe gɨ ta di ba wamnagɨ bədə. ");
INSERT INTO sor_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Me dole gɨ geche di gɨn̰ gwale day bam me chə́w dwãr̰ĩyə di mwom da, an̰ji cwara hára sɨn̰a duwa lə bi. An̰ji ꞌwaga kòy duwa nə tanga an̰ji ꞌyàgɨ́ jindar ba àlnáw gɨ kenge di, gaa cendi ba ꞌyo nimi dɨra lə diiyə ɨndi na mo? ");
INSERT INTO sor_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Gɨ pii chidɨ hára sɨwə me wayɨw ba da: “Aba ciri ni, jindar dɨ mə ꞌyàn gandɨdɨ di me, nə ꞌyo nimi dɨra lə diiyə mwaj.” ");
INSERT INTO sor_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Aba ciri duwa di wayɨw da: “Ladɨ nan̰e, mə i kwaya gɨ lade. Mana gɨ mani nə ɓaniyə kaw, mə gɨlə dara ba mə i gun gɨ gun nem kala dusɨw dɨmmə ꞌyang. Yande da, nə chɨ́m dole gɨnə ciri dɨ mwaj dɨra mə ha lama dwãr̰ĩ lə.” ");
INSERT INTO sor_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Gaba dii sɨrrə chidɨ sɨwə me wayɨw ba da: “Aba ciri ni, jindar dɨ mə ꞌyàn gandɨdɨ di, nə ꞌyo nimi dɨra lə diiyə jii.” ");
INSERT INTO sor_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Aba ciri duwa di wayɨw da: “Ladɨ nan̰e, ɨjɨm di kaw, nə chɨ́m dole gɨnə ciri jii dɨra mə lam dwãr̰ĩ lə me ca.” ");
INSERT INTO sor_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Gɨ ɗang hára gɨra wayɨw da: “Aba ciri ni, yər, jindar dɨma di i ta. Nə madɨ gɨ barge bɨw gamdɨ daa, ");
INSERT INTO sor_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","dara nə lán̰ɨmme. Ɨjɨm da, mə i gun gɨ gwale dɨma wom nan̰e. Nə way yande dara gursɨ dɨ mə àsɨnadɨ mana gaba gama lə ɨjɨm bədə kaw, mə udɨ le, me mani nə mə gɨsɨgɨ ɨjɨm bədə kaw, mə n̰ilgɨ le me ca.” ");
INSERT INTO sor_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Aba ciri duwa di wayɨw da: “Kwaya gɨ àcn̰e gá! Gwale dɨma gɨ mə wayɨw ta di me àsɨm gwale dɨmmə ɨjɨm gaba ciri duwa gang. Mə ꞌwocn̰ dara ba nə i gun gɨ gwale ni ba womme, ba nə i aba ꞌwoo gursɨ dɨ nə àsɨdɨ ɨndi mana gaba gama lə bədə me, ba nə n̰il mani nə ba nə gɨsɨgɨ ɨndi bədə me ca. ");
INSERT INTO sor_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Inam yande da, dana me mə àsan gursɨ ni di mana gaba gama lə bədə mo? Cwara niyə da, dee nə ha ꞌwódɨ gɨ nimi dɨra lə diiyə.” ");
INSERT INTO sor_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ɨr̰ɨ dole di waygɨ nare nə ɗɨbɨ lə tulɨwə di ba da: “Unə jindar duwa di bam me ꞌyànaw gandɨdɨ aba ꞌywaa mwaj di lə diiyə.” ");
INSERT INTO sor_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Cendi cow wayɨw ba da: “Aba ciri nin, an̰ji jindar duwa di ilə ɨsəwə mwaj ta ɗɨmme.” ");
INSERT INTO sor_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Aba ciri di cogɨ lə diiyə waygɨ ba da: “Nə wayang: Gun gɨ mani duwa ina lə da, gɨ ha ꞌyàw lə diiyə bi. Me gun gɨ mani duwa ina lə bədə da, nə hin̰e nə ilə ɨsəwə ta di kaw, gɨ ha ꞌwógɨ i bam ɨsəwə. ");
INSERT INTO sor_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ɗang da, woni mar̰ande ni nə ùr ba nə lamna dwãr̰ĩ dɨdəgɨ lə bədə di, laynagɨ hane nɨm ꞌyánagɨ bam dɨrənnə ka.”» ");
INSERT INTO sor_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Mana gɨ Jesu way gwale gɨ ta di ꞌyen̰ bam pad mwom da, an̰ji ɨndər nare dɨrəgɨ lə dara naga hára ciri dɨ Jursalem. ");
INSERT INTO sor_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","An̰ji chidɨ yala ib gɨ ciri dɨ Betɨpage me dɨ Betani me. Ciri dɨ ta di dam i kur̰a dɨ gɨ ꞌwogɨdɨ «kur̰a dɨ Olib» tuldɨ lə ib. Mana gɨ ta lə da, an̰ji giy woni gɨrsə gwale duwa sɨr dɨrəwə, ");
INSERT INTO sor_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","me waygɨ da: «Hana mana gɨ ciri dɨ ꞌya dɨrəngə ta di. Mana gɨ anə gɨrnə ciri dɨ ta lə da, anə ha ꞌywaa kura gɨ dwe gɨ gun ajilɨw dii mɨn bədə sɨn̰, gɨ maw ɗɨbɨ lə. Awrɨnaw daa, hane nɨm. ");
INSERT INTO sor_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Gun ùrnəng anə banə awɨr kura di dana mo da, waynaw da: “I Aba ciri nin me ùr an̰ju.”» ");
INSERT INTO sor_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Woni gɨrsə gwale duwa nə sɨr di hargɨ me, gɨra ha ꞌywaa mani di ya Jesu dee ba a waygɨ nɨm de. ");
INSERT INTO sor_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Mana gɨ cendi ilə awra kura gɨ dwe di lə mwom da, woni ciri duwa ùrgɨ ba da: «Anə awɨr kura di dana mo?» ");
INSERT INTO sor_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Cendi cogɨ waygɨ ba da: «I aba ciri nin me ùr an̰ju.» ");
INSERT INTO sor_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Mwom da, cendi yəə kura di hára nɨm ꞌyàw Jesu. Cendi darbɨ barge day tarɨwə, me u Jesu chɨ́w lə diiyə. ");
INSERT INTO sor_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Mana gɨ an̰ji ilə hára lə mwom da, nare lay barge day darbɨ dodə bɨrmə dalawə dɨrəwə pii. ");
INSERT INTO sor_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Mana gɨ an̰ji chə́ə daa kur̰a dɨ Olib dɨdə hára dara hára Jursalem ɗɨm da, nare woni gɨrsə gwale duwa nə gɨr̰e pad woni bwaw hára nɨm di, sɨdəgɨ ꞌyolgɨ nan̰e me, cendi ɓɨr̰ɨn̰ ilə bwaw Mãr̰ĩ jilayyə gɨ mar̰ɨjagɨ daa nan̰ dara mani nə dan̰a pad nə Jesu àlgɨ̀ me cendi yaragɨ ta di. ");
INSERT INTO sor_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Cendi way ba da: «Kal Aba ciri gɨ Mãr̰ĩ biynəw an̰ju gɨ dole gɨ geche gɨ hára lə gɨ sumɨw di bɨw dɨwə, biynəw bɨw dɨwə! Kal hɨlala jwam ina lə daa Mãr̰ĩyə, me kal Mãr̰ĩ gaba dama daa cog, sumɨw ꞌwagɨna me ca!» ");
INSERT INTO sor_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Nare nə Parise nə yab nə ilə nare nə gɨr̰e di dwar̰agɨ lə wayɨw Jesu da: «Aba gɨlənin mani, waygɨ woni gɨrsə gwale dɨma di, kalgɨ gɨ ɗyasɨna bɨdəgɨ daa.» ");
INSERT INTO sor_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Me an̰ji cogɨ lə diiyə waygɨ ba da: «Nə wayang: Cendi ɗesɨbɨna bɨdəgɨ daa kaw, i kur̰a dɨ ɓolbəre me ha bwaa gura le com.» ");
INSERT INTO sor_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Mana gɨ Jesu gɨr ib gɨ ciri dɨ Jursalem me ba yərdɨ da, an̰ji nul gura daradɨ ");
INSERT INTO sor_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","me way da: «Ay! Dee mɨndi kaw, wála gɨ laba lə, də ꞌwacn̰ana i man me də ha ꞌywaa hɨlala jwam mo! Me cor caga ka, mani di pad budər dodə dɨrəyyə. ");
INSERT INTO sor_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ɗan̰ wála gɨ àcn̰e hára lə me, woni mar̰ande diya ha aja gər liwi daa kudaj. Cendi ha dɨmdəy daa ka me, ka me. ");
INSERT INTO sor_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Cendi ha myanday bam, me ha ꞌyáa nare nə dam dɨyyə di bam me ca. Cendi ha cubə kur̰a dɨ gɨ awɨy nɨm daa di bam pad, mɨn kaw, ha wara daa kondɨdɨ dɨdə bədə, dara dɨ ꞌwocn̰ wála gɨ Mãr̰ĩ gɨra nɨm diya lə dara way nɨm lə di bədə.» ");
INSERT INTO sor_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Mana gɨ Jesu gɨr Jursalem mwom da, an̰ji dɨm ha ciri dwar̰ɨ dɨ kulu gaba bwasa Mãr̰ĩ ilə di. Me an̰ji so ilə ꞌywara woni àla kenge lə bam. ");
INSERT INTO sor_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Me an̰ji waygɨ ba da: «Gɨ jangɨ lə Maktubu dɨnə Mãr̰ĩyə, Mãr̰ĩ ba way da: “Kulu ni di ha ꞌya i kulu gaba amsa Mãr̰ĩ.” Me ɨr̰ɨ ꞌyeni dan da, anə cow dan mana gaba budə gɨnə miidi day!» ");
INSERT INTO sor_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jesu dam ciri dwar̰ɨ dɨ kulu gaba bwasa Mãr̰ĩ ilə di gɨlgɨ nare mani gɨ wála wála. Cor woni bwasa Mãr̰ĩ gechide day me, woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa me, gechide nə ɗang nənə nare nə Juwib day me, kan̰jɨ bɨrmə dara ba gɨ ꞌyəwe. ");
INSERT INTO sor_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Me cendi ꞌwocn̰ mani nə ba gɨ ha àla dara ꞌyáw nɨm di bədə, dara nare di pad dayar ilə gandɨw gɨ wála wála dwaya gwale duwa lə. ");
INSERT INTO sor_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Wála mɨn mana gɨ Jesu ilə gɨləgɨ nare mani mana gɨ ciri dwar̰ɨ dɨ kulu gaba bwasa Mãr̰ĩ ilə di me, ilə wayagɨ nare Nõ dɨ lade dɨ Mãr̰ĩ lam gɨ dwãr̰ĩ duwa lə me ca da, woni bwasa Mãr̰ĩ gechide day me, woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa me, gechide nənə nare nə Juwib day me, gɨra ꞌyow ");
INSERT INTO sor_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","me ùrɨw ba da: «Waynin daa, i gɨ dwana dɨ we me mə àl nɨm gɨ mani nə ta di mo? I wi me ꞌyàm bɨrmə me mə àl nɨm gɨ mani nə ta di mo?» ");
INSERT INTO sor_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesu cogɨ waygɨ da: «Ɨndi kaw, nə ha ùrəng gwale mɨn ka, me cwanan lə diiyə: ");
INSERT INTO sor_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","I wi me giyə Jã gɨra àlgɨ́ nare batem di mo? I Mãr̰ĩ, labaa i nare nə gɨsɨgədə mo?» ");
INSERT INTO sor_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ɨr̰ɨ cendi wajɨbɨ gwale bulə dayyə ba da: «Də cwanaw ɨnda lə diiyə ba i Mãr̰ĩ da, an̰ji ha wayandɨ ba də yə̀ng gwale gɨ Jã wayɨw di bədə, dana mo? ");
INSERT INTO sor_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Me də waynang ba i nare nə gɨsɨgədə da, nare di ha jarandɨ gɨ kur̰a ꞌyándɨ i bam me ca, dara cendi pad ɨrɨm dara Jã di, ba i aba cɨmə Mãr̰ĩ bɨw.» ");
INSERT INTO sor_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Yande da, cendi cow wayɨw ba gɨ ꞌwocn̰ gun gaba giyə Jã me gɨra àlgɨ̀ nare batem di bədə. ");
INSERT INTO sor_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ɨr̰ɨ Jesu cogɨ waygɨ ba da: «Yande da, ɨndi kaw, nə ha wayang dwana ni dɨ nə àl nɨm gɨ mani nə ta di bədə me ca.» ");
INSERT INTO sor_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jesu waygɨ nare di gwale gɨ diri ba da: «Abe mɨn yigɨ daga duwa gɨ yabɨr̰a ilə. Me an̰ji u daga di ꞌyàgɨ́ woni àla giyə ɨsɨragɨ lə mwom da, so yá mɨjəni dɨ idɨ wála nan̰yə. ");
INSERT INTO sor_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Mana gɨ wála gaba cəə yabɨr̰a yàa duwa nem mwom da, aba ciri di giygɨ woni àla giyə gɨnə yabɨr̰a di kwaya duwa mɨn, dara cendi ba junəw yabɨr̰a yàa duwa di me ba kalna day me ca. Ɨr̰ɨ woni àla giyə gɨnə yabɨr̰a yɨ kwaya di gobɨw me ꞌyorɨw daa ɨsəw pəgɨn̰. ");
INSERT INTO sor_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Mwom da, aba ciri di cor giygɨ kwaya gɨ ɗang bi. An̰ji gɨ ta di kaw, cendi gobɨw me àlɨw àcn̰ ꞌyorɨw daa ɨsəw pəgɨn̰ bi me ca. ");
INSERT INTO sor_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ɨr̰ɨ an̰ji giygɨ kwaya gɨ ɗang gaba dii subu lə kaw, cendi ajɨbɨw diyabe me ꞌywaraw daa bi. ");
INSERT INTO sor_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Aba ciri gɨnə daga di dam ɨrɨm gwale dusɨwə ba da: “Ya ta de da, nə ha àla i man mo? Nə ha giyəgɨ gɨ gorndɨn gɨ nudən gɨ dusɨn ùrɨw nan̰ di. An̰ju da, gaa cendi ha yə̀w jawe som.” ");
INSERT INTO sor_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Me, mana gɨ cendi yaraw hára lə da, cendi wajɨ gwale bulə dayyə ba da: “Ta di me i aba wama dɨba duwa sanga di! Hane, ꞌyánandɨ gandɨw bam, me dɨba di ha warandɨ ɨnda.” ");
INSERT INTO sor_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Me cendi yɨw surɨw ha nɨm bam iche daga di tarɨwə me, ꞌyəw bam.» Ɨr̰ɨ Jesu ùr nare di ba da: «Ina yande da, aba yiga di ha àla nare nə ta di man mo? ");
INSERT INTO sor_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Nə wayang: An̰ji hára lə gɨ sɨw duwa ꞌyáa nare nə ta di bam, me ha ꞌwoo daga di ꞌyàgɨ́ nare nə ɗang ɨsɨragɨ lə.» Mana gɨ nare di ba gɨ doy yande da, cendi way da: «Kal mani nə ta di àlalna bədə ɓɨr̰ɨn̰!» ");
INSERT INTO sor_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ɨr̰ɨ Jesu yərgɨ ɓam, me waygɨ ba da: «Gwale gɨ gɨ jangɨw Maktubu dɨnə Mãr̰ĩyə di, gɨndɨw i man mo? Gɨ jangɨ ba da: “Kur̰a dɨ woni awa kululi gɨn̰dɨ bam di, yala gɨdɨ kur̰a sɨdɨ dɨ lade dɨ idɨ yəə kulu daa tandi. ");
INSERT INTO sor_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Gun gɨ we we gɨ ɨndarna kur̰a dɨ ta di dɨdə da, dɨw ha ichara bam, me gun gɨ tandi ɨndarna dɨwə da, tandi ha dɨlan̰aw bam mɨgɨlag me ca.”» ");
INSERT INTO sor_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ɨr̰ɨ, woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa me, woni bwasa Mãr̰ĩ gechide day me, ꞌwocn̰ dara Jesu ba way gwale gɨ diri gɨ ta di, i dara daragɨ cendi. Mwom da, cendi kan̰jɨ bɨrmə mana gɨ ta lə dog ba gɨ yɨw, me cendi lán̰gɨ i nare nə gɨr̰e di. ");
INSERT INTO sor_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Mana gɨ ta lə di, woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa me, woni bwasa Mãr̰ĩ gechide day me, kal dɨrəgɨ Jesu dɨwə. Mwom da, giyɨw nare nə àl sɨdəgɨ ya ba gɨ i nare nə tɨba Mãr̰ĩ dɨrəwə de. Nare nə ta di, hára ꞌyo Jesu me ùrɨw gwale gaba twaw, gaa ba gɨ ꞌyo gwale gɨ àcn̰e bɨwə me, ba gɨ yɨw ꞌyàw dole gɨ Rom ɨsəwə. ");
INSERT INTO sor_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Cendi ùrɨw ba da: «Aba gɨlənin mani, nə ꞌwocn̰ɨninne dara mə i aba waya gwale sɨw, me mə gɨlgɨ nare gwale sɨw gɨ Mãr̰ĩ ùr nare ba àlna di gɨ bɨrmə duwa. Mə àl yande dɨban lán̰aw gɨ gun, dara dolɨm gɨ nare nə ladɨbe bədə me ca. ");
INSERT INTO sor_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Yande da, waynin ɨrmə dɨma daa sɨn̰: Gaa nendɨ da, bii ɨnda gɨ ꞌwoo lə da, ꞌywagaw gɨ dole gɨ geche gɨ Rom lombo da, ladɨ le, labaa ladɨ bədə mo?» ");
INSERT INTO sor_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesu ꞌwocn̰ kojɨgə day di com, me waygɨ ba da: ");
INSERT INTO sor_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Gɨlnən chile dɨ gursɨ mɨn dɨ deniye di kwa sɨn̰.» Cendi gɨlɨw gandɨdɨ mwom da,  an̰ji ùrgɨ ba da: «Mana gɨ chile dɨ ka di sɨdə da, i wi dɨw me sumɨw me ilə mo?» Cendi cow wayɨw da: «I dole gɨ geche gɨ Rom.» ");
INSERT INTO sor_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ɨr̰ɨ Jesu waygɨ da: «Ladɨ! Yande da, mani nənə dole duwa da, ꞌyànáw dole di, me mani nənə Mãr̰ĩ duwa kaw, ꞌyànáw Mãr̰ĩ di le me ca.» ");
INSERT INTO sor_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Cendi nem ꞌywaa gwale gɨ àcn̰e bɨwə mana gɨ gwale duwa gɨ an̰ji wayɨw nare dɨrəgɨ lə di bədə. Gwale gɨ an̰ji cogɨ lə diiyə di, ꞌyàgɨ́ ɨrmə nan̰e me, cendi dam bɨdəgɨ mɨgɨmi. ");
INSERT INTO sor_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ɨr̰ɨ nare nə mɨn nə gɨ ꞌwogɨgɨ Saduse hára ꞌyo Jesu. Cendi ɨrɨm day ba nare nə mare da, Mãr̰ĩ ba ha dɨməgɨ daa munɨ lə bədə bɨr̰ɨn̰. Me cendi ùrɨw ba da: ");
INSERT INTO sor_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«Aba gɨlənin mani, yər, Moyis jangɨ mana gɨ bii ɨnda gɨ ꞌwoo lə ba da, abe gɨ ba unə deme me yàna gandɨdɨ dine bədə me ba marna bam da, chendɨw ba unə wambɨ di me ba yànaw gɨ chendɨw gɨ mar bam di dine. ");
INSERT INTO sor_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Caga da, doy: Wála mɨn, chebni dɨ nare wurgɨsubu ilə. Chandragɨ gɨ geche u deme me mar bam dɨban yàa gandɨdɨ dwe. ");
INSERT INTO sor_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Chendɨw gaba dii sɨrrə udɨ kaw, mar bam yande me, gɨ aba dii subu lə kaw, àlal yande me, bɨraa gɨ aba dii wurgɨsubu lə bá. ");
INSERT INTO sor_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Chamre nə wurgɨsubu di margɨ bam pad dayyə pad dɨban yàa gandɨdɨ dine. ");
INSERT INTO sor_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Targɨn̰ ɗang da, deme di kaw, wála dɨra nem me, tandi mar bam me ca. ");
INSERT INTO sor_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Yande da, wála gɨ Mãr̰ĩ ha dɨmə gɨ nare nə mare daa munɨ lə da, tandi ha ꞌya i gɨ we dyaməw mo? Dara cendi nə pad ta di, tanga i tɨrgadɨ.» ");
INSERT INTO sor_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesu cogɨ lə diiyə ba da: «Mana gɨ sɨn̰a dɨdə ka da, abje me namde me lay sɨdəgɨ le. ");
INSERT INTO sor_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Me nare nə Mãr̰ĩ yərgɨ ba i woni nyama dɨmə daa munɨ lə me sanga ba ha nyama dama dɨr̰ɨn̰a dɨ dɨrwayyə da, cendi ha laya sɨdəgɨ bədə. ");
INSERT INTO sor_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Nare nə ta di, ha mara bədə ɓɨr̰ɨn̰, dara cendi ha wunə ya Paja nənə Mãr̰ĩ duwa nə daa ta de, me cendi i Mãr̰ĩ dɨndaw me ca, dara an̰ji dɨməgɨ i daa munɨ lə ɗɨm. ");
INSERT INTO sor_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Nare nə mare dɨmə day gɨ daa munɨ lə da, Moyis sɨw duwa gang kaw, way gwale duwa i mana gɨ gwale gɨnə habda gɨ ɗwag ɗwaggɨ dùwa ꞌyo lə di. Mana gɨ ta lə da, Moyis ꞌwogɨ Aba ciri gɨ Mãr̰ĩ ba i Mãr̰ĩ gɨnə Abɨraham duwa me, gɨnə Isak duwa me, gɨnə Jakob duwa me ca. ");
INSERT INTO sor_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Me Mãr̰ĩ di, i gɨnə nare nə mare day bədə, me i gɨnə nare nə dam bɨ̀ra day. Dara an̰ju gɨ Mãr̰ĩ dɨrəwə da, nare nə subu nə ta di, dam lə bɨ̀ra.» ");
INSERT INTO sor_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa nə yab u gwale way ba da: «Aba gɨlənin mani, gwale dɨma gɨ mə co lə diiyə ta di, ladɨ nan̰e.» ");
INSERT INTO sor_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ɨr̰ɨ gun mɨn kaw, nem ùrɨw gwale gɨ ɗang bədə ɗɨm. ");
INSERT INTO sor_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ɨr̰ɨ Jesu ùr nare di ba da: «I man me, anə way bá, dole gɨ Mãr̰ĩ biyəw gɨ Kris di, ba i Dabid mwàw mo? ");
INSERT INTO sor_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Dabid gɨ sɨw duwa gang kaw, way mana gɨ Maktubu dɨ diriyə ba da: “Aba ciri gɨ Mãr̰ĩ wayɨw aba ciri ni ba da: Hare, mə dam ɨsən gɨ abeyə, ");
INSERT INTO sor_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","bɨraa nə ha bwam woni mar̰ande dɨma dodə gɨdammə bá do.” ");
INSERT INTO sor_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dabid ꞌwagɨna Dole gɨ Mãr̰ĩ biyəw gɨ Kris di ba i aba ciri duwa da, i dana me gɨ ꞌwogɨw ba i Dabid mwàw ɗang tugu mo?» ");
INSERT INTO sor_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Mana gɨ nare nə gɨr̰e di ilə dwaya gwale duwa lə da, an̰ji waygɨ woni gɨrsə gwale duwa ba da: ");
INSERT INTO sor_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Àsɨna angal danne! Àlna mani ya woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa ba gɨ àl nɨm de bədə. Cendi ùr hurba gɨ barge gɨ gechide gaba sumi kɨdɨbər nɨm, me ùr ba gɨ àlnagɨ́ labiya gɨ horɨmbə nare dɨrəgɨ lə mana gaba dayara lə me. Cendi ùr dama gɨ mana gaba sumiyə kululi woni amsa Mãr̰ĩyə, me wama gɨ maniyə kaw, cendi ùr i mana gaba sumi me ca. ");
INSERT INTO sor_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Cendi chəbɨ namde nə wambɨ mani day bam me, ɗang da, cendi ɗɨbɨnə dara amsa gɨ Mãr̰ĩ da, amsɨ bɨraa bɨraa bɨraa dara gɨlə gɨ sɨdəgɨ ba gɨ i nə ladɨbe cendi. Me sanga da, sariya day ha wama nan̰e.» ");
INSERT INTO sor_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Mana gɨ kɨrə ciri dwar̰ɨ dɨ kulu gaba bwasa Mãr̰ĩ ilə da, mana mɨn gɨ nare hára gɨ gursɨ day àl gɨ dwani gɨ Mãr̰ĩ ilə. Jesu u dɨrəw daa me yər nare woni ꞌywaa mani ilə bwaa mani day nə dwaniyə mana gɨ sungɨ dwar̰ɨ lə. ");
INSERT INTO sor_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","An̰ji yər deme dɨ wambɨ mɨn dɨ mani dɨra ilə bədə bɨr̰ɨn̰ kaw, so bo chile sɨr dɨ nem àla gɨ mani bədə me ca. ");
INSERT INTO sor_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","An̰ji way da: «Dwayna, nə wayang i gwale sɨw: Deme dɨ wambɨ dɨ bugɨr dɨ ta di bo gursɨ dɨra ɗoy nare day di bam pad. ");
INSERT INTO sor_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Nə way yande dara nare di, i gursɨ day dɨ wor dodə sɨr̰ɨgɨm me, cendi hára ꞌyàa sɨn̰. Me tandi da, mani pad jaldɨ le, me cor ꞌyàa i mani pad nə ilə ɨsədɨ lə dara ɨsə gɨ sɨdɨ di bam.» ");
INSERT INTO sor_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Mana gɨ nare nə mɨn way gwale dara kulu gaba bwasa Mãr̰ĩ ladni duwa me kur̰a dɨ ladɨbe dɨ gɨ aw nɨm di me mani nə ladɨbe nə gɨ hára chɨ́gdɨgɨ di me ca da, Jesu waygɨ da: ");
INSERT INTO sor_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Ɗan̰ wála hára lə da, mani nə anə yərgɨ ta di pad da, ha myandara bam. Kur̰a mɨn kaw, ha wara daa kondɨdɨ dɨdə bədə.» ");
INSERT INTO sor_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ɨr̰ɨ cendi ùrɨw da: «Aba gɨlənin mani, mani nə ta di ha àlala i mindi na mo? Me i mani na me ha gɨlə dara mani di ba ha àlala le di mo?» ");
INSERT INTO sor_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesu waygɨ da: «Àsɨna angal dan ladɨ le! Kal gɨ lamnang bwanang bam bədə. Nə way yande dara nare nan̰ ha ꞌwoo sumɨn hára nɨm lə, me wi kaw, ha waya ba Dole gɨ Mãr̰ĩ biyəw gɨ Kris di, ba i an̰ju, labaa, wála di ba yala ib ɗɨm. Cendi waynang yande kaw, kalna pama taragɨ ɗi. ");
INSERT INTO sor_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Mana gɨ anə dwayna nare jarna say, me nare swana gɨ gwale sɨdəgɨ dayyə gang me da, kalna àla lán̰a ɗi, dara mani nə ya ta de di ha àlala le pii pa do. Ɗɨm da, i dɨr̰ɨn̰a ꞌyan̰a dɨra bədə sɨn̰.» ");
INSERT INTO sor_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jesu waygɨ ɗang ba da: «Nare nə wama gɨ ciri dɨ mɨnnə ha swaa jara say gɨ kwandagɨ nə ciri dɨ wama gɨ ɗangə me, dole gɨ mɨn ha jara say gɨ jaw dole gɨ ɗang me ca. ");
INSERT INTO sor_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Sɨn̰a ha gɨgdara nan̰e mana lə jiga jiga me, badɨgara dɨ geche ha ɨndara ciriyə jiga jiga me, mwom gaba ɗɨmə mana ha àla nare me. Gɨ ha yara mani nə dan̰a nə àl lán̰a nan̰ ha àlala daa me ca. ");
INSERT INTO sor_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Mani nə ta di ha àlala le. Me pii pa dɨrəgɨ lə da, gɨ ha yɨbəng gɨləng dɨrəng me, gɨ ha hára gandang kululi woni amsa Mãr̰ĩ nənə nare nə Juwib dayyə bwang gwale dɨdəngə me, gɨ ha bwang dangeyə me ca. Gɨ ha hára gandang dolgə dɨrəgɨ lə me woni wama ciri dɨrəgɨ lə me dara daran ɨndi. ");
INSERT INTO sor_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","I ta di me anə ha biyəgɨ gɨ gwale gɨ nə wayɨw me mani nə nə àlgɨ̀ di me. ");
INSERT INTO sor_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Gwale gaba bɨlə sɨdəng da, ꞌwacn̰ana dara anə ha ɗangr̰aw ꞌyeni gang bədə. ");
INSERT INTO sor_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","I ɨndi me nə ha ꞌyàng gwale di bɨdəngə, me woni mar̰ande dan ha nyama gaga gandang gwale bədə. Nə ha ꞌyàng dɨrɨn̰ naa me, gwale day ha nyama ɗwaya gɨ dan bədə me ca. ");
INSERT INTO sor_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Abɨrang me, chamrang me, war̰ang me, kwandang moso me kaw, ha wayagɨ nare woni dwana ba yɨbɨnəng me, cendi ha ꞌyáa nə yab dwar̰angə bam me ca. ");
INSERT INTO sor_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nare pad ha ɨlənge dara daran ɨndi. ");
INSERT INTO sor_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ta di kaw, wudɨn̰ nə dɨdəngə mɨn tenene ha nwala bam bədə. ");
INSERT INTO sor_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Yɨnə sɨdəng wayna le me anə ha ꞌywaa gɨ bɨlə gaba dama gɨ dɨrɨn̰ bɨr̰ɨn̰ di sɨn̰.» ");
INSERT INTO sor_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","«Wála gɨ anə dara yara asɨngar woni mar̰ande liwnə Jursalem daa da, ɨrmɨnə dara wála dɨra gaba myandara bam di wor i ibden̰ ɗɨm. ");
INSERT INTO sor_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Mwom da, nare woni dama wama gɨ Judeyə da, gɨ wana hana daa kur̰a dɨdə me, nare nə ilə kɨrə Jursalem da, dɨmnə bam iche, me nə warna bam yiga lə da, gɨ hane ulay ciriyə bədə ɗɨm me ca. ");
INSERT INTO sor_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Dara i wála gaba aa sariya gɨ gɨ jangɨ gwale duwa mana gɨ Maktubu dɨnə Mãr̰ĩyə di ha àlala le ɗɨm. ");
INSERT INTO sor_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Wála gɨ ta lə di, owe namde woni gudi gudi me woni ꞌyàgɨ́ dɨndɨragɨ nãy me! Wamani ha ꞌywagɨ le! Dara wamani gɨ geche ha ɨndara sɨn̰a dɨ ta lə di me, Mãr̰ĩ dusɨw ha swaa nare dɨra dɨdəgɨ lə me ca. ");
INSERT INTO sor_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Nare nə yab da, gɨ ha ꞌyágɨ bam gɨ sugɨnəne me, nə mɨn da, gɨ ha yɨbəgɨ kwaynani hára nɨm sɨn̰a dɨ ɗangə me. Ciri dɨ Jursalem da, nare nə i Juwib bədə ha ɗɨrbədɨ dodə gɨ gɨdɨragɨ, bɨraa ɗan̰ wála gɨ Mãr̰ĩ ɨrmɨw gandɨw di nyamna nɨm bá.» ");
INSERT INTO sor_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","«Ɗan̰ da, daa dawa lə me, duru lə me, dechu lə me da, gɨ ha yara mani nə dan̰a woni àla lán̰a ha àlala lə me ca. Me sɨn̰a dɨdə ka da, lán̰a ha àla nare nan̰e me, dusɨrəgɨ ha cubəgɨ me dara nimi nə kurayyə gwabara day me sugdə day me ca. ");
INSERT INTO sor_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Nare nə sɨn̰a dɨdə ka da, lán̰a ha ɓugdəgɨ ꞌyágɨ dodə dara wamani gɨ hára lə sɨn̰a dɨdə pad, dara mani nə daa pad woni dwana ha gɨgdara daa. ");
INSERT INTO sor_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Mwom da, nare ha yaran ɨndi gɨ Gun gorndɨw, nə ha swaa daa siyaya dalawə dara chə́ə dodə. Nə hára i gɨ dwana me gɨ ꞌywagda ni me ca. ");
INSERT INTO sor_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Wála gɨ mani nə ta di pad dara àlala da, yɨnə sɨdəng wayna le, àlna lán̰a bədə, ɗɨbɨnə abnani yarna dɨrəng daa me, dara wála gɨ Mãr̰ĩ ha kɨdəng nɨm daa wamaniyə di, wor i ib ɗɨm.» ");
INSERT INTO sor_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ɨr̰ɨ Jesu waygɨ gwale gɨ diri ɗang ba da: «Yarna dwaga me habde nə ɗang pad me sɨn̰. ");
INSERT INTO sor_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Mana gɨ anə yarna bajɨragɨ kubɨnə mwom da, anə ꞌwocn̰ dara marsɨni ba i ib ɗɨm. ");
INSERT INTO sor_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Cwara gɨnə Gun gorndɨw di kaw, ha wunə i yande di me ca: Mana gɨ anə dara yara mani nə dee nə wayang gwale day pii di dara àlala da, ɨrmɨnə dara wála gɨnə Mãr̰ĩ duwa gaba lama dwãr̰ĩ di kaw, yala ib ɗɨm me ca. ");
INSERT INTO sor_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Dwayna, nə wayang i gwale sɨw: Mani nə pad ta di dara àlala da, nare nə caga ka di ha mara bam pad pii dɨrəgɨ lə bədə sɨn̰. ");
INSERT INTO sor_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Daa me, sɨn̰a me da, ha myandara i bam me, gwale ni da, ha myandara bam bədə bɨr̰ɨn̰. ");
INSERT INTO sor_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Àsɨna angal dan, gamna sɨdənge dara kal anə nɨmarna bam mana gɨ wama gɨ nan̰ dɨwə me widɨbə gɨ gani dɨwə me, ɨrmə gɨ sɨn̰a dɨdə ka dɨwə me bədə. Yande bədə da, wála gɨ ɨndi gɨ Gun gorndɨw, nə dara cwara da, ha dɨmə i dɨdəngə jisgɨ. ");
INSERT INTO sor_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Dara cwara ni di ha yɨbə nare nə sɨn̰a lə ka pad ya boy ba dɨ yɨbɨ gɨ mani de. ");
INSERT INTO sor_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Damna dɨrəng bɨ̀ra me, amsɨna Mãr̰ĩ dɨban bwaa gɨ gwayni, dara kal a ꞌyànang dwana dɨ idɨ dɨmə nɨm bam mana gɨ mani nə wome nə ha àlala ta di lə me, anə ha ɗɨbə nɨm daa ɨndi gɨ Gun gorndɨw dɨrənnə di me ca.» ");
INSERT INTO sor_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Gɨ dawa da, Jesu hɨrɨm daa gɨləgɨ gɨ nare maniyə ciri dwar̰ɨ dɨ kulu gaba bwasa Mãr̰ĩ ilə di. Ɨr̰ɨ gɨ turgɨ da, an̰ji dɨm ha kur̰a dɨ gɨ ꞌwogɨdɨ Olib dɨdə wála lə. ");
INSERT INTO sor_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Gɨ jomni cor̰ər̰ə da, nare pad hára ꞌyow ciri dwar̰ɨ dɨ kulu gaba bwasa Mãr̰ĩ ilə di dara dwaya gɨ gwale duwa. ");
INSERT INTO sor_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Wála gaba sii ꞌywala gɨnə mapa gɨ dɨban musbu di wor ibden̰ ɗɨm. Sii ꞌywala gɨ ta di, gɨ ꞌwogɨw sii ꞌywala gɨnə kɨrara gɨ daa kwaynaniyə me ca. ");
INSERT INTO sor_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Woni bwasa Mãr̰ĩ gechide day me, woni gɨlə bii gɨ ꞌwoo gɨnə Moyis duwa me, kan̰jɨ bɨrmə ba gɨ yɨ Jesu ꞌyəw bam kaláng, dara cendi lán̰gɨ i nare nə gɨr̰e di. ");
INSERT INTO sor_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Mwom da, Sidan dɨm mana gɨ Judas gɨ gɨ ꞌwogɨw Iskariyot dusɨwə. Judas gɨ ta di, i woni gɨrsə gwale gɨnə Jesu duwanə mwaj dii sɨr di gun day gɨ mɨn. ");
INSERT INTO sor_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Judas ha ꞌywaa woni bwasa Mãr̰ĩ gechide day di me, asɨngar woni gama kulu gaba bwasa Mãr̰ĩ me, cendi maa gwale gaa ba a ha yəə Jesu di i man me ba a ha ꞌyàgɨ́ nɨm gandɨw ɨsɨragɨ lə mo? ");
INSERT INTO sor_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Cendi sɨdəgɨ ꞌyolgɨ pad me ɨrmɨw ba gɨ ꞌyàw gursɨ. ");
INSERT INTO sor_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","An̰ji dusɨw ùre me, kan̰jɨ bɨrmə dara ba a yɨw gɨ budə ꞌyàgɨ́ gandɨw ɨsɨragɨ lə dara kal nare nə gɨr̰e di ba ꞌwacn̰ana bədə. ");
INSERT INTO sor_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Wála gaba àla sii ꞌywala gɨnə mapa gɨ dɨban musbu, gɨ gɨ ha kunbə gəgɨr̰ɨn̰je nə dine woni àla gɨ sii ꞌywala gɨnə kɨrara gɨ daa di nem ɗɨm. ");
INSERT INTO sor_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesu giy nə Piyer day gɨ Jã me waygɨ da: «Hana ɗangr̰andɨ mani woni àla sii ꞌywala gɨnə kɨrara gɨ daa di.» ");
INSERT INTO sor_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Cendi ùrɨw da: «Mə ùr ba nə hananin àlnám mani nə wama di i we mo?» ");
INSERT INTO sor_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesu cogɨ waygɨ da: «Yarna, mana gɨ anə gɨrnə ciri dɨ Jursalem da, gun mɨn go nimi gɨ pɨr̰ɨm hára sawa dɨrəng daa. Pamna tarɨw bɨraa mana gɨ ciri dɨ an̰ji ha dɨmə lə bá. ");
INSERT INTO sor_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ɨr̰ɨ anə ha wayaw aba ciri da: “Aba gɨlənin mani wayanin ba nə ùrnəmnin bá, kulu gɨ ba a ha wama mani woni sii ꞌywala gɨnə kɨrara gɨ daa day gɨ nə woni gɨrsə gwale duwa lə di, ba i we mo?” ");
INSERT INTO sor_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Mana gɨ ciri dɨ ta di lə da, kulu mɨn gɨ gɨ aw daa jaw dɨwə ilə. Aba ciri di ha gɨləng gandɨw. I kulu gɨ ɓɨle, gɨ mani pad ilə dalawə. I mana gɨ ta lə me anə ha àla mani nə wama woni sii ꞌywala di lə.» ");
INSERT INTO sor_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Cendi ha me gɨra ha ꞌywaa mani di lə ya Jesu ba wayagɨ nɨm de, me àla mani nə wama woni sii ꞌywala di. ");
INSERT INTO sor_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Dawa dɨ idɨ wama mani woni sii ꞌywala gɨnə kɨrara gɨ daa kwaynaniyə di nem mwom da, Jesu dam wama bɨwə day gɨ nə paja duwa di mɨn. ");
INSERT INTO sor_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ɨr̰ɨ an̰ji waygɨ da: «Nə ùr bá ba nə wom mani gandang mana gɨ sii ꞌywala gɨnə kɨrara gɨ daa gɨ ta di lə do me ba nə ha gɨlə dɨrɨn̰. ");
INSERT INTO sor_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Nə wayang daa wang: Mani woni sii ꞌywala gɨnə kɨrara gɨ daa di, nə ha wamagɨ ɗang bədə bɨr̰ɨn̰ bɨraa ɗan̰ sii ꞌywala gɨ ta di gɨndɨw dɨ ɓag àlalna alə daa ciri dɨnə Mãr̰ĩyə bá do.» ");
INSERT INTO sor_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ɨr̰ɨ an̰ji u kob dɨ gani gɨ yabɨr̰a yàa duwa ilə dwalɨn̰yə ɨsəwə me àlɨ́w Mãr̰ĩ dóche lə diiyə me waygɨ da: «Unə chàna pad dannə pad. ");
INSERT INTO sor_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nə wayang daa wang: Caga da, nə ha chàa gani gɨ yabɨr̰a yàa duwa di ɗang bədə ɗɨm, bɨraa i wála gɨ ɗan̰ Mãr̰ĩ ha lama gɨ dwãr̰ĩ duwa lə di bá.» ");
INSERT INTO sor_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Targɨn̰ ɗang da, Jesu u mapa ɨsəwə me àlɨ́w Mãr̰ĩ dóche lə diiyə me ɓolbɨ dodə u ꞌyàgɨ́ me waygɨ da: «Ta di, i doni gɨ sɨn. Nə ꞌyàw sarga i dara darang. Àlna yande kal dusɨrəng gunəng nɨm daa dɨnnə.» ");
INSERT INTO sor_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Mana gɨ cendi wom mani di bam mwom da, an̰ji u kob dɨnə gani gɨ yabɨr̰a yàa duwa di ɨsəwə bi me àlɨ́w Mãr̰ĩ dóche ya dee ba a àl nɨm gɨ mapa di de, me way da: «Gani gɨ ta di, i mɨlan dɨ dɨrway dɨ Mãr̰ĩ yɨ gandang. Mɨlan dɨ ta di, an̰ji yɨdɨ i gɨ bare ni gɨ bor dodə dara darang di. ");
INSERT INTO sor_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Me caga da, yarna: Aba ùrə yə̀n ꞌyàgɨ́ woni mar̰ande ni ɨsɨragɨ lə di kaw, ilə wama lə gandɨn mɨn. ");
INSERT INTO sor_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","I sɨdɨ, ɨndi gɨ Gun gorndɨw di, nə ha mara le ꞌyang, ya Mãr̰ĩ ba ɨrɨm nɨm de, me an̰ju gaba ꞌyàn woni mar̰ande ni ɨsɨragɨ lə di da, wamani ha ꞌywawe.» ");
INSERT INTO sor_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ɨr̰ɨ woni gɨrsə gwale duwa di ùrbɨ sɨdəgɨ ba da, i wi dwar̰agɨ lə mɨn me ba ha àla mani nə ta di mo? ");
INSERT INTO sor_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ɗang da, woni gɨrsə gwale gɨnə Jesu duwagagɨ gwale ba, dwar̰agɨ lə da, i wi me gɨ yərɨw ba nem ꞌya geche day mo? ");
INSERT INTO sor_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesu waygɨ da: «Dolgə nənə nare nə sɨn̰a gɨndɨdɨ lə pad da, cendi bɨl nare day ya ba gɨ i woni ciri day de. Me woni lama dwãr̰ĩ kwandagɨ dɨdəgɨ lə da, kal sɨdəgɨ gɨ ꞌwogɨgɨ ba i woni àla mani nə lade. ");
INSERT INTO sor_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ɗɨm da, ꞌyeni dan da, kal ina yande bədə. Ladni duwa da, gun gɨ geche dwar̰angə da, cwana sɨw ya dwe gɨ ꞌyəng de me, aba dama dɨdəngə da, kal a cwana sɨw aba kɨjəgɨ kwandaw. ");
INSERT INTO sor_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ya ɨrmə dannə da, i wi mɨn me i geche mo? Aba dama wama bɨwə labaa, aba ɨsəgɨ nare mani nə wama mo? I aba dama wama bɨwə bədə mo? Me ɨndi da, nə ilə dwar̰angə ya aba ɨsəng wama de. ");
INSERT INTO sor_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","ꞌYeni da, anə ɗɨbə gandɨn waya mana gɨ wamani niyə. ");
INSERT INTO sor_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","I dara ta di me dwãr̰ĩ dɨ Aban gɨ Mãr̰ĩ ꞌyàn gandɨdɨ di, ɨndi di kaw, nə ꞌyàng gandɨdɨ me ca. ");
INSERT INTO sor_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Yande da, anə ha wama me chàa me gandɨn wála gɨ nə dara lama dwãr̰ĩ ni me, anə ha dama gagege nə dwãr̰ĩyə àlagɨ́ nare nə Israyel gangle day gɨ mwaj dii sɨr di sariya.» ");
INSERT INTO sor_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ɨr̰ɨ Jesu wayɨw Piyer da: «Simõ, Simõ, àsɨ angal dɨma ladɨ le! Sidan ùr Mãr̰ĩ dara ba dɨ lugiyənge ya ba gɨ lugi gɨ swagə ɗagɨna lə de. ");
INSERT INTO sor_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Me ɨndi da, nə amsɨ Mãr̰ĩ daram dara kal dusɨm dɨ kala di cwarna targɨn̰ bədə. Me ɨjɨm da, wála gɨ mə cwarnay kalna dusɨm dɨnnə ɗang bi da, hurəgɨ chamram abnani dusɨrəgɨ lə.» ");
INSERT INTO sor_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Piyer cow wayɨw da: «Aba ciri ni, ɨndi da, ina i mana gɨ dangeyə labaa madeyə kaw, nə ha hára i gandɨm.» ");
INSERT INTO sor_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesu cow wayɨw da: «Piyer, nə wayɨm: Laba da, mə ha bɨlə bɨm sarni dɨm subu ba mə ꞌwocn̰ɨn bədə do me gɨray ha swaya hɨrda sɨn̰.» ");
INSERT INTO sor_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ɨr̰ɨ Jesu waygɨ woni gɨrsə gwale duwa pad dayyə ba da: «Wála gɨ tanga pii nə kɨjəng dɨban ꞌwoo gɨ gursɨ ɨsɨrangə me magɨla ɨsɨrangə me laya gɨ gɨbande daa me da, i na jalang mo?» Cendi cow wayɨw da: «Mani mɨn jalnin bədə.» ");
INSERT INTO sor_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","An̰ji waygɨ da: «Ɨr̰ɨ caga ka da, gun gɨ gursɨ duwa ina lə da, a unə daa ɨsəwə, me gɨ magɨla duwa ina lə kaw, a unə daa ɨsəwə me ca, me gun gɨ sugɨnə duwa dɨ chere ina lə bədə da, a kɨlnə barge duwa gɨ geche bam me kɨlnə gɨ sugɨnə di. ");
INSERT INTO sor_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Nə wayang daa wang dara gwale gɨ gɨ jangɨw Maktubu dɨnə Mãr̰ĩyə, ha àlala le dɨnə bá. Gɨ jangɨw ba gɨ āsɨw ɓamɨw gɨ nare woni ꞌyáa mana di mɨn. I sɨdɨ, mani nə woni cɨmə Mãr̰ĩ bɨw nə pii jangɨ ɨrɨm dara daran di, ha àlala le ɗɨm me ca.» ");
INSERT INTO sor_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Cendi wayɨw da: «Aba ciri nin, yər sugɨnəne sɨr ilə ka ɗɨm.» An̰ji cor waygɨ da: «Ta di nemme ɗɨm.» ");
INSERT INTO sor_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ɨr̰ɨ Jesu dɨm ha kur̰a dɨ Olib dɨdə ya te ba a àlbɨ nɨm pii pii de, me woni gɨrsə gwale duwa kaw, pamɨw tarɨwə me ca. ");
INSERT INTO sor_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Cendi gɨr mana gɨ ta lə di mwom da, an̰ji waygɨ da: «Amsɨna Mãr̰ĩ dara mana gɨ mani ꞌywanang da, kal lamnang bwanang àla gɨ àcn̰a lə bədə.» ");
INSERT INTO sor_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ɨr̰ɨ an̰ji duwa da, biy sɨw ha bam hin̰e kal bulə day wor bam ɓani me, piy gubɨrəw dodə me amsɨ Mãr̰ĩ ba da: ");
INSERT INTO sor_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","«Aban, ladɨna dɨrəmmə da, chidɨ gɨlə gɨ dɨrɨn̰ gɨ ta di ha nɨm bam sɨnnə. Ladɨna bədə da, àl mani nə dɨrəm ùr ɨjɨm, kal àla nə ùrə niyə ɗi.»  ");
INSERT INTO sor_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Mana gɨ ta lə da, paja gɨnə Mãr̰ĩ duwa gɨ daa mɨn dɨmə gɨra ꞌyow me ꞌyàw dwana. ");
INSERT INTO sor_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jesu di, lán̰a gɨ geche àlɨ̀w me, an̰ji amsɨ Mãr̰ĩ mɨrgɨw nɨm daa daa me, làn̰a gɨ sɨwə cor wun ya bare de me ulbɨ bor dodə. ");
INSERT INTO sor_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Mana gɨ an̰ji amsɨ Mãr̰ĩ di bam pad mwom da, so daa ha ꞌywaa woni gɨrsə gwale duwa di. Me an̰ji ꞌyogɨ cendi i i nuni nə n̰agɨni ");
INSERT INTO sor_vpl VALUES ("LK22_46","072_22_46","LUK","22","46"