﻿USE sofia;
DROP TABLE IF EXISTS sofia.soq_vpl;
CREATE TABLE soq_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES soq_vpl WRITE;
INSERT INTO soq_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Bumpeido God uba ita tawo segamon. ");
INSERT INTO soq_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Tane walama sawo tawo mai segalepe wineipe, dia, sala iwimpaia winedie ita God Aleupa os esa osowe tepaleidie. ");
INSERT INTO soq_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Ita God badowa wanase, “Sapa waa” ita sapa segalen. ");
INSERT INTO soq_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Ita God sapa sa ewena ipa euda ita sapa iwimpa nata empuiamone nambenambemon. ");
INSERT INTO soq_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Ita God sapa ebowa wane ituna walama, tane iwimpa ebowa wane ituna tadina. Ita rawi rialene aleno walama sapawa wisen. Sa ipa walama dea. ");
INSERT INTO soq_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Ita God badowa wanase, “Bela badowa iono segaite esa enapundepio nata segantopu.” ");
INSERT INTO soq_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Ema epe inta God wano bela badowa esa einpue awopa itun, da atowe ita da iono, ita rua segalen. ");
INSERT INTO soq_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Ita me bela badowa ionoa ebowa wane ituna uba. Ita rawi rialene aleno ita walama sapawa wisen. Sa ipa walama natawa. ");
INSERT INTO soq_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Ita God badowa wanase, “Esa uba atowe enapune inta dea enaa ita dogo makowa segaita.” Ita wana rua segalen. ");
INSERT INTO soq_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Ita God tawo makowa ebowa wane ituna dogo, tane esa auwene enena ebowa wane ituna owa. Ita God ewena ipa euda. ");
INSERT INTO soq_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Tane God badowa wanase, “Dogo osowe nitu uduudu initane segaitana, isiwa ipawa os ita isiwa ipawa naumpaa bedewe naumba dola. Ita naumba naumompa iawa inainambu rua.” Ita wana rua segalen. ");
INSERT INTO soq_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Ita tawo osowe nitu uduudu wana rua seganton, isiwa ipawa os ita isiwa naumompa bedewe naumba dola. Ita naumba isiwa naumompa bedewe iawa inainamba rua. Ita God ewena ipa euda. ");
INSERT INTO soq_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ita rawi rialene aleno ita walama sapawa wisen. Sa ipa walama natadeawa. ");
INSERT INTO soq_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Ita God badowa wanase, “Sapa siwa rua uba tampe segaitane walama ita tadina enapundepio awoantopu. Tane eueuwa baiwa walama ita ena intaweintawe nolantompa ita do oda walamawa insempaa baiwa empuempusapi. ");
INSERT INTO soq_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Ita sapa siwa rua uba tampe walama oniempe nolalempa baiwa.” Ita wana rua segalen. ");
INSERT INTO soq_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","God sapa siwa rua debamau nata dewamon, sapa debamawa walamo sapa wampaa baiwa, ita sapa kerauda tadino sapa wampaa baiwa. Ita kipora do dewamon. ");
INSERT INTO soq_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","God sapa siwa rua uba tampe teamona tawo sapasampaa baiwa, ");
INSERT INTO soq_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ita sapa sa walamo ita tadino nolantompa baiwa ita do sapa iwimpa nata empuempumopia baiwa. Ita God ewena ipa euda. ");
INSERT INTO soq_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Ita rawi rialene aleno walama sapawa wisen. Sa ipa walama 4. ");
INSERT INTO soq_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","God badowa wanase, “Esa bedewe moia uaraitane wanlempa, ita do nene uaraitane uba tampe leununa.” ");
INSERT INTO soq_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Ita me owa moiawa debamau ita kerakera ewaewau daitada uduudu dewamon, moia owa bedewe wanwanlala ita nene ewaewau daitada mo muba uarantopu muba inainambu rua. Ita God ewena ipa euda. ");
INSERT INTO soq_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Ita God sau euda osouwo itune wanase, “Moia esa bedewea otootoitana ita uaraitane esa bedewa nopesana, do nene tawo osowe otootoitane uaraitana.” ");
INSERT INTO soq_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Ita rawi rialene aleno walama sapawa wisen. Sa ipa walama 5. ");
INSERT INTO soq_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","God badowa wanase, “Tawo ema osowe pue daitada segaitana. Pue manasau duwa wanwanlala ita pue dobinoa, do pue dogo osowe tetelala eba otootoitane inainala rua segaitana.” Ita rua segalen. ");
INSERT INTO soq_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","God pue inainambu daitada dewamon ita isiwa otootontone muba inainambu rua seganton. Ita God ewena ipa euda. ");
INSERT INTO soq_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Tane God wanase, “Tauma no apana dewasata, no inainanimba rua. Ita mo moia esa bedewe wanwanlala, ita do nene uduudu uba tampe lalala do pue daitada tawo osowe wanwanlala ita isiwa tetelala do oniamopu.” ");
INSERT INTO soq_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","God apana dewamona meba inainamba rua. Meba ruaida dewamon. Me apana ita i dewamon. ");
INSERT INTO soq_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","God sau euda mo osouwo itune wanase, “E tawo ema osowe otootoitane uaraitane ita e os uduuduitana. Moia owa bedewe wanwanlala, nene iono lalala ita do pue uduudu tawo osowe wanwanlala oniamona.” ");
INSERT INTO soq_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","God wanase, “Tawo osowe nana uduudu enalena, nana isiwa bedewe naumba dola. Tane nana ipawa naumoie wineia ipa e baila nanuna baiwa. ");
INSERT INTO soq_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Tane pue dobino wanwanlala ita nene iono lalala ita do pue tawo osowe tetelala inawaa waimoia mo baibu ne ina wasiipa wanamodina mo nampaa baiwa.” Ita me wana rua segalen. ");
INSERT INTO soq_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Tane God dewa uduudu dewamona ewamona ipa eudida. Tane rawi rialene aleno ita walama sapawa wisen. Sa ipa walama 6. ");
INSERT INTO soq_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Ita God uba, tawo ita bedewe dewa uduudu wineia dewamontuwan. ");
INSERT INTO soq_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","God nitu uduudu dewamone diasan ita walama 7 bedewe bubualen. ");
INSERT INTO soq_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","God walama 7 eusane kakaisane awoasane itun, ipawa walama sawo me nolawa dewasane diasana bubuawalen. ");
INSERT INTO soq_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Ita Iawe God, dogo mampe apana dewasano segalen. Ita me baidawe ina nonaupa sune ina waneno inawaa enenwisene wain. ");
INSERT INTO soq_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Tane Iawe God, omo wiseidia deneuwe bola Iden bedewe irai dewasane ita apana me dewasana sape itun. ");
INSERT INTO soq_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Tane Iawe God ia ewaewau daitada ipawa ewee nuauepio nanawa meneepia dogo osowe dewamono inintoie naumoie. Ita irai sa bedewe ina iawa ita do euda ita kadiwa atentompa iawa sawano eneie. ");
INSERT INTO soq_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Tane do irai sa bedewe esa aleidie irai butasampo inidewalempa baiwa. Ita esa ipa sa Idenwae nosene aleidia ragaragalene ragapa uduudu 4 seganton. ");
INSERT INTO soq_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","12","Ita esa ipa sa ragapa dea ebowa waia Pison Awila tawowa uduudu panenbodene aleide. Tane bola sa bedewe goldida uwatauwa ita ia esapa bonawa eudida ita do seu oau eubuida ebowa onik winamoi. ");
INSERT INTO soq_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Tane esa ipa deawa ragapa natawa ebowa Gion Kus tawowa uduudu panenbodene aleide. ");
INSERT INTO soq_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Ita ragapa natadeawa ebowa Taigiris bola ebowa Asiria tawowa moawa omo wisedia deneuwe aleide. Tane ragapa 4 ebowa ipa Eupirates. ");
INSERT INTO soq_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Tane Iawe God, apana wadene Idenwa irai bedewe ituna irai sa bedewe nolalempe ita do oniempadewalempa baiwa. ");
INSERT INTO soq_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Tane Iawe God badowa apana diene wanase, “Irai ema bedewe ia daitada inintoie ipawa naumoia e namona rua os. ");
INSERT INTO soq_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Tane euda ita kadiwa atentompa iawa ipawa mai wadee naa, diaida. Tane ia sa ipawa wade naa e tauwadea boitaa.” ");
INSERT INTO soq_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Tane Iawe God wanase, “Mai eulepona apana meba os waimpa, dia. Sa baiwa ne me sauwa apanawa onaidasapia dewasapa.” ");
INSERT INTO soq_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Tauma Iawe God tawo osowe dogo wadene pue daitada ita nene uduudu uba tampea dewamone otene wisene apana mampesan ebou teamopia baiwa. Ita Adam mo ebou wane teamon. Ita sa ipa mo ebou. ");
INSERT INTO soq_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Ita apana sa pue debamau uduudu, nene uba tampea ita pue daitada tawo osowe ebou wane teamon. Tane me sauwa apanawa mai segalepona, dia. ");
INSERT INTO soq_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Sa baiwa Iawe God, apana dewasano itulene nuawa awawaidaleno siwa nepa wadenaubene aupe etepa wadene aupawa itunboden. ");
INSERT INTO soq_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Tane Iawe God, apana siwa nepa wadenaubene mampe i dewasano segalen. Ita me wadene apana mampesan. ");
INSERT INTO soq_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Tane apana wanase, “Neai ema ipa ne neainaida bedewe segalen, Ete ema ipa ne mainawoe ibu ema segalena, Tauma me ebowa ipa I, ipawa me apana bedewee segalen.” ");
INSERT INTO soq_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Sa baiwa apana mona mamba ita inawa emopie manainapa nata ete deaida segantopue waimompa. ");
INSERT INTO soq_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Tane walama sawo apana mona manainapa nata nikoakoa waimoie ita mai malantoipe, dia. ");
INSERT INTO soq_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Tane Iawe God pue uduudu dewamona bedeuwo mota ipa laga wawa atembaida. Walama dea mota i diene wanase, “Ide ulaipa, God dialena irai Iden bedewe ia uduudu naumoia ipawa mai namona, ba?” ");
INSERT INTO soq_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Tane i mota sipoasane wanase, “No ia uduudu irai bedewe inintoia ipawa namonta rua. ");
INSERT INTO soq_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Tane God wanase, ‘Irai bedewe ia sawanoido enedia ipawa mai wadane nana ba ibuwa wadane etana, dia. Naita epe dewaitana e ando boitana.’” ");
INSERT INTO soq_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Tane mota i sipoasane wanase, “E mai boitana, diaida. ");
INSERT INTO soq_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Ipawa God atemba, e wadane nanaa walamawe e ando me ruawaitana, euda ita kadiwa ateitana.” ");
INSERT INTO soq_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Sa baiwa i ia ipawa eubu wineio ewamone nuausan. Ita do me menasana ia ipawa napie aten iwa debama segalepia insene ita ia ipawa wadene nane ita isiwa badawa waneno nan. ");
INSERT INTO soq_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Ita mo nata emau wadenaubeno nikoakoa waimoia ewane ita ia asiwa dewasane tauiena. ");
INSERT INTO soq_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Ita rawilene sala obasaleno mo Iawe God irai bedewe iedio wawa moinawa eteina. Ita mo Iawe God mampe santone ia eneia bedewe wereganton. ");
INSERT INTO soq_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Tane Iawe God apana apasane wanase, “E naepe?” ");
INSERT INTO soq_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Tane apana me sipoasane wanase, “Ne e irai bedewe waiano eteena tane nikoakoa wainedine baiwa santene wereganten.” ");
INSERT INTO soq_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Me waitaralene wanase, “E nikoakoa wainiana umanawa mida dieen? Ne ia ipawa umanawa e anaanaena dauwa e naana, ba?” ");
INSERT INTO soq_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ita apana sipoalene wanase, “E i ema ne nata wainenta baiwa neaana me ia ipawa wadene neno nana.” ");
INSERT INTO soq_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Tane Iawe God i waitarasane wanase, “E dima dewasaana?” Ita i me sipoasane wanase, “Mota ne laganeno ia ipawa nana.” ");
INSERT INTO soq_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Tane Iawe God mota diene wanase, “E epe dewaitena baiwa pue manasau ita pue daitada dobinoa waimoia bedeuwo ne matangelaedina buawobuawo teteitone tawo popokauwa nane lakasaitaa. ");
INSERT INTO soq_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ita ne e dewaepo i nata emalawoaitonuna ita e bedelawoa deawaa dewasampa. Ita i bedewea e uwaa ampitutudepi ita e i bedewea wawa kampa adaa.” ");
INSERT INTO soq_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ita me i diene wanase, “E buitee wanempa bedewe ne poka debamaia osoawo itupa, ita oto mulempa walamawe e poka debamaia etona. Tane e ideita badaa baiwaitona ita do e ideita badaa atoweitone aiawa ruaitona.” ");
INSERT INTO soq_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Tane me Adam mampe wanase, “Ne ia ipawa nanawa anaanaena e mai nana, tane e manainaa aiawa etee ruaitene naana baiwa ne tawo ema matangelasapa. Ita e walama uduudu nolaitone poka etone nana ipawa itumpo wadone nane wanempa. ");
INSERT INTO soq_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Tane dogo osowe bodu ita gedara inintopu ita do eba iraite poka etee ita nae tounawe wana. ");
INSERT INTO soq_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","E iraitone anawo pola nosepio nana ipawa itupio wadee nae tounawe wana. Tane ando e boitee leuite dogo bedewe aitaa. Ne tawo popokauwa mampe e dewaena tane ando leuite popokau wanaita.” ");
INSERT INTO soq_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Tane tauma apana manainapa ebowa wane ituna Iwi. Ebo ema ipawaida ipa, me ando apana uduudu inau wanalepi. ");
INSERT INTO soq_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Ita Iawe God pue etepa dewasane wadene ita Adam manainapa nata wanamono tauiena. ");
INSERT INTO soq_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Iawe God wanase, “Apana ema tauma no ruambanton mo insaisa euda ita kadiwa ewaewa atenton. Sa baiwa mo mai ina iawa ipawa wadapue napu, dia. Mo napue inawaa wankasantopua sawa.” ");
INSERT INTO soq_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Sa baiwa Iawe God mo waaubamono irai Iden bedewe waimoia ene nomone anton dogo sa mampe dewamona osowe wampue iraintopu. ");
INSERT INTO soq_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Ita me apana waaubamono nomone anton. Aupo me Iden iraiwa omo wiseidia deneuwe ensel kerubim teamon, ita do isima moamoaua idie bumedie leusaituleidie winedie ita mo irai bodane eneie ipawa mai apana da ina iawa mampe wisepi. ");
INSERT INTO soq_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adam manainapa Iwi nata ituntone ita me bulene oto Kein gamosan. Ita me wanase, “Iawe God sauwa mampe ne oto mona gamosana.” Me ebowa Kein. ");
INSERT INTO soq_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Ema aupe me oto da gamosane ebowa ituna Abel. Abel me sipsip onioniala ita Kein ipa irai apanawa. ");
INSERT INTO soq_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Mo epe dewantoie walama dea, Kein nanawa uwauwalene wisene Iawe God mampe amonawa itun. ");
INSERT INTO soq_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Tane Abel do sipsip otopa tautuwa sanaa bosane nipawa eubu os otene wisene itun. Ita Iawe God Abel ita me amonawa ewene nuawa eulen. ");
INSERT INTO soq_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Tane Kein ita me amonawa do dabuasane en. Sa baiwa Kein nuawa kadiidaleno namba araarasan. ");
INSERT INTO soq_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Mape Iawe God Kein waitarasane wanase, “E dima baiwa nuaa kadileidio ita do nana araarasaiana? ");
INSERT INTO soq_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","E euda dewasapono ne nuaeuntapona. Tane e kadiwa dewasaana baiwa ewaa dewaita kadi menasadia bedeawolepi e mukaite nanausaa.” ");
INSERT INTO soq_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Mape Kein wamba Abel diene wanase, “Enawo antata dobino.” Mo antone dobino laie Kein wamba Abel epenbolen. ");
INSERT INTO soq_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Ema aupe Iawe God Kein waitarasane wanase, “E wana Abel naepe?” Tane me Iawe God sipoasane wanase, “Ne mai atentapona me naepe. Ne mai nolana wineipona me oniepina.” ");
INSERT INTO soq_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Ita Iawe God me waitarasane wanase, “E dima baiwa dewa ema kadiwaida dewasaana? E wana osinapa dogo osowe ne mainawo biwa baiwa sidaleide. ");
INSERT INTO soq_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","E epe dewaitena baiwa ne matangelana e osoawolen. E wana epaaboleno osinapa dogo osowe memenauben, sa baiwa e mai iraita rua, dia. ");
INSERT INTO soq_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Tauma ita ando e nana iraitawo ipawa mai itupi tane dogo ipasialepi ita duasiawaia apana ewamone saawo nambeinta lakasaitaa.” ");
INSERT INTO soq_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kein Iawe God diene wanase, “Matangela ema ipa debamaia ne mai awanepa rua, dia. ");
INSERT INTO soq_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Tauma tawo ne wainedinawo tananeiana ita do ne mai e manawo wampaa rua, dia. Do ne dunasiawaia inta lalapa segantapa baiwantedina ita apana mida ne doinepia epanepibolepi.” ");
INSERT INTO soq_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Tane Iawe God me sipoasane wanase, “E mai epeubolepi, dia. Apana mida e epeepibolepia me ando sipoa matangela walama 7 ita osoweosowe debamaia wadepi.” Ita Iawe God me osowe pusi itun, apana pusi sa ewapue ita epu mai bosapu, dia. ");
INSERT INTO soq_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Tane Kein Iawe God eniene nosene bola Iden moawa omo wisedia deneuwe Nod bolawa bedewe wandie. ");
INSERT INTO soq_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Ita mo sape waimoie Kein manainapa nata ituntone ita me bulene otopa Enok gamosan. Tane sape Kein bola debama dewasane ita otopa ebowa wadene bola sa ebowa Enok wane itun. ");
INSERT INTO soq_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Tane Enok me ipa Irad mamba, Irad Melgal mamba, Melgal Metusel mamba ita Metusel me ipa Lamek mamba. ");
INSERT INTO soq_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Tane Lamek ioto nata naimon, mo ebou ipa Ada ita Sila. ");
INSERT INTO soq_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ita Ada Sebal gamosan. Tane Sebal me ipa apana mida ape bedeuwointa waimoie pue gamontoia dewawa uwalena apanawa. ");
INSERT INTO soq_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Tane Sebal wamba ebowa Subal me ipa mo mida kanko epeia ita kolago suia dewawa uwalena apanawa. ");
INSERT INTO soq_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Ita Sila otopa gamosana ebowa Tubal-Kein, me ipa apana mida aelan ita irama mampe nitu badou dewamoia uwaulena apanawa ita Tubal weanapa ipa Nama. ");
INSERT INTO soq_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Tane walama dea Lamek iotopa nata Ada ita Sila diamone wanase, “Asisuneanuno wapa, ema epe: Apana dea ne epaneno poka etaidasane sipoa ne epanabolen. ");
INSERT INTO soq_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Ita apana mida Kein bosapia me matangelawa debama 7 wadepi. Tane mida ne kadina sipoasapia me matangelawa 7 ampiboe 77 wadepi, sa ipa matangela debamaia osoweosowe wadepi.” ");
INSERT INTO soq_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Tane Adam manainapa nata osowe ituntone ita me oto gamosan. Ita me ebowa Set wane itun, Ebo ema ipawaida ipa, “God oto da ne nen Kein Abel epenbolena aupawa wadepia baiwa.” ");
INSERT INTO soq_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Tane Set oto gamosana ebowa Enos wane itun. Ita Enos wandia walamawe apana Iawe God ebowa kakaisaie wadaposisaie. ");
INSERT INTO soq_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","2","Walama sawo tawo osowe apana muntoie uarantoio bedeuwo God obampa ioto ewaewau eubuida mo ewamone nuaumono sonabamone naimoiena. ");
INSERT INTO soq_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Ita Iawe God wanase, “Ne aleuna mai apana inainambu ema etepu oaoara ando bolepie dialepia bedeuwo waimpo walama daumaia dialepi, dia. Sa baiwa ne mo enau 120 os wanamona bedewe tawo ema osowe wampu.” ");
INSERT INTO soq_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Walama sawo ita adiwe odene su alena apana mubu debamau tawo osowe waimoie. Tane walamaipa God obampa apanaida iwoa do ituntoia sedau gamomoie. Ita seda sa ipa mukamukaua ita dewa pokawaa dewalala do ebou alala ita do mo dudunau wawalala. ");
INSERT INTO soq_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Iawe God apana kadiwa daitada tawo osowe dewamoie waimoia ewamodie. Ita mo walama uduudu dima inseie dewamoia ipa kadiwaida. ");
INSERT INTO soq_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Sa baiwa Iawe God nuawa parelen ita do nuawa pokaida wan apana me dewamone tawo ema osowe teamono waimoia mampo. ");
INSERT INTO soq_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Ita Iawe God wanase, “Tauma ne apana uduudu tawo osowe waimoia kadimopatuapi. Ne nuana pareidaleide dima baiwa ne mo dewamona. Sa baiwa ne apana uduudu ita pue debamau ita kerakera tawo osowe tetelala ita nene iono laia do kadimopatuapi.” ");
INSERT INTO soq_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Tane Iawe God apana dea ebowa Noa ewene nuawa eulen. ");
INSERT INTO soq_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Noa obampa do dudunau ema epe. Noa obampa natadea, mo ipa Sem, Am ita Iapet. Walama sawo Noa me ipa apana euda dodomana mai wawu da do apana bedeuwo wandie. Tane me God aiawa ruawaleidie wadaposisadie wandie. ");
INSERT INTO soq_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","God tawo ewena ipa kadiidalen ita apana uduudu tawo osowe dewa daitada rebarebaida dewamoie waimoie. ");
INSERT INTO soq_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Ita do God tawo ewena ipa rebarebalene kadiidalen ipawa apana uduudu kadiwa daitada inseie ita dewasaie waimoie. ");
INSERT INTO soq_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Sa baiwa God Noa diene wanase, “Tawo osowe kadi debamaidalen ipawa apana waine kadi dewasai. Ne insedina tawo ema ita apana uduudu ne kadimopatuapi. ");
INSERT INTO soq_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Sa baiwa ne menanedia e ema epe dewaita: Tauma e eba baia waa debama ia euda badou mampe dewasa. Ita waa sa bedewe bola empuempumoa. Ita ema aupe waa bedewa ita adiwa ia bodipa mampe pasisabodaitaa. ");
INSERT INTO soq_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ema epe rua waa dewasaa: daumalepia mitawa 140 ita debamalepia mitawa 22 tane odepi alepia mitawa 14 wadepi. ");
INSERT INTO soq_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Waa iwa dewasane bela ita du iwa sawanauwo naga awopawa witaa uraupe ita kompa oso nosena rua daumawa ea. Tane du moawa waa sainape itua ita waa bedewe wanwan bolawa iono, sawano ita atowe dewamoa.” ");
INSERT INTO soq_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Ita God wanase, “Asisuitana! Ne abaia wapaaubepo wisepie nitu uduudu tawo osowe inawa waimoia ita do nitu isiwa nonau tounawe waimoia kadimopituapi. ");
INSERT INTO soq_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Tane ne sauana badowa e manawo wadina. E ita obana, manainaa ita do obana manamanainapu do waa bedewe odana. ");
INSERT INTO soq_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Ita do pue daitada natanata mona ita iwoa manawo wimopuo otamoe waa bedewe aimoa. Tane nene daitada do pue debamau ita kerakera isiwa tetelala inawaa waimompa baiwa natanata otamoe aimoa. ");
INSERT INTO soq_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ita do nana daitada nanalala e eba baila ita do pue baibu otamoe waa bedewe adibaitaa.” ");
INSERT INTO soq_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Ita God badowa Noa diena rua uduudu dewasantuan. ");
INSERT INTO soq_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Tauma Iawe God Noa diene wanase, “Ne emanawo apana uduudu walama ema bedewe muntone tawo ema osowe waimoia bedeuwo e dea os dodomana wainiana, sa baiwa e ita manainaa, obana ita manamanainapu do waa bedewe odana. ");
INSERT INTO soq_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Tane pue eubu mona 7 ita iwoa 7 otamoe aimoa. Tane pue isiu da mai eubu mona dea ita iwoa dea otamoe aimoa. ");
INSERT INTO soq_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Do nene daitada mona 7 ita iwoa 7 aimoa. Ipawa pue daitada ita nene iono lalala inawaa tawo osowe waimompa. ");
INSERT INTO soq_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Walama 7 dialepio ne unu tawo ema osowe wapaaubepo wampo walama 40 ita tadina 40 dialepi. Ita nitu uduudu inawaa tawo osowe dewamona kadimopatuapi.” ");
INSERT INTO soq_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ita Noa dewa uduudu Iawe God badowa diena rua dewasan. ");
INSERT INTO soq_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noa gulauidalene enawa 600 wadedio abaia debama tawo osowe segalen. ");
INSERT INTO soq_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Sape Noa ita me manainapa ita obampa manamanainapu do abaia saiepue inantopua baiwa waa bedewe odeiena. ");
INSERT INTO soq_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Tane pue eubu ita kadiu, nene ita pue uduudu dogo osowe tetelala mona ita iwoa natanata Noa mampe wimone waa bedewe odeiena God wana rua. ");
INSERT INTO soq_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Ita walama 7 dialeno aupe abaia segalene tawo osowe wisen. ");
INSERT INTO soq_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Noa enawa 600 wadeno uaboa natawa walama 17 bedewe esa tawo bedewe segalene odene wisen. Tane do uboo unu duwa moawa wadaaubalen. ");
INSERT INTO soq_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Ita unu wadio walama 40 ita tadina 40 dialen. ");
INSERT INTO soq_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Tane walama sa deawaa bedewe Noa ita me manainapa ita me obampa Sem, Am, Iapet ita mo manamanainapu do awodea waa bedewe odeiena. ");
INSERT INTO soq_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","15","Ita do pue duwa wanwanlala ita dobinoa ewaewau daitada, do nitu uduudu dogo osowe tetelala, nene ewaewau daitada, do nitu uduudu debamau ita kerakera inawaau, isiwa mabupu dola uduudu Noa mampe wimone waa bedewe odeiena. ");
INSERT INTO soq_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Pue daitada mona ita iwoa tane nitu uduudu inawaa wanwanlala waa bedewe odeiena God wana rua. Ema aupe Iawe God waa moawa gudulen Noa diena rua. ");
INSERT INTO soq_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Tane abaia ideita tawo osowe weuwadio walama 40 waden ita esa susugalene waa tawo oso enedia awanenposiden. ");
INSERT INTO soq_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Tane esa debamalene odene tawo uduudu rupusan ita waa sa tonpisideno esa osowe enedie. ");
INSERT INTO soq_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Ita esa susugalene odene aleidie wadi debamau uduudu tawo osowe eneia nanaumon. Ita esa sa mo awanaposimono iono tenantoie. ");
INSERT INTO soq_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Tane esa odene wadi nanasimone adiwe odene alena makawa 20 waden ita esa uduudulene wadi uduudu nanaumon. ");
INSERT INTO soq_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Ita nitu uduudu tawo osowe inawaa waimoia, sa ipa nene, pue duwa wanwanlala, pue daitada dobino wanwanlala, esa moiawa daitada ita do apana uduudu bontoiena. ");
INSERT INTO soq_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Tane nitu uduudu inawaa tawo osowe waimoia bontonatuwaiena. ");
INSERT INTO soq_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","God nitu uduudu inawaa tawo osowe waimoia, apana uduudu, pue debamau ita pue kerakera tetelala ita nene uduudu bomontuan. Tane Noa ita mo mida waa bedewe odoiena os inanton. ");
INSERT INTO soq_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Tane esa abaialene winena walama 150 waden. ");
INSERT INTO soq_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Tane God Noa ita pue dobinoa do pue gamolala me do waa bedewe waimoia insamone baiwa lanunu dewasano tawo osowe wisene esa dewasano aisidene iene alen. ");
INSERT INTO soq_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Ita do me esa tawo bedewe naimedi wisedia tane do unu debama uboe wadie nosedia intawa enabodamon. ");
INSERT INTO soq_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Tane abaia aisidene iene aleidie ita walama 150 wadedio esa aisidedie. ");
INSERT INTO soq_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Ita uaboa 7 bedewe walama 17 wadedio waa wadi Ararat osowe ependoden. ");
INSERT INTO soq_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Tane esa aisidene iene aleidie uaboa 10 ualeidio wadi iu sabamontoiena. ");
INSERT INTO soq_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","7","Ita walama 40 dialeno aupe Noa waa nagawa imaasano winedia wadenaubene nene wadene itunieno alen. Tane nene galobu sa nosene alene leidie mai leulepe wisepona ipawa esa mai aisidepe iape alepona. ");
INSERT INTO soq_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Tauma me sala dauwa ewepie atenlepia baiwa me nene bunebune itunieno alen. ");
INSERT INTO soq_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Tane nene sa nosene alena mai wanwan bola da donsapona esa uduuduleno baiwa leulene wisen. Ita Noa nene sa wadene leusane ain. ");
INSERT INTO soq_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Me wandio walama 7 dialeno osowe nene bunebune wadene itunieno alen. ");
INSERT INTO soq_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Tane rawileidio nene bunebune ia olib asiwa wasiipa euwaida apusene wiseno Noa ewene atenlen tauma esa aisidene iene alen. ");
INSERT INTO soq_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Tane walama 7 da dialeno me nene bunebune osowe wanaubeno alen. Ita nene sa mai leulepe mampe wisepona, dia. ");
INSERT INTO soq_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Tauma Noa enawa 601 waden. Ita ena sa bedewe uaboa dea bumpe esa aisidene iene alene dialen. Ita me waa iwa wadenaubene sala makolena ewen. ");
INSERT INTO soq_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Tane uaboa natawa bedewe walama 27 wadedio esa uduudu makolene diaidalen. ");
INSERT INTO soq_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Ema aupe God Noa diene wanase, ");
INSERT INTO soq_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“E manainaa nata ita obanaa manamanaipu do waa ene nolena. ");
INSERT INTO soq_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Tane nitu uduudu inawaa e do wainilana, nene, pue debamau ita do pue kerakera tetelala uduudu otaaubamoe do nolena dogo osowe muba otootontopue uarantopu tawo osowe.” ");
INSERT INTO soq_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Mape Noa manainapa nata ita obampa manamanainapu do waa bedewe waimoia ene nomoiena. ");
INSERT INTO soq_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Ita pue uduudu nene ita pue isiwa tawo osowe lalala waa ene mubaawomubaawo nomoiena. ");
INSERT INTO soq_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Tane Noa Iawe God mampe pue pulolepie supia watawa dewasan. Ita me pue ita nene uduudupau eubu otene wisene wata osowe teamone sumon. ");
INSERT INTO soq_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Ita Iawe God pulo sa idia bonawa euda etene nuawa bedewe insene wanase, “Ne tauma ita ando tawo mai matangelasapa ipawa apana dewau baiwa. Mo sanaape muntoie odeie eiantoia ipa kadi do muntoi. Mo kadiwa insempe dewasampa tane ne mo ita nitu uduudu inawaa waimompa mai osowe kadimopa, dia. ");
INSERT INTO soq_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Tane tawo ema winompa walamawe, lawuru anamba ita uwauwa walamawa, obasa ita ginasa, unu ita omo, walama ita tadina, dewa ema ideita winamompa.” ");
INSERT INTO soq_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Tane God Noa ita obampa do osouwo sau euda itune wanase, “E tawo ema osowe otootoitane uaraitane e os uduuduitana. ");
INSERT INTO soq_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Ne pue debamau ita kerakera uduudu da tetelala, nene ita do esa bedewe wanwanlala uduudu dewamopo e saantompa ita do onioniau apanawa wanaite oniamona mukawa eneedina. ");
INSERT INTO soq_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Moia inawaau ema uduudu waimoia ipa e nanaa. Mapo nana uduudu inilala eneena rua. ");
INSERT INTO soq_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Tane ne anaanaedina e moia osina do mai naa ipawa ina osina bedewe winede. ");
INSERT INTO soq_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Ne osina anaanawa badowa itudina, naita pue apana adepio osinapa nosepituapio bolepia ne pue sa ando matangelasapa. Tane apana enepie sowa bosapia sipoa ne apana sa matangelasapa. ");
INSERT INTO soq_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Ipawa God inainamba rua apana dewasan. Sa baiwa apana mida soa bosapia apana sa do bosapu. ");
INSERT INTO soq_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Ita e obana do otootoitane tawo osowe uaraitane e os uduuduitana. ");
INSERT INTO soq_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Ita God osowe Noa ita me obampa do mampo wanase, ");
INSERT INTO soq_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","Asisuitana! Ande ne sauana badowa itudina e ita e bedeawoa muntompa mampo ");
INSERT INTO soq_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","ita pue inawaa uduudu, nene daitada do pue duwa wanwanlala ita pue dobinoa e do waa bedewee nolena ita ando muntompe waimompa do manlawo itudina. ");
INSERT INTO soq_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ne sauana badowa itudina e manlawo, ne mai osowe abaia wapaaubepo nitu uduudu inawaa tawo osowe waimoia ita do tawo kadimopi, dia. ");
INSERT INTO soq_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Ita God wanase, Ne sauana eueuwa itudina e ita ne sawanambo ita nitu uduudu inawaa e do wainilana manalawo. Ita do apana ando muntompa do mampo sauantedina. ");
INSERT INTO soq_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Ne sauana badowa eueuwa wari giou bedewe itupa ne ita nitu uduudu inawaa waimoia sawanambo. ");
INSERT INTO soq_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Ne walama isiwa tawo osowe giou dewasapino odompa ita giou sa bedewe wari segalempa. ");
INSERT INTO soq_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Ita ne sauana ema nuaituneampa, e ita ne, do nitu uduudu wanwanlala daitada sawanambo. Abaia mai osowe nosepie nitu uduudu inawaa waimoia kadimopi, dia. ");
INSERT INTO soq_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Tane wari giou bedewe segalempo ewape ne sauana winakasala God ita nitu uduudu tawo osowe inawaa wanwanlala sawanambo winedia insepa. ");
INSERT INTO soq_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Sa baiwa God Noa diene wanase, Ema ipa ne sauana eueuwa ne ita nitu uduudu inawaa tawo osowe wanwanlala do sawanambo itudina.” ");
INSERT INTO soq_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Tane Noa obampa do waa bedewe waimoie nomoiena ipa: Sem, Iapet ita Am. Ita Am me ipa bola Kanaan apanawa mambu. ");
INSERT INTO soq_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Apana ema natadea ipa Noa obampa mo bedeuwoe apana muntone uarantone tawo uduudu bedewe alentuwan. ");
INSERT INTO soq_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Tane Noa me ipa irai dewalala me wain iraiwa aina apanawa. ");
INSERT INTO soq_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Ita Noa wain wadene nane ua koakoaleno nikoakoa ape bedewe ituleidie. ");
INSERT INTO soq_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Tane bola Kanaan apanawa mambu Am mamba Noa nikoakoa ituleidio ewene nosene alene sosowa benemamon. ");
INSERT INTO soq_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Ita Sem Iapet nata epe etane gara debama wadane awanapu osowe epanadoe adiwoadiwo antone mambu rupusaiena ita mambu mai ewapona emau nambesane ene anton. ");
INSERT INTO soq_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","25","Tane Noa ua koakoalena dialeno enenwisene me otopa ompa ebowa Am dima me mampe dewasana umanawa etene saua kadiwa otopa sa Kanaanwa mambu osowe itune wanase, “E ipa Sem ita Iapet nata nolau dewalala, diapanaida segaita.” ");
INSERT INTO soq_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","No Iawe Sem Godiwa wadaposisata. Ita do sau euda otopa Sem osowe itune wanase, “Iawe God sauwa euda e osoawo winepi ita Kanaan apanawa e nolaa dewalala segantopu.” ");
INSERT INTO soq_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Tane God sau euda Iapet osoawo itupie bolaa debamasapi, ita do me Sem apewa ita nitu uduudu me mampea bopawa osowe waimpa. Ita bola Kanaan apanawa mo nolau dewalala segalepi. ");
INSERT INTO soq_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Tane abaia debama dialeno aupe Noa waina enawa 350 waden. ");
INSERT INTO soq_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Noa waine odena enawa ita abaia dialeno waina awodealena enawa 950 wadeno ita me bolen. ");
INSERT INTO soq_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Apana uduudu tawo osowe aia dea os winedio waie waimoie. ");
INSERT INTO soq_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Tane walama sawo apana omo wisedia deneuwe waimoia ene antone bola apuapuwa Sina bolawa bedewe waimoiena. ");
INSERT INTO soq_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Ita mo muba wawadiadiantone waienase, “Winleno awodeantate paka otamote sumoto badontopue seu wanantopuo mampe du wadata.” Ita mo epe dewantone du wadeiena ita ia bodipa mampe seu wadadomoiena du wadepidodepia baiwa. ");
INSERT INTO soq_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Ema aupe mo wane waienase, “Winleno no nuba bainimba bola debama dewasate ita du debama iwa dauma uba tampe wisepia wadata. No epe dewantate nuba ebomba debamasata ita do mai tawo osowe deaantata, dia.” ");
INSERT INTO soq_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Mo epe dewantoie waimoio Iawe God iene bola sa debama ita apana du wadeia ewamopia baiwa. ");
INSERT INTO soq_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Ita Iawe God wanase, “Apana ema dan dea baiwa aiau dea wai. Mo ema epe dewantono intalen ando ema epe dewakasantopu ita dima inseia dewasapua rua, mai dia. ");
INSERT INTO soq_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Sa baiwa winleno iate ane apana ema aia dea waie waimoia koakoamoto aiau rebalepio muba etakoantopu.” ");
INSERT INTO soq_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Sa baiwa Iawe God mo uduudu aia dea waie waimoia daberaramono tawo osowe deaantone bola sa dewasaia eiena. ");
INSERT INTO soq_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Iawe God apana uduudu aia dea waie waimoia daberaramono tawo oso deaantona baiwa bola debama sa ebowa Babel wane ituiena. ");
INSERT INTO soq_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Tane ema ipa apana dea debama ebowa Tera obampa ebou reresawa. Tera ipa Abram, Nao ita Aran mambu. Ita Aran otopa ebowa ipa Lot. ");
INSERT INTO soq_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Aran apana sanaa mamba do waimoie me mulena bolawa debama ebowa Ura tawo Kaldia bedewe bolen. ");
INSERT INTO soq_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Ita mo sape waimoie Abram Sarai naisen. Tane me wamba ebowa Nao mo wambu ompa ebowa Aran anoopa Milka naisen. Tane Milka wamba ebowa ipa Isika. ");
INSERT INTO soq_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Tane Abram manainapa Sarai aipoilena baiwa mai oto wadepia rua, dia. ");
INSERT INTO soq_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tera otopa Abram ita me tawabinawa Sarai ita do me atawa Lot Aran otopa bola debama Ura tawo Kaldia bedewe waimoia ene bola Kanaan awa antoiena. Mo antoie into bola Aran bedewe wimone wankasanton. ");
INSERT INTO soq_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Ita Tera bola debama Aran bedewe wandio enawa 205 wadedio bolen. ");
INSERT INTO soq_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Walama dea Iawe God Abram diene wanase, “Enawie tawoa, dana ita gombaa emoe ita bola ne waeuwaepo aie sape wana. ");
INSERT INTO soq_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Ita ne e dewaepo dana debamalepie uaralepi. Ita ne e dewaepo eboa debamalepi apana e saantopue wiwiraantopu ita e sau euda wadaana apana segaita. Ita e euda dewasana apana mampo. ");
INSERT INTO soq_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ita apana mida dewa euda e manawo dewasampa ne sau euda mo osouwo itupa. Ita apana mida saua kadiwa e manawo wapua ne mo matangelamopa. E eboawo apana uduudu tawo osowe waimoia ne euwana mo osouwolepi.” ");
INSERT INTO soq_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","5","Tane walama sawo Abram enawa 75 waden. Iawe God me diena rua me manainapa Sarai ita me wamba otopa Lot do bola debama Aran ene antoiena. Mo a baiwa nitu uduudu mo mampoa, pue ita do mo nolau dewala apanawa Aran bedewe waimoia do bola Kanaan bedewe anton. Ita mo Kanaan bolawa enentudenawo wimone, ");
INSERT INTO soq_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram ita me apanawa do nawane antone bola debama Sikem tampe bola More bedewe ia debama atowe saradounton. Walama sawo Kanaan apanawaida bola sa bedewe waimoie. ");
INSERT INTO soq_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Ita Iawe God Abram mampe segalene wanase, “Ne bola ema Kanaan e nosinosia wanamopa.” Sa baiwa Abram wata dewasan pue pulolempe sumpaa baiwa, ipawa Iawe God me mampe segalen. ");
INSERT INTO soq_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Ema aupe Abram alene wadi kerakera eneia bedeuwo bola debama Betel deneuwe ape wadene wain. Tane omo pamediawo Betel winede ita omo wiseidiawo sa ipa bola debama Ai winede. Sape me Iawe God wadaposisampaa watawa dewasane ita wadaposisan. ");
INSERT INTO soq_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Ita ema aupe Abram wanriasalene aleidie bola Negeb bolawa bedewe wisen. ");
INSERT INTO soq_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Tane bola Kanaan bedewe omana debamaia segaleno baiwa Abram Isibtiwa alen walama kerauda os wampia baiwa. ");
INSERT INTO soq_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Me Isibt bedewe odepia baiwaleidie manainapa Sarai diene wanase, “E i ewaewaa eudida. ");
INSERT INTO soq_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Ita Isibt apanawa e eweepue wapuase, ‘Ema apa me manainapa, ita mo ne boneapue aupe e wadeepue mampoepu.’ ");
INSERT INTO soq_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Sa baiwa mo e dieempo waase, Me weanapa ne, mo epe etapue ne mainawo dewa euda dewasapue oniadewasaneapu ita mai boneapu.” ");
INSERT INTO soq_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Ita Lot Abram warorosane aleidie ita me sipsipwa, kau ita duwa apanawa ita nolawa dewalala apeu bedewe waimoia do antoiena. ");
INSERT INTO soq_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Abram ita Lot nata pueu uarantono ita bola keraulen, sa baiwa mo awodea mai wampona rua, dia. ");
INSERT INTO soq_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Tane Abram Lot diene wanase, “No apana dea os mai diadiantata ita do nolamba dewasaia apanawa mai muba onantopu, dia. ");
INSERT INTO soq_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Sa baiwa no deaantata, tauma e eba bola ewee sonabe ita aite sape wana. Naita e wita on deneuwe aitona ne sen deneuwe anteapa. Tane e wita sen deneuwe aitona ne wita on deneuwe anteapa.” ");
INSERT INTO soq_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Ita Lot Ioadan doba nua euda bola debama Soa deneuwe ewen. Tane bola sa bedewa esa uduudulen ewaewa Iawe God iraiwa rua ba Isibt bolawa euda rua nuausan. Tane walama sawo Iawe God bola debama Sodom ita Gomora mai kadisapona, dia. ");
INSERT INTO soq_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Tane Lot alene bola Ioadan dobawa nuawa sonabene ita me apanawa do antone omo wisedia deneuwe bola wadeiena. Ita mo epe dewantone deaanton. ");
INSERT INTO soq_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Ita Abram bola Kanaan bedewe wankasalen tane Lot bola debama Sodom tampe bola isiwa wineia bedewe apewa wadene wain. ");
INSERT INTO soq_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Tane Iawe God emawe Sodom apanawa wanwanbu kadiidalen ita mo kadi rebareba daitada dewamoie waimoie. ");
INSERT INTO soq_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Tane Lot Abram ene aleno aupe Iawe God Abram diene wanase, “E mape enee eba baia bola ema uduudu ewamoa. ");
INSERT INTO soq_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Ne e ita e nosinosia do bola ema uduudu eweiana enalepo ebaala wanalepio osowe wankasaitana. ");
INSERT INTO soq_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ne e nosinosia dewamopo popokau rua uarantopu, ita mai mida e nosinosia wisiamopia rua. ");
INSERT INTO soq_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Ne bola ema eneepa, sa baiwa e bedewainta aite tawo debamalepia ita daumalepia makawa ewaa.” ");
INSERT INTO soq_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Sape Abram enenwisene alene bola debama Ibron bedewe Mamre iawa eneia tampe apewa wadene wain. Me Iawe God wadaposisampaa watawa dewasan. ");
INSERT INTO soq_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","2","Walama sawo Sina warerewa Amrapel, Elasa warerewa Ariok, Elam warerewa Kedolaoma ita Goim warerewa Tidal ona awa anton bola debama Sodom warerewa ebowa Bera, Gomora warerewa Bisa, Adma warerewa Sinaba, Seboim warerewa Simeba ita bola debama Bela ebowa da waia Soa warerewa do onantopua baiwa. ");
INSERT INTO soq_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Tane warere isiwa apanau do muriwa wimoiena ona baiwa Owa Bobopa wadi ebowa Sidin nuawa bola apuapuwa debama osowe auweiena. ");
INSERT INTO soq_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Ita ena 12 bedewe mo warere Kedolaoma atowentone waimoie. Tane ena 13 bedewe mo me dabuasane eiena. ");
INSERT INTO soq_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","6","Ena 14 bedewe Kedolaoma ita warere isiwa do insaisau deasane ona baiwa antone Repai apanawa bola debama Asterot Kanaim bedewe wanwanlala, Susi apanawa bola debama Am bedewe wanwanlala, Emi apanawa Sawet Kiriataim ita Orai apanawa wadi Sia bedeuwointa wanwanlala ita alene tawo makowa tampe El Paraim bolawa bedewe wisena do onantone aimoiena. ");
INSERT INTO soq_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Tane sape mo leutone anton bola debama En Mispat ebowa da waia Kades bedewe wimone Amalek apanawa ita do Amoriwa bolau debama Asason Tama bedewe wanwanlala do onantone aimoiena. ");
INSERT INTO soq_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Sa baiwa bola debama Sodom, Gomora, Adma, Seboim ita Bela ebowa da waia Soa warerewa nomone antone wadi nuawa apuapuwa ebowa Sidim bedewe ona baiwa imaantoiena. ");
INSERT INTO soq_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Ema baiwa Elam warerewa Kedolaoma, Goim warerewa Tidal, Sina warerewa Amrapel ita Elasa warerewa Ariok, warere ema 4 enane warere 5 do onantopua baiwa imaantoiena. ");
INSERT INTO soq_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Tane Sidim bedewe don uaraia bedewe topa dola winamoie. Sodom ita Gomora warerewa apanau do onau ieio baiwa sauwo weuwane antoie, ita isiwa don sa bedewe ainasue ieiena tane mo isiwa sawo wadi iwe antoiena. ");
INSERT INTO soq_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Ita warere uduudu 4 ona wimone Sodom ita Gomora bedewe nitu uduudu ita nana do awanamone antoiena. ");
INSERT INTO soq_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Abram wamba otopa Lot bola Sodom bedewe wandio emalawoa apanawa wimone me ita me puraiwa uduudu do otamone antoiena. ");
INSERT INTO soq_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Tane walama sawo Abram Amori apanawa Mamre iawa aimona tampe wandie. Apana dea ona ewena sawe weuwane wisene Abram Ibru apanawa dima segalena umanawa benemasan. Ita Mamre me wanamba Eskol ita Ane mo Abram do badowa sauantona ona bedewe eda sauntompa. ");
INSERT INTO soq_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Abram Lot wadane antoiena umanawa etene me apanawa me duwa bedewe muntone waimoia ita do ona dewawa waeuwamodia apanawa wisiau 318 emalawoa apanawa tanamone antone bola debama Dan bedewe enanaitudeiena. ");
INSERT INTO soq_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Tadino iwin bedewe Abram sorodiawa empuempumone ita me do antone bola sa enanabodane do onantone ita nanaumoiena. Ita isiwa tanamone bola debama Damaskas ainaboe bola Oba mampe wimone enanaitudeiena. ");
INSERT INTO soq_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Abram nitu uduudu emalawoa apanawa pointoiena ita me wamba otopa Lot do otamone leumon. Tane Lot ita me puraiwawa uduudu, ioto ita apana otene antoiena leumono wimoiena. ");
INSERT INTO soq_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Melikisedek me ipa bola debama Salem warerewa tane do me ipa God ionoidoa pirisiwa, me bured ita wain otene wisene Abram wanen. ");
INSERT INTO soq_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Ita me Abram mampe sau euda gagalowa ema epe wan, “God ionoidoa mida uba ita tawo dewamona sau euda e osoawo itupi. ");
INSERT INTO soq_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","God ionoidoa sauwa euda e osoawo itune ita muka eneeno e emalawoa apanawa nanaumoana.” Ita Abram nitu uduudu emalawoa apanawa mampo otena odawa 10 teamona bedewe dea wadene Melikisedek wanen. ");
INSERT INTO soq_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Tauma Sodom warerewa Abram diene wanase, “Ne apanana os leusae neaa, tane puraiwa sa e ebaa otamoa.” ");
INSERT INTO soq_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Ita Abram me sipoasane wanase, “Ne Iawe God ionoidoa me mida uba ita tawo dewamona mampe witana wadanaposie sauantedina. ");
INSERT INTO soq_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Ne ando mai dima da e manawo wadapa, dia. Ema epe inta e ando mai waase, ‘Ne Abram dewasano maura apanawa segalen.’ ");
INSERT INTO soq_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Ne ando mai dima da wadapa, dia. Ita dima ne apanana naiena sa os winepi. Tane ne menanedia ne sauna apanawa natadea Ane, Eskol ita Mamre sauneiena baiwa e puraiwa moa da wanamoa.” ");
INSERT INTO soq_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Ema aupe Iawe God Abram mampe auen rua bedewe segalene diene wanase, “Abram mai saitaa, ne e etea enabodawa; ita do unea debamaia winedia eneepa.” ");
INSERT INTO soq_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Tane Abram me sipoasane wanase, “Warere Iawe God, e mai oto da ne neapona, sa baiwa e une debamaia ne neaa mai saunepia rua, dia. Ne ando bonteapo aupanawo Eliesa bola debama Damaskas apanawa ne dunawo nolaledie wandia ne maurana uduudu epo me mampelepi.” ");
INSERT INTO soq_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Tane Iawe God Abram osowe diene wanase, “E mauraa mai apana sa wadepi, dia. Tane e eba otoaida segasawo maura sa uduudu e manawoa me mampelepi.” ");
INSERT INTO soq_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Ita Iawe God me diene wanase, “E pewa noe enee pisiwae uba tampe kipora ewamoe mai wisiaitaa rua, dia. Ita epe rua e nosinosia wisiasiawaia uaraia segantopu.” ");
INSERT INTO soq_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abram Iawe God sumanaiwaidalena baiwa me nuawa euleno insenase, “Abram ipa dodomanaida ne emanawo.” ");
INSERT INTO soq_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Rawiwa omo pamedio Abram itu awawalen ita iwimpa debamaia nua salalaida me golausan. ");
INSERT INTO soq_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Ema aupe Iawe God Abram mampe wanase, “Dewa ema atendewaitaa, e nosinosia bola bopawa osowe ware rua waimompe leumpa. Ita ena 400 bedewe bola apanawa mo nolau dewalala wanamopu ita do oniakadisamompa. ");
INSERT INTO soq_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Tane bola apanawa mo mai oniadewasamompaa ne mo matangelamopa. Ita do e nosinosia bola sa epue a baiwantompe nitu eubu wineia otepue do antopu. ");
INSERT INTO soq_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","16","Tane Amori apanawa tauma bola ema bedewe waimoi, mo kadiu debamalempe alempa ne mo matangelamope tanamopo bola sa epue antopu. Ita e nosinosia mai tauwadea leuntopue bola sawo wimopu, dia. Tane e nosinosia andoido muntompa bedewe mo obaampu wimopue wampu. Ita e Abram ena debamaia wanempe gulauidaite ita bo obasa euda boitawo mo dobosaepu.” ");
INSERT INTO soq_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Tane omo pameno sala iwinlene dubalena bedewe Abram moia none reresawa nata teamono wineie. Ita onta bedewe ia idia gasuwa odedie ita do siwa idie moia sawanawointa wimone antoio ewamodine. ");
INSERT INTO soq_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Ita walama sawo Iawe God saua badowa Abram diene wanase, “Tawo ema alene Isibt tawowa moa wadena ita do alene esa debama Eupirates makawa wisena uduudu sa ne e nosinosia wanamodina.” ");
INSERT INTO soq_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","21","Tane tawo ema ipa ua ebou Kena, Kenisa, Kadimoni, Itai, Perisi, Repai, Amori, Kanaan, Gigasa ita Sebusi apanawa mo tawou. ");
INSERT INTO soq_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","3","Tane Abram bola Kanaan bedewe wandio enawa 10 dialen ita me manainapa aipoiwa mai oto da wadapona, dia. Tane me nolawa dewala Isibt iwa ebowa Eiga mo do waimoie. Ita Sarai Abram diene wanase, “Iawe God mai oto da ne neapona, dia. Sa baiwa e aitee nolamba dewala iwa nata ituitane ita me bulepie oto wadepie nepio gamosapo otonawanalepi.” Ita Abram Sarai aiawa etene ruawalene Eiga wadene mampesano manainapa natawa segalen. ");
INSERT INTO soq_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Ita me Eiga nata ituntone ita me bulen. Tane me bu dauwa etene atenlene Sarai ituaisisan. ");
INSERT INTO soq_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Mape Sarai Abram diene wanase, “E dewaa baiwa ne nolana iwa wadane eneeno nata ituiten. Ita tauma me bulene etene ne nibuanede. Tane Iawe God mampe e kotua dodomanalepi ba ne kotuna dodomanalepi.” ");
INSERT INTO soq_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Me epe wadio Abram leusane wanase, “E nolaa iwa sa e atoawo wande, e dima inseiana rua dewasaa me mampe.” Mape Sarai epe etene Eiga oniakadisasan. Ita Eiga salene weuwane nambe alen. ");
INSERT INTO soq_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Tane Iawe God enseliwa Eiga sala makowa bedewe Sua bolawa bedewe inta waiwe maneu wiseidiawo donsan. ");
INSERT INTO soq_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Ita me diene wanase, “Sarai nolawa iwa, e nainta wiene ita nainta aitiana?” Me leusane wanase, “Ne onianedia iwa Sarai ene sanawo antedina.” ");
INSERT INTO soq_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Tane Iawe God enseliwa me diene wanase, “E leuite aitaa, oniaedia iwa mukawa atoweitone wanempa.” ");
INSERT INTO soq_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Ita ensel osowe me diene wanase, “Iawe God e dana dewasapio uaraia wisiasiawaia segantopu.” ");
INSERT INTO soq_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Tauma osowe me diene wanase, “E tauma bu do wainiana kerauda os otoa mona gamosaa ita me ebowa itua Ismael Iawe God nuaparea kewa eten. ");
INSERT INTO soq_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Oto sa mulepie apana suanau rua segalepi. Me apana uduudu onau enompo ita mo me onawa enompa tane do me wanamba do wanwanbu kadilempa.” ");
INSERT INTO soq_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Ema aupe dima Eiga mampe segalena asiasi Iawe God ebowa wane itune wanase, “Me mida ewanedie ateinedio os leidina emanawoido ewana.” ");
INSERT INTO soq_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Ita ema baiwa me maneu sa ebowa itune wanase, ‘Bea Laia Roi.’ Maneu ipa sa tauma aleide Kades ita Bired sawanauwo. ");
INSERT INTO soq_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Ita Eiga bulene oto mona gamosan Abram baiwa ita me ebowa Ismael wane itun. ");
INSERT INTO soq_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Tane Abram enawa 86 wadeno Eiga Ismael gamosan. ");
INSERT INTO soq_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Tane Abram enawa 99 wadeno Iawe God me mampe segalene diene wanase, “Ne ipa God Mukamukaua. E ne intanawo aitone mai pin ba wawu da bedeawo winepi, dia. ");
INSERT INTO soq_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ipawa ema baiwa ne sauana badowa e manawo itudina ita dewaepo e nosinosia uaraia segantopu.” ");
INSERT INTO soq_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abram imimpa emmisilene nitomaleidio God me diene wanase, ");
INSERT INTO soq_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Asisuitaa! Ne sauana e manawo dewasana: E ando dan daitada atanosiu segaita. ");
INSERT INTO soq_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","E dan daitada nosiu segaitaa baiwa tauma ne e eboa Abram winedia ene leusane Abraam itudina. ");
INSERT INTO soq_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ne e dewaepo nosinosia uarantopu ita do dan daitada e bedeawo segantopue warerentompa. ");
INSERT INTO soq_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Ne sauana badowaida ne ita e nosinosia do manlawo itupo winakasalepi. Tane ne, e ita e nosinosia do Godila wananteapa. ");
INSERT INTO soq_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ne Kanaan bolawa uduudu tauma osowe wainilana e ita e nosinosia do enalepa. Ita bola ema mo bolau wanalepio osowe wankasantopu ita ne mo Godiu wananteapa.” ");
INSERT INTO soq_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","God Abraam diene wanase, “Tane e ne sauana badowa wadaadoe ruawaitona ita ando e nosinosia saua sa ruawantompe waimompa. ");
INSERT INTO soq_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","E ema epe dewaite ne sauana wadaitudepi, e ita ne sawanambo. E ita e nosinosia mona uduudu ando muntompa ita mida e do wanlempa ete nonowa ideita dewasampa. ");
INSERT INTO soq_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","E ete nonowa dewawa dewasanuna sa ipa ne sauana badowa eueuwa ne ita e sawanambo ipawanasaitana. ");
INSERT INTO soq_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Ete nonowa dewawa ema e nosinosia ando ita ando muntompa dewasampa. Oto mona muntopuo walama 8 wadepio eueuwa baiwa e ete nonowa dewawa dewasaa. Dewa ema e obana mampo ita nolaa dewalala obampu tane mo mida gimaramoia obampu do mampo deawaa dewasana. ");
INSERT INTO soq_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Tane e bedelawoa muntompa ba apana mane mampe gimaramoilana ita e uduudu ete nonowa dewawa dewasanuna. Ita sa ipa ne sauana eueuwa e etela osowe winakasalepi. ");
INSERT INTO soq_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Tane apana dainea ne sauana badowa eueuwa etepa osowe mai wineipona, apana sa ne sauana badowa ainpunden ita me awowa nambe wande.” ");
INSERT INTO soq_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Ita God Abraam diene wanase, “E manainaa ebowa Sarai waiana ee Sara wana. ");
INSERT INTO soq_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ne sauna euda Sara osowe itupo ita me oto mona gamosapi e baia. Ita do me dewasapo uwa daitada inau wanalepi, ita me bedewee mo warereu segantompa.” ");
INSERT INTO soq_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abraam imimpa emmisilene nitomalene ita nuawa bedewe oi wane insenase, “Apana enawa 100 wadena ambi oto wadepi? Ita Sara enawa 90 me oto wadepia rua, ba?” ");
INSERT INTO soq_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ita me God diene wanase, “Ne menanedia e sau euda Ismael osowe ituwo waimpa.” ");
INSERT INTO soq_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Tane God wanase, “Sa dia, e manainaa Sara oto gamosapi e baia ita e me ebowa itua Aisak. Tane ne sauana me mampe ita me damba bedewe muntompa do mampo itupo akasalepi. ");
INSERT INTO soq_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Tane Ismael baiwa ne e iriria etana. Ita ne sau euda me osowe itupo obampa uaraia ita do nosinosiwa uaraia segantopu. Ita me warere uduudu 12 mambu wanalepi ita do me nosinosiwa bedewe uwa daitada segantopu. ");
INSERT INTO soq_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Tane ne sauana Aisak mampe itupa. Ande winena rua imonepi enawa bedewe Sara oto gamosapi.” ");
INSERT INTO soq_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Tane God Abraam nata gagalontone diasane aupe me ene odene alen. ");
INSERT INTO soq_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Ita walama sa deawa bedewe Abraam otopa Ismael ita mida me duwa bedewe waimoia seda gamomoia ita seda isiwa da mane mampe gimaramodia otamone alen God wana rua ete nonowa dewawa dewasaiena. ");
INSERT INTO soq_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ita Abraam enawa 99 wadeno tauma ete nonowa dewawa dewasaiena. ");
INSERT INTO soq_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Tane me otopa Ismael enawa ipa 13 waden. ");
INSERT INTO soq_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Ita mo nata walama sa dea bedewe ete nonowa dewawa dewasaiena. ");
INSERT INTO soq_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Tane seda mona uduudu, apana mona me dua bedewe wanwanlala ita nola dewalala mane mampe gimaramoia uduudu ete nonowa dewawa dewasaiena. ");
INSERT INTO soq_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Abraam Mamre iawa debama bumpe omo pola wano baiwa nosene ape nope wandio mampe Iawe God segalen. ");
INSERT INTO soq_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Me pisiwane apana natadea maida eneio ewamon. Me mo auwamopia baiwa enenwisene alene wau bumpe dunelene imimpa emmisilene namba dogo osowe itun. ");
INSERT INTO soq_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Ita me wanase, “Debamana, ne e nolaa dewala, naita e insena ne apana euda e emaawo mai ene aita. ");
INSERT INTO soq_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Mape wanlempo ne esa wadape wimpo wala mitamone ita ia ema bumpe bubuaitana. ");
INSERT INTO soq_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Ita do nana wadape wimpo nane nuala topio muka wadane tauma ala aitilanawo aitana. E ne nolaa dewalala mainawo wilena baiwa simbialepa.” Ita mo waienase, “Sa ide, dima waana rua dewasaa.” ");
INSERT INTO soq_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Tane Abraam diniwa mampe ape bede alene Sara diene wanase, “E tauwadea ene aie parawa begiwa dea winedia wade ita bured tabataba dewasae sua.” ");
INSERT INTO soq_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Ita Abraam weuwane pue laiawo mampo wisene pue sanaa euda sonabene ita nola dewala waneno bosane ita tauwadea laulalen. ");
INSERT INTO soq_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Tane Abraam pue amau sogapa ita nana ama sogapa mampe dewalala ita do moia otene wisene mo ia atowe waimoio wanamon. Ita mo nana naio rua me tampo enedie. ");
INSERT INTO soq_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Tane mo Abraam waitarasane waienase, “E manainaa Sara naepe?” Tane me sipoamone wanase, “Me ape bedewe wande.” ");
INSERT INTO soq_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Ita mo bedeuwo dea Abraam diene wanase, “Ne ulaipaida dieedina ande winena rua deawaa imonepi enawa bedewe leuntape wineapo e manainaa Sara oto mona gamosapi.” Tane Sara me adiwe ape moape enene asisuleidie. ");
INSERT INTO soq_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Sara Abraam nata gulauidanton ita do Sara mai uaboa wadeipe, diaida. ");
INSERT INTO soq_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Ita Sara meba oi wane wanase, “Ne gulaunten ita etena oaralen do badana gulauidalen. No mai etemba deasate oto wadataa rua.” ");
INSERT INTO soq_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Tane Iawe God Abraam diene wanase, “Dima baiwa Sara oi wane wanase, ‘Ne gulaunten ide oto wadapaa rua, ba?’ ");
INSERT INTO soq_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Iawe God mampe mai dewa da saiwa wineipona, dia. Ne dieene wanase, ‘Ande winena rua deawa imonepi enawa bedewe leunteape manawo wineapo manainaa oto mona gamosapi.’” ");
INSERT INTO soq_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Tane Sara sawe lagalene wanase, “Ne mai oi wapona, dia.” Ita Iawe God wanase, “Dia, e oi waana.” ");
INSERT INTO soq_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Apana natadea enane a baiwantoio Abraam eneno do antoiena into emopia baiwa. Ita mo sawana dea osowe wimone enane emau ieno bola debama Sodom eweie. ");
INSERT INTO soq_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","19","Iawe God meba wane wanase, “Abraam nosinosiwa debamalepie mukamukauaida segalepi ita me bedewee dan daitada tawo osowe waimoia osouwo sau euda itupa. Ne Abraam sonabena me obampa badowa diamopio ne intanawo dewa euda dodomana dewasampe antompa ita mo obampu bedewea deawa dewasampa. Ema mampe ne Abraam mampe sauantena dewasapa. Tauma ne dima dewasapaa baiwantedina mai Abraam emawa mowe dewasapa, dia.” ");
INSERT INTO soq_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Sa baiwa Iawe God Abraam mampe wanase, “Sodom ita Gomora apanawa kadi dewasaia umanau apana momoduntoio ne etana. ");
INSERT INTO soq_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Ne iape anteape kadi debamaleidia ewapa ulaipa ba, dia.” ");
INSERT INTO soq_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Ita sape apana nata enanawimone Sodom awa antoiena. Tane Iawe God Abraam nata sape enakasanton. ");
INSERT INTO soq_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Tane Abraam Iawe God mampelene wanase, “E apana euda ita kadiwa waimompaa awodea kadimoatuapi, ba? ");
INSERT INTO soq_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Apana eubu dodomana uduudu 50 bola sa debama bedewe waimompaa, e inseiana mo kadimoa, ba? Eulena apana ema 50 insamoe ita mai bola sa kadisaa. ");
INSERT INTO soq_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Sa ipa mai euda, apana kadiu ita eubu do mai kadimoa. Naita epe dewaita apana kadiwa dewalala saibu mo di wadapu, ipawa e dewaa dodomana ita euda dewasaiana apanawa.” ");
INSERT INTO soq_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Tane Iawe God wanase, “Ne apana 50 eubu ewamopaa emopa, mai bola sa kadisapa, mo kadiu insepadabuasapa, ipawa apana uduudu 50 eubu bola sa bedewe waimoi.” ");
INSERT INTO soq_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abraam me sipoasane wanase, “Tatana ne popokau rua diapanaida, gagalo ema diedine tane osowe wape dieepa baiwantedina. ");
INSERT INTO soq_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Tane apana 50 bedewe 5 dia ita 45 os waimompaa e bola sa uduudu kadisaa, ba?” Ita me wanase, “Ne apana eubu 45 ewamopaa bola sa mai kadisapa, dia.” ");
INSERT INTO soq_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abraam osowe waitaralene wanase, “Tane apana eubu 40 os ewamoa kadimoa, ba?” Ita me sipoasane wanase, “Ne apana eubu 40 ewamopaa mai kadimopa, dia.” ");
INSERT INTO soq_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Tane Abraam wanase, “Tatana ne mainawo mai nuaa kadilepi eneawo manawo gagalonteapa. Naita apana eubu 30 os sape ewamoa ambi dewamoa?” Ita me sipoasane wanase, “Ne apana eubu 30 ewamopaa mai kadimopa, dia.” ");
INSERT INTO soq_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ita Abraam wanase, “Ne e manawo malasia badowa gagalontedina, naita apana eubu 20 ewamoa ambi dewamoa?” Ita me sipoasane wanase, “Ne apana eubu 20 ewamopaa mai kadimopa, dia.” ");
INSERT INTO soq_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Tane Abraam wanase, “Tatana ne mainawo mai nuaa kadilepi eneawo osowe gagalona ompa wape dieepa. Naita apana eubu 10 os ewamoa ambi dewamoa?” Ita me sipoasane wanase, “Ne apana eubu 10 ewamopaa ne mai kadimopa, dia.” ");
INSERT INTO soq_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Iawe God Abraam mampe gagalolene diasane ene aleno ita Abraam ene bolawe alen. ");
INSERT INTO soq_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Tane ensel nata Abraam ene antoia rawileidio Sodomwa wimoiena ita Lot bola debama gonaawa moape wandie ewamon. Ita me enenwisene mampo alene wau bumpe dunelene imimpa emmisilene auwamon. ");
INSERT INTO soq_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Ita me wanase, “Debamana, e winleno ane wala mitamone ne dunawo wanlempo baila simbiantapa ita wanlempe ituitana. Imonemba tadina bedewe enanawilene ita naepe aitilanawo aitana.” Tane mo waienase, “Dia, no ane bola debama bedewe bola da donsata tadina ema baiwa.” ");
INSERT INTO soq_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Tane Lot badowa iririmodio baiwa awodea antoiena me duwa bedewe. Ita sape mo baibu bured mai ist dola sune ita nana isiwa do imaasane wadene wisene wanamono naiena. ");
INSERT INTO soq_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Mo nana nane diasane ando ituntopona bola debama Sodom apanawa mona uduudu apana sanaa ita gulaubu wimone Lot duwa enanabodeiena. ");
INSERT INTO soq_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Ita mo Lot diane waienase, “Apana sa nata tadino e manawo wimoiena naepe? E mo waaubamowo nomopu ita no mo ninamotaa menanede.” ");
INSERT INTO soq_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Mo epe waio Lot enene du moape noseidie baiwa du moawa adiwe gudulen. ");
INSERT INTO soq_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Ita wanase, “Sosona apana ema mampo dewa kadiwa mai dewasana. ");
INSERT INTO soq_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Asisuitana, ne obaina iwoa nata mai apana do itula waimoi. Ne mo waaubamopo nomopuo ita e dima menaledia rua mampo dewasana. Tane apana ema nata dunawo waimoio oniamodina mai kadiwa mampo dewasana.” ");
INSERT INTO soq_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Tane mo sipoasane waienase, “E nambe aitaa, e mai bola ema apanawa di debamaitie itupositie gagaloneiana. Sa baiwa poka dauwa mo etapona e osoawolepio etaidasaa.” Mo epe wane ita mukama odane Lot epanaaubene ita du moawa epapakewapona baiwantoie. ");
INSERT INTO soq_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Tane ensel nata du bedewe waimoia Lot wadane teineieno duwa mampo odeno ita du moa guduntoiena. ");
INSERT INTO soq_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Tane mo apana uduudu pewa eneia dewamoieno emau potaleno du moa ewasiantoiena. ");
INSERT INTO soq_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","13","Mape apana nata Lot diane waienase, “No bola ema kadisataa baiwantitana. Iawe God mo wawubu gagalowa etedie no waaubaneno mape winena bola ema kadisata. Bola ema bedewe e sosoa da waimoi ba, dia? E obana mona ita iwoa mo babadau do tane e sosoa isiwa bola ema bedewe waimompa otamoe bola ema enaiana.” ");
INSERT INTO soq_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Ita Lot gagalo ema etene alene obampa iwoa babadau diamone wanase, “Iawe God bola ema kadisapia baiwaleide tauwadea bola ema ena.” Tane mo etane inseienase me wasileide. ");
INSERT INTO soq_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Imonemba walama sapa wapia baiwaleidio ensel Lot diane waienase, “Iawe God bola ema kadisampe e do kadilepia sawa tauwadea enee manainaa, obana iwoa nata do wainilana otamoe aitana.” ");
INSERT INTO soq_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Tane me aia ema etene mai diniwalepona, dia. Iawe God menasana Lot inasapi sa baiwa ensel enane Lot, manainapa ita me obampa iwoa do witapo teinamone nomone bola debama ene antoiena. ");
INSERT INTO soq_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ita mo banlamone bola sa adiwe nomone diamone waienase, “Salawo weuwane aitane inaitana! Tane aitonune mai leusaewaitana ba into waina ideita wadiwa wilena boitana sawa.” ");
INSERT INTO soq_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Tane Lot mo sipoamone wanase, “Sosona eiau kerauda os onianeana. ");
INSERT INTO soq_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","E ne mainawo euda dewasale ita inanealana. Tauma ne mai diniwa mampe weuwape wadiwa anteapaa rua kadi doinepio bonteapa sawa. ");
INSERT INTO soq_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Ewee; e ne eneano bola sisi kerauda maida winedia bedewe tauwadea anteape inanteapa.” ");
INSERT INTO soq_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Ita me sipoasane wanase, “Euda, dima e waana baiwa ne aiaa ruantape bola sa mai kadisapa.” ");
INSERT INTO soq_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Tane Lot ita obampa do antone bola debama Soa bedewe wimoio omo wisen. ");
INSERT INTO soq_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Tane Iawe God seu imoie moniantoia ia idia do uboe wanaubeno bola debamau Sodom ita Gomora osouwo unu rua iene ituiamon. ");
INSERT INTO soq_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Ita Iawe God bola debamau nata, apu debamawa ita do apana uduudu bola sa bedewe waimoia ita nitu uduudu dogo osowe inintoia uduudu kadimontuwan. ");
INSERT INTO soq_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Tane Lot manainapa leusaewa mampe matangela osowe ieno aideba wanalene enakasalen. ");
INSERT INTO soq_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Abraam tadina bedewe enenwisene naepe bauta Iawe God nata enane gagalontoiawo alen. ");
INSERT INTO soq_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Ita me sape enene emawa ieno Sodom ita Gomora bolawa uduudu ita doba nuawa bedewainta ia idia gasuwa debamaia oro iawa sumpo gasua odompa rua ewedie. ");
INSERT INTO soq_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Tane God bola sa debama kadisadie Abraam insen. Tane me Lot bola sa bedewe wandio wanaubeno aleno aupe me bola sa kadisan. ");
INSERT INTO soq_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Tane Lot bola Soa apanawa saulena baiwa anoanopa nata banlamone wadiwa odene alene guba bedewe waimoie. ");
INSERT INTO soq_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Ita mo sape waimoie me anoopa tautuwa wamba diene wanase, “No bola ema wainitana bedewe mai apana da waimoipona ita naimota, do no mamamba aitamana gulaulepia baiwaleide. Me gulaulepia ando oto mai segasapia rua. ");
INSERT INTO soq_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Sa baiwa no wain mamamba wanato napie uwawa koakoalepio do ituntate ita me asiasi sedamba gamomote dainimba debamasata.” ");
INSERT INTO soq_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Ita tadina sawo mo mambu wain waneieno nane uwawa koakoalene ituleidio anoopa tautuwa bauta odene me itusan ita mamba anoopa dauwa mai etapona, dia. ");
INSERT INTO soq_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Tane imonemba i tautuwa wamba diene wanase, “Tadino ne mamana itusana, sa baiwa ande tadina mamamba wain wanato napie uwawa koakoalepie itulempo e ode itusaa. Ita inta ema inta no dainimba dialepia baiwaleidia debamasata.” ");
INSERT INTO soq_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Ita mo waiena rua tadina sawo mo mambu wain waneieno nane uwawa koakoalene ituleidio anoopa kerauwa odene itusan. Ita bauta anoopa tautuwa mampe segalena rua deawa kerauwa mamba itusadio dauwa mai etapona, dia. ");
INSERT INTO soq_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Ita mo epe dewantone mambu asiasi bunton. ");
INSERT INTO soq_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Tane i tautuwa gamolene otopa ebowa itune wana Moab. Me ipa Moab apanawa nosiu. ");
INSERT INTO soq_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Ita kerauwa gamolene otopa ebowa itune wanase, Ben Ami. Me ipa apana ebou Amoniwa nosiu. ");
INSERT INTO soq_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Tauma Iawe God saualena rua Sara mampe euda dewasano oto mona waden. ");
INSERT INTO soq_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Abraam gulauidalene wandio God walama ituna rua osowe Sara bulene ita otopa mona gamosan. ");
INSERT INTO soq_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ita oto sa muleno Abraam otopa ebowa Aisak wane itun. ");
INSERT INTO soq_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Tane me mulene wandio walama 8 dialeno, God Abraam mapo diena rua eueuwa baiwa etepa osowe ete nonowa dewawa dewasan. ");
INSERT INTO soq_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Tane Abraam wandio enawa 100 wadeno Aisak mulen. ");
INSERT INTO soq_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Tane Sara wanase, “God nuaeu wadene mainawosan ita apana uara umanana etapue wimopuo ne do nuaeuntata.” ");
INSERT INTO soq_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Ita me osowe wane wanase, “Mai mida da mapo Abraam diape waponase, e manaina ando oto gamolepi e baia ita tauma me gulauidaleno ne oto wadana.” ");
INSERT INTO soq_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Tane oto Aisak mulene ama nanawa ena walamawe Abraam me odawa debama dewasan. ");
INSERT INTO soq_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Ita mo waimoie Ismael Aisak nata owantoie sowa ituaisisadio Sara ewamon. Tane Ismael me ipa Abraam otopa Isibt iwa nolau dewalala Eiga gamosana. ");
INSERT INTO soq_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Ita Sara Abraam diene wanase, “E i ema otopa nata waaubamowo antopu, ne mai menaneipona e boitawo aupaawo dewa da e manawoa me mampelepio wadepi.” ");
INSERT INTO soq_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Abraam aia ema etene nuabolalen. Ipawa Ismael ipa me otopa. ");
INSERT INTO soq_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","God Abraam diene wanase, “E nolaa dewalala Eiga otopa nata mai nuabolauitaa. E dana umanawa ne sauaena ando Aisak bedewe segalepi. Sa baiwa Sara dima wana ruawaita. ");
INSERT INTO soq_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Tane nola dewalala iwa oto wadena ipa e otoa, ando ne me dewasapo damba debamalepi ita do uwa dea segalepi.” ");
INSERT INTO soq_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Tane imonemba tadinaida Abraam enenwisene nana ita esa dugiwa, pue etepa mampe dewasaiena bedewe esa utene wadene Eiga otopa nata wanamone waaubamono antoiena. Tane Eiga otopa nata antoie into bola Beasiba sala makowa bedewe koantone lakasanton. ");
INSERT INTO soq_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Ita mo esa naieno dialeno baiwa me oto wadenaisie ia golaupe itune en. ");
INSERT INTO soq_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Tane me seu aubeio aleidie enediitudedia makawa rua waine insediase, “Ne mai oto ewepino emanawo bolepi.” Ita waine ke wadie. ");
INSERT INTO soq_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Ita oto itulene ke wadio God eten, sa baiwa me enseliwa Eiga diene wanase, “Eiga dima kadilen? Mai saitaa God otoa kewa eten. ");
INSERT INTO soq_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","E aite oto wadaaposie witape wadee banle aitaa, ne me dewasapo damba debamalepi.” ");
INSERT INTO soq_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Mape God Eiga emawa wadenaubeno esa ewen ita alene dugiwa mampe esa utene oto waneno nan. ");
INSERT INTO soq_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Tane oto sa muleidio rua God ipa me do ita me e mampe waenlempa apanawa segalen. ");
INSERT INTO soq_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Ita me Paran sala makowa bedewe wandio me inawa alene Isibt iwa wadene wisene otopa wanen. ");
INSERT INTO soq_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Tane ema aupe mo waimoio ena isiwa diantono God Abraam sumanaiwa wadaetasapia baiwa apasane wanase, “Abraam!” Abraam sipoasane wanase, “Oa, ne ema.” ");
INSERT INTO soq_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Ita God me diene wanase, “E otoa deaida Aisak nuawadawadasaiana banlee aita bola Moraia bedewe. Sape ne wadi euwaepo iwa osowe otoa bosae puloite sua.” ");
INSERT INTO soq_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ita imonemba tadinaida Abraam enenwisene donki imaasan ita ia tonapa isuen pulo itupie supia baiwa ita otene pue donki osowe itune ita me otopa Aisak banlene nolawa apanawa nata do antoiena bola God dienawo. ");
INSERT INTO soq_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Mo antoio walama natadea dialeno Abraam pisiwane bola sa awa antoia nowadawo ewen. ");
INSERT INTO soq_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Ita sape me nolawa apanawa diamone wanase, “E mape pue donki do wanlempo ne otona nata sisi ane God wadaposisate ete leuntate winta.” ");
INSERT INTO soq_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ita Abraam ia dimbua wadenposie otopa awanape ituno awanen tane me ia emawa ita isima do oteno antoiena. ");
INSERT INTO soq_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Mo antoie into Aisak mamba waitarasane wanase, “Mako!” Ita Abraam wanase, “Otona asisuedina wawo etapo.” Aisak wanase, “Ia tonapa ita ia emawa mape winei tane pulontata moiawa bunawa naepe?” ");
INSERT INTO soq_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraam sipoasane wanase, “Otona, God ando pulontata moiawa imaasapie nenepi.” Me epe wane ita mo antoiawo awodea antoiena. ");
INSERT INTO soq_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Mo antoie bola sa umanawa God wanawo wimone Abraam pulolepia watawa dewasane osowe ia teamon. Ita me otopa Aisak wadenitue witapa ita wawa taumone ia tonapa auwene teamona osowe itun. ");
INSERT INTO soq_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Ita me isima wadene otopa empabolepona baiwaleidie. ");
INSERT INTO soq_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Tane Iawe God enseliwa uboe diene wanase, “Abraam, Abraam!” Ita Abraam sipoasane wanase, “Oa, ne ema.” ");
INSERT INTO soq_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Ita Iawe God enseliwa me diene wanase, “Mai witaa oto osowe itua ba dewa da kadiwa me mampe dewasa, dia. Tauma ne atenten e God sawaitiana, sa baiwa e otoa deaida mai anatepona, dia.” ");
INSERT INTO soq_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ita Abraam pisiwane pue sip donawa ia bagoreno enedio ewen. Ita me otopa pulolepona ene alene pue sa bosane God mampe pulowa itune sun. ");
INSERT INTO soq_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Sa baiwa Abraam bola sa ebowa ituna Iawe Iaira amona mamba. Walama sawo odene ita tauma apana wampase, “Iawe God wadiwa osowe me amonalepie nenepi.” ");
INSERT INTO soq_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Tane Iawe God enseliwa uboe osowesane ema epe Abraam dien, ");
INSERT INTO soq_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“Iawe God wanase, ‘E ne aiana etee ruaitene otoa mai anatepona baiwa ne sauana badowa neba ebonawo itudina, ");
INSERT INTO soq_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ne sauna euda e osoawo itupe dewaepo dana uarantopu uba tampe kipora wisiasiawaia rua ita do owa nelawa rua segantopu. Ita mo emalawoau apanawa do onantopue otepue mampomopu. ");
INSERT INTO soq_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Ita e nosinosia bedeuwoe apana uduudu tawo oso waimoia sau euda osouwo itupa, ipawa e ne aiana ruawaitena baiwa.’” ");
INSERT INTO soq_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Ema aupe Abraam otopa nata antone nolawa apanawa mampo wimone ita awodea anton bola debama Beasibawo ita sape Abraam wankasalen. ");
INSERT INTO soq_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Tane Abraam gulauidalene enawa debamaia diasan. Ita Iawe God me mai epona, dewa uduudu dewamodia bedewe euda os segantoie. ");
INSERT INTO soq_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Ita me nolawa dewalala uwauleidia apanawa me duwa bedewe wandia diene wanase, “Witaa ne abuna atowe itua. ");
INSERT INTO soq_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Ita ne menanedia e saua badowa dewasa Iawe God, me mida uba ita tawo dewamona Godiwa mampe. Ita ando e mai ne otona baiwa bola ema Kanaan bedewe ne wainedinawo i da wadaa, dia. ");
INSERT INTO soq_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Tane e aie neida bolanawo gombanaida bedeuwo otona Aisak baiwa i da ewee sonabea.” ");
INSERT INTO soq_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Mape nola dewalala me waitarasane wanase, “Naita i sa ne nata mape wimwimba dabualempo ambi dewanteapa, e inseiana ne leuntape wineape e otoa Aisak banlepe nata antata, ba?” ");
INSERT INTO soq_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ita Abraam wanase, “Ne otona mai banle bola sawo aita, dia.” ");
INSERT INTO soq_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Ita me wanase, “Iawe, God uboo wanwanlala me mida ne gombana ita baida sosona do wainitano banlanene mape wisena, me saua badowa dianene wanase, ‘Ne ando tawo ema e nosinosia wanamopa.’ God ipa sa enseliwa wapiaubepio bautalepie alepi. Sa baiwa e aite ne otona iwa banle winea. ");
INSERT INTO soq_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Naita i sa mai e nata leuitane wilena menasampa, saua sa e ne mainawo dewasaana mai ingugurawaita, dia. Tane ne otona mai banle bola sawo aitaa, dia.” ");
INSERT INTO soq_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Sa baiwa nola dewalala me oniedia apanawa Abraam abupa otowe witapa itune ita saua badowa dewasana nola sa dewasapi. ");
INSERT INTO soq_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Ema aupe me a baiwaleidie me oniedia apanawa puewa kamel uduudu 10 otene mampemone osouwo puraiwa uwataubu eubuida otene teene ita enenwisene alen. Tane me a baiwalene Mesopotamia bolawa intawa asiasi alene bola debama na epe Nao wandia bedewe wisen. ");
INSERT INTO soq_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Ita me bola sa mampelene ita esa sagala tampe wisene pue kamel dewamono aisintone waimoiena. Ipawa rawiwa ioto wimoie sape esa utei. ");
INSERT INTO soq_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Ita me sape waine rauparilene wanase, “O Iawe God, ne onianedia apanawa Abraam Godiwa, tauma e ne saunea ita dima awa winena ipawanalepi, ita e euwaa Abraam osowe itua. ");
INSERT INTO soq_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Tauma ne ema ambi esa tampe enedina ita bola ema debama iotopa sanaau esa utautawa ando mape wimopu. ");
INSERT INTO soq_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Ita ne mo bedeuwo dea diape wapaase, ‘Rua ba dia, e esa utee ne neawo napa.’ Tane me wapiase, ‘Oa, ne dewasapa ita do puea kamel esa wanamopa.’ Epe segalepia, me ipa sa e sonabeana e nolaa dewalala Aisak baiwa. Ema epe mampe ne atenteapa e dewa euda ne onianedia apanawa mampe dewasaana.” ");
INSERT INTO soq_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Tane me andomana rauparileidio Rebeka esa dugiwa awanape awanene wisen. Ita i sa ipa Abraam wamba Nao manainapa Milka otopa ebowa Betuel anoopa. ");
INSERT INTO soq_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Ita Rebeka i sanaa eudida mai apana do itula, dia. Me iene alene esa utene ita leulene wisen. ");
INSERT INTO soq_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Tane nola dewalala weuwane alene i sa diene wanase, “Rua ba dia, e esa dugia bedewe winedia neawo napa?” ");
INSERT INTO soq_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ita i sa leusane wanase, “E esa naa rua.” Me epe wane ita esa dugiwa awanedia wadenaisidene ita esa memene waneno nan. ");
INSERT INTO soq_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Tane me esa nano dialeno aupe i sa wanase, “E puea kamel do ne esa utape wanamopo napue pokamopio tauma epa.” ");
INSERT INTO soq_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Ita me epe wane, pue esa naia laukaibu bedewe esa memeno naiena. Ita me osoweosowe esa utedie kamel wanamodio naie pokamono tauma en. ");
INSERT INTO soq_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Tane nola dewalala daina waine emosadie insediase, “Iawe God dauwa ne ana ema ipawanasade.” ");
INSERT INTO soq_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ita kamel esa naieno dialeno aupe me rin baidauwo seuseulala gold mampe dewalala uwatauwa ita do asama nata gold mampe dewalala malesawa debamaia, ita nitu ema nata uwataubuida otawialene wanen. ");
INSERT INTO soq_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Ita ema aupe me i sa waitarasane wanase, “Wawo etapo, e mida anoopa, e mamaa duwa bedewe itu bolawa da winede ba dia, ita ne sosona do ituntepona?” ");
INSERT INTO soq_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Nola dewalala epe waitaraleidio me sipoasane wanase, “Ne mamana ebowa ipa Betuel ita atana mona ebowa ipa Nao, ita iwoa ebowa Milka.” ");
INSERT INTO soq_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Tane do wane wanase, “No mainimbo kamel nanau ita do ina osowe ituntompa bolawa winede ita ware ituntompa bolawa do winede.” ");
INSERT INTO soq_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Ita nola dewalala Rebeka gagaloleno etene dogo osowe imimpa emisilene dunelene Iawe God wadaposisadie ");
INSERT INTO soq_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","wanase, “Iawe God ne debamana Abraam Godiwa wadaposisadina, ipawa e ne debamana Abraam mai nuaawawasape sauwa epona, dia. Sa baiwa e ne banlaneano dodomana ne debamana baida sosowaida mampo winen.” ");
INSERT INTO soq_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Tane ema aupe Rebeka weuwane alene mida me duwa bedewe waimoia dima me mampe segalena umanawa diamono eteiena. ");
INSERT INTO soq_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Ita Rebeka nopa ebowa Leiban sape wandie weanapa witape rin baidauwo seuseulala ita asama wineio ewamon. Ita do me dima ewena gagalowaleidio etene enenwisene weuwane alen esa uteia bolawe, naepe apana puewa kamel do eneiawo. Ita Leiban Abraam nolawa dewalala diene wanase, ");
INSERT INTO soq_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","“Iawe God sau euda e osoawo ituna apanawa e winewo ane no do wainenta, dima baiwa mape eneiana? Ipawa no aitamana e itua bolawa ita do pue kamel bolau imamotano winei.” ");
INSERT INTO soq_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Ema aupe, apana sa Leiban nata anton me duwe ita Leiban kamel osouwo puraiwa otawiamone aupe kamel bolau osowe ina teamoienawo wadaaisimoieno waimoiena. Tane sape mo nana wanamoieno naiena. Do me esa imasan Abraam nolawa dewalala sosowa do wau mitamopua baiwa. ");
INSERT INTO soq_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Tauma mo nana epentone wanamoiena napua baiwa. Tane Abraam nolawa dewalala wanase, “Ne mai nana da napa, dia. Tane bauta ne dima awa winena dieepo etaa.” Tane Leiban leusane wanase, “Sa ide, dima awa wiena wawo etata.” ");
INSERT INTO soq_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ita me gagalolene wanase, “Ne ipa Abraam nolawa dewalala winen. ");
INSERT INTO soq_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Iawe God sauwa debama ne debamana osowe ituno apana eboeboua segalen. Ita do dewasano pue sipsip, kau, silwa ita gold, do nola dewalala uwara mona ita iwoa, kamel ita donki osouwo mauraidalen. ");
INSERT INTO soq_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Ita ne debamana manainapa Sara gulaulene wandie oto gamosan me baiwa. Tane nitu uduudu me mampea otopa sa wanentuwano me mebaawawanalen. ");
INSERT INTO soq_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Tane debamana dianeno mampe sauantena ne ideita me otopa manainapa, me mamba bolawa iwa da donsape wanapo naisepi. Me mai bola Kanaan iwa da naisepi, dia. ");
INSERT INTO soq_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Sa baiwa ne waaubaneno me bolawa ema bedewe winen, ita me dianena i me mamba damba bedewe donsape banlepe anteape otopa wanapo naisepi. ");
INSERT INTO soq_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Ita ne me waitarasane wanase, ‘Naita i da donsape nata mape wimwimba dabualempo, ambi dewanteapa?’ ");
INSERT INTO soq_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Tane me ne wasaunene wanase, ‘Dima ne diena, ideita segalepi, ipawa Iawe God mida onianedio wainedine leidina enseliwa wapiaubepio e tanawolepie sauepio dima awa aitiana ipawanalepi. Sa baiwa e ideita ne dainaida mamana sosowaida bedeuwo aite i da donsaa, ne otona baiwa. ");
INSERT INTO soq_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Ita naita e ne baida sosona mampo aitee gagaloitone mai i da donsaa, sa ipa e saua sa dewasaana mai ingugurawaitaa, dia.’ ");
INSERT INTO soq_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Sa baiwa ne aita esa uteia bolawe winene enane rauparintene wanase, “O Iawe God, ne debamana Abraam Godiwa, naita ne dima awa winena sauneawo ipawanalepia sa ipa inta dainea euda e eba atena asiasi banlanea. ");
INSERT INTO soq_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Tauma ne ema ambi esa tampe enedina ita ioto sanaau bedeuwo dea da esa utautawa wisepio ne diape wapase, ‘I, e esa utee neawo napa rua ba, dia?’ ");
INSERT INTO soq_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Ita me leusapie wapiase, ‘Oa, ne esa eneepa, ita do kamel esa wanamopa, epe segalepia, me ipa sa Iawe God sonabeana ne debamana otopa baiwa. ");
INSERT INTO soq_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Ne epe rauparitene diasane enedino, Rebeka esa utautawa dugiwa awanene iedio ewana. Me iene alene esa utedio ewane iririsane wanase, ‘I, esa ute neawo napaa rua ba, dia?’ ");
INSERT INTO soq_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Ita me tauwadea os esa dugiwa awanedia wadenaisie itune ita wanase, “E esa ema naa, ita ne esa nana ita do me pue kamel esa wanamon. ");
INSERT INTO soq_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Ita ne me waitarasane wanase, ‘E mida anoopa?’ Me leusane wanase, ‘Ne Betuel anoopa, me ipa Milka gamosana Nao otopa.’ Ita me epe wano ne etane rin baidawe seuna ita asama witape aimona. ");
INSERT INTO soq_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Tane sape ne imina emmisintene Iawe God wadaposisana. Me ipa ne debamana Abraam Godiwa. Me inta ruawalene banladewasanene debamana baida sosowa mampo winen, me otopa manainapa mo atau banlepe anteapa. ");
INSERT INTO soq_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Tauma ne debamana baiwa e euwaa dewasaa ba dia, naita diaa, dianeawo etape tauma ne ambi dewanteapa?” ");
INSERT INTO soq_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Tane Leiban ita Betuel me sipoasane waienase, “Ema ipa Iawe God insaisawa rua, no mai dima wataa rua, dia. ");
INSERT INTO soq_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","E Rebeka banlee aitaa, e debamaa otopa manainapa. Iawe God banlaeno wien.” ");
INSERT INTO soq_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ita Abraam nolawa dewalala mo epe waieno etene, imimpa emmisilene dunelene Iawe God wadaposisan. ");
INSERT INTO soq_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Tane sape nola dewalala gold, silwa kibokiborala ita gara eubuida otaaubalene Rebeka wanen, ita amona isiwa eubu do otawialene me nopa ita inawa wanamon. ");
INSERT INTO soq_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Ita apana mida me do antoiena tadina sawo nana debama mo dewasaieno nane ituntoiena. Tane imonemba tadinaida enana wimone nola dewalala wanase, “Ne waubaneano debamana mampe anteapa menanede.” ");
INSERT INTO soq_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Me epe wadio, i nopa ita inawa waienase, “I ewo no do walama 10 wante, tauma aita.” ");
INSERT INTO soq_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Me mo sipoamone wanase, “E mai ne wadaituneana, Iawe God ne ana ema ipawanasano euwa ewana baiwa waaubaneano debamana mampe anteapa.” ");
INSERT INTO soq_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Tane mo waienase, “No i diato wimpie meba wapio etata, ambi wapi.” ");
INSERT INTO soq_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Ita mo Rebeka dieieno wiseno diane waienase, “E apana ema nata aitana, ba?” Ita me wanase, “Oa, ne anteapa menanede.” ");
INSERT INTO soq_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Mape mo weanapu Rebeka wanaaubeieno me taurabasana iwa, Abraam nolawa dewalala ita me sosowa do antoiena. ");
INSERT INTO soq_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Tauma mo Rebeka osowe sau euda itune diane waienase, “No weanamba e aitiana otootoitee uarakaditaa, mo uaraia inau segaita ita e bedeawoa wenawenau nanaumopue aimopu.” ");
INSERT INTO soq_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Ema aupe Rebeka ita nolawa iotopa sanaau pue kamel osowe odane ita apana sa ita nola dewalala do antoiena. ");
INSERT INTO soq_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Tane Aisak Negeb bolawa bedewe wandie ene Bea Laia Roi bedewe leidie leulene wisen. ");
INSERT INTO soq_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Ita rawi dea me pewa nosene alene leidie insaisaleidie tane pisiwane pue kamel me mampe ieio ewamon. ");
INSERT INTO soq_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Tane mo antoio Rebeka do Aisak odedio ewene kamel osowe wandia ene nosene nola dewalala diene wanase, ");
INSERT INTO soq_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","“Sisi mida iede?” Ita me diene wanase, “Me ne debamana Aisak iede.” Ita Rebeka gara wadene namba boden. ");
INSERT INTO soq_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Tane mo Aisak mampe wimone nola dewalala dewa uduudu dewasana benemawa me dieno eten. ");
INSERT INTO soq_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Ita Aisak i banlene duwa alen mapo Sara wandia aupe. Ita Aisak Rebeka naisene nuawadawadasadie. Tane Aisak inawa Sara boleno aupe Rebeka me sausane onien. ");
INSERT INTO soq_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Abraam otopa Aisak me obaampa do gagalou ema epe. Aisak mamba ipa Abraam, ");
INSERT INTO soq_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Aisak enawa 40 wadeno Rebeka naisen. Me ipa Betuel anoopa ita do Leiban weanapa, mo ipa Aram apanawa bola Padan Aram bedewe waimoie. ");
INSERT INTO soq_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Rebeka aipoileno baiwa Aisak rauparilen Iawe God mampe sausapono bulepona. Ita Iawe God me raupariwa etene sausano bulen. ");
INSERT INTO soq_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Tane seda sa inau bupa bedewe tepaidantoio etene Iawe God diene wanase, “Dima baiwa ema epe segaleide?” ");
INSERT INTO soq_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Ita Iawe God me diene wanase, “Seda nata e buawo waimoia ando dan uwa nata segantopu. E gamoitawo apana uwa nata segantopue ona maempa. Da kasawogalepie sowa da ituaisisampa, ita oto tautuwa enepie wamba simbiasampe nolawa dewasampa.” ");
INSERT INTO soq_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Tane Rebeka gamoa walama wiseno me seda mona nata gamomon. ");
INSERT INTO soq_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Oto tautuwa mulena etepa buma osiosinaua ita etepa imbuimbua sa baiwa me ebowa Esau ituiena. ");
INSERT INTO soq_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Tane oto da muleidie tatawa wawa kampa wadedie do mulen, sa baiwa me ebowa ituiena, Iakob. Aisak enawa 60 wadeno me manainapa seda sa nata gamomon. ");
INSERT INTO soq_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Seda sa nata muntone debamantone ita Esau waen apanawaida segalen. Tane Iakob me apana daina duwa os wanwanla. ");
INSERT INTO soq_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Ita Aisak dewawa ipa nana moia do napi, sa baiwa me Esau nuawadawadasan, tane Rebeka otopa Iakob nuawadawadasan. ");
INSERT INTO soq_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Walama dea Iakob nanawa nuleidie wandio Esau dobino leidie omana tono etepa garigarileno wisen. ");
INSERT INTO soq_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Sa baiwa me Iakob diene wanase, “Ne omanaida tonen, nana sa bumawa nuitiana toe neawo napa.” Me epe wana baiwa ebowa wane ituiena Edom. ");
INSERT INTO soq_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Ita Iakob wanase, “E oto tautuwa ando nitu uduudu mamamba epio aupawe e wadaa. Tane e nitu sa uduudu ewo ne mainawolepituwapia umanawa wawo etape tauma sipoa nana eneepo naa.” ");
INSERT INTO soq_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Ita Esau sipoasane wanase, “Ne omana toidanen bonteapa dauwa etedina, e ne aupana wadee nitu sa otea.” ");
INSERT INTO soq_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Tane Iakob wanase, “E oto tautuwa aupaa ne wadapa sauawa tauma dianeawo etapaa menanede.” Ita Esau wamba badowa sauasana me aupawa wadepie nitu uduudu otamopi. ");
INSERT INTO soq_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Tauma Iakob bini bumawa epelene bured dosane Esau waneno nane ita ene alen. Esau mai nitu da me mampea wadaituwa insepona, dia. ");
INSERT INTO soq_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Omana debamaia Kanaan bolawa bedewe segalen mapo Abraam walamawe segalena rua. Sa baiwa Aisak alen bola debama Gera bedewe Pilistan warerewa Abimelek mampe. ");
INSERT INTO soq_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Tane Iawe God Aisak mampe segalene wanase, “E Isibt bedewe mai iee aitaa, tane mape wanempo ne wapo rua aita. ");
INSERT INTO soq_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","E mape wanempa ita ne ipa e do ita sau euda osoawo itupe oniaepina. Tane e nosinosia do tawo ema uduudu enalepa ita ema bedewe mamaa Abraam mampe saua badowa wana ipawanasapa. ");
INSERT INTO soq_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ita ne e dewaepo dana uarantopu uba tampe kipora wisiasiawaia rua ita do tawo ema uduudu wanamopa. E nosinosia bedeuwoe uwa daitada apanawa sau euda donsampa. ");
INSERT INTO soq_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Ipawa Abraam ne aiana asisusan ita waeuwana etene ita do anaanana uduudu ruawalen.” ");
INSERT INTO soq_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Sape Aisak bola debama Gera bedewe wankasalen. ");
INSERT INTO soq_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Aisak Iakob umanawa wano mampe wiseno sau euda osowe itune diene wanase, “Otona, ne mai menaneipona e bola Kanaan iwa da naisea, dia. ");
INSERT INTO soq_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Sa baiwa ne e waaubaedina aita inaa mamba Betuel bolawa Padan Aram bedewe ita sape inaa nopa ebowa Leiban anoopa da naisea. ");
INSERT INTO soq_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Ita God Mukamukaua sauwa euda osoawosapio otootoite uaraita ita do nosinosia uarantopue tawo uduudu nopesapu. Tane e uwa daitada apanawa mambu wanaita. ");
INSERT INTO soq_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Iawe God sau euda Abraam osowe ituna rua deawaa e ita e bedeawoa do sau euda donsampa. Ita God Abraam dima uduudu sauasana rua e manawolepituwapio ita bola e osowe ware rua wainiana e ebaa wanalepi.” ");
INSERT INTO soq_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Tane Aisak otopa Iakob wanaubeno bola Padan Aram bedewe Betuel Aram apanawa otopa Leiban, sa ipa Rebeka nopa mampe alen. ");
INSERT INTO soq_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Ita Aisak sau euda Iakob osowe itune wanaubeno bola Padan Aram bedewe alen, sape i da donsapie naisepia baiwa ita do badowa anaanasana bola Kanaan iwa da mai naisepi, dia. Tane ema umanawa Esau etene atenlen. ");
INSERT INTO soq_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Tane do me atenlen Iakob gombawa aiau etene ruawalene bola Padan Aram bedewe alen. ");
INSERT INTO soq_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Tauma Esau insaisawa wadenaubeno atenlen me mamba Aisak Kanaan iotopa dabuamode. ");
INSERT INTO soq_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Sa baiwa me alene osowe nainailen Abraam otopa Ismael anoopa ebowa Maalat, me ipa Nebaiot weanapa naisen. ");
INSERT INTO soq_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Iakob bola debama Beasiba ene Araniwa aleidie, ");
INSERT INTO soq_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","ita omo pamedio bola da donsan. Ita itu baiwalene seu wadene uawe itune unuwanalene itulen. ");
INSERT INTO soq_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Sape me ituleidie ita auen bedewe nete dauma tawo osowe enene odene ubo alena ewedie, ita nete sa osowe God enseliwa ieie ita odeie antoia ewamodie. ");
INSERT INTO soq_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Me epe ewedio, Iawe God wisene tampe enene diene wanase, “Ne Iawe, e ataa Abraam ita mamaa Aisak Godiu. Tawo ema osowe ituitiana ne e ita e bedeawoa do enalepa. ");
INSERT INTO soq_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","E nosinosia uarantopue tawo moawa daitada osowe mo uduuduntopu tawo popokauwa wisiasiawaia rua. Tane e ita e nosinosia do bedelawoe apana uduudu tawo osowe wanwanlala ne Iawe God sauna euda donsapue wadapu. ");
INSERT INTO soq_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Tane insena e naepe aitona ne ando oniadewasaepina, ita banlaepo leuite wiea tawo ema osowe. Tane do dima uduudu ne sauawaena ne ideita dewasapatuapi.” ");
INSERT INTO soq_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Iakob itu bedewe enenwisene wanase, “Ulaipa, tauma ne atenten Iawe God apa bola ema bedewe wande ita ne mai atenteapona.” ");
INSERT INTO soq_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Ita me bola sawo auen bedewe dewa pokawaa ewene nuawa saleno wanase, “Bola ema ipa kakaiwa God duwa ita uba intawa moawa nosena ewana.” ");
INSERT INTO soq_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Sa baiwa Iakob tadina bedewe enenwisene seu unuanalene itulena wadene eindodeno eneno ita seu sa osowe ia asiwa esapa bonabonaua memene en. ");
INSERT INTO soq_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Mape me bola sa ebowa itune wana Betel. Tane mapo bola sa ebowa tontawa waia Lus. ");
INSERT INTO soq_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Iakob saualene wanase, “Naita God e ne do, ne ana ema antedina bedewe oniadewasanene nana ita gara do neona. ");
INSERT INTO soq_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","Tane do oniadewasaneawo euda os leuntape mamana bolawe wineapa. E epe dewaitaa, e ipa Iawe ne Godna. ");
INSERT INTO soq_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Tane seu ne einadodena ewonte God wadaposisantaa baiwa, ita dima uduudu ne neona moa dea leusape eneepa.” ");
INSERT INTO soq_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Ita Iakob aleidie apana omo wisedia deneuwe waimoia mampo wisen. ");
INSERT INTO soq_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Tane me sape wisene enene sipsip ita gote uaraia uwa natadea esa naia atembaa wimone esa sa tampe ituntoio ewamon. Ita esa sa moawa seu debama enenbodene winedie. ");
INSERT INTO soq_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Tane esa sa mampe sipsip wimoie auweituwadio sipsip onionialala wimoie seu sa wadeiaubei. Ita pue esa wanamoio naio dialeidio aupe seu koirewasaio aleidie esa moawa enedibodedio ei. ");
INSERT INTO soq_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Ita Iakob sipsip oniamoia apanawa waitaramone wanase, “Sosona e bola dainea apanawa?” Tane mo leusane waienase, “No bola Aran apanawa.” ");
INSERT INTO soq_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Ita Iakob mo diamone wanase, “E apana ebowa Leiban Nao atawa ateiten ba, dia?” Tane mo me sipoasane waienase, “Oa, apana sa no ateinimbaida.” ");
INSERT INTO soq_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Ita mo epe waieno etene ita wanase, “Me wanwamba bedewe ide euda os wande, ba?” Tane mo waienase, “Oa, me ide euda os wande tauma emanta ewee meida anoopa Reitel sipsipwa do iei.” ");
INSERT INTO soq_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Tane me mo diamone wanase, “Ewane omo debama andomana pamepi ita tauma mai sipsip auwepua walamawa wisepona sa baiwa dainea bauta wimoiena esa wanamono napue leuntopue nanau awa antopu.” ");
INSERT INTO soq_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ita me epe wadio mo leusane waienase, “No mai epe dewantata, dia. No mape enonto sipsip uduudu wimopuo ita seu esa moawa itunbodae winedia wadataaubete nambesate ita tauma sipsip esa wanamoto napu.” ");
INSERT INTO soq_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Ita mo andomana gagalontoio bedewe Reitel mamba puewa sipsip banlamone sape wisen. Ipawa me ipa sipsip onionialala iwa. ");
INSERT INTO soq_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Tane Iakob inawa nopa Leiban anoopa Reitel ita me auba sa Leiban sipsipwa do ewamone ita alene seu esa moawa itunbodae winedia wadenaubeno nambeleno aupe auba puewa esa wanamono naiena. ");
INSERT INTO soq_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Ita ema aupe me Reitel wadene isuruwasane ita ke debamaia wan. ");
INSERT INTO soq_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Tane ema aupe Reitel mampe wane wanase, “Ne ipa e mamaa weanapa Rebeka otopa.” Ita Reitel epe etene alene mamba benemasan. ");
INSERT INTO soq_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Ita Leiban weanapa otopa Iakob wisena gagalowa etedia, tauwadea os weuwane alene into donsan. Me onapa wadene mampesane isuruwasan ita banlene duwe alen. Tane Iakob dewa uduudu mampe segalena umanawa me dieno eten. ");
INSERT INTO soq_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Tane Leiban Iakob diene wanase, “E ipa neida etena ita osinana.” Ema aupe Iakob sape wandio uaboa dea dialen. ");
INSERT INTO soq_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Ita Iakob wandio Leiban me diene wanase, “E ipa ne onanaida sa ipa ne etena ita osinanaida sa baiwa ne baina mai di nolaitona, ita ambi malesaa meneede.” ");
INSERT INTO soq_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Tane walama sawo Leiban obampa iwoa nata waimoie. I tautuwa ebowa ipa Lea tane kerauwa ebowa ipa Reitel. ");
INSERT INTO soq_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Ita Lea emawa ewaewawa ipa euwa tane Reitel me ipa mua ita inainamba eudida. ");
INSERT INTO soq_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Tane Iakob Reitel nuausano nuawa me mampe omeno baiwa me Leiban diene wanase, “Ne e baia ena 7 nolanteapa malesawa ando e anoa kerauwa Reitel neaa.” ");
INSERT INTO soq_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Me epe wano Leiban etene wanase, “Sa ipa euda ne ando me eneepa, ne mai menaneipona me ando apana da nambea naimopi.” ");
INSERT INTO soq_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Ita Iakob Reitel naisepia baiwa nolalena enawa ipa 7 dialen. Tane ena sa 7 me nolalena dauwa etaetawa abo walama natadea bedewe nolalepona rua, ipawa me Reitel nuawadawadaidasan. ");
INSERT INTO soq_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Tauma Iakob Reitel naisepia baiwa ena 7 bedewe nolalene ompa osowe wisene ita Leiban mampe wane wanase, “E waana rua ne nolana dewasane diasana, tauma ne anoa neawo naisepa.” ");
INSERT INTO soq_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Ita Leiban wanase, “Oa ide nainaitana.” Ita me nainai odawa debama dewasane sosowa uduudu bola sawo waimoia nisomono wimoiena Iakob mampe ita me nainaiwa odawa dewasaiena. ");
INSERT INTO soq_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Tane tadino dubawa bedewe Leiban Reitel ene Lea banlene alene mampesano nata ituntoiena. ");
INSERT INTO soq_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Tane do Leiban Silpa wadene Lea wanena nolawa dewasampa baiwa. ");
INSERT INTO soq_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Ita tadinaida Iakob enenwisene Lea ewene nuawa kadiidaleno wanase, “Leiban e dima baiwa epe dewaiten, ne ena 7 bedewe nola pokawaa dewasana Reitel baiwa. Tane e dima baiwa laga inainamba ema dewasaana ne mainawo?” ");
INSERT INTO soq_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Tane Leiban leusane wanase, “No dewamba ipa oto tautuwa bauta nainailepi muriwa kerauwa nainailepi. ");
INSERT INTO soq_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Tane e kerauda os onioniaitaa nainai odawantitana wikiwa ema dialepio aupe Reitel do eneepa. Tane sa ipa e bauta sauaitaa ena 7 osowe wane ne baina nolaita.” ");
INSERT INTO soq_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Ita Iakob Leiban aiawa ruawalene wana ena 7 da osowe wampie nolalepi. Ita me Lea naisene nata waimoio wiki dea dialeno aupe Leiban wana rua Reitel do waneno naisen. ");
INSERT INTO soq_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Ita do Leiban Bila wadene Reitel wanena nolawa dewasampa baiwa. ");
INSERT INTO soq_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Tauma Iakob Reitel do itusan ita me nuawadawadawa Reitel baiwa debamaidalen tane Lea mampe nuawadawadawa keraulen. Ita Iakob ena 7 da osowe waine Leiban baiwa nolalen. ");
INSERT INTO soq_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Tane Iakob nuawadawadawa Lea mampe keraulena baiwa Iawe God sauwa euda Lea osowe itune oto wanen tane Reitel ewene en. ");
INSERT INTO soq_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Ita Lea bulene otopa gamosane ebowa ituna Ruben. Ipawa me wane wanase, “Iawe God ne nuaparena saiwa ewene ita saunene euwa mainawo dewasan, tauma ne badana nuawadawadanepi.” ");
INSERT INTO soq_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Tane ema aupe Lea wandie osowe bulene otopa da gamosane ebowa ituna Simion, ipawa me wanase, “Iawe God ne etanene atenlen ne badana mai nuawadawadaneipona, dia. Sa baiwa ne otona da nen.” ");
INSERT INTO soq_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Tane Lea osowe bulene otopa natadeawa gamosane ebowa itune wana Liwai, ipawa me wanase, “Tauma ne badana nuawadawadaidanepi me obampa natadea gamomona baiwa.” ");
INSERT INTO soq_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Ita me osowe bulene otopa da gamosane ebowa ituna Iuda, ipawa me wanase, “Tauma ne Iawe God wadaposisapa.” Ita ema aupe me mai oto da gamosapona, dia. ");
INSERT INTO soq_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Tane Reitel oto gamosia di wandie ewene tatawa mampe obulen. Ita me badawa Iakob diene wanase, “E oto ne nea, dia ipa ne bonteapa.” ");
INSERT INTO soq_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Tane Iakob epe etene Reitel mampe nuawa kadileno wanase, “Ne God ba? Me e dewaeno oto wadasiaiten, mai ne, dia.” ");
INSERT INTO soq_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Ita Reitel badawa wanaubene wanase, “E ne nolana iwa Bila nata ituitano ita ne baina seda gamomopi ita ema epeinta daina debamalepi.” ");
INSERT INTO soq_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","5","Sa baiwa me nolawa dewala Bila Iakob nata ituntone ita bulene oto mona Reitel baiwa gamosan. ");
INSERT INTO soq_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Ita Reitel wanase, “God ne dima insedina rua oto nen ita sa ipa ne euwanen dima ne dewasana ipa dodomana.” Sa baiwa me otopa ebowa ituna ipa Dan. ");
INSERT INTO soq_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Tane Reitel nolawa iwa osowe bulene Iakob otopa natawa gamosan. ");
INSERT INTO soq_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Ita Reitel wanase, “Ne tatana mampe babisana ita ompa osowe kasawoganten.” Sa baiwa me otopa ebowa Napitali wane itun. ");
INSERT INTO soq_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Tane Lea oto gamowa enentudeno ewene nolawa iwa Silpa wadene Iakob waneno manainapa wanasan. ");
INSERT INTO soq_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Ita Lea nolawa iwa Silpa Iakob mampelena otopa gamosan. ");
INSERT INTO soq_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Ita Lea oto sa ewene wanase, “Ide dewanten eudida.” Ita me oto ebowa Gad wane itun. ");
INSERT INTO soq_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Tauma me nolawa iwa sa oto natawa gamosan Iakob baiwa. ");
INSERT INTO soq_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Tane Lea wanase, “Ne nuaeunten! Ioto uduudu ne mainawo wapuase, nuaeu.” Sa baiwa me oto ebowa Asea wane itun. ");
INSERT INTO soq_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Ita wit totowa walamawa wiseno ita Ruben nosene irai bedewe alen. Me alene ia ipawa otamone inawa Lea mampe wisen. Apana inseia ia sa napue oto gamontopu. Tane Reitel Lea diene wanase, “Rua ba dia, e otoa iawa ipawa otena isiwa ne nea.” ");
INSERT INTO soq_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Tane me Reitel diene wanase, “Ne badana e wadaapunden tane meneedia ne otona mampe iawa ipawa otea, ba?” Tane Reitel leusane wanase, “Sa ide e otoa iawa ipawa ne nea sipoa Iakob wisepio nata ituitana.” ");
INSERT INTO soq_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Sa baiwa Iakob irai bedewe leidie rawiwa wiseno Lea nosene donsane wanase, “Ne otona iawa ipawa Reitel wanena sipoa ande tadina e nata ituntata.” Sa baiwa tadina sawo me Lea nata ituntoiena. ");
INSERT INTO soq_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Tane Lea raupariwa God etene sausano bulen ita Iakob otopa nambawa 5 gamosan. ");
INSERT INTO soq_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Mape Lea wanase, “Ne Iakob wadane nolana iwa wanana baiwa God ne unena nen.” Sa baiwa me ebowa Isaka wane itun. ");
INSERT INTO soq_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Ita Lea osowe bulene ita Iakob otopa nambawa 6 gamosan. ");
INSERT INTO soq_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Tane Lea wane wanase, “God ne amonana eubuida nen. Tauma ne badana ituposineampe oniadewasaneampa, ipawa me obampa uduudu 6 gamomona.” Sa baiwa me oto sa ebowa Sebulun wane itun. ");
INSERT INTO soq_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Ita ema adiwe me bulene anoopa iwoa gamosan ita ebowa Daina wane itun. ");
INSERT INTO soq_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Tane sawana sa bedewe God Reitel raupariwa etene bupa bedewe oto duwa imaasan. ");
INSERT INTO soq_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Ita me bulene otopa gamosane ita wanase, “God ne malana wadenauben.” ");
INSERT INTO soq_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Tane me otopa sa ebowa Iosep wane itun ita wanase, “Tane Iawe God osowe oto da do nepi.” ");
INSERT INTO soq_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Tane Iakob leulene bolawe aleidie into God enseliwa me donsaiena. ");
INSERT INTO soq_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Ita Iakob mo ewamone wanase, “Ema ipa God nolawa dewalala saradoubu, sa baiwa bola sa me ebowa wana Maanaim.” ");
INSERT INTO soq_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Tane Iakob gagalowa bautasane me nolawa dewalala wanamone waubamopio antopue me tatawa Esau bola Edom ebowa da waia Sia bedewe wandia diapua baiwa. ");
INSERT INTO soq_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Ita mo a baiwantoio me diamone wanase, “Ema epe aitane debamana Esau diana, ne e nolaa dewala auna Leiban mape wankasanten ita tauma leuntene iedina. ");
INSERT INTO soq_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Ita do aitane tatana benemasana, ne mainawo pue kau, donki, sipsip, gote ita nola dewalala mona ita iwoa uara waimoi, sa baiwa me ne sowananepia menanede.” ");
INSERT INTO soq_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Tane mo mida benema sa wadane antona leuntone wimone Iakob diane waienase, “No e tataa Esau mampe antene diatano etene ita me apanawa 400 do manawo iei.” ");
INSERT INTO soq_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Ita Iakob epe etene nuawa saidaleno ingugura do apanawa mida do antoia empuiamono uwa nata seganton. Tane puewa - sipsip ita gote ita kamel do empuiamono nata seganton. ");
INSERT INTO soq_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Ipawa me insenase, “Naita Esau iompe ne apanana uwa dea bautantona kadimompo uwa da sawo weuwapue nambe antopu.” ");
INSERT INTO soq_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Tane Iakob rauparilene wanase, “O God ne atana Abraam Godiwa ita ne mamana Aisak Godiwa. O Iawe God, e ne diane waanase, ‘Leuite bolaawo ita gombaa mampo aitaa ita sape ne e manawo dewa eubu dewamopa.’ ");
INSERT INTO soq_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","God, ne mai nola dewalala euda. Tane e ne nuaparenaitene ita dewaa euda mainawo dewamoana. Ita mapo ne ana bedewe witanawo koina os wadane esa Ioadan nawane anten. Ita tauma ne apanana do uwa nata seganten. ");
INSERT INTO soq_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","O Iawe God ne rauparintedina e ne saunea. Ne tatana Esau into doinepie mai kadinepi, dia. Ne me sawantedina into doinepie seda ita gombau iwoa do kadinepia sawa. ");
INSERT INTO soq_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Ita do e ne sauanee waanase, ‘Ne ando e dewaepo eboa debamalepi ita do dana dewasapo owa nelawa mai wisiantopua rua segalepi.’” ");
INSERT INTO soq_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Tane Iakob into itulene ita imonemba enene tatawa Esau mampe amona itupia baiwa puewa empuempumon. ");
INSERT INTO soq_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Pulo sa ipa gote iwoa uduudu 200, mona wisiawa 20, do sipsip iwoa uduudu 200 ita mona wisiawa 20. ");
INSERT INTO soq_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Ita kamel iwoa uduudu 30 mo obampu do, kau iwoa uduudu 40 ita mona uduudu 10, tane donki iwoa uduudu 20 ita mona uduudu 10. ");
INSERT INTO soq_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Ita me pue sa empuempumone nola dewalala witapomone wanase, “Tauma e pue ema banlamone bautaitana, tane awoaawoa enane aitana.” ");
INSERT INTO soq_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Ita me nolawa dewalala pue banlamopue bauta antopua apanawa wadewasamone wanase, “E aitonune Esau donsano me waitaralepie wapiase, e mida nolawa dewalala ita naepe aitilana, do ema mida puewa. ");
INSERT INTO soq_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Ita me epe waitaralempo diane wanase, ‘Pue ema uduudu ipa e nolaa dewalala Iakob mebaawa ita me nuaeuwa amonawa waubalen me debamawa Esau baiwa. Tane me no wambo odedia wisepi.’” ");
INSERT INTO soq_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Tauma me nolawa dewalala isiwa mida pue banlamopue bautantopue antopua diamone wanase, “E uduudu ando Esau donsanaa aia ipa deawa wane diana.” ");
INSERT INTO soq_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Tane do diane wanase, “E nolaa dewalala Iakob no wambo odede.” Ipawa Iakob insenase, “Muriwa ne me donsapa bauta me nuaeuwa amonawa waaubantapo ewepie nuawa eulempo ne wineapa ita kadiwa ne mainawo mai dewasapi, dia.” ");
INSERT INTO soq_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Sa baiwa Iakob Esau nuaeuwa amonawa pue waaubamono nola dewalala banlamone bautantone anton. Tane Iakob sape wandie itulen. ");
INSERT INTO soq_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Ita tadina sawo me manamanainapa nata ita ioto nata mo nolau dewalala ita do obampa 11 waubamono esa ebowa Iabok nawane anton waiwa dauwo. ");
INSERT INTO soq_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Tane mo nawane antoieno wauwo nituwa uduudu waubamono anton. ");
INSERT INTO soq_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Ita Iakob eieno meba os wandio ita apana da wisene me nata onantone wadawadantoio walama puwan. ");
INSERT INTO soq_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Tane apana sa Iakob kasawogaleidio ewene wadentue tampa bumpa epeno aisiden. ");
INSERT INTO soq_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Ita apana sa wanase, “Eneawo anteapa walama pundeide.” Tane Iakob wanase, “Ne mai e eepo aitaa, dia, ideita sau euda osonawo ituwo muriwa eepo aitaa.” ");
INSERT INTO soq_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Tane apana sa me waitarasane wanase, “E eboa ambi?” Ita me leusane wanase, “Ne ebona ipa Iakob.” ");
INSERT INTO soq_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ita me epe wadio apana sa wanase, “E eboa mai Iakob tane e eboa ipa Israel ipawa e God ita apana mampo babisaana ita kasawogaiten.” ");
INSERT INTO soq_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Tane Iakob wanase, “Ne menanedia e eboa wae dianea.” Ita me leusane wanase, “Dima baiwa ne ebona ateitaa baiwa waiana?” Ita sape me sau euda osowe itun. ");
INSERT INTO soq_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Tane mape Iakob emaweido God ewen ita do me bolepona tane inalen sa baiwa me bola sa ebowa Penuel wane itun. ");
INSERT INTO soq_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Ita me bola Penuel bedewe aleidie tampa bumpa aisideno baiwa ansuleidio omo wisene tontalen. ");
INSERT INTO soq_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Mapo ita tauma walamawa bedewe Israel apanawa nosinosiu moia tampa bumpa mai naipona, dia. Ipawa Iakob tampa bumpa epeno aisidena baiwa. ");
INSERT INTO soq_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Iakob bola Padan Aram bedewe wandie leulene bola debama Betelwa wiseno God me mampe segalene sau euda osowe itun. ");
INSERT INTO soq_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Ita God wanase, “E eboa ipa Iakob ebo sa tauma dialeide tane eboa sanaa ipa Israel.” Ita me ebowa ituna Israel. ");
INSERT INTO soq_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Tane God me mampe wanase, “Ne ipa God Mukamukaua e otootoite obana uara segantopu do dana debamalepi ita uwa daitada segantopu. Tane mo bedeuwo isiwa warere segantopue apana oniamompa. ");
INSERT INTO soq_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Tane tawo umanawa ne Abraam ita Aisak sauamona ne e eneepa ita do e dana ando muntompa tawo ema wanamopa.” ");
INSERT INTO soq_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Sape God Iakob mampe gagaloleno dialeno ene alen. ");
INSERT INTO soq_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","God gagalolena aupawa oso Iakob seu dauma wadene eindodene ita osowe wain memene pulowa God mampe itun ita do ia olib esapa memene en. ");
INSERT INTO soq_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Iakob God nata sape gagalotona baiwa bola sa ebowa Betel itun. ");
INSERT INTO soq_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Ema aupe Iakob bola Betel ene antoie andoma bola debama Epra bedewe wimopua Reitel oto dauwa eten. Ita oto mulepona babisane poka etaidasan. ");
INSERT INTO soq_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Me oto gamoa babisadio poka debamaia wisen ita oto muleidio oniedia iwa wanase, “Mai saitaa e oto mona gamosaana.” ");
INSERT INTO soq_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Tane walama sawo Reitel boida baiwaledie oto ebowa ituna Benoni. Tane me mamba otopa ebowa itune wanase, Beniamin. ");
INSERT INTO soq_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Sape Reitel boleno bola debama Epra intawa aleidia waiwe dobontoiena. Tane bola debama Epra ipa Beteliem ebowa tontawa. ");
INSERT INTO soq_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Ita Iakob Reitel dobontoiena osowe seu dauma wadene eindoden. Mo seu sa ewompe me bowa insempa baiwa. ");
INSERT INTO soq_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Tane Iakob obampa mona wisiawa uduudu 12. ");
INSERT INTO soq_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Me manainapa Lea gamomona ipa: Ruben me Iakob otopa tautuwa, Simion, Liwai, Iuda, Isaka ita Sebulun. ");
INSERT INTO soq_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Tane manainapa Reitel obaampa mona ebou ipa: Iosep ita Beniamin. ");
INSERT INTO soq_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Tane Reitel nolawa iwa ebowa Bila obampa mona ipa: Dan ita Napitali. ");
INSERT INTO soq_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Ita Lea nolawa iwa ebowa Silpa obampa mona ipa: Gad ita Asea. Mo ipa Iakob obampa mona bola Padan Aram bedewe waimoie muntona. ");
INSERT INTO soq_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Tane Iakob leulene mamba Aisak mampe wisen bola Mamre, Kiriat Aba tampe. Bola sa tauma ebowa waia Ibron. Tane sape mapo Abraam Aisak nata ware rua waimoie. ");
INSERT INTO soq_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Ita Aisak sape wandio enawa 180 waden. ");
INSERT INTO soq_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Tane me wandio ena debamaia dialeno gulaulene boleno aleupa alen nosinosiwa mampo. Tane me obaampa Esau ita Iakob dobontoiena. ");
INSERT INTO soq_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Aisak boleno aupe Iakob bola Kanaan bedewe mamba wandia aupe ware rua wandie. ");
INSERT INTO soq_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Tane Iakob obampa do gagalou ema epe. Iosep ipa oto emademba enawa 17 wadedio me tatatawa do pue sipsip ita gote oniamoie. Tane seda sa ipa me mamba manamanainapa Bila ita Silpa obaampu. Ita Iosep aleidie mamba mampe wisedie mo emalawoasaia umanawa mamba benemasade. ");
INSERT INTO soq_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Walama sawo Iakob gulauidalene wandie otopa Iosep gamosan sa baiwa me otopa sa nuawadawadaidasan mai obampa isiwa ruau. Sa baiwa me garawa oawa eudida wanen. ");
INSERT INTO soq_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Tane mo mambu otopa Iosep epe nuawadawadasadio ewane nuau kadileno me wakadisasaie ita do emalawoasaie. ");
INSERT INTO soq_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Tane tadina dea me ituleidie auenlena umanawa tatatawa benemamon. Mo epe etane nibuasaiena. ");
INSERT INTO soq_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Iosep diamone wanase, “Asisuitonuno ne auentena gagalowa wapa. ");
INSERT INTO soq_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","No irai bedewe wit toite ita dimbuntite teamoite. Tane ne witina dimbua sawano enedie ita e ebaala enane panane ne dimbuna mampe dunentoie.” ");
INSERT INTO soq_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ita me tatatawa etane waienase, “E inseiana muka wadee warereite no onianena, ba?” Tane Iosep auemba gagalowa wano etane me nibuaidasaiena. ");
INSERT INTO soq_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Tane Iosep osowe auenlene tatatawa diamone wanase, “Ne auena bedewe omo, uaboa ita kipora 11 mainawo dunentoio ewamona.” ");
INSERT INTO soq_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Tane Iosep auemba mamba dien tatatawa diamona rua. Ita me mamba etene badowa diene wanase, “Dima auemba epe aueiten, e inseiana inaa ne nata ita tatataa do e manawo winte dunentate wadaposieta, ba?” ");
INSERT INTO soq_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Tane me tatatawa auemba umanawa etane me mampe nuau kadilen ita me mamba auen ema insaisawaleidie os wandie. ");
INSERT INTO soq_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Walama dea Iosep tatatawa enanawimone mambu puewa sipsip ita gote banlamone antone bola Sikem bedewe oniamoie. ");
INSERT INTO soq_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Ita Iakob Iosep diene wanase, “Ne menanedia e waaubaepo aite tatataa bola Sikem bedewe sipsip ita gote oniamoie waimoia ewamoa.” Ita Iosep wanase, “Oa, ne anteapa.” ");
INSERT INTO soq_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Ita mamba me diene wanase, “Aie tatataa ewamoa mo ide inawaa waimoi ita do pue ewamoa ide euda os waimoi tane leute wine mo umanau dianeawo etapa.” Tane Iakob Iosep wanaubeno bola debama Ibron dobawa ene alene Sikemwa wisene. ");
INSERT INTO soq_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Sape mo ewasumone insakoaleidio apana dea me waitarasane wanase, “E dima banusaiana?” ");
INSERT INTO soq_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Iosep me sipoasane wanase, “Ne tatatana banumodina mo naepe sipsip ita gote oniamoi, e ateitama waeuwaneawo anteape ewamopa?” ");
INSERT INTO soq_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Ita me leusane wanase, “Mo aita antoiena. Ne etamodino waienase, no bola ema etee bola debama Dotan bedewe ana.” Ita me epe etene tatatawa waroromone wawo alene bola debama Dotanwa donmon. ");
INSERT INTO soq_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Me nowadauwo iedio tatatawa ewane muba wawadiadiantone insaisau deasane waiena me wisepio bosapu. ");
INSERT INTO soq_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Mo Iosep wakadisawa gagalowa wane waienase, “Ewana, auen apanawa iede. ");
INSERT INTO soq_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","No me bosate ane esa sagala domba bedewe aubeto alepi. Ita no ete ane mamamba diate wataase pue onawa Iosep adenboe nan. Ita ema aupe ewato me auemba ide ulaipa.” ");
INSERT INTO soq_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Tane Ruben mo gagalontoio etene ita Iosep inasapia baiwa wanase, “Mai bosata. ");
INSERT INTO soq_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Me mai bosata, no di wadate esa sagala makolena domba bedewe aubeto iepie alepi. Tane no mai witamba me osowe itute bosata.” Ruben aia ema wana ipawa me menasana Iosep inasapie banlepie alepi mambu mampe. ");
INSERT INTO soq_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Tane Iosep tatatawa mampo wiseno me wadanaitue ampe garawa euda taudia wadanaaubeiena. ");
INSERT INTO soq_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Ita mo me wadane antone esa sagala makolena bedewe aubeieno iene alen. ");
INSERT INTO soq_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Ema aupe mo waine nana naie ita pisiwane Ismaelwa bola Giled bolawa bedewe wanwanlala pueu kamel do ieio ewamoiena. Mo pueu sa osowe nitu nana eusampa ita nitu isiwa etepu pokawa wampo osowe uturempa baiwa tane do mire etepu benasampa baiwa aimone Isibtiwa antoie. ");
INSERT INTO soq_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Ita Iuda tatatawa diamone wanase, “Naita no wainimba bosate gagalowa weregasata, tane ema aupe dima euda donsate wadata? ");
INSERT INTO soq_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Sa baiwa Ismael apanawa wanamoto gimarantopue antopu. Tane me mampe mai kadiwa da dewasata, ipawa me ipa no wainimba osina dea muntena wainitana.” Ita Iuda dima wana rua sosowa wawentoiena. ");
INSERT INTO soq_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Tane bola Midia mo ipa gimara apanawa wimoieno ita mo wambu Iosep don bedewe teinenaposie wanamoieno mane nepa wisiawa 20 mampe gimarantoiena. Ita sape mo Iosep banlene Isibtiwa antoiena. ");
INSERT INTO soq_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Tane ema aupe Ruben leulene alene esa sagala domba bedewe Iosep ewensue nuawa pareleno meba garawa siosawialen. ");
INSERT INTO soq_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Ita me wanwamba mampo alene wanase, “Iosep mai don bedewe wainipona, dia. Tauma ne dima dewasapa?” ");
INSERT INTO soq_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Tane Iosep tatatawa pue gote bosane ita osinawa wadane me garawa osinasaiena. ");
INSERT INTO soq_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Ita mo gara sa oawa euda wadane antone mambu diane waienase, “No gara ema donsatana ewawo, e otoa garawa rua?” ");
INSERT INTO soq_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Mo mambu gara sa ewene wanase, “Ema ipa ne otonaida garawa. Pue onawaa me adane bosane ita siosawiasaiena.” ");
INSERT INTO soq_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Ita me nuawa pareidaleno meba garawa taudia siolenauben. Aupe gara pue imba mampe dewala dauwa etaeta kadiwaida wadene taune walama dauma otopa kewa wadie. ");
INSERT INTO soq_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Me obampa mona ita iwoa wimone mambu nuadubusaie, tane me dabualene wanase, “Ne ideita ke wapine otona wawe bolala bolauwo iape anteapa ita dialepi.” Ita me otopa kewa wadia mai epona, dia. ");
INSERT INTO soq_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Tane bola Midia apanawa Iosep wadane Isibtiwa warere duwa bedewe nolantoia uwau apanawa Potipa mampesaieno gimaralen. ");
INSERT INTO soq_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Tane Ismael apanawa Iosep banlene Isibtiwa antoiena. Sape Isibt warerewa duwa onieia uwauleidia apanawa ebowa Potipa Iosep gimaralene mampesan. ");
INSERT INTO soq_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Ita me wadene mampesane duwa bedewe ituno wandie. Tane Iawe God ipa Iosep do mai epona, dia. Sa baiwa me nitu uduudu dewasadia bedewe ipuipua segaleidie. ");
INSERT INTO soq_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Iawe God ipa Iosep do ita sausano nolawa uduudu dewamodio ipuipua segaleidio Potipa ewene, ");
INSERT INTO soq_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","nuawa euleno Iosep diena me nolawa dewasapi. Tane do me muka wanena apana mida me duwa bedewe nolantoia uwau apanawa segalepie ita nitu uduudu me witapelepio oniamopi. ");
INSERT INTO soq_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Tane walama sawo Iawe God sauwa euda Iosep asiasi Isibtiwa Potipa duwa bedewe wanwanlala wadeiena. Ita do nitu uduudu du bedewe ita irai bedewe eulentuwan. ");
INSERT INTO soq_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Ita du bedewe nitu uduudu wineia Iosep witapelena oniamopi. Tane Potipa mai dima da nuabolawalepi, dia. Me nana os nanawa insaisawa wadompa. Tane Iosep me ipa apana emademba uwatauwa ewaewa eudida. ");
INSERT INTO soq_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Ita me mai wampono daumalepono Potipa manainapa me ewene mampe nuawa omaidasano baiwa diene wanase, “Winewo nata ituntata.” ");
INSERT INTO soq_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Tane Iosep dabualene wanase, “Ne onianedia apanawa mai dima da nuabolawaleipona, ipawa ne mape wainedina, ita nitu uduudu ne witanawosano oniedina. ");
INSERT INTO soq_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ne me aupawa wadane ita du ema oniedina. Nitu uduudu oniepina mukawa neen, me mai dima da anatepona, dia. Tane dea e os ipa me mebaawaida, ambi ne dianeiana kadiwa e manawo ita God mampe dewasapa?” ");
INSERT INTO soq_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Tane i sa kainokaino Iosep itudosadie, ita me mai menasapona nata wampu ba ituntopu dabuaidalen. ");
INSERT INTO soq_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Walama dea Iosep nola awa wisene du bedewe oden ita nola sosowa sape mai waimoipe, dia. ");
INSERT INTO soq_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Me odene leidio Potipa manainapa me mampe wisene garawa onapea wadenitue diene wanase, “Winewo nata ituntata.” Me epe wadio Iosep weuwane nosene alen ita gara os i sa witape winakasalen. ");
INSERT INTO soq_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Iosep i sa ene nosene aleno aupe me garawa onapea witape winedio ewene, ");
INSERT INTO soq_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","nola dewalala apamono mampe wimono diamone wanase, “Ewane, Ibru apanawa ema ne badana banlene wisene ituno duwa wandia dewa kadiwaida malawala mainawo dewasan. Me wisene no ituntitana bolawe odene wadaneapona baiwaleidio ka debama wana. ");
INSERT INTO soq_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Ne ka wadino etene garawa ene weuwane nosene pewa alen.” ");
INSERT INTO soq_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Ita me Iosep garawa wadenitue wandio badawa leulene duwa wisen. ");
INSERT INTO soq_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Me wiseno manainapa dewa sa segalena umanawa uduudu benemasane wanase, “Ewee, Ibru apanawa ema e banleano wisene duwa wandia dewa kadiwaida malawala ne mainawo dewasan. Me odene no ituntitana bolawe ne wadaneapona baiwaleidie. ");
INSERT INTO soq_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Tane ne ka wano me garawa ene weuwane nosene pewa alen.” ");
INSERT INTO soq_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Potipa manainapa aia ema wano etene nuawa kadiidaleno ");
INSERT INTO soq_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Iosep wadenitue dibura bedewe itun, warere apana dibura bedewe teamodio waimoia bolawe. Ita sape Iosep dibura bedewe wandie. ");
INSERT INTO soq_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Ita Iawe God ipa me do sa baiwa sau euda me osowe ituno dewa eubu dewamodie. Ita dibura oniamodia apanawa me ewene nuawa eulen. ");
INSERT INTO soq_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Sa baiwa me Iosep muka waneno dibura bedewe sosowa ita do nitu uduudu sape wineia oniamompa apanawa segalen. ");
INSERT INTO soq_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Tane dibura oniedia apanawa mai dima da nuabolawalepona, dia. Ipawa sai sa uduudu tauma Iosep witapelen. Ita Iawe God ipa me do, sausadio dewa uduudu dewamodio ipuipua segantoie. ");
INSERT INTO soq_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Walama isiwa diantono aupe Isibt warerewa nolawa dewala nata, wain reduwa oniedia ita bured sudia apanawa nitu da kadisaieno baiwa warere nuawa mai eulepona. ");
INSERT INTO soq_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Sa baiwa warere nuawa kadiidalen nolawa dewalala apanawa debamau nata mampo. ");
INSERT INTO soq_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Ita me otamone dibura onieia uwauleidia apanawa duwa bedewe naepe Iosep wandiawo teamon. ");
INSERT INTO soq_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Tane dibura onieia uwauleidia apanawa mo banlamone alene Iosep witapesan oniamopia baiwa. Ita sape mo waimoio walama uaraia dialen. ");
INSERT INTO soq_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Wain reduwa wadedia ita bured sudia apanawa walama daumaia dibura bedewe waimoie ita tadina dea auentoiena tane mo auembu ipawa ipa nambenambe. ");
INSERT INTO soq_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Ita imonemba tadinaida Iosep alene mo inainambu ingugura do waimoio ewamon. ");
INSERT INTO soq_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Ita me waitaramone wanase, “Ande e ambi dewaitene baiwa inguguraitile wainilana?” ");
INSERT INTO soq_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Tane mo sipoasane waienase, “No tadino ituntite auenten ita auen sa ipawaida mida waeuwanepio atentata.” Iosep aia ema etene wanase, “God no saunepio auen ipawa atentate waeuwantata rua. Sa baiwa auenla wamono etapo.” ");
INSERT INTO soq_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Ita wain reduwa oniedia apanawa auenba benemawa Iosep diene wanase, “Ne wain iawa dananawo enedio ewana, ");
INSERT INTO soq_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ita wain iawa ragapa natadea osowe inintoie asiwa nomonatuwaiena ita kelontone tauwadea ipawa teamone ita menawaiena. ");
INSERT INTO soq_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Tane ne warere reduwa wadedine ita wain ipawa otene redu sa bedewe bulontene me wanana.” ");
INSERT INTO soq_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Ita Iosep wanase, “E auena ipawaida ipa ema epe: Wain ragapa natadea ewaana sa ipa walama natadea umanawa wade. ");
INSERT INTO soq_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Walama natadea diantopuo aupe warere dibura bedewe wainiana wadaaubaepio noea. Ita e nolaa aupawe ituepio nolaita. Tane e bauta nolaitiana rua warere reduwa wadone witape ituna. ");
INSERT INTO soq_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","E sape nolaitone wanwana eulempo e euwaa dewasae ne insane ita warere diawo nuaparenalepie dibura bedewe wainedina wadaaubanepio noneapa. ");
INSERT INTO soq_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Ne mainawo dima segalena umanawa warere diawo etepi. Ne Ibru tawowa bedewe wainedino apana muka mampe wadanenaitue banlanene wimone mape ituneieno wainedina. Ne mape Isibt bedewe wainedine mai dima da kadisapona tane di diburaneieno wainedina.” ");
INSERT INTO soq_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Tauma bured sudia apanawa sowa auemba Iosep wano etene nuausano ita me Iosep diene wanase, “Ne do auenten, auena ema epe: Ne bured susula posawa natadea uwanawo endontene antedine. ");
INSERT INTO soq_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Tane posa onapea bedewe bured iilala daitada aimone warere baiwa antedine. Ita nene wimone onanawo posa bedewe nana sa namoie.” ");
INSERT INTO soq_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Ita Iosep me sipoasane wanase, “Posa natadea ewamoana, sa ipa walama natadea umanawa wade. ");
INSERT INTO soq_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Walama natadea dialepio aupe warere wadaaubaepio dibura ee noea. Ita me sorodiawa diamopio wimopue e imuna topupune ita ia osowe seuepu. Tane nene wimopue naeputuwapi.” ");
INSERT INTO soq_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Walama natadea diantono warere muwa walama wiseno odawa dewasane ita nolawa dewala apanawa nisomono auweiena. Tane do me wain reduwa onioniala ita bured sudia apanawa dibura bedewe waimoio wadaaubamone banlamone warere mampe wimon apana uara waimoio danauwo. ");
INSERT INTO soq_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ita sape wain reduwa onioniala apanawa warere me nolawa osowe itune ita wain reduwa wadane witape itun. ");
INSERT INTO soq_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Tane bured sudia apanawa uwawa tonapune ita ia osowe seuiena. Ita dima Iosep mo auembu waeuwalena ruaida segalen. ");
INSERT INTO soq_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ita mape wain reduwa wadedie warere wanedia apanawa Iosep mai insepona nuawa awawaidalen. ");
INSERT INTO soq_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Tane ena nata diantono aupe Isibt warerewa wandie auenlen. Me auemba ema epe: Me esa Nael tampe enedia ewedie, ");
INSERT INTO soq_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","ita walama sawo kau uduudu 7 etepu potopotowa ewaewau eubu esa bedewee wimone ina esa tampe inintoia namoie. ");
INSERT INTO soq_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Ema aupe kau 7 da ewaewau oaoarauida etepu nepunepua esa Nael bedewee wimone esa tampe kau eubu bauta wimoiena do eneie. ");
INSERT INTO soq_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Ita kau ewaewau oaoarau etepu nepunepua enane kau 7 ewaewau eubu etepu potopotowa namonatuwaiena. Ita warere auenleidia ene enenwisen. ");
INSERT INTO soq_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Tane me osowe itulene auemba natawa ewena ema epe: Wit ipawa uduudu 7 iawa dea osowe naunautetela ewaewau eubu wineie. ");
INSERT INTO soq_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Ita ema aupe wit iawa osowe ipawa 7 da inintone wimoiena lanunu epeno ipau rorontone kapisantona ewamon. ");
INSERT INTO soq_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ita wit kapisantona sa enane wit ipau eubu naunautetela namonatuwaiena. Ita ema aupe warere enenwisene insene wanase, “Ema apa ne auentedina.” ");
INSERT INTO soq_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Sa baiwa tadinaida me nuawa surakauidalen, ita me wene apanawa, ginauri dewalala ita aten apanawa auen ipawa benemantopuo etepia baiwa gagalou wanauben Isibt bolawa uduudu bedewe. Mo wimoieno warere auemba nata umanawa diamon, tane mai mida da auen sa nata ipawaida waeuwalepona, dia. ");
INSERT INTO soq_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Ita wain reduwa wadedie warere wanedia apanawa me diene wanase, “Tauma ne insaisa mainawo wiseno kadiwa dewasana insenadewanten, tauma wapo etaa. ");
INSERT INTO soq_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Mapo e bured sudia apanawa mampe ita ne mainawo nuaa kadiidalen. Ita e otanee dibura onieia uwauleidia apanawa duwa bedewe teaneana. ");
INSERT INTO soq_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Tane tadina dea no ituntite auenten ita auen sa ipawa ipa nambenambe. ");
INSERT INTO soq_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ita Ibru apanawa sanaa no do wainitana, mida dibura onieia uwauleidia nolawa dewasadia apanawa, no auentena umanawa me diatano benemanen. ");
INSERT INTO soq_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ita dima me wana ruaida no mainimbo segalen. E ne wadane nolana osowe ituneana ita e sorodiaa diamoano bured sudia apanawa imumba tonapune ita etepa ia osowe seuiena.” ");
INSERT INTO soq_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Tauma warere epe etene Iosep gagalowa wanauben me mampe wisepia baiwa. Ita mo tauwadea antone me banlene dibura ene wimoiena. Ita Iosep koro tone gara eubu taumono tauma me banlene warere mampe antoiena. ");
INSERT INTO soq_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Ita warere Iosep diene wanase, “Tadino ne ituntedine auenten ita auen sa ipawaida mai mida da ne waeuwaneapona, dia. Tane apana waiase, e auen ipawaida waeuwaitiana.” ");
INSERT INTO soq_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Tane Iosep sipoasane wanase, “Ne neba mukana mampe mai auen sa ipawaida waeuwanteapa rua, dia. Tane God os e auena sa ipawaida waeuwaepia rua.” ");
INSERT INTO soq_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Ita warere Iosep diene wanase, “Ne auen bedewe esa Nael tampe enedine, ");
INSERT INTO soq_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","ita esa sa bedewee kau uduudu 7 etepu potopotowa eubu wimone esa waiwe ina namoie. ");
INSERT INTO soq_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Tane ema aupe ewedino kau uduudu 7 da oaoarau etepu nepunepua esa bedewee wimoiena. Kau inainambu ema ruau ne mai Isibt bolawa bedewe ewamopona, ewamona. ");
INSERT INTO soq_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Ita kau oaoarau etepu nepunepua enanawimone ita kau etepu potopotowa uduudu 7 esa bedewee bauta wimoiena namonatuwaiena. ");
INSERT INTO soq_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Tane kau etepu nepunepua sosou etepu potopotowa namonatue aupe mai muntopona, dia, nepunepua deawa waimoie. Ita ne ituntedina enanawinen. ");
INSERT INTO soq_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Tane osowe ituntene auen da ewana. Ita auen sa bedewe wit iawa dea osowe naumona ipawa uduudu 7 menawane wineio ewamona. ");
INSERT INTO soq_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Ita ema aupe wit iawa da osowe ipawa naumona uduudu 7 wineio lanunu wisene suno ipawa da kapisanton ita isiwa kerakera teamon. ");
INSERT INTO soq_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Tane wit ipawa 7 kapisantona enane wit naumonadewae menawaie wineia namonatuwaiena. Ita ne auen ema ewane ipawa atenteapona baiwa wene ita apana debamau diamono wimoiena. Ita ne auena mo diamono etane ipawa mai waeuwaneapona, dia.” ");
INSERT INTO soq_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Tane Iosep warere auemba ipawa benemasane wanase, “E auena nata ipau ipa deawaa. Dima ando e manawo segalepia umanawa God auen bedewe waeuwaen. ");
INSERT INTO soq_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Kau potopotowa eubu 7 ewamoana sa ipa ena 7 ita wit ipawa eubu 7 sa ipa ena 7. Auen sa nata ipau ipa deawa. ");
INSERT INTO soq_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Tane kau etepu nepunepua ewaewau oaoarau 7 kau eubu wauwo wimoiena sa ipa ena 7 umanawa wade. Tane wit ipawa 7 lanunu epeno tonantona sa ipa ena 7 bedewe omana debamawa segalepia umanawa wade. ");
INSERT INTO soq_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Ita dima ne warere benemaena ruaida God e manawo dewasapia baiwaleide. ");
INSERT INTO soq_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Ena 7 bedewe maura debama Isibt tawowa uduudu bedewe segalepi. ");
INSERT INTO soq_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Tane ema aupe ena 7 da bedewe omana debamaia segalepi. Ita Isibt bedewe maura debama segalena apana nuauawawalepi. Ita omana debama segalepie bola uduudu kadisapituwapi. ");
INSERT INTO soq_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Ita omana debamaia segalepie apana mapo nana debama naia insaisawa bedeuwo dialepi. ");
INSERT INTO soq_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Tane God insaisawa itudia dewa ema ideita segalepi. Sa baiwa me auen ema nata eneen. ");
INSERT INTO soq_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Tauma ne menanedia aten ita insadewasa apanawa enaitudepio tawo Isibt uduudu me atowelepio oniepi. ");
INSERT INTO soq_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Sa baiwa Isibt bolawa deadea bedewe apana insadewasala sonabamoa. Ita mo sape wampue apana nana uwauwantoia adibawa 5 teamompa. Ita uwauwa sa deadea bedewe mo adiba dea wadompe adiba bolawe itumpa, maura walamawa sa bedewe. ");
INSERT INTO soq_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ita apana sa debamau ena ema deadea bedewe nana uwauwantompe warere mukawa atowe bola debamau bedewe adibantompo winompo oniempadewantompa. Ita muriwa nana ipa sa apana napue tounawe wampu. ");
INSERT INTO soq_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Tane omana debama segalempo, ena 7 bedewe Isibt apanawa nana sa saumopi. Ita epe segalepio apana mai omana bowantopu, dia.” ");
INSERT INTO soq_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Ita dima Iosep wana osowe warere ita me nolawa dewalala do nuaeuwanton. ");
INSERT INTO soq_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Ita warere mo diamone wanase, “Ulaipa, God aleupa apana ema bedewe wande. Sa baiwa no mai insaisa apanawa da me rua banusata, dia.” ");
INSERT INTO soq_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Mape me Iosep diene wanase, “Ipawa God nitu uduudu e manawo sabamosan, mai mida da insaisa euda ita aten apanawa wainipona e ruaa, dia. ");
INSERT INTO soq_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Tauma ne e ituedina ne bolana ema uduudu atoawolepio oniea ita apana uduudu e aiaa etompe ruaantompa. Tane warere bolawa osowe mai wana, dia. Ipawa ne ipa warere. ");
INSERT INTO soq_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Tauma ne ituedina Isibt bolawa uduudu atoawolepio onionia apanawa debama segaitaa.” ");
INSERT INTO soq_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Ita warere rin witape wadenaubene Iosep witape ain. Sa ipa warere mukawa me wanene badosan. Ita gara eudida malesawa debama wadene me osowe aine ita seni gold mampe dewalala wadene gadompawe seun. ");
INSERT INTO soq_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Tane do warere atowe Iosep nolalepia baiwa turakawa pue mampe teiteinalala natawa waneno osowe wandi leidie. Ita nolawa apanawa me nambanepe bautantoie antoie mukantoie waiase, “E winlene Iosep mampe iminla emmisitana.” Ita mo epe dewantone mampe me dewasaieno Isibt bolawa uduudu onien. ");
INSERT INTO soq_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Tauma warere Iosep diene wanase, “Ne ipa warere; e dieedina mai mida da Isibt bedewe wisepie e amboiaepie meba insaisawa rua dima da dewasapi, diaida.” ");
INSERT INTO soq_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Tane warere Isibtiwa ebou asiasi Iosep ebowa Sapenat-panea wane itun ita do bola debama On pirisiwa Potipera anoopa Asenat waneno naisen. Ita sape Iosep Isibt bolawa uduudu atoweleno onien. ");
INSERT INTO soq_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Iosep enawa 30 wadeno Isibtiwa warereu atowelene me duwa bedewe nola ualen. Me nola ualene nosene Isibt bolawa uduudu ewamone alen. ");
INSERT INTO soq_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Tane ena 7 bedewe Isibt tawowa bedewe maura debamaia segalen. ");
INSERT INTO soq_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Ena sa 7 bedewe Iosep apana diamono maura sa uwauwantone auweiena Isibt bolawa debama deadea bedewe adibantoiena. Ita bola debama deadea bedewe nana sa irai bedewe uwauwantoia maida auwene adibantoiena. ");
INSERT INTO soq_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Iosep nana sa adibaleno nopainta alen owa nelawa wisiasiawaia rua segalen. Sa baiwa Iosep nana wisiawa en. ");
INSERT INTO soq_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Tane Iosep manainapa On pirisiwa Potipera anoopa Asenat sedawa nata gamomono aupe omana debama segalen. ");
INSERT INTO soq_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Ita Iosep otopa tautuwa ebowa Manase wane itun. Ema ipawa me wane wanase, “Ne God sauneno poka daitada etedina nuaawawasana ita do mida ne mamana duwa bedewe waimoia mai insamopona, dia.” ");
INSERT INTO soq_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Tane me otopa natawa ebowa Eparaim wane itun. Ema ipawa me wane wanase, “Ne poka etanaa bolawa bedewe wainedino God sedana nata amonalene nen.” ");
INSERT INTO soq_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Tane Isibtiwa ena 7 bedewe maura debamawa mampo segalena tauma dialen. ");
INSERT INTO soq_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Ita ena 7 da bedewe Iosep wana rua omana debamaia bola daitada bedewe ualen. Tane Isibt bolawa os bedewe nana winedie. ");
INSERT INTO soq_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Ita walama sawo Isibt apanawa waimoia omana tomono antone warere iririsaia nana wanamopi. Ita warere mo uduudu diamone wanase, “E aitane Iosep ewana ita me dima dialepio rua dewasana.” ");
INSERT INTO soq_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Bola uduudu bedewe omana segalen ita apana Isibtiwa wanwanlala omana pokawa etaidasaiena. Sa baiwa Iosep nana adibaledia duwa moawa wadaubaleno Isibt apanawa wimone nana gimaranton. ");
INSERT INTO soq_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Omana debama segalene bola isiwa do kadimon. Sa baiwa bola sa apanawa wimone Iosep mampe nana gimarantoie. ");
INSERT INTO soq_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Iakob wandie nana wit debama Isibtiwa winedia umanawa etene obampa diamone wanase, “E dima enakoaitilana?” ");
INSERT INTO soq_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Ita me wanase, “Asisuneana, ne nana Isibt bedewe winedia umanawa etana. E sape aitane nana wit gimaraitane winleno nate tounawe wanta ita mai bontata, dia.” ");
INSERT INTO soq_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Sa baiwa Iosep tatatawa 10 nana gimarantopua baiwa Isibtiwa iane antoiena. ");
INSERT INTO soq_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Tane Iakob otopa Beniamin, me ipa Iosep wamba mai wapaaubepono tatatawa do antopona, dia. Ipawa me nuawa inguguralen naita kadiwa donsapia sawa. ");
INSERT INTO soq_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Kanaan bolawa bedewe omana segaleno baiwa Iakob obampa apana isiwa do iane Isibtiwa antoiena nana gimarantopua baiwa. ");
INSERT INTO soq_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Tane Iosep bola sa uduudu atowesane oniedio apana me mampe wimoie nana gimarantoie. Sa baiwa tatatawa me mampe wimone imimpu emmisintone dunentone dogo osowe nambu udanadodeiena. ");
INSERT INTO soq_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Iosep tatatawa ewamone atenmon tane dewalena ewaewawa abo me apana da nambea rua. Sa baiwa aiawa badowa mampe diamone wanase, “E mida, naepeinta wilen?” Ita mo leusane waienase, “No bola Kanaan bedewe wainite nana gimarawa awa winetana.” ");
INSERT INTO soq_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Iosep mo ewamone atenmon tane mo mai me atensapona, dia. ");
INSERT INTO soq_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Tane me tatatawa auenmona insene ita diamone wanase, “E ipa iwu apanawa! Mape wilene no bolamba ewaitusailana, awopawa dainea obasa winedia bedewe odane kadinena baiwa.” ");
INSERT INTO soq_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Tane mo me sipoasane waienase, “Dia, debamamba! No e nolaa dewalala os, nana gimarawa winen.” ");
INSERT INTO soq_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Tauma mo muba gagalontone waienase, “Ulaipa, no wainimba matangelawa donsaitana. Mapo no wainimba poka etene sau umanawa wadio mai nuaparewantepe sausapona, dia. Sa baiwa no tauma sai ema donsaitana.” ");
INSERT INTO soq_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Mo epe waio Ruben wanase, “Ne bauta dialena, oto mampe mai kadiwa dewasata eta, tane e mai ne aiana etape ruawaitapona, dia. Tauma no me bosatana malesawa donsaitana.” ");
INSERT INTO soq_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Tane Iosep Isibt aiawa mampe gagaloleidio sauwa apanawa aia sa leusadie mo aiauwo diamodie. Iosep tatatawa dima waia me etedie atenleidie. Tane mo dima waio me etedie atenleidia mo mai atentoipe, dia. ");
INSERT INTO soq_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Sa baiwa Iosep tatatawa mampo wanase, “Mape mainawoido winlena.” Ita mo me mampentono diamone wanase, “Ne ipa e wanlaida, Iosep, mapo gimaranene Isibtiwa ieiena apanawa. ");
INSERT INTO soq_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Tauma e mai mo gimaraneieno mape winena nuabolawaitana, dia. Ipawa God ne waaubaneno bautantene mape winen apana inawau inasapaa baiwa. ");
INSERT INTO soq_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Ena ema nata bedewe omana debama segalen bola uduudu bedewe, ita ena 5 da nainimbanepe ieia bedewe apana mai iraintopue uwauwantopua rua, dia. ");
INSERT INTO soq_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Tane God ne bautanene waaubaneno mape winena e inawala inasapaa baiwa. Me ina mukawa debama mampe e nosinosila inawaa tawo ema osowe waimoia inamopaa baiwa. ");
INSERT INTO soq_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","E mai ne waaubaneapona, dia. Tane God ne waaubaneno apana debama oniamopina seganten. Do warere duwe waimoia oniamopina ita Isibt tawowa uduudu atonawolepio oniepina baiwa. ");
INSERT INTO soq_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Tauma e tauwadea os ne mamana mampe aitane diane wanaase, ‘E otoa Iosep wanase, God ne dewaneno Isibt tawowa uduudu atonawoleno oniedina. Sa baiwa mai wankasaita ie wina mainawo. ");
INSERT INTO soq_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","E iee bola Gosen bedewe ne tainawo bola wade wana, e ita obana ita atataa, sipsip ita gote, kau ita nitu uduudu e manawoa do iane winlena. ");
INSERT INTO soq_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Tane ena 5 da nainimbanepe winedia bedewe, ne e onialepe nana mampe saulepino Gosen bedewe wanlempa. Naita ne nana mai enalepaa, e ita apana duawo waimoia tane do e nolaa dewalala nana abolawaitane nuapareitana.’” ");
INSERT INTO soq_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Iosep tatatawa tawo Isibt ene leuntone bola Kanaan bedewe anton mambu Iakob mampe. ");
INSERT INTO soq_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ita mo antone mambu diane waienase, “Iosep inawaa wande. Ita me bola sa uduudu atoweleno oniede.” Iakob otopa wandia umanawa etene memesaidalene tane mai sumanaibulepona. ");
INSERT INTO soq_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ita mo Iosep gagalo uduudu wamona me benemasaieno eten. Ita do puraiwa uduudu aimompa turakawa pue mampe teiteinala Iosep wanaubena osowe me wampie iepie Isibtiwa alepia ewamone nuawa aisidene winendewalen. ");
INSERT INTO soq_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Sa baiwa Iakob wanase, “Gagalo ema ipa ulaipa! Ne otona Iosep ipa inawaa wande. Ne anteape me ibuwa ewape muriwa bonteapa.” ");
INSERT INTO soq_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Iakob Kanaan bolawa ene a baiwalene puraiwawa uduudu imaamone ita Isibt bedewe iene alen. Me aleidie bola debama Beasibawo wisene ita pue bomone mamba Aisak Godiwa mampe pulolen. ");
INSERT INTO soq_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Ita tadina sawo me auen rua ewedio bedewe God wanase, “Iakob, Iakob!” Ita Iakob sipoasane wanase, “Oa, ne ema.” ");
INSERT INTO soq_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ita God wanase, “Ne ipa God, e mamaa Godiwa! Isibt bedewe awa mai saitaa, ipawa ne e dewaepo bola sa bedewe dana uarantopu. ");
INSERT INTO soq_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","E Isibtiwa ie aitona ne e do ita ando e dana otamope leumopo bola emawo wimopu. Tane boitawo otoa Iosep witaa nukulepi.” ");
INSERT INTO soq_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Ita Iakob bola debama Beasiba ene, me obampa enane mambu, manamanainapu ita do mo obampu otamone turaka pue mampe teiteinala warere waubamona bedewe aimone ita iane Isibtiwa antoiena. ");
INSERT INTO soq_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","7","Ita do mo pueu uduudu ita nitu uduudu mo mampoa bola Kanaan bedewe wineia otene Isibt bedewe anton. Sa baiwa Iakob duwa bedewe wanwanlala, me obampa mona ita iwoa ita atatawa do otene Isibt bedewe anton. ");
INSERT INTO soq_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","27","Tane apana mida Iakob do Isibt bedewe antoiena atatawa do wisiau 66 waden, tane mai me obampa manamanainapu wisiamopona, dia. Ita Iosep obampa nata Isibtiwa muntoiena mo ipa Iakob atatawa wisiawa odene awodealene 70 waden. ");
INSERT INTO soq_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Iakob Iuda wanaubeno bautalene alena Iosep diepio bola Gosen intawa waeuwamopi. Ita mo wawe antoie Gosen bolawa bedewe wimon. ");
INSERT INTO soq_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Ita Iosep turakawa pue mampe teiteinala a baiwa imaasano winedia osowe odene waine alen Gosenwa mamba Iakob donsapia baiwa. Ita me mamba mampe wisene ewene wadene mampesane ke waie enakasanton. ");
INSERT INTO soq_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Ema aupe Iakob Iosep diene wanase, “Ne winene e inawaa wainiano ibuaida ewana. Sa baiwa ne rua os wainepine bo obasa bonteapa.” ");
INSERT INTO soq_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Tane Iosep tatatawa ita wamba mida me mamba duwa bedewe waimoia diamone wanase, “Ne odape anteape warere diape wapaase, ‘Ne tatatana ita waina mo mida ne mamana duwe wanwanlala bola Kanaan bedewe waimoie mainawo wimoiena. ");
INSERT INTO soq_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Do wapaase, apana ema, mo pue onioniau apanawa ita mo pue oniamoio otootontoi tane mo sipsip, kau, gote ita nitu uduudu mo mampoa otene do wimoiena.’ ");
INSERT INTO soq_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Ita e warere dialepio mampe odane aitana ita me waitaralepie wapiase, ‘E nola dainea dewasailana apanawa?’ ");
INSERT INTO soq_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Tane e me sipoasane wanase, ‘No kerakera wainitana walamawe ita odena tauma debamantenawo no ipa pue onioniala apanawaida wainitana mapo no atatamba dewantoia rua.’ Me epe etepie bola Gosen enalepio bedewe aitane waina, ipawa Isibt apanawa dewau ipa mai apana pue onionialala do awodeantopue wampu, dia.” ");
INSERT INTO soq_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Sa baiwa Iosep alene warere diene wanase, “Ne mamana ita tatatana do mo pueu sipsip ita kau tane nitu uduudu mo mampoa do bola Kanaanwae wimone bola Gosen bedewe waimoi.” ");
INSERT INTO soq_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Ita Iosep tatatawa 5 sonabamone ita banlamone alen warere mampe. ");
INSERT INTO soq_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Mape warere mo waitaramone wanase, “E nola dainea dewasailana apanawa?” Tane mo warere sipoasane waienase, “No nosinosimba ruau pue onioniala apanawa mape winen. ");
INSERT INTO soq_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Walama kerauda os mape winena wanta, ipawa omana debamaia Kanaan bolawa bedewe segalen. No puemba nanau dia, sa baiwa rua ba, dia e wawo no ane bola Gosen bedewe wanta.” ");
INSERT INTO soq_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Warere epe etene Iosep diene wanase, “E mamaa, tatataa ita wana e manawo wimoiena. ");
INSERT INTO soq_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Sa baiwa e Isibt tawowa moawa bola eudida ewee bedewe mamaa, tatataa ita wana do teamowo Gosen bolawa debama bedewe wampu. Tane mo bedeuwo dea da pue onioniau dewawa atembaida me sonabewo alepie ne puena oniamopi.” ");
INSERT INTO soq_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Ita Iosep mamba Iakob banlene alen warere mampe. Tane Iakob warere auwasane ita sau euda osowe itun. ");
INSERT INTO soq_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Tane warere Iakob waitarasane wanase, “E enaa tauma ambi waden.” ");
INSERT INTO soq_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Tane me leusane wanase, “Ne enana tauma 130 waden. Tane sa ipa mai ena debama ita surakau debamaia donsadina. Ita ne enana sa ipa mai ne nosinosina enau rua wadeipona, dia.” ");
INSERT INTO soq_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Ema aupe Iakob warere auwasane ita sau euda me osowe itune ene nosene alen. ");
INSERT INTO soq_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Tane warere wana rua Iosep mamba, tatatawa ita wamba do banlamone Isibt bedewe Ramsis bolawa euda moawa da mo wanamono bola wadane waimoiena. ");
INSERT INTO soq_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Ita Iosep nana wadompe mamba, tatatawa, wamba ita mida me mamba duwe waimoia ita do seda kerakera uduudu ruaulempe odalempe wanamompa. ");
INSERT INTO soq_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Tane walama sawo nana mai wineipe uduudu dialentuwan ipawa omana debamaia Isibt ita Kanaan bolawa bedewe segalen. ");
INSERT INTO soq_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Ita Isibt ita Kanaan apanawa wimoie Iosep mampe nana gimarantoio baiwa maneu diasanatuwaiena. Ita Iosep mane sa uduudu otentue ita alene warere duwa bedewe teamone en. ");
INSERT INTO soq_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Bola Isibt ita Kanaan apanawa maneu dialeno baiwa Isibt apanawa uduudu wimone Iosep diane waienase, “No ewaneiana ba, dia! No bontata baiwantitana ita mane do mainimbo dianton. E nana nenawo nata.” ");
INSERT INTO soq_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Tane Iosep wanase, “Epe segalena baiwa e puela otene winlene neano sipoa ne nana enalepa.” ");
INSERT INTO soq_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Sa baiwa mo pue uduudu otene wimone Iosep waneiena nana wanamopia baiwa. Ita pue isiwa oas, sipsip ita gote, kau ita donki otene wimone dewa ipa deawa dewasaiena. Iosep epe dewalene nana mampe apana ena sa bedewe oniamono waimoie. ");
INSERT INTO soq_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Tane ena da bedewe mo osowe wimone Iosep diane waienase, “Tauma no mai e manawo lagantataa rua. No manemba ita puemba diasatana, mai mainimbo da wineipona, uduudu e manawolentuwan. Tane dea os mainimbo winedia, sa ipa no nubaida ita no tawomba. ");
INSERT INTO soq_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Dima baiwa wane ewaneiano omana bowantata baiwantitana? Rua ba, dia; no nubaida ita tawomba eneeto gimaraite sipoa nana nenawo nate inantata. Tane do no ita tawomba do warere atowentate nolawa dewalala wanantata. Ita e lawuru naumba nenawo iraintate osowe wanta mai bontato tawo nowa di winepi, dia.” ");
INSERT INTO soq_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Tane Isibt apanawa uduudu omana dewamono baiwa tawou waaubantono Iosep gimaramontue warere mampesan. ");
INSERT INTO soq_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Ita Isibt apanawa uduudu epe dewantone warere nolawa dewalala wananton. ");
INSERT INTO soq_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Tane pirisi os tawou Iosep mai gimaralepona ipawa warere mo mane wanamodio mampe nana gimarantoie waimoie. ");
INSERT INTO soq_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Tauma Iosep wanase, “Ewanee, e ita tawola do gimaralenatue warere mampesano me mebaawa wanaiten. Sa baiwa ne tauma lawuru naumba enaledina otene aitane iraitana. ");
INSERT INTO soq_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Tane e iraitonuno ipawa itumpa walamawe uwauwaitane oda 5 teamona. Ita sa bedewe dea warere wanana tane uduudu 4 e wadaitumone naumba ena da bedewe aina baiwa ita do e ita mida dulawo waimoia tane obanla do nanuna baiwa.” ");
INSERT INTO soq_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Tauma apana Iosep diane waienase, “E no inaneana, sa baiwa e meneempa no ideita warere nolawa dewalala wanantena wankasantata.” ");
INSERT INTO soq_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Tane Iosep anaana ituna walamawa sawo ita tauma winedia ruawantoia ipa ema epe, Isibt tawowa uduudu ipa warere mampea, sa baiwa iraitonuna nanala odawa 5 teamona bedewe dea wadane warere mebaawa wanonuna. Ita pirisi tawou warere mai gimaralepona baiwa anaana wadia rua nanau moawa mai warere waneipona, dia. ");
INSERT INTO soq_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Tane Israel apanawa antone Isibt tawowa moawa ebowa Gosen bedewe bola wadane waimoiena. Mo sape waimoie maurantone ita do otootontone uaranton. ");
INSERT INTO soq_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Iakob Isibt tawowa bedewe wandio enawa 17 dialen. Tane waina enawa awodealena ipa 147 waden. ");
INSERT INTO soq_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Tane Iakob bowa walamawa kampaleidio me otopa Iosep dieno mampe wiseno wane wanase, “Naita e ne nuawadawadaneana witaa abuna atowe teamoa ita e euwa ita simbia sauawaitaa. Ne bonteapo mai Isibt bedewe dobosanea, dia. ");
INSERT INTO soq_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Tane ne bubuana walama wisepio mamana ita atana do bubuantonte e awanane Isibt eaie aite mo tampo dobosanea.” Ita Iosep wanase, “Ide rua ne dewasapa.” ");
INSERT INTO soq_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Ita Iakob otopa mampe wane wanase, “Iosep, mainawo sauaitaa.” Ita me saualene wanase, “Oa, ne dewasapa.” Tane Iakob epe etene nuawa euleno dunelene God wadaposisan. ");
INSERT INTO soq_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Walama isiwa diantono aupe apana Iosep diane waienase, “E mamaa kero waden.” Me epe etene obampa Manase ita Eparaim otamone Iakob ewapua baiwa antoiena. ");
INSERT INTO soq_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Mo wimoieno apana ewamone Iakob diane waienase, “E otoa Iosep eweepia baiwa wisen.” Iakob epe etene meba enapona babisadie tane kasawogalene enenwisene ituwa bolawe wain. ");
INSERT INTO soq_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Ita Iakob otopa Iosep diene wanase, “Ne bola Lus Kanaan bolawa bedewe wainedino God Mukamukaua mainawo segalene ita sau euda ne osonawo itune, ");
INSERT INTO soq_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","dianene wanase, ‘Ne e dewaepo obana uarantopu, do dewaepo nosinosia uarantopue uwa daitada segantopu ita do bola ema e nosinosia wanamopo bolauidawanalepio wankasantopu.’” ");
INSERT INTO soq_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Me gagaloleidie wanase, “Tane e obana nata Isibt bedewe wainiano muntono, muriwa ne mape winena, Eparaim ita Manase mo ipa neida nebaana ne obaina Ruben ita Simion ruau. ");
INSERT INTO soq_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Tane e obana isiwa muriwa gamomona sa ipa e ebaa, ita mo ando tatatau Eparaim ita Manase ebou asiasi bolau wadapu. ");
INSERT INTO soq_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Tane ne bola Padanwae leuntene iedino Reitel boleno bola Kanaan tawowa bedewe, sa ipa bola debama Epra (ebowa da waia Beteliem) tampentite ita sape ne nuapareidantedine ita Epra intawa waiwe me dobonten.” ");
INSERT INTO soq_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Ita Iakob Iosep obampa nata ewamone wanase, “Ema e obana ba?” ");
INSERT INTO soq_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Ita Iosep wanase, “Ne Isibt bedewe wainedino God sedana ema nata nen.” Ita me epe etene wanase, “E mo banlamoe mainawo wino sau euda mo osouwo itupa.” ");
INSERT INTO soq_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Tane Iakob gulauidalen emawa oaoaraidalen mai sala ewepidewalepia rua, sa baiwa Iosep sedawa banlamone mampe wiseno me seda sa otamone mampemone isuruwamon. ");
INSERT INTO soq_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Ita Iakob Iosep diene wanase, “Ne insedina ne mai ibua ewapa tane God ne oniadewasanedio e obana do wileno ibula ewana.” ");
INSERT INTO soq_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Tauma Iosep obampa atau abupa osowe waimoia otamone nambemone aupe Iosep dunelene mamba auwasan. ");
INSERT INTO soq_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Tane Iosep obampa nata, Eparaim mamba witapa on deneuwe enene namba Iakob witapa sen deneuwesan. Ita Manase mamba witapa sen deneuwe enene namba Iakob witapa on deneuwesan. Ita banlamone Iakob mampe wisen. ");
INSERT INTO soq_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Tane Iakob witapa leusaitumone on oto kerauwa Eparaim osowe itun ita sen oto tautuwa Manase osowe itun. ");
INSERT INTO soq_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Ita Iakob sau euda Iosep osowe itune wanase, “God mida ne atana Abraam ita mamana Aisak wadaposisaia, God sa ne inawana bedewe walama uduudu oniadewasanedie, me ipa sipsip onionila apanawa rua. ");
INSERT INTO soq_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","God enseliwa poka bedewe ne saunene inanena rua seda ema nata sau euda osouwo itupie oniamopi. Tauma ne rauparintedina, apana ando seda ema ebou asiasi ne ebona, ita do ne atana Abraam ita mamana Aisak ebou insempa. Ita do rauparintedina mo otootontopue tawo ema osowe nosinosiu uarantopu.” ");
INSERT INTO soq_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Mape Iosep mamba Iakob witapa on Eparaim osowe itudio ewene mai menasapona, sa baiwa me mamba witapa wadapaaubepe otopa Manase osowe itupona baiwaleidie. ");
INSERT INTO soq_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Ita Iosep mamba diene wanase, “Mako mai epe dewasaa, ne otona tautuwa Manase uwawa osowe witaa on itua.” ");
INSERT INTO soq_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Tane mamba me aiawa etendabue wanase, “Otona, ne dima atentena rua dewasadina. Manase ando ebowa debamalepi ita do dan ua dea segalepi. Tane me wamba ebowa debamaidalepi ita do nosinosiwa uarantopue dan uwa daitada segantopu.” ");
INSERT INTO soq_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Ita walama sawo me sau euda mo osouwo itune wanase, “Ando Israel apanawa sau euda itutuwa baiwa e ebola wampe wampaase, ‘No rauparintitana God sauwa euda e osoawo itupi, Eparaim ita Manase osouwo ituna rua.’” Me epe wane ita Eparaim ebowa bautasane wan ita muriwa Manase ebowa wan. ");
INSERT INTO soq_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Ita ema aupe Iakob Iosep diene wanase, “Asisunea, ne bo baiwantedina, tane God ipa e do ando banlaepio leuite nosinosia bolauwo wiea. ");
INSERT INTO soq_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Tane e Amori bolawa debama moa kerauda ne isima ita pidu mampe onantene wadana e eneedina mai tatataa ita wanwana wanamopa, dia.” ");
INSERT INTO soq_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Mape Iakob obampa diamono mampe auweieno tauma me wane wanase, “Dima e manlawo ando segalepia umanawa wapo etana. ");
INSERT INTO soq_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Ne obaina, winlene asisuneana! Ne Iakob e mamala asisuneana. ");
INSERT INTO soq_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben, e ipa ne otona tautuwa, ne apana sanaa mukamukaua wainedina walamawe e gamoena. E apana debama ita mukamukaua mai ne obaina isiwa ruau, dia. ");
INSERT INTO soq_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Tane e dewaa ipa abaia noseidie leusaituleidia rua, mai mida enabodaepia rua, dia. Tauma e ando mai eboeboua segaita, dia. Ipawa e mamaa manainapa nata ninaiten ita e mala debamaia ne osonawo ituana. ");
INSERT INTO soq_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Tane Simion e wana Liwai nata e dewala deawaa. E nata onala puraiwa oteile mampe rebareba onaitilana. ");
INSERT INTO soq_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ne ando mai e manlawo wimpa ba e waninala bedewenteapa, dia. Ipawa e nuala kadileidia walamawe apana bomoilana tane do e waninaitilana walamawe kau wau epawirosimoilana wasi baiwa. ");
INSERT INTO soq_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Ita e nata eba nuasigasigaitilana baiwa, God matangelawa osolawolepio kadiwa rebarebaida dewasanuno segalempa. Sa baiwa ne e tanalepo Israel damba waimoia bolau bedewainta deawantana. ");
INSERT INTO soq_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Iuda, e sosoa ando ituposiempa ita e mamaa obampa e manawo imimpu emisintompa, ipawa e emalawoa apanawa gadompau osowe wadadomone aimona. ");
INSERT INTO soq_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Iuda ne otona, e ipa pue onawa laion rua, pue sa moiawa adediboe nadie aupe aleidie bubualeidia rua. Mida wisepie e sinsiepi? ");
INSERT INTO soq_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Ita warere koinawa Iuda witape winepi ita e nosinosia warerentompe waimompo koina sa apanawaida wisepi. Ita dan uwa daitada apanawa me aiawa ruawantompa. ");
INSERT INTO soq_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Tane e manawo wain eubu iawa uarakadilepi ita e donkia wadone aitone wain iawa osowe taunadoe ena, ita e donki otopa sanaa wadone aitone wain iawa euda osowe taunadoe ena. Ita wain ipawa naumpatewampo nampalewae moawa winompo mampe garawa mitamompa. ");
INSERT INTO soq_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Me emawa osinakadilempa wain rua ita moawa nepa sapusapuaida ama sogapa rua segalepi. ");
INSERT INTO soq_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Tane Sebulun, e ando owa tampe bolaa dewasae wana ita e bolaawo waa wimompe odompe obasa euwa bedewe enompa, ita e tawoa alepia makawa bola debama Saidoniwa enepitudepi. ");
INSERT INTO soq_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Ita Isaka, e ipa donki dea mukamukauaida puraiwa saiwa do obasa di ituitona. ");
INSERT INTO soq_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Tane e aitone bola euda ewone wanempe bubuaitona, tane apana da nolau dewasaa baiwa dieempe sai debama osoawo itumpo nolaitona. ");
INSERT INTO soq_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Tane Dan, e ionoite wane apanaa oniamona Israel damba isiwa ruau. ");
INSERT INTO soq_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Tane do e ipa mota kadiwa onawa rua inta waiwe anuitone wanempe ita oas wimompe antompa e rowoitone wau adona. Ita mo poka etompe apana osouwo waimoia epaubamompo nomompa. ");
INSERT INTO soq_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","O Iawe God ne sumanaiantedine intaewaewantedina inanea baiwa. ");
INSERT INTO soq_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Tane Gad, e poi apanawa wadeepue kadiepua baiwantompo e mo onau enee tanamowo antopu. ");
INSERT INTO soq_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Ita Asea, e ando iraitona bedewe nanaa eubu daitada inintompa ita nana sa wadone laulaitona ewaewa eudida warere ewompe nanawa menasampa. ");
INSERT INTO soq_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Tane Napitali, e ipa pue ebowa waia dia, taudosia di leidia rua wanempe sedaa eubu os gamoitona. ");
INSERT INTO soq_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Tane Iosep, e ipa wain naunautetela rua, wain naunautetela sa esa aleidia tampe enede ita ragapu gonaa asiasi inintompe odompe antompa. ");
INSERT INTO soq_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Tane e emalawoa apanawa nuakadintopue ona badowa dewasapue pidu mampe enepue ita kadiwa daitada dewasapu e manawo. ");
INSERT INTO soq_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Ita Iosep, e pidu teinee badowa enakasaitaa mabua mai garigarilepi, dia. Ipawa Iakob Godiwa ipa mukamukaua ita do Israel onioniau Godiwa, me ipa seu e sauepio osowe badowa enakasaitaa. ");
INSERT INTO soq_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Ipawa mamaa Godiwa mida e sauedia ita me mida mukamukauaida sauwa euda osoawosapi, me sauwa euda unu uboe wapiaubepio iepi ita do dogo bedewe esa dewasapio wisepi ita puea otootontompe uarantompa. Ita do e nosinosia uaraia eneepi. ");
INSERT INTO soq_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Tane e mamaa sauwa ipa debamaidalen mai wadi debamau osowe sau iedia rua. Tane e mamaa sauawa ipa debamaidalene wadi uduudu amboiamon. Iosep, tatataa bedeuwoe ionoitaa ita sau euda e osoawolempo wanempa. ");
INSERT INTO soq_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Ita Beniamin, e ipa elo onawaa rua, tadinaida e moia bomone nana tane rawilempo e moia sa kampa odaitona.” ");
INSERT INTO soq_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Tane ema ipa Israel damba 12, ita mo mambu dima insedie ita dewau ewedia rua wane mo deadea osouwo sau euda itun. ");
INSERT INTO soq_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Ita me mo diadewasamone wanase, “Ne bonteape mamamana wawo anteapa baiwantedina. Tane e ne mamamana bontone wineiawo Itai apanawa Epron bolawe guba bedewe dobosaneana. ");
INSERT INTO soq_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Tane guba sa bola Mapela Mamre tampe Kanaan bolawa bedewe winede. Abraam Epron Itai apanawa bolawa uduudu bo teamompa baiwa gimaralene en. ");
INSERT INTO soq_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Ita sape Abraam manainapa Sara nata ita Aisak manainapa Rebeka nata dobosamoiena ita do ne Lea sape dobonten.” ");
INSERT INTO soq_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Tauma Iakob obampa diadewasamono dialeno aupe me wawa nukusamone ita ituwa bolawa oso itulene ita boleno aleupa me nosinosiwa bontone antonawo wawo alen. ");
INSERT INTO soq_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Tane Iosep mamba boleno ewene alene mamba osowe itulene kekesadie ita isuruwasadie. ");
INSERT INTO soq_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Ita Iosep bunama nolawa dewalala apanawa diamona me mamba bolena etepa osowe bunama itupu. Ita mo me etepa osowe bunama ituiena etepa badowa winompa baiwa. ");
INSERT INTO soq_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Tane me boleno mo wimone etepa badolepia baiwa simbiasaie bunamantoio walama 40 dialen. Ema aupe Isibt apanawa kakontoio walama 70 dialen. ");
INSERT INTO soq_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Ita mo bo kakowa waio dialeno aupe Iosep alene warere nolawa dewalala debamawa diene wanase, “Rua ba dia e aite ne baina warere diee waase, ");
INSERT INTO soq_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Ne mamana dianeno mampe sauanten, me wanase, “Ne bonteapa baiwantedina ita bonteapo etena wade leuite aite Kanaan bolawa bedewe bo nagawa ne imaasana bedewe dobosanea.” Sa baiwa me ne waaubanepio anteape mamana dobontape leuntape wimpa.’” ");
INSERT INTO soq_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Ita warere Iosep gagalowa etene wanase, “Ide e saua ituana rua mamaa bolena etepa wadee aite doboite leute wina.” ");
INSERT INTO soq_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Tane Iosep a baiwaleidio warere sauwa apanawa mo eiau ita Isibt apanawa debamau uduudu enane Iosep sausane do anton bo dobontopua baiwa. ");
INSERT INTO soq_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Ita Iosep duwa bedewe wanwanlala, me tatatawa, wamba ita me mamba duwa bedewe wanwanlala uduudu mo do antoiena. Tane otooto kerakera, pue sipsip, gote ita kau os emoieno bola Gosen bedewe wankasanton. ");
INSERT INTO soq_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Tane turaka teiteinalala ita oas osowe wanwanlala apanawa eneieno Iosep ita apana sa uaraia do antoiena. ");
INSERT INTO soq_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Ita mo antone esa Ioadan tampe bola debama Atad bedewe nana wit ipawa ita sewa empuiasaiawo wimoiena. Ita sape mo nuapare kakowa debamaia waie. Tane Iosep nuaparepare dewawa rua dewasadie mamba kewa wadio walama 7 dianton. ");
INSERT INTO soq_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Tane Isibt apanawa bola debama Atad bedewe waine nuaparepare kewa debamaia waie. Ita Kanaan apanawa mo ewamone waienase, “Isibt apanawa ke debamaia wai.” Sa baiwa Kanaan bolawa sa ebowa Abel Misraim wane ituiena. ");
INSERT INTO soq_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Ita Iakob obampa diamona rua, aiawa ruawantone dewasaiena. ");
INSERT INTO soq_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Mo Iakob awanene antone Kanaan tawowa bedewe bola Mamre tampe Mapelawo bo nagawa imaasaienawo dobontoiena. Tane bo teamompa bolawa sa bauta Abraam apana ebowa Epron Itai apanawa mampe gimaralena. ");
INSERT INTO soq_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Sape Iosep mamba dobolene ene aupe me tatatawa, wamba ita do mo mida me warorosane wimoiena uduudu leuntone Isibtiwa anton. ");
INSERT INTO soq_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Ita mo mambu boleno aupe Iosep tatatawa me mampe kadiwa dewasaiena insene santone waienase, “Tauma dauwa no wainimba mampe kadiwa dewasatana sipoa nuawa kadilepio kadinepi.” ");
INSERT INTO soq_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Mo epe insene Iosep mampe gagalo wanaaubene waienase, “No mamamba muriwa bolen, e no do dodomanantata umanawa wanase, ");
INSERT INTO soq_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","E Iosep ema epe diana, ‘E tatataa kadiwa debama manawo dewasaiena, tane ne menanedia e mo kadiu inseadabuasa.’ Sa baiwa no e mamaa Godiwa nolawa dewasaitana apanawa iririeitana kadimba inseadabuasaa.” Tane Iosep tatatawa gagalou etene ke debamaia wan. ");
INSERT INTO soq_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Tauma me sosowa antone me mampe wimone danawe dunentone waienase, “No ipa tauma e nolaa dewalala os atoawontate simbiaente wainenta.” ");
INSERT INTO soq_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Tane Iosep aiawa aiaisiwa obasa mampe wadewasamone wanase, “Ne mai God ita matangelalepa insene saitana, dia. ");
INSERT INTO soq_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Mapo e ne mainawo kadiwa dewasalana, tane God kadiwa leusane euwa mainawo dewasan, ita apana uara mai bontopu, dia, tane inawaa wampu ande eweitana rua. ");
INSERT INTO soq_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Sa baiwa e mai saitana, ne e ita obanla do onialepa.” Me epe wane wasaumone nuau badosan. ");
INSERT INTO soq_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Tane Iosep mamba damba do Isibtiwa waimoio ita me enawa odene alene 110 waden. ");
INSERT INTO soq_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Ita me wandio danawe Eparaim obampa me atatawa muntoiena ita do Manase otopa Maki obampa munton ita mo otene antono Iosep otene danawe teene mebaawa wanamon. ");
INSERT INTO soq_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Tane Iosep tatatawa ita wamba diamone wanase, “Ne bo baiwantedina, God e oniadewasalepie bola emawo wainilana enee leutane bola Abraam, Aisak ita Iakob Godiu sauamonawo tealepi.” ");
INSERT INTO soq_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Ita Iosep Iakob bedewea diamona badowa sauantopu ita me wanase, “God e oniadewasalepio bola emawo ne neaina winedia ideita otene aitana.” ");
INSERT INTO soq_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Ita Iosep enawa 110 wadeno bolen. Tane mo Isibt bedewe bunama me etepa eusampa baiwa simbiasane etepe itune ita kopin bedewe aine eiena. ");
INSERT INTO soq_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Iakob ita obampa, mo manamanainapu ita obampu do Isibtiwa iane antoiena. Mo ebou ipa: ");
INSERT INTO soq_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruben, Simion, Liwai, Iuda, ");
INSERT INTO soq_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isaka, Sebulun, Beniamin, ");
INSERT INTO soq_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Napitali, Gad ita Asea. ");
INSERT INTO soq_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Tane Iosep ipa Isibt bedewe wandie. Ita Iakob obampa ita atatawa do wisiau uduudu ipa 70 waden. ");
INSERT INTO soq_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Tane Iosep ita tatatawa, ita mo mida walama sawo waimoia uduudu bontonatuwaiena. ");
INSERT INTO soq_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Tane me damba Israel apanawa otootontone uarantone baiwa Isibt bolawa uduudu nopesaiena. ");
INSERT INTO soq_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Ena uaraia diantono aupe warere sanaa Isibt tawowa atoweleno oniedie. Warere sa Iosep ita do me nolawa Isibt bedewe dewamona mai atemba, dia. ");
INSERT INTO soq_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Tauma me apanawa diamone wanase, “Asisuneana: Israel apanawa uarantone mukawauida seganton, mai no ruamba. ");
INSERT INTO soq_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Naita emalawoamba apanawa onamba enompo, Israel apanawa mo do awodea onamba enapue kadineputue epue antoputuwapi. Sa baiwa no gagalontate mo uarantoia intawa enatabodata.” ");
INSERT INTO soq_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Sa baiwa Isibtiwa Israel apanawa dewamoieno badowa nolantoiena. Mo oniamompe atouwomompo nolantompa apanawa seganton. Ita mo Israelwa diamoieno bola nata debamau, Pitom ita Ramsis wadamoiena. Sape warere nana ita nitu isiwa do adibalempaa baiwa. ");
INSERT INTO soq_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Isibt apanawa sai debama mo osouwo ituio badowaida mo baibu nolantoie. Tane Israelwa bola sa bedewe uarantone daberarantone bola uduudu wadeiena baiwa mo nuau salen. ");
INSERT INTO soq_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","14","Sa baiwa mo awasinamoie nola badowa wanamoio ita nolantoie poka eteie. Ita mo badowa poka wanamoio biriki dewamoie do paka gadantoie biriki wadadosampa baiwa. Tane do mo diamoio iraibu bedewe nolantoie. Isibt apanawa poka debamaia mo osouwo itune dewamoio badowa nolantoie, mai nuapareuntope emopona, dia. ");
INSERT INTO soq_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Tane warere aiawa badowa mampe apanawa diamone wanase, “Ibru apanawa obampu mona gamomoia otamone esa Nael bedewe aubamonuna. Tane obampu iwoa muntompa ewamonune emonuna.” ");
INSERT INTO soq_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Tane apana dea Liwai damba bedewea enene meba dambaida iwa naisen. ");
INSERT INTO soq_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Ita i sa wandie bulene oto mona gamosan. Oto sa muleno me ewena ewaewawa eudida. Sa baiwa me wadene weregasane wandio uaboa natadea dianton. ");
INSERT INTO soq_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Tane me mai oto weregasapona rua. Sa baiwa me posa ina esa tampe inintoia ebowa paperas mampe dewasaiena wadene, nagawa ia bodipa mampe pasisabodalen. Ita posa sa wadene bedewe oto aine esa Nael osowe itunieno ina esa waiwe inintoia bedewainta alen. ");
INSERT INTO soq_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Tane oto weanapa eseanama enene ewedie, ando me mampe dima segalepi. ");
INSERT INTO soq_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Walama sawo warere anoopa duadi awa iene alen ita me nolawa dewalala iotopa esa waiweinta laie. Sape me posa ina bedeuwointa iedia ewene, ita me nolawa dewalala diamono posa esa bedewe wadane me mampe wimoiena. ");
INSERT INTO soq_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Ita me posa wadenaubene oto kerauda ewen, ita oto sa gegela ke wadio nuaparewalene wanase, “Ema ipa Ibruwa otopu dea.” ");
INSERT INTO soq_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Tane oto weanapa alene warere anoopa diene wanase, “E meneedia, ne anteape Ibru iwa dea diapo wimpie oto ema wadepie e baia amamasapi, ba?” ");
INSERT INTO soq_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Warere anoopa epe etene wanase, “Oa, sa rua, aitaa!” Ita me alene oto inawaida banlene wisen. ");
INSERT INTO soq_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Tane warere anoopa i sa diene wanase, “E oto ema wade aitee ne baina gamosaa, ita ne ando malesaepa.” Ita sape me oto sa wadene alene gamosan. ");
INSERT INTO soq_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Tane oto mulene debamalene ama eno ita banlene wisene warere anoopa waneno wadene otopawanasan. Me oto ebowa ituna Moses, ita me wanase, “Ipawa ne esa bedewee me wadanaaubena.” ");
INSERT INTO soq_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Tane ena uara diantono aupe Moses mulene debamalene ita nosene alen apanawa Ibruwa ewamopia baiwa. Ita Isibt apanawa aia badowa mampe diamoio nolantoio ewamodie. Ita do Isibt apanawa dea enee Moses apanawa dea Ibru apanawa epedio ewen. ");
INSERT INTO soq_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Tane Moses apana iwumodie tane mai apana da me eweipe, dia. Ita me enene Isibt apanawa sa epenboe ita tauwadea dogo tone dobokadikadilene en. ");
INSERT INTO soq_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Tane imonemba Moses osowe nosene apanawa ewamopia baiwa alen. Me alene Ibru apanawa nata muba onantoio ewamon. Ita me ona ualena apanawa diene wanase, “E dima baiwa eba soa epeiana?” ");
INSERT INTO soq_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Tane me leusane wanase, “Ambi waiana, e mida itueno no atoawone ita dodomananeiana? E ne epaneabolepi imana Isibt apanawa epaabolena rua, ba?” Tauma Moses salene ita nuawa bedewe insenase, “Apana uduudu ne kadiwa dewasana umanawa atentoiena.” ");
INSERT INTO soq_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Ita warere wandie Moses Isibt apanawa dea epenbolena umanawa etene Moses bosapona intawa banusadie. Tane Moses sawe weuwane alene Midia bolawa bedewe wankasalen. ");
INSERT INTO soq_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Moses nemonapa Dietero puewa sipsip ita gote oniamodie. Me ipa bola Midia pirisiwa. Walama dea me pue banlamone sala makowa bedewe wadi Sainai bedewe wisen, wadi sa ipa kakaiwaida Iawe God baiwa. ");
INSERT INTO soq_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Sape Iawe God enseliwa me mampe segalen, me ewaewawa ia idie bumedia epawa rua ia kerauda inileidia bedewe idia ewedie. Moses pisiwane ia sa idia ewedie, tane ia sa bumedia mai ia sa kerauda ipatuwapona, dia. ");
INSERT INTO soq_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Me epe ewedie insenase, “Dima baiwa ia sa kerauda inileidia mai ipatuwapona? Ne mampeido anteaape ewapo.” ");
INSERT INTO soq_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Iawe God Moses ia idia mampeido iedio ewene ita ia sa kerauda idi bumedia bedewe sawano apalene wanase, “Moses, Moses.” Ita Moses me sipoasane wanase, “Oa, ne ema.” ");
INSERT INTO soq_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Sape Iawe God wanase, “E mai riaite ia sa kerauda mampeido winea. E bauta waawo sendoro otawiaita, ipawa dogo ema e osowe eneiana ipa kakaiwaida. ");
INSERT INTO soq_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Ne ipa e nosinosia Godiu - Abraam, Aisak ita Iakob Godiu.” Ita Moses aia ema etene me ewaewa saidalene namba rupusan. ");
INSERT INTO soq_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Ita Iawe God wane wanase, “Ne aitamana Isibtiwa ne apanana mampo kadiwa dewasaio ewane ita do ne apanana keu etana mo ne sauna menamode mo atowomoie oniamoia mampo inamopa. Mo poka eteia ne atenten. ");
INSERT INTO soq_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Sa baiwa ne Isibt apanawa mampoe mo inamopaa baiwa iane winen. Ita mo banlamopo Isibt epue antopu bola euda bedewe. Bola sa ipa debama eudida maura bolawa. Tane bola sa bedewe Kanaan, Itai, Amori, Perisi, Iwa ita Sebusi apanawa sape waimoi. ");
INSERT INTO soq_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Ulaipa, ne apanana poka eteie sidantoia kewa ne mainawo wiseno etana. Ita do Isibt apanawa poka debama mo wanamoia ewana. ");
INSERT INTO soq_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Sa baiwa ne tauma waaubaedina Isibt warerewa mampe aite ne apanana Israelwa banlamowo Isibt epue nomopu.” ");
INSERT INTO soq_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Tane Moses God mampe wane wanase, “Ne apana diapanaida. Ambi anteape warere mampe e apanaa banlamopo Isibt epue nomopuaubepu?” ");
INSERT INTO soq_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Ita God me sipoasane wanase, “Ne ipa e do. E Israel apanawa banlamowo Isibt epue nomopuaubepua, e ando wadi emawo ne wadaposineana. Ema epe segalepio ewee ateita, ne e waaubaena.” ");
INSERT INTO soq_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Tane Moses wanase, “Ne anteape Israel apanawa diamope wapase, ‘No nosinosimba Godiu waaubaneno e manlawo winen.’ Ita mo wapuase, ‘Me ebowa ambi?’ Ita ne ambi wape diamopa?” ");
INSERT INTO soq_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Tane God Moses diene wanase, “Ne ipa ne! Ita e Israel apanawa diamoe waase, ‘Me ebowa ipa “Ne ipa ne waaubanen e manlawo.” ");
INSERT INTO soq_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Tane do God Moses mampe wane wanase, “E aite Israel apanawa ema epe diamoa, ‘Iawe God, e nosinosila Godiu, sa ipa Abraam, Aisak, ita Iakob Godiu, me ne waaubanen e manlawo. Ne ebona, Ne ipa ne ebona winakasalala; ando ita ando apana muntompa ne ebona epe wampa.’” ");
INSERT INTO soq_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Tane Iawe God Moses diene wanase, “Ne Isibt warerewa ita me apanawa do mampo matangela ompa wapaaubepo osouwolepi. Ema aupe warere ewepie oalepio aitana. Walama ema osowe me oalepie tanalepio nolene aitanaaubena. ");
INSERT INTO soq_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Sa baiwa tauma nolene aitane Israel apanawa diamone wanase, ‘E uduudu nolene Isibtiwa mida tanlawo waimoia mampo aitane diamono etepu benawa gold ita silwa mampe dewamoia iririwaitano enalepu.’” ");
INSERT INTO soq_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Tane Iawe God Isibt apanawa dewamono Israelwa nuapareunton. Ulaipa, warere nolawa dewalala apanawa debamau ita apana uduudu emauwo, Moses ebowa Isibt bedewe ipa debamalen. ");
INSERT INTO soq_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Sa baiwa Moses alene warere diene wanase, “Iawe God wadiase, ‘Ne tadina pouwe Isibt tawowa bedewainta anteapa, ");
INSERT INTO soq_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","ita seda mona bauta muntona uduudu Isibt bedewe wanwanlala bontopu. Ita iepi alepie nola dewala iwa mida witape wit dewasadie wandia otopa mona tautuwa bolepi. Ita do pue kau obampu tautuwa uduudu bontopu. Tane bo ema warere otopa mampe ualepi, oto sa mamba aupawa wadape nitu uduudu oniamopona. ");
INSERT INTO soq_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Tane Isibt tawowa uduudu bedewe apana ke debamaia wampa. Ke ema rua mai da epe mapo wapona, ita ando mai osowe ke ema rua wapu, dia. ");
INSERT INTO soq_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Tane Israel apanawa mampo mai kadiwa da segalepi, dia. Ita eueuwa elo mai Israel apanawa ba pueu raumopi, dia. Ita ema mampe e Isibt apanawa ateitana, ne Iawe God, Israel apanawa e manlawo empuiamone nambemona.’” ");
INSERT INTO soq_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Ita Moses wanase, “E nolaa dewalala apanawa debamau uduudu wimopue ne mainawo dunentopue wapuase, ‘E apanaa do aitana!’ Ita muriwa ne anteapa.” Tauma Moses nuawa kadileno ita warere ene alen. ");
INSERT INTO soq_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Ita Iawe God Moses diene wanase, “E warere mampe gagaloitono aiaa etepie tane nuawa anatepie badosapi. Epe segalempo ne ginasa isiwa pokawaau Isibt bedewe dewamopa.” ");
INSERT INTO soq_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Tane Moses ita Aron ginasa pokawaau warere emawe dewamoiena. Tane Iawe God me nuawa bodene badosan. Sa baiwa me mai Israel apanawa eiamopono Isibt epe nomope antopona, dia. ");
INSERT INTO soq_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Tane Iawe God, Moses ita Aron Isibt bedewe ema epe diamone wan, ");
INSERT INTO soq_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Uaboa ema dewasano e uaboala bautaa ena deadea bedewe. ");
INSERT INTO soq_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","E aitane Israel apanawa uduudu diamone wanase, ‘Uaboa emauwo walama 10 oso apana uwala du deadea baiwa pue sipsip ba gote sanaa me duwa apanawa do napua baiwa sonabepu. ");
INSERT INTO soq_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Tane apana dea duwa bedewe apana nata os waimoi, ita moia sa uduudupa muba mai napua rua, dia. Naita epe segalepia mo sosou tampo waimoia do awodeantopue napu. Moia sa apana wisiawa ruau ita do napua ruantopue odantopue wanamopu. ");
INSERT INTO soq_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","E sipsip ba gote mona enawa dea wadena etepu eubu sonabamona mai kadiwa, dia. ");
INSERT INTO soq_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","E pue sa onienadewaitana ita uaboa sa bedewe walama 14 wadompo rawiwa omo pamempo Israel apanawa uduudu pue sa bomopu. ");
INSERT INTO soq_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Ita e pue sa osinawa wadane du moa sainapa ita onape wiramone aitana, du sa bedewe nana nanune wanlempa. ");
INSERT INTO soq_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Tane tadina sawo e moia wakadabadabamone sinun sigasigaua ita bured mai ist dola do nanuna. ");
INSERT INTO soq_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","E nanala ema epe nana: a baiwa benaitane wala lomawa taumona ita koinala witalawo otamona. Ita nana tauwadea nanatuwapi. Ema ipa Pasowa odawa ne Iawe God wadaposineana baiwa. ");
INSERT INTO soq_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Tane tadina sa deawa bedewe ne Isibt tawowa uduudu bedewainta anteape apana ita pue obampu tautuwa mona uduudu bomopatuwapi. Ne ipa Iawe God, ita Isibt apanawa godiu wadaposimoia ebou ituaisimopa. ");
INSERT INTO soq_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Tane osina e dula moape winedia sa ipa e wainilana eueuwa. Ita ne osina sa ewape e dula epaiapa. Isibt apanawa matangelamopine e mai kadilepa, dia. ");
INSERT INTO soq_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","E oda ema rua ena uduudu bedewe dewasanuna. Walama ema wisempo odaitonuna ita epe mampe e ne Iawe God dima dewasana insenuna. Ita ando e nosinosila oda ema odantompa, mai epu, dia.’ ");
INSERT INTO soq_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","‘E bured mai ist dola nanuno walama 7 dialepi. Tane oda ualempo walama sa dea bedewe ist uduudu e manlawo duwa wineia otamone aubamona. Oda ema ualempo mai mida bured ist bedewe itune dewasaiena napi, ideita walama 7 diantopu. Tane apana mida walama 7 sa bedewe bured ist dola napia me Israel apanawa mampo wapuaubepuo emopie aidalepi. ");
INSERT INTO soq_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Oda walamawa sa bumpa oso ita ompa osowe wisepia, walama ema nata bedewe e awodeaitonune wadapositonuna. Ita walama sa osowe e mai nola da dewasana, dia. Tane waine nanala os laulaitonuna rua. ");
INSERT INTO soq_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Ita bured tabataba odawa dewasanune, insena ambi walama ema bedewe ne e apanala ita danla banlamono Isibt ene nomoiena. Ita e nosinosila ando ita ando muntompaa walama ema wisempo odawa dewasampe akasantompa.’” ");
INSERT INTO soq_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Tane Moses Israel apanawa debamau os diamono auweieno wanase, “E deadea aitane sipsip ba gote otopa sanaa sonabamone ita bomona. Ita e obanla do Pasowa nanawa dewasane nana. ");
INSERT INTO soq_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","E ia isop ragapa dimbuitane pue osinawa redu bede winedia bedewe aine du moa sainape ita onape wiramone ena, ita mai mida nosepie alepi, ideita walamalepi. ");
INSERT INTO soq_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Tadino Iawe God Isibt bolawa uduudu bedewainta alepie apanawa deadea obampu mona tautuwa bomopituwapi. Tane me osina e dula moa sainape ita onape winedia ewepie epiiepie alepi. Ita bo enseliwa mai epio wisepie dulawo odepie obanla tautuwa bomopi, dia. ");
INSERT INTO soq_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","25","Tane e obanla do tawo Iawe God saualena enalepia bedewe odane, e ita obanla do ema epe dewaitana; e Pasowa odawa ena deadea bedewe insenune dewasanune wankasaitana. ");
INSERT INTO soq_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Tane e obanla waitarantopue wapuase, ‘No oda ema dewasaitana ipawaida dima?’ ");
INSERT INTO soq_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","E mo sipoamone wanase, ‘Ema ipa Pasowa pulowa, Iawe God ebowa wadaposiwa baiwa. Mapo tadina sawo Isibt bedewe Iawe God no dumba eniene alen. Ita Isibt apanawa dubu bedewe obampu tautuwa mona bomon, tane no obainimba emon. Sa baiwa no epe dewantitana.’” Ita Israelwa uduudu dunentone Iawe God wadaposisaiena. ");
INSERT INTO soq_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Sa baiwa Israel apanawa antone dima Iawe God Moses ita Aron diamona ruaida dewasaiena. ");
INSERT INTO soq_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Tadina pouwe Iawe God Isibt sedawa mona tautuwa uduudu bomontuwan. Me warere otopa mampe ualen, ando me aupawa wadape nitu uduudu warere mampea atowelepono oniamopona, ita iene alene dibura apanawa obampu mona tautuwa do bontoiena. Ita do me pue obampu mona uduudu tautuwa bomontuwan. ");
INSERT INTO soq_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Ita tadina sawo warere nolawa dewalala debamau ita Isibt apanawa uduudu enanawimoiena. Du deadea bedewe apana obampu tautuwa bontoiena. Sa baiwa mo uduudu uaantone ke debama waie. ");
INSERT INTO soq_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Tadina sa deawa bedewe warere Moses Aron nata apamone diamone wanase, “Tauwadea nolene aitana, e ita e apanala Israelwa do! Ne bolana ema enaiane aitane Iawe God wadaposisana eba inseilana rua. ");
INSERT INTO soq_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Ita e sipsip, gote ita kau uduudu otamone aitana. Tane aitonune, e Godila iririsano sau euda ne osonawo itupi.” ");
INSERT INTO soq_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Tauma Isibt apanawa diniwa mampe Israelwa diamone waienase, “Naita e mai aitana no uduudu bontatatuwapi.” ");
INSERT INTO soq_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Israel apanawa bola debama Ramsis bedewe waimoie ene wawointa antone bola Sukot bedewe wimon. Tane apana mona wisiau 600,000 waden, tane ioto ita seda mai wisiamopona, dia. ");
INSERT INTO soq_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Mo apana uara isiwa da nambea do anton, mo pueu uara sipsip, gote ita kau do antoiena. ");
INSERT INTO soq_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Isibt apanawa mo waubamoio nomoie baiwa, omo dialeidio diniwantone nanau mai imaasape wadapona. Ita mo parawa gadala mai ist dola otene do antoiena. Sa baiwa mo parawa gadala bedewe mai ist dola dewasane bured tabataba sumoiena. ");
INSERT INTO soq_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Israel apanawa Isibt bedewe waimoiena enawa ipa 430 dialen. ");
INSERT INTO soq_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Iawe God Moses ita Aron diamone wanase, “Pasowa nanawa anaanawa ema epe: Mai apana da nambea nana sa napi, dia. ");
INSERT INTO soq_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Ita e nolala dewala mane mampe gimaramolano baila nolantoia nana sa napua, rua. Tane bauta mo ete nonowa dewawa dewasapu. ");
INSERT INTO soq_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Tane apana da nambea e bedelawo walama kerauda os baiwa waimoia ita do nolala dewasaio malesamoilana, mo mai nana sa napu, dia. ");
INSERT INTO soq_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","E sipsip sanaa Pasowa moiawa du dainea bedewe imasalanawo waine nana, ita mai moia sa kimba da wadane pewa nolena, dia. Ita do mai nepa ainapundepi, dia. ");
INSERT INTO soq_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Tane Israel apanawa uduudu Pasowa nanawa napu mai epu, dia.” ");
INSERT INTO soq_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Iawe God Moses diene wanase, ");
INSERT INTO soq_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Seda tautuwa mona uduudu einapune ne neana. Israelwa sedau mona tautuwa uduudu ita pue obampu mona tautuwa uduudu, ne nebaana.” ");
INSERT INTO soq_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Moses wanase, “Iawe God e banlalepi alepie Kanaan apanawa bolau enalepi, mapo e nosinosila mampo badowa sauamona rua. Me bola sa enalepia, ");
INSERT INTO soq_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","e obanla mona tautuwa uduudu ita pue obampu mona tautuwa uduudu einapune Iawe God wanana. Ipawa apana obampu ita pue obampu tautuwau uduudu ipa me mebaawa. ");
INSERT INTO soq_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Tane e puela donki otopa mona tautuwa leusane wadawada menalepia, sipsip sanaa mampe gimaraitane leusane wadana. Naita e mai pue donki otopa mona leusane wadana, sa ipa e donki sa imumba ainapundepi. Tane e obanla mona tautuwa uduudu gimaramone otamone manlawomona. ");
INSERT INTO soq_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Ita ando e obanla waitaralepue wapuase, ‘Dima baiwa no dewa ema dewasaitana?’ Tane e mo diamone wanaase, ‘Iawe God mukawa debama mampe no Isibt tawowa bedewe wadaaubaneno nonen. Sape no nola pokawa etatana, ita mai malesa do nolantepona, dia. ");
INSERT INTO soq_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Tane Isibt warerewa nuawa badoidaleno no mai eianepono nonepe antepona, dia. Sa baiwa Iawe God Isibt bedewe oto mona tautuwau ita pue obampu mona tautuwau uduudu bomontuwan. Ipawa ema baiwa ne pue obampu mona tautuwa einapune Iawe God wanana, tane oto mona tautuwa uduudu gimaramonune otamonune mainawomonuna.’ ");
INSERT INTO soq_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Dewa ema ipa eueuwa rua e witala osowe ita bena rua nanla osowe winompa, Iawe God mukawa debama mampe no wadaaubaneno Isibt tawowa ete nonen.” ");
INSERT INTO soq_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Ita ema aupe mo bola Sukot ene antone Etam bedewe wimone sala makowa enentudenawo saradountone waimoiena. ");
INSERT INTO soq_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Tane Iawe God nambunepe bautalene banlamodie. Ita walamo me giou bedewe tuatua rua nambunepe enene bautalene banlamodie ita tadino me ia idie bumedia bedewe tuatua rua enene sapa wanamodie banlamodie. Ema epeinta mo walama ita tadina antopua rua. ");
INSERT INTO soq_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Tauma Isibt apanawa Israelwa ene antona umanawa warere dieieno eten, sa baiwa warere ita me nolawa dewala apanawa debamau insaisau leusane waienase, “No ambi dewanten? Israel apanawa ema no emotano nomone antoiena, tauma no nolamba mida dewasapi!” ");
INSERT INTO soq_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Ita warere ona turakawa pue oas mampe teiteinala imaamon ita sorodiawa otamone mampemon. ");
INSERT INTO soq_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Ita me turaka pue mampe teiteinala wisiawa 600 eubu ita do Isibt turakawa uduudu otamon. Ita turaka sa deadea osouwo ona ua apanawa do teamon. ");
INSERT INTO soq_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Tane Iawe God Isibt warerewa nuawa badoidasano Israel apanawa tanamone wauwo alen. Tane Israel apanawa insaisau badowa itune antoie. ");
INSERT INTO soq_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Tane Isibt apanawa mo tanamone antoiena. Warere ita me turakawa pue mampe teiteinalala, sorodia oas osowe wanwanlala ita ona apanawa wimone mo Pi-Airotiwa owa tampe dommoiena ita bola debama Baal-Sepon ipa waiwa dauwo winede. Tane sape Israel apanawa walama kampaida os bola wadane waimoie. ");
INSERT INTO soq_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Warere ita me sorodiawa do mampontoio ita Israel apanawa pisiwane Isibt apanawa onau enapua baiwa ieio ewamone saidantone ita Iawe God mampe sau baiwa iririntoie. ");
INSERT INTO soq_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Ita mo Moses mampe momoduntone waienase, “Isibt bedewe bo nagawa dia, ba? Sa baiwa no banlane mape sala makowa bedewe winene bontata baiwaitiana! Dima no mainimbo dewasaana? ");
INSERT INTO soq_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","No Isibt bedewe wainitana walamawe no dieete watanase, ‘No enea, mai umanamba wana, no Isibt apanawa baibu nolantonte wainenta!’ No Isibt apanawa baibu nolantite wainitana etaetawa euda rua, tane mape sala makowa bedewe bontata baiwantitana.” ");
INSERT INTO soq_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Tane Moses mo diamone wanase, “Mai saitana! Badowa enana, ande Iawe God e inalepia emalawo ewana. Tane Isibt apanawa ema tauma ewamoilana ando mai osowe ewamona, dia. ");
INSERT INTO soq_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Tane Iawe God e adilawolepie saulepi. Sa baiwa badowa enane dainaitana.” ");
INSERT INTO soq_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Tauma Iawe God Moses diene wanase, “E dima baiwa ne mainawo sau baiwa iriritiana? Israel apanawa diamowo antoiawo akasantopu. ");
INSERT INTO soq_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Tane e koinaa owa deneuwesae wadaaposie enono owa empipune awopawa itupio, tauma e nolene sala makowa asiasi sawanointa nawane aitana. ");
INSERT INTO soq_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","E ewona, ne Isibt apanawa nuau badosano walawo iei. Tane Isibt warerewa ita me sorodiawa, ita turakawa pue oas mampe teiteinala ita sorodia oas osowe wanwanla, ne nanaumope aimopo apana ne wadaposineapue iononeapu. ");
INSERT INTO soq_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Ne Isibt warerewa, turakawa pue mampe teiteinala ita sorodia oas osowe wanwanla nanaumope aimopa. Ita Isibt apanawa uduudu atentopu ne ipa Iawe God.” ");
INSERT INTO soq_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Tane God enseliwa Israel apanawa nambunepe bautalene banlamone aleidia leulenitue adiwolene enen. Ita giou budibudi tuatua rua enene bautaleidia leulenitue alene adiwo enen. ");
INSERT INTO soq_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Giou sa Isibt ita Israel apanawa sawanauwo enen. Ita tadina sawo Isibt apanawa mampo dewasano sala dubaidalen ita Israelwa mampo sapa dewasan. Sa baiwa tadina sawo mo mai dommopona, dia. ");
INSERT INTO soq_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Tauma Moses witapa wadenposie owa deneuwesan. Ita Iawe God lanunu badowa omo wiseidiawo dewasano wisen, ita tadina daumawa lanunu owa sune einpundeno dogo makowa segalen. ");
INSERT INTO soq_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Ita owa bela rua wita on ita sen deneuwe eneio sawanointa Israel apanawa nawane dogo makowa asiasi antoiena. ");
INSERT INTO soq_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Tane Isibt apanawa mo tanamone anton. Warere oasiwa, turakawa, sorodia oas osowe wanwanlala uduudu Israelwa tanamone wawo owa bedewe antoiena. ");
INSERT INTO soq_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Tadina bedewe ia iilala tuatua rua ita giou bedewe Iawe God emawa ieno Isibt apanawa ewamone dewamono koakoanton. ");
INSERT INTO soq_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Me turaka wawa kadimon, sa baiwa mo mai turaka sa osowe wampue antopua rua, dia. Ita Isibt apanawa waienase, “Iawe God Israel apanawa adiwolene saumode, no Isibtiwa onamba enede, sa baiwa no sambo ete ana.” ");
INSERT INTO soq_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Tane Iawe God Moses diene wanase, “E owa deneuwe witaa wadaapos ita owa leulepie aupawe wisepie ita Isibtiwa turakau ita sorodia oasiu do osouwointa alepie numamopi.” ");
INSERT INTO soq_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Tauma Moses owa deneuwe witapa wadenposie enedie, ita omo wiseidio owa leulene aupawe wisene itunboden. Tane Isibt apanawa sawo weuwape antopona baiwantoio Iawe God mukawa debama mampe aubamono owa bedewe anton. ");
INSERT INTO soq_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Ita owa leulene aupawe wisene Isibt apanawa osouwointa alene numamon. Ita mai turaka pue mampe teiteinala, sorodia oas osowe wanwanla ba sorodia isiwa da wampona, dia. ");
INSERT INTO soq_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Tane Israel apanawa Iawe God ginasa debamawa mampe Isibt apanawa nanaumone aimona ewane Iawe God sawanton. Ita mo Iawe God ita me nolawa dewala Moses mampo sumanainton. ");
INSERT INTO soq_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Tane Moses ita Israel apanawa wadapos sasawa Iawe God mampe sasantone wane waienase, “Ne sasa mampe Iawe God wadaposisadina, ipawa me emalawoa apanawa oasiu ita turakau pue mampe teiteinala do owa bedewe noanamone nanaumon. ");
INSERT INTO soq_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Iawe God ipa ne mukana ita sasantepina mampe me wadaposisapina ipawa me ne inanen. Me ipa ne Godna sa baiwa ne me wadaposisapina ita me ipa ne mamana Godiwa sa baiwa ne me wadaposisapine ebowa debamasapina. ");
INSERT INTO soq_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Me ebowa ipa Iawe God; Me ipa apana onawaa. ");
INSERT INTO soq_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Me warere turakawa ita sorodiawa ita do me nolawa uwantoia apanawa eubu Owa Bumawa bedewe noanamon. ");
INSERT INTO soq_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Mo seu rua owa bedewe ieieno owa numamon. ");
INSERT INTO soq_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","O Iawe God, e witaa on ipa mukamukauaida, witaa sa mampe wadamoe mususamoe aimoana. ");
INSERT INTO soq_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","E mukaa ionoidoleno emalawoa apanawa nanaumoe aimoana. E nuakadia ia ina idituwadia rua iene mo ituiamon. ");
INSERT INTO soq_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","E nonaua owa tepaleidia suno badolen, ita owa einpue bela rua enen, ita owa makolene badolen. ");
INSERT INTO soq_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Tane emalawoa apanawa asowawalene wanase, ‘Ne mo tanamope anteapa, ita ne mo wadaitumopa, tane mo puraiwau eubu uduudu ne menanedia otamopatuapi, ita isimana teinepaaubepe mo bomopa.’ ");
INSERT INTO soq_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Tane e nonaua mampe owa suano wisene apana numamon, ita mo seu rua owa bedewe monuntone iane anton. ");
INSERT INTO soq_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Iawe God, god isiwa e rua waimoi, ba? Diaida! E dea os ipa ulaipa kakaiwaida, mukaa debamaidalen no saantitana, e ginasa pokawaa dewalala wainiana. ");
INSERT INTO soq_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","E witaa on wadaaposideno tawo moawa awane emalawoa apanawa numamontuan. ");
INSERT INTO soq_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","E nuawadawadaa debama mampe e apanaa inamoana emalawoau apanawa mampoe banlamoano nomoiena. E mukaa debama mampe mo banlamoe e bolaa kakaiwa bedewe teamoana. ");
INSERT INTO soq_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Bola daitada apanawa e dima dewasaana umanawa etane uwauwabobontone saidanton. Pilisitia apanawa saidantone nuau pokaida wadie; ");
INSERT INTO soq_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Tawo Edom apanawa uauntoia memesaidantone saidanton; Moab apanawa debamau santoie etepu uwedie; Kanaan apanawa uduudu santone guribubuntoie. ");
INSERT INTO soq_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Apana uduudu saidantoie. O Iawe God, e mukaa debamaia mo ewane seu rua badontone eneie, no emalawoamba apanawa mampo inaneana danauwointa winene anten. ");
INSERT INTO soq_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Iawe God, e apanaa banlamoe wieana e wadia iwa osowe teamowo wampu, bola sa e sonabeana e wanempa bolawa, bola sa ipa kakaiwaida e eba witaawo dewasana. ");
INSERT INTO soq_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Iawe God, e apana uduudu onapoitone warerekasaitona.” ");
INSERT INTO soq_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Israel apanawa owa bedewe tawo makowa asiasi anton. Tane Isibt warerewa oasiwa ita turakawa pue mampe teiteinala ita turaka wadeia apanawa owa bedewe antono numamon. Ipawa Iawe God owa dewasano leulene wisene apana sa numamon. ");
INSERT INTO soq_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Aron weanapa Miriam, me ipa peroweta. Me sino kerauda wadene ioto isiwa do nomone antone sinou epeie biantoie. ");
INSERT INTO soq_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miriam sasalene wane wanase, “Ne sasa mampe Iawe God wadaposisadina, ipawa me emalawoa apanawa nanaumone aimon, me oas ita turaka pue mampe teiteinala wadeia apanawa noanamono owa bedewe anton.” ");
INSERT INTO soq_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Mape Moses Israel apanawa banlamone Owa Bumawa enee Sua sala makowa bedewe anton. Mo walama natadea bedewe sala makowa bedewainta antoie mai esa da donsapona, dia. ");
INSERT INTO soq_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Tane mo bola Mara bedewe wimone esa donsaiena, esa sa sigasigaua mai napona rua, dia. Ipawa sa baiwa mo bola sa ebowa Mara wane ituiena. ");
INSERT INTO soq_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Tane apana Moses mampe momoduntone waienase, “Tauma no esa dainea nata?” ");
INSERT INTO soq_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Sa baiwa Moses Iawe God mampe sau baiwa rauparileno ia kampa euwasan. Ita Moses ia sa wadene esa bedewe aubeno leulentue esa euda nanala segalen. Ita sape Iawe God apana anaana wanamona ruawantompe waimompa, sa ipa mo wadaetamodia me aiawa ruawantompa ba, dia. ");
INSERT INTO soq_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Me wanase, “Naita ne aiana deaitopa asisudewaitonune ita ne emanawo dewa dodomana dewasanuna ita anaanana ruawaitonuna, ne mai kero enalepa Isibt apanawa wanamona rua, dia. Ne Iawe God e inalepina apanawa, inaledino inawaa wainilana.” ");
INSERT INTO soq_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Ema aupe mo bola Elim bedewe wimoiena. Bola sa bedewe maneu uduudu 12 ita notonkela iawa uduudu 70 eneie. Mo sape saradountone waimoie. ");
INSERT INTO soq_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Tane Israel apanawa uduudu bola Elim enee ita Sin sala makowa bedewe anton, bola sa ipa Elim ita wadi Sainai sawanauwo winede. Mo Isibt ene walama 15 wadedio uaboa natawa bedewe sape wimoiena. ");
INSERT INTO soq_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Ita sape mo osowe Moses ita Aron mampo momodunton. ");
INSERT INTO soq_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Mo waienase, “No Isibtiwa wainitana walamawe Iawe God bonepona dima baiwa enen. Ipawa sape no wainite moia ita nana eubu namoite. Tane e no banlanee mape sala makowa bedewe wileno omana bowantata baiwantitana.” ");
INSERT INTO soq_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Tane Iawe God Moses diene wanase, “Ewee! Ne nana e baila uboe unu rua wapaaubepo iepi. Ita apana walama sa deadea nanawa ruawantompe mo menamodia rua antompe wadompa. Ema epeinta ne mo wadaetamope ewapa, mo ne anaanana ruawantopu ba, dia. ");
INSERT INTO soq_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Wiki deadea bedewe walama 6 osowe apana antompe nanau auwempe posawa nata aimompa walama nata bedewe napua rua.” ");
INSERT INTO soq_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Tane Iawe God Moses diene wanase, ");
INSERT INTO soq_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Ne Israel apanawa momoduntoio etamona. Ema epe diamoa, ‘Rawilempo e moia nana tane tadinaida nuala menasadia rua bured nana. Ema epeinta e ateitana ne ipa Iawe e Godila.’” ");
INSERT INTO soq_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Tane rawileidio nene uaraia wimone bola sa bedewe mo os uduudunton. Tane imonemba tadinaida uma esapa nosene saradontone waimoia bolawa uduudu butasan. ");
INSERT INTO soq_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Ita bola sa butalene winedia makoleno aupe sala uduudu osowe nitu da isana rua segalene winedie. ");
INSERT INTO soq_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Israel apanawa dewa ema ewane mai atentopona, sa baiwa mo muba eda waitarantone waienase, “Sa dima eweitana?” Ita Moses mo diamone wanase, “Sa ipa e nanala Iawe God enalena nanuna baiwa. ");
INSERT INTO soq_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Iawe God ema epe wade, ‘Apana deadea meba nanawa napia ruawalepie nana sa auwepi. Ita apana du dea bedewe waimoia muba baibu posa deadea aimopu.’” ");
INSERT INTO soq_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Sa baiwa Israel apanawa dima God wana rua dewasaiena. Mo isiwa nana debamawa auweiena tane isiwa nana kerauda auweiena. ");
INSERT INTO soq_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Tane mo posa deadea oteieno ruaulen. Ita mai mida da nana debamasadie wadedia moa di winakoalepona, ita mida kerausadie wadedia uduudu wadeieno ruaulen. Du deadea apanawa nana sa wadeieno ruaulen. ");
INSERT INTO soq_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Tane Moses apana diamone wanase, “Mai mida nana wadepiitudepio walama da wadepi.” ");
INSERT INTO soq_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Tane Israel apanawa Moses aiawa mai etape ruawantopona, dia. Mo isiwa nana moawa wadanaitudeieno winedio walama da puwan, ita nana sa kadilene motamotalen. Sa baiwa Moses apana mampo nuawa kadiidalen. ");
INSERT INTO soq_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Walama uduudu tadinaida apana nomoie nana mo napua ruawa os auweie, tane omo wisedie pola wadio nana sa sisiwadie dialeide. ");
INSERT INTO soq_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Wiki deadea bedewe walama 6 osowe apana nomoie nana sa auweie apana deadea baiwa posa nata aimoi walama nata bedewe napua rua. Tane apana eiau wimone Moses waitarasane waienase, “Dima baiwa apana posa nata aimoi?” ");
INSERT INTO soq_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Ita me mo diamone wanase, “Ema ipa Iawe God anaanawa, ‘Imonepi ipa e bubuaitana walamawa. Walama sa Iawe God einpue nambesane kakaisan me meba baiwa. Ande e nanala susuwa menalepia sumona tane nuwa menalepia nuitana. Ita nanala kampa winakasalepia eno winompo ideita walama puwapi.’” ");
INSERT INTO soq_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Mo Moses wana rua, apana nana kampa winakasalena eieno winedio walama puwan ita nana sa mai da kadilepe motamotalepona, dia. ");
INSERT INTO soq_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Moses wanase, “Nana sa ande ema namona mai imonepi, ipawa ande ipa Iawe God walamawaida bubuaitana, sa baiwa e mai nana da apela tampe winompo donsana, dia. ");
INSERT INTO soq_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Walama 6 bedewe e nanala auwenuna tane walama 7 sa ipa Sabat walamawa, walama sawo e mai nana da donsana, dia.” ");
INSERT INTO soq_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Tane walama 7 osowe apana isiwa nomone antone nana auwepona baiwa banuntoie tane mai da donsapona, dia. ");
INSERT INTO soq_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Ita Iawe God Moses diene wanase, “E apana ema epe diamoa, ‘E ambi ne waeuwana ita anaanana mai eteipe ruawaitipona. ");
INSERT INTO soq_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","E insene ateitana Sabat walamawa ipa Iawe God amonawa e baila. Sa baiwa me walama 6 osowe walama nata bedewe nana nane waina ruawa enalen. Sabat walamawa sawo e duwa dainaitane wanlempa, walama 7 osowe mai nolene nana banuwa aitana, dia.’” ");
INSERT INTO soq_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Sa baiwa walama 7 osowe apana mai nana auwepona. ");
INSERT INTO soq_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Ita Israel apanawa nana bured ebowa waia mana. ");
INSERT INTO soq_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Sa baiwa Israel apanawa ena 40 bedewe nana mana naie waimoie. Mo mana naie tounawe antone Kanaan bolawa mampentone waine muba witapo irainton. ");
INSERT INTO soq_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Israel apanawa Sin sala makowa enee antoi. Mo Iawe God wadio rua wanriasantoie antoie. Mo antone bola Repidimwa saradountone waimoie, tane sape mai esa da wineipona apana napu, dia. ");
INSERT INTO soq_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Sa baiwa apana Moses mampe momoduntone waienase, “No esa nenawo nata!” Tane Moses mo sipoamone wanase, “E dima baiwa ne mainawo momoduitilana? Dima baiwa Iawe God rubu osowe ituilana?” ");
INSERT INTO soq_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Apana gadompau makoidaleno esa nanawa menaidamono baiwa Moses mampe momoduntone waienase, “Dima baiwa no, obainimba ita no puemba do Isibtiwa wainitano banlaneano nonene esa abolawa bontata baiwantitana?” ");
INSERT INTO soq_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Sa baiwa Moses Iawe God mampe badowa rauparilen, “Apana ema mampo ne dima dewasapa? Mo seu mampe ne boneapua baiwantoi.” ");
INSERT INTO soq_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Tane Iawe God Moses diene wanase, “E koina mampe esa Nael epaana, koina sa wadee apana nambunepe enee bautaitaa. Tane apana eiau diamowo enapuo do aitana. ");
INSERT INTO soq_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","E ne bola Sainai bedewe seu osowe nananepe enepino ewanea, ita sape e koina mampe seu epawo ita esa nosepio apana wimopue napu.” Moses apana eiau eneio danauwo dewa ema dewasan. ");
INSERT INTO soq_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Ita Moses bola ebowa itune wana Masa ita Meriba, ipawa apana Moses do wawantone ita Iawe God rubu osowe itune waienase, “Tauma no Iawe God do mape, ba?” ");
INSERT INTO soq_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Amalek apanawa wimone bola Repidim bedewe Israelwa do onantoiena. ");
INSERT INTO soq_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Sa baiwa Moses Iosua diene wanase, “E apana isiwa sonabamowo antopue Amalek apanawa do onantopu. Ita imonepi wadi iwa osowe God ne koinana wano wadana wadapaposie enepina.” ");
INSERT INTO soq_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Ita Iosua Moses dima diena rua dewasane Amalek apanawa onau eneia do onatoiena. Ita walama sa deawawo Moses, Aron ita Ea wadiwa odane antoiena. ");
INSERT INTO soq_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Tane Moses witapa wadenposie enedio Israel apanawa ona bedewe mukantoie emalawoau aimoie. Tane me witapa wadediaisidedia walamawe Amalek apanawa mukantoie Israelwa aimoie. ");
INSERT INTO soq_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Moses witapa garigarileno mai wadapaposidepona rua, dia. Sa baiwa Aron ita Ea seu wadane ituieno osowe wain. Tauma mo me tampe enane witapa wadanaposie eneio me witapa mai garigarilepona ideita omo pamen. ");
INSERT INTO soq_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Ita Iosua apanawa do isimau mampe Amalek apanawa onau eneia nanaumone aimoiena. ");
INSERT INTO soq_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Moses manainapa mamba Dietero, Midia pirisiwa, nitu uduudu God Moses ita Israel apanawa mampo dewamodia ita do ambi Israelwa banlamono Isibt ene nomone antoiena umanawa eten. ");
INSERT INTO soq_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Me Moses manainapa ita do obampa mona nata banlamone Moses mampe sala makowa bedewe God wadiwa kakaiwa tampe saradoulene wandia mampe antoiena. ");
INSERT INTO soq_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Tane me andomana iedia wisepona me bauta gagalo wanaubene wanase, “Ne Dietero e nemonaa, e manainaa ita obana mona nata do e ewaewa baiwa ieitana.” ");
INSERT INTO soq_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Sa baiwa mo wimoieno me nosene alene wiwira mampe wadene auwasane isuruwasan ita mo wanwambu ambi waimoia umanawa edawaitaranton. Ita mo eda auwantone ene Moses apewa bedewe anton. ");
INSERT INTO soq_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Moses nemonapa nitu uduudu Iawe God Isibtiwa ita mo warereu mampo dewasana Israel apanawa inamopia baiwa umanawa dien. Ita do mo poka saiwa daitada into donsaio Iawe God saumone inamona umanawa dieno eten. ");
INSERT INTO soq_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Dietero dewa eubu Iawe God Israel apanawa mampo dewamodie ita do Isibtiwa mukau atowe waimoia mampo otaubamone inamona umanawa etene nuawa eulen. ");
INSERT INTO soq_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Dietero wanase, “Ne Iawe God wadaposiedina, ipawa e Isibt apanawa ita do warereu mukau atowe wainilano inalena. Oa, me Israel apanawa Isibtiwa mukau atowe wainilano inalen. ");
INSERT INTO soq_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Ulaipa, tauma ne atenten Iawe God ipa debamawaida mai god isiwa apana wadaposimoia ruau, dia. Ipawa Isibtiwa asoasontoie me apanawa Israelwa oniakadisamoie poka wanamoia mampo saumone inamon.” ");
INSERT INTO soq_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Imonemba Moses kotu wadeia bolawe aisidene waine apana sosou do empuempuntoia gagalowa dodomanasadie. Mo tadinaida wimone eneio ita alene rawilen. ");
INSERT INTO soq_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Moses nemonapa me dewa uduudu apana baibu dewasadio ewene wanase, “Dima baiwa dewa ema uduudu e dewamoiana apana baibu? Dima baiwa nola ema eba os dewasaiano ita apana tadinaida eneio alene rawileide, mo menamodia e gagalou etaa?” ");
INSERT INTO soq_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Ita Moses me sipoasane wanase, “Ne ema dewasadina ipawa apana ne mainawo ieia mo atentopu dima God menasadia rua mo dewasapua baiwa. ");
INSERT INTO soq_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Tane apana nata empuempuntopua ne mainawo wimpuo ita ne mo dodomanamopa mida gagalowa wana ipa dodomana, ita ne God anaanawa ita gagalowa waeuwamopo atentopu.” ");
INSERT INTO soq_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Moses nemonapa leusane wanase, “Dima e dewasaiana ipa mai euda. ");
INSERT INTO soq_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Nola ema ipa saibusaibua e eba os mai dewasaa rua, dia. E ita apana do etela garigariidalepi. ");
INSERT INTO soq_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Tauma ne asisuneano gagaloepa, God ipa e do sauepio ruaite dewasaa. Eulena e apana adiwoite mo empuempuntoia saiwa wadone God mampe gagaloitona. ");
INSERT INTO soq_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","E mo God anaanawa ita gagalowa waeuwadewasamowo atentopu, ita do wanwan dodomana intawa waeuwamowo rua dewasapu. ");
INSERT INTO soq_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Tane do apana uduudu bedeuwo e apana insadewasala sonabamowo mo uwau apanawa wanantopue apana uara, da 1,000 da 100 da 50 ita da 10 oniamopu. Ita apana mida God sawantoia e ewamoie sumanaibuitiana ita do mo mai apana puraiwau mampe nuau teineio gagalou dodomanasaia sonabamoa. ");
INSERT INTO soq_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Mo apana empuempuntoia saiwa atendewantompe dodomanasampa walama uduudu bedewe. Ita empuempu saiwa debama mo wadapue e manawo wimpu tane sai kerakera mo muba dodomasapua rua. Mo e sauepue sai moawa awanepuo ita e saia tekatekalepi. ");
INSERT INTO soq_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Naita e epe dewasaa, God e banlaepi ita etea mai garigarilepi, dia. Tane apana uduudu leuntopue bolawo antopue wanwan euda obasa waimompa.” ");
INSERT INTO soq_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Sa baiwa Moses nemonapa gagalowa uduudu etene rualene dewasan. ");
INSERT INTO soq_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Me Israel apanawa bedeuwo insadewasala apanawa sonabamone teamon uwau apana wanantone mo uara da 1,000 da 100, da 50 ita da 10 oniamoiena. ");
INSERT INTO soq_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Tane mo uwau apanawa ema walama uduudu apana empuempuntoia dodomanasai. Ita empuempu saiwa debama wadeie Moses mampe ieio dodomanasade tane kerakera muba dodomanasai. ");
INSERT INTO soq_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Ema aupe Moses nemonapa Dietero auwasano ita me ene leulene bolawe alen. ");
INSERT INTO soq_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Tane Israel apanawa bola Repidim ene antone Sainai sala makowa bedewe wimoiena. Ita mo wadi Sainai atowe bola dewasane apeu wadamone waimoie. ");
INSERT INTO soq_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Ita Moses wadiwa odene alen Iawe God donsapie nata gagalontopua baiwa ita me apasane diene wanase, “E aite Iakob nosinosiwa Israel apanawa ema epe wae diamoa, ");
INSERT INTO soq_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘E ebaida dima ne Isibt apanawa mampo dewasana ewale ateiten, ita atenla ne inamoia obampu mabupa osowe awanamodie aleidia ruawa ne e mabuna osowe awanalene banlaleno mape mainawo wilen. ");
INSERT INTO soq_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Tauma, naita e ne aiana ita sauana badowa wadanaitue ruawaitonuna uwa daitada apanawa bedeuwo e ipa ne apananaida wanaitana. Tawo uduudu ipa ne nebaana tane mo uduudu bedeuwo ne e sonabalepo apana uwataubuida ne nuana obampa segaitana, ");
INSERT INTO soq_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","do e ipa ne gonaana apanawa wanaitana ita pirisitane uwa da kakaiwaida segaitane ne os baina wanlempa.’ Aia ema wamono etaana aite Israel apanawa diamowo etapu.” ");
INSERT INTO soq_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Sa baiwa Moses wadiwae iene alene uwau apanawa diamono auweiena dima uduudu Iawe God wana rua benemamono eteiena. ");
INSERT INTO soq_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Ita apana uduudu auwene waienase, “Oa, no dewa uduudu Iawe God wana rua dewamota.” Ita Moses apana oantona gagalowa Iawe God benemasan. ");
INSERT INTO soq_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Iawe God Moses diene wanase, “Ne e manawo giou dubawaida bedeweinta wimpe manawo gagalontepino apana etapue atentopu Iawe God gagaloleide ita walama uduudu e sumanaiantompa.” Ita Moses apana dima waiena rua Iawe God benemasano eten. ");
INSERT INTO soq_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Iawe God me diene wanase, “E apana mampo ie aite ande ita imonepi diamowo imaadewadewantompa ne wadaposineapua baiwa ita do garau ideita mitamopu ");
INSERT INTO soq_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","ita walama natadeawa baiwa imaantopu. Walama sawo ne Iawe God wadi Sainai osowe iapo apana uduudu ewaneapua rua. ");
INSERT INTO soq_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","E wadi osowe enapundepio alepi ita mai mida wisepie e maka enapundena ampiboe bedewe odepi. Apana badowa diamoa, mo mai wadiwa odapue antopu ba ibua wirasapu, dia. Mida wadi sa wirasapia me ideita epapubolepi. ");
INSERT INTO soq_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Naita apana ba pue da maka sa enapundena nanausapie alepia e mai apana sa ibuwa wirasana tane e seu ba e mampe bosana. Ita e bui aiawa debama wampo etana sa ipa apana wadiwa antopue wadi atowe enompa.” ");
INSERT INTO soq_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Ita Moses wadiwae iene alene apana diamona dodomanantopu God wadaposisapua baiwa ita do garau mitamopu. ");
INSERT INTO soq_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Ita Moses mo diamone wanase, “E walama natadea iedia baiwa imaaitana tauma ita alepie walama sa wisepia bedewe e mai babadala ba manamanainala do ninaitana, dia.” ");
INSERT INTO soq_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Tane walama natadea bedewe tadinaida uma waie ita kelama lotoie, ita giou dubawaida wadiwa segalene wisen. Ita mo moina debamaia etaetawa bui moinawa rua eteiena. Tane apana sape eneia santone etepu uwauwalen. ");
INSERT INTO soq_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Moses mo banlamono bola mo waimoia ene anton wadiwa God donsapua baiwa ita mo wadi sa atowe eneie. ");
INSERT INTO soq_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Gasu debama wadi Sainai uduudu boden, ipawa Iawe God wadi sa osowe ia idia rua bedewe ien. Gasu sa odene alena ewaewa auni debama suwo gasuwa debama odepia rua oden ita wadi sa uduudu uwauwaidalen. ");
INSERT INTO soq_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Tane bui aiawa wane debamalen ita osoweosowe debamalene aleidie. Ita Moses gagaloleno God aiawa debama uma rua wane me sipoasan. ");
INSERT INTO soq_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Iawe God wadi Sainai osowe iene wisene Moses apasane wanase, “Mape ode winea.” Sa baiwa Moses wadi iwa osowe odene alene Iawe God donsan. ");
INSERT INTO soq_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Ita God anaanawa ema uduudu apana diamone wanase, ");
INSERT INTO soq_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Ne ipa Iawe e Godila, e Isibt tawowa bedewe nolau dewalala wainilano otaubaleno nolelana. ");
INSERT INTO soq_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","E mai god da wadaposisana, dia, ne dea os wadaposineanuna. ");
INSERT INTO soq_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","E mai kokoitau da uba bedewe ba tawo osowe ba esa bedewe tawo atowe wineia inainambu rua dewamona, diaida. ");
INSERT INTO soq_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","E mai mo mampo iminla emmisitane wadaposimona, ipawa ne ipa Iawe God, God obulala mai god da epo aupana wadepi. Apana mida ne dabuaneie eneia mo matangela osouwolepi ita matangela sa do mo obampu, atatau ita nosinosiu osouwo wisepi. ");
INSERT INTO soq_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Tane naita e ne nuawadawadaneane ita aiana etane ruawaitana ne nuawadawadana mai diala e manlawo ita nosinosila ita do mo uaraia ando muntompa mampo winakasalepi. ");
INSERT INTO soq_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","E mai ne ebona rebareba wakadisasana, ipawa ne ipa Iawe e Godila, apana mida ne ebona rebareba wakadisasadia ne me matangelasapa. ");
INSERT INTO soq_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Tane e Sabat walamawa insene onienadewaitana walama sa ipa kakaiwaida ne baina. ");
INSERT INTO soq_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","E wiki uduudu bedewe walama 6 bedewe nolaitonuna, ");
INSERT INTO soq_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","tane walama 7 ipa Sabat walamawa, ita walama sa einapune Iawe e Godila baina ena. Walama sa bedewe mai mida da nolawa dewasapi, dia, mai e, mai obanla ba mida nolala dewalala, ba puela, ba apana da nambea wimone e bolalawo waimoia nolantopu, dia. ");
INSERT INTO soq_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Ipawa walama 6 bedewe Iawe God uba, tawo, owa ita nitu uduudu bedewe wineia dewamontuwan ita walama 7 bedewe nolawa bubuawalen. Sa baiwa ne Iawe God sau euda Sabat walamawa osowesana ita kakaisane neba baina einapune awowasana. ");
INSERT INTO soq_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","E mamaa ita inaa oniadewasamona, epe mampe e wanwanla daumalepi Iawe e Godila bola ema enalediawo. ");
INSERT INTO soq_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","E mai witakadite apana da bosaa, dia. ");
INSERT INTO soq_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","E mai apana da manainapa ba badawa ninasaa, dia. ");
INSERT INTO soq_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","E mai poitaa, dia. ");
INSERT INTO soq_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","E mai kotu bedewe laga mampe apana da kadi wawuwa wae dia, dia. ");
INSERT INTO soq_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","E mai sosola dubu, manamanainapu, nolau dewalala mona ba iwoa, pueu kau, donkiu ba nitubu da mo mampoa ewanuaubuitana, dia.” ");
INSERT INTO soq_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Iawe God wanase, “Naita apana da sowa epepibolepia, mo apana sa ideita bosapu. ");
INSERT INTO soq_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Tane me mai bosapia insepe dewasapona, apana sa sawe weuwapie alepie inawaa wampia bolawa ne sonabepa. ");
INSERT INTO soq_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Tane naita me mida nuawa kadilepio apana da insepidoe bosapie tane me ina insepie me pulo ne baina suia bolawe alepia, mo apana sa ideita wadapuitue nambe antopue bosapu. ");
INSERT INTO soq_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Naita apana da meba mamba ba inawa epepia, mo ideita apana sa bosapu. ");
INSERT INTO soq_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Naita apana da sowa poilepie weregasapia ba apana da mampo gimaralepia baiwalempo donsapua, apana sa ideita bosapu. ");
INSERT INTO soq_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Naita apana mida meba mamba ita inawa saua kadiwa wapie diamopia, apana sa ideita bosapu.” ");
INSERT INTO soq_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Iawe God wanase, “Naita apana da i sanaa mai apana da naisepia baiwa sauasapona lagasapie ninasapia, me nainai mataopa dewasapie i sa wanepie muriwa naisepi. ");
INSERT INTO soq_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Tane i sa mamba apana nainai menasampo toulepia, apana ideita i mamba i sanaa mataopawa ruawalepie malesasapi. ");
INSERT INTO soq_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Tane naita i da baraulempa, mo ideita i sa bosapu. ");
INSERT INTO soq_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Ita naita apana da pue do ninantopua, mo ideita apana sa bosapu. ");
INSERT INTO soq_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Apana uduudu ne os mainawo pulo itumpa, tane naita apana mida god da mampo pulo itumpa apana sa ideita bosapu. ");
INSERT INTO soq_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","E mai apana bola dauwo ieie manlawo waimoia, oniakadisamona, dia, insena e ipa epe bola da nambea apanawa Isibt bedewe wainile. ");
INSERT INTO soq_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","E mai obuobu ba suweibu oniakadisamona, dia. ");
INSERT INTO soq_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Naita e oniakadisamonuno mo sau baiwa ne Iawe God mainawo ke wampo etape saumopa ");
INSERT INTO soq_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","ita do ne nuakadina polapolaua e ilepituwapi sa ipa ona bedewe isima moamoaua mampe emboialepa. Tane manamanainala obuntopue waimompa ita obanla suweibu segantopue waimompa. ");
INSERT INTO soq_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Naita e ne apanana da nuaparelala mane wanamone ita sipoa osowesane debama mai leusane wadawada insena, mane amonalala apanawa dewawa rua, dia. ");
INSERT INTO soq_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Naita e apana da mane wanaa ita me garawa onapea eneepia sauawa eueuwa rua, me e manea sa leusapie eneepi, ita e omo enediawo garawa sa leusae wanaa. ");
INSERT INTO soq_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Ipawa me garawa dea os obasa topio rupulepia. Me gara dainea rupulepie itulepi? Naita e mai gara sa leusae apana sa wanaa, me ne mainawo sau baiwa ke wampo sipoasapa, ipawa ne ipa Iawe nuapare Godiwa.” ");
INSERT INTO soq_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Iawe God wanase, “E mai apana isiwa dewau umanawa etadewasasia di lagau wanune leununa. E mai kotu apanawa mampo lagaitane apana kadi dewasaia wawoitane kadi dewasaia saumona. ");
INSERT INTO soq_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Apana uara dewa dewasaikadisaia e mai ruautane dewasana, dia. Tane e kotu apanawa danauwo enonune gagaloitonune mo isiwa dewantoia rua mai lagaitana. E mai dewa kadiwa intawa wadanaaubeno ita kadi inilepie debamalepi.” ");
INSERT INTO soq_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Tane Iawe God anaanawa ita gagalowa uduudu Moses wanena alene apana diamono eteiena. Ita apana uduudu sipoasane waienase, “No dewa uduudu Iawe God wana rua dewamota.” ");
INSERT INTO soq_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Mape Moses Iawe God gagalowa ita anaanawa uduudu wamona girumalen. Ita imonemba tadina bedewe me enenwisene wadi atowe pulo sumpa watawa dewasan. Ita do me seu uduudu 12 debamau eueuwa baiwa Israelwa damba ruaulene endomon. ");
INSERT INTO soq_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Ita me Israelwa bedeuwo apana sanaau waaubamono antone pue Iawe God mampe pulontopua baiwa bomone sumoiena. Ita do mo wanwan euda me do deantoiena pulowa pue kau otamone pulonton. ");
INSERT INTO soq_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Tane Moses pue osinau moawa laukai bedewe aine en ita moawa da wadene pulo amonantoie suia bolawa butasane alen. ");
INSERT INTO soq_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Ita me saua badowa girumalala wadene wisialeno apana uduudu eteiena. Ita waienase, “Oa, no Iawe God gagalo uduudu wana aiawa ruantate dewasata.” ");
INSERT INTO soq_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Ita Moses osina laukai bedewe winedia wadene apana uduudu osouwo uwakokosane ita wanase, “Ewane, osina ema ipa Iawe God anaanawa me sauawa badowa ema enalena mampe me do deaitena ipawanasadie badosade.” ");
INSERT INTO soq_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Iawe God Moses mampe gagalolene wanase, “E wadiwa ode winewo wainenta. Ne anaanana ita gagalona seu nata tabatabau osowe girumantape eneepo aite apana waeuwamono etompe ruawantompa.” ");
INSERT INTO soq_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","14","Mape Moses ita me sauwa apana Iosua nata a baiwa imaanton. Me apana eiau diamone wanase, “E mape wanlempo no antate leuntate winta. Aron ita Ea e do mape wainilana, apana mida empuempuntompa mo mampo wimopuo dodomanamopu.” Ita Moses Iosua nata a uwantone God wadiwa iwe odane anton. ");
INSERT INTO soq_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Tane Moses God wadiwa odene aidalen ita giou dubaia wisene wadi boden. ");
INSERT INTO soq_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Ita Iawe God sapawa debamaia wadi Sainai osowe ien. Tane giou wadi sa bodene winedio walama 6 dialen. Ita walama 7 bedewe God giou sawanaida bedewe Moses apasana mampe wimpi. ");
INSERT INTO soq_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Tane Israel apanawa wadi atowe waimoie pisiwane Iawe God sapawa debamaia ia debamaia impa rua wadi iwa osowe eweiena. ");
INSERT INTO soq_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Ita Moses giou taunbolenawo odene alene waina walama 40 ita tadina 40 dialen. ");
INSERT INTO soq_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Iawe God Moses diene wanase, “E apana diamowo ape kakaiwa ne baina wadapuo ita ne wimpe mo waimoia bedeuwo wainepina. ");
INSERT INTO soq_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","E ape kakaiwa ita bedewe nitu uduudu aleupu mape euwaepo ewaa ruawaida dewasaa.” ");
INSERT INTO soq_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Mo ia akeisia mampe bokis dewasapu. Ita daumawa 110 sentimita wadepi ita debamalepia sentimitawa 66 ita odepi alepia 66 sentimita wadepi. ");
INSERT INTO soq_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Tane etepa uduudu bedewe ita onape goldida os mampe rupusana ita moawa iawa gold os mampe wadadosana. ");
INSERT INTO soq_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Ita rin uduudu 4 gold mampe dewamone bokis wawa deadea osouwo teamona. ");
INSERT INTO soq_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Tane kewa ia akeisia mampe dewasana ita gold os mampe rupusana. ");
INSERT INTO soq_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Ita e kewa sa rin bedewe neanamowo bokis waiwa dauwo wimopu awanempaa baiwa. ");
INSERT INTO soq_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","E kewa sa rin bedewe aimoe ea, mai teinaubaitaa, dia. ");
INSERT INTO soq_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Ne sauana badowa girumalala seu tabataba nata osouwo girumalala wineia eneepo bokis ema bedewe aimoa. ");
INSERT INTO soq_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Ita e bokis enabodawa ebowa; kadi insempadabuasampa goldida os mampe dewasaa, daumalepia sentimitawa 110 wadepi ita debamalepia sentimitawa 66 wadepi. ");
INSERT INTO soq_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Tane e nitu nata ensel rua mabupu dola ebowa kerubim gold mampe nata dewamoa. E ama mampe gold epamowo kerubim inainambu rua segantopu ");
INSERT INTO soq_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","ita kerubim dea wade baida da osowe itua ita da baida dauwo ituwo ita enabodawa do deantopu. ");
INSERT INTO soq_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Mo nata mabupu lalantopue bokis enabodawa enapubodapu. Ita enabodawa sa onapeinta danau deasapue itupue ewompa. ");
INSERT INTO soq_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Tane e saua badowa seu nata tabataba osowe girumalala wadee bokis bedewe ana, ita enabodawa bokisiwa iwa osowe itua. ");
INSERT INTO soq_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Ita kerubim nata mabupu sawanauwo ita kadi insadabuasampa enabodawa onape sawano saua badowa bokisiwa winediawo ne donepina, ita sape ne anaanana uduudu eneepina Israel apanawa baibu.” ");
INSERT INTO soq_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Tane Iawe God Moses diene wanase, “E tataa Aron ita me obampa Nadab, Abiu, Eliesa ita Itama diamowo wimpu. Israel apanawa bedeuwo ne mo sonabamona ne pirisina wanantopu pulo sumpa baiwa. ");
INSERT INTO soq_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Ita e gara kakaiwa Aron taumpa baiwa dewamoa. Ita me taumopie ewaewawa eulepio apana ewapue sawantopue atowentopue wiwirawantopu. ");
INSERT INTO soq_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","E mo mida ne aten wanamono nitu dewamoia atembuida apanawa diamowo wimpu. Mo os Aron pirisilepia garawa dewasapu, ita e me enapune awowasae ituwo pulo sumpa apanawa segalepie simbianeampa.” ");
INSERT INTO soq_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Tane Iawe God Moses mampe gagalolene wanase, ");
INSERT INTO soq_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“E asisunea, ne Besale Uri otopa Ea atawa Iuda damba bedewe sonabena, ");
INSERT INTO soq_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","ita me ne aleuna mampe nopesana. Ne insaisa euda ita aten me wanana nitu daitada dewasampa baiwa, ");
INSERT INTO soq_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","me iwasawa dewamopaa ipa gold, silwa ita nitu kiborala oau daitada dewamompa, ");
INSERT INTO soq_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","me bena eubuida seu oau daitada nomopie mampe dewamopi, ita do ia tasisamopie oau daitada dewamopi. Me nola ema atemba insaisawa euda wadena mampe dewasapi. ");
INSERT INTO soq_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Ita ne Oliab Aisama otopa Dan damba bedewe sonabena me sausapi. Tane do ne aten insaisawa iwasa apanawa isiwa wanamona nitu uduudu dewamompa baiwa, ne wane dieena rua. ");
INSERT INTO soq_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Ne apena kakaiwa saua badowa bokisiwa ita kadi insadabua enabodawa osowe winedia ita ne apena kakaiwa puraiwawa uduudu dewamopi. ");
INSERT INTO soq_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","Tane wata ita nituwa uduudu, siwa gold mampe dewalala ita nituwa uduudu, ita nitu bonawa euwa piupiu sumompa watawa, ");
INSERT INTO soq_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","tane pulo sumpa watawa ita nituwa uduudu, ita mitamitantompa abomawa do aboma osowe itumpa bolawa. ");
INSERT INTO soq_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","Ita do gara kakaiwa oau eubu, pirisi ionoa Aron garawa ita me obampa garau taumompe pirisi nolawa dewasampa baiwa. ");
INSERT INTO soq_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","Ita do mena dewamopu apana osouwo itumpe kakaimompa baiwa ita piupiu bola kakaiwa baiwa dewamopu. Apana atembuida apanawa nitu ema uduudu dewamopu ne wane dieena rua.” ");
INSERT INTO soq_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Israel apanawa Moses wadiwa odene alene wankasaleidio intawa eweie lewanton. Sa baiwa mo antone Aron mampe wimone enane panane waienase, “E no bainimba god da dewasawo banlanempa. Apana sa Moses Isibt bedewe wainitano banlaneno nonetana, mai atentepona dima me mampe segalen.” ");
INSERT INTO soq_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Ita Aron mo sipoamone wanase, “E komakoma gold mampe dewalala manamanaila, obanla mona ita anoanola asiwo otawiaitane mainawo winlena!” ");
INSERT INTO soq_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Tane apana uduudu antone mo asiwo komakoma otaubamone otene Aron mampe anton. ");
INSERT INTO soq_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Me gold sa otamone dewasano sisiwano ita pue kau mona bunawa inainamba rua dewasano segalen. Ita apana ema ewane mukantone wane waienase, “O Israelwa, god ipa ema no banlaneno Isibt ete nonetana!” ");
INSERT INTO soq_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Aron apana epe dewantoio ewamone me pulo sumpa watawa nambanepe pue kau dewasan ita sabamo gagalolene wanase, “Imonepi no Iawe God mampe oda dewasata.” ");
INSERT INTO soq_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Imonemba tadinaida apana pue isiwa otene wimone pulo sumoiena ituwialepia baiwa tane wanwan euda pulowa dewasaiena naiena. Ita sape mo waine nana ita esa naiena. Tane mo esa nane uwau koakoaleno ninantoie ita dewa kadiuida daitada rebareba dewamoie. ");
INSERT INTO soq_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Iawe God Moses diene wanase, “E tauwadea ie aita ipawa e apanaa Isibt bedewe waimoio banlamoano nomoiena muba kadikadintone miramiranton. ");
INSERT INTO soq_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Mo tauwadea os ne anaanana waeuwamona eiena. Ita mo muba pue kau mona bunawa inainamba rua dewasane wadaposisaie ita pulowantoie. Ita mo waia nitu sa mo godiu Isibt bedewe waimoio banlamono nomoiena. ");
INSERT INTO soq_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Ne ateina apana ema nuau badowaia. ");
INSERT INTO soq_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","E mai ne bodanea, ne nuana kadiidalen mo kadimopa. Tane e ita e nosinosia dewamopo uwa daitada apanawa uaraia segantopu.” ");
INSERT INTO soq_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Tane Moses Iawe God mampe iririlene wanase, “O Iawe God e mukaa debamaia mampe e apana ema banlamoano Isibt ene nomoiena. Sa baiwa e mai nuaa kadiidalepio mo kadimoa, dia. ");
INSERT INTO soq_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Naita e mo kadimoa Isibt apanawa etapue wapuase, ‘E insaisa kadiwa insee baiwa Israel apanawa banlamoano wadiwa wimon ita sape e kadimowo diaidantopu.’ E mai nua kadilepio kadimoa. ");
INSERT INTO soq_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Insea e nolaa dewalala Abraam, Aisak ita Iakob mampo eba eboawo badowa sauaitene waanase, ‘Ne e nosinosia dewamopo uaraia kipora uba tampe wineia rua segantopu. Ita nosinosia bola ema uduudu sauamona wadapu ita mubaauwanalepie winakasalepi.’” ");
INSERT INTO soq_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Sa baiwa Iawe God Israel apanawa kadimopona insaisawaledia en. ");
INSERT INTO soq_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Ita Moses ene leulene seu tabataba nata adiwe ita danawe anaana girumalala awanene wadi ene iene alen. ");
INSERT INTO soq_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Seu ema nata tabatabau ipa God dewasan ita me mebaipa sa osowe girumalen. ");
INSERT INTO soq_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Tane Moses iene wisene mo waimoia tampolene kokoitau kau enedia ita do mo biantoio ewamon. Ita me nuawa kadiidaleno seu sa tabatabau dogo osowe aubamono epatuwialeno sisiwane dianton wadi sa atowe. ");
INSERT INTO soq_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Me pue kau apana dewasaiena wadene ia bedewe suno intuwan. Ita me einsisideno isana wanaleno wadene esa bedewe memenaubene Israel apanawa diamone ita dewamono naiena. ");
INSERT INTO soq_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Ita Moses Aron diene wanase, “Apana ema e manawo dima dewasaiena ita e mo banlakadisamoano kadi debamaia dewasaiena?” ");
INSERT INTO soq_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Ita Aron me sipoasane wanase, “Debamana, e mai nuaa kadilempo do wanempa. E apana ema dewau atena mo insaisau kadi os dewasampe waimompa menamode. ");
INSERT INTO soq_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Sa baiwa mo ne dianeieno pue kau inainamba rua dewasana no banlanempe onianempa baiwa. Mo ne dianene waienase, ‘Apana sa Moses Isibt bedewe wainitano banlaneno nonetana, mai atentepona dima me mampe segalen.’ ");
INSERT INTO soq_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Ne mo diamone wanase, ‘Mo mida mampo bena oaoaua gold mampe dewalala winompa otawiantopu.’ Ita rua mo otawiantone ne neieno ia bedewe aubamono pue kau segalene wisen.” ");
INSERT INTO soq_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Ita Moses Aron ewena me mai apana oniadewasamopia rua, dia, sa baiwa mo emalawoau apanawa mampo ewaewau apana koakoau rua seganton. ");
INSERT INTO soq_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Tane Moses mo waimoia bolawa intawa moape enene mukaleidie wadiase, “Apana mida Iawe God baiwa eneilana ne mainawo winlena!” Me epe wadio Liwai damba apanawa me mampe wimone auweiena. ");
INSERT INTO soq_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Ita Moses mo diamone wanase, “Iawe Israelwa Godiu ema epe wan, ‘E uduudu isimala moamoaua otamone bola wainila bedewe aitane bola sa uduudu bedewe sosolaida, baida sosola ita sosola tanlawoa uduudu bomonatuwapi.’” ");
INSERT INTO soq_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Tane Liwai damba apanawa Moses aiawa ruawantone antone ita walama sa bedewe apana wisiawa uduudu 3,000 bomoiena. ");
INSERT INTO soq_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Ita Moses mo mampo gagalolene wanase, “E Iawe God aiawa etale ruawaitene dewa dodomana dewasale eba obanla ita sosola tanlawoa bomolana. Sa baiwa Iawe God sauwa euda e osolawo itune empualene awowalen ita me pirisiwa wanaitane me nolawaitonuna baiwa.” ");
INSERT INTO soq_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Ita imonemba Moses apana mampo gagalolene wanase, “E kadi rebarebaida dewasalana. Tauma ne leunteape Iawe God mampe anteape e adilawontape Iawe God waaisisapo e kadila dewasalana insepidabuasapi.” ");
INSERT INTO soq_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Ita Moses leulene Iawe God mampe alene diene wanase, “Apana ema kadi rebarebaida dewasaiena! Mo gold otene dewasaieno kokoitau kau segaleno muba godiu wanasane wadaposisaie. ");
INSERT INTO soq_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Ne menanedia mo kadi dewasaiena e inseadabuasa. Tane naita mo kadiu e mai inseadabuasaa mo mida e sonabamoana ebou e bukaa bedewe winedia bedewe ne os ebona e sinieaaubea.” ");
INSERT INTO soq_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Tane Iawe God sipoasane wanase, “Apana mida ne adianananene kadiwa dewasana apana sa ebowa ne bukana bedewe winedia ne siniepaaubepa. ");
INSERT INTO soq_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Tauma aite ne apanana bola dienawo banlamoe aitaa. Ne enselina bautalepie e banlaepi, ita ne walamana wisepio mo kadiu sipoasapo kadi dewasaiena matangelawa donsapu.” ");
INSERT INTO soq_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Ita sape Iawe God matangela debamaia dewasane kero kadiwaida wanaubeno apana osouwoleno poka etaidasaiena. Ipawa Aron pue kau inainamba rua dewasane ituno mo wadaposisaiena. ");
INSERT INTO soq_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Iawe God Moses diene wanase, “E seu nata tabatabau bautaa epatuwiamoana rua dewamoa, ita seu sa osowe ne aiana bauta girumantena rua girumamopa. ");
INSERT INTO soq_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","E imaite imonepi tadina bedewe ode wadi Sainai iwa oso ne doinea.” ");
INSERT INTO soq_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Sa baiwa Moses seu nata tabataba dewamon bautaa ruau ita tadinaida awanamone wadi Sainai osowe odene alen, Iawe God diena rua. ");
INSERT INTO soq_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Ita Iawe God giou asiasi iene sape Moses nata eneie ita me meba ebowaida wan, “Iawe God.” ");
INSERT INTO soq_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Moses enedio danaweinta me wisene aleidie mukaleidie wadiase, “Ne ipa Iawe God! Ne ipa Iawe God! Ne ipa nuana obasa ita nuapare Godiwa, nuana aiaisiwa wainedina ita nuawadawadana apanana baibu ipa debamaia. Ne dima wadina ruaida dewasadina. ");
INSERT INTO soq_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Ne nuawadawadana apanana mampo sabamosapa mo nosinosiu uaraia mai wisiau rua mampo ita mo kadiu rebarebaida dewamoia insadabuamopa. Tane mo mida ne adianananeie aiana eteie mai ruantoipona ne nuakadina apana sa ita mo obampu ita atatau ita mo nosinosiu osouwo iepi.” ");
INSERT INTO soq_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Moses epe etene dogo osowe dunelene nitomalene ita wadaposilen. ");
INSERT INTO soq_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Ita wanase, “Tatana naita e ne ewanee nuaa eulempa ne iririedina mai enea do ana. Tane apana ema nuau badoidaleno kadi dewasaiena, tane e no kadimba inseadabuasa ita e no wadanee eba obanaida wananea.” ");
INSERT INTO soq_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Ita Iawe God me sipoasane wanase, “E asisunea! Ne sauana badowa e Israel apanawa manlawo itudina. E ando ginasa pokawaau ewamona, mai mapo apana da mampo ba bola da bedewe dewamopono ewapona e ewana. Ipawa ne dewa ema e baila dewamopo apana isiwa ewapue santopu.” ");
INSERT INTO soq_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Ita Moses Iawe God nata walama 40 ita tadina 40 wadiwa wankasanton. Ita me mai nana ba esa da napona, dia. Mape Iawe God seu tabatabau osowe saua badowa anaanawa 10 girumalen. ");
INSERT INTO soq_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Moses anaana 10 seu nata tabatabau oso girumala awanamone wadi Sainaiwae iene alen. Me Iawe God nata gagalontoie baiwa namba leulene sapaidawan. Tane me namba sapaida wana mai atenlepona. ");
INSERT INTO soq_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Tane Aron ita Israel apanawa Moses namba sapaidawano ewane ita mo me mampe antopona santon. ");
INSERT INTO soq_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Ita Moses Aron ita mo uwau apanawa apamono mampe wimoiena ita me mo mampo gagalolen. ");
INSERT INTO soq_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Tane Israel apanawa uduudu me mampe wimono, me anaana gagalowa uduudu Iawe God wadi Sainai osowe wanena mo diamon. ");
INSERT INTO soq_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Ita Moses mo mampo gagaloleno dialeno me namba gara mampe lomalenboden. ");
INSERT INTO soq_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Tane Moses Iawe God mampe gagalo baiwa ape kakaiwa bedewe aleidia walamawe me namba lomaleidia wadediaubede. Ita me Israelwa mampo nosedie Iawe God anaanawa diamodio etei. ");
INSERT INTO soq_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Me gagalo baiwaleidia walamawe me gara wadediaubedio me namba sapa wadio ewei ita gagalo diasadie namba rupusade. Tane me Iawe God nata gagalontopua baiwa aleidia walamawe namba lomawa wadediaubede. ");
INSERT INTO soq_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Iawe God Moses mampe wane wanase, ");
INSERT INTO soq_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Uaboa dea ita walama dea bumpe e Iawe God donsampa apewa kakaiwa wadaa. ");
INSERT INTO soq_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Tane e saua badowa bokisiwa bedewe saua anaanawa 10 wineia wadee ape kakaiwa bedewe itua ita gara mampe seuabodaa. ");
INSERT INTO soq_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Ita wata wadee wine itue ita nitu uduudu wata mebaawa otee osowe teaa, ita do siwa nepa endowa wadee wine osowe siwa sumpa ote teaa. ");
INSERT INTO soq_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Tane e wata gold mampe dewalala piupiu sumpa baiwa wadee saua badowa bokisiwa danawe simampe enadodepi, ita ape kakaiwa moawa gara mampe seuabodaa. ");
INSERT INTO soq_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Ita pulo sumpa watawa wadee ape kakaiwa moape odeiawo enadodepi. ");
INSERT INTO soq_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Ita e wau ita witapu mitompa abomawa wadee pulo sumpa watawa ita ape kakaiwa bedewe odaodawa intawa sawanauwo enadodepi. Tane aboma sa bedewe esa memewo nope wisepio ea. ");
INSERT INTO soq_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","E ape kakaiwa ita pulo sumpa watawa gonaite gara mampe intawa moa seuabodaa. ");
INSERT INTO soq_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Ita e mena wadee ape kakaiwa ita bedewe nitu uduudu wineia osouwo memamoa ita nitu sa uduudu enapune awowasaa, ita nitu kakaiwa segantopu. ");
INSERT INTO soq_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Tane mena wadee pulo sumpa watawa ita nituwa uduudu osouwo memamoa ita nitu sa uduudu enapune awowasaa, ita nitu kakaiwa segantopu. ");
INSERT INTO soq_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Ita do mena wadee witapu ita wau mitompa abomawa ita itumpa bolawa enapune nambemoe kakaimoa. ");
INSERT INTO soq_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Tane Aron ita me obampa do otamoe ape kakaiwa moape ita esa mampe duadimoa. ");
INSERT INTO soq_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Ita Aron gara kakaiwa mampe benasaa ita mena me osowe memea ita me enapune nambesawo pirisilepie ne simbianeampa. ");
INSERT INTO soq_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Tane me obampa otamoe wine pirisi garawa mampe benamoa. ");
INSERT INTO soq_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Ita mo mambu osowe mena memeana rua mo osouwo memea ita mo ne simbianeampe pulo sumpa apanawa wanantopu. Tane mena sa mo osouwo memeana mo nosinosiu do pulo sumpa apanawa wanantopue wankasantompa.” ");
INSERT INTO soq_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Iawe God wana rua Moses dewa uduudu dewasantuwan. ");
INSERT INTO soq_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Ita ena nata bedewe uaboa dea ita walama dea bumpe mo ape kakaiwa dewasaiena. ");
INSERT INTO soq_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Moses unsia endolepia bolawa dewamone ita bedeuwo endolen ita kambara ita rou teeno alen ape wadepidodepia baiwa. ");
INSERT INTO soq_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Ita me ape sa dewasane aupe rupu isiwa otene teabodalen tane osowesane onapainta pue etepa mampe ape iwa ita belawa itunboden, Iawe God wana rua. ");
INSERT INTO soq_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Ita Moses seu nata tabatabau otene saua badowa bokisiwa bedewe aimon ita bokisi sa wawa osouwo riniwa dola nagawa bedewe kewa neanamono waiwa dauwo nomoiena. Ita osowe kadi insadabua enabodawa itune boden. ");
INSERT INTO soq_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Tauma me saua badowa bokisiwa wadene alene ape kakaiwaida bedewe itune ita ape bedewe gara seunboden, Iawe God me diena rua. ");
INSERT INTO soq_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Ita do me wata awanene alene ape kakaiwa bedewe gara seudia danawe wita on deneuwe eindoden. ");
INSERT INTO soq_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Ita do me parawa susula Iawe God mampe amonalene wata osowe itun, Iawe God me diena rua. ");
INSERT INTO soq_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Tane me siwa endowa nepa wadene odene ape kakaiwa bedewe wita sen deneuwesane wata enedia waiwa dauwo eindoden ");
INSERT INTO soq_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","ita me Iawe God emawe siwa sumon, Iawe God me diena rua. ");
INSERT INTO soq_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Me watawa gold mampe dewala osowe piupiu sumpo bonawa alempa wadene gara seuiena danawe itun ");
INSERT INTO soq_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","ita me piupiu sun Iawe God me diena rua. ");
INSERT INTO soq_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Tane me gara wadene ape kakaiwa intawa moa seunboden. ");
INSERT INTO soq_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Ita me pulo sumpaa watawa wadene ape kakaiwa danawe itun ita osowe me pulolepia baiwa pue bosan. Ita do me parawa pulolene sun, Iawe God me diena rua. ");
INSERT INTO soq_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Ita me witapu ita wau mitompa abomawa wadene alene ape kakaiwa ita pulo sumpaa watawa sawanauwo itun ita aboma sa bedewe esa memeno nopelen duadi baiwa ");
INSERT INTO soq_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","ita sape Moses, Aron ita me obampa do witapu ita wau mitamoie ");
INSERT INTO soq_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","walamaipa mo ape kakaiwa bedewe odaodawa baiwa ita do pulo sumpaa watawa mampe antompa mo bauta duadintoi, Iawe God me diena rua. ");
INSERT INTO soq_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Ita me ape kakaiwa ita pulo sumpaa watawa gonaalene gara mampe intawa moawa seunboden. Ita mape me nola uduudu diasan. ");
INSERT INTO soq_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Tane giou iene ape kakaiwa lolenboden ita Iawe God sapawa debamaia iene ape sa nopesan. ");
INSERT INTO soq_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Giou iene ape kakaiwa lolenbodae winedie ita Iawe God sapawa debamaia nopesano baiwa Moses mai ape bedewe odapona rua, dia. ");
INSERT INTO soq_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Tane giou ape kakaiwa osowe iedie winedia punwadie ape iwa ediiedia walamawe Israel apanawa eie bola da bedewe antoi. ");
INSERT INTO soq_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Tane giou mai pundepi alepia mo mai nomopue antopu, dia, ideita giou punwapie ape iwa epiiepia walamawe mo nomopue antopu. ");
INSERT INTO soq_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Sa baiwa mo au antoia bedewe walamo giou eweiena ita Iawe God giou sa bedewe wandie, ape kakaiwa osowe ita do tadino giou bedewe ia bumedio eweie. ");
INSERT INTO soq_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Iawe God ape kakaiwa bedewe Moses apasane wanase, ");
INSERT INTO soq_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Israel apanawa mampo gagaloite diamoe ema epe waa, ‘E mida Iawe God mampe pue puloite susuwa meneempa e pue kau, sipsip ba gote wadee wine amonaa itua. ");
INSERT INTO soq_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Tane naita puloa kau wadaa, pulo sa ipa kau mona mai etepa bene dola, dia. Tane pue etepa euda wadee ape kakaiwa moape winea ita Iawe God emawe sa ipa amona euda me wadepie mampesapi. ");
INSERT INTO soq_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Witaa pue sa uwawa osowe itua ita e aupaa wadepie bolepi tane Iawe God pue sa bolepia mampee e dewaa kadiwa mitepiaubepio dodomanaita. ");
INSERT INTO soq_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","E pue kau Iawe God mampe bosae ita Aron obampa pirisi, pue osinapa wadapue ape kakaiwa moape pulo sumpaa watawa enedia sainapainta uwakokosapue antopu. ");
INSERT INTO soq_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Tane e pue etepa loe ita moia nipawa nopuiamoa. ");
INSERT INTO soq_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Ita pirisi ia awanepue pulo watawa osowe teapue ia supuo ipi. ");
INSERT INTO soq_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","9","Tane e pue noe bedewa otawiaite mitaa. Ita moia wawa do moia uduudu noia kepakepau, uwawa ita menawa pirisi wanamowo otepue wata osowe ia bedewe sumopu. Ita pulo sa uduudu mo suiena ipa amona eudida bonabonaua Iawe God mampe.’” ");
INSERT INTO soq_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Iawe God Moses mampe wane wanase, “Naita e pue kau mona ba iwoa awodeantompe nana nampaa amonawa itua, pue sa etepa mai bene ba kero da dola, dia. ");
INSERT INTO soq_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","E witaa pue uwawa osowe itue bosaa ape kakaiwa nope. Ita Aron obampa pirisi pue osinapa wadapue pulo watawa sainapainta uwakokosapue antopu. ");
INSERT INTO soq_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","4","E moia lapawa pue bedewe winedia ita adimoa nata osouwo menawa do ita pue karomba kewakewa eubuida nana nampa pulowa itua ne Iawe God mainawo. Ita pirisi moia ema umanau wamona ne Iawe God mainawo pulontopu. ");
INSERT INTO soq_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Ita mo pulo susula dosapue pulontopu wata osowe. Nana ema mo amonantopua bonawa ipa eudida ne mainawo.” ");
INSERT INTO soq_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Iawe God Moses ita Aron diamone wanase, ");
INSERT INTO soq_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Naita apana etepe bene debama enepia ba bentugu enepie sasanalepia ita apana etepa osinakadilepia, bene sa debamalepie apana sa etepa kadisampo ewapua mo apana sa banlepue Aron mampe ba me obampa pirisilala mampo antopu. ");
INSERT INTO soq_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Ita pirisi sa mo bene me etepe ewadewasasapu ita bene sa bedewe imba sapusaua segalepia ita do bene apana etepa bedeweido iepi alepia, sa ipa kero debamalene kadiwaida segalen. Ita pirisi apana diamopie wapiase, ‘Apana ema Iawe God emawe miramiralen.’ ");
INSERT INTO soq_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Apana mida etepa kadilepia me gara kadiwa pumpumba taupi, ita do me mai uawa sinatalepi dia. Me gara wadepie moawa taupibodepie ita apana mampo wapiase, ‘Ne miramiranten, apana mai tainawo winlena, di diaida.’ ");
INSERT INTO soq_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Ita me walama uduudu etepa kadileidia, me miramiraidalen. Me apana uduudu emopie nosepie alepie meba nambe waimpo ideita etepa inalepi.” ");
INSERT INTO soq_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Iawe God Moses mampe wane wanase, “Apana mida pue bosapia osinapa epio nosepituwapi muriwa moia sa napi. Ita naita Israel apanawa da ba bola da nambea apanawa e do wainilana pue osinawa etepa bedewe wimompo do napia, ne apana sa mampe adina itupa ita me mai ne apanana bedeuwolepi, dia. ");
INSERT INTO soq_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Apana ita pue uduudu inawaa waimoia bedeuwo osina winedio waimoi, osina bedewe ina winede. Ita osina enalena mampe e kadila pulontompa watawa osowe diasana. Me mida pue wadedie wisedie ita osinawa pulontompa watawa sainapainta uwakokosadia apana sa kadiwa dialeide. Ita osina sa kadi diasade.” ");
INSERT INTO soq_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Tane Iawe God Moses diene wanase, ");
INSERT INTO soq_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“E Israel apanawa mampo gagaloite waase, ‘Ne ipa Iawe e Godila. ");
INSERT INTO soq_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","E mai Isibt apanawa dima dewasaia ruawa dewasana, dia. Mapo e bola sa bedewe wainilano ne banlaleno nolen. Do e mai Kanaan apanawa dima dewasaia ruawa dewasana, dia. Ne bola sa bedewe banlalepo odana baiwaitilana. E mai mo dewau ewane rua dewasana. ");
INSERT INTO soq_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Ne ipa Iawe e Godila, ne anaanana ruaitonune ita dima ne wadina ruawa dewamonuna. ");
INSERT INTO soq_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Tane e ne anaanana ita aiana enaledina ruaitonune dewasanuna mampe e inaida bedeweitana. Ne ipa Iawe God wadina. ");
INSERT INTO soq_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Ita e mai eba baida sosola do ninaitana, diaida. Ipawa ne ipa Iawe God aiana etane ruaitana. ");
INSERT INTO soq_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Ita do e mida nainailala manamanainala uaboa wadamodia walamawe mai do ituitana, dia. ");
INSERT INTO soq_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","E mai soa da tanawoa manainapa do ninaitana ne emanawo eba miramiraitaa sawa. ");
INSERT INTO soq_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","E obanla mai otamone god lagawaa ebowa Molek pulontoia watawa osowe puloitane sumona, dia. Naita e epe dewasana God mampe mala ituna. Ne ipa Iawe e Godila. ");
INSERT INTO soq_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Ita mai apana da mona sowa mona nata ninantopu i nata ninantoia rua, diaida. Sa ipa dewa kadiwaida ne emanawo. ");
INSERT INTO soq_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Ita mai apana da mona pue iwoa do ninantopu, dia. Ita do mai i da pue mona do ninantopu, di diaida. Sa ipa dewa kadiwaida. ");
INSERT INTO soq_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","E mai dewa inainambu ema ruau dewamone miramiraitana, dia. Apana bola Kanaan bedewe wanwanlala dewa inainamba ema dewamoia mampe ne emanawo kadintone miramiraidanton. Sa baiwa ne mo tanamopo nomopue antopuo aupo e odane waina.’” ");
INSERT INTO soq_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Tane Iawe God Moses diene wanase, ");
INSERT INTO soq_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“E Israel apanawa auwamoe diamoe waase, ‘Ne kakaiwa dodomana wainedina rua e kakaiwa dodomana wanlempa. ");
INSERT INTO soq_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Apana mida kadiwa manawo dewasapia e mai kadi sa wadone nuaawo itune insene wanempa, tane apana sa mampe aite nata gagaloitane kadiwa sa dodomanasana, ipawa me kadiwa nuaawo winompe kadiepia sawa. ");
INSERT INTO soq_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","E mai soa manawo kadiwa dewasapio sipoasaa ba nuawo ituwo wimompa, dia. Tane sosoa nuawadawadamona eba nuawadawadaitiana rua. Ne ipa Iawe God aiana ruawaitana.’” ");
INSERT INTO soq_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Iawe God Moses mampe wane wanase, “E Israel apanawa diamoe waase, ‘Apana da menasadia dewa da ipawa atenlepona me ne mainawo iririlepi. Tane mai apana mo mida bolala mampo gagalontoia mampo aitane gagalo ipawa ateitana baiwa iriritano dialepu. Naita mida epe dewalempa ne me mampe adina itupa ita mai ne apanana bedeuwolepi, dia.’” ");
INSERT INTO soq_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Iawe God Moses diene wanase, “Israel apanawa diamoe waase, ‘Apana mida sowa epepia sipoa apana sa epapu. ");
INSERT INTO soq_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Tane naita apana mida sowa neaipa da epepitewapia sipoa apana sa neaipa epaputewapi. Ita do apana da sowa emawa empisopodepia sipoa apana sa emawa empusopodepi. Tane apana da sowa moa nepa epepitewapia sipoa apana sa moa nepa do epaputewapi. Apana mida kadi inainamba ema rua da dewasapia sipoa kadi deawa me mampe dewasapu. ");
INSERT INTO soq_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Ita apana mida sowa puewa bosadia me puewa wadepie pue sa sipoasapi. Ita apana mida sowa bosadia sipoa me bosapu. ");
INSERT INTO soq_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Ne ipa Iawe e Godila, sa baiwa anaana ema ipa e uduudu baila, mo Israelwa ita bola da apanawa wimone e do wainilana do baila.’” ");
INSERT INTO soq_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Iawe God Moses mampe wane wanase, ");
INSERT INTO soq_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Aron ita me obampa mona do ema epe diamoa, E sau euda Israel apanawa osouwo itune ema epe waa, ");
INSERT INTO soq_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‘Iawe God sau euda e osolawo itupie ita oniadewasalempa. ");
INSERT INTO soq_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Iawe God e manlawo oiwawalepie ita nuaparewa sauwa euda manlawo itupi. ");
INSERT INTO soq_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Iawe God namba manlawosapi ita wanwan euda obasa enalepi. ");
INSERT INTO soq_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Mo ne ebonawo Israel apanawa osouwo sau euda itumpo, ne do saisaisape sau euda mo osouwo itupa.’” ");
INSERT INTO soq_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Iawe God Moses mampe wane wanase, ");
INSERT INTO soq_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“E Israelwa damba 12 bedeuwo uwaulepia apanawa deadea sonabamowo antopue bola Kanaan ne mo wanamodina ewaitusapu.” ");
INSERT INTO soq_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Sa baiwa Moses Iawe God wana rua Paran sala makowa bedewe Israel damba 12 bedeuwo uwaulepia apanawa deadea sonabamone waaubamono anton. ");
INSERT INTO soq_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Moses ewaitu apanawa waubamone diamone wanase, “E Negeb bolawa bedewainta odane wadiwa aitana. ");
INSERT INTO soq_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Ita sape wilene bola ewana, sape apana mukamukaua ba oaoarau waimoi ita do apana nataida ba uarau waimoi. ");
INSERT INTO soq_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Ita do bola ewane ateitana tawo kadiwa ba, euda? Do bola debama ewana, gonaala ba, dia? ");
INSERT INTO soq_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Tane do dogo bedewe mauralala ba ipasiawaia? Tane do ia inintoi ba, dia? E rubusane bola sa nanawa ipawa aisamone do otene winlena.” (Walama sawo, ipa wain bautaa uwauwa walamawa). ");
INSERT INTO soq_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Sa baiwa mo ene antone sala makowa ebowa Gin Kanaan tawowa bedewe wimone odane antone Reob bedewe Lebo-amat tampe bola ewaitusaie. ");
INSERT INTO soq_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Ita walama 40 dialeidio apana sa bola ewaitusaie laia leuntone wimoiena. ");
INSERT INTO soq_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Mo leuntone Moses, Aron ita Israel apanawa mampo Kadesiwa Paran sala makowa bedewe wimoiena. Ita mo bola sa eweiena umanawa diamoiena ita do bola sa bedewe nana aisamoiena otamone wimone euwamoieno eweiena. ");
INSERT INTO soq_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Ita mo diamone waienase, “E no waaubanelano bola sa bedewe antene ewatana ipa, bola euda, tawo maurala ita irai inintoia euda. Bola ipa nanawa aisamotana ema ambi no otete winen. ");
INSERT INTO soq_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Tane apana bola sa bedewe waimoia ipa mukamukaua ita bola debamau sa bedewe waimoia ipa mubu debamawa, ita do bola sa gonaantoia belawa ipa badowaia. Ita no sape apana ebowa Anak damba mubu daumau debamauia waimoio ewamotana. ");
INSERT INTO soq_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Ita Amalek apanawa Negeb bedewe waimoi ita Itai, Sebusi ita Amori apanawa wadi sainapainta waimoi, tane bola Kanaan apanawa Mediterenian Owa tampe ita isiwa Ioadan esawa tampe waimoi.” ");
INSERT INTO soq_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Ita Keileb apana Moses tampe eneia diamono dainantoieno ita wanase, “No rua os apana sa nanaumote aimote bola sa wadata, sa baiwa no tauma odate nuba baimba onantate aimote bola wadata.” ");
INSERT INTO soq_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Tane apana mida Keileb do odane bola sa bedewe antona waienase, “Dia, apana sa mukamukaua mai no ruwamba, no mai rua antate ita mo do onantata.” ");
INSERT INTO soq_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Ita mo Israel apanawa bola sa eweiena lagawa gagalowa wane waienase, “No antene bola sa ewatana apana wanwanbu kadisade ita apana uduudu sape waimoia mubu dauma debamau ewamotana. ");
INSERT INTO soq_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Tane do no apana ebou Nipiliwa sape waimoio ewamotana, mo ipa dan ebou Anakwa nosinosiu. Mo no ewaneia ita do no nuba inainanimba eweitana no ipa kerakera kapoi ruau wainitana.” ");
INSERT INTO soq_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Ita Israel apanawa uduudu ke debamaia waio aiau moinawa oden, ita mo tadino ke wakasanton. ");
INSERT INTO soq_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Mo uduudu Moses ita Aron mampo momoduntone waienase, “No enepono Isibtiwa wainipe bontepona ba enepono mape sala makowa bedewe bontepona. ");
INSERT INTO soq_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Dima baiwa Iawe God banlaneno bola emawo odeitana ita apana ewanepue epanepubolepi? Ita ema aupe mo no manamanainamba ita obainimba otamopue mampomopu diburala ruau. Sa baiwa eulena no leuntate Isibtiwa ana.” ");
INSERT INTO soq_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Ita mo muba gagalontone waienase, “No uwamba apanawa sonabeta me banlanepio leuntate Isibtiwa ana.” ");
INSERT INTO soq_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Tane Moses ita Aron mo epe momoduntoio etamone Israel apanawa uduudu danauwo aisintone dunentone nambu dogo osowe ien. ");
INSERT INTO soq_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Ita Nun otopa Iosua ita Iepunes otopa Keileb, mo nata iwu apanawa do iwuntoie bola ewamoie laia nuau pareidaleno garau wadapuiamoiena. ");
INSERT INTO soq_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Ita mo Israel apanawa uduudu diamone waienase, “No antene bola sa uduudu ewatatuwan ita bola sa ipa eudida. ");
INSERT INTO soq_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Naita Iawe God no mainimbo nuawa eulempa me no banlanepie wimpie bola ema nenepio bedewe wanta. Bola sa ipa maurala ita irai inidewantoie winei do pue uara waimoi. ");
INSERT INTO soq_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Tane e mai Iawe God adiananasana, dia. Ita no bola sa apanawaida nanaumote aimota rua, sa baiwa e mai apana sa sauitana. Iawe God ipa no do, mo mai saubu apanawa da adiwo eneipona saumopi, dia. Sa baiwa e mai mo sauitana, dia.” ");
INSERT INTO soq_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Ita apana uduudu waiena mo seu otepe Iosua ita Keileb epaboiamopona. Tane Iawe God sapawa debamaia Israel apanawa uduudu ape kakaiwa danawe eneio mampo segalen. ");
INSERT INTO soq_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Tane Iawe God Moses ita Aron diamone wanase, ");
INSERT INTO soq_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Apana ema kadiu walama dainea ne mainawo momoduntoia epu? Ne Israel apanawa mainawo momoduntoie wakadisaneio etamona. ");
INSERT INTO soq_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","E ema epe wane diamona, ‘Ulaipa, e dima walano ne asinawo etana rua dewasapa. ");
INSERT INTO soq_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","E uduudu mida ne mainawo momoduitena enala 20 ita odene su alena ona baiwa wisialeiena sala makowa bedewe boitana. ");
INSERT INTO soq_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","E uduudu bola saualena bedewe ne itulepono wampona mai wilena rua, dia. Tane Iepunes otopa Keileb ita Nun otopa Iosua mo os bola sawo odapu. ");
INSERT INTO soq_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","E momodulala walanase, No emalawoamba apanawa wimopue obainimba kerakera otamopue antopu, tane ne, Iawe God mo wadamope wimpe bola sauala kanaan bedewe e mai odaoda menaleiponawo teamopa. ");
INSERT INTO soq_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Tane e sala makowa bedewe boitana. ");
INSERT INTO soq_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Ita ena 40 bedewe obanla gamo onionia apanawa ruau sala makowa bedewe waimompo ideita e uduudu boitanatuwapi. Ipawa e mai ne aiana etape ruawaitapona baiwa e sedala nuaparentopue poka etapu. ");
INSERT INTO soq_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","E bola ewaitusaile leilano walama 40 dialena rua ne e matangelalepo ena 40 dialepi, ita walama sa deadea matangelawa ena deadea matangelalepa. E ne dewanealano onala apanawa segantena baiwa ne e dewalepo pokaida etana.’ ");
INSERT INTO soq_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Ne, Iawe God, wadina ipawaida dewasape apana ema ne onana eneie adianananeia bomopa. Mo mape sala makowa bedewe bontopuo aupau winepi.” ");
INSERT INTO soq_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Uaboa dea ualeidio bedewe Israel apanawa uduudu Gin sala makowa bedewainta wimone sape Kadesiwa waimoie. Ita sape Miriam boleno dobontoiena. ");
INSERT INTO soq_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Mo sape waimoie esa dialeno baiwa apana uduudu awodeantone Moses ita Aron mampo momoduntoiena. ");
INSERT INTO soq_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Mo Moses mampe momoduntone waienase, “No menaidanedia sosomba bontona rua sape enepono God emawe bontepona. ");
INSERT INTO soq_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","E dima baiwa Iawe God apanawa banlaneano mape sala makowa bedewe winen no ita no puemba do bontata baiwa, ba? ");
INSERT INTO soq_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","E dima baiwa no Isibtiwa wainitano banlaneano mape bola kadiwaida bedewe winetana? Ita mape no mai wit ba karakai, wain ita ia ebowa pomegerenet ipawa aimota rua, dia, ita do esa abolawantitana.” ");
INSERT INTO soq_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Tane Moses ita Aron apana auweia emone antone mo awodeantoia apewa moape wimone dunentone nambu dogo osowe ituiena. Ita mo epe dewantoio Iawe God sapawa debamawa osouwo ien. ");
INSERT INTO soq_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Ita Iawe God Moses diene wanase, ");
INSERT INTO soq_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“E koinaa wadaa, ita tataa Aron do apana diamono auwepu. Ita apana uduudu ewalempo emauwo nau emanta mampe wawo esa debamawa naimepie nosepi. Ita apana ita do pueu uduudu baibu esa nau bedewe nosepio napu.” ");
INSERT INTO soq_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Ita Moses Iawe God wana rua dewasan. Sa baiwa Iawe God wana rua Moses mampe koina winedia waden, me diena rua. ");
INSERT INTO soq_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Tane Moses ita Aron apana uduudu diamoieno auweieno me diamone wanase, “E momodulala asisuitana, no nau ema bedewe esa dewasato nosepio nana!” ");
INSERT INTO soq_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Ita Moses koina wadene walama nata nau epeno ita esa debama noseno apana uduudu ita mo pueu do naiena. ");
INSERT INTO soq_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Tane Iawe God Moses ita Aron diamone wanase, “E ne bedenawo mai sumanaitape ita ne kakaiwaida wainedina sabamoneapona Israel apanawa mampo, sa baiwa e mai apana ema banlamono bola ne wanamodinawo odapu, dia.” ");
INSERT INTO soq_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Israel apanawa bola Meriba bedewe Iawe God mampe momoduntoiena. Ita bola sa bedewe me euwamon mo bedeuwo me ipa kakaiwaida. Ebo Meriba ipawaida ipa Momoduntoiena. ");
INSERT INTO soq_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Israel apanawa uduudu Kadesi ene antone wadi Oa tawo Edom alena makawa tampe wimon ita Iawe God Moses ita Aron diamone wanase, ");
INSERT INTO soq_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“E Meriba esawa bedewe ne aiana mai ruawaitapona, sa baiwa ne Israel apanawa bola wanamodina bedewe Aron mai bola sawo odaa, dia. E boitaa, ipawa e nata ne aiana mai ruawaitapona, dia. ");
INSERT INTO soq_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Tauma e ita Aron otopa Eliesa nata banlamoe wadi Oa oso odane aitana. ");
INSERT INTO soq_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Ita sape e Aron pirisi garawa taumodia otawiaite me otopa Eliesa osowe aimoa. Ita sape Aron bolepie nosinosiwa wawo alepi.” ");
INSERT INTO soq_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Tane Moses Iawe God wana rua dewasan. Apana uduudu mo ewamoio emawo odane wadi Oa oso anton. ");
INSERT INTO soq_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Sape Moses Aron ampe pirisi garawa otaubalene me otopa Eliesa osowe aimon. Ita Aron wadi sa iwa oso bolen. Ita Moses Eliesa nata wadiwae leuntone anton. ");
INSERT INTO soq_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Tane Israel apanawa uduudu Aron boleno umanawa etane mo uduudu ke waio walama 30 dialen. ");
INSERT INTO soq_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Tane mo wadi Oa enee Edom tawowa panape antopona ene Owa Bumawa intawa asiasi antoie into etedabuantoiena. ");
INSERT INTO soq_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Mo God ita Moses mampo momoduntone waienase, “E dima baiwa no Isibtiwa wainitano banlaneano mape sala makowa bedewe winena bontata baiwantitana? Mape nana ita esa dia, no nana deawa os nate dabuaidanten.” ");
INSERT INTO soq_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Sa baiwa Iawe God mota onawau mo mampo waubaleno ita Israel apanawa uara adamono bontoiena. ");
INSERT INTO soq_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Israel apanawa Moses mampe wimone waienase, “No kadiwaida dewasatana God mampe ita e manawo. E Iawe God mampe rauparitawo mota no mainimbo diantopu.” Sa baiwa Moses Iawe God mampe rauparilen. ");
INSERT INTO soq_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Iawe God Moses diene wanase, “E mota onawaa aleupa dewasae ia osowe seua. Ita mida mota adena mota sa aleupa ewepie inalepi.” ");
INSERT INTO soq_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Sa baiwa Moses irama mampe mota aleupa dewasane ia osowe itun. Ita apana mida mota adedia me mota sa aleupa ewedie inaleide. ");
INSERT INTO soq_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Tane Israel apanawa antoie bola Obot bedewe saradountone waimoie. ");
INSERT INTO soq_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Ita mo bola Obot ene antone Ie-abarim bedewe wimone saradountoiena. Bola sa sala makowa bedewe Moab tawowa moawa do omo wisediawo winede. ");
INSERT INTO soq_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Ita mo sape waimoie ene antone doba Sered bedewe saradountone waimoie. ");
INSERT INTO soq_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Tane mo sape waimoie ene antone doba Anon waiwa dauwo saradountone waimoie Amori apanawa tawou moawa osowe sala makowa bedewe. Tane doba Anon sa ipa Amori ita Moab apanawa ita Amori apanawa tawou endipundede. ");
INSERT INTO soq_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Tane Israel apanawa gagalou benemalala waaubamoieno Amori apanawa warereu ebowa Sion mampe antone wane waienase, ");
INSERT INTO soq_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“No menanedia e bolala bedewainta antata, tane antonte e iraila bedewe mai odata, dia. No e esala mai da utate nata, dia. Tane no warere intawa alena asiasi antonte e bolaa etaiata.” ");
INSERT INTO soq_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Tane warere Sion mai menasapona Israel apanawa me bolawa bedewainta antopu, dia. Me sorodiawa uduudu diamono auweieno ita Israel apanawa sala makowa bedewe dommopua baiwa anton. Ita mo antone bola debama Iaias bedewe wimone Israel apanawa do onanton. ");
INSERT INTO soq_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Tane Israel apanawa mukantone isima mampe warere Sion onawa enane nanausane aneiena. Ita warere tawo Anon esawa noseidiawo ita alene Iabok esawa makawa wadane mamposaiena. Tane Iabok sa ipa Amon apanawa bolau makawa enenpunden. Ita Amoniwa bolau makawa badowa bodeiena, sa baiwa Israel apanawa mai wimope odapona, dia. ");
INSERT INTO soq_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Ita Israelwa Amori apanawa bolau uduudu ita do bola debama ebowa Esibon ita bolawa kerakera do wadane mamposane bedewe waimoie. ");
INSERT INTO soq_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Israelwa epe dewantone Amori apanawa bolau wadane mamposaiena. ");
INSERT INTO soq_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Ita Moses iwu apanawa waaubamono bola debama Iase ita do bolawa kerakera bedewainta antone ewaitusaiena. Ita mo Israelwa do antone bola Amori apanawa sape waimoia tanamoiena. ");
INSERT INTO soq_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Ita ema aupe mo leuntone Basan bolawa intawa asiasi odane antoiena. Ita Basan warerewa Ogi me sorodiawa uduudu do Edirei bedewe ona baiwa nomon. ");
INSERT INTO soq_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Ita Iawe God Moses diene wanase, “E mai me sawaitaa, ne me ita me apanawa uduudu ita me bolawa uduudu e witaawosadina kadimoa. E Amori apanawa warereu ebowa Sion bolawa debama Esibon bedewe wandio mampe ambi dewasaana ruaida me mampe dewasaa.” ");
INSERT INTO soq_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Sa baiwa mo antone Ogi ita obampa mona ita do me sorodiawa onau enane aimoiena, mai da inawaa wampona, dia. Ita me bolawa mo wadane mamposaiena. ");
INSERT INTO soq_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Tane Israel apanawa antoie bola apuapuwa Moab bedewe Ioadan esawa tampe saradountone waimoie. Ita bola debama Ieriko ipa Ioadan waiwa dauwo winede. ");
INSERT INTO soq_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Tane Sipo otopa ebowa Balak Israelwa Amori apanawa onau enane aimoiena ewamon. ");
INSERT INTO soq_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Israel apanawa ipa uaraia sa baiwa Moab apanawa mo ewamone saidantone uwauwabobonton. ");
INSERT INTO soq_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Ita Moab apanawa antone Midia apanawa eiau mampo wane waienase, “Apana ema uaraia waimoia ando dewa uduudu mainimbo wineia kadimoputuwapi, mo pue kau antoie ina natuiantoia rua no kadineputuwapi.” Tane walama sawo Sipo otopa Balak ipa Moab apanawa warereu wandie. ");
INSERT INTO soq_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Sa baiwa me apana waaubamono gagalo wadane Beoa otopa ebowa Balaam mampe antoiena bola debama Petoa esa debama aleidia tampe Amawi apanawa tawou oso. Ita mo antone me dieiena me mampe alepi ita diane waienase, “Balak wana, ‘Apana Isibtiwae nomona, mo bola uduudu bedewainta wainatuwaiena ita ne tainawo do waimoi, ");
INSERT INTO soq_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","mo apana mukamukaua mai no ruamba, dia, sa baiwa e wine ne adinawoite mo osouwo saua kadiwa wae wadabuamoa. Ita ne mo nanaumope aimopa ita tanamopo bolana epue antopu. Ne ateina e apana osowe sau euda waiana sau euda me mampeleide, tane saua kadiwa waiana me osowe kadiwa ituiana.’” ");
INSERT INTO soq_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Sa baiwa Midia ita Moab apanawa eiau mane wadane nomone antoiena Balaam malesasapuo Israel apanawa osouwo saua kadiwa wapia baiwa. Ita mo Balaam mampe wimone warere Balak gagalowa wana benemasaieno eten. ");
INSERT INTO soq_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Ita me mo diamone wanase, “E ne do mape wainente ituntata ita e gagalo wadale wilena sipoa Iawe God dianepio rua dialepa.” Sa baiwa mo waimoie itunton. ");
INSERT INTO soq_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Tane God Balaam mampe wisene waitarasane wanase, “Ema apana dainea e do wainilana?” ");
INSERT INTO soq_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balaam me sipoasane wanase, “Sipo otopa Balak Moab warerewa mo waaubamono gagalo ema epe wadane ne mainawo wimoiena. ");
INSERT INTO soq_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","Apana ema Isibtiwa waimoie nomone bola uduudu bedewe waine mo os uduudunton. E wine ne adinawoite saua kadiwa wae wadabuamoa. E epe dewaitawo ne mo onau enape nanaumope aimopa ita tanamopo bola ema epue nomopue antopu.” ");
INSERT INTO soq_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Tane God Balaam diene wanase, “E mai mo do aitana, ne dan sa osouwo sau euda ituna sa baiwa e mai saua kadiwa wae mo osouwo itua, dia.” ");
INSERT INTO soq_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Sa baiwa Balaam tadinaida enenwisene Balak gagalowa sipoa mo diamone wanase, “Iawe God ne dianena mai e do antata, dia, sa baiwa e eba leutane bolalawo aitana.” ");
INSERT INTO soq_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Moab apanawa eiau epe etane leuntone antone Balak diane waienase, “Balaam no do mape wimpona dabualen.” ");
INSERT INTO soq_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Sa baiwa Balaam tadinaida enenwisene a baiwa donkiwa imaasan ita Moab apanawa eiau do antoiena Balak mampe. ");
INSERT INTO soq_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Tane God nuawa kadilen Balaam mampe ipawa me Moab apanawa eiau do Balak mampe antoia baiwa. Balaam nolawa apanawa nata do antoio Iawe God enseliwa wanaubeno alene me onawa enene intawa boden. ");
INSERT INTO soq_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Tane mo antoie donki Iawe God enseliwa ona isimawa wadene into enedio ewen. Sa baiwa me inta eniene irai bedewe alen. Tane Balaam donki epen leusapono into wisepona baiwa. ");
INSERT INTO soq_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Tane Iawe God enseliwa wain iraiwa nata gonaantona eneia sawanauwo inta kerauda oso enedie. ");
INSERT INTO soq_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Ita donki ensel ewene irai gonaawa osowe udendoe Balaam wawa apisentutuden. Sa baiwa me osowe donki epen. ");
INSERT INTO soq_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Tane Iawe God enseliwa rialene alene inta awopawa keraudida osowe enen, sape mai leute wita on ba sen deneuwe aitaa rua, dia. ");
INSERT INTO soq_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Mape donki Iawe God enseliwa enedio ewene ita Balaam wawa atowe itulen. Tane me nuawa kadileno koinawa mampe donki epen. ");
INSERT INTO soq_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Tauma Iawe God donki moawa wadenaubeno Balaam mampe wane wanase, “Ne dima e manawo dewasanakadisano baiwa walama natadea epaneana?” ");
INSERT INTO soq_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balaam me sipoasane wanase, “E ne dewaneana ewaewa abo apana oopa rua. Ne mainawo isima wineipono tauma ema e boepona.” ");
INSERT INTO soq_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Tane donki Balaam diene wanase, “Ne ipa e donkiaida walama uduudu osonawo wainie leie, ita dewa inainamba ema rua ne bauta dewasana, ba?” Tane me wanase, “Dia.” ");
INSERT INTO soq_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Mape Iawe God Balaam emawa wadenaubeno ensel isima wadene enedio ewen. Sa baiwa me dunelene namba dogo osowe itun. ");
INSERT INTO soq_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Tane Iawe God enseliwa me waitarasane wanase, “E dima baiwa donkia walama natadea epaana? Ne emanawo a ema e aitiana ipa kadiwa, sa baiwa ne onaa enane intaa bodedina. ");
INSERT INTO soq_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","E donkia ne ewanene baiwa leulena walamawa natadea. Tane me leu epono ne tauma ema boepona ita me epono inalepona.” ");
INSERT INTO soq_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balaam Iawe God enseliwa sipoasane wanase, “Ne kadiwa dewasana, ita do into ne baina ona eneiana mai atenteapona. Naita e ne ana ema ewone mai meneempa, ne ideita leuntape anteapa.” ");
INSERT INTO soq_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Ita Iawe God enseliwa Balaam diene wanase, “E apanaa do aitana, tane dima ne dieepa rua os waa.” Sa baiwa me Balak apanawa debamau do anton. ");
INSERT INTO soq_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Ita Balaam gagalowa ema wane wanase: “Balak, Sipo otopa, Wine ne gagalona ema etaadewaitaa. ");
INSERT INTO soq_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","God ipa mai apanaida ruamba, me mai laga wapi, dia. Me mai insaisawa leusaipona, no apanaida ruamba, dia. Me dima wadia ruawaida dewasade. Dima me sauawalene wadia ideita segaleide, mai dia. ");
INSERT INTO soq_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Me ne dianena sau euda me apanawa osouwo itupa. Me mo osouwo sau euda itun. Sa baiwa ne saua sa mo osouwo ituna mai wadapaaubepa rua, dia. ");
INSERT INTO soq_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Iawe God ipa mo do, mo nuaeu mampe mukantoie wadaposintoi ipawa me ipa mo warereu. Me ando mai poka saiwa daitada Iakob nosinosiwa Israelwa osouwo itupi, dia. ");
INSERT INTO soq_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","God Israel apanawa Isibtiwa waimoio banlamono nomoiena. Me mukawa ipa debamaia, kau dobinoa onawaa mukawa rua. ");
INSERT INTO soq_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Mai mida da Israel apanawa osouwo saua kadiwa wapia rua, dia. Mai wene ba ginauri dewawa mampe mo kadimopua rua, dia. Tane mo Israel apanawa Iakob nosinosiwa umanau wapue wapuase, ‘Ewane, God dewa pokawaa me apanawa baibu dewasan!’ ");
INSERT INTO soq_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Israel apanawa mukau ipa debamaia pue onawaa laion rua; me mai di wampia rua, dia, me ideita aleidie moiawa bomodie namode, ita do osinapu remoleidio dialeide. Ita edie aleidie bubualeidie ituleide.” ");
INSERT INTO soq_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","“God apana muriwa wisepia umanawa ne dianen. Ne me ewedina tane mai tauwadea wisepi, Iakob nosinosiwa Israelwa bedeuwoe kipora wiseidia rua warere ando wisepi. Me ando Moab apanawa uwauntoia ansisimopie nanaumopi, ita Set apanawa uwau nepa antutulepi. ");
INSERT INTO soq_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Me emalawoa tawo Edom apanawa nanaumopie aimopi, ita mo tawou wadepie mampesapi, ita Israel apanawa mukamukaua segantopu. ");
INSERT INTO soq_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Ita warere sa ando Iakob nosinosiwa bedeuwoe wisepi, me wisepie apana Moab bolawa debama bedewe waimoia kadimopituapi.” ");
INSERT INTO soq_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Tane Israel apanawa bola Sitim bedewe waimoie apana mona nina dewawa Moab iotopa do dewasaie. ");
INSERT INTO soq_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Tane Moab iotopa Israel apanawa nisomoieno mo godiu mampe pulontoia bedewe odeiena. Ita do nana naie mo godiu wadaposimoie. ");
INSERT INTO soq_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Mo epe dewantone Baal-Peo godiwa wadaposisaie, sa baiwa Iawe God mo mampo nuawa kadiidaleno nuakadiwa wanaubeno ien. ");
INSERT INTO soq_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Ita Iawe God Moses mampe wane wanase, “E ne emanawo walamo sabamo apana uwauntoia apanawa uduudu bomoa. Ita ne nuakadina Israel apanawa osouwo iena epa, mai dewasapa, dia.” ");
INSERT INTO soq_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Sa baiwa Moses Israel apanawa uwauntoia diamone wanase, “E deadea wainilana bedelawo mo mida nomone antone Baal-Peo godiwa wadaposisaiena bomonatuwapi.” ");
INSERT INTO soq_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Tane Moses ita Israel apanawa ape kakaiwa moape ke waie waimoie. Ita mo eweio Israel apanawa dea Midia iwa banlene me wandia apewa bedewe alen. ");
INSERT INTO soq_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Tane Aron atawa Piniasi Eliesa otopa pirisi nolawa dewasadia dewa ema ewene apana auweia emone nosene alene e waden, ");
INSERT INTO soq_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","ita Israel apanawa sa wawe alene ape bedewe oden. Ita me e mampe apana eine ita i bupa dosane eino bontoiena. Ita walama sawo Iawe God matangelawa kero kadiwaida wanaubeno iena dialen. ");
INSERT INTO soq_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Tane matangela sa bedewe apana wisiawa 24,000 kero wadamono bontoiena. ");
INSERT INTO soq_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Mape Iawe God Moses diene wanase, ");
INSERT INTO soq_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Aron atawa Piniasi, pirisi nolawa dewasadia Eliesa otopa ne insedina ruaida dewasan. Me epe dewasana mampe apana mai god lagawaa wadaposisapu, dia. Tane ne os wadaposineampa. Ne mo mampo nuana kadileno kadimopona saiwa me diasan. ");
INSERT INTO soq_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Sa baiwa e me diaa, ne wanwan euda obasa sauawa badowa me mampe itudina. ");
INSERT INTO soq_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Me nuawa kadileno ebona wiwirawantompa baiwa Israel apanawa kadiu riasan ita mo kadiu insadabuamona. Ita tauma sauana badowa me ita me nosinosiwa do osouwo itudina. Mo pirisi nolawa dewasampe ita akasantopu.” ");
INSERT INTO soq_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Iawe God Moses diene wanase, “Nun otopa Iosua, Aleu nopesano wandia me osowe e witaa itua apana banlamopia baiwa ita enapune awowasaa. ");
INSERT INTO soq_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Ita me pirisi Eliesa mampesawo apana uduudu ewompo danauwo e aupaa wadepi. Ita me sabamosae Israel apanawa banlamopia mukawa osowe itua. ");
INSERT INTO soq_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Moses, e mukaa isiwa me wanawo Israel apanawa uduudu me aiawa etompe ruawantompa. ");
INSERT INTO soq_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Ita me pirisi Eliesa danawe enompo ita pirisi sa nitu kerakera kopikopiua ebowa Urim mampe owalempe ne insaisana atenlempa. Eliesa wapio Iosua ita Israel apanawa emalawoau do onantompe ita leuntompe wimompa.” ");
INSERT INTO soq_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Sa baiwa Moses Iawe God wana ruawalene Iosua banlene alene pirisi Eliesa ita Israel apanawa uduudu danauwo ituno enen. ");
INSERT INTO soq_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Ita Moses Iawe God wana rua witapa Iosua osowe itune ita sabamosan Israel apanawa banlamopia baiwa. ");
INSERT INTO soq_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Tane Israel apanawa Moab bolawa apuapuwa osowe waimoie esa Ioadan tampe ita bola debama Ieriko waiwa dauwo winedie. Ita sape Iawe God Moses diene wanase, ");
INSERT INTO soq_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“E Israel apanawa ema epe diamoa, ‘E esa Ioadan nawane Kanaan bolawa bedewe odane, ");
INSERT INTO soq_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","sape apana waimoia tanamona ita kokoitau seu mampe ita irama mampe dewalala ita do wadaposiu bolawa kadimonatuwapi. ");
INSERT INTO soq_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Ne bola sa e enaledina wadane manlawosane ita bedewe waina. ");
INSERT INTO soq_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","E bola wadawadawa baiwa, nitu kopikopiua mampe owaitane ewane rua empuempusane danla wanamona. Dan dainea debamawa, eiasane wanamona tane dan kerauda kerausane wanamona. E nosinosila dambu asiasi odaitana. ");
INSERT INTO soq_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Naita e apana bola sa bedewe waimoia mai tanamono antopua, mo ando karami emalawo aleidie poka enaledia ita do gedara endia rua surakaulempa. E sape wanlempo mo ando poka debamaia enalempa. ");
INSERT INTO soq_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Naita e apana bola sa bedewe waimoia mai tanamono antopua, ne insedina Kanaan apanawa matangelamopono poka etapona tane e Israelwa poka osolawosapo etana.’” ");
INSERT INTO soq_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Tane Iawe God Moses diene wanase, ");
INSERT INTO soq_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“E Israel apanawa ema epe diamoa, ‘E esa Ioadan nawane Kanaan bolawa bedewe odane, ");
INSERT INTO soq_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","bola debamau isiwa sonabamona apana antompe inantompa baiwa. Naita apana mida mai insepidoe sowa bosapia me sawe weuwapie sape alepie inalepi. ");
INSERT INTO soq_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Tane apana bolena gombawa biwa menamompo apana sa sawe bola sonabala bedewe alena, mo mai tauwadea sipoasapue me bosapu, dia. Tane bauta me kotu apanawa danawe enepie ita apana uduudu emauwo kotulepi.’” ");
INSERT INTO soq_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","Mape Moses Israel apanawa diamone wanase, “Israel apanawa, ne anaana uduudu enaledina ruawaitonuna, e epe dewaitonune wanlempe ita aitane Iawe God, nosinosila Godiu tawo enalepio wadane bedewe waina. ");
INSERT INTO soq_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Iawe God, e Godila anaanawa ne dialedina, anaana sa bedewe mai da wadanaaubena ba da eba osowesane ituna, dia. Tane anaana ema e ruawaitonune wanlempa, mai ena, dia. ");
INSERT INTO soq_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","E anaana ema deaitopa ruawaitonune wanlempaa mampe bola isiwa apanawa e insaisala dodomana ita atenla debama ewapu. Ita mo anaana ema uduudu etapue wapuase, ‘Ulaipa Israel apanawa dan debama mukawaa seganton, mo insaisa dodomana ita aten debama apanawa.’ ");
INSERT INTO soq_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Iawe God ipa no mainimboido ita no rauparintitana me saunede, mai bola isiwa debama ba kerakera apanau godiu da epe wainipona, dia. ");
INSERT INTO soq_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Ande anaana ema uduudu ne dialedina ipa dodomana ita eubu winei, mai bola isiwa debamau ba kerakera anaanau epe rua wineipona, dia. ");
INSERT INTO soq_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","34","Walama sawo e Isibtiwa wanilano Iawe e Godila banlaleno nolelana ita me mukawa mampe ginasa pokawaau ita dewa debamau e emalawo dewamodie. Me adilawolene Isibt apanawa onau enene poka debama wanamon. Ita e me dewaleno apanawaida wanaiten, ita wadi Sainai iwe dobina bedewe ia debamaia idie bumedia bedewe me gagaloleidio etalana tane inawaa wainilana. Dewa inainambu ema rua mapo da epe segalen, ba? Dia! Tauma insaisala leusano tawo uduudu bedewe inseno alepi, bumpeido God apana dewasanawo dima segantona ita do muriwa e muitena insamona. Mai god da dewa inainambu ema rua dewamopona, dia. ");
INSERT INTO soq_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","E sumanaitane insenadewaitana Iawe me meba os ipa God uboo ita tawo osowe wande, ita mai god da wainipona, diaida. ");
INSERT INTO soq_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","Anaana ema uduudu ande ne enaledina ruawaitonune wanlempa. Ema mampe e ita e nosinosila do wanwan euda Iawe e Godila bola enalediawo wankasaitana.” ");
INSERT INTO soq_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","Ita Moses Israel apanawa diamone wanase, “Israelwa asisuidewaitana, Iawe God, no Godimba dea os wande, mai god da wainipona, dia. ");
INSERT INTO soq_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Iawe e Godila nuala uduudu, insaisala ita mukala uduudu mampe nuawadawadasanuna. ");
INSERT INTO soq_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","Anaana ema ande ne dialedina wadane ita nualawo itune insamonune os wanlempa. ");
INSERT INTO soq_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","E dulawo wanlempa ba leununa bedewe ita tadino ituitonune bubuaitonuna bedewe ita do tadinaida enonuna bedewe anaana ema e obanla waeuwamonuno etompe waimompa ita do anaana ema gagalowaitonune wanlempa.” ");
INSERT INTO soq_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","Moses Israel apanawa diamone wanase, “Iawe e Godila banlalepie alepie bola enalepio bedewe waina. E sape odonuno me dan uawa uduudu 7 tanamopio nambe antoputuwapi. Uwa sa ipa Itaiwa, Gigasiwa, Amoriwa, Kanaanwa, Perisiwa, Iwaiwa ita Sebusiwa. Dan uwa ema ipa apana debamau ita pokawaauida mai e ruala. ");
INSERT INTO soq_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","Tane Iawe e Godila apana sa e mukala atolawosapio nanaumone aimone diaidamona. Mai mo do insaisala deasane badowa sauaitana do wanlempa baiwa ba nuapareutana, emona. ");
INSERT INTO soq_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","Ita mai mo do nainaitana, dia. Sa ipa e obanla iwoa mai mo obampu mona naimopu ba e obanla mona mo obampu iwoa naimopu, dia. ");
INSERT INTO soq_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","Naita e obanla epe dewantopua mo sumanaibu ne bedenawo ituia epue ita god lagawaa wadaposimopu. Ita Iawe God e epe dewaitonuno ewalepie nuawa kadiidalepio tauwadea os bolepituwapi. ");
INSERT INTO soq_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","E aitane mo mampo ema epe dewaitana: Mo pulontoia watawa epakokomona ita seu kakaila epatuwiaitane ita do Asera wadaposisaia tuatua eneia toiamone ita kokoitau sa ia emawe sumono ituiamopi. ");
INSERT INTO soq_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","E ema epe dewaitana ipawa Iawe e Godila empuialene nambelena me os baiwa wanlempa. Uwa daitada apanawa tawo osowe waimoia bedeuwo e ipa me apanawa mebaawaida wanaitane wanlempa. ");
INSERT INTO soq_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","E mai uaraitape ita bola isiwa apanawa nataosintopono baiwa Iawe God e nuawadawadalepe sonabalepona, dia. Uwa daitada waimoia bedeuwo e dan uwa kerauda wainilana. ");
INSERT INTO soq_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","Iawe God e nuawadawadalede ita me dima e nosinosila mampo saualena rua manlawo dewasapi. Sa baiwa e Isibt apanawa warereu mukawa atowe nola dewalala wainilano me mukawa debamaia mampe inalen. ");
INSERT INTO soq_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","Sa baiwa e ateitana Iawe ipa ulaipa Godida wande, me dima wadia dewamodie os wande. Apana mida me nuawadawadasaie ita do aiawa ruawantoia, me nuawadawadaidamodie ita dewa euda mo mampo dewasade. Sa ipa me sauawa mo uaraia ando muntompa mampo winakasalepi. ");
INSERT INTO soq_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","Ita mo mida me aiawa dabuasaie mai ruawantoipona kadimode. Mo mida me dabuasaia me tauwadea os kadimopi. ");
INSERT INTO soq_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","Sa baiwa ne anaana ita waeuwa ema uduudu waeuwantedina e deaitopa ruawaitonune wanlempa.” ");
INSERT INTO soq_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","Mape Moses Israel apanawa diamone wanase, “Iawe e Godila ena 40 bedewe ambi sala makowa bedewe e banlalene odena insenuna. Me e poka enalena mampe wadaetaledie ewalepia baiwa. Ita e poka enaledia bedewe e ituaisiledie ewalepia baiwa me anaanawa ruawaitana ba, dia. ");
INSERT INTO soq_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","Me dewaleno omana tolen, tane nana ebowa mana enaleno nalana. Nana sa e ita nosinosila do mai atenla, dia. Ita me ema epe dewalena mampe e ateitana baiwa, apana mai nana os tounawe wampua rua, tane Iawe God aiawa ruawantopue tounawe waimompa. ");
INSERT INTO soq_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","E ando nana debama nanune ita du eubu wadamonune bedewe wanlempa, ");
INSERT INTO soq_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","ita do e puela kau, sipsip ita gote uarantopu ita do dewa uduudu bedewe mauraidaitana, ");
INSERT INTO soq_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","tane ewanadewaitana, mai asowawaitana e Isibt apanawa nolau dewalala wainilano Iawe God banlaleno nolelana. Iawe God ita dima me dewasana insenuna, mai nuala awawalepi, dia. ");
INSERT INTO soq_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","Me banlaleno sala makowa debama bedewainta, ita sape mota kadiu uaraia ita nauapiapisa, ita do sala makowa esa dia bedewainta odalana. Tane me dewasano nauida bedewe esa nosen ");
INSERT INTO soq_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","ita nana ebowa mana nosinosila mapo mai da mo napona enaleno nalana. Sa ipa e wadaetalepio ituaisitane me anaanawa ruawaitane ompe euda donsana baiwa epe dewasan. ");
INSERT INTO soq_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","Tane ewanadewaitana mai eba insene wanaase, ‘No nuba mukamba mampe badowa nolantene mauraidanten.’ ");
INSERT INTO soq_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","Iawe e Godila insenuna, me saua badowa e nosinosila mampo saualen, saua sa me insene baiwa e muka enaledia nitu uduudu mampe mauraitana.” ");
INSERT INTO soq_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","Tauma Moses Israel apanawa diamone wanase, “E Iawe God anaanawa walama uduudu nualawo itunune insamonune os leununa. E anaana sa nuaitulempa baiwa girumamone mabula osowe taudomona ita do eueuwa baiwa nanlawo taumona. ");
INSERT INTO soq_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","Ita obanla waeuwamonuno etompa, e dulawo wanlempa bedewe, leununa bedewe ba ituitonune bubuaitonuna bedewe anaana ema waeuwaitonuna. ");
INSERT INTO soq_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","Israel apanawa, asisuitana! E menaledia Iawe God sau euda osolawo itupi ba saua kadiwa osolawosapi? ");
INSERT INTO soq_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","Ande ne Iawe God anaanawa enaledina, naita e me anaanawa ruawaitana me sau euda e osolawo itupi. ");
INSERT INTO soq_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","Naita me anaanawa ema ne tauma waeuwaledina etane mai ruawaitana, ene god da e mai ateitipona sumanaibuitonuna Iawe God e osolawo saua kadiwa itupi. ");
INSERT INTO soq_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","Sa baiwa me anaanawa ita waeuwa ne tauma waeuwaledina ruawaitonune wanlempa.” ");
INSERT INTO soq_vpl VALUES ("DT17_14","006_17_14","DEU","17","14","14","Ita Moses wanase, “Iawe God bola ema enalede, bola sa bedewe odane emalawoala apanawa nanaumone aimone ita du wadamona. Aupe ema epe wana, ‘Bola isiwa tainimboa warereu do waimoi, sa baiwa no do warere da sonabeto onianepi.’ ");
INSERT INTO soq_vpl VALUES ("DT17_15","006_17_15","DEU","17","15","15","Mida e danla bedewe Iawe God sonabedia ituno warerelepi. Ita mai bola da nambea apanawa wisene bedelawo wandia sonabeno warerelepi, dia. ");
INSERT INTO soq_vpl VALUES ("DT17_16","006_17_16","DEU","17","16","16","Apana sa mai meba baiwa oas uara otepi ona baiwa ba apana waaubamopio leuntopue oas isiwa otepua baiwa Isibtiwa antopu. Ipawa Iawe God wanase, ‘E mai leutane Isibtiwa aitana, diaida.’ ");
INSERT INTO soq_vpl VALUES ("DT17_17","006_17_17","DEU","17","17","17","Ita do me mai manamanainapa uara naimopi ipawa mo me insaisawa teinawadasapio Iawe God baiwa simbialeidia epie nambelepi. Ita do me mai gold ba mane ita dewa daitada mampe mauralepi. ");
INSERT INTO soq_vpl VALUES ("DT17_18","006_17_18","DEU","17","18","18","Tane e me dewasano warerelepie Liwai damba pirisintoia mampo alepie anaana bukawa bedewe meba baiwa anaana girumalepie wadepi. ");
INSERT INTO soq_vpl VALUES ("DT17_19","006_17_19","DEU","17","19","19","Ita me buka ema wadepie mampesapie wisialempe os waimpa. Ema epeinta me ando Iawe God wiwirawalempe anaanawa uduudu ruawalempe os waimpa. ");
INSERT INTO soq_vpl VALUES ("DT17_20","006_17_20","DEU","17","20","20","Me epe dewalepie apanawa bedeuwo meba ituaisilepie ebowa mai debamasapi, dia. Ita me ando mai insaisawa leusaitusapie anaana epiiepie nambe alepi, dia. Ita me nosinosiwa do Israel apanawa oniakasamompo walama dauma dialepi.” ");
INSERT INTO soq_vpl VALUES ("DT18_9","006_18_9","DEU","18","9","9","Tane do Moses Israel apanawa diamone wanase, “E Iawe God bola enaledia bedewe odane wanlempe mai uwa daitada sape waimoia dewau kadiwaida waweitane rua dewasana, dia. ");
INSERT INTO soq_vpl VALUES ("DT18_10","006_18_10","DEU","18","10","10","Mai mida da, di diaida: otopa ba anoopa pulolepie ia emawe supi, ba eueuwa da ewepie dima ando segalepia umanawa wapi, ba aleu da mampo gagalolempa, dima ando segalepia umanawa atenlempa baiwa, ba dewa isiwa atenlempa baiwa ginauri dewamompa, ");
INSERT INTO soq_vpl VALUES ("DT18_11","006_18_11","DEU","18","11","11","do aleu da nambea ba nosinosila boniu mampo gagalolempa. Ita do me aleu da nambea ba nosinosiwa boniu nisomopio me bedewe odapue wampu, ba wene apanawa aiawa etepie sumanaiwalepi, di diaida. ");
INSERT INTO soq_vpl VALUES ("DT18_12","006_18_12","DEU","18","12","12","Apana mida dewa inainamba ema dewamodia Iawe God emawe me ipa nuadabualalaida. Apana bola sa bedewe waimoia dewa inainambu ema dewamoi, sa baiwa Iawe God mo tanamopio nomopue antopuo aupo e odane bola wadane waina. ");
INSERT INTO soq_vpl VALUES ("DT18_13","006_18_13","DEU","18","13","13","E walama uduudu Iawe God aiawa etonune ruawaitonune dodomanaida wanlempa. ");
INSERT INTO soq_vpl VALUES ("DT18_14","006_18_14","DEU","18","14","14","Apana bola sa bedewe waimoia, mo aleu kadiwa ita boni mampo gagalowa ita do wene apanawa aiau eteie sumanaibuntoi. Tane e tauma bola wadane manlawosana baiwaitilana, sa baiwa Iawe e Godila anaanalede mai mo dewau kadiwa waweitane rua dewasana, dia.” ");
INSERT INTO soq_vpl VALUES ("DT18_15","006_18_15","DEU","18","15","15","Ita Moses wane wanase, “Iawe God peroweta dea e eba apanalaida ne ruana bedelawo sonabepie manlawosapi, me gagalolempo aiawa uduudu etanadewaitana. ");
INSERT INTO soq_vpl VALUES ("DT18_16","006_18_16","DEU","18","16","16","Ipawa walama sawo e wadi Sainai atowe e uduudu auwelana ita eba Iawe God iririsale walanase, ‘No mai dewanewo osowe Iawe no Godimba aiawa etata ba ia debama idi bumedia ewata, no ando bontata sawa.’ ");
INSERT INTO soq_vpl VALUES ("DT18_17","006_18_17","DEU","18","17","17","Iawe God ne mainawo wane wanase, ‘Dima mo waiena ipa euda. ");
INSERT INTO soq_vpl VALUES ("DT18_18","006_18_18","DEU","18","18","18","Ne peroweta dea e ruaa mo muba dambuida bedewee sonabepe ita wanamopa. Ita ne aiana me bedewesapo ita ne wadina ruaida uduudu apana benemamompo etompa. ");
INSERT INTO soq_vpl VALUES ("DT18_19","006_18_19","DEU","18","19","19","Me ipa peroweta, sa baiwa ne ebonawo gagalolempo apana me aiawa etepie tane mai ruawalepia ne apana sa matangelasapa. ");
INSERT INTO soq_vpl VALUES ("DT18_20","006_18_20","DEU","18","20","20","Tane naita peroweta da asowawalepie ne dima wadina epie meba insaisawe gagalolempa me bolepi. Ita do god lagawaau ebouwo gagalolempa, mo ideita me bosapu.’ ");
INSERT INTO soq_vpl VALUES ("DT18_21","006_18_21","DEU","18","21","21","Tauma e eba waitaraitana, ‘No ambi atentata, me benema ema Iawe God mampea wade ba, dia?’ ");
INSERT INTO soq_vpl VALUES ("DT18_22","006_18_22","DEU","18","22","22","Ita peroweta Iawe God ebowe gagalolempo ita dima me wadia mai segaleipona dia, aia sa ipa mai Iawe God mampea waipona, tane meba insaisawe gagaloleide. Sa baiwa me mai sawaitana, dia.” ");
INSERT INTO soq_vpl VALUES ("DT31_7","006_31_7","DEU","31","7","7","Mape Moses Iosua dieno mampe wiseno Israel apanawa uduudu eneio danauwo me diene wanase, “Insaisaa badowa mukamukauaida enaa, ipawa apana ema Iawe God e nosinosia badowa sauamone bola wanamona bedewe banlamoe aitaa. Ita sape e bola sa empuempusae ruauite odaite wanamowo wadapue bolau wanasapu. ");
INSERT INTO soq_vpl VALUES ("DT31_8","006_31_8","DEU","31","8","8","Tane Iawe God e nananepe bautalepie banlaepi. Sa baiwa mai nuabolaite saitaa, me ipa e do, mai eepi, dia.” ");
INSERT INTO soq_vpl VALUES ("DT34_1","006_34_1","DEU","34","1","1","Ita Moses bola Moab apua debama osowe wandie ene wadi Nebo odene alene ita iwaida osowe bola ebowa Pisiga bedewe wisen. Tane bola debama Ieriko ipa Ioadan waiwa dauwo winede. Ita Iawe God Moses bola uduudu euwasano ewen. Sa ipa Giled bolawa ita alene Dan makawa, ");
INSERT INTO soq_vpl VALUES ("DT34_2","006_34_2","DEU","34","2","2","ita Napitali bolawa uduudu, Eparaim ita Manase bolawa uduudu ita Iuda bolawa uduudu alene Mediterenian Owawa wadena euwasan. ");
INSERT INTO soq_vpl VALUES ("DT34_3","006_34_3","DEU","34","3","3","Do Iawe God Moses sala makowa bolawa ebowa Negeb, Ioadan dobawa nuawa, bola debama Ieriko ita Soa bolawa uduudu euwasano ewen. Ita bola debama Ieriko ebowa da waia Notonkela Bolawa. ");
INSERT INTO soq_vpl VALUES ("DT34_4","006_34_4","DEU","34","4","4","Tauma Iawe God Moses diene wanase, “Tawo ema umanawa ne Abraam, Aisak ita Iakob mampo badowa sauantene wanase, ‘Ne tawo ema ando e nosinosia wanamopa.’ Ne bola ema euwaeno emaa os mampe ewaana, tane mai sape odee wana, dia.” ");
INSERT INTO soq_vpl VALUES ("DT34_5","006_34_5","DEU","34","5","5","Sa baiwa Iawe God wana rua me nolawa dewalala Moses bola Moab bedewe bolen. ");
INSERT INTO soq_vpl VALUES ("DT34_9","006_34_9","DEU","34","9","9","Muriwa me bolen me witapa Nun otopa Iosua osowe ituno God aten insaisa euda nopesan. Ita Israel apanawa me aiawa eteie ruawantoie. Mo dewa uduudu Iawe God Moses diena rua dewamoiena. ");
INSERT INTO soq_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","Iawe God nolawa dewalala Moses boleno aupe me sausadie leidia, Nun otopa Iosua mampe Iawe God wane wanase, ");
INSERT INTO soq_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","“Moses ne nolana dewasadia apanawa bolen. Sa baiwa tauma e imaitee ita Israel apanawa uduudu banlamoe esa Ioadan nawane bola ne wanamodinawo aitana. ");
INSERT INTO soq_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","Bola uduudu bedewe odane wala ainuna bola sa ipa e ebaala, ne enalena mapo Moses sauasana rua. ");
INSERT INTO soq_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","E bolala makawa ipa Negeb sala makowa ita alene wadi Lebanon waden. Ita do e bolala makawa Eupirates esawa omo wiseidia deneuwe, ita alene Itai apanawa bolau uduudu ita Mediterenian Owawa debamawa omo pamediawo enentuden. ");
INSERT INTO soq_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","E wanempa walamawe mai mida da nanausiepia rua, dia. Ne ipa Moses do lakasantena ruawa e mai eepa, dia. ");
INSERT INTO soq_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","Ne apana ema nosinosiu mampo badowa sauantena tawo ema wanamopa. Sa baiwa e badowa mukamukaua enee apana ema banlamowo bola sa bedewe odapue wadapue mubaauwanalepi. ");
INSERT INTO soq_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","E nana badowa mukamukaua enona. Tane ewaadewaita, anaana uduudu ne nolana dewalala Moses eneena ruawaitona. E dewa uduudu dewasano euda segalempa baiwa mai anaana ema saiee leusaitutee witaa on ba sen deneuweitaa, dia. ");
INSERT INTO soq_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","Walama uduudu waeuwa ema waeuwaitona. Tane do walama ita tadina nuaa bedewe insamone os wanempa, ema epe dewaite anaana ema uduudu ruawaitaatuapi. Ema epeinta e ando nolaa bedewe debamaite ipuipua segaitaa.” ");
INSERT INTO soq_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","Tane Israel apanawa bola debama Ieriko tampe bola Gilgal apuwa osowe saradountone waimoie. Tane uaboa dea ualeidio walama 14 wadedio rawiwa, mo Pasowa odawa dewasaiena. ");
INSERT INTO soq_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","Ema aupe imonemba mo nana ebowa wit irai bedewe uwauwantona sararantone ita bured tabataba mai ist dola dewamone ita namoiena. ");
INSERT INTO soq_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","Walama sawo mo nana irai bedewe uwauwantona naieno dialeno aupe nana ebowa mana mai segalepona, dia. Sa baiwa Israel apanawa mai mana da napona, dia, tane mo Kanaan bedewe nana irailala naie waimoie. ");
INSERT INTO soq_vpl VALUES ("JS24_1","007_24_1","JOS","24","1","1","Ema aupe Iosua Israel damba uduudu diamono bola debama Sikem bedewe wimone auweiena. Ita mo sape wimoieno me apana eiau, uaula apanawa, kotu wadawadalala ita nola deadea wadeia apanawa uduudu God danawe enapua baiwa diamono eneiena. ");
INSERT INTO soq_vpl VALUES ("JS24_2","007_24_2","JOS","24","2","2","Iosua apana sa uduudu diamone wanase, “Iawe, Israel apanawa Godiu wadiase, ‘Mapoido e nosinosila Tera ita me obampa Abraam ita Nao esa Eupirates waiwa dauwo waine god da wadaposimoie. ");
INSERT INTO soq_vpl VALUES ("JS24_3","007_24_3","JOS","24","3","3","Tane e nosila Abraam bola sawo wandio ne wadane banleno Kanaan bolawa uduudu bedeweinta alen. Ne me otopa Aisak bedewee nosinosiwa uara wanana. ");
INSERT INTO soq_vpl VALUES ("JS24_13","007_24_13","JOS","24","13","13","E Ioadan elee bautala Kanaan bedewe odalano ne tawo irai dola enalena, sape e mai iraitapona, dia. Ita do bola debamau enaleno bedewe tauma wainilana, bola sa e mai witalawo dewasapona, dia. Ita do e wain ita olib iawa mai aimopona ipawa naumoio naile wainilana.’” ");
INSERT INTO soq_vpl VALUES ("JS24_14","007_24_14","JOS","24","14","14","Tane Iosua Israel apanawa diamone wanase, “Sa baiwa e Iawe God sawaitonune nuala uduudu mampe simbiasanuna. E nosinosila esa Eupirates waiwa dauwo ita Isibtiwa waimoie god lagawau kokoitaubu wadaposimoia aubamone emonatuwapi. Tane e Iawe God os simbiasanune wanlempa. ");
INSERT INTO soq_vpl VALUES ("JS24_15","007_24_15","JOS","24","15","15","Tane naita e Iawe God simbiawa dabuaitana, ande ema e godila dainea inseilana sonabene ita simbiasanuna. E nosinosila Eupirates waiwa dauwo waimoie bola sa godiu wadaposimoia ba Amoriwa mida bolau e tauma wadale wainilana godiu wadaposimoia wawoitana. Tane ne ita ne duna bedewe waimoia do Iawe God os wadaposisante simbiasante wainenta.” ");
INSERT INTO soq_vpl VALUES ("JS24_16","007_24_16","JOS","24","16","16","Tane apana leusane waienase, “No mai Iawe God adiananasate ete god da wadaposimonta, dia. ");
INSERT INTO soq_vpl VALUES ("JS24_17","007_24_17","JOS","24","17","17","Ipawa no nosinosimba do Isibt bedewe mo nolau dewalala wainitano Iawe God no inanen. Me dewa pokawaauida dewamodio emamboido ewatana. Tane no sala makowa bedewe uwa daitada apanawa bedeuwointa antitano me no oniadewasaneno anten. ");
INSERT INTO soq_vpl VALUES ("JS24_18","007_24_18","JOS","24","18","18","Tane do Amori apanawa ita apana isiwa bola ema bedewe waimoia Iawe God tanamono antoiena. Sa baiwa Iawe God me os ipa no Godimba simbiasante wainenta.” ");
INSERT INTO soq_vpl VALUES ("JG2_7","008_2_7","JDG","2","7","7","Iosua ita apana eiau mida Iawe God dewa pokawaau dewamono eweiena apanawa inawaa waimoia walamawe Israel apanawa Iawe God simbiasaie. ");
INSERT INTO soq_vpl VALUES ("JG2_8","008_2_8","JDG","2","8","8","Ita Iosua Nun otopa Iawe God nolawa dewalala apanawa enawa 110 wadeno bolen. ");
INSERT INTO soq_vpl VALUES ("JG2_9","008_2_9","JDG","2","9","9","Ita mo me bolawa odantone waneiena Timnat Eres, Eparaim bolawa bedewe wadi Gaasi osowe wita sen deneuwe dobontoiena. ");
INSERT INTO soq_vpl VALUES ("JG2_10","008_2_10","JDG","2","10","10","Ita ema aupe dan sa uduudu bontontuwano aupe dan da sanaa muntone ita Iawe God mai atentopona ita do dima Israelwa baibu dewasana mai atentopona, dia. ");
INSERT INTO soq_vpl VALUES ("JG2_11","008_2_11","JDG","2","11","11","Israel apanawa Iawe God mampe kadi debamaia dewasaiena, ita mo god Baal kokoitauwa wadaposisaie. ");
INSERT INTO soq_vpl VALUES ("JG2_12","008_2_12","JDG","2","12","12","Mo sumanaibu Iawe God mampe ituia tauma eiena mo nosinosiu Godiu, mida mo tawo Isibt bedewe waimoio banlamono nomoiena. Ita mo Kanaan apanawa godiu daitada wawontoie wadaposimoie ita Iawe God dewasaieno nuawa kadiidalen. ");
INSERT INTO soq_vpl VALUES ("JG2_13","008_2_13","JDG","2","13","13","Ita mo sumanaibu Iawe God mampe itua ene ita god Baal ita god iwoa Astoret wadaposimoie. ");
INSERT INTO soq_vpl VALUES ("JG2_14","008_2_14","JDG","2","14","14","Sa baiwa Iawe God nuakadiwa Israel apanawa mampo ita emono emalawoa apanawa wimone epamone ita mo puraiwau otamone anton. Me emono onau apana wimone enabodamoiena. Ita Israel apana mai muba inantopona rua, dia. ");
INSERT INTO soq_vpl VALUES ("JG2_15","008_2_15","JDG","2","15","15","Tane Israel apanawa ona baiwa nomoie antoia walamawe Iawe God mo amboitumodie, me wana rua dewasadie ita mo pokaida eteie. ");
INSERT INTO soq_vpl VALUES ("JG2_16","008_2_16","JDG","2","16","16","Ita sape Iawe God uwaula apanawa eubu sonabamone teamon Israel apanawa onau eneia mampo saumopue inamopua baiwa. ");
INSERT INTO soq_vpl VALUES ("JG2_17","008_2_17","JDG","2","17","17","Tane Israel apana mo mida uwauntoie oniamoia apanawa aiau mai ruawantopona, dia. Mo Iawe God enee ita god da ewanuauwantoie wawo antoie, i badawa edie apana da baiwaleidia rua, ita mo tauwadea nosinosiu antoia intawa ita do God anaanawa eiena. ");
INSERT INTO soq_vpl VALUES ("JG2_18","008_2_18","JDG","2","18","18","Iawe God emalawoa apanawa Israelwa poka debamawa wanamoio eteie sidantoia etamodie. Sa baiwa me uwaulempa apanawa wanamodie, tane Iawe God uwaulempa apanawa nata Israelwa saumoie emalawoau apanawa mampo inamoie. Uwaleidia apanawa inawaa wandia walamawe Iawe God Israel apanawa nuapareuleidie inamodie ");
INSERT INTO soq_vpl VALUES ("JG2_19","008_2_19","JDG","2","19","19","Tane uwaleidia apanawa boleidio aupe Israelwa mai Iawe God inseipona ita eie dewau tontawa inseie nuau teinedio leuntoie aupawo antoie. Mo dewau ipa kadiwaida mai gombau bauta waimoia ruau, dia. Mo god da wauwontoie wadaposimoie. Ita mo nuau badoidaleno mai menamoipona kadi dewawa dewasaia epu. ");
INSERT INTO soq_vpl VALUES ("S11_1","010_1_1","1SA","1","1","1","Ita sape apana ebowa Elikana me Eparaim damba bedewe mulena, me bola debama Rama bedewe Eparaim bolawa bedewe wadi sainape wandie. Elikana ipa Ieroam otopa ita Ieroam ipa Eliu otopa ita Eliu ipa Tou otopa, ita Tou me ipa Supa otopa, Eparaim damba bedewea. ");
INSERT INTO soq_vpl VALUES ("S11_2","010_1_2","1SA","1","2","2","Ita me ioto nata naimon, i dea ebowa Ana ita da ebowa Penina. Penina oto gamoleidie tane Ana mai oto da gamosapona, dia. ");
INSERT INTO soq_vpl VALUES ("S11_3","010_1_3","1SA","1","3","3","Ena deadea bedewe Elikana bola debama Silo bedewe odedie aleide Iawe God Mukamukaua wadaposisampe ita pulo amonalempa baiwa. Tane sape Eli obampa nata Opini ita Piniasi mo ipa Iawe God pirisiwa. ");
INSERT INTO soq_vpl VALUES ("S11_4","010_1_4","1SA","1","4","4","Tane Elikana pulo amonaleidie sudia walamawe, me moia nipawa eubu otamodie manainapa Penina ita obampa mona ita iwoa do wanamodie. ");
INSERT INTO soq_vpl VALUES ("S11_5","010_1_5","1SA","1","5","5","Iawe God oto muwa intawa Ana bedewe itunboden. Tane Elikana Ana nuawadawadaidasane baiwa moia nipawa eubu osowesadie wanedie. ");
INSERT INTO soq_vpl VALUES ("S11_6","010_1_6","1SA","1","6","6","Ita Iawe God Ana oto muwa intawa itunbodeno baiwa Penina walama uduudu Ana nuawa oauarasampa baiwa wasisadie ita ituaisisadie. ");
INSERT INTO soq_vpl VALUES ("S11_7","010_1_7","1SA","1","7","7","Penina dewa inainamba ema Ana mampe ena ruawaleidie dewasade, mo Iawe God duwa bedewe antoia walamawe. Ita Ana emawe ke osi noseidie ita do nana mai naipe, dia. ");
INSERT INTO soq_vpl VALUES ("S11_8","010_1_8","1SA","1","8","8","Me badawa Elikana manainapa diene wanase, “Ana, e dima baiwa ke debamaia waie ita do nana dabuaitiana, tane do e dima baiwa walama uduudu nuapareitiana? Ne wadaneano manawontena sa ipa eudida, mai seda 10 otamopona rua.” ");
INSERT INTO soq_vpl VALUES ("S11_9","010_1_9","1SA","1","9","10","Ita walama dea mo bola debama Silo bedewe Iawe God duwa nope nana ita esa naieno dialeno, Ana nuawa pareidaleno ke wadie. Tane Eli God duwa bedewe du nope wandie. Ana nuawa surakauidaleno Iawe God mampe rauparilen. ");
INSERT INTO soq_vpl VALUES ("S11_11","010_1_11","1SA","1","11","11","Me raupariwa bedewe saua ema epe wan, “O Iawe God Mukamukaua, ne ipa e nolaa dewalala iwa! Ne nuabolana ewee mai nuaawawane enea, insanea. Naita e oto mona ne neaa, oto sa ne leusape eneepo me inawawa uduudu bedewe e os nolaa dewasampe wankasalepi. Ita do me uawa imba mai topu, dia.” ");
INSERT INTO soq_vpl VALUES ("S11_12","010_1_12","1SA","1","12","12","Me epe rauparileidie moawa tepaleidio Eli waine Ana moawa ewedie. ");
INSERT INTO soq_vpl VALUES ("S11_13","010_1_13","1SA","1","13","13","Me dainawa nuawa bedewe rauparileidio baiwa Eli me aiawa mai etapona tane moawa os tepaleidio ewedie. Sa baiwa Eli insenase, me dauwa esa badowa nan. ");
INSERT INTO soq_vpl VALUES ("S11_14","010_1_14","1SA","1","14","14","Sa baiwa me aiawa badowa mampe diene wanase, “Dima baiwa esa badowa nae koakoaitiana? Esa badowa nanawa ea.” ");
INSERT INTO soq_vpl VALUES ("S11_15","010_1_15","1SA","1","15","15","Tane Ana sipoasane wanase, “Debamana, ne mai esa badowa napona ne nuana bedeweido dauna etano surakauleno baiwa ne Iawe God mampe gagalontedine. ");
INSERT INTO soq_vpl VALUES ("S11_16","010_1_16","1SA","1","16","16","Ne nuana surakauleno baiwa ema epe rauparintedina. Sa baiwa mai insakadisane insease ne kadi dewalala iwa.” ");
INSERT INTO soq_vpl VALUES ("S11_17","010_1_17","1SA","1","17","17","Eli sipoasane wanase, “Wanwan obasa euda manawo winepio do noe aitaa! Dima umanawa iririwaitena Israelwa Godiu eneepituwapi.” ");
INSERT INTO soq_vpl VALUES ("S11_18","010_1_18","1SA","1","18","18","Ana sipoasane wanase, “Debamana niapo, insaisa euda mampe insaneana baiwa.” Ema aupe me alene ita nana nane ita do mai osowe nuaparelepona, dia. ");
INSERT INTO soq_vpl VALUES ("S11_19","010_1_19","1SA","1","19","19","Imonemba tadinaida Elikana apanawa do enanawimone Iawe God wadaposisane ene ita leuntone iane bolau debama Rama bedewe anton. Sape Elikana manainapa nata ituntone ita Iawe God Ana iririwa sipoasan. ");
INSERT INTO soq_vpl VALUES ("S11_20","010_1_20","1SA","1","20","20","Ema aupe Ana bulene oto mona gamosane ebowa ituna Samuel ita wanase, “Ipawa ne Iawe God iririsana baiwa.” ");
INSERT INTO soq_vpl VALUES ("S11_21","010_1_21","1SA","1","21","21","Mo waimoie ena da bedewe pulo itupua walama wiseno Elikana apanawa do pulo itupua baiwa odane antoiena bola debama Silo bedewe ena deadea bedewe pulo ituia rua. Ita sape me pulo da do itun me saualena rua. ");
INSERT INTO soq_vpl VALUES ("S11_22","010_1_22","1SA","1","22","22","Tane Ana mai mo do antopona, dia. Me badawa diene wanase, “Oto ema mulepie ama nanawa epio tauma ne me wadape anteape Iawe God duwa bedewe itupe epo wankasalepi.” ");
INSERT INTO soq_vpl VALUES ("S11_23","010_1_23","1SA","1","23","23","Tane Elikana sipoasane wanase, “Sa ide, dima e inseiana rua dewasae ita oto oniewo debamalepi. Iawe God sauepio dima e sauaitena ipawanalepi.” Sa baiwa me duwa waine oto oniedio debamalene ama nanawa en. ");
INSERT INTO soq_vpl VALUES ("S11_24","010_1_24","1SA","1","24","24","Samuel mulene ama nanawa ena walamawe me inawa otopa sa banlene ita kau mona enawa 3, parawa begiwa dea ita wain dugiwa dea do otene ita bola debama Silo bedewe alen ita sape me Iawe God duwe en. ");
INSERT INTO soq_vpl VALUES ("S11_25","010_1_25","1SA","1","25","25","Sape mo kau mona bosane pulontono dialeno aupe oto banlene anton Eli mampe. ");
INSERT INTO soq_vpl VALUES ("S11_26","010_1_26","1SA","1","26","26","Ita me inawa wanase, “O debamana! Ne ulaipaida wadina, ne ipa sa bauta Iawe God mampe rauparintedino ewaneana. ");
INSERT INTO soq_vpl VALUES ("S11_27","010_1_27","1SA","1","27","27","Ne oto baiwa Iawe God iririsano ita me ne iririna etene ita oto mona neen. ");
INSERT INTO soq_vpl VALUES ("S11_28","010_1_28","1SA","1","28","28","Tauma ne oto ema amonantene Iawe God wanedina. Me inawawa uduudu sa ipa Iawe God os mampea.” Ita ema aupe mo sape Iawe God wadaposisaiena. ");
INSERT INTO soq_vpl VALUES ("S12_1","010_2_1","1SA","2","1","1","Ita Ana rauparileidie wanase, “Ne Iawe God mampe nuaeuntedina, me ne muka neen. Ne nuaparentedino me sauneno tauma ne nuaeuntedina. Sa baiwa ne tauma emalawoana apanau wasiu wapa rua. ");
INSERT INTO soq_vpl VALUES ("S12_2","010_2_2","1SA","2","2","2","O Iawe God, mai mida da kakaiwa e ruaa wainipona, diaida, ita mai god da wainipona, dia. Tane mai onionia apanawa da no Godimba e ruaa wainipona, dia. ");
INSERT INTO soq_vpl VALUES ("S12_3","010_2_3","1SA","2","3","3","Ne dieedina eba ituposia gagalowa wawa ea, e eba asowawaa gagalou wawa eidasaa. Ipawa Iawe God dewa ududuu me atemba os. Ita ando me mampe e dewaa uduudu dewamoiana baiwa kotuepi. ");
INSERT INTO soq_vpl VALUES ("S12_4","010_2_4","1SA","2","4","4","Iawe God, ona apanau eu e ampuiaiten, tane e apana oauara muka wanamoiana. ");
INSERT INTO soq_vpl VALUES ("S12_5","010_2_5","1SA","2","5","5","Tane apana nana maurantoie naio pokamodio waimoia mo tauma nana baiwa nolantopu, tane mo mida omana tomodia tauma nana mauraleidio naie waimoi, ita i aipoiwa tauma obampa uduudu 7 gamomon. Tane i obampa uara gamomona tauma meba osi wande. ");
INSERT INTO soq_vpl VALUES ("S12_6","010_2_6","1SA","2","6","6","Iawe God, e dewasaiano apana boleide, ita e apana inaida wanamoiana, e apana bo nagawa bedewe teamoana, ita e apana dewamoiano bo bedewe eneiwimoi. ");
INSERT INTO soq_vpl VALUES ("S12_7","010_2_7","1SA","2","7","7","Iawe God, e apana dewamoiano puraiwa abolawantoi, ita apana isiwa dewamoiano maurantoi, ita isiwa ituaisimoiano ebousiawaia segantoi, ita apana isiwa dewamoiano ebou debamaleide. ");
INSERT INTO soq_vpl VALUES ("S12_8","010_2_8","1SA","2","8","8","Ita e apana nuaparelala popokau aimodio bedewe waimoia, ita do apana nana abolaantoie se naie waimoia teinaposimoe manawomowo, ita apana eboeboua do teamowo bola eubu oso wampu. Ita tawo ema uduudu ipa Iawe God dewasaana e manawoa, ita e nitu uduudu intaweintawe teamoano winei. ");
INSERT INTO soq_vpl VALUES ("S12_9","010_2_9","1SA","2","9","9","Ita mo mida insaisau e bedeawo ituia oniadewasamoiana, tane kadi apanawa bontopue sala iwimpa bedewe antopue dainantopu. Ita apana muba mukau mampe mai dima da dewasapuo segalepia rua, dia. ");
INSERT INTO soq_vpl VALUES ("S12_10","010_2_10","1SA","2","10","10","Ita e emalawoa apana ando kadimoatuapi, e nuakadia iepia moinawa uma rua. Ita e ando tawo uduudu kotusaa. Ita ando e warerea muka wanaa, tane do sonabeana apanawa dewasawo mukawaida segalepi.” ");
INSERT INTO soq_vpl VALUES ("S12_11","010_2_11","1SA","2","11","11","Ema aupe Elikana apanawa do oto ene ita leutone bola debama Rama bedewe anton. Samuel bola debama Silo bedewe wandie Iawe God nolawa dewasadie ita me ualeidia apanawa ipa Eli, me ipa pirisi. ");
INSERT INTO soq_vpl VALUES ("S13_1","010_3_1","1SA","3","1","1","Samuel oto sanaa wandia walamawe Eli aiawa etedie rua Iawe God nolawa dewasadie. Tane walama sa bedewe Iawe God apana mampo mai kainokaino gagaloleipe ita mo me mai auen rua bedewe eweipe, dia. ");
INSERT INTO soq_vpl VALUES ("S13_2","010_3_2","1SA","3","2","2","Eli emawa kadinton ita me mai sala ewepidewalepia rua, dia. Sa baiwa tadina dea me itua bolawe ituleidie. ");
INSERT INTO soq_vpl VALUES ("S13_3","010_3_3","1SA","3","3","3","Tane Samuel me Iawe God apewa bedewe saua badowa bokisiwa tampe ituleidie. Do Iawe God apewa bedewe siwa idia mai bolepona, dia. ");
INSERT INTO soq_vpl VALUES ("S13_4","010_3_4","1SA","3","4","4","Sape Iawe God apalene wanase, “Samuel!” Ita Samuel sipoalene wanase, “Oa! Ne ema!” ");
INSERT INTO soq_vpl VALUES ("S13_5","010_3_5","1SA","3","5","5","Me tauwadea enenwisene weuwane Eli mampe alene ita wanase, “E apaiteno baiwa ne winen.” Tane Eli wanase, “Ne mai apaepona, leuite aie ituita.” Ita Samuel leulene alene itulen. ");
INSERT INTO soq_vpl VALUES ("S13_6","010_3_6","1SA","3","6","6","Tane Iawe God osowe apalene wanase, “Samuel!” Me enenwisene alen Eli mampe ita wanase, “E apaiteno baiwa ne winen!” Tane Eli wanase, “Otona, ne mai e apaepona, dia. Leuite aie ituita.” Sa baiwa Samuel leulene alene itulen. ");
INSERT INTO soq_vpl VALUES ("S13_7","010_3_7","1SA","3","7","7","Epe segaleidie ipawa Iawe God mai da bauta me mampe epe gagalolepona. Sa baiwa me mai Iawe God aiawa etaetawa atenlepona, dia. ");
INSERT INTO soq_vpl VALUES ("S13_8","010_3_8","1SA","3","8","8","Tane Iawe God apawa natadeawa wadia Samuel etene enenwisene alene Eli mampe ita wanase, “E apaiteno baiwa ne winen.” Epe segaleidio tauma Eli insene atenlen sa ipa Iawe God oto apasade. ");
INSERT INTO soq_vpl VALUES ("S13_9","010_3_9","1SA","3","9","9","Sa baiwa me Samuel diene wanase, “Leuite aite ituita. Naita me osowe e apaepia e ema epe waa, ‘Debamana, gagaloitaa. Ne e nolaa dewalala asisuedina.’” Ita Samuel ene leulene alene itulen. ");
INSERT INTO soq_vpl VALUES ("S13_10","010_3_10","1SA","3","10","10","Ita Iawe God wisene osowe enene apalene wanase, “Samuel! Samuel!” Samuel sipoasane wanase, “Gagaloitaa, e nolaa dewalala asisuleide.” ");
INSERT INTO soq_vpl VALUES ("S13_11","010_3_11","1SA","3","11","11","Tane Iawe God wanase, “Ne ando dewa pokawaauida Israel apanawa mampo dewamopaa baiwantedina. Ita walama sa bedewe dewa sa umanawa etapue memesantopue saidantopu. ");
INSERT INTO soq_vpl VALUES ("S13_12","010_3_12","1SA","3","12","12","Ne ando Eli ita mo mida me duwe waimoia poka debamaia wanamopa bauta ne dewa uduudu diamona rua. ");
INSERT INTO soq_vpl VALUES ("S13_13","010_3_13","1SA","3","13","13","Me obampa ne ebona kadisane mala osowe ituneiena, ita me obampa mai gagalomopona kadi dewawa epua baiwa, dia. Sa baiwa ne me diana apana uduudu me damba bedewe waimoia poka osouwo itupo akasalepi. ");
INSERT INTO soq_vpl VALUES ("S13_14","010_3_14","1SA","3","14","14","Ita ne sauana badowa ituna Eli ita me obampa do mampo, ne wakadisanene mala osowe ituneiena kadiwa sa ne mai insepadabuasapa, dia. Ne ideita matangelamopo bontoputuapi. Naita ando mo ne mainawo wimpue kadi pulowa itupu, tane ne mo kadiu sa mai insepadabuasapa, diaida.” ");
INSERT INTO soq_vpl VALUES ("S13_15","010_3_15","1SA","3","15","15","Tane Samuel gagalo sa etene ita leulene alene ituleidio walama punden ita me alene Iawe God apewa moa wadenauben. Me gagalo etena umanawa Eli diapona saidalen. ");
INSERT INTO soq_vpl VALUES ("S13_16","010_3_16","1SA","3","16","16","Tane Eli Samuel dieno wiseno diene wanase, “Samuel, otona.” Samuel sipoasane wanase, “Ne ema.” ");
INSERT INTO soq_vpl VALUES ("S13_17","010_3_17","1SA","3","17","17","Eli, Samuel waitarasane wanase, “E Iawe God gagalo ambi wano etaana, gagalo sa uduudu ne dianeawo etapa. Naita e gagalo sa mai ne dianea, God ando e matangela debamaia eneepi.” ");
INSERT INTO soq_vpl VALUES ("S13_18","010_3_18","1SA","3","18","18","Sa baiwa Samuel gagalo uduudu Eli dieno eten, mai da weregasapona, dia. Ita Eli wanase, “Me ipa Iawe God, me dima insedia dodomanawa dewasapi.” ");
INSERT INTO soq_vpl VALUES ("S13_19","010_3_19","1SA","3","19","19","Tane Samuel mulene debamaleidio Iawe God me do. Ita me Samuel dewasano gagalowa uduudu wamodia rua os segantoie. ");
INSERT INTO soq_vpl VALUES ("S13_20","010_3_20","1SA","3","20","20","Sa baiwa, Israel apana uduudu, bola debama Dan alene enentudena makawa ita bola debama Beasiba alene enentudenawo bola sa apanawa Samuel atensaiena me ipa Iawe God perowetawa. ");
INSERT INTO soq_vpl VALUES ("S13_21","010_3_21","1SA","3","21","21","Ita Iawe God walama uara Samuel bola debama Silo bedewe wandio mampe wisedie sabamoleidie. Ita me mampe gagaloleidie. ");
INSERT INTO soq_vpl VALUES ("S18_1","010_8_1","1SA","8","1","2","Ita Samuel obampa nata, otopa tautuwa ebowa ipa Ioel, ita otopa da ebowa ipa Abaidia. Tane Samuel gulauleidie obampa nata sonabamon uwa apanawa segantopue Israel apanawa kotu bedewe kadiu dodomanasampa baiwa. Mo bola debama Beasiba bedewe uwa apanawa teamona nolau sape uanton. ");
INSERT INTO soq_vpl VALUES ("S18_3","010_8_3","1SA","8","3","3","Tane mo mai mambu dewawa rua dewantopona, dia. Mo apana mampo mane wadeie ando kotu bedewe adiwontompe emompe waubamompo di antompa baiwa. Ita mo dewau ema mampe kotu dewawa dodomana intawa bodeiena. ");
INSERT INTO soq_vpl VALUES ("S18_4","010_8_4","1SA","8","4","4","Sa baiwa Israel apanawa eiau uduudu wimone bola debama Rama bedewe auwene Samuel do gagalonton. ");
INSERT INTO soq_vpl VALUES ("S18_5","010_8_5","1SA","8","5","5","Mo Samuel diane waienase, “Ewee, e tauma gulauiten ita e obana mai e dewaa euda rua mo dewasaipona, dia. Sa baiwa no warere nenaa ita no onianepi. Ita no bola da apanawa waimoia ruau wanta.” ");
INSERT INTO soq_vpl VALUES ("S18_6","010_8_6","1SA","8","6","6","Tane Samuel mai nuaeulepona mo warere iririwantona mampe, sa baiwa me Iawe God mampe rauparilen. ");
INSERT INTO soq_vpl VALUES ("S18_7","010_8_7","1SA","8","7","7","Iawe God wanase, “Nitu uduudu mo iririwantoia baibu dewasaa mo ipa ne dabuanei mai e, dia. Mo mai menamoipona ne warereu wainepina, dia. ");
INSERT INTO soq_vpl VALUES ("S18_8","010_8_8","1SA","8","8","8","Ita walama sawo ne mo banlamono tawo Isibt ene nomoiena walamawe ita odene tauma. Mo ne eneie inta da wadeie antoi ita god da warorosaie. Tauma mo e manawo dewa ipa deawaa dewasai. ");
INSERT INTO soq_vpl VALUES ("S18_9","010_8_9","1SA","8","9","9","Mo e iririeia ruaite dewasaa tane e mo mampo badowa gagaloitaa, mo warere umanawa waia ando ambi oniamopia benemawa wae diamoa.” ");
INSERT INTO soq_vpl VALUES ("S18_10","010_8_10","1SA","8","10","10","Sa baiwa Samuel Iawe God wana gagalowa uduudu apana sa warere umanawa waia benemamon. ");
INSERT INTO soq_vpl VALUES ("S18_11","010_8_11","1SA","8","11","11","Me wanase, “Naita warere sa e onialepia, me ando ema epe dewalepi: e obanla otepie ita dewamopio me sorodiawa segantopu, ita do dewamopio turaka pue mampe teiteinalala ita oasi osowe nolantopu, tane do me dewamopio turaka pue mampe teiteinalala nambanepe bautantompe weuwampe antompe warere mampo aleidia umanawa diamompa baiwa. ");
INSERT INTO soq_vpl VALUES ("S18_12","010_8_12","1SA","8","12","12","Tane obanla isiwa me dewamopio sorodia uduudu 1,000 uwaula apanawa segantopu ita isiwa dewamopio sorodia uduudu 50 uwaula apanawa segantopu. Tane do isiwa dewamopio me iraiwa nolawantopu ita do nana uwauwantompe auwempa. Tane isiwa ona puraiwawa ita turaka pue mampe teiteinalala puraiwawa dewamompa. ");
INSERT INTO soq_vpl VALUES ("S18_13","010_8_13","1SA","8","13","13","Tane e obanla iwoa me otamopie dewamopio nana nuntompa ita do nana sumompa. Isiwa me dewamopio me baiwa bunama bonabonaua dewamompa. ");
INSERT INTO soq_vpl VALUES ("S18_14","010_8_14","1SA","8","14","14","Tane do me e nanala ita wainla iraiwa, ita olib iawa aimompa bolawa eubuida otepie ita me nolawa dewasaia apanawa debamau wanamopi. ");
INSERT INTO soq_vpl VALUES ("S18_15","010_8_15","1SA","8","15","15","E iraila bedewe wit ita wain ipawa uwauwaitane odawa uduudu 10 teamona. Tane me e manlawo odawa 10 bedeuwo oda dea wadepie me nolawa dewasaia apanawa debamau ita nola dewalala wanamopi. ");
INSERT INTO soq_vpl VALUES ("S18_16","010_8_16","1SA","8","16","16","Do me e nolaa dewalala mona ita iwoa ita do e kaua ita donkia eubuida otamopi, me nolawa dewasampa baiwa. ");
INSERT INTO soq_vpl VALUES ("S18_17","010_8_17","1SA","8","17","17","E puela sipsip ita gote otene odawa uduudu 10 teamona. Ita me oda sa bedewe dea wadepie mampesapi ita do e otalepio me nolawa dewalala apanawa segaitana. ");
INSERT INTO soq_vpl VALUES ("S18_18","010_8_18","1SA","8","18","18","Walama sawo warere sa e umanawa wailana dewa inainamba ema e manlawo dewasampo ewana. Tane e sau baiwa Iawe God mampe iriritonuno me etalepie elepi mai saulepi, dia.” ");
INSERT INTO soq_vpl VALUES ("S18_19","010_8_19","1SA","8","19","19","Tane apana sa Samuel badowaida gagaloleidia mai etaetawa menamopona, dia. Ita mo waienase, “No menanedia warere dea bainimba enepie onianepi. ");
INSERT INTO soq_vpl VALUES ("S18_20","010_8_20","1SA","8","20","20","Ema epe inta bola isiwa apanawa ruauntata. Warere sa no nainimbanepe bautalepi alepie bola isiwa apanawa do ona maepu.” ");
INSERT INTO soq_vpl VALUES ("S18_21","010_8_21","1SA","8","21","21","Sape Samuel apana insaisau gagalowantona umanawa Iawe God benemasan. ");
INSERT INTO soq_vpl VALUES ("S18_22","010_8_22","1SA","8","22","22","Ita Iawe God wanase, “Mo waia rua warere wanamoa.” ");
INSERT INTO soq_vpl VALUES ("S19_1","010_9_1","1SA","9","1","1","Beniamin damba bedewe apana debama dea maura apanawa wandia, me ebowa Kis, me mamba ebowa Abiel, ita me atawa ipa Sero, ita me atanosiwa ebowa Bekorat. Tane mo nosiu ipa Apia, mo Beniamin damba bedewea. ");
INSERT INTO soq_vpl VALUES ("S19_2","010_9_2","1SA","9","2","2","Kis otopa Sol apana sanaa uatauwa ewaewa eudida. Israel apanawa uduudu bedeuwo mai mida da ewaewawa euda me rua, dia. Tane do me apana muwa dauma me eneno uawa odene alene Israel apanawa isiwa amboiamon. ");
INSERT INTO soq_vpl VALUES ("S19_3","010_9_3","1SA","9","3","3","Walama dea Kis donkiwa rebanton. Sa baiwa me otopa Sol diene wanase, “E nola apanawa wadee ita nolene donki banumone aitana.” ");
INSERT INTO soq_vpl VALUES ("S19_15","010_9_15","1SA","9","15","15","Sol ita me nolawa apanawa nata antone Samuel mampe wimoiena. Ita Iawe God imana epe Samuel diene wanase, ");
INSERT INTO soq_vpl VALUES ("S19_16","010_9_16","1SA","9","16","16","“Imonepi omo ema rua wadompo ne Beniamin damba bedewe apana dea wapaaubepa e manawo. Me uawa osowe mena memea mampe sabamosaa ne apana sa sonabedina ne apanana Israelwa oniamopi. Me ando Pilistan apanau mampo inamopi. Ne apanana poka eteia saiwa ewana ita do ne saumopa kewa waio etamona.” ");
INSERT INTO soq_vpl VALUES ("S110_1","010_10_1","1SA","10","1","1","Tane Samuel mena dugiwa wadene Sol uawa osowe memene isuruasane ita diene wanase, “Iawe God e sonabaen me apanawa Israelwa warereuite oniamona baiwa. Sa baiwa ne dewa ema manawo dewasana. ");
INSERT INTO soq_vpl VALUES ("S110_2","010_10_2","1SA","10","2","2","Ita ande ne enee aitona, e apana nata Reitel dobontona bolawa tampe dommoa bola debama Selsa bedewe, Beniamin bolawa alene enentudenawo. Mo e manawo wapuase, ‘Donki sa e banumoilana dommoiena. Tauma e mamaa pue sa mai insamoipona, dia. Me ipa e insaedie ita wadiase, “Ne otona naepe donsapa.’” ");
INSERT INTO soq_vpl VALUES ("S110_5","010_10_5","1SA","10","5","5","Tane Samuel wanase, “Ando e God wadaposisaia wadiwa kerauda bola debama Gibea osowe odee aia, sape Pilistan apanawa sorodiau ona baiwa auweia bolawe. E bola sa bedewe odone peroweta uduudu wadapos diasane ieia dommoa. Mo gita, tambarin, sino kerakera ita kolago mampe owantone God insaisawa waie sabamosaie ita wadaposisaie do rasantoia dommoa. ");
INSERT INTO soq_vpl VALUES ("S110_6","010_10_6","1SA","10","6","6","Walama sawo Iawe God aleupa odepie bedeawo wampio e do God insaisawa wane wadapositona. Iawe God e insaisaa leusapio apana inainaa sanaa segaitaa. ");
INSERT INTO soq_vpl VALUES ("S110_7","010_10_7","1SA","10","7","7","Walama sawo eueuwa inainamba ema manawo segantopuo ewamoa, sa ipa God banlaempe dima diempa rua apanaa baibu dewamona me sauempo ipawanalempa. ");
INSERT INTO soq_vpl VALUES ("S110_8","010_10_8","1SA","10","8","8","Tauma e bautaite iee aitaa bola debama Gilgal bedewe ita e bola sa bedewe wanempo walama 7 dialepi. Ita ne sape wineape dima dieepo rua dewasa. Ne pue pulontompe sumpa pulowa ita wanwan euda pulowa dewasapa Iawe God mampe, sa ipa no me do deantena pulowa.” ");
INSERT INTO soq_vpl VALUES ("S110_9","010_10_9","1SA","10","9","9","Sol Samuel ene leulene aleidia walamawe God me insaisawa sanaasano apana sanaa segalen. Ita walama sawo Samuel dima bauta wamona uduudu ipawanalen. ");
INSERT INTO soq_vpl VALUES ("S110_10","010_10_10","1SA","10","10","10","Sol ita me nolawa dewala bola debama ebowa Gibea wimone ita peroweta uduudu suinta mampo ieio ewamoiena. Tane God aleupa Sol osowe ieno me do God aiawa wawa ualene wadaposileidie ita do rasaleidie. ");
INSERT INTO soq_vpl VALUES ("S110_11","010_10_11","1SA","10","11","11","Tane apana mida Sol atentoiena, me God aiawa wadie ita wadaposileidie do rasaleidio ibuwa ewane waienase, “Ema ulaipa, ba? Kis otopa mampe dima segaleide? Sol me peroweta, ba?” ");
INSERT INTO soq_vpl VALUES ("S110_12","010_10_12","1SA","10","12","12","Mo wane waienase, “Sol ide ulaipa peroweta, ba? Mo walama sawo uantone aia sa waiena tauma ideita wai. Ipawa apana dea wane wanase, ‘Dima baiwa me mamba atentata umanawa waitana, apana da reba peroweta nolawa wadepia rua?’” ");
INSERT INTO soq_vpl VALUES ("S110_13","010_10_13","1SA","10","13","13","Sol God aiawa wadie ita wadaposileidie do rasaleidia diasane aupe odene wadaposintompa bolawe alen. ");
INSERT INTO soq_vpl VALUES ("S110_14","010_10_14","1SA","10","14","14","Tane me mamba da, otopa Sol ita me nolawa dewalala do dommone ita waitaramone wanase, “E naepe wainile wilen?” Tane Sol sipoasane wanase, “No donki banumoite ita mai dommopona, dia. Sa baiwa no anten Samuel mampe diato pue naepe waimoia umanawa dianepia baiwa.” ");
INSERT INTO soq_vpl VALUES ("S110_15","010_10_15","1SA","10","15","15","Tane me mamba da kaina waitaralene wanase, “Tane Samuel ambi wane dialen?” ");
INSERT INTO soq_vpl VALUES ("S110_16","010_10_16","1SA","10","16","16","Sol wanase, “Me dianena ipa, apana da donki dommon.” Tane meida Israel apanawa warereulepia umanawa Samuel wana mamba mai benemasapona, dia. ");
INSERT INTO soq_vpl VALUES ("S110_17","010_10_17","1SA","10","17","17","Ita Samuel Israel apanawa diamona ando bola debama Mispa bedewe antopue Iawe God aiawa etapu. ");
INSERT INTO soq_vpl VALUES ("S110_18","010_10_18","1SA","10","18","18","Mo antone bola sa bedewe wimono Samuel diamone wanase, “Iawe, e nosinosila Godiu ema epe wade, ‘E Isibt apanawa mukau atowe wainilano otaubalene banlalene bola emauwo winene ita bola daitada apanawa e ituaisileia mampo inalena. ");
INSERT INTO soq_vpl VALUES ("S110_19","010_10_19","1SA","10","19","19","Ne ipa e Godila nuapare ita poka bedewe sauledina apanawa, tane e ne dabuaneale walanase, “No dabuanten menanedia wareremba enepie ita onianepi.” Sa baiwa ne Iawe, e Godila mainawo auwenatue ita uwa daitada ita do danla ruawaitane intaweintawe enana.’ ");
INSERT INTO soq_vpl VALUES ("S110_20","010_10_20","1SA","10","20","20","Ita Samuel Israel apanawa uwa daitada diamono deadea mampe wimoiena. Mo epe dewantoio bedewe Iawe God Beniamin damba sonaben. ");
INSERT INTO soq_vpl VALUES ("S110_21","010_10_21","1SA","10","21","21","Ita Samuel Beniamin damba bedewe uwa deadea apamono odeiena. Mo deadea odeia bedeuwo Iawe God Matri sonaben ita Matri obampa bedeuwo Kis sonaben ita Kis obampa bedeuwo Sol sonaben. Ita apana Sol banusaie ewapona baiwa ita mai ewapona. ");
INSERT INTO soq_vpl VALUES ("S110_22","010_10_22","1SA","10","22","22","Sa baiwa mo Iawe God waitarasaiena, “Me naepe?” Iawe God sipoamone wanase, “Me mo puraiwau sawanauwo weregaleide.” ");
INSERT INTO soq_vpl VALUES ("S110_23","010_10_23","1SA","10","23","23","Apana weuwane antone banusane donsane ita banlene apana danauwo ituieno enen. Me apana daumawa eneno apana uduudu me awanapa atowenton. ");
INSERT INTO soq_vpl VALUES ("S110_24","010_10_24","1SA","10","24","24","Ita Samuel apana diamone wanase, “Me ipa sa Iawe God sonaben e warerela. Mai mida da no Israelwa uduudu bedembo me rua, dia.” Ita apana uduudu rasantone waienase, “Warereitone wankasaitaa!” ");
INSERT INTO soq_vpl VALUES ("S111_14","010_11_14","1SA","11","14","14","Tane ema aupe Samuel Israel apanawa mampo wanase, “Wino ana bola debama Gilgal bedewe ita osowe wate sabamosata Sol ipa no wareremba.” ");
INSERT INTO soq_vpl VALUES ("S111_15","010_11_15","1SA","11","15","15","Sa baiwa mo uduudu anton bola debama Gilgal bedewe Iawe God wadaposisane waienase, “Sol ipa no wareremba.” Ita sape mo wanwan euda pulowa Iawe God mampe ituiena, ita mo awodeantone pulo nanawa naiena. Sa baiwa Sol ita Israel apanawa uduudu nuau eudidalen. ");
INSERT INTO soq_vpl VALUES ("S113_13","010_13_13","1SA","13","13","13","Ita ema aupe Samuel Sol diene wanase, “E dewakaditen mai insadewasaitapona. E mai Godia anaanawa ruaitapona. Naita e Iawe God anaanawa ruaitapono me eepono e ita e nosinosia do Israel apanawa oniamoipe wankasaitapona. ");
INSERT INTO soq_vpl VALUES ("S113_14","010_13_14","1SA","13","14","14","Tane e ando apana mai oniakasamoa, dia. Iawe God apana da sonabena itupi, apana sa insaisawa God insaisawa rua. E mai Iawe God anaanawa ruaitapona, sa baiwa e aupaa apana da sonabepie itupio apanawa oniamopi.” ");
INSERT INTO soq_vpl VALUES ("S115_1","010_15_1","1SA","15","1","1","Walama dea Samuel Sol diene wanase, “Ne ipa ema Iawe God waaubanen mena osoawo memeno ita e warere segaiten me apanawa Israelwa uwaute oniamoa baiwa. Sa baiwa e Iawe God gagaloleidia deaitopa asisusaa. ");
INSERT INTO soq_vpl VALUES ("S115_2","010_15_2","1SA","15","2","2","Iawe God Mukamukaua wanase, ‘Walama sawo Israel apana Isibtiwae nomoio Amalek apanawa nosinosiu mo bodamoiena, sa baiwa ne tauma mo kadimopa. ");
INSERT INTO soq_vpl VALUES ("S115_3","010_15_3","1SA","15","3","3","E aitane Amalek apanawa do onaitana ita nitu uduudu mo mampoa kadimonatuapi, mai nitu da ena. Tane apana mona, ioto, seda debamau ita gegelau ita do mo pueu kau, sipsip, kamel ita donki uduudu bomonatuwapi.’” ");
INSERT INTO soq_vpl VALUES ("S115_4","010_15_4","1SA","15","4","4","Sa baiwa Sol sorodia mampo gagalo wanauben wimpue sausapue onantopua baiwa. Mo uduudu wimone bola debama ebowa Telem bedewe auweiena. Iuda damba bedewe sorodia wisiau uduudu 10,000 wimoiena. Ita Israel damba isiwa bedewe wimone auweieno wisia 200,000 waden. ");
INSERT INTO soq_vpl VALUES ("S115_7","010_15_7","1SA","15","7","7","Sol ualene sorodia banlamone Amalek apana do onantoie ita aimoiena. Mo Awila bolawa bedewe ona uantone antoie bola debama Sua bedewe Isibtiwa omo wiseidiawo wimoiena. ");
INSERT INTO soq_vpl VALUES ("S115_8","010_15_8","1SA","15","8","8","Me Agag Amalek apanawa warereu mai bosapona di taune banlene anton. Tane mo Amalek apanawa uduudu bomonatuaiena mai da epona, dia. ");
INSERT INTO soq_vpl VALUES ("S115_9","010_15_9","1SA","15","9","9","Sol ita ona apanawa do mai Agag bosapona dia, ita do mo mai pue eubu sipsip ita kau, mo pueu eubuida ita mo puraiwa eubu mai kadimopona dia. Mo pue ita puraiwau dainea mo eweie dabuamodia sa os kadimoiena. ");
INSERT INTO soq_vpl VALUES ("S115_10","010_15_10","1SA","15","10","10","Tane ema aupe Iawe God Samuel diene wanase, ");
INSERT INTO soq_vpl VALUES ("S115_11","010_15_11","1SA","15","11","11","“Ne nuana pareidalen Sol dewasano warerelena baiwa. Ipawa me ne adianananen ita ne anaanana mai ruawalepona dia.” Samuel Iawe God gagaloleidia etene nuawa pareleno ita tadina sawo me badowaida rauparikasalen. ");
INSERT INTO soq_vpl VALUES ("S115_12","010_15_12","1SA","15","12","12","Imonemba tadinaida Samuel Sol banuwa alen ewepia baiwa. Tane apana da me diene wanase, “Sol alen bola debama ebowa Kamel bedewe. Sape me seu eindoden apana seu sa ewompe me asowa wampa baiwa. Tane sa aupe me bola debama Gilgalwa iene alen.” ");
INSERT INTO soq_vpl VALUES ("S115_13","010_15_13","1SA","15","13","13","Samuel alene Sol donsano ita me diene wanase, “Samuel, Iawe God sauwa euda e manawo! Ne Iawe God anaanawa ruawanten.” ");
INSERT INTO soq_vpl VALUES ("S115_14","010_15_14","1SA","15","14","14","Tane Samuel sipoasane wanase, “Naita e me anaanawa ruaitapono dewa uduudu kadimopatuapona, tane dima baiwa sipsip ita kau aiau waio ne etedina?” ");
INSERT INTO soq_vpl VALUES ("S115_15","010_15_15","1SA","15","15","15","Tane Sol sipoasane wanase, “Ne sorodiana mida onantoia mo pue sa Amalek apanau mampo oteiena. Mo pue sipsip ita kau eubu emoiena Iawe e Godia mampe pulontompa baiwa tane isiwa no bomotatuwan.” ");
INSERT INTO soq_vpl VALUES ("S115_16","010_15_16","1SA","15","16","16","Tane Samuel Sol diene wanase, “Dainaitaa! Tadino Iawe God ne mainawo gagalolene wana ne dieepa.” Sol sipoasane wanase, “Me ambi wan?” ");
INSERT INTO soq_vpl VALUES ("S115_17","010_15_17","1SA","15","17","17","Samuel sipoasane wanase, “Mapo e inseianase e apana kerauda tane tauma e ipa Israel apanawa uwaunepa. Iawe God mena osoawo ituna sa ipa mo warereu. ");
INSERT INTO soq_vpl VALUES ("S115_18","010_15_18","1SA","15","18","18","Me badowa wane dieene ita e waaubaena aitee Amalek apanau mida kadi dewasaia baiwa kadimoatuwapi. Me e dieena onaitone ideita uduudu bomoatuwapi. ");
INSERT INTO soq_vpl VALUES ("S115_19","010_15_19","1SA","15","19","19","E dima baiwa Iawe God aiawa mai ruaitapona? Me e dieena mo puraiwau da mai nuauepio ewee wadaa dia. Tane e ewanuautene nitu isiwa otamoana, e dewa kadiwaida dewasaana me emawe.” ");
INSERT INTO soq_vpl VALUES ("S115_20","010_15_20","1SA","15","20","20","Sol sipoasane wanase “Ne Iawe God wana ruawantene antene ita Amalek apanawa uduudu bomonatuwan tane mo warereu Agag os wadane banlene winen. ");
INSERT INTO soq_vpl VALUES ("S115_21","010_15_21","1SA","15","21","21","Tane ne sorodiana onantoia mo sipsip ita kau eubu mai bomopona, dia. Ita mo pue sa otamone bola debama Gilgal bedewe wimon Iawe e Godia mampe pulo itumpa baiwa.” ");
INSERT INTO soq_vpl VALUES ("S115_22","010_15_22","1SA","15","22","22","Tane Samuel wanase, “Nitu dainea Iawe God nuawa eusade: pue puloitile suilana ita do pulo isiwa dewamoilana mampe, ba me aiawa etane ruawaitana mampe? Asisuitana! Iawe God aiawa etane ita ruawaitana sa ipa eudida mai pulo ituitana rua, tane no Iawe God mampeidontata sa ipa euda mai pue pulontoia rua. ");
INSERT INTO soq_vpl VALUES ("S115_23","010_15_23","1SA","15","23","23","Naita apana Iawe God amboitusapua, kadi sa ipa wene rua. Tane apana nuau badosaie ne aiana mai ruantoipona, sa ipa apana kokoitau mampo imimpu emmisintoia rua. E Iawe God anaanawa mai ruawaitapona, sa baiwa me e adiananaen ita e ando mai warereite apana oniamoa, dia.” ");
INSERT INTO soq_vpl VALUES ("S115_27","010_15_27","1SA","15","27","27","Sape me leulenitue a baiwaleidio Sol Samuel garawa moa wadendodeno ita isuaden. ");
INSERT INTO soq_vpl VALUES ("S115_28","010_15_28","1SA","15","28","28","Tane Samuel wanase, “E ne garana moa wadaadodeno isuadena rua deawaa e warereitene Israelwa oniamoiana mukawa manawo wadenaubene apana da euda mai e ruaa wanen. ");
INSERT INTO soq_vpl VALUES ("S115_29","010_15_29","1SA","15","29","29","Israelwa Godiu ipa wanwankasalala, me mai lagaleipona ba insaisawa leusaitusaipona, me ando dewasapi. Me mai apanaida no ruamba, me mai insaisawa leusapi, dia.” ");
INSERT INTO soq_vpl VALUES ("S115_34","010_15_34","1SA","15","34","34","Ita Samuel bolawa debama Rama bedewe alen tane Sol leulene bolawa debama Gibea bedewe alen. ");
INSERT INTO soq_vpl VALUES ("S115_35","010_15_35","1SA","15","35","35","Samuel wandia walamawe Sol ibuwa mai osowe ewapona. Tane me ibuwa insedia walamawe nuawa pareidaleidie. Tane Iawe God do nuaparewalen ipawa me dewasano Sol Israel apanawa warereu segalena baiwa. ");
INSERT INTO soq_vpl VALUES ("S116_1","010_16_1","1SA","16","1","1","Iawe God Samuel diene wanase, “E dima baiwa Sol nuaparewaitiana? Ne mai menaneipona me Israelwa warereu waimpa. Tauma mena sipsip donawa bedewe memee wadee ita Beteliemwa apana ebowa Iese mampe aitaa. Me obampa uduudu bedeuwo dea ne sonabena warerelepia baiwa.” ");
INSERT INTO soq_vpl VALUES ("S116_2","010_16_2","1SA","16","2","2","Tane Samuel wanase, “Ambi anteapa? Dewa ema umanawa Sol etepia ne epanepibolepi.” Tane Iawe God wanase, “A baiwa kau iwoa bunawa wade aite ita waase, ‘Ne Iawe God mampe pulo itupa baiwa winen.’ ");
INSERT INTO soq_vpl VALUES ("S116_3","010_16_3","1SA","16","3","3","E pue susuwa baiwa Iese nisosawo wisepio ita ne waeuwaepo rua dewaitaa. Me otopa dea ne sonabena euwaepo ewee ita me mena uawa osowe memea.” ");
INSERT INTO soq_vpl VALUES ("S116_4","010_16_4","1SA","16","4","4","Iawe God wana rua Samuel enenwisene ita Beteliemwa alen. Ita sape apana eiau me donsane saidantone ita waienase, “E a euwa wien, ba?” ");
INSERT INTO soq_vpl VALUES ("S116_5","010_16_5","1SA","16","5","5","Me sipoamone wanase, “Oa, ne Iawe God mampe pulo itupa baiwa winen. E eba imaaitane ita winleno antate Iawe God mampe pulo ituta.” Samuel Iese obampa do nisomona muba imaantopue tauma antopu pulo itutuwa baiwa. ");
INSERT INTO soq_vpl VALUES ("S116_6","010_16_6","1SA","16","6","6","Mo antone wimono Samuel Iese otopa tautuwa Eliab ewene insenase, “Ulaipa, apana ema Iawe God sonaben.” ");
INSERT INTO soq_vpl VALUES ("S116_7","010_16_7","1SA","16","7","7","Tane Iawe God Samuel diene wanase, “Mai me inainamba euda ita do muwa daumawa ewee insea, ipawa ne me ewanadabuasana. Apana mai ne Iawe God ewedina rua eweipona. Apana ete onapea ewei tane ne apana nuawa ewedina.” ");
INSERT INTO soq_vpl VALUES ("S116_10","010_16_10","1SA","16","10","10","Sa baiwa Iese obampa uduudu 7 diamono Samuel mampe anton. Tane me Iese diene wanase, “Iawe God e obana ema mai da sonabepona, dia.” ");
INSERT INTO soq_vpl VALUES ("S116_11","010_16_11","1SA","16","11","11","Ita Samuel Iese diene wanase, “E obana uduudu mape wimonatuaiena, ba?” Iese sipoasane wanase, “Ne otona ompa wande, tane me tauma sipsip oniamode.” Tane Samuel wanase, “Apana isiwa waaubamowo antopue me banlepue wimpu. Me wisepio tauma no aisintate wanta.” ");
INSERT INTO soq_vpl VALUES ("S116_12","010_16_12","1SA","16","12","12","Sa baiwa Iese apana isiwa waaubamono anton me banlepua baiwa. Tane Dawid me muwa ipa euda do apana sanaa emademba emawa ewaewa eudida. Dawid wiseno Iawe God Samuel diene wanase, “Me ipa sa! Tauma aite mena me osowe memea.” ");
INSERT INTO soq_vpl VALUES ("S116_13","010_16_13","1SA","16","13","13","Ita sape me tatatawa eneio danauwo Samuel mena sipsip donawa bedewe winedia wadene ita Dawid uawe memen. Ita Iawe God aleupa mukamukaua Dawid osowe ien ita walama sawo ita odene su alena me mai epaiapona, dia. Ita Samuel ene bola debama Rama bedewe alen. ");
INSERT INTO soq_vpl VALUES ("S116_14","010_16_14","1SA","16","14","14","Tane Iawe God aleupa Sol ene aleno aupe Iawe God aleu kadiwa Sol osowe iene dewasadio saidaleidie os wandie. ");
INSERT INTO soq_vpl VALUES ("S118_5","010_18_5","1SA","18","5","5","Sol Dawid wadiaubedio ona daitada bedewe aleidie onaleidie ita Dawid onaleidia ipa euda os. Sa baiwa Sol Dawid wadene itunposideno sorodia uwau apana segalen. Sol Dawid epe dewasano apana uduudu nuau eudidalen, ita Sol sorodia do nuau eulen. ");
INSERT INTO soq_vpl VALUES ("S118_6","010_18_6","1SA","18","6","6","Dawid Pilistan apanawa debama dea epenbolen, me ebowa ipa Golaioti. Tane sape sorodia onantoia ene leutone bolauwo antoio, ioto Israel bolawa debama deadea bedewe waimoia nomone warere Sol donsapua baiwa anton. Mo gita ita tambarin epeie ita nuaeu sasawa waie ita biantoie. ");
INSERT INTO soq_vpl VALUES ("S118_7","010_18_7","1SA","18","7","7","Tane ioto sa mo gita epeie ita sasantoie waiase, “Sol emalawoa apanawa 1,000 bomon tane Dawid emalawoa apanawa 10,000 bomon!” ");
INSERT INTO soq_vpl VALUES ("S118_8","010_18_8","1SA","18","8","8","Tane Sol aia ema etene mai nuawa eulepona, dia. Sa baiwa me nuawa kadileno ema epe insen, “Mo Dawid ituposisaie waiase, ‘Me apana 10,000 bomon ita ne 1,000 os bomona. Ita mo ando me dewasapuo warereulepi!’” ");
INSERT INTO soq_vpl VALUES ("S118_9","010_18_9","1SA","18","9","9","Ita walama sawo ualene odene alena Sol Dawid emalawoasadie. ");
INSERT INTO soq_vpl VALUES ("S121_1","010_21_1","1SA","21","1","1","Dawid alen bola debama ebowa Nob bedewe pirisi ebowa Elimelek ewepia baiwa. Elimelek nosene alen Dawid donsapie auwasapia baiwa ita me salene wanase, “E dima baiwa eba mape wien?” ");
INSERT INTO soq_vpl VALUES ("S121_2","010_21_2","1SA","21","2","2","Dawid pirisi Elimelek sipoasane wanase, “Ne warere dianena nitu da dewasapa. Tane me ne dianene wanase, ‘Ne waaubaedina umanawa ita waeuwa dieena mai mida da diaa!’ Ne sorodiana diamona antopue bola dea bedewe ne onianeapu. ");
INSERT INTO soq_vpl VALUES ("S121_3","010_21_3","1SA","21","3","3","E nana da manawo winede ba dia, ne neaa? Bured uduudu 5 ba nana dainea e manawo winompa neaa.” ");
INSERT INTO soq_vpl VALUES ("S121_4","010_21_4","1SA","21","4","4","Tane pirisi Elimelek me sipoasane wanase, “No mai bured da mainimbo wineipona. Tane bured Iawe mampe amonantoiena sa os winede. E bured ema wadane nana rua, naita sorodiaa mai ioto do ituntopua mo napua rua.” ");
INSERT INTO soq_vpl VALUES ("S121_5","010_21_5","1SA","21","5","5","Dawid sipoasane wanase, “Ulaipaida, no ona awa antitana walamawe mai iotomba do itunteipona, ne apanana sanaau muba etepu onieidewantoi. Ande no nubaida etemba onietadewanten nola ema debama dewasataa baiwa.” ");
INSERT INTO soq_vpl VALUES ("S121_6","010_21_6","1SA","21","6","6","Tane nana da mai wineipe, sa baiwa bured Iawe God mampe amonantona otawialene nambe teeno wineia pirisi otene Dawid wanen. Ipawa aita me bured sanaa otawialene aupe teen. ");
INSERT INTO soq_vpl VALUES ("S131_1","010_31_1","1SA","31","1","1","Ita walama sawo Pilistan apana ita Israel apana do wadi Gilboa osowe onantoie. Israelwa sorodiau Pilistan apanawa sorodiau sauntone weuwane antoiena. Tane Pilistan apanawa enane Israel apanawa uaraia bomoiena. ");
INSERT INTO soq_vpl VALUES ("S131_2","010_31_2","1SA","31","2","2","Pilistan apanawa enane Sol ita obampa Ionatan, Abinadab ita Malikisua do tanamone wawo antone ita me obampa bomoiena. ");
INSERT INTO soq_vpl VALUES ("S131_3","010_31_3","1SA","31","3","3","Tane ona debamakadilen ita mo Sol enane panane ita pidu mampe enidasaiena. ");
INSERT INTO soq_vpl VALUES ("S131_4","010_31_4","1SA","31","4","4","Ita Sol, me onawa puraiwa mida awanedia apanawa sa diene wanase, “E onaa isimawa wadaaubee ita mampe ne bonea. Ne mai menaneipona Pilistan apanawa god da sumanaiwantoia apanawa wasineapue ita boneapu.” Tane sorodia me bosapona salen. Ita Sol, meba isimawa wadenaubene eindoe osowe aubaubaulene ita meba enenbobolen. ");
INSERT INTO soq_vpl VALUES ("S131_5","010_31_5","1SA","31","5","5","Tane sorodia sa Sol boleno ewene ita meba isimawa wadenaubene ita enenbobolen, ambi Sol bolen rua. ");
INSERT INTO soq_vpl VALUES ("S25_1","011_5_1","2SA","5","1","1","Israelwa uwau apanawa antone Dawid bola debama Ibron bedewe donsane ita waienase, “No ipa e dana moa. ");
INSERT INTO soq_vpl VALUES ("S25_2","011_5_2","2SA","5","2","2","Mapoido Sol ipa no wareremba, tane e Dawid dea osi Israelwa sorodiau uwau apanawa wainie mo banlamoiano nomoie ona awa antoie. Iawe God e dieene wanase, ‘E ne apanana Israelwa oniadewasamona, ambi gamo oniadewasala apanawa sipsipwa oniadewasamodia rua.’” ");
INSERT INTO soq_vpl VALUES ("S25_3","011_5_3","2SA","5","3","3","Tane walama sawo Israelwa apanau debamau uduudu bola debama Ibron bedewe Dawid mampe wimon, ita Dawid Israel apanawa do Iawe God emawe sauanton. Sa ipa Israel apanawa uwauntoia mena wadane Dawid uawa osowe memene euwamon me ipa tauma Israelwa warereu. ");
INSERT INTO soq_vpl VALUES ("S25_4","011_5_4","2SA","5","4","4","Tane Dawid enawa 30 wadedio, me warerelene Israel apanawa oniamono ena 40 dialen. ");
INSERT INTO soq_vpl VALUES ("S27_1","011_7_1","2SA","7","1","1","Iawe God Dawid gonaasane ita kakaisan emalawoa apanawa mampo ita do muka wanena mo nanaumopi. Sa baiwa me duwa bedewe wanwan obasawa bedewe wandie. ");
INSERT INTO soq_vpl VALUES ("S27_2","011_7_2","2SA","7","2","2","Ita me peroweta Natan diene wanase, “Ne duna ia badowa eubu ebowa sida mampe wadawadala bedewe wainedina. Tane God sauawa badowa bokisiwa ape bedewe winede.” ");
INSERT INTO soq_vpl VALUES ("S27_3","011_7_3","2SA","7","3","3","Tane Natan warere diene wanase, “Iawe God ipa e do, aite dima inseiana rua dewasaa.” ");
INSERT INTO soq_vpl VALUES ("S27_4","011_7_4","2SA","7","4","4","Tane tadina sawo Iawe God Natan diene wanase, ");
INSERT INTO soq_vpl VALUES ("S27_5","011_7_5","2SA","7","5","5","“Aite ne nolana dewalala Dawid diee waase, ‘Iawe ema epe wade: Mai e ne duna wadawo bedewe wampa, dia.’” ");
INSERT INTO soq_vpl VALUES ("S27_8","011_7_8","2SA","7","8","8","Ne nolana dewalala Dawid diee waase, “Iawe God Mukamukaua ema epe wade: ‘Mapo e ipa ituaisilalaida pue ina naia bolawe sipsip oniamoie. Tane ne e sonabaene itueno Israel apanawa uwaula segaiten. ");
INSERT INTO soq_vpl VALUES ("S27_9","011_7_9","2SA","7","9","9","E naepe aitiano ne do sape antedine ita sauene emalawoa apanawa nanaumone ita aimona. Tauma ne e eboa debamasapa, tawo osowe apana ebou debamaleidia, rua. ");
INSERT INTO soq_vpl VALUES ("S27_10","011_7_10","2SA","7","10","11","Ne apanana Israelwa bolau wanamopa sape mo wanwan obasa bedewe wampudewae waimompa. Walama sawo uwauntompa apanawa ne teamono Israelwa oniamoie tane emalawoa apanawa mo poka wanamoie. Tauma mo ando mai epe dewantopua rua, dia. Ne mai osowe emalawoa apanawa dewamopo wimopue poka enalepu, dia. Ne Iawe God, e nosinosila do dewalepo warereitonuna. ");
INSERT INTO soq_vpl VALUES ("S27_12","011_7_12","2SA","7","12","12","Tane warere sa e dana bedewe eba obana bedeuwo dea sonabepo warerelepi. E gulaute boitawo nosinosia dobosamoienawo sape dobosaepu. Tane ne me dewasapo onionia apanawa mukamukaua segalepie gonaawa badowa enepi, mai mida me ituaisisapia rua. ");
INSERT INTO soq_vpl VALUES ("S27_13","011_7_13","2SA","7","13","13","Ita do mai mida wisepie me wanwanba bolawa wadepia rua, diaida. Me ando ne duna wadepi. ");
INSERT INTO soq_vpl VALUES ("S27_14","011_7_14","2SA","7","14","14","Ne ipa me mamba wananteapa ita me ne otona wanalepi. Naita me kadiwa dewasapia ne me poka wanapa, ambi oto mamba otopa poka wanedia, rua. ");
INSERT INTO soq_vpl VALUES ("S27_15","011_7_15","2SA","7","15","15","Tane ne nuawadawadana me mampe mai wadapaaubepa Sol mampe dewasana rua, dia. Ne warere Sol wadanaaubene aupe e ituedina warereitaa. ");
INSERT INTO soq_vpl VALUES ("S27_16","011_7_16","2SA","7","16","16","E dana ando mai enepiitudepi ita do e dana bedewe mo ando warerekasantopu.’” ");
INSERT INTO soq_vpl VALUES ("S27_17","011_7_17","2SA","7","17","17","Dima uduudu auen rua bedewe Natan Iawe God mampe etena umanawa Dawid benemasan. ");
INSERT INTO soq_vpl VALUES ("S211_1","011_11_1","2SA","11","1","1","Madia walamawe mo dewau rua warere nomoie ona awa antoi. Sorodia uwaula apanawa ita do Israelwa sorodiau uduudu ona baiwa anton ita Dawid Ioab do wanaubeno alen Amon apanawa do onantopua baiwa. Walama sawo mo antone Amoniwa ona apanawa bomonatuwaiena. Ita enee bola debama Raba enane paneiena ita mai mida wisepie odepi ba nosepie alepi, dia. Tane Dawid bola debama Ierusalem bedewe wandie. ");
INSERT INTO soq_vpl VALUES ("S211_2","011_11_2","2SA","11","2","4","Tane walama dea rawileidio Dawid ituleidie enenwisene ita duwa iwa osowe enedie leidie, ita i esa bedewe duadileidio ewen. I sa ipa uwatauwa ewaewa eudida. (Me uaboa wadeno mo dewau rua duadileidio Dawid ewen). Sa baiwa Dawid apana dea wanaubeno alen i ewepie atenlepia baiwa. Ita me atensane leulene wisene wanase, “I sa Besiba, Eliam anoopa Itai apanawa ebowa Uria manainapa.” Sa baiwa Dawid gagalo wanaubeno ita Besiba me mampe wiseno nata ituntone ita ene leulene duwe alen. ");
INSERT INTO soq_vpl VALUES ("S211_5","011_11_5","2SA","11","5","5","Tane i wandie bulene ita gagalo wanaubeno Dawid mampe aleno wanase, “Ne bunten.” ");
INSERT INTO soq_vpl VALUES ("S211_6","011_11_6","2SA","11","6","6","Tane Dawid Ioab mampe gagalo wanaubene wanase, “Uria Itai apanawa wanaubeno ne mainawo wimpi.” Ita Ioab Uria wanaubeno leulene Dawid mampe alen. ");
INSERT INTO soq_vpl VALUES ("S211_7","011_11_7","2SA","11","7","7","Uria Dawid mampe wiseno ita waitarasane wanase, “Ioab ita sorodia tauma ambi dewantoi ita ona tauma ambi aleide?” ");
INSERT INTO soq_vpl VALUES ("S211_8","011_11_8","2SA","11","8","8","Tane Dawid Uria diene wanase, “Aie duawo ita bubuaita.” Uria warere duwa ene aleno wawe pulowa wadane antone waneiena. ");
INSERT INTO soq_vpl VALUES ("S211_9","011_11_9","2SA","11","9","9","Tane Uria duwe mai alepona, dia. Tane me alene warere duwa nope itulen Dawid nolawa dewasaia apanawa do. ");
INSERT INTO soq_vpl VALUES ("S211_10","011_11_10","2SA","11","10","10","Ita mo Dawid diane waienase, “Uria mai duwe alepona, dia.” Dawid Uria diene wanase, “E inta daumaia wien, dima baiwa e mai duawo aitapona?” ");
INSERT INTO soq_vpl VALUES ("S211_11","011_11_11","2SA","11","11","11","Tane Uria Dawid diene wanase, “Saua badowa bokisiwa ape bedewe winede ita Israelwa ita Iuda apanawa do ape bedewe waimoi. Ita ona ualeidia apana Ioab ita me sorodiawa sabamo apua saradountone waimoi. Sa baiwa ne mai dunawo anteape nana ita esa nape do manainana nata ituntata. Ne ulaipaida diedina mai epe dewanteapa rua, dia.” ");
INSERT INTO soq_vpl VALUES ("S211_12","011_11_12","2SA","11","12","12","Sa baiwa Dawid Uria diene wanase, “Ande e mape bubuaite wankasaitaa ita imonepi ne waaubaepo leute aitaa.” Ita Uria Ierusalem bedewe wandio walama nata diantono ene alen. ");
INSERT INTO soq_vpl VALUES ("S211_13","011_11_13","2SA","11","13","13","Ita sape Dawid Uria apasano mampe wiseno nana ita esa naiena. Ita Dawid esa badowa Uria waneno nane ua koakoalen. Tane rawiwa Uria nosene alene nogiwa osowe itulen Dawid nolawa dewalala apanawa do, mai duwe alepona, dia. ");
INSERT INTO soq_vpl VALUES ("S211_14","011_11_14","2SA","11","14","14","Tane tadinaida Dawid leta girumalen Ioab mampe alepia baiwa ita leta sa Uria waneno wadene alen. ");
INSERT INTO soq_vpl VALUES ("S211_15","011_11_15","2SA","11","15","15","Tane leta sa bedewe wadiase, “Uria wadee ona pokawaida nambanepe ituwo enepi ita sorodia da otamoe Uria adiwe teamowo enapu. Ita mo me epuiapuo meba nambanepe enepio epapubolepi.” ");
INSERT INTO soq_vpl VALUES ("S211_16","011_11_16","2SA","11","16","16","Tane Ioab bola debama Raba ewedie insaisawaleidie ita me atenlen sorodia mukawauida naepe eneia bolawa me atemba. Sa baiwa me Uria wanaubeno bola sa osowe alene enen. ");
INSERT INTO soq_vpl VALUES ("S211_17","011_11_17","2SA","11","17","17","Ita bola debama sa apanawa nomone antone ita Ioab apanawa do onantone ita Dawid apanawa isiwa bomoiena. Ita do mo Uria bola Itai apanawa bosaiena. ");
INSERT INTO soq_vpl VALUES ("S211_26","011_11_26","2SA","11","26","26","Ita Uria manainapa badawa boleno umanawa etene kewa wadie. ");
INSERT INTO soq_vpl VALUES ("S211_27","011_11_27","2SA","11","27","27","Tane kako walamawa dialeno Dawid apana da wanaubeno Besiba banlepie me duwe wimpia baiwa alen. Ita Dawid Besiba wadene mampesane manainapa wanasan. Tane Besiba otopa mona gamosan. Dawid dewawa kadiwa dewamodia baiwa Iawe God mai nuawa eulepona. ");
INSERT INTO soq_vpl VALUES ("S212_1","011_12_1","2SA","12","1","1","Sa baiwa Iawe God Natan wanaubeno Dawid mampe alene diene wanase, “Apana nata bola debama bedewe waimoie, apana dea ipa maura apana tane da ipa abolala. ");
INSERT INTO soq_vpl VALUES ("S212_2","011_12_2","2SA","12","2","2","Tane maura apana mampe ipa pue sipsip ita kau uaraia. ");
INSERT INTO soq_vpl VALUES ("S212_3","011_12_3","2SA","12","3","3","Apana abolala sipsip iwoa sanaa wadene wisena debamalene ita apana sa obampa do awodea waimoie. Tane sipsip iwoa sanaa dea os apana abolala mampe wandie ita apana sa abolala nanawa moa kerauda nadie, ita do me reduwa bedewe esa memedio nadie, itu baiwa apana sa abupa osowe ituleidie. Ita me dewasadia ewaewa anoopa kerauda rua. ");
INSERT INTO soq_vpl VALUES ("S212_4","011_12_4","2SA","12","4","4","Tauma ware dea leidie wisen maura apana duwe ita maura apanawa mai menasapona meba sipsipwa ba kau wadepie ware wanepio napi, dia. Tane maura apanawa alene apana abolala mampe sipsipwa iwoa wadene nulene warewa wisena wanen.” ");
INSERT INTO soq_vpl VALUES ("S212_5","011_12_5","2SA","12","5","5","Tane walama sawo Dawid nuawa kadiidalen apana sa dudunawa etene ita Natan mampe wanase, “Ulaipaida, Iawe God wanwankasalala ita me ebowe ne wadina apana sa dewa ema dewasana me bolepio dialepi. ");
INSERT INTO soq_vpl VALUES ("S212_6","011_12_6","2SA","12","6","6","Me dewa kadiwa dewasan mai sowa nuaparewalepona. Sa baiwa me ideita sipsip sanaa sipoa uduudu 4 otamopie apana abolala wanepi.” ");
INSERT INTO soq_vpl VALUES ("S212_7","011_12_7","2SA","12","7","7","Tane Natan Dawid mampe wanase, “Apana ipa e! Iawe Israelwa Godiu ema epe wan, ‘Ne e sonabaeno Israelwa warereu segaiten. Sol e boepia mukawa bedewe wainiano ne inaena. ");
INSERT INTO soq_vpl VALUES ("S212_8","011_12_8","2SA","12","8","8","Ne Sol mida oniaedia apanawa duwa ita me manamanainapa eneena. Ita do ne e ituedina Israel ita Iuda bolawa oniea. Tane naita nitu ema uduudu e ewamono manawo keraulepia, ne ando osowe debamasape itupa. ");
INSERT INTO soq_vpl VALUES ("S212_9","011_12_9","2SA","12","9","9","Tane e dima baiwa ne aiana mai ruaitapona? E dima baiwa dewa ema kadiwaida dewasaana? E Uria Itai apanawa ona isima mampe bosaana ita me manainapa wadee manawosae manainaa wanasaana. E Amon apanawa onau isimawa mampe bosaana. ");
INSERT INTO soq_vpl VALUES ("S212_10","011_12_10","2SA","12","10","10","E mai ne aiana ruaitapona, e Uria manainapa wadee ebaa wanasaana, e dewa ema dewasana baiwa e dana bedeuwo apana isiwa epaboiamompa.’ ");
INSERT INTO soq_vpl VALUES ("S212_11","011_12_11","2SA","12","11","11","Ita Iawe God ema epe wade, ‘Ne kerauda os bagora wadape wimpe e dana mampo itupa. E nananepe emaawo ewono ne e manamanainaa otepe mida tanawoaida wanapo do ituntopuo ita apana uduudu ewapu. ");
INSERT INTO soq_vpl VALUES ("S212_12","011_12_12","2SA","12","12","12","E dewa ema werego dewasaana mai apana atentopona tane ne dewa ema sabamo walamo dewasapa ita Israel apanau uduudu emawo ewapu.’” ");
INSERT INTO soq_vpl VALUES ("S212_13","011_12_13","2SA","12","13","13","Ita Dawid Natan mampe wanase, “Ne Iawe God mampe kadiwaida dewasana.” Ita Natan Dawid diene wanase, “Oa, e kadiwa dewasaana, tane Iawe God e kadia insendabuasan, e mai boitaa. ");
INSERT INTO soq_vpl VALUES ("S212_14","011_12_14","2SA","12","14","14","Tane e Iawe God sawasiaitene dewa kadiwaida dewasaana. Sa baiwa e otoa bolepi.” ");
INSERT INTO soq_vpl VALUES ("S212_15","011_12_15","2SA","12","15","15","Ita Natan leulene duwa bedewe aleno aupe Iawe God oto kero waneno pokaida eten. Oto sa Uria manainapa Dawid busano gamolena. ");
INSERT INTO soq_vpl VALUES ("S212_16","011_12_16","2SA","12","16","16","Tane walama sawo Dawid God mampe rauparilen oto baiwa, Dawid odene alene ituwa bolawe nana ene idilene rauparilen ita tadina sa dauma me dogo osowe ituleidio walamalen. ");
INSERT INTO soq_vpl VALUES ("S212_17","011_12_17","2SA","12","17","17","Apana eiau Dawid duwa bedewe me tampe eneia menamodia me dogo osowe ituleidia sausapuo enepiwisepi, tane me mai menasapona ita do nana mo do napona dabualen. ");
INSERT INTO soq_vpl VALUES ("S212_18","011_12_18","2SA","12","18","18","Walama 7 dialeno aupe oto bolen. Dawid nolawa dewalala oto bolena umanawa wapona santon. Ita mo waienase, “Oto wandia walamawe me mampe no gagalontitano mai etaneipe, dia. Tauma oto bolena umanawa ambi wate diata? Meba kadi donsapio!” ");
INSERT INTO soq_vpl VALUES ("S212_19","011_12_19","2SA","12","19","19","Dawid nolawa dewalala awodea mamo gagalontoio ewamone atenlen oto bolen. Sa baiwa Dawid waitaralene wanase, “Oto bolen, ba?” Mo sipoasane waienase, “Oa, oto bolen.” ");
INSERT INTO soq_vpl VALUES ("S212_20","011_12_20","2SA","12","20","20","Dawid epe etene dogo osowe ituleidia enenwisene alene duadilen, mena bonabonaua etepe itune ita gara eubu taumon. Ita ene Iawe God duwa bedewe wadaposilepia baiwa alen. Ema aupe meba duwe alene nolawa dewalala diamono nana wadane wimone waneieno nan. ");
INSERT INTO soq_vpl VALUES ("S212_21","011_12_21","2SA","12","21","21","Nola dewalala Dawid diane waienase, “E ambi epe dewaitiana? Oto inawaa wandia walamawe nana iditie ita ke waie. Tane oto boleno aupe e enaawiene nana naiana!” ");
INSERT INTO soq_vpl VALUES ("S212_22","011_12_22","2SA","12","22","22","Dawid wanase, “Oto inawaa wandia walamawe insenase, ‘Naita Iawe God ne nuaparenalepie oto inasapio wampi, sa baiwa nana idintedine ita ke wadine.’ ");
INSERT INTO soq_vpl VALUES ("S212_23","011_12_23","2SA","12","23","23","Tane tauma oto bolen. Dima baiwa ne nana idinteapa? Ne mai oto leusapo wisepia rua, dia. Ne ando me mampe anteapa. Tane me ne mainawo mai wimpia rua, dia.” ");
INSERT INTO soq_vpl VALUES ("S212_24","011_12_24","2SA","12","24","24","Dawid manainapa Besiba wasausane ita mampe alene nata itunton. Besiba bulene oto mona gamosan ita Dawid oto ebowa ituna Solomon. Iawe God Solomon nuawadawadasan. ");
INSERT INTO soq_vpl VALUES ("S212_25","011_12_25","2SA","12","25","25","Ita Iawe God peroweta Natan wanauben Dawid diepio oto ebowa itupi wapiase Iedidaia. ");
INSERT INTO soq_vpl VALUES ("K12_10","012_2_10","1KI","2","10","11","Warere Dawid Israel apanawa oniamodie, me bauta bola debama Ibron bedewe waina enawa 7 ita Ierusalem bedewe waina enawa 33. Tane me oniamodia enawa awodealena 40 waden. Me wandie boleno mo me nosinosiwa wineiawo bola ebowa Dawid bolawa Ierusalem bedewe dobontoiena. ");
INSERT INTO soq_vpl VALUES ("K12_12","012_2_12","1KI","2","12","12","Tane Solomon mamba Dawid aupawa wadene Israelwa oniamon. Ita God me sausano badowa enen. ");
INSERT INTO soq_vpl VALUES ("K13_3","012_3_3","1KI","3","3","3","Solomon Iawe God nuawadawadasana baiwa mamba Dawid anaanawa ruawaleidie wandie. Tane dea os Iawe God dima wadia mai ruawalepona, dia. Me aleidie god lagawaau wadaposimoia watawa osouwo pue puloleidie ita do piupiu sudie. ");
INSERT INTO soq_vpl VALUES ("K13_4","012_3_4","1KI","3","4","4","Mo bola debama Gibeon bedewe antoie wadapos debama dewasai, sa baiwa warere sape alene pue 1,000 amonalene Iawe God wanen. ");
INSERT INTO soq_vpl VALUES ("K13_5","012_3_5","1KI","3","5","5","Solomon bola debama Gibeon bedewe wandio tadino Iawe God me mampe auen bedewe segalene wanase, “E dima meneede? Dewa uduudu meneedia iririwaitawo eneepa.” ");
INSERT INTO soq_vpl VALUES ("K13_7","012_3_7","1KI","3","7","7","Solomon Iawe God sipoasane wanase, “O Iawe ne Godna e ne mamana aupawa ituneano warerentedina. Ne ipa oto kerauda rua, mai atenteapona ambi apana oniamopa. ");
INSERT INTO soq_vpl VALUES ("K13_8","012_3_8","1KI","3","8","8","Ita e apanaa sonabalala bedeuwo ne e nolaa dewalala ita mo ipa uaraia mai wisiau rua, dia. ");
INSERT INTO soq_vpl VALUES ("K13_9","012_3_9","1KI","3","9","9","Mai mida da meba mukawa mampe e dana ema debama oniamopia rua, dia. Sa baiwa e aten insaisawa euda neawo euda ita kadiwa bedewe ewaewa atenteape e apanaa oniadewasamopa.” ");
INSERT INTO soq_vpl VALUES ("K13_10","012_3_10","1KI","3","10","10","Solomon aten insaisawa euda iririwaleno Iawe God nuawa eudidalen. ");
INSERT INTO soq_vpl VALUES ("K13_11","012_3_11","1KI","3","11","11","Sa baiwa God me sipoasane wanase, “E mai bola emawo wanwana daumalepia, ba ete maurawa mampe debamaitaa ba wenawenaa onau enee nanaumoa iririwaitapona, tane aten insaisawa euda wadee mampe apanaa oniadewasamoa iririwaiten, ");
INSERT INTO soq_vpl VALUES ("K13_12","012_3_12","1KI","3","12","12","sa baiwa e dima iririwa waana ne eneepaa rua! Ne e insaisa euda ita aten e eneepa rua, mai mida da mapo epe wanapona ita mai mida da ando epe wanapa, dia. ");
INSERT INTO soq_vpl VALUES ("K13_13","012_3_13","1KI","3","13","13","Tane e mai maura debama ba eboa debamalepia baiwa iririneapona, ne ideita nitu ema uduudu eneepatuwapi. Tane e inawaa wanempa bedewe mai warere da mane ita ebo debama e wadaana rua wadapu, dia. ");
INSERT INTO soq_vpl VALUES ("K13_14","012_3_14","1KI","3","14","14","Tane e ne aiana etone ita anaanana uduudu ruawaitona e mamaa Dawid dewalena rua ne e dewaepo ena dauma wana.” ");
INSERT INTO soq_vpl VALUES ("K13_16","012_3_16","1KI","3","16","16","Tane ema aupe ioto nata ninalala wanwambu kadilen. Sa baiwa mo warere Solomon mampe wimone me iririsaiena mo saibu dodomanasapi. ");
INSERT INTO soq_vpl VALUES ("K13_17","012_3_17","1KI","3","17","17","I ninalala dea bautaa wane wanase, “Warere, i ema ne nata du dea bedewe wainitee ne oto gamonten. ");
INSERT INTO soq_vpl VALUES ("K13_18","012_3_18","1KI","3","18","18","Tane walama natadea diantono imonemba i ema do otopa gamosan ita me ne nata nuba os du sa bedewe wainite mai mida da, dia. ");
INSERT INTO soq_vpl VALUES ("K13_19","012_3_19","1KI","3","19","19","Tane tadino me otopa osowe koirewalene ainbolen. ");
INSERT INTO soq_vpl VALUES ("K13_20","012_3_20","1KI","3","20","20","Ita tadino itu awawanteno me onanawo wisene oto ne tainawo ituleidia wadene alen. Ita me otopa bobopa wadene tainawo itune en. ");
INSERT INTO soq_vpl VALUES ("K13_21","012_3_21","1KI","3","21","21","Imonemba ne enanawinene oto amamasapa baiwantene tane oto bobopa ewana. Ita walama sapawa bedewe oto ewanadewanten, ema apa mai ne otona.” ");
INSERT INTO soq_vpl VALUES ("K13_22","012_3_22","1KI","3","22","22","Tane i ninalala wawea wanase, “Dia! Oto bobopa ipa e otoa ita inawaa wandia ne nebaana.” Tane i ninala bautaa aiawa mukalene wanase, “Dia! Oto bolena ipa e manawoa, oto inawaa ipa ne nebaana.” I ema nata warere Solomon danawe epe wawantoie. ");
INSERT INTO soq_vpl VALUES ("K13_23","012_3_23","1KI","3","23","23","Sape warere wanase, “Ema epe, i bautaa wadia da, ‘Oto bobopa ipa e manawoa, oto inawaa ipa ne otona.’ Ita i wawea wadiase, ‘Dia! Oto inawaa wandia ipa ne mainawoa ita oto bolena sa ipa e manawoa.’” ");
INSERT INTO soq_vpl VALUES ("K13_24","012_3_24","1KI","3","24","24","Ita warere nolawa dewalala diamone wanase, “Isima moamoaua wadane neana.” Sa baiwa mo Isima wadane warere mampe wimoiena. ");
INSERT INTO soq_vpl VALUES ("K13_25","012_3_25","1KI","3","25","25","Tauma warere wanase, “Oto inawaa sawano isuweno waiwa nata segantopu ita waiwa wadane i da wanana ita waiwa da sowa wanana.” ");
INSERT INTO soq_vpl VALUES ("K13_26","012_3_26","1KI","3","26","26","Ita oto sa inawaida oto nuawadawadasana baiwa aiawa debama mampe wanase, “Debamana, oto mai bosaa me wadee i ema wanaa.” Tane i da enedia wanase, “Dia! Toaisudepio waiwa nata segantopu ita oto sa mai ne ba me mampea segalepi.” ");
INSERT INTO soq_vpl VALUES ("K13_27","012_3_27","1KI","3","27","27","Tane warere nolawa dewalala diamone wanase, “Oto mai bosana me wadane i bautaa wanana, me ipa oto inawaida.” ");
INSERT INTO soq_vpl VALUES ("K13_28","012_3_28","1KI","3","28","28","God aten insaisawa euda warere waneno kadi saiwa dodomanasadia umanawa Israelwa etane ita atentoiena, sa baiwa mo me wiwirawanton. ");
INSERT INTO soq_vpl VALUES ("K14_20","012_4_20","1KI","4","20","20","Iuda ita Israel apanawa uaraidanton mo ewaewau owa tampa nelawa rua. Mo mampo nana ita esa rua os, ita mo nuaeuntoie. ");
INSERT INTO soq_vpl VALUES ("K14_21","012_4_21","1KI","4","21","21","Warere Solomon bola uduudu apanawa oniamon Eupirates esawa oso ualene, ita Pilistan apanawa waimoia bolauwo ita iene alene Isibtiwa enenituden. Apana sa amonau waaubantoie Solomon mampe inawaa wandia walamawe ita do mo me aiawa ruawantoie. ");
INSERT INTO soq_vpl VALUES ("K14_25","012_4_25","1KI","4","25","25","Ita warere Solomon inawaa wandia walamawe bola debama Dan iene alene bola debama Beasibawo wisena Israel apanawa uduudu muba bolau dewasaie iraintoie waimoie. ");
INSERT INTO soq_vpl VALUES ("K15_1","012_5_1","1KI","5","1","1","Mapo warere Dawid inawaa wandia walamawe me nuawadawada sowaida ipa warere Iram, me bola debama Taire apanawa oniamodie. Tane warere Iram, Dawid otopa Solomon Israel apanawa warereu sanaa enena umanawa etene nolawa apanawa waaubamono anton me auwasapua baiwa. ");
INSERT INTO soq_vpl VALUES ("K15_2","012_5_2","1KI","5","2","2","Ita warere Solomon gagalo wanaubeno leulene warere Iram mampe alen me wanase, ");
INSERT INTO soq_vpl VALUES ("K15_3","012_5_3","1KI","5","3","3","“E ateiten ambi ne mamana Dawid uwa daitada uaraia enane panane do onantoie. Sa baiwa me mai rua ita wadaposi duwa wadapona Iawe God wadaposisampa baiwa. Me Iawe God oniedie emalawoa apana bauta aimopie nanamopio tauma me God wadaposisampa duwa wadepi. ");
INSERT INTO soq_vpl VALUES ("K15_4","012_5_4","1KI","5","4","4","Tane tauma Iawe ne Godna wanwan euda obasa nen bola uduudu bedewe ita ne onana eneia apanawa dia do empuempu dia. ");
INSERT INTO soq_vpl VALUES ("K15_5","012_5_5","1KI","5","5","5","Sa baiwa ne tauma insedina wadapos duwa wadapa Iawe Godna wadaposisapina baiwa. Ne mamana Dawid diena rua, me wanase, ‘Ne ando e otoa dewasapo e aupaa wadepie warerelepi. Ita me ne ebona wadaposisampa duwa wadepi.’ ");
INSERT INTO soq_vpl VALUES ("K15_6","012_5_6","1KI","5","6","6","Sa baiwa e nolaa wadeia apanawa waubamowo Lebanon tawowa bedewe antopue ia badowa eboa sida waia tomopu ne baina ita nolana wadeia apanawa do awodea nolantopu. No atenten e apanaa bola debama Saidon bedewe waimoia ia totowa atendewanton, mai no Israelwa ruamba. Sa baiwa e ne dianea mane ambi rua e nolaa apana wanamopa ita rua ne malesamopa.” ");
INSERT INTO soq_vpl VALUES ("K16_1","012_6_1","1KI","6","1","1","Warere Solomon Israel apanawa ena natadea oniamon ita ena 4 bedewe uaboa natawa bedewe ebowa waia Siwi, me Iawe God duwa ualene wadedie. Tane Israel apanawa Isibtiwa waimoie ene antone ena 480 diasaieno aupe Solomon nola ema ualen. ");
INSERT INTO soq_vpl VALUES ("K16_7","012_6_7","1KI","6","7","7","Mo du wadawada baiwa nambe antone seu dogo tone bedewe otawiamoiena, ita nopuiamoie ipawa du wadawadawa bolawe mai mida widi ita ama mampe ia tompe ba seu nopuamompe moinantopu, dia. ");
INSERT INTO soq_vpl VALUES ("K16_11","012_6_11","1KI","6","11","12","Tane Iawe God warere Solomon du wadedia umanawa diene wanase, “Naita e ne aiana etone ita anaanana uduudu ruawaitona, ne sauana badowa mamaa Dawid mampe wana manawo ipawanasapa. ");
INSERT INTO soq_vpl VALUES ("K16_13","012_6_13","1KI","6","13","13","Ita ne apanana Israelwa bedeuwo wainepina ita do mai emopa, dia.” ");
INSERT INTO soq_vpl VALUES ("K16_14","012_6_14","1KI","6","14","14","Ita warere Solomon God duwa wadedia diasan. ");
INSERT INTO soq_vpl VALUES ("K18_1","012_8_1","1KI","8","1","1","Warere Solomon Israelwa eiau uduudu, uwa daitada ita dan daitada uwaula diamona Iawe God sauawa badowa bokisiwa Dawid bolawa debamawa Saion bedewe awanepue do Ierusalemwa wimpu. ");
INSERT INTO soq_vpl VALUES ("K18_3","012_8_3","1KI","8","3","3","Tane Israelwa eiau uduudu wimoieno pirisi saua badowa bokisiwa wadanaposideiena. ");
INSERT INTO soq_vpl VALUES ("K18_4","012_8_4","1KI","8","4","4","Pirisi ita Liwai damba apanawa Iawe God sauawa badowa bokisiwa ita ape kakaiwa do nituwa kakaibu awanamone God duwa bedewe odeiena. ");
INSERT INTO soq_vpl VALUES ("K18_5","012_8_5","1KI","8","5","5","Warere Solomon ita Israel apanawa uduudu saua badowa bokisiwa danawe enane sipsip ita kau uaraia pulontoie, pue ema mai wisiau rua uarakadinton. ");
INSERT INTO soq_vpl VALUES ("K18_6","012_8_6","1KI","8","6","6","Tauma pirisi Iawe God sauawa badowa bokisiwa awanene bola kakaiwaida bedewe God duwe odeiena ita kerubim mabupa atowe teamoiena. ");
INSERT INTO soq_vpl VALUES ("K18_10","012_8_10","1KI","8","10","10","Tane pirisi bola kakaiwa ene antono giou debamaia iene Iawe God duwa nopesan. ");
INSERT INTO soq_vpl VALUES ("K18_11","012_8_11","1KI","8","11","11","Ita giou sa pirisi bodamono nolau enatuwaiena ipawa Iawe God sapawa debama du sa nopesan. ");
INSERT INTO soq_vpl VALUES ("K18_22","012_8_22","1KI","8","22","22","Tane warere Solomon wata danawe enena, sa ipa me Iawe God danawe eneno ita apana uduudu me adiwe eneiena. Solomon witapa uboo wadenposie rauparilen. ");
INSERT INTO soq_vpl VALUES ("K18_23","012_8_23","1KI","8","23","23","Me rauparilene wanase, “O Iawe Israelwa Godiu, mai God da e ruaa uboo wainipona ba tawo emauwo wainipona, dia. E dima sauaitena rua walama uduudu dewasaiana, e walama uduudu apanaa nuawadawadamoiana, apana mida mo nuau uduudu mampe e aiaa eteie ruawantoia. ");
INSERT INTO soq_vpl VALUES ("K18_27","012_8_27","1KI","8","27","27","Iawe God tawo ema osowe e wana rua, ba? Uba ema mai debamalepona e wadeepitudepi! Sa baiwa wadapos duwa ne wadana bedewe e mai wana rua, dia. ");
INSERT INTO soq_vpl VALUES ("K18_28","012_8_28","1KI","8","28","28","Iawe ne Godna, ne e manawo iedina dima raupari bedewe iririedina ete ita saunea. ");
INSERT INTO soq_vpl VALUES ("K18_29","012_8_29","1KI","8","29","29","E du ema umanawa ema epe waana, ‘Ne ebona du ema bedewe winompa.’ Sa baiwa wadapos duwa ema walama uduudu oniena. Ne naina leusapine wadaposi duwa ema mampesapine rauparintepino etanena. ");
INSERT INTO soq_vpl VALUES ("K18_30","012_8_30","1KI","8","30","30","Tane no nainimba bola ema itunta ne ita e apanaa Israelwa do rauparimba etona. E uboo wainiana ita rauparimba etone kadimba insadabuamona. ");
INSERT INTO soq_vpl VALUES ("K18_41","012_8_41","1KI","8","41","42","Tane bola da nambea apanawa mai Israelwa e eboa debama, mukaa ita dewa debamau dewamoana umanawa etapu. Mo mida bolau nowadawo wadapos awa ieia wimopue nambu du ema mampesapue manawo rauparintopu. ");
INSERT INTO soq_vpl VALUES ("K18_43","012_8_43","1KI","8","43","43","E bolaa uboo wainiana, mo raupariu etone dima iririwantoia wanamona. Ita tawo osowe wanwanlala atentopue e eboa wadaposisapu, no Israel apanawa dewantitana rua. Mo atentopu du ema ne wadana ipa e wadaposia duwa.” ");
INSERT INTO soq_vpl VALUES ("K110_1","012_10_1","1KI","10","1","1","Tane tawo Seba apanawa warereu iwoa Solomon ebowa debamaleidia ita do Iawe God wiwirawaleidia umanawa etene warewa alen. Me menasana warere Solomon aten insaisa euda wadena rubusapie ewepi, sa baiwa waitara uara mampe badowa me diedie. ");
INSERT INTO soq_vpl VALUES ("K110_2","012_10_2","1KI","10","2","2","Me nolawa apanawa uara ita kamel banlamono anton ita do nitu nana eusampa bunamawa, gold eubu ita seu uwataubu eubu malesau debamaia awanamone anton. Me alene warere Solomon auwasane ita me nata gagalonton dima uduudu nuawa bedewe insamodia wano eten. ");
INSERT INTO soq_vpl VALUES ("K110_3","012_10_3","1KI","10","3","3","Solomon me waitarawa uduudu sipoa wamondewalen, mai da koasapona, dia. ");
INSERT INTO soq_vpl VALUES ("K110_4","012_10_4","1KI","10","4","4","Tawo Seba warerewa Solomon insaisawa euda ewene ita do warere duwa wadena, ");
INSERT INTO soq_vpl VALUES ("K110_5","012_10_5","1KI","10","5","5","tane do nana me watawa osowe wineia, ita nolawa apanawa debamau wata tampe waimompa bolawa, do nolawa apanawa debamau gara eubuida tautaula, ita wain reduwa wadeie amonantoia apanawa ita do Iawe God duwa bedewe Solomon pulo amonaleidie wata osowe itudia ewamone memesaidalen. ");
INSERT INTO soq_vpl VALUES ("K110_6","012_10_6","1KI","10","6","6","Ita me warere Solomon diene wanase, “Ne bolanawo wainedine e insaisa euda ita dewa debamau uara dewamoiana umanawa os etedine. Tane tauma atenten dewa apa ulaipa segaleide. ");
INSERT INTO soq_vpl VALUES ("K110_7","012_10_7","1KI","10","7","7","Bauta ne gagalo sa etedine mai sumanaiwantapona, tane tauma ne winene emanawoido e insaisaa euda ita mauraa debamakadilena ewana mai e umanaa ne dianeieno etana rua ewamopona, dia. ");
INSERT INTO soq_vpl VALUES ("K110_8","012_10_8","1KI","10","8","8","E apanaa nuaeuntoi ita nolaa apanawa debamau walama ruawantoie danaawo eneie aten insaisawa euda waiano etei. ");
INSERT INTO soq_vpl VALUES ("K110_9","012_10_9","1KI","10","9","9","Iawe e Godia ne wadaposisadina. Me e manawo nuawa euleide ita me e ituena Israel apanawa oniamoa. Me mo nuawadawadamode, sa baiwa e itueno warereiten ita insaisa euda dewa intawe ulaipa dodomana mampe mo oniamoiana.” ");
INSERT INTO soq_vpl VALUES ("K111_1","012_11_1","1KI","11","1","1","Tane Solomon Isibt warerewa anoopa nuawadawadasadie ita bola da nambea iotopa do nuawadawadamodie. Me tawo Moab, Amon, Edom, do bola Saidon ita Itai iotopa nuawadawadamodie. ");
INSERT INTO soq_vpl VALUES ("K111_2","012_11_2","1KI","11","2","2","Iawe God Israel apanawa bola ema uduudu umanau badowaida diamone wane wanase, “E bola ema iotopu mai naimona ipawa naita e mo naimona mo e nuala teinepuo mo godiu wawoitana.” Tane warere Solomon gagalo sa etendabue ioto nuawadawadaidamodie. ");
INSERT INTO soq_vpl VALUES ("K111_3","012_11_3","1KI","11","3","3","Warere Solomon manamanainapa uduudu 700 mo ipa warere anoanopu. Ita do nolawa iotopa 300 mo ipa me manamanainapa. Ioto ema me nuawa teineieno Iawe God nuawadawadasadia en. ");
INSERT INTO soq_vpl VALUES ("K111_4","012_11_4","1KI","11","4","4","Tane warere Solomon gulauleno manamanainapa me dewasaieno mo godiu da wawo aleidie wadaposimodie. Me mai ulaipa mampe Iawe God os sumanaiwalepona mamba Dawid rua, dia. ");
INSERT INTO soq_vpl VALUES ("K111_5","012_11_5","1KI","11","5","5","Mo bola debama Saidon apanawa godiu iwoa ebowa Astoret ita Amon apanawa godiu ebowa Molek wawolene wadaposimodie, god Molek ipa kadiwaida. ");
INSERT INTO soq_vpl VALUES ("K111_7","012_11_7","1KI","11","7","7","Wadiwa Ierusalemwa omo wisedia deneuwe warere Solomon Moab apanawa godiu kadiwaida Semos ita Amoniwa godiu kadiwaida ebowa Molek wadaposiu bolau dewamodie. ");
INSERT INTO soq_vpl VALUES ("K111_8","012_11_8","1KI","11","8","8","Me wadapos bolawa dewamon me manamanainapa uduudu bola da iotopu baibu. Ita sape mo antompe piupiu sumpe ita pulontompa mo godiu mampo. ");
INSERT INTO soq_vpl VALUES ("K111_9","012_11_9","1KI","11","9","10","Iawe God warere Solomon mampe walama nata sabamolene badowa diena me mai god lagawaau wawolepi, tane me Solomon diena mai ruawalepona, me Israelwa Godiu adiananasane en. Sa baiwa Iawe God me mampe nuawa kadiidalen. ");
INSERT INTO soq_vpl VALUES ("K111_11","012_11_11","1KI","11","11","11","Me Solomon diene wanase, “E ne sauana badowa anapunden ita do anaanana mai ruawaitapona, dia. Sa baiwa ne e Israelwa onioniau mukawa eneena manawo wadapaaubepe e nolaa apanawa da wanapa. ");
INSERT INTO soq_vpl VALUES ("K111_12","012_11_12","1KI","11","12","12","Tane ne e mamaa Dawid nuawadawadasadina baiwa tauma inawaa wainiana mai epe dewanteapa. Ita ando e otoa mampe onionia mukawa sa ne wadapaaubepa. ");
INSERT INTO soq_vpl VALUES ("K111_13","012_11_13","1KI","11","13","13","E otoa Israel apanawa oniamompo bedewe ne mai mo uduudu otaubamopa. Tane dan dea os epo me mukawa atowelepio oniepi. Dawid ipa ne nolana dewalala ita bola debama Ierusalem ne neba baina sonabene ituna. Sa baiwa ne epe dewasapaa rua, ne dan dea epo me oniepi.” ");
INSERT INTO soq_vpl VALUES ("K111_26","012_11_26","1KI","11","26","26","Nebat otopa Ieroboam warere Solomon amboitusan. Me Solomon nolawa dewalala uwauleidia apanawa debama bola debama Sereda Eparaim bolawa bedewe wanwanla. Ita inawa ipa obu, me eboa Serua. ");
INSERT INTO soq_vpl VALUES ("K111_27","012_11_27","1KI","11","27","27","Ema epe inta dewa segalen: Solomon bola debama Ierusalem gonaawa tutuwadie naganagaleidia pasisabodamodie. Bola sa ipa me mamba Dawid bolawa debama. ");
INSERT INTO soq_vpl VALUES ("K111_28","012_11_28","1KI","11","28","28","Ieroboam nola dewasapia atemba apanawa, me nolawa euda dewamodio Solomon ewene ituno nola onioniau apanawa segalen. Me Eparaim ita Manase damba Iosep nosinosiwa mida nolantoia uwaulepia apanawa segalen. ");
INSERT INTO soq_vpl VALUES ("K111_29","012_11_29","1KI","11","29","29","Walama dea Ieroboam Ierusalem ene aleidie into peroweta Aisa donsan. Me bolawa debama Silo bedewe wanwanla. Mo nata into bola sawanaida bedewe dondonton tane Aisa garawa onapea sanaa taudie. ");
INSERT INTO soq_vpl VALUES ("K111_30","012_11_30","1KI","11","30","30","Aisa garawa onapea sanaa taudia wadenaubene siosawialeno kepakepa uduudu 12 seganton. ");
INSERT INTO soq_vpl VALUES ("K111_31","012_11_31","1KI","11","31","31","Ita me Ieroboam diene wanase, “E gara kepakepa 10 eba baia otamoa. Iawe Israelwa Godiu wadiase, ‘Solomon Israel apanawa oniamodio waimoia mukawa me mampe wadepiaubepi. Ita e Ieroboam dan uduudu 10 manawomopio oniamoa. ");
INSERT INTO soq_vpl VALUES ("K111_32","012_11_32","1KI","11","32","33","Solomon, ne adianananene ita me Saidonwa godiu iwoa ebowa Astoret ita Moab apanawa godiu ebowa Semos ita Amon apanawa godiu Molek wawoleidie wadaposimode. Me mai Iawe God intawa asiasi alepona ita me mai euda dewasapona me mampe. Tane me gagalowa mai etapona ita do me anaanawa ainpunden. Me mamba Dawid Iawe God sumanaiwalena rua me mai dewalepona. Tane Dawid ipa Iawe God nolawa dewalala ita Israelwa dambu daitada bedeuwoe me bola debama Ierusalem sonaben me meba baiwa. Sa baiwa mo bedeuwo dan uwa dea epio Solomon nosinosiwa atouwontompo oniamompa. ");
INSERT INTO soq_vpl VALUES ("K111_35","012_11_35","1KI","11","35","35","Ita me Israelwa Solomon otopa mukawa atowe waimoia otaubamopie dan uduudu 10 eneepo oniamoa.’” ");
INSERT INTO soq_vpl VALUES ("K111_40","012_11_40","1KI","11","40","40","Warere Solomon Ieroboam bosapona baiwaleidie tane me sawe weuwane warere Sisak mampe Isibt bedewe alen. Solomon inawaa wandio rua me sape wankasalen. ");
INSERT INTO soq_vpl VALUES ("K111_42","012_11_42","1KI","11","42","42","Ierusalem bedewe warere Solomon Israel apanawa uduudu oniamono enawa 40 dialen. ");
INSERT INTO soq_vpl VALUES ("K111_43","012_11_43","1KI","11","43","43","Tane me boleno mo me mamba Dawid bolawa debama bedewe dobontoiena. Ita me otopa Reobeam aupawa wadene warerelen. ");
INSERT INTO soq_vpl VALUES ("K112_1","012_12_1","1KI","12","1","1","Warere Reobeam bola debama Sikem bedewe alen Israel apanawa uduudu sape onioniantoia me wisepio itupuo warereu segalepi. ");
INSERT INTO soq_vpl VALUES ("K112_2","012_12_2","1KI","12","2","2","Nebat otopa Ieroboam warere Solomon sawalene alene Isibtiwa wandia gagalo ema etene leulene wisen. ");
INSERT INTO soq_vpl VALUES ("K112_3","012_12_3","1KI","12","3","3","Israel apanawa uaula me gagalowa wanaaubeiena wisepi, ita Ieroboam Israelwa uduudu do warere Reobeam mampe antone diane waienase, ");
INSERT INTO soq_vpl VALUES ("K112_4","012_12_4","1KI","12","4","4","“E mamaa Solomon no nola saiwaia nenedie tane e dieeitana nola saiwa tekateka nenawo e atoawontato onianea.” ");
INSERT INTO soq_vpl VALUES ("K112_5","012_12_5","1KI","12","5","5","Tane Reobeam sipoamone wanase, “E ene aitane walama natadea diantopuo leutane mainawo wilena ita gagalola sipoa dialepa.” Mo epe etane ita ene antoiena. ");
INSERT INTO soq_vpl VALUES ("K112_6","012_12_6","1KI","12","6","6","Mo antoieno aupo Reobeam apana eiau mida warere Solomon inawaa wandio sausaia apanawa do gagalonton. Me mo waitaramone wanase, “Apana ema wimopuo ambi wape diamopa?” ");
INSERT INTO soq_vpl VALUES ("K112_7","012_12_7","1KI","12","7","7","Tane mo waienase, “Naita e apana saumoa meneempa mo dima waia asiasi dewasaa ita mo e atoawontopuo oniakasamoa.” ");
INSERT INTO soq_vpl VALUES ("K112_8","012_12_8","1KI","12","8","8","Ita Reobeam mo gagalou etene mai ruaulepona, me ene alene apana sanaau do gagalonton. Mo ipa me mu sosowa me sausaia apanawa. ");
INSERT INTO soq_vpl VALUES ("K112_9","012_12_9","1KI","12","9","9","Me mo waitaramone wanase, “Ne ambi dewanteapa, apana waia ne nola tekateka wanamopa mai nola saiwaia ne mamana walamawe wanamodia rua wanamopa. Ne ambi wape diamopa?” ");
INSERT INTO soq_vpl VALUES ("K112_10","012_12_10","1KI","12","10","10","Ita apana sanaa me diane waienase, “Mo e dieiena, ‘Nola saiwa tekateka nenaa’ ita e mo diamoa, ‘Ne apana badowaia wainedina mai mamana rua. ");
INSERT INTO soq_vpl VALUES ("K112_11","012_12_11","1KI","12","11","11","Ne mamana sai debama enaleno awanelana tane ne sai osowesape enalepa. Me tai mampe epalen, tane ne tai gedaragedaraua mampe epalepa.’” ");
INSERT INTO soq_vpl VALUES ("K112_12","012_12_12","1KI","12","12","12","Walama natadea diantono Ieroboam ita apana uduudu me diamona rua leuntone wimoiena Reobeam gagalowa etapua baiwa. ");
INSERT INTO soq_vpl VALUES ("K112_13","012_12_13","1KI","12","13","13","Warere Reobeam apana eiau wasaubu gagalowa mai etapona, sa baiwa me badowa apana mampo gagalolen. ");
INSERT INTO soq_vpl VALUES ("K112_14","012_12_14","1KI","12","14","14","Ita me apana sanaa wasaubu gagalowa asiasi apana diamone wanase, “Ne apana badowaia, mai mamana rua! Ne mamana sai debama enalen tane ne e sai debamawaida enalepa! Me tai mampe epaledie tane ne tai gedaragedaraua mampe epalepa!” ");
INSERT INTO soq_vpl VALUES ("K112_15","012_12_15","1KI","12","15","15","Iawe God epe menasana rua segalen, sa baiwa warere apana aiau mai etaeta menasapona. Iawe God bola debama Silo perowetawa Aisa bedeweinta Nebat otopa Ieroboam mampe gagalolen. Me wana, Solomon otopa mampe apana oniamodia mukawa wadepiaubepi. Ita Iawe God peroweta Aisa bedewee wana rua segalen. ");
INSERT INTO soq_vpl VALUES ("K112_16","012_12_16","1KI","12","16","16","Israelwa uduudu warere mo gagalou etaeta dabualeno ewane me diane waienase, “No ipa mai Iese otopa Dawid bedewea! No mai me damba wainipona! Israelwa, eno nuba bolambobolambo ana, Dawid bedewea Reobeam meba apanawa oniamopi!” Ita mo epe wane ene antoiena. ");
INSERT INTO soq_vpl VALUES ("K112_17","012_12_17","1KI","12","17","17","Ita warere Reobeam Israelwa Iuda bolawa debama bedewe waimoia me atowentono oniamodie. ");
INSERT INTO soq_vpl VALUES ("K112_18","012_12_18","1KI","12","18","18","Tane apana ebowa Adoniram Israelwa nola baiwa auweia me diamodie oniamodio nolantoi, mo warere Reobeam nolawa dewalala. Sa baiwa Reobeam me wanaubeno Israel apanawa mampo alen otamopie wimpuo me atowentopuo oniamopi. Tane mo seu mampe me bosaiena. Ita warere Reobeam tauwadea turaka pue mampe teiteinalala osowe odene waine Ierusalemwa alen. ");
INSERT INTO soq_vpl VALUES ("K112_19","012_12_19","1KI","12","19","19","Walama sawo ita odene tauma Israel apanawa einapue Ieroboam atowentone bola Iuda bedewe wanwanla Dawid bedewea do emalawoantoie waimoie. ");
INSERT INTO soq_vpl VALUES ("K112_20","012_12_20","1KI","12","20","20","Tane Israel apanawa Ieroboam Isibtiwae leulene wisena umanawa etane mo apana uduudu diamoieno auweiena. Ita mo me dieieno wiseno ituieno Israelwa uwa daitada uduudu oniamon. Tane Iuda damba os Dawid bedewea atowentono oniamon. ");
INSERT INTO soq_vpl VALUES ("K112_25","012_12_25","1KI","12","25","25","Eparaim nosinosiwa bolau bedewe Ieroboam bola debama Sikem gonaalene bodene bedewe wandie. Bola sawo wadi uara enei. Me sape wandie ene alene bola debama Penuel gonaalene boden. ");
INSERT INTO soq_vpl VALUES ("K112_26","012_12_26","1KI","12","26","27","Tane walama dea Ieroboam wandie ema epe insedie, “Israel apanawa uduudu Ierusalemwa Iawe God duwa bedewe pue pulontompe sumpa baiwa antoi. Apana ema antoia, Dawid damba bedewea atowentopue nuau leusapuo mo apanau bola Iuda warerewa Reobeam mampentopu. Ita mo ne boneapue me dewasapuo ne aupana wadepie warerelepi.” ");
INSERT INTO soq_vpl VALUES ("K112_28","012_12_28","1KI","12","28","28","Sa baiwa warere aten apanawa do gagalonton dima dewasapu, ita me gold mampe kau inainamba rua kokoitau nata dewamon. Tane apana diamone wanase, “E Ierusalem awa aitile pokaida eteilana, e Israel apanawa, godila ema ewanee mapo Isibt bedewe banlaleno nolelana.” ");
INSERT INTO soq_vpl VALUES ("K112_29","012_12_29","1KI","12","29","29","Ita me kokoitau sa dewamona otene dea bola debama Betel bedewe itun ita da bola debama Dan bedewe itun. ");
INSERT INTO soq_vpl VALUES ("K112_30","012_12_30","1KI","12","30","30","Me epe dewaleno apana kadi dewasaiena. Apana nowadawo Dan bedewe kokoitau wadaposiwa baiwa anton. ");
INSERT INTO soq_vpl VALUES ("K112_31","012_12_31","1KI","12","31","31","Ita do Ieroboam wadapos bolawa wadi uarau iwa oso dewamon ita pirisi dan daitada bedeuwo sonabamone teamon. Mo ipa mai Liwai damba bedewea, dia. ");
INSERT INTO soq_vpl VALUES ("K116_30","012_16_30","1KI","16","30","30","Omri otopa ebowa Eiab Iawe God mampe dewa kadiu uaraia dewamodie mai warere bautaa ruau. ");
INSERT INTO soq_vpl VALUES ("K116_31","012_16_31","1KI","16","31","31","Me kadi dewasadie insediase dewa da kerauda dewasade Nebat otopa warere Ieroboam kadiwa dewasana rua. Tane do dewa da kadiwaida dewasana ipa me Saidon warerewa Etibaal anoopa Iesebel naisen ita laga godiwa Baal wadaposisadie. ");
INSERT INTO soq_vpl VALUES ("K116_32","012_16_32","1KI","16","32","32","Eiab bola debama Samaria bedewe Baal wadaposiwa duwa waden ita do bedewe pulontompa watawa dewamon. ");
INSERT INTO soq_vpl VALUES ("K116_33","012_16_33","1KI","16","33","33","Ita do me god iwoa ebowa Asera kokoitauwa wadaposisampa baiwa dewasane eindoden. Eiab dewa uaraia dewamona mampe Iawe Israelwa Godiu nuawa kadiidasan mai warere bautaa ruau. ");
INSERT INTO soq_vpl VALUES ("K117_1","012_17_1","1KI","17","1","1","Peroweta ebowa Elaia Giled bolawa bedewe Tisibiwa wanwanlala warere Eiab mampe alene wanase, “Ulaipaida, Israelwa Godiu wanwankasalala ita ne ipa me nolawa dewalala ebowe wadina, unu mai wapi ita do ena ema ieia bedewe mai nirurulepi ideita ne wapo rua unu wapi.” ");
INSERT INTO soq_vpl VALUES ("K117_8","012_17_8","1KI","17","8","8","Tane Iawe God Elaia diene wanase, ");
INSERT INTO soq_vpl VALUES ("K117_9","012_17_9","1KI","17","9","9","“E aie Sarepatiwa wanempa bola debama Saidon tampe. Sape ne obu diana nana sauepio naa.” ");
INSERT INTO soq_vpl VALUES ("K117_10","012_17_10","1KI","17","10","10","Sa baiwa Elaia Sarepatiwa alene bola gonaawa moape wisene i ia nolaleidio ewen. Ita me diene wanase, “Rua ba dia, esa utee neawo napa?” ");
INSERT INTO soq_vpl VALUES ("K117_11","012_17_11","1KI","17","11","11","I ene esa utepia baiwa aleidio me apa mampe wanase, “Rua ba dia, bured do wade wine nea?” ");
INSERT INTO soq_vpl VALUES ("K117_12","012_17_12","1KI","17","12","12","I me sipoasane wanase, “Ulaipa e Goda wanwankasalala ebowe wadina, ne mainawo mai bured da wineipona, dia. Ne parawa didiwaida ita mena kerauda mainawo winede. Tauma ne ia nolantedina duwa anteape neba otona nata baimba laulantapo nate aupe no di wainente omana bowantata.” ");
INSERT INTO soq_vpl VALUES ("K117_13","012_17_13","1KI","17","13","14","Tane Elaia me diene wanase, “Mai inguguraitaa! Iawe Israelwa Godiu wadiase, ‘Parawa onta bedewe ita do mena dugi bedewe wineia mai diantopu, dia, ideita Iawe God walama ituna osowe unu wapie irai butamopio inintopu!’ Sa baiwa ne dima waana rua duwa aite dewasaa ita ne baina bauta parawa kerauda nuite wade winea. Ita moawa winompa nuitaa e otoa nata baila.’” ");
INSERT INTO soq_vpl VALUES ("K117_15","012_17_15","1KI","17","15","15","Me alene Elaia wana rua dewasan. Ita ema aupe, walama uduudu Elaia ita obu otopa nata baibu nana winedio os waimoie. ");
INSERT INTO soq_vpl VALUES ("K117_16","012_17_16","1KI","17","16","16","Iawe God sauawa Elaia bedewesano wana parawa onta bedewe ita mena dugi bedewe mai diantopona. ");
INSERT INTO soq_vpl VALUES ("K117_17","012_17_17","1KI","17","17","17","Tane walama isiwa diantono obu ema meba duwa bedewe wandie otopa kero debama wadaidasano ita bolen. ");
INSERT INTO soq_vpl VALUES ("K117_18","012_17_18","1KI","17","18","18","Sa baiwa me Elaia diene wanase, “E ipa God perowetawa, e dima baiwa dewa ema dewasaana ne mainawo? E mape wiena ne kadina euwanee ita do otona bosaa baiwa, ba?” ");
INSERT INTO soq_vpl VALUES ("K117_19","012_17_19","1KI","17","19","19","Elaia sipoasane wanase, “Otoa wadee nea.” Me oto inawa mampe wadene awanene me wandiawo du iwa osowe odene alen. Ita me ituleidia bolawe wadenaisie itun. ");
INSERT INTO soq_vpl VALUES ("K117_20","012_17_20","1KI","17","20","20","Ita me Iawe God mampe rauparilene wanase, “Iawe ne Godna, dima baiwa e sai debama obu ema osowe ituana? Me wano ne duwa bedewe wainedina tane dima baiwa e dewasaano me otopa bolen?” ");
INSERT INTO soq_vpl VALUES ("K117_21","012_17_21","1KI","17","21","21","Ita me walama natadea oto osowelene danawa tonbodene osowe itulene Iawe God mampe mukalene wanase, “Iawe ne Godna, ne menanede e oto ema ina leusae wanaa!” ");
INSERT INTO soq_vpl VALUES ("K117_22","012_17_22","1KI","17","22","22","Iawe God Elaia raupariwa etene ita oto ina waneno inalene wain. ");
INSERT INTO soq_vpl VALUES ("K117_23","012_17_23","1KI","17","23","23","Ita Elaia oto wadenposie awanene neke asiasi iene alen. Ita du atowea wanwan bola debama bedewe inawa wanene wanase, “Ewee, otoa inawaa!” ");
INSERT INTO soq_vpl VALUES ("K117_24","012_17_24","1KI","17","24","24","Tane oto inawa Elaia mampe wanase, “Tauma ne atenten e God perowetawa, ita Iawe God aiawa e moawo nosedia ipa ulaipa.” ");
INSERT INTO soq_vpl VALUES ("K118_1","012_18_1","1KI","18","1","2","Ena nata bedewe Samaria tawowa bedewe unu mai wapona ita maraapore debamaia segalen. Tane maraapore enawa natadea bedewe Iawe God Elaia diene wanase, “E aite warere Eiab ewaa, ne unu tawo ema oso wapaaubepa baiwantedina.” Ita me warere Eiab mampe alene donsan. ");
INSERT INTO soq_vpl VALUES ("K118_17","012_18_17","1KI","18","17","17","Ita me alene wiseno Eiab ewene diene wanase, “E ipa sa Israelwa osouwo poka ituiana apanawa, ba?” ");
INSERT INTO soq_vpl VALUES ("K118_18","012_18_18","1KI","18","18","18","Elaia leusane wanase, “Ne mai Israelwa osouwo poka itupona tane e ita e mamaa damba do dewa ema dewaiten. E Iawe God anaanawa mai ruawaitapona ita eida Baal godiwa wadaposimoile.” ");
INSERT INTO soq_vpl VALUES ("K118_19","012_18_19","1KI","18","19","19","Tauma e Israel apanawa uduudu diamowo wimpu wadi Kamel iwa oso doineapu. Ita e ione Baal perowetawa uduudu 450 ita Asera perowetawa 400 do winlena. Mo mida warere iwoa Iesebel nana wanamodia. ");
INSERT INTO soq_vpl VALUES ("K118_20","012_18_20","1KI","18","20","20","Sa baiwa Eiab Israelwa uduudu ita peroweta diamona wadi Kamel iwa osowe antopue auwepu. ");
INSERT INTO soq_vpl VALUES ("K118_21","012_18_21","1KI","18","21","21","Ita Elaia apana uduudu danauwo enene diamone wanase, “E walama dainea insaisala natamoilana enee insaisala dea ituna. Naita Iawe ipa God, aiawa ruawaitane waweitana, tane naita Baal ipa God me waweitana.” Ita apana mai aiau da wapona, dia. ");
INSERT INTO soq_vpl VALUES ("K118_22","012_18_22","1KI","18","22","22","Mape Elaia mo mampo wanase, “Iawe God perowetawa neba os wainedina tane Baal perowetawa ipa 450. ");
INSERT INTO soq_vpl VALUES ("K118_23","012_18_23","1KI","18","23","23","E kau mona nata otene mainimbo winlena. Mo kau dea wadapue mamposapu ita bosapue nopuiasapu. Tane mo pue pulotompa watawa osowe ia teamopue ita osowe moia teapu, tane ia mai supu. Ita ne kau da mampe deawaa dewasapa. ");
INSERT INTO soq_vpl VALUES ("K118_24","012_18_24","1KI","18","24","24","Tane e Baal perowetawa, godila mampe rauparitana ita ne Iawe God mampe rauparintapa. Ita god dainea raupari sipoasapie ia wapiaubepio moia ia do ituialepia me ulaipa Godida!” Ita apana uduudu oanton. ");
INSERT INTO soq_vpl VALUES ("K118_25","012_18_25","1KI","18","25","25","Tane Elaia Baal perowetawa mampo gagalolene wanase, “E apana uaraitena baiwa bauta puloitana. Ita e kau dea sonabene imaitane otamone wata osowe teana tane ia mai suna ita godila mampe rauparitana.” ");
INSERT INTO soq_vpl VALUES ("K118_26","012_18_26","1KI","18","26","26","Sa baiwa mo kau dea wadane imasane pulo ituia watawa osowe ituiena. Ita mo Baal mampe tadinaida rauparintoio alene enautalen. Mo mukantoie waiase, “O Baal, no rauparimba sipoasaa!” Ita mo pue pulontompa watawa dewasaiena tampeinta biantoie. Tane mai raupari sipoa da, diaida. ");
INSERT INTO soq_vpl VALUES ("K118_27","012_18_27","1KI","18","27","27","Ita enautaleidio Elaia mo wasimone wanase, “Mukaitane rauparitana! Me ulaipa godida! Me dauwa insaisawa uaraleide ba nambe alen ba awa da alen. Ba naita me ituleidia wanamesano enepiwisepi!” ");
INSERT INTO soq_vpl VALUES ("K118_28","012_18_28","1KI","18","28","28","Mo mukantoie rauparintoie ita mo dewau rua isima mampe etepu toie ita e mampe etepu eneio osina debama esa rua noseidie. ");
INSERT INTO soq_vpl VALUES ("K118_29","012_18_29","1KI","18","29","29","Mo ideita ka osowe osowe waio rawilen ita pue susuwa walamaida wisen, tane mai aia da, mai mida da sipoalepona, diaida. ");
INSERT INTO soq_vpl VALUES ("K118_30","012_18_30","1KI","18","30","30","Tauma Elaia apana diamone wanase, “E mainawo winlena.” Ita mo uduudu me mampe wimone enanepaneiena. Ita me Iawe God watawa apana da kadisana osowe dewasan. ");
INSERT INTO soq_vpl VALUES ("K118_31","012_18_31","1KI","18","31","31","Me seu uduudu 12 otamon ita seu sa ipa Israel damba deadea eueuwau. Ebo ema Israel Iawe God mo nosiu Iakob wanen. ");
INSERT INTO soq_vpl VALUES ("K118_32","012_18_32","1KI","18","32","32","Me seu sa mampe pulontompa watawa osowe dewasan Iawe God wadaposiwa baiwa. Ita me wata tampeinta don tone panen. Don sa bedewe esa memepuo 14 lita wadepia rua. ");
INSERT INTO soq_vpl VALUES ("K118_33","012_18_33","1KI","18","33","33","Ita me ia tonapu wata osowe teamone ita kau nopuialene otene ia osowe teamon. Ita me wanase, “E dugi debamau 4 bedewe esa memamono nopentopuo pulo ita ia osowe memamona.” ");
INSERT INTO soq_vpl VALUES ("K118_34","012_18_34","1KI","18","34","34","Mo epe dewantoieno ita me wanase, “E osowe deawaa dewasana.” Ita mo dewasane diasaieno wanase, “E tauma osowe natadeawa memena.” Sa baiwa mo esa natadeawa memeiena me wana rua. ");
INSERT INTO soq_vpl VALUES ("K118_35","012_18_35","1KI","18","35","35","Ita esa wata osowe iene alene don nopesan. ");
INSERT INTO soq_vpl VALUES ("K118_36","012_18_36","1KI","18","36","36","Tane rawileidio pue pulontopua walamawa wiseno Elaia wata mampe alene enene rauparilene wanase, “Iawe God, Abraam, Aisak ita Iakob Godiu, ande e sabamoitaa e ipa God Israel bedewe ita ne ipa e nolaa dewalala, ita dewa ema uduudu e waana rua ne dewamona. ");
INSERT INTO soq_vpl VALUES ("K118_37","012_18_37","1KI","18","37","37","O Iawe God ne rauparina e sipoasaa, ne rauparina e sipoasawo apana ema atenepu e ipa Iawe God, tane e ipa mo nuau leusaiana manawontopu.” ");
INSERT INTO soq_vpl VALUES ("K118_38","012_18_38","1KI","18","38","38","Me epe rauparileno Iawe God uboo ia iilala wanaubeno iene kau, ia, seu ita dogo wata tampe tane do esa don bedewe ituiamono makolene dialen. ");
INSERT INTO soq_vpl VALUES ("K118_39","012_18_39","1KI","18","39","39","Tane apana dewa ema ewane, mo nambu dogo osowe udanadoe ke wane waienase, “Iawe God, me ipa God! Iawe God, me ipa God!” ");
INSERT INTO soq_vpl VALUES ("K118_40","012_18_40","1KI","18","40","40","Ita Elaia aiawa badowa mampe diamone wanase, “E Baal perowetawa wadaitumona mai da eno alepi!” Sa baiwa mo uduudu wadaitumoiena ita Elaia banlamone Kison dobawa apua oso antone bomonatuwaiena. ");
INSERT INTO soq_vpl VALUES ("K118_41","012_18_41","1KI","18","41","41","Ita Elaia Eiab mampe wanase, “E aie nana ita esa naa, ne unu debama iedio moinawa etedina.” ");
INSERT INTO soq_vpl VALUES ("K118_42","012_18_42","1KI","18","42","42","Eiab alene nana ita esa nan ita Elaia wadi Kamel iwa osowe odene alene nitomalene namba imimpa osowe udendoe rauparilen. ");
INSERT INTO soq_vpl VALUES ("K118_43","012_18_43","1KI","18","43","43","Ita me nolawa dewalala mampe wanase, “E aie owa deneuwe ewawo.” Ita nola dewalala alene ewene leulene wisene Elaia diene wanase, “Ne antene mai dima da ewapona.” Elaia nolawa dewalala dieno walama 7 osoweosowe alene ewen. ");
INSERT INTO soq_vpl VALUES ("K118_44","012_18_44","1KI","18","44","44","Ita walama 7 bedewe nola dewalala wanase, “Ne giou keraudida apana witapa rua owa bedewe odedio ewana.” Sa baiwa Elaia wanase, “E aite Eiab diaa, e unu bodeepia sawa turakaa pue teiteinalala osowe odee wane duawo aitaa.” ");
INSERT INTO soq_vpl VALUES ("K118_45","012_18_45","1KI","18","45","45","Tane tauwadea uba tampe giou dubalen. Ita lanunu weuwane unu debama nosen. Eiab turakawa pue mampe teiteinalala osowe waine bola Iesiriel bedewe alen. ");
INSERT INTO soq_vpl VALUES ("K118_46","012_18_46","1KI","18","46","46","Tane Iawe God Elaia muka debamaia waneno garawa nukulene igawa bedewe ensipusalen. Ita me weuwane alene Eiab ainboe Iesirielwa wisen. ");
INSERT INTO soq_vpl VALUES ("K119_1","012_19_1","1KI","19","1","1","Eiab alene duwa wisene dewa uduudu Elaia dewamona ita ambi Baal perowetawa uduudu bomona umanawa manainapa Iesebel dieno eten. ");
INSERT INTO soq_vpl VALUES ("K119_2","012_19_2","1KI","19","2","2","Iesebel dewa ema umanawa etene Elaia gagalowa wanaubene wanase, “Imonepi omo ema rua e Baal peroweta bomoana rua ne e boepa. Naita ne mai epe dewanteapa, ne godina mampo rauparintedina ne matangelaneapue do boneapu.” ");
INSERT INTO soq_vpl VALUES ("K119_3","012_19_3","1KI","19","3","3","Elaia ema umanawa etene inalepia insene sawe alen. Ita me Iuda bedewe wisene nolawa dewalala bola Beasiba bedewe en. ");
INSERT INTO soq_vpl VALUES ("K119_4","012_19_4","1KI","19","4","4","Ita me meba sala makowa bedewainta aleidio rawilen. Me ia ebowa burum bumpe waine bolepona menasano rauparilene wanase, “Iawe God ne pokaidanen. Ne inawana wadaaubewo bonteapa nosinosina bontoiena ruau.” ");
INSERT INTO soq_vpl VALUES ("K119_5","012_19_5","1KI","19","5","5","Me epe rauparilene aupe ia bumpe ituawawalen. Ita tauwadea Iawe God enseliwa wadenmesane wanase, “Enawie nana naa.” ");
INSERT INTO soq_vpl VALUES ("K119_6","012_19_6","1KI","19","6","6","Me aia etene enenwisene sala ewen ita uwawe bured tabataba isana polapolaua osowe susulala ita esa dugiwa wineio ewamon. Ita me bured ita esa nane tane osowe itulen. ");
INSERT INTO soq_vpl VALUES ("K119_7","012_19_7","1KI","19","7","7","Tane Iawe God enseliwa osowe me wadenmesane wanase, “Enawie nana naa. Naita dia e mai rua inta dauma aita.” ");
INSERT INTO soq_vpl VALUES ("K119_8","012_19_8","1KI","19","8","8","Sa baiwa me enene bured ita esa namon. Ita me nana sa nane muka waneno walama 40 ita tadina 40 alen God wadiwa wadi Sainai osowe wisen. ");
INSERT INTO soq_vpl VALUES ("K119_9","012_19_9","1KI","19","9","9","Ita sape me wisene tadinaleno guba bedewe itulen. Iawe God me diene wanase, “Elaia, e dima baiwa mape wien?” ");
INSERT INTO soq_vpl VALUES ("K119_10","012_19_10","1KI","19","10","10","Elaia me sipoasane wanase, “Iawe God Mukamukaua, ne walama uduudu e os simbiaedine. Tane Israelwa e sauaa badowa dabuasaiena ita pulontompa watawa epakokomoiena ita do e perowetaa uduudu bomonatuaiena. Ne os wainedina ita tauma mo ne boneapua baiwantoi.” ");
INSERT INTO soq_vpl VALUES ("K119_11","012_19_11","1KI","19","11","11","Tane Iawe God me diene wanase, “E aite wadi iwa osowe nainanepe enaa.” Ita Elaia enedio Iawe God nosene alen ita lanunu debamaia wisene wadi epeno nau tutuwaiena. Tane Iawe God ipa mai lanunu bedewe, dia. Ema aupe wanatata uwen, tane Iawe God mai wanatata sa bedewe, dia. ");
INSERT INTO soq_vpl VALUES ("K119_12","012_19_12","1KI","19","12","12","Tane wanatata aupe ia debama iilala wisene alen. Tane me mai ia sa bedewe, dia. Ia ema aupe aia kerauda asibenebenema wadio eten. ");
INSERT INTO soq_vpl VALUES ("K119_13","012_19_13","1KI","19","13","13","Ita Elaia asibenebenema moinawa etene garawa onapea teineno odene namba rupusan ita nosene alene guba moape enedie. Tane aia me mampe wane wanase, “Elaia, e dima baiwa mape wien?” ");
INSERT INTO soq_vpl VALUES ("K119_14","012_19_14","1KI","19","14","14","Tane me sipoasane wanase, “Iawe God Mukamukaua, ne walama uduudu e os simbiaedine. Tane Israel apanawa e sauaa badowa dabuasaiena ita pulontompa watawa epakokomoiena ita do e perowetaa uduudu bomonatuwaiena. Ne os wainedina ita tauma mo ne boneapua baiwantoi.” ");
INSERT INTO soq_vpl VALUES ("K119_15","012_19_15","1KI","19","15","15","Ita Iawe God me diene wanase, “E leuite inta wienawo asiasi sala makowa bola debama Damaskas tampe aitaa. Ita bola sa debama bedewe odee mena Asael osowe memee euwasaa me ando tawo Siria warereu segalepi. ");
INSERT INTO soq_vpl VALUES ("K119_16","012_19_16","1KI","19","16","16","Tane Nimsi otopa Ieru osowe mena memee euwasa me ando Israel apanawa warereu segalepi. Ita Sapat otopa Elaisa bola Abel Meola apanawa osowe mena memee euwasa me ando e aupaa wadepie ne perowetana segalepi. ");
INSERT INTO soq_vpl VALUES ("K119_17","012_19_17","1KI","19","17","17","Apana mida Asael bosapia sawa alepia Ieru me bosapi. Tane mo mida Ieru bomopua sawantopue antopua Elaisa mo bomopi. ");
INSERT INTO soq_vpl VALUES ("K119_18","012_19_18","1KI","19","18","18","Tane Israel apanawa 7,000 mo mida mai Baal wadaposisapona ba kokoitauwa isuruwasapona, mo os waimompa.” ");
INSERT INTO soq_vpl VALUES ("K119_19","012_19_19","1KI","19","19","19","Tane Elaia alene Sapat otopa Elaisa iraiwa bedewe dogo nobaleidio donsan. Sape apana uduudu 12 muba kaubu natanata otamone iraibu bedewe nolantoie ita Elaisa kau nata sa ompa otamone dogo nobaleidie. Elaia me mampe alene garawa onapea dauma wadene Elaisa awanapa osowe itune ene alen. ");
INSERT INTO soq_vpl VALUES ("K119_20","012_19_20","1KI","19","20","20","Tane Elaisa nolaleidia kauwa nata emone Elaia wawe alene diene wanase, “Bauta ne antape mamana ita inana isuruwamope ita auwamope epe wimpo nata ana!” Elaia me sipoasane wanase, “Leuite aita ita ne e manawo dima dewamona insamona.” ");
INSERT INTO soq_vpl VALUES ("K119_21","012_19_21","1KI","19","21","21","Ita Elaisa leulene alen kauwa nata epaboiamon. Tane kau ia teineio dogo nobaleidia otene denalene moia sune ita apana wanamono naiena. Ita me alene Elaia warorosane nolawa dewalala segalen. ");
INSERT INTO soq_vpl VALUES ("K22_1","013_2_1","2KI","2","1","1","Walama kerauda os bedewe Iawe God Elaia wadepiposidepio wiriwiritoto asiasi odepie uboo alepi, Elaia ita Elaisa bola debama Gilgalwae nomone antoie. ");
INSERT INTO soq_vpl VALUES ("K22_2","013_2_2","2KI","2","2","2","Elaia me diene wanase, “E mape wanempa, Iawe God dianena ne bola debama Betel bedewe anteapa.” Tane Elaisa sipoasane wanase, “Ulaipa Iawe God wanwankasalala ebowe ita do e eboawo ne sauantedina e mai eepa, dia.” Sa baiwa mo iane Betelwa anton. ");
INSERT INTO soq_vpl VALUES ("K22_3","013_2_3","2KI","2","3","3","Ita Betel bedewe peroweta sape waimoie ita mo wimone Elaisa diane waienase, “E ateiten ba, dia, ande Iawe God e debamaa manawo wadepie alepia baiwaleide?” Elaisa sipoamone wanase, “Oa, ne atenten tane e mai gagalowa wana.” ");
INSERT INTO soq_vpl VALUES ("K22_4","013_2_4","2KI","2","4","4","Tane Elaia me mampe wanase, “Elaisa, e mape wanempa. Iawe God ne dianena bola debama Ieriko bedewe anteapa.” Tane Elaisa sipoasane wanase, “Ulaipa Iawe God wanwankasalala ebowe ita do e eboawo ne sauantedina e mai eepa, dia.” Sa baiwa mo iane bola Ierikowa anton. ");
INSERT INTO soq_vpl VALUES ("K22_5","013_2_5","2KI","2","5","5","Peroweta Ieriko bedewe wanwanlala wimone Elaisa waitarasane waienase, “E ateiten ba, dia, ande Iawe God e debamaa manawo wadepie alepia baiwaleide?” Elaisa sipoamone wanase, “Oa, ne atenten tane e mai gagalowa wana.” ");
INSERT INTO soq_vpl VALUES ("K22_6","013_2_6","2KI","2","6","6","Ita Elaia me mampe wanase, “Elaisa, e mape wanempa. Iawe God ne dianena esa Ioadanwa iape anteapa.” Tane Elaisa sipoasane wanase, “Ulaipa Iawe God wanwankasalala ebowe ita do e eboawo ne sauantedina e mai eepa, dia.” Ita mo nata awodea antoiena. ");
INSERT INTO soq_vpl VALUES ("K22_7","013_2_7","2KI","2","7","7","Ita peroweta uduudu bedeuwo 50 mo do antoiena. Elaia ita Elaisa Ioadan esawa tampe nomone eneiena, ita peroweta sa uduudu 50 nomone eseanama enane emontoie. ");
INSERT INTO soq_vpl VALUES ("K22_8","013_2_8","2KI","2","8","8","Ita Elaia garawa onapea wadenaubene nukulene mampe esa epen. Ita esa meba rialene on ita sen deneuwe antono me Elaisa nata nomone dogo makowa asiasi nawane anton. ");
INSERT INTO soq_vpl VALUES ("K22_9","013_2_9","2KI","2","9","9","Mo antone waiwa dauwo wimone Elaia Elaisa diene wanase, “Dima e baia dewasapa meneedia dianea ita aupe Iawe God ne wadaposinepio odape anteapa.” Ita Elaisa sipoasane wanase, “Ne menanede e mukaa osowesae debamasae neawo e aupaa wadape peroweta uwau apanawa segantapa.” ");
INSERT INTO soq_vpl VALUES ("K22_10","013_2_10","2KI","2","10","10","Tane Elaia leusane wanase, “E dewa debama iririwaiten. Ne ewaneano Iawe God wadaposinepio odape antepino, tauma e dima iririwa waana wadaa. Naita dia, sa ide, dia.” ");
INSERT INTO soq_vpl VALUES ("K22_11","013_2_11","2KI","2","11","11","Ita mo gagalontoie antoio tauwadea oas turaka teineia osowe ia idie bumedia do seganton. Ita oas sa Elaia ita Elaisa sawanauwointa nomone anton, ita Iawe God Elaia wiriwiritoto bedewainta wadenposideno uboo odene alen. ");
INSERT INTO soq_vpl VALUES ("K22_12","013_2_12","2KI","2","12","12","Elaisa dewa ema ewene mukalene wanase, “Ne mamana! Ne mamana! Ne Israelwa turakau oas mampe teiteinala apanawa do ewamodina!” Sape me Elaia mai osowe ewapona. Me nuaparewa eueuwa dewasane garawa onapea sioleno kepawa nata seganton. ");
INSERT INTO soq_vpl VALUES ("K22_13","013_2_13","2KI","2","13","13","Tane Iawe God Elaia wadenposideno uboo odene aleidio garawa onapea dogo osowe noseno Elaisa waden. Ita me alene esa Ioadan waiwe enen. ");
INSERT INTO soq_vpl VALUES ("K22_14","013_2_14","2KI","2","14","14","Ita me Elaia garawa onapea noseno wadena mampe esa epene mukalene wanase, “Iawe Elaia Godiwa naepe?” Me epe wane esa epeno einpue awopawa ituno nawene alen. ");
INSERT INTO soq_vpl VALUES ("K22_15","013_2_15","2KI","2","15","15","Tane peroweta Ieriko bedewe wanwanlala eseanama enane dima segalena ewane waienase, “Elaia mukawa tauma Elaisa osowelen!” Ita mo antone me donsane danawe dogo osowe dunentoiena. ");
INSERT INTO soq_vpl VALUES ("K22_16","013_2_16","2KI","2","16","16","Mo waienase, “No apana mukamukaua uduudu 50 mape wainitana. E wawo no ane e debamaa banusata. Dauwa Iawe God Aleupa me awanene alene wadi da osowe itun, ba bola da nua bedewe itun.” Tane Elaisa diamone wanase, “Dia, e mai aitana.” ");
INSERT INTO soq_vpl VALUES ("K22_17","013_2_17","2KI","2","17","17","Tane mo me kainokaino iririsaio malalene wanase, “Sa ide aitana.” Apana sa uduudu 50 Elaia banusapua baiwa antone laio walama natadea dialen ita me mai donsapona, dia. ");
INSERT INTO soq_vpl VALUES ("K22_18","013_2_18","2KI","2","18","18","Tane Elaisa bola Ieriko bedewe wandie, ita mo wimoieno me diamone wanase, “Ne dialena, mai aitana.” ");
INSERT INTO soq_vpl VALUES ("K24_8","013_4_8","2KI","4","8","8","Walama dea Elaisa bola debama Sunem bedewe alen. Sape maura iwa wandie ita me Elaisa iririidasadia me duwa bedewe wimpe nana napona. Sa baiwa walama isiwa me inta sa asiasi iedie nana nadie. ");
INSERT INTO soq_vpl VALUES ("K24_9","013_4_9","2KI","4","9","9","Me badawa diene wanase, “Asisunea, apana sa ne ateina me walama uduudu iede, me ipa God perowetawa kakaiwa. ");
INSERT INTO soq_vpl VALUES ("K24_10","013_4_10","2KI","4","10","10","Eulena no dumba iwa osowe me waimpa bolawa dewasata. Sape itu bolawa, nana watawa, wanwan bolawa ita do siwa ituta, ita me wisempe sape waimpa.” ");
INSERT INTO soq_vpl VALUES ("K24_11","013_4_11","2KI","4","11","11","Walama dea Elaisa Sunem bolawa bedewe leulene wisene ita wandia bolawe du iwe bubualepia baiwa odene alen. ");
INSERT INTO soq_vpl VALUES ("K24_14","013_4_14","2KI","4","14","14","Ema aupe Elaisa nolawa dewalala ebowa Geasi diene wanase, “Ne dima euwa i ema baiwa dewasapa?” Tane Geasi Elaisa sipoasane wanase, “Me mai oto wadapona ita badawa ipa gulaulen.” ");
INSERT INTO soq_vpl VALUES ("K24_15","013_4_15","2KI","4","15","15","Elaisa nolawa dewalala diene wanase, “I diawo mape wimpi.” Sa baiwa Geasi alene i dieno wisene Elaisa duwa moape enen. ");
INSERT INTO soq_vpl VALUES ("K24_16","013_4_16","2KI","4","16","16","Ita Elaisa i mampe wanase, “Ena dea dialepio aupe e oto mona sitaue mabua osowe awanea.” Tane me Elaisa diene wanase, “Debamana, e ipa God perowetawa mai laganea, ne ipa e nolaa dewalala.” ");
INSERT INTO soq_vpl VALUES ("K24_17","013_4_17","2KI","4","17","17","Tane ulaipaida, Elaisa i diena rua ena da bedewe walama sa deawaa bedewe i otopa mona gamosan. ");
INSERT INTO soq_vpl VALUES ("K24_42","013_4_42","2KI","4","42","42","Walama da bedewe apana dea bola debama Baal Salisa bedewe wandie wisene Elaisa bured uduudu 20 wanen. Apana ena sa bedewe nanau ipawa bauta itudia uwauwantoia ebowa waia bali otene wimone bured sumoiena. Tane do nana ipawa sanaa uwauwantoia Elaisa deuawa aine waneiena. Tane Elaisa nolawa dewalala diene wanase, “Nana sa peroweta auweia wanamowo ita napu.” ");
INSERT INTO soq_vpl VALUES ("K24_43","013_4_43","2KI","4","43","43","Tane Elaisa nolawa dewalala wanase, “E ambi waiana, apana 100 wadena mai nana napua rua?” Tane Elaisa leusane wanase, “Iawe God wadia mo nana napue pokamopio moawa epu, sa baiwa nana mo wanamona.” ");
INSERT INTO soq_vpl VALUES ("K24_44","013_4_44","2KI","4","44","44","Sa baiwa nola dewalala apana nana wanamon. Ita mo Iawe God wana rua nana nane moawa eiena. ");
INSERT INTO soq_vpl VALUES ("K25_1","013_5_1","2KI","5","1","1","Naeman ipa tawo Siria apanawa warereu me sorodia uwauleidia apanawa debama. Iawe God Naeman sausano Siria apanawa mo mida onau eneia nanaumone aimon. Sa baiwa Siria warerewa insedia Naeman apana debama ita wiwirawaleidie. Naeman ona debama dewasadia apanawa ita me kero kadiwaida kito waden. ");
INSERT INTO soq_vpl VALUES ("K25_2","013_5_2","2KI","5","2","2","Bautamampe Siria apanawa sorodiau anton apana do onantopua baiwa ita Israel tawowa bedewe mo Israel iwa sanaa bodane wadeiena. Ita i sa Naeman manainapa nolawa dewalala wanalen. ");
INSERT INTO soq_vpl VALUES ("K25_3","013_5_3","2KI","5","3","3","I sa Naeman manainapa diene wanase, “Ne menanedia debamana Naeman peroweta Samaria tawowa bedewe wandia mampe alepi. Peroweta sa ne debamana kero kito wadena inasapi.” ");
INSERT INTO soq_vpl VALUES ("K25_9","013_5_9","2KI","5","9","9","Sa baiwa Naeman oas ita turaka pue mampe teiteinala osowe waine Samaria tawowa bedewe alen ita Elaisa duwa moape enen. ");
INSERT INTO soq_vpl VALUES ("K25_10","013_5_10","2KI","5","10","10","Tane Elaisa gagalowa benemala wanaubeno Naeman mampe alen diepi wapiase, “E esa Ioadan bedewe aite walama 7 duaditaa. Ita e etea inalepio euitaa.” ");
INSERT INTO soq_vpl VALUES ("K25_11","013_5_11","2KI","5","11","11","Tane Naeman nuawa kadileno ene aleidie wanase, “Ne insaisana badowa itunaa peroweta du bedewee nosepe mainawoido enape me Godiwa Iawe mampe rauparilepona. Ita me witapa kito osowe itupe inaneapona. ");
INSERT INTO soq_vpl VALUES ("K25_12","013_5_12","2KI","5","12","12","Ne bolana debama Damaskas esawa Abana ita Papa esau ipa eubuida tane Israel tawowa esawa mai eubu. Ne bola debama Damaskas esawa bedewe duadintape inanteapona.” Me epe insedie nuawa kadileno ene alen. ");
INSERT INTO soq_vpl VALUES ("K25_13","013_5_13","2KI","5","13","13","Naeman nolawa dewalala wimone me diane waienase, “Debamamba, e peroweta nola da debama dewasapona baiwa dieeipono dewasapona. Sa baiwa e peroweta dima dieena rua dewasaa, ‘Aite duadite euitaa.’” ");
INSERT INTO soq_vpl VALUES ("K25_14","013_5_14","2KI","5","14","14","Ita Naeman alene Ioadan esawa bedewe iena walama 7 God perowetawa wana rua ita etepa uduudu eulen, oto gegela etepa rua. ");
INSERT INTO soq_vpl VALUES ("K25_15","013_5_15","2KI","5","15","15","Ita Naeman apanawa uduudu do leuntone God perowetawa Elaisa mampe anton. Naeman Elaisa danawe enene mukalene wanase, “Tauma ne atenten Israelwa Godiu tawo uduudu osowe me os God wande! Sa baiwa ne nolaa dewalala menanedia amonana ema e wadaa.” ");
INSERT INTO soq_vpl VALUES ("K25_16","013_5_16","2KI","5","16","16","Tane Elaisa me sipoasane wanase, “Ulaipa Iawe God ipa wanwankasalala mida ne simbiasadina, me ebowe ne wadina amona sa ne mai wadapa, dia.” Naeman aiawa badowa mampe me iririsana amona wadapona, tane me mai wadapona. ");
INSERT INTO soq_vpl VALUES ("K25_17","013_5_17","2KI","5","17","17","Tane Naeman wanase, “Ne tauma ita ando pulona Iawe God os mampe dewasapina mai god isiwa lagawau mampo. Tauma ne pue bosape Iawe God mampe pulontapa. Sa ide, pulo mai wadaa tane menaidanedia Israel dogowa saiwa pue ema nata awanepu. ");
INSERT INTO soq_vpl VALUES ("K25_18","013_5_18","2KI","5","18","18","Ne ipa e nolaa dewalala rua, tane ne warerena alepie Saidon apanawa godiu ebowa Rimon duwa bedewe pulo watawa osowe sape wadaposilempa. Me ne mabuna osowe dodanalempo nata sape wadaposintonta. Epe dewantepino Iawe God ide kadina insadabuamopi?” ");
INSERT INTO soq_vpl VALUES ("K25_19","013_5_19","2KI","5","19","19","Ita Elaisa Naeman diene wanase, “Wanwan euda obasa e bedeawolepio aitaa.” Ita me ene alen. ");
INSERT INTO soq_vpl VALUES ("K217_5","013_17_5","2KI","17","5","10","Iawe Israel apanawa Godiu mo Isibt warerewa mukawa atowe waimoio banlamono nomoiena me mampe kadiwa dewasaiena. Israel apanawa god da wadaposimoie ita uwa daitada apanawa dewau wawontoie. Mo ipa sa bauta Kanaan bolawa bedewe waimoio Iawe God Israelwa danauwo tanamono nomoiena. Mo Israelwa warereu dewantona rua god da wadaposimoie. Ita Israelwa weregainta dewa kadiwa daitada uaraia Iawe God mai menasaipona dewamoiena. Tane mo bolau kerakera ita debamau bedewainta, god lagawaau wadaposiu bolawa dewamoiena. Israel apanawa seu kakaila ita Asera kokoitauwa wadaposisampa baiwa wadi iwainta ita ia debamau bumpeinta endonton. Ipawa ema baiwa tawo Asaria apanawa warereu sorodiawa Israel tawowa bedewe wimoiena onantopue Israelwa aimopu. Ita mo wimone bolawa debama Samaria enane bodane eneio ena natadea dianton. Tane ena 9 bedewe Osia warereleidia walamawe tawo Asaria warerewa sorodia bola debama Samaria wadane mamposaiena. Ita Israelwa diburau apanawa taumone Asaria bolau bedewe anton. Tawo Asaria warerewa mo bola debama Ala bedewe teamono waimoie ita isiwa Gosen bolawa bedewe esa Abo tampe waimoie, ita isiwa Midia tawowa apanawa bolau bedewainta teamono waimoiena. ");
INSERT INTO soq_vpl VALUES ("K217_24","013_17_24","2KI","17","24","24","Tane tawo Asaria warerewa bola debamau Babilon, Kata, Awa, Amat ita Sepawaim apanawa otamone Samaria tawowa debama bedewe teamon. Mo Samaria bolawa bedewainta teamono Israelwa aupau wadane waimoie. ");
INSERT INTO soq_vpl VALUES ("K217_25","013_17_25","2KI","17","25","25","Bola da nambea apanawa wimoiena walamawe Iawe God mai wadaposisapona, sa baiwa Iawe God laion waubamono mo isiwa adaboiamoiena. ");
INSERT INTO soq_vpl VALUES ("K217_26","013_17_26","2KI","17","26","26","Tane apana wimone Asaria warerewa diane waienase, “Apana e waubamoano Samaria bolau debama bedewainta waimoia mo mai bola sa godiwa anaanawa atentopona ita god sa laion waubamono apana bomoi.” ");
INSERT INTO soq_vpl VALUES ("K217_27","013_17_27","2KI","17","27","27","Tane Asaria warerewa wanase, “E pirisi dea wanaaubeno leulepie Samaria tawowa bedewe alepi. Mapo pirisi Samaria tawowa bedewe waimoie, tane ne mo diburana apanawa rua otamona. Ita mo bedeuwo dea Samaria tawowa bedewe waimpaa baiwa wanaaubeiena alepi. Me sape wampie apanawa sape waimoia Samaria godiu anaanawa waeuwamopi.” ");
INSERT INTO soq_vpl VALUES ("K217_28","013_17_28","2KI","17","28","28","Sa baiwa mo pirisi dea mapo Samaria tawowa oso wandio wadane antoiena leulene bola debama Betel bedewe wisen. Ita me apana waeuwamodie ita mo Iawe God atentopue me wadaposisapu. ");
INSERT INTO soq_vpl VALUES ("K217_29","013_17_29","2KI","17","29","29","Tane bola da nambea apanawa uduudu Israel bolawa debamau bedewe waimoia muba godiu dewamoiena. Ita Israelwa wadaposiu bolawa osowe mo god sa teamoiena. ");
INSERT INTO soq_vpl VALUES ("K218_1","013_18_1","2KI","18","1","1","Ela otopa Osia ena natadea bedewe warerelen, me ipa Israelwa warereu, ita ena 3 wadedio Akas otopa Esekia warere ualene Iuda bolawa onien. ");
INSERT INTO soq_vpl VALUES ("K218_2","013_18_2","2KI","18","2","2","Tane Esekia enawa 25 wadeno bola debama Ierusalem bedewe warerelen ita enawa 29 diasan. Me inawa ipa Sakaria anoopa ebowa Abia. ");
INSERT INTO soq_vpl VALUES ("K218_3","013_18_3","2KI","18","3","3","Iawe God emawe Esekia dewa eubu dodomana dewamodie me nosiwa Dawid rua. ");
INSERT INTO soq_vpl VALUES ("K218_4","013_18_4","2KI","18","4","4","Me god lagawaau bolawa kadimon ita seu kakaila epatuiamon tane Asera kokoitauwa iawa toiamon. Mapo Moses kokoitau mota aleupa irama mampe dewasane itun. Israel apanawa mota sa ebowa Neustan wane ituiena, mo mota aleupa mampe antoie piupiu suie. Mo epe dewantoio baiwa Esekia mota aleupa sa epatuiamon. ");
INSERT INTO soq_vpl VALUES ("K218_5","013_18_5","2KI","18","5","5","Esekia Israel apanawa Godiu Iawe bedewe sumanailen. Iuda bolawa warereu uduudu bedeuwo mai mida da me rua. Mai warere da me danawe ba adiwe me ruawa wainipona, dia. ");
INSERT INTO soq_vpl VALUES ("K218_6","013_18_6","2KI","18","6","6","Me walama uduudu Iawe God mampe sumanaiwa itudie ita dima Iawe God wadia me ruawaleidie ita do Iawe God Moses anaana wanena me ruawalen. ");
INSERT INTO soq_vpl VALUES ("K218_7","013_18_7","2KI","18","7","7","Ita Iawe God ipa me do ita nolawa uduudu dewamodia ipa euda os. Me tawo Asaria warerewa adiananasane ita me nolawa mai dewasapona, dia. ");
INSERT INTO soq_vpl VALUES ("K218_8","013_18_8","2KI","18","8","8","Esekia Palistan apanawa uduudu ita Gasa tawowa uduudu osowe bola debama ita kerakera tane do mo bolau debama gonaalene panane, nanaumone aimon. ");
INSERT INTO soq_vpl VALUES ("K221_1","013_21_1","2KI","21","1","1","Tane Manase enawa 12 wadeno warerelen. Me Ierusalem bedewe warerelene wandio enawa 55 diasan. Me inawa ipa Epsiba. ");
INSERT INTO soq_vpl VALUES ("K221_2","013_21_2","2KI","21","2","2","Manase Iawe God aiawa mai ruawalepona. Me ipa sa bauta Kanaan bolawa bedewe waimoio Iawe God Israelwa danauwo tanamono nomoiena me bola daitada mai God atentopona dewau kadiwaida dewamodie. ");
INSERT INTO soq_vpl VALUES ("K221_3","013_21_3","2KI","21","3","3","Manase mamba Esekia laga wadaposiwa bolawa kadimon tane me sanaamon. Me pue pulontompa watawa dewamon ita mo god Baal wadaposisampa baiwa. Ita me Asera wadaposisampa iawa eindoden Israelwa warereu Eiab dewalena rua. Manase kipora uduudu uba tampe mampo uwawa epentee wadaposimon. ");
INSERT INTO soq_vpl VALUES ("K221_4","013_21_4","2KI","21","4","4","Mapo Iawe God wanase, “Ne wadaposina duwa Ierusalem bedewe enedia, ne ebona sape winompa.” Tane Iawe God duwa Manase dewasano god da pueu pulontompa watawa segalen. ");
INSERT INTO soq_vpl VALUES ("K221_5","013_21_5","2KI","21","5","5","Tane God duwa bola empuempula nata bedewe Manase dewasano kipora uba tampe wadaposiwa bolawa segalen. ");
INSERT INTO soq_vpl VALUES ("K221_6","013_21_6","2KI","21","6","6","Manase meba otopaida ia bedewe pulolene sun, wene dewasan ita nepoanalen, waigiolen ita me aleu kadiu mampo gagalolen. Me dewa kadiwaida dewamono Iawe God awasinasano nuawa kadilen me mampe. ");
INSERT INTO soq_vpl VALUES ("K221_10","013_21_10","2KI","21","10","10","Tane Iawe God benema ema me perowetawa, mida me simbiasaia wanamon. ");
INSERT INTO soq_vpl VALUES ("K221_11","013_21_11","2KI","21","11","11","Me wanase, “Kanaan apanawa dewa kadiwa dewamoiena tane warere Manase dewa kadiuida dewamon. Me Iuda apanawa dewamono mo godiu kokoitaubu wadaposimoiena. ");
INSERT INTO soq_vpl VALUES ("K221_12","013_21_12","2KI","21","12","12","Sa baiwa ne, Israelwa Godiu Iawe, poka debamaia Ierusalem ita Iuda tawowa osowe itupa. Ita mo poka sa umanawa etapue nuau saidalepi. ");
INSERT INTO soq_vpl VALUES ("K221_13","013_21_13","2KI","21","13","13","Ne bola debama Samaria ita warere Eiab duwa bedewe wanwanlala kadimonatuwana rua bola debama Ierusalem matangelasapa. Ne apana laukai bedewa mitedie leusaditudedia rua apana uduudu Ierusalem bedewe mitaaubamopa. ");
INSERT INTO soq_vpl VALUES ("K221_14","013_21_14","2KI","21","14","15","Ne apanana Isibt tawowa ene nomoiena ita tauma walamawa osowe, mo kadiwa daitada dewasane awasinaneieno nuana kadiidalen mo mampo. Sa baiwa ne apanana tauma inawaa waimoia dabuamope emopo Iuda emalawoau apanawa mampentopu. Mo emalawoau sa Iuda apanawa dogou mamposapu ita nitubu uduudu poisamopu.” ");
INSERT INTO soq_vpl VALUES ("K221_16","013_21_16","2KI","21","16","16","Tane do Manase apana uaraia eubu epaboiamon, sa baiwa bola debama Ierusalem intawa uduudu osowe osina weuwan. Tane me osowe Iuda apanawa dewamono kadiwa dewasane kokoitau wadaposimoiena ita Iawe God adiananasaiena. ");
INSERT INTO soq_vpl VALUES ("K221_18","013_21_18","2KI","21","18","18","Ita Manase boleno apana warere duwa ebowa Usa iraiwa bedewe dobontoiena. Ita me aupawa otopa Amon warerelen. ");
INSERT INTO soq_vpl VALUES ("K221_19","013_21_19","2KI","21","19","19","Tane walama sawo Amon enawa ipa 22 wadeno Iuda warerewa enen. Ita me warerelene Ierusalem bedewe wandio ena nata dialen. Me inawa ipa Mesulemet Aru anoopa bolawa debama Iotba apanawa. ");
INSERT INTO soq_vpl VALUES ("K221_20","013_21_20","2KI","21","20","20","Amon mamba Manase rua Iawe God aiawa mai ruawalepona. ");
INSERT INTO soq_vpl VALUES ("K221_21","013_21_21","2KI","21","21","21","Amon mamba dewalena rua kokoitau daitada wadaposimodie. ");
INSERT INTO soq_vpl VALUES ("K221_22","013_21_22","2KI","21","22","22","Me nosiwa Godiwa dabuasan ita Iawe anaanawa mai ruawalepona. ");
INSERT INTO soq_vpl VALUES ("K221_23","013_21_23","2KI","21","23","23","Warere Amon nolawa apanawa debamau me bosapua gagalontone ita warere duwa bedewe bosaiena. ");
INSERT INTO soq_vpl VALUES ("K221_24","013_21_24","2KI","21","24","24","Sa baiwa Iuda apanawa nola dewalala Amon bosaiena sipoa mo bomoiena. Ita me aupawa otopa Iosia itueno warerelen. ");
INSERT INTO soq_vpl VALUES ("K222_1","013_22_1","2KI","22","1","1","Walama emawo Iosia enawa 8 wadeno me Iuda warerewalen ita Ierusalem bedewe wandio enawa 31 dialen. Me inawa ipa Iedida Boskat apanawa Adaia anoopa. ");
INSERT INTO soq_vpl VALUES ("K222_2","013_22_2","2KI","22","2","2","Iosia dewa eubu Iawe God mampe dewamodie. Me nosiwa Dawid dewaida wadene Iawe God aiawa ita anaanawa ruawaleidie dodomana dewasadie. ");
INSERT INTO soq_vpl VALUES ("K222_11","013_22_11","2KI","22","11","11","Tane warere anaana bukawa bedewe gagalo etedia nuawa pareleno ita garawa siolen. ");
INSERT INTO soq_vpl VALUES ("K222_12","013_22_12","2KI","22","12","12","Ita warere tauwadea os pirisi Elkia, Sapan otopa Aikam, Mikaia otopa Akabo ita Sapan me ipa warere nolawa benema girumalempa apanawa ita warere waeuwa apanawa debama Asaia diamone wanase, ");
INSERT INTO soq_vpl VALUES ("K222_13","013_22_13","2KI","22","13","13","“No nosinosimba buka ema aiawa mai ruawantoipe ita mai dianepona dewa ema dewamonta. Sa baiwa Iawe God nuawa kadiidaleide no mainimbo. E aitane God duwa bedewe ne baina ita tawo ema apanawa tane Iuda apanawa uduudu bainimba gagaloitana. Ita do anaana bukawa ema donsaiena gagalowa bedewe winedia waitarawa Iawe God diana.” ");
INSERT INTO soq_vpl VALUES ("K222_16","013_22_16","2KI","22","16","17","“Iawe God wadiase, ‘Iuda apanawa ne adianananeiena ita god da mampo pueu pulontoi mo kokoitau witapo dewasaie nuana kadisai. Ne poka saiwa debamaia bola Ierusalem ita apana sape waimoia osouwo itupa. Dewa uduudu buka bedewe girumalena Iuda warerewa wisialena rua. Ne nuakadina ia idia rua iepi mo osouwo ita mai mida ia sa bosapi.’ ");
INSERT INTO soq_vpl VALUES ("K222_18","013_22_18","2KI","22","18","18","Aitane Iuda warerewa Iawe God waitarawa wana diane wanaase, ‘Iawe Israelwa Godiu benemawa buka bedewe etaana umanawa ema epe wade: ");
INSERT INTO soq_vpl VALUES ("K222_19","013_22_19","2KI","22","19","19","Ita walama sawo ne bola ema ita apana bedewe waimoia adiananamona gagalowa etaana. Ne apana ema dabuamopa ita apana da dewamopo mo emalawoau wakadisau baiwa mo kadiwa donsaiena umanawa wampe diamompa. E kadiwa wawiaiten ita Iawe God mampe eba ituaisitene garaa sioiten ita keida waana. Tane ne e rauparia etana. ");
INSERT INTO soq_vpl VALUES ("K222_20","013_22_20","2KI","22","20","20","Sa baiwa ne e eepo bo obasa euwa boitawo apana dobosaepu. E mai poka saiwa bola ema bedewe itupa baiwantedina ewaa, dia.’” Sa baiwa mo benema peroweta iwoa diamono etane leuntone warere Iosia mampe antone benemasaiena. ");
INSERT INTO soq_vpl VALUES ("K223_1","013_23_1","2KI","23","1","1","Warere Iosia Iuda tawowa apanawa eiau uduudu ita bola debama Ierusalem apanawa eiau diamono mampe wimoiena. ");
INSERT INTO soq_vpl VALUES ("K223_2","013_23_2","2KI","23","2","2","Ita warere Iuda tawowa apanawa uduudu ita Ierusalem apanawa, pirisi ita peroweta tane do apana eboeboua ita ebousiawaia do odane God duwa bedewe anton. Ita warere Iosia God saua badowa wana bukawa apana uduudu mampo wisialen. Buka sa nola apanawa God duwa bedewe donsaiena. ");
INSERT INTO soq_vpl VALUES ("K223_3","013_23_3","2KI","23","3","3","Tane warere God duwa bedewe tuatua tampe warere eneie gagalontoia bolawa osowe enene God sauawa badowa aiawa debama mampe wane sanaasan. Iosia badowa saualena dima uduudu Iawe God sauawa badowa buka bedewe girumamono wineia nuawa uduudu mampe ruawalempe waimpa. Ita do apana uduudu saua sa deawa Iawe God mampe waiena. ");
INSERT INTO soq_vpl VALUES ("K223_4","013_23_4","2KI","23","4","4","Tane warere pirisi ionoidoa Elkia ita pirisi sausaia, do pirisi uduudu mo mida nolau du moawa oniempa badowa diamon. Mo God duwa bedewe god Baal dewamoia, Asera ita kipora uba tampe inainambu rua dewamoiena ita do nitubu uduudu otamopue nambemopu. Iosia apana diamona nitu sa otepue bola Ierusalem epue nambe Kidron tampe doba nua bedewe sumopuo imopituwapi. Ita ema aupe mo god lagawa sumoiena isanawa otamopue bolawa debama Betel bedewe antopu. ");
INSERT INTO soq_vpl VALUES ("R236_14","015_36_14","2CH","36","14","14","Tane pirisi uwaula apanawa ita mo uduudu Iawe God mampe badowa sauantona mai ruawantopona, dia. Ita mo apana dewau kadiwa nuadabualalaida eweie wawontoie dewasaie. Ita Iawe God duwa bola debama Ierusalem bedewe enedia me kakaisana mo miramirasaiena. ");
INSERT INTO soq_vpl VALUES ("R236_15","015_36_15","2CH","36","15","15","Iuda apanawa nosinosiu Godiu Iawe, me apanawa ita duwa ewamone nuawa pareidalen. Sa baiwa me gagalowa benemalala waubamono anton me gagalowa osoweosowe wampo apana etompa. ");
INSERT INTO soq_vpl VALUES ("R236_16","015_36_16","2CH","36","16","16","Tane apana God gagalowa benemalala oibu waiena. Mo me gagalowa waia mo mai etapona ita God perowetawa oibu waiena. Sa baiwa Iawe God nuakadiwa debamaidalen, me nuakadiwa sa mai dima da bodepia rua, dia. ");
INSERT INTO soq_vpl VALUES ("R236_17","015_36_17","2CH","36","17","17","Sa baiwa Iawe God tawo Babilon warerewa wanaubeno alen bola debama Ierusalem onawa enepi. Tane Babilon sorodiawa Iuda apanawa sanaau bomoiena ita mo tanamoieno God duwa bedewe odane antoiena. Babilon sorodiau Iuda apanawa mai nuapareuntopona ita mo apana mona ita ioto sanaau, apana tontau ita kero wadawadala bomoiena. God Iuda apanawa uduudu otamone Babilon warerewa Nebukadnesa mukawa atowe teamon. ");
INSERT INTO soq_vpl VALUES ("R236_18","015_36_18","2CH","36","18","18","Babilon warerewa sorodiawa antone nitu debamau ita kerakerau uduudu God duwa bedewe wineio nolawantoia otamonatuwaiena. Mo antone nitu uwataubu God duwa bedewe wineia ita Iuda warerewa duwa tane me nolawa apanawa debamau dubu bedewe do otamoiena. Mo nitu ema uduudu otene Babilon bedewe anton. ");
INSERT INTO soq_vpl VALUES ("R236_19","015_36_19","2CH","36","19","19","Babilon warerewa sorodiawa God duwa suiena ita bola debama Ierusalem seu mampe gonaantoiena epatuiamone kadisaiena. Tane du debamau uduudu sumoiena ita nitu uwataubu kadimonatuwaiena. ");
INSERT INTO soq_vpl VALUES ("R236_20","015_36_20","2CH","36","20","20","Tane Iuda apanawa mo mida inawaa wankasantona Babilon warerewa sorodiawa otamona diburalala rua Babilon bolawa debama bedewe teamoiena. Tane mo Babilon bedewe waimoie ita warere sa me obampa do nolau dewalala segantone waimoio ideita Pesia tawowa ebowa debama segalen. ");
INSERT INTO soq_vpl VALUES ("R236_21","015_36_21","2CH","36","21","21","Sa baiwa Iawe God benemawa ulaipalen peroweta Ierimaia wana rua. Sabat walamawe bubuantoia rua tawo sa di winedie bubualeidio ena 70 dialen. ");
INSERT INTO soq_vpl VALUES ("R236_22","015_36_22","2CH","36","22","22","Tane tawo Pesia warerewa Sairus ena dea bedewe warereleidio Iawe God gagalowa peroweta Ierimaia waneno wana rua segalen. Iawe God Sairus dewasano anaana ema girumalene wanaubeno apana uduudu atentopua baiwa me wandia bolawa uduudu bedewainta alen. ");
INSERT INTO soq_vpl VALUES ("R236_23","015_36_23","2CH","36","23","23","“Pesia warerewa Sairus ema epe wan: Iawe uba Godiwa tawo gonaawa uduudu ne nen. Me ne nola nena dewasapa, sa baiwa ne Iuda tawowa oso bola debama Ierusalem bedewe me duwa wadapa. Iawe God apanawa mida leu menaledia e leuitane aitane sape wanlempa rua. E aitonuna Iawe e Godila ipa e do.” ");
INSERT INTO soq_vpl VALUES ("ER3_1","016_3_1","EZR","3","1","1","Walama sa uaboa 7 wadeno Israel apanawa muba bolauwobolauwo waimoia ene wimone Ierusalemwa awodeantone waimoie. ");
INSERT INTO soq_vpl VALUES ("ER3_2","016_3_2","EZR","3","2","2","Ita Iosadak otopa Iesua ita pirisi isiwa do ita Sealtiel otopa Serubabel damba do Israelwa Godiu mampe pulo sumpaa watawa osowe dewasaiena. Tauma mo God perowetawa Moses anaanawa wana rua pulo amonawa sumpa. ");
INSERT INTO soq_vpl VALUES ("ER3_3","016_3_3","EZR","3","3","3","Mo sape waimoie apana da bola sa bedewe waimoia sauntoie. Tane mo pulo watawa bolawa dewasane ita tadinaida ita rawi uduudu pue suie. ");
INSERT INTO soq_vpl VALUES ("ER3_7","016_3_7","EZR","3","7","7","Warere Sairus oaleno rua mo ia badowa ebowa sida Lebanon tawowa bedewe inintoia tomopu God duwa wadapua baiwa. Mo seu nolawala apanawa ita kanda mane wanamopu. Tane Saidon ita Taire apanawa isiwa nana, esa ita mena wanamoiena mo ia sa neanamopuo owa asiasi bola Iopa bedewe wimopua baiwa. ");
INSERT INTO soq_vpl VALUES ("ER3_8","016_3_8","EZR","3","8","8","Mo wimone Ierusalemwa God duwa enedia aupawe waimoio ena dea dialen. Ema aupe ena da uaboawa natawa bedewe Sealtiel otopa Serubabel, Iosadak otopa Iesua damba do, pirisi ita Liwai damba tane do apana uduudu emalawoau wadaitumoiena leuntone bola debama Ierusalem bedewe wimoiena. Ita sape mo osowe uwantone God duwa wadeiena. Mo Liwai damba mida enau 20 wadena teamoieno nola sa uantopua apanawa wananton. ");
INSERT INTO soq_vpl VALUES ("ER6_16","016_6_16","EZR","6","16","16","Tane Israel apanawa, pirisi, ita Liwaiwa do mo mida emalawoau otamone antoiena leuntone wimoiena God duwa nanantone me wanane nuaeuntoiena. ");
INSERT INTO soq_vpl VALUES ("NH8_1","017_8_1","NEH","8","1","1","Apana uduudu wimone auweia bolawe sabamo du moawa ebowa waia Esa Gonaala Intawa Moape sape mo auweiena. Ita mo anaana waeuwa apana Esra dieiena Moses anaanawa bukawa Iawe God Israelwa wanamona wadepie wimpi. ");
INSERT INTO soq_vpl VALUES ("NH8_2","017_8_2","NEH","8","2","2","Sa baiwa uaboa 7 wadeno walama dea ualeno pirisi Esra anaana bukawa wadene apana uduudu mona ita ioto ita seda eiau gagalo etapue atentopua mampo wisen. ");
INSERT INTO soq_vpl VALUES ("NH8_3","017_8_3","NEH","8","3","3","Esra auauwa bolawe sabamo anaana bukawa apana uduudu mona ita ioto ita seda eiau gagalo etapue atentopua mampo wisialen. Me omo wisedio anaana bukawa wisialeidio enautalen ita mo deaitopa asisusaie. ");
INSERT INTO soq_vpl VALUES ("NH8_5","017_8_5","NEH","8","5","5","Esra apana danauwo ia tabataba osowe enedie ita apana uduudu me eweie. Ita me anaana bukawa wadenaubene wisialepia baiwaleidio mo uduudu ewane enanawimoiena. ");
INSERT INTO soq_vpl VALUES ("NH8_6","017_8_6","NEH","8","6","6","Esra Iawe God me ipa debamawaida wadaposisan. Ita apana uduudu me sipoasane waienase, “Sa ulaipa!” Ita mo witapu wadaposimoiena. Tane mo dunentone Iawe God wadaposisaiena. ");
INSERT INTO soq_vpl VALUES ("NH8_8","017_8_8","NEH","8","8","8","Liwai apanawa God anaanawa bukawa wisiantone waeuwantono gagalo ipawa sabamoleno apana atentoiena. ");
INSERT INTO soq_vpl VALUES ("NH8_9","017_8_9","NEH","8","9","9","Tane apana anaana gagalowa etane ke waiena sa baiwa gabemani Niamaia, anaana waeuwala Esra ita Liwaiwa mo mida waeuwantoia apanawa uduudu mampo wane waienase, “Walama ema ipa kakaiwa Iawe e Godila baiwa ita e mai nuala parelepio ke wana!” ");
INSERT INTO soq_vpl VALUES ("NH8_10","017_8_10","NEH","8","10","10","Niamaia wanase, “Tauma e aitane esa ita nanala eubu uwatauwa namona ita mo mida mai dima da wadape wimopona nanala moa wanamona. Walama ema ipa kakaiwaida Iawe God mampe. Iawe God e nuaeu enalen ita e muka wadana sa baiwa mai nuala parelepi, dia.” ");
INSERT INTO soq_vpl VALUES ("JB1_1","019_1_1","JOB","1","1","1","Apana ebowa Iob tawo Us bedewe wandie. Me ipa apana dodomana dewa euda os dewalala. Me God sawaleidie atoweleidie mai kadi da dewasapona, dia. ");
INSERT INTO soq_vpl VALUES ("JB1_2","019_1_2","JOB","1","2","2","Me obampa mona 7 ita anoanopa natadea gamomon. ");
INSERT INTO soq_vpl VALUES ("JB1_3","019_1_3","JOB","1","3","3","Ita me sipsipwa uduudu 7,000, kamelwa 3,000, kauwa 1,000 ita donkiwa iwoa 500. Ita do me nolawa apanawa uaraia. Tane me ipa maura apanawa mai apana isiwa bola sa omo wisedia deneuwe waimoia ruau. ");
INSERT INTO soq_vpl VALUES ("JB1_4","019_1_4","JOB","1","4","4","Iob obampa muba duwoduwo oda dewasaie ita mo deadea walamau wisedio oda dewasaie weaweanapu natadea nisomoio wimoio do nana nai. ");
INSERT INTO soq_vpl VALUES ("JB1_5","019_1_5","JOB","1","5","5","Tane oda dialeidio Iob dewawa rua dewasadie ita obampa gagalou wadiaubedio mampe wimoio ita mo deadea dewamodio euntoi God emawe. Ipawa me insediase, “Ne obaina kadiwa dewasaiena ba nuau bedewe God wakadisa waiena.” Sa baiwa me tadinaida enedie pue sumodie puloleide God mampe me obampa euntompa baiwa God emawe. ");
INSERT INTO soq_vpl VALUES ("JB1_6","019_1_6","JOB","1","6","6","Walama dea Iawe God danawe me enseliwa auweiena ita Seitan do sape wisen. ");
INSERT INTO soq_vpl VALUES ("JB1_7","019_1_7","JOB","1","7","7","Iawe God Seitan diene wanase, “E naepe os lamoie tauma wien?” Tane Seitan leusane wanase, “Ne tawo uduudu osowe di leidine.” ");
INSERT INTO soq_vpl VALUES ("JB1_8","019_1_8","JOB","1","8","8","Tane Iawe God Seitan diene wanase, “E ne nolana dewalala Iob ewaana ba, dia? Me ipa apana eudida mai mida da me rua tawo osowe wainipona, dia. Me dewa dodomana os dewamodie ita ne wiwiranaleide tane mai kadiwa da dewasapona.” ");
INSERT INTO soq_vpl VALUES ("JB1_9","019_1_9","JOB","1","9","9","Tane Seitan Iawe God mampe wane wanase, “E onieiadewaitiana baiwa me wiwiraaleide. ");
INSERT INTO soq_vpl VALUES ("JB1_10","019_1_10","JOB","1","10","10","E walama uduudu me ita obampa ita do puraiwawa oniadewasamoiana. Dima me dewasadia e dewamoiano euda os segaleide. Sa baiwa tauma me mampe kau ita sipsip uaranton ");
INSERT INTO soq_vpl VALUES ("JB1_11","019_1_11","JOB","1","11","11","tane naita e me nituwa uduudu otaubaitaa me e nanawo wakadisaa wapi.” ");
INSERT INTO soq_vpl VALUES ("JB1_12","019_1_12","JOB","1","12","12","Tane Iawe God wanase, “Oa, me nituwa uduudu e witaawosadina tane mai me kadisaa, dia.” Mape Seitan Iawe God ene alen. ");
INSERT INTO soq_vpl VALUES ("JB1_13","019_1_13","JOB","1","13","13","Walama dea Iob obampa mona ita iwoa otopa tautuwa duwa bedewe oda dewasaie. ");
INSERT INTO soq_vpl VALUES ("JB1_14","019_1_14","JOB","1","14","14","Ita walama sa dea bedewe benema apanawa Iob duwe wisene diene wanase, “E kaua dogo nobantoie laie ita donkia tampo ina naie laie ");
INSERT INTO soq_vpl VALUES ("JB1_15","019_1_15","JOB","1","15","15","ita poiwaa bola Sabe apanawa wimone pue uduudu poisamoiena ita nola apanawa uduudu bomoiena. Ne dea os eneieno weuwane e dieepa baiwa winen.” ");
INSERT INTO soq_vpl VALUES ("JB1_16","019_1_16","JOB","1","16","16","Tane apana sa gagaloleidio benema apanawa da wisene wanase, “God kelama uboe wanaubeno iene e sipsipa ita mo onioniau apanawa do imontuan. Ne dea os eneieno weuwane e dieepa baiwa winen.” ");
INSERT INTO soq_vpl VALUES ("JB1_17","019_1_17","JOB","1","17","17","Tane apana sa gagaloleidio benema apanawa natadeawa wisene wanase, “Poiwaa ua natadea Babilon tawowa bedewe wanwanla wimone e kamela uduudu poisamoiena ita e nolaa dewalala bomoiena. Ne dea os eneieno weuwane e dieepaa baiwa winen.” ");
INSERT INTO soq_vpl VALUES ("JB1_18","019_1_18","JOB","1","18","18","Ita apana sa gagaloleidio benema apanawa da wisene wanase, “E obana mona ita iwoa otoa tautuwa duwa bedewe odantoie. ");
INSERT INTO soq_vpl VALUES ("JB1_19","019_1_19","JOB","1","19","19","Tauwadea os lanunu debamaia sala makowa bedewe wisene du sainapa epamono du bioudene nosene obana uduudu bomontuwan. Ne dea os eneieno weuwane e dieepa baiwa winen.” ");
INSERT INTO soq_vpl VALUES ("JB1_20","019_1_20","JOB","1","20","20","Ita Iob enene nuaparewa eueuwa garawa siolen ita uwa korelen. Ita me dunelene namba dogo osowe itune God wadaposisan. ");
INSERT INTO soq_vpl VALUES ("JB1_21","019_1_21","JOB","1","21","21","Ita me wanase, “Ne muntedine mai dima da wadape noneapona ita bontepine mai nitu da wadape do anteapa, dia. Nitu sa uduudu Iawe God ne nen ita mainawo mebaa leusane oten. Ne Iawe God ebowa wadaposisadina.” ");
INSERT INTO soq_vpl VALUES ("JB1_22","019_1_22","JOB","1","22","22","Poka saiwa ema uduudu Iob mampe seganton tane me mai God wawusape baiwa waponase, “God ne mainawo kadi dewasan.” ");
INSERT INTO soq_vpl VALUES ("JB2_1","019_2_1","JOB","2","1","1","Tane walama da bedewe ensel wanwanlala awodea Iawe God danawe wimoiena ita Seitan do mo bedeuwo wisen, me wisena Iawe God danawe enepi. ");
INSERT INTO soq_vpl VALUES ("JB2_2","019_2_2","JOB","2","2","2","Iawe God Seitan diene wanase, “E naepe leie tauma mape wien?” Tane Seitan leusane wanase, “Ne tawo uduudu osowe antene di leidine.” ");
INSERT INTO soq_vpl VALUES ("JB2_3","019_2_3","JOB","2","3","3","Ita Iawe God Seitan diene wanase, “Ne nolana dewalala Iob ewaana ba, dia? Me ipa apana eudida mai mida da me rua tawo osowe wainipona, dia. Me dewa dodomana os dewamode ita wiwiranaleidie wande. Me mai dewa da kadiwa dewasapona. E ne ensineano me poka wanana, tane me mai dima da kadiwa dewasapona, dia. Me dewa dodomana os dewamodie wiwiranaleidie wande.” ");
INSERT INTO soq_vpl VALUES ("JB2_4","019_2_4","JOB","2","4","4","Ita Seitan Iawe God sipoasane wanase, “Iob meba etepa insaisawa os insedie wande! Tane apana nituwa uduudu nanalepiaubepie inawawa inasapi. ");
INSERT INTO soq_vpl VALUES ("JB2_5","019_2_5","JOB","2","5","5","Tane naita e witaa me osowe itue poka wanaa me e wakadisaa nanawo wapi.” ");
INSERT INTO soq_vpl VALUES ("JB2_6","019_2_6","JOB","2","6","6","Iawe God epe etene wanase, “Oa, ne me witaawosadina tane mai witaa me osowe itue ita bosaa, dia.” ");
INSERT INTO soq_vpl VALUES ("JB2_7","019_2_7","JOB","2","7","7","Ita Seitan Iawe God mampe gagaloleidia ene alen. Me alene Iob etepa dewasano bene uduudulen. Bene sa ipa kadiuida wawe ita uwawe wisen. ");
INSERT INTO soq_vpl VALUES ("JB2_8","019_2_8","JOB","2","8","8","Tane me nuaparewa eueuwa isana bedewainta wandie ita onta tutuwadia kepakepa mampe benewa maumodie. ");
INSERT INTO soq_vpl VALUES ("JB2_9","019_2_9","JOB","2","9","9","Ita manainapa me diene wanase, “Sai ema uduudu e manawoleidio dima baiwa e God wiwirawaitie ita dewa dodomana dewamoiana? E God wapadabuasape oso boitapono dialepona.” ");
INSERT INTO soq_vpl VALUES ("JB2_10","019_2_10","JOB","2","10","10","Tane Iob manainapa sipoasane wanase, “E gagaloitiana etaeta i oolepie gagalolempa rua. No dewa euwa God nenedio wadeitana, sa baiwa kadiwa empo mainimbo iompo no ideita wadonta.” Ema uduudu Iob mampe seganton, tane me mai moape kadiwa da wapona, diaida. ");
INSERT INTO soq_vpl VALUES ("JB2_11","019_2_11","JOB","2","11","11","Iob sosowa natadea mo ebou ipa Elipas Teman apanawa, Bilda bolawa Sun ita Sopa Naamat bolawa bedewe wanwanlala. Mo Iob poka etedia umanawa etane auwene gagalontone me nuadubusapua baiwa mampe anton. ");
INSERT INTO soq_vpl VALUES ("JB2_12","019_2_12","JOB","2","12","12","Mo ieie nowa dauwo Iob eweiena, tane mampe wimone ewane koasaiena. Ita mo ke debamaia wane nuapareu eueuwa dewasane garau siosamoiena ita popokau osouwo weisaiena. ");
INSERT INTO soq_vpl VALUES ("JB2_13","019_2_13","JOB","2","13","13","Ita mo Iob do dogo osowe waimoio walama 7 ita tadina 7 dianton. Iob poka debamaia etedie, sa baiwa mo ewane gagalo wasasia daina waimoie. ");
INSERT INTO soq_vpl VALUES ("JB3_1","019_3_1","JOB","3","1","1","Wiki sa aupe mai mida gagalolepona, Iob gagaloleidie ualene inawa gamosana walamawa aiawa badowa mampe wadabuasan. ");
INSERT INTO soq_vpl VALUES ("JB3_2","019_3_2","JOB","3","2","2","Iob wanase, ");
INSERT INTO soq_vpl VALUES ("JB3_3","019_3_3","JOB","3","3","3","“Ne inana gamonena walamawa e siniepaaubepona ita tadina sa mo waienase, ‘Oto mona mulen.’ ");
INSERT INTO soq_vpl VALUES ("JB3_4","019_3_4","JOB","3","4","4","Walama sa iwinlepona! God iono mai banusapi, ita sapa mai osowe me sapasapi. ");
INSERT INTO soq_vpl VALUES ("JB3_5","019_3_5","JOB","3","5","5","Iwin debama walama sa nopesapi; Giou rupusapibodepi; ita iwin ema inana gamonena walamawa saanasapi. ");
INSERT INTO soq_vpl VALUES ("JB3_6","019_3_6","JOB","3","6","6","Iwin debama tadina sa wadepidodepi! Tadina sa mai nuaeulepi ena sa bedewe walama isiwa ruau; ita mo mai walama sa wisiantopu ena sa bedewe. ");
INSERT INTO soq_vpl VALUES ("JB3_7","019_3_7","JOB","3","7","7","Oa, tadina sa mai ipawa itupi; ita nuaeu kawa me bedewe mai etapu. ");
INSERT INTO soq_vpl VALUES ("JB3_8","019_3_8","JOB","3","8","8","Wene apanawa walama ema badowaida wadabuasapu; mo ipa sa owa motawa debamaia poru wadamesawa atenton. ");
INSERT INTO soq_vpl VALUES ("JB3_9","019_3_9","JOB","3","9","10","Tadina sa ne inana bupe oto dua intawa mai gudulepona, ita poka saiwa mainawo mai weregasapona. Sa baiwa tadina sa walama kiporawa dubasampa; ita sapa banusapi tane mai donsapi, dia, ita mai tadinaida omo emawa siapa ewepi, dia. ");
INSERT INTO soq_vpl VALUES ("JB3_11","019_3_11","JOB","3","11","11","Ambi ne mai bonteapona inana gamonena walamawa oso? Ne inana bupe nonedina dianteapona? ");
INSERT INTO soq_vpl VALUES ("JB3_12","019_3_12","JOB","3","12","12","Dima baiwa inana imimpa endolene gamonen? Dima baiwa inana amawa mampe ne amamanen? ");
INSERT INTO soq_vpl VALUES ("JB3_13","019_3_13","JOB","3","13","13","Ne inana gamonedia walamawe, bonteape iape daina winapona; ne itunteipe bubuanteipona.” ");
INSERT INTO soq_vpl VALUES ("JB4_1","019_4_1","JOB","4","1","1","Tane Elipas Teman apanawa Iob sipoasane wanase: ");
INSERT INTO soq_vpl VALUES ("JB4_2","019_4_2","JOB","4","2","2","“Naita ne gagaloepo, e nuaa kadilepio? Tane mai daina wampaa rua. ");
INSERT INTO soq_vpl VALUES ("JB4_3","019_4_3","JOB","4","3","3","Ulaipa, e apana uaraia waeuwamoana, e mo witapu oarantoia dewamoano badonton. ");
INSERT INTO soq_vpl VALUES ("JB4_4","019_4_4","JOB","4","4","4","E aiaa mampe apana omeia saumoano eneiena; apana imimpu oaoarau e dewamoano badonton. ");
INSERT INTO soq_vpl VALUES ("JB4_5","019_4_5","JOB","4","5","5","Tane tauma poka saiwa manawo wiseno e insaisaa omen; poka saiwa ibua wadeno saidaiten. ");
INSERT INTO soq_vpl VALUES ("JB4_6","019_4_6","JOB","4","6","6","Ambi, e God wiwirawaitiana ita do wanwanaa dodomanawa wainiana dewaepono insaisaa badolepona. ");
INSERT INTO soq_vpl VALUES ("JB4_7","019_4_7","JOB","4","7","7","E inseiana apana kadiwa mai dewasaipona do sanaa waimoia di bontoi, ba? Apana wanwan dodomana waimoia God kadimode, ba? ");
INSERT INTO soq_vpl VALUES ("JB4_8","019_4_8","JOB","4","8","8","Ne apana sa ewamodina, mo ipa sa kadiwa aimoie ita kadiwa uwauwantoi. Sa baiwa mo poka saiwa anei lawuru naumba aneia rua. Ita mo muba ipa sa kadi dewawa ita poka saiwa aneiena deawaida uwauwantoi.” ");
INSERT INTO soq_vpl VALUES ("JB38_1","019_38_1","JOB","38","1","1","Tane Iawe God kaibisibisi bedewe Iob sipoasane diene wanase, ");
INSERT INTO soq_vpl VALUES ("JB38_2","019_38_2","JOB","38","2","2","“E ambi ne insaisana dewasadina bedewe aiaa ipasiawaia mampe ne waitaraneiana? ");
INSERT INTO soq_vpl VALUES ("JB38_3","019_38_3","JOB","38","3","3","Naita e apana, imaite wine nainawo enaa; Ne e waitaraepino sipoanea. ");
INSERT INTO soq_vpl VALUES ("JB38_4","019_38_4","JOB","38","4","4","E na epe wainiano ne tawo ema dewasane ituna? Naita e ateitaa tauma dianea. ");
INSERT INTO soq_vpl VALUES ("JB38_5","019_38_5","JOB","38","5","5","Mida debamawa makawa atenlene rua dewasan, e ateiten ba, dia? Mida witapa aubene rualen? ");
INSERT INTO soq_vpl VALUES ("JB38_6","019_38_6","JOB","38","6","6","Tuatua sa bumpa dima osowe eindoe enede? Tuatua sawano enedia mida eindoden? ");
INSERT INTO soq_vpl VALUES ("JB38_7","019_38_7","JOB","38","7","7","Walama sawo walama kiporawa uduudu sasantoie, ita God enseliwa uduudu nuaeu mampe wadaposintoie. ");
INSERT INTO soq_vpl VALUES ("JB38_8","019_38_8","JOB","38","8","8","Tane walama ipa owa bupa bedewe abaialene nosen, ita mida owa itunbodeno winede?” ");
INSERT INTO soq_vpl VALUES ("JB40_1","019_40_1","JOB","40","1","1","Tane Iawe God wane wanase, ");
INSERT INTO soq_vpl VALUES ("JB40_2","019_40_2","JOB","40","2","2","“Iob, ne God Mukamukaua amboituneiana tauma ea ba, dia? Naita wadabuaitona, ne waitarana e sipoamoa.” ");
INSERT INTO soq_vpl VALUES ("JB40_3","019_40_3","JOB","40","3","3","Iob leusane wanase, ");
INSERT INTO soq_vpl VALUES ("JB40_4","019_40_4","JOB","40","4","4","“Ne apana diapana, ambi e sipoaepa? Ne witana mampe moana wadapaboe dainanteapa. ");
INSERT INTO soq_vpl VALUES ("JB40_5","019_40_5","JOB","40","5","5","Ne gagalonten ita osowe e gagaloa mai sipoasapaa rua, dia.” ");
INSERT INTO soq_vpl VALUES ("JB42_1","019_42_1","JOB","42","1","1","Tane osowe Iob Iawe God mampe wane wanase, ");
INSERT INTO soq_vpl VALUES ("JB42_2","019_42_2","JOB","42","2","2","“Ne ateina nitu uduudu e dewamoa rua, ita e dima insamoie dewasaiana mai mida e enabodaepia rua. ");
INSERT INTO soq_vpl VALUES ("JB42_3","019_42_3","JOB","42","3","3","E ne dianee waanase, ‘E ambi ne insaisana dewasadina bedewe aiaa ipasiawaia mampe ne waitaraneiana?’ Ulaipa, ne dewa mai atenteipe gagalo diapanau di wamodine, dewa debamau mai atenteapa rua, dia. ");
INSERT INTO soq_vpl VALUES ("JB42_4","019_42_4","JOB","42","4","4","E ne dianee waanase, ‘E asisuneano gagalonteapa! Ne waitaraepo ita e sipoanea.’ ");
INSERT INTO soq_vpl VALUES ("JB42_5","019_42_5","JOB","42","5","5","Bauta e umanaa apana ne dianeieno etedine, tane tauma ne emanawoido e eweedina. ");
INSERT INTO soq_vpl VALUES ("JB42_6","019_42_6","JOB","42","6","6","Sa baiwa ne gagalona uduudu wamodina malawantedina, ita insaisana leusadina eueuwa popokau ita isana bedewe wainedina.” ");
INSERT INTO soq_vpl VALUES ("JB42_7","019_42_7","JOB","42","7","7","Iawe God Iob mampe gagalo ema wamono aupe, me Elipas Teman apanawa mampe gagalolene wanase, “E ne umanana mai ulaipa mampe wapona ne nolana dewalala Iob dewaleidia rua. Sa baiwa ne nuana kadilen e ita sosoa nata do manlawo. ");
INSERT INTO soq_vpl VALUES ("JB42_8","019_42_8","JOB","42","8","8","Sa baiwa e kau mona 7 ita sipsip mona 7 otamone ne nolana dewalala Iob mampe aitane pulo itune suna eba baila. Me e baila rauparilepi, ita dima ne dewasapa iririwaneampo e baila dewasapa. Ita ne mai e kadila dewasalana ruaidanteape matangelalepa. E ne umanana mai ulaipa wapona ne nolana dewalala Iob dewaleidia rua.” ");
INSERT INTO soq_vpl VALUES ("JB42_9","019_42_9","JOB","42","9","9","Sa baiwa Elipas Teman apanawa, Bilda Sun apanawa ita Sopa Naamat apanawa Iawe God diamona rua dewasaiena. Ita Iob Iawe God iririsana rua mampo dewasan. ");
INSERT INTO soq_vpl VALUES ("JB42_10","019_42_10","JOB","42","10","10","Iob sosowa baibu rauparileno dialeno aupe Iawe God maura wanen. Bauta nitu uduudu Iawe God wanena me osowesane do wanen. ");
INSERT INTO soq_vpl VALUES ("JB42_11","019_42_11","JOB","42","11","11","Iob sosowa, tatatawa, weaweanapa ita apana uduudu mida me bauta atensaiena me duwa bedewe wimone me do nana naiena. Mo uduudu wimone me mampe nuapareu eueuwa dewasaiena. Ita Iawe God poka saiwa wanaubeno Iob mampe wisena gagalowa me wasausaiena. Ita mo deadea mane ita rin gold mampe dewalala me waneiena. ");
INSERT INTO soq_vpl VALUES ("JB42_12","019_42_12","JOB","42","12","12","Iawe God Iob inawawa bauta eusan, tane inawawa ompeido eudidasan. Tauma Iob sipsipwa 14,000, kamelwa 6,000, kauwa 2,000 ita donkiwa iwoa 1,000. ");
INSERT INTO soq_vpl VALUES ("JB42_13","019_42_13","JOB","42","13","13","Ita do me obampa mona uduudu 7 ita anoanopa natadea wanen. ");
INSERT INTO soq_vpl VALUES ("JB42_14","019_42_14","JOB","42","14","14","Me anoopa tautuwa ebowa wane ituna Dimaima, tane anoopa wawea ebowa Kesia ita anoopa ompa ebowa wane ituna Keren-apua. ");
INSERT INTO soq_vpl VALUES ("JB42_15","019_42_15","JOB","42","15","15","Tawo uduudu bedewe mai ioto da uwataubu Iob anoanopa rua waimoipona, dia. Tane Iob obampa mona ita iwoa diamona me bolepio aupe maurawa empuempusapuo ua 10 winapuo mo deadea otepu. ");
INSERT INTO soq_vpl VALUES ("JB42_16","019_42_16","JOB","42","16","16","Me inalene aupe enawa 140 wain. Sa baiwa me enawa daumaia waine me obampa, ita obampa sedau oden alene nosi wadena ewamon. ");
INSERT INTO soq_vpl VALUES ("JB42_17","019_42_17","JOB","42","17","17","Ita me gulauidalene bolen. ");
INSERT INTO soq_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Nuaeu debama me mampe mida mai kadi dewalala do warorontoipona ba aiau eteipe ruawaleipona; ba kadi dewalala ita do mo mida God wasiwa waia, bedeuwoleipe do deantoipona, ");
INSERT INTO soq_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","tane me Iawe God anaanawa nuawadawadasadie, tadina ita walama God aiawa wisialeidie insaisaleidie wandia. ");
INSERT INTO soq_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Apana sa ia maneu tampe inintoie, ita ipau walamau osowe naumoidewantoia rua ita do asiu mai rorontoipe nonosintoipona tane dima uduudu mo dewasaia ipa ipuipua segaleide. ");
INSERT INTO soq_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Tane apana kadi dewalala mampo mai epe segaleipona! Mo ina tonapa rua lanunu wisedie suaubamode. ");
INSERT INTO soq_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Sa baiwa mo mai Iawe God kotuwa saiepue inantopu, ita me apanawaida do mai deantopu, dia. ");
INSERT INTO soq_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Iawe God dewa dodomana dewasaia apanawa os ewamodie saumode, tane kadi dewalala bo intawa asiasi antoi. ");
INSERT INTO soq_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","Dawid sasawa Iawe God me ipa ne onioniana apanawa wande sipsip onionia apanawa euda rua. Sa baiwa ne mai dima abolawantipona, dia. ");
INSERT INTO soq_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","Me banlanedio bola euda bedewe antedine, sape esa obasa aleidiawo wanwan euda wainedine bubuadewantedina. ");
INSERT INTO soq_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Ne sape wainedine leidino nuana wasileidio muka wadedina. Me dewawa dodomana baiwa ne banlanedio a dewadewantedina. ");
INSERT INTO soq_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Tane ne dewa da badowaida kadineampo boida baiwantepine mai bo ba kadiwa sawanteapa, ipawa Iawe God e ipa ne do mai eneipona, dia; e koinaa mampe bodaneie onianeiana. ");
INSERT INTO soq_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","E nisoneiano emalawoana apanawa ewaneio oda nanawa debama imasaanawo iedina. E ne ituposineaana manawonteapa baiwa mena wadee uanawo memeana; do nana nadine pokanedio wainedina. ");
INSERT INTO soq_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Ita e ne nuawadawadanene dewa euda mainawo dewasana, ita ne e nata duawo wankasantata. ");
INSERT INTO soq_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","Dawid sasawa Iawe God ipa ne sapana, ita inawana, sa baiwa ne mai santeapa. Me ne onianede ando mai kadi donsapa sa baiwa ne mai inguguranteapa. ");
INSERT INTO soq_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","Emalawoa apanawa kadi daitada dewalala ne bodaneapu kadineapua baiwa, tane mo muba bagorantopue omepu. ");
INSERT INTO soq_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","Mo uara awodeantopue ne onana enapu, tane ne mai mo sauntapa. Mo ne bodaneampo, ne sumanaina Iawe God mampe itupa. ");
INSERT INTO soq_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","Ne Iawe God iririsapo dewa dea os ne baina dewasapi: walama uduudu ne inawana bedewe me duwa bedewe wainepina, ne me euwaa ewapaa menanede ita me duwa kakaiwa bedewe mampe rauparintapa. ");
INSERT INTO soq_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","Ne poka mainawo wisempo me bola euda bedewe wereganepi, me duwa bedewe ne onianepi, me nau osowe ionoido itunepi. ");
INSERT INTO soq_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","Ne emalawoana apanawa uara enapue pananeapu, tane ne mo onaponteapa. Ne Iawe God duwa bedewe me mampe pue pulontape supa, ne nuaeu mampe ka wape sino epape ita sasantapa Iawe God mampe. ");
INSERT INTO soq_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","Iawe God, manawo rauparintepino etanea, nuaparenaite saunea! ");
INSERT INTO soq_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","E ne dianee waanase, “Wine mainawo gagaloitaa.” Sa baiwa tauma ne manawo iedina. ");
INSERT INTO soq_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","Ne ipa e nolaa dewalala, mai nuaa kadilepio adia ne mainawo itua, e mai weregaitaa! E ne inaneana, e walama uduudu ne sauneie, sa baiwa tauma mai nebaida enea! Mai eneaiaa! ");
INSERT INTO soq_vpl VALUES ("PS27_10","020_27_10","PSA","27","10","10","Naita ne mamana ita inana adiu ne mainawo itupu, tane Iawe God walama uduudu wadanempe mampeneampa. ");
INSERT INTO soq_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","Iawe God, ne emalawoana apanawa wadaneapua baiwantoi, sa baiwa waeuwaneawo waroroepa, e inta dodomana asiasi banlanea. ");
INSERT INTO soq_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","Emalawoa apanawa sa ne lagana wai, mo ne kadineapua menamode, sa baiwa e mai mo emowo ne wadaneapu! ");
INSERT INTO soq_vpl VALUES ("PS27_13","020_27_13","PSA","27","13","13","Ne sumanaintedina Iawe God euda dewasapio ewapa, tawo ema osowe inawaa wainepino me dewasapi. ");
INSERT INTO soq_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","Sa baiwa Iawe God sumanaiwaitana, insaisala itune badowa enonuna, Iawe God sumanaiwaitana. ");
INSERT INTO soq_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","Walama dea Dawid Abimelek danawe dewalena ewaewa abo oopa rua, sa baiwa me wanaubeno alen. Dewa ema aupe Iawe God Dawid sausana insene ita sasa ema girumalen. Ne walama uduudu Iawe God wadaposisapina ita me asowa wapina. ");
INSERT INTO soq_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","Ne me ebowa debamasapina, e apana ituaisilala gagalo ema etane nuaeuitana. ");
INSERT INTO soq_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","Iawe God wadaposisata, no awodea me ebowa debamasata! ");
INSERT INTO soq_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","Ne Iawe God mampe rauparinteno ita me ne sipoanen, apana sa ne sauntedina mampo me inanen. ");
INSERT INTO soq_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","Apana mida sau baiwa Iawe God mampentoia, mo nuaeuntoi, me walama uduudu mo saumompa. ");
INSERT INTO soq_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","Ne poka uara mainawo wimoieno tane Iawe God mampe rauparinteno etanen, ne poka etedino me inanen. ");
INSERT INTO soq_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","Apana mida Iawe God wiwirawantoia, me enseliwa mo oniamode, me mo gonaamodio do waimoi. ");
INSERT INTO soq_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","Sa baiwa e Iawe God mampeitane ita me euwaa dauwaida etana. Naita e me onialepia baiwa mampe aitana, e nuaeuitana. ");
INSERT INTO soq_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","E sumanailala Iawe God ebowa debamasana. Apana mida me ebowa debamasaia mai dima abolawantopu. ");
INSERT INTO soq_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","Walama isiwa pue laion omana tomodio lai, tane mida Iawe God sumanaiwantoia nitu uduudu mampe rua os waimoi mai nitu da abolawantopu, dia. ");
INSERT INTO soq_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","Ne obaina, mainawo winlene gagalona etana. Ne waeuwalepo Iawe God wiwirawaitonuna. ");
INSERT INTO soq_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","E wanwan daumawa ita do wanwan euda waina menalempa, ");
INSERT INTO soq_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","mai apana wakadisamonuna do mai laga wanuna. ");
INSERT INTO soq_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","Kadiwa dewasailana ene tane euda dewasana, ita apana saumono wanwan euda obasa wampu. ");
INSERT INTO soq_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","Iawe God emawa apana dewa dodomana dewasaia osouwo winede, mo sau baiwa me mampe iririntoio etamode. ");
INSERT INTO soq_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","Tane kadi dewasaia apanawa mampo me namba nambesade, mo bontopuo ando mai mida mo umanau wapi, dia. ");
INSERT INTO soq_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","Iawe God apanawa me mampe sau baiwa iririntompo etamopi, me mo poka uduudu bedewe saumopie inamopi. ");
INSERT INTO soq_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","Apana mida insaisau omaomala Iawe God ipa mo do, ita mo mida nuabolantoie insaisau omedia me saumopie insaisau badosapi. ");
INSERT INTO soq_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","Dewa dodomana dewasaia apanawa poka saiwa uara donsai, tane Iawe God walama uduudu mo saumodie inamode. ");
INSERT INTO soq_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","Me emawa mo osouwo, sa baiwa mai neaipu da tewapi. ");
INSERT INTO soq_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","Tane kadi dewalala, mo muba kadiwa dewasaia kadimopi, ita apana mida dodomana dewasaio emalawoamoia matangelawa mo wadapu. ");
INSERT INTO soq_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","Tane Iawe God me nolawa dewalala inamode. Apana mida Iawe God saumopie inamopia baiwa me mampe antoia mai matangela donsapu, dia. ");
INSERT INTO soq_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","Warere Dawid apana ebowa Uria manainapa ebowa Besiba nata ninanton. God perowetawa Natan wisene aia badowa mampe Dawid diaidasan. Me aia ema etene dewawa kadiwa insene ita nuawa pareleno sasa ema girumalen. O God, e nuawadawadaa mai diala, sa baiwa nuaparenaite saunea. E walama uduudu apana nuapareuitiana, sa baiwa kadiwana inseadabuasaa. ");
INSERT INTO soq_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Kadina mitaaubea, ita mitanee eunea. ");
INSERT INTO soq_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Ne ateina dewa kadiwa dewasana, nainanepe winedio walama uduudu insedina. ");
INSERT INTO soq_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Ne kadiwa e manawo dewasana, dea e os manawo; e emaawo ne eueuwana ipa kadiwa. Sa baiwa e ne diane waanase, “E kadiwa dewasaana!” E ulaipa waiana. E ne matangelanea, sa e dewa dodomana dewasaiana. ");
INSERT INTO soq_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Ne muntena walamawe odene ita tauma ne ipa kadi dewalala, Ne inana bupa bedewe kadi do wainedine. ");
INSERT INTO soq_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Tane e meneedia ne nuana bedewe ulaipa nopesapi sa baiwa nuana bedewe insaisa eubu teamoa. ");
INSERT INTO soq_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Ne kadiwana mitaaubee ita eunea ita sapaida wapa. ");
INSERT INTO soq_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Ne kadina inseiadabuasaiana umanawa wawo etape ita ulaipa mampe nuaeuntapa; e ne dewaneano neaina nonosinton tane osowe dewaneawo nuaeutapa. ");
INSERT INTO soq_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Ne dewana kadiwa mai ewamona wade nambeidomoa. ");
INSERT INTO soq_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","O God, ne nuana mitee sanaasaa ita ulaipa mampe ne waroroepa. ");
INSERT INTO soq_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Ne mai waaubaneawo eepe anteapa! E Aleua Kakaiwa bedenawo mai wadaaubea! ");
INSERT INTO soq_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Dewaneawo osowe nuaeunteapa, bauta inaneano nuaeutena rua, Ne dewaneawo e aiaa ruawantepina dewawa menaneampa. ");
INSERT INTO soq_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Ita kadi dewalala mampo e intaa ne waeuwamopina ita mo leuntopue e manawo wimpu. ");
INSERT INTO soq_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","O God, e ne inanea, saunee inawana oniea ita ne nuaeu mampe e dewaa dodomana sasawa wapa. ");
INSERT INTO soq_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","O Tatana, sauneawo moana wadapaaubepe wadaposiepa. ");
INSERT INTO soq_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Ne pue supe pulonteapa e manawo, tane e mai meneeipona. E mai pulo inainamba sa iririwa waipona, dia. ");
INSERT INTO soq_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","Ne neba ituaisinteape iririepo kadina inseadabuasaa, e pulo inainamba ema meneede. O God, ne kadiwana dauwa etane nuaparentene manawo rauparintedina mai leunea. ");
INSERT INTO soq_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","O God, bola Saion nuaparewaitee sausaa; me gonaawa tewana osowe wadawo enepi. ");
INSERT INTO soq_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","Ita apana amonau nuau dodomana mampe e manawo dewasampo nuaa eulempa; mo pulou daitada sumpe e nuaa eusampa ita kau mona e oltaa osowe pulontompa. ");
INSERT INTO soq_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","1","O God, nuaparembaite, sau euda osombo itua. E nana mainimbosae oiwawaitaa. ");
INSERT INTO soq_vpl VALUES ("PS67_2","020_67_2","PSA","67","2","2","Ita apana uduudu tawo osowe waimoia e dewaa atentopu, uwa daitada apanawa atentopu e mo inamoa rua. ");
INSERT INTO soq_vpl VALUES ("PS67_3","020_67_3","PSA","67","3","3","Uwa daitada apanawa God wadaposiepu, apana uduudu e wadaposiepu! ");
INSERT INTO soq_vpl VALUES ("PS67_4","020_67_4","PSA","67","4","4","Apana uduudu tawo osowe nuaeu mampe sasantopu ipawa e dewaa dodomana mampe uwa daitada apanawa oniamoiana, e apana uduudu tawo osowe oniamona. ");
INSERT INTO soq_vpl VALUES ("PS67_5","020_67_5","PSA","67","5","5","Uwa daitada apanawa God wadaposiepu apana uduudu e wadaposiepu! ");
INSERT INTO soq_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","Ita tawo osowe nana mauralepi ita no Godimba sau debama no osombo itupi. ");
INSERT INTO soq_vpl VALUES ("PS67_7","020_67_7","PSA","67","7","7","Ulaipa, God sau euda no osombosapi ita bola daitada bede wanwanlala me wadaposisana. ");
INSERT INTO soq_vpl VALUES ("PS90_1","020_90_1","PSA","90","1","1","God nolawa dewalala Moses sasa ema girumalen. Tatamba, e ipa walama uduudu no wanwanimba bolawa. ");
INSERT INTO soq_vpl VALUES ("PS90_2","020_90_2","PSA","90","2","2","E ipa wanwankasalalaida muriwa wadi dewamoana do muriwa tawo uduudu dewamoana. ");
INSERT INTO soq_vpl VALUES ("PS90_3","020_90_3","PSA","90","3","3","E apana diamoe waanase, “E leuitane popokau wanaitana!” Mo popokau mampe seganton, tane e leumoano popokau wananton. ");
INSERT INTO soq_vpl VALUES ("PS90_4","020_90_4","PSA","90","4","4","E emaawo ena 1,000 ipa walama dea rua, ena sa ipa tadina omowa kampaida rua. ");
INSERT INTO soq_vpl VALUES ("PS90_5","020_90_5","PSA","90","5","5","E apana inawau tauwadea os wadeiaubeiana auen ewawo nuaa tauwadea awawalepia rua. Mo ipa beran tadinaida kelontoia rua. ");
INSERT INTO soq_vpl VALUES ("PS90_6","020_90_6","PSA","90","6","6","Tadinaida beran kelowa ewaewau eubu, tane rawiwa mo rorontoie nonosintoi. ");
INSERT INTO soq_vpl VALUES ("PS90_7","020_90_7","PSA","90","7","7","E nuakadia debama no kadinede e nuaa no mainimbo kadileidia walamawe e saaidantitana. ");
INSERT INTO soq_vpl VALUES ("PS90_8","020_90_8","PSA","90","8","8","No kadimba uduudu e eweiana, no weregasaitana, tane e sabamo eweiana. ");
INSERT INTO soq_vpl VALUES ("PS90_9","020_90_9","PSA","90","9","9","No wainitano e nuaa kadileide; apana nonaupa itumpaiompa rua e no wanwanimba tauwadea os kampasaana. ");
INSERT INTO soq_vpl VALUES ("PS90_10","020_90_10","PSA","90","10","10","No wantaa enawa ipa 70, tane apana isiwa mukantopua wampuo enau 80 wadepi; no wainite sai uara donsaitana, mai wainipono daumaleipona ita bontitana. ");
INSERT INTO soq_vpl VALUES ("PS90_11","020_90_11","PSA","90","11","11","Mai mida e nuakadia pokawaaida atenleipona, naita e nuakadia no atendewantepono, e saaidantepona. ");
INSERT INTO soq_vpl VALUES ("PS90_12","020_90_12","PSA","90","12","12","No wanwanimba walamawa kampaida winedia waeuwanewo atentate, ita insadewasa bedewe wainenta. ");
INSERT INTO soq_vpl VALUES ("PS90_13","020_90_13","PSA","90","13","13","Iawe God, insaisaa leusae nuaparembaitaa! Mai kaino nuaa kadilempa no mainimbo! ");
INSERT INTO soq_vpl VALUES ("PS90_14","020_90_14","PSA","90","14","14","Tadinaida uduudu euwanena e nuawadawadaa no baimba ipa winakasalala, ita no walama uduudu nuaeu mampe sasantonte wainenta. ");
INSERT INTO soq_vpl VALUES ("PS90_15","020_90_15","PSA","90","15","15","E sai debama ena uara bedewe nenaana, tane tauma deawaa dewasae walama dauma bedewe nuaeu nenona! Poka eteitana wadaaubea, ita wanwan euda ena uara bedewe wanta. ");
INSERT INTO soq_vpl VALUES ("PS90_16","020_90_16","PSA","90","16","16","No ipa e nolaa dewalala, e dewaa pokawaa euwanea, no obainimba euwamoa e ipa, mukamukaua ita debamawaida wainiana. ");
INSERT INTO soq_vpl VALUES ("PS90_17","020_90_17","PSA","90","17","17","Tatamba e ipa no Godimba, sau euda osombo itua, no nolamba dewasawo eulepie ipuipua segalepi, oa, e no nolamba dewasawo eulepie ipuipua segalepi. ");
INSERT INTO soq_vpl VALUES ("PS95_1","020_95_1","PSA","95","1","1","Winleno sasantate Iawe God wadaposisata no nuaeu mampe me wadaposisata, me ipa no onioniamba ita saumba. ");
INSERT INTO soq_vpl VALUES ("PS95_2","020_95_2","PSA","95","2","2","No me mampe winte auwasata no sasantate me wadaposisata. ");
INSERT INTO soq_vpl VALUES ("PS95_3","020_95_3","PSA","95","3","3","Ipawa Iawe God me ipa debamawaida, me ipa warere mukamukaua tawo godiu uduudu aimon. ");
INSERT INTO soq_vpl VALUES ("PS95_4","020_95_4","PSA","95","4","4","Tawo bolawa uduudu ipa me mampea doba nuau iane aidantona ita wadi debama odane aidantona me os witape winei. ");
INSERT INTO soq_vpl VALUES ("PS95_5","020_95_5","PSA","95","5","5","Owa ipa me mebaa, ipawa me dewasan ita do tawo me dewasan. ");
INSERT INTO soq_vpl VALUES ("PS95_6","020_95_6","PSA","95","6","6","Winleno dunentate Iawe God wadaposisata, Iawe God no dewanena danawe iminimba emmisintata. ");
INSERT INTO soq_vpl VALUES ("PS95_7","020_95_7","PSA","95","7","7","Me ipa no Godimba, no ipa me apanawaida, oniadewasanede, gamowa rua onianedio wainitana. Ande e me aiawa etanadewaitana! ");
INSERT INTO soq_vpl VALUES ("PS95_8","020_95_8","PSA","95","8","8","Me wadiase, “E mai nosinosila sala makowa bedewe bola Meriba ita Masa bedewe wimone nuau anatene badosaiena ruauitana! ");
INSERT INTO soq_vpl VALUES ("PS95_9","020_95_9","PSA","95","9","9","Mo ne ginasana emauwoido eweiena, ita mai sumanaintopona, tane rubu osowe ituneiena. ");
INSERT INTO soq_vpl VALUES ("PS95_10","020_95_10","PSA","95","10","10","Ena 40 bedewe ne mo mampo nuana kadileno wanase, ‘Apana ema nuau nambeido, ne aiana mai ruawantoipona.’ ");
INSERT INTO soq_vpl VALUES ("PS95_11","020_95_11","PSA","95","11","11","Sa baiwa nuana kadileno badowa diamone wanase, ‘Ne bubua bolawa mo baibu imaasanawo mai odapu, dia.’” ");
INSERT INTO soq_vpl VALUES ("PS100_1","020_100_1","PSA","100","1","1","Apana uduudu tawo osowe wanwanlala, mukaitane Iawe God mampe sasaitana! ");
INSERT INTO soq_vpl VALUES ("PS100_2","020_100_2","PSA","100","2","2","E winlene nuaeu mampe me wadaposisana, e me danawe nuaeu mampe sasaitana. ");
INSERT INTO soq_vpl VALUES ("PS100_3","020_100_3","PSA","100","3","3","E insene ateitana Iawe ipa God. Me no dewanen; no ipa me apanawa onianedio wainitana, gamo onionia sipsipwa oniamodia rua. ");
INSERT INTO soq_vpl VALUES ("PS100_4","020_100_4","PSA","100","4","4","E me duwa kakaiwa bedewe aitane me auwasana, e sape aitane me wadaposisana. Me ebowa debamasane ita auwasana, ");
INSERT INTO soq_vpl VALUES ("PS100_5","020_100_5","PSA","100","5","5","ipawa Iawe God me ipa eudida. Me nuawadawadawa apana baibu ipa winakasalala! Me saualena rua, mo mampo euda dewawa mai eipona. ");
INSERT INTO soq_vpl VALUES ("PS103_1","020_103_1","PSA","103","1","1","Dawid sasawa Ne nuana uduudu mampe Iawe God wadaposisapa. Me ebowa kakaiwa wadaposisapa. ");
INSERT INTO soq_vpl VALUES ("PS103_2","020_103_2","PSA","103","2","2","Ne nuana uduudu mampe Iawe God wadaposisapa, ne walama uduudu me dewa eubu dewamona insamopina. ");
INSERT INTO soq_vpl VALUES ("PS103_3","020_103_3","PSA","103","3","3","Me ne kadiwana uduudu insadabuamode ita kerona uduudu inamode. ");
INSERT INTO soq_vpl VALUES ("PS103_4","020_103_4","PSA","103","4","4","Ne bo baiwantedino me inanen. Me ne nuawadawadanedie ita nuaparenaleidie dewa eubu mainawo dewamode. ");
INSERT INTO soq_vpl VALUES ("PS103_5","020_103_5","PSA","103","5","5","Ne inawaa wainepino me nitu eubu mampe ne sauneampa, ema epe inta ne apana sanaa mukamukaua seganteapa nene inamoia mukamukaua rua. ");
INSERT INTO soq_vpl VALUES ("PS103_6","020_103_6","PSA","103","6","6","Iawe God apana ewadabualala saumode ipawa me dewawa dodomana; me mo mampo kotuwa dodomana os dewasade. ");
INSERT INTO soq_vpl VALUES ("PS103_7","020_103_7","PSA","103","7","7","Me dima insedia umanawa Moses euwasan, me dewa pokawaa dewamone mukawa debama sabamosano Israel apanawa eweiena. ");
INSERT INTO soq_vpl VALUES ("PS103_8","020_103_8","PSA","103","8","8","Iawe God nuawa aiaisiwa ita nuaparelala, me mai tauwadea nuawa kadileipona, do me nuawadawadawa mai dialepi. ");
INSERT INTO soq_vpl VALUES ("PS103_9","020_103_9","PSA","103","9","9","Me mai no kadimba kainokaino eweipe enituidaneipona, dia, ita do me nuakadiwa mai winakasaleipona. ");
INSERT INTO soq_vpl VALUES ("PS103_10","020_103_10","PSA","103","10","10","No kadiwa dewasaitana baiwa me matangelaneipona, tane me no kadiwa dewasaitana mai ruaida sipoanepie matangelaidanepi. ");
INSERT INTO soq_vpl VALUES ("PS103_11","020_103_11","PSA","103","11","11","Mo mida me wiwirawantoia mampo me nuawadawadawa ipa debamaia winakasalala; nuawadawada sa ipa iono uba debama winedia rua. ");
INSERT INTO soq_vpl VALUES ("PS103_12","020_103_12","PSA","103","12","12","Omo wisedie nowa daumaia aleidie pamedia rua, epe rua me no kadimba riasadio nambeido aleide. ");
INSERT INTO soq_vpl VALUES ("PS103_13","020_103_13","PSA","103","13","13","Seda mambu obampa mampo nuawa aiaisiwa wandia rua, Iawe God mo mida me sawantoia mampo nuawa aiaisiwa wande, ");
INSERT INTO soq_vpl VALUES ("PS103_14","020_103_14","PSA","103","14","14","ipawa me atemba no popokau mampe dewanen, me atemba no mai apana mukamukaua, dia. ");
INSERT INTO soq_vpl VALUES ("PS103_15","020_103_15","PSA","103","15","15","No ipa beran rua tawo osowe wainitana, no beran kelontoie ita nonosintoia rua, walama kampaida os wainitana. ");
INSERT INTO soq_vpl VALUES ("PS103_16","020_103_16","PSA","103","16","16","Lanunu wiseidie suaubamode, ita tauwadea nonosintoio mai mida ewamoipona. ");
INSERT INTO soq_vpl VALUES ("PS103_17","020_103_17","PSA","103","17","17","Tane Iawe God nuawadawadawa ipa winakasalala, mo mida me sawantoie wiwirawantoia mampo me euda dewasade ita mo bedeuwo mida ando muntompa mampo winakasalepi, ");
INSERT INTO soq_vpl VALUES ("PS103_18","020_103_18","PSA","103","18","18","mo mida saua badowa wadeitue ita anaana sa ruawantoia. ");
INSERT INTO soq_vpl VALUES ("PS103_19","020_103_19","PSA","103","19","19","Iawe God uba dewasana me kolaiwatawa, osowe waine dewa uduudu oniamode. ");
INSERT INTO soq_vpl VALUES ("PS103_20","020_103_20","PSA","103","20","20","E ensel mukamukaua uduudu, Iawe God aiawa eteile ruawaitilana, e Iawe God wadaposisana. ");
INSERT INTO soq_vpl VALUES ("PS103_21","020_103_21","PSA","103","21","21","E uboo wanwanlala mukamukaua uduudu e mida me nolawa dewasailana, Iawe God wadaposisana. ");
INSERT INTO soq_vpl VALUES ("PS103_22","020_103_22","PSA","103","22","22","Dewa uduudu me dewamona uboo ita tawo osowe wineia, e uduudu Iawe God wadaposisana. Ne do nuana uduudu mampe Iawe God wadaposisapa. ");
INSERT INTO soq_vpl VALUES ("PS110_1","020_110_1","PSA","110","1","1","Dawid sasawa Iawe God ne debamana dieene wanase, Iawe God gagaloleide warere mampe “Witana on deneuwe aisite wana ne ideita e emalawoa nanausimope e waa atowe teamopatuapi.” ");
INSERT INTO soq_vpl VALUES ("PS110_2","020_110_2","PSA","110","2","2","E Ierusalemwae noe aitono Iawe God dewaepio mukaa debamalepi, ita e emalawoa apanawa onapoite oniamoa. ");
INSERT INTO soq_vpl VALUES ("PS110_3","020_110_3","PSA","110","3","3","E emalawoa apanawa onau enaa walamawe, e apanaaida mo muba nuau wadapuaubepue nomopue bautantopu. E gara kakaiwa mampe benaitaa ita me walama ruawalempe mukaa sanaasampa, kipora esapa sala butasadio tadinaida nitu uduudu sanaantoia rua. ");
INSERT INTO soq_vpl VALUES ("PS110_4","020_110_4","PSA","110","4","4","Iawe God e sauaene wanase, “E ipa pirisi wanwankasalala pirisi Melikisedek rua.” Me saua sa wana mai insaisawa leusapi. ");
INSERT INTO soq_vpl VALUES ("PS110_5","020_110_5","PSA","110","5","5","O Iawe God, e witaa on deneuwe warere wandia nuawa kadilepio warere uara bomopi. ");
INSERT INTO soq_vpl VALUES ("PS110_6","020_110_6","PSA","110","6","6","Me uwa daitada apanawa matangelamopi ita mo bontoia etepu mo bolau nopesapi. Mo uwau nepa epatuiamopi, tawo uduudu osowe. ");
INSERT INTO soq_vpl VALUES ("PS110_7","020_110_7","PSA","110","7","7","Warere ando into esa alala nampe alempa ita muka wadompa, do me ipa mukawaida segalepi. ");
INSERT INTO soq_vpl VALUES ("PS119_9","020_119_9","PSA","119","9","9","O Iawe God, apana sanaa ambi wanwan dodomana os wampi? E aiaa ruawalepie wanwan dodomana wampi. ");
INSERT INTO soq_vpl VALUES ("PS119_10","020_119_10","PSA","119","10","10","Ne nuana uduudu mampe rubusadina nolaa dewasapa, sa baiwa mai enewo anaanaa dabuasape epa. ");
INSERT INTO soq_vpl VALUES ("PS119_11","020_119_11","PSA","119","11","11","E aiaa ne nuana bedewe teamono winei, ita dewa kadiwa e manawo mai dewasapa. ");
INSERT INTO soq_vpl VALUES ("PS119_12","020_119_12","PSA","119","12","12","Ne Iawe God wadaposiedina, e anaanaa ne waeuwanea. ");
INSERT INTO soq_vpl VALUES ("PS119_13","020_119_13","PSA","119","13","13","E anaanaa apana wanamoana ne osowesane mukantene wisiantedina. ");
INSERT INTO soq_vpl VALUES ("PS119_14","020_119_14","PSA","119","14","14","Ne e anaanaa ruawantedina mampe nuaeuidantedina, mai maura bedewe nuaeu donsadina rua. ");
INSERT INTO soq_vpl VALUES ("PS119_15","020_119_15","PSA","119","15","15","Ne e anaanaa wisiantepine ewepinadewantepine, ita e waeuwa insepina. ");
INSERT INTO soq_vpl VALUES ("PS119_16","020_119_16","PSA","119","16","16","Ne nuaeuntepina e anaanaa bedewe e aiaa ne mai nuana awawalepi. ");
INSERT INTO soq_vpl VALUES ("PS121_1","020_121_1","PSA","121","1","1","Ne sau naepeinta donsapona insene, pisiwane wadi ewamona. ");
INSERT INTO soq_vpl VALUES ("PS121_2","020_121_2","PSA","121","2","2","Ne sau Iawe God mida uba ita tawo dewamona mampee, mainawo wisepio wadapa. ");
INSERT INTO soq_vpl VALUES ("PS121_3","020_121_3","PSA","121","3","3","Sa baiwa me mai eepio omea, dia, walama uduudu eweedio wainiana mai ituleipona, ");
INSERT INTO soq_vpl VALUES ("PS121_4","020_121_4","PSA","121","4","4","Iawe God ipa Israelwa onioniau apanawa, me mai emawa lauleipona ba ituleipona, dia. ");
INSERT INTO soq_vpl VALUES ("PS121_5","020_121_5","PSA","121","5","5","Iawe God ipa e onioniaa apanawa wande, me ipa e tanawoido kadiwa donsano sauepi. ");
INSERT INTO soq_vpl VALUES ("PS121_6","020_121_6","PSA","121","6","6","Walamo omo sapawa e mai kadiepi ita tadino uaboa sapawa mai kadiepi, dia. ");
INSERT INTO soq_vpl VALUES ("PS121_7","020_121_7","PSA","121","7","7","Poka daitada manawo wisempo Iawe God e oniadewasaepi, ita kadiwa mai donsaa, dia. ");
INSERT INTO soq_vpl VALUES ("PS121_8","020_121_8","PSA","121","8","8","E noene aitona ita leuitona bedewe Iawe God emawa ipa e osoawo, me e oniadewasaempa tauma ita ando ita ando bedewe. ");
INSERT INTO soq_vpl VALUES ("PS139_1","020_139_1","PSA","139","1","1","Dawid sasawa Iawe God, ne nuana bedewa banuitene ewaana, e ne atenidaneana. ");
INSERT INTO soq_vpl VALUES ("PS139_2","020_139_2","PSA","139","2","2","Ne wainedina ba enedina e atenaida, e nowa dauwoido wainiana tane insaisana uduudu atenaida. ");
INSERT INTO soq_vpl VALUES ("PS139_3","020_139_3","PSA","139","3","3","E ne ewaneiano leidina ba bubuantedina, dewa uduudu dewamodina e atena. ");
INSERT INTO soq_vpl VALUES ("PS139_4","020_139_4","PSA","139","4","4","Muriwa gagalo da moanawo nosepi, e bauta ateitiana muriwa ne wadina. ");
INSERT INTO soq_vpl VALUES ("PS139_5","020_139_5","PSA","139","5","5","E ipa gonaa rua ne pananeana, e mukaa debama mampe gonaaneana. ");
INSERT INTO soq_vpl VALUES ("PS139_6","020_139_6","PSA","139","6","6","E ne ateineiana atemba ipa debamaia, ne mai atenteapaa rua. ");
INSERT INTO soq_vpl VALUES ("PS139_7","020_139_7","PSA","139","7","7","Ne naepe anteapo e mai ewanea? Mai bola da wineipona bedewe anteapa, ne naepe antape wampona e sape wainiana. ");
INSERT INTO soq_vpl VALUES ("PS139_8","020_139_8","PSA","139","8","8","Ne odape uboo anteapa, e sape wainiana; ba bolala bolauwo iape anteapa, e sape wainiana. ");
INSERT INTO soq_vpl VALUES ("PS139_9","020_139_9","PSA","139","9","9","Naita ne omo wisediawo anteapa, ba omo pamediawo anteapa, ");
INSERT INTO soq_vpl VALUES ("PS139_10","020_139_10","PSA","139","10","10","e bola sa bedewe ne witana wadae banlanea, ita e mukaa mampe ne gonaanea. ");
INSERT INTO soq_vpl VALUES ("PS139_11","020_139_11","PSA","139","11","11","Ne dubawa diapo wereganepi, ita sapa diapo iwinlepie dubalepi ");
INSERT INTO soq_vpl VALUES ("PS139_12","020_139_12","PSA","139","12","12","tane dubawa e mai bodeepia rua e manawo dubawa ipa walama sapawa rua. Dubawa ita sapa e manawo ipa deawau os. ");
INSERT INTO soq_vpl VALUES ("PS139_13","020_139_13","PSA","139","13","13","E ne etena moa daitada dewasaana, ita inana bupa bedewe awodeasae ituneana. ");
INSERT INTO soq_vpl VALUES ("PS139_14","020_139_14","PSA","139","14","14","E dewa pokawaa dewasae dewaneana baiwa wadaposiedina; nitu uduudu e dewamoiana ipa eubuida. Ne nuana uduudu mampe atenten. ");
INSERT INTO soq_vpl VALUES ("PS139_15","020_139_15","PSA","139","15","15","Ne neaina uduudu dewamoana, ita deaitopanee inana bupa bedewe ituneana, sape werego muntedino, e ateiten ne sape wainedine. ");
INSERT INTO soq_vpl VALUES ("PS139_16","020_139_16","PSA","139","16","16","E ne ewaneano muriwa munten. Ne wampaa walamawa umanawa e bukaa bedewe girumaiten ita muriwa walama sa ualen. ");
INSERT INTO soq_vpl VALUES ("PS139_17","020_139_17","PSA","139","17","17","God e insaisaa uduudu ne mai atentapatuwapia rua, ipawa e insaisaa uarakadinton! ");
INSERT INTO soq_vpl VALUES ("PS139_18","020_139_18","PSA","139","18","18","Ne mai wisiamopa rua ipawa e insaisaa ipa uaraia, nela wisiasiawaia rua! Ne itu bedewe enapawineapa, e ne tainawo onianeiana! ");
INSERT INTO soq_vpl VALUES ("PS139_19","020_139_19","PSA","139","19","19","God, ne menaidanedia e apana kadi dewasaia bomoa! Ne mainawo wita kadilala tanamowo nambe antopu. ");
INSERT INTO soq_vpl VALUES ("PS139_20","020_139_20","PSA","139","20","20","Mo e wakadisaei, mo e eboa mai wiwirawantoipona. ");
INSERT INTO soq_vpl VALUES ("PS139_21","020_139_21","PSA","139","21","21","Iawe God, mo mida e dabuaeia ne dabuamodina. Mo e aiaa amboitusai. ");
INSERT INTO soq_vpl VALUES ("PS139_22","020_139_22","PSA","139","22","22","Ne nuana kadiidaleide mo mampo; sa baiwa mo ipa ne emalawoana apanawa. ");
INSERT INTO soq_vpl VALUES ("PS139_23","020_139_23","PSA","139","23","23","Ne nuana bedewa banuitee ewaa ita insaisana uduudu ateitaa. ");
INSERT INTO soq_vpl VALUES ("PS139_24","020_139_24","PSA","139","24","24","Naita kadi dewalala intau asiasi antepina waeuwanea, ita e ina winakasala intawa asiasi banlanea. ");
INSERT INTO soq_vpl VALUES ("PR1_7","021_1_7","PRO","1","7","7","E insadewasa apanawa segaitaa meneepia e bauta Iawe God sumanaiwaite wiwirawaitaa. Mo insakadisala apanawa insaisa euda ita aten waeuwa mo mai menamoipona. ");
INSERT INTO soq_vpl VALUES ("PR1_8","021_1_8","PRO","1","8","8","Otona, mamaa aiawa etaadewaitaa, ita do inaa waeuwa mai dabuasae ea. ");
INSERT INTO soq_vpl VALUES ("PR1_9","021_1_9","PRO","1","9","9","Mo waeuwau e sauepio insaisa euda apanawa segaitaa, uwaawo beran inola ita do gadompawo posaru seupuo inainaa eusapia rua. ");
INSERT INTO soq_vpl VALUES ("PR5_8","021_5_8","PRO","5","8","8","I ninalala mampeinta mai aitaa, me duwa nopeinta mai aitaa, ");
INSERT INTO soq_vpl VALUES ("PR5_9","021_5_9","PRO","5","9","9","naita e epe dewaitaa apana mai wiwiraantopu eboa debamaleidia ebo sa apana da mampolepi, ita e dewaa uduudu dewamoiana apana dewau rebareba kadiwaida mai nuapareantoipona wadapuo oaraitaa. ");
INSERT INTO soq_vpl VALUES ("PR5_21","021_5_21","PRO","5","21","21","Nitu uduudu apana dewasadia Iawe God ewedituwade, ita apana dewa daitada dewamoia sabamo me deaitopa ewamode. ");
INSERT INTO soq_vpl VALUES ("PR5_22","021_5_22","PRO","5","22","22","Apana kadiwa dewasaia mo muba kadiu karo rua wadamode, suana karo wadedia rua. ");
INSERT INTO soq_vpl VALUES ("PR5_23","021_5_23","PRO","5","23","23","Mo mai insadewasantoipe ita onioniadewantoipona, ita intau epuiapue bontopu. ");
INSERT INTO soq_vpl VALUES ("PR6_20","021_6_20","PRO","6","20","20","Otona mamaa aiawa etee ruawaitaa, ita do inaa waeuwa mai dabuasae ea. ");
INSERT INTO soq_vpl VALUES ("PR6_21","021_6_21","PRO","6","21","21","Mo aiau nuaawo ituwo walama uduudu winompa; ita do posaru rua gadompawo seuwo winompa. ");
INSERT INTO soq_vpl VALUES ("PR6_22","021_6_22","PRO","6","22","22","E a leuna bedewe mo wasaubu e inta waeuwaempa; do itua bedewe mo waeuwau e oniaepi, ita do itu bedewe enona walamawe aia ema e gagaloepi. ");
INSERT INTO soq_vpl VALUES ("PR6_23","021_6_23","PRO","6","23","23","Mo waeuwau inta waeuwaede, iwimpa bedewe siwa sapa wadia rua. Mo e wadabuaepu sa e dodomanaeie euwaei wanadewaitaa baiwa. ");
INSERT INTO soq_vpl VALUES ("PR6_24","021_6_24","PRO","6","24","24","Waeuwa ema e kakaiepio i nina rebarebala mai mampeita, ita do apana da manainapa me aiawa eubu wampo, e mai etee ruawaitaa. ");
INSERT INTO soq_vpl VALUES ("PR6_25","021_6_25","PRO","6","25","25","Me inainamba euda ewee mai nuaa bedewe omepi, me emawa bedewa mai ewaa. ");
INSERT INTO soq_vpl VALUES ("PR8_22","021_8_22","PRO","8","22","23","Mapo, Iawe God tawo mai dewasapona walamawe, walama sawo me nolawa ualepona baiwaleidie, bauta ne, Aten Insaisawa Euwa, dewanen. ");
INSERT INTO soq_vpl VALUES ("PR8_24","021_8_24","PRO","8","24","24","Bauta ne munten, muriwa Iawe God owa dewasan, ita maneu dogo bedewe dewasano wisen. ");
INSERT INTO soq_vpl VALUES ("PR8_25","021_8_25","PRO","8","25","25","Bauta ne munteno, muriwa Iawe God wadi debamau ita kerakera, ");
INSERT INTO soq_vpl VALUES ("PR8_26","021_8_26","PRO","8","26","26","tawo ita irai bolawa ba dogo dewamon. ");
INSERT INTO soq_vpl VALUES ("PR8_27","021_8_27","PRO","8","27","27","Ne wainedino Iawe God uba dewasan, ita me uba ita owa sawano makalen. ");
INSERT INTO soq_vpl VALUES ("PR8_28","021_8_28","PRO","8","28","28","Ne mampe wainedino me uba tampe giou dewamone teen, ita esa dewamono wimone owa nopesaiena. ");
INSERT INTO soq_vpl VALUES ("PR8_29","021_8_29","PRO","8","29","29","Ne wainedino Iawe God owa makawa einpunden, ita me anaanasana makawa mai ampibolepi. Ne wainedino me tawo winepia bolawa badowa dewasane osowe itun. ");
INSERT INTO soq_vpl VALUES ("PR8_30","021_8_30","PRO","8","30","30","Walama sawo ne koitau dewalala apanawa me tampe wainedine, ne walama uduudu me nuawa eusadine, ne me nata wainitana baiwa nuaeuntedine. ");
INSERT INTO soq_vpl VALUES ("PR8_31","021_8_31","PRO","8","31","31","Me tawo dewasana ne ewane nuana eulen, ita do tawo osowe apana waimoia ewane nuana eulen. ");
INSERT INTO soq_vpl VALUES ("PR9_1","021_9_1","PRO","9","1","1","Aten Insaisawa Euwa meba duwa waden; meba unsia 7 dewasan. ");
INSERT INTO soq_vpl VALUES ("PR9_2","021_9_2","PRO","9","2","2","I sa oda debama dewasan, me wain bedewe nitu bonabonaua aimone leusaitusane ita nana do wata osowe teen. ");
INSERT INTO soq_vpl VALUES ("PR9_3","021_9_3","PRO","9","3","3","Me nolawa dewalala iotopa wanaubeno anton apana uduudu nisomopio wimpu. Me alene sawano enene apalen. ");
INSERT INTO soq_vpl VALUES ("PR9_4","021_9_4","PRO","9","4","4","Me wanase, “Apana insakadisalala uduudu nisoledina winlena!” Mo mida mai insadewasantoipona mo mampo me wanase, ");
INSERT INTO soq_vpl VALUES ("PR9_5","021_9_5","PRO","9","5","5","“Winlene nanana dewasana nana, ita do wain dewasana nana. ");
INSERT INTO soq_vpl VALUES ("PR9_6","021_9_6","PRO","9","6","6","Insakoa dewawa emona ita wanwan euda waina; aten insaisawa euwa bedeweitane ita dewasana.” ");
INSERT INTO soq_vpl VALUES ("PR13_1","021_13_1","PRO","13","1","1","Oto insadewasala mamba badowa gagalosadio etedie ruawaleide, tane apana asowawala badowa diaidasampo mai etepie ruawalepi, dia. ");
INSERT INTO soq_vpl VALUES ("PR13_4","021_13_4","PRO","13","4","4","Apana etedabuala nitu uduudu menasade tane mai donsapie wadepi, tane apana mukaleidie nolaleidia dima menasadia wadompa. ");
INSERT INTO soq_vpl VALUES ("PR13_24","021_13_24","PRO","13","24","24","Apana mida otopa dewa kadiwa dewasadio mai epeipona me otopa nibuasade, tane apana mida otopa dewa kadiwa dewasadio epedia me otopa nuawadawadasadie sausade. ");
INSERT INTO soq_vpl VALUES ("PR17_21","021_17_21","PRO","17","21","21","Oto insakadisala mamba ita inawa dewamodio nuapareidantoi, ita oto sa gombawa mai nuaeuntoipona. ");
INSERT INTO soq_vpl VALUES ("PR20_4","021_20_4","PRO","20","4","4","Apana etedabuala mai irai walamawa osowe iraileipona; sa baiwa uwauwa walamawe nana dia baiwa mai uwauwalepi, dia. ");
INSERT INTO soq_vpl VALUES ("PR22_6","021_22_6","PRO","22","6","6","E oto waeuwasawo dewa dodomana dewawa atenlepi, ita me debamalepia walamawe waeuwa euda mai nuawa awawalepi. ");
INSERT INTO soq_vpl VALUES ("PR23_13","021_23_13","PRO","23","13","13","Oto dewa kadiwa dewasapio matangelawa mai ea, koina mampe oto epono mai bolepi, dia. ");
INSERT INTO soq_vpl VALUES ("PR23_14","021_23_14","PRO","23","14","14","Otoa koina mampe epaa, ita bo bedewe aleidia inasaa. ");
INSERT INTO soq_vpl VALUES ("PR24_30","021_24_30","PRO","24","30","30","Ne apana etedabuala iraiwa sa tampeinta winene anten, me ua koakoa wain aina iraiwa sa tampeinta anten. ");
INSERT INTO soq_vpl VALUES ("PR24_31","021_24_31","PRO","24","31","31","Irai sa bedewe gedara inintoio ewamona, do ina kadiwa inilene debamalen, ita do irai gonaawa seu mampe dewalala daberaralen. ");
INSERT INTO soq_vpl VALUES ("PR24_32","021_24_32","PRO","24","32","32","Ne irai sa ewane ita insaisawanten ita do atemba wadana. ");
INSERT INTO soq_vpl VALUES ("PR24_33","021_24_33","PRO","24","33","33","Itu kerauntape, bubua kerauntape, witaa nukuite ita itu dauma ituitaa. ");
INSERT INTO soq_vpl VALUES ("PR24_34","021_24_34","PRO","24","34","34","E ituitono nitu uduudu omanawa debama manawo wisepie wadeepiitudepi, poi apanawa wisepie wadeepiitudepia, rua. ");
INSERT INTO soq_vpl VALUES ("PR26_13","021_26_13","PRO","26","13","13","Apana etedabuala wadiase, “Pue onawaa intasino wande, pue sa into anuleidie wande ne adanepia baiwa!” ");
INSERT INTO soq_vpl VALUES ("PR26_15","021_26_15","PRO","26","15","15","Apana etedabuala nana baiwa aboma bedewe witapa itude, me etedabualeidia baiwa mai nana tauwadea wadepie moape itupi. ");
INSERT INTO soq_vpl VALUES ("PR29_3","021_29_3","PRO","29","3","3","Apana mida aten insaisawa euwa nuawadawadasadia me mamba nuaeusade, tane me mida i ninalala do laia nituwa eubu di diasade. ");
INSERT INTO soq_vpl VALUES ("PR29_15","021_29_15","PRO","29","15","15","Oto dewa kadiwa dewasadio epeiana aten euwa wadede, tane oto dewa kadiwa dewasadio mai epeipona oto sa inawa osowe mala itude. ");
INSERT INTO soq_vpl VALUES ("PR29_17","021_29_17","PRO","29","17","17","Obanla dewa kadiwa dewasapuo epamone waeuwamono mai kadiwa dewasapu ita ema bedewe wanwan euda segalepi, ita e dewalepuo nuaeuitana. ");
INSERT INTO soq_vpl VALUES ("PR31_10","021_31_10","PRO","31","10","10","Apana mida manainapa euda naisena, me nitu uwatauwa donsan. ");
INSERT INTO soq_vpl VALUES ("PR31_11","021_31_11","PRO","31","11","11","Badawa manainapa sumanaiwaleide, ita me mai dima da abolawalepi, diaida. ");
INSERT INTO soq_vpl VALUES ("PR31_12","021_31_12","PRO","31","12","12","Me walama uduudu, badawa mampe dewa euda dewasade. ");
INSERT INTO soq_vpl VALUES ("PR31_13","021_31_13","PRO","31","13","13","Me sipsip imba ita nitu isiwa otamodie upamodie mampe tai owanamode, me meba witape gara dewamode. ");
INSERT INTO soq_vpl VALUES ("PR31_19","021_31_19","PRO","31","19","19","Me meba witape tai dewamode, ita owanamode. ");
INSERT INTO soq_vpl VALUES ("PR31_20","021_31_20","PRO","31","20","20","Me duwa moawa wadaaubala apana nuaparelala mampo, ita apana dima menamodia mampe saumode. ");
INSERT INTO soq_vpl VALUES ("PR31_30","021_31_30","PRO","31","30","30","I dewawa nuateiteinala dewamodia apana mona lagasapia rua, me inainamba euwa sa ando mai winakasalepi, dia. Tane i dainea Iawe God wiwirawaleidia, apana i sa asowa wapu. ");
INSERT INTO soq_vpl VALUES ("PR31_31","021_31_31","PRO","31","31","31","E i sa wiwirawaitana! Me witape nolaleidie dewa debamau pokawaau dewamodia baiwa apana uara danauwo me asowa wapue ita ebowa ituposisapu. ");
INSERT INTO soq_vpl VALUES ("EC1_1","022_1_1","ECC","1","1","1","Ema ipa Waeuwa Apanawa Dawid otopa Ierusalem bedewe warereleidie wandia aiawa. ");
INSERT INTO soq_vpl VALUES ("EC1_2","022_1_2","ECC","1","2","2","Waeuwa Apanawa wadiase, “Nitu uduudu diapanau, diapanauida, ipusiawaia! Ulaipa di diapanauida!” ");
INSERT INTO soq_vpl VALUES ("EC1_3","022_1_3","ECC","1","3","3","Apana tawo ema osowe waimoie nola pokawaa dewasai, ita dima euwa dosaie wadei? ");
INSERT INTO soq_vpl VALUES ("EC1_4","022_1_4","ECC","1","4","4","Apana muntoie waimoi ita do apana bontoie antoi, tane tawo deawa winede. ");
INSERT INTO soq_vpl VALUES ("EC1_5","022_1_5","ECC","1","5","5","Omo wiseidie ita pamede, ita leuleidie aupawe wiseide. ");
INSERT INTO soq_vpl VALUES ("EC1_6","022_1_6","ECC","1","6","6","Lanunu wita sen deneuwe wiseidie, ita on deneuwe aleide. Ita kawiroroleidie winede. ");
INSERT INTO soq_vpl VALUES ("EC1_7","022_1_7","ECC","1","7","7","Esa nomoie owa bedewe antoi, tane owa mai nopeleipona; esa leuleidie aupawe wiseide, ita aleide. ");
INSERT INTO soq_vpl VALUES ("EC1_8","022_1_8","ECC","1","8","8","Nitu uduudu segaleidia etea dabuasampa rua, gagalowa wawa apana mai menamoipona; emamba nitu ewamode tane mai pokasaipona, ita asimba dima etamodia mai pokasaipona. ");
INSERT INTO soq_vpl VALUES ("EC1_9","022_1_9","ECC","1","9","9","Nitu uduudu bauta segantona tane osowe segantopu, nitu bauta apana dewamoiena osowe dewamopu, tawo osowe mai nitu da sanaa segaleipona, dia. ");
INSERT INTO soq_vpl VALUES ("EC1_10","022_1_10","ECC","1","10","10","Walama isiwa apana wapuase, “Ewane, nitu ema sanaa segalen.” Dia, nitu uduudu mapo segantona deawaa winei muriwa no munten. ");
INSERT INTO soq_vpl VALUES ("EC1_11","022_1_11","ECC","1","11","11","Dewa dainea mapo segantona mai mida insamoipona, dia, ita dima no tauma dewamoitana, apana ando muntompa mai insamopu. ");
INSERT INTO soq_vpl VALUES ("EC1_12","022_1_12","ECC","1","12","12","Ne ipa Waeuwa Apanawa Israelwa warereu Ierusalem bedewe wainedine. ");
INSERT INTO soq_vpl VALUES ("EC1_13","022_1_13","ECC","1","13","13","Ne aten insaisawa mampe nitu uduudu tawo osowe segaleidia insadewasamodine ita insena, “God apana osouwo sai ita nuabola itun.” ");
INSERT INTO soq_vpl VALUES ("EC1_14","022_1_14","ECC","1","14","14","Nitu uduudu tawo osowe segaleidia ipawa ne ewanasuden diapana, ewaewa lanunu tanone wadasusana rua. ");
INSERT INTO soq_vpl VALUES ("EC1_15","022_1_15","ECC","1","15","15","Nitu kiokiolena e mai dodomanasaa rua, ita nitu dainea mai winamoipona e mai di wisiaitaa rua. ");
INSERT INTO soq_vpl VALUES ("EC1_16","022_1_16","ECC","1","16","16","Ne neba wane wanase, “Ewee, ne ateina debamaidalen mai mapo warere Ierusalem bedewe waimoia atembu rua, dia. Ne ipa aten debama apanawa.” ");
INSERT INTO soq_vpl VALUES ("EC1_17","022_1_17","ECC","1","17","17","Ne insadewasa ita insakadisa atendewasamopa baiwa insaisawantedine tane donsana ipa dewa ema do lanunu tanone wadasusana rua. ");
INSERT INTO soq_vpl VALUES ("EC1_18","022_1_18","ECC","1","18","18","Naita ateina insaisawa euwa debamaidalepia nuabola osonawo itupi, ita naita ateina debamalepia nuapare osonawo itupi. ");
INSERT INTO soq_vpl VALUES ("EC2_1","022_2_1","ECC","2","1","1","Ne neba wane wanaase, “Ne neba nuaeunteapa dewawa dewasape ita ipawa atenteapa.” Tane donsane atentena ema do ipa ipasiawaia. ");
INSERT INTO soq_vpl VALUES ("EC2_2","022_2_2","ECC","2","2","2","Oi ipa oo dewawa ita nuaeu mai dima da euda dewasaipona. ");
INSERT INTO soq_vpl VALUES ("EC2_3","022_2_3","ECC","2","3","3","Ne insaisana euda mampe rubusane wain nane ita do dewa rebareba dewamona mampe nuaeunten. Ita atenteapa dewa dainea ipa eubu apana tawo ema osowe walama kampaida bedewe inawaa waimompe dewamompa. ");
INSERT INTO soq_vpl VALUES ("EC2_4","022_2_4","ECC","2","4","4","Ne nola debamau dewamone du wadamona ita wain iraiwa dewamona. ");
INSERT INTO soq_vpl VALUES ("EC2_5","022_2_5","ECC","2","5","5","Ne nana iraiwa dewasane ia naumbu nanalala aimono inintoiena. ");
INSERT INTO soq_vpl VALUES ("EC2_6","022_2_6","ECC","2","6","6","Ita doba dewamona esa iompe ia aimona butamompa baiwa. ");
INSERT INTO soq_vpl VALUES ("EC2_7","022_2_7","ECC","2","7","7","Ne nolana dewalala mona ita iwoa uaraia gimaramona ita nolana dewalala iwoa dunawo waimoie gamontoieno nolana dewalala uara seganton. Ita do kau ita sipsipna uwa uaraia waimoi, mai apana da epe rua Ierusalem bedewe wainipe, dia. ");
INSERT INTO soq_vpl VALUES ("EC2_8","022_2_8","ECC","2","8","8","Silwa, gold ita warere nitubu uwataubu bola dauwo wineia mainawolen. Ita do sasa wawala apanawa mona ita iwoa mainawo waimoie. Ita do manamanaina uaraia eubuida do wainitee. Dima uduudu apana menamodio baiwantoia uduudu ne mainawolentuwan. ");
INSERT INTO soq_vpl VALUES ("EC2_9","022_2_9","ECC","2","9","9","Ne puraiwa mampe mauraidanten mai apana da ne ruana bauta Ierusalem bedewe wainipe, dia. Tane dewa ema uduudu bedewe aten insaisawa euwa ne bedenawo winakasalen. ");
INSERT INTO soq_vpl VALUES ("EC2_10","022_2_10","ECC","2","10","10","Nitu uduudu ewamodina dewamopina os menanedio ita dewamodine, nitu sa uduudu dewamodina nuaeuneapona baiwa ita rua nuaeuneiena. Ne nolana sa nuaeuneiena, sa ipa ne nolana sa dewamodina malesawa wadana. ");
INSERT INTO soq_vpl VALUES ("EC2_11","022_2_11","ECC","2","11","11","Tane ne nola sa pokawau dewamona insaisawantedine, atentena nola sa ipa ipasiawaia diapana, lanunu tanone wadasusana rua. Ita nolana sa mai ipawa da euda tawo emauwo donsape wadapa, dia. ");
INSERT INTO soq_vpl VALUES ("EC2_12","022_2_12","ECC","2","12","12","Ne aten insaisawa euda, ita oo insaisawa ita do insakadisa insaisau wadedine. Apana mida ne aupana wadepie warerelepia, me mai nitu da sanaa dewasapi, dia. ");
INSERT INTO soq_vpl VALUES ("EC2_13","022_2_13","ECC","2","13","13","Tane ne ewane atenten aten insaisawa wadee manawosaa ipa euda, tane insakadisa wadee manawosaa sa ipa dewa kadiwa. Sapa ewaewa ipa euda mai dubawa rua. ");
INSERT INTO soq_vpl VALUES ("EC2_14","022_2_14","ECC","2","14","14","Insadewasa apanawa sala ewedidewae aleide, tane insakadisala me ipa dubawa bedewainta aleide. Tane ne ewane atenten, mo nata ando ompa osowe deawaa donsapu. ");
INSERT INTO soq_vpl VALUES ("EC2_15","022_2_15","ECC","2","15","15","Ita ne neba wane wanaase, “Dima ne ompa osowe donsapa deawaida insakadisa apanawa donsapi. Tauma dima euda ne aten insaisawa euda bedewe donsane wadana? Ema do ipa ipasiawaia.” ");
INSERT INTO soq_vpl VALUES ("EC2_16","022_2_16","ECC","2","16","16","Mai mida da ando insadewasala ba insakadisala insamopie umanau wapi, dia. Apana insadewasala ita insakadisala bo deawa bontopu. ");
INSERT INTO soq_vpl VALUES ("EC2_17","022_2_17","ECC","2","17","17","Nitu uduudu tawo ema osowe wainite dewasaitana sa ipa sai wadeite osombo ituitana. Sa baiwa ina tawo ema osowe wainitana ne dabuasadina. Ema uduudu ipa ipasiawaia lanunu tanone wadasusana rua. ");
INSERT INTO soq_vpl VALUES ("EC2_18","022_2_18","ECC","2","18","18","Ne nolana uduudu dewamodina epe bonteapo aupanawo apana da wadepi, sa baiwa ne nola tawo ema osowe etedabuantedina. ");
INSERT INTO soq_vpl VALUES ("EC2_19","022_2_19","ECC","2","19","19","Tane mida atenlen apana sa ne aupanawo nitu sa uduudu nolawantene pokanena bopawa wadepia me ipa insadewasa apanawa ba, dia? Tane dewa ema uduudu ipa ipasiawaia. ");
INSERT INTO soq_vpl VALUES ("EC2_20","022_2_20","ECC","2","20","20","Sa baiwa ne nolana pokawaa tawo ema osowe dewamodina insaisawantedine nuana pareidalen. ");
INSERT INTO soq_vpl VALUES ("EC2_21","022_2_21","ECC","2","21","21","Naita apana insaisa euda, aten ita nitu dewawa atemba apanawa nolalempe nitu uduudu ipawa segantopuo, tane emopio aupe apana da mai nolalepona di bopawa otamopi. Ema do ipa ipasiawaia mai dodomana. ");
INSERT INTO soq_vpl VALUES ("EC2_22","022_2_22","ECC","2","22","22","Nitu dainea euda apana tawo ema osowe nolawa pokamodia bedewe donsapue wadapu? ");
INSERT INTO soq_vpl VALUES ("EC2_23","022_2_23","ECC","2","23","23","Mo walama uduudu nolau bedewe poka ita nuapare wadeie mamposai do tadino mai itudewantoipe insaisau bubuasaipona, dia. Ema do ipa ipasiawaia. ");
INSERT INTO soq_vpl VALUES ("EC2_24","022_2_24","ECC","2","24","24","Sa baiwa eulena ipa apana nana ita esa nampa ita do nuaeulempe tauma nolawa dewasampa. Ne ewane atenten ema ipa God sauwa euda. ");
INSERT INTO soq_vpl VALUES ("EC2_25","022_2_25","ECC","2","25","25","Naita God diaewo mai mida nana naipe ita do nuaeuleipona, dia. ");
INSERT INTO soq_vpl VALUES ("EC2_26","022_2_26","ECC","2","26","26","Tane God insaisa euda, aten ita nuaeu mo mida me nuawa eusaia wanamode. Tane mo mida kadi dewalala saibu wanamodia mo ipa nola pokamompo ipawa itumpa. Ita nolau ipawa sa ipa mo mida God nuawa eusaia baibu. Ema do ipa ipasiawaia lanunu tanone wadasusana rua. ");
INSERT INTO soq_vpl VALUES ("EC3_1","022_3_1","ECC","3","1","1","Nitu uduudu walamau osowe segantoi, ita nitu uduudu walamau wisedio segantoi, ");
INSERT INTO soq_vpl VALUES ("EC3_2","022_3_2","ECC","3","2","2","Apana walamawa wisedio muleide ita bowa walamawa wisedio boleide, naumba anamba walamawa wisedio anei ita bobowa walamawa wisedio boiaubei, ");
INSERT INTO soq_vpl VALUES ("EC3_3","022_3_3","ECC","3","3","3","nitu epaboia walamawa wisedio epeiboleide ita inalepia walamawa wisedio inaleide, nitu wadakokowa walama wisedio wadeikokodede ita wadapuo enepia walamawa wisedio wadei, ");
INSERT INTO soq_vpl VALUES ("EC3_4","022_3_4","ECC","3","4","4","ke wawa walamawa wisedio ke wai ita oi wawa walamawa wisedio oi wai, nuaparepare walamawa wisedio nuaparentoi ita bia walamawa wisedio biantoi, ");
INSERT INTO soq_vpl VALUES ("EC3_5","022_3_5","ECC","3","5","5","seu daberara walamawa wisedio daberaramoi ita auauwa walamawa wisedio auweie tei, laubaba walamawa wisedio laubabantoi ita eewa walamawa wisedio ei, ");
INSERT INTO soq_vpl VALUES ("EC3_6","022_3_6","ECC","3","6","6","nitu banuwa walamawa wisedio banuntoi ita eewa walamawa wisedio dabuantoie ei, itumpo winompa walamawa wisedio itui ita aubauba walamawa wisedio aubei, ");
INSERT INTO soq_vpl VALUES ("EC3_7","022_3_7","ECC","3","7","7","gara siowa walamawa wisedio siontoi ita popowa walamawa wisedio popontoi, daina walamawa wisedio dainantoi ita gagalo walamawa wisedio gagalontoi, ");
INSERT INTO soq_vpl VALUES ("EC3_8","022_3_8","ECC","3","8","8","nuawadawada walamawa wisedio nuawadawadantoi ita seua walamawa wisedio seuantoi, ona walamawa wisedio onantoi ita wanwan euda obasa walamawa wisedio waimoidewantoi. ");
INSERT INTO soq_vpl VALUES ("EC4_9","022_4_9","ECC","4","9","9","Apana dea meba waimpa ipa euda tane apana nata waimompa sa ipa eudida, ipawa mo nata nolau bedewe edasauntompo ipuipua segalempa. ");
INSERT INTO soq_vpl VALUES ("EC4_10","022_4_10","ECC","4","10","10","Naita sowa da omepia da sausapie wadepiposidepi, tane apana dea meba waimpe omepia, sa ipa mai euda. Ipawa mai mida me sausapia rua, dia. ");
INSERT INTO soq_vpl VALUES ("EC4_11","022_4_11","ECC","4","11","11","Deawaa apana nata ituntompa mai obasa tomopi, tane apana dea meba itulempa obasa toidasapi. ");
INSERT INTO soq_vpl VALUES ("EC4_12","022_4_12","ECC","4","12","12","Apana dea mai onalepie emalawoa nanausapia rua, dia, tane apana natantopua edasauntopua rua. Tane apana natadea ipa mukamukauaida tai badowa owaowanala rua mai tauwadea puwapi. ");
INSERT INTO soq_vpl VALUES ("EC5_10","022_5_10","ECC","5","10","10","Maura apanawa menasadia mauraidalepi, tane dima uduudu menasadia mai donsapie wadepi, dia. Apana sa mauralepia menasadia me dima uduudu menasadia wadompa tane mai pokasampa. Me insaisa sa insedia ipa diapana ipasiawaia. ");
INSERT INTO soq_vpl VALUES ("EC5_11","022_5_11","ECC","5","11","11","Naita e mauraidaitaa, apana uara e mauraa sa moawa wadompe mamposampa, ita maura apanawa wane ewono mauraa dialempa. ");
INSERT INTO soq_vpl VALUES ("EC5_12","022_5_12","ECC","5","12","12","Apana mida nola pokamodia, nana debama ba kerauda nai tane itudewantoi, tane maura debama apanawa, maurau inseie mai itudewantoipe bubuantoipona, dia. ");
INSERT INTO soq_vpl VALUES ("EC5_13","022_5_13","ECC","5","13","13","Tane kero da debamaia tawo ema osowe winedia ne donsana, apana mida tawo ema nituwa mampe mauraleidie wadeditue anatedia nitu sa me inawawa kadisapi. ");
INSERT INTO soq_vpl VALUES ("EC5_14","022_5_14","ECC","5","14","14","Maura apanawa sa maurawa oniepidewalepie inisapio debamalepia baiwa nolawa dewasadie, tane maura sa kadilena baiwa me rebasan. Ita me bolepio aupe me obampa mai dima da wineipona wadapu, dia. ");
INSERT INTO soq_vpl VALUES ("EC5_15","022_5_15","ECC","5","15","15","No tawo ema osowe muntite mai dima da wadape do sabamontepona, dia, tane do bontate mai dima da nolawa pokanena wadate do ana, diaida. No bontate maura sa mai wadate do ana, dia. ");
INSERT INTO soq_vpl VALUES ("EC7_15","022_7_15","ECC","7","15","15","Ina tawo ema osowe diapana bedewe nitu nata ewamone atenten: Apana God anaanawa ruawaleidie wanwan dodomana wande, tane ideita apana sanaa boleide. Tane me mida kadiwa dewalala God anaanawa mai ruawaleipona wanwan daumawa wande. ");
INSERT INTO soq_vpl VALUES ("EC7_16","022_7_16","ECC","7","16","16","E mai apana emauwo dodomana wainiana asowawaitaa, mai apana emauwo e insaisa euda apanawa wainiana asowawaitaa, dima baiwa eba kadikaditiana? ");
INSERT INTO soq_vpl VALUES ("EC7_17","022_7_17","ECC","7","17","17","Mai eba kadi dewalala apanawaida segaitaa, mai insakadisalaida segaitaa, e meneedia boa walamawaida ee amua boita, ba? ");
INSERT INTO soq_vpl VALUES ("EC7_18","022_7_18","ECC","7","18","18","Dewa ema nata emoa. Euda ipa nuaitu wasauwa ema insene ruawaitona, apana mida God wiwirawaleidia, me mai eudidalepia ita kadiidalepia sawano waimpa. ");
INSERT INTO soq_vpl VALUES ("EC7_19","022_7_19","ECC","7","19","19","Insadewasa apanawa ipa mukamukauaida, mai warere 10 bola dea debama onieia mukau rua. ");
INSERT INTO soq_vpl VALUES ("EC7_20","022_7_20","ECC","7","20","20","Ulaipa mai apana da tawo ema osowe dodomanaida, dia, mai mida kadiwa dewasiawaiaida ita dodomanaida wainipona. ");
INSERT INTO soq_vpl VALUES ("EC8_16","022_8_16","ECC","8","16","16","Ne badowa insaisantedine aten insaisawa euda wadape apana tawo ema osowe nitu dewamoia atenteapona baiwa walama ita tadina mai bubuanteapona. ");
INSERT INTO soq_vpl VALUES ("EC8_17","022_8_17","ECC","8","17","17","Ema bedewe ne ewane atenten God dewa uduudu dewasadia mai mida atenlepituwapia rua, dia. Insadewasala apanawa wapiase me atemba tane me mai atenlepituwapia rua, diaida. ");
INSERT INTO soq_vpl VALUES ("EC11_9","022_11_9","ECC","11","9","10","E apana sanaau, mai dima da nuabolawaitonuna tane etela onienunadewaitonune mukamukaua wanlempa, ipawa e mai apana sanaa wankasaitana, dia. E sanaa wainilana mampe nuaeuitonuna. Dima e nuala menasadia rua dewamonunatuwampa tane insenadewaitana, ipawa dima uduudu dewamoilana baiwa ando God e kotulepi. ");
INSERT INTO soq_vpl VALUES ("EC12_1","022_12_1","ECC","12","1","1","E apana sanaa wainiana walamawe mida e dewaena mai nuaawawasaa, ipawa e gulauitaa walamawe e wae waase, “Ne tawo ema osowe wanwamba mai menaneipona, dia.” ");
INSERT INTO soq_vpl VALUES ("EC12_2","022_12_2","ECC","12","2","2","Mida e dewaena insena ipawa ando omo, uaboa ita kipora dubantopuo mai sala ewaadewaitaa, ita unu wapia baiwa giou dubaleidia mai punwapie dialepi, dia. ");
INSERT INTO soq_vpl VALUES ("EC12_3","022_12_3","ECC","12","3","3","Mida e dewaena insena e witaa tauma mukamukaua wineie oniaeia ando oauarantopue uwauwantopu, ita waa tauma mukamukaua wineia ando oauarantopu. Mida e dewaena insena ando e moaa nepa nonosintopuo nana mai naadewaitaa, ita e emaa sala mai ewepidewalepi. ");
INSERT INTO soq_vpl VALUES ("EC12_4","022_12_4","ECC","12","4","4","Mida e dewaena insena ando asia potalepio aia mai etadewaitaa, e nana laulantompa ba sino epompa moinawa mai etaa. Tane nene aiawa e wadamesaepi. ");
INSERT INTO soq_vpl VALUES ("EC12_5","022_12_5","ECC","12","5","5","Mida e dewaena insena ando e sala awoia awa inguguraitone saitona kadi donsaa sawa, ita e uwaa lagunalepie sapa wapi, e kapoi rua mamoo teteite aitaa, ita e eba mai aitaa rua, dia. Ita nitu daitada nuaeubu manawo dialepi. Mida e dewaena insena ando apana uduudu bontompe bubua bolawe antompa, ita apana into ke wampe leumpa. ");
INSERT INTO soq_vpl VALUES ("EC12_6","022_12_6","ECC","12","6","6","Mida e dewaena insena ando ia kampa idia, ipituwapi ita isana obasalepi do ando sala pola wadia obasalepi, ita ando nene mabupa imba empio rowolepie alepi. ");
INSERT INTO soq_vpl VALUES ("EC12_7","022_12_7","ECC","12","7","7","No bontato etemba leulepie dogo popokauwa wanalepi, ita aleumba leulepie God mida dewasana mampe alepi. ");
INSERT INTO soq_vpl VALUES ("EC12_8","022_12_8","ECC","12","8","8","Sa baiwa Waeuwa Apanawa wadiase, “Nitu uduudu ipa diapanau, diapanauida ipusiawaia.” ");
INSERT INTO soq_vpl VALUES ("EC12_9","022_12_9","ECC","12","9","9","Waeuwa Apanawa insadewasala ita me apana aten umanawa waeuwamodie. Me aten waeuwa tontawa deaitopa insadewasamodie ita ulaipa mampe empuempumodie intaweintawe girumamodio wineie. ");
INSERT INTO soq_vpl VALUES ("EC12_10","022_12_10","ECC","12","10","10","Waeuwa Apanawa aia dainea dodomana mampelepio girumamopia ita rua dima girumamona ipa ulaipa. ");
INSERT INTO soq_vpl VALUES ("EC12_11","022_12_11","ECC","12","11","11","Insadewasala apanawa waeuwa ipa gamo onioniala koinawa moamoaua wadedie sipsipwa bodamodio adewantoia rua. Me aiawa ipa tutu moamoaua ia bedewe epeio aidaleidia rua. Aia sa ipa God me mida no uduudu onianedia mampee wisen. ");
INSERT INTO soq_vpl VALUES ("EC12_12","022_12_12","ECC","12","12","12","Ne otona, ewadewaitaa. Waeuwa ema wadaadoe wanempa. Buka girumawa dewawa ando mai dialepi ita kainokaino insaisawaitone girumawaitone etea dabualepi. ");
INSERT INTO soq_vpl VALUES ("EC12_13","022_12_13","ECC","12","13","13","Dewa ema uduudu bedeuwo dewa dea os ipa debamawaida wape dieepa, sa ipa e God sawaitone ita aiawa ruawaitona. Ipawa ema baiwa God apana tawo ema osowe dewanene teaneno wainitana. ");
INSERT INTO soq_vpl VALUES ("EC12_14","022_12_14","ECC","12","14","14","God dewa uduudu werego euda ba kadiwa dewasaitana ruawalepie kotunepi. ");
INSERT INTO soq_vpl VALUES ("IS2_1","024_2_1","ISA","2","1","1","Iawe God ando Iuda ita Ierusalem mampo dima dewasapia umanawa Aisaia Eimos otopa benemasadio atenleide. ");
INSERT INTO soq_vpl VALUES ("IS2_2","024_2_2","ISA","2","2","2","Walama iedia wisepio wadi dainea osowe, Iawe God duwa enedia uduudu onapoidolepie enakasalepi, wadi sa ionoidolepie isiwa nanaumopi. Tawo uduudu apanawa esa rua memepuaubepue me wawa bumpe auwepu. ");
INSERT INTO soq_vpl VALUES ("IS2_3","024_2_3","ISA","2","3","3","Ita apana sa wapue wapuase, “Winleno odate antata Iawe God wadiwa osowe Israelwa Godiu duwa enediawo. Sape me dima menasadia no waeuwanepio dewasante wainenta. Me no waeuwanepio intawa asiasi antonta. Iawe God wadiwa Saion osowee me anaanawa nosepie alepi, ita me aiawa Ierusalemwae nosepie alepio apanawa etapu. ");
INSERT INTO soq_vpl VALUES ("IS2_4","024_2_4","ISA","2","4","4","Me bola daitada apanawa empuempuntoie waimoia kotumopio dodomanantopue wampudewantopu. Mo onau puraiwawa dewamopuo irai dipawa segantopu, ita mo eu epadodomanamopuo isima segantopu iraibu simbiamompa baiwa. Ita bola daitada onau apanawa mai osowe onau puraiwawa otamopue onantopu. Mo mai ona baiwa imaantopu, diaida. ");
INSERT INTO soq_vpl VALUES ("IS2_5","024_2_5","ISA","2","5","5","Iakob nosinosiwa, winleno Iawe God sapawa bedewainta antonta.” ");
INSERT INTO soq_vpl VALUES ("IS5_1","024_5_1","ISA","5","1","1","Me mida ne nuawadawadasadina sasawa wapa, me wainiwa irailena sasawa wapa: Ne nuawadawada sona wainiwa iraiwa wadi sainape dogo eudida osowe ain. ");
INSERT INTO soq_vpl VALUES ("IS5_2","024_5_2","ISA","5","2","2","Me dogo nobalene seu nambemone ita wainiwa eubuida naumba menasadia rua aimon. Ita irai sa bedewe iwulempe waimpa apewa wawa dauma iono waden, ita do wain gadawa abomawa dewasane itun. Ema aupe wain ipawa eubu daudaua banubu alen, tane me ipawa kadiu moa epaepala os ewamon. ");
INSERT INTO soq_vpl VALUES ("IS5_3","024_5_3","ISA","5","3","3","Tauma ne nuawadawada sona wane wanase, “E mida Ierusalem ita Iuda bedewe wainilana, ne ita wain aina iraiwa maininene ewanene wano etapo irai ainaa kadilen ba ne ainakadisana! ");
INSERT INTO soq_vpl VALUES ("IS5_4","024_5_4","ISA","5","4","4","Nitu dainea ne mai dewasapona baiwa iraina kadilen? Ipawa ne mai nitu da dewasapakadisapona, diaida. Ne menanena iraina bedewe ipawa eubu ewamopona, tane kadiu moa epaepala os ewamona. ");
INSERT INTO soq_vpl VALUES ("IS5_5","024_5_5","ISA","5","5","5","Sa baiwa ne wain aina iraiwa mampe ambi dewasapaa insaisawantedina umanawa dialepo etana: Ne me enabodawa gedara ainepanana bowiantapo ita me kadi donsapi. Ne me belawa einaa epateianteapa, ita pue dobinoa odapue ipau namopue ita irai sa ansisisapue kadisapu. ");
INSERT INTO soq_vpl VALUES ("IS5_6","024_5_6","ISA","5","6","6","Ita ne irai sa epo rokoulepi, ne mai wain sa simbiasape deunteapa ba dogowa nobanteapa, dia. Tane ne epo gedara taupibodepi, ita do unu anaanasapo mai wapie irai sa butasapi, dia.” ");
INSERT INTO soq_vpl VALUES ("IS5_7","024_5_7","ISA","5","7","7","Israel apanawa ipa Iawe God Mukamukaua wainiwa iraiwa, ita Iuda apanawa sa ipa me wainiwaida meba aina nuawa eusampaa baiwa, sa baiwa me menasana mo insadewasantoipe dewa intawe dodomana dewasaipona, tane mo kadiwa dewasane sosou epaboiamoiena. Mo dodomana dewasapona me insaisawaleidie, tane mo sosou mampo kadiwa dewasaio pokawa eteie sidantoia etedie. ");
INSERT INTO soq_vpl VALUES ("IS6_1","024_6_1","ISA","6","1","1","Ena sa deawa bedewe warere Usaia boleno ne Tatamba sapawa debama do kolaiwata osowe ionoido wandio ewana. Ita me gara taudia lalaleno duwa bedewa uduudu rupusanboden. ");
INSERT INTO soq_vpl VALUES ("IS6_2","024_6_2","ISA","6","2","2","Me tampeinta nitu wanwanlala ebou serapim mabupu 6 dolala ewaewau ia idie bumedia rua eneie, mo mabupu nata mampe nambu rupumoiena ita nata da mampe wau rupumoiena ita mabupu nata da mampe lapopontoie. ");
INSERT INTO soq_vpl VALUES ("IS6_3","024_6_3","ISA","6","3","3","Mo mukantoie muba waie waiase, “Iawe God Mukamukaua ipa kakaiwa, kakaiwa ita kakaiwaida. Me sapawa tawo uduudu sapasade.” ");
INSERT INTO soq_vpl VALUES ("IS6_4","024_6_4","ISA","6","4","4","Mo aiau moinawa du unsiawa dewamono uwauwanton ita du sa bedewa gasu nopesan. ");
INSERT INTO soq_vpl VALUES ("IS6_5","024_6_5","ISA","6","5","5","Ne ema ewane wanaase, “Akaio! Ne emanawoido warere me ipa Iawe God Mukamukaua ewana. Ne mai inanteapa rua aitamana kadiwa donsana, ipawa ne kadi do ita moana kadiwa wawala ita apana mida ne bedeuwo wainedina moau kadiwa wawala waimoi.” ");
INSERT INTO soq_vpl VALUES ("IS6_6","024_6_6","ISA","6","6","6","Ema aupe serapim bedeuwo dea lapopolene mainawo winin. Me wata osowe ia bupa iilala abina mampe abinene wadene do mainawo wisen. ");
INSERT INTO soq_vpl VALUES ("IS6_7","024_6_7","ISA","6","7","7","Me ia bupa iila sa ne moanawo itune ita wanase, “Ewee, ia bupa ema e moaa wirasan, sa ipa tauma e wawua wadenauben ita kadia insendabuasan.” ");
INSERT INTO soq_vpl VALUES ("IS6_8","024_6_8","ISA","6","8","8","Ema aupe ne etedino Tatamba wane wanase, “No gagalomba benemala apanawa dainea wataaubeto alepi apana ema mampo? Mida no baimba alepi?” Me epe wadio ne sipoasane wanaase, “Ne ema ambi! Ne waaubaneawo anteapa!” ");
INSERT INTO soq_vpl VALUES ("IS7_10","024_7_10","ISA","7","10","10","Iawe God osowe Akas mampe Aisaia bedewee gagalosane wanase, ");
INSERT INTO soq_vpl VALUES ("IS7_11","024_7_11","ISA","7","11","11","“Iawe e Goda iririsawo eueuwa da euwaepi. Me eueuwa da bolala bolauwo ba naepe iono uboo euwaepia iririwasaa.” ");
INSERT INTO soq_vpl VALUES ("IS7_12","024_7_12","ISA","7","12","12","Tane warere Akas sipoasane wanase, “Ne mai menaneipona Iawe God rubusapa baiwa mampe eueuwa baiwa iririwanteapa.” ");
INSERT INTO soq_vpl VALUES ("IS7_13","024_7_13","ISA","7","13","13","Tane Aisaia wanase, “E warere Dawid nosinosiwa asisuneanuno gagalonteapa! E God aiawa mai eteipe ruawaitipona mampe apana nuamba surakausailana mai pokaleipona baiwa, God do nuawa surakausailana, ba? ");
INSERT INTO soq_vpl VALUES ("IS7_14","024_7_14","ISA","7","14","14","E epe dewaitena baiwa Tatamba me meba eueuwa da sabamosapio ateitana. Sa ipa: I sanaa bulepie oto mona gamosapi, ita mo me ebowa itupue wapuase, Imanuel.” (Ebo ema ipawa ipa God no do). ");
INSERT INTO soq_vpl VALUES ("IS9_1","024_9_1","ISA","9","1","1","Walama sawo apana mai poka eteia do wankasantopu. Sebulun ita Napitali bedewe wanwalala apana ituaisimoio nuaparentoie waimoia, walama iedia wisepio uwa daitada apanawa Galili ita Mediterenian Owawa tampe ita Ioadan esawa nosena sawano inta debama nowa oso waimoia ebou debamalepi. ");
INSERT INTO soq_vpl VALUES ("IS9_2","024_9_2","ISA","9","2","2","Apana mida dubawa bedewe waimoia, sapa debamaia ewei. Ita mida bolala rua waimoia osouwo sapa wade. ");
INSERT INTO soq_vpl VALUES ("IS9_3","024_9_3","ISA","9","3","3","Iawe God e mo dewamoano uarantone nuaeuntoi, e mo dewamoano nuaeuntoi. E dima mo mampo dewasaana baiwa nuaeuwantoi. Mo nuaeuwau sa ipa maura debama uwauwantoie nuaeuwantoia rua, ba sorodia antoie emalawoau apanawa aimoie aupe nitubu oteie nuaeuwantoia rua. ");
INSERT INTO soq_vpl VALUES ("IS9_6","024_9_6","ISA","9","6","6","Oto no mainimbo mulen, Iawe God oto mona amonalene no nenen. Me muka wadepie mukamukaua no onianepi ita apana me ebowa wampe wampase, “Me ebowa ipa Wadewasa Apanawa Eudida, God Mukamukaua, Wanwankasalala Mamba, Warere Wanwan Euda Obasa Wadepie Wisepi. ");
INSERT INTO soq_vpl VALUES ("IS9_7","024_9_7","ISA","9","7","7","Me onionia mukawa ita wanwan euda wadene wisena debamalepie winakasalempa. Me warere Dawid aupawa wadepie wampie gonaawa oniepi. Me dodomana mampe ita do ulaipa mampe apana oniamompaa bedewe me gonaawa badowa enakasalepi. Iawe God Mukamukaua, me ando epe dewasapio segalepia rua, ipawa me apanawa nuawadawadaidamode.” ");
INSERT INTO soq_vpl VALUES ("IS11_1","024_11_1","ISA","11","1","1","Iese nosinosiwa bedeuwo, warere dea sanaa, ia iwa osowe seupa inileidia rua wisepi. ");
INSERT INTO soq_vpl VALUES ("IS11_2","024_11_2","ISA","11","2","2","Iawe God aleupa ipa me do, aleu sa me insadewasa ita aten wanepio apanawa oniadewasamopi, aleu sa me banlempo dima me insedia intawa dodomana asiasi wampie dewasampe apanawa banladewasamompa, ita aleu sa me dewasapio God atensampe wiwirawalempa. ");
INSERT INTO soq_vpl VALUES ("IS11_3","024_11_3","ISA","11","3","3","Ita me Iawe God aiawa ruawalempaa mampe nuaeulempa, Me mai emawa ba asiwa etedia asiasi apana kotumopi, dia. ");
INSERT INTO soq_vpl VALUES ("IS11_4","024_11_4","ISA","11","4","4","Me apana nuaparelala ulaipa ita dodomana mampe kotumopi, mo mida oauarau ita mukausiawaia saumopie dodomanamopi. Me aiawa ipa koina badowa rua tawo epompa, ita me aiawa sa apana kadi dewalala epaboiamopi. ");
INSERT INTO soq_vpl VALUES ("IS11_5","024_11_5","ISA","11","5","5","Dewa dodomana ipa iga rua me nowe taupi, ita euda wadepiitue dewakasalempaa dewawa gara nouwo tauia rua nowe taupi. ");
INSERT INTO soq_vpl VALUES ("IS11_6","024_11_6","ISA","11","6","6","Walama sawo pue dobinoa ita manasau duwa wanwanlala awodeatopue euda os waimompa, sa ipa elo onawau sipsip bunau do awodea waimompa, pue ebowa leopat ita gote bunau do awodea ituntompa, ita laion kau bunawa do awodea nana nampa ita seda kerakera pue sa oniamompa. ");
INSERT INTO soq_vpl VALUES ("IS11_7","024_11_7","ISA","11","7","7","Kau ita bea awodea nana nampa, ita mo obampu gegelau awodea euda os ituntompa. Ita laion kau ruau ina nampa. ");
INSERT INTO soq_vpl VALUES ("IS11_8","024_11_8","ISA","11","8","8","Seda gegelau mota onawaau nagau moapo owantompa, seda kerakera mota onawaau dubu bedewe witapu noanempa. ");
INSERT INTO soq_vpl VALUES ("IS11_9","024_11_9","ISA","11","9","9","Ne wadina kakaiwa osowe mo mai muba onantopue kadikadintopu, ipawa mo mida Iawe God atensapua apanawa bola sa nopesapu, esa owa nopesadia rua. ");
INSERT INTO soq_vpl VALUES ("IS11_10","024_11_10","ISA","11","10","10","Walama sawo warere sanaa Iese nosinosiwa bedeuwoe wisepia, me ipa eueuwa uwa daitada apanawa tawo osowe waimoia baibu. Ita apana uduudu me atensapua baiwa mampe antopu, ita me bubuawa bolawa bedewe sapa ita ebo debama winakasalepi. ");
INSERT INTO soq_vpl VALUES ("IS35_1","024_35_1","ISA","35","1","1","Sala makowa bedewe mai dima da euda wineipona, tane ando nuaeulepi, ita sala makowa sa bedewe beran kelontopu. ");
INSERT INTO soq_vpl VALUES ("IS35_2","024_35_2","ISA","35","2","2","Beran ita ina daitada inintopue bola sa nopesapu, ita bola sa nuaeulepie nuaeu kawa debama wapi. Bola sa ando ewaewa eudida uwatauwa segalepi Lebanon wadiwa eubu eneia ruau, ita me inainamba eudewadewaleidie winedia ewaewa sala apuapua Kamel ita Saron bedeuwo ina daitada inintoie wineia ruau. Sape Iawe God inainamba eudida sabamosapio, apana uduudu no Godimba me mukawa ita sapawa debamaia ewapu. ");
INSERT INTO soq_vpl VALUES ("IS35_3","024_35_3","ISA","35","3","3","Witala aiaisintona ita iminla oauarantona badomona; ");
INSERT INTO soq_vpl VALUES ("IS35_4","024_35_4","ISA","35","4","4","Apana mida santoia diamoe waase, “Badowa enana ita mai saitana! Ewanee, e Godila iede me emalawoa apanawa matangelamopie kadimopi, me wisepie mo matangelamopie ita e inalepi.” ");
INSERT INTO soq_vpl VALUES ("IS35_5","024_35_5","ISA","35","5","5","Me wisepie apana emau potantona eumopio sala ewapu, ita mo asiu potantona eumopio gagalo etapu. ");
INSERT INTO soq_vpl VALUES ("IS35_6","024_35_6","ISA","35","6","6","Apana tampu bobopu inantopue rowontopue biantopu, ita moau potawa wadaaubamopio nuaeu kawa wapu. Maneu dogo bedewe naimepie wisepie sala makowa bedewainta alepi. ");
INSERT INTO soq_vpl VALUES ("IS35_7","024_35_7","ISA","35","7","7","Siata polapolaua apu itune winedia leulepitue doa segalepi, ita dogo makowa bedewe maneu wimopu. Ita pue dobinoa bubuau bolawa topa segalepi, ita topa bedewe ina daitada sape inintopu. ");
INSERT INTO soq_vpl VALUES ("IS35_8","024_35_8","ISA","35","8","8","Ita inta debama ebowa “Inta Kakaiwa” bola sa sawanainta nosepie alepi, ita apana kadi dewalala inta sa asiasi mai antopu, dia. Inta sa ipa God apanawa os baibu, insakadisalala mai inta sa asiasi antopu, dia. ");
INSERT INTO soq_vpl VALUES ("IS35_9","024_35_9","ISA","35","9","9","Pue laion ita pue onawau dobinoa mai inta sa nowa oso wimopu, dia, tane apana mida Iawe God inamona mo os inta sa asiasi antompa. ");
INSERT INTO soq_vpl VALUES ("IS35_10","024_35_10","ISA","35","10","10","Mo leuntopue Ierusalemwa antompe nuaeu sasawa wampe antompa. Nuaeu winakasala ipa uwa benawa rua uwauwo ampu, mo nuaeu debamaia nopeidomopi, nuaparepare ita momodu diaidalepi. ");
INSERT INTO soq_vpl VALUES ("IS40_1","024_40_1","ISA","40","1","1","E Godila wadiase, “Wasau gagalowa wae apanana diamoa, wasau gagalowa wae diamoa. ");
INSERT INTO soq_vpl VALUES ("IS40_2","024_40_2","ISA","40","2","2","E nuaa aiaisiwa obasa mampe gagaloite ne apanana Ierusalem bedewe waimoia diamoe waase, ‘E poka etale surakautena walamawa tauma dialen, ita do Iawe God e kadila insadabuamon, e kadila uduudu matangelawa ne ruantene manlawo dewasanatuwan.” ");
INSERT INTO soq_vpl VALUES ("IS40_3","024_40_3","ISA","40","3","3","Asisuitana! Apana dea mukama benemaleidie wadi wadiase, “Sala makowa bedewe Iawe God wimpia baiwa inta eusana, dewa uduudu inta enabodamodia otawiaitane nambemona. ");
INSERT INTO soq_vpl VALUES ("IS40_4","024_40_4","ISA","40","4","4","Doba nuau dobosamono euntopu, ita wadi kerakera ita debamau ieie odeia toaisimono apuapuntopue winadewasantopu inta kiokiou iaodala deaitopamono inta euda segantopu. Ita inta bagorauia wineia deaitopamono eudidantopu. ");
INSERT INTO soq_vpl VALUES ("IS40_5","024_40_5","ISA","40","5","5","Tauma Iawe God sapawa sabamolepie wisepi, ita apana uduudu tawo osowe sapa sa ewata. Iawe God me meba moawe gagalo ema wan.” ");
INSERT INTO soq_vpl VALUES ("IS40_9","024_40_9","ISA","40","9","9","Saion, e Gagalo euda benemaitaa baiwa wade ieiana odee, aita wadi iwa ionoidolena osowe. Ierusalem, e Gagalo euda wade ieiana ka wae gagaloitaa, ka waa mai saitaa; Iuda bolawa debamau bedeuwo apana waimoia mampo gagaloite waase, “Ewane! E Godila ema ambi!” ");
INSERT INTO soq_vpl VALUES ("IS40_10","024_40_10","ISA","40","10","10","Ulaipa, Warere Iawe God wisepie mukawa debama mampe apanawa oniamopi. Me unewa otamone do iedia ewana, sa ipa me apanawa inamona. ");
INSERT INTO soq_vpl VALUES ("IS40_11","024_40_11","ISA","40","11","11","Me apanawa oniadewasamopi, gamo onionia puewa oniamodia rua. Me sipsipwa bunau otamopie, mabupa osowe teamopie mampemopi. Ita sipsip iwoa obampu do deaitopa banladewasamopi. ");
INSERT INTO soq_vpl VALUES ("IS42_1","024_42_1","ISA","42","1","1","Iawe God wadiase, “Ewana, apana ema ipa ne nolana dewalala, ne me muka wanedina, ne me sonabena ita ne nuana eudidalen me mampe. Ne aleuna mampe me nopesana, ita me apana uduudu mampo kotuwa dodomana dewasampa ita mo banlamopio God mukawa atowentopu. ");
INSERT INTO soq_vpl VALUES ("IS42_2","024_42_2","ISA","42","2","2","Me mai bola bedewainta apana mampo aiawa badowa ba mukama gagalolepi, dia. ");
INSERT INTO soq_vpl VALUES ("IS42_3","024_42_3","ISA","42","3","3","Me auni asiwa tewapia baiwaleidia mai ampipundepi, ita siwa keraudida idia mai supibolepi, dia. Me kotuwa dodomana dewasapi apana uduudu mampo. ");
INSERT INTO soq_vpl VALUES ("IS42_4","024_42_4","ISA","42","4","4","Me mai nuawa oaoaralepio nolawa epi, me nolalempo ideita tawo osowe apana uduudu dewa dodomana dewasampaa dewawa winepidewalepi. Apana nowa dauwo wanwanlala me waeuwa etapua onioniawantoie waimoi. ");
INSERT INTO soq_vpl VALUES ("IS42_6","024_42_6","ISA","42","6","6","Ne Iawe God neba dodomanana bedewe apaena, ne e witaa wadape ita muka enepe oniadewasaepa, ne e dewaepo saua badowa rua segaita apana mampo, ita e bedeawoe mo ne sauna euda wadapu ita e ipa sapa uwa daitada apanawa baibu. ");
INSERT INTO soq_vpl VALUES ("IS42_7","024_42_7","ISA","42","7","7","E apana emau potawa wadaubaitawo sala ewapu, ita diburalala dibura bedewe wadaubamoa, ita mo mida diburantone dubawa bedewe waimoia wadaubamowo inantopu!” ");
INSERT INTO soq_vpl VALUES ("IS49_3","024_49_3","ISA","49","3","3","Iawe God ne mainawo wane wanase, “Israel, e ipa ne nolana dewalala, e asiasi wadapos uduudu ne mainawolepi.” ");
INSERT INTO soq_vpl VALUES ("IS49_5","024_49_5","ISA","49","5","5","Iawe God ne dewanene inana bupa bedewe itunene, sonabanena me nolawa dewalala seganteapa. Me epe dewasana me apanawa otamopie leumopio me mampentopua baiwa, Israel apanawa meba wawa bumpe awodeamopia baiwa; Iawe God ne ituposinene ebona debamasan, ne Godna muka nen. ");
INSERT INTO soq_vpl VALUES ("IS49_6","024_49_6","ISA","49","6","6","Iawe God wadiase, “E ne nolana dewalala, e nolaa eneena Iakob nosinosiwa dewamowo ebou debamalepi, ita do mida antone bola daitada bedewe inawaa waimoia leumowo bolawo wimopu, tane mai sa os. Ne sonabaena uwa daitada apanawa sapau segaitaa, ita e inaida gagalowa wade aite tawo moawa daitadawo benemaitawo etapue atentopu.” ");
INSERT INTO soq_vpl VALUES ("IS49_14","024_49_14","ISA","49","14","14","Ita Ierusalem apanawa waienase, “Iawe God no dabuanene enen, me no nuaawawaidanene enen.” ");
INSERT INTO soq_vpl VALUES ("IS49_15","024_49_15","ISA","49","15","15","Iawe God mo sipoamone wanase, “I otopa amamasadia nuaawawasapie, ita otopa gamosana mai nuaparewalepi ba? Naita oto inawa me nuaawawasapie epi, tane ne mai e nuaawawalepe elepa, diaida.” ");
INSERT INTO soq_vpl VALUES ("IS50_4","024_50_4","ISA","50","4","4","Warere Iawe God ne waeuwanen ambi gagalonteape, apana insaisau oauarau wasaumopa baiwa. Tadinaida uduudu me wadamesanedie asina wadediaubede, apana waeuwa atowe wandia dewawa rua me dima waeuwanedia etape atenteapa baiwa. ");
INSERT INTO soq_vpl VALUES ("IS50_5","024_50_5","ISA","50","5","5","Warere Iawe God ne mainawo sabamo gagaloleno etane atenten, ita ne me aiawa mai dabuasape epona, ne mai me adiananasapona, dia. ");
INSERT INTO soq_vpl VALUES ("IS50_6","024_50_6","ISA","50","6","6","Ne adina wanamono epeiena, ita sainana wanamono korona bowiantoiena. Ne naina mai weregasapona, tane sabamosano wasineane seseineiena. ");
INSERT INTO soq_vpl VALUES ("IS50_7","024_50_7","ISA","50","7","7","Tane Warere Iawe God ne saunen, ema baiwa ne mai ituaisiidanteapona. Sa baiwa ne insaisana badosadina, ne insene atenten ando mai malanteapa. ");
INSERT INTO soq_vpl VALUES ("IS50_8","024_50_8","ISA","50","8","8","God ipa ne tainawoido, ita me ne mai wawuna da donsapona wasabamoa wade. Winleno ane kotu bolawa osowe kotuntata, mida ne wawuna donsana umanawa wade? Me mainawoido wimpie wapidewalepio etapa. ");
INSERT INTO soq_vpl VALUES ("IS50_9","024_50_9","ISA","50","9","9","Warere Iawe God ne saunede, tauma mida ne kadina ewena wawuwa dianepi? Ne wakadisana waia apanawa kadi donsapu, gara tontawa lalaa adapuiasaio kadileidia rua. ");
INSERT INTO soq_vpl VALUES ("IS52_7","024_52_7","ISA","52","7","7","Apana Gagalo euda wadane wadiwainta ieia wau aupawa ewaewau eudida no mainimbo, ipawa mo wanwan euda obasa gagalowa wadane iei. Me God apanawa, inamona umanawa benemaleidie bola debama Saion apanawa diamodie wadiase, “E Godila warereleidie wande!” ");
INSERT INTO soq_vpl VALUES ("IS52_8","024_52_8","ISA","52","8","8","Asisuitana, apana mida e bolala debama onieie gonaantoia nuaeu kawa waia etamona, mo emawoido Iawe God leulene bola debama Saionwa wisena, ewane nuaeuwantoie wai. ");
INSERT INTO soq_vpl VALUES ("IS52_9","024_52_9","ISA","52","9","9","E Ierusalem bedewe poka donsaile wainilana, awodeaitane nuaeu kawa wana, Iawe God apanawa mampolene oniamone saumode, me bolawa debama gonaaleide. ");
INSERT INTO soq_vpl VALUES ("IS52_10","024_52_10","ISA","52","10","10","Me mukawa debama kakaiwa sabamosade, apana uduudu tawo osowe waimoia mampo. Ita apana uduudu tawo osowe wanwanlala, no Godimba apana kadi bedewe otaubamodie inamodia ewapu. ");
INSERT INTO soq_vpl VALUES ("IS52_13","024_52_13","ISA","52","13","13","Ewane, ne nolana dewalala nolawa dewasapidewae diasapi, ne me itupaposidepio uduudu onapolepie, ita ebowa debama wadepi. ");
INSERT INTO soq_vpl VALUES ("IS52_14","024_52_14","ISA","52","14","14","Apana uara me ewane memesaidantone nuau rowolen, ipawa mo me epeieno inainamba rebarebaidalene koakoalen, mai apana inainamba rua. ");
INSERT INTO soq_vpl VALUES ("IS52_15","024_52_15","ISA","52","15","15","Ita tauma uwa daitada apanawa uara me ewapue asosapu, ita warere uduudu memesantopue mai aiau da wapu, diaida. Ipawa dima umanawa mo mai etapona segalepio ewapu, mai mida ema umanawa diamopono etape atentopona atentopu. ");
INSERT INTO soq_vpl VALUES ("IS53_1","024_53_1","ISA","53","1","1","Aisaia wane wanase, “Iawe God, mida no gagalomba amonantitana sumanaiwantoie waimoi? E mida mampo mukaa sabamosaana?” ");
INSERT INTO soq_vpl VALUES ("IS53_2","024_53_2","ISA","53","2","2","Iawe God nolawa dewalala nitu inioauaraleidia rua oauara me danawe inilen, ia wapa sala makowa bedewe winedie inileidia rua inilen. Me mai inainamba ewaewa apana pokawaa euda no nuamba teinepia baiwa, me mai euwa da no nuaunepio warorosata, dia. ");
INSERT INTO soq_vpl VALUES ("IS53_3","024_53_3","ISA","53","3","3","No me ewadabuasate nibuasatana, me ipa poka ita siga daitada etaetala apanawa, no me adiananasatana, ita mai wiwirawantepe apana eboeboua rua ituposisapona. ");
INSERT INTO soq_vpl VALUES ("IS53_4","024_53_4","ISA","53","4","4","No insetanase me poka etedia sa ipa God me matangelasade meba kadiwa baiwa. Tane sa ipa dia, no keromba ita pokamba daitada awanenauben. Me no saimba osoweleno awanen. ");
INSERT INTO soq_vpl VALUES ("IS53_5","024_53_5","ISA","53","5","5","No dewamba kadiwa baiwa me eneiena, no dewamba kadiwa baiwa me epeiena; me poka etena bedewee no wanwan euda obasa donsatana, me epeiena kerowa bedewe no inanten. ");
INSERT INTO soq_vpl VALUES ("IS53_6","024_53_6","ISA","53","6","6","No uduudu sipsip rebaleidie inta banuleidia rua rebanten, no deadea nuba intambointambo antite; tane Iawe God no wawumba ita kadimba daitada matangelawa me osowe ituno awanene pokawa eten. ");
INSERT INTO soq_vpl VALUES ("IS53_7","024_53_7","ISA","53","7","7","Mo me dewasaieno poka rebarebaida eten, me mai aiawa da wapona, dia, tane nua aiaisiwa mampe sai sa awanen. Mo sipsip bosapua apanawa mampe banleie antoia rua banlene bosapua baiwa antoiena; sipsip bunawa imba totontoia apanawa danauwo onasia enedia rua, me onawa apanawa danauwo daina di enedie. ");
INSERT INTO soq_vpl VALUES ("IS53_8","024_53_8","ISA","53","8","8","Mo me wadanaitue antone mai dodomana asiasi kotusapona, di wadane anton ita mai mida da me adiwelepe umanawa wapona, dia. No kadiwamba baiwa me eine bosaiena. ");
INSERT INTO soq_vpl VALUES ("IS53_9","024_53_9","ISA","53","9","9","Me mai apana da kadisapona, me mai laga da wapona, tane me kadi dewalala bontone wineiawo dobontoiena, me maura apanawa domba bedewe ituiena. ");
INSERT INTO soq_vpl VALUES ("IS53_10","024_53_10","ISA","53","10","10","Mo me epaepabobosaieno poka etene nuapareidalena sa ipa Iawe God insaisawalena rua segalen; nola dewalala sa meba etepa amonalene pulo rua kadi baiwa ituna, me damba uaralepia baiwa. Me ando walama dauma wankasalepi, ita me bedewee Iawe God insaisawa ipawanalepi. ");
INSERT INTO soq_vpl VALUES ("IS53_11","024_53_11","ISA","53","11","11","Me poka etene nuaparelena ipawa ando itupio ewepie nuaeuwalepi, me ando atenlepi me mai di poka etape nuaparelepona, dia. Iawe God wadiase, “Ne nolana dewalala dodomana apana uara dewamopio dodomana segantopu, ipawa mo kadiu saiwa matangelawa awanepiaubepia mampe. ");
INSERT INTO soq_vpl VALUES ("IS53_12","024_53_12","ISA","53","12","12","Ne me dewasapo eboeboua segalepi, ita itupaposidepio apana eboeboua bedeuwolepi, ipawa me inawawa amonalene bolena baiwa, ita apana me ebowa waiena kadi dewalala apanawa da. Me kadi daitada dewalala kadiu matangelawa wadene, ita mo baibu rauparilen.” ");
INSERT INTO soq_vpl VALUES ("IS54_5","024_54_5","ISA","54","5","5","Me mida e dewaena ipa e badaa, me ebowa ipa Iawe God Mukamukaua uduudu onapolene oniamode, Israelwa Godiu kakaiwa ipa e inawala, me ebowa waia ipa tawo uduudu Godiu. ");
INSERT INTO soq_vpl VALUES ("IS54_6","024_54_6","ISA","54","6","6","E ipa i sanaa nainaila badawa edio nuapareleidie wandia rua. Tane Iawe God umanaa wapio leuite mampe winea. ");
INSERT INTO soq_vpl VALUES ("IS54_7","024_54_7","ISA","54","7","7","Iawe God mida e oniaedia ema epe wade, “Walama kampaida os baiwa ne eena, tane nuaparena debama mampe leuepo mainawo winea. ");
INSERT INTO soq_vpl VALUES ("IS54_8","024_54_8","ISA","54","8","8","Ne nuana kadileno walama kampaida bedewe ne adiananaena, tane nuawadawadana winakasala mampe ne nuaparena e manawo sabamosapa.” Iawe God me mida e kakailedie onialedia ema epe wade ");
INSERT INTO soq_vpl VALUES ("IS54_9","024_54_9","ISA","54","9","9","“Noa walamawe ne sauantena mai osowe abaia wapaaubepo tawo kadisapi, epe rua ne sauantedina mai osowe adiananaepa, ita ne mai osowe matangelaepa, dia. ");
INSERT INTO soq_vpl VALUES ("IS54_10","024_54_10","ISA","54","10","10","Naita wadi debamau ba kerakerau lawosantopue diantopu, tane ne nuawadawana mai dialepi, ita ne wanwan euda obasa eneepa sauawa wana winakasalepi,” sa ipa Iawe God mida nuaparealeidia epe wade. ");
INSERT INTO soq_vpl VALUES ("IS55_1","024_55_1","ISA","55","1","1","“E mida gadompala makoleidia, winlene esa nana, e mida manlawo mane dia, winlene nana wadane nana, winlene wain ita ama sogapa nana, mai malesawa do. ");
INSERT INTO soq_vpl VALUES ("IS55_2","024_55_2","ISA","55","2","2","E manela mai nana kadiu osouwo di diasanuna, nana dainea e nailano mai pokaleipona mai nolawaitana. Ne aiana asisusane ita nana euda nane pokalepi, nana ema euda daudaua nane nuaeuitana. ");
INSERT INTO soq_vpl VALUES ("IS55_3","024_55_3","ISA","55","3","3","Ne aiana etane mainawo winlena, ne asisuneane ita e inaida wadana, ne sauana badowa winakasala e manlawo wapa, ne e nuawadawadalepe euda manlawo dewasapa, warere Dawid mampe sauantena rua.” ");
INSERT INTO soq_vpl VALUES ("IS55_6","024_55_6","ISA","55","6","6","“E tauma Iawe God manlawolena mampe banusane donsana, tauma me tanlawolena mampe me iririsana. ");
INSERT INTO soq_vpl VALUES ("IS55_7","024_55_7","ISA","55","7","7","E kadiwa dewalala kadiwa ene leuitana, ita insaisala kadiu insamoilana emona. E leuitane Iawe God mampe aitano me e nuaparelalepie saulepi, e no Godimba mampe rauparitano kadila uduudu insadabuamopi.” ");
INSERT INTO soq_vpl VALUES ("IS55_8","024_55_8","ISA","55","8","8","Iawe God wadiase, “Ne insaisana ipa mai e insaisala rua, ne dewana ipa mai e dewala rua. ");
INSERT INTO soq_vpl VALUES ("IS55_9","024_55_9","ISA","55","9","9","Uba mai maida ionoido winedia rua, ne dewana ipa ionoidolen mai e dewala rua, ne insaisana ipa ionoidolen mai e insaisala rua. ");
INSERT INTO soq_vpl VALUES ("IS55_10","024_55_10","ISA","55","10","10","Unu ita giou obasa do uboe ieia, mai di ieipona, mo tawo butasaie bibiasaio, ina inintoi, ita apana iraintoie nana nai. ");
INSERT INTO soq_vpl VALUES ("IS55_11","024_55_11","ISA","55","11","11","Epe rua ne aiana mai di leulepie mainawo wisepi, tane ne dima menanedia nolawa dewasapio segalepi. Me dima uduudu ne menanena dewasapituwapi, ita insaisana uduudu dewasapie diasapituwapi.” ");
INSERT INTO soq_vpl VALUES ("IS56_1","024_56_1","ISA","56","1","1","Iawe God wadiase, “Ne walama kerauda os bedewe wineape inalepa. Ne dewana dodomana apana uduudu mampo sabamosapo ewapu, sa baiwa e ulaipa ita dodomana mampe apana mampo dewasanuna. ");
INSERT INTO soq_vpl VALUES ("IS56_6","024_56_6","ISA","56","6","6","Ando bola da apanau inawau amonantopue ne Iawe God mainawo wimopue, ita dima ne menanedia rua dewasapu, mo ne nuawadawadaneapue wadaposineapu, ne bubuana walamawa mo wiwirawantopu, mo ne sauana badowa wanaa wadapuitudepi. ");
INSERT INTO soq_vpl VALUES ("IS56_7","024_56_7","ISA","56","7","7","Bola da apanawa sa ne otamope wadina kakaiwa osowe teamopa, ita ne rauparina duwa bedewe nuaeuna wanamopa. Mo amonau susula ita amonau isiwa ne watana osowe teamompa ne nuaeubuntepine mainawomopina, apana uduudu ne duna kakaiwa ebowa wapue wapuase, uwa daitada apanawa rauparintompa duwa.” ");
INSERT INTO soq_vpl VALUES ("IS58_7","024_58_7","ISA","58","7","7","“Mo mida omana tomodia nanala moawa wanamono napu, ita apana mida bolau dia bola wanamono wampu, mo mida gara abolawantoia garala wanamona, do osina sosolaida mai adiananamona. ");
INSERT INTO soq_vpl VALUES ("IS58_8","024_58_8","ISA","58","8","8","E epe dewaitano ne sapana omo sanaa wisedie sapa wadia rua e osolawo sapa wapi, e kerola inantopua walamawa maidaleide, ne bautanteape e intala dodomanasapa, ne adilawo enape mukana debama mampe oniadewasalepa. ");
INSERT INTO soq_vpl VALUES ("IS58_9","024_58_9","ISA","58","9","9","Ita e ne mainawo rauparitano etalepe sipoasapa, ita e sau baiwa apaitonuno ne etalepe wapaase, ‘Ne ema!’ E mai apana osouwo sai itununa, ita mai wakadisamonuna ba lagau wana, dia. ");
INSERT INTO soq_vpl VALUES ("IS58_10","024_58_10","ISA","58","10","10","Apana omana totopu mukala uduudu mampe saumonuna, ita mo mida bagorantoia mukala uduudu mampe nolaitonune saumonuna, e epe dewaitonuno e sapala dubawa bedewe sapa wapi, ita tadina uduudu e manlawo ipa walama sapawa rua winompa.” ");
INSERT INTO soq_vpl VALUES ("IS61_1","024_61_1","ISA","61","1","1","“Warere Iawe God aleupa ne osonawosan, me ne sonabanene mena osonawo memen Gagalo euda abolala mampo amonanteapo etapua baiwa, me ne waaubanea apana nuau kerola inamopaa baiwa, me ne waaubaneno winena apana tautaula dibura bedewe waimoia benemamopo dibura epue inantopu, mo mida diburantone dubawa bedewe waimoia lotoaubamopo inantopu. ");
INSERT INTO soq_vpl VALUES ("IS61_2","024_61_2","ISA","61","2","2","Me ne waaubanena apana diamope wapase, ‘Iawe God e inalepia walamawa tauma wisen, walama ema bedewe me emalawoa uduudu sipoamopie matangelamopi.’ Me ne waaubanena apana ke waie nuaparentoia nuadubumopaa baiwa. ");
INSERT INTO soq_vpl VALUES ("IS61_3","024_61_3","ISA","61","3","3","Me ne waaubanena apana Ierusalem bedewe nuapareidantoie waimoia saumopaa baiwa, mo nuaparentoie isana toie waimoia eumope ita bena uwatauwa eudida uwauwo ampa. Mo nuaeubu eueuwa mena wadapue uwau lausintopu ita ke waia epu, wadapos gagalowa mo moapo winakasalempo wampe os waimompa, ita nuapareu dialepi. Mo dewau eudidalepio badowa enapu ia eudida bonoia badowa enedie inileidia rua, ia sa eubu Iawe God meba aimona me euwawa ita mukawa apana euwamopio ewapua baiwa. ");
INSERT INTO soq_vpl VALUES ("IS61_6","024_61_6","ISA","61","6","6","Apana ando e umanala wapue wapuase, ‘E ipa Iawe God pirisiwa’ do wapuase, ‘E ipa Iawe God nolawa dewalala. E ando tawo osowe uwa daitada apanawa mampo nitu eubu otamona, ita apana sa asiasi e mauraitane asowawaitana.” ");
INSERT INTO soq_vpl VALUES ("IS61_8","024_61_8","ISA","61","8","8","“Ne dodomana dewawa dewasampaa nuawadawadasadina, poi ita dewa kadiu ne dabuaidanede. Ne apanana poka eteia baiwa uneu euda wanamopa, ne apanana mampo sauana badowa wape ita wadapaitudepio winakasalepi. ");
INSERT INTO soq_vpl VALUES ("IS61_9","024_61_9","ISA","61","9","9","Uwa daitada apanawa tawo osowe wanwanlala ne apanana ita mo nosinosiu do atenmopue ita wiwirauntopu, mo ewamopue wapuase, ‘Ulaipa, Iawe God apana ema osouwo sau euda itun!” ");
INSERT INTO soq_vpl VALUES ("IS61_10","024_61_10","ISA","61","10","10","“Iawe God nuaeuwantedina ita do ne Godna dewa euda mainawo dewasana baiwa nueuidantedina. Me ne inanen ita dewaneno dodomananten me meba rua, ina ita dewa dodomana sa ipa ne garana rua; me ne benanena ewaewawa ipa apana mida nainai baiwaleidie nainai garawa eubuida taumodia rua, me ne benanena ewaewawa i nainai baiwaleidie beran inoleidie benaleidia rua. ");
INSERT INTO soq_vpl VALUES ("IS61_11","024_61_11","ISA","61","11","11","Dogo bedewe nitu daitada inintoie wimoia rua, irai bedewe lawuru daitada inintopue wimopu, Epe rua deawaa, Warere Iawe God apana uduudu tawo osowe wanwanla dewamopio me wadaposisapu, me dewawa dodomana tawo uduudu apanawa mampo sabamosapi.” ");
INSERT INTO soq_vpl VALUES ("IS64_4","024_64_4","ISA","64","4","4","Mapoido mai mida da God da e ruaa umanawa etapona, mai mida da God da e ruaa ewapona; e apana mida sumanaiantoie waimoia saumoiana. ");
INSERT INTO soq_vpl VALUES ("IS64_5","024_64_5","ISA","64","5","5","Apana mida nuaeu mampe dewa eubu dewamoie, ita e intaa dodomana asiasi antoia e saumoiana. Tane e nuaa kadilen no mainimbo, ipawa no walama daumawa kadiwa dewakasanten. Apana inainanimba epe ambi e inanea? ");
INSERT INTO soq_vpl VALUES ("IS64_6","024_64_6","ISA","64","6","6","No dewamba kadiwa sa dewaneno e emaawo miramiraidanten, no dewamba eubu rubumoite dewamoitana e emaawo ewaewa ipa gara kepawa miramiraua rua. No tonaidanten ia asiwa tonantoia rua, ita lanunu ia asiwa uwakokomodio nomoia rua, no dewamba kadiu awananene alene kadiidanen. ");
INSERT INTO soq_vpl VALUES ("IS64_7","024_64_7","ISA","64","7","7","Tane mai mida e manawo rauparileipona, ba sau baiwa e manawo ieipe waitaraeipona, dia, no kadimba baiwa e adianananee eneana, e no eneano nuba kadimba kadiidanen. ");
INSERT INTO soq_vpl VALUES ("IS64_8","024_64_8","ISA","64","8","8","Tane Iawe God e ipa no mamamba, no ipa onta rua ita e eba ipa onta dewalala rua, e witaa mampe no dewaneana. ");
INSERT INTO soq_vpl VALUES ("IS64_9","024_64_9","ISA","64","9","9","Mai nua kadilempa no mainimbo, no kadiwamba mai nuaawo ituwo winompo insene os wanempa, no uduudu ipa e apanaa, sa baiwa nuaparembaite leuite ewanea. ");
INSERT INTO soq_vpl VALUES ("JR1_4","025_1_4","JER","1","4","4","Ema ipa Iawe God gagalowa ne mainawo wade, ");
INSERT INTO soq_vpl VALUES ("JR1_5","025_1_5","JER","1","5","5","“Ne mai e inaa bupa bedewe dewaepona walamawe atenepona dia, ne bauta e atenena, e mai muitapona walamawe ne bauta e sonabaena, ne e sonabaene awowaena perowetana segaite uwa daitada apanawa mampo gagaloitona baiwa.” ");
INSERT INTO soq_vpl VALUES ("JR1_6","025_1_6","JER","1","6","6","Ne epe etane wanaase, “Aio, Warere Iawe God, ne oto sanaa ita do mai gagalo atenteapona!” ");
INSERT INTO soq_vpl VALUES ("JR1_7","025_1_7","JER","1","7","7","Iawe God ne sipoanene wanase, “E mai waase, ‘Ne oto sanaa!’ E ideita bola daineawo waaubaepa rua aitaa ita ne aia moaawo itupo waa. ");
INSERT INTO soq_vpl VALUES ("JR1_8","025_1_8","JER","1","8","8","Ne ipa e do ita oniaepa, sa baiwa apana sa mai sauitaa, dia.” Iawe God epe wane ne dianen. ");
INSERT INTO soq_vpl VALUES ("JR1_9","025_1_9","JER","1","9","9","Ita Iawe God witapa aubene ne moana wadene dianene wanase, “Ne aiana e moawo itudina! ");
INSERT INTO soq_vpl VALUES ("JR1_10","025_1_10","JER","1","10","10","Ande ne e sonabaene muka eneedina uwa daitada apanawa warereu do mampo gagaloitaa. Mo isiwa e boaubamoa ita isiwa ampuiamoa, isiwa e tokokomoe ita kadimoa ita mo isiwa e wadamowo enapu ita isiwa ammowo inintopu.” ");
INSERT INTO soq_vpl VALUES ("JR1_17","025_1_17","JER","1","17","17","Iawe God ne dianene wanase, “E imaitaa! Enawie gagalo uduudu ne dieepo rua wae diamoa. E mai mo sauitaa, naita e mo sauitaa ne e dewaepo saidaitaa mo mampo! ");
INSERT INTO soq_vpl VALUES ("JR1_18","025_1_18","JER","1","18","18","Ande ne e dewaeno mukamukaua segaiten, bola debama gonaawa debama dauma enedia rua, ita unsia ba bela badowa irama mampe dewalala rua segaiten. E apana uduudu Iuda tawowa bedewe waimoia gagaloa mampe amboitumona, sa ipa warere, uwaula apanawa, pirisi ita apana uduudu mampo epe dewasaa. ");
INSERT INTO soq_vpl VALUES ("JR1_19","025_1_19","JER","1","19","19","Mo e onaa enapu, tane mai kasawogantopue nanauepua rua, dia, ipawa ne ipa e do ita oniaepa.” Iawe God epe wane ne dianen. ");
INSERT INTO soq_vpl VALUES ("JR6_13","025_6_13","JER","6","13","13","“Ne apanana eboeboua ita ebousiawaia anaanata dewawa dewasai, mo apana lagamoie mampo mane wadei. Peroweta ita pirisi laga deawaa dewasai. ");
INSERT INTO soq_vpl VALUES ("JR6_14","025_6_14","JER","6","14","14","Ne apanana mampo bene debama winedia peroweta ita pirisi bene sa inasapona, tane mo dewasaia ewaewa bene keraudida mauakewapia rua eweie ei. Mo waiase, ‘Dewa uduudu ipa euda os winede.’ Tane sa dia, dewa kadiidaleidie winede.” ");
INSERT INTO soq_vpl VALUES ("JR17_5","025_17_5","JER","17","5","5","Iawe God ema epe wade, “Mo mida sumanaibu apanaida mukau bedewe ituia ne matangelamopa, mo inseiase apana os bedeuwo aten insaisawa euda winede, ita mo nuau bedewe ne Iawe God dabuaneie enei. ");
INSERT INTO soq_vpl VALUES ("JR17_6","025_17_6","JER","17","6","6","Mida epe dewantoia mo ipa ia kerakera sala makowa bedewe ini oauarantoia rua; mo sala makowa bedewe mai dima inintoipona bolawe waimompa, dogo sa ipa tonapa ita dasia bedewe mai mida da waimoipona. Apana sa mampo mai dima da euda ando segalepi, dia. ");
INSERT INTO soq_vpl VALUES ("JR17_7","025_17_7","JER","17","7","7","Tane mo mida ne Iawe God mainawo sumanaibu ituia ne sauna euda mo osouwo itupa, mo inawau amonantonaaubene ne mainawosane waimoi. ");
INSERT INTO soq_vpl VALUES ("JR17_8","025_17_8","JER","17","8","8","Mo ipa ia maneu tampe inintoia rua, ia sa waapu ieie aidantoie esa euda wadeie inintoie enei; ia sa omo polawa mai sawantoipona, ita do walama dauma unu wapie butamopia onioniawantopue enapua rua, mo asiu mai tonantopue nonosintopu, dia. Mo walama uduudu ipau naumompe winamompa. ");
INSERT INTO soq_vpl VALUES ("JR17_9","025_17_9","JER","17","9","9","Mai mida da apana nuawa atenlepituwapia rua, dia, no nuamba ipa lagawaa ita walama uduudu insakadisaleide sa ipa bene debama inalewalewala rua ita mai mida da inasapia rua. ");
INSERT INTO soq_vpl VALUES ("JR17_10","025_17_10","JER","17","10","10","Tane ne Iawe God apana nuau ewedina ateinaida, ne mo dima inseia ita menamodia deaitopa ewadewasamodine atentedina, ita mo dima dewasaia rua sipoa wanamodina, mo dima dewasaia ruaida uneu wanamodina.” ");
INSERT INTO soq_vpl VALUES ("JR20_5","025_20_5","JER","20","5","5","“Ne bola debama ema Ierusalem maurawa uduudu otamope me emalawoa apanawa wanamopa ita mo otamopue tawou Babilon bedewe antopu. Ne puraiwa malesau debamau ita do dima e nolawaitene pokaleno otamolana, do Iuda warereu nitubu uwatauwa uduudu wanamopo otamopue antopu.” ");
INSERT INTO soq_vpl VALUES ("JR20_7","025_20_7","JER","20","7","7","“O Iawe God e laganee nuana teineano, ita ne e sumanaianten. E ipa mukamukauaida, ita ne ipa oauara, sa baiwa e ne aineana. Walama uduudu apana ne wasina wai, mo inseia ne ipa apana diapana koakoa. ");
INSERT INTO soq_vpl VALUES ("JR20_8","025_20_8","JER","20","8","8","Ne apana mampo gagalontedina walamawe diamodine wadinase, ‘E emalawoala apanawa ando onala enapue kadilepu!’ Sa ipa e ne dima dianeiana rua diamodina, sa baiwa mo kainokaino ne wawuneie wakadisanei. ");
INSERT INTO soq_vpl VALUES ("JR20_9","025_20_9","JER","20","9","9","Walama isiwa ne neba wadinase, ‘Tauma ne mai osowe Iawe God gagalowa wapa, dia, me gagalowa da mai moanawo nosepi, kakai.’ Tane e aiaa bedenawo winedie, ia debama idia rua idie iidanede! Ne menanedia e aiaa anatepo bedenawo winakasalepi, tane mai epe dewasapa rua, dia. ");
INSERT INTO soq_vpl VALUES ("JR20_10","025_20_10","JER","20","10","10","Apana ne etamodino kutunneie ebona sainapesaie waiase, ‘Apana Saidaleidie Wande.’ Mo ne dianeie waiase, ‘E epe gagaloitiana baiwa no uwambantoia apanawa diamoto etapu.’ Ne sosonaida do kadiwa da dewasapo ewapua baiwa iwuneie waimoi. Mo waiase, ‘No lagasato aia da wapikadisapio wadataitue gagalowa sipoa ituaisisate matangelasata.” ");
INSERT INTO soq_vpl VALUES ("JR20_11","025_20_11","JER","20","11","11","Tane Iawe God e ne tainawoido ona apanawa badowa rua eneiana, sa baiwa ne emalawoana uduudu nanaumopa, ita mo mai nanauneapue aineapu, dia. Mo oauarantopue ita malaidantopu, ita apana mo malau sa mai nuau awawalepi, dia. ");
INSERT INTO soq_vpl VALUES ("JR20_12","025_20_12","JER","20","12","12","O Iawe God Mukamukaua, apana dodomanau eubu e emaawo waimoia mo dewau e rubusaie eweiana, e apana insaisau ita dima menamodia deaitopa ewamoie ateitiana. Ne saina ema uduudu e manawosadina, sa baiwa ne emalawoana apanawa e matangelamowo ewapaa menanede!” ");
INSERT INTO soq_vpl VALUES ("JR20_13","025_20_13","JER","20","13","13","E sasaitane Iawe God wadaposisana! Kadi dewalala apana nuaparelala osouwo sai itui, tane Iawe God apana nuaparelala sa, mo mukau atowe waimoia otaubamodie inamode. ");
INSERT INTO soq_vpl VALUES ("JR23_1","025_23_1","JER","23","1","1","Iawe God wadiase, “Nuapare debama ne apanana uwaula apanawa mampo wisepi! Mo ipa sipsip onionia apanawa kadiwa rua sipsip kadimoie ita tanamoio bola daitada bedewe deantoi.” ");
INSERT INTO soq_vpl VALUES ("JR23_2","025_23_2","JER","23","2","2","Sa baiwa gagalo ema Iawe Israelwa Godiu sipsip onioniala uwaula mampo wade, “E ne sipsipna mai oniamopadewaitapona ita tanamoilano deaantoiena, e epe dewaitena baiwa ne matangelalepa. ");
INSERT INTO soq_vpl VALUES ("JR23_3","025_23_3","JER","23","3","3","Ne apanana tanamolano daberaratone bola daitada bedewe antoiena, tane tauma mo mida inawaa waimoia ne leumopo bolauwo wimopue waimompa. Mo otootontopue uarantopu. ");
INSERT INTO soq_vpl VALUES ("JR23_4","025_23_4","JER","23","4","4","Ne mo uwaula apanawa sanaa otamope mampomopo oniamompa ita ne apanana sa mai osowe santompa ita do mai dea da rebalepi, dia.” ");
INSERT INTO soq_vpl VALUES ("JR23_5","025_23_5","JER","23","5","5","Iawe God wadiase, “Walama iedia bedewe ne apana dea sonabepa warerelepia baiwa Dawid damba bedewe. Me ipa apana dodomana ne emanawo. Me insaisawa euda mampe apana banlamopi, ita dewawa euda dodomana os dewasampa bola uduudu Iuda ita Israel bedewe. ");
INSERT INTO soq_vpl VALUES ("JR23_6","025_23_6","JER","23","6","6","Mo me ebowa wapue wapuase, ‘Iawe God dewa dodomana no baimba dewasapi.’ Me onioniawa atowe Iuda apanawa waimompadewantompa ita Israel apanawa wanwan euda obasa bedewe waimompa.” ");
INSERT INTO soq_vpl VALUES ("JR31_7","025_31_7","JER","31","7","7","Ema ipa Iawe God gagalowa wadi wadiase, “E Israelwa baibu sasaitane nuaeuitana mo ipa eboeboua, e Israelwa nuaeuitane ka wana! Sasaitane ka wane wadapositane wanase, ‘O Iawe God, e apanaa inamoa Israelwa inawaa waimoi, mai bontopatuwapona!’ ");
INSERT INTO soq_vpl VALUES ("JR31_8","025_31_8","JER","31","8","8","Ne apanana bola wita sen deneuwe antone waimoia banlamopo leuntopue wimopu, ita do bola isiwa nowa dauwoido winamoia bedewe antone waimoia leuntopue wimopu. Mo emau potawa ita tampu aiaisiwa leuntopue wimopu, ioto bulala ita da gamo baiwantoia, sa ipa apana uaraia leuntopue wimopu. ");
INSERT INTO soq_vpl VALUES ("JR31_9","025_31_9","JER","31","9","9","Ne banlamopo leuntopue iompe, ke wampe ita rauparintompa. Ne mo banlamopo esa maneuleida tampe wimopue antompa, ita mo inta deulala asiasi adewantompa ita mai wau dima da bagorepio omepu, dia. Ne ipa Israel mamba ita Eparaim ipa ne otona tautuwa sa baiwa ne mo mampo epe dewasapaa rua.” ");
INSERT INTO soq_vpl VALUES ("JR31_31","025_31_31","JER","31","31","31","Ema ipa Iawe God gagaloleidie wadiase, “Walama iedia bedewe ne sauana badowa sanaa dewasapa Israel ita Iuda apanawa mampo. ");
INSERT INTO soq_vpl VALUES ("JR31_32","025_31_32","JER","31","32","32","Saua ema ipa mai ne mo nosinosiu mampo sauantena rua, dia. Sa ipa ne mo Isibt bedewe waimoio banlamono nomoiena. Walama sawo ne mo badau rua deaitopa oniadewasamona, tane mo ne anaanana ainapundeiena.” ");
INSERT INTO soq_vpl VALUES ("JR31_33","025_31_33","JER","31","33","33","Iawe God gagaloleidie wadiase, “Walama iedia bedewe ne sauana badowa sanaa Israel apanawa mampo dewasapa. Sa ipa ne anaanana mo insaisau ita do nuau bedewe girumanteapa. Ita ne mo Godiu wananteapa ita mo ne apanana wanantopu. ");
INSERT INTO soq_vpl VALUES ("JR31_34","025_31_34","JER","31","34","34","Walama sawo mo mida eboeboua ita ebousiawaia uduudu ne atenidaneapu. Sa baiwa mai mida me sowa ando waeuwasapie wapiase, ‘E Iawe God ateitaa.’ Ne mo nuapareuntape dewau kiokiou insepadabuasapa, ita mo kadiu ando mai insepa, dia.” Ema ipa Iawe God gagaloleide. ");
INSERT INTO soq_vpl VALUES ("JR33_14","025_33_14","JER","33","14","14","Iawe God wadiase, “Walama iedia bedewe ne dewa euda dewasapa Iuda ita Israel apanawa mampo, ne sauamona rua. ");
INSERT INTO soq_vpl VALUES ("JR33_15","025_33_15","JER","33","15","15","Ita walamawaida wisepio, ne apana dea sonabepa Dawid damba bedewe warerelepia baiwa, me ipa apana dodomana ne emanawo, me dewawa dodomana os dewasampa bola ema bedewe. ");
INSERT INTO soq_vpl VALUES ("JR33_16","025_33_16","JER","33","16","16","Me onioniawa atowe Iuda apanawa waimompadewantompa ita Ierusalem apanawa wanwan euda obasa bedewe waimompa. Mo Ierusalem ebowa wapue wapuase, “Iawe God dewa dodomana no baimba dewasapi.” ");
INSERT INTO soq_vpl VALUES ("JR38_4","025_38_4","JER","38","4","4","Walama dea apana uwaula 4 warere Sedekia mampe antone diane waienase, “Warere, no menanedia euda ipa Ierimaia ideita bolepi. Me gagalowa mampe sorodia ita apana uduudu bola ema bedewe emalawo apanawa emoieno waimoia mabupu epaaisileidie oauaramode. Me apana kadimode mai saumoipona.” ");
INSERT INTO soq_vpl VALUES ("JR38_5","025_38_5","JER","38","5","5","Ita warere mo sipoamone wanase, “Ne mai e waitulepa rua, dia. E dima inseilana rua me mampe dewasana.” ");
INSERT INTO soq_vpl VALUES ("JR38_6","025_38_6","JER","38","6","6","Sa baiwa mo Ieremaia wadanaitue antone, warere onieia apanawa waimoia bolauwo wimone don bedewe noaneiena. Don sa ipa warere otopa ebowa Malkia mebaawa. Mo Ierimaia tai mampe taune don sa topa os winedia bedewe noaneieno iene aidalen. ");
INSERT INTO soq_vpl VALUES ("LM1_1","026_1_1","LAM","1","1","1","Mapo Ierusalem bedewe apana uaraia waimoie, tane tauma mai apana da wainipona, diaida. Mapo bola sa ipa eboeboua bola uduudu bedeuwo, tane tauma obu rua nuapareidalen, mai mida da me tounasapia rua. Mapo me ipa i eboeboua rua bola isiwa me atowe waimoie, tane tauma me ipa nola dewalala iwa rua segalen. ");
INSERT INTO soq_vpl VALUES ("LM1_2","026_1_2","LAM","1","2","2","Tadino me ke wadio emawe ke aleide. Me babadawa ene antonatuwaiena, mo mai nuadubusapua rua, me sosowaida uduudu nibuasane eiena, tauma mo ipa me emalawoa apanawa waimoi. ");
INSERT INTO soq_vpl VALUES ("LM1_3","026_1_3","LAM","1","3","3","Emalawo apanawa wimone Iuda apanawa onau enane nanaumone ita otamone antoiena, ita mo dewamoieno nolau apanawa wanantoieno sai debama osouwo ituiena. Tauma mo antone apana da bedeuwo waimoi, mo mai bubua bolawa da donsapona, dia. Mo emalawoau apanawa tanamone antone otamoiena, ita mo mai sawo naepe antope inantopona rua, dia. ");
INSERT INTO soq_vpl VALUES ("LM1_4","026_1_4","LAM","1","4","4","Ierusalem intawa ke wai, ipawa mai mida da God wadaposiwa baiwa mo osouwointa wimoipe antoipona, dia. Mai mida da bola sa gonaawa moainta odepia rua, dia. Ita pirisi poka eteie nuaparentoi, ioto sanaau ke wai, ita bola debama sa apanawa uduudu pokaida etei. ");
INSERT INTO soq_vpl VALUES ("LM1_5","026_1_5","LAM","1","5","5","Mo emalawoau apanawa mukau atowentono oniamoi, ita emalawoa apanawa sa nitu uduudu mampe rua os waimoi. Ierusalem dewawa kadiwa daitada dewamona baiwa Iawe God me matangelasan. Emalawoa apanawa me obampa otamone antone nowa dauwo teamone emoiena. ");
INSERT INTO soq_vpl VALUES ("LM1_6","026_1_6","LAM","1","6","6","Mapo Ierusalem ipa eboeboua ita bola uwatauwa eudida, tane tauma me euwawa sa uduudu dialen. Me apanawa debamau pue ebowa dia ruau omana tomodio nana banuwa lai. Mo omana tomono oauarantona baiwa, mai sawo tauwadea emalawoau apanawa emopue weuwapue antopua rua, dia. ");
INSERT INTO soq_vpl VALUES ("LM1_7","026_1_7","LAM","1","7","7","Tauma Ierusalem apanawa bola daitada bedeuwo nuabola saiwa daitada do waimoie lai, mo nitubu eubu daitada bauta mampo wineia insamoie waimoi. Walama sawo mo emalawoau apanawa wimone nanaumone aimoiena, ita mai mida da mo saumopona, dia. Me emalawoa apanawa onawa enane nanausaiena, ita mo me kadi donsana ewane oiwa waiena. ");
INSERT INTO soq_vpl VALUES ("LM3_19","026_3_19","LAM","3","19","19","Neba pokana etedina ita do bolana ene winene nowa dauwo wainedine leidina insedine, poka sigasigauaida etedina. ");
INSERT INTO soq_vpl VALUES ("LM3_20","026_3_20","LAM","3","20","20","Ne pokana sa insadewasamodine, nuana enidasade. ");
INSERT INTO soq_vpl VALUES ("LM3_21","026_3_21","LAM","3","21","21","Tane insaisa dea os ne insedine, nuana sausadia ipa: ");
INSERT INTO soq_vpl VALUES ("LM3_22","026_3_22","LAM","3","22","22","Iawe God nuawadawadawa ipa winakasalala, sa baiwa me nuaparewa eueuwa no mainimbo ideita dewasade, mai eipona. ");
INSERT INTO soq_vpl VALUES ("LM3_23","026_3_23","LAM","3","23","23","Tadinaida uduudu me ideita saua wadeditue, no mainmbo euda os dewasade. ");
INSERT INTO soq_vpl VALUES ("LM3_24","026_3_24","LAM","3","24","24","Ne neba wane wanase, “Iawe God, e dea os ipa ne nebaanaida, mai dima da, sa baiwa ne e sumanaiaidantepina.” ");
INSERT INTO soq_vpl VALUES ("LM3_25","026_3_25","LAM","3","25","25","Apana mida sumanaibu Iawe God bedewe ituie me baiwaidantoia, me euda mampo dewasade. ");
INSERT INTO soq_vpl VALUES ("LM3_26","026_3_26","LAM","3","26","26","Sa baiwa euda ipa no nuamba aiaisiwa mampe me inanepia baiwa onioniawantonte wainenta, ipawa me ando no saunepie inanepi. ");
INSERT INTO soq_vpl VALUES ("LM3_27","026_3_27","LAM","3","27","27","Euda ipa no apana sanaa wainitana mampe, God aiawa ruawantonta dewawa atentata. ");
INSERT INTO soq_vpl VALUES ("LM3_28","026_3_28","LAM","3","28","28","Walama ipa God sai no osombo itumpo, no ideita daina wainenta. ");
INSERT INTO soq_vpl VALUES ("LM3_29","026_3_29","LAM","3","29","29","No me wawa bumpe dunentate nainimba dogo osowe itute onioniantonta naita me ando no saunepi. ");
INSERT INTO soq_vpl VALUES ("LM3_30","026_3_30","LAM","3","30","30","Naita apana no epanempa ba wakadisanempa, no mai leusate onau enata, dia. ");
INSERT INTO soq_vpl VALUES ("LM3_31","026_3_31","LAM","3","31","31","Ipawa Iawe God me mai apanawa dabuamoipe eidamoipona, dia. ");
INSERT INTO soq_vpl VALUES ("LM3_32","026_3_32","LAM","3","32","32","Walama isiwa me poka edio no mainimbo wisede, tane do me nuaparembaleidie saunede. Ipawa me nuawadawadawa debama no bainimba winakasala winede. ");
INSERT INTO soq_vpl VALUES ("LM3_33","026_3_33","LAM","3","33","33","Ulaipa walama isiwa poka ita nuapare edio apana mampo wisede, tane me dewa sa dewasadia baiwa mai nuaeuwaleipona, dia. ");
INSERT INTO soq_vpl VALUES ("EK2_1","027_2_1","EZK","2","1","1","Ne Iawe God sapawa debamaia kiboraleidia ewane tawo osowe dunenten. Ne dunentene etedino apana da gagalolene wanase, “E apanaida, enawiewo ne manawo gagalonteapa.” ");
INSERT INTO soq_vpl VALUES ("EK2_2","027_2_2","EZK","2","2","2","Me gagaloleidio bedewe God aleupa ne nopenene wadaposineno enana. Ita enane me mida gagaloleidia asisusadine. ");
INSERT INTO soq_vpl VALUES ("EK2_3","027_2_3","EZK","2","3","3","Me wane wanase, “E apanaida, ne e waubaedina Israel apanawa mo mida mapo nosinosiu ne adianananene aiana mai ruantopona rua dewantoie waimoia mampo aita. ");
INSERT INTO soq_vpl VALUES ("EK2_4","027_2_4","EZK","2","4","4","Ne dima wadina mo mai eteipe ruawantoipona ita wiwiranantoipona, sa baiwa ne e waubaedina aite dima ne Warere Iawe God mo baibu wadina diamoa. ");
INSERT INTO soq_vpl VALUES ("EK2_5","027_2_5","EZK","2","5","5","Apana sa aia etadabuala, naita e aiaa etapue dabuantopu ba ruantopua sa ide, tane mo atentopu peroweta mo bedeuwo wisene gagalolen.” ");
INSERT INTO soq_vpl VALUES ("EK17_22","027_17_22","EZK","17","22","22","Warere Iawe God wadiase, “Ne neba ia bonoia daumaia inileidia nuapa empapune anteape wadi iwa ionoidolena osowe ampa. ");
INSERT INTO soq_vpl VALUES ("EK17_23","027_17_23","EZK","17","23","23","Ia bonoia sa wadi iwa osowe Israel bedewe inileidia debamaidalepie eudida segalepi. Me ragapa teamopio osowe naumba teamopi, me ragapa osowe nene daitada wimopue duntopue ita golaupa bedewe waimompa. ");
INSERT INTO soq_vpl VALUES ("EK17_24","027_17_24","EZK","17","24","24","Ia uduudu tawo osowe inintoia atentopu ne ipa Iawe God. Ne ia dauma topaiape ita kampaida dewasapo inilepie daumaia segalepia rua. Ne ia asiwa euda dubua inileidia dewasapo tonalepi ita tonapa ina wanapo inilepia rua. Ne Iawe God wadina ando ideita dewasapa.” ");
INSERT INTO soq_vpl VALUES ("EK33_7","027_33_7","EZK","33","7","7","Iawe God ne dianene wanase, “E apanaida, ne e entuedina Israel apanawa iwubu apanawa segaitaa, sa baiwa ne dima e dieepa wae nuaitumoa. ");
INSERT INTO soq_vpl VALUES ("EK33_8","027_33_8","EZK","33","8","8","Naita ne apana kadi dewalala bolepia umanawa wapino e etee tane diasiaitawo kadi bedewe waimpe bolepia me bowa sipoa ne e matangelaepa. ");
INSERT INTO soq_vpl VALUES ("EK33_9","027_33_9","EZK","33","9","9","Tane naita me insaisawa leusapia umanawa diawo etepie tane kadiwa dewasampe waimpe bolepia sa ipa e inawaa inasaana.” ");
INSERT INTO soq_vpl VALUES ("EK34_11","027_34_11","EZK","34","11","11","Warere Iawe God ema epe wadi wadiase, “Ne neba sipsipna banumopine ideita dommopa. ");
INSERT INTO soq_vpl VALUES ("EK34_12","027_34_12","EZK","34","12","12","Naita sipsip dea da aleidie rebaleidia, me onionia apanawa ideita banusadie donsade, epe rua ne sipsipna banumope dommopa. Mo giou taubodamono dubawa bedewe nomone bola daitadawo antone waimoie laia banlamopo leuntopue bolawo wimopu. ");
INSERT INTO soq_vpl VALUES ("EK34_15","027_34_15","EZK","34","15","15","Ne Warere Iawe God sipsipna nana wanamope ita bolau euda bedewe teamopo wampudewae bubuantopu. ");
INSERT INTO soq_vpl VALUES ("EK34_16","027_34_16","EZK","34","16","16","Ne sipsipna dainea rebantone koantone laia banumope dommope ita otamope leumopo bolauwo wimopu, isiwa bene dola ne bunamamopa ita kero wadamono nawinawintona muka wanamopa. Tane isiwa etepu potopotowa mukawau mo kadiu sipoa ne sipsip onioniau apanawa rua dodomana asiasi matangelamope bomopa. ");
INSERT INTO soq_vpl VALUES ("EK34_17","027_34_17","EZK","34","17","17","Tane ne Warere Iawe God, sipsipna baila ema epe wadina, ‘Gamo onionia apanawa sipsip ita gote empuempumodia rua ne e kadiwa dewalala ita euda dewalala do kotulepe empuempulepo nambenambeitana.’” ");
INSERT INTO soq_vpl VALUES ("EK36_16","027_36_16","EZK","36","16","16","Iawe God ne mainawo wane wanase, ");
INSERT INTO soq_vpl VALUES ("EK36_17","027_36_17","EZK","36","17","17","“E apanaida, Israel apanawa muba tawou osowe waimoie dewau ita eueuwau kadiwa daitada dewamoia mampe bolau miramirasane kadiidasaiena. Ne emanawo kadi sa ipa i uaboa wadepio miramiralepia rua. ");
INSERT INTO soq_vpl VALUES ("EK36_18","027_36_18","EZK","36","18","18","Mo apana epaboiamoiena ita do god lagawau wadaposimoiena mampe tawo ema kadisaiena, sa baiwa ne nuasigasigana debama mo osouwo memepaaubepa. ");
INSERT INTO soq_vpl VALUES ("EK36_19","027_36_19","EZK","36","19","19","Ne mo matangelamona ipawa mo kadiwa daitada dewasaiena baiwa. Ita do dewamono antone tawo daitada apanawa do waimoie. ");
INSERT INTO soq_vpl VALUES ("EK36_20","027_36_20","EZK","36","20","20","Mo sape waimoie laia asiasi apana ne ebona kakaiwa wakadisasaie waiase, ‘Ema ipa Iawe God apanawaida, me ipa oauara sa baiwa mo emono bolauida ene bola daitada bedeuwointa waimoie lai. Mo epe waia mampe ne ebona kakaiwa wakadisasaie mala osowe ituiena.’ ");
INSERT INTO soq_vpl VALUES ("EK36_21","027_36_21","EZK","36","21","21","Ne menanedia apana ne ebona kakaiwa wiwirawantoipe waimoipona, tane Israel apanawa sa antone bola daitadauwo waimoia mala osonawo itui. ");
INSERT INTO soq_vpl VALUES ("EK36_22","027_36_22","EZK","36","22","22","Sa baiwa Israel apanawa ema epe diamoa, ‘Warere Iawe God ema epe wade: E mai dewala da euda baiwa ne leulepo bolalawo wilena, dia. Tane ne neba ebona kakaiwa wiwirawa asiasi epe dewasapa, ebo ipa sa e tawo daitada bedeuwo wainile mala osowe itulana ");
INSERT INTO soq_vpl VALUES ("EK36_23","027_36_23","EZK","36","23","23","Ne apana mampo sabamosapa ne ebona ipa mukamukaua kakaiwa, ebo ipa sa e tawo daitada apanawa emauwo mala osowe itulana. E Israel apanawa bedelawoe ne tawo daitada apanawa mampo sabamonteapo ateineapu ne ipa kakaiwa. Ne epe dewasapo uwa daitada apanawa atentopu ne ipa Iawe God. Ne Warere Iawe God ema epe wadina. ");
INSERT INTO soq_vpl VALUES ("EK36_24","027_36_24","EZK","36","24","24","Ne e tawo daitada bedeuwo wainilana otalepe leulepo bolalawo wilena. ");
INSERT INTO soq_vpl VALUES ("EK36_25","027_36_25","EZK","36","25","25","Ita ne e euitana baiwa esa eudida mampe nuala mitapa, e god lagawau wawoitile ita kadiwa daitada dewasale miramiraitena bedewe euitana. ");
INSERT INTO soq_vpl VALUES ("EK36_26","027_36_26","EZK","36","26","26","Ne e nua sanaa enalepa ita do aleu sanaa bedelawo itupa. Ne e nuala badowa seu rua aia etadabuala winedia wadapaubepa ita nuala bibia tekateka bedelawo itupo ne aiana etonune ruawaitonuna. ");
INSERT INTO soq_vpl VALUES ("EK36_27","027_36_27","EZK","36","27","27","Ne aleuna e bedelawo itupo ita ne waeuwana wiwirawaitonuna ita anaanana deaitopa ruawaitonuna.’” ");
INSERT INTO soq_vpl VALUES ("EK37_1","027_37_1","EZK","37","1","1","Iawe God mukawa ne osonawo ieno, me aleupa ne wadanene alene doba nua bedewe neai bobopa nopesane winedia bedewe itunen. ");
INSERT INTO soq_vpl VALUES ("EK37_2","027_37_2","EZK","37","2","2","Me ne dewaneno neai sa bedeuwointa antene ewamodine, neai sa ipa uaraia ita tonapuida. ");
INSERT INTO soq_vpl VALUES ("EK37_3","027_37_3","EZK","37","3","3","Me ne waitaranene wanase, “E apanaida, e inseiana neai ema tonapu osowe inantopue apana segantopua rua, ba?” Ne me sipoasane wanase, “Warere Iawe God, sa e eba ateiten.” ");
INSERT INTO soq_vpl VALUES ("EK37_4","027_37_4","EZK","37","4","4","Me ne dianene wanase, “Ne gagalona wae neai ema diamoe wae waase, ‘E neai tonapu, Iawe God aiawa wadia etana. ");
INSERT INTO soq_vpl VALUES ("EK37_5","027_37_5","EZK","37","5","5","Warere Iawe God e dialedie wadiase: Ne wapo etane, ne e osowe nonau enalepo inaitana. ");
INSERT INTO soq_vpl VALUES ("EK37_6","027_37_6","EZK","37","6","6","Ne e otalepe endoendolepo badoitano ita nipala dewamope ita etela teamopa. Ne e nonau enalepo ita inaitana ita ema bedewe e ateitana ne ipa Iawe God.’” ");
INSERT INTO soq_vpl VALUES ("EK37_7","027_37_7","EZK","37","7","7","Me gagalo sa wane dianena rua neai sa mampo gagalontedine etedino neai inainantoio etamona ita ewamodino neai sa muba endoendontoiena. ");
INSERT INTO soq_vpl VALUES ("EK37_8","027_37_8","EZK","37","8","8","Ne enane ewamodino muba endoendontone badontono osouwo nipawa teamon ita etepu wisene nipau rupumon. Tane nonau bedeuwo dia. ");
INSERT INTO soq_vpl VALUES ("EK37_9","027_37_9","EZK","37","9","9","Iawe God ne dianene wanase, “E apanaida, ne aiana mampe nonau diee waase, ‘Warere Iawe God wadi wadiase: Nonau inta daitada bedewe wine ete ema bolala wineia bedewoitawo osowe inantopu.’” ");
INSERT INTO soq_vpl VALUES ("EK37_10","027_37_10","EZK","37","10","10","Iawe God ne dianena rua wano nonau wisene bolala bedeuwo odeno mo uduudu inantone enanawimoiena. Mo inantone enanawimoiena ewaewau sorodia uaraia ruau. ");
INSERT INTO soq_vpl VALUES ("EK37_11","027_37_11","EZK","37","11","11","Iawe God ne mainawo wane wanase, “E apanaida, ne wapo eta, Israel apanawa mo ipa neai ema rua. Mo waiase, ‘No tonantene diaidanten mai mida inanepia rua.’ ");
INSERT INTO soq_vpl VALUES ("EK37_12","027_37_12","EZK","37","12","12","Sa baiwa ne gagalona e dieena rua diamoe waase, ‘Warere Iawe God e dialedie wadiase: Ne apanana, ne e inalepe emalawoala apanawa bedeuwo wainilana otaubalepo leuitane winlena tawola Israel bedewe. Sa ipa ewaewa e bo domba bedewe wineipono wadaubalepona rua, ne e otaubalepe dewalepo osowe inaitana. ");
INSERT INTO soq_vpl VALUES ("EK37_13","027_37_13","EZK","37","13","13","E ne apanana, ne e wadaubalepo nolenuna walamawe e ateitana ne ipa Iawe God. ");
INSERT INTO soq_vpl VALUES ("EK37_14","027_37_14","EZK","37","14","14","Ne aleuna e bedelawo itupo osowe inaitano ita otalepo leuitane bolalawo wilena. Ne epe dewasapo e ateitana ne ipa Iawe God. Ulaipa, ne ipa Iawe God dima wadina ando ideita dewasapa!’” ");
INSERT INTO soq_vpl VALUES ("DN7_13","028_7_13","DAN","7","13","13","Tadino ne auen rua bedewe apanaida rua giou taunbodeno bedewainta iedio ewana. Ita mo me banlene anton me mida Wanwankasalala mampe. ");
INSERT INTO soq_vpl VALUES ("DN7_14","028_7_14","DAN","7","14","14","Ita me mida Wanwankasalala sa me muka, ebo debama ita kasawoga uduudu me wanen warerelepia baiwa. Ita apana uwa daitada uduudu tawo osowe wanwanla muba aiauwoaiauwo me wadaposisampe ita aiawa ruawantompa baiwa. Me gonaawa ando mai dialepi ita me onionia mukawa ipa winakasala. ");
INSERT INTO soq_vpl VALUES ("DN12_1","028_12_1","DAN","12","1","1","Ensel ne dianene wanase, “Walama ando iedia bedewe ensel mukamukaua Maikel mida e apanaa Israelwa oniamodia sabamolepie wisepio poka rebarebaida segalepi. E uwa da segaitena walamawe e mai kadi ema rua donsapona, dia. Walama sawo e apanaa mida ebou God buka bedewe girumalena inaida donsapu. ");
INSERT INTO soq_vpl VALUES ("DN12_2","028_12_2","DAN","12","2","2","Apana uara mida bontone dogo bedewe wineia ando osowe inantopue enapuwimopu, isiwa ando inawinakasala wadapu ita isiwa mala ita nuapare debamaia winakasala bedewe antopu. ");
INSERT INTO soq_vpl VALUES ("DN12_3","028_12_3","DAN","12","3","3","Tane insadewasala apanawa mo mida sosou isiwa dewamoieno God mampe dodomanantona ebo debama winakasala wadapu ita mo inainambu sapaida wapi walamo uba sapa wadia rua ita do tadino kipora sapa waia rua.” ");
INSERT INTO soq_vpl VALUES ("HS11_1","029_11_1","HOS","11","1","1","Iawe God wanase, “Israel oto kerauda wandia walamawe ne me nuawadawadasadine ita me ne otona rua Isibtiwa wandio apasano nosen. ");
INSERT INTO soq_vpl VALUES ("HS11_2","029_11_2","HOS","11","2","2","Ne Israel apanawa kainokaino eneio baiwa osoweosowe apamodine mainawo wimpua baiwa, tane mo ne eneia dewawa osoweosowe dewasaie enene aidantoie, ne apanana godiu lagawaa Baal mampe pulou ituie ita kokoitau mampo piupiu suie ita wadaposimoie.” ");
INSERT INTO soq_vpl VALUES ("AM8_4","031_8_4","AMO","8","4","4","E mida apana nitu abolawantoia ituaisimoilana, ita do nuaparelala bolala bedewe waimoia kadimonatuwapia baiwaitilana asisuneana. ");
INSERT INTO soq_vpl VALUES ("AM8_5","031_8_5","AMO","8","5","5","E menaledia Sabat walamawa ita walama debamau odau tauwadea os diantopuo, e nanala osowe teamona ita gimaralala lagamona baiwa. E laga mampe malesa debamamoilana, ita do nana mai wisiadewaitipe apana wanamoipona, dia, e mai nana sikeredewaitipono apana manlawo gimarantoipona, dia. ");
INSERT INTO soq_vpl VALUES ("AM8_6","031_8_6","AMO","8","6","6","E nana isiwa kadiu do teamoilano apana gimarantoi. Naita e apana mane kerauda manlawo wadeia mai leusapue malesantopua rua e mo wadamoile dewamoilano nolala apanawa segantoi. Tane mane sa ipa kerauda sendoro malesawa rua. ");
INSERT INTO soq_vpl VALUES ("AM8_7","031_8_7","AMO","8","7","7","Iawe God saua badowa me meba ebowa mampe wan, ebo ipa sa Israel apanawa mamposaie wiwirawantoia, me wane wanase, “E dewa sa kadiwa dewamoilana ne ando mai nuaawawamopa, diaida.” ");
INSERT INTO soq_vpl VALUES ("AM8_10","031_8_10","AMO","8","10","10","Ne e walama debamau odau dewamoilana leusapaitudepio kako debamaia wanuna, nuaeu sasawa wailana leusapaitudepio ke wanuna. E nuaparela eueuwa bo segalena garawa kadiwa benaitane ita uwala koresamonuna. Ne dewalepo ke wanuna e otolaida bolepono kakowa waipona rua. Kako sa ideita alempe ompa osowe sigasigauaida segalepi. ");
INSERT INTO soq_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Iawe God gagalowa Amitai otopa Iona wanene ");
INSERT INTO soq_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","diene wanase, “Imaite enawie aitaa bola debama Niniwe bedewe ita diamoe waase, mo kadiwa dewasaia ne ewamone atenten. Sa baiwa ne mo matangelamopa baiwantedina.” ");
INSERT INTO soq_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Tane Iona tauwadea os enenwisene imaalene insedia Iawe God epie nambe alepi. Sa baiwa me alene owa tampe bola Iopa bedewe nosene waa dea bola debama Tasisi bedewe a baiwaleidio ewen. Ita me waa sa malesalene bedewe odene ita Tasisiwa aleidie. ");
INSERT INTO soq_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Tane Iawe God lawara debama badowa dewasano wisene owa tepaidasadie waa epedia kerauda os tutuwapona. ");
INSERT INTO soq_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Tane waa bedewe nolantoia apanawa saidantoiena ita mo deadea sau baiwa godiu mampo iririntoie. Ita mo waa tekatekasapua baiwa puraiwa waa bedewe wineia otaweisantoiena. Tane Iona aita iene alene waa didiwe ituawawaidalen. ");
INSERT INTO soq_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Waa dodomanasadia apanawa iene alene Iona ewene diene wanase, “No uduudu kadi donsata baiwantitana e dima itudewadewaitiana! Enawie e godia mampe rauparita naita me no etanepie nuaparembalepie saunepio mai bontata!” ");
INSERT INTO soq_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Waa bedewe nolantoia apanawa muba gagalontone waienase, “No nitu kopikopiua mampe owantate ewate atentata mida kadi dewasano baiwa poka rebarebaida ema donsaitana.” Sa baiwa mo nitu sa mampe owantono Iona ebowa sabamolen. ");
INSERT INTO soq_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Mo epe ewane me diane waienase, “E no dianea kadi ema donsaitana wawuwa mida waden? E nolaa dainea? E bola dainea apanawa? E apana uwa dainea?” ");
INSERT INTO soq_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Ita Iona mo sipoamone wanase, “Ne ipa Ibru apanawa ita Iawe God mida uboo wandia wadaposisadina apanawa, me ipa mida owa ita tawo dewamono winei.” ");
INSERT INTO soq_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Tane Iona me insenase, ne Iawe God epe nambe anteapa rua. Me ene sawe aleidia umanawa bauta mo diamono eteiena sa baiwa mo sipoamodio saidantoiena ita waienase, “E dewa kadiwaida dewasaana!” ");
INSERT INTO soq_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Tane lawara debama badowa weuwadia mukawa debamaidaleidio mo ewane Iona waitarasane waienase, “No e ambi dewaeto lawara ema aisidepie dialepi?” ");
INSERT INTO soq_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Iona mo sipoamone wanase, “Ne atenten ema ipa ne kadina baiwa e kadi ema donsailana, sa baiwa ne wadaneane owa bedewe aubaneano lawara ita rauwanaga ema obasalepie dialepi.” ");
INSERT INTO soq_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Tane waa bedewe nolantoia apanawa mai menamoipona me owa bedewe aubepu, sa baiwa mo badowa rubusane wolentoie waiwe antopona baiwa. Tane lawara ita rauwanaga debamaidalene kadiidaledie. ");
INSERT INTO soq_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Sa baiwa mo Iawe God mampe sidantone waienase, “Iawe God no apana ema euda bosataa baiwantitana wawuwa mai no osombosae matangelanewo bontata. Dewa ema ipa e eba insaisawaitene dewasaano segalen.” ");
INSERT INTO soq_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Ema aupe mo Iona wadane owa bedewe aubeieno iene alen. Mo epe dewasaieno tauwadea os rauwanaga aisidene dialen. ");
INSERT INTO soq_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Waa bedewe nolantoia apanawa dewa ema ewane Iawe God sawaidantoiena, sa baiwa mo Iawe God mampe pulo dewasane ita badowa sauantoiena. ");
INSERT INTO soq_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Tane Iawe God dewasano owa moia debamaia wisene Iona numen ita me moia sa bupa bedewe wandio walama natadea ita tadina natadea dianton. ");
INSERT INTO soq_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Iona owa moia bupa bedewe wandie Iawe God mampe rauparilene wanase, ");
INSERT INTO soq_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","“O Iawe God ne poka debama etedina, bedewe manawo rauparinteno etaneana. Bolala bolau bedewe iane aidantene sau baiwa iririntedino etaneana. ");
INSERT INTO soq_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","E ne aubaneano owa didiweido iane aidanten. E rabamaa mukawa epaubanedie leusaitunedie. E rabamaa ne osonawo epedie tutuwadie. ");
INSERT INTO soq_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Ne insenase, e ne enabodaneano eidaene nambeido anten, ita ando e dua kakaiwa mai osowe ewapa. ");
INSERT INTO soq_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Ne owa bedewe iane antene nuana boidalen, owa numanen, ita ina owa bedewe inintoia uwana taunboden. ");
INSERT INTO soq_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Ne iane owa bedewe aidantene wadi didiuwoido nonen. Sape ne diburantene wainedine, bola sa intawa moau gudulala winei. Tane e Iawe God ne Godna e ipa sa ne inaneana, ita e ne don sa bedewe wainedino wadaubanee inaneana. ");
INSERT INTO soq_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Walama sawo ne insaisana koaleno boida baiwantedine. O Iawe God ne e insaene manawo rauparinten, ita e dua kakaiwa bedewe wainie etaneana. ");
INSERT INTO soq_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Apana mida god lagawaau wadaposimoia, e nuawadawadaa winakasala adiananasai. ");
INSERT INTO soq_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Tane ne nebaida e os wadaposiepina; Ne e manawo pulo itupa, ne dima e manawo sauatena rua dewamopa. Iawe God e os apana inamoiana.” ");
INSERT INTO soq_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Walama isiwa diantono aupe Iawe God owa moia debama dieno Iona uta rua einaubeno owa waiwe nosen. ");
INSERT INTO soq_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Iawe God osowe me gagalowa Iona diede. ");
INSERT INTO soq_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","Me wadi wadiase, “E imaitee bola debama Niniwe bedewe aitee ita ne gagalona wae apana diamoa.” ");
INSERT INTO soq_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Sa baiwa Iona Iawe God aiawa ruawalene imalene alen Niniwe bedewe. Bola ema ipa debamaia walama natadea bedewe ewatuwapi. ");
INSERT INTO soq_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Iona Niniwe bedewe wisene aleidio walama dea dialeno God benemawa wadio apana eteiena. Me wanase, “Walama 40 dialepio aupe bola debama Niniwe kadi donsapi.” ");
INSERT INTO soq_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Bola debama Niniwe apanawa God gagalo ema etane sumanaintone mo uduudu eboeboua ita ebousiawaia insaisau itune idintoia nana mai napu. Ita mo gara imbu kadiu mampe dewalala rupuntoie mo dewau kadiwa dewasaiena nuaparewantoia eueuwa. ");
INSERT INTO soq_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Bola debama Niniwe warerewa gagalo ema etene kolaiwatawa ene nosene warere garawa benaleidia otawialene aupe gara imbu kadiu taumon ita nuaparewa eueuwa isana bedewe wandie. ");
INSERT INTO soq_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Me gagalowa apana uduudu diamone wanase, “Ne ita uwaala apanawa dialeitana e uduudu ita puela debamau ita kerakera do iditane nana ita esa mai nana. ");
INSERT INTO soq_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Apana ita pue uduudu gara imbu kadiu mampe taumona. E uduudu dewala kadiu ita dewala rebarebaida emonatuwapi ita God mampe nuala uduudu mampe iriritana. ");
INSERT INTO soq_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","No mai atentipona naita me insaisawa leusapie nuasigasiga debama mai osombosapio bontata.” ");
INSERT INTO soq_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Mo insaisau leusane kadiwa eieno God ewamone nuapareulene mo kadimopona wana mai dewasapona, dia. ");
INSERT INTO soq_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Tane Iona mai nuaeulepona ita do nuawa kadiidalen, ipawa God bola debama Niniwe apanawa mai matangelamopona. ");
INSERT INTO soq_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Sa baiwa me rauparilene wanase, “O Iawe God ne imanamampe bolanawo wainedine wanase dewa ema ando segalepi, sa baiwa ne imantene bola debama Tasisi bedewe antedine. Ne atenten God e apana nuapareuitie euda mampo dewasaiana, e mai tauwadea nua kadileipona do e nuawadawadaa ipa winakasalala ita e insaisaa leusaie apana mai matangelamoipona, dia. ");
INSERT INTO soq_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Sa baiwa Iawe God ne mai wanwan menaneipona, ne bonteapa sa ipa eudida.” ");
INSERT INTO soq_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Tane Iawe God me sipoasane wanase, “E dewa ema baibu mai di nua kadilempa, emoa.” ");
INSERT INTO soq_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Iona alene bola sa waiwe omo wisedia deneuwe golau dewasane atowe onionialeidie wandie, dewa dainea Niniwe apanawa mampo segalepio ewepia baiwa. ");
INSERT INTO soq_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Me sape wandio Iawe God ia da kerauda dewasano tauwadea os inilena ragapa weisapio golaupa bedewe waimpa baiwa. Golau sa atowe waine nuawa tono ita ia sa nuaeuwaleidie. ");
INSERT INTO soq_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Tane imonemba God katuwei dewasano wisene ia sa adenboleno rorolen. ");
INSERT INTO soq_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Tane tadinaida omo wiseno God lanunu polapolaua dewasano sala makowa deneuweinta wisen ita omo polawa Iona uwawa ino guribubulepona. Me bo menasano wanase, “Ne mai wanwan menaneipona, ne bonteapa sa ipa eudida.” ");
INSERT INTO soq_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Tauma God Iona diene wanase, “E ia ema tonalena baiwa nua kadileide, ba?” Iona wanase, “O ne nuana kadiidaleide, sa baiwa ne bonteapa menanede!” ");
INSERT INTO soq_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","God me diene wanase, “Ia ema tadina dea bedewe inilen ita imonemba tonalen, tane e mai ia sa dewasapono inilepona ba oniepona ita tonaleno nuaparewaitiana. ");
INSERT INTO soq_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Tane ne ideita bola debama Niniwe nuaparewanteapa, ipawa apana uaraia 120,000 mai euda ita kadiwa dewawa atentopona ita do pue uara sape waimoia baiwa!” ");
INSERT INTO soq_vpl VALUES ("MC5_1","034_5_1","MIC","5","1","1","E Ierusalem apanawa onala apanawa diamono auwepu. No emalawoamba apanawa aitamana wimone tonusaneiena onamba enapua baiwa, mo koina mampe Israelwa uwaula apanawa sainapa epaubasapu. ");
INSERT INTO soq_vpl VALUES ("MC5_2","034_5_2","MIC","5","2","2","Iawe God wadiase, “Beteliem Eparata, e ipa bola keraudida Iuda bedewe, tane e bedeawoe apana dea ando wisepie Israelwa uwaula apanawa segalepie oniamopi ne baina, me damba reresawa simaido odene wisenaa.” ");
INSERT INTO soq_vpl VALUES ("MC5_3","034_5_3","MIC","5","3","3","Sa baiwa Iawe God Israel apanawa otamopie emalawoau witaposapio waimompo, ideita i oto gamoa walamawa wisepio gamolepi. Tauma onionia apanawa sa me apanawaida deaantone waimoia leuntopu wimopue sosou isiwa Israel bedewe waimoia do deantopue wampu. ");
INSERT INTO soq_vpl VALUES ("MC5_4","034_5_4","MIC","5","4","4","Me ando badowa Iawe God mukawa mampe enepie me apanawa oniadewasamopi, gamo apanawa puewa oniadewasamodia rua, Iawe God me Godiwa muka wanena epe dewasapia rua. Me apanawa ando oniadewasamompo mai mida da kadimopi, dia. Ipawa apana uduudu tawo osowe wanwanlala me nuawadawadasapue wiwirawantopu. ");
INSERT INTO soq_vpl VALUES ("ZC9_9","039_9_9","ZEC","9","9","9","Iawe God wadiase, “E bola debama Saion apanawa nuaeuidaitana! E Ierusalem apanawa nuaeu kawa wana! Ewane e warerela manlawo iede, me dewawa ipa dodomana ita ona nanausana apanawa. Me etepa molaisiwa donki osowe waine iede; Oa, me donki sanaa osowe waine iede. ");
INSERT INTO soq_vpl VALUES ("ZC9_10","039_9_10","ZEC","9","10","10","Ne ona turakawa pue mampe teiteinala Israel bedewe otaubamopa, ita oas osouwo waimoie antoie onantoia Ierusalem bedewe waimoia otaubamope nambemopa. Ita ona puraiwawa uduudu kadimopatuwapi. E warerela wanwan euda obasa uwa daitada apanawa uduudu tawo osowe waimoia wanamopi. Me warerewa makawa owa da osowe enepitue alepie owa da wadepi, ita do esa Eupirates makawa alepie ita tawo uduudu wadepituwapi.” ");
INSERT INTO soq_vpl VALUES ("ZC12_10","039_12_10","ZEC","12","10","10","Iawe God wadiase, “Mo mida Dawid nosinosiwa ita apana uduudu Ierusalem bedewe waimoia ne dewamopo apana nuapareuntompa ita do raupari nuapolapolantompa. Mo ne ewaneapu ne ipa sa einene boneiena, mo kako debamaia wapu oto sanaa boleidio kewa waia rua. Mo nuasiasiau kewa pokawaida wapu oto tautuwa boleidio kewa waia rua. ");
INSERT INTO soq_vpl VALUES ("ZC12_11","039_12_11","ZEC","12","11","11","Walama sawo Ierusalem bedewe nuaparepare kakowa debamaia wapu ambi mo Adad-Rimon baiwa doba nua Megido bedewe ke waiena rua.” ");
INSERT INTO soq_vpl VALUES ("ZC13_1","039_13_1","ZEC","13","1","1","Iawe God Mukamukaua wadiase, “Walama sawo maneu naimepie wisepie Dawid nosinosiwa ita Ierusalem apanawa kadiu ita mirau uduudu mitepiaubepie eumopi.” ");
INSERT INTO soq_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ema ipa Iesu Keriso nosinosiwa ebou: Iesu Keriso me ipa warere Dawid atanosiwa, tane Dawid me ipa Abraam atanosiwa. ");
INSERT INTO soq_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","6","Abraam ita warere Dawid wisena Iesu nosinosiwa uduudu 14, mo ebou reresawa ipa ema epe: Abraam Aisak mamba, Aisak Iakob mamba, ita Iakob Iuda wanwamba do mambu. Iuda, me ipa Peres ita Sera mambu, mo inau ipa Tama. Tane Peres Esron mamba, Esron Ram mamba, ita Ram Aminadab mamba. Aminadab me ipa Nason mamba, Nason Salamon mamba, ita Salamon Boas mamba, ita Boas inawa ipa Raab. Tane Boas Obed mamba, ita Obed inawa ipa Rut. Obed me ipa Iese mamba ita Iese warere Dawid mamba. ");
INSERT INTO soq_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","11","Warere Dawid ita Israel apanawa mo bolau ene Babilon banlamone antoiena walamawe wisena Iesu nosinosiwa uduudu 14, mo ebou reresawa ipa ema epe: Dawid ipa Solomon mamba, tane bauta Solomon inawa Uria manainapa wandie ita ema aupe me Dawid naisena. Ita Solomon Reobeam mamba, Reobeam me ipa Abaia mamba, ita Abaia Asa mamba. Asa ipa Ieosapat mamba, ita Ieosapat Ieoram mamba, tane Ieoram me ipa Usia mamba, ita Usia Iotam mamba. Iotam ipa Akas mamba, Akas me ipa Esekia mamba, ita Esekia Manase mamba. Manase ipa Amon mamba, ita Amon Iosia mamba, tane Iosia ipa Ioiakim wanwamba do mambu. ");
INSERT INTO soq_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","17","Israel apanawa bolau ene Babilon bedewe banlamone antoiena walamawe ita Iesu Keriso segalena walamawe me nosinosiwa uduudu 14, mo ebou reresawa ipa ema epe: Ioiakim ipa Sealiel mamba, Sealiel Serubabel mamba, ita Serubabel Abiud mamba. Abiud Elaiakim mamba, Elaiakim ipa Asoa mamba, ita Asoa Sadok mamba. Sadok Akim mamba, Akim ipa Eliud mamba, ita Eliud ipa Eleasa mamba. Eleasa Matan mamba, ita Matan Iakob mamba, ita Iakob ipa Iosep mamba. Iosep sa Meri naisena. Ita Meri Iesu gamosan, me ipa Keriso God sonabena apana inamopia baiwa. ");
INSERT INTO soq_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Iesu Keriso muwa ema epe inta winin: Iesu muriwa mulen me inawa Meri tarabensaiena apana ebowa Iosep naisepi. Mo anaanau ruawantone nainaiidantopua anuwa nambenambe waimoie mai etepu deasapona, dia. Tane Meri awoa wandie dauwa etene atenlen me Aleu kakaiwa mukawa mampe bulen. ");
INSERT INTO soq_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Iosep Meri bulena umanawa etene insenase Meri apana da busan, sa baiwa nainai inguguraleidie. Tane Iosep apana euda, walama uduudu dewa dodomana os dewasadie Meri anaanau ainpundena osowe mai sabamo mala osowe itupe ebowa kadisapona menasapona, dia. Tane me dainawa nainai epona insaisawaleidie. ");
INSERT INTO soq_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Me nainai eewa insaisawaleidio Tatamba enseliwa auwen bedewe mampe segalene diene wanase, “Iosep, Dawid atanosiwa, Meri naisea, mai inguguraite ea! Me Aleu kakaiwa mukawa mampe bulen. ");
INSERT INTO soq_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Me oto mona gamosapio ita e me ebowa itue waase, ‘Iesu.’ Ebo sa ipawaida ipa me God apanawa kadi bedewe waimoia inamopi. E ebo sa itua, ipawa Iesu ipa apana kadi bedewe inamopi.” ");
INSERT INTO soq_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Dima Meri ita Iosep mampo segalena, mai di segalepona, dia. Tane dima Tatamba God mapo perowetawa mampee wana ideita segalepia baiwa ema segalen. Ita God me perowetawa insaisawa waneno wane wanase, ");
INSERT INTO soq_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“I sanaa mai apana do itula bulepie oto mona gamosapi, ita mo me ebowa itupue wapuase, ‘Imanuel.’” Ebo Imanuel ipawaida ipa God no do. ");
INSERT INTO soq_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Iosep ituleidie auwen bedewe God enseliwa mampe segalene gagaloleno dialeno me enenwisene dima Tatamba enseliwa diena rua dewasane Meri naisen. Ita mo nata duwa antone waimoie. ");
INSERT INTO soq_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Mo nata awodea waimoie mai etepu deasapona, dia, mo oto mulepia anuwa di waimoie. Tane oto muleno Iosep me ebowa itune wanase, ‘Iesu.’ Ema aupe mo nainaiida ruawa etepu deasaie awodea waimoie. ");
INSERT INTO soq_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Erod warereleidia walamawe Iesu bola Beteliem Iudia bedewe mulen. Walama sawo bola da bedewe ware isiwa kipora eueuwau ewamoia atembu waimoie. Mo Iuswa warereu kiporawa ewane bolau naepe omo wisediawo ene kipora wisunene Ierusalemwa wimone ");
INSERT INTO soq_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","waitarantone waienase, “No oto gegela mida ando Ius apanawa warereulepia banusaitana, me naepe mulene wande? No bolambo wainite me kiporawa ewate atenten warere debamawa mulen. Ita no bolamba ete me auwadewade- wasate ionosataa baiwa winen.” ");
INSERT INTO soq_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ierusalem wanwanlala isiwa ware apanawa sa ewamone do gagalontoiena umanawa warere Erod etene nuawa surakauidalen. Oto sa mulena me aupawa wadepia insedie nuawa polaida wan. Ita Ierusalemwa uduudu do nuau pola wan. ");
INSERT INTO soq_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Erod nuawa polaida wano osowe pirisi debamau uduudu ita anaana waeuwalala diamono gagalo baiwa auweieno me waitaramone wanase, “Keriso, me ipa Iuswa warereu mida God sauawalena mulepia, me bola daineawo mulepi, e ateiten ba dia?” ");
INSERT INTO soq_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ita mo me sipoasane waienase, “Me bola Beteliem Iudia bedewe mulepi, God perowetawa mapo girumalena rua. God perowetawa me umanawa buka bedewe girumalena God wadi wadiase, ");
INSERT INTO soq_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Bola Beteliem, Iudia bolawa uduudu bedeuwo e debamawaida. E bedeawoe warere mulepie waimpa, ita me ne apanana Israelwa onioniau apanawa wanalepie oniamompa.’” ");
INSERT INTO soq_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Erod pirisi debamau ita anaana waeuwalala mampo oto mulepia bolawa etene atenlene ware sa uamo wimoiena niabointa gagalou wanaubena wim- pue me do gagalontopu. Ita mo me mampe wimoieno waitaramone wanase, “Ne menanedia e warere debamawa kiporawa wisene enedio ewalana walamawa ruaidaitane dianeano atenteapa.” ");
INSERT INTO soq_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Mo me waitarawa sipoasaieno eteno dialeno Beteliemwa waaubamodie diamone wanase, “E Beteliemwa aitane oto banuitana! E banusanune donsana tauwadea os gagalo wanaaubeno mainawo wimpio ne do sape anteape oto auwadewadewasape ionosapa.” ");
INSERT INTO soq_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Mo warere Erod gagalowa eteieno dialeno me ene nomone intauwo antoiena ita kipora bauta bolauwo waimoie eweiena nambunepelene banlamodie. Ita mo kipora sa ewane nuaeuntone antoie. Tane kipora sa banlamone aleidia oto mulena bolawa onape enenituden. ");
INSERT INTO soq_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Mo antone du onape kipora enenitudenawo odeie oto banusaia inawa Meri do ewamoiena. Tane mo oto ewane imimpu emmisintone auwadewadewasaie ionosaie. Ita mo oto amonawa otamone wimoiena otawiamone me baiwa teamoiena. Mo amonau ipa gold, piupiu, ita nitu uwatauwa eudida bonabonaua ebowa waia Mire. ");
INSERT INTO soq_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ema aupe tadino ituntoio God auwen bedewe diamona mo leuntopue bolau awa antompe mai Erod mampe antopue diadewasasapu, dia. Tane epue inta da inta bolauwo antopu. Ita mo God diamona ruawantone inta da asiasi leuntone bolauwo anton. ");
INSERT INTO soq_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ware ene leuntone antoieno aupo Tatamba enseliwa auwen bedewe Iosep mampe segalene diene wanase, “Erod menasadia oto ema banusapie bosapia baiwaleide. Sa baiwa tauwadea enawie oto inawa do otamoe aitana Isibt bedewe wankasaitana ita ne dialepo ruawa leuitane winlena.” ");
INSERT INTO soq_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Tatamba enseliwa Iosep diena rua tadina sawo me itu bedewe enenwisene oto inawa benemasano eteno mo oto wadane bola waimoia ene Isibt bedewe antoiena. ");
INSERT INTO soq_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Mo sape wimone waimompo ideita Erod bolepi. Mo Isibt bedewe antoiena, sa ipa dima mapo God perowetawa moawe wana ulaipalen. Peroweta ema epe wane wanase, “Ne Otona apasana Isibt epiiepie nosepi.” ");
INSERT INTO soq_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Erod oto gagalowa anuwa wandi lewalene meba insene atenlen ware apanawa me lagasane ene antone wankasanton, sa baiwa me nuawa kadiidaleno wandie. Ita me nuawa kadiidaleno osowe sorodiawa waaubamona Beteliemwa antopue otooto mona sanaa uduudu sape muntoia ita ena nata bedewe waimoia epaboiamopu. Erod ware apanawa mampo warere debamawa kiporawa eweiena omowa etene atenlene enawa ruawalene otooto mona sa epaboiamon. ");
INSERT INTO soq_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Erod ema dewasana, sa ipa dima peroweta Ieremaia wana ulaipalen. Me wane wanase, ");
INSERT INTO soq_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Rama apanawa nuaparepare kewa debamawa etei, sa ipa Reitel anoanopa obampu bomoiena keu debamaia waio etei. Mo obampu ewasumone kewa waie os waimoi, mai eipona, ita mida wasau moipe oniamoipona mai menamoipona, dia.” ");
INSERT INTO soq_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Erod boleno aupe Iosep Isibt bedewe wandio Tatamba enseliwa tadina dea auwen bedewe me mampe segalene diene wanase, ");
INSERT INTO soq_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Mo mida oto bosapona menamona bontoiena, sa baiwa e enawie Meri oto do otamoe leuitane aitana Israel bedewe.” ");
INSERT INTO soq_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Tatamba enseliwa Iosep diena rua me enenwisene Meri nata oto otamone leuntone Israel bedewe antoiena. ");
INSERT INTO soq_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Tane Erod boleno aupe me otopa Akeleus Iudia oniedi wandie. Tane mo antoie into Iosep ema umanawa etene Iudia awa saidalene dabualen. Me sape awa inguguraleidio Tatamba auwen bedewe diena mai leulepie Iudiawo alepi, dia. Ita me ene Galiliwa alene ");
INSERT INTO soq_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","bola Nasaret bedewe wankasalen. Ema segalena dima God perowetawa waiena ulaipalen. Mo wane waienase, “Mo Keriso umanawa wampa me Nasaret apanawa.” ");
INSERT INTO soq_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ion Babatutu nolawa uwaalene sala makowa Iudia bedewe alene God aiawa amonaleidie wane wanase, ");
INSERT INTO soq_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“E insaisala leusane kadila ene dodomanaitana, ipawa God gonaawa tauma maidalen!” ");
INSERT INTO soq_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Peroweta Aisaia mapo Ion umanawa wane wanase, “Apana dea sala makowa bedewe mukama benema- leidie wadiase, ‘Tatamba wimpia baiwa inta eusana, dewa uduudu inta enabodamodia otawiaitane nambemona!’” ");
INSERT INTO soq_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ion gara pue kamel imba dewala taudie ita do iga pue etepa mampe dewasaiena nowe taune wandi leidie. Tane nanawa kapoi ita awanai namodi wandie. ");
INSERT INTO soq_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ierusalem ita Iudia bedeuwo wanwanlala tane do esa Ioadan tampe wanwanlala Ion mampe wimoiena. ");
INSERT INTO soq_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Mo kadiu wawiantono ita Ion mo esa Ioadan bedewe babatutumon. ");
INSERT INTO soq_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Parisi ita Sadusi apanawa uara Ion mampe babatutu baiwa wimono ewamone nuawa kadileno diamone wanase, “E mota obampaida wainilana! E inseilana babatutuitano God nuasigasigawa mai e osolawo iepie kadilepi, ba? Mida epe dialeno rua mainawo ieilana? ");
INSERT INTO soq_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","E dewala euda dewamonuna mampe sabamoitana e kadila eidamole God mampe dodomanaitene wainilana. ");
INSERT INTO soq_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","E inseile sumanaitile wailanase, ‘Abraam no mamambaida. No me bedewea wainitana baiwa God mai matangelanepie kadinepi, dia.’ E mai epe insenakadisana! E mai Abraam obampaida wanaitape wanleipona, dia! E mamalaida Abraam wailana, tane me dewawaida mai wadapona! Ne dialedina God muka wadena e dabualepie seu sa wineio eweilana mampe Abraam nosinosiwaida da dewamopio segantopue waimompa. ");
INSERT INTO soq_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","No ia naunaula rua wainitana. Ita God ia nausiawaia uduudu ba ia isiwa naukadisantoie ipau kapisantoia toiamopitue ia iilala bedewe aubamopituwapi. Tane me aitamana widi wadene ia sa osouwosane itunimaae wande, mai dia. Sa baiwa e God mampe dodomanaitana umanawa dialedina.” ");
INSERT INTO soq_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Tane Ion meba umanawa wadewasamone wanase, “Ne winene esa mampe babatutuledine e insaisala leusane God mampe dodomanaitana baiwa. Tane mida ne wanawo e manlawo wisepia, me ipa mukamukauaida, me Aleu kakaiwa mampe ita ia idie bumedia mampe e babatutulepi. Me ipa debamawaida ne atoweidontene wainedina, ita ne mai ruana me sendorowa taumodia otawiantape awanamopa, dia. ");
INSERT INTO soq_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Me dogo pokewa wadepie wimpie wit topuiamone auweno wineia emposimopie uwakokomopio ipawaida bolawe nomopue winapu ita sewa nambemopitu- wapi. Aupe me wit ipawaida adiba bolawe adibamopituwapio winakasantopu, tane wit sewa ia iikasalala bedewe aubamopio imopituwapi.” ");
INSERT INTO soq_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Walama sawo Iesu Galili ene esa Ioadanwa wisen Ion me babatutusapia baiwa. ");
INSERT INTO soq_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Tane Ion me ewene inguguralene wanase, “E ne babatutuneapona, tane dima baiwa ne dianeiana e babatutuepa?” ");
INSERT INTO soq_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Tane Iesu me sipoasane wanase, “Dima ne dieedina rua dewasaa, ita ema mampe dima uduudu God menasadia no dewasaipona ideita dewasata.” Sa baiwa Ion Iesu aiawa ruawalene me babatutusan. ");
INSERT INTO soq_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Iesu babatutuleno dialeno tauwadea os esa bedewe enenwiseno uba siolene wadenauben ita Aleu kakaiwa ewaewawa nene bunebune rua ewedio me osowe iene wain. ");
INSERT INTO soq_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Tauma aia uboo segalene wanase, “Ema ipa ne Otonaida, ne nuawadawadaidasadina, nuana eusadio wainedina.” ");
INSERT INTO soq_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ema aupe Aleu kakaiwa Iesu banleno sala makowa bedewe alen, kadi mamba Seitan me rubusapia baiwa. ");
INSERT INTO soq_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Me nana mai napona walama 40 ita tadina 40 dialen, sa baiwa Iesu omanatoidasan. ");
INSERT INTO soq_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ita kadi mamba Seitan me mampe wisene diene wanase, “Naita e God Otopaida seu emanta diawo bured wanalepio nae nuaa topi.” ");
INSERT INTO soq_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Tane Iesu leusane wanase, “Buka bedewe girumalene ema epe wade, ‘Apana mai bured os tounawe wampua rua, dia! Tane inawaa waimompaa baiwa apana ideita God aiawa dima uduudu me moawe wadio nosedia tounawe waimompa.’” ");
INSERT INTO soq_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ema aupe Seitan Iesu banlene wadi sa ene Ierusalemwa, sa ipa God bolawa kakaiwa, alene God duwa iwa ionoidolena osowe banleno alene enen. ");
INSERT INTO soq_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ita Seitan Iesu diene wanase, “Naita e God Otopaida mape eneianawoe eba aubaubaite iee aitaa! E mai kadiwa da donsaa, dia, ipawa buka bedewe girumalene ema epe wade, ‘God enseliwa e umanaa diamopio e oniadewasa- empo kadiwa mai donsaa, dia. Naita bagora da e manawolempa God enseliwa e waa seu osowe epamoa sawa awanaepue antopu.’” ");
INSERT INTO soq_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Tane Iesu Seitan aiawa sipoa wabodasane wanase, “Buka bedewe do girumalene ema epe wade, ‘E Tataa God mai rubu osowe itue me mukawa ba ginasawa ewaa baiwaite diaa, diaida!’” ");
INSERT INTO soq_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Iesu ema wano aupe Seitan me banlene wadi iwa osowe odene alene tawo mukawa ita tawo ewanuauwa daitada euwasano ewen. ");
INSERT INTO soq_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ita kadi mamba Seitan Iesu diene wanase, “Ne wana bumpe e imina emmisite ne wadaposinea dewa uduudu ema eweiana ne eneepatuwapi.” ");
INSERT INTO soq_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Tane Iesu wabodasane diene wanase, “Seitan, nambe aitaa! Buka bedewe girumalene ema epe wade, ‘E Tataa God os mampe insaisaa itune wadaposi- sane simbiasane wanempa, mai mida da, dia!’” ");
INSERT INTO soq_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Tauma Seitan Iesu eno aupe ensel nomone oniene simbiasaiena. ");
INSERT INTO soq_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ion Babatutu dibura bedewe ituieno umanawa Iesu etene Iudia ene leulene alen Galiliwa. ");
INSERT INTO soq_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Me mai Galili bolawa Nasaret bedewe wampona, dia, tane alene Kapeanaumwa wandie. Bola sa ipa doa Galili tampe Sebulun ita Napitali bedeuwo. ");
INSERT INTO soq_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Iesu bola sawo wandia, sa ipa dima peroweta Aisaia wana ulaipalepia baiwa. Peroweta wane wanase, ");
INSERT INTO soq_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sebulun ita Napitali, e doa Galili tampe Ioadan esawa waiwa dawo wineilana. E ipa bola debamau Galili bedewe naepe Iuswa ita uwa daitada apanawa do waimoia. E Galili apanawa ne asisuneana! ");
INSERT INTO soq_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Apana mida dubawa bedewe waimoia sapa debamaia ewei, ita mida God mai atensapona bolala rua waimoia osouwo sapa wade.” ");
INSERT INTO soq_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ita walama sawo Iesu uwaalene God aiawa amonaleidie wanase, “E kadi bedewe insaisala leusane kadiwa ene dodomanaitana, ipawa God gonaawa tauma maidalen!” ");
INSERT INTO soq_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Iesu doa Galili waiwainta aleidie me apana wamba nata lawaintoio ewamon, dea ipa Saimon, ebowa da waia Pita, ita me wamba Endru. Mo nata bouri lawailala ita mo lawaibu doa bedewe aubamone eneio ewamone ");
INSERT INTO soq_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","diamone wanase, “Winlene ne waroroneana, ita ne dewalepo apana lawaimonuna.” ");
INSERT INTO soq_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Me epe diamona rua tauwadea lawaibu emone Iesu warorosane do antoiena. ");
INSERT INTO soq_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ita Iesu doa tampe aleidie Sebedi obampa nata dommon, mo ebou ipa Iems ita Ion. Mo nata mambu do waa bedewe lawaibu imaasaie waimoio Iesu ewamone ita apamon wimpue warorosapua baiwa. ");
INSERT INTO soq_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Mo Iesu aiawa etane tauwadea os waau ita mambu do emone Iesu wawe antoiena. ");
INSERT INTO soq_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Tane Iesu Galili bolawa uduudu bedewainta alene gagalo dubu bedeuwointa waeuwaleidie, ita Gagalo euda God gonaawa umanawa amonaleidie. Do me apana kerolala ita poka daitada etaetalala inamodie leidie. ");
INSERT INTO soq_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ita Iesu benemawa sape debamalene Siria tawowa uduudu bedewe alentuwan. Sa baiwa apana sosou kerolala, poka daitada wadamodia, apana bedeuwo aleu kadiwa wanwanlala, bosulala isiwa ita apana tampu bobopa banlamone Iesu mampe wimono inamon. ");
INSERT INTO soq_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Iesu epe nolaleidie leidio apana uaraia me wawe antoiena, mo ipa Galiliwa ita bola Dekapolis bedewe wanwanlala, do Ierusalem ita Iudia apanawa, ita Ioadan esa waiwa dawo wanwanlala. ");
INSERT INTO soq_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Iesu apana sa uara me wawe ieio ewamone ene wadiwa odene alen. Sape me aisidene waino wawe alala wimone waine paneiena. ");
INSERT INTO soq_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Me gagalo uwaalene mo diamone wanase, ");
INSERT INTO soq_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Apana mida nuau uduudu mampe God sauwa euda menamodia nuaeuntompa, ipawa God gonaawa mo mampoa. ");
INSERT INTO soq_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Apana mida nuau bedewe kekeleidia nuaeuntompa, ipawa God mo roamopi. ");
INSERT INTO soq_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Apana mida molaaisiwa waimoia nuaeuntompa, ipawa God dima saualena mo donsapue wadapu. ");
INSERT INTO soq_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Apana mida God insaisawa dodomana segalepona baiwa insaisantoie nuau uduudu mampe menamodio waimoia nuaeuntompa, ipawa dima mo menaidamodia ando segalepi, ita mo pokamompo waimompa. ");
INSERT INTO soq_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Apana mida sosou nuapareuntoie saumoia nua euntompa, ipawa God mo do ando nuapareulepie saumopi. ");
INSERT INTO soq_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Apana mida nuau uduudu mampe God banusaia nuaeuntompa, ipawa mo ando God ibuwaida ewapu, mai dia. ");
INSERT INTO soq_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Apana mida sosou adiananantoie waimoio saumoie apana sa wanwambu dodomanasaio dealeidia, mo ipa nuaeuntompa, ipawa God mo ebou wapi wapiase, ‘Ne obainaida.’ ");
INSERT INTO soq_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Apana mida God simbiasaie me insaisawa os dewasaie waimoio baiwa mo sosou emalawoamoie kadimoia nuaeuntompa, ipawa God gonaawa mo mampoa. ");
INSERT INTO soq_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","E ne waroroneilana baiwa apana aia kadiwa mampe wadabualempe emalawoalempa ita laga daitada mampe di wawulempa e sau euda wadalana apanawa wainilana. ");
INSERT INTO soq_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Mo e nibualempe dabualempa, sa ipa mo peroweta mampo mapo dewasaiena rua e manlawo dewasai. Mo e manlawo epe dewantompo e nuaeuidaitana, ipawa e unela debamaia imaalene uboo winedia wadana, mai dia.” ");
INSERT INTO soq_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“E ipa aideba rua tawo apanawa mampo. Tane naita aideba daawa dialepia, ambi dewasawo osowe daa wapi? Aideba daasia winedia mai nolawa da wineipona, di winakoaleide, aubaubala. ");
INSERT INTO soq_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","E ipa tawo sapawa wainilana. Ita bola wadi iwa osowe sabamo winedio apana uduudu eweia rua tawo apanawa e sapala ewapu, mai weregalepia rua, dia. ");
INSERT INTO soq_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Mai mida siwa suipe onta atowe weregasaipe ituipona, dia. Tane me ideita siwa sudie sabamo enaenawa bolawe itude apana me duwe waimoia sapa bedewe waimompaa baiwa. ");
INSERT INTO soq_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Epe rua deawaa e sapala mai weregasana, dia, tane eno sapa sa apana mampo sapa wapi. E epe dewaitonuno mo e dewala eubu ewapue ita e Mamala uboo wandia ebowa wadaposisapue sapaidasapu.” ");
INSERT INTO soq_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Mai insenase, ne dima anaana ba peroweta bukawa bedewe girumamona ipasia- mopaa baiwa wineapona. Ne mai dima buka bedewe girumalena ipasiasapaa baiwa wineapona, dia, tane ne ipawaida sabamosape ipawanasapaa baiwa winen. ");
INSERT INTO soq_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ne ulaipa dialedina, uba ita tawo diantopu, tane bauta giruma debama ita kerakera anaana bedewe girumalena mai ipusiantopu, ideita segantopu. ");
INSERT INTO soq_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Apana mida anaana kerauda da andipundedie ita sosowa isiwa deawaa waeuwamodio me ruawantoia, me ipa keraudaida God gonaawa bedewe, mai apana isiwa ruau. Tane apana mida anaana ema ruauleidie ita sosowa isiwa deawaa waeuwamodio me ruawantoia, me ipa debamawaida God gonaawa bedewe. ");
INSERT INTO soq_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ne epe dialedina, ipawa e Parisi ita anaana waeuwalala dewau rua dewaitana e mai God gonaawa bedewe odana rua, dia! Tane e God insaisawa rua dodomana os dewasanune Parisi dewau ainaboe e God gonaawa bedewe odana.” ");
INSERT INTO soq_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Dima mapo e nosinosila anaana girumala benemamoieno eteiena e etale ateiten. Anaana ipa wadi wadiase, ‘Mai soa bosaa, tane mida me sowa bosadia, me wadapue kotusapu.’ ");
INSERT INTO soq_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Tane ne tauma ema epe dialedina: ‘Mida me sowa nuakadisadia me wadapue kotusapu.’ Tane do mida me sowa wadabuasadie wadiase, ‘E apana diapanaida!’ Mo apana sa wadapuo kotu debama bedewe alepi. Ita mida nuawa kadileidio sowa wadabuasadie wadiase, ‘E apana oopa!’ apana sa wadapuo ia iilalawo alepi. ");
INSERT INTO soq_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Sa baiwa e amonaa pulo bolawa osowe itutuwa baiwaitone ita sape e soa nuawa kadisaana insea, ");
INSERT INTO soq_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","e puloa nambe itue ee, ita bauta aitee soa nata dodomanaitane aupe leuite wine puloa itua. ");
INSERT INTO soq_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Naita apana da e wadeepie kotu baiwa nata aitonune intasino tauwadea gagalo dodomanasaa me mampe. E mai epe dewaitaa me e banlaepio dodomana kotu apanawa mampe aitana. Tane me e dibura onioniala witapeepi, ita me e dibura bedewe ituepi. ");
INSERT INTO soq_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ne diaidaedina, e sape wanempe mai di noe aitaa, tane ideita e mane ompa mo dieiena rua ituaubee, tauma dibura ee noe aitaa.” ");
INSERT INTO soq_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Dima mapo e nosinosila anaana girumala benemamoieno eteiena e etale ateiten. Anaana ipa wadi wadiase, ‘Mai ninaitaa!’ ");
INSERT INTO soq_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Tane ne tauma ema epe dialedina: Apana mida me sowa manainapa ewedie itusa- pona baiwa nuawa pola wadia, sa ipa me ninaleide. ");
INSERT INTO soq_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Naita e emaa on deneuwe winedia e banlaepio kadi dewasaa, emaa sa enasopoe aubewo alepi! E emaa dea os do God gonaawa bedewe odaa, sa ide. Tane mai ide e emaa nata do bola kadiwa bedewe aubaepu. ");
INSERT INTO soq_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Naita e witaa on banlaepio kadi dewasaa, witaa sa toapune aubewo alepi. E witaa dea os do inawinakasalawo odaa, sa ide. Tane mai ide e etea uduudu do bola kadiwa bedewe aitaa.” ");
INSERT INTO soq_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Tane do e gagalo ema etale ateiten, wadi wadiase, ‘Apana mida me manainapa dabuasapie eewa baiwalempa, me ee gagalowa girumalepie i wanepie do wapiaubepio alepi.’ ");
INSERT INTO soq_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Tane ne tauma ema epe dialedina: Apana mida manainapa dabuasadie wadiaubedio aleidie apana da naisedia, i sa ipa ninaleide, tane wanaubena apanawa me wano i ninaleide. Ita apana mida i nainai ena naisedia, sa ipa me ninaleide.” Tane naita i nainaila alepie apana da nata ninantopua, badawa i epio alepia rua. ");
INSERT INTO soq_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Dima mapo e nosinosila anaana girumala benemamoieno eteiena e etale ateiten. Anaana ipa wadi wadiase, ‘Mai insaisa da baiwa God ebowa wae lagaitaa, tane dima e God emawe sauaitena ruawa dewasaa.’ ");
INSERT INTO soq_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Tane ne tauma ema epe dialedina: Mai insaisa da baiwa kangoraitaa, diaida! Mai uba ebowa wae mampe soa kangorasaa, dia, ipawa uba ipa God kolaiwatawa! ");
INSERT INTO soq_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Mai tawo nituwa da ebowa wae mampe soa kangorasaa, ipawa tawo ipa God wawa eimpadodempaa bolawa. Ita mai Ierusalem ebowa wae mampe soa kangorasaa, ipawa bola sa ipa warere debama God bolawaida. ");
INSERT INTO soq_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Tane do mai e iwaidua umanawa wae mampe soa kangorasaa, ipawa God e uwaa dewasan, ita e mai uwaa imba dea da sapusapua ba dubawa dewasapona rua, dia. ");
INSERT INTO soq_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Sa baiwa e aia ema os wanuna, ‘Oa’ ba ‘Dia’, sa ide. Tane e kangoraitana, aia sa ipa kadi mamba Seitan mampe wisedio wailana. ");
INSERT INTO soq_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Tane e gagalo ema do etalana wadi wadiase, ‘E soa emawa dea enasopodepia, sipoa e emaa dea do empusopodepi. Tane e soa moa nepa dea epaatewapia, sipoa e moa nepa dea do epaputewapi.’ ");
INSERT INTO soq_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Tane ne tauma ema epe dialedina: Apana mida e manawo kadiwa dewasapia mai kadiwa mampe sipoasaa, dia! Tane ema epe dewaitaa: Apana mida sainaa epedie wadiase, ‘E ipasiawaia,’ me ewo sainaa da do epepi. ");
INSERT INTO soq_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Tane apana mida gara osowe kotuepia gara sa ita gara sanaa do wade wanaa, mai wadaitudepi! ");
INSERT INTO soq_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Apana da wisepie dieepi wapiase, ‘Ne saina ema awanewo antate nowa dawo enea,’ e me saiwa sa awanee bola sa me umanawa wana anaboe bola da bedewe noe ea. ");
INSERT INTO soq_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Apana mida nitu da baiwa e manawo iririwalepia wade wanaa, ita mida e nitua da umanawa wampa wade wanaa, mai dabuaite ea.” ");
INSERT INTO soq_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Tane e gagalo ema do etalana wadiase, ‘Soa tanawoa nuawadawadasaa, tane emalawoa apanawa nibuasaa.’ ");
INSERT INTO soq_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Tane ne tauma ema epe dialedina: Emalawoala apanawa nuawadawadamona ita mida e kadileia baibu rauparitane sau euda osouwo ituna. ");
INSERT INTO soq_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","E epe dewaitonuno apana ewalepue insepu e ipa Mamamba uboa obampa me dewawa ruawaitilana. Ita me dewawa ema epe: Me omo dewasadio wisedie apana eubu ita kadiu do osouwo sapa wade, ita do me unu wadiaubedio apana kadiu ita dodomanau osouwo nosede. E me ruawaitane emalawoala apanawa nuawadawadamona. ");
INSERT INTO soq_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Naita e takis manewa tamalala dewantoia ruau apana nuawadawadaleia os nuawadawadamonuna, e inseilana God mampe e unela wadana, ba? Diaida! ");
INSERT INTO soq_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Naita e sumanaisiawaia apanawa dewantoia ruau e sosolaida os auwadewasamonune manlawomonuna, e inseilana God mampe e unela wadana, ba? Diaida! ");
INSERT INTO soq_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Tane e Mamala uboo dewa euda dodomana os dewamodie wandia rua e apana uduudu mampo euda dodomana os dewasanune wanlempa.” ");
INSERT INTO soq_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Ewanadewaitana, God sumanaiwaitilana nolawa mai sabamo apana uduudu ewalepua baiwa dewasana, diaida. E naita sabamo dewasana, e Mamala uboo wandia mai unela da enalepi, dia! ");
INSERT INTO soq_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","E nuaparelala nitu da wanamonune mai sabamo asowawa debama dewasano apana uduudu ewalepu, dia. E apana lagawaauida gagalo duwa bedewe ita do intanowainta apana uduudu asou wampaa baiwa epe dewantoie waimoia mai ruauitana, dia. Ne ulaipa dialedina, mo apana mampo asowawa debamawa wadane waimoi, sa ipa mo uneu, ita God mampe mo mai uneu da winedia wadapu, dia. ");
INSERT INTO soq_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Tane e nuaparelala saumonune nitu da wanawanau menalempa niabointa wanamona, mai mida da atenlepi, dia! ");
INSERT INTO soq_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","E niabointa epe nanaitonuno e Mamala mida niabola sa uduudu dewamoilana ewedituwadia unela enalepi, mai dia. ");
INSERT INTO soq_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","E rauparitonune mai apana lagawaauida ruauitana! Mo dewau ipa ema epe: Mo apana uduudu ewamompaa baiwa gagalo duwa bedewe do intanowainta sabamo rauparintoi. Ne ulaipa dialedina, mo apana mampo asowawa debamawa wadane waimoi, sa ipa mo uneu, ita God mampe mo mai uneu da winedia wadapu, dia! ");
INSERT INTO soq_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","E mai mo dewau ruauitana, diaida! E raupari baiwaitonune dula bedewe odane aitane du moawa guduitane ita e eba niaboa waine Mamala God ewasiawaia mampe rauparitana. Ita e Mamala dima niaboa dewasailano ewedituwadia unela enalepi, mai dia. ");
INSERT INTO soq_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Do rauparitonune mai aia ipusiawaia uara osoweosowe wamonuna, apana mida God mai atentoipona ruau. Mo epe rauparintoia, ipawa mo inseiase raupari daumaia osoweosowe wampo mo godiu etamopi. ");
INSERT INTO soq_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","E mai mo dewantoia ruauitane osoweosowe dima menaledia God dionuna, dia! E dima uduudu menaledia iririwaitapona Mamala atemba os wande, mai dia. ");
INSERT INTO soq_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","E raupari baiwaitonune ema epe rauparitana: ‘Mako, e uboo wanwanlala, e eboa kakaisaipe wainipona. ");
INSERT INTO soq_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","E gonaa wisepona, ita e insaisaa uboo segaleidituwadia ruawa tawo osowe segaleipona. ");
INSERT INTO soq_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Walama ruawaitone nanamba menanedia nenona. ");
INSERT INTO soq_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ita no kadiwamba inseadabuasaa, no sosomba kadiwa mainimbo dewasaiena inseitadabuasaitana rua. ");
INSERT INTO soq_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Tane mai rubu bedewe itunea, kadi mamba nanausinepia sawa no oniadewasanena.’ ");
INSERT INTO soq_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Naita sosola kadiwa manlawo dewasaia insenadabuasana e Mamala uboo wandia do kadila insepidabuasapi. ");
INSERT INTO soq_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Tane naita sosola kadiu mai insenadabuasana, deawaa e Mamala e kadila mai insempadabuasampa, dia! ");
INSERT INTO soq_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","E iditonune mai apana lagawaauida dewantoia rua nuapareitilana eueuwa sabamosana. Mo idintoie mai etepu oniadewasasaipe benadewantoipona, dia. Apana uduudu mo idintoia ewapue atentopua baiwa benasia di waimoi. Ne ulaipa dialedina, God mai mo uneu da wanamopi, dia. Ipawa mo aitamana apana mampo asowawa wadeiena, sa ipa mo uneu. ");
INSERT INTO soq_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Tane e iditonune nanla mitonune uwala sinataitonune benaitonune euda os wanlempa. ");
INSERT INTO soq_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","E epe dewaitonuno apana mai atentopu e apa iditilana, tane e Mamala os ewalepi. Ita e Mamala mida niabola uduudu ewedia e unela enalepi.” ");
INSERT INTO soq_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Mai tawo osowe adibala uwataubu eba baila adibaitana naepe lalaa adibala kadisapu, ba puraiwa adibaitena ninintopue kadintopua, ita do poiwaa adiba duwa epauke odapue pointopu. ");
INSERT INTO soq_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Tane adibala uwatauwa eba baila uboo adibaitana, naepe lalaa mai adibala kadisapu, ba puraiwa adibalala ninintopue kadintopua. Sape poiwaa adiba duwa mai epauke odapue pointopua rua, dia. ");
INSERT INTO soq_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","E epe dewasanuna, ipawa naepe e adibala uwatauwa winedia e nuala uduudu do inta sape.” ");
INSERT INTO soq_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Apana emawa ipa etepa siwawa winedie nuawa sapasade. Naita e emala euda winompa sapa wadedie bedelawosadie etela uduudu sapasadituwadio wainilana. ");
INSERT INTO soq_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Tane naita e emala kadilepia e etela uduudu ipa iwinidalepi. Naita e emala kadilepia sapa mai e bedelawolepia rua, ita e nuala dubaidalepi!” ");
INSERT INTO soq_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Nola dewalala dea mai apana debamau nata nolau dewasapia rua, diaida! Me apana debama dea nibuasapie ita da nuawadawadasapi, me da baiwaidalepie nolawalepi, tane apana debama da nolawa dewawa dabualepi. Deawaa, e mai God simbiasanune bedewe mane nuawadawadawa taudolepio awodea nolau dewasana rua, diaida! ");
INSERT INTO soq_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Maura debama bedewe mai inaida wineipona, dia. Sa baiwa ne ema epe wasaulepa: Nana, ba gara menaledia osowe wampona baiwa mai nuala pola wapi, dia. Nana ita gara ipa debamau ete sauwa baiwa, tane e inawala, sa ipa debamawaida, mai ete insaisawa rua. ");
INSERT INTO soq_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","E nene ewamone insena, mo mai lawuru naumba aimoipona ba uwauwantoipe auweipe adibantoipona, dia. E Mamala uboo wandia oniamodie nana wanamode. Tane God emawe e ipa debamawaida, mai nene ruau! ");
INSERT INTO soq_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","E inseilana nuala pola wampo bedewe e inawala kerauda os daumalepona rua, ba? Diaida! ");
INSERT INTO soq_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Dima baiwa gara mampe nuala pola wade? Dobina beraniwa inintoia ewamone insena: Mo mai muba garau dewamoipona, dia! ");
INSERT INTO soq_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Warere Solomon dewa uduudu mampe rua os ita gara eubu taumodie wandie. Tane ne dialedina dobina beraniwa ipa eubuida, mai Solomon garawa taudie benaleidia rua. ");
INSERT INTO soq_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","E sumanaila God mampe ipa keraulen! Beran uduudu ande inintoia ita imonepi ia bedewe imopituwapi, tane God dewamodio ewaewau euleide. Deawaa, me ideita e garala enalempa, ipawa e debamawaida God emawe, mai beran ruau! ");
INSERT INTO soq_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Sa baiwa mai nuala pola wapio insenase, ‘No dima napona?’ ba, ‘No gara dainea taupona?’ ");
INSERT INTO soq_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Apana mida God mai atentoipona mo walama uduudu nitu ema insaisawantoie lai. E Mamala uboo wandia e nitu ema uduudu menaledia atembaida. ");
INSERT INTO soq_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Tane e bauta God gonaawa insaisawaitonuna do dima God menasadia baiwaitonuna, ita me nitu uduudu e menaledia enalempa. ");
INSERT INTO soq_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Sa baiwa dima imonepi menalempaa baiwa mai ande nuala pola wapi! Ande nuabolawa mai imonepi nuabolawa dosana, dia!” ");
INSERT INTO soq_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“E sosola da dima dewasapukadisapuo e mai enitumone kotumone ituaisimona, God e kadila dewasailana enitulepie kotulepia sawa. ");
INSERT INTO soq_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ne epe dialedina, ipawa e apana enitumoilana rua God e enitulepie kotulepi, ita God dima e sosola mampo dewasailana ruawalepie manlawo dewasapi. ");
INSERT INTO soq_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","E lagaitie wainiana, soa emawe popokau wineia ewamoe gagalowa waie badowa dieie wainiana. Tane eba emaawo e enedio mai eweipe ateitipe insaisawa da wadeipona, dia. ");
INSERT INTO soq_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","E soa dieie waianase, ‘Sona, e wanwana bagoraleidio ewane winen, wasauepaa menanede, kadi ema manawo ewedina wadaaubea.’ Ambi e soa da epe wasausaie dieiana, tane e emaawo e enedia insaisawa da mai wadeipona? ");
INSERT INTO soq_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","E lagawaaida wainiana! Bauta eba emaawo e enedia boaube euitee, tauma aite soa emawe popokau wineia suwiaitaa. ");
INSERT INTO soq_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Nitu kakaila euda e manlawoa mai duba apanawa wanamona. E epe dewaitonuna, sa ipa ewaewa abo nitu kakaila euda elo wanamoipona, ba posarula bono mampo aubeipona rua. Naita e nitula da euda elo ba bono mampo aubena elo ba bono wimpue nitula sa euda ansisisapue epue e bailantopue adalepue siosawialepu.” ");
INSERT INTO soq_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“E dima meneedia baiwa God iririsawo eneepi, banusae donsaa, kekesaraitawo ita du moawa wadepiaubepi e manawo. ");
INSERT INTO soq_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ipawa mida iririleidia wadede, tane mida banusadia donsade, ita mida kekesaraleidia du moawa wadediaubede me mampe. ");
INSERT INTO soq_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Oto enape mamba bured baiwa iririsaipono e inseilana mamba seu wadape wanapona, ba? ");
INSERT INTO soq_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ita oto bouri baiwa mamba iririsaipono me mota wadape wanapona, ba? ");
INSERT INTO soq_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","E kadi dewalala wainilana, tane amona dewawa ateitene obanla iririleia amona euda ruawaitile wanamoilana. E kadi dewalala amonala eulen ita inseilana Mamala uboo wanwanlala amona dewawa atensasia wande, ba? Sa dia, me amona mambaida wande, mai e ruala. Sa baiwa mida God iririsaia me ideita amona euda wanamopi, mai dia! ");
INSERT INTO soq_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Dima uduudu e menaledia sosola manlawo dewasaipe oniadewasaleipono nuaeuwaitipona, e mo mampo uduudu sa insamoilana eueuwa dewamonuno nuaeuwantompe waimompa! E epe dewasanuna, sa ipa e dima anaana bukawa bedewe girumalena ita peroweta waeuwau uduudu ruawaitile dewasailatuwade.” ");
INSERT INTO soq_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","E God gonaawa moawa kerauda bedewainta odane inta kerauda awa badowaida asiasi inawinakasala bedewe aitana! Apana nata os inta sa asiasi antoi. Tane apana uaraia du moawa debamawa bedewainta odane inta debama awa tekateka asiasi bola kadiwaida bedewe antoi.” ");
INSERT INTO soq_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Ewanadewaitana peroweta lagawaau mampo! Mo e manlawo wimopu ewaewau abo sipsip onadina ruau, tane mo ipa elo kadiwa onawaauida. ");
INSERT INTO soq_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mo dewau mampe ewane ateitana mo apana inainambu dainea. Ia gedaragedaraua mai ipawa euda naupia rua, dia. Deawaa, elobudubudu inileidia osowe mai korou ipawa naupia rua, dia. ");
INSERT INTO soq_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ia euda naunauwa euda os naude, tane ia kadiwa naunauwa kadiwa os naude. ");
INSERT INTO soq_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ia euda mai naunauwa kadiwa nauipona, dia. Deawaa, ia kadiwa mai naunauwa euda nauipona, dia. ");
INSERT INTO soq_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Tane ia uduudu mai nauipadewantoipona topuiamoie ia iilala bedewe aubamoi. ");
INSERT INTO soq_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Epe rua peroweta lagawaau naunaubu mampe ewane ateitana.” ");
INSERT INTO soq_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Mai apana uduudu mida ne ebona waie waiase, ‘Tatamba, Tatamba’ God gonaawa bedewe odapu, dia. Tane apana mida ne Mamana uboo wandia insaisawa rua dewasaia, mo os God gonaawa bedewe odapu. ");
INSERT INTO soq_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ompa osowe kotu walamawa wisepio apana uara ne dianeapue wapuase, ‘Tatamba, Tatamba, no nolamba benemawaeto etaa! No Gagalo euda e eboawo amonantite leite, ita e eboawo aleu kadiwa uara apana bedeuwo waimoia tanamotano nomone anton, ita do ginasa uaraia e eboawo dewamotana.’ ");
INSERT INTO soq_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Tane ne mo diamope wapaase, ‘E kadiwaida dewalala, ne e mai atenlepona, eneane nambeido aitana!’” ");
INSERT INTO soq_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Apana mida ne aiana etedie ruawaleidia, me ipa insadewasala apanawa mida duwa wadedie don toidasadie unsia seu mampe gunaleidia rua. ");
INSERT INTO soq_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Unu debama wano abaia nosen ita lanunu debama du sa badowa epeno, tane mai bioudepona, dia. Ipawa du sa dogoida osowe wadene seu mampe gunadewalen. ");
INSERT INTO soq_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Tane apana mida ne aiana mai eteipe ruawaleipona, me ipa mai insadewasala apanawa mida duwa nela osowe wadedia rua. ");
INSERT INTO soq_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Unu debama wano abaia nosen ita lanunu debama du sa badowa epeno rebarebaida bioudene kadiidalen.” ");
INSERT INTO soq_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Tane Iesu ema umanawa wane diasadio apana uara me waeuwawa mampe memesanton. Ipawa me muka do waeuwaleidie, mai anaana waeuwalala ruau waeuwaleipe, dia. ");
INSERT INTO soq_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Iesu wadiwae iene wiseno apana uaraia me warorosane do antoiena. ");
INSERT INTO soq_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ita sape apana kito wadawadalala Iesu mampe wisene me wawa bumpe imimpa emmisilene diene wanase, “Tatamba, naita e meneempa e rua os ne inanea!” ");
INSERT INTO soq_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Me epe iririsano Iesu me ibuwa wadene diene wanase, “Ne sauepaa menanede, inaitaa!” Me epe wano tauwadea kito etepa uduudu osowelena diantono inalen. ");
INSERT INTO soq_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ita Iesu me diene wanase, “E inaitena umanawa mai apana da diamoa, dia, tane dodomana aite pirisi mampe etea euwasawo ewepi. Muriwa Moses anaanawa wana rua e inaitena pulowa ituno apana ewapue atentopu e inaitene euiten, God duwe aitaa rua.” ");
INSERT INTO soq_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Iesu Kapeanaum bedewe odedio Rom sorodiawa debama me mampe wisene sau baiwa iririsane wane wanase, ");
INSERT INTO soq_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Sona, ne nolana dewalala kero wadeno dunawo ituleide. Me etepa mai tepala, dainawa di winede ita do pokaida etede.” ");
INSERT INTO soq_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ita Iesu me diene wanase, “Ne anteape me inasapa.” ");
INSERT INTO soq_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Tane Rom sorodiawa debama leusane wanase, “Debamana, ne mai apana euda wainipona ita e wine dunawo odaa, dia. E nambe enee aia os wawo ne nolana dewalala inalepi. ");
INSERT INTO soq_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ne apana nola baiwa empuitue diapuo dewasapia ateina wainedina. Ne sorodia debamau onanawoa dianeio ruauntedine nolantedina. Ita ne sorodiana atonawo waimoia dima diamodina ruawantoie nolantoi, mai eipona, dia. Ne sorodiana dea diape wapaase, ‘E aitaa!’ me aiana ruawalepie alepi, mai eipona, dia. Ita sorodiana da diape wapaase, ‘Ne mainawo wina!’ me wimpi. Tane nolana dewalala da diape wapaase, ‘Nola ema dewasaa!’ me ruawalepie dewasapi.” ");
INSERT INTO soq_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Iesu aia ema etene memesalene apana wawe ieia diamone wanase, “Ne dialedina, Israel apanawa bedeuwo mai apana da sumanaiwa debamaia Rom sorodiawa ema sumanailena rua donsapona, dia. ");
INSERT INTO soq_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ne ulaipa dialedina, apana uaraia tawo moawa uduudu bedeuwoe wimopue God gonaawa bedewe Abraam, Aisak ita Iakob do bolau imaala wineiawo wampue odantompe nuaeuntompe os waimompa. ");
INSERT INTO soq_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Tane apana mida bautaido God gonaawa baiwa sonabamona mo aubamopi bola kadiwaida iwinidaleidia bedewe. Sape mo ke wampe poka etaidasampe asipu adompa.” ");
INSERT INTO soq_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Iesu mo epe diamone aupe Rom sorodiawa debama diene wanase, “Leuite aitaa bolaawo, dima sumanaiwaitena rua segalepi.” Iesu aia ema wadio omo sa deawaa bedewe Rom sorodiawa debama me nolawa dewalala inalen. ");
INSERT INTO soq_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ema aupe Iesu alene Pita duwa bedewe oden. Sape me Pita nemonapa kero wadeno etepa polaida wano ituwa bolawe ituleidio ewen. ");
INSERT INTO soq_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ita Iesu me mampelene witapa wadeno polapola eno inalene enene me baiwa simbialen. ");
INSERT INTO soq_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Rawi sawo apana sosou uara aleu kadiwa bedeuwo wanwanlala banlamone Iesu mampe wimon. Tane Iesu aiawa os mampe aleu kadiwa tanamono nomon ita me kerolala uduudu inamon. ");
INSERT INTO soq_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Me ema epe dewasana dima peroweta Aisaia wana ulaipalepia baiwa. Aisaia bukawa bedewe ema epe wadi wadiase, “Me no keromba ita pokamba daitada awanenaubene eunen.” ");
INSERT INTO soq_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Tane apana uaraia Iesu enane paneieno me ewamone baiwa wawe alala diamone wanase, “Sosona, nawate doa waiwa dawo antata.” Iesu mo epe diamona rua waa bedewe odane nawane anton. ");
INSERT INTO soq_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Tane mo doa waiwa dawo wimoieno anaana waeuwalala apanawa dea Iesu mampe wisene diene wanase, “Debamana, e na aitona ne waroroa wananteape do lakasantata, mai eepa, dia!” ");
INSERT INTO soq_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Iesu me sipoasane wanase, “Ibou waimompadewantompaa nagau winede, ita do nene itudewantompaa dubu wineio waimoi, tane Apana Otopa mai bolawa da wineipona ita uwawa itupidewae bubualepi, dia.” ");
INSERT INTO soq_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Iesu warorosaia apanawa da wisene me diene wanase, “Tatamba, ne mamana bolena baiwa bauta eneawo anteape me dobonteape muriwa leunteape wineape waroroepa.” ");
INSERT INTO soq_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Tane Iesu leusane diene wanase, “Sa dia, e ne waroronea! Apana bolala waimoia muba sou bolena dobontopu.” ");
INSERT INTO soq_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Iesu aia ema wano dialeno aupe me waa bedewe odeno ita wawe alala warorosane do anton. ");
INSERT INTO soq_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Madiaida bedewe mo mai moina da eteipono lawara debamaia esa osowe tauwadea os wisene epeno waa kadiwa osowe odene monulepona baiwaleidie. Tane Iesu ituleidie. ");
INSERT INTO soq_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ita wawe alala saidantone Iesu mampe antone wadanamesane waienase, “Tatamba, no saunee inanea, no kerauda os bontataa baiwantitana!” ");
INSERT INTO soq_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Iesu sipoamone wanase, “Dima baiwa saidaitilana? E sumanaila keraulena baiwa epe dewaitilana!” Iesu mo epe diamone aupe enene lawara ita rauwanaga mampo badowa wana dainantopu, ita lawara dialeno sala uduudu dainalen. ");
INSERT INTO soq_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Tane wawe alala ginasa ema ewane memesaidantone waienase, “Me apana dainea? Me wadio lawara ita rauwanaga ruawantoie dainantoi!” ");
INSERT INTO soq_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Iesu lawara ita rauwanaga dieno aisidene dialeno aupe mo au antoiawo antone doa Galili waiwa dawo bola ebowa Gadara bedewe wimoiena. Sape apana nata bedeuwo aleu kadiwa wanwanlala bo gubauwo waimoia nomone Iesu donsaiena. Mo nata pokawaauida onawaau, sa baiwa mai mida mo mampointa antopua rua, inta sa nuasasanaidalen. ");
INSERT INTO soq_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Mo Iesu ewane siribabantone waienase, “God Otopa, e mai nolaa da no mainimbo wineipona, dia! Kotu walamawa ando wisepi, tane e meneedia no tauma matangelanea baiwa wien, ba?” ");
INSERT INTO soq_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Tane maidana bono uara labantoie leie, ");
INSERT INTO soq_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","sa baiwa aleu kadiwa Iesu iririsane waienase, “No atenten e tananea, sa baiwa no menanedia e waaubanewo nonete ane bono sa bedeuwo odate wanta.” ");
INSERT INTO soq_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ita Iesu mo diamone wanase, “Nolene aitana!” Aleu kadiwa Iesu aiawa ruawantone apana nata emone nomone antoiena bono bedeuwo. Ita bono uara sa daiwa antono doa numamon. ");
INSERT INTO soq_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Bono oniamoia apanawa epe ewane ene weuwane antone bola debama bedewe dima sape segalena ita do apana bedeuwo aleu kadiwa wanwanlala inantona umanawa benemantoie antoie. ");
INSERT INTO soq_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ita bola debamauwo wanwanlala uduudu mo benemau etane bolau ene Iesu donsapua baiwa antoiena. Ita mo Iesu ewane badowa iririsaiena mo bolau epie alepi. ");
INSERT INTO soq_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ema aupe Iesu waa bedewe odene nawene doa waiwa dawo me wanwamba bolawe alen. ");
INSERT INTO soq_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ita apana isiwa sou tampa bobopa rasirasi bedewe aine awanene Iesu mampe wimoiena. Iesu mo sumanaibu ewene apana tampa bobopa diene wanase, “Otona nuaeuitaa, e kadia insendabuasan.” ");
INSERT INTO soq_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Anaana waeuwalala aia ema etane muba gagalontone waienase, “Apana ema gagaloleidia abo me God, sa ipa me God wakadisasade!” ");
INSERT INTO soq_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Tane Iesu mo insaisau atenlene baiwa diamone wanase, “E dima baiwa insaisa kadiwaida inseilana? ");
INSERT INTO soq_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","6","E inseilanase ne mai muka da wadapona tane di apana ema diane wanase, ‘E kadia insendabuasan.’ Dauwa e inseilanase kadi insadabua ipa mai emamboido sabamo ewataa rua, dia, sa baiwa ne di ema epe wana, ba? Tane tauma ne ginasa sabamoido dewasapo e ewane ateitana Apana Otopa apa muka wadena kadi insadabuamompaa rua, mai dia!” Sa baiwa Iesu apana tampa bobopa diene wanase, “Enawie nogia wade aitaa duawo!” ");
INSERT INTO soq_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Iesu epe diedio apana ipa inalene enenwisene alen duwe. ");
INSERT INTO soq_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ita apana uara dima segalena ewane God dauwaida etane baiwa me ebowa wadaposisane sapaidasaiena. Mo God wadaposisaie, ipawa me muka debamaia epe rua apana wanamono eweiena. ");
INSERT INTO soq_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Iesu bola ema ene aleidie takis manewa tamalala apanawa ebowa Matiu nolawa duwa bedewe wandio ewene diene wanase, “Wine, waroronea!” Me epe etene tauwadea enene Iesu warorosane alen. ");
INSERT INTO soq_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Tane Iesu Matiu duwa bedewe nana nadio takis manewa tamalala uara ita do apana ebou kadiwa wawalala wimone Iesu ita wawe alala do awodea nana naie. ");
INSERT INTO soq_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Tane Parisi apanawa isiwa dewa ema ewane me wawe alala diamone waienase, “Dima baiwa e debamala takis manewa tamalala ita apana ebou kadiwa wawalala do nana naie waimoi?” ");
INSERT INTO soq_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Iesu mo epe momoduntoio etamone diamone wanase, “Apana inawaa waimoia doketa mai menamoipona, dia! Tane kerolala doketa saumopia menaidamodio waimoi. ");
INSERT INTO soq_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","God buka bedewe wadi wadiase, ‘Ne menanedia apana nuapare mampe eba eda sauitonuna, e epe dewaitonune aupe pulo ne neonuna. Aia ema ipawaida banusane ita donsane ateitana!’ Ne mai apana dodomanau apamopaa baiwa wineapona, dia! Ne kadi apanawa apamopo God mampentopua baiwa winen.” ");
INSERT INTO soq_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ema aupe Ion wawe alala Iesu mampe wimone waitarasane waienase, “No ita Parisi do kainokaino idintitana, tane dima baiwa e waawo alala mai idintoipona?” ");
INSERT INTO soq_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Iesu mo sipoamone wanase, “Mo nainai apanawa odawa dewasaie nainai muri nisolala nisomoio wimoie me do nuaeuntoie nana naie os waimoi, mo mai nuaparentoipe nana idintoipe waimoipona, dia! Mo ideita nana sa nampe waimompo oda dialepi. Tane God walama ituna wisepio mo nainai apanawa mo mampoe banlepue antopuo aupe mo idi dewawa dewasampe waimompa! ");
INSERT INTO soq_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Mai apana da gara sanaa kepawa wadepie gara tontawa nagawa itupibodepie popolepi, dia! Ipawa gara sanaa kepawa gara tontawa teinepipundepio naga debamalepi. ");
INSERT INTO soq_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Mai mida wain sanaa wadepie dugiwa tontawa pue etepa mampe dewasaiena bedewe memepie itupio winompa, dia! Epe dewasapia wain dugiwa nanasidepio wain nosepituwapi ita dugi do kadilepi. Tane wain sanaa dugiwa sanaa bedewe memepue itupuo winompa, ita wain dugiwa do euda os winompa.” ");
INSERT INTO soq_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Tane Iesu ema epe wadio Iuswa onioniau apanawa dea me mampe wisene wawa bumpe imimpa emmisilene wanase, “Ne anona taumaida bolen, sa baiwa e wine witaa me osowe ituwo inalepie wampi.” ");
INSERT INTO soq_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Iesu enenwisene me nata antoiena ita wawe alala do waroromoiena. ");
INSERT INTO soq_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Tane i kerola dea osina etepe weuwadio ena 12 diantona do aleidie. Ita me Iesu adiweadiwe wisene garawa moawa os waden. ");
INSERT INTO soq_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Me ema dewasana, ipawa me insenase, “Naita me garawa wirasapa ne inanteapa.” ");
INSERT INTO soq_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Tane Iesu leulene i sa ewene wanase, “Anona nuaeuitaa, eba sumanaia inaen.” Iesu epe wadio tauwadea os i sa inalen. ");
INSERT INTO soq_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Tauma Iesu Iuswa onioniau apanawa duwa bedewe alen. Tane me duwa odene mo dewau rua bo osowe kolago suie do apana ke waio ewamone ");
INSERT INTO soq_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","diamone wanase, “E uduudu nolene aitana! Anola di ituleide, mai bolepona, dia.” Mo Iesu epe wadio etane me oiwa wane ene nambe antono ");
INSERT INTO soq_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","aupo Iesu i sanaa ituleidiawo alene witapa wadeno ita me enenwisene inawaa wain. ");
INSERT INTO soq_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Tane gagalo ema debamaleno bola sa uduudu eteiena. ");
INSERT INTO soq_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Iesu bola sa ene aleidio into apana emau potawa nata me wawe antoie mukantoie waiase, “Dawid Otopa, no nuaparembaite saunea!” ");
INSERT INTO soq_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Iesu du dea bedewe odeno apana emau potawa sa nata warorosane me mampe wimoiena. Ita Iesu mo ewamone waitaramone wanase, “E sumanaitilana ne rua os inalepa, ba?” Mo sipoasane waienase, “Oa Tatamba, no sumanaintitana, mai dia!” ");
INSERT INTO soq_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tauma Iesu mo emau osowe witapa itune wanase, “E sumanaitena rua manlawo segalepi!” ");
INSERT INTO soq_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Me epe wano mo emau euleno sala eweiena. Ita Iesu mo badowa anaanamone wanase, “Dima manlawo segalena umanawa mai apana da diamona, dia!” ");
INSERT INTO soq_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Tane mo ene antone gagalo ema bola debama bedewainta debamasaiena. ");
INSERT INTO soq_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Apana ema nata antoioma apana isiwa sou moawa potawa banlene Iesu mampe wimoiena. Me mai gagalolepia rua, ipawa aleu kadiwa me bedewelene wandie. ");
INSERT INTO soq_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Tane Iesu aleu kadiwa taneno nosene aleno ita apana moawa potawa sa gagalolen. Apana uduudu dewa ema ewane memesantone waienase, “Dewa ema pokawaa epe rua no mai Israel bedewe segalepono ewapona, dia!” ");
INSERT INTO soq_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Tane Parisi apanawa wane waienase, “Me kadi mamba Seitan mukawa mampe aleu kadiu apana bedeuwo waimoia tanamodio nomoie antoi.” ");
INSERT INTO soq_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Iesu bola kerakera ita debamau uduudu bedewainta alene gagalo duwa bedewe waeuwaleidie. Ita Gagalo euda God gonaawa umanawa amonaleidie, do kero ita poka daitada etaetalala inamodie. ");
INSERT INTO soq_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Iesu apana uaraia sape ewamone nuapareuidalen. Ipawa mo ewaewau nuabolala mai eda sauntopona rua, sipsip onioniausiawaia ruau waimoie. ");
INSERT INTO soq_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ita Iesu mo ewamone wawe alala diamone wanase, “God iraiwa naune mauraidalene winede, tane uwauwantopua apanawa nataidanton. ");
INSERT INTO soq_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Sa baiwa e irai apanawa mampe rauparitane iririsano me nolawa apanawa waaubamopio antopue me iraiwa naune winedia uwauwantopue auwepu.” ");
INSERT INTO soq_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Iesu wawe alala 12 apamono me mampe wimoieno muka wanamona aleu kadiu apana bedeuwo waimoia tanamompaa baiwa, do apana kerolala ita poka etaetalala uduudu inamompaa baiwa. ");
INSERT INTO soq_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ita Iesu mo ebou Aposel wane itun, ebo ema ipawaida ipa waaubalala. Mo ebou ipa ema: Saimon, ebowa da waia Pita, me wamba Endru, Sebedi obampa Iems Ion nata, ");
INSERT INTO soq_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilip ita Batolomiu, Tomas ita takis manewa tamalala Matiu, Alpias otopa Iems, Tadeus, ");
INSERT INTO soq_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saimon, me Selot apanawa sou dea, mo Rom gabemaniwa Israel epue antopua baiwa onantoia, ita do Iudas Iskariot, mida Iesu laga mampe nanalepia. ");
INSERT INTO soq_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","6","Iesu wawe alala 12 sa waaubamodie diamone wanase, “Aitana Israel apanawa mampo, mo sipsip rebalala ruau waimoi. Tane mai bola daitada bedeuwo wanwanlala mampo, ba Samaria bolau bedewe aitana, dia. ");
INSERT INTO soq_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","E aitonune gagalo ema benemaitonune wanunase, ‘God gonaawa maidalen.’ ");
INSERT INTO soq_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ita do apana kerolala inamona, bolala ina wanamona ita kito wadawadalala eumona, do aleu kadiu apana bedeuwo tanamono nomopue antopu. E God sauwa eubu uduudu di otamolana, sa baiwa di nolaitane aitana, mai nola sa dewasailana malesawa iririwaitana. ");
INSERT INTO soq_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","E ala baiwa mai mane da, ");
INSERT INTO soq_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ba petala, garala da, ba koinala wadana, dia, ita sendorola mai taumona, uduudu emonatuwapi. Ita nitu sa uduudu mai nuabolawaitana, ipawa nola dewalala apanawa nitu uduudu menamodia mampolepituwapio wadapu. ");
INSERT INTO soq_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","E bola debama ba bola kerauda bedewe odonune sape apana dodomana euda wandia banusane donsane me do wainaboe, nolala dialepio tauma ene aitana. ");
INSERT INTO soq_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","E du dea bedewe odonune sau euda itune wanase, ‘Euda du ema bedewe winepi!’ ");
INSERT INTO soq_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Naita apana du sa bedewe nuaeu do mampolepua e God sauwa euda mo mampo ituno winakasalepi, tane mo e mai mampolepua sau auwawa e walana leusane wadana. ");
INSERT INTO soq_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Tane mida e mai banlalepuo duwo odana ba e gagalola mai asisusapua, bola sa ene aitonune popokau e wala osowe winedia uwakokosane ene aitana. ");
INSERT INTO soq_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ne ulaipa dialedina, bola Sodom ita Gomora kotu walamawe pokawa etapu. Tane e bola dawo aitile wileilano bola sa apanawa dabualeie eleia matangelau rebarebaida osouwolepio poka etaidasapu, mai Sodom ita Gomora apanawa ruau!” ");
INSERT INTO soq_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Asisuneana! Ne e sipsip ruau elo onawaau bedeuwo waaubaledina. Sa baiwa insaisala euda dodomana ita etela euda molaaisiwa waina. ");
INSERT INTO soq_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Apana mampo insaisala wadaaubala ewanadewaitana, ipawa mo wadalepue kotulepu ita gagalou dubu bedewe epapuialepue matangelalepu. ");
INSERT INTO soq_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","E ne waroroneilana baiwa mo e wadalepue banlalepue apana debamau ita warere mampo aitane kotuitana. Tane ema epe segalepia e Gagalo euda mo ita uwa daitada apanawa mampo amonaitano etapua baiwa. ");
INSERT INTO soq_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Mo e wadalepue kotulempo mai inguguraitane insenase, ‘No tauma ambi wate inantata?’ Tane walama sawo e dima wapona God e saulepio ateitanatuwapi. ");
INSERT INTO soq_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ipawa mai e eba gagaloitana, dia, tane Mamala Aleupa kakaiwa e bedelawo gagalolepio etapu. ");
INSERT INTO soq_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Apana muba wanwambuida ita tatatauida dabuamopue kotu apanawa mampomopuo kotumopue bomopu. Ita mamamau obampuida dabuamopuo kotu apanawa mampontopu bomopua baiwa. Ita obampu gombauida mampo dewa ipa deawaa dewamopue dabuamopuo kotu apanawa mampomopuo kotumopue bomopu. ");
INSERT INTO soq_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","E ne wanawoitilana baiwa apana uduudu e nibualepu. Tane me mida poka saiwa ema bedewe badowa enompe ompa osowe wisepia, me inaida donsapie inalepi. ");
INSERT INTO soq_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Bola dea bedewe apana e kadilempa e tauwadea bola sa ene bola da bedewe aitane nolaitana. Ne ulaipa dialedina, e mai nolala dewasane Israel bolawa uduudu diasanuno Apana Otopa leulepi wisepi. ");
INSERT INTO soq_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","25","Oto girumala me mai waeuwa apanawa rua, dia, tane me ipa waeuwa apanawa atowe wande. Do nola dewalala me mai mida wadio nolawaleidia rua, dia, me debamawa atowe wande. Tane ando oto girumala me waeuwa apanawa ruawalepi, ita nola dewalala me mida wadio nolawaleidia ruawalepi, sa ide. Ne ipa du apanawa rua wainedina ita e ne atonawo. Apana ne ebona kadi mamba ebowa Belsebul itune wakadisaneiena, tane e ne atonawo wainilana mo ebola rebareba ambi teamopue wakadisalepu? ");
INSERT INTO soq_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Apana mida e wadabualeia mai sauitana, ipawa nitu uduudu tauma weregalala ando sabamontopu ita nitu niabolala uduudu atentopu. ");
INSERT INTO soq_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Sa baiwa dima werego dialedina e sapa bedewe gagalowaitana ita asibenebenemala mampe dialedina sabamo wano apana uduudu etapue atentopu. ");
INSERT INTO soq_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","E emalawoala apanawa kadilepua baiwantompo mai sauitana, dia. Mo ete bosapua mukawa wadeiena, tane aleu mo mai bosapua rua, diaida. Tane me mida ete ita aleu do bola kadiwaida bedewe kadimopia me os sawaitana. ");
INSERT INTO soq_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Apana e wadabualempo aiana ema insena: E nene kerakera nata mane nepa dubawa dea mampe gimaraitana rua. Nene sa mai uwataubu, dia, tane Mamamba nene uduudu insamodituwade. Mai nene dea da di boleipona, dia, God insaisawa rua os segaleide. ");
INSERT INTO soq_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Do e uwala imba uduudu ipa wisialala winei, sa ipawa God e inawala uduudu oniedidewaleide, mai dima da me atensia di segaleipona. ");
INSERT INTO soq_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Nene kerakera God insamodie oniadewasamode, tane e ipa debamawaida God nuawea, mai nene kerakera ruau. Me e oniadewasaledia baiwa mida e kadilepua mai sauitana, dia. ");
INSERT INTO soq_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Mida apana emalawoasaia danauwo ne ebona wadaposisapie wapiase, ‘Ne ipa Keriso mampea,’ ne do ando uboo Mamana danawe wape wapaase, ‘Me ipa ne mainawoa.’ ");
INSERT INTO soq_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Tane mida apana danauwo ne lagana wadia, ne do me wakoasape dabuasapa uboo Mamana God danawe.” ");
INSERT INTO soq_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“E inseilana ne tawo osowe wanwan euda obasa wadane winen, ba? Dia, ne mai wanwan euda obasa wadape wineapona, ne ona wadane winen. ");
INSERT INTO soq_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ne winena apana empuempusapaa baiwa. Ita ando oto me mambaida emalawoasapi, oto iwoa me inawaida emalawoasapi, tawabina me nemonapaida emalawoasapi. ");
INSERT INTO soq_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Apana meba gombawaida, do wanwambaida, weaweanapaida mo mida me duwa bedewe waimoia me emalawoasapu. ");
INSERT INTO soq_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Apana mida ne nuawadawadanedie, tane mamba ita inawa nuawadawadaidamodia, me ipa mai euda ita ne mainawo wimpie waroronepi, dia. Deawaa, mida ne nuawadawadanedie, tane otopa ba anoopa nuawadawadaidasadia, me ipa mai euda ita ne mainawo wimpie waroronepi. ");
INSERT INTO soq_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Apana mida mai meba korosiwa awaneipe tane di ne waroronepia menasadia, me ipa mai euda ne waroronepie simbianepi, dia. ");
INSERT INTO soq_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Mida meba inawawa wadediitudedia me inawawa rebasapi, tane mida inawawa edie ne bainaleidia, me ipa inaida donsapi.” ");
INSERT INTO soq_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Mida e wadalene mampelena me ipa ne wadanene mampesade, tane mida ne wadanene mampesadia, me mida ne waaubanena wadene mampesade. ");
INSERT INTO soq_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Apana mida God perowetawa wadene mampesadia, ipawa me ipa peroweta, apana sa peroweta unewa wadepi. Ita mida apana God mampe dodomanalena dewa euda dewasadia apanawa wadedie mampesadia, ipawa me God mampe dodomanalena apanawa, me apana sa dodomana euda unewa wadepi. ");
INSERT INTO soq_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ne ulaipa dialedina, apana mida esa utepie ne wanawo alala bedeuwo dea da kerauda wanepia, ipawa apana sa ne wanawo alala, me ideita unewa wadepi, mai dia.” ");
INSERT INTO soq_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Iesu wawe alala 12 waeuwamono dialeno aupe bola sa ene bola maida Galili bedewainta waeuwalepie ita God aiawa amonalepia baiwa alen. ");
INSERT INTO soq_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","3","Ion dibura bedewe wandie Iesu dima dewasadio umanawa etene me wawe alala waaubamono anton Iesu waitarasapua baiwa. Mo me mampe wimone wane waienase, “Ion waitarawa ema epe: ‘E ipa mida God sauawalena wisepona wien, ba no apana da onioniawantonte wainento wisepi?’” ");
INSERT INTO soq_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Mo Iesu epe waitarasaieno etene sipoamone wanase, “Leuitane aitane, dima ne gagalowantene dewamodino ewamole ita etamolana Ion benemawasano etepi. ");
INSERT INTO soq_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Me ema epe diana: Apana emau potantona euntone sala ewei, apana tampu bobopu inantone antoi, kito wadawadalala inantoie etepu euntoio waimoi, mo asiu potantoia inantoie gagalo etei, ita do apana bontoia inantoie inawaa waimoi. Ita Gagalo euda nuaparelala mampo benemantoio eteie waimoi. ");
INSERT INTO soq_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ita do Ion ema epe diano etepi: Me mida ne sumanainaleidie mai ne insakoaneipe sumanaiwa oauaraleipono omeipona, me ipa nuaeuwa apanawa wande.” Iesu epe diamono mo ene leuntone antoiena. ");
INSERT INTO soq_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Tane mo antono aupe Iesu Ion umanawa apana diadewasamone wanase, “E dima ewaewa baiwa Ion Babatutu mampe sala makowa bedewe aiten? E auni asiwa lanunu tepasadio ewaewawa awa aiten, ba? ");
INSERT INTO soq_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ba dewa dainea ewaewa baiwa nolene aiten? E apana garawa eubu taumodie benaleidi wandia ewaewawa awa aiten, ba? E walamala di diasaile apana epe ruau sala makowa bedewe banumoile leilana. Apana garau eubu taumoie benadewadewantoie mauraidantoie waimoia bolau eudida bedewe waimoi, mai sala makowa bedewe waimoipe leipona, dia. ");
INSERT INTO soq_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Dianeano etapo, e dima awa sala makowa bedewe aiten? E peroweta ewaewawa awa nolene aiten, ba? Ne dialedina, e peroweta ewaewawa awa nolene aitena, sa ipa sa e ewalana, ipawa sala makowa bedewe God perowetawa wandio ewalana. Tane me ipa sa peroweta uduudu onapolene debamalen. ");
INSERT INTO soq_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ita Ion umanawa buka bedewe girumalena God wadi wadiase, ‘Ne gagalona benemala apanawa bauta wapaaubepo e intaa deaitopasapio eulepie winompa e baia.’ ");
INSERT INTO soq_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ne ulaipa dialedina, apana uduudu mapo ita tauma gamomoia bedeuwo Ion ipa debamawaida segalene wande, mo uduudu onapolen. Ion bautalene wisena walamawe me ipa debamawa, tane mo sumanailala eboeboua ita ebousiawaia mida tauma God gonaawa bedewe odeia ita ando odompa mo ipa debamaidantopuo Ion atouwolepi. ");
INSERT INTO soq_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ion Babatutu segalena walamawe ita tauma apana rubusaia God gonaawa kadisape ita muba mukau mampe oniepona. ");
INSERT INTO soq_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mapo ita Ion walamawe peroweta uduudu ita anaana bukau Ion umanawa waie. ");
INSERT INTO soq_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","E dima buka bedewe Ion umanawa wadia ruawaitana menalempa, ne tauma dialedina: Ion ipa Elaia, mida apana waia wisepona, tauma wisen. ");
INSERT INTO soq_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Mida asiwa wineipono aia ema eteipe atenleipona!” ");
INSERT INTO soq_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ita Iesu asisulala diamone wanase, “Walama ande apanawa umanau ambi wapo ateitana, mida dewau rua dewantoie waimoi? Mo seda kerakera ruau maket bolawe waimoie sosou diamoie waiase, ");
INSERT INTO soq_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘No nuaeuwa odawa bedewe e baila kolago suitano e nuaeuitape biaitapona dabuaitene di wainile! Ita walama dawo no nuaparepare sasawa sasantite antitano e nuala parelepono ke wapona dabuaitene di wainile!’” ");
INSERT INTO soq_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Iesu gagalo babawa ema mampe Ion me nata nolau umanawa apana diadewasamone wane wanase, “Ion Babatutu e manlawo wisena saulepona baiwa ita me wain nasasia wandie do nana idileidie wandie nolaleide. Ita e mai me nolawa bedeweitapona, dia, tane wadabuasaile wailanase, ‘Me bedewe aleu kadiwa wandio nolaleide.’ ");
INSERT INTO soq_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ita Apana Otopa e manlawo wisene nana ita wain namodie wandio e me wadabuasaile wailanase, ‘Me kainokaino wain ita nana namode, nana os insaisau insamodie no bedembo wandi leide. Me takis manewa tamalala ita kadi daitada dewalala sou wande!’ Mo mida aten insaisawa eueuwa osowe ituie dewasaia waeuwa daitada eteie bedeuwo ulaipa waeuwawa atendewantoie waimoi, ita dainea laga waeuwawa mo etadabuasaie ei.” ");
INSERT INTO soq_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Bola isiwa bedeuwo Iesu ginasawa uaraia dewasana mai bola isiwa bedeuwo rua. Ita bola sa apanawa Iesu ginasa dewamona eweiena tane mai insaisau leusape kadiwa epona, dia. Sa baiwa Iesu mo bolau kotuwa gagalowa wane wanase, ");
INSERT INTO soq_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Ne dialedina, e Korasin ita Betisaida apanawa kadi rebarebaida donsane pokawa etaidasana! Ginasa pokawaau e bolalawo dewamoieno ewamole mai sumanaitape God mampe dodomanaitapona, dia. Naita ginasa pokawaau e ewamolana rua Taire ita Saidon apanawa ewamopono mo mapo kadiu bedewe insaisau leusape dodomanantopona. Ita mo kadiu epona eueuwa dewasaipe garau kadiu taumoipe isana totontoipe nuaparentoipe waimoipona. ");
INSERT INTO soq_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Kotu walamawe Taire ita Saidon apanawa matangelau pokawa etapu, mai dia. Tane e Korasin ita Betisaida apanawa kotu walamawe matangelala rebarebaida osolawolepio poka etaidasana, mai Taire ita Saidon apanawa ruau. ");
INSERT INTO soq_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","E Kapeanaum apanawa inseilana kotu walamawe e ionoidoitane uba tampe wilene kotu matangelawa mai donsane wadana, ba? Diaida, e aubalepuo bola kadiwaida bedewe iane aitane poka etonune wanlempa. Ginasa e bedelawo segantoia bola Sodom bedewe segantopono mo insaisau leusape kadiwa epona ita God mo bolau mai kadisapona, ideita winakasalepona. ");
INSERT INTO soq_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ne dialedina, kotu walamawe Sodom apanawa poka etapu, tane e ipa poka debamawaida etana!” ");
INSERT INTO soq_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Walama sawo Iesu wane wanase, “Mako, e uba ita tawo onioniau mamba wainiana. E gonaa umanawa ita mukaa ita atena uduudu ne mainawosaano apana girumantoie aten debama wadeie asowawantoie waimoia mampo weregasaiano mai atentoipe waimoipona, dia. Tane otooto kerakera insaisau oauara mampo sabamosaiano atenidantoie waimoio nuana eudidaleide. ");
INSERT INTO soq_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","E insaisaa euda meneedio rua dewasaiana baiwa ne wadaposiedina. ");
INSERT INTO soq_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Dewa uduudu onioniau mukawa ne Mamana mampe winedia mainawosano oniamodina. Tane mai mida da ne ateineapona, dia, Mamamba os ne ateinen. Ita mai mida da Mamamba atensaipona, dia, tane Otopa os me atensadio wande. Ita mo mida me sonabamodia do Mamamba atensaie waimoi, ipawa Otopa mo mampo sabamosano atentoiena. Tane apana da dia. ");
INSERT INTO soq_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","E uduudu poka etaetala ita sai enaleio awaneilana ne mainawo winlena ita ne e saila wadaaubepo bubuaitana. ");
INSERT INTO soq_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ne dewana wadane ruanaitana ita ne mainawo aten wadana, ipawa ne ipa molaaisiwa ita etena aiaisiwa. Ne mainawo winlene ita e wanwanla bedewe bubua donsana, ");
INSERT INTO soq_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ipawa ne warorona nolawa mai saiwa, ita dima ne enalepo awanena ipa tekateka, e awanena rua os.” ");
INSERT INTO soq_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ema aupe Iesu Sabat walamawe nana wit iraiwa bedewainta aleidie. Me wawe alala omanatomono wit ampuiantone ipawa namoio ");
INSERT INTO soq_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Parisi apanawa mo ewamone Iesu diane waienase, “Dima baiwa e waawo alala Sabat walama bedewe wit ampuiantoie nai? Dewa sa no anaanamba kakaisan!” ");
INSERT INTO soq_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Mo epe waio Iesu etamone diamone wanase, “E Dawid dudunawa wisiaitene ateiten, ba dia? Dawid sosowa do omanatomono me dima dewasan? ");
INSERT INTO soq_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Dawid God duwa bedewe odene bured kakaila winamoia wadene ita sosowa do naiena, tane bured sa ipa pirisi os nanala anaana wadia rua. ");
INSERT INTO soq_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","E anaana bukawa bedewe wisiaitene ateiten, ba dia? Pirisi mida Sabat walamawe God duwa bedewe nolantoia do Sabat anaanawa ampuiasai, tane mo epe dewasaia mo mai kadiwa wawuwa wadeipona, dia. ");
INSERT INTO soq_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ne dialedina, apana debamawaida dea ipa mape, me mai God duwe nolantoia apanawa ruau, dia. ");
INSERT INTO soq_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","God buka bedewe wadi wadiase, ‘Ne menanedia apana nuapare mampe eda sauntompa, e epe dewaitonune aupe pulo ne neonuna.’ E aia ema ipawaida atendewaitapono e mai apana eubu dodomana di wawumopona.” ");
INSERT INTO soq_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Iesu Dawid gagalowa wane diasane meba umanawa diadewasamone wanase, “Apana Otopa Sabat walamawa mambaida, me os oniede.” ");
INSERT INTO soq_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Iesu mo emone gagalo duwa bedewe odene alen, ");
INSERT INTO soq_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","sape apana witapa bobopa wandie. Apana isiwa sape waimoia menamodia Iesu dima dewasapikadisapio ita me wawusapu. Sa baiwa mo Iesu waitarasane waienase, “No anaanamba ambi wade, Sabat walamawe kerolala inasata, ba dia?” ");
INSERT INTO soq_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Iesu mo waitarau eueuwa mampe sipoamone wanase, “Apana dea e bedelawo sipsip me gamosadia Sabat walamawe don bedewe omepe alepono me sipsip sa tauwadea teinepaposidepona, ba dia? ");
INSERT INTO soq_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Tane apana ipa debamawaida mai pue rua! Sa baiwa Sabat walamawe dodomana no dewa euda dewasate apana saumota.” ");
INSERT INTO soq_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Tauma Iesu apana witapa bobopa diene wanase, “Witaa aubea!” Iesu dima diena rua me witapa aubeno ita eulen witapa da rua. ");
INSERT INTO soq_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Sape Parisi apanawa dewa ema ewane nuau kadileno nomone antone ita Iesu bosapua baiwa inta banusaiena. ");
INSERT INTO soq_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Iesu mo insaisau atenlene emone aleidio apana uara me warorosaiena ita me kerolala uduudu mo bedeuwo inamon. ");
INSERT INTO soq_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Tane Iesu mo badowa anaanamona me umanawa mai wapue sabamosapu me mida, dia. ");
INSERT INTO soq_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Me epe dewasana dima peroweta Aisaia gagalolena ideita ulaipalepia baiwa. God Aisaia bukawa bedewe girumalena ema epe wadi wadiase, ");
INSERT INTO soq_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ewana, apana ema ipa ne nolana dewalala mida ne sonabena. Me ipa ne nuawadawadana Otopaida, ne nuana eudidalen me mampe. Ne Aleuna kakaiwa wapaaubepa me osowe iepio apana daitada mampo kotu gagalowa wapio etapu. ");
INSERT INTO soq_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Me mai apana do wawantopu ita mai bola bedewainta aiawa mukama mampe gagalolepio apana etapu, dia. ");
INSERT INTO soq_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Me auni asiwa tewapia baiwaleidia mai ampi pundepi ita siwa keraudaida idia mai supibolepi, dia. Me epe nolalempe waimpo ideita kotuida walamawe uduudu dodomanalepi. ");
INSERT INTO soq_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Uwa daitada apanawa me ebowa mampe me baiwantopu.” ");
INSERT INTO soq_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ema aupe mo apana dea banlene Iesu mampe wimon. Apana sa ipa emawa ita moawa potawa, ipawa me bedewe aleu kadiwa wandie. Ita Iesu me ewene inasano gagalo wan ita do sala ewen. ");
INSERT INTO soq_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Apana uduudu ginasa ema ewane memesantone waienase, “Apana ema dauwa Keriso, Dawid Otopa God sauawalena, ba?” ");
INSERT INTO soq_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Parisi apanawa aia ema etane waienase, “Iesu meba mai epe nolalepia rua, dia. Tane me aleu kadiu mambu ebowa Belsebul mukawa mampe aleu kadiu apana bedeuwo waimoia tanamodio nomoie antoi.” ");
INSERT INTO soq_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Iesu mo insaisau atenlene diamone wanase, “Naita bola debama dea apanawa mai insaisau dealepia mo ona maepue wanwambu kadiidasapu. Bola ba dan dea mai insaisau dealepia mo ona maepue wanwambu kadiidalepi. ");
INSERT INTO soq_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Epe rua deawaa, naita Seitan me sowa nata mai insaisau dealepio sowa tanepia me gonaawa mai winakasalepi, dia. ");
INSERT INTO soq_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","E wailanase ne Belsebul mukawa mampe aleu kadiu tanamodina. Sa baiwa tauma ne e epe waitaraledina: E warorola muka dainea mampe aleu kadiu tanamoio nomoi? Mo atembu waimoi, mai mida da aleu kadiu Seitan mukawa mampe tanamoipona rua, dia. E mo waitaramono nolantoia umanawa diadewasalepuo atendewaitane malaitana. ");
INSERT INTO soq_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ne God mukawa mampe aleu kadiu tanamodino nomoie nambentoia ewaewawa sabamo God gonaawa e manlawoleno koasailana. ");
INSERT INTO soq_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Apana kasawogala duwa bedewe mai apana poiwaa reba odepie puraiwawa otamopia rua, dia. Tane me ideita apana kasawogala bauta taupidoe muriwa puraiwawa duwa bedewe winamoia otamopia rua. ");
INSERT INTO soq_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Mo mida mai ne bainantoipe nolanantoipona mo ne onana apanawa waimoi. Ita mo mida mai ne sauneipe sipsip waimoi laia auwamoipe gonaana bedewe aimoipona, mo ipa sipsip tanamoio deaantoia apanawa. ");
INSERT INTO soq_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ne dialedina, God kadi uduudu, ita do me wakadisasaia insepidabuasapia rua. Tane me mida Aleu kakaiwa wakadisasadia God mai apana sa kadiwa insepidabuasapi, diaida. ");
INSERT INTO soq_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Me mida Apana Otopa wadabuasadia me kadiwa God insepidabuasapi. Tane apana mida Aleu kakaiwa wadabuasadia me kadiwa winakasala, tauma ita walama ompa osowe God mai insepidabuasapi, diaida!” ");
INSERT INTO soq_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Ia inidewaleidia naunauwa euda os naupi, tane ia inikadileidia naunauwa kadiwa naupi. E ia sa ipawa naudia mampe ewane ateitana ia sa euda ba kadiwa. ");
INSERT INTO soq_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","E ipa mota obampa kadiuida, e ambi gagalo euda wana? Dima apana nuawe sanaleidio wineia me moawe nosedio wade. ");
INSERT INTO soq_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Apana euda nuawe euda sanaleidio wineia euda wadio nosede, tane apana kadiwa nuawe kadiwa sanaleidio wineia kadiwa wadio nosede. ");
INSERT INTO soq_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ne dialedina, kotu walamawe apana uduudu aia kerauda ita debama rebareba waia kotuwantopu. ");
INSERT INTO soq_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ne epe wadina, ipawa e eba aiala enepie kotulepi, ita do deawaa eba aiala enepie inalepi.” ");
INSERT INTO soq_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Mape Parisi ita anaana waeuwalala isiwa Iesu diane waienase, “Debamamba, ginasa dewasawo ewate atentata e ulaipa God mukawa wadaana!” ");
INSERT INTO soq_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Iesu sipoamone wanase, “Ande apanawa kadiuida ewanuaula waimoi. Mo menamodia ne ginasa da dewasapo ewapua iririwantoi. Tane ne mai mo iririu ruawantape ginasa da dewasapo ewapu, dia. Tane eueuwa dea os mo bedeuwo segalepio ewapu, sa ipa dima mapo Iona mampe segalena rua deawaa segalepi. ");
INSERT INTO soq_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Iona owa moia debama bupa bedewe walama ita tadina natadea waina rua deawaa Apana Otopa walama ita tadina natadea bo nagawa bedewe winepi. ");
INSERT INTO soq_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Iona God benemawa Niniwe apanawa diamono etane mo kadiu bedewe insaisau leusane God mampe dodomananton. Kotu walamawe mo dewa euda sa dewasaiena mampe walama ande apanawa kotulepue mala debama osolawo itupu. Ipawa tauma dea debamawaida, mai Iona rua, manlawo wisene gagaloleidio mai baiwaitipona, dia. ");
INSERT INTO soq_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Bola Seba warerewa iwoa nowa dawoido enenwisene alene Israelwa warereu Solomon atemba gagalowa etepia baiwa mampe wisen. Me mai atemba gagalowa sa dabuasape epona, dia, me wadene mampesan. Kotu walamawe me dewawa euda sa dewasana mampe walama ande apanawa kotulepie mala debama osolawo itupi. Ipawa tauma dea debamawaida, mai Solomon rua, manlawo gagaloleidio tane e mai baiwaitipona, dia.” ");
INSERT INTO soq_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ita Iesu gagalo da diamone wanase, “Aleu kadiwa apana bedewe wandia edie nosedie sala dainala bedewe bubuadewalepia bolawa banusadie aleidie, mai donsaipona, dia. ");
INSERT INTO soq_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ita meba insaisaleidie insediase, ‘Ne bubua bolawa banusanalewantena baiwa leuntape du enawo anteape wainepina.’ Me leuleidie du sa bedewe odedie du kulontono teadewasala di winedia ewedie bedewe wampidewalepia menasade. ");
INSERT INTO soq_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Tane me menasadia aleu kadiu 7 da kadiuida, mai me meba rua, do sape wampu. Me au aleidie banlamodio wimoie du sawo waimoie du apanawa dewasaio wanwamba kadiidaleide, mai bauta aleu kadiwa dea os me duwa bedewe wandie nolaleidia rua. Tane epe rua deawaa walama ande apanawa mampo segalepi.” ");
INSERT INTO soq_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Iesu apana uara mampo gagaloleidio me inawa ita wanwamba wimone pewa eneie onieia me mampe gagalontopona. ");
INSERT INTO soq_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ita apana dea mo umanau Iesu diene wanase, “E inaa ita wanwana pewa enei menamodia e do gagaloitana.” ");
INSERT INTO soq_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Tane Iesu sipoasane wanase, “Mida ne inana ita waiwaina?” ");
INSERT INTO soq_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Me epe wane wawe alala enitumone wanase, “Mo ipa ne inana ita waiwaina waimoi, ");
INSERT INTO soq_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ipawa mida ne Mamana uboo wandia insaisawa dewasaia, mo ipa ne waina, weanana ita ne inana.” ");
INSERT INTO soq_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Walama sa deawaawo Iesu du bedewe wandie ene nosene alene doa Galili tampe aisidene waine waeuwaleidie. ");
INSERT INTO soq_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tane me sape waeuwaleidio apana uaraia wimone Iesu enane panane asisusaie. Me enape waeuwalepona bolawa dia baiwa waa bedewe odene waine waeuwaleidio apana ududu wimoiena esa tampe eneie asisusaie. ");
INSERT INTO soq_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ita Iesu gagalo babawa uara mampe apana waeuwamodie wadiase, “Irai apanawa dea lawuru naumba aimopia baiwa nosene alen. ");
INSERT INTO soq_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ita me lawuru naumba laraimodio isiwa into nonosinton ita nene wimone ennaantoiena. ");
INSERT INTO soq_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","6","Naumba isiwa siara bedewe nomone tauwadea teponton, tane siara uduudulena baiwa waapa mai iapona, dia. Ita omo idia walamawe tepolala sa imono rorontonatuwaiena. ");
INSERT INTO soq_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Lawuru naumba da laraimono gedara kaigawara bedewe nomone gedara do inintone wimone gedara lawuru tauboiamono ipawa mai teamopona, dia. ");
INSERT INTO soq_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Tane naumba da irai dogowa euda osowe nomone inintone naunadewanton, naumba isiwa ipawa 100, isiwa 60 ita isiwa 30 naumoiena.” ");
INSERT INTO soq_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ita Iesu gagalowa diasapia baiwaleidie wanase, “Mida asiwa wineipono aia ema eteipe atenleipona!” ");
INSERT INTO soq_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Wawe alala Iesu mampe wimone waitarasane waienase, “Dima baiwa e gagalo babawa mampe apana diamoiana?” ");
INSERT INTO soq_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ita Iesu mo diamone wanase, “God gonaawa benemawa ipawaida wadenitudena e os manlawo sabamoleidio ateitile wainilana. Tane mo mida me gonaawa adiwe waimoia mampo mai sabamosaipono atentoipona, dia. Tane mo mampo gagalo babawa waeuwa os nosedio etei. ");
INSERT INTO soq_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","E God aiawa eteilana mampe asisudewaitane me aiawa wadane manlawosano winakasalempa. Apana mida God aiawa debamasane wadene mampesana, God me osowesapie debamasapie wanepio mauraidalepi. Tane me mida God aiawa keraudaida karami rua wadene mampesana, God me mampe keraudaida sa wadepiaubepio di wampi. ");
INSERT INTO soq_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ema girumalena baiwa ne gagalo babawa mampe mo diamodina. Buka bedewe epe wadi wadiase, ‘Mo dewa ewompa, tane mai ewompe atendewantompa, dia, do gagalo etompe, tane atensasia di waimompa.’ ");
INSERT INTO soq_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Mo dewau bedewe dima peroweta Aisaia bukawa bedewe girumalena tauma ulaipaleide. Aisaia bukawa bedewe girumalene wadiase, ‘E etonune ita etonuna, tane mai ateitana, dia. E ewonune ita ewonuna, tane mai ewana, dia.’ ");
INSERT INTO soq_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Mo epe dewantoia, ipawa mo nuau potalen, ita mo asiu enenboden ita do emau potalen. Mo emau ewepie ita asiu etepia sawa, do nuau insepie ita insaisau leusapuo ne inamopaa sawa epe segalen mo mampo.” ");
INSERT INTO soq_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Tane Iesu wawe alala mampo wane wanase, “E God sauwa euda wadale nuaeuitilana, ipawa e emala ewede ita asila etede. ");
INSERT INTO soq_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ne ulaipa dialedina, peroweta ita apana eubu dodomanau uara menamona dewa pokawaau e ewamoile ateitilana rua ewamope atentopona, tane dia, mo ewasasia di waimoie. Ita do menamona dima e etamoile ateitilana rua etamope atentopona, tane dia, etasasia di bontoiena.” ");
INSERT INTO soq_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Asisuitana! Gagalo babawa ipawaida ema epe: ");
INSERT INTO soq_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Lawuru naumba into nonosintoia, sa ipa apana mida God gonaawa gagalowa etede tane mai atenleipona, ita kadi mamba Seitan wisedie dima apana sa nuawe winedia wadediaubedio di wankoaleide. ");
INSERT INTO soq_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Lawuru naumba siara bedewe nonosintoia, sa ipa apana mida God aiawa etede ita nuaeu do wadedie mampesade. ");
INSERT INTO soq_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Tane me walama kampaida os sumanai bedewe enede, ipawa me bedewe God aiawa mai iaidasaipe bola wadeipe wineipona, dia. Ita apana da God aiawa baiwa me wadabuasapu ba amboitusapua me tauwadea sumanai bedewe ampipare omepi. ");
INSERT INTO soq_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Lawuru naumba gedara bedewe nonosintoia mai ipawa naumoipona, sa ipa apana mida God aiawa etede, tane tawo nuabola ba tawo nuaeuwa insaisawa God aiawa nuawa bedewe tauboiamoi ita mai ipawa naumoipona, dia. ");
INSERT INTO soq_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Tane lawuru naumba irai dogowa euda osowe nonosintoia, sa ipa apana mida God aiawa eteie atendewantoi ita nauidewantoi. Apana dea naudia ipawa 100, da 60, ita apana da 30.” ");
INSERT INTO soq_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Iesu gagalo babawa da diamone wanase, “God gonaawa ipa ema epe: Irai apanawa dea iraiwa bedewe nana wit naumba eubu irailen. ");
INSERT INTO soq_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Tane tadino apana uduudu ituawawantoio emalawoa apanawa wisene bodu naumba kadiwa wit iraiwa sa bedewe aimone ene alen. ");
INSERT INTO soq_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Tane irai sa bedewe wit tepontone inintone debamanton, ita kelontoiomawa bodu do bedewe ininton. ");
INSERT INTO soq_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Tauma irai apana nolawa dewalala epe ewane wimone me diane waienase, ‘Debamamba, e wit naumba eubu os iraia bedewe aimoana, tane bodu ema naewa wimone inintoi?’ ");
INSERT INTO soq_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Tane me sipoamone wanase, ‘Emalawoa apanawa dewa ema dewasan.’ Mape me nolawa dewalala leusane diane waienase, ‘E meneedia no iraia bedewe ane bodu kadiwa inintoia bowiantata, ba?’ ");
INSERT INTO soq_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Me diamone wanase, ‘Mai bodu bowiaitana, dia, bodu kadiwa bowiaitonune wit do bowiaitana sawa. ");
INSERT INTO soq_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Eno, wit ita bodu do awodea inintompa ideita totowa walamawa wisepio ne totola apanawa diamopo mo bauta bodu topuiantopue tauboiamopue ia bedewe sumopu, ema aupe wit auwepue otepue adibanawo teamopu.’” ");
INSERT INTO soq_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Me gagalo babawa da diamone wanase, “God gonaawa ipa paipai naumba apana dea iraiwa bedewe andia rua. ");
INSERT INTO soq_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Paipai naumba ipa keraudaida, mai lawuru naumba isiwa ruau, tane naumba sa keraudaida inileidie debamaleidio ita nene wimoie osowe duntoi.” ");
INSERT INTO soq_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Do gagalo babawa da diamone wanase, “God gonaawa ipa nana kerauda ist parawa bedewe ituio sasanaleidia rua. I nitu sa kerauda ist parawa bedewe itudie gadaleidio bured debamaia segaleide.” ");
INSERT INTO soq_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Iesu waeuwa ema uduudu gagalo babawa mampe os waeuwamon, mai gagalo da di wapona, dia. ");
INSERT INTO soq_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Me ema dewasana dima peroweta gagalolena ideita segalepia baiwa. God peroweta bukawa bedewe ema epe wane wanase, “Ne gagalo babawa mampe apana gagalomodina, do dima tawo segalena walamawe ita tauma niabolene winedia ne tauma apana diamodino etei.” ");
INSERT INTO soq_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Iesu apana uara emone du bedewe odene aleno me wawe alala wimone diane waienase, “Bodu irai bedewe inileidia gagalowa babawa ipawaida no waeuwanewo atentata!” ");
INSERT INTO soq_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Iesu sipoamone wanase, “Mida lawuru eubu aimona, sa ipa Apana Otopa. ");
INSERT INTO soq_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Irai, sa ipa tawo ema, tane naumba euda, sa ipa God gonaawa obampa. Ita bodu, sa ipa Seitan obampa. ");
INSERT INTO soq_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Emalawoa apanawa mida bodu aimona, sa ipa kadi mamba Seitan. Tane totowa walamawa umanawa wadia, sa ipa walama ompa. Ita totola apanawa, sa ipa God enseliwa. ");
INSERT INTO soq_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Totola apanawa bodu bowiantoie ita ia bedewe sui, epe rua deawaa walama ompa osowe segalepi. ");
INSERT INTO soq_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Apana Otopa me enseliwa waaubamopio antopue mo mida me gonaawa bedewe sosou banlakadisamoia, do mo mida kadi dewalala uduudu awodeamopue ");
INSERT INTO soq_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ia iilala monialeidia bedewe aubamopu. Sape mo poka etompe ke wampe ita asipu adompe waimompa. ");
INSERT INTO soq_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Walama sawo apana eubu dodomanau Mambu gonaawa bedewe sapaida wapu, omo tawo osowe sapa wadia rua. Mida asiwa wineipono aia ema eteipe atenleipona.” ");
INSERT INTO soq_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“God gonaawa ipa nitu uwataubu eubuida dogo bedewe weregala wineia rua, ita apana dogo todie donsane, tane osowe weregasan. Ita me nuaeu do alene nitu uduudu me mampea gimaralentuwan. Ema aupe me mane sa waden ita dogo sa waiwa naepe nitu uwataubu eubuida bedewe wineia gimaralene mampesan. ");
INSERT INTO soq_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Do God gonaawa ipa apana gimarala rua, mida bena uwataubu eubu banumodia gimaralepona baiwa. ");
INSERT INTO soq_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Walama dea me bena dea uwatauwa eudida donsane alene nitu uduudu me mampea gimaralentuwan, ita me mane sa wadene bena sa uwatauwa eudida gimaralene mampesan. ");
INSERT INTO soq_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Do God gonaawa ipa bouri lawaiwa esa bedewe aubeio moia daitada uaraia bedewe odeia rua. ");
INSERT INTO soq_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Lawai sa nope wiseno teinenaposie esa waiwe wimon. Sape mo aisintone waine moia eubu os posa bedewe aimoiena, tane kadiu nambe aubamoiena. ");
INSERT INTO soq_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ema epe rua deawaa walama ompa osowe segalepi. Walama sawo God enseliwa wimopue apana kadiu ita dodomana eubu empuempumopu. ");
INSERT INTO soq_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ita mo apana kadi dewalala ia iilala monialeidia bedewe aubamopu. Sape mo poka etompe ke wampe ita asipu adompa.” ");
INSERT INTO soq_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Tauma Iesu wawe alala waitaramone wanase, “Dewa ema uduudu eteile ateitilana, ba dia?” Mo sipoasane waienase, “Oa, no etate atenten.” ");
INSERT INTO soq_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Sa baiwa Iesu mo ema epe diamone wanase, “Anaana waeuwalala uduudu mida God gonaawa umanawa etane atentoiena, mo ipa du apanawa rua mida nitu uwataubu du bedewe sanantoio wineia, sanaau ita tontau do otaaubamoio nomoi.” ");
INSERT INTO soq_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Iesu gagalo babawa ema diasane bola sa ene alene ");
INSERT INTO soq_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","me bolaweido wisen. Sape me gagalo duwa bedewe apana waeuwamodio mo etane memesantone waienase, “Apana ema aten ita ginasa mukawa na waden? ");
INSERT INTO soq_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Me kanda apanawa otopa, me inawa ebowa Meri ita me wanwamba ipa Iems, Iosep, Saimon ita Iudas no ateinimba waimoi. ");
INSERT INTO soq_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Do me weaweanapa mape waimoia ateinimbaida. Me dewa ema mukamukaua naepe otene nolaleide?” ");
INSERT INTO soq_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Mo insaisa ema wadane osowe Iesu dabuasaiena. Tane Iesu diamone wanase, “Peroweta bola uduudu bedewe onieidewantoi, tane mebaida bolawa apanawa ita baidasosowa mai me onieipadewantoipe wadeipe mamposaipona, dia.” ");
INSERT INTO soq_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Iesu bolawaida apanawa sumanaibu dia, sa baiwa me sape ginasa nata os dewamon, mai uara. ");
INSERT INTO soq_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","2","Erod Galili tawowa warerewaleidia walamawe Iesu ebowa debamaleidia benemawa eten, sa baiwa me nolawa apanawa diamone wanase, “Iesu ipa Ion Babatutu, mida imumba ne sorodiana tonapundeiena bo bedewe enenwisene muka wadene ginasa pokawaau dewamodio umanawa eteitana.” ");
INSERT INTO soq_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Me epe insedie, ipawa Ion wandia walamawe Erod manainapa ebowa Erodias Ion mampe nuawa kadiidalen, ipawa Ion kainokaino Erod diedie wadiase, “God emawe mai dodomana e tataa Pilip manainapa naisee nata wainilana.” Sa baiwa Erod sorodia waaubamono antone Ion wadane dibura bedewe ituiena. ");
INSERT INTO soq_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Erod Ion bosapona insaisawaleidie, tane me Ius apanawa saulen, ipawa mo sumanaintoia Ion ipa peroweta. ");
INSERT INTO soq_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Tane Erod mulena walamawa wiseno bedewe ema epe segalen: Erodias anoopa apana nisolala danauwo bialeidio Erod ewene nuawa eudidalen. ");
INSERT INTO soq_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Sa baiwa me i sanaa sauaidasan dima da me iririwalepia ideita wanepi. ");
INSERT INTO soq_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Tane i sanaa inawa diedia me insaisawa diepi, ita inawa diena rua alene Erod diene wanase, “Ne menaidanedia taumaida ema e sorodiaa waaubamowo antopue Ion Babatutu imumba topupundepi ita me uwawa laukai bedewe itupue ne neapu!” ");
INSERT INTO soq_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Erod aia ema etene nuaparelen, tane apana nisolala danauwo sauaidalena baiwa me sorodiawa diamona dima Erodias anoopa iririwalena ruawantopu. ");
INSERT INTO soq_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ita Erod sorodiawa waaubamono antone dibura bedewe Ion imumba tonapundeiena. ");
INSERT INTO soq_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Mo me uwawa laukai bedewe itune wadane wimone i sanaa waneiena, tane me wadene alene inawa wanen. ");
INSERT INTO soq_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ita Ion wawe alala wimone etepa wadane awanene antone dobontoiena. Ema aupe mo ene antone dima segalena umanawa Iesu dieieno eten. ");
INSERT INTO soq_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Tane Erod Iesu insakoasadia umanawa etene bola sa bedewe wandia ene waa asiasi meba alen sala dainalawo. Tane apana uaraia ema umanawa etane mo bolau emone Iesu wawe doa waiwainta antoiena. ");
INSERT INTO soq_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ita Iesu doa waiwa dawo wisene waa ene nosene apana uaraia wawe wimona ewamone nuapareuidalen ita bedeuwo kerolala uduudu inamon. ");
INSERT INTO soq_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Rawi sawo wawe alala Iesu mampe wimone waienase, “Mape sala obasa, tane aitamana rawiidalena baiwa apana ema waaubamowo bola bedeuwointa antopue nanau gimarantopue napu.” ");
INSERT INTO soq_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Iesu sipoamone wanase, “Dia, mo mai antopu, e nana wanamono napu!” ");
INSERT INTO soq_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Mo leusane waienase, “No mainimbo bured 5 ita bouri nata winei, mai da, dia!” ");
INSERT INTO soq_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ita Iesu diamone wanase, “Aitane, nana sa otene winlena ne mainawo.” ");
INSERT INTO soq_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Tane me apana uaraia diamone wanase, “Aisitane ina osowe waina.” Ita Iesu bured 5 ita bouri nata otene pisiwane uba ewene God auwasane bured ampuialene ita bouri dosane wawe alala wanamon. Ita mo nana sa wadane apana wanamoiena. ");
INSERT INTO soq_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Tane mo uduudu nane pokamon. Ita wawe alala nana moawa eiena auwene posa uduudu 12 aimoieno nope wimon. ");
INSERT INTO soq_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Apana mona sape nana naiena wisiawa 5000, tane ioto ita seda do nana naiena mai wisiamopona, dia. ");
INSERT INTO soq_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Nana dialeno aupe Iesu wawe alala diamone wanase, “E waa bedewe odane nawane doa waiwa dawo aitonuno ne apana ema uaraia waaubamopo bolauwo antompo walawo wimpa.” ");
INSERT INTO soq_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","24","Iesu apana waaubamono antoieno aupe me raupari baiwa wadiwa odene alen. Meba wandio tadinaleidio wawe alala waa asiasi doa pouwe wimoio lanunu esa tepasane waa epaaubasadie, ipawa mo lanunu iediawo antoie. ");
INSERT INTO soq_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Tane walama iwimpa bedewe Iesu esa osowainta winine wawe alala mampoleidie. ");
INSERT INTO soq_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ita mo Iesu esa osowainta iedio ewane saidantone siribabantone waienase, “Sa aleu, ba dewa dainea eweitana?” ");
INSERT INTO soq_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Tane Iesu tauwadea mo mampo wane wanase, “Mai saitana, ne iedina, siribaba ena!” ");
INSERT INTO soq_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ita Pita leusane wanase, “Tatamba, naita e ebaida ne dianeawo esa osowainta manawo wimpa.” ");
INSERT INTO soq_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Pita epe wano Iesu etene diene wanase, “Winea mainawo!” Ita Pita waa ene nosene esa osowainta a uwaalene Iesu mampe aleidie. ");
INSERT INTO soq_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Tane me lanunu ewendewae saidalene ainsudeno esa numedio ka debama wane wanase, “Tatamba, saune inanea!” ");
INSERT INTO soq_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Tauwadea Iesu witapa aubene Pita wadendoe diene wanase, “E sumanaia keraulen! Bauta sumanaiten, tane dima baiwa eana?” ");
INSERT INTO soq_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Mo nata waa bedewe odeieno lanunu dainalene dialen. ");
INSERT INTO soq_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Tauma wawe alala waa bedewe wanwanlala Iesu wawa bumpe imimpu emmisimone wadaposisane waienase, “Ulaipa, e ipa God Otopaida!” ");
INSERT INTO soq_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Iesu wawe alala do doa nawane waiwa dawo bola Genesaretiwa wimoiena. ");
INSERT INTO soq_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Apana sape waimoia Iesu ewane atensaiena, sa baiwa mo bola uduudu bedewe gagalo waaubasane waienase, “Kerolala banlamone Iesu mampe winlena.” ");
INSERT INTO soq_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Tane mo kerolala banlamone wimone Iesu iririsaiena me garawa moawa os wirasape inantopona. Ita kerolala uduudu mida me garawa wirasaiena inanton. ");
INSERT INTO soq_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ema aupe Parisi ita anaana waeuwalala isiwa Ierusalemwae Iesu mampe wimone waitarasane waienase, ");
INSERT INTO soq_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Dima baiwa e waawo alala no apanamba eiau waeuwau ampuiasaie witapu mai mitamoipe nana naipona, tane di nana nai?” ");
INSERT INTO soq_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Iesu mo wawu gagalowa waieno etene sipoamone wanase, “E epe wailana, tane ne e diaidaledina e God anaanawaida ampuiasaile eueuwa onape os dewamoile apana banlakadisamoilana. E dima baiwa epe dewaitilana? ");
INSERT INTO soq_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","God anaanawa bedewe wadi wadiase, ‘E mamaa ita inaa do oniadewasamona,’ ita do wadiase, ‘Mida me mamba ba inawa dabuamodie wakadisamodia, me epapubolepi.’ ");
INSERT INTO soq_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","God anaanawa epe wade, tane e God anaanawa waeuwakadisaitile apana banlakadisamoilana. Apana da mamba ba inawa oniadewasamopia baiwa nitu da mampe winedia wadedie mamba ba inawa wanepia menasade, tane e waeuwala asiasi meba wadi wadiase, ‘Ne nitu ema mai gombana enalepaa rua, dia, ne God baiwa pulonteapa.’ E apana epe insaisaleidio adiweitile wailanase dima me dewasapia mampe mai God anaanawa aneipapundeipona, dia. E epe dewaitile mampe apana banlakadisamoilano God aiawa eie e waeuwala wawentoi. E dewala sa mampe God aiawa ipasiasailana. ");
INSERT INTO soq_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","E lagawaauida! God peroweta Aisaia bukawa bedewe e umanala wandewalene wanase, ");
INSERT INTO soq_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Apana ema aiau os mampe ne eunei, tane mo nuau ipa nambeido, mai ne mainawo. ");
INSERT INTO soq_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Mo ne di wadaposinei, mo apanaida anaanau waeuwantoia abo God anaanawa rua.’” ");
INSERT INTO soq_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Tauma Iesu apana uara sape eneia apamono mampe wimono diamone wanase, “Parisi ita anaana waeuwalala wita mitamita dewawa baiwa nuau pola wade. Tane ema etane ateitana: ");
INSERT INTO soq_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Mai nitu da apana moawe iepe apana miramirasaipona, dia. Tane dima apana nuawa bedewe winedie moawe nosedia, sa ipa apana miramirasade.” ");
INSERT INTO soq_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Mape wawe alala Iesu mampe wimone wane waienase, “E ateiten ba dia, epe waie Parisi apanawa nuau kadisaiana.” ");
INSERT INTO soq_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Me sipoamone wanase, “Nitu anala uduudu dima ne Mamana uboo wandia mai ampona me bowiamopi. ");
INSERT INTO soq_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Parisi apanawa emona, mo muba emau potau tane sosou banlamoi. Apana emawa potawa me sowa emawa potawa banlepia mo nata ampusue don bedewe antopu.” ");
INSERT INTO soq_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ita Pita wane wanase, “Gagalo babawa ema ipawaida wadewasanea!” ");
INSERT INTO soq_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Iesu mo waitaramone wanase, “E do mai dima ateitipe wanleipona, ba? ");
INSERT INTO soq_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","E eweilana, ba dia, dima apana nadio bupa bedewe iedia etepa edie nosedie nambe aleide. ");
INSERT INTO soq_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Tane dima apana nuawe winedie moawe nosedia, sa ipa apana miramirasade. ");
INSERT INTO soq_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Apana nuau bedewe insaisa kadiwa nosedia baiwa mo sosou bomoi, nina dewawa rebareba dewasai, pointoi, lagantoi ita kutuntoi. ");
INSERT INTO soq_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Dewa ema uduudu apana miramirasade, tane mo waia rua apana witapa mitasiawaia nana wadepie napia, sa mai apana miramirasapia rua, dia.” ");
INSERT INTO soq_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Tane Iesu Israel tawowa ene Taire ita Saidon bolau kerakera bedeuwointa alen. ");
INSERT INTO soq_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Sape i dea wisene mukama Iesu apasane wane wanase, “Tatana, Dawid Otopa, nuaparenaitaa! Aleu kadiwa ne anona bedewe wandie dewasadio pokaida etede, mai rua!” Tane i sa mai Israel iwa, me bola Kanaan bedewe wanwanlala. ");
INSERT INTO soq_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Tane Iesu mai i aiawa da sipoasapona, dia. Tauma wawe alala Iesu mampe wimone diane waienase, “I sa waaubewo alepi, me no wambo odedie aia uara wamode.” ");
INSERT INTO soq_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Iesu sipoamone wanase, “Ne Israel apanawa os baibu waaubaneno winen, mo ipa sipsip rebalala ruau waimoi.” ");
INSERT INTO soq_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Tauma i sa Iesu mampelene imimpa emmisilene wanase, “Tatana, saunea!” ");
INSERT INTO soq_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Iesu leusane wanase, “Mai eulepona no seda nanau wadate mo elou wanamoto napu.” ");
INSERT INTO soq_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","I leusane wanase, “Tatana, sa ipa ulaipa, tane elo do mambu nana nadia karamba du atowe nosedia nai.” ");
INSERT INTO soq_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Mape Iesu i diene wanase, “Anona, e sumanaia ipa debama! Dima e iririwaitena ideita segalepi.” Iesu epe diedioma me anoopa tauwadea os inalen. ");
INSERT INTO soq_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ema aupe Iesu bola sa ene doa Galili tampeinta aleidie ita wadiwa odene aisidene wain. ");
INSERT INTO soq_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Sape apana uaraia mo sosou kero daitada wadawadalala, mo isiwa tampu bobopa, da emau potau, da etepu kiokiou ita do moau potau banlamone wimone Iesu wawa bumpe teamoieno me inamon. ");
INSERT INTO soq_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Tane apana moau potau inantone gagalontoiena, etepu kiokiou euntoiena, tampu bobopa antoiena ita emau potau sala eweio apana sape eneia ewamone memesantone Israel Godiwa wadaposisaiena. ");
INSERT INTO soq_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Iesu me wawe alala apamono me mampe wimono diamone wanase, “Ne nuana pareleide apana ema baibu, ipawa walama natadea mo ne do lakasanten ita tauma mai nana da wineipona napu. Ne mai menaneipona mo omanaomanaua waaubamopo bolauwobolauwo antompe into emau dubalepi.” ");
INSERT INTO soq_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Wawe alala Iesu diane waienase, “Bola sawanawaida, ambi dauwa ema bedewe bured donsate apana uaraia wanamoto napu?” ");
INSERT INTO soq_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Iesu waitaramone wanase, “E manlawo bured uduudu ambi winei?” Mo sipoasane waienase, “No mainimbo bured 7 ita bouri kerakera nata os winei.” ");
INSERT INTO soq_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ema aupe Iesu apana diamono dogo osowe aisintone waimoiena. ");
INSERT INTO soq_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Tauma me bured 7 ita bouri do otene God auwasano dialeno ampuialene me wawe alala wanamon, mo apana mampo amonantopuo napua baiwa. ");
INSERT INTO soq_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Mo uduudu nana sa nane pokamon. Tane wawe alala nana moawa eiena posawa 7 aimoieno nope wimon. ");
INSERT INTO soq_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Apana mona wisiawa uduudu 4000, tane ioto obampu do sape nana naiena mai wisiamopona, dia. ");
INSERT INTO soq_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Apana nana naieno dialeno tauma Iesu mo waaubamono anton ita me waa bedewe odene doa nawene bola Magadaniwa alen. ");
INSERT INTO soq_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Parisi ita Sadusi apanawa isiwa Iesu rubusapua baiwa mampe wimone waitarasane waienase, “Ginasa dewasawo ewata e ulaipa God mukawa wadaana!” ");
INSERT INTO soq_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Me sipoamone wanase, “Rawileidio e wailanase, ‘Sala bumede, imonepi omo debama ipi.’ ");
INSERT INTO soq_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ita tadinaida e wailanase, ‘Giou odedie dubaleidia ando unu wapi.’ E dima uba tampe emalawo eweile ateitilana, tane dima baiwa ande walamawa bedewe eueuwa segaleidio e eweile tane ipawaida mai ateitipona? ");
INSERT INTO soq_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Walama ande apanawa ginasa ewapua baiwa banusai, tane mo kadiwaida dewasaie ewaninantoi. E mai ginasa da ewana rua, diaida. Tane eueuwa dea os e bedelawo segalepio ewana. Eueuwa sa segalepio ewana dima mapo Iona mampe segalena rua.” Iesu epe wane mo emone alen. ");
INSERT INTO soq_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Tauma Iesu wawe alala do doa Galili nawane antoie tane wawe alala mai bured insepe wadapona. ");
INSERT INTO soq_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Intasino Iesu diamone wanase, “Parisi ita Sadusi apanawa nanau da kerauda ist parawa bedewe ituio sasanaleidia mampe ewanadewaitana.” ");
INSERT INTO soq_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Iesu wawe alala me gagalowa etane ipawaida banusaie muba eda gagalontoie waienase, “Dauwa Iesu no bured wadasiantena umanawa wade.” ");
INSERT INTO soq_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Iesu mo dima umanawa waia atenlene ita mo waitaramone wanase, “E sumanaila kerauda! Dima baiwa e bured wadasiaitena umanawa wailana? ");
INSERT INTO soq_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","E walama daumawa ne do leitana, tane e ideita mai ateitipona! E inseilana, ba dia, walamaipa ne bured 5 wadane apana 5000 wanamona e nana moawa eiena posawa uduudu ambi nopemolana? ");
INSERT INTO soq_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Tane do walamaipa ne bured 7 otene apana 4000 wanamono naiena e nana sa moawa posawa uduudu ambi nopemolana? ");
INSERT INTO soq_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","E inseilana abo ne buredida umanawa e manlawo wape waponase, ‘Parisi ita Sadusi apanawa nanau ist parawa bedewe ituio sasanaleidia mampe ewanadewaitana!’” ");
INSERT INTO soq_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Tauma mo etane atendewanton Iesu mai nana ist umanawa wapona, tane me Parisi ita Sadusi apanawa waeuwau umanawa wan. ");
INSERT INTO soq_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Iesu Sisaria Pilipai tampainta bola kerakera bedewainta wisen. Ita me wawe alala waitaramone wanase, “Dianeano etapo, Apana Otopa umanawa apana ambi wai me mida?” ");
INSERT INTO soq_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Mo sipoasane waienase, “Apana isiwa waiase e ipa Ion Babatutu bo bedewe enaawiena, isiwa waia e ipa Elaia, tane da wai e ipa Ieremaia ba peroweta tontau bedeuwo dea.” ");
INSERT INTO soq_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Mape Iesu waitaramone wanase, “Tane e ne umanana ambi wailana ne mida?” ");
INSERT INTO soq_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saimon Pita sipoalene wanase, “E ipa Keriso Inawamba, Godida wanwankasalala Otopa.” ");
INSERT INTO soq_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Iesu me sipoasane wanase, “Saimon Iona otopa, e sau euda donsana nuaa eulempa! Insaisa ema mai apanaida mampe e nuaawo odapono wapona, dia, tane ne Mamana uboo wandia insaisa ema eneen. ");
INSERT INTO soq_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Tauma ne ema epe dieedina: E ipa Pita, ebo sa ipawaida ipa seu, ita seu sa osowe ne ekelesiana wadapa. Bo mukawa ita muka da mai mukau wineipona ando ekelesia kadisapua rua, diaida. ");
INSERT INTO soq_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ne e God gonaawa kiwa eneedina, dima e tawo osowe anaanasaiana, sa ipa uboo do anaanasade, ita dima e tawo osowe wadeiaubeiana, sa ipa uboo do wadediaubede.” ");
INSERT INTO soq_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ita Iesu me wawe alala gagalo badowa mampe diamone wanase, “Mai apana da diana ne ipa Keriso God sauawalena, dia.” ");
INSERT INTO soq_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Walama sawo Iesu uwaalene wawe alala sabamo waeuwamodie wanase, “Ne God insaisawa ituna rua Ierusalemwa odape anteapa ita poka daitada apana eiau, pirisi debamau ita anaana waeuwalala mampo etaidasapa. Mo ne boneapu tane walama natadeawo ne bo bedewe enapawineapa.” ");
INSERT INTO soq_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Mape Pita Iesu banlene nambesane badowa diene wanase, “Tatamba, God sauwa mampe dewa inainamba ema mai segalepi e manawo.” ");
INSERT INTO soq_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Iesu leulentue Pita diene wanase, “Seitan, nambe aitaa! E ne intana bodeiana, ipawa e insaisaa ema mai God mampea tane apanaida mampea!” ");
INSERT INTO soq_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Sape Iesu me wawe alala diamone wanase, “Me mida ne warorona menasampa mai meba insaisawa wadepi, diaida. Tane dima uduudu nuawa teinedia dabuamopie emopituwapi. Ita meba korosiwa, sa ipa poka saiwa God ituna awanepi. ");
INSERT INTO soq_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tane apana mida meba inawawa wadediitudedia me inawawa rebaidasapi, tane apana mida meba inawawa edie ne bainaleidia me inaida donsapie wankasalepi. ");
INSERT INTO soq_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Naita apana da tawo manewa uduudu ita ewanuauwa daitada otamodie mampemodie boleidia dima euwa tawo ewanuauwa sa bedewe donsapie wadepi? Me tawo ewanuauwa sa do awanamopie alepie nitu sa mampe inawawa gimaralepie leusapie wadepi, ba? Di diaida! ");
INSERT INTO soq_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ne epe wadina, ipawa Apana Otopa me Mamba sapawa ita me enseliwa sapau do leulepi wisepie ita apana deadea dima dewasana rua unewa wanamopi. ");
INSERT INTO soq_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ne ulaipa dialedina, apana isiwa e bedelawo mape eneia Apana Otopa me gonaawa bedewe wisepio ewapu, mo mai ewasasia waimompe di bontopu, dia.” ");
INSERT INTO soq_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ema aupe walama 6 diantono Iesu me wawe alala bedeuwo Pita, Iems ita me wamba Ion otamone muba os wadi debama iwe banlamone odane anton. ");
INSERT INTO soq_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Sape wimone tauma Iesu mo danauwo inainamba leulene da segalen ita me namba sapa wan omo sapawa rua. Ita me garawa do kibokiboralene sapaida wan. ");
INSERT INTO soq_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Tauma wawe alala natadea sape eneio Moses Elaia nata segantone Iesu do gagalontoio ewamoiena. ");
INSERT INTO soq_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ita Pita Iesu diene wanase, “Tatamba, ide dewantene bola ema euda bedewe winen. E meneempa ne ape natadea wadamopa, dea e baia, dea Moses baiwa ita da Elaia baiwa.” ");
INSERT INTO soq_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita gagaloleidioma giou sapusapua aisidene nosene mo taubodamono ita giou bedewe aia segalene wanase, “Ema ipa ne nuawadawadana Otopaida, nuana eusadio wainedina. Me aiawa etanadewaitana!” ");
INSERT INTO soq_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Wawe alala aia ema etane saidantone mo imimpu emmisintone dunenton. ");
INSERT INTO soq_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Tane Iesu mo mampo wisene ibubu wadene diamone wanase, “Enana, mai saitana!” ");
INSERT INTO soq_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Mo enane pisiwane tane Iesu meba enedio eweiena, mai mida da, dia. ");
INSERT INTO soq_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Tauma mo wadi iwe leuntone ieie into Iesu diamone wanase, “Dima e ewalana mai apana da benemamono etapu, dia. Tane Apana Otopa bo bedewe enepiwisepio tauma benemaitano apana atentopu.” ");
INSERT INTO soq_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Sape wawe alala Iesu waitarasane waienase, “Dima baiwa anaana waeuwalala waie waiase, ‘Peroweta Elaia bauta wisepio wawe Keriso mida God saualena wisepi?’” ");
INSERT INTO soq_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Iesu sipoamone wanase, “Elaia ideita bauta wisepi ita nitu uduudu aupo teadewasamopie imaamopi. ");
INSERT INTO soq_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ne dialedina Elaia aitamana wisen, tane mo me mai atensapona, tane mo insaisau rua dewasane me bosaiena. Deawaa Apana Otopa pokaida etepi mo mampo.” ");
INSERT INTO soq_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Wawe alala aia ema etane atentoiena dima Iesu Elaia umanawa wana, sa ipa me Ion Babatutu umanawa wadie. ");
INSERT INTO soq_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Mo wadiwae leuntone iane apana uara mampo nomono apana dea Iesu mampelene imimpa emmisilene ");
INSERT INTO soq_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","wane wanase, “Tatamba, ne otona nuaparewaitaa, me walamawa wisedio uwawa koakoaleide ita poka debama etede. Me guriboboleidie ia iilala ita esa bedewe omedie aleide. ");
INSERT INTO soq_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ne me banlene e waawo alala mampo winene iririmona inasapona baiwa, tane mo rubusanalewanton.” ");
INSERT INTO soq_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Iesu leusane wanase, “Walama ande apanawa ambi e sumanaisiawaiaida, insaisala do kiokiowa! Mapo os e ne do wankasantene dialedino os wainilee, tane mai sumanaitapona, dia! E baila ne poka etaidasadina. E aitane oto sa banlene mainawo winlena!” ");
INSERT INTO soq_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Mo oto kerola banlene wimono Iesu aiawa badowa mampe aleu kadiwa taneno nosene alen ita oto tauwadea os inalen. ");
INSERT INTO soq_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ema aupe wawe alala Iesu mampe wimone werego waitarasane waienase, “Dima baiwa no aleu kadiwa mai tanapona rua?” ");
INSERT INTO soq_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Me sipoamone wanase, “E sumanaila kerauda baiwa mai tanana rua, dia. Ne ulaipa dialedina sumanai mampe dewa uduudu e dewasana rua. Naita e sumanaila paipai naumba kerauda rua manlawo winompa e rua os wadi ema diane wanase, ‘Riaite sisi aitaa,’ ruawa me rialepi.” ");
INSERT INTO soq_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Iesu wawe alala do Galili bedewe auweieno tauma Iesu mo diamone wanase, “Apana Otopa mo laga mampe nanantopue apana witaposapuo ");
INSERT INTO soq_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","bosapu. Tane walama natadeawo me bo bedewe enepiwisepi.” Me wawe alala aia ema etane nuau pareidalen. ");
INSERT INTO soq_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Iesu wawe alala do Kapeanaum bedewe wimoio God duwa manewa tamalala dea Pita mampe wisene waitarasane wanase, “E debamala God duwa manewa itude, ba dia?” ");
INSERT INTO soq_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pita me sipoasane wanase, “Oa, me mane itude.” Pita du bedewe odeno Iesu Pita waitarasane wanase, “Saimon, e ambi inseiana? Tawo warereu apana dainea mampo mane wadei? Mo muba apanau mampo ba bola da apanawa mampo?” ");
INSERT INTO soq_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pita leusane wanase, “Bola da apanawa mampo, mai muba apanau.” Iesu me sipoasane wanase, “E waadewaiten, warere bolawa apanawa mai mane itupu, dia. ");
INSERT INTO soq_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Tane no mai menaneipona God duwa manewa tamalala apanawa nuawa kadisata. Sa baiwa doa tampe aitee kaimoitaa, ita bouri bauta teinea moawa wadaake bedewe mane nepa dea donsaa. Mane nepa sa rualepio God duwa manewa tamalala wanamoa e ne nata baimba.” ");
INSERT INTO soq_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Walama sawo Iesu wawe alala wimone me waitarasane waienase, “Mida ipa debamawaida God gonaawa bedewe?” ");
INSERT INTO soq_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Iesu gagalo ema etene oto kerauda apasane mo sawanauwosane euwamone wanase, ");
INSERT INTO soq_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“Ne ulaipa dialedina, mai mida God gonaawa bedewe odepia rua, dia! Dea os, mida insaisawa uduudu leusadie oto kerauda ruawaleidia me ipa God gonaawa bedewe odepi. ");
INSERT INTO soq_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ita mida oto ema rua meba molaaisileidia me ipa debamawaida God gonaawa bedewe. ");
INSERT INTO soq_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Mida sowa ebowasiawaia oto kerauda ema rua ne ebonawo wadedie mampesadie simbiasadia, me ipa ne wadanedie mampesadie simbianede.” ");
INSERT INTO soq_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Apana mida seda kerakera bedeuwo dea ne mainawo sumanaileidia dewasapio sumanaiwa dialepia, me ipa matangelawa debamaia donsapi. Epe segalepia sawa eulena apana sa gadompawe seu debama taupadoe owa bedewe aubepono alepona. ");
INSERT INTO soq_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ambi kadiwa rebarebaida tawo apanawa baibu mo mida sumanailala banlakadisamoio sumanaibu eie omeia. Dewa ema ideita segantopu, tane ambi kadiwa rebarebaida apana mida dewa ema dewamoio segantoia mampo. ");
INSERT INTO soq_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Naita e witaa ba waa banlaepio kadi dewasae sumanaia bedewe omea tauwadea topuiamoe aubamoa! E witaa ba waa dea os do inawinakasalawo odaa, sa ide. Tane mai ide e witaa ita waa nata do ia iilalawo aitaa! ");
INSERT INTO soq_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Naita e emaa banlaepio kadi dewasae sumanaia bedewe omea tauwadea enasopoe aubea! E emaa dea os do God gonaawa bedewe odaa, sa ide. Tane mai ide e emaa nata do bola kadiwa bedewe aubaepu.” ");
INSERT INTO soq_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","“E ewanadewaitana ita mai oto kerauda da ewanadabuasana, ipawa ne dialedina ensel mo oniamoia walama uduudu ne Mamana uboo wandia danawe enei. ");
INSERT INTO soq_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","E ambi inseilana, naita apana dea sipsip 100 gamomoipe, tane dea os nambe alepie rebalepio me dima dewasapi? Me ideita sipsip 99 wadi sainape emopie rebala dea banuwa alepi. ");
INSERT INTO soq_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ne ulaipa dialedina, me sipsip sa donsapie nuawa eudidalepi sipsip sa baiwa, mai sipsip 99 isiwa waimoidewantoia rua. ");
INSERT INTO soq_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Deawaa, e Mamala uboo wandia mai menasaipona oto da kerauda nambe alepie rebalepi, dia.” ");
INSERT INTO soq_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Naita e sumanai soa e manawo kadi dewasapia, me nata gagaloitane kadi sa euwasaa. Me e asisuepia, sa ipa e soa kadi bedewe leusaana. ");
INSERT INTO soq_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Me e mai asisuepia apana dea ba nata do me mampe aitane me do gagaloitana. Inta ema bedewe gagalo uduudu benema apana nata ba natadea mampe ulaipalepi buka bedewe girumalena rua. ");
INSERT INTO soq_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Naita mo do mai asisumopia ekelesia uduudu mampo me kadiwa gagalowa benemaitaa. Tane ekelesia me gagalosapuo mai etepie ruawalepia tauma me dewasaa ewaewawa abo me takis manewa tamalala lagawaau ba apana ebou kadiwa wawalala ruau. ");
INSERT INTO soq_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ne ulaipa dialedina, dima e tawo osowe anaanasailana, sa ipa uboo do anaanasade, ita dima e tawo osowe wadeilaaubeilana, sa ipa uboo do wadediaubede. ");
INSERT INTO soq_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Tane do ne dialedina, apana nata e bedelawo insaisau dealepio dima umanawa iririwantompa, ne Mamana uboo wandia etamopie ideita mo baibu dewasapi. ");
INSERT INTO soq_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ne epe wadina, ipawa sumanai apanawa nata ba natadea ne ebonawo auweia sape mo bedeuwo ne do.” ");
INSERT INTO soq_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Mape Pita Iesu mampelene waitarasane wanase, “Tatamba, sumanai sona mainawo kadi dewasapia walama uduudu ambi ne me kadiwa insepadabuasapa? Walama uduudu 7 ide, ba?” ");
INSERT INTO soq_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Iesu sipoasane wanase, “Mai walama 7 os, dia! Walama 7 ita osoweosowe soa kadiwa inseadabuasaa, tane mai ea, walama uduudu kadiwa insenadabuasana! ");
INSERT INTO soq_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","E ema epe waitaraneana baiwa ne gagalo babawa ema dialedina. God gonaawa ema epe rua: Warere debama dea menasana me sauwa apanawa nolau ewepie atenlepi mo mane onieidewantoi, ba dia. ");
INSERT INTO soq_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Me nolawa sa uwaaleidio mo apana dea banleieno warere mampe wisen. Apana sa mane debamaia, mai mida malesalepia rua, me warerewa mampe wadene tane mai sipoasape wanapona, dia. ");
INSERT INTO soq_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Tane tauma me mampe mai mane da wineipona ita warere sipoasapie wanepi. Sa baiwa warere me nolawa dewalala diamone wanase, ‘Apana ema, manainapa obampa do, ita uduudu me mampea do otene gimaramone ita mane sa wadane ne neana.’ ");
INSERT INTO soq_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Tauma sau apanawa sa epe etene warere danawe imimpa emmisilene iririlene wanase, ‘Nuaparenaitaa, walama dawo mane donsape tauma uduudu sipoaepa!’ ");
INSERT INTO soq_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Mape warere me nuaparewalene insendabuasane diene wanase, ‘Ne sauena, ee aitaa, mai mane sa sipoanea, dia.’ ");
INSERT INTO soq_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ita apana sa warere ene nosene aleidie me nola sowa da into donsan. Me sowa sa mane kerauda insadabualala me mampe wadene ita mai sipoasapona. Me sowa sa wadene imumba wadendoe diene wanase, ‘Tauwadea manena sipoasaa!’ ");
INSERT INTO soq_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Mape apana sa imimpa emmisilene iririsane wanase, ‘Nuaparenaitaa, walama dawo mane donsape tauma ne uduudu sipoaepa!’ ");
INSERT INTO soq_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Tane me dabualene diene wanase, ‘Ne menanedia e tauma manena sipoasaa, mai ando, dia!’ Ita me sowa kotusane diburasan me ideita manewa sipoasapie tauma dibura epie nosepi alepi. ");
INSERT INTO soq_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Tane warere sauwa apanawa isiwa dewa ema ewane nuau siga wano warere mampe antone ema uduudu umanawa dieiena. ");
INSERT INTO soq_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Mape warere sauwa apanawa mida me bauta mane debamaia sausane insendabuasana apasano odeno diene wanase, ‘E sau apanawa kadiwaida, e iririneano baiwa sauene mane debamaia wadaana insenadabuasana. ");
INSERT INTO soq_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","E nola soa da do nuaparewaitapona ne e nuapareantena rua.’ ");
INSERT INTO soq_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Warere nuawa kadiidaleno ita sau apanawa sa dibura onioniala witaposan poka etepia baiwa. Me sape waimpe mane uduudu sipoasapitue tauma me nosepi alepi.” ");
INSERT INTO soq_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Iesu gagalo babawa ema diasane wane wanase, “Insenadewaitana, naita e mai nuala uduudu mampe sola kadiwa insenadabuasana ne Mamana uboo wandia deawaa dewasapi e manlawo.” ");
INSERT INTO soq_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Iesu gagalo ema uduudu diasane Galili ene Iudia bedewainta esa Ioadan waiwa dawo alen. ");
INSERT INTO soq_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Apana uaraia me warorosane antoiena, ita mo bedeuwo kerolala isiwa me inamon. ");
INSERT INTO soq_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Sape Parisi isiwa wimone gagalo mampe Iesu rubusaiena me wapakadisapono wawusapona baiwa. Mo Iesu diane waienase, “E no dianewo etato no anaanamba ambi wade, apana manainapa nitu da kadisapio baiwa me dabuasapie epia intawa da winede, ba dia?” ");
INSERT INTO soq_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Iesu sipoamone wanase, “Buka bedewe e wisiaitene ateiten, ba dia, God bumpeido apana mona ita i auwepue waimompaa baiwa dewamone teamon. Mai nambenambe waimompaa baiwa teamopona, dia. ");
INSERT INTO soq_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ita God wane wanase, ‘Ne apana mona ita iwoa dewamona, ipawa ema baiwa apana mona me mamba ita inawa do emopie i mampelepi. Ita mo nata deaidantopue ete dea os waimompa.’ ");
INSERT INTO soq_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","God nainai bedewe apana mona ita i deaidamono waimoi, sa baiwa mo mai empuempuntopue nata segantopua intawa da wineipona, diaida!” ");
INSERT INTO soq_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Mape mo Iesu waitarasane waienase, “Tane dima baiwa Moses epe girumalene wanase, ‘Apana manainapa epia menasampa me manainapa epia gagalowa girumalepie sowa wanepie wapiaubepio alepi bolawe.’” ");
INSERT INTO soq_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Iesu sipoamone wanase, “E nuala badoidaleno baiwa Moses anaana ema epe girumalene ituno e ruawaitilana. Tane God bumpeido uba ita tawo dewasanawo me mai epe insepona, diaida. ");
INSERT INTO soq_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ne dialedina, apana mida me manainapa dabuasadi edie tane i da naisedia, me ipa ninaleide. Tane i bauta nosene alene apana da nata ninanton, epe segalena baiwa apana i epio alepia rua.” ");
INSERT INTO soq_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Wawe alala gagalo ema etane Iesu diane waienase, “Naita dewa inainamba ema epe apana i nata mampo winompa, eulena mo mai nainaintopu.” ");
INSERT INTO soq_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Iesu sipoamone wanase, “Gagalo ema badowa mai apana uduudu etapua rua, tane mo mida insaisau wanamona, mo etapua rua. ");
INSERT INTO soq_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ema epe baiwa apana isiwa mai nainaintopua rua: Apana isiwa mo epe muwantona baiwa mai nainaintopu, tane isiwa apana mo etepu nomone kadimoiena baiwa mai nainaintopu, ita isiwa God gonaawa baiwa mai nainaintopu. Mida gagalo ema etaeta menasapia me etepi.” ");
INSERT INTO soq_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Apana otooto kerakera banlamone Iesu mampe wimoiena me witapa osouwo itupie ita mo baibu rauparilepia baiwa. Wawe alala mo epe dewantoio ewamone apana onau wane bodamoiena. ");
INSERT INTO soq_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Mo epe dewantoio Iesu wane wanase, “Otooto kerakera emono ne mainawo wimpu, mai enabodamona, ipawa God gonaawa ipa otooto kerakera ema ruau mampoa.” ");
INSERT INTO soq_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ita me witapa mo osouwo ituno dialeno bola sa ene alen. ");
INSERT INTO soq_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Apana dea Iesu mampelene waitarasane wanase, “Debamamba, ne dewa dainea euwa dewasape inawinakasala donsapa?” ");
INSERT INTO soq_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Iesu me sipoasane wanase, “Dima baiwa e dewa euwa waitarawaneiana? God me meba os euda, mai mida da. E inawinakasala meneempa God anaanawa ruawaitaa.” ");
INSERT INTO soq_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Me sipoasane wanase, “Anaana dainea ne ruawanteapa umanawa waiana?” Iesu me diene wanase, “Soa mai bosaa, mai ninaitaa, mai poitaa, mai lagaitaa, ");
INSERT INTO soq_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","mamaa ita inaa oniadewasamoe aiau ruauitona, tane do sosoa tanawoa nuawadawadamona e eba nuawadawadaitiana rua.” ");
INSERT INTO soq_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Mape apana sanaa wane wanase, “Ne anaana ema uduudu ruawantentuwan, dima enanosiden?” ");
INSERT INTO soq_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Iesu leusane wanase, “E dodomanaidaitaa meneempa aite dima manawo wineia gimaramoe manewa wadee apana nuaparelala wanamoa. E epe dewaitawo uboo mauraa debamalepi. Ne aiana ema ruawaite dewasae tauma wanawo winea.” ");
INSERT INTO soq_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Apana sanaa gagalo ema etene puraiwawa uaraia osowe mauraleidie wandia insamone nuawa pareidaleno ene alen. ");
INSERT INTO soq_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ita Iesu wawe alala diamone wanase, “Ne ulaipa dialedina, maura apanawa God gonaawa bedewe odaodawa badowaida. ");
INSERT INTO soq_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ne dialedina, pue debamaia ebowa Kamel mai selau nagawa bedewe odepia rua, dia. Deawaa, apana puraiwa insaisawaleidia, me mai God gonaawa bedewe odepia rua, diaida.” ");
INSERT INTO soq_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Wawe alala inseia puraiwa apanawa God sauwa euda donsaie baiwa maurantoie waimoia God gonaawa bedewe odapua rua. Tane mo gagalo ema etane memesaidantone waitarantone waienase, “Ema ambi, apana da inalepia intawa da winede, ba dia?” ");
INSERT INTO soq_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ita Iesu mo diadewasamone wanase, “Apana mampo mai inantopona intawa da wineipona, dia, tane God mampe inta wadaaubala winede, ipawa me dewa uduudu dewasapia rua.” ");
INSERT INTO soq_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pita sipoasane wanase, “No nitu uduudu emote e waawo leitana! Tauma dima no baimba winedia wadata?” ");
INSERT INTO soq_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Iesu mo diamone wanase, “Ne ulaipa dialedina, nitu uduudu sanaalempaa walamawa osowe Apana Otopa kolaiwatawa sapawaida bedewe waimpo e mida ne waroronealana do kolaiwata 12 osouwo waine ita Israel apanawa dambu uduudu 12 oniamona. ");
INSERT INTO soq_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ita apana mida duwa, tatatawa, wanwamba, weaweanapa, mamba, inawa, obampa ba iraiwa ne baina emodia me ando dima emona ruawalepie uaraia eiasampe otempa ita do inawinakasala donsapi. ");
INSERT INTO soq_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ewane, mo mida Gagalo euda muriwa os eteie sumanaintoia God gonaawa bedewe bautantopue odapu. Tane mo mida Gagalo euda bautantone etane atentoiena muriwantopue God gonaawa bedewe odapu.” ");
INSERT INTO soq_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Iesu wane wanase, “God gonaawa ipa ema epe: Irai apanawa dea tadinaida apana auweia bolawe alene apana isiwa dommone diamona wimopue me baiwa wain iraiwa bedewe nolantopu. ");
INSERT INTO soq_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Me mo diamona walama sa dea bedewe nolantopua mane nepa deadea wadapu. Me epe diamono dialeno waaubamono nola awa wain iraiwa bedewe antoiena. ");
INSERT INTO soq_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Mo nolantoio omo tontaleno wain iraiwa apanawa osowe apana auweia bolawe alene apana isiwa di enakoantoio dommon. ");
INSERT INTO soq_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ita me mo diamone wanase, ‘Ne menanedia e do aitane ne baina wain iraiwa bedewe nolaitano malesadewalepa.’ ");
INSERT INTO soq_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Mo me epe diamona ruawantone wain iraiwa bedewe nolantopua baiwa anton. Mo auwene nolantoie laio enautaleno irai apanawa osowe apana auweiawo alene apana isiwa diamona antopue me baiwa wain iraiwa bedewe nolantopu. Mo me wana ruawantone nola awa antoiena. Tane omo kekeraleidio irai apanawa dewaipa deawaa dewalene nola apanawa isiwa diamono iraiwa nolawa awa anton. ");
INSERT INTO soq_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Mo uduudu nolantoie laio rawileidio irai apanawa osowe apana auweia bolawe alene apana isiwa di eneie laio ewamone waitaramone wanase, ‘E dima baiwa tadinaida ita tauma nolalasiawaia di eneilano rawilen?’ ");
INSERT INTO soq_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Mo leusane waienase, ‘No nola anuwa wainitano mai mida da wisepe nola baiwa dianepona, dia!’ Irai apanawa epe etene diamone wanase, ‘Ne menanedia e aitane ne baina wain iraiwa bedewe nolaitana.’ ");
INSERT INTO soq_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Tane rarapirileidio irai apanawa nola dewalala oniamodia apanawa diene wanase, ‘E apana nolantoia diamowo wimoputuwapio malesamoa. Ne menanedia e malesa baiwaitone apana dainea nola baiwa muriwa wimoiena bauta malesamoe, aupe aite apana bauta nola awa wimoiena malesamoa.’ ");
INSERT INTO soq_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Oniamodia apanawa apana mida muriwa rawileidio wimoiena mane nepa dea wanamono oteiena. ");
INSERT INTO soq_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Tane apana bautantone tadinaida nola awa wimoiena sosou ewamoio malesau wadeiena ita mo nuau bedewe inseia mo tadinaida wimoiena baiwa malesau debama wadapu, mai mo ruau. Ita mo malesau wadapua awa antone mane nepa deadea sosou wadeiena rua wanamono wadeiena, mai osowesape wadapona, dia. ");
INSERT INTO soq_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Tane mo malesau wadane ewane nuau kadileno irai apanawa mampe antone momoduntone waienase, ");
INSERT INTO soq_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘No sosomba sa muriwaido wimone mai nolantopona daumawa, omo dea os bedewe nolanton, tane mo malesa no wadatana rua deawaa wadeiena. Sa ipa ambi? No nola pokaidaneno pola ainimbo noseno omo pokawaida etatano mai malesadewanepona, dia!’ ");
INSERT INTO soq_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Mo epe momoduntoio irai apanawa sou dea diene wanase, ‘Sona, ne mai e malesakadiepona, dia! Ne e dieena walama dea bedewe nolaitawo mane nepa dea eneepa, ita e nuaa euleno oaitene nola awa wien. ");
INSERT INTO soq_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","E malesaa ipa sa wade ene aitaa! Ne menanedia nola dewalala muriwa nola awa wimoiena deawaa wanamopa. ");
INSERT INTO soq_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Mane ne os mainawoa nola dewalala malesamodina, ne neba insaisana rua dewasapa, e di momoduitiana. Ne apana amonala dewana euda osowe e epe dewaitiana, ba?’” ");
INSERT INTO soq_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ita Iesu gagalo babawa ema diasadie wane wanase, “Nola dewalala muriwalala bauta malesa wadeiena rua mo mida Gagalo euda muriwa eteie sumanaintoia God gonaawa bedewe bautantopue odapu. Tane mo mida Gagalo euda bautantone etane atentoiena muriwantopue God gonaawa bedewe odapu.” ");
INSERT INTO soq_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Iesu Ierusalemwa odene aleidie wawe alala 12 diamono apana emone awoantoieno muba os mampo gagalolene wanase, ");
INSERT INTO soq_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Etanee, no odate antitana Ierusalemwa, sape Apana Otopa wadapue pirisi debamau ita anaana waeuwalala mamposapuo insaisau rua me mampe dewasapu. Mo me kotusapue bowa sauawa wapue ");
INSERT INTO soq_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ita Rom gabemaniwa mamposapu. Mo me oiwa wapue, tai mampe epompe ita koros osowe seupuo bolepi. Tane walama natadeawo me bo bedewe enepiwisepi.” ");
INSERT INTO soq_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Iesu ema wano aupe Sebedi manainapa obampa nata do Iesu mampe wimoiena. Ita inau Iesu wawa bumpe imimpa emmisilene waitarasane wanase, “Rua ba dia, e ne insaisana dewasaa?” ");
INSERT INTO soq_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Tane Iesu i waitarasane wanase, “E dima meneede?” I sa leusane wanase, “Ne menanedia e sauanea warereitona walamawa osowe ne obaina ema nata witaa on ita sen deneuwe wampuo e do waina.” ");
INSERT INTO soq_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Iesu Iems Ion nata sipoamone wanase, “E mai ateitapona dima menalena iririwaitilana! Poka etaetala reduwa ne napaa baiwantedina e inseilana nana rua, ba?” Mo leusane waienase, “Oa, no nataa rua!” ");
INSERT INTO soq_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ita Iesu mo diamone wanase, “E ulaipa ne pokana reduwa napino ideita nana! Tane ne mai mukana wineipona e sonabalepo da witana on ita da sen deneuwe waina. Ne Mamana bola sa imaamon mida me sonabamona os sape wampua baiwa.” ");
INSERT INTO soq_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Wawe alala isiwa 10 ema umanawa etane mo sosou nata mampo nuau kadiidalen. ");
INSERT INTO soq_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Tane Iesu mo uduudu apamone auwamone wanase, “E ateiten bola daitada onionialala apanawa mo bolau bedewe wanwanlala osouwo muka uduudu wadei ita kasawogantoie oniamoie badowa diamoio ruauntoi. ");
INSERT INTO soq_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Tane e mai epe rua dewasana! Mida e bedelawo debamalepia menasampa me sosowa nolau dewala wanalepie simbiamompa. ");
INSERT INTO soq_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ita mida e bedelawo ebowa debamalepona menasampa me sosowa uduudu atouwolempe simbiaulempa. ");
INSERT INTO soq_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Apana Otopa mai ebowa debama wadepio apana me simbiasapua baiwa wisepona, dia. Me wisena apana simbiamopie inawawa itupi epie apana uara kadi bedewe malesamopie inamopia baiwa.” ");
INSERT INTO soq_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Iesu wawe alala do Ieriko ene antoio apana uara mo waroromoiena. ");
INSERT INTO soq_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Tane apana emau potawa nata inta waiwe waimoie Iesu tampointa wisene aleidio umanawa eteiena. Sa baiwa mo mukantone wane waienase, “Tatamba, Dawid Otopa, no nuaparembaite saunea!” ");
INSERT INTO soq_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Tane apana uara mo wadabuamone diamoiena dainantopu. Ita mo etanadabuasane osowe mukantone waienase, “Tatamba, Dawid Otopa, no nuaparembaite saunea!” ");
INSERT INTO soq_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Iesu mo sau baiwa waio aindo enene mo apamono wimono waitaramone wanase, “Ne dima e baila dewasapaa menaledio iririneilana?” ");
INSERT INTO soq_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Mo sipoasane waienase, “Tatamba, no menanedia e inanewo sala ewata!” ");
INSERT INTO soq_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ita Iesu mo nuapareulene witapa emau osowe ituno tauwadea emau euleno sala ewane Iesu warorosaiena. ");
INSERT INTO soq_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Iesu wawe alala do Ierusalem mampentoie bola Betipage bedewe wadi Olib tampe wimoiena. Sape Iesu wawe alala nata waaubamone ");
INSERT INTO soq_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","diamone wanase, “E nata bola sisi nanlanepe winediawo aitana. Bola sawo odonune tauwadea pue donki inawa otopa do taudomoiena ewamona. Pue sa lotoaubamone banlamone ne mainawo winlena. ");
INSERT INTO soq_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Apana da ambi dialepia me diane wanase, ‘Tatamba pue ema menasade.’ Me aia sa etepie pue tauwadea waaubamopio banlamone winlena.” ");
INSERT INTO soq_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Tane Iesu wawe alala epe diamona, sa ipa dima peroweta bukawa bedewe girumalena ulaipalepia baiwa. Peroweta bukawa bedewe epe girumalene wadiase, ");
INSERT INTO soq_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Ierusalem apanawa ema epe benemamoa, ‘Ewana, e warerela manlawo iede! Me etepa molaaisiwa donki osowe waine aleide, me donki sanaa osowe waine iede.’” ");
INSERT INTO soq_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ita wawe alala antone Iesu diamona rua dewasaiena. ");
INSERT INTO soq_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Mo donki otopa do banlamone wimone mo garau onapea pue osouwo teamoieno ita Iesu osowe odene wain. ");
INSERT INTO soq_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Tane apana uara sape mo do laia garau onapea inta osowe abumoie. Ita sosou da notonkela asiwa tomoiena inta osowe teamone antoieno osowainta Iesu donki osowe waine aleidie. ");
INSERT INTO soq_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Apana Iesu danawe ita adiwe enane antoia mo aiau mukama wane waienase, “Osana, Dawid Otopa wadatapos! Euda me mampe mida God ebowe iediawo! Osana, God ionoidoa wadaposisate debamasata!” ");
INSERT INTO soq_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Iesu Ierusalemwa odedio apana sape wanwanlala uduudu nuau bumeno waitarantone waienase, “Me mida?” ");
INSERT INTO soq_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Tane apana isiwa sipoamone waienase, “Sa ipa peroweta Iesu, me bolawa Nasaret Galili bedewe.” ");
INSERT INTO soq_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Iesu God duwe odene leidie mo uduudu sape gimarantoie waimoie laia ewamone nuawa kadiidaleno tanamono nomone anton. Me mane leusaia apanawa watau ita do nene gimaralala watau memaaubamon. ");
INSERT INTO soq_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Me diamone wanase, “Buka bedewe girumalena ema epe wadi wadiase, ‘Ne duna ipa uwa daitada apanawa rauparintompaa duwa.’ Tane e dewasalana poiwaa auwempaa dubu wanalen.” ");
INSERT INTO soq_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","God duwa bedewe apana emau potau ita apana etepu kiokiou Iesu mampe wimono me inamon. ");
INSERT INTO soq_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Tane pirisi debamau ita anaana waeuwalala Iesu dewa eubu dewamodio eweiena ita do seda kerakera God duwa bedewe ka waie waiase, ‘Osana, Dawid Otopa wadatapos,’ mo etamone nuau kadiidalen. ");
INSERT INTO soq_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ita mo Iesu diane waienase, “Seda dima waia e eteiana, ba dia?” Iesu sipoamone wanase, “Oa, ne etedina! Tane e buka bedewe ema wisiaitene ateiten, ba dia, naepe wadi wadiase: ‘E seda kerakera ita otooto gegelau dewamoano e eboa wadaposisai.’” ");
INSERT INTO soq_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ema aupe Iesu mo emone Ierusalemwae nosene Betani bedewe alene sape wandie. ");
INSERT INTO soq_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Imonemba tadinaida me leulene Ierusalemwa aleidie omanaton. ");
INSERT INTO soq_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Sape inta waiwe me karakai iawa ewene mampe alen korou napia baiwa, tane ewensuden, asiwa os ewamon. Tauma Iesu karakai iawa diene wanase, “E mai osowe naua, dia!” Ita ia sa tauwadea os rorolene tonaidalen. ");
INSERT INTO soq_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Tane wawe alala dewa ema ewane memesantone waitarantone waienase, “Ambi karakai iawa tauwadea rorolene tonaidalen?” ");
INSERT INTO soq_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Iesu sipoamone wanase, “Ne ulaipa dialedina, naita e manlawo sumanai winompa ne dima karakai iawa ema mampe dewasana deawaa e dewasana rua. Ita do e rua os wadi ema diane wanase, ‘Enawie aite owa bedewe aubaubaitaa!’ E nuala bedewe mai insakoaitana ba sumanaila mai keraulepi, tane sumanaiidaitano ipawaida ando segalepi. ");
INSERT INTO soq_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Naita e sumanaitane dima raupari bedewe iririwaitonuna ideita wadana.” ");
INSERT INTO soq_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Iesu Ierusalemwa leulene wisene God duwa bedewe odene waeuwaleidio pirisi debamau ita apana eiau me mampe wimone waitarasane waienase, “E muka dainea mampe dewa ema dewamoiana? Mida muka eneen?” ");
INSERT INTO soq_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Iesu sipoamone wanase, “Ne waitara dea dialepo sipoaneano muriwa ne dialepa ne mukana na wadane dewa ema dewamodina. ");
INSERT INTO soq_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","E dianeano etapo, Ion mukawa na wadene nolaleidie? Me God mukawa mampe apana babatutumodie ba apanaida mukawa mampe?” Iesu epe wane diamono muba inta banusaie gagalontope ambi wapona baiwa. Ita muba gagalontone waienase, “No ambi wata? Naita no wataase, ‘Ion God mukawa mampe nolaleidie apana babatutumodie,’ Iesu dianepie wapiase, ‘Naita epeewo, e dima baiwa me mai sumanaiwaitapona?’ ");
INSERT INTO soq_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Tane no mai rua wataase, ‘Ion apanaida mukawa waden,’ ipawa apana uduudu sumanaintone atenton Ion ipa peroweta God wanaubena.” ");
INSERT INTO soq_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ita mo apana nuau kadisapua sawantone Iesu lagasane waienase, “No Ion mukawa na wadene apana babatutumodia mai atentepona, dia!” Mo epe waieno Iesu diamone wanase, “E ne waitarana sipoa mai dianeapadewaitapona, sa baiwa ne mai dialepa mukana na wadane dewa ema dewamodina.” ");
INSERT INTO soq_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Iesu osowesane wanase, “Apana dea me obampa nata do waimoie. Me otopa tautua mampe alene diene wanase, ‘Otona, ande aite wain iraiwa bedewe nolaitaa!’ ");
INSERT INTO soq_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Otopa tautua sipoasane wanase, ‘Ne dabuanen, mai dewasapa!’ Tane muriwa me insaisawa leusane irai awa alen. ");
INSERT INTO soq_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Tauma mambu otopa kerauwa mampe alene deawaa diene wanase, ‘Otona, ande aite wain iraiwa bedewe nolaitaa!’ Me sipoasane wanase, ‘Oa, ne dewasapa!’ Tane muriwa me dabualen, mai nola awa alepona, dia. ");
INSERT INTO soq_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Tauma e ambi inseilana, oto dainea dima mambu menasadia rua dewasan?” Mo sipoasane waienase, “Otopa tautua.” Iesu sipoamone wanase, “Ne ulaipa dialedina, takis manewa tamalala ita ioto ninalala bautantoie nanlanepe God gonaawa bedewe odei. ");
INSERT INTO soq_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ne epe wadina, ipawa Ion wisene ita God intawa euda dodomana euwalen, tane e mai sumanaiwaitapona, dia! Tane takis manewa tamalala ita ioto ninalala me sumanaiwanton. Mo epe dewantoio e ewalana, tane e mai insaisala leusape kadiwa epona, do Ion mai sumanaiwaitapona, dia.” ");
INSERT INTO soq_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ita Iesu wane wanase, “Tauma ne gagalo babawa da wapo etana: Apana dea wain irailene gonaalen. Ita me wain gadawa empidodepia baiwa don ton. Do iraiwa oniempaa duwa wadene diasane wain iraiwa oniepua apanawa witaposane diamona odawa moawa ando wanapu. Ita ene nowa dawo alen. ");
INSERT INTO soq_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Aiaisa walamawa wiseno me nolawa dewalala onieia apanawa mampo waaubamono antoiena me mebaa moawa otepona baiwa. ");
INSERT INTO soq_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Onieia apanawa mo ewamone wadaitumone, dea epaepabobosaiena, da di bosaiena ita da seu mampe epanaboleiena. ");
INSERT INTO soq_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ema aupe irai apanawaida nolawa dewalala uara waaubamono anton, mai nolawa dewalala isiwa bauta antoiena rua, tane irai onieia apanawa deawaa dewasaiena mo mampo. ");
INSERT INTO soq_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Irai apanawaida ompa osowe otopaida wanaubeno mampo alen, ipawa me insenase, ‘Ne otonaida mo mampo wisepio wadapue mamposapue oniepudewantopu, mai kadisapu, dia.’ ");
INSERT INTO soq_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Tauma irai onieia apanawa irai apana otopaida iedio ewane muba gagalontone waienase, ‘Tauma irai ema apanawaida otopa wisen. Ane, me wadataitue bosate, aupe dima uduudu me mampea no taupakawantata!’ ");
INSERT INTO soq_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Dima mo waiena ruawantone antone irai apanawa otopaida wadanaitue wain iraiwa gonaawa adiwe aubeieno noseno sape epanaboleiena.” ");
INSERT INTO soq_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Mape Iesu asisulala waitaramone wanase, “E ambi inseilana irai apanawaida leulepi wimpie irai onieia apanawa mampo dima dewasapi?” ");
INSERT INTO soq_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Mo sipoasane waienase, “Kadi apanawa sa me bomopie kadiidamopi ita wain iraiwa onionia apanawa sanaau witaposapi, mo mida me mebaawa ipawa aiaisa walamawa osowe aisepue me wanapu.” ");
INSERT INTO soq_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","43","Mape Iesu wane wanase, “Ne dialedina, deawaa God gonaawa e manlawo wadepiaubepie ita apana da wanamopio wadapu, mo mida ia euda rua naupudewantopua. E buka bedewe wisiaitene ateiten, ba dia, naepe wadi wadiase, ‘Du wadawadalala apanawa seu dea ewanadabue eiena, mai menamopona, dia. Tane seu sa ewadabuasaia ipa eudidalene du awanediposidede. Tane ema ipa Tatamba God insaisawa rua dewasano segalen, mai di segalepona, dia. Ita insaisa sa me dewasana ewaewawa eudidalen no mainimbo.’ ");
INSERT INTO soq_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Apana mida seu sa osowe omepia epaepalepie boidalepi, ita apana mida osowe seu sa nosepia epepisisidepio bolepi.” ");
INSERT INTO soq_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Pirisi debamau ita Parisi apanawa gagalo babawa ema etane atentoiena Iesu moida umanau wadie. ");
INSERT INTO soq_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ema bedewe mo inta banuntoiena Iesu wadapaitue kotusapona baiwa. Tane mo apana uaraia sape eneia sauntoiena, ipawa mo inseiena Iesu me ipa peroweta. Sa baiwa ene di antoiena, mai me wadapaitudepona, dia. ");
INSERT INTO soq_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Iesu gagalo babawa da apana diamone wanase, ");
INSERT INTO soq_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“God gonaawa ipa ema epe: Warere nolawa dewalala diamona me otopa baiwa nainai odawa imaasapu. Ita me oda sa baiwa apana nisou waaubaleno eteiena. ");
INSERT INTO soq_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Oda walamawaida wiseno warere nolawa dewalala waaubamono antoiena nisolala diamopuo oda imaalene winedia bedewe wimopua baiwa. Tane mo oda bedewe awa dabuantone wankasanton. ");
INSERT INTO soq_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Mo dabuantono baiwa warere oda dewasadia nolawa dewalala da waaubamona nisolala diamopue wapuase, ‘Sosona winlena, odana imaalene winede! Ne moiana kau eubuida bomone laulanteno imaantone wineia nata!’ ");
INSERT INTO soq_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Mo nisolala nisou osowe aleno etane oda bedewe awa dabuaidanton. Ita mo muba insaisau rua antoiena, dea iraiwa bedewe alen ita da gimara awa alen. ");
INSERT INTO soq_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Tane nisolala isiwa dabuantone waimoie warere nolawa dewalala nisomopua awa mampo wimoieno wadaitumone kadikadimone epaboiamoiena. ");
INSERT INTO soq_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Warere nolawa dewalala kadikadimoieno etene nuawa pokawaida wano me matangela mo osouwosapia baiwalene sorodiawa waaubamone diamone wanase, ‘Aitane, witakadilala sa uduudu epaboiamone ita mo bolau debamawa suno ipituwapi!’ Mo warere wana ruawantone antone witakadilala sa epaboiamone bolau suieno intuwan. ");
INSERT INTO soq_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ema aupe warere nolawa dewalala da diamone wanase, ‘Nainai odawa imaalene winede, tane mo nisolala kadiwaida oda awa wimopona dabuanton, mo dewau mai dodomana, dia, di nisokoamotana! ");
INSERT INTO soq_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","E tauma aitane bola uduudu bedewainta apana dommonuna nisomono oda bedewe wimopu.’ ");
INSERT INTO soq_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ita nolawa dewalala me diamona rua bola uduudu bedewainta antone apana kadiwa ba euwa dommoia nisomone banlamone oda bedewe anton. Mo nisolala oda duwa bedewe odeieno apana uduudulen. ");
INSERT INTO soq_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Warere nisolala auwamopia baiwa oda duwa bedewe odene alene auwamodie. Mo auwenatuwaiena bedeuwo apana dea mai nainai odawa garawa euda taupona wandio ewene ");
INSERT INTO soq_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","waitarasane wanase, ‘Sona, e ambi mape odaana? E mai nainai odawa garawa taupona, di wainiano eweedina.’ Warere apana sa waitarasadio dainalen, mai aia da wapona rua, dia. ");
INSERT INTO soq_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Me dainakasaleno warere nolawa dewalala diamone wanase, ‘Apana ema wadane witapa ita wawa do taumone dubawa iwinla bedewe aubeno alepi. Sape me ke wampe poka etaidasampe asipa adompa.’” ");
INSERT INTO soq_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Iesu gagalowa diasadie wanase, “Apana uaraia nisolala, tane mo bedeuwo isiwa os sonabalala.” ");
INSERT INTO soq_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Parisi apanawa Iesu ene antone auwene gagalontone inta banusaie laga mampe Iesu waitarasampo wapikadisapio wadapua baiwa. ");
INSERT INTO soq_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Sa baiwa Parisi sosou isiwa mo wauwo alala ita Erod sosowa isiwa do waaubamoieno antoiena Iesu mampe. Ita mo Iesu mampe wimone diane waienase, “Debamamba, no atenten e walama uduudu ulaipa os waeuwaitiana. E God insaisawa dodomana os apana waeuwamoiana, mai apana kerauda ita debama insaisau rua gagaloitipona. ");
INSERT INTO soq_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","E ambi inseiana, no ide rua Rom gabemaniwa mampe takis manewa ituta? E dianewo atentata!” ");
INSERT INTO soq_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Tane mo kadiwa dima inseia Iesu atenlene baiwa diamone wanase, “E lagawaauida! Dima baiwa laga mampe waitaraneilana? ");
INSERT INTO soq_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","E mane sa nepa ambi rua malesaitilana euwaneano ewapa!” Mo mane sa wadane Iesu mampe wimoieno me ewene waitaramone wanase, ");
INSERT INTO soq_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","“Ewana, ema mida namba ita mida ebowa mane ema osowe winei?” ");
INSERT INTO soq_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Mo leusane waienase, “Rom gabemaniwa ionoidoa namba ita ebowa winei.” Ita Iesu diamone wanase, “Ide, dima gabeman mampea gabeman wanana, tane dima God mampea ipa God wanana.” ");
INSERT INTO soq_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Mo ema etane memesantone me ene antoiena. ");
INSERT INTO soq_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Walama sa deawaawo Sadusi apanawa waitara do Iesu mampe wimoiena. Mo sumanaintoie inseia apana bolala ando mai bo bedewe enapuwimopue waimompa, dia. ");
INSERT INTO soq_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Sa baiwa mo Iesu mampe wimone waienase, “Debamamba, Moses ema epe girumalene ituno winede: Apana mona nainaila obampasiawaia bolepio aupe apana sa wambaida tatawa obupa naisepie otootolepi tatawa baiwa. No menanedia anaana sa ipawaida atenidantata. Sa baiwa no duduna da dieeto etee waeuwanewo atentata.” ");
INSERT INTO soq_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Mape mo dudunau Iesu diane waienase, “Apana wanwamba 6 bolauwo waimoie. Tautua dea nainailene obampasiawaia bolen. Tauma tautua wawea obu sa naisen. ");
INSERT INTO soq_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Tane me mampe deawaa segalen, me do obampasiawaia bolen. Ita wambu natadeawa mampe deawaa segalen. Tane wanwambu ompu epe os dewantontuwan, mo uduudu i sa naiseiena ita obampusiawaia di bontoiena. ");
INSERT INTO soq_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ompa osowe obu sa do bolen. ");
INSERT INTO soq_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","I sa apana 7 naimono bontoiena. Sa baiwa no waeuwanewo atentata apana bolala bo bedewe enapuwimopue waimompo i sa apana dainea manainapaida wanalepi?” ");
INSERT INTO soq_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Iesu mo sipoamone wanase, “Buka bedewe dima girumalena e mai inseipadewaitipe ita do God mukawa mai ateitipe wanleipona, dia. Sa baiwa waitarala surakauaia waile dianeilana. ");
INSERT INTO soq_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Apana bolala bo bedewe enapuwimopue waimompaa walamawe mo mai nainaintopu, dia, mo ensel uboo waimoia ruau di waimompa. ");
INSERT INTO soq_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Tane bo bedewe enawisa umanawa dima God buka bedewe e dialena mai wisiaitapona, ba? Me ema epe wadi wadiase, ");
INSERT INTO soq_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ne ipa Abraam Godiwa, Aisak Godiwa ita Iakob Godiwa.’ Insenadewaitana, me mai bolala Godiu, dia, tane me ipa mo wanwankasalala Godiu.” ");
INSERT INTO soq_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Apana uara ema etane ita Iesu waeuwawa mampe memesanton. ");
INSERT INTO soq_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Iesu Sadusi apanawa sipoadewasamodio mo mai dima da wapona rua. Ita ema umanawa Parisi apanawa etane auwenatue Iesu mampe anton. ");
INSERT INTO soq_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Tane mo bedeuwo anaana waeuwalala dea menasadia Iesu waitara mampe rubusapi, sa baiwa me diene wanase, ");
INSERT INTO soq_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Debamamba, anaana dainea debamawaida uduudu bedeuwo?” ");
INSERT INTO soq_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Iesu leusane wanase, “E Tataa God nuaa uduudu, insaisaa uduudu, atena uduudu, ita do mukaa uduudu mampe nuawadawadasane wanempa. ");
INSERT INTO soq_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Anaana ema dea debamawaida uduudu bedeuwo. ");
INSERT INTO soq_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Tane da deawaa debamawaida: ‘Sosoa nuawadawadamona eba nuawadawadaitiana rua.’ ");
INSERT INTO soq_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Moses anaanawa ita peroweta waeuwau uduudu anaana ema nata bedewentoiena.” ");
INSERT INTO soq_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Parisi apanawa isiwa sape auweiena Iesu waitaramone wanase, ");
INSERT INTO soq_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“E Keriso mida God sauawalen baiwa ambi inseilana, me mida otopa?” Mo sipoasane waienase, “Keriso ipa Dawid atanosiwa.” ");
INSERT INTO soq_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ita Iesu mo waitaramone wanase, “Tane dima baiwa Aleu kakaiwa Dawid insaisawa waneno Keriso ebowa Tatana wan? Dawid ema epe wane wanase, ");
INSERT INTO soq_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Tatamba God ne Tatana mampe wane wanase, ‘Witana on deneuwe aisite wana ne ideita e wenawenaa nanausimope e waa atowe teamopatuwapi.” ");
INSERT INTO soq_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Dawid Keriso ebowa wadi wadiase, ‘Tatana,’ tane ambi Keriso ipa Dawid atanosiwa?” ");
INSERT INTO soq_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Mai mida da Iesu sipoasapona rua, dia. Tane ema aupe apana Iesu waitarawa santoiena. ");
INSERT INTO soq_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ema aupe Iesu apana uara auweiena ita wawe alala do diamone wanase, ");
INSERT INTO soq_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Anaana waeuwalala ita Parisi apanawa Moses aupawa wadeie anaana waeuwantoi. ");
INSERT INTO soq_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ne menanedia mo dima uduudu waie dialeia rua dewasanune wanlempa, mai da ena, dia. Tane mo dewau mai ruawaitana, ipawa mo dima waeuwantoia mai ruawantoipe dewasaipona, dia. ");
INSERT INTO soq_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Mo anaanau uaraia waie mampe sai debamaia apana osouwo ituio awaneie surakaumodio poka etei. Tane mo mubaida sai sa awaawanawa dabuantoie mai sosou saumoipona, dia. ");
INSERT INTO soq_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Anaana waeuwalala ita Parisi apanawa dewa uduudu apana ewamompe asou wampaa os baiwa dewamoi. Israel apanawa dewau ema epe: Mo God aiawa girumala isiwa oteie nambu ita witapu osowe taumoi insamompaa baiwa. Tane Parisi ita anaana waeuwalala ebou debamalempaa baiwa giruma debamauia di dewamoie taumoi. Do mo garau moawa siapa daumau osowe taumoi apana ewamompe asou wampaa baiwa. ");
INSERT INTO soq_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Mo oda bedewe wanwan bolawa eubu sonabamoi ita gagalo duwa bedewe wanwan bolawa pokawaau wadeie osowe waimoi. ");
INSERT INTO soq_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Mo menamodia apana maket bolawe wiwira mampe auwamompa, ita ituposimompe ebou wampaase, ‘Debamamba.’ ");
INSERT INTO soq_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Mai mida e wanawo alala ebola wapi wapiase, ‘Debamana.’ Diaida! Ne epe wadina, ipawa Debamala dea os wande, tane e uduudu sumanai apanawa sosola do wainilana. ");
INSERT INTO soq_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ita tawo osowe mai apana ebowa wane wanase, ‘Mamamba.’ Diaida! Ipawa e Mamala dea os, me ipa uboo wande. ");
INSERT INTO soq_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Mai mida sola ebowa wapi wapiase, ‘Somba eia.’ Diaida! Ipawa e sola eia dea os wande, me ipa Keriso. ");
INSERT INTO soq_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Mida e bedelawo debamalepia meba ituaisilepie nola dewala rua sosowa simbiamopi. ");
INSERT INTO soq_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ipawa me mida meba ituposileidie debamaidaleipona menasadia God me itupiaisidepi. Tane me mida God sawaleidie meba ituaisileidie sosowa atouwoleidie simbiauleidia God me itupiposidepio debamaidalepi.” ");
INSERT INTO soq_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Kadiwa rebarebaida e anaana waeuwalala ita Parisi manlawo, e ipa lagawaauida! E God gonaawa moawa apana danauwo guduitilana! E eba mai God gonaawa bedewe odeipona, dia, tane do mida mo odaoda menamompa e enabodamoilana. ");
INSERT INTO soq_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","15","Kadiwa rebarebaida e anaana waeuwalala ita Parisi manlawo, e ipa lagawaauida! E bola nowa dawo owa nanausaile aitile apana dea dewasailano e sumanailaleidie do e waeuwala ruawaleide. Inta ema bedewe apana sa bola kadiwa otopaida wanalepi. Ando me ita e do ideita bola kadiwaida bedewe aitana! ");
INSERT INTO soq_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Kadiwa rebarebaida e manlawo! E ipa emala potawa tane sosola da banlamoilana. E wailanase, ‘Apana mida God duwa ebowa mampe kangoraleidia, sa ide me ando mai dewasapi. Tane mida God duwa bedewe gold winedia ebowa mampe kangoraleidia me ideita ruawalepie dewasapi.’ ");
INSERT INTO soq_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","E insaisala kiokiolen, emala potawa apanawa wainilana! Dima debamawaida, gold os, ba God duwa dima gold eusadia? ");
INSERT INTO soq_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Do e wailanase, ‘Mida pulo itutula bolawa ebowa mampe kangoraleidia, sa ipa ipasia, tane mida amona pulo bolawa osowe winedia ebowa mampe kangoraleidia, me ideita ruawalepie dewasapi.’ ");
INSERT INTO soq_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","E ipa emala potawa! Dima debamawaida, amona, ba pulo ituia bolawa dima amona eusadia? ");
INSERT INTO soq_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Sa baiwa apana mida pulo ituia bolawa ebowa mampe kangoraleidia, me ipa ituia bolawa ebowa ita amona osowe winedia do kangorauleide. ");
INSERT INTO soq_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Tane apana mida God duwa ebowa mampe kangoraleidia, me God duwa ita mida bedewe wandia ebou mampe kangorauleide. ");
INSERT INTO soq_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ita mida uba ebowa mampe kangoraleidia, me ipa God kolaiwatawa ita mida osowe wandia ebou mampe kangorauleide. ");
INSERT INTO soq_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Kadiwa rebarebaida e anaana waeuwalala ita Parisi manlawo! E lagawaauida! E iraila bedewe nitu bonabonaua kerakera wineia moawa anaana wadia rua God waneilana, tane dima debamaia God anaanawa bedewe e eilana, mai dewasaipona. Dewa ema debamaia God anaanawa bedewe: Apana uduudu mampo deawaa os dewasanune wanlempa, sosola nuapareuitonune saumonuna, ita ulaipa wanune dewasanuna. E epe dewaitonune ita do God mampe amonaitilana mai ena. ");
INSERT INTO soq_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","E apana emala potawa tane sosola da banlamoilana! E esa bedewe takula alepio nana sawa eneilabodeilana, tane pue debama kamel e naile numeilana. ");
INSERT INTO soq_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Kadiwa rebarebaida e anaana waeuwalala ita Parisi manlawo! E lagawaauida! E redula ita abomala onapea os mitamoilano sapa wai, tane dima bedewe winamoia e muka mampe waile danuweile eba baiwaitilana. ");
INSERT INTO soq_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","E Parisi emala potawa wainilana! Bauta redula ita abomala bedeu mitamona, epe dewaitano onapea do sapa wapi. ");
INSERT INTO soq_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Kadiwa rebarebaida e anaana waeuwalala ita Parisi manlawo! E lagawaauida! E ewaewala ipa bo meamba deuntoio euda winedia rua, onapea ewaewa eudida, tane bedewe ipa bolala nepa ita boawa kadiwaida winede. ");
INSERT INTO soq_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Deawaaida, e apana danauwo ewaewala abo euda ita dodomana, tane e bedela ipa laga ita kadi nopelen.” ");
INSERT INTO soq_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Kadiwa rebarebaida e anaana waeuwalala ita Parisi manlawo! E ipa lagawaau! E peroweta tontau meambu osouwo seu eubu dewamoile endomoilana ita apana eubu dodomanau meambu e benamoilana. ");
INSERT INTO soq_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ita e wailanase, ‘No nosinosimba walamauwo wainipono no mai mo do deantepe peroweta bomopona, diaida.’ ");
INSERT INTO soq_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","E epe waile eba benemala wailana e ipa peroweta bomoiena apanawa nosinosiu wainilana. ");
INSERT INTO soq_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ide, nosinosila kadi dewasaiena rua e do aitane dewasane diasana! ");
INSERT INTO soq_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","E ipa mota, ita mota obampaida wainilana! Mai insenase e kotu saiene ene bola kadiwaida bedewe mai aitana! ");
INSERT INTO soq_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Sa baiwa peroweta, insaisa dodomana apanawa ita waeuwa apanawa ne waaubamodina e manlawo. Isiwa e epaboiamona, isiwa koros osowe bomona ita isiwa gagalo duwa bedewe tai mampe epamone tanamono bola deadea bedeuwointa antopu. ");
INSERT INTO soq_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Bumpeido ita tauma apana eubu dodomanau e bomolana ita mo osinau e witalawo winede! Bauta apana euda dodomana ebowa Abel e bosalana ita odene wisene ompa osowe e Berakia otopa ebowa Sakaria God duwa bedewe pulo ituia bolawa ita du pouwaida sawanawe bosalana. ");
INSERT INTO soq_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ne ulaipa dialedina, kadi sa uduudu matangelawa walama ande apanawa wadapu, mai dia.” ");
INSERT INTO soq_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Mape Iesu Ierusalem apanawa insamone nuawa polaida wano wane wanase, “Ierusalem, Ierusalem, e dewala insedine nuana enidasade. E God perowetawa epaboiamoile wainilana! Ita mo mida God waaubamodio manlawo wimoie nolantoia seu mampe epaboiamoilana. Kanka inawa obampa auwamodie mabupa atowemodie oniadewasamodia rua ne walama uduudu nuana menaidasadia e auwalepono mainawoitapona, tane e mampe dabuaitile wainilana. ");
INSERT INTO soq_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ewane, God Ierusalem ita me duwa sape enedia dabuamopie matangelawa osouwolepio kadintoputuwapi. ");
INSERT INTO soq_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ne epe dialedina, ipawa ne e elepo mai ewaneana ideita walama wisempo e wane wanase, ‘Euda me mampe, mida Tatamba God ebowe iedia.’” ");
INSERT INTO soq_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Iesu God duwa ene aleidio wawe alala me mampe wimone waienase, “Debamamba, God duwa ema empuempula eneia ewamoa!” ");
INSERT INTO soq_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Iesu sipoamone wanase, “E tauma du ema uduudu ewamoile asou wailana. Tane ne ulaipaida dialedina, du sa uduudu kadimopituwapi, mai seu da bolawe winepia rua, uduudu noanamopuo nomoputuwapi.” ");
INSERT INTO soq_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Iesu Ierusalemwa ene alene wadi Olib osowe wisene sape aisidene wandio me wawe alala muba wimone me waitarasane waienase, “Dianea, dewa ema walama dainea segalepi, ita eueuwa inainamba ambi no ewate atentata e wiwisaa walamawa ita walama ompa wisede.” ");
INSERT INTO soq_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Iesu sipoamone wanase, “Ewanadewaitana ita mai mida da e lagalepie banlakadisalepi. ");
INSERT INTO soq_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ne epe wadina, ipawa apana uara ne ebonawo wimompe wampaase, ‘Ne ipa Keriso mida e onioniawaitile wainilana winen inalepaa baiwa.’ Mo ne ebona wampe nolantompe apana uara banlakadisamopuo waeuwau bedewentopu. ");
INSERT INTO soq_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","7","E bola uara daitada onantompo gagalowa etana ita do bola isiwa ona baiwa imaantompo umanau etane mai saitane insenase, ‘Tauma ipa sa walama ompa wisen.’ Tane sa dia. Aia daitada wawalala bola daitada bedewe onantompe waimompa. Do natunakani ita wanatata bola uara daitada bedewe segantompo pokawa apana etompe waimompa. ");
INSERT INTO soq_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Poka sa ipa i oto mu baiwaleidio poka etedia rua. Tane poka sa mai i oto gamoidalepia pokawa rua, dia. Poka sa segantompa ipa eueuwa e baila, ewamone ateitana walama ompa maidaleide. Tane ompaida ando segalepi. ");
INSERT INTO soq_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Tane e wadalepue kadilepu ita epaboialepu. Ita uwa daitada apanawa ne ebona baiwa e nibualepu. ");
INSERT INTO soq_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Walama sawo apana uara insakoantopue sumanaibu epue omepu ita muba sou nanantopu do muba nibunibuantopu. ");
INSERT INTO soq_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Peroweta lagawaau uara segantopu ita apana uara banlakadisamopu. ");
INSERT INTO soq_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Dewa kadiwa rebareba debamalepia baiwa apana uara bedeuwo nuawadawada obasalepi. ");
INSERT INTO soq_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Tane mida ompa osowe badowa enedia me inaida donsapie inalepi. ");
INSERT INTO soq_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ita Gagalo euda God gonaawa umanawa tawo uduudu bedewe benemantopuo uwa daitada apanawa etapu. Epe segalempo tauma ompaida wisepi. ");
INSERT INTO soq_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Apana wisiala e gagalo ema ipawaida atendewaitana: Walama ando e God duwa bola kakaila bedewe nitu nuadabualalaida itupuo enompo e ewana, peroweta Daniel wana rua. ");
INSERT INTO soq_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Nitu nuadabualalaida sape enompo kadi rebarebaida segalepia baiwalempo mo Iudiawo wanwanlala kadi sawantopue bolau epue weuwapue wadiwa antopue waimompa. ");
INSERT INTO soq_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Me mida walama sa bedewe peloo waimpe leumpa mai a baiwa du bedewe odepie puraiwawa otepi, dia. Me tauwadea bolawa epie di weuwapie wadiwa alepie inalepi. ");
INSERT INTO soq_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ita apana iraileidia mai garawa otaotawa insaisawalepie duwa awa alepie walamawa diasapi. ");
INSERT INTO soq_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Walama sa ipa pokawaaida ioto bulala ita mo mida oto gegelau do baibu, ipawa mo mai tauwadea os bolau epue wadiwa antopua rua. ");
INSERT INTO soq_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","God mampe rauparitana dewa inainamba ema mai unu walamawe ba Sabat osowe segalepi, ipawa walama sawo e mai tauwadea weuwane aitana rua, dia. ");
INSERT INTO soq_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Mo inantopua baiwa wadiwa antopu, ipawa walama sawo poka etaetalalaida segalepi. Tane poka sa rua mai God tawo dewasanawo ita tauma segalepona, dia. Ita poka walamawa sa dialepio aupe mai poka da ema rua segalepi, dia. ");
INSERT INTO soq_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Poka etaetala walamawa sa daumalempe alempo mai mida da inalepi, dia, uduudu bontoputuwapi. Tane sonabalala baibu God poka walamawa sa kampasapie itupi. ");
INSERT INTO soq_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Walama sa bedewe apana isiwa e dialempe wampaase, ‘Sosona, Keriso inalepia mape wande,’ ita do wampaase, ‘Keriso sisi wande.’ Mo epe dialempo mai sumanaibuitana, dia. ");
INSERT INTO soq_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","E mai sumanaibuitana, ipawa walama sawo Keriso lagawaau ita do peroweta lagawaau uara segantopue wimopu. Ita mo ginasa eueuwa pokawaau dewamompe sonabalala banlakadisamompaa baiwa. Tane mo mai banlakadisamopua rua, diaida. ");
INSERT INTO soq_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Etanadewaitana, dima ando segalepia ne tauma diaimaaledina. ");
INSERT INTO soq_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Naita apana da dialepi wapiase, ‘Ewana, Keriso sala dainala bedewe wande,’ sape mai aitana! Ba apana da dialepi wapiase, ‘Ewana, Keriso ema du pouwe wande,’ mai sumanaiwaitana, dia. ");
INSERT INTO soq_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ipawa Apana Otopa wiwisawa kelama lotodie sapawa tawo moawa daitada osowe sapa wadia rua apana uduudu ewompo segalepi. ");
INSERT INTO soq_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Eueuwa ema insena: Bo etepu wineiawo sape nene galobu auwempo ita apana ewapue atentopu, sape apa bo winei. Ewaewa ema rua Apana Otopa wiwisawa apana emauwo sabamo segalepi.” ");
INSERT INTO soq_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Poka debamaia walamawa sa diantopuo aupe dewa inainamba da segantopu buka bedewe girumalena rua, wadi wadiase, ‘Omo dubalepie sala iwinlepi ita uaboa mai sapa wapi, dia. Kipora uboe nomoputuwapio uba ita sala do ewaewawa rebarebaidalepi.’ ");
INSERT INTO soq_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ema segalempo walamawe Apana Otopa wisepia eueuwa uba tampe segalepi, ita uwa daitada apanawa santompe nuau kekelempa. Tane mo Apana Otopa giou bedewe iompo mukawa ita sapawaida do ewapu. ");
INSERT INTO soq_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Nitu bui rua tarampet aiawa debama wapi ita Apana Otopa me enseliwa waaubamopio antopu, me sonabamodia apanawa tawo moawa daitadawo wanwanlala auwamopua baiwa. ");
INSERT INTO soq_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Ia karakai mampe aten wadana! Walamaipa ia seupa inintopue asiu sanaa teamompo e ewane ateitana maura walamawa kampalen. ");
INSERT INTO soq_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Deawaa, dewa pokawaau ema segantompo e ateitana Apana Otopa wiwisawa walamawa maidalen, du nopeido. ");
INSERT INTO soq_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ne ulaipa dialedina, walama ande apanawa mai bontoputuwapio dewa ema uduudu segantopu. ");
INSERT INTO soq_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Uba ita tawo uduudu diaidantopu, tane ne aiana mai dialepi, diaida!” ");
INSERT INTO soq_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Apana Otopa wiwisawa walamawa ba omowa sa mai mida da atenleipona, dia! God enseliwa uboa mai atentoipona, God Otopa do dia, tane Mamamba os walama sa atenlen. ");
INSERT INTO soq_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Tane Apana Otopa wiwisawa walamawe dima bauta Noa walamawe segalena rua deawaa segalepi. ");
INSERT INTO soq_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Apana odantoie nana naie ita nainaintoie ita Noa waa bedewe odeno unu debama wano abaia uduudulen. ");
INSERT INTO soq_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Dima segalepia mo mai atentopona, di wankoantoio abaia nosene awanamontuwan. Apana Otopa wiwisawa ewaewawa Noa walamawe segalena rua segalepi. ");
INSERT INTO soq_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Apana nata irai bedewe leumpo tane Apana Otopa wisepie dea wadepie mampesapi ita da epio sape wankasalepi. ");
INSERT INTO soq_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Deawaa, ioto nata duwo awodea nana laulantompo tane Apana Otopa wisepie i dea wadepie mampesapi, ita da epio sape wankasalepi. ");
INSERT INTO soq_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Sa baiwa onioniadewaitana insaisala wadaaubala wanlempa! Mai di wankoaitonuna, dia, ipawa e mai ateitapona walama dainea e Tatala leulepie wisepi. ");
INSERT INTO soq_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ema etane insenadewaitana: Naita du apanawa atenlepona omo daineawo poi apanawa wisepia me iwudewalempa poiwaa mai ewepikadisapio du epeike bedewe odepi, dia. ");
INSERT INTO soq_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Epe rua deawaa e do imaaitonune wanlempa, ipawa Apana Otopa walama dainea e mai me wisepia insaisawaitipona bedewe wisepi.” ");
INSERT INTO soq_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Du apanawa nola dewalala dainea sonabepi me sosowa oniamompe ita mo nanau omo ruawalempe wanamompa? Me ipa dodomana ita insaisa euda apanawa sonabepio nola sosowa isiwa oniamopi. ");
INSERT INTO soq_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Walamaipa du apanawa leulepi wisepie ita nolawa dewalala noladewalempo donsapia, nola dewalala sa ideita nuaeu debama donsapi. ");
INSERT INTO soq_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ne ulaipa dialedina, du apanawa nitu uduudu me mampea nolawa dewalala sa witapesapio oniamompa. ");
INSERT INTO soq_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Tane naita nolawa dewalala sa insepie wapiase, ‘Du apanawa alaleide, mai tauwadea wisepi,’ ");
INSERT INTO soq_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ita tauma me insepirebae nola dewalala isiwa epamopi ita me sosowa do narebasantompe esa badowa nampe uwau koakoalempo waimompa. ");
INSERT INTO soq_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Tane nola dewalala sa du apanawa wiwisawa walamawa ita omowa mai insaisawalempe di wankoalempo tauma du apanawa leulepie wisepi. ");
INSERT INTO soq_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Me nola dewalala sa epe dewalempo donsapia me badowaida matangelasapie ita lagawaau bolauwo aubepio mo do waimompa. Sape mo ke wampe poka etaidasampe asipu adompa.” ");
INSERT INTO soq_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Iesu gagalo babawa da mo diamone wanase, “God gonaawa ipawanalempo Apana Otopa warere awa wisepia walamawe ema epe rua segalepi: Ioto sanaau uduudu 10 siwau otamone nomone nainai apanawa into donsapua awa antoiena. ");
INSERT INTO soq_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","3","Mo bedeuwo ioto sanaau 5 insadewasalala, tane 5 da insakadisalala, mai dewa atendewantope nainai apanawa wisepia baiwa siwa esapa imaala wadapona, dia. Nainai apanawa iedio mo siwau nepa os otamone sosou do antoiena. ");
INSERT INTO soq_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Tane ioto insadewasalala siwa esapa imaala dugiwa do otamone antoiena. ");
INSERT INTO soq_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ioto antoie into nainai apanawa alaleidio baiwa etepu garigarileno ituntoie. ");
INSERT INTO soq_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Tane tadina pouwaleidio apana da mukalene benemalene wanase, ‘Nainai apanawa iede, wine auwasana!’ ");
INSERT INTO soq_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Mo ituntoia benema sa etane emau lotone enanawimone siwau debamamone nainai apanawa anuwa waimoie. ");
INSERT INTO soq_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Tane ioto insakadisalala sosou insadewasalala diamone waienase, ‘E siwala esapa moawa saunena, no siwamba bontoi.’ ");
INSERT INTO soq_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ita ioto insadewasalala leusane waienase, ‘Dia, sa mai ide, no epe dewantata no siwamba do bontopu. Aitane, gimara duwa bedewe eba baila siwa esapa gimaraitana.’ ");
INSERT INTO soq_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ioto insadewasalala sosou epe diamoieno etane mo siwa esapa gimarantopua baiwa antoiena. Mo ene antoieno aupo nainai apanawa wiseno ioto insadewasalala imaantoie waimoia me do oda awa antoiena. Mo nainai odawa duwa bedewe odanatuwaieno du moawa gudulen. ");
INSERT INTO soq_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ioto insakadisalala siwa esapa awa antone laie wimone sosou aupau ewanasue antone nainai odawa duwa mampe enane mukantoie iririntoie waiase, ‘Debamamba, e du moawa wadaaubewo no odataa menanede!’ ");
INSERT INTO soq_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Mo epe badowa iririntoio nainai apanawa diamone wanase, ‘E mai odana rua, dia, e apana dainea, ne mai atenleipona!’” ");
INSERT INTO soq_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ita Iesu gagalowa diasadie wanase, “E Apana Otopa wiwisawa walamawa mai ateitipe wanleipona baiwa insaisala wadaaubalala imaaitonune wanlempa, mai di wankoaitonuna, dia!” ");
INSERT INTO soq_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ema aupe Iesu wane wanase, “Ne gagalo babawa da dialepa, ema epe: Apana dea bolawa ene a baiwaleidie me nolawa dewalala uduudu apamono mampe wimoiena. Ita me nituwa uduudu mo witaposana oniamompe waimompa. ");
INSERT INTO soq_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Me nolawa dewalala natadea mo deadea atembu ruawalene manewa odalene wanamona nolawantopue dewasapuo debamalepi. Nolawa dewalala dea mane petawa 5 wanen, ita sowa da mane petawa nata wanen, ita sou da mane petawa dea wanen. Du apanawa mo mane wanamone nolau witaposane awa insaisawaleidia alen. ");
INSERT INTO soq_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Nolawa dewalala mane petawa 5 wanena me dodomana alene nolawalene dewasano debamalen, ita me mane petawa 5 osowesane itun. ");
INSERT INTO soq_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Nola dewalala wawea deawaa dewasane noladewalene mane petawa nata osowesane ituno debamalen. ");
INSERT INTO soq_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Tane mo sou da mane petawa dea wanena wadene alene dogo tone bedewe mane wadena dobolene en. ");
INSERT INTO soq_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Mo epe nolantoie waimoio walama daumawa dialeno mane wanamona apanawa leulene wisene nolawa dewalala apamono wimon mane bauta wanamona gagalowantopua baiwa, mane sa mo wadane ambi dewasaiena. ");
INSERT INTO soq_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Nolawa dewalala mane petawa 5 wanena me nolawalene mane debamawa donsan, petawa 10 seganton. Me mane sa otene mane wanena apanawa mampe wisene wanase, ‘Debamana, e mane petawa 5 neaano nolawantene mane debamawa donsana, tauma petawa 10 leusane eneedina.’ ");
INSERT INTO soq_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Mane wanena apanawa ema etene nuawa euleno diene wanase, ‘E nola dewalala eudida, sumanaiantedina apanawa, e noladewaiten. E nitu kerakera onioniau atendewaitena baiwa ne ituepo nitu debamau oniamona. E ne nuana eusaana baiwa winewo ane nuaeuntate odantata!’ ");
INSERT INTO soq_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ema aupe nolawa dewalala da mane petawa nata wanena wisene wanase, ‘Debamana, e mane petawa nata neaana, tane ne nolawantene mane petawa nata da osowesane ituno petawa 4 segantono leusane eneedina.’ ");
INSERT INTO soq_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Mane wanena apanawa ema etene diene wanase, ‘E nola dewalala eudida, sumanaiantedina apanawa, e noladewaiten! E nitu kerakera onioniau atendewaitena baiwa ne ituepo nitu debamau oniamona. E ne nuana eusaana baiwa winewo ane nuaeuntate odantata!’ ");
INSERT INTO soq_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Mape nola dewalala mane petawa dea wanena wisene wanase, ‘Debamana, ne atenten e apana badowa, e mai dima amponawo uwauwaitiana, ita mai naumba aimoiponawo di aitie aisamoiana. ");
INSERT INTO soq_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ne e saantene baiwa manea neaana wadane antene dogo tone bedewe dobonteno winakasalen. Dima e ne neaana deawaa leusane eneedina.’ ");
INSERT INTO soq_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Mane wanena apanawa ema etene nuawa kadiidaleno diaidasane wanase, ‘E nola dewalala oauara kadiwaida! E ateiten ne apana badowa, ne mai dima amponawo uwauwantedina, ita mai naumba aneipona tane di aisamodina! ");
INSERT INTO soq_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Eulena e epe dewasapona: Manena eneena e banika bedewe ituipe epono wineipe inileipona. Ne insaisana itune insedina leunteape wineape bopawa wadapona, tane e mai banika bedewe itupona, dia.’ ");
INSERT INTO soq_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Tauma du apanawa me sausaia diamone wanase, ‘Apana sa mampe mane wadanaaubene aitane apana mane petawa 10 wadene wisena wanana. ");
INSERT INTO soq_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ipawa mida mampe nitu da winedia osowesapie wanepi, tane me debamaia wanepio rua os mauralepi. Tane me mida keraudaida os mampe winompa keraudaida sa me mampe wadapaaubepo me nituwasiawaia waimpe nuaparelepi. ");
INSERT INTO soq_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Tauma nolakadikadilala sa wadapuaubepuo alepi dubawa iwinla bedewe. Sape me ke wampe poka etaidasampe asipa adompa.’” ");
INSERT INTO soq_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Apana Otopa ensel uduudu do wimopue tauma me kolaiwatawa osowe sapaida do wampio ");
INSERT INTO soq_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ita apana bola daitada bedeuwo wanwanlala uduudu me danawe auweputuwapi. Mape me mo empuempumopi, onionia apanawa sipsip ita gote empuempumodia rua. ");
INSERT INTO soq_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Me sipsip witapa on deneuwe teamopi, tane gote witapa sen deneuwe teamopi. ");
INSERT INTO soq_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ita warere apana witapa on deneuwe diamopie wapiase, ‘E mida ne Mamana euwa osolawo ituna winlena! Winlena ita God gonaawa tawo segasadie walamawe e baila imaasano winedia wadana! ");
INSERT INTO soq_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ne omanatoneno e nana nealano nana. Ne gadompana makoleno e esa nealano nana. Ne ware wineno e banlanealano dulawo odana. ");
INSERT INTO soq_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ne gara abolawanteno e ne gara nealano tauna. Ne kero wadaneno e wilene ne oniadewasanealana. Ne dibura bedewe wainedino e wilene ne nuadubunealana.’ ");
INSERT INTO soq_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Mape apana dodomanau sipoasapue wapuase, ‘Tatamba, walama dainea omanatoedio nana eneetano naana, ba gadompaa makoleidio esa eneetano naana? ");
INSERT INTO soq_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Walama dainea e ware wieno no banlaetano dumba bedewe odaana, ba gara abolawaitiano eneetano tauana? ");
INSERT INTO soq_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Walama dainea kero wadeeno ba dibura bedewe wainiano no winene nuadubuetana?’ ");
INSERT INTO soq_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ita warere leusapi wapiase, ‘Ne ulaipa dialedina, dima uduudu ne sumanai sona debama ba kerauda me mampe dewasalana, sa ipa neida baina dewasalana.’ ");
INSERT INTO soq_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Tauma me apana witapa sen deneuwe diamopie wapiase, ‘E apana matangelala eneane nambeido ia iikasalalawo aitana! Bola sa ipa imaala kadi mamba Seitan ita me sausaia do baibu. ");
INSERT INTO soq_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ne omanatoneno, tane e mai nana da neapono napona, dia! Ne gadompana makoleno, tane e mai esa da neapono napona, dia! ");
INSERT INTO soq_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ne ware wineno, tane e ne mai banlaneapono dulawo odapona, dia! Ne gara abolawanteno, tane e ne mai gara neapono taupona, dia! Ne kero wadaneno ita do dibura bedewe wainedino, tane e mai ne onianeapona, dia!’ ");
INSERT INTO soq_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Tauma mo do sipoasapue wapuase, ‘Tatamba, walama dainea e omanatoedio ba gadompaa makoleidio no eweete tane mai sauepona? Walama dainea e ware wieno, ba gara abolawaitiano eweete tane mai sauepona? Walama dainea kero wadeeno ba dibura bedewe wainiano tane mai sauepona?’ ");
INSERT INTO soq_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ita warere sipoamopie wapiase, ‘Ne ulaipa dialedina, dima uduudu apana debama ba kerauda mampe e mai dewasapona, sa ipa ne baina dewasapona elana.’ ");
INSERT INTO soq_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ita mo dewasialala matangela winakasalala bedewe waaubamopi, tane apana dodomana eubu inawinakasalawo antopu.” ");
INSERT INTO soq_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Iesu gagalo ema uduudu diasane me wawe alala diamone wanase, ");
INSERT INTO soq_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“E atenla walama nata bedewe Pasowa odawa walamawa segalepi ita sawana sa bedewe mo Apana Otopa koros osowe bosapua baiwa nanantopu.” ");
INSERT INTO soq_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Tane walama sawo pirisi debamau ita apana eiau pirisi ionoidoa ebowa Kaiapas duwe auwene ");
INSERT INTO soq_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","gagalontone inta banusaia Iesu werego wadape bosapona baiwa. ");
INSERT INTO soq_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Mo epe dewantoie, ipawa mo inseie waiase, “No Iesu mai oda walamawe wadataitue bosataa rua, apana uara ewanepue nuau kadilepio onamba enapua sawa.” ");
INSERT INTO soq_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Iesu Betani bedewe apana ebowa Saimon duwe wandie. Saimon sa mapo kero kito wadawadala inalena. ");
INSERT INTO soq_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Iesu sape nana nadio i dea ia asiwa bonabonaua esapa dugi euda bedewe imaala wadene wisene ita Iesu uwawa osowe memen. Tane esa sa malesawa ipa debamaia. ");
INSERT INTO soq_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Iesu warorowa dewa ema ewane nuau kadileno wane waienase, “Dima baiwa esa ema di memenaubene kadisan? ");
INSERT INTO soq_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Esa bonabonaua ema gimaralepe mane debamaia wadape apana nuaparelala saumopona.” ");
INSERT INTO soq_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Iesu aiau ema atenlene diamone wanase, “Dima baiwa me epe dieile nuawa kadisailana? ");
INSERT INTO soq_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Apana nuaparelala walama uduudu e do wanlempe saumonuna rua. Tane ne mai walama uduudu e do wainento oniadewasaneanuna, dia. ");
INSERT INTO soq_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","I ema esa bonabonaua ne etena osowe memen, sa ipa ne dobosaneapua baiwa imaanen. ");
INSERT INTO soq_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ne ulaipa dialedina, bola uduudu bedewe Gagalo euda amonantompa dima i ema dewasana do gagalowa wampa, me dudunawa insempaa baiwa.” ");
INSERT INTO soq_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ema aupe wawe alala 12 bedeuwo dea ebowa waia Iudas Iskariot pirisi debamau mampo alene ");
INSERT INTO soq_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","waitaramone wanase, “Naita ne Iesu witalawosapo e sipoa dima ne neana?” Mo epe etane mane silwa wisiantona 30 me waneiena. ");
INSERT INTO soq_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ita Iudas mane wadene tauma walamawa euda wadepidewae Iesu nanalepie mo witaposapia onioniawaleidie wandie. ");
INSERT INTO soq_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Tane Ierusalem bedewe oda walama uwawe apana bured sasanasiawaia nai, walama sawo Iesu wawe alala me mampe wimone waitarasane waienase, “Naepe e meneedia no Pasowa nanawa imaasata e baia?” ");
INSERT INTO soq_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Iesu sipoamone wanase, “Aitane Ierusalem bedewe apana ne atentena donsane diane wanase, ‘Debamamba ema epe wade: Ne walamanaida tauma maidalen. Ne menanedia wanawo alala do e duawo Pasowa nanawa nata.’” ");
INSERT INTO soq_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Wawe alala Iesu diamona rua dewasane ita Pasowa nanawa imaasaiena. ");
INSERT INTO soq_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Rawileidio Iesu wawe alala 12 do wimone nana napua baiwa aisintone waimoiena. ");
INSERT INTO soq_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Mo nana naio bedewe Iesu wane wanase, “Ne ulaipa dialedina, apana dea e bedelawo ne laga mampe nanalepie kotu apanawa mamposapi.” ");
INSERT INTO soq_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Wawe alala aia ema etane mo nuau pareidaleno ita deadea Iesu waitarasane waienase, “Tatamba, ne dia, ba?” ");
INSERT INTO soq_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Iesu sipoamone wanase, “Apana mida tauma bured wadene ne nata urai bedewe aneite naitana, me ipa sa ne wadanepie nanalepi. ");
INSERT INTO soq_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Apana Otopa mampe epe segalepio bolepi, me umanawa buka bedewe girumaleno winedia rua. Tane me mida Apana Otopa dabuasapie laga mampe kotu apanawa mamposapia me matangela rebarebaida donsapie poka etepi! Poka sa etepia sawa eulena inawa me gamowa epona.” ");
INSERT INTO soq_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Mape Iudas mida Iesu nanalepia wane wanase, “Debamana, mai ne, ba?” Iesu sipoasane wanase, “Mebaawa ipa e waiana.” ");
INSERT INTO soq_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Mo nana naio Iesu bured wadene God auwasane ita ampuiasane wawe alala wanamodie wanase, “Wadane nana, ema ipa ne etena.” ");
INSERT INTO soq_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Tauma me redu wadene God auwasane ita mo wanamodie wanase, “E uduudu ema nana. ");
INSERT INTO soq_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ema ipa ne osinana memenaubena apana uara kadiu insadabua baiwa. Inta ema bedewe ne sauana sanaa ulaipaleide. ");
INSERT INTO soq_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ne dialedina, nana ema naitana dialepio aupe ne wain mai napa, dia, ideita ne Mamana God gonaawa wisepie ipawanalepio tauma ne e do osowe nata.” ");
INSERT INTO soq_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Nana aupe mo wadapos sasawa waieno dialeno Ierusalem ene nomone wadi Olib osowe anton. ");
INSERT INTO soq_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Sape Iesu wawe alala diamone wanase, “Ande tadina e uduudu ne koaneane eneane aitanatuwapi buka girumalena rua. God buka bedewe ema epe wadi wadiase, ‘Ne sipsip onioniau apanawa epapabolepi ita sipsip auweie waimoia deaantoputuwapi.’ ");
INSERT INTO soq_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","E uduudu ne eneane aitanatuwapio bonteapa. Tane bo bedewe enapawineape bautantape Galiliwa anteapo e wanawo wilene doineana.” ");
INSERT INTO soq_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pita sipoasane wanase, “Naita apana uduudu e koaepue ita eepu ne mai e koaepe eepa, dia.” ");
INSERT INTO soq_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Iesu me aiawa leusane wanase, “Ne ulaipa dieedina, ande tadinawa eida ne wakoana wae lagaitaa walama natadea, muriwa kanka aiawa wapi.” ");
INSERT INTO soq_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Tane Pita wane wanase, “Ne mai e wakoaepe lagaa wapa, diaida! Naita ne do boneapua, ide rua e nata bontata.” Tane wawe alala isiwa aia ipa deawaa waiena. ");
INSERT INTO soq_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Tauma Iesu wawe alala do sala awopawe ebowa waia Gesemani bedewe wimone me mo diamone wanase, “E mape wanlempo ne sisi anteape rauparintapa.” ");
INSERT INTO soq_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Iesu Pita ita Sebedi obampa nata otamone me do anton. Tane me nuawa pola wano ita nuapareidalene ");
INSERT INTO soq_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","mo diamone wanase, “Ne nuana nuapare nopeidosana bonepia rua etedina. Mape wanlempe ne do onioniantonte iwuntonte wainenta!” ");
INSERT INTO soq_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Iesu eseanama alene dogo osowe dunelene rauparilene wanase, “Mako, rua ba dia, poka etaetala reduwa ne mainawoleidia e wade nambesawo ne mai napa? Tane mai ne menanedia rua dewasawo segalepi, dia, e insaisaaida segalepi ne mainawo.” ");
INSERT INTO soq_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Tauma me leulene wisene wawe alala natadea ituntoio dommone ita Pita diene wanase, “E mai walama kampaida os ne do onioniantape iwuntepona rua, ba?” ");
INSERT INTO soq_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ita me do diamone wanase, “E rauparitonune emoitonune os wanlempa, rubu iompo e badowa enakasaitane nanausana rua, mai dia. E nuala uduudu menasadia badowa enonuna, tane ete oauaraleidie teinaaisileidia wankoaitonuna menasade.” ");
INSERT INTO soq_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Iesu mo osowe emone alene rauparilene wanase, “Mamana, naita poka etaetala reduwa ema mai wadaaubea rua ne napa e insaisaa rua.” ");
INSERT INTO soq_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Me leulene wisene wawe alala ituntoio dommon, ipawa mo emau lauidalen. ");
INSERT INTO soq_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Mape Iesu mo emone alene raupariwa ompa deawaa wan. ");
INSERT INTO soq_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Tane me raupariwa diasane leulene wawe alala mampo wisene diamone wanase, “E ideita ituitile bubuaitilana, ba? Ewana, ne walamanaida maidalen. Taumaida Apana Otopa dabuasapuo kadiwa dewalala witapolepi. ");
INSERT INTO soq_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Enano ana, mida ne wadanepie nanalepia iede.” ");
INSERT INTO soq_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Iesu gagaloleidioma Iudas wisen, me bauta wawe alala 12 bedeuwo dea. Apana uaraia witapo isima ita koinau otamone me do wimoiena. Apana sa uara pirisi debamau ita apana eiau waaubamoiena. ");
INSERT INTO soq_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ita mida Iesu nanalepia me bauta werego apana diaimaamone wanase, “Mida ne isuruasapino ewana, me ipa sa wadanaitudepi.” ");
INSERT INTO soq_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Iudas wisene tauwadea Iesu mampelene wanase, “Debamana, ne auwaedina!” Me epe wane ita isuruasan. ");
INSERT INTO soq_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Tane Iesu me diene wanase, “Sona, dima awa wiena dewasaa!” Tauma apana nomonaaubene Iesu wadanaitudeiena. ");
INSERT INTO soq_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Iesu sowa dea dewa ema ewene isimawa teinenaubene pirisi debama nolawa dewalala dea epene ita me asiwa tonpunden. ");
INSERT INTO soq_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Tane Iesu me diene wanase, “Isimaa leusae aupawe ane ea! Ipawa apana mida isimau teineiaubeia mo ona bedewe bontopu. ");
INSERT INTO soq_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","E ateiten ba dia, ne rua os Mamana mampe iririnteapono ita me tauwadea ensel uaraia waaubamopona ne baina? ");
INSERT INTO soq_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Dima buka bedewe girumalena tauma ideita ulaipalepi, tane Mamana ensel waaubamopono dima buka bedewe girumalena ando ambi segalepona?” ");
INSERT INTO soq_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Mape Iesu apana uara diamone wanase, “E isimala ita koinala do otele mainawo wilen wadaneana baiwa, ewaewawa abo ne witakadilala apanawa rua. Ne e do wainite walama ruawantedine God duwa bedewe waeuwantedine wainedine, tane e mai wadaneapona, dia. ");
INSERT INTO soq_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Tane dewa ema uduudu segaleidia dima peroweta bukawa bedewe girumalena ulaipalepia baiwa.” Mape wawe alala uduudu tauwadea Iesu ene sauwo antonatuwaiena. ");
INSERT INTO soq_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Anaana waeuwalala ita apana eiau pirisi ionoidoa ebowa Kaiapas duwa bedewe auwene waimoie ita mo mida Iesu wadanaitudeiena banlene antone apana debamau auweia bolawe wimoiena. ");
INSERT INTO soq_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Mo Iesu banlene antoio Pita awoa Iesu wawe warorosane pirisi ionoidoa duwa enedia bolawa mampelene dima segalepio ewepia baiwa iwu apana do aisintone waimoie. ");
INSERT INTO soq_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Tane pirisi debamau ita Ius onionialala uduudu laga apanawa banumoie. Apana sa laga mampe benemasikintopono mo Iesu bosapona baiwa. ");
INSERT INTO soq_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Laga apanawa uara wimone Iesu benemasikiwantone tane mai kadiwa da donsapona Iesu bosapu. Tane kotu gagalowa ompa osowe apana nata mo uara danauwo enane ");
INSERT INTO soq_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","benemasikintone waienase, “Apana ema epe wane wanase, ‘Ne God duwa kadisapa ita walama natadea bedewe ne osowe wadapa.’” ");
INSERT INTO soq_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Mape pirisi ionoidoa enenwisene Iesu diene wanase, “Apana ema e wawueie benemantoio eteiana, ba? E mo wawueia sipoa leusae eba inaitaa gagalowa waa, ba di epe enona?” ");
INSERT INTO soq_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Tane Iesu dainakasalene mai dima wapona, dia. Tauma pirisi ionoidoa me diene wanase, “E Godida wanwankasalala ebowa mampe ulaipaida waa: Naita e Keriso God Otopa no dianewo atentata!” ");
INSERT INTO soq_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Iesu leusane wanase, “E eba ipa sa waiana! Tane ne e uduudu dialedina: E ando Apana Otopa God mukamukaua witapa on deneuwe waimpo ita do uba giouwa asiasi iompo ewana.” ");
INSERT INTO soq_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Mape pirisi ionoidoa nuawa kadiidaleno me garawa siolene wanase, “E uduudu etalana me God wakadisasano, dima baiwa benemasiki apanawa da baibuntitana? ");
INSERT INTO soq_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Tauma e ambi inseilana no dima dewasata me mampe?” Mo sipoasane waienase, “Me epe wana baiwa ideita bolepi.” ");
INSERT INTO soq_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Mape mo Iesu namba seseisaiena, apana isiwa witapo epaubasane ita isiwa me sainapa epane ");
INSERT INTO soq_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","wane waienase, “Naita e Kerisoewo dianea mida e epeedio poka eteiana!” ");
INSERT INTO soq_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita kotu duwa enedia adiwe peloo wandio pirisi nolawa dewalala iwa rialene me mampelene diene wanase, “E do Galili Iesuwa do leilana apanawa!” ");
INSERT INTO soq_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Tane Pita mo uduudu danauwo lagalene wanase, “Ne mai atenteapona e dima umanawa waiana.” ");
INSERT INTO soq_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ema aupe Pita nosene inta nope aleidio sape i da me ewene apana sape eneia diamone wanase, “Apana ema Nasaret Iesuwa do laia apanawa.” ");
INSERT INTO soq_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Me osowe lagalene wanase, “Ne God ebowa mampe ulaipa wadina, apana sa ne mai atenteapona, dia!” ");
INSERT INTO soq_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ema aupe walama kerauda os bedewe apana sape eneia Pita mampentone diane waienase, “Ulaipa, e ipa Iesu sowa dea, e aiaa bumpa etaeta sabamoede!” ");
INSERT INTO soq_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pita meba ula wane wanase, “Ne laganteapono God matangelaneapona, apana sa ne mai atenteapona, dia!” Pita ema wano dialeno kanka aiawa wan. ");
INSERT INTO soq_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Tane Pita insendewalen dima Iesu bauta wane wanase, “E ne wakoana wae lagaitaa walama natadea, muriwa kanka aiawa wapi.” Ita Pita nuawa pareidaleno nosene peloo alene ke debamaia wan. ");
INSERT INTO soq_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Tadinaida pirisi debamau ita apana eiau auwene gagalontone insaisau deasaiena Iesu bosapu. ");
INSERT INTO soq_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Mo Iesu witapa taune banlene antone Rom gabemaniwa debama Pailat witapesaiena. ");
INSERT INTO soq_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Iudas mida Iesu nanalena tauma atenlen Iesu kotuwa aleidia ompa osowe bolepi. Sa baiwa me kadiwa dewasana atenlene nuawa polaida wano silwa nepa 30 pirisi debamau ita apana eiau me waneiena wadene mane sa leusapie wanamopia baiwa alen. ");
INSERT INTO soq_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Me mo mampo wisene diamone wanase, “Ne kadiwaida dewasane apana eudida nanantena bolepi!” Mo sipoasane waienase, “Dima baiwa no nuamba pola wapi, sa e kadia, no mai wasaueta, dabuanen!” ");
INSERT INTO soq_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Iudas aia ema etene me mane mukalene God duwa bedewe aubamone emone nosene alene ita meba tautaulen. ");
INSERT INTO soq_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Pirisi debamau mane sa otamone waienase, “Mane ema osina wadawadala! No anaanamba bedewe mai eulepona mane ema God duwa manewa do deasata!” ");
INSERT INTO soq_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Mo gagalontone insaisau deasane mane sa wadane apana onta dewala dogowa moawa gimaranton bola da apanawa bontompo sape dobosamompaa baiwa. ");
INSERT INTO soq_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ema segalena baiwa walama sawo ita ando apana dogo moawa sa ebowa wampaase, ‘Osina dogowa.’ ");
INSERT INTO soq_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Dewa ema dima peroweta Ieremaia wana ulaipalepia baiwa segalen. Me epe wane wanase, “Israel apanawa isiwa nuau deasaiena ita silwa nepa 30 malesasaiena me wadapua baiwa. ");
INSERT INTO soq_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Mo mane sa wadane ita apana onta dewala dogowa moawa gimarantoiena, Tatamba God dianena rua.” ");
INSERT INTO soq_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Mo Iesu wadane Rom gabemaniwa debama mampe wimoieno ita me Iesu waitarasane wanase, “E Iuswa warereu, ba?” Iesu leusane wanase, “E ipa sa waiana!” ");
INSERT INTO soq_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Pirisi debamau ita apana eiau Iesu wawusaiena tane Iesu mai gagalo da leusapona, dia. ");
INSERT INTO soq_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Mape Pailat me diene wanase, “E wawua gagalowa uara waio eteiana, ba dia?” ");
INSERT INTO soq_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Tane Iesu wawusaio me daina enakasalen, mai gagalo da wapona, dia. Ita Pailat Iesu dainawa enedio ewene memesaidalen. ");
INSERT INTO soq_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Pailat me dewawa rua Pasowa odawa walamawe ena deadea bedewe apana diburala dea Iuswa sonabeia dibura bedewe wadediaubedio nosedi aleide. ");
INSERT INTO soq_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Walama sawo witakadilala Barabas ebowa alala dibura bedewe wandie. ");
INSERT INTO soq_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Pailat apana uaraia sape auweiena waitaramone wanase, “Mida menaledia e baila wapaaubepo alepi, Barabas ba Iesu, mida me umanawa waia me ipa Keriso God sauawalena?” ");
INSERT INTO soq_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Tane Pailat atenidalen pirisi debamau Iesu obusane baiwa di wadane me witapesaiena. ");
INSERT INTO soq_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pailat kotu duwa bedewe wandio manainapa gagalo wanaubene wanase, “Mai apana eudida sa mampe kotu bedewe dewa da dewasaa, ipawa ne tadino me auwesane meraunten.” ");
INSERT INTO soq_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Tane pirisi debamau ita apana eiau apana uaraia waninamoiena mo Pailat iririsapuo Barabas wadepiaubepio inalepi, ita me Iesu bosapi. ");
INSERT INTO soq_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ita Pailat apana waitaramone wanase, “Apana ema nata bedeuwo mida menaledia ne e baila wapaaubepo inalepi?” Mo sipoasane waienase, “Barabas!” ");
INSERT INTO soq_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ita Pailat mo waitaramone wanase, “Tauma ne dima dewasapa Iesu mampe, mida umanawa apana waia me ipa Keriso?” Mo uduudu leusane waienase, “Koros osowe bosaa!” ");
INSERT INTO soq_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ita Pailat osowe waitaramone wanase, “Me kadi dainea dewasana bowalepi?” Tane mo osowe rasa debamaia wane waienase, “Koros osowe bosaa!” ");
INSERT INTO soq_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pailat atenlen me gagalo wanlewalen, ita ona segalepia sawa apana uara danauwo me esa wadene witapa mitene aupe wanase, “Apana ema osinawa mai ne witanawo, dia! E witalawo!” ");
INSERT INTO soq_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Apana uaraia sipoasane waienase, “Sa ide, me osinawa no ita obainimba do osombo winepi!” ");
INSERT INTO soq_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Mape Pailat Barabas mo baibu wadenaubeno nosene alen. Tane me wana rua mo Iesu tai mampe epeie. Mo Iesu epeieno dialeno me wadene sorodia witaposan koros osowe seupue bosapua baiwa. ");
INSERT INTO soq_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Mape Pailat sorodiawa Iesu banlene gabeman duwa bedewe antono sorodia sosou uduudu wimone me enane paneiena. ");
INSERT INTO soq_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Mape mo Iesu garawaida wadanaaubene ita gara dubawa ewaewawa warere garawa rua me osowe aneiena. ");
INSERT INTO soq_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ita mo tai gedaragedaraua nukuntono kunubobo wanaleno uwawe aine benasaiena. Ita mo koina wadane Iesu witapa on osowe ituieno wadedio tauma mo Iesu danawe imimpu emmisintone wareuwasane waienase, “Iuswa warereu, no auwaeitana!” ");
INSERT INTO soq_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Mo Iesu seseisane koina witape wadanaaubene me uwawa osoweosowe epeie. ");
INSERT INTO soq_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Mo epeie wareuwasaieno dialeno tauma gara dubawa ampe wadanaaubene meba garawaida ampe aneiena, ita banlene anton koros osowe seupue bosapua baiwa. ");
INSERT INTO soq_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Tauma mo nomone antoie intasino apana dea ebowa Saimon, me bolawa Sairini, donsane badowa dieiena me Iesu korosiwa awanepi. ");
INSERT INTO soq_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Mo antoie bola ebowa waia Golgota bedewe wimoiena. Ebo Golgota ipawaida ipa uwa nepa. ");
INSERT INTO soq_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Sape sorodia wain ita esa sigasigaua leusaitulala Iesu waneiena napia baiwa. Iesu esa sigasigaua nane dauwa etene tane nanawa dabualen. ");
INSERT INTO soq_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Mo Iesu koros osowe tutuntone seuiena. Tane me garawa otaotawa baiwa nitu kopikopiua mampe owantone ewane rua otamoiena ");
INSERT INTO soq_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ita aisintone waine Iesu onieiena. ");
INSERT INTO soq_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Mo Iesu wawuwa gagalowa epe girumantona wadiase, “Ema Iesu, Iuswa warereu,” ita giruma sa me onape koros osowe seuiena. ");
INSERT INTO soq_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Apana poiwaau nata Iesu do koros osowe seumoiena, dea witapa on deneuwe ita da sen deneuwe. ");
INSERT INTO soq_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Apana wimoie antoie Iesu wakadisasaie imumbu totetotesaie waiase, ");
INSERT INTO soq_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“E waanase, ‘Ne God duwa kadisape ita walama natadea bedewe osowe wadapa.’ Naita e ulaipa God Otopa tauma eba inaitee koros osowe iee winea!” ");
INSERT INTO soq_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Deawaa pirisi debamau, anaana waeuwalala ita apana eiau do Iesu wareuwasane ");
INSERT INTO soq_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","waienase, “Me apana isiwa inamon, tane meba mai inalepia rua, dia! Me Israelwa warereu, koros epie iepio no ewate sumanaiwantata! ");
INSERT INTO soq_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Me God sumanaiwaleidia baiwa wane wanase, ‘Ne ipa God Otopa.’ Tauma ewonta God menasadia me inasapi, ba dia!” ");
INSERT INTO soq_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Tane poi apanawa Iesu do koros osowe seuia apana isiwa wasiu rua me wareuwasaiena. ");
INSERT INTO soq_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Iesu koros osowe seudio enautalene omo natadea bedewe sala uduudu iwinidalene winen. ");
INSERT INTO soq_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Rawiwa, omo 3 wadedio Iesu aiawa mukama wane wanase, “Eli, Eli, lama sabakitani?” Aia ema ipa Ibru aiawe wana ipawaida ipa: Ne Godna, ne Godna, dima baiwa eidaneana? ");
INSERT INTO soq_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Sape apana isiwa eneia Iesu aiawa ema etane waienase, “Apana ema peroweta Elaia apasadio wimpi!” ");
INSERT INTO soq_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","49","Mape apana dea tauwadea ene weuwane alene koina gara osowe tauieno winedia wadene esa sigasigaua bedewe aine gara butasan. Ita me nitu sa butasana Iesu wanepio napia baiwa wadene leulene alene Iesu wanedie sosowa da diamone wanase, “Sosona ewonta, Elaia wisepie me sausapie koros osowe wadepiaubepie inasapi, ba dia?” ");
INSERT INTO soq_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Tane Iesu osowe ka debama wanaubene ita bolen. ");
INSERT INTO soq_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Tane me boleidio God duwa bedewe gara daumawa seudia suinta isuadene iene waiwa nata seganton, do dogo uwauwalene ita seu tutuwaiena. ");
INSERT INTO soq_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","53","Bo nagawa wadaaubalen ita apana eubu dodomana uara bo bedewe enanawimone bo nagau eiena. Iesu bo bedewe enenwiseno aupe mo bola kakaiwa Ierusalemwa antone ita apana uara mampo sabamontono ewamoiena. ");
INSERT INTO soq_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Sorodia uwaula apanawa ita mida me do Iesu onieia wanatata dogo uweno ita uduudu dima segalena ewane mo nuau saidaleno waienase, “Ulaipa, me ipa God Otopa!” ");
INSERT INTO soq_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Tane ioto isiwa bautamampe Iesu Galiliwae warorosane sausane wimoiena nambe enane Iesu emosaie. ");
INSERT INTO soq_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mo bedeuwo Meri Magdalin, Meri da, me Iems ita Iosep inau, tane Sebedi obampa inau do sape eneie. ");
INSERT INTO soq_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Omo pamedio bola Arimatia apanawa dea ebowa Iosep wisen. Me ipa puraiwa apanawa ita me Iesu warorosadie leidia apanawa. ");
INSERT INTO soq_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Me Pailat mampe alene Iesu etepa wadepie itupidewalepia baiwa waitarawalen. Pailat oalene sorodia diamona Iesu etepa me wanapu. ");
INSERT INTO soq_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ita Iosep nosene alene Iesu etepa wadene gara sapusapua euda mampe lomalene, ");
INSERT INTO soq_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","bo nagawa nau bedewe toiena Iosep meba baiwa imaasanawo itun. Tane me seu debama koirewasane bo nagawa moawa enenbodeno ene alen. ");
INSERT INTO soq_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Meri Magdalin ita Meri da bo nagawa nope eseanama danau bo ituiena mampesane waimoie. ");
INSERT INTO soq_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Imonemba Sabat walamawe pirisi debamau ita Parisi apanawa Pailat mampe antone ");
INSERT INTO soq_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","wane waienase, “No inseitana laga apanawa ema inawaa wandie epe wane wanase, ‘Walama natadeawo ne bo bedewe enapawineapa.’ ");
INSERT INTO soq_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Sa baiwa sorodia isiwa waaubamowo antopue bo nagawa oniempadewantompo walama natadea dialepi, naita wawe alala wimopue Iesu etepa pointopua sawa. Ita mo ando apana lagamopue wapuase, ‘Iesu bo bedewe enenwisen.’ Mo epe dewantopua Iesu lagawa debamaidalepi, mai bauta rua.” ");
INSERT INTO soq_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pailat oalene diamone wanase, “Sorodiana isiwa e do aitane ambi e inseilana rua dewasana ita mo bo nagawa oniepudewantopu.” ");
INSERT INTO soq_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Pailat mo epe diamona rua ene antone seu bo nagawa enenbodena apana da koirewasapia sawa lominton. Ita sorodia emono bo nagawa iwusaie eneie. ");
INSERT INTO soq_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabat walamawa imonemba Sandewa walama pumpu Meri Magdalin ita Meri da nata bo nagawa ewapua baiwa antoiena. ");
INSERT INTO soq_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Mo antoio wanatata debamaia segalen, ipawa Tatamba enseliwa uboe iene wisene seu debama bo nagawa enenbodena koirewasano nambeleno osowe wandie. ");
INSERT INTO soq_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Me inainamba ewaewa kelama rua ita garawa sapusapuaida. ");
INSERT INTO soq_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Bo nagawa onionialala ensel sawaidantone uwauwantone etepu bolen. ");
INSERT INTO soq_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Tane ensel ioto diamone wanase, “Mai saitana! Ne atenten e Iesu koros osowe bosaiena banusailana. ");
INSERT INTO soq_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Me mape dia, me bo bedewe enenwisen me bauta wana rua. Winlene, me ituleidia aupawa ewane ");
INSERT INTO soq_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ita tauwadea aitane me wawe alala diamone wanase, ‘Iesu bo bedewe enenwisene ita tauma bautalene aleide Galiliwa, sape me donsana!’” Ita ensel osowesane wanase, “Ne dima tauma dialena insenadewaitana!” ");
INSERT INTO soq_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Tane mo santoie ita nuaeu debama do diniwantone bo nagawa ene weuwane antoie wawe alala benemamopua baiwa. ");
INSERT INTO soq_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Tane into antoioma Iesu mo dommone diamone wanase, “Euda e manlawo!” Mo me mampeido wimone danawe imimpu emmisintone wawa wadanaitue nuau bedeweido wadaposisaiena. ");
INSERT INTO soq_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Tane Iesu mo diamone wanase, “Mai saitana! Aitane ne sosona diamono Galiliwa antopu ita sape mo ne ewaneapu.” ");
INSERT INTO soq_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ioto into antoioma sorodia bo nagawa iwulala isiwa leuntone Ierusalemwa antone dima uduudu segalena umanawa pirisi debamau diamoiena. ");
INSERT INTO soq_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Pirisi debamau apana eiau do auwene gagalontone waienase, “No gagalo ema etatana, tauma dima dewasata?” Mo dima insene waiena rua dewasaiena ita sorodia mane debama wanamone diamone waienase, ");
INSERT INTO soq_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“Apana uduudu diamona Iesu wawe alala e ituitilano onalawo tadino wimone Iesu etepa pointone awanene antoiena. ");
INSERT INTO soq_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Tane Pailat ema umanawa etepia no gagalosata ita wawu mai e wadalepi, dia.” ");
INSERT INTO soq_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Sorodia mane wadane ita pirisi debamau diamoiena rua dewasaiena. Walama sawo ita tauma duduna sa Ius apanawa bedeuwo debamalen. ");
INSERT INTO soq_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Tane wawe alala 11 Galiliwa antone wadi dea Iesu diamona rua osowe odane antoiena. ");
INSERT INTO soq_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Mo sape wimone Iesu ewane danawe imimpu emmisintone nuau bedeweido wadaposisaiena. Tane isiwa mo bedeuwo insakoantone baiwa mai sumanaintopona, dia. ");
INSERT INTO soq_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ita Iesu mo mampolene wanase, “Muka uduudu uba bedewea ita tawo osowea ne nen. ");
INSERT INTO soq_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Sa baiwa uwa daitada apanawa uduudu mampo aitane dewamono mo ne wanawo alala wanantopu ita Mamamba, Otopa ita Aleu kakaiwa ebouwo mo babatutumona. ");
INSERT INTO soq_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ita dima uduudu ne e dialedina waeuwamono ruawantopu. Tane aiana ema insenune os wanlempa: Walama uduudu e ne do, tauma ita walama ompe.” ");
INSERT INTO soq_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ema ipa Gagalo euda bumpa Iesu Keriso God Otopa umanawa. ");
INSERT INTO soq_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Peroweta Aisaia girumalena wadi wadiase, “Ne gagalona benemala apanawa bauta wapaaubepo e intaa deaitopasapio eulepie winompa e baia.” ");
INSERT INTO soq_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Do me wadi wadiase, “Apana sala makowa bedewe mukama benemaleidie wadi wadiase, ‘Tatamba wimpia baiwa inta eusana, dewa uduudu inta enabodamodia otawiaitane nambemona!’” ");
INSERT INTO soq_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Epe girumalena rua Ion sala makowa bedewe wisene apana babatutumodie. Ita gagalo amonaleidie wadi wadiase, “E kadi bedewe insaisala leusane God mampe dodomanaitano kadila nambemopie insadabuamopi.” ");
INSERT INTO soq_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Iudia bedewe wanwanlala ita Ierusalem apanawa uduudu Ion mampe antone kadiu wawiantono ita me esa Ioadan bedewe mo babatutumon. ");
INSERT INTO soq_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ion dewawa ema epe: Me gara pue kamel imba dewala taudie ita do iga pue etepa mampe dewasaiena nowe taune wandi leidie. Tane nanawa kapoi ita awanai namodi wandie. ");
INSERT INTO soq_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Me ema epe benemaleidie wadi wadiase, “Mida ne wanawo wisepia ipa mukamukauaida, mai ne ruana. Me ipa debamawaida, ne mai rua me sausape me sendorowa otawiantape nambemopa, dia. ");
INSERT INTO soq_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ne esa mampe babatutuledina, tane me ipa Aleu kakaiwa mampe babatutulepi.” ");
INSERT INTO soq_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Walama sawo Iesu bola Nasaret Galili bedewe ene alene Ion mampe wisen. Ita Ion esa Ioadan bedewe Iesu babatutusan. ");
INSERT INTO soq_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Tane babatutu dialeno Iesu esa bedewe enenwisidene pisiwane uba siolene wadenaubeno Aleu nene bunebune rua me osowe iedio ewedie. ");
INSERT INTO soq_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ita aia uboo segalene wanase, “E ne Otonaida nuawadawadaedina, nuana eusaiano wainedina!” ");
INSERT INTO soq_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Tane aia sa wano dialeno aupe Aleu kakaiwa Iesu wanaubeno sala makowa bedewe alen. ");
INSERT INTO soq_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Sape me wandie Seitan rubusadio walama 40 dialen. Me pue os bolauwo wandio ensel wimone me oniadewasasaie sausaie. ");
INSERT INTO soq_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","15","Ion dibura bedewe ituieno wandio Iesu Galili tawowa bedewe alene God Gagalowa euda benemaleidie wane wanase, “God walama ituna tauma wisen ita me gonaawa tauma ipawanalepia baiwaleide. E kadi bedewe insaisala leusane God mampe dodomanaitane ita Gagalo euda sumanaiwaitana!” ");
INSERT INTO soq_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Iesu doa Galili tampe aleidie bouri lawailala Saimon wamba Endru nata lawaibu esa bedewe aubamoio ewamone ");
INSERT INTO soq_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","diamone wanase, “Wine, ne waroroneana, ita ne dewalepo apana lawaimonuna.” ");
INSERT INTO soq_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Me epe diamona rua tauwadea lawaibu emone Iesu warorosane do antoiena. ");
INSERT INTO soq_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ita mo Iesu do doa tampeinta mai aidantopona maida sa Iesu Sebedi obampa Iems wamba Ion nata waau bedewe lawaibu imaasaie waimoio ewamon. ");
INSERT INTO soq_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Iesu mo ewamone tauwadea os apamon me warorosapua baiwa. Ita Iems Ion nata mo mambu Sebedi nola sosou do waau bedewe emone Iesu warorosane antoiena. ");
INSERT INTO soq_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Iesu wawe alala do Kapeanaumwa wimon. Ita Iuswa bubuau walamawa Sabat wisena walamawe Iesu mo gagalou duwa bedewe alene waeuwa nolawa uwaalen. ");
INSERT INTO soq_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Tane asisulala me muka do waeuwaleidio etane memesanton, ipawa me mai anaana waeuwalala ruau waeuwaleipe, dia. ");
INSERT INTO soq_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Iesu waeuwaleidio asisula apanawa dea aleu kadiwa bedeweleidie kadisadia mukama wane wanase, ");
INSERT INTO soq_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Nasaret Iesuwa, e mai nolaa da no mainimbo wineipona, dia. E no kadineatuwapia baiwa wien, ba? Ne atenten e mida, e God benemalala waaubaena kakaiwaida wien!” ");
INSERT INTO soq_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Tane Iesu aleu kadiwa badowa diene wanase, “Dainaite me ee di noe nambeitaa!” ");
INSERT INTO soq_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Aleu kadiwa apana sa bedewe wandia aia ema etene me dewasano etepa uwauwaboboleidie ita rasa debama wane apana ene nosen. ");
INSERT INTO soq_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Apana uduudu sape asisuntoia dima eweiena mampe memesantone muba eda waitarantoie waiase, “Ema dewa dainea eweitana? Waeuwa sanaa muka do segaleide! Apana ema muka wadene aleu kadiu diamodia ruawantoi.” ");
INSERT INTO soq_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Tane Iesu benemawa tauwadea Galili bolawa uduudu bedewainta alentuwano atentoiena. ");
INSERT INTO soq_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Iesu ita Iems Ion nata, do wawe alala isiwa gagalo duwa ene Saimon Endru nata duwo antoiena. ");
INSERT INTO soq_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Sape mo Saimon nemonapa polapola wadene ituleidia benemawa Iesu dieiena. ");
INSERT INTO soq_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Iesu me umanawa etene i sa ituwa bolawe ituleidio mampe alene witapa wadene sausano enenwisiden. Ita polapola i eno inalene mo baibu simbialen. ");
INSERT INTO soq_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Rawileidio omo pameno apana sosou kerolala ita apana bedeuwo aleu kadiu wanwanlala uduudu banlamone Iesu mampe wimoiena. ");
INSERT INTO soq_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Tane bola sa bedewe wanwanlala uduudu Saimon duwa moape auweiena, ");
INSERT INTO soq_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ita sape kero daitada wadawadalala uara Iesu inamon. Do aleu kadiu uara apana bedeuwo waimoia me tanamono nomon. Mo apana emone nomoio Iesu anaanamona mai dima da wapu, ipawa mo atenidanton Iesu me mida. ");
INSERT INTO soq_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Imonemba walama pundedio Iesu enene nosene sala dainala bedewe alene rauparileidie. ");
INSERT INTO soq_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Tane Saimon sosowa do nomone antone me banusaie. ");
INSERT INTO soq_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ita mo Iesu donsane diane waienase, “Kapeanaum apanawa uduudu e wabanua wai!” ");
INSERT INTO soq_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Tane Iesu sipoamone wanase, “No mai mape os wainenta, dia. Ne menanede bola dawo ane sape do Gagalo euda amonanteapa. Ne nolana sa dewasapina baiwa winen.” ");
INSERT INTO soq_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ita Iesu Galili bolawa uduudu bedeuwointa alene gagalou dubu bedewe Gagalo euda amonaleidie do aleu kadiu apana bedeuwo waimoia tanamodie. ");
INSERT INTO soq_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Apana kito wadawadalala Iesu mampe wisene imimpa emmisilene iririsane wanase, “E naita meneempa e rua os ne inanea!” ");
INSERT INTO soq_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Iesu kerolala sa nuaparewalene ibuwa wadene wanase, “Ne sauepaa menanede, inaitaa!” ");
INSERT INTO soq_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Me epe wano tauwadea kito dialeno inalen. ");
INSERT INTO soq_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Me inaleno Iesu badowa anaanasane wanase, “Dima manawo segalena umanawa mai apana da diamoa, diaida! Tane tauwadea pirisi mampe aitee etea inalena euwasawo ewepi. Muriwa Moses anaanawa wana rua e inaitena pulowa ituno apana ewapue atentopu e inaitene euitena God duwe aitaa rua.” ");
INSERT INTO soq_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Me Iesu diena mai ruawalepona, dia, tane alene bola uduudu bedeuwointa Iesu me inasana benemawaleidie. Apana uduudu me umanawa etane atentoiena baiwa Galili bedewe bola debamauwo Iesu mai odapona rua, dia. Me bola obasau kerakera bedeuwo wandi leidie. Tane bola uduudu apanawa mai Iesu epona, me baiwaidantoie ieie. ");
INSERT INTO soq_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Walama nata dialeidio Iesu leulene bolawe Kapeanaumwa wisen ita bola sa apanawa me benemawa eteiena. ");
INSERT INTO soq_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Apana uaraia du Iesu wandia bedewe auweieno nopeidolen ita du moape do apana uduudulen. Ita Iesu God aiawa amonaleidio ");
INSERT INTO soq_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","apana nataitanata sou tampa bobopa rasirasi bedewe aine awanene me mampe ieie. ");
INSERT INTO soq_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Tane apana uarantono baiwa mo mai du moapeinta odape sou kerolala Iesu mampesapona rua, dia. Sa baiwa mo du iwa nekewa asiasi odane anton. Ita Iesu du bedewe enediawo ruawantone du iwe naga dewasane sou rasirasi osowe ituleidio noaneieno iene alene Iesu danaweido nosen. ");
INSERT INTO soq_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Iesu mo ewamone atenlen mo sumanaiidantoi. Sa baiwa me apana tampa bobopa diene wanase, “Otona, e kadia insadabuamon.” ");
INSERT INTO soq_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Tane anaana waeuwalala isiwa sape waimoie insaisantoie inseiase, ");
INSERT INTO soq_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Apana ema ambi epe wade? Me epe wadie God wakadisasade! God os kadi insadabuamopia rua, mai mida da, diaida!” ");
INSERT INTO soq_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Tane mo dima nuau bedewe inseia Iesu atenlene baiwa waitaramone wanase, “Dima baiwa epe inseilakadisailana? ");
INSERT INTO soq_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","10","E inseilana ne mai mukana do apana ema di diane wanase, ‘E kadia insendabuasan!’ E epe inseilana, ipawa kadi insadabua no mai emambo ibuwa ewataa rua, dia. Tane ne dewa da pokawaa dewasapo ita e uduudu emalawoido ibuwa ewana. Dewa ema mampe ne sabamosapo e ateitana Apana Otopa tawo osowe muka God mampe wadena kadi insadabuamompaa rua.” Tauma Iesu dewa ema ipawaida sabamosapio mo ewapua baiwa me apana tampa bobopa diene wanase, ");
INSERT INTO soq_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ne dieedina, enawie nogia nukuite wade aitaa duawo.” ");
INSERT INTO soq_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Mo uduudu eweio apana ipa enenwisene nogiwa wadene alen duwe. Mo uduudu memesantone God wadanaposie waienase, “No mai dewa inainamba ema rua segalepono ewapona, dia!” ");
INSERT INTO soq_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Iesu Kapeanaum ene leulene doa Galili tampe alen. Ita sape apana uaraia Iesu mampe wimoieno me God aiawa waeuwamodie. ");
INSERT INTO soq_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Tane me doa tampe leidie takis manewa tamalala apanawa Liwai, me ipa Alpias otopa, nolawa duwa bedewe wandio ewen. Iesu me mampe wisene diene wanase, “Wine, waroronea!” Me epe etene tauwadea enene Iesu warorosane alen. Tane takis manewa tamalala ita kadi apanawa uara do Iesu wawe anton. ");
INSERT INTO soq_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Muriwa Iesu wawe alala do, ita takis manewa tamalala, tane do kadi apanawa uara Liwai duwa bedewe waine rawi nanawa naie. ");
INSERT INTO soq_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Tane anaana waeuwalala isiwa, mo mida Parisi sosou, Iesu kadi apanawa ita takis manewa tamalala do nana naie waimoio ewamoiena. Ita mo Iesu wawe alala waitaramone waienase, “Iesu atenlen, ba dia, apana sa kadiwaida dewalala, dima baiwa mo do nana naie waimoi?” ");
INSERT INTO soq_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Mo epe waio Iesu etamone sipoamone wanase, “Apana inawaa waimoia doketa mai menamoipona, dia! Tane kerolala doketa saumopia menaidamodio waimoi. Ne mai apana dodomanau apamopaa baiwa wineapona, dia! Ne kadi apanawa apamopo God mampentopua baiwa winen.” ");
INSERT INTO soq_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ion wawe alala ita Parisi do kainokaino idi dewawa dewasaie waimoie. Ita apana isiwa Iesu mampe wimone waitarasane waienase, “Ion wawe alala ita Parisi warorou do idi dewawa dewasaie waimoi, tane e waawo alala dia, sa ipa ambi?” ");
INSERT INTO soq_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Iesu sipoamone wanase, “Mo nainai apanawa odawa dewasaie nainai muri nisolala nisomoio wimoie me do nuaeuntoie nana naie os waimoi, mo mai diamoipono nana idintoipe waimoipona, dia! ");
INSERT INTO soq_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Tane God walama ituna wisepio mo nainai apanawa mo mampoe banlepue antopuo aupe mo idi dewawa dewasampe waimompa. ");
INSERT INTO soq_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Mai mida gara sanaa wadepie ita gara tontawa nagawa osowe itupie popolepi, diaida! Naita apana da epe dewalepia, gara sanaa gara tontawa nagawa osowe itunbodae popolena teinasopolepio nagawa debamalepi. ");
INSERT INTO soq_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Mai mida wain sanaa wain dugiwa tontawa bedewe memepono wineipona, dia! Naita apana da epe dewalepia wain dugiwa sa pumpu wapio wain nosepitue dugiwa do kadikadilepituwapi. Tane apana wain sanaa dugiwa sanaa os bedewe memeio winede.” ");
INSERT INTO soq_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sabat walamawe Iesu wawe alala do irai bedewe antoie nana wit ampuiantone ipawa namoie antoie. ");
INSERT INTO soq_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Parisi epe ewamone Iesu diane waienase, “No anaanamba wadia Sabat walamawe mai nolantipe wit otamoipona, dia. Dima baiwa e waawo alala no anaanamba aneipundedio e mai anaanamoipona?” ");
INSERT INTO soq_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Iesu sipoamone wanase, “E Dawid dudunawa buka bedewe wisiaitene ateiten, ba dia? Me sosowa do omana toidamono dima dewasaiena? ");
INSERT INTO soq_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abiata pirisi ionoidoa wandia walamawe Dawid God duwa bedewe alene bured kakaila pulontoia, anaanamba wadia pirisi os bured sa nanala, otamone sosowa do nane inanton. ");
INSERT INTO soq_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","God mai Sabat walamawa itupona apana sai osouwo ituntaa baiwa, diaida, tane apana euwau baiwa me Sabat itun. ");
INSERT INTO soq_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Tane Apana Otopa Sabat walamawa mambaida, me os oniede.” ");
INSERT INTO soq_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Sabat walamawa dawo Iesu gagalo duwa bedewe alene apana witapa bobopa do wandio donsan. ");
INSERT INTO soq_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Tane apana isiwa Iesu wawusapua baiwa me ewaitusaie laia do sape waimoie. Mo menamodia atentopu Iesu Sabat anaanawa oniepidewalepi, ba dia, me apana kerolala Sabat walamawe inasapi ba mo anaanau asiasi epi. ");
INSERT INTO soq_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Mape Iesu apana witapa bobopa diene wanase, “Ne mainawo wine, apana nambunepe enaa.” ");
INSERT INTO soq_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ita Iesu apana waitaramone wanase, “No anaanamba ambi wade, no Sabat walamawe dewa dainea os dewamonta? Walama sa bedewe apana kadilempo ewate eta ba sausata? Apana kerolala eto bolepi ba sausato inalepi?” Tane mo epe etane mai dima leusape wapona, dia. ");
INSERT INTO soq_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Iesu mo nuau badoleno ewedie nuawa kadiidalen mo mampo ita me nuawa pareidalen. Mape me apana witapa bobopa diene wanase, “Witaa aubea.” Ita Iesu diena rua me witapa aubeno inalen. ");
INSERT INTO soq_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Parisi dewa ema ewane tauwadea gagalo duwa ene Erod apanawa baibu antoiena. Ita mo dommone insaisau deasaie wawadiadiantoie inta banusaie Iesu bosapua baiwa. ");
INSERT INTO soq_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Iesu wawe alala do bola waimoia enee doa Galili tampe antoiena. Ita Galili apanawa uaraia Iesu wawe anton. Tane bola uduudu apanawa do Iesu ginasa dewamodia umanawa etane me mampe antoiena. Mo ipa Iudia, Ierusalem, Idumia, Taire, Saidon ita Ioadan waiwa da apanawa. ");
INSERT INTO soq_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Sape apana auweia uaraidanton. Iesu kerolala uaraia inamodia osowe mo uara bedeuwo kerolala uduudu ewaewasaaubantoie Iesu mampentopona baiwa. Mo inseia Iesu ibuwa wadape inantopona. Mo uaraia ewaewasaaubantoie Iesu bolawa dia naepe enapona. Sa baiwa me wawe alala diamona waa banuntopue wadapue wimopuo me bedewe odepie wampie waeuwalepi. ");
INSERT INTO soq_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Apana bedeuwo aleu kadiu wanwanlala Iesu eweia walamawe mo me danawe muba siribabantoie aubaubantoie waie waiase, “E ipa God Otopa.” ");
INSERT INTO soq_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Tane Iesu mo badowa anaanamona me umanawa mai wapue sabamosapu me mida, diaida. ");
INSERT INTO soq_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ema aupe Iesu wadiwa odene alene apana mida me menasadia rua apamone mampemon. ");
INSERT INTO soq_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ita apana 12 sa sonabamona me ebou Aposel itune ita diamone wanase, “Ne e sonabalena waroroneanuno do lakasantataa baiwa. Ita God aiawa amonawa baiwa ne waaubalepino aitonuna. ");
INSERT INTO soq_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Tane muka enalepa aleu kadiu tanamonuna baiwa.” ");
INSERT INTO soq_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Apana 12 sonabamona ebou ipa ema epe: Saimon, Iesu ebowa da ituna Pita, ");
INSERT INTO soq_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ita Sebedi obampa Iems wamba Ion nata, Iesu ebou da ituna Boaneages, aia ema ipawaida ipa uma obampa. ");
INSERT INTO soq_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ita do Endru, Pilip, Batolomiu, Matiu, Tomas, Iems, me ipa Alpias otopa. Tane do Tadeus, Saimon me ipa apana uwau Selotiwa sou dea, ");
INSERT INTO soq_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ita Iudas Iskariot mida Iesu laga mampe nanalepia apanawa. ");
INSERT INTO soq_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Iesu wadiwae iene alene duwa odeno tane apana uaraia bauta sape auweia rua osowe me baiwantone auweiena. Ita me wawe alala do bodamoieno mai nana napona rua. ");
INSERT INTO soq_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Me nola pokaidasadie, do wampadewae nana napona intawa dia gombawa umanawa etane me mampe antoie oniempaa baiwa. Mo waienase, “Dauwa me kainokaino nola os dewasadie wandia baiwa uwawa saiwa wano koakoalen. Ane, nuba wadate mainimbosate onieta.” ");
INSERT INTO soq_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Tane anaana waeuwalala isiwa Ierusalemwae iane wimone waienase, “Me bedewe aleu kadiu mambu ebowa Belsebul wandio mukawa mampe aleu kadiu apana bedeuwo waimoia tanamodio nomoie antoi.” ");
INSERT INTO soq_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Iesu mo gagalou etene baiwa apamono mampe wimoieno gagalo babau diamone wanase, “Ambi Seitan enepie tane me sowaida tanepi? ");
INSERT INTO soq_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Naita tawo moawa dea mai insaisau dealepia muba onantopue empuempu bedeuwo segalepio deaantopuo bola sa ebowa dialepi. ");
INSERT INTO soq_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Naita dan dea mai insaisau dealepia mo bedeuwo empuempu segalepio wanwambu kadiidalepio deaantopu. ");
INSERT INTO soq_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Naita mo mida Seitan gonaawa bedewe waimoia muba adiananantompe empuempuntompa mo gonaau muba kadikadisapuo dialepi. ");
INSERT INTO soq_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Apana kasawogala duwa bedewe mai apana poiwaa reba odepie puraiwawa otamopia rua, dia. Tane me ideita apana kasawogala bauta taupidoe muriwa puraiwawa duwa bedewe winamoia otamopia rua. ");
INSERT INTO soq_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ne ulaipa dialedina, apana mida God mampe dodomanalepona menasadia God me kadiwa uduudu insadabuamopie inasapi. Naita me God wakadisasana, kadi sa debama do insepidabuasapi. ");
INSERT INTO soq_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Tane mida Aleu kakaiwa wakadisasadia, God me kadiwa mai insepidabuasapie inasapi, diaida, kadiwa sa winakasalepi.” ");
INSERT INTO soq_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Iesu gagalo ema wana, ipawa mo isiwa me wakadisasane waienase, “Me bedewe aleu kadiwa wandie nolaleide!” ");
INSERT INTO soq_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Iesu gagalo ema wamontuwano aupe me inawa wanwamba do me awa wimoiena. Tane apana uaraia sape auweieno baiwa mo mai du bedewe odape Iesu mampe wimopona rua, dia. Sa baiwa mo peloo enane gagalo os wanaaubeiena Iesu mo mampo nosepia baiwa. ");
INSERT INTO soq_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ita apana uaraia du bedewe Iesu waine paneiena benema sa etane waiasaieno alene Iesu mampe wisen ita gagalo sa wane waienase, “E inaa wanwana do peloo waimoi, menamodia eweepue do gagaloitana.” ");
INSERT INTO soq_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Iesu mo uaraia waitaramone wanase, “Mida ne inana ita waiwaina umanau wailana?” ");
INSERT INTO soq_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Tane me uaraia waine paneiena ewamodie diamone wanase, “Ema ipa ne inainana ita waiwaina waimoi! ");
INSERT INTO soq_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Apana mida God insaisawa dewasadia me ipa ne waina, weanana ita inana wande.” ");
INSERT INTO soq_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Iesu leulene doa Galili tampe wisene osowe waeuwaleidie. Tane apana uaraia sape auwene me tonusaieno baiwa Iesu waa bedewe odene waine ita mo uduudu esa tampe waimoio waeuwamodie. ");
INSERT INTO soq_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Tane Iesu waeuwa uara gagalo babawa mampe mo waeuwamodie wane wanase, ");
INSERT INTO soq_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ne asisudewaneana! Irai apanawa lawuru naumba aimopia baiwa nosene alen. ");
INSERT INTO soq_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ita me iraiwa bedewe lawuru naumba laraimona isiwa into nonosinton, tane nene wimone ennaanton. ");
INSERT INTO soq_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","6","Naumba isiwa siara bedewe nomone tauwadea teponton, tane siara uduudulena baiwa waapa mai iapona, dia. Ita omo idia walamawe tepolala sa imono rorontonatuwaiena. ");
INSERT INTO soq_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Naumba da gedara kaigawara bedewe nomono gedara inintone lawuru tauboiamoieno mai ipawa naupona, dia. ");
INSERT INTO soq_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Tane lawuru naumba da irai dogowa euda osowe nomone inintone ipawa uaranton, ipawa naumona isiwa 30, da 60 ita isiwa teamona 100.” ");
INSERT INTO soq_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ita Iesu gagalowa diasapia baiwaleidie wanase, “Mida asiwa wineipono aia ema eteipe atenleipona!” ");
INSERT INTO soq_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Asisulala uaraia ene antoieno aupo Iesu wawe alala 12 ita warorowa isiwa os Iesu do waimoie gagalo babawa me waeuwamona ipawaida atentopua baiwa me waitarasaiena. ");
INSERT INTO soq_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ita Iesu mo diamone wanase, “God gonaawa benemawa ipawaida wadenitudena e os manlawo sabamoleidio ateitile wainilana. Tane mo mida me gonaawa adiwe waimoia mampo mai sabamosaipono atentoipona, dia. Tane mo mampo gagalo babawa waeuwa os nosedio eteie waimoi. ");
INSERT INTO soq_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Dima peroweta Aisaia mapo wana ipawanaleide, me wane wanase, ‘Mo dewa ewompa, tane mai atendewantopu, do gagalo etompe tane mai insepue atentopu, dia. Naita dima eweipe ita eteipe atentoipono mo insaisau leusape God mampentopono kadiu insadabuamopona.’” ");
INSERT INTO soq_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Mape Iesu mo mampo wane wanase, “E lawuru naumba gagalowa babawa ipawaida mai ateitapona, ba? Gagalo babawa ema ne sabamo wana, tane ambi e mai ateitapona? Naita ema mai ateitana e gagalo babawa isiwa do mai atenmona rua, dia! ");
INSERT INTO soq_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Gagalo babawa ipawaida ipa ema epe: Irai apanawa lawuru naumba laraimodia, sa ipa me mida God aiawa amonaleidia umanawa wade. ");
INSERT INTO soq_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Lawuru naumba into nomoio nene namoituwadia, sa ipa apana mida God aiawa eteia bedewe Seitan wisedie aia sa mampo poileidio nuau koakoaleidia umanau wade. ");
INSERT INTO soq_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Lawuru naumba siara osowe laraimono tauwadea tepontona, sa ipa mo isiwa mida God aiawa eteie nuaeu do wadeie mamposaia umanau wade. ");
INSERT INTO soq_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Mo God aiawa eteie mamposai, tane mai nuau bedeweido ituipono wineipona, dia. Ita dewa badowa mampolempo, ba sosou mo sumanaibu baiwa poka daitada wanamompo mo tauwadea os sumanaibu oauaralepio etedabuantopu. ");
INSERT INTO soq_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Lawuru naumba gedara kaigawara bedewe nomoie inintoie mai ipawa naumoipona, sa ipa mo mida God aiawa eteie mamposai, tane eteia sa bedewe mai ipawa da naumoipona umanau wade. ");
INSERT INTO soq_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Mo God aiawa eteie mamposai, tane ete nuabolawa, do mane ita puraiwa nua teiteinawa, ita do ewanuau daitada nuau bodedio baiwa God aiawa mo bedeuwo eueuwa ipawa dia. ");
INSERT INTO soq_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Tane lawuru naumba dogo euda osowe laraimono inintone ipawa uaraia naumoiena, sa ipa mo mida God aiawa eteie mamposaie ruawantoia naunau debamaia nauia umanau wade. Isiwa naumoie ipawa teia 30, isiwa 60, ita isiwa ipawa 100 rua tei.” ");
INSERT INTO soq_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Tane Iesu mo waitaramone wanase, “E siwa idia wadeile onta ba wata atowe ituile sapa bodeilana, ba? E mai epe dewaitipona, dia, tane e siwa idia wadeile sawano ituilano sapa debamaleide. ");
INSERT INTO soq_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Nitu uduudu weregalala wineia ando sabamontoputuwapi, do nitu uduudu rupulala wineia ando wadaaubantopu, apana uduudu ewapue atentopu. ");
INSERT INTO soq_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Mida asiwa wineipono aia ema eteipe atenleipona!” ");
INSERT INTO soq_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ita Iesu mo diamone wanase, “Dima ne dialedina asisudewaitane gagalo wadanadewaitana. Ema epe: E God aiawa debamasaile wadeile manlawosailana, deawaa God ando debama ruawalepie enalepi, tane osowesapie do enalepi. ");
INSERT INTO soq_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Apana mida debama mampe wineia God ando debamaia wanepio mauraidalepi. Tane naita apana keraudaida karami rua mampe winompa God ando keraudaida sa me mampe wadepiaubepio diaidalepi.” ");
INSERT INTO soq_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Iesu epe wane wanase, “God gonaawa ipa lawuru naumba apana dogo osowe laraimodia rua. ");
INSERT INTO soq_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Me naumba laraileiditue edie aleide duwe ita wandiboleidio rua lawuru naumba tepontoi. Tane irai apanawa lawuru naumba laraimodia mai onieipono inintoipona, dia, muba inintoi, ita irai apanawa atensasia ambi inintoi. ");
INSERT INTO soq_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Irai dogowa meba dewasadio lawuru naumba tepontoie bumpa teie, nepa badontoio asiwa teamodio nauie ipawa tei. ");
INSERT INTO soq_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ita mena waio uwauwa walamawa wisedio irai apanawa isima wadedie tomodie uwauwaleide.” ");
INSERT INTO soq_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ema aupe Iesu wane wanase, “God gonaawa gagalo babawa dainea mampe waeuwantate atenidantata. Me gonaawa dima rua? ");
INSERT INTO soq_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","God gonaawa ipa paipai iawa naumba rua. Naumba uduudu bedeuwo naumba sa keraudaida dogo bedewe anei. ");
INSERT INTO soq_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ita inileidie debamaidaleidie ragapa uaraia tede, mai naumba isiwa aimoio inintoia rua, dia. Ita nene wimoie ragapu osowe duntoie golaupa bedewe waimoi.” ");
INSERT INTO soq_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Iesu gagalo babawa uara ema rua mampe God aiawa gagalowaleidie, apana atentopua rua os mampo waeuwaleidie, mai rebareba, dia. ");
INSERT INTO soq_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Me walama uduudu gagalo babawa mampe apana waeuwamodie, mai ipawaida sabamo waipe apana diamoipe, dia. Tane me wawe alala os do waimoia walamawe gagalo babawa ipawaida sabamoido waeuwadewasamodie. ");
INSERT INTO soq_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Rawi sawo Iesu wawe alala mampo wane wanase, “Nawate antata doa waiwa dawo.” ");
INSERT INTO soq_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Apana uara emone mo waa bedewe odane Iesu aitamana waa bedewe wandio do antoiena. Ita waa isiwa do antoie. ");
INSERT INTO soq_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Mo antoio lawara debamawa segaleno rauwanaga debamalene waa bedewe odene esa uduuduleno waau monulepona baiwaleidie. ");
INSERT INTO soq_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Tane Iesu waa niwa kampa belala bedewe uwawa unuana osowe itune ituleidio wawe alala wimone me wadamesasane waienase, “Debamamba, no monuntate bontataa inseie nuaa pola wade, ba dia?” ");
INSERT INTO soq_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Mo epe waio Iesu enenwisene lawara ita esa mampo badowa wane wanase, “Aisite dainaitaa!” Tane lawara aisidene iene alene dialen ita sala uduudu obasalene dainalen. ");
INSERT INTO soq_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Mape Iesu wawe alala diamone wanase, “E dima baiwa saidaiten? E sumanaila dia epe dewaiten?” ");
INSERT INTO soq_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Tane mo saidantone muba eda waitarantone waienase, “Me mida epe wano segalen, lawara ita rauwanaga me aiawa ruawantoi!” ");
INSERT INTO soq_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Iesu wawe alala do doa Galili nawane antone waiwa dawo Gerasa tawowa bedewe wimoiena. ");
INSERT INTO soq_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ita Iesu waa bedewe nosedio apana bedewe aleu kadiu waimoia bo gubauwo wandi leidia nosene Iesu donsan. ");
INSERT INTO soq_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Me bo gubauwo wanwanlala. Me dewawa kadiwa baiwa apana walama uara witapa ita wawa seni mampe taumoio tane me epapuialeidie edie aleide. Mai mida da kasawoga ita me wadepiitue taupia rua, dia, sa baiwa mo eiena. ");
INSERT INTO soq_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Me wadi bedewainta bo gubauwo wandi leidie. Me walama ita tadina ruawaleidie mukama ke wadie rasaleidie meba etepa seu mampe epakeialeidie. ");
INSERT INTO soq_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Me Iesu eseanamaido ewene weuwane alene Iesu mampe wisen. ");
INSERT INTO soq_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Ita Iesu me diene wanase, “Aleu kadiwa apana ema bedewe wainiana ee noe nambe aitaa!” Me ema etene Iesu danawe imimpa emmisilene mukama siribabalene wane wanase, “Iesu, God ionoidoa Otopa, e mai nolaa da ne mainawo wineipona, dia. E God ebowa mampe sauanea mai kadineawo poka etapa!” ");
INSERT INTO soq_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Mape Iesu me waitarasane wanase, “E eboa ambi?” Ita me sipoasane wanase, “Ne ebona Uaraia, ipawa no aleu kadiwa uaraia mape wainitana.” ");
INSERT INTO soq_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Me Iesu kainokaino iririsadia aleu kadiu mai tanamopio tawo sa epue nambe antopu, dia. ");
INSERT INTO soq_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Tane walamaipa bono uara wadi sainape maida lodontoie laie. ");
INSERT INTO soq_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ita aleu kadiu Iesu iririsane waienase, “No menanedia bono sa bedeuwo ane wainenta.” ");
INSERT INTO soq_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Dima mo iririwantoiena Iesu oaleno ita aleu kadiu apana ene nomone bono bedeuwo antoiena. Tane bono uaraia sa, wisia 2000, weuwane dai debama bedewe antoieno doa numamon. ");
INSERT INTO soq_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Bono oniamoia apanawa dima bono mampo segaleno ewane tauwadea weuwane antone bola debama ita kerakera bedeuwointa apana benemamoiena. Ita apana benema sa etane bolau ene doa tampe antoiena dima segalena ewapua baiwa. ");
INSERT INTO soq_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Mo Iesu mampe wimone apana mida bauta aleu kadiu bedewe wanwanlala gara taudewasalene insaisawa dodomana euda wandio ewane saidantone inseienase, “Ambi ipa ema epe, apana ema dewawa dodomanaleno wande?” ");
INSERT INTO soq_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ita mo mida dima segaleno eweiena apana wimoiena mampo benemantoiena. Mo apana aleu kadiwa bedewe wanwanlala eulena benemawa ita do dima bono mampo segalena benemawa wane diamoiena. ");
INSERT INTO soq_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Mo ema etane Iesu badowa iririsaiena bolau epie alepi. ");
INSERT INTO soq_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ita Iesu waa bedewe odepia baiwaleidio apana inalena Iesu do antopona baiwa iririleidie. ");
INSERT INTO soq_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Tane Iesu me wanitudena mai do antopu, dia, ita diene wanase, “E bolaawo aite gombaaida mampo ginasa debamawa Tatamba manawo dewasana ita do ambi e nuaparealene inaena benemawaitawo atentopu.” ");
INSERT INTO soq_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Iesu wana rua me ene bola Dekapolis bedeuwointa alene Iesu ginasa debamawa me mampe dewasana umanawa apana benemamodie. Ita apana uduudu ema etane memesanton. ");
INSERT INTO soq_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Tane Iesu bola sa ene waa asiasi nawene doa waiwa dawo leulene alene wisedio apana uaraia wimone sape auweiena. ");
INSERT INTO soq_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ita gagalo duwa bedewe apana auweio oniamodia apanawa ebowa Iairas do sape wisen. Ita me Iesu ewene wawa bumpe imimpa emmisilene ");
INSERT INTO soq_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","nuawa uduudu mampe Iesu iririsane wanase, “Winea, ne anona kerauda bo baiwaleide, ne menanedia e witaa osowe ituwo inalepi.” ");
INSERT INTO soq_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Iesu me nata antoio apana uara mo wauwontoie apisamoiena. ");
INSERT INTO soq_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ita apana uara bedeuwo i kerowa etepe osina weuwadia enawa 12 diantona sape leidie. ");
INSERT INTO soq_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Me pokaida etedie doketa uara mampo alen sausapono inalepona baiwa ita manewa uduudu mampe wineia di diasan, mai inalepona, tane kerowa debamaleidio wandie. ");
INSERT INTO soq_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Me Iesu benemawa etena baiwa apana uara auweio bedewe wisene Iesu adiweinta mampelene garawa moawa os waden. ");
INSERT INTO soq_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Me epe dewalena ipawa me insenase, “Naita ne Iesu garawa wirasapa ne inanteapa.” ");
INSERT INTO soq_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Me Iesu garawa moawa wadedio osina etepe weuwadia dialen ita me tauwadea dauwa etene atenlen me inalen. ");
INSERT INTO soq_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","I sa Iesu garawa wirasadio kerolala inamompaa mukawa me mampe nosedio dauwa etene apana uara bedeuwo leulene enene waitaralene wanase, “Mida ne garana wirasan?” ");
INSERT INTO soq_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Tane wawe alala leusane Iesu diane waienase, “E apana uaraia do apiapisaitile eneile bedewe e waitaraitie waianase, ‘Mida ne wiranen?’” ");
INSERT INTO soq_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Tane Iesu apana uaraia tampe eneia bedeuwo mida me wirasana ewabanuleidie atensapona baiwa. ");
INSERT INTO soq_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Tane i inalena meba ateatenlene baiwa sa ita uwauwa etepe odedio Iesu mampe wisene wawa bumpe imimpa emmisilene wasabamowa wane dima dewasana umanawa dientuwan. ");
INSERT INTO soq_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ita Iesu i diene wanase, “Anona, mai nuabolaitaa, nuaeu mampe bolaawo aitaa, e sumanaia inaen, poka eteiana tauma dialen.” ");
INSERT INTO soq_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Iesu i sa mampe gagaloleidio, apana isiwa Iairas duwee wimone ita Iairas diane waienase, “E anoa aitamana bolen, Iesu surakauwa ea.” ");
INSERT INTO soq_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Mo dima waia Iesu etene mai insepona, dia, tane Iairas diene wanase, “Mai insaisaa nosepio inguguraitaa, sumanaitaa!” ");
INSERT INTO soq_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Iesu apana uduudu wawentoia waitumona mo wankasantopua baiwa. Tane me menasana Pita ita Iems wamba Ion nata mo os do antopu. ");
INSERT INTO soq_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Mo Iairas duwa mampentoie apana uara sape ke waie nuapareparentoio ewamoiena. ");
INSERT INTO soq_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ita Iesu du bedewe odene apana ke waio diamone wanase, “E dima baiwa ke waile nuaparepareitilana? Oto mai bolepona, di ituleide.” ");
INSERT INTO soq_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Mo Iesu epe wadio etane me oiwa waiena. Tane Iesu apana sa uduudu waaubamono nomone antoiena. Ita oto mamba inawa nata, do wawe alala natadea Iesu do wimoiena oto ituleidiawo odane antoiena. ");
INSERT INTO soq_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Sape Iesu oto witapa wadene diene wanase, “Talita koumi!” Aia ema ipawaida ipa ema epe: I sanaa kerauda, ne dieedina enawiea! ");
INSERT INTO soq_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Iesu wadio i kerauda tauwadea enenwisene sape leidie. Me muwa enawa 12 dialen. Tane apana uara sape waimoia i sanaa kerauda inawaa leidio ewane memesaidanton. ");
INSERT INTO soq_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ita Iesu mo badowa anaanamona dima segalena umanawa mai wapue apana da benemamopu, dia. Ita Iesu diamona oto inalena nana da wanapuo napi. ");
INSERT INTO soq_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Iesu bola sa ene bolaweido aleidio wawe alala warorosane do antoiena. ");
INSERT INTO soq_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ita Sabat walamawa wiseno me gagalo duwa bedewe odene alene waeuwaleidio mo uara sape auweiena me gagalowa etane memesantone muba eda waitarantone waienase, “Me aten insaisawa na wadene badowa gagaloleide? Me ginasa debama dewamodia mukawa na waden? ");
INSERT INTO soq_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","No apana ema ateinimba, me mai giruma debama wadapona, me nolawa kanda os dewalala. Me Meri otopa, ita me wanwamba Iems, Iosep, Iudas ita Saimon ateinimba do weaweanapa mape waimoi.” Mo insaisa epe insene nuau insakoaleno Iesu ewane dabuasaiena. ");
INSERT INTO soq_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Mo dima inseia Iesu atenlene mampo wane wanase, “Bola uduudu apanawa peroweta bola dawoe wisedia wadeie mamposaie gagalowa deaitopa eteidewantoi. Tane me bolawaida apanawa, sa ipa me gombawaida ita mu sosowa, mai wadeipe mamposaipe gagalowa eteipadewantoipona, dia.” ");
INSERT INTO soq_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Me bolawaida apanawa Iesu dabuasaiena baiwa sape me apana kerolala nata os witapa osouwo itune inamon, tane mai ginasa isiwa dewamopona rua, dia. ");
INSERT INTO soq_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Iesu insenlewalen, ipawa bolawaida apanawa sumanaibu dia. Ita ene alen bola isiwa bedeuwointa apana waeuwamodie. ");
INSERT INTO soq_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Iesu wawe alala 12 apamono mampe wimoiena waaubamopia baiwa, ita mo diamona natanata os antompa bola deadea bedewe. Ita Iesu mo aleu kadiwa apana bedeuwo waimoia tanamompaa mukawa wanamon. ");
INSERT INTO soq_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Mo a baiwantoio Iesu wadewasamone wanase, “Ala bedewe mai dima da wadane do aitana. E mai nanala, ba petala ba manela otene do aitana, tane aitonune koinala os otena. ");
INSERT INTO soq_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","E sendorola taune ita garala taumoilana os do aitana, mai garala isiwa otena, dia. ");
INSERT INTO soq_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Aitonune bola dainea bedewe wileno apana dainea wadalepie mampelepia me duwa bedewe waine nolala bola sa bedewe diasane ene aitana. ");
INSERT INTO soq_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Tane aitonune bola dainea bedewe wilenuno bola sa apanawa mai wadalepue mampolepua bola sa apanawa mampo matangela eueuwa dewasane walawo dogo wineia uwakokosano ewapue atentopu. Ita bola sa apanawa adilawomone ene aitana.” ");
INSERT INTO soq_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Iesu epe diamono wawe alala me ene antone Gagalo euda amonantoie apana kadi bedewe waimoia diamoia mo insaisau leusape God mampe dodomanantopona. ");
INSERT INTO soq_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ita aleu kadiu uara apana bedeuwo waimoia mo tanamoio nomoie. Do apana kerolala uara ia olib naumba esapa etepo ituieno inanton. ");
INSERT INTO soq_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Bola uduudu bedewe Iesu ebowa debamaleidio warere Erod benemawa etene atenlene wandie. Apana isiwa Iesu insakoasaie me umanawa waiase, “Me ipa Ion Babatutu bo bedewe inalene enenwisene muka wadene ginasa debama dewamodio umanawa eteitana.” ");
INSERT INTO soq_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Tane apana da insakoantoie waiase, “Me ipa peroweta Elaia leulene wisen.” Ita isiwa Iesu umanawa waiase, “Me ipa peroweta da mapo wimoia rua wisen.” ");
INSERT INTO soq_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Apana Iesu umanawa epe waio Erod etamone wanase, “Me ipa Ion Babatutu, me imumba ne tonapundeno bolena, tane me bo bedewe inalene enenwisene nolaleide!” ");
INSERT INTO soq_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Muriwa Ion bolen, me wandia walamawe Erod manainapa ebowa Erodias Ion mampe nuawa kadiidalen, ipawa Ion kainokaino Erod diedie wadiase, “God emawe mai dodomana e tataa Pilip manainapa naisee nata wainilana.” Ita me manainapa nuaeusapia baiwa Erod Ion Babatutu mampe ema epe dewalen: Me sorodiawa waaubamono antone Ion wadane seni mampe taune dibura bedewe ituiena. ");
INSERT INTO soq_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Erodias Ion nibuasadie menasadia Erod me bosapona. Tane dima me insedia Erod mai menasapona, dia, ");
INSERT INTO soq_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","me Ion di bosapia sawalen, ipawa me atenlena Ion apana euda dodomana kakaiwa wande. Sa baiwa me mai bosapona, dia, tane dibura bedewe eno di wandio oniadewasasadie. Ita Erod me gagalowa etaetawa menasadio sorodiawa kainokaino waaubamodio antoie Ion dibura bedewe banleie Erod mampe wimoio me gagaloleidio asisusadie. Tane me aiawa etedie nuawa surakauidaleidie. ");
INSERT INTO soq_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Erodias Ion bosapona insaisawaleidie wandia Erod muwa walamawe me walamawa wadedidewae dima insedia dewasapi. Ita ema epe segalen: Erod mulena walamawe oda debama dewasadie ita me gabeman debamau, sorodia debamau ita tawo Galili apanawa debamau nisomono wimoiena. ");
INSERT INTO soq_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Oda ema bedewe Erodias anoopa bialeidio Erod ita nisolala apanawa uduudu nuau waden. Me bia diasadio warere Erod manainapa Erodias anoopa diene wanase, “Dima uduudu meneedia dianeawo eneepa!” ");
INSERT INTO soq_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ita me i sanaa badowa sauasane wanase, “Dima uduudu e wae dianea ne ruawantape eneepa, mai dia. Ne dima osowe wainedina waiwa e meneempa ba bolana oniedina waiwa da meneempa ne ideita eneepa. Naita ne lagaepa kadiwa mainawolepi.” ");
INSERT INTO soq_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Erod i sanaa gagalosane diasano me ene alene inawa mampe wisene waitarasane wanase, “Inako, dianea ne Erod dima iririwasapo nepi.” Ita inawa sipoasane diene wanase, “E aitee Erod Ion Babatutu imumba topipundepia baiwa iririwaitaa!” ");
INSERT INTO soq_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Inawa dima diena rua anoopa diniwa mampe leulene alene warere Erod mampe wisene iririwa itune wanase, “Ne menanedia e tauma ema Ion Babatutu bosae uwawa laukai bedewe itue neaa.” ");
INSERT INTO soq_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Warere Erod ema etene nuawa pareidalen, tane iriri sa etape epona mai rua, ipawa dima me Erodias anoopa badowa sauasana nisolala apanawa uduudu etane atentoiena. ");
INSERT INTO soq_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Sa baiwa me tauwadea sorodiawa dea wanaubene diene wanase, “Aite, tauwadea Ion imumba toapundepi ita uwawa wade winea!” Ita Erod diena rua sorodia dibura bedewe alene Ion imumba tonpundene, ");
INSERT INTO soq_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","uwawa laukai bedewe itune wadene leulene wisene Erodias anoopa wanen. Ita me wadene alene inawa wanen. ");
INSERT INTO soq_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Tane Ion warorowa ema umanawa etane wimone Ion etepa wadane dobontoiena. Ion Babatutu mampe epe segalena baiwa Erod tauma me Iesu umanawa etene insakoalen. ");
INSERT INTO soq_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Aposel Iesu waaubamona leuntone wimone Iesu do dondontone mo ambi nolantoiena ita ambi mo apana waeuwamoiena umanawa me benemasaieno eten. ");
INSERT INTO soq_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ita sa bedewe apana uara dima menamodio baiwa mampo wimoie antoi ita surakaumoieno nana mai napona rua, dia. Sa baiwa Iesu wawe alala diamone wanase, “Bola ema ete ane bola dawo no nubaosintate tauma bubuadewaitana.” ");
INSERT INTO soq_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ita mo bola sa ene waa bedewe odane muba os bola obasawe antoiena. ");
INSERT INTO soq_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Tane apana uara mo ewamoio antoiena ita mo atenmoiena mo mida, do atentoiena bola daineawo antoie. Sa baiwa mo uara bolau emone doa waiwainta weuweuwa os mampe waa ainaboe antoie Iesu wawe alala do bola naepe wimopuawo wimone anubu waimoie. ");
INSERT INTO soq_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Mo bola sawo wimone Iesu waa ene nosene apana uaraia sape auweio ewamone nuapareuidalen, ipawa mo sipsip mubaida onioniau apanawa dia rua waimoie laie. Ita Iesu mo uaraia waeuwa daitada mampe waeuwamodie. ");
INSERT INTO soq_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Tane omo pamedio Iesu wawe alala me mampe wimone waienase, “Aitamana rawileide, apana omanatomode, bola ema sawanaida bedewe wainitana mai nana da naepe wadataa rua, dia. ");
INSERT INTO soq_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Sa baiwa e apana waaubamowo bola maida isiwa bedewe antopue muba nanau gimarantopue napue pokamopi.” ");
INSERT INTO soq_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Tane Iesu sipoamone wanase, “E nana wanamono napu!” Iesu epe diamodio etane waienase, “E ambi waiana, e meneedia no ane mane nepa 200 mampe bured gimarantate wanamoto napue pokamopi, ba?” ");
INSERT INTO soq_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Mape Iesu mo waitaramone wanase, “Aitane, banuitane ewana e manlawo bured uduudu ambi winei?” Mo Iesu diamona rua antone donsane leuntone wimone Iesu diane waienase, “No mainimbo bured 5 ita bouri nata winei.” ");
INSERT INTO soq_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Mape Iesu wawe alala diamone wanase, “Apana diamono empuempuntopue ina osowe wampu.” ");
INSERT INTO soq_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Wawe alala mo diamoieno rua apana empuempuntone da 100, ita isiwa 50 ruaweruawe waimoiena. ");
INSERT INTO soq_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ita mo sape waimoieno Iesu bured 5 ita bouri nata wadaposilene pisiwane uba ewene nana baiwa God auwasan. Ita auwasano dialeno me bured ampuialene bouri dosane wawe alala wanamon amonantopue apana wanamopua baiwa. ");
INSERT INTO soq_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ita mo nana sa amonantone wanamoieno apana uduudu nane pokamon. ");
INSERT INTO soq_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Tane apana nana nane pokamono moawa eiena wawe alala nana sa auwene posawa 12 bedewe aneieno nope wimon. ");
INSERT INTO soq_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Apana uaraia sape nana nane pokamon, ita apana mona os wisiawa 5000 waden. ");
INSERT INTO soq_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Nana dialeno Iesu wawe alala diamone wanase, “E waa bedewe odane nawane doa waiwa dawo bola Betisaidawo aitonuno ne apana ema uaraia waaubamopo bolauwo antompo walawo wimpa.” ");
INSERT INTO soq_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Wawe alala antoieno aupo Iesu apana waaubamono antoio me raupari baiwa wadiwa odene alen. ");
INSERT INTO soq_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Me meba sape rauparileidio wawe alala nawane antoie doa Galili pouwentoio tadinaleidie. ");
INSERT INTO soq_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ita Iesu wadiwa waine wawe alala ewamodio lawara awanamodio a babisaie. Walama pumpu sawano Iesu esa osowainta enene mampo aleidie. Tane me amboiamopona baiwaleidio ");
INSERT INTO soq_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","wawe alala uduudu Iesu esa osowe enene aleidio ewane inseia nitu da ewei, mai apana, ita mukama siribabantoie saidantoiena. ");
INSERT INTO soq_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Mo siribabantoio Iesu tauwadea diamone wanase, “Mai saitana, ne iedina, siribaba ena!” ");
INSERT INTO soq_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Iesu epe wane mo mampolene waa bedewe odedio lawara aisidene iene dialen. Ita Iesu wawe alala ema ewane memesaidanton, mai dima wapona rua. ");
INSERT INTO soq_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Iesu apana uaraia nana wanamono nane pokamona wawe alala insaisawa wadeie tane ipawaida mai atendewantopona, dia, ipawa mo nuau badoleno waimoie. ");
INSERT INTO soq_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Mo nawane antone bola Genesaretiwa wimone waa taunadodeiena. ");
INSERT INTO soq_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ita mo waa bedewe nomoio apana Iesu ewane tauwadea os atensaiena me mida. ");
INSERT INTO soq_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Mo Iesu ewane ene diniwa mampe bola sa uduudu bedeuwointa antoiena ita bola daineawo Iesu wisedio umanawa eteie kerolala rasirasi osowe ituntoio awanamoie bola sawo Iesu mampe ieie. ");
INSERT INTO soq_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ita Iesu bola sa uduudu debamau ita kerakera bedeuwointa aleidio bola sa deadea apanawa kerolala awanamoie maket bolawe teamoie. Ita apana sa Iesu iririsampo sosou kerolala me garawa moawa os wadapue inantopua baiwa. Ita kerolala uduudu mida me garawa wirasaiena inantoiena. ");
INSERT INTO soq_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Parisi apanawa ita anaana waeuwalala isiwa Ierusalemwae wimone Iesu asisusaie do laie. ");
INSERT INTO soq_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ita mo wawe alala dewau eweie atentoiena, mo isiwa mai Iuswa anaanau ruauntoipe witapu mitadewasamoipe nana naipe, dia, mo di nana naie. ");
INSERT INTO soq_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Tane Parisi apanawa ita Iuswa uduudu do nosinosiu anaanau ruawantoie mo dewasaiena rua witapu mitadewasantoie muriwa nana nai, mai di. ");
INSERT INTO soq_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ita mo nana maketiwa gimaramoie nosinosiu anaanau wadia rua mitadewasamoie nai. Ita mo redubu, ontau ita laukaibu anaanau wadia ruawantoie mitadewasamoio winei. Tane do dewa isiwa uara mo nosinosiu anaanau asiasi dewamoie waimoi. ");
INSERT INTO soq_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Parisi ita anaana waeuwalala Iesu wawe alala nana di wadeie naio ewamone Iesu waitarasane waienase, “Dima baiwa e waawo alala anaana nosinosimba ituiena mai ruawantoipona, tane witapu mitasasia di nana wadeie nai?” ");
INSERT INTO soq_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Tane Iesu sipoamone wanase, “Peroweta Aisaia mapoido e umanala ulaipaida wadie. E ipa lagawaauida, me girumalena rua. Aia sa girumalena bedewe God wadi wadiase, ‘Apana ema aiau os mampe ne ituposinei, tane mo nuau ipa nambeido, mai ne mainawo, dia. ");
INSERT INTO soq_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Mo apana mampo apanaida anaanau waeuwantoio etei, abo ne anaananaida waeuwantoipona rua. Mo apanaida anaanau asiasi waeuwantoia baiwa taparorontoie wadaposineia ipasiawaia, di dewasai.’ ");
INSERT INTO soq_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Aisaia girumalena rua e dewasaile wainilana. E God anaanawa eilana, tane apanaida anaanau wadeile dewasailana. ");
INSERT INTO soq_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","E God anaanawa dabuawa intawa atendewaidaiten ita eba waeuwala os dewamoile wainilana. ");
INSERT INTO soq_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses God anaanawa itune wanase, ‘E mamaa ita inaa do oniadewasamoe aiau ruawaitona,’ ita do wanase, ‘Mida mamba ba inawa dabuamodie wakadisamodia, me epapubolepi.’ ");
INSERT INTO soq_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Moses epe dialen, tane e waeuwakadisaitile wailanase, ‘Naita apana da nitu da euda mampe winedia gombawa saumopona, tane me edie nitu euda sa wadedie God pulosade, ");
INSERT INTO soq_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","sa ipa dewa euda dewasade, mai anaana aneipapundeipona, dia.’ ");
INSERT INTO soq_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","E anaanala tontawa gombala wadaiasaieno wisena mampe God anaanawa ipasiasailana. Tane mai ema os, e dewa daitada mampe apana waeuwakadisamoile God anaanawa ipasiasaile wainilana.” ");
INSERT INTO soq_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Iesu epe wane aupe apana osowe apamone auwamone diamone wanase, “E uduudu ne asisuneane dima wadina etanadewaitane nualawo ituno winepi. ");
INSERT INTO soq_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","E mai nana da nailana bedelawo ieipe miramiraleipona, dia. Tane dima e bedelawo wineia miramiralede.” ");
INSERT INTO soq_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Iesu epe wano dialeno aupe apana auweiena emone du wandia bedewe odene alen. Sape me wawe alala Iesu dima wana ipawaida atendewantopona baiwa me waitarasaiena. ");
INSERT INTO soq_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Tane Iesu sipoamone wanase, “Ambi e ne gagalo wano mai atendewaitapona ipawa banusailana? E mai nana da naipono bedelawo ieipe miramiraleipona, dia. ");
INSERT INTO soq_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ipawa nana sa nailano mai nualawo ieipe wineipona, dia, tane bulawo iedi winedie muriwa nosedie nambeleide.” Waeuwa ema mampe Iesu mo waeuwadewasamona nana uduudu eubu os nanalala winei. ");
INSERT INTO soq_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ita Iesu diamone wanase, “E mai nana naipona mampe miramiraitipona, dia, tane dima nualawo wineia, sa ipa insaisala mampe, ba aiala mampe, do dewamoilana mampe miramiralei. ");
INSERT INTO soq_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ipawa apana nuau bedewe kadiwa daitada sanantoio wineia eueuwa dewasaie ninantoi, pointoi, apana epaboiamoi, nainai bedewe ninarebarebantoi, ");
INSERT INTO soq_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","sosou puraiwau ewanuauwantoi, kadiwa daitada dewasai, lagantoi, dewa malawalaida dewamoi, obuntoi, ula kadiwa wamoie kutuntoi, kasawogantoie asowawantoi ita insaisa kadiwa insamoie lai. ");
INSERT INTO soq_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Dewa kadiu ema uduudu apana nuau bedewe nomoie miramiramoi.” ");
INSERT INTO soq_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ita Iesu waeuwaleidia ene alene bola debama Taire mampelene bola kerakera bedewainta wandi leidie. Sape me du dea bedewe odene wandie mai menasapona apana atensapu, dia. Ita me weregalepona mai rua, me benemawa debamaleno apana uduudu eteiena. ");
INSERT INTO soq_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ita i dea anoopa bedewe aleu kadiwa wandia sape wandie Iesu benemawa eten. Me mai Israel iwa, dia, me Siria iwa, bola Penisiawo mulena. Me Iesu umanawa etene tauwadea me mampe wisene danawe meba aubaubalene iririsane wanase, ");
INSERT INTO soq_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","“Ne menanedia anona bedewe aleu kadiwa wandia tanawo nosepie nambelepi.” ");
INSERT INTO soq_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Mape Iesu me apanawaida Iuswa ita uwa daitada apanawa gagalou babawa i diene wanase, “Bauta seda kerakera nana menamodia wanamoto napue pokamopi. Mai eulepona mo nanauida elo wanamoto napu, dia.” ");
INSERT INTO soq_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Tane i Iesu sipoasane wanase, “Tatana, elo seda nanau karamba du atowe nomoio nai.” ");
INSERT INTO soq_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Mape Iesu i diene wanase, “E waadewaitena baiwa leuite duawo aitee aleu kadiwa anoa bedewelena nosene nambe aleno anoa eulene wandia ewaa.” ");
INSERT INTO soq_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ita i Iesu diena rua leulene alene duwe anoopa itu bolawe eulene ituleidio donsan. Aleu kadiwa me bedewe wandia nosene nambe alen. ");
INSERT INTO soq_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Iesu tawo Taire ene Saidon bedewainta doa Galili mampelene tawo Dekapolis bedewainta aleidie. ");
INSERT INTO soq_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ita apana isiwa sou asiwa potawa mai dodomana gagaloleipona banlene Iesu mampe wimoiena. Ita mo Iesu iririsaiena me witapa apana kerolala osowe itupio inalepia baiwa. ");
INSERT INTO soq_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ita Iesu apana asiwa potawa apana uara sape auweio bedeuwo banlene nata antone nambe eneiena. Mo nata sape eneio Iesu witapa uraupa kerolala asiwa bedewe noanamone witapa otawialene sesei witapa osowe tone epawa wirasan. ");
INSERT INTO soq_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ita Iesu pisiwane uba ewene nua ituniene kerolala diene wanase, “Ebata!” Aia ema ipawaida ema epe: Asi nasitana. ");
INSERT INTO soq_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Iesu epe wadio tauwadea os me asiwa nasintone inantono aia eten, tane do epawa rebarebaleidia euleno dodomana gagalolen. ");
INSERT INTO soq_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Mape Iesu apana sape auweia anaanamona mai ginasa ema eweiena benemawa wapue apana da diamopu, diaida. Iesu mo osoweosowe diamodio tane mo benemantoiena, mai epona rua, dia. ");
INSERT INTO soq_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ita mo uduudu mida benema sa eteiena memesaidantone waienase, “Iesu dewa eubuida os dewamodie. Me apana asiu potalala dewamodio asiu nasintoio etei, ita do epau rebarebaleidia eumodio dodomana gagalontoi.” ");
INSERT INTO soq_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Walama dawo apana uaraia Iesu asisuwa baiwa wimone auweiena. Ita mo nanausia di sape waimoio Iesu atenlene wawe alala apamono me mampe wimoieno diamone wanase, ");
INSERT INTO soq_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Apana ema ne do wainitano walama natadea dialen, tane nanau dia, ne nuapareuntedina. ");
INSERT INTO soq_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Naita mo nana nasasia ne di waaubamopo bolauwo antompe emau dubalepio etepu garigariidalepi, ipawa mo isiwa inta daumawa wimoiena.” ");
INSERT INTO soq_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Tane wawe alala nana baiwa ingugurantone Iesu waitarasane waienase, “No bola sawanaida bedewe wainitana, mai mida da nana debama naepe wadepie apana ema uaraia wanamopio napue pokamopi. Nana intawa uamo os winei, naepe wadata?” ");
INSERT INTO soq_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Mape Iesu mo waitaramone wanase, “E manlawo bured ambi os winei?” Mo me sipoasane waienase, “No mainimbo bured 7 os winei.” ");
INSERT INTO soq_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Tane Iesu apana auauwalala uaraia diamona dogo osowe aisintopue wampu. Ita me bured 7 wineia otene God auwasane ampuialene me wawe alala wanamon apana sa uaraia wanamopuo napua baiwa. Ita wawe alala Iesu diamona rua bured sa nanantone apana wanamoiena. ");
INSERT INTO soq_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Tane mo mampo mai bured os wineipe, dia, bouri kerakera nata os rua do wineie. Ita Iesu bouri sa otene God auwasane wawe alala diamona bouri sa do nanantopue apana wanamopu. ");
INSERT INTO soq_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Ita mo nana sa nanantoieno apana uduudu nane pokamon. Tane apana sape auweiena uaraia, 4000 rua. Mo nana nane pokamono moawa eiena wawe alala nana sa auwene posawa 7 bedewe aimoieno nope wimon. Mo nana diasaieno Iesu apana waaubamono bolauwo antoio ");
INSERT INTO soq_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","me wawe alala do waa bedewe odane nawane antone doa waiwa dawo Dalmanuta tawowa bedewe wimoiena. ");
INSERT INTO soq_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Parisi apanawa isiwa Iesu mampe wimone wawadiadiantoie. Ita wawadiadia sa bedewe mo insene waienase, “Me ginasa dewasapia baiwa waitarasate ewonta, me dewasapia rua, ba dia? Me dewasapio ewata, sa ipa atentata me God mukawa wadene nolaleide.” Mo epe wane Iesu dieiena ginasa dewasapio ewapu. ");
INSERT INTO soq_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Tane Iesu nuawa dabua mampe nuawa ituniene wanase, “Dima baiwa walama tauma apanawa ne ginasa dewasapo ewapua iririwanei? Ne ulaipa dialedina, apana ema ne mai ginasa da dewasapo ewapu, diaida!” ");
INSERT INTO soq_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Iesu epe wane mo emone ita wawe alala do waa bedewe odane nawane leuntone doa waiwa dawo antoie. ");
INSERT INTO soq_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Mo waa asiasi antoio wawe alala bured emone, tane dea os wadeiena inseiena. ");
INSERT INTO soq_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Mo nawane antoio Iesu wawe alala diamone wanase, “Parisi apanawa ita warere Erod mampo ewanadewaitana. Mo dewau kadiwa ipa nana kerauda ist parawa bedewe ituio bured uduudu sasanaleidia rua. Sa baiwa mo mampo ewonunadewae insaisala wadaaubala leununa!” ");
INSERT INTO soq_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Iesu wawe alala me gagalowa etane ipawaida banusaie muba eda gagalontoie waienase, “Dauwa Iesu no bured wadasiantena umanawa wade.” ");
INSERT INTO soq_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Dima mo muba waia Iesu atenlene baiwa me waitaramone badowa diamone wanase, “E inseilana bured wadasasia wilena umanawa ne wana, ba? Sa dia! Ambi epe inseilana? Mapo ita tauma dima ne wadina e mai atendewaitipona! Nuala ambi dewalene badolen? ");
INSERT INTO soq_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","E emala ita asila do, ambi ipa epe e mai dewa eweipona ita do gagalo mai eteipe ateitipona? E emala ita asila abo dia rua dewaitilana! E bured osowe nuabolaitile dima ne imanaida dewamona nuala koakoalen, ba? ");
INSERT INTO soq_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ne bured 5 ampuiamone apana 5000 wanamono nane pokamon ita e nana moawa eiena posawa ambi aimolano nope wimon?” Wawe alala Iesu sipoasane waienase, “No nana moawa eiena posawa 12 aimotano nope wimon.” ");
INSERT INTO soq_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Tane Iesu osowe waitaramone wanase, “Walamaipa ne bured 7 ampuiamone apana 4000 wanamono nane pokamon ita e nana moawa eiena posawa ambi aimolano nope wimon?” Ita mo me sipoasane waienase, “Walama sawo no nana eiena posawa 7 aimotano nope wimon.” ");
INSERT INTO soq_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Mape Iesu waitaramone wanase, “Ginasa ema dewamono ewalana, tane ambi e mai atendewaitipona wakoaitile wainilana?” ");
INSERT INTO soq_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Iesu wawe alala do nawane antone bola Betisaida bedewe wimoiena. Sape apana isiwa sou emawa potawa banlene Iesu mampe wimone iririsaiena me ibuwa wadapono inalepona baiwa. ");
INSERT INTO soq_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Tane me apana emawa potawa witapa wadene banlene bola ene nomone muba os nambe eneiena. Sape Iesu me emawa seseisan. Ita muriwa witapa me osowe itune waitarasane wanase, “E tauma sala eweiana, ba dia? Dima ewamoiana, wawo etapo?” ");
INSERT INTO soq_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Me leusaitulene sala ewamone wanase, “Ne apana laio ewamodina ewaewa abo ia tepantoipona rua, mai ewadewasamoipona, dia.” ");
INSERT INTO soq_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Me epe wano baiwa Iesu osowesane witapa apana sa emawa osowe itun. Ita me emawa euleno sala ewendewalen. ");
INSERT INTO soq_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Mape Iesu me wadiaubedie anaanasane wanase, “Mai leuite bolaawo sosoa wadeene wimoienawo aitaa, tane eba wanwanawo aitaa!” ");
INSERT INTO soq_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ita Iesu wawe alala do bola Betisaida ene bola debama Sisaria Pilipai mampenton. Sape mo bola kerakera bedeuwointa laio Iesu waitaramone wanase, “Dianeano etapo, apana ambi waia ne mida?” ");
INSERT INTO soq_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Mo sipoasane waienase, “Apana isiwa waia e ipa Ion Babatutu, isiwa waia e ipa peroweta Elaia, tane da waia e ipa peroweta dea da wien.” ");
INSERT INTO soq_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Iesu ema etene mo waitaramone wanase, “Tane e ne umanana ambi wailana ne mida?” Ita Pita me sipoasane wanase, “E ipa Keriso no Inawamba mida God sauawalena wien.” ");
INSERT INTO soq_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Pita Iesu wasabamowa wano etene me badowa wawe alala anaanamona dima Pita Iesu umanawa wana mai apana da benemamopuo etapu. ");
INSERT INTO soq_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Iesu ema aupe mo waeuwamone wanase, “God insaisawa ituna rua Apana Otopa poka debama etaidasapi, ita apana debamau, pirisi debamau, do anaana waeuwalala me dabuasapue epu. Ita mo me bosapu, tane walama natadeawo me bo bedewe enepiwisepi.” ");
INSERT INTO soq_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Iesu poka etepia umanawa wawe alala diadewasamono eteiena. Tane Pita ema etene nua pola wano Iesu banlene nata nambentone enane me wadabuasadie mai epe poka etepie bolepi, dia. ");
INSERT INTO soq_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Pita epe wadio Iesu leulene enene wawe alala ewamone mo do etapua baiwalene Pita diaidasane wanase, “Seitan, ne ene nambe aitaa! E dima insee waana mai God insaisawa mampe wape dianeapona, dia, tane apanaida insaisawa asiasi wae dianeana.” ");
INSERT INTO soq_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Iesu ema wane aupe apana uaraia sape laia apamono wimoieno ita wawe alala do diamone wanase, “Me mida ne warorona menasampa mai meba insaisawa wadepi, diaida. Tane dima uduudu nuawa teinedia dabuamopie emopituwapi. Ita meba korosiwa, sa ipa poka saiwa God ituna awanepie waroroneampa. ");
INSERT INTO soq_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Apana mida inawawa wadediitudedie meba os baiwaleidie wandi leidia, me inawawa rebasapie mai inaida donsapi, diaida! Tane me mida ne baina ita Gagalo euda baiwa inawawa nanaleidie itudi edia, me inaida donsapie wankasalepi. ");
INSERT INTO soq_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Naita apana da tawo manewa uduudu ita ewanuauwa daitada uduudu otamodie mampemodie boleidia dima euwa tawo ewanuauwa sa bedewe donsapie wadepi? ");
INSERT INTO soq_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Me tawo ewanuauwa sa do awanamopie alepie nitu sa mampe inawawa gimaralepie leusapie wadepi, ba? Di diaida! ");
INSERT INTO soq_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Me mida walama tauma apanawa kadi daitada dewalala mampo ne malanaleidia ita do aiana malawaleidia, Apana Otopa leulepie Mamba sapawa do ita ensel kakaibu do wisepie me apana sa do malawalepi.” ");
INSERT INTO soq_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Tane Iesu do diamone wanase, “Ne ulaipa dialedina, apana isiwa e bedelawo mape eneia God gonaawa mukawa do wisepio ewapu. Mo mai ewasasia waimompe di bontopu, dia.” ");
INSERT INTO soq_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Iesu epe wano waimoie walama 6 diantono me Pita, Iems ita Ion os banlamone wadi daumawa osowe odane antoiena. Ita sape mo muba waimoio Iesu inainamba leulene sapaidaleno eweiena. ");
INSERT INTO soq_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ita me garawa sapaida wane kibokiboraidaleidie, tane sapawa sa mai mapo ita tauma apana da ewapona, diaida. ");
INSERT INTO soq_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ita wawe alala sape waine eweio Elaia Moses nata segantone Iesu do gagalontoio ewamoiena. ");
INSERT INTO soq_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Mo dewa sa pokawaaida eweie baiwa Pita Iesu diene wanase, “Debamamba, ide dewantene bola ema euda bedewe winen! No ape natadea wadamote wainenta, da e baia, da Moses baiwa ita da Elaia baiwa.” ");
INSERT INTO soq_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Tane Pita mai dima atenleipe gagaloleipe, dia, me sosowa nata do insaisau rebarebaleno koakoantone memesaidantoie. ");
INSERT INTO soq_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Mo memesantone eneio giou wisene tauboiamodio aia giou bedewe segalene wanase, “Ema ipa ne nuawadawadana Otopaida, me aiawa etanadewaitana!” ");
INSERT INTO soq_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Aia ema dialeidio wawe alala pisiwane mai mida da ewapona, tane Iesu os mo do enakasantoiena. ");
INSERT INTO soq_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Mo wadiwae iane antoie Iesu anaanamone wanase, “Dima wadiwa ewalana mai apana da benemamono etapu, dia. Tane Apana Otopa bo bedewe enepiwisepio tauma benemaitano apana atentopu.” ");
INSERT INTO soq_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Dima Iesu wana mo ruawantone dima eweiena muba os mampo winakasalen. Tane gagalowa da wana mai atentopona baiwa muba gagalontoie waiase, “No inseitana me mai bolepi, dia, tane dima baiwa bo bedewe enawisawa gagalowa wade?” ");
INSERT INTO soq_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ita mo Iesu waitarasane waienase, “Dima baiwa anaana waeuwalala waiase, ‘Peroweta da ewaewa Elaia rua bautalepie wisepio muriwa Keriso mida God saualena wisepi?’” ");
INSERT INTO soq_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ita Iesu mo sipoamone wanase, “Peroweta da ewaewawa Elaia rua bauta wisepie ita nitu uduudu aupo teadewasamopie imaamopi. Tane buka bedewe girumalena Apana Otopa poka debama etaidasampo apana uduudu dabuasapue epu. E insenadewaitana, buka bedewe di girumalene ituno winede, ba? ");
INSERT INTO soq_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Anaana waeuwalala waia peroweta da ewaewa Elaia rua bautalepie wisepi. Tane ne dialedina me bautalene wiseno tane apana mai wadape mamposapona, dia. Tane me dabuasane insaisau rua dewasane kadisaiena. Sa ipa buka bedewe me umanawa wana rua me mampe dewantoiena.” ");
INSERT INTO soq_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Iesu, Pita, Iems ita Ion iane wimone mo sosou apana uaraia bedeuwo eneie ita anaana waeuwalala do badowa gagalontoio ewamoiena. ");
INSERT INTO soq_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Tane apana sa Iesu ewane nuau euleno me mampe weuwane antone auwasaiena. ");
INSERT INTO soq_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ita me mo waitaramone wanase, “Edima osowe gagaloitile diadiaitilana?” ");
INSERT INTO soq_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Mo uduudu sape eneia bedeuwo sou dea Iesu sipoasane wanase, “Debamamba, aleu kadiwa ne otona bedewe wandio aiawa mai waipona, moawa potawa os wandia banlene e manawo winepona insene winen. ");
INSERT INTO soq_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Tane e mape dia, sa baiwa e waawo alala diamona aleu kadiwa otona bedewe wandia tanapono nosepona. Tane mo mai dewasapona rua, dia. Ne otona ema epe dewaleide: Walama isiwa me wandia euda. Tane walama da bedewe aleu kadiwa otona bedewelena dewasadio dogo osowe omedie leusaituleidie guriboboleide. Ita moawe gusau wimoie, moawa totontoie etepa badoleidituwadio winede.” ");
INSERT INTO soq_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Iesu apana sa dima wadia etene mo uaraia sape auweia diamone wanase, “E sumanai dia apanawa wainilana! Mapo os e ne do wankasantene dialedino os wainilee, tane mai sumanaitapona, dia! E baila ne poka etaidasadina. Oto banlene mainawo wina!” ");
INSERT INTO soq_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ita mo oto banlene Iesu mampe wimone mampesaiena. Tane aleu kadiwa oto bedewe wandia Iesu ewene oto dewasano uwauwaleidie dogo osowe omene leusaituleidie moawe gusau wimoie. ");
INSERT INTO soq_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Mape Iesu oto mamba waitarasane wanase, “Me walama dainea kerowa uwaalene epe dewaleide?” Me sipoasane wanase, “Me keraudape ita tauma epe dewaleide. ");
INSERT INTO soq_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Aleu kadiwa bedewelena otona boidasaipona baiwaleidie kainokaino ia iilala bedewe do esa bedewe aubedio aleide. Ita me dewa ema bedewe pokaida etedie. Naita inta da manawo winompa no nuaparembaite saunea!” ");
INSERT INTO soq_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ita Iesu me diene wanase, “E dima baiwa waianase, ‘Naita inta da manawo winompa nuaparembaite saunea?’ Ne dewasapaa rua os, tane e sumanaitiana, ba dia? Apana mida sumanailempa me rua os dewa uduudu dewamompo ipawanantompa, mai dia.” ");
INSERT INTO soq_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Oto mamba aia ema etene nuawa pola wano Iesu diene wanase, “Ne sumanaintedina, tane insakoa dewawa do mainawoleide. E sauneawo insakoana sa dialepio sumanaina debamalepi.” ");
INSERT INTO soq_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ita mape apana uara mampontone ieio Iesu ewamone ita aleu kadiwa oto sa dewasadio asiwa ita moawa potaleidia badowa diene wanase, “Aleu kadiwa, oto ee noe nambe aitaa! Mai walama da leuite oto bedeweite kadisaa!” ");
INSERT INTO soq_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Mape aleu kadiwa rasa debama wane oto dewasano etepa uwauwaboboleidio nosene nambe alen. Ita oto etepa dainasane di winedio apana ewane waienase, “Oto boidalen!” ");
INSERT INTO soq_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Tane Iesu oto witapa wadene sausano enenwisen. ");
INSERT INTO soq_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ema aupe Iesu du bedewe odene aleno me wawe alala wimone muba os waimoie bedewe me waitarasaiena, “Dima baiwa aleu kadiwa oto sa bedewelena no mai tanapona rua?” ");
INSERT INTO soq_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ita Iesu mo sipoamone wanase, “E raupari os mampe aleu kadiwa ema rua tanamono nomopue nambe antopu, mai dima da, dia.” ");
INSERT INTO soq_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Iesu wawe alala do bola sa ene Galili bedewainta antoie me mai menasapona apana da atenlepi me naepe wandi leidie. ");
INSERT INTO soq_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Me menasadia wawe alala os do leumpe mo waeuwadewasamompa. Ita mo diamone wanase, “Mo Apana Otopa nanantopue apana witaposapuo insaisau rua me mampe dewasapue bosapu. Tane walama natadeawo me bo bedewe enepiwisepie waimpa.” ");
INSERT INTO soq_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Iesu mo epe diamodio mai atentopona me dima waeuwaleidie diamodie. Tane mo santone mai waitarasapona, eiena. ");
INSERT INTO soq_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ita mo antoie Kapeanaumwa wimone du bedewe odeio Iesu wawe alala waitaramone wanase, “Ieite intasino e dima gagalowaitile diadiaitile?” ");
INSERT INTO soq_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Tane mo malantone mai sipoasapona rua, ipawa mo bedeuwo mida debamawaida gagalowa waie diadiantoie ieie. ");
INSERT INTO soq_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Iesu du bedewe waine wawe alala 12 diamono mampe wimone waimoieno me diamone wanase, “Mida apana bedeuwo ebowa debamalepona menasampa me sosowa uduudu atouwolempe simbiaulempa.” ");
INSERT INTO soq_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Me epe wane oto kerauda wadene siwa atowesane wawe alala nambunepe enene diamone wanase, ");
INSERT INTO soq_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Mida sowa ebowasiawaia oto kerauda ema rua ne ebonawo wadedie mampesadie simbiasadia, me ipa ne wadanedie mampesadie simbianede. Ita mida ne wadanedie mampesadie simbianedia me Mamamba ne waaubanena do wadedie mampesadie simbiasade.” ");
INSERT INTO soq_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ema aupe Ion Iesu diene wanase, “Debamamba, no apana da e eboawo aleu kadiu tanamodio ewate anaanasatana me nola sa epi, ipawa me mai no bedembolepono do nolantipona apanawa, dia.” ");
INSERT INTO soq_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Tane Iesu me sipoasane wanase, “Me nola sa dewasadia mai anaanasana, dia, ipawa mida ne ebonawo ginasa dewamodia, me mai aupeaupe ne wawakadikadinepi, dia. ");
INSERT INTO soq_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Mida no mai adianananeipona me ipa no baimba wande. ");
INSERT INTO soq_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ne ulaipa dialedina, mida ne ebonawo simbialeidie esa enaledia ipawa e ne mainawoa, me unewa wadepi, mai dia!” ");
INSERT INTO soq_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Apana mida seda kerakera bedeuwo dea ne mainawo sumanaileidia dewasapio sumanaiwa dialepia, me ipa matangelawa debamaia donsapi. Epe segalepia sawa eulen ita apana sa gadompawe seu debama taupadoe owa bedewe aubepono alepona. ");
INSERT INTO soq_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Naita e witaa banlaepio kadiwa dewasaa, witaa sa toapundepi. E witaa dea os do inawinakasalawo odaa, sa ide, tane mai ide witaa nata do bola kadiwa ia iilalawo aitaa! ");
INSERT INTO soq_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Naita e waa banlaepio kadi dewasaa toapundepi. E waa dea os do inawinakasalawo odaa, sa ide, tane mai ide e waa nata do ia iilalawo aitaa! ");
INSERT INTO soq_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Naita e emaa banlaepio kadi dewasaa wadaaubea. E emaa dea os do God gonaawa bedewe odaa, sa ide, tane mai ide e emaa nata do bola kadiwaida bedewe aubaepu. Bola sa umanawa buka bedewe epe wadi wadiase, ");
INSERT INTO soq_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‘Sape motamota mo namoia mai bobontopu, tane ia mo imodia mai bolepi.’ ");
INSERT INTO soq_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ne dima wadina e ruawaitana, ipawa ia idia apana uduudu eueuwa osowe teamopie wadaetamopio kadiwa ba euda donsapu, mai dia. Ia iilala sa aideba pulo moiawa eusadia rua apana isiwa eumopi, tane isiwa kadimopi. ");
INSERT INTO soq_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Aideba ipa euda, tane naita daasialepia ambi dewasawo osowe daa wapi? Walama uduudu aideba e bedelawo winompa ita nuala euda os wanlempa sosola deadea do.” ");
INSERT INTO soq_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ema aupe Iesu bola sa ene Iudia tawowa bedewe aleidie esa Ioadan nawene waiwa dawo wandie. Iesu naepe wisedio apana uara auweia rua deawaa esa Ioadan tampe mo uara wimone auweieno me dewawa rua waeuwamodie. ");
INSERT INTO soq_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ita Parisi apanawa isiwa Iesu gagalo wapikadisapi, ba dima dewasapikadisapio ewapua baiwa wimone sape waimoie waitara badowa diane waienase, “E no dianewo etato no anaanamba ambi wade, apana nainaibu bedewe kadilempo manainapa dabuasapie epia intawa da winede, ba dia?” ");
INSERT INTO soq_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Tane Iesu waitara mampe sipoamone wanase, “E anaana dainea Moses enaleno ateitene wainilana?” ");
INSERT INTO soq_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ita mo sipoasane waienase, “No Moses anaanawa nenena ema epe wade, ‘Apana manainapa epia menasampa me manainapa epia gagalowa girumalepie sowa wanepie wapiaubepio alepi bolawe.’” ");
INSERT INTO soq_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Mape Iesu mo waeuwadewasamone wanase, “E nuala badoidaleno baiwa Moses anaana ema epe girumalene ituno e ruawaitilana. ");
INSERT INTO soq_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Tane God bumpeido uba ita tawo dewasanawo me mai epe insepona, dia. Me bumpeido apana mona ita i auwepue waimompaa baiwa dewamone teamon, mai nambenambe waimompaa baiwa teamopona. ");
INSERT INTO soq_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","8","God bumpeido insaisawa ituna rua apana mona mamba ita inawa emopie i mampelepi. Ita mo nata deaidantopue ete dea waimompa. Sa ipa buka bedewe girumalena rua. ");
INSERT INTO soq_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","God nainai bedewe apana mona ita i deaidamono waimoi, sa baiwa mo mai empuempuntopue nata segantopua intawa da wineipona, diaida!” ");
INSERT INTO soq_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Gagalo ema aupe Iesu wawe alala do du bedewe odane waimoie mo nainai gagalowa eteiena waitarawasaiena. ");
INSERT INTO soq_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ita me diadewasamone wanase, “Apana mida manainapa dabuasadie edie i da naisedia, me ipa nina dewawa dewasade. ");
INSERT INTO soq_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Deawaa, i badawa dabuasadie edie apana da naisedia, me ipa nina dewawa dewasade.” ");
INSERT INTO soq_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Apana isiwa otooto kerakera banlamone Iesu mampe wimoiena me witapa mo osouwo itupie sau euda wanamopia baiwa. Wawe alala mo epe dewantoio ewamone apana onau wane bodamoiena. ");
INSERT INTO soq_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Iesu mo wadabuamoio ewamone nuawa kadileno wawe alala diamone wanase, “Otooto kerakera emono ne mainawo wimpu, mai enabodamona, ipawa God gonaawa ipa otooto kerakera ema ruau mampoa. ");
INSERT INTO soq_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ne ulaipa dialedina, me mida oto kerauda rua nuawa wadaaubala me God gonaawa bedewe odepia rua. Tane me mida mai oto kerauda ruawalepia me mai God gonaawa bedewe odepia rua, diaida.” ");
INSERT INTO soq_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Iesu epe wane otooto kerakera otamone siwa atowemone deadea osouwo witapa itune sau euda wanamodie. ");
INSERT INTO soq_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Iesu mo sau euda osouwo itune diasane a baiwaleidio apana dea tauwadea Iesu mampe wisene me danawe imimpa emmisilene waitarasane wanase, “Debamamba, e euda apanawa, dianeawo atenteapa ne dima dewasape inawinakasala donsapa?” ");
INSERT INTO soq_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Iesu sipoasane wanase, “E dima baiwa ne euda apanawa dianeiana? God meba os euda, mai mida da, dia. ");
INSERT INTO soq_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","E anaana wineia ateitena ruauitona, sa ipa: ‘Mai soa da bosaa, mai ninaitaa, mai poitaa, mai kutuntaa, mai lagaitaa, mamaa ita inaa do oniadewasamone aiau ruauitona.’” ");
INSERT INTO soq_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ita apana sa Iesu sipoasane wanase, “Debamamba, ne oto keraudanawo ita tauma anaana sa uduudu ruauntene dewamonatuwan.” ");
INSERT INTO soq_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Me epe wadio Iesu etene nuawadawadasane diene wanase, “E dea os eanosidena dewasaa: Puraiwaa uduudu manawo wineia gimaramoatue manewa wadee nuaparelala wanamowo uboo e mauraa debamalepi. Ema dewasae aupe wine ne waroronea.” ");
INSERT INTO soq_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Me Iesu epe dieno etene puraiwawa uaraia osowe mauraleidie wandia insamone inainamba aisidene nuapareidaleno ene alen. ");
INSERT INTO soq_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Me ene aleidio Iesu wawe alala ewamone diamone wanase, “Maura apanawa God gonaawa bedewe odaodawa badowaida!” ");
INSERT INTO soq_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Mo Iesu epe wano etane memesaidanton. Tane Iesu osowesane diamone wanase, “Obaina, God gonaawa bedewe odaodawa badowaida! ");
INSERT INTO soq_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Pue debama ebowa Kamel selau nagawa bedewe mai odepia rua, diaida. Deawaa, maura apanawa insaisawa puraiwawa osowe itudie wandia God gonaawa bedewe odaodawa badokadilen!” ");
INSERT INTO soq_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Wawe alala inseia puraiwa apanawa God sauwa euda donsaie baiwa maurantoie waimoia God gonaawa bedewe odapua rua. Tane mo Iesu epe wano etane inguguraidantone Iesu diene waienase, “Ema ambi, apana da inalepia intawa da winede, ba dia?” ");
INSERT INTO soq_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ita Iesu ewamone diadewasamone wanase, “Apana mampo mai inantopona intawa da wineipona, dia, tane God mampe inta wadaaubala winede, ipawa me dewa uduudu dewasapia rua.” ");
INSERT INTO soq_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Mape Pita Iesu mampe wane wanase, “No nitu uduudu emotatue e waroroeite do leitana, tauma no dima donsata?” ");
INSERT INTO soq_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Iesu sipoasane wanase, “Ne ulaipa dialedina, mida duwa, ba nonopa, ba weaweanapa, ba inawa, ba mamba, ba obampa, ba iraiwa emona ne baina ba Gagalo euda baiwa, me wandi leidia bedewe uaraia osoweosowe mampelempo wadompa, mai bauta wandie emona rua. Sa ipa duwa, nonopa, weaweanapa, inawa, obampa ita iraiwa mampelempatuwampo osowe waimpa. Tane me poka apana mampo do etompe waimpa, mai dia. Ita walama iedia wisepio me inawinakasala donsapi. ");
INSERT INTO soq_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ewane, mo mida Gagalo euda muriwa os eteie sumanaintoia God gonaawa bedewe bautantopue odapu. Tane mo mida Gagalo euda bautantone etane atentoiena muriwa God gonaawa bedewe odapu.” ");
INSERT INTO soq_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ema aupe Iesu wawe alala do Ierusalemwa odane antoie. Tane into Iesu bautalene aleidio wawe alala nuau polaida wadio wawe odeie. Ita warorowa da mo wauwo santoie ieie. Tane mo antoio Iesu wawe alala 12 os diamone mampemone dima me mampe segalepia baiwaleidia umanawa diadewasamodie. ");
INSERT INTO soq_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ita me mo diamone wanase, “No odate antitana Ierusalemwa, sape Apana Otopa wadapue pirisi debamau ita anaana waeuwalala mamposapuo insaisau rua me mampe dewasapu. Mo me kotusapue bowa sauawa wapue Rom gabemaniwa mamposapu. ");
INSERT INTO soq_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Mo me wasi kadiwa daitada wampe diompe seseisampe ita tai gedaragedaraua mampe epompe ita bosapu. Ita walama natadeawo me bo bedewe enepiwisepi.” ");
INSERT INTO soq_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Mape Sebedi obampa Iems Ion nata Iesu mampe wimone diane waienase, “Debamamba, no dima inseite menaidanedia e dieeto dewasaa rua, ba dia?” ");
INSERT INTO soq_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ita Iesu waitaramone wanase, “E dima menaledia ne baila dewasapa?” ");
INSERT INTO soq_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Mo leusane waienase, “No menanedia e uboo sapaida do kolaiwataawo wane e wawo no tanawo wanta, da witaa on deneuwe, ita da sen deneuwe.” ");
INSERT INTO soq_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ita Iesu mo diamone wanase, “E mai dima ateitipe osowe iriritipona! E ide rua dima ne redunawo winedia napino e do nana? Ne babatutuntepina rua e ide rua babatutuitana?” ");
INSERT INTO soq_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Mo leusane waienase, “No rua os dewasata!” Ita Iesu mo diamone wanase, “Poka etaetala reduwa napina rua e ideita nane poka etana. Ita poka saiwa osonawo iompo babatutuntepina rua poka saiwa ideita e osolawo iompo babatutuitana. ");
INSERT INTO soq_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Mida witana on ita sen deneuwe wampua mukawa mai mainawo wineipona sonabalepo waina, dia. God bola sa mo mida baibu imaasana os wanamopio osowe wampu.” ");
INSERT INTO soq_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Tane wawe alala 10 ema etane nuau kadilen Iems Ion nata mampo. ");
INSERT INTO soq_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Iesu mo uduudu apamone auwamone wanase, “Mo mida gabeman mukawa wadeia kasawoga mampe apana banlamoio mo ruauntoie dewa uduudu dewamoituwade. ");
INSERT INTO soq_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Tane e mai epe dewaitana, dia! Mida e bedelawo debamalepona menasampa me sosowa uduudu simbiaulempe nolalempa. ");
INSERT INTO soq_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ita mida e bedelawo ebowa debamalepona menasampa me sosowa uduudu atouwolempe simbiaulempa. ");
INSERT INTO soq_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","E ema insena: Apana Otopa mai ebowa debama wadepio apana me simbiasapua baiwa wisepona, dia. Me wisena apana simbiamopie inawawa itupi epie apana uara kadi bedewe malesamopie inamopi.” ");
INSERT INTO soq_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Iesu wawe alala do Ierusalemwa antoie into Ieriko bedewe wimone, bola sa eio apana uaraia wauwo waroromone antoie. Tane bola sa tampe Timias otopa emawa potawa ebowa Batimias inta waiwe iririleidie wandie. ");
INSERT INTO soq_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Me sape wandie benema etena, sa ipa Nasaret Iesuwa iede. Sa baiwa me mukaidalene wane wanase, “Iesu, Dawid Otopa, nuaparenaite saunea!” ");
INSERT INTO soq_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Apana uara sape me etane diaidasane wanadabuasaiena dainalepi. Tane mo dima waia etendabue osowe mukama wane wanase, “Dawid Otopa, nuaparenaite saunea!” ");
INSERT INTO soq_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ita Iesu me sau baiwa wadio etene amuwa enene apana diamone wanase, “Me apasano mainawo wimpi.” Mo Iesu wana rua emawa potawa inta waiwe wandia apasane waienase, “Nuaeuwa mampe enawie winea, Iesu e umanaa wade!” ");
INSERT INTO soq_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Me epe dieieno etene nuawa eudewadewaleno tauwadea enenwisene garawa onapea wadenaubene ene alene Iesu mampe wisen. ");
INSERT INTO soq_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ita Iesu me waitarasane wanase, “Dima e manawo dewasapaa meneede?” Apana emawa potawa sipoasane wanase, “Debamamba, ne sala ewapaa menanedio iririwantedina!” ");
INSERT INTO soq_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Mape Iesu me diene wanase, “Aitaa, eba sumanaia inaen!” Me epe wadio Batimias emawa tauwadea os euleno sala ewene Iesu warorosano do antoiena. ");
INSERT INTO soq_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Mo Ierusalemwa antoie bola Betipage ita Betani mampentone wadi Olib tampe wimone, sape Iesu wawe alala nata waaubamone diamone wanase, ");
INSERT INTO soq_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“E bautaitane bola nainimbanepe winediawo aitana. E bola sawo wilenune pue donki sanaa mai apana osowe odaodalala taunadodeieno enedia ewana. Ita lotonaaubene wadane banlene mainawo winlena. ");
INSERT INTO soq_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Naita apana da donki lotonuno ewalepie waitaralepie wapiase, ‘E donki ambi dewasana baiwa lotoilana?’ Me diane wanase, ‘Tatamba menasadia baiwa donki ema lotoite wadeitana. Nola kerauda dialepio leusapio wimpi.’” ");
INSERT INTO soq_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Iesu epe diamona rua mo donki awa anton. Ita mo bola sawo wimone inta waiwe du enedia moape donki taunadodeieno enedia eweiena. ");
INSERT INTO soq_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Mo lotoio apana isiwa sape eneia ewamone waitaramone waienase, “E donki ambi dewasana baiwa lotoilana?” ");
INSERT INTO soq_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Mo nata Iesu diamona rua apana sa diamoieno etane emoieno donki lotone banlene antoiena. ");
INSERT INTO soq_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ita mo Iesu mampe wimone garau onapea otawiamone pue osowe teamoieno Iesu odene osowe wain. ");
INSERT INTO soq_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Tane apana uara sape mo do laia garau onapea inta osowe abumoie. Ita sosou da notonkela asiwa iraibu bedewe tomoiena inta osowe teamone antoieno osowainta Iesu donki osowe waine aleidie. ");
INSERT INTO soq_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Apana uara Iesu danawe ita adiwe enane antoia mukaidantoie waie waiase, “Osana! Me mida God ebowe iedia no wadaposisate ionosata! ");
INSERT INTO soq_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","God gonaawa mapoido mamamba Dawid mampe sauawalena tauma ipawanalepia baiwaleidia wadaposisata! Osana, God ionoidoa wadaposisate debamasata!” ");
INSERT INTO soq_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Mo uaraia Iesu epe auwasaie wadaposisaio Ierusalemwa odene aleidie. Ita me God duwa bedewe odene dewa uduudu apana sape dewamoia ewamodie leidie. Tane rawileidio Iesu wawe alala 12 do leuntone bola Betani bedewe antoiena. ");
INSERT INTO soq_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Imonemba mo Betani ene Ierusalemwa antoio into Iesu omanaton. ");
INSERT INTO soq_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Me emawa aubene karakai iawa asiwa uduudulena ewene mampe alen korou ewapona baiwa. Tane me karakai iawa mampelene mai ipawa da ewapona, asiwa os ewaewawa euleidie, ipawa naupona walamawaida mai wisepona. ");
INSERT INTO soq_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ita Iesu karakai iawa mampe wandabuasane wanase, “Tauma ita ando e mai nauno apana ipaa nampa, diaida!” Tane Iesu karakai iawa wadidabuasadio wawe alala etane do antoiena. ");
INSERT INTO soq_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ita mo Ierusalemwa wimone Iesu God duwa bedewe odene leidie mo uduudu sape gimarantoie waimoie laia ewamone nuawa kadiidaleno tanamono nomone anton. Me mane leusaia apanawa watau ita do nene gimaralala watau memaaubamon. ");
INSERT INTO soq_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ita me apana uduudu anaanamona mai God duwa bedewe nitu da gimaralala otamompa ba awanamompe do odompa. ");
INSERT INTO soq_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Dewa sa uduudu me intawa gudulene apana waeuwadewasamone wanase, “Buka bedewe ema epe girumalena winede, wadi wadiase, ‘Ne duna ipa uwa daitada apanawa rauparintompaa duwa.’ Tane e dewasalana poiwaa auwempaa dubu wanalen.” ");
INSERT INTO soq_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Pirisi debamau ita anaana waeuwalala aia ema etane nuau kadileno inta banusaie Iesu bosapua baiwa. Apana uduudu Iesu waeuwawa nuau wadeno baiwa pirisi debamau ita anaana waeuwalala nuau saleno me bosapona insaisawa wadeie. ");
INSERT INTO soq_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ita rawileidio Iesu wawe alala do Ierusalem ene bola waimoiawo antoiena. ");
INSERT INTO soq_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Mo bola waimoiawo ituntone tadinaida enanawimone antoie into karakai iawa Iesu wandabuasana waapa do tonalentue enedia eweiena. ");
INSERT INTO soq_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Tane Pita karakai iawa sa ewene Iesu ia sa wandabuasana insene wanase, “Debamamba, ia sisi e wadabuasaana tonalentue enede.” ");
INSERT INTO soq_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Mape Iesu wawe alala diadewasamone wanase, “E sumanaila God mampe itununa. ");
INSERT INTO soq_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ne ulaipa dialedina, e nuala bedewe mai insakoaitonuna tane sumanaiidaitonune bedewe wadi emanta diane wanase, ‘Enawie aite owa bedewe aubaubaitaa!’ Dima e sumanaiwaitile wailana God e baila dewasapio segalepi, mai dia. ");
INSERT INTO soq_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Sa baiwa e dewa uduudu raupari bedewe iririwaitonune sumanaitana ewaewawa abo dima iririwaitilana e aitamana wadapona. E epe sumanaitonuna dewa uduudu iririwaitilana God e enalepituwapio wadana. ");
INSERT INTO soq_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","E raupari baiwaitonune naita sosola kadileiena insaisawa manlawo winompa kadiu insadabuamona. Muriwa Mamala uboo wandia mampe rauparitano e kadila insadabuamopi.” ");
INSERT INTO soq_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ema aupe mo osowe Ierusalemwa antone wimoiena. Sape Iesu God duwa bedewe odene leidio pirisi debamau, anaana waeuwalala ita mo eiau isiwa me mampe wimone waitarasane waienase, ");
INSERT INTO soq_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“E mukaa dainea mampe dewa ema dewamoiana? Mida eneen?” ");
INSERT INTO soq_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ita Iesu mo sipoamone wanase, “Ne waitara dea dialepo sipoaneano muriwa ne dialepa ne mukana na wadane dewa ema dewamodina. ");
INSERT INTO soq_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","E dianeano etapo, Ion mukawa na wadene nolaleidie? Me God mukawa mampe apana babatutumodie ba apanaida mukawa mampe?” ");
INSERT INTO soq_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Iesu epe wane diamono muba inta banusaie ambi gagalontope wapona baiwa. Ita muba gagalontone waienase, “No ambi wata? Naita no wataase, ‘Ion God mukawa mampe nolaleidie apana babatutumodie,’ Iesu dianepi wapiase, ‘Naita epeewo, e dima baiwa me mai sumanaiwaitapona?’ ");
INSERT INTO soq_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Tane me apanaida mukawa wadene nolaleidia wataa mai rua, ipawa apana uduudu sumanaintone atentoiena Ion ipa peroweta God wanaubena.” ");
INSERT INTO soq_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ita mo apana nuau kadisapua sawantone Iesu lagasane waienase, “No Ion mukawa na wadene apana babatutumodia mai atentepona, dia!” Mo epe waieno Iesu diamone wanase, “E ne waitarana sipoa mai dianeapadewaitapona, sa baiwa ne mai dialepa mukana na wadane dewa ema dewamodina.” ");
INSERT INTO soq_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Iesu aia ema wano dialeno aupe gagalo babawa mampe mo mampo gagaloleidie wane wanase, “Apana dea wain irailene gonaalen. Ita me wain gadawa empidodepia baiwa don ton. Do iraiwa oniempaa duwa wadene diasane wain iraiwa oniepua apanawa witaposane diamona odawa moawa ando wanapu. Ita ene nowa dawo alen. ");
INSERT INTO soq_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Wain aiaisawa walamawa wiseno irai apanawaida nolawa dewala dea bauta wanauben alepie me irai onieia apanawa mampo mebaa moawa wadepia baiwa. ");
INSERT INTO soq_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Me alene mo mampo wiseno tane mai wanapona, dia, ita me wadanaitue epaepabobosane taneieno di alen. ");
INSERT INTO soq_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ema aupe irai apanawaida nolawa dewala da wanaubeno alene mampo wiseno uwawa epaepabobosaiena. Ita mo mala dewawa rebarebaida mampe dewasane malasaiena. ");
INSERT INTO soq_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Tauma me nolawa dewala da wanaubeno alene mampo wiseno epanaboleiena. Mo epe dewantoieno aupe irai apanawaida nolawa dewalala uara waaubamono onionia apanawa mampo antoiena. Mo isiwa epaepabobomone tanamoieno anton, ita isiwa epaboiamoiena. ");
INSERT INTO soq_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Irai apanawaida nolawa dewalala uduudu waaubamontuwan, mai da wampona, dia. Tane dea os wandia, sa ipa me nuawadawada otopaida, newa osowe wanauben iraiwa onieia apanawa mampo. Me wadiaubedie insenase, ‘Ne otonaida mo mampo wisepio wadapue mamposapue oniepudewantopu, mai kadisapu, dia.’ ");
INSERT INTO soq_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Me ema epe insedie, tane me otopaida mo mampo wiseno muba gagalontone waienase, ‘Tauma irai ema apanawaida otopa wisen. Ane, me wadataitue bosate, aupe dima uduudu me mampea no nubaamba wanalepio taupakawantata.’ ");
INSERT INTO soq_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Dima mo waiena ruawantone antone irai apanawa otopaida wadanaitue epanaboleiena. Ita wain iraiwa gonaawa adiwe aubeieno nosene winen. ");
INSERT INTO soq_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","E tauma ambi inseilana irai apanawaida ema segalena mampe dima dewasapi? Ne dialedina, me wisepie iraiwa onieia apanawa bomopitue aupe wain iraiwa oniempaa apanawa da witaposapio oniempa. ");
INSERT INTO soq_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","E buka bedewe giruma ema wisiaitene ewale ateiten, ba dia? Ema epe wadi wadiase, ‘Du wadawadala apanawa seu dea ewanadabue eiena, mai menamopona, dia. Tane seu sa ewadabuasaia eudidalene du awanediposidede. ");
INSERT INTO soq_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Tane ema ipa Tatamba God insaisawa rua dewasano segalen, mai di segalepona, dia. Ita insaisa sa me dewasana ewaewawa eudidalen no mainimbo.’” ");
INSERT INTO soq_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Pirisi debamau, anaana waeuwalala ita mo eiau gagalo babawa ema etane atentoie Iesu moida wawumone gagalolen, mo me dabuasaia baiwa. Ema bedewe mo inta banuntoiena Iesu wadapaitue kotusapona baiwa. Tane mo apana uaraia sape eneie Iesu adiwentoia sauntone ene di antoiena, mai me wadapaitudepona, dia. ");
INSERT INTO soq_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Walama dawo Iuswa eiau, Parisi isiwa ita Erod sosowa isiwa do waaubamoiena Iesu mampe antopu. Mo menamodia mo antopue laga mampe Iesu waitarasampo me wapikadisapio wadapua baiwa. ");
INSERT INTO soq_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","15","Mo me mampe wimone diane waienase, “Debamamba, no atenten e apana dodomanaida. E manawo apana debamau ita ebousiawaia deawaa os. E mai mida da sawaitipe mo dima etaetawa menamodia rua asiasi waeuwaitipona, dia, tane e God insaisawa rua ulaipa os waeuwaitiana. E ambi inseiana, ide rua no Rom gabemaniwa mampe takis manewa ituta, ba dia?” Tane Iesu mo laga mampe waitarasaia atenlene sipoamone wanase, “E dima baiwa laga mampe waitaraneilana? Ne wapakadisapo wadaneana menalede, ba? Mane nepa wadane wino ewapo.” ");
INSERT INTO soq_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Mo diamona rua mane nepa wadane mampe wimoieno ewene diamone wanase, “Ewana, ema mida namba ita mida ebowa mane ema osowe winei?” Ita mo leusane waienase, “Rom gabemaniwa ionoidoa namba ita ebowa winei.” ");
INSERT INTO soq_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Mape Iesu diamone wanase, “Dima Rom gabemaniwa mampea gabeman wanana, tane dima God mampea God wanana.” Mo Iesu gagalowa wandewaleno etane memesanton. ");
INSERT INTO soq_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ema aupe Sadusi apanawa waitara do Iesu mampe wimoiena. Mo sumanaintoie inseiase apana bolala ando mai bo bedewe enapuwimopue waimompa, dia. ");
INSERT INTO soq_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Mo Iesu mampe wimone waienase, “Debamamba, no anaanamba Moses ema epe girumalene ituno winede: Apana mona nainaila obampasiawaia bolepio aupe apana sa wambaida tatawa obupa naisepie otootolepi tatawa baiwa. No menanedia anaana sa ipawa atenidantata. Sa baiwa no duduna da dieeto etee waeuwanewo atentata. ");
INSERT INTO soq_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","No dudunamba ema epe: Apana wanwamba 6 do bolauwo waimoie. Tautua nainailene obampasiawaia bolen. ");
INSERT INTO soq_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ita tautua wawea tatawa obupa naisene obampasiawaia bolen. Tane wambu natadeawa mampe deawaa segalen, me tatawa obupa naisene obampasiawaia bolen. ");
INSERT INTO soq_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ita wanwambu ompu epe os dewantontuwan, mo uduudu obu sa naisene obampusiawaia bonton. Ita ompa osowe obu sa do bolen. ");
INSERT INTO soq_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","I sa apana 7 naimono bontoiena. Sa baiwa no waeuwanewo atentata apana bolala bo bedewe enapuwimopue waimompo i sa apana dainea manainapaida wanalepi?” ");
INSERT INTO soq_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Iesu mo sipoamone wanase, “Buka bedewe dima girumalena e mai inseipadewaitipe ita do God mukawa mai ateitipe wanleipona, dia. Sa baiwa waitarala surakauaia waile dianeilana, ba? ");
INSERT INTO soq_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Apana bolala bo bedewe enapuwimopue waimompaa walamawe mo mai nainaintopu, dia, mo ensel uboo waimoia ruau di waimompa. ");
INSERT INTO soq_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","27","E sumanaitile inseilanase bolala mai bo bedewe enapuwimopue waimompa, dia. E inseilakadisaile mai ateitipona! Moses bukawa bedewe ia inilala idia dudunawa e wisiaitene ateiten, ba dia? God Moses ia idia tampe enedio diene wanase, ‘Ne ipa Abraam Godiwa, Aisak Godiwa ita do Iakob Godiwa.’ Insenadewaitana, me mai apana bolala Godiu, dia, tane mo wanwankasalala Godiu.” ");
INSERT INTO soq_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Tane anaana waeuwalala wisene Sadusi apanawa Iesu do gagalontoio asisumodie. Me Iesu gagalo dodomana wandewaleno etene baiwa waitarasane wanase, “Anaana dainea debamawaida uduudu bedeuwo?” ");
INSERT INTO soq_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ita Iesu leusane wanase, “Anaana uduudu bedeuwo ema dea ipa debamawaida: ‘Israelwa asisudewaitana, Tatamba God dea os wande, mai God da wainipona, diaida. ");
INSERT INTO soq_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","E Tataa God nuaa uduudu, insaisaa uduudu, atena uduudu, ita do mukaa uduudu mampe nuawadawadasane wanempa.’ ");
INSERT INTO soq_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Tane anaana ema do deawaa debamawaida: ‘Sosoa nuawadawadamona eba nuawadawadaitiana rua.’ Anaana uduudu bedeuwo ema nata ipa debamauida, mai anaana isiwa ruau.” ");
INSERT INTO soq_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Anaana waeuwalala aia ema etene Iesu diene wanase, “Debamamba, e waadewaiten, Tatamba God dea os wande, mai God da wainipona, dia. Sa ulaipa. ");
INSERT INTO soq_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Eulena no God mampe amonamba pue pulontonte sunta, ba pulo daitada amonantonte wainenta. Epe dewantonta, sa ipa euda. Tane anaana nata e wamoana, sa ipa debamauida dewamonte wainenta: No God nuamba uduudu, ateinimba uduudu, ita do mukamba uduudu mampe nuawadawadantonte wainenta. Tane do sosomba nuawadawadamonte wainenta, no nuba simbiambantite nuawadawadantitana rua.” ");
INSERT INTO soq_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Me sipoa wandewalena baiwa Iesu nuawa euleno diene wanase, “E God gonaawa mampeitie wainiana.” Iesu epe wano aupe mai apana da me waitarasapona rua, dia. ");
INSERT INTO soq_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Iesu God duwa bedewe waeuwaleidie apana waitaramone wanase, “Anaana waeuwalala Keriso umanawa waia me ando Dawid mampee wisepie me atanosiwa mulepi. Mo insaisau na wadane epe wai? ");
INSERT INTO soq_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Aleu kakaiwa Dawid insaisawa waneno wane wanase, ‘Tatamba God ne Tatana mampe wane wanase, ‘Witana on deneuwe aisite wana ne ideita e wenawenaa nanausimope e waa atowe teamopatuwapi.” ");
INSERT INTO soq_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dawid Keriso ebowa wadi wadiase, ‘Tatana.’ Tane ambi Keriso me atanosiwaida?” Apana uaraia Iesu gagaloleidio nuau eudidaleno me asisusaie. ");
INSERT INTO soq_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Iesu sape waeuwaleidie wane wanase, “Anaana waeuwalala dewau ewanadewaitana, mai mampoitana, dia! Mo dewau ema epe dewamoie waimoi: Mo garau eubu daumauia taumoie asowawantoie lai. Ita mo maket bolawe laio apana auwadewasamoio mo nuau eudidaleidio ituposintoi. ");
INSERT INTO soq_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Tane do gagalo duwa bedewe ita oda bedewe bola euwa wanamoio osowe waimoie nuaeuwantoie asowawantoi. ");
INSERT INTO soq_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Mo obuobu dubu ita puraiwau oniakadisamoie otamoie mampomoi. Ita laga mampe raupari daumauia wamoie lai. Mo epe dewantoia baiwa God matangelawa pokawa debamaia etapu.” ");
INSERT INTO soq_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ema aupe Iesu pulo ituia watawa tampe aisidene waine apana uara maneu pulontoio ewadewasamodie. Mauralala uara wimone mane debamaia teamoie. ");
INSERT INTO soq_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ita obu nuaparela wisene pulowa mane nepa dubawa nata teamon. ");
INSERT INTO soq_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Iesu me ewedie wawe alala apamono mampe wimono diamone wanase, “Ne ulaipa dialedina, obu sa pulowa ituna mai apana uduudu pulontoiena rua, me ipa debamawaida itun. ");
INSERT INTO soq_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ipawa mo mane osowe maurantone moawa di winakoalala pulontoiena. Tane obu sa abolaleidie wandia dima osowe wampona uduudu pulolentuwan.” ");
INSERT INTO soq_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Iesu God duwa ene nosedio wawe alala dea me diene wanase, “Debamamba, God duwa ita tampe du isiwa do eneia ewamoa! Mo seu debamau mampe wadamoieno ewaewau eudida enei.” ");
INSERT INTO soq_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Iesu sipoasane wanase, “E du ema eubu badou eneio ewamoie asou waiana, ba? Ne dieedina, du sa uduudu kadintoputuwapi, mai seu da bolawe winepi, uduudu noanamopuo nomoputuwapi.” ");
INSERT INTO soq_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Iesu Ierusalemwae alene wadi Olib osowe wisene namba God duwa mampesane wain. Sape Pita, Iems, Ion ita Endru wimone werego Iesu waitarasane waienase, ");
INSERT INTO soq_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ema gagalowaitena walama dainea segantopu? Dewa ema uduudu uwaantompo eueuwa inainambu dainea segantompo no ewamote atentata?” ");
INSERT INTO soq_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Iesu mo diamone wanase, “Ewanadewaitana, mai mida da e lagalepie banlakadisalepi, dia. ");
INSERT INTO soq_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ne epe dialedina, ipawa apana uara manlawo wimompe wampaase, ‘Ne e inawala, mida e onioniawaitile wainilana winen inalepaa baiwa.’ Mo ne ebona wampe nolantompe apana uara banlakadisamopuo waeuwau bedewentopu. ");
INSERT INTO soq_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","8","E bola uara daitada onantompo gagalowa etana ita do bola isiwa ona baiwa imaantompo umanau etane mai saitane insenase, ‘Tauma ipa sa walama ompa wisen.’ Tane sa dia. Aia daitada wawalala bola daitada bedewe onantompe waimompa. Do wanatata ita natunakani bola uara daitada bedewe segantompo pokawa apana etompe waimompa. Poka sa ipa i oto mu baiwaleidio poka etedia rua. Tane poka sa mai i oto gamoidalepia pokawa rua, dia. Poka sa segantompa, sa ipa eueuwa e baila, ewamone ateitana walama ompa maidaleide. Tane ompaida ando segalepi. ");
INSERT INTO soq_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","E insaisala wadaaubalala os emoitonune wanlempa, mai di wankoaitonuna. Mo e wadaitulepue kotu apanawa mampolepu. Ita mo gagalo dubu bedewe ba kotu bolawa osowe sabamo apana emauwo epaepabobolempo malaitana. E ne wanawoitilana baiwa gabeman apanawa debamau ita do warere danauwo enane kotulempo e ne wasabamoneane Gagalo euda benemaitano mo etapu. ");
INSERT INTO soq_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Gagalo euda uwa daitada apanawa mampo amonantopuo etaputuwapio tauma walama ompaida wisepi. ");
INSERT INTO soq_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Mo e wadaitulepue kotulempo gagalo wawawa mampe mai nuabolaitana, ipawa e ebaida mai gagaloitana, dia. Tane Aleu kakaiwa aia enalepio gagaloitana rua. ");
INSERT INTO soq_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Apana muba wanwambuida ita tatatauida dabuamopue kotu apanawa mampomopuo kotumopue bomopu. Ita mamamau obampuida dabuamopuo kotu apanawa mampontopu bomopua baiwa. Ita obampu gombauida mampo dewa ipa deawaa dewamopue dabuamopuo kotu apanawa mampomopuo kotumopue bomopu. ");
INSERT INTO soq_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","E ne wanawoitilana baiwa apana uduudu e nibualepu. Tane me mida poka saiwa ema bedewe badowa enompe ompa osowe wisepia, me inaida donsapie inalepi.” ");
INSERT INTO soq_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“E wisialala gagalo ema wisiaite ipawa atendewaitana: Walama ando nitu nuadabualalaida God bolawe itupuo enompe God bolawaida rebarebasampo ewaewawa koakoalepie kadilepi. Nitu nuadabualalaida sape enompo kadi rebarebaida segalepia baiwalempo mo Iudiawo wanwanlala kadi sawantopue bolau epue weuwapue wadiwa antopue waimompa. ");
INSERT INTO soq_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Me mida walama sa bedewe peloo waimpe leumpa mai a baiwa du bedewe odepie puraiwawa otepi, diaida. Me tauwadea bolawa epie di weuwapie wadiwa alepie inalepi. ");
INSERT INTO soq_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ita apana iraileidia mai garawa otaotawa insaisawalepie duwa awa alepie walamawa diasapi. Me tauwadea wadiwa alepie inalepi. ");
INSERT INTO soq_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Walama sa ipa pokawaaida ioto bulala ita do mo mida oto gegelau do baibu, mo mai tauwadea os bolau epue wadiwa antopua rua. ");
INSERT INTO soq_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","E God mampe rauparitonuna poka inainamba ema mai unu walamawe segantopu, dia, abaia nomopue inta bodamopua sawa. ");
INSERT INTO soq_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Mo inantopua baiwa wadiwa antopu, ipawa walama sawo poka etaetalalaida segalepi. Tane poka sa rua mai God tawo dewasanawo ita tauma segalepona, dia. Ita poka walamawa sa dialepio aupe mai poka da ema rua segalepi, dia. ");
INSERT INTO soq_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Poka etaetala walamawa sa daumalempe alempo mai mida da inalepi, dia, uduudu bontoputuwapi. Tane sonabalala baibu God poka walamawa sa kampasapie itupi. ");
INSERT INTO soq_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Walama sa bedewe apana isiwa e dialempe wampaase, ‘Sosona, Keriso inalepia mape wande,’ ita do wampaase, ‘Keriso sisi wande.’ Mo epe dialempo mai sumanaibuitana, dia. ");
INSERT INTO soq_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","E mai sumanaibuitana, ipawa walama sawo Keriso lagawaau ita do peroweta lagawaau uara segantopue wimopu. Ita mo ginasa eueuwa pokawaau dewamompe sonabalala banlakadisamompaa baiwa. Tane mo mai banlakadisamopua rua, dia. ");
INSERT INTO soq_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ne dewa ema uduudu ando segantopua umanau diaimaalene nualawo ituna insamonune wanlempa.” ");
INSERT INTO soq_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Poka debamaia walamawa sa diantopuo aupe dewa inainamba da segantopu buka bedewe girumalena rua, wadi wadiase, ‘Omo dubalepie sala iwinlepi ita uaboa mai sapa wapi, dia. ");
INSERT INTO soq_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Kipora uboe nomoputuwapio uba ita sala do ewaewawa rebarebaidalepi.’ ");
INSERT INTO soq_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ema segalempo walamawe Apana Otopa giou bedewainta mukawa debamaia ita me sapawaida do iompo apana uduudu ewapu. ");
INSERT INTO soq_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ita me enseliwa waaubamopio God sonabamodia apanawa tawo osowe bola uduudu bedewe banlamopue me mampe auwamopu. ");
INSERT INTO soq_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","E ia karakai mampe aten wadana! Ia sa inintopue asiu sanaa teamompo e ewane ateitana maura walamawa kampalen. ");
INSERT INTO soq_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Deawaa, eueuwa ne dialena segantompo e ewane ateitana Apana Otopa wiwisawa walamawa kampaidalen, du nopeido. ");
INSERT INTO soq_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ne ulaipa dialedina, walama ande apanawa mai tauwadea bontoputuwapi tane mo waimompo dewa ema uduudu segantopu. ");
INSERT INTO soq_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Uba ita tawo diantoputuwapi, tane ne aiana mai dialepi, diaida!” ");
INSERT INTO soq_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Apana Otopa wiwisawa walamawa ita omowa mai mida da atenleipona, dia. God enseliwa uboo waimoia mai atentoipona, ita do me Otopa walama sa mai atenleipona, dia, tane Mamamba os atenlen. ");
INSERT INTO soq_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","E insaisala wadaaubalala emoitonune wanlempa, mai di wankoaitonuna, ipawa Apana Otopa wiwisawa walamawa e mai ateitipe wanleipona, dia. ");
INSERT INTO soq_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ne gagalo kerauda wapo mampe insaisawa wadana! Du apanawa bolawa epie alepia insaisawaleide. Me nolawa uduudu nolawa apanawa witapomopie ita du oniedia apanawa diepio onionialempe emolempe waimpa, mai di wankoalempa. Ita epie awe alepi. ");
INSERT INTO soq_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","E du oniedia apanawa ruawaitane onioniaitonune emoitonune os wanlempa, ipawa e mai ateitapona du apanawa walama dainea leulepie wisepi. E mai atendewaitipona me rawiwa, ba tadina pouwe, ba walama pumpu kanka wampo wisepi. ");
INSERT INTO soq_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","E walama uduudu imaaitonune wanlempa, me tauwadea os wisepie ituitonuno donlepia sawa. ");
INSERT INTO soq_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Gagalo ema wane dialena mai e os dialepona, dia, tane apana uduudu dialedina, e onioniaitonune emodewaitonune wanlempa.” ");
INSERT INTO soq_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Pirisi debamau ita anaana waeuwalala auweie gagalontoie inta na inta Iesu wadapuitue kotusapue bosapu. Ita mo gagalontoie insaisau deasane waienase, “Walama nata dialepio aupe Pasowa odawa nata. Ita ema aupeaupe no bured sasanasiawaia odantonte nanto walama 7 dialepi. ");
INSERT INTO soq_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ita oda sa nante bedewe Iesu mai wadata, naita apana uara ewanepue nuau kadilepio onamba enapu.” ");
INSERT INTO soq_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Mo insaisau deasaio walamawe Iesu Betani bedewe apana ebowa Saimon duwe wandie. Saimon sa mapo kero kito wadawadalala tane inalena. Iesu sape nana nadio i dea ia asiwa bonabonaua esapa dugi euda bedewe imaala winedio wadene Iesu mampe wisen. Ita me dugi moawa wadenaubene Iesu uwawa osowe ia esapa bonabonaua memenauben. Tane esa sa malesawa debamaia. ");
INSERT INTO soq_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Apana isiwa sape waimoia i epe dewaleidio ewane nuau kadiidaleno mamoo muba momoduntoie waiase, “Dima baiwa me ia esapa bonabonaua eudida di memenauben? ");
INSERT INTO soq_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Nitu sa malesawa debamaia ena dea bedewe nolantope manewa wadapona rua. Me gimaralepe mane debamaia epe rua wadape nuaparelala saumopona, tane di kadisan.” Ita mo me badowaida diane malasaiena. ");
INSERT INTO soq_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Mo epe dieio Iesu onau wane wanase, “Dima baiwa me epe dieile nuawa kadisailana? Ena, me dewa euda dewasan ne baina. ");
INSERT INTO soq_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Apana nuaparelala walama uduudu e do wanlempe saumonuna rua. Tane ne mai walama uduudu e do wainento oniadewasaneanuna, dia. ");
INSERT INTO soq_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Me dima mampeleno ewene rua ne mainawo dewasane ia esapa bonabonaua ne uwanawo memenauben. Sa ipa ne dobosaneapua baiwa benaimaanen. ");
INSERT INTO soq_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ne ulaipa dialedina, bola daitada bedewe Gagalo euda amonantompe dima i ema dewasana do gagalowa wampe benemantompa. Ita me dudunawa sa winakasalepio apana insempa.” ");
INSERT INTO soq_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ema aupe wawe alala 12 bedeuwo sou dea Iudas Iskariot pirisi debamau mampo alene Iesu dabuasapie laga mampe mo saumopie mamposapia benemawa diamon. ");
INSERT INTO soq_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Mo aia ema etane nuau eudidaleno me sauasane dieiena mane wanapu. Ita Iudas wandi leidia walamawa wadepidewae dima insaisawalena dewasapio segalepi. ");
INSERT INTO soq_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Bured sasanasiawaia odantoie naia walamawa bumpe Iuswa dewau rua sipsip bomoi Pasowa odawa nanawa napua baiwa. Walama sa bedewe Iesu wawe alala me waitarasane waienase, “E meneedia no naepe ane Pasowa nanawa imaasato wane naa?” ");
INSERT INTO soq_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Me wawe alala nata waaubamone diamone wanase, “Aitane Ierusalem bedewe, inta sape apana esa dugiwa awanepie iompo donsane do aitana. ");
INSERT INTO soq_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Me du dainea bedewe odompo e do odane aitana. Ita sape du apanawaida diane wanase, ‘Debamamba e waitaraedie wadiase: E duawo nana bolawa da winede, ba dia, ne wanawo alala do wante Pasowa odawa nanawa nata?’ ");
INSERT INTO soq_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ita du apanawaida bola debama du pouweido imaasaieno winedia euwalepio ewane sape oda nanawa imaamonatuwapi.” ");
INSERT INTO soq_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Iesu wawe alala nata epe diadewasamono ene Ierusalemwa antoiena. Mo sape wimone me dima umanawa wamona uduudu segantonatuwaieno eweiena. Ita mo Iesu diamona rua Pasowa odawa nanawa laulantone imaamone teiena. ");
INSERT INTO soq_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Rawileidio Iesu wawe alala 12 do sape wimoiena. ");
INSERT INTO soq_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Mo nana napua baiwa aisintone waimoiena. Ita mo nana naio bedewe Iesu wane wanase, “Ne ulaipa dialedina, dea e bedelawo mida ne do wante nana naitana ne laga mampe nananepie kotu apanawa mamposapi.” ");
INSERT INTO soq_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Wawe alala aia ema etane nuau pareidaleno deadea Iesu waitarasaie waiase, “Debamamba, e ne umanana wano? Ne ando mai epe dewanteapa, dia!” ");
INSERT INTO soq_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ita Iesu mo sipoamone wanase, “E 12 bedelawo sola dea mida bured wadedie ne nata urai reduwa enedia bedewe aneite naitana me ipa sa ne dabuanepie mo mamposapi. ");
INSERT INTO soq_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Apana Otopa mampe epe segalepio bolepi me umanawa buka bedewe girumaleno winedia rua. Tane me mida Apana Otopa dabuasapie laga mampe kotu apanawa mamposapia me matangela rebarebaida donsapie poka etepi! Poka sa etepia sawa eulena, me inawa gamowa epona.” ");
INSERT INTO soq_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Mo nana naio Iesu bured wadene God auwasane ita ampuiasane wawe alala wanamodie wanase, “Ema ipa ne etena, wadane nana.” ");
INSERT INTO soq_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ema aupe me redu wadene God auwasane ita mo wanamono naiena, mai da epona, dia. ");
INSERT INTO soq_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ita me mo diamone wanase, “Ema ipa ne osinana memenaubena apana uara kadiu insadabua baiwa. Inta ema bedewe ne sauana sanaa ipawanalepi. ");
INSERT INTO soq_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ne ulaipa dialedina, nana ema naitana dialepio aupe ne wain mai napa, dia, ideita God gonaawa wisepie ipawanalepio tauma ne osowe napa.” ");
INSERT INTO soq_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Nana aupe mo wadapos sasawa waieno dialeno Ierusalem ene nomone wadi Olib osowe anton. ");
INSERT INTO soq_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Mo wadi Olib osowe wimone Iesu wawe alala diamone wanase, “E uduudu ne koaneane eneane aitanatuwapi buka bedewe girumalena rua. Buka bedewe God ema epe wadi wadiase, ‘Ne sipsip onioniau apanawa epapabolepio me sipsipwa uduudu epue deaantopu.’ ");
INSERT INTO soq_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","E uduudu ne eneane aitanatuwapio bonteapa. Tane bo bedewe enapawineape bautantape Galiliwa anteapo e wanawo wilene doineana.” ");
INSERT INTO soq_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ita Pita meba umanawa waidasane Iesu diene wanase, “Naita mo uduudu e koaepue eepue antopu, tane ne mai e eepa, diaida!” ");
INSERT INTO soq_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Tane Iesu me sipoasane wanase, “Ne ulaipa dieedina, deama tadino e walama natadea ne wakoana wae lagaitaa, muriwa walama nata kanka aiawa wapi.” ");
INSERT INTO soq_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pita aia ema etene badowaida leusane wanase, “Ne mai e wakoaepe lagaa wapa, diaida! Ne e adiawontape wasabamoa wapa, mo ne do boneapua ide rua e nata bontata.” Ita wawe alala uduudu sape Iesu do waimoia aia ipa deawaa waiena. ");
INSERT INTO soq_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Iesu wawe alala do wadi Olib osowe antoie bola ebowa Gesemaniwa wimone Iesu mo diamone wanase, “E mape wanlempo ne inta sisi anteape rauparintepine wainepina.” ");
INSERT INTO soq_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Tane me a baiwaleidie Pita, Iems ita Ion os diamone banlamono do anton. Mo sape waimoie Iesu nuawa polaida wano nuapareidalen. ");
INSERT INTO soq_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ita mo diamone wanase, “Ne nuana nuapare nopeidosana bonepia rua etedina. Ne emante anteape rauparintepino e mape onioniaitonune emoitonune wanlempa, mai di wankoaitonuna, dia.” ");
INSERT INTO soq_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Me epe diamone ene eseanama alene dogo osowe nuawa aintue itulene rauparileidie God diedia poka walamawa sa me baiwa iedia nambesapona baiwa. ");
INSERT INTO soq_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ita me rauparileidie wane wanase, “Aba, Mako, e manawo muka winedia dewa uduudu dewasaa rua. Ne iririedina poka saiwa reduwa mainawoleidia wade nambesawo mai napa. Tane mai ne menanedia rua dewasawo segalepi, dia, e insaisaaida segalepi ne mainawo.” ");
INSERT INTO soq_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Me epe rauparilene ene alene wawe alala natadea mampo wisene ituntoio ewamone Pita diene wanase, “Saimon, e ituitiana, ba? E onioniaitipe emoitipe os waneipono omo dea dialepona, ambi ipa epe e ituitiana?” ");
INSERT INTO soq_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ita me mo diamone wanase, “E rauparitonune emoitonune os wanlempa, rubu iompo e badowa enakasaitane nanausana rua, mai dia. E nuala uduudu menasadia badowa enonuna, tane ete oauaraleidie teinaaisileidia wankoaitonuna menasade.” ");
INSERT INTO soq_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Me epe wane emone alene raupari deawaa rauparileidi wandie. ");
INSERT INTO soq_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ita ene leulene wawe alala mampo wisene mo emau lauidaleno baiwa osowe ituntoio ewamon. Tane mo mai dima da Iesu mampe wapona rua, dia. ");
INSERT INTO soq_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Mape Iesu osowe mo emone raupariwa ompa awa alen. Ita me raupari diasane leulene wawe alala mampo wisene diamone wanase, “E ituidaitile bubuaitilana, ba? Itu ena, ne walamanaida wisen. Taumaida Apana Otopa dabuasapuo kadi dewalala mampolepi. ");
INSERT INTO soq_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Enano ana, mida ne wadanepie nanalepia iede.” ");
INSERT INTO soq_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Iesu gagalo sa wadio bedewe Iudas mampeido wisen. Me ipa wawe alala 12 sou dea. Ita apana uaraia witapo isimau ita koinau otamone me do wimone eneie. Mo ipa pirisi debamau ita apana eiau ita do anaana waeuwalala waaubamoieno wimoiena. ");
INSERT INTO soq_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Muriwa mo wimoiena, bauta Iesu nanaleidia apanawa werego sosowa diaimaamone wanase, “Ne anteape mida ne isuruasapino ewana, me ipa sa wadanaitue sorodia mamposano banlepue antopu.” ");
INSERT INTO soq_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Mo uaraia wimone eneio Iudas tauwadea os Iesu mampe alene diene wanase, “Debamamba, ne auwaedina!” Me epe wane Iesu isuruasan. ");
INSERT INTO soq_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ita mo eueuwa sa ewane Iesu wadanaitudeieno dibura apanawa wanalene enedie. ");
INSERT INTO soq_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Mape mo eneio Iesu sowa dea enedie isimawa teinenaubene pirisi ionoidoa nolawa dewalala asiwa tonpunden. ");
INSERT INTO soq_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ita Iesu mo diamone wanase, “E isimala ita koinala do otele mainawo wilen ne wadaneana baiwa, ewaewa abo ne witakadila apanawa. ");
INSERT INTO soq_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ne e do wainite walama ruawantedine God duwa bedewe waeuwantedino mai wadaituneapona, dia. Tane tauma os dewasailana, sa ipa dima buka bedewe girumaleno winedia ipawanalepia baiwa.” ");
INSERT INTO soq_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Me epe wano wawe alala uduudu Iesu ene sauwo antonatuwaiena. ");
INSERT INTO soq_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ita mo Iesu banlene antoio apana dea sanaa garawa dea os taudi leidia mai epe alepona, dia, me Iesu warorosane aleidio mo me wadaitusaie garawa teineie wadapona baiwa. ");
INSERT INTO soq_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Tane me kasawogalene garawa sa taudia ampe noseno ene di alen. ");
INSERT INTO soq_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Mo Iesu banlene pirisi ionoidoa duwa mampe wimoieno pirisi debamau, apana eiau, ita do anaana waeuwalala sape auweie. ");
INSERT INTO soq_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Mo Iesu banlene antoio Pita mo wauwo mamoo Iesu warorosane aleidie. Ita pirisi ionoidoa duwa enedia bolawa mampe wisene sorodia iwulala do ia denantone ewamodio waimoie. ");
INSERT INTO soq_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Tane pirisi debamau ita do Iuswa onioniau apanawa uduudu Iesu kadiwa banusaie wawu da donsape bosapona baiwa. Tane mai kadi wawuwa da donsapona, dia. ");
INSERT INTO soq_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Apana uara me lagawa waie sabamosaie abo me kadiwa dewasapona rua. Ita mo lagau mai dealepona, nambenambe os wamoie, sa ipa muba eueuwantona mo lagaidantoie. ");
INSERT INTO soq_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Tane mo isiwa sape waimoia enanawimone gagalowa da mampe Iesu wawusane waienase, ");
INSERT INTO soq_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“No eteitano me wanase, ‘Ne God duwa apana wadeiena kadisapatue tane walama natadea bedewe ne God duwa da mai apana witapo dewalala wadapatuwapio segalepi.’” ");
INSERT INTO soq_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ita mo isiwa God duwa gagalowa sa benemawantoiena mai dealepona, dia. ");
INSERT INTO soq_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Mape pirisi ionoidoa enenwisene Iesu diene wanase, “Apana ema e wawueie benemantoio eteiana, ba? E mo wawueia sipoa leusae eba inaitaa gagalowa waa, ba di epe enona?” ");
INSERT INTO soq_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Tane Iesu dainakasalen, mai dima da wapona, dia. Ita pirisi ionoidoa osowe waitarasane diene wanase, “Dianewo etata, e Kerisoida, God mida no wadaposisaitana Otopa, ba?” ");
INSERT INTO soq_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ita Iesu me diene wanase, “Oa, ne ipa ema ewaneiana. Tane e ando Apana Otopa God mukamukaua witapa on deneuwe waimpo ewaidasana, ita do me uba giouwa asiasi iompo ewana.” ");
INSERT INTO soq_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Pirisi ionoidoa ema etene nuawa kadiidaleno garawa taudia siolenaubene wanase, “No dima baiwa benemasiki apanawa da baibuntitana? Me epe wana baiwa eta. ");
INSERT INTO soq_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Me God wakadisasano etatana, tauma dima dewasata me mampe?” Mape mo uduudu nuau deasane matangelawa ituiena bosapu. ");
INSERT INTO soq_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Tane mo isiwa sape eneia Iesu seseisaie ita emawa taubodasaia sala mai ewepi ita epeie dieie waiase, “Tauma waa, mida epeede!” Ema aupe sorodia iwulala me wadanaitue epaepabobosaiena. ");
INSERT INTO soq_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita kotu duwa enedia bolawe wandio pirisi ionoidoa nolawa dewala iwa mampeinta wisene aleidie. ");
INSERT INTO soq_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Me Pita ia ewasedio wandio ewadewasasane diene wanase, “Ne eweene atenten e Nasaret Iesuwa sowa da.” ");
INSERT INTO soq_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Tane me lagalene wanase, “Dima baiwa ne epe dianeiana, apana sa umanawa waiana ne moana.” Me epe wane ia ewasedia ene bola sa intawa moawe nosene aleidio kanka aiawa wan. ");
INSERT INTO soq_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Tane nola dewalala iwa sa Pita sape enedio ewene mo mida me do eneie laia osowe diamone wanase, “Apana sa Nasaret Iesuwa sowa dea.” ");
INSERT INTO soq_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ita me osowe wakoalene lagalen. Tane mo mida me tampe eneia me etane enanakeraue ita Pita diane waienase, “E ipa mo sou dea, e Galili apanawa, mo aiauwo gagaloitiano no etate atenten.” ");
INSERT INTO soq_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Mo me epe dieieno etene me mampo badowa wane diamone wanase, “Ne laganteipono God ne matangelaneapona. Apana e umanawa wailana ne mai atenteapona, dia!” ");
INSERT INTO soq_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Pita mo epe diamono aupeaupe kanka aiawa osowe wan. Kanka aiawa wadio etene dima Iesu me diena insaisawa mampelen. Iesu me ema epe diene wanase, “E walama natadea ne wakoana wae lagaitaa, muriwa walama nata kanka aiawa wapi.” Iesu epe wana rua Pita kanka aiawa wano etene tauma Iesu me diena insendewalene ke debamaia wan. ");
INSERT INTO soq_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Imonemba walama pumpu pirisi debamau, apana eiau ita anaana waeuwalala, ita do Iuswa onioniau uduudu insaisau deasaiena Iesu matangelawa dainea wadepi. Ita mo insaisau deasaiena rua me witapa taune banlene antone Rom gabemaniwa debama Pailat mampesaiena. ");
INSERT INTO soq_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ita Pailat Iesu waitarasane wanase, “E Iuswa warereu, ba?” Tane Iesu leusane wanase, “Sa ipa sa e waiana.” ");
INSERT INTO soq_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Mape pirisi debamau wawu uara mampe me wawusaio Pailat etedie. ");
INSERT INTO soq_vpl VALUES ("MK15_4","071