﻿USE sofia;
DROP TABLE IF EXISTS sofia.som_vpl;
CREATE TABLE som_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES som_vpl WRITE;
INSERT INTO som_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Bilowgii Ilaah samada iyo dhulkuu abuuray. ");
INSERT INTO som_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Dhulkuna qaab ma lahayn, wuuna madhnaa; gudcurna moolkuu dul joogay; oo Ruuxa Ilaahna wuxuu ka dul dhaqdhaqaaqayay biyaha. ");
INSERT INTO som_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Ilaahna wuxuu yidhi, Iftiin ha ahaado: iftiin baana ahaaday. ");
INSERT INTO som_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Ilaahna wuxuu arkay iftiinkii inuu wanaagsan yahay: Ilaahna iftiinkii ayuu ka soocay gudcurkii. ");
INSERT INTO som_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Ilaahna iftiinkii wuxuu u bixiyey Maalin, gudcurkiina wuxuu u bixiyey Habeen. Waxaana jiray fiid iyo subax, isla maalin ah. ");
INSERT INTO som_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Ilaahna wuxuu yidhi, Meel bannaani ha noqoto biyaha dhexdooda, oo iyadu biyaha ha ka soocdo biyaha. ");
INSERT INTO som_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Markaasuu Ilaah sameeyey meeshii bannaanka ahayd, oo wuxuu biyihii bannaanka ka hooseeyey ka soocay kuwii bannaanka ka sarreeyey; sidaasayna ahaatay. ");
INSERT INTO som_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Ilaahna bannaankii wuxuu u bixiyey Samo. Waxaana jiray fiid iyo subax, maalintii labaad. ");
INSERT INTO som_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Ilaahna wuxuu yidhi, Biyaha samada ka hooseeya meel ha isugu soo urureen, oo ciidda engegani ha muuqato; sidaasayna ahaatay. ");
INSERT INTO som_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Markaasuu Ilaah ciiddii engegnayd u bixiyey Dhul; ururkii biyahana wuxuu u bixiyey Bado: oo Ilaah wuxuu arkay in taasu wanaagsan tahay. ");
INSERT INTO som_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Ilaahna wuxuu yidhi, Dhulku ha soo bixiyo doog, iyo geedo yaryar oo iniino dhala, iyo geedo waaweyn oo midho caynkooda ah dhala, oo iniinahoodu ku dhex jiraan, oo dhulka ku kor yaal; sidaasayna ahaatay. ");
INSERT INTO som_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Dhulkiina wuxuu soo bixiyey doog, iyo geedo yaryar oo leh iniino caynkooda ah, iyo geedo waaweyn oo midho dhala, oo iniinahoodu ku dhex jiraan, iyagoo caynkooda ah, Ilaahna wuxuu arkay in taasu wanaagsan tahay. ");
INSERT INTO som_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Waxaana jiray fiid iyo subax, maalintii saddexaad. ");
INSERT INTO som_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Ilaahna wuxuu yidhi, Iftiimmo ha ahaadeen meesha bannaan oo samada dhex ah si ay u kala soocaan maalinta iyo habeenka; oo ha u ahaadeen calaamooyin, iyo xilliyo, iyo maalmo iyo sannado; ");
INSERT INTO som_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","oo iftiimmo ha u noqdeen meeshii bannaanayd oo samada dhex ahayd si ay u iftiimiyaan dhulka dushiisa; sidaasayna ahaatay. ");
INSERT INTO som_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Oo Ilaah wuxuu sameeyey labada iftiin ee waaweyn; si uu iftiinka weynu u xukumo maalinta, iftiinka yaruna u xukumo habeenka; oo xiddigahana wuu sameeyey. ");
INSERT INTO som_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Ilaahna wuxuu iyaga dhigay meeshii bannaanayd oo samada dhex ahayd si ay dhulka u iftiimiyaan, ");
INSERT INTO som_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","oo ay u xukumaan maalinta iyo habeenka, oo ay iftiinka uga soocaan gudcurka, Ilaahna wuxuu arkay in taasu wanaagsan tahay. ");
INSERT INTO som_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Oo waxaana jiray fiid iyo subax, maalintii afraad. ");
INSERT INTO som_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Oo Ilaah wuxuu yidhi, Biyuhu aad ha u soo bixiyeen uun dhaqdhaqaaqa oo badan, oo naf nool leh, haadduna ha duusho dhulka dushiisa xagga meeshii bannaanayd oo samada dhex ahayd. ");
INSERT INTO som_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Oo Ilaah wuxuu abuuray nibiriyada badda oo waaweyn, iyo uun kasta oo nool oo dhaqdhaqaaqa, ee biyuhu aad u soo bixiyeen iyagoo badan, oo caynkooda oo kale dhala, iyo haad kasta oo caynkiisa dhala; Ilaahna wuxuu arkay in taasu wanaagsan tahay. ");
INSERT INTO som_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Oo Ilaah baa barakeeyey iyaga, isagoo leh, Wax badan dhala, oo tarma, oo biyaha badaha ka buuxsama, haadduna ha ku tarmeen dhulka. ");
INSERT INTO som_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Oo waxaana jiray fiid iyo subax, maalintii shanaad. ");
INSERT INTO som_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Oo Ilaah wuxuu yidhi, Dhulku ha soo bixiyo uun nool oo caynkiisa dhala, kuwaasoo ah xoolo, iyo waxa gurguurta, iyo dugaagga dhulka oo caynkooda dhala; sidaasayna ahaatay. ");
INSERT INTO som_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Ilaahna wuxuu sameeyey dugaagga dhulka oo caynkiisa dhala, iyo xoolo caynkooda dhala, iyo wax kasta oo dhulka gurguurta oo caynkiisa dhala; Ilaahna wuxuu arkay in taasu wanaagsan tahay. ");
INSERT INTO som_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Ilaahna wuxuu yidhi, Aan nin inoo eg ka samayno araggeenna, oo iyagu ha xukumeen kalluunka badda, iyo haadda hawada, iyo xoolaha, iyo dhulka oo dhan, iyo waxa dhulka gurguurta oo dhan. ");
INSERT INTO som_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Oo Ilaah nin buu ka abuuray araggiisa, Ilaah araggiisa ayuu ka abuuray isaga; lab iyo dhaddig ayuu abuuray. ");
INSERT INTO som_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Oo Ilaah waa barakeeyey iyaga; oo Ilaah wuxuu iyaga ku yidhi, Wax badan dhala oo tarma, oo dhulka ka buuxsama, oo ka sara mara dhulka, oo xukuma kalluunka badda, iyo haadda hawada, iyo wax kasta oo nool oo dhulka kor dhaqdhaqaaqa. ");
INSERT INTO som_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Oo Ilaah wuxuu yidhi, Bal eeg, waxaan idin siiyey geed kasta oo yar oo iniino dhala, oo ku yaal dhulka dushiisa oo dhan, iyo geed kasta oo weyn, kaasoo midho leh, iniinona dhala; oo waxay idiin noqon doonaan cunto; ");
INSERT INTO som_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","oo dugaag kasta oo dhulka jooga, iyo haad kasta oo hawada duula, iyo wax kasta oo dhulka gurguurta, oo naf nool leh ayaan geed kasta oo cagaar ah cunto u siiyey; sidaasayna ahaatay. ");
INSERT INTO som_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Oo Ilaah wuxuu arkay wax kasta oo uu sameeyey, oo bal eeg, aad bay u wanaagsanaayeen. Waxaana jiray fiid iyo subax, maalintii lixaad. ");
INSERT INTO som_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Samada iyo dhulkuna way dhammaadeen, iyo waxa badan ee ku jira oo dhammuba. ");
INSERT INTO som_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Maalintii toddobaadna Ilaah wuu dhammeeyey shuqulkiisii uu sameeyey; oo maalintii toddobaad ayuu ka nastay shuqulkiisii uu sameeyey oo dhanba. ");
INSERT INTO som_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Oo Ilaah wuu barakeeyey maalintii toddobaad, quduusna wuu ka dhigay; maxaa yeelay, maalintaas ayaa Ilaah ka nastay shuqulkiisii uu sameeyey ee ahaa abuuridda oo dhan. ");
INSERT INTO som_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Kuwanu waa bilowgii samada iyo dhulka kolkii la abuuray iyaga, maalintii Rabbiga Ilaah ahu sameeyey dhulka iyo samada. ");
INSERT INTO som_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Dhirta duurkuna weli kuma ay oollin dhulka, geedaha yaryar oo duurkuna weli sooma ay bixin: waayo, Rabbiga Ilaah ahu dhulka roob kuma soo dayn, nin dhulka beeraana ma jirin; ");
INSERT INTO som_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","laakiin ceeryaamo baa dhulka kor uga soo bixi jirtay, oo waraabin jirtay dhulka dushiisa oo dhan. ");
INSERT INTO som_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Rabbiga Ilaah ahuna nin buu ka sameeyey ciidda dhulka, dulalka sankiisana wuxuu kaga afuufay neeftii nolosha; ninkiina wuxuu noqday naf nool. ");
INSERT INTO som_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Oo Rabbiga Ilaah ahu beer buu ka beeray xagga bari ee Ceeden; oo halkaasuuna geeyey ninkii uu sameeyey. ");
INSERT INTO som_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Rabbiga Ilaah ahuna wuxuu dhulka ka soo bixiyey geed kasta oo indhaha u roon, oo cunto ku wanaagsan; beerta dhexdeedana wuxuu ka soo bixiyey geedkii nolosha iyo geedkii aqoonta wanaagga iyo xumaanta. ");
INSERT INTO som_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ceedenna webi baa ka baxay inuu beerta waraabiyo; halkaasuuna ku kala qaybsamay, wuxuuna noqday afar madax. ");
INSERT INTO som_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Kan kowaad magiciisu wuxuu ahaa Fiishoon: kaasu waa kan ku wareegsan dhulka Xawiilaah oo dhan, meeshaas oo dahab leh; ");
INSERT INTO som_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","oo dahabka dhulkaasu waa wanaagsan yahay: oo meeshaasuna waxay leedahay beduliyum iyo dhagaxyo onika la yidhaahdo. ");
INSERT INTO som_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Webiga labaad magiciisuna waa Giixoon: kaasuna waa kan ku wareegsan dhulka Kuush oo dhan. ");
INSERT INTO som_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Webiga saddexaad magiciisuna waa Xiddeqel: kaasu waa kan Ashuur dhankeeda bari mara. Webiga afraadna waa Yufraad. ");
INSERT INTO som_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Rabbiga Ilaah ahuna ninkii wuu kaxeeyey oo wuxuu geeyey beer Ceeden inuu falo oo dhawro. ");
INSERT INTO som_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Rabbiga Ilaah ahuna wuxuu ninkii ku amray isagoo leh, Geed kasta oo beerta ku yaal wax baad ka cuni kartaa: ");
INSERT INTO som_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","laakiin geedka aqoonta wanaagga iyo xumaanta waa inaanad waxba ka cunin: waayo, maalintii aad wax ka cuntid hubaal waad dhiman doontaa. ");
INSERT INTO som_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Oo Rabbiga Ilaah ahu wuxuu yidhi, Ma wanaagsana in ninku keligiis ahaado; waxaan u samayn doonaa mid caawisa oo ku habboon. ");
INSERT INTO som_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Rabbiga Ilaah ahuna wuxuu ciidda ka sameeyey dugaag kasta oo duurka jooga, iyo haad kasta oo hawada duula; oo iyagii wuxuu u keenay ninkii, inuu arko wuxuu u bixiyo; oo wax kastoo ninkii u bixiyey uun kasta oo nool ayaa magiciisii noqday. ");
INSERT INTO som_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Oo ninkii baa magacyo u bixiyey xoolaha oo dhan, iyo haadda hawada, iyo dugaag kasta oo duurka jooga, laakiin ninkii looma helin mid caawisa oo ku habboon. ");
INSERT INTO som_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Oo Rabbiga Ilaah ahu hurdo weyn buu ku riday ninkii, kolkaasuu gam'ay; kolkaasuu wuxuu ka bixiyey feedhihiisii middood, meesheediina hilib buu ku awday. ");
INSERT INTO som_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Oo feedhii Rabbiga Ilaah ahu ka bixiyey ninka ayuu naag ka sameeyey, oo wuxuu iyadii u keenay ninkii. ");
INSERT INTO som_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ninkiina wuxuu yidhi, Tanu hadda waa laf ka mid ah lafahayga, iyo hilib ka mid ah hilibkayga: waxaa iyada loogu yeedhi doonaa Naag, maxaa yeelay, iyada waxaa laga soo saaray Nin. ");
INSERT INTO som_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Sidaas daraaddeed nin wuxuu ka tegayaa aabbihiis iyo hooyadiis, wuxuuna la joogayaa naagtiisa: oo waxay noqonayaan isku jidh. ");
INSERT INTO som_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Oo labadooduba way qaawanaayeen, ninka iyo naagtiisuba, mana ay xishoonaynin. ");
INSERT INTO som_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Haddaba abeesadu way ugu khiyaano badnayd bahal kasta ee duurka jooga oo Rabbiga Ilaah ahu sameeyey. Oo waxay naagtii ku tidhi, Ilaah miyuu idinku yidhi, Waa inaydnaan waxba ka cunin geed kasta oo beerta ku yaal? ");
INSERT INTO som_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Naagtiina waxay abeesadii ku tidhi, Midhaha geedaha beerta waannu cuni karnaa; ");
INSERT INTO som_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","laakiinse midhaha geedka beerta dhexdeeda ku yaal, Ilaah wuxuu nagu yidhi, Waa inaydnaan waxba ka cunin, ama aydnaan taaban, yeydnan dhimanine. ");
INSERT INTO som_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Abeesadiina waxay naagtii ku tidhi, Ma dhiman doontaan; ");
INSERT INTO som_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","waayo, Ilaah wuxuu og yahay in maalinta aad cuntaan ay indhihiinnu furmi doonaan, oo aad noqon doontaan sida Ilaah oo kale, idinkoo kala garanaya wanaagga iyo xumaanta. ");
INSERT INTO som_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Oo markii naagtii aragtay in geedkii cunto ku wanaagsan yahay, oo indhaha u roon yahay, oo uu yahay geed caqli lagu yeesho, ayay midho ka qaadatay, oo cuntay; ninkeedii la joogayna wax bay ka siisay, oo isagiina wuu cunay. ");
INSERT INTO som_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Oo labadoodiiba indhahoodii way furmeen, oo waxay garteen inay qaawan yihiin; waxayna isku tosheen caleemo berde, oo ay gunti ka samaysteen. ");
INSERT INTO som_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Oo waxay maqleen codkii Rabbiga Ilaaha ah, isagoo beerta dhex socda kolkii maalintu qaboobayd: oo ninkii iyo naagtiisii way iska qariyeen Ilaah, oo waxay ku dhuunteen geedihii beerta dhexdooda. ");
INSERT INTO som_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Oo Rabbiga Ilaah ahu wuu u yeedhay ninkii, oo wuxuu ku yidhi, Xaggee baad joogtaa? ");
INSERT INTO som_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Isagiina wuxuu yidhi, Codkaagaan beerta ka dhex maqlay, waanan cabsaday, maxaa yeelay, waan qaawanaa; oo waan isqariyey. ");
INSERT INTO som_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Kolkaasuu ku yidhi, Yaa kuu sheegay inaad qaawan tahay? Miyaad wax ka cuntay geedkii aan kugu amray inaadan wax ka cunin? ");
INSERT INTO som_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ninkiina wuxuu yidhi, Naagtii aad i siisay inay ila joogto ayaa geedkii wax iga siisay, oo anna waan cunay. ");
INSERT INTO som_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Oo Rabbiga Ilaah ahu wuxuu naagtii ku yidhi, Waa maxay waxan aad samaysay? Naagtiina waxay tidhi, Abeesadaa i khiyaanaysay oo anna waan cunay. ");
INSERT INTO som_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Oo Rabbiga Ilaah ahu wuxuu abeesadii ku yidhi, Waxan aad samaysay aawadiis waad ka habaaran tahay xoolaha oo dhan, iyo dugaag kasta oo duurka jooga; waxaanad ku socon doontaa boggaaga, ciid baanad cuni doontaa maalmaha cimrigaaga oo dhan: ");
INSERT INTO som_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","oo colaad baan idin dhex dhigi doonaa adiga iyo naagta, iyo farcankaaga iyo farcankeeda; oo madaxaaguu burburin doonaa, adiguna cedhibtiisaad burburin doontaa. ");
INSERT INTO som_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Naagtiina wuxuu ku yidhi, Dhibtaada iyo wallacaaga aad baan u badin doonaa; oo dhib baad carruur ku dhali doontaa; oo waxay doonistaadu ahaan doontaa ninkaaga, wuuna kuu talin doonaa. ");
INSERT INTO som_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Aadanna wuxuu ku yidhi, Codkii naagtaadaad maqashay oo waxaad wax ka cuntay geedkii aan kugu amray, anigoo leh, Waa inaadan waxba ka cunin, sidaas daraaddeed dhulku waa habaaran yahay adiga aawadaa; maalmaha cimrigaaga oo dhanna dhibaataad wax kaga cuni doontaa. ");
INSERT INTO som_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Qodxan iyo yamaarugna waa kaaga soo bixi doonaan, waxaanad cuni doontaa geedaha yaryar oo duurka. ");
INSERT INTO som_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Wejigaagoo dhididsan baad wax cuni doontaa, ilaa aad dhulka ku noqotid; maxaa yeelay, dhulkaa lagaa qaaday; waayo, ciid baad tahay, ciid baadna ku noqon doontaa. ");
INSERT INTO som_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Ninkiina wuxuu naagtiisii u bixiyey Xaawa, maxaa yeelay, waxay ahayd hooyadii waxa nool oo dhan. ");
INSERT INTO som_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Rabbiga Ilaah ahuna wuxuu Aadan iyo naagtiisii u sameeyey dhar harag ah, wuuna u xidhay iyagii. ");
INSERT INTO som_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Oo Rabbiga Ilaah ahuna wuxuu yidhi, Ninku wuxuu noqday sidii mid innaga mid ah, isagoo garanaya wanaagga iyo xumaanta; oo haatan, waaba intaasoo uu gacantiisa soo fidiyaa, oo uu wax ka qaataa geedka nolosha, oo uu cunaa oo uu weligiis noolaadaa: ");
INSERT INTO som_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","sidaas daraaddeed Ilaah isaga wuu ka saaray Beer Ceeden, si uu u beerto dhulkii isaga laga soo qaaday. ");
INSERT INTO som_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Kolkaasuu ninkii eryay; Beer Ceeden barigeedana wuxuu taagay Keruubiim, iyo seef ololaysa, oo dhan walba u jeesanaysa, si ay u dhawrto jidka geedka nolosha. ");
INSERT INTO som_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Ninkiina naagtiisii Xaawa ahayd buu u tegey; wayna uuraysatay, oo Qaabiil bay dhashay, oo waxay tidhi, Wiil baan ku helay Rabbiga caawimaaddiisa. ");
INSERT INTO som_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Dabadeedna waxay dhashay walaalkiis Haabiil. Haabiilna wuxuu ahaa adhijir, laakiin Qaabiil wuxuu ahaa beerfale. ");
INSERT INTO som_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Maalmo dabadeed waxay noqotay in Qaabiil qurbaan ahaan Rabbiga ugu keenay midhihii dhulka. ");
INSERT INTO som_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Haabiilna wuxuu wax uga keenay curadyadii adhigiisa iyo baruurtoodiiba. Rabbiguna wuu eegay Haabiil iyo qurbaankiisii; ");
INSERT INTO som_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","laakiinse Qaabiil iyo qurbaankiisii Rabbigu ma uu eegin. Qaabiilna aad buu u cadhooday, wejigiisiina wuu madoobaaday. ");
INSERT INTO som_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Oo Rabbigu wuxuu ku yidhi Qaabiil, Maxaad u cadhoonaysaa? Maxaase wejigaagu u madoobaaday? ");
INSERT INTO som_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Haddaad wax wanaagsan samaysid, sow laguma aqbaleen? Haddaadan wax wanaagsan samaynse, dembi illinkuu kuugu gabbanayaa; doonistiisuna aday noqon doontaa, adiguna waa inaad xukuntid isaga. ");
INSERT INTO som_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Qaabiilna wuxuu ku yidhi walaalkiis Haabiil, Ina keen, aynu duurka tagnee. Waxaana dhacday, markii ay duurka joogeen, in Qaabiil walaalkiis Haabiil ku kacay oo dilay isagii. ");
INSERT INTO som_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Rabbiguna wuxuu Qaabiil ku yidhi, Walaalkaa Haabiil meeh? Kolkaasuu yidhi, Ma aqaan: ma anigaa ah walaalkay ilaaliyihiisa? ");
INSERT INTO som_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Kolkaasaa Ilaah ku yidhi, Maxaad samaysay? Codkii dhiiggii walaalkaa ayaa dhulka iiga dhawaaqayaye. ");
INSERT INTO som_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Oo haatan waad ka habaaran tahay dhulkii afkiisa u kala qaaday si uu dhiiggii walaalkaa gacantaada uga helo. ");
INSERT INTO som_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Kolkii aad dhulka beeratid, wax badan kuuma dhali doono. Waxaad dhulka ku noqon doontaa mid carcarara oo warwareega. ");
INSERT INTO som_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Qaabiilna wuxuu Rabbiga ku yidhi, Taqsiirtaydu waa ka sii badan tahay wax aan qaadi karo. ");
INSERT INTO som_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Bal eeg, maanta dhulkaad iga eriday, wejigaagana waan ka qarsoonaan doonaa, waxaanan dhulka ku noqon doonaa mid carcarara oo warwareega; waxaana dhici doonta in kii i arkaaba i dili doono. ");
INSERT INTO som_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Oo Rabbigu wuxuu ku yidhi isagii, Sidaas daraaddeed ku alla kii dila Qaabiil, waxaa looga aargudan doonaa toddoba labanlaab. Rabbiguna calaamad buu u sameeyey Qaabiil, si aanu ku alla kii arkaaba u dilin. ");
INSERT INTO som_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Qaabiilna Rabbiga hortiisuu ka tegey, oo wuxuu degay dalkii la odhan jiray Nood, oo xagga bari oo Ceeden ku yiil. ");
INSERT INTO som_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Qaabiilna naagtiisuu u tegey; wayna uuraysatay, oo waxay dhashay Enoog. Wuxuuna dhisay magaalo, oo magaaladiina wuxuu ku magacaabay magicii wiilkiisii Enoog. ");
INSERT INTO som_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enoogna waxaa u dhashay Ciiraad, Ciiraadna wuxuu dhalay Mexuuya'el, Mexuuya'elna wuxuu dhalay Metuusha'el, Metuusha'elna wuxuu dhalay Lameg. ");
INSERT INTO som_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamegna wuxuu guursaday laba naagood; mid magaceedu wuxuu ahaa Caadah, tan kalena magaceedu wuxuu ahaa Sillah. ");
INSERT INTO som_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Caadahna waxay dhashay Yaabaal: isna wuxuu ahaa aabbihii kuwa teendhooyinka deggan oo xoolaha leh. ");
INSERT INTO som_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Magaca walaalkiisna wuxuu ahaa Yuubaal; isna wuxuu ahaa aabbihii kuwa kataaradda iyo biibiilaha garaaca. ");
INSERT INTO som_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Sillahna waxay dhashay Tuubalqayin oo ahaa mid tumi jiray alaabtii naxaasta iyo birta ahayd oo dhan; Tuubalqayin walaashiisna waxay ahayd Nacmah. ");
INSERT INTO som_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lamegna wuxuu naagihiisii ku yidhi: Caadah iyo Sillahay, codkayga maqla; Lameg naagihiisow, hadalkayga dhegaysta; Nin baan u dilay dhaawicid uu i dhaawacay aawadeed, Iyo nin dhallinyar dhufashadii uu wax igu dhuftay aawadeed. ");
INSERT INTO som_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Haddii Qaabiil toddoba labanlaab looga aargudan lahaa, Runtii Lameg waa in toddoba iyo toddobaatan labanlaab looga aar gutaa. ");
INSERT INTO som_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Aadanna naagtiisii mar kale ayuu u tegey; waxayna dhashay wiil, magiciisiina waxay u bixisay Seed, iyadoo leh, Ilaah abuur kaluu ii soo dhigay Haabiil meeshiisii; waayo, Qaabiil baa dilay isagii. ");
INSERT INTO som_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seedna waxaa u dhashay wiil, magiciisiina wuxuu u bixiyey Enoos; markaasaa dadkii waxay bilaabeen inay Rabbiga ku baryaan magiciisa. ");
INSERT INTO som_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Kanu waa buuggii farcankii Aadan. Maalintii Ilaah ninkii abuuray, ekaanta Ilaah buu ka sameeyey isagii; ");
INSERT INTO som_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","wuxuu abuuray iyagoo lab iyo dhaddig ah; wuuna barakeeyey iyagii, magacoodiina wuxuu u bixiyey Aadan maalintii iyagii la abuuray. ");
INSERT INTO som_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Aadanna wuxuu jiray boqol iyo soddon sannadood, wuxuuna dhalay wiil isagii u eg oo araggiisii leh; magiciisiina wuxuu u bixiyey Seed. ");
INSERT INTO som_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Aadanna markuu Seed dhalay ka dib wuxuu noolaa siddeed boqol oo sannadood; wiilal iyo gabdhona wuu dhalay. ");
INSERT INTO som_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Wakhtigii Aadan noolaa oo dhammuna wuxuu ahaa sagaal boqol iyo soddon sannadood; dabadeedna wuu dhintay. ");
INSERT INTO som_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Seedna wuxuu jiray boqol iyo shan sannadood, wuxuuna dhalay Enoos. ");
INSERT INTO som_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Seedna markuu Enoos dhalay ka dib wuxuu noolaa siddeed boqol iyo toddoba sannadood, wiilal iyo gabdhona wuu dhalay. ");
INSERT INTO som_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Wakhtigii Seed noolaa oo dhammuna wuxuu ahaa sagaal boqol iyo laba iyo toban sannadood; dabadeedna wuu dhintay. ");
INSERT INTO som_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enoosna wuxuu jiray sagaashan sannadood, wuxuuna dhalay Qaynaan. ");
INSERT INTO som_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Enoosna markuu Qaynaan dhalay ka dib wuxuu noolaa siddeed boqol iyo shan iyo toban sannadood, wiilal iyo gabdhona wuu dhalay. ");
INSERT INTO som_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Wakhtigii Enoos noolaa oo dhammuna wuxuu ahaa sagaal boqol iyo shan sannadood; dabadeedna wuu dhintay. ");
INSERT INTO som_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Qaynaanna wuxuu jiray toddobaatan sannadood, wuxuuna dhalay Mahalale'el. ");
INSERT INTO som_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Qaynaanna markuu Mahalale'el dhalay ka dib wuxuu noolaa siddeed boqol iyo afartan sannadood, wiilal iyo gabdhona wuu dhalay. ");
INSERT INTO som_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Wakhtigii Qaynaan noolaa oo dhammuna wuxuu ahaa sagaal boqol iyo toban sannadood, dabadeedna wuu dhintay. ");
INSERT INTO som_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalale'elna wuxuu jiray shan iyo lixdan sannadood, wuxuuna dhalay Yaared. ");
INSERT INTO som_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Mahalale'elna markuu Yaared dhalay ka dib wuxuu noolaa siddeed boqol iyo soddon sannadood, wiilal iyo gabdhona wuu dhalay. ");
INSERT INTO som_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Wakhtigii Mahalale'el noolaa oo dhammuna wuxuu ahaa siddeed boqol iyo shan iyo sagaashan sannadood, dabadeedna wuu dhintay. ");
INSERT INTO som_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yaaredna wuxuu jiray boqol iyo laba iyo lixdan sannadood, wuxuuna dhalay Enoog. ");
INSERT INTO som_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Yaaredna markuu Enoog dhalay ka dib wuxuu noolaa siddeed boqol oo sannadood, wiilal iyo gabdhona wuu dhalay. ");
INSERT INTO som_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Wakhtigii Yaared noolaa oo dhammuna wuxuu ahaa sagaal boqol iyo laba iyo lixdan sannadood; wuuna dhintay. ");
INSERT INTO som_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enoogna wuxuu jiray shan iyo lixdan sannadood, wuxuuna dhalay Metushelax. ");
INSERT INTO som_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Enoogna wuxuu la socday Ilaah saddex boqol oo sannadood markuu Metushelax dhalay ka dib, wiilal iyo gabdhona wuu dhalay. ");
INSERT INTO som_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Wakhtigii Enoog jiray oo dhammuna wuxuu ahaa saddex boqol iyo shan iyo lixdan sannadood. ");
INSERT INTO som_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enoogna Ilaah buu la socday; waana la waayay; maxaa yeelay, Ilaah baa qaatay isagii. ");
INSERT INTO som_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metushelaxna wuxuu jiray boqol iyo toddoba iyo siddeetan sannadood, wuxuuna dhalay Lameg. ");
INSERT INTO som_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Metushelaxna wuxuu noolaa markuu Lameg dhalay ka dib toddoba boqol iyo laba iyo siddeetan sannadood, wiilal iyo gabdhona wuu dhalay. ");
INSERT INTO som_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Wakhtigii Metushelax noolaa oo dhammuna wuxuu ahaa sagaal boqol iyo sagaal iyo lixdan sannadood; dabadeedna wuu dhintay. ");
INSERT INTO som_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamegna wuxuu jiray boqol iyo laba iyo siddeetan sannadood; wuxuuna dhalay wiil: ");
INSERT INTO som_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","magiciisiina wuxuu u bixiyey Nuux, isagoo leh, Kanu waa inooga raaxayn doonaa shuqulkeenna iyo hawsha gacmaheenna, xagga dhulka Ilaah habaaray. ");
INSERT INTO som_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Lamegna markuu Nuux dhalay ka dib wuxuu noolaa shan boqol iyo shan iyo sagaashan sannadood, wiilal iyo gabdhona wuu dhalay. ");
INSERT INTO som_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Wakhtigii Lameg noolaa oo dhammuna wuxuu ahaa toddoba boqol iyo toddoba iyo toddobaatan sannadood; dabadeedna wuu dhintay. ");
INSERT INTO som_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nuuxna wuxuu jiray shan boqol oo sannadood; wuxuuna dhalay Sheem, iyo Xaam, iyo Yaafed. ");
INSERT INTO som_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Waxayna noqotay, markii ay bilaabatay in dadku ku bataan dhulka oo ay gabdho u dhashaan, ");
INSERT INTO som_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","in wiilashii Ilaah arkeen gabdhihii dadku inay wanaagsan yihiin, oo ay guursadeen in alla intay doorteen oo dhan. ");
INSERT INTO som_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Rabbiguna wuxuu yidhi, Ruuxaygu lama sii dagaallami doono dadka weligiis, maxaa yeelay, isagu waa jidh, laakiinse cimrigiisu wuxuu noqon doonaa boqol iyo labaatan sannadood. ");
INSERT INTO som_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Waagaas waxaa dhulka joogay dad waaweyn oo xoog badan, taas ka dibna kolkii wiilashii Ilaah u yimaadeen gabdhihii dadka, oo ay carruur u dhaleen, isla kuwaas waxay ahaayeen nimankii xoogga badnaa oo waagii hore ahaa raggii caanka ahaa. ");
INSERT INTO som_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Rabbiguna wuxuu arkay in dadka sharkiisu ku badan yahay dhulka, iyo in male kasta oo fikirrada qalbigiisu ay shar keliya yihiin had iyo goorba. ");
INSERT INTO som_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Rabbiguna wuxuu ka qoomamooday abuuriddii uu dadka ku abuuray dhulka, wuuna caloolxumaaday. ");
INSERT INTO som_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Oo Rabbigu wuxuu yidhi, Waxaan dhulka ka baabbi'in doonaa dadkii aan abuuray; dadka, iyo weliba dugaagga, iyo waxa gurguurta, iyo haadda hawada; maxaa yeelay, waan ka qoomamooday samayntii aan sameeyey iyaga. ");
INSERT INTO som_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Laakiin Rabbigu Nuux raalli buu ka ahaa. ");
INSERT INTO som_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Kuwanu waa farcankii Nuux. Nuux wuxuu ahaa nin xaq ah, oo ku eed la' farcankiisii; Nuuxna Ilaah buu la socon jiray. ");
INSERT INTO som_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Oo Nuux wuxuu dhalay saddex wiil oo ahaa Sheem, iyo Xaam iyo Yaafed. ");
INSERT INTO som_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Dhulkuna wuu kharribnaa Ilaah hortiisa, dhulkana dulmi baa ka buuxsamay. ");
INSERT INTO som_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Ilaahna wuxuu arkay dhulka, oo bal eeg, wuu kharribnaa; waayo, intii jidh lahayd oo dhammu jidkooday ku kharribeen dhulka. ");
INSERT INTO som_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Oo Ilaah wuxuu Nuux ku yidhi, Intii jidh leh oo dhan dhammaadkoodii aan dhammayn lahaa ayaa gaadhay; waayo, dhulkii waxaa ka buuxsamay dulmi iyaga ka yimid, oo bal eeg, iyagaan dhulka la baabbi'in doonaa. ");
INSERT INTO som_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Doonni ka samayso qoryo gofer ah; qowladana ka dhex samee doonnida, daamurna ka mari dusha iyo hoostaba. ");
INSERT INTO som_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Waa inaad sidatan u samaysid iyada: doonnida dhererkeeda waxaad ka dhigtaa saddex boqol oo dhudhun, ballaadhkeedana waxaad ka dhigtaa konton dhudhun, sarajooggeedana waxaad ka dhigtaa soddon dhudhun. ");
INSERT INTO som_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Waa inaad dariishadna u samaysid doonnida, oo waxaad ku dhammaysaa in dhudhun ah ilaa xaggeeda sare, albaabka doonnidana dhinaca ka samee, dabaqad hoose, iyo tu labaad, iyo tu saddexaadna u samee iyada. ");
INSERT INTO som_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Oo bal eeg, anigu daad biyo ah baan ku soo dayn dhulka, inaan baabbi'iyo inta jidhka leh oo dhan oo neefta noloshu ku jirto, inta samada ka hoosaysa; wax kasta oo dhulka joogaaba way dhiman doonaan. ");
INSERT INTO som_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Laakiin axdigayga adigaan kula dhigan doonaa; oo doonnidaad soo geli doontaan, adiga, iyo wiilashaada, iyo naagtaada, iyo naagaha wiilashaada ee kula jiraba. ");
INSERT INTO som_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Oo wax kasta oo nool oo jidh leh waa inaad cayn walba laba ka soo gelisaa doonnida, si ay kuula sii noolaadaan; waana inay ahaadaan lab iyo dhaddig. ");
INSERT INTO som_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Haadda caynkooda, iyo xoolaha caynkooda, iyo wax kasta oo dhulka gurguurta caynkooda, cayn walba laba ka mid ihi ha kuu soo galeen, si ay u sii noolaadaan. ");
INSERT INTO som_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Cuntada la cuno oo dhanna qaado, oo kulligeed ururso oo waxay idiin noqon doontaa cunto, adiga iyo iyagaba. ");
INSERT INTO som_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Sidaasuu Nuux sameeyey; wax kasta sidii Ilaah ugu amray buu u sameeyey. ");
INSERT INTO som_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Oo Rabbigu wuxuu Nuux ku yidhi, Adiga iyo dadka gurigaaguba soo gala doonnida; waayo, waxaan arkay adigoo qarnigan xaq ku ah hortayda. ");
INSERT INTO som_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Xoolaha daahirka ah toddoba iyo toddoba ka qaad, ku lab iyo dhaddiggiis; xoolaha aan daahirka ahaynna laba ka qaad, ku lab iyo dhaddiggiis; ");
INSERT INTO som_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","haadda hawadana toddoba iyo toddoba ka qaad, lab iyo dhaddig: si farcan ugu sii noolaado dhulka dushiisa oo dhan. ");
INSERT INTO som_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Waayo, waxaa weli hadhay toddoba maalmood, dabadeedna afartan maalmood iyo afartan habeen ayaan roob ku soo dayn dhulka; oo wax kasta oo nool oo aan sameeyey waan ka baabbi'in doonaa dhulka dushiisa. ");
INSERT INTO som_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Nuuxna wax kasta sidii Rabbigu ugu amray ayuu u sameeyey. ");
INSERT INTO som_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Nuuxna wuxuu jiray lix boqol oo sannadood markii daadka biyuhu dhulka dul joogay. ");
INSERT INTO som_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nuuxna doonniduu galay, isagii iyo wiilashiisii iyo naagtiisii, iyo naagihii wiilashiisii ee la jiray oo dhan, waxayna ka soo galeen biyihii daadka. ");
INSERT INTO som_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Xoolihii daahirka ahaa, iyo xoolihii aan daahirka ahayn, iyo haaddii iyo wax kasta oo dhulka gurguurtaba ");
INSERT INTO som_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Nuux bay laba laba ugu galeen doonnidii, lab iyo dhaddig, sidii Ilaah ugu amray Nuux. ");
INSERT INTO som_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Waxaana dhacday, in toddobadii maalmood dabadeed, ay biyihii daadka ahaa dhulka dul joogeen. ");
INSERT INTO som_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Sannaddii uu Nuux lix boqol oo sannadood jiray, bisheedii labaad, maalintii toddoba iyo tobnaad oo bisha, isla maalintaas ayaa ilihii moolka weyn biyo ka buqdeen, dariishadihii samadana la furay. ");
INSERT INTO som_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Roobkuna wuxuu dhulka ku da'ayay afartan maalmood iyo afartan habeen. ");
INSERT INTO som_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Isla maalintaas Nuux wuxuu galay doonnidii, isagii iyo Sheem, iyo Xaam, iyo Yaafed, oo ahaa wiilashii Nuux, iyo naagtii Nuux, iyo saddexdii naagood oo wiilashiisa ee la jiray; ");
INSERT INTO som_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","iyagii, iyo dugaag kasta caynkiisa, iyo xoolo kasta caynkooda, iyo wax kasta oo dhulka gurguurta caynkooda, iyo haad kasta caynkiisa, iyo shimbir kasta oo cayn kasta ah. ");
INSERT INTO som_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Wax kasta oo jidh leh oo neefta noloshu ku jirtaba Nuux bay laba laba ugu galeen doonnidii. ");
INSERT INTO som_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Oo kuwii galay waxay ahaayeen lab iyo dhaddig oo wax kasta oo jidh leh, sidii Ilaah ku amray isagii: oo Ilaahna waa ku xidhay isagii. ");
INSERT INTO som_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Daadkiina afartan maalmood buu dhulka dul joogay; biyihiina way sii kordheen, oo doonnidii bay kor u qaadeen, oo waxaa iyadii kor looga qaaday dhulka. ");
INSERT INTO som_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Biyihiina way xoogaysteen, oo dhulkay aad ugu kordheen; doonnidiina waxay dul socotay biyihii. ");
INSERT INTO som_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Biyihiina aad bay ugu xoogaysteen dhulka; oo dhammaan buurihii dhaadheeraa oo samada oo dhan ka hooseeyey way qarsoomeen. ");
INSERT INTO som_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Shan iyo toban dhudhun baa biyihii xagga sare xoog ugu kaceen; buurihiina way qarsoomeen. ");
INSERT INTO som_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Oo wax kasta oo jidh leh oo dhulka ku dul dhaqaaqaaba way dhinteen, haaddii, iyo xoolihii, iyo dugaaggii, iyo wax kasta oo dhulka gurguurta, iyo dadkii oo dhanba. ");
INSERT INTO som_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Wax walba oo dhulka engegan joogay oo dulalka sankiisa ay neefta ruuxa nolosha ku jirtay, way wada dhinteen. ");
INSERT INTO som_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Waxaa la wada baabbi'iyey wixii dhulka dushiisa ku noolaa oo dhan, xataa dadkii, iyo xoolihii, iyo wixii gurguuran jiray, iyo haaddii cirka; kulli waa laga wada baabbi'iyey dhulka; oo waxaa hadhay Nuux oo keliya, iyo kuwii doonnidii kula jiray isagii. ");
INSERT INTO som_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Biyihiina boqol iyo konton maalmood ayay dhulka xoog ku lahaayeen. ");
INSERT INTO som_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Oo Ilaah wuxuu xusuustay Nuux, iyo wixii noolaa, iyo xoolihii doonnidii kula jiray isagii oo dhan; oo Ilaah dabayl buu dhulka dul mariyey, biyihiina way dhinmeen; ");
INSERT INTO som_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","ilihii moolka iyo dariishadihii samaduna way awdmeen; roobkii samadana waa la joojiyey; ");
INSERT INTO som_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","biyihiina had iyo goorba dhulkay ka noqonayeen, oo boqol iyo konton maalmood dabadood ayaa biyihii dhinmeen. ");
INSERT INTO som_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Oo bishii toddobaad, maalinteedii toddoba iyo tobnaad, ayay doonnidii ku fadhiisatay buuraha Araarad. ");
INSERT INTO som_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Biyihiina way sii dhinmayeen ilaa bishii tobnaad. Bishii tobnaad, maalinteedii kowaad, ayaa buuraha dushoodii la arkay. ");
INSERT INTO som_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Waxaana dhacday in afartan maalmood dabadood Nuux furay dariishaddii doonnidii uu sameeyey; ");
INSERT INTO som_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","oo wuxuu dibadda u diray tuke, hor iyo dib buuna u duulayay, ilaa intay biyihii ka engegeen dhulka dushiisa. ");
INSERT INTO som_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Dabadeedna wuxuu diray qoolley si uu u ogaado bal in biyihii dhulka dushiisa ka yaraadeen iyo in kale; ");
INSERT INTO som_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","laakiin qoolleydii meel ay cagta dhigto ayay weyday, kolkaasay Nuux xaggiisii ku soo noqotay iyo xaggii doonnidii, maxaa yeelay, biyihii baa dhulka oo dhan dul joogay; kolkaasuu gacanta dibadda u bixiyey, oo soo qabtay iyadii, oo soo geliyey doonnidii. ");
INSERT INTO som_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Kolkaasuu toddoba maalmood oo kale sugay; markaasuu mar kale qoolleydii doonnidii ka diray; ");
INSERT INTO som_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","qoolleydiina waxay isagii ku soo noqotay fiidkii; oo afkana waxay ku wadatay caleen saytuun oo qoyan; kolkaasuu Nuux ogaaday in biyihii dhulka ka yaraadeen. ");
INSERT INTO som_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Kolkaasuu toddoba maalmood oo kale sugay; dabadeedna qoolleydii buu diray; iyadiina mar dambe kuma ay soo noqon. ");
INSERT INTO som_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Oo waxaana dhacday sannaddii lix boqol iyo kowaad, bishii kowaad, maalinteedii kowaad, inay biyihii dhulka ka engegeen: Nuuxna daboolkii buu doonnidii ka qaaday, wuuna fiiriyey, oo bal eeg, dhulka dushiisu way engegnayd. ");
INSERT INTO som_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Oo bishii labaad, maalinteedii toddoba iyo labaatanaad, ayaa dhulka engegay. ");
INSERT INTO som_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Ilaahna Nuux buu la hadlay, isagoo leh, ");
INSERT INTO som_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Doonnida ka baxa adiga, iyo naagtaada, iyo wiilashaada, iyo naagaha wiilashaada ee kula jiraba. ");
INSERT INTO som_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Soo bixi wax kasta oo nool oo kula jooga, inta jidhka leh oo dhan, kuwaas oo ah haadda, iyo xoolaha, iyo waxa dhulka gurguurta oo dhan; si ay dhulka ugu bataan, oo ay wax badan u dhalaan, oo ay dhulka ugu tarmaan. ");
INSERT INTO som_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Nuuxna wuu baxay, isagii iyo wiilashiisii, iyo naagtiisii, iyo naagihii wiilashiisa ee la jirayba. ");
INSERT INTO som_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Dugaag kasta, iyo wax kasta oo gurguurta, iyo haad kasta, iyo wax alla wixii dhulka ku dhaqaaqaaba, jinsigoodii ayay doonnidii kala soo baxeen. ");
INSERT INTO som_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Nuuxna meel allabari buu Rabbiga u dhisay; xayawaankii daahirka ahaa iyo haaddii daahirka ahaydba, intuu wax ka qaatay, ayuu allabaryo la gubo ku bixiyey meeshii allabariga dusheeda. ");
INSERT INTO som_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Rabbiguna wuxuu uriyey caraftii udgoonayd, kolkaasuu Rabbigu iska yidhi qalbigiisa, Mar dambe dadka aawadiis dhulka uma habaari doono, maxaa yeelay, malaha qalbiga dadku waa shar tan iyo yaraantiisa; mar dambena ma aan dili doono wax kasta oo nool sidii aan yeelay. ");
INSERT INTO som_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Intuu dhulku jiro, beer abuurid, iyo beer goosasho, iyo qabow iyo kulayl, iyo gu iyo jiilaal, iyo habeen iyo maalin midnaba ma joogsan doono. ");
INSERT INTO som_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Oo Ilaah waa barakeeyey Nuux iyo wiilashiisii, oo wuxuu ku yidhi, Wax badan dhala, oo tarma, oo dhulka ka buuxsama. ");
INSERT INTO som_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Cabsidiinna iyo baqdintiinnu way la jiri doonaan dugaag kasta, iyo haad kasta oo hawada, iyo waxa dhulka gurguurta oo dhan, iyo kalluunka badda oo dhan, gacmihiinna baa laydiin geliyey iyaga. ");
INSERT INTO som_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Wax kasta oo dhaqdhaqaaqa oo noolu cuntay idiin noqon doonaan; sidii aan geedaha cagaarka ah idiin siiyey ayaan kulli idiin siiyey. ");
INSERT INTO som_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Laakiin waa inaydnaan cunin hilibka noloshiisu la jirto, taasoo ah dhiiggiisa. ");
INSERT INTO som_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Oo hubaal dhiigga naftiinna waan weyddiin, oo waxaan weyddiin dugaag kasta iyo dadkaba, xataa nafta nin kasta walaalkiis waan weyddiin. ");
INSERT INTO som_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Ku kasta oo nin dhiiggiis daadiya, nin baa isna dhiiggiisa daadin doona: waayo, Ilaah araggiisuu ka sameeyey ninka. ");
INSERT INTO som_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Idinku wax badan dhala, oo tarma; aad iyo aadna ugu farcama dhulka, kuna tarma dhexdiisa. ");
INSERT INTO som_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Oo Ilaah Nuux buu la hadlay, iyo wiilashiisii la joogay, isagoo ku leh, ");
INSERT INTO som_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","Bal eega, anigu axdigayga baan idinku adkaynayaa, idinka iyo farcankiinna idinka dambeeya; ");
INSERT INTO som_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","iyo uun kasta oo nool oo idinla jooga, haadda iyo xoolaha, iyo dugaag kasta oo dhulka idinla jooga; oo ah in alla intii ka soo baxda doonnida, xataa dugaag kasta oo dhulka. ");
INSERT INTO som_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Oo waxaan idinku adkayn doonaa axdigayga; inta jidh leh oo dhan mar dambe biyo daad ah laguma baabbi'in doono; daad dambe oo dhulka baabbi'iyaana mar dambe ma jiri doono. ");
INSERT INTO som_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Oo Ilaah wuxuu yidhi, Waa tan calaamadii axdiga aan idinla dhiganayo idinka iyo uun kasta oo nool oo idinla jooga, tan iyo qarni kasta. ");
INSERT INTO som_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Waxaan qaansadayda ku dhex dhigay daruurta, waxayna noqon doontaa calaamadii axdiga dhex yaal aniga iyo dhulka. ");
INSERT INTO som_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Waxaana dhici doonta, markii aan dhulka daruur dul keeno, in qaansada lagu arki doono daruurta dhexdeeda, ");
INSERT INTO som_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","oo waxaan xusuusan doonaa axdigayga ina dhex yaal aniga iyo idinka iyo uun kasta oo nool oo jidh kasta leh; biyuhuna dib dambe ma noqon doonaan daad baabbi'iya inta jidh leh oo dhan. ");
INSERT INTO som_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Qaansaduna waxay ku dhex jiri doontaa daruurta; anna waan fiirin doonaa iyada, inaan xusuusto axdiga weligiis dhex yaal Ilaah iyo uun kasta oo nool oo jidh kasta leh oo dhulka jooga. ");
INSERT INTO som_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Oo Ilaah wuxuu Nuux ku yidhi, Tanu waa calaamadii axdigii aan ku adkeeyey inta jidhka leh oo dhulka joogta. ");
INSERT INTO som_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Oo wiilashii Nuux oo doonnidii ka soo baxay, waxay ahaayeen Sheem, iyo Xaam, iyo Yaafed: Xaamna waa Kancaan aabbihiis. ");
INSERT INTO som_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Saddexdanu waxay ahaayeen wiilashii Nuux; oo iyagii farcankoodii baa dhulka oo dhan ku fiday. ");
INSERT INTO som_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nuuxna wuxuu bilaabay inuu beerrey noqdo, oo wuxuu beertay canab. ");
INSERT INTO som_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Kolkaasuu wax ka cabbay khamrigeedii, wuuna sakhraamay; oo teendhadiisii dhexdeeda ayuu ku qaawanaa. ");
INSERT INTO som_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Oo Xaam, oo ahaa Kancaan aabbihiis, ayaa arkay qaawanaantii aabbihiis, kolkaasuu u sheegay labadii walaalihiis ahayd oo dibadda joogta. ");
INSERT INTO som_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Kolkaasaa Sheem iyo Yaafed dhar qaadeen, oo labadoodu garbahay saareen, oo dib dib u socdeen, kolkaasay qaawanaantii aabbahood ku dedeen, oo wejiyadooduna way sii jeedeen, mana ay arkin qaawanaantii aabbahood. ");
INSERT INTO som_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Nuuxna khamrigiisii wuu ka soo miyirsaday, wuuna ogaaday wixii wiilkiisa yaru ku sameeyey. ");
INSERT INTO som_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Kolkaasuu yidhi, Inkaaru ha ku dhacdo Kancaan; Addoonkii addoommaduu u noqon doonaa walaalihiis. ");
INSERT INTO som_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Oo wuxuu yidhi, Ammaanu ha u ahaato Rabbiga ah Ilaaha Sheem, Kancaanna addoon ha u noqdo. ");
INSERT INTO som_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Ilaah ha fidiyo Yaafed, Hana dego teendhooyinka Sheem; Kancaanna addoon ha u noqdo isaga. ");
INSERT INTO som_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Nuuxna daadka ka dib wuxuu sii noolaa saddex boqol iyo konton sannadood. ");
INSERT INTO som_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Wakhtigii Nuux noolaa oo dhammuna waxay ahaayeen sagaal boqol iyo konton sannadood; dabadeedna wuu dhintay. ");
INSERT INTO som_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Haddaba kuwanu waa farcankii wiilashii Nuux, kuwaas oo ahaa Sheem, Xaam iyo Yaafed: oo wiilal baa u dhashay iyaga daadkii dabadiis. ");
INSERT INTO som_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Wiilashii Yaafed waxay ahaayeen Gomer, iyo Maajuuj, iyo Maaday, iyo Yaawaan, iyo Tubal, iyo Mesheg, iyo Tiiraas. ");
INSERT INTO som_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Wiilashii Gomerna waxay ahaayeen Ashkenas, iyo Riifad, iyo Togarmaah. ");
INSERT INTO som_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Wiilashii Yaawaanna waxay ahaayeen Eliishah, iyo Tarshiish, iyo Kitiim iyo Dodaaniim. ");
INSERT INTO som_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Kuwaasay jasiiradihii quruumuhu ugu kala qaybsameen waddammadoodii, dad kasta sidii afkoodii, iyo qabiilooyinkoodii, iyo quruumahoodii ay ahaayeen. ");
INSERT INTO som_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Wiilashii Xaamna waxay ahaayeen Kuush, iyo Misrayim, iyo Fuud, iyo Kancaan. ");
INSERT INTO som_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Wiilashii Kuushna waxay ahaayeen Sebaa, iyo Xawiilaah, iyo Sabtaah, iyo Racmaah, iyo Sabteka: wiilashii Racmaahna waxay ahaayeen Shebaa, iyo Dedaan. ");
INSERT INTO som_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kuushna wuxuu dhalay Nimrod: wuxuuna bilaabay inuu noqdo mid dhulka xoog weyn ku leh. ");
INSERT INTO som_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Wuxuu ahaa ugaadhsade ku xoog weyn Rabbiga hortiisa: taas daraaddeed waxaa la yidhaahdaa, Sidii Nimrod ugaadhsade xoog weyn Rabbiga hortiisa. ");
INSERT INTO som_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Bilowgii boqortooyadiisu waxay ahayd Baabel, iyo Ereg, iyo Akad, iyo Kalneh, waxayna ku yiilleen waddankii Shincaar. ");
INSERT INTO som_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Dhulkaas wuu ka tegey oo wuxuu galay Ashuur, wuxuuna dhisay Nineweh, iyo Rexobod, iyo Kaalah, ");
INSERT INTO som_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","iyo Resen oo u dhexeeyey Nineweh iyo Kaalah, (taasuna waxay tahay magaalada weyn). ");
INSERT INTO som_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misrayimna wuxuu dhalay Luudiim, iyo Canaamiim, iyo Lehaabiim iyo Naftuxiim, ");
INSERT INTO som_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","iyo Fatrusiim iyo Kasluxiim (oo ay reer Falastiin ka yimaadeen), iyo Kaftoriim. ");
INSERT INTO som_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kancaanna wuxuu dhalay Siidoon oo ahaa curadkiisii, iyo Xeed; ");
INSERT INTO som_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","iyo reer Yebuus, iyo reer Amor, iyo reer Girgaash; ");
INSERT INTO som_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","iyo reer Xiwi, iyo reer Carqi, iyo reer Siini; ");
INSERT INTO som_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","iyo reer Arwaad, iyo reer Semaar, iyo reer Xamaad: dabadeedna qabiilooyinkii Kancaan way kala firdheen. ");
INSERT INTO som_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Oo soohdintii reer Kancaan waxay ka bilaabmaysay Siidoon, markii loo kaco xagga Geraar, ilaa Gaasa, oo markii loo kaco xagga Sodom iyo Gomora iyo Admah iyo Seboyim, ilaa Laashac. ");
INSERT INTO som_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Kuwanu waxay ahaayeen wiilashii Xaam, sidii qabiilooyinkoodii, iyo afafkoodii, iyo waddammadoodii, iyo quruumahoodii ay ahaayeen. ");
INSERT INTO som_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Sheem oo aabbe u ahaa carruurtii Ceeber oo dhan, oo ahaa Yaafed walaalkiisii weynaa, isagana carruur baa u dhalatay. ");
INSERT INTO som_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Wiilashii Sheemna waxay ahaayeen Ceelaam, iyo Ashuur, iyo Arfaksad, iyo Luud, iyo Araam. ");
INSERT INTO som_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Wiilashii Araamna waxay ahaayeen Cuus, iyo Xuul, iyo Geter, iyo Mash. ");
INSERT INTO som_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arfaksadna wuxuu dhalay Salah; Salahna wuxuu dhalay Ceeber. ");
INSERT INTO som_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ceeberna waxaa u dhashay laba wiil: mid magiciisu wuxuu ahaa Feleg; waayo, waagiisii ayaa dhulku qaybsamay; magaca walaalkiisna wuxuu ahaa Yoqtaan. ");
INSERT INTO som_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yoqtaanna wuxuu dhalay Almoodaad, iyo Shelef, iyo Xasarmaawed, iyo Yerah; ");
INSERT INTO som_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","iyo Hadooraam, iyo Uusaal, iyo Diqlah; ");
INSERT INTO som_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","iyo Coobaal, iyo Abiimaa'el, iyo Shebaa; ");
INSERT INTO som_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","iyo Oofir, iyo Xawiilaah, iyo Yoobaab: kuwaasu kulli waxay ahaayeen wiilashii Yoqtaan. ");
INSERT INTO som_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Meeshay degganaayeenna waxay ka bilaabmaysay Meesha, markii loo kaco xagga Sefaar, buurta bari. ");
INSERT INTO som_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Kuwanu waxay ahaayeen wiilashii Sheem; sidii qabiilooyinkoodii, iyo afafkoodii, iyo waddammadoodii, iyo quruumahoodii ay ahaayeen. ");
INSERT INTO som_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Kuwanu waa qabiilooyinkii wiilashii Nuux; sidii farcankoodii iyo quruumahoodii ay ahaayeen; oo kuwanaa quruumuhu ka kala qaybsameen daadkii dabadiis. ");
INSERT INTO som_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Dhulka oo dhammuna wuxuu ahaa isku af iyo isku hadal keliya. ");
INSERT INTO som_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Waxaana dhacday markay xagga bari u sii socdaaleen inay waddankii Shincaar meel bannaan ka heleen; oo halkaas ayay degeen. ");
INSERT INTO som_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Oo waxay isku yidhaahdeen, Ina keena, aynu leben samaysannee, oo aynu aad u dubnee. Oo waxay dhagaxa meeshiisa u haysteen leben, nuuradda meesheedana dhoobo. ");
INSERT INTO som_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Oo waxay yidhaahdeen, Ina keena, aynu magaalo dhisannee, iyo munaarad dhaladeedu samada gaadho, oo aynu magac yeelannee, waaba intaasoo aynu dhulka dushiisa oo dhan ku kala firidhnaaye. ");
INSERT INTO som_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Rabbiguna wuxuu u soo degay inuu arko magaaladii iyo munaaraddii ay binu-aadmigu dhisayeen. ");
INSERT INTO som_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Oo Rabbigu wuxuu yidhi, Bal eega, iyagu waa isku dad keliya, oo dhammaan isku af keliya bay leeyihiin, oo waxanuna waa waxa ay bilaabayaan inay sameeyaan, oo haatan wax ka hor joogsan doona waxay damcaan inay sameeyaan ma jiraane. ");
INSERT INTO som_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Ina keena, aynu degnee, oo halkaas aynu afkooda iskaga qasnee, yaan midna midka kale hadalkiisa garanine. ");
INSERT INTO som_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Kolkaasaa Rabbigu halkaas ka kaxeeyey oo ku kala firdhiyey dhulka dushiisa oo dhan, oo dhisiddii magaaladii way joojiyeen. ");
INSERT INTO som_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Sidaas daraaddeed magaceedii waxaa loo bixiyey Baabel, maxaa yeelay, halkaasaa Rabbigu afkii dhulka oo dhan iskaga qasay; oo halkaasuu Rabbigu ka kaxeeyey iyagii oo ku kala firdhiyey dhulka dushiisa oo dhan. ");
INSERT INTO som_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Kuwanu waa farcankii Sheem. Sheem wuxuu jiray boqol sannadood, oo laba sannadood oo daadkii ka dambaysay wuxuu dhalay Arfaksad. ");
INSERT INTO som_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Sheemna markuu Arfaksad dhalay ka dib wuxuu noolaa shan boqol oo sannadood, wiilal iyo gabdhona wuu dhalay. ");
INSERT INTO som_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arfaksadna wuxuu jiray shan iyo soddon sannadood, wuxuuna dhalay Salah: ");
INSERT INTO som_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Arfaksadna markuu Salah dhalay ka dib wuxuu noolaa afar boqol iyo saddex sannadood, wiilal iyo gabdhona wuu dhalay. ");
INSERT INTO som_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Salahna wuxuu jiray soddon sannadood, wuxuuna dhalay Ceeber. ");
INSERT INTO som_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Salahna markuu Ceeber dhalay ka dib wuxuu noolaa afar boqol iyo saddex sannadood, wiilal iyo gabdhona wuu dhalay. ");
INSERT INTO som_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ceeberna wuxuu jiray afar iyo soddon sannadood, wuxuuna dhalay Feleg: ");
INSERT INTO som_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Ceeberna markuu Feleg dhalay ka dib wuxuu noolaa afar boqol iyo soddon sannadood, wiilal iyo gabdhona wuu dhalay. ");
INSERT INTO som_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Felegna wuxuu jiray soddon sannadood, wuxuuna dhalay Recu: ");
INSERT INTO som_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Felegna markuu Recu dhalay ka dib wuxuu noolaa laba boqol iyo sagaal sannadood, wiilal iyo gabdhona wuu dhalay. ");
INSERT INTO som_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Recuna wuxuu jiray laba iyo soddon sannadood, wuxuuna dhalay Seruug. ");
INSERT INTO som_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Recuna markuu Seruug dhalay ka dib wuxuu noolaa laba boqol iyo toddoba sannadood, wiilal iyo gabdhona wuu dhalay. ");
INSERT INTO som_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Seruugna wuxuu jiray soddon sannadood, wuxuuna dhalay Naaxoor: ");
INSERT INTO som_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Seruugna markuu Naaxoor dhalay ka dib wuxuu noolaa laba boqol oo sannadood, wiilal iyo gabdhona wuu dhalay. ");
INSERT INTO som_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Naaxoorna wuxuu jiray sagaal iyo labaatan sannadood, wuxuuna dhalay Terax; ");
INSERT INTO som_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Naaxoorna markuu Terax dhalay ka dib wuxuu noolaa boqol iyo sagaal iyo toban sannadood, wiilal iyo gabdhona wuu dhalay. ");
INSERT INTO som_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Teraxna wuxuu jiray toddobaatan sannadood, wuxuuna dhalay Aabraam, iyo Naaxoor, iyo Haaraan. ");
INSERT INTO som_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Kuwanu waa farcankii Terax. Terax wuxuu dhalay Aabraam, iyo Naaxoor, iyo Haaraan; Haaraanna wuxuu dhalay Luud. ");
INSERT INTO som_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haaraanna wuxuu dhintay aabbihiis Terax oo jooga, wuxuuna ku dhintay dhulkii uu ku dhashay, oo la odhan jiray Uur tii reer Kaldayiin. ");
INSERT INTO som_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Aabraam iyo Naaxoorna way guursadeen: Aabraam naagtiisii waxaa la odhan jiray Saaray; naagtii Naaxoorna waxaa la odhan jiray Milkah, waxayna ahayd gabadhii Haaraan, aabbihii Milkah iyo Iskah. ");
INSERT INTO som_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Saarayna waxay ahayd madhalays; ilmona ma ay lahayn. ");
INSERT INTO som_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Teraxna wuxuu kaxaystay wiilkiisii Aabraam, iyo Luud oo ahaa ina Haaraan, wiilkii wiilkiisii, iyo Saaray oo uu soddog u ahaa, oo ahayd naagtii wiilkiisii Aabraam; wayna kala baxeen Uur tii reer Kaldayiin, si ay u tagaan dalkii Kancaan; waxayna yimaadeen Haaraan, oo halkaasay degeen. ");
INSERT INTO som_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Wakhtigii Terax noolaa wuxuu ahaa laba boqol iyo shan sannadood, Teraxna wuxuu ku dhintay Haaraan. ");
INSERT INTO som_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Rabbigu wuxuu Aabraam ku yidhi, Ka tag waddankaaga, iyo xigaalkaaga, iyo reerka aabbahaaba, oo dalka aan ku tusi doono u kac. ");
INSERT INTO som_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Oo quruun weyn baan kaa dhigi doonaa, oo waan ku barakayn doonaa, magacaagana waan weynayn doonaa; oo waxaad noqon doontaa barako; ");
INSERT INTO som_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","oo waan barakayn doonaa kuwa kuu duceeya, kan ku habaarana waan habaari doonaa: oo qabiilooyinka dhulka oo dhammu adigay kugu barakoobi doonaan. ");
INSERT INTO som_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Markaasaa Aabraam tegey, sidii Rabbigu ku yidhi; Luudna wuu raacay. Aabraam shan iyo toddobaatan sannadood buu jiray markuu Haaraan ka tegey. ");
INSERT INTO som_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Aabraamna wuxuu kaxaystay naagtiisii Saaray, iyo Luud oo ahaa wiilkii walaalkiis, iyo xoolahoodii ay urursadeen oo dhan, iyo dadkii ay Haaraan ka heleen oo dhan; kolkaasay u kaceen dalkii Kancaan, oo waxay yimaadeen dalkii Kancaan. ");
INSERT INTO som_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Aabraamna dalkii buu dhex maray ilaa meeshii la odhan jiray Shekem iyo tan iyo geedkii Moreh. Wakhtigaasna reer Kancaan dalkay joogeen. ");
INSERT INTO som_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Oo Ilaah baa Aabraam u muuqday, oo ku yidhi, Dalkan farcankaagaan siin doonaa. Kolkaasuu meeshaas meel allabari uga dhisay Rabbigii u muuqday. ");
INSERT INTO som_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Markaasuu meeshaas ka guuray, oo wuxuu tegey buurtii xagga bari ka ahayd Beytel, oo teendhadiisii buu ka dhistay meel Beytel galbeed ka ahayd, Aaciina bari ka ahayd; markaasuu meeshaas meel allabari Rabbiga uga dhisay, oo magaca Rabbiga ku baryootamay. ");
INSERT INTO som_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Kolkaasaa Aabraam socdaalay, isagoo weli xagga koonfureed u sii socda. ");
INSERT INTO som_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Kolkaasaa dhulkii abaari ka dhacday: markaasuu Aabraam Masar tegey; inuu halkaas qariib ku ahaado, waayo, abaartii aad bay dhulkii ugu xumayd. ");
INSERT INTO som_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Oo waxay noqotay in markii uu ku soo dhowaaday inuu Masar galo, uu ku yidhi naagtiisii Saaray, Bal eeg, waan ogahay inaad tahay naag arag quruxsan, ");
INSERT INTO som_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","oo waxaa dhici doona in markii ay Masriyiintu ku arkaan, ay odhan doonaan, Waa naagtiisii tanu. Oo way i dili doonaan, laakiin adiga way ku dayn doonaan. ");
INSERT INTO som_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Waxaad ku tidhaahdaa, Walaashiis baan ahay; si ay iigu roonaadaan adiga aawadaa, oo ay naftaydu daraaddaa u noolaato. ");
INSERT INTO som_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Oo waxay noqotay in markii Aabraam Masar soo galay, ay Masriyiintii arkeen in naagtu aad u quruxsan tahay. ");
INSERT INTO som_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Oo amiirradii Fircoon baa arkay, oo Fircoon bay u ammaaneen iyadii, oo naagtii waxaa loo kaxeeyey gurigii Fircoon. ");
INSERT INTO som_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Isaguna Aabraam si wanaagsan buu u qabtay iyada aawadeed: wuxuuna lahaa ido, iyo dibiyo, iyo dameerro lab, iyo niman addoommo ah, iyo naago addoommo ah, iyo dameerro dhaddig iyo geel. ");
INSERT INTO som_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Oo Rabbigu belaayooyin waaweyn buu ku riday Fircoon iyo reerkiisiiba, Saaray oo naagtii Aabraam ahayd aawadeed. ");
INSERT INTO som_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Fircoonna Aabraam buu u yeedhay, oo ku yidhi, Waa maxay waxan aad igu samaysay? Maxaad iigu sheegi weyday inay tahay naagtaadii? ");
INSERT INTO som_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Maxaad u tidhi, Waa walaashay si aan u guursado iyada? Haddaba waa tan naagtaadii, kaxayso oo iska tag. ");
INSERT INTO som_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Fircoonna niman buu u soo amray isaga: wayna soo ambabbixiyeen isagii iyo naagtiisii, iyo wuxuu haystay oo dhan. ");
INSERT INTO som_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Aabraamna Masar wuu ka baxay, isaga, iyo naagtiisii, iyo wuxuu haystay oo dhan, Luudna wuu raacay, oo wuxuu tegey xagga koonfureed. ");
INSERT INTO som_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Oo Aabraam hodan buu ka ahaa xagga xoolaha iyo lacagta iyo dahabka. ");
INSERT INTO som_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Xagga koonfureed ayuu ka tegey oo wuxuu u socdaalay ilaa Beytel, meeshii bilowgii ay teendhadiisu ahayd, ee u dhexaysay Beytel iyo Aacii; ");
INSERT INTO som_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","ilaa meeshii allabariga oo uu horraantii halkaas ka sameeyey; oo meeshaasuu Aabraam magaca Rabbiga kaga baryootamay. ");
INSERT INTO som_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Oo Luud, oo isna Aabraam la socday, wuxuu lahaa adhi, iyo lo', iyo teendhooyin. ");
INSERT INTO som_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Dhulkuna ma uu qaadi karin iyagii, hadday wada degganaan lahaayeen: waayo, xoolahoodu way badnaayeen, oo sidaas daraaddeed ma ay wada degganaan karin. ");
INSERT INTO som_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Dirir baana ku dhex jirtay xoolojirradii Aabraam iyo xoolojirradii Luud. Markaasna reer Kancaan iyo reer Feris dhulkaasay degganaayeen. ");
INSERT INTO som_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Oo Aabraam wuxuu Luud ku yidhi, Waxaan kaa baryayaa inaan diriru inaga dhex dhicin aniga iyo adiga, iyo xoolojirradayda iyo xoolojirradaada; maxaa yeelay, waxaynu nahay walaalo. ");
INSERT INTO som_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Dhulka oo dhammu sow kaa ma horreeyo? Waxaan kaa baryayaa inaad iga guurtid. Haddaad bidixda tagto, midigtaan tegayaa; haddaad midigta tagtona, bidixdaan tegayaa. ");
INSERT INTO som_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Kolkaasuu Luud indhihiisii kor u taagay, oo wuxuu arkay Bannaankii Webi Urdun oo dhan, iyo inay meel waluba aad u waraabsan tahay, intaan Rabbigu baabbi'in Sodom iyo Gomora; wuxuu u ekaa beertii Ilaah, iyo sida dalka Masar markaad tagto xagga Socar. ");
INSERT INTO som_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Markaasuu Luud wuxuu doortay Bannaankii Urdun oo dhan; oo Luud xagga bari buu u socdaalay; oo way kala guureen. ");
INSERT INTO som_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Aabraam wuxuu degay dalkii Kancaan, Luudna wuxuu degay magaalooyinkii Bannaanka ku yiil, oo teendhadiisii wuxuu u wareejiyey xagga Sodom. ");
INSERT INTO som_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Haddaba dadkii Sodom shar miidhan bay ahaayeen, Ilaahna aad iyo aad bay ugu dembaabeen. ");
INSERT INTO som_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Oo Rabbigu wuxuu Aabraam ku yidhi, intii Luud ka guuray ka dib, Indhahaaga kor u taag, oo meeshaad joogto ka fiiri, xagga woqooyi iyo xagga koonfureed, iyo xagga bari iyo xagga galbeedba; ");
INSERT INTO som_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","waayo, dhulka aad aragto oo dhan waxaan siin doonaa adiga iyo farcankaaga weligiin. ");
INSERT INTO som_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Farcankaagana waxaan ka dhigi doonaa sida ciidda dhulka; haddii nin ciidda dhulka tirin karo, farcankaagana waa la tirin doonaa. ");
INSERT INTO som_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Bal kac oo ku dhex soco dhulka dhererkiisa iyo ballaadhkiisa; waayo, adigaan ku siin doonaa. ");
INSERT INTO som_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Oo Aabraam teendhadiisii wuu wareejiyey, oo wuxuu yimid oo degay dhirtii Mamre, ee ku tiil Xebroon, oo halkaasuu Rabbiga meel allabari uga dhisay. ");
INSERT INTO som_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Oo waxaa dhacday waagii Amraafel boqorka u ahaa Shincaar, Aryoogna boqorka u ahaa Ellaasaar, Kedorlaacomerna boqorka u ahaa Ceelaam, Tidcaalna boqorka u ahaa Goyiim, ");
INSERT INTO som_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","inay la dirireen Berac oo boqor u ahaa Sodom, iyo Birshac oo boqor u ahaa Gomora, iyo Shinaab oo boqor u ahaa Admah, iyo Shemeeber oo boqor u ahaa Seboyim, iyo boqorkii Belac (oo iyana ahayd Socar). ");
INSERT INTO som_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Kuwanu waxay kulligood isugu yimaadeen Dooxo Siddiim (oo iyana ahayd Baddii Cusbada). ");
INSERT INTO som_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Laba iyo toban sannadood bay Kedorlaacomer u adeegeen, markaasay sannaddii saddex iyo tobnaad ku caasiyoobeen. ");
INSERT INTO som_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Sannaddii afar iyo tobnaadna waxaa yimid Kedorlaacomer, iyo boqorradii la jiray, oo waxay reer Refaa'iim ku dileen Cashterod Qarnayim, oo reer Suusiimna waxay ku dileen Haam, oo reer Eymiimna waxay ku dileen Shaweh Qiryaatayim, ");
INSERT INTO som_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","reer Xorna waxay ku dileen buurtoodii Seciir, iyo ilaa Aylfaaraan oo u dhowayd cidlada. ");
INSERT INTO som_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Oo way soo noqdeen, oo waxay yimaadeen Ceyn Mishfaad (oo iyana ahayd Qaadeesh), oo waxay dileen dadkii dalkii reer Camaaleq oo dhan, waxaa kale oo ay dileen reer Amor oo degganaa Hasason Tamar. ");
INSERT INTO som_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Oo waxaa soo baxay boqorkii Sodom, iyo boqorkii Gomora, iyo boqorkii Admah, iyo boqorkii Seboyim, iyo boqorkii Belac (oo iyana ahayd Socar); oo waxay Dooxo Siddiim ugu diyaargaroobeen inay la dagaallamaan ");
INSERT INTO som_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Kedorlaacomer oo ahaa boqorkii Ceelaam, iyo Tidcaal oo ahaa boqorkii Goyiim, iyo Amraafel oo ahaa boqorkii Shincaar, iyo Aryoog oo ahaa boqorkii Ellaasaar. Waxay ahaayeen afar boqor oo shantii boqor ka gees ah. ");
INSERT INTO som_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Haddaba Dooxo Siddiim waxaa ka buuxay boholo waaweyn oo dhoobo ah; oo boqorradii Gomora iyo Sodom way carareen, oo halkaasay ku dhaceen, intii kalena waxay u carareen xagga buurta. ");
INSERT INTO som_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Oo waxay qaateen alaabtii Sodom iyo Gomora oo dhan, iyo cuntadoodii oo dhan, wayna iska tageen. ");
INSERT INTO som_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Oo waxaa kaloo ay la tageen Luud, oo ahaa wiilkii Aabraam walaalkiis, oo Sodom degganaa, iyo alaabtiisii oo dhan, wayna iska tageen. ");
INSERT INTO som_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Oo waxaa yimid mid soo baxsaday, oo wuxuu u warramay Aabraam kii ahaa Cibraaniga isagoo ag deggan dhirtii Mamre kii ahaa reer Amor, oo Eshkol iyo Caaneer walaalkood ahaa. Kuwaasu Aabraam bay gaashaanbuur la ahaayeen. ");
INSERT INTO som_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Oo Aabraam markuu maqlay in walaalkiis maxbuus ahaan loola tegey ayuu soo kaxaystay raggiisii la tababbaray oo gurigiisa ku dhashay, iyagoo ah saddex boqol iyo siddeed iyo toban nin, oo wuxuu raacdo ku jiray ilaa Daan. ");
INSERT INTO som_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Oo habeennimo ayuu raggiisii u kala qaybiyey, isaga iyo addoommadiisiiba, oo waxay laayeen colkii, oo ay raacdaysteen ilaa Xoobah, oo Dimishaq xagga bidixda ka ah. ");
INSERT INTO som_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Oo alaabtii oo dhan buu soo celiyey, oo waxaa kale oo uu soo celiyey walaalkiis Luud, iyo alaabtiisii, iyo naagihii, iyo dadkiiba. ");
INSERT INTO som_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Markuu ka soo noqday layntii Kedorlaacomer iyo boqorradii la jiray ka dib ayaa boqorkii Sodom Aabraam kaga hor tegey Dooxo Shaweh oo ahayd Dooxadii Boqorka. ");
INSERT INTO som_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Oo Malkisadaq oo ahaa boqorkii Saalem baa keenay cunto iyo khamri: wuxuuna ahaa wadaadkii Ilaaha ugu sarreeya. ");
INSERT INTO som_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Oo Aabraam buu u duceeyay, oo yidhi, Ilaaha ugu sarreeya, ee leh samada iyo dhulkaba ha barakeeyo Aabraam. ");
INSERT INTO som_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Ammaan waxaa leh Ilaaha ugu sarreeya, oo cadaawayaashaadii gacantaada geliyey. Markaasaa Aabraam wuxuu isagii wax kasta ka siiyey toban meelood oo meel. ");
INSERT INTO som_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Boqorkii Sodom wuxuu Aabraam ku yidhi, Dadka uun i sii, alaabtana adigu iska qaado. ");
INSERT INTO som_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Laakiin Aabraam wuxuu boqorkii Sodom ku yidhi, Gacantaydaan kor u taagay oo waxaan ku dhaartay Rabbiga, kan ah Ilaaha ugu sarreeya, ee leh samada iyo dhulka, ");
INSERT INTO som_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","inaanan qaadanin miiq ama kab yeelmeheed ama wax adigu aad leedahay, waayo, waaba intaasoo aad tidhaahdaa, Anaa Aabraam hodan ka dhigaye. ");
INSERT INTO som_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Waxba qaadan maayo wixii ay ragga dhallinyarada ahu cuneen mooyaane, iyo qaybtii raggii i raacay. Caaneer iyo Eshkol, iyo Mamre ha qaateen qaybtooda. ");
INSERT INTO som_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Waxyaalahaas ka dib ereygii Ilaah baa Aabraam ugu yimid muuqasho ahaan, isagoo leh, Aabraamow, ha baqin: anigu waxaan ahay gaashaankaaga, abaalgudkaaguna aad buu u weynaan doonaa. ");
INSERT INTO som_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Oo Aabraam wuxuu yidhi, Sayidow Rabbiyow, maxaad i siin doontaa? Waayo, anigu carruurla'aan baan sii socdaa, reerkaygana waxaa dhaxli doona Eliiceser oo ah reer Dimishaq. ");
INSERT INTO som_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Oo Aabraam wuxuu yidhi, Bal eeg, aniga ima aad siin farcan: oo mid gurigayga ku dhashay baa i dhaxlaya. ");
INSERT INTO som_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Oo bal eeg, ereygii Rabbigaa u yimid, isagoo leh, Ninkanu kuma dhaxli doono: laakiinse waxaa ku dhaxli doona wiil aad dhali doontid. ");
INSERT INTO som_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Oo dibadduu u soo bixiyey, oo ku yidhi, Bal samada fiiri, oo xiddigaha tiri, haddaad tirin kartid: oo wuxuu ku yidhi, Sidaas oo kalaa farcankaagu ahaan doonaa. ");
INSERT INTO som_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Oo Rabbiga wuu rumaystay; Ilaahna taas wuxuu ugu tiriyey xaqnimo. ");
INSERT INTO som_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Oo wuxuu ku yidhi isaga, Anigu waxaan ahay Rabbiga kaaga soo kaxeeyey Uur tii reer Kaldayiin, inaan ku siiyo dalkan si aad u dhaxashid. ");
INSERT INTO som_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Oo Aabraam wuxuu yidhi, Sayidow Rabbiyow, maxaan ku ogaadaa inaan dhaxli doono? ");
INSERT INTO som_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Oo wuxuu ku yidhi, Ii kaxee qaalin lo' ah oo saddex jir ah, iyo ceesaan saddex jir ah, iyo wan saddex jir ah, iyo qoolley, iyo xamaam yar. ");
INSERT INTO som_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Oo wuu u kaxeeyey kuwaas oo dhan, oo badhtankuu ka kala wada gooyay, oo badh kastaba kan kaluu hor dhigay: laakiinse shimbirrihii ma uu kala gooyn. ");
INSERT INTO som_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Haad baana hilibkii ku soo degtay, laakiinse Aabraam baa ka eryay. ");
INSERT INTO som_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Oo kolkii qorraxdu sii dhacaysay, ayaa hurdo aad u weynu Aabraam ku soo dhacday; oo bal eeg, cabsi gudcur weyn leh baa ku soo degtay. ");
INSERT INTO som_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Markaasuu wuxuu ku yidhi Aabraam, Ogow in hubaal farcankaagu ay dad qalaad ku ahaan doonaan dal aan kooda ahayn, oo ay u adeegi doonaan, oo afar boqol oo sannadood waa la dhibi doonaa; ");
INSERT INTO som_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","oo weliba quruuntaas ay u adeegi doonaan, xukun baan ku ridi doonaa; oo dabadeedna way ka soo bixi doonaan iyagoo xoolo badan wata. ");
INSERT INTO som_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Laakiinse adigu nabad baad ugu tegi doontaa awowayaashaa, oo waxaa lagu xabaali doonaa adigoo cimri dheer gaadhay. ");
INSERT INTO som_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Oo iyagu qarniga afraad halkan bay ku soo noqon doonaan: waayo, dembigii reer Amor weli ma dhamma. ");
INSERT INTO som_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Oo waxay noqotay, markii qorraxdii dhacday oo ay ahayd gudcur, in girgire qiiqaya iyo dab ololaya ay dhex mareen cadadkii. ");
INSERT INTO som_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Maalintaas Rabbigu Aabraam buu axdi la dhigtay, isagoo leh, Farcankaagaan siiyey dhulkan, oo laga bilaabo webiga Masar ilaa webiga weyn, oo ah webi Yufraad: ");
INSERT INTO som_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","reer Qeyn, iyo reer Qenas, iyo reer Qadmon, ");
INSERT INTO som_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","iyo reer Xeed, iyo reer Feris, iyo reer Refaa'iim, ");
INSERT INTO som_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","iyo reer Amor, iyo reer Kancaan, iyo reer Girgaash, iyo reer Yebuus. ");
INSERT INTO som_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Saaray oo ahayd Aabraam naagtiisii carruur uma ay dhalin isagii: waxayna lahayd gabadh midiidin ah, oo Masriyad ah, magaceedana waxaa la odhan jiray Haagaar. ");
INSERT INTO som_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Oo Saaray waxay Aabraam ku tidhi, Bal eeg imminka, Rabbigu waa ii diiday inaan dhalo; haddaba waxaan kaa baryayaa inaad midiidintayda u tagto, mindhaa iyadaan carruur ka heli doonaaye, Aabraamna codkii Saaray buu maqlay. ");
INSERT INTO som_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Saaray oo ahayd naagtii Aabraam waxay kaxaysay Haagaar tii Masriyadda ahayd, oo midiidinteeda ahayd, markii Aabraam toban sannadood joogay dalkii Kancaan ka dib, oo waxay iyadii siisay ninkeedii Aabraam inay naagtiisii u noqoto. ");
INSERT INTO som_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Oo Haagaar buu u tegey, wayna uuraysatay; oo markay aragtay inay uuraysatay ayay murwadeedii aad u quudhsatay. ");
INSERT INTO som_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Oo Saaray waxay Aabraam ku tidhi, Dulmigii laygu sameeyey dushaada ha ahaado: midiidintaydii waxaan geliyey laabtaada; oo markay aragtay inay uuraysatay ayay i quudhsatay; Rabbigu aniga iyo adiga ha ina kala xukumo. ");
INSERT INTO som_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Laakiinse Aabraam wuxuu ku yidhi Saaray, Bal eeg, midiidintaadii gacantaaday ku jirtaaye; waxaad doonto ku samee. Saarayna si adag bay ula macaamilootay, kolkaasay midiidintii ka carartay horteeda. ");
INSERT INTO som_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Oo malaa'igtii Rabbigaa heshay iyadoo ag joogta il biyo ah oo cidlada ku taal, oo ishuna waxay ku tiil jidka Shuur. ");
INSERT INTO som_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Oo malaa'igtii waxay ku tidhi, Haagaar, midiidintii Saaray, xaggee baad ka timid? Xaggee baadse ku socotaa? Oo waxay ku tidhi, Murwadayda Saaray baan ka cararayaa. ");
INSERT INTO som_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Oo malaa'igtii Rabbigu waxay ku tidhi iyadii, Ku noqo murwadaadii, oo gacmaheeda is-hoos dhig. ");
INSERT INTO som_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Oo malaa'igtii Rabbigu waxay ku tidhi iyadii, Farcankaaga aad baan u tarmin doonaa si aan loo tirin karin farabadnaantiisa aawadeed. ");
INSERT INTO som_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Oo malaa'igtii Rabbigu waxay ku tidhi iyadii, Bal eeg, uur baad leedahaye, oo wiil baad dhali doontaa; magiciisana waxaad u bixin doontaa Ismaaciil, maxaa yeelay, Rabbigu waa maqlay dhibaatadaadii. ");
INSERT INTO som_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Oo dadka dhexdiisa wuxuu ku noqon doonaa sida dameer banjoog ah; gacantiisu nin walba gees bay ka noqon doontaa, oo nin walba gacantiisuna gees bay ka noqon doontaa isaga; wuxuuna degganaan doonaa walaalihiis oo dhan hortooda. ");
INSERT INTO som_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Oo waxay magicii Rabbigii la hadlay iyada u bixisay, Waxaad tahay Ilaaha wax arka, waayo, waxay tidhi, Weliba miyaan halkan ka arkay kan i arka? ");
INSERT INTO som_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Sidaas daraaddeed ceelkii waxaa loo bixiyeyBi'ir Lahayroy; bal eeg, wuxuu u dhexeeyaa Qaadeesh iyo Bered. ");
INSERT INTO som_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Oo Haagaar waxay Aabraam u dhashay wiil; oo Aabraamna wuxuu wiilkiisii Haagaar dhashay u bixiyey Ismaaciil. ");
INSERT INTO som_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Aabraamna wuxuu jiray lix iyo siddeetan sannadood, markii ay Haagaar Ismaaciil u dhashay Aabraam. ");
INSERT INTO som_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Oo markuu Aabraam jiray sagaal iyo sagaashan sannadood ayaa Rabbigu u muuqday, oo wuxuu ku yidhi, Waxaan ahay Ilaaha Qaadirka ah; hortayda ku soco, oo mid eed la' ahow. ");
INSERT INTO som_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Oo axdigaygaan kula dhigan doonaa, oo anigu aad baan kuu tarmin doonaa. ");
INSERT INTO som_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Markaasuu Aabraam wejiga u dhacay; oo Ilaah baa la hadlay isagoo ku leh, ");
INSERT INTO som_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Bal eeg, axdigaygii waa kula jiraaye, oo adigu quruumo badan baad aabbe u noqon doontaa. ");
INSERT INTO som_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Magacaagana mar dambe lama odhan doono Aabraam, laakiinse magacaagu wuxuu noqon doonaa Ibraahim; waayo, waxaan kaa dhigay quruumo badan aabbahood. ");
INSERT INTO som_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Aad baanan kuu badin doonaa, oo quruumo baan kaa samayn doonaa, boqorrona way kaa soo bixi doonaan. ");
INSERT INTO som_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Oo axdigayga waxaan ku adkayn doonaa dhexdeenna iyo farcankaaga kaa dambeeyaba, tan iyo qarniyadooda oo dhan, waana axdi weligiis waara, kaas oo ah inaan adiga Ilaah kuu noqdo iyo farcankaaga kaa dambeeya. ");
INSERT INTO som_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Oo waxaan ku siin doonaa, adiga iyo farcankaaga kaa dambeeyaba, dhulkii aad sodcaalka ku ahayd, kaas oo ah dalka Kancaan oo dhan inuu idiin ahaado hanti aad weligiin lahaataan; aniguna waxaan ahaan doonaa Ilaahood. ");
INSERT INTO som_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Oo Ilaah wuxuu Ibraahim ku yidhi, Adiguna waa inaad axdigayga xajisaa, adiga iyo farcankaaga kaa dambeeyaba, tan iyo qarniyadooda oo dhan. ");
INSERT INTO som_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Kanu waa axdigayga aad xajin doontaan, oo inoo dhexeeya aniga iyo adiga iyo farcankaaga kaa dambeeyaba; mid kasta oo lab oo idinku jira waa in la gudaa. ");
INSERT INTO som_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Oo waxaad iska gudi doontaan buuryadiinna; waxayna calaamo u noqon doontaa axdiga ina dhex yaal aniga iyo idinka. ");
INSERT INTO som_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Kii siddeed maalmood jira oo idinku dhex jira waa in la gudaa, mid kasta oo lab tan iyo qarniyadiinna oo dhan, ha ahaado kii gurigaaga ku dhasha ama kii lacag lagaga soo iibsado shisheeyaha oo aan farcankaaga ahayn. ");
INSERT INTO som_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Kii gurigaaga ku dhasha, iyo kii lacagtaada lagu iibsadoba, waa in la gudaa: axdigayguna wuxuu jidhkiinna ku noqon doonaa axdi weligiis waara. ");
INSERT INTO som_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Oo buuryoqabka lab oo aan buuryadiisa laga gooynin, midkaasu waa ka go'i doonaa dadkiisa; waayo, axdigaygii buu jebiyey. ");
INSERT INTO som_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Oo Ilaah wuxuu Ibraahim ku yidhi, Naagtaada Saarayna magaceeda waa inaadan ugu yeedhin Saaray, laakiinse magaceedu wuxuu ahaan doonaa Saarah. ");
INSERT INTO som_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Oo iyadaan barakayn doonaa, oo weliba wiil baan kaa siin doonaa; iyadaan barakayn doonaa, oo waxay noqon doontaa quruumo hooyadood; boqorrada dadyowguna iyaday ka iman doonaan. ");
INSERT INTO som_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Markaasuu Ibraahim wejiga u dhacay, oo qoslay, oo qalbigiisa wuxuu iska yidhi, Ma ilmaa u dhalan doona nin boqol jir ah? Oo Saarah oo sagaashan jir ihi miyey dhali doontaa? ");
INSERT INTO som_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Oo Ibraahim wuxuu Ilaah ku yidhi, Waxaan jeclaan lahaa in Ismaaciil hortaada ku noolaado! ");
INSERT INTO som_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Oo Ilaah wuxuu yidhi, Maya, laakiin naagtaada Saarah wiil bay kuu dhali doontaa, magiciisana waxaad u bixin doontaa Isxaaq; oo waxaan isaga ku adkayn doonaa axdigayga, kaas oo farcankiisa ka dambeeya u ahaan doona axdi weligiis waara. ");
INSERT INTO som_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Xagga Ismaaciilna waan ku maqlay; oo bal eeg, isaga waan barakeeyey, waanan badin doonaa, oo aad baan u tarmin doonaa isaga; laba iyo toban amiir buu dhali doonaa, oo quruun weyn baan ka dhigi doonaa. ");
INSERT INTO som_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Laakiin axdigayga waxaan ku adkayn doonaa Isxaaq kan Saarah kuu dhali doonto sannadda soo socota xilligan oo kale. ");
INSERT INTO som_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Oo kolkuu hadalkii u dhammeeyey, Ilaah waa ka tegey Ibraahim. ");
INSERT INTO som_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Markaasaa Ibraahim wuxuu kaxaystay wiilkiisii Ismaaciil, iyo intii gurigiisa ku dhalatay oo dhan, iyo kuwii lacagtiisa lagu iibsaday oo dhan, kulli intii labayd oo ka midka ahayd dadkii guriga Ibraahim joogay, oo isla maalintaas ayuu ka guday buuryadoodii sidii Ilaah ku yidhi isaga. ");
INSERT INTO som_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Oo Ibraahim wuxuu jiray sagaal iyo sagaashan sannadood markii laga guday buuryadiisii. ");
INSERT INTO som_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Wiilkiisii Ismaaciilna wuxuu jiray saddex iyo toban sannadood markii buuryadiisii laga guday. ");
INSERT INTO som_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Oo isla maalintaas baa la guday Ibraahim iyo wiilkiisii Ismaaciil. ");
INSERT INTO som_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Oo raggii gurigiisa joogay oo dhan, kuwii gurigiisa ku dhashay, iyo kuwii lacagtiisii shisheeyaha lagaga iibsadayba waa lala guday isaga. ");
INSERT INTO som_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Oo Rabbigaa u muuqday isaga oo ag jooga dhirtii Mamre, isagoo iridda teendhada fadhiya markii maalinta ugu kululayd. ");
INSERT INTO som_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Oo indhihiisii buu kor u taagay oo eegay, oo wuxuu arkay saddex nin oo hortiisa taagan: oo kolkuu arkay, ayuu ka orday iriddii teendhada inuu ka hor tago iyagii, kolkaasuu dhulka ku sujuuday, ");
INSERT INTO som_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","oo wuxuu yidhi, Sayidkaygiiyow, haddaad raalli iga tahay, ha i dhaafin anigoo addoonkaaga ah. ");
INSERT INTO som_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Biyo yar ha laydiin keeno, oo cagamaydha, oo geedka hoostiisa ku nasta: ");
INSERT INTO som_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","oo waxaan idiin keeni doonaa wuxoogaa cunto ah, ee raaxaysta; waayo, waxaad u timaadeen addoonkiinna; markaas ka dib waad tegi doontaan. Oo waxay ku yidhaahdeen, Yeel sidaad tidhi. ");
INSERT INTO som_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ibraahimna dhaqsuu u galay teendhadii, oo Saarah u tegey, oo wuxuu ku yidhi, Saddex koombo oo bur ah degdeg u diyaari, oo cajiin, oo kibis ka samee. ");
INSERT INTO som_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Oo Ibraahim xagga lo'dii buu ku orday, oo wuxuu soo kaxeeyey dibi yar oo dhaylo ah oo wanaagsan, oo wuxuu u dhiibay nin dhallinyaro ah, isaguna dhaqsuu u diyaariyey. ");
INSERT INTO som_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Kolkaasuu u qaaday subag, iyo caano, iyo dibigii uu diyaariyey, oo hortooduu dhigay; isna dhinacooduu istaagay geedkii hoostiisii; iyana way cuneen. ");
INSERT INTO som_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Oo waxay ku yidhaahdeen, Meeday bilcantaadii Saarah? Markaasuu yidhi, Waa taa; teendhaday ku jirtaa. ");
INSERT INTO som_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Wuxuuna ku yidhi, Hubaal waan kuu soo noqon doonaa markii xilligu soo wareego; oo bal ogow, naagtaada Saarah wiil bay dhali doontaaye. Saarahna way maqashay, iyadoo joogta iriddii teendhada oo ka dambaysay isaga. ");
INSERT INTO som_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Haddaba Ibraahim iyo Saarah way da' weynaayeen; gabow bayna la dhaceen; caadadii naaguhuna Saarah way ka joogsatay. ");
INSERT INTO som_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Saarahna qalbigay ka qososhay, iyadoo leh, Ma anigoo gaboobay baan farxad heli doonaa, iyadoo sayidkayguna gaboobay? ");
INSERT INTO som_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Rabbiguna wuxuu Ibraahim ku yidhi, Saarah maxay u qososhay, iyadoo leh, Runtii ma ilmaan dhali doonaa, anoo gaboobay? ");
INSERT INTO som_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Ma wax Rabbiga ku adag baa jira? Wakhtigii la ballamay baan kugu soo noqon doonaa, markii xilligu soo wareego, oo Saarah wiil bay dhali doontaa. ");
INSERT INTO som_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Markaasaa Saarah dafirtay oo tidhi, Ma aan qoslin; maxaa yeelay, way cabsatay. Oo isna wuxuu yidhi, Maya, laakiin waad qososhay. ");
INSERT INTO som_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Nimankiina halkaas way ka kaceen, oo waxay u jeesteen xagga Sodom: Ibraahimna wuu raacay inuu sagootiyo iyaga. ");
INSERT INTO som_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Rabbiguna wuxuu yidhi, Miyaan Ibraahim ka qariyaa waxaan samaynayo, ");
INSERT INTO som_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Maxaa yeelay, hubaal Ibraahim wuxuu noqon doonaa quruun weyn oo xoog leh, oo quruumaha dhulka oo dhammu isagay ku barakoobi doonaan? ");
INSERT INTO som_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Waayo, waan garanayaa isaga, inuu carruurtiisa iyo kuwa gurigiisa jooga ku amri doono, inay jidka Rabbiga xajiyaan inay sameeyaan xaqnimo iyo caaddilnimo; si uu Rabbigu Ibraahim ugu soo dejiyo wixii uu kaga hadlay. ");
INSERT INTO som_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Rabbiguna wuxuu yidhi, Qaylada Sodom iyo Gomora way badatay, dembigooduna aad buu u weynaaday. ");
INSERT INTO som_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Haddaba waan degi doonaa, oo waxaan arki doonaa inay wada sameeyeen sida qayladu ii soo gaadhay iyo in kale; haddaanay wada samaynna, waan ogaan doonaa. ");
INSERT INTO som_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Oo nimankii halkaasay ka noqdeen oo waxay tageen xagga Sodom: laakiinse Ibraahim weli wuxuu hor taagnaa Rabbiga. ");
INSERT INTO som_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Oo Ibraahim baa u dhowaaday, oo yidhi, Miyaad kuwa xaqa ah la baabbi'inaysaa kuwa sharka fala? ");
INSERT INTO som_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Mindhaa waxaa magaalada jooga konton xaq ah. De miyaad baabbi'inaysaa meesha oo aadan ugu tudhaynin kontonka xaqa ah ee jooga aawadood? ");
INSERT INTO som_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Yaanay noqon inaad sidaas samayso, inaad kuwa xaqa ah la dishid kuwa sharka fala, oo sidaas kuwa xaqa ahu ay kula mid noqdaan kuwa sharka fala, taas yaanay noqon. Dunida oo dhan Xaakinkeedu miyuusan xaq samayn doonin? ");
INSERT INTO som_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Markaasaa Rabbigu yidhi, Haddaan Sodom ka helo konton qof oo xaq ah oo magaalada jooga, de markaas meeshaa oo dhan waxaan ugu tudhi doonaa iyaga daraaddood. ");
INSERT INTO som_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Oo Ibraahimna wuu jawaabay oo yidhi, Bal eeg, waxaan isu diray inaan Sayidka la hadlo, anoo ciid iyo dambas ah. ");
INSERT INTO som_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Mindhaa kontonka xaqa ah shan baa ka dhiman; miyaad magaalada oo dhan u baabbi'in hadday shanu ka dhiman tahay? Markaasuu yidhi, Baabbi'in maayo haddaan meeshaas shan iyo afartan ka helo. ");
INSERT INTO som_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Kolkaasuu mar kale la hadlay, oo yidhi, Mindhaa waxaa halkaas laga heli afartan. Markaasuu yidhi, Afartanka aawadood ayaanan u baabbi'inayn. ");
INSERT INTO som_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Oo wuxuu yidhi, Sayidku yuusan cadhoon, waan la hadlayaaye. Mindhaa waxaa halkaas laga heli soddon. Markaasuu yidhi, Baabbi'in maayo haddaan soddon halkaas ka helo. ");
INSERT INTO som_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Markaasuu yidhi, Bal eeg, waxaan isu diray inaan Sayidka la hadlo: mindhaa waxaa halkaas laga heli labaatan. Markaasuu yidhi, Labaatanka daraaddood ayaanan u baabbi'inayn. ");
INSERT INTO som_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Oo wuxuu yidhi, Sayidku yuusan cadhoon, oo weli waan la hadlayaaye, waase markan keliya. Mindhaa waxaa halkaas laga heli toban. Wuxuuna yidhi, Tobanka daraaddood ayaanan u baabbi'inayn. ");
INSERT INTO som_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Rabbiguna wuu iska tegey markuu Ibraahim la dhammeeyey hadalkii, Ibraahimna meeshiisii buu ku noqday. ");
INSERT INTO som_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Oo labadii malaa'igood baa Sodom fiidkii yimid; Luudna wuxuu fadhiyey iridda Sodom. Oo markuu Luud iyagii arkay ayuu u kacay inuu ka hor tago; wuuna sujuuday oo wejigiisuu dhulka saaray; ");
INSERT INTO som_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","oo wuxuu ku yidhi, Bal eega, sayidyadaydiiyow, soo leexda, waan idin baryayaaye, oo gala guriga addoonkiinna, oo caawa oo dhan jooga, oo cagamaydha. Aroortii baanad kici doontaan oo iska tegi doontaane. Oo waxay ku yidhaahdeen, Maya; laakiin jidkaannu joogaynaa caawa oo dhan. ");
INSERT INTO som_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Aad buuna u baryay; xaggiisayna u soo leexdeen, oo gurigiisii bay galeen; diyaafad buuna u sameeyey, kibis aan khamiir lahaynna wuu u dubay, wayna cuneen. ");
INSERT INTO som_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Laakiinse intaanay jiifsan ka hor, waxaa gurigii hareereeyey nimankii magaalada, oo ahaa nimankii Sodom, yar iyo weynba, dadkii oo dhan oo ka yimid meel kastaba; ");
INSERT INTO som_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","oo Luud bay u yeedheen, oo waxay ku yidhaahdeen, Meeye nimankii caawa kuu yimid? Dibadda noogu soo bixi iyaga, aannu fuulnee. ");
INSERT INTO som_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Oo Luudna dibadduu ugu baxay iyagoo albaabka jooga, albaabkiina wuu xidhay. ");
INSERT INTO som_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Oo wuxuu yidhi, Waan idin baryayaaye, walaalahayow, ee wax sidaas u xun ha samaynina. ");
INSERT INTO som_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Bal eega, waxaan leeyahay laba gabdhood oo aan weli nin u tegin; haddaba waan idin baryayaaye, aan idiin soo bixiyo iyaga, oo saad doontaan u gala, laakiin nimankan uun waxba ha ku samaynina, maxaa yeelay, waxay soo hoos galeen dugsiga saqafkayga. ");
INSERT INTO som_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Waxayna yidhaahdeen, Dib u joogso. Oo waxay kaloo yidhaahdeen, Ninkanu socdaal buu ku yimid, oo wuxuu doonayaa inuu xaakin noqdo. Haatan wax daran baannu kugu samayn, intaannu iyaga ku samayn lahayn in ka sii daran. Markaasay si xun ninkii Luud ahaa u riixeen. Waxayna ugu soo dhowaadeen inay albaabka jebiyaan. ");
INSERT INTO som_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Laakiinse nimankii baa gacmahoodii soo bixiyey, oo Luud bay gurigii soo gashadeen, markaasay albaabkii xidheen. ");
INSERT INTO som_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Wayna indho tireen nimankii guriga albaabkiisa joogay, yar iyo weynba: oo saas daraaddeed way ka daaleen inay albaabkii helaan. ");
INSERT INTO som_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Oo nimankii waxay Luud ku yidhaahdeen, Intan mooyaane wax kale ma ku leedahay meeshan? Wiil aad soddog u tahay iyo wiilashaada iyo gabdhahaaga, iyo ku alla kaad magaalada ku leedahay kala soo bax meeshan; ");
INSERT INTO som_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","waayo, meeshan waannu baabbi'in doonnaa, maxaa yeelay, qayladoodii baa Rabbiga hortiisa aad ugu badatay: oo Rabbigu wuxuu noo soo diray inaannu baabbi'inno. ");
INSERT INTO som_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Markaasuu Luud dibadda u baxay, oo wuxuu la hadlay wiilashuu soddogga u ahaa, oo gabdhihiisa qabay, oo wuxuu ku yidhi, Kaca, oo ka soo baxa meeshan; waayo, Rabbigu magaalada wuu baabbi'in doonaa. Laakiin wuxuu wiilashuu soddogga u ahaa ula ekaaday sidii mid ku cayaaraya. ");
INSERT INTO som_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Oo markii waagii beryay ayaa malaa'igihii Luud deddejiyeen, iyagoo leh, Kac, oo la tag naagtaada iyo labadaada gabdhood oo halkan jooga; waaba intaasoo aad dembiga magaalada ku baabba'daane. ");
INSERT INTO som_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Laakiin markuu raagay ayay nimankii gacantiisa qabteen, iyo gacantii naagtiisa, iyo gacantii labadiisii gabdhood; Rabbiguna waa u naxariistay isaga, iyana way soo bixiyeen, oo waxay geeyeen magaaladii dibaddeeda. ");
INSERT INTO som_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Oo markay dibadda u soo bixiyeen ayuu ku yidhi, Naftaada la baxso; gadaashaadana ha eegin. Bannaanka oo dhanna ha joogsan, ee buurta u baxso, waaba intaas oo aad baabba'daaye. ");
INSERT INTO som_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Luudna wuxuu ku yidhi iyagii, Sayidkaygiiyow, saas yaanay noqon. ");
INSERT INTO som_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Bal eeg, anigoo addoonkaaga ah raalli baad iga ahayd, oo waad weynaysay naxariistaadii aad i tustay markii aad naftayda badbaadisay; aniguse buurta uma baxsan karo, waaba intaasoo shar i gaadhaa oo aan dhintaa. ");
INSERT INTO som_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Bal eeg, magaaladan baa dhow inaan u cararo, waana mid yar, de iyada aan u baxsado, (miyaanay mid yar ahayn?) naftayduna waa noolaan doontaa. ");
INSERT INTO som_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Oo wuxuu ku yidhi isagii, Bal eeg, waxanna waan kaa aqbalay inaanan rogi doonin magaaladii aad ka hadashay. ");
INSERT INTO som_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Dhaqso, oo halkaas u baxso; waayo, waxba ma aan samayn karo ilaa aad halkaas tagto. Sidaas daraaddeed magaalada magaceeda waxaa loo bixiyey Socar. ");
INSERT INTO som_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Markii Luud Socar yimid ayaa qorraxdu dhulka u soo baxday. ");
INSERT INTO som_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Markaasaa Rabbigu wuxuu Sodom iyo Gomora ku soo daayay baruud iyo dab ka yimid xagga Rabbiga oo samada ka soo daatay; ");
INSERT INTO som_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","wuuna rogay magaalooyinkaas, iyo Bannaankii oo dhan, iyo dadkii degganaa magaalooyinkaas oo dhan, iyo wixii dhulka ka soo baxay oo dhan. ");
INSERT INTO som_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Laakiinse naagtiisii oo daba socotay ayaa dib u eegtay, waxayna noqotay tiir cusbo ah. ");
INSERT INTO som_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Ibraahimna aroortii hore ayuu u kacay meeshii uu Rabbiga hor istaagay: ");
INSERT INTO som_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","oo wuxuu eegay xagga Sodom iyo Gomora, iyo dhulkii Bannaanka oo dhan, wuuna fiiriyey, oo bal eeg, qiiqii dhulka ayaa kor u baxay sidii qiiqa foornada oo kale. ");
INSERT INTO som_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Oo waxay noqotay, markii Ilaah baabbi'iyey magaalooyinkii Bannaanka, in Ilaah xusuustay Ibraahim, Luudna roggidda wuu ka bixiyey markuu rogay magaalooyinkii Luud dhex degganaa. ");
INSERT INTO som_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Luudna Socar wuu ka baxay, oo buurtuu degay, isaga iyo labadiisii gabdhood ee la joogayba; waayo, wuu ka cabsaday inuu Socar degganaado, wuxuuna degay bohol dhexdeed, isaga iyo labadiisii gabdhood. ");
INSERT INTO som_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Oo tii curadda ahayd waxay tii yarayd ku tidhi, Aabbeheen waa duq, dhulkana ma jiro nin inoo iman kara sida caadada dunida oo dhan tahay. ");
INSERT INTO som_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Kaalay, aynu aabbeheen khamri cabsiinnee, markaasaynu la jiifsanaynaa, si aynu aabbeheen farcan ugala hadhno. ");
INSERT INTO som_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Oo habeenkaasay aabbahood khamri cabsiiyeen, oo tii curadda ahayd baa u tagtay oo la jiifsatay aabbeheed; mana uu ogayn markay la jiifsatay, iyo markay ka kacday toona. ");
INSERT INTO som_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Oo waxay noqotay in maalintii dambe ay tii curadda ahayd ku tidhi tii yarayd, Bal eeg, xalayto aabbahay baan la jiifsaday: caawana aynu khamri cabsiinno; oo adigu u tag oo la jiifso isaga, aynu aabbeheen farcan kala hadhnee. ");
INSERT INTO som_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Oo haddana habeenkaasay aabbahood khamri cabsiiyeen: oo tii yarayd baa kacday oo aabbeheed la jiifsatay; mana uu ogayn markay la jiifsatay iyo markay ka kacday toona. ");
INSERT INTO som_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Oo sidaasay Luud labadiisii gabdhoodba aabbahood uurka ugu lahaayeen. ");
INSERT INTO som_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Oo tii curaddii ahayd waxay dhashay wiil, oo waxay magiciisii u bixisay Moo'aab, isna waa reer Moo'aabka maanta joogo aabbahood. ");
INSERT INTO som_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Tii yarayd iyana waxay dhashay wiil, oo waxay magiciisii u bixisay Bencammi: isna waa reer Cammoonka maanta jooga aabbahood. ");
INSERT INTO som_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Ibraahimna meeshaas wuu ka sodcaalay oo wuxuu u kacay xagga dhulka Koonfureed, oo wuxuuna degay Qaadeesh iyo Shuur dhexdooda, qariib ahaan buuna Geraar u degay. ");
INSERT INTO som_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Ibraahimna wuxuu naagtiisii Saarah ka yidhi, Waa walaashay. Oo Abimeleg oo ahaa boqorkii Geraar ayaa u soo cid dirtay, oo watay Saarah. ");
INSERT INTO som_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Laakiinse Ilaah baa Abimeleg habeenkii riyo ugu yimid, oo wuxuu ku yidhi, Bal eeg, waxaad tahay meyd uun, waana naagtii aad qaadatay aawadeed, maxaa yeelay, iyadu waa nin naagtiis. ");
INSERT INTO som_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Abimelegna uma uusan dhowaan iyada, wuxuuna yidhi, Sayidow, miyaad quruun xaq ah baabbi'inaysaa? ");
INSERT INTO som_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Miyuusan isaga qudhiisu igu odhan, Waa walaashay? Oo iyana xataa waxay igu tidhi, Isagu waa walaalkay. Tan waxaan ku sameeyey daacadnimada qalbigayga iyo daahirsanaanta gacmahayga. ");
INSERT INTO som_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Oo Ilaah wuxuu ku yidhi isaga intuu riyoonayay, Haah, waan ogahay inaad waxan daacadnimada qalbigaaga ku samaysay, anna waan kaa celiyey inaad igu dembaabto: sidaas daraaddeed kuuma aan oggolaan inaad iyada taabato. ");
INSERT INTO som_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Haddaba ninka naagtiisa u celi, waayo, isagu waa nebi, wuuna kuu ducayn doonaa, waanad noolaan doontaa. Haddaadan iyada celinna, ogow hubaal waad dhiman doontaa, adiga iyo waxaaga oo dhammuba. ");
INSERT INTO som_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Abimelegna aroor horuu kacay, oo wuxuu u yeedhay addoommadiisii oo dhan, oo waxyaalahan oo dhan buu u sheegay, nimankiina aad iyo aad bay u cabsadeen. ");
INSERT INTO som_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Markaasaa Abimeleg wuxuu u yeedhay Ibraahim, oo wuxuu ku yidhi, Waa maxay waxa aad nagu samaysay? Oo maxaan kuugu dembaabay, oo aad aniga iyo boqortooyadaydaba dembi weyn ugu soo jiidday? Waxaad igu samaysay waxyaalo aan waajib ahayn in la sameeyo. ");
INSERT INTO som_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abimelegna wuxuu Ibraahim ku yidhi, Maxaad aragtay oo aad waxan u samaysay? ");
INSERT INTO som_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ibraahimna wuxuu yidhi, Waxaan mooday inaan cabsida Ilaah meeshan jirin, oo ay naagtayda aawadeed ii dili doonaan. ");
INSERT INTO som_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Oo weliba sida runta ah iyadu waa walaashay, waana gabadhii aabbahay, laakiin ma aha gabadhii hooyaday; waxayna noqotay naagtaydii. ");
INSERT INTO som_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Waxaana dhacay, markii Ilaah iga wareejiyey gurigii aabbahay, inaan ku idhi iyada, Raxmaddaada aad i tusi doonto waxay tahay inaad meel kastoo aynu tagnaba iga tidhaahdo, Waa walaalkay. ");
INSERT INTO som_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Markaasaa Abimeleg wuxuu waday ido iyo dibiyo, iyo niman addoommo ah, iyo naago addoommo ah, oo wuxuu siiyey Ibraahim, naagtiisii Saarahna wuu u celiyey. ");
INSERT INTO som_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimelegna wuxuu ku yidhi, Bal eeg dhulkaygu waa ku hor yaallaaye. Meeshaad doonto deg. ");
INSERT INTO som_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Saarahna wuxuu ku yidhi, Bal eeg, walaalkaa waxaan siiyey kun xabbadood oo lacag ah, waana u indhadabool kuwa kula jooga oo dhan; oo xagga wax kasta waa lagaa xaq mariyey. ");
INSERT INTO som_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Ibraahimna Ilaah buu baryay, markaasaa Ilaah bogsiiyey Abimeleg, iyo naagtiisii, iyo gabdhihii midiidinyada u ahaa; waxayna dhaleen carruur. ");
INSERT INTO som_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Waayo, Ilaah wuxuu awday maxalladii kuwa reerka Abimeleg oo dhan, waana Saarah oo ahayd naagtii Ibraahim aawadeed. ");
INSERT INTO som_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Oo Rabbigu Saarah wuu soo booqday siduu yidhi, oo Rabbigu wuxuu Saarah u yeelay siduu kula hadlay. ");
INSERT INTO som_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Oo Saarah way uuraysatay, oo Ibraahim wiil bay u dhashay isagoo da' weyn, waxayna ahayd wakhtigii Ilaah kala hadlay isaga. ");
INSERT INTO som_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Oo Ibraahim wuxuu wiilkiisii u dhashay, oo Saarah u dhashay isaga, u bixiyey Isxaaq. ");
INSERT INTO som_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Oo Ibraahim baa guday wiilkiisii Isxaaq markuu siddeed maalmood jiray, sidii Ilaah ku amray isaga. ");
INSERT INTO som_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Oo Ibraahimna wuxuu jiray boqol sannadood, markii wiilkiisii Isxaaq u dhashay isaga. ");
INSERT INTO som_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Saarahna waxay tidhi, Ilaah waa iga qosliyey, qof kasta oo maqlaana waa ila qosli doonaa. ");
INSERT INTO som_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Oo waxay tidhi, Yaa Ibraahim ku odhan lahaa, Saarah carruur bay nuujin doontaa? Waayo, wiil baan u dhalay isaga oo da' weyn. ");
INSERT INTO som_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Wiilkiina wuu koray, naaskiina waa laga gudhiyey. Ibraahimna diyaafad weyn buu sameeyey maalintii Isxaaq naaska laga gudhiyey. ");
INSERT INTO som_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Saarahna waxay aragtay wiilkii ay Haagaar tii Masriyadda ahayd Ibraahim u dhashay oo ku cayaaraya. ");
INSERT INTO som_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Sidaas daraaddeed waxay Ibraahim ku tidhi, Eri addoontan iyo wiilkeedaba: maxaa yeelay, wiilka addoontanu wax la dhaxli maayo wiilkayga Isxaaq ah. ");
INSERT INTO som_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Waxaasuna Ibraahim aad buu ula xumaa xagga wiilkiisa. ");
INSERT INTO som_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Ilaahna wuxuu Ibraahim ku yidhi, Yaanay kula xumaan wiilka dartiis, iyo naagta addoonta ah toona. Wax alla wixii Saarah kugu tidhaahdo, hadalkeeda maqal; waayo, farcankaaga Isxaaq baa loogu yeedhi doonaa. ");
INSERT INTO som_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Wiilka addoontana waxaan ka dhigi doonaa quruun, waayo, isna waa farcankaaga. ");
INSERT INTO som_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Ibraahimna aroortii horuu kacay, wuxuuna qaaday cunto iyo sibraar biyo ah, oo Haagaar buu siiyey intuu garbaha u saaray, wiilkiina wuu siiyey, markaasuu eryay: wayna iska tagtay, oo ku wareegtay cidladii Bi'ir Shebac. ");
INSERT INTO som_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Biyihii sibraarka ku jirayna way dhammaadeen, kolkaasay ilmihii ku xoortay geedihii midkood hoostiisa. ");
INSERT INTO som_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Wayna tagtay oo waxay fadhiisatay meel ku soo jeedda oo ka fog, oo qiyaastii ah intii fallaadh la ganay gaadho, waxayna tidhi, Yaanan eegin dhimashada wiilka. Iyadoo fadhida meel ku soo jeedda ayay codkeedii kor u qaadday oo ooyday. ");
INSERT INTO som_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Ilaah baana maqlay codkii wiilka; malaa'igtii Ilaahna Haagaar bay samada uga yeedhay, oo waxay ku tidhi, Haagaaray, maxaa ku helay? Ha baqin; waayo, Ilaah waa maqlay codkii wiilka, meeshuu joogo isagu. ");
INSERT INTO som_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Kac oo wiilka toosi, oo gacantaada ku hay; maxaa yeelay, quruun weyn baan ka dhigi doonaa isaga. ");
INSERT INTO som_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Markaasaa Ilaah indhaheedii furay, oo waxay aragtay ceel biyo ah; kolkaasay tagtay, oo sibraarkii biyo ka soo buuxisay, oo wiilkii waraabisay. ");
INSERT INTO som_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Ilaahna wiilkii buu la jiray; wuuna koray; oo cidladuu degay, wuxuuna noqday qaansoole. ");
INSERT INTO som_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Wuxuuna degay cidladii Faaraan: hooyadiis baana dhulka Masar naag uga qaadday. ");
INSERT INTO som_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Waxayna noqotay wakhtigaas in Abimeleg iyo Fiikol oo ahaa madaxda ciidankiisa ay la hadleen Ibraahim iyagoo leh, Ilaah waa kugula jiraa waxa aad samayso oo dhan. ");
INSERT INTO som_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Haddaba halkan Ilaah iigu dhaaro inaadan i khiyaanaynin aniga ama wiilkayga, ama wiilkayga wiilkiisa, laakiinse sidii aan wanaagga kuugu sameeyey, inaad adna iigu samaynaysid, aniga iyo dhulka aad qariib ahaanta u degganaydba. ");
INSERT INTO som_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ibraahimna wuxuu yidhi, Waan kuu dhaaran doonaa. ");
INSERT INTO som_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Ibraahimse wuxuu Abimeleg u canaantay ceelkii ay addoommada Abimeleg ka xoogeen aawadiis. ");
INSERT INTO som_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimelegna wuxuu yidhi, Anigu garan maayo ka waxaas sameeyey; adna iima aad sheegin, welina ma aan maqlin, maanta mooyaane. ");
INSERT INTO som_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Markaasaa Ibraahim ido iyo dibiyo kaxeeyey, oo wuxuu siiyey Abimeleg; labadoodiina axdi bay dhigteen. ");
INSERT INTO som_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Kolkaasaa Ibraahim idihii gooni ahaan uga bixiyey toddoba sabeenood. ");
INSERT INTO som_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimelegna wuxuu Ibraahim ku yidhi, Micnehoodu waa maxay toddobadan sabeenood oo aad gooni ahaantooda u bixisay? ");
INSERT INTO som_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Markaasuu yidhi, Toddobadan sabeenood waa inaad iga guddoontid inay markhaati ii noqoto inaan anigu ceelkan qoday. ");
INSERT INTO som_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Sidaas daraaddeed meeshaas wuxuu u bixiyey Bi'ir Shebac; maxaa yeelay, labadooduba meeshaas bay ku dhaarteen. ");
INSERT INTO som_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Sidaas daraaddeed axdi bay ku dhigteen Bi'ir Shebac; markaasaa Abimeleg kacay, isaga iyo Fiikol oo ahaa madaxda ciidankiisa, oo waxay ku noqdeen dhulkii reer Falastiin. ");
INSERT INTO som_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Ibraahimna geed buu Bi'ir Shebac ku beeray, oo halkaas buu ku ducaystay magaca Rabbiga Ilaaha daa'imka ah. ");
INSERT INTO som_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ibraahimna maalmo badan ayuu dhulka reer Falastiin qariib ahaan ku degganaa. ");
INSERT INTO som_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Oo waxaa dhacay waxyaalahaas ka dib, in Ilaah tijaabiyey Ibraahim, oo uu ku yidhi, Ibraahimow. Isna wuxuu yidhi, Waa i kan. ");
INSERT INTO som_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Markaasuu ku yidhi, Hadda kaxee wiilkaaga keligiis ah, kan aad jeceshahay, oo ah Isxaaq, oo u kac dalka Moriyaah; oo halkaas isaga sida allabari la gubo ku dul bixi buuraha middood oo aan kuu sheegi doono. ");
INSERT INTO som_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Oo aroortii horaa Ibraahim kacay, oo wuxuu kooraystay dameerkiisii, oo wuxuu kaxaystay laba ka mid ah dhallinyaradiisii, iyo wiilkiisii Isxaaq; qoryihiina allabariga la gubo wuu u jeexjeexay, wuuna kacay, oo wuxuu tegey meeshii Ilaah u sheegay. ");
INSERT INTO som_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Maalintii saddexaad ayuu Ibraahim indhihiisa kor u taagay, markaasuu meeshii oo ka fog arkay. ");
INSERT INTO som_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Ibraahimna wuxuu raggiisii dhallinyarada ahaa ku yidhi, Idinku halkan dameerka la jooga, aniga iyo wiilkuna halkoo baannu tegaynaa oo Ilaah ku soo caabudaynaa, dabadeedna waannu idinku soo noqonaynaa. ");
INSERT INTO som_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ibraahimna wuxuu qaaday qoryihii allabariga la gubo, oo wuxuu saaray wiilkiisii Isxaaq, isna wuxuu gacantiisa ku qaaday dabkii iyo mindidii; markaasay labadoodiiba israaceen. ");
INSERT INTO som_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isxaaqna waa la hadlay aabbihiis Ibraahim, oo yidhi, Aabbow. Isna wuxuu yidhi, Waa i kan, wiilkaygiiyow. Markaasuu ku yidhi, Bal eeg, waa kuwan dabkii iyo qoryihii, laakiinse meeh wankii allabariga la gubo loo bixin lahaa? ");
INSERT INTO som_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ibraahimna wuxuu yidhi, Ilaah qudhiisaa keeni doona wankii allabariga la gubo loo bixin lahaa, wiilkaygiiyow; saas daraaddeed labadoodiiba way israaceen. ");
INSERT INTO som_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Oo waxay yimaadeen meeshii Ilaah isaga u sheegay; Ibraahimna meeshaasuu ka dhisay meeshii allabariga, qoryihiina wuu hagaajiyey, markaasuu xidhay wiilkiisii Isxaaq, oo meeshii allabariga saaray qoryihii dushooda. ");
INSERT INTO som_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Ibraahimna gacantiisii buu fidiyey, oo mindidii buu u qaaday inuu wiilkiisii dilo. ");
INSERT INTO som_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Markaasay malaa'igtii Rabbigu samada uga yeedhay isaga, oo waxay ku tidhi, Ibraahimow, Ibraahimow. Kolkaasuu yidhi, Waa i kan. ");
INSERT INTO som_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Markaasay ku tidhi, Gacantaada ha saarin wiilka, waxbana ha ku samaynin: waayo, hadda waan garanayaa inaad Ilaah ka cabsatid, maxaa yeelay, igama aadan lexejeclaysan wiilkaaga, kaas oo ahaa wiilkaaga keligiis ah. ");
INSERT INTO som_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Markaasaa Ibraahim indhihiisii kor u taagay, oo wax fiiriyey, oo wuxuu dabadiisa ku arkay wan geesaha kayn kula jira. Markaasaa Ibraahim tegey oo wankii soo kaxeeyey, oo wuxuu u bixiyey allabari guban meeshii wiilkiisa. ");
INSERT INTO som_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ibraahimna meeshaas wuxuu u bixiyey Yehowah Yireh; xataa ilaa maanta waxaa la yidhaahdaa, Buurta Rabbiga ayaa lagu arki doonaa. ");
INSERT INTO som_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Kolkaasaa mar labaad malaa'igtii Rabbigu Ibraahim samada uga yeedhay, ");
INSERT INTO som_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","oo waxay ku tidhi, Rabbigu wuxuu yidhi, Waxan aad samaysay aawadood, iyo wiilkaaga aadan iga lexejeclaysan, kaas oo ah wiilkaaga keligiis ah aawadiis ayaan nafsaddayda ku dhaartay ");
INSERT INTO som_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","inaan barako ku barakayn doono, oo aan farcankaaga u tarmin doono sida xiddigaha cirka, iyo sida cammuudda taal badda xeebteeda; oo uu farcankaaguna hantiyi doono cadaawayaashiisa iriddooda; ");
INSERT INTO som_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","oo ay quruumaha dunida oo dhammu ku barakoobi doonaan farcankaaga, maxaa yeelay, codkaygaad addeecday. ");
INSERT INTO som_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Haddaba Ibraahim wuxuu ku noqday raggiisii dhallinyarada ahaa, markaasay kaceen oo waxay wada tageen Bi'ir Shebac, Ibraahimna wuxuu iska degay Bi'ir Shebac. ");
INSERT INTO som_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Oo waxaa dhacay waxyaalahaas dabadood, in Ibraahim loo sheegay, oo lagu yidhi, Bal eeg, Milkah carruur bay u dhashay walaalkaa Naaxoor. ");
INSERT INTO som_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Waxay yihiin Cuus oo ah curadkiisa, iyo Buus oo ah walaalkiis, iyo Qemuu'el oo ah Araam aabbihiis; ");
INSERT INTO som_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","iyo Kesed, iyo Haso, iyo Fildash, iyo Yidlaf iyo Betuu'el. ");
INSERT INTO som_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuu'elna wuxuu dhalay Rebeqah. Siddeeddan bay Milkah u dhashay Naaxoor, oo ahaa Ibraahim walaalkiis. ");
INSERT INTO som_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Addoontiisii la odhan jiray Re'uumah waxay iyana u dhashay Tebah, iyo Gaham, iyo Tahash, iyo Macakah. ");
INSERT INTO som_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Saarah waxay noolayd boqol iyo toddoba iyo labaatan sannadood; intaasu waa Saarah cimrigeedii. ");
INSERT INTO som_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Oo Saarah waxay ku dhimatay Qiryad Arbac, taasoo ah Xebroon, tan ku taal dalka Kancaan: Ibraahimna wuxuu u yimid inuu u baroorto, oo uu u ooyo Saarah. ");
INSERT INTO som_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Markaasaa Ibraahim meydkii naagtiisa ka kacay, oo wuxuu la hadlay reer Xeed, isagoo ku leh, ");
INSERT INTO som_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Waxaan ahay shisheeye sodcaal ah oo idin dhex jooga: ee dhexdiinna iga siiya meel xabaaleed oo hanti ah, si aan meydka naagtayda hortayda uga aaso. ");
INSERT INTO som_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Oo reer Xeedna Ibraahim bay u jawaabeen, iyagoo ku leh, ");
INSERT INTO som_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","Bal na maqal sayidkaygiiyow, adigu dhexdayada waxaad ku tahay amiir weyn. Midka ugu wanaagsan qabriyadayada meydka naagtaada ku aas. ");
INSERT INTO som_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Midkayana kaama lexejeclaysan doono qabrigiisa inaad ku aastid meydka naagtaada. Markaasaa Ibraahim sare kacay, oo uu u sujuuday dadkii waddanka lahaa, oo ahaa reer Xeed. ");
INSERT INTO som_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Wuuna la hadlay oo ku yidhi, Haddaad oggoshihiin inaan meydka naagtayda hortayda ka aaso, i maqla oo ii barya Cefroon ina Sohar, ");
INSERT INTO som_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","inuu i siiyo godka la yidhaahdo Makfelah oo uu haysto, oo ku yaal berrinkiisa geestiisa. Qiimo dhan ha iga siiyo, inay dhexdiinna ii noqoto meel xabaaleed oo hanti ah. ");
INSERT INTO som_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Haddaba Cefroon wuxuu fadhiyey reer Xeed dhexdooda; oo Cefroon oo ahaa reer Xeed ayaa Ibraahim u jawaabay, iyadoo ay maqlayaan reer Xeed intii iriddii magaaladiisa ka gashay oo dhammu, oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Maya, sayidkaygiiyow, i maqal, berrinka waan ku siinayaa, godka ku dhex yaalna waan ku siinayaa; waxaan kugu siinayaa ragga reerkayga hortooda, ee meydka ku aaso. ");
INSERT INTO som_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Ibraahimna wuxuu ku hor sujuuday dadkii waddanka. ");
INSERT INTO som_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Markaasuu Cefroon la hadlay iyadoo ay dadkii waddanku maqlayaan, oo wuxuu ku yidhi, Waan ku baryayaaye, haddaad oggoshahay i maqal; waan ku siin qiimihii berrinka ee iga qaado, anna meydkaan meeshaas ku aasan. ");
INSERT INTO som_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Cefroonna Ibraahim buu u jawaabay, isagoo ku leh, ");
INSERT INTO som_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","Sayidkaygiiyow, bal i maqal: meel dhul ah oo qiimihiisu yahay afar boqol oo sheqel oo lacag ah, waa maxay dhexdeenna? Haddaba meydka aaso. ");
INSERT INTO som_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ibraahimna Cefroon buu maqlay; markaasaa Ibraahim u miisaamay Cefroon lacagtii uu u sheegay, iyadoo ay reer Xeed maqlayaan, oo waxay ahayd, afar boqol oo sheqel oo lacag ah, oo lacagtii baayacmushtarka ku socotay ah. ");
INSERT INTO som_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Sidaasaa berrinkii Cefroon, oo Makfelah ku yiil, oo Mamre ku hor yiil, berrinkii iyo godkii ku dhex yiil, iyo geedihii ku yiil berrinkii, iyo xuduudkii ku wareegsanaa oo dhanba waxaa lagu xaqiijiyey ");
INSERT INTO som_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","reer Xeed intii iriddii magaaladiisa ka gashay oo dhan hortooda, in Ibraahim hanti ahaan u lahaado. ");
INSERT INTO som_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Markaas ka dib ayaa Ibraahim naagtiisii Saarah ku aasay godkii berrinkii Makfelah oo ku hor yiil Mamre, taas oo ah Xebroon oo dalka Kancaan ku tiil. ");
INSERT INTO som_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Oo berrinkii iyo godkii ku dhex yiilba reer Xeed ayaa Ibraahim u xaqiijiyey inay meel xabaaleed oo hanti ah u noqdaan. ");
INSERT INTO som_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ibraahimna waa da' weynaa, gabow buuna la dhacay. Rabbiguna Ibraahim buu ku barakeeyey wax walba. ");
INSERT INTO som_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Oo Ibraahim, wuxuu ku yidhi addoonkiisii oo dadka gurigiisa ugu weynaa, oo u talin jiray wixii uu lahaa oo dhan, Waan ku baryayaaye gacantaada bowdadayda hoos dhig. ");
INSERT INTO som_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Oo waxaan kugu dhaarin doonaa Rabbiga ah Ilaaha samada iyo Ilaaha dhulka inaadan wiilkayga naag uga guurinayn gabdhaha reer Kancaanka aan dhex degganahay: ");
INSERT INTO som_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","laakiin waxaad u kacdaa dalkaygii iyo xigaalkaygii, oo waxaad naag uga keentaa wiilkayga Isxaaq. ");
INSERT INTO som_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Addoonkiina wuxuu ku yidhi, Waxaa laga yaabaa inaanay naagtu oggolaan inay ii soo raacdo dalkan; ma inaan wiilkaaga ku celiyo dalkii aad ka timid baa? ");
INSERT INTO som_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ibraahimna wuxuu ku yidhi isagii, Iska jir oo wiilkayga meeshaas ha ku celin. ");
INSERT INTO som_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Rabbiga Ilaaha samada ah, oo iga soo kaxeeyey gurigii aabbahay iyo dalkaygii aan ku dhashay, oo ila hadlay, iiguna dhaartay, isagoo leh, Farcankaaga ayaan dalkan siinayaa, ayaa malaa'igtiisa kaa sii hor diri doona, wiilkaygana naag baad halkaas uga soo guurin doontaa. ");
INSERT INTO som_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Haddii naagtu aanay oggolaan inay ku soo raacdo, markaas dhaartaydan waxba kaa ma saarna, laakiin wiilkayga halkaas ha ku celin. ");
INSERT INTO som_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Addoonkii wuxuu gacantiisii hoos dhigay bowdadii sayidkiisii Ibraahim, wuxuuna ugu dhaartay wax arrintan ku saabsan. ");
INSERT INTO som_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Addoonkiina wuxuu kaxeeyey toban awr, oo ka mid ah awrtii sayidkiisa, wuuna tegey, isagoo gacantiisa ku haya waxyaalihii sayidkiisa oo wanaagsanaa oo dhan, oo intuu kacay ayuu tegey Mesobotamiya, xagga magaalada Naaxoor. ");
INSERT INTO som_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Awrtiina wuxuu tu'iyey meel magaalada dibaddeeda ah oo ceelka biyaha agtiisa ah kolkay galabtii ahayd, marka dumarku biyo dhaansiga u soo baxaan. ");
INSERT INTO som_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Oo wuxuu yidhi, Rabbiyow, sayidkayga Ibraahim Ilaahiisow, waan ku baryayaaye, maanta i liibaani, sayidkayga Ibraahimna u roonow. ");
INSERT INTO som_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Bal eeg, waxaan ag taaganahay isha biyaha ah, gabdhaha dadka magaaladuna waxay u soo baxayaan inay biyo dhaansadaan. ");
INSERT INTO som_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Gabadhii aan ku odhan doono, Ashuunkaaga deji, waan ku baryayaaye, aan ka cabbee, oo igu odhan doonta, Cab, awrtaadana waan waraabin doonaa, taasu ha noqoto tii aad u dooratay addoonkaaga Isxaaq, oo taas baan ku ogaan doonaa inaad sayidkayga u roonaatay. ");
INSERT INTO som_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Intuusan hadalkii dhammayn, waxaa soo baxday, iyadoo ashuunkeedii garabka ku sidata, Rebeqah oo u dhalatay Betuu'el wiilkii Milkah, oo ahayd naagtii Naaxoorkii ahaa Ibraahim walaalkiis. ");
INSERT INTO som_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Gabadhuna waa suurad quruxsanayd, waxayna ahayd bikrad aan ninna u tegin. Waxay tagtay ishii biyaha ahayd xaggeeda, oo intay ashuunkeedii soo buuxsatay, ayay soo baxday. ");
INSERT INTO som_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Markaasuu addoonkii ku orday inuu ka hor tago oo wuxuu ku yidhi, Ashuunkaaga iga waraabi in yar oo biyo ah, waan ku baryayaaye. ");
INSERT INTO som_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Markaasay tidhi, Cab, sayidkaygiiyow. Oo intay dhaqsatay ayay ashuunkeedii dejisay oo gacanta ku qabatay, wayna waraabisay. ");
INSERT INTO som_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Oo markii ay waraabisay ka dib ayay ku tidhi, Awrtaadana waan u dhaamin doonaa, ilaa ay wabxaan. ");
INSERT INTO som_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Oo intay dhaqsatay ayay biyihii ashuunkeedii ku shubtay berkeddii, oo mar kalay ceelkii ku orodday inay soo dhaamiso, wayna u dhaamisay awrtiisii oo dhan. ");
INSERT INTO som_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Ninkiina aad buu u fiiriyey iyada, isagoo aamusan, inuu ogaado in Rabbigu ku liibaaniyey sodcaalkiisii iyo in kale. ");
INSERT INTO som_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Markii awrtii cabtay ka dib ayaa ninkii soo qaaday sangelis dahab ah oo miisaankiisu yahay nus sheqel, gacmaheedana wuxuu u soo qaaday laba dugaagadood oo dahab ah oo miisaankoodu yahay toban sheqel. ");
INSERT INTO som_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Oo wuxuu ku yidhi, Ina ayaad tahay? Waan ku baryayaaye, ii sheeg. Guriga aabbahaa meel aannu ku hoyanno ma leeyahay? ");
INSERT INTO som_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Oo waxay ku tidhi isagii, Anigu waxaan ahay ina Betuu'el, wiilkii Milkah ay Naaxoor u dhashay. ");
INSERT INTO som_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Oo weliba waxa kale oo ay ku tidhi, Caws iyo cunto badanba waannu haysannaa, iyo meel lagu hoydo. ");
INSERT INTO som_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Markaasaa ninkii madaxa foororiyey oo Rabbiga caabuday. ");
INSERT INTO som_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Markaasuu yidhi, Mahad waxaa leh Rabbiga ah sayidkayga Ibraahim Ilaahiisa, oo aan naxariistiisa iyo runtiisa ka joojin sayidkayga. Anigana Rabbigu jidkuu igu soo hoggaamiyey, oo wuxuu i keenay gurigii sayidkayga walaalihiis. ");
INSERT INTO som_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Gabadhiina intay orodday ayay waxyaalahan dadkii guriga hooyadeed uga warrantay. ");
INSERT INTO som_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebeqahna waxay lahayd walaal magiciisa la yidhaahdo Laabaan. Markaasaa Laabaan dibadda u baxay oo wuxuu ku orday ninkii isha joogay. ");
INSERT INTO som_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Markuu arkay sangeliskii, iyo dugaagadihii gacmihii walaashiis ku jiray, oo uu maqlay hadalkii walaashiis Rebeqah, iyadoo leh, Sidan buu ninkii iila hadlay, ayuu u yimid ninkii oo bal eeg, wuxuu ag istaagay awrtii isha joogtay. ");
INSERT INTO som_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Oo wuxuu ku yidhi, Kaaga Rabbigu barakeeyeyow, soo gal, maxaad dibadda u taagan tahay? Gurigii waan soo hagaajiyey, awrtana meel baan u diyaariyey. ");
INSERT INTO som_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Ninkiina gurigii buu soo galay, awrtiina wuu furay, wuxuuna isaga awrtii ugu dhiibay caws iyo cunto, biyona wuu siiyey inay ku cago maydhaan isaga iyo raggii la socdayba. ");
INSERT INTO som_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Cuntona waa la hor dhigay inuu cuno: laakiinse wuxuu yidhi, Cuni maayo ilaa aan sheego farriintayda. Kolkaasuu yidhi, Sheeg. ");
INSERT INTO som_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Markaasuu yidhi, Waxaan ahay Ibraahim addoonkiisa. ");
INSERT INTO som_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Rabbigu aad iyo aad buu u barakeeyey sayidkayga, wuuna weynaaday: wuxuuna siiyey adhi iyo lo', iyo lacag iyo dahab, iyo rag addoommo ah, iyo naago addoommo ah, iyo geel iyo dameerro. ");
INSERT INTO som_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Saarah oo ahayd sayidkayga naagtiisii ayaa wiil u dhashay sayidkayga markay gabowday, oo wuxuu isaga siiyey wuxuu leeyahay oo dhan. ");
INSERT INTO som_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Sayidkayguna wuu i dhaariyey, isagoo leh, Wiilkayga waa inaanad naag uga guurin gabdhaha reer Kancaanka aan dalkooda degganahay. ");
INSERT INTO som_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Laakiinse waxaad u kacdaa gurigii aabbahay, iyo xigaalkaygii, oo wiilkayga naag uga keen. ");
INSERT INTO som_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Markaasaan sayidkaygii ku idhi, Waxaa laga yaabaa inaanay naagtu i soo raaci doonin. ");
INSERT INTO som_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Oo wuxuu igu yidhi, Rabbiga aan hortiisa ku socdo wuxuu ku raacin doonaa malaa'igtiisa, jidkaagana wuu kugu liibaanin doonaa, wiilkaygana naag baad uga guurin doontaa xigaalkaygii iyo gurigii aabbahay, ");
INSERT INTO som_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","dabadeedna dhaartayda waxba kaama saarna, markaad u tagto xigaalkay; oo hadday iyada ku siin waayaan, markaas dhaartayda waxba kaama saarna. ");
INSERT INTO som_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Maantaan isha imid oo waxaan idhi, Rabbiyow, sayidkayga Ibraahim Ilaahiisow, haddaad haatan jidkayga aan ku socdo igu liibaanisid, ");
INSERT INTO som_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","bal eeg, waxaan ag taaganahay isha biyaha ah, gabadhii u soo baxda inay biyo dhaansato oo aan ku odhan doono, Waan ku baryayaaye, ashuunkaaga iga sii in yar oo biyo ah aan cabbee, ");
INSERT INTO som_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","oo igu odhan doonta, Cab, awrtaadana waan u dhaamin doonaa, taasu ha noqoto tii Rabbigu u doortay wiilka sayidkayga. ");
INSERT INTO som_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Oo intaan hadalkii qalbigayga ka dhammaan ayaa Rebeqah soo baxday iyadoo ashuunkeedii garabka ku sidata, markaasay ishii ku dhaadhacday, oo soo dhaansatay: anna waxaan ku idhi, Waan ku baryayaaye, i waraabi. ");
INSERT INTO som_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Iyana intay dhaqsatay oo ay ashuunkeedii garabkeeda ka soo dejisay ayay tidhi, Cab, awrtaadana waan waraabin doonaa: sidaas daraaddeed waan cabbay, awrtiina way waraabisay. ");
INSERT INTO som_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Markaasaan weyddiiyey oo ku idhi, Ina ayaad tahay? Oo waxay tidhi, Ina Betuu'el wiilkii Naaxoor ay Milkah u dhashay isaga. Markaasaan sangeliskii sanka u sudhay; dugaagadihiina gacmaha u geliyey. ");
INSERT INTO som_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Kolkaasaan madaxa foororiyey, oo Rabbiga caabuday, oo waxaan ammaanay Rabbiga ah sayidkayga Ibraahim Ilaahiisa, oo igu soo hoggaamiyey jidkii toosnaa, inaan gabadhii sayidkayga walaalkiis u kaxeeyo wiilkiisa. ");
INSERT INTO som_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Haddaba haddaad sayidkayga ula macaamiloonaysaan si raxmad leh oo daacad ah, ii sheega: haddii kalese ii sheega, inaan u leexdo xagga midigta ama xagga bidixda. ");
INSERT INTO som_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Markaasay Laabaan iyo Betuu'el jawaabeen oo yidhaahdeen, Waxanu wuxuu ka soo baxay xagga Rabbiga, annana kugulama hadli karno xumaan iyo samaan toona. ");
INSERT INTO som_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Bal eeg, Rebeqah waa ku hor joogtaaye, kaxee oo la tag, oo ha noqoto sayidkaaga wiilkiisii naagtiisa, sidii Rabbigu ku hadlay. ");
INSERT INTO som_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Markii uu Ibraahim addoonkiisii hadalkoodii maqlay ayuu Rabbiga u sujuuday. ");
INSERT INTO som_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Markaasuu addoonkii soo bixiyey jowharro lacag ah iyo jowharro dahab ah, iyo dhar, oo Rebeqah siiyey: walaalkeed iyo hooyadeedna wuxuu siiyey waxyaalo qaali ah. ");
INSERT INTO som_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Markaasay wax cuneen oo wax cabbeen, isaga iyo raggii la jirayba, habeenkii oo dhanna halkaasay joogeen. Aroortii bay kaceen oo wuxuu yidhi, Xagga sayidkaygii ii dira. ");
INSERT INTO som_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Walaalkeed iyo hooyadeedna waxay yidhaahdeen, Gabadhu ha nala joogto dhawr maalmood, ugu yaraan toban beri; dabadeedna way tegi doontaa. ");
INSERT INTO som_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Markaasuu ku yidhi iyagii, Rabbigu waa igu liibaaniyey jidkaygii, sidaas daraaddeed ha i raajinina, ee i dira inaan sayidkaygii u tago. ");
INSERT INTO som_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Markaasay yidhaahdeen, Gabadha waannu u yeedhi doonnaa oo weyddiin doonnaa. ");
INSERT INTO som_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Markaasay Rebeqah u yeedheen, oo waxay ku yidhaahdeen, Ninkan ma raacaysaa? Oo waxay tidhi, Haah, waan raacayaa. ");
INSERT INTO som_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Markaasay walaashood Rebeqah direen, iyada iyo midiidinteedii, iyo addoonkii Ibraahim, iyo raggiisiiba. ");
INSERT INTO som_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Oo Rebeqah bay u duceeyeen oo ku yidhaahdeen, Walaashayoy, kumanyaal kun hooyadood noqo, farcankaaguna kuwa iyaga neceb iriddooda ha hantiyeen. ");
INSERT INTO som_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Rebeqahna way kacday, iyada iyo gabdhaheediiba, oo waxay fuuleen awrtii, ninkiina way raaceen: addoonkiina wuu kaxeeyey Rebeqah, wuuna tegey. ");
INSERT INTO som_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Isxaaqna wuxuu ka yimid xagga jidka Bi'ir Lahayroy, waayo, wuxuu degganaa dhulka Koonfureed. ");
INSERT INTO som_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Oo gabbaldhicii ayaa Isxaaq berrinka u soo baxay inuu fikiro: markaasuu indhihiisa kor u taagay, oo wax fiiriyey, oo wuxuu arkay awr soo socota. ");
INSERT INTO som_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeqahna indhaheedii bay kor u taagtay, oo markay Isxaaq aragtay ayay ratigii ka degtay. ");
INSERT INTO som_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Oo waxay addoonkii ku tidhi, Waa ayo ninkaas berrinka dhex socda, oo inaga hor imanaya? Addoonkiina wuxuu yidhi, Waa sayidkaygii. Markaasay indhashareerteedii qaadatay oo hagoogatay. ");
INSERT INTO som_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Addoonkiina wuxuu Isxaaq u sheegay wixii uu sameeyey oo dhan. ");
INSERT INTO som_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Isxaaqna wuxuu iyadii soo geliyey teendhadii hooyadiis Saarah, Rebeqahna wuu guursaday, oo naagtiisii bay noqotay. Wuuna jeclaaday iyada, oo Isxaaq waxaa laga qalbi qabowjiyey geeridii hooyadiis. ");
INSERT INTO som_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ibraahim wuxuu guursaday naag kale, magaceeduna wuxuu ahaa Qetuurah. ");
INSERT INTO som_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Oo waxay u dhashay Simraan, iyo Yoqshaan, iyo Medaan, iyo Midyaan, iyo Yishbaaq, iyo Shuu'ah. ");
INSERT INTO som_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yoqshaanna wuxuu dhalay Shebaa, iyo Dedaan. Wiilashii Dedaanna waxay ahaayeen Ashuurim, iyo Letushim, iyo Le'ummiim. ");
INSERT INTO som_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Wiilashii Midyaanna waxay ahaayeen Ceefah, iyo Ceefer, iyo Xanoog, iyo Abiidac iyo Eldacah. Kuwanu waxay wada ahaayeen carruurtii Qetuurah. ");
INSERT INTO som_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ibraahimna wax alla wuxuu lahaa wuxuu siiyey Isxaaq. ");
INSERT INTO som_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Laakiinse naagihii addoommada ahaa oo Ibraahim haystay wuxuu wiilashoodii siiyey hadiyado, oo intuu isagu noolaa ayuu ka diray wiilkiisii Isxaaq, bari buuna u diray xagga dhulka bari. ");
INSERT INTO som_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Sannadihii Ibraahim noolaa oo cimrigiisu ahaa waa boqol iyo shan iyo toddobaatan sannadood. ");
INSERT INTO som_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Ibraahimna waa naf baxay, cimri wanaagsan buuna ku dhintay, isagoo duq ah, oo sannado badan jiray; oo wuxuu ku darmaday dadkiisii. ");
INSERT INTO som_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Markaasay wiilashiisii Isxaaq iyo Ismaaciil ku aaseen godkii Makfelah, oo ku dhex yiil berrinkii Cefroon ina Sohar oo ahaa reer Xeed oo ku hor yiil Mamre; ");
INSERT INTO som_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","berrinkaas oo ahaa kii Ibraahim ka iibsaday reer Xeed. Halkaasaa lagu aasay Ibraahim iyo naagtiisii Saarahba. ");
INSERT INTO som_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Ibraahim geeridiisii ka dib ayaa Ilaah barakeeyey wiilkiisii Isxaaq; Isxaaqna wuxuu ag degganaa Bi'ir Lahayroy. ");
INSERT INTO som_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Haddaba kuwanu waa farcankii Ismaaciil ina Ibraahim, kii Haagaar tii Masriyadda ahayd oo Saarah midiidinteedii ahayd ay u dhashay Ibraahim. ");
INSERT INTO som_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Kuwanuna waa magacyadii wiilashii Ismaaciil, magacyadoodii sidii farcankoodii ahaa. Curadkii Ismaaciil wuxuu ahaa Nebayod; waxaana ku xigay Qedaar, iyo Adbe'el, iyo Mibsam, ");
INSERT INTO som_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","iyo Mishmaac, iyo Duumah, iyo Masa; ");
INSERT INTO som_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadar, iyo Tema, iyo Yetuur, iyo Nafish, iyo Qedemah. ");
INSERT INTO som_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Kuwanu waa wiilashii Ismaaciil, kuwanuna waa magacyadoodii sidii ay tuulooyinkoodii iyo xeryahoodii ahaayeen; waxayna lahaayeen laba iyo toban amiir sidii ay qolooyinkoodii ahaayeen. ");
INSERT INTO som_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Sannadihii Ismaaciil noolaa waa boqol iyo toddoba iyo soddon sannadood, wuuna naf baxay, oo dhintay; wuxuuna ku darmaday dadkiisii. ");
INSERT INTO som_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Waxayna degganaayeen tan iyo Xawiilaah iyo Shuur tan ku hor taal Masar, haddaad u kacdo xagga Ashuur. Walaalihiis oo dhan hortooda ayuu degay. ");
INSERT INTO som_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Kuwanuna waa farcankii Isxaaq ina Ibraahim. Ibraahim Isxaaq buu dhalay: ");
INSERT INTO som_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isxaaqna afartan sannadood buu jiray markuu guursaday Rebeqah ina Betuu'el kii dalkiisu ahaa Suuriya ee reer Fadan Araam, iyadoo ahayd Laabaan kii dalkiisu Suuriya ahaa walaashiis. ");
INSERT INTO som_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isxaaqna naagtiisuu Rabbiga u baryay, maxaa yeelay, madhalays bay ahayd, Rabbiguna waa ka aqbalay, markaasay naagtiisii Rebeqah uuraysatay. ");
INSERT INTO som_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Carruurtiina uurkeeday isku dhex riixriixeen; markaasay tidhi, Hadday saas tahay, maxaan sidan u ahay? Kolkaasay u tagtay inay Rabbiga wax weyddiiso. ");
INSERT INTO som_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Rabbiguna wuxuu ku yidhi iyada, Laba quruumood baa maxalkaaga ku jirta, Oo laba dad oo kala duwan ayaa uurkaaga ka soo bixi doona; Oo labada dad midkood baa ka xoog badnaan doona dadka kale; Kan weynuna wuxuu u adeegi doonaa kan ka yar. ");
INSERT INTO som_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Oo markii wakhtigii ay umuli lahayd dhammaaday, bal eeg, waxaa maxalkeedii ku jiray mataano. ");
INSERT INTO som_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Oo kii hore wuu soo baxay isagoo cas, korkiisa oo dhammuna wuxuu u ekaa dhar dhogor laga sameeyey, magiciisiina waxay u baxsheen Ceesaw. ");
INSERT INTO som_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Dabadeedna waxaa soo baxay walaalkiis, gacantiisuna waxay ku dhegganayd cedhibta Ceesaw; magiciisiina waxaa loo bixiyey Yacquub; Isxaaqna lixdan sannadood buu jiray markay iyaga dhashay. ");
INSERT INTO som_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Wiilashiina way koreen: oo Ceesaw wuxuu ahaa nin ugaadhsiga aad u yaqaan, wuxuuna ahaa nin duurgal ah; Yacquubna wuxuu ahaa nin aamusan oo teendhooyin degi jiray. ");
INSERT INTO som_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isxaaqna wuu jeclaa Ceesaw, maxaa yeelay, wuxuu cuni jiray hilibkiisii ugaadha; Rebeqahna waxay jeclayd Yacquub. ");
INSERT INTO som_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Yacquub wuxuu karsaday fuud; markaasaa waxaa duurka ka yimid Ceesaw, wuuna daalanaa. ");
INSERT INTO som_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Markaasaa Ceesaw wuxuu Yacquub ku yidhi, Waan ku baryayaaye, i sii aan cunee fuudkaas cas, waayo, waan daalanahay. Sidaas daraaddeed magiciisii waxaa loo bixiyey Edom. ");
INSERT INTO som_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yacquubna wuxuu yidhi, Maanta iga iibi curadnimadaada. ");
INSERT INTO som_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Markaasaa Ceesaw yidhi, Bal eeg, geeri baan ku dhowahay; haddaba curadnimadu maxay ii taraysaa? ");
INSERT INTO som_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Markaasaa Yacquub ku yidhi, Maanta ii dhaaro. Kolkaasuu u dhaartay, curadnimadiisiina wuxuu ka iibiyey Yacquub. ");
INSERT INTO som_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Yacquubna wuxuu Ceesaw siiyey kibis iyo fuud digir laga sameeyey, wuuna cunay oo cabbay, markaasuu intuu kacay, iska tegey. Sidaasuu Ceesaw u quudhsaday curadnimadiisii. ");
INSERT INTO som_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Waxaa dhulkii ka dhacday abaar, oo aan ahayn tii hore oo waagii Ibraahim dhacday. Markaasaa Isxaaq u kacay xagga Abimeleg oo ahaa boqorkii reer Falastiin xagga Geraar. ");
INSERT INTO som_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Rabbiguna wuu u muuqday isaga, oo wuxuu ku yidhi, Xagga Masar ha u dhaadhicin, laakiinse deg dhulka aan kuu sheegi doono. ");
INSERT INTO som_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Dhulkan qariib ahaan u deg, oo anna waan kula jiri doonaa, oo waan ku barakayn doonaa; waayo, adiga iyo farcankaaga ayaan dalalkan oo dhan siin doonaa, oo waxaan adkayn doonaa dhaartii aan ugu dhaartay aabbahaa Ibraahim. ");
INSERT INTO som_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Farcankaagana waxaan u tarmin doonaa sida xiddigaha samada, oo waxaan farcankaaga siin doonaa dalalkan oo dhan, farcankaagayna quruumaha dunida oo dhammu ku barakoobi doonaan; ");
INSERT INTO som_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","maxaa yeelay, Ibraahim baa addeecay codkaygii, wuxuuna dhawray wixii la ii dhawri lahaa, iyo xukummadaydii, iyo amarradaydii, iyo qaynuunnadaydii. ");
INSERT INTO som_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Isxaaqna wuxuu degganaa Geraar: ");
INSERT INTO som_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","oo dadkii meeshaas joogay baa naagtiisii ka warsaday, oo wuxuu yidhi, Iyadu waa walaashay: waayo, wuu ka cabsaday inuu yidhaahdo, Waa naagtaydii, oo wuxuu isyidhi, waaba intaasoo ay dadka meeshanu igu dilaan Rebeqah aawadeed, maxaa yeelay, way suurad quruxsanayd. ");
INSERT INTO som_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Markuu halkaas wakhti dheer joogay ayaa Abimeleg oo ahaa boqorkii reer Falastiin daaqad ka fiiriyey, oo uu arkay Isxaaq oo naagtiisii Rebeqah la qooqaya. ");
INSERT INTO som_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Markaasuu Abimeleg Isxaaq u yeedhay, oo yidhi, Hubaal iyadu waa naagtaadii. De sidee baad ku tidhi, Waa walaashay? Isxaaqna wuxuu ku yidhi, Maxaa yeelay, waxaan is-idhi, Waaba intaasoo aad u dhimatid iyada aawadeed. ");
INSERT INTO som_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Oo Abimelegna wuxuu ku yidhi, War waa maxay waxan aad nagu samaysay? Mid dadka ka mid ahu dhib yaraan buu ula jiifsan lahaa naagtaada, oo kolkaasaad eed noo soo jiidi lahayd. ");
INSERT INTO som_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Markaasaa Abimeleg wuxuu dadkii oo dhan ku amray, oo yidhi, Kii ninkan ama naagtiisa taabta hubaal naftaa laga qaadi doonaa. ");
INSERT INTO som_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isxaaqna dhulkaasuu wax ku beertay, isla sannaddiina wuxuu helay boqol laab; Rabbiguna wuu barakeeyey isagii. ");
INSERT INTO som_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Ninkiina wuu weynaaday, oo hor u maray, ilaa uu noqday nin aad u weyn, ");
INSERT INTO som_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","wuxuuna lahaa adhi iyo lo', iyo addoommo fara badan; markaasay reer Falastiin ka masayreen. ");
INSERT INTO som_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Ceelashii addoommada aabbihiis qodeen oo dhan waagii aabbihiis Ibraahim noolaa ayay reer Falastiin hore u awdeen oo ciid uga buuxiyeen. ");
INSERT INTO som_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Abimelegna wuxuu Isxaaq ku yidhi, Naga tag; waayo, aad baad nooga xoog badan tahay. ");
INSERT INTO som_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Markaasaa Isxaaq halkaas ka tegey, oo dooxadii Geraar degay, halkaasuuna joogay. ");
INSERT INTO som_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Kolkaasaa Isxaaq mar kale qoday ceelashii biyaha oo ay qodeen waagii aabbihiis Ibraahim noolaa, waayo, reer Falastiin baa awday markii Ibraahim dhintay ka dib, oo wuxuu magacyadoodii u bixiyey magacyadii aabbihiis Ibraahim u bixiyey. ");
INSERT INTO som_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Markaasaa addoommadii Isxaaq dooxadii qodeen, oo waxay ka heleen ceel durdur ah. ");
INSERT INTO som_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Markaasaa xoolojirradii reer Geraar la dirireen xoolojirradii Isxaaq, iyagoo leh, Biyaha annagaa leh. Ceelka magiciisiina wuxuu u bixiyey Ceseq, maxaa yeelay, way la dirireen isagii. ");
INSERT INTO som_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Ceel kalena way qodeen, oo kaasna way kula dirireen, markaasuu magiciisii u bixiyey Sitnah. ");
INSERT INTO som_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Kolkaasuu meeshaas ka guuray, oo wuxuu qoday ceel kale; kaasna kulama ay diririn; magiciisiina wuxuu u bixiyey Rexobod, oo wuxuu yidhi, Haatan Rabbigu meel buu noo banneeyey, oo dalka waannu ku badnaynaa. ");
INSERT INTO som_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Markaasuu halkaas ka tegey, oo wuxuu u kacay Bi'ir Shebac. ");
INSERT INTO som_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Oo isla habeenkaas ayaa Rabbigu u muuqday isagii oo ku yidhi, Waxaan ahay aabbahaa Ibraahim Ilaahiisa. Ha cabsan, waayo, waan kula jiraa, oo waan ku barakayn doonaa, farcankaagana waan tarmin doonaa addoonkaygii Ibraahim aawadiis. ");
INSERT INTO som_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Kolkaasuu halkaas ka dhisay meel allabari, oo magaca Rabbiga ku baryootamay, halkaas buuna teendhadiisii ka dhisay, markaasaa addoommadii Isxaaq halkaas ceel ka qodeen. ");
INSERT INTO som_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Dabadeedna Abimeleg iyo saaxiibkiis Axusad, iyo Fiikol oo ahaa madaxda ciidankiisa ayaa Geraar ka tegey oo Isxaaq u kacay. ");
INSERT INTO som_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Markaasaa Isxaaq ku yidhi, Maxaad iigu timaadeen, waabad i neceb tihiine, oo aad iska kay erideene? ");
INSERT INTO som_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Oo waxay yidhaahdeen, Caddaan baannu u aragnay in Rabbigu kula jiro; oo waxaannu nidhi, Annaga iyo adiga dhaaru ha inoo dhexayso oo aynu axdi dhiganno, ");
INSERT INTO som_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","inaadan wax na yeelayn, sidii annana aannan kuu taaban, oo aannan waxba kuugu samayn wanaag mooyaane, oo aannu nabad kuugu dirnay. Adigu hadda waxaad tahay kan Rabbigu barakeeyey. ");
INSERT INTO som_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Diyaafad buuna u sameeyey, wayna cuneen oo cabbeen. ");
INSERT INTO som_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Kolkaasay aroor hore kaceen, oo isu dhaardhaarteen: markaasaa Isxaaq iska diray, iyana nabad bay kaga ambabbaxeen. ");
INSERT INTO som_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Oo isla maalintaas ayay addoommadii Isxaaq yimaadeen, oo ay uga warrameen ceelkii ay qodeen, oo waxay ku yidhaahdeen, Biyaannu helnay. ");
INSERT INTO som_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Markaasuu u bixiyey Shebcaah; sidaas daraaddeed magaaladaas magaceeda waxaa ilaa maantadan la yidhaahdaa Bi'ir Shebac. ");
INSERT INTO som_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Ceesaw markuu afartan sannadood jiray ayuu guursaday Yuhuudiid ina Be'eerii kii reer Xeed, iyo Basmad ina Eeloon kii reer Xeed. ");
INSERT INTO som_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Kuwaasuna Isxaaq iyo Rebeqah ayay caloolxumo geliyeen. ");
INSERT INTO som_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Markii Isxaaq gaboobay, oo ay indhihiisii u arag darnaayeen si uusan waxba arki karin, ayuu u yeedhay wiilkiisii weynaa oo Ceesaw ahaa, oo wuxuu ku yidhi, Wiilkaygiiyow. Isaguna wuxuu yidhi, Waa i kan. ");
INSERT INTO som_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Markaasuu yidhi, Bal i eeg, haatan waan gaboobay, garanna maayo maalinta dhimashadayda. ");
INSERT INTO som_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Sidaas daraaddeed waan ku baryayaaye, qaado hubkaaga, gabooyahaaga iyo qaansadaada, oo duurka u bax, oo hilib ugaadheed ii keen; ");
INSERT INTO som_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","oo ii samee hilib macaan, oo ah kan aan jeclahay, oo ii keen, aan cunee, inay naftaydu kuu ducayso intaanan dhiman. ");
INSERT INTO som_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Rebeqahna way maqashay markii Isxaaq la hadlay wiilkiisii Ceesaw. Ceesawna duurkuu u kacay inuu ugaadh soo dilo oo uu keeno. ");
INSERT INTO som_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Markaasay Rebeqah la hadashay wiilkeedii Yacquub, oo tidhi, Waxaan maqlay aabbahaa oo la hadlaya walaalkaa Ceesaw, isagoo leh, ");
INSERT INTO som_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Hilib ugaadheed ii keen, oo ii samee hilib macaan, aan cunee, oo aan kuugu duceeyee Rabbiga hortiis intaanan dhimane. ");
INSERT INTO som_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Haddaba sidaas daraaddeed, wiilkaygiiyow, codkayga u addeec sida aan kuugu amro. ");
INSERT INTO som_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Bal adhiga u kac, oo iiga keen laba waxar oo wanwanaagsan, oo waxaan aabbahaa uga samayn hilib macaan, oo ah kan uu jecel yahay, ");
INSERT INTO som_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","adna aabbahaa waad u geeyn doontaa inuu cuno, si uu kuugu duceeyo intuusan dhiman. ");
INSERT INTO som_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Yacquubna wuxuu hooyadiis Rebeqah ku yidhi, Walaalkay Ceesaw waa nin xaad badan, anna waxaan ahay nin xaad yar. ");
INSERT INTO som_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Mindhaa aabbahay waa i taaban doonaa, oo markaasaan ula ekaan doonaa khaa'in, oo habaar baan isu soo jiidi doonaa, ducose ma heli doono. ");
INSERT INTO som_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Oo hooyadiis baa ku tidhi, Wiilkaygiiyow, habaarkaagu aniga ha igu dhaco: codkayga uun addeec, oo orod oo ii keen iyaga. ");
INSERT INTO som_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Markaasuu tegey, oo soo kaxeeyey, oo u keenay hooyadiis, hooyadiisna waxay samaysay hilib macaan, oo ah sidii kii aabbihiis jeclaa. ");
INSERT INTO som_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Markaasaa Rebeqah waxay soo qaadday dharkii wanaagsanaa oo wiilkeedii weynaa oo ahaa Ceesaw, oo ay guriga ku haysay, oo waxay u xidhay wiilkeedii yaraa oo ahaa Yacquub; ");
INSERT INTO som_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","markaasay waxarihii hargahoodii ku xidhay gacmihiisii iyo intii aan xaadda lahayn oo luquntiisii. ");
INSERT INTO som_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Markaasay hilibkii macaanaa iyo kibistii ay diyaarisay u dhiibtay wiilkeedii Yacquub. ");
INSERT INTO som_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Kolkaasuu aabbihiis u yimid, oo yidhi, Aabbow. Isna wuxuu yidhi, Waa i kan. Kumaad tahay, wiilkaygiiyow? ");
INSERT INTO som_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yacquubna wuxuu aabbihiis ku yidhi, Waxaan ahay curadkaagii Ceesaw. Waan sameeyey sidii aad iigu amartay. Haddaba waan ku baryayaaye, kac oo fadhiiso oo cun hilibkaygan ugaadheed, si aad iigu ducayso. ");
INSERT INTO som_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isxaaqna wuxuu wiilkiisii ku yidhi, Wiilkaygiiyow, sidee baad dhaqso ugu soo heshay? Isna wuxuu yidhi, Maxaa yeelay, Rabbiga ah Ilaahaaga ayaa ii keenay. ");
INSERT INTO som_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Isxaaqna wuxuu Yacquub ku yidhi, Soo dhowow, waan ku baryayaaye, aan ku taabtee, wiilkaygiiyow, bal inaad tahay wiilkaygii Ceesaw iyo in kale. ");
INSERT INTO som_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yacquubna waa u dhowaaday aabbihiis Isxaaq; markaasuu taabtay oo yidhi, Codku waa codkii Yacquub, gacmuhuse waa gacmihii Ceesaw. ");
INSERT INTO som_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Mana uu garanin, maxaa yeelay, gacmihiisu xaad miidhan bay ahaayeen sidii gacmihii walaalkiis Ceesaw; sidaas daraaddeed wuu u duceeyey. ");
INSERT INTO som_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Kolkaasuu yidhi, War ma tahay wiilkaygii Ceesaw qudhiisii? Isna wuxuu yidhi, Waan ahay. ");
INSERT INTO som_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Markaasuu ku yidhi. Bal ii soo dhowee, aan cunee wiilkayga hilibkiisa ugaadheed, si aan kuugu duceeyo. Kolkaasuu u soo dhoweeyey, oo isna wuu cunay: oo wuxuu kaloo u keenay khamri, wuuna cabbay. ");
INSERT INTO som_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Markaasaa aabbihiis Isxaaq ku yidhi, Bal ii soo dhowow, oo i dhunko, wiilkaygiiyow. ");
INSERT INTO som_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Isna wuu u soo dhowaaday, oo wuu dhunkaday. Markaasuu ursaday dharkiisa, wuuna u duceeyey, oo yidhi, Bal eeg, urta wiilkaygu Waa sida urta duurka Rabbigu barakeeyey, ");
INSERT INTO som_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Ilaahu ha ku siiyo sayaxa samada, Iyo barwaaqada dhulka, Iyo hadhuudh iyo khamri badan. ");
INSERT INTO som_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Dadyowgu ha kuu adeegeen, Quruumuhuna ha kuu sujuudeen. Walaalahaa sayid u noqo, Wiilasha hooyadaana ha kuu sujuudeen. Ha inkaarnaado ku kasta oo ku inkaaraa, Ha ducaysnaado ku kasta oo kuu duceeyaa. ");
INSERT INTO som_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Markii Isxaaq dhammeeyey ducadii uu Yacquub u ducaynayay, Yacquubna ka tegey aabbihiis, ayaa walaalkiis Ceesaw ka yimid ugaadhsigii. ");
INSERT INTO som_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Oo isna hilib macaan buu sameeyey, oo u keenay aabbihiis; oo wuxuu ku yidhi aabbihiis, Aabbow kac, oo cun hilibkaygan ugaadheed, si aad iigu ducayso. ");
INSERT INTO som_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Markaasaa aabbihiis Isxaaq ku yidhi, Kumaad tahay? Isna wuxuu yidhi, Waxaan ahay wiilkaaga ah curadkaaga Ceesaw. ");
INSERT INTO som_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Markaasuu Isxaaq aad iyo aad u gariiray, oo yidhi, De yuu ahaa haddaba kii intuu hilib ugaadheed soo qaaday, ii keenay, oo aan kulli cunay intaadan iman ka hor, oo aan u duceeyey? Kaasu wuu ducaysnaan doonaa. ");
INSERT INTO som_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Ceesawna markuu maqlay hadalkii aabbihiis ayuu ku dhawaaqay dhawaaq aad iyo aad u weyn oo daran, oo wuxuu aabbihiis ku yidhi, Aabbahayow, anigana ii ducee. ");
INSERT INTO som_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Isna wuxuu yidhi, Walaalkaa baa khiyaano iila yimid oo ducadaadii qaatay. ");
INSERT INTO som_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Oo wuxuu yidhi, Miyaanay ku habboonayn in magiciisa loo bixiyo Yacquub? Waayo, labadan goor buu i khiyaaneeyey. Curadnimadaydii buu qaatay; haatanna wuxuu qaatay ducadaydii. Oo wuxuu yidhi, Miyaadan duco ii reebin? ");
INSERT INTO som_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isxaaqna wuu jawaabay oo wuxuu Ceesaw ku yidhi, Bal eeg, waxaan isaga ka dhigay sayidkaagii, walaalihiis oo dhanna waxaan u siiyey isaga inay addoommo u noqdaan, hadhuudh iyo khamrina waan u ballanqaaday, ee maxaan haddaba adiga kuu sameeyaa, wiilkaygiiyow? ");
INSERT INTO som_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Ceesawna wuxuu aabbihiis ku yidhi, Aabbahayow, ducadaadu ma mid keliya baa? Ii ducee anigana sidoo kale, Aabbow. Markaasuu Ceesaw aad u qayliyey oo ooyay. ");
INSERT INTO som_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Markaasaa aabbihiis Isxaaq u jawaabay oo ku yidhi, Bal eeg, rugtaadu waxay ahaan doontaa meel ka baxsan dhulka barwaaqadiisa Iyo sayaxa samada sare ka yimaada. ");
INSERT INTO som_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Oo waxaad ku noolaan doontaa seeftaada, walaalkaana waad u adeegi doontaa, Oo waxaa dhici doonta markaad xukunka qabsato Inaad harqoodkiisa surkaaga ka tuuri doonto. ");
INSERT INTO som_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Ceesawna wuxuu Yacquub u nebcaaday ducadii aabbihiis ugu duceeyey aawadeed. Ceesawna wuxuu isku yidhi, Maalmihii aabbahay loo barooran lahaa waa dhow yihiin; dabadeedna waan dili doonaa walaalkay Yacquub. ");
INSERT INTO som_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Rebeqahna waxaa loo sheegay hadalkii wiilkeedii weynaa oo ahaa Ceesaw; markaasay intay u cid dirtay u yeedhay wiilkeedii yaraa oo ahaa Yacquub, oo waxay ku tidhi isagii, Bal eeg, walaalkaa Ceesaw wuxuu isku qalbi qabowjiyaa talajirka uu ku talo jiro inuu ku dilo. ");
INSERT INTO som_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Haddaba sidaas daraaddeed wiilkaygiiyow, codkayga addeec. Kac oo u carar walaalkay Laabaan xagga Haaraan; ");
INSERT INTO som_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","oo dhawr maalmood isaga la joog, ilaa walaalkaa ciilku ka ba'ayo, iyo ilaa walaalkaa cadhaduu kuu qabo ka ba'ayso, ");
INSERT INTO som_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","oo uu ka illoobayo wixii aad ku samaysay: dabadeedna waan kuu soo cid diri doonaa, oo halkaasaan kaa soo kaxayn doonaa. Maxaan labadiinnaba isku maalin idiin waayayaa? ");
INSERT INTO som_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Rebeqahna waxay Isxaaq ku tidhi, Naftaydu waa rafaadsan tahay gabdhaha reer Xeed dartood. Haddii Yacquub naag ka guursado gabdhaha reer Xeed oo kuwan oo kale ah, kuwaas oo ah gabdhaha waddanka, noloshaydu maxay igu taraysaa? ");
INSERT INTO som_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Isxaaqna wuxuu u yeedhay Yacquub, wuuna u duceeyey, oo wuxuu ku amray, oo ku yidhi, Waa inaadan naag ka guursan gabdhaha reer Kancaan. ");
INSERT INTO som_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Kac oo xagga Fadan Araam tag, iyo xagga gurigii Betuu'el oo ah hooyadaa aabbeheed; oo halkaas naag ka guurso gabdhaha Laabaan oo ah hooyadaa walaalkeed. ");
INSERT INTO som_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Oo Ilaaha Qaadirka ahu ha ku barakeeyo, oo ha ku badiyo, oo ha ku tarmiyo, inaad noqotid dad faro badan, ");
INSERT INTO som_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","oo ha ku siiyo barakadii Ibraahim, adiga iyo farcankaaga kula joogaba, inaad dhaxashid dalka aad qariibka ku tahay, oo Ilaah Ibraahim siiyey. ");
INSERT INTO som_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Isxaaqna Yacquub wuu diray: oo wuxuu u kacay Fadan Araam xagga Laabaan, ina Betuu'el kii reer Suuriya, oo ahaa Rebeqah walaalkeed tii ahayd Yacquub iyo Ceesaw hooyadood. ");
INSERT INTO som_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Ceesawna wuxuu arkay in Isxaaq u duceeyey Yacquub oo u diray Fadan Araam, inuu halkaas naag ka guursado, iyo inuu markuu u duceeyey amray, oo ku yidhi, Waa inaadan naag ka guursan gabdhaha reer Kancaan; ");
INSERT INTO som_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","iyo in Yacquub addeecay aabbihiis iyo hooyadiis, oo uu u kacay xagga Fadan Araam. ");
INSERT INTO som_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Oo Ceesaw wuxuu arkay inaanay gabdhaha reer Kancaan ka farxin aabbihiis Isxaaq. ");
INSERT INTO som_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Markaasuu Ceesaw wuxuu u kacay xagga Ismaaciil, oo wuxuu naagihii uu qabay ku daray Mahalad gabadhii Ismaaciil ina Ibraahim, taas oo ahayd Nebayod walaashiis, si ay naagtiisii u noqoto. ");
INSERT INTO som_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yacquubna waa ka tegey Bi'ir Shebac, oo wuxuu u kacay xagga Haaraan. ");
INSERT INTO som_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Oo meel buu gaadhay oo halkaasuu habeenkii oo dhan joogay, maxaa yeelay, qorraxdu way dhacday, markaasuu qaaday mid ka mid ah dhagxantii meeshaas, oo barkaday, halkaasuuna jiifsaday si uu u seexdo. ");
INSERT INTO som_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Wuuna riyooday, oo riyadiisii wuxuu ku arkay sallaan dhulka qotoma oo caaraddiisiina samada gaadhay, wuxuuna arkay malaa'igihii Ilaah oo ku koraya, kuna soo degaya. ");
INSERT INTO som_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Oo bal eeg, Rabbigaa isdul taagay, oo yidhi, Waxaan ahay Rabbiga ah Ilaaha awowgaa Ibraahim, iyo Ilaaha Isxaaq. Dhulka aad ku jiifto, waxaan siin doonaa adiga iyo farcankaaga. ");
INSERT INTO som_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Farcankaaguna wuxuu noqon doonaa sida ciidda dhulka, oo waxaad ku firdhi doontaan tan iyo galbeed, iyo bari, iyo tan iyo woqooyi, iyo koonfur: oo adiga iyo farcankaagay qabiilooyinka dhulka oo dhammu ku barakoobi doonaan. ");
INSERT INTO som_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Oo bal eeg, waan kula jiraa, meel alla meeshii aad tagtidna waan kugu dhawri doonaa, dalkanna mar kalaan kugu soo celin doonaa; waayo, anigu kaa tegi maayo ilaa aan sameeyo wixii aan kugula hadlay. ");
INSERT INTO som_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Markaasuu Yacquub ka toosay hurdadiisii, oo wuxuu yidhi, Hubaal Rabbigaa halkan jooga, mana aan ogayn. ");
INSERT INTO som_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Wuuna cabsaday, oo wuxuu yidhi, Meeshanu cabsi badanaa! Tanu meel kale ma aha, gurigii Ilaah mooyaane, tanuna waa iriddii samada. ");
INSERT INTO som_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Yacquubna aroor horuu kacay, oo wuxuu qaaday dhagaxii uu barkaday, oo sidii tiir buu u qotomiyey, kolkaasuu saliid ku dul shubay. ");
INSERT INTO som_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Meeshaas magaceediina wuxuu u bixiyey Beytel: laakiinse markii hore magaalada magaceedu wuxuu ahaa Luus. ");
INSERT INTO som_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Yacquubna nidar buu nidray, oo wuxuu yidhi, Haddii Ilaah ila jiro, oo uu jidkan aan socdo igu dhawro, oo uu i siiyo wax aan cuno, iyo dhar aan xidho, ");
INSERT INTO som_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","oo aan aniga oo nabad qaba ku soo noqdo gurigii aabbahay, markaas Rabbigu wuxuu ii noqon doonaa Ilaah, ");
INSERT INTO som_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","oo dhagaxan aan sidii tiir u qotomiyey, wuxuu noqon doonaa guriga Ilaah: oo wax alla wixii aad i siisidna hubaal meel tobnaadka adigaan ku siin doonaa. ");
INSERT INTO som_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Yacquubna sodcaalkiisii buu iska sii watay, oo wuxuu yimid dalkii reer bari. ");
INSERT INTO som_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Kolkaasuu wax fiiriyey, oo wuxuu arkay ceel berrinka ku dhex yaal, oo waxaa joogay saddex qaybood oo ido ah oo agtiisa jiifjiifa, maxaa yeelay, ceelkaasay idaha ka waraabin jireen. Dhagaxa ceelka afkiisa saarnaana aad buu u weynaa. ");
INSERT INTO som_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Oo halkaasaa idaha oo dhan lagu soo ururin jiray: kolkaasay dhagaxa ceelka afkiisa ka rogi jireen, oo idaha ka waraabin jireen, markaasay mar labaad dhagaxa ceelka afkiisa saari jireen oo ku celin jireen meeshiisii. ");
INSERT INTO som_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Markaasaa Yacquub ku yidhi, Walaalahayow, xaggaad ka timaadeen? Iyana waxay yidhaahdeen, Waxaannu ka nimid Haaraan. ");
INSERT INTO som_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Markaasuu ku yidhi, Ma taqaaniin Laabaan oo ah ina Naaxoor? Markaasay ku yidhaahdeen, Waannu naqaan. ");
INSERT INTO som_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Markaasuu ku yidhi, Ma nabad qabaa? Iyana waxay yidhaahdeen, Haah, wuu nabad qabaa. Waa taas gabadhiisii Raaxeel idaha soo kaxaynaysa. ");
INSERT INTO som_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Oo wuxuu ku yidhi iyagii, Bal eega, weli waa maalin weyn, mana aha goortii xoolaha la soo wada ururin lahaa. Idaha waraabiya, oo kaxeeya oo daajiya. ");
INSERT INTO som_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Iyana waxay yidhaahdeen, Ma yeeli karno taas, jeeray idoyowga oo dhammu isu yimaadaan, oo dhagaxa ceelka afkiisa laga rogo; markaasaannu idaha waraabinaynaa. ");
INSERT INTO som_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Oo intuu weli la hadlayay ayaa Raaxeel keentay idihii aabbeheed, waayo, iyadaa ilaalin jirtay. ");
INSERT INTO som_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Oo Yacquub markuu arkay Raaxeel oo ahayd gabadhii abtigiis Laabaan, iyo idihii abtigiis Laabaan, ayuu u dhowaaday, oo dhagaxii ka rogay ceelka afkiisa, oo uu waraabiyey idihii abtigiis Laabaan. ");
INSERT INTO som_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Markaasuu Yacquub Raaxeel dhunkaday, wuuna qayliyey oo ooyay. ");
INSERT INTO som_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Yacquubna wuxuu Raaxeel u sheegay inuu yahay aabbeheed xigaalkiis, oo uu yahay wiilkii Rebeqah; kolkaasay orodday oo u sheegtay aabbeheed. ");
INSERT INTO som_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Oo Laabaan markuu maqlay warkii Yacquub oo ahaa wiilkii walaashiis ayuu ku orday inuu ka hor tago, markaasuu isku duubay, oo dhunkaday, oo uu gurigiisii keenay. Isna wuxuu Laabaan u sheegay waxyaalahan oo dhan. ");
INSERT INTO som_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Laabaanna wuxuu ku yidhi isagii, Hubaal waxaad tahay laftayda iyo jidhkayga. Wuxuuna la joogay isagii intii bil ah. ");
INSERT INTO som_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Markaasaa Laabaan Yacquub ku yidhi, Walaalkayga aad tahay aawadeed ma habboon tahay inaad mushahaarola'aan iigu shaqaysid? Bal ii sheeg, mushahaaradaadu maxay ahaan doontaa? ");
INSERT INTO som_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laabaanna wuxuu lahaa laba gabdhood: midda weyn magaceedu wuxuu ahaa Lee'ah, tan yar magaceeduna wuxuu ahaa Raaxeel. ");
INSERT INTO som_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lee'ahna way indha darnayd, laakiinse Raaxeel way quruxsanayd, suurad wanaagsanna way lahayd. ");
INSERT INTO som_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yacquubna wuxuu jeclaa Raaxeel; markaasuu yidhi, Toddoba sannadood baan kuugu shaqayn gabadhaada yar oo Raaxeel ah. ");
INSERT INTO som_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laabaanna wuxuu yidhi, Waa wanaagsan tahay inaan adiga ku siiyo intii aan iyada nin kale siin lahaa, ee ila joog. ");
INSERT INTO som_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Yacquubna toddoba sannadood buu u shaqaynayay Raaxeel aawadeed; waxayna la ahaayeen maalmo yar, waana jacaylkii uu iyada u qabay aawadiis. ");
INSERT INTO som_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Yacquubna wuxuu Laabaan ku yidhi, Maalmahaygii way dhammaystirmeen; ee naagtayda i sii, si aan ugu tago iyada. ");
INSERT INTO som_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Markaasuu Laabaan soo ururiyey nimankii meeshaas joogay oo dhan, oo wuxuu sameeyey diyaafad. ");
INSERT INTO som_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Oo waxay noqotay inuu fiidkii kaxeeyey gabadhiisii Lee'ah, oo uu u geeyey isagii; isna wuu u tegey iyadii. ");
INSERT INTO som_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Laabaanna wuxuu gabadhiisii Lee'ah siiyey Silfah oo isaga addoon u ahayd inay iyada addoon u noqoto. ");
INSERT INTO som_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Yacquubna wuxuu aroortii arkay inay tahay Lee'ah, oo wuxuu Laabaan ku yidhi, Waa maxay waxan aad igu samaysay? Miyaanan Raaxeel kuugu shaqaynayn? De maxaad haddaba ii khiyaanaysay? ");
INSERT INTO som_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laabaanna wuxuu yidhi, Dhulkayaga sidaas laguma sameeyo in tan yar curadda la dhaafiyo. ");
INSERT INTO som_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Bal tan toddobaadkeeda dhammee, tan kalena waxaannu kugu siin doonnaa shuqulka aad toddoba sannadood oo kale ii shaqayn doontid. ");
INSERT INTO som_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yacquubna sidii buu yeelay, toddobaadkeediina wuu dhammeeyey. Markaasuu Laabaan Yacquub siiyey gabadhiisii Raaxeel inay naag u noqoto. ");
INSERT INTO som_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Laabaanna wuxuu gabadhiisii Raaxeel siiyey Bilhah oo isaga addoon u ahayd inay iyada addoon u noqoto. ");
INSERT INTO som_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Oo Raaxeelna wuu u tegey, oo isna Raaxeel aad buu uga jeclaa Lee'ah, toddoba sannadood oo kalena wuu u shaqeeyey isaga. ");
INSERT INTO som_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Rabbiguna wuxuu arkay in Lee'ah la nebcaaday, markaasuu maxalkeedii furay; laakiinse Raaxeel waxay ahayd madhalays. ");
INSERT INTO som_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lee'ahna way uuraysatay, oo waxay dhashay wiil, magiciisiina waxay u bixisay Ruubeen, oo waxay tidhi, Sababtu waxaa weeye inuu Rabbigu dhibaatadayda arkay, oo haatan ninkaygu wuu i jeclaan doonaa. ");
INSERT INTO som_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Oo haddana way uuraysatay mar labaad, waxayna dhashay wiil, oo waxay tidhi, Rabbigu waa maqlay in lay nebcaaday, oo haddaba taas aawadeed ayuu ii siiyey wiilkanna; magiciisiina waxay u bixisay Simecoon. ");
INSERT INTO som_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Oo haddana mar kalay uuraysatay, oo waxay dhashay wiil, waxayna tidhi, Haatan ninkayga ayaa ila jiri doona, maxaa yeelay, saddex wiil baan u dhalay isaga; sidaas daraaddeed magiciisii waxaa loo bixiyey Laawi. ");
INSERT INTO som_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Oo haddana way uuraysatay, oo waxay dhashay wiil; oo waxay tidhi, Haatan Rabbigaan ammaani, sidaas daraaddeed waxay magiciisii u bixisay Yahuudah; wayna dhalmo daysay. ");
INSERT INTO som_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Raaxeelna markay aragtay inaanay Yacquub carruur u dhalin, ayay walaasheed ka masayrtay; oo waxay Yacquub ku tidhi, Carruur i sii, haddii kalese waan dhiman. ");
INSERT INTO som_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Markaasaa Yacquub aad ugu cadhooday Raaxeel; oo wuxuu ku yidhi, Ma anigaa ku jira meeshii Ilaaha midhihii maxalka kuu diiday? ");
INSERT INTO som_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Markaasay tidhi, Bal eeg addoontayda Bilhah, u tag iyada, inay jilbahayga ku dul dhasho, oo aan anna carruur ku helo iyada. ");
INSERT INTO som_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Markaasay isagii siisay addoonteedii Bilhah inuu naag ka dhigto; Yacquubna wuu u tegey iyadii. ");
INSERT INTO som_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilhahna way uuraysatay, oo Yacquub wiil bay u dhashay. ");
INSERT INTO som_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Raaxeelna waxay tidhi, Ilaah waa i xukumay, codkaygiina wuu maqlay, oo wiil buu i siiyey. Sidaas daraaddeed magiciisii waxay u bixisay Daan. ");
INSERT INTO som_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bilhah oo ahayd addoontii Raaxeel mar kalay uuraysatay, oo waxay Yacquub u dhashay wiil labaad. ");
INSERT INTO som_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Oo Raaxeelna waxay tidhi, Legdan aad u weyn baan walaashay la legdamay, waanan ka adkaaday. Magiciisiina waxay u bixisay Naftaali. ");
INSERT INTO som_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Lee'ahna markay aragtay inay dhalmo daysay ayay kaxaysay addoonteedii Silfah, oo waxay siisay Yacquub inuu naag ka dhigto. ");
INSERT INTO som_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Lee'ah addoonteedii Silfah ahaydna Yacquub wiil bay u dhashay. ");
INSERT INTO som_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Oo Lee'ahna waxay tidhi, Ayaan weynaa! Magiciisiina waxay u bixisay Gaad. ");
INSERT INTO som_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Lee'ah addoonteedii Silfah ahaydna wiil labaad bay u dhashay Yacquub. ");
INSERT INTO som_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Oo Lee'ahna waxay tidhi, Waan faraxsanahay! waayo, naaguhu waxay iigu yeedhi doonaan tan faraxsan. Magiciisiina waxay u bixisay Aasheer. ");
INSERT INTO som_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Maalmihii sarreenka la goosanayay ayaa Ruubeen tegey berrinka oo ka dhex helay ubax, oo wuxuu u keenay hooyadiis Lee'ah. Markaasay Raaxeel waxay Lee'ah ku tidhi, Waan ku baryayaaye, wax iga sii ubaxa wiilkaaga. ");
INSERT INTO som_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Iyana waxay ku tidhi, Ma wax yar baa inaad ninkaygii iga qaadday? Weliba ubaxa wiilkaygana ma iga qaadan lahayd? Raaxeelna waxay tidhi, Haddaba wiilkaaga ubaxiisa aawadiis isagu caawa wuu kula seexan doonaa. ");
INSERT INTO som_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Yacquubna fiidkii buu beertii ka yimid, markaasay Lee'ah ka hor tagtay oo waxay tidhi, Waa inaad ii timaadaa, waayo, hubaal waxaan kugu kiraystay ubaxii wiilkayga. Habeenkaasna iyadii buu la seexday. ");
INSERT INTO som_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Ilaahna wuu maqlay Lee'ah, wayna uuraysatay, oo Yacquub bay u dhashay wiil shanaad. ");
INSERT INTO som_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Lee'ahna waxay tidhi, Ilaah waa i siiyey kiradaydii, maxaa yeelay, addoontaydii waxaan siiyey ninkayga. Wiilkii magiciisiina waxay u bixisay Isaakaar. ");
INSERT INTO som_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lee'ahna mar kalay uuraysatay, oo waxay Yacquub u dhashay wiil lixaad. ");
INSERT INTO som_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Lee'ahna waxay tidhi, Ilaah dhiibaad wanaagsan buu igu dhiibaadiyey, haatan buu ninkaygu ila joogi doonaa, maxaa yeelay, waxaan u dhalay lix wiil. Wiilkii magiciisiina waxay u bixisay Sebulun. ");
INSERT INTO som_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Dabadeedna waxay dhashay gabadh, magaceediina waxay u bixisay Diinah. ");
INSERT INTO som_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Ilaahna wuu xusuustay Raaxeel, oo Ilaah wuu maqlay iyada, maxalkeediina wuu u furay. ");
INSERT INTO som_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Oo way uuraysatay, oo wiil bay dhashay; oo waxay tidhi, Ilaah baa ceebtaydii iga qaaday. ");
INSERT INTO som_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Magiciisiina waxay u bixisay Yuusuf, iyadoo leh Rabbigu wiil kale ha iigu daro. ");
INSERT INTO som_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Markii Raaxeel Yuusuf dhashay ka dib ayaa Yacquub Laabaan ku yidhi, Iska kay dir, si aan u tago meeshaydii, iyo dalkaygii. ");
INSERT INTO som_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","I sii naagahayga iyo carruurtayda aan daraaddood kuugu adeegay, oo aan iska tago; waayo waad og tahay adeegiddii aan kuu adeegi jiray. ");
INSERT INTO som_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Laabaanna wuxuu ku yidhi isagii, Haddaad raalli iga tahay, joog, waayo, waxaan faal ku gartay in Rabbigu daraaddaa ii barakeeyey. ");
INSERT INTO som_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Oo wuxuu yidhi, Mushahaaradaada ii sheeg, oo waan ku siin doonaa. ");
INSERT INTO som_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Oo isna wuxuu ku yidhi, Waad og tahay sidii aan kuugu adeegay, iyo sidii xoolahaagii aan daaqi jiray xaalkoodu ahaa. ");
INSERT INTO som_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Waayo, waxaad haysan jirtay wax yar bay ahayd intaanan iman ka hor, waana ay korodhay oo waxay noqotay wax faro badan; Rabbiguna wuu kugu barakeeyey dhinacii aan u kacayba; de haddaba goormaan reerkaygana wax u dhaqan doonaa? ");
INSERT INTO som_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Oo isna wuxuu yidhi, Maxaan ku siiyaa? Yacquubna wuxuu yidhi, Waa inaanad waxba i siin, laakiin haddaad waxan ii samaysid, adhigaaga haddana waan daajin oo waan ilaalin doonaa. ");
INSERT INTO som_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Maanta adhigaaga oo dhan waan dhex mari doonaa, oo waxaan ka sooci doonaa mid kasta oo dhibicyo iyo barbaro leh, iyo mid kasta oo madow oo idaha ku dhex jira, iyo inta barbaraha iyo dhibicyada leh oo riyaha ku jirta; oo waxaasu waxay noqon doonaan mushahaaradayda. ");
INSERT INTO som_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Oo sidaasay xaqnimadaydu iigu jawaabi doontaa hadda ka dib, goortaad timaadid oo ka hadlaysid mushahaaradayda ku hor taal. Mid kasta oo aan dhibicyo ama barbaro lahayn oo riyaha ku jira, iyo mid kasta oo aan madoobayn oo idaha ku jira, haddii layga helo, waxaa lagu tirin doonaa wax la soo xaday. ");
INSERT INTO som_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laabaanna wuxuu yidhi, Waa hagaag, sidaad tidhi ha noqoto. ");
INSERT INTO som_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Oo maalintaasuu wada soocay orgidii xariijimaha iyo barbaraha lahayd, iyo riyihii dhibicyada iyo barbaraha lahaa oo dhan, mid kasta oo caddaani ku jirto, iyo kuwa madmadow oo idaha ku jira oo dhan, oo wuxuu gacanta u geliyey wiilashiisii; ");
INSERT INTO som_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Oo wuxuu Yacquub ka fogaaday intii saddex maalmood loo socdo, Yacquubna wuxuu daajin jiray Laabaan adhigiisii intii ka hadhay. ");
INSERT INTO som_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Yacquubna wuxuu qaatay dhengedo qoyan oo ah geedihii la odhan jiray libneh iyo yicib iyo carmon, kolkaasuu diiray oo xariijimo cadcad ku sameeyey. ");
INSERT INTO som_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Markaasuu dhengedihii uu diiray adhigii hor dhigay oo ku riday dararkii berkedaha oo adhigu ka cabbi jiray; wayna rimeen markay soo arooreen. ");
INSERT INTO som_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Adhigiina dhengedihii hortooda ayuu ku rimay, wuxuuna dhalay maqal xariijimo iyo dhibicyo iyo barbaro leh. ");
INSERT INTO som_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Markaasuu Yacquub naylihii ka soocay oo wuxuu adhigii u jeediyey xagga kuwii xariijimaha lahaa iyo intii madmadoobayd oo dhan ee adhigii Laabaan; markaasuu gooni u soocay goosankiisii, kumana uu darin adhigii Laabaan. ");
INSERT INTO som_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Markii adhiga intiisii xoogga lahayd rintay ayaa Yacquub dhengedihii adhiga indhihiisa hor dhigay intuu dararkii ku riday, inay dhengedihii ku dhex rimaan; ");
INSERT INTO som_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","laakiinse adhiga qaarkii caatada ahaa, uma uu dhex gelin jirin; sidaas daraaddeed intii caatada ahayd waxaa lahaa Laabaan, intii xoogga lahaydna waxaa lahaa Yacquub. ");
INSERT INTO som_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Ninkiina aad buu u xoolo batay, wuxuuna lahaa adhi badan, iyo naago addoommo ah, iyo niman addoommo ah, iyo geel, iyo dameerro. ");
INSERT INTO som_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Wuxuu maqlay hadalkii Laabaan wiilashiisii, iyagoo leh, Yacquub baa wixii aabbeheen oo dhan wada qaatay, oo xoolahan oo dhan wuxuu ku helay wixii aabbeheen. ");
INSERT INTO som_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yacquubna wuxuu fiiriyey wejigii Laabaan, oo wuxuu arkay inuusan sidii hore u ahayn. ");
INSERT INTO som_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Rabbiguna wuxuu Yacquub ku yidhi, Ku noqo dalkii aabbahaa iyo xigaalkaaga, oo anna waan kula jiri doonaa. ");
INSERT INTO som_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Yacquubna wuxuu u cid diray oo u yeedhay Raaxeel iyo Lee'ah inay yimaadaan berrinkii adhigiisu joogay, ");
INSERT INTO som_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","oo wuxuu iyagii ku yidhi, Waxaan arkay wejigii aabbihiin inuusan sidii hore ii ahayn, laakiinse Ilaaha aabbahay baa ila jiray. ");
INSERT INTO som_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Idinkuna waad og tihiin inaan aabbihiin xooggayga oo dhan ugu adeegay. ");
INSERT INTO som_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Laakiin aabbihiin wuu i khiyaaneeyey, oo toban goor buu mushahaaradaydii beddelay; Ilaahse uma oggolaan inuu wax i yeelo. ");
INSERT INTO som_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Hadduu yidhi, Kuwa dhibicyada lahu waxay noqon doonaan mushahaaradaada, adhiga oo dhammu wax dhibicyo leh bay dhaleen; hadduu yidhina, Kuwa xariijimaha lahu waxay noqon doonaan mushahaaradaada, adhiga oo dhammu wax xariijimo leh bay dhaleen. ");
INSERT INTO som_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Sidaasaa Ilaah aabbihiin xoolihiisii uga qaaday, oo uu aniga ii siiyey. ");
INSERT INTO som_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Wakhtigii adhigii rimay ayaan indhahayga kor u taagay, oo aan riyo ku arkay orgidii adhiga ku boodday inay wada lahaayeen xariijimo, iyo dhibicyo iyo barbaro. ");
INSERT INTO som_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Malaa'igtii Ilaahna waxay igu tidhi intaan riyoonayay, Yacquubow. Oo anna waxaan idhi, Waa i kan. ");
INSERT INTO som_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Oo waxay tidhi, Haatan indhahaaga kor u taag, oo arag, orgida adhiga ku boodda oo dhammu waxay wada leeyihiin xariijimo iyo dhibicyo iyo barbaro, maxaa yeelay, waxaan wada arkay waxa Laabaan kugu sameeyo oo dhan. ");
INSERT INTO som_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Waxaan ahay Ilaaha Beytel, meeshii aad tiirka ku subagtay, oo aad nidarka iigu nidartay. Haddaba kac, oo dalkan ka bax, oo ku noqo dalkii aad ku dhalatay. ");
INSERT INTO som_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Markaasay Raaxeel iyo Lee'ah u jawaabeen isagii oo ku yidhaahdeen, Weli ma qayb baa guriga aabbahayo noogu hadhay amase dhaxal? ");
INSERT INTO som_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Miyaannan xaggiisa ka xisaabnayn shisheeye? Waayo, wuu na iibiyey, oo weliba lacagtayadiina wuu cunay. ");
INSERT INTO som_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Waayo, kulli maalkii Ilaah ka qaaday aabbahayo waxaa leh annaga iyo carruurtayada; haddaba yeel wixii Ilaah kugu yidhi. ");
INSERT INTO som_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Markaasuu Yacquub kacay, carruurtiisii iyo naagihiisiina wuxuu fuushiiyey awrtii; ");
INSERT INTO som_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","wuuna la tegey xoolihiisii oo dhan, iyo alaabadii uu urursaday, kuwaas oo ahaa xoolihii uu helay, oo uu ku ururiyey Fadan Araam, inuu tago xaggii aabbihiis Isxaaq iyo ilaa dalkii Kancaan. ");
INSERT INTO som_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Laabaanna wuxuu ku maqnaa inuu idihiisa dhogorta ka soo xiirto; kolkaasay Raaxeel xadday sanamyadii aabbeheed lahaa. ");
INSERT INTO som_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Markaasaa Yacquub si qarsoon uga tegey Laabaankii reer Suuriya oo aan ogayn, umana uu sheegin inuu cararayo. ");
INSERT INTO som_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Oo sidaasuu ula cararay wixii uu haystay oo dhan, oo intuu kacay, ayuu webigii ka gudbay, oo wejigiisii ku toosiyey buurtii Gilecaad. ");
INSERT INTO som_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Maalintii saddexaad baa Laabaan loo sheegay in Yacquub cararay. ");
INSERT INTO som_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Markaasuu walaalihiis kaxaystay, oo wuxuu raacdaynayay toddoba maalinsocod, wuxuuna ku gaadhay buurtii Gilecaad. ");
INSERT INTO som_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Markaasaa Ilaah riyo habeennimo ugu yimid Laabaankii reer Suuriya, oo ku yidhi, Iska jir oo Yacquub xumaan iyo wanaag toona ha kula hadlin. ");
INSERT INTO som_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Laabaanna wuu soo gaadhay Yacquub. Haddaba Yacquub teendhadiisii wuxuu ka dhistay buurta; Laabaanna walaalihiis buu kala dhistay buurtii Gilecaad. ");
INSERT INTO som_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Laabaanna wuxuu Yacquub ku yidhi, Waa maxay waxan aad samaysay, oo maxaad si qarsoon iiga soo tagtay anoo aan ogayn, oo aad gabdhahayga ula soo carartay sidii iyagoo ah maxaabiis seef lagu soo dhacay? ");
INSERT INTO som_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Maxaad qarsoodiga ugu soo carartay, oo aad si qarsoon iiga soo tagtay? Oo maxaad iigu sheegi weyday, si aan kuugu soo ambabbixiyo rayrayn iyo gabayo iyo daf iyo kataarad? ");
INSERT INTO som_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Oo maxaad iigu oggolaan weyday inaan dhunkado wiilashayda iyo gabdhahayga? De taas nacasnimaad u yeeshay. ");
INSERT INTO som_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","De xoog aan wax kugu yeelo waan leeyahay, laakiinse Ilaaha aabbahaa baa xalay ila hadlay, oo wuxuu igu yidhi, Iska jir oo Yacquub ha kula hadlin xumaan iyo wanaag toona. ");
INSERT INTO som_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Oo haatan waad tagtay, maxaa yeelay, aad baad ugu hilowday gurigii aabbahaa, laakiinse maxaad ilaahyadayda iiga soo xadday? ");
INSERT INTO som_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yacquubna waa u jawaabay oo wuxuu Laabaan ku yidhi, Maxaa yeelay, waan cabsaday; waayo, waxaan is-idhi, Wuu kaa xoogi doonaa gabdhihiisa. ");
INSERT INTO som_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Qofkii aad ilaahyadaadii ka hesho waa inuusan noolaan. Walaalahayo hortooda ku fiiri wixii aan kaa haysto, oo iska qaado. Waayo, Yacquub ma uu ogayn inay Raaxeel soo xadday. ");
INSERT INTO som_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Laabaanna wuxuu galay teendhadii Yacquub, iyo teendhadii Lee'ah, iyo teendhadii labada addoommood, laakiinse ma uu helin. Oo intuu ka baxay teendhadii Lee'ah ayuu galay teendhadii Raaxeel. ");
INSERT INTO som_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Raaxeelna way qaadday sanamyadii, oo waxay gelisay heeryadii awrta, wayna ku fadhiisatay. Laabaanna wuu ka wada baadhay teendhadii oo dhan, mana uu helin. ");
INSERT INTO som_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Oo waxay aabbeheed ku tidhi, Sayidkaygiiyow, ha u cadhoon inaanan istaagi karin, waayo, caadadii dumarku heli jiray baan qabaa. Isna wuu baadhay, laakiinse sanamyadii ma uu helin. ");
INSERT INTO som_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Yacquubna wuu cadhooday, oo Laabaan wuu la murmay; Yacquubna wuu u jawaabay oo wuxuu Laabaan ku yidhi, Waa maxay xadgudubkaygu? Waa maxay dembigayga aad aawadiis aad iigu soo raacdaysatay? ");
INSERT INTO som_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Waxaad baadhay alaabtayda oo dhan, ee maxaad ka heshay oo ah alaabtii gurigaaga? Halkan soo hor dhig walaalahayga iyo walaalahaaga, inay labadeenna inoo kala gar naqaan. ");
INSERT INTO som_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Labaatan sannadood baan kula joogay; laxahaaga iyo riyahaaguna dhicis ma dhalin, wananka idahaagiina ma aan cunin. ");
INSERT INTO som_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Kuwii dugaagu ka cunayna kuuma aan keenin; laakiinse anaa kuu magdhabay, anaad i weyddiisan jirtay, ha ahaadeen wixii maalin lagaa xado ama wixii habeen lagaa xado ee. ");
INSERT INTO som_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Maalintii kulayl baa i dili jiray, habeenkiina dhaxan; hurdadiina waa iga tagtay. Oo sidaasaan ahaan jiray. ");
INSERT INTO som_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Labaatan sannadood baan gurigaaga joogay; afar iyo toban sannadood waxaan kuugu shaqeeyey labadaada gabdhood aawadood, lix sannadoodna adhigaaga aawadiis. Mushahaaradaydiina waxaad beddeshay toban goor. ");
INSERT INTO som_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Ilaaha aabbahay, oo ah Ilaaha Ibraahim, iyo kan Isxaaq ka cabsado, haddii uusan ila jirin, hubaal haatan waxaad i diri lahayd anoo faro madhan. Ilaah wuxuu arkay dhibaatadaydii iyo hawshii gacmahayga, kolkaasuu xalay ku canaantay. ");
INSERT INTO som_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laabaanna wuu u jawaabay oo wuxuu Yacquub ku yidhi, Gabdhuhu waa gabdhahayga, carruurtuna waa carruurtayda, adhiguna waa adhigayga, oo waxa aad aragto oo dhammuna waa waxayga, haddaba maxaan maanta ku samayn karaa gabdhahaygan, ama carruurtooda ay dhaleen? ");
INSERT INTO som_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Haddaba kaalay, aan aniga iyo adigu axdi dhigannee, hana noqdo markhaati ina dhex yaal aniga iyo adiga. ");
INSERT INTO som_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Markaasaa Yacquub dhagax soo qaaday, oo sidii tiir u qotomiyey. ");
INSERT INTO som_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Yacquubna wuxuu walaalihiis ku yidhi, Dhagaxyo soo ururiya; kolkaasay dhagaxyo soo gureen, oo meel taalleeyeen; kolkaasay taallada agteedii wax ku cuneen. ");
INSERT INTO som_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laabaanna wuxuu meeshaas u bixiyey Yegar Sahaduta; Yacquubse wuxuu u bixiyey Galceed. ");
INSERT INTO som_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laabaanna wuxuu yidhi, Maanta taalladanu waa markhaati ina dhex yaal aniga iyo adiga. Sidaas daraaddeed waxaa magaceedii loo bixiyey Galceed, iyo Misfaah, ");
INSERT INTO som_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","waayo, wuxuu yidhi, Rabbigu ha dhawro aniga iyo adiga dhexdeenna markaynu kala maqan nahay. ");
INSERT INTO som_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Haddaad gabdhahayga dhibtid, ama aad naago kale gabdhahayga la guursatid, ninna inalama joogo, balse ogow, Ilaah baa markhaati dhexdeenna ka ah aniga iyo adiga. ");
INSERT INTO som_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Laabaanna wuxuu Yacquub ku yidhi, Bal eeg taalladan, oo bal fiiri tiirka aan ina dhex dhigay aniga iyo adiga. ");
INSERT INTO som_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Taalladanu markaati ha ka noqoto, tiirkuna markhaati ha ka noqdo, inaanan taalladan kuugu soo dhaafayn inaan wax ku yeelo, adna aadan taalladan iyo tiirkan iigu soo dhaafayn inaad wax i yeeshid. ");
INSERT INTO som_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Kan ah Ilaaha Ibraahim, iyo Ilaaha Naaxoor, iyo Ilaaha aabbahood, ha ina kala xukumo innaga. Yacquubna wuxuu ku dhaartay Kan aabbihiis Isxaaq ka cabsado. ");
INSERT INTO som_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Yacquubna allabari buu buurtii ku bixiyey, walaalihiisna wuxuu ugu yeedhay inay wax cunaan; cuntadiina way cuneen, habeenkii oo dhanna buurtay joogeen. ");
INSERT INTO som_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Laabaanna aroor hore ayuu kacay, wiilashiisii iyo gabdhihiisiina wuu dhunkaday, wuuna u duceeyey; markaasuu Laabaan tegey, oo ku noqday meeshiisii. ");
INSERT INTO som_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yacquubna jidkiisii buu iska qaaday, malaa'igihii Ilaah baana ka hor yimid. ");
INSERT INTO som_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Yacquubna markuu iyagii arkay wuxuu yidhi, Kanu waa ciidankii Ilaah. Meeshaas magaceediina wuxuu u bixiyey Maxanayim. ");
INSERT INTO som_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Yacquubna wuxuu iska hor mariyey kuwo farriin wada oo wuxuu u diray walaalkiis Ceesaw oo degganaa dalkii Seciir oo ahaa duurkii Edom. ");
INSERT INTO som_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Wuuna amray, oo wuxuu iyagii ku yidhi, Waxaad ku tidhaahdaan sayidkayga Ceesaw, Addoonkaagii Yacquub wuxuu yidhi, Waxaan qariib ahaan ula degay Laabaan, oo ilaa haatanna waan la joogay, ");
INSERT INTO som_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","oo waxaan haystaa dibiyo, iyo dameerro, iyo adhi, iyo niman addoommo ah iyo naago addoommo ah; oo waxaan kuugu soo cid diray inaan kuu sheego, sayidkaygiiyow, inaad raalli iga noqotid. ");
INSERT INTO som_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Kuwii farriinta wadayna Yacquub bay ku soo noqdeen, oo waxay ku yidhaahdeen, Waannu gaadhnay walaalkaa Ceesaw, oo weliba wuu soo socdaa inuu kaa hor yimaado isagoo wata afar boqol oo nin. ");
INSERT INTO som_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Markaasaa Yacquub aad u cabsaday, cidhiidhi buuna galay; kolkaasuu kala qaybiyey dadkii la jiray, iyo adhigii, iyo lo'dii, iyo geelii, oo wuxuu ka dhigay laba kooxood, ");
INSERT INTO som_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","oo wuxuu isyidhi, Ceesaw hadduu koox u yimaado oo uu laayo, dabadeed kooxda hadha ayaa baxsan doonta. ");
INSERT INTO som_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Yacquubna wuxuu yidhi, Awowgay Ibraahim Ilaahiisiiyow, Aabbahay Isxaaq Ilaahiisiiyow, Ku noqo dalkaagii, iyo xigaalkaagii, oo anna wanaag baan kuu samayn doonaa, Rabbigii igu yidhiyow: ");
INSERT INTO som_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Ma aan istaahilo waxa ugu wada yar ee ka mid ah naxariistaada iyo daacadnimadaada ee aad addoonkaaga tustay, waayo, ushaydaan kaga soo gudbay webigan Urdun, haatanna waxaan noqday laba kooxood. ");
INSERT INTO som_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Waan ku baryayaaye, Iga samatabbixi gacanta walaalkay ee ah gacanta Ceesaw; waayo, isagaan ka baqayaa waaba intaasoo uu yimaadaa oo dilaa aniga iyo hooyooyinka iyo carruurta la socotaba. ");
INSERT INTO som_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Waxaad igu tidhi, Hubaal wanaag baan kuu samayn doonaa, farcankaagana waxaan ka dhigi doonaa sida cammuudda badda, taas oo aan la tirin karin farabadnaan aawadeed. ");
INSERT INTO som_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Habeenkaasna halkaas buu ku baryay, oo walaalkiis Ceesaw ayuu hadiyad uga qaaday wixii uu lahaa, ");
INSERT INTO som_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","taas oo ah laba tiro oo riyo ah, iyo labaatan orgi, iyo laba tiro oo sabeeno ah iyo labaatan wan, ");
INSERT INTO som_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","iyo soddon halaad oo irmaan iyo nirgahoodii, iyo afartan sac iyo toban dibi, iyo labaatan dameerood iyo toban qayl. ");
INSERT INTO som_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Markaasuu xoolihii u dhiibay gacantii addoommadiisa, iyadoo goosan waluba goonidiisa yahay; oo wuxuu addoommadiisii ku yidhi, Iga sii hor gudba, xoolahana goosan waluba goosanka kale cabbaar ha ka dambeeyo. ");
INSERT INTO som_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Oo kii ugu horreeyey ayuu amray oo wuxuu ku yidhi, Markii walaalkay Ceesaw kaa hor yimaado, oo ku weyddiiyo, isagoo ku leh, Yaa ku leh? Oo xaggee baad ku socotaa? Kuwan kaa horreeyana yaa leh? ");
INSERT INTO som_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","waxaad ku tidhaahdaa, Waxaa leh addoonkaagii Yacquub; oo waa hadiyad loo soo diray sayidkayga Ceesaw; oo isagiina wuu naga dambeeyaa. ");
INSERT INTO som_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Sidaasuu ku amray kii labaad, iyo kii saddexaad, iyo kuwii goosannada daba socday oo dhan, oo wuxuu ku yidhi, Sidaas waa inaad ula hadashaan Ceesaw markaad aragtaan; ");
INSERT INTO som_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","oo waxaad ku tidhaahdaan, Weliba addoonkaagii Yacquub waa naga dambeeyaa. Oo wuxuu yidhi, Hadiyadda iga horraysa ayaan ku cadho tirayaa isaga, dabadeedna wejigiisaan arki doonaa; oo mindhaa wuu i aqbali doonaa. ");
INSERT INTO som_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Sidaas daraaddeed hadiyaddii waa ka sii hor gudubtay, isna habeenkaas geeddigii buu ku dhex baryay. ");
INSERT INTO som_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Kolkaasuu kacay habeenkaas, oo wuxuu kaxaystay labadiisii naagood, iyo labadiisii addoommood, iyo koob iyo tobankiisi carruurta ahayd, oo wuxuu ka gudbiyey tog Yabboq marinkiisii. ");
INSERT INTO som_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Wuuna kaxeeyey iyagii oo wuxuu u diray durdurka shishadiisa, wixii uu haystayna wuu gudbiyey. ");
INSERT INTO som_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Markaasuu Yacquub keligiis hadhay, nin baana la legdamayay isaga ilaa markii waagu beryayay. ");
INSERT INTO som_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Oo markuu arkay inuusan ka adkaanayn ayuu taabtay godkii bowdadiisa, bowdadii Yacquubna way murkacatay, intuu la legdamayay isagii. ");
INSERT INTO som_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Markaasuu yidhi, I sii daa, maxaa yeelay, waagii waa beryayaa. Isna wuxuu yidhi, Ku sii dayn maayo inaad i barakaysid mooyaane. ");
INSERT INTO som_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Mar kaasuu ku yidhi isagii, Magacaa? Isna wuxuu yidhi, Yacquub. ");
INSERT INTO som_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Markaasuu ku yidhi, Magacaaga hadda ka dib lama odhan doono Yacquub, waase Israa'iil; waayo, Ilaah iyo dadba waad la dagaallantay, waanad ka adkaatay. ");
INSERT INTO som_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Yacquubna wuu weyddiiyey, oo wuxuu ku yidhi, Waan ku baryayaaye, ii sheeg magacaaga. Oo wuxuu yidhi, Bal maxaad u haybsanaysaa magacayga? Halkaasuuna ku barakeeyey. ");
INSERT INTO som_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Yacquubna meeshaas magaceedii wuxuu u bixiyey Fenii'eel; waayo, wuxuu yidhi, Ilaah fool ka fool baan u arkay, naftayduna way nabad gashay. ");
INSERT INTO som_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Qorraxdiina waxay soo baxday markuu Fenuu'eel dhaaftay, isna bowdadiisii buu ka dhutinayay. ");
INSERT INTO som_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Sidaas daraaddeed ilaa maantadan reer binu Israa'iil ma cunaan seedda misigta oo ku dul taal godka bowdada; maxaa yeelay, wuxuu taabtay godkii bowdadii Yacquub xagga seedda misigta. ");
INSERT INTO som_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Markaasaa Yacquub indhihiisii kor u taagay oo wax fiiriyey, wuxuuna arkay Ceesaw oo soo socda, oo afar boqol oo nin wata. Kolkaasuu carruurtii u qaybiyey Lee'ah, iyo Raaxeel, iyo labadii addoon. ");
INSERT INTO som_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Markaasuu addoommihii iyo carruurtoodii ugu hor mariyey, Lee'ah iyo carruurteediina wuu ku xigsiiyey, Raaxeel iyo Yuusufna wuu ugu dambaysiiyey. ");
INSERT INTO som_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Isna markaasuu ka hor gudbay, toddoba goor buuna sujuuday, intuusan walaalkiis u soo dhowaan. ");
INSERT INTO som_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ceesawna wuu ku soo orday inuu ka hor tago isaga, wuuna isku duubay, oo qoortiisuu dhab yidhi, wuuna dhunkaday, wayna ooyeen. ");
INSERT INTO som_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Markaasuu Ceesaw indhihiisii kor u taagay, oo wuxuu arkay dumarkii iyo carruurtii; oo wuxuu ku yidhi, Waa ayo kuwan kula socdaa? Isna wuxuu yidhi, Waa carruurtii Ilaah intuu ii roonaaday i siiyey anoo ah addoonkaaga. ");
INSERT INTO som_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Dabadeedna addoommihii iyo carruurtoodii ayaa u soo dhowaaday, wayna wada sujuudeen. ");
INSERT INTO som_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Lee'ah iyo carruurteediina way u soo dhowaadeen, wayna wada sujuudeen; dabadeedna waxaa u soo dhowaaday Yuusuf iyo Raaxeel, wayna sujuudeen. ");
INSERT INTO som_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Markaasuu yidhi, Maxaad ula jeeddaa kooxahan iga hor yimid oo dhan? Isna wuxuu yidhi, Inaad raalli iga noqotid, sayidkaygiiyow. ");
INSERT INTO som_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Ceesawna wuxuu yidhi, Walaalkayow, wax igu filan baan haystaa; ee iska hayso waxaaga. ");
INSERT INTO som_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yacquubna wuxuu yidhi, Maya, waan ku baryayaaye, haddii aad haatan raalli iga tahay, de hadiyaddayda gacantayda ka guddoon; waayo, wejigaaga waxaan u arkay sidii wejigii Ilaah loo arko, oo adna waad igu faraxday. ");
INSERT INTO som_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Waan ku baryayaaye, guddoon hadiyaddayda laguu keenay; maxaa yeelay, Ilaah baa ii roonaaday, oo haddana wax igu filan baan haystaa. Aad buuna u baryay, kolkaasuu guddoomay. ");
INSERT INTO som_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Oo wuxuu yidhi, Sodcaalkeenna aan iska sii soconno, oo ina keena, oo anna waan kaa hor marayaa. ");
INSERT INTO som_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Markaasuu ku yidhi isagii, Sayidkaygiiyow, waad og tahay in carruurtu ay tabar daranyihiin, adhiga iyo lo'dana waa la nuugaa; oo haddii maalin keliya aad loo sii kaxeeyo, de adhigu waa wada dhimanayaa. ");
INSERT INTO som_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Sayidkaygiiyow, waan ku baryayaaye, iga hor mar anigoo addoonkaaga ah, oo anna aayar baan soo kaxayn, anoo fiirinaya tallaabada xoolaha i hor jooga, iyo tallaabada carruurta, ilaa aan Seciir kuugu imaado, sayidkaygiiyow. ");
INSERT INTO som_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Markaasaa Ceesaw ku yidhi, Haddaba aan dadka ila jira qaar kaaga tago. Isna wuxuu yidhi, Maxaa looga baahan yahay? Raalli iga ahow, sayidkaygiiyow. ");
INSERT INTO som_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Oo maalintaasaa Ceesaw ku noqday jidkiisii ilaa Seciir. ");
INSERT INTO som_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Yacquubna wuxuu u sodcaalay Sukod, wuxuuna ka dhistay guri, xoolihiisiina wuxuu u sameeyey xerooyin; sidaas daraaddeed meeshaas magaceeda waxaa la yidhaahdaa Sukod. ");
INSERT INTO som_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Yacquubna nabad buu ku yimid magaaladii Shekem, oo ku taal dalka Kancaan, markuu ka yimid Fadan Araam; oo wuxuu degay magaalada horteeda. ");
INSERT INTO som_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Jagadii uu teendhadiisii ka dhistayna wuxuu ka iibsaday reer Xamoor oo ahaa Shekem aabbihiis, oo wuxuu siistay boqol xabbadood oo lacag ah. ");
INSERT INTO som_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Halkaasna wuxuu ka taagay meel allabari, wuxuuna u bixiyey El-elohe-Israa'iil. ");
INSERT INTO som_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Oo Diinah oo ahayd gabadhii Lee'ah ay Yacquub u dhashay ayaa dibadda u baxday inay soo aragto gabdhihii dalka. ");
INSERT INTO som_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Markaasuu Shekem ina Xamoor kii reer Xiwi oo ahaa amiirkii dalka arkay iyadii, oo uu kaxaystay oo la jiifsaday, wuuna ceebeeyey iyadii. ");
INSERT INTO som_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Naftiisiina way raacday gabadhii Yacquub oo Diinah ahayd, wuuna jeclaaday gabadhii, si raxmad lehna wuu ula hadlay gabadhii. ");
INSERT INTO som_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Markaasuu Shekem la hadlay aabbihiis Xamoor, oo yidhi, Gabadhan ii doon aan guursadee. ");
INSERT INTO som_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Haddaba Yacquub waa maqlay in Shekem gabadhiisii Diinah nijaaseeyey; wiilashiisiina duurka ayay xoolihiisa la joogeen; Yacquubna wuu iska aamusay ilaa ay yimaadeen. ");
INSERT INTO som_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Markaasaa Xamoor oo Shekem aabbihiis ahaa Yacquub ugu tegey inuu la hadlo isaga. ");
INSERT INTO som_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Oo wiilashii Yacquub ayaa duurka ka yimid markay taas maqleen; nimankiina way caloolxumaayeen, aad bayna u cadhaysnaayeen, maxaa yeelay, nacasnimo buu ku sameeyey reer binu Israa'iil markuu la jiifsaday gabadhii Yacquub, taas oo aanay jid ahayn in la sameeyo. ");
INSERT INTO som_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Xamoorna wuu la hadlay iyagii, oo wuxuu ku yidhi, Wiilkaygii Shekem naftiisii aad bay u doonaysaa gabadhaada; haddaba waan ku baryayaaye, iyada sii ha guursadee. ");
INSERT INTO som_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Oo aan iska guursanno, gabdhihiinna na siiya annaga, idinkuna gabdhahayaga guursada. ");
INSERT INTO som_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Oo waad nala degganaan doontaan; dalkuna hortiinnuu oolli doonaa; degganaada oo ku baayacmushtara dhexdiisa, oo xoolo ku yeesha. ");
INSERT INTO som_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Shekemna wuxuu aabbeheed iyo walaalaheed ku yidhi, Raalli iga ahaada, oo anna wixii aad i weyddiisataan waan idin siin. ");
INSERT INTO som_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","In alla intii aad meher iyo yarad doonaysaan i weyddiista, oo anna waan idin siin intii aad igu tidhaahdaan, laakiinse gabadha i siiya aan guursadee. ");
INSERT INTO som_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Wiilashii Yacquubna khiyaanay ugu jawaabeen Shekem iyo aabbihiis Xamoor, wayna la hadleen, maxaa yeelay, walaashood Diinah ayuu nijaaseeyey, ");
INSERT INTO som_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","oo waxay ku yidhaahdeen, Ma yeeli karno inaan walaashayo siinno nin buuryoqab ah; waayo, taasu ceeb bay nagu ahaan lahayd. ");
INSERT INTO som_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Si uun baannu idinku yeeli karnaa; taasuna waa haddii aad intiinna ragga ah oo dhan iswada guddaan, oo aad noqotaan sidayada oo kale; ");
INSERT INTO som_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","markaasaannu gabdhahayaga idin siin doonnaa, oo annaguna waxaan guursan doonnaa gabdhihiinna, oo waannu idinla degganaan doonnaa, oo waxaynu noqon doonnaa isku dad. ");
INSERT INTO som_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Laakiinse haddaydnan na maqlin, inaad isguddaan, de markaas gabadhayada waannu wadan, oo waannu tegi. ");
INSERT INTO som_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Hadalkoodiina waa ka farxiyey Xamoor, iyo wiilkiisii Shekem. ");
INSERT INTO som_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Ninkii dhallinyarada ahaana dib uma uu dhigin inuu taas yeelo, maxaa yeelay, aad buu ugu faraxsanaa Yacquub gabadhiisii, Isna wuu ka wada maamuus badnaa intii guriga aabbihiis joogtay oo dhan. ");
INSERT INTO som_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Markaasay Xamoor iyo wiilkiisii Shekem magaaladoodii iriddeeda yimaadeen, oo ay raggii magaaladooda la hadleen, oo waxay ku yidhaahdeen, ");
INSERT INTO som_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Nimankanu waa inala nabad, sidaas daraaddeed dhulka ha degeen, oo ha ka baayacmushtareen dhexdiisa, maxaa yeelay, bal eega, dhulku waa weyn yahay oo waa ku wada filan yahay. Aynu gabdhahooda guursanno, oo innana aan gabdhaheenna siinno iyaga. ");
INSERT INTO som_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Nimanku si uun bay inagu yeelayaan inay inala degganaadaan si aynu isku dad u noqonno, taasuna waa haddii inteenna lab oo dhan loo gudo sida ay iyagu u gudan yihiin. ");
INSERT INTO som_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Oo miyaan lo'dooda iyo alaabadooda iyo xayawaankooda oo dhammu noqon doonin kuweenna? Bal aynu yeelno uun, oo iyaguna way inala degganaan doonaan. ");
INSERT INTO som_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Markaasaa in alla intii ka baxday magaaladiisa iriddeeda waxay maqleen Xamoor iyo wiilkiisii Shekem; markaasaa la wada guday intii labka ahayd oo magaaladiisa ka baxday oo dhan. ");
INSERT INTO som_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Oo maalintii saddexaad, markay dhaawaca wada ahaayeen, waxay noqotay in laba ka mid ahaa wiilashii Yacquub oo ahaa Simecoon iyo Laawi, Diinah walaalaheed, uu midkood kastaa seeftiisii qaatay, oo waxay yimaadeen magaaladii, iyagoo aan la ogayn, waxayna wada laayeen intii labka ahayd oo dhan. ");
INSERT INTO som_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Xamoor iyo wiilkiisii Shekemna waxay ku dileen seef afkeed, Diinahna way kala baxeen gurigii Shekem, wayna iska tageen. ");
INSERT INTO som_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Wiilashii Yacquubna waxay yimaadeen raqdii kuwii la laayay, oo magaaladiina way dhaceen, maxaa yeelay, walaashood bay ka nijaaseeyeen. ");
INSERT INTO som_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Waxayna la tageen adhigoodii iyo lo'doodii iyo dameerradoodii, iyo wax alla wixii magaalada u yiil, iyo wax alla wixii duurka u joogay, ");
INSERT INTO som_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","iyo maalkoodii oo dhan, iyo dhallaankoodii oo dhan, iyo naagahoodiiba, way qabsadeen oo way dhaceen, xataa wixii guryaha yiil oo dhan. ");
INSERT INTO som_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Yacquubna wuxuu Simecoon iyo Laawi ku yidhi, Dhib baad igu riddeen, maxaa yeelay, waxaad i nacsiiseen dadka dhulka deggan, oo ah reer Kancaan, iyo reer Feris. Haddaba anigoo dadkaygu yar yahay, ayay isu kay wada urursan doonaan oo ay i dili doonaan; markaasna aniga iyo reerkaygaba waa la baabbi'in doonaa. ");
INSERT INTO som_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Oo iyana waxay ku yidhaahdeen, De miyey ku habboonayd inuu walaashayo sidii dhillo ula macaamiloodo? ");
INSERT INTO som_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Oo Ilaah wuxuu Yacquub ku yidhi, Kac oo xagga Beytel tag, oo halkaas deg; oo meel allabari halkaas uga samee Ilaahii kuu muuqday markii aad walaalkaa Ceesaw ka cararaysay. ");
INSERT INTO som_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Markaasaa Yacquub ku yidhi dadkii gurigiisa iyo intii isaga la jirtay oo dhan, Iska fogeeya ilaahyada qalaad oo idinku dhex jira, oo isdaahirsha, oo dharkiinnana beddesha, ");
INSERT INTO som_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","oo ina kiciya, aynu Beytel tagnee, oo anna halkaas meel allabari baan uga samayn doonaa Ilaahii ii jawaabay maalintii aan dhibtoonayay oo ila jiray jidkii aan maray. ");
INSERT INTO som_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Markaasay Yacquub wada siiyeen ilaahyadii qalaad oo gacantooda ku jiray, iyo hilqadihii dhegahooda ku jiray, Yacquubna wuxuu ku qariyey geed Shekem ku ag yiil hoostiisa. ");
INSERT INTO som_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Wayna sodcaaleen, magaalooyinkii ku wareegsanaa oo dhanna cabsi weyn baa ku dhacday, mana ay ka daba tegin reer Yacquub. ");
INSERT INTO som_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yacquubna wuxuu yimid Luus oo ku taal dalka Kancaan (taasuna waa Beytel), isagii iyo dadkii la jiray oo dhanba. ");
INSERT INTO som_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Markaasuu halkaas ka dhisay meel allabari, wuxuuna meeshii u bixiyey Elbeytel, maxaa yeelay, Ilaah baa halkaas ugu muuqday isaga, markuu ka cararay walaalkiis. ");
INSERT INTO som_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Markaasaa Debooraah oo Rebeqah midiidinteedii ahayd dhimatay, waxaana lagu aasay Beytel geedka hoostiisa; meeshaas magaceediina waxaa loo bixiyey Alloon Bakuud. ");
INSERT INTO som_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Markaasaa Ilaah mar kale Yacquub u muuqday, markii uu ka yimid Fadan Araam, wuuna barakeeyey. ");
INSERT INTO som_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Oo waxaa Ilaah ku yidhi, Magacaagu waa Yacquub. Hadda ka dib magacaaga lama odhan doono Yacquub, laakiinse magacaagu wuxuu ahaan doonaa Israa'iil. Magiciisiina wuxuu u bixiyey Israa'iil. ");
INSERT INTO som_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Markaasaa Ilaah ku yidhi isaga, Waxaan ahay Ilaaha Qaadirka ah. Wax badan dhal oo taran; quruun iyo quruumo badan ayaa kaa iman doona, waxaa kaa soo bixi doona boqorro; ");
INSERT INTO som_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","oo dhulkii aan siiyey Ibraahim iyo Isxaaq, adigaan ku siin doonaa, adiga dabadaana farcankaagaan siin doonaa dhulka. ");
INSERT INTO som_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Ilaahna kor buu uga tegey isagii iyo meeshii uu kula hadlayba. ");
INSERT INTO som_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yacquubna meeshii uu kula hadlay isaga wuxuu ka taagay tiir, kaas oo ahaa tiir dhagax ah; wuxuuna ku dul shubay qurbaan cabniin ah, saliidna wuu ku dul shubay. ");
INSERT INTO som_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Yacquubna meeshii Ilaah kula hadlay isaga magaceedii wuxuu u bixiyey Beytel. ");
INSERT INTO som_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Wayna ka sodcaaleen Beytel; oo intaanay Efrad weli soo gaadhin ayaa Raaxeel foolatay, fooshiina way ku rafaadday. ");
INSERT INTO som_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Oo markay fooshii ku rafaadaysay umulisadii baa ku tidhi, Ha cabsan; waayo, haatan waxaad dhalaysaa wiil kale. ");
INSERT INTO som_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Oo waxay noqotay in, markii ay naftu ka sii baxaysay, ay magiciisii u bixisay Benooni, waayo, way dhimatay, laakiinse aabbihiis wuxuu u bixiyey Benyaamiin. ");
INSERT INTO som_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Raaxeelna way dhimatay, waxaana lagu aasay jidka loo maro Efrad, taasuna waa Beytlaxam. ");
INSERT INTO som_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yacquubna tiir buu ka taagay qabrigeedii; waana isla tiirka ka taagan qabrigii Raaxeel ilaa maanta. ");
INSERT INTO som_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Israa'iilna waa sodcaalay, oo wuxuu teendhadiisii ka dhistay munaaraddii Ceeder shishadeeda. ");
INSERT INTO som_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Oo waxay noqotay, intuu Israa'iil dhulkaas degganaa, in Ruubeen u tegey oo la jiifsaday addoontii aabbihiis oo Bilhah ahayd; Israa'iilna taas wuu maqlay. Wiilashii Yacquubna laba iyo toban bay ahayeen. ");
INSERT INTO som_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Wiilashii Lee'ah waxay ahaayeen Ruubeen oo ahaa curadkii Yacquub, iyo Simecoon, iyo Laawi, iyo Yahuudah, iyo Isaakaar, iyo Sebulun. ");
INSERT INTO som_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Wiilashii Raaxeelna waxay ahaayeen Yuusuf iyo Benyaamiin. ");
INSERT INTO som_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Addoontii Raaxeel oo Bilhah ahayd wiilasheediina waxay ahaayeen Daan iyo Naftaali. ");
INSERT INTO som_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Addoontii Lee'ah oo Silfah ahayd wiilasheediina waxay ahaayeen Gaad iyo Aasheer. Kuwanu waa wiilashii Yacquub oo isaga ugu dhashay Fadan Araam. ");
INSERT INTO som_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Markaasaa Yacquub aabbihiis Isxaaq ugu yimid Mamre, iyo xagga Qiryad Arbac, taasuna waa Xebroon, oo ahayd meeshii Ibraahim iyo Isxaaq qariib ahaanta u degganaan jireen. ");
INSERT INTO som_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isxaaq cimrigiisuna wuxuu ahaa boqol iyo siddeetan sannadood. ");
INSERT INTO som_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Isxaaqna wuu naf baxay, wuuna dhintay, oo wuxuu ku darmaday dadkiisii, isagoo duq ah oo cimri weyn; markaasay wiilashiisii Ceesaw iyo Yacquub isagii aaseen. ");
INSERT INTO som_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Haddaba kuwanuna waa farcankii Ceesaw, isna waa Edom. ");
INSERT INTO som_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Ceesaw wuxuu gabdhihii reer Kancaan ka guursaday Caadah ina Eeloon kii reer Xeed, iyo Aaholiibaamah ina Canah, oo ahayd ina Sibecoon kii reer Xiwi, ");
INSERT INTO som_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","iyo Basmad oo ahayd ina Ismaaciil, oo la dhalatay Nebayod. ");
INSERT INTO som_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Caadahna waxay Ceesaw u dhashay Elifas, Basmadna waxay u dhashay Recuu'eel; ");
INSERT INTO som_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Aaholiibaamahna waxay u dhashay Yecuush, iyo Yaclaam, iyo Qorax; kuwanu waa wiilashii Ceesaw, oo isaga ugu dhashay dalkii Kancaan. ");
INSERT INTO som_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Markaasaa Ceesaw kaxaystay naagihiisii, iyo wiilashiisii iyo gabdhihiisii, iyo dadkii gurigiisa oo dhan, iyo lo'diisii, iyo xayawaankiisii oo dhan, iyo wixii uu lahaa oo dhan oo uu ku urursaday dalkii Kancaan; markaasuu tegey dal ka fog walaalkiis Yacquub. ");
INSERT INTO som_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Waayo, xoolahoodu aad bay u badnaayeen oo ma ay wada degi karin; dhulkii ay degganaan jireenna ma uu wada qaadi karin lo'dooda aawadeed. ");
INSERT INTO som_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Ceesawna wuxuu degay Buur Seciir; Ceesaw waa Edom. ");
INSERT INTO som_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Kuwanuna waa farcankii Ceesaw oo ahaa reer Edom aabbahood oo degganaan jiray Buur Seciir. ");
INSERT INTO som_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Kuwanu waa wiilashii Ceesaw magacyadoodii, Elifas oo ahaa wiilkii Caadah oo naagtii Ceesaw ahayd, iyo Recuu'eel oo ahaa wiilkii Basmad oo naagtii Ceesaw ahayd. ");
INSERT INTO som_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Wiilashii Elifasna waxay ahaayeen Teemaan, Oomaar, Sefoo, iyo Gactaam iyo Qenas. ");
INSERT INTO som_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Timnac waxay ahayd addoontii uu Elifas ina Ceesaw qabay, oo waxay Elifas u dhashay Camaaleq; kuwanu waa wiilashii naagtii Ceesaw oo Caadah ahayd. ");
INSERT INTO som_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Kuwanuna waa wiilashii Recuu'eel: Nahad, iyo Serax, iyo Shammah, iyo Misaah; kuwanuna waxay ahaayeen wiilashii naagtii Ceesaw oo Basmad ahayd. ");
INSERT INTO som_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Kuwanuna waxay ahaayeen wiilashii naagtii Ceesaw oo ahayd Aaholiibaamah, gabadhii Canah oo ahayd ina Sibecoon; oo iyana waxay Ceesaw u dhashay Yacuush, iyo Yaclaam, iyo Qorax. ");
INSERT INTO som_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Kuwanu waxa weeye ugaasyadii wiilashii Ceesaw. Waa wiilashii Elifas kii ahaa curadkii Ceesaw kuwaas oo ah ugaas Teemaan, iyo ugaas Oomaar, iyo ugaas Sefoo, iyo ugaas Qenas, ");
INSERT INTO som_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","ugaas Qorax, iyo ugaas Gactaam, iyo ugaas Camaaleq. Kuwanu waa ugaasyadii Elifas dhalay oo dalkii Edom joogay; kuwanu waa wiilashii Caadah. ");
INSERT INTO som_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Kuwanuna waa wiilashii Recuu'eel oo ahaa ina Ceesaw: ugaas Nahad, iyo ugaas Serax, iyo ugaas Shammah, iyo ugaas Misaah. Kuwanuna waa ugaasyadii uu Recuu'eel dhalay oo dalkii Edom joogay; kuwanu waa wiilashii naagtii Ceesaw oo Basmad ahayd. ");
INSERT INTO som_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Kuwanuna waa wiilashii naagtii Ceesaw oo Aaholiibaamah ahayd: ugaas Yecuush, iyo ugaas Yaclaam, iyo ugaas Qorax. Kuwanuna waa ugaasyadii ay dhashay naagtii Ceesaw oo ahayd Aaholiibaamah, gabadhii Canah. ");
INSERT INTO som_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Kuwanu waa wiilashii Ceesaw oo ahaa Edom, oo kuwanu waa ugaasyadoodii. ");
INSERT INTO som_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Kuwanuna waa wiilashii Seciir, kii reer Xor, oo ahaa kuwii dhulka degganaa, Lootaan, iyo Shoobaal, iyo Sibecoon, iyo Canah, ");
INSERT INTO som_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","iyo Dishon, iyo Eeser, iyo Diishaan. Kuwanu waa ugaasyadii reer Xor, oo ahaa ilma Seciir oo degganaa dhulkii Edom. ");
INSERT INTO som_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Carruurtii Lootaanna waxay ahaayeen Xori iyo Heemaam, Lootaan walaashiisna waxay ahayd Timnac. ");
INSERT INTO som_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Kuwanuna waa carruurtii Shoobaal; Calwaan, iyo Maanahad, iyo Ceebaal, iyo Shefo, iyo Oonaam. ");
INSERT INTO som_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Kuwanuna waa carruurtii Sibecoon; Ayah, iyo Canah. Kanu waa Canah kii cidlada ka helay ilaha biyaha oo kulul, markuu daajinayay dameerrada aabbihiis Sibecoon. ");
INSERT INTO som_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Kuwanuna waa carruurtii Canah; Dishon, iyo Aaholiibaamah, gabadhii Canah. ");
INSERT INTO som_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Kuwanuna waa carruurtii Dishon; Xemdaan, iyo Eshbaan, iyo Yitraan, iyo Keraan. ");
INSERT INTO som_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Kuwanuna waa carruurtii Eeser; Bilhaan, iyo Sacwaan, iyo Caqaan. ");
INSERT INTO som_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Kuwanuna waa carruurtii Diishaan; Cuus iyo Araan. ");
INSERT INTO som_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Kuwanuna waa ugaasyadii reer Xor; ugaas Lootaan, iyo ugaas Shoobaal, iyo ugaas Sibecoon, iyo ugaas Canah, ");
INSERT INTO som_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","ugaas Dishon, iyo ugaas Eeser, iyo ugaas Diishaan. Kuwanuna waa ugaasyadii reer Xor siday ahaayeen ugaasyadoodii dalka Seciir joogay. ");
INSERT INTO som_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Kuwanuna waa boqorradii xukumi jiray dalkii Edom intaan boqorna xukumin reer binu Israa'iil. ");
INSERT INTO som_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Belac ina Becoor wuxuu xukumi jiray Edom, magaaladiisii magaceedana waxaa la odhan jiray Dinhaabah. ");
INSERT INTO som_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Markaasaa Belac dhintay, oo waxaa meeshiisii xukumi jiray Yoobaab ina Serax oo reer Bosraah ahaa. ");
INSERT INTO som_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yoobaabna waa dhintay, oo waxaa meeshiisii xukumi jiray Xushaam oo ka yimid dhulkii reer Teemaan. ");
INSERT INTO som_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Xushaamna waa dhintay, oo waxaa meeshiisii xukumi jiray Hadad ina Bedad, oo reer Midyaan ku laayay berrinkii Moo'aab, magaaladiisii magaceedana waxaa la odhan jiray Cawiid. ");
INSERT INTO som_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Markaasaa Hadadna dhintay, oo waxaa meeshiisii xukumi jiray Samlah oo reer Masreqah ahaa. ");
INSERT INTO som_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Markaasaa Samlahna dhintay, oo waxaa meeshiisii xukumi jiray Sha'uul oo reer Rexobod ahaa oo webiga ag degganaa. ");
INSERT INTO som_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Markaasaa Sha'uulna dhintay, oo waxaa meeshiisii xukumi jiray Bacal Xaanaan ina Cakboor. ");
INSERT INTO som_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Bacal Xaanaan ina Cakboorna waa dhintay, oo waxaa meeshiisii xukumi jiray Hadar, magaaladiisii magaceedana waxaa la odhan jiray Faacuu; naagtiisa magaceeduna wuxuu ahaa Meheetabeel, oo ay Matreed gabadha Meesaahaab dhashay. ");
INSERT INTO som_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Kuwanuna waa magacyadii ugaasyadii Ceesaw dhalay, siday ahaayeen qabiilooyinkoodii iyo magacyadii meelahoodii ay degganaan jireen, waana ugaas Timnac, iyo ugaas Calwah, iyo ugaas Yeteed, ");
INSERT INTO som_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","iyo ugaas Aaholiibaamah, iyo ugaas Eelaah, iyo ugaas Fiinon; ");
INSERT INTO som_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","iyo ugaas Qenas, iyo ugaas Teemaan, iyo ugaas Mibsaar; ");
INSERT INTO som_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","iyo ugaas Magdii'eel, iyo ugaas Ciiraam. Kuwanu waa ugaasyadii reer Edom sidii ay u degganaayeen dhulkii ay lahaayeen. Kanu waa Ceesaw oo ahaa reer Edom aabbahood. ");
INSERT INTO som_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yacquubna wuxuu degay dhulkii aabbihiis qariibka ku ahaan jiray, oo ahaa dalkii Kancaan. ");
INSERT INTO som_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Kuwanuna waa farcankii Yacquub. Yuusuf, isagoo jira toddoba iyo toban sannadood, ayuu idaha la daajinayay walaalihiis, wuxuuna ahaa wiil la jooga wiilashii Bilhah iyo Silfah oo ahaa naagihii aabbihiis. Markaasuu Yuusuf xaggooda war xun uga keenay aabbahood. ");
INSERT INTO som_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Israa'iilna Yuusuf wuu ka jeclaa carruurtiisa oo dhan, maxaa yeelay, wuxuu ahaa inankuu dhalay markuu gaboobay; oo wuxuuna u sameeyey shulug midabyo badan leh. ");
INSERT INTO som_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Markaasaa walaalihiis arkeen in aabbahood ka jecel yahay isaga walaalihiis oo dhan; kolkaasay nebcaadeen isagii, wayna kari waayeen inay isaga si nabad ah ula hadlaan. ");
INSERT INTO som_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Yuusufna wuu riyooday, markaasuu riyadiisii u sheegay walaalihiis, iyana aad bay u sii nebcaadeen. ");
INSERT INTO som_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Oo wuxuu iyagii ku yidhi, Waan idin baryayaaye, bal maqla riyadan aan ku riyooday. ");
INSERT INTO som_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Bal eega, waxaynu beerta ku xidhxidhaynay xidhmooyin, markaasaa xidhmadaydii kacday, oo istaagtay, xidhmooyinkiinniina hareeraheeday yimaadeen oo u sujuudeen xidhmadaydii. ");
INSERT INTO som_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Markaasaa walaalihiis ku yidhaahdeen, Ma annagaad na xukumi doontaa? Amase noo talin doontaa? Markaasay aad iyo aad ugu sii nebcaadeen riyooyinkiisii iyo hadalladiisii aawadood. ");
INSERT INTO som_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Markaasuu haddana riyo kale ku riyooday, oo walaalihiis u sheegay, oo wuxuu ku yidhi, Bal eega, riyo kalaan ku riyoodaye. Waxaan ku riyooday qorraxdii iyo dayaxii, iyo koob iyo toban xiddigood oo ii sujuuday. ");
INSERT INTO som_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Markaasuu aabbihiis u sheegay, iyo walaalihiisba, aabbihiisna waa canaantay, oo wuxuu ku yidhi, Waa maxay riyadan aad ku riyootay? Ma aniga iyo hooyadaa iyo walaalahaa baa kuu iman doonna, oo intaan wejiga dhulka saarno kuu sujuudi doonna? ");
INSERT INTO som_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Markaasay walaalihiis ka masayreen isagii; laakiinse aabbihiis maankuu ku haystay hadalkii. ");
INSERT INTO som_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Markaasaa walaalihiis tageen, inay adhigii aabbahood soo daajiyaan Shekem. ");
INSERT INTO som_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Israa'iilna wuxuu Yuusuf ku yidhi, Miyaanay walaalahaa adhigii daajinayn Shekem? Bal kaalay, xaggoodaan kuu dirayaaye. Markaasuu isna ku yidhi, Waa i kan. ");
INSERT INTO som_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Oo wuxuu ku yidhi isagii, Bal tag oo soo arag in walaalahaa iyo adhigiiba nabad qabaan iyo in kale, oo haddana ii war keen. Sidaas daraaddeed isagii wuxuu ka diray dooxadii Xebroon, oo wuxuu tegey Shekem. ");
INSERT INTO som_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Markaasaa nin helay isagoo duurka wareegaya; ninkiina wax buu weyddiiyey oo wuxuu ku yidhi, Maxaad doondoonaysaa? ");
INSERT INTO som_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Isna wuxuu yidhi, Waxaan doondoonayaa walaalahay. Waan ku baryayaaye, ii sheeg meesha ay adhigii daajinayaan. ");
INSERT INTO som_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Markaasaa ninkii ku yidhi, Halkan way ka tageen, waayo, waxaan maqlay iyagoo isku leh, Ina keena aynu Dotaan tagnee. Markaasuu Yuusuf walaalihiis ka daba tegey, oo wuxuu iyagii ka helay Dotaan. ");
INSERT INTO som_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Markaasay meel fog ka arkeen isagii, oo intuusan u soo dhowaan iyagii, ayay ku tashadeen inay dilaan. ");
INSERT INTO som_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Oo waxay isku yidhaahdeen, Bal eega, kii riyada badnaa waa soo socdaaye. ");
INSERT INTO som_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Haddaba kaalaya aynu dilnee, oo aynu ku tuurno ceelasha midkood, oo waxaynu odhan doonnaa, Bahal xun baa cunay. Dabadeedna waxaynu arki doonnaa bal waxay riyooyinkiisii noqdaan. ");
INSERT INTO som_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Oo Ruubeen baa taas maqlay, isagiina wuu ka samatabbixiyey gacantoodii; oo wuxuu iyagii ku yidhi, Yeynan naftiisa ka qaadin. ");
INSERT INTO som_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Kolkaasaa Ruubeen ku yidhi iyagii, Dhiig ha daadinina, ee isaga ku tuura ceelkan cidlada ku yaal, laakiinse far ha saarina. Oo wuxuu taas u yeelay inuu isaga ka samatabbixiyo gacantooda oo uu u celiyo aabbihiis. ");
INSERT INTO som_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Oo waxay noqotay in markii Yuusuf walaalihiis u yimid ay Yusuuf ka furteen shuluggiisii, kaasu wuxuu ahaa shuluggii midabyada badnaa oo uu qabay. ");
INSERT INTO som_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Kolkaasay qabteen oo ay ceelkii ku tuureen; ceelkuna waa madhnaa oo biyo kuma jirin. ");
INSERT INTO som_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Kolkaasay u fadhiisteen inay wax cunaan; dabadeedna indhahay kor u taageen oo wax bay fiiriyeen, oo waxay arkeen safar reer Ismaaciil ah oo ka soo socda xagga Gilecaad, oo awrtooda ay ugu raran yihiin xawaash, iyo beeyo, iyo malmal, waxayna u socdeen xagga Masar. ");
INSERT INTO som_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Markaasuu Yahuudah ku yidhi walaalihiis, Maxaa faa'iido inoogu jirta, haddaynu walaalkeen dilno oo aynu dhiiggiisa qarinno? ");
INSERT INTO som_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Kaalaya, aynu reer Ismaaciil ka iibinnee, oo yeynan isaga far saarin, maxaa yeelay, isagu waa walaalkeen, waana jidhkeenna. Walaalihiisna way maqleen isagii. ");
INSERT INTO som_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Oo waxaa ag maray niman reer Midyaan ah, oo baayacmushtariyaal ah. Markaasay Yuusuf soo jiideen oo ceelkii ka soo bixiyeen, oo waxay Yuusuf kuwii reer Ismaaciil kaga iibiyeen labaatan xabbadood oo lacag ah. Oo iyana Yuusuf waxay keeneen Masar. ");
INSERT INTO som_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Markaasaa Ruubeen ku noqday ceelkii; wuxuuna arkay inuusan Yuusuf ku jirin ceelka, kolkaasuu dharkiisii dildillaaciyey. ");
INSERT INTO som_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Markaasuu walaalihiis ku noqday, oo wuxuu ku yidhi, Yarkii ma joogo, haddaba anigu xaggee baan tagaa? ");
INSERT INTO som_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Kolkaasay shuluggii Yuusuf qaadeen oo intay orgi gowraceen ayay shuluggii dhiiggii geliyeen. ");
INSERT INTO som_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Markaasay shuluggii midabyada badnaa direen, oo ay aabbahood u keeneen; oo waxay ku yidhaahdeen, Kan waannu helnay, haddaba bal garo inuu shuluggii wiilkaagii yahay iyo in kale. ");
INSERT INTO som_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Wuuna gartay, oo wuxuu yidhi, Waa shuluggii wiilkayga. Bahal xun baa cunay isagii. Shakila'aan Yuusuf cadcad baa loo kala jeexjeexay. ");
INSERT INTO som_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Markaasaa Yacquub dharkiisii dildillaaciyey, oo joonyad buu dhexda ku xidhay, wiilkiisiina maalmo badan ayuu u barooranayay. ");
INSERT INTO som_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Kolkaasaa wiilashiisii oo dhan iyo gabdhihiisii oo dhammu u kaceen inay isaga qalbi qaboojiyaan, laakiinse wuu diiday inuu qalbi qaboobo, oo wuxuu yidhi, Anigoo barooranaya ayaan qabriga geli doonaa oo wiilkaygii u tegi doonaa. Aabbihiisna wuu u ooyay isagii. ");
INSERT INTO som_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Markaasay kuwii reer Midyaan isagii Masar kaga iibiyeen nin la odhan jiray Footiifar, wuxuuna ahaa sirkaalkii Fircoon oo ahaa madaxa waardiyayaasha. ");
INSERT INTO som_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Oo waagaas waxay noqotay inuu Yahuudah ka tegey walaalihiis, oo wuxuu u leexday nin magiciisa la odhan jiray Xiirah oo reer Cadullaam ah. ");
INSERT INTO som_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Markaasaa Yahuudah wuxuu halkaas ku arkay nin reer Kancaan ah oo magiciisa la odhan jiray Shuuca gabadhiisii. Kolkaasuu kaxaystay iyadii oo uu u tegey. ");
INSERT INTO som_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Wayna uuraysatay oo waxay dhashay wiil, magiciisiina wuxuu u bixiyey Ceer. ");
INSERT INTO som_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Oo haddana mar kalay uuraysatay oo waxay dhashay wiil; magiciisiina waxay u bixisay Oonaan. ");
INSERT INTO som_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Oo weliba haddana wiil kalay dhashay, magiciisiina waxay u bixisay Sheelaah; oo isna wuxuu joogay Kesiib, markay dhashay isaga. ");
INSERT INTO som_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Markaasaa Yahuudah naag u guuriyey curadkiisii ahaa Ceer, magaceedana waxaa la odhan jiray Taamaar. ");
INSERT INTO som_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Yahuudah curadkiisii ahaa Ceer waa ku xumaa Rabbiga hortiisa; Rabbiguna waa dilay isagii. ");
INSERT INTO som_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Markaasaa Yahuudah wuxuu ku yidhi Oonaan, Naagta walaalkaa u tag oo dumaal, oo ku samee wixii ninkeeda walaalkiis ku samayn lahaa, oo farcan u reeb walaalkaa. ");
INSERT INTO som_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Oonaanna wuu ogaa inaan farcanku kiisii noqonayn, oo markuu u tegey naagtii walaalkiis ayuu shahwadiisii ku daadiyey dhulka, si uusan farcan u siin walaalkiis. ");
INSERT INTO som_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Wixii uu sameeyeyna Rabbiga hortiisa aad buu ugu xumaa; oo markaasuu isagiina dilay. ");
INSERT INTO som_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Markaasuu Yahuudah ku yidhi gabadhii Taamaar oo uu soddogga u ahaa, Carmalnimo ku joog guriga aabbahaa, ilaa uu wiilkayga Sheelaah koro; waayo, wuxuu isyidhi, Waaba intaasoo uu isna dhintaa sidii walaalihiis. Kolkaasay Taamaar tagtay oo gurigii aabbeheed joogtay. ");
INSERT INTO som_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Wakhti dheer ka dib waxaa dhimatay Shuuca gabadhiisii oo ahayd naagtii Yahuudah. Markaasaa Yahuudah loo tacsiyeeyey, oo wuxuu tegey xagga kuwii idihiisa dhogorta ka xiiri jiray oo joogay Timnaad, isaga iyo saaxiibkiis Xiirah kii reer Cadullaamba. ");
INSERT INTO som_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Markaasaa Taamaar loo sheegay, oo waxaa lagu yidhi, Bal eeg, soddoggaa wuxuu tegayaa xagga Timnaad inuu idihiisii dhogorta ka soo xiirto. ");
INSERT INTO som_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Markaasay iska dhigtay dharkii carmalinimadeeda, oo waxay hagoogatay indhashareerteedii, oo intay isdedday ayay waxay fadhiisatay iriddii Cenayim, oo ku ag tiil jidka loo maro Timnaad, waayo, waxay aragtay inuu Sheelaah weynaaday, oo aan loo guurin iyada. ");
INSERT INTO som_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Markii Yahuudah arkay ayuu u maleeyey inay dhillo tahay; maxaa yeelay, wejigeeday qarisay. ");
INSERT INTO som_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Kolkaasuu ku soo leexday iyadoo jidka ag fadhida, oo wuxuu ku yidhi, Waan ku baryayaaye, kaalay aan kuu tagee; waayo, ma uu ogayn inay tahay gabadhii uu soddogga u ahaa. Kolkaasay waxay ku tidhi, Maxaad i siinaysaa aad ii tagtide? ");
INSERT INTO som_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Markaasuu wuxuu ku yidhi, Waxaan adhiga kaaga soo diri doonaa waxar. Iyana waxay tidhi, Rahaamad ma i siinaysaa intaad ii soo diraysid? ");
INSERT INTO som_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Isna wuxuu yidhi, Maxaan rahaamad kuu siiyaa? Kolkaasay tidhi, I sii kaatunkaaga iyo xadhiggaaga, iyo ushaada aad gacanta ku haysatid. Kolkaasuu siiyey, oo uu u tegey iyadii, oo iyana xaggiisay ka uuraysatay. ");
INSERT INTO som_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Kolkaasay kacday oo tagtay, oo intay indhashareerteedii iska dhigtay, ayay xidhatay dharkii carmalinimadeedii. ");
INSERT INTO som_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Markaasaa Yahuudah waxar adhiga ka soo diray oo wuxuu ugu soo dhiibay gacanta saaxiibkiis kii reer Cadullaam, inuu rahaamaddii ka soo qaado gacantii naagta, laakiinse iyadii wuu waayay. ");
INSERT INTO som_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Markaasuu weyddiiyey dadkii degganaa meesheedii, oo wuxuu ku yidhi, Meeday dhilladii joogi jirtay Cenayim jidka dhinaciisa? Kolkaasay iyana ku yidhaahdeen, Halkan dhillo ma joogi jirin. ");
INSERT INTO som_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Markaasuu ku noqday Yahuudah, oo wuxuu ku yidhi, Iyadii waan waayay, dadkii meeshaa degganaana waxay igu yidhaahdeen, Halkan dhillo ma joogi jirin. ");
INSERT INTO som_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Markaasaa Yahuudah yidhi, Ha iska qaadato, waaba intaasoo aynu ku ceebownaaye; waayo, bal eeg, anigu waxaan u diray waxarkan, waana aad soo weyday iyadii. ");
INSERT INTO som_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Oo waxay noqotay in muddo saddex bilood ku dhow dabadeed Yahuudah war loo soo sheegay, oo lagu yidhi, Gabadhii Taamaar oo aad soddogga u ahayd waa dhillowday; oo dhillanimadeedii bay ku uuraysatay. Markaasaa Yahuudah yidhi, Soo bixiya oo ha la gubo. ");
INSERT INTO som_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Kolkaasay markii la soo bixiyey farriin u dirtay soddoggeed, oo waxay tidhi, Ninka alaabtan leh ayaa i uureeyey; oo waxay kaloo tidhi, Waan ku baryayaaye, bal hubso ninka leh kuwan ah kaatunka iyo xadhkaha, iyo usha. ");
INSERT INTO som_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Markaasaa Yahuudah qirtay iyagii, oo wuxuu yidhi, Iyadu way iga xaqsan tahay, waayo, waxaan iyada siin waayay wiilkayga Sheelaah ah. Mar dambena uma uu tegin iyadii. ");
INSERT INTO som_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Oo bal eeg, markii ay foolatay mataano baa ku jiray maxalkeeda. ");
INSERT INTO som_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Oo waxay noqotay, in markii ay foolatay uu midkood gacan soo bixiyey; markaasay umulisadii qaadatay dun guduudan oo ay gacantiisii ku xidhay, oo waxay tidhi, Kanaa soo hor baxay. ");
INSERT INTO som_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Oo waxay noqotay, markuu gacanta dib u ceshaday, inuu walaalkiis soo baxay; oo iyana waxay tidhi, De maxaad u soo dustay? Sidaas daraaddeed magiciisii waxaa loo bixiyey Feres. ");
INSERT INTO som_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Dabadeedna waxaa soo baxay walaalkiis, kii ay dunta guduudanu gacanta ugu xidhnayd; magiciisiina waxaa loo bixiyey Serax. ");
INSERT INTO som_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Yuusufna waxaa la keenay Masar. Kuwii reer Ismaaciil oo isaga halkaas geeyeyna waxaa gacantoodii ka iibsaday nin Masri ahaa oo la odhan jiray Footiifar, oo Fircoon sirkaal u ahaa, oo madaxii waardiyayaasha ahaa. ");
INSERT INTO som_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Rabbiguna waa la jiray Yuusuf, wuxuuna ahaa nin liibaansan, wuxuuna joogi jiray gurigii sayidkiisii Masriga ahaa. ");
INSERT INTO som_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Sayidkiisiina wuu arkay in Rabbigu liibaaniyey wixii uu sameeyey oo dhan. ");
INSERT INTO som_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Isaguna raalli buu Yuusuf ka ahaa, Yuusufna waa u adeegi jiray, oo wuxuu isagii ka dhigay kan gurigiisa u sarreeya, wixii uu haystay oo dhanna gacantiisuu wada geliyey. ");
INSERT INTO som_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Oo waxay noqotay in wakhtigii uu ka dhigay kan u sarreeya gurigiisa iyo wixii uu haystay oo dhan, uu Rabbigu gurigii kii Masriga ahaa u barakeeyey Yuusuf aawadiis, wixii uu guriga iyo beertaba ku haystay oo dhanna barakada Rabbigaa saarnayd. ");
INSERT INTO som_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Wixii uu lahaa oo dhanna Yuusuf gacantiisuu kaga tegey. Waxbana kama ogayn wixii uu hayay, wixii uu cuni jiray mooyaane. Yuusufna aad buu u quruxsanaa, wuuna suurad wanaagsanaa. ");
INSERT INTO som_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Oo waxay noqotay waxyaalahaas ka dib in naagtii sayidkiisu ay fiirisay Yuusuf, oo ay ku tidhi, Kaalay ila jiifso. ");
INSERT INTO som_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Laakiinse wuu diiday, oo wuxuu ku yidhi naagtii sayidkiisa, Bal eeg, sayidkaygu waxba kama oga waxa aan guriga ku hayo; wixiisii oo dhanna gacantayduu wada geliyey; ");
INSERT INTO som_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","oo weliba gurigan mid aniga iga weynu ma joogo, oo isaguna waxba igalama hadhin adiga mooyaane, maxaa yeelay, adigu waxaad tahay naagtiisii, de haddaba sidee baan u samayn karaa xumaantan weyn, oo aan Ilaah ugu dembaabaa? ");
INSERT INTO som_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Oo waxay noqotay, in kastoo ay maalinba maalinta ka dambaysa la hadlaysay Yuusuf, inuu maqli waayay inuu la jiifsado ama uu la joogo iyadii. ");
INSERT INTO som_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Oo waxay noqotay haddaa oo kale, inuu gurigii galay inuu shuqulkiisii qabsado, nimankii gurigana midna gudaha ma joogin. ");
INSERT INTO som_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Kolkaasay qabsatay dharkiisii, oo waxay ku tidhi, Ila jiifso. Isaguse dharkiisii gacanteeduu kaga tegey, wuuna cararay oo baxay. ");
INSERT INTO som_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Markay aragtay inuu dharkiisii gacanteeda kaga tegey, oo uu dibadda u cararay, ");
INSERT INTO som_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ayay u yeedhay raggii gurigeeda oo ay la hadashay, oo waxay ku tidhi, Bal eega, ninkaygu wuxuu inoo keenay nin Cibraani ah inuu inagu majaajiloodo. Wuxuu iigu soo galay inuu ila jiifsado aawadeed, markaasaan cod dheer ku qayliyey, ");
INSERT INTO som_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","oo markuu maqlay inaan codkaygii sare u qaaday oo aan qayliyey ayuu dharkiisii iiga tegey, wuuna cararay oo baxay. ");
INSERT INTO som_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Dharkiisiina way is-ag dhigtay ilaa uu sayidkiisii guriga yimid. ");
INSERT INTO som_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Kolkaasay hadalkan kula hadashay isagii, oo waxay ku tidhi, Addoonkii Cibraaniga ahaa, oo aad inoo keentay, ayaa iigu soo galay inuu igu majaajiloodo, ");
INSERT INTO som_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","oo markaan codkaygii sare u qaaday oo aan qayliyey ayuu dharkiisii iiga tegey, oo uu dibadda u cararay. ");
INSERT INTO som_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Markii sayidkiisii maqlay hadalkii naagtiisa, oo ay kula hadashay isaga, iyadoo leh, Addoonkaagii sidan buu igu sameeyey, ayuu cadhooday. ");
INSERT INTO som_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Markaasaa Yuusuf sayidkiisii qabtay isagii, oo wuxuu geliyey xabsigii ahaa meeshii maxaabiista boqorku ku xidhnaayeen; oo isna halkaasuu ku jiray xabsigii gudihiisa. ");
INSERT INTO som_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Laakiinse Yuusuf waxaa la jiray Rabbiga, wuuna u roonaaday, kii xabsiga hayayna raalli buu uga dhigay. ");
INSERT INTO som_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Kii xabsiga hayayna wuxuu Yuusuf gacanta u geliyey maxaabiistii xabsiga ku jirtay oo dhan; oo wax kastoo ay halkaas ku sameeyeenna, wuxuu ahaa kii sameeyey. ");
INSERT INTO som_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Kii xabsiga hayayna ma uu eegi jirin waxa isaga gacantiisa ku jira, maxaa yeelay, Rabbigaa la jiray isaga, wixii uu sameeyeyna Rabbigu waa liibaaniyey. ");
INSERT INTO som_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Waxyaalahaas ka dib, kii boqorkii Masar khamriga siin jiray iyo kii wax u dubi jiray waxay xumeeyeen sayidkoodii ahaa boqorkii Masar. ");
INSERT INTO som_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Fircoonna aad buu ugu cadhaysnaa labadiisii sirkaal oo ahaa kii madaxa u ahaa kuwii khamriga siin jiray, iyo kii madaxa u ahaa kuwii wax u dubi jiray. ");
INSERT INTO som_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Oo wuxuu iyagii ku xabbisay gurigii madaxa waardiyayaasha, xagga xabsiga gudihiisa oo ahaa meeshii Yuusuf ku xidhnaa. ");
INSERT INTO som_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Madaxii waardiyayaashuna Yuusuf amar buu u siiyey iyagii, wuuna u adeegi jiray iyagii; intii wakhti ahna xabsigay ku jireen. ");
INSERT INTO som_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Kii khamriga siin jiray iyo kii wax u dubi jiray boqorkii Masar, iyagoo xabsiga ku xidhnaa, ayay labadoodiiba isku habeen riyoodeen, nin kastaana riyadiisuu ku riyooday oo nin kastaa wuxuu ku riyooday sidii riyadiisii fasirkeedu ahaa. ");
INSERT INTO som_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Subaxdii baa Yuusuf u soo galay oo fiiriyey iyagii, oo wuxuu arkay iyagoo calool xun. ");
INSERT INTO som_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Markaasuu wax weyddiiyey saraakiishii Fircoon oo isaga lagula xabbisay guriga sayidkiisa, oo wuxuu ku yidhi, Maxaad maanta ugu eg tihiin kuwo calool xun? ");
INSERT INTO som_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Markaasay waxay ku yidhaahdeen isagii, Riyaannu ku riyoonnay, mana jiro mid fasiri karaa. Markaasaa Yuusuf wuxuu ku yidhi iyagii, Miyaan Ilaah fasirro lahayn? Haddaba waan idin baryayaaye, bal ii sheega. ");
INSERT INTO som_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Markaasaa madaxii kuwii khamriga keeni jiray riyadiisii Yuusuf u sheegay, oo wuxuu yidhi, Riyadaydii waxaan ku arkay geed canab ah oo i hor yaal. ");
INSERT INTO som_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Geedkuna wuxuu lahaa saddex laamood. Waxayna u ekaayeen sidii iyagoo magoolaya, ubaxyadiina soo baxayaan; markaasaa rucubyadii waxay noqdeen canab bisil. ");
INSERT INTO som_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Koobkii Fircoonna gacantayduu ku jiray, markaasaan canabkii guray oo koobkii Fircoon ku tuujiyey, koobkiina waxaan u dhiibay gacantii Fircoon. ");
INSERT INTO som_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Markaasaa Yuusuf ku yidhi, Fasirkeedii waa kan: saddexda laamood waa saddex maalmood. ");
INSERT INTO som_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Oo weliba saddex maalmood dhexdooda ayaa Fircoon madaxaaga kor u qaadi doonaa, oo meeshaaduu kugu celin doonaa; Fircoon koobkiisiina gacantiisaad u dhiibi doontaa sidii waagii hore markaad ahaan jirtay kii khamriga siin jiray. ");
INSERT INTO som_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Laakiinse waan ku baryayaaye, i soo xusuuso markay kuu hagaagto, oo ii roonow, oo Fircoon ii sheeg, oo gurigan iga bixi; ");
INSERT INTO som_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","waayo, waxaa layga soo xaday dhulka Cibraaniyada, oo halkanna kuma aan samayn wax ay iigu ridaan godxabsiga. ");
INSERT INTO som_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Madaxii kuwii wax dubi jiray markuu arkay inuu fasirkaasu wanaagsanaa ayuu wuxuu Yuusuf ku yidhi, Aniguna waxaan riyadaydii ku arkay saddex dambiil oo kibis cadcadu ku jirto oo madaxayga saaran. ");
INSERT INTO som_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Oo dambiishii ugu wada sarreeyey waxaa ku jiray cunto cayn kasta ah oo Fircoon loo dubay; markaasay haadkii cuntadii ka cuneen dambiishii madaxayga saarnaa. ");
INSERT INTO som_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Markaasaa Yuusuf u jawaabay oo ku yidhi, Fasirkeedii waa kan; saddexda dambiil waa saddex maalmood. ");
INSERT INTO som_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Oo weliba saddex maalmood dhexdooda ayaa Fircoon madaxaaga kor kaaga qaadi doonaa, geed buuna kaa soo deldeli doonaa, markaasaa haadku hilibkaaga cuni doonaa. ");
INSERT INTO som_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Maalintii saddexaad oo la xusuustay maalintii Fircoon dhashay ayuu addoommadiisii oo dhan diyaafad u sameeyey; markaasuu kor u qaaday madaxii kii madaxa u ahaan jiray kuwii khamriga isaga siin jiray iyo madaxii kii madaxa u ahaan jiray kuwii wax u dubi jiray oo addoommadiisa dhex joogay. ");
INSERT INTO som_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Markaasuu madaxii kuwii khamriga keeni jiray mar kale shaqadiisii ku celiyey; oo koobkii buu u dhiibay gacantii Fircoon; ");
INSERT INTO som_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","laakiinse madaxii kuwii wax dubi jiray ayuu deldelay sidii Yuusuf ugu fasiray iyaga. ");
INSERT INTO som_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Laakiinse madaxii kuwii khamriga keeni jiray ma uu xusuusan Yuusuf, wuuse illoobay isagii. ");
INSERT INTO som_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Markii laba sannadood oo dhammu dhammaatay ayuu Fircoon riyooday, oo wuxuu is-arkay isagoo webiga ag taagan. ");
INSERT INTO som_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Oo bal eeg, waxaa webigii ka soo baxay toddoba sac oo quruxsan oo cayillan, oo waxay daaqeen cawskii dareemada ahaa. ");
INSERT INTO som_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Markaasaa waxaa dabadood webigii ka soo baxay toddoba sac oo kale oo fool xun, oo weyd ahaa, oo waxay is-ag taageen sicihii kale oo webiga qarkiisa jooga. ");
INSERT INTO som_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Markaasaa sicihii foosha xumaa oo weydda ahaa waxay cuneen toddobadii sac oo qurxoonayd oo cayillanayd. Kolkaasuu Fircoon toosay. ");
INSERT INTO som_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Markaasuu haddana seexday oo mar labaad riyooday, oo wuxuu arkay toddoba sabuul oo buurbuuran oo wanaagsan oo ka soo baxay isku jirid. ");
INSERT INTO som_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Oo bal eeg, waxaa haddana ka soo daba baxay toddoba sabuul oo xunxun, oo ay dabayshii bari qallajisay. ");
INSERT INTO som_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Markaasaa sabuulladii xunxumaa waxay liqeen toddobadii sabuul oo buurbuurnayd oo iltirnayd. Markaasuu Fircoon toosay, oo wuxuu arkay inay riyo tahay. ");
INSERT INTO som_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Oo subaxdiina wuu dhibaataysnaa, kolkaasuu u cid diray oo uu u wada yeedhay saaxiriintii Masar oo dhan iyo nimankii xigmadda lahaa oo dhan; markaasaa Fircoon u sheegay riyadiisii; laakiin ma jirin mid Fircoon u fasiri karaa. ");
INSERT INTO som_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Markaasaa waxaa Fircoon la hadlay kii madaxa u ahaa kuwa khamriga siin jiray isaga, oo wuxuu ku yidhi, Maantaan xusuustay dembiyadaydii. ");
INSERT INTO som_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Fircoonow, adigoo u cadhaysnaa addoommadaada, waxaad igu xabbistay guriga madaxa waardiyayaasha, oo waxaannu ahayn aniga iyo kii madaxa u ahaa kuwii wax dubi jiray; ");
INSERT INTO som_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","oo markaasaannu isku habeen riyoonnay, aniga iyo isagiiba; waxaannu ku riyoonnay midkayo kastaba sidii riyadiisii fasirkeedu ahaa. ");
INSERT INTO som_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Oo halkaasna waxaa nala joogay nin dhallinyaro ah oo Cibraani ah, oo madaxa waardiyayaasha addoon u ahaa, markaasaannu isagii u sheegnay, oo isna wuu noo fasiray riyooyinkayagii, nin kastana sidii riyadiisu ahayd buu ugu fasiray. ");
INSERT INTO som_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Oo sidii uu noogu fasiray ayay noqotay. Aniga waxaa laygu soo celiyey meeshaydii, isagiina waa la deldelay. ");
INSERT INTO som_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Dabadeedna Fircoon baa u cid diray oo u yeedhay Yuusuf. Markaasay dhaqso uga soo bixiyeen godxabsigii; kolkaasuu xiirtay, oo dharkiisii beddeshay, oo uu u soo galay Fircoon. ");
INSERT INTO som_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Markaasaa Fircoon wuxuu Yuusuf ku yidhi, Riyaan ku riyooday, mana jiro mid fasiri karaa; oo waxaan maqlay in markii aad riyo maqashid aad fasiri kartid. ");
INSERT INTO som_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yuusufna Fircoon buu u jawaabay oo ku yidhi, Taasu xaggayga ma aha, laakiinse Ilaah wuxuu Fircoon siin doonaa jawaab nabadeed. ");
INSERT INTO som_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Markaasaa Fircoon Yuusuf la hadlay, oo yidhi, Waxaan riyadaydii ku arkay anigoo webiga qarkiisa taagan; ");
INSERT INTO som_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","oo bal eeg, waxaa webigii ka soo baxay toddoba sac oo buurbuuran oo quruxsan oo waxay daaqeen cawskii dareemada ahaa; ");
INSERT INTO som_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","oo waxaa haddana ka soo daba baxay toddoba sac oo kale, oo taagdaran oo fool xun oo weyd ah. Weligay dhulka Masar oo dhan kuma aan arag kuwa sidooda u xun. ");
INSERT INTO som_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Markaasaa sicihii weydda ahaa oo foosha xumaa waxay cuneen toddobadii sac oo hore. ");
INSERT INTO som_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Oo markay cuneen lagama garan karin inay cuneen, laakiinse waxay u fool xumaayeen sidii markii hore. Markaasaan toosay. ");
INSERT INTO som_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Oo waxaan kaloo riyadaydii ku arkay toddoba sabuul oo iltiran oo wanaagsan, oo ka soo baxay isku jirid; ");
INSERT INTO som_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","dabadeedna waxaa ka soo daba baxay toddoba sabuul oo engegan oo xunxun oo dabayshii bari qallajisay. ");
INSERT INTO som_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Markaasaa sabuulladii xunxumaa waxay liqeen toddobadii sabuul oo wanaagsanayd; markaasaan u sheegay saaxiriinta, laakiinse ma uu jirin mid ii sheegi karay. ");
INSERT INTO som_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Oo Yuusuf wuxuu ku yidhi Fircoon, Riyadaadu waa mid, oo waxa Ilaah samaynayo ayuu kuu sheegay, Fircoonow. ");
INSERT INTO som_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Toddobada sac oo wanwanaagsanu waa toddoba sannadood, toddobada sabuul oo wanwanaagsanuna waa toddoba sannadood; riyadu waa mid. ");
INSERT INTO som_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Toddobada sac oo weyd ah oo foosha xun, oo ka soo daba baxay waa toddoba sannadood, oo haddana toddobada sabuul oo madhan, oo dabayshii bari qallajisay waxay noqon doonaan toddoba sannadood oo abaar ah. ");
INSERT INTO som_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Taasu waa wixii aan kugula hadlay, Fircoonow. Waxa Ilaah samaynayo ayuu ku tusay. ");
INSERT INTO som_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Oo bal eeg, waxaa dalka Masar oo dhan imanaya toddoba sannadood oo barwaaqo ah, ");
INSERT INTO som_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","oo dabadoodna waxaa dhici doona toddoba sannadood oo abaar ah; oo barwaaqadii oo dhanna waa laga illoobi doonaa dalka Masar, markaasay abaartu dhulka dhammayn doontaa, ");
INSERT INTO som_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","barwaaqadana dhulka laguma ogaan doono abaartaas ka dambaysa aawadeed, waayo, waxay noqon doontaa mid aad u xun. ");
INSERT INTO som_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Oo taas aawadeed riyadii labanlaab bay kuu noqotay, Fircoonow, maxaa yeelay, waxaas waxaa amray Ilaah, oo weliba Ilaah dhowaan buu samayn doonaa. ");
INSERT INTO som_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Haddaba Fircoonow, waxaad doontaa nin caqli iyo xigmad leh, oo u sarraysii dalka Masar oo dhan. ");
INSERT INTO som_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Tan yeel oo waxaad doorataa niman dalka u sarreeya, oo waxa toddobada sannadood oo barwaaqada ah dhulka ka baxa inta shanaad ha ururiyeen. ");
INSERT INTO som_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Oo cuntada oo dhan sannadahan wanaagsan oo imanaya ha ururiyeen, hadhuudhkana ha kugu hoos kaydiyeen, Fircoonow, oo intay cunto ahaan magaalooyinka u dhigaan, ha ilaaliyeen. ");
INSERT INTO som_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Cuntaduna kayd bay dalka u noqon doontaa toddobada sannadood oo abaarta ah oo ka dhici doonta dalka Masar, si aan dalku abaarta ugu baabbi'in. ");
INSERT INTO som_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Waxaasuna Fircoon way la wanaagsanaayeen, isaga iyo addoommadiisiiba. ");
INSERT INTO som_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Markaasaa Fircoon wuxuu addoommadiisii ku yidhi, Miyaynu heli karaynaa mid la mid ah kan, oo ah nin Ruuxa Ilaah ku jiro? ");
INSERT INTO som_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Markaasuu Fircoon wuxuu Yuusuf ku yidhi, Mar haddii Ilaah ku tusay waxyaalahan oo dhan, ma jiro mid sidaadoo kale caqli iyo xigmad u leh. ");
INSERT INTO som_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Adigu waxaad ka sarrayn doontaa gurigayga, dadkayga oo dhanna waxaa lagu xukumi doonaa si waafaqsan hadalkaaga, oo anigu carshiga oo keliya ayaan kaaga weynaan doonaa. ");
INSERT INTO som_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Markaasaa Fircoon wuxuu Yuusuf ku yidhi, Bal eeg, dalka Masar oo dhan ayaan kaa sarraysiiyey. ");
INSERT INTO som_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Markaasuu Fircoon gacantiisa ka bixiyey kaatunkiisii, oo Yuusuf gacanta u geliyey, oo wuxuu u xidhay dhar aad u wanaagsan, silsilad dahab ahna qoortuu u sudhay; ");
INSERT INTO som_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","oo wuxuu fuushiiyey gaadhifaraskii labaad oo uu lahaa, oo waxay hortiisa kaga qayliyeen, Sujuuda; oo wuxuu ka sarraysiiyey dalka Masar oo dhan. ");
INSERT INTO som_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Markaasaa Fircoon wuxuu Yuusuf ku yidhi, Anigu waxaan ahay Fircoon, oo adiga la'aantaa ninna gacantiisa ama cagtiisa kor uma qaadi doono dalka Masar oo dhan. ");
INSERT INTO som_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Markaasaa Fircoon wuxuu Yuusuf magiciisii u bixiyey Saafnad Facneh, oo wuxuu u guuriyey Aasenad oo ahayd ina Footiiferac, wadaadkii Oon. Yuusufna markaasuu dalkii Masar oo dhan u baxay oo wada maray. ");
INSERT INTO som_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Yuusufna soddon sannadood buu jiray markuu hor istaagay Fircoon oo ahaa boqorkii Masar. Markaasaa Yuusuf Fircoon hortiisii ka tegey, oo wuxuu wada maray dalkii Masar oo dhan. ");
INSERT INTO som_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Markaasaa toddobadii sannadood oo barwaaqada ahayd waxaa dhulkii ka soo baxay wax aad u badan. ");
INSERT INTO som_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Markaasuu ururiyey cuntadii toddobadii sannadood baxday oo dalka Masar oo dhan tiil, oo cuntadii wuxuu ku kaydiyey magaalooyinka. Cuntadii beerihii ku wareegsanaa magaalo kastana isku meel buu ku kaydiyey. ");
INSERT INTO som_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Markaasaa Yuusuf hadhuudh aad u badan wuxuu u kaydiyey sida cammuudda badda, ilaa uu tirintii daayay, maxaa yeelay, waxay ahayd wax aan tiro lahayn. ");
INSERT INTO som_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Oo Yuusuf waxaa u dhashay laba wiil intii aan sannaddii abaarta ahayd iman, oo waxaa u dhashay Aasenad oo ahayd ina Footiiferac, wadaadkii Oon. ");
INSERT INTO som_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Markaasaa Yuusuf wuxuu curadkii magiciisii u bixiyey Manaseh; waayo, wuxuu yidhi, Ilaah waa i illowsiiyey dhibaatadaydii oo dhan, iyo gurigii aabbahay oo dhan. ");
INSERT INTO som_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Kii labaadna magiciisii wuxuu u bixiyey Efrayim. Waayo, wuxuu yidhi, Ilaah waa igu badiyey dalkii aan ku dhibtooday. ");
INSERT INTO som_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Markaasaa toddobadii sannadood oo barwaaqada ahayd ay dalkii Masar ka dhammaadeen. ");
INSERT INTO som_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Oo waxaa bilaabatay toddobadii sannadood oo abaarta ahayd, sidii Yuusuf yidhi. Dalalkii oo dhanna abaar baa ka dhacday; laakiinse dalka Masar oo dhan cuntaa jirtay. ");
INSERT INTO som_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Oo markii dalkii Masar oo dhammu wada abaarsaday ayaa dadkii Fircoon cunto ugu qayliyeen. Markaasaa Fircoon wuxuu ku yidhi Masriyiintii oo dhan, Yuusuf u taga, oo wuxuu idin yidhaahdo yeela. ");
INSERT INTO som_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Oo abaartuna waxay ka dhacday dhulka dushiisa oo dhan. Markaasaa Yuusuf wada furay maqsinnadii oo dhan, oo wuxuu hadhuudhkii ka iibiyey Masriyiintii, abaartuna aad bay ugu xumayd dalka Masar. ");
INSERT INTO som_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Markaasaa dalalkii oo dhammu waxay u soo safreen Masar, oo Yuusuf bay ugu yimaadeen inay hadhuudh ka iibsadaan; maxaa yeelay, abaartu aad bay ugu xumayd dhulka oo dhan. ");
INSERT INTO som_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Haddaba Yacquub wuxuu arkay in hadhuudh laga helo Masar, markaasuu Yacquub wiilashiisii ku yidhi, War maxaa midkiinba midka kale u fiirinayaa? ");
INSERT INTO som_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Oo wuxuu yidhi, Bal ogaada, waxaan maqlay in hadhuudh laga helo Masar. Bal xaggaas u dhaadhaca, oo halkaas wax inooga soo iibiya, inaynu noolaanno oo aynaan dhimanin. ");
INSERT INTO som_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Markaasaa Yuusuf tobankiisii walaal waxay u tageen Masar inay hadhuudh ka soo iibsadaan. ");
INSERT INTO som_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Laakiinse Benyaamiin oo ahaa Yuusuf walaalkiis Yacquub ma uu raacinin walaalihiis; waayo, wuxuu isyidhi, Waaba intaasoo belaayo ku dhacdaa. ");
INSERT INTO som_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Markaasaa wiilashii Israa'iil waxay u yimaadeen inay wax iibsadaan, iyagoo la socda kuwii yimid, waayo, abaartu dalkii Kancaanna way ka dhacday. ");
INSERT INTO som_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Yuusufna wuxuu ahaa taliyihii dalka, isaguna wuxuu ahaa kii wax ka iibin jiray dadka dalka oo dhan. Markaasay Yuusuf walaalihiis u yimaadeen isagii, oo intay u wada sujuudeen ayay wejiga dhulka wada saareen. ");
INSERT INTO som_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yuusufna walaalihiis wuu arkay, wuuna gartay, laakiin wuxuu isaga dhigay sidii nin qalaad, oo intuu si qallafsan ula hadlay ayuu wuxuu ku yidhi iyagii, War xaggee baad ka timaadeen? Oo iyana waxay yidhaahdeen, Waxaannu ka nimid dalka Kancaan si aannu cunto u iibsanno. ");
INSERT INTO som_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yuusufna wuu gartay walaalihiis laakiinse iyagu ma ay garan isagii. ");
INSERT INTO som_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Markaasaa Yuusuf xusuustay riyooyinkii iyaga ku saabsanaa oo uu ku riyooday, oo wuxuu ku yidhi iyagii, Basaasyaad tihiin, oo waxaad u timaadeen inaad aragtaan dhulka abaarnimadiisa. ");
INSERT INTO som_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Iyana waxay ku yidhaahdeen isagii, Maya, sayidkayagiiyow, laakiinse annagoo addoommadaada ah waxaannu u nimid inaannu cunto iibsanno. ");
INSERT INTO som_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Kulligayo isku nin wiilashiis baannu nahay, oo waxaannu nahay niman daacad ah, oo annagoo addoommadaada ah basaasyo ma nihin. ");
INSERT INTO som_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Oo isna wuxuu ku yidhi iyagii, Maya, laakiinse waxaad u timaadeen inaad aragtaan dhulka abaarnimadiisa. ");
INSERT INTO som_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Iyana waxay yidhaahdeen, Annagoo ah addoommadaada waxaannu nahay laba iyo toban walaalo ah, oo waxaannu nahay nin jooga dalka Kancaan wiilashiisii; oo bal eeg, kii noogu yaraa wuxuu maanta la joogaa aabbahayo, midna maba joogo. ");
INSERT INTO som_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Markaasuu Yuusuf iyagii ku yidhi, Taasu waa tii aan idinkula hadlay, anigoo leh, Basaasyaad tihiin. ");
INSERT INTO som_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Haddaba tan baa laydinku tijaabin doonaa; nolosha Fircoon baan ku dhaartay inaydaan halkan ka tegi doonin, in walaalkiinnii yaraa halkan yimaado mooyaane. ");
INSERT INTO som_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Mid idinka mid ah dira, oo ha keeno walaalkiin, idinkuna waad xidhnaan doontaan, in la tijaabiyo hadalkiinna, bal inay runi idinku jirto iyo in kale, haddii kalese hubaal nolosha Fircoon baan ku dhaartay inaad basaasyo tihiin. ");
INSERT INTO som_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Markaasuu kulligood muddo saddex maalmood ah wada xabbisay. ");
INSERT INTO som_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Kolkaasaa maalintii saddexaad Yuusuf iyagii ku yidhi, Tan yeela, oo waad noolaan doontaan, waayo, anigu Ilaah baan ka cabsadaa. ");
INSERT INTO som_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Haddaad niman daacad ah tihiin, walaalihiinna midkood ha ku xidhnaado guriga xabsigiinna; laakiinse idinku taga, oo hadhuudh u geeya reerihiinna abaaraysan. ");
INSERT INTO som_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Walaalkiinna idiinku wada yar ii keena; sidaasuu hadalkiinnu ku rumoobi doonaa, mana aad dhiman doontaan. Iyana sidii bay yeeleen. ");
INSERT INTO som_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Markaasay waxay isku yidhaahdeen, Runtii walaalkeen eed baan ka galnay, maxaa yeelay, waxaynu aragnay naftiisii dhibaatada ku jirtay, markuu ina baryay, mana aynu maqlin, sidaas daraaddeed ayay dhibaatadanu inoogu dhacday. ");
INSERT INTO som_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Markaasaa Ruubeen u jawaabay iyagii, oo wuxuu ku yidhi, Miyaanan idinla hadlin oo idinku odhan, Wiilka ha ku dembaabina, oo sow ima aydin maqli waayin? Haddaba bal eega, dhiiggiisii baa laydin weyddiistaye. ");
INSERT INTO som_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Oo iyana ma ay ogayn in Yuusuf gartay iyaga; waayo, turjumaan baa kala dhex joogay. ");
INSERT INTO som_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Markaasuu ka sii jeestay iyagii, wuuna ooyay; oo haddana intuu ku soo noqday ayuu la hadlay, oo wuxuu kala dhex baxay Simecoon, wuuna xidhay isagii iyagoo arkaya. ");
INSERT INTO som_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Markaasaa Yuusuf wuxuu amray in joonyadahoodii hadhuudh looga buuxiyo, iyo in nin walba lacagtiisii loogu celiyo joonyaddiisii iyo in sahay jidka loo siiyo, oo sidii baana loo yeelay. ");
INSERT INTO som_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Markaasay hadhuudhkoodii dameerradoodii ku rarteen, wayna ka tageen halkaas. ");
INSERT INTO som_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Meeshay ku hoydeen markii uu midkood joonyaddiisii ugu furay inuu dameerkiisii cunto siiyo ayuu arkay lacagtiisii oo ku jirta joonyaddiisii afkeeda. ");
INSERT INTO som_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Markaasuu walaalihiis ku yidhi, Lacagtaydii waa lay soo celiyey; oo waxay ku jirtaa joonyaddayda, markaasay qalbiga ka nexeen, oo ay isku jeesteen iyagoo gariiraya, oo waxay isku yidhaahdeen, Waa maxay waxakan Ilaah inagu sameeyey? ");
INSERT INTO som_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Markaasay aabbahood Yacquub ugu yimaadeen dalkii Kancaan, oo waxay isagii u sheegeen wixii ku dhacay oo dhan, iyagoo leh, ");
INSERT INTO som_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Ninka sayidka u ah dalka ayaa si qallafsan noola hadlay, oo wuxuu noo qaatay inaannu dalka basaasayno. ");
INSERT INTO som_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Oo waxaannu isagii ku nidhi, Annagu waxaannu nahay niman daacad ah; oo basaasyo ma aannu nihin. ");
INSERT INTO som_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Waxaannu nahay laba iyo toban walaalo ah, oo ah wiilashii aabbahayo. Mid ma joogo, kii noogu yaraana maanta dalkii Kancaan ayuu aabbahayo la joogaa. ");
INSERT INTO som_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Markaasaa ninkii sayidka u ahaa dalka wuxuu nagu yidhi, Inaad niman daacad ah tihiin tanaan idinku garan doonaaye; walaalihiin mid igaga taga, oo hadhuudh u qaada reerihiinna abaaraysan, oo iska taga, ");
INSERT INTO som_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","oo ii keena walaalkiinnii idiinku wada yaraa, markaasaan garan doonaa inaydaan basaasyo ahayn, laakiinse inaad tihiin niman daacad ah. Markaasaan walaalkiin idin siin doonaa, dalkana waad ka baayacmushtari doontaan. ");
INSERT INTO som_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Oo waxay noqotay in markay joonyadahoodii hadhuudhkii ka shubeen, nin walba xidhmadiisii lacagta ahayd ay ugu jirtay joonyaddiisii, oo markii iyaga iyo aabbahood ay arkeen xidhmooyinkoodii lacagta ahaa ayay baqeen. ");
INSERT INTO som_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Markaasaa aabbahood Yacquub wuxuu iyagii ku yidhi, Gablan baad iga dhigteen, bal eeg, Yuusuf ma joogo, oo Simecoon ma joogo, oo haddana waxaad kaxayn doontaan Benyaamiin; waxyaalahan oo dhammu waa iga gees. ");
INSERT INTO som_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Markaasaa Ruubeen aabbihiis la hadlay, oo wuxuu ku yidhi, Haddii aan isaga kuu keeni waayo, dil labadayda wiil. Aniga ii dhiib isaga, oo anna waan kuu soo celin doonaa. ");
INSERT INTO som_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Markaasuu yidhi, Wiilkaygu idinla dhaadhici maayo; waayo, walaalkiis waa dhintay, oo keligiis baa hadhay. Haddii jidka aad sii maraysaan belaayo kaga dhacdo isaga, de markaas cirradayda caloolxumaad qabriga la gelin doontaan. ");
INSERT INTO som_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Abaartuna dalka aad bay ugu xumayd. ");
INSERT INTO som_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Oo markii ay wada cuneen hadhuudhkii ay Masar ka keeneen ayaa aabbahood ku yidhi, Bal taga haddana, oo cunto yar inoo soo iibiya. ");
INSERT INTO som_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Markaasaa Yahuudah la hadlay isagii, oo wuxuu ku yidhi, Ninkii aad buu noogu digay, oo wuxuu nagu yidhi, Wejigayga ma aad arki doontaan in walaalkiin idinla jiro mooyaane. ");
INSERT INTO som_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Haddaad walaalkayo na raacisid, waannu dhaadhacaynaa oo cuntaannu kuu soo iibinaynaa, ");
INSERT INTO som_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","laakiinse haddaadan isaga dirin, annagu dhaadhici mayno; waayo, ninkii wuxuu nagu yidhi, Wejigayga ma aad arki doontaan in walaalkiin idinla jiro mooyaane. ");
INSERT INTO som_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Markaasaa Israa'iil wuxuu yidhi, Maxaad sida xun iigula macaamilooteen, oo aad ninka ugu sheegteen inaad walaal kale leedihiin? ");
INSERT INTO som_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Markaasay yidhaahdeen, Ninku wuu na haybsaday annaga iyo xigaalkayaga, oo wuxuuna yidhi, Aabbihiin weli ma nool yahay? Walaal kale ma leedihiin? Oo annana waxaannu ugu jawaabnay wixii uu na weyddiiyey; waayo, miyaannu sinaba ku garan karnay inuu nagu odhan doono, Walaalkiin keena? ");
INSERT INTO som_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Markaasaa Yahuudah wuxuu ku yidhi aabbihiis Israa'iil, Wiilka i raaci, oo markaas waannu kici oo waannu tegi doonnaa, inaynu noolaanno, oo aynaan dhiman, annaga, iyo adiga, iyo dhallaankayaguba. ");
INSERT INTO som_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Anigaa dammiin u noqon doona oo anaad i weyddiisan doontaa isaga. Haddii aan kuu keeni waayo isaga oo aan hortaada soo joojin waayo, aniga eeddu ha i saarnaato weligay, ");
INSERT INTO som_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","waayo, haddaannan raagin, hubaal hadda mar labaad waannu soo noqon lahayn. ");
INSERT INTO som_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Markaasaa aabbahood Israa'iil wuxuu iyagii ku yidhi, Hadday haatan saas tahay, bal tan yeela, haddaba midhaha ugu fiican oo dalka weelashiinna ku qaada, oo bal ninkii hadiyad ugu geeya, wuxoogaa beeyo ah, iyo wuxoogaa malab ah, iyo xawaash iyo malmal, iyo lows iyo yicib; ");
INSERT INTO som_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","gacantiinnana lacag labanlaab ah ku qaada, oo lacagtii joonyadihiinna afkooda lagu soo celiyeyna haddana gacantiinna ku qaada, waayo, mindhaa waa la soo qaldamay. ");
INSERT INTO som_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Walaalkiinna kaxeeya, oo kaca, oo bal haddana ninkii u taga, ");
INSERT INTO som_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","oo Ilaaha Qaadirka ahu naxariis ha idinka siiyo ninka hortiisa, inuu idiin sii daayo walaalkiinnii kale iyo Benyaamiin. Oo haddaan carruurtayda ka gablamo, anaa gablamay. ");
INSERT INTO som_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Markaasaa nimankii waxay qaadeen hadiyaddii, lacag labanlaab ahna gacantooday ku qaadeen, Benyaamiinna way kaxeeyeen, wayna kaceen oo Masar tageen, oo waxay hor istaageen Yuusuf. ");
INSERT INTO som_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Oo markii Yuusuf arkay Benyaamiin oo iyaga la jira ayuu wakiilkii gurigiisa ku yidhi, Nimanka guriga soo geli, dabadeedna neef qal oo diyaari, waayo, duhurka nimanku anigay ila qadayn doonaan. ");
INSERT INTO som_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Markaasaa ninkii yeelay wixii Yuusuf ku amray; oo ninkii wuxuu nimankii soo geliyey gurigii Yuusuf. ");
INSERT INTO som_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Nimankiina waa cabcabsadeen, maxaa yeelay, waxaa la soo geliyey gurigii Yuusuf; oo waxay isku yidhaahdeen, Lacagtii markii hore lagu soo celiyey joonyadaheenna weeye waxa laynoo soo xeraystay; wuxuu doonayaa inuu wax inoo qabsado, oo uu ina dhaco, oo uu ina addoonsado, dameerradeennana qaato. ");
INSERT INTO som_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Markaasay waxay u soo dhowaadeen wakiilkii guriga Yuusuf, oo waxay isagii kula hadleen albaabkii guriga, ");
INSERT INTO som_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","waxayna ku yidhaahdeen, Sayidkayagiiyow, markii hore waxaannu u soo dhaadhacnay inaannu cunto iibsanno, ");
INSERT INTO som_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","oo markii aannu meel aannu ku hoyanno gaadhnay ayaannu furnay joonyadahayagii, oo bal eeg, nin walba lacagtiisii waxay ugu jirtay joonyaddiisa afkeeda, waxay ahayd lacagtayadii oo miisaankeedii dhan yahay; oo haddana gacantayadaannu ku soo celinnay. ");
INSERT INTO som_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Oo lacag kale oo aannu cunto ku iibsannona waan la soo dhaadhacnay. Annagu garan mayno kii lacagtayadii ku riday joonyadahayagii. ");
INSERT INTO som_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Isna wuxuu yidhi, Nabad ha idiin ahaato, ee ha cabsanina. Ilaahiinna ah Ilaaha aabbihiin ayaa maal idiinku riday joonyadihiinnii. Anigu waan helay lacagtiinnii. Markaasuu Simecoon dibadda ugu soo bixiyey iyagii. ");
INSERT INTO som_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Oo ninkii baa nimankii soo geliyey gurigii Yuusuf, oo biyo siiyey, kolkaasay cagamaydheen. Dameerradoodiina cuntuu siiyey. ");
INSERT INTO som_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Markaasay diyaariyeen hadiyaddii intuusan Yuusuf duhurkii iman; waayo, waxay maqleen inay halkaas wax ka cuni doonaan. ");
INSERT INTO som_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Oo markii Yuusuf gurigii yimid ayay gurigii ugu keeneen hadiyaddii gacantooda ku jirtay, markaasay u wada sujuudeen oo wejiga dhulka saareen. ");
INSERT INTO som_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Isna markaasuu nabdaadiyey iyagii, oo wuxuu ku yidhi, Ninkii duqa ahaa oo aad sheegteen oo aabbihiin ahaa ma ladan yahay? Weli miyuu nool yahay? ");
INSERT INTO som_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Markaasay yidhaahdeen, Addoonkaagii aabbahayo ahaa waa ladan yahay, welina wuu nool yahay. Kolkaasay madaxa foororiyeen, oo ay u sujuudeen. ");
INSERT INTO som_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Markaasuu intuu indhihiisii kor u taagay wuxuu arkay Benyaamiin oo ahaa walaalkiisii hooyo, oo wuxuu yidhi, Kanu ma walaalkiinnii idiinku yaraa oo aad ii sheegteen baa? Oo wuxuu ku yidhi, Wiilkaygiiyow, Ilaah ha kuu roonaado. ");
INSERT INTO som_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Markaasuu Yuusuf dhaqsaday, oo goobtay meel uu ku ooyo, waayo, walaalkiis buu u beernuglaaday oo wuxuu galay qowladdiisii, oo halkaasuu ku ooyay. ");
INSERT INTO som_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Kolkaasuu intuu fooldhaqday soo baxay; oo intuu adkaystay ayuu wuxuu yidhi, Cunto noo soo dhiga. ");
INSERT INTO som_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Markaasay isagii gooni ahaantiis ugu dhigeen, iyagiina gooni ahaantood, Masriyiintii isaga la cuntayna gooni ahaantood; maxaa yeelay, Masriyiintu lama ay cuni karin Cibraaniyada, waayo, taasu Masriyiinta karaahiyo bay u ahayd. ");
INSERT INTO som_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Oo waxay hor fadhiisteen isagii, curadka sidii curadnimadiisii ahayd buu u fadhiistay, kii ugu yaraana yaraannimadiisii; markaasaa nimankii midba midka kale eegay oo ay wada yaabeen. ");
INSERT INTO som_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Markaasaa hortiisa waxaa iyagii looga qaaday dhawr qaybood oo cunto ah, laakiinse intii Benyaamiin shan jeer bay ka weynayd kuwa kale intoodii. Kolkaasay wax cabbeen oo ay la farxeen isagii. ");
INSERT INTO som_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Markaasuu amray wakiilkii gurigiisa, oo ku yidhi, Nimanka joonyadahooda cunto uga buuxi, in alla intay qaadi karaan, nin walba lacagtiisana joonyaddiisa afkeeda ugu rid. ");
INSERT INTO som_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Kan ugu yar joonyaddiisa afkeedana waxaad ku riddaa koobkayga lacagta ah iyo lacagtiisii uu hadhuudhka ku doonayay. Markaasuu yeelay hadalkii Yuusuf kula hadlay. ");
INSERT INTO som_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Oo markii waagii beryay ayaa nimankii la diray, iyagii iyo dameerradoodiiba. ");
INSERT INTO som_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Oo markay magaaladii dibadda uga baxeen, oo ayan weli fogaan, ayaa Yuusuf ku yidhi wakiilkiisii, Kac oo ka daba tag nimankii, oo markaad gaadhid, waxaad ku tidhaahdaa, Maxaad wanaag xumaan noogu abaalguddeen? ");
INSERT INTO som_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Miyuusan kanu ahayn koobka sayidkaygu wax ku cabbo, oo uu ku faaliyo? Wax xun baad samayseen markaad saas yeesheen. ");
INSERT INTO som_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Kolkaasuu gaadhay, oo uu hadalkan kula hadlay. ");
INSERT INTO som_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Markaasay waxay isagii ku yidhaahdeen, Sayidkaygiiyow, hadalka caynkan ah maxaad ugu hadlaysaa? Yaanay noqon in annagoo ah addoommadaada aannu wax caynkaas ah samayno. ");
INSERT INTO som_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Bal eeg, lacagtii aannu ka dhex helnay joonyadahayaga afafkooda ayaannu kaaga soo celinnay dalkii Kancaan; de haddaba sidee baannu guriga sayidkaaga uga xadi karnaa lacag ama dahab? ");
INSERT INTO som_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ku alla kii addoommadaada ka mid ah oo laga helo, kaasu ha dhinto, annaguna addoommo baannu kuu noqon doonnaa, sayidkaygiiyow. ");
INSERT INTO som_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Markaasuu yidhi, Waa yahay, oo haatan sidaad tidhaahdeen ha noqoto. Kii laga helo addoon buu ii noqon doonaa, idinkuna waad eedla'aan doontaan. ");
INSERT INTO som_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Markaasay degdegeen, oo nin waluba joonyaddiisii buu dhulka dhigay, dabadeedna nin waluba joonyaddiisii buu furay. ");
INSERT INTO som_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Kolkaasuu baadhay, oo wuxuu ka bilaabay kii ugu weynaa, oo wuxuu ku dhammeeyey kii ugu yaraa; oo koobkiina waxaa laga helay joonyaddii Benyaamiin. ");
INSERT INTO som_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Kolkaasay dharkoodii jeexjeexeen, oo nin waluba dameerkiisii buu rartay, oo magaaladii bay ku noqdeen. ");
INSERT INTO som_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Markaasaa Yahuudah iyo walaalihiis waxay yimaadeen gurigii Yuusuf; oo isna weli halkaasuu joogay. Kolkaasay hortiisa dhulka isku tuureen. ");
INSERT INTO som_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Oo Yuusufna wuxuu iyagii ku yidhi, Waxan aad samayseen waa maxay? Miyaydnaan ogayn ninkii anoo kale ahu inuu faalin karo? ");
INSERT INTO som_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Markaasaa Yahuudah ku yidhi, Maxaannu kuugu jawaabnaa, sayidkaygiiyow? Oo maxaannu ku hadalnaa? Ama sidee baannu ku eed baxnaa? Ilaah waa soo saaray dembigayagii annagoo ah addoommadaada; bal eeg, sayidkaygiiyow, waxaannu nahay addoommadaada, annaga iyo kii gacantiisa koobka laga helayba. ");
INSERT INTO som_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Markaasuu yidhi, Yaanay noqon inaan saas yeelo. Ninkii gacantiisa koobka laga helay ayaa addoon ii noqon doona; laakiinse idinku kaca oo nabdoonaan aabbihiin ugu taga. ");
INSERT INTO som_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Markaasaa Yahuudah u soo dhowaaday oo ku yidhi, Sayidkaygiiyow, anigoo addoonkaaga ah waxaan kaa baryayaa inaan hadal yar kugula hadlo, sayidkaygiiyow, oo ha ii cadhoon anigoo ah addoonkaaga; waayo, waxaad la mid tahay sida Fircoon oo kale. ");
INSERT INTO som_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Sayidkaygiiyow, annagoo ah addoommadaada, ayaad wax na weyddiisay oo nagu tidhi, Aabbe ama walaal ma leedihiin? ");
INSERT INTO som_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Oo annaguna waxaannu kugu nidhi, Sayidkaygiiyow, waxaannu leennahay aabbe duq ah, iyo wiil yar oo uu dhalay markuu gaboobay, oo walaalkiisna waa dhintay, oo keligiis baa ka hadhay bahdoodii, aabbihiisna waa jecel yahay isaga. ");
INSERT INTO som_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Oo adigu waxaad nagu tidhi, annagoo ah addoommadaada, Bal ii keena isaga, aan indhahayga saaree. ");
INSERT INTO som_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Oo annaguna waxaannu kugu nidhi, sayidkaygiiyow, Yarku aabbihiis kama tegi karo; waayo, hadduu ka tago aabbihiis, de markaas aabbihiis waa dhiman lahaa. ");
INSERT INTO som_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Oo adna waxaad nagu tidhi, annagoo ah addoommadaada, Haddii uusan walaalkiinnii idiinku yaraa idin soo raacin, wejigayga mar dambe ma aad arki doontaan. ");
INSERT INTO som_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Oo markii aannu u tagnay aabbahay oo addoonkaaga ah, ayaannu isaga u sheegnay hadalladaadii, sayidkaygiiyow. ");
INSERT INTO som_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Oo aabbahayo wuxuu nagu yidhi, Orda haddana oo wuxoogaa yar oo cunto ah inoo soo iibiya. ");
INSERT INTO som_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Oo waxaannu ku nidhi, Ma tegi karno. Haddiise walaalkayaga noogu yaru na raaco, markaasaannu dhaadhici doonnaa; waayo, ma aannu arki karno ninkii wejigiisa, haddii uusan walaalkayaga noogu yaru nala jirin. ");
INSERT INTO som_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Markaasaa addoonkaagii aabbahay ahaa wuxuu nagu yidhi, Waad og tihiin in naagtaydu ii dhashay laba wiil; ");
INSERT INTO som_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","oo uu midkood iga baxay, oo waxaan idhi, Hubaal cadcad baa loo kala jeexjeexay, tan iyo waagaasna ma aanan arkin isagii. ");
INSERT INTO som_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Oo haddaad kanna iga kaxaysataan, oo belaayo ku dhacdo isaga, de markaas cirradayda caloolxumaad qabriga la gelin doontaan. ");
INSERT INTO som_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Haddaba sidaas daraaddeed markii aan u tago aabbahay oo addoonkaagii ah, haddii uusan wiilku nala jirin, de naftiisu waxay ku xidhan tahay nafta wiilka, ");
INSERT INTO som_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","oo wuu dhiman doonaa markuu arko inuusan yarkii nala jirin; oo annagoo ah addoommadaada ayaannu aabbahayaga addoonkaaga ah cirradiisa caloolxumo qabriga la gelin doonnaa. ");
INSERT INTO som_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Waayo, anigoo addoonkaaga ah ayaa aabbahay dammiin uga noqday wiilka, oo waxaan ku idhi, Haddaan kuu keeni waayo, xaggaaga eeddu ha iga saarnaato weligay, Aabbahayow. ");
INSERT INTO som_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Haddaba sidaas daraaddeed, waan ku baryayaaye, aniga oo ah addoonkaagii, aan wiilka meeshiisii kuu joogo oo aan addoon kuu noqdo, sayidkaygiiyow; wiilkuna walaalihiis ha iska raaco. ");
INSERT INTO som_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Waayo, sidee baan aabbahay ugu tegi doonaa iyadoo aan yarku ila jirin? Maba tegi karo waaba intaasoo aan arkaa hoogga aabbahay ku dhici doona. ");
INSERT INTO som_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Markaasaa Yuusuf ku hor adkaysan kari waayay kuwii isaga la taagnaa oo dhan; oo wuxuu ku qayliyey, Nin walba dibadda iiga bixiya. Oo ninnaba lama taagnayn isaga markii Yuusuf walaalihiis isu sheegay. ");
INSERT INTO som_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Markaasuu intuu codkiisii kor u qaaday ooyay; oo Masriyiintiina way maqleen, dadkii guriga Fircoonna way maqleen. ");
INSERT INTO som_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Markaasuu Yuusuf wuxuu walaalihiis ku yidhi, Yuusuf baan ahay, ee aabbahay weli ma nool yahay? Walaalihiisna way u jawaabi kari waayeen; waayo, aad bay ugu argaggexeen hortiisa. ");
INSERT INTO som_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Markaasaa Yuusuf wuxuu walaalihiis ku yidhi, Bal ii soo dhowaada, waan idin baryayaaye. Kolkaasay u soo dhowaadeen. Markaasuu yidhi, Anigu waxaan ahay walaalkiin Yuusuf, kii aad ka iibiseen kuwii Masar tegayay. ");
INSERT INTO som_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Oo haatan ha caloolxumaanina, naftiinnana ha u cadhoonina iibiskii aad halkan iga iibiseen aawadiis; waayo, Ilaah wuxuu hortiin ii soo diray in nafo la badbaadiyo. ");
INSERT INTO som_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Waayo, labadan sannadood baa dhulku abaar ahaa, oo weli waxaa hadhay shan sannadood, oo aan beer la fali doonin, waxna la goosan doonin. ");
INSERT INTO som_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Oo Ilaah wuxuu hortiin ii soo diray inuu dadkiinna qaar dhulka idiinku reebo, oo uu idiin badbaadiyo kuwo fara badan oo baxsada. ");
INSERT INTO som_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Haddaba sidaas daraaddeed idinka ma ahayn kii halkan ii soo diray, laakiinse wuxuu ahaa Ilaah; oo isagu Fircoon buu aabbe iiga dhigay, iyo sayidkii dadka gurigiisa oo dhan, iyo taliyihii dalka Masar oo dhan. ");
INSERT INTO som_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Dhaqsada, oo aabbahay u kaca, oo waxaad isaga ku tidhaahdaan, Wiilkaagii Yuusuf wuxuu kugu soo yidhi, Ilaah wuxuu iga dhigay sayidkii Masar oo dhan, ee soo dhaadhac oo ii kaalay, hana raagin; ");
INSERT INTO som_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","oo waxaad degi doontaa dhulka la yidhaahdo Goshen, oo waad ii soo dhowaan doontaa, adiga iyo carruurtaada, iyo carruurtaada carruurtooda, iyo adhigaaga iyo lo'daada, iyo waxa aad haysatid oo dhanba; ");
INSERT INTO som_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","oo halkaasaan kugu quudin doonaa; waayo, weli waxaa hadhay shan sannadood oo abaar ah, waaba intaasoo aad gaajootaan, adiga iyo reerkaaga, iyo waxa aad haysatid oo dhammuba. ");
INSERT INTO som_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Oo bal eega, indhihiinnu waa arkaan, iyo indhaha walaalkay Benyaamiinba, inuu afkaygii yahay kan idinla hadlaya. ");
INSERT INTO som_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Idinku waxaad aabbahay u sheegtaan ammaantayda aan Masar ku leeyahay oo dhan, iyo wixii aad aragteen oo dhan; oo dhaqsada oo aabbahay halkan keena. ");
INSERT INTO som_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Markaasuu walaalkiis Benyaamiin qoortiisa dhab yidhi, wuuna ku dul ooyay, Benyaamiinna qoortiisuu ku ooyay. ");
INSERT INTO som_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Markaasuu wada dhunkaday walaalihiis oo dhan, wuuna ku dul ooyay; dabadeedna walaalihiis baa la hadlay isagii. ");
INSERT INTO som_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Markaasaa warkii laga maqlay gurigii Fircoon, oo waxaa la yidhi, Yuusuf walaalihiis baa yimid. Taasna aad bay uga farxisay Fircoon iyo addoommadiisiiba. ");
INSERT INTO som_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Markaasaa Fircoon wuxuu Yuusuf ku yidhi, Walaalahaa waxaad ku tidhaahdaa, Idinku sidan yeela, gaadiidkiinna rarta, oo taga oo dalkii Kancaan u kaca; ");
INSERT INTO som_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","oo waxaad soo kaxaysataan aabbihiin iyo reerihiinna oo dhan, oo aniga ii kaalaya; oo anna waxaan idin siin doonaa waxyaalaha wanwanaagsan ee dalka Masar, oo idinku waxaad cuni doontaan barwaaqada dalka. ");
INSERT INTO som_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Haddaba waa lagu amray, Sidan yeela. Gaadhifardood dalka Masar uga kaxaysta dhallaankiinna, iyo dumarkiinna; oo aabbihiin keena, oo kaalaya. ");
INSERT INTO som_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Oo alaabtiinnana ha ka fikirina, waayo, waxyaalaha wanwanaagsan ee dalka Masar oo dhan idinkaa iska leh. ");
INSERT INTO som_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Markaasaa wiilashii Israa'iil saas yeeleen, Yuusufna wuxuu iyagii siiyey gaadhifardood, sidii Fircoon amarkiisu ahaa, sahayna jidkuu u siiyey. ");
INSERT INTO som_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Dhammaantoodna wuxuu nin kasta siiyey dhar iskujoog ah; laakiinse Benyaamiin wuxuu siiyey saddex boqol oo xabbadood oo lacag ah, iyo shan iskujoog. ");
INSERT INTO som_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Oo aabbihiisna sidan buu wax ugu diray, toban dameer oo ay ku raran yihiin waxyaalihii wanwanaagsanaa ee Masar, iyo toban dameerood oo hadhuudh iyo cunto ku raran yihiin, iyo sahaydii aabbihiis jidka ku soo mari lahaa. ");
INSERT INTO som_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Markaasuu walaalihiis diray, oo iyana way tageen; oo wuxuu iyagii ku yidhi, Idinku jidka ha isugu cadhoonina. ");
INSERT INTO som_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Markaasay Masar ka baxeen, oo ay yimaadeen dalkii Kancaan, oo waxay u yimaadeen aabbahood Yacquub. ");
INSERT INTO som_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Markaasay u sheegeen oo ku yidhaahdeen, Yuusuf weli waa nool yahay, oo wuxuu u taliyaa dalka Masar oo dhan. Markaasuu taag darnaaday, waayo, wuu rumaysan waayay iyagii. ");
INSERT INTO som_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Markaasay u sheegeen hadalkii Yuusuf kula hadlay oo dhan, oo markuu arkay gaadhifardoodkii Yuusuf u soo diray in isaga lagu qaado ayaa aabbahood Yacquub ruuxiisii cusboonaaday. ");
INSERT INTO som_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Markaasaa Israa'iil wuxuu yidhi, Igu filan mar haddii wiilkaygii Yuusuf weli nool yahay; haddaba waan tegi doonaa, oo waan arki doonaa isaga intaanan dhiman. ");
INSERT INTO som_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Markaasaa Israa'iil la guuray wixii uu haystay oo dhan, oo wuxuu yimid Bi'ir Shebac, oo halkaasuu Ilaaha aabbihiis Isxaaq allabaryo ugu bixiyey. ");
INSERT INTO som_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Markaasaa Ilaah riyooyinka habeenka kula hadlay Israa'iil oo wuxuu ku yidhi, Yacquubow, Yacquubow. Isna wuxuu yidhi, Waa i kan. ");
INSERT INTO som_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Markaasuu ku yidhi, Anigu waxaan ahay Ilaaha ah Ilaaha aabbahaa. Ha ka baqin inaad Masar ku dhaadhacdo, waayo, anigu halkaas baan kaaga dhigi doonaa quruun weyn. ");
INSERT INTO som_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Anigu Masar baan kuu raaci doonaa, oo hubaal haddana waan kaa soo bixin doonaa; Yuusufna gacantiisuu saari doonaa indhahaaga. ");
INSERT INTO som_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Markaasaa Yacquub ka tegey Bi'ir Shebac, wiilashii Israa'iilna waxay aabbahood Yacquub, iyo dhallaankoodii, iyo dumarkoodiiba ku qaadeen gaadhifardoodkii Fircoon u soo diray in isaga lagu soo qaado. ");
INSERT INTO som_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Oo waxay kaxaysteen xoolahoodii, iyo alaabtoodii ay ka heleen dalkii Kancaan, oo waxayna yimaadeen Masar, Yacquub iyo farcankiisii la socday oo dhammuba; ");
INSERT INTO som_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","kuwaas oo ahaa wiilashiisii iyo wiilashiisii wiilashoodii isaga la socday, iyo gabdhihiisii iyo wiilashiisii gabdhahoodii. Farcankiisii oo dhanna wuxuu keenay Masar. ");
INSERT INTO som_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Kuwanu waa magacyadii reer binu Israa'iil oo Masar yimid, Yacquub iyo wiilashiisii: Ruubeen wuxuu ahaa curadkii Yacquub. ");
INSERT INTO som_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Wiilashii Ruubeenna waxay ahaayeen Xanoog, iyo Falluu, iyo Xesroon, iyo Karmii. ");
INSERT INTO som_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Wiilashii Simecoonna waxay ahaayeen Yemuu'eel, iyo Yaamiin, iyo Ohad, iyo Yaakiin, iyo Sohar, iyo Shaa'uul oo ay naag reer Kancaan ihi dhashay. ");
INSERT INTO som_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Wiilashii Laawina waxay ahaayeen Gershoon, iyo Qohaad, iyo Meraarii. ");
INSERT INTO som_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Wiilashii Yahuudahna waxay ahaayeen Ceer, iyo Oonaan, iyo Sheelaah, iyo Feres, iyo Serax; laakiinse Ceer iyo Oonaan waxay ku dhinteen dalkii Kancaan. Wiilashii Feresna waxay ahaayeen Xesroon iyo Xaamuul. ");
INSERT INTO som_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Wiilashii Isaakaarna waxay ahaayeen Toolac iyo Fuwaah, iyo Yoob, iyo Shimroon. ");
INSERT INTO som_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Wiilashii Sebulunna waxay ahaayeen Sered, iyo Eeloon, iyo Yaxle'eel. ");
INSERT INTO som_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Intaasu waa wiilashii Lee'ah oo ay Yacquub ugu dhashay Fadan Araam, iyo weliba gabadhiisii Diinah ahayd. Yacquub wiilashiisa iyo gabdhihiisa oo dhammu waxay ahaayeen saddex iyo soddon. ");
INSERT INTO som_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Wiilashii Gaadna waxay ahaayeen Sifiyoon, iyo Xaggii, iyo Shuunii, iyo Esboon, iyo Ceerii, iyo Aroodii, iyo Areelii. ");
INSERT INTO som_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Wiilashii Aasheerna waxay ahaayeen Yimnaah, iyo Yishwaah, iyo Yishwii, iyo Beriicaah, iyo walaashood Serax; wiilashii Beriicaahna waxay ahaayeen Xeber iyo Malkii'eel. ");
INSERT INTO som_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Kuwanu waa wiilashii Silfah, tii uu Laabaan siiyey gabadhiisii Lee'ah, oo intaasay Yacquub u dhashay, waxayna ahaayeen lix iyo toban. ");
INSERT INTO som_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Naagtii Yacquub oo Raaxeel ahayd wiilasheedii waxay ahaayeen Yuusuf iyo Benyaamiin. ");
INSERT INTO som_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Yuusufna dalka Masar waxaa ugu dhashay Manaseh iyo Efrayim, oo waxaa u dhashay Aasenad ina Footiiferac, oo wadaadkii Oon ahaa. ");
INSERT INTO som_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Wiilashii Benyaamiinna waxay ahaayeen Belac, iyo Beker, iyo Ashbeel, iyo Geeraa, iyo Nacamaan, iyo Eexii, iyo Rosh, iyo Mufiim, iyo Xufiim, iyo Ared. ");
INSERT INTO som_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Kuwanu waa wiilashii Raaxeel u dhashay Yacquub, kulligoodna waxay ahaayeen afar iyo toban. ");
INSERT INTO som_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Wiilashii Daanna waxay ahaayeen Xushiim. ");
INSERT INTO som_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Wiilashii Naftaalina waxay ahaayeen Yaxse'eel, iyo Guunii, iyo Yeser, iyo Shilleem. ");
INSERT INTO som_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Kuwanuna waa wiilashii Bilhah, tii uu Laabaan siiyey gabadhiisii Raaxeel, oo intaasay Yacquub u dhashay; kulligoodna waxay ahaayeen toddoba. ");
INSERT INTO som_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Intii Yacquub Masar la timid, oo xanjaadkiisa ka soo baxday, haddaan lagu darin wiilashii Yacquub naagahooda, kulligood waxay ahaayeen lix iyo lixdan. ");
INSERT INTO som_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Wiilashii Yuusuf Masar ugu dhashayna waxay ahaayeen laba. Reerkii Yacquub dadkiisii Masar yimid oo dhammu waxay ahaayeen toddobaatan. ");
INSERT INTO som_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Markaasuu wuxuu iska hor mariyey Yahuudah inuu Yuusuf u tago, si uu u tuso jidka loo maro Goshen; oo waxay yimaadeen dalkii Goshen. ");
INSERT INTO som_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yuusufna wuxuu diyaarsaday gaadhifaraskiisii, oo aabbihiis Israa'iil ayuu kaga hor tegey Goshen; oo markuu isagii arkay ayuu qoortiisii dhab yidhi, qoortiisana wuxuu ku dul ooyay wakhti dheer. ");
INSERT INTO som_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Israa'iilna wuxuu Yuusuf ku yidhi, Haddaba aan iska dhinto, mar haddaan arkay wejigaaga, oo aad weli nooshahay. ");
INSERT INTO som_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Yuusufna wuxuu walaalihiis iyo reerkii aabbihiis ku yidhi, Waan tegi, oo Fircoon baan u sheegi, oo waxaan ku odhan, Walaalahay iyo reerkii aabbahay oo joogi jiray dalka Kancaan ayaa ii yimid. ");
INSERT INTO som_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Nimankaasuna waa adhijirro, waayo, waxay ahaan jireen lo'ley; waxayna la yimaadeen adhigoodii, iyo lo'doodii, iyo waxay haysteen oo dhan. ");
INSERT INTO som_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Markii Fircoon idiin yeedho, oo idinku yidhaahdo, Shuqulkiinnu waa maxay? ");
INSERT INTO som_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","waxaad ku tidhaahdaan, Annagoo addoommadaada ah waxaannu tan iyo yaraantayadii ahaan jirnay lo'ley, annaga iyo awowayaashayoba; si aad u degtaan dalka Goshen; waayo, adhijir waluba waa u karaahiyo Masriyiinta. ");
INSERT INTO som_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Markaasaa Yuusuf gudaha galay oo uu Fircoon u warramay, wuxuuna ku yidhi, Aabbahay iyo walaalahay, iyo adhigoodii, iyo lo'doodii, iyo waxay haystaan oo dhammu way ka yimaadeen dalkii Kancaan, oo bal eeg, haatan waxay joogaan dalka Goshen. ");
INSERT INTO som_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Oo walaalihiisna wuxuu ka kaxeeyey shan nin, oo wuxuu hor taagay Fircoon. ");
INSERT INTO som_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Markaasaa Fircoon wuxuu Yuusuf walaalihiis ku yidhi, Shuqulkiinnu waa maxay? Markaasay waxay Fircoon ku yidhaahdeen, Annagoo addoommadaada ah waxaannu nahay adhijirro, annaga iyo awowayaashayoba. ");
INSERT INTO som_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Oo waxay Fircoon ku yidhaahdeen, Inaannu qariib ahaan dhulka u joogno ayaannu u nimid, waayo, adhiga addoommadaadu daaq ma haysto, maxaa yeelay, abaartu aad bay ugu xun tahay dalkii Kancaan; haddaba waxaannu kaa baryaynaa inaannu annagoo addoommadaada ah degno dalka Goshen. ");
INSERT INTO som_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Markaasaa Fircoon la hadlay Yuusuf, oo wuxuu ku yidhi, Aabbahaa iyo walaalahaa aday kuu yimaadeen. ");
INSERT INTO som_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Dalka Masarna wuu ku hor yaal; haddaba dalka meesha ugu wanaagsan aabbahaa iyo walaalahaa deji, oo dalka Goshen ha degeen. Oo haddaad ku garanaysid rag karti leh, de ka dhig kuwo xoolahayga u taliya. ");
INSERT INTO som_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Markaasaa Yuusuf aabbihiis Yacquub gudaha soo geliyey, oo wuxuu soo hor taagay Fircoon; Yacquubna Fircoon wuu u duceeyey. ");
INSERT INTO som_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Fircoonna wuxuu Yacquub ku yidhi, Immisa jir baad tahay? ");
INSERT INTO som_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Markaasaa Yacquub wuxuu Fircoon ku yidhi, Sannadihii aan qariibka ahaa waa boqol iyo soddon; cimrigaygu waa yaraa, wuuna xumaa, mana gaadhin cimrigii awowayaashay qariibka ahaayeen. ");
INSERT INTO som_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Yacquubna Fircoon wuu u duceeyey, markaasuu Fircoon hortiisa ka tegey. ");
INSERT INTO som_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Markaasuu Yuusuf aabbihiis iyo walaalihiis dejiyey dalkii Masar oo uu ka siiyey meel hanti ah, taasoo ah meeshii dalka ugu wanaagsanayd oo ku tiil dalka la yidhaahdo Racmeses, sidii Fircoon ku amray. ");
INSERT INTO som_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yuusufna aabbihiis iyo walaalihiis, iyo reerkii aabbihiis oo dhan, sidii ay carruurtoodii tiradoodii ahayd, ayuu u quudiyey. ");
INSERT INTO som_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Dalkii oo dhanna cunto ma jirin; waayo, abaartu aad bay u xumayd, sidaas daraaddeed dalkii Masar iyo dalkii Kancaan abaartay la taag darnaadeen. ");
INSERT INTO som_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Yuusufna wuxuu ururiyey lacagtii dalka Masar tiil oo dhan, iyo tii dalka Kancaan tiil oo dhan, waayo, hadhuudh bay kaga iibsadeen; Yuusufna lacagtii wuxuu keenay gurigii Fircoon. ");
INSERT INTO som_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Oo markii lacagtii ka wada dhammaatay dalkii Masar iyo dalkii Kancaanba ayay Masriyiintii oo dhammu u yimaadeen Yuusuf, oo waxay ku yidhaahdeen, Cunto na sii, waayo, maxaannu hortaada ugu dhimanaynaa? Maxaa yeelay, lacagtayadii way naga dhammaatay. ");
INSERT INTO som_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Markaasaa Yuusuf wuxuu ku yidhi, Haddii lacagtii idinka dhammaatay, xoolihiinna keena, oo anna xoolihiinna ayaan cunto idinka siin doonaa. ");
INSERT INTO som_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Markaasay xoolahoodii Yuusuf u keeneen, Yuusufna wuxuu iyagii cunto ugu beddelay fardihii, iyo adhigii, iyo lo'dii iyo dameerradii; oo sannaddaas ayuu quudiyey oo xoolahoodii oo dhan cunto ugu beddelay. ");
INSERT INTO som_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Oo markii sannaddaasi dhammaatay ayay sannaddii labaad u yimaadeen, oo waxay ku yidhaahdeen, Sayidkaygiiyow, kaa qarin mayno in lacagtayadii oo dhammu naga idlaatay, ishkinkii lo'da ahaana adigaa leh, sayidkaygiiyow, waxba kuma hadhin hortaada, sayidkaygiiyow, jidhkayaga iyo dhulalkayaga mooyaane. ");
INSERT INTO som_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","De haddaba maxaannu hortaada ugu dhimanaynaa annaga iyo dhulkayaguba? Annaga iyo dhulkayagaba cunto nagu iibso, oo annaga iyo dhulkayaguba Fircoon baannu addoommo u noqon doonnaa. Abuur la beero na sii inaannu noolaanno, oo aannan dhiman, dhulkayaguna uusan baabbi'in. ");
INSERT INTO som_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Yuusufna dhulkii Masar oo dhan Fircoon buu u iibiyey, waayo, Masriyiintii nin waluba wuxuu iibiyey beertiisii, maxaa yeelay, abaartaa ku xumayd iyaga; dhulkiina waxaa yeeshay Fircoon. ");
INSERT INTO som_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Dadkiina wuxuu u wareejiyey magaalooyinka dhulka Masar darafkiisa ilaa darafka kale. ");
INSERT INTO som_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Wuxuusan iibsan dhulkii wadaaddada oo keliya, waayo, wadaaddadu qayb bay ku lahaan jireen Fircoon, oo waxay cuni jireen qaybtii Fircoon siin jiray, oo sidaas daraaddeed ma ay iibsan dhulkoodii. ");
INSERT INTO som_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Markaasaa Yuusuf wuxuu dadkii ku yidhi, Bal eega, maantaan Fircoon idiin iibiyey idinka iyo dhulkiinnaba; haddaba abuurkan qaata oo dhulka ku beera. ");
INSERT INTO som_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Markii aad wax soo goosataan, waxaad Fircoon siisaan shan meelood meel, afarta kalena waxay idiin ahaan doonaan abuur aad beerta ku abuurtaan iyo cuntadiinna iyo cuntadii reerihiinna iyo cuntadii dhallaankiinnaba. ");
INSERT INTO som_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Markaasay iyana waxay yidhaahdeen, Adigu noloshayada waad badbaadisay, haddaba, sayidkayagiiyow, naga raalli ahow, oo annana waxaannu Fircoon u noqon doonnaa addoommo. ");
INSERT INTO som_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Yuusufna wuxuu sameeyey qaynuun ku saabsan dhulka Masar in ilaa maantadan la joogo Fircoon lahaado shantii meeloodba meel, Fircoonna wuxuusan yeelan dhulkii wadaaddada oo keliya. ");
INSERT INTO som_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Reer binu Israa'iilna waxay degeen dalka Masar, xagga dhulka Goshen; oo halkaas bay maal ka heleen, wayna bateen, oo aad iyo aad bay u tarmeen. ");
INSERT INTO som_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yacquubna wuxuu dalka Masar ku noolaa toddoba iyo toban sannadood, oo Yacquub cimrigiisu wuxuu ahaa boqol iyo toddoba iyo afartan sannadood. ");
INSERT INTO som_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Wakhtigii Israa'iil dhiman lahaana waa soo dhowaaday, markaasuu wiilkiisii Yuusuf u yeedhay, oo wuxuu ku yidhi, Haddaba haddii aad raalli iga tahay, waan ku baryayaaye, gacantaada bowdadayda hoos geli, oo si raxmad leh oo daacad ah igu la dhaqan. Haddaba waan ku baryayaaye, Masar ha igu aasin, ");
INSERT INTO som_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","laakiinse meydkaygu ha la jiifo awowayaashay; waa inaad Masar iga qaaddaa oo aad igu aastaa meeshii lagu aasay awowayaashay. Markaasuu isna yidhi, Waan yeeli doonaa sidaad igu tidhi. ");
INSERT INTO som_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Markaasuu ku yidhi, Ii dhaaro, isna wuu u dhaartay. Markaasaa Israa'iil sariirta madaxeedii ku foororsaday. ");
INSERT INTO som_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Waxyaalahaas ka dib waxaa Yuusuf lagu yidhi, Bal eeg, aabbahaa waa bukaaye. Markaasuu wuxuu kaxaystay labadiisii wiil oo ahaa Manaseh iyo Efrayim. ");
INSERT INTO som_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Kolkaasaa waxaa Yacquub loo soo sheegay, oo lagu yidhi, Bal eeg, wiilkaagii Yuusuf baa kuu imanaya. Markaasaa Israa'iil intuu xoog isgeliyey ayuu soo dul fadhiistay sariirtiisii. ");
INSERT INTO som_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Markaasaa Yacquub wuxuu Yuusuf ku yidhi, Ilaaha Qaadirka ah ayaa iigu muuqday Luus oo ku taal dalka Kancaan, wuuna i barakeeyey, ");
INSERT INTO som_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","oo wuxuu igu yidhi, Bal eeg waan ku badin doonaa, waanan ku tarmin doonaa, oo waxaan kaa dhigi doonaa dad fara badan; dhulkanna waxaan siin doonaa farcankaaga kaa dambeeya, inuu hanti aan weligeed dhammaanayn u ahaado. ");
INSERT INTO som_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Haddaba labadaadii wiil oo dalka Masar kuugu dhashay, intaanan kuugu iman Masar, anigaa iska leh. Efrayim iyo Manaseh ayaan u lahaan doonaa sida Ruubeen iyo Simecoon. ");
INSERT INTO som_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Carruurta aad iyaga ka dib dhasho, adigaa iska lahaan doona, waana in loo bixiyo magacyada walaalahood markay wax dhaxlaan. ");
INSERT INTO som_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Anigana, markii aan ka imid Fadan ayaa Raaxeel igaga dhimatay dalkii Kancaan waddada loo maro, intaanan weli Efrad soo gaadhin; oo kolkaasaan iyadii ku aasay waddada loo maro Efrad, meeshaasuna waa Beytlaxam. ");
INSERT INTO som_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Markaasaa Israa'iil intuu wiilashii Yuusuf dhugtay ayuu yidhi, Kuwanu waa ayo? ");
INSERT INTO som_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Markaasaa Yuusuf wuxuu aabbihiis ku yidhi, Waa wiilashaydii Ilaah halkan igu siiyey. Markaasuu isna wuxuu ku yidhi, Waan ku baryayaaye, iyaga ii soo dhowee, waanan u ducaynayaa. ");
INSERT INTO som_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Haddaba Israa'iil cimrigiisii dheeraa aawadiis ayuu la indha darnaaday, sidaas daraaddeed waxba ma uu arki karin. Kolkaasuu iyagii u soo dhoweeyey, wuuna isku duubay oo dhunkaday. ");
INSERT INTO som_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Markaasaa Israa'iil wuxuu Yuusuf ku yidhi, Uma aan malaynayn inaan wejigaaga arki doono, oo bal eeg, Ilaah weliba wuxuu i tusay xataa farcankaagii. ");
INSERT INTO som_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Markaasaa Yuusuf wuxuu iyagii ka durkiyey lowyihiisii; oo intuu sujuuday ayuu wejigiisii dhulka saaray. ");
INSERT INTO som_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Markaasuu Yuusuf labadoodiiba kaxeeyey, intuu Efrayim gacantiisii midigta ahayd ku qabtay oo ku toosan Israa'iil bidixdiisa, Manasehna ku qabtay bidixdiisii oo ku toosan midigtii Israa'iil, wuuna u soo dhoweeyey iyagii. ");
INSERT INTO som_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Markaasaa Israa'iil soo fidiyey gacantiisii midigta ahayd, oo wuxuu saaray madaxii Efrayim oo kii yaraa ahaa. Gacantiisii bidixda ahaydna wuxuu saaray Manaseh madaxiisii, wuuna isdhaafiyey gacmihiisii, maxaa yeelay, Manaseh wuxuu ahaa curadkii. ");
INSERT INTO som_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Markaasuu Yuusuf u duceeyey, oo wuxuu yidhi, Ilaaha aabbahay Isxaaq iyo awowgay Ibraahim ay ku hor socdeen, oo ah Ilaaha i quudinayay intii aan noolaa oo dhan ilaa maanta, ");
INSERT INTO som_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","iyo malaa'igtii iga soo samatabbixisay xumaato oo dhan, wiilasha ha barakeeyeen; oo magacayga ha lagu magacaabo iyaga, iyo magicii aabbahay Isxaaq, iyo kii awowgay Ibraahim; oo dad faro badan dhulka ha ku noqdeen. ");
INSERT INTO som_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Oo markii Yuusuf arkay in aabbihiis gacantiisii midigta ahayd Efrayim madaxiisa saaray ayuu taas ka xumaaday; markaasuu gacantii aabbihiis qabtay inuu ka qaado Efrayim madaxiisa oo uu saaro Manaseh madaxiisa. ");
INSERT INTO som_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Oo Yuusufna wuxuu aabbihiis ku yidhi, Aabbahayow, saas ma aha, waayo, kanu waa curadkii ee gacantaada midigta ah madaxiisa saar. ");
INSERT INTO som_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Markaasaa aabbihiis diiday oo wuxuu ku yidhi, Waan ogahay, waan ogahay, wiilkaygiiyow. Isaguna wuxuu noqon doonaa quruun, wuuna weynaan doonaa; habase yeeshee walaalkiisa ka yar baa ka weynaan doona, oo farcankiisu wuxuu noqon doonaa quruumo faro badan. ");
INSERT INTO som_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Oo maalintaasuu u duceeyey iyagii, oo wuxuu yidhi, Reer binu Israa'iil idinkay idinku ducaysan doonaan, iyagoo leh, Ilaah ha kaa dhigo sidii Efrayim iyo sidii Manaseh. Oo Efrayimna wuxuu ka hor mariyey Manaseh. ");
INSERT INTO som_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Oo Israa'iilna wuxuu Yuusuf ku yidhi, Anigu waan dhimanayaa, laakiinse Ilaah baa kula jiri doona, oo mar labaadna wuxuu ku geeyn doonaa dhulkii awowayaashaa. ");
INSERT INTO som_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Oo weliba waxaan ku siiyey qayb dheeraad ah, oo aad walaalahaa dheer tahay, waana tii aan reer Amor kaga qaatay seeftayda iyo qaansadayda. ");
INSERT INTO som_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Markaasuu Yacquub wiilashiisii u yeedhay; oo wuxuu ku yidhi, Isa soo urursada, aan idiin sheego waxyaalaha maalmaha ugu dambeeya idinku dhici doona. ");
INSERT INTO som_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Wiilashii Yacquubow, isa soo urursada, oo maqla, Oo i dhegaysta anigoo ah aabbihiin Israa'iil. ");
INSERT INTO som_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruubeenow, waxaad tahay curadkayga, iyo xooggayga, iyo itaalkayga bilowgiisa, Xagga sharafka adaa u sarreeya, xagga xooggana adaa u sarreeya. ");
INSERT INTO som_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Waxaad tahay sida biyo socda, oo ma sarrayn doontid, Maxaa yeelay, adigu waxaad fuushay sariirtii aabbahaa; Waanad nijaasaysay. Wuxuu fuulay sariirtaydii. ");
INSERT INTO som_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simecoon iyo Laawi waa walaalo, Seefahoodu waa hub dirireed. ");
INSERT INTO som_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Naftaydiiyey, ha gelin guddigooda, Oo ururkoodana ha la midoobin, ammaantaydiiyey; Waayo, cadhadoodii nin bay ku dileen, Oo qushigooday dibi ku boqno jareen. ");
INSERT INTO som_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Habaar ha ku dhaco cadhadooda, waayo, xoog bay lahayd, Habaar ha ku dhaco ciilkooda, waayo, naxariis ma uu lahayn. Reer Yacquub baan ku kala qaybin, oo reer binu Israa'iil baan ku kala firdhin. ");
INSERT INTO som_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yahuudahow, walaalahaa waa ku ammaani doonaan. Gacantaadu waxay saarnaan doontaa cadaawayaashaada qoortooda, Anigoo ah aabbahaana wiilashaydu way kuu sujuudi doonaan, ");
INSERT INTO som_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yahuudah waa libaax dhashiis. Wiilkaygiiyow, wixii aad ugaadhsatay waad ka tagtay. Wuu kadaloobsaday, oo wuxuu u jiifsaday sida aar, Iyo sida gool, haddaba yaa kicin doona? ");
INSERT INTO som_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Usha boqortooyadu kama tegi doonto Yahuudah, Usha taliyuhuna cagihiisa kama dhex bixi doonto; Ilaa Shiiloh yimaado; Dadkuna isagay addeeci doonaan. ");
INSERT INTO som_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Qaylkiisa wuxuu ku xidhaa geed canab ah, Dameerkiisa yarna canabka la doorto, Dharkiisa wuxuu ku maydhaa khamri, Lebiskiisana dhiig canab. ");
INSERT INTO som_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Indhihiisu waxay la guduudan doonaan khamri, Ilkihiisuna waxay la caddaan doonaan caano. ");
INSERT INTO som_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sebulun wuxuu degganaan doonaa badda xeebteeda. Wuxuuna noqon doonaa marsada doonniyaha, Xuduudkiisuna wuxuu ahaan doonaa Siidoon agteeda. ");
INSERT INTO som_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isaakaar waa dameer xoog weyn, Oo jiifsada xeryaha idaha dhexdooda. ");
INSERT INTO som_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Oo wuxuu arkay meel lagu nasto inay wanaagsan tahay, Iyo dhulku inuu nimcaysan yahay; Kolkaasuu garbihiisa u soo goday inuu wax ku qaado, Oo addoon buu u noqday hawshii. ");
INSERT INTO som_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Daanna wuxuu dadkiisa u xukumi doonaa Sidii qabiilooyinka Israa'iil middood. ");
INSERT INTO som_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Daan wuxuu noqon doonaa abeeso jidka dhex joogta, Iyo jilbis waddada dhex yaal, Oo fardaha cedhbaha ka qaniina, Si uu kii faraska ku joogaana dib ugu dhaco. ");
INSERT INTO som_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Rabbiyow, waxaan sugayay badbaadintaada. ");
INSERT INTO som_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Waxaa Gaad cidhiidhi gelin doonta guuto wax dhacda; Laakiinse isna cedhibtooduu cidhiidhi gelin doonaa. ");
INSERT INTO som_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Aasheerna cuntadiisu subag bay lahaan doontaa, Wuxuuna keeni doonaa cunto ay reer boqor ku farxaan. ");
INSERT INTO som_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naftaali waa cawl la furay, Hadallo wanwanaagsanna wuu ku hadlaa. ");
INSERT INTO som_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yuusuf waa laan midho leh, Waa laan midho leh oo il biyo ah ku ag taal; Laamihiisuna derbigay kor u dhaafaan. ");
INSERT INTO som_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Qaansolayaasha ayaa aad u dhibay, Wayna toogteen oo silciyeen; ");
INSERT INTO som_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Laakiinse qaansadiisu xoog bay sii yeelatay, Dhudhummadii gacmihiisana waxaa lagu xoogeeyey Gacmaha Kan xoogga leh oo Yacquub, (Kaasuu adhijirku ka imanayaa, waana dhagaxii Israa'iil) ");
INSERT INTO som_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Oo ah Ilaaha aabbahaa oo ku caawimi doona, Iyo Ilaaha Qaadirka ah, oo kugu barakayn doona Barakooyinka samada sare, Iyo barakooyinka moolka hoos jiifa, Iyo barakooyinka naasaha iyo maxalka. ");
INSERT INTO som_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Barakooyinkii aabbahaa Way ka xoog badnaadeen barakooyinkii awowayaashay Ilaa meesha ugu fog oo buuraha weligood waara; Waxay saarnaan doonaan madaxa Yuusuf, Iyo dhakada kan walaalihiis laga soocay. ");
INSERT INTO som_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benyaamiin waa yeey hilib dillaacsada; Oo aroorta wuxuu cuni doonaa wixii uu ugaadhsaday, Fiidkana wuxuu qaybin doonaa wixii uu dhacay. ");
INSERT INTO som_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Kuwan oo dhammu waa laba iyo tobankii qabiil oo reer binu Israa'iil; tanuna waa wixii aabbahood kula hadlay oo ugu duceeyey; mid walbana sidii ducadiisu ahayd buu ugu duceeyey. ");
INSERT INTO som_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Oo wuxuu kula dardaarmay, oo ku yidhi iyagii, Waxaan ku darman doonaa dadkaygii. Awowayaashay igula aasa godka ku yaal berrinka Cefroon kii reer Xeed, ");
INSERT INTO som_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","kaasoo ah godka ku yaal berrinkii Makfelah, oo ku hor yaal Mamre, oo dalka Kancaan ku taal, oo uu Ibraahim Cefroon kii reer Xeed ka iibsaday, godka iyo berrinkaba, inuu ka dhigto meel xabaaleed oo hanti ah. ");
INSERT INTO som_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Halkaasaa lagu aasay Ibraahim iyo afadiisii Saarahba, halkaasaa lagu aasay Isxaaq iyo afadiisii Rebeqahba, oo anna Lee'ah baan ku aasay halkaas ");
INSERT INTO som_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","oo ah berrinka iyo godka ku dhex yaalba, oo laga iibsaday reer Xeed. ");
INSERT INTO som_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Oo markii Yacquub dhammeeyey dardaarankii uu wiilashiisii kula dardaarmayay ayuu cagihiisii ku soo urursaday sariirta, oo markaasuu naf baxay, oo wuxuu ku darmaday dadkiisii. ");
INSERT INTO som_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Markaasaa Yuusuf ku dhacay wejigii aabbihiis, wuuna ooyay oo dhunkaday. ");
INSERT INTO som_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Kolkaasaa Yuusuf wuxuu addoommadiisii dhakhtarrada ahaa ku amray inay aabbihiis meydkiisa dawo mariyaan, markaasay dhakhtarradii Israa'iil dawo mariyeen. ");
INSERT INTO som_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Oo waxaa u dhammaaday afartan maalmood, waayo, sidaasay maalmaha dawomarintu ugu dhammaan jireen. Masriyiintiina waxay isaga u ooyayeen toddobaatan maalmood. ");
INSERT INTO som_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Oo markii maalmihii loo ooyayay isaga ay dhammaadeen ayaa Yuusuf la hadlay reerkii Fircoon oo wuxuu ku yidhi, Waan idin baryayaaye haddaad haatan raalli iga tihiin, Fircoon iila hadla oo waxaad ku tidhaahdaan, ");
INSERT INTO som_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Aabbahay baa i dhaariyey, oo wuxuu igu yidhi, Bal eeg, waan dhimanayaa ee waxaad igu aastaa qabrigaygii aan ka qotay dalka Kancaan. Haddaba waan ku baryayaaye, ii fasax inaan tago oo aan aabbahay soo aaso, oo haddana waan soo noqon doonaa. ");
INSERT INTO som_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Markaasaa Fircoon ku yidhi, Tag oo aabbahaa u soo aas siduu kugu dhaariyey. ");
INSERT INTO som_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Markaasaa Yuusuf tegey inuu aabbihiis soo aaso; oo waxaana isagii raacay addoommadii Fircoon oo dhan, iyo odayaashii reerkiisa, iyo odayaashii dalka Masar oo dhan, ");
INSERT INTO som_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","iyo reerkii Yuusuf oo dhan, iyo walaalihiis, iyo reerkii aabbihiis. Waxaa keliyahoo ay dalkii Goshen kaga tageen dhallaankoodii, iyo adhigoodii, iyo lo'doodii. ");
INSERT INTO som_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Waxaana isagii raacay gaadhifardoodyo, iyo fardooley; oo waxay ahaayeen guuto aad u weyn. ");
INSERT INTO som_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Markaasay waxay yimaadeen goobtii hadhuudhka lagu tumi jiray oo Aataad, oo Webi Urdun ka shishaysay, oo halkaasay ku baroorteen baroor aad u weyn oo daran; oo aabbihiis buu toddoba maalmood oo loo baroortay u dhigay. ");
INSERT INTO som_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Oo markii dadkii reer Kancaan oo dalka degganaa ay arkeen baroortii ka dhacday goobtii Aataad ayay waxay yidhaahdeen, Tanu waa baroor ku xun Masriyiinta. Oo sidaas daraaddeed waxaa magaceedii loo bixiyey Aabeel Masriyiin, oo waxay ka shishaysaa Webi Urdun. ");
INSERT INTO som_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Wiilashiisiina way u yeeleen wixii uu kula dardaarmay iyaga, ");
INSERT INTO som_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","maxaa yeelay, wiilashiisii waxay isagii u qaadeen dalkii Kancaan, oo waxay ku aaseen godkii ku dhex yiil berrinkii Makfelah, oo Ibraahim u iibsaday isaga iyo berrinkaba inuu ka dhigto meel xabaaleed oo hanti ah, wuxuuna ka iibsaday Cefroon kii reer Xeed, oo wuxuu ku hor yaal Mamre. ");
INSERT INTO som_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yuusufna markuu aabbihiis aasay ka dib, wuxuu ku noqday Masar, isagii iyo walaalihiis, iyo kulli intii isaga u raacday oo dhan inay aabbihiis la soo aasaan. ");
INSERT INTO som_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Oo markay Yuusuf walaalihiis arkeen in aabbahood dhintay ayay isku yidhaahdeen, Mindhaa Yuusuf waa ina nebcaan doonaa oo wuu inaga magan doonaa xumaantii aynu ku samaynay oo dhan. ");
INSERT INTO som_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Oo markaasay farriin u fareen Yuusuf, oo waxay ku yidhaahdeen, Aabbahaa intuusan dhiman ayuu dardaarmay oo wuxuu yidhi, ");
INSERT INTO som_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Waxaad Yuusuf ku tidhaahdaan, Haatan waan ku baryayaaye, cafi walaalahaa xadgudubkooda, iyo dembigooda, maxaa yeelay, iyagu xumaan bay kugu sameeyeen. Haddaba waannu ku baryaynaaye, Annagoo ah addoommada Ilaaha aabbahaa, naga cafi xadgududkayaga. Yuusufuna wuu ooyay markay la hadleen. ");
INSERT INTO som_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Walaalihiisna way u dhowaadeen oo ku hor dhaceen; oo waxay yidhaahdeen, Bal eeg, waxaannu nahay addoommadaada. ");
INSERT INTO som_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Markaasaa Yuusuf wuxuu iyagii ku yidhi, Ha cabsanina, waayo, ma anaa Ilaah meeshiisii jooga? ");
INSERT INTO som_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Idinku xumaan baad ila damacsanaydeen, laakiinse Ilaah wuxuu damacsanaa wanaag si uu u sameeyo siday maantaba tahay oo uu dad badan badbaadiyo. ");
INSERT INTO som_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Haddaba ha cabsanina. Anigu waan idin quudin doonaa idinka iyo dhallaankiinnaba. Wuuna qalbi qaboojiyey oo si raxmad leh ula hadlay. ");
INSERT INTO som_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Oo Yuusufna dalkii Masar buu degganaa, isaga iyo reerkii aabbihiisba; oo wuxuu Yuusuf noolaa boqol iyo toban sannadood. ");
INSERT INTO som_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Yuusufna qarnigii saddexaad oo carruurtii Efrayim ayuu arkay; oo carruurtii Maakiir ina Manasehna waxay ku kor dhasheen Yuusuf lowyihiisii. ");
INSERT INTO som_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Oo Yuusuf wuxuu walaalihiis ku yidhi, Anigu waan dhimanayaa, laakiinse hubaal Ilaah waa idin soo booqan doonaa, oo dalkan idinka kaxayn doonaa, oo wuxuu idin geeyn doonaa dalkii uu ugu dhaartay Ibraahim iyo Isxaaq iyo Yacquub. ");
INSERT INTO som_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Yuusuf wuxuu dhaariyey reer binu Israa'iil, oo ku yidhi, Hubaal Ilaah waa idin soo booqan doonaaye, idinkuna waa inaad lafahayga halkan ka qaaddaan. ");
INSERT INTO som_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Yuusufna wuxuu dhintay isagoo boqol iyo toban sannadood jira; markaasaa inta dawo meydkiisii la mariyey, waxaa lagu riday sanduuq dalka Masar.");
INSERT INTO som_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Haddaba waa kuwan magacyadii wiilashii Israa'iil, oo Masar yimid; nin walba iyo reerkiisiiba waxay la yimaadeen Yacquub. ");
INSERT INTO som_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruubeen, Simecoon, Laawi iyo Yahuudah, ");
INSERT INTO som_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isaakaar, Sebulun, iyo Benyaamiin, ");
INSERT INTO som_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Daan iyo Naftaali, iyo Gaad iyo Aasheer. ");
INSERT INTO som_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Oo dadkii ka soo go'ay xanjaadkii Yacquub oo dhammu waxay ahaayeen toddobaatan qof; Yuusufna Masar buu markii hore joogay. ");
INSERT INTO som_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Yuusufna, iyo walaalihiis, iyo farcankaas oo dhanba way wada dhinteen. ");
INSERT INTO som_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Oo reer binu Israa'iilna waa bateen, oo aad bay u kordheen, wayna tarmeen, oo aad iyo aad u xoogaysteen; dhulkiina way buuxiyeen. ");
INSERT INTO som_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Haddaba Masar waxaa ka kacay boqor cusub oo aan Yuusuf aqoonin. ");
INSERT INTO som_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Markaasuu wuxuu dadkiisii ku yidhi, Bal eega, dadkii reer binu Israa'iil waa inaga badan yihiin, wayna inaga xoog weyn yihiin. ");
INSERT INTO som_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Kaalaya, aynu si caqli ah ula macaamiloonnee; waaba intaasoo ay tarmaan, oo ay markuu dagaal dhaco cadaawayaasheenna inoogu darmadaan, oo intay inala diriraan ay dalka ka baxaane. ");
INSERT INTO som_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Haddaba sidaas daraaddeed ayay niman madax uga dhigeen si ay culaabtooda ugu dhibaan, oo waxay Fircoon u dhiseen magaalooyin wax lagu kaydiyo oo la yidhaahdo Fitom iyo Racmeses. ");
INSERT INTO som_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Laakiinse in kastoo ay aad u dhibeen, haddana aad bay u sii tarmeen, oo aad bay u faafeen. Oo reer binu Israa'iil aawadood ayay la murugaysnaayeen. ");
INSERT INTO som_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Oo Masriyiintiina waxay reer binu Israa'iil ku qasbeen inay qaxar ku adeegaan, ");
INSERT INTO som_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","oo waxay naftoodii ku dhibeen hawl aad u adag, oo ahayd dhoobo la qaso, iyo leben, iyo hawl kasta oo beeraha laga qabto, oo hawl kastoo ay ku qasbeen inay qabtaanba way ku qaxri jireen. ");
INSERT INTO som_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Markaasaa boqorkii Masar wuxuu la hadlay umulisooyinkii Cibraaniyadaha ahaa, oo middood magaceeda Shifraah la odhan jiray, tan kale magaceedana Fuwah la odhan jiray, ");
INSERT INTO som_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","oo wuxuu ku yidhi, Markii aad umulinaysaan naagaha Cibraaniyadaha, oo aad aragtaan iyagoo gambarka umusha fadhiya, haddii uu wiil yahay, waa inaad dishaan, haddayse gabadh tahay, ha iska noolaato. ");
INSERT INTO som_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Laakiinse umulisooyinkii Ilaah bay ka cabsadeen, mana ay samayn wixii boqorkii Masar ku amray, ee way badbaadiyeen carruurtii labka ahayd. ");
INSERT INTO som_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Markaasaa boqorkii Masar u yeedhay umulisooyinkii, oo wuxuu ku yidhi, Maxaad waxan u samayseen, oo aad u badbaadiseen carruurtii labka ahayd? ");
INSERT INTO som_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Markaasaa umulisooyinkii waxay Fircoon ku yidhaahdeen, Maxaa yeelay, naagaha Cibraaniyaduhu la mid ma aha naagaha Masriga, oo waa ka dhaqso badan yihiin, oo intii aan umulisooyinku u iman bay umulaan. ");
INSERT INTO som_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Haddaba Ilaah si wanaagsan buu u sameeyey umulisooyinkii, dadkiina waa tarmay, oo aad bay u xoogaysteen. ");
INSERT INTO som_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Oo waxay noqotay, in Ilaah umulisooyinkii reero u yeelay, maxaa yeelay, Ilaah bay ka cabsadeen. ");
INSERT INTO som_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Markaasaa Fircoon wuxuu dadkiisii ku amray, oo ku yidhi, Wiil kasta oo dhasha waa inaad webiga ku tuurtaan, laakiinse gabadh kasta waa inaad badbaadisaan. ");
INSERT INTO som_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Markaasaa waxaa tegey nin reer Laawi ah, oo wuxuu guursaday gabadh reer Laawi iyana ah. ");
INSERT INTO som_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Markaasay naagtii uuraysatay oo waxay dhashay wiil; oo markay aragtay inuu ilmo wanaagsan yahay, ayay qarisay in saddex bilood ah. ");
INSERT INTO som_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Oo markay in dambe qarin kari weyday, ayay waxay soo qaadday abxad caws duur ah, oo intay dhoobo iyo daamur ku malaastay ayay wiilkii ku ridday, oo waxay dhex gelisay duur webiga qarkiisa ka baxay. ");
INSERT INTO som_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Walaashiisna waxay taagnayd meel ka fog, inay ogaato waxa isaga lagu samayn doono. ");
INSERT INTO som_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Markaasaa gabadhii Fircoon webiga timid inay ku maydhato. Gabdhihii addoommada u ahaana waxay socdeen webigii dhinaciisa. Markaasay iyadu waxay aragtay abxadda duurka ku dhex jirta, oo waxay u diratay gabadhii addoonta u ahayd inay u keento. ");
INSERT INTO som_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Markaasay furtay, oo waxay aragtay wiilkii; oo bal eeg, yarkii waa ooyay. Kolkaasay u naxariisatay, oo waxay tidhi, Kanu waa carruurtii Cibraaniyada midkood. ");
INSERT INTO som_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Markaasaa walaashiis waxay gabadhii Fircoon ku tidhi, Ma kuugu yeedhaa naagaha Cibraaniyadaha middood inay kuu nuujiso ilmaha? ");
INSERT INTO som_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Gabadhii Fircoonna waxay ku tidhi iyadii, Haah, tag. Gabadhiina way tagtay oo waxay u yeedhay yarkii hooyadiis. ");
INSERT INTO som_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Markaasaa gabadhii Fircoon waxay ku tidhi iyadii, Tag, oo ilmahan qaad oo ii nuuji, oo anna waxaan ku siin doonaa mushahaaradaada. Markaasay naagtii yarkii qaadday oo nuujisay. ");
INSERT INTO som_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Yarkiina waa koray, markaasay u keentay gabadhii Fircoon, oo wuxuu noqday wiilkeedii. Oo waxay magiciisii u bixisay Muuse, oo waxay tidhi, Maxaa yeelay, anaa biyihii ka soo bixiyey. ");
INSERT INTO som_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Oo waayahaas, markii Muuse weynaaday, waxay noqotay inuu walaalihiis u soo baxay, oo uu fiiriyey culaabta saaran. Markaasuu wuxuu arkay mid Masri ah oo dilaya mid Cibraani ah oo walaalihiis ka mid ah. ");
INSERT INTO som_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Markaasuu iska fiiriyey xagga iyo xagga, oo markuu arkay inaan ciduna joogin ayuu Masrigii kaw kaga siiyey, oo ciidda ku qariyey. ");
INSERT INTO som_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Markaasuu haddana maalintii labaad soo baxay, oo wuxuu arkay laba nin oo Cibraaniyo ah oo isla diriraya; oo kii gardarnaa buu wuxuu ku yidhi, War maxaad u dilaysaa wadaygaa? ");
INSERT INTO som_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Markaasuu wuxuu yidhi, Bal yaa amiir iyo xaakin nooga kaa dhigay? Ma waxaad doonaysaa inaad ii disho sidaad u dishay Masriga? Markaasaa Muuse cabsaday, oo wuxuu isyidhi, Hubaal wixii waa la ogaaday. ");
INSERT INTO som_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Haddaba markii Fircoon waxaas maqlay, ayuu wuxuu doondoonay inuu Muuse nafta ka qaado. Laakiinse Muuse waa ka cararay Fircoon hortiisii, oo wuxuu degay dalka Midyaan, oo ceel buu ag fadhiistay. ");
INSERT INTO som_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Haddaba wadaadkii Midyaan wuxuu lahaa toddoba gabdhood. Intay ceelkii yimaadeen ayay dhaamiyeen oo berkedihii biyo ka buuxiyeen inay waraabiyaan idihii aabbahood. ");
INSERT INTO som_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Markaasaa adhijirro yimaadeen oo ka eryeen, laakiinse Muuse intuu istaagay, ayuu caawiyey iyagii, oo idahoodii u waraabiyey. ");
INSERT INTO som_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Oo markay u yimaadeen Recuu'eel oo aabbahood ah ayuu wuxuu ku yidhi, Waa sidee, maanta waad soo dhaqsateene? ");
INSERT INTO som_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Markaasay waxay yidhaahdeen, Midkoo Masri ah ayaa naga samatabbixiyey gacantii adhijirrada, oo weliba biyuu noo dhaamiyey oo idaha isagaa noo waraabiyey. ");
INSERT INTO som_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Markaasuu wuxuu gabdhihiisii ku yidhi, Isagii meeyey? De maxaad ninkii uga soo kacdeen? U yeedha, kibis ha cunee. ");
INSERT INTO som_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Muusena raalli buu ka ahaa inuu ninkaas la joogo, oo isagu wuxuu Muuse siiyey gabadhiisii Siforaah. ");
INSERT INTO som_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Oo waxay u dhashay wiil, markaasuu magiciisii wuxuu u bixiyey Gershoom, waayo, wuxuu yidhi, Qariib baan ku ahaa dal qalaad. ");
INSERT INTO som_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Oo waxay noqotay in waayahaas badan dabadeed uu boqorkii Masar iska dhintay, reer binu Israa'iilna addoonnimada aawadeed ayay ula taaheen, oo way ooyeen, oo oohintoodiina waxay gaadhay Ilaah addoonnimada aawadeed. ");
INSERT INTO som_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Ilaahna waa maqlay cabaadkoodii, markaasaa Ilaah xusuustay axdigiisii uu la dhigtay Ibraahim, iyo Isxaaq, iyo Yacquub. ");
INSERT INTO som_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Markaasaa Ilaah arkay reer binu Israa'iil, Ilaahna wuu ogaaday xaalkoodii. ");
INSERT INTO som_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Muuse wuxuu ilaalinayay adhigii soddoggiis Yetroo oo ahaa wadaadkii Midyaan, oo wuxuu adhigii u soo kexeeyey meeshii cidlada ahayd shishadeeda, markaasuu wuxuu yimid buurtii Ilaah oo ahayd Xoreeb. ");
INSERT INTO som_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Markaasaa malaa'igtii Rabbigu waxay uga muuqatay dab ololaya oo ka baxaya geed dhexdiis, kolkaasuu fiiriyey oo wuxuu arkay geedkii oo ololaya oo dabku gubayo, geedkuna ma basayn. ");
INSERT INTO som_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Markaasaa Muuse wuxuu yidhi, Anigu waan ku leexan doonaa, waanan arki doonaa muuqashadan weyn, iyo waxa geedku u guban waayay. ");
INSERT INTO som_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Oo markuu Rabbigu arkay inuu ku soo leexday inuu arko ayaa Ilaah uga yeedhay geedka dhexdiisii, oo wuxuu ku yidhi, Muusow, Muusow. Markaasuu yidhi, Waa i kan. ");
INSERT INTO som_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Markaasuu wuxuu ku yidhi, Halkan ha u soo dhowaan, kabahana iska siib, waayo, meesha aad taagan tahay waa dhul quduus ah. ");
INSERT INTO som_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Oo weliba wuxuu kaloo ku yidhi, Anigu waxaan ahay Ilaahii aabbahaa oo ah Ilaahii Ibraahim, iyo Ilaahii Isxaaq, iyo Ilaahii Yacquub. Markaasaa Muuse wejigiisii qariyey, waayo, wuxuu ka cabsaday inuu Ilaah eego. ");
INSERT INTO som_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Rabbiguna wuxuu ku yidhi, Hubaal waxaan arkay dhibaatada dadkayga ku haysata Masar, oo waan maqlay oohintii ay ooyeen kuwa hawsha ku qaxraya aawadood, waayo, anigu waan ogahay caloolxumadooda; ");
INSERT INTO som_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","oo waxaan u imid inaan ka samatabbixiyo gacanta Masriyiinta, iyo inaan ka soo bixiyo dhulkaas, oo keeno dhul wanaagsan oo ballaadhan, oo ah dal caano iyo malab la barwaaqaysan; waana meesha ay deggan yihiin reer Kancaan, iyo reer Xeed, iyo reer Amor, iyo reer Feris, iyo reer Xiwi, iyo reer Yebuus. ");
INSERT INTO som_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Oo haatan bal eeg, waxaa i hor timid oohintii reer binu Israa'iil, oo weliba waxaan arkay cadaadinta ay Masriyiintu ku cadaadinayaan iyaga. ");
INSERT INTO som_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Haddaba kaalay, oo waxaan kuu dirayaa Fircoon, inaad dalka Masar ka soo kaxaysid dadkayga reer binu Israa'iil ah. ");
INSERT INTO som_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Markaasaa Muuse wuxuu Ilaah ku yidhi, Bal yaan ahay anigu, markaan Fircoon u tegayo, oo aan reer binu Israa'iil ka soo bixinayo dalka Masar? ");
INSERT INTO som_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Markaasuu wuxuu ku yidhi, Xaqiiqa anigaa kula jiraya, oo taasaa calaamo kuu noqonaysa, inaan anigu ku soo diray; markii aad dadka ka soo bixiso Masar, Ilaah baad buurtan ugu adeegi doontaan. ");
INSERT INTO som_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Markaasaa Muuse wuxuu Ilaah ku yidhi, Bal eeg, markii aan u tago reer binu Israa'iil, oo aan ku idhaahdo iyaga, Ilaahii awowayaashiin baa ii soo kiin diray, oo iyaga waxay igu odhan doonaan, De magiciisa maxaa la yidhaahdaa? Haddaba maxaan ku odhan doonaa? ");
INSERT INTO som_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Markaasaa Ilaah wuxuu Muuse ku yidhi, ANIGU WAXAAN AHAY KAAN AHAY; oo weliba wuxuu ku yidhi, Waxaad ku odhan doontaa reer binu Israa'iil, WAAN AHAY baa ii soo kiin diray. ");
INSERT INTO som_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Oo Ilaah weliba wuxuu kaloo Muuse ku yidhi, Waxaad ku tidhaahdaa reer binu Israa'iil, Rabbiga ah Ilaahii awowayaashiin, oo ah Ilaahii Ibraahim, iyo Ilaahii Isxaaq, iyo Ilaahii Yacquub ayaa ii soo kiin diray; kanu waa magacayga weligay, oo laygu xusuusto ka ab ka ab. ");
INSERT INTO som_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Bal tag, oo isu soo ururi waayeellada reer binu Israa'iil, oo waxaad ku tidhaahdaa, Rabbiga ah Ilaahii awowayaashiin, oo ah Ilaahii Ibraahim, iyo Ilaahii Isxaaq, iyo Ilaahii Yacquub ayaa ii muuqday, isagoo leh, Hubaal waan idin soo booqday, oo waan arkay waxa laydinku sameeyey Masar dhexdeeda, ");
INSERT INTO som_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","oo waxaan idhi, Anigu waan idinka soo wadi doonaa dhibaatada Masar, oo waxaan idin keeni doonaa dalka reer Kancaan, iyo reer Xeed, iyo reer Amor, iyo reer Feris, iyo reer Xiwi, iyo reer Yebuus, oo ah dal caano iyo malab la barwaaqaysan. ");
INSERT INTO som_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Oo codkaaga way maqli doonaan, markaas adiga iyo waayeellada reer binu Israa'iil waa inaad u tagtaan boqorka Masar, oo waxaad ku tidhaahdaan, Rabbiga ah Ilaaha Cibraaniyada ayaa nala kulmay. Haddaba waan ku baryaynaaye, Iska kaaya daa aannu meel saddex maalmood loo socdo oo cidla ah tagnee, inaannu allabari u bixinno Rabbiga ah Ilaahayo. ");
INSERT INTO som_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Oo anna waxaan ogahay inaanu boqorka Masar idiin sii daynayn inaad tagtaan, maya, ee wuxuuna idiinku diidayaa gacan xoog leh. ");
INSERT INTO som_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Markaasaan gacantayda soo kala bixin doonaa, oo waxaan Masar ku layn doonaa cajaa'ibyadayda oo dhan oo aan ku dhex samayn doono iyada, oo markaas dabadeed wuu idin sii dayn doonaa inaad iska tagtaan. ");
INSERT INTO som_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Oo anigu dadkan raalli baan uga yeeli doonaa Masriyiinta; oo waxay noqon doontaa in markii aad tagtaan aydnaan faromadhnaan ku tegin, ");
INSERT INTO som_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","laakiinse naag waluba ha weyddiisato deriskeeda iyo tan guriga la joogta alaab lacag ah iyo alaab dahab ah, iyo dhar; waxaadna saari doontaan wiilashiinna iyo gabdhihiinna, oo waxaad dhici doontaan Masriyiinta. ");
INSERT INTO som_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Markaasaa Muuse jawaabay oo wuxuu yidhi, Laakiinse, bal ogow, ima ay rumaysan doonaan, codkaygana ma ay dhegaysan doonaan, waayo, waxay igu odhan doonaan, Rabbigu kuuma uu muuqanin. ");
INSERT INTO som_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Markaasaa Rabbigu wuxuu ku yidhi, Waa maxay waxaas gacantaada ku jiraa? Oo wuxuu yidhi, Waa ul. ");
INSERT INTO som_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Markaasuu ku yidhi, Bal dhulka ku tuur. Markaasuu dhulka ku tuuray, oo waxay noqotay abeeso. Kolkaasaa Muuse ka hor cararay. ");
INSERT INTO som_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Markaasaa Rabbigu wuxuu Muuse ku yidhi, Bal gacanta soo fidi oo dabada ku dheg, kolkaasuu gacantii soo fidiyey oo dabada ku dhegay, kolkaasay noqotay ul gacantiisa ku jirta. ");
INSERT INTO som_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Sidaas yeel inay ku rumaystaan inuu kuu muuqday Rabbiga ah Ilaahii awowayaashood, oo ah Ilaahii Ibraahim, iyo Ilaahii Isxaaq, iyo Ilaahii Yacquub. ");
INSERT INTO som_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Oo Rabbigu wuxuu kaloo ku sii yidhi isagii, Bal gacanta laabta saar, markaasuu gacanta laabta saaray, oo markii uu ka qaaday, bal eeg, gacantii baras bay yeelatay oo waxay u caddaatay sida baraf cad. ");
INSERT INTO som_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Markaasuu ku yidhi, Bal gacanta laabta mar kale saar. Kolkaasuu mar kale gacantii laabta saaray, oo markii uu ka qaaday laabtii, bal eeg, waxay haddana u rogmatay oo u ekaatay sida jidhkiisii kale. ");
INSERT INTO som_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Oo waxay noqon doontaa, hadday kugu rumaysan waayaan oo ay calaamada hore codkeeda maqli waayaan, de markaas calaamada dambe codkeeday rumaysan doonaan. ");
INSERT INTO som_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Oo haddana waxay noqon doontaa, hadday rumaysan waayaan labadan calaamo, oo weliba ay codkaaga maqli waayaan, de markaas bal waa inaad webiga biyo ka qaaddid oo aad dhulka engegan ku shubtid, oo biyihii aad webiga ka qaadday, markay gaadhaan dhulka engegan dhiig bay noqon doonaan. ");
INSERT INTO som_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Markaasaa Muuse wuxuu Rabbiga ku yidhi, Rabbiyow, anigu codkar ma ahi, hadda iyo hore toona, iyo tan iyo markaad ila hadashay anigoo addoonkaaga ah, maxaa yeelay, anigu hadalka waan shigaa, waanan carrab la'ahay. ");
INSERT INTO som_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Markaasaa Rabbigu wuxuu ku yidhi, Kan dadka afkiisa sameeyey waa ayo? Yaase dadka carrab tira, ama dhego tira, ama wax tusa, ama indho tira? Sow anigan Rabbiga ah ma aha? ");
INSERT INTO som_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Haddaba sidaas daraaddeed tag, oo anigaa afkaaga la jiri doona oo ku bari doona wixii aad ku hadli lahayd. ");
INSERT INTO som_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Isna wuxuu yidhi, Rabbiyow, Waan ku baryayaaye, dir kaad doonaysid inaad dirtid. ");
INSERT INTO som_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Markaasaa Rabbigu u cadhooday Muuse, oo wuxuu ku yidhi, Sow ma joogo walaalkaa Haaruun oo ah reer Laawi? Waan ogahay inuu isagu si wanaagsan u hadli karo. Oo bal ogow, wuu u soo socdaa inuu kula kulmo, oo markuu ku arko, qalbigiisuu ka farxi doonaa. ");
INSERT INTO som_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Haddaba waa inaad isaga la hadashaa, oo aad erayada afkiisa ku riddaa, oo anigu afkaagaan la jiri doonaa, iyo afkiisaba, oo waxaan idin barayaa wixii aad samayn lahaydeen. ");
INSERT INTO som_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Oo isagu wuxuu kuu noqon doonaa ninka dadka kuula hadla, oo waxay noqon doontaa inuu isagu af kuu noqdo, adna waxaad isaga u noqon doontaa Ilaah oo kale. ");
INSERT INTO som_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Haddaba waa inaad gacanta ku qaadatid ushan aad cajaa'ibyada ku samayn doontid. ");
INSERT INTO som_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Markaasaa Muuse tegey oo wuxuu ku noqday soddoggiis Yetroo, oo wuxuu ku yidhi, Waan ku baryayaaye, Bal i sii daa aan tagee, oo ku noqdo walaalahayga Masar jooga, oo aan soo arkee bal inay nool yihiin iyo in kale. Markaasaa Yetroo wuxuu Muuse ku yidhi, Nabad ku tag. ");
INSERT INTO som_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Markaasaa Rabbigu wuxuu ku yidhi Muuse, isagoo Midyaan jooga, Tag, oo Masar ku noqo, waayo, dadkii doondoonayay inay nafta kaa qaadaan way wada dhinteen. ");
INSERT INTO som_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Markaasaa Muuse wuxuu watay naagtiisii iyo wiilashiisii, oo wuxuu saartay dameer, wuxuuna ku noqday dalkii Masar. Markaasaa Muuse ushii Ilaah gacanta ku qaatay. ");
INSERT INTO som_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Rabbiguna wuxuu Muuse ku yidhi, Markii aad Masar ku noqotid, cajaa'ibyadii aan gacantaada ku riday oo dhan Fircoon hortiisa ku samee, laakiinse anigu qalbigiisaan qallafin doonaa, oo dadka ma uu sii dayn doono inay tagaan. ");
INSERT INTO som_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Oo waxaad Fircoon ku tidhaahdaa, Rabbigu wuxuu yidhi, Israa'iil waa wiilkayga curadka ah, ");
INSERT INTO som_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","oo waxaan adiga kugu idhi, Wiilkayga sii daa, ha tagee oo ha ii adeegee. Adiguse waad u diiday inuu tago. Bal hadda ogow, waxaan dili doonaa wiilkaaga curadka ah. ");
INSERT INTO som_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Intay jidka sii socdeen meel bay ku habeen dhexeen, Rabbi baana ugu yimid, oo wuxuu damcay inuu dilo isaga. ");
INSERT INTO som_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Markaasaa Siforaah waxay qaadatay dhagax af leh, oo wiilkeedii buuryadiisii bay ku gooysay, oo waxay ku ag tuurtay cagihiisa oo tidhi, Hubaal waxaad ii tahay arooskii dhiigga. ");
INSERT INTO som_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Markaasuu iska daayay isagii. Kolkaasay tidhi, Waxaad ii tahay arooskii dhiigga gudniinta aawadeed. ");
INSERT INTO som_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Markaasaa Rabbigu wuxuu Haaruun ku yidhi, Tag inaad Muuse kaga hor tagtid cidlada dhexdeeda. Markaasuu tegey, oo wuxuu kaga hor tegey buurta Ilaah, kolkaasuu dhunkaday. ");
INSERT INTO som_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Kolkaasaa Muuse wuxuu Haaruun u sheegay erayadii Rabbigu u soo faray oo dhan, iyo calaamooyinkii uu ku amray oo dhan. ");
INSERT INTO som_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Markaasaa Muuse iyo Haaruun tageen oo waxay isu soo ururiyeen waayeelladii reer binu Israa'iil oo dhan. ");
INSERT INTO som_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Markaasaa Haaruun kula hadlay erayadii Rabbigu Muuse u soo faray oo dhan, calaamooyinkiina dadka hortiisuu ku sameeyey. ");
INSERT INTO som_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Dadkiina way rumaysteen, oo markay maqleen inuu Rabbigu soo booqday reer binu Israa'iil iyo inuu arkay dhibaatadooda ayay madaxa hoos u foorariyeen oo caabudeen. ");
INSERT INTO som_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Oo dabadeedna Muuse iyo Haaruun waxay u tageen Fircoon, oo waxay ku yidhaahdeen, Rabbiga ah Ilaaha reer binu Israa'iil wuxuu leeyahay, Sii daa dadkaygu ha tageene, inay cidlada iigu ciidaan. ");
INSERT INTO som_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Markaasaa Fircoon wuxuu yidhi, Waa ayo Rabbiga ay waajibka igu tahay inaan codkiisa maqlo oo aan reer binu Israa'iil sii daayo? Anigu garan maayo Rabbiga, oo weliba sii dayn maayo reer binu Israa'iil inay tagaan. ");
INSERT INTO som_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Markaasay waxay ku yidhaahdeen, Ilaahii Cibraaniyada ayaa nala kulmay, haddaba waannu ku baryaynaaye, Na sii daa, aannu tagnee meel cidla ah oo saddex maalmood loo socdo oo aan allabari ugu bixinnee Rabbiga ah Ilaahayaga inuusan belaayo ama seef nagu soo dejin. ");
INSERT INTO som_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Markaasaa boqorkii Masar wuxuu ku yidhi iyagii, Muuse iyo Haaruunow, maxaad dadka uga joojinaysaan shuqulladooda? Orda oo hawlihiinna culculus qabsada. ");
INSERT INTO som_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Kolkaasaa Fircoon wuxuu yidhi, Bal eega, haatan dadka dalku waa badan yihiin, oo idinku waad ka nasiseen hawlahoodii cuscuslaa. ");
INSERT INTO som_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Markaasaa Fircoon wuxuu isla maalintaas ku amray kuwii dadka hawsha ku cadaadin jiray iyo saraakiishoodii, isagoo leh, ");
INSERT INTO som_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","Hadda dabadeed waa inaydnaan dadka siin caws ay leben ka sameeyaan sidii loo siin jiray, laakiinse iyagu ha tageen oo caws ha soo gurteen. ");
INSERT INTO som_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Oo lebenkii ay markii hore samayn jireen tiradiisii oo kale waa inaad hadda ka dib ku qasabtaan inay sameeyaan, oo waa inaydnaan waxba ka dhimin, waayo, waa caajisiin oo sidaas daraaddeed waxay u qaylinayaan, iyagoo leh, Na sii daa aannu tagnee oo aan Ilaahayaga allabari u bixinnee. ");
INSERT INTO som_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Haddaba nimanka ha lagu qasbo hawl ka culus intii hore inay ku hawshoodaan, oo yaanay hadal been ah u jeedin. ");
INSERT INTO som_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Markaasay kuwii hawsha dadka ku cadaadin jiray iyo saraakiishoodiiba dibadda u bexeen, oo waxay la hadleen dadkii, oo ku yidhaahdeen, Waxaa Fircoon idin leeyahay, Caws idin siin maayo. ");
INSERT INTO som_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Idinku taga oo caws ka doonta meeshii aad ka heli kartaan, laakiin hawshiinna waxba laydinka dhimi maayo innaba. ");
INSERT INTO som_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Sidaa daraaddeed ayaa dadku ku kala firdhay dalkii Masar oo dhan inay jirrido jajab ah soo ururiyaan meeshii cawska laga siin jiray. ");
INSERT INTO som_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Oo kuwii dadka hawsha ku cadaadin jirayna way daddajiyeen, oo waxay ku yidhaahdeen, Dhammeeya shuqulladiinna, iyo hawshiinna intii aad maalin walba samayn jirteen, sidii markii cawsku jiri jiray oo kale. ");
INSERT INTO som_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Oo saraakiishii reer binu Israa'iil, oo Fircoon kuwiisa dadka hawsha ku cadaadiyaa ay dadka madaxda uga dhigeen, waa la garaacay, oo waxaa lagu yidhi, War maxaad shalay iyo maantaba hawshiinna u dhammayn weydeen oo aad lebenkii ugu samayn weydeen sidii hore? ");
INSERT INTO som_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Markaasay saraakiishii reer binu Israa'iil waxay u tageen oo u cataabeen Fircoon, waxayna ku yidhaahdeen, War maxaad addoommadaada sidan ugula macaamilootaa? ");
INSERT INTO som_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Addoommadaada caws lama siiyo, oo waxay nagu yidhaahdaan, Leben sameeya. Oo bal eeg, addoommadaadii waa la garaacaa, laakiinse gardarrada waxaa iska leh dadkaaga. ");
INSERT INTO som_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Laakiinse wuxuu ku yidhi iyagii, Caajisiin baad tihiin, caajisiin baad tihiin, oo sidaas daraaddeed baad u leedihiin, Aannu tagno oo aan Rabbiga allabari u bixinno. ");
INSERT INTO som_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Haddaba taga oo shaqeeya, waayo, caws laydin siin maayo, oo weliba waa inaad keentaan tiradii lebenkii oo kale. ");
INSERT INTO som_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Oo saraakiishii reer binu Israa'iil waxay arkeen in xaalkoodii xun yahay, markii lagu yidhi, Waa inaydnaan waxba dhimin lebenkii aad maalin walba samayn jirteen. ");
INSERT INTO som_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Oo markay Fircoon ka soo bexeen waxay ka hor yimaadeen Muuse iyo Haaruun oo jidka taagtaagan, ");
INSERT INTO som_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","oo waxay ku yidhaahdeen, Rabbigu ha idin fiiriyo oo ha idin xukumo, waayo, waxaad naga dhigteen wax u ura Fircoon iyo addoommadiisii si ay noo nacaan oo ay intay seefo noo qaataan noo laayaan. ");
INSERT INTO som_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Markaasaa Muuse mar kale Rabbiga u jeestay, oo wuxuu ku yidhi, Rabbiyow, maxaad dadkan si xun ugula macaamilootay? Oo maxaad aniga ii soo dirtay? ");
INSERT INTO som_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Ilaa markii aan u imid Fircoon oo aan magacaaga kula hadlay isaga, wax xun buu dadkan ku sameeyey, oo adna dadkaaga kama aad samatabbixin innaba. ");
INSERT INTO som_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Markaasaa Rabbigu wuxuu Muuse ku yidhi, Haddaba waad arki doontaa waxaan ku samayn doono Fircoon, waayo, gacan xoog leh buu ku sii dayn doonaa iyaga, oo gacan xoog leh buu dhulkiisa kaga eryi doonaa. ");
INSERT INTO som_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Markaasaa Ilaah wuxuu la hadlay Muuse oo ku yidhi, Anigu waxaan ahay Rabbiga, ");
INSERT INTO som_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","oo waxaan ugu muuqday Ibraahim, iyo Isxaaq, iyo Yacquub, sidii Ilaaha Qaadirka ah, laakiinse magacayga ah RABBI iguma ay aqoonin. ");
INSERT INTO som_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Oo weliba axdigaygii waan la dhigtay iyaga inaan siiyo dalka reer Kancaan oo ah dalkii geeddinimadooda oo ay qariibka ku ahaayeen. ");
INSERT INTO som_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Oo weliba waxaan maqlay cabaadka reer binu Israa'iil oo Masriyiintu addoonsiga ku sii hayaan, oo axdigaygii baan xusuustay. ");
INSERT INTO som_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Haddaba waxaad reer binu Israa'iil ku tidhaahdaa, Anigu waxaan ahay Rabbiga, oo waan idinka soo bixin doonaa culaabta Masriyiintu idinku hoos hayaan, waanan idinka xorayn doonaa addoonsigooda, waanan idinku furan doonaa gacan fidsan iyo xukummo waaweyn, ");
INSERT INTO som_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","oo waxaan idiin qaadan doonaa dad ahaan, oo aan idiin noqon doonaa Ilaah, oo waxaad ogaan doontaan inaan anigu ahay Rabbiga Ilaahiinna ah oo idinka bixinaya culaabtii Masriyiinta. ");
INSERT INTO som_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Oo waxaan idin geeyn doonaa dalkii aan ku dhaartay inaan siiyo Ibraahim, iyo Isxaaq, iyo Yacquub, oo idinkaan dhaxal ahaan idiin siin doonaa. Anigu waxaan ahay Rabbiga. ");
INSERT INTO som_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Muusena sidaasuu reer binu Israa'iil ula hadlay, laakiinse ma ayan maqlin Muuse, caloolxumadooda iyo addoonsiga aan looga tudhayn aawadood. ");
INSERT INTO som_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Markaasaa Rabbigu Muuse la hadlay, isagoo leh, ");
INSERT INTO som_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","Fircoon oo ah boqorka Masar u tag, oo la hadal, si uu u sii daayo reer binu Israa'iil si ay dalkiisa uga baxaan. ");
INSERT INTO som_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Markaasaa Muuse Rabbiga la hadlay oo wuxuu ku yidhi, Bal eeg, reer binu Israa'iil ima maqline, de haddaba sidee buu Fircoon ii maqli doonaa, anigoo aan bushimaha ka xalaalaysnayn? ");
INSERT INTO som_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Markaasaa Rabbigu wuxuu la hadlay Muuse iyo Haaruun, oo amar buu u soo faray reer binu Israa'iil, iyo boqorkii Masar oo ahaa Fircoon, inay reer binu Israa'iil ka soo wadaan dalka Masar. ");
INSERT INTO som_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Kuwanu waa madaxdii reerihii awowayaashood, kuwanu waa reer Ruubeen oo ahaa curadkii Israa'iil, Xanoog, iyo Falluu, iyo Xesroon, iyo Karmii; kuwanu waa qolooyinkii reer Ruubeen. ");
INSERT INTO som_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Reer Simecoonna waa kuwan, Yemuu'eel, iyo Yaamiin, iyo Ohad, iyo Yaakiin, iyo Sohar, iyo Shaa'uul oo ahaa wiilkii ay naag reer Kancaan ah dhashay. Kuwanu waa qolooyinkii reer Simecoon. ");
INSERT INTO som_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Kuwanuna waa reer Laawi magacyadoodii, iyo sidii farcankoodii kala ahaayeen; Gershoon, iyo Qohaad, iyo Meraarii. Oo Laawi cimrigiisii wuxuu ahaa boqol iyo toddoba iyo soddon sannadood. ");
INSERT INTO som_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Reer Gershoon, iyo sidii qolooyinkoodu kala ahaayeenna waa Libnii iyo Shimcii. ");
INSERT INTO som_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Reer Qohaadna waa Camraam, iyo Isehaar, iyo Xebroon, iyo Cusii'eel. Oo Qohaad cimrigiisiina wuxuu ahaa boqol iyo saddex iyo soddon sannadood. ");
INSERT INTO som_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Reer Meraariina waa Maxlii iyo Mushii. Kuwanu waa qolooyinkii reer Laawi iyo sidii ay farcankoodii kala ahaayeen. ");
INSERT INTO som_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Oo Camraam wuxuu guursaday Yookebed oo eeddadiis ahayd, oo waxay u dhashay Haaruun iyo Muuse. Oo Camraam cimrigiisiina wuxuu ahaa boqol iyo toddoba iyo soddon sannadood. ");
INSERT INTO som_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Reer Isehaarna waa Qorax, iyo Nefeg, iyo Sikrii. ");
INSERT INTO som_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Reer Cusii'eelna waa Miishaa'eel, iyo Elsaafaan, iyo Sitrii. ");
INSERT INTO som_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Haaruunna wuxuu guursaday Eliishebac ina Cammiinaadaab oo ahayd Naxshoon walaashiis; oo waxay u dhashay Naadaab iyo Abiihuu, iyo Elecaasaar, iyo Iitaamaar. ");
INSERT INTO som_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Reer Qoraxna waa Asiir, iyo Elqaanaah, iyo Abii'aasaaf. Kuwanu waa qolooyinkii reer Qorax. ");
INSERT INTO som_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Markaasaa Elecaasaar oo ahaa ina Haaruun wuxuu guursaday gabdhihii Fuutii'eel middood, oo waxay u dhashay Fiinexaas. Kuwanu waa madaxdii reer Laawi, iyo qolooyinkoodii siday kala ahaayeen. ");
INSERT INTO som_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Kuwanu waa Haaruun iyo Muuse kuwii Rabbigu ku yidhi, Reer binu Israa'iil ka soo wada dalka Masar sida ay dadkooda guutooyinkoodu yihiin. ");
INSERT INTO som_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Kuwanuna waa kuwii la hadlay boqorkii Masar oo Fircoon ahaa, inuu dalka Masar ka bixiyo reer binu Israa'iil. Iyagu waa Muusahaas iyo Haaruunkaas. ");
INSERT INTO som_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Maalintii Rabbigu la hadlay Muuse oo dalka Masar jooga, ");
INSERT INTO som_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","wuxuu Rabbigu ku yidhi Muuse, Anigu waxaan ahay Rabbiga. Boqorka Masar oo Fircoon ah la hadal oo waxaad u sheegtaa wixii aan kugula hadlo oo dhan. ");
INSERT INTO som_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Markaasaa Muuse wuxuu ku yidhi Rabbiga, Bal eeg, anigu bushimaha kama xalaalaysni, de haddaba sidee buu Fircoon ii maqlayaa? ");
INSERT INTO som_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Markaasaa Rabbigu wuxuu Muuse ku yidhi, Bal fiiri, waxaan Fircoon kaaga dhigay sidii ilaah oo kale, walaalkaa Haaruunna wuxuu ahaan doonaa nebigaaga. ");
INSERT INTO som_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Adigu waa inaad ku hadasho waxa aan kugu amrayo oo dhan; walaalkaa Haaruunna waa inuu Fircoon la hadlo si uu reer binu Israa'iil u sii daayo si ay dalkiisa uga baxaan. ");
INSERT INTO som_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Oo Fircoon qalbigiisana waan qallafin doonaa, calaamooyinkayga iyo cajaa'ibyadaydana waan ku badin doonaa dalka Masar. ");
INSERT INTO som_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Laakiin Fircoon kuma maqli doono, markaasaan gacantayda saari doonaa Masar, oo aan soo bixin doonaa ciidankayga oo ah dadkayga reer binu Israa'iil, waanan kaga soo saari doonaa xukummo waaweyn dalka Masar. ");
INSERT INTO som_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Markaasaa Masriyiintu ogaan doonaan inaan anigu Rabbiga ahay, markii aan gacantayda Masar ku kor fidiyo, oo aan reer binu Israa'iil ka dhex bixiyo iyaga. ");
INSERT INTO som_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Markaasaa Muuse iyo Haaruun sidaas yeeleen. Sidii Rabbigu ku amray, ayay yeeleen. ");
INSERT INTO som_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Muusena markaas wuxuu jiray siddeetan sannadood, Haaruunna wuxuu jiray saddex iyo siddeetan sannadood markay Fircoon la hadleen. ");
INSERT INTO som_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Markaasaa Rabbigu la hadlay Muuse iyo Haaruun, oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","Markii Fircoon idinla hadlo, oo idinku yidhaahdo, Cajaa'ib i tusa; markaas waxaad Haaruun ku tidhaahdaa, Ushaada qaado, oo Fircoon hortiisa ku tuur, si ay abeeso u noqoto. ");
INSERT INTO som_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Markaasaa Muuse iyo Haaruun waxay u tageen Fircoon, oo waxay yeeleen sidii Rabbigu ku amray, markaasaa Haaruun ushiisii ku hor tuuray Fircoon iyo addoommadiisii, oo waxay noqotay abeeso. ");
INSERT INTO som_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Fircoonna markaasuu wuxuu u yeedhay raggiisii xigmadda lahaa iyo saaxiriintiisii, markaasaa falalowyadii Masarna iyana yeeleen sidii si le'eg oo falfalkoodii ku sameeyeen. ");
INSERT INTO som_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Waayo, nin waluba wuxuu tuuray ushiisii, markaasay waxay noqdeen abeesooyin, laakiinse ushii Haaruun baa wada liqday ulahoodii oo dhan. ");
INSERT INTO som_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Qalbigii Fircoonna wuu sii qallafsanaaday, mana uu dhegaysan iyagii, sidii Rabbigu yidhi. ");
INSERT INTO som_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Markaasaa Rabbigu wuxuu Muuse ku yidhi, Fircoon waa macangag, oo wuu diidayaa inuu dadka sii daayo. ");
INSERT INTO som_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Bal subaxda Fircoon u tag, waayo, aroorta wuxuu tagaa biyaha. Haddaba waxaad istaagtaa webiga qarkiisa inaad la kulantid isaga; oo gacanta waxaad ku qaadataa ushii abeesada noqotay. ");
INSERT INTO som_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Oo waxaad isaga ku tidhaahdaa, Rabbiga ah Ilaaha Cibraaniyada ayaa ii soo kaa diray, oo wuxuu kugu yidhi, Sii daa dadkaygu ha tageene, inay cidlada iigu adeegaan; oo bal eeg, hadda ka hor ima aad maqlin. ");
INSERT INTO som_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Oo waxaa Rabbigu ku leeyahay, Tan ayaad ku ogaan doontaa inaan Rabbiga ahay, bal ogow, ushan aan gacanta ku hayo ayaan ku dhufan doonaa biyaha webiga ku jira, markaasay waxay u rogman doonaan dhiig. ");
INSERT INTO som_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Oo kalluunka biyaha ku jiraana way wada bakhtiyi doonaan, markaasaa webigu soo uri doonaa; kolkaasaa Masriyiintu aad u nebcaan doonaan inay webiga biyo ka cabbaan. ");
INSERT INTO som_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Rabbigu wuxuu Muuse ku yidhi, Waxaad Haaruun ku tidhaahdaa, Ushaada qaado, oo gacanta ku kor fidi biyaha Masar, iyo webiyaashooda, iyo durdurradooda, iyo galalkooda, iyo balliyadooda biyaha ah oo dhan, si ay u noqdaan dhiig; oo dhulka Masar oo dhammu wuxuu noqon doonaa dhiig miidhan, oo ku jiri doona weelasha qoriga ah iyo weelasha dhagaxa ahba. ");
INSERT INTO som_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Markaasaa Muuse iyo Haaruun yeeleen sidii Rabbigu ku amray; kolkaasuu ushii kor u qaaday, oo biyihii webiga ku jiray ku dhuftay Fircoon iyo addoommadiisii hortooda, markaasaa biyihii webiga ku jiray oo dhammu waxay u rogmadeen dhiig. ");
INSERT INTO som_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Kalluunkii webiga ku jirayna way wada bakhtiyeen; webigiina waa uray, Masriyiintiina biyo way ka cabbi kari waayeen webigii; dhulkii Masar oo dhammuna wuxuu noqday dhiig miidhan. ");
INSERT INTO som_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Markaasaa saaxiriintii Masarna waxay yeeleen sidii si le'eg oo falfalkoodii ku sameeyeen. Qalbigii Fircoonna wuu sii qallafsanaaday, mana uu dhegaysan iyagii, sidii Rabbigu yidhi. ");
INSERT INTO som_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Kolkaasaa Fircoon noqday oo gurigiisii tegey, waxanna qalbigiisii maba uu gelin. ");
INSERT INTO som_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Markaasaa Masriyiintii oo dhammu waxay qoteen webiga dhinacyadiisa inay helaan biyo ay cabbaan, waayo, biyihii webiga way cabbi kari waayeen. ");
INSERT INTO som_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Oo intii Rabbigu webiga kharribay toddoba maalmood baa ka dambaysay. ");
INSERT INTO som_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Markaasaa Rabbigu wuxuu Muuse ku yidhi, Fircoon u tag, oo waxaad ku tidhaahdaa, Waxaa Rabbigu leeyahay, Dadkayga sii daa ha tageene inay ii adeegaan. ");
INSERT INTO som_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Oo haddii aad diiddo inaad sii daysid, bal hadda ogow, waddankaaga oo dhan waxaan ku soo dayn doonaa rahyo. ");
INSERT INTO som_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Oo webiga waxaa ka buuxsami doona rahyo, markaasay waxay tegi doonaan oo geli doonaan gurigaaga, iyo qawladdaada aad seexatid, iyo sariirtaada dusheeda, iyo guryaha addoommadaada oo dhan, iyo dadkaaga dushiisa, iyo foornooyinkaaga dhexdooda, iyo weelashaada wax lagu cajiimo oo dhan; ");
INSERT INTO som_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","oo rahyadu waxay kor fuuli doonaan adiga, iyo dadkaaga, iyo addoommadaada oo dhanba. ");
INSERT INTO som_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Markaasaa Rabbigu wuxuu Muuse ku yidhi, Waxaad Haaruun ku tidhaahdaa, Gacanta adoo ushaada ku haysta ku fidi webiyaasha dushooda, iyo durdurrada dushooda, iyo balliyada dushooda, oo rahyo ku soo daa dalka Masar. ");
INSERT INTO som_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Markaasaa Haaruun gacanta ku kor fidiyey biyihii dalka Masar oo dhan, kolkaasaa rahyadii soo baxeen oo qariyeen dalkii Masar. ");
INSERT INTO som_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Saaxiriintiina sidaas si le'eg bay yeeleen oo falfalkoodii ku sameeyeen, oo rahyo bay keeneen dalkii Masar. ");
INSERT INTO som_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Markaasaa Fircoon wuxuu u yeedhay Muuse iyo Haaruun, oo wuxuu ku yidhi, Rabbiga noo barya inuu rahyada naga qaado aniga iyo dadkaygaba; oo markaasaan dadka sii dayn doonaa inay tagaan oo ay Rabbiga allabari u bixiyaan. ");
INSERT INTO som_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Kolkaasaa Muuse wuxuu Fircoon ku yidhi, Adaa amarka leh; goormaan idiin baryaa adiga iyo addoommadaada iyo dadkaaga, iyo in rahyada laga baabbi'iyo adiga iyo guryahaagaba, oo ay ku hadhaan webiga keliya? ");
INSERT INTO som_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Markaasuu ku yidhi, Berri. Isaguna wuxuu yidhi, Sidaad u tidhi ha noqoto, bal inaad ogaatid inaanu jirin mid la mid ah Rabbiga ah Ilaahayaga. ");
INSERT INTO som_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Oo rahyadu waa ka tegi doonaan adiga iyo guryahaaga, iyo addoommadaada, iyo dadkaagaba, oo waxay ku hadhi doonaan webiga oo keliya. ");
INSERT INTO som_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Kolkaasay Muuse iyo Haaruun ka tageen Fircoon; markaasaa Muuse Rabbiga ugu qayshaday wax ku saabsan rahyadii uu ku soo daayay Fircoon. ");
INSERT INTO som_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Rabbiguna wuu yeelay siduu Muuse yidhi, oo rahyadii waa ka idlaadeen guryihii, iyo barxadihii, iyo beerihiiba. ");
INSERT INTO som_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Kolkaasay isu soo wada ururiyeen oo meelo ku tuuleen, markaasaa dalkii uray. ");
INSERT INTO som_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Fircoonse markuu arkay inay wixii joogsadeen ayuu qalbiga ka sii qallafsanaaday, mana uu dhegaysan iyagii, sidii Rabbigu yidhi. ");
INSERT INTO som_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Markaasaa Rabbigu wuxuu Muuse ku yidhi, Waxaad Haaruun ku tidhaahdaa, Ushaada fidi oo ciidda dhulka ku dhufo si uu dalka Masar oo dhammu injir miidhan u noqdo. ");
INSERT INTO som_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Markaasay sidii yeeleen. Kolkaasaa Haaruun ushiisii gacanta ku fidiyey, oo wuxuu ku dhuftay ciidda dhulka, kolkaasaa injiru gashay dadkii iyo duunyadiiba; ciiddii dhulka oo dhammuna waxay noqotay injir miidhan oo qulqulaysa dalkii Masar oo dhan. ");
INSERT INTO som_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Saaxiriintiina saasay yeeleen, oo waxay damceen inay injir falfalkoodii ku keenaan, laakiinse way kari waayeen; injir baana ku jirtay dadkii iyo duunyadiiba. ");
INSERT INTO som_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Markaasaa saaxiriintii waxay Fircoon ku yidhaahdeen, Tanu waa fartii Ilaah. Qalbigii Fircoonna wuu sii qallafsanaaday, mana uu dhegaysan iyagii, sidii Rabbigu yidhi. ");
INSERT INTO som_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Markaasaa Rabbigu wuxuu Muuse ku yidhi, Aroor hore kac oo Fircoon hortiisa istaag, waayo, markaasuu biyaha tegayaa, oo waxaad ku tidhaahdaa, Waxaa Rabbigu leeyahay, Dadkayga sii daa ha tageene inay ii adeegaan. ");
INSERT INTO som_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Haddii kalese haddaadan dadkayga sii daynin inay tagaan, bal ogow, waxaan idiin soo diri doonaa duqsiyo faro badan, adiga, iyo addoommadaada, iyo dadkaaga, iyo guryahaaga dhexdooda; oo guryaha Masriyiinta oo dhanna waxaa ka buuxsami doona duqsiyo faro badan, iyo weliba dhulka ay joogaanba. ");
INSERT INTO som_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Inaad ogaatid inaan anigu dhulka dhexdiisa ku ahay Rabbiga, maalintaas waan ka duwi doonaa dalka Goshen oo dadkaygu deggan yahay, inaan duqsiyo badanu halkaas jirin innaba. ");
INSERT INTO som_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Oo dadkayga iyo dadkaagana waan kala sooci doonaa; calaamadaasuna berri bay ahaan doontaa. ");
INSERT INTO som_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Rabbiguna sidii buu yeelay, oo duqsiyo badan oo baas ayaa yimid gurigii Fircoon, iyo guryihii addoommadiisa, oo dalkii Masar oo dhanna duqsiyadii badnaa aawadood ayuu u kharribmay. ");
INSERT INTO som_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Markaasaa Fircoon wuxuu u yeedhay Muuse iyo Haaruun, oo wuxuu ku yidhi, Taga oo Ilaahiin dalka dhexdiisa allabari ugu bixiya. ");
INSERT INTO som_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Kolkaasaa Muuse ku yidhi, Sidaas inaan yeelno ma habboona; waayo, karaahiyada Masriyiinta ayaannu Rabbiga Ilaahayaga ah u bixinaynaa. Bal eeg, miyaannu karaahiyada Masriyiinta ku allabarinnaa iyagoo noo jeeda? De sow na dhagxin maayaan? ");
INSERT INTO som_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Meel saddex maalmood loo socdo oo cidla ah ayaannu tegaynaa, oo allabari ugu bixinaynaa Rabbiga Ilaahayaga ah, siduu nagu amri doono. ");
INSERT INTO som_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Markaasaa Fircoon wuxuu ku yidhi, Waan idin sii daynayaa inaad tagtaan inaad cidlada allabari ugu bixisaan Rabbiga Ilaahiinna ah, laakiinse waa inaydnaan aad u fogaan. Iina soo duceeya. ");
INSERT INTO som_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Muusena wuxuu ku yidhi, Bal eeg, waan kaa baxayaa oo waxaan Rabbiga ka baryi doonaa inay duqsiyada badanu berri ka tagaan Fircoon iyo addoommadiisa, iyo dadkiisa, laakiinse Fircoon yuusan mar dambe khiyaano nagula macaamiloon, isagoo aan daynin dadka inay tagaan si ay allabari ugu bixiyaan Rabbiga. ");
INSERT INTO som_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Markaasaa Muuse ka tegey Fircoon, oo wuxuu baryay Rabbiga. ");
INSERT INTO som_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Rabbiguna sidii Muuse yidhi ayuu yeelay; duqsiyadii badnaana wuu ka kexeeyey Fircoon, iyo addoommadiisii, iyo dadkiisiiba. Mid qudh ahna kama hadhin. ");
INSERT INTO som_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Markanna Fircoon qalbiga ayuu ka sii qallafsanaaday, oo dadkiina siima uu dayn inay tagaan. ");
INSERT INTO som_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Markaasaa Rabbigu wuxuu Muuse ku yidhi, Fircoon u tag, oo waxaad ku tidhaahdaa, Waxaa Rabbiga ah Ilaaha Cibraaniyadu leeyahay, Dadkayga sii daa ha tageene, inay ii adeegaan. ");
INSERT INTO som_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Waayo, haddii aad sii dayn weydo, oo aad sii haysatid, ");
INSERT INTO som_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","bal ogow, gacanta Rabbigu waxay ku dhici doontaa xoolahaaga berrinka jooga, ha ahaadeen fardaha, dameeraha, geela, lo'da, iyo adhigaba; waxaana dhici doona cudur baas. ");
INSERT INTO som_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Oo Rabbigu waa kala sooci doonaa xoolaha reer binu Israa'iil iyo xoolaha Masar; oo waxa reer binu Israa'iil ay leeyihiinna waxba kama dhiman doonaan. ");
INSERT INTO som_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Rabbiguna wakhti buu u qabtay, isagoo leh, Berri Rabbigu waxan ayuu dalka dhexdiisa ku samayn doonaa. ");
INSERT INTO som_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Rabbiguna waxaas waa sameeyey maalintii dambe, oo xoolihii Masar oo dhammuna way wada bakhtiyeen; laakiinse xoolihii reer binu Israa'iil midna kama bakhtiyin. ");
INSERT INTO som_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Markaasaa Fircoon cid diray, oo bal eeg, xoolihii reer binu Israa'iil xataa mid kama bakhtiyin. Laakiinse Fircoon wuu madax adkaaday, dadkiina siima uu dayn inay tagaan. ");
INSERT INTO som_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Markaasaa Rabbigu wuxuu Muuse iyo Haaruun ku yidhi, Waxaad qaadataan cantoobooyin dambaska foornada ah, oo Muuse samada ha u saydho Fircoon hortiisa. ");
INSERT INTO som_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Oo waxay noqon doontaa habaas dhulka Masar oo dhan dul yaal, oo dalka Masar oo dhan waxaa dadka iyo duunyadaba ka soo bixi doona boogo xunxun. ");
INSERT INTO som_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Markaasay qaadeen dambaskii foornada, oo waxay hor istaageen Fircoon; kolkaasaa Muuse xagga samada kor ugu saydhay, markaasaa dadkii iyo duunyadiiba waxaa ka soo wada baxay boogo xunxun. ");
INSERT INTO som_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Oo saaxiriintiina Muuse ma ay hor istaagi karin boogaha dartood, waayo, booguhu waxay ka soo bexeen saaxiriintii iyo Masriyiintii oo dhan. ");
INSERT INTO som_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Rabbiguna waa sii qallafiyey Fircoon qalbigiisii, oo isna ma uu dhegaysan iyagii, sidii Rabbigu Muuse ku yidhi. ");
INSERT INTO som_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Markaasaa Rabbigu wuxuu Muuse ku yidhi, Aroor hore kac, oo Fircoon hortiisa istaag, oo waxaad ku tidhaahdaa, Rabbiga Ilaaha Cibraaniyada ah wuxuu leeyahay, Dadkayga sii daa ha tageene, inay ii adeegaan. ");
INSERT INTO som_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Waayo, waxaan markan qalbigaaga, iyo addoommadaada, iyo dadkaagaba ku soo dayn doonaa belaayadayda oo dhan, inaad ogaatid inaan dhulka oo dhan lagu arag mid anoo kale ah. ");
INSERT INTO som_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Waayo, haatan haddaan gacantayda fidin lahaa, oo aan belaayo kugu dhufan lahaa adiga iyo dadkaagaba, de markaas adiga dhulka waa lagaa baabbi'in lahaa, ");
INSERT INTO som_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","laakiin sababtan aawadeed ayaan kuu taagay, inaan xooggayga kaa muujiyo iyo in magacayga laga sheego dhulka oo dhan. ");
INSERT INTO som_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Ma weli baad dadkayga iska weynaynaysaa, oo aanad sii daynin? ");
INSERT INTO som_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Bal ogow, berrito haddaa oo kale waxaan soo daadin doonaa roobdhagaxyaale baas oo aan weligiis lagu arag Masar tan iyo maalintii la dhisay ilaa haatan. ");
INSERT INTO som_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Haddaba cid u dir oo la soo dhaqso lo'daada iyo waxa berrinka kuu jooga oo dhan; waayo, dad iyo duunyo wixii berrinka laga helo oo dhan oo aan guryaha la soo gelin, waxaa ku soo degi doona roobka dhagaxyada leh, wayna dhiman doonaan. ");
INSERT INTO som_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Markaasaa mid kasta oo addoommadii Fircoon ka mid ahaa oo ka cabsanayay ereygii Rabbiga, addoommadiisii iyo lo'diisii ayuu xagga guryaha u eryay; ");
INSERT INTO som_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","kii aan dan ka lahayn ereygii Rabbigase addoommadiisii iyo lo'diisiiba ayuu berrinka ku daayay. ");
INSERT INTO som_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Markaasaa Rabbigu wuxuu Muuse ku yidhi, Gacanta xagga samada u fidi, in roobka dhagaxyada leh ku soo dego dalka Masar oo dhan, dadka dushiisa iyo duunyada dusheeda iyo dhalatada duurka ku taal dusheeda oo dhan ee dalka Masar dhammaantiis. ");
INSERT INTO som_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Markaasaa Muuse ushiisii u fidiyey xagga samada, oo Rabbigu wuxuu soo diray onkod iyo roobdhagaxyaale, waxaana dhulka ku soo degay dab; oo Rabbigu wuxuu dalkii Masar ku soo daayay roobdhagaxyaale. ");
INSERT INTO som_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Sidaas daraaddeed waxaa ku soo da'ay roobdhagaxyaale baas, roobka dhagaxyada lehna waxaa ku qaldanaa dab, kaas oo kalena weligiis kama di'in dalka Masar oo dhan tan iyo maalintii ay quruun noqotay ilaa haatan. ");
INSERT INTO som_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Oo roobkii dhagaxyada lahaana wuxuu laayay wax alla wixii dalka Masar oo dhan duurkiisa joogay, dad iyo duunyoba; oo dhalatadii duurka oo dhanna roobkii dhagaxyada lahaa baa laayay, oo dhirtii duurka oo dhanna wuu jejebiyey. ");
INSERT INTO som_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Waxaa keliyahoo aan roobdhagaxyaale ku di'in dalkii Goshen oo reer binu Israa'iil joogeen. ");
INSERT INTO som_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Markaasaa Fircoon cid u diray, oo u yeedhay Muuse iyo Haaruun, oo wuxuu iyagii ku yidhi, Markan waan dembaabay; Rabbigu waa xaq, aniga iyo dadkaygubana shar baannu leennahay. ");
INSERT INTO som_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Bal Rabbiga noo barya, waayo, roobkan dhagaxyada leh iyo onkodkan weynu waa nagu filan yihiin; oo waan idin sii dayn doonaa, oo idinku mar dambe sii joogi maysaan innaba. ");
INSERT INTO som_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Kolkaasaa Muuse wuxuu isagii ku yidhi, Isla markii aan ka baxo magaalada ayaan gacmahayga u kala bixin doonaa Rabbiga, oo onkodku waa joogsan doonaa, roobdhagaxyaale dambena ma jiri doono, si aad adigu u ogaatid inuu Rabbigu dhulka leeyahay. ");
INSERT INTO som_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Laakiin waan ogahay in adiga iyo addoommadaadu aydnaan weli ka cabsanayn Rabbiga Ilaaha ah. ");
INSERT INTO som_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Oo cudbigii iyo shaciirkiiba waa baabbe'een; waayo, shaciirku waa midhaystay, cudbigana ubax baa ka baxayay. ");
INSERT INTO som_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Laakiinse sarreenkii waxba kuma dhicin; waayo, weli aad uma uu bixin. ");
INSERT INTO som_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Oo Muusena magaaladii buu ka baxay, wuuna ka tegey Fircoon, oo gacmihiisii buu u kala bixiyey Rabbiga. Markaasaa onkodkii iyo roobkii dhagaxyada lahaaba joogsadeen, roobkiina dhulka kuma shubmin. ");
INSERT INTO som_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Fircoonna kolkuu arkay inay joogsadeen roobkii iyo roobdhagaxyaalihii iyo onkodkiiba, ayuu weliba sii dembaabay, oo qalbigiisiina wuu sii qallafiyey, isaga iyo addoommadiisiiba. ");
INSERT INTO som_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Oo Fircoon qalbigiisiina waa sii qallafsanaaday, oo reer binu Israa'iilna siima uu dayn inay tagaan, sidii Rabbigu Muuse afkiisa kaga hadlay. ");
INSERT INTO som_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Kolkaasaa Rabbigu Muuse ku yidhi, Orod oo Fircoon u gal, waayo, qalbigiisii waan qallafiyey, iyo qalbiyadii addoommadiisa, inaan calaamooyinkaygan dhexdooda ka muujiyo, ");
INSERT INTO som_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","iyo inaad adigu u sheegtid dhegaha wiilkaaga, iyo wiilkaaga wiilkiisa, wixii aan ku sameeyey Masriyiinta, iyo calaamooyinkaygii aan ku dhex sameeyey, inay iyagu ogaadaan inaan anigu ahay Rabbiga. ");
INSERT INTO som_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Markaasaa Muuse iyo Haaruun waxay u tageen Fircoon, oo ku yidhaahdeen, Rabbiga ah Ilaaha Cibraaniyadu wuxuu kugu yidhi, Ilaa goormaad diidaysaa inaad hortayda is-hoosaysiiso? Dadkayga sii daa ha tageene, inay ii adeegaan. ");
INSERT INTO som_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Laakiinse haddii aad diiddo inaad dadkayga sii dayso, bal ogow, berrito dalkaaga ayax baan ku soo dayn doonaa, ");
INSERT INTO som_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","oo dhulkuu qarin doonaa, si aan dhulka loo arkin, oo wuxuu cuni doonaa wixii ka baxsaday roobkii dhagaxyada lahaa oo idiin hadhay, oo wuxuu kaloo cuni doonaa geed kasta oo duurka idiinka baxaya. ");
INSERT INTO som_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Oo wuxuu ka buuxsami doonaa guryahaaga, iyo guryaha addoommadaada, iyo guryaha Masriyiinta oo dhan; si aan aabbayaashiin iyo awowayaashiin midkoodna arag tan iyo waagii ay dhulka joogeen ilaa maantadan. Kolkaasuu ka noqday oo ka tegey Fircoon. ");
INSERT INTO som_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Markaasaa Fircoon addoommadiisii waxay ku yidhaahdeen, Ilaa goormuu ninkanu dabin inagu noqonayaa? Inaga sii daa nimanka, Rabbiga Ilaahooda ah ha u adeegeene. War miyaadan weli ogayn in Masar baabba'day? ");
INSERT INTO som_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Markaasaa Muuse iyo Haaruun mar kale loo keenay Fircoon. Kolkaasuu wuxuu ku yidhi, Taga oo Rabbiga Ilaahiinna ah u adeega, laakiinse waa ayo kuwa tegayaa? ");
INSERT INTO som_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Muusena wuxuu yidhi, Annagu waannu tegaynaa yar iyo weynba, oo waxaannu la tegaynaa wiilashayada iyo gabdhahayaga, iyo adhyahayaga, iyo lo'dayada oo dhan; waayo, waxaannu u iidaynaa Rabbigayaga. ");
INSERT INTO som_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Oo wuxuu iyagii ku yidhi, Rabbigu ha idinla jiro, haddaan idin sii daayo idinka iyo yaryarkiinnaba, laakiinse bal ogaada in wax xumu idinka horreeyaan. ");
INSERT INTO som_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Sidaas ma aha; ee intiinna ragga ahu taga, oo Rabbiga u adeega; waayo, taasu waa wixii aad doonayseen. Kolkaasaa Fircoon hortiisa laga eryay iyagii. ");
INSERT INTO som_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Markaasaa Rabbigu wuxuu Muuse ku yidhi, Gacantaada ayaxa ugu fidi dalka Masar korkiisa, inuu kor yimaado dalka Masar, oo uu cuno geed yar oo kasta, oo ah in alla intii roobkii dhagaxyada lahaa ka baxsatay. ");
INSERT INTO som_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Markaasuu Muuse ushiisii dalkii Masar ku kor fidiyey, oo Rabbigu maalintaas oo dhan iyo habeenkii oo dhan, wuxuu dhulkii ku soo daayay dabayl bari ka timid, oo markii waagii beryay ayaa dabayshii bari ayaxii keentay. ");
INSERT INTO som_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Kolkaasaa ayaxii dalkii Masar oo idil dul fuulay, oo wuxuu ku soo degay dalkii Masar oo dhan; wuxuuna ahaa ayax baas; hortiisna lama arag ayax saas oo kale ah, dabadiisna ma jiri doono kaas oo kale. ");
INSERT INTO som_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Waayo, wuxuu qariyey dhulka dushiisa oo dhan, kolkaasaa dalkii gudcur noqday; oo wuxuu cunay dhalatadii waddanka oo dhan, iyo midhihii dhirtii roobkii dhagaxyada lahaa ka baxsaday oo dhan; oo dalkii Masar oo dhanna wax cagaar ahuna kuma hadhin ama dhir ha noqoto ama dhalatada duurka. ");
INSERT INTO som_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Markaasaa Fircoon dhaqso ugu yeedhay Muuse iyo Haaruun, oo wuxuu ku yidhi, Waan ku dembaabay Rabbiga Ilaahiinna ah iyo idinkaba. ");
INSERT INTO som_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Haddaba waan ku baryayaaye, iga cafi dembigayga markan keliya, oo ii barya Rabbiga Ilaahiinna ah, inuu iga qaado dhimashadan keliya. ");
INSERT INTO som_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Kolkaasuu Fircoon dibadda uga baxay oo Rabbiga baryay. ");
INSERT INTO som_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Markaasaa Rabbigu wuxuu soo leexiyey dabayl aad iyo aad u xoog badan oo galbeed ka timid, kolkaasay ayaxii kor u qaadday oo waxay ku gurtay Badda Cas, oo xataa ayax qudha ahi kuma hadhin dalka Masar oo dhan. ");
INSERT INTO som_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Markaasaa Rabbigu sii qallafiyey Fircoon qalbigiisii, mana uusan sii dayn reer binu Israa'iil inay tagaan. ");
INSERT INTO som_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Markaasaa Rabbigu wuxuu Muuse ku yidhi, Gacantaada xagga samada u taag, in gudcur ku soo dego dalka Masar, kaasoo ah gudcur aad u daran. ");
INSERT INTO som_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Kolkaasaa Muuse gacanta xagga samada u taagay; oo waxaa dalkii Masar ku soo degay gudcur weyn oo in saddex maalmood ah jiray; ");
INSERT INTO som_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","oo midkoodna midka kale ma arkin, ama midkoodna meeshiisii kama kicin in saddex maalmood ah; laakiinse reer binu Israa'iil oo dhan guryahoodu iftiin bay lahaayeen. ");
INSERT INTO som_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Markaasaa Fircoon Muuse u yeedhay oo wuxuu ku yidhi, Taga oo Rabbiga u adeega; laakiinse adhyihiinna iyo lo'diinnu ha joogeen; yaryarkiinnuse ha idin raaceen. ");
INSERT INTO som_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Muusena wuxuu yidhi, De waa inaad weliba na siisaa allabaryo iyo qurbaan la gubo, oo aannu u bixinno Rabbiga ah Ilaahayaga. ");
INSERT INTO som_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Lo'dayaduna waa inay na raacdaa, oo waa inaan neef keliyahu dib nooga hadhin, waayo, iyada waa inaannu wax ka qaadannaa si aannu ugu adeegno Rabbiga ah Ilaahayaga. Annagu garan mayno wax aannu ugu adeegno Rabbiga jeeraannu tagno xaggaas. ");
INSERT INTO som_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Laakiinse Rabbigu waa sii qallafiyey Fircoon qalbigiisii, mana u doonaynin inuu iyaga sii daayo. ");
INSERT INTO som_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Markaasaa Fircoon wuxuu isagii ku yidhi, War iga tag, oo iska jir, si aadan wejigayga mar dambe u arkin, waayo, maalintii aad wejigayga aragtid hubaal waad dhiman doontaa. ");
INSERT INTO som_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Markaasaa Muuse wuxuu ku yidhi, Adigu si wanaagsan baad u hadashay, oo wejigaaga mar dambe arki maayo. ");
INSERT INTO som_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Markaasaa Rabbigu wuxuu Muuse ku yidhi, Weli belaayo kale ayaan Fircoon iyo Masar ku soo dejin doonaa; oo dabadeedna wuu idin sii dayn doonaa inaad halkan ka tagtaan, oo markuu idin sii daayo, giddigiin ayuu halkan idinka sii wada eryi doonaa. ");
INSERT INTO som_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Haddaba dadka dhegihiisa maqashii, oo nin waluba ha weyddiisto deriskiisa, naag walubana ha weyddiisato deriskeeda alaab lacag ah iyo alaab dahab ah. ");
INSERT INTO som_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Rabbiguna Masriyiintii ayuu dadkii raalli uga dhigay. Oo weliba ninkii Muuse ahaa wuxuu dalka Masar ku ahaa mid aad u weyn xagga Fircoon addoommadiisa iyo xagga dadkaba. ");
INSERT INTO som_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Muusena wuxuu yidhi, Waxaa Rabbigu leeyahay, Habeenbadhka baan dalka Masar ku dhex soconayaa, ");
INSERT INTO som_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","oo curadyada dalka Masar jooga oo dhammu way wada dhiman doonaan, curadka Fircoon oo ku fadhiya carshigiisa, ilaa la gaadho curadka gabadha addoonta ah oo ka dambaysa dhagaxshiidka, iyo curadyada xoolaha oo dhan. ");
INSERT INTO som_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Oo waxaa dalka Masar oo dhan jiri doonta oohin weyn, taas oo kale aan hore loo arag, hadda kaddibna aan la arki doonin marnaba. ");
INSERT INTO som_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Laakiinse reer binu Israa'iil dad iyo duunyo toona xataa eeyna afka u kala qaadi maayo, si aad u ogaataan in Rabbigu kala duway Masriyiinta iyo reer binu Israa'iil. ");
INSERT INTO som_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Oo addoommadaadan oo dhammu anigay ii iman doonaan, oo anigay ii sujuudi doonaan, iyagoo leh, Iska bax, adiga iyo dadka kula socda oo dhammuba; oo markaas dabadeed ayaan bixi doonaa. Oo wuxuu Fircoon kaga tegey cadho aad u kulul. ");
INSERT INTO som_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Markaasaa Rabbigu wuxuu Muuse ku yidhi, Fircoon hadalkaaga dhegaysan maayo, inay cajaa'ibyadaydu dalka Masar ku sii bataan aawadeed. ");
INSERT INTO som_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Muuse iyo Haaruunna cajaa'ibyadan oo dhan waxay ku sameeyeen Fircoon hortiisa; Rabbiguna waa sii qallafiyey qalbigii Fircoon oo isna ma uusan sii dayn reer binu Israa'iil inay dalkiisa ka baxaan. ");
INSERT INTO som_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Oo Rabbigu wuxuu Muuse iyo Haaruun kula hadlay dalka Masar, oo ku yidhi, ");
INSERT INTO som_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","Bishanu waxay idiin noqonaysaa tii bilaha ugu horraysay; oo waxay idiin noqonaysaa sannadda bisheedii kowaad. ");
INSERT INTO som_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Shirka reer binu Israa'iil oo dhan la hadla oo waxaad ku tidhaahdaan, Maalinta tobnaad oo bishan waa in nin waluba wan qaataa sida reeraha aabbayaashood yihiin, qoys waluba wan ha qaato; ");
INSERT INTO som_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","oo haddii qoys uusan wada qaadan karin wan, de markaas waa in isaga iyo deriskiisa oo ah kan qoyskiisa ku xiga ay mid wada qaataan oo ay u qaybsadaan sida tirada dadku tahay; nin walba sida cuntadiisu tahay waa inaad u tirisaan kalaqaybinta wanka. ");
INSERT INTO som_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Wankiinnu waa inuu ahaadaa mid aan iin lahayn, waana inuu ahaadaa mid lab oo sannad jiray, waana inaad wananka ama orgiyada ka bixisaan, ");
INSERT INTO som_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","oo waa inaad gooni u xidhaan ilaa bisha maalinteeda afar iyo tobnaad; oo ururka shirka reer binu Israa'iil oo dhammu waa inay makhribkii qalaan. ");
INSERT INTO som_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Oo waa inay dhiigga wax ka qaataan, oo ay mariyaan fayaaradda albaabka labadeeda dhinac iyo meesheeda sare oo ah guryaha ay wax ku dhex cuni doonaan. ");
INSERT INTO som_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Oo habeenkaas waa inay cunaan hilibka oo dab lagu dubay, iyo kibis aan khamiir lahayn, oo ha ku cuneen caleemo qadhaadh. ");
INSERT INTO som_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Ha cunina isagoo ceedhiin ama biyo lagu kariyey, laakiin waxaad cuntaan isagoo dab lagu dubay, oo qaba madaxiisa iyo mijihiisa iyo waxa gudihiisa ku jira qaba. ");
INSERT INTO som_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Oo waa inaydnaan waxba ka reebin ilaa subaxda, laakiin waxa ka hadha markuu waagu beryo waa inaad dab ku gubtaan. ");
INSERT INTO som_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Oo sidan waa inaad u cuntaan, idinkoo guntan, oo kabihiinnu cagaha idiinku jiraan, ushiinnuna gacanta idiinku jirto; oo waa inaad degdeg u cuntaan; waayo, waa Rabbiga Kormariddiisa. ");
INSERT INTO som_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Waayo, habeenkaas waxaan dhex mari doonaa dalka Masar, oo waxaan wada layn doonaa curadyada dalka Masar oo dhan, kuwa dadka iyo kuwa duunyadaba, oo ilaahyada Masar oo dhan waxaan ku soo dejin doonaa xukummo. Anigu waxaan ahay Rabbiga. ");
INSERT INTO som_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Oo dhiiggu wuxuu idiin noqon doonaa calaamo kor taal guryaha aad ku jirtaan; oo markii aan dhiigga arko, waan iska kiin kor mari doonaa, belaayo idin baabbi'isaana idinkuma dhici doonto, markaan wax ku dhufto dhulka Masar. ");
INSERT INTO som_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Oo maalintanu waa inay xusuus idiin noqotaa, oo waa inaad Rabbiga u iiddaan. Waa inaad ka ab ka ab weligiin ku dhawrtaan iid amar ahaan. ");
INSERT INTO som_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Toddoba maalmood waxaad cuntaan kibis aan khamiir lahayn; weliba maalinta kowaad waa inaad khamiirka ka saartaan guryihiinna; waayo, ku alla kii cuna kibis khamiir leh maalinta kowaad ilaa maalinta toddobaad, qofkaas waa laga gooyn doonaa reer binu Israa'iil. ");
INSERT INTO som_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Maalinta kowaad waxaa idiin ahaan doona shir quduus ah, maalinta toddobaadna shir quduus ah. Wax shuqul ah maalmahaas waa inaan la qaban, waxa qof kastaaba cuno mooyaane, taas oo keliya baa la samayn karaa. ");
INSERT INTO som_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Oo idinku waa inaad dhawrtaan iidda kibista aan khamiirka lahayn, waayo, maalintaas qudheeda ayaan dadkiinna badnaantiisii ka soo bixiyey dalkii Masar; sidaas daraaddeed amar ahaan waa inaad ka ab ka ab weligiin ku dhawrtaan maalintaas. ");
INSERT INTO som_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Bisha kowaad, maalinteeda afar iyo tobnaad, markay fiidkii tahay waa inaad cuntaan kibis aan khamiir lahayn, ilaa laga gaadho maalinta koob iyo labaatanaad oo bisha, markay fiidkii tahay. ");
INSERT INTO som_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Toddoba maalmood waa inaan guryihiinna khamiir laga helin; waayo, ku alla kii wax khamiir leh cuna, qofkaas waa laga gooyn doonaa shirka reer binu Israa'iil, hadduu yahay qariib iyo hadduu waddanka ku dhex dhashayba. ");
INSERT INTO som_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Wax khamiir leh waa inaydnaan cunin; guryihiinna oo dhan waa inaad ku cuntaan kibis aan khamiir lahayn. ");
INSERT INTO som_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Markaasaa Muuse wuxuu u wada yeedhay waayeelladii reer binu Israa'iil oo dhan, oo wuxuu iyagii ku yidhi, La baxa wanan oo qoys, qoys u qaata, oo qala wanka Kormaridda. ");
INSERT INTO som_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Waxaad qaadataan xidhmo geed husob ah, oo waxaad dartaan dhiigga ku jira xeedhada, oo albaabka fayaaraddiisa sare iyo labada dhinac oo fayaaradda ah ku taabsiiya dhiiga ku jira xeedhada; oo midkiinna ilaa waagu ka beryo yuusan albaabka gurigiisa dibadda uga bixin. ");
INSERT INTO som_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Waayo, Rabbigu wuxuu dhex mari doonaa dalka, oo wuxuu layn doonaa Masriyiinta, oo markuu arko dhiigga ku yaal albaabka fayaaraddiisa sare iyo labada dhinac oo fayaaradda ah ayaa Rabbigu kor mari doona albaabka, oo u oggolaan maayo in baabbi'iyuhu guryihiinna soo galo oo idin laayo. ");
INSERT INTO som_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Oo waxan amar ahaan waa inaad weligiin u dhawrtaan idinka iyo carruurtiinnuba. ");
INSERT INTO som_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Oo markii aad timaadaan dalka Rabbigu idin siin doono, oo uu idiinku ballanqaaday, waa inaad dhawrtaan u adeegiddan Ilaah. ");
INSERT INTO som_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Oo markii carruurtiinnu idinku yidhaahdaan, Maxaad ula jeeddaan u-adeegiddan Ilaah? ");
INSERT INTO som_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","waxaad ku odhan doontaan, Waa allabarigii Rabbiga Kormariddiisii, kii kor maray guryihii reer binu Israa'iil markay Masar joogeen, oo samatabbixiyey reerahayagii, Masriyiintiise laayay. Markaasaa dadku madaxa u foororiyey oo u sujuuday. ");
INSERT INTO som_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Markaasaa reer binu Israa'iil tageen oo sidaas yeeleen; sidii Rabbigu Muuse iyo Haaruun ku amray ayay yeeleen. ");
INSERT INTO som_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Oo waxaa dhacday in habeenbadhkii Rabbigu laayay curadyadii dalkii Masar oo dhan, inta laga bilaabay curadkii Fircoon oo carshigiisii ku fadhiyey ilaa la gaadhay curadkii maxbuuska godxabsiga ku jiray, iyo curadyadii xoolaha oo dhan. ");
INSERT INTO som_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Markaasaa habeenkaas waxaa kacay Fircoon, iyo addoommadiisii oo dhan, iyo Masriyiintii oo dhan; oo oohin aad u weyn baa Masar ka dhacday, waayo, ma jirin guri aan meyd oollin. ");
INSERT INTO som_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Markaasuu Muuse iyo Haaruun u yeedhay habeennimadii, oo wuxuu ku yidhi, Kaca, oo dadkayga ka dhex baxa, idinka iyo reer binu Israa'iilba; taga oo Rabbiga u adeega, sidaad u tidhaahdeen. ");
INSERT INTO som_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Oo adhyihiinna iyo lo'diinnaba kaxaysta, sidaad u tidhaahdeen, iina soo duceeya. ");
INSERT INTO som_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Oo Masriyiintuna waxay dadka ku deddejiyeen inay dhaqso uga saaraan dalka; waayo, waxay yidhaahdeen, Kulligeen waxaynu nahay dad go'ay. ");
INSERT INTO som_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Markaasaa dadkii waxay qaateen cajiinkoodii intaanu khamiirin, iyo weelashoodii ay wax ku dhex cajiimi jireen, oo intay maryahoodii ku xidheen ayay garbaha saarteen. ");
INSERT INTO som_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Oo reer binu Israa'iilna waxay yeeleen sidii Muuse eraygiisu ahaa; oo waxay Masriyiintii weyddiisteen alaab lacag ah iyo alaab dahab ah iyo dhar; ");
INSERT INTO som_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","oo Rabbiguna Masriyiintii ayuu dadkii raalli uga dhigay, oo sidaas daraaddeed way u daayeen inay qaataan wixii ay weyddiisteenba. Oo iyana Masriyiintii way dheceen. ");
INSERT INTO som_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Oo reer binu Israa'iilna waxay ka sodcaaleen Racmeses oo waxay tageen Sukod, tiradooduna waxay ku dhowayd lix boqol oo kun oo nin oo lugaynaya oo aan carruurta lagu tirin. ");
INSERT INTO som_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Oo waxaa kaloo raacay dad faro badan oo isku darsan, iyo adhyihii, iyo lo'dii, oo ahaa xoolo aad u badan. ");
INSERT INTO som_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Oo cajiinkii ay Masar kala yimaadeen ayay ka dubteen kibis aan khamiir lahayn, waayo, ma ay khamiirin; maxaa yeelay, dalkii Masar degdeg bay kaga soo bexeen, oo ma aanay sii joogi karin, mana ay diyaarsan sahay. ");
INSERT INTO som_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Reer binu Israa'iil intay dalka Masar qariib ku ahaayeen waxay ahayd afar boqol iyo soddon sannadood. ");
INSERT INTO som_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Oo markii afartii boqol iyo soddonkii sannadood dhammaadeen, isla maalintaas ayaa Rabbiga dadkiisii badnaa oo dhammu ka baxay dalkii Masar. ");
INSERT INTO som_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Habeenkaasu waa habeen aad Rabbiga loogu dhawro, bixintii uu iyaga Masar ka soo bixiyey aawadeed; kaasu waa habeenkii Rabbiga oo ay reer binu Israa'iil oo dhammu ka ab ka ab aad u dhawraan. ");
INSERT INTO som_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Markaasaa Rabbigu wuxuu Muuse iyo Haaruun ku yidhi, Kanu waa amarkii iidda Kormaridda; shisheeyuhuna yuusan wax ka cunin; ");
INSERT INTO som_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","laakiinse nin kasta addoonkiisa uu lacagta ku iibsaday, markaad guddo dabadeed waa inuu wax ka cunaa. ");
INSERT INTO som_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Kii qariib ah iyo midiidinka la soo kiraystay toona midkoodna waa inuusan wax ka cunin. ");
INSERT INTO som_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Oo waa in isku guri lagu cuno; oo waa inaadan hilibka waxba dibadda uga bixin; lafna waa inaydnaan ka jebin. ");
INSERT INTO som_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Oo shirka reer binu Israa'iil oo dhammu waa inuu dhawro. ");
INSERT INTO som_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Oo haddii mid qariib ahu idinla dego, oo uu doonayo inuu Rabbiga u dhawro iidda Kormaridda, de waa in intiisa lab oo dhan la wada gudaa, oo markaas ha soo dhowaado oo ha dhawro, oo markaas wuxuu noqon doonaa sidii mid dalka ku dhashay; laakiinse qof buuryoqab ahu waa inuusan wax ka cunin. ");
INSERT INTO som_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Kan waddanka ku dhashay iyo kan qariibka ah oo idin dhex degganu waa inay isku sharci ahaadaan. ");
INSERT INTO som_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Sidaasay reer binu Israa'iil oo dhammu yeeleen; sidii Rabbigu Muuse iyo Haaruun ku amray ayay yeeleen. ");
INSERT INTO som_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Oo isla maalintaasaa Rabbigu reer binu Israa'iil uga bixiyey dalkii Masar, siday guutooyinkoodii ahaayeen. ");
INSERT INTO som_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Markaasaa Rabbigu Muuse la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","Curadyada oo dhan quduus iiga dhig; wax alla wixii maxal fura oo ku dhex jira reer binu Israa'iil, dad iyo duunyoba, anigaa iska leh. ");
INSERT INTO som_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Markaasaa Muuse wuxuu dadkii ku yidhi, Xusuusta maalintan aad Masar ka soo baxdeen, oo aad ka soo baxdeen gurigii addoonsiga; waayo, Rabbigu gacan xoog badan buu idinkaga soo bixiyey meeshan; waa inaan kibis khamiirsan la cunin. ");
INSERT INTO som_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Idinku waxaad baxdeen maanta oo ah bisha Aabiib. ");
INSERT INTO som_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Oo markii Rabbigu idin geeyo dalka reer Kancaan iyo reer Xeed, iyo reer Amor, iyo reer Xiwi, iyo reer Yebuus, oo uu awowayaashiin ugu dhaartay inuu idin siinayo, kaas oo ah dal caano iyo malab la barwaaqaysan, de markaas waa inaad bishan dhexdeeda dhawrtaan u adeegiddan Ilaah. ");
INSERT INTO som_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Toddoba maalmood waa inaad kibis aan khamiir lahayn cuntaan, oo maalinta toddobaad waa inay iid Rabbiga u ahaato. ");
INSERT INTO som_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Oo kibis aan khamiir lahayn waa in la cunaa toddobada maalmood oo dhan; oo waa inaan lagugu arag kibis khamiirsan, ama waa inaan xataa lagugu arag khamiir, tan iyo xudduudkaaga oo dhan. ");
INSERT INTO som_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Maalintaas waa inaad wiilkaaga u sheegtaa, oo waxaad ku tidhaahdaa, Waa wixii Rabbigu ii sameeyey aawadood markii aan Masar ka soo baxay. ");
INSERT INTO som_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Oo waxay kuu noqon doontaa calaamo gacantaada saaran, iyo xusuus indhahaaga u dhaxaysa, in Rabbiga sharcigiisu afkaaga ku jiro; waayo, Rabbigu gacan xoog leh buu kaaga soo bixiyey dalkii Masar. ");
INSERT INTO som_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Sidaas daraaddeed waa inaad amarkan haysaa xilligiisa, oo aad dhawrtaa sannad ilaa sannad. ");
INSERT INTO som_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Oo markii Rabbigu ku geeyo dalka reer Kancaan siduu ugu dhaartay adiga iyo awowayaashaaba, oo uu ku siiyo, ");
INSERT INTO som_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","de markaas waa inaad Rabbiga gooni ugu soocdaa kulli intii maxal furta oo dhan iyo intii xoolaha curad ah, mid kasta oo lab ah Rabbigu waa iska lahaan doonaa. ");
INSERT INTO som_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Oo curad kasta oo dameer ah waa inaad ku madax furtaa wan yar; oo haddii aadan doonaynin inaad madax furto, de markaas waa inaad luqunta ka jebisaa, oo dadkaaga curadyadiisa oo dhan waa inaad wax ku madax furtaa. ");
INSERT INTO som_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Oo dabadeedto markii wiilkaagu wax ku weyddiiyo oo kugu yidhaahdo, Waxanu waa maxay? waa inaad ku tidhaahdaa isaga, Gacan xoog badan baa Rabbigu nagaga soo bixiyey Masar oo ahaa gurigii addoonsiga; ");
INSERT INTO som_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","oo markii Fircoon dooni waayay inuu na sii daayo, waxaa dhacday inuu Rabbigu wada laayay curadyadii Masar oo dhan oo ahaa curadyadii dadka iyo curadyadii duunyadaba; oo sidaas daraaddeed baan Rabbiga allabari ugu bixiyaa wax alla wixii maxal fura oo dhan, ee ah inta lab, laakiinse dadkayga curadyadiisa oo dhan wax baan ku madax furtaa. ");
INSERT INTO som_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Oo waxay kuu noqon doontaa calaamo gacantaada saaran, iyo wax ka laalaada indhahaaga dhexdooda; waayo, Rabbigu gacan xoog badan buu Masar nagaga soo bixiyey. ");
INSERT INTO som_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Oo markii Fircoon dadkii sii daayay, Ilaah kuma uu kaxayn jidka dalka reer Falastiin in kastoo uu kaasu dhowaa, waayo, Ilaah wuxuu yidhi, Waaba intaasoo dadku markay dagaal arkaan ay qoomameeyaan, oo ay Masar dib ugu noqdaan. ");
INSERT INTO som_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Laakiinse Ilaah wuxuu dadkii u hor kacay waddada la wareegta cidlada ku ag taal Badda Cas; reer binu Israa'iilna waxay Masar ka bexeen iyagoo hubkoodii sita. ");
INSERT INTO som_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Markaasaa Muuse wuxuu qaaday lafihii Yuusuf; waayo, Yuusuf aad buu ugu dhaartay reer binu Israa'iil, oo wuxuu ku yidhi, Hubaal Ilaah waa idin soo booqan doonaa; ee lafahayga waa inaad halkan ka qaaddaan. ");
INSERT INTO som_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Oo waxay sodcaalkoodii ka bilaabeen Sukod, oo waxay degeen Eetaam, oo ku taal cidlada qarkeeda. ");
INSERT INTO som_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Rabbiguna inuu iyaga jidka tuso aawadeed ayuu maalintii hortooda socon jiray isagoo ku jira tiir daruur ah, habeenkiina tiir dab ah, inuu iyaga u iftiimiyo si ay u socdaan hadh iyo habeenba. ");
INSERT INTO som_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Tiirkii daruurta ahaa oo maalinta, iyo tiirkii dabka ahaa oo habeenka kama tegin dadka hortiisa. ");
INSERT INTO som_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Markaasaa Rabbigu la hadlay Muuse, oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","La hadal reer binu Israa'iil oo u sheeg inay dib u soo noqdaan oo ay degaan meel ka horraysa Fiihaahiirod, oo u dhaxaysa Migdol iyo badda, kana horraysa Bacal Sefoon. Horteeda oo meel badda agteeda ah waa inaad degtaan. ");
INSERT INTO som_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Oo Fircoon wuxuu wax ka sheegi doonaa reer binu Israa'iil, oo odhan doonaa, Dhulkaa murgiyey, oo cidladaa xidhay iyagii. ");
INSERT INTO som_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Oo anna waxaan qallafin doonaa Fircoon qalbigiisa, oo isna wuu soo raacdaysan doonaa iyaga; markaasaan Fircoon iyo ciidankiisaba ciso ka heli doonaa; Masriyiintuna waxay ogaan doonaan inaan anigu ahay Rabbiga. Oo iyana sidii bay yeeleen. ");
INSERT INTO som_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Oo waxaa loo sheegay boqorkii Masar inay dadkii carareen; markaasaa Fircoon iyo addoommadiisii qalbigoodii wuxuu u rogmaday xaggii dadka, oo waxay yidhaahdeen, Waxan aynu samaynay waa maxay, oo maxaynu reer binu Israa'iil uga sii daynay adeegiddii ay inoo adeegi jireen? ");
INSERT INTO som_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Markaasuu wuxuu diyaarsaday gaadhifaraskiisii, oo wuxuu watay dadkiisii; ");
INSERT INTO som_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Oo wuxuu kaxaystay lix boqol oo gaadhifaras ah oo la doortay, iyo gaadhifardoodkii Masar oo dhan, iyo saraakiil u sarraysa kulligood. ");
INSERT INTO som_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Markaasaa Rabbigu qallafiyey qalbigii boqorkii Masar oo Fircoon ahaa; kolkaasuu wuxuu raacdaystay reer binu Israa'iil; waayo, reer binu Israa'iil waxay ku bexeen gacan sarraysa. ");
INSERT INTO som_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Markaasaa Masriyiintii iyagii raacdaysteen. Kulli Fircoon fardihiisii iyo gaadhifardoodkiisii oo dhan, iyo fardooleydiisii, iyo ciidankiisii ayaa raacdeeyey, oo waxay gaadheen iyagoo deggan meel badda u dhow, oo Fiihaahiirod dhinaceeda ah, kana horraysa Bacal Sefoon. ");
INSERT INTO som_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Oo markii Fircoon soo dhowaaday, ayaa reer binu Israa'iil indhaha kor u taageen, oo waxay arkeen Masriyiintii oo soo daba socota; markaasay aad iyo aad u cabsadeen, oo reer binu Israa'iil ayaa Rabbiga u qayshaday. ");
INSERT INTO som_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Oo waxay Muuse ku yidhaahdeen, War ma xabaalaan jirin Masar, oo sidaa aawadeed aad noogu soo kaxaysay cidlada inaannu ku dhimanno? Maxaad sidan noogu gashay oo aad Masar nooga soo saartay? ");
INSERT INTO som_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Sow erayganu ma aha kii aannu kugula hadalnay Masar dhexdeeda, annagoo ku leh, Iska kaaya daa, aannu Masriyiinta u addeegnee? Waayo, waxaa noo wanaagsanaan lahayd inaannu Masriyiinta u adeegno, intii aannu cidlada ku dhiman lahayn. ");
INSERT INTO som_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Markaasaa Muuse wuxuu dadkii ku yidhi, War ha cabsanina, oo iska taagnaada, oo bal arka badbaadada uu Rabbigu maanta idiin samayn doono; waayo, Masriyiinta aad maanta aragteen, weligiin mar dambe ma arki doontaan. ");
INSERT INTO som_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Oo Rabbigu aawadiin buu u diriri doonaa, oo idinku waa inaad iska aamusnaataan. ");
INSERT INTO som_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Markaasaa Rabbigu wuxuu Muuse ku yidhi, War maxaad iigu qaylinaysaa? Reer binu Israa'iil u sheeg inay hore u socdaan. ");
INSERT INTO som_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Oo adigu ushaada kor u qaad, oo gacanta badda ku kor fidi, oo kala goo; oo reer binu Israa'iil waxay mari doonaan badda dhexdeeda oo ay ku socon doonaan dhul engegan. ");
INSERT INTO som_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Oo bal ogow, anigu waxaan qallafin doonaa qalbiga Masriyiinta, oo iyagay daba geli doonaan; oo markaasaan ciso ka heli doonaa Fircoon, iyo ciidankiisa oo dhan, iyo gaadhifardoodkiisa, iyo fardooleydiisa. ");
INSERT INTO som_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Oo Masriyiintu markaasay garan doonaan inaan anigu Rabbiga ahay, kolkii aan sharaf ka helo Fircoon, iyo gaadhifardoodkiisa, iyo fardooleydiisa. ");
INSERT INTO som_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Markaasaa malaa'igtii Ilaah oo hor socotay reer binu Israa'iil soo wareegtay oo daba martay iyagii, markaasaa tiirkii daruurta ahaa ka soo hor wareegay oo uu daba maray iyagii; ");
INSERT INTO som_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","oo wuxuu kala dhex galay reer Masar iyo reer binu Israa'iil; oo waxaa jiray daruur iyo gudcur, laakiinse weliba habeennimadii wuu iftiimay; oo habeenkii oo dhan midna uma soo dhowaan ka kale. ");
INSERT INTO som_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Markaasaa Muuse gacantii baddii ku kor fidiyey, oo habeenkii oo dhan Rabbigu wuxuu baddii dib ugu celiyey dabayl xoog badan oo bari ka timid, oo wuxuu baddii ka dhigay dhul engegan, oo biyihiina way kala go'een. ");
INSERT INTO som_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Markaasaa reer binu Israa'iil baddii dhex mareen, oo waxay ku socdeen dhul engegan, oo biyihiina waxay iyagii u ahaayeen derbi xagga midigta iyo xagga bidixdaba. ");
INSERT INTO som_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Markaasaa Masriyiintiina soo eryadeen, oo intay soo daba galeen ayay waxay mareen badda dhexdeeda, oo waxayna ahaayeen Fircoon fardihiisii iyo gaadhifardoodkiisii, iyo fardooleydiisii oo dhan. ");
INSERT INTO som_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Oo markii waagii beryay waxaa dhacday in Rabbigu ciidankii Masriyiinta ka dhex fiiriyey tiirkii dabka ahaa iyo kii daruurta ahaa, kolkaasuu kadeeday ciidankii Masriyiinta. ");
INSERT INTO som_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Kolkaasuu giringirihii gaadhifardoodkooda xidhay, inay si dhib leh u kexeeyaan; markaasay Masriyiintii waxay yidhaahdeen, Reer binu Israa'iil hortooda aynu ka cararno; waayo, Rabbigu waa u dirirayaa iyaga oo uga hiilinayaa Masriyiinta. ");
INSERT INTO som_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Markaasaa Rabbigu wuxuu Muuse ku yidhi, Badda gacanta ku kor fidi, inay biyuhu ku soo noqdaan Masriyiinta, iyo gaadhifardoodkooda, iyo fardooleydooda. ");
INSERT INTO som_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Markaasaa Muuse gacantii badda ku kor fidiyey, oo markii waagii beryay ayaa baddii xooggeedii hore ku soo noqotay, markaasaa Masriyiintiina ka carareen; kolkaasaa Rabbigu wuxuu Masriyiintii ku tuuray badda dhexdeedii. ");
INSERT INTO som_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Markaasaa biyihii isku soo noqdeen, oo waxay qariyeen gaadhifardoodkii, iyo fardooleydii, iyo xataa ciidankii Fircoon oo dhan oo badda dhexdeeda reer binu Israa'iil ku eryaday, oo xataa midna kama hadhin. ");
INSERT INTO som_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Laakiinse reer binu Israa'iil waxay ku socdeen dhul engegan oo badda dhexdeeda ah, biyihiina waxay iyagii u ahaayeen derbi xagga midigta iyo xagga bidixdaba. ");
INSERT INTO som_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Oo sidaasaa Rabbigu reer binu Israa'iil uga badbaadiyey gacantii Masriyiinta; oo reer binu Israa'iilna waxay arkeen Masriyiintii oo dhimatay oo badda xeebteeda taal. ");
INSERT INTO som_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Markaasaa reer binu Israa'iil waxay arkeen shuqulkii weynaa oo Rabbigu ku sameeyey Masriyiintii, kolkaasay dadkii Rabbiga ka cabsadeen, oo waxay rumaysteen Rabbiga iyo addoonkiisii Muuse. ");
INSERT INTO som_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Markaasaa Muuse iyo reer binu Israa'iil waxay Rabbiga ugu gabyeen gabaygan, oo intay qaadeen, bay yidhaahdeen, Anigu Rabbiga waan u gabyi doonaa, waayo, ammaan buu ku guulaystay; Faraskii iyo kii fuushanaaba wuxuu ku tuuray badda. ");
INSERT INTO som_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Rabbigu waa xooggayga iyo gabaygayga, Oo isagu wuxuu noqday badbaadadayda. Kanu waa Ilaahay, oo anigu waan ammaani doonaa isaga; Waa Ilaahii aabbahay, aniguna waan sarraysiin doonaa. ");
INSERT INTO som_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Rabbigu waa dagaalyahan, Magiciisuna waa Rabbi. ");
INSERT INTO som_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Wuxuu Fircoon gaadhifardoodkiisii iyo ciidankiisiiba ku tuuray badda dhexdeeda, Oo saraakiishiisii la doortayna waxay tiimbadeen Badda Cas dhexdeeda. ");
INSERT INTO som_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Oo waxaa iyagii qariyey moolkii, Oo moolkay dhex tiimbadeen sidii dhagax oo kale. ");
INSERT INTO som_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Rabbiyow, gacantaada midig xoog bay ammaan ku leedahay, Rabbiyow, gacantaada midig cadowga bay burburisaa. ");
INSERT INTO som_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Oo mudnaantaada weynaanteeda ayaad ku jebisaa kuwa adiga kugu kaca. Oo waxaad soo dirtaa cadhadaada, kolkaasay iyaga u gubtaa sidii jirrido yaryar oo jajab ah. ");
INSERT INTO som_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Oo neeftii sankaaga aawadeed ayaa biyihii isdul rasaysmeen, Daadkiina kor buu u kacay sidii taallo; Moolkiina wuxuu ku adkaaday badda dhexdeeda. ");
INSERT INTO som_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Oo cadowgii wuxuu yidhi, Anigu waan eryan doonaa, anigu waan gaadhi doonaa, boolida waan kala qaybin doonaa. Oo damacaygu waa ka dhergi doonaa iyaga; Oo seeftaydaan galka kala bixi doonaa, gacantayduna way baabbi'in doontaa iyaga. ");
INSERT INTO som_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Adigu dabayshaadii baad ku afuuftay, oo baddii baa qarisay iyagii; Oo sidii laxaamad oo kale ayay u dhex tiimbadeen biyihii xoogga badnaa. ");
INSERT INTO som_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Rabbiyow, adiga bal yaa kula mid ah ilaahyada dhexdooda? Bal yaa adiga kula mid ah oo quduusnimada ammaan ku leh, Oo ammaantiisa laga cabsadaa, oo cajaa'ibyo sameeya? ");
INSERT INTO som_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Adigu gacantaadii midig baad soo fidisay, Markaasaa dhulku liqay iyagii. ");
INSERT INTO som_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Oo raxmaddaadaad ku soo hor kacday dadkii aad soo madax furatay. Oo waxaad iyagii ku soo hor kacday xooggaaga, waxaadna u soo wadday rugtaada quduuska ah. ");
INSERT INTO som_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Oo dadyowgii baa maqlay, wayna gariireen. Kuwii Falastiin degganaana waxay noqdeen sidii dumar fool qabatay. ");
INSERT INTO som_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Markaasay ugaasyadii reer Edom yaabeen; Raggii xoogga weynaa oo Moo'aabna gariir baa qabtay. Dadkii Kancaan degganaa oo dhammuna way dhalaaleen. ");
INSERT INTO som_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Oo cabsi iyo naxdin baa ku dhacay iyagii. Oo gacantaada weynaanteeda aawadeed ayay sidii dhagax oo kale u aamuseen, Ilaa ay dadkaagu gudbeen, Rabbiyow, Ilaa ay dadkii aad soo iibsatay gudbeen. ");
INSERT INTO som_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Iyaga gudahaad soo gelin doontaa, oo waxaad ku beeri doontaa buurta dhaxalkaaga, Taasoo ah meesha aad u samaysatay inaad degganaatid, Rabbiyow, Waana meesha quduuska ah oo gacmahaagu diyaariyeen. ");
INSERT INTO som_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Rabbigu boqor buu ahaan doonaa weligiis iyo weligiisba. ");
INSERT INTO som_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Waayo, Fircoon fardihiisii waxay baddii la galeen gaadhifardoodkiisii, iyo fardooleydiisii, oo Rabbigu biyihii badda ayuu dushooda ku soo celiyey; laakiinse reer binu Israa'iil waxay ku socdeen dhul engegan oo badda dhexdeeda ah. ");
INSERT INTO som_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Markaasaa Maryan oo nebiyad ahayd, Haaruunna walaashiis ahayd, ayaa waxay gacanteeda ku qaadatay daf; kolkaasaa dumarkii oo dhammu ka daba yaaceen iyagoo cayaaraya oo dafaf wata. ");
INSERT INTO som_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Markaasaa Maryan waxay ugu celisay iyagii, War Rabbiga u gabya, waayo, ammaan buu ku guulaystay; Oo faraskii iyo kii fuushanaaba wuxuu ku tuuray badda. ");
INSERT INTO som_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Markaasaa Muuse reer binu Israa'iil hore uga sii kexeeyey Badda Cas, oo waxay tageen cidlada Shuur la yidhaahdo; oo waxay cidlada ku dhex soconayeen saddex maalmood, oo biyona ma ay helin. ");
INSERT INTO som_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Oo markii ay yimaadeen Maaraah, way cabbi kari waayeen biyihii Maaraah, waayo, way qadhaadhaayeen, oo sidaas daraaddeed magaceedii waxaa loo bixiyey Maaraah. ");
INSERT INTO som_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Markaasay dadkii Muuse u gunuuseen, oo waxay yidhaahdeen, Bal maxaannu cabnaa? ");
INSERT INTO som_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Kolkaasuu Rabbiga u qayshaday, oo Rabbigu wuxuu tusay geed, geedkiina wuu ku dhex tuuray biyihii, markaasaa biyihii macaan noqdeen. Oo meeshaas buu wuxuu ugu sameeyey qaynuun iyo amar, oo meeshaas buu ku tijaabiyey iyagii; ");
INSERT INTO som_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","oo wuxuu ku yidhi, Haddaad aad u dhegaysatid Rabbiga Ilaahaaga ah codkiisa, oo aad samaysid wixii ku hagaagsan indhihiisa hortooda, oo aad dhegta u dhigtid amarradiisa, oo aad dhawrtid qaynuunnadiisii oo dhan, de markaas anigu kugu ridi maayo cudurradii aan Masriyiinta ku riday midnaba; waayo, anigu waxaan ahay Rabbiga ku bogsiiya. ");
INSERT INTO som_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Markaasay waxay yimaadeen meel la yidhaahdo Eelim, oo meeshaas waxaa ku yiil laba iyo toban ilood oo biyo ah, iyo toddobaatan geed oo timir ah, oo halkaasay degeen biyaha agtooda. ");
INSERT INTO som_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Markaasay ka ambabbexeen Eelim, oo shirkii reer binu Israa'iil oo dhammu waxay yimaadeen cidlada Siin la yidhaahdo, taasoo u dhaxaysa Eelim iyo Siinay, waxayna ahayd bishii labaad, maalinteedii shan iyo tobnaad, taasoo ka dambaysay baxniintii ay Masar ka soo bexeen. ");
INSERT INTO som_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Markaasaa shirkii reer binu Israa'iil oo dhammu cidladii Muuse iyo Haaruun ugu gunuuseen. ");
INSERT INTO som_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Oo reer binu Israa'iilna waxay iyagii ku yidhaahdeen, Waxaa noo wanaagsanaan lahayd inaannu gacanta Rabbiga ku dhimanno, annagoo dalkii Masar joogna, intii aannu ag fadhinnay dheryaha hilibka ah, oo aannu kibis ka dhergaynay, waayo, waxaad cidladan noogu soo bixiseen inaad ururkan oo dhan gaajo ku dishaan. ");
INSERT INTO som_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Markaasaa Rabbigu wuxuu Muuse ku yidhi, Bal eeg, waxaan samada idiinka soo dayn doonaa kibis, oo dadku waa inay dibadda u baxaan oo maalin walba soo urursadaan in maalin ku filan, si aan u tijaabiyo iyaga, bal inay sharcigayga ku socdaan iyo in kale. ");
INSERT INTO som_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Oo maalinta lixaad waa inay diyaarsadaan wixii ay soo gurteen, kolkaasay noqon doontaa intii ay maalin walba guran jireen in labanlaabkeed ah. ");
INSERT INTO som_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Markaasaa Muuse iyo Haaruun waxay reer binu Israa'iil oo dhan ku yidhaahdeen, Makhribka baad ogaan doontaan inuu Rabbigu idinka soo bixiyey dalkii Masar, ");
INSERT INTO som_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","oo subaxdana waxaad arki doontaan ammaantii Rabbiga, waayo, wuu maqlayaa gunuuskiinna aad Rabbiga u gunuusaysaan. Oo annagu maxaannu nahay oo aad noogu gunuusaysaan? ");
INSERT INTO som_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Markaasaa Muuse wuxuu yidhi; Rabbigu makhribka wuxuu idin siin doonaa hilib aad cuntaan, subaxdana wuxuu idin siin doonaa kibis aad ka dheregtaan; maxaa yeelay, Rabbigu wuxuu maqlayaa gunuuskiinna aad isaga u gunuusaysaan. Bal maxaannu annagu nahay? Annaga noo gunuusi maysaane, ee waxaad u gunuusaysaan Rabbiga. ");
INSERT INTO som_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Markaasaa Muuse wuxuu Haaruun ku yidhi, Shirka reer binu Israa'iil oo dhan waxaad ku tidhaahdaa, Rabbiga hortiisa ku soo dhowaada; waayo, wuu maqlay gunuuskiinnii. ");
INSERT INTO som_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Intii Haaruun la hadlayay shirkii reer binu Israa'iil oo dhan waxay eegeen xaggii cidlada, oo bal eeg, ammaantii Rabbiga ayaa daruurtii ka dhex muuqatay. ");
INSERT INTO som_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Markaasaa Rabbigu Muuse la hadlay, oo wuxuu isagii ku yidhi, ");
INSERT INTO som_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","Anigu waan maqlay gunuuskii reer binu Israa'iil; haddaba la hadal, oo waxaad ku tidhaahdaa, Makhribka waxaad cuni doontaan hilib, subaxdana waxaad ka dhergi doontaan kibis; oo waad ogaan doontaan inaan anigu ahay Rabbiga Ilaahiinna ah. ");
INSERT INTO som_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Oo waxaa dhacday in makhribkii digaagduur yimaadeen oo ay xeradii oo dhan qariyeen, oo subaxdiina waxaa degmadii hareeraheeda ku soo degay sayax. ");
INSERT INTO som_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Oo markii sayaxii soo degay baabba'ay ayaa waxaa dhulkii cidlada ku hadhay wax yaryar oo goobaaban oo laale'eg sayax barafoobay. ");
INSERT INTO som_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Oo markay reer binu Israa'iil arkeen ayaa midkoodba ka kale ku yidhi, Maxay tahay? Waayo, ma ay garanayn waxay tahay. Kolkaasaa Muuse wuxuu iyagii ku yidhi, Tanu waa kibistii Rabbigu idiin siiyey inaad cuntaan. ");
INSERT INTO som_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Waxanu waa wixii Rabbigu idinku amray, Nin waluba ha ka gurto in cuntadiisa ugu filan, inta dadkiinna tiradiisu tahay, qofkiiba comer muggiis ha qaato, oo nin waluba inta teendhadiisa joogta ha u qayb qaado. ");
INSERT INTO som_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Oo reer binu Israa'iil sidaasay yeeleen, oo qaarna wax badan buu soo gurtay, qaarna wax yar. ");
INSERT INTO som_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Oo markay comerkii ku qiyaaseen, kii wax badan soo gurtay waxba kama hadhin, kii wax yar soo gurtayna waxba kama dhinmin, oo nin waluba in cuntadiisa ugu filan buu soo gurtay. ");
INSERT INTO som_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Markaasaa Muuse wuxuu iyagii ku yidhi, Ninna yuusan wax ka reebin ilaa subaxda. ");
INSERT INTO som_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Habase yeeshee Muuse ma ay dhegaysan, laakiinse qaarkood baa wax ka reebay ilaa subaxdii, kolkaasaa dirxi galay, oo ay urtay. Markaasaa Muusena iyagii u cadhooday. ");
INSERT INTO som_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Oo subax kasta nin waluba wuxuu guran jiray in cuntadiisa ugu filan; oo markii qorraxdu soo kululaatana, way dhalaali jirtay. ");
INSERT INTO som_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Oo maalintii lixaad waxay soo gurteen kibistii hore labanlaabkeed, qof waluba wuxuu soo gurtay laba comer, markaasaa taliyayaashii shirka oo dhammu intay u yimaadeen Muuse u sheegeen. ");
INSERT INTO som_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Kolkaasuu wuxuu iyagii ku yidhi, Waxanu waa wixii Rabbigu ku hadlay, Berri waa maalin weyn oo nasasho ah, oo waa sabti quduus u ah Rabbiga. Wixii aad duban lahaydeen dubta, oo wixii aad karin lahaydeen kariya, oo wax alla wixii idiin hadha meel dhigta oo ha idiin yaalleen ilaa subaxda. ");
INSERT INTO som_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Kolkaasay meel dhigteen ilaa subaxdii, sidii Muuse ku amray; oo mana ay urin, dirxina laguma arag. ");
INSERT INTO som_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Markaasaa Muuse wuxuu yidhi, Intan maanta cuna; waayo, maanta waa maalin sabti u ah Rabbiga; oo maanta waxba duurka ka heli maysaan. ");
INSERT INTO som_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Lix maalmood waa inaad soo gurataan, laakiinse maalinta toddobaad waa sabtida, oo maalintaas waxba ma jiri doonaan innaba. ");
INSERT INTO som_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Oo waxaa dhacday maalintii toddobaad inay dadkii qaarkood dibadda u bexeen inay wax soo gurtaan, laakiinse waxba ma ay helin. ");
INSERT INTO som_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Markaasaa Rabbigu wuxuu Muuse ku yidhi, Ilaa goormaad diidaysaan inaad dhawrtaan amarradayda iyo qaynuunnadayda? ");
INSERT INTO som_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Bal eega, Rabbigu wuxuu idin siiyey sabtida, oo sidaas daraaddeed buu isagu maalintii lixaad idiin siiyey kibis laba maalmood idinku filan; haddaba nin kasta oo idinka mid ahu meeshiisa ha joogo, oo maalinta toddobaad ninna yuusan meeshiisa ka bixin. ");
INSERT INTO som_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Oo sidaas daraaddeed baa dadkii maalintii toddobaad u nasteen. ");
INSERT INTO som_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Oo reer binu Israa'iil waxay magaceedii u bixiyeen Maanna; oo waxay u caddayd sida midhaha koryander la yidhaahdo, waxayna u dhadhan ekayd sidii buskud malab lagu sameeyey. ");
INSERT INTO som_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Markaasaa Muuse wuxuu yidhi, Waxanu waa wixii Rabbigu idinku amray, oo wuxuu yidhi, Comer muggiis ha loo dhigo farcankiinna dambe, inay arkaan kibistii aan idinku masruufi jiray markaad cidlada joogteen oo aan dalkii Masar idinka soo bixiyey. ");
INSERT INTO som_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Markaasaa Muuse wuxuu Haaruun ku yidhi, Weel qaado oo waxaad ku shubtaa comer muggiis oo Maanna ah, oo Rabbiga hor dhig in loo hayo farcankiinna dambe. ");
INSERT INTO som_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Sidii Rabbigu Muuse ku amray ayaa Haaruun Maragga hortiis u dhigay, in loo hayo aawadeed. ");
INSERT INTO som_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Oo reer binu Israa'iil waxay maannadii cunayeen afartan sannadood, ilaa ay yimaadeen dhul la deggan yahay. Waxay cuni jireen maannadii ilaa ay yimaadeen dalkii reer Kancaan xadkiisii. ");
INSERT INTO som_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Comer waa eefaah toban meelood loo dhigay meeshiis. ");
INSERT INTO som_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Oo markaasaa shirkii reer binu Israa'iil oo dhammu waxay ka sodcaaleen cidlada Siin la yidhaahdo, oo waxay u socdeen sidii Rabbigu ku amray, kolkaasay waxay degeen meel la yidhaahdo Refiidiim; oo dadkuna ma ay haysan biyo ay cabbaan. ");
INSERT INTO som_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Sidaas daraaddeed dadkii waxay la dirireen Muuse, oo waxay ku yidhaahdeen, War biyo aannu cabno na sii. Kolkaasaa Muuse wuxuu iyagii ku yidhi, Bal maxaad aniga iila diriraysaan? Oo maxaad Rabbiga u jirrabaysaan? ");
INSERT INTO som_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Markaasay dadkii meeshaas biyo ugu harraadeen; kolkaasaa dadkii intay Muuse u gunuuseen ayay waxay ku yidhaahdeen, War maxaad Masar nooga soo kaxaysay? Ma inaad annaga iyo carruurtayada, iyo xoolahayaga harraad noogu disha baa? ");
INSERT INTO som_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Kolkaasaa Muuse Rabbiga u qayshaday oo ku yidhi, Bal maxaan dadkan ku sameeyaa? Waayo, waxay ku dhow yihiin inay i dhagxiyaan. ");
INSERT INTO som_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Markaasaa Rabbigu wuxuu Muuse ku yidhi, Bal dadka ka hor mar, oo waxaad kaxaysataa waayeellada reer binu Israa'iil, ushaadii aad webiga ku dhufatayna gacanta ku qabso oo tag. ");
INSERT INTO som_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Oo bal ogow, halkaas ayaan hortaada isku dul taagi doonaa dhagaxa weyn oo Xoreeb yaal, kolkaas waa inaad dhagaxa ushaada ku dhufataa, oo waxaa halkaas ka iman doona biyo ay dadku cabbaan. Kolkaasaa Muuse sidaas ku sameeyey waayeelladii reer binu Israa'iil hortooda. ");
INSERT INTO som_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Markaasuu meeshaas magaceedii wuxuu u bixiyey Masaah iyo Meriibaah, dirirtii ay reer binu Israa'iil dirireen aawadeed, iyo jirrabaaddii ay Rabbiga jirrabeen aawadeed, oo ay yidhaahdeen, War, Rabbigu ma na dhex joogaa mise nama dhex joogo? ");
INSERT INTO som_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Markaasaa waxaa yimid reer Camaaleq, oo wuxuu reer binu Israa'iil kula diriray Refiidiim. ");
INSERT INTO som_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Markaasaa Muuse wuxuu Yashuuca ku yidhi, Rag inoo dooro, oo la bax, oo reer Camaaleq la dirir. Berrito waxaan istaagi doonaa buurta dusheeda, anigoo gacanta ku haysta ushii Ilaah. ");
INSERT INTO som_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Kolkaasaa Yashuuca yeelay sidii Muuse ku yidhi, oo wuxuu la diriray reer Camaaleq. Markaasaa Muuse iyo Haaruun iyo Xuur waxay koreen ilaa buurta dusheedii. ");
INSERT INTO som_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Oo markii Muuse gacanta kor u taagayba, waxaa adkaaday reer binu Israa'iil; markuu gacanta dejiyeyna, waxaa adkaaday reer Camaaleq. ");
INSERT INTO som_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Laakiinse Muuse gacmihiisu way cuslaayeen; kolkaasay waxay soo qaadeen dhagax, oo Muuse u saldhigeen, isna kolkaasuu ku fadhiistay; Haaruun iyo Xuurna gacmihiisii bay sare u hayeen, intuu midba dhinac ka maray, oo gacmihiisiina way xoogeeyeen ilaa ay qorraxdii dhacday. ");
INSERT INTO som_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Oo Yashuucana seef afkeed buu ku jebiyey reer Camaaleq iyo dadkiisiiba. ");
INSERT INTO som_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Markaasaa Rabbigu wuxuu Muuse ku yidhi, Waxan buug ku qor si loo xusuusto, oo Yashuuca dhegihiisa maqashii, waayo, xusuusta reer Camaaleq lagu xusuusan jiray ayaan inta samada ka hoosaysa oo dhan ka baabbi'inayaa. ");
INSERT INTO som_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Markaasaa Muuse wuxuu dhisay meel allabari, oo magaceedii wuxuu u bixiyey Yehowah Nisii, ");
INSERT INTO som_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","oo wuxuu yidhi, Rabbigu waa dhaartay, oo Rabbigu wuu la dagaallami doonaa reer Camaaleq ka ab ka ab. ");
INSERT INTO som_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Haddaba wadaadkii Midyaan oo Yetroo ahaa, Muusena soddog u ahaa, ayaa wuxuu maqlay kulli wixii Rabbigu u sameeyey Muuse iyo dadkiisa reer binu Israa'iil, iyo sidii Rabbigu reer binu Israa'iil uga soo bixiyey dalkii Masar. ");
INSERT INTO som_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Markaasaa Yetroo oo Muuse soddog u ahaa ayaa wuxuu soo kexeeyey naagtii Muuse oo ahayd Siforaah, markuu iska diray dabadeed, ");
INSERT INTO som_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","iyadii iyo labadeedii wiilba, oo midkood magiciisu wuxuu ahaa Gershoom, waayo, wuxuu yidhi, Qariib baan ku ahaa dal qalaad, ");
INSERT INTO som_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","midka kalena magiciisuna wuxuu ahaa Eliiceser; waayo, wuxuu yidhi, Ilaahii aabbahay baa i caawiyey, oo wuxuu iga samatabbixiyey seeftii Fircoon. ");
INSERT INTO som_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Markaasaa Yetroo oo Muuse soddog u ahaa ayaa Muuse ugu yimid cidladii ay degeen oo buurtii Ilaah agteeda ahayd isagoo wada wiilashiisii iyo naagtiisii. ");
INSERT INTO som_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Markaasuu wuxuu Muuse ku yidhi, Anigoo ah Yetroo soddoggaa waan kuu imid aniga iyo naagtaada iyadoo wadata labadeedii wiilba. ");
INSERT INTO som_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Markaasaa Muuse dibadda u baxay inuu ka hor tago soddoggiis, kolkaasuu u sujuuday oo dhunkaday, markaasaa intay iswaraysteen ayay teendhadii soo galeen. ");
INSERT INTO som_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Markaasaa Muuse wuxuu soddoggiis u sheegay kulli wixii Rabbigu ku sameeyey Fircoon iyo Masriyiintii oo uu ugu sameeyey reer binu Israa'iil aawadood, iyo wixii dhib iyaga ku dhacay oo dhan intay soo socdeen, iyo sidii Rabbigu uga samatabbixiyey. ");
INSERT INTO som_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Markaasaa Yetroo ku farxay kulli wanaaggii Rabbigu reer binu Israa'iil u sameeyey oo dhan, iyo bixinta uu ka soo samatabbixiyey gacantii Masriyiinta. ");
INSERT INTO som_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Markaasaa Yetroo wuxuu yidhi, Ammaan waxaa leh Rabbigii idinka soo samatabbixiyey gacantii Masriyiinta, iyo gacantii Fircoon; oo kaasu waa kii dadka ka soo samatabbixiyey gacantii Masriyiinta hoosteeda. ");
INSERT INTO som_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Oo haatan anigu waan ogahay in Rabbigu ka wada weyn yahay ilaahyada oo dhan; waayo, waxyaalihii ay kula macaamiloodeen iyagoo kibirsan aawadeed, isagaa ka sarreeyey. ");
INSERT INTO som_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Markaasaa Yetroo oo Muuse soddog u ahaa ayaa wuxuu qaaday qurbaan la gubo iyo allabaryo. Markaasaa waxaa yimid Haaruun iyo waayeelladii reer binu Israa'iil oo dhan inay Ilaah hortiisa kibis kula cunaan Muuse soddoggiis. ");
INSERT INTO som_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Markaasaa waxaa maalintii dambe dhacday in Muuse u fadhiistay inuu dadkii u kala gar naqo; dadkiina waxay Muuse ag taagnaayeen subaxdii ilaa makhribkii. ");
INSERT INTO som_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Oo Muuse soddoggiis markuu arkay wixii uu dadkii ku sameeyey oo dhan ayuu yidhi, Waa maxay waxan aad dadka ku samaynaysaa? Oo maxaad keligaa u fadhidaa, dadka oo dhammuna kuu ag taagan yahay subaxda ilaa makhribka? ");
INSERT INTO som_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Markaasaa Muuse soddoggiis ku yidhi, Maxaa yeelay, dadku waxay iigu yimaadaan inay Ilaah wax iga weyddiiyaan. ");
INSERT INTO som_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Oo markay wax isu haystaanna anigay ii yimaadaan, oo markaasaan u kala gar naqaa nin iyo deriskiisa, oo waxaan iyaga ogeysiiyaa amarrada Ilaah iyo qaynuunnadiisa. ");
INSERT INTO som_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Markaasaa Muuse soddoggiis wuxuu isaga ku yidhi, War waxaad samaysaa ma wanaagsana. ");
INSERT INTO som_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Waayo, hubaal waad ku daali doontaan, adiga iyo dadka kula joogaaba, maxaa yeelay, waxanu waa kugu culus yihiin adiga; oo ma aad awooddid inaad keli ahaantaa samayso. ");
INSERT INTO som_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Haddaba bal i dhegayso oo waan kula talinayaaye, oo Ilaahna ha kula jiro. Adigu dadka daraaddiis Ilaah u dhowow, oo arrimahoodana Ilaah u keen. ");
INSERT INTO som_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Oo waa inaad iyaga bartaa amarrada iyo qaynuunnada, oo waa inaad iyaga tustaa jidkii ay mari lahaayeen, iyo shuqulkii ay qaban lahaayeen. ");
INSERT INTO som_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Oo weliba waa inaad dadka oo dhan kala soo baxdaa rag karti leh, oo Ilaah ka cabsada, oo daacad ah, oo neceb faa'iidada xaqdarrada ah, oo kuwo caynkaas ah madax uga dhig, inay ahaadaan kuwo kun kun u taliya, iyo kuwo boqol boqol u taliya, iyo kuwo konton konton u taliya, iyo kuwo toban toban u taliya, ");
INSERT INTO som_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","oo kuwaasu dadka ha u gar naqeen had iyo goor, oo waxay noqon doontaa in wixii weyn oo dhan ay adiga kuu keenaan, laakiinse wixii yar oo dhan ay iyagu ka gar naqi doonaan; oo sidaasaa hawshu kaaga yaraan doontaa, oo iyana hawshay kula qaybsan doonaan. ");
INSERT INTO som_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Oo haddaad waxan samaysid, oo haddii Ilaah sidan kugu amro, de markaas waad adkaysan kari doontaa, oo dadkan oo dhammuna meeshooda ayay nabad ku tegi doonaan. ");
INSERT INTO som_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Sidaas daraaddeed Muuse wuu dhegaystay hadalkii soddoggiis, wuuna wada sameeyey wixii uu ku yidhi oo dhan. ");
INSERT INTO som_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Markaasaa Muuse wuxuu reer binu Israa'iil oo dhan ka doortay rag karti leh, oo wuxuu ka dhigay madaxdii dadka, oo ah kuwo kun kun u taliya, iyo kuwo boqol boqol u taliya, iyo kuwo konton konton u taliya, iyo kuwo toban toban u taliya. ");
INSERT INTO som_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Oo dadkay u gar naqi jireen had iyo goorba, oo arrimaha adadagna waxay u keeni jireen Muuse, laakiinse wixii yaryar oo dhan iyagaa ka gar naqi jiray. ");
INSERT INTO som_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Markaasaa Muuse u oggolaaday soddoggiis inuu tago, isna dalkiisii ayuu tegey. ");
INSERT INTO som_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Markii reer binu Israa'iil Masar ka soo bexeen dabadeed, bishii saddexaad, ayay isla maalintaas yimaadeen cidlada Siinay la yidhaahdo. ");
INSERT INTO som_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Oo markay ka soo keceen Refiidiim oo ay yimaadeen cidladii Siinay ayay teendhooyinkoodii cidladii ka dhisteen, oo reer binu Israa'iil halkaasay degeen buurta horteeda. ");
INSERT INTO som_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Muusena kor buu ugu tegey Ilaah, markaasaa Rabbigu buurta uga yeedhay isagii, oo wuxuu ku yidhi, Yacquub reerkiisa waxaad ku tidhaahdaa sidan, reer binu Israa'iilna ku dheh, ");
INSERT INTO som_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Idinku waad aragteen wixii aan ku sameeyey Masriyiintii, iyo sidii aan idiinku soo qaaday gorgorro baalashood, oo aan idiin soo kaxaystay. ");
INSERT INTO som_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Haddaba sidaas daraaddeed, haddaad daacad ahaan ii addeecaysaan, oo aad axdigayga dhawraysaan, de markaas waxaad ahaan doontaan dad hanti iiga ah dadyowga oo dhan, waayo, dhulka oo dhan anigaa iska leh; ");
INSERT INTO som_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","oo waxaad ii ahaan doontaan boqortooyo wada wadaaddo ah, iyo quruun quduus ah. Kuwanu waa erayada aad reer binu Israa'iil kula hadli doonto. ");
INSERT INTO som_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Markaasaa Muuse yimid oo wuxuu u yeedhay waayeelladii dadka oo dhan, kolkaasuu erayadii Rabbigu isaga ku amray oo dhan hortooda wada dhigay. ");
INSERT INTO som_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Markaasaa dadkii oo dhammu waxay ku wada jawaabeen, oo yidhaahdeen, Kulli waxa Rabbigu ku hadlay oo dhan waannu wada yeeli doonnaa. Markaasaa Muuse Rabbiga uga warramay erayadii dadka. ");
INSERT INTO som_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Kolkaasaa Rabbigu wuxuu Muuse ku yidhi, Bal ogow, waxaan kuugu iman doonaa daruur qaro weyn dhexdeed, inay dadku maqlaan markii aan kula hadlayo, iyo weliba inay weligood adiga ku rumaystaan. Markaasaa Muuse Rabbiga u sheegay erayadii dadka. ");
INSERT INTO som_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Kolkaasaa Rabbigu wuxuu Muuse ku yidhi, Bal orod oo dadka u tag, oo maanta iyo berri quduus ka dhig iyaga, oo dharkooda ha dhaqeen, ");
INSERT INTO som_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","oo maalinta saddexaad diyaar ha u noqdeen, waayo, maalinta saddexaad dadka oo dhan hortiisa ayaa Rabbigu ku soo degi doonaa Buur Siinay. ");
INSERT INTO som_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Oo waa inaad soohdin dadka kaga wareejisaa, oo waxaad ku tidhaahdaa, Iska jira, oo buurta ha fuulina, hana taabanina xuduudkeeda; waayo, ku alla kii buurta taabta hubaal waa la dili doonaa. ");
INSERT INTO som_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Gacanu yaanay taaban isaga, laakiinse hubaal isaga waa in la dhagxiyo ama waa in gantaal lagu dilo; dad iyo duunyo ha ahaado, kaasu sina yaanu u noolaan; oo markii buunka aad looga dhawaajiyo, buurta ha soo fuuleen. ");
INSERT INTO som_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Markaasaa Muuse buurtii ka degay, oo wuxuu u tegey dadkii, kolkaasuu dadkii quduus ka dhigay, oo ay dharkoodii dhaqeen. ");
INSERT INTO som_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Oo wuxuu dadkii ku yidhi, Maalinta saddexaad diyaar noqda oo naagna ha isugu dhowaanina. ");
INSERT INTO som_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Oo maalintii saddexaad, markuu waagii beryay, waxaa dhacay onkod iyo hillaac, oo daruur qaro weyn baa buurtii soo dul joogsatay, oo waxaa yeedhay buun codkiisu aad iyo aad u weyn yahay, kolkaasay dadkii xerada ku jiray oo dhammu wada gariireen. ");
INSERT INTO som_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Markaasaa Muuse dadkii xeradii ka soo bixiyey inay Ilaah la kulmaan aawadeed; kolkaasay waxay istaageen buurta salkeedii. ");
INSERT INTO som_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Oo Buur Siinay dhammaanteed way qiiqaysay, maxaa yeelay, Rabbi baa dusheeda ku soo degay, isagoo dab ku dhex jira, oo qiiqeediina kor buu u baxay sida qiiq foorno oo kale, oo buurtii oo dhammuna aad bay u gariirtay. ");
INSERT INTO som_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Oo markii buunkii codkiisii aad iyo aad u sii weynaaday ayaa Muuse hadlay, Ilaahna kolkaasuu cod ugu jawaabay. ");
INSERT INTO som_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Markaasaa Rabbigu wuxuu ku soo kor degay Buur Siinay, oo wuxuu yimid buurta dusheedii. Kolkaasaa Rabbigu wuxuu Muuse ugu yeedhay buurta dusheedii; oo Muusena kor buu u baxay. ");
INSERT INTO som_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Markaasaa Rabbigu wuxuu Muuse ku yidhi, Hoos u deg, oo dadka u dig, waaba intaasoo ay Rabbiga xaggiisa u soo xadgudbaan inay fiirsadaan, oo ay qaarkood badanu halligmaane. ");
INSERT INTO som_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Oo weliba wadaaddada Rabbiga u soo dhowaanaya quduus ha iska dhigeen, waaba intaasoo Rabbigu uu halligaaye. ");
INSERT INTO som_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Kolkaasaa Muuse wuxuu Rabbiga ku yidhi, Dadku Buur Siinay sooma fuuli karaan, waayo, waxaad nagu amartay, oo nagu tidhi, Buurta soohdin ku wareeji, oo quduus ka dhig. ");
INSERT INTO som_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Markaasaa Rabbigu wuxuu isagii ku yidhi, Orod oo hoos u deg; oo dabadeedna soo fuul adigoo Haaruun wata; laakiinse wadaaddada iyo dadku yaanay kor u soo xadgudbin xagga Rabbiga, waaba intaasoo uu halligaaye. ");
INSERT INTO som_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Haddaba Muuse hoos buu u degay oo dadkii u tegey, una sheegay. ");
INSERT INTO som_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Markaasaa Rabbigu erayadan oo dhan ku hadlay, isagoo leh, ");
INSERT INTO som_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Anigu waxaan ahay Rabbiga Ilaahaaga ah, oo kaa soo bixiyey dalkii Masar iyo gurigii addoonsiga. ");
INSERT INTO som_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Aniga mooyaane ilaahyo kale waa inaanad lahaan. ");
INSERT INTO som_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Waa inaanad samaysan sanam xardhan, ama wax u eg waxa samada sare jira, ama waxa dhulka hoose jira, ama waxa biyaha dhulka ka hooseeya ku jira. ");
INSERT INTO som_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Waa inaanad iyaga u sujuudin, ama u adeegin, waayo, aniga oo ah Rabbiga Ilaahaaga ah waxaan ahay Ilaah masayr ah, oo xumaantii awowayaasha waxaan soo gaadhsiinayaa carruurtooda tan iyo farcanka saddexaad iyo kan afraad oo kuwa i neceb, ");
INSERT INTO som_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","oo waxaan u naxariistaa kumanyaal ah kuwa i jecel oo amarradayda xajiya. ");
INSERT INTO som_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Waa inaanad magaca Rabbiga Ilaahaaga ah si been ah ugu hadal qaadin, waayo, Rabbigu eedlaawe u haysan maayo kii magiciisa si been ah ugu hadal qaada. ");
INSERT INTO som_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Xusuuso maalinta sabtida, inaad quduus ka dhigto. ");
INSERT INTO som_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Lix maalmood waa inaad hawshootaa, oo aad shuqulkaaga oo dhan qabsataa, ");
INSERT INTO som_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","laakiinse maalinta toddobaad waa maalin sabti u ah Rabbiga Ilaahaaga ah, oo waa inaanad shuqul qaban, adiga, ama wiilkaaga, ama gabadhaada, ama addoonkaaga, ama addoontaada, ama xoolahaaga, ama qariibka irdahaaga ku jira; ");
INSERT INTO som_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","waayo, Rabbigu lix maalmood buu ku sameeyey samada, iyo dhulka, iyo badda, iyo waxa dhexdooda ku jira oo dhan, kolkaasuu nastay maalintii toddobaad, sidaas daraaddeed ayaa Rabbigu u barakeeyey maalintii sabtida ahayd oo quduus uga dhigay. ");
INSERT INTO som_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Aabbahaa iyo hooyadaa maamuus, in cimrigaagu ku dheeraado dhulka Rabbiga Ilaahaaga ahu ku siiyo. ");
INSERT INTO som_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Waa inaanad qudh gooyn. ");
INSERT INTO som_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Waa inaanad sinaysan. ");
INSERT INTO som_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Waa inaanad waxba xadin. ");
INSERT INTO som_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Waa inaanad deriskaaga marag been ah ku furin. ");
INSERT INTO som_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Waa inaanad damcin guriga deriskaaga, waa inaanad damcin naagta deriskaaga, ama addoonkiisa, ama addoontiisa, ama dibigiisa, ama dameerkiisa, ama waxa deriskaagu leeyahay oo dhan. ");
INSERT INTO som_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Oo dadkii oo dhammuna way wada arkeen onkodkii iyo hillaacii, iyo codkii buunka, iyo buurtii qiiqaysay; oo markii dadkii arkay ayay gariireen, oo meel fog istaageen. ");
INSERT INTO som_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Kolkaasay waxay Muuse ku yidhaahdeen, Adigu nala hadal, oo annana waannu ku maqli doonnaa, laakiinse Ilaah yuusan nala hadlin, waaba intaasoo aannu dhimannaaye. ");
INSERT INTO som_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Markaasaa Muuse wuxuu dadkii ku yidhi, Ha cabsanina, waayo, Ilaah wuxuu u yimid inuu idin tijaabiyo, iyo in ka cabsashadiisu idinku jirto, si aydnaan u dembaabin. ");
INSERT INTO som_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Markaasaa dadkii waxay istaageen meel fog, Muusena wuxuu u soo dhowaaday gudcurkii qarada weynaa oo Ilaah joogay. ");
INSERT INTO som_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Markaasaa Rabbigu wuxuu Muuse ku yidhi, Waxaad reer binu Israa'iil ku tidhaahdaa, Idinka qudhiinnu waad aragteen inaan samada idinkala hadlay. ");
INSERT INTO som_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Haddaba waa inaydnaan yeelan ilaahyo kale aniga mooyaane; oo ilaahyo lacag ah iyo ilaahyo dahab ah waa inaydnaan samaysan. ");
INSERT INTO som_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Meel allabari waa inaad ciid iiga samaysaa, oo waa inaad dusheeda iigu bixisaa qurbaannadaada la gubo, iyo qurbaannadaada nabaadiinada, iyo idahaaga iyo dibiyadaada. Oo meel kasta oo aan magacayga dadka ku xusuusiyoba waan kuugu iman doonaa oo waan kugu barakayn doonaa. ");
INSERT INTO som_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Oo haddaad meel allabari dhagax iiga samayso, waa inaadan dhagax qoran ka dhisin, waayo, haddaad alaabtaada taabsiisid waad nijaasaysay. ");
INSERT INTO som_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Ama waa inaanad meeshayda allabariga sallaan ku fuulin, si aan cawradaadu uga muuqan. ");
INSERT INTO som_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Haddaba kuwanu waa amarradii aad hortooda dhigi lahayd. ");
INSERT INTO som_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Haddaad addoon Cibraani ah iibsatid, ha kuu adeego lix sannadood, oo tan toddobaadna ha iska tago isagoo xor ah oo aan waxba bixin. ");
INSERT INTO som_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Oo hadduu keli ahaantiis ku soo galo, haddana keli ahaantiis ha ku baxo, hadduuse naag qabo, de markaas waa inay naagtiisu isaga la baxdaa. ");
INSERT INTO som_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Haddii sayidkiisu naag siiyona, oo ay wiilal iyo gabdho u dhasho, de markaas naagta iyo carruurteedaba waxaa iska lahaanaya sayidkeedii, oo waa inuu isagu keligiis iska baxaa. ");
INSERT INTO som_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Laakiinse haddii addoonku bayaan u yidhaahdo, Anigu waan jeclahay sayidkayga, iyo naagtayda, iyo carruurtayda, oo anigoo xor ah bixi maayo, ");
INSERT INTO som_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","de markaas waa in sayidkiisu xaakinnada u keenaa, oo waa inuu albaabka ag keenaa, ama tiirka albaabka; markaas sayidkiisu dhegta mudac ha kaga dalooliyo; oo weligiis ha u adeego. ");
INSERT INTO som_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Oo haddii nin gabadhiisa u iibiyo inay addoon noqoto, waa inaanay dibadda u bixin sida addoommada nimanka ahu ay u baxaan. ");
INSERT INTO som_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Oo haddaanay raalli gelin sayidkeedii doonay iyada, de markaas waa inuu sii daayo iyada, ha la madax furto, laakiinse amar uma lahaan doono inuu iyada dad qalaad ka iibiyo, waayo, khiyaano ayuu kula macaamilooday iyada. ");
INSERT INTO som_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Oo hadduu iyada wiilkiisa u guursho, de waa inuu iyada ula macaamiloodaa sida gabdhaha loola macaamiloodo. ");
INSERT INTO som_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Oo hadduu naag kale la guursado, waa inuusan inna ka dhimin masruufkeeda, iyo dharkeeda, iyo xaqa naagnimadeeda. ");
INSERT INTO som_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Oo hadduusan saddexdaas iyada u samayn, markaas lacagla'aan ha ku baxdo. ");
INSERT INTO som_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Kii nin wax ku dhufta si uu ninku u dhinto, isagana hubaal waa in la dilaa. ");
INSERT INTO som_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Oo haddii aanu gaadin, laakiinse Ilaah u dhiibo gacantiisa, de markaas anaa kuu samayn doona meel uu ku cararo. ");
INSERT INTO som_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Oo haddii nin kibir ula badheedho inuu deriskiisa khiyaano ku dilo, waa inaad isaga ka waddaa meeshayda allabariga, ha dhintee. ");
INSERT INTO som_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Oo kii aabbihiis ama hooyadiis wax ku dhufta, hubaal kaas waa in la dilaa. ");
INSERT INTO som_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Oo kii intuu nin xada iibiya ama gacantiisaba laga helo, hubaal kaas waa in la dilaa. ");
INSERT INTO som_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Oo kii aabbihiis ama hooyadiis caaya, hubaal kaas waa in la dilaa. ");
INSERT INTO som_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Oo haddii niman diriraan, oo midkood kan kale dhagax ama feedh ku dhufto, oo uusan dhiman, laakiinse uu sariir ku jiif noqdo; ");
INSERT INTO som_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","kaasu hadduu mar kale sara kaco oo uu dibadda u baxo isagoo ushiisa ku tukubaya, markaas kii wax ku dhuftay eed ma leh, laakiinse waa inuu siiyaa wixii ka khasaaroobay intuu jiifay, waana inuu dhaqaaleeyo ilaa uu ka bogsado. ");
INSERT INTO som_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Haddii nin addoonkiisa ama addoontiisa uu ul ku dhufto, oo uu gacantiisa ku dhinto, kaas hubaal waa in la ciqaabaa. ");
INSERT INTO som_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Kan la dilayse hadduu maalin ama laba sii joogo, de markaas waa inaan la ciqaabin, waayo, isagu waa lacagtiisii. ");
INSERT INTO som_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Oo haddii niman diriraan oo ay wax yeelaan naag uur leh, oo uu ilmaheedu ka soo dhaco, laakiinse dhib kale aanu dhicin, kaas waa in lagu ganaaxaa intii ninkii naagta qabay uu kor saaro, oo waa inuu bixiyaa intii xaakinnadu ku xukumaan. ");
INSERT INTO som_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Laakiinse haddii dhib kale dhacdo, waa inaad naf naf u dishaa, ");
INSERT INTO som_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","oo waa inaad il il u riddaa, iligna ilig u riddaa, gacanna gacan u gooysaa, cagna cag u gooysaa, ");
INSERT INTO som_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","oo kii wax guba, gub, kii wax dhaawacana, dhaawac, kii wax karbaashana, karbaash. ");
INSERT INTO som_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Oo haddii nin isha addoonkiisa ama isha addoontiisa wax ku dhufto, oo ka rido, de markaas waa inuu iska sii daayaa isagoo xor ah, ishiisa aawadeed. ");
INSERT INTO som_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Oo hadduu iligga addoonkiisa ama iligga addoontiisa wax ku dhufto oo ka rido, de markaas waa inuu iska sii daayaa isagoo xor ah iliggiisa aawadiis. ");
INSERT INTO som_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Oo haddii dibi nin ama naag geeso ku mudo, oo ay dhintaan, markaas hubaal waa in dibiga la dhagxiyaa, oo hilibkiisana waa inaan la cunin; laakiinse qofkii dibiga lahaa waxba eed ma leh. ");
INSERT INTO som_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Laakiinse haddii markii hore dibigu dad geesaha ku mudi jiray, oo loo sheegay qofkii lahaa, isaguse aanu xidhin, laakiinse uu dibigu nin ama naag dilay, dibiga waa in la dhagxiyaa, oo weliba qofkii lahaana waa in isna la dilaa. ");
INSERT INTO som_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Haddiise mag la saaro isaga, de markaas waa inuu bixiyaa wax alla wixii la kor saaray madaxfurashadiisa aawadeed. ");
INSERT INTO som_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Hadduu wiil geeso ku muday iyo hadduu gabadh geeso ku mudayba waa in xukunkan lagu qaadaa. ");
INSERT INTO som_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Oo haddii dibigii geeso ku mudo nin addoon ah ama naag addoon ah, waa inuu ninkii dibiga lahaa sayidkoodii soddon sheqel oo lacag ah siiyaa, oo dibigana waa in la dhagxiyaa. ");
INSERT INTO som_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Oo haddii nin god daboolka ka qaado, ama haddii nin god qodo oo uu dabooli waayo, oo uu ama dibi ama dameer ku dhaco, ");
INSERT INTO som_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","de markaas waa in ninkii godka lahaa xaq mariyaa. Waa inuu lacag siiyaa ninkii neefka lahaa, oo neefka dhintayna waa inuu isagu lahaado. ");
INSERT INTO som_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Oo haddii nin dibigiis nin kale dibigiis wax yeelo oo uu dhinto, de markaas waa inay dibiga nool iibiyaan, oo qiimihiisa waa inay qaybsadaan; oo weliba kan dhintayna waa inay qaybsadaan. ");
INSERT INTO som_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Ama haddii dibiga lagu yiqiin inuu markii hore wax geeso ku mudi jiray, oo uusan qofkii lahaa xidhin, markaas hubaal waa inuu dibi dibi ku bixiyaa, oo neefka dhintayna waa inuu isagu lahaado. ");
INSERT INTO som_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Haddii nin dibi ama lax xado, oo uu qasho ama iibiyo, waa inuu shan dibi dibigii ku magdhabo, laxdiina afar laxaad. ");
INSERT INTO som_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Haddii tuug la helo isagoo guri u dhacaya, oo inta wax lagu dhufto uu dhinto, markaas kii dilay dhiig eed kuma laha. ");
INSERT INTO som_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Haddiise qorraxdu u soo baxdo, markaas dhiigga eed buu ku leeyahay. Waa inuu u soo celiyaa, hadduusanse waxba haysan, de markaas waa in isaga la iibiyaa tuugnimadiisii aawadeed. ");
INSERT INTO som_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Haddiise wuxuu xaday iyagoo nool gacantiisa laga helo, ama dibi ha noqdo amase dameer, amase lax, waa inuu labanlaab u bixiyaa. ");
INSERT INTO som_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Haddii nin beer canab ah ama beer kale xoolo daajiyo, oo uu neefkiisa ku sii daayo si uu nin kale beertiis u daaqo, de markaas waa inuu meesha beertiisa ugu wanaagsan iyo meesha beertiisa canabka ah ugu wanaagsan ugu magdhabaa. ");
INSERT INTO som_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Haddii dab baxo, oo uu qodxanta qabsado, oo uu wada gubo xidhmooyinka sarreenka ah ama sarreenka weli baalka ku yaal, ama beerta oo dhan, markaas kii dabka shiday waa inuu magdhabaa. ");
INSERT INTO som_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Haddii nin deriskiisa lacag ama alaab ammaano ugu dhiibto, oo ninka gurigiisii laga xado, oo markaas tuuggii la helo, waa inuu labanlaab u magdhabaa. ");
INSERT INTO som_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Haddiise aan tuuggii la helin, markaas waa in ninkii guriga lahaa xaakinnada u soo dhowaadaa si loo caddeeyo inuu alaabtii deriskiisa fartiisa saaray iyo in kale. ");
INSERT INTO som_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Waayo, wax kasta oo xadgudub ah ama ha noqdo dibi aawadiis, ama dameer aawadiis, ama lax aawadeed, ama dhar aawadiis, ama wax kasta oo baadi ah, haddii la leeyahay, Waa kan, waa in labada qolo arrintooda xaakinnada la hor keenaa. Oo midkii xaakinnadu ku xukumaan waa inuu deriskiisa labanlaab ugu magdhabaa. ");
INSERT INTO som_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Haddii nin deriskiisa ammaano ugu dhiibto dameer ama dibi, ama lax amase neef uun, markaas hadduu dhinto, ama wax gaadhaan, ama la kaxaysto iyadoo aan la arkayn, ");
INSERT INTO som_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","markaas waa in dhaartii Rabbiga la dhex dhigaa labadooda, si loo caddeeyo inuu fartiisa saaray xoolihii deriskiisa iyo in kale, oo kii lahaana waa inuu aqbalaa, oo waxbana loo magdhabi maayo. ");
INSERT INTO som_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Laakiinse haddii laga xado, waa inuu isagu qofkii lahaa u magdhabaa. ");
INSERT INTO som_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Haddiise dugaag bakhtiisto, waa inuu marag ahaan u keenaa, oo wixii dugaaggu bakhtiistay waxba ka magdhabi maayo. ");
INSERT INTO som_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Oo haddii nin deriskiisa neef ka ammaahdo, oo ay wax gaadhaan amaba uu dhinto, isagoo aan ninkii lahaa la joogin, kaasu hubaal waa inuu magdhabaa. ");
INSERT INTO som_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Haddiise kii lahaa la joogay, waa inuusan waxba ka magdhabin, oo hadduu kiro ahaa, kiradiisii waa laga xisaabay. ");
INSERT INTO som_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Oo haddii nin sasabto gabadh bikrad ah oo aan doonanayn, oo uu iyada la seexdo, de markaas waa inuu yarad ka bixiyo oo uu guursadaa iyada. ");
INSERT INTO som_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Haddiise aabbeheed innaba u diido inuu isaga siiyo, de markaas waa inuu bixiyaa intii gabadh bikrad ah yaradkeedu yahay. ");
INSERT INTO som_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Saaxirad inay sii noolaato waa inaadan u fasaxin. ");
INSERT INTO som_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Ku alla kii neef u galmooda, hubaal waa in la dilaa. ");
INSERT INTO som_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Kii wax u bixiya ilaah kale oo aan Rabbiga keligiis ah ahayn, kaas waa in dhammaantiis la baabbi'iyaa. ");
INSERT INTO som_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Oo qariib waa inaadan xumayn, ama waa inaadan dulmin, waayo, idinba qariib baad ku ahaydeen dalkii Masar. ");
INSERT INTO som_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Waa inaydnaan dhibin carmal, ama ilmo agoon ah. ");
INSERT INTO som_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Oo si kasta ha noqotee haddii aad iyaga dhibtid, oo ay ii qayshadaan hubaal qayladooda waan maqli doonaa, ");
INSERT INTO som_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","oo aad baan u cadhoon doonaa, oo markaasaan seef idinku dili doonaa, kolkaasaa naagihiinnu waxay noqon doonaan carmallo, carruurtiinnuna agoon. ");
INSERT INTO som_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Oo haddaad lacag ammaahisid dadkayga masaakiinta ah oo kula jooga, waa inaadan ku noqon sidii mid dayn ku leh ama waa inaadan waxba kor saarin. ");
INSERT INTO som_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Haddaad deriskaaga dharkiisa rahmad uga qaadatid waa inaad u celisaa intaan qorraxdu dhicin, ");
INSERT INTO som_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","waayo, kaasu waa kan qudh ah oo uu isa saari jiray, oo waa dharkii uu huwan jiray, oo muxuu ku seexan doonaa? Oo waxaa dhici doonta in markuu ii qayshado, aan maqli doono, waayo, anigu waan raxmad badnahay. ");
INSERT INTO som_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Waa inaadan xaakinnada caayin, mid dadkaaga u taliyana ha habaarin. ");
INSERT INTO som_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Waa inaadan ka raagin inaad wax ka bixiso midhahaaga badan iyo dheecaanka macsaraddaada. Oo curadyada dadkaagana waa inaad aniga i siisaa. ");
INSERT INTO som_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Oo sidaas oo kalena waa inaad ka yeeshaa dibiyadaada iyo idahaaga; toddoba maalmood waa inuu hooyadiis la joogaa, maalinta siddeedaadna waa inaad ii bixisaa. ");
INSERT INTO som_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Oo waa inaad dad quduus ah ii ahaataan, oo sidaas daraaddeed waa inaydnaan cunin hilib neef oo dugaag berrinka ku bakhtiistay, laakiinse waa inaad eeyaha u tuurtaan. ");
INSERT INTO som_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Waa inaadan qaadqaadin war been ah; gacantaada heshiis ha ugu dhiibin kan sharka ah, yaadan markhaati xaqdaran noqone. ");
INSERT INTO som_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Inaad xumaan fashid aawadeed dad badan ha u raacin, ama marag ha furin oo dad badan dhankooda ha u leexan inaad gar qalloocisaan, ");
INSERT INTO som_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","waana inaadan nin miskiin ah u gar eexan. ");
INSERT INTO som_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Haddaad aragtid cadowgaaga dibigiisii ama dameerkiisii oo lumaya, waa inaad u celisaa. ");
INSERT INTO som_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Haddaad aragtid kan ku neceb dameerkiisii oo rar la dhacay, oo aanad doonayn inaad caawiso, hubaal waa inaad caawisaa. ");
INSERT INTO som_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Miskiinkaaga dacwaddiisa waa inaadan garta ka qalloocin. ");
INSERT INTO som_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Wax been ah ka fogow; oo ha dilin mid aan eed lahayn iyo kan xaqa ah; waayo, anigu xaq ka dhigi maayo kan shar fala. ");
INSERT INTO som_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Oo waa inaadan laaluush qaadan innaba; waayo, laaluushku waa indho tiraa kuwa wax arka, wuuna qalloociyaa kan xaqa ah hadalkiisa. ");
INSERT INTO som_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Oo qariib waa inaadan dulmin; waayo, qalbiga qariibka waad garanaysaan, maxaa yeelay, idinba qariib baad dalkii Masar ku ahaydeen. ");
INSERT INTO som_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Lix sannadood waa inaad dhulkaaga wax ku abuurtaa oo midhihiisa urursataa, ");
INSERT INTO som_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","laakiinse sannadda toddobaad waa inaad iska daysaa ha nasto, oo dhul aan beernayn ha noqdee, inay masaakiinta dadkaagu wax ka cunaan; oo waxay reebaanna dugaagga duurku ha daaqeen. Oo sidaas oo kalena waa inaad u gashaa beertaada canabka ah iyo beertaada saytuunka ah. ");
INSERT INTO som_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Lix maalmood waa inaad shuqulkaaga qabsataa, oo maalinta toddobaadna waa inaad nasataa, si ay dibigaaga iyo dameerkaaguna u nastaan, oo ay wiilka addoontaada iyo kan qariibka ahuba nafis u helaan. ");
INSERT INTO som_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Oo kulli wixii aan idinku idhi oo dhan waa inaad aad u dhawrtaan, oo ilaahyo kale magacood ha soo qaadina innaba, ama afkaagaba yaan laga maqlin. ");
INSERT INTO som_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Oo sannad walba saddex goor waa inaad ii iiddaa. ");
INSERT INTO som_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Oo Iiddii Kibista-aan-khamiirka-lahayn waa inaad dhawrtaa. Toddoba maalmood waa inaad cuntaa kibis aan khamiir lahayn, sidii aan kugu amray wakhtigii la yidhi oo bisha Aabiib ah, maxaa yeelay, bishaas ayaad Masar ka soo baxday; oo midkiinna hortayda yuusan iman isagoo faro madhan. ");
INSERT INTO som_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Oo waa inaad dhawrtaa Iiddii Beergoosadka oo ah midhihii ugu horreeyey hawshaada aad beerta ku abuurtay, iyo Iiddii Wax urursiga oo sannadda dhammaadkeeda ah, marka aad soo urursatid midhihii aad beerta ku hawshootay. ");
INSERT INTO som_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Kuwaaga labka ah oo dhammu waa inay sannad walba saddex goor Rabbiga Ilaaha ah ka hor yimaadaan. ");
INSERT INTO som_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Oo waa inaadan dhiigga allabarigayga la bixin kibis khamiir leh; baruurta iiddayduna waa inaanay hadhin habeenka oo dhan ilaa subaxda. ");
INSERT INTO som_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Oo dhulkaaga midhaha ugu horreeya waa inaad inta hore guriga Rabbiga Ilaahaaga ah geeysaa. Waa inaadan waxar caanaha hooyadiis ku karin. ");
INSERT INTO som_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Bal eeg, waxaan hortaada u soo dirayaa malaa'ig, inay jidka kugu dhawrto oo ay meeshii aan diyaarshay ku geeyso. ");
INSERT INTO som_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Iyada iska jira, oo codkeeda dhegaysta, hana ka xanaajinina, waayo, iyadu xadgudubkiinna idinkama cafiyi doonto; maxaa yeelay, iyada magacaygii baa ku dhex jira. ");
INSERT INTO som_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Laakiinse xaqiiqa haddaad codkeeda dhegaysatid, oo aad yeeshid kulli waxa aan ku hadlayo, de markaas waxaan noqon cadaawayaashaada cadowgooda, oo kuwa ku dhibana mid dhiba iyaga. ");
INSERT INTO som_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Waayo, malaa'igtaydu way ku hor socon doontaa, oo waxay ku dhex geeyn doontaa reer Amor, iyo reer Xeed, iyo reer Feres, iyo reer Kancaan, iyo reer Xiwi, iyo reer Yebuus; oo kolkaasaan iyaga baabbi'in doonaa. ");
INSERT INTO som_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Waa inaadan u sujuudin ilaahyadooda, hana u adeegin, shuqulkooda oo kalena ha samayn; laakiinse waa inaad wada afgembidaa, oo aad sanamyadoodana jejebisaa. ");
INSERT INTO som_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Oo waa inaad Rabbiga Ilaahiinna ah u adeegtaan, oo isaguna wuu idiin barakayn doonaa kibistiinna iyo biyihiinna; oo anna cudur waan ka fogayn doonaa dhexdiinna. ");
INSERT INTO som_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Oo dhulkaaga dhexdiisa miduna dhicis ma dhali doonto, ama madhalays ma noqon doonto, oo tirada maalmahaaga waan dhammaystiri doonaa. ");
INSERT INTO som_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Oo cabsidaydaan ku hor marin doonaa, oo dadka aad u tegaysid oo dhan waan argaggixin doonaa, oo waxaan cadaawayaashaada oo dhan ka dhigi doonaa inay dhabarkooda kaa sii jeediyaan. ");
INSERT INTO som_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Oo waxaan hortaa diri doonaa xoon, kaas oo reer Xiwi, iyo reer Kancaan, iyo reer Xeed hortaada ka eryi doona. ");
INSERT INTO som_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Oo iyaga sannad uun hortaada ka eryi maayo, waayo, waaba intaasoo dhulku cidla noqdaa, oo dugaagga duurku kugu bataa. ");
INSERT INTO som_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","In yar in yar ayaan hortaada ka eryi doonaa, ilaa aad adigu badatid oo aad dalka dhaxashid. ");
INSERT INTO som_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Oo waxaan soohdintaada ka dhigi doonaa Badda Cas iyo tan iyo badda reer Falastiin, iyo cidlada ilaa tan iyo Webiga, waayo, dadka dhulka deggan waxaan gelin doonaa gacantaada, markaasaad hortaada ka eryi doontaa. ");
INSERT INTO som_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Waa inaadan axdi la dhigan iyaga iyo ilaahyadooda toona. ");
INSERT INTO som_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Waa inayan iyagu dalkaaga degganaan, waaba intaasoo ay igu kaa dembaajiyaane, waayo, haddaad ilaahyadooda u adeegtid, hubaal waxay taasu kugu noqon doontaa dabin. ");
INSERT INTO som_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Markaasuu wuxuu Muuse ku yidhi, Soo fuula oo Rabbiga u kaalaya, adiga iyo Haaruun, iyo Naadaab, iyo Abiihuu, iyo toddobaatan oday oo reer binu Israa'iil ah, oo meel fog ka caabuda; ");
INSERT INTO som_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","oo Muuse oo keliyahu waa inuu Rabbiga u soo dhowaada, laakiinse iyagu waa inayan soo dhowaan, dadkuna yuusan la soo fuulin. ");
INSERT INTO som_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Markaasaa Muuse dadkii u yimid, oo wuxuu u sheegay hadalladii Rabbiga oo dhan iyo amarradii oo dhan. Markaasaa dadkii oo dhammu isku cod ku jawaabeen, oo waxay yidhaahdeen, Ereyadii Rabbigu ku hadlay oo dhan waannu wada yeeli doonnaa. ");
INSERT INTO som_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Markaasaa Muuse wuxuu qoray ereyadii Rabbiga oo dhan, kolkaasuu aroor hore kacay, oo buurta hoosteedii wuxuu ka dhisay meel allabari iyo laba iyo toban tiir, sidii laba iyo tobankii qolo oo reer binu Israa'iil ay ahaayeen. ");
INSERT INTO som_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Kolkaasuu wuxuu diray raggii dhallinyarada ahaa oo reer binu Israa'iil, oo waxay Rabbiga u bixiyeen allabaryo la gubo iyo qurbaanno nabaadiino oo dibiyo ah. ");
INSERT INTO som_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Markaasaa Muuse wuxuu qaaday dhiiggii badhkiis oo wuxuu ku shubay xeedhooyin; oo dhiiggii badhkiisna wuxuu ku rusheeyey meeshii allabariga. ");
INSERT INTO som_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Markaasuu wuxuu qaaday kitaabkii axdiga, oo wuuna akhriyey iyadoo ay dadkii maqlayaan, oo waxay yidhaahdeen, Kulli wixii Rabbigu ku hadlay waannu yeeli doonnaa oo waannu addeeci doonnaa. ");
INSERT INTO som_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Markaasaa Muuse wuxuu qaaday dhiiggii, oo dadkii ku rusheeyey, oo wuxuu ku yidhi, Bal eega dhiiggii axdiga oo Rabbigu idinla dhigtay oo ku saabsan hadalladan oo dhan. ");
INSERT INTO som_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Kolkaasaa waxaa kor u fuulay Muuse, iyo Haaruun, iyo Naadaab, iyo Abiihuu, iyo toddobaatan oday oo reer binu Israa'iil ah. ");
INSERT INTO som_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Markaasay waxay arkeen Ilaahii reer binu Israa'iil; oo waxaa cagihiisa ka hooseeyey sallax dhagax safayr ah oo sida samada u daahirsan. ");
INSERT INTO som_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Oo odayaashii reer binu Israa'iilna far ma uu saarin, oo Ilaah bay arkeen, waxna way cuneen oo cabbeen. ");
INSERT INTO som_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Markaasaa Rabbigu wuxuu Muuse ku yidhi, Bal kaalay oo buurta ii soo fuul, oo halkaas iska joog; oo waxaan ku siinayaa looxyada dhagaxa ah, iyo sharcigii iyo qaynuunnadii aan qoray, inaad iyaga bartid. ");
INSERT INTO som_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Kolkaasaa Muuse sara kacay, isaga iyo midiidinkiisii Yashuuca, oo Muuse wuxuu fuulay buurtii Ilaah. ");
INSERT INTO som_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Oo wuxuu odayaashii ku yidhi, Idinku halkan noo jooga, ilaa aan mar kale idiin nimaadno, oo bal eega, waxaa idinla jooga Haaruun iyo Xuur; ku alla kii dacwo qaba, iyaga ha u yimaado. ");
INSERT INTO som_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Markaasaa Muuse wuxuu fuulay buurtii, oo buurtiina waxaa qarisay daruur. ");
INSERT INTO som_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Oo ammaantii Rabbiguna waxay dul joogtay Buur Siinay, oo daruurtuna way qarinaysay intii lix maalmood ah, oo maalintii toddobaad ayaa Rabbigu Muuse uga dhex yeedhay daruurtii. ");
INSERT INTO som_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Oo muuqashada ammaantii Rabbigu waxay reer binu Israa'iil ula ekayd sidii dab wax gubaya buurta dusheeda. ");
INSERT INTO som_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Markaasaa Muuse wuxuu galay daruurtii dhexdeeda, oo buurtuu fuulay; oo Muuse wuxuu buurtii fuushanaa afartan maalmood iyo afartan habeen. ");
INSERT INTO som_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Markaasaa Rabbigu wuxuu la hadlay Muuse, oo ku yidhi, ");
INSERT INTO som_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","Waxaad reer binu Israa'iil ku tidhaahdaa, Rabbigu wuxuu leeyahay, Qurbaan ii ururiya, oo nin kasta oo qalbigiisu raalli ka yahay waa inaad ka qaaddaa qurbaankayga. ");
INSERT INTO som_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Oo qurbaanka aad ka qaadayso waxa weeyaan: dahab, iyo lacag, iyo naxaas, ");
INSERT INTO som_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","iyo buluug, iyo guduud, iyo casaan, iyo maro wanaagsan, iyo dhogor riyaad, ");
INSERT INTO som_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","iyo wanan hargahood oo la caseeyey, iyo adhidibadeed hargahood, iyo qori qudhac ah, ");
INSERT INTO som_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","iyo saliid laambadda lagu shubo, iyo udgoon lagu daro saliidda lagu subkado, iyo dhir udgoon oo lagu daro uunsiga; ");
INSERT INTO som_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","iyo dhagaxyo onika la yidhaahdo, iyo dhagaxyo loogu dhejiyo eefodka, iyo laabgashiga. ");
INSERT INTO som_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Oo meel quduus ah ha ii sameeyeen aan iyaga dhex joogee. ");
INSERT INTO som_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Waxaan ku tusi doono oo dhan, oo ah hannaanka taambuugga iyo hannaanka alaabtiisa oo dhan, waa inaad sidaas oo kale u samaysaan. ");
INSERT INTO som_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Oo waa inay sanduuq ka sameeyaan qori qudhac ah, oo dhererkiisuna waa inuu ahaadaa laba dhudhun iyo badh, ballaadhkiisuna waa inuu ahaadaa dhudhun iyo badh, sarajooggiisuna waa inuu ahaadaa dhudhun iyo badh. ");
INSERT INTO som_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Oo waa inaad ku dahaadhaa dahab saafi ah, oo gudaha iyo dibaddaba waa inaad ka dahaadhaa, oo dushiisana waa inaad u samaysaa wax taaj oo kale ah oo dahab ah oo ku wareegsan. ");
INSERT INTO som_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Oo waa inaad afar siddo oo dahab ah u yeeshaa, oo aad kaga dhejisaa afarta rukun, oo laba siddo waa inay isku dhinac ku yaalliin, laba siddona waa inay dhinaciisa kale ku yaalliin. ");
INSERT INTO som_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Oo waa inaad ulo ka samaysaa qori qudhac ah, waana inaad dahab ku dahaadhaa. ");
INSERT INTO som_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Oo ulahana waa inaad gelisaa siddooyinka sanduuqa dhinacyadiisa ku yaal, in sanduuqa lagu qaado. ");
INSERT INTO som_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Oo uluhu waa inay ku jiraan sanduuqa siddooyinkiisa; oo waana inaan iyaga laga bixin marnaba. ");
INSERT INTO som_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Oo sanduuqa gudihiisana waa inaad ku riddaa maragga aan ku siin doono. ");
INSERT INTO som_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Oo daboolna waa inaad uga samaysaa dahab saafi ah; laba dhudhun iyo badh waa inuu dhererkiisu ahaadaa, ballaadhkiisuna waa inuu ahaadaa dhudhun iyo badh. ");
INSERT INTO som_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Oo waa inaad laba keruub ka samaysaa dahab la tumay iyagoo daboolka labadiisa madax ka soo taagan. ");
INSERT INTO som_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Keruub waa inaad madax ka samaysaa, keruubka kalena waa inaad madaxa kale ka samaysaa; oo labada keruub oo labada madax ka kala taagan iyo daboolka waa inaad isku waslad ka wada samaysaan. ");
INSERT INTO som_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Oo keruubiimtu waa inay baalashooda meel sare ka soo kala bixiyaan, iyagoo baalashooda ku qarinaya daboolka, oo wejiyadoodu isku soo jeedaan, oo keruubiimta wejiyadooduna waa inay ku soo jeedaan daboolka. ");
INSERT INTO som_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Oo daboolkana waa inaad sanduuqa dushiisa saartaa; oo sanduuqa gudihiisana waa inaad ku riddaa maragga aan ku siin doono. ");
INSERT INTO som_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Oo halkaasaan kugula kulmi doonaa, oo waxaan kaala hadli doonaa daboolka dushiisa, iyo labada keruub oo sanduuqa maragga dul saaran dhexdooda, oo waxaan kuu sheegi doonaa waxyaalaha aan ku siin doono oo dhan oo aan amar ahaan kuugu dhiibi doono reer binu Israa'iil. ");
INSERT INTO som_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Oo waa inaad miis ka samaysaa qori qudhac ah, oo dhererkiisu ha ahaado laba dhudhun, ballaadhkiisuna ha ahaado dhudhun, sarajooggiisuna ha ahaado dhudhun iyo badh. ");
INSERT INTO som_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Oo waa inaad dahab saafi ah ku dahaadhaa, waana inaad u samaysaa wax taaj oo kale ah oo dahab ah oo ku wareegsan. ");
INSERT INTO som_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Oo waa inaad qar le'eg calaacal ballaadhkeed oo ku wareegsan u samaysaa, oo waa inaad qarka u samaysaa wax taaj oo kale ah oo dahab ah oo ku wada wareegsan. ");
INSERT INTO som_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Oo waa inaad afar siddo oo dahab ah u yeeshaa, oo siddooyinkana waa inaad ku dhejisaa afarta gees oo rukummada ah. ");
INSERT INTO som_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Oo meel qarka ku dhow waa inay siddooyinku ku yaalliin, iyagoo ah meelaha laga geliyo ulaha miiska lagu qaado. ");
INSERT INTO som_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Oo ulaha waa inaad qori qudhac ah ka samaysaa, oo aad dahab ku dahaadhaa, in miiska lagu qaado iyaga. ");
INSERT INTO som_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Oo waa inaad u samaysaa suxuuntiisa, iyo malqacadihiisa, iyo kidhliyadiisa, iyo maddiibadihiisa wax lagaga shubo, oo waa inaad dahab saafi ah ka wada samaysaa. ");
INSERT INTO som_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Oo miiska dushiisana waa inaad kibistii tusniinta saartaa, hana taallo hortayda had iyo goorba. ");
INSERT INTO som_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Oo laambad waa inaad dahab saafi ah ka samaysaa, oo laambaddii waa in dahab laga tumaa, xataa salkeeda iyo usheeda dhexe, iyo koobabkeeda, iyo burooyinkeeda, iyo ubaxeeduba, waa inay isku waslad la ahaadaan. ");
INSERT INTO som_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Dhinacyadana waa in lix laamood ka baxdaa; saddex laamood waa inay laambadda dhinac kaga yaalliin, saddexda kalena waa inay dhinaca kale kaga yaalliin. ");
INSERT INTO som_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Saddex koob oo yicib ubaxeed u eg, iyo buro iyo ubax waa inay isku laan ku yaalliin, oo saddex koob oo yicib ubaxeed u eg iyo buro iyo ubaxna waa inay ku yaalliin laanta kale; oo lixda laamood oo laambadda ka baxdaa waa inay sidaas wada ahaadaan. ");
INSERT INTO som_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Oo laambadduna waa inay lahaataa afar koob oo u eg yicib ubaxeed, iyo burooyinkoodii, iyo ubaxoodii; ");
INSERT INTO som_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","iyo buro oo laba laamood ka hoosaysa oo ay isku waslad la yihiin, iyo buro kale oo laba laamood ka hoosaysa oo ay isku waslad la yihiin, iyo buro kale oo laba laamood ka hoosaysa oo ay isku waslad la yihiin, oo waa inay lixda laamood oo laambadda ka baxday sidaas wada ahaadaan. ");
INSERT INTO som_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Burooyinkooda iyo laamahooduba waa inay isku waslad la ahaadaan, oo kulligeedna waa inay ahaataa isku waslad dahab la tumay oo saafi ah. ");
INSERT INTO som_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Oo waa inaad toddoba laambadood ka dhigtaa, oo laambadaheeda waa in la shidaa inay hortooda iftiimiyaan. ");
INSERT INTO som_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Oo birqaabyadeeda iyo alaabteeda lagu safeeyoba waa inay dahab saafi ah ahaadaan. ");
INSERT INTO som_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Oo iyada iyo alaabtan oo dhanba waa in talanti dahab saafi ah laga sameeyaa. ");
INSERT INTO som_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Oo sida hannaankii lagugu tusay buurta waa inaad u samaysaa. ");
INSERT INTO som_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Oo weliba waa inaad samaysaa taambuugga toban daah leh, oo waxaad ka samaysaa maro wanaagsan, iyo buluug, iyo guduud, iyo casaan, oo lagu daabacay keruubiim. ");
INSERT INTO som_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Oo daah walba dhererkiisu waa inuu ahaadaa siddeed iyo labaatan dhudhun, daah walba ballaadhkiisuna waa inuu ahaadaa afar dhudhun; oo daahyada oo dhammuna waa inay isku qiyaas ahaadaan. ");
INSERT INTO som_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Shan daah waa inay isku xidhnaadaan, oo shanta daah oo kalena waa inay isku wada xidhnaadaan. ");
INSERT INTO som_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Oo daahyada midkood waa inaad darafta uu ka laaban yahay u yeeshaa siddooyin buluug ah, oo sidaas oo kalena waa inaad ka yeeshaa daaha dibadda ugu xiga laabka labaad. ");
INSERT INTO som_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Isku daah waa inaad konton siddo u yeeshaa; oo daaha ku yaal laabka labaad waa inaad daraftiisa u yeeshaa konton siddo; oo siddooyinkuna waa in midkoodba kan kale ka hor jeedaa. ");
INSERT INTO som_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Waa inaad konton qabsato oo dahab ah samaysaa, oo daahyadana waa inaad midba kan kale qabsatooyinka kula xidhaa, oo taambuuggana waa inuu mid dhan ahaadaa. ");
INSERT INTO som_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Oo waa inaad daahyo ah dhogor riyaad samaysaa oo aad taambuugga ku deddaa; oo waa inaad iyaga ka dhigtaa koob iyo toban daah. ");
INSERT INTO som_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Oo daah kasta dhererkiisu waa inuu soddon dhudhun ahaadaa, daah kasta ballaadhkiisuna waa inuu afar dhudhun ahaadaa; oo koob iyo tobanka daah waa inay isku qiyaas ahaadaan. ");
INSERT INTO som_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Oo waa inaad shan daah gooni ahaantooda isugu xidhaa, lix daahna gooni ahaantooda isugu xidh, oo daaha lixaad waa inaad ku labanlaabtaa teendhada fooddeeda. ");
INSERT INTO som_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Oo daaha dibadda u xiga laabka daraftiisa waa inaad konton siddo u yeeshaa, oo daaha laabka labaad ugu korreeya daraftiisana waa inaad konton siddo u yeeshaa. ");
INSERT INTO som_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Oo waa inaad samaysaa konton qabsato oo naxaas ah, oo waa inaad qabsatooyinkana sudhaa siddooyinka, oo teendhadana isku xidh kulligeed si ay mid dhan u noqoto. ");
INSERT INTO som_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Oo inta dusha ka lalmata oo ka hadhay daahyada teendhada, oo ah daaha badhkiisa, waa in laga lalmiyaa taambuugga dabadiisa. ");
INSERT INTO som_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Dhudhunka oo dhinaca ah iyo dhudhunka oo dhinaca kale oo ah waxa ka hadha daahyada teendhada dhererkooda waa in laga lalmiyaa dhinacyada taambuugga, oo ah dhankan iyo dhankaasba, inay dedaan. ");
INSERT INTO som_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Oo teendhada waa inaad ded uga dhigtaa wanan hargahood oo la caseeyey, iyo ded ah adhidibadeed hargahood oo ka sarreeya. ");
INSERT INTO som_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Oo looxyada taambuuggu ku taagan yahay waa inaad qori qudhac ah ka samaysaa. ");
INSERT INTO som_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Looxiiba dhererkiisu waa inuu toban dhudhun ahaadaa, oo loox kasta ballaadhkiisu waa inuu dhudhun iyo badh ahaadaa. ");
INSERT INTO som_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Oo loox kasta waa inuu lahaadaa laba caarad, oo looxyadu waa inay dhinacyada isku hayaan, oo waa inaad sidaas u yeeshaa looxyada taambuugga oo dhan. ");
INSERT INTO som_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Oo dhinaca koonfureed oo taambuugga looxyadiisa waa inaad labaatan loox ka dhigtaa. ");
INSERT INTO som_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Oo waa inaad samaysaa afartan saldhig oo lacag ah oo ka hooseeya labaatanka loox; oo laba saldhigba waa inay ka hooseeyaan loox inay saldhig u ahaadaan labadiisa caarad, oo laba saldhigna waa inay ka hooseeyaan loox kale inay saldhig u ahaadaan labadiisa caarad. ");
INSERT INTO som_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Oo taambuugga dhankiisa labaad oo woqooyi xiga waa inaad u yeeshaa labaatan loox, ");
INSERT INTO som_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","iyo afartankoodii saldhig oo lacagta ahayd. Laba saldhigba waa inay loox ka hoosayso. ");
INSERT INTO som_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Oo meesha ugu dambaysa taambuugga oo ah dhankiisa galbeed waa inaad lix loox u yeeshaa. ");
INSERT INTO som_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Oo laba loox waa inaad u yeeshaa labada geesood oo taambuugga xaggiisa dambe. ");
INSERT INTO som_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Oo waa inay hoosta labanlaab ka noqdaan, oo sidaas oo kalena waa inay dhammaadaan ilaa siddada kowaad dusheeda, oo labaduba waa inay sidaas ahaadaan, oo labada gees baa iska leh. ");
INSERT INTO som_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Oo waa inay ahaadaan siddeed loox, iyo saldhigyadoodii lacagta ahayd oo ah lix iyo toban saldhig, oo laba saldhigba waa inay loox ka hoosayso. ");
INSERT INTO som_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Oo waa inaad ulo gudban ka samaysa qori qudhac ah; looxyada taambuugga dhinac kaga jira shan ulood u yeel, ");
INSERT INTO som_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","looxyada dhinaca kale kaga jirana shan ulood oo kale u yeel, oo shan ulood oo kale u yeel taambuugga looxyadiisa kaga jira dhanka galbeed xaggiisa dambe. ");
INSERT INTO som_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Oo uldhexaadda oo looxyada ku gudban waa inay gaadhaa gees ilaa gees. ");
INSERT INTO som_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Oo looxyada waa inaad dahab ku dahaadhaa, oo siddooyinkooda ah meelaha ulaha gudban ka gelayaan waxaad ka samaysaa dahab, oo ulahana waa inaad dahab ku dahaadhaa. ");
INSERT INTO som_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Oo taambuugga waa inaad u taagtaa sidii hannaankii aan buurta kugu tusay. ");
INSERT INTO som_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Oo waa inaad ilxidh ka samaysaa buluug, iyo guduud, iyo casaan, iyo maro wanaagsan; hana lagu daabaco keruubiim. ");
INSERT INTO som_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Oo waa inaad ka soo lalmisaa afar tiir oo qudhac ah oo dahab lagu dahaadhay, iyagoo leh qabsatooyin dahab ah, oo ku taagan afar saldhig oo lacag ah. ");
INSERT INTO som_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Oo waa inaad ilxidhka ka soo lalmisaa qabsatooyinka hoostooda, oo waxaad soo gelisaa sanduuqa maragga ilxidhka gudihiisa; oo ilxidhkuna wuxuu u dhexeeyaa meesha quduuska ah iyo meesha ugu quduusan idinka aawadiin. ");
INSERT INTO som_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Oo daboolka waa inaad saartaa sanduuqa maragga oo ku jira meesha ugu quduusan. ");
INSERT INTO som_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Oo miiskana waa inaad dhigtaa ilxidhka dibaddiisa, oo laambaddana waxaad dhigtaa miiska hortiisa oo ah dhanka koonfureed oo taambuugga, miiskana dhanka woqooyi dhig. ");
INSERT INTO som_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Oo waa inaad iridda Teendhada u samaysaa daah buluug, iyo guduud, iyo casaan, iyo maro wanaagsan oo daabac leh. ");
INSERT INTO som_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Oo daaha waa inaad u samaysaa shan tiir oo qudhac ah, oo dahab ku dahaadh iyaga, qabsatooyinkooduna ha ahaadeen dahab; oo waa inaad shan saldhig oo naxaas ah u yeeshaa. ");
INSERT INTO som_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Oo meesha allabariga waa inaad ka samaysaa qori qudhac ah, dhererkeedu shan dhudhun ha ahaado, ballaadhkeeduna shan dhudhun; oo meesha allabarigu afar geesood ha ahaado, oo sarajooggeeduna saddex dhudhun ha ahaado. ");
INSERT INTO som_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Oo afarteeda rukun waxaad u yeeshaa afar gees; oo geesaheedu waa inay isku waslad la ahaadaan; oo waa inaad naxaas ku dahaadhaa. ");
INSERT INTO som_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Oo waa inaad u samaysaa weelal dambaska lagaga guro, iyo majarafadaheeda, iyo maddiibadaheeda, iyo mudacyadeeda, iyo dabqaadayaasheeda, oo alaabteeda oo dhan waxaad ka samaysaa naxaas. ");
INSERT INTO som_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Oo waa inaad shabag naxaas ah u yeeshaa; oo shabagga dushiisa waa inaad u yeeshaa afar siddo oo naxaas ah oo ku taal afarta gees. ");
INSERT INTO som_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Oo waxaad hoos dhigtaa qarka ku wareegsan meesha allabariga, inuu shabaggu gaadho meesha allabariga kalabadhkeeda. ");
INSERT INTO som_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Oo meesha allabariga waa inaad u yeeshaa ulo qudhac ah oo lagu qaado, oo waxaad ku dahaadhaa naxaas. ");
INSERT INTO som_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Oo ulaheeda waa in siddooyinka laga geliyaa, oo uluhu waa inay meesha allabariga labada dhinac kaga jiraan ha lagu qaadee. ");
INSERT INTO som_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Oo waxaad iyada ka samaysaa looxyo, sida sanduuq madhan oo kale, oo sidii buurta lagugu tusay ha u sameeyeen. ");
INSERT INTO som_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Oo waa inaad samaysaa barxadda taambuugga; oo barxadda dhinaceeda koonfureed waxaad ka lalmisaa daah maro wanaagsan ah oo dhererkiisu yahay boqol dhudhun, ");
INSERT INTO som_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","oo tiirarkiisuna waa inay ahaadaan labaatan, iyo labaatan saldhig oo naxaas ah, oo tiirarka qabsatooyinkooda iyo waxyaalaha laysugu wada xidhaa waa inay lacag ahaadaan. ");
INSERT INTO som_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Oo sidaas oo kale waa inaad dhinaca woqooyina ka lalmisaa daah ah boqol dhudhun, oo tiirarkiisuna ha ahaadeen labaatan, iyo labaatan saldhig oo naxaas ah, oo tiirarka qabsatooyinkooda iyo waxyaalaha laysugu wada xidhaana lacag ha ahaadeen. ");
INSERT INTO som_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Oo barxadda dhinaca galbeed ballaadhkeeda waxaad ka lalmisaa daah konton dhudhun ah, oo tiirarkiisu ha ahaadeen toban, saldhigyadooduna toban. ");
INSERT INTO som_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Oo barxadda dhinaca bari ballaadhkeedu waa inuu konton dhudhun ahaado. ");
INSERT INTO som_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Oo iridda dhinaceeda waxaad ka lalmisaa daah shan iyo toban dhudhun ah; tiirarkiisuna waa inay ahaadaan saddex, saldhigyadooduna saddex. ");
INSERT INTO som_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Oo dhinaca kalena waxaad ka lalmisaa daah shan iyo toban dhudhun ah, tiirarkiisuna waa inay ahaadaan saddex, saldhigyadooduna saddex. ");
INSERT INTO som_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Oo barxadda iriddeeda waxaad u yeeshaa daah labaatan dhudhun ah, oo ah buluug, iyo guduud, iyo casaan, iyo maro wanaagsan oo daabac laga sameeyey, tiirarkiisu ha ahaadeen afar, saldhigyadooduna afar. ");
INSERT INTO som_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Oo tiirarka barxadda ku wareegsan oo dhan waa in lacag laysugu wada xidhaa; oo qabsatooyinkooduna waa inay lacag ahaadaan, saldhigyadooduna waa inay naxaas ahaadaan. ");
INSERT INTO som_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Barxadda dhererkeedu waa inuu ahaado boqol dhudhun, oo ballaadhkeeduna waa inuu meel walba u ahaadaa konton dhudhun, sarajooggeeduna waa inuu ahaado shan dhudhun, kana samee maro wanaagsan oo saldhigyadooduna ha ahaadeen naxaas. ");
INSERT INTO som_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Oo alaabta taambuugga lagaga adeego oo dhan, iyo musmaarradiisa oo dhan, iyo barxadda musmaarradeeda oo dhammu waa inay naxaas wada ahaadaan. ");
INSERT INTO som_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Oo waxaad reer binu Israa'iil ku amartaa inay kuu keenaan saliid saafi ah oo saytuun laga tumay oo laambadda lagu shido, si ay laambaddu had iyo goor u baxdo. ");
INSERT INTO som_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Taambuugga shirka gudihiisa oo ku yaal ilxidhka dibaddiisa, kuna hor yaalla maragga, fiidka ilaa subaxda waa inay Haaruun iyo wiilashiisu Rabbiga hortiisa ku diyaariyaan laambadda; oo wuxuu reer binu Israa'iil u noqon doonaa qaynuun weligiis u jira ka ab ka ab. ");
INSERT INTO som_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Oo soo kaxayso walaalkaa Haaruun iyo wiilashiisa, oo kala soo dhex bax reer binu Israa'iil, inuu iiga adeego hawsha wadaadnimada, kuwaasu waxa weeyaan Haaruun qudhiisa iyo Naadaab, iyo Abiihuu, iyo Elecaasaar, iyo Iitaamaar oo wada ah wiilashii Haaruun. ");
INSERT INTO som_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Oo walaalkaa Haaruun waa inaad u samaysaa dhar quduus ah, ammaan iyo qurux aawadood. ");
INSERT INTO som_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Oo waxaad la hadashaa kulli inta qalbigooda xigmadu ku jirto, oo aan ruuxii xigmadda ka buuxiyey, inay Haaruun dharkiisa u sameeyaan oo ay isaga quduus ka dhigaan inuu iiga adeego hawsha wadaadnimada. ");
INSERT INTO som_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Oo dharka ay u samaynayaanna waxa weeyaan laabgashi, iyo eefod, iyo khamiis, iyo jubbad, iyo duub, iyo dhex-xidh, oo waa inay dhar quduus ah u sameeyaan walaalkaa Haaruun iyo wiilashiisa, inuu iiga adeego hawsha wadaadnimada. ");
INSERT INTO som_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Oo ha qaateen dahab, iyo buluug, iyo guduud, iyo casaan, iyo maro wanaagsan. ");
INSERT INTO som_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Oo eefodka ha ka sameeyeen dahab, iyo buluug, iyo guduud, iyo casaan, iyo maro wanaagsan, oo daabacna ha lagu sameeyo. ");
INSERT INTO som_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Waa inuu lahaadaa laba garab oo is-haysta oo ku xidhan labadiisa daraf, inuu iswada haysto kulligii. ");
INSERT INTO som_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Oo dhex-xidhka daabaca leh oo dusha kaga yaal in lagu xidho waa in isku si loo sameeyaa oo uu isku waslad la ahaadaa; oo ha ahaado dahab, iyo buluug, iyo guduud, iyo casaan, iyo maro wanaagsan. ");
INSERT INTO som_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Oo waxaad qaadataa laba dhagax oo onika la yidhaahdo, oo waxaad dushooda ku xaradhaa magacyada reer binu Israa'iil; ");
INSERT INTO som_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","magacyadooda lix waa inaad isku dhagax ku dhigtaa, oo lixda magac oo hadhayna waa inaad dhagaxa kale ku dhigtaa, siday u kala hor dhasheen. ");
INSERT INTO som_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Sida shuqulka dhagax-xardhihii waa inaad labada dhagax u xaradhaa xaradh u eg xaradhka shaabadda, oo waana inaad ku dhigtaa magacyadii reer binu Israa'iil; oo waa inaad saldhigyo dahab ah ku dhejisaa. ");
INSERT INTO som_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Oo labada dhagax waa inaad ku dhejisaa eefodka garbihiisa inay dhagaxyo xusuus ah u noqdaan reer binu Israa'iil, oo Haaruun waa inuu Rabbiga hortiisa magacyadooda ku qaadaa garbihiisa xusuus ahaan aawadeed. ");
INSERT INTO som_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Oo waa inaad u samaysaa saldhigyo dahab ah, ");
INSERT INTO som_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","oo waa inaad u samaysaa laba silsiladood oo ah dahab saafi ah, oo waxaad u samaysaa sida wax xadhko u eg oo tidcan, oo silsiladaha isku tidcan waa inaad ku xidhaa saldhigyada. ");
INSERT INTO som_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Oo waa inaad samaysaa laabgashi xukumaadeed, oo daabacna ha lagu sameeyo; oo waa inaad u samaysaa sida samaynta eefodka; waana inaad ka samaysaa dahab, iyo buluug, iyo guduud, iyo casaan, iyo maro wanaagsan. ");
INSERT INTO som_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Waa inuu ahaadaa afargeesood oo isku laalaaban; dhererkiisuna ha ahaado taako, ballaadhkiisuna ha ahaado taako. ");
INSERT INTO som_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Oo waa inaad afar saf oo dhagaxyo ah ku dul dhejisaa; safka kowaad ha ahaado sardiyos, iyo tobasiyos, iyo mid birqaya; ");
INSERT INTO som_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","safka labaadna ha ahaado sumurud, iyo safayr, iyo dheemman; ");
INSERT INTO som_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","safka saddexaadna ha ahaado yakintos, iyo agate, iyo ametustos; ");
INSERT INTO som_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","safka afraadna ha ahaado berullos, iyo onika, iyo yasbid; oo waa in lagu dhejiyo saldhigyo dahab ah. ");
INSERT INTO som_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Oo dhagaxyadu waa inay tiro le'ekaadaan sida magacyada reer binu Israa'iil, ha ahaadeen laba iyo toban sida magacyadooda, oo laba iyo tobanka qabiil waa in mid kasta magiciisa lagu xardho sida xaradhka shaabadda. ");
INSERT INTO som_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Oo laabgashiga waxaad ku samaysaa silsilado xadhko u eg oo laga tidcay dahab saafi ah. ");
INSERT INTO som_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Oo laabgashiga waxaad ku samaysaa laba siddo oo dahab ah, oo labada siddo waxaad sudhaa laabgashiga labadiisa darfood. ");
INSERT INTO som_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Oo labada silsiladood oo tidcan oo dahabka ah waxaad ku xidhaa labada siddo oo ku yaal laabgashiga labadiisa darfood. ");
INSERT INTO som_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Oo labada silsiladood oo tidcan labadooda madax oo kale waxaad ku xidhaa labada saldhig, oo waxaad ku xidhaa eefodka garbihiisa xaggooda hore. ");
INSERT INTO som_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Oo waxaad samaysaa laba siddo oo dahab ah, oo waxaad soo sudhaa laabgashiga labadiisa darfood oo gudaha oo eefodka xiga. ");
INSERT INTO som_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Oo waxaad samaysaa laba siddo oo dahab ah, oo waxaad ku xidhaa eefodka labadiisa garab xaggooda hoose oo dhanka hore ku yaal, oo ku dhow meeshay isku xidhmaan, oo ka sarreeya eefodka dhex-xidhkiisa oo daabaca ah. ");
INSERT INTO som_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Oo laabgashiga waa inay siddooyinkiisa ku xidhaan siddooyinkii eefodka oo ha kula xidheen shalash buluug ah, inuu ku dul xidnaado dhex-xidhka daabaca ah oo eefodka, iyo inuusan laabgashigu ka furnaan eefodka. ");
INSERT INTO som_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Oo magacyada reer binu Israa'iil waa in Haaruun ku qaadaa laabgashiga xukumaadda oo qalbigiisa saaran markuu galo meesha quduuska ah, inay xusuus noqdaan Rabbiga hortiisa had iyo goor. ");
INSERT INTO som_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Oo laabgashiga xukumaadda waa inaad gelisaa Uuriimka iyo Tummiimka, oo waa inay Haaruun qalbigiisa saarnaadaan markuu Rabbiga hortiisa tago; oo Haaruun waa inuu qalbigiisa ku qaadaa xukumaadda reer binu Israa'iil had iyo goorba. ");
INSERT INTO som_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Oo khamiiska eefodka kulligiis waa inaad ka dhigtaa buluug. ");
INSERT INTO som_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Oo waa inuu meel daloosha oo madaxu maro ku lahaadaa; oo waa inuu ahaado sida dhar leh tolmo wanaagsan oo daloolkiisa ku wareegsan inuusan dillaacin aawadeed. ");
INSERT INTO som_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Oo khamiiska daraftiisa hoose waxaad u yeeshaa rummaanno oo ah buluug, iyo guduud, iyo casaan, oo ku wada wareeji daraftiisa hareeraheeda oo dhan; oo dawanno dahab ahna dhexdooda geli oo ku wareeji. ");
INSERT INTO som_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Dawan dahab ah iyo rummaan, haddana dawan dahab ah iyo rummaan, waa inaad ku wareejisaa khamiiska daraftiisa. ");
INSERT INTO som_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Oo Haaruun waa inuu gashado inuu ku adeego; oo sanqadhiisana waa la maqli doonaa markuu tago Rabbiga hortiisa oo uu galo meesha quduuska ah, iyo markii uu ka soo baxaba, inuusan dhiman aawadeed. ");
INSERT INTO som_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Oo waa inaad samaysaa waslad khafiifa oo dahab saafiya ah, waxaad ku xaradhaa xaradhka u eg xaradhka shaabadda oo leh, WAA U QUDUUS RABBIGA. ");
INSERT INTO som_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Oo waa inaad ku xidhaa shalash buluug ah, oo ku dhejisaa duubka, oo duubka intiisa hore ha ku taallo. ");
INSERT INTO som_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Oo ha ku taallo Haaruun fooddiisa, Oo Haaruun baa qaadi doona dembiga alaabta quduuska ah, oo ay reer binu Israa'iil quduus kaga dhigi doonaan hadiyadahooda quduuska ah; oo mar kasta waxay ku oolli doontaa fooddiisa, in iyaga laga aqbalo Rabbiga hortiisa. ");
INSERT INTO som_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Oo jubbadda marada wanaagsan laga sameeyey waa inaad daabacdaa oo waa inaad duub ka samaysaa maro wanaagsan, oo dhex-xidh waa inaad ka samaysaa daabac. ");
INSERT INTO som_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Oo wiilasha Haaruunna waa inaad u samaysaa jubbado iyo dhex-xidho, iyo duubab, iyagu ha u ahaadeen ammaan iyo qurux. ");
INSERT INTO som_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Oo waxaad dharkaas u lebbistaa walaalkaa Haaruun iyo wiilashiisa la joogaba; oo waa inaad iyaga subagtaa, oo daahirisaa oo quduus ka dhigtaa, inay iiga adeegaan hawsha wadaadnimada. ");
INSERT INTO som_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Oo waa inaad iyaga u samaysaa sirwaallo maro wanaagsan ah oo gaadha dhexdooda ilaa bowdyahooda, oo ay ku qariyaan cawradooda; ");
INSERT INTO som_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Haaruun iyo wiilashiisu waa inay gashadaan markay galaan taambuugga shirka ama markay meesha allabariga u dhowaadaan inay ka dhex adeegaan meesha quduuska ah inaanay dembi qaadin oo dhiman. Waxay isaga iyo farcankiisa ka dambeeyaba ku noqon doontaa qaynuun weligiis ah. ");
INSERT INTO som_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Oo waxyaalahan waa waxa aad ku samayso iyaga inaad quduus ka dhigtid inay iiga adeegaan hawsha wadaadnimada; waxaad wadataa dibi yar iyo laba wan oo aan iin lahayn, ");
INSERT INTO som_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","iyo kibis aan khamiir lahayn, iyo moofo aan khamiir lahayn oo saliid lagu daray, iyo canjeero aan khamiir lahayn oo saliidu marsan tahay, oo waxaad ka samaysaa bur wanaagsan oo sarreen ah. ");
INSERT INTO som_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Oo waa inaad isku dambiil ku riddaa oo dambiisha ku keentaa, adigoo wada dibigii iyo labadii wan. ");
INSERT INTO som_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Oo Haaruun iyo wiilashiisa waa inaad ilaa iridda teendhada shirka keentaa, oo waa inaad biyo ugu maydhaa. ");
INSERT INTO som_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Oo waxaad qaadataa dharkii, oo waxaad Haaruun u gelisaa jubbadda, iyo khamiiska eefodka, iyo eefodka, iyo laabgashiga, oo dhexdana waxaad ugu xidhaa dhex-xidhka daabaca leh oo eefodka; ");
INSERT INTO som_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","oo duubkana waa inaad madaxiisa saartaa, oo taajka quduuska ahna duubka saar. ");
INSERT INTO som_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Oo markaas waxaad qaadataa saliidda lagu subkado, oo madaxiisa ku shub, oo ugu subag isaga. ");
INSERT INTO som_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Oo waxaad soo kaxaysaa wiilashiisa oo iyagana jubbado u geli. ");
INSERT INTO som_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Oo dhex-xidho ugu xidh, duubabna u duub Haaruun iyo wiilashiisaba; oo qaynuun weligiis ah ayay hawsha wadaadnimada ku lahaan doonaan, oo Haaruun iyo wiilashiisaba waa inaad quduus ka dhigtaa. ");
INSERT INTO som_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Oo dibiga waxaad keentaa teendhada shirka horteeda, Haaruun iyo wiilashiisuna gacmaha ha dul saareen dibiga madaxiisa. ");
INSERT INTO som_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Oo dibiga waxaad ku qashaa Rabbiga hortiisa xagga iridda teendhada shirka. ");
INSERT INTO som_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Oo waxaad qaaddaa dibiga dhiiggiisa, oo fartaada ku mari meesha allabariga geesaheeda; oo dhiigga oo dhan waxaad ku qubtaa meesha allabariga hoosteeda. ");
INSERT INTO som_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Oo waxaad qaaddaa xaydha gudaha ku jirta oo dhan, iyo xuubka beerka ku dul yaal, iyo labada kelyood, iyo xaydha dushooda ku taal, oo meesha allabariga ku dul gub. ");
INSERT INTO som_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Laakiinse dibiga hilibkiisa iyo haraggiisa iyo uuskiisaba waxaad ku gubtaa xerada dibaddeeda; waayo, waa qurbaan dembi loo bixiyey. ");
INSERT INTO som_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Oo haddana waxaad qaaddaa wan; oo Haaruun iyo wiilashiisuna gacmaha ha dul saareen wanka madaxiisa. ");
INSERT INTO som_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Oo markaas waa inaad wanka gowracdaa, oo dhiiggiisa intaad qaadatid waxaad ku dul rushaysaa meesha allabariga. ");
INSERT INTO som_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Oo markaas waa inaad wanka kala googooysaa, oo waxaad maydhaa uurkujirtiisa iyo lugihiisa, oo meel la dhig googo'iisa iyo madaxiisaba. ");
INSERT INTO som_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Oo wanka oo dhan waa inaad ku dul gubtaa meesha allabariga, waayo, waa qurbaan Rabbiga loo gubo; oo waa caraf udgoon oo waa qurbaan dab loogu sameeyo Rabbiga. ");
INSERT INTO som_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Oo haddana waxaad qaaddaa wanka kale; oo Haaruun iyo wiilashiisuna gacmaha ha dul saareen wanka madaxiisa. ");
INSERT INTO som_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Oo markaas waa inaad wanka gowracdaa, oo dhiiggiisa intaad qaadatid waxaad marisaa dhegta midig oo Haaruun caaraddeeda, iyo dhegta midig oo wiilashiisa caaraddeeda, iyo suulka gacantooda midig, iyo suulka cagtooda midig, oo haddana waxaad dhiigga ku dul rushaysaa meesha allabariga. ");
INSERT INTO som_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Oo waxaad qaaddaa dhiigga meesha allabariga ku dul yaal, iyo saliidda lagu subkado, oo waxaad ku rushaysaa Haaruun, iyo dharkiisa, iyo wiilashiisa, iyo dharkii wiilashiisa isaga la jooga; oo waa in quduus laga dhigaa isaga, iyo dharkiisa, iyo wiilashiisa, iyo dharkii wiilashiisa isaga la jooga. ");
INSERT INTO som_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Oo waxaad kaloo qaaddaa wanka baruurtiisa, iyo badhidiisa, iyo xaydhiisa gudaha ku duuban, iyo xuubka beerka ku dul yaal, iyo labadiisa kelyood iyo xaydhooda, iyo bowdada midigta ah; waayo, waa wanka quduuskadhigidda. ");
INSERT INTO som_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Oo dambiisha hor taal Rabbiga oo ay ku jirto kibista aan khamiirka lahaynu waxaad kala soo baxdaa xabbad kibis ah, iyo xabbad ah moofo saliid leh, iyo xabbad canjeero ah; ");
INSERT INTO som_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","oo kulligood waxaad saartaa gacmaha Haaruun, iyo gacmaha wiilashiisa, oo Rabbiga hortiisa ku ruxrux inay ahaadaan qurbaanka la ruxruxo. ");
INSERT INTO som_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Oo markaas waa inaad gacmahooda ka qaaddid, oo waxaad ku dul gubtaa qurbaanka la gubo oo meesha allabariga kor yaal, inay caraf udgoon ku ahaadaan Rabbiga hortiisa. Waa qurbaan dab loogu sameeyey Rabbiga. ");
INSERT INTO som_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Oo waxaad qaaddaa Haaruun wankiisa quduuskadhigidda sakaarkiisa, oo Rabbiga hortiisa ku ruxrux sidii qurbaanka la ruxruxo, oo wuxuuna noqon doonaa qaybtaada. ");
INSERT INTO som_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Oo waa inaad quduus ka dhigtaa sakaarka qurbaanka la ruxruxo, iyo bowdada qurbaanka sare loo qaado, oo la ruxruxo, oo sarena loo qaado, ee wanka quduuskadhigidda, xataa qaybta Haaruun iyo qaybta wiilashiisaba, ");
INSERT INTO som_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","oo intaas waa inay Haaruun iyo wiilashiisu amar ahaan uga lahaadaan reer binu Israa'iil weligoodba, waayo, waa qurbaan sare loo qaado; waana inay ahaato qurbaan sare loo qaado, oo ay reer binu Israa'iil bixiyaan markay ku allabaryaan qurbaannadooda nabaadiinada. Waa qurbaankooda sare loogu qaado Rabbiga. ");
INSERT INTO som_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Oo dharka Haaruun oo quduuska ah waxaa qaadan doona wiilashiisa isaga dabadiis, si loogu subko oo quduus looga dhigo iyagoo gashan. ");
INSERT INTO som_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Oo wiilka isaga meeshiisa wadaad ka noqdaa toddoba maalmood waa inuu gashanaadaa markuu teendhada shirka galo inuu ka adeego meesha quduuska ah. ");
INSERT INTO som_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Oo waa inaad qaaddaa wanka quduuskadhigidda, oo hilibkiisa waxaad ku karisaa meel quduus ah. ");
INSERT INTO som_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Oo Haaruun iyo wiilashiisu waa inay hilibka wanka iyo kibista ku jirta dambiisha cunaan xagga iridda taambuugga shirka. ");
INSERT INTO som_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Oo waa inay cunaan waxyaalahaas lagu kafaaro guday, inay daahir iyo quduus ku noqdaan; laakiinse qof qalaadu yaanu waxba ka cunin, waayo, iyagu waa quduus. ");
INSERT INTO som_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Oo haddii hilibka quduuskadhigidda iyo kibista wax ka hadhaan oo ay gaadhaan ilaa subaxda, de markaas waa inaad intii hadhay dab ku gubtaa, oo waa inaan la cunin, maxaa yeelay, waa quduus. ");
INSERT INTO som_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Oo Haaruun iyo wiilashiisa waxaad ku samaysaa sidii aan kugu amray oo dhan, oo toddoba maalmood waa inaad iyaga quduus ka dhigtaa. ");
INSERT INTO som_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Maalin walba waa inaad dibiga qurbaanka dembiga u bixisaa kafaaraggud aawadiis, oo meesha allabarigana waa inaad daahirisaa markaad u kafaaro gudaysid, oo waa inaad subagtaa inaad quduus ka dhigtid. ");
INSERT INTO som_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Oo toddoba maalmood waa inaad meesha allabariga u kafaaro guddaa oo quduus ka dhigtaa, oo meesha allabarigu waa inay ugu wada quduusnaataa, oo wax kasta oo meesha allabariga taabtaa quduus wuu noqon doonaa. ");
INSERT INTO som_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Haddaba waxanu waa wixii aad meesha allabariga ku dul bixin lahayd; maalin walba had iyo goor waa inaad laba wan oo sannad jira ku bixisaa. ");
INSERT INTO som_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Wan waa inaad subaxda bixisaa, wanka kalena waa inaad makhribka bixisaa. ");
INSERT INTO som_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Oo bur wanaagsan oo hiin rubuceed oo saliid saafi ah lagu daray toban meelood oo meel waa inaad wanka la bixisaa, iyo weliba hiin rubuceed oo khamri ah oo ah qurbaankii cabniinka. ");
INSERT INTO som_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Oo wanka kalena waa inaad makhribka bixisaa, oo waxaad u bixisaa sida qurbaanka hadhuudhka ah oo subaxda, iyo qurbaanka cabniinka oo subaxda, caraf udgoon ha lahaado hana ahaado qurbaan Rabbiga dab loogu sameeyo. ");
INSERT INTO som_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Oo wuxuu ka ab ka ab ahaan doonaa qurbaan joogto ah oo Rabbiga hortiisa lagu gubo xagga iridda taambuugga shirka, oo ah meesha aan kugula kulmi doono inaan kula hadlo aawadeed. ");
INSERT INTO som_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Oo halkaas reer binu Israa'iil ayaan kula kulmi doonaa; oo taambuugguna wuxuu quduus ku noqon doonaa ammaantayda. ");
INSERT INTO som_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Oo waxaan quduus ka dhigi doonaa taambuugga shirka iyo meesha allabariga; oo Haaruun iyo wiilashiisana quduus baan ka dhigi doonaa, inay hawsha wadaadnimada iiga adeegaan. ");
INSERT INTO som_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Oo anigu waxaan dhex joogi doonaa reer binu Israa'iil, oo waxaan ahaan doonaa Ilaahood. ");
INSERT INTO som_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Oo iyagu waxay ogaan doonaan inaan anigu ahay Rabbiga Ilaahood ah oo iyaga dalkii Masar ka soo bixiyey inaan iyaga dhex joogo. Anigu waxaan ahay Rabbiga ah Ilaahood. ");
INSERT INTO som_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Oo waxaad samaysaa meel allabari oo foox lagu shido; waxaadna ka samaysaa qori qudhac ah. ");
INSERT INTO som_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Oo dhererkeeduna ha ahaado dhudhun, ballaadhkeeduna ha ahaado dhudhun, afar geesoodna waa inay lahaataa, sarajooggeeduna ha ahaado laba dhudhun, oo geesaheeduna waa inay isku waslad la ahaadaan. ");
INSERT INTO som_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Oo waa inaad dahab saafi ah ku dahaadhaa dusheeda iyo dhinacyadeeda ku wareegsan iyo geesaheedaba; oo waxaad u samaysaa wax taaj oo kale ah oo dahab ah oo ku wareegsan. ");
INSERT INTO som_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Oo qarkeeda hoostiisa waa inaad laba siddo oo dahab ah ugu yeeshaa labada rukun; labada dhinac waa inaad sidaas u yeeshaa, oo waxay u noqon doonaan meelihii ulaha lagu qaado laga gelin lahaa. ");
INSERT INTO som_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Oo waxaad ulaha ka samaysaa qori qudhac ah, waana inaad dahab ku dahaadhaa. ");
INSERT INTO som_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Oo waxaad hor dhigtaa ilxidhka u dhow sanduuqa maragga oo hor yaal daboolka ka sarreeya maragga, halkaas oo ah meesha aan kugula kulmi doono. ");
INSERT INTO som_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Oo Haaruun waa inuu ku shido foox udgoon; subax walba markuu laambadaha hagaajinayo waa inuu foox shido. ");
INSERT INTO som_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Oo makhribka Haaruun markuu laambadaha shidayo waa inuu foox shido, kaasoo ah foox joogto u ah Rabbiga hortiisa, ka ab ka ab. ");
INSERT INTO som_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Oo waa inaydnaan dusheeda ku bixin foox qalaad, ama qurbaan la gubo, ama qurbaan hadhuudh ah, oo dusheedana ha ku daadinina qurbaan cabniin ah. ");
INSERT INTO som_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Geesaheedana sannaddiiba mar Haaruun waa inuu ku dul kafaaro gudo; oo dhiigga allabariga dembiga oo kafaaraggud ah sannaddiiba mar waa inuu ku kafaaro gudo tan iyo ka ab ka ab. Waa kan ugu wada quduusan Rabbiga. ");
INSERT INTO som_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Markaasuu Rabbigu Muuse la hadlay, oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","Markaad reer binu Israa'iil tirinaysid, intii ay tiradoodu noqoto oo dhan, nin waluba waa inuu Rabbiga siiyo madaxfurashadiisa, markaad tirisid; si aan belaayo ugu dhicin markaad iyaga tirisid. ");
INSERT INTO som_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Oo waxan waa inay bixiyaan, nin walba oo u gudba kuwa la tiriyey waa inuu bixiyaa nus sheqel le'eg sheqelkii meesha quduuska ah: (sheqelku waa labaatan geeraah:) nus sheqel waa in Rabbiga loo bixiyaa. ");
INSERT INTO som_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Oo mid kasta oo u gudba kuwa la tiriyey oo ah inta jirta labaatan sannadood iyo wixii ka sii weyn, waa inuu bixiyaa Rabbiga wixiisa. ");
INSERT INTO som_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Markay Rabbiga wixiisa u bixinayaan inay nafihiinna u kafaaro gudaan, kii taajir ahu waa inaanu bixin wax nus sheqel ka badan, kii miskiin ahuna waa inaanu bixin wax nus sheqel ka yar. ");
INSERT INTO som_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Oo waa inaad reer binu Israa'iil ka qaaddaa lacagta kafaaraggudka ah, oo aad wax kaga qabataa hawsha taambuugga shirka, inay reer binu Israa'iil u noqoto xusuus Rabbiga hortiisa, si aad nafihiinna ugu kafaaro guddaan. ");
INSERT INTO som_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Markaasuu Rabbigu Muuse la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","Waxaad samaysaa berked weyso oo naxaas ah, salkeedana waxaad ka samaysaa naxaas, oo waxaad dhigtaa meel u dhexaysa taambuugga shirka iyo meesha allabariga; oo waa inaad biyo ku shubtaa, ha lagu maydho e. ");
INSERT INTO som_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Haaruun iyo wiilashiisu waa inay gacmaha iyo cagaha ku dhaqdaan: ");
INSERT INTO som_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","oo markay gelayaan taambuugga shirka waa inay biyo ku maydhaan, yaanay dhimanine, ama markay meesha allabariga ag yimaadaan inay ka adeegaan oo ay gubaan qurbaan Rabbiga dab loogu sameeyo, ");
INSERT INTO som_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","waa inay gacmaha iyo cagahaba dhaqdaan, yaanay dhimanine; oo wuxuu iyaga u noqon doonaa qaynuun weligiis ah, xataa xagga isaga iyo farcankiisa ka dambeeyaba ka ab ka ab. ");
INSERT INTO som_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Oo markaasuu haddana Rabbigu Muuse la hadlay oo ku yidhi, ");
INSERT INTO som_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","Waxaad qaadataa dhir udgoon oo wacan, oo ah shan boqol oo sheqel oo ah malmal asli ah, iyo badhkiis oo qorfe macaan ah, oo ah laba boqol iyo konton sheqel, iyo laba boqol iyo konton sheqel oo ah kalamus, ");
INSERT INTO som_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","iyo shan boqol oo sheqel oo ah kasiya, oo le'eg sheqelka meesha quduuska ah, iyo hiin muggeed oo saliid saytuun ah. ");
INSERT INTO som_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Oo waxaad ka samaysaa saliid lagu subkado oo quduus ah, taas oo ah cadar laysku daray sidii kan cadarsameeyaha oo kale; oo waxay noqon doontaa saliid lagu subkado oo quduus ah. ");
INSERT INTO som_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Oo waxaad ku subagtaa taambuugga shirka iyo sanduuqa maragga, ");
INSERT INTO som_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","iyo miiska iyo alaabtiisa oo dhan, iyo laambadda iyo alaabteeda, iyo meesha allabariga ee fooxa, ");
INSERT INTO som_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","iyo meesha allabariga lagu gubo iyo alaabteeda oo dhan, iyo berkedda weysada iyo salkeedaba. ");
INSERT INTO som_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Oo waa inaad iyaga quduus ka dhigtaa, inay noqdaan kuwa ugu wada quduusan; oo wax kasta oo iyaga taabtaaba waxay noqon doonaan quduus. ");
INSERT INTO som_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Oo Haaruun iyo wiilashiisaba waa inaad u subagtaa oo quduus ka dhigtaa, inay iiga adeegaan hawsha wadaadnimada. ");
INSERT INTO som_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Oo waa inaad la hadashaa reer binu Israa'iil oo waxaad ku tidhaahdaa, Tanu waxay ka ab ka ab ii noqon doontaa saliid lagu subkado oo quduus ah. ");
INSERT INTO som_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Haddaba waa inaan dad jidhkiisa lagu shubin, ama waa inaydnaan samayn mid la mid ah, oo sideeda oo kale loo sameeyey, waayo, iyadu waa quduus, oo waxay idiin noqon doontaa quduus. ");
INSERT INTO som_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Oo ku alla kii taas oo kale sameeya, ama ku alla kii qof qalaad mariya, dadkiisa waa laga gooyn doonaa. ");
INSERT INTO som_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Markaasaa Rabbigu wuxuu Muuse ku yidhi, Waxaad qaadataa uunsi udgoon oo ah istakte iyo onika iyo galbanum, iyagoo ah uunsi ay ku jirto beeyo saafi ah, oo miisaankooduna ha iswada le'ekaado. ");
INSERT INTO som_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Oo waxaad ka samaysaa foox, kaas oo loo sameeyey sida cadarsameeyuhu uu u sameeyo oo kale, oo cusbo lagu daray, oo saafi ah, quduusna ah. ");
INSERT INTO som_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Oo qaarkiis waa inaad tuntaa oo yaryaraysaa, oo waxaad hor dhigtaa maragga ku jira taambuugga shirka, taasoo ah meesha aan kugula kulmi doono; oo waxay idiin noqon doontaa kan ugu wada quduusan. ");
INSERT INTO som_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Oo fooxa aad samayn doontaan sidiisa ha u samaysanina; waayo, wuxuu kuu noqon doonaa quduus Rabbiga aawadiis. ");
INSERT INTO som_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Oo ku alla kii kaas oo kale sameeya, inuu ku udgoonsado, kaas dadkiisa waa laga gooyn doonaa. ");
INSERT INTO som_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Markaasaa Rabbigu Muuse la hadlay, oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","Bal eeg, magac baan ugu yeedhay Besaleel ina Uurii, oo ah ina Xuur, qabiilkiisuna yahay Yahuudah; ");
INSERT INTO som_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","oo waxaan isaga ka buuxiyey Ruuxa Ilaah, xagga xigmadda, iyo waxgarashada, iyo aqoonta, iyo sancada cayn kasta ah, ");
INSERT INTO som_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","inuu shuqullo yaab leh hindiso, oo uu ka shaqeeyo dahabka, iyo lacagta, iyo naxaasta, ");
INSERT INTO som_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","iyo inuu qoro dhagaxyada saldhigyo lagu dhejiyo oo uu looxyada xardho, iyo inuu ka shaqeeyo sanco cayn kasta ah. ");
INSERT INTO som_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Oo bal eeg, waxaan isaga la doortay Aaholii'aab oo ah ina Axiisaamaag, oo qabiilkiisu yahay Daan; oo inta xigmadda leh oo dhan waxaan qalbigooda geliyey xigmad, inay sameeyaan wixii aan kugu amray oo dhan; ");
INSERT INTO som_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","kuwaasoo ah taambuugga shirka, iyo sanduuqa maragga, iyo daboolka dul saaran, iyo alaabta Taambuugga oo dhan, ");
INSERT INTO som_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","iyo miiska iyo alaabtiisa, iyo laambadaha saafiga ah, iyo alaabtooda oo dhan, iyo meesha allabariga oo fooxa, ");
INSERT INTO som_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","iyo meesha allabariga lagu gubo, iyo alaabteeda oo dhan, iyo berkedda weysada iyo salkeeda, ");
INSERT INTO som_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","iyo dharka adeegidda, iyo dharka quduuska ah oo wadaadka Haaruun ah, iyo dharka wiilashiisaba, inay ka adeegaan hawsha wadaadnimada, ");
INSERT INTO som_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","iyo saliidda lagu subkado, iyo fooxa uunsiga udgoon ah oo meesha quduuska ah, oo wax walba sidii aan kugu amray waa inay u sameeyaan. ");
INSERT INTO som_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Markaasaa Rabbigu Muuse la hadlay, oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Waxaad la hadashaa reer binu Israa'iil, oo waxaad ku tidhaahdaa, Sida runta ah waa inaad dhawrtaan ayaamahayga sabtiyaasha ah: waayo, waa calaamo ina dhex taal aniga iyo idinka ka ab ka ab; si aad u ogaataan inaan anigu ahay Rabbiga quduus idinka dhigaya. ");
INSERT INTO som_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Haddaba waa inaad dhawrtaan sabtida, waayo, waa idiin quduus, oo mid kasta oo ka dhiga wax aan quduus ahayn hubaal waa in la dilaa, waayo, ku alla kii maalintaas shaqeeya, de qofkaas waa in laga gooyaa dadkiisa. ");
INSERT INTO som_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Lix maalmood waa in shuqul la qabtaa, laakiinse maalinta toddobaad waa sabti nasasho ah oo Rabbiga quduus u ah; oo ku alla kii maalinta sabtidaa shuqul qabta hubaal waa in la dilaa. ");
INSERT INTO som_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Sidaas daraaddeed reer binu Israa'iil waa inay sabtida dhawraan, iyagoo ka ab ka ab sabtida u dhawra axdi weligiis ah aawadiis. ");
INSERT INTO som_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Waa calaamo weligeed ina dhex taal aniga iyo reer binu Israa'iil; waayo, Rabbigu lix maalmood buu ku sameeyey samada iyo dhulka, oo maalintii toddobaadna wuu nastay, wuuna qabowsaday. ");
INSERT INTO som_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Oo markii uu dhammeeyey hadalkii uu kula hadlayay Buur Siinay dusheeda, ayuu Muuse siiyey labadii loox ee maragga iyagoo ah looxyo dhagaxyo ah, oo fartii Ilaah lagu qoray. ");
INSERT INTO som_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Oo markii dadkii arkay in Muuse raagay oo uusan buurtii ka soo degin, ayaa dadkii iyagoo urursan Haaruun u yimaadeen, oo waxay ku yidhaahdeen, Kac, oo inoo samee ilaahyo ina hor socda; waayo, Muusahan oo ah ninkii inaga soo bixiyey dalkii Masar, garan mayno wax ku dhacay. ");
INSERT INTO som_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Markaasaa Haaruun wuxuu iyagii ku yidhi, Soo bixiya hilqadaha dahabka ah oo dhegaha ugu jira naagihiinna, iyo wiilashiinna, iyo gabdhihiinna, oo ii keena. ");
INSERT INTO som_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Markaasaa dadkii oo dhammu waxay soo bixiyeen hilqadihii dahabka ahaa oo dhegaha ugu jiray oo waxay u keeneen Haaruun. ");
INSERT INTO som_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Kolkaasuu gacmahooda ka guddoomay, oo wuxuu ku xardhay alaabta wax lagu xardho, wuxuuna ka sameeyey weyl dahab la shubay ah; oo waxay yidhaahdeen, Reer binu Israa'iilow, kanu waa ilaahiinnii dalka Masar idinka soo waday. ");
INSERT INTO som_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Oo Haaruun markuu arkay ayuu meel allabari ka hor dhisay, markaasaa Haaruun ogeysiis ku dhawaaqay, oo wuxuu yidhi, Berri waa iiddii Rabbiga. ");
INSERT INTO som_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Markaasay subaxdii dambe aroor hore keceen, oo waxay bixiyeen qurbaanno la gubo, oo waxay keeneen qurbaanno nabaadiino, markaasay dadkii u fadhiisteen inay wax cunaan oo wax cabbaan, oo ay u keceen inay cayaaraan. ");
INSERT INTO som_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Markaasaa Rabbigu wuxuu Muuse ku yidhi, Kac oo hoos u deg, waayo, dadkaagii aad dalkii Masar ka soo bixisay, way iskharribeen, ");
INSERT INTO som_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","oo haddiiba way ka leexdeen jidkii aan ku amray, oo waxay samaysteen weyl dahab la shubay ah, wayna caabudeen, oo allabarina way u bixiyeen, oo waxayna yidhaahdeen, Reer binu Israa'iilow, kanu waa ilaahiinnii dalka Masar idinka soo waday. ");
INSERT INTO som_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Kolkaasaa Rabbigu wuxuu Muuse ku yidhi, Anigu dadkan waan arkay oo waa dad madax adag, ");
INSERT INTO som_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","haddaba iska kay daa, aan aad ugu cadhoodee, oo aan kulligood baabbi'iyee, oo waxaan adiga kaa dhigi doonaa quruun weyn. ");
INSERT INTO som_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Markaasaa Muuse baryay Rabbiga Ilaahiis ah oo wuxuu ku yidhi, Rabbiyow, maxaad aad ugu cadhoonaysaa dadkaaga aad dalkii Masar kaga soo bixisay itaal weyn iyo gacan xoog leh? ");
INSERT INTO som_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Bal Masriyiintu maxay u odhan doonaan, Wuxuu iyaga u saaray xumaan inuu buuraha ku laayo iyo inuu dhulka iyaga ka baabbi'iyo? Rabbiyow, ka leexo cadhadaada kulul oo ka noqo xumaantan aad damacsan tahay inaad dadkaaga ku samaysid. ");
INSERT INTO som_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Bal xusuuso addoommadaadii ahaa Ibraahim, iyo Isxaaq, iyo Israa'iil, oo aad naftaada ugu dhaaratay, oo aad ku tidhi, Farcankiinna waxaan u badin doonaa sida xiddigaha cirka, oo dalkan aan ka hadlay oo dhan waxaan siin doonaa farcankiinna, wayna dhaxli doonaan weligood. ");
INSERT INTO som_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Markaasaa Rabbigu ka noqday xumaantii uu damacsanaa inuu dadkiisa ku sameeyo. ");
INSERT INTO som_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Markaasuu Muuse jeestay, oo buurtii hoos uga degay, isagoo labadii loox oo maragga ahaa gacanta ku sita, looxyadana wax baa kaga qornaa labadooda dhinacba; oo dhankan iyo dhankaasba wax qoran baa kaga yiil. ");
INSERT INTO som_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Oo looxyadu waxay ahaayeen shuqulkii Ilaah, oo farta ku qoranuna waxay ahayd fartii Ilaah oo looxyada ku xardhan. ");
INSERT INTO som_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Oo markii Yashuuca maqlay qayladii ay dadku ku qaylinayeen ayuu Muuse ku yidhi, War xeradii qaylo colaadeed baa ka yeedhaysa. ");
INSERT INTO som_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Markaasuu ku yidhi, Kaasu ma aha codka kuwa guulaysta, mana aha codka kuwa laga adkaado, laakiinse waxaan maqlayaa kuwa gabyaya codkood. ");
INSERT INTO som_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Oo markuu xeradii ku soo dhowaaday wuxuu arkay weyshii iyo cayaartii; markaasaa Muuse aad u cadhooday, looxyadiina gacmihiisa wuu ka tuuray, oo wuxuu ku jejebiyey buurta hoosteedii. ");
INSERT INTO som_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Markaasuu weyshii ay samaysteen qaaday, dab buuna ku gubay oo daqiijiyey, oo intuu biyaha ku dul daadiyey ayuu reer binu Israa'iil cabsiiyey. ");
INSERT INTO som_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Markaasaa Muuse wuxuu Haaruun ku yidhi, War maxaa dadkanu kugu sameeyey oo aad dembi weyn ugu keentay? ");
INSERT INTO som_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Markaasaa Haaruun wuxuu yidhi, Sayidkaygiiyow, bal ha ii cadhoon; waayo, adiguba waad og tahay inay dadkanu sharka jecel yihiin. ");
INSERT INTO som_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Waayo, waxay igu yidhaahdeen, Inoo samee ilaahyo ina hor socda, waayo, Muusahan oo ah ninkii inaga soo bixiyey dalkii Masar, garan mayno wax ku dhacay. ");
INSERT INTO som_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Markaasaan ku idhi, Ku alla kii dahab haystaa, ha siibo. Kolkaasay i siiyeen, anna dabkaan ku tuuray, oo waxaa ka soo baxday weyshan. ");
INSERT INTO som_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Oo markii Muuse arkay in dadkii layska sii daayay, waayo, Haaruun baa sii daayay oo ku kashifay cadaawayaashooda hortooda, ");
INSERT INTO som_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","ayuu Muuse istaagay xerada iriddeedii, oo wuxuu yidhi, Ku alla kii Rabbiga la gees ahow, ii kaalay. Markaasay reer Laawi oo dhammu agtiisa ku soo urureen. ");
INSERT INTO som_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Markaasuu wuxuu iyagii ku yidhi, Rabbiga ah Ilaaha reer binu Israa'iil sidan buu leeyahay, Nin waluba seeftiisa dhinaca ha ku xidho, oo kulligiin irid ilaa irid xerada hore iyo dib u dhex qaada, oo nin waluba ha dilo walaalkiis, iyo saaxiibkiis, iyo deriskiisaba. ");
INSERT INTO som_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Oo reer Laawi waxay yeeleen hadalkii Muuse, oo maalintaas dadkii waxaa ka dhintay qiyaastii saddex kun oo nin. ");
INSERT INTO som_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Markaasaa Muuse wuxuu ku yidhi, Inuu maanta barako idinku soo dejiyo aawadeed, Rabbiga quduus isaga dhiga oo nin waluba ha ka gees noqdo wiilkiisa iyo walaalkiisba. ");
INSERT INTO som_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Oo waxaa dhacday, in Muuse maalintii dambe dadkii ku yidhi, Idinku dembi weyn baad samayseen, oo haatan waxaan kor ugu tegayaa Rabbiga; mindhaa dembigiinna aawadiis ayaan u kafaaro gudi doonaaye. ");
INSERT INTO som_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Markaasaa Muuse wuxuu ku noqday Rabbiga xaggiisa, oo wuxuu yidhi, Bal dadkanu dembi weyn bay sameeyeen, oo waxay samaysteen ilaahyo dahab ah. ");
INSERT INTO som_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Laakiin hadda haddaad dembigooda cafidid; haddii kalese waan ku baryayaaye, kitaabkaaga aad qortay iga tir. ");
INSERT INTO som_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Markaasaa Rabbigu wuxuu Muuse ku yidhi, Ku alla kii igu dembaabay weeye kan aan kitaabkayga ka tirayaa. ");
INSERT INTO som_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Ee haddaba tag, oo meeshii aan kaala hadlay dadka u hor kac, oo bal eeg, malaa'igtayda ayaa ku hor kici doontee; habase yeeshee maalinta aan soo booqdo ayaan dembigooda u ciqaabi doonaa. ");
INSERT INTO som_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Markaasaa Rabbigu dadkii belaayo ku riday, waayo, waxay sameeyeen weyshii taasoo tii Haaruun sameeyey ahayd. ");
INSERT INTO som_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Markaasaa Rabbigu wuxuu Muuse ku yidhi, Tag, oo halkan ka socda, adiga iyo dadkii aad dalkii Masar ka soo bixisayba, oo waxaad u kacdaan dalkii aan ugu dhaartay Ibraahim, iyo Isxaaq, iyo Yacquub, oo aan mid walba ku idhi, Farcankaagaan siin doonaa. ");
INSERT INTO som_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Oo waxaan hortiinna ku soo diri doonaa malaa'ig, oo waan eryi doonaa reer Kancaan, iyo reer Amor, iyo reer Xeed, iyo reer Feris, iyo reer Xiwi, iyo reer Yebuus. ");
INSERT INTO som_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","U kaca dalkaas caanaha iyo malabka la barwaaqaysan. Anigu idin dhex socon maayo, waayo, waaba intaasoo aan jidka idinku baabbi'iyaa, maxaa yeelay, idinku waxaad tihiin dad madax adag. ");
INSERT INTO som_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Oo markii dadkii warkaas xun maqlay, ayay wada calool xumaadeen, oo midkoodna ma xidhan wixii uu isku sharrixi jiray. ");
INSERT INTO som_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Markaasaa Rabbigu wuxuu Muuse ku yidhi, Waxaad reer binu Israa'iil ku tidhaahdaa, Idinku waxaad tihiin dad madax adag, oo haddii aan daqiiqad qudh ah dhexdiinna imaado, waan idin baabbi'in; haddaba wixii aad isku sharrixi jirteen, iska fura, bal inaan ogaado waxaan idinku sameeyo. ");
INSERT INTO som_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Markaasaa reer binu Israa'iil waxay Buur Xoreeb ka bilaabeen inay iska furaan wixii ay isku sharrixi jireen. ");
INSERT INTO som_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Haddaba Muuse wuxuu qaadi jiray taambuugga oo uu ka dhisi jiray xerada dibaddeeda, meel xerada ka durugsan; oo wuxuu u bixiyey Taambuuggii shirka. Oo mid kasta oo Rabbiga doonay, wuxuu u baxay taambuuggii shirka oo xerada dibaddeeda ahaa. ");
INSERT INTO som_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Oo markii Muuse Taambuuggii u baxay, dadkii oo dhammu way wada keceen, oo nin waluba teendhadiisa iriddeeda ayuu istaagay, oo waxay eegayeen Muuse ilaa uu Taambuuggii galay. ");
INSERT INTO som_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Oo markii Muuse Taambuuggii galay ayaa tiirkii daruurta ahaa soo degay oo Taambuugga iriddiisii qotonsaday, markaasaa Rabbigu Muuse la hadlay. ");
INSERT INTO som_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Oo dadkii oo dhammuna way wada arkeen tiirkii daruurta ahaa oo Taambuugga iriddiisii hor qotoma; kolkaasay dadkii oo dhammu wada kaceen oo Ilaah caabudeen, nin walba oo teendhadiisa iriddeeda ag jooga. ");
INSERT INTO som_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Markaasaa Rabbigu wuxuu Muuse ula hadlay sida nin saaxiibkiis ula hadlo, iyagoo iska soo hor jeeda. Kolkaasuu haddana xeradii ku soo noqday; laakiinse midiidinkiisii ahaa Yashuuca ina Nuun oo nin dhallinyar ahaa ayaan Taambuuggii ka bixin. ");
INSERT INTO som_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Muusena wuxuu Rabbiga ku yidhi, Bal eeg, waxaad i leedahay, Dadkan kaxee, oo imana aad ogeysiin kan aad ila diraysid. Laakiin waxaad igu tidhi, Magacaaga waan kugu aqaan, oo raalli baan kaa ahay. ");
INSERT INTO som_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Haddaba waan ku baryayaaye, haddaad raalli iga tahay, jidadkaaga i tus, inaan ku ogaado aawadeed, oo aad raalli iga ahaato, oo bal fiiri in quruuntanu tahay dadkaaga. ");
INSERT INTO som_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Markaasuu wuxuu ku yidhi, Anigu waan kula socon doonaa, oo waan ku nasin doonaa. ");
INSERT INTO som_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Markaasuu isna ku yidhi, Haddaba haddaanad ila socon, halkan ha naga kaxayn. ");
INSERT INTO som_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Waayo, sidee baa lagu garanayaa inaad raalli naga tahay, aniga iyo dadkaagaba? Miyaanay ahayn inaad nala socoto si aannu aniga iyo dadkaaguba uga duwanaanno dadka dhulka jooga oo dhan? ");
INSERT INTO som_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Markaasaa Rabbigu wuxuu Muuse ku yidhi, Weliba waxan aad ku hadashay waan kuu samayn doonaa; waayo, raalli baan kaa ahay, oo magacaagana waan kugu aqaan. ");
INSERT INTO som_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Markaasuu yidhi, Waan ku baryayaaye, ammaantaada i tus. ");
INSERT INTO som_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Isna wuxuu ku yidhi, Wanaaggayga oo dhan ayaan hortaada soo marin, oo magaca Rabbiga ayaan hortaada ku naadin, oo waan u roonaan kii aan doonayo inaan u roonaado, waanan u naxariisan kii aan doonayo inaan u naxariisto. ");
INSERT INTO som_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Oo wuxuu yidhi, Adigu wejigayga arki kari maysid, waayo, dad i arkaa noolaan maayo. ");
INSERT INTO som_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Markaasaa Rabbigu wuxuu yidhi, Bal eeg, meel baa agtayda ah, oo waxaad isku taagi doontaa dhagaxa weyn, ");
INSERT INTO som_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","oo markii ay ammaantaydu ku ag marayso, waxaan ku gelin doonaa meel dhagaxa ka dillaacsan, oo gacantaydaan kugu dabooli doonaa ilaa aan ku dhaafo; ");
INSERT INTO som_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","oo haddana waan kaa qaadi doonaa gacantayda, oo waxaad arki doontaa dhabarkayga, laakiinse wejigayga la arki maayo. ");
INSERT INTO som_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Markaasaa Rabbigu wuxuu Muuse ku yidhi, Waxaad soo qortaa laba loox oo dhagax ah oo kuwii hore u eg, oo waxaan looxyada ku qori doonaa erayadii ku qornaa looxyadii hore, oo aad jebisay. ");
INSERT INTO som_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Oo subaxda diyaar ahow, oo Buur Siinay subaxda soo fuul, oo halkaas buurta dusheeda ah iigu kaalay. ");
INSERT INTO som_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Oo ninna yuusan kula soo fuulin, oo buurta dhan yaan ninna lagu arkin, oo adhi iyo lo' toona yaanay buurta horteeda daaqin. ");
INSERT INTO som_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Markaasuu qoray laba loox oo dhagax ah oo kuwii hore u eg; kolkaasuu Muuse aroor hore kacay, oo Buur Siinay fuulay sidii Rabbigu ku amray, oo gacantana wuxuu ku qaaday laba loox oo dhagax ah. ");
INSERT INTO som_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Markaasaa Rabbigu daruurtii ku soo degay, oo halkaas isla taagay, oo wuxuu naadiyey magicii Rabbiga. ");
INSERT INTO som_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Kolkaasaa Rabbigu hortiisa maray oo naadiyey isagoo leh, Waxaan ahay Rabbiga, Rabbiga, oo ah Ilaah raxmad iyo roonaan badan, oo cadho u gaabiya, oo naxariis iyo run badan, ");
INSERT INTO som_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","oo kumankun u naxariista, oo xumaanta iyo xadgudubka iyo dembiga dhaafa, laakiin aan sinaba u caddayn in kan dembiga galay aanu eed lahayn; oo xumaantii awowayaasha soo gaadhsiiya carruurtooda iyo carruurta carruurtooda tan iyo farcanka saddexaad iyo kan afraadba. ");
INSERT INTO som_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Markaasaa Muuse intuu dhaqsaday u sujuuday oo caabuday. ");
INSERT INTO som_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Kolkaasuu wuxuu yidhi, Haddaba, Rabbiyow, haddii aad raalli iga tahay, waan ku baryayaaye, Rabbiyow, bal na dhex soco oo naga cafi xumaantayada iyo dembigayaga, waayo dadkanu waa dad madax adag, ee annaga dhaxal ahaan noo qaado. ");
INSERT INTO som_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Markaasuu ku yidhi, Bal eeg, axdi baan dhigayaa; dadkaaga oo dhan hortiisa waxaan ku samayn doonaa cajaa'ibyo aan weligood lagu samayn dhulka oo dhan iyo quruunnaba; oo dadka aad dhex joogto oo dhammu waxay arki doonaan shuqulka Rabbiga, waayo, waxaan kugu samaynayaa waa wax cabsi badan. ");
INSERT INTO som_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Waxaad dhawrtaa waxaan maanta kugu amrayo; oo bal ogow, hortaada waxaan ka eryayaa reer Amor, iyo reer Kancaan, iyo reer Xeed, iyo reer Feris, iyo reer Xiwi, iyo reer Yebuus. ");
INSERT INTO som_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Haddaba iska jira, oo axdi ha la dhiganina dadka deggan dalka aad u socotaan, waaba intaasoo ay dabin ku noqoto dhexdiinna, ");
INSERT INTO som_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","laakiinse waa inaad dumisaan meelahooda allabariga, oo burburisaan tiirarkooda, oo gooysaan geedahooda Asheeraah, ");
INSERT INTO som_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","waayo, idinku waa inaydnaan caabudin ilaah kale, maxaa yeelay, Rabbiga magiciisu yahay Masayr waa Ilaah masayr ah; ");
INSERT INTO som_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","waaba intaasoo aad axdi la dhigataan dadka dalkaas deggan, oo ay ilaahyadooda raacaan sida naagi ninkeeda uga dhillowdo, oo ay allabari u bixiyaan ilaahyadooda, oo inta laydiin yeedho, aad allabarigiisa wax ka cuntaan, ");
INSERT INTO som_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","oo waaba intaasoo aad gabdhahooda u guurisaa wiilashaada, oo ay gabdhahooduna ilaahyadooda raacaan sida dhillooyin oo kale, oo ay wiilashaadana u jiitaan inay raacaan ilaahyadooda. ");
INSERT INTO som_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Waa inaanad samaysaan ilaahyo shub ah. ");
INSERT INTO som_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Waa inaad dhawrtaan Iiddii Kibista-aan-khamiirka-lahayn. Oo toddoba maalmood waa inaad cuntaan kibis aan khamiir lahayn, sidii aan kugu amray wakhtigii la yidhi ee bishii Aabiib ahayd, maxaa yeelay, bishii Aabiib ayaad Masar ka soo baxday. ");
INSERT INTO som_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Kulli intii maxal furta anigaa iska leh, iyo kulli xoolahaaga intooda lab oo ah curadyada dibida iyo wananka oo dhan. ");
INSERT INTO som_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Oo dameerka curadka ah waa inaad wan yar ku furataa, oo haddaanad furanin, de waa inaad qoorta ka jebisaa. Oo dadkaaga curadyadiisa oo dhan waa inaad furataa. Oo hortayda midna yuusan iman isagoo faro madhan. ");
INSERT INTO som_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Lix maalmood waa inaad shaqaysaan, laakiinse maalinta toddobaad waa inaad nasataan; ha ahaatee xilliga beeraha la falo iyo xilliga beeraha la goostoba waa inaad maalinta toddobaad nasataan. ");
INSERT INTO som_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Oo waa inaad dhawrtaan Iidda Toddobaadyada, taasoo ah marka la goosto midhaha ugu horreeya ee sarreenka, iyo Iidda Waxurursiga ah marka sannadda ugu dambaysa. ");
INSERT INTO som_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Sannaddiiba saddex goor waa inay labkiinna oo dhammu ka hor yimaadaan Rabbiga Ilaaha ah, Ilaaha reer binu Israa'iil. ");
INSERT INTO som_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Waayo, anigu quruumaan hortiinna ka eryi doonaa, oo soohdimihiinnana waan ballaadhin doonaa; oo ninnaba dalkiinna ma damci doono markii aad sannaddiiba saddex goor u baxdaan inaad Rabbiga Ilaahiinna ah ka hor tagtaan. ");
INSERT INTO som_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Waa inaydnaan dhiigga allabarigayga la bixin kibis khamiir leh, oo waa inaan allabariga Iidda Kormaridda ilaa subaxda la gaadhsiin. ");
INSERT INTO som_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Dhulkiinna midhaha ugu horreeya waa inaad inta hore guriga Rabbiga Ilaahiinna ah geeysaan. Waa inaydnaan waxar caanaha hooyadiis ku karin. ");
INSERT INTO som_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Markaasaa Rabbigu wuxuu Muuse ku yidhi, Erayadan qor, waayo, waxaan idinla dhigtay adiga iyo reer binu Israa'iilba axdi erayadan waafaqsan. ");
INSERT INTO som_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Oo halkaasuu Rabbiga la joogay afartan habeen iyo afartan maalmood, waxbana ma uu cunin, biyona ma uu cabbin. Oo looxyadiina wuxuu ku qoray erayadii axdiga, kuwaas oo ah tobanka qaynuun. ");
INSERT INTO som_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Oo markii Muuse Buur Siinay ka soo degay isagoo labadii loox oo maragga gacanta ku sita, intuu buurta ka soo degayay Muuse ma uu ogayn inuu dubka wejigiisu la dhalaalayay hadalkii uu kula hadlay aawadiis. ");
INSERT INTO som_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Oo markay Haaruun iyo reer binu Israa'iil oo dhammu Muuse arkeen, bal eeg, dubka wejigiisu waa dhalaalayay, wayna ka cabsadeen inay u dhowaadaan. ");
INSERT INTO som_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Markaasaa Muuse iyagii u yeedhay; Haaruun iyo taliyayaashii shirka oo dhammuna way ku soo noqdeen; Muusena wuu la hadlay. ");
INSERT INTO som_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Dabadeedna reer binu Israa'iil oo dhammu waa u soo dhowaadeen. Markaasuu wuxuu iyagii ku amray kulli wixii Rabbigu isaga ugu sheegay Buur Siinay. ");
INSERT INTO som_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Oo markuu Muuse dhammeeyey hadalkii uu kula hadlayay ayuu indho shareertay. ");
INSERT INTO som_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Laakiinse markii Muuse Rabbiga u galay oo uu is-hor taagay inuu la hadlo ayuu indhashareertii iska fayday ilaa uu soo baxay; kolkaasuu soo baxay, oo wuxuu reer binu Israa'iil u sheegay wixii lagu amray, ");
INSERT INTO som_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","oo reer binu Israa'iilna way arkeen Muuse wejigiisii iyo inuu dubka wejigiisu dhalaalayay, markaasaa Muuse haddana indho shareertay ilaa uu gudaha u galay inuu la hadlo. ");
INSERT INTO som_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Markaasaa Muuse isu soo ururiyey shirkii reer binu Israa'iil oo dhan, oo wuxuu ku yidhi, Kuwanu waa erayadii Rabbigu idinku amray inaad yeeshaan. ");
INSERT INTO som_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Lix maalmood waa in la shaqeeyaa, laakiinse maalinta toddobaad waa inay maalin quduus ah idiin ahaataa oo waa sabti nasasho oo Rabbiga loo nasto, oo ku alla kii maalintaas shuqul qabta waa in nafta laga qaadaa. ");
INSERT INTO som_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Oo maalin kasta oo sabti ah waa inaydnaan innaba dab ku shidin rugihiinna oo dhan. ");
INSERT INTO som_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Oo Muuse wuxuu la hadlay shirkii reer binu Israa'iil oo dhan, isagoo leh, Waxanu waa wixii Rabbigu idinku amray, isagoo leh, ");
INSERT INTO som_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Idinku dhexdiinna waa inaad wax Rabbiga isaga ururisaan. Mid kasta oo qalbigiisu raalli ka yahay, ha keeno qurbaanka Rabbiga, kaasoo ah dahab, iyo lacag, iyo naxaas, ");
INSERT INTO som_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","iyo buluug, iyo guduud, iyo casaan, iyo maro wanaagsan, iyo dhogor riyaad, ");
INSERT INTO som_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","iyo wanan hargahood oo la caseeyey, iyo adhidibadeed hargahood, iyo qori qudhac ah, ");
INSERT INTO som_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","iyo saliid laambadda lagu shubo, iyo udgoon lagu daro saliidda lagu subkado, iyo foox udgoon, ");
INSERT INTO som_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","iyo dhagaxyo onika la yidhaahdo, iyo dhagaxyo lagu dhejiyo eefodka iyo laabgashiga. ");
INSERT INTO som_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Oo nin kasta oo xigmad leh oo idinku dhex jiraaba ha yimaado oo ha sameeyo wixii Rabbigu idinku amray oo dhan; ");
INSERT INTO som_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","waxaas oo ah taambuugga iyo teendhadiisa, iyo dedkiisa, iyo qabsatooyinkiisa, iyo looxyadiisa, iyo ulihiisa gudban, iyo tiirarkiisa, iyo saldhigyadiisa, ");
INSERT INTO som_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","iyo sanduuqa, iyo ulihiisa, iyo daboolka, iyo ilxidhka daaha ah, ");
INSERT INTO som_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","iyo miiska, iyo ulihiisa, iyo alaabtiisa oo dhan, iyo kibista tusniinta, ");
INSERT INTO som_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","iyo laambadda iftiinka aawadiis, iyo alaabteeda, iyo laambadaheeda, iyo saliidda iftiinka aawadiis, ");
INSERT INTO som_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","iyo meesha allabariga ee fooxa, iyo ulaheeda, iyo saliidda lagu subkado, iyo fooxa udgoon, iyo daaha iridda laga soo galo taambuugga, ");
INSERT INTO som_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","iyo meesha allabariga lagu gubo, iyo shabaggeeda naxaasta ah, iyo ulaheeda, iyo alaabteeda oo dhan, iyo berkedda weysada, iyo salkeeda, ");
INSERT INTO som_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","iyo barxadda daahyadeeda, iyo tiirarkeeda, iyo saldhigyadooda, iyo daaha iridda barxadda, ");
INSERT INTO som_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","iyo musmaarradii taambuugga, iyo musmaarradii barxadda, iyo xadhkahooda, ");
INSERT INTO som_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","iyo dharka lagaga adeegi lahaa meesha quduuska ah, kuwaas oo ah dharka quduuska ah ee wadaadka Haaruun, iyo dharka wiilashiisa si ay ugaga adeegaan hawsha wadaadnimada. ");
INSERT INTO som_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Markaasaa shirkii reer binu Israa'iil oo dhammu waxay ka tageen Muuse hortiisii. ");
INSERT INTO som_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Oo waxay yimaadeen iyagoo mid walba qalbigiisu kacay, oo mid walba ruuxiisu raalli ka dhigay, oo waxay keeneen waxay Rabbiga u bixiyeen, kuwaasoo ah wixii loo doonay shuqulkii teendhada shirka, iyo hawsheeda oo dhan, iyo dharkii quduuska ahaa. ");
INSERT INTO som_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Oo in alla intii raalliga ahayd way yimaadeen, rag iyo dumarba, oo waxay keeneen dugaagado, iyo hilqado, iyo kaatunno, iyo murriyado, iyo wax kasta oo laysku sharxo oo dahab ah; oo nin kastaaba wuxuu Rabbiga u bixiyey wax dahab ah. ");
INSERT INTO som_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Oo nin walba, oo laga helay buluug, iyo guduud, iyo casaan, iyo maro wanaagsan, iyo dhogor riyaad, iyo wanan hargahood oo la caseeyey, iyo adhidibadeed hargahoodba wuu keenay. ");
INSERT INTO som_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Oo mid kasta oo qurbaan lacag iyo naxaas ah bixiyey wuxuu u bixiyey Rabbiga; oo nin kasta oo laga helay qori qudhac ah wuxuu u keenay hawsha adeegidda aawadeed. ");
INSERT INTO som_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Oo dumarkii xigmadda lahaa oo dhammu waxay gacmahooda ku miiqeen dun, oo waxay keeneen wixii ay miiqeen oo ahaa buluug, iyo guduud, iyo casaan, iyo maro wanaagsan. ");
INSERT INTO som_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Oo dumarkii qalbigoodu xigmadda la kacay oo dhammu waxay miiqeen dhogor riyaad. ");
INSERT INTO som_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Oo taliyayaashiina waxay keeneen dhagaxyada onika la yidhaahdo, iyo dhagaxyada lagu dhejiyo eefodka iyo laabgashiga. ");
INSERT INTO som_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Waxayna keeneen uunsiga, iyo saliidda iftiinka, iyo saliidda lagu subkado, iyo fooxa udgoon. ");
INSERT INTO som_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Oo reer binu Israa'iil waxay Rabbiga u bixiyeen qurbaan ay raalli ka yihiin; oo waxay ahaayeen dad rag iyo dumarba leh oo qalbigoodu raalli ka ahaa inay u keenaan shuqulka Rabbigu Muuse ku amray in la sameeyo oo dhan. ");
INSERT INTO som_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Markaasaa Muuse wuxuu reer binu Israa'iil ku yidhi, Bal eega, Rabbigu wuxuu magac ugu yeedhay Besaleel oo ah ina Uurii, oo ah ina Xuur, oo qabiilkiisu yahay Yahuudah; ");
INSERT INTO som_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","oo wuxuu isaga ka buuxiyey ruuxii Ilaah, xagga xigmadda iyo waxgarashada, iyo aqoonta, iyo sancada caynka kasta ah, ");
INSERT INTO som_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","iyo inuu shuqullo yaab leh hindiso, oo uu ka shaqeeyo dahabka, iyo lacagta, iyo naxaasta, ");
INSERT INTO som_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","iyo inuu qoro dhagaxyo saldhigyo lagu dhejinayo, oo uu looxyada xardho, iyo inuu ka shaqeeyo sanco cayn kasta ah. ");
INSERT INTO som_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Oo wuxuu qalbigiisii geliyey inuu wax baro, isaga iyo Aaholii'aab oo ah ina Axiisaamaag, oo qabiilkiisu yahay Daan. ");
INSERT INTO som_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Oo iyaga wuxuu qalbigooda ka buuxiyey xigmad, inay ka shaqeeyaan shuqul cayn kasta ah oo ay qabtaan kuwa wax xardha iyo kuwa wax hindisa, iyo kuwa daabac ku tola buluug, iyo guduud, iyo casaan, iyo maro wanaagsan, iyo kuwa dharka sameeya, xataa ha ahaatee kuwa shuqul kasta qabta iyo kuwa shuqullo yaab leh hindisa. ");
INSERT INTO som_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Oo Besaleel iyo Aaholii'aab iyo nin kasta oo xigmad leh, oo Rabbigu geliyey xigmad iyo waxgarasho ay ku gartaan si loo sameeyo shuqul kasta oo ah adeegidda laga qabanayo meesha quduuska ah, waa inay u qabtaan sidii Rabbigu ku amray oo dhan. ");
INSERT INTO som_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Markaasaa Muuse wuxuu u yeedhay Besaleel iyo Aaholii'aab, iyo nin kasta oo xigmad leh, oo Rabbigu qalbigiisa xigmad geliyey, xataa mid kasta oo qalbigiisu kiciyey inuu yimaado oo shuqulka qabto. ");
INSERT INTO som_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Markaasay Muuse ka guddoomeen wixii la bixiyey oo dhan, oo ay reer binu Israa'iil u keeneen shuqulka adeegidda meesha quduuska ah, inay ka sameeyaan. Oo haddana waxay weliba subax walba u keeni jireen waxay raalli ka yihiin. ");
INSERT INTO som_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Oo raggii xigmadda lahaa oo dhan, oo ahaa kuwii shuqulka ka qabtay meesha quduuska ah, way wada yimaadeen, oo waxaa nin waluba ka soo kacay shuqulkii uu samaynayay. ");
INSERT INTO som_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Oo intay Muuse la hadleen ayay ku yidhaahdeen, Dadku waxay keeneen in ka sii badan intii ku filnayd in lagu qabto shuqulkii Rabbigu amray in la sameeyo. ");
INSERT INTO som_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Markaasaa Muuse amar bixiyey, oo waxaa xeradii oo dhan laga naadiyey inaan nin iyo naag toona wax dambe u bixin shuqulka meesha quduuska ah. Sidaas daraaddeed baa dadkii looga joojiyey si aanay wax kale u keenin. ");
INSERT INTO som_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Waayo, alaabtii ay haysteen waa ku filnayd in shuqulka oo dhan lagu sameeyo, wayna ka sii badnayd weliba. ");
INSERT INTO som_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Oo nin kasta oo xigmad leh oo iyaga ku dhex jiray oo shuqulkii qabtay wuxuu taambuuggii ka sameeyey toban daah, oo wuxuu ka sameeyey maro wanaagsan, iyo buluug, iyo guduud, iyo casaan, oo keruubiim lagu daabacay. ");
INSERT INTO som_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Oo daah kasta dhererkiisu wuxuu ahaa siddeed iyo labaatan dhudhun, oo daah kasta ballaadhkiisuna wuxuu ahaa afar dhudhun; oo daahyada oo dhammuna isku wada qiyaas bay ahaayeen. ");
INSERT INTO som_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Oo shan daah ayuu mid kasta midka kale ku xidhay, oo shantii daah oo kalena ayuu mid kasta midka kale ku xidhay. ");
INSERT INTO som_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Oo daahyada midkii darafta ugu xigay qarkiisa ayuu wuxuu u yeelay siddooyin buluug ah; oo sidaasoo kalena wuxuu u yeelay daahii dibadda ugu xigay intii labaad. ");
INSERT INTO som_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Konton siddo ayuu daahba u yeelay, oo konton siddo oo kalena wuxuu u yeelay qarkii daaha dibadda u xiga ee intii labaad; oo siddooyinkuna midba mid buu ku toosnaa. ");
INSERT INTO som_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Oo wuxuu sameeyey konton qabsato oo dahab ah, oo daahyadiina wuxuu midba midka kale kula lammaaneeyey qabsatooyinkii; sidaasuu taambuuggu mid u noqday. ");
INSERT INTO som_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Markaasuu daahyo ka sameeyey dhogor riyaad, inay ahaadaan teendho ka sarrayso taambuugga, oo wuxuu iyaga ka dhigay kow iyo toban daah. ");
INSERT INTO som_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Oo daah kasta dhererkiisu wuxuu ahaa soddon dhudhun, oo daah kasta ballaadhkiisuna wuxuu ahaa afar dhudhun; oo kow iyo tobanka daah isku wada qiyaas bay ahaayeen. ");
INSERT INTO som_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Markaasuu shan daah gooni-ahaantooda isugu xidhay, lix daahna gooni-ahaan. ");
INSERT INTO som_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Markaasuu qarkii daahii dibadda u xigay intii kowaad u yeelay konton siddo, oo konton siddo oo kalena wuxuu u yeelay qarkii daahii dibadda u xigay intii labaad. ");
INSERT INTO som_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Oo haddana wuxuu sameeyey konton qabsato oo naxaas ah inuu teendhada iskula dhejiyo oo ay mid noqoto. ");
INSERT INTO som_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Oo teendhadana wuxuu ded uga sameeyey wanan hargahood oo la caseeyey, iyo ded ah adhidibadeed hargahood oo ka sarreeya. ");
INSERT INTO som_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Oo taambuugga looxyadiisii taagtaagnaana wuxuu ka sameeyey qori qudhac ah. ");
INSERT INTO som_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Oo loox kasta dhererkiisu wuxuu ahaa toban dhudhun, ballaadhkiisuna wuxuu ahaa dhudhun iyo badh. ");
INSERT INTO som_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Oo loox kastaaba wuxuu lahaa laba caaro, oo looxyaduna dhinacyaday isku hayeen, oo looxyadii taambuugga oo dhan sidaasuu u sameeyey. ");
INSERT INTO som_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Oo looxyada ayuu Taambuugga u sameeyey, oo waxay ahaayeen labaatan loox dhinaca koonfureed. ");
INSERT INTO som_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Oo wuxuu sameeyey afartan saldhig oo lacag ah oo ka hooseeya labaatan loox, oo laba saldhigba waxay ka hooseeyeen loox, oo waxay saldhig u ahaayeen labadiisii caaro, oo laba kale oo saldhigna waxay saldhig u ahaayeen loox kale labadiisii caaro. ");
INSERT INTO som_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Oo taambuugga dhankiisa labaadna oo woqooyi xiga, wuxuu u sameeyey labaatan loox, ");
INSERT INTO som_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","iyo afartankoodii saldhig oo lacagta ahayd. Laba saldhigba loox bay ka hooseeyeen, oo laba saldhig oo kalena waxay ka hooseeyeen loox kale. ");
INSERT INTO som_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Oo taambuugga xaggiisa dambe oo galbeed xigtana wuxuu u sameeyey lix loox. ");
INSERT INTO som_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Oo labada geesood oo taambuugga xaggiisa dambena wuxuu u sameeyey laba loox. ");
INSERT INTO som_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Oo hoosta bay labanlaab ka noqdeen, oo sidaas oo kalena way dhammaadeen ilaa siddada kowaad dusheeda, oo sidaasuu ka dhigay labadoodii ku jiray labada geesood. ");
INSERT INTO som_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Waxaana jiray siddeed loox, iyo saldhigyadoodii lacagta ahaa. Kuwaasu waxay ahaayeen lix iyo toban saldhig, oo lababa loox ka hoosayso. ");
INSERT INTO som_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Oo wuxuu ulo gudban ka sameeyey qori qudhac ah, oo shan buu u sameeyey looxyada taambuugga dhinac kaga jira, ");
INSERT INTO som_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","oo shan ulood oo kalena wuxuu u sameeyey looxyada dhinaca kale kaga jira taambuugga, oo shan ulood oo kalena wuxuu u sameeyey looxyada taambuugga kaga jira xaggiisa dambe oo galbeed xigta. ");
INSERT INTO som_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Oo uldhexaaddii ayuu looxyadii ku gudbay gees ilaa gees. ");
INSERT INTO som_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Oo looxyadii wuxuu ku dahaadhay dahab, oo siddooyinkoodana wuxuu ka sameeyey dahab inay ahaadaan meelihii ay ulaha gudban ka geli lahaayeen, oo ulihiina wuxuu ku dahaadhay dahab. ");
INSERT INTO som_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Oo ilxidhkiina wuxuu ka sameeyey buluug, iyo guduud, iyo casaan, iyo maro wanaagsan, oo keruubiim buu ku daabacay. ");
INSERT INTO som_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Oo wuxuu u sameeyey afar tiir oo qori qudhac ah, wuxuuna ku dahaadhay dahab; oo qabsatooyinkooduna waxay ahaayeen dahab; oo wuxuuna u yeelay afar saldhig oo lacag ah. ");
INSERT INTO som_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Oo iridda Teendhada wuxuu u sameeyey daah ah buluug, iyo guduud, iyo casaan, iyo maro wanaagsan oo daabac leh. ");
INSERT INTO som_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Wuxuuna sameeyey shantiisii tiir iyo qabsatooyinkoodiiba, oo dahab buu ku dahaadhay tiirarka madaxyadoodii iyo waxyaalihii laysugu wada xidhayba; oo shantoodii saldhigna waxay ahaayeen naxaas. ");
INSERT INTO som_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Oo Besaleel wuxuu sanduuqii ka sameeyey qori qudhac ah, oo dhererkiisuna wuxuu ahaa laba dhudhun iyo badh, ballaadhkiisuna wuxuu ahaa dhudhun iyo badh, sarajooggiisuna wuxuu ahaa dhudhun iyo badh. ");
INSERT INTO som_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Markaasuu gudaha iyo dibaddaba kaga dahaadhay dahab saafi ah, oo wuxuu u yeelay wax taaj oo kale ah oo dahab ah oo ku wareegsan. ");
INSERT INTO som_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Kolkaasuu wuxuu u yeelay afar siddo oo dahab ah oo afartiisa rukun ee hoose ku yaal; oo laba siddoba dhinac buu kaga dhejiyey, dhinaca kalena laba siddo buu kaga dhejiyey. ");
INSERT INTO som_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Wuxuuna ulo ka sameeyey qori qudhac ah, dahab buuna ku dahaadhay. ");
INSERT INTO som_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Markaasuu ulihii wuxuu geliyey siddooyinkii sanduuqa dhinacyadiisa ku yiil, si sanduuqa loogu qaado. ");
INSERT INTO som_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Markaasuu wuxuu dahab saafi ah ka sameeyey dabool, oo dhererkiisuna wuxuu ahaa laba dhudhun iyo badh, ballaadhkiisuna wuxuu ahaa dhudhun iyo badh. ");
INSERT INTO som_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Markaasuu laba keruub ka sameeyey dahab la tumay, oo daboolkii labadiisa madax ayuu ka taagay. ");
INSERT INTO som_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Keruub wuxuu ka sameeyey madax, keruubkii kalena wuxuu ka sameeyey madaxa kale; oo labada keruub oo labada madax ka kala taagan iyo daboolkii wuxuu ka wada sameeyey isku waslad. ");
INSERT INTO som_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Oo keruubiimtuna meel sare ayay baalashooda ka soo kala bixiyeen, oo daboolkay baalashooda ku qariyeen, wejiyadooduna way iska soo hor jeedeen; oo keruubiimta wejiyadoodu waxay ku soo jeedeen daboolka. ");
INSERT INTO som_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Miiskana qori qudhac ah ayuu ka sameeyey, oo dhererkiisu wuxuu ahaa laba dhudhun, ballaadhkiisuna dhudhun, sarajooggiisuna dhudhun iyo badh, ");
INSERT INTO som_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","oo wuxuu ku dahaadhay dahab saafi ah, oo wuxuuna u yeelay wax taaj oo kale ah oo dahab ah oo ku wareegsan. ");
INSERT INTO som_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Oo wuxuu u yeelay qar le'eg calaacal ballaadhkeed oo ku wareegsan, oo qarkiina wuxuu u yeelay wax taaj oo kale ah oo dahab ah oo ku wada wareegsan. ");
INSERT INTO som_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Oo wuxuu u yeelay afar siddo oo dahab ah, oo wuxuu siddooyinkii ku dhejiyey afarta gees oo afarta rukun oo hoose kaga yiil. ");
INSERT INTO som_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Oo siddooyinku waxay ku dhowaayeen qarka, iyagoo ah meelaha laga geliyo ulaha miiska lagu qaado. ");
INSERT INTO som_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Oo wuxuu ulihii ka sameeyey qori qudhac ah oo ku dahaadhay dahab, si miiska loogu qaado. ");
INSERT INTO som_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Oo wuxuu dahab saafi ah ka sameeyey alaabtii miiska saarnayd oo dhan oo ahayd suxuuntiisii, iyo malqacadihiisii, iyo maddiibadihiisii, iyo kidhliyadiisii wax laga shubo. ");
INSERT INTO som_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Oo wuxuu laambadda ka sameeyey dahab saafi ah, oo laambaddii waxay ahayd mid tuman, xataa salkeeda iyo usheeda dhexe iyo koobabkeeda, iyo burooyinkeeda iyo ubaxeeduba isku waslad bay la wada ahaayeen. ");
INSERT INTO som_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Oo dhinacyadeeda waxaa ka baxayay lix laamood, oo saddex laamood dhinac bay kaga yiilleen, saddex laamoodna dhinaca kale ayay kaga yiilleen. ");
INSERT INTO som_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Oo saddex koob oo yicib ubaxeed u eg, iyo buro, iyo ubax baa isku laan ku yiil, laanta kalena waxaa ku yiil saddex koob oo yicib ubaxeed u eg, iyo buro, iyo ubax, oo lixdii laamood oo ka baxday laambaddii sidaasay wada ahaayeen. ");
INSERT INTO som_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Oo laambaddii waxaa ku yiil afar koob oo yicib ubaxeed u eg, iyo burooyinkoodii iyo ubaxoodii, ");
INSERT INTO som_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","oo buro waxay ku tiil laba laamood hoostood, isku waslad bayna la ahayd, buro kalena waxay ku tiil laba laamood hoostood, isku waslad bayna la ahayd, burona waxay ku tiil laba laamood hoostood, isku waslad bayna la ahayd, oo lixda laamoodba sidaasay wada ahaayeen. ");
INSERT INTO som_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Oo burooyinkooda iyo laamahooduba isku waslad bay la ahaayeen: oo kulligeedna waxay ahayd isku waslad dahab la tumay oo saafi ah. ");
INSERT INTO som_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Oo dahab saafi ah wuxuu ka sameeyey toddobadeedii laambadood, iyo birqaabyadeedii iyo alaabteedii lagu safayn jirayba. ");
INSERT INTO som_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Oo iyada iyo alaabteeda oo dhanba wuxuu ka sameeyey talanti dahab saafi ah. ");
INSERT INTO som_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Oo meeshii allabariga ee fooxana wuxuu ka sameeyey qori qudhac ah, oo dhererkeeduna wuxuu ahaa dhudhun, ballaadhkeeduna wuxuu ahaa dhudhun, oo afar geesood bay ahayd, sarajooggeeduna wuxuu ahaa laba dhudhun, oo geesaheeduna isku waslad bay la ahaayeen. ");
INSERT INTO som_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Oo wuxuu dahab ku dahaadhay dusheedii iyo dhinacyadeedii ku wareegsanaa, iyo geesaheedii, oo wuxuu u sameeyey wax taaj oo kale ah oo dahab ah oo ku wareegsan. ");
INSERT INTO som_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Oo qarka hoostiisa laba siddo oo dahab ah ayuu ugu yeelay labadeeda rukun inay labadeeda dhinac ugu ahaadaan meelaha ulaha lagu qaado laga gelin lahaa. ");
INSERT INTO som_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Oo ulihii wuxuu ka sameeyey qori qudhac ah, dahab buuna ku dahaadhay. ");
INSERT INTO som_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Oo saliiddii quduuska ahayd oo lagu subkado iyo fooxii saafiga ahaa ee uunsiga udgoon wuxuu u sameeyey sidii shuqulka cadarsameeyaha oo kale. ");
INSERT INTO som_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Oo meeshii allabariga lagu gubi lahaana wuxuu ka sameeyey qori qudhac ah, oo dhererkeedu wuxuu ahaa shan dhudhun, ballaadhkeeduna wuxuu ahaa shan dhudhun, afargeesood bay ahayd, sarajooggeeduna wuxuu ahaa saddex dhudhun. ");
INSERT INTO som_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Oo geesaheediina wuxuu ugu sameeyey afarteeda rukun; oo geesaheeduna isku waslad bay la ahaayeen, naxaas buuna ku dahaadhay. ");
INSERT INTO som_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Oo wuxuu kaloo sameeyey alaabtii meesha allabariga oo dhan, kuwaasoo ah dheryihii, iyo majarafadihii, iyo maddiibadihii, iyo mudacyadii, iyo dabqaadayaashii; oo alaabteeda oo dhan wuxuu ka sameeyey naxaas. ");
INSERT INTO som_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Oo wuxuu meeshii allabariga u sameeyey shabag naxaas ah oo gaadha qarka hoostiisa ilaa kalabadhka. ");
INSERT INTO som_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Afarta daraf oo shabaggii naxaasta ahaa ayuu u yeelay afar siddo si ay u ahaadaan meelihii ulaha laga gelin lahaa. ");
INSERT INTO som_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Oo ulihiina wuxuu ka sameeyey qori qudhac ah, naxaas buuna ku dahaadhay. ");
INSERT INTO som_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Oo ulihiina wuxuu ka geliyey siddooyinkii meesha allabariga si loogu qaado; oo wuxuu meeshii allabariga ka sameeyey looxyo sida sanduuq madhan oo kale. ");
INSERT INTO som_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Oo berkeddii weysada iyo salkeedii wuxuu ka sameeyey naxaas, taasoo laga helay muraayadihii dumarka ka adeegi jiray teendhada shirka iriddeeda. ");
INSERT INTO som_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Oo wuxuu sameeyey barxaddii; oo barxadda xaggeeda koonfureed waxaa ka lushay daahyo dhererkoodu yahay boqol dhudhun oo ah maro wanaagsan. ");
INSERT INTO som_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Oo tiirarkoodu waxay ahaayeen labaatan, saldhigyadooduna labaatan, naxaas laga sameeyey; tiirarka qabsatooyinkooda iyo waxyaalihii laysugu xidhi jirayna waxaa laga sameeyey lacag. ");
INSERT INTO som_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Oo xaggeeda woqooyina waxaa ka lushay daahyo boqol dhudhun ah, oo tiirarkoodu waxay ahaayeen labaatan, saldhigyadooduna labaatan, naxaas laga sameeyey; tiirarka qabsatooyinkooda iyo waxyaalihii laysugu xidhi jirayna waxaa laga sameeyey lacag. ");
INSERT INTO som_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Oo dhinaca galbeed daahyadiisu waxay ahaayeen konton dhudhun, tiirarkoodu waxay ahaayeen toban, saldhigyadooduna toban, oo tiirarka qabsatooyinkooda iyo waxyaalihii laysugu xidhi jirayna waxay ahaayeen lacag. ");
INSERT INTO som_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Oo xagga bari daahyadiisuna waxay ahaayeen konton dhudhun. ");
INSERT INTO som_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Oo iridda daahyadeedu dhinac waxay ka ahaayeen shan iyo toban dhudhun, tiirarkooduna saddex bay ahaayeen, saldhigyadooduna saddex, ");
INSERT INTO som_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","oo dhinaca kalena sidaas oo kalay ahaayeen, oo barxadda iriddeeda xaggan iyo xaggaasba waxaa ka lushay daahyo dhererkoodu yahay shan iyo toban dhudhun, tiirarkooduna waxay ahaayeen saddex, saldhigyadooduna saddex. ");
INSERT INTO som_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Daahyadii barxadda ku wareegsanaa oo dhammu waxay ahaayeen maro wanaagsan. ");
INSERT INTO som_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Oo tiirarka saldhigyadoodu waxay ahaayeen naxaas; qabsatooyinkooda iyo waxyaalihii laysugu xidhi jirayna waxay ahaayeen lacag; tiirarka madaxyadooda waxaa lagu dahaadhay lacag, oo tiirarka barxadda oo dhanna waxaa laysugu wada xidhay lacag. ");
INSERT INTO som_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Oo daaha barxadda iriddeeda wuxuu ahaa wax daabacan oo ah buluug, iyo guduud, iyo casaan, iyo maro wanaagsan, oo dhererkiisuna wuxuu ahaa labaatan dhudhun, sarajooggiisuna wuxuu ahaa shan dhudhun oo u dhigma barxadda daahyadeeda. ");
INSERT INTO som_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Tiirarkooduna waxay ahaayeen afar, saldhigyadoodii naxaasta ahaana afar; qabsatooyinkooduna waxay ahaayeen lacag, oo tiirarka madaxyadoodii waxaa ku dahaadhnaa lacag, waxyaalihii laysugu xidhayna waxay wada ahaayeen lacag. ");
INSERT INTO som_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Oo musmaarrada taambuugga iyo barxadda ku wareegsanba kulligood waxay ahaayeen naxaas. ");
INSERT INTO som_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Waa tan tiradii alaabtii taambuugga, kaas oo ah taambuuggii maragga, markii la tiriyey sidii Muuse ku amray adeegidda reer Laawi, oo uu tilmaamay Iitaamaar kii wadaadkii Haaruun ahaa dhalay. ");
INSERT INTO som_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Oo kulli wixii Rabbigu ku amray Muuse waxaa sameeyey Besaleel oo ahaa ina Uurii oo ahaa ina Xuur, oo qabiilkiisu ahaa Yahuudah. ");
INSERT INTO som_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Oo waxaa isaga la jiray Aaholii'aab oo ahaa ina Axiisaamaag, oo qabiilkiisu ahaa Daan, oo wuxuu ahaa mid wax xardha, oo aad iyo aad u farsamo badan, iyo mid yaqaan sida loo daabaco buluug, iyo guduud, iyo casaan, iyo maro wanaagsan. ");
INSERT INTO som_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Oo dahabkii la bixiyey oo loogu isticmaalay hawshii meesha quduuskaa oo dhammu wuxuu ahaa sagaal iyo labaatan talanti, iyo toddoba boqol iyo soddon sheqel, oo le'eg sheqelka meesha quduuska ah. ");
INSERT INTO som_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Oo shirka intiisii la tiriyey lacagtoodii waxay ahayd boqol talanti, iyo kun iyo toddoba boqol iyo shan iyo toddobaatan sheqel, oo le'eg sheqelka meesha quduuska ah. ");
INSERT INTO som_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Waxaa nin kastaa bixiyey beqac, kaas oo ah nus sheqel, oo le'eg sheqelka meesha quduuska ah, oo kulli intii u gudubtay kuwii la tiriyey, intii jirtay labaatan sanadood iyo wixii ka sii weyn, waxay ahaayeen lix boqol iyo saddex kun, iyo shan boqol iyo konton nin. ");
INSERT INTO som_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Oo saldhigyada meesha quduuska ah iyo saldhigyada ilxidhku waxay ka samaysmeen boqolkii talanti oo lacagta ahaa, boqol saldhig baa laga sameeyey boqolkii talanti, saldhigba talanti baa laga sameeyey. ");
INSERT INTO som_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Kun iyo toddoba boqol iyo shan iyo toddobaatanka sheqel ayuu tiirarka qabsatooyinkoodii ka sameeyey, oo wuxuuna ku dahaadhay tiirarka madaxyadoodii, wuxuuna ka sameeyey waxyaalihii tiirarka laysugu wada xidhay. ");
INSERT INTO som_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Naxaastii la bixiyey waxay ahayd toddobaatan talanti, iyo laba kun iyo afar boqol oo sheqel. ");
INSERT INTO som_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Oo wuxuu naxaastii ka sameeyey iriddii teendhada shirka saldhigyadeedii, iyo meeshii naxaasta ahayd oo allabariga, iyo shabaggeedii naxaasta ahaa, iyo alaabtii meesha allabariga oo dhan, ");
INSERT INTO som_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","iyo saldhigyadii barxadda ku wareegsanaa, iyo saldhigyadii iridda barxadda, iyo musmaarradii taambuugga oo dhan, iyo musmaarradii barxadda ku wareegsanaa oo dhan. ");
INSERT INTO som_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Oo waxay buluuggii, iyo guduudkii, iyo casaankii ka sameeyeen dhar aad u wanaagsan in meesha quduuskaa lagaga adeego, oo waxay kaloo sameeyeen dharkii quduuska ahaa oo Haaruun, sidii Rabbigu Muuse ku amray. ");
INSERT INTO som_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Oo eefodkiina wuxuu ka sameeyey dahab, iyo buluug, iyo guduud, iyo casaan, iyo maro wanaagsan. ");
INSERT INTO som_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Oo waxay dahabkii u tumeen sidii caleemo khafiif ah oo kale, markaasay googooyeen oo silig ka dhigeen, in looga shaqeeyo buluuggii, iyo guduudkii, iyo casaankii, iyo maradii wanaagsanayd, oo la daabacay. ");
INSERT INTO som_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Oo waxay u sameeyeen garbo is-haystay, oo waxay iska haysteen labada daraf. ");
INSERT INTO som_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Oo dhex-xidhkii daabaca lahaa oo dusha kaga yiil in lagu xidho, isku waslad buu la ahaa eefodka, isku sina waa loo sameeyey, waxaana laga sameeyey dahab, iyo buluug, iyo guduud, iyo casaan, iyo maro wanaagsan, sidii Rabbigu Muuse ku amray. ");
INSERT INTO som_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Oo waxay diyaariyeen dhagaxyadii onika la odhan jiray, oo ku jira saldhigyo dahab ah, oo lagu xardhay xaradhkii shaabadda oo ah sida ay magacyadii reer binu Israa'iil ahaayeen. ");
INSERT INTO som_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Oo wuxuu ku dhejiyey eefodka garbihiisa, inay dhagaxyo xusuus ah u noqdaan reer binu Israa'iil, sidii Rabbigu Muuse ku amray. ");
INSERT INTO som_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Oo wuxuu sameeyey laabgashigii, oo la daabacay, oo u eg sida samaynta eefodka oo kale, oo ahayd dahab, iyo buluug, iyo guduud, iyo casaan, iyo maro wanaagsan. ");
INSERT INTO som_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Wuxuu ahaa afargeesood, oo laabgashiga waxay u sameeyeen labanlaab, oo dhererkiisu wuxuu ahaa taako, ballaadhkiisuna wuxuu ahaa taako isagoo labanlaaban. ");
INSERT INTO som_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Oo waxay ku dul dhejiyeen afar saf oo dhagaxyo ah; oo safka kowaad wuxuu ahaa sardiyos, iyo tobasiyos, iyo mid birqaya. ");
INSERT INTO som_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Safka labaadna wuxuu ahaa sumurud, iyo safayr, iyo dheemman. ");
INSERT INTO som_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Safka saddexaadna wuxuu ahaa yakintos, iyo agate, iyo ametustos. ");
INSERT INTO som_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Safka afraadna wuxuu ahaa berullos, iyo onika, iyo yasbid; oo waxaa lagu dhejiyey saldhigyo dahab ah oo meeshooda ku yaal. ");
INSERT INTO som_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Oo dhagaxyaduna waxay tiro le'ekaayeen magacyadii reer binu Israa'iil, oo waxay ahaayeen laba iyo toban sidii magacyadoodii; oo laba iyo tobankii qabiil, mid kasta waxaa magiciisa loogu xardhay sidii xaradhkii shaabadda. ");
INSERT INTO som_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Oo laabgashiga waxay ku sameeyeen silsilado xadhko u eg, oo laga tidcay dahab saafi ah. ");
INSERT INTO som_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Oo waxay sameeyeen laba saldhig oo dahab ah, iyo laba siddo oo dahab ah, oo waxay labadii siddo sudheen laabgashiga labadiisa daraf. ");
INSERT INTO som_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Oo labadii silsiladood oo dahabka ahayd oo tidcanaydna waxay ku xidheen labadii siddo oo ku yiil darfaha laabgashiga. ");
INSERT INTO som_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Oo labadii silsiladood oo tidcanayd labadoodii madax oo kalena waxay ku xidheen labadii saldhig, oo waxay ku xidheen eefodka garbihiisa xaggooda hore. ");
INSERT INTO som_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Oo waxay sameeyeen laba siddo oo dahab ah, oo waxay soo sudheen laabgashiga labadiisa daraf oo gudaha ah oo eefodka xiga. ");
INSERT INTO som_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Oo waxay kaloo sameeyeen laba siddo oo dahab ah, oo waxay soo sudheen eefodka garbihiisa xaggooda hoose, oo dhanka hore ku yaal, oo ku dhow meeshay iskaga xidhmaan, oo ka sarreeya suunka eefodka dhex-xidhkiisa daabaca ah. ");
INSERT INTO som_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Oo laabgashigii waxay siddooyinkiisii ku xidheen siddooyinkii eefodka, waxayna kula xidheen shalash buluug ah, inuu ku dul xidhnaado dhex-xidhka daabaca ah oo eefodka, iyo inuusan laabgashigu ka debcin eefodka, sidii Rabbigu Muuse ku amray. ");
INSERT INTO som_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Oo khamiiskii eefodkana wuxuu ahaa dhar samaysan, oo kulligiis buluug ah. ");
INSERT INTO som_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Oo daloolkii khamiiska ku yiil wuxuu ahaa sida daloolka dhar afkiisa rigrig ku wareegsan yahay, si uusan u dillaacin. ");
INSERT INTO som_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Oo khamiiska darafkiisa hoose waxay ku sameeyeen rummaanno buluug, iyo guduud, iyo casaan ah, iyo maro wanaagsan. ");
INSERT INTO som_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Oo waxay sameeyeen dawanno dahab saafi ah, oo dawannadii waxay kala dhex geliyeen rummaannadii ku yiil khamiiska darafkiisa ku wareegsan, oo u dhexeeya rummaannadii; ");
INSERT INTO som_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","oo dawan iyo rummaan, haddana dawan iyo rummaan, ayuu ku wareejiyey khamiiska dharafkiisa, in lagu adeego aawadeed, sidii Rabbigu Muuse ku amray. ");
INSERT INTO som_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Waxay Haaruun iyo wiilashiisii u sameeyeen jubbadihii marada wanaagsan ahaa oo si fiican loo sameeyey, ");
INSERT INTO som_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","oo waxay kaloo sameeyeen duubkii Haaruun oo marada wanaagsan ahaa, iyo wiilashiisii duubabkoodii wacanaa oo marada wanaagsan ahaa, iyo sirwaalladii marada wanaagsan ahaa, ");
INSERT INTO som_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","iyo dhex-xidhkii ahaa marada wanaagsan, iyo buluug, iyo guduud, iyo casaan, oo daabacnaa, sidii Rabbigu Muuse ku amray. ");
INSERT INTO som_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Oo waxay kaloo sameeyeen taajkii quduuska ahaa ee ahaa wasladdii khafiifka oo dahabka saafiga ahayd, oo waxay dushiisii ku qoreen far u eg xaradhkii shaabadda oo leh, WAA U QUDUUS RABBIGA. ");
INSERT INTO som_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Oo waxay ku xidheen shalash buluug ah, in lagula dhejiyo duubka sare, sidii Rabbigu Muuse ku amray. ");
INSERT INTO som_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Oo sidaasay hawshii taambuugga teendhadii shirka oo dhammu ku dhammaatay; oo reer binu Israa'iil way wada sameeyeen wixii Rabbigu Muuse ku amray oo dhan, sidii bayna u sameeyeen. ");
INSERT INTO som_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Oo waxay Muuse u keeneen taambuuggii, oo ahaa teendhadii iyo alaabteedii oo dhan, qabsatooyinkeedii iyo looxyadeedii iyo ulaheedii gudbanaa, iyo tiirarkeedii, iyo saldhigyadeedii, ");
INSERT INTO som_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","iyo dedkii ahaa wananka hargahooda oo la caseeyey, iyo dedkii ahaa hargaha adhidibadeedka, iyo ilxidhkii daaha ahaa, ");
INSERT INTO som_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","iyo sanduuqii maragga, iyo ulihiisii, iyo daboolkii, ");
INSERT INTO som_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","iyo miiskii, iyo alaabtiisii oo dhan, iyo kibistii tusniinta, ");
INSERT INTO som_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","iyo laambaddii saafiga ahayd, iyo laambadaheedii, kuwaasoo ah laambadihii la diyaarin lahaa, iyo alaabtoodii oo dhan, iyo saliiddii lagu shidi lahaa, ");
INSERT INTO som_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","iyo meeshii allabariga oo dahabka ahayd, iyo saliiddii lagu subkan lahaa, iyo fooxii udgoonaa, iyo daahii iridda teendhada, ");
INSERT INTO som_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","iyo meeshii allabariga oo naxaasta ahayd, iyo shabaggeedii naxaasta ahaa, iyo ulaheedii, iyo alaabteedii oo dhan, iyo berkeddii weysada, iyo salkeedii, ");
INSERT INTO som_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","iyo barxadda daahyadeedii, iyo tiirarkeedii, iyo saldhigyadeedii, iyo daahii iridda barxadda, iyo xadhkihiisii, iyo musmaarradiisii, iyo alaabtii lagu qaban lahaa hawsha taambuugga oo dhan, teendhada shirka aawadeed, ");
INSERT INTO som_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","iyo dharkii loo sameeyey in lagaga adeego meesha quduuska ah, iyo dharkii quduuska ahaa oo wadaadka Haaruun ah, iyo dharkii wiilashiisa, ee loogu sameeyey inay kaga adeegaan hawsha wadaadnimada. ");
INSERT INTO som_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Oo kulli wixii Rabbigu Muuse ku amray oo dhan reer binu Israa'iil sidii bay hawshii u wada qabteen. ");
INSERT INTO som_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Markaasaa Muuse wuxuu arkay shuqulkii oo dhan, oo bal eeg way wada sameeyeen; sidii Rabbigu ku amray ayay u sameeyeen; markaasaa Muuse iyagii u duceeyey. ");
INSERT INTO som_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Markaasaa Rabbigu Muuse la hadlay, oo ku yidhi, ");
INSERT INTO som_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","Bisha kowaad maalinteeda kowaad waa inaad taambuugga teendhada shirka qotomisaa. ");
INSERT INTO som_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Oo waa inaad sanduuqa maragga gudaheeda gelisaa, oo sanduuqa waa inaad ilxidhka ku qarisaa. ");
INSERT INTO som_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Oo miiskana waa inaad gudaha soo gelisaa, oo aad alaabta saaran hagaajisaa, oo laambaddana waa inaad gudaha soo gelisaa, oo laambadaheeda waa inaad shiddaa. ");
INSERT INTO som_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Oo meesha allabariga oo dahabka ah oo fooxa waxaad dhigtaa sanduuqa maragga hortiisa, oo iridda taambuuggana daaheeda sudh. ");
INSERT INTO som_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Oo meesha allabariga lagu gubona waxaad hor dhigtaa iridda taambuugga teendhada shirka. ");
INSERT INTO som_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Oo berkedda weysadana waxaad dhigtaa teendhada shirka iyo meesha allabariga dhexdooda, waana inaad biyo ku shubtaa. ");
INSERT INTO som_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Oo waa inaad dayrka barxadda ku wareegsan qotomisaa, oo barxadda iriddeedana waxaad soo sudhaa daaha. ");
INSERT INTO som_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Oo markaas waxaad qaadataa saliidda lagu subkado, oo waxaad ku subagtaa taambuugga, iyo waxa gudihiisa ku jira oo dhan, oo waa inaad quduus ka dhigtaa isaga iyo alaabtiisa oo dhanba; oo kolkaasuu quduus noqon doonaa. ");
INSERT INTO som_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Oo waxaad kaloo subagtaa meesha allabariga lagu gubo, iyo alaabteeda oo dhan, oo meesha allabariga quduus ka dhig, oo markaasay meesha allabarigu waxay noqon doontaa tan ugu wada quduusan. ");
INSERT INTO som_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Oo waxaad kaloo subagtaa berkedda weysada iyo salkeeda, oo waa inaad quduus ka dhigtaa. ");
INSERT INTO som_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Oo Haaruun iyo wiilashiisa waxaad keentaa iridda teendhada shirka, oo waa inaad biyo ugu maydhaa iyaga. ");
INSERT INTO som_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Oo Haaruun waa inaad u gelisaa dharkii quduuska ahaa; oo waa inaad isaga u subagtaa oo quduus ka dhigtaa, inuu iiga adeego hawsha wadaadnimada. ");
INSERT INTO som_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Oo wiilashiisana waa inaad keentaa oo jubbado u gelisaa, ");
INSERT INTO som_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","oo waa inaad iyana u subagtaa sidii aad aabbahood ugu subagtay oo kale, inay iiga adeegaan hawsha wadaadnimada, oo subkiddoodu waxay iyaga u noqon doontaa wadaadnimo iyaga u jiraysa weligood iyo tan iyo ka ab ka ab. ");
INSERT INTO som_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Sidaasuu Muuse yeelay, oo sidii Rabbigu ku amray oo dhan wuu wada sameeyey. ");
INSERT INTO som_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Oo sannaddii labaad, bisheedii kowaad, maalinteedii kowaad ayaa taambuuggii la qotomiyey. ");
INSERT INTO som_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Oo Muuse wuxuu qotomiyey taambuuggii, saldhigyadiisiina wuu dhigay, oo wuxuu taagay looxyadiisii, ulahoodiina wuu ku gudbay, tiirarkiisiina wuu taagay. ");
INSERT INTO som_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Oo taambuuggii buu ku deday teendhada, oo teendhada dedkeediina wuu ka sii dul mariyey, sidii Rabbigu Muuse ku amray. ");
INSERT INTO som_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Markaasuu qaaday maraggii oo ku riday sanduuqii, oo ulihiina sanduuqii sudhay, daboolkiina wuxuu saaray sanduuqa dushiisii; ");
INSERT INTO som_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","markaasuu sanduuqiina taambuuggii soo geliyey, oo haddana sudhay ilxidhkii daaha, oo wuxuu ku qariyey sanduuqii maragga, sidii Rabbigu Muuse ku amray. ");
INSERT INTO som_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Oo miiskiina wuxuu geliyey teendhadii shirka, oo wuxuu dhigay ilxidhka dibaddiisa oo ah taambuugga dhankiisa woqooyi. ");
INSERT INTO som_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Oo intuu Rabbiga hor dhigay ayuu kibistii hagaajiyey, sidii Rabbigu Muuse ku amray. ");
INSERT INTO som_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Oo laambaddiina wuxuu geliyey teendhadii shirka, oo wuxuu dhigay meel miiska ku toosan, oo ah taambuugga dhankiisa koonfureed. ");
INSERT INTO som_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Markaasuu laambadihii Rabbiga hortiisa ku shiday, sidii Rabbigu Muuse ku amray. ");
INSERT INTO som_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Oo meeshii allabariga oo dahabka ahaydna wuu soo geliyey teendhadii shirka, oo wuxuu dhigay ilxidhka hortiisa, ");
INSERT INTO som_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","oo markaasuu ku shiday foox uunsi udgoon ah, sidii Rabbigu Muuse ku amray. ");
INSERT INTO som_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Oo taambuugga iriddiisiina wuxuu sudhay daahii. ");
INSERT INTO som_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Oo meeshii allabariga lagu gubi jirayna wuxuu ag dhigay iridda taambuugga ee teendhada shirka, oo wuxuu dusheeda ku bixiyey qurbaankii la gubayay iyo qurbaankii hadhuudhka ahaa, sidii Rabbigu Muuse ku amray. ");
INSERT INTO som_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Oo berkeddii weysadana wuxuu dhigay teendhadii shirka iyo meeshii allabariga dhexdooda, oo wuxuu ku shubay biyo in lagu maydho. ");
INSERT INTO som_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Oo Muuse iyo Haaruun iyo wiilashiisiiba gacmaha iyo cagaha ayay ku maydheen; ");
INSERT INTO som_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","oo markay teendhada shirka galeen iyo markay meesha allabariga u soo dhowaadeenba way ku maydheen, sidii Rabbigu Muuse ku amray. ");
INSERT INTO som_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Markaasuu qotomiyey dayrkii barxadda taambuuggii iyo meeshii allabariga ku wareegsanaa, oo barxadda iriddeediina wuxuu sudhay daahii. Sidaasuu Muuse shuqulkii u dhammeeyey. ");
INSERT INTO som_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Markaasaa daruurtii teendhadii shirka qarisay, ammaantii Rabbiguna taambuuggay ka buuxsantay. ");
INSERT INTO som_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Oo Muusena inuu teendhadii shirka galo wuu kari waayay, maxaa yeelay, daruurtii baa dul joogtay, oo ammaantii Rabbiguna taambuuggay ka buuxday. ");
INSERT INTO som_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Oo markii daruurtii taambuuggii kor ahayd laga qaaday ayaa reer binu Israa'iil hore u sii wadeen sodcaalladoodii oo dhan, ");
INSERT INTO som_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","laakiinse haddii aan daruurtii kor loo qaadin, ma ay socon jirin ilaa maalinta kor loo qaado. ");
INSERT INTO som_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Waayo, daruurtii Rabbigu maalintii taambuuggay dul joogi jirtay, habeenkiina waxaa daruurtii ku jiri jiray dab, reer binu Israa'iil oo dhammuna waxyaalahaas ayay arki jireen sodcaalladoodii oo dhan.");
INSERT INTO som_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Rabbigu wuxuu Muuse uga yeedhay teendhadii shirka oo intuu la hadlay ayuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Reer binu Israa'iil la hadal oo waxaad ku tidhaahdaa, Markii nin idinka mid ahu uu Rabbiga qurbaan u bixinayo, qurbaankiinna waxaad ka bixisaan xoolaha, kuwaasoo ah lo'da iyo idaha. ");
INSERT INTO som_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Oo haddii qurbaankiisu yahay qurbaan la gubo oo lo' ah, waa inuu bixiyaa neef lab oo aan iin lahayn, oo waa inuu ku bixiyaa teendhada shirka iriddeeda, si isaga Rabbiga hortiisa loogu aqbalo. ");
INSERT INTO som_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Oo waa inuu gacanta saaraa madaxa neefka qurbaanka la gubayo, oo waxaa loo aqbali doonaa inuu isaga u ahaado kafaaraggud. ");
INSERT INTO som_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Oo dibiga waa inuu Rabbiga hortiisa ku gowraco, oo wiilasha Haaruun oo wadaaddada ahu waa inay dhiigga keenaan, oo ay dhiigga ku dul rusheeyaan hareeraha meesha allabariga ee teendhada shirka horteeda taal. ");
INSERT INTO som_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Oo neefka qurbaanka la gubayo waa inuu haragga ka bixiyaa, oo haddana waa inuu xubin xubin u googooyaa. ");
INSERT INTO som_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Oo wiilasha Haaruun oo wadaaddada ahu waa inay meesha allabariga dab ku shubaan oo haddana waa inay qoryo ku dul hagaajiyaan dabka, ");
INSERT INTO som_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","oo markaas wiilasha Haaruun oo wadaaddada ahu xubnaha iyo madaxa iyo baruurta ha ku dul hagaajiyeen qoryaha dabka meesha allabariga saaran, ");
INSERT INTO som_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","laakiinse neefka uurkujirtiisa iyo addimmadiisa biyo ha ku maydho, oo wadaadku meesha allabariga dusheeda dhammaantiis ha ugu gubo qurbaan la gubo oo ah qurbaan dab lagu sameeyo oo Rabbiga caraf udgoon u ah. ");
INSERT INTO som_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Oo haddii qurbaankiisu yahay neef adhi ah, ha ahaado wan ama orgi oo qurbaan la gubo loo keenay, ha bixiyo neef lab oo aan iin lahayn. ");
INSERT INTO som_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Oo neefka waa inuu Rabbiga ku hor gowraco meesha allabariga dhinaceeda woqooyi, oo wiilasha Haaruun oo wadaaddada ahu dhiiggiisa ha ku dul rusheeyeen hareeraha meesha allabariga. ");
INSERT INTO som_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Oo haddana isagu xubin xubin ha u kala googooyo, iyo madaxiisa iyo baruurtiisa, oo markaas wadaadku waa inuu ku dul hagaajiyo qoryaha dabka meesha allabariga saaran, ");
INSERT INTO som_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","laakiinse neefka uurkujirtiisa iyo addimmadiisa biyo ha ku maydho, oo wadaadku dhammaantiis ha bixiyo, oo meesha allabariga dusheeda ha ku gubo, waayo, waa qurbaan la gubo oo ah qurbaan dab lagu sameeyo, oo Rabbiga caraf udgoon u ah. ");
INSERT INTO som_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Oo haddii qurbaankiisa uu Rabbiga u bixinayo uu yahay haad qurbaan la gubo ah, markaas qurbaankiisa ha u bixiyo qoolleyo ama xamaam yaryar. ");
INSERT INTO som_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Oo wadaadku ha keeno meesha allabariga agteeda, oo madaxa ha ka maroojiyo, oo meesha allabariga dusheeda ha ku gubo, oo dhiiggana ha lagaga miiro meesha allabariga agteeda. ");
INSERT INTO som_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Oo waa inuu ka soo bixiyaa gulgulada iyo baalasheeda oo ha ku tuuro meesha allabariga dhinaceeda bari, kaasoo ah meeshii dambaska. ");
INSERT INTO som_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Oo garbaha ha ka jeexo, laakiinse yuusan kala dillaacin dhammaanteed, oo wadaadku ha ku dul gubo qoryaha dabka meesha allabariga saaran, waayo, waa qurbaan la gubo oo ah qurbaan dab lagu sameeyo, oo Rabbiga caraf udgoon u ah. ");
INSERT INTO som_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Oo markii qof qurbaan hadhuudh ah Rabbiga u bixinayo, qurbaankiisu ha ahaado bur, oo waa inuu saliid ku shubaa, oo fooxna saaraa. ");
INSERT INTO som_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Oo isagu ha u keeno wadaaddada wiilasha Haaruun ah, oo cantoobo muggeed ha ka qaato burka, iyo saliidda, iyo fooxa oo dhan, oo wadaadku xusuus ahaan meesha allabariga dusheeda ha ugu gubo, waayo, waa qurbaan dab lagu sameeyo oo Rabbiga caraf udgoon u ah. ");
INSERT INTO som_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Oo wixii qurbaanka hadhuudhka ah ka hadhana waxaa iska leh Haaruun iyo wiilashiisa; oo waa wax ugu wada quduusan qurbaannada Rabbiga ee dab lagu sameeyo. ");
INSERT INTO som_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Oo markaad bixinaysid qurbaan hadhuudh ah oo foorno lagu dubay, ha ahaado moofo aan khamiir lahayn oo laga sameeyo bur saliid lagu daray, ama canjeero aan khamiir lahayn oo saliidu marsan tahay. ");
INSERT INTO som_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Oo haddii qurbaankaagu yahay qurbaan hadhuudh ah oo digsi lagu dubay, ha ahaado bur aan khamiir lahayn oo saliid lagu daray. ");
INSERT INTO som_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Waa inaad cad cad u kala jejebisid oo aad saliid ku shubtid, waayo, waa qurbaan hadhuudh ah. ");
INSERT INTO som_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Oo haddii qurbaankaagu yahay qurbaan hadhuudh ah oo birdaawe lagu dubay, markaas ha laga sameeyo bur saliid lagu daray. ");
INSERT INTO som_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Oo qurbaanka hadhuudhka ah oo waxyaalahaas laga sameeyey waa inaad Rabbiga u keentaa, oo waa in wadaadka loo dhiibaa, oo isna meesha allabariga ha keeno. ");
INSERT INTO som_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Oo wadaadku qurbaanka hadhuudhka ah waa inuu ka qaadaa intii xusuusta ahayd, oo meesha allabariga dusheeda ha ku gubo, waayo, waa qurbaan dab lagu sameeyo oo Rabbiga caraf udgoon u ah. ");
INSERT INTO som_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Oo wixii qurbaanka hadhuudhka ah ka hadho waa in Haaruun iyo wiilashiisu iska lahaadaan, oo waa wax ugu wada quduusan qurbaannada Rabbiga ee dab lagu sameeyo. ");
INSERT INTO som_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Qurbaan hadhuudh ah oo aad Rabbiga u bixinaysaan waa inaan khamiir lagu samayn, waayo, waa inaydaan khamiir iyo malab toona sidii qurbaan Rabbiga dab loogu sameeyo u gubin. ");
INSERT INTO som_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Iyaga waa inaad Rabbiga ugu bixisaan sidii qurbaan midhaha ugu horreeya ah, laakiinse waa inaan meesha allabariga loogu dul gubin caraf udgoon aawadeed. ");
INSERT INTO som_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Oo qurbaan kasta oo ah qurbaankaaga hadhuudhka ah waa inaad cusbaysaa, oo waa inaadan innaba u oggolaan in cusbadii axdiga Ilaahaaga ay ka maqnaato qurbaankaaga hadhuudhka ah. Qurbaannadaada oo dhan waa inaad cusbo la bixisaa. ");
INSERT INTO som_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Oo haddaad Rabbiga u bixinaysid qurbaan hadhuudh ah oo midhaha ugu horreeya ah, qurbaankaaga hadhuudhka ah oo midhaha ugu horreeya ah waxaad u bixisaa sabuul qoyan oo la dubay oo la tumay. ");
INSERT INTO som_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Oo waa inaad saliid ku shubtaa, fooxna saartaa, waayo, taasu waa qurbaan hadhuudh ah. ");
INSERT INTO som_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Oo wadaadku waa inuu gubaa intii xusuusta ahayd, oo qaarkeed ha ahaado hadhuudhka tuman, qaarkeedna ha ahaado saliiddeeda, iyo fooxeeda oo dhan, waayo, taasu waa qurbaan Rabbiga dab loogu sameeyo. ");
INSERT INTO som_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Oo haddii qurbaankiisu yahay allabari qurbaanno nabaadiino ah, oo uu lo'da ka bixinayo, lab ama dhaddig midduu yahayba, waa inuu Rabbiga hortiisa ku bixiyaa neef aan iin lahayn. ");
INSERT INTO som_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Oo waa inuu gacanta saaraa madaxa neefka qurbaanka ah, oo waa inuu ku ag gowracaa iridda teendhada shirka, oo wiilasha Haaruun oo wadaaddada ahu waa inay dhiigga ku dul rusheeyaan hareeraha meesha allabariga. ");
INSERT INTO som_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Oo allabariga qurbaannada nabaadiinada ah waa inuu Rabbiga qurbaan dab loogu sameeyo uga bixiyaa xaydha gudaha ku duuban, iyo xaydha neefka uurkiisa ku jirta oo dhan, ");
INSERT INTO som_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","iyo labada kelyood iyo xaydha dushooda ku taal, oo xanjaadka u dhow, iyo xuubka beerka ku dul yaal, dhammaantood kelyaha ha la qaado. ");
INSERT INTO som_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Oo wiilasha Haaruun waa inay ku dul gubaan meesha allabariga iyo qurbaanka la gubayo oo kor saaran qoryaha dabka, waayo, taasu waa qurbaan dab lagu sameeyo oo Rabbiga caraf udgoon u ah. ");
INSERT INTO som_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Oo haddii qurbaankiisu yahay allabari qurbaanno nabaadiino ah oo uu adhiga ka bixinayo, lab iyo dhaddig miduu yahayba, waa inuu bixiyaa neef aan iin lahayn. ");
INSERT INTO som_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Oo hadduu qurbaankiisa wan yar ku bixinayo, Rabbiga hortiisa ha ku bixiyo. ");
INSERT INTO som_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Oo waa inuu gacanta saaraa madaxa neefka qurbaanka ah, oo waa inuu teendhada shirka horteeda ku gowracaa, oo wiilashii Haaruun waa inay neefka dhiiggiisa ku dul rusheeyaan hareeraha meesha allabariga. ");
INSERT INTO som_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Oo allabariga qurbaannada nabaadiinada ah waa inuu Rabbiga qurbaan dab loogu sameeyo uga bixiyaa xaydhiisa iyo badhidiisa oo dhan, taasoo uu ka gooyo meesha ay lafta dhabarka ka haysato, iyo xaydha gudaha ku duuban, iyo xaydha neefka uurkiisa ku jirta oo dhan, ");
INSERT INTO som_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","iyo labada kelyood, iyo xaydha dushooda ku taal, oo xanjaadka u dhow, iyo xuubka beerka ku dul yaal, dhammaantood kelyaha ha la qaado. ");
INSERT INTO som_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Oo wadaadku ha ku dul gubo meesha allabariga, waayo, waxaasu waa cuntadii qurbaanka Rabbiga dabka loogu sameeyo. ");
INSERT INTO som_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Oo haddii qurbaankiisu neef riyo ah yahayna, Rabbiga hortiisa ha ku bixiyo. ");
INSERT INTO som_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Oo waa inuu gacanta saaraa madaxa neefka, oo teendhada shirka horteeda waa inuu ku gowracaa, oo wiilasha Haaruunna neefka dhiiggiisa waa inay ku dul rusheeyaan hareeraha meesha allabariga. ");
INSERT INTO som_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Oo isagu ha bixiyo qurbaankiisii, kaasoo ah qurbaan Rabbiga dab loogu sameeyo oo ah xaydha gudaha ku duuban, iyo xaydha neefka uurkiisa ku jirta oo dhan, ");
INSERT INTO som_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","iyo labada kelyood, iyo xaydha ku dul taal oo xanjaadka u dhow, iyo xuubka beerka ku dul yaal, dhammaantood kelyaha ha la qaado. ");
INSERT INTO som_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Oo wadaadku ha ku dul gubo meesha allabariga, waayo, waxaasu waa cuntadii qurbaankii dabka loogu sameeyo caraf udgoon. Xaydha oo dhan Rabbigaa iska leh. ");
INSERT INTO som_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Tan iyo ab ka ab waa inuu qaynuun joogto ah ku ahaadaa meel kastoo aad deggan tihiinba inaydaan cunin xaydh iyo dhiig midnaba. ");
INSERT INTO som_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Markaasaa Rabbigu Muuse la hadlay oo ku yidhi, ");
INSERT INTO som_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Dadka reer binu Israa'iil la hadal, oo waxaad ku tidhaahdaa, Haddii mid kama' ugu dembaabo waxyaalihii Rabbigu amray inaan la samayn, oo uu sameeyo waxyaalahaas qaarkood, ");
INSERT INTO som_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","iyo haddii wadaadka subkanu uu dembaabo oo uu sidaas dadka dembi ugu keeno, markaas waa inuu dembigiisa uu dembaabay aawadiis Rabbiga qurbaan dembi ugu bixiyaa dibi yar oo aan iin lahayn. ");
INSERT INTO som_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Oo dibiga waa inuu Rabbiga ugu hor keenaa iridda teendhada, oo waa inuu gacanta saaraa madaxa dibiga, oo uu dibiga Rabbiga hortiisa ku gowracaa. ");
INSERT INTO som_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Oo wadaadka subkanu waa inuu dhiigga dibiga qaarkiis qaadaa oo uu teendhada shirka keenaa, ");
INSERT INTO som_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","oo markaas wadaadku fartiisa dhiigga ha geliyo, oo dhiigga toddoba jeer waa inuu Rabbiga ugu hor saydhaa ilxidhka meesha quduuska ah. ");
INSERT INTO som_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Oo wadaadku waa inuu dhiigga qaarkiis mariyaa geesaha meesha allabariga ee fooxa oo Rabbiga hortiisa taal oo teendhada shirka ku dhex taal, oo dibiga dhiiggiisa oo dhanna waa inuu ku ag shubaa salka meesha allabariga ee qurbaanka la gubo, taasoo iridda teendhada shirka taal. ");
INSERT INTO som_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Oo dibiga qurbaanka dembiga loo bixinayo xaydhiisa oo dhan waa inuu ka bixiyaa, waana xaydha gudaha ku duuban, iyo xaydha neefka uurkiisa ku jirta oo dhan, ");
INSERT INTO som_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","iyo labada kelyood, iyo xaydha ku dul taal, oo xanjaadka u dhow, iyo xuubka beerka ku dul yaal, dhammaantood kelyaha ha la qaado, ");
INSERT INTO som_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","sida dibiga allabariga qurbaannada nabaadiinada ah looga qaado oo kale, oo wadaadku ha ku dul gubo meesha allabariga ee qurbaanka la gubo. ");
INSERT INTO som_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Oo dibiga haraggiisa iyo hilibkiisa oo dhan, iyo madaxiisa, iyo addimmadiisa, iyo uurkujirtiisa, iyo uuskiisa, ");
INSERT INTO som_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","iyo xataa dibiga oo dhan waa inuu xerada dibadda uga bixiyaa oo uu geeyaa meel daahirsan, taasoo ah meesha dambaska lagu soo daadiyo, oo intuu qoryo saaro waa inuu dab ku gubaa. Meesha dambaska lagu soo daadiyo waa in lagu gubaa. ");
INSERT INTO som_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Oo ururka reer binu Israa'iil oo dhammu hadduu qaldamo, oo ay waxaasu indhaha shirka ka qarsoon yihiin, oo ay sameeyaan wax ka mid ah waxyaalihii uu Rabbigu amray inaan la samayn, oo ay saas eed ku leeyihiin, ");
INSERT INTO som_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","dembigii ay dembaabeen markii la ogaado, shirku waa inuu dibi yar qurbaan dembi u bixiyaa, oo uu dibiga keenaa teendhada shirka horteeda. ");
INSERT INTO som_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Oo odayaasha ururku waa inay Rabbiga hortiisa gacmahooda ku saaraan madaxa dibiga, oo dibiga Rabbiga hortiisa ha lagu gowraco. ");
INSERT INTO som_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Oo wadaadka subkanu waa inuu dibiga dhiiggiisa keenaa teendhada shirka, ");
INSERT INTO som_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","oo markaas wadaadku fartiisa dhiigga ha geliyo, oo toddoba jeer waa inuu Rabbiga ugu hor saydhaa ilxidhka. ");
INSERT INTO som_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Oo isagu waa inuu dhiigga qaarkiis mariyaa geesaha meesha allabariga oo Rabbiga hortiisa taal oo teendhada shirka ku dhex taal, oo dibiga dhiiggiisa oo dhanna waa inuu ku ag shubaa salka meesha allabariga ee qurbaanka la gubo, taasoo iridda teendhada shirka taal. ");
INSERT INTO som_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Oo dibiga xaydhiisa oo dhanna waa inuu ka bixiyaa, oo meesha allabariga ku dul gubaa. ");
INSERT INTO som_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Oo dibiga ha ku sameeyo siduu ku sameeyey dibigii qurbaanka dembiga oo kale, oo kanna sidaas oo kale ha ku sameeyo; oo wadaadku iyaga kafaaraggud ha u sameeyo, oo iyana waa la cafiyi doonaa. ");
INSERT INTO som_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Oo dibiga waa inuu xerada dibadda uga bixiyaa oo uu gubaa siduu dibigii hore u gubay oo kale, waayo, kaasu wuxuu shirka u yahay qurbaanka dembiga. ");
INSERT INTO som_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Markii qof madax ahu dembaabo oo uu kama' u sameeyo mid ka mid ah waxyaalihii Rabbiga Ilaahiisa ahu uu amray inaan la samayn, oo uu saas eed ku leeyahay, ");
INSERT INTO som_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","haddii la ogeysiiyo dembigiisii uu dembaabay, waa inuu qurbaankiisa aawadiis u keenaa neef riyo ah, waana inuu ahaadaa mid lab oo aan iin lahayn. ");
INSERT INTO som_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Oo waa inuu gacanta saaraa madaxa orgiga, oo uu ku gowracaa meesha lagu gowraco qurbaanka la gubo oo Rabbiga hortiisa ah, waayo, kaasu waa qurbaan dembi. ");
INSERT INTO som_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Oo wadaadku waa inuu dhiigga qaarkiis ku qaadaa fartiisa oo uu mariyaa geesaha meesha allabariga qurbaanka la gubo, oo dhiiggana waa inuu ku ag shubaa salka meesha allabariga qurbaanka la gubo. ");
INSERT INTO som_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Oo xaydhiisa oo dhanna waa inuu ku dul gubaa meesha allabariga, sidii xaydhii allabariga qurbaannada nabaadiinada ah oo kale, oo wadaadku waa inuu kafaaraggud u sameeyaa dembigiisii, oo isna waa la cafiyi doonaa. ");
INSERT INTO som_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Oo dadka dhulka mid ka mid ahu hadduu kama' ku dembaabo, oo uu sameeyo wax ka mid ah waxyaalihii uu Rabbigu amray inaan la samayn, oo uu saas eed ku leeyahay, ");
INSERT INTO som_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","haddii la ogeysiiyo dembigiisii uu dembaabay, waa inuu qurbaankiisa aawadiis u keenaa neef riyo ah, waana inuu ahaadaa mid dhaddig oo aan iin lahayn, dembigiisii uu dembaabay aawadiis. ");
INSERT INTO som_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Oo waa inuu gacanta saaraa madaxa neefka ah qurbaanka dembiga, oo waa inuu neefka ah qurbaanka dembiga ku gowracaa meesha lagu gowraco qurbaanka la gubo. ");
INSERT INTO som_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Oo wadaadku waa inuu dhiigga qaarkiis fartiisa ku qaadaa oo uu mariyaa geesaha meesha allabariga qurbaanka la gubo, oo dhiigga oo dhanna waa inuu ku ag shubaa salka meesha allabariga. ");
INSERT INTO som_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Oo xaydhiisa oo dhanna waa in laga bixiyaa sidii xaydha looga bixiyo allabarigii qurbaannada nabaadiinada ah, oo wadaadku waa inuu meesha allabariga ku dul gubaa, si ay Rabbiga ugu ahaato caraf udgoon; oo wadaadku waa inuu isaga kafaaraggud u sameeyaa, oo isna waa la cafiyi doonaa. ");
INSERT INTO som_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Oo hadduu neef ido yar ah u keeno qurbaanka dembigana waa inuu neef dhaddig oo aan iin lahayn keenaa. ");
INSERT INTO som_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Oo waa inuu gacanta saaraa madaxa neefka qurbaanka dembiga ah, oo waa inuu qurbaanka dembiga ugu gowracaa meesha lagu gowraco qurbaanka la gubo. ");
INSERT INTO som_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Oo wadaadku waa inuu qurbaanka dembiga dhiiggiisa qaarkiis fartiisa ku qaadaa oo uu mariyaa geesaha meesha allabariga qurbaanka la gubo lagu baxsho, oo dhiigga oo dhanna waa inuu ku ag shubaa salka meesha allabariga. ");
INSERT INTO som_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Oo xaydhiisa oo dhanna waa inuu ka bixiyaa sidii xaydhii laga qaado wanka yara oo ahaa allabarigii qurbaannada nabaadiinada ah, oo wadaadku waa inuu ku dul gubaa meesha allabariga, sidii qurbaannadii Rabbiga dabka loogu sameeyo, oo wadaadku waa inuu kafaaraggud u sameeyaa dembigiisii uu dembaabay, oo isna waa la cafiyi doonaa. ");
INSERT INTO som_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Haddii qof ku dembaabo cod dhaar ah oo uu maqlay, ee uu isagu marag ka yahay, hadduu arkay iyo hadduu gartayba, hadduusan sheegin waa inuu dembigiisa qaataa. ");
INSERT INTO som_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Ama haddii qof taabto wax nijaas ah, hadduu yahay bahal nijaas ah baqtigiis, ama neef xoolo ah oo nijaas ah baqtigiis, ama waxyaalo gurguurta oo nijaas ah baqtigood, haddii taasu ay isaga ka qarsoon tahay, oo uu saas ku nijaasoobo, markaas isagu wuxuu ahaan doonaa mid eed leh. ");
INSERT INTO som_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Ama hadduu taabto qof nijaastiis, nijaasta uu ku nijaasoobay wax kastoo ay tahayba, haddii taasu ay isaga ka qarsoon tahay, markuu ogaado wuxuu ahaan doonaa mid eed leh. ");
INSERT INTO som_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Ama haddii mid uu bushimihiisa degdeg ugaga dhaarto inuu samaynayo xumaan ama samaan, wax kasta ha ahaadeene wixii qof degdeg ugu dhaarto, hadday waxaasu isaga ka qarsoon yihiin, markuu waxaas ogaado wuxuu ahaan doonaa mid waxyaalahan midkood eed ku leh. ");
INSERT INTO som_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Oo markuu ahaado mid waxyaalahan midkood eed ku leh waa inuu qirtaa wixii uu ku dembaabay, ");
INSERT INTO som_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","oo markaas waa inuu dembigii uu dembaabay aawadiis Rabbiga ugu keenaa qurbaankii xadgudubkiisa, oo waa inuu adhiga ka soo qabto neef dhaddig ah, oo ah nayl ama waxar oo qurbaan dembi ah, oo wadaadku waa inuu kafaaraggud uga sameeyaa dembigiisii. ");
INSERT INTO som_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Oo haddii lacagtiisu ayan ugu filnayn inuu neef baraar ah keeno, markaas dembigii uu dembaabay aawadiis waa inuu qurbaankii xadgudubkiisa Rabbiga ugu keenaa laba qoolley ama laba xamaam oo yaryar, oo mid qurbaan dembi ha ka dhigo, midda kalena qurbaan la gubo. ");
INSERT INTO som_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Iyaga waa inuu wadaadka u keenaa, oo isna marka hore ha bixiyo tan qurbaanka dembiga ah, oo madaxa ha ka maroojiyo, laakiinse waa inuusan kala dillaacin. ");
INSERT INTO som_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Oo qurbaanka dembiga dhiiggiisa qaarkiis waa inuu ku rusheeyaa meesha allabariga dhinaceeda, oo dhiigga intiisa kalena ha lagaga miiro salka meesha allabariga, waayo, taasu waa qurbaan dembi. ");
INSERT INTO som_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Oo tan labaadna waa inuu qurbaan la gubo ugu bixiyo si qaynuunka waafaqsan, oo wadaadku waa inuu kafaaraggud u sameeyaa dembigiisii uu dembaabay, oo isna waa la cafiyi doonaa. ");
INSERT INTO som_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Laakiinse haddii lacagtiisu ayan ugu filnayn laba qoolley amase laba xamaam oo yaryar, markaas wixii uu ku dembaabay aawadood qurbaankiisa ha u keeno eefaah toban meelood loo dhigay meeshiis oo bur ah, kaasoo qurbaan dembi ah, oo waa inuusan saliid ku shubin, waana inuusan waxba foox saarin, waayo, waa qurbaan dembi. ");
INSERT INTO som_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Oo waa inuu wadaadka u keenaa, oo wadaadkuna waa inuu cantoobo muggeed uga qaataa xusuus, oo meesha allabariga ha ku dul gubo, sidii qurbaannada Rabbiga dabka loogu sameeyo, waayo, waa qurbaan dembi. ");
INSERT INTO som_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Oo wadaadku waa inuu kafaaraggud u sameeya dembigiisii uu ku dembaabay wax kasta oo waxyaalahan ka mid ah, oo isna waa la cafiyi doonaa, oo inta kalena waxaa iska leh wadaadka, sidii qurbaankii hadhuudhka. ");
INSERT INTO som_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Markaasaa Rabbigu Muuse la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Haddii qof xadgudbo oo uu si kama' ah ugu dembaabo Rabbiga waxyaalihiisa quduuska ah, markaas waa inuu Rabbiga u keenaa qurbaankii xadgudubkiisii aawadiis, kaasoo ah wan aan iin lahayn oo idaha laga soo bixiyey, oo aad ku qiimaysay lacag intuu sheqel yahay, iyadoo lagu miisaamay sheqelka meesha quduuska ah, oo kaas qurbaan xadgudub ha u bixiyo. ");
INSERT INTO som_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Oo alaabtii quduuska ahayd oo uu ku dembaabay waa inuu magdhabaa, oo weliba iyadoo shan meelood loo dhigay meesheed waa inuu ku daraa, oo waa inuu wadaadka u dhiibaa, oo wadaadkuna waa inuu isaga kafaaraggud uga dhigaa wankii ahaa qurbaanka xadgudubka oo isna waa la cafiyi doonaa. ");
INSERT INTO som_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Oo haddii qof dembaabo oo uu sameeyo wax ka mid ah waxyaalihii uu Rabbigu amray inaan la samayn, in kastoo uusan ogayn, weli eed buu leeyahay, oo waa inuu dembigiisa qaataa. ");
INSERT INTO som_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Oo isagu waa inuu idaha ka soo bixiyaa wan aan iin lahayn oo aad adigu qiimaysay, oo waa inuu wadaadka ugu dhiibaa qurbaan xadgudub, oo wadaadkuna waa inuu kafaaraggud u sameeyaa wixii uu kama' ugu qaldamay isagoo aan ogayn, oo isna waa la cafiyi doonaa. ");
INSERT INTO som_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Waa qurbaan xadgudub, maxaa yeelay, sida xaqiiqada ah isagu Rabbiga hortiisa eed buu ku leeyahay. ");
INSERT INTO som_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Markaasaa Rabbigu Muuse la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Haddii qof dembaabo oo uu Rabbiga ku xadgudbo, oo uu si aan daacad ahayn deriskiisa kula macaamiloodo wax ku saabsan carbuun, ama rahmad, ama dhicid, amase hadduu deriskiisa dulmo, ");
INSERT INTO som_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","amase hadduu helo wax lumay oo uu waxaas qarsado oo uu been ku dhaarto, hadduu waxyaalahaas midkood sameeyo oo uu saas ku dembaabo, ");
INSERT INTO som_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","markaas hadduu dembaabay oo uu eedaysan yahay waa inuu soo celiyaa wixii uu dhacay, ama wixii uu dulmi ku qaatay, ama carbuunkii isaga loo dhiibtay, ama wixii lumay oo uu helay, ");
INSERT INTO som_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","amase wixii uu beenta ugu dhaartay, waa inuu celiyaa iyagoo kaamil ah, oo weliba waa inuu ku daraa iyada oo shan meelood loo dhigay meesheed. Oo waa inuu siiyaa kii waxaas lahaa maalintii la ogaado inuu isagu eedaysan yahay. ");
INSERT INTO som_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Oo isagu qurbaanka xadgudubkiisa aawadiis waa inuu Rabbiga ugu keenaa wan aan iin lahayn oo uu idaha ka soo bixiyey ee aad qiimaysay, oo qurbaan xadgudub aawadiis wadaadka ha ugu keeno. ");
INSERT INTO som_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Oo wadaadkuna waa inuu isaga kafaaraggud ugu sameeyaa Rabbiga hortiisa, oo isna waa laga cafiyi doonaa wixii uu sameeyey oo uu ku eedaysan yahay oo dhanba. ");
INSERT INTO som_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Markaasaa Rabbigu Muuse la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Haaruun iyo wiilashiisa amar oo waxaad ku tidhaahdaa, Kanu waa sharciga qurbaanka la gubo ku saabsan: qurbaanka la gubo waa inuu habeenkii oo dhan saarnaadaa qoryaha meesha allabariga saaran tan iyo ilaa waagu ka baryo; oo dabka meesha allabarigana waa in laga sii ololiyaa. ");
INSERT INTO som_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Oo wadaadkuna waa inuu xidhaa dharkiisa wanaagsan, oo sirwaalkiisa marada wanaagsan laga sameeyeyna waa inuu gashadaa, oo waa inuu qaadaa dambaskii qurbaanka la gubayay oo dabku meesha allabariga dusheeda ku baabba'saday, oo waa inuu meesha allabariga ku ag shubaa. ");
INSERT INTO som_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Oo markaas waa inuu dharkiisii iska furaa oo uu dhar kale xidhaa, oo dambaska waa inuu meel daahirsan oo xerada dibaddeeda ah u qaadaa. ");
INSERT INTO som_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Oo dabka meesha allabarigana waa in had iyo goor la sii ololiyaa oo waa inuusan marna demin; oo wadaadku waa inuu subax kasta qoryo saaraa, oo uu qurbaanka la gubona ku dul hagaajiyaa, oo xaydha qurbaanka nabaadiinadana waa inuu ku dul gubaa. ");
INSERT INTO som_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Oo dab joogto ah waa in meesha allabariga dusheeda laga sii ololiyaa had iyo goorba, oo waa inuusan marna demin. ");
INSERT INTO som_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Oo kanuna waa sharciga qurbaanka hadhuudhka ku saabsan: Wiilashii Haaruun waa inay ku hor bixiyaan meesha allabariga ee Rabbiga hortiisa ah. ");
INSERT INTO som_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Oo isagu waa inuu cantoobadiisa muggeed ka qaadaa burka wanaagsan ee qurbaanka hadhuudhka ah iyo saliiddiisa, iyo kulli fooxa saaran qurbaanka hadhuudhka oo dhan, oo waa inuu meesha allabariga ugu dul gubaa caraf udgoon ee xusuus u ah Rabbiga. ");
INSERT INTO som_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Oo wixii qurbaankaas ka hadhayna Haaruun iyo wiilashiisu ha cuneen. Iyadoo aan khamiir lahayn waa in meel quduus ah lagu cunaa; oo iyagu waa inay ku cunaan barxadda teendhada shirka. ");
INSERT INTO som_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Waa inaan khamiir lagu dubin. Anigu taas waxaan iyaga u siiyey qaybtoodii ay ka heli lahaayeen qurbaannadayda dabka lagu sameeyo. Iyadu waa ugu quduusan tahay oo waa sidii qurbaankii dembiga iyo sidii qurbaankii xadgudubka. ");
INSERT INTO som_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Oo qof kasta oo lab ah oo reer Haaruun ka mid ahu waa inuu wax ka cunaa, oo tan iyo ab ka ab intaasaa looga amray qurbaannada Rabbiga oo dabka lagu sameeyo; oo ku alla kii taabtaana quduus buu ahaan doonaa. ");
INSERT INTO som_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Markaasaa Rabbigu Muuse la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Kanu waa qurbaanka Haaruun iyo wiilashiisu ay Rabbiga u bixin doonaan maalintii isaga la subko, waana eefaah bur ah oo toban meelood loo dhigay meeshiis, oo ah qurbaan hadhuudh oo joogto ah, oo intaas badhkeed subaxdii ha la bixiyo, badhka kalena fiidkii ha la bixiyo. ");
INSERT INTO som_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Oo waa in lagu sameeyo digsi oo saliid lagu sameeyo, oo markii la isku qooshay waa inaad gudaha soo gelisaa. Xabbad xabbad la dubay waa inaad u bixisaa qurbaanka hadhuudhka oo Rabbiga caraf udgoon u ah. ");
INSERT INTO som_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Oo waxaa bixin doona wadaadka subkan oo reer Haaruun oo isaga meeshiisa joogi doono, oo qaynuun weligiis ah waa in dhammaan Rabbiga loogu gubaa. ");
INSERT INTO som_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Oo qurbaan kasta oo hadhuudh ah oo wadaadku bixiyoba waa in dhammaantiis la wada guba, oo waa inaan la cunin. ");
INSERT INTO som_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Markaasaa Rabbigu Muuse la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","La hadal Haaruun iyo wiilashiisa, oo waxaad ku tidhaahdaa, Kanu waa sharciga ku saabsan qurbaanka dembiga: meesha qurbaanka la gubo lagu gowraco waa in qurbaanka dembigana lagu gowracaa Rabbiga hortiisa, waayo, kaasu waa kan ugu wada quduusan. ");
INSERT INTO som_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Oo wadaadka dembiga aawadiis u bixiyaa waa inuu cunaa, waana in lagu cunaa meel quduus ah oo ah barxadda teendhada shirka. ");
INSERT INTO som_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Oo wax alla wixii hilibkiisa taabtaana quduus bay ahaan doonaan, oo dhiiggiisana haddii dhar lagu saydho, wixii uu kaga saydhmay waa inaad ku maydhaa meel quduus ah. ");
INSERT INTO som_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Laakiinse weelka dhoobada ah oo lagu kariyey waa in la burburiyaa, oo haddii weel naxaas ah lagu kariyana waa in la xaquuqaa oo biyo lagu dhaqaa. ");
INSERT INTO som_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Oo wadaaddada intooda laboodka ah oo dhammu waa inay wax ka cunaan, waayo, waa kan ugu wada quduusan. ");
INSERT INTO som_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Oo qurbaankii dembiga oo dhiiggiisa la soo geliyo teendhada shirka si meesha quduuska ah kafaaraggud loogu sameeyo innaba waa inaan la cunin, waase in dab lagu gubaa. ");
INSERT INTO som_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Oo kanuna waa sharciga ku saabsan qurbaanka xadgudubka. Kaasu waa kan ugu wada quduusan. ");
INSERT INTO som_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Meesha qurbaanka la gubo lagu gowraco waa in qurbaanka xadgudubkana lagu gowracaa, oo dhiiggiisana waa inuu ku dul rusheeyaa hareeraha meesha allabariga. ");
INSERT INTO som_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Oo isagu waa inuu bixiyaa baruurta taasoo ah badhida, iyo xaydha gudaha ku duuban, ");
INSERT INTO som_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","iyo labada kelyood iyo xaydha ku dul taal oo xanjaadka u dhow, iyo xuubka beerka ku dul yaal, waa inuu kelyaha la qaadaa. ");
INSERT INTO som_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Oo wadaadku waa inuu meesha allabariga ugu dul gubaa qurbaan Rabbiga dab loogu sameeyo, waayo, kaasu waa qurbaankii xadgudubka. ");
INSERT INTO som_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Oo wadaaddada intooda laboodka ah oo dhammu waa inay wax ka cunaan, oo waa in lagu cunaa meel quduus ah, waayo, kaasu waa kan ugu wada quduusan. ");
INSERT INTO som_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Oo qurbaanka xadgudubku waa sidii qurbaanka dembiga oo kale. Oo iyagu isku sharci ayay leeyihiin, oo wadaadkii kafaaraggudka ku sameeyaa ha lahaado. ");
INSERT INTO som_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Oo wadaadkii qof qurbaan la gubo u bixiyaa ha iska qaato haragga qurbaanka la gubo oo uu bixiyey. ");
INSERT INTO som_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Oo qurbaan kasta oo hadhuudh ah oo foorno lagu dubo, iyo wax alla wixii birdaawe ama digsi lagu sameeyo waxaa iska leh wadaadka bixiya. ");
INSERT INTO som_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Oo qurbaan kasta oo hadhuudh ah oo saliid lagu daray amase engeg ah waa inay wiilasha Haaruun oo dhammu lahaadaan, oo sidii mid u cuno kan kalena ha u cuno. ");
INSERT INTO som_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Oo kanuna waa sharciga ku saabsan allabariga qurbaannada nabaadiinada ah oo Rabbiga loo bixiyo. ");
INSERT INTO som_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Oo hadduu mahadnaqid aawadeed u bixinayo, waa inuu allabariga mahadnaqidda la bixiyaa moofo aan khamiir lahayn oo saliid lagu daray, iyo canjeero aan khamiir lahayn oo saliidu marsan tahay, iyo moofo saliid lagu daray oo bur la qoyay laga sameeyey. ");
INSERT INTO som_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Kibis khamiir leh waa inuu la bixiyaa qurbaankiisa iyo allabariga qurbaannadiisa nabaadiinada ah mahadnaqid aawadeed. ");
INSERT INTO som_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Oo qurbaan kastana waa inuu ka bixiyaa xabbad ah qurbaanka sare loo qaado oo Rabbiga loo bixiyo, oo waxaa iska lahaanaya wadaadka saydhsaydha dhiigga qurbaannada nabaadiinada. ");
INSERT INTO som_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Oo hilibka allabarigiisa qurbaannadiisa nabaadiinada ah oo uu mahadnaqidda u bixiyo waa in dhammaantiis la cunaa maalinta uu qurbaankiisa bixiyo, oo waa inuusan waxba ka gaadhsiin tan iyo subaxda dambe. ");
INSERT INTO som_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Laakiinse haddii allabariga qurbaankiisu uu yahay nidar amase qurbaan uu ikhtiyaar u bixiyo, waa in la cunaa maalinta uu bixiyo allabarigiisa, oo wixii ka hadhana maalinta ku xigta ha la cuno. ");
INSERT INTO som_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Laakiinse hilibka allabariga wixii ka hadha oo maalinta saddexaad gaadha waa in dab lagu gubaa. ");
INSERT INTO som_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Oo haddii hilibka allabarigiisa qurbaannada nabaadiinada ah la cuno maalinta saddexaad, markaas la aqbali maayo, oo kii bixiyeyna loo xisaabi maayo, laakiin taasu waxay ahaan doontaa karaahiyo, oo qofkii cunaana isagaa dembigiisa qaadanaya. ");
INSERT INTO som_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Oo hilibkii taabta wax nijaas ahna waa inaan la cunin; waase in dab lagu gubaa. Oo hilibkana qof kasta oo daahir ahu wax ha ka cuno. ");
INSERT INTO som_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Laakiinse hilibka allabariga qurbaannada nabaadiinada ah oo Rabbigu iska leeyahay qofkii cuna isagoo nijaastiisii ku taal waa in dadkiisii laga gooyaa. ");
INSERT INTO som_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Oo qof hadduu taabto wax nijaas ah, hadday tahay qof nijaastiis ama bahal nijaas ah amase karaahiyo nijaas ah, oo uu wax ka cuno hilibka allabariga qurbaannada nabaadiinada ah oo Rabbigu iska leeyahay, qofkaas waa in dadkiisa laga gooyaa. ");
INSERT INTO som_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Markaasaa Rabbigu Muuse la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Reer binu Israa'iil la hadal oo waxaad ku tidhaahdaa, Idinku waa inaydaan cunin baruur lo'aad ama mid idaad amase mid riyood. ");
INSERT INTO som_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Oo neefkii iska dhinta baruurtiisa iyo neefkii dugaaggu bakhtiisto baruurtiisa toona waa inaydaan sinaba u cunin, laakiinse siyaalo kale waa loogu isticmaali karaa. ");
INSERT INTO som_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Waayo, qofkii cuna baruurtii neefka dadku u bixiyo qurbaan dab loogu sameeyo Rabbiga, qofka kaas cuna waa in dadkiisa laga gooyaa. ");
INSERT INTO som_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Oo waa inaydaan degmooyinkiinna oo dhan ku dhex cunin dhiig cayn kasta ha ahaadee, hadduu yahay mid haad ama mid xayawaan toona. ");
INSERT INTO som_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Ku kasta ha ahaadee qofkii dhiig cuna waa in dadkiisa laga gooyaa. ");
INSERT INTO som_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Markaasaa Rabbigu Muuse la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Reer binu Israa'iil la hadal oo waxaad ku tidhaahdaa, Kii Rabbiga u bixiyaa allabarigiisa qurbaannada nabaadiinada ah waa inuu Rabbiga qurbaankiisa uga keenaa allabariga qurbaannadiisa nabaadiinada ah. ");
INSERT INTO som_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Waa inuu gacmihiisa ku keenaa qurbaannada Rabbiga oo dabka lagu sameeyo; waa inuu keenaa baruurta iyo sakaarka in sakaarka Rabbiga hortiisa lagu ruxruxo sidii qurbaanka la ruxruxo. ");
INSERT INTO som_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Oo wadaadku waa inuu baruurta ku dul gubaa meesha allabariga, laakiinse sakaarka waxaa iska leh Haaruun iyo wiilashiisa. ");
INSERT INTO som_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Oo allabariga ah qurbaannadiinna nabaadiinada waxaad ka soo bixisaan bowdada midig oo waa inaad wadaadka siisaan, ha ahaatee qurbaan sare loo qaado. ");
INSERT INTO som_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Kii reer Haaruun ka mid ah oo bixiya dhiigga qurbaannada nabaadiinada iyo baruurta ayaa qayb ahaan u leh bowdada midig. ");
INSERT INTO som_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Waayo, anigu reer binu Israa'iil ayaan allabariga ah qurbaannadooda nabaadiinada kala baxay sakaarka la ruxruxo iyo bowdada sare loo qaado, oo waxaan reer binu Israa'iil amar kaga siiyey wadaadka Haaruun iyo wiilashiisa weligoodba. ");
INSERT INTO som_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Taasu waa qaybtii subkidda oo Haaruun iyo qaybtii subkidda oo wiilashiisa oo la kala baxayo qurbaannada Rabbiga oo dabka lagu sameeyo, maalintii iyaga loo keenay Rabbiga inay isaga uga adeegaan jagada wadaadnimada, ");
INSERT INTO som_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","kuwaasoo maalintii la subkay uu Rabbigu amray in reer binu Israa'iil iyaga siiyaan, oo taasna ab ka ab baa loo amray. ");
INSERT INTO som_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Haddaba kanu waa sharciga ku saabsan qurbaanka la gubo, iyo qurbaanka hadhuudhka, iyo qurbaanka dembiga, iyo qurbaanka xadgudubka, iyo kan quduuskadhigidda, iyo kan allabariga qurbaannada nabaadiinada ah, ");
INSERT INTO som_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","ee uu Rabbigu Muuse kaga amray Buur Siinay maalintii uu reer binu Israa'iil ku amray inay Rabbiga u bixiyaan qurbaannadooda iyagoo jooga cidladii Siinay. ");
INSERT INTO som_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Markaasaa Rabbigu Muuse la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","Waxaad keentaa Haaruun iyo wiilashiisa oo isaga la jira, iyo dharka, iyo saliidda lagu subkado, iyo dibiga ah qurbaanka dembiga, iyo labada wan, iyo dambiisha ay kibista aan khamiirka lahaynu ku jirto. ");
INSERT INTO som_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Oo ururka oo dhanna waxaad ku soo shirisaa iridda teendhada shirka. ");
INSERT INTO som_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Oo Muusena waa yeelay wixii Rabbigu isaga ku amray, oo ururkiina waa lagu soo shiriyey iridda teendhadii shirka. ");
INSERT INTO som_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Kolkaasaa Muuse ururkii oo dhan ku yidhi, Waxanu waa waxa Rabbigu amray in la sameeyo. ");
INSERT INTO som_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Markaasaa Muuse wuxuu soo kexeeyey Haaruun iyo wiilashiisii, oo biyuu iyagii ku maydhay. ");
INSERT INTO som_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Oo wuxuu isagii u geliyey jubbaddii, oo dhexdana wuxuu ugu xidhay dhex-xidhka, oo wuxuu u geliyey khamiiskii, eefodkiina wuu u geliyey, oo dhexdana wuxuu ugu xidhay dhex-xidhkii eefodka oo daabaca lahaa, oo kaasuu isagii ku xidhay. ");
INSERT INTO som_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Oo haddana wuxuu isagii saaray laabgashigii, oo laabgashigiina wuxuu geliyey Uuriimkii iyo Tummiimkii. ");
INSERT INTO som_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Oo madaxana wuxuu u saaray duub, oo duubka dhankiisa horena wuxuu ku dhejiyey waslad khafiif ah oo dahab ah oo ah taajka quduuska ah sidii Rabbigu Muuse ku amray. ");
INSERT INTO som_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Markaasaa Muuse soo qaaday saliidda lagu subkado, oo wuxuu ku subkay taambuuggii iyo waxyaalihii gudihiisa ku jiray oo dhan, oo dhammaantoodna quduus buu ka dhigay. ");
INSERT INTO som_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Oo qaarkeedna wuxuu toddoba jeer ku saydhsaydhay meeshii allabariga, oo wuxuu subkay meeshii allabariga iyo weelasheedii oo dhan iyo berkeddii weysada iyo salkeedii, si uu dhammaantood quduus uga dhigo. ");
INSERT INTO som_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Oo saliidda lagu subkado qaarkeedna wuxuu ku shubay Haaruun madaxiisa, oo isagii wuu subkay si uu quduus uga dhigo. ");
INSERT INTO som_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Oo haddana Muuse wuxuu soo kexeeyey wiilashii Haaruun, oo wuxuu iyagii u geliyey jubbado, wuxuuna ugu xidhay dhex-xidho, duubabna wuu u duubay sidii Rabbigu Muuse ku amray. ");
INSERT INTO som_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Oo haddana wuxuu keenay dibigii ahaa qurbaanka dembiga, oo Haaruun iyo wiilashiisiina gacmahooday madaxa ka saareen dibigii qurbaankii dembiga ahaa. ");
INSERT INTO som_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Markaasuu dibigii gowracay, oo Muuse wuxuu soo qaaday dhiiggii, oo farta ku mariyey geesihii meesha allabariga, oo meesha allabarigana sidaasuu ku daahiriyey, kolkaasuu dhiigga ku ag shubay salkii meesha allabariga, quduus buuna ka dhigay, si uu kafaaraggud ugu sameeyo. ");
INSERT INTO som_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Oo wuxuu qaaday kulli xaydhii uurka ku jirtay oo dhan, iyo xuubkii beerka ku dul yiil, iyo labada kelyood iyo xaydhooda, oo Muuse intaasuu ku dul gubay meesha allabariga. ");
INSERT INTO som_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Laakiinse dibigii iyo haraggiisii, iyo hilibkiisii, iyo uuskiisiiba wuxuu ku gubay meel xerada dibaddeeda ah sidii Rabbigu Muuse ku amray. ");
INSERT INTO som_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Oo haddana wuxuu keenay wankii ahaa qurbaanka la gubo, oo Haaruun iyo wiilashiisiina gacmahooday madaxa ka saareen wankii. ");
INSERT INTO som_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Oo isna wankii wuu gowracay, markaasaa Muuse dhiiggii ku dul rusheeyey hareeraha meesha allabariga. ");
INSERT INTO som_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Oo wankii xubin xubin buu u kala googooyay, markaasaa Muuse wuxuu gubay madaxii iyo xubnihii iyo xaydhii, ");
INSERT INTO som_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","oo isna uurkujirtii iyo addimmadii ayuu biyo ku maydhay, markaasaa Muuse wankii oo dhan ku dul gubay meesha allabariga, waayo, kaasu wuxuu ahaa qurbaan la gubo oo caraf udgoon loo bixiyo, wuxuuna ahaa qurbaan Rabbiga dab loogu sameeyo, sidii Rabbigu Muuse ku amray. ");
INSERT INTO som_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Oo haddana wuxuu keenay wankii kale, kaasoo ahaa wankii quduuskadhigidda, oo Haaruun iyo wiilashiisiina gacmahooday madaxa ka saareen wankii. ");
INSERT INTO som_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Markaasuu wankii gowracay, oo Muuse wuxuu soo qaaday dhiiggii oo wuxuu mariyey Haaruun caaradda dhegtiisa midig, iyo suulka gacantiisa midig, iyo suulka cagtiisa midig. ");
INSERT INTO som_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Oo haddana wuxuu keenay Haaruun wiilashiisii, kolkaasaa Muuse dhiiggii mariyey caaradda dhegahooda midig, iyo suulka gacantooda midig, iyo suulka cagtooda midig, oo Muusena wuxuu dhiiggii ku dul rusheeyey hareeraha meesha allabariga. ");
INSERT INTO som_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Markaasuu soo qaaday baruurtii, iyo badhidii, iyo xaydhii uurka ku jirtay oo dhan, iyo xuubkii beerka ku yiil, iyo labadii kelyood, iyo xaydhoodii, iyo bowdadii midig. ");
INSERT INTO som_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Oo dambiishii ay kibista aan khamiirka lahaynu ku jirtay oo Rabbiga hortiisa tiilna wuxuu ka soo bixiyey xabbad ah kibis aan khamiir lahayn, iyo xabbad ah moofo saliid leh, iyo xabbad canjeero ah, oo wuxuu saaray baruurtii iyo bowdadii midig, ");
INSERT INTO som_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","oo intaas oo dhan ayuu saaray Haaruun gacantiisii, iyo gacantii wiilashiisa, oo sida qurbaanka la ruxruxo ayaa Rabbiga hortiisa lagu ruxruxay. ");
INSERT INTO som_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Kolkaasaa Muuse gacmahoodii ka qaaday oo wuxuu qurbaankii la gubayay kula dul gubay meesha allabariga, oo waxay ahaayeen quduuskadhigidda oo caraf udgoon loo bixiyo. Taasu waxay ahayd qurbaan Rabbiga dab loogu sameeyo. ");
INSERT INTO som_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Kolkaasaa Muuse qaaday sakaarkii, oo Rabbiga hortiisa ayuu ugu ruxruxay qurbaan la ruxruxo aawadiis, oo kaasu wuxuu ahaa qaybtii Muuse ku lahaa wankii quduuskadhigidda sidii Rabbigu Muuse ku amray. ");
INSERT INTO som_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Markaasaa Muuse qaaday saliiddii lagu subkado qaarkeed iyo dhiiggii meesha allabariga ku kor yiil, oo wuxuu ku kor saydhsaydhay Haaruun, iyo dharkiisii, iyo wiilashiisii, iyo dharkii wiilashiisa, oo wuxuu quduus ka dhigay Haaruun iyo dharkiisii iyo wiilashiisii iyo dharkii wiilashiisaba. ");
INSERT INTO som_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Markaasaa Muuse Haaruun iyo wiilashiisii ku yidhi, Hilibka waxaad ku ag karisaan iridda teendhada shirka, oo halkaas ku cuna hilibka iyo kibista dambiisha quduuskadhigidda ku jirta, sidaan u amray, oo aan u idhi, Haaruun iyo wiilashiisu waa inay cunaan. ");
INSERT INTO som_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Oo hilibka iyo kibista wixii ka hadhana waa inaad dab ku gubtaan. ");
INSERT INTO som_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Oo idinkuna waa inaydaan ka bixin iridda teendhada shirka intii toddoba maalmood ah, ilaa maalmaha quduus laydinka dhigay ay dhammaystirmaan, waayo, isagu wuxuu quduus idinka dhigayaa intii toddoba maalmood ah. ");
INSERT INTO som_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Oo Rabbigu wuxuu amray in la yeelo sida maantadan la yeelay, in kafaaraggud laydiin sameeyo. ");
INSERT INTO som_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Oo intii toddoba maalmood ah habeen iyo maalinba waa inaad ag joogtaan iridda teendhada shirka, oo Rabbiga amarkiisa xajiya yeydnan dhimanine, waayo, sidaasaa laygu amray. ");
INSERT INTO som_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Oo Haaruun iyo wiilashiisiina way wada yeeleen waxyaalihii Rabbigu amray oo uu gacanta Muuse u soo dhiibay oo dhan. ");
INSERT INTO som_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Oo maalintii siddeedaad ayaa Muuse u yeedhay Haaruun iyo wiilashiisii, iyo odayaashii reer binu Israa'iil, ");
INSERT INTO som_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","oo wuxuu Haaruun ku yidhi, Waxaad keentaa dibi yar oo ah qurbaan dembi, iyo wan ah qurbaan la gubo oo aan innaba iin lahayn, oo iyaga Rabbiga hortiisa ku bixi. ");
INSERT INTO som_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Oo reer binu Israa'iilna la hadal oo waxaad ku tidhaahdaa, Waxaad keentaan orgi ah qurbaan dembi, iyo weyl iyo wan oo labadooduba gu jiraan oo aan innaba iin lahayn oo qurbaan la gubo ah. ");
INSERT INTO som_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Oo dibi iyo wanna waxaad u keentaan qurbaanno nabaadiino in Rabbiga hortiisa allabari ahaan loogu bixiyo, iyo qurbaan hadhuudh ah oo saliid lagu daray, waayo, maanta ayaa Rabbigu idiin muuqan doonaa. ");
INSERT INTO som_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Oo iyana waxay teendhadii shirka horteeda keeneen wixii Muuse amray, markaasay dadkii ururkii oo dhammu soo dhowaadeen oo Rabbiga hortiisa istaageen. ");
INSERT INTO som_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Markaasaa Muuse wuxuu yidhi, Waxanu waa wixii Rabbigu idinku amray inaad samaysaan, oo waxaa idiin muuqan doona Rabbiga ammaantiisa. ");
INSERT INTO som_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Kolkaasaa Muuse wuxuu Haaruun ku yidhi, Meesha allabariga u dhowow, oo waxaad bixisaa qurbaankaaga dembiga iyo qurbaankaaga la gubo, oo nafsaddaada kafaaraggud u samee, iyo weliba dadka aawadiis, oo waxaad bixisaa dadka qurbaankiisii oo iyaga kafaaraggud ugu samee sidii Rabbigu amray. ");
INSERT INTO som_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Sidaas daraaddeed ayuu Haaruun u soo dhowaaday meeshii allabariga, oo wuxuu gowracay weylkii isaga nafsaddiisa u ahaa qurbaanka dembiga. ");
INSERT INTO som_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Oo wiilashii Haaruun ayaa isagii u keeneen dhiiggii, oo isna fartiisii ayuu dhiiggii daray oo wuxuu mariyey geesihii meesha allabariga, oo dhiigga intiisii kalena wuxuu ku ag shubay salkii meesha allabariga. ");
INSERT INTO som_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Laakiinse xaydhii, iyo kelyihii, iyo xuubkii laga soo gooyay beerkii qurbaanka dembiga wuxuu ku dul gubay meesha allabariga sidii Rabbigu Muuse ku amray. ");
INSERT INTO som_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Oo hilibkii iyo haraggiina wuxuu ku gubay meel xerada dibaddeeda ah. ");
INSERT INTO som_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Oo haddana wuxuu gowracay neefkii qurbaanka la gubo ahaa, markaasaa wiilashii Haaruun waxay isagii u keeneen dhiiggii, oo isna wuxuu ku dul rusheeyey hareeraha meesha allabariga. ");
INSERT INTO som_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Oo haddana waxay isagii u keeneen neefkii qurbaankii la gubo oo cad cad ah iyo madaxii neefka, oo isna wuxuu ku dul gubay meesha allabariga. ");
INSERT INTO som_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Markaasuu biyo ku maydhay uurkujirtii iyo addimmadii, oo wuxuu ku dul gubay qurbaankii la gubayay oo meesha allabariga saarnaa. ");
INSERT INTO som_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Oo haddana wuxuu keenay qurbaankii dadka, oo wuxuu soo waday ridii dadka u ahayd qurbaankii dembiga, wuuna gowracay oo u bixiyey dembi aawadiis, siduu kan hore yeelay. ");
INSERT INTO som_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Oo haddana wuxuu keenay neefkii qurbankii la gubo ahaa, oo si qaynuunka waafaqsan ayuu u bixiyey. ");
INSERT INTO som_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Oo haddana wuxuu keenay qurbaankii hadhuudhka, markaasuu cantoobo muggeed ka qaaday oo ku dul gubay meesha allabariga, kaasoo ka gooni ah qurbaankii la gubayay oo subaxnimada. ");
INSERT INTO som_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Oo weliba wuxuu gowracay dibigii iyo wankii ahaa allabariga qurbaannada nabaadiinada ah oo dadka aawadiis loo bixinayay; oo markaasay wiilashii Haaruun isagii u keeneen dhiiggii, oo isna wuxuu ku dul rusheeyey hareeraha meesha allabariga. ");
INSERT INTO som_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Markaasay keeneen baruurtii dibiga iyo tii wanka, iyo badhidii, iyo xaydhii gudaha ku duubnayd, iyo kelyihii, iyo xuubkii beerka. ");
INSERT INTO som_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Markaasay baruurtii saareen sakaarradii, oo isna baruurtii buu ku dul gubay meeshii allabariga. ");
INSERT INTO som_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Kolkaasaa Haaruun Rabbiga hortiisa qurbaan la ruxruxo ugu ruxruxay sakaarradii iyo bowdadii midig, sidii Muuse amray. ");
INSERT INTO som_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Markaasaa Haaruun gacmihiisii ku soo taagay dadka xaggiisii, oo wuu u duceeyey iyagii; markaasuu ka soo degtay bixintii uu bixinayay qurbaankii dembiga, iyo qurbaankii la gubayay, iyo qurbaannadii nabaadiinada. ");
INSERT INTO som_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Markaasay Muuse iyo Haaruun teendhadii shirka galeen, oo haddana way ka soo bexeen oo dadkii u duceeyeen; kolkaasaa ammaantii Rabbigu dadkii oo dhan u muuqatay. ");
INSERT INTO som_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Oo Rabbiga hortiisa waxaa ka yimid dab, oo meesha allabariga dusheedii ayuu ku baabba'saday qurbaankii la gubayay iyo baruurtii, oo dadkii oo dhammuna markay taas arkeen ayay qayliyeen oo wejigooda u dheceen. ");
INSERT INTO som_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Oo Naadaab iyo Abiihuu oo ahaa wiilashii Haaruun ayaa midkood waluba qaatay idankiisii, oo dab bay ku rideen, fooxna way dul saareen, oo waxay Rabbiga hortiisa ku bixiyeen dab qalaad oo uusan ku amrin. ");
INSERT INTO som_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Oo dab baa Rabbiga hortiisa ka yimid, oo iyagii baabba'saday, oo Rabbiga hortiisa ayay ku dhinteen. ");
INSERT INTO som_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Markaasaa Muuse Haaruun ku yidhi, Tanu waa wixii Rabbigu ka hadlay, oo uu yidhi, Aniga waa in quduus laygaga dhex dhigaa kuwa ii soo dhowaada, oo waa in laygu ammaanaa dadka oo dhan hortiisa. Oo Haaruunna wuu iska aamusay. ");
INSERT INTO som_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Markaasaa Muuse u yeedhay Miishaa'eel iyo Elsaafaan, oo ahaa wiilashii Cusii'eel kaasoo ahaa Haaruun adeerkiis, oo wuxuu ku yidhi, Soo dhowaada, oo walaalihiin ka soo qaada meesha quduuska ah horteeda oo waxaad geeysaan xerada dibaddeeda. ");
INSERT INTO som_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Sidaas daraaddeed way u dhowaadeen, oo wayna qaadeen iyagoo jubbadahoodii gashan, waxayna geeyeen xerada dibaddeedii sidii Muuse yidhi. ");
INSERT INTO som_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Markaasaa Muuse ku yidhi Haaruun iyo wiilashiisii ahaa Elecaasaar iyo Iitaamaar, Timaha madaxiinnu yaanay arbushnaan, dharkiinnana ha dildillaacinina yeydnan dhimane, si aan Rabbigu ugu cadhoon ururka oo dhan, laakiinse walaalihiin ah reer binu Israa'iil oo dhammu ha ka ooyeen gubashadii Rabbigu huriyey. ");
INSERT INTO som_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Oo idinku waa inaydaan ka bixin iridda teendhada shirka yeydnan dhimane, waayo, waxaa korkiinna ku taal saliiddii subkidda oo Rabbiga, oo iyana waxay yeeleen si waafaqsan eraygii Muuse. ");
INSERT INTO som_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Markaasaa Rabbigu Haaruun la hadlay, oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","Ha cabbina khamri amase wax lagu sakhraamo, adiga iyo wiilashaada kula jira toona, markaad teendhada shirka gashaan yeydnan dhimane, oo taasu weligiin iyo ab ka ab qaynuun bay idiin ahaan doontaa, ");
INSERT INTO som_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","oo waa inaad kala dudaan waxa quduuska ah iyo waxa aan quduuska ahayn, iyo waxa nijaasta ah iyo waxa daahirka ah; ");
INSERT INTO som_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","iyo inaad reer binu Israa'iil bartaan kulli qaynuunnadii Rabbigu iyaga kula hadlay oo uu gacanta Muuse ugu soo dhiibay oo dhan. ");
INSERT INTO som_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Kolkaasaa Muuse la hadlay Haaruun, iyo wiilashiisii hadhay oo ahaa Elecaasaar iyo Iitaamaar, oo wuxuu ku yidhi, Qurbaanka hadhuudhka ah oo ka hadhay qurbaannadii Rabbiga dabka loogu sameeyey qaata oo isagoo aan khamiir lahayn ku cuna meesha allabariga dhinaceeda, waayo, kaasu waa kan ugu wada quduusan. ");
INSERT INTO som_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Oo waa inaad ku cuntaan meel quduus ah, maxaa yeelay, waa intii adiga iyo wiilashaadaba looga amray qurbaannada Rabbiga oo dabka lagu sameeyo, waayo, aniga sidaasaa laygu amray. ");
INSERT INTO som_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Oo sakaarka la ruxruxo iyo bowdada sare loo qaado waa inaad meel daahirsan ku cuntaan adiga iyo wiilashaada iyo gabdhahaaga kula jiraaba, waayo, kuwaasu waa intii adiga iyo wiilashaada looga amray allabaryada qurbaannada nabaadiinada ah oo reer binu Israa'iil ay bixiyaan. ");
INSERT INTO som_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Oo iyagu bowdada sare loo qaado iyo sakaarka la ruxruxo waa inay la keenaan qurbaannada xaydha oo dabka lagu sameeyo, in iyaga Rabbiga hortiisa lagu ruxruxo sidii qurbaanka la ruxruxo, oo markaasay ahaan doonaan inta weligiin laydiin amray adiga iyo wiilashaadaba, sidii Rabbigu amray. ");
INSERT INTO som_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Oo Muuse aad buu u doondoonay ridii ahayd qurbaanka dembiga, markaasuu ogaaday in la gubay, kolkaasuu ku xanaaqay Elecaasaar iyo Iitaamaar oo ahaa Haaruun wiilashiisii hadhay, oo wuxuu iyagii ku yidhi. ");
INSERT INTO som_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","War maxaad qurbaanka dembiga ugu cuni weydeen meesha quduuska ah gudaheeda, maxaa yeelay, kaasu waa kan ugu wada quduusan, oo isagu wuxuu kaas idiin siiyey inaad qaaddaan xumaantii ururka oo aad iyaga Rabbiga hortiisa kafaaraggud ugu samaysaan? ");
INSERT INTO som_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Bal eega, orgiga dhiiggiisii lama soo gelin meesha quduuska ah gudaheeda. Sida xaqiiqada ah waxaa idiin ekayd inaad meesha quduuska ah gudaheeda ku cuntaan, sidaan idinku amray. ");
INSERT INTO som_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Markaasaa Haaruun la hadlay Muuse, oo wuxuu ku yidhi, Bal eeg, maantadan ayay Rabbiga hortiisa ku bixiyeen qurbaankoodii dembiga iyo qurbaankoodii la gubayay, oo aniga waxaa igu dhacay wax sidan oo kale ah, oo maanta haddaan cuno qurbaankii dembiga, taasu Rabbiga hortiisa ma ku wanaagsanaan lahayd? ");
INSERT INTO som_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Muusena markuu taas maqlay raalli buu ka noqday. ");
INSERT INTO som_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Markaasaa Rabbigu la hadlay Muuse iyo Haaruun, oo wuxuu ku yidhi. ");
INSERT INTO som_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","Reer binu Israa'iil la hadla, oo waxaad ku tidhaahdaan, Kuwanu waa waxyaalaha noolnool oo aad ka cunaysaan xayawaanka dhulka jooga oo dhan, ");
INSERT INTO som_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Wax alla wixii xayawaan ah oo raafkoodu kala jeexan yahay, oo qanjaafilo leeyahay, oo calyanaqsiga raamsado waa inaad cuntaan. ");
INSERT INTO som_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Habase yeeshee, kuwan oo ka mid ah kuwa calyanaqsiga raamsado oo raafka jeexan leh waa inaydaan cunin, kuwaasoo ah geela, maxaa yeelay, calyanaqsiga wuu raamsadaa, laakiinse raafkiisu ma kala jeexna, haddaba isagu waa idinka nijaas. ");
INSERT INTO som_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Oo waladana ha cunina, maxaa yeelay, iyadu calyanaqsiga way raamsataa, laakiinse raafkeedu ma kala jeexna, haddaba iyadu waa idinka nijaas. ");
INSERT INTO som_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Oo bakaylahana ha cunina, maxaa yeelay, isagu calyanaqsiga wuu raamsadaa, laakiinse raafkiisu ma kala jeexna, haddaba isagu waa idinka nijaas. ");
INSERT INTO som_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Oo doofaarkana ha cunina, maxaa yeelay, isaga raafkiisu waa kala jeexan yahay, oo qanjaafiluu leeyahay, laakiinse calyanaqsiga ma raamsado, sidaas daraaddeed isagu waa idinka nijaas. ");
INSERT INTO som_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Haddaba kuwaas hilibkooda waa inaydaan cunin, oo baqtigoodana waa inaydaan taaban, maxaa yeelay, iyagu waa idinka nijaas. ");
INSERT INTO som_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Waxa biyaha ku dhex jira oo dhan kuwan ka cuna: wax alla wixii baalal iyo qolfo leh oo ku dhex jira biyaha iyo badaha iyo webiyada cuna. ");
INSERT INTO som_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Laakiinse wax alla wixii aan baalal iyo qolfo lahayn oo ku dhex jira badaha iyo webiyada, iyo waxa biyaha ku dhex dhaqdhaqaaqa oo dhan, iyo kulli waxyaalaha noolnool oo biyaha ku dhex jira oo dhammu waa idinka karaahiyo. ");
INSERT INTO som_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Haddaba iyagu waa inay karaahiyo idinka ahaadaan; idinku waa inaydaan hilibkooda cunin, oo baqtigoodana waa inuu karaahiyo idinka ahaadaa. ");
INSERT INTO som_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Wax alla wixii biyaha ku dhex jira oo aan lahayn baalal iyo qolfo waa idinka karaahiyo. ");
INSERT INTO som_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Oo haaddana waxaa idinka karaahiyo ah kuwan, oo iyaga waa inaan la cunin, waayo, iyagu waa karaahiyo, waana baqalyada, iyo babawga, iyo saratoosiyaha, ");
INSERT INTO som_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","iyo xuunshada, iyo shimbirlaayaha, iyo faragooysta caynkeeda, ");
INSERT INTO som_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","iyo cayn kasta oo tuke ah, ");
INSERT INTO som_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","iyo gorayada, iyo aboodiga, iyo shimbirbadeedda, iyo cayn kasta oo haadka adag, ");
INSERT INTO som_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","iyo guumaysta yar, iyo xeebajoogta iyo guumaysta weyn, ");
INSERT INTO som_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","iyo guumaysgeesaleyda, iyo cantalyaaga, iyo gorgorka, ");
INSERT INTO som_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","iyo xuurta, iyo haadbiyoodda iyo caynteeda, iyo ceelajoogjoogta, iyo fiidmeerta. ");
INSERT INTO som_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Oo wax baalal leh oo gurguurta oo afarta addinba ku socda dhammaantood waa idinka karaahiyo. ");
INSERT INTO som_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Laakiinse wax baalal leh oo gurguurta oo afarta addinba ku socda dhammaantood waxaad ka cuni kartaan kuwa addimmada ku leh cagahooda ka kor, oo dhulka ku kor boodbooda, ");
INSERT INTO som_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","iyaga waxaad ka cuntaan kuwa caynkan ah oo ah ayaxa iyo caynkiisa, iyo kabajaanka iyo caynkiisa, iyo jiriqsiga iyo caynkiisa, iyo koronkorrada iyo caynkeeda. ");
INSERT INTO som_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Laakiinse wax baalal leh oo gurguurta oo afarta cagood lahu, waa idinka karaahiyo. ");
INSERT INTO som_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Oo kuwaas idinku waad ku nijaasoobaysaan, oo ku alla kii baqtigooda taabtaa nijaas buu ahaanayaa tan iyo fiidkii, ");
INSERT INTO som_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","oo ku alla kii baqtigooda wax ka qaadaa waa inuu dharkiisa maydhaa, oo nijaas buu ahaanayaa tan iyo fiidkii. ");
INSERT INTO som_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Xayawaan kasta oo raafkiisu kala jeexan yahay, oo aan qanjaafilo lahayn ama aan calyanaqsiga raamsan waa idinka nijaas, oo ku alla kii iyaga taabtaana wuu nijaasoobayaa. ");
INSERT INTO som_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Oo xayawaanka afarta addinba ku socda, wax alla wixii baabacooyinka ku socdaa waa idinka nijaas, oo ku alla kii baqtigooda taabtaa nijaas buu ahaanayaa tan iyo fiidkii. ");
INSERT INTO som_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Oo kii baqtigooda qaadaana waa inuu dharkiisa maydhaa, oo tan iyo fiidkiina nijaas buu ahaanayaa, waayo, iyagu waa idinka nijaas. ");
INSERT INTO som_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Oo waxa dhulka ku gurguurta oo dhan kuwanu waa kuwa idinka nijaas ah, waana fadhanfadhka, iyo jiirka, iyo amuurka iyo caynkiisa oo dhan, ");
INSERT INTO som_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","iyo ilweynta iyo maansalugaleyda, iyo qorratada, iyo mulaca, iyo jirjirroolaha. ");
INSERT INTO som_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Oo waxa gurguurta oo dhan kuwaasu waa kuwa idinka nijaas ah, oo ku alla kii taabtaa markay dhintaan nijaas buu ahaan doonaa tan iyo fiidkii. ");
INSERT INTO som_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Oo wax alla wixii ay ku dhacaan markay dhintaan, nijaas bay ahaan doonaan, hadday yihiin weel qori ah, ama dhar, ama harag, ama joonyad, weelkaasu wax kasta ha ahaadee haddii wax loogu isticmaalo waa in biyo la dhex geliyaa, oo tan iyo fiidkiina nijaas buu ahaanayaa, oo markaas dabadeedna daahir buu ahaanayaa. ");
INSERT INTO som_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Oo weelkii dhoobo ah oo mid iyaga ka mid ahu gudihiisa ku dhaco, wax alla wixii weelkaas gudihiisa ku jiraaba way nijaasoobi doonaan, oo weelkiina waa inaad jebisaan. ");
INSERT INTO som_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Oo waxa la cuno oo ku jira oo biyo gaadhaanba way nijaasoobi doonaan, oo weelka caynkaas ah waxa la cabbo oo ku jira oo dhammuna way nijaasoobi doonaan. ");
INSERT INTO som_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Oo wax alla wixii wax baqtigooda ahu ku dhacaanba way nijaasoobi doonaan, hadday yihiin foorno ama sholad, waa in la burburiyaa, waayo, iyagu waa nijaas, waana inay nijaas idinka ahaadaan. ");
INSERT INTO som_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Habase yeeshee il amase god ay biyo badanu ku jiraan daahir bay ahaanayaan, laakiinse wixii baqtigooda taabtaa way nijaasoobayaan. ");
INSERT INTO som_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Oo wax baqtigooda ahu hadday ku dhacaan abuur la abuurayo, kaasu waa daahir. ");
INSERT INTO som_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Laakiinse abuurka haddii biyo lagu shubo oo wax baqtigooda ahu ay ku dhacaan markaas waa idinka nijaas. ");
INSERT INTO som_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Oo xayawaanka aad cuni kartaan midkood hadduu dhinto, kii baqtigiisa taabtaa nijaas buu ahaanayaa tan iyo fiidkii. ");
INSERT INTO som_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Oo neefkaas baqtigiisa qofkii cunaana waa inuu dharkiisa maydhaa, oo isna nijaas buu ahaanayaa tan iyo fiidkii, oo kii neefka baqtigiisa qaadaana waa inuu dharkiisa maydhaa, oo isna nijaas buu ahaanayaa tan iyo fiidkii. ");
INSERT INTO som_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Oo wax kasta oo dhulka ku gurguurtaaba waa karaahiyo, oo waa inaan la cunin. ");
INSERT INTO som_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Wax alla wixii bogga ku socda, iyo wax alla wixii afar addin ku socda, amase wax alla wixii addimmo badan leh, kuwaas oo ah waxyaalaha dhulka ku gurguurta oo dhan, waa inaydaan cunin, waayo, iyagu waa karaahiyo. ");
INSERT INTO som_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Idinku waa inaydaan karaahiyo iskaga dhigin waxa dhulka ku gurguurta oo dhan, oo waa inaydaan iyaga isku nijaasayn si aydaan iyaga ugu nijaasoobin. ");
INSERT INTO som_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Waayo, anigu waxaan ahay Rabbiga Ilaahiinna ah, haddaba isdaahiriya oo quduus ahaada, maxaa yeelay, anigu quduus baan ahay. Oo waa inaydaan isku nijaasayn cayn kasta oo ah waxa gurguurta oo dhulka ku kor dhaqdhaqaaqa. ");
INSERT INTO som_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Waayo, anigu waxaan ahay Rabbigii dalkii Masar idinka soo bixiyey inuu Ilaah idiin ahaado, haddaba sidaas daraaddeed waa inaad quduus ahaataan, waayo, anba quduus baan ahay. ");
INSERT INTO som_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Haddaba intaasu waa sharciga ku saabsan xayawaanka, iyo haadda, iyo wax kasta oo nool oo biyaha ku dhex dhaqdhaqaaqa, iyo wax kasta oo dhulka ku gurguurta; ");
INSERT INTO som_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","si loo kala duwo waxa nijaasta ah iyo waxa daahirka ah, iyo waxa nool oo la cuni karo iyo waxa nool ee aan la cuni karin. ");
INSERT INTO som_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Markaasaa Rabbigu Muuse la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Reer binu Israa'iil la hadal oo waxaad ku tidhaahdaa, Haddii naagu ilmo uuraysato oo ay wiil dhasho, markaas intii toddoba maalmood ah waa inay nijaas ahaataa, oo waxay u nijaasoobaysaa siday nijaasta u ahayd maalmihii dhiiggeeda. ");
INSERT INTO som_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Oo maalinta siddeedaadna wiilka buuryadiisa ha la gudo. ");
INSERT INTO som_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Oo iyadu waa inay ku sii jirtaa dhiigga isdaahirinteeda saddex iyo soddon maalmood oo kale, oo waa inayan taaban wax quduus ah, waana inayan meesha quduuska ah gelin ilamaa maalmaha isdaahirinteedu ay dhammaystirmaan. ");
INSERT INTO som_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Laakiinse hadday gabadh dhasho, markaas intii laba toddobaad ah waa inay nijaas ahaataa sidii markay xagga dhiigga nijaas ka tahay, oo waa inay ku sii jirtaa dhiigga isdaahirinteeda lix iyo lixdan maalmood oo kale. ");
INSERT INTO som_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Oo markii maalmaha isdaahirinteedu ay dhammaystirmaan wiilkeeda aawadiis ama gabadheeda aawadeed waa inay keentaa wan gu jira oo qurbaan la gubo aawadiis loo bixiyo, iyo xamaam yar ama qoolley oo qurbaan dembi aawadiis loo bixiyo oo waa inay wadaadka ugu keentaa teendhada shirka iriddeeda. ");
INSERT INTO som_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Oo isna qurbaankaas waa inuu ku bixiyaa Rabbiga hortiisa, oo waa inuu iyada kafaaraggud u sameeyaa, oo iyana dhiigbixiddeeda way ka daahirsanaan doontaa. Kanu waa sharciga ku saabsan tii dhasha ama wiil ha ahaado ama gabadhe. ");
INSERT INTO som_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Oo haddii lacagteedu ayan wan ugu filnaynna waa inay keentaa laba qoolley ama laba xamaam oo yaryar, oo midkood waa in loo bixiyaa qurbaan la gubo aawadiis, kan kalena waa in loo bixiyaa qurbaan dembi aawadiis, oo wadaadkuna waa inuu iyada kafaaraggud u sameeyaa, oo iyana daahir bay ahaan doontaa. ");
INSERT INTO som_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Markaasaa Rabbigu la hadlay Muuse iyo Haaruun oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Haddii qof jidhkiisa lagu arko barar, ama qolof, ama bar dhalaalaysa, oo ay jidhkiisa ku noqoto cudurkii baraska, markaas waa in loo keenaa wadaadka Haaruun ah, amase wiilashiisa wadaaddada ah midkood, ");
INSERT INTO som_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","oo wadaadku waa inuu fiiriyaa cudurka jidhka ku yaal, oo haddii meesha cudurka leh timaheedu ay caddaadeen, oo cudurka muuqashadiisu ay dubka sare hoos u sii dhaafsiisan tahay, markaas waa cudurkii baraska, oo wadaadku waa inuu fiiriyaa oo yidhaahdaa, Ninkanu waa nijaasaysan yahay. ");
INSERT INTO som_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Laakiinse haddii barta dhalaalaysaa ay jidhka sare ka cad dahay, oo muuqashadeeduna ayan dubka sare hoos u sii dhaafsiisnayn, oo meeshaas timaheeduna ayan caddaan, markaas waa in wadaadku qofkaas cudurka qaba karantiilaa intii toddoba maalmood ah. ");
INSERT INTO som_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Oo haddana wadaadku maalinta toddobaad waa inuu isaga fiiriyaa, oo bal eeg, hadduu indhihiisa ku arko in cudurku joogsaday oo uusan dubka sare ku sii faafin, markaas waa in wadaadku qofkaas sii karantiilaa toddoba maalmood oo kale. ");
INSERT INTO som_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Oo haddana maalinta toddobaad waa in wadaadku fiiriyaa, oo bal eeg, haddii cudurkii yaraaday oo uusan dubka sare ku sii faafin, markaas wadaadku ha yidhaahdo, Ninkanu waa daahir, oo meeshu waa qolof keliya, oo isna dharkiisa ha maydho oo daahir ha ahaado. ");
INSERT INTO som_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Laakiinse qoloftu hadday jidhka ku sii faafto markii u daahirintiisa aawadeed wadaadka isu tuso dabadeed, waa inuu wadaadka mar kale istusaa. ");
INSERT INTO som_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Oo wadaadku waa inuu fiiriyaa, oo bal eeg, haddii qoloftu ay jidhka ku faafto, markaas wadaadku waa inuu yidhaahdaa, Ninkanu waa nijaasaysan yahay, waayo, kaasu waa baras. ");
INSERT INTO som_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Oo haddii nin cudurka baraska qabo waa in wadaadka loo keenaa, ");
INSERT INTO som_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","oo wadaadku waa inuu fiiriyaa, oo bal eeg, haddii dubka sare barar cadu ku yaal, oo meeshaas timaheeduna ay caddaadeen, oo bararkana haddii boog xun ku dhex taal, ");
INSERT INTO som_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","kaasu waa baras gaboobay oo dubka jidhka ku dhex jira, oo wadaadku kaas waa inuu yidhaahdaa, Ninkanu waa nijaasaysan yahay, oo isaga waa inuusan karantiilin, waayo, isagu waa nijaas. ");
INSERT INTO som_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Oo haddii barasku dubka ku faafo, oo uu barasku kan cudurka qaba dubkiisa oo dhan qariyo tan iyo madaxiisa iyo ilaa cagihiisa, in alla intii wadaadka u muuqata, ");
INSERT INTO som_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","markaas wadaadku waa inuu qofkaas fiiriyaa, oo bal eeg, haddii barasku jidhkiisa oo dhan ku faafay, markaas isagu kan cudurka qaba waa inuu ku yidhaahdaa, Ninkanu waa daahir, waayo, isagu wuu wada caddaaday oo waa daahir. ");
INSERT INTO som_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Laakiinse mar alla markii boog xumu isaga ka muuqdo, waa inuu nijaas ahaadaa. ");
INSERT INTO som_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Oo wadaadku waa inuu boogtii xumayd fiiriyaa oo waa inuu yidhaahdaa, Ninkanu waa nijaasaysan yahay, waayo, boogta xumu waa nijaas oo waa baras. ");
INSERT INTO som_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Oo boogta xumu hadday mar kale beddelanto oo caddaato, markaas isagu waa inuu wadaadka u yimaadaa, ");
INSERT INTO som_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","oo wadaadkuna waa inuu fiiriyaa, oo bal eeg, haddii cudurkii caddaaday, markaas wadaadku kan cudurka qabi jiray ha ku yidhaahdo, Waa daahir, isagu waa daahir. ");
INSERT INTO som_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Oo haddii jidhku kasoobax ku leeyahay dubka sare oo uu bogsaday, ");
INSERT INTO som_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","oo kasoobaxa meeshuu ku yaal haddii lagu arko barar cad ama bar dhalaalaysa oo ah guduud caddaan ku jiro, markaas waa in wadaadka la tusaa. ");
INSERT INTO som_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Oo wadaadku waa inuu fiiriyaa, oo bal eeg, haddii muuqashadeedu hoos u sii dhaafsiisan tahay dubka sare oo meeshaas timaheeduna ay caddaadeen, markaas wadaadku waa inuu yidhaahdaa, Ninkanu waa nijaasaysan yahay, waayo, taasu waa cudurkii baraska oo soo baxay. ");
INSERT INTO som_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Laakiinse haddii wadaadku fiiriyo, oo meeshaas timo cad laga waayo, oo nabarkuna uusan dubka sare hoos u sii dhaafsiisnayn, illowse uu sii yaraaday, markaas waa in wadaadku karantiilaa intii toddoba maalmood ah, ");
INSERT INTO som_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","oo haddii cudurku dubka sare ku sii faafo, markaas wadaadku ha yidhaahdo, Ninkanu waa nijaasaysan yahay, waayo, kaasu waa cudur. ");
INSERT INTO som_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Laakiinse bartii dhalaalaysay hadday meesheedii ku joogsatay oo ayan sii faafin, markaas waa astaantii kasoobaxii ka hadhay, oo wadaadku waa inuu yidhaahdaa, Ninkanu waa daahir. ");
INSERT INTO som_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Amase haddii dubka jidhku dab ku gubto oo jidhkii gubtay uu noqdo bar dhalaalaysa oo ah guduud caddaan ku jiro, amase caddaan, ");
INSERT INTO som_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","markaas wadaadku waa inuu meeshaas fiiriyaa, oo bal eeg, barta dhalaalaysa timaheedu hadday caddaadeen oo nabarka muuqashadiisuna ay dubka sare hoos u sii dhaafsiisan tahay, waa baras kaasu, oo wuxuu ka soo dhex baxay meeshii gubatay, oo wadaadku waa inuu yidhaahdaa, Ninkanu waa nijaasaysan yahay, waayo, kaasu waa cudurkii baraska. ");
INSERT INTO som_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Laakiinse haddii wadaadku fiiriyo, oo barta dhalaalaysa laga waayo timo cad, oo nabarkuna uusan dubka sare hoos u sii dhaafsiisnayn laakiinse uu yaraaday, markaas wadaadku waa inuu qofkaas karantiilaa intii toddoba maalmood ah. ");
INSERT INTO som_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Oo maalinta toddobaad waa in wadaadku qofkaas fiiriyaa, oo haddii nabarku dubka sare ku faafay, markaas wadaadku waa inuu yidhaahdaa, Ninkanu waa nijaasaysan yahay, waayo, kaasu waa cudurkii baraska. ");
INSERT INTO som_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Laakiinse bartii dhalaalaysay hadday meesheedii ku joogsatay, oo ayan dubka sare ku sii faafin, illowse ay yaraatay, markaas waa bararkii meeshii gubatay, oo wadaadku waa inuu yidhaahdaa, Ninkanu waa daahir, waayo, taasu waa astaantii gubashada. ");
INSERT INTO som_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Haddii nin ama naagu ay cudur ku yeeshaan madaxa amase gadhka, ");
INSERT INTO som_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","markaas wadaadku waa inuu cudurka fiiriyaa, oo bal eeg, haddii cudurka muuqashadiisu ay dubka sare hoos u sii dhaafsiisan tahay, oo meeshaasna ay ku yaalliin timo casuur ah oo khafiif ah, markaas wadaadku waa inuu yidhaahdaa, Ninkanu waa nijaasaysan yahay, waayo, taasu waa cambaar oo waa baraskii madaxa iyo gadhka. ");
INSERT INTO som_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Oo wadaadku hadduu fiiriyo cudurka cambaarta ah, oo bal eeg, haddii muuqashadeedu ayan dubka sare hoos u sii dhaafsiisnayn, oo aan timo madoobu meeshaas ku oollin, markaas wadaadku waa inuu karantiilaa kan cudurka cambaarta ah qaba intii toddoba maalmood ah. ");
INSERT INTO som_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Oo maalinta toddobaad wadaadku waa inuu cudurka fiiriyaa, oo bal eeg, haddii cambaartii ayan sii faafin, oo aan lagu arag timo casuur ah, oo cambaarta muuqashadeedu ayan dubka sare ka sii dhaafsiisnayn, ");
INSERT INTO som_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","markaas isagu waa inuu xiirto, laakiinse meesha cambaarta leh yuusan xiirin, oo wadaadku waa inuu qofkaas karantiilaa toddoba maalmood oo kale. ");
INSERT INTO som_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Oo haddana maalinta toddobaad wadaadku waa inuu cambaartii fiiriyaa, oo bal eeg, cambaartu haddii ayan dubka sare ku sii faafin, oo muuqashadeeduna ayan dubka sare hoos u sii dhaafsiisnayn, markaas wadaadku waa inuu yidhaahdaa, Ninkanu waa daahir, oo isna waa inuu dharkiisa maydhaa oo uu daahir ahaadaa. ");
INSERT INTO som_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Laakiinse cambaartii haddii ay dubka sare ku sii faafto daahirintiisa dabadeed, ");
INSERT INTO som_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","markaas wadaadku waa inuu fiiriyaa, oo bal eeg, haddii cambaartu ay dubka sare ku sii faaftay wadaadku yuusan sii doondoonin timo casuur ah, waayo, ninkanu waa nijaasaysan yahay. ");
INSERT INTO som_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Laakiinse cambaartu hadday indhihiisa la ahaato inay joogsatay oo timo madoobuna ay ka bexeen, markaas cambaartu waa bogsatay, oo ninkaasuna waa daahir, oo wadaadkuna waa inuu yidhaahdaa, Ninkanu waa daahir. ");
INSERT INTO som_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Oo haddii nin ama naagu ay dubka jidhkooda ku yeeshaan baro dhaldhalaalaya, oo ah baro cadcad oo dhaldhalaalaya, ");
INSERT INTO som_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","markaas wadaadku waa inuu fiiriyaa, oo bal eeg, haddii baraha dhaldhalaalaya oo dubka jidhkooda ku yaallaa ay yihiin caddaan khafiif ah, taasu waa xaajiin jidhka ka soo baxday, oo qofkaasu waa daahir. ");
INSERT INTO som_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Oo haddii nin madaxiisa ay timahu ka dhammaadaan, isagu wuxuu leeyahay bidaar, hase ahaatee waa daahir. ");
INSERT INTO som_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Oo haddii timihiisu ay foodda hore ka dhammaadaanna, isagu foodda horuu bidaar ku leeyahay, hase ahaatee waa daahir. ");
INSERT INTO som_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Laakiinse madaxa bidaarta leh ama foodda bidaarta leh haddii lagu arko cudur guduudan oo caddaan ku jiro, markaas waa baras ka soo baxay madaxiisii bidaarta lahaa ama fooddiisii bidaarta lahayd. ");
INSERT INTO som_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Markaas wadaadku waa inuu fiiriyaa, oo bal eeg, cudurka bararkiisu hadduu yahay mid guduudan oo caddaan ku jiro, oo ku yaal madaxiisa bidaarta leh, ama fooddiisa bidaarta leh, sidii ay tahay muuqashada baraska oo dubka jidhkiisa ku taal, ");
INSERT INTO som_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","isagu waa nin baras qaba, oo waa nijaasaysan yahay, oo sida xaqiiqada ah wadaadku waa inuu yidhaahdaa, Ninkanu waa nijaasaysan yahay; oo cudur buu madaxa ka qabaa. ");
INSERT INTO som_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Oo qofkii cudurka baraska qaba dharkiisu wax jeexjeexan ha ahaadeen, oo timaha madaxiisuna ha bannaanaadeen, oo bushintiisa sarena ha daboolo, oo ha ku qayliyo, Waan nijaasaysnahay, waan nijaasaysnahay! ");
INSERT INTO som_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Oo in alla intuu cudurkaas qabo oo dhan isagu waa inuu nijaasaysnaadaa, waayo, isagu waa nijaasaysan yahay, oo waa inuu keligiis meel ku hoydaa, oo hoygiisuna waa inuu ahaadaa xerada dibaddeeda. ");
INSERT INTO som_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Oo dharkii uu cudurka barasku ku yaal, hadduu yahay dhar dhogor idaad ah amase dhar wanaagsan oo linen ah, ");
INSERT INTO som_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","hadduu ku jiro dunta fidsan amase tan gudubsan ee dharka wanaagsan oo linenka ah, ama kan dhogorta idaad ah, iyo hadduu ku jiro haragga ama wax alla wixii harag laga sameeyo, ");
INSERT INTO som_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","haddii cudurku ka cagaaran yahay ama ka guduudan yahay dharka ama haragga ama dunta fidsan ama tan gudubsan ama waxa alla wixii harag laga sameeyo, kaasu waa cudurkii baraska oo waa in wadaadka la tusaa. ");
INSERT INTO som_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Oo wadaadkuna waa inuu fiiriyaa cudurkaas, oo waxaas cudurka qabana waa inuu meel ku xereeyaa intii toddoba maalmood ah. ");
INSERT INTO som_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Oo haddana maalinta toddobaad waa inuu cudurka fiiriyaa, oo haddii cudurku dharka kaga sii faafay dunta fidsan ama tan gudubsan, ama haragga dhexdiisa, haraggaas hawl kasta oo loogu isticmaalaba, markaas cudurku waa baras wax xaganaya oo waxaasu waa nijaasaysan yahay. ");
INSERT INTO som_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Oo isna waa inuu gubaa dharkaas cudurku ku jiro, hadduu yahay dunta fidsan ama tan gudubsan oo ku jirta dharka dhogorta idaad ah ama kan wanaagsan oo linenka ah, ama wax kasta oo harag laga sameeyey, waayo, kaasu waa baras wax xaganaya, ee waa in dab lagu gubaa. ");
INSERT INTO som_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Oo haddii wadaadku fiiriyo, oo markaa cudurkii uusan dharka kaga sii faafin dunta fidsan ama tan gudubsan toona, ama wax harag laga sameeyey, ");
INSERT INTO som_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","markaas wadaadku waa inuu ku amraa in la maydhaa waxaas cudurka qaba, oo isagu haddana waa inuu waxaas meel ku xereeyaa intii toddoba maalmood oo kale ah. ");
INSERT INTO som_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Oo wadaadku waa inuu fiiriyaa, markii cudurka laga maydho dabadeed, oo bal eeg, cudurka midabkiisu hadduusan beddelmin, iyo haddii cudurku uusan faafinba, waxaasu waa nijaas, oo waa inaad dab ku gubtaa, oo haddii meeshii xumayd kaga taal hoosta ama dushaba, taasu waa wax xaganaya. ");
INSERT INTO som_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Oo haddii wadaadku fiiriyo, oo bal eeg, cudurku hadduu yaraaday markii la maydhay dabadeed, markaas isagu waa inuu intaas ka dillaaciyaa dharka ama haragga ama dunta fidsan ama tan gudubsan. ");
INSERT INTO som_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Oo haddii cudurkii weli dharkii kaga sii muuqdo dunta fidsan ama tan gudubsan ama wax kasta oo harag laga sameeyey markaas waa inaad dab ku gubtaa waxa cudurku ku yaal, maxaa yeelay, cudurku waa soo faafayaa. ");
INSERT INTO som_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Oo dharkii ha ahaado dunta fidsan ama tan gudubsan ama wax alla wixii harag laga sameeyey oo aad maydho, haddii cudurku iyaga ka baxo, haddana waa in mar labaad la maydhaa, oo kolkaasay daahir ahaan doonaan. ");
INSERT INTO som_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Kanu waa sharciga ku saabsan cudurka baraska ahu markuu dharka dhogorta idaad ah ama dharka wanaagsan oo linenka ah kaga dhaco dunta fidsan ama tan gudubsan, ama waxa kasta oo harag laga sameeyo, in la yidhaahdo, Waxaasu waa daahir, ama in la yidhaahdo, Waa nijaas. ");
INSERT INTO som_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Markaasaa Rabbigu Muuse la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","Kanu waa inuu ahaadaa sharciga ku saabsan qofkii baras qaba maalinta la daahirinayo: Waa in isaga wadaadka loo keenaa. ");
INSERT INTO som_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Oo wadaadku waa inuu xerada dibadda uga baxaa, oo waa inuu qofkaa fiiriyaa, oo bal eeg, cudurkii barasku hadduu ka bogsaday qofkii baraska qabay, ");
INSERT INTO som_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","markaas wadaadku waa inuu amraa in kan la daahirinayo aawadiis loo keeno laba shimbirrood oo noolnool oo daahir ah, iyo qori kedar ah, iyo wax casaan ah, iyo geed husob la yidhaahdo. ");
INSERT INTO som_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Oo wadaadku waa inuu amraa in shimbirraha middood lagu dhex gowraco weel dhoobo ah oo biyo socda korkooda ah. ");
INSERT INTO som_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Oo shimbirta nool iyo qoriga kedarka ah, iyo waxa casaanta ah iyo geedka husobka ahba waa inuu soo qaadaa oo iyaga iyo shimbirta noolba waa inuu dhex geliyaa dhiigga shimbirtii biyaha socda lagu kor gowracay. ");
INSERT INTO som_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Oo wadaadkuna kan baraska laga daahirinayo toddoba jeer waa inuu dhiigga ku saydhaa oo waa inuu yidhaahdaa, Kanu waa daahir. Oo shimbirta noolna berrin bannaan ha ku sii daayo. ");
INSERT INTO som_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Oo kan la daahirinayaana waa inuu dharkiisa maydhaa oo timihiisa oo dhanna iska xiiraa, oo isna biyo ku maydhaa, kolkaasuu daahir noqon doonaaye, oo markaas dabadeedna waa inuu xerada soo galaa, laakiinse intii toddoba maalmood ah waa inuu teendhadiisa dibaddeeda ku hoydaa. ");
INSERT INTO som_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Oo maalinta toddobaad waa inuu timaha ka wada xiiraa madaxa iyo gadhka iyo suunniyadaba. Xataa timihiisa oo dhan waa inuu iska wada xiiraa, oo waa inuu dharkiisana maydhaa, jidhkiisana biyo ku maydhaa, kolkaasuu daahir noqon doonaaye. ");
INSERT INTO som_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Oo maalinta siddeedaadna isagu waa inuu keenaa laba wan oo yaryar oo aan innaba iin lahayn, iyo nayl gu jira oo aan iin lahayn, iyo eefaah toban meelood loo dhigay saddexdiis meelood oo bur ah oo saliid lagu daray, kaasoo ah qurbaan hadhuudh, iyo qiyaas log la yidhaahdo oo saliid ah. ");
INSERT INTO som_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Oo wadaadka isaga daahirinayaa waa inuu kan la daahirinayo iyo alaabtiiba keenaa Rabbiga hortiisa, meel iridda teendhada shirka agteeda ah. ");
INSERT INTO som_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Oo wadaadku waa inuu soo qaadaa wananka midkood oo waa inuu u bixiyaa qurbaan xadgudub aawadiis, oo weliba waa inuu logga saliidda ah qaadaa oo uu iyaga Rabbiga hortiisa ugu ruxruxaa qurbaan la ruxruxo. ");
INSERT INTO som_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Oo wanka waa inuu ku gowracaa meesha lagu gowraco qurbaanka dembiga iyo qurbaanka la gubo oo ku dhex taal meesha quduuska ah, waayo, sida qurbaanka dembigu uu kii wadaadka u yahay ayaa qurbaanka xadgudubkuna kiisii u yahay. Waa kan ugu quduusan. ");
INSERT INTO som_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Oo wadaadku waa inuu qaadaa dhiigga qurbaanka xadgudubka qaarkiis, oo waa inuu dhiigga taabsiiyaa kan la daahirinayo caaradda dhegtiisa midig, iyo suulka gacantiisa midig, iyo suulka cagtiisa midigba. ");
INSERT INTO som_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Oo wadaadku waa inuu qaadaa loggii saliidda ahaa qaarkiis oo waa inuu calaacasha gacantiisa bidix ku shubaa. ");
INSERT INTO som_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Oo wadaadku waa inuu fartiisa midig daraa saliidda ku jirta calaacashiisa bidix, oo waa inuu toddoba jeer saliidda fartiisa kula saydhaa Rabbiga hortiisa. ");
INSERT INTO som_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Oo saliidda inteeda kale oo gacantiisa ku hadhayna waa in wadaadku taabsiiyaa kan la daahirinayo caaradda dhegtiisa midig, iyo suulka gacantiisa midig, iyo suulka cagtiisa midig, oo ha ka kor mariyo dhiiggii qurbaanka xadgudubka. ");
INSERT INTO som_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Oo saliidda inteeda kale oo ku jirta wadaadka calaacashiisana waa inuu taabsiiyaa kan la daahirinayo madaxiisa, oo wadaadku waa inuu isaga Rabbiga hortiisa kafaaraggud ugu sameeyaa. ");
INSERT INTO som_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Oo wadaadku waa inuu bixiyaa qurbaanka dembiga, oo waa inuu nejisnimadiisii daraaddeed kan la daahirinayo aawadiis kafaaraggud u sameeyaa, oo dabadeedna waa inuu gowracaa neefkii ahaa qurbaanka la gubo, ");
INSERT INTO som_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","oo wadaadku waa inuu meesha allabariga ku dul bixiyaa qurbaanka la gubo iyo qurbaanka hadhuudhka, oo wadaadku waa inuu isaga kafaaraggud u sameeyaa, oo isna daahir buu ahaan doonaa. ");
INSERT INTO som_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Laakiinse isagu hadduu miskiin yahay oo uusan intaas oo dhan wada heli karin, markaas waa inuu keenaa wan yar oo qurbaankii xadgudubka aawadiis loo ruxruxo si uu kafaaraggud ugu sameeyo, iyo eefaah toban meelood loo dhigay meeshiis oo bur ah oo saliid lagu daray oo qurbaan hadhuudh ah loo bixiyo, iyo log saliid ah, ");
INSERT INTO som_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","iyo laba qoolley ama laba xamaam oo yaryar, kuwaas oo ah wax uu heli karo, oo middood waa inay ahaato qurbaan dembi, midda kalena qurbaan la gubo. ");
INSERT INTO som_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Oo waa inuu maalinta siddeedaad daahirintiisa aawadeed wadaadka ugu keenaa iridda teendhada shirka agteeda oo Rabbiga hortiisa ah. ");
INSERT INTO som_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Oo wadaadku markaas waa inuu soo qaadaa wanka qurbaanka xadgudubka ah, iyo logga saliidda ah, oo wadaadku waa inuu iyaga Rabbiga hortiisa ugu ruxruxaa qurbaan la ruxruxo. ");
INSERT INTO som_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Oo waa inuu gowracaa wanka qurbaanka xadgudubka ah, oo wadaadku waa inuu dhiigga qurbaanka xadgudubka qaarkiis soo qaadaa, oo taabsiiyaa kan la daahirinayo caaradda dhegtiisa midig, iyo suulka gacantiisa midig, iyo suulka cagtiisa midigba. ");
INSERT INTO som_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Oo waa in wadaadku saliidda ku shubaa calaacasha gacantiisa bidix. ");
INSERT INTO som_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Oo waa inuu saliidda calaacashiisa bidix ku jirta qaarkeed toddoba jeer fartiisa midig kula saydhaa Rabbiga hortiisa. ");
INSERT INTO som_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Oo waa in wadaadku saliidda calaacashiisa ku jirta qaarkeed taabsiiyaa kan la daahirinayo caaradda dhegtiisa midig, iyo suulka gacantiisa midig, iyo suulka cagtiisa midig, oo ha ka kor mariyo meeshii uu ku yiil dhiiggii qurbaanka xadgudubku. ");
INSERT INTO som_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Oo saliidda wadaadka gacantiisa ku jirta inteeda kalena waa inuu mariyaa kan la daahirinayo madaxiisa, si uu isaga kafaaraggud ugu sameeyo Rabbiga hortiisa. ");
INSERT INTO som_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Oo markaas waa inuu bixiyaa mid ka mid ah qoolleyaha ama xamaamka yaryar, kuwaas oo ah wax uu heli karo. ");
INSERT INTO som_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Oo xataa waxaas uu heli karo middood ha u bixiyo qurbaan dembi, midda kalena qurbaan la gubo, oo qurbaankii hadhuudhka la socda, oo wadaadku waa inuu kan la daahirinayo kafaaraggud ugu sameeyaa Rabbiga hortiisa. ");
INSERT INTO som_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Kaasu waa sharciga ku saabsan qofkii cudurka baraska ah qaba, oo aan awoodin inuu keeno wixii daahirintiisa waajibka ku ahaa. ");
INSERT INTO som_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Markaasaa Rabbigu la hadlay Muuse iyo Haaruun oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","Idinku markaad gashaan dalka reer Kancaan oo aan hantida idiin siinayo, haddaan cudurka baraska ah ku rido guri ku yaal dalka hantidiinna ah, ");
INSERT INTO som_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","markaas qofka guriga lahu waa inuu wadaadka u yimaadaa oo u sheegaa isagoo leh, Waxay ila tahay in cuduru guriga ku jiro. ");
INSERT INTO som_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Oo wadaadku waa inuu amraa in guriga mid madhan laga dhigo, intaan wadaadku soo gelin markuu cudurka fiirinayo, si aan waxa guriga ku jira oo dhan nijaas looga dhigin, oo dabadeedna wadaadku waa inuu galaa si uu guriga u fiiriyo. ");
INSERT INTO som_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Oo waa inuu cudurka fiiriyaa, oo bal eeg, cudurku hadduu ku yaal guriga derbiyadiisa oo ay leeyihiin meelo godgodan oo ah cagaar iyo guduud, iyo haddii muuqashadiisu ay derbiga sare hoos u sii dhaafsiisan tahay, ");
INSERT INTO som_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","markaas waa in wadaadku gurigaas ka baxo oo albaabka istaagaa, oo waa inuu gurigaas intii toddoba maalmood ah xidhaa. ");
INSERT INTO som_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Oo haddana maalinta toddobaad waa in wadaadku soo noqdaa oo fiiriyaa, oo bal eeg, haddii cudurku ku sii faafay guriga derbiyadiisa, ");
INSERT INTO som_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","markaas wadaadku waa inuu amraa in guriga laga bixiyo dhagaxyada cudurka qaba, oo lagu xooraa meel nijaas ah oo magaalada dibaddeeda ah. ");
INSERT INTO som_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Oo markaas waa inuu ka dhigaa in guriga gudihiisa oo dhan la wada xoqo, oo malaasta guriga laga xoqayna waa in lagu soo daadiyaa meel nijaas ah oo magaalada dibaddeeda ah. ");
INSERT INTO som_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Oo waa in dhagaxyo kale la soo qaadaa, oo la geliyaa meeshii ay dhagaxyadaas laga bixiyey, oo malaas kale waa inuu keenaa oo guriga ku malaasaa. ");
INSERT INTO som_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Oo haddii cudurku mar kale guriga ku soo noqdo oo uu ka soo dhex baxo, markii dhagaxyada laga bixiyey oo guriga oo dhan la xoqay oo la malaasay dabadeed, ");
INSERT INTO som_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","markaas wadaadku waa inuu soo galaa, oo fiiriyaa, oo bal eeg, cudurku hadduu guriga ku faafay, waa baras wax xagta oo guriga ku jira, oo markaas gurigu waa nijaasaysan yahay. ");
INSERT INTO som_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Oo isagu waa inuu guriga dumiyaa kulli dhagxantiisa, iyo alwaaxdiisa, iyo malaastiisa oo dhanba, oo waa inuu magaalada dibaddeeda u bixiyaa, oo meel nijaas ah ku daadiyaa. ");
INSERT INTO som_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Oo weliba gurigu intuu xidhan yahay oo dhan ku alla kii galaaba, nijaas buu ahaan doonaa tan iyo fiidkii. ");
INSERT INTO som_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Oo qofkii guriga seexdaaba waa inuu dharkiisa maydhaa, oo kii guriga wax ku cunaana waa inuu dharkiisa maydhaa. ");
INSERT INTO som_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Oo haddii wadaadku guriga soo galo, oo uu fiiriyo, oo uu arko inaan cudurkii guriga ku dhex faafin markii guriga la malaasay dabadeed, markaas wadaadku waa inuu yidhaahdaa, Gurigu waa daahir, maxaa yeelay, cudurkii wuu ka bogsaday. ");
INSERT INTO som_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Oo isna si uu guriga u daahiriyo aawadeed waa inuu qaadaa laba shimbirrood, iyo qori kedar ah, iyo wax casaan ah, iyo geed husob la yidhaahdo. ");
INSERT INTO som_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Oo shimbirraha middood waa inuu ku dhex gowracaa weel dhoobo ah oo biyo socda korkooda ah. ");
INSERT INTO som_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Oo isagu markaas waa inuu soo qaadaa qoriga kedarka ah, iyo geedka husobka ah, iyo waxa casaanta ah iyo shimbirta nool, oo iyaga waa inuu dhex geliyaa dhiigga shimbirtii la gowracay iyo biyaha socdaba, oo markaas waa inuu toddoba jeer guriga ku saydhsaydhaa. ");
INSERT INTO som_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Oo waa inuu guriga ku daahiriyaa dhiigga shimbirta, iyo biyaha socda, iyo shimbirta nool, iyo qoriga kedarka ah, iyo geedka husobka ah, iyo waxa casaanta ah. ");
INSERT INTO som_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Laakiinse waa inuu shimbirta nool ku sii daayaa berrin bannaan oo magaalada dibaddeeda ah, oo sidaas waa inuu guriga kafaaraggud ugu sameeyaa, oo markaasuu daahir ahaan doonaa. ");
INSERT INTO som_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Kanu waa sharciga ku saabsan cayn kasta oo ah cudurka baraska ah, waana cambaarta, ");
INSERT INTO som_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","iyo weliba baraska dharka gala iyo kan guriga galaba, ");
INSERT INTO som_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","iyo bararka iyo qolofta, iyo barta dhalaalaysa. ");
INSERT INTO som_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Kanu waa sharciga baraska ku saabsan, oo idinkala baraya markay wax nijaas yihiin iyo markay daahir yihiin. ");
INSERT INTO som_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Markaasaa Rabbigu la hadlay Muuse iyo Haaruun oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","Dadka reer binu Israa'iil la hadla oo waxaad ku tidhaahdaan, Haddii qof leeyahay dheecaan jidhkiisa ka soo dareero, dheecaankiisa aawadiis isagu waa nijaas. ");
INSERT INTO som_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Oo nijaastiisuna sidanay ahaanaysaa inta dheecaankiisu ka daadanayo. Haddii dheecaanku jidhkiisa ka daadanayo iyo haddii dheecaanku jidhkiisa ka joogsadayba, waa nijaastiisa. ");
INSERT INTO som_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Oo kan dheecaanku ka daadanayo sariir alla sariirtii uu ku jiifsadaaba way nijaasoobaysaa, oo wax alla wixii uu ku fadhiistaaba way nijaasoobayaan. ");
INSERT INTO som_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Oo ku alla kii sariirtiisa taabtaaba waa inuu dharkiisa maydhaa, oo isna biyo ku maydhaa, oo tan iyo fiidkiina nijaas buu ahaanayaa. ");
INSERT INTO som_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Oo ku alla kii ku fadhiisto wixii uu qofkii dheecaanku ka daadanaya ku fadhiistay waa inuu dharkiisa maydhaa, oo isna biyo ku maydhaa, oo tan iyo fiidkiina nijaas buu ahaanayaa. ");
INSERT INTO som_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Oo kan dheecaanku ka daadanayo jidhkiisa qofkii taabtaana waa inuu dharkiisa maydhaa, oo isna biyo ku maydhaa, oo tan iyo fiidkiina nijaas buu ahaanayaa. ");
INSERT INTO som_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Oo kan dheecaanku ka daadanayaana hadduu ku candhuufo qof daahir ah, markaas ninkaasu waa inuu dharkiisa maydhaa, oo isna biyo ku maydhaa, oo tan iyo fiidkii nijaas buu ahaanayaa. ");
INSERT INTO som_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Oo kan dheecaanku ka daadanayo koore alla koorihii uu fuulaaba nijaas buu ahaanayaa. ");
INSERT INTO som_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Oo ku alla kii taabtaa wixii isaga hoostiisa ku jirayna, tan iyo fiidkii nijaas buu ahaanayaa, oo waxyaalahaas qofkii qaadaana waa inuu dharkiisa maydhaa, oo isna biyo ku maydhaa, oo tan iyo fiidkii nijaas buu ahaanayaa. ");
INSERT INTO som_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Oo kan dheecaanku ka daadanayo isagoo aan gacmihiisa biyo ku maydhin ku alla kii uu taabtaaba waa inuu dharkiisa maydhaa, oo isna biyo ku maydhaa, oo tan iyo fiidkii nijaas buu ahaanayaa. ");
INSERT INTO som_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Oo kan dheecaanku ka daadanayo weelkii dhoobo ah oo uu taabtona waa in la burburiyaa, oo weel kasta oo qori ahna waa in biyo lagu xalaa. ");
INSERT INTO som_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Oo kii dheecaanka daadanayaa markuu daahir ka noqdo, waa inuu toddoba maalmood nafsaddiisa u tirsadaa daahirintiisa aawadeed, oo dharkiisana waa inuu maydhaa, oo isna ku maydhaa biyo socda, oo markaasuu daahir ahaanayaa. ");
INSERT INTO som_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Oo maalinta siddeedaadna isagu waa inuu laba qoolley ama laba xamaam oo yaryar qaataa oo uu Rabbiga ugu hor yimaadaa iridda teendhada shirka, oo uu iyaga wadaadka u dhiibaa. ");
INSERT INTO som_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Oo wadaadku waa inuu middood u bixiyaa qurbaan dembi, midda kalena qurbaan la gubo, oo wadaadku waa inuu Rabbiga hortiisa kafaaraggud isaga ugu sameeyaa dheecaankiisa aawadiis. ");
INSERT INTO som_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Haddii nin shahwaddiisu ka timaada waa inuu jidhkiisa oo dhan biyo ku maydhaa, oo tan iyo fiidkii nijaas buu ahaanayaa. ");
INSERT INTO som_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Oo dhar kasta iyo harag kasta oo ay shahwaddiisu ku taalba, waa in biyo lagu maydhaa, oo tan iyo fiidkii nijaas bay ahaanayaan. ");
INSERT INTO som_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Oo weliba nin hadduu naag la seexdo, labadooduba waa inay biyo ku maydhaan, oo tan iyo fiidkii nijaas bay ahaanayaan. ");
INSERT INTO som_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Oo haddii dheecaan naag ka daadanayo, oo dheecaanka jidhkeeda ku yaal uu xayl yahay, iyadu waa inay intii toddoba maalmood ah nijaasteeda ku sii jirtaa. ");
INSERT INTO som_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Oo intay nijaasaysan tahay wax alla wixii ay ku jiifsataaba way nijaasoobayaan, oo wax alla wixii ay ku fadhiisataaba way nijaasoobayaan. ");
INSERT INTO som_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Oo ku alla kii sariirteeda taabtaana waa inuu dharkiisa maydhaa, oo isna biyo ku maydhaa, oo tan iyo fiidkiina nijaas buu ahaanayaa. ");
INSERT INTO som_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Oo wax alla wixii ay ku fadhiisato kii taabtaana waa inuu dharkiisa maydhaa, oo isna biyo ku maydhaa, oo tan iyo fiidkiina nijaas buu ahaanayaa. ");
INSERT INTO som_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Oo sariirteeda ama waxay ku fadhiisato haddii xayl ku yaal, markuu taabto, tan iyo fiidkii nijaas buu ahaanayaa. ");
INSERT INTO som_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Oo nin hadduu iyada la jiifsado oo xaylkeedu taabto intii toddoba maalmood ah nijaas buu ahaanayaa, oo sariir alla sariirtii uu ku jiifsadaaba way nijaasoobaysaa. ");
INSERT INTO som_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Haddii naag uu ka daato dheecaan dhiiggeeda ah maalmo badan oo aan ahayn wakhtigii xaylkeeda, ama hadduu iyada ka daato dheecaan ka badan oo dhaafsiisan wakhtigii xaylkeeda, inta iyada dheecaanku ka daadanayo oo ay nijaasaysan tahay oo dhan waa inay ahaataa sidii maalmihii ay xaylka qabtay oo kale, waayo, way nijaasaysan tahay. ");
INSERT INTO som_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Oo inta dheecaanku iyada ka daadanayo oo dhan, sariir alla sariirtii ay ku jiifsataaba, waxay iyada u ahaan doontaa sida sariirta ay ku jiifsato markay xaylka qabto, oo wax alla wixii ay ku fadhiisataaba waxay u nijaasoobayaan sida nijaasta xaylkeeda. ");
INSERT INTO som_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Oo waxyaalahaas ku alla kii taabtaa wuu nijaasoobayaa, oo waa inuu dharkiisa maydhaa, oo isna biyo ku maydhaa, oo tan iyo fiidkii nijaas buu ahaanayaa. ");
INSERT INTO som_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Laakiinse hadday dheecaankeedii ka daahirsanaato, markaas waa inay toddoba maalmood nafsaddeeda u tirsataa, oo markaas dabadeedna daahir bay ahaanaysaa. ");
INSERT INTO som_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Oo maalinta siddeedaadna waa inay laba qoolley ama laba xamaam oo yaryar qaadataa oo ay wadaadka ugu keentaa iridda teendhada shirka. ");
INSERT INTO som_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Oo wadaadku waa inuu middood u bixiyaa qurbaan dembi, oo midda kalena qurbaan la gubo, oo wadaadku waa inuu iyada kafaaraggud ugu sameeyaa Rabbiga hortiisa dheecaankii nijaasteeda aawadiis. ");
INSERT INTO som_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Oo sidaas waa inaad reer binu Israa'iil nijaastooda uga soocdaan, si ayan nijaastooda ugu dhex dhiman markay nijaaseeyaan taambuuggayga dhexdooda ku yaal. ");
INSERT INTO som_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Kanu waa sharciga ku saabsan kii dheecaan ka daadanayo iyo kii shahwaddiisu ka timaado, oo uu sidaas ku nijaasoobay, ");
INSERT INTO som_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","iyo naagtii xayl qabta, iyo qofkii dheecaan ka daadanayo nin iyo naag miduu yahayba, iyo kii la seexda tii nijaasaysan. ");
INSERT INTO som_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Oo markii Haaruun labadiisii wiil ay Rabbiga hortiisa u soo dhowaadeen oo ay dhinteen dabadeed ayaa Rabbigu Muuse la hadlay, ");
INSERT INTO som_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","oo wuxuu Muuse ku yidhi, Walaalkaa Haaruun la hadal si uusan goor walba u soo gelin meesha quduuska ah oo ilxidhka ka shishaysa gudaheeda, oo ka soo hor jeedda daboolka sanduuqa kor saaran, yuusan dhimane, waayo, anigu waxaan ka dhex muuqan doonaa daruurta kor saaran daboolka. ");
INSERT INTO som_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Haddaba Haaruun meesha quduuska ah waa inuu la soo galo dibi yar oo qurbaan dembi ah, iyo wan qurbaan la gubo ah. ");
INSERT INTO som_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Waa inuu gashadaa jubbadda quduuska ah oo dhar linen ah laga sameeyey, oo waa inuu jidhkiisa u lebbisaa sirwaalka linenka ah, oo dhexdana waa inuu ku xidhaa dhex-xidhka linenka ah, oo duubka linenka ahna waa inuu madaxa ku duubtaa, waayo, iyagu waa dharka quduuska ah oo intuu jidhkiisa biyo ku maydho waa inuu dharkaas lebbistaa. ");
INSERT INTO som_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Oo ururka reer binu Israa'iilna waa inuu laba orgi uga soo qaadaa qurbaan dembi, wanna qurbaan la gubo. ");
INSERT INTO som_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Oo Haaruun waa inuu keenaa dibiga qurbaanka dembiga ah oo uu nafsaddiisa u bixinayo, oo waa inuu nafsaddiisa iyo reerkiisaba kafaaraggud u sameeyaa. ");
INSERT INTO som_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Oo waa inuu labada orgi soo kexeeyaa, oo uu soo taagaa meel Rabbiga hortiisa ah oo iridda teendhada shirka u dhow. ");
INSERT INTO som_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Oo markaas Haaruun waa inuu labada orgi saami u kala ridaa, oo saami kan Rabbiga ha ahaado, saamiga kalena kan Casaaseel ha ahaado. ");
INSERT INTO som_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Oo orgigii saamigu ugu dhacay Rabbiga, Haaruun waa inuu keenaa, oo qurbaan dembi u bixiyaa. ");
INSERT INTO som_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Laakiinse orgigii saamigu ugu dhacay Casaaseel waa in isagoo nool Rabbiga hortiisa la taagaa si kafaaraggud looga kor sameeyo, oo Casaaseel aawadiis cidlada loogu eryo. ");
INSERT INTO som_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Oo Haaruun waa inuu keenaa dibiga qurbaanka dembiga ah oo uu nafsaddiisa u bixinayo, oo waa inuu nafsaddiisa iyo reerkiisaba kafaaraggud u sameeyaa, oo uu gowracaa dibiga qurbaanka dembiga ah oo uu nafsaddiisa u bixinayo. ");
INSERT INTO som_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Oo waa inuu meesha allabariga ee Rabbiga hortiisa taal ka qaadaa idan ay dhuxulo noolu ka buuxaan, oo waa inuu sacabbadiisana ka buuxsadaa foox udgoon oo tuman, oo uu ilxidhka la galaa. ");
INSERT INTO som_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Oo waa inuu fooxa ku shubaa dabka Rabbiga hortiisa yaal, si fooxa qiiqiisu u qariyo daboolka sanduuqa markhaatiga kor saaran, yuusan dhimane. ");
INSERT INTO som_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Oo isagu waa inuu qaadaa dhiiggii dibiga qaarkiis, oo fartiisa ha kula saydhsaydho daboolka dhankiisa bari, oo daboolka hortiisana waa inuu dhiigga fartiisa kula saydhsaydhaa toddoba jeer. ");
INSERT INTO som_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Markaas waa inuu gowracaa orgigii dadka loogu bixinayo qurbaan dembi, oo uu dhiiggiisana ilxidhka soo geliyaa, oo orgiga dhiiggiisana waa inuu ku sameeyaa siduu ku sameeyey dhiiggii dibiga oo kale, oo uu ku saydhsaydhaa daboolka dushiisa iyo hortiisaba. ");
INSERT INTO som_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Oo isagu waa inuu meesha quduuska ah daraaddeed kafaaraggud ugu sameeyaa dadka reer binu Israa'iil waxyaalahooda nijaasta ah iyo xadgudubyadooda oo ah xataa dembiyadooda oo dhan aawadood, oo sidaasoo kalena waa inuu u sameeyaa teendhada shirka oo iyaga la deggan waxyaalahooda nijaasta ah dhexdooda. ");
INSERT INTO som_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Oo waa inaan ninna teendhada shirka joogin markii uu isagu u galo inuu kafaaraggud ku sameeyo meesha quduuska ah gudaheeda ilaa uu ka soo baxo, isagoo kafaaraggud u sameeyey nafsaddiisa, iyo reerkiisa, iyo shirka reer binu Israa'iil oo dhan. ");
INSERT INTO som_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Oo waa inuu meesha allabariga ee Rabbiga hortiisa taal u baxaa, oo uu kafaaraggud u sameeyaa, oo uu soo qaadaa dhiigga dibiga qaarkiis, iyo dhiigga orgiga qaarkiis, oo uu mariyaa meesha allabariga geesaheeda. ");
INSERT INTO som_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Oo waa inuu toddoba jeer dhiigga fartiisa kula saydhaa meesha allabariga, oo waa inuu daahiriyaa, oo quduus ka dhigaa waxyaalaha nijaasta ah ee reer binu Israa'iil. ");
INSERT INTO som_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Oo markuu dhammaystiro kafaaraggudka uu u samaynayo meesha quduuska ah, iyo teendhada shirka, iyo meesha allabarigaba waa inuu orgiga nool keenaa. ");
INSERT INTO som_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Oo markaas Haaruun waa inuu labadiisa gacmoodba kor saaraa madaxa orgiga nool, oo waa inuu korkiisa ku qirtaa xumaatooyinkii reer binu Israa'iil oo dhan iyo xadgudubyadoodii oo dhan, oo ah xataa dembiyadoodii oo dhan, oo waxaas oo dhan waa inuu kor saaraa orgiga madaxiisa, dabadeedna waa inuu cidlada ugu diraa nin diyaarsan. ");
INSERT INTO som_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Oo orgiguna xumaatooyinkoodii oo dhan wuxuu u qaadayaa dhul cidla ah, oo markaas waa inuu orgiga ku sii daayaa cidlada dhexdeeda. ");
INSERT INTO som_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Markaas Haaruun waa inuu teendhada shirka galaa, oo waa inuu iska furaa dharka wanaagsan oo linenka ah, oo uu gashaday markuu galay meesha quduuska ah, oo waa inuu dharka halkaas kaga tagaa, ");
INSERT INTO som_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","oo waa inuu meel quduus ah ku maydhaa, oo uu dharkiisii soo gashadaa, oo dibadda u soo baxaa, oo bixiyaa qurbaankiisii la gubayo iyo qurbaankii dadka oo la gubayoba, oo kafaaraggudna waa inuu u sameeyaa nafsaddiisa iyo dadka daraaddiisba. ");
INSERT INTO som_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Oo xaydha qurbaanka dembigana waa inuu meesha allabariga ku dul gubaa. ");
INSERT INTO som_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Oo kii Casaaseel orgiga u sii daayayna waa inuu dharkiisa maydhaa, oo jidhkiisana biyo ku maydhaa, oo dabadeedna xerada galaa. ");
INSERT INTO som_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Oo dibigii qurbaanka dembiga ahaa, iyo orgigii qurbaanka dembiga ahaa oo dhiiggooda loo soo geliyey meesha quduuska ah in kafaaraggud lagu sameeyo, waa in xerada dibadda looga bixiyaa, oo haraggooda iyo hilibkooda iyo uuskoodaba dabka lagu gubaa. ");
INSERT INTO som_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Oo qofkii iyaga gubaana dharkiisa waa inuu maydhaa, oo jidhkiisana biyo ku maydhaa, oo dabadeedna xerada soo galaa. ");
INSERT INTO som_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Oo waxaa weligiinba qaynuun idiin ahaan doona inaad bisha toddobaad maalinteeda tobnaad nafihiinna dhibtaan, oo waa inaydaan waxba shuqul qaban cayn kasta ha ahaadee, kiinna waddaniga ah iyo shisheeyaha dhexdiinna degganuba, ");
INSERT INTO som_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","waayo, maalintaas kafaaraggud baa laydiin samayn doonaa in laydin daahiriyo aawadeed, oo dembiyadiinna oo dhanna daahir baad kaga noqon doontaan Rabbiga hortiisa. ");
INSERT INTO som_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Maalintaasu waxay idiin tahay sabti nasasho weyn leh, oo waa inaad nafihiinna dhibtaan. Taasu waa qaynuun weligiis jira. ");
INSERT INTO som_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Oo wadaadka la subki doono oo quduus looga dhigi doono inuu wadaad ka ahaado meeshii aabbihiis ayaa kafaaraggudka samayn doona, oo isagaa xidhan doona dharka wanaagsan oo linenka ah, oo ah dharka quduuska ah. ");
INSERT INTO som_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Oo isagu waa inuu kafaaraggud u sameeyaa meesha quduuska ah, waana inuu kafaaraggud u sameeyaa teendhada shirka iyo meesha allabariga, oo waa inuu kafaaraggud u sameeyaa wadaaddada iyo dadka shirka oo dhan. ");
INSERT INTO som_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Oo kaasu qaynuun weligiis ah buu idiin ahaan doonaa inaad reer binu Israa'iil sannaddiiba mar kafaaraggud ugu samaysaan dembiyadooda oo dhan. Oo isna wuxuu sameeyey sidii Rabbigu Muuse ku amray. ");
INSERT INTO som_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Markaasaa Rabbigu Muuse la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","Waxaad la hadashaa Haaruun, iyo wiilashiisa, iyo dadka reer binu Israa'iil oo dhan, oo waxaad ku tidhaahdaa, Waxanu waa wixii Rabbigu amray, oo uu yidhi, ");
INSERT INTO som_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Nin kasta oo reer binu Israa'iil ka mid ah, oo xerada gudaheeda ama dibaddeeda ku gowraca dibi ama wan yar ama orgi, ");
INSERT INTO som_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","isagoo aan iridda teendhada shirka keenin inuu Rabbiga qurbaan ahaan ugu bixiyo taambuugga Rabbiga hortiisa, ninkaas waxaa lagu xisaabi doonaa mid uu dhiig saaran yahay, waayo, isagu dhiig buu daadiyey, oo qofkaas waa in dadkiisa dhexdooda laga gooyaa, ");
INSERT INTO som_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","oo sidaas daraaddeed reer binu Israa'iil waa inay keenaan allabaryadooda ay berrinka bannaan ku bixiyaan, oo iyagu waa inay Rabbiga ugu keenaan iridda teendhada shirka, waana inay wadaadka guddoonsiiyaan, oo ay Rabbiga ugu bixiyaan allabaryo qurbaanno nabaadiino ah. ");
INSERT INTO som_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Oo wadaadkuna waa inuu dhiigga ku saydhsaydhaa meesha allabariga ee Rabbiga oo ag yaal iridda teendhada shirka, oo xaydhana waa inuu gubaa si ay Rabbiga u ahaato caraf udgoon. ");
INSERT INTO som_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Oo iyagu waa inayan mar dambe allabaryadooda u bixin orgiyada ay caabudaan sida naagu ninkeeda uga dhillowdo. Kaasu qaynuun weligiis ah buu ab ka ab u ahaan doonaa iyaga. ");
INSERT INTO som_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Oo waxaad iyaga ku tidhaahdaa, Nin kasta oo ka mid ah reer binu Israa'iil ama shisheeyayaasha dhexdooda deggan, oo bixiya qurbaan la gubo ama allabari, ");
INSERT INTO som_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","isagoo aan keenin iridda teendhada shirka inuu Rabbiga u bixiyo daraaddeed, ninkaas waa in dadkiisa laga gooyaa. ");
INSERT INTO som_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Oo nin alla ninkii ka mid ah reer binu Israa'iil ama shisheeyayaasha dhexdooda deggan oo cuna cayn kasta oo dhiig ah, aniga ayaa ka gees noqon doonaa qofkaas dhiigga cuna, oo dadkiisaan isaga ka gooyn doonaa. ");
INSERT INTO som_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Waayo, jiidhka noloshiisii waxay ku dhex jirtaa dhiigga; oo anna waxaan meesha allabariga dusheeda idiinku siiyey in nafihiinna loogu kafaaro gudo, waayo, waa dhiigga waxa loogu kafaaro gudaa nolosha daraaddeed. ");
INSERT INTO som_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Haddaba sidaas daraaddeed waxaan reer binu Israa'iil ku idhi, Qof idinka mid ahu waa inuusan dhiig cunin, oo shisheeyaha idin dhex degganuna waa inuusan dhiig cunin. ");
INSERT INTO som_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Oo nin alla ninkii ka mid ah reer binu Israa'iil ama shisheeyayaasha dhexdooda deggan hadduu ugaadhsasho ku helo neef amase haad ugaadh ah oo la cuno, waa inuu dhiiggiisa daadiyaa oo ciid ku daboolaa. ");
INSERT INTO som_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Waayo, jiidh kastaba naftiisa iyo dhiiggiisu waa isku mid qudha, oo sidaas daraaddeed ayaan reer binu Israa'iil ku idhi, Waa inaydaan jiidhnaba dhiiggiisa cunin cayn kastoo uu yahayba, waayo, jiidh kastaba noloshiisu waa dhiiggiisa, oo qof alla qofkii dhiig cunaba waa la gooyn doonaa. ");
INSERT INTO som_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Oo qof kasta oo cuna neef iska bakhtiyey amase neef dugaagu bakhtiistay, hadduu yahay waddani iyo hadduu shisheeye yahayba waa inuu dharkiisa maydhaa, oo isna biyo ku maydhaa, oo tan iyo fiidkana nijaas buu ahaanayaa, oo dabadeedna daahir buu ahaan doonaa. ");
INSERT INTO som_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Laakiinse hadduusan dharkiisa maydhin ama uusan jidhkiisa maydhin, markaasuu dembigiisa qaadan doonaa. ");
INSERT INTO som_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Markaasaa Rabbigu Muuse la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","Reer binu Israa'iil la hadal oo waxaad ku tidhaahdaa, Anigu waxaan ahay Rabbiga Ilaahiinna ah. ");
INSERT INTO som_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Falimaha dalka Masar ee aad degganaan jirteen waa inaydaan samayn, oo falimaha dalka Kancaan oo aan idiin geeynayana waa inaydaan samayn, oo qaynuunnadoodana waa inaydaan ku socon. ");
INSERT INTO som_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Waxaad samaysaan xukummadayda, oo waxaad dhawrtaan qaynuunnadayda si aad iyaga ugu dhex socotaan, waayo, aniga ayaa ah Rabbiga Ilaahiinna ah. ");
INSERT INTO som_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Haddaba sidaas daraaddeed idinku waa inaad dhawrtaan qaynuunnadayda iyo xukummadayda, oo ninkii sameeyaana iyaguu ku noolaan doonaa, waayo, aniga ayaa Rabbiga ah. ");
INSERT INTO som_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Waa inaan midkiinna u dhowaan qof ka mid ah xigaalkiisa u dhow inuu cawradiisa qaawiyo, waayo, aniga ayaa Rabbiga ah. ");
INSERT INTO som_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Cawrada aabbahaa taasoo ah cawrada hooyadaa waa inaadan qaawin, iyadu waa hooyadaa, ee waa inaadan cawradeeda qaawin. ");
INSERT INTO som_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Oo waa inaadan qaawin cawrada naagta aabbahaa, ee waa cawradii aabbahaa. ");
INSERT INTO som_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Waa inaadan qaawin cawrada walaashaa oo ah aabbahaa gabadhiisa ama hooyadaa gabadheeda, hadday guriga ku dhalatay iyo hadday meel kale ku dhalatayba. ");
INSERT INTO som_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Waa inaadan qaawin cawrada gabadha wiilkaaga, ama cawrada gabadha gabadhaada, waayo, toodu waa cawradaadii. ");
INSERT INTO som_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Waa inaadan qaawin cawrada naagta aabbahaa gabadheeda ay aabbahaa u dhashay, waayo, iyadu waa walaashaa, ee waa inaadan cawradeeda qaawin. ");
INSERT INTO som_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Waa inaadan qaawin cawrada eeddadaa, waayo, iyadu waa aabbahaa qaraabadiis u dhow. ");
INSERT INTO som_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Waa inaadan qaawin cawrada habaryartaa, waayo, iyadu waa hooyadaa qaraabadeed u dhow. ");
INSERT INTO som_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Waa inaadan adeerkaa cawradiisa qaawin. Waa inaadan naagtiisa u dhowaan, waayo, iyadu waa aayadaa. ");
INSERT INTO som_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Waa inaadan qaawin cawrada gabadha aad soddogga u tahay, waayo, iyadu waa naagtii wiilkaaga, ee waa inaadan cawradeeda qaawin. ");
INSERT INTO som_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Waa inaadan qaawin cawrada naagta walaalkaa, waayo, taasu waa cawradii walaalkaa. ");
INSERT INTO som_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Waa inaadan naag iyo gabadheedaba cawradooda wada qaawin, oo waa inaadan kaxaysan gabadha wiilkeeda ama gabadha gabadheeda si aad cawradeeda u qaawisid; waayo, iyagu waa naago qaraabo kuu dhow ah, oo taasu waa shar. ");
INSERT INTO som_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Waa inaadan naagtaada walaasheed la guursan oo aadan cawradeeda qaawin intay naagtaadu nooshahay. ");
INSERT INTO som_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Waa inaadan naag u dhowaan si aad cawradeeda u qaawisid, in alla intay xaylka ku nijaasaysan tahay. ");
INSERT INTO som_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Waa inaadan la jiifsan naagta deriskaaga, si aadan iyada ugu nijaasoobin. ");
INSERT INTO som_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Waa inaadan carruurtaada Moleg siin oo aadan iyaga innaba dab u dhex marsiin, oo weliba waa inaadan magaca Ilaahaaga hadal nijaas ah ka sheegin, waayo, aniga ayaa Rabbiga ah. ");
INSERT INTO som_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Waa inaadan ragga ula seexan sida dumarka loola seexdo oo kale, waayo, taasu waa karaahiyo. ");
INSERT INTO som_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Waa inaadan neef xayawaan ah kudin si aadan ugu nijaasoobin, oo naaguna waa inayan neef xayawaan ah is-hor taagin si ay isaga ugu jiifsato, waayo, taasu waa qasnaan. ");
INSERT INTO som_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Idinku waxyaalahaas midkoodna nafsaddiinna ha ku nijaasaynina, waayo, quruumihii aan hortiinna ka eryay oo dhammu waxyaalahaas bay ku nijaasoobeen, ");
INSERT INTO som_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","oo dalkii wuu nijaasoobay, haddaba sidaas daraaddeed ayaan xumaantiisii soo gaadhsiinayaa, oo dalku waa mantagayaa dadka deggan. ");
INSERT INTO som_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Haddaba idinku waa inaad dhawrtaan qaynuunnadayda iyo xukummadayda, oo waa inaydaan waxyaalahaas karaahiyada ah innaba samayn, kiinnii waddani ah, iyo kii shisheeye ah oo idin dhex degganuba, ");
INSERT INTO som_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","(waayo, dadkii dalka degganaan jiray oo idinka horreeyey waxyaalahaas karaahiyada ah oo dhan ayay wada samayn jireen, oo dalkuna wuu nijaasoobay;) ");
INSERT INTO som_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","si markaad nijaasaysaan dalku uusan idinkana idiin mantagin, siduu quruuntii idinka horraysay u mantagay oo kale. ");
INSERT INTO som_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Waayo, ku alla kii sameeya waxyaalahaas karaahiyada ah, xataa nafihii waxyaalahaas sameeya dadkooda waa laga gooyn doonaa. ");
INSERT INTO som_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Haddaba sidaas daraaddeed waa inaad amarkayga xajisaan si aydaan u samayn oo aydaan ugu nijaasoobin caadooyinkaas karaahiyada ah oo dadkii idinka horreeyey ay samayn jireen, waayo, aniga ayaa ah Rabbiga Ilaahiinna ah. ");
INSERT INTO som_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Markaasaa Rabbigu Muuse la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","La hadal ururka reer binu Israa'iil oo dhan, oo waxaad ku tidhaahdaa, Waa inaad quduus ahaataan, waayo, anigoo ah Rabbiga Ilaahiinna ahuba quduus baan ahay. ");
INSERT INTO som_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Oo idinka midkiin kastaaba waa inuu ka cabsadaa aabbihiis iyo hooyadiis, oo waa inaad dhawrtaan maalmahayga sabtida ah, waayo, aniga ayaa ah Rabbiga Ilaahiinna ah. ");
INSERT INTO som_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Sanamyo ha u jeesanina, oo hana samaysanina ilaahyo la tumay, waayo, aniga ayaa ah Rabbiga Ilaahiinna ah. ");
INSERT INTO som_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Oo markaad allabari qurbaanno nabaadiino ah Rabbiga u bixinaysaan waa inaad bixisaan si laydiin aqbalo. ");
INSERT INTO som_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Oo waa in dhammaantiis la wada cunaa maalinta aad bixisaan iyo maalinta ku xigta, oo haddii wax ka hadhaan oo ay gaadhaan maalinta saddexaad waa in dab lagu gubaa. ");
INSERT INTO som_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Oo innaba haddii maalinta saddexaad la cuno waa karaahiyo, oo la aqbali maayo, ");
INSERT INTO som_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","ku alla kii cunaase dembigiisuu qaadanayaa, maxaa yeelay, nijaas buu ka dhigay Rabbiga wixiisii quduuska ahaa, oo qofkaasna dadkiisa waa laga gooyn doonaa. ");
INSERT INTO som_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Oo markaad goosataan waxa dhulkiinna ka soo baxa waa inaydaan midhaha ka wada goosan rukummada beertiinna, oo weliba waa inaydaan soo urursan xaaxaabka beergoosadkiinna. ");
INSERT INTO som_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Oo beertiinna canabka ahna waa inaydaan xaaxaabin, oo midhaha beertiinna canabka ah oo dhacayna waa inaydaan soo urursan, laakiinse waa inaad u daysaan miskiinka iyo shisheeyaha, waayo, aniga ayaa ah Rabbiga Ilaahiinna ah. ");
INSERT INTO som_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Waa inaydaan waxba xadin, oo aydaan daacadla'aan ku isticmaalin, waana inaan midkiinna midka kale been u sheegin. ");
INSERT INTO som_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Oo waa inaydaan magacayga been ugu dhaaran, yeydnan hadal nijaas ah ka sheegin magaca Ilaahiinna, waayo, aniga ayaa Rabbiga ah. ");
INSERT INTO som_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Waa inaadan deriskaaga dulmin, waana inaadan waxba ka dhicin. Oo shaqaale aad soo kiraysatay mushahaaradiisu yaanay habeenkii kugu baryin oo kugu gaadhin tan iyo subaxda dambe. ");
INSERT INTO som_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Waa inaadan caayin qofkii dhega la', oo kii indha la'na waa inaadan hortiisa dhigin wax lagu turunturoodo, laakiinse waa inaad Ilaahaaga ka cabsataa, waayo, aniga ayaa Rabbiga ah. ");
INSERT INTO som_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Waa inaydaan garsooridda caddaaladdarro ku samayn, oo waa inaadan miskiinka u eexan, ama aadan cisayn qofka weyn, laakiinse deriskaaga waxaad ugu garsoortaa si caddaalad ah. ");
INSERT INTO som_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Waa inaadan dadkaaga xan kula dhex wareegin, oo waa inaadan deriskaaga dhiiggiisa hor joogsan, waayo, aniga ayaa Rabbiga ah. ");
INSERT INTO som_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Waa inaadan walaalkaa qalbiga ka nebcaan, oo sida xaqiiqada ah waa inaad deriskaaga canaanataa, yaadan isaga daraaddiis dembi u qaadane. ");
INSERT INTO som_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Waa inaadan ninna ka aarsan, waana inaadan dadkaaga u ciil qabin, laakiinse waa inaad deriskaaga u jeclaataa sidaad naftaada u jeceshahay oo kale, waayo, aniga ayaa Rabbiga ah. ");
INSERT INTO som_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Waa inaad qaynuunnadayda dhawrtaan. Waa inaadan xoolahaaga u dayn inay cayn kale ku beermaan, oo waa inaadan beertaada ku beeran midho laba cayn ah, oo waa inaadan xidhan dhar laga sameeyey laba cayn oo isku darsan. ");
INSERT INTO som_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Oo ku alla kii la seexda naag addoon ah oo nin u doonan, oo aan la madax furin ama aan la xorayn, markaas waa in iyaga la ciqaabaa, laakiinse waa inaan iyaga la dilin, maxaa yeelay, iyadu xor ma ay ahayn. ");
INSERT INTO som_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Oo isagu waa inuu qurbaankiisii xadgudubka, kaasoo ah wan ah qurbaan xadgudub, Rabbiga ugu keenaa iridda teendhada shirka. ");
INSERT INTO som_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Oo wadaadku waa inuu isaga kafaaraggud uga dhigaa wanka qurbaanka xadgudubka ah, oo waa inuu Rabbiga hortiisa ugu bixiyaa dembiguu dembaabay aawadiis, oo isagana waa laga cafiyi doonaa dembigii uu dembaabay. ");
INSERT INTO som_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Oo markaad dalka gashaan, oo aad cunto u beerataan dhir cayn kasta ah, markaas waa inaad midhahooda ku tirisaan sidii wax buuryoqab ah, oo intii saddex sannadood ah waxay idiin ahaan doonaan sidii wax buuryoqab ah, oo waa inaan midhahaas la cunin. ");
INSERT INTO som_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Laakiinse sannadda afraad midhahooda oo dhammu quduus bay ahaan doonaan, si Rabbiga loo ammaano aawadeed. ");
INSERT INTO som_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Oo midhahoodana waxaad cuni doontaan sannadda shanaad, si ay midhahoodu idiinku soo baxaan, waayo, aniga ayaa ah Rabbiga Ilaahiinna ah. ");
INSERT INTO som_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Waa inaydaan wax dhiiggoodu ku jiro cunin, oo waa inaydaan u tegin falanfallowyo ama aydaan faalna ku noqnoqon. ");
INSERT INTO som_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Waa inaydaan timaha madaxa ka jaran dhinacyada, gadhkiinnana waa inaydaan jarin. ");
INSERT INTO som_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Waa inaydaan jidhkiinna u gooyn qof dhintay daraaddiis, ama waa inaydaan waxba ku daabicin, waayo, aniga ayaa Rabbiga ah. ");
INSERT INTO som_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Waa inaadan gabadhaada nijaasayn oo aadan dhillo ka dhigin, waaba intaasoo uu dalku noqdaa sino miidhan oo uu shar ka buuxsamaa. ");
INSERT INTO som_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Waa inaad maalmahayga sabtida ah dhawrtaan, oo aad meeshayda quduuska ah maamuustaan, waayo, aniga ayaa Rabbiga ah. ");
INSERT INTO som_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Ha u jeesanina xagga kuwa ruuxaanta leh, iyo saaxiriinta, oo iyaga ha doondoonina yeydnan nijaasoobine, waayo, aniga ayaa ah Rabbiga Ilaahiinna ah. ");
INSERT INTO som_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Waa inaad qofkii cirro leh u istaagtaa, oo waa inaad ninkii oday ah cisaysaa, waana inaad Ilaahaa ka cabsataa, waayo, aniga ayaa Rabbiga ah. ");
INSERT INTO som_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Oo haddii mid shisheeye ahu idinla deggan yahay dhulkiinna, waa inaydaan xumayn. ");
INSERT INTO som_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Shisheeyaha idinla degganu waa inuu idiinla mid ahaadaa sida waddaniga idin dhex jooga, oo waa inaad isaga u jeclaataan sidaad naftiinna u jeceshihiin oo kale, maxaa yeelay, idinkuba shisheeyayaal baad ku ahaan jirteen dalkii Masar, waayo, aniga ayaa ah Rabbiga Ilaahiinna ah. ");
INSERT INTO som_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Waa inaydaan xaqdarro ka samayn garsooridda, iyo cabbiridda, iyo miisaamidda iyo beegiddaba. ");
INSERT INTO som_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Waa inaad haysataan kafado qumman iyo miisaan qumman, iyo eefaah qumman iyo hiin qumman, waayo, aniga ayaa ah Rabbiga Ilaahiinna ah oo dalkii Masar idinka soo bixiyey. ");
INSERT INTO som_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Oo waa inaad wada dhawrtaan oo yeeshaan qaynuunnadayda oo dhan iyo xukummadayda oo dhan, waayo, aniga ayaa Rabbiga ah. ");
INSERT INTO som_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Markaasaa Rabbigu Muuse la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","Weliba waxaad ku tidhaahdaa reer binu Israa'iil, Ku alla kii reer binu Israa'iil ka mid ah, ama shisheeyayaasha idin dhex deggan ka mid ah, oo carruurtiisa Moleg siiya, sida xaqiiqada ah kaas waa in la dilaa, oo dadka dalka degganu waa inay dhagax la dhacaan. ");
INSERT INTO som_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Oo anna qofkaas ayaan ka gees noqon doonaa, oo isagaan dadkiisa ka dhex gooyn doonaa, maxaa yeelay, wuxuu carruurtiisii siiyey Moleg, oo sidaasuu meeshayda quduuska ah ku nijaaseeyey oo uu magacayga quduuska ahna wax nijaas ah kaga sheegay. ");
INSERT INTO som_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Oo haddii dadka dalka degganu ay ninkaas indhahooda ka qarsadaan oo ayan isaga dilin markuu carruurtiisa Moleg siiyo, ");
INSERT INTO som_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","markaas aniga ayaa ninkaas iyo reerkiisaba ka gees noqon doonaa, oo isaga iyo in alla intii raacda inay Moleg u daba galaan sida naagu ninkeeda uga dhillowdo, waxaan ka dhex gooyn doonaa dadkooda. ");
INSERT INTO som_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Oo qof alla qofkii u jeesta xagga kuwa ruuxaanta leh iyo saaxiriinta, oo iyaga u daba gala sida naagu ninkeeda uga dhillowdo, sida xaqiiqada ah anigu qofkaas ayaan ka gees noqon doonaa oo isagaan dadkiisa ka dhex gooyn doonaa. ");
INSERT INTO som_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Haddaba isdaahiriya oo quduus ahaada, waayo, aniga ayaa ah Rabbiga Ilaahiinna ah. ");
INSERT INTO som_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Oo waa inaad qaynuunnadayda dhawrtaan oo yeeshaan, waayo, anigu waxaan ahay Rabbiga quduus idinka dhiga. ");
INSERT INTO som_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Oo ku alla kii caaya aabbihiis ama hooyadiis, sida xaqiiqada ah waa in la dilaa, waayo, wuxuu caayay aabbihiis ama hooyadiis, oo dhiiggiisuna isaguu dul saarnaan doonaa. ");
INSERT INTO som_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Oo nin alla ninkii ka sinaysta nin kale naagtiis, kaasoo ah kii ka sinaysta naagta deriskiisa, sida xaqiiqada ah dhillayga iyo dhilladaba waa in la dilaa. ");
INSERT INTO som_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Oo ninkii naagta aabbihiis la seexdaana wuxuu qaawiyey cawradii aabbihiis, oo sida xaqiiqada ah labadoodaba waa in la dilaa; oo dhiiggooduna iyaguu dul saarnaan doonaa. ");
INSERT INTO som_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Oo haddii nin la seexdo gabadh uu soddog u yahay, sida xaqiiqada ah labadoodaba waa in la dilaa; iyagu waxay sameeyeen wax qas ah, oo dhiiggooduna iyaguu dul saarnaan doonaa. ");
INSERT INTO som_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Oo haddii nin nin kaleeto ula seexdo sida dumarka loola seexdo oo kale, labadooduba waxay sameeyeen karaahiyo oo sida xaqiiqada ah waa in iyaga la dilaa, oo dhiiggooduna iyaguu dul saarnaan doonaa. ");
INSERT INTO som_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Oo haddii nin wada guursado naag iyo hooyadeed, taasu waa shar, oo isaga iyo labadoodaba waa in dhammaantood dab lagu gubaa, si aan sharu idiinku dhex jirin. ");
INSERT INTO som_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Oo haddii nin neef xayawaan ah kudo, sida xaqiiqada ah waa in ninkaas la dilaa, oo neefkana waa inaad gowracdaan. ");
INSERT INTO som_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Oo naaguna hadday u dhowaato neef xayawaan ah, oo ay u jiifsato, naagta iyo neefkaba waa inaad dishaan, sida xaqiiqada ah waa in labadoodaba la dilaa; oo dhiiggooduna iyaguu dul saarnaan doonaa. ");
INSERT INTO som_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Oo haddii nin kaxaysto walaashiis oo ah ina aabbihiis ama ina hooyadiis, oo uu cawradeeda arko, oo iyana ay cawradiisa aragto, taasu waa wax ceeb ah, oo iyaga waa in dadkooda hortiisa laga gooyaa, waayo, isagu wuxuu qaawiyey cawradii walaashiis, oo dembigiisana wuu qaadan doonaa. ");
INSERT INTO som_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Oo haddii nin la seexdo naag xayl qabta, oo uu cawradeeda qaawiyo, wuxuu qaawiyey ishii dhiiggeeda oo iyana waxay qaawisay ishii dhiiggeeda, oo markaas labadoodaba waa in laga gooyaa dadkooda. ");
INSERT INTO som_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Oo waa inaadan qaawin habaryartaa, ama eeddadaa, waayo, kii saas yeelaa wuxuu qaawiyey xigaalkiisa u dhow, oo iyagu waxay qaadan doonaan dembigooda. ");
INSERT INTO som_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Oo haddii nin la seexdo naagta adeerkiis, kaasu wuxuu qaawiyey cawradii adeerkiis; iyagu waxay qaadan doonaan dembigooda, oo waxay dhiman doonaan iyagoo gablan ah. ");
INSERT INTO som_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Oo haddii nin kaxaysto naagta walaalkiis, taasu waa nijaas, waayo, wuxuu qaawiyey cawradii walaalkiis, oo iyagu waxay ahaan doonaan gablan. ");
INSERT INTO som_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Haddaba waa inaad wada xajisaan oo yeeshaan qaynuunnadayda oo dhan iyo xukummadayda oo dhan, si dalka aan idin geeynayo inaad degtaan uusan idiin mantagin. ");
INSERT INTO som_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Oo waa inaydaan ku socon caadooyinkii quruuntii aan hortiinna ka eryayo, waayo, iyagu waxyaalahaas oo dhan ayay samayn jireen, oo sidaas daraaddeed ayaan u karhay. ");
INSERT INTO som_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Laakiinse waxaan idinku idhi, Idinka ayaa dalkoodii dhaxli doona, oo hanti ahaan ayaan idiin siinayaa, kaasoo ah dal caano iyo malab la barwaaqaysan, waayo, aniga ayaa ah Rabbiga Ilaahiinna ah oo idinka soocay dadyowga. ");
INSERT INTO som_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Haddaba sidaas daraaddeed waa inaad kala soocdaan xayawaanka daahirka ah iyo kan nijaasta ah, iyo haadda daahirka ah iyo tan nijaasta ah, oo waa inaydaan nafihiinna wax karaahiyo ah kaga dhigin xayawaan ama haad ama waxa dhulka ku gurguurta oo aan idinka soocay oo aan idhi, Waa nijaas. ");
INSERT INTO som_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Waa inaad quduus ii ahaataan, waayo, anigoo Rabbiga ahuba quduus baan ahay, oo dadyowgii baan idinka soocay, si aad kuwaygii u ahaataan. ");
INSERT INTO som_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Oo weliba sida xaqiiqada ah waa in la dilaa ninkii ama naagtii ruuxaan leh, ama ku alla kii saaxir ah, oo iyaga waa in dhagax la dhacaa, oo dhiiggooduna iyaguu dul saarnaan doonaa. ");
INSERT INTO som_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Markaasaa Rabbigu Muuse ku yidhi, La hadal wadaaddada ah wiilashii Haaruun, oo waxaad ku tidhaahdaa, Ninkiinna yuusan isu nijaasayn mid dadkiisa ah oo dhintay, ");
INSERT INTO som_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","xigaalkiisa u dhow mooyaane, kuwaasoo ah hooyadiis, ama aabbihiis, ama wiilkiisa, ama gabadhiisa, ama walaalkiis, ");
INSERT INTO som_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","ama walaashiisa bikradda ah oo isaga u dhow, oo aan weli nin guursan; taas wuu isu nijaasayn karaa. ");
INSERT INTO som_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Waa inuusan isnijaasayn isagoo dadkiisa madax u ah, yuusan nijaas iska dhigin. ");
INSERT INTO som_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Oo waa inaan ninkoodna madaxa xiiran, oo waa inayan gadhkooda xiirin, ama ayan jidhkooda gooyn. ");
INSERT INTO som_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Iyagu waa inay Ilaahooda quduus u ahaadaan, oo ayan wax nijaas ah ka sheegin magaca Ilaahooda, waayo, iyagu waxay bixiyaan qurbaannadii Rabbiga ee dabka lagu sameeyo oo ah cuntada Ilaahooda, oo sidaas daraaddeed waa inay quduus ahaadaan. ");
INSERT INTO som_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Waa inayan guursan naag dhillo ah ama mid la nijaaseeyey, oo waa inayan guursan naag la furay, waayo, wadaadku quduus buu Ilaahiis u yahay. ");
INSERT INTO som_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Haddaba sidaas daraaddeed waa inaad isaga quduus ka dhigtaa, waayo, isagu wuxuu bixiyaa cuntada Ilaahaaga, oo isagu waa inuu quduus kuu ahaadaa, waayo, anba quduus baan ahay, anigoo ah Rabbiga quduus idinka dhiga. ");
INSERT INTO som_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Oo wadaad kasta haddii ay gabadhiisu isnijaasayso oo ay dhillowdo, iyadu nijaas bay ka dhigaysaa aabbaheed, oo waa in dab lagu gubaa. ");
INSERT INTO som_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Oo kii wadaadka sare walaalihiis ka dhex ah, oo madaxiisa lagu shubay saliiddii subkidda, oo ah kan loo daahiriyey inuu xidho dharka quduuska ah waa inaanay timaha madaxiisu arbushnaan ama uusan dharkiisa dildillaacin. ");
INSERT INTO som_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Oo weliba waa inuusan meyd gudaha ugu gelin, oo xataa waa inuusan isu nijaasayn aabbihiis iyo hooyadiis toona. ");
INSERT INTO som_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Oo waa inuusan dibadda uga bixin meesha quduuska ah, waana inuusan nijaasayn meesha quduuska ah ee Ilaahiisa, waayo, isaga waxaa kor saaran taajkii saliidda subkidda ee Ilaahiisa, waayo, aniga ayaa Rabbiga ah. ");
INSERT INTO som_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Oo isagu waa inuu guursadaa gabadh bikrad ah. ");
INSERT INTO som_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Waa inuusan marnaba guursan carmal, ama naag la furay, ama naag nijaasowday oo dhillo ah, laakiinse waa inuu guursadaa gabadh bikrad ah oo dadkiisa ka dhalatay. ");
INSERT INTO som_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Oo waa inuusan dhashiisa ku dhex nijaasayn dadkiisa, waayo, aniga ayaa ah Rabbiga isaga quduus ka dhiga. ");
INSERT INTO som_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Markaasaa Rabbigu Muuse la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","Haaruun la hadal, oo waxaad ku tidhaahdaa, Tan iyo ab ka ab ku alla kii farcankaaga ahu, isagoo iin leh, yuusan u dhowaan inuu cuntada Ilaahiisa bixiyo. ");
INSERT INTO som_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Waayo, nin alla ninkuu yahayba, kii iin lahu waa inuusan u soo dhowaan, kaasoo ah ninkii indha la' ama curyaan ah, ama kii sankiisu faruuran yahay, ama jidhkiisu leeyahay wax dheeraad ah, ");
INSERT INTO som_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","ama ninkii cag jaban, ama gacan jaban, ");
INSERT INTO som_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","ama kii tuur leh, ama kii cilin ah, ama kii ishiisu iin leedahay, ama kii cambaar qaba, ama kii cadho qaba, ama kii xiniinyihiisu burbureen. ");
INSERT INTO som_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Wadaadka Haaruun ah nin alla ninkii farcankiisa ka mid ahu isagoo iin leh waa inuusan u soo dhowaan inuu bixiyo qurbaannada Rabbiga oo dabka lagu sameeyo, waayo, isagu iin buu leeyahay, oo waa inuusan u soo dhowaan inuu cuntada Ilaahiisa bixiyo. ");
INSERT INTO som_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Isagu waa inuu cunaa cuntada Ilaahiisa, tan quduuska ah iyo tan ugu wada quduusanba. ");
INSERT INTO som_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Laakiinse waa inuusan meesha daaha leh gelin, ama uusan meesha allabariga u dhowaan, si uusan u nijaasayn meelahayga quduuska ah, maxaa yeelay, isagu iin buu leeyahay, oo aniga ayaa ah Rabbiga iyaga quduus ka dhiga. ");
INSERT INTO som_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Muuse sidaasuu kula hadlay Haaruun iyo wiilashiisii, iyo dadkii reer binu Israa'iil oo dhanba. ");
INSERT INTO som_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Markaasaa Rabbigu Muuse la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","La hadal Haaruun iyo wiilashiisa, oo waxaad iyaga u sheegtaa inay iska soocaan waxyaalaha quduuska ah oo reer binu Israa'iil, oo ay ii daahiriyaan, iyo inayan wax nijaas ah ka sheegin magacayga quduuska ah, waayo, aniga ayaa Rabbiga ah. ");
INSERT INTO som_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Oo waxaad iyaga ku tidhaahdaa, Ku alla kii ka mid ah farcankiinna oo dhan tan iyo ab ka ab, hadduu isagoo nijaas qaba u soo dhowaado waxyaalaha quduuska ah oo reer binu Israa'iil ay Rabbiga u daahiriyeen, qofkaas hortayda waa in laga gooyaa, waayo, aniga ayaa Rabbiga ah. ");
INSERT INTO som_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Oo ku alla kii farcanka Haaruun ka mid ah oo baras qaba, ama dheecaan ka daadanayaa, waa inuusan wax ka cunin waxyaalaha quduuska ah jeeruu daahir noqdo. Oo ku alla kii taabta wax meyd ku nijaasoobay, ama uu taabta nin shahwaddiisu ka daadatay, ");
INSERT INTO som_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","ama ku alla kii taabta wax gurguurta oo uu isagu ku nijaasoobo, amase qof isaga nijaaso qabadsiin kara, wax kastoo ay nijaastiisu tahayba, ");
INSERT INTO som_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","qof alla qofkii waxyaalaha caynkaas ah taabtaa wuxuu nijaas ahaan doonaa tan iyo fiidkii, oo waa inuusan wax ka cunin waxyaalaha quduuska ah, inuu jidhkiisa biyo ku maydho mooyaane. ");
INSERT INTO som_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Oo isna markii qorraxdu dhacdo ayuu daahir noqon doonaa, oo markaas dabadeedna isagu wax ha ka cuno waxyaalaha quduuska ah, maxaa yeelay, taasu waa cuntadiisii. ");
INSERT INTO som_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Oo isagu si uusan ugu nijaasoobin waa inuusan innaba cunin wax iska bakhtiyey amase dugaagu bakhtiistay, waayo, aniga ayaa Rabbiga ah. ");
INSERT INTO som_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Oo sidaas daraaddeed iyagu waa inay amarkayga xajiyaan, waaba intaasoo ay dembi u qaataan taas aawadeed oo ay ku dhintaan haddii ay nijaaseeyaan, waayo, aniga ayaa ah Rabbiga iyaga quduus ka dhiga. ");
INSERT INTO som_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Oo qof qalaadu waa inuusan waxba ka cunin waxa quduuska ah, oo qofkii wadaadka la deggan, amase shaqaalihii la soo kiraystay waa inuusan waxba ka cunin waxa quduuska ah. ");
INSERT INTO som_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Laakiinse haddii wadaad qof soo iibsado, kii uu lacagtiisa ku soo iibsaday wax ha ka cuno, oo intii isaga gurigiisa ku dhalatayna cuntadiisa wax ha ka cuneen. ");
INSERT INTO som_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Oo wadaad gabadhiis hadday nin qalaad guursato, iyadu waa inayan wax ka cunin qurbaanka sare loo qaado ee waxyaalaha quduuska ah. ");
INSERT INTO som_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Laakiinse wadaad gabadhiis hadday carmal tahay, ama la soo furay, oo ayan carruur lahayn, oo ay ku soo noqoto gurigii aabbaheed, oo ay halkaas u joogto sidii waagii ay yarayd, markaas iyadu wax ha ka cunto cuntada aabbaheed, laakiinse qof qalaadu yuusan wax ka cunin. ");
INSERT INTO som_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Oo waxa quduuska ah haddii nin kama' ku cuno, intii uu cunay oo shan meelood loo dhigay meesheed ha ku sii daro, oo waxa quduuska ah wadaadka ha u dhiibo. ");
INSERT INTO som_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Oo iyagu waa inayan nijaasayn waxyaalaha quduuska ah ee reer binu Israa'iil oo ay Rabbiga u bixiyaan, ");
INSERT INTO som_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","si ayan uga dhigin inay iyagu qaataan xumaanta eedda keenta, markay cunaan waxyaalahooda quduuska ah, waayo, aniga ayaa ah Rabbiga iyaga quduus ka dhiga. ");
INSERT INTO som_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Markaasaa Rabbigu Muuse la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","Waxaad la hadashaa Haaruun iyo wiilashiisa iyo dadka reer binu Israa'iil oo dhan, oo waxaad ku tidhaahdaa, Ku alla kii reer binu Israa'iil ka mid ah, ama dadka shisheeyayaasha ah ee reer binu Israa'iil dhex deggan, markay keenaan qurbaankooda ay Rabbiga ugu bixinayaan qurbaan la gubo aawadiis, hadduu yahay nidarradooda midkood amase qurbaannadooda ikhtiyaarka ah, ");
INSERT INTO som_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","si laydiinka aqbalo aawadeed waa inaad bixisaan neef lab oo aan iin lahayn, kaasoo ka mid ah lo'da, ama idaha, ama orgida. ");
INSERT INTO som_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Laakiinse waa inaydaan bixin wax alla wixii iin leh, waayo, waxaas laydinka aqbali maayo. ");
INSERT INTO som_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Oo ku alla kii Rabbiga u bixiyo allabari qurbaanno nabaadiino ah, si uu ku oofiyo nidar amase qurbaan ikhtiyaar ah, si looga aqbalo aawadeed waa inuu ka bixiyaa lo'da ama idaha neef dhan oo aan innaba iin lahayn. ");
INSERT INTO som_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Waa inaydaan Rabbiga u bixin ama aydaan ka dhigin qurbaan dab lagu sameeyo oo meesha allabariga loo saaro Rabbiga aawadiis neef indha la', ama mid jaban, ama mid naafo ah, ama mid qoon leh, ama mid cambaar qaba, ama mid cadho qaba. ");
INSERT INTO som_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Oo dibi yar ama wan yar miduu yahayba neefkii jidhkiisu wax dheeraad ah leeyahay ama xubnihiisa wax ka dhiman yihiin, kaas qurbaan ikhtiyaar ah waad u bixin kartaa, laakiinse nidar daraaddiis loo aqbali maayo. ");
INSERT INTO som_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Waa inaydaan Rabbiga u bixin neef xiniinyihiisa la burburiyey, ama la tumay, ama la jejebiyey, ama laga gooyay, oo waa inaydaan dalkiinna sidaasoo kale ku dhex samayn. ");
INSERT INTO som_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Oo kuwaas waa inaydaan ka guddoomin qof shisheeye ah gacantiis oo aydaan ku bixin cuntada Ilaahiinna, maxaa yeelay, iyagu wax kharriban bay leeyihiin, oo iin baa ku taal. Sidaas daraaddeed iyaga innaba laydinka aqbali maayo. ");
INSERT INTO som_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Markaasaa Rabbigu Muuse la hadlay, oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","Markii uu dhasho dibi ama wan ama orgi intii toddoba maalmood ah waa inuu hooyadiis ku hoos jiraa, oo maalinta siddeedaad iyo intii ka dambaysana waa loo aqbali doonaa in Rabbiga loogu bixiyo qurbaan dab lagu sameeyo. ");
INSERT INTO som_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Oo sac iyo lax toona waa inaydaan ilmaheeda iyo iyada isku maalin gowracin. ");
INSERT INTO som_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Oo markaad Rabbiga u bixinaysaan allabari mahadnaqid ah, waa inaad kaas u bixisaan si laydiinka aqbalo. ");
INSERT INTO som_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Oo isla maalintaas waa in la wada cunaa, oo waa inaydaan waxba ka reebin tan iyo subaxda dambe, waayo, aniga ayaa Rabbiga ah. ");
INSERT INTO som_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Haddaba sidaas daraaddeed waa inaad xajisaan oo yeeshaan amarradayda, waayo, aniga ayaa Rabbiga ah. ");
INSERT INTO som_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Waa inaydaan wax nijaas ah ka sheegin magacayga quduuska ah, laakiinse quduus baan ku dhex ahaan doonaa dadka reer binu Israa'iil, waayo, anigu waxaan ahay Rabbiga quduus idinka dhiga, ");
INSERT INTO som_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","oo dalkii Masar idiinka soo bixiyey inuu Ilaah idiin ahaado aawadeed, waayo, aniga ayaa Rabbiga ah. ");
INSERT INTO som_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Markaasaa Rabbigu Muuse la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","Dadka reer binu Israa'iil la hadal oo waxaad ku tidhaahdaa, Kuwanu waa Rabbiga iidihiisa la amray, oo aad naadin doontaan inay ahaadaan shirar quduus ah. Xataa kuwanu waa iidahayga la amray. ");
INSERT INTO som_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Lix maalmood waa in shuqul la qabtaa, laakiinse maalinta toddobaad waa sabti nasasho weyn leh oo ah shir quduus ah. Waa inaydaan innaba shuqul qaban cayn kastoo uu yahayba, waayo, waa sabti ay tahay in Rabbiga looga dhawro meel kastoo aad deggan tihiinba. ");
INSERT INTO som_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Kuwanu waa Rabbiga iidihiisa la amray, oo ah shirar quduus ah, oo ay tahay inaad naadisaan wakhtigooda la amray. ");
INSERT INTO som_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Bisha kowaad, maalinteeda afar iyo tobnaad, markay fiidkii tahay, waa Rabbiga iiddiisii Kormaridda. ");
INSERT INTO som_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Oo isla bishaas maalinteeda shan iyo tobnaadna waa Iidda Kibista-aan-khamiirka-lahayn oo Rabbiga loo qabto, oo intii toddoba maalmood ah waa inaad kibis aan khamiir lahayn cuntaan. ");
INSERT INTO som_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Oo maalinta kowaad waa inaad shir quduus ah yeelataan. Waa inaydaan innaba shuqul adag qaban. ");
INSERT INTO som_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Laakiinse intii toddoba maalmood ah waa inaad Rabbiga u bixisaan qurbaan dab lagu sameeyo, oo maalinta toddobaad waa shir quduus ah, oo waa inaydaan innaba shuqul adag qaban. ");
INSERT INTO som_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Markaasaa Rabbigu Muuse la hadlay, oo wuxuu ku yidhi. ");
INSERT INTO som_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","Dadka reer binu Israa'iil la hadal, oo waxaad ku tidhaahdaa, Dalka aan idin siinaya markaad gashaan oo aad midhaha goosataan, markaas waxaad wadaadka u keentaan xidhmo ah beergooyska midhihiisa ugu horreeya. ");
INSERT INTO som_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Oo isna xidhmada waa inuu ku ruxruxaa Rabbiga hortiisa si laydiin aqbalo, oo maalinta sabtida ka dambaysa wadaadku waa inuu ruxruxaa. ");
INSERT INTO som_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Oo maalinta aad xidhmada ruxruxdaan, wan yar oo aan iin lahayn oo gu jira waa inaad Rabbiga ugu bixisaan qurbaan la gubo aawadiis. ");
INSERT INTO som_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Oo qurbaankiisa hadhuudhka ahuna waa inuu ahaadaa eefaah toban meelood loo dhigay labadiis meelood oo bur wanaagsan ah oo saliid lagu daray, kaasoo ah qurbaan dab lagu sameeyo oo Rabbiga caraf udgoon u ah, oo qurbaankiisa cabniinka ahuna waa inuu ahaadaa khamri, kaasoo ah hiin afar meelood loo dhigay meesheed. ");
INSERT INTO som_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Oo waa inaydaan cunin kibis, ama hadhuudh duban, ama sabuullo cusub ilaa isla maalintaas, jeeraad keentaan qurbaankii Ilaahiinna. Kaasu weligiinba waa idiin qaynuun tan iyo ab ka ab meel kastoo aad deggan tihiinba. ");
INSERT INTO som_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Oo maalintii aad keenteen xidhmada qurbaanka la ruxruxo, oo ah maalinta ka dambaysa sabtida, waxaad ka tirsataan toddoba toddobaad oo kaamil ah. ");
INSERT INTO som_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Oo waxaad tirsataan konton maalmood ilaa maalinta ka dambaysa sabtida toddobaad, oo dabadeedna waxaad Rabbiga u bixisaan qurbaan hadhuudh cusub ah. ");
INSERT INTO som_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Oo waa inaad rugihiinna ka keentaan laba kibsood oo ah qurbaan la ruxruxo, oo ah eefaah toban meelood loo dhigay labadiis meelood, oo waa inay bur ahaadaan, oo waa in khamiir lagu dubaa oo Rabbiga loogu keenaa qurbaan midhaha ugu horreeya. ");
INSERT INTO som_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Oo waxaad kibista la keentaan toddoba wan oo yaryar oo aan iin lahayn oo wada gu jira, iyo dibi yar, iyo laba wan oo waaweyn, oo waa inay Rabbiga u ahaadaan qurbaan la gubo, oo waxaad iyaga la keentaan qurbaankooda hadhuudhka ah iyo qurbaannadooda cabniinka ahba, kuwaasoo wada ah qurbaan dab lagu sameeyo oo Rabbiga u ah caraf udgoon. ");
INSERT INTO som_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Oo waa inaad bixisaan orgi qurbaan dembi ah iyo laba wan oo yaryar oo gu jira oo ah allabari qurbaanno nabaadiino ah. ");
INSERT INTO som_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Oo wadaadku waa inuu Rabbiga hortiisa qurbaan la ruxruxo iyaga ugula ruxruxaa kibista midhaha ugu horreeya oo raacda labada wan oo yaryar, oo iyagu quduus bay Rabbiga u ahaan doonaan wadaadka aawadiis. ");
INSERT INTO som_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Oo isla maalintaas waa inaad naadisaan inuu shir quduus ah idiin jiri doono, oo waa inaydaan dharaartaas shuqul adag qaban, waayo, kaasu weligiinba waa idiin qaynuun tan iyo ab ka ab meel kastoo aad deggan tihiinba. ");
INSERT INTO som_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Oo markaad beeraha dhulkiinna goosataan waa inaydaan dhammaan wada goosan midhaha ku yaal beertiinna geesaheeda, oo weliba waa inaydaan wada urursan xaaxaabka beergoosadkiinna; waa inaad u daysaan miskiinka iyo shisheeyaha, waayo, aniga ayaa ah Rabbiga Ilaahiinna ah. ");
INSERT INTO som_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Markaasaa Rabbigu Muuse la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","Dadka reer binu Israa'iil la hadal, oo waxaad ku tidhaahdaa, Bisha toddobaad maalinteeda kowaad waxay idiin ahaan doontaa nasasho weyn oo ah buunafuufid xusuus ah, iyo shir quduus ah. ");
INSERT INTO som_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Oo innaba waa inaydaan shuqul adag qaban, oo waa inaad Rabbiga u bixisaan qurbaan dab lagu sameeyo. ");
INSERT INTO som_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Markaasa Rabbigu Muuse la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","Habase yeeshee bishan toddobaad maalinteeda tobnaad waa maalinta kafaaraggudka. Oo waa inay idiin ahaataa shir quduus ah, oo waa inaad nafihiinna dhibtaan; oo waa inaad Rabbiga u bixisaan qurbaan dab lagu sameeyo. ");
INSERT INTO som_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Oo isla maalintaas waa inaydaan waxba shuqul qaban cayn kasta ha ahaadee, waayo, taasu waa maalintii kafaaraggudka in kafaaraggud laydiinku sameeyo Rabbiga Ilaahiinna ah hortiisa. ");
INSERT INTO som_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Oo qof kasta ha ahaadee kii aan maalintaas la dhibin, dadkiisa waa in laga gooyaa. ");
INSERT INTO som_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Oo qof kasta ha ahaadee kii maalintaas wax shuqul ah qabtaa cayn kastoo uu yahayba, qofkaas ayaan ka dhex baabbi'in doonaa dadkiisa. ");
INSERT INTO som_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Waa inaydaan innaba shuqul qaban cayn kastoo uu yahayba, oo kaasu weligiinba waa idiin qaynuun tan iyo ab ka ab meel kastoo aad deggan tihiinba. ");
INSERT INTO som_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Oo dharaartaasu waxay idiin ahaan doontaa sabti nasasho weyn leh, oo waa inaad nafihiinna dhibtaan. Oo bisha maalinteeda sagaalaad waa inaad dhawrtaan sabtidiinna tan iyo fiid ilaa ka fiid. ");
INSERT INTO som_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Markaasaa Rabbigu Muuse la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","La hadal dadka reer binu Israa'iil, oo waxaad ku tidhaahdaa, Bishan toddobaad maalinteeda shan iyo tobnaad waa Iiddii Waababka oo waa in toddoba maalmood Rabbiga loo iidaa. ");
INSERT INTO som_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Maalinta kowaad waa inay shir quduus ah ahaataa, oo waa inaydaan innaba shuqul adag qaban. ");
INSERT INTO som_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Oo intii toddoba maalmood ah waxaad Rabbiga u bixisaan qurbaan dab lagu sameeyo, oo maalinta siddeedaadna waa inay idiin ahaataa shir quduus ah, oo waa inaad Rabbiga u bixisaan qurbaan dab lagu sameeyo, oo waa inaydaan innaba shuqul adag qaban, waayo, dharaartaasu waa shir quduus ah. ");
INSERT INTO som_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Kuwanu waa Rabbiga iidihiisa la amray, oo ay tahay inaad naadisaan inay ahaadaan shirar quduus ah, oo waa inaad Rabbiga u bixisaan qurbaan dab lagu sameeyo, kaasoo ah qurbaan la gubo, iyo qurbaan hadhuudh ah, iyo allabari, iyo qurbaanno cabniin ah, oo mid kastana maalintiisa ha la bixiyo. ");
INSERT INTO som_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Oo kuwaasu waa ka gooni sabtiyadii Rabbiga iyo hadiyadihiinna oo waa ka gooni nidarradiinna oo dhan, oo waa ka gooni qurbaannadiinna ikhtiyaarka ah oo dhan ee aad Rabbiga siisaan. ");
INSERT INTO som_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Habase yeeshee bisha toddobaad maalinteeda shan iyo tobnaad, markaad midhaha dhulka soo urursataan, waa inaad intii toddoba maalmood ah Rabbiga iiddiisa dhawrtaan. Maalinta kowaad waa inay ahaataa nasasho weyn, oo maalinta siddeedaadna waa inay ahaataa nasasho weyn. ");
INSERT INTO som_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Oo maalinta kowaad waxaad soo qaadataan midhaha dhirta wanaagsan, iyo laamo cawbaar ah, iyo dhir waaweyn laamaheed, iyo safsaafka durdurka, oo waa inaad Rabbiga Ilaahiinna ah hortiisa ku rayraysaan intii toddoba maalmood ah. ");
INSERT INTO som_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Oo sannaddiiba toddoba maalmood waa inaad Rabbiga iid u qabataan, oo kaasu waa qaynuun weligiisba idiin jira tan iyo ab ka ab; oo iiddaas waa inaad bisha toddobaad dhawrtaan. ");
INSERT INTO som_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Intii toddoba maalmood ah waa inaad waabab ku hoyataan, oo kulli reer binu Israa'iilka waddaniga ah oo dhammu waa inay waabab ku hoydaan, ");
INSERT INTO som_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","si farcankiinna dambe u ogaado inaan reer binu Israa'iil waabab ku hoyiyey markaan iyaga ka soo bixiyey dalkii Masar, waayo, aniga ayaa ah Rabbiga Ilaahiinna ah. ");
INSERT INTO som_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Oo Muusena wuxuu reer binu Israa'iil u sheegay iidihii Rabbiga oo la amray. ");
INSERT INTO som_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Markaasaa Rabbigu Muuse la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","Waxaad reer binu Israa'iil ku amartaa inay kuu keenaan saliid saafiya oo saytuun ah oo loo tumay laambadda, in laambad lagu shido had iyo goorba. ");
INSERT INTO som_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Oo daaha markhaatiga dibaddiisa oo teendhada shirka gudaheeda ah Haaruun waa inuu Rabbiga hortiisa had iyo goorba ku hagaajiyaa tan iyo fiidkii iyo ilaa subaxdii, oo kaasu waa inuu ahaadaa qaynuun weligiis idiin jiri doona tan iyo ab ka ab. ");
INSERT INTO som_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Oo isagu waa inuu had iyo goorba laambadaha ku kor hagaajiyaa laambadda saafiga ah oo Rabbiga hortiisa taal. ");
INSERT INTO som_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Oo waa inaad bur soo qaadataa, oo aad ka dubtaa laba iyo toban xabbadood oo kibis ah, oo xabbaddiiba waa inuu eefaah toban meelood loo dhigo labadiis meelood ku jiraa. ");
INSERT INTO som_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Oo waa inaad laba saf u dhigtaa oo safkiiba waxaad ka dhigtaa lix xabbadood, oo waxaad saartaa miiska saafiga ah oo Rabbiga hortiisa yaal. ");
INSERT INTO som_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Oo saf kastaba waxaad ku shubtaa foox saafi ah, si uu kibista ugu noqdo xusuus, kaasoo ah qurbaan Rabbiga dab loogu sameeyo. ");
INSERT INTO som_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Oo isagu had iyo goorba sabti kasta waa inuu Rabbiga hortiisa ku hagaajiyaa; waayo, kaasu wuxuu reer binu Israa'iil u yahay axdi weligiis ah. ");
INSERT INTO som_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Oo kibistaas waxaa iska yeelan doona Haaruun iyo wiilashiisa, oo waa inay meel daahir ah ku cunaan, waayo, taasu isaga waa ugu wada quduusan tahay qurbaannada Rabbiga ee dabka lagu sameeyo oo qaynuun weligiis ah loo amray. ");
INSERT INTO som_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Oo naag reer binu Israa'iil ah wiilkeed, oo aabbihiis uu Masri ahaa ayaa reer binu Israa'iil dhex galay, oo wiilkii naagta reer binu Israa'iil iyo nin reer binu Israa'iil ah ayaa xerada dhexdeedii ku diriray. ");
INSERT INTO som_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Markaasaa naagtii reer binu Israa'iil wiilkeedii magicii Rabbiga caayay oo habaaray, oo isagii waxaa loo keenay Muuse. Oo wiilkaas hooyadiis magaceedu wuxuu ahaa Shelomiid ina Dibrii, waxayna ahayd qabiilka Daan. ");
INSERT INTO som_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Oo isagiina way xidheen ilaa xukunkiisu ka soo baxo afka Rabbiga. ");
INSERT INTO som_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Markaasaa Rabbigu Muuse la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","Kii caytamay xerada ka soo bixi, oo intii isaga maqashay oo dhammu gacmahooda madaxiisa ha kor saareen, oo dabadeedna ururka oo dhammu ha dhagxiyeen. ");
INSERT INTO som_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Oo waa inaad reer binu Israa'iil la hadashaa oo waxaad ku tidhaahdaa, Ku alla kii Ilaahiisa caayaa waa inuu dembigiisa qaadaa. ");
INSERT INTO som_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Kii magaca Rabbiga caaya sida xaqiiqada ah waa in la dilaa. Ururka oo dhammu hubaal waa inay isaga dhagxiyaan, oo hadduu shisheeye yahay iyo hadduu waddani yahayba, markuu magaca Rabbiga caayo waa in la dilaa. ");
INSERT INTO som_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Oo ku alla kii qof kale dila, sida xaqiiqada ah waa in la dilaa. ");
INSERT INTO som_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Oo ku alla kii neef xoolo ah dilaana waa inuu magaa, oo neef neef ku gudaa. ");
INSERT INTO som_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Oo haddii nin deriskiisa wax yeelo, wax alla wixii uu yeelay oo kale waa in isagana la yeelaa. ");
INSERT INTO som_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Jabniin jabniin ha ku mago, ilna il ha ku mago, iligna ilig ha ku mago, oo isagu siduu qofka wax u yeelay, saasoo kale isagana ha loo yeelo. ");
INSERT INTO som_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Oo kii neef xoolo ah dilaa waa inuu isagu magaa, kii qof dilase waa in isagana la dilaa. ");
INSERT INTO som_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Oo waa inaad sharci qudha u haysataan shisheeyaha iyo waddanigaba, waayo, aniga ayaa ah Rabbiga Ilaahiinna ah. ");
INSERT INTO som_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Markaasaa Muuse la hadlay reer binu Israa'iil, oo iyana waxay xerada ka soo bixiyeen kii caytamay, oo way dhagxiyeen. Oo reer binu Israa'iil waxay sameeyeen sidii Rabbigu Muuse ku amray. ");
INSERT INTO som_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Markaasa Rabbigu Muuse kula hadlay Buur Siinay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Reer binu Israa'iil la hadal, oo waxaad ku tidhaahdaa, Markaad gashaan dalka aan idin siinayo, waa in dalku sabti Rabbiga u dhawraa. ");
INSERT INTO som_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Lix sannadood waa inaad beertaada beerataa, oo lix sannadoodna waa inaad beertaada canabka ah baarka ka jartaa, oo midhaheedana waa inaad soo xeraysataa. ");
INSERT INTO som_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Laakiinse sannadda toddobaad waa inay dhulka u ahaataa sabti nasasho weyn ah, oo taasu waa sabti Rabbiga loo dhawro, oo waa inaadan beertaada beeran, ama aadan beertaada canabka ah baarka ka jarin. ");
INSERT INTO som_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Oo sannaddaas wixii beertaada ka baxa iyagoo aan la beerin waa inaadan guran, oo canabkaaga aan la hagaajin midhiihii ka baxana waa inaadan urursan, waayo, sannaddaasu waa inay dhulka u ahaataa nasasho weyn. ");
INSERT INTO som_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Oo dhulka sabtidiisu cunto bay idiin ahaan doontaa. Adiga, iyo addoonkaaga, iyo addoontaada, iyo midiidinkaaga aad kiraysatay, iyo kan shisheeye kuu ah oo kula degganba, ");
INSERT INTO som_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","iyo xoolahaaga, iyo xayawaanka dalkaaga jooga oo dhan waxaa cunto u ahaan doona midhaha dalka iska baxa oo idil. ");
INSERT INTO som_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Oo waa inaad tirsataa toddoba sabtiyood oo sannado ah, taasu waxa weeyaan toddoba meelood oo toddoba sannadood ah; oo toddoba sabtiyood oo toddoba sannadood ah wakhtigoodu wuxuu kuu ahaan doonaa sagaal iyo afartan sannadood. ");
INSERT INTO som_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Oo dabadeedna waa inaad bisha toddobaad maalinteeda tobnaad buun dhawaajisaa, oo maalinta kafaaraggudka waa inaad dalkiinna oo dhan buun ka dhawaajisaan. ");
INSERT INTO som_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Oo waa inaad sannadda kontonaad quduus ka dhigtaan, oo dhammaan dadka dalka deggan oo dhan waxaad u naadisaan xorriyad, oo sannaddaasu waxay idiin ahaan doontaa wakhti yubilii ah; oo midkiin kastaa waa inuu ku noqdaa hantidiisii, oo midkiin kastaa waa inuu ku noqdaa qoladiisii. ");
INSERT INTO som_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Oo sannaddaas kontonaad wuxuu idiin ahaan doonaa wakhti yubilii ah, oo waa inaydaan waxba beeran, ama aydaan goosan wixii beertiinna iskood uga baxa, ama aydaan soo urursan canabka ka baxa geedcanabka oo aan la hagaajin. ");
INSERT INTO som_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Waayo, sannaddaasu waa wakhti yubilii ah, oo waa inay idiin ahaataa mid quduus ah; oo waxaad cuni doontaan midhaha berrinka iskood uga baxa. ");
INSERT INTO som_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Oo sannaddaas yubilii ah midkiin kastaa waa inuu ku noqdaa hantidiisii. ");
INSERT INTO som_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Oo haddaad deriskaaga wax ka iibisid, ama haddaad gacanta deriskaaga wax ka iibsatid, waa inaan midkiinna midka kale dulmin. ");
INSERT INTO som_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Oo sannadaha wakhtiga yubilii ah ka dambeeya siday tiradoodu tahay waa inaad deriskaaga wax uga iibsataa, oo isna wax ha kaaga iibiyo siday tahay sannadaha wax la goosto. ");
INSERT INTO som_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Oo waa inaad qiimaha u kordhisaa sida sannaduhu u badan yihiin, oo waa inaad qiimaha u dhintaa sida sannaduhu u yar yihiin, waayo, isagu wuxuu wax kaaga iibin doonaa sida ay tahay tirada sannadaha wax la goosanayo. ");
INSERT INTO som_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Waa inaan midkiinna midka kale dulmin; laakiinse waxaad ka cabsataan Ilaahiinna, waayo, aniga ayaa ah Rabbiga Ilaahiinna ah. ");
INSERT INTO som_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Haddaba sidaas daraaddeed waa inaad qaynuunnadayda yeeshaan, oo aad xukummadaydana dhawrtaan oo yeeshaan, oo markaasaad dalka ammaan ku degganaan doontaan. ");
INSERT INTO som_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Oo dhulkuna wuxuu dhali doonaa midhihiisa, oo waxaad cuni doontaan wax aad ka dheregtaan, oo dalkana ammaan baad ku degganaan doontaan. ");
INSERT INTO som_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Oo haddaad istidhaahdaan, Bal maxaynu sannadda toddobaad cuni doonnaa? Waayo, waxba ma aynu beeran doonno, oo soomana urursan doonno midhaheenna, ");
INSERT INTO som_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","markaas anigu sannadda lixaad ayaan barakadayda idiin amri doonaa, oo waxaa dhulka idiinka soo bixi doona midho saddex sannadood ku filan. ");
INSERT INTO som_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Oo sannadda siddeedaadna wax baad beeran doontaan, oo waxaad cuni doontaan midhihii hore, oo tan iyo ilaa aad midhaha sannadda sagaalaad soo xeraysataan waxaad iska cuni doontaan midhihii hore. ");
INSERT INTO som_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Oo dalkana waa inaydaan hanti weligeed ah u iibin, waayo, dalka anigaa iska leh, oo idinna waxaad tihiin shisheeyayaal iyo socoto ila jooga. ");
INSERT INTO som_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Oo dalka aad hantida u leedihiin oo dhan waxaad dhulka uga oggolaataan furasho. ");
INSERT INTO som_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Oo haddii walaalkaa miskiin noqdo oo uu hantidiisa qaar iibiyo, markaas xigaalkiisa ugu dhow ha yimaado, oo ha u furto wixii walaalkiis iibiyey. ");
INSERT INTO som_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Oo nin hadduusan lahayn qof isaga u furta, laakiinse uu mar dambe helo wax ku filan inuu dhulkiisii ku soo furto, ");
INSERT INTO som_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","markaas ha tiriyo sannadaha la iibiyey, oo waxa dheeraadka ah ha u celiyo ninkii uu ka iibiyey; oo hantidiisii ha ku noqdo. ");
INSERT INTO som_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Laakiinse hadduusan soo ceshan karin, markaas wixii uu iibiyey waxay ku sii jiri doonaan kii ka iibsaday gacantiisa tan iyo sannadda yubilii ah, oo sannadda yubiliiga ah ayaa waxaasu gacantiisa ka bixi doonaan, oo isna markaasuu hantidiisii ku noqon doonaa. ");
INSERT INTO som_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Oo qof hadduu iibiyo guri lagu hoydo oo magaalo deyr leh ku yaal, markaas intii sannad dhan ah wuu soo furan karaa gurigiisii uu iibiyey, waayo, sannad dhan ah wuxuu xaq u leeyahay inuu soo furto. ");
INSERT INTO som_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Oo haddaan la soo furan intii sannad dhan ah, markaas gurigii magaalada deyran ku yiil waa inuu weligii hanti u ahaadaa qofkii iibsaday, oo tan iyo ab ka ab isagaa iska leh, oo sannadda yubilii ahna gacantiisa ka bixi maayo. ");
INSERT INTO som_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Laakiinse guryaha ku dhex yaal tuulooyinka aan lahayn deyr ku wareegsan ha lagu tiriyo beeraha duurka ku yaal, oo iyaga waa la soo furan karaa, oo sannadda yubilii ahna gacanta kii iibsaday way ka bixi doonaan. ");
INSERT INTO som_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Habase yeeshee magaalooyinka reer Laawi saas ma aha, oo reer Laawi mar kasta way soo furan karaan guryaha ku dhex yaal magaalooyinka ay iyagu hantida u leeyihiin. ");
INSERT INTO som_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Oo mid reer Laawi ahu hadduu soo furto, markaas gurigii la iibiyey iyo magaaladii hantidiisa ahaydba waxay bixi doonaan wakhtiga yubilii ah, waayo, guryaha ku dhex yaal magaalooyinka reer Laawi waa hantidooda oo ku dhex jirta reer binu Israa'iil. ");
INSERT INTO som_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Laakiinse waa inaan la iibin beertii ku taal agagaarka magaalooyinkooda, waayo, taasu waa hantidooda weligeed ah. ");
INSERT INTO som_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Oo haddii walaalkaa miskiin noqdo, oo intuu ku ag joogo masruufkiisa waayo, adigu waa inaad taageertaa, oo isagu waa inuu kuula degganaado sidii shisheeye iyo nin socoto ah. ");
INSERT INTO som_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Oo waa inaadan isaga ka qaadan korsocod ama wax dheeraad ah toona, laakiinse Ilaahaaga ka cabso, oo walaalkaa ha kula degganaado. ");
INSERT INTO som_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Oo waa inaadan lacagtaada korsocod ku deymin, ama aadan quudkaaga u siin si aad wax dheeraad ah kaga qaadatid. ");
INSERT INTO som_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Aniga ayaa ah Rabbiga Ilaahiinna ah oo dalkii Masar idiinka soo bixiyey inaan idin siiyo dalka Kancaan oo aan Ilaah idiin noqdo aawadeed. ");
INSERT INTO som_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Oo haddii walaalkaa miskiin noqdo isagoo kula jooga oo uu iska kaa iibiyo, waa inaadan isaga ka dhigin inuu kuugu adeego sidii addoon oo kale, ");
INSERT INTO som_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","laakiinse waa inuu kuula joogaa sidii midiidin la kiraysto iyo sidii mid socoto ah, oo waa inuu kuu adeegaa tan iyo sannadda yubilii ah, ");
INSERT INTO som_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","oo dabadeedna ha kaa tago, isaga iyo carruurtiisaba, oo ha ku noqdo reerkiisii iyo hantidii awowayaashiis. ");
INSERT INTO som_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Waayo, iyagu waa addoommadaydii aan dalkii Masar ka soo bixiyey, oo waa inaan loo iibin sidii addoommo. ");
INSERT INTO som_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Waa inaadan cadaadis ugu talin, laakiinse Ilaahaaga ka cabso. ");
INSERT INTO som_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Oo ragga iyo dumarka addoommada ah oo aad lahaanaysaan waxaad ka iibsan doontaan quruumaha hareerahiinna ku wareegsan. Iyaga waa inaad ka iibsataan rag iyo dumar addoommo ah. ");
INSERT INTO som_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Oo weliba waxaad ka iibsataan shisheeyayaasha idin dhex deggan iyo reerahooda idinla joogaba, kuwaasoo ay dalkiinna ku dhaleen, oo waxay ahaan doonaan hantidiin. ");
INSERT INTO som_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Oo iyaga waa inaad dhaxal uga dhigtaan carruurtiinna idinka dambaysa, si ay iyana hanti ahaan ugu haystaan; oo iyagu waa kuwa aad weligiin addoommo ka dhiganaysaan, laakiinse walaalihiinna reer binu Israa'iil waa inaan midkiinna midka kale cadaadis ugu talin. ");
INSERT INTO som_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Oo haddii shisheeye ama socoto kula joogo uu taajir noqdo, oo walaalkaana uu agtiisa miskiin ku noqdo oo uu markaas iska iibiyo shisheeyaha ama socotada kula jooga amase shisheeyaha qoladiisii, ");
INSERT INTO som_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","markii la iibiyo dabadeed waa la soo furan karaa. Walaalihiis mid ka mid ahu waa soo furan karaa, ");
INSERT INTO som_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","ama adeerkiis ama ina-adeerkiis way soo furan karaan, amase midkii xigaal u dhow ah oo qoladiisa ahu waa soo furan karaa, amase isaga qudhiisu hadduu taajir noqdo waa isfuran karaa. ");
INSERT INTO som_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Isaga iyo kan isaga iibsaday waa inay tiriyaan sannadihii u dhexeeyey sannaddii uu iibsaday iyo sannadda yubilii ah, oo qiimihii iibka waa inuu ahaadaa si waafaqsan tiradii sannadaha, oo wakhtiguu la joogay waa inuu ahaadaa sida wakhtiga shaqaale la kiraysto. ");
INSERT INTO som_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Oo haddii sannado badanu ay weli dhiman yihiin, inta ay yihiin oo kale iyaga ha uga celiyo qiimihii furashadiisa oo ha uga bixiyo lacagtii lagu iibsaday. ");
INSERT INTO som_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Laakiinse haddii sannado yaru ay ka dhiman yihiin sannadda yubilii ah, markaas waa inuu isaga la xisaabtamo, oo inta sannadihiisu ay yihiin oo kale waa inuu ka celiyaa qiimihii furashadiisa. ");
INSERT INTO som_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Oo waa inuu isaga ula joogaa sida shaqaale la kiraysto sannad ka sannad, oo isagu waa inuusan cadaadis hortaada ugaga talin. ");
INSERT INTO som_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Oo isaga haddaan sidan lagu soo furan, markaasuu sannadda yubilii ah bixi doonaa, isaga iyo carruurtiisaba. ");
INSERT INTO som_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Waayo, reer binu Israa'iil anigay addoommo ii yihiin, oo iyagu waa addoommadaydii aan ka soo bixiyey dalkii Masar. Aniga ayaa ah Rabbiga Ilaahiinna ah. ");
INSERT INTO som_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Waa inaydaan sanamyo samaysan, ama aydaan qotonsan ekaan la qoray amase tiir, oo waa inaydaan dalkiinna dhagax la qoray u dhex dhigin inaad u sujuuddaan, waayo, aniga ayaa ah Rabbiga Ilaahiinna ah. ");
INSERT INTO som_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Waa inaad iidahayga dhawrtaan, oo aad meeshayda quduuska ah maamuustaan, aniga ayaa Rabbiga ah. ");
INSERT INTO som_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Haddaad qaynuunnadayda ku socotaan, oo aad amarradayda dhawrtaan oo yeeshaan, ");
INSERT INTO som_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","markaasaan roobkiinna idin siinayaa xilligiisa, oo dhulkuna wuxuu dhali doonaa midhihiisa, dhirta duurkuna midhahooday dhali doonaan. ");
INSERT INTO som_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Tumidda hadhuudhkiinnu waxay gaadhi doontaa guridda canabkiinna, guridda canabkuna waxay gaadhi doontaa ilaa wakhtiga beeridda, oo cuntadiinna ayaad cuni doontaan ilaa aad dheregtaan, oo dalkiinnana ammaan baad ku degganaan doontaan. ");
INSERT INTO som_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Oo anigu waxaan dalka idinku siin doonaa nabaadiino, oo idinna waad iska jiifsan doontaan, oo waxba idinma cabsiin doonaan, oo anna dugaagga xun dalkiinna waan ka baabbi'in doonaa, oo seefuna dalkiinna innaba ma dhex mari doonto. ");
INSERT INTO som_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Oo idinku cadaawayaashiinnaad eryan doontaan, oo iyana hortiinnay seef kaga baabbi'i doonaan. ");
INSERT INTO som_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Oo shan idinka ahu boqol nin bay eryan doonaan, oo boqol idinka ahuna toban kun oo nin bay eryan doonaan, oo cadaawayaashiinnuna hortiinnay seef kaga baabbi'i doonaan. ");
INSERT INTO som_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Oo anigu waan idiin soo jeesan doonaa, waanan idin badin doonaa oo idin tarmin doonaa, oo axdigaygii aan idinla dhigtayna waan sii adkayn doonaa. ");
INSERT INTO som_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Oo waxaad cuni doontaan midhihii hore oo aad wakhti dheer kaydsateen, oo waxaad soo bixin doontaan midhihii hore si aad kuwa cusub meel ugu heshaan. ");
INSERT INTO som_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Oo anna taambuuggaygaan idinka dhex dhisan doonaa, oo naftayduna idinma karhi doonto. ");
INSERT INTO som_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Oo dhexdiinnaan ku socon doonaa, oo Ilaahiinnaan ahaan doonaa, oo idinkuna dadkaygaad ahaan doontaan. ");
INSERT INTO som_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Anigu waxaan ahay Rabbiga Ilaahiinna ah, oo idiinka soo bixiyey dalkii Masar si aydaan u sii ahaan addoommadoodii. Qataarradii harqoodkiinna waan idinka jebiyey, oo waxaan idinka dhigay inaad madaxfurnaan ku socotaan. ");
INSERT INTO som_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Laakiinse haddaad i dhegaysan weydaan, oo aydaan amarradan oo dhan wada yeelin, ");
INSERT INTO som_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","iyo haddaad qaynuunnadayda diiddaan, iyo haddii naftiinnu xukummadayda karahdo, oo aad amarradayda oo dhan wada yeeli weydaan, illowse aad igu axdi furtaan, ");
INSERT INTO som_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","markaasaan aniguna waxyaalahan idinku samayn doonaa. Naxdin baan idinku soo dejin doonaa, taasoo ah baabbi'id iyo qandho indhaha idinka ridda oo naftana idinka dullaysa, oo abuurkiinnana waxtarla'aan baad u beeran doontaan, waayo, waxaa iska cuni doona cadaawayaashiinna. ");
INSERT INTO som_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Oo anna gees baan idinka noqon doonaa, oo cadaawayaashiinna hortooda baa laydinku layn doonaa, oo waxaa idiin talin doona kuwo idin neceb, waadna iska carari doontaan iyadoo aan ninna idin eryanayn. ");
INSERT INTO som_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Oo weliba haddaydnan waxyaalahaas daraaddood ii dhegaysan, haddana toddoba jeer oo kale ayaan dembiyadiinna aawadood idiin edbin doonaa. ");
INSERT INTO som_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Waanan jebin doonaa kibirka xooggiinna, oo samadiinnana waxaan ka dhigi doonaa sida bir oo kale, dhulkiinnana sida naxaas oo kale. ");
INSERT INTO som_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Oo xooggiinnuna waxtarla'aan buu idinkaga dhammaan doonaa, waayo, dhulkiinnu midho ma dhali doono, oo dhirta dalka ku taalna midho kama soo bixin doonaan. ");
INSERT INTO som_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Oo haddaad i sii caasisaan oo aydaan i dhegaysan, toddoba jeer oo kale ayaan belaayo idiinku soo dejin doonaa siday dembiyadiinnu yihiin. ");
INSERT INTO som_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Oo waxaan dhexdiinna ku soo dayn doonaa dugaagga duurka, kuwaasoo carruurtiinna idinka dhifan doona, oo xoolihiinna baabbi'in doona, oo idin kala yarayn doona, oo jidadkiinnuna cidla bay noqon doonaan. ");
INSERT INTO som_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Oo weliba waxyaalahaas daraaddood haddaad edeb ku soo yeelan weydaan, laakiinse aad i sii caasisaan, ");
INSERT INTO som_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","markaas aniguna gees baan idinka ahaan doonaa oo waan idin layn doonaa, xataa toddoba jeer ayaan dembiyadiinna aawadood idiin layn doonaa. ");
INSERT INTO som_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Oo waxaan idinku soo dejin doonaa seef idinka aargudda aanadii axdiga, oo magaalooyinkiinna waad ku soo wada ururi doontaan, oo anna belaayo waan idinku dhex ridi doonaa, markaasaad cadowga u gacangeli doontaan. ");
INSERT INTO som_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Oo markaan usha kibistiinna jebiyo, toban naagood ayaa kibistiinna isku foorno ku dubi doonta, oo haddana waxay kibistiina idinku siin doonaan miisaan, oo kolkaad cuntaanna kama dhergi doontaan. ");
INSERT INTO som_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Oo haddaad waxyaalahaas oo dhan igu dhegaysan weydaan, illowse aad i sii caasisaan, ");
INSERT INTO som_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","markaasaan aniguna gees idinka ahaan doonaa, waanan xanaaqi doonaa, oo dembiyadiinna aawadoodna ayaan toddoba jeer oo kale idiin edbin doonaa. ");
INSERT INTO som_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Oo waxaad cuni doontaan hilibka wiilaashiinna, oo waxaad cuni doontaan hilibka gabdhihiinna. ");
INSERT INTO som_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Oo anigu meelihiinna sarsare waan dumin doonaa, oo sanamyadiinna qorraxdana waan wada baabbi'in doonaa, oo meydadkiinnana waxaan ku dul xoori doonaa meydka sanamyadiinna; oo naftayduna way idin karhi doontaa. ");
INSERT INTO som_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Oo magaalooyinkiinna baabba' waan ka dhigi doonaa, oo meeshiinna quduuska ahna cidla waan ka dhigi doonaa, oo weliba carafta fooxiinna udgoon ma aan ursan doono. ");
INSERT INTO som_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Oo weliba dalkana cidla baan ka dhigi doonaa, oo cadaawayaashiinna dalka dhex degganuna taas way la yaabi doonaan. ");
INSERT INTO som_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Oo waxaan idinku kala dhex firdhin doonaa quruumaha, oo seef gal la' waan idinla daba geli doonaa, dalkiinnuna cidla buu noqon doonaa, oo magaalooyinkiinnuna baabba' bay noqon doonaan. ");
INSERT INTO som_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Oo markaasaa dalku sabtiyadiisa ku raaxaysan doonaa intuu cidla yahay oo idinku aad joogtaan dalka cadaawayaashiinna oo dhan; oo wakhtigaas oo dhan dalku wuu iska nasan doonaa, oo wuxuu ku raaxaysan doonaa sabtiyadiisa. ");
INSERT INTO som_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Oo dalku intuu cidla yahay oo dhan wuu iska nasan doonaa, nasashadaas oo ah mid uusan sabtiyadiinna helin markaad degganaydeen. ");
INSERT INTO som_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Oo intii idinka hadhana waxaan qalbigooda ku ridi doonaa fulanimo, iyagoo dalalka cadaawayaashooda dhex jooga, oo sanqadha caleen dabaylu kaxaynayso ayaa iyaga eryan doonta, oo waxay uga carari doonaan sida qof seef uga cararo, oo iyadoo aan ninna eryanayn ayay iska daadan doonaan. ");
INSERT INTO som_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Oo iyagoo aan ninna eryanayn ayaa midkoodba midka kale ku turunturoon doonaa sidii iyagoo seef ka baqanaya. Oo innaba ma aad yeelan doontaan itaal aad cadaawayaashiinna isku hor taagtaan. ");
INSERT INTO som_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Waxaad ku dhex baabbi'i doontaan quruumaha, oo dalka cadaawayaashiinnuna waa idin dhammaysan doonaa. ");
INSERT INTO som_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Oo intii idinka hadhana iyagoo dalka cadaawayaashiinna jooga ayay xumaatadooda u dulloobi doonaan, oo weliba xumaatooyinkii awowayaashoodna ayay u dulloobi doonaan. ");
INSERT INTO som_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Wayna qiran doonaan xumaatadoodii iyo xumaatadii awowayaashood, iyo xadgudubkii ay igu xadgudbeen, iyo weliba caasinimadii ay igu caasiyeen ");
INSERT INTO som_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","oo aan aawadeed iyaga gees uga noqday, oo aan dalkii cadaawayaashooda u geeyey. Markaas hadday qalbigooda buuryoqabka ah hoosaysiiyaan, oo ay aqbalaan taqsiirta xumaatadooda, ");
INSERT INTO som_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","ayaan soo xusuusan doonaa axdigaygii aan Yacquub la dhigtay, iyo weliba axdigaygii aan Isxaaq la dhigtay, oo weliba waxaan kaloo soo xusuusan doonaa axdigaygii aan Ibraahim la dhigtay, oo dalkana waan soo xusuusan doonaa. ");
INSERT INTO som_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Oo iyagu dalka way ka tegi doonaan, oo wuxuu ku raaxaysan doonaa sabtiyadiisa intuu cidla yahay oo iyagu ay ka maqan yihiin oo dhan; oo iyaguna way aqbali doonaan taqsiirta xumaatadooda, maxaa yeelay, way diideen xukummadaydii, oo naftooduna qaynuunnadayday karahday. ");
INSERT INTO som_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Laakiinse in kastoo ay saas sameeyeen anigu intay dalka cadaawayaashooda joogaan oo dhan iyaga diidi maayo, karhina maayo, wada baabbi'inna maayo, oo axdigaygii aan la dhigtay jebin maayo, waayo, aniga ayaa ah Rabbiga Ilaahooda ah. ");
INSERT INTO som_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Laakiinse iyaga daraaddood ayaan u xusuusan doonaa axdigii aan la dhigtay awowayaashood, kuwaasoo aan, iyadoo ay quruumuhu u jeedaan, dalkii Masar uga soo bixiyey si aan iyaga Ilaah ugu ahaado, waayo, aniga ayaa Rabbiga ah. ");
INSERT INTO som_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Kuwaasu waa qaynuunnadii iyo xukummadii iyo sharciyadii uu Rabbigu u dhexaysiiyey isaga qudhiisa iyo reer binu Israa'iil oo uu Muuse ugu soo dejiyey Buur Siinay. ");
INSERT INTO som_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Markaasaa Rabbigu Muuse la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","Dadka reer binu Israa'iil la hadal oo waxaad ku tidhaahdaa, Haddii nin nidar galo, qofafka waa inay Rabbiga ugu ahaadaan sidaad ugu qiimaysa. ");
INSERT INTO som_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Oo inta labka ah oo jirta labaatan sannadood iyo ilaa lixdan sannadood qiimayntooda aad qiimayso waa inay ahaataa konton sheqel oo lacag ah oo le'eg sheqelka meesha quduuska ah. ");
INSERT INTO som_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Oo qofku hadduu dhaddig yahayna markaas qiimayntaadu ha ahaato soddon sheqel. ");
INSERT INTO som_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Oo qofku hadduu shan sannadood jiro iyo ilaa labaatan sannadood, markaas kii lab waxaad ku qiimaysaa labaatan sheqel, oo tii dhaddigna waxaad ku qiimaysaa toban sheqel. ");
INSERT INTO som_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Oo haddii qofku jiro bil iyo ilaa shan sannadood, markaas qofkii lab waxaad ku qiimaysaa shan sheqel oo lacag ah, tii dhaddigna waxaad ku qiimaysaa saddex sheqel oo lacag ah. ");
INSERT INTO som_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Oo haddii qofku lixdan jir yahay amase ka sii weyn yahay, hadduu lab yahay waxaad ku qiimaysaa shan iyo toban sheqel, hadduu dhaddig yahayna waxaad ku qiimaysaa toban sheqel. ");
INSERT INTO som_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Laakiinse qofku hadduu ka miskiinsan yahay intaad ku qiimaysay, markaas waa in la soo taagaa wadaadka hortiisa, oo wadaadku waa inuu qiimeeyaa, oo qofkii nidarka galay intuu awoodo waa in wadaadku ku qiimeeyaa. ");
INSERT INTO som_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Oo neef Rabbiga qurbaan loogu bixiyo hadduu yahayna, wax alla wixii qofi Rabbiga saas ugu bixiyaa quduus bay ahaan doonaan. ");
INSERT INTO som_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Oo isagu waa inuusan doorin, ama waa inuusan neef fiican mid xun ku beddelin, ama neef xun mid fiican ku beddelin, oo hadduu neef neef kale ku beddelo, markaas neefkii hore iyo kii lagu beddelayba waa inay quduus wada ahaadaan. ");
INSERT INTO som_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Oo neefku hadduu yahay neef nijaas ah oo aan Rabbiga qurbaan loogu bixin, markaas isagu neefka ha soo taago wadaadka hortiisa, ");
INSERT INTO som_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","oo wadaadku ha qiimeeyo, hadduu xun yahay iyo hadduu fiican yahayba, oo adiga wadaadka ahu intii aad ku qiimayso waa inay ahaataa. ");
INSERT INTO som_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Laakiinse isagu hadduu doonayo inuu furto, waa inuu ku sii daraa intii aad ku qiimaysay oo shan meelood loo dhigay meesheed. ");
INSERT INTO som_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Oo haddii qof doonayo inuu gurigiisa quduus uga dhigo Rabbiga, markaas wadaadku waa inuu qiimeeyaa hadduu xun yahay iyo hadduu fiican yahayba, oo sidii wadaadku ku qiimeeyo ha ahaato. ");
INSERT INTO som_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Oo kii quduus ka dhigay hadduu doonayo inuu gurigiisii soo furto, markaas ha ku sii daro lacagtii aad ku qiimaysay oo shan meelood loo dhigay meesheed, markaas isagaa lahaan doona. ");
INSERT INTO som_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Oo haddii nin doonayo inuu Rabbiga quduus uga dhigo qaar ka mid ah beertuu leeyahay, markaas waxaad ku qiimaysaa inta abuurkeedu dhan yahay; xomeer muggiis oo shaciir abuur ah waa in lagu qiimeeyaa konton sheqel oo lacag ah. ");
INSERT INTO som_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Oo beertiisa hadduu quduus ka dhigo oo uu ka bilaabo sannadda yubilii ah, markaas intaad ku qiimaysay ha ahaato. ");
INSERT INTO som_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Laakiinse hadduu beertiisa quduus ka dhigo sannadda yubilii ah dabadeed, markaas wadaadku waa inuu lacagta u xisaabaa intay yihiin sannadaha ka dhiman sannadda yubilii ah, oo intaad ku qiimaysayna waa in wax laga sii dhimaa. ");
INSERT INTO som_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Oo kii beerta quduus ka dhigay hadduu doonayo inuu soo furto markaas waa inuu ku sii daraa lacagtii aad ku qiimaysay oo shan meelood loo dhigay meesheed, oo dabadeedna mar labaad buu mulkin doonaa. ");
INSERT INTO som_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Laakiinse hadduusan doonayn inuu beerta soo furto, ama hadduu beerta nin kale ka iibiyey, markaas mar dambe waa inaan la soo furan, ");
INSERT INTO som_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","laakiin beertu markay wareegto sannadda yubilii ah, waxay quduus u ahaan doontaa Rabbiga sidii beer isaga loo soocay, hantideedana waxaa yeelan doona wadaadka. ");
INSERT INTO som_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Oo hadduu Rabbiga quduus uga dhigo beer uu soo iibsaday oo aan ahayn beerta hantidiisa ah, ");
INSERT INTO som_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","markaas wadaadku waa inuu xisaabaa qiimihii aad ku qiimaysay tan iyo sannadda yubilii ah, oo isla maalintaas isagu waa inuu wixii aad beerta ku qiimaysay u bixiyaa sida wax Rabbiga quduus u ah. ");
INSERT INTO som_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Oo sannadda yubilii ahna beertu waxay u noqon doontaa kii laga soo iibsaday, kaasoo ah kii dhulka hanti u leh. ");
INSERT INTO som_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Oo waxa aad wax ku qiimayso oo dhammu waa inay waafaqsanaadaan sheqelka meesha quduuska ah, oo sheqelku waa inuu ahaadaa labaatan geeraah. ");
INSERT INTO som_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Laakiinse xayawaanka curadkooda Rabbiga gooni ahaanta loogu soocay ninna waa inuusan quduus ka dhigin, hadduu dibi yahay iyo hadduu ido yahayba, waayo, waxaa iska leh Rabbiga. ");
INSERT INTO som_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Oo hadduu yahay neef nijaas ah markaas isagu waa inuu ku furtaa intii aad ku qiimayso, oo weliba waa inuu ku sii daraa intaas oo shan meelood loo dhigay meesheed, oo haddaan la soo furanna waa in lagu iibiyaa intii aad ku qiimayso. ");
INSERT INTO som_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Habase yeeshee wixii gooni loo sooco, oo qof waxyaalihiisa oo dhan Rabbiga uga sooco, hadday waxaasu yihiin qof, ama neef, ama beerta hantidiisa ah, waa inaan innaba la iibin ama la furan, waayo, wax kasta oo gooni loo sooco waa wax Rabbiga ugu wada quduusan. ");
INSERT INTO som_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Oo qof alla qofkii gooni loo sooco oo dadka laga sooco oo dhan waa inaan innaba la soo furan, laakiinse hubaal waa in la dilaa. ");
INSERT INTO som_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Oo meeltobnaadka waxa dalka ka baxa oo dhan hadday yihiin dhulka iniinihiisa ama hadday yihiin midhaha dhirtaba, Rabbigaa iska leh, oo waa wax Rabbiga quduus u ah. ");
INSERT INTO som_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Oo haddii qof doonayo inuu wax meeltobnaadkiisii ah furto waa inuu ku daraa waxaas oo shan meelood loo dhigay meeshood. ");
INSERT INTO som_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Oo kulli meeltobnaadka lo'da ah ama kan adhiga ah oo dhan, wax alla wixii lagu tiriyo ee hoos maro usha adhijirka, meeltobnaadku waa inuu Rabbiga quduus u ahaadaa. ");
INSERT INTO som_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Oo neefkaasu inuu xun yahay iyo inuu fiican yahay, isagu waa inuusan kala hubsan, waana inuusan beddelin, oo kolnaba hadduu beddelo, markaas isagii iyo kii lagu beddelayba waa inay quduus wada ahaadaan ee aan la soo furan. ");
INSERT INTO som_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Kuwanu waa amarradii Rabbigu Muuse kaga amray Buur Siinay oo uu reer binu Israa'iil ugu soo dhiibay.");
INSERT INTO som_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Rabbigu wuxuu Muuse kula hadlay cidladii Siinay, isagoo ku jira teendhadii shirka, bishii labaad maalinteedii kowaad, oo ah sannaddii labaad oo ay dalkii Masar ka soo bexeen dabadeed, oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","Shirka reer binu Israa'iil oo dhan u soo tiriya qolo qolo iyo reer reer, sida ay tirada magacyadoodu tahay, nin kasta madax madax u tiriya. ");
INSERT INTO som_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Oo waxaad tirisaa intii labaatan sannadood jirta iyo intii ka sii weyn. Inta reer binu Israa'iil oo dagaal u bixi karta oo dhan adiga iyo Haaruun waa inaad koox koox u tirisaan. ");
INSERT INTO som_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Oo waa inuu idinla jiraa qabiil kasta nin ka mid ah oo reerka aabbihiis madax u ah. ");
INSERT INTO som_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Oo nimanka isla kiin taagi doona magacyadooduna waa kuwan: reer Ruubeen waxaa ka iman Eliisuur ina Shedeeyuur. ");
INSERT INTO som_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Reer Simecoonna waxaa ka iman Shelumii'eel ina Suuriishadday. ");
INSERT INTO som_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Reer Yahuudahna waxaa ka iman Naxshoon ina Cammiinaadaab. ");
INSERT INTO som_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Reer Isaakaarna waxaa ka iman Netaneel ina Suucaar. ");
INSERT INTO som_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Reer Sebulunna waxaa ka iman Elii'aab ina Xeelon. ");
INSERT INTO som_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Oo kuwa reer Yuusufna waxaa reer Efrayim ka iman Eliishaamaac ina Cammiihuud: oo waxaa reer Manaseh ka iman Gamalii'eel ina Fedaahsuur. ");
INSERT INTO som_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Oo reer Benyaamiinna waxaa ka iman Abiidaan ina Gidconii. ");
INSERT INTO som_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Oo reer Daanna waxaa ka iman Axiiceser ina Cammiishadday. ");
INSERT INTO som_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Oo reer Aasheerna waxaa ka iman Fagcii'eel ina Cokraan. ");
INSERT INTO som_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Oo reer Gaadna waxaa ka iman Eliyaasaaf ina Decuu'eel. ");
INSERT INTO som_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Oo reer Naftaalina waxaa ka iman Axiirac ina Ceynaan. ");
INSERT INTO som_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Kuwanu waa kuwa shirka looga yeedhay oo amiirro u ahaa qabiilooyinka aabbayaashood, oo waxay ahaayeen madaxdii kumanyaalka reer binu Israa'iil. ");
INSERT INTO som_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Markaasaa Muuse iyo Haaruun waxay kaxaysteen nimankaas la magacaabay, ");
INSERT INTO som_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","oo shirkii oo dhan ayay isu soo ururiyeen bishii labaad maalinteedii kowaad, oo waxay u soo abtirsadeen qolo qolo iyo reer reer, oo ay madax madax u tiriyeen sida tirada magacyadoodu ay ahayd intii labaatan sannadood jirtay iyo intii ka sii weynaydba. ");
INSERT INTO som_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Oo Muusena wuxuu iyagii cidlada Siinay ugu tiriyey sidii Rabbigu ku amray. ");
INSERT INTO som_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Oo reer Ruubeen oo ahaa curadkii Israa'iil farcankoodii, qolo qolo iyo reer reer, sidii ay tirada magacyadoodu ahayd markii madax madax loo tiriyey, nin kasta oo labaatan sannadood jiray iyo intii ka sii weynaydba, in alla intii dagaal u bixi kartay oo dhan, ");
INSERT INTO som_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","intii iyaga laga tiriyey oo ahayd qabiilka reer Ruubeen waxay ahaayeen lix iyo afartan kun iyo shan boqol. ");
INSERT INTO som_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Oo reer Simecoon farcankoodii, qolo qolo iyo reer reer, kuwii iyaga laga tiriyey sidii ay tirada magacyadoodu ahayd markii madax madax loo tiriyey, nin kasta oo labaatan sannadood jiray iyo intii ka sii weynaydba, in alla intii dagaal u bixi kartay oo dhan, ");
INSERT INTO som_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","intii iyaga laga tiriyey oo ahayd qabiilka reer Simecoon waxay ahaayeen sagaal iyo konton kun iyo saddex boqol. ");
INSERT INTO som_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Oo reer Gaadna farcankoodii, qolo qolo iyo reer reer, sidii ay tirada magacyadoodu ahayd, intii labaatan sannadood jirtay iyo intii ka sii weynaydba, in alla intii dagaal u bixi kartay oo dhan, ");
INSERT INTO som_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","intii iyaga laga tiriyey oo ahayd qabiilka reer Gaad waxay ahaayeen shan iyo afartan kun iyo lix boqol iyo konton. ");
INSERT INTO som_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Oo reer Yahuudahna farcankoodii, qolo qolo iyo reer reer, sidii ay tirada magacyadoodu ahayd, intii labaatan sannadood jirtay iyo intii ka sii weynaydba, in alla intii dagaal u bixi kartay oo dhan, ");
INSERT INTO som_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","intii iyaga laga tiriyey oo ahayd qabiilka reer Yahuudah waxay ahaayeen afar iyo toddobaatan kun iyo lix boqol. ");
INSERT INTO som_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Oo reer Isaakaarna farcankoodii, qolo qolo iyo reer reer, sidii ay tirada magacyadoodu ahayd, intii labaatan sannadood jirtay iyo intii ka sii weynaydba, in alla intii dagaal u bixi kartay oo dhan, ");
INSERT INTO som_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","intii iyaga laga tiriyey oo ahayd qabiilka reer Isaakaar waxay ahaayeen afar iyo konton kun iyo afar boqol. ");
INSERT INTO som_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Oo reer Sebulunna farcankoodii, qolo qolo iyo reer reer, sidii ay tirada magacyadoodu ahayd, intii labaatan sannadood jirtay iyo intii ka sii weynaydba, in alla intii dagaal u bixi kartay oo dhan, ");
INSERT INTO som_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","intii iyaga laga tiriyey oo ahayd qabiilka reer Sebulun waxay ahaayeen toddoba iyo konton kun iyo afar boqol. ");
INSERT INTO som_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Oo kuwa reer Yuusuf oo ahaa reer Efrayim farcankoodii, qolo qolo iyo reer reer, sidii ay tirada magacyadoodu ahayd, intii labaatan sannadood jirtay iyo intii ka sii weynaydba, in alla intii dagaal u bixi kartay oo dhan, ");
INSERT INTO som_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","intii iyaga laga tiriyey oo ahayd qabiilkii reer Efrayim waxay ahaayeen afartan kun iyo shan boqol. ");
INSERT INTO som_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Oo reer Manasehna farcankoodii, qolo qolo iyo reer reer, sidii ay tirada magacyadoodu ahayd, intii labaatan sannadood jirtay iyo intii ka sii weynaydba, in alla intii dagaal u bixi kartay oo dhan, ");
INSERT INTO som_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","intii iyaga laga tiriyey oo ahayd qabiilka reer Manaseh waxay ahaayeen laba iyo soddon kun iyo laba boqol. ");
INSERT INTO som_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Oo reer Benyaamiinna farcankoodii, qolo qolo iyo reer reer, sidii ay tirada magacyadoodu ahayd, intii labaatan sannadood jirtay iyo intii ka sii weynaydba, in alla intii dagaal u bixi kartay oo dhan, ");
INSERT INTO som_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","intii iyaga laga tiriyey oo ahayd qabiilka reer Benyaamiin waxay ahaayeen shan iyo soddon kun iyo afar boqol. ");
INSERT INTO som_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Oo reer Daanna farcankoodii, qolo qolo iyo reer reer, sidii ay tirada magacyadoodu ahayd, intii labaatan sannadood jirtay iyo intii ka sii weynaydba, in alla intii dagaal u bixi kartay oo dhan, ");
INSERT INTO som_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","intii iyaga laga tiriyey oo ahayd qabiilka reer Daan waxay ahaayeen laba iyo lixdan kun iyo toddoba boqol. ");
INSERT INTO som_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Oo reer Aasheerna farcankoodii, qolo qolo iyo reer reer, sidii ay tirada magacyadoodu ahayd, intii labaatan sannadood jirtay iyo intii ka sii weynaydba, in alla intii dagaal u bixi kartay oo dhan, ");
INSERT INTO som_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","intii iyaga laga tiriyey oo ahayd qabiilka reer Aasheer waxay ahaayeen kow iyo afartan kun iyo shan boqol. ");
INSERT INTO som_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Oo reer Naftaalina farcankoodii, qolo qolo iyo reer reer, sidii ay tirada magacyadoodu ahayd, intii labaatan sannadood jirtay iyo intii ka sii weynaydba, in alla intii dagaal u bixi kartay oo dhan, ");
INSERT INTO som_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","intii iyaga laga tiriyey oo ahayd qabiilka reer Naftaali waxay ahaayeen saddex iyo konton kun iyo afar boqol. ");
INSERT INTO som_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Kuwaasu waa kuwii la tiriyey, oo ay tiriyeen Muuse iyo Haaruun iyo amiirradii reer binu Israa'iil oo laba iyo toban nin ahaa oo midkood kastaba loo soocay reerkii aabbihiis. ");
INSERT INTO som_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Haddaba intii reer binu Israa'iil oo dhan ee reerihii aabbayaashood laga tiriyey, intii labaatan sannadood jirtay iyo intii ka sii weynaydba, in alla intii dagaal u bixi kartay oo dhan oo reer binu Israa'iil dhex joogtay, ");
INSERT INTO som_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","xataa intii la tiriyey oo dhammu waxay ahaayeen lix boqol iyo saddex kun, iyo shan boqol iyo konton. ");
INSERT INTO som_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Laakiinse qabiilkii reer Laawi reer reer looma tirin. ");
INSERT INTO som_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Waayo, Rabbigu waa la hadlay Muuse oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","Qabiilka reer Laawi oo keliya waa inaadan tirin, oo reer binu Israa'iilna waa inaadan tiradooda ku dhex darin, ");
INSERT INTO som_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","laakiinse reer Laawi waxaad u doorataa inay u taliyaan taambuugga maragga, iyo alaabtiisa oo dhan, iyo waxa uu isagu leeyahay oo dhan. Iyagu waa inay taambuugga iyo alaabtiisa oo dhan sidaan, oo ay u adeegaan, oo ay taambuugga hareerihiisa degaan. ");
INSERT INTO som_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Oo markii taambuuggu hor u dhaqaaqayo reer Laawi waa inay furaan, markii taambuugga la dhisayona reer Laawi waa inay dhisaan, oo shisheeyihii u soo dhowaadana waa in la dilaa. ");
INSERT INTO som_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Oo reer binu Israa'iilna markay teendhooyinkooda dhistaan, nin waluba tiisa xeradiisa ha ka dhisto, oo nin waluba calankiisa ha uga ag dhisto sida ciidammadoodu yihiin. ");
INSERT INTO som_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Laakiinse reer Laawi waa inay teendhooyinkooda ka dhistaan taambuugga maragga hareerihiisa, si aan cadho ugu soo degin shirka reer binu Israa'iil; oo reer Laawi waa inay u taliyaan taambuugga maragga. ");
INSERT INTO som_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Oo reer binu Israa'iil sidaasay yeeleen; oo sidii Rabbigu Muuse ku amray oo dhan ayay wada yeeleen. ");
INSERT INTO som_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Markaasaa Rabbigu la hadlay Muuse iyo Haaruun, oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","Reer binu Israa'iil waa in nin waluba teendhadiisa ka ag dhistaa calankiisa, iyagoo ag jooga bandiiradihii reerka aabbahood, oo waa inay teendhooyinkooda ka dhistaan meel teendhada shirka ka hor jeedda oo hareeraheeda ah. ");
INSERT INTO som_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Oo kuwa ka dhistaa xagga bari dhanka qorrax ka soo baxa waa inay ahaadaan kuwa calanka xerada reer Yahuudah sida ciidammadoodu yihiin, oo amiirka reer Yahuudahna waa inuu ahaadaa Naxshoon ina Cammiinaadaab. ");
INSERT INTO som_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Oo ciidankiisii kuwii laga tiriyey waxay ahaayeen afar iyo toddobaatan kun iyo lix boqol. ");
INSERT INTO som_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Oo kuwa ku xiga oo agtiisa ka dhistaana waa inay ahaadaan qabiilka reer Isaakaar, oo amiirka reer Isaakaarna waa inuu ahaadaa Netaneel ina Suucaar. ");
INSERT INTO som_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Oo ciidankiisii kuwii laga tiriyey waxay ahaayeen afar iyo konton kun iyo afar boqol. ");
INSERT INTO som_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Qabiilka reer Sebulunna, oo amiirka reer Sebulunna waa inuu ahaadaa Elii'aab ina Xeelon. ");
INSERT INTO som_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Oo ciidankiisii kuwii laga tiriyeyna waxay ahaayeen toddoba iyo konton kun iyo afar boqol. ");
INSERT INTO som_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Oo kulli intii xerada reer Yahuudah laga tiriyey oo dhammu waxay ahaayeen boqol iyo lix iyo siddeetan kun iyo afar boqol, siday ciidammadoodu yihiin, oo iyagu waa inay marka hore baxaan. ");
INSERT INTO som_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Oo xagga koonfureedna waa inuu ahaadaa calanka xerada reer Ruubeen, siday ciidammadoodu yihiin, oo amiirka reer Ruubeenna waa inuu ahaadaa Eliisuur ina Shedeeyuur. ");
INSERT INTO som_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Oo ciidankiisii kuwii laga tiriyey waxay ahaayeen lix iyo afartan kun iyo shan boqol. ");
INSERT INTO som_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Oo kuwa ku xigaana waa inay ahaadaan qabiilka reer Simecoon. Oo amiirka reer Simecoonna waa inuu ahaadaa Shelumii'eel ina Suuriishadday. ");
INSERT INTO som_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Oo ciidankiisii kuwii laga tiriyey waxay ahaayeen sagaal iyo konton kun iyo saddex boqol. ");
INSERT INTO som_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Qabiilka reer Gaadna, oo amiirka reer Gaadna waa inuu ahaadaa Eliyaasaaf ina Recuu'eel. ");
INSERT INTO som_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Oo ciidankiisii kuwii laga tiriyey waxay ahaayeen shan iyo afartan kun iyo lix boqol iyo konton. ");
INSERT INTO som_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Oo kulli intii xeradii reer Ruubeen laga tiriyey waxay ahaayeen boqol iyo kow iyo konton kun iyo afar boqol iyo konton, siday ciidammadoodu ahaayeen. Oo iyana waa inay marka labaad baxaan. ");
INSERT INTO som_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Dabadeedna teendhada shirku waa inay baxdaa, iyadoo kooxda reer Laawi ku dhex jirta kooxaha kale, oo siday u degaan waa inay u baxaan, nin kasta oo meeshiis ku jira oo calankooda ag jooga. ");
INSERT INTO som_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Oo dhanka galbeedna waa inuu ahaadaa calanka xerada reer Efrayim siday ciidammadoodu yihiin, oo amiirka reer Efrayimna waa inuu ahaadaa Eliishaamaac ina Cammiihuud. ");
INSERT INTO som_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Oo ciidankiisii kuwii laga tiriyey waxay ahaayeen afartan kun iyo shan boqol. ");
INSERT INTO som_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Oo qabiilka reer Manaseh waa inuu ku xigaa; oo amiirka reer Manasehna waa inuu ahaadaa Gamalii'eel ina Fedaahsuur. ");
INSERT INTO som_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Oo ciidankiisii kuwii laga tiriyey waxay ahaayeen laba iyo soddon kun iyo laba boqol. ");
INSERT INTO som_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Qabiilkii reer Benyaamiinna, oo amiirka reer Benyaamiinna waa inuu ahaadaa Abiidaan ina Gidconii. ");
INSERT INTO som_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Oo ciidankiisii kuwii laga tiriyey waxay ahaayeen shan iyo soddon kun iyo afar boqol. ");
INSERT INTO som_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Oo kulli intii xerada reer Efrayim laga tiriyey waxay ahaayeen boqol iyo siddeed kun iyo boqol, siday ciidammadoodii ahaayeen. Oo iyana waa inay marka saddexaad baxaan. ");
INSERT INTO som_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Oo dhanka woqooyina waa inuu ahaadaa calanka xerada reer Daan siday ciidammadoodu yihiin, oo amiirka reer Daanna waa inuu ahaadaa Axiiceser ina Cammiishadday. ");
INSERT INTO som_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Oo ciidankiisii kuwii laga tiriyey waxay ahaayeen laba iyo lixdan kun iyo toddoba boqol. ");
INSERT INTO som_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Oo qabiilka reer Aasheer waa inuu ku xigaa, oo amiirka reer Aasheerna waa inuu ahaadaa Fagcii'eel ina Cokraan. ");
INSERT INTO som_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Oo ciidankiisii kuwii laga tiriyey waxay ahaayeen kow iyo afartan kun iyo shan boqol. ");
INSERT INTO som_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Qabiilkii reer Naftaalina, oo amiirka reer Naftaalina waa inuu ahaadaa Axiirac ina Ceynaan. ");
INSERT INTO som_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Oo ciidankiisii kuwii laga tiriyey waxay ahaayeen saddex iyo konton kun iyo afar boqol. ");
INSERT INTO som_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Oo kulli intii xerada reer Daan laga tiriyey waxay ahaayeen boqol iyo toddoba iyo konton kun iyo lix boqol. Oo iyagu waa inay baxaan marka ugu dambaysa, iyagoo calammadooda ag jooga. ");
INSERT INTO som_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Kuwaasu waa intii laga tiriyey reer binu Israa'iil siday reerahoodu ahaayeen. Kulli intii xerooyinka laga tiriyey sidii ciidammadoodii ahaayeen waxay ahaayeen lix boqol iyo saddex kun iyo shan boqol iyo konton. ");
INSERT INTO som_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Laakiinse reer Laawi laguma tirin reer binu Israa'iil, waayo, sidaas ayaa Rabbigu Muuse ku amray. ");
INSERT INTO som_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Sidaasay reer binu Israa'iil yeeleen, oo kulli wixii Rabbigu Muuse ku amray, sidaasay dhammaan uga ag dhisteen calammadoodii, oo sidaasay ugu bexeen siday qoladoodii iyo reerahoodii ahaayeen. ");
INSERT INTO som_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Haddaba kuwanu waxa weeye farcammadii Haaruun iyo Muuse waagii Rabbigu Muuse kula hadlay Buur Siinay. ");
INSERT INTO som_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Oo kuwanu waa wiilashii Haaruun magacyadoodii, Naadaab oo curadkii ahaa, iyo Abiihuu, iyo Elecaasaar, iyo Iitaamaar. ");
INSERT INTO som_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Kuwaasu waa wiilashii Haaruun magacyadoodii, oo waa wadaaddadii la subkay oo uu gooni uga dhigay inay adeegaan shuqulka wadaadnimada. ");
INSERT INTO som_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Naadaab iyo Abiihuu waxay ku dhinteen Rabbiga hortiisa, markay dab qalaad ku bixiyeen Rabbiga hortiisa iyagoo cidlada Siinay jooga, oo iyagu carruurna ma ay lahayn. Markaasay Elecaasaar iyo Iitaamaar shuqulkii wadaadnimada kaga adeegi jireen aabbahood Haaruun hortiisa. ");
INSERT INTO som_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Kolkaasaa Rabbigu Muuse la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","Qabiilka reer Laawi soo dhowee oo wadaadka Haaruun hortiisa keen inay isaga u adeegaan. ");
INSERT INTO som_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Oo iyagu waa inay amarkiisa iyo amarka shirka oo dhan ku yeelaan teendhada shirka horteeda si ay hawsha taambuugga u sameeyaan. ");
INSERT INTO som_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Oo waa inay dhawraan alaabta teendhada shirka oo dhan, iyo amarka reer binu Israa'iil, si ay hawsha taambuugga u sameeyaan. ");
INSERT INTO som_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Oo adigu waa inaad reer Laawi siisaa Haaruun iyo wiilashiisaba, oo iyaga dhammaantood waa la siiyey reer binu Israa'iil aawadood. ");
INSERT INTO som_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Oo waa inaad Haaruun iyo wiilashiisa doorataa, oo iyagu waa inay dhawraan wadaadnimadooda, oo shisheeyihii u soo dhowaadana waa in la dilaa. ");
INSERT INTO som_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Markaasaa Rabbigu Muuse la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","Oo bal eeg, anna waxaan reer Laawi kala dhex baxay reer binu Israa'iil intii aan ka qaadan lahaa curadyada reer binu Israa'iil ee maxalka furta oo dhan, oo reer Laawi waxay ahaanayaan kuwaygii, ");
INSERT INTO som_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","waayo, curadyada oo dhan anigaa iska leh. Maalintii aan curadyadii Masar oo dhan wada laayay ayaan quduus ka wada dhigtay curadyada reer binu Israa'iil, dad iyo duunyoba, oo iyagu kuwaygay ahaanayaan, waayo, aniga ayaa Rabbiga ah. ");
INSERT INTO som_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Oo haddana Rabbigu wuxuu Muuse kula hadlay cidlada Siinay, oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","Reer Laawi oo dhan u soo wada tiri reer reer iyo qolo qolo. Nin kasta oo bil jira ama ka sii weyn waa inaad tirisaa. ");
INSERT INTO som_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Markaasaa Muuse iyagii u tiriyey sidii eraygii Rabbigu ahaa oo uu isaga ugu amray. ");
INSERT INTO som_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Kuwanu waxay ahaayeen wiilashii Laawi magacyadoodii: Gershoon, iyo Qohaad, iyo Meraarii. ");
INSERT INTO som_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Oo kuwanuna waa magacyadii wiilashii Gershoon siday qolooyinkoodu yihiin, Libnii iyo Shimcii. ");
INSERT INTO som_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Oo wiilashii Qohaad siday qolooyinkoodu yihiin waa Camraam, iyo Isehaar, iyo Xebroon, iyo Cusii'eel. ");
INSERT INTO som_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Oo wiilashii Meraariina siday qolooyinkoodu yihiin waa Maxlii iyo Mushii, kuwanu waa qolooyinkii reer Laawi siday reerahoodu yihiin. ");
INSERT INTO som_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Oo Gershoon waxaa ka soo farcamay reer Libnii iyo reer Shimcii, kuwaasu waa qolooyinkii reer Gershoon. ");
INSERT INTO som_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Oo kuwii iyaga laga tiriyey siday ahayd tiradii kuwii lab ahaa oo dhan, intii bil jirtay ama ka sii weynayd, kulli intoodii la tiriyey waxay ahaayeen toddoba kun iyo shan boqol. ");
INSERT INTO som_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Oo reer Gershoon qolooyinkoodii waa inay taambuugga dabadiisa xagga galbeedka teendhooyinkooda ka dhistaan. ");
INSERT INTO som_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Oo amiirka reer Gershoonna waa inuu ahaadaa Eliyaasaaf ina Laa'eel. ");
INSERT INTO som_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Oo reer Gershoonna waa inay teendhada shirka ugu taliyaan taambuuga, iyo Teendhada, iyo dedkeeda, iyo daaha iridda teendhada shirka, ");
INSERT INTO som_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","iyo barxadda daahyadeeda, iyo daaha iridda barxadda oo taambuugga iyo meesha allabariga ku wareegsan iyo xadhkihii hawsha lagu qabto oo dhan. ");
INSERT INTO som_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Oo Qohaadna waxaa ka soo farcamay reer Camraam, iyo reer Isehaar, iyo reer Xebroon, iyo reer Cusii'eel; kuwaasu waa qolooyinkii reer Qohaad. ");
INSERT INTO som_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Siday ahayd tiradii kuwii lab ahaa oo dhan intii bil jirtay ama ka sii weynayd waxay ahaayeen siddeed kun iyo lix boqol, oo waxay u taliyeen meesha quduuska ah. ");
INSERT INTO som_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Oo qolooyinka reer Qohaad waa inay taambuugga dhankiisa koonfureed teendhooyinkooda ka dhistaan. ");
INSERT INTO som_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Oo amiirka reer Qohaadna waa inuu ahaadaa Eliisaafaan ina Cusii'eel. ");
INSERT INTO som_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Oo iyana waxay u talin doonaan sanduuqa, iyo miiska, iyo laambadda, iyo meelaha allabariga, iyo weelasha meesha quduuska ah oo ay ku adeegaan, iyo daaha, iyo hawsha oo dhan. ");
INSERT INTO som_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Oo Elecaasaar ina wadaadka Haaruun waa inuu ahaadaa amiirka amiirrada reer Laawi, oo wuxuu korka ka ilaalin doonaa kuwa u taliya meesha quduuska ah. ");
INSERT INTO som_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Oo Meraariina waxaa ka soo farcamay reer Maxlii iyo reer Mushii, kuwaasu waa qolooyinkii reer Meraarii. ");
INSERT INTO som_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Oo kuwoodii loo tiriyey siday ahayd tiradii kuwii labka ahaa oo dhan, intii bil jirtay ama ka sii weynayd, waxay ahaayeen lix kun iyo laba boqol. ");
INSERT INTO som_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Oo qabiilka reer Meraarii amiirkoodii wuxuu ahaa Surii'eel ina Abiixayil, oo iyana waa inay taambuugga dhankiisa woqooyi teendhooyinkooda ka dhistaan. ");
INSERT INTO som_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Oo reer Meraarii waxaa loo amray inay u taliyaan taambuugga looxyadiisa, iyo ulihiisa gudban, iyo tiirarkiisa, iyo saldhigyadiisa, iyo alaabtiisa oo dhan, iyo hawshiisa oo dhan, ");
INSERT INTO som_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","iyo tiirarka barxadda ku wareegsanna, iyo saldhigyadooda, iyo musaamiirtooda iyo xadhkahooda. ");
INSERT INTO som_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Oo kuwa teendhooyinkooda ka dhistaa taambuugga xaggiisa bari iyo teendhada shirka horteeda xagga qorrax ka soo baxa waa inay ahaadaan Muuse iyo Haaruun iyo wiilashiisa, oo waxay reer binu Israa'iil ugu talinayaan meesha quduuska ah; oo shisheeyaha u soo dhowaadana waa in la dilaa. ");
INSERT INTO som_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Oo kulli intii reer Laawi ah ee la tiriyey, oo Muuse iyo Haaruun ay qolo qolo ugu tiriyeen amarkii Rabbiga, kuwii lab ahaa oo dhan oo bil jiray ama ka sii weynaa, waxay ahaayeen laba iyo labaatan kun. ");
INSERT INTO som_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Markaasaa Rabbigu wuxuu Muuse ku yidhi, Tiri curadyada labka ah oo reer binu Israa'iil oo dhan, intii bil jirta ama ka sii weyn, oo magacyadooda ku soo xisaab. ");
INSERT INTO som_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Oo waa inaad ii qaaddaa reer Laawi intii aad ii qaadi lahayd curadyada reer binu Israa'iil oo dhan, oo waa inaad xoolaha reer Laawina ii qaaddaa intii aad ii qaadi lahayd curadyada xoolaha reer binu Israa'iil oo dhan, waayo, aniga ayaa Rabbiga ah. ");
INSERT INTO som_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Markaasaa Muuse curadyadii reer binu Israa'iil oo dhan u tiriyey sidii Rabbigu ugu amray. ");
INSERT INTO som_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Oo curadyadii labka ahaa oo dhammu, sidii tirada magacyadoodu ahayd, intii bil jirtay ama ka sii weynayd, kuwii iyaga laga soo tiriyey waxay ahaayeen laba iyo labaatan kun iyo laba boqol iyo saddex iyo toddobaatan. ");
INSERT INTO som_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Markaasaa Rabbigu Muuse la hadlay, oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","Reer Laawi ii qaad intii aad ii qaadi lahayd curadyada reer binu Israa'iil oo dhan, oo xoolaha reer Laawina ii qaad intii aad ii qaadi lahayd xoolaha reer binu Israa'iil, oo reer Laawi kuwaygay ahaanayaan, waayo, aniga ayaa Rabbiga ah. ");
INSERT INTO som_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Oo labada boqol iyo saddex iyo toddobaatanka curad oo reer binu Israa'iil oo ka sii badan reer Laawi, ");
INSERT INTO som_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","madaxtiriskiiba waxaad iigu madax furataa shan sheqel oo le'eg sheqelka meesha quduuska ah. (Sheqelku waa labaatan geeraah.) ");
INSERT INTO som_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Oo tiradooda dheeraadka ah lacagta lagu madax furtay waa inaad Haaruun iyo wiilashiisa siisaa. ");
INSERT INTO som_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Markaasaa Muuse lacagtii ka qaaday kuwii ka sii badnaa kuwii lagu madax furtay reer Laawi. ");
INSERT INTO som_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Oo curadyadii reer binu Israa'iil ayuu ka qaaday lacagtii, oo ahayd kun iyo saddex boqol iyo shan iyo lixdan sheqel oo le'eg sheqelka meesha quduuska ah. ");
INSERT INTO som_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Oo Muuse lacagtii madaxfurashada ahayd wuxuu u dhiibay Haaruun iyo wiilashiisii, siduu ahaa eraygii Rabbigu Muuse ku amray. ");
INSERT INTO som_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Markaasaa Rabbigu Muuse iyo Haaruun la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","Reer Qohaad qolo qolo iyo reer reer uga soo tiri reer Laawi, ");
INSERT INTO som_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","intii soddon sannadood jirta iyo intii ka sii weyn ilaa tan iyo konton jir dhammaan intii hawsha gasha si ay shuqulka teendhada shirka u sameeyaan. ");
INSERT INTO som_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Tanu waa hawshii reer Qohaad ee ku jirtay teendhada shirka. Waa inay waxyaalaha ugu wada quduusan ka adeegaan. ");
INSERT INTO som_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Markii dadkii xeradu ay guurayaan Haaruun iyo wiilashiisu waa inay galaan oo iyagu waa inay daaha ilxidhka ah soo dejiyaan oo ku daboolaan sanduuqa maragga. ");
INSERT INTO som_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Oo markaas dushooda waa inay ded ah harag adhidibadeed saaraan, oo ay ku kala dul bixiyaan maro kulligeed buluug ah, oo waa inay ulaha lagu qaado sudhaan. ");
INSERT INTO som_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Oo miiska kibista tusniintana waa inay ku kala bixiyaan maro buluug ah, oo ay dusheedana saaraan suxuunta, iyo malqacadaha, iyo maddiibadaha, iyo koobabka wax lagaga shubo, oo kibista joogtada ahuna waa inay saarnaataa, ");
INSERT INTO som_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","oo markaas waa inay dushooda maro cas ku kala bixiyaan oo ay isla taasna dedka ah haragga adhidibadeedka ku daboolaan, oo ay markaas ulaha lagu qaado sudhaan. ");
INSERT INTO som_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Oo markaas waa inay maro buluug ah qaadaan oo ay ku daboolaan laambadda iftiinka, iyo laambadaheeda, iyo birqaabyadeeda, iyo alaabteeda lagu safeeyo, iyo weelasha saliidda oo dhan oo ay kaga adeegaan. ");
INSERT INTO som_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Oo iyada iyo alaabteeda oo dhanba waa inay dhex geliyaan harag adhidibadeed oo markaas waa inay usha lagu qaado sudhaan. ");
INSERT INTO som_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Oo meesha allabariga oo dahabka ahna waa inay maro buluug ah ku daboolaan, oo ay ku dedaan ded harag adhidibadeed ah, oo markaas waa inay ulaha lagu qaado sudhaan. ");
INSERT INTO som_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Oo waa inay qaadaan alaabta lagu adeego oo dhan oo ay kaga adeegaan meesha quduuska ah, waana inay maro buluug ah ku wada dhex ridaan oo ay ded ah harag adhidibadeed ku dedaan, oo ay usha lagu qaado sudhaan. ");
INSERT INTO som_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Oo waa inay meesha allabariga dambaska ka daadiyaan, oo ay maro guduudan ku kala dul bixiyaan. ");
INSERT INTO som_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Waana inay saaraan alaabteeda oo dhan oo ay kaga adeegaan, kuwaas oo ah idammada, iyo mudacyada, iyo majarafadaha, iyo maddiibadaha, iyo weelashii meesha allabariga oo dhan, oo markaas waa inay ku kala dul bixiyaan ded ah harag adhidibadeed, oo ay ulaha lagu qaado sudhaan. ");
INSERT INTO som_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Oo Haaruun iyo wiilashiisu markay dhammeeyaan inay dedaan meesha quduuska ah iyo alaabta meesha quduuska ah oo dhan, oo ay dadkii xeradu guurayaan, reer Qohaad ha yimaadeen oo ha qaadeen; laakiinse iyagu waa inaanay taaban waxyaalaha quduuska ah si aanay u dhiman. Waxyaalahaasu waa waxa teendhada shirka ku jira oo ay tahay in reer Qohaad qaadaan. ");
INSERT INTO som_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Oo wadaadka Haaruun ah wiilkiisa Elecaasaar ahuna waa inuu u taliyaa saliidda laambadda, iyo fooxa udgoon, iyo qurbaanka hadhuudhka oo joogtada ah, iyo saliidda lagu subkado, iyo shuqulka taambuugga oo dhan, iyo waxa ku jira oo dhan, kuwaasoo ah meesha quduuska ah iyo alaabteedaba. ");
INSERT INTO som_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Markaasaa Rabbigu la hadlay Muuse iyo Haaruun oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","Reer Qohaad qolooyinkooda ha ka gooynina reer Laawi dhexdooda, ");
INSERT INTO som_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","laakiinse sidan ku sameeya si ay u noolaadaan oo aanay u dhiman markay u soo dhowaadaan waxyaalaha ugu wada quduusan. Haaruun iyo wiilashiisu waa inay gudaha galaan, oo ay iyaga u amraan hawshooda iyo waxqaadkooda, ");
INSERT INTO som_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","laakiinse iyagu waa inaanay xataa daqiiqad u gelin inay waxyaalaha quduuska ah arkaan, yaanay dhimane. ");
INSERT INTO som_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Oo haddana Rabbigu Muusuu la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","Reer Gershoonna qolo qolo iyo reer reer u soo tiri. ");
INSERT INTO som_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Intii soddon sannadood jirta iyo intii ka sii weyn ilaa tan iyo konton jirka waa inaad soo tirisaa, kulli inta hawsha gasha si ay shuqulka teendhada shirka u sameeyaan. ");
INSERT INTO som_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Tanu waa hawshii qolooyinka reer Gershoon oo ah adeegidda iyo waxqaadkaba. ");
INSERT INTO som_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Iyagu waa inay qaadaan daahyada taambuugga, iyo teendhada shirka, iyo dedkeeda, iyo dedka ah haragga adhidibadeedka oo kor saaran, iyo ilxidhka iridda teendhada shirka, ");
INSERT INTO som_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","iyo daahyada barxadda, iyo ilxidhka iridda barxadda ku ag taal taambuugga iyo meesha allabariga ee ku wareegsan, iyo xadhkahooda, iyo alaabta hawshooda oo dhan, oo wax alla wixii iyaga lagu sameeyo oo dhan, xaggooda waa inay kaga adeegaan. ");
INSERT INTO som_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Oo reer Gershoon waa inay amarka Haaruun iyo wiilashiisa ku qabtaan waxa ay qaadaan iyo shuqulka ay qabtaan oo dhan; oo idinku waa inaad ku amartaan waxay qaadayaan. ");
INSERT INTO som_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Oo tanuna waa qolooyinka reer Gershoon hawshooda ku saabsan teendhada shirka; oo shuqulkooduna waa inuu ka hooseeyaa gacanta Iitaamaar ina Haaruun ee wadaadka ah. ");
INSERT INTO som_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Oo reer Meraariina waa inaad qolo qolo iyo reer reer u soo tirisaa. ");
INSERT INTO som_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Intii soddon sannadood jirta iyo intii ka sii weyn ilaa tan iyo konton jirka waa inaad soo tirisaa, mid kasta oo hawsha gala si uu shuqulka teendhada shirka u sameeyo. ");
INSERT INTO som_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Oo tanuna waa hawsha ay teendhada shirka ku leeyihiin ee ah waxa loo amray inay qaadaan: looxyada taambuugga, iyo ulihiisa gudban, iyo tiirarkiisa, iyo saldhigyadiisa, ");
INSERT INTO som_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","iyo tiirarka barxadda ku wareegsan, iyo saldhigyadooda, iyo musaamiirtooda, iyo xadhkahooda, iyo alaabtooda oo dhan, iyo hawshooda oo dhan. Oo magac magac waa inaad ugu amartaan alaabta ay qaadayaan. ");
INSERT INTO som_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Taasu waa hawshii qolooyinka reer Meraarii, sida ay tahay dhammaan hawshooda ku saabsan teendhada shirka, oo waxay ka hoosaysaa gacantii Iitaamaar ina Haaruun ee wadaadka ah. ");
INSERT INTO som_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Markaasaa Muuse iyo Haaruun iyo amiirradii shirku waxay reer Qohaad u tiriyeen qolo qolo iyo reer reer, ");
INSERT INTO som_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","intii soddon sannadood jirtay iyo intii ka sii weynayd, ilaa tan iyo konton jirka, mid kasta oo hawsha geli jiray si uu shuqulka teendhada shirka u sameeyo. ");
INSERT INTO som_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Oo kuwoodii qolo qolo loo tiriyey waxay ahaayeen laba kun iyo toddoba boqol iyo konton. ");
INSERT INTO som_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Kuwanu waa kuwii qolooyinkii reer Qohaad ee la tiriyey, kulli intii ka adeegi jirtay teendhadii shirka, oo Muuse iyo Haaruun ay ku tiriyeen amarkii Rabbiga ee uu gacanta Muuse u dhiibay. ");
INSERT INTO som_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Oo kuwii reer Gershoon ee qolo qolo iyo reer reer loo soo tiriyey, ");
INSERT INTO som_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","intii soddon sannadood jirtay iyo intii ka sii weynayd ilaa tan iyo konton jirka, mid kasta oo hawsha geli jiray si uu shuqulka teendhada shirka u sameeyo, ");
INSERT INTO som_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","xataa kuwoodii qolo qolo iyo reer reer loo tiriyey waxay ahaayeen laba kun iyo lix boqol iyo soddon. ");
INSERT INTO som_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Oo kuwanuna waa kuwii qolooyinkii reer Gershoon, ee la tiriyey, kulli intii ka adeegi jirtay teendhadii shirka, oo Muuse iyo Haaruun ay amarkii Rabbiga ku tiriyeen. ");
INSERT INTO som_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Oo kuwii qolooyinka reer Meraarii ee qolo qolo iyo reer reer loo tiriyey, ");
INSERT INTO som_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","intii soddon sannadood jirtay iyo intii ka sii weynayd ilaa tan iyo konton jirka, mid kasta oo hawsha geli jiray si uu shuqulka teendhada shirka u sameeyo, ");
INSERT INTO som_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","xataa kuwii qolo qolo loo tiriyey waxay ahaayeen saddex kun iyo laba boqol. ");
INSERT INTO som_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Kuwanu waa kuwii qolooyinka reer Meraarii oo la tiriyey, oo Muuse iyo Haaruun ay ku tiriyeen amarkii Rabbiga ee uu gacanta Muuse u dhiibay. ");
INSERT INTO som_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Oo kulli intii reer Laawi ah oo la soo tiriyey, oo Muuse iyo Haaruun iyo amiirradii reer binu Israa'iil ay qolo qolo iyo reer reer u soo tiriyeen, ");
INSERT INTO som_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","intii soddon sannadood jirtay iyo intii ka sii weynayd xataa ilaa tan iyo konton jirka, mid kasta oo u geli jiray si uu shuqulka hawsha u sameeyo, iyo si uu alaabta teendhada shirka u qaado, ");
INSERT INTO som_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","xataa kuwoodii la tiriyey waxay ahaayeen siddeed kun iyo shan boqol iyo siddeetan. ");
INSERT INTO som_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Oo sidii amarka Rabbigu ahaa ayaa loogu tiriyey gacantii Muuse, mid walba sidii hawshiisu ahayd iyo sidii waxqaadkiisu ahaa, oo isagii sidaasuu iyagii u tiriyey sidii Rabbigu Muuse ugu amray. ");
INSERT INTO som_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Markaasaa Rabbigu Muuse la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","Waxaad reer binu Israa'iil amar ku tidhaahdaa, Xerada ka saara mid kasta oo baras qaba, iyo mid kasta oo dheecaan ka dareera, iyo mid kasta oo meyd ku nijaasoobay. ");
INSERT INTO som_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Oo waa inaad rag iyo dumarba bixisaan, oo aad xerada dibaddeeda geeysaan si aanay u nijaasayn xeradooda aan anigu dhex deggan ahay. ");
INSERT INTO som_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Oo reer binu Israa'iilna sidaasay yeeleen, oo iyagii xerada dibaddeeday geeyeen, oo sidii Rabbigu Muuse kula hadlay ayaa reer binu Israa'iil yeeleen. ");
INSERT INTO som_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Oo haddana ayaa Rabbigu Muuse la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","Reer binu Israa'iil la hadal oo waxaad ku tidhaahdaa, Haddii nin ama naagu ay galaan dembi ay dadku galaan, oo ay Rabbiga ku xadgudbaan, oo ay naftaasu sidaas eed ku lahaato, ");
INSERT INTO som_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","markaas waa inay qirtaan dembigoodii ay sameeyeen. Oo wixii uu ku xadgudbay waa inuu dhammaan u magdhabaa, oo weliba ku sii daraa shan meelood meesheed, oo siiyaa kii uu ku xadgudbay. ");
INSERT INTO som_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Laakiinse ninku hadduusan lahayn xigto xadgudubkii mag laga siiyo, markaas magta xadgudubka ee Rabbiga loo bixiyo waxaa lahaan doona wadaadka; oo weliba waxaa wehliya wanka kafaaraggudka oo isaga aawadiis loogu kafaaro gudo. ");
INSERT INTO som_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Oo qurbaan kasta oo sare loo qaado oo ah waxyaalaha quduuska ah oo dhan ee ay reer binu Israa'iil wadaadka u keenaan waa in isagu lahaadaa. ");
INSERT INTO som_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Oo nin walba waxyaalihiisa quduuska ah waa in wadaadku lahaadaa, oo wax alla wixii nin wadaadka siiyana isagu waa inuu lahaadaa. ");
INSERT INTO som_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Oo haddana ayaa Rabbigu Muuse la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","Reer binu Israa'iil la hadal oo waxaad ku tidhaahdaa, Haddii nin naagtiis isaga ka tagto oo ay ku xadgudubto, ");
INSERT INTO som_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","oo haddii nin kale la jiifsado oo waxaas ninkeedii laga qariyo oo qarsoodi loo haysto, oo ay naagtaasu sidaas ku nijaasowdo, laakiinse markhaati loo waayo iyada, amase aan iyada lagu qaban samayntii, ");
INSERT INTO som_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","oo markaas haddii masayr ku soo dego ninka oo uu naagtiisa ka masayro oo ay iyadu nijaasowday, amase haddii masayr ku soo dego oo uu naagtiisa ka masayro oo ayan iyadu nijaasoobin, ");
INSERT INTO som_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","markaas ninku waa inuu naagtiisa wadaadka u keenaa, oo iyada aawadeed qurbaan ugu keenaa eefaah toban meelood loo qaybiyey meeshiis bur shaciir ah. Isagu waa inuusan saliidna ku shubin amase foox saarin, waayo, taasu waxa weeye qurbaankii masayrka, waana qurbaan xusuuseed oo dembiga lagu soo xusuusto. ");
INSERT INTO som_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Markaas wadaadku waa inuu iyada soo dhoweeyaa oo Rabbiga hortiisa keenaa. ");
INSERT INTO som_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Oo markaas wadaadku waa inuu biyo quduus ah weel dhoobo ah ku qaadaa, oo ciidda taambuugga dhulkiisa taalna waa in wadaadku qaadaa oo biyaha ku shubaa, ");
INSERT INTO som_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","oo markaas waa in wadaadku naagta keenaa Rabbiga hortiisa, oo naagta timaheeduna ha furfurnaadaan, oo qurbaankii xusuuseedna gacmaheeda ha ku rido, kaasoo ah qurbaankii masayrka. Wadaadkuna gacanta ha ku haysto biyaha qadhaadhka ah oo habaarka kiciyo. ");
INSERT INTO som_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Oo markaas wadaadku iyada ha dhaariyo, oo ha ku yidhaahdo naagta, Hadduusan nin kale kula jiifsan, oo aadan nijaaso ku leexan, adoo ninkaaga ka dambayn lahaa, ka xorow biyahan qadhaadhka ah oo habaarka kiciyo, ");
INSERT INTO som_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","laakiinse haddaad gees u leexatay adigoo ninkaaga ka dambayn lahaa, oo aad markaas nijaasowday, oo haddii nin kale kula jiifsaday ninkaaga mooyaane, ");
INSERT INTO som_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","markaas wadaadku waa inuu naagta ku dhaariyaa dhaar habaar ah, oo wadaadku naagta ha ku yidhaahdo, Markuu Rabbigu bowdadaada hilib beeliyo oo uu calooshaada barariyo, dadkaaga dhexdiisa ha kaaga dhigo habaar iyo dhaar, ");
INSERT INTO som_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","oo biyahan habaarka kiciyaa way ku geli doonaan, oo calooshaaday bararin doonaan, bowdadaadana way hilib beelin doonaan. Oo naagtuna waa inay tidhaahdaa, Aamiin, Aamiin. ");
INSERT INTO som_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Oo wadaadkiina waa inuu habaarradaas buug ku qoraa, oo uu biyaha qadhaadhka ah ku baabbi'iyaa. ");
INSERT INTO som_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Oo waa inuu naagta cabsiiyaa biyaha qadhaadhka ah oo habaarka kiciya, oo biyaha habaarka kiciyaa ayaa iyada geli doona oo qadhaadh bay noqon doonaan. ");
INSERT INTO som_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Oo markaas wadaadku waa inuu qurbaankii masayrka naagta gacanteeda ka qaadaa oo Rabbiga hortiisa ku ruxruxaa, oo markaas waa inuu meesha allabariga keenaa. ");
INSERT INTO som_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Oo markaas wadaadku waa inuu qaadaa cantoobo muggeed oo qurbaanka xusuuseed ah, oo waa inuu meesha allabariga ku dul gubaa, oo haddana naagta biyaha cabsiiyaa. ");
INSERT INTO som_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Oo markuu iyada biyaha cabsiiyo markaas hadday iyadu nijaasowday, oo ay ninkeeda ku xadgudubtay, biyaha habaarka kiciya iyaday geli doonaan oo qadhaadh bay noqon doonaan, oo caloosheedu way barari doontaa oo bowdadeeduna way hilib beeli doontaa; oo naagtu waxay dadkeeda ku dhex ahaan doontaa habaar. ");
INSERT INTO som_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Laakiinse naagtu haddaanay nijaasoobin illowse ay daahir tahay, markaas iyadu xor bay ahaanaysaa, wayna uuraysanaysaa. ");
INSERT INTO som_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Kanu waa sharciga ku saabsan masayrka haddii naagu iyadoo ninkeeda ka dambayn lahayd ka leexato oo ay nijaasowdo, ");
INSERT INTO som_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","ama haddii masayr ku soo dego nin, oo uu naagtiisa ka masayro, de markaas waa inuu naagta Rabbiga hor keenaa, oo wadaadku waa inuu iyada sharcigaas oo dhan ku oofiyaa. ");
INSERT INTO som_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Oo markaas ninku dembi xor buu ka ahaanayaa, oo naagtaasuna dembigeeda way qaadan doontaa. ");
INSERT INTO som_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Markaasaa Rabbigu Muuse la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","Reer binu Israa'iil la hadal oo waxaad ku tidhaahdaa, Haddii nin ama naagu galo nidar khaas ah, kaasoo ah nidarka Nadiirka, inuu Rabbiga gooni isugu sooco, ");
INSERT INTO som_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","waa inuu ka fogaadaa khamri iyo wax lagu sakhraamoba. Waa inuusan cabbin khamri khalkiis ama wax lagu sakhraamo khalkood, oo waa inuusan cabbin dheecaanka canabka, uusanna cunin canab cusub ama sabiib toona. ");
INSERT INTO som_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Maalmaha isa-soociddiisa oo dhan waa inuusan cunin innaba wax laga sameeyey canab tan iyo inta hoose iyo diirka sare. ");
INSERT INTO som_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Maalmaha uu nidarka isa-soociddiisa qabo oo dhan waa inaan mandiil madaxiisa la marin. Ilamaa uu dhammaystiro maalmihii uu Rabbiga goonida isugu soocay waa inuu quduus ahaadaa oo timaha madaxiisana waa inuu daystaa. ");
INSERT INTO som_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Oo maalmaha uu Rabbiga gooni isugu sooco oo dhan waa inuusan meyd u soo dhowaan. ");
INSERT INTO som_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Oo waa inuusan isu nijaasayn aabbihiis ama hooyadiis ama walaalkiis ama walaashiis markay dhintaan; waayo, waxaa isaga saaran soociddii uu Ilaah isu soocay. ");
INSERT INTO som_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Oo maalmaha isa-soociddiisa oo dhan ayuu quduus u yahay Rabbiga. ");
INSERT INTO som_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Oo haddii nin agtiisa kedis ugu dhinto oo uu isagu nijaaseeyo madaxiisii uu gooni u soocay, markaas waa inuu madaxiisa xiiraa maalinta daahirintiisa; maalinta toddobaad waa inuu xiiraa. ");
INSERT INTO som_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Oo maalinta siddeedaad waa inuu laba qoolley ama laba xamaam oo yaryar wadaadka ugu keenaa iridda teendhada shirka. ");
INSERT INTO som_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Oo markaas wadaadku waa inuu mid u bixiyaa qurbaan dembi, midka kalena qurbaan la gubo, oo waa inuu isaga u kafaaro gudaa, waayo, wuu ku dembaabay meyd, oo isla maalintaas waa inuu madaxiisa quduus ka dhigaa. ");
INSERT INTO som_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Oo waa inuu Rabbiga gooni isugu soocaa maalmaha isa-soociddiisa oo dhan, oo waa inuu qurbaan xadgudub u keenaa wan gu jir ah, laakiinse waa inaan maalmihii hore loo tirin, maxaa yeelay, isa-soociddiisii way nijaasowday. ");
INSERT INTO som_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Oo kanu waa sharciga Nadiirka ku saabsan; markii maalmihii isa-soociddiisu ay dhammaystirmaan waa in isaga la keenaa iridda teendhada shirka, ");
INSERT INTO som_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","oo waa inuu qurbaankiisa Rabbiga u bixiyaa. Wan yar oo gu jir ah oo aan iin lahayn waa inuu qurbaan la gubo u bixiyaa, oo uu sabeen gu jir ah oo aan iin lahaynna qurbaan dembi u bixiyaa, oo wan weyn oo aan iin lahaynna qurbaanno nabaadiino u bixiyaa, ");
INSERT INTO som_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","iyo dambiil ah kibis aan khamiir lahayn taasoo ah moofo ah bur saliid lagu daray iyo canjeero aan khamiir lahayn oo saliidu marsan tahay, iyo qurbaankooda hadhuudhka ah iyo qurbaankooda cabniinka ah. ");
INSERT INTO som_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Oo markaas wadaadku waa inuu iyaga Rabbiga hortiisa keenaa, oo waa inuu bixiyaa qurbaankiisa dembiga iyo qurbaankiisa la gubo. ");
INSERT INTO som_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Oo waa inuu Rabbiga allabari ah qurbaanno nabaadiino ugu bixiyaa wanka iyo dambiisha kibista aan khamiirka lahayn. Oo weliba wadaadku waa inuu bixiyaa qurbaankooda hadhuudhka ah iyo qurbaankooda cabniinka ah. ");
INSERT INTO som_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Oo Nadiirku waa inuu madaxii isa-soociddiisa ku xiiraa iridda teendhada shirka agteeda oo markaas waa inuu qaadaa timihii madaxii isa-soociddiisa, oo waa inuu ku shubaa dabka ka hooseeya allabariga qurbaannada nabaadiinada ah. ");
INSERT INTO som_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Oo markaas wadaadku waa inuu qaadaa wanka garabkiisa karsan, oo dambiishana ha ka soo bixiyo xabbad moofo ah oo aan khamiir lahayn iyo xabbad canjeero ah oo aan khamiir lahayn, oo iyaga ha saaro gacanta Nadiirka markuu madaxii isa-soociddiisa xiiro dabadeed. ");
INSERT INTO som_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Oo wadaadku waa inuu ruxruxaa iyaga inay ahaadaan qurbaan lagu ruxruxo Rabbiga hortiisa. Intaasu waa u quduus wadaadka oo sakaarka la ruxruxo iyo bowdada sare loo qaadona way raacaan, oo markaas dabadeed Nadiirku khamri wuu cabbi karaa. ");
INSERT INTO som_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Kaasu waa sharciga Nadiirkii nidar gala, iyo qurbaankiisa uu Rabbiga ugu bixiyo isa-soociddiisa, iyo weliba wixii uu isagu heli karo; oo isagu siduu nidarkiisa u nidray waa inuu u sameeyaa, sidii sharciga isa-soociddiisa. ");
INSERT INTO som_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Markaasaa Rabbigu Muuse la hadlay, oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","Haaruun iyo wiilashiisa la hadal, oo waxaad ku tidhaahdaa, Idinku waa inaad sidan reer binu Israa'iil ugu ducaysaan, oo waxaad midkood kasta ku tidhaahdaan, ");
INSERT INTO som_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Rabbigu ha ku barakeeyo, oo ha ku dhawro. ");
INSERT INTO som_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Rabbigu wejigiisa ha kugu iftiimiyo, oo ha kuu roonaado. ");
INSERT INTO som_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Rabbigu jaahiisa kor ha kuugu qaado, oo nabadna ha ku siiyo. ");
INSERT INTO som_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Oo sidaas waa inay magacayga u saaraan reer binu Israa'iil, oo anna iyaga waan barakayn doonaa. ");
INSERT INTO som_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Maalintii Muuse dhammeeyey dhisiddii taambuugga, oo uu subkay oo quduus ka dhigay isagii iyo alaabtiisii oo dhan iyo meeshii allabariga iyo weelasheedii oo dhan, oo uu subkay oo quduus ka dhigay iyagii, ");
INSERT INTO som_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","ayay amiirradii reer binu Israa'iil oo madaxda u ahaa reerahood wax bixiyeen. Kuwanu waxay ahaayeen amiirradii qabiilooyinka, oo iyagu waa kuwii ka sarreeyey kuwii la tiriyey. ");
INSERT INTO som_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Oo waxay Rabbiga hortiisa keeneen qurbaankoodii oo ah lix gaadhi oo dedan, iyo laba iyo toban dibi. Labadii amiirba waxay keeneen gaadhi, amiir kastaana dibi, oo waxay geeyeen taambuugga hortiisii. ");
INSERT INTO som_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Markaasaa Rabbigu la hadlay Muuse oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","Ka qaad iyaga inay u ahaadaan wax hawsha teendhada shirka lagu sameeyo, oo waxaad siisaa reer Laawi, nin walba sidii hawshiisu tahay. ");
INSERT INTO som_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Markaasaa Muuse gaadhiyaashii iyo dibidii qaaday oo reer Laawi siiyey. ");
INSERT INTO som_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Laba gaadhi iyo afar dibi wuxuu siiyey reer Gershoon, sidii hawshoodu ahayd. ");
INSERT INTO som_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Oo afar gaadhi iyo siddeed dibina wuxuu siiyey reer Meraarii, sidii hawshoodu ahayd, oo wuxuu ugu dhiibay gacantii wadaadkii Haaruun ahaa wiilkiisii Iitaamaar. ");
INSERT INTO som_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Laakiinse reer Qohaad waxba kama uu siin, maxaa yeelay, iyagaa lahaa hawshii meesha quduuska ah, oo waxay ku qaadi jireen garbahooda. ");
INSERT INTO som_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Oo maalintii meesha allabariga la subkay ayay amiirradii bixiyeen qurbaankii daahirinta, oo waxay qurbaankoodii ku bixiyeen meesha allabariga horteeda. ");
INSERT INTO som_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Markaasaa Rabbigu Muuse ku yidhi, Iyagu qurbaankooda waa inay u bixiyaan meesha allabariga daahirinteeda, oo amiir kastaaba maalintiisa ha bixiyo. ");
INSERT INTO som_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Oo kii maalintii kowaad qurbaankiisii bixiyey wuxuu ahaa Naxshoon oo ahaa ina Cammiinaadaab oo reer Yahuudah ah. ");
INSERT INTO som_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Oo qurbaankiisuna wuxuu ahaa saxan weyn oo lacag ah oo miisaankiisu yahay boqol iyo soddon sheqel, iyo maddiibad lacag ah oo miisaankeedu yahay toddobaatan sheqel oo le'eg sheqelka meesha quduuska ah, oo labadoodaba waxaa ka buuxay bur saliid lagu daray qurbaanka hadhuudhka aawadiis, ");
INSERT INTO som_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","iyo malqacad dahab ah ee miisaankeedu yahay toban sheqel, oo foox ka buuxo. ");
INSERT INTO som_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","Oo qurbaan la gubona wuxuu u keenay dibi yar, iyo wan weyn, iyo wan yar oo gu jir ah, ");
INSERT INTO som_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","oo qurbaan dembina wuxuu u keenay orgi. ");
INSERT INTO som_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","Oo allabarigii qurbaannadii nabaadiinadana wuxuu u keenay laba dibi, iyo shan wan oo waaweyn, iyo shan orgi, iyo shan wan oo yaryar oo wada gu jir ah, oo intaasu waxay ahayd qurbaankii Naxshoon ina Cammiinaadaab. ");
INSERT INTO som_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Oo maalintii labaadna waxaa bixiyey Netaneel ina Suucaar oo amiir u ahaa reer Isaakaar. ");
INSERT INTO som_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Oo qurbaankiisiina wuxuu ahaa saxan weyn oo lacag ah oo miisaankiisu yahay boqol iyo soddon sheqel, iyo maddiibad lacag ah oo miisaankeedu yahay toddobaatan sheqel oo le'eg sheqelka meesha quduuska ah, oo labadoodaba waxaa ka buuxay bur saliid lagu daray qurbaanka hadhuudhka aawadiis, ");
INSERT INTO som_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","iyo malqacad dahab ah ee miisaankeedu yahay toban sheqel, oo foox ka buuxo. ");
INSERT INTO som_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","Oo qurbaan la gubona wuxuu u keenay dibi yar, iyo wan weyn, iyo wan yar oo gu jir ah, ");
INSERT INTO som_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","oo qurbaan dembina wuxuu u keenay orgi. ");
INSERT INTO som_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","Oo allabarigii qurbaannadii nabaadiinadana wuxuu u keenay laba dibi, iyo shan wan oo waaweyn, iyo shan orgi, iyo shan wan oo yaryar oo wada gu jir ah, oo intaasu waxay ahayd qurbaankii Netaneel ina Suucaar. ");
INSERT INTO som_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Oo maalintii saddexaadna waxaa bixiyey Elii'aab ina Xeelon, oo amiir u ahaa reer Sebulun. ");
INSERT INTO som_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Oo qurbaankiisiina wuxuu ahaa saxan weyn oo lacag ah oo miisaankiisu yahay boqol iyo soddon sheqel, iyo maddiibad lacag ah oo miisaankeedu yahay toddobaatan sheqel oo le'eg sheqelka meesha quduuska ah, oo labadoodaba waxaa ka buuxay bur saliid lagu daray qurbaanka hadhuudhka aawadiis, ");
INSERT INTO som_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","iyo malqacad dahab ah ee miisaankeedu yahay toban sheqel, oo foox ka buuxo. ");
INSERT INTO som_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","Oo qurbaan la gubona wuxuu u keenay dibi yar, iyo wan weyn, iyo wan yar oo gu jir ah, ");
INSERT INTO som_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","oo qurbaan dembina wuxuu u keenay orgi. ");
INSERT INTO som_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","Oo allabarigii qurbaannadii nabaadiinadana wuxuu u keenay laba dibi, iyo shan wan oo waaweyn, iyo shan orgi, iyo shan wan oo yaryar oo wada gu jir ah, oo intaasu waxay ahayd qurbaankii Elii'aab ina Xeelon. ");
INSERT INTO som_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Oo maalintii afraadna waxaa bixiyey Eliisuur ina Shedeeyuur oo amiir u ahaa reer Ruubeen. ");
INSERT INTO som_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Oo qurbaankiisiina wuxuu ahaa saxan weyn oo lacag ah oo miisaankiisu yahay boqol iyo soddon sheqel, iyo maddiibad lacag ah oo miisaankeedu yahay toddobaatan sheqel oo le'eg sheqelka meesha quduuska ah, oo labadoodaba waxaa ka buuxay bur saliid lagu daray qurbaanka hadhuudhka aawadiis, ");
INSERT INTO som_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","iyo malqacad dahab ah ee miisaankeedu yahay toban sheqel oo foox ka buuxo. ");
INSERT INTO som_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","Oo qurbaan la gubona wuxuu u keenay dibi yar, iyo wan weyn, iyo wan yar oo gu jir ah, ");
INSERT INTO som_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","oo qurbaan dembina wuxuu u keenay orgi. ");
INSERT INTO som_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","Oo allabarigii qurbaannadii nabaadiinadana wuxuu u keenay laba dibi, iyo shan wan oo waaweyn, iyo shan orgi, iyo shan wan oo yaryar oo wada gu jir ah, oo intaasu waxay ahayd qurbaankii Eliisuur ina Shedeeyuur. ");
INSERT INTO som_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Oo maalintii shanaad waxaa bixiyey Shelumii'eel ina Suuriishadday, oo amiir u ahaa reer Simecoon. ");
INSERT INTO som_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Oo qurbaankiisiina wuxuu ahaa saxan weyn oo lacag ah oo miisaankiisu yahay boqol iyo soddon sheqel, iyo maddiibad lacag ah oo miisaankeedu yahay toddobaatan sheqel oo le'eg sheqelka meesha quduuska ah, oo labadoodaba waxaa ka buuxay bur saliid lagu daray qurbaanka hadhuudhka aawadiis, ");
INSERT INTO som_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","iyo malqacad dahab ah ee miisaankeedu yahay toban sheqel, oo foox ka buuxo. ");
INSERT INTO som_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","Oo qurbaan la gubona wuxuu u keenay dibi yar, iyo wan weyn, iyo wan yar oo gu jir ah, ");
INSERT INTO som_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","oo qurbaan dembina wuxuu u keenay orgi. ");
INSERT INTO som_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","Oo allabarigii qurbaannadii nabaadiinadana wuxuu u keenay laba dibi, iyo shan wan oo waaweyn, iyo shan orgi, iyo shan wan oo yaryar oo wada gu jir ah, oo intaasu waxay ahayd qurbaankii Shelumii'eel ina Suuriishadday. ");
INSERT INTO som_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Oo maalintii lixaadna waxaa bixiyey Eliyaasaaf ina Decuu'eel, oo amiir u ahaa reer Gaad. ");
INSERT INTO som_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Oo qurbaankiisiina wuxuu ahaa saxan weyn oo lacag ah oo miisaankiisu yahay boqol iyo soddon sheqel, iyo maddiibad lacag ah oo miisaankeedu yahay toddobaatan sheqel oo le'eg sheqelka meesha quduuska ah, oo labadoodaba waxaa ka buuxay bur saliid lagu daray qurbaankii hadhuudhka aawadiis, ");
INSERT INTO som_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","iyo malqacad dahab ah ee miisaankeedu yahay toban sheqel, oo foox ka buuxo. ");
INSERT INTO som_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","Oo qurbaan la gubona wuxuu u keenay dibi yar, iyo wan weyn, iyo wan yar oo gu jir ah, ");
INSERT INTO som_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","oo qurbaan dembina wuxuu u keenay orgi. ");
INSERT INTO som_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","Oo allabarigii qurbaannadii nabaadiinadana wuxuu u keenay laba dibi, iyo shan wan oo waaweyn, iyo shan orgi, iyo shan wan oo yaryar oo wada gu jir ah, oo intaasu waxay ahayd qurbaankii Eliyaasaaf ina Decuu'eel. ");
INSERT INTO som_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Oo maalintii toddobaadna waxaa bixiyey Eliishaamaac ina Cammiihuud oo amiir u ahaa reer Efrayim. ");
INSERT INTO som_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Oo qurbaankiisiina wuxuu ahaa saxan weyn oo lacag ah oo miisaankiisu yahay boqol iyo soddon sheqel, iyo maddiibad lacag ah oo miisaankeedu yahay toddobaatan sheqel oo le'eg sheqelka meesha quduuska ah, oo labadoodaba waxaa ka buuxay bur saliid lagu daray qurbaanka hadhuudhka aawadiis, ");
INSERT INTO som_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","iyo malqacad dahab ah ee miisaankeedu yahay toban sheqel, oo foox ka buuxo. ");
INSERT INTO som_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","Oo qurbaan la gubona wuxuu u keenay dibi yar, iyo wan weyn, iyo wan yar oo gu jir ah, ");
INSERT INTO som_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","oo qurbaan dembina wuxuu u keenay orgi. ");
INSERT INTO som_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","Oo allabarigii qurbaannadii nabaadiinadana wuxuu u keenay laba dibi, iyo shan wan oo waaweyn, iyo shan orgi, iyo shan wan oo yaryar oo wada gu jir ah, oo intaasu waxay ahayd qurbaankii Eliishaamaac ina Cammiihuud. ");
INSERT INTO som_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Oo maalintii siddeedaadna waxaa bixiyey Gamalii'eel ina Fedaahsuur oo amiir u ahaa reer Manaseh. ");
INSERT INTO som_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Oo qurbaankiisiina wuxuu ahaa saxan weyn oo lacag ah oo miisaankiisu yahay boqol iyo soddon sheqel, iyo maddiibad lacag ah oo miisaankeedu yahay toddobaatan sheqel oo le'eg sheqelka meesha quduuska ah, oo labadoodaba waxaa ka buuxay bur saliid lagu daray qurbaanka hadhuudhka aawadiis, ");
INSERT INTO som_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","iyo malqacad dahab ah ee miisaankeedu yahay toban sheqel, oo foox ka buuxo. ");
INSERT INTO som_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","Oo qurbaan la gubona wuxuu u keenay dibi yar, iyo wan weyn, iyo wan yar oo gu jir ah, ");
INSERT INTO som_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","oo qurbaan dembina wuxuu u keenay orgi. ");
INSERT INTO som_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","Oo allabarigii qurbaannadii nabaadiinadana wuxuu u keenay laba dibi, iyo shan wan oo waaweyn, iyo shan orgi, iyo shan wan oo yaryar oo wada gu jir ah, oo intaasu waxay ahayd qurbaankii Gamalii'eel ina Fedaahsuur. ");
INSERT INTO som_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Oo maalintii sagaalaadna waxaa bixiyey Abiidaan ina Gidconii, oo amiir u ahaa reer Benyaamiin. ");
INSERT INTO som_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Oo qurbaankiisiina wuxuu ahaa saxan weyn oo lacag ah oo miisaankiisu yahay boqol iyo soddon sheqel, iyo maddiibad lacag ah oo miisaankeedu yahay toddobaatan sheqel oo le'eg sheqelka meesha quduuska ah, oo labadoodaba waxaa ka buuxay bur saliid lagu daray qurbaanka hadhuudhka aawadiis, ");
INSERT INTO som_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","iyo malqacad dahab ah ee miisaankeedu yahay toban sheqel, oo foox ka buuxo. ");
INSERT INTO som_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","Oo qurbaan la gubona wuxuu u keenay dibi yar, iyo wan weyn, iyo wan yar oo gu jir ah, ");
INSERT INTO som_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","oo qurbaan dembina wuxuu u keenay orgi. ");
INSERT INTO som_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","Oo allabarigii qurbaannadii nabaadiinadana wuxuu u keenay laba dibi, iyo shan wan oo waaweyn, iyo shan orgi, iyo shan wan oo yaryar oo wada gu jir ah, oo intaasu waxay ahayd qurbaankii Abiidaan ina Gidconii. ");
INSERT INTO som_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Oo maalintii tobnaadna waxaa bixiyey Axiiceser ina Cammiishadday oo amiir u ahaa reer Daan. ");
INSERT INTO som_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Oo qurbaankiisiina wuxuu ahaa saxan weyn oo lacag ah oo miisaankiisu yahay boqol iyo soddon sheqel, iyo maddiibad lacag ah oo miisaankeedu yahay toddobaatan sheqel oo le'eg sheqelka meesha quduuska ah, oo labadoodaba waxaa ka buuxay bur saliid lagu daray qurbaanka hadhuudhka aawadiis, ");
INSERT INTO som_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","iyo malqacad dahab ah oo miisaankeedu yahay toban sheqel, oo foox ka buuxo. ");
INSERT INTO som_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","Oo qurbaan la gubona wuxuu u keenay dibi yar, iyo wan weyn, iyo wan yar oo gu jir ah, ");
INSERT INTO som_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","oo qurbaan dembina wuxuu u keenay orgi. ");
INSERT INTO som_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","Oo allabarigii qurbaannadii nabaadiinadana wuxuu u keenay laba dibi, iyo shan wan oo waaweyn, iyo shan orgi, iyo shan wan oo yaryar oo wada gu jir ah, oo intaasu waxay ahayd qurbaankii Axiiceser ina Cammiishadday. ");
INSERT INTO som_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Oo maalintii kow iyo tobnaadna waxaa bixiyey Fagcii'eel ina Cokraan oo amiir u ahaa reer Aasheer. ");
INSERT INTO som_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Oo qurbaankiisiina wuxuu ahaa saxan weyn oo lacag ah oo miisaankiisu yahay boqol iyo soddon sheqel, iyo maddiibad lacag ah oo miisaankeedu yahay toddobaatan sheqel oo le'eg sheqelka meesha quduuska ah, oo labadoodaba waxaa ka buuxay bur saliid lagu daray qurbaanka hadhuudhka aawadiis, ");
INSERT INTO som_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","iyo malqacad dahab ah oo miisaankeedu yahay toban sheqel, oo foox ka buuxo. ");
INSERT INTO som_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","Oo qurbaan la gubona wuxuu u keenay dibi yar, iyo wan weyn, iyo wan yar oo gu jir ah, ");
INSERT INTO som_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","oo qurbaan dembina wuxuu u keenay orgi. ");
INSERT INTO som_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","Oo allabarigii qurbaannadii nabaadiinadana wuxuu u keenay laba dibi, iyo shan wan oo waaweyn, iyo shan orgi, iyo shan wan oo yaryar oo wada gu jir ah, oo intaasu waxay ahayd qurbaankii Fagcii'eel ina Cokraan. ");
INSERT INTO som_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Oo maalintii laba iyo tobnaadna waxaa bixiyey Axiirac ina Ceynaan oo amiir u ahaa reer Naftaali. ");
INSERT INTO som_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Oo qurbaankiisiina wuxuu ahaa saxan weyn oo lacag ah oo miisaankiisu yahay boqol iyo soddon sheqel, iyo maddiibad lacag ah oo miisaankeedu yahay toddobaatan sheqel oo le'eg sheqelka meesha quduuska ah, oo labadoodaba waxaa ka buuxay bur saliid lagu daray qurbaanka hadhuudhka aawadiis, ");
INSERT INTO som_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","iyo malqacad dahab ah oo miisaankeedu yahay toban sheqel, oo foox ka buuxo. ");
INSERT INTO som_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","Oo qurbaan la gubona wuxuu u keenay dibi yar, iyo wan weyn, iyo wan yar oo gu jir ah, ");
INSERT INTO som_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","oo qurbaan dembina wuxuu u keenay orgi. ");
INSERT INTO som_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","Oo allabarigii qurbaannadii nabaadiinadana wuxuu u keenay laba dibi, iyo shan wan oo waaweyn, iyo shan orgi, iyo shan wan oo yaryar oo wada gu jir ah, oo intaasu waxay ahayd qurbaankii Axiirac ina Ceynaan. ");
INSERT INTO som_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Intaasu waxay ahayd wixii amiirradii reer binu Israa'iil ay maalintii meesha allabariga la subkay daahirinteeda u bixiyeen, waxayna ahaayeen laba iyo toban saxan oo waaweyn oo lacag ah, iyo laba iyo toban maddiibadood oo lacag ah, iyo laba iyo toban malqacadood oo dahab ah. ");
INSERT INTO som_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Oo miisaanka saxan kastaa oo lacag ah wuxuu ahaa boqol iyo soddon sheqel, oo kan maddiibad kastaana wuxuu ahaa toddobaatan sheqel, oo weelasha oo dhan lacagtoodu waxay ahayd laba kun iyo afar boqol oo sheqel oo le'eg sheqelka meesha quduuska ah. ");
INSERT INTO som_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Oo laba iyo tobanka malqacadood oo dahabka ahna waxaa ka wada buuxay foox, oo mid kastaaba waxay ahayd toban sheqel oo le'eg sheqelka meesha quduuska ah, oo malqacadaha oo dhan dahabkoodu wuxuu ahaa boqol iyo labaatan sheqel. ");
INSERT INTO som_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Oo dibidii qurbaanka la gubo loo bixiyey oo dhammu waxay ahaayeen laba iyo toban dibi, wanankuna waxay ahaayeen laba iyo toban wan oo waaweyn, iyo laba iyo toban wan oo yaryar oo wada gu jir ah, waxaana la keenay qurbaankoodii hadhuudhka ahaa. Oo qurbaankii dembigana orgidii loo bixiyey waxay ahaayeen laba iyo toban, ");
INSERT INTO som_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","oo allabarigii qurbaannadii nabaadiinada dibidii loo bixiyey oo dhammu waxay ahaayeen afar iyo labaatan, wananka waaweynuna waxay ahaayeen lixdan, orgiduna waxay ahaayeen lixdan, wananka yaryar oo wada gu jirka ahuna waxay ahaayeen lixdan. Intaasu waa wixii daahirinta meesha allabariga loo bixiyey markii la subkay dabadeed. ");
INSERT INTO som_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Oo markii Muuse u galay teendhadii shirka inuu Rabbiga la hadlo, wuxuu maqlay Codka isaga la hadlaya oo ka yeedhaya daboolkii saarnaa sanduuqii maragga iyo labadii keruub dhexdooda, oo isaguna wuu la hadlay isagii. ");
INSERT INTO som_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Markaasaa Rabbigu Muuse la hadlay oo ku yidhi, ");
INSERT INTO som_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","Haaruun la hadal, oo waxaad ku tidhaahdaa, Markaad laambadaha shiddid, toddobada laambadood oo yaryar waa inay ka iftiimaan laambadda horteeda. ");
INSERT INTO som_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Oo Haaruunna sidaasuu yeelay, oo wuxuu wada shiday laambadaheedii si ay uga iftiimaan laambadda horteeda, sidii Rabbigu Muuse ku amray. ");
INSERT INTO som_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Oo shuqulkii laambaddu wuxuu ahaa dahab la tumay. Tan iyo salkeeda ilaa ubaxeeda waxay wada ahayd dahab la tumay. Sidii Rabbigu Muuse u tusay ayuu laambaddii u sameeyey. ");
INSERT INTO som_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Markaasaa Rabbigu Muuse la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","Reer Laawi ka dhex sooc reer binu Israa'iil oo iyaga daahiri. ");
INSERT INTO som_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Oo markaad daahirinaysid sidan iyaga ku samee: dushooda waxaad ku rushaysaa biyaha daahirinta, oo iyaguna timaha ha ka xiireen jidhkooda oo dhan, oo dharkoodana ha maydheen, hana isdaahiriyeen. ");
INSERT INTO som_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Oo markaas iyagu ha kaxaysteen dibi yar iyo qurbaankiisii hadhuudhka oo ah bur saliid lagu daray, oo dibi kale oo yarna waxaad u kaxaysaa qurbaan dembi. ");
INSERT INTO som_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Oo reer Laawi waa inaad hor taagtaa teendhada shirka, oo waa inaad soo shirisaa dadka reer binu Israa'iil oo dhan. ");
INSERT INTO som_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Oo reer Laawi waa inaad keentaa Rabbiga hortiisa, oo reer binu Israa'iilna waa inay gacmaha saaraan reer Laawi. ");
INSERT INTO som_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Haaruunna waa inuu reer Laawi Rabbiga hortiisa ugu bixiyaa qurbaan la ruxruxo ahaan reer binu Israa'iil daraaddood, si ay u sameeyaan Rabbiga hawshiisa. ");
INSERT INTO som_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Oo reer Laawina waa inay gacmaha saaraan madaxa dibida, oo mid waxaad u bixisaa qurbaan dembi, kan kalena waxaad Rabbiga ugu bixisaa qurbaan la gubo, si aad reer Laawi ugu kafaaro guddid. ");
INSERT INTO som_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Oo reer Laawi waa inaad Haaruun iyo wiilashiisa soo hor taagtaa, oo aad Rabbiga ugu bixisaa qurbaan la ruxruxo ahaan. ");
INSERT INTO som_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Oo waa inaad reer Laawi sidaas uga soocdaa reer binu Israa'iil, oo reer Laawina kuwaygay ahaan doonaan. ");
INSERT INTO som_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Oo markaas dabadeedna reer Laawi ha u galeen inay ka adeegaan teendhada shirka, oo waa inaad iyaga daahirisaa oo qurbaan la ruxruxo ahaan u bixisaa. ");
INSERT INTO som_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Waayo, iyaga dhammaantood ayaa la iiga soocay reer binu Israa'iil. Intii lay siin lahaa intii maxal furta oo dhan, kuwaasoo ah curadyada reer binu Israa'iil oo dhan, ayaan iyaga qaatay. ");
INSERT INTO som_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Waayo, dad iyo duunyaba curadyada reer binu Israa'iil oo dhan anigaa iska leh. Waxaan iyaga quduus ka dhigtay maalintii aan wada laayay curadyadii dalka Masar oo dhan. ");
INSERT INTO som_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Oo waxaan qaatay reer Laawi intii aan qaadan lahaa curadyada reer binu Israa'iil oo dhan. ");
INSERT INTO som_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Oo reer Laawi ayaan reer binu Israa'iil ka soocay oo hadiyad ahaan u siiyey Haaruun iyo wiilashiisa inay reer binu Israa'iil uga adeegaan teendhada shirka iyo inay reer binu Israa'iil u kafaaro gudaan, si aan belaayo ugu dhicin reer binu Israa'iil markii reer binu Israa'iil ay u soo dhowaadaan meesha quduuska ah. ");
INSERT INTO som_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Oo Muuse iyo Haaruun iyo shirkii reer binu Israa'iil oo dhammu sidaasay ku sameeyeen reer Laawi. Wixii reer Laawi ku saabsanaa ee uu Rabbigu Muuse ku amray oo dhan ayay reer binu Israa'iil wada yeeleen. ");
INSERT INTO som_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Oo reer Laawina dembi way iska daahiriyeen, oo dharkoodiina way maydheen, markaasaa Haaruun qurbaan la ruxruxo ahaan Rabbiga hortiisa iyaga ugu bixiyey, oo inuu iyaga daahiriyo aawadeed ayaa Haaruun u kafaaro guday. ");
INSERT INTO som_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Oo markaas dabadeed ayaa reer Laawi gudaha u galeen inay teendhada shirka kaga adeegaan Haaruun iyo wiilashiisa hortooda, oo wixii reer Laawi ku saabsanaa ee uu Rabbigu Muuse ku amray ayay ku sameeyeen. ");
INSERT INTO som_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Markaasaa Rabbigu Muuse la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","Tanu waa waxa reer Laawi intii shan iyo labaatan sannadood jirta ama ka sii weyn ay leeyihiin inay sameeyaan. Iyagu ha galeen oo ha ka adeegeen hawsha teendhada shirka. ");
INSERT INTO som_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Oo markii ay konton jir gaadhaan waa inay ka joogsadaan hawsha ka-adeegiddeeda oo aanay mar dambe adeegin, ");
INSERT INTO som_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","laakiinse walaalahood teendhada shirka ha kala adeegeen si ay amarka u hayaan laakiinse yaanay hawl dambe qaban. Sidaas waa inaad ka yeeshaa amarrada ku saabsan reer Laawi hawshooda. ");
INSERT INTO som_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Markaasaa Rabbigu Muuse kula hadlay cidladii Siinay, bishii kowaad ee sannaddii labaad oo ka dambaysay wakhtigii ay dalkii Masar ka soo bexeen, oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","Weliba reer binu Israa'iil ha dhawreen Iidda Kormaridda xilligeedii la amray. ");
INSERT INTO som_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Bishan maalinteeda afar iyo tobnaad markay fiidkii tahay waa inaad dhawrtaan xilligeedii la amray. Waxaad u dhawrtaan sida qaynuunnadeedii iyo amarradeedii oo dhammu ay yihiin. ");
INSERT INTO som_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Markaasaa Muuse la hadlay reer binu Israa'iil oo wuxuu u sheegay inay Iidda Kormaridda dhawraan. ");
INSERT INTO som_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Oo bishii kowaad maalinteedii afar iyo tobnaad markay fiidkii ahayd ayay Iiddii Kormaridda ku dhawreen cidladii Siinay; oo sidii Rabbigu Muuse ku amray oo dhan ayay reer binu Israa'iil wada yeeleen. ");
INSERT INTO som_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Oo waxaa jiray niman ku nijaasoobay nin dhintay meydkiis oo aanay sidaas aawadeed karin inay maalintaas Iiddii Kormaridda dhawraan, oo maalintaasay yimaadeen Muuse iyo Haaruun hortooda. ");
INSERT INTO som_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Oo nimankaasu waxay isagii ku yidhaahdeen, Annagu waxaannu ku nijaasownay nin dhintay meydkiis. Haddaba maxaa nalooga celiyey inaannu reer binu Israa'iil la bixinno qurbaankii Rabbiga xilligii la amray? ");
INSERT INTO som_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Markaasaa Muuse ku yidhi, I suga intaan soo maqlayo waxa Rabbigu amri doono oo idinku saabsan. ");
INSERT INTO som_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Markaasaa Rabbigu Muuse la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","Reer binu Israa'iil la hadal oo waxaad ku tidhaahdaa, Haddii nin idinka mid ah amase farcankiinna ka mid ahu uu ku nijaasoobo sabab meyd ka timid, amase hadduu sodcaal dheer ku jiro, weli waa inuu Rabbiga u dhawraa Iidda Kormaridda. ");
INSERT INTO som_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Bishii labaad maalinteeda afar iyo tobnaad markay fiidka tahay waa inay dhawraan oo ay kibis aan khamiir lahayn iyo caleemo qadhaadh cunaan. ");
INSERT INTO som_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Waa inayan waxba ka reebin ilaa subaxda, oo ayan lafahana mid ka jebin. Waa inay u dhawraan sida qaynuunka Iidda Kormaridda yahay oo dhan. ");
INSERT INTO som_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Laakiinse ninkii daahir ah oo aan sodcaal ku jirin oo ka hadha inuu dhawro Iidda Kormaridda, qofkaasu waa ka go'i doonaa dadkiisa, maxaa yeelay, wuxuusan bixin qurbaankii Rabbiga xilligiisii la amray, oo ninkaasu dembigiisuu qaadan doonaa. ");
INSERT INTO som_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Oo haddii nin qalaad dhexdiinna deggan yahay, oo uu doonayo inuu Rabbiga u dhawro Iidda Kormaridda, waa inuu u sameeyaa sida ay Iidda Kormaridda qaynuunkeeda iyo amarkeedu yihiin, oo kii qalaad iyo kii dalka ku dhashayba waa inaad isku qaynuun u lahaataan. ");
INSERT INTO som_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Oo maalintii taambuugga la dhisay ayaa daruurtu qarisay taambuuggii, kaasoo ah teendhadii maragga, oo fiidkii waxay taambuuggii korkiisa uga muuqatay sida wax dab u eg ilaa subaxdii. ");
INSERT INTO som_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Oo sidaasay mar kasta ahayd. Maalintii daruurtii baa qarisay, habeenkiina wax dab u eg. ");
INSERT INTO som_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Oo mar alla markii daruurta Teendhada korkeeda laga qaado, dabadeed ayaa reer binu Israa'iil guuri jireen, oo meeshii daruurtu degto ayay reer binu Israa'iil degi jireen. ");
INSERT INTO som_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Oo reer binu Israa'iil waxay ku guuri jireen amarka Rabbiga, waxayna ku degi jireen amarka Rabbiga; oo in alla inta daruurtu taambuugga kor joogto halkaasay iska sii degganaan jireen. ");
INSERT INTO som_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Oo haddii daruurtu taambuugga kor joogto maalmo badan, markaas reer binu Israa'iil way xajin jireen amarka Rabbiga oo mana ay guuri jirin. ");
INSERT INTO som_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Oo marmarna daruurtu taambuugga waxay kor joogi jirtay dhawr maalmood, oo markaas sidii amarka Rabbigu ahaa way iska sii degganaan jireen, oo waxay ku guuri jireen sidii amarka Rabbigu ahaa. ");
INSERT INTO som_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Oo marmarna daruurtu waxay joogtay fiidkii ilamaa subaxdii; oo markii daruurta subaxdii la qaado ayay guuri jireen; oo hadday habeen iyo maalin sii joogtana, markii daruurta la qaado ayay guuri jireen. ");
INSERT INTO som_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Oo hadday tahay laba maalmood ama bil ama sannad, in alla intii daruurtu taambuugga dul joogto, oo ay kor deggan tahay, reer binu Israa'iil way iska sii degganaan jireen, oo mana ay guuri jirin; laakiinse markii daruurta kor loo qaado way guuri jireen. ");
INSERT INTO som_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Waxay ku degi jireen amarka Rabbiga, oo waxay ku guuri jireen amarka Rabbiga. Iyagu xukunkii Rabbiga ayay ku dhawri jireen amarkii Rabbigu ugu soo dhiibay Muuse. ");
INSERT INTO som_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Markaasaa Rabbigu Muuse la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","Laba turumbo oo lacag ah samayso, oo waxaad iyaga ka samaysaa lacag la tumay, oo waa inaad u isticmaashaa ururka markaad isugu yeedhayso iyo markay xerooyinkii guurayaan. ");
INSERT INTO som_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Oo markii iyaga laga dhawaajiyo, ururka oo dhammu waa inay kuugu soo shiraan iridda teendhada shirka. ");
INSERT INTO som_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Oo haddii mid keliya la afuufo markaas waxaa kuu soo shiraya amiirrada ah utaliyayaasha kumanyaalka reer binu Israa'iil. ");
INSERT INTO som_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Oo markaad turumbada digtoonaanta afuuftaan, xerooyinka xagga bari degganu waa inay guuraan. ");
INSERT INTO som_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Oo haddana markaad turumbada digtoonaanta afuuftaan mar labaad, xerooyinka xagga koonfureed degganu ha guureen; oo waa inay afuufaan turumbo digtoonaaneed guuriddooda aawadeed. ");
INSERT INTO som_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Laakiinse markii shirka laysu soo ururinayo waa inaad turumbada afuuftaan, laakiinse tan digtoonaanta ha ka dhawaajinina. ");
INSERT INTO som_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Oo wadaaddada ah wiilasha Haaruun waa inay turumbooyinka afuufaan, oo iyagu waa inay idiin ahaadaan qaynuun tan iyo qarniyadiinna oo dhan. ");
INSERT INTO som_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Oo markaad waddankiinna dhexdiisa dagaal ugu baxaysaan cadowgiinna idin cadaadiya waa inaad digtoonaan kaga dhawaajisaan turumbooyinka, oo markaasuu Rabbiga Ilaahiinna ahu idin xusuusan doonaa, oo cadaawayaashiinna ayaa laydinka badbaadin doonaa. ");
INSERT INTO som_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Oo weliba maalintii aad faraxdaan, iyo markaad iidihiinna la amray dhawrtaan, iyo markay bilaha idiin dhashaan, waa inaad turumbooyinka ku dul dhawaajisaan qurbaannadiinna la gubo, iyo allabaryada qurbaannadiina nabaadiinada ah, oo iyana xusuus bay idiinku noqon doonaan Ilaahiinna hortiisa, waayo, aniga ayaa ah Rabbiga Ilaahiinna ah. ");
INSERT INTO som_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Sannaddii labaad, bisheedii labaad, maalinteedii labaatanaad ayaa daruurtii laga qaaday taambuuggii maragga korkiisa. ");
INSERT INTO som_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Oo markaasay reer binu Israa'iil cidlada Siinay uga guureen sida sodcaalkoodii loo amray, oo daruurtiina waxay degtay cidladii Faaraan. ");
INSERT INTO som_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Oo iyana markii hore waxay sodcaalkoodii ku bilaabeen amarkii Rabbigu u soo dhiibay Muuse. ");
INSERT INTO som_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Oo horta waxaa baxay calankii xeradii reer Yahuudah siday ciidammadoodu ahaayeen. Oo ciidankiisana waxaa u sarreeyey Naxshoon ina Cammiinaadaab. ");
INSERT INTO som_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Oo qabiilka reer Isaakaar ciidankoodana waxaa u sarreeyey Netaneel ina Suucaar. ");
INSERT INTO som_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Oo qabiilka reer Sebulun ciidankoodana waxaa u sarreeyey Elii'aab ina Xeelon. ");
INSERT INTO som_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Markaasaa taambuuggii la furay oo reer Gershoon iyo reer Meraarii oo taambuugga qaadi jiray ayaa baxay. ");
INSERT INTO som_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Oo haddana waxaa baxay calankii xeradii reer Ruubeen siday ciidammadoodu ahaayeen, oo ciidankiisana waxaa u sarreeyey Eliisuur ina Shedeeyuur. ");
INSERT INTO som_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Oo qabiilkii reer Simecoon ciidankoodana waxaa u sarreeyey Shelumii'eel ina Suuriishadday. ");
INSERT INTO som_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Oo qabiilkii reer Gaad ciidankoodana waxaa u sarreeyey Eliyaasaaf ina Decuu'eel. ");
INSERT INTO som_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Oo haddana waxaa baxay reer Qohaad oo teendhadii quduuska ahayd sida, oo kuwii kalena taambuuggay dhiseen intay iyagu soo socdeen. ");
INSERT INTO som_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Oo haddana waxaa baxay calankii xeradii reer Efrayim siday ciidammadoodu ahaayeen, oo ciidankiisana waxaa u sarreeyey Eliishaamaac ina Cammiihuud. ");
INSERT INTO som_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Oo qabiilka reer Manaseh ciidankoodana waxaa u sarreeyey Gamalii'eel ina Fedaahsuur. ");
INSERT INTO som_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Oo qabiilka reer Benyaamiin ciidankoodana waxaa u sarreeyey Abiidaan ina Gidconii. ");
INSERT INTO som_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Oo haddana calankii xeradii reer Daan oo ugu wada dambeeyey xerooyinka oo dhan ayaa baxay siday ciidammadoodu ahaayeen, oo ciidankiisana waxaa u sarreeyey Axiiceser ina Cammiishadday. ");
INSERT INTO som_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Oo qabiilka reer Aasheer ciidankoodana waxaa u sarreeyey Fagcii'eel ina Cokraan. ");
INSERT INTO som_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Oo qabiilkii reer Naftaali ciidankoodana waxaa u sarreeyey Axiirac ina Ceynaan. ");
INSERT INTO som_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Sidaasay reer binu Israa'iil u sodcaaleen siday ciidammadoodu ahaayeen, oo hore bay u bexeen. ");
INSERT INTO som_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Markaasaa Muuse wuxuu ku yidhi Xoobaab ina Recuu'eel oo reer Midyaan ahaa, oo Muuse soddog u ahaa, Annagu waxaannu u sodcaalaynaa meeshii Rabbigu yidhi, Waan idin siinayaa. Haddaba na soo raac, oo annana wanaag waannu kuu samaynaynaa, maxaa yeelay, Rabbigu wanaag ayuu ugu ballanqaaday reer binu Israa'iil. ");
INSERT INTO som_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Oo isna wuxuu isagii ku yidhi, Anigu tegi maayo, laakiinse waxaan u kacayaa dalkaygii iyo dadkaygii. ");
INSERT INTO som_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Oo isna wuxuu ku yidhi, Waan ku baryayaaye ha naga tegin, waayo, adigu waad garanaysaa sida roon ee aannu cidlada u degno, oo waxaad noo ahaanaysaa indho oo kale. ");
INSERT INTO som_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Oo weliba haddaad na raacdo, wax kasta oo wanaagsan oo Rabbigu noo sameeyo annana waannu kuu samaynaynaa. ");
INSERT INTO som_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Oo iyaguna buurtii Rabbiga ayay saddex maalmood socodkood ka sii sodcaaleen, sanduuqii axdiga Rabbiguna iyaguu hor kacay intii saddex maalmood socodkood ah, inuu iyaga u sii doondoono meel ay ku nastaan. ");
INSERT INTO som_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Markay xerada ka bexeen ayaa daruurtii Rabbigu maalinnimada oo dhan dul joogtay. ");
INSERT INTO som_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Oo kolkii sanduuqii hore u baxay ayaa Muuse yidhi, Rabbiyow, sara joogso, oo cadaawayaashaadu ha kala firdheen, oo kuwa ku necebuna hortaada ha ka carareen. ");
INSERT INTO som_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Oo markuu joogsadayna wuxuu yidhi, Rabbiyow, ku soo noqo kumanyaalka kun ee reer binu Israa'iil. ");
INSERT INTO som_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Oo dadkuna waxay ahaayeen sidii kuwo gunuunac badan, oo wax shar ah ayay Rabbiga dhegihiisa maqashiiyeen. Oo markii Rabbigu maqlay ayaa cadhadiisii kululaatay, oo dabkii Rabbiguna dhexdooduu ka qaxmay, oo xerada meesheedii ugu dambaysay ayuu baabbi'iyey. ");
INSERT INTO som_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Markaasaa dadkii waxay u qayliyeen Muuse, kolkaasaa Muuse Rabbiga baryay, oo dabkiina wuu damay. ");
INSERT INTO som_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Oo meeshaas magaceediina waxaa loo baxshay Tabceeraah, maxaa yeelay, dabkii Rabbiga ayaa dhexdooda ka qaxmay. ");
INSERT INTO som_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Oo dadkii badnaa oo isku darsanaa oo iyaga ku dhex jirayna aad bay wax ugu jeeleen. Oo reer binu Israa'iilna mar kalay ooyeen, oo waxay yidhaahdeen, Bal yaa hilib aannu cunno na siinaya? ");
INSERT INTO som_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Annagu waxaannu xusuusan nahay kalluunkii aannu Masar lacagla'aan uga cuni jirnay, iyo khajaarkii, iyo batiikhii, iyo basashii cagaarka ahayd, iyo basashii guduudnayd, iyo toontii. ");
INSERT INTO som_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Laakiinse haatan naftayadii way cunta nacday, oo waxba ma jiraan, oo maannadan ma ahaane wax kaloo aan fiirsanno ma haysanno. ");
INSERT INTO som_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Oo maannaduna waxay u ekayd midhaha koryander la yidhaahdo, oo midabkeeduna wuxuu u ekaa midabka xabagta beduliyum la yidhaahdo. ");
INSERT INTO som_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Dadku way warwareegi jireen oo soo urursan jireen, markaasay mixdin ku daqiijin jireen, amase mooye ku tumi jireen, oo dheryay ku karsan jireen, oo moofo bay ka samaysan jireen; oo dhadhankeeduna wuxuu ahaa sida dhadhanka wax saliid lagu sameeyey. ");
INSERT INTO som_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Oo habeennimada markii sayaxu xerada ku soo dego ayaa maannaduna la soo dhici jirtay. ");
INSERT INTO som_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Haddana Muuse wuxuu maqlay dadkii oo ka dhex ooyaya qabiilooyinkoodii oo dhan, oo nin waluba teendhadiisa iriddeeduu taagnaa, markaasaa cadhadii Rabbigu aad u kululaatay, oo Muusena wuu ka xumaaday. ");
INSERT INTO som_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Oo Muuse wuxuu Rabbiga ku yidhi, Maxaad anoo addoonkaaga ah sida xun iigu gashay? Oo maxaan raallinimadaada u heli waayay, oo maxaad ii kor saaraysaa dadkan oo dhan culaabtiisa? ");
INSERT INTO som_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Dadkan oo dhan ma anigaa uuraystay? Oo ma anigaa dhalay markaad igu leedahay, Iyaga laabtaada ku qaad sida aabbe u qaado ilmo caanonuug ah, tan iyo dalkii aad awowayaashood ugu dhaaratay? ");
INSERT INTO som_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Bal xaggee baan ka helayaa hilib aan siiyo dadkan oo dhan? Waayo, iyagu way igu ooyaan oo waxay igu yidhaahdaan, Hilib aannu cunno na si. ");
INSERT INTO som_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Anigu ma aan qaadi karo dadkan oo dhan, maxaa yeelay, rarkan aad buu iigu culus yahay. ");
INSERT INTO som_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Haddaad sidaas ii gashid, waan ku baryayaaye, i dil, haddaad raalli iga tahay, oo yaanan dandarradayda arkin. ");
INSERT INTO som_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Markaasaa Rabbigu Muuse ku yidhi, Waxaad ii soo ururisaa toddobaatan nin oo ah waayeelladii reer binu Israa'iil oo aad garanaysid inay dadka waayeello u yihiin iyo saraakiil u talisa, oo waxaad iyaga keentaa teendhada shirka inay halkaas kula istaagaan. ");
INSERT INTO som_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Oo anna waan soo degan doonaa, oo halkaasaan kugula hadli doonaa, oo waxaan qaadi doonaa ruuxa ku kor jooga, markaasaan iyaga saari doonaa, oo waxay kula qaadi doonaan culaabta dadka, si aanad keligaa u qaadin. ");
INSERT INTO som_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Oo dadkana waxaad ku tidhaahdaa, Hilib baad cunaysaane berri quduus isaga dhiga, waayo, waxaad ku ooydeen Rabbiga dhegihiisii, oo waxaad tidhaahdeen, Bal yaa hilib aannu cunno na siinaya? Waayo, markaannu Masar joogi jirnay baa noo dhaantay. Haddaba Rabbigu hilib buu idin siin doonaa oo idinna waad cuni doontaan. ");
INSERT INTO som_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Oo idinku ma cuni doontaan maalin keliya, ama laba maalmood, amase shan maalmood, amase toban maalmood, amase labaatan maalmood, ");
INSERT INTO som_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","laakiinse waxaad cuni doontaan bil dhan, jeer aad sanka dulalkiisa ka keentaan, oo aad ka diiqootaan, maxaa yeelay, Rabbiga idin dhex jooga ayaad diiddeen oo aad ku hor ooydeen, oo waxaad tidhaahdeen, Bal maxaannu Masar uga soo baxnay? ");
INSERT INTO som_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Markaasaa Muuse yidhi, Dadka aan dhex joogaa waa lix boqol oo kun oo nin oo lug ah, oo adna waxaad tidhi, Waxaan iyaga siinayaa hilib ay bil dhan cunaan. ");
INSERT INTO som_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Ma waxaa loo qalaa ido iyo lo' si ay uga dhergaan? Mase kalluunka badda ku jira oo dhan baa loo soo ururiyaa si ay uga dhergaan? ");
INSERT INTO som_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Markaasaa Rabbigu Muuse ku yidhi, War ma gacantii Rabbigaa gaabatay? Haddaba waad arki doontaa bal in eraygaygu rumoobayo iyo in kale. ");
INSERT INTO som_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Markaasaa Muuse baxay oo dadkii u soo sheegay ereygii Rabbiga, oo wuxuu soo ururiyey toddobaatan nin oo reer binu Israa'iil waayeello u ah, oo Teendhada hareeraheedii ayuu isugu keenay. ");
INSERT INTO som_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Markaasaa Rabbigu ku soo degtay daruurtii oo isagii la hadlay, wuxuuna qaaday ruuxii isaga saarnaa, markaasuu toddobaatankii waayeel saaray, oo markii ruxuu korkooda ku degay ayay wax sii sheegeen, laakiinse sidaas mar dambe ma ay yeelin. ");
INSERT INTO som_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Laakiinse laba nin baa xeradii ku dhex hadhay. Mid magiciisa waxaa la odhan jiray Eldaad, kan kalena magiciisa waxaa la odhan jiray Meedaad, oo iyagana ruuxii baa ku soo degay, oo waxay ka mid ahaayeen kuwii la qoray, laakiinse uma ay bixin Teendhadii; oo iyagu xerada dhexdeedii ayay wax ku sii sheegeen. ");
INSERT INTO som_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Markaasaa nin dhallinyaro ah soo orday oo Muuse u soo sheegay oo yidhi, Eldaad iyo Meedaad xeradii bay wax ku sii sheegayaan. ");
INSERT INTO som_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Markaasaa Yashuuca ina Nuun oo Muuse midiidinkiisa ahaa oo raggiisii uu doortay ka mid ahaa ayaa ku yidhi, Sayidkaygii Muusow, u diid iyaga. ");
INSERT INTO som_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Markaasaa Muuse wuxuu isagii ku yidhi, War ma aniga baad ii xinaasaysaa? Bal may dadka Rabbiga oo dhammu nebiyo ahaadaan, oo Rabbigu muu iyaga ruuxiisa ku soo dejiyo! ");
INSERT INTO som_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Markaasaa Muuse iyo waayeelladii reer binu Israa'iilba xerada ku noqdeen. ");
INSERT INTO som_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Markaasaa dabayl Rabbiga ka timid, oo waxay badda ka keentay digaagduur, oo xerada hareeraheedii ayay ku soo daadisay intii maalin socodkeed ah oo dhankan ah iyo intii maalin socodkeed ah oo dhanka kale ah oo xerada ku wareegsan, oo dalka korkiisana waxay u jireen intii laba dhudhun ah. ");
INSERT INTO som_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Markaasaa dadkii kacay oo maalintaas oo dhan, iyo habeenkii oo dhan, iyo maalintii dambe oo dhan waxay soo urursadeen digaagduurkii; oo kii ugu wax yaraa wuxuu soo urursaday toban xomeer, oo waxay ku kala bixiyeen xerada hareeraheedii. ");
INSERT INTO som_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Oo intii hilibkii ilkahoodii ku dhex jiray, oo aanay weli calalin, ayaa cadhadii Rabbigu dadkii aad ugu kululaatay, markaasaa Rabbigu wuxuu dadkii ku dhuftay belaayo weyn. ");
INSERT INTO som_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Oo meeshaas magaceedii waxaa loo bixiyey Qibrood Xatawaah, maxaa yeelay, halkaasaa lagu aasay dadkii hunguri xumaaday. ");
INSERT INTO som_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Markaasay dadkii Qibrood Xatawaah ka guureen, oo waxay u sodcaaleen Xaseerood, Xaseeroodna way degeen. ");
INSERT INTO som_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Oo Maryan iyo Haaruunna waxay Muuse u xanteen naagtii reer Kuush oo uu guursaday, maxaa yeelay, isagu wuxuu guursaday naag reer Kuush. ");
INSERT INTO som_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Oo iyagu waxay yidhaahdeen, War Rabbigu ma Muuse keliyuhuu la hadlay? Miyuusan annagana nala hadlin? Oo Rabbigu taas wuu maqlay. ");
INSERT INTO som_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Haddaba Muuse wuxuu ahaa ninka ugu wada qalbi qaboobaa dadkii dunida joogay oo dhan. ");
INSERT INTO som_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Markaasaa Rabbigu dhaqso ula hadlay Muuse iyo Haaruun iyo Maryan, oo wuxuu ku yidhi, Saddexdiinnuba kaalaya teendhada shirka. Oo saddexdoodiiba way soo bexeen. ");
INSERT INTO som_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Markaasaa Rabbigu ku soo degtay tiir daruur ah oo istaagay iriddii teendhadii shirka, oo wuxuu u yeedhay Haaruun iyo Maryan, kolkaasaa labadoodiiba soo bexeen. ");
INSERT INTO som_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Oo wuxuu iyagii ku yidhi, Haddaba bal hadalladayda maqla. Haddii nebi idinku dhex jiro, anigoo Rabbiga ah ayaa muujin isku tusi doona, oo riyo baan kula hadli doonaa. ");
INSERT INTO som_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Addoonkayga Muuse sidaas ma aha, oo isagu aamin buu ku yahay gurigayga oo dhan. ");
INSERT INTO som_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Isaga bayaan baan afkayga ugula hadlayaa, oo hadal gudcur ah kula hadli maayo, oo wuxuu arki doonaa Rabbiga qaabkiisa. Haddaba maxaad uga cabsan weydeen inaad addoonkayga Muuse wax ka sheegtaan? ");
INSERT INTO som_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Markaasaa Rabbigu iyagii aad ugu cadhooday, wuuna ka tegey. ");
INSERT INTO som_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Oo daruurtiina way ka tagtay teendhada korkeedii; oo Maryanna waxaa ku dhacay baras, oo waxay u caddaatay sida barafka cad oo kale. Markaasaa Haaruun fiiriyey Maryan oo wuxuu arkay inay baras qabto. ");
INSERT INTO som_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Markaasaa Haaruun Muuse ku yidhi, Sayidkaygiiyow, waan ku baryayaaye, wixii aannu nacasnimada u samaynay iyo wixii aannu ku dembaabnay aawadood dembi ha noo saarin. ");
INSERT INTO som_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Waan ku baryayaaye, yaanay ahaan sidii mid dhintay oo kale oo jidhkiisii badh baabba'san yahay markuu uurkii hooyadiis ka soo baxay. ");
INSERT INTO som_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Markaasaa Muuse Rabbiga u qayliyey, oo wuxuu ku yidhi, Ilaahow, waan ku baryayaaye, iyada bogsii. ");
INSERT INTO som_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Oo Rabbigu wuxuu Muuse ku yidhi, Haddii aabbeheed wejiga kaga candhuufo sow ma ay ceebowdeen intii toddoba maalmood ah? Haddaba xerada ha laga saaro intii toddoba maalmood ah, oo markaas dabadeedna ha la soo celiyo. ");
INSERT INTO som_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Kolkaasaa Maryan xerada dibadda looga xidhay, oo dadkiina ma guurin ilamaa Maryan mar kale la soo celiyey. ");
INSERT INTO som_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Oo dabadeedna dadkii Xaseerood way ka guureen, oo waxay degeen cidladii Faaraan. ");
INSERT INTO som_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Markaasaa Rabbigu Muuse la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","War waxaad dirtaa niman soo basaasa dalka reer Kancaan oo aan reer binu Israa'iil siinayo, oo qabiil walba waa inaad nin ka dirtaan, oo mid kastaaba ha ahaado amiir iyaga ku jira. ");
INSERT INTO som_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Markaasaa Muuse iyagii ka diray cidladii Faaraan sidii amarkii Rabbigu ahaa, oo kulligood waxay ahaayeen rag reer binu Israa'iil madax u ahaa. ");
INSERT INTO som_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Oo magacyadoodiina kuwan bay ahaayeen: qabiilkii reer Ruubeen waxaa ka tegey Shammuuca ina Sakuur. ");
INSERT INTO som_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Oo qabiilkii reer Simecoonna Shaafaad ina Xori. ");
INSERT INTO som_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Oo qabiilkii reer Yahuudahna Kaaleeb ina Yefunneh. ");
INSERT INTO som_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Oo qabiilkii reer Isaakaarna Yigaal ina Yuusuf. ");
INSERT INTO som_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Oo qabiilka reer Efrayimna Hoosheeca ina Nuun. ");
INSERT INTO som_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Oo qabiilkii reer Benyaamiinna Faltii ina Raafuu. ");
INSERT INTO som_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Oo qabiilkii reer Sebulunna Gaddii'eel ina Soodii. ");
INSERT INTO som_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Oo qabiilkii reer Yuusuf oo ah reer Manasehna Gaddii ina Suusii. ");
INSERT INTO som_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Oo qabiilkii reer Daanna Cammii'eel ina Gemallii. ");
INSERT INTO som_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Oo qabiilkii reer Aasheerna Setuur ina Miikaa'eel. ");
INSERT INTO som_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Oo qabiilkii reer Naftaalina Naxbii ina Waafsii. ");
INSERT INTO som_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Oo qabiilkii reer Gaadna Ge'uu'eel ina Maakii. ");
INSERT INTO som_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Intaasu waa magacyadii nimankii Muuse u diray inay dalka soo basaasaan. Markaasaa Muuse wuxuu Hoosheeca ina Nuun u bixiyey Yashuuca. ");
INSERT INTO som_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Markaasaa Muuse iyagii u diray inay dalkii reer Kancaan soo basaasaan, oo wuxuu iyagii ku yidhi, Jidkan koonfureed xaggiisa u kaca oo buuraha fuula. ");
INSERT INTO som_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Oo waxaad soo fiirisaan dalku siduu yahay, iyo dadka degganu inay xoog badan yihiin iyo inay itaal yar yihiin, iyo inay tiro yar yihiin iyo inay tiro badan yihiin, ");
INSERT INTO som_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","iyo dalka ay deggan yihiin siduu yahay inuu wanaagsan yahay iyo inuu xun yahay, iyo magaalooyinka ay deggan yihiin siday yihiin, inay xerooyin deggan yihiin iyo inay qalcado xoog badan ku jiraan, ");
INSERT INTO som_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","iyo siduu dalku yahay inuu barwaaqaysan yahay iyo in kale, iyo inuu dhir leeyahay iyo in kale. Haddaba dhiirranaada oo dalka midhihiisa keena. Oo wakhtiguna wuxuu ahaa xilliga uu canabka hore bislaado. ");
INSERT INTO som_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Haddaba iyagii way tageen oo waxay soo basaaseen dalkii tan iyo cidlada Sin iyo ilaa Rexob oo ku taal meesha Xamaad laga galo. ");
INSERT INTO som_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Oo waxay tageen xagga koonfureed, oo yimaadeen Xebroon; oo Axiiman iyo Sheeshay iyo Talmay oo reer Canaaq ahaa ayaa halkaas degganaa. (Oo Xebroon waxaa la dhisay goor toddoba sannadood ka horraysa intaan la dhisin Socan oo Masar ku taal.) ");
INSERT INTO som_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Oo haddana waxay yimaadeen dooxadii Eshkol, oo halkaasay ka goosteen laan rucub canab ahu ku yaal, oo waxay ku qaadeen ul laba nin u dhexaysa, waxayna keeneen midho rummaan iyo berde ah. ");
INSERT INTO som_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Oo meeshaas magaceeda waxaa la odhan jiray Eshkol, rucubkii canabka ahaa oo ay reer binu Israa'iil halkaas ka goosteen aawadiis. ");
INSERT INTO som_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Oo markay afartan maalmood dalkii soo basaaseen dabadeed ayay ka soo noqdeen. ");
INSERT INTO som_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Markaasay tageen oo Muuse iyo Haaruun iyo shirkii reer binu Israa'iil oo dhan ugu yimaadeen cidladii Faaraan iyo tan iyo Qaadeesh, oo iyagii iyo ururkii oo dhan war bay u keeneen, oo waxay soo tuseen midhihii dalka. ");
INSERT INTO som_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Oo Muuse bay u warrameen oo waxay ku yidhaahdeen, Annagu dalkii aad noo dirtay waan gaadhnay, oo hubaal wuxuu la barwaaqaysan yahay caano iyo malab, oo midhihiisiina waa kuwan. ");
INSERT INTO som_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Habase yeeshee dadka dalka degganu waa xoog badan yihiin, oo magaalooyinkuna deyrar bay leeyihiin, waana waaweyn yihiin, oo weliba waxaannu halkaas ku soo aragnay reer Canaaq. ");
INSERT INTO som_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Oo reer Camaaleq waxay deggan yihiin dalka xaggiisa koonfureed, oo reer Xeed iyo reer Yebuus iyo reer Amorna waxay deggan yihiin buuraha, oo reer Kancaanna waxay deggan yihiin badda agteeda iyo Webi Urdun dhinaciisa. ");
INSERT INTO som_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Markaasaa Kaaleeb dadkii ku aamusiiyey Muuse hortiisa, oo wuxuu ku yidhi, War haddiiba ina keena, aynu dalka qabsannee, waayo, innagu waynu karaynaa inaynu ka adkaanno. ");
INSERT INTO som_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Laakiinse nimankii isaga raacay waxay yidhaahdeen, War innagu dadkaas kuma kici karno, waayo, way inaga xoog badan yihiin. ");
INSERT INTO som_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Oo iyagu dalkii ay soo basaaseen ayay reer binu Israa'iil war xun uga keeneen, oo waxay yidhaahdeen, Dalka aannu dhex marnay oo soo basaasnay waa dal cuna dadka deggan, oo dadkii aannu ku aragnay oo dhammuna waa dad aad u dhaadheer. ");
INSERT INTO som_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Oo waxaannu halkaas ku aragnay dad waaweyn oo xoog badan oo ah reer Canaaq oo ka yimid dadkii waaweynaa oo xoogga badnaa. Waxaannu isula yaraannay sida kabajaan oo kale, oo hortoodana sidaas oo kalaannu ku ahayn. ");
INSERT INTO som_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Oo shirkii oo dhammuna codkoodii bay kor u qaadeen oo qayliyeen, oo dadkiina habeenkaas way ooyeen. ");
INSERT INTO som_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Oo reer binu Israa'iil oo dhammuna waxay u gunuuseen Muuse iyo Haaruun, oo shirkii oo dhammu waxay iyagii ku yidhaahdeen, Waxaa inoo roonayd inaynu dalkii Masar ku dhimanno! Amase inaynu cidladan ku dhimanno! ");
INSERT INTO som_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Bal Rabbigu muxuu inoogu soo kexeeyey dalkan aynu seefta ku le'anayna? Naagaheenna iyo dhallaankeennu dhac bay noqonayaan. Sow inaynu Masar ku noqonno inooma roona? ");
INSERT INTO som_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Oo markaasaa midba midkii kale ku yidhi, Kaalaya aynu madax doorannee oo aynu Masar isaga noqonnee. ");
INSERT INTO som_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Markaasaa Muuse iyo Haaruun waxay ku hor dheceen ururkii shirka reer binu Israa'iil oo dhan. ");
INSERT INTO som_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Oo Yashuuca ina Nuun iyo Kaaleeb ina Yefunneh oo kuwii dalka soo basaasay ka mid ahaa ayaa dharkoodii iska jeexjeexay, ");
INSERT INTO som_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","oo waxay la hadleen shirkii reer binu Israa'iil oo dhan oo ku yidhaahdeen, War dalkii aannu dhex marnay oo aan soo basaasnay waa dal aad iyo aad u wanaagsan. ");
INSERT INTO som_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Oo haddii Rabbigu inagu farxo, ayuu dalkaas ina geeyn doonaa, oo wuu ina siin doonaa dalkaas caanaha iyo malabka la barwaaqaysan. ");
INSERT INTO som_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Laakiinse Rabbiga ha ku caasiyoobina, oo ha ka cabsanina dadka dalka deggan, waayo, waxay inoo yihiin sida kibis oo kale. Daafacoodii korkooda waa laga qaaday, oo Rabbigu innaguu inala jiraaye; iyaga ha ka cabsanina. ");
INSERT INTO som_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Laakiinse shirkii oo dhammu waxay yidhaahdeen, Iyaga ha la dhagxiyo. Markaasaa ammaantii Rabbigu waxay reer binu Israa'iil oo dhan uga muuqatay teendhadii shirka. ");
INSERT INTO som_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Oo Rabbigu wuxuu Muuse ku yidhi, Dadkanu ilaa goormay i quudhsanayaan? Oo ilaa goormay i rumaysan waayayaan in kastoo aan dhexdooda calaamooyinka oo dhan ku sameeyey? ");
INSERT INTO som_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Haddaba iyagaan belaayo ku dhufan doonaa, oo waan dhaxal tiri doonaa, oo waxaan kaa samayn doonaa quruun iyaga ka weyn oo ka sii xoog badan. ");
INSERT INTO som_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Markaasaa Muuse wuxuu Rabbiga ku yidhi, De taas waxaa maqli doona Masriyiintii, waayo, dadka itaalkaagaad iyaga kaga soo dhex bixisay. ");
INSERT INTO som_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Oo iyana waxay u sheegi doonaan dadka dalkan deggan. Iyagu waxay maqleen inaad dadkan dhex joogto, Rabbiyow, waayo, Rabbiyow, fool ka fool baa laguu arkay oo daruurtaadii baa iyaga kor taagan, oo maalintii waad ku hor kacdaa tiir daruur ah, habeenkiina tiir dab ah. ");
INSERT INTO som_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Haddaba haddaad dadkan sidii nin keliya u disho, quruumihii warkaaga maqlay way hadli doonaan, oo waxay odhan doonaan, ");
INSERT INTO som_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","Rabbigu ma uu karin inuu dadkan keeno dalkii uu ugu dhaartay, sidaas daraaddeed ayuu cidladii ku laayay. ");
INSERT INTO som_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Haddaba waan ku baryayaaye, Sayidow, xooggaagu wax weyn ha ahaado, sidaad u hadashay oo aad tidhi, ");
INSERT INTO som_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","Rabbigu cadho waa u gaabiyaa, oo waa naxariis badan yahay, oo xumaanta iyo xadgudubka wuu dhaafaa, oo sinaba uma caddeeyo in kan dembiga galay aanu eed lahayn, oo xumaantii awowayaashana wuxuu gaadhsiiyaa carruurtooda tan iyo farcanka saddexaad iyo kan afraad. ");
INSERT INTO som_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Haddaba waan ku baryayaaye, sida ay naxariistaadu u weyn tahay oo aad dadkan u cafiyi jirtay tan iyo dalkii Masar iyo ilaa haddeer dadkan xumaantooda saamax. ");
INSERT INTO som_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Markaasaa Rabbigu yidhi, Sidaad u tidhi, waan u saamaxay, ");
INSERT INTO som_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","laakiinse sida runta ah anigu waan noolahay, oo dunida oo dhammuna waxay ka buuxsami doontaa ammaanta Rabbiga. ");
INSERT INTO som_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Kulli dadkii ammaantayda arkay, oo arkay calaamooyinkii aan ku sameeyey Masar iyo cidladii, oo weliba tobankan jeer i jirrabay oo aanay codkaygiina dhegaysan, ");
INSERT INTO som_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","hubaal ma ay arki doonaan dalkii aan awowayaashood ugu dhaartay, oo intoodii i quudhsatayna midna ma arki doono. ");
INSERT INTO som_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Laakiinse addoonkayga Kaaleeb wuxuu lahaa ruux kaleeto oo dhammaan ahaan buu ii raacay, oo sidaas daraaddeed isaga waan geeynayaa dalkii uu tegey, oo farcankiisuna way lahaan doonaan. ");
INSERT INTO som_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Haddaba dooxada waxaa deggan reer Camaaleq iyo reer Kancaan. Idinku berrito dib u noqda, oo waxaad tagtaan cidladii ku taal jidka loo maro Badda Cas. ");
INSERT INTO som_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Markaasaa Rabbigu la hadlay Muuse iyo Haaruun, oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","Ilaa goormaan u adkaysanayaa shirkan sharka ah oo ii gunuusa? Waxaan maqlay gunuuskii ay reer binu Israa'iil ii gunuuseen. ");
INSERT INTO som_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Waxaad iyaga ku tidhaahdaa, Rabbigu wuxuu leeyahay, Noloshaydaan ku dhaartaaye, hubaal sidaad dhegahayga ugu hadasheen ayaan idinku samaynayaa. ");
INSERT INTO som_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Meydadkiinnu waxay ku dhici doonaan cidladan, oo kulli kuwiinna la tiriyey sidii tiradiinnu ahayd oo ah intii labaatan sannadood jirtay ama ka sii weynayd oo aniga ii gunuusay, ");
INSERT INTO som_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","hubaal idinku geli maysaan dalkii aan ku dhaartay inaan idin dejinayo, Kaaleeb ina Yefunneh iyo Yashuuca ina Nuun mooyaane. ");
INSERT INTO som_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Laakiinse yaryarkiinna aad tidhaahdeen, Waa la dhacayaa, iyagaan keeni doonaa, oo iyagu way baran doonaan dalkii aad diiddeen. ");
INSERT INTO som_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Laakiinse idinka meydadkiinnu way ku dhici doonaan cidladan. ");
INSERT INTO som_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Oo carruurtiinnuna afartan sannadood ayay cidlada ku warwareegi doonaan, oo ilaa meydadkiinnu ay cidlada ku baabba'aan iyagu waxay sidi doonaan daacadnimola'aantiinna. ");
INSERT INTO som_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Oo maalmihii aad dalka ku soo basaasteen oo afartan maalmood ahaa, maalintiiba sannad ayaad dembiyadiinna u qaadanaysaan, oo idinku xumaantiinna waad qaadanaysaan xataa afartan sannadood, oo waxaad ogaan doontaan diidniintayda. ");
INSERT INTO som_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Anigoo Rabbiga ah ayaa sidaas ku hadlay, oo hubaal waxan oo dhan ayaan ku samaynayaa shirkan sharka ah ee iiga wada ururay oo dhan. Cidladan ayay ku baabbi'i doonaan oo ku wada dhiman doonaan. ");
INSERT INTO som_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Oo nimankii Muuse u diray inay dalka soo basaasaan oo soo noqday oo shirka oo dhan ka dhigay inay isaga u gunuusaan markay dalkii war xun ka keeneen, ");
INSERT INTO som_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","nimankaas oo war xun dalkii ka keenay ayaa belaayadii ku dhintay Rabbiga hortiisa. ");
INSERT INTO som_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Laakiinse Yashuuca ina Nuun iyo Kaaleeb ina Yefunneh ayaa nolol kaga hadhay nimankii tegey inay dalka soo basaasaan. ");
INSERT INTO som_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Markaasaa Muuse hadalkaas reer binu Israa'iil oo dhan u sheegay, kolkaasaa dadkii aad u baroorteen. ");
INSERT INTO som_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Markaasaa aroor hore kaceen, oo buurta dhaladeeday fuuleen, oo waxay yidhaahdeen, Bal eeg, waa na kan, waanan u kacaynaa meeshii Rabbigu noo ballanqaaday, maxaa yeelay, waannu dembaabnay. ");
INSERT INTO som_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Kolkaasaa Muuse yidhi, War Rabbiga amarkiisa maxaad ugu xadgudbaysaan, waayo, taasu faa'iido idiinma lahaan doonto? ");
INSERT INTO som_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Halkaas ha u kicina, waayo, Rabbigu idinma dhex joogo ee yaan cadaawayaashiinnu idin layn. ");
INSERT INTO som_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Waayo, halkaas waxaa idinka horreeya reer Camaaleq iyo reer Kancaan, oo seeftaad ku le'an doontaan, maxaa yeelay, Rabbiga lasocodkiisii dib baad uga noqoteen, oo sidaas daraaddeed Rabbigu idinla jiri maayo. ");
INSERT INTO som_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Laakiinse iyagii waxay ku sii adkaysteen inay buurta dhaladeedii fuulaan, habase yeeshee Muuse iyo sanduuqii axdiga Rabbigu xeradii kama ay bixin. ");
INSERT INTO som_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Kolkaasay reer Camaaleq iyo reer Kancaan oo buurta degganaa hoos u degeen, oo intay laayeen ayay tan iyo Xormaah eryadeen. ");
INSERT INTO som_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Markaasaa Rabbigu Muuse la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","Reer binu Israa'iil la hadal oo waxaad ku tidhaahdaa, Markaad gaadhaan dalka rugtiinna ah oo aan idin siinayo, ");
INSERT INTO som_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","haddaad doonaysaan inaad Rabbiga qurbaan dab ugu bixisaan, kaasoo ah qurbaan la gubo, amase allabari aad nidar ku samaynaysaan, amase qurbaan aad ikhtiyaar ku bixisaan, amase iidihiinna joogtada ah inaad caraf udgoon Rabbiga uga bixisaan lo'da ama idaha, ");
INSERT INTO som_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","haddaba kii wax bixinayaa qurbaankiisa ha ku bixiyo Rabbiga aawadiis qurbaan hadhuudh ah eefaah toban meelood loo qaybiyey meeshiis oo bur wanaagsan ah oo lagu daray hiin rubuceed oo saliid ah; ");
INSERT INTO som_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","oo khamri ah qurbaanka cabniinka hiin rubuceed waa inaad qurbaanka la gubo ama allabariga ula diyaarisaan wan kasta. ");
INSERT INTO som_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Oo wankii weynna waxaad qurbaan hadhuudh ah u diyaarisaan eefaah toban meelood loo qaybiyo labadiis meelood oo bur wanaagsan ah oo hiin saddex meelood meel saliid ah lagu daray. ");
INSERT INTO som_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","Oo qurbaanka cabniinkana waxaad u bixisaan hiin saddex meelood meel khamri ah oo Rabbiga u ah caraf udgoon. ");
INSERT INTO som_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Oo markaad dibi u bixinaysid allabariga la gubo amase allabari aad nidar ku samaynaysid, amase qurbaanno nabaadiino oo aad Rabbiga u bixinayso, ");
INSERT INTO som_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","markaas eefaah toban meelood loo qaybiyey saddexdiis meelood oo bur wanaagsan ah oo lagu daray hiin nuskeed saliid ah qurbaan hadhuudh ha ula bixiyo dibiga. ");
INSERT INTO som_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Qurbaanka cabniinkana waa inaad u bixisaa hiin nuskeed khamri ah, kaas oo ah qurbaan dab lagu sameeyo oo caraf udgoon Rabbiga u ah. ");
INSERT INTO som_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Oo sidaas ha loo sameeyo dibi kasta, ama wan kasta oo weyn, ama wan kasta oo yar, ama orgi kasta oo yar. ");
INSERT INTO som_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Intaad diyaarisaan sida tiradu tahay mid kasta u sameeya. ");
INSERT INTO som_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Inta waddaniga ah oo dhammu waxyaalahan sidaas ha u sameeyeen markay bixinayaan qurbaan dab lagu sameeyo oo caraf udgoon Rabbiga u ah. ");
INSERT INTO som_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Oo haddii shisheeye idinla deggan yahay ama mid kasta oo idin dhex jooga qarniyadiinna oo dhan, hadduu doonayo inuu qurbaan dab lagu sameeyo Rabbiga ugu bixiyo caraf udgoon, sidaad idinku yeeshaan isna waa inuu yeelaa. ");
INSERT INTO som_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Oo ururkiinna oo dhammu waa inaad idinka iyo shisheeyaha idinla degganu lahaataan qaynuun keliya, kaas oo ahaanaya qaynuun ab ka ab. Waayo, sidaad idinku tihiin, shisheeyuhuna waa inuu Rabbiga hortiisa sidaas oo kale ku ahaadaa. ");
INSERT INTO som_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Oo idinka iyo shisheeyihii idinla degganuba waa inaad lahaataan isku sharci iyo isku qaynuun. ");
INSERT INTO som_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Markaasaa Rabbigu haddana Muuse la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","Reer binu Israa'iil la hadal oo waxaad ku tidhaahdaa, Dalka aan idin geeynayo markaad gaadhaan, ");
INSERT INTO som_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","oo aad dalka cuntadiisa cuntaan waa inaad Rabbiga u bixisaan qurbaan sare loo qaado. ");
INSERT INTO som_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Cajiinkiinna ugu horreeya waa inaad ka bixisaan moofo ah qurbaan sare loo qaado, oo waa inaad taas sare u qaaddaan sidaad sare ugu qaaddaan qurbaanka hadhuudhka ee laga qaado meesha hadhuudhka lagu tumo. ");
INSERT INTO som_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Oo cajiinkiinna ugu horreeya waa inaad Rabbiga uga bixisaan qurbaan sare loo qaado tan iyo ab ka ab. ");
INSERT INTO som_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Oo markaad qaldantaan oo aydaan wada xajin amarradan oo dhan oo uu Rabbigu Muuse kula hadlay, ");
INSERT INTO som_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","xataa wixii uu Rabbigu Muuse idinkaga amray oo dhan tan iyo maalintii Rabbigu amarka bixiyey ilaa tan iyo ab ka ab, ");
INSERT INTO som_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","markaas haddii qaladkii kama' loo sameeyey iyadoo aan shirku ogayn, shirka oo dhammu waa inay qurbaan la gubo aawadiis dibi yar Rabbiga ugu bixiyaan caraf udgoon, isaga iyo qurbaankiisii hadhuudhka, iyo qurbaankiisii cabniinka, iyo orgi ah qurbaanka dembiga, oo ha loo bixiyo sida qaynuunku leeyahay. ");
INSERT INTO som_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Oo shirka reer binu Israa'iil oo dhan waa in wadaadku u kafaaro gudaa, oo markaas iyaga waa la cafiyayaa, maxaa yeelay, waxay ahayd qalad kama' loo sameeyey, oo iyana waxay qaladkoodii u keeneen qurbaankoodii kaas oo ahaa qurbaan dab loogu sameeyey Rabbiga, iyo qurbaankii dembigooda Rabbiga hortiisa loogu bixiyey. ");
INSERT INTO som_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Oo shirka reer binu Israa'iil oo dhan iyo shisheeyaha iyaga dhex degganba waa la cafiyi doonaa, waayo, qaladkaas dadka oo dhammu kama' bay u sameeyeen. ");
INSERT INTO som_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Oo haddii qof keliya kama' u dembaabo, isagu waa inuu qurbaanka dembiga u bixiyaa ceesaan gu jir ah. ");
INSERT INTO som_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Oo qofkii qaldamay waa in wadaadku u kafaaro gudaa naftiisa markuu qofkaas kama' ugu dembaabo Rabbiga hortiisa, si uu isaga u kafaaro gudo, oo markaas isaga waa la cafiyi doonaa. ");
INSERT INTO som_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Waa inaad isku sharci keliya u yeeshaan kii kama' u qaldama ha ahaadee waddanigii reer binu Israa'iil ku dhex dhashay ama shisheeyihii iyaga dhex degganba. ");
INSERT INTO som_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Laakiinse qofkii gacan kibir leh gaf ku sameeyaa hadduu waddani yahay iyo hadduu shisheeye yahayba kaasu wuxuu caayay Rabbiga, oo qofkaas waa in dadkiisa laga gooyaa. ");
INSERT INTO som_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Qofkaas dhammaantiis waa in laga gooyaa, oo dembigiisuna waa inuu korkiisa saarnaadaa, maxaa yeelay, isagu Rabbiga ereygiisuu quudhsaday, oo amarkiisiina wuu jebiyey. ");
INSERT INTO som_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Oo intii reer binu Israa'iil cidladii joogeen, waxay heleen nin maalintii sabtida qoryo guranaya. ");
INSERT INTO som_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Oo kuwii helay isagoo qoryo guranaya waxay u keeneen Muuse iyo Haaruun iyo shirkii oo dhan. ");
INSERT INTO som_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Oo markaasay xidheen, maxaa yeelay, waxa isaga lagu samayn lahaa ayaan weli la caddayn. ");
INSERT INTO som_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Markaasaa Rabbigu Muuse ku yidhi, Ninka hubaal waa in la dilaa, oo shirka oo dhammu waa inay isaga xerada dibaddeeda ku dhagxiyaan. ");
INSERT INTO som_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Markaasaa shirkii oo dhammu waxay isagii keeneen xerada dibaddeedii, kolkaasay dhagxiyeen oo wuu dhintay, sidii Rabbigu Muuse ku amray. ");
INSERT INTO som_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Kolkaasaa Rabbigu Muuse la hadlay, oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","Reer binu Israa'iil la hadal, oo waxaad iyaga ku amartaa inay iyagu ab ka ab farqiyaan darfaha dharkooda, iyo inay faraqa daraf kasta u yeelaan xadhig buluug ah. ");
INSERT INTO som_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Oo wuxuu idiin noqonayaa faraq aad fiirsataan oo aad Rabbiga amarradiisii oo dhan ku xusuusataan inaad samaysaan, si aydaan u raacin qalbigiinna iyo indhihiinna aad daacadnimola'aan ku raaci jirteen, ");
INSERT INTO som_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","laakiinse aad xusuusataan oo aad samaysaan amarradayda oo dhan, oo aad quduus uu ahaataan Ilaahiinna. ");
INSERT INTO som_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Anigu waxaan ahay Rabbiga Ilaahiinna ah oo dalkii Masar idiinka soo bixiyey inuu Ilaah idiin ahaado. Aniga ayaa ah Rabbiga Ilaahiinna ah. ");
INSERT INTO som_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Haddaba Qorax ina Isehaar oo ahaa ina Qohaad, oo ka sii ahaa reer Laawi, isaga iyo Daataan iyo Abiiraam oo ahaa ilma Elii'aab, iyo Oon oo ahaa ina Feled oo reer Ruubeen ahaa ayaa rag watay, ");
INSERT INTO som_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","oo waxay ku hor kaceen Muuse iyaga iyo reer binu Israa'iil qaarkood oo ahaa laba boqol iyo konton amiir oo shirka loo doortay oo wada caan ahaa. ");
INSERT INTO som_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Oo iyana way wada urureen oo gees ka noqdeen Muuse iyo Haaruun, oo waxay iyagii ku yidhaahdeen, Idinku filan, maxaa yeelay, shirka oo dhan qof kastaaba waa quduus, oo Rabbiguna waa dhex joogaa iyaga. Haddaba maxaad Rabbiga ururkiisa isaga sara marisaan? ");
INSERT INTO som_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Oo Muusena markuu taas maqlay ayuu wejiga dhulka dhigay. ");
INSERT INTO som_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Markaasuu la hadlay Qorax iyo guutadiisii oo dhan oo wuxuu ku yidhi, Berri subax ayaa Rabbigu muujin doonaa kuwa ah kuwiisa iyo kii quduus ah, wuuna soo dhowayn doonaa; oo kii uu isagu dooranayana wuu isu soo dhowayn doonaa. ");
INSERT INTO som_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Haddaba Qorax iyo guutadiisa oo dhammay, sidan yeela, oo waxaad qaadataan idammo, ");
INSERT INTO som_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","oo berrito Rabbiga hortiisa iyaga dab ku shuba oo foox ku shida, oo kolkaas ninkii Rabbigu doorto, wuxuu ahaan doonaa quduus. Idinku filan reer Laawiyow. ");
INSERT INTO som_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Markaasaa Muuse wuxuu Qorax ku yidhi, Haddaba maqla reer Laawiyow. ");
INSERT INTO som_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Ma idinla yar tahay in Ilaaha reer binu Israa'iil idiinka soocay shirka reer binu Israa'iil inuu idin soo dhowaysto si aad u samaysaan hawsha taambuugga Rabbiga oo aad shirka hortiisa istaagtaan oo u adeegtaan, ");
INSERT INTO som_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","iyo inuu weliba idinka iyo walaalihiinna reer Laawi oo dhanba soo dhowaystay? Oo haddana ma waxaad doonaysaan wadaadnimada? ");
INSERT INTO som_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Haddaba adiga iyo guutadaada oo dhammu waxaad isu soo urursateen oo aad gees ka tihiin Rabbiga. Balse maxaa dhacay oo aad Haaruun ugu gunuustaan? ");
INSERT INTO som_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Markaasaa Muuse u cid diray Daataan iyo Abiiraam oo ahaa ilma Elii'aab, oo iyana waxay yidhaahdeen, Iman mayno. ");
INSERT INTO som_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Ma wax yar baa inaad naga soo kaxaysay dal caano iyo malab la barwaaqaysan, si aad noogu dishid cidlada dhexdeeda, oo aad weliba annaga amiir isaga kaayo dhigtid? ");
INSERT INTO som_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Oo weliba nama aadan geeyn dal caano iyo malab la barwaaqaysan, oo namana aadan siin dhul iyo beero canab ah oo aan dhaxalno. War ma waxaad doonaysaa inaad dadkan indhaha ka riddo? Annagu iman mayno. ");
INSERT INTO som_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Markaasaa Muuse aad u cadhooday, oo wuxuu Rabbiga ku yidhi, Adigu qurbaankooda ha aqbalin. Anigu iyaga dameerna kama qaadan, midkoodna waxba ma yeelin. ");
INSERT INTO som_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Markaasaa Muuse wuxuu Qorax ku yidhi, Berrito adiga iyo guutadaaduba Rabbiga hortiisa kaalaya, adiga iyo iyaga iyo Haaruunba. ");
INSERT INTO som_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Oo idinka nin waluba idankiisa ha qaato oo foox ha ku shubo, oo ninkiin kastaaba idankiisa Rabbiga ha hor keeno, kuwaasoo wada ah laba boqol iyo konton idan, oo weliba adiga iyo Haaruunna idammadiinna soo qaata. ");
INSERT INTO som_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Oo iyana nin waluba idankiisii buu soo qaatay, oo dab bay ku shubeen, fooxna way saareen, kolkaasay Muuse iyo Haaruun la istaageen iridda teendhadii shirka. ");
INSERT INTO som_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Markaasaa Qorax soo shirsaday shirkii oo dhan oo iyaga ka gees ah, oo wuxuu soo tubay iridda teendhadii shirka. Oo shirkii oo dhan waxaa u muuqatay ammaantii Rabbiga. ");
INSERT INTO som_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Markaasaa Rabbigu Muuse iyo Haaruun la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","Idinku shirkan dhan isaga sooca aan iyaga daqiiqad ku baabbi'iyee. ");
INSERT INTO som_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Markaasay wejiga dhulka dhigeen, oo waxay yidhaahdeen, Ilaahow, adigoo ah Ilaaha binu-aadmiga oo dhan ruuxoodow, haddaba nin keliyahaa dembaabaye ma dadka shirka oo dhan baad u cadhoonaysaa? ");
INSERT INTO som_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Markaasaa Rabbigu Muuse la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","Shirka la hadal, oo waxaad ku tidhaahdaa, War, ka ag kaca taambuugyada Qorax, iyo Daataan iyo Abiiraam. ");
INSERT INTO som_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Markaasaa Muuse wuxuu u kacay Daataan iyo Abiiraam, oo waayeelladii reer binu Israa'iilna isagay soo raaceen. ");
INSERT INTO som_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Markaasuu shirkii la hadlay, oo wuxuu ku yidhi, Waan idin baryayaaye, Isaga fogaada nimankan sharka ah teendhooyinkooda, oo waxay iyagu leeyihiinna ha taabanina, yaan dembiyadooda aawadood laydiin baabbi'ine. ");
INSERT INTO som_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Haddaba waxay ka kaceen dhinac kasta ee taambuugyadii Qorax iyo Daataan iyo Abiiraam. Markaasay Daataan iyo Abiiraam soo bexeen, oo waxay istaageen iridda teendhooyinkoodii, iyaga iyo naagahoodii, iyo wiilashoodii, iyo dhallaankoodiiba. ");
INSERT INTO som_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Markaasaa Muuse wuxuu yidhi, Tanaad ku ogaanaysaan in Rabbigu ii soo diray inaan waxyaalahan oo dhan sameeyo, waayo, anigu maankayga uun kama samayn. ");
INSERT INTO som_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Haddii nimankanu ay u dhintaan sida caadiga u ah dadka oo dhan, ama iyaga loo booqdo sida dadka oo dhan loo soo booqdo, markaas Rabbigu ima uu soo dirin. ");
INSERT INTO som_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Laakiinse haddii Rabbigu wax cusub sameeyo, oo dhulku afka kala qaado oo uu iyaga iyo waxay leeyihiin oo dhan liqo, oo haddii iyagoo noolnool ay She'ool ku dhaadhacaan, de markaas waxaad garan doontaan in nimankanu Rabbiga quudhsadeen. ");
INSERT INTO som_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Oo kolkuu dhammeeyey waxyaalahaas uu ku hadlay oo dhan, ayaa dhulkii iyaga ka hooseeyey kala dillaacay, ");
INSERT INTO som_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","oo dhulku afka kala qaaday oo liqay iyagii iyo reerahoodii, iyo dadkii Qorax oo dhan, iyo alaabtoodii oo dhan. ");
INSERT INTO som_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Haddaba iyagii iyo wixii ay lahaayeen oo dhammuba iyagoo noolnool ayay She'ool ku dhaadhaceen, markaasaa dhulkii ku dul xidhmay, oo iyana shirkii way ka halligmeen. ");
INSERT INTO som_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Markaasaa reer binu Israa'iilkii hareerahooda joogay waxay ka carareen qayladoodii, waayo, waxay isyidhaahdeen, War aarmaa dhulku innagana ina liqaa. ");
INSERT INTO som_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Markaasaa dab Rabbiga xaggiisa ka yimid oo baabbi'iyey laba boqol iyo kontonkii nin oo fooxa bixiyey. ");
INSERT INTO som_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Markaasaa Rabbigu Muuse la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","La hadal Elecaasaar ina Haaruun wadaadka ah, oo u sheeg inuu idammada dabka ka bixiyo, adna dabka xagga shishe ku kala firdhi, waayo, iyagu waa quduus. ");
INSERT INTO som_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Oo idammada nimankan naftooda ku dembaabay ha laga dhigo dahaadh tuman oo meesha allabariga lagu dahaadho; waayo, Rabbiga hortiisay ku bixiyeen, oo sidaas daraaddeed iyagu waa quduus; oo calaamo bay reer binu Israa'iil u noqon doonaan. ");
INSERT INTO som_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Markaasaa wadaadkii Elecaasaar wuxuu soo qaaday idammadii naxaasta ahaa oo ay kuwii gubtay bixiyeen, oo inta la tumay ayaa meesha allabariga dahaadh looga dhigay, ");
INSERT INTO som_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","inay taasu reer binu Israa'iil xusuus u noqoto, si uusan shisheeye aan Haaruun farcankiisa ahaynu Rabbiga hortiisa ugu soo dhowaan inuu foox u bixiyo, si uusan u noqon sidii Qorax iyo guutadiisa, sidii Rabbigu isaga ugula hadlay Muuse. ");
INSERT INTO som_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Laakiinse subaxdii dambe shirkii reer binu Israa'iil oo dhammu way u gunuuseen Muuse iyo Haaruun, oo waxay ku yidhaahdeen, Idinku dadkii Rabbiga waad layseen. ");
INSERT INTO som_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Oo kolkii shirkii oo dhammu ay soo urureen oo ay Muuse iyo Haaruun gees ka noqdeen, waxay soo fiiriyeen teendhadii shirka xaggeedii, oo bal eeg, daruurtii baa qarisay, oo waxaa muuqatay Rabbiga ammaantiisii. ");
INSERT INTO som_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Markaasaa Muuse iyo Haaruun waxay yimaadeen teendhadii shirka horteeda. ");
INSERT INTO som_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Oo Rabbigu Muuse la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","Adigu shirkan ka soo kac, aan iyaga daqiiqad ku baabbi'iyee. Oo iyana markaasay wejiga dhulka dhigeen. ");
INSERT INTO som_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Kolkaasaa Muuse wuxuu Haaruun ku yidhi, War idankaaga qaad oo meesha allabariga dab kaga soo shubo, oo foox ku rid, oo haddiiba shirka u qaad, oo iyaga u kafaaro gud, waayo, cadho ayaa Rabbiga ka soo baxday, oo belaayadii way bilaabatay. ");
INSERT INTO som_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Markaasaa Haaruun qaaday sidii Muuse ku hadlay, oo shirkuu ku dhex orday, oo bal eeg, belaayadiina dadka way ku dhex bilaabatay; oo fooxii wuu shiday, dadkiina buu u kafaaro guday. ");
INSERT INTO som_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Markaasuu isdhex taagay kuwii dhintay iyo kuwii noolaa; oo belaayadiina way joogsatay. ");
INSERT INTO som_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Haddaba kuwii belaayada ku dhintay waxay ahaayeen afar iyo toban kun iyo toddoba boqol, oo aan lagu tirin kuwii ku dhintay xaalkii Qorax. ");
INSERT INTO som_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Markaasaa Haaruun Muuse ugu noqday iriddii teendhadii shirka; oo belaayadiina way joogsatay. ");
INSERT INTO som_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Markaasaa Rabbigu Muuse la hadlay, oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","Reer binu Israa'iil la hadal, oo iyaga ulo ka qaad. Qabiil kastaba ul ka qaad; amiirradooda oo dhan sida ay qabiilooyinkoodu kala yihiin laba iyo toban ulood ka kala qaad. Oo nin walba magiciisa ushiisa ku qor. ");
INSERT INTO som_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Usha reer Laawi waxaad ku qortaa magaca Haaruun. Qabiilooyinkooda madaxdooda mid kastaaba waa inuu ul lahaadaa. ");
INSERT INTO som_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Oo waa inaad iyaga hor dhigtaa maragga teendhada shirka ku yaal, taasoo ah meesha aan idinkula kulmo. ");
INSERT INTO som_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Oo markaas ninkii aan doorto ushiisu way magooli doontaa, oo anna hortayda waan ka joojin doonaa gunuuska ay reer binu Israa'iil adiga kuu gunuusaan. ");
INSERT INTO som_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Markaasaa Muuse reer binu Israa'iil la hadlay, oo amiirradoodii oo dhammu waxay isagii siiyeen ulo, oo amiir kastaaba mid buu siiyey siday qabiilooyinkoodu ahaayeen, intaasu waxay ahayd laba iyo toban ulood; oo ushii Haaruunna ulahooday ku dhex jirtay. ");
INSERT INTO som_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Markaasaa Muuse ulihii dhigay Rabbiga hortiisa teendhadii maragga gudaheeda. ");
INSERT INTO som_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Maalintii dambe waxaa noqotay in Muuse galay teendhadii maragga, oo bal eeg, wuxuu arkay ushii Haaruun oo reer Laawi oo magooshay; way magooshay, wayna ubxisay, oo waxay dhashay yicib bisil. ");
INSERT INTO som_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Markaasaa Muuse ulihii ka soo qaaday Rabbiga hortiisa oo wuxuu u keenay reer binu Israa'iil oo dhan, oo way fiiriyeen oo nin waluba ushiisii buu qaatay. ");
INSERT INTO som_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Markaasaa Rabbigu Muuse ku yidhi, Usha Haaruun dib ugu celi maragga hortiisa in iyada loo haysto calaamo ka gees ah dadka caasiya, inaad iga joojisid gunuuskooda ay ii gunuusaan, yaanay iyagu dhimane. ");
INSERT INTO som_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Oo sidaasaa Muuse yeelay. Sidii Rabbigu isaga ugu amray ayuu u sameeyey. ");
INSERT INTO som_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Markaasay reer binu Israa'iil Muuse la hadleen, oo waxay ku yidhaahdeen, War bal eeg, waannu baabba'aynaa, oo waannu halligmaynaa, kulligayo waannu wada halligmaynaaye. ");
INSERT INTO som_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Mid kasta oo soo dhowaada oo u soo dhowaadaa taambuugga Rabbiga wuu dhiman doonaa. Haddaba kulligayo miyaannu wada baabba'aynaa? ");
INSERT INTO som_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Markaasaa Rabbigu Haaruun ku yidhi, Adiga iyo wiilashaada iyo qabiilkaagu waxaad qaadi doontaan dembiga meesha quduuska ah, oo adiga iyo wiilashaada kula jiraa waxaad qaadi doontaan dembiga wadaadnimadiinna. ");
INSERT INTO som_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Oo walaalahaa oo ah qabiilka reer Laawi, qabiilkaas oo ah kan aabbahaa, la soo dhowow si ay kuugu darmadaan, oo ay kuugu adeegaan, laakiinse adiga iyo wiilashaada kula jiraa waa inaad teendhada maragga hor joogtaan. ");
INSERT INTO som_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Oo iyagu waa inay dhawraan amarkaaga iyo hawsha teendhada oo dhan, laakiinse waa inaanay u soo dhowaan alaabta meesha quduuska ah iyo meesha allabariga, yaanay iyaga iyo idinka toona dhimanine. ");
INSERT INTO som_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Oo iyagu ha idinku darmadeen oo ha dhawreen teendhada shirka, iyo hawsha teendhada loo sameeyo oo dhan; oo shisheeyena yaanu idiin soo dhowaan. ");
INSERT INTO som_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Oo inaan mar dambe cadho ku dhicin reer binu Israa'iil idiinku waa inaad dhawrtaan hawsha meesha quduuska ah iyo hawsha meesha allabariga. ");
INSERT INTO som_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Oo bal eeg, anna walaalihiin reer Laawi ayaan kala dhex baxay reer binu Israa'iil, oo waxay idiin yihiin hadiyad Rabbiga loo siiyey inay teendhada shirka ka adeegaan. ");
INSERT INTO som_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Oo adiga iyo wiilashaada kula joogaaba waa inaad wadaadnimadiinna u dhawrtaan waxyaalaha meesha allabariga oo dhan, iyo waxyaalaha daaha ka shisheeya oo dhan, oo waa inaad adeegtaan. Wadaadnimada ayaan idiin siiyey sida hawl hadiyad ah; oo shisheeyihii soo dhowaada waa in la dilaa. ");
INSERT INTO som_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Markaasaa Rabbigu Haaruun ku yidhi, Bal eeg, anna adigaan ku siiyey amarka qurbaannadayda sare loo qaado, kuwaas oo ah waxyaalaha quduuska ah oo reer binu Israa'iil oo dhan. Subkidda aawadeed ayaan adiga iyo wiilashaada u siiyey qayb joogto ah weligeed. ");
INSERT INTO som_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Kulli waxyaalaha aad u quduuska ah oo dabka laga reebay oo aad lahaan doonto waa kuwan: mid kasta oo qurbaankooda ah, xataa qurbaankooda kasta ee hadhuudhka ah, iyo qurbaankooda kasta ee dembiga, iyo qurbaankooda kasta ee xadgudubka, oo ay ii bixinayaan, adiga iyo wiilashaadaba ayay aad u quduus idiin ahaan doonaan. ");
INSERT INTO som_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Oo sida waxyaalaha aad u quduuska ah waa inaad u cuntaa, oo mid kasta oo lab ahu wax ha ka cuno. Taasu waa inay quduus kuu ahaataa. ");
INSERT INTO som_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Oo adigaa iska leh qurbaanka sare loo qaado oo hadiyaddooda ah, oo ah qurbaannada la ruxruxo ee reer binu Israa'iil oo dhan. Kuwaas adiga iyo wiilashaada iyo gabdhahaaga kula jooga ayaan u siiyey qayb joogto ah weligeed. Oo mid kasta oo daahir ah oo gurigaaga joogaaba wax ha ka cuno. ");
INSERT INTO som_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Oo saliidda inteeda ugu wanaagsan oo dhan iyo canabka iyo hadhuudhka intooda ugu wanaagsan oo dhan kuwaasoo ah midhaha ugu horreeya oo ay Rabbiga siiyaanba, ayaan adiga ku siiyey. ");
INSERT INTO som_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Midhaha ugu horreeya oo dalkooda oo dhan, oo ay Rabbiga u keenaan, adigaa iska lahaan doonta; oo mid kasta oo daahir ah oo gurigaaga joogaaba wax ha ka cuno. ");
INSERT INTO som_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Oo wax kasta oo ay reer binu Israa'iil gooni u soocaan waa inay kuwaaga ahaadaan. ");
INSERT INTO som_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Oo wax kasta oo maxal furo oo Rabbiga loo bixiyo, dad iyo duunyoba, waa inay kuwaaga ahaadaan, habase yeeshee dadka curadkiisa kolleyba waa inaad madax furtaa, oo xoolaha aan daahirka ahayn curadyadoodana waa inaad madax furtaa. ");
INSERT INTO som_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Oo kuwa la madax furayo, markay bil jiraan waa inaad ku madax furtaa, sidaad u qiimayso, lacag ah shan sheqel oo le'eg sheqelka meesha quduuska ah (kaasu waa labaatan geeraah). ");
INSERT INTO som_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Laakiinse dibigii curad ah, iyo curadka idaha, iyo curadka riyaha midnaba yaan la madax furin, iyagu waa quduus; haddaba dhiiggooda waa inaad meesha allabariga ku rushaysaa, oo baruurtoodana waa inaad u gubtaa qurbaan dab lagu gubo oo Rabbiga caraf udgoon u ah. ");
INSERT INTO som_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Oo hilibkoodana waa inuu kaaga ahaadaa, oo sidii sakaarkii la ruxruxo iyo bowdadii midig adigaa iska leh. ");
INSERT INTO som_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Oo waxyaalaha quduuska ah oo dhan qurbaannadooda sare loo qaado oo ay reer binu Israa'iil Rabbiga u bixiyaan ayaan adiga iyo wiilashaada iyo gabdhahaaga kula jooga u siiyey qayb joogto ah weligeed. Oo taasu waa axdi cusbo ah oo weligiis Rabbiga ku hor yaal, oo uu idinla dhigtay adiga iyo farcankaaga kula jiraba. ");
INSERT INTO som_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Markaasaa Rabbigu Haaruun ku yidhi, Adigu dalkooda dhaxal kuma lahaan doonto, oo dhexdoodana innaba qayb kuma yeelan doonto. Aniga ayaa reer binu Israa'iil dhexdooda ku ah qaybtaadii iyo dhaxalkaagiiba. ");
INSERT INTO som_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Oo bal eeg, reer Laawina waxaan dhaxal u siiyey meeltobnaadka ay reer binu Israa'iil oo dhan bixiyaan; taasu waa hawshooda ay qabtaan abaalgudkeedii, taasoo ah hawsha teendhada shirka. ");
INSERT INTO som_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Oo hadda ka dib waa inaan reer binu Israa'iil u soo dhowaan teendhada shirka yaanay dembi qaadine oo dhimane. ");
INSERT INTO som_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Laakiinse reer Laawi waa inay teendhada shirka ka adeegaan, oo ay dembigooda qaadaan: oo taasu waa inay idiin ahaataa qaynuun weligiin ab ka ab ah, oo iyagu reer binu Israa'iil dhexdooda dhaxal kuma yeelan doonaan. ");
INSERT INTO som_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Waayo, waxaan reer Laawi dhaxal u siiyey meeltobnaadka ay reer binu Israa'iil Rabbiga ugu bixiyaan qurbaan sare loo qaado, oo sidaas daraaddeed waxaan iyaga ku idhi, Reer binu Israa'iil dhexdooda dhaxal kuma lahaan doontaan. ");
INSERT INTO som_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Markaasaa Rabbigu Muuse la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","Weliba waxaad la hadashaa reer Laawi oo ku tidhaahdaa, Markaad reer binu Israa'iil dhaxal uga qaadataan meeltobnaadka aan idinka siiyey, markaas waa inaad Rabbiga uga bixisaan qurbaan sare loo qaado, oo ah meeltobnaadka meeltobnaadkiisa. ");
INSERT INTO som_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Oo qurbaankiinna sare loo qaado wuxuu idiin tirsanaan doonaa sidii isagoo ah hadhuudhka meesha lagu tumo, iyo sida buuxsanaanta macsaradda canabka. ");
INSERT INTO som_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Oo sidaas waa inaad idinku qurbaan sare loo qaado Rabbiga uga bixisaan meeltobnaadyadiinna oo dhan oo aad ka qaadataan reer binu Israa'iil, oo waa inaad Rabbiga qurbaankiisii sare loo qaado ka siisaan wadaadka Haaruun ah. ");
INSERT INTO som_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Oo hadiyadaha aad heshaan oo dhanba waa inaad ka bixisaan qurbaan kasta oo Rabbiga oo sare loo qaado intooda ugu wanaagsan oo ah inta ugu wada quduusan. ");
INSERT INTO som_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Oo sidaas daraaddeed waxaad iyaga ku tidhaahdaa, Markii aad sare uga qaaddaan inta ugu wanaagsan, waxaa reer Laawi loogu tirinayaa sida hadhuudhka meesha wax lagu tumo yaal iyo sida midhaha canabka oo macsaradda yaal. ");
INSERT INTO som_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Oo meel kastaad ku cuni doontaan idinka iyo reerihiinnuba, waayo, iyadu waa abaalgudkiinna aad ka heshaan hawsha aad ka qabataan teendhada shirka. ");
INSERT INTO som_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Oo idinku taas aawadeed dembi u qaadi maysaan, markaad sare uga qaaddaan inteeda ugu wanaagsan; oo waa inaydaan nijaasayn waxyaalaha quduuska ah oo reer binu Israa'iil. ");
INSERT INTO som_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Markaasaa Rabbigu Muuse iyo Haaruun la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","Kanu waa qaynuunkii sharciga Rabbigu idinku amray oo uu idinku yidhi, Reer binu Israa'iil la hadla, oo waxaad ku tidhaahdaan, Noo keena qaalin lo'aad oo cas oo aan bar iyo iin lahayn oo aan weligeed harqood la saarin. ");
INSERT INTO som_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Oo waxaad iyada siisaan wadaadka Elecaasaar ah, oo isagu iyada ha geeyo xerada dibaddeeda, oo hortiisa waa in lagu gowracaa. ");
INSERT INTO som_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Oo markaas wadaadka Elecaasaar ahu waa inuu dhiiggeeda farta ku qaadaa, oo uu dhiiggeeda toddoba jeer ku rusheeya xagga teendhada shirka horteeda. ");
INSERT INTO som_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Oo waa in qaalinta hortiisa lagu gubaa. Haraggeeda, iyo hilibkeeda, iyo dhiiggeeda, iyo uuskeedaba waa in la wada gubaa. ");
INSERT INTO som_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Oo markaas waa in wadaadku soo qaadaa qoryo ah geed kedar la yidhaahdo, iyo husob, iyo wax guduud ah, oo waa inuu ku dhex tuuro dabka qaalintu ku gubanayso. ");
INSERT INTO som_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Oo markaas wadaadku dharkiisa ha maydho, oo jidhkiisana biyo ha ku maydho, oo markaas ka dib xerada ha soo galo, oo tan iyo fiidkii wadaadku nijaas buu ahaan doonaa. ");
INSERT INTO som_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Oo kii qaalinta gubona dharkiisa biyo ha ku maydho, jidhkiisana biyo ha ku maydho, oo isna tan iyo fiidkii nijaas buu ahaan doonaa. ");
INSERT INTO som_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Oo markaas nin daahir ahu ha soo ururiyo qaalinta dambaskeedii, oo meel xerada dibaddeeda oo nadiif ah ha dhigo, oo shirka reer binu Israa'iil ha lagu dhigo biyaha nijaasta daahiriya; waayo, iyadu waa dembi qurbaankiis. ");
INSERT INTO som_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Oo kii dambaska qaalinta soo ururiyaana dharkiisa ha maydho, oo tan iyo fiidkiina nijaas buu ahaan doonaa, oo taasu waa inay reer binu Israa'iil iyo shisheeyaha la degganba u ahaataa qaynuun weligiis jira. ");
INSERT INTO som_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Oo kii qof meyd ah taabta intii toddoba maalmood ah ayuu nijaas ahaan doonaa. ");
INSERT INTO som_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Oo kaasu waa inuu maalinta saddexaad isku daahiriyaa, oo maalinta toddobaad isagu daahir buu ahaan doonaa; laakiinse haddaanu maalinta saddexaad isdaahirin, markaas maalinta toddobaad daahir ma uu ahaan doono. ");
INSERT INTO som_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Oo ku alla kii qof dhintay meydkiis taabta oo aan isdaahirin, kaasu wuxuu nijaaseeyaa Rabbiga taambuuggiisa, oo qofkaasu wuu ka go'i doonaa reer binu Israa'iil, maxaa yeelay, isaga laguma rushayn biyaha nijaasta daahiriya, oo isagu nijaas buu ahaan doonaa, oo nijaasnimadiisa ayaa weli saaran. ");
INSERT INTO som_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Oo tanu waa sharciga markii nin teendho ku dhex dhinto. Mid kasta oo teendhada soo gala, iyo mid kasta oo teendhada ku jirayba, intii toddoba maalmood ah ayay nijaas ahaan doonaan. ");
INSERT INTO som_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Oo weel kasta oo furan oo aan lahayn dabool ku xidhan waa nijaas. ");
INSERT INTO som_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Oo ku alla kii berrin bannaan ku soo taabta qof seef lagu dilay, ama meyd, ama laf dad, ama qabri, intii toddoba maalmood ah ayuu nijaas ahaan doonaa. ");
INSERT INTO som_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Oo nijaasta aawadeed waa in loo qaadaa dambaska qurbaankii dembiga oo la gubay, oo biyo socda waa in weel lagula shubaa, ");
INSERT INTO som_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","oo markaas waa in qof daahir ahu geed husob ah soo qaadaa, oo uu biyaha daraa, oo kolkaas ha ku rusheeyo teendhada, iyo weelasha oo dhan, iyo dadkii halkaas joogay, iyo kii taabtay lafta, ama qofka la dilay, ama meydka, ama qabriga. ");
INSERT INTO som_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Oo qofka daahirka ahu waa inuu maalinta saddexaad iyo maalinta toddobaad ku rusheeyaa kii nijaas ah, oo maalinta toddobaad waa inuu isaga daahiriyaa, markaas dharkiisana ha maydho, jidhkiisana biyo ha ku maydho, oo markaas fiidkii daahir buu ahaan doonaa. ");
INSERT INTO som_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Laakiinse qofka nijaasta ah, oo aan isdaahirin, qofkaasu shirka dhexdiisa waa in laga gooyaa, maxaa yeelay, wuxuu nijaaseeyey Rabbiga meeshiisii quduuska ahayd, oo waa nijaas oo laguma rushayn biyaha nijaasta daahiriya. ");
INSERT INTO som_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Kaasu wuxuu iyaga u ahaanayaa qaynuun weligiis jira, oo kii rusheeyo biyaha nijaasta daahiriyana waa inuu dharkiisa maydhaa, oo kii biyaha nijaasta daahiriya taabtaana nijaas buu ahaan doonaa tan iyo fiidkii. ");
INSERT INTO som_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Oo wax alla wixii uu qofka nijaasta ahu taabtana nijaas bay ahaan doonaan, oo qofkii taabtaana tan iyo fiidkii nijaas buu ahaan doonaa. ");
INSERT INTO som_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Oo reer binu Israa'iil, xataa shirkii oo dhammu waxay cidladii Sin yimaadeen bishii kowaad. Markaasaa dadkii waxay degeen Qaadeesh, oo Maryanna halkaasay ku dhimatay, oo halkaasaa lagu aasay. ");
INSERT INTO som_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Oo shirkiina biyo ma haysan, oo markaasay Muuse iyo Haaruun u wada shireen. ");
INSERT INTO som_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Kolkaasaa dadkii Muuse la dirireen, wayna la hadleen oo ku yidhaahdeen, Waxaa noo roonayd inaannu walaalahayo iskala dhimanno markay Rabbiga hortiisa ku dhinteen! ");
INSERT INTO som_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Bal maxaad shirka Rabbiga cidladan u keenteen si aan annaga iyo lo'dayaduba halkan ugu wada dhimanno? ");
INSERT INTO som_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Oo maxaadse dalkii Masar nooga soo bixiseen, oo aad meeshan sharka ah noo keenteen? Waayo, meeshanu ma aha meel laga helo midho, ama berde, ama geedcanab, amase rummaanno; oo biyo la cabbona laguma arko. ");
INSERT INTO som_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Markaasay Muuse iyo Haaruun ururka hortiisii uga tageen iriddii teendhadii shirka, kolkaasay wejiga dhulka dhigeen, oo waxaa iyagii u muuqatay ammaantii Rabbiga. ");
INSERT INTO som_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Markaasaa Rabbigu Muuse la hadlay, oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","Usha qaado, oo adiga iyo walaalkaa Haaruun dadka shirka ah oo dhan soo shiriya, oo iyagoo arkaya dhagaxa la hadla, biyo ha soo daayee; oo waa inaad iyaga dhagaxa biyo uga keentaa, si aad u wada waraabisid shirka iyo lo'doodaba. ");
INSERT INTO som_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Markaasaa Muuse ushii ka qaatay Rabbiga hortiisa, siduu isaga ugu amray. ");
INSERT INTO som_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Kolkaasay Muuse iyo Haaruun ururkii oo dhan ku soo ururiyeen dhagaxa hortiisii, oo wuxuu iyagii ku yidhi, War bal maqla, caasiyiin yahay. Dhagaxan biyo ma idiinka soo daynaa? ");
INSERT INTO som_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Kolkaasaa Muuse gacanta kor u qaaday, oo dhagaxii ayuu ushiisii laba jeer ku dhuftay; oo waxaa ka soo baxay biyo aad u badan, oo shirkii iyo lo'doodiiba way wada cabbeen. ");
INSERT INTO som_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Markaasaa Rabbigu Muuse iyo Haaruun ku yidhi, Idinku ima aydaan rumaysan, oo quduusna igama aydaan dhigin reer binu Israa'iil hortooda, haddaba sidaas daraaddeed idinku shirkan geeyn maysaan dalkii aan iyaga siiyey. ");
INSERT INTO som_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Kuwanu waa biyihii Meriibaah, maxaa yeelay, reer binu Israa'iil way la dirireen Rabbiga, oo wuxuu iyaga tusay inuu quduus yahay. ");
INSERT INTO som_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Markaasaa Muuse kuwa farriin wada Qaadeesh uga diray boqorkii reer Edom, oo wuxuu ku yidhi, Annagoo ah walaalahaa ilma Israa'iil waxaannu kugu leennahay, Waad garanaysaa dhibkii nagu soo dhacay oo dhan, ");
INSERT INTO som_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","iyo sida awowayaashayo dalkii Masar u tageen, iyo inaannu Masar wakhti dheer degganayn. Masriyiintu aad iyo aad bay noo xumeeyeen annaga iyo awowayaashayoba. ");
INSERT INTO som_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Oo markaannu Rabbiga u qayshannay, codkayagii wuu maqlay, oo wuxuu noo soo diray malaa'ig, oo Masarna wuu naga soo bixiyey, oo haddana waxaannu joognaa Qaadeesh oo ah magaalo ku taal soohdintaada darafkeeda. ");
INSERT INTO som_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Waan ku baryayaaye, na daa aan dalkaaga dhex marnee. Kaa dhex mari mayno berrin ama beercanab, oo ceelasha biyahoodana ka cabbi mayno. Waxaannu iska maraynaa boqorka waddadiisa oo ugu leexan mayno xagga midigta ama xagga bidixda jeeraannu soohdintaada ka baxno. ");
INSERT INTO som_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Markaasaa boqorkii Edom wuxuu ku yidhi, Dalkayga waa inaanad soo dhex marin yaanan seef kuula soo bixine. ");
INSERT INTO som_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Markaasaa reer binu Israa'iil waxay ku yidhaahdeen, Annagu waddada weyn baannu iska maraynaa, oo annaga iyo lo'dayaduba haddaannu biyo kaa cabno qiimahooda waannu ku siinaynaa, haddaba annagoo aan innaba wax kale samayn aan dalkaaga cagaha ku dhex marno. ");
INSERT INTO som_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Oo isna wuxuu yidhi, Dalkayga soo dhex mari maysaan. Markaasaa boqorkii Edom wuxuu u soo baxay reer binu Israa'iil isagoo gacan xoog leh dad badan ku wata. ");
INSERT INTO som_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Oo sidaasuu boqorkii Edom ugu diiday reer binu Israa'iil inay soohdintiisa soo dhex maraan, oo saas aawadeed reer binu Israa'iil isagii way ka leexdeen. ");
INSERT INTO som_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Oo Qaadeesh way ka guureen, oo reer binu Israa'iil xataa shirkii oo dhammu waxay yimaadeen Buur Xor. ");
INSERT INTO som_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Markaasaa Rabbigu Muuse iyo Haaruun kula hadlay Buur Xor oo ku ag taal soohdinta dalka Edom oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","Haaruun wuxuu ku darman doonaa dadkiisii, waayo, isagu geli maayo dalkii aan siiyey reer binu Israa'iil, maxaa yeelay, hadalkaygii waad ku caasideen markaad biyihii Meriibaah ag joogteen. ");
INSERT INTO som_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Haddaba Haaruun iyo wiilkiisa Elecaasaar soo wad, oo waxaad iyaga keentaa Buur Xor. ");
INSERT INTO som_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Oo markaas Haaruun dharkiisa ka bixi oo waxaad u gelisaa wiilkiisa Elecaasaar, oo Haaruun dadkiisa wuu ku darman doonaa, oo halkaasuu ku dhiman doonaa. ");
INSERT INTO som_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Markaasaa Muuse sameeyey sidii Rabbigu ku amray, oo waxay fuuleen Buur Xor iyadoo shirkii oo dhammu ay u jeedaan. ");
INSERT INTO som_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Markaasaa Muuse Haaruun ka bixiyey dharkiisii, oo wuxuu u geliyey wiilkiisii Elecaasaar, markaasaa Haaruun ku dhintay halkaas oo ahaa buurtii dhaladeeda; kolkaasay Muuse iyo Elecaasaar buurtii ka soo degeen. ");
INSERT INTO som_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Oo markii shirkii oo dhammu ay arkeen in Haaruun dhintay ayaa reer binu Israa'iil oo dhammu waxay Haaruun u ooyeen intii soddon maalmood ah. ");
INSERT INTO som_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Oo boqorkii Caraad, oo reer Kancaan, oo xagga koonfureed degganaa ayaa maqlay in reer binu Israa'iil ka yimaadeen xagga jidka Ataariim, markaasuu la diriray reer binu Israa'iil oo qaarkood qabsaday. ");
INSERT INTO som_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Markaasay reer binu Israa'iil Rabbiga nidar u nidreen oo waxay yidhaahdeen, Hubaal haddaad dadkan gacantayada soo gelisid markaas magaalooyinkooda oo dhan waannu wada baabbi'inaynaa. ");
INSERT INTO som_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Oo Rabbigu wuu dhegaystay codkii reer binu Israa'iil, oo gacantooda buu soo geliyey reer Kancaan, oo iyana iyagii iyo magaalooyinkoodiiba way wada baabbi'iyeen, oo meeshaas magaceediina waxaa loo bixiyey Xormaah. ");
INSERT INTO som_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Oo Buur Xor waxay uga guureen xagga jidka loo maro Badda Cas inay hareer ka maraan dalka reer Edom. Markaasay dadku aad u qalbi jabeen jidkii daraaddiis. ");
INSERT INTO som_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Oo dadkii waxay ku hadleen wax ka gees ah Ilaah iyo Muuseba, oo waxay yidhaahdeen, War dalkii Masar maxaad nooga soo bixiseen si aannu cidladan ugu dhimanno? Waayo, kibis ma jirto, biyona ma jiraan, oo naftayaduna kibistan khafiifka ah way ku yaqyaqsataa. ");
INSERT INTO som_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Markaasaa Rabbigu wuxuu dadka dhexdiisii ku soo daayay abeesooyin qaniinyo kulul oo ay dadkii qanqaniineen, oo dad badan oo reer binu Israa'iil ah ayaa dhintay. ");
INSERT INTO som_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Markaasay dadkii Muuse u yimaadeen, oo waxay ku yidhaahdeen, Annagu waannu dembaabnay, maxaa yeelay, waxaannu ku hadalnay wax ka gees ah Rabbiga iyo adiga, haddaba Rabbiga noo bari inuu abeesooyinka naga fogeeyo. Markaasaa Muuse dadkii u baryay Rabbiga. ");
INSERT INTO som_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Oo Rabbigu wuxuu Muuse ku yidhi, Abeeso samee, oo tiircalan kor saar, oo mid kasta oo la qaniinoba, markuu arko wuu noolaanayaa. ");
INSERT INTO som_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Oo Muuse baa abeeso naxaas ah sameeyey oo wuxuu kor saaray tiirkii calanka, oo haddii abeeso qof qaniinto oo qofku soo eego abeesadii naxaasta ahayd wuu noolaan jiray. ");
INSERT INTO som_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Markaasaa reer binu Israa'iil soo guureen, oo waxay degeen Obod. ");
INSERT INTO som_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Oo Obodna way ka guureen, oo waxay degeen Ciyee Hacabaariim oo cidlada ku dhex taal oo ah Moo'aab horteeda oo xagga qorrax ka soo baxa ah. ");
INSERT INTO som_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Oo halkaasna way ka guureen, oo waxay degeen dooxadii Sered, ");
INSERT INTO som_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Halkaasna way ka guureen, oo waxay deggeen Webi Arnoon dhankiisa kale, kaasoo cidlada ku yaal oo soohdinta reer Amor ka soo baxa, waayo, Webi Arnoon waa soohdinta reer Moo'aab oo wuxuu u dhexeeyaa reer Moo'aab iyo reer Amor. ");
INSERT INTO som_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Haddaba kitaabkii dagaalladii Rabbiga waxaa ku qoran, Waaheeb oo Suufaah ku taal, Iyo dooxooyinka Arnoon, ");
INSERT INTO som_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","Iyo dhaadhaca dooxooyinka Oo u dadban xagga rugta Caar, Oo u dhow soohdinta reer Moo'aab. ");
INSERT INTO som_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Oo halkaasna waxay uga guureen xagga Bi'ir, kaasoo ah ceelkii Rabbigu Muuse kaga yidhi, Dadka oo dhan soo ururi, oo anna biyo waan siinayaa. ");
INSERT INTO som_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Markaasay reer binu Israa'iil gabaygan ku gabyeen, Ceel yahow, soo durdur. War idinku u gabya ");
INSERT INTO som_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Ceelkii ay amiirradii qodeen, Oo ay dadkii gobta ahu ku qodeen Ushii dowladnimada iyo ulahoodii. Oo cidladiina waxay uga guureen xagga Mataanaah. ");
INSERT INTO som_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Oo Mataanaahna waxay uga guureen xagga Naxalii'eel; Naxalii'eelna waxay uga guureen xagga Baamood. ");
INSERT INTO som_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Oo Baamoodna waxay uga guureen xagga dooxadii ku taal bannaanka Moo'aab, iyo Buur Fisgaah dhaladeeda oo cidlada hoos u soo fiirisa. ");
INSERT INTO som_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Markaasay reer binu Israa'iil wargeeyayaal u direen Siixon oo ahaa boqorkii reer Amor, oo waxay ku yidhaahdeen, ");
INSERT INTO som_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","Na daa aan dalkaaga dhex marnee. Annagu gees ugu leexan mayno berrin ama beercanab, oo ceelashana biyo ka cabbi mayno. Waxaannu iska maraynaa boqorka waddadiisa jeeraannu soohdintaada ka baxno. ");
INSERT INTO som_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Siixonse uma uu oggolaan in reer binu Israa'iil soohdintiisa soo dhex maraan; laakiinse Siixon dadkiisii oo dhan ayuu soo urursaday oo ku soo baxay reer binu Israa'iil oo cidlada jooga, oo wuxuu yimid Yahas, oo uu reer binu Israa'iil la diriray. ");
INSERT INTO som_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Markaasay reer binu Israa'iil seef ku dileen, oo waxay qabsadeen dalkiisii tan iyo Arnoon iyo ilaa Yabboq, iyo xataa tan iyo reer Cammoon, waayo, soohdintii reer Cammoon wuu xoog badnaa. ");
INSERT INTO som_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Oo reer binu Israa'iil magaalooyinkan oo dhan ayay qabsadeen, oo reer binu Israa'iil waxay degeen magaalooyinkii reer Amor oo dhan, xataa Xeshboon iyo magaalooyinkeedii oo dhan. ");
INSERT INTO som_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Waayo, Xeshboon waxay ahayd magaaladii Siixon oo ahaa boqorkii reer Amor, oo la diriray boqorkii hore oo reer Moo'aab, oo dalkiisii oo dhan ka qabsaday, xataa tan iyo Arnoon. ");
INSERT INTO som_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Oo sidaas daraaddeed kuwa maahmaahyo ku hadlaa waxay yidhaahdaan, War Xeshboon kaalaya, Magaaladii Siixon ha la dhiso oo ha la xoojiyo, ");
INSERT INTO som_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Waayo, dab baa ka soo baxay Xeshboon, Taasoo ah magaaladii Siixon oo olol ka soo baxay. Wuxuu baabbi'iyey Caartii reer Moo'aab, Iyo sayidyadii meelaha sare oo Arnoon. ");
INSERT INTO som_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Moo'aabay, waa kuu hoog! Waad baabba'day, dadka reer Khemooshow. Wiilashiisii wuxuu u sii daayay sida laajiyo, Gabdhihiisiina wuxuu maxaabiis ahaan ugu sii daayay Boqorka reer Amor oo Siixon ahaa. ");
INSERT INTO som_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Iyaga waannu toogannay; oo Xeshboon waa baabba'day tan iyo Diibon, Oo annagu waxaannu baabbi'innay tan iyo Nofax, Taasoo gaadha tan iyo Meedebaa. ");
INSERT INTO som_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Oo sidaasay reer binu Israa'iil u degeen dalkii reer Amor. ");
INSERT INTO som_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Markaasaa Muuse diray rag soo basaasa Yacser, oo iyana way qabsadeen magaalooyinkeedii, oo reer Amorkii halkaas degganaana way ka eryeen. ");
INSERT INTO som_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Oo intay leexdeen ayay waxay tageen xagga jidka Baashaan loo maro. Markaasaa waxaa ku soo baxay Coog oo ahaa boqorkii Baashaan, isagii iyo dadkiisii oo dhanba, inay kula diriraan Edrecii. ");
INSERT INTO som_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Markaasaa Rabbigu Muuse ku yidhi, Ha ka cabsan, waayo, gacantaadaan geliyey isaga iyo dadkiisa oo dhan iyo dalkiisa, oo waxaad isaga ku samayn doontaa sidii aad ku samaysay Siixon oo ahaa boqorkii reer Amor oo Xeshboon degganaa. ");
INSERT INTO som_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Oo iyana waxay dileen isagii, iyo wiilashiisii, iyo dadkiisii oo dhan ilaa ayan isagii waxba u hadhin, oo dalkiisiina way qabsadeen. ");
INSERT INTO som_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Markaasaa reer binu Israa'iil guureen, oo waxay degeen bannaanka Moo'aab oo Webi Urdun ka shisheeya oo Yerixoo ka soo hor jeeda. ");
INSERT INTO som_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Oo Baalaaq ina Sifoor wuxuu arkay kulli wixii ay reer binu Israa'iil ku sameeyeen reer Amor. ");
INSERT INTO som_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Oo reer Moo'aab dadka bay ka cabsadeen, maxaa yeelay, iyagu aad bay u badnaayeen, oo reer Moo'aab aad iyo aad bay u welweleen reer binu Israa'iil aawadood. ");
INSERT INTO som_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Markaasaa reer Moo'aab waxay ku yidhaahdeen odayaashii reer Midyaan, Sida dibi u dhammaysto cawska berrinka ayaa dadkan faraha badanu waxa hareerahayaga ku wareegsan oo dhan u dhammaysanayaan. Oo wakhtigaas waxaa reer Moo'aab boqor u ahaa Baalaaq ina Sifoor. ");
INSERT INTO som_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Oo wargeeyayaal buu u diray Balcaam ina Becoor oo joogay Fetoor oo Webiga ku ag taal oo ah dalkii dadkiisa si ay ugu yeedhaan oo wuxuu ku yidhi, Bal eeg, halkan waxaa jooga dad Masar ka yimid, oo dhulkii oo dhan way qarinayaan, oo waxay deggan yihiin hortayda. ");
INSERT INTO som_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Haddaba waan ku baryayaaye kaalay oo dadkan ii habaar, waayo, way iga xoog badan yihiin, oo mindhaa waan ka adkaanayaa si aannu ugu layno, oo dalka uga erinno, waayo, waan ogahay in kii aad u ducaysaa wuu ducaysan yahay, kii aad habaartaana wuu habaaran yahay. ");
INSERT INTO som_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Markaasaa odayaashii reer Moo'aab iyo odayaashii reer Midyaan waxay gacantooda ku qaadeen abaalgudkii habaaridda, oo waxay u tageen Balcaam, oo isagay kula hadleen erayadii Baalaaq. ");
INSERT INTO som_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Oo isna wuxuu ku yidhi iyagii, Caawa halkan ku barya oo anna war dambaan idiinka keenayaa wixii Rabbigu igula hadlo. Markaasay amiirradii reer Moo'aab la hoydeen Balcaam. ");
INSERT INTO som_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Markaasaa Ilaah Balcaam u yimid, oo wuxuu ku yidhi, War nimanka kula joogaa yay yihiin? ");
INSERT INTO som_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Markaasaa Balcaam wuxuu Ilaah ku yidhi, Baalaaq ina Sifoor oo ah boqorkii reer Moo'aab ayaa ii soo diray oo yidhi, ");
INSERT INTO som_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","Bal eeg, dadka Masar ka yimid waxay qarinayaan dhulka oo dhan, haddaba kaalay oo ii habaar, oo mindhaa waan karayaa inaan iyaga la diriro oo aan eryado. ");
INSERT INTO som_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Markaasaa Rabbigu wuxuu Balcaam ku yidhi, Waa inaanad iyaga raacin, oo waa inaanad dadka habaarin, waayo, iyagu waa barakaysan yihiin. ");
INSERT INTO som_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Aroortii dambe ayaa Balcaam kacay, oo wuxuu amiirradii Baalaaq ku yidhi, Dalkiinnii taga, waayo, Rabbigu fasax buu ii diidaa inaan idin raaco. ");
INSERT INTO som_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Markaasaa amiirradii reer Moo'aab kaceen, oo Baalaaq u tageen, oo waxay ku yidhaahdeen, Balcaam waa diiday inuu na soo raaco. ");
INSERT INTO som_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Oo Baalaaq haddana wuxuu diray amiirro kale oo kuwii hore ka sii badan oo ka sii derejo weyn. ");
INSERT INTO som_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Oo iyana Balcaam bay u tageen, oo waxay ku yidhaahdeen, Baalaaq ina Sifoor wuxuu kugu leeyahay, Waan ku baryayaaye inaad ii timaado yaanay waxba kaa hor joogsan. ");
INSERT INTO som_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Waxaan ku siinayaa derejo sharaf ah, oo wax alla wixii aad igu tidhaahdona waan samaynayaa. Haddaba waan ku baryayaaye kaalay oo dadkan ii habaar. ");
INSERT INTO som_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Markaasaa Balcaam jawaabay, oo wuxuu addoommadii Baalaaq ku yidhi, Haddii Baalaaq i siiyo gurigiisa oo lacag iyo dahab ka buuxo, anigu kama tallaabsan karo erayga Rabbiga Ilaahayga ah inaan sameeyo wax ka yar iyo wax ka badan toona. ");
INSERT INTO som_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Haddaba waan idin baryayaaye, Bal caawa halkan isaga hoyda, bal aan soo ogaado waxa kaloo Rabbigu igula hadlee. ");
INSERT INTO som_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Oo habeennimadii ayaa Ilaah Balcaam u yimid, oo wuxuu ku yidhi, Haddii nimanku u yimaadeen inay kuu yeedhaan, kac oo iyaga raac; laakiinse waxaad yeeshaa aan kugula hadlo oo keliya. ");
INSERT INTO som_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Oo subaxdii dambe ayaa Balcaam kacay oo dameertiisii kooraystay, kolkaasuu raacay amiirradii reer Moo'aab. ");
INSERT INTO som_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Oo Ilaah cadhadiisiina way kululaatay, maxaa yeelay, Balcaam baa tegey. Markaasaa malaa'igtii Rabbigu jidka istaagtay iyadoo cadow ku ah isaga. Haddaba isagu wuxuu iska fuushanaa dameertiisii, oo labadiisii addoonna way la socdeen. ");
INSERT INTO som_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Markaasaa dameertii waxay aragtay malaa'igtii Rabbiga oo jidka taagan oo seefteedii oo galka ka baxsan gacanta ku haysata. Kolkaasay dameertii jidka ka leexatay oo berrinka gashay. Oo Balcaamna dameertii wax buu ku dhuftay si uu jidka ugu soo celiyo. ");
INSERT INTO som_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Markaasaa malaa'igtii Rabbigu waxay istaagtay surun beercanabyada ku dhex yaal oo dhankan deyr ka yahay, dhanka kalena deyr ka yahay. ");
INSERT INTO som_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Oo haddana dameertii waxay aragtay malaa'igtii Rabbiga, markaasay derbiga isku jiidday, oo Balcaam cagtiisii ayay derbigii kula qabatay, oo isna haddana wax buu ku dhuftay. ");
INSERT INTO som_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Markaasaa malaa'igtii Rabbigu hore u sii socotay oo waxay istaagtay meel cidhiidhi ah oo aan meel looga leexdo lahayn midig iyo bidix toona. ");
INSERT INTO som_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Oo haddana dameertii waxay aragtay malaa'igtii Rabbiga, markaasay iska jiifsatay Balcaam hoostiisa, Balcaamna wuu cadhooday, oo dameertii usha ku dhuftay. ");
INSERT INTO som_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Markaasaa Rabbigu afka dameerta furay oo waxay Balcaam ku tidhi, War maxaan kugu sameeyey oo aad saddexdan jeer ii dishay? ");
INSERT INTO som_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Markaasaa Balcaam dameertii ku yidhi, Maxaa yeelay, adigu waad igu majaajilootay. Oo weliba waxaan jeclaan lahaa in seefu gacantayda ku jirto, waayo, waan ku dili lahaa hadda. ");
INSERT INTO som_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Markaasaa dameertii Balcaam ku tidhi, War sow ma ahi dameertaadii aad cimrigaaga oo dhan fuuli jirtay ilaa maantadan? Oo miyaan hore sidan oo kale weligay kugu sameeyey? Oo isna wuxuu ku yidhi, Maya. ");
INSERT INTO som_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Kolkaasaa Rabbigu Balcaam indhaha u furay oo wuxuu arkay malaa'igtii Rabbiga oo jidka dhex taagan oo seefteedii oo galka ka baxsan gacanta ku haysata. Markaasuu madaxa foororiyey oo sujuuday. ");
INSERT INTO som_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Kolkaasaa malaa'igtii Rabbigu waxay isagii ku tidhi, War maxaad dameertaada u dishay saddexdan jeer? Bal eeg, anigu waxaan u soo baxay cadow ahaan, maxaa yeelay, jidkaagu hortayda waa ku qalloocan yahay. ");
INSERT INTO som_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Oo dameertuna anay i aragtay oo saddexdan jeerba hortayday ka leexatay. Oo haddaanay iga leexan, hubaal waan ku dili lahaa, iyadase waan badbaadin lahaa. ");
INSERT INTO som_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Oo Balcaam wuxuu malaa'igtii Rabbiga ku yidhi, Waan dembaabay, waayo, ma aan ogayn inaad jidka taagan tahay adigoo iga gees ah. Haddaba haddii sidaasu ku xumayso, dib baan u noqonayaa. ");
INSERT INTO som_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Markaasaa malaa'igtii Rabbigu Balcaam ku tidhi, Orod oo nimanka raac; laakiinse hadalkii aan kula hadlo oo keliya waa inaad ku hadashaa. Sidaas daraaddeed Balcaam wuxuu raacay amiirradii Baalaaq soo diray. ");
INSERT INTO som_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Oo Baalaaq markuu maqlay in Balcaam yimid ayuu u baxay inuu isaga ku qaabbilo magaaladii Moo'aab oo ku taal soohdinta Arnoon oo ah soohdinta darafkeeda. ");
INSERT INTO som_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Markaasaa Baalaaq wuxuu Balcaam ku yidhi, War sow degdeg dad kuuguma soo dirin inay kuu yeedhaan? Maxaad iigu iman weyday? Miyaanan awoodin inaan derejo weyn ku siiyo? ");
INSERT INTO som_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Kolkaasaa Balcaam wuxuu Baalaaq ku yidhi, Haddaba waa i kan oo waan kuu imid. War anigu ma waxaan leeyahay awood aan wax kaga hadlo innaba ha ahaatee? Ereygii Ilaah afkayga geliyo ayaan ku hadli doonaa. ");
INSERT INTO som_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Markaasaa Balcaam raacay Baalaaq, oo waxay yimaadeen Qiryad Xusood. ");
INSERT INTO som_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Markaasaa Baalaaq allabari u bixiyey dibi iyo ido, oo wax buu u diray Balcaam iyo amiirradii isaga la joogay. ");
INSERT INTO som_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Oo subaxdii dambe ayaa Baalaaq kaxaystay Balcaam, oo wuxuu keenay meelihii sare oo Bacal, oo halkaas wuxuu ka arkay dadka darafkii ugu shisheeya. ");
INSERT INTO som_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Oo Balcaam wuxuu Baalaaq ku yidhi, Halkan iiga dhis toddoba meelood oo allabari, oo halkan iigu soo diyaari toddoba dibi iyo toddoba wan. ");
INSERT INTO som_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Markaasaa Baalaaq sameeyey sidii Balcaam ku hadlay, oo Baalaaq iyo Balcaam meel kasta oo allabariba waxay ku dul bixiyeen dibi iyo wan. ");
INSERT INTO som_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Kolkaasaa Balcaam Baalaaq ku yidhi, Allabarigaaga la gubo ah istaag, oo anna waan tegayaa, mindhaa Rabbigu waa iga hor iman doonaa, oo wax alla wixii uu i tuso waan kuu sheegi doonaa. Markaasuu meel sare oo bannaan tegey. ");
INSERT INTO som_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Kolkaasaa Ilaah Balcaam ka hor yimid, oo wuxuu ku yidhi, Waxaan diyaariyey toddobada meelood oo allabari, oo meel kastaba waxaan ku dul bixiyey dibi iyo wan. ");
INSERT INTO som_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Markaasaa Rabbigu eray Balcaam afka u geliyey, oo wuxuu ku yidhi, Baalaaq ku noqo oo sidatan ula hadal. ");
INSERT INTO som_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Oo isna markaasuu ku noqday, oo wuxuu arkay isagoo ag taagan allabarigiisii la gubo, isagii iyo amiirradii reer Moo'aab oo dhan. ");
INSERT INTO som_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Markaasuu hadalkiisii bilaabay oo wuxuu yidhi, Baalaaq oo ah boqorkii reer Moo'aab oo ka yimid xagga buuraha bariga Ayaa iga keenay Araam, oo yidhi, Kaalay oo reer Yacquub ii habaar, Oo kaalay, cadhadaadu reer binu Israa'iil ha ku dhacdo. ");
INSERT INTO som_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Bal sidee baan u habaaraa mid aan Ilaah habaarin? Oo sidee baan ugu cadhoodaa mid aan Rabbigu ka cadhaysnayn? ");
INSERT INTO som_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Waayo, dhagaxyada dushooda ayaan ka arkaa, Oo xagga buuraha ayaan uga jeedaa, Oo bal eeg, waa dad gooni u deggan, Iyagana quruumaha kale laguma tirin doono. ");
INSERT INTO som_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Bal yaa qiyaasi kara reer Yacquub oo sida boodhka ah? Amase yaa tirin kara reer binu Israa'iil rubuciis? Anigu aan u dhinto sida kuwa xaqa ahu u dhintaan, Oo ugu dambaystayduna ha ahaato sida tooda oo kale. ");
INSERT INTO som_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Kolkaasaa Baalaaq wuxuu Balcaam ku yidhi, War waa maxay waxa aad igu samaysay? Waxaan ku soo watay inaad cadaawayaashayda habaartid, laakiinse bal eeg, waad u wada ducaysay. ");
INSERT INTO som_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Kolkaasuu u jawaabay oo wuxuu ku yidhi, Sow waajib iguma aha inaan isjiro si aan ugu hadlo wixii Rabbigu afkayga geliyo? ");
INSERT INTO som_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Markaasaa Baalaaq isagii ku yidhi, Waan ku baryayaaye, Kaalay, oo meel kale ii raac inaad halkaas iyaga ka aragtid. Waxaad arki doontaa darafkooda, oo kulligood ma arki doontid; haddaba halkaas iiga habaar. ");
INSERT INTO som_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Markaasuu isagii geeyey berrinkii Sofiim xagga Buur Fisgaah dhaladeeda, oo halkaasuu ka dhisay toddoba meelood oo allabari, oo meel kasta wuxuu ku dul bixiyey dibi iyo wan. ");
INSERT INTO som_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Oo markaasuu Baalaaq ku yidhi, Halkan allabarigaaga la gubo ag istaag intaan Rabbiga xaggaas shishe kaga hor tegayo. ");
INSERT INTO som_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Markaasaa Rabbigu ka hor yimid Balcaam, oo eray buu afka u geliyey, oo wuxuu ku yidhi, Baalaaq ku noqo, oo sidatan ula hadal. ");
INSERT INTO som_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Markaasuu isagii u yimid, oo wuxuu arkay isagoo ag taagan allabarigiisii la gubo, oo waxaa isaga la jiray amiirradii reer Moo'aab. Kolkaasaa Baalaaq isagii ku yidhi, War Rabbigu muxuu ku hadlay? ");
INSERT INTO som_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Markaasuu hadalkiisii sii watay, oo wuxuu yidhi, Baalaaq, kac oo maqal, Bal aniga i dhegayso, ina Sifoorow. ");
INSERT INTO som_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Ilaah ma aha nin been sheego; Mana aha binu-aadmi qoomameeyo. Ma wuxuu yidhi buusan samaynayn? Ama ma wuxuu ku hadlay buusan yeelayn? ");
INSERT INTO som_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Bal eeg, waxaa laygu amray inaan u duceeyo. Isagaa barakeeyey, anna barakadaas ma aan beddeli karo. ");
INSERT INTO som_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Isagu reer Yacquub dembi kuma uu arag, Oo reer binu Israa'iil qalloocsanaan ugama uu jeedin. Rabbiga Ilaahood ah ayaa iyaga la jira, Oo waxaa dhexdooda ka yeedhaysa boqor qayladiis. ");
INSERT INTO som_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Ilaah baa iyaga Masar ka soo bixiyey, Iyagu waxay leeyihiin xoog gisiyeed oo kale, ");
INSERT INTO som_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Hubaal sixir reer Yacquub kuma dhaco, Oo reer binu Israa'iil innaba fal ma qabto, Haddaba Yacquub iyo Israa'iil waxaa laga sheegi doonaa, Bal fiiri waxa Ilaah sameeyey! ");
INSERT INTO som_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Bal eeg, dadku wuxuu u kacaa sidii gool oo kale, Oo sidii aar oo kale ayuu isu qaadaa: Oo isagu jiifsan maayo jeeruu ugaadh cuno, Oo uu dhiigga ka cabbo waxa uu dishay. ");
INSERT INTO som_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Markaasaa Baalaaq wuxuu Balcaam ku yidhi, War iyaga hana habaarin, hana u ducayn innaba. ");
INSERT INTO som_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Laakiinse Balcaam ayaa jawaabay oo wuxuu Baalaaq ku yidhi, Sow kuuma sheegin oo kuguma odhan, Wixii Rabbigu ku hadlo oo dhan waa inaan sameeyaa? ");
INSERT INTO som_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Markaasaa Baalaaq wuxuu Balcaam ku yidhi, Haddaba kaalay, meel kalaan ku geeynayaaye, mindhaa Ilaah waa ku farxi doonaa inaad iyaga halkaas iiga habaartid. ");
INSERT INTO som_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Markaasaa Baalaaq wuxuu Balcaam geeyey Buur Fecoor dhaladeeda taasoo lamadegaanka hoos u soo fiirisa. ");
INSERT INTO som_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Oo Balcaam wuxuu Baalaaq ku yidhi, Halkan iiga dhis toddoba meelood oo allabari, oo halkan iigu soo diyaari toddoba dibi iyo toddoba wan. ");
INSERT INTO som_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Markaasaa Baalaaq sameeyey sidii Balcaam ku yidhi, oo meel kasta oo allabariba wuxuu ku dul bixiyey dibi iyo wan. ");
INSERT INTO som_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Oo Balcaamna markuu arkay in Rabbigu ku farxay inuu reer binu Israa'iil barakeeyo, ma uu tegin sidii mararkii kale inuu sixir doondoono, laakiinse wuxuu wejigiisii u jeediyey xagga cidlada. ");
INSERT INTO som_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Markaasaa Balcaam indhaha kor u qaaday, oo wuxuu arkay reer binu Israa'iil oo qabiil qabiil u deggan, kolkaasaa waxaa isagii ku soo degay ruuxii Ilaah. ");
INSERT INTO som_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Markaasuu hadalkiisii watay oo wuxuu yidhi, Balcaam ina Becoor wuxuu leeyahay, Oo ninkii ishiisu daboolnaan jirtay wuxuu leeyahay, ");
INSERT INTO som_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Wuxuu leeyahay kii erayadii Ilaah maqla Oo tusniintii Ilaaha Qaadirka ah arka, Oo dhaca isagoo indhihiisu furan yihiin, ");
INSERT INTO som_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Teendhooyinkiinnu wanaagsanaa, Reer Yacquubow, Oo taambuugyadiinnu qurxoonaa, Reer binu Israa'iilow! ");
INSERT INTO som_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Waxay u fidsan yihiin sidii dooxooyin, Iyo sidii beero webiga barbarkiisa ku yaal, Iyo sidii geedo dacar ah oo Rabbigu beeray, Iyo sidii geedo kedar ah oo biyo ku ag yaal. ");
INSERT INTO som_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Baaldiyadooda waxaa ka daadan doona biyo, Oo farcankoodu wuxuu ku jiri doonaa biyo badan, Oo boqorkooduna wuu ka sarrayn doonaa Agag, Oo boqortooyadoodana waa la sarraysiin doonaa. ");
INSERT INTO som_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Ilaah baa iyaga Masar ka soo bixiyey, Oo iyagu waxay leeyihiin xoog gisiyeed oo kale, Oo waxay cuni doonaan quruumaha cadaawayaashooda ah, Oo lafahooda way jejebin doonaan, Oo waxay iyaga ka mudhbixin doonaan fallaadhahooda. ");
INSERT INTO som_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Iyagu hoos bay isu gaabiyeen, oo sida aar bay u jiifsadeen, Iyo sida gool libaax; haddaba bal yaa kicin doona? Duco ha ku dhacdo ku alla kii idiin duceeya, Oo habaarna ha ku dhaco ku alla kii idin habaara. ");
INSERT INTO som_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Markaasaa Baalaaq aad ugu cadhooday Balcaam, oo gacmihiisuu isku dhuftay. Oo Baalaaq wuxuu Balcaam ku yidhi, Waxaan kuugu yeedhay inaad cadaawayaashayda ii habaartid, oo bal eeg, saddexdan jeer baad u wada ducaysay. ");
INSERT INTO som_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Haddaba meeshaadii ku carar. Anigu waxaan damacsanaa inaan derejo weyn ku siiyo, laakiinse Rabbigu dib buu kaaga celiyey derejadii. ");
INSERT INTO som_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Kolkaasaa Balcaam wuxuu Baalaaq ku yidhi, War kuwii farriin kaa waday miyaanan u sheegin oo aanan ku odhan, ");
INSERT INTO som_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","Haddii Baalaaq i siiyo gurigiisa oo lacag iyo dahab ka buuxo, anigu kama tallaabsan karo erayga Rabbiga inaan maankayga ka sameeyo xumaan iyo samaan toona. Wixii Rabbigu ku hadlo, kaas uun baan ku hadli doonaa. ");
INSERT INTO som_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Haddaba waxaan u tegayaa dadkaygii, oo bal kaalay aan kuu sheego waxay dadkanu dadkaaga ku samayn doonaan maalmaha ugu dambaysta. ");
INSERT INTO som_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Markaasuu hadalkiisii sii watay oo wuxuu yidhi, Balcaam ina Becoor wuxuu leeyahay, Oo ninkii ishiisu daboolnaan jirtay wuxuu leeyahay, ");
INSERT INTO som_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Wuxuu leeyahay kii erayadii Ilaah maqla, Oo yaqaan aqoonta Kan ugu sarreeya, Oo tusniintii Ilaaha Qaadirka ah arka, Oo dhaca, isagoo indhihiisu furan yihiin, ");
INSERT INTO som_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Isagaan arkaa, haddase ma aha, Waan u jeedaa, mase dhowa, Reer Yacquub xiddig baa ka soo bixi doonta, Reer binu Israa'iil waxaa ka soo kici doonta ul boqortooyo, Oo waxay burburin doontaa rukummada Moo'aab, Oo waxay baabbi'in doontaa dadka Sheed oo dhan. ");
INSERT INTO som_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Oo dalka Edom wuxuu noqonayaa hantidooda, Oo Seciir oo isna cadowgooda ahaa hantidooduu noqonayaa. Oo reer binu Israa'iil way xoogaysan doonaan. ");
INSERT INTO som_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Oo mid reer Yacquub ka soo farcamay ayaa xukun yeelan doona, Oo wuxuu baabbi'in doonaa kuwa magaalada ka hadha. ");
INSERT INTO som_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Markaasuu Camaaleq eegay, oo hadalkiisii sii watay oo yidhi, Camaaleq wuxuu ahaa kan quruumaha ugu horreeya, Laakiinse ugudambaysta wuu halligmi doonaa. ");
INSERT INTO som_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Oo haddana wuxuu eegay reer Qeyn, markaasuu hadalkiisii sii watay oo yidhi, Meeshaad deggan tihiin waa adag tahay, Oo buulkiinnana dhagaxaa laga dhisay. ");
INSERT INTO som_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Habase yeeshee waa laydin baabbi'in doonaa, reer Qeynow, Jeer ay reer Ashuur maxaabiis ahaan idiin kaxaystaan. ");
INSERT INTO som_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Markaasuu hadalkiisii sii watay oo wuxuu yidhi, Hoogay, ee bal yaa sii noolaan doona markii Ilaah waxan sameeyo? ");
INSERT INTO som_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Laakiinse doonniyo waxay ka iman doonaan xeebta Kitiim, Oo waxay dhibi doonaan Ashuur, oo waxay dhibi doonaan Ceeber, Oo isna wuu halligmi doonaa. ");
INSERT INTO som_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Markaasaa Balcaam kacay oo ku noqday meeshiisii; Baalaaqna wuu iska tegey. ");
INSERT INTO som_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Oo reer binu Israa'iilna waxay iska degeen Shitiim, markaasay dadkii bilaabeen inay ka dhillaystaan gabdhihii reer Moo'aab, ");
INSERT INTO som_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","waayo, dadkii bay ugu yeedheen allabaryadii ilaahyadooda, markaasay dadkii wax cuneen, oo waxay u sujuudeen ilaahyadoodii. ");
INSERT INTO som_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Oo reer binu Israa'iil waxay isku dareen Bacal Fecoor. Markaasaa Rabbiga cadhadiisii aad ugu kululaatay reer binu Israa'iil. ");
INSERT INTO som_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Kolkaasaa Rabbigu Muuse ku yidhi, Dadka madaxdiisa oo dhan soo wado oo maalin cad ku deldel Rabbiga hortiisa in cadhadii kululayd oo Rabbigu ay ka soo noqoto reer binu Israa'iil. ");
INSERT INTO som_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Kolkaasaa Muuse wuxuu xaakinnadii reer binu Israa'iil ku yidhi, Idinka mid waluba ha dilo nimankiisii Bacal Fecoor isku daray. ");
INSERT INTO som_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Oo bal eeg, mid reer binu Israa'iil ah ayaa walaalihiis ula yimid naag reer Midyaan ah Muuse hortiisa iyo shirkii reer binu Israa'iil oo dhan hortooda iyagoo ku ooyaya iriddii teendhadii shirka horteeda. ");
INSERT INTO som_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Oo Fiinexaas ina Elecaasaar oo ahaa wadaadkii Haaruun wiilkiisii markuu taas arkay ayuu shirka dhexdiisii ka kacay oo wuxuu gacanta ku qaatay waran. ");
INSERT INTO som_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","Oo teendhadii ayuu uga daba galay ninkii reer binu Israa'iil, oo ninkii reer binu Israa'iil iyo naagtii labadiiba calooshuu ka wareemay. Markaasaa belaayadii laga joojiyey reer binu Israa'iil. ");
INSERT INTO som_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Oo intii belaayadii u dhimatay waxay ahaayeen afar iyo labaatan kun. ");
INSERT INTO som_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Kolkaasaa Rabbigu Muuse la hadlay, oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","Waxaa cadhadaydii reer binu Israa'iil ka celiyey Fiinexaas ina Elecaasaar oo ah wiilkii wadaadka Haaruun ah, waayo, dhexdooda ayuu iiga qiirooday, oo sidaas daraaddeed anigu qiiradaydii kuma aan baabbi'in reer binu Israa'iil. ");
INSERT INTO som_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Haddaba sidaas daraaddeed waxaad tidhaahdaa, Bal eeg, anigu waxaan isaga la dhiganayaa axdigaygii nabadda. ");
INSERT INTO som_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Oo isaga iyo farcankiisa ka dambeeyaba buu u ahaan doonaa axdiga wadaadnimo weligeed ah, maxaa yeelay, Ilaahiis buu qiiro u qabay, oo reer binu Israa'iil ayuu u kafaaro guday. ");
INSERT INTO som_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Haddaba ninkii reer binu Israa'iil oo la dilay, oo naagtii reer Midyaan lala dilay, magiciisu wuxuu ahaa Simrii ina Saaluu oo amiir u ahaa qoladiisa reer Simecoon. ");
INSERT INTO som_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Oo naagtii reer Midyaan oo la dilay magaceedu wuxuu ahaa Kaasbii ina Suur, oo aabbeheed wuxuu madax u ahaa qolo ka mid ah reer Midyaan. ");
INSERT INTO som_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Markaasaa Rabbigu Muuse la hadlay oo wuxuu ku yidhi, ");
INSERT INTO som_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","Reer Midyaan dhib oo laa iyaga, ");
INSERT INTO som_vpl VALUES ("NU25_18","0