﻿USE sofia;
DROP TABLE IF EXISTS sofia.sny_vpl;
CREATE TABLE sny_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES sny_vpl WRITE;
INSERT INTO sny_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ane, iyape ano Matyu, peri ape ne Jisas lo ya'ariyei lo lu tewi werese au lesesiya. Jisas Krais lo ya'ariyei sitewi aiwawe a'i Devit. Devit lo ya'ariyei sitewi aiwawe a'i Abraham. ");
INSERT INTO sny_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham lo meni eime Aisak. Aisak lo meni eime Jekop. Jekop lo meni eime Juda. Jekop eimane tomu ne'ese iroteye. ");
INSERT INTO sny_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda lo tani, iyape Tamar, eimane hesi auteiye. Lowesi iyape Peres, sosu Sera. Peres lo meni eime Hesron. Hesron lo meni eime Ram. ");
INSERT INTO sny_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram lo meni eime Aminadap. Aminadap lo meni eime Nason. Nason lo meni eime Salmon. ");
INSERT INTO sny_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon lo meni eime Boas. Boas lo mai Rahap. Boas menitani Rut naituwe. Sosu Rut meni eime Obet auteiye. Obet lo meni eime Jesi. ");
INSERT INTO sny_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesi lo meni eime Devit. Devit pani Israel lo meni owane tutawe henerai. Menitani ape meni eime Solomon auteiye. Menitani ape ne tu meni Uria lai naituwe. ");
INSERT INTO sny_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sosu Solomon lo meni eime Rehoboam. Sosu Rehoboam lo meni eime Abiya. Sosu Abiya lo meni eime Asa. ");
INSERT INTO sny_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Sosu Asa lo meni eime Jehosafat. Jehosafat lo meni eime Johoram. Sosu Johoram lo meni eime Usia. ");
INSERT INTO sny_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia lo meni eime Jotam. Sosu Jotam lo meni eime Ahas. Sosu Ahas lo meni eime Hesekia. ");
INSERT INTO sny_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Sosu Hesekia lo meni eime Manase. Sosu Manase lo meni eime Emon. Sosu Emon lo meni eime Josaia. ");
INSERT INTO sny_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Sosu Josaia lai Jekonia, sosu nairipi werese lo aite. Nowe ape se ai lu tamo lai lowe Juda lo lu tewi werese omo pani Babilon ma'e wiyawi yahowa'i ta'aneyei ne heneti. ");
INSERT INTO sny_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Sosu lowe omo Babilon ma'e heneti. Jekonia lo Tani meni eime Sealtiel auteiye. Sosu Sealtiel lo meni eime Serubabel. ");
INSERT INTO sny_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Sosu Serubabel lo meni eime Abiut. Sosu Abiut lo meni eime Eliakim. Sosu Eliakim lo meni eime Asor. ");
INSERT INTO sny_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Sosu Asor lo meni eime Sadok. Sosu Sadok lo meni eime Akim. Sosu Akim lo meni eime Eliut. ");
INSERT INTO sny_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Sosu Eliut lo meni eime Eleasar. Sosu Eleasar lo meni eime Matan. Sosu Matan lo meni eime Jekop. ");
INSERT INTO sny_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Sosu Jekop lo meni eime Josep. Sosu Josep lai menitani ta iyape Maria naituwe. Maria meni eime Jisas auteiye. Owane Sitewi lai tu naifa weriyei weriyei meni eime Jisas lu taune werese ne si tame ete hene aniyei ne ariariyeye. Serai meni ape Krais henerai. ");
INSERT INTO sny_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Sosu a'i pe Abraham lo lu tewi werese i tepa'asiye su, meni owane tutawe Devit henerai. Lu tewi werese ereti feni hesi, lowe hesiyo hesiyo (14) iroteye. Sosu aiwawe a'i Devit lo lu tewi ereti werese i tepa'asiye su, omo pani Babilon ma'e wiyawi yahowa'i a'i henetiyei ape, henerai. Lu tewi ereti feni hesi, lowe hesiyo hesiyo (14) iroteye. Sosu lu tewi kalabus sahe iroteye ape, lu tewi werese i tepa'asiye su, Krais ma'e henerai. Lu tewi werese ereti feni hesi, lowe hesiyo hesiyo (14) iroteye. Lu 2:17 ");
INSERT INTO sny_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Nowe ape se Maria meni eime Jisas auteiye. Peri ape apou te'eteye. Meni ape Josep lai menitani Maria naituwei ne ariariyeye. Maria meni Josep ma'e fai ta'ama. Menitani wati'are ape farere a'i iroteye. Ahowa, lowesi wesi tere'e tere'e sahe howeiteye. Nowe ape se Owane Sitewi lo Hepene Wara'i a'i lai menitani Maria ma'e eine tahe se au irowe. Serene Maria tahe se henerai. Lu 1:27,35 ");
INSERT INTO sny_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Sosu Josep Maria eine tahe se wanuwe su, le marepi erasi a'i toteye. Le lu taune werese lo nihe se menitani lo eine tahe se ne au te'e areiyerowata. Le meni aseyaro a'i ne. Le tani lo au neritaseye wou ta'ame. Serene le menitani lo tai mai ma'e eresene a'i se si tame eimawesawiyei ne toteye. ");
INSERT INTO sny_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Le marepi ape toteye su, Owane Sitewi lai ipari wisere a'i lo Josep ma'e eimawe arosai. Sosu Josep nihe howeiteye su, Owane Sitewi lo ipari wisere a'i (ensel) lai Josep ma'e suwou se au te'eye. Le Josep ma'e apou te'eye, “Josep Devit lo lu tewi, Wanure! Ne menitani wati'are, Maria, naituwei ne owe ape atoweiyere. Owane Sitewi lo Hepene Wara'i a'i lai Maria eine tahe se au irowe. ");
INSERT INTO sny_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nowe me'iye su, le meni eime auteiyei. Ne iyape lo Jisas au paporowa. Owane Sitewi lai meni eime ape lu taune werese lo yo seni luwaru a'i au sasariyei ne ariariyeye. Serai le lu taune werese si tame ete hene anirowa.” Lu 1:31; 2:21 ");
INSERT INTO sny_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Owane Sitewi lo ipari wisere a'i (ensel) Josep ma'e suwou se henerai su, Owane Sitewi lai peri ta lo au te'e siye meni lo ahi leseye ape, wiyeme a'i henerai. Tu naifa Owane Sitewi lo peri au te'e siye meni apou leseye. ");
INSERT INTO sny_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Wanure! Menitani wati'are ta, meni ta se howei ta'ame ape, eime tahe se henerairowa. Le me'iye su meni eime ta auteirowa. Lowe iyape paporowa, ‘Emanuel.’ Iyape ape lo sitewi apou a'i ‘Owane Sitewi nomo mase ironamirowa.’” ");
INSERT INTO sny_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Sosu Josep Owane Sitewi lo ipari wisere a'i (ensel) lo peri wanuwe su, le nihe howei sineyewe, Owane Sitewi lo peri werese umasiteye. Le menitani Maria naituwe. ");
INSERT INTO sny_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Sosu Josep lai menitani Maria wesi lo henetaiyewe, lowesi ironamiteye. Le tani lo mase howeiye ta'ama. Ahowa, Maria meni eime auteiye su, le tani lo mase howeinamiteye. Serai Josep meni eime ape au papowe, Jisas. Lu 2:21 ");
INSERT INTO sny_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","2","Nowe ape se awei meni owane erasi a'i iyape Herot, pani tewi Judia au noweinoweiteye. Sosu Maria lai Owane Sitewi lo meni eime omo Betlehem sahe auteiye. Meni eime auteiye su, eiwariyemi erasi yaru poweiye itori siye ma'e teiteye. Sosu awei lo marepi so'oruwe wisere a'i siye lu tamo, omo pani poweiye wirai ape, ma'e fai. Lowe eiwariyemi erasi ape siyeye. Lowe apou a'i toteye. “Meni Owane erasi a'i henerai tepa'asiye.” Serai lowe pani tewi lowe lo arunatiyewe, eiwariyemi erasi ape siye umasiti. Sosu omo Jerusalem ma'e henerai. Omo Jerusalem ma'e henerai su, lowe apou te'e toweriye, “Meni eime ape ate Juda lo meni owane tutawe ne, eiwerou ma'e irosiya awere? Nomo eiwariyemi lo ape poweiye yaru itori siye ma'e siyeyewe, serene nomo meni eime ne au te'e wisereyeyei ne fai.” Nam 24:17 ");
INSERT INTO sny_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Meni owane Herot peri ape wanuwe su, marepi lo erasi a'i auseriyeye. Sosu lu taune werese, omo Jerusalem sahe iroteye ape, aiwawe a'i meni eime ma'e marepi luwaru erasi a'i totenamiteye. ");
INSERT INTO sny_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Sosu a'i pe awei meni owane tutawe Herot lai Owane Sitewi lo wesi lu owane, Owane Sitewi lo peri so'oruwe siye lu tamo ei ta'uwe aniye. Lowe ta'uwerai su, le lowe ma'e ei toweriye, “Meni ape Krais piye omo ma'e henerairowa awere?” ");
INSERT INTO sny_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Sosu lowe le ma'e itiya'u eiye, “Krais nomo lo omo Betlehem pani tewi Judia sahe henerairowa. Owane Sitewi lo peri au te'e siye meni apou leseye, ");
INSERT INTO sny_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Fene lu taune werese omo Betlehem pani tewi Judia sahe irosiya. Omo Betlehem fene iyape erasi irosiya. Fene omo tomu ne'ese fene ma'e hi ani ararowe. Wanure! Meni ta, meni owane tutawe fene ma'e aiyerowa ape, henerairowa su, le Israel lo lu taune werese au noweinoweirowa.’” ");
INSERT INTO sny_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Sosu meni owane lai awei lo marepi wisere a'i siye lu ma'e eiwariyemi mo'o fai ape, eresene a'i ei ta'uwe aniye. Sosu le lowe ma'e ei toweriye, “Eiwerou su eiwariyemi erasi a'i siyeye awere?” Lowe itiya'u eiye, “Tu naifa nomo eiwariyemi erasi a'i ape siyeye.” ");
INSERT INTO sny_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Sosu le lowe omo Betlehem ma'e eimawesawi. Sosu le lowe ma'e eiye, “Fene meni eime ape nehi etire. Fene meni eime ape siyeyei su, peri heneruwe ape ane ma'e au te'esaire. Serai ane aiwawe a'i meni eime ape au te'e wisereyeyei. ");
INSERT INTO sny_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Sosu lowe meni owane lo peri wanuwe su, lowe omo Jerusalem arunatiyewe fi. Lowe fi su, eiwariyemi erasi a'i lowe tu siyeteye ape, tame siyeye. Lowe siyeye su, lowe marepi wisere a'i teriteye. Eiwariyemi ape meni eime yaru hire ma'e teiteye.” ");
INSERT INTO sny_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Sosu lowe wesi papu wiye su, lowe meni eime oso, mai lo, Maria, mase iroteye ape siyeye. Sosu lowe ape'i onuwe su, lowe meni eime ma'e etiri tamo neri a'i auwe. Etiri neriya'i a'i ape apou a'i ne, ma'aru gol tamo, sa'i heneri wisere a'i tamo, sosu tuwai wisere a'i tamo le ma'e auwe. Sng 72:10-15; Ais 60:6 ");
INSERT INTO sny_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Sosu Owane Sitewi lai lowe ma'e suwou se au te'eye. Apou au te'eye, “Fene pani tewi fene lo ma'e yo tere'e se si tame ire. Meni owane ape awera'iyenatire!” Sosu lowe omo Betlehem arunatiyewe, yo tere'e se si tame fi. ");
INSERT INTO sny_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Sosu a'i pe meni owane Herot lai meni eime oso a'i ape aine tera'eyei ne toteye. Serene Owane Sitewi lai ipari wisere a'i (ensel) lo ta meni Josep ma'e eimawe arosai. Le Josep ma'e suwou se apou au te'eye, “Josep, Ne sinere! Tani no, meni eime oso a'i aiwawe a'i pani tewi Isip ma'e hene iterotire. Fene pani tewi ape saro ahe irote. Nowe me'iye su, etiri fara'u a'i heneraiyei su, ane si tame itoraiyei fene ma'e au te'esairowa. Sosu fene pani tewi Judia ma'e fara'u si tame aiyerowa.” ");
INSERT INTO sny_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Sosu nowe pasi a'i se le meni eime mai lo aiwawe a'i pani tewi Isip ma'e hene iteroti. ");
INSERT INTO sny_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Tu naifa weriyei Owane Sitewi lo peri au te'e areiyeyei siye meni apou leseye, “Ane meni eime ano pani tewi Isip ma'e si ei aniyei.” Sosu Josep, Maria, meni eime oso lowesi lo, lowe pani tewi Isip sahe iroteye. Nowe me'iye su meni Owane Herot temeniyeye su, lowe pani tewi Judia si tame fai. Sosu lowe pani tewi Isip arunatiyewe, pani tewi Judia ma'e si tame fi su, Owane Sitewi lo peri ape, Owane Sitewi lo peri au te'e siye meni au te'eye ape, wiyeme a'i henerai. ");
INSERT INTO sny_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Sosu a'i pe awei lo marepi wisere a'i siye lu ape, Jisas ma'e au te'e wisereyeye ape, lowe meni owane Herot awera'iyenati. Sosu Herot lu ape le ne areareye ape, wanuwe su, le ai marepi erasi a'i toteye. Le apou toteye, “Marepi wisere a'i siye lu, lowe eiwariyemi erasi tu iyu menei hesi a'i siyeteye. Serai mitaru eimane oso a'i ape mo iyu menei hesi a'i irosiya.” Le ai atu siye lu tamo omo Betlehem ma'e lu wenei eimane oso werese aine tera'eyei ne eimawesawi. Le lowe ma'e eiye, “Fene omo Betlehem, omo tere'e tere'e atahe a'i sahe lu wenei mitaru eimane oso iyu menei hesi a'i irosiya ape, sosu mitaru eimane he'i a'i auteiye ape mo, aiwawe a'i aine tera'ere.” ");
INSERT INTO sny_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Tu naifa weriyei Owane Sitewi lo au te'e siye meni tere'e iyape Jeremaia apou leseye, ");
INSERT INTO sny_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Peri ahi ta omo Rama sahe wanuwe. Mai tomu ne'ese luwei erasi irowei. Resel lo lu tewi eimane lo ne urunoruwei erasi iroteye. Lu taune tamo le ne marepi fetane a'i au irowei ne toteyei su, ahowa. Le urunoruwei erasi a'i ironamiteyei. Piyene awere? Eimane werese lowe lo temeniyeye.” ");
INSERT INTO sny_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Nowe me'iye su, meni owane Herot temeniyeye. Sosu Owane Sitewi lo ipari wisere a'i Josep ma'e suwou se au te'eye. Le apou te'eye, ");
INSERT INTO sny_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Josep, ne sinere! Meni eime no tani no aiwawe a'i omo pani tewi Israel ma'e si tame henetire. Meni owane Herot meni eime ape aine tera'eyei ne toteye ape, temeniye tepa'asiye.” ");
INSERT INTO sny_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Sosu Josep, meni eime lo, mai mase omo pani Israel ma'e si tame heneti. ");
INSERT INTO sny_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Herot temeniyeye su, meni eime lo iyape Arkelaus, Herot lo yaru aniyewe, awei meni owane tutawe henerai. Le meni luwaru a'i ne. Sosu Josep peri heneruwe ape wanuwe su, le atoweiye marepi tote henerai. Serai Owane Sitewi Josep ma'e suwou se apou au te'eye. Fene pani tewi Judia awera'iyenatire. Pani tewi Galili ma'e henetire. ");
INSERT INTO sny_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Lowe pani tewi Galili ma'e henerai su, lowe omo Nasaret sahe iroteye. Tu naifa weriyei Owane Sitewi lo au te'e siye meni ta apou leseye, “Lowe le ne apou te'eyei, ‘Le omo Nasaret lo meni pefine a'i ne’.” Serai Owane Sitewi lo peri ape pefine wiyeme a'i henerai. Lu 2:39; Ais 11:1; 53:2; Jo 1:45 ");
INSERT INTO sny_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Sosu a'i pe meni ta iyape Jon sa'i au hu siye meni Juda lo pani tewi ariye a'i sahe Owane Sitewi lo peri au te'e fiyarirai. Le apou au te'eye. ");
INSERT INTO sny_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Fene werese yo seni luwaru a'i me'iyeni ma'e atati arunatite! Wanure! Nowe ape Owane Sitewi lu taune werese au noweinoweinamirowa ape ataheyewa.” Mt 4:17; 1:15 ");
INSERT INTO sny_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Owane Sitewi lo peri au te'e siye meni iyape, Aisaia, meni ape ne, apou leseye, “Meni ta pani tewi ariye a'i sahe peri erasi a'i uterowa, fene Meni Owane Pefine a'i lo yo wisere a'i au ta'anere. Yo lo ape au ta'ane fareraiyere.” ");
INSERT INTO sny_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Meni ape Jon, le ipari tahe fe kamel lo towe se ani asi ti tawesiye. Le fe kamel lo tahe lire ponei sahe ti tawesiye. Le ya'e luwaru werese, watetaiye lo mo'u fi ateye. 2 Kin 1:8 ");
INSERT INTO sny_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jon pani tewi ariye a'i sahe Owane Sitewi lo peri au te'eteye su, lu taune tomu ne'ese le ma'e Owane Sitewi lo peri wanuwei ne ta'uwerai. Lu taune omo Jerusalem ma'e omo omo pani tewi Judia sahe, sosu omo omo pani tewi Sa'i Mai Jordan feni eire ma'e Jon ma'e ta'uwerai. ");
INSERT INTO sny_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Lowe Jon lo peri wanuwe su, lowe yo seni luwaru ta'i ta'i a'i towafi lowe lo Owane Sitewi ma'e au te'e areiyeye. Sosu Jon Sa'i Jordan sahe lowe sa'i au huteye. ");
INSERT INTO sny_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Sosu lu Farisi tamo, lu tewi tere'e tamo iyape Sadyusi, lowe aiwawe Jon ma'e sa'i ani huwei ne ta'uwerai. Jon lowe siye aniye su, le lowe ma'e au te'eye, “Tahe fene lo aseyaro pamowe irosiya. Ahowa, marepi fene lo yo seni luwaru a'i papu ironamisiya. Fene haru aimesi aiwawe a'i ne. Eiwerai fene ma'e apou te'eye awere? ‘Weiyai! Owane Sitewi lo ai marepi fene ma'e henerairowa.’ Serene fene ane ma'e iterotai. Mt 12:34; 23:33 ");
INSERT INTO sny_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Fene marepi luwaru werese a'i arunatite. Sosu marepi wisere a'i lu taune ma'e au te'e atuatunamite. ");
INSERT INTO sny_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Fene marepi apou owe ape totere, ‘Ya'ariyei nomo lo meni owane Abraham. Serai Owane Sitewi lai nomo ma'e fofowei luwaru a'i itiya'u au irorowata.’ Ei! Meni owane Abraham ya'ariyei fene lo tene! Ahowa, marepi fene lo Abraham lo marepi wou ta'ama. Fene werese Owane Sitewi lo lu tewi ta'ama. Ahowa, Owane Sitewi lai lu tewi he'i a'i topo lo, lu taune yahowa'i apou au iro heneraiyei. Serai fene marepi ape owe ape totete, ‘Owane Sitewi lai nomo ma'e fofowei luwaru a'i itiya'u au irorowata.’ Jo 8:33,39; Ro 4:12 ");
INSERT INTO sny_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Owane Sitewi lo ai marepi ipari howe wou a'i me si sahe ironamisiya. Serai me ta lo'u wisere a'i ta'eye ta'ame su, le me ape orowawe, yehe ma'e fu arosawiyei. Aiwawe lu taune yo seni luwaru a'i irowei su, le lowe ma'e eimawe arosairowa. Mt 7:19; Lu 13:6-9 ");
INSERT INTO sny_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Wanure! Lu taune tamo yo seni luwaru a'i me'iyeni ma'e atati aruwei su, ane a'i lai sa'i se lowe ma'e au huwei. Ahowa, meni ta ane mo'o aiyerowa. Le meni owane pefine a'i. Le ane ne ani fu aronamisiya. Ane meni yahowa'i ne. Ane meni ape lo lowe tahe ani tahe furowata. Le aiyeyei su, le lu taune ma'e Owane Sitewi lo Hepene Wara'i a'i se au huwei. Owane Sitewi lai yo seni werese lowe lo aseyaro au iro heneraiyei. Apou ape aiwawe a'i le yo seni luwaru a'i yehe ma'e ani fu arosawiyei. Serai marepi hepene lowe lo wara'i a'i heneraiyei. Jo 1:26-27,33; Ap 1:5 ");
INSERT INTO sny_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Kewi so aseyaro a'i anireme. Le kewi oro'oru werese ani fusawirowawe, kewi so wisere a'i ani ta'uwe asiyei. Le kewi so wisere a'i wesi lo ma'e ani fuwei. Kewi oro'oru werese ape mo yehe ma'e ani fu arowei. Yehe ape weriyei weriyei tisero'onamitorowa.” ");
INSERT INTO sny_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Sosu a'i pe Jisas pani tewi Galili arunatiyewe, Sa'i Mai Jordan ma'e henerai. Le Jon ma'e sa'i ani huwei ne fai. ");
INSERT INTO sny_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ahowa, Jon peri ape lo wanuwe su, le Jisas ma'e eiye, “Ahowa! Ane ne sa'i au hurowata. Ne lai ereti no se ane sa'i au hure. Ne ane ma'e sa'i ani huwei ne fai awere? Ahowa!” ");
INSERT INTO sny_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Sosu Jisas itiya'u eiye, “Ei! Ane ereti no se sa'i ani huwei ne fai. Ne marepi ano fa umasire. Serai ne ane sa'i au hure. Ne ane sa'i au huwei su, ne yo seni aseyaro a'i umasiyei.” Sosu Jon Jisas lo peri wanuwe su, le Jisas sa'i au huwe. ");
INSERT INTO sny_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jon Jisas sa'i au hu tepa'asiye su, Jisas pereye a'i sa'i papu si sineye. Sineye su, Jon ni'arawe hire ma'e ponei peratiye ape, siyeye. Le Owane Sitewi lo Hepene Wara'i a'i irowe sapuwe aiwawe a'i Jisas ma'e itorai. Jo 1:32 ");
INSERT INTO sny_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Sosu peri no'u erasi uteye, “Meni ape meni eime ano ne. Ane le ne tote wawesiyesiya. Ane le ne marepi wisere a'i totenamisiya.” Sng 2:7; Ais 42:1; Mt 12:18; 17:5; Lu 9:35 ");
INSERT INTO sny_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Sosu a'i pe Jisas Sa'i Mai Jordan arunatiyewe, Owane Sitewi lo Hepene Wara'i a'i omo pani tewi ariye a'i ma'e heneti. Saro ahe sepei Satan luwaru a'i Jisas areareyei ne toteye. Hi 2:18; 4:15 ");
INSERT INTO sny_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Omo pani tewi ariye a'i sahe, le mi pasi lu hesi lo ereti lowe werese ironamiteye. Le ayei werese a ta'ame. Serene Jisas lau erasi a'i iroteye. Kis 34:28 ");
INSERT INTO sny_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Sosu sepei Satan luwaru a'i Jisas ma'e henerai apou eiye, “Ne Owane Sitewi lo meni eime ta'ame. Ne Owane Sitewi lo meni eime su, ne fara'u tapiye eite ma'e au te'ere, ‘Tapiye, nau ta'ase wou heneraire.’” ");
INSERT INTO sny_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Sosu Jisas le ma'e itiya'u eiye, “Owane Sitewi lo peri one towe sahe apou leseye, ‘Lu taune werese nau ta'ase a'i ene ateyei su, lowe marepi hepene se mi mi pasi pasi irorowata. Ahowa, lu taune hepene se mi mi pasi pasi ironamitereme su, lowe Owane Sitewi lo peri werese fa wanu umasite.’” ");
INSERT INTO sny_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Sosu sepei luwaru a'i Satan Jisas ma'e eiye, “Notosi omo Jerusalem ma'e wiyei.” Sosu le Jisas Owane Sitewi lo wesi me'iye ma'e hene teiteye. ");
INSERT INTO sny_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Le Jisas ma'e eiye, “Ne Owane Sitewi lo meni eime ta'ame! Ne Owane Sitewi lo meni eime su, ne fara'u wesi me'iye hi awei ma'e ye'i arore. Ne hi ma'e ye'i arowei su, Owane Sitewi lo peri one towe sahe apou leseye, ‘Owane Sitewi lai le ne ipari wisere tomu ne'ese lo au noweinoweiyei ne eimawe arosaiyei. Lowe le ne ereti lowe lo se au noweinowei kairefiyeyei. Serai le tapiye sahe lowe lo ninapune winetairowata.’ Serai ne hi ma'e ye'i arore. Ne fofowei erasi teriterowata.” ");
INSERT INTO sny_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Sosu Jisas le ma'e itiya'u eiye, “Wanure! Owane Sitewi lo peri tere'e one towe sahe apou leseye, ‘Ne Owane Sitewi Meni Owane Pefine a'i ma'e owe ape arearete.’” ");
INSERT INTO sny_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Sosu sepei luwaru a'i Satan Jisas ma'e eiye, “Notosi omo erasi hire ma'e yaneyei.” Le Jisas ma'e eiye, “Ne omo pani werese werese siyere! Omo pani werese ape mo ano ne. ");
INSERT INTO sny_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ne ane ma'e lowe uporo ape'i onurowawe, sosu ane ma'e au te'e wisereyeyei su, ane omo pani werese ano ne ma'e auwei. Omo pani werese wisere a'i ne!” ");
INSERT INTO sny_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Sosu Jisas le ma'e itiya'u eiye, “Satan, Ne ire! Ane marepi no umasirowata. Owane Sitewi lo peri one towe sahe apou leseye, ‘Ne Owane Sitewi Meni Owane Pefine a'i no ne au te'e wisereyete. Ne le ne a'i wiyawi au irote.’” ");
INSERT INTO sny_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Sosu sepei luwaru a'i Satan le arunatiyewe, fi. Owane Sitewi lo ipari wisere a'i le ma'e au pati ani kairefiyeyei ne itorai. ");
INSERT INTO sny_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Sosu a'i pe lu tamo apou eiye, “Jon sa'i au hu siye meni, lowe le kalabus wesi ma'e heneti.” Sosu Jisas peri ape wanuwe su, le pani tewi Galili ma'e si tame fi. Mt 14:3; Mk 6:17; Lu 3:19-20 ");
INSERT INTO sny_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Le omo Nasaret arunatiyewe, omo Kaperneam sahe iroteye. Omo Kaperneam, pani tewi Sebulun, sosu pani tewi Naptali atahe a'i iroteye. Omo ape hare ite tewiye sahe iroteye. ");
INSERT INTO sny_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Tu naifa weriyei Owane Sitewi lo peri au te'e siye meni, Aisaia, peri ta leseye, Peri ape wiyeme a'i henerai tepa'asiye. Le apou eiye, ");
INSERT INTO sny_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Lu taune pani tewi Sebulun sahe iroteye ape, lu taune pani tewi Naptali sahe iroteye ape, lu taune hare ite tewiye sahe iroteye ape, lu taune Sa'i Mai Jordan feni eire ma'e iroteye ape, lu tewi tere'e Moses lo yo peri umasi ta'ame ape, lowe omo pani tewi Galili sahe iroteye ape. ");
INSERT INTO sny_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Lu taune werese ape mo yo pasi a'i wou ironamiteye. Nowe me'iye su, lowe mi erasi wou siyeye. Lu taune ape mo yo pasi a'i ironamiteye su, lowe hepene lowe lo temeniyeye. Lowe mi erasi siyeye su, hepene lowe lo si tame sineteye.” ");
INSERT INTO sny_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Nowe ape se Jisas lai nowe tutawe peri lo lu taune ma'e au te'e fiyari areiyeteye. Le apou au te'eteye, “Fene werese yo seni luwaru a'i me'iyeni ma'e atati arunatite. Piyene awere? Nowe ape se Owane Sitewi lai, lu taune lo yo seni werese au hese ereirowa ape, ataheye heneraiwa.” Mt 3:2; 19:27 ");
INSERT INTO sny_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Sosu a'i pe Jisas hare ite Galili tewiye sahe iteye su, le lu nairi hesi a'i siyeye. Lowesi lo iyape Saimon iyape tere'e, Pita, sosu pa'ise lo Andru. Lowesi hare honaiye sa'i papu fu arosawiteye. Wiyawi lowesi lo hare ani siye lu ne. ");
INSERT INTO sny_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Sosu le lowesi ma'e eiye, “Fenesi ane mo'o umasire. Serai ane fenesi lu taune Owane Sitewi ma'e hene aniyei lo yo atuaturowa.” ");
INSERT INTO sny_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Sosu lowesi pereye a'i hare honaiye awei sahe fu arowewe, Jisas mo'o umasiti. ");
INSERT INTO sny_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Sosu le lu nairi hesi aiwawe iteye. Le lu nairi tere'e hesi a'i siyeye. Lowesi lo tai iyape Sebedi. Lowesi lo iyape Jems, sosu pa'ise Jon. Lowesi tai mase wai erasi papu hare honaiye lo yo iwisiteye. Jisas lowesi ei aniye. ");
INSERT INTO sny_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Sosu lowesi pereye a'i tai lowesi lo wai sahe arunatiyewe, Jisas mo'o umasiti. ");
INSERT INTO sny_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Sosu a'i pe Jisas omo pani tewi Galili sahe iteye. Le Owane Sitewi lo peri ta'uwe wesi sahe au te'e fiyariteye. Le Owane Sitewi lo peri heneruwe wisere a'i au te'e fiyariye. Le apou au te'eye, “Nowe ape se Owane Sitewi lu taune lo yo seni au hese ereirowa ape ataheye henerairowa.” Le lu taune lo u tahe apou ape mo au ta'ane fara'uweye. Mt 9:35; Mk 1:39; Ap 10:38 ");
INSERT INTO sny_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Lu taune Jisas lo wiyawi siyeye su, lowe peri heneruwe lo ne omo pani tewi Siria ma'e au te'e fiyariteye. Serai lowe Jisas ma'e lu taune tomu ne'ese u tahe se henetai. Lowe lu taune u tahe apou ape se, sepei luwaru a'i se, tahe auseriyeyei se, ereti lowe haroharo a'i se, serai Jisas lowe werese au ta'ane fara'uweye. Mk 6:55 ");
INSERT INTO sny_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Lu taune tomu ne'ese Jisas mo'o umasiteye. Lowe omo pani tewi Galili omo pani tewi Dekapolis, omo Jerusalem, omo pani tewi Judia, sosu pani tewi feni ma'e Sa'i Mai Jordan ma'e mo'o umasiteye. Mk 3:7-8 ");
INSERT INTO sny_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Sosu a'i pe Jisas lu taune tomu ne'ese le ma'e mo'o umasiteye ape, siyeyei su, le omo hire ma'e yaneye. Sosu le omo hire sahe onuwe su, lu disaipel lo le ma'e ei ta'uwerai. ");
INSERT INTO sny_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Sosu le lowe ma'e Owane Sitewi lo peri apou au te'e atuatuteye. ");
INSERT INTO sny_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Peri ano wanure! Fene marepi apou totesiya su, ‘Ane Owane Sitewi lo nihe se meni yahowa'i a'i ne.’ Owane Sitewi lai fene au noweinoweiteyei. Serene fene marepi papu tote nine'inamitorowa. ");
INSERT INTO sny_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Lu taune uruwei irosiya ape, Owane Sitewi lai fene marepi fetane a'i au te'eyei. Serene fene marepi papu tote nine'inamitorowa. Ais 61:2-3; KTH 7:17 ");
INSERT INTO sny_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Fene marepi fetane a'i lu taune ma'e au irosiya ape, Owane Sitewi lai fene ma'e etiri tomu ne'ese au noweinoweiyei ne auwei. Serene fene marepi papu tote nine'inamitorowa. ");
INSERT INTO sny_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Fene yo seni aseyaro wara'i a'i iro tohoteteye ape, Owane Sitewi lai marepi hepene fene lo au kairefiyerowa. Serene fene marepi papu tote nine'inamitorowa. ");
INSERT INTO sny_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Fene lu taune ma'e marepi au seremareyesiya ape, Owane Sitewi lai fene ma'e marepiau seremareyerowa. Serene fene marepi papu tote nine'inamitorowa. ");
INSERT INTO sny_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Fene marepi aseyaro wara'i a'i totenamisiya ape, fene Owane Sitewi lo yo seni siyerowa. Serene fene marepi wisere a'i totenamitorowa. ");
INSERT INTO sny_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Fene lu taune lo ai marepi einami siye lu ape, Owane Sitewi lai fene ne apou eiyei, ‘Fene eimane ano ne.’ Serene fene marepi papu tote nine'inamitorowa. ");
INSERT INTO sny_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Fene yo seni aseyaro a'i ironamisiya ape, lu tamo lai fene au luwaruweyei. Serai Owane Sitewi fene mi mi pasi pasi au noweinoweirowa. Serene fene marepi papu tote nine'inamitorowa. ");
INSERT INTO sny_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Fene yo seni wara'i a'i ano umasinamisiya ape, lu tamo fene ne ai marepi totenamiyei. Sosu lowe fene au luwaruweyei. Sosu lowe peri luwaru a'i fene ma'e au te'e areareyei. Serene fene marepi papu tote nine'inamitorowa. 1 Pi 4:14 ");
INSERT INTO sny_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Lu tamo fene ma'e au luwaruweyei su, fene marepi wisere a'i fu tote nine'inamite. Piyene awere? Tu naifa weriyei lu tamo lai Owane Sitewi lo au te'e siye lu werese aiwawe a'i au luwaruweteye. Serai omo hire sahe Owane Sitewi lai fene ma'e etiri wisere a'i aurowa. 2 Sto 36:16; Ap 7:52 ");
INSERT INTO sny_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Sosu fene lu taune mase ironamisiya. Fene awei lo ipari sei wou a'i ne. Ipari sei lo fi wisere a'i ne. Ahowa, ipari sei lo fi po'uteyei su, fene eiwerou irowei awere? Fene fara'u fi lo si tame fuwei awere? Ahowa, fene ipari sei ape awei sahe ani fusawire. Sosu lu taune ipari sei ape hire sahe atorowa. Serai fene lu taune ma'e au ferafereite. ");
INSERT INTO sny_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Fene mi erasi wou a'i ne. Fene lo mi awei pani werese tewi fiyarite. Fene wesi ta omo hire ma'e ta'aneyei su, fene wesi ape fareyarerowata. Lu taune werese wesi no ape amerame a'i siyerowa. Jo 8:12; 9:5 ");
INSERT INTO sny_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Lu taune tamo yehe erei taiso aniteyei su, lowe omoto unahi fu fareyarerowata. Ahowa, lowe yehe erei ape ereti se taiso anite mitaiye titorowa. Serai lu taune werese yehe erei mi fara'u siyerowa. Mk 4:21; Lu 8:16; 11:33 ");
INSERT INTO sny_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Fene mi erasi ape aiwawe a'i ne. Fene yo seni aseyaro a'i irowei su, lu taune yo seni fene lo siyeteyei. Sosu lowe lai tai fene lo omo hire ma'e irosiya ape, lowe iyape lo ei ani aroweyei.” Ef 5:8-9; 1 Pi 2:12 ");
INSERT INTO sny_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Fene ane ne apou owe ape totere, ‘Jisas lai Moses lo yo peri werese ani fu arowei.’ Ahowa, ane Moses lo yo peri werese au luwaruwe po'uteyei ne fai ta'ama. Aiwawe, ane Owane Sitewi lo au te'e siye lu lo peri au luwaruwe po'uteyei ne fai ta'ama. Ahowa, ane Moses lo yo peri werese umasinamiyei ne fai. Ro 3:31 ");
INSERT INTO sny_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Peri ano wiyeme a'i ne. Ane fene ma'e eisiya, Wanure! Owane Sitewi lo peri werese Moses leseye ape, mi mi pasi pasi weriyei ironamitorowa. Yo peri lo tewi oso oso a'i ape po'uterowata. Yo peri lo tewi werese werese pefine henerairowa. Awei pani werese, ni'arawe etiri werese hire ma'e irosiya ape, po'uterowa. Ahowa, Owane Sitewi lo yo peri werese po'uterowata. Lu 16:17; 21:33 ");
INSERT INTO sny_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Meni ta Owane Sitewi lo peri, Moses leseye ape, tewi a'i ne apou toteyei su, ‘Owane Sitewi lo peri tewi oso a'i ape peri yahowa'i ne. Ane fara'u peri ape arisiyei.’ Sosu le lu taune ma'e peri tewi a'i ape arisiyei ne au te'e atuatuwei su, le weiyai! Owane Sitewi lai omo lo hire sahe le iyape lo hi ani ararowei. Ahowa, weiyai! Meni ta Owane Sitewi lo peri werese umasiyei su, sosu lu taune ma'e peri pefine a'i au te'e atuatuwei su, Owane Sitewi lai omo lo sahe iyape lo ei ani aroweyei. Je 2:10 ");
INSERT INTO sny_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Marepi sitewi ano apou a'i totesiya, ane fene ma'e eisiya. Lu tewi iyape Farisi, sosu Owane Sitewi lo peri ani so'oruwe siye lu, lowe ahi a'i se yo seni aseyaro a'i ironamiyei. Marepi lowe lo ne, lowe Owane Sitewi lo peri arisinamisiya. Meni ta yo seni eito eite irowei su, le Owane Sitewi lo omo papu wirowata.” ");
INSERT INTO sny_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Peri ape ya'ariyei fene lo ma'e, te'eteye ape, wanu tepa'asiye. Lowe apou te'eye, ‘Fene meni ta owe ape aine tera'ere.’ Meni ta meni tere'e aine tera'eyei su, awei lo meni owane lai meni ape etirowa. ");
INSERT INTO sny_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ahowa, ane fene ma'e apou au te'esiya. Lu taune ta meni tere'e ma'e ai marepi toteyei su, awei lo meni owane lai le etiyei. Aiwawe a'i meni ta meni tere'e ma'e apou eiyei su, ‘Ne ipo meni luwaru poto a'i ne.’ Awei lo meni owane tutawe lai le etiyei. Sosu aiwawe a'i, meni ta meni tere'e ma'e apou eiyei su, ‘Ne meni meremereye a'i ne.’ Meni ape weiyai! Le ma'e atahe a'i irowa. 1 Jo 3:15 ");
INSERT INTO sny_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Nowe ta se fene Owane Sitewi ma'e etiri neri a'i ta aitaiyei ne toteyei su, fene tu marepi fene lo au hese eti ereire! Fene meni tere'e ne ai marepi toteye su, fene etiri neri a'i fene lo arunatirowawe, meni ape ma'e ai marepi ape si tame au fareraiyeyei ne ire. Fene ai marepi fene lo ape au fareraiyeyei su, fene fara'u etiri neri a'i ape Owane Sitewi ma'e aure! Mk 11:25 ");
INSERT INTO sny_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Meni ta fene ma'e apou eiyei su, ‘Ne ane ma'e au luwaruweye. Serai ne ane ma'e ma'aru tamo itiya'u fu aure.’ Ne le mase yo sahe iteye su, ne yo seni luwaru a'i ape witane a'i se au fareraiyere. Ne yo seni luwaru a'i ape au fareraiyeyei ta'ama su, le fene meni owane ta ma'e au hese ereiyei ne henetiyei. Le au hese erei tepa'asiyei su, le fene ai lu tamo ma'e henetirowawe, fene kalabus wesi ma'e eimawesawiyei. ");
INSERT INTO sny_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Peri ano wiyeme a'i ne. Ane fene ma'e au te'e areiyesiya. Ne kalabus wesi sato mi mi weriyei ironamitorowa. Fene ma'aru werese werese si itiya'u ete fetaneyere. Fene orese a'i ape ete fetaneyeyei su, fene kalabus wesi ma'e henerairowa.” ");
INSERT INTO sny_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Sosu a'i pe Owane Sitewi lo yo peri Moses leseye ape, apou te'eye, ‘Fene tafa'e yo seni owe ape irote.’ Fene peri ape mi mi weriyei wanu tepa'asiye. ");
INSERT INTO sny_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ahowa, ane fene ma'e au te'e areiyesiya. Fene menitani ta nihe se siye wisereyeyei su, serai fene menitani ape ma'e tafa'e yo sene luwaru a'i irowei ne toteyei su, fene Moses lo yo peri marepi fene lo sahe arisiye. ");
INSERT INTO sny_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Aiwawe a'i fene nihe se menitani ta tafa'e yo seni luwaru a'i siye wisereyeyei su, fene nihe fene lo ani tahe ani fusawire. Fene Owane Sitewi lo omo hire ma'e wiyei su, fene nihe ta'i se a'i wirowa. Etiri ape wisere a'i ne. Nihe fene lo yo seni luwaru a'i au irowei ape, ironamiteyei su, fene ma'e irowa. Etiri ape luwaru a'i ne. Mt 18:9; Mk 9:47 ");
INSERT INTO sny_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Aiwawe a'i fene ereti fene lo se seni luwaru a'i irowei su, fene ereti ape aine to fusawire. Fene Owane Sitewi lo omo hire ma'e wiyei su, fene ereti ta'i se a'i wirowa. Etiri ape wisere a'i ne. Ereti fene lo yo seni luwaru au irowei ape ironamiteye su, fene yehe omo ma'e irowa. Etiri ape luwaru a'i ne. Mt 18:8; Mk 9:43 ");
INSERT INTO sny_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Tu naifa weriyei Moses apou leseye, ‘Meni ta tani lo si omo lo ma'e si eimawesawiyei ne toteyei su, meni ape tani lo ma'e one towe ta fa aure.’ One towe ape apou te'eyei, ‘Ane, menitani ape lo meni, ane lai tani ano si omo lo ma'e eimawesawi.’ Mk 10:4 ");
INSERT INTO sny_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ahowa, ane fene ma'e te'e areiyesiya. Meni ta tani lo yahowa'i a'i si omo lo ma'e eimawesawiyei su, meni ape yo seni luwaru a'i irowei. Menitani ape meni tere'e naitu ene ayei su, menitani ape tafa'e yo seni luwaru a'i irowei. Meni tere'e ta menitani ape naituwei su, meni ape aiwawe a'i tafa'e yo seni luwaru a'i irowei. Tani fene lo lai meni tere'e tafa'e yo sene luwaru a'i irowei su, fene tani fene lo fara'u si omo lo ma'e eimawesawire.” 1 Ko 7:10-11 ");
INSERT INTO sny_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Sosu a'i pe ane peri tere'e fene ma'e au te'e areiyesiya. Ya'ariyei fene lo apou au te'eye, ‘Fene peri yahowa'i a'i owe ape te'e nanei arearete! Fene peri wiyeme te'e naneiyei su, fene peri wiyeme a'i ape Meni Owane Pefine a'i lo nihe se fa umasire!’ ");
INSERT INTO sny_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ahowa, ane fene ma'e au te'e areiyesiya. Fene peri wiyeme a'i owe ape te'e naneite. Fene peri wiyeme a'i apou au te'e naneiyei su, ‘Ni'arawe hire ape peri wiyeme a'i ano ne au kairefiyeyei.’ Fene peri eito eite owe ape te'e naneite. Piyene awere? Ni'arawe hire werese ape sahe Owane Sitewi lai onunamisiya. Ais 66:1; Je 5:12; Mt 23:22 ");
INSERT INTO sny_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Aiwawe a'i fene peri ta owe ape te'e naneite. ‘Ane peri wiyeme a'i ta awei lo kairefi se au te'e naneisiya.’ Ahowa, fene peri apou owe ape te'e naneite. Piyene awere? Awei werese sahe Owane Sitewi Pefine a'i lai lowe lo hesi fa aro ato fetaneyenamisiya. Aiwawe a'i fene peri ta owe ape te'e naneite, ‘Ane peri wiyeme a'i ta omo Jerusalem lo kairefiyeyei se au te'e naneisiya.’ Ahowa, fene peri apou owe ape te'e naneite. Piyene awere? Omo Jerusalem sahe meni owane tutawe Owane Sitewi lai onunamisiya. Sng 48:2; Ais 66:1 ");
INSERT INTO sny_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Aiwawe a'i fene mato fene lo se peri wiyeme a'i ta owe ape te'e naneite! Piyene awere? Fene fara'u mato towe fene lo wapo a'i heneraiyei ne irowei awere? Fene mato towe wapo a'i irowei su, fene fara'u mato towe fene lo iwise a'i heneraiyei ne irowei awere? Ahowa! Fene wiyawi eito eite au irorowata. Serai fene mato fene lo se peri wiyeme a'i ta owe ape te'e naneite. ");
INSERT INTO sny_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ahowa, fene peri ta apou toteyei su, ‘Nomo wiyawi ape irowei.’ Sosu fene apou fu eire, ‘Ei! Nomo wiyawi ape au irorowa!’ Aiwawe a'i fene peri ta apou toteyei su, ‘Nomo wiyawi ape irowei ta'ama.’ Sosu fene apou fu eire, ‘Nomo wiyawi ape irorowata.’ Fene peri wiyeme a'i ta au te'e naneiyei su, sosu mo'o fene peri wiyeme a'i ape arisiyei. Yo seni fene lo sepei luwaru a'i Satan lo marepi ma'e fai.” ");
INSERT INTO sny_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Tu naifa weriyei Moses peri ta apou leseye, ‘Fene meni ta lo nihe ani tahe aniyei su, meni tere'e ta nihe fene lo pei ani tahe aniyei! Aiwawe a'i fene meni ta lo pi aine towesiyei su, meni owane lai pi fene lo fa aine towesiyei.’ Fene peri ape mi mi weriyei wanunamiteye. ");
INSERT INTO sny_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ahowa, ane fene ma'e peri he'i a'i au te'e areiyesiya. Meni ta ahi si ma'e ereti se aineyei su, fene le itiya'u owe ape ainere. Ahowa, meni ta ahi si fene lo aineyei su, fene nihari feni fene lo atati tei awetore! Serai le fara'u ahi si feni ma'e ereti se aineyei. ");
INSERT INTO sny_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Sosu meni ta fene etiyei su, sosu peri etiyei siye meni owane fene ma'e apou eiyei, ‘Ne meni ape ma'e ipari tahe fene lo itiya'u fa aure. Ei fene ipari tahe siot itiya'u fu aure. Aiwawe a'i fene ipari tahe trauses le ma'e aure.’ ");
INSERT INTO sny_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Sosu meni owane ta fene ma'e peri kairefi a'i apou eiyei su, ‘Ne etiri ano yo mai tewi oso eyeri ma'e sutaitetire.’ Ei, fene pani eyeri tewi oso etiri lo fa sutaitetire. Ahowa, fene pani eyeri tewi erasi fara'u sutaitetire. ");
INSERT INTO sny_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Sosu meni ta fene ma'e etiri ta ne ei toweriyei su, fene etiri ape le ma'e fu aure! Meni ta fene ma'e etiri neri a'i fa au ne ei toweriyei su, fene le ma'e etiri neri a'i fa aure!” ");
INSERT INTO sny_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Tu naifa weriyei Owane Sitewi lo one towe sahe apou leseye, ‘Fene kaiyemo fene lo ne marepi erasi a'i tote wawesiyenamite. Sosu aiwawe a'i lu tamo fene ma'e au luwaruweyei ape, fene ai marepi erasi a'i lowe ne totenamite.’ ");
INSERT INTO sny_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ahowa, ane peri he'i a'i fene ma'e au te'e areiyesiya. Fene airame fene lo marepi erasi a'i tote wawesiyenamisiya. Aiwawe lu tamo fene ma'e au luwaruweyei su, fene lowe ne Owane Sitewi ma'e au te'e towerite. Kis 23:4-5; Lu 23:34; Ap 7:60; Ro 12:14,20 ");
INSERT INTO sny_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Piyene awere? Fene lowe ne Owane Sitewi ma'e au te'e toweriyei su, lowe fene ne apou toteyei, ‘Lu ape mo lowe Owane Sitewi ma'e fai.’ Owane Sitewi ape lai hire ma'e ironamisiya ape, le poweiye ne, sa'i ne apou te'esiya awere? ‘Ane lu taune aseyaro a'i ma'e poweiye, sa'i au ei ito arosairowa.’ Ahowa, Owane Sitewi lai poweiye sa'i lu taune werese werese a'i ma'e au ei ito arosairowa. Serai fene Owane Sitewi lo marepi aiwawe a'i fu totete. ");
INSERT INTO sny_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Lu taune fene ne marepi erasi a'i tote wawesiyenamisiya ape, fene marepi lowe ne erasi a'i itiya'u tote wawesiyenamiyei su, yo seni eito eite fene irowei ape, fene ne eiwerou irowei awere? Takis ma'aru ani siye lu, lowe lu tewi towafi lowe lo, lowe ne aiwawe a'i marepi erasi a'i tote wawesiyenamisiya. Lowe takis ma'aru fene lo yahowa'i ta'arei aniteye. Lowe lu luwaru a'i tene! Serai fene yo seni eito eite irowei su, Owane Sitewi fene ma'e etiri wisere a'i aurowa awere? Ahowa. ");
INSERT INTO sny_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Sosu fene lu tewi fene lo a'i ma'e none isafiyeyei su, fene wiyawi erasi a'i iro ta'ame. Ahowa, lu taune werese Owane Sitewi lo peri umasi ta'ame ape, yo seni eito eite aiwawe a'i lu tewi lowe lo ma'e none isafiyenamisiya. ");
INSERT INTO sny_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Serai fene marepi eito eite owe ape totete! Ahowa, tai fene lo hire ma'e ironamisiya ape, marepi lo aseyaro a'i totenamisiya. Serai fene marepi wara'i lo fu umasinamite.” Wkp 19:2; Lo 18:13 ");
INSERT INTO sny_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Fene weiyai! Ane fene ma'e au te'e areiyesiya. Fene lu taune tamo, ma'e au ferafereiyei su, fene marepi apou owe ape totete, ‘Ane lu tamo au ferafereiyei su, lu taune tere'e werese ane ma'e au te'e wisereyeyei.’ Fene apou toteyei su, Tai fene lo ni'arawe hire ma'e irosiya ape, le fene ma'e etiri wisere a'i ta aurowata. Mt 23:5 ");
INSERT INTO sny_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Fene lu taune tamo etiri ma'aru ariye a'i ape ma'e etiri ma'aru auwei ne toteyei su, fene meni ta tu wau aineyei ne owe ape eimawesawire. Ahowa, lu taune tomu ne'ese yo seni apou ape tote umasinamisiya. Lowe Owane Sitewi lo wesi sahe yo seni apou ape umasisiya. Aiwawe a'i lowe yo mai sahe peri ne'ese au te'e utesiya. ‘Fene ane siyere! Ane etiri ma'aru tomu ne'ese lu ma'aru ariye a'i ape ma'e aunamisiya.’ Lowe lu taune werese lowe ne au siye wisereyereme. Wiyeme a'i! Ane peri pefine a'i fene ma'e au te'e areiyesiya. Wanure! Lu taune ape yo seni apou ape tote umasisiya ape, lowe lu taune werese ma'e areareyei ne totesiya. Lu taune lowe ma'e au te'e wisereyeye. Ahowa, Owane Sitewi lai lowe au te'e wisereyerowata. ");
INSERT INTO sny_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","Fene etiri ma'aru fene lo lu taune ma'aru ariye a'i ape ma'e auwei ne toteyei su, fene lowe ma'e etiri ma'aru eresene a'i aure. Lu taune tere'e fene owe ape siyere. Ahowa, fene etiri ma'aru fene lo eresene a'i aunamite. Serai Owane Sitewi lai fene siye tepa'asiye. Sosu le lu taune werese ma'e fene ne au te'e wisereyeyei. Le a'i lai fene ma'e etiri wisere a'i itiya'u aurowa.” ");
INSERT INTO sny_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Aiwawe a'i fene Owane Sitewi ma'e au te'eyei ne toteyei su, fene lu marepi hesi a'i totesiya ape, yo seni owe ape umasite. Lowe Owane Sitewi lo wesi ponei sahe teinamisiya. Lowe peri erasi a'i Owane Sitewi ma'e au te'esiya. Lowe Owane Sitewi ma'e au te'eyei su, lu taune werese peri lowe lo wanuwei. Lowe nowe amerame sahe teisiya. Peri erasi se Owane Sitewi ma'e au te'eyei. Lu taune werese peri lowe lo wanuwei su, lu tewi ape apou toteyei, ‘Ane Owane Sitewi ma'e au te'eyei su, lu taune werese ane ne au te'e wisereyeyei.’ Wiyeme a'i ane peri pefine fene ma'e au te'e areiyesiya. Wanure! Lu tewi ape lowe Owane Sitewi lo etiri neri a'i anirowata. Owane Sitewi lai peri lowe lo wanurowata. Mt 23:5; Lu 18:10-14 ");
INSERT INTO sny_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ahowa, fene Owane Sitewi ma'e, tai fene lo, au te'eyei ne toteyei su, fene tewi wesi papu wire. Yo anitiyei su, fene Owane Sitewi, Tai fene lo, ma'e lu le ne siye ta'ame ape, au te'ete. Serai Owane Sitewi lai fene eresene a'i tewi wesi papu siyeyei. Fene peri au te'eyei su, Owane Sitewi lai Tai fene lo etiri ta fene ma'e aurowa. ");
INSERT INTO sny_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Sosu fene Owane Sitewi ma'e au te'eyei su, fene peri yahowa'i owe ape au te'e te'enamite. Lu taune, Moses lo yo peri umasi ta'ame ape, yo seni ape umasinamisiya. Lowe apou totesiya, ‘Nomo Owane Sitewi ma'e peri tomu ne'ese au te'e te'eyei su, Owane Sitewi lai peri nomo lo ape wanuwei.’ Ahowa, Owane Sitewi lai peri lowe lo wanurowata. 1 Kin 18:26-29 ");
INSERT INTO sny_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Serai fene yo seni lowe lo owe ape umasire. Tai fene lo le marepi fene lo siye so'oruwe tepa'asiye. Tu fene marepi fene lo Owane Sitewi ma'e au te'e ta'ame su, Owane Sitewi lai etiri fene lo po'utesiya ape, siye so'oruwe tepa'asiye. Mt 6:32 ");
INSERT INTO sny_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Serai fene Owane Sitewi ma'e au te'eyei su, fene apou eire, ‘Tai nomo lo, ne hire ma'e onunamisiya. Nomo ne ma'e au te'esiya, Iyape no mi mi weriyei wara'i a'i fa ironamite.’ ");
INSERT INTO sny_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nowe ye'ewi su, ne lu taune werese au noweinoweirowa ape, nowe ape se witane a'i fa henera. Marepi werese no hi awei sato fa henera. Aiwawe a'i omo hire ma'e marepi werese no wou umasi tepa'asiye. Lu 22:42 ");
INSERT INTO sny_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ne pereye nowe eite se nomo ma'e ayei etiri nomo lo fa aute. ");
INSERT INTO sny_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Lu taune tere'e nomo ma'e yo seni luwaru a'i irowei su, nomo yo seni luwaru a'i lowe lo i'ane tepa'asiye. Serai Nomo yo seni luwaru a'i irowei su, ne yo seni luwaru a'i nomo lo ani pamowete. Mt 6:14-15; 18:21-35 ");
INSERT INTO sny_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ne nomo yo seni luwaru a'i owe ape henetire. Nomo yo seni luwaru a'i umasiyei ne toteyei su, ne fara'u nomo ma'e yo seni wara'i a'i au atuatute. Sosu ne nomo yo seni luwaru a'i hene aro anire. {Ne lu taune werese au noweinoweirowa su, ne lai mi mi pasi pasi fa ironamite. Kairefi no weriyei weriyei fa ironamite. Sosu nomo iyape no mi mi pasi pasi se te'e ani arowete. Peri wiyeme a'i ne.} Lu 22:40; Jo 17:15 ");
INSERT INTO sny_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Wanure! Lu taune yo seni luwaru a'i fene ma'e au irowei su, fene yo seni luwaru a'i lowe lo fa i'anete. Fene yo seni luwaru a'i lowe lo i'aneyei su, Tai fene lo, omo hire ma'e ironamisiya ape, aiwawe a'i yo seni luwaru a'i fene lo i'anerowa. Mk 11:25-26 ");
INSERT INTO sny_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Aiwawe a'i fene yo seni luwaru a'i lowe lo i'ane ta'ame su, Tai fene lo yo seni luwaru a'i fene lo ani pamowerowata.” ");
INSERT INTO sny_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Sosu a'i pe fene, Owane Sitewi ma'e te'e towerirowawe, sosu ayei ta fene lo siyenamiyei su, fene ereme se owe ape irote. Ahowa, lu tamo, marepi hesi a'i totesiya ape, lowe yo seni ape umasisiya. Lowe nihari lowe lo ereme se au atuatuwei su, lowe apou totesiya. ‘Lu taune yo seni wisere a'i ano siyeyei. Serai lowe ane ne siye te'e wisereyeyei.’ Ahowa, Owane Sitewi lai lowe yo seni lowe lo siye wisereyerowata. Owane Sitewi lai etiri ta lowe ma'e neri a'i aurowata. Ais 58:5-9 ");
INSERT INTO sny_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ahowa, fene ayei ta siyenamiyei su, fene mato towe fene lo asi noweinoweire. Nihari fene lo sa'i se au hure. Serene lu taune werese ereme se fene lo siyerowata. ");
INSERT INTO sny_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Fene mato towe fene lo asi noweinoweiyei su, lu taune werese fene ayei siyenamiyei ape siyerowata. Ahowa, Tai fene lo lai lu le ne siye ta'ame ape, marepi fene lo eresene a'i siye tepa'asiye. Owane Sitewi lai marepi wisere a'i fene lo siyeyei su, le etiri ta fene ma'e neri a'i itiya'u aurowa.” ");
INSERT INTO sny_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Fene awei lo etiri ne marepi erasi a'i totenamiyei su, fene awei lo marepi tote umasinamiyei. Aiwawe a'i fene etiri werese, Owane Sitewi ma'e fai ape, marepi erasi a'i totenamirowa su, fene Owane Sitewi lo marepi tote umasinamirowa. Je 5:1-3 ");
INSERT INTO sny_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ahowa, fene etiri aseyaro wisere a'i Owane Sitewi lo omo hire yaro ta'uwe ani fure. Fene Owane Sitewi lo omo hire yaro etiri werese fene lo ta'uwe ani fuwei su, ya'e werese a po'uterowata. Aiwawe a'i etiri werese uwaserowata. Sosu ta'arei lu werese aine apeti wirowata. Etiri werese ta'arei anirowata. Mt 19:21; Lu 18:22 ");
INSERT INTO sny_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Fene awei sahe etiri tomu ne'ese ta'uwe ani fuwei su, marepi fene lo aiwawe a'i awei lo etiri ape a'i toteyei. Fene etiri fene lo Owane Sitewi lo omo hire ma'e ta'uwe ani fuwei su, marepi fene lo Owane Sitewi ne totenamirowa.” ");
INSERT INTO sny_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Nihe fene lo yehe erei wou a'i ne. Nihe fene lo amerame a'i siyeyei su, tahe pa'are werese fene lo mitaiyeyei a'i ironamirowa. ");
INSERT INTO sny_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ahowa, nihe fene lo pokoweyei su, tahe pa'are werese fene lo pasi a'i irorowa. Tahe pa'are fene lo pasi a'i iroteyei su, pasi ape pefine a'i tene. Fene etiri werese siyerowata.” ");
INSERT INTO sny_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Meni ta wiyawi lu owane hesi lo wiyawi anirowata. Meni ape meni owane ta'i a'i ne marepi erasi a'i tote wawesiyenamirowa. Sosu meni owane tere'e ne ai marepi erasi a'i totenamirowa. Le meni owane ta'i lo marepi werese wanu umasirowa. Sosu meni owane tere'e, le peri werese lo wanu arisirowa. Fene werese etiri totenamirowa su, fene Owane Sitewi ne marepi erasi a'i toterowata. Serai fene awei lo ma'aru ne erasi a'i toteyei su, fene Owane Sitewi ne toterowata. ");
INSERT INTO sny_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Serene ane marepi sitewi fene ma'e au te'e areiyesiya. Fene etiri werese fene lo marepi erasi owe ape totatote ewitete. Fene ayei fene lo, sa'i ayei fene lo, ipari tahe fene lo ape ne owe ape totenamite. Ayei tamo, sa'i ayei tamo, ipari tahe werese tamo, etiri ape mo lowe witane a'i uwaserowa. Marepi hepene fene lo mi mi pasi pasi ironamitorowa. Serai fene marepi erasi a'i marepi hepene fene lo ne fa totenamite. Fl 4:6; 1 Ti 6:6-8; 1 Pi 5:7 ");
INSERT INTO sny_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Fene irowe werese ne totere. Lowe werese sahe me so ta'aneyei awei yehe same ta'ame. Lowe me so tamo ani tou anirowawe, wesi ta sahe ani ta'uwe furowata. Ahowa, Owane Sitewi Tai fene lo hire ma'e irosiya ape, le irowe werese mi mi werese au ene anamisiya. Owane Sitewi lai lowe werese au noweinoweinamisiya su, le lu feni lo aiwawe a'i au noweinoweinamisiya. Owane Sitewi lo nihe se fene werese irowe werese hi ani ararosiya. Mt 10:29-31; Lu 12:6-7 ");
INSERT INTO sny_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Fene marepi tote ewiteyei su, fene fara'u nowe mi tere'e ta tei irorowa awere? Ahowa, fene marepi orese a'i owe ape totere. ");
INSERT INTO sny_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Fene piyene marepi orese a'i ipari tahe ne tote ewitesiya awere? Fene mesu ape siyere. Lowe wafei irirowata. Lowe wiyawi ta ta'anerowata. Sosu siyere! Owane Sitewi lai mesu werese au lese tepa'asiye. ");
INSERT INTO sny_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Peri ape wiyeme a'i ne. Wanure! Meni ta, iyape Solomon le ipari tahe wisere a'i ani asiteye. Ahowa, mesu werese Owane Sitewi lai lowe au lese tepa'asiye. Mesu lo leseyei lu lo leseyei ape wou ta'ama. Mesu lo leseyei tutawe a'i ne. 1 Kin 10:4-7; 2 Sto 9:3-6 ");
INSERT INTO sny_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Sosu Owane Sitewi lai senarepe su ma'e au leseye su, fene apou owe ape totere. ‘Le ane ipari tahe au ani asirowata.’ Ahowa, Owane Sitewi lai fene werese marepi erasi a'i tote wawesiyenamisiya. Le lai fene ma'e ipari tahe wisere a'i au ani asinamirowa. Mesu werese, senarepe su werese pereye nowe eite se lowe norohu a'i irosiya. Nowe me'iye su, nomo lowe yehe ma'e ani fu arosawiyei. Fene werese Owane Sitewi ne tote tawesiyei fene lo oso a'i ne. ");
INSERT INTO sny_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Serai fene marepi orese a'i owe ape totete, ‘Nomo ayei eiwerou ma'e aniyei awere? Nomo piye sa'i ayei awere? Nomo piye ipari tahe ani asiyei awere?’ ");
INSERT INTO sny_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Etiri werese ape mo lu taune Owane Sitewi lo peri umasi ta'ame ape, lowe etiri ape mo siyeyei ne nehi tohotesiya. Tai fene lo hire ma'e irosiya ape, etiri ape mo fene po'utesiya ape, le so'oruwe a'i ne. Fene etiri ape anirowa. Serai fene marepi orese a'i owe ape totete. Mt 6:8 ");
INSERT INTO sny_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ahowa, fene tu Owane Sitewi lo marepi tote umasinamite. Sosu Owane Sitewi lo yo seni wara'i a'i fu umasinamite. Sosu fene etiri ape mo umasinamirowa su, le a'i lai etiri werese ape mo fene ma'e aurowa. 1 Kin 3:13-14; Sng 37:4,25; Ro 14:17 ");
INSERT INTO sny_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Serai fene nowe me'iye su marepi orese a'i owe ape totete. Ahowa, nowe me'iye ape, fa henera. Etiri orese tamo nowe pereye a'i heneraiyei ape, etiri orese ape lai nowe pereye a'i lo ne.” ");
INSERT INTO sny_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Fene lu tere'e lo yo seni owe ape hese ereite. Serai Owane Sitewi lai yo seni fene lo hese ereirowata. Ro 2:1; 1 Ko 4:5; Je 4:11-12 ");
INSERT INTO sny_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Aiwawe a'i fene lu tere'e lo yo seni marepi luwaru a'i se au hese siye eti ereiye su, Owane Sitewi lai yo seni luwaru a'i fene lo ape marepi luwaru a'i aiwawe a'i se itiya'u hese siye eti ereirowa. Fene lu tere'e lo yo seni luwaru a'i nawiteyei su, Owane Sitewi aiwawe a'i yo seni fene lo itiya'u nawiterowa. Mk 4:24 ");
INSERT INTO sny_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Fene me meni erasi ta nihe fene lo sahe irosiya ape, piyene fene meni tere'e ta oro'oru tewi oso a'i nihe lo sahe irosiya ape, ani tahe fusawiyei ne totesiya awere? ");
INSERT INTO sny_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ahowa, fene me meni erasi nihe fene lo sahe irosiya ape, fene meni tere'e ma'e apou owe ape eire. ‘Kaiyemo, ane fara'u oro'oru tewi oso a'i, nihe no sahe irosiya ape, ani tahe fusawiyei.’ Fene me meni erasi nihe fene lo sahe irosiya ape, fene oro'oru tewi a'i meni tere'e lo nihe sahe siyerowata. ");
INSERT INTO sny_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Fene marepi hesi a'i siye lu. Fene me meni erasi nihe fene lo sahe irosiya ape, tu ani tahe fusawire. Sosu fene me meni erasi, nihe fene lo sahe irosiya ape, ani tahe fusawi tepa'asiyei su, fene fara'u kaiyemo lo oro'oru tewi oso a'i nihe sahe irosiya ape, siye ani tahe fusawirowawe, siye etirowa. ");
INSERT INTO sny_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Fene Owane Sitewi lo yo seni wara'i a'i werese lu taune luwaru a'i ma'e owe ape au te'ere. Lowe you erawe wou a'i ne. Lowe Owane Sitewi lo yo seni wara'i a'i wanuwei su, lowe fene ma'e atati teirowawe, sosu fene ma'e au luwaruwerowa. Aiwawe a'i fene nokoro wisere a'i lu taune luwaru a'i tamo awei sahe owe ape ani fu arore. Lowe fe erawe wou a'i ne. Nokoro fene lo awei sahe wiyeineyei su, lowe hire ato tawesitiyei. Sosu lowe fene ma'e atati teirowawe, fene ma'e itiya'u au luwaruweyei.” ");
INSERT INTO sny_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Fene etiri ta aniyei ne toteyei su, fene Owane Sitewi ma'e te'e towerirowawe, le fene ma'e etiri ape aurowa. Fene Owane Sitewi lo marepi siye so'oruweyei ne toteyei su, le a'i lai fene ma'e marepi lo ne au atuatu areiyerowa. Fene yo sahe ereti se aine ta'aruwei su, yo ape fene ma'e au tosorowa. Mk 11:24; Jo 14:13; 15:7; Jo 16:23-24 ");
INSERT INTO sny_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Lu taune werese etiri ta Owane Sitewi ma'e te'e toweriyei su, Owane Sitewi lai lowe ma'e etiri ape aurowa. Lu taune werese etiri ta ani nehitiyei su, Owane Sitewi lai lowe ma'e au atuaturowa. Lu taune werese yo sahe ereti se aine ta'aruwei su, Owane Sitewi lai lowe ma'e yo ape au tosorowa. 1 Jo 3:22; 5:14-15 ");
INSERT INTO sny_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Meni eime ta tai lo ma'e nau ta'ase ne ei toweriyei su, le meni eime lo ma'e tapiye auwei awere? Ahowa! ");
INSERT INTO sny_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Sosu le tai lo hare ta ei toweriyei su, tai lo le ma'e haru aimesi ta auwei awere? Ahowa. ");
INSERT INTO sny_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Serai fene yo seni luwaru a'i ironamisiya ape, fene werese etiri wisere a'i eimane fene lo ma'e auwei. Owane Sitewi, Tai fene lo hire ma'e irosiya ape, fene le ma'e te'e toweriyei su, le etiri wisere a'i fene ma'e aurowa awere? Ei, wiyeme a'i. Le etiri wisere a'i fene ma'e aurowa. Je 1:17 ");
INSERT INTO sny_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Serai fene apou totesiya su, ‘Lu taune tere'e tamo lowe nomo ma'e yo seni wisere a'i au ironamite.’ Sosu fene lowe ma'e yo seni apou ape aiwawe a'i au ironamite. Peri eite lo sitewi Moses leseye. Sosu Owane Sitewi lo peri au te'e se lu lai leseye.” Mt 22:39-40; Lu 6:31; Ro 13:8-10 ");
INSERT INTO sny_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Sosu Jisas apou a'i te'eteye, “Yo hesi irosiya. Fene yo oso a'i papu wire. Fene yo erasi a'i papu wiyei su, fene yo luwaru a'i umasiyei. Lu taune tomu ne'ese yo erasi ape umasinamisiya. Sosu lowe ma'e irowa. ");
INSERT INTO sny_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Fene yo oso a'i papu wiyei su, fene marepi hepene he'i a'i anirowa. Yo ape oso a'i ne. Lu taune ta'i ta'i a'i lai yo oso ape umasirowa.” ");
INSERT INTO sny_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Sosu Jisas apou eiye, “Weiyai! Lu taune tomu ne'ese fene ma'e peri areareyei ne aiyerowa. Lowe apou te'esiya, ‘Nomo fene ma'e peri wisere a'i au te'eyei ne aiyerowa.’ Ahowa, peri werese lowe lo wawero a'i ne. Fene peri wawero lowe lo owe ape wanu umasite. Mt 24:24; Ap 20:29; 2 Pi 2:1 ");
INSERT INTO sny_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Fene lu taune lo yo seni ape siyeyei su, fene yo seni lowe lo siye so'oruwerowa. Lowe yo seni luwaru a'i ironamirowa. Lu taune werese Owane Sitewi lo wiyawi anisiya ape, lowe yo seni aseyaro a'i ironamisiya. Fene iyu sepau lo lo'u fiyarowe sahe anirowata. Aiwawe a'i, fene unere lo lo'u wafei tohu sahe anirowata. Ga 5:19-22; Je 3:12 ");
INSERT INTO sny_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Peri ape wiyeme a'i ne. Wanure! Me wisere a'i ta so wisere a'i ta'esiya. Aiwawe a'i me luwaru a'i ta so luwaru a'i ta'esiya. ");
INSERT INTO sny_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Me wisere a'i ta so luwaru a'i ta'erowata. Aiwawe a'i me luwaru a'i ta so wisere a'i ta'erowata. ");
INSERT INTO sny_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Me ta so luwaru a'i ta'eyei su, meni ta me ape aine ou ani ererowa. Sosu yehe ma'e ani fu arosawirowa. Mt 3:10; Lu 3:9; Jo 15:6 ");
INSERT INTO sny_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Serai lu taune tamo yo seni luwaru a'i irowei su, fene lowe ne siye so'oruwe tepa'asiyei. Lowe yo peri ano umasi se ta'ama. Mt 12:33 ");
INSERT INTO sny_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Fene apou owe ape totete, ‘Lu taune werese iyape ano ei ani arowesiya ape, lowe Tai ano lo omo hire ma'e wirowa.’ Ahowa, lu taune tamo Tai ano lo marepi tote umasinamiyei su, lowe a'i lai Owane Sitewi lo omo hire ma'e wirowa. Lu 6:46; Je 1:25 ");
INSERT INTO sny_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Nowe ye'ewi su, lu taune tomu ne'ese ane ma'e apou te'erowa, ‘Owane, Owane! Nomo peri no lu taune werese ma'e au te'e fiyariteye. Sosu nomo iyape no se sepei luwaru a'i tomu ne'ese pefine au ta'ane sasari arosawiteye. Sosu nomo iyape no se wiyawi erasi a'i iroteye.’ ");
INSERT INTO sny_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ane peri lowe lo wanurowa su, ane lowe ma'e apou eirowa. ‘Ane fene werese so'oru ta'ama. Fene ane arunatire. Fene yo seni luwaru a'i ironamiteye.’” Sng 6:8; 2 Ti 2:19 ");
INSERT INTO sny_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Sosu a'i pe lu taune werese peri ano wanu tote umasinamisiya ape, lowe meni ta marepi wisere a'i wou a'i ne. Meni ta marepi wisere a'i totesiya ape, le wesi lo tapiye hire ma'e ta'anesiya. ");
INSERT INTO sny_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Sosu me'iye su sa'i erasi itorairowa. Fiyaru erasi wesi ape aine narowa. Sa'i ei ape wesi lo ma'e aine towesiyei ne totesiya. Ahowa, sa'i ei wesi ape tewi apetirowata. Wesi ape tapiye erasi sahe kairefi se teinamiteye.” ");
INSERT INTO sny_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Sosu aiwawe a'i lu taune tere'e tamo peri ano wanu arisisiya ape lowe meni marepi meremereye a'i wou a'i ne. Meni ta marepi meremereye a'i totesiya ape, le wesi lo yo'u eneri sahe ta'aneye. ");
INSERT INTO sny_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Sosu me'iye su sa'i erasi itorairowa. Fiyaru erasi wesi ape aine towesi apetirowa. Sa'i ei ape wesi lo ma'e aine towesiyei ne totesiya. Sa'i ei ape eneri werese wesi unahi iroteye ape, tewi koruwe aiti. Sa'i ei ape wesi lo tewi towesi aniri.” ");
INSERT INTO sny_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Sosu a'i pe Jisas peri werese au te'e fiyari tepa'asiye su, lu taune werese peri werese lo ne hepene se su'ariye. ");
INSERT INTO sny_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Piyene awere? Jisas peri lo au te'e areiyeye su, le meni iyape erasi se wou a'i ne. Yo peri te'e siye lu lowe peri au te'eye su, lowe marepi luwaru a'i se au te'eteye. Jisas lu ape mo wou ta'ama. Mk 1:22; Lu 4:32 ");
INSERT INTO sny_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Sosu a'i pe Jisas peri au te'e tepa'asiye su, le omo hire ma'e itorai. Lu taune tomu ne'ese le mo'o itorai. ");
INSERT INTO sny_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Omo hire ma'e itorai su, Jisas meni ta enite kairefi a'i se siyeye. Meni ape Jisas ma'e faiyewe, lowe uporo hi ape'i onurai. Le Jisas ma'e eiye, “Meni Owane, Ne ane ne marepi erasi a'i ferafereiyei su, ne enite werese ano au ani ta'ane niyemaiyere.” ");
INSERT INTO sny_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Sosu Jisas ereti lo tesisawiyewe, meni ape isawe aniteye. Sosu le meni ape ma'e apou eiye, “Ane apou totesiya, Ei! Ane fara'u enite werese no au ta'ane niyemaiyeyei.” Sosu Jisas peri te'eye su, pereye a'i meni ape lo enite werese foro'owe tepa'asiye. ");
INSERT INTO sny_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Sosu Jisas le ma'e eiye. “Ne lu taune werese ma'e owe ape te'e fiyarite. Ahowa, ne au heseyei meni owane ma'e ire. Ne witane a'i au heseyei meni owane ape ma'e tahe no au atuature. Sosu mo'o ne Owane Sitewi ma'e ayei ta au hesere. Ne Moses lo yo peri umasire. Tu naifa weriyei Moses apou leseye, ‘Enite kairefi no au niyemaiyeyei su, ne au heseyei meni owane ma'e enite werese au atuatuwei ne ire. Sosu mo'o ne ayei ta Owane Sitewi ma'e au hesere. Au heseyei meni owane ape tahe no siyeye su, le apou eiyei, ane ne ma'e eisiya, tahe werese no aseyarowe tepa'asiye.’” Wkp 14:1-32; Mt 9:30; Lu 17:14 ");
INSERT INTO sny_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Sosu a'i pe Jisas omo Kaperneam ma'e fi. Sosu ai atu siye meni owane ta le ma'e ei toweriyei ne fai. ");
INSERT INTO sny_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Le apou ei toweriye, “Meni Owane, Wiyawi yahowa'i meni ano wesi ano howeisiya. Ereti lowe werese lo luwaru afofo a'i ne. Le fofowei erasi a'i teritenamisiya.” ");
INSERT INTO sny_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Sosu Jisas itiya'u eiye, “Ei, ane wesi no ma'e wiyawi yahowa'i meni no au ani ta'ane fara'uweyei ne aiyerowa.” ");
INSERT INTO sny_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ahowa, ai atu siye meni owane le ma'e itiya'u apou eiye, “Ahowa, ne meni erasi a'i ne. Ane meni yahowa'i. Ne wesi ano papu wirairowata. Wesi ano luwaru a'i ne. Ahowa, ne peri ta apou eire. Sosu wiyawi yahowa'i meni ano wisere a'i henerairowa. ");
INSERT INTO sny_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Wanure. Ane meni owane unahi irosiya. Sosu ai atu siye lu tomu ne'ese ane unahi irosiya. Ane ai atu siye meni ta apou eiyei su, ‘Ne fu ire!’ Meni ape peri ano wanu umasiyewe, serai le iyei. Sosu ane meni tere'e ma'e apou eiyei su, ‘Ne aiya!’ Meni ape peri ano wanu umasiyewe, serai le aiyeyei. Sosu ane wiyawi meni yahowa'i ano ma'e apou eiyei su, ‘Ne wiyawi ape ta'anere!’ Sosu wiyawi meni yahowa'i ano peri ano wanuwe. Serai le wiyawi ano ta'ane tepa'asirowa.” ");
INSERT INTO sny_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Sosu Jisas peri lo ape wanuwe su, le marepi erasi a'i toteye. Sosu le lu taune werese, umasiteye ape, ma'e apou eiye, “Peri wiyeme ano wanure. Israel lo omo pani werese sahe meni ape lo tote tawesiyei lo erasi a'i ne. Tote tawesiyei lo lu taune tere'e ani ararowe. ");
INSERT INTO sny_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Sosu ane fene ma'e eisiya. Lu taune tomu ne'ese omo pani poweiye itoriyei ape, sosu omo pani poweiye wirairowa ape, lowe omo hire ma'e lu Abraham, Aisak, Jekop mase ene ayei ne ta'uwerowa. Lu 13:29 ");
INSERT INTO sny_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Juda lo lu taune feni tewi Owane Sitewi tu naifa ariariyeye ape, lowe Owane Sitewi lai ani fusawirowa. Le lowe yehe omo pasi a'i ma'e eimawesawirowa. Lowe omo pasi a'i ape ma'e irowa su, lowe luwei erasi irotorowa. Mato pi lowe lo ta'ani tawesirowa.” Mt 22:13; 25:30; Lu 13:28 ");
INSERT INTO sny_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Sosu Jisas ai atu siye meni owane ma'e eiye, “Wesi no ire! Tote tawesiyei no kairefi a'i ne. Ane marepi no tote umasiyei. Wiyawi meni yahowa'i no wisere a'i heneraiyei.” Sosu a'i pe nowe ape se, wiyawi meni yahowa'i lo ape kairefi a'i henerai. ");
INSERT INTO sny_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Sosu a'i pe Jisas Pita lo wesi papu wiye. Le Pita lo mai pape u tahe se wari sahe howeiteye ape, siyeye. Tahe werese lo umeri a'i ne. Serai le wari sahe howeiteye. ");
INSERT INTO sny_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Le menitani ape lo ereti sahe isawe aniteye. U tahe lo arunati tepa'asiye. Serai le sineyewe, Jisas lo ayei ta ta'uwe naneiyewe, lowe ma'e au ene aye. ");
INSERT INTO sny_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Nowe neriwei henerai su, lowe lu taune tomu ne'ese sepei luwaru a'i iroteye ape, Jisas ma'e fa au ta'ane sasariyei ne henetai. Sosu Jisas peri ta au te'eyewe, sepei luwaru a'i werese lowe lo au ta'ane sasariteye. Le lu taune tomu ne'ese, u tahe iroteye ape, au ta'ane fara'uweteye. ");
INSERT INTO sny_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Jisas wiyawi ape iroteye su, le Owane Sitewi lo peri au te'e siye meni Aisaia lo peri umasiteye. Tu naifa weriyei, meni ape Aisaia Jisas ne apou leseye, “Le enite werese nomo lo au ta'ane sasarisawi. Le u tahe werese nomo lo au ta'ane fara'uweteye.” ");
INSERT INTO sny_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Sosu a'i pe lu taune tomu ne'ese Jisas ma'e ta'uwerai. Jisas lu taune werese siyeye su, le lu disaipel lo ma'e apou eiye, “Nomo sa'i feni eire ma'e pei tonere.” ");
INSERT INTO sny_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Sosu yo peri so'oruwe siye meni ta Jisas ma'e eiyei ne fai. “Atuatu siye meni, ane lai ne eiwerou ma'e iyei ape, mi mi werese ane ne mase umasinamirowa.” ");
INSERT INTO sny_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Sosu Jisas le ma'e itiya'u apou eiye, “You erawe awei yo papu howeisiya. Irowe werese uri towafi lowe lo papu howeisiya. Ahowa, ane, meni omo hire ma'e itorai ape, ane yaru howeiyei se ta'ama.” 2 Ko 8:9 ");
INSERT INTO sny_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Sosu meni tere'e le aiwawe umasiyei ne toteye. Le Jisas ma'e apou eiye, “Owane tai ano temeniyeyei su, ane le fisiye yo papu furowa. Sosu mo'o ane ne me'iye umasirowa.” 1 Kin 19:20 ");
INSERT INTO sny_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ahowa, Jisas le ma'e itiya'u eiye, “Pereye a'i ne ane umasitaire. Lu ape mo Owane Sitewi ne tote tawesi ta'ame ape, lowe fara'u lu taune, temeniyeye ape, fisiye yo sahe fuwei.” ");
INSERT INTO sny_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Sosu a'i pe Jisas hare ite ma'e itori. Le wai erasi papu wi atowe. Lu disaipel lo ape mase wai papu aiwawe wi atowe. ");
INSERT INTO sny_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Sosu lowe wai hare ite ponei sahe iyatu heneri. Hare ite ponei sahe heneri su, fiyaru, sa'i ei erasi henerai. Sa'i ei erasi lai wai si lowe lo ani awetu awetowe. Lu feni werese lo atoweiye erasi irowe. Ahowa, Jisas wai papu nihe howeiteye. Sng 4:8 ");
INSERT INTO sny_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Lu disaipel lo le ma'e faiyewe, eisowerai. Lowe peri erasi te'eye, “Meni Owane, ne nomo ne ferafereire. Nomo werese temeniyeyei ne ataheyewa.” ");
INSERT INTO sny_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Sosu Jisas lowe ma'e itiya'u eiye, “Fene piyene atoweiyesiya awere? Tote tawesiyei fene lo oso a'i ne.” Sosu le sineyewe, fiyaru, sa'i ei ma'e peri erasi se einamiye. Serai fiyaru, sa'i ei ape titaneye. Mt 14:31; Sng 89:9 ");
INSERT INTO sny_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Lu disaipel lo le ne hepene se su'ariye. Meni ape piye meni awere? Fiyaru, sa'i ei peri lo wanuwe su, sosu sa'i ei erasi ape titaneye. ");
INSERT INTO sny_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Sosu a'i pe lowe hare ite Galili sa'i feni ma'e iyatu toneri. Wai eneri sahe furi. Lowe omo pani tewi iyape Gadara heneri. Sosu lowe wai seni tewi arunati su, lowe lu hesi sepei luwaru a'i papu iroteye ape, fisiye yo tomo papu henerai ape, siyeye. Lu erawe hesi ape lowesi yo mai tei tawesiteye. Serai lu taune werese ape yo mai ape se eiwerou irowata. ");
INSERT INTO sny_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Lowesi Jisas siyeye su, lowesi le ma'e apou hare uteye, “Owane Sitewi lo meni eime, ne notosi ma'e eiwerou irowei ne totesiya awere? Ne notosi ma'e au luwaruweyei ne fai awere? Nowe notosi lo henerai se ta'ame ne.” Mk 1:24; Lu 4:41 ");
INSERT INTO sny_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Omo to'u feni ma'e, fe tomu ne'ese awei peperi ene ateye. ");
INSERT INTO sny_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Sosu sepei luwaru a'i ape lowesi Jisas ma'e peri kairefi a'i uteye. “Ne notosi au eimawesawiyei su, ne fara'u fe ape mo papu, omo to'u feni ma'e irosiya ape, papu wiyei ne eimawesawire.” ");
INSERT INTO sny_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Sosu Jisas lowesi ma'e itiya'u eiye, “Ei, fe ape mo papu wiyei ne ire.” Sepei luwaru a'i ape mo lowe lu hesi arunatiyewe, fe werese papu wiye. Pereye a'i fe werese omo to'u iterotiyewe, hare ite ma'e atenise itowe. ");
INSERT INTO sny_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Fe werese sa'i papu atenise itowe su, lu werese fe ape noweinoweiteye ape, lowe omo towafi lowe lo ma'e itape iteroti. Lowe lu taune werese ma'e etiri werese ape ne au te'e fiyariteye. Lowe sepei luwaru a'i ne aiwawe au te'e fiyariteye. ");
INSERT INTO sny_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Lu taune werese peri lowe lo wanuwe su, lowe werese Jisas ma'e siyeyei ne fai. Lowe le siyeye su, lowe le ma'e ai marepi toteye. Serene lowe le ma'e apou te'eye, “Ne omo pani nomo lo arunatire.” ");
INSERT INTO sny_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Sosu a'i pe Jisas lu disaipel lo mase wai papu wi atowe. Lowe hare ite sa'i feni ma'e iyatu toneri. Le omo sitewi lo ma'e heneri. Mt 4:13 ");
INSERT INTO sny_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Lowe omo ape henerai su, lu tamo meni ta lowe nono'oweyei a'i Jisas ma'e me wari se sutaitetai. Jisas tote tawesiyei lowe lo siyeye su, le meni lowe nono'oweye ape ma'e apou eiye, “Meni eime, marepi no fetane wisere a'i irote. Yo seni luwaru a'i no ane lai au sasarisawi pamowe tepa'asiye.” ");
INSERT INTO sny_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Sosu Owane Sitewi lo yo peri ani so'oruwe siye lu tamo Jisas lo peri wanuwe su, lowe a'i lai te'e tiyatiteye. “Sawi amou! Meni ape Owane Sitewi ma'e te'e naruwe. Owane Sitewi ta'i a'i yo seni luwaru a'i au ta'ane sasarisawirowa.” ");
INSERT INTO sny_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Sosu Jisas marepi lowe lo siye so'oruwe tepa'asiye. Le lowe ma'e apou eiye, “Fene piyene marepi luwaru a'i totesiya awere? Mt 12:25; Lu 9:47; Jo 2:25 ");
INSERT INTO sny_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Fene ane ma'e au te'ere, ane meni ape ma'e au te'eyei su, ‘Yo seni luwaru werese a'i no ane lai au sasarisawirowa.’ Peri eite wiyawi erasi awere? Ahowa, peri ape etiri yahowa'i ne. Sosu ane meni ape au te'eyei su, ‘Meni, Ne sinere! Wesi no ma'e ire.’ Peri eite wiyawi erasi awere? Ahowa, peri ape etiri yahowa'i ne. ");
INSERT INTO sny_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ane fene ma'e etiri ta au atuaturowa. Ane, meni hire ma'e itorai ape, ane kairefi erasi a'i ne. Ane fara'u yo seni luwaru a'i au sasarirowa. Serai ane fene ma'e kairefi ano au atuaturowa. Ane meni ape ma'e ereti lowe nono'oweye a'i ape eirowa. ‘Meni, ne sine teire! Wari no ape anirowawe, wesi no sutetire.’” Jo 17:2 ");
INSERT INTO sny_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Sosu pereye a'i meni ape sine teiyewe, wari lo ape aniyewe, wesi lo ma'e suteti. ");
INSERT INTO sny_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Lu taune werese iroteye ape, lowe marepi hepene se su'ariye. Lowe Owane Sitewi ma'e au te'e wisereyeye. Lowe apou toteye, “Owane Sitewi lai kairefiyeyei erasi ape meni ape ma'e au tepa'asiye.” ");
INSERT INTO sny_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Sosu a'i pe Jisas omo ape arunatiyewe, yo mai sahe iteye. Le meni ta siyeye, iyape Matyu. Le wesi oso a'i sahe takis ma'aru aniteye ape, papu onuteye. Sosu Jisas le ma'e eiye, “Meni! Ne ane mo'o umasita.” Serai meni ape Jisas lo peri wanuwe su, le, le mo'o umasiti. ");
INSERT INTO sny_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Sosu Jisas lu disaipel lo aiwawe, lowe Matyu lo wesi ma'e fi. Lowe metei sahe onuri. Lu tomu ne'ese takis ma'aru aniteye ape, lu tere'e Juda lo yo peri arisiteye ape lowe, metei sahe Jisas mase ene ayei ne onuwe. ");
INSERT INTO sny_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Lu Farisi tamo lowe siyeye su, lowe Jisas lo lu disaipel ma'e apou te'e toweriye, “Piyene meni owane fene lo ape lu luwaru a'i ape ponei onu ene asiya awere? Lu ape mo ma'aru tomu ne'ese nomo lo ta'arei aniteye ne. Lowe yo peri nomo lo arisiteye.” Lu 15:2 ");
INSERT INTO sny_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ahowa, Jisas peri lowe lo wanuwe su, le apou te'eye, “Meni ta u tahe ta'ame su, le dokta ei anirowata. Ahowa, meni ta u tahe se, le dokta fara'u ei anirowa. ");
INSERT INTO sny_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ane fene ma'e eisiya, Owane Sitewi lo peri sitewi wanu so'oruwerire! Ane ayei ta fene lo au heseye ape, ani wou ta'ama. Ahowa, fene lu taune ma'e au atuatu seremareyete. Ane yo seni apou ape siyereme. Ane lu taune yo seni aseyaro a'i irosiya ape, ei aniyei ne fai ta'ama. Ahowa, ane lu taune werese yo seni luwaru a'i irosiya ape mase, hene ta'uwe aniyei ne fai.” ");
INSERT INTO sny_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Sosu a'i pe Jon sa'i au hu siye meni, le lu feni lo Jisas ma'e peri ta ei toweriyei ne eimawesai. Lowe apou te'e toweriye, “Piyene lu disaipel no ayei werese siyenami ta'ame awere? Nomo ayei werese siyenamiteye. Etiri wisere a'i tene! Sosu lu Farisi ayei werese siyenamiteye. Etiri wisere a'i tene! Serai lu disaipel no siyenami ta'ame. Piyene awere?” Lu 18:12 ");
INSERT INTO sny_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Sosu Jisas peri anowe ta lowe ma'e itiya'u eiye, “Meni ta menitani naituwei ne toteyei su, le lu tewi lo ei ta'uwe anirowa. Lowe mase saro aiwawe ta'uwerowa su, nowe ape se lowe werese nine'inamirowa. Meni ape iroteyei su, lu feni werese lo lu ewiterowata. Ahowa, lu tamo meni ape kalabus wesi ma'e henetiyei su, lu taune werese meni ape ne, lu ewite irorowa. Nowe me'iye su, lowe meni ape henetirowa. Nowe ape henerairowa su, lu feni ano lowe ayei amouweyei ne ewiterowa. ");
INSERT INTO sny_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Meni ta ipari tahe papa'u a'i irosiya su, meni ape ipari tahe he'i a'i yo ape se iwisirowata. Le ipari tahe he'i a'i ipari tahe papa'u a'i sahe iwisirowa su, ipari tahe he'i a'i lai ipari tahe papa'u a'i ma'e au luwaruwerowa. ");
INSERT INTO sny_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Aiwawe a'i meni ta wain sa'i he'i a'i kaukau seni papa'u a'i papu ani terosorowata. Ahowa, le wain sa'i he'i a'i kaukau seni papa'u a'i papu ani terosowei su, wain sa'i he'i a'i meirowawe, kaukau seni papa'u a'i peratiyei. Sosu wain sa'i werese awei sahe winetai terosorowa. Sosu wain sa'i, kaukau seni aiwawe a'i, lowesi luwaruwe po'uterowa. Ahowa, lu werese wain sa'i he'i a'i kaukau seni he'i a'i se ani terosorowa. Wain sa'i he'i a'i kaukau seni he'i a'i papu ani terosorowa su, wain sa'i kaukau seni aiwawe lowesi weriyei irorowa.” ");
INSERT INTO sny_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jisas peri ape te'eye su, Owane Sitewi lo wesi meni owane ta Jisas ma'e ei toweriyei ne fai. Le apou eiye, “Eime taune ano he'i temeniyeye. Ne fara'u ereti no tahe lo ma'e isawe hetesiyere. Serai le si tame norohuwe sineyei.” ");
INSERT INTO sny_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jisas peri ape wanuwe su, le sineyewe, meni owane ape mase aiwawe fi. Lu feni lo aiwawe a'i fi. ");
INSERT INTO sny_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Lowe meni ape lo yo ape iteye su, menitani ta u fisa'i nowe weriyei iroteye. Iyu menei ereti feni hesi lowe hesi a'i (12) fisa'i heneraiteye. Menitani ape Jisas me'iyeni ma'e faiyewe, ipari tahe lo weniwe isawe hetesiyeye. ");
INSERT INTO sny_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Menitani ape apou toteye, “Ane ipari tahe lo isawe hetesiyeyei su, u fisa'i ano tepa'asirowa.” Mt 14:36 ");
INSERT INTO sny_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Serai menitani ape Jisas lo ipari tahe lo weniwe isawe hetesiyeye su, Jisas atati teiyewe, menitani ape siye etiye. Le menitani ape ma'e apou eiye, “Menitani, marepi hepene no fetane wisere a'i irote. Tote tawesiyei no ape lai u fisa'i no po'uteye.” Jisas peri tepa'asiye su, menitani lo u fisa'i po'uteye. ");
INSERT INTO sny_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Sosu Jisas lu feni lo mase meni owane lo wesi ma'e henerai. Le lu tomu ne'ese mene'e faseteye ape siyeye. Lu taune tomu ne'ese lu ewiteteye ape siyeye. No'u erasi a'i ape wanuteye. ");
INSERT INTO sny_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Sosu Jisas lowe werese ma'e eiye, “Fene werese sato arunatire. Meni owane lo eime taune ape temeniye ta'ame. Le nihe howeisiya.” Lowe werese peri lo wanuwe su, lowe le ne niyeyei erasi iroteye. ");
INSERT INTO sny_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Jisas lowe werese wesi nowe ma'e eimawe fiyarisawi su, le wesi ape tewi wesi papu eime tani howeiteye ape ma'e wiye. Le eime taune lo ereti aniteyewe, meni owane ape lo eime taune ape au ani sine onuwe. ");
INSERT INTO sny_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Menitani ape sine teiye su, peri ape ne omo omo werese te'e fiyarisawi. ");
INSERT INTO sny_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Sosu a'i pe Jisas lu feni aiwawe a'i wesi ape arunatiyewe, fi. Yo mai sahe itiye su, lu hesi, nihe pokowe iroteye ape, Jisas mo'o umasiti. Lowesi apou hare uteye, “Ya'ariyei owane Devit lo meni eime, ne notosi au ferafereire.” Mt 20:29-34 ");
INSERT INTO sny_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Sosu Jisas wesi papu wiye su, lu hesi ape nihe pokowe iroteye ape, lowesi Jisas ma'e tame te'e toweriyei ne fai. Jisas lowesi ma'e itiya'u ei toweriye, “Fenesi piye totesiya awere? Ane fara'u nihe fenesi lo au ani peteneyei awere? Piye tote tawesisiya awere?” Lowesi le ma'e itiya'u eiye, “Ei, ne fara'u nihe notosi lo au ani iro peteneyei.” ");
INSERT INTO sny_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Jisas tote tawesiyei lowesi lo siyeye su, le nihe lowesi lo ereti se isawe hetesiyeyewe, lowesi ma'e eiye, “Ane tote tawesiyei fenesi lo umasiyei. Ane nihe fenesi lo au ani peteneyei.” ");
INSERT INTO sny_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Pereye a'i nihe lowesi lo peteneye. Serai lowesi etiri werese amerame a'i siyeye. Sosu Jisas lowesi ma'e peri kairefi a'i se eiye, “Fenesi lu taune werese wiyawi erasi pefine a'i ape ne owe ape te'ete.” Mt 8:4 ");
INSERT INTO sny_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ahowa, lowesi wesi ape arunati su, lowesi omo omo werese sahe lu taune werese ma'e au te'e fiyariteye. ");
INSERT INTO sny_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Sosu a'i pe Jisas lu feni ma'e eiye, “Nomo wesi ape arunatiyei.” Lowe wesi ape arunati su, lu taune tamo meni ta ahi tomo'ute tawesiye ape Jisas ma'e henetai. Sepei luwaru a'i lai meni ape lo ahi einamiteye. ");
INSERT INTO sny_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Sosu Jisas sepei luwaru a'i ape eimawesawi. Sepei luwaru a'i ape meni ape arunati su, meni ape fara'u te'e areiyeteye. Lu taune werese wiyawi ape siyeye su, lowe hepene se su'ariye, apou te'e tiyatiteye, “Siyere! Tu omo omo werese sahe nomo wiyawi eito eite siye ta'ame.” Mk 2:12 ");
INSERT INTO sny_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ahowa, lu Farisi tamo apou eiye, “Fene werese Jisas lo peri owe ape wanu tote umasite. Le sepei luwaru a'i lo owane lo kairefiyeyei se sepei luwaru a'i au ta'ane eimawesawi.” Mt 12:24; Mk 3:22; Lu 11:15 ");
INSERT INTO sny_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Serai Jisas lu disaipel lo mase omo omo werese sahe Owane Sitewi lo marepi lo peri heneruwe wisere a'i au te'e fiyariteye. Le ta'uweyei wesi sahe au te'eteye. Lu taune werese u tahe se ape, le u tahe lowe lo au ta'ane fara'uweye. Lu taune enite se iroteye ape, le enite werese au ta'ane niyemaiyeye. Mt 4:23; Mk 1:39 ");
INSERT INTO sny_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Le lu taune tomu ne'ese siyeye. Serai le lowe ne ewiteyei erasi iroteye. Piyene awere? Lowe marepi orese a'i iroteye. Lowe fe sipsip meni owane ta se ta'ama ape wou a'i ne. Mt 14:14; Nam 27:17; 1 Kin 22:17; Sek 10:2; Mk 6:34 ");
INSERT INTO sny_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Sosu le lu disaipel lo ma'e apou eiye. “Lu taune werese siyere! Lu taune tomu ne'ese Owane Sitewi ma'e aiyeyei ne ta'uwesiya. Ahowa, lu ta'i ta'i a'i lai lowe ma'e Owane Sitewi ne au atuatusiya. Lu 10:2 ");
INSERT INTO sny_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Serai fene Owane Sitewi ma'e wiyawi siye lu taune tomu ne'ese eimawesaiyei ne te'e towerire. Piyene awere? Lowe lu taune tomu ne'ese Owane Sitewi ma'e henetirowa.” ");
INSERT INTO sny_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Sosu a'i pe Jisas lu disaipel werese lo ei aniye. Jisas lo lu disaipel ereti feni hesi lowe hesi a'i (12) Jisas ma'e ta'uwerai. Le lowe ma'e kairefi erasi a'i auwe. Lowe kairefi ape se sepei luwaru a'i au ta'ane sasari eimawesawiyei. U tahe werese lowe lai fara'u au ta'ane fara'uweyei. Sosu lowe u werese a'i fara'u au ta'ane fareraiyeyei. Mk 6:7; Lu 9:1 ");
INSERT INTO sny_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Lu feni ereti feni hesi lowe hesi a'i (12 aposel) lo iyape apou te'eye. Tutawe Saimon, iyape tere'e Pita. Pita lo pa'ise Andru. Jems, Sebedi lo meni eime. Sosu Jems lo pa'ise iyape Jon. ");
INSERT INTO sny_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip, meni tere'e Bartolomyu, sosu Tomas, sosu Matyu, meni ape takis ma'aru ani se meni. Meni tere'e iyape Jems, Alfius lo meni eime, sosu meni tere'e Tadius. ");
INSERT INTO sny_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Meni tere'e Saimon Selot. Sosu meni ye'ewi Judas Iskariot. Meni ape nowe me'iye su, le ai atu siye lu Jisas ma'e henetirowa. ");
INSERT INTO sny_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Sosu a'i pe Jisas lu disaipel lo (12) le ma'e aiyeyei ne ei aniye. Le lowe ma'e eiye, “Ane fene omo omo ma'e eimawesawiyei. Fene lu tewi tere'e ma'e owe ape ire. Ahowa, aiwawe a'i fene Samaria lo pani tewi ma'e owe ape ire. ");
INSERT INTO sny_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ahowa, fene Israel lo lu taune ma'e Owane Sitewi lo peri au te'eyei ne ire. Lowe fe sipsip owane se ta'ama wou a'i ne. Lowe Owane Sitewi lo yo peri werese i'aneye. Serai fene lowe Owane Sitewi ma'e si tame henetaire. Jer 50:6 ");
INSERT INTO sny_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Fene iyei su, fene lu taune werese ma'e peri apou au te'e fiyarire. Nowe ape se Owane Sitewi lai lu taune werese ma'e au noweinoweirowa ape ataheyewa. Mt 3:2; 4:17; Lu 10:9,11 ");
INSERT INTO sny_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Fene lu taune tamo u tahe se siyeyei su, fene fara'u u tahe lowe lo au ta'ane fara'uwere. Lu taune tamo, temeniyeye ape, fene fara'u lowe si tame hene ani sinere. Lu taune tamo enite kairefi a'i se, fene fara'u enite werese lowe lo au ta'ane niyemaiyere. Lu taune tamo sepei luwaru a'i iroteye ape, fene sepei luwaru a'i ape au eimawesawire. Ane fene ma'e kairefiyeyei ape neri a'i auwei. Serai fene wiyawi ano ape irowei su, fene ma'aru ta owe ape anire. ");
INSERT INTO sny_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Fene iyei su, fene ma'aru niye fene lo papu owe ape ani asitire. Lu 10:4 ");
INSERT INTO sny_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Fene Owane Sitewi lo peri au te'eyei su, lu taune tamo fene ma'e etiri ayei ta aurowa. Serai fene niye ta owe ape aiti. Fene apou owe ape totere, ‘Ane lowe tahe hesi a'i fara'u aitiyei. Ane ipari tahe hesi a'i aiwawe a'i aitirowa.’ Ahowa, fene iyei su, ipari tahe ta'i ani asire. Sosu ire! Fene me epi owe ape aiti. Wiyawi meni ta wiyawi aniyei su, lu tamo etiri lo le ma'e fa aure. Lu 10:7; 1 Ko 9:14 ");
INSERT INTO sny_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Fene omo ta heneriyei su, fene apou te'e toweriyei, ‘Eiwerai nomo au isafiyerowa awere?’ Meni ta fene au isafiyeyei su, fene meni ape lo wesi sahe irowei. Fene wesi tere'e tere'e sahe owe ape irote. Fene omo ape arunatiyei ne toterowa su, fene wesi ape aiwawe arunatirowa. ");
INSERT INTO sny_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Fene wesi ape papu wiyei su, fene lu taune wesi sahe irowei ape, eriteyei. Lu 10:5-6 ");
INSERT INTO sny_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Lu ape mo fene ma'e isafiyeyei su, fene lowe ma'e marepi fetane a'i au te'ere. Ahowa, lu ape mo fene ma'e isafiye ta'ame su, fene marepi fetane a'i owe ape te'ere. ");
INSERT INTO sny_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Lu tamo fene ma'e isafiye ta'ame su, sosu peri fene lo wanu arisiyei su, fene wesi ape, omo ape arunatire. Fene wesi omo ape arunatiyei su, fene awei peperi lowe tahe irosiya ape, ato periperenatire. Lu 10:10-12; Ap 13:51 ");
INSERT INTO sny_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ane peri wiyeme a'i fene ma'e au te'esiya. Wanure! Omo ta ape fene ma'e au luwaruweyei su, nowe ye'ewi su, lu taune omo ape sahe iroteye ape, Owane Sitewi lai lowe ma'e fofowei erasi luwaru a'i aurowa. Lu taune, omo Sodom, omo Gomora sahe iroteye ape, nowe ye'ewi su, lowe fofowei oso a'i teritetorowa.” Mt 11:24; Ju 7 ");
INSERT INTO sny_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Sosu a'i pe Jisas lu disaipel lo ma'e apou au te'eye, “Fene weiyai! Ane fene lu taune ma'e ai marepi Owane Sitewi se totesiya ape, au te'e fiyariyei ne eimawesawiyei. Fene fe sipsip wou a'i ne. Fene tahe pere'e a'i ne. Fene marepi wisere a'i totere. Marepi fene lo fetane a'i totesiya. Lu taune ape mo, lowe you erawe wou a'i ne. Lowe fene ma'e atati teirowawe, ai erasi aturowa. Serai fene lowe ma'e au te'eyei ne iyei su, fene marepi fetane a'i lowe ma'e totere. Aiwawe a'i fene marepi wisere a'i totere. Fene lowe ma'e iyei su, fene marepi momotei a'i totere. Fene yo seni luwaru a'i lowe ma'e owe ape irote. Lu 10:3; Ro 16:19 ");
INSERT INTO sny_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Fene weiyai! Lu tamo peri fene lo wanuwei su, lowe fene etiyei ne henetirowa. Lowe fene ta'uweyei wesi ma'e henetirowawe, me'iyeni fene lo sahe wafei se ainerowa. ");
INSERT INTO sny_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Lowe fene lu owane tamo ma'e etiyei ne henetirowa. Lowe fene meni owane tutawe ma'e henetirowawe, fene ne apou au fu te'erowa, ‘Lu tewi ape, lowe Jisas lo peri au te'e fiyari areiyesiya.’ Fene lowe ma'e henerairowa su, fene peri ano lowe ma'e au te'ere. Fene peri ano lu tewi tere'e ma'e aiwawe aurowawe, au te'ere. ");
INSERT INTO sny_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ahowa, lowe fene etiyei ne henetirowa su, fene marepi fene lo auseriyeyei sawa. Fene peri te'eyei su, atoweiye sawa. Nowe ape se, Owane Sitewi lai fene ma'e peri wiyeme a'i lo au te'erowa. Serai fene lowe ma'e Owane Sitewi lo peri wiyeme a'i au te'e areiyerowa. ");
INSERT INTO sny_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Lowe fene etirowa su, fene lai peri fene lo ape au te'eyei ta'ama. Ahowa, Owane Sitewi Tai fene lo, lo Hepene Wara'i a'i ape lai peri wiyeme a'i lo ape au te'erowa. Mk 13:9-11; Lu 12:11-12; 21:12-15; Jo 14:26 ");
INSERT INTO sny_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Nowe me'iye su, meni ta lai pa'ise meni lo etiyei ne henetirowa. Le lu owane ma'e apou au te'erowa, ‘Fene pa'ise ano eite fu aine tera'ere.’ Aiwawe aite ta lai meni eime lo etiyei ne henetirowa. Sosu eimane tamo lai tai mai lowe lo etiyei ne henetirowa. Lowe tai mai lowe lo ape aine tera'eyei ne toterowa. Mai 7:6; Mt 10:35; Mk 13:12; Lu 21:16 ");
INSERT INTO sny_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Fene peri ano au te'e fiyarirowa su, lu taune werese fene ne ai marepi totenamirowa. Ahowa, lu taune tamo kairefi a'i teinamirowa su, Owane Sitewi lai lowe mo mi mi pasi pasi au ferafereirowa. ");
INSERT INTO sny_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Sosu lu tamo omo ape sahe fene ma'e au luwaruweyei su, fene omo tere'e ma'e atoweiye iteroti. Peri pefine a'i ano wanure. Fene Israel lo omo pani werese ma'e au te'eyei ne iyei su, fene wiyawi ape tepa'asiye ta'ama. Serai fene wiyawi ape ironamitorowa. Sosu ane, meni hire ma'e itorai ape, si tame itorairowa su, sosu fene wiyawi ape iro tepa'asirowa. ");
INSERT INTO sny_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Eimane ta lai atuatu siye meni lo ani fu ararorowata. Aiwawe a'i wiyawi yahowa'i siye meni lai meni owane lo ani fu ararowata. Lu 6:40; Jo 13:16; 15:20 ");
INSERT INTO sny_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Eimane ape lai atuatu siye meni lo wou henerairowa. Sosu wiyawi yahowa'i siye meni lai meni owane lo aiwawe a'i henerairowa. Etiri ape mo wisere a'i ne. Ne apou eisiya su, ‘Ne lai sepei luwaru a'i tutawe, Belsebul Mt 9:34; 12:24; Mk 3:22; Lu 11:15 ");
INSERT INTO sny_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Serai ane fene ma'e peri pefine a'i ape au te'esiya, fene lowe ne owe ape atoweiyete. Lowe fene ma'e etiri ta au luwaruweyei su, etiri ape amerame a'i henerairowa. Etiri werese lowe fareyareye iroteyei ape, Owane Sitewi lai etiri ape mo lu taune ma'e au te'e atuatu areiye fiyarirowa. Mk 4:22; Lu 8:17 ");
INSERT INTO sny_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ane fene ma'e eresene a'i peri ta au te'erowa su, fene lu taune werese ma'e i au te'e areiyere. Sosu ane peri eresene a'i fene ma'e au te'erowa su, fene peri ahi erasi a'i se lu taune werese ma'e au te'e ute areiye fiyarire. ");
INSERT INTO sny_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Lu tamo fene aine tera'eyei ne toterowa su, fene lowe ne owe ape atoweiyete. Lowe hepene fene lo ape mase aine tera'erowata. Ahowa, meni ape tahe pa'are, hepene mase aine tera'erowa ape, sosu yehe omo ma'e fu arosawirowa ape, fene meni ape fu atoweiyete. Meni ape Owane Sitewi pefine a'i tene. Je 4:12 ");
INSERT INTO sny_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Meni ta irowe mawe hesi a'i ma'aru tau ta'i a'i eterowa. Sosu irowe mawe ta'i awei sahe wiyeinerowa su, tai fene lo, hire ma'e irosiya ape, le marepi erasi a'i irowe mawe ne totenamirowa. ");
INSERT INTO sny_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Aiwawe a'i Owane Sitewi tai fene lo le lai mato towe fene lo ape werese werese nawite tepa'asiye. Serai le fene marepi erasi a'i tote wawesiyenamisiya. ");
INSERT INTO sny_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Serai fene owe ape atoweiyete! Owane Sitewi lo nihe se fene iyape erasi se ironamisiya. Fene irowe mawe tomu ne'ese ani fu ararowe.” Mt 6:26 ");
INSERT INTO sny_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Fene iyape ane ne lu taune werese ma'e au te'e fiyariyei su, ane lai fene ne tai ano ma'e omo hire ma'e ironamisiya ape, au te'e areiyerowa. ");
INSERT INTO sny_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Meni ta ane ne amerame a'i sahe apou te'erowa su, ‘Ane Jisas so'oru ta'ama.’ Ane le ne aiwawe a'i tai ano ma'e omo hire ma'e ironamisiya ape, apou te'erowa, ‘Ane meni ape so'oru ta'ama.’” Mk 8:38; Lu 9:26; 2 Ti 2:12 ");
INSERT INTO sny_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Sosu a'i pe Jisas lu disaipel lo ma'e apou eiye, “Fene apou owe ape totere, ‘Jisas lu taune werese ma'e marepi fetane a'i auwei ne fai.’ Ahowa, ane marepi fetane a'i auwei ne fai ta'ama. Ane lu taune ma'e ai atuwei erasi au irowei ne fai. Ane lu taune lo ai marepi au ani atuwei ne fai. Ane hi awei ma'e itorai su, peri wiyeme a'i ano lai lu taune ai atu tiyati au irorowa. ");
INSERT INTO sny_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ane ai marepi au ani atuwei ne fai. ‘Meni ta lai eimane lo mase ai atu tiyatirowa. Eime taune ta lai mai lo mase ai atu tiyatirowa. Ewite ta lai mai pape mase ai atu tiyatirowa. ");
INSERT INTO sny_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Lu airame lowe lo ne, lowe lu tewi topo lo ne.’ ");
INSERT INTO sny_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Meni ta aite mai lo ne marepi erasi tote wawesiyeyei su, sosu ane ne marepi oso a'i tote wawesiyeyei su, ane le ne marepi erasi a'i tote wawesiyerowata. Aiwawe a'i meni ta eimane lo ne marepi erasi a'i tote wawesiyenamiyei su, sosu le ane ne marepi oso a'i tote wawesiyeyei su, ane lai meni ape marepi erasi a'i tote wawesiyerowata. ");
INSERT INTO sny_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Meni ta me tape'i sahe temeniyeyei ne tote ta'ame su, sosu ane mo'o umasi ta'ame su, le lu feni ano ta'ama. ");
INSERT INTO sny_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Meni ta apou a'i toteyei su, ‘Ane marepi hepene wisere a'i ironamisiya.’ Meni ape marepi hepene topo lo po'uterowa. Sosu meni ta iyape ano se wiyawi ano anitiyei ape, le temeniyeyei su, le marepi hepene he'i a'i mi mi pasi pasi ironamitorowa.” Mt 16:24-25; Mk 8:34-35; Lu 9:23-24; 17:33; Jo 12:25 ");
INSERT INTO sny_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Lu taune tamo lai fene ma'e au sewiye isafiyerowa su, lowe lai ane ma'e aiwawe a'i au sewiye isafiyerowa. Sosu lu taune tamo ane ma'e au sewiye isafiyenarairowa su, lowe tai ano, ane hi awei sato eimawe arosai ape, lowe le ma'e au sewiye isafiyerowa. Mk 9:37; Lu 10:16; Jo 13:20 ");
INSERT INTO sny_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Meni ta apou toteyei su, ‘Meni ape Owane Sitewi lo peri au te'e siye meni pefine a'i ne.’ Serai ane meni ape wesi ano papu hene wirowawe, le ma'e au isafiye arowa. Fene apou wou a'i toteyei su, fene etiri wisere a'i Owane Sitewi lai au te'e siye lu ma'e aurowa ape, fene etiri apou ape wou anirowa. Meni ta apou toteyei su, ‘Meni ape yo seni aseyaro a'i ironamisiya. Ane meni ape wesi ano hene wirowawe, le ma'e au isafiye arowa. Fene apou toteyei su, Owane Sitewi lai etiri wisere a'i fene ma'e aurowa. Etiri ape mo Owane Sitewi lai lu taune ma'e, yo seni aseyaro iroteye ape, aurowa. ");
INSERT INTO sny_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Peri ano wiyeme a'i ne, wanure! Meni ta sa'i wara'i a'i eimane ta peri ano umasiteye ape, ma'e au arowa su, Owane Sitewi lai meni ape ma'e etiri wisere a'i aurowa. Etiri wisere a'i le aurowa ape, etiri wisere a'i po'uterowata.’” ");
INSERT INTO sny_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Sosu a'i pe Jisas lu disaipel lo (12) ma'e au te'e atuatu tepa'asiye su, le omo ape arunatiyewe, omo tere'e tere'e Galili sahe Owane Sitewi lo peri au te'e fiyariteye. ");
INSERT INTO sny_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Jon sa'i au hu siye meni kalabus wesi iroteye ape, le Krais lo wiyawi ne wanuwe su, le lu disaipel lo tamo le ma'e ei toweriyei ne eimawesawi. ");
INSERT INTO sny_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Lowe le ma'e apou te'e toweriye, “Tu naifa weriyei Owane Sitewi lai peri ta lu tewi Israel ma'e au te'e naneiye. Le apou eiye, ‘Nowe me'iye su, ane meni eime ano fene ma'e au pati aniyei ne eimawe arosairowa. Ne meni ape Owane Sitewi lai, hi awei sato eimawe arosairowa ape, ne meni ape awere? Nomo meni tere'e ninawe teirowa awere?’” ");
INSERT INTO sny_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Sosu Jisas lowe ma'e itiya'u eiye, “Fene Jon ma'e si tame ire! Fene etiri werese ape mo, fene siyeteye ape, fene wanuteye ape, le ma'e au te'e areiyere. ");
INSERT INTO sny_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ane lu taune nihe pokowe tawesiye ape, nihe lowe lo au petaneye. Ane lu taune tamo lowe luwaruweye ape, ane lowe lowe lo au ani ta'ane fareraiyeye. Lu taune tamo enite kairefi a'i iroteye ape mo, ane enite werese au ta'ane niyemaiyeteye. Lu taune tamo apaniye te'eniye tawesiye ape, ane apaniye lowe lo ani tosowe. Lu taune tamo temeniyeye ape, ane lowe hene ani sineye. Sosu ane Owane Sitewi lo peri lu taune ma'aru ariye a'i ape, au te'e fiyariteye. Ais 35:5-6; 61:1 ");
INSERT INTO sny_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Meni ta ane ne marepi hesi se tote ta'ame su, marepi lo wisereye nine'inamisiya.” ");
INSERT INTO sny_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Sosu a'i pe Jon lo lu feni Jisas arunati su, Jisas lu taune werese ma'e Jon ne au te'e areiyeteye. Le lowe ma'e au ei toweriye, “Fene pani ariye a'i ma'e piye siyeyei ne fi awere? Fene menei towe wou a'i au nareyeyei siyeyei ne fi awere? Ahowa, fene meni ta marepi ta'i a'i totesiya ape, siyeyei ne fi. ");
INSERT INTO sny_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Fene pani ariye a'i ma'e piye siyeyei ne fi awere? Meni ta ipari tahe wisere a'i ani asiteye ape, awere? Wanure! Lu werese ipari tahe wisere a'i ani asisiya ape, lowe lu owane tutawe lo wesi sato howeisiya. ");
INSERT INTO sny_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Sosu ane fene ma'e tame ei towerisiya, fene piyene pani ariye a'i ma'e fi awere? Fene Owane Sitewi lo peri au te'e siye meni ta siyeyei ne fi awere? Ei, pefine! Ane fene ma'e au te'esiya, meni ape Owane Sitewi lo peri au te'e siye lu werese ani ararowe. ");
INSERT INTO sny_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Tu naifa weriyei meni ta Owane Sitewi lo one towe sahe apou leseye, ‘Wanure! Ane peri au te'e siye meni ano nihari no ma'e eimawesawiyei. Meni ape aiyerowa su, le yo no au ta'uwe naneirowa.’ ");
INSERT INTO sny_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ane peri wiyeme a'i fene ma'e au te'esiya. Lu werese awei sato irosiya ape, meni ape Jon sa'i au hu siye meni lowe werese ani ararowe. Ahowa, fene werese Owane Sitewi lo marepi ne tote tawesi umasisiya ape, fene Owane Sitewi lo omo sahe fene iyape erasi a'i irosiya. Iyape fene lo Jon lo iyape ani ararosiya. Piyene awere? Fene Owane Sitewi lo marepi siye so'oruwe tepa'asiye. ");
INSERT INTO sny_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Jon Owane Sitewi lo marepi lu taune ma'e au te'e fiyariyei ne fai su, lu taune Owane Sitewi lo marepi umasisiya ape, ai atu siye lu tamo lai, lowe ma'e fofowei erasi au luwaruwerowawe, apou toteteye, ‘Nomo Owane Sitewi lo au noweinoweiyei unahi ironamirowata. Nowe ape henerairowa su, nomo ai atu kairefiyerowa.’ Pereye nowe eite se lowe ai atunamisiya. ");
INSERT INTO sny_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Owane Sitewi lo peri au te'e fiyari se lu werese sosu aiwawe a'i yo peri ape, Moses leseye ape, lowe etiri werese, me'iye su henerairowa ape, au te'eye. Jon henerai su, lowe peri lowe lo au te'e tepa'asiye. Lu 16:16 ");
INSERT INTO sny_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Lowe peri ape au te'eye su, lowe meni Elaija ne toteye. Fene peri ape wanuwei su, fene meni ape ne wanu tote tawesirowa. Fene peri ape wanu ani ta'ame su, fene marepi towafi fene lo umasirowa. Mal 4:5; Mt 17:10-13; Mk 9:11-13 ");
INSERT INTO sny_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Lu taune werese apaniye se, fene peri ape wanute. ");
INSERT INTO sny_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Lu taune ape pereye nowe eite se irosiya ape, ane yo seni lowe lo ne au te'eyei su, ane peri anowe ta piye au te'erowa awere? Ei! Lowe eimane wou omo nepawe amerame sahe onuteye. Lowe eimane tere'e ma'e uteyei. ");
INSERT INTO sny_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Lowe apou uteyei, ‘Nomo mene'e fateye su, fene ure'i wou unei ta'ame. Nomo lu ewiteye su, fene lu ewite ta'ame.’ ");
INSERT INTO sny_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jon fai su, le ayei a ta'ame, wain sa'i a ta'ame. Sosu lu taune ape mo le ne apou au te'eye, ‘Meni ape sepei luwaru a'i papu irosiya.’ ");
INSERT INTO sny_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Wanure! Ane, meni hire ma'e itorai ape, ayei, wain sa'i arai. Sosu lowe ane ne apou te'esiya, ‘Siyere! Meni ape ayei ahi a'i meni. Aiwawe a'i le wain sa'i meremereyeyei. Le takis ma'aru ani siye lu werese mase onunamisiya. Le lu taune yo seni luwaru a'i ironamisiya ape, le lowe lo kaiyemo mo irosiya.’ Etiri werese, ane irosiya ape, etiri ape mo lai ane meni pefine a'i ne au atuatusiya.” Mt 9:14 ");
INSERT INTO sny_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Sosu a'i pe Jisas omo tere'e tere'e sahe wiyawi erasi pefine a'i irowe ape, lu taune tomu ne'ese yo seni luwaru a'i towafi lowe lo arunati ta'ame. Serai Jisas lowe werese ne ai marepi tote te'eye. ");
INSERT INTO sny_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Le lu taune ma'e ai marepi lo apou au te'e areiyeye, “Lu taune omo Korasin sahe irosiya ape, Weiyai! Lu taune omo Betsaida sahe irosiya ape, Weiyai! Wiyawi erasi pefine a'i ane omo fene lo sahe irowe ape, ane omo Tair, omo Saidon sahe aiwawe irorowa su, lowe witane se a'i yo seni luwaru a'i towafi lowe lo arunatirowa. Sosu lowe ipari tahe luwaru a'i ani asirowa su, lowe yesi yehe sahe onurowa. Ahowa, fene wiyawi erasi pefine a'i ano siyeye su, fene yo seni luwaru a'i fene lo me'iyeni ma'e atati arunati ta'ame. ");
INSERT INTO sny_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ahowa, ane fene ma'e au te'e areiyesiya. Wanure! Nowe ye'ewi se Owane Sitewi lai lu taune werese yo seni luwaru a'i lowe lo ani hese ereirowa su, le lu taune ma'e omo Saidon, omo Tair, iroteye ape, le fofowei erasi a'i au hese ereirowa. Fene yo seni luwaru a'i ironamisiya su, fene nowe ape se Owane Sitewi lai fene ma'e fofowei luwaru erasi a'i fene ma'e aurowa. Ais 23; Ese 26-28; Jol 3:4-8; Amo 1:9-10; Sek 9:2-4 ");
INSERT INTO sny_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ane lu taune omo Kaperneam sahe fene ma'e au te'e areiyesiya. Fene apou totesiya, ‘Nomo Owane Sitewi lo omo hire ma'e wirowa.’ Ahowa, fene werese papu itorirowa. Meni ta wiyawi erasi pefine a'i, apou ape aiwawe a'i ane omo fene lo sahe irowe ape, omo Sodom sahe irowe su, omo ape weriyei ironamitorowa. Ais 14:13-15; Stt 19:24-28 ");
INSERT INTO sny_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ahowa, ane fene ma'e au te'e areiyesiya. Wanure! Nowe ye'ewi se Owane Sitewi lai yo seni luwaru a'i au hese ereirowa su, lu taune omo Sodom iroteye ape, Owane Sitewi lai lowe ma'e fofowei oso a'i aurowa. Fene Owane Sitewi lai fofowei luwaru erasi a'i fene ma'e aurowa.” Mt 10:15; Lu 10:12 ");
INSERT INTO sny_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Nowe ape se Jisas Owane Sitewi tai lo ma'e au te'e tiyatiteye. Le apou eiye, “Tai ano, ane ne ma'e au te'e wisereyesiya. Ne omo hire ma'e irosiya ape, ne meni owane tutawe ne. Ne hi awei sato meni owane tutawe ne. Ne peri no lu taune marepi wisere a'i toteye ape fareyareye a'i irowe. Ahowa, ne peri no lu taune ma'e marepi eimane oso a'i wou au atuatu areiyeteye. 1 Ko 1:26-29 ");
INSERT INTO sny_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ei! Tai ano, ne peri no fareyareye a'i irowe su, sosu lu taune ma'e eimane lo marepi wou au te'e atuatu areiyeye su, ne marepi wisere erasi a'i totenamisiya. ");
INSERT INTO sny_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Tai ano, ne etiri werese ane ma'e au tepa'asiye. Ne a'i lai meni eime no so'oruwe tepa'asiye. Lu taune werese werese lowe ane so'oru ta'ama. Aiwawe a'i lu taune werese werese lai ne, tai ano, so'oru ta'ama. Ane a'i lai ne so'oruwe tepa'asiye. Ane marepi no umasitereme. Ane lu taune ma'e tai ano ne au atuatu areiyerowa su, lowe ne siye so'oruwerowa. Mt 28:18; Jo 3:35; 17:2; Fl 2:9; Jo 1:18; 10:15 ");
INSERT INTO sny_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Fene werese ane ma'e aiyere. Fene, tahe onota'ano a'i irosiya ape, fene, marepi orese a'i totenamisiya ape, fene ane ma'e aiyeyei su, ane marepi fetane a'i au irorowa. Jer 31:25 ");
INSERT INTO sny_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Fene wiyawi ano ta'anere. Yo seni ano siye etire. Sosu yo seni ano tote umasite. Ane marepi momotei a'i irosiya. Fene marepi ano ani tote tawesiyei su, sosu peri ano wanu tote umasiyei su, ane fene ma'e marepi fetane a'i au irorowa. ");
INSERT INTO sny_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Wiyawi ape ane fene ma'e aurowa ape, wiyawi ape orese se ta'ama. Fene wiyawi ape suterowa ape, fene fetane a'i suterowa.” 1 Jo 5:3 ");
INSERT INTO sny_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Sosu a'i pe Jisas peri tepa'asiye su, le lu disaipel lo aiwawe a'i nowe amou (Sabat) se ta'aneyei awei ta sahe tei uwei a'i iroteye. Lu disaipel lo lau mase iroteye su, lowe kewi so ani to'ote aniyewe, ene ateye. Lo 23:25 ");
INSERT INTO sny_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Sosu lu Farisi lowe kewi so ani to'ote aniyewe, ene ateye ape, siyeye su, lowe Jisas ma'e apou eiye, “Siyere! Lu disaipel no Moses lo yo peri arisisiya. Moses apou leseye, ‘Fene werese nowe amou (Sabat) se wiyawi werese owe ape ta'anere.’” Kis 20:10 ");
INSERT INTO sny_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ahowa, Jisas lowe ma'e itiya'u eiye. “Ya'ariyei meni owane nomo lo Devit, le lu feni mase lau mase iroteye su, le piye irowe awere? Fene piye Owane Sitewi lo one towe sahe siye te'eye awere? ");
INSERT INTO sny_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Wanure! Le lu feni lo mase Owane Sitewi lo wesi papu wiyewe, nau ta'ase amou a'i, Owane Sitewi ma'e auwe ape, aniyewe, ene ateye. Le lu feni lo mase, lowe nau ta'ase amou ape ene ateye su, le Owane Sitewi lo yo peri arisiye. Au hesere meni owane tutawe, le a'i lai nau ta'ase amou ape anamiteye. 1 Sml 21:1-6; Wkp 24:5-9 ");
INSERT INTO sny_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Owane Sitewi lo yo peri Moses leseye ape, fene yo peri lo sitewi wanu so'oru ta'ama. Owane Sitewi lo wesi lu owane lowe nowe amou (Sabat) arisinamiteye. Owane Sitewi lo nihe se yo seni lowe lo aseyaro a'i ne. Nam 28:9-10 ");
INSERT INTO sny_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ahowa, ane fene ma'e peri wiyeme a'i au te'esiya. Owane Sitewi lo wesi lo wiyawi erasi a'i ne. Au heseyei lu owane, lowe Owane Sitewi lo wesi Owane Sitewi lo nowe amou (Sabat) se fara'u wiyawi ta'anerowa. Etiri oso a'i ne. Ane a'i lai Owane Sitewi lo wesi ape ani araronamisiya. Ane Owane Sitewi lo nihe se erasi a'i ne. Mt 12:41-42 ");
INSERT INTO sny_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Owane Sitewi lo peri au te'e siye meni ta apou leseye, ‘Ane, Owane Sitewi Pefine a'i fene ma'e te'esiya, ane ayei fene lo ape au hesesiya ape, ane aniyei wou ta'ama. Ahowa, fene lu taune werese ma'e au seremareyere.’ Fene peri lo sitewi ape wanu tote umasisiya su, fene lu feni ano ne peri te'e narurowata. Owane Sitewi lo nihe se lowe yo seni luwaru a'i irote ta'ame. ");
INSERT INTO sny_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ane, meni hire ma'e itorai ape, ane nowe amou (Sabat) lo meni owane ne.” ");
INSERT INTO sny_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Sosu a'i pe Jisas awei ape arunatiyewe, ta'uweyei wesi lowe lo papu wiye. ");
INSERT INTO sny_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ta'uweyei wesi papu wiye su, le meni ta ereti nono'owe a'i se siyeye. Lu Farisi ape mo, lowe Jisas ma'e te'e toweriye, “Nowe amou (Sabat) se ne fara'u meni ape ereti nono'owe a'i au ta'ane fara'uweye awere? Piyete awere?” Lowe apou toteye. “Jisas meni ape lo ereti au ta'ane fara'uweyei su, nomo le etirowa.” Lu 14:3 ");
INSERT INTO sny_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Sosu Jisas lowe ma'e itiya'u eiye, “Ne fe sipsip ta'i ta iroteyei su, nowe amou (Sabat) se fe sipsip no awei fisiye yo papu itori winetaiyei su, ne nowe amou (Sabat) se fe sipsip no, awei fisiye yo papu itori winetaiye ape, fene aro aniyei awere? ");
INSERT INTO sny_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Fene marepi erasi totere! Meni ape fe sipsip ani ararowe. Ei! Owane Sitewi lo nowe wara'i a'i se fene wiyawi wisere a'i fara'u ani irorowa.” Lu 14:5 ");
INSERT INTO sny_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Sosu le meni ape ma'e apou eiye, “Meni! Ne ereti no tesi fareraiyere.” Meni ape Jisas lo peri wanuwe su, le ereti lo tesi fareraiyeye. Sosu ereti lo wisere a'i ereti tere'e lo wou a'i henerai. ");
INSERT INTO sny_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ahowa, lu Farisi etiri ape siyeye su, lowe wesi nowe ma'e fi. Lowe wesi tere'e ma'e te'e eti naneiyei ne fi. Lowe Jisas aine tera'eyei ne toteye. Jo 5:16 ");
INSERT INTO sny_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jisas lu Farisi lo marepi siye so'oruwe tepa'asiye. Serai le lu disaipel lo mase ta'uwe wesi nowe ma'e arunati. Lu taune tomu ne'ese Jisas mo'o umasiti. Le lu taune tomu ne'ese u tahe se ape au ta'ane fara'uweteye. ");
INSERT INTO sny_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Le lowe lo u tahe au ta'ane tepa'asiye su, le lowe ma'e eiye, “Fene ane ne lu taune werese ma'e owe ape au te'e fiyarire!” Mt 8:4; Mk 3:12 ");
INSERT INTO sny_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Tu naifa weriyei Owane Sitewi lo peri au te'e siye meni ta, iyape Aisaia, le apou leseye. Jisas peri ape au te'eye su, peri ape wiyeme a'i henerai tepa'asiye. ");
INSERT INTO sny_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Wanure! Wiyawi meni ano, ane le ariariye tepa'asiye. Ane le ne marepi erasi a'i tote wawesiyenamisiya. Ane marepi hepene lo marepi wisere a'i totenamisiya. Ane Hepene Wara'i a'i ano le ma'e eimawe arosawi. Le lu taune Moses lo yo peri umasi ta'ame ape ma'e apou au te'e areiyerowa. ‘Marepi ano wisere farere a'i ironamisiya.’ ");
INSERT INTO sny_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Le peri lo au te'e fiyarirowa su, le ai marepi se au te'erowata. Le peri erasi a'i yo mai sahe lu taune, peri ta wanuwei ne ta'uwerairowa ape, le peri erasi a'i owe ape uterowata. ");
INSERT INTO sny_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Lu taune tamo marepi lowe lo pere'e a'i irotorowa, menei lo lo'u pere'e aiwawe a'i. Le lowe ma'e au luwaruwerowata. Lu taune yehe mi oso wou a'i irotorowa su, le lowe lo mi ape aine noruwerowata. Meni ape aiyerowa su, le lai ferafereiyei lo lowe ma'e au atuatunamirowa. Sosu marepi wara'i a'i yo seni luwaru a'i ani fu aro po'uterowa. Serai yo seni luwaru a'i po'uterowa su, yo seni wara'i a'i ape lai weriyei weriyei ironamirowa. ");
INSERT INTO sny_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Lu taune omo omo werese peri lo wanu tote tawesi umasirowa su, meni ape lai lowe ma'e marepi hepene he'i a'i au ironamitorowa.” ");
INSERT INTO sny_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Sosu a'i pe Jisas peri tepa'asiye su, lu tamo meni ta sepei luwaru a'i papu iroteye ape, le ma'e henetai. Sepei luwaru a'i ape lai meni ape lo ahi au tomo'uteye, nihe au pokoweye. Jisas meni ape siyeye su, le ahi lo aneye, nihe lo petaneye. Serai meni ape fara'u etiri werese siye areiyeye. Sosu fara'u peri te'eteye. ");
INSERT INTO sny_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Lu taune werese meni ape siyeye su, lowe hepene se su'ariye. Sosu lowe apou te'eye, “Siyere! Meni ape Devit lo meni eime awere? Piyete awere?” ");
INSERT INTO sny_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ahowa, lu Farisi tamo meni ahi, nihe luwaru a'i ape wisere a'i wanuwe su, lowe apou areare te'eye, “Meni ape, Jisas, le sepei luwaru a'i Belsebul lo kairefiyeyei se au ta'ane sasarisawi.” Belsebul sepei luwaru a'i tutawe ne, iyape tere'e Satan. Mt 9:34; 10:25 ");
INSERT INTO sny_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jisas lu Farisi lo marepi siye so'oruwe tepa'asiye su, le lowe ma'e eiye, “Wanure! Ai atu siye lu weneri ponei erauwirowawe, ai atu siye lu tewi a'i tewi a'i lowe ai atu tiyatiyei su, lowe kairefiyeyei teirowata. Aiwawe a'i omo nepawe tewi a'i tewi a'i ponei sahe erauwiyei su, lowe ai atu tiyatiyei su, lowe kairefiyeyei se teirowata. Lu tewi ta ponei sahe tewi a'i tewi a'i erauwirowawe, lowe ai atu tiyatiyei su, lu tewi ape kairefiyeyei se teirowata. ");
INSERT INTO sny_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Serai sepei luwaru a'i, Satan, le sepei luwaru a'i ape au ani ta'ane sasarisawirowa su, wiyawi lo ape ani sasarirowa su, wiyawi lo ape kairefiyeyei se teirowata. ");
INSERT INTO sny_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Sosu ane Belsebul lo kairefi se sepei luwaru a'i au ani ta'ane sasarisawiyei su, ane fene ma'e peri ta ei towerisiya. Eiwerou lo kairefiyeyei se, lu tewi fene lo sepei luwaru a'i au ani ta'ane sasarisawirowa awere? Lowe lai peri fene lo, areareye ape, au te'e atuatu areiyesiya. ");
INSERT INTO sny_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ahowa, ane sepei luwaru a'i Owane Sitewi lo Hepene Wara'i a'i lo kairefiyeyei se au ani ta'ane sasarisawiyei su, fene apou siye so'oruwe tepa'asiye. nowe amou (Sabat) lu taune ma'e au noweinoweirowa ape, henerai tepa'asiye. Ap 10:38; 1 Jo 3:8 ");
INSERT INTO sny_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ta'arei irosiya meni ta meni kairefi a'i lo wesi ta ani apeti wiyei ne toteyei su, le tu wesi ape lo meni kairefi a'i ape wafei se ti tawesirowa. Meni ape wafei se ti tawesiyei su, le fara'u wesi lo ape ani apeti wirowawe, etiri werese lo ta'arei anirowa. ");
INSERT INTO sny_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Lu taune tamo peri ano arisiyei su, lowe ane umasirowata. Aiwawe a'i lu taune tamo wiyawi ano ani ta'ame su, lowe lu feni ano eimawe fiyarisawirowa. Mk 9:40; Lu 9:50 ");
INSERT INTO sny_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Serai ane fene ma'e au te'esiya. Yo seni luwaru werese a'i Owane Sitewi lai fara'u ani sasarirowa. Ahowa, yo seni luwaru ta'i a'i irosiya ape, Owane Sitewi lai ani sasarirowata. Yo seni luwaru a'i ape apou a'i fene Hepene Wara'i a'i lo ma'e owe ape te'e narute ape, Owane Sitewi lai meni ape lo yo seni luwaru a'i ape ani sasarirowata. Hi 6:4-6 ");
INSERT INTO sny_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Meni ta, menitani ta ane ma'e, meni hire ma'e itorai ape, te'e naruwei su, Owane Sitewi fara'u yo seni luwaru a'i lo ape ani sasarirowa. Ahowa, meni ta, menitani ta Owane Sitewi lo Hepene Wara'i a'i ma'e te'e naruwei su, Owane Sitewi lai yo seni luwaru a'i ape, ani sasarirowata. Ei, yo seni luwaru a'i ape mi mi pasi pasi weriyei weriyei ironamitorowa.” ");
INSERT INTO sny_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Iyu ta lo'u wisere a'i ta'eyei su, meni ta apou totesiya, ‘Iyu ape wisere a'i ne.’ Ahowa, iyu ta lo'u luwaru a'i ta'eyei su, meni ape apou totesiya, ‘Iyu ape luwaru a'i ne.’ Apou wou a'i meni ta, yo seni aseyaro irowei ape, fene apou totesiya, ‘Meni ape meni wisere a'i ne.’ Mt 7:16-20 ");
INSERT INTO sny_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Fene werese haru aimesi wou aiwawe a'i ne. Yo seni werese fene lo luwaru a'i tene. Fene piyene peri wara'i a'i au te'esiya awere? Peri werese fene lo wawero a'i tene! Fene peri ta au te'eyei su, peri ape marepi papu ma'e henerai. Mt 3:7; 15:18; Lu 3:7; 6:45 ");
INSERT INTO sny_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Meni wisere a'i ta marepi wisere a'i totenamirowa su, le yo seni wara'i a'i ironamirowa. Sosu aiwawe a'i meni luwaru a'i marepi luwaru a'i totenamirowa su, le yo seni luwaru a'i ironamirowa. ");
INSERT INTO sny_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ane fene ma'e au te'esiya. Lu taune tamo peri luwaru a'i au te'eteyei su, nowe Owane Sitewi yo seni werese au hese ereirowa ape, peri luwaru a'i lowe lo ape Owane Sitewi lai au hese eti ereirowa. ");
INSERT INTO sny_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Peri werese, fene au te'esiya ape, Owane Sitewi lai fene ma'e au hese etirowa. Lu taune tamo Owane Sitewi lai lowe ma'e lu taune aseyaro a'i au eirowa. Lu taune tere'e tamo Owane Sitewi lai lowe ma'e ani fu arorowa.” ");
INSERT INTO sny_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Sosu a'i pe lu Farisi, ani so'oruwe siye lu tamo Jisas ma'e itiya'u apou eiye, “Atuatu siye meni, Ne wiyawi erasi pefine a'i nomo ma'e fa au atuature. Wiyawi erasi ne atuatuwei ape, nomo siye so'oruwerowawe, ne Owane Sitewi wiyeme a'i ma'e itorai.” Mt 16:1; Lu 11:16; Jo 6:30 ");
INSERT INTO sny_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ahowa, Jisas lowe ma'e itiya'u eiye, “Ane fene werese ma'e wiyawi erasi pefine a'i au atuaturowata. Fene lu taune, yo seni luwaru a'i ironamisiya ape, tafa'e yo seni ironamisiya ape, fene wiyawi erasi pefine a'i siyeyei ne nehinamireme. Ei, ane etiri ta'i a'i fene ma'e au atuaturowa. Etiri ape Owane Sitewi lo peri au te'e siye meni Jona, le fene ma'e au atuatu tepa'asiye. Mt 16:4; Mk 8:12 ");
INSERT INTO sny_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Meni ape Jona, le nowe mi pasi hesi heta hare erasi a'i lo lire papu iroteye. Aiwawe a'i ane, meni hire ma'e itorai ape, ane awei papu wiyeme a'i ma'e nowe mi pasi hesi heta iroteyei. Jna 1:17 ");
INSERT INTO sny_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nowe ape se Owane Sitewi lai yo seni au hese ereirowa ape, lu taune werese omo Ninive sahe iroteye ape, lowe fene mase teirowawe, lowe aiwawe a'i yo seni luwaru a'i fene lo au hese ereirowa. Piyene awere? Meni Jona Owane Sitewi lo peri au te'e fiyariteye su, lowe yo seni luwaru werese a'i me'iyeni ma'e atati arunati. Fene werese yo seni luwaru a'i fene lo me'iyeni ma'e atati arunati ta'ame. Sosu ane, sato irosiya ape, ane meni Jona ani araro tepa'asiye. Jna 3:5 ");
INSERT INTO sny_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Fene werese peri ape wanu tepa'asiye. Menitani owane tutawe tu naifa weriyei omo tere'e tere'e iyape Siba, tamo a'i noweinoweiteye ape, menitani ape Israel lo meni owane tutawe Solomon ma'e peri lo wanuwei ne fai. Nowe ape Owane Sitewi lai yo seni au hese ereirowa ape, menitani ape fene mase teirowawe. Le yo seni luwaru a'i fene lo au hese ereirowa, le fene werese yehe omo ma'e eimawe arosawirowa. Ane, sato irosiya ape, meni owane Solomon hi ani araro tepa'asiye. 1 Kin 10:1-10 ");
INSERT INTO sny_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Sosu sepei luwaru a'i meni ta nowe ma'e arunatiyei su, le awei pani foro'o a'i nehiyei ne uweitiye. Le onu fetaneyereme. Ahowa, le onu fetaneyerowata. ");
INSERT INTO sny_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Sosu sepei luwaru a'i ape apou toteye, ‘Ane meni ano ape si tame wiyei ne totesiya.’ Sosu sepei luwaru a'i ape meni ape si tame fi. Meni ape ma'e si tame wiyei ne fai su, le lirewawe lo ape wisere a'i iroteye ape siyeye. Etiri tere'e tamo meni ape ma'e wi ta'ame. ");
INSERT INTO sny_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Sosu sepei luwaru a'i ape meni ape arunatiyewe, sepei ape le pinasu lo tamo nehiyei ne fi. Le sepei pinasu luwaru a'i ereti feni werese feni hesi a'i meni ape papu hene wiye. Sosu meni ape lo lirewawe papu weriyei ironamiteye. Sepei luwaru a'i ape mo lowe lai meni ape au ani luwaruweteye. Serai meni ape yo seni luwaru werese werese a'i ironamiteye. Tu meni ape yo seni luwaru oso a'i iroteye.” Sosu aiwawe a'i lu taune pereye nowe eite se, yo seni luwaru erasi a'i marepi hepene lowe lo au luwaruwerowa. 2 Pi 2:20 ");
INSERT INTO sny_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jisas lu taune ma'e au te'e atuatuteye su, Jisas lo mai, pa'ise lu tamo, lowe wesi nowe ma'e le se peri ta au te'eyei ne fai. ");
INSERT INTO sny_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","{Sosu meni ta Jisas ma'e apou eiye, “Wanure! Mai no pa'ise no wesi nowe sato irosiya. Peri ta ne ma'e au te'eyei ne fai.”} ");
INSERT INTO sny_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ahowa, Jisas meni ape ma'e itiya'u eiye, “Mai ano, pa'ise ano. Eiwerai awere?” ");
INSERT INTO sny_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Sosu Jisas ereti lo lu feni ma'e tesi fareraiyesawi, apou eiye, “Siyere! Lu taune ape mo lowe mai ano, pa'ise ano sato irosiya. ");
INSERT INTO sny_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Tai ano, omo hire ma'e ironamisiya ape, lu taune tamo lai tai ano lo marepi tote umasi irorowa su, lowe mai ano, einei ano, lowe pa'ise ano ne.” Ro 8:29 ");
INSERT INTO sny_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nowe ape se Jisas wesi ape arunatiyewe, hare ite yo'u tewiye sahe onuteye. ");
INSERT INTO sny_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Lu taune tomu ne'ese le ma'e peri lo wanuwei ne ta'uwerai. Jisas lu taune werese siyeye su, le lu disaipel lo ape mase wai papu arowatowe. Le wai pihatu sahe onuwe. Lu taune werese hare ite yo'u tewiye sahe teiteye. Lu 5:1-3 ");
INSERT INTO sny_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Le lowe ma'e peri anowe tomu ne'ese au te'e atuatuteye. Le lowe ma'e apou au te'eye, “Wanure! Meni ta ta'aneyei awei lo ma'e kewi so sameyei ne fi. ");
INSERT INTO sny_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Le kewi so ta'aneyei awei sahe sameye fiyariye su, kewi so tamo yo mai yo'u tewiye sahe wiyeineye. Irowe tamo me'iye faiyewe, kewi so ape so aye. ");
INSERT INTO sny_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Kewi so tere'e tamo ta'aneyei awei tapiye a'i ape sahe wiyeineye. Ta'aneyei awei ape peperi oso a'i iroteye. Serai kewi so ape saro ahe witane a'i perati wirai. Kewi so ape napi awei papu ito ta'ame. ");
INSERT INTO sny_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Poweiye wirai su, kewi so ape lo wamu, poweiye ai lai kewi so ape lo wamu ti haroharoweye. Kewi so ape poweiye lai ti haroharoweye su, napi lo awei papu ito ta'ame. Serai kewi so ape haroharowe foro'oweye. ");
INSERT INTO sny_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Kewi so tere'e tamo wafei ni'ari a'i ape sahe wiyeineye. Kewi so ape wafei ni'ari a'i ape mase perati wirai. Wafei ni'ari a'i ape lai kewi so ape ani napetu tawesiye. Serai kewi wamu ape erasiye ta'ame. ");
INSERT INTO sny_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Kewi so tamo awei wisere a'i sahe wiyeineye ape, lowe mo wisere a'i perati wirai. Nowe me'iye ta se kewi ape mo so tomu ne'ese (100) ta'eye. Kewi ape tamo so erasi, (60) ta'eye. Kewi ape tamo so oso a'i, 30, ta'eye. ");
INSERT INTO sny_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Lu taune tamo apaniye se fene irosiya ape peri ape fu wanu etite!” ");
INSERT INTO sny_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Sosu a'i pe Jisas lo lu disaipel le ma'e te'e toweriyei ne fai. Lowe apou te'e toweriye, “Piyene ne lu taune ma'e peri anowe ape au te'esiya awere?” ");
INSERT INTO sny_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Sosu le lowe ma'e itiya'u eiye, “Owane Sitewi lai marepi werese lo peri fareyare a'i fene ma'e au atuatu areiyeyei ne totesiya. Owane Sitewi lo marepi sitewi lo ape lu taune ape ma'e au te'e areiye se ta'ame. ");
INSERT INTO sny_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Meni ta apou toteyei su, ‘Ane Owane Sitewi lo peri wanu tote umasirowa.’ Owane Sitewi lai le ma'e peri tere'e tamo au te'e areiyerowa. Meni ape lo so'oruweyei erasi a'i henerairowa. Ahowa, meni ta Owane Sitewi lo peri arisiyei su, Owane Sitewi lai meni ape lo so'oruweyei lo ape si ani sasarirowa. Mt 25:29; Mk 4:25; Lu 8:18; 19:26 ");
INSERT INTO sny_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Serai ane peri anowe ape lowe ma'e au te'e fiyarisiya. Ane lowe ma'e peri anowe au te'esiya su, lowe peri a'i wanusiya. Lowe peri ape lo eti wanu so'oruwerowata. Lowe Owane Sitewi lo peri sitewi siye so'oruwerowata. ");
INSERT INTO sny_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Fene lu taune tewi a'i ne totere. Tu naifa weriyei Owane Sitewi lo peri au te'e siye meni, Aisaia apou leseye, ‘Fene peri ape wanuwei su, ahowa, fene peri lo sitewi ani so'oru ta'ama. Fene peri anowe siyeyei su, ahowa, fene marepi sitewi ape tote areiyerowata. Jo 12:40 ");
INSERT INTO sny_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Lu taune ape lo marepi sa'i moro wou a'i iroteye. Apaniye lowe lo te'ene tawesiye. Nihe lowe lo niso'uwe tawesiye. Lowe nihe se siyeyei su, lowe, etiri siyeyei ape, so'oru ta'ama. Lowe peri ta apaniye lowe lo se wanuwei su, lowe, peri ape wanuwei ape, so'oru ta'ama. Lowe Owane Sitewi lo marepi tote umasi ta'ame su, serai yo seni luwaru a'i me'iyeni ma'e atati arunati ta'ame su, ane lowe ma'e ferafereiyei au irorowata.’ Peri lo ape wiyeme a'i henerai tepa'asiye.” ");
INSERT INTO sny_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Sosu Jisas lu disaipel lo ma'e tame eiye, “Ahowa, fene Owane Sitewi lo marepi siye so'oruwe tepa'asiye. Fene Owane Sitewi lo peri wanu tote umasi tepa'asiye. Serai Owane Sitewi lai fene ma'e marepi hepene wisere a'i auwe. Lu 10:23-24 ");
INSERT INTO sny_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ane peri wiyeme a'i fene ma'e au te'esiya. Wanure! Lu tomu ne'ese, Owane Sitewi lo peri au te'e siye lu tomu ne'ese, lu yo seni aseyaro a'i ironamiteye ape, lowe etiri werese ape, fene siye tepa'asiye ape, siyereme. Ahowa, lowe etiri ape siye ta'ame. Aiwawe lowe peri werese ape, fene wanu tepa'asiye ape, wanureme. Ahowa, lowe peri ape wanu ta'ame. ");
INSERT INTO sny_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Fene peri anowe lo sitewi eite wanure. ");
INSERT INTO sny_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Meni ta kewi so ta'aneyei awei sahe sameyei ne fi. Kewi so tewi a'i yo mai tewiye sahe wiyeineye. Peri ape lo sitewi apou a'i te'esiya. Meni ta, menitani ta Owane Sitewi lo marepi lo peri wanuwe su, sosu lowe peri ape lo sitewi so'oru ta'ama su, sepei luwaru a'i tutawe lai le ma'e Owane Sitewi lo peri, marepi lowe lo sahe iroteye ape, tote aniye aiti. ");
INSERT INTO sny_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Kewi so tewi a'i awei tapiye a'i ape sahe wiyeineye. Peri ape lo sitewi apou a'i te'esiya. Meni ape, Owane Sitewi lo peri wanuwe su, witane a'i le marepi wisere a'i tote nine'iye. ");
INSERT INTO sny_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Meni ape marepi kairefi se ta'ama. Ahowa, nowe oso a'i su, le Owane Sitewi lo peri arunatiyei. Lu tamo Owane Sitewi lo peri ani fu arowei ne toteyei su, lowe meni ape ma'e au luwaruweyei. Serai meni ape Owane Sitewi lo peri witane a'i arunatiyei. ");
INSERT INTO sny_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Kewi so tamo wafei ni'ari se ape ponei sahe wiyeineye. Peri ape lo sitewi apou a'i te'esiya. Meni ape Owane Sitewi lo peri wanuwe su, awei lo etiri luwaru a'i werese meni ape lo marepi papu wiye. Awei lo etiri orese werese, ma'aru lo marepi, marepi arearesiya ape, papu wiyewe, Owane Sitewi lo peri ani ti terate tawesinamiteyei. Serai meni ape lo yo seni luwaru a'i henerai. Lu 12:16-21; 1 Ti 6:9-10,17 ");
INSERT INTO sny_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Kewi so tamo awei wisere a'i sahe wiyeineye. Peri ape lo sitewi apou a'i te'esiya. Meni ape Owane Sitewi lo peri wanuwe su, le Owane Sitewi lo peri lo eti wanu so'oruwe tepa'asiye. Meni ape lo marepi kairefi a'i henerai. Serai le Owane Sitewi lo wiyawi erasi poto a'i (100) au ta'aneye. Lu tere'e tamo Owane Sitewi lo wiyawi erasi (60) au ta'aneye. Lu tere'e tamo Owane Sitewi lo wiyawi oso a'i (30) au ta'aneye.” ");
INSERT INTO sny_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Sosu a'i pe Jisas lowe ma'e peri anowe ta au te'eye, le apou te'eye, “Nowe ape se Owane Sitewi lu taune au noweinoweirowa ape apou wou aiwawe a'i te'esiya. Meni ta ta'aneyei awei ma'e kewi so wisere a'i yehe sameyei ne fi. ");
INSERT INTO sny_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Pasi su lu werese, nihe teiteye ape, airame tamo ta'aneyei awei lo ma'e au luwaruweyei ne toteyewe fai. Serai lowe wafei tohu ni'ari a'i ape lo so ta'aneyei awei sahe ponei ma'e ani teroso fiyari arowe. Wafei tohu lo so ani teroso fiyarisawi su, lowe eresene a'i fi. ");
INSERT INTO sny_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Nowe me'iye su, kewi so lo wamu wafei tohu lo wamu aiwawe a'i perati wirai. ");
INSERT INTO sny_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Sosu wiyawi yahowa'i ani siye lu tamo lowe meni owane lowe lo ma'e eirai, ‘Owane ne kewi so wisere a'i ta'aneyei awei sahe ani teroso fiyarisawi awere? Piyene wafei tohu lo wamu luwaru a'i aiwawe a'i wirai awere?’ ");
INSERT INTO sny_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Sosu le lowe ma'e itiya'u eiye, ‘Siyere! Airame tamo wafei tohu so ta'aneyei awei ano sahe ani teroso fiyarisawi.’ Wiyawi yahowa'i ani siye lu mo le ma'e apou te'e toweriye, ‘Nomo fara'u wafei tohu ani tahe ani fusawiyei awere?’ ");
INSERT INTO sny_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","30","Meni owane ape lowe ma'e itiya'u eiye, ‘Ahowa, lowesi aiwawe a'i fa irote. Fene wafei tohu lo wamu ani tahe anirowata. Fene wafei tohu lo wamu ape ani tahe aniyei su, fene kewi so lo wamu mase ani tahe aniyei. Nowe me'iye su, ane wiyawi yahowa'i ani siye lu ano ma'e apou te'eyei, fene tu wafei tohu lo lo'u ani tahe anirowawe, wafei se ti tawesirowawe, yehe ma'e fu arore. Yehe ma'e fu arowei su, fene kewi so foro'o a'i wesi ano papu ani fu ta'uwere.’” ");
INSERT INTO sny_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Sosu a'i pe Jisas peri anowe tere'e au te'eteye. Le apou eiye, “Nowe ape se Owane Sitewi lu taune, au noweinoweirowa ape, saiyoho so apou wou a'i ne. Meni ta saiyoho so ta'aneyei awei lo ape sahe sameyei ne fi. ");
INSERT INTO sny_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Saiyoho so ape so oso pefine a'i ne. So tere'e tere'e erasi a'i. Saiyoho so lo wamu peratiyei su, lo'owe erasi a'i henerairowa. Me ta wou a'i ne. Saiyoho lo'owe erasi ape haiye werese ani ararowe. Saiyoho lo lo'owe erasi a'i heneraiyei su, irowe hire ma'e sinesiya ape, lai saiyoho nei sahe uri lowe lo ta'aneyei.” ");
INSERT INTO sny_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Sosu a'i pe Jisas lowe ma'e peri anowe tere'e ta au te'eye. Le apou eiye, “Nowe ape se Owane Sitewi lu taune, au noweinoweirowa ape, apou wou a'i ne. Nau ti meiyei irowe ape, menitani ta siye fi nau papu fuwe. Me'iye su, siye fi, nau werese fiyariyewe. Serai nau erasi a'i ti meiyei.” ");
INSERT INTO sny_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jisas peri anowe tamo lu taune tomu ne'ese ma'e au te'eteye. Le lowe ma'e au te'e fiyariteye su, le peri amerame a'i au te'e areiye ta'ame. Ahowa, le lowe ma'e peri anowe a'i au te'e fiyariteye. ");
INSERT INTO sny_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Tu naifa weriyei Owane Sitewi lo peri au te'e siye meni ta apou leseye. Peri ape le leseye ape, wiyeme a'i henerai tepa'asiye. Le apou leseye, “Ane lu taune ma'e au te'e fiyarirowa su, ane peri anowe a'i au te'erowa. Etiri werese tu naifa weriyei fareyareye iroteye ape, pereye ane lu taune ma'e au te'e areiyerowa.” ");
INSERT INTO sny_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Sosu a'i pe Jisas lu taune werese arunatiyewe, le lu disaipel lo mase wesi papu wiye. Wesi papu wiye su, lu disaipel lo le ma'e apou te'e toweriyei ne fai, “Ne wafei tohu lo peri sitewi nomo ma'e fara'u au te'e areiyere.” ");
INSERT INTO sny_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Sosu Jisas lowe ma'e itiya'u eiye, “Meni ape kewi so ta'aneyei awei sahe sameyei ne fi ape, le, ane, meni hire ma'e itorai ne. ");
INSERT INTO sny_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ta'aneyei awei ape wou a'i lu taune omo omo werese sahe irosiya. Kewi so wisere a'i ape apou wou a'i, lu taune werese Owane Sitewi lo peri wanu tote tawesi umasisiya. Wafei tohu so ape apou wou a'i ne. Lowe lu taune werese sepei luwaru pefine a'i lo peri wanu umasisiya. ");
INSERT INTO sny_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Meni ape wafei tohu so ta'aneyei awei sahe pasi a'i se ani teroso fiyariye ape, le sepei luwaru a'i iyape Satan. Nowe ape se wiyawi yahowa'i ani siye lu lo'u ani une aniyei ape, nowe ape se nowe ye'ewi, wiyawi yahowa'i ani siye lu apou wou a'i, Owane Sitewi lo ipari wisere a'i (ensel) ne. ");
INSERT INTO sny_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Serai wiyawi yahowa'i ani siye lu, lowe wafei tohu aine tou ta'uwe anirowawe, yehe ma'e ani fu arosawirowa. Apou wou a'i, nowe ye'ewi se, Owane Sitewi lo ipari wisere a'i, lowe lu taune werese sepei luwaru a'i Satan lo peri wanu umasisiya ape, lowe lu tewi ape mo ma'e eimawesawirowa. Jo 15:6 ");
INSERT INTO sny_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nowe ye'ewi se ane, meni hire ma'e itorai ape, ane Owane Sitewi lo ipari wisere a'i omo omo werese ma'e lu taune werese yo seni luwaru a'i ironamiteye ape, ane lowe lu tewi ape mo ta'uweyei ne eimawesairowa. Le etiri werese lu taune yo seni luwaru a'i irowei ne ani ta'uwe sasarisawirowa. Mt 24:31; 25:31; Mk 13:27 ");
INSERT INTO sny_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Owane Sitewi lo ipari wisere a'i (ensel) lai lowe ma'e ani fu arosawirowa. Yehe omo sahe lu taune werese luwei erasi irorowa. Fofowei erasi yehe omo ma'e irorowa. Serai pi lowe lo ta'ani tawesirowa. Mt 8:12 ");
INSERT INTO sny_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Sosu lu taune werese yo seni aseyaro a'i ironamisiya ape, lowe Owane Sitewi tai lowe lo omo sahe mitaiyeyei erasi mase iro fiyarinamitorowa. Poweiye mi wou a'i tewi mitaiye fiyarinamitorowa. Lu taune werese apaniye se fene peri ape wanu tawesire. Dan 12:3 ");
INSERT INTO sny_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Nowe ape se Owane Sitewi lu taune, au noweinoweirowa ape, apou wou a'i. Meni ta ta'aneyei awei sahe ma'aru pa'are nehiyewe, siyeye. Meni tere'e tu naifa weriyei ma'aru pa'are awei fisiye yo papu fu fareyareye. Sosu meni ape nehiyewe, siyeye su, marepi lo erasi nine'iye. Le wesi lo ma'e si tame fiyewe, etiri lo werese lu lai eteye. Ma'aru werese ani ta'uweye su, le awei tewi ape eteye.” ");
INSERT INTO sny_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Sosu a'i pe Jisas peri anowe tere'e au te'eye. Le apou eiye, “Ane fene ma'e tame eisiya. Nowe ape se Owane Sitewi lu taune, au noweinoweirowa ape, apou a'i. Meni ta ni'aripe wisere erasi a'i eteyei ne toteye. Le omo omo werese sahe ni'aripe ape siye nehiteye. Nowe me'iye se le ni'aripe wisere erasi a'i siyeye. ");
INSERT INTO sny_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Le ni'aripe erasi wisere a'i siyeye su, le etiri lo werese lu lai eteye. Ma'aru werese ani ta'uweye su, le ni'aripe ape eteye.” ");
INSERT INTO sny_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Sosu a'i pe Jisas peri anowe tere'e apou au te'eye. Le apou eiye, “Nowe ape se Owane Sitewi lu taune, au noweinoweirowa ape, apou a'i. Meni ta hare honaiye sa'i papu fu arowe. Le hare honaiye si tame tore ani wirai su, hare apou ape tomu ne'ese aiwawe aniye. ");
INSERT INTO sny_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Hare honaiye teme'eriyerowa su, le sa'i tewiye ma'e tore ani wirairowa. Hare werese ape le lai ani fu ereirowa. Hare tewi wisere a'i le lowe ani fu ta'uwerowa. Hare tewi luwaru a'i werese ape, le lowe werese ipo sahe ani fu eresawirowa.” ");
INSERT INTO sny_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Sosu le peri anowe lo sitewi au te'eye. Le apou eiye, “Nowe ye'ewi se, Owane Sitewi lo ipari wisere a'i (ensel) hi awei ma'e itorairowawe, lu taune werese werese ani ta'uwerowa. ");
INSERT INTO sny_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Lowe lu taune werese yo seni luwaru a'i ironamisiya ape, yehe omo ma'e ani fu arorowa. Lu taune werese ape mo luwei erasi irorowa. Lowe fofowei erasi teriterowawe, sosu pi lowe lo ta'ani tawesirowa.” Mt 13:42; Lu 13:28 ");
INSERT INTO sny_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Sosu Jisas lu disaipel lo ma'e apou ei toweriye, “Peri werese ano fene so'oruwesiya awere?” Lowe le ma'e itiya'u eiye, “Ei, nomo peri sitewi werese so'oruwe tepa'asiye.” ");
INSERT INTO sny_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Sosu le lowe ma'e eiye, “Owane Sitewi lo yo peri ani so'oruwe siye meni ta, le Owane Sitewi lo peri wanu tote tawesiyei su, le apou wou a'i ne. Meni owane ta etiri tomu ne'ese ta'uwe aniye. Le wesi lo papu wiyei su, le etiri weriyei ape aiwawe etiri he'i a'i ani aitairowa.” ");
INSERT INTO sny_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Sosu a'i pe Jisas peri anowe werese au te'e tepa'asiye su, le lu disaipel lo mase wesi arunatiyewe, fi. ");
INSERT INTO sny_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Le lu disaipel lo mase omo topo lo ma'e heneri. Le ta'uweyei wesi papu wiyewe, Owane Sitewi lo peri au te'e fiyariye. Lu taune tomu ne'ese peri lo ape wanuwe su, lowe meni ape ne hepene se su'ariye. Lowe apou te'e tiyatiteye. “So'oruweyei lo ape eiwerou ma'e aniye awere? Kairefiyeyei lo ape eiwerou ma'e aniye awere? Piye kairefiyeyei se le wiyawi erasi pefine a'i eite irosiya awere? Jo 7:15 ");
INSERT INTO sny_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Meni ape wesi ta'ane siye meni lo meni eime awere? Mai ape lo iyape Maria awere? Pa'ise werese mo lo iyape Jems, Josep, Saimon, sosu Judas, wiyeme awere? Jo 6:42 ");
INSERT INTO sny_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Einei lo mo lowe nomo mase irosiya awere? Meni eiwerou ma'e kairefiyeyei lo aniye awere?” ");
INSERT INTO sny_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Sosu lowe ai marepi le ne totenamiteye. Lowe le ne me'iyeni ma'e atati aruwe. Ahowa, Jisas lowe ma'e itiya'u eiye, “Owane Sitewi lo peri au te'e siye lu werese ape ne, lu taune werese lai lowe ma'e iyape erasi a'i ei ani arowesiya. Ahowa, lu taune omo sitewi lowe lo sahe, lowe Owane Sitewi lo peri au te'e siye lu werese iyape lowe lo ani fu ararosiya. Lu tewi lowe lo aiwawe a'i lowe Owane Sitewi lo peri au te'e siye lu lo iyape ani fu ararosiya.” Jo 4:44 ");
INSERT INTO sny_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Serai Jisas omo sitewi topo lo sahe wiyawi erasi pefine a'i ta'anerowata. Piyene awere? Lowe le ne wanu tote tawesi se ta'ame. ");
INSERT INTO sny_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Nowe ape se pani Galili pani tewi hesiyo hesiyo iroteye. Meni owane tutawe, iyape Herot, le pani tewi ta'i a'i au noweinoweiteye. Le peri heneruwe ape Jisas lo wanuwe su, ");
INSERT INTO sny_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Le wiyawi yahowa'i siye lu ma'e apou eiye, “Meni ape Jon sa'i au hu siye meni. Ane ai lu tamo Jon lo pere'i mato aine tousawiyei ne eimawesawi. Le fisiye yo sahe si tame sineye. Meni ape, temeniyeye ape, si tame sineye su, Owane Sitewi lai le ma'e kairefiyeyei auwe. Serai le wiyawi erasi pefine a'i kairefiyeyei se fara'u ta'anesiya.” ");
INSERT INTO sny_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Tu naifa meni owane Herot lai ai lu tamo Jon ereti aniteyei ne eimawesawiyewe, ereti lowe wafei se ti tawesiyewe, kalabus wesi ma'e eimawesawi. Piyene awere? Jon le ma'e apou eiye, “Ne pa'ise no Filip lo tani Herotias naituwe. Yo seni no luwaru a'i ne.” Serai Herot ai lu tamo Jon ereti aniteyei ne eimawesawiyewe, kalabus wesi ma'e hene ani fu arowe. Wkp 18:16; 20:21; Lu 13:19-20 ");
INSERT INTO sny_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Jon peri ape le ma'e te'eye su, Herot ai marepi erasi le ne toteye. Le Jon aine tera'eyei ne toteye. Ahowa, le lu taune werese ne atoweiye iroteye. Lu taune werese Jon ne apou toteye. “Jon le Owane Sitewi lo peri au te'e siye meni pefine a'i ne.” Mt 21:26 ");
INSERT INTO sny_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Nowe me'iye ta se Herot lu tamo ene ayei ne ei aniye. Nowe ape se tu naifa Herot lo mai le auteiye. Serai lowe Herot lo wesi ma'e faiyewe, nowe ape toteteye. Sosu lowe metei sahe onuwe su, Herotias lo eime taune lowe ma'e uma'iye irowe. Herot menitani ape siyeye su, le marepi erasi a'i tote nine'iye. ");
INSERT INTO sny_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Le menitani ape siyeye su, Herot le ma'e peri te'e naneiteye, le apou eiye, “Ne piye etiri ta ne ane ma'e ei toweriyei su, ane ne ma'e fara'u aurowa.” ");
INSERT INTO sny_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Menitani ape mai lo ma'e ei toweriyei ne fi. Le apou ei toweriye. “Etiri ta, ane piye ei toweriyei awere?” Sosu mai le ma'e apou eiye, “Ne Herot ma'e ei towerire, ‘Ne ane ma'e apou aure, Jon lo mato wahu papu aita. Ane etiri ape anireme.’” ");
INSERT INTO sny_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Sosu Herot peri ape wanuwe su, le marepi orese erasi a'i toteye. Sosu toteye, “Ane menitani ape peri te'e naneiye, lu werese metei sahe onuteye ape lowe peri te'e naneiyei ano wanuwe su, ane peri ano fu umasirowa. Ane nihe lowe lo se neritase a'i irorowata.” Serai le ai atu siye lu tamo ma'e eiye, “Fene Jon sa'i au hu siye meni aine tera'erirowawe, mato lo ane ma'e wahu papu aita.” ");
INSERT INTO sny_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Serai le ai atu siye lu Jon sa'i au hu siye meni lo pere'i aine touwei ne eimawesawi. ");
INSERT INTO sny_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Lowe Jon lo pere'i aine tou tepa'asiye su, lowe mato lo wahu sahe fuwewe, menitani wati'are ape ma'e auri. Sosu wati'are ape Jon lo mato mai lo ma'e auri. Serai mai lo apou eiye, “Wisere a'i tene! Ane pereye etiri eite siye so'oruwesiya. Jon sa'i au hu siye meni temeniyeye.” ");
INSERT INTO sny_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Jon lo lu feni peri ape wanuwe su, lowe Jon lo tahe pa'are fisiye yo papu fuwe. Sosu lowe Jisas ma'e peri heneruwe ape au te'eri. ");
INSERT INTO sny_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Sosu a'i pe Jisas peri heneruwe ape wanuwe su, le lu taune werese arunatiyewe, wai papu arowatowe. Le lu disaipel lo mase pani lu ta'ame ape ma'e fi. Lu taune werese Jisas wai sahe siyesawi su, lowe omo towafi lowe lo arunatiyewe, yo mai me'iye atati umasiti. ");
INSERT INTO sny_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Sosu Jisas sa'i tewiye sahe wai furi su, le lu taune werese siyeye. Le lowe werese marepi au tote ewiteye. Sosu le lu taune lo u tahe werese se ape au ta'ane fara'uweye. ");
INSERT INTO sny_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nowe neriwei su, Jisas lo lu disaipel le ma'e au te'eyei ne fai. Lowe le ma'e te'eye, “Meni Owane, pani eite ariye a'i ne. Nowe pasi ataheyewa. Ne lu taune werese omo tere'e ma'e eimawesawire! Serai lowe fara'u ayei ta omo nepawe eteyei ne iyei.” ");
INSERT INTO sny_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ahowa, Jisas lowe ma'e itiya'u eiye, “Lowe omo lowe lo ma'e owe ape eimawe fiyarisawire. Fene ayei tamo lowe werese ma'e au isafiye nonere.” ");
INSERT INTO sny_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Sosu lowe le ma'e eiye, “Nomo nau ta'ase ereti feni werese irosiya, hare hesi a'i.” ");
INSERT INTO sny_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Sosu le lowe ma'e eiye, “Nau ta'ase werese, hare hesi ane ausa!” ");
INSERT INTO sny_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Sosu le lu taune werese ma'e eiye, “Fene senarepe sahe onure.” Le nau ta'ase ereti feni werese hare hesi ereti aniteyewe, Owane Sitewi lo omo hire ma'e nihe hire siye aroweyewe, Owane Sitewi ma'e au te'e wisereyeye. Le nau ta'ase tewi pa tewi a'i towesiye. Le lu disaipel lo ma'e auwe. Sosu eiye, “Fene lu taune werese ma'e au nonetire.” Lowe lu taune werese ma'e au nonoti, nonetai tepa'asiye. Mt 15:35-39; Mk 8:6-10 ");
INSERT INTO sny_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Lu taune werese nau ta'ase, hare ene a tepa'asiye su, lire lowe lo teme'eriyeye. Lowe marepi wisere a'i toteye. Jisas lo lu disaipel nau ta'ase tewi a'i hare tewi a'i werese ipi sahe ani asiye. Lowe ipi ereti feni hesi werese lowe hesi a'i ipi papu ani asi teme'eriyeye. ");
INSERT INTO sny_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Lu tomu ne'ese (5,000) nau ta'ase ene ateye. Taune eimane tomu ne'ese aiwawe a'i ene ateye. ");
INSERT INTO sny_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Sosu a'i pe Jisas pereye a'i lu disaipel lo ma'e apou eiye, “Fene wai papu aratore. Hare ite feni eire ma'e tonerire. Ane lu taune werese omo towafi lowe lo ma'e eimawesawiyei. Sosu ane fene mo'o umasiyei.” ");
INSERT INTO sny_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Le lu taune werese eimawesawi su, le woto a'i omo hire ma'e Owane Sitewi ma'e au te'e tiyatiyei ne yaneye. Nowe neriwei su, le woto a'i saro iroteye. Lu 6:12; 9:28 ");
INSERT INTO sny_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Lu disaipel lo hare ite wai iyatutinauwe, iyatutinauwe ponei sahe heneri. Lowe hare ite ponei sahe heneri su, fiyaru, sa'i ei erasi a'i henerai. Sa'i ei wai lowe lo ma'e ani awetu awetowe. Fiyaru erasi wai lo pihatu aine torutorowe. ");
INSERT INTO sny_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Nowe mitaiyeye su, Jisas hare ite hire awesetaiteye. Sosu le lu disaipel lo ma'e heneri. ");
INSERT INTO sny_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Jisas lo lu disaipel meni ape, sa'i hire awesetaiteye ape, siyeye su, lowe atoweiye erasi irowe apou uteye, “Sawi amou! Sepei luwaru a'i nomo ma'e fai.” Lu 24:37 ");
INSERT INTO sny_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ahowa, pereye a'i Jisas lowe ma'e apou eiye, “Atoweiye sawa! Marepi fene lo momotei a'i irote. Ane lai ne.” ");
INSERT INTO sny_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Sosu Pita le ma'e itiya'u apou eiye, “Meni Owane, ne meni ape lai su, ne ane ei anire. Serai ane sa'i hire ma'e ne ma'e awesetairowa.” ");
INSERT INTO sny_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Sosu Jisas Pita ma'e eiye, “Ne aiya!” Pita peri ape wanuwe su, le wai ape arunatiyewe, sa'i hire ma'e fi, Jisas ma'e heneri. ");
INSERT INTO sny_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ahowa, Pita fiyaru erasi siyeye su, le atoweiye erasi irowe. Le sa'i papu wiye. Sosu le Jisas ma'e apou uteye, “Meni Owane, ne ane mase pati anire.” ");
INSERT INTO sny_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Sosu Jisas ereti lo tesiye su, le Pita ereti lo se aniteye. Le ma'e eiye, “Tote tawesiyei no oso a'i ne. Piyene ne marepi hesi a'i totesiya awere?” Mt 8:26; Mk 4:39 ");
INSERT INTO sny_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Lowesi wai papu arowatowe su, fiyaru werese titaneye. ");
INSERT INTO sny_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Lu werese wai sahe iroteye ape, lowe le ma'e au nine'iteye. Sosu le ma'e eiye, “Wiyeme a'i ne Owane Sitewi lo meni eime pefine a'i tene!” ");
INSERT INTO sny_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Sosu a'i pe lowe wai iyatutinauwe, iyatutinauwe pani Genesaret lo wai senitewi sahe furi. ");
INSERT INTO sny_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Lu tamo Jisas siye so'oruweye su, lowe Jisas omo omo lowe lo fai ape ne au te'e fiyariteye. Lu taune tomu ne'ese lai lu taune u tahe se Jisas ma'e au ta'ane fara'uweyei ne henetai. ");
INSERT INTO sny_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Lu taune werese u tahe se ape lowe le ma'e kairefiyeyei se apou te'e toweriye, “Nomo ipari tahe weniwe no fara'u isawe hetesiyeyei awere? Sosu lu taune werese ipari tahe weniwe isawe hetesiteye su, u tahe lowe lo fara'u henerai.” Lu taune ipari tahe weniwe lo isawe hetesiyeye su, u tahe lowe lo fara'u a'i henerai. Mt 9:20-21 ");
INSERT INTO sny_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Sosu a'i pe lu tewi tamo iyape Farisi, sosu Moses lo yo peri so'oruwe te'e siye lu tamo, lowe Jisas ma'e te'e toweriyei ne fai. Lowe omo Jerusalem ma'e fai. ");
INSERT INTO sny_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Lowe le ma'e apou te'e toweriye, “Piyene lu disaipel no ya'ariyei nomo lo, lo yo peri arisisiya awere? Lowe nau ta'ase ene ateye su, lowe ereti lowe lo sa'i au hu se ta'ame.” ");
INSERT INTO sny_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Sosu Jisas lowe ma'e itiya'u eiye, “Fene lai piyene Owane Sitewi lo yo peri arisisiya awere? Fene ya'ariyei lo yo peri kairefiyeyei se tote tawesisiya. Ahowa, fene Owane Sitewi lo yo peri werese arisisiya. ");
INSERT INTO sny_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Wanure! Tu naifa Owane Sitewi apou eiye, ‘Fene tai mai fene lo iyape ei ani arowere. Meni ta tai mai lo ma'e te'e naruwei su, lu tamo meni ape fu aine tera'ere.’ ");
INSERT INTO sny_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ahowa, fene apou te'esiya, ‘Ane etiri ape ta tai mai ano ma'e auwei ne totesiya. Ahowa, ane lowesi ma'e aurowata. Etiri ape ane lai Owane Sitewi ma'e etiri ape auwei ne ariariyeye. Serai ane lowesi ma'e etiri ape aurowata.’ ");
INSERT INTO sny_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Fene ya'ariyei lo yo peri ape wanu umasiteye, fene Owane Sitewi lo yo peri wiyeme a'i ani ararowe. Ya'ariyei fene lo, lo yo peri apou eiye, ‘Fene mai tai fene lo lo iyape owe ape ei ani arowere.’ Marepi fene lo se Owane Sitewi lo peri yahowa'i henerai. ");
INSERT INTO sny_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Fene lu marepi hesi a'i se lu, tu naifa weriyei Owane Sitewi lo peri au te'esiye meni iyape Aisaia, le fene ne wiyeme a'i apou leseye, ");
INSERT INTO sny_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Lu taune werese, lowe ahi a'i lowe lo se iyape ano ei ani arowenamisiya. Ahowa, marepi lowe lo ane ma'e eyeri irosiya. ");
INSERT INTO sny_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Lowe ane ne au te'e nine'iteyei su, marepi lowe lo yahowa'i henerairowa. Peri ape lowe au te'e atuaturowa ape, lowe lu lo marepi tote umasirowa.’” ");
INSERT INTO sny_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Sosu Jisas lai lu taune werese le ma'e ute aniye. Sosu lowe ma'e apou au eiye, “Fene peri ano wanure! Fene peri sitewi ano tote tawesire. ");
INSERT INTO sny_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Etiri ape mo fene ahi papu ene ayei su, lowe marepi hepene fene lo au unouwerowata. Ahowa, peri luwaru a'i, peri wawero te'erowa ape, etiri ape mo ahi nowe ma'e fai ape, lowe lu taune lo marepi hepene au unouweyei.” Mt 12:34 ");
INSERT INTO sny_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Sosu Jisas lo lu disaipel le ma'e te'e toweriyei ne fai. “Ne peri ape au te'eye su, ne lu Farisi lo marepi au luwaruweye. Ne so'oruwesiya awere? Lowe ne ne ai marepi totesiya.” ");
INSERT INTO sny_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ahowa, Jisas lowe ma'e peri anowe ta itiya'u eiye, “Tai ano hire ma'e irosiya ape, le ta'aneyei awei irosiya. Le etiri werese, awei papu irosiya ape, le yehe sameye ta'ame su, le etiri werese ape mo ani tahe aniyewe, yehe ma'e ani fu arosawirowa. Etiri lo napi towe werese yehe ma'e ani fu arosawirowa. ");
INSERT INTO sny_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Fene lu tewi ape mo arure. Lowe lu nihe pokoweyei se wou a'i ne. Lowe meni tere'e nihe pokoweyei se yo ta atuatuwei su, lowe ninapune awei fisiye yo papu winetairowa.” Lu 6:39; Ro 2:19 ");
INSERT INTO sny_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Sosu Pita le ma'e itiya'u eiye, “Ne fara'u peri anowe ape sitewi nomo ma'e au te'e atuatu areiyere.” ");
INSERT INTO sny_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Sosu Jisas le ma'e eiye, “Ne peri anowe lo sitewi so'oru ta'ama awere? ");
INSERT INTO sny_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Wanure! Etiri werese ape mo, ahi papu wiyei ape, etiri werese ape mo lire papu wiyei. Me'iye su, nowe ma'e li wesi ma'e tu narirowa. ");
INSERT INTO sny_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Etiri ape mo ahi nowe ma'e heneraisiya ape, lowe marepi ma'e heneraisiya. Etiri ape mo lowe lu taune lo marepi hepene au unouwesiya. ");
INSERT INTO sny_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Etiri eito eite mo, marepi nowe ma'e heneraisiya ape, apou a'i ne. Marepi luwaru a'i, lu aine tera'eyei ne totesiya, naituwe tiyato towesi arosawiyei ne totesiya, tafa'e yo seni luwaru a'i ta'areiyei ne totesiya, peri wawero, peri te'e narusiya. ");
INSERT INTO sny_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Etiri eito eite mo lu taune lo marepi hepene au unouwesiya. Ahowa, meni ta ereti lo unou a'i se ayei su, etiri ape meni ape lo marepi hepene au unouwerowata.” ");
INSERT INTO sny_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Sosu Jisas lu taune werese arunatiyewe, omo pani Tair, omo Saidon ma'e fi. ");
INSERT INTO sny_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Lowe omo pani Tair ma'e heneri su, menitani ta, omo pani Kenan ma'e fai ape, Jisas ma'e henerai. Le Moses lo yo peri umasi ta'ame. Le apou eiye, “Meni Owane, ne meni owane Devit lo meni eime pefine. Ne ane ne ewitere. Ne ane ne seremareyere. Sepei luwaru a'i lai eime taune ano papu ironamisiya. Sepei luwaru a'i lai eime taune ano au luwaruweyei ne totesiya.” ");
INSERT INTO sny_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ahowa, le menitani ape ma'e itiya'u peri ta ei ta'ame. Sosu Jisas lo lu disaipel le ma'e eiye, “Ne menitani ape omo topo lo ma'e eimawesawire. Le nomo ma'e peri erasi a'i utetaiteye.” ");
INSERT INTO sny_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ahowa, Jisas le ma'e eiye, “Ane Israel lo lu taune ma'e seremareyeyei ne fai. Lowe fe sipsip ipo ma'e erau aiyeye wou a'i ne. Lowe a'i ma'e, ane lai au seremareyeyei ne itorai.” Mt 10:6 ");
INSERT INTO sny_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ahowa, menitani ape Jisas ma'e lowe uporo ape'i onurai. Sosu le ma'e erasi a'i eiye, “Meni Owane, Ne ane ne seremareyere.” ");
INSERT INTO sny_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Sosu le menitani ape ma'e itiya'u eiye, “Ane eimane lo nau ta'ase anirowawe, you ma'e fu arorowata. Yo seni ape luwaru a'i ne.” ");
INSERT INTO sny_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ahowa, menitani ape le ma'e itiya'u eiye, “Ei, meni owane, ne peri wiyeme a'i te'eye. Ane you ape aiwawe a'i ne! Ahowa, meni ta nau ta'ase ayei su, nau tewi a'i tewi a'i hi ma'e winetaiyei. Serai ane fara'u nau ta'ase tewi a'i ape ene arowa.” ");
INSERT INTO sny_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Sosu Jisas le ma'e itiya'u eiye, “Menitani, tote tawesiyei no wisere erasi a'i ne! Ane eime taune no au ta'ane fara'uweye.” Jisas peri ape te'eye su, sepei luwaru a'i eime taune ape arunatiyewe, sosu eime taune wisere a'i henerai. ");
INSERT INTO sny_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Sosu a'i pe Jisas omo Saidon, omo Tair arunatiyewe, le hare ite Galili tewiye ma'e heneri. Le lu feni aiwawe omo ta yaneye. Le saro ahe onu fetaneyeteye. ");
INSERT INTO sny_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Sosu le omo ape sahe onuteye su, lu taune tomu ne'ese le ma'e ta'uwerai. Lowe lu taune tomu ne'ese u tahe se ape le ma'e henetai. Lu taune tamo lowe haroharoweye ape, lowe nono'oweye ape, nihe pokoweye ape, ahi tomo'ute tawesiye ape, lu taune tere'e tere'e u se ape le ma'e henetai. ");
INSERT INTO sny_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Serai Jisas lowe werese au ani ta'ane fara'uweye. Lu taune ahi tomo'ute tawesiteye ape, lowe peri te'eteye. Lowe nihe pokoweye a'i ape, lowe siyeteye. Lu taune lowe haroharoweye a'i ape, lowe ye'i sine uweiteye. Lu taune werese Jisas ma'e ta'uwerai ape lowe werese siyeye su, lowe hepene se su'ariye. Sosu lowe Israel lo Owane Sitewi wiyeme a'i lo iyape ei ani aroweteye. Mk 7:37 ");
INSERT INTO sny_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Sosu a'i pe Jisas lai lu disaipel lo ma'e ei aniye. Lowe ma'e apou eiye, “Ane lu taune werese marepi erasi a'i ewite totesiya. Lowe nomo mase nowe mi hesi heta iroteye. Ene ayei werese lowe lo irote ta'ame. Lowe lau mase erasi a'i iroteye. Serai ane lowe omo towafi lo ma'e eimawesawirowata. Ane lowe lau se a'i si eimawesawirowa su, lowe nihe meremereyerowawe, lowe yo sahe ninapune winetairowa.” Mt 14:14 ");
INSERT INTO sny_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Sosu lu disaipel lo le ma'e eiye, “Nomo eiwerou ma'e nau ta'ase tomu ne'ese aniyei awere? Omo pani eite etiri ariye a'i ne. Lu taune werese tomu ne'ese irosiya. Nomo lowe werese ma'e au ene arowata.” ");
INSERT INTO sny_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Sosu Jisas lowe ma'e ei toweriye, “Nau ta'ase fene eiwerou a'i irosiya awere?” Lowe le ma'e itiya'u eiye, “Nomo nau ta'ase ereti feni werese feni hesi a'i irosiya. Hare tewi oso a'i aiwawe irosiya.” ");
INSERT INTO sny_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Sosu le lu taune werese ma'e eiye, “Fene werese awei peperi sahe onure.” ");
INSERT INTO sny_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Lu taune werese awei peperi sahe onuteye su, le nau ta'ase ereti feni werese feni hesi a'i, hare tewi oso a'i ereti se aniteyewe, le Owane Sitewi ma'e au te'e wisereyeye. Le nau ta'ase hare werese tewi pa tewi ani towesiteye. Nau ta'ase, hare werese tewi pa tewi towesiye su, le lu disaipel lo ma'e auwe. Sosu lu disaipel lo nau ta'ase hare werese tewi a'i lu taune ma'e au nonetiteye. ");
INSERT INTO sny_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Lu taune werese nau ta'ase, hare werese ene ateye. Lire lowe lo teme'eriyeye. Marepi lowe lo wisere a'i tene! Lowe werese ene a tepa'asiye su, lu disaipel lo nau ta'ase hare tewi a'i ipi papu ta'uwe ani asiteye. Lowe nau ta'ase hare tewi a'i ipi ereti feni werese, feni hesi a'i ani asi teme'eriyeteye. ");
INSERT INTO sny_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Lu werese, ene ateye ape, lowe 4,000 nawiteye. Taune eimane tomu ne'ese aiwawe ene ateye. ");
INSERT INTO sny_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Sosu Jisas lu taune werese omo towafi lowe lo ma'e si eimawesawi su, le lu feni lo mase wai papu wi atowewe, hare ite Galili feni eire ma'e toneri. Lowe hare ite tewiye omo pani Magdala ma'e furi. ");
INSERT INTO sny_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Sosu a'i pe lu Farisi tamo lu Sadyusi tamo lowe Jisas ma'e te'e toweriyei ne fai. Lowe apou te'e toweriye, “Ne wiyawi erasi pefine a'i nomo ma'e au atuature. Ne wiyawi erasi a'i aniyei su, nomo apou toteyei, ‘Owane Sitewi lai ne hi awei ma'e eimawe arosai.’” Lowe Jisas ma'e areareyei ne toteye. Mt 12:38; Lu 11:16 ");
INSERT INTO sny_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ahowa, le lowe ma'e itiya'u eiye, “Fene apou toteye, ‘Neriwei su, ni'arawe werese farufaru a'i ne. Nowe mo'o su poweiye mi wisere a'i ne.’ ");
INSERT INTO sny_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Sosu nowe esi mitaiyeye su, ni'arawe farufaru a'i, sa'i nihari erasi a'i iroteye ape, serai sa'i, fiyaru erasi a'i henerairowa. Fene ni'arawe lo yareyare so'oruwe tepa'asiye. Ahowa, ane wiyawi erasi a'i aniyei su, fene wiyawi ano lo sitewi so'oruwerowata. ");
INSERT INTO sny_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Fene werese yo seni luwaru a'i ironamisiya ape, fene werese naituwe tiyato towesiye ape, fene wiyawi erasi pefine a'i siye nehireme. Ane a'i lai fene ma'e wiyawi erasi pefine a'i au atuaturowata. Ane yareyare ta'i a'i fene ma'e au atuaturowa. Yareyare ape tu naifa weriyei Owane Sitewi lai Jona ma'e au atuatuwe. Nowe hesi heta Jona hare erasi lire papu iroteye. Serai yareyare ape ane fene ma'e au atuature.” Jisas peri tepa'asiye su, le lowe ma'e arunatiyewe, fi. Mt 12:39; Lu 11:29 ");
INSERT INTO sny_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Sosu a'i pe Jisas lo lu disaipel aiwawe a'i hare ite toneri su, lowe nau ta'ase werese i'ane arunatiyewe, aitai ta'ame. ");
INSERT INTO sny_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Sosu Jisas lowe ma'e apou eiye, “Lu Farisi, lu Sadyusi lo fe wawe sa'i ne. Fene weiyai! Fene arute! Fene fe wawe sa'i lowe lo me'iyeni ma'e atati arure! Fe wawe sa'i lowe lo ape aiwawe wou a'i marepi luwaru a'i lowe lo ne. Marepi lowe lo fene papu wiyei su, marepi hepene werese fene lo au luwaruwerowa.” Lu 12:1 ");
INSERT INTO sny_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Lu disaipel lo peri ape wanuwe su, lowe te'e tiyatiteye, “Piye peri ape lo sitewi toteye awere? Nomo nau ta'ase i'ane arunatiyewe, aitai ta'ame. Serai le peri ape nomo ne au te'eteye awere?” ");
INSERT INTO sny_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ahowa, Jisas lai marepi lowe lo siye so'oruwe tepa'asiye. Serai le lowe ma'e eiye, “Fene wanure! Tote tawesiyei fene lo oso a'i tene! Fene apou toteye, ‘Nomo nau ta'ase aitai ta'ame.’ Piyene fene apou te'e tiyatiteye awere? ");
INSERT INTO sny_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","10","Ane lu (5,000) nawiteye ape, nau ta'ase ereti feni werese au ene aye su, eiwerou a'i ipi ani asi teme'eriyeye awere? Aiwawe ane lu, 4,000 nawiteye ape, nau ta'ase ereti feni werese feni hesi a'i au ene aye su, eiwerou a'i ipi ani asi teme'eriyeye awere? Fene marepi tote i'aneye awere? Fene wiyawi ape lo sitewi tote so'oru ta'ama awere? Mt 14:17-21; 15:34-38 ");
INSERT INTO sny_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ane peri ape apou eiye su, ‘Fene weiyai! Lu Farisi, lu Sadyusi lo fe wawe sa'i ape owe ape umasite.’ Fene marepi lowe lo tote umasiyei su, marepi lowe lo marepi hepene fene lo au luwaruweyei. Fene peri ape lo sitewi tote so'oru ta'ama awere?” ");
INSERT INTO sny_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Sosu lowe peri ape wanuwe su, lowe peri ape lo sitewi siye so'oruwe tepa'asiye. Jisas peri ape apou eiye su, “Fene weiyai! Lu Farisi, lu Sadyusi lo marepi luwaru a'i owe ape umasite. Le nau ta'ase ne au te'eye ta'ama. Ahowa, le peri lo sitewi apou te'eye. ‘Fene weiyai! Fene lu Farisi lo, lu Sadyusi lo marepi lowe lo owe ape wanu umasite.’” ");
INSERT INTO sny_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Sosu a'i pe Jisas lu disaipel lo aiwawe omo pani ape arunatiyewe, omo pani Sisaria, Filipai ma'e heneri. Sosu le lu disaipel lo ma'e apou ei toweriye, “Lu taune werese lowe ane, meni hire ma'e itorai ape ne, eiwerai totesiya awere? Ane eiwerai awere?” ");
INSERT INTO sny_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Sosu lowe le ma'e itiya'u eiye, “Lu taune tamo ne ne apou totesiya. ‘Ne Jon sa'i au hu siye meni.’ Lu taune tamo apou totesiya, ‘Ne Owane Sitewi lo peri au te'e siye meni Elaija.’ Lu taune tere'e tamo apou totesiya, ‘Ne Owane Sitewi lo peri au te'e siye meni Jeremaia.’ Lu taune tere'e tamo apou totesiya, ‘Ne Owane Sitewi lo peri au te'e siye meni ta.’” Mt 14:1-2; Mk 6:14-15; Lu 9:7-8 ");
INSERT INTO sny_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Sosu le lowe ma'e ei toweriye, “Fene lai ane piye meni totesiya awere? Ane eiwerai awere?” ");
INSERT INTO sny_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Sosu Saimon Pita itiya'u apou eiye, “Ne a'i lai Krais tene! Ne meni ape Owane Sitewi lai hi awei ma'e eimawe arosai. Ne Owane Sitewi, Meni Owane Pefine a'i, mi mi weriyei weriyei ironamisiya ape, lo meni eime.” Jo 6:69 ");
INSERT INTO sny_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Sosu Jisas le ma'e itiya'u eiye, “Saimon, Jon lo meni eime, Owane Sitewi lai ne mase irosiya. Peri no ape lu lo marepi ma'e fai ta'ama. Ahowa, Tai ano, omo hire ma'e onunamisiya ape, le lai peri no ape marepi no papu au te'e atuatuteye. Ga 1:15-16 ");
INSERT INTO sny_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Sosu ane ne ma'e apou te'esiya. Ne a'i lai Pita. Tapiye ape sahe ane lu tewi ano au ta'anerowa. Lu tewi ano kairefi a'i teinamitorowa. Sepei Satan lu tewi ano aine tera'eyei ne totenamisiya ape, le lu tewi ano au ani ararorowata. Jo 1:42; Ef 2:20 ");
INSERT INTO sny_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Sosu ne Owane Sitewi lo omo lo yo au noweinoweisiya meni. Serai ne etiri werese awei sahe irosiya ape, ne apou eiyei su, etiri ape amou tene! Sosu Owane Sitewi lai peri no umasirowawe, Owane Sitewi lo omo sahe, le apou eiyei, ‘Ei, etiri ape amou tene!’ Aiwawe a'i ne apou eiyei su, ‘Etiri ape wisere a'i ne. Ne etiri ape irore!’ Sosu Owane Sitewi omo hire ma'e aiwawe a'i peri no umasirowa. Le apou eirowa, ‘Ei, etiri wisere a'i ne. Ne etiri ape irore!’” Mt 18:18; Jo 20:23 ");
INSERT INTO sny_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Sosu le lu disaipel lo einamiyewe, lowe ma'e eiye, “Fene lu taune werese werese ma'e ane Krais ne owe ape au te'e fiyarite.” ");
INSERT INTO sny_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Sosu a'i pe nowe ape se Jisas lu disaipel lo ma'e etiri werese ne omo erasi Jerusalem sahe henerairowa ape, le lowe ma'e au atuatu areiyeteye. Le omo erasi Jerusalem henerirowa su, Owane Sitewi lo wesi lu ya'ariyei tamo, au heseyei lu owane tutawe tamo, Owane Sitewi lo peri siye so'oruwe siye lu tamo, lowe le ma'e fofowei erasi a'i au irorowa. Lowe aine tera'erowa. Sosu nowe hesi heta i tepa'asirowa su, Owane Sitewi lai le si tame norohuwe hene ani sinerowa. ");
INSERT INTO sny_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Sosu Pita peri ape wanuwe su, le Jisas ma'e hene tiyewe, le ma'e peri kairefi a'i se eiye, “Meni Owane, peri no wawero a'i ne! Etiri ape mo ne ma'e henerairowata.” ");
INSERT INTO sny_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ahowa, Jisas Pita ma'e atati teiyewe, le ma'e eiye, “Sepei Satan, Ne me'iyeni ano ma'e ire! Ne ane yo ano einamiyei ne toteye. Ne lai lu lo marepi totesiya. Ne Owane Sitewi lo marepi tote umasi se ta'ama.” ");
INSERT INTO sny_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Sosu Jisas lu disaipel lo ma'e apou eiye, “Lu taune tamo ane mo'o tote umasiyei ne toteyei su, lowe marepi towafi lowe lo fu ani ararore! Lowe me tape'i towafi lowe lo fu ani sutetirowawe, ane mo'o umasite. Mt 10:38; Lu 14:27 ");
INSERT INTO sny_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Lu taune tamo marepi erasi a'i se mi mi pasi pasi ironamiyei ne toteyei su, lowe witane a'i temeniyerowa. Aiwawe a'i lu taune tamo, wiyawi ano irowei ape, lu tere'e tamo lowe aine tera'eyei su, Owane Sitewi lai lowe si tame hene ani norohuwe sinerowa. Mt 10:39; Lu 17:33; Jo 12:25 ");
INSERT INTO sny_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Meni ta apou toteyei su, ‘Ane awei lo etiri werese werese a'i ani ta'uwerowa.’ Ahowa, marepi hepene lo yehe omo ma'e mi mi pasi pasi weriyei ironamitorowa. Etiri werese le ani ta'uwerowa ape, lowe le au ferafereirowa awere? Opiyai! Meni ta ape etiri tomu ne'ese ani ta'uwerowa su, le marepi hepene lo ne piye eterowa awere? Opiyai! Le marepi hepene lo si tame eterowata. Mt 4:8-9 ");
INSERT INTO sny_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ane, meni hire ma'e itorai ape, ane tai ano lo kairefi erasi a'i se, Owane Sitewi lo ipari wisere a'i (ensel) mase itorairowa. Nowe ape se, ane lu taune werese lo yo seni au hese ereirowawe, etiri apou ape lowe ma'e itiya'u aurowa. Lu taune tamo yo peri ano umasi ta'ama ape mo, ane lowe yehe omo ma'e ani fu arosawirowa. Lu taune werese yo peri ano umasinamiteye ape, ane lowe Owane Sitewi lo omo wesi ma'e hene ani wirowa. Mt 25:31; Sng 62:12; Snd 24:12; Ro 2:6; KTH 22:12 ");
INSERT INTO sny_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Peri ano pefine a'i ne. Wanure! Lu tamo sato ahe teisiya ape, ane, meni hire ma'e itorai ape, tai ano lo kairefi erasi a'i mase lu taune werese au noweinoweiyei ne itorairowa su, nowe ape se lowe temeniyerowata.” ");
INSERT INTO sny_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Sosu a'i pe nowe ereti feni werese feni ta'i (6) i tepa'asiye su, Jisas lu disaipel lo tamo Pita, Jems, sosu Jems lo pa'ase Jon omo hire pefine a'i ma'e yaneye. Lowe a'i lai omo ape yaneye. ");
INSERT INTO sny_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Lowe saro teiteye su, Jisas lo tahe pa'are he'i a'i henerai. Nihari lo ape mitaiyeyei erasi a'i poweiye wou a'i tewi mitaiyeyei fiyarirai. Ipari tahe lo wapo pefine a'i henerai. Mitaiyeyei erasi wou a'i ne. 2Pi 1:16-18 ");
INSERT INTO sny_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Lowe saro teiteye su, lu hesi ni'arawe ma'e itoraiyewe, Jisas ma'e te'e tiyatiteye. Lowesi lo iyape Moses, sosu Elaija. ");
INSERT INTO sny_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Sosu Pita Jisas ma'e itiya'u eiye, “Meni Owane, nomo ne mase saro irosiya. Etiri ape wisere a'i ne. Nomo fara'u wesi ipo oso hesi heta ta'anerowa. Wesi ta'i ne fara'u onu fetaneyerowa. Ta'i a'i Moses lo, sosu ta'i a'i Elaija lo ta'aneyei. Ane marepi no umasiyei.” ");
INSERT INTO sny_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita le ma'e peri ape au te'eteye su, Siyere! Ni'arawe mitaiyeyei erasi a'i se omo hire ma'e itoraiyewe, lowe werese napetu tawesiye. Sosu Wanure! Peri no'u erasi a'i ni'arawe sahe apou au te'eye, “Meni ape le meni eime ano ne. Ane le ne marepi erasi a'i tote wawesiyenamisiya. Le marepi werese ano umasinamisiya. Serai ane le ne au nine'inamisiya.” Sng 2:7; Ais 42:1; Lo 18:15 ");
INSERT INTO sny_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Sosu lu disaipel lo ape peri ape wanuwe su, lowe tu ereme awei ma'e onoruwe lowe marepi lowe lo se erasi a'i atoweiye iroteye. ");
INSERT INTO sny_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Sosu Jisas lowe ma'e faiyewe, lowe ma'e ereti se isawe hetesiyeye. Sosu lowe ma'e eiye, “Fene sinere! Atoweiye sawa!” ");
INSERT INTO sny_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Lowe Jisas lo peri wanuwe su, lowe nihe lowe lo hire siya ani aroweye. Lowe Jisas ta'i a'i siyeye. Lu hesi ni'arawe ma'e itorai ape, si tame wiye. Lowesi sato ariye. ");
INSERT INTO sny_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Sosu a'i pe lowe omo ma'e itorai su, Jisas lu disaipel lo hesi heta ma'e peri kairefi a'i se apou eiye, “Fene lu taune werese ma'e suwou lo peri ape owe ape au te'e fiyarite. Ane temeniyerowawe, si tame sinerowa su, fene fara'u suwou lo peri ape lu taune ma'e au te'e fiyarirowa.” ");
INSERT INTO sny_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Sosu lu disaipel lo ape le ma'e te'e toweriye, Owane Sitewi lo peri so'oruwe siye lu tamo, lowe apou eiye, “Meni Elaija tu pei henerairowa. Piyene lowe apou te'esiya awere?” Mal 4:5 ");
INSERT INTO sny_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jisas lowe ma'e itiya'u apou eiye, “Ei, peri ape pefine a'i ne. Meni Elaija tu aiyerowa. Le aiyerowa su, le etiri werese tame au ta'ane wisereyerowa. ");
INSERT INTO sny_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ahowa, ane fene ma'e apou eisiya, Meni Elaija tu henerai tepa'asiye. Lu tewi ape mo lowe meni ape siye so'oru ta'ama. Le henerai su, lu tewi ape mo marepi towafi lowe lo tote umasiteyewe, sosu le ma'e au luwaruweye. Aiwawe a'i lowe ane, meni omo hire ma'e itorai ape, lowe ane aiwawe a'i au luwaruwerowa. Ane fofowei erasi a'i teriterowa.” Mt 11:14 ");
INSERT INTO sny_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Sosu lu disaipel lo peri lo ape wanuwe su, lowe Jon sa'i au huwei siye meni ne au te'eteye ape, siye so'oruweye. Lu 1:17 ");
INSERT INTO sny_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Sosu a'i pe lowe lu taune tomu ne'ese ito heneri su, meni ta Jisas ma'e lowe uporo ape'i onuwewe, tu ereme ororuwe. Le Jisas ma'e marepi orese a'i se apou ei toweriye, ");
INSERT INTO sny_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Meni Owane, ne ane au ferafereire. Meni eime ano meremereye a'i ne. Tahe werese lo auseriyesiya. Le u erasi a'i se. Nowe tomu ne'ese se le yehe ma'e winetainamiteye. Aiwawe nowe tomu ne'ese se sa'i papu winetainamiteye. ");
INSERT INTO sny_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ane meni eime ano eite lu disaipel no ma'e henetaiyewe, lowe sepei luwaru a'i au ani eimawesawirowata.” ");
INSERT INTO sny_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Sosu Jisas le ma'e itiya'u eiye, “Fene werese, saro ahe irosiya ape, fene tote tawesiyei fene lo po'uteye. Fene marepi towafi fene lo tote fareraiyesiya ta'ama. Ane fene mase nowe mi tomu ne'ese iroteye. Fene ane ne tote tawesi ta'ame. Ane si tame wirowa su, fene eiwerou irorowa awere? Ane fene mase nowe poweiye eiwerou irorowa awere? Meni eime ape heneta!” ");
INSERT INTO sny_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Lowe meni eime ape henetai su, Jisas sepei luwaru a'i ape ma'e ai peri erasi apou eiye, “Sepei luwaru a'i, ne meni eime eite papu arunatire! Ne ire!” Sepei luwaru a'i Jisas lo peri wanuwewe, le meni eime ape arunatiyewe fi. Witane a'i meni eime lo u fara'uwe tepa'asiye. ");
INSERT INTO sny_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Sosu nowe me'iye su lu disaipel lo Jisas ma'e peri ta eresene a'i te'e toweriyei ne fai. Lowe apou ei toweriye, “Piyene nomo sepei luwaru a'i ape au ani eimawesawi awere?” Mt 10:1 ");
INSERT INTO sny_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Sosu Jisas lowe ma'e eiye, “Tote tawesiyei fene lo oso a'i tene. Serai fene sepei luwaru a'i ape au eimawesawi ta'ama. Ane peri wiyeme a'i fene ma'e au te'esiya. Wanure! Fene tote tawesiyei oso a'i saiyoho so wou a'i irosiya su, fene omo ape ma'e apou au te'ere, ‘Omo, ne sinere! Pani tewi ma'e ire!’ Omo ape peri no wanurowawe, le sinerowawe, pani tewi ma'e onurirowa. Fene etiri werese werese fara'u ta'ane irorowa.” ");
INSERT INTO sny_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","{Fene sepei luwaru a'i eito eite au ani eimawesawireme su, fene Owane Sitewi ma'e au te'enamitorowa. Sosu ene ayei werese siyenairowa. Serai fene fara'u sepei luwaru a'i ape au ani sasarisawirowa.} Mt 21:21; Mk 11:23; Lu 17:6; 1 Ko 13:2 ");
INSERT INTO sny_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jisas lu disaipel lo aiwawe a'i omo pani Galili sahe ta'uweri. Sosu Jisas lu feni lo ma'e eiye, “Meni ta ane, meni omo hire ma'e itorai ape, lu tamo ma'e aine tera'eye ne henetirowa. Mt 16:21 ");
INSERT INTO sny_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Lu tewi ape mo ane aine tera'erowa. Ane fisiye yo papu nowe hesi heta howeirowawe, sosu nowe mi hesi heta i tepa'asirowa su, Owane Sitewi lai ane si tame hene sinerowa.” Lu feni werese lo peri ape wanuwe su, lowe marepi orese erasi a'i totenamiteye. ");
INSERT INTO sny_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Sosu a'i pe Jisas lu disaipel lo aiwawe a'i omo Kaperneam ma'e heneri. Lu tamo Owane Sitewi lo wesi takis ma'aru ani siye lu peri ta Pita ma'e te'e toweriyei ne fai. Lowe Pita ma'e te'e toweriye, “Atuatu siye meni fene lo, le Owane Sitewi lo wesi takis ma'aru auwe awere? Le ma'aru tau hesi a'i Owane Sitewi lo wesi ma'e fa aure!” Kis 30:13; 38:26 ");
INSERT INTO sny_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Sosu Pita lowe ma'e itiya'u eiye, “Ei, Atuatu siye meni nomo lo takis ma'aru aunamiteye.” Me'iye se, Pita wesi papu wiyewe, Jisas tu le ma'e ei toweriye, “Saimon, ne piye peri totesiya awere? Awei lu owane werese lai takis ma'aru aniyei su, eiwerou ma'e lowe lai takis ma'aru aniyei awere? Eimane towafi lowe lo aniyei awere? Lu tewi tere'e se aniyei awere?” ");
INSERT INTO sny_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Sosu Pita le ma'e itiya'u eiye, “Lowe lu tewi tere'e se takis ma'aru aniyei.” Sosu Jisas le ma'e itiya'u eiye, “Ei, serai eimane lowe lo takis ma'aru werese aurowata. ");
INSERT INTO sny_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Serai ane ne ma'e au te'esiya. Ane lu tewi ape nomo ma'e ai marepi toteyei wou ta'ama. Ne hare ite Galili ma'e ire. Ne hare sase sa'i papu fure! Hare ape tutawe sase tomuwei su, ne ahi lo ani potuwerowa. Hare ape ahi papu irosiya su, ne ma'aru tau erasi siyerowa. Ne ma'aru tau ape lu tewi ape ma'e aiti. Tewi a'i ano tewi a'i no lowe ma'e aunari.” ");
INSERT INTO sny_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Sosu a'i pe nowe ape se, Jisas lo lu disaipel le ma'e peri ta te'e toweriyei ne fai. Lowe apou te'e toweriye, “Eiwerai meni tutawe iyape erasi a'i se Owane Sitewi lo omo hire sahe, irorowa awere?” Lu 22:24 ");
INSERT INTO sny_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Sosu Jisas peri lowe lo wanuwe su, le meni eime ta ei aniyewe, le eime ape ma'e lowe ponei sahe au teiteye. ");
INSERT INTO sny_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Sosu eiye, “Peri ano pefine a'i ne. Wanure! Fene yo seni luwaru a'i atati arunatirowawe, yo seni ano umasirowa su, fene eimane lo marepi wou a'i fa henera. Fene eimane ta wou a'i heneraiyei ta'ama su, fene Owane Sitewi lo omo sahe eiwerou wirowata. Mt 19:14; Mk 10:15; Lu 18:17 ");
INSERT INTO sny_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Lu taune tamo marepi towafi lowe lo ani ararorowawe, eimane lo marepi wou a'i toteteyei su, lowe Owane Sitewi lo omo sahe iyape erasi tutawe irorowa. ");
INSERT INTO sny_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Aiwawe a'i meni ta meni eime ta ma'e au isafiye wisereyeyei su, le ane ma'e aiwawe a'i au isafiye wisereyerowa.” Lu 10:16; Jo 13:20 ");
INSERT INTO sny_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Sosu Weiyai! Meni ta eimane, ane ne tote tawesi umasisiya ape, le tote tawesiyei lowe lo au luwaruwerowawe, lowe yo seni luwaru a'i au irorowa su, Owane Sitewi tai ano meni ape ma'e fofowei erasi a'i aurowa. Fene tapiye erasi a'i meni ape lo pere'i sahe wafei se ti tawesirowawe, fene le sa'i papu fu arorowawe, sosu le atenisetirowa. Meni ape fofowei oso a'i teriterowa. ");
INSERT INTO sny_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Lu taune omo omo werese irosiya ape, fene weiyai! Fene yo ano einamirowawe, serai lu taune tamo ano yo seni luwaru a'i irowei su, tai ano fene ma'e fofowei erasi a'i aurowa. Peri pefine a'i lu tomu ne'ese yo ano einamiyei ne toterowa. Ahowa, meni ta yo ano einamitowa su, meni ape fofowei erasi a'i ironamitorowa. ");
INSERT INTO sny_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Sosu fene ereti lowe tote tawesiyei fene lo yo seni luwaru a'i ma'e ni'ariyeteyei su, fene ereti lowe fene lo aine tourowawe, ani fu arosawire. Fene Owane Sitewi lo omo ma'e wirowa su, fene ereti ta'i a'i lowe ta'i a'i mase wirowa. Etiri wisere a'i ne. Sosu aiwawe ereti lowe fene lo yo seni luwaru a'i ma'e ni'ariteyei su, fene werese ereti hesi, lowe hesi yehe omo ma'e ironamitorowa. Yehe omo ape mi mi pasi pasi ironamitorowa. Etiri ape luwaru a'i tene! Mt 5:29-30 ");
INSERT INTO sny_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Aiwawe a'i fene nihe ta'i yo seni luwaru a'i ma'e ni'ariteyei su, fene nihe fene lo ani tahe fu arosawire. Fene Owane Sitewi lo omo nihe ta'i a'i se wirowa. Etiri ape wisere a'i ne. Ahowa, fene nihe hesi fene lo yo seni luwaru a'i ma'e ni'ariyeteyei su, fene yehe omo ma'e mi mi pasi pasi irotorowa. Etiri ape luwaru a'i tene! ");
INSERT INTO sny_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Serai fene eimane werese ape ai marepi owe ape totenamite. Piyene awere? Owane Sitewi lo ipari wisere a'i (ensel) lowe au noweinoweinamisiya. Fene etiri luwaru a'i lowe ma'e au luwaruwerowa su, ipari wisere a'i (ensel) lowe lo Owane Sitewi ma'e etiri ape ne au te'erirowa. Serai fene eimane ai marepi owe ape totenamite. ");
INSERT INTO sny_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","{Ane, meni omo hire ma'e itorai ape, lu taune yo seni luwaru a'i ironamiteye ape, si tame hene aniyei ne itorai.} Hi 1:14; Lu 19:10 ");
INSERT INTO sny_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Fene eiwerou totesiya awere? Meni ta fe sipsip lu ereti feni tamo werese irosiya ape (100) fe sipsip ta'i a'i ipo ma'e erauwiyerowa su, meni ape fe sipsip werese omo to'u sahe arunatirowawe, fe sipsip ta'i a'i, ipo ma'e erauwiye ape, ne nehiyei ne irowa. ");
INSERT INTO sny_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ane peri pefine a'i fene ma'e au te'esiya. Meni ape fe sipsip ipo sahe siyeyei su, le marepi wisere erasi a'i nine'inamirowa. Fe sipsip werese tere'e ne, le marepi wisere a'i nine'irowata. Lowe werese wisere a'i ironamirowa. Le fe sipsip werese nine'inamirowa. Ahowa, fe sipsip ape, ipo ma'e erauwiyeye ape, le marepi erasi pefine a'i nine'inamisiya. ");
INSERT INTO sny_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Eimane ta ma'e irowa su, Tai fene lo omo hire ma'e onunamitorowa ape, le marepi orese a'i totenamitorowa. Ei. Tai fene lo marepi apou totesiya, ‘Ane eimane werese werese mi mi pasi pasi temeniye wou ta'ama.’” ");
INSERT INTO sny_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Sosu a'i pe kaiyemo fene lo ta Owane Sitewi lo peri umasisiya ape, yo seni luwaru a'i fene ma'e irorowa su, fene meni ape ma'e eresene a'i ire. Fene le ma'e apou eire, ‘Ne yo seni luwaru a'i irowei ape, ne au te'e fareraiyere. no wanu umasiyei su, etiri wisere a'i tene! Serai ne kaiyemo ape Owane Sitewi ma'e si tame henetirowa. Lu 17:3; Ga 6:1 ");
INSERT INTO sny_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ahowa, kaiyemo, le peri no wanu umasi se ta'ame su, ne meni ta'i tere'e, lu hesi le ma'e aiwawe yo seni luwaru a'i lo ape au te'e areiyeyei ne ire. Owane Sitewi lo one towe sahe apou leseye, ‘Lu hesi, lu hesi heta yo seni luwaru a'i au te'e areiyerowa. Serai lu taune werese peri wiyeme a'i, henerai areiyerowa ape siye so'oruwerowa.’ ");
INSERT INTO sny_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Meni ape peri fenesi lo wanu umasi se ta'ame su, fene meni ape Owane Sitewi lo lu feni werese ponei sahe au hene teire. Le lu feni werese lo peri wanu umasi se ta'ame su, fene Owane Sitewi lo wesi nowe ma'e ani eimawesawire. Serai fene werese meni ape ne apou a'i toterowa. ‘Meni ape lu tewi tere'e ne. Le takis ani siye meni wou a'i ne.’ ");
INSERT INTO sny_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ane peri pefine a'i fene ma'e te'esiya. Wanure! Fene yo ape ane fene ma'e tu au te'eye ape, umasiyei su, etiri werese awei sahe fene peri ta einamiyei ape, Owane Sitewi hire ma'e onusiya ape, aiwawe a'i peri ape einamirowa. Aiwawe a'i etiri werese awei sahe wiyeme toteyei su, Owane Sitewi omo hire sahe aiwawe a'i wiyeme toterowa. Mt 16:19; Jo 20:23 ");
INSERT INTO sny_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ane fene ma'e apou tame te'esiya. Lu hesi marepi ta'i a'i se etiri ta ne toteyei su, lowesi Tai ano ma'e, omo hire ma'e ironamisiya ape, etiri ape ne te'e towerirowawe, le lai lowesi ma'e aurowa. Mk 11:24; Jo 15:7 ");
INSERT INTO sny_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Lu hesi, lu hesi heta iyape ano se ta'uweraiyei su, ane lowe aiwawe ponei saro irorowa.” ");
INSERT INTO sny_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Sosu a'i pe Pita Jisas ma'e peri ta ei toweriyei ne fai. Le apou ei toweriye, “Meni Owane, meni ta ane ma'e au luwaruwenamirowawe, sosu ane ma'e si tame apou ei towerirowa, ‘Ane ne ma'e au luwaruweye, ne fara'u yo seni luwaru a'i ano i'ane arunatire.’ Eiwerou a'i ane yo seni luwaru a'i ape i'ane arunatirowa awere? Ereti feni werese feni hesi a'i i'ane arunatirowa awere?” ");
INSERT INTO sny_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Sosu Jisas le ma'e itiya'u eiye, “Ahowa, fene ereti feni werese feni hesi a'i fene yo seni luwaru a'i owe ape i'ane arunatirowa. Ane ne ma'e au te'esiya. Ne yo seni luwaru a'i lo owe ape nawite. Ne yo seni luwaru a'i mi mi pasi pasi weriyei i'ane arunatinamite. Lu 17:4 ");
INSERT INTO sny_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Serai ane nowe ape se Owane Sitewi, lu taune au noweinoweirowa ape, fene ma'e eiwerou peri anowe wou au te'esiya awere? Ane fene ma'e au te'esiya. Nowe ape se Owane Sitewi lu taune, au noweinoweirowa ape, apou wou a'i te'esiya. Awei meni owane tutawe apou toteye, ‘Ane wiyawi yahowa'i siye lu werese lo etiri neri a'i au ani erese fareraiyei ne totesiya.’ ");
INSERT INTO sny_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Sosu awei meni owane ape wiyawi yahowa'i siye meni ta'i a'i ei aniye. Meni ape etiri neri a'i erasi iroteye, Ma'aru tau tomu ne'ese (10 milion). Meni ape lai meni owane lo ma'e si itiya'u tame aurowata. ");
INSERT INTO sny_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Meni owane ape le ma'e apou eiye, ‘Ne ma'aru neri a'i werese si itiya'u aure!’ Meni ape ma'aru neri a'i si itiya'u aurowata. Serai meni owane apou au te'eye, ‘Fene nohuweripi awaripi lowe lo etiri werese aiwawe a'i lu tere'e ma'e fa ete arosawire. Fene ma'aru werese lowe lo ane ma'e aure. Serai meni ape lo ma'aru neri a'i wiyeme au ani fara'uwerowa.’ ");
INSERT INTO sny_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Wiyawi yahowa'i siye meni peri lo wanuwe su, le meni owane lo ma'e tu ereme awei sahe howeiteye. Le apou eiye, ‘Ahowa! Ne ane ne siye ferafereire. Ane ma'aru no neri a'i, werese a'i teyani irowe ape, si tame itiya'u aurowa.’ ");
INSERT INTO sny_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Sosu awei meni owane meni ape lo peri wanuwe su, le meni ape ne marepi au siye ferafereiteye. Sosu le meni ape ma'e apou eiye, ‘Ne ire! Ane ma'aru neri a'i werese teyani no i'ane arunatirowa. Ne ma'aru werese ane ma'e si tame itiya'u owe ape aure.’ ");
INSERT INTO sny_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Sosu meni ape meni owane lo wesi arunatiyewe, fi. Nowe me'iye su, meni ape wiyawi yahowa'i ani siye meni tere'e siyeri. Meni tere'e ape ma'aru neri a'i tewi oso a'i le ma'e iroteye. Ma'aru tau ereti feni hesi werese a'i le ma'e teyani a'i iroteye. Serai meni ape lai meni tere'e ape pere'i sahe anite tawesiyewe, apou eiye, ‘Ne ma'aru neri a'i werese teyani ano ane ma'e si tame itiya'u aure.’ ");
INSERT INTO sny_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Meni tere'e ape le ma'e tu ereme awei ma'e ape'e onuwewe, sosu itiya'u apou eiye, ‘Ne ane ne siye ferafereire. Ane ma'aru neri a'i werese teyani no ne ma'e si tame itiya'u aurowa.’ ");
INSERT INTO sny_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ahowa, meni ape ta'oreye a'i ne. Le meni tere'e ma'e au siye feraferei ta'ame. Le meni ape kalabus wesi ma'e eimawe arosawi. Sosu le ma'e eiye, ‘Ne kalabus wesi sahe ironamite. Ne ma'aru neri a'i werese teyani ano si itiya'u tame aurowa su, ne fara'u nowe ma'e si tame henera.’ ");
INSERT INTO sny_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Sosu wiyawi yahowa'i ani siye lu tere'e lai meni ape lo yo seni luwaru a'i siyeye su, lowe marepi orese erasi a'i tote teriteteyewe, meni owane lowe lo ma'e peri heneruwe ape ne au te'e areiyeye, eine fi. ");
INSERT INTO sny_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Sosu meni owane ape lai wiyawi yahowa'i ani siye meni lo ape ei aniyewe, le ma'e eiye, ‘Ne meni luwaru poto a'i ne. Ne ane ma'e apou eiye su, ne ane ma'e ferafereire.’ Ane ma'aru neri a'i werese teyani no i'ane arunati po'uteye. ");
INSERT INTO sny_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ane ne ma'e au ferafereiye su, serai piyene ne wiyawi kaiyemo no ape ma'e au feraferei se ta'ama. ");
INSERT INTO sny_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Meni owane ape lai wiyawi yahowa'i ani siye meni lo ma'e ai marepi erasi a'i iroteye. Serai le meni ape lu tewi kalabus wesi au noweinoweiyei ape heneti. Serai lowe meni ape ma'e fofowei erasi a'i au ironamiteye. Meni ape ma'aru werese a'i teyani meni owane lo ma'e itiya'u si tame aurowa su, serai fofowei ape po'uterowa. Mt 5:25-26 ");
INSERT INTO sny_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Aiwawe a'i fene marepi fene lo se lu taune tere'e tere'e lo yo seni luwaru a'i i'ane arunati ta'ame su, Tai ano omo hire ma'e ironamisiya ape, le fene ma'e aiwawe a'i ironamirowa.” Mt 6:15; Mk 11:25; Ef 4:32; Kl 3:13 ");
INSERT INTO sny_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Sosu a'i pe Jisas peri anowe te'e tepa'asiye su, le lu feni aiwawe a'i lowe omo pani Galili arunatiyewe, omo pani Judia, Sa'i Jordan feni eire ma'e heneri. ");
INSERT INTO sny_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Lu taune tomu ne'ese le mo'o umasiti. Omo pani ape sahe le lu taune u se ape au ta'ane fara'uweteye. ");
INSERT INTO sny_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Nowe ape se lu Farisi tamo le ma'e areareyei ne fai. Lowe le ma'e apou te'e toweriye, “Meni ta marepi sitewi yahowa'i se, tani lo tiyato ato towesi arosawiyei awere. Le tani lo tiyato ato towesi arosawiyei su, le yo peri ta arisiyei awere?” ");
INSERT INTO sny_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Sosu Jisas lowe ma'e itiya'u eiye, “Fene Owane Sitewi lo peri one towe ape sahe leseye ape, siye te'eye awere? ‘Tu naifa weriyei Owane Sitewi lai lu taune ta'aneye su, sosu le meni ta, menitani ta ta'aneye.’ ");
INSERT INTO sny_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Sosu le lowesi ma'e eiye, ‘Meni ta lai menitani ta naituweyei ne toteyei su, le tai mai lo arunatiyewe, tani lo mase nate tawesinamiyei. Lowesi tahe pa'are ta'i a'i henerairowa.’ ");
INSERT INTO sny_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Lowesi naituwei su, lowesi ta'i ta'i a'i irorowata. Ahowa, lowe tahe pa'are ta'i a'i henerairowa. Serai ane fene ma'e au te'esiya. Owane Sitewi lai lowesi lo naituwei ape au ti nate tawesiye. Lu taune werese werese naituwei lowesi lo ape tiyato ato towesi arosawirowata.” ");
INSERT INTO sny_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Sosu lowe le ma'e itiya'u te'e toweriye, “Piyene Moses apou eiye, fene tani fene lo omo lo sitewi ma'e eimawesawiyei ne toteyei su, fene one towe ta le ma'e lese aure. One towe ape apou leseye, ‘Ane tani ano naituwe tiyato ato towesi arosawirowa. Serai ane tani ano omo lo sitewi lo ma'e si eimawesawirowa.’” ");
INSERT INTO sny_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Sosu Jisas lowe ma'e apou eiye, “Tu naifa weriyei Owane Sitewi lai lu taune ta'aneye su, le apou toteye. Meni ta naituwei su, le menitani ta'i a'i naitu ti nate tawesinamiyei. Serai le menitani ape mi mi pasi pasi weriyei ironamitorowa. Fene lu kuseriye a'i ne. Serai fene ai marepi erasi a'i totenamiteyei, ‘Ane tani ano omo sitewi topo lo ma'e eimawesawiyei ne toterowa.’ Fene peri ape au te'enamiteye su, Moses one towe ape ne fene ma'e lese auwe. ");
INSERT INTO sny_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ane fene ma'e au te'esiya, fene tani yo seni wisere a'i ironamiteye ape naituwei tiyato ato towesi arosawirowawe, menitani tere'e naituwei su, fene tafa'e yo seni luwaru a'i irowei.” Mt 5:32; 1 Ko 7:10-11 ");
INSERT INTO sny_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Jisas lo lu disaipel le ma'e apou te'eye, “Nohuweripi ape yo seni eito eite ironamirowa su, Lowesi naiturowata. Lowesi yo'orei ki, wati'are ki wou a'i mi mi weriyei ironamitorowa. Etiri ape wisere a'i ne.” ");
INSERT INTO sny_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ahowa, Jisas lowe ma'e itiya'u eiye, “Ei, peri ape kairefi a'i ne. Lu taune tamo peri ano ape tote wanu umasirowata. Ahowa, Owane Sitewi lai lu taune tewi oso a'i ma'e kairefi a'i auwe. Serai lowe fara'u peri ano ape tote wanu umasirowa. ");
INSERT INTO sny_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Peri ano wanure! Lu tere'e tamo lowe naitu ta'ame ape, irosiya. Tu naifa mai lai eimane auteiye su, le tahe tou ta'ame ape, menitani ta naitu ene arowata. Lu tere'e tamo irosiya ape, meni ta foro so lowe lo ani tou fu arosawi. Lu tere'e tamo apou a'i totesiya. Ane Owane Sitewi lo wiyawi mi mi pasi pasi ironamirowa. Serai ane menitani ta naiturowata. Sosu ane Owane Sitewi lo wiyawi pefine a'i au ta'anerowa. Fene marepi ape apou wou a'i toteteye. Serai fene fara'u yo'orei ki ironamirowa.” ");
INSERT INTO sny_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Sosu a'i pe lu taune tamo eimane lowe lo Jisas ma'e au te'e wisereyeyei ne henetai. Lowe Jisas ma'e te'eye, “Ne eimane werese nomo lo ereti no se au isawe wisereyere. Sosu lowe ne Owane Sitewi ma'e ei towerire.” Ahowa, Jisas lo lu disaipel, ai peri erasi irowe ape, lowe eimane werese einamiye. Lowe eimane werese lowe lo Jisas ma'e henetairowata. ");
INSERT INTO sny_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ahowa, Jisas lowe ma'e eiye, “Fene eimane ape mo ane ma'e owe ape einamire. Lu taune eimane eito eite wou a'i Owane Sitewi lai lowe au noweinoweinamitorowa. Serai fene lowe ane ma'e ani arosa.” Mt 18:2-3 ");
INSERT INTO sny_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Sosu Jisas ereti lo se mato lowe lo sahe isawe hetesiye tepa'asiye su, le omo ape arunatiyewe, fi. ");
INSERT INTO sny_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Sosu a'i pe meni ta Jisas ma'e peri ta ei toweriyei ne fai. Le apou ei toweriye, “Atuatu siye meni, ane mi mi pasi pasi weriyei ironamitereme. Piye wiyawi wisere a'i ane eiwerou irowei awere? Serai ane mi mi pasi pasi ironamitorowa.” ");
INSERT INTO sny_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Sosu Jisas le ma'e itiya'u eiye, “‘Ne piyene ane ma'e etiri wisere a'i ne ei towerisiya awere? Owane Sitewi ta'i a'i le wisere a'i ne. Ahowa, ne marepi hepene he'i a'i anireme su, ne Moses lo yo peri werese umasinamite.’” Wkp 18:5 ");
INSERT INTO sny_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Meni ape Jisas ma'e itiya'u ei toweriye, “Owane Sitewi lo yo peri eiwerou ane fu umasinamirowa awere?” Sosu Jisas le ma'e itiya'u eiye, “‘Ne meni ta owe ape aine tera'ere. Ne naituwei owe ape tiyato ato towesire. Ne etiri ta owe ape ta'arei anite. Ne lu taune ma'e peri owe ape arearere. ");
INSERT INTO sny_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ne tai mai no lo iyape ei ani arowete. Peri lowesi lo ne wanu umasite. Topo ne ne wawesiyesiya ape, aiwawe a'i tiyati ma'e yo seni ape aiwawe a'i tote wawesiyenamite.’” ");
INSERT INTO sny_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Sosu meni yo'orei ape le ma'e itiya'u eiye, “Etiri werese ne ane ma'e au te'eye ape, ane mi mi weriyei ironamiteye. Etiri tere'e ta ane piye iro po'uteye awere?” ");
INSERT INTO sny_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jisas le ma'e eiye, “Ne yo seni aseyaro pefine a'i tote iroreme su, ne etiri werese werese no lu taune yahowa'i ma'e ani none hese erei po'utesawi. Ma'aru werese no lu taune ma'aru ariye a'i ape, ani hese erei noneyei su, ne etiri wisere a'i Owane Sitewi lo omo sahe fu ta'uwerowa. Sosu ne ane mo'o umasita.” ");
INSERT INTO sny_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ahowa, meni yo'orei peri ape wanuwe su, le marepi orese a'i teriteyewe, fi. Piyene awere? Meni ape etiri ma'aru tomu ne'ese iroteye. ");
INSERT INTO sny_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Sosu Jisas lu disaipel lo ma'e apou eiye, “Peri pefine a'i ane fene ma'e au te'esiya. Lu taune tamo etiri ma'aru tomu ne'ese ta'uwe ani fu iroteye ape, yo ape kairefi a'i umasiyei ne Owane Sitewi lo omo hire ma'e wirowa. ");
INSERT INTO sny_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Sosu ane fene ma'e apou tame au te'esiya. Fe kamel ta ipari tahe lo ni'ari lo yo papu wirowata. Aiwawe a'i lu taune tamo ma'aru etiri tomu ne'ese ta'uwe ani fu iroteye ape, lowe Owane Sitewi lo omo hire ma'e wiyei ne po'uterowa.” ");
INSERT INTO sny_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Sosu Jisas lo lu disaipel peri ape wanuwe su, lowe marepi hepene se su'ariye. Sosu le ma'e itiya'u te'e toweriye, “Sosu eiwerai Owane Sitewi lo omo hire ma'e wirowa awere?” ");
INSERT INTO sny_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Sosu Jisas lu disaipel lo ma'e atati tei siye etiyewe, lowe ma'e au te'eye, “Lu taune werese wiyawi au ani irowei ne toteyei su, lowe Owane Sitewi lo omo ma'e wirowata. Ahowa, Owane Sitewi a'i lai lu taune omo lo ma'e hene wirowa. Owane Sitewi Pefine a'i lai etiri werese werese fara'u irorowa.” Jop 42:2 ");
INSERT INTO sny_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Sosu Pita le ma'e itiya'u ei toweriye, “Siyere! Nomo etiri werese nomo lo arunatiyewe, ne ma'e mo'o umasinamiteye. Serai nomo piye etiri ta aniyei awere?” ");
INSERT INTO sny_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Sosu Jisas lowe ma'e eiye, “Peri ano pefine a'i ne. Wanure! Ane fene ma'e au te'esiya. Ei, fene werese etiri werese fene lo arunatiyewe, ane ma'e mo'o umasinamiteye. Nowe ye'ewi su, ane Tai ano lo omo hire sahe me to'u pefine a'i lo onunamirowa su, fene ereti feni hesi werese a'i lowe hesi a'i (12) me to'u sahe aiwawe a'i onurowa. Serai fene lai Israel lo niyene ereti feni hesi werese a'i lowe hesi a'i (12) yo seni lowe lo au hese ereirowa. Mt 25:31; Lu 22:30; KTH 3:21 ");
INSERT INTO sny_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Lu taune werese wesi towafi lowe lo, neme tareripi towafi lowe lo tai mai towafi lowe lo, eimane towafi lowe lo, omo sitewi towafi lo arunatirowawe, sosu wiyawi ano au ani ironamirowa su, nowe ye'ewi su lowe etiri tomu ne'ese anirowa. Sosu Owane Sitewi lai lowe ma'e au ferafereirowawe, sosu lowe marepi hepene he'i a'i se mi mi pasi pasi weriyei ironamitorowa. ");
INSERT INTO sny_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ahowa, lu taune tomu ne'ese apou a'i toteyei su, ‘Ane yaru tutawe fa henera.’ Lu taune marepi apou ape totesiya ape, lowe yaru ye'ewi henerairowa. Aiwawe a'i lu taune yaru ye'ewi irorowa su, lowe yaru tutawe henerairowa.” Mt 20:16; Lu 13:30 ");
INSERT INTO sny_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Sosu a'i pe Jisas lu disaipel lo ma'e peri anowe ta au te'eye. Le apou eiye. “Nowe ape se Owane Sitewi lu taune, au noweinoweirowa ape, apou wou a'i te'esiya. Nowe esi mitaiyeyei su, meni owane ta wiyawi ani siye lu tamo nehiyei ne fi. Lowe ta'aneyei awei ape au ta'anerowa. ");
INSERT INTO sny_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Sosu meni owane ape wiyawi ani siye lu tamo ete tepa'asiye su, le lowe ma'e eiye, ‘Fene ta'aneyei awei ano wiyawi aniyei ne ire. Nowe neriwei su, fene wiyawi ani tepa'asiyei su, ane ma'aru tau tamo a'i fene ma'e aurowa.’ ");
INSERT INTO sny_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Wiyawi ani siye lu ape mo ta'aneyei awei ma'e fi. Sosu nowe esi ponei (9 klok) meni owane ape omo nepawe ma'e fi. Le lu tamo yo sahe yahowa'i teiteye, siyeri. ");
INSERT INTO sny_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Sosu le lowe ma'e eiye, ‘Fene ta'aneyei awei ano ma'e ire. Nowe neriwei su ane ma'aru tau tamo fene ma'e aurowa.’ Sosu lu ape mo ta'aneyei awei lo ma'e wiyawi aniyei ne fi. ");
INSERT INTO sny_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Sosu poweiye ponei se, le omo nepawe ma'e si tame fi. Le lu tamo yo sahe yahowa'i teiteye, siyeri. Sosu le lowe ma'e eiye, ‘Fene aiwawe a'i ta'aneyei awei ano ma'e ire! Sosu neriwei su, ane ma'aru tewi ta fene ma'e aurowa. Le nowe poweiye wati (3 klok) si tame fiyewe, lu tere'e tamo ta'aneyei awei lo ma'e eimawesawi.’ ");
INSERT INTO sny_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Nowe ereti feni werese (5 klok) henerai su, meni owane ape omo nepawe amerame a'i ma'e fi. Le lu tamo teiteye, siyeri. Sosu le lowe ma'e ei toweriye, ‘Fene piyene poweiye mi werese yahowa'i teisiya awere?’ ");
INSERT INTO sny_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Lowe le ma'e itiya'u apou eiye, ‘Owe meni ta nomo wiyawi aniyei ne ete ta'ame.’ Sosu meni owane ape lowe ma'e eiye, ‘Sosu fene ta'aneyei awei ano ma'e wiyawi aniyei ne ire.’ ");
INSERT INTO sny_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Pasi a'i su, meni owane ape wiyawi meni owane lo ma'e apou eiye, ‘Ne lu werese ma'e ma'aru aniyei ne ei anire. Ne lu werese nowe neriwei su awei ma'e fi ape tu ma'aru aure. Sosu mo'o lu werese tere'e ma'e aiwawe a'i aure.’ Wkp 19:13; Lo 24:15 ");
INSERT INTO sny_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Wiyawi meni owane ape lu nowe ereti feni werese awei ma'e fi ape, ei aniye. Le lu ta'i ta'i a'i ma'aru tau hesi ta'i a'i lowe ma'e auwe. ");
INSERT INTO sny_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Sosu lu ape mo esi mitaiyeyei su, awei ma'e fi ape, lowe apou toteye, ‘Lu ape ma'aru tau hesi a'i aniye su, serai nomo ma'aru tomu ne'ese anirowa. Nomo esi neriwei werese wiyawi aniteye.’ Lowe ma'aru tau hesi a'i hesi a'i aniye. ");
INSERT INTO sny_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Lu ape mo ma'aru tau hesi a'i aniye su, lowe meni owane ma'e ai marepi erasi a'i toteye. ");
INSERT INTO sny_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Lowe le ma'e ai peri erasi eiye, ‘Wanure! Lu ape mo, lowe neriwei su ta'aneyei awei no ma'e wiyawi aniyei ne fi ape, lowe nowe tewi ta'i a'i wiyawi aniye. Piyene lowe ma'aru tau hesi a'i aiwawe a'i aniye awere? Nomo esi, ponei, neriwei su, poweiye umeri a'i se wiyawi erasi aniye ape nomo ma'aru tau hesi a'i aiwawe a'i aniye. Marepi no luwaru a'i tene!’ ");
INSERT INTO sny_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Sosu meni owane ape meni ape ma'e apou itiya'u eiye, ‘Ane fene ma'e etiri luwaru a'i iro ta'ame. Ahowa, ane fene esi a'i eteyei ne ei aniye su, ane fene ma'e apou eiye, fene ta'aneyei awei ano wiyawi aniyei su, ane ma'aru tau hesi a'i aurowa.’ Fene peri ano wanuwe su, fene marepi wisere a'i toteye. ");
INSERT INTO sny_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Fene ma'aru fene lo aiti. Marepi ano apou a'i totesiya, ‘Ane lu ye'ewi ape mo ma'e ma'aru tau hesi a'i aiwawe a'i au tepa'asiye.’ ");
INSERT INTO sny_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ane yo peri ta arisiye awere? Ape ta etiri werese ano ne. Ane fara'u marepi ano se umasisiyawe, lu ma'e au nonetiyei. Ane lu ape mo ma'e wisere a'i irowe su, fene piyene ane ne ai marepi totenamisiya awere? ");
INSERT INTO sny_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Serai ane fene ma'e tame au te'esiya. Lu taune tamo yaru tutawe irotereme su, lowe yaru ye'ewi irotorowa. Aiwawe lu taune tamo yaru ye'ewi irosiya su, lowe yaru tutawe henerairowa.” Mt 19:30; Mk 10:31; Lu 13:30 ");
INSERT INTO sny_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Sosu a'i pe Jisas peri anowe ape te'e tepa'asiye su, le lu disaipel lo mase omo Jerusalem ma'e iyei ne toteye. Le lu disaipel lo ereti feni hesi lowe hesi a'i (12 disaipel) eresene a'i heneti. Lowe yo sahe iteye su, le lowe ma'e apou au te'eye, ");
INSERT INTO sny_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Wanure! Nomo omo Jerusalem ma'e iyei ne. Meni ta ane, meni hire ma'e itorai ape, au heseyei lu owane tutawe tamo, Owane Sitewi lo yo peri so'oruwe siye lu tamo ma'e henetirowa. Lowe ane au hese ereirowawe, sosu lowe ane ne apou te'erowa, ‘Nomo meni ape aine tera'e temeniyerowa!’ Mt 16:21; 17:22-23 ");
INSERT INTO sny_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Sosu mo'o su au heseyei lu owane lai lu tewi tere'e ma'e Owane Sitewi lo peri umasi ta'ama ape, lowe ma'e ane henetirowa. Lu tewi tere'e tamo lai ane se peri te'e narurowa. Lowe me'iyeni ano ma'e wafei tohu se ainerowawe, ane me tape'i sahe aine ti tawesirowa. Ane temeniyerowawe, nowe hesi heta se Owane Sitewi lai ane si au ta'ane norohuwe sinerowa.” ");
INSERT INTO sny_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nowe ape se Sebedi lo tani, eimane hesi lo mase Jisas ma'e peri ta ei toweriyei ne fai. Le Jisas ma'e awei sahe lowe uporo ape'i onuwewe, le ma'e peri ta ei toweriyei ne fai. ");
INSERT INTO sny_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Sosu Jisas le ma'e ei toweriye, “Marepi no piye peri totesiya awere?” Sosu menitani ape apou ei toweriye, “Nowe ape se, ne lu taune werese au noweinoweirowa ape, ne si tame itorairowa su, ne Owane Sitewi ma'e peri kairefi a'i se apou au te'ere. Eimane hesi ano lai, ta'i me to'u sahe eyate feni no ma'e onurowa. Sosu meni eime ano tere'e me to'u sahe ereti opi feni no ma'e onurowa.” Mt 19:28; Lu 22:30 ");
INSERT INTO sny_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ahowa, Jisas lowe ma'e itiya'u apou eiye, “Fene etiri ape ne so'oru ta'ama awere? Ne fara'u siye auwe ano se sa'i asiya awere? Peri lo sitewi apou aiwawe a'i, fenesi fofowei ano teritesiya awere?” Lowe le ma'e itiya'u eiye, “Ei, nomo siye auwe no se fara'u sa'i ayei.” Mt 26:39; Jo 18:11 ");
INSERT INTO sny_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Sosu Jisas lowe ma'e itiya'u eiye, “Ei pefine! Fenesi siye auwe ano se sa'i arowa. Ahowa, me tuto'u hesi a'i ereti eyate feni sahe, ereti opi feni sahe ane aurowata. Tai ano a'i lai me to'u hesi ape lu hesi onuwei ne ariariye tepa'asiye.” ");
INSERT INTO sny_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Sosu lu feni tere'e ereti feni hesi peri ape wanuwe su, lowe lu nairi ma'e ai marepi erasi a'i toteteye. ");
INSERT INTO sny_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ahowa, Jisas lu feni werese lo le ma'e ei ta'uwe aniyewe, lowe ma'e apou eiye, “Fene awei lo marepi eito eite wou owe ape totere. Awei lu owane werese lowe ereti kairefi a'i se lu tere'e tamo ma'e au noweinoweisiya. Serai lowe iyape erasi a'i henerairowa. Aiwawe a'i awei lu owane tere'e, lowe lu owane ape ani fu ararorowa. Serai lowe iyape erasi pefine henerairowa. Lu 22:25-26 ");
INSERT INTO sny_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Fene awei lu owane ape wou ta'ama. Ahowa, fene iyape erasi a'i se heneraiyei ne toteyei su, fene wiyawi yahowa'i ani siye lu pefine a'i fa henerai. Mt 23:11; Mk 9:35 ");
INSERT INTO sny_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Serai meni ta, fene saro irosiya ape, yaru tutawe heneraiyei ne toteyei su, le fene lo wiyawi yahowa'i siye lu fa henera. ");
INSERT INTO sny_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Apou aiwawe a'i ane, meni hire ma'e itorai ape, ane hi awei ma'e lu taune ane ma'e wiyawi fa au ta'aneyei ne itorai ta'ama. Ane hi awei ma'e lu taune werese ne au temeniyeyei ne itorai. Ane lu taune tomu ne'ese ne au ferafereiyei ne itorai. Ane temeniyerowa su, ane lu taune tomu ne'ese si tame ete hene anirowa.” Lu 22:27; Fl 2:7 ");
INSERT INTO sny_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Sosu a'i pe Jisas lu disaipel lo mase omo Jeriko arunatiyewe, fi. Lu taune tomu erasi le mo'o umasiye. ");
INSERT INTO sny_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Siyere! Lu hesi nihe pokoweyei se ape yo mai tewiye saro onuteye. Lowesi Jisas yo sahe awera'iyenati ape ne wanuwe su, lowesi peri erasi a'i Jisas ma'e uteye, “Meni owane, Devit lo meni eime, ne notosi ma'e au ferafereire.” ");
INSERT INTO sny_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Lu taune werese peri lowesi lo wanuwe su, lowe lu hesi lo peri einamiyei ne toteye. Lowe lowesi ma'e eiye, “Peri sawa.” Ahowa, lu hesi peri kairefi erasi a'i tame uteye, “Meni Owane Devit lo meni eime ne notosi ne au ferafereire.” ");
INSERT INTO sny_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jisas peri lowesi lo wanuwe su, le lowesi ma'e apou ei toweriye, “Ane fenesi ma'e eiwerou irowei awere?” ");
INSERT INTO sny_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Lowesi le ma'e itiya'u eiye, “Meni Owane, ne nihe notosi lo au ta'ane petanere.” ");
INSERT INTO sny_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Sosu Jisas peri lowesi lo wanuwe su, le marepi ewiteye erasi a'i lowesi ne toteye. Serai le ereti lo se nihe lowesi lo isawe hetesiyeye. Le nihe lowesi lo isawe hetesiyeye su, witane a'i nihe lowesi lo petaneye. Serai lowesi etiri werese amerame a'i siyeteye. Lowesi Jisas aiwawe a'i mo'o umasiteye. ");
INSERT INTO sny_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Sosu a'i pe Jisas lu disaipel lo aiwawe a'i, lowe omo Jerusalem ma'e ataheyeri. Lowe omo Betfage, Omo Oliv sahe iroteye ape heneri. Sosu lowe omo Betfage heneri su, le lu feni hesi lo ei aniye. ");
INSERT INTO sny_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Le lowesi ma'e eiye, “Fenesi omo ape feni yaro ma'e ire. Fenesi omo ape wiyei su, fenesi fe donki wesi sahe wafei se ti tawesi teiyei siyeri. Fe donki ape yene lo aiwawe a'i irosiya. Fenesi lowesi lo wafei ani eraure. Sosu fenesi lowesi ane ma'e hene aita. ");
INSERT INTO sny_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Meni ta fenesi ma'e peri ta ei toweriyei su, ‘Fenesi piyene fe donki ani erausiya awere?’ Fenesi le ma'e apou itiya'u eire, ‘Meni owane notosi lo lai fe donki ape fa erau aiti ne eimawesai. Fe donki eite hire sahe onutiyei ne toteye.’ Serai witane a'i se meni ape fe donki hesi ape fenesi mase eimawesairowa.” ");
INSERT INTO sny_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Jisas peri ape au te'eye su, peri ta Owane Sitewi lo peri au te'e siye meni tu naifa weriyei leseye ape wiyeme a'i henerai. Le apou leseye, ");
INSERT INTO sny_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Fene lu taune, omo Jerusalem sahe irosiya ape, peri apou ape te'ere! Siyere. Meni owane tutawe fene lo fene ma'e aiyesiya. Le marepi fetane a'i se fe donki hire sahe onutai. Le fe donki lo yene hire sahe onutai.” ");
INSERT INTO sny_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Sosu Jisas lo lu disaipel hesi ape lai peri lo ape wanu umasiti. ");
INSERT INTO sny_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Lowesi fe donki sosu yene lo aiwawe a'i Jisas ma'e henetaiyewe, Jisas ma'e henerai su, lowesi lo ipari tahe lowesi lo fe donki lo yene lo me'iyeni hire ma'e fuwe. Sosu Jisas fe donki lo yene hire sahe onuti. ");
INSERT INTO sny_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Lu taune tomu ne'ese ipari tahe lowe lo yo mai sahe fu arowewe, hesetiteye. Lu taune tere'e me nei tomu ne'ese aine touwewe, yo mai sahe fu arowewe, hesetiteye. ");
INSERT INTO sny_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Lu taune tomu ne'ese omo Jerusalem ma'e tu iteye. Sosu Jisas fe donki me'iyeni hire sahe mo'o onutiteye. Lu taune tamo me'iye umasiti. Lowe werese peri kairefi erasi a'i apou uteye, “Nomo Devit lo meni eime ne marepi au te'e wisereye nine'isiya. Meni owane nomo lo Owane Sitewi lo iyape se fai. Fene Owane Sitewi, owane pefine a'i iyape lo ei ani arowete!” ");
INSERT INTO sny_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Sosu Jisas omo Jerusalem papu wiri su, lu taune werese omo Jerusalem iroteye ape, marepi hepene se su'ariye. Lowe apou te'e toweriye, “Meni ape eiwerai pefine a'i awere?” ");
INSERT INTO sny_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Sosu lu taune werese lai lowe ma'e itiya'u uteye, “Meni ape Jisas. Le Owane Sitewi lo peri au te'e siye meni pefine a'i ne. Le omo Nasaret, pani tewi Galili irosiya ape, ma'e fai.” ");
INSERT INTO sny_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Sosu a'i pe Jisas omo Jerusalem papu wiye su, le Owane Sitewi lo wesi tutawe papu wiye. Le lu tomu ne'ese Owane Sitewi lo wesi ape sahe etiri eteteye ape, le lu werese ape siyeye su, le lowe ma'e ai marepi erasi a'i toteteyewe, Owane Sitewi lo wesi tutawe nowe ma'e hene au sasarisawi. Lu tamo ma'aru ani ereiteye ape le metei lowe lo ani apeti teroso fiyari sasariye. Lu ape mo irowe sapuwe eteteye ape, le me to'u lowe lo ani apeti teroso sasarisawi tepa'asiye. ");
INSERT INTO sny_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Le lowe ma'e ai marepi se apou eiye, “Tu naifa weriyei Owane Sitewi lo peri au te'e siye meni apou leseye, ‘Owane Sitewi apou eiye, wesi ape wesi pefine a'i ano ne. Wesi papu sahe fene ane ma'e peri au te'e towerinamirowa. Serai wesi ano lo iyape apou te'esiya. Owane Sitewi ma'e peri au te'e wisereye nine'isiya.’ Ahowa, fene ta'arei siye lu lo wesi papu fareyareteye ape, wou henerai.” ");
INSERT INTO sny_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Le lu werese Owane Sitewi lo wesi nowe ma'e au eimawe heneye su, lu taune tamo nihe pokoweyei se ape, le nihe lowe lo au ta'ane fara'uweye. Lu taune tamo lowe nono'oweteye ape, le ma'e fai. Le lowe lo lowe au ta'ane kairefiyeye. ");
INSERT INTO sny_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ahowa, Owane Sitewi lo wesi lu owane tutawe tamo, Owane Sitewi lo peri so'oruwe siye lu tamo, lowe Jisas lo wiyawi erasi pefine a'i siyeye. Lowe eimane tomu ne'ese apou wanuwe, “Devit lo meni eime, ne nomo ma'e au ferafereiyei ne fai. Nomo ne ne marepi wisere a'i totenamisiya.” Lu tewi ape mo peri lowe lo wanuwe su, lowe ai marepi erasi a'i totenamisiya. ");
INSERT INTO sny_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Lowe le ma'e te'e toweriye, “Ne peri ape eimane uteteye ape, wanusiya awere?” Sosu Jisas lowe ma'e itiya'u eiye, “Ei, fene Owane Sitewi lo peri one towe lo sahe peri ape apou siye te'eye awere? Owane Sitewi lo peri apou te'esiya, ‘Eimane oso werese a'i, eimane osu mai lo mo'u ani asiya ape, lowe ane ne au wisereyeyei ne totesiya. Serai lowe werese ane ne au te'e wisereyenamirowa.’” ");
INSERT INTO sny_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Sosu le peri ape au te'e tepa'asiye su le lowe arunatiyewe, omo Jerusalem ma'e heneye. Le omo Betani pasi ta howeiri. ");
INSERT INTO sny_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Sosu a'i pe Jisas omo Betani sahe pasi ta howei mitaiyeyewe, sosu esi su le omo Jerusalem ma'e si tame wiri. Le lau erasi iroteye, ");
INSERT INTO sny_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Le yo mai sahe iteye su, le me owarape ta'i a'i, yo mai tewiye sahe teiteye ape, siyeye. Le me owarape ape so ani ta'eyei ne toteye su, le me owarape ma'e heneri. Me owarape henerai su, owarape so werese ariye. Towe nei a'i iroteye. Serai le me ape ma'e eiye, “Me owarape ne mi mi werese so owe ape ta'ere.” Jisas peri ape te'e tepa'asiye su, witane a'i me owarape ape foro'owe po'uteye. ");
INSERT INTO sny_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Sosu Jisas lo lu disaipel hepene se su'ariye. Sosu te'e toweriye, “Piyene me owarape witane a'i foro'oweye awere?” ");
INSERT INTO sny_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Sosu Jisas lowe ma'e itiya'u eiye, “Ane peri pefine a'i fene ma'e te'esiya. Wanure! Fene Owane Sitewi ne tote tawesisiya su, sosu marepi hesi a'i owe ape totete su, fene me owarape tere'e aiwawe a'i au ta'anerowa. Sosu aiwawe a'i fene omo ape ma'e apou te'eyei su, ‘Omo, ne sinere yaru no arunatirowawe, sa'i erasi papu onurire.’ Fene apou ape tote tawesiyei su, wiyawi erasi pefine a'i ape henerairowa. Mt 17:20; Lu 17:6; 1 Ko 13:2; Jo 14:12 ");
INSERT INTO sny_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Etiri werese, fene lai Owane Sitewi ma'e te'e toweriyei ape, Owane Sitewi lai peri no wanurowa. Fene le ne tote tawesiyei su, etiri werese fene te'e toweriyei ape, fene anirowa.” Mt 7:7-11; 18:19 ");
INSERT INTO sny_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Sosu a'i pe Jisas omo Jerusalem ma'e heneri su, Owane Sitewi lo wesi tutawe papu lu taune ma'e au atuatuwei ne wiri. Le lu taune peri lo au atuatuteye su, au heseyei lu owane tutawe tamo, awei lo lu owane tamo Jisas ma'e peri ta te'e toweriyei ne fai. Lowe le ma'e te'e toweriye, “Wiyawi erasi pefine a'i no ne, ne etiri ape mo ne iroteye ape, eiwerai ne irowei ne eimawesai awere? Eiwerai kairefi no auwe awere?” ");
INSERT INTO sny_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ahowa, Jisas lu ape mo ma'e peri ta apou eiye, “Ane peri ta fene ma'e ei towerisiya. Fene peri ano wiyeme a'i itiya'u te'eyei su, ane fara'u te'e toweriyei fene lo itiya'u te'erowa. Apou a'i eiwerai etiri ape mo irowei ne eimawesai awere? ");
INSERT INTO sny_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Jon sa'i au hu siye meni ne. Jon lu taune sa'i au huwe su, wiyawi lo ape Owane Sitewi lai ausai awere? Lu lo marepi se fai awere?” Sosu lowe peri lo ape wanuwe su, lowe te'e tiyatiteye. Lowe apou toteye, “Nomo apou eirowa su, Jon lo wiyawi Owane Sitewi lai ausai. Nomo peri ape itiya'u te'eyei su, le nomo ma'e itiya'u eirowa. ‘Piyene fene peri lo wanu tote umasi ta'ama awere?’ ");
INSERT INTO sny_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ahowa, nomo apou eirowa su, ‘Jon lo wiyawi lu lo marepi ma'e fai.’ Nomo peri ape le ma'e itiya'u eirowa su, lu taune werese nomo ne ai marepi erasi a'i totenamirowa. Piyene awere? Lu taune ape mo Jon ne Owane Sitewi lo peri au te'e siye meni totesiya. Nomo lowe atoweiyesiya.” Mt 14:5 ");
INSERT INTO sny_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Sosu lowe le ma'e itiya'u te'eye, “Jon lo wiyawi ape ne, eiwerai le ma'e au ei aniye awere? Nomo so'oru ta'ama.” Sosu Jisas lowe ma'e aiwawe a'i itiya'u eiye. “Ane aiwawe a'i fene ma'e kairefi ano eiwerou ma'e fai awere? Ane fene ma'e au te'e areiyerowata.” ");
INSERT INTO sny_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Sosu Jisas lowe ma'e peri ta tame ei toweriye. “Fene piye totesiya awere? Meni ta eimane hesi iroteye. Sosu le meni eime poto ma'e peri ta au te'eyei ne fai. ‘Ne ta'aneye awei ma'e wiyawi ta'aneyei ne ire!’ ");
INSERT INTO sny_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Meni eime poto le ma'e itiya'u eiye, ‘Ei tai, Ane awei ma'e wiyawi ta'aneyei ne irowa.’ Ahowa, le ta'aneyei awei ma'e i ta'ame. ");
INSERT INTO sny_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Sosu le meni eime Peiwe siyeri. Le apou eiye, ‘Ne ta'aneyei awei ano wiyawi aniyei ne ire!’ Ahowa, meni eime Peiwe aite lo ma'e itiya'u eiye, ‘Opiyai! Ane ta'aneyei awei ma'e wiyawi aniyei ne irowata.’ Nowe me'iye oso a'i su, le marepi orese a'i toteye. Serai le aite lo ta'aneyei awei ma'e wiyawi aniyei ne fi. ");
INSERT INTO sny_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ane fene ma'e peri ta ei towerisiya. Eimane hesi lo ape ne eiwerai aite lo marepi tote umasiye awere?” Lowe le ma'e itiya'u eiye, “Ei meni eime Peiwe aite lo marepi tote umasiteye.” Sosu Jisas lowe ma'e itiya'u eiye, “Ane peri pefine a'i fene ma'e au te'esiya. Lu tewi takis ani siye lu tamo, sosu taune tafa'e yo seni luwaru a'i se ape mo, lowe Owane Sitewi lo peri wanu tote umasiteye. Lowe yo seni luwaru a'i lowe lo me'iyeni ma'e atati arunati. Lu tewi ape mo Owane Sitewi lo omo hire ma'e tu wirowa. Fene Owane Sitewi lo peri wanuwewe, peri lo ape arisinamiteye. Serai fene Owane Sitewi lo omo hire ma'e wirowata. ");
INSERT INTO sny_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ane fene ma'e au te'esiya. Jon fene ma'e yo seni aseyaro atuatuwei ne fai. Ahowa, fene le ne tote tawesirowata. Lu ape mo takis ma'aru ani siye lu ape mo, taune tafa'e yo seni luwaru a'i se ape mo, lowe le ne tote tawesi umasiteye. Fene yo seni irowe ape, siyeye su, fene yo seni luwaru a'i fene lo me'iyeni ma'e atati arunati ta'ame. Fene yo seni luwaru a'i fene lo neritase a'i iro ta'ame. Serai fene Owane Sitewi ne tote tawesi se ta'ama.” Lu 3:12; 7:29-30 ");
INSERT INTO sny_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Sosu a'i pe Jisas lowe ma'e peri anowe tere'e ta au te'eye, Jisas apou eiye, “Peri anowe eite wanure! Meni owane ta ta'aneyei awei ta'aneye. Le tapiye fisahe ta'aneyei awei lo lo'oti yosetiteye. Le ta'aneyei awei ponei ape sahe fisiye yo horuseye. Ta'aneyei awei fisiye yo papu wiyawi ani siye lu wafei wain lo so aine tapoteye. Le wesi aite oso a'i ta ta'aneye. Serai wiyawi ani siye lu, lowe wesi aite papu onuwewe, lo ta'aneyei awei au noweinoweiteye. Sosu le wiyawi ani siye lu tamo awei lo au noweinoweiyei ne nehiti. Wiyawi ani siye lu ete tepa'asiye su, le lowe ma'e eiye, ‘Fene ta'aneyei awei ano au noweinoweite. Wain sa'i ta'uwe tepa'asiye su, ane wiyawi yahowa'i ani siye lu ano wain sa'i tewi a'i aniyei ne eimawesairowa.’ Sosu meni ape omo pani eyeri ma'e fi. Ais 5:1-2 ");
INSERT INTO sny_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Nowe me'iye su, wain sa'i ta'ane tepa'asiye su, meni owane ape wiyawi yahowa'i ani siye lu tamo awei lo ma'e wain sa'i tewi a'i aniyei ne eimawesawi. ");
INSERT INTO sny_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Wiyawi yahowa'i ani siye lu ape mo ta'aneyei awei ma'e heneri su, wiyawi ani siye lu lowe ma'e au luwaruweye. Lowe meni ta'i me au se aineye. Meni ta'i ma'e tapiye aine fusawi. Meni ta'i, lowe lai aine tera'eye. ");
INSERT INTO sny_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Sosu meni owane peri heneruwe ape wanuwe su, le wiyawi yahowa'i ani siye lu tomu ne'ese lowe ma'e wain sa'i aniyei ne eimawesawi. Wiyawi ani siye lu ape, lowe siye aniye su, lowe lu ape mo ma'e aiwawe a'i au luwaruweye. ");
INSERT INTO sny_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Sosu meni owane ape apou toteye, ‘Ane meni eime ano wiyawi ani siye lu ma'e eimawesawi. Lowe meni eime ano ne marepi wisere a'i wanu toterowa.’ ");
INSERT INTO sny_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ahowa, wiyawi ani siye lu meni owane lo meni eime siye aniye su, lowe apou te'eye, ‘Siyere! Meni owane lo meni eime fai. Nowe me'iye su, ta'aneyei awei ape topo lo pefine henerairowa. Nomo meni ape ereti se aniteyewe, le ma'e aine tera'eyei ne. Nomo meni ape aine tera'eyei su, ta'aneyei awei ape, nomo lo henerairowa.’ Mt 27:18 ");
INSERT INTO sny_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Sosu wiyawi ani siye lu lai meni owane lo meni eime ereti lo se anite tawesiyewe, ta'aneyei awei nowe ma'e ani fu arosawi. Lowe meni eime ape aine tera'eye.” Hi 13:12 ");
INSERT INTO sny_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Jisas peri anowe te'e tepa'asiye su, le lowe ma'e ei toweriye, “Meni owane ape ta'aneyei awei lo ma'e si tame henerairowa su, le lai wiyawi ani siye lu werese ma'e eiwerou irorowa awere?” ");
INSERT INTO sny_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Sosu lowe itiya'u eiye, “Le aiyerowa su, le wiyawi ani siye lu luwaru werese a'i lo ape ereti aniteyewe, sosu le lowe ma'e aine tera'erowa. Lowe werese temeniyerowa su, meni owane ape wiyawi ani siye lu tewi tere'e eteyei ne nehitirowa. Nowe me'iye henerairowa su wiyawi ani siye lu ape mo lowe meni owane ma'e wain sa'i tewi a'i si itiya'u aurowa.” ");
INSERT INTO sny_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jisas lowe ma'e ei toweriye, “Fene Owane Sitewi lo one towe sahe peri ape siye te'e ta'ame awere? Owane Sitewi lo peri apou te'esiya, ‘Me tou pefine a'i ne wesi ta'aneyei siye lu lai ani fu arosawi ape, me tou pefine ape lai wesi me tou tutawe henerairowa. Owane Sitewi lai me tou ape aniyewe, wesi lo ape me tou tutawe iro henerai. Lu taune ape mo me tou ape siyeye su, lowe apou toteye, Siyere! Meni owane pefine a'i lai, me tou ape wesi ta'aneyei siye lu ani fu arosawi po'uteye ape, le me tou wesi me tou tutawe iro henerai. Meni Owane Pefine a'i wiyawi ape ta'aneye, sosu nomo marepi wisere erasi a'i totenamisiya.’ ");
INSERT INTO sny_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Serai ane fene ma'e au te'esiya, Owane Sitewi lai kairefiyeyei fene lo, Owane Sitewi lo wiyawi au noweinoweiteye ape, ani po'uterowawe, lu tewi tere'e ma'e aurowa. Lu tewi ape mo lai Owane Sitewi lo wiyawi au noweinoweirowawe, Owane Sitewi lo marepi tote umasinamitorowa.” ");
INSERT INTO sny_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","{“Meni ta me tou ape hire sahe winetairowa su, me tou ape lai meni ape aine towesi haroharowerowa. Ahowa, me tou ape lai meni ta hire ma'e winetairowa su, meni ape awei peperi wou henerairowa. Fiyaru lai awei peperi ape fiyarisawirowa.”} ");
INSERT INTO sny_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Owane Sitewi lo wesi lu owane ape mo, lu Farisi ape mo wanuwe su, lowe apou toteye. Peri anowe ape le nomo ne au te'eye. ");
INSERT INTO sny_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Lowe Jisas ereti se anite tawesiyei ne toteye su, lowe lu taune werese ne atoweiyeye. Piyene awere? Lu taune werese Jisas ne apou toteye, “Jisas, le Owane Sitewi lo peri au te'e siye meni pefine a'i ne.” ");
INSERT INTO sny_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Sosu a'i pe Jisas lowe ma'e peri anowe tere'e tame au te'eye. Le apou te'eye, ");
INSERT INTO sny_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Nowe ape se Owane Sitewi lai lu taune au noweinoweirowa ape apou aiwawe a'i te'esiya. Awei meni owane tutawe ta apou eiye, ‘Meni eime ano naituwei ne totesiya. Ane naituwei lo ta'uwe hereiyei erasi au irorowa.’ ");
INSERT INTO sny_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ayei etiri werese ani ta'uwe opai tepa'asiye su, le wiyawi yahowa'i ani siye lu lo lu taune ma'e faiye ne eimawesawi. Ahowa, lu taune werese ta'uwe hereiyei ape aiyeyei ne ta'oreye. ");
INSERT INTO sny_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Wiyawi yahowa'i ani siye lu meni owane ma'e si tame henerai su, lowe apou eiye, ‘Lu taune werese aiyeyei ne ta'oreye.’ Sosu meni owane ape wiyawi yahowa'i ani siye lu tere'e lu taune ma'e faiye ne eimawesawiyewe, lowe ma'e eiye, Fene lu taune ape mo ma'e ane tu ei aniye ape, au te'ere, Wanure! Meni owane nomo lo ene ayei werese ani ta'uwe opai tepa'asiye. Le fe bulmakau oturei a'i nei tou opai tepa'asiye. Etiri werese ta'uwe nanei tepa'asiye. Fene werese naituwei lo ta'uwe hereiyei eite lo aiyere! ");
INSERT INTO sny_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ahowa, lu taune werese peri lo arisinamiteye. Lowe werese fiyari howeinati a'i irowe. Meni ta'i ta'aneyei awei topo lo ma'e fi. Meni tere'e ta omo tere'e ma'e etiri lo ete ta'uweyei ne fi. ");
INSERT INTO sny_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Lu taune tere'e werese, lowe meni owane lo wiyawi yahowa'i ani siye lu ma'e au luwaruweteye. Lowe wiyawi yahowa'i ani siye lu tamo aine tera'eye. Mt 21:35 ");
INSERT INTO sny_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Awei meni owane tutawe ape peri heneruwe ape wanuwe su, le ai marepi erasi a'i lowe ma'e totenamiteye. Serai le ai atu siye lu tomu ne'ese omo lowe lo ma'e yehe se taiso fuwei ne eimawesawi. Lowe lu taune ape mo wiyawi, yahowa'i ani siye lu lo aine tera'eye ape, lowe werese aine tera'e tepa'asiye. ");
INSERT INTO sny_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ai atu siye lu tamo lu taune tewi ape aine tera'eye su, lowe meni owane ma'e si fi. Sosu meni owane ape wiyawi yahowa'i ani siye lu ma'e eiye, ‘Naituwei lo ta'uwe hereiyei lo ene ayei opai tepa'asiye. Lu taune tewi ape lai ane tu ei aniye ape, lowe naituwei lo ta'uwe hereiyei aiyerowata. Lowe werese lu taune luwaru a'i ne. ");
INSERT INTO sny_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Serai fene yo teri werese ma'e irowawe, lu taune werese te'esiya. Fene siyeyei su, naituwei lo ta'uwe hereiyei ano eite ei anire.’ ");
INSERT INTO sny_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Sosu wiyawi yahowa'i ani siye lu yo teri lu taune tei ninaweyei ne fi. Lowe lu taune werese werese lowe siyeye ape ei aniteye. Lu taune tamo wisere a'i lu taune tamo luwaru a'i. Meni owane lo ta'uwe wesi teme'eriyeye. Lu taune tomu ne'ese ene ayei ne ta'uwerai. ");
INSERT INTO sny_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ahowa, meni owane ape ta'uwe wesi ape wiye su, le lu taune werese siye etiteye. Le meni ta'i naituwei lo ipari tahe ani asi ta'ame ape siyeye. ");
INSERT INTO sny_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Meni owane ape meni ape ma'e eiye, ‘Kaiyemo, Ne naituwei lo ipari tahe ani asi ta'ame. Piyene ne ta'uwe wesi ano wirai awere?’ Meni ape peri se ta'ama. ");
INSERT INTO sny_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Sosu meni owane wiyawi ani siye lu ma'e apou eiye. ‘Meni ape ereti lowe wafei se ani ti tawesire. Fene le nowe ma'e pasi a'i ani fu arosawire. Le fofowei erasi teriteyewe, pi ta'ani tawesitorowa. Le luwei erasi irotorowa.’” Mt 8:12; 25:30; Lu 13:28 ");
INSERT INTO sny_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Sosu Jisas apou eiye, Wanure! Fene peri ape ne totere. Owane Sitewi lai lu taune tomu ne'ese ei aniye. Ahowa, lu taune tewi oso a'i le lai Owane Sitewi lo omo ma'e wiyei ne ariariyeye. ");
INSERT INTO sny_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Sosu a'i pe lu Farisi tamo wesi nowe ma'e fi. Lowesi wesi tere'e ma'e te'eyei ne ta'uwerai. Lowe apou toteye, “Nomo yo ta Jisas areareyei ne te'e ani nehiyei. Sosu nomo le aine tera'erowa.” Mk 3:6 ");
INSERT INTO sny_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Sosu lowe lu feni lowe lo Jisas ma'e te'e toweriyei ne eimawesawi. Herot lo lu tewi lowe aiwawe a'i fi. Lowe Jisas ma'e henerai su, lowe le ma'e apou te'e toweriye, “Atuatu siye meni, Nomo ne ne so'oruwesiya tene! Peri werese no wiyeme a'i ne. Ne Owane Sitewi lo peri pefine a'i lu taune ma'e au te'e atuatu areiyesiya. Lu werese lai ne eterowata. Ne lu taune ne apou tote ta'ama. ‘Meni ape iyape erasi se ane le ne wiyawi anirowa. Meni tere'e ape iyape se ta'ama, Ane le ma'e ani fu ararorowa.’ Ahowa, ne marepi eito eite tote ta'ame. ");
INSERT INTO sny_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ne nomo ma'e peri ta itiya'u te'ere. Ne eiwerou totesiya awere? Nomo fara'u takis ma'aru tau awei meni owane Sisar aurowa awere. Piyete awere? Nomo takis ma'aru tamo meni owane Sisar ma'e aurowa su, nomo Owane Sitewi lo yo peri arisirowa awere? Piyete awere?” ");
INSERT INTO sny_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ahowa, Jisas marepi lowe lo siye so'oruwe tepa'asiyewe, lowe le ma'e au areareyei ne toteye. Le lowe ma'e eiye, “Piyene fene ane areareyei ne totesiya awere? Fene marepi hesiyei tote siye lu tene! ");
INSERT INTO sny_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Fene takis ma'aru tau ane ma'e ausa!” Sosu lowe ma'aru tau le ma'e aitai. ");
INSERT INTO sny_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Sosu le lowe ma'e peri ta ei toweriye, “Nihari hepene ape ne eiwerou lo awere? Iyape leseye ape eiwerou lo awere?” ");
INSERT INTO sny_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Sosu lowe le ma'e itiya'u eiye, “Sisar lo nihari hepene sosu iyape lo aiwawe a'i sato irosiya.” Sosu le lowe ma'e eiye, “Fene Sisar lo etiri Sisar ma'e si tame aure. Etiri werese Owane Sitewi lo ne, fene Owane Sitewi ma'e si tame aure!” Ro 13:7 ");
INSERT INTO sny_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Lu tewi ape mo peri ape wanuwe su, lowe hepene se su'ari hemirehemiye. Lowe le arunatiyewe, wesi towafi lowe lo si tame fi. ");
INSERT INTO sny_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Nowe aiwawe a'i se lu Sadyusi tamo Jisas ma'e peri ta te'e toweriyei ne fai. Lu tewi ape mo apou totesiya. Meni ta temeniyeye su, le si tame sinerowata. Ap 23:8 ");
INSERT INTO sny_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Lowe le ma'e apou te'e toweriye, “Atuatu siye meni, Moses apou leseye, ‘Meni ta tani lo naituwe su, lowesi eimane se ta'ama. Sosu me'iye se meni ape temeniyeye. Meni ape lo pa'ise, le airu lo tani fa naiture. Serai lowesi eimane auteirowawe, lowesi airu lo eimane ma'e wou au noweinoweinamirowa. Serai eimane werese poto lo aiwawe a'i henerairowa.’ ");
INSERT INTO sny_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Sosu meni ape nairipi ereti feni werese ereti feni hesi a'i iroteye. Meni eime Poto tani lo naituwewe, sosu temeniyeye. Eimane se ta'ama. Serai Peiwe meni lai Poto lo tani naituwe. ");
INSERT INTO sny_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Sosu meni Peiwe temeniyeye. Henei meni Poto lo tani naituwewe, sosu temeniyeye. Sosu nairipi werese Poto lo tani naituwewe, lowe werese temeniyeye. Lowe werese eimane se ta'ama. ");
INSERT INTO sny_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Sosu me'iye su, menitani ape aiwawe a'i temeniyeye. Menitani ape eimane tamo autei ta'ame. ");
INSERT INTO sny_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Serai nomo ne ma'e apou te'e towerisiya, nowe ye'ewi se, lu taune werese si tame sinerowa ape, menitani ape ne, eiwerai tani pefine naitunamirowa awere? Nairi ereti feni werese ereti feni hesi a'i awei sahe naitu tepa'asiye.” ");
INSERT INTO sny_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ahowa, Jisas lowe ma'e itiya'u eiye, “Marepi fene lo meremereye a'i ironamisiya. Fene Owane Sitewi lo peri lo sitewi so'oru ta'ama. Fene Owane Sitewi lo kairefi pefine siye so'oru ta'ama. ");
INSERT INTO sny_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Nowe ye'ewi se lu taune si tame sinerowa ape, lowe naituwei se irorowata. Lowe taune tamo eterowata. Lu taune werese Owane Sitewi lo omo hire ma'e wirowa ape, lowe Owane Sitewi lo ipari wisere a'i (ensel) wou ironamitorowa. ");
INSERT INTO sny_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Serai ane fene ma'e si tame sineyei lo peri au te'esiya. Fene Owane Sitewi lo peri one towe sahe leseye ape siye te'e ta'ama awere? Owane Sitewi lai fene ma'e apou au te'eye, ");
INSERT INTO sny_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ane a'i lai Abraham lo Owane Sitewi Pefine a'i ne. Ane Aisak lo Owane Sitewi Pefine a'i ne. Sosu ane Jakop lo Owane Sitewi Pefine a'i ne. Owane Sitewi lai, lu taune werese temeniyeye ape, au noweinowei se ta'ame. Ahowa, le a'i lai lu taune werese, hepene norohuwe se ironamisiya ape, au noweinoweinamitorowa.’” ");
INSERT INTO sny_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Lu taune werese Jisas lo peri wanuwe su, lowe hepene se su'ari hemirehemiteye. Lowe apou toteye, “Meni ape peri wisere a'i au te'e atuatusiya.” ");
INSERT INTO sny_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Sosu a'i pe lu Farisi peri heneruwe apou wanuwe su, Jisas lai lu Sadyusi lo peri ani fu ararowewe, serai lowe peri ta itiya'u te'erowata. Lowe peri se ta'ama. Lu Farisi peri ape wanuwe su, lowe Jisas ma'e ta'uwerai. ");
INSERT INTO sny_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Meni ta'i yo peri siye so'oruwe siye meni le Jisas ma'e peri areareyei ne toteye. Le Jisas ma'e apou ei toweriye. ");
INSERT INTO sny_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Atuatu siye meni. Owane Sitewi lo yo peri werese totere. Piye yo peri tutawe irosiya awere?” ");
INSERT INTO sny_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jisas le ma'e itiya'u eiye, “Ne Owane Sitewi pefine a'i no marepi werese se tote wawesiyere. Ne aiwawe a'i marepi hepene werese se le ma'e tote wawesiyere. Sosu kairefiyeyei werese no le ma'e tote wawesiyere.” ");
INSERT INTO sny_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","“Yo peri ape erasi pefine a'i tene. Yo peri ape peri tutawe henerai tepa'asiye. ");
INSERT INTO sny_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Yo peri to'uresi apou aiwawe a'i te'esiya. ‘Ne lu taune topo ne ne wawesiyeyei ape aiwawe a'i tote wawesiyenamite!’ ");
INSERT INTO sny_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Yo peri hesi ape lo sitewi Owane Sitewi lo yo peri werese werese hire ma'e ironamiteye. Owane Sitewi lo peri au te'e siye lu lo peri werese yo peri hesi ape unahi ironamiteye.” Ro 13:10; Ga 5:14 ");
INSERT INTO sny_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Sosu lu Farisi tamo ta'uwerai su, Jisas lowe ma'e peri ta apou ei toweriye, ");
INSERT INTO sny_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Le lowe ma'e apou ei toweriye, “Meni ape Krais lai, hi awei ma'e eimawe arosai ape, meni ape eiwerou lo eime awere?” Sosu lowe itiya'u eiye. “Meni ape ne Devit lo meni eime.” Jo 7:42 ");
INSERT INTO sny_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Serai Jisas lowe ma'e itiya'u eiye, “Meni ape Devit lo meni eime su, piyene Devit lai Owane Sitewi lo Hepene Wara'i a'i se meni ape apou eiye, ‘Ne meni owane ano ne.’ ");
INSERT INTO sny_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Devit peri ape apou leseye, ‘Meni owane pefine a'i lai meni owane ano ma'e eiye, Ne eyate feni ano ma'e onure. Ane airame werese fene lo, lowe no unahi fu ararore.’ ");
INSERT INTO sny_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Devit lai meni ape ne apou eiye su, ‘Ne meni owane ano ne.’ Piyene meni ape Devit lo meni eime henerai awere?” ");
INSERT INTO sny_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Lu Farisi werese Jisas lo peri itiya'u te'e ta'ame. Lowe werese le ne atoweiye iroteye. Serai lowe peri tere'e tere'e mi mi weriyei weriyei le ma'e te'e towerirowata. ");
INSERT INTO sny_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Sosu a'i pe Jisas lu taune werese ma'e lu disaipel lo aiwawe a'i apou au te'eye. ");
INSERT INTO sny_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Lu tewi ape mo, lu Farisi, Owane Sitewi lo yo peri siye so'oru siye lu tamo lowe Moses lo yaru anirowa. Lowe apou totesiya, ‘Nomo Moses aiwawe a'i ne. Nomo Moses lo wiyawi aninamirowa.’ ");
INSERT INTO sny_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Lowe fene ma'e peri ta au te'eyei su, fene fara'u peri lowe lo ape wanu umasite. Ahowa, lowe yo seni luwaru a'i ironamiteye. Serai fene yo seni lowe lo owe ape umasite. Lowe peri wiyeme tamo au te'esiya. Sosu peri wiyeme a'i, lowe au te'esiya ape, lowe umasi ta'ame. Mal 2:7-8 ");
INSERT INTO sny_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Lowe lu taune werese ma'e marepi orese a'i auwei. Ahowa, lowe marepi orese a'i fene lo ani pati anirowata. Lowe onota'ano a'i ne. ");
INSERT INTO sny_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Lowe wiyawi ta aniyei su, lowe wiyawi ape lu taune ma'e amerame a'i au atuaturowa. Lowe apou totesiya, ‘Siyere! Nomo wiyawi erasi a'i anisiya. Fene nomo ne fa au te'e wisereyete.’ Lowe Owane Sitewi lo peri one towe sahe leseyewe, sosu one towe ape mapine sahe ti tawesiteye. Lowe namo, maruwai makerapo, ipari tahe no'u a'i pere'eyesiya. Lowe etiri ape irowei su, lowe apou totesiya. Lu taune werese nomo siyerowawe, nomo ma'e au te'e wisereyerowa. Mt 6:1; Kis 13:9; Lo 6:8; Nam 15:38-39 ");
INSERT INTO sny_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Lowe ene ayei lo ta'uwe hereiyei aiyeyei su, lowe me to'u tutawe onuwei ne toteye. Lowe ta'uwe wesi ma'e wiyei su, lowe me to'u tutawe onuwei ne toteye. ");
INSERT INTO sny_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Lowe omo amerame a'i uweiteyei su, lowe apou totesiya, ‘Lu taune lai nomo ma'e weriyei weriyei fa au te'e wisereye ani arowete.’ Lu taune lowe ma'e apou te'eyei, ‘Fene atuatu siye meni nomo lo ne.’ ");
INSERT INTO sny_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ahowa, lu taune fene ne atuatu siye lu owe ape te'ete. Fene lai atuatu siye meni ta'i a'i irosiya. Atuatu siye meni ape Owane Sitewi Pefine a'i ne. Fene werese kaiyemo mo aiwawe a'i ne. ");
INSERT INTO sny_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Lu tere'e fene ma'e owe ape te'ete. ‘Ne tai ano ne.’ Fene tai pefine a'i irosiya. Owane Sitewi Pefine a'i, omo hire ma'e ironamitorowa ape, le a'i lai tai pefine a'i fene lo ne. ");
INSERT INTO sny_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Fene lu tere'e ma'e owe ape te'ere. ‘Ne meni owane ano ne. Fene meni owane pefine ta'i a'i irosiya. Meni ape Krais tene. Owane Sitewi meni ape ariariyeyewe, hi awei ma'e eimawe arosai. ");
INSERT INTO sny_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Lu tamo, iyape erasi pefine a'i irosiya ape, lowe wiyawi yahowa'i ani siye lu fene lo fa heneraire.’ Mt 20:26; Mk 9:35; Lu 22:26 ");
INSERT INTO sny_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Meni ta apou toteyei su, ‘Ane iyape erasi a'i irosiya.’ Ahowa, Owane Sitewi lai meni ape ani ararorowa. Meni ta apou toteyei su, ‘Ane meni yahowa'i ne.’ Owane Sitewi lai meni ape iyape erasi a'i ei ani arowerowa.” Jop 22:29; Snd 29:23; Lu 14:11; 18:14 ");
INSERT INTO sny_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Sosu a'i pe Jisas lu Farisi, Owane Sitewi lo yo peri so'oruwe siye lu ma'e apou eiye, “Fene werese Farisi, Owane Sitewi lo yo peri so'oruwe siye lu, fene werese marepi hesi a'i totesiya. Ane fene ma'e eisiya. Weiyai! Fene yo ape Owane Sitewi ma'e wiyei ape ti tawesisiya. Fene Owane Sitewi lo omo ma'e wi ta'ame su, fene apou totesiya, ‘Lu taune Owane Sitewi ne tote tawesi umasiteye ape, lowe lai Owane Sitewi lo omo ma'e wirowata.’ ");
INSERT INTO sny_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","{Lu Farisi, Owane Sitewi lo yo peri so'oruwe siye lu fene marepi hesi a'i totesiya ape, ane fene ma'e eiwa. Weiyai! Fene taune weiname areareteyewe, sosu wesi lowe lo fene lai ta'arei aniye. Fene lu taune ma'e areareyei ne totesiya. Serai fene peri wawero a'i Owane Sitewi ma'e pitase a'i au te'esiya. Nowe ye'ewi su, fene fofowei erasi a'i teritenamitorowa.} ");
INSERT INTO sny_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Fene, lu Farisi, Owane Sitewi lo yo peri so'oruwe siye lu, fene marepi hesi a'i totesiya ape, ane fene werese ma'e au te'esiya. Weiyai! Fene sa'i erasi toneriyewe, nawei pani iteyewe, fene meni ta'i a'i nehiti. Fene meni ape siyeye su, fene le ma'e apou eiye, ‘Ne nomo aiwawe a'i fa henera!’ Meni ape marepi fene lo tote umasiyei su, fene meni ape sepei Satan ma'e henetirowa. Serai le sepei Satan lo eimane wou henerairowa. Yo seni luwaru a'i lo, luwaru a'i tene! ");
INSERT INTO sny_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Fene meni nihe pokoweyei aiwawe a'i ne. Fene Owane Sitewi lo yo lu taune ma'e au atuatuwei ne toteyei su, fene Owane Sitewi lo yo so'oru ta'ama. Fene lowe ma'e te'esiya, ‘Fene peri te'e naneiyei ta Owane Sitewi lo wesi lo kairefiyeyei se te'eyei su, peri te'e naneiyei ape pefine ta'ama.’ Ahowa, meni ta peri te'e naneiyei ta apou eiyei su, ‘Tapiye gol lo iyape se Owane Sitewi lo wesi sahe irosiya ape, ane peri te'e naneiyei.’ Peri te'e naneiyei ape, le peri lo ape fa umasite. Mt 15:14 ");
INSERT INTO sny_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Fene meremereye a'i ne. Marepi fene lo meremereye a'i tote tawesinamisiya. Fene peri ano itiya'u te'ere. Owane Sitewi lo nihe se etiri ape mo ne fene piye tutawe totesiya awere? Tapiye gol Owane Sitewi lo wesi irosiya ape, tutawe awere? Owane Sitewi lo wesi ape lai tapiye gol aseyaro a'i au iro ta'aneye. Owane Sitewi lo wesi ape tutawe awere? Fene piye tutawe totesiya awere? Ahowa, Owane Sitewi lo wesi tutawe irosiya ape, tapiye gol ani araronamisiya. ");
INSERT INTO sny_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Meni ta apou te'eyei su, ‘Ane peri te'e naneiyei ta tapiye wari lo kairefiyeyei se au te'eyei.’ Peri te'e naneiyei ape yahowa'i ne. Ahowa, meni ta Owane Sitewi ma'e fe sipsip tapiye wari sahe aine tera'e au hese lei tisero'owei su, sosu Owane Sitewi ma'e apou te'eyei, ‘Ane ne ma'e peri te'e naneiyei ta au te'e areiyesiya.’ Peri te'e naneiyei ape kairefi a'i ne. Meni ape te'e naneiyei ape fu umasite. ");
INSERT INTO sny_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Fene marepi meremereye a'i ne. Owane Sitewi lo nihe se piye etiri hesi ape tutawe awere? Tapiye wari tutawe awere? Fe sipsip meni ape Owane Sitewi ma'e aine tera'e au hese lei tisero'owei se ape tutawe awere? ");
INSERT INTO sny_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Serai meni ta Owane Sitewi ma'e te'e naneiyei ta au te'e su, le tapiye wari se sosu fe sipsip tapiye wari hire irosiya ape aiwawe a'i se au te'e naneiyei. ");
INSERT INTO sny_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Aiwawe a'i meni ape Owane Sitewi ma'e peri te'e naneiyei ta Owane Sitewi lo wesi sahe au te'e naneiyei su, le peri te'e naneiyei Owane Sitewi lo nihe se aiwawe a'i peri te'e naneiyei. ");
INSERT INTO sny_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Aiwawe a'i meni ta Owane Sitewi lo omo hire ma'e se Owane Sitewi ma'e peri te'e naneiyei ta au te'e areiyeyei su, le Owane Sitewi aiwawe a'i, me tuto'u lo sahe onunamisiya ape, au te'e naneiyei areiyeyei. Ais 66:1; Mt 5:34 ");
INSERT INTO sny_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ane fene ma'e, lu Farisi, Owane Sitewi lo yo peri so'oruwe siye lu, fene marepi hesi totenamisiya. Ane fene ma'e eiwa. Weiyai! Fene ta'aneyei awei lo one, sawi, haiye werese wesi fene lo ani fu asiyei. Sosu fene one, sawi, haiye tewi oso a'i tamo Owane Sitewi ma'e itiya'u ani au hese ereirowa. Etiri wisere a'i ne. Ahowa, fene Owane Sitewi lo yo peri lo sitewi tote i'aneye. Lu taune fene ma'e marepi orese a'i se au hese ereiyei ne aiyerowa su, fene peri lowe lo wanu se ta'ame. Lu taune lau erasi se, fene lowe ne ewite ta'ame. Fene marepi wisere pefine a'i tote umasi se ta'ame. Etiri eite mo tutawe ne. Etiri tewi a'i ne fene Owane Sitewi ma'e au hese ereiyei ape etiri ape mo to'uresi. Ahowa, fene Owane Sitewi lo yo peri sitewi tote i'ane tepa'asiye. Wkp 27:30; Mai 6:8 ");
INSERT INTO sny_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Fene yo seni eito eite umasiyei su, fene lu nihe pokoweyei se wou a'i ne. Fene yo wisere a'i lu taune ma'e au atuatuwei ne toteyei su, fene yo wisere a'i ape siyerowata. Fene ne'i oso a'i siye auwe sa'i papu siyeyei su, fene ne'i oso a'i ape ani sasarisawiyei. Ahowa, fene etiri erasi a'i, fe kamel sa'i sahe iroteye ape, siyeyei su, fene apou totesiya, ‘Fe kamel sa'i sahe irosiya. Ane fara'u sa'i fe kamel aiwawe a'i amesi arorowa.’ ");
INSERT INTO sny_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ane fene ma'e, lu Farisi, Owane Sitewi lo yo peri so'oruwe siye lu, fene marepi hesi se totenamisiya. Ane fene ma'e eisiya. Weiyai! Fene siye auwe, plet aiwawe a'i nowe ma'e au hu noweinoweisiya. Ahowa, siye auwe, plet oro'oru papu irosiya ape unouweye. Fene siye auwe, plet wou aiwawe a'i ne. Fene ipari tahe, tu nihari ereti lowe tahe au hu noweinoweinamisiya. Lu taune fene siyeyei su, lowe apou toteyei. ‘Lu ape mo wisere a'i tene!’ Ahowa! Wawero a'i ne! Marepi hepene fene lo yo seni ta'areiyei a'i irosiya. Fene marepi towafi fene lo umasinamisiya. Mk 7:4 ");
INSERT INTO sny_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Fene Farisi nihe pokoweyei se ne. Fene tu siye auwe, plet papu au hure. Fene siye auwe, plet papu au huwei su, siye auwe, plet nowe ma'e aseyaro a'i iro heneraiyei. Ane fene ma'e eisiya. Fene marepi hepene towafi fene lo tu au fareraiyere. Marepi hepene fene lo aseyaro a'i heneraiyei su, lu taune yo seni fene lo wisere a'i siyeyei. ");
INSERT INTO sny_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ane fene ma'e lu Farisi, Owane Sitewi lo yo peri so'oruwe siye lu, fene marepi hesi se totenamisiya. Ane fene ma'e eisiya. Weiyai! Fene fisiye yo wou a'i ne. Fene fisiye yo mesu wisere a'i nowe ma'e au leseye. Lu nihe se fisiye yo ape mo wisere a'i siyesiya. Ahowa, fisiye yo papu meni tahe, pa'are a'i uwaseye ape, saro irosiya. Ap 23:3 ");
INSERT INTO sny_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Fene aiwawe a'i ne. Lu taune lai yo seni fene lo wisere a'i siyesiya. Ahowa! Wawero a'i tene! Marepi hepene fene lo hesi a'i totenamisiya. Fene yo peri werese arisinamisiya. Lu 16:15 ");
INSERT INTO sny_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ane fene ma'e lu Farisi, Owane Sitewi lo yo peri so'oruwe siye lu, fene marepi hesi se totenamisiya. Fene Weiyai! Tu naifa weriyei, ya'ariyei fene lo lai Owane Sitewi lo peri au te'e siye lu aine tera'eye. Fene lu ape mo lo fisiye yo ma'e wisere a'i au lesesiya. Lu taune tamo yo seni aseyaro a'i iroteye ape, fene fisiye yo lowe lo wisere a'i au lesesiya. ");
INSERT INTO sny_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Sosu fene apou te'esiya, ‘Nomo tu naifa iroteye su, nomo ya'ariyei nomo lo pinasu iro ta'ame. Lowe Owane Sitewi lo peri au te'e siye lu aine tera'eye. Ahowa, nomo iroteye su, nomo lowe aine tera'e ta'ame.’ ");
INSERT INTO sny_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Serai fene lai yo seni fene lo siye eti ereisiya. Lu tewi ape mo lai Owane Sitewi lo peri au te'e siye lu aine tera'eye ape, lu tewi ape ya'ariyei fene lo ne. Ap 7:52 ");
INSERT INTO sny_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Lu ape mo ya'ariyei fene lo ne. Serai fene lai orese a'i ape marepi fene lo papu ironamisiya. Marepi fene lo papu orese a'i ape teme'eriyesiya. ");
INSERT INTO sny_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Fene haru luwaru wou a'i ne. Fene hare aimesi weneri wou a'i tene! Owane Sitewi lai fene werese yehe omo ma'e eimawe arosawirowa. Serai fene mi mi pasi pasi yehe omo sahe ironamitorowa. Mt 3:7; 12:34; Lu 3:7 ");
INSERT INTO sny_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Serai ane fene ma'e Owane Sitewi lo peri au te'e siye lu tamo eimawesairowa. Ane lu tamo, marepi wisere a'i totesiya ape, fene ma'e eimawesairowa. Lu so'oruwe siye lu tamo ne, ane fene ma'e eimawesairowa. Lowe fene ma'e aiyeyei su, lowe Owane Sitewi lo peri au te'e siye lu lo fisa'i ne fene ma'e au te'e fiyari areiyerowa. Lu tewi tamo fene lai aine tera'erowa. Fene lu tamo me tape'i sahe aine tera'erowa. Ta'uweyei wesi fene lo sahe fene lu tamo wafei se ainerowa. Lu tamo fene lai omo omo werese sahe au luwaruwerowa. ");
INSERT INTO sny_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Lu taune ape mo yo seni aseyaro a'i ironamiteye ape, lu tewi ape mo aine tera'eye ape, fene orese a'i ape ne marepi papu ironamitorowa. Meni ape iyape Abel, Kein lai pa'ise Abel aine tera'eye. Fene Abel lo orese a'i ne marepi fene lo papu ironamitorowa. Aiwawe a'i meni ape Sekaraia fene Owane Sitewi lo wesi nowe ma'e ponei tapiye wari atahe a'i sahe meni ape aine tera'eye. Fene meni ape lo temeniyete ape ne marepi fene lo papu ironamitorowa. Stt 4:8; 2 Sto 24:20-21 ");
INSERT INTO sny_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ane fene ma'e eisiya. Peri ano wiyeme a'i tene! Wanure! Fene werese, pereye nowe irosiya ape, etiri ape mo fene ma'e henerairowa. ");
INSERT INTO sny_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Omo Jerusalem, omo Jerusalem fene lu taune saro irosiya ape, fene lai Owane Sitewi lo peri au te'e siye lu werese aine tera'eye. Owane Sitewi lai lu tamo fene ma'e peri lo au te'eyei ne eimawe arosai su, fene lowe tapiye se aine tera'e temeniyeye. Nowe ne'ese ane fene ei ta'uwe anireme. Apou aiwawe a'i kakaruk mai yene lo haipi unahi ma'e ei ta'uwe anisiya. Ahowa, fene peri ano wanu arisinamisiya. Fene ane ma'e aiyeyei wou ta'ama. ");
INSERT INTO sny_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Wanure! Fene peri ano wanu arisiteyei su, ane lai fene arunatirowa. Serai fene yo seni fene lo umasinamirowa. Sosu fene yehe omo sahe mi mi pasi pasi ironamitorowa. 1 Kin 9:7-8; Jer 22:5 ");
INSERT INTO sny_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ane fene ma'e eisiya fene ane tame siyerowata. Fene apou eirowa su, ‘Meni ape ma'e owane pefine lo iyape se aiyerowa ape, ane le ne au te'e wisereyenamisiya.’ Fene peri ape eirowa su, fene ane tame siyerowa.” ");
INSERT INTO sny_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Sosu a'i pe Jisas lu disaipel lo mase Owane Sitewi lo wesi nowe ma'e henerai. Lu disaipel lo Jisas ma'e Owane Sitewi lo wesi werese au atuatuwe apou te'eye, “Owane Sitewi lo wesi werese ape, siyere! Wesi werese wisere a'i tene!” ");
INSERT INTO sny_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Sosu Jisas lowe ma'e itiya'u eiye, “Wesi werese, siyere! Peri ano wanure! Peri ano wiyeme a'i tene! Nowe me'iye su wesi werese ape tapeti po'uterowa. Lowe tapiye werese ani towesi sasarisawirowa. Wesi werese ape tapeti po'uterowa.” Lu 19:44 ");
INSERT INTO sny_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Sosu a'i pe Jisas Omo Oliv ma'e yaneye. Le saro onuwe su, lu disaipel lo eresene a'i se le ma'e peri ta te'e toweriyei ne fai. Lowe apou te'e toweriye, “Meni owane, Ne peri ape nomo ma'e itiya'u eire! Eiwerou su etiri ape henerairowa awere? Ne si tame aiyerowa su, piye yaru nomo siyerowa awere? Nowe ye'ewi aiyerowa su, piye yaru nomo siyerowa awere? Eiwerou su awei eite po'uterowa awere?” ");
INSERT INTO sny_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Sosu Jisas lowe se itiya'u eiye, “Fene Weiyai! Lu tamo fene owe ape arearere! ");
INSERT INTO sny_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Lu tomu ne'ese iyape ano se aiyerowa. Lowe apou au te'e fiyarirowa, ‘Ane a'i lai meni tutawe, Owane Sitewi hi awei ma'e eimawe arosai.’ Lowe lu taune tomu ne'ese au arearerowa. Lu taune peri lowe lo wanurowa su, lowe lu ape mo tote umasirowa. Mt 24:23-24; 1 Jo 2:18 ");
INSERT INTO sny_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Fene ai atuwei erasi a'i lo no'u wanurowa. Omo tere'e tere'e ape sahe, fene ai atuwei lo peri heneruwe wanurowa. Fene etiri ape mo wanurowa su, fene owe ape atoweiyere. Nowe ye'ewi ataheye se ta'ama. Etiri ape mo ai atuwei erasi a'i ai atuwei lo no'u lu tamo iyape ano se lu taune au arearerowa ape tu henerairowa. ");
INSERT INTO sny_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Pani tewi lo ai atu siye lu, lowe pani tewi tere'e lo ai atu siye lu ma'e ai atu tiyatinamirowa. Lu tewi tamo lu tewi tere'e ma'e ai atunamirowa. Omo tere'e tere'e sahe ene ayei werese ariye po'uterowa. Omo tomu ne'ese sahe awe erasi a'i omo werese auseriyerowa. ");
INSERT INTO sny_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ahowa, fene etiri ape mo siyerowa su, fene etiri ape apou siye so'oruwerowa. Nowe ye'ewi ataheyerowa. Apou wou a'i ne, menitani ta eime lo autei ataheyeyei su, le lire papu fofowei erasi teriteyei. ");
INSERT INTO sny_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Lu tamo fene ma'e au luwaruweyei ne henetirowa. Lowe fene tamo aine tera'erowa. Fene iyape ano anite tawesi umasisiya su, lu taune tomu ne'ese omo omo werese sahe fene ma'e ai marepi totenamirowa. Mt 10:22 ");
INSERT INTO sny_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Nowe ape se lu taune tomu ne'ese iyape ano umasiteye ape, lowe marepi orese a'i teriterowa su, lowe peri ano arisiterowawe, ane ma'e me'iyeni atati arurowa. Lowe lu feni ano lu owane ma'e etiyei ne henetirowa. Lowe lu feni werese ano ai marepi totenamirowa. ");
INSERT INTO sny_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Peri wawero a'i au te'e siye lu tomu ne'ese henerairowa. Lowe lai lu taune tomu erasi au te'e arearerowa. Lu taune tomu ne'ese peri wawero a'i ape wanurowa su, lowe peri ape wanu tote umasirowa. Mt 24:5,24; 1 Jo 4:1 ");
INSERT INTO sny_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Nowe ape se lu taune werese werese yo seni luwaru a'i ironamirowa. Serai lowe lu taune tere'e ma'e tote wawesiyerowata. ");
INSERT INTO sny_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ahowa, lu taune iyape ano me'iyeni ma'e atati arunati ta'ame su, mi mi werese kairefi a'i teinamirowa su, nowe ape se tai ano lowe ferafereirowawe, omo lo ma'e henetirowa. Mt 10:22 ");
INSERT INTO sny_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Sosu lu feni ano lai peri heneruwe wisere a'i ano omo omo werese ma'e au te'e fiyari areiyerowa. Lowe peri ano lu taune ma'e omo omo werese sahe irorowa ape, lowe ane ne au te'e fiyari areiye tepa'asirowa su, me'iye su, nowe ye'ewi henerairowa.” Mt 28:19 ");
INSERT INTO sny_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Serai meni luwaru pefine a'i henerairowa. Meni ape henerairowa su, le etiri luwaru a'i pefine Owane Sitewi lo wesi sahe au teirowa. Meni ape etiri ape Owane Sitewi lo wesi sahe au teirowa su, fene etiri ape siyerowa. Tu naifa weriyei Owane Sitewi lo peri au te'e siye meni iyape Daniel meni ape ne leseye. Fene peri ape siye te'eyei su, fene etiri ape ne wanu so'oruweyei. Dan 9:27; 12:11 ");
INSERT INTO sny_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Etiri ape henerairowa su, lu taune werese omo pani Judia irorowa ape, witane a'i se omo hire ma'e itero yanerowa. ");
INSERT INTO sny_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Lu taune tamo naretei wesi a'i sahe onu fetane irotorowa su, lowe witane se iteroti. Lowe wesi towafi lowe lo papu etiri ta'uweyei ne wi ta'ame. Lu 17:31 ");
INSERT INTO sny_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Lu taune tamo ta'aneyei awei sahe ta'aneteyei su, lowe wesi towafi lowe lo ipari tahe lowe lo aniyei ne si tame iro ta'ame. ");
INSERT INTO sny_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Taune tamo, eimane tahe se irorowa ape, fene marepi orese erasi a'i teriterowa. Fene Weiyai! Taune tamo, eimane ma'e mo'u au arowa ape, fene weiyai! Fene marepi orese a'i teriterowa. ");
INSERT INTO sny_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","21","Nowe ape se fofowei luwaru erasi a'i henerairowa. Tu naifa weriyei weriyei lu taune werese fofowei luwaru erasi a'i eito eite terite ta'ame. Fofowei luwaru erasi ape etiri fofowei werese tere'e ani fu araronamiteye. Nowe me'iye su, fofowei eito eite tame irotorowata. Serai fofowei luwaru erasi ape henerairowa su, fene Owane Sitewi ma'e apou te'e towerire! ‘Owane Sitewi ne fofowei erasi ape Owane Sitewi lo nowe wara'i a'i se, nowe naretei a'i se owe ape au arosa.’ Nowe amou (Sabat) se, nowe naretei a'i se henerairowa su, nomo witane a'i iterotirowata. Dan 12:1 ");
INSERT INTO sny_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Nowe ape se Owane Sitewi lai fofowei luwaru a'i erasi a'i einami ta'ame su, lu taune eimane werese temeniyerowa. Serai Owane Sitewi lu taune lo ariariyeye ape ne, le lai fofowei erasi ape einamirowa. ");
INSERT INTO sny_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Sosu lu taune tamo fene ma'e apou te'erowa su, ‘Siyere! Meni ape Krais Owane Sitewi lai hi awei ma'e eimawe arosai ape irosiya.’ Wawero a'i tene. Fene peri lowe lo owe ape tote umasire. Mt 24:5 ");
INSERT INTO sny_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Lu tomu ne'ese fene ma'e henerairowa. Lowe peri wawero a'i apou au te'e fiyarirowa, ‘Ane meni ape, Krais, Owane Sitewi hi awei ma'e eimawe arosai.’ Peri wawero a'i au te'e siye lu tomu ne'ese henerairowa. Lowe wiyawi erasi pefine a'i lu taune ma'e au atuaturowa. Lowe yaru erasi pefine a'i lu taune ma'e au atuaturowa. Lowe lu taune tomu ne'ese au te'e arearerowa. Lu feni ano Owane Sitewi tu naifa ariariyeye ape, lowe lai marepi lowe lo tore tatai anirowawe, lowe lu feni ano areareyei ne toterowa. Fene wiyawi lowe lo siyerowa su, fene peri lowe lo owe ape umasire. Lo 13:1-3; 2 Te 2:8-9; KTH 13:13-14 ");
INSERT INTO sny_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Fene peri ano wanu etire! Ane pereye nowe fene ma'e etiri ape mo ne au te'e tepa'asiye. Etiri ape mo henerai se ta'ame ne. Nowe me'iye su, etiri werese ape mo wiyeme a'i henerairowa. ");
INSERT INTO sny_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Serai lu tamo fene ma'e te'eyei su, ‘Siyere! Meni ape Owane Sitewi ariariye eimawe arosai ape, le ipo ma'e irosiya.’ Fene le ipo ma'e nehiyei ne owe ape ire! Aiwawe a'i lowe fene ma'e apou te'eyei su, ‘Siyere! Meni ape wesi papu onusiya!’ Weiyai! Fene peri lowe lo owe ape tote tawesi umasire. Lu 17:23-24 ");
INSERT INTO sny_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ane meni ape hire ma'e itorai ape, si tame aiyerowa su, ane eresene fareyareye a'i itoraiyei ta'ama. Ahowa, ane si tame itorairowa su, ane pesiyei mera'o wou a'i itorairowa. Lu taune werese mera'o erasi hire ma'e siyerowa. Mera'o ape omo pani werese werese tei mitaiyerowa. Ane aiwawe a'i ne. Ane si tame itorairowa su, lu taune werese omo werese sahe ane se siye so'oruwerowa.” Sosu Jisas peri anowe ta apou te'esiya. Mt 24:37-39 ");
INSERT INTO sny_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Fene irowe yaruwapi totere. Meni ta ipo sahe temeniyeyei su, irowe yaruwapi meni ape lo heneri somu siyerowa. Lowe werese meni ape ene ayei ne ta'uwe sine itorairowa.” Lu 17:37 ");
INSERT INTO sny_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Fene peri ano wanure! Nowe orese fofowei luwaru erasi a'i tepa'asirowa su, witane a'i poweiye ape pasi a'i henerairowa. Yame lo mi aiwawe a'i po'uterowa. Eiwariyemi werese ni'arawe ma'e winetairairowa. Etiri werese, hire ma'e ironamirowa ape erasi a'i auserinamirowa.” ");
INSERT INTO sny_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Etiri werese hire ma'e auserinamirowa su, ane, meni ape hire ma'e itorai ape, si tame itorairowa su, yaru ano ni'arawe ma'e henerairowa. Lu taune eimane werese, omo omo pani werese sahe irosiya ape, etiri ape mo siyerowa su, lowe erasi a'i atoweiyerowa. Sosu lowe luwei erasi a'i ironamitorowa. Ane meni ape hire ma'e itorai ape, ni'arawe ma'e itorairowa. Ane ni'arawe ma'e itoraiyei su, lowe werese ane si tame siye anirowa. Ane kairefiyeyei erasi se, sosu mi wara'i a'i mase itorairowa. Sek 12:10; KTH 1:7; Dan 7:13 ");
INSERT INTO sny_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ane si tame itorairowa su, ane Owane Sitewi lo ipari wisere a'i (ensel) omo omo werese ma'e eimawesawirowa. Lowe metaiyei erasi a'i ainerowa. Lowe lu taune eimane werese werese peri ano umasinamirowa ape, hene ta'uwe anirowa. Lu feni ano omo werese sahe poweiye wirai siye ma'e, omo werese sahe poweiye itori siye ma'e, lu feni ano omo werese eyate feni ma'e irorowa ape, lu feni ano omo werese opi feni ma'e irorowa ape, Owane Sitewi lo ipari wisere a'i (ensel) lowe werese hene ta'uwe anirowa.” 1 Ko 15:52; 1 Te 4:16 ");
INSERT INTO sny_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Sosu a'i pe Jisas lu feni lo ma'e apou eiye, “Fene me owarape lo peri anowe wanure. Fene peri anowe lo sitewi wanu so'oruwere. Me owarape lo me nei he'i a'i siyeyei su, towe lo ataheyewa. Fene towe he'i a'i siyeyei su, fene apou totesiya. Nowe ape se me ape so atahe a'i ta'eyei. ");
INSERT INTO sny_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Aiwawe a'i ne. Fene etiri werese, ane fene ma'e au te'e areiyeye ape, siyeyei su, fene siye so'oruwe tepa'asiye. Ane yo ma'e tei ataheyewa. Nowe ape se ataheye heneraiwa. ");
INSERT INTO sny_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ane fene ma'e apou te'esiya. Wanure! Juda lo lu tewi ape tamo, sato irosiya ape, lowe temeniyerowata. Ahowa, tu etiri werese ape, ane fene ma'e au te'eteye ape, henerairowa su, sosu mo'o lu tewi ape tamo fara'u temeniyerowa. Mt 16:28 ");
INSERT INTO sny_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Etiri werese, hire sahe irosiya ape, etiri werese, omo pani sahe irosiya ape, etiri werese ape mo po'uterowa. Ei etiri werese ape mo po'uterowa. Ahowa, peri werese ano po'uterowata. Ahowa, peri ano mi mi pasi pasi ironamitorowa. Mt 5:18 ");
INSERT INTO sny_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Eiwerou su nowe ape henerairowa awere? Lu taune werese werese so'oru ta'ama. Aiwawe a'i Owane Sitewi lo ipari wisere a'i (ensel), hire sahe irosiya ape, lowe aiwawe a'i nowe ape so'oru ta'ama. Ane Owane Sitewi lo meni eime aiwawe a'i nowe ape so'oru ta'ama. Tai pefine ta'i a'i le nowe ape so'oruwesiya tene! Ap 1:7; 1 Te 5:1-2 ");
INSERT INTO sny_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","38","Fene meni Noa totere! Nowe ape se tu naifa weriyei, lu taune werese ene ateye, sa'i ateye, lowe taune naituwe, taune lu naitu ene a wisereyeteye. Sosu nowe ta se meni Noa wai wesi erasi papu wiri. Meni ape wai wesi papu wiye su, Owane Sitewi lai aitu werese au peratiye. Mi pasi tomu ne'ese (40) sa'i itorai. Omo awei pani werese ani aporuwe. Aiwawe a'i ane, meni ape hire ma'e itorai ape, si tame itorairowa su, lu taune werese yo seni apou ape aiwawe a'i ironamirowa. Ane witane a'i itorairowa. Stt 6:5-8 ");
INSERT INTO sny_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Nowe ape se lu taune werese Owane Sitewi lo peri siye so'oru ta'ama. Sa'i omo pani ani aporu po'uteye su, lowe siye so'oruweye. Sa'i ei erasi ape lu taune eimane werese aiti. Lowe sa'i atenise temeniyeye. Aiwawe a'i ane meni ape hire ma'e itorai ape, si tame itorairowa su, nowe ape aiwawe wou a'i ne. Stt 7:21-23 ");
INSERT INTO sny_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Sosu lu hesi ta'aneyei awei sahe iroteyei su, Owane Sitewi lai meni ta'i hene ani wirowa. Heta awei saro arunatirowa. ");
INSERT INTO sny_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Taune hesi tamo nau taineteyei su, Owane Sitewi lai menitani ta'i hene ani wirowa. Menitani ta'i saro arunatirowa. ");
INSERT INTO sny_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Serai fene werese nowe ape se ane, Meni Owane Pefine fene lo si tame itorairowa su, fene siye ninawe etinamite. Le si tame itorairowa su, nowe ape fene so'oru ta'ama. Mt 25:13 ");
INSERT INTO sny_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Fene ta'arei meni ne totere. Eiwerou su ta'arei meni wesi tapeti wiyei su, meni owane ape wesi topo lo siye noweinowei etirowa. Meni owane ape wesi topo lo au noweinoweiteye su, ta'arei meni ape wesi ape ani tapeti wirowata. Lu 12:39-40; KTH 16:15 ");
INSERT INTO sny_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Serai fene aiwawe a'i fu au noweinoweinamite. Ane, meni ape hire ma'e itorai ape, si tame itorairowa su, eiwerou su itorairowa awere? Lu taune werese so'oru ta'ama. ");
INSERT INTO sny_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Sosu a'i pe Jisas peri anowe ta apou te'eye. Le apou au te'eye. Meni owane ta omo pani eyeri ma'e iyei ne toteye. Le wiyawi yahowa'i a'i siye meni marepi wisere a'i se au ariariyeye. Le ma'e eiye, ‘Ne lu taune werese wesi ano howeisiya ape au noweinoweite. Ne ene ayei mi mi werese ta'uwere. Lowe ma'e au ene are!’ ");
INSERT INTO sny_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Meni owane si tame aiyeyei su, Wiyawi ani siye meni peri lo wanu umasinamirowa. Le lu tewi owane lo au noweinoweinamiteye. Wiyawi ani siye meni marepi wisere a'i totenamirowa. ");
INSERT INTO sny_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Peri ano pefine a'i tene! Ane fene ma'e au te'esiya. Meni owane wiyawi ani siye meni siyeyei su, le le ma'e apou eiye, ‘Ne lu taune, wesi ano howeiteye ape, au noweinowei tepa'asiye su, ane etiri werese werese ano ne ma'e au noweinoweiyei ne aurowa.’ Mt 25:21,23 ");
INSERT INTO sny_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Fene wiyawi ani siye meni luwaru a'i ne totere. Wiyawi ani siye meni luwaru a'i apou toteyei, ‘Meni owane ano omo pani eyeri ma'e fi. Le witane a'i se si tame aiyerowata.’ ");
INSERT INTO sny_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Serai wiyawi ani siye meni ape le wiyawi ani siye lu tere'e ma'e wafei se aineye. Le lu luwaru a'i mase ene ateye, lowe mase sa'i meremereye a'i ateye. ");
INSERT INTO sny_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Nowe ta se meni owane lo si tame aiyerowa su, le wiyawi ani siye meni luwaru a'i siyerowa. Eiwerou su, meni owane lo si tame aiyerowa awere? Le nowe ape meni owane si tame aiyerowa ape so'oru ta'ama. Meni owane eresene a'i se si tame aiyerowa. ");
INSERT INTO sny_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Meni owane si tame aiyerowa su, le wiyawi siye meni luwaru a'i ma'e fofowei erasi a'i aurowa. Le meni ape yehe omo ma'e lu taune marepi hesi aiwawe a'i ironamirowa ape, eimawe arosawirowa. Le omo ape sahe lu taune werese fofowei erasi a'i teriterowa. Lowe luwei erasi a'i ironamirowa. Lowe ahi pi fekeke ne tawesinamitorowa.” ");
INSERT INTO sny_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Sosu a'i pe Jisas peri anowe ta lowe ma'e au te'eye. “Nowe ape se Owane Sitewi lai lu feni lo au noweinoweirowa ape piye te'esiya awere? Taune wati'are ereti feni hesi werese, lowe naituwe lo meni owane siyeyei ne fi. Lowe yehe erei mase aiti. KTH 19:7; Lu 12:35 ");
INSERT INTO sny_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Taune ereti feni werese, lowe marepi luwaru a'i toteteye. Lowe yehe erei tere'e mase aiti ta'ame. Taune tere'e ereti feni werese, lowe marepi wisere a'i toteye. Lowe yehe erei tere'e tamo mase aiti. ");
INSERT INTO sny_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Sosu lowe werese naituwei lo meni owane ninawe ninaweteye. Naituwei meni owane eiwerou su aiyeyei awere? Sosu taune werese nihe teiteye. ");
INSERT INTO sny_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ahowa, pasi ponei su, lowe peri erasi a'i wanuwe. ‘Mao! Naituwei lo meni owane ataheyewa. Fene le nowe ma'e siyeyei ne aiya.’ ");
INSERT INTO sny_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Taune werese peri ape wanuwe su, lowe witane a'i sineyewe, yehe erei ani ta'uwe naneiteye. ");
INSERT INTO sny_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Sosu taune ereti feni werese marepi luwaru a'i toteye ape, lowe taune tere'e, marepi wisere a'i toteye ape, ma'e te'e toweriyei ne fai. ‘Fene yehe erei tewi a'i fene lo nomo ma'e ausa! Yehe erei nomo lo ti te'eye po'uteye.’ ");
INSERT INTO sny_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ahowa, taune marepi wisere a'i toteye ape, lowe ma'e itiya'u eiye, ‘Piyete! Yehe omo erei tewi a'i feni ma'e auwei su, yehe erei nomo lo aiwawe a'i te'eye po'uteyei. Fene ipo ma'e yehe erei nehiyei ne ire!’ ");
INSERT INTO sny_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Sosu taune marepi luwaru a'i ipo ma'e yehe erei he'i a'i nehiyei ne fi. Lowe fi su, naituwei meni owane witane a'i fai. Taune marepi wisere a'i toteye ape, lowe meni owane ape mase wesi papu ta'uwe hereiyei ene ayei ne wiye. Lowe werese wesi papu wiye su, lowe wesi yo ti tawesiye. ");
INSERT INTO sny_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Nowe me'iye su, taune marepi luwaru a'i se si tame fai. Lowe wesi ape yo sahe aineye. Apou uteye, ‘Owane, Nomo si tame fai. Yo ape tosore!’ Lu 13:25-27 ");
INSERT INTO sny_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ahowa, meni owane lowe ma'e itiya'u eiye, ‘Ane fene ma'e eisiya. Ane fene so'oru ta'ama. Fene ire!’ Mt 7:23 ");
INSERT INTO sny_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Sosu ane fene ma'e eisiya. Fene werese siye ninawe noweinoweite. Nowe ape se ane si tame aiyerowa su, fene so'oru ta'ama. Mt 24:42 ");
INSERT INTO sny_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Fene peri anowe tere'e wanure! Meni owane ta omo pani eyeri ma'e iyei ne toteye. Le wiyawi yahowa'i ani siye lu werese ei aniye. Le lowe ma'e eiye, ‘Fene etiri werese ano au noweinoweite.’ ");
INSERT INTO sny_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Le wiyawi meni ta'i ne apou toteye, ‘Meni ape marepi wisere a'i totenamisiya. Ane meni ape ma'aru ereti feni werese le ma'e auwei.’ Le wiyawi ani siye meni tere'e ape ne apou toteye, ‘Meni ape marepi kairefi se ta'ame. Ane meni ape ma'e ma'aru hesi a'i auwei.’ Sosu le wiyawi ani siye meni tere'e ei aniye. Le meni ape ne apou toteye. ‘Meni ape marepi onota'ano a'i ne. Ane ma'aru ta'i a'i le ma'e auwei.’ Sosu le ma'aru werese wiyawi ani siye lu ma'e au tepa'asiye su, le omo pani eyeri ma'e fi. Ro 12:6 ");
INSERT INTO sny_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Sosu wiyawi ani siye meni, ma'aru ereti feni werese aniye ape, le wiyawi tohote aniteye. Serai ma'aru lo ereti feni werese tere'e aniye. Serai le ma'aru ereti feni hesi werese anite tepa'asiye. ");
INSERT INTO sny_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Sosu aiwawe a'i wiyawi ani siye meni tere'e ma'aru hesi a'i aniye ape, le ma'aru hesi a'i wiyawi ani tohoteye. Sosu meni ape ma'aru hesi a'i tere'e aniyei. Serai meni ape ma'aru hesiyo hesiyo ereti anite tepa'asiye. ");
INSERT INTO sny_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ahowa, wiyawi ani siye meni tere'e, ma'aru ta'i a'i aniye ape, le apou toteye, ‘Ane ma'aru ta'i a'i auwei yo papu horuse fareyareteye. Serai meni owane ano si tame aiyerowa su, ane ma'aru lo le ma'e si tame aurowa.’ ");
INSERT INTO sny_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Sosu a'i pe wiyawi ani siye lu lo meni owane si tame fai. Le wiyawi ani siye lu werese ei aniye. Le ma'aru lo siye etiyei ne toteye. ");
INSERT INTO sny_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Sosu le wiyawi ani siye meni ma'aru ereti feni werese aniye ape, ei aniye. Meni ape meni owane lo ma'e henerai su, le le ma'e eiye, ‘Siyere! Ane ma'aru ereti feni werese no aitiyewe, wiyawi ani tohoteteye. Serai ane ma'aru ereti feni werese tere'e anitesiya. Ne ma'e si auwei.’ ");
INSERT INTO sny_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Sosu meni owane le ma'e itiya'u eiye, ‘Pefine a'i tene. Ne meni wisere a'i tene! Ne etiri oso a'i ano au noweinowei tepa'asiye. Serai ane ne ma'e etiri tomu ne'ese ano au noweinoweiyei ne auwei. Serai notosi marepi wisere a'i ironamitorowa.’ Mt 24:45-47; Lu 16:10 ");
INSERT INTO sny_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Sosu meni owane ape wiyawi ani siye meni tere'e, ma'aru hesi a'i auwe ape, ei aniye. Wiyawi ani siye meni ape henerai su, le owane lo ma'e eiye, ‘Meni owane, Siyere! Ne ma'aru hesi a'i ane ma'e auwe. Ane ma'aru no aitiyewe, wiyawi ani tohoteye. Sosu ane ma'aru hesi tere'e ne ma'e auwei ne fai.’ ");
INSERT INTO sny_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Sosu meni owane lo le ma'e itiya'u eiye, ‘Pefine a'i tene! Ne meni wisere a'i tene! Ne etiri oso a'i ano au noweinowei tepa'asiye. Serai ane ne ma'e etiri tomu erasi ano au noweinoweiyei ne auwei. Serai notosi marepi wisere a'i ironamitorowa.’ ");
INSERT INTO sny_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Sosu mo'o meni owane ape wiyawi ani siye meni tere'e ei aniye. Meni ape meni owane lo ma'e henerai su, le, le se eiye, ‘Meni owane, ane marepi no so'oruwe tepa'asiye. Ne meni marepi kairefi luwaru a'i ne. Ne etiri tomu ne'ese ta'aneyei awei tere'e ma'e ani ta'uwerai. Ne lu tere'e lo me so asiye. Ane ne ne atoweiyesiya. ");
INSERT INTO sny_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Serai ane ne ne erasi a'i atoweiye. Sosu ane ma'aru ta'i a'i no awei yo papu horuse fareyareye. Siyere! Ane ma'aru ta'i a'i no ne ma'e si tame auwei ne fai.’ ");
INSERT INTO sny_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ahowa, meni owane ape itiya'u eiye. ‘Piyene awere? Ne meni luwaru a'i tene! Ne meni onota'ano a'i tene! Ne marepi ano so'oruwe tepa'asiye. Ane etiri tomu ne'ese ta'aneyei awei tere'e ma'e ani ta'uwerai. Ane lu tere'e lo me so asiya. ");
INSERT INTO sny_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Sosu ne piyene ma'aru ta'i a'i ano ma'aru wesi papu aiti ta'ame awere? Serai ane si tame aiyeyei su, ane ma'aru tewi oso a'i tere'e anirowa. ");
INSERT INTO sny_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Serai ane ma'aru ta'i a'i ano aniyei. Ane wiyawi ani siye meni, ereti feni hesi (10) werese aniteye ape, le ma'e auwei.’ ");
INSERT INTO sny_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Lu taune tamo wiyawi ani tohoterowa ape, lowe etiri ma'aru tere'e tamo ani ta'uwerowa. Serai lowe etiri ma'aru tomu ne'ese irorowa. Ahowa, lu taune tamo onota'ano a'i ape, etiri lowe lo ape irosiya ape, ane etiri lowe lo ape mo aniyewe, lu taune tere'e ma'e aurowa. Mt 13:12; Mk 4:25; Lu 8:18 ");
INSERT INTO sny_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Meni onota'ano a'i ape omo pasi wiyeme a'i ma'e ani fu arosawire. Omo ape sahe lu taune werese luwei erasi a'i ironamitorowa. Lowe fofowei erasi luwaru a'i teriterowawe, lowe pi towafi lo ta'ani fekekeniye ironamitorowa.” Mt 8:12; Lu 13:28 ");
INSERT INTO sny_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Ahowa, ane, meni hi awei ma'e itorai ape, mitaiyeyei erasi se si tame itorairowa. Ane Owane Sitewi lo ipari wisere a'i (ensel) mase aiwawe itorairowa. Ane a'i lai meni owane tutawe lo me to'u onunamitorowa. Mt 16:27; 19:28 ");
INSERT INTO sny_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","33","Lu taune werese omo werese sahe le ma'e ta'uwerowa. Le a'i lai lowe ponei teiyewe, lowe ma'e au hese ereirowa. Lu taune werese Jisas lo iyape umasinamiteye su, lowe ereti eyate feni ma'e au ei teirowa. Lu taune werese lo yo seni luwaru a'i ironamiteye ape, le lowe ereti opi feni ma'e au ei teirowa. Le apou a'i irorowa. Fe sipsip aiwawe a'i ereti eyate feni ma'e ani furowa. Sosu fe meme ape aiwawe a'i ereti opi feni ma'e ani furowa. Ese 34:17; KTH 20:11-13 ");
INSERT INTO sny_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Sosu meni owawe tutawe lu taune ma'e ereti eyate feni sahe irorowa ape, lowe ma'e eirowa, ‘Fene Owane Sitewi lai marepi wisere a'i fene ma'e iroteye ape, fene werese ane ma'e aiya! Tu naifa weriyei weriyei le a'i lai awei pani fene ne au ta'ane ta'uweye. Serai fene lu taune werese, awei pani irorowa ape, au noweinoweitorowa. ");
INSERT INTO sny_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ane lau erasi a'i iroteye su, fene lai ane au aye. Ane sa'i wawe teriteye su, fene lai ane sa'i au aye. Ane meni omo tere'e se omo wesi fene lo ma'e henerai su, fene lai ane wesi fene lo papu fa isafiyeyei ne heneti. Ais 58:7 ");
INSERT INTO sny_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ane ipari tahe ariye a'i iroteye su, fene lai ipari tahe fene lo ane se auwe. Ane u tahe se iroteye su, fene lai ane se sewiyeteye. Ane kalabus wesi sahe iroteye su, fene lai ane au ferafereiteye.’ ");
INSERT INTO sny_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Sosu lu taune yo seni aseyaro a'i irorowa ape, lowe ma'e te'e toweriye, ‘Meni owane, eiwerou su nomo ne lau erasi se siyeteye awere? Eiwerou su nomo ne au aye awere? Eiwerou su nomo ne sa'i wawe teriteye awere? Serai nomo sa'i ne ma'e au aye awere? ");
INSERT INTO sny_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Eiwerou su ne omo eyeri ma'e fai awere? Serai nomo ne ma'e wesi nomo lo papu au isafiyeyei ne heneti awere? Eiwerou su ne ipari tahe ariye a'i iroteye awere? Serai nomo ipari tahe nomo lo ne ma'e auwe. ");
INSERT INTO sny_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Eiwerou su ne u tahe se iroteye awere? Eiwerou su ne kalabus wesi sahe iroteye awere? Serai nomo ne sahe sewiyeyei ne aiyete awere?’ ");
INSERT INTO sny_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Sosu meni owane tutawe lai lu taune lowe ma'e itiya'u eirowa, ‘Ane fene ma'e peri wiyeme a'i au eisiya! Wanure! Fene wiyawi ape lu feni pefine ano ma'e au iroteye su, fene ane se aiwawe a'i iroteye. Fene lu feni yahowa'i ano au iroteye su, fene aiwawe a'i ane se au iroteye.’ Snd 19:17; Mt 10:42; Mk 9:41 ");
INSERT INTO sny_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Sosu meni owane ape lu taune ereti opi feni sahe iroteye ape, le lowe ma'e eirowa, ‘Fene werese ane arunatire. Fene ma'e ire. Fene lu taune luwaru a'i ne. Fene Owane Sitewi lo yo pefine awera'iyenati. Serai Owane Sitewi lo ai marepi fene ma'e ironamitorowa. Fene ma'e weriyei weriyei tinamitorowa ape, Owane Sitewi lai au ta'ane ta'uweye. Sosu sepei Satan lu feni werese lo aiwawe a'i ma'e tinamitorowa. Mt 7:23 ");
INSERT INTO sny_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ane lau erasi iroteye su, fene ane ma'e au a ta'ame. Ane sa'i wawe teriteye su, fene ane sa'i au a ta'ame! ");
INSERT INTO sny_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ane omo eyeri ma'e fai su, fene ane mase aiwawe isafiye ta'ame. Ane ipari tahe ariye a'i iroteye su, fene ane ipari tahe au ta'ame. Ane u tahe iroteye su, kalabus wesi sahe iroteye su, fene ane se sewiyenarai ta'ame!’ ");
INSERT INTO sny_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Sosu lu taune ape mo meni owane ape ma'e itiya'u eiye, ‘Meni owane, eiwerou su ne lau erasi a'i iroteye awere? Eiwerou su ne sa'i wawe iroteye awere? Eiwerou su ne ipari tahe ariye a'i iroteye awere? Eiwerou su ne u tahe se kalabus wesi sahe iroteye awere? Serai nomo ne au noweinowei ta'ame. Nomo ne siye ta'ame. ");
INSERT INTO sny_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Sosu meni owane ape lowe ma'e itiya'u eirowa, Ane fene ma'e peri pefine a'i au eisiya. Wanure! Fene lu feni yahowa'i ano au feraferei ta'ame su, fene ane aiwawe a'i au feraferei ta'ame.’ ");
INSERT INTO sny_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Serai lu taune werese yo ano umasi ta'ame ape, ane lowe ma'e weriyei weriyei ani fu arosawirowa. Lowe weriyei weriyei yehe ma'e tinamitorowa. Aiwawe a'i lu taune werese yo ano umasinamiteye ape, ane lowe Owane Sitewi lo omo ma'e henetirowa. Sosu lowe mi mi pasi pasi Owane Sitewi lo omo sahe ironamitorowa.” Dan 12:2; Jo 5:29 ");
INSERT INTO sny_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Sosu a'i pe Jisas peri lo au te'e tepa'asiye su, le lu disaipel lo ma'e apou eiye, ");
INSERT INTO sny_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Wanure! Nowe mi hesi i tepa'asiyei su, Juda lo ta'uwe hereiyei tutawe iyape Pasova henerairowa. Nowe ape se lu tamo lai ane, meni hire ma'e itorai ape, kalabus wesi ma'e etiyei ne henetirowa. Lowe ane me tape'i sahe ti tawesirowawe, sosu aine tera'erowa.” Kis 12:1-27; Mt 20:18 ");
INSERT INTO sny_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Sosu a'i pe au heseyei lu owane erasi a'i, ya'ariyei lu tamo, lowe au heseyei meni owane tutawe lo wesi au te'e tiyatiyei ne ta'uwerai. Meni ape lo iyape Kaiafas. ");
INSERT INTO sny_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Lowe werese ta'uwerai su, lowe peri te'e tiyatiyei ne onuwe. Lowe Jisas ne te'e arearerowawe, ereti lowe lo wafei se ti tawesirowa. Sosu lowe fara'u aine tera'erowa. ");
INSERT INTO sny_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Lowe apou te'e tiyatiteye, “Nomo ta'uwe hereiyei nomo lo le ereti wafei se ti tawesirowata. Ahowa, nomo le anite tawesiyei su, lu taune werese ai marepi nomo ne toterowa. Serai lowe nomo ma'e ai atu tiyatirowa.” ");
INSERT INTO sny_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Sosu a'i pe Jisas omo Betani sahe onuteye. Le Saimon lo wesi papu wi onuteye. Jisas tu naifa Saimon lo enite kairefi a'i au ta'ane niyemaiyeye. ");
INSERT INTO sny_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Jisas Saimon lo wesi metei sahe onuteye su, menitani ta tapiye pa'are ta aniyewe, heneri sa'i wisere a'i ape Jisas lo mato hire au ani terosowe. Menitani ape heneri sa'i ape ma'aru tomu ne'ese eteye. Lu 7:37-38 ");
INSERT INTO sny_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ahowa, lu disaipel lo menitani ape siyeye su, lowe ai marepi menitani ma'e toteye. Lowe apou eiye, “Piyene sa'i heneri wisere a'i au ani terosowe awere? Yo seni ape luwaru a'i tene! ");
INSERT INTO sny_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Nomo fara'u sa'i ape etiri wesi ma'e fu irorowawe, ma'aru tomu ne'ese anirowa. Ma'aru ape lu tamo ma'aru ariye a'i ape aurowa.” ");
INSERT INTO sny_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ahowa, Jisas lu disaipel lo peri wanuwe su, le lowe ma'e eiye, “Fene piyene menitani ape ne marepi luwaru a'i totesiya awere? Menitani ape ane ma'e wiyawi wisere a'i ta'ane tepa'asiye. ");
INSERT INTO sny_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Fene mi mi werese lu taune ma'aru ariye a'i ne totesiya. Ahowa, ane fene mase nowe oso a'i se irorowa. Nowe me'iye su, ane fene aru po'utenatirowa. Lo 15:11 ");
INSERT INTO sny_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Menitani ape sa'i heneri wisere a'i mato hire ano au ani terosowe su, le tahe pa'are ano fisiye yo sahe ta'uwe naneiye. ");
INSERT INTO sny_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ane fene ma'e peri pefine a'i eisiya! Wanure! Omo omo werese sahe peri ano au te'e fiyarirowa su, lu taune werese menitani lo wiyawi ape marepi tote anite tawesirowa. Lowe menitani ape tote i'anerowata.” ");
INSERT INTO sny_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Sosu a'i pe Jisas lo meni disaipel ta iyape Judas Iskariot, le Jisas arunatiyewe, Owane Sitewi lo wesi lu owane ma'e peri ta au te'eyei ne fi. ");
INSERT INTO sny_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Le Owane Sitewi lo wesi lu owane ma'e heneri su, le lowe ma'e ei toweriye, “Ane meni Jisas fene ma'e henetirowa su, piye etiri ma'aru tamo ane ma'e aurowa awere?” Owane Sitewi lo wesi lu owane peri lo wanuwe su, lowe ma'aru tewi tamo au heseye, lowe ma'aru tau meni ta werese ereti hesi werese le ma'e au heseye. Sek 11:12; Jo 11:57 ");
INSERT INTO sny_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Serai meni ape lai yo ta Jisas lowe ma'e henetiyei ne nehiteye. Le Jisas areareyei ne toteye. ");
INSERT INTO sny_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Sosu a'i pe ta'uwe hereiyei, Pasova, lo nowe tutawe henerai su, Jisas lo lu feni le ma'e te'e toweriyei ne fai. “Ta'uwe hereiyei, Pasova, tutawe ape nomo eiwerou ma'e ene ayei awere? Nomo etiri werese au ta'uwe naneiyei.” Kis 12:14-20 ");
INSERT INTO sny_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Sosu Jisas lowe ma'e itiya'u eiye, “Fene omo eire ma'e ire. Fene meni ta siyeyei. Le ma'e eire! ‘Atuatu siye meni ne ma'e eisiya. Nowe ape ane temeniyeyei ape ataheyeyei ne henerairowa. Ane lu feni ano mase ta'uwe hereiyei, Pasova, ape wesi no sahe ene ayei.’” ");
INSERT INTO sny_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Sosu lu disaipel lo omo ape ma'e fi. Jisas lo peri umasiteye. Lowe ta'uwe hereiyei, Pasova, lo etiri werese au ta'uwe naneiye. ");
INSERT INTO sny_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Sosu a'i pe nowe neriwei pasi su Jisas lu feni werese lo mase metei sahe ene ayei ne onuteye. ");
INSERT INTO sny_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Lowe ene ateye su, Jisas lowe ma'e apou eiye, “Ane peri wiyeme a'i fene ma'e eisiya. Wanure! Meni ta'i fene mase irosiya ape, le ane lu owane tamo ma'e etiyei ne henetirowa.” ");
INSERT INTO sny_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Lu disaipel lo Jisas lo peri wanuwe su, lowe werese marepi orese a'i toteteye. Lowe ta'i ta'i a'i lai le ma'e apou ei toweriye. “Meni owane, Eiwerai awere? Ane se ta'ama awere?” ");
INSERT INTO sny_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Sosu Jisas lowe ma'e itiya'u apou eiye, “Meni ape ane mase ayei fi wisere siye auwe papu iroteye ape, ani teinamiyewe, meni ape lai ane lu owane ma'e henetirowa. Sng 41:9 ");
INSERT INTO sny_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Owane Sitewi lo peri ane ne apou te'esiya, ‘Meni ape hire ma'e itorai ape, le temeniyerowa. Ahowa! Meni ape lai le lu owane ma'e henetirowa ape, meni ape weiyai! Meni ape lo mai le autei ta'ame su, etiri wisere a'i tene. Piyene etiri ape wisere a'i awere? Mai lo auteiye su, marepi lirewawe luwaru a'i papu le ma'e henerairowa. ");
INSERT INTO sny_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Sosu meni ape, iyape Judas, le Jisas ne lu owane ma'e au te'e ariariyeye ape, le Jisas ma'e ei toweriye. “Atuatu siye meni. Pefine, ane lai awere?” Sosu Jisas le ma'e itiya'u eiye, “Ne lai peri wiyeme a'i au te'e tepa'asiye.” ");
INSERT INTO sny_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Sosu a'i pe lowe ene ateye su, Jisas lai nau ta'ase ereti se aniteyewe, Owane Sitewi ma'e au te'e wisereyeteye. Sosu le nau ta'ase tewi pa tewi ani topotowewe, lu disaipel lo ma'e au noneye. Le lowe ma'e apou eiye, “Fene nau ta'ase ape ani ene. Nau ta'ase ape tahe pa'are ano wou a'i ne.” ");
INSERT INTO sny_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Lowe nau ta'ase ene a tepa'asiye su, le wain sa'i pa'are ereti aniteyewe, Owane Sitewi ma'e au te'e wisereyeye. Le wain sa'i pa'are lu disaipel lo ape ma'e au noneye. Le apou eiye, “Fene werese wain sa'i ape ene are. ");
INSERT INTO sny_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Wain sa'i ape fisa'i ano wou a'i ne. Owane Sitewi lai peri he'i ariariye irowe. Lowe tahe ano aine tewi narowa. Fisa'i ano nowe ma'e tepi'o teroso arosairowa. Fisa'i ano lai yo seni luwaru a'i ape mo au ani sasari tepa'asiyei. Owane Sitewi tai ano, fisa'i ano siyeyei su, le yo seni luwaru a'i ape tote i'ane tepa'asiyei. Kis 24:8; Jer 31:31-34; Sek 9:11; 1 Ko 10:16 ");
INSERT INTO sny_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ahowa, ane fene ma'e peri ta eisiya. Ane wain sa'i ape a tepa'asiyei su, ane wain sa'i tere'e tame arowata. Ahowa, nowe ye'ewi su, ane hi awei ma'e si tame itorairowa su, ane fene mase fara'u wain sa'i tere'e arowa. Nowe ape se ane Tai ano lo lu tewi werese au noweinoweirowa.” ");
INSERT INTO sny_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Sosu a'i pe lowe Owane Sitewi lo omoyawi ahi ta irowe su, lowe wesi ape arunatiyewe, Omo Oliv hire ma'e yaneye. Lu 22:39; Jo 18:1 ");
INSERT INTO sny_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Sosu a'i pe Jisas lowe ma'e eiye, “Wanure! Nowe pasi eite se lu owane lai ane ereti aniteye su, fene werese ane ne me'iyeni ma'e atati arunatirowa. Owane Sitewi lo peri tu naifa weriyei apou te'eye, ‘Ane fe sipsip au noweinowei siye meni ape aine tera'erowa. Serai fe sipsip werese lo atoweiye itero fiyari howeirowa.’ ");
INSERT INTO sny_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ahowa! Ane si tame sinerowa su, ane omo pani Galili ma'e tu irowa. Yaro ahe ane fene tame siyerowa.” Mt 28:7,16 ");
INSERT INTO sny_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ahowa, Pita le ma'e itiya'u eiye, “Wanure! Lu feni tere'e no lowe ne ne me'iyeni ma'e atati arunatirowa su, ane lai mi mi werese ne ne me'iyeni ma'e atati arunatirowata.” ");
INSERT INTO sny_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Sosu Jisas le ma'e eiye, “Ane peri wiyeme a'i ne ma'e eisiya. Wanure! Pasi eite se ne nowe hesi heta ane ne me'iyeni ma'e atati arunatirowa. Ne yo seni iro tepa'asirowa su, ne irowe kakaruk aite peri uterowa ape, wanurowa.” Mt 26:69-75 ");
INSERT INTO sny_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pita le ma'e itiya'u eiye, “Ahowa! Ane ne ne au temeniyerowa. Ane mi mi weriyei ne ne me'iyeni ma'e atati arunatirowata.” Lu disaipel lo ape werese peri aiwawe a'i le ma'e au te'eye. ");
INSERT INTO sny_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Sosu a'i pe Jisas lu disaipel lo mase awei Getsemani ma'e henerai. Sosu Jisas lu feni lo ma'e apou eiye, “Fene saro ahe onure. Ane hire yaro ma'e Owane Sitewi se au te'e tiyatiyei ne irowa.” ");
INSERT INTO sny_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Sosu Pita, Sebedi lo eimane hesi, iyape Jems, Jon, Jisas lai lowe hene yaneye. Jisas marepi orese erasi a'i teriteye. Le fofowei erasi lirewawe papu teriteye. ");
INSERT INTO sny_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Sosu Jisas lowe ma'e eiye, “Marepi lirewawe ano orese a'i irosiya. Ane apou toteye. Ane orese a'i ape suterowata. Ane tote temeniyereme. Fene sato onuwewe, etiri siye noweinowei etire. Owane Sitewi ma'e ane ne au ferafereiyei ne te'e towerire.” Jo 12:27 ");
INSERT INTO sny_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Sosu le lowe arunatiyewe, omo hire oso a'i yaneye. Le lowe lo ape'i onuwewe, ereme se awei ma'e winetaiteye. Sosu Owane Sitewi ma'e ei toweriye. “Tai ano, marepi ano orese a'i ne. Ane temeniye wou ta'ama. Ne yo tere'e fara'u siye nehire. Ahowa, ane lai marepi ano awera'iyenatirowa. Ane lai marepi no umasirowawe, peri no umasirowa.” ");
INSERT INTO sny_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Nowe oso a'i su, le si tame itorai. Lu feni hesi heta lo nihe howeiteye. Sosu le Pita ma'e eiye, “Fene nowe tewi ta'i a'i ane aiwawe a'i tei ninaweteye awere? ");
INSERT INTO sny_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Fene etiri werese tei siye etinamire. Owane Sitewi ma'e au te'ere. Serai fene yo seni luwaru a'i irowei ne toterowata. Yo aseyaro ne hepene fene lo marepi kairefi a'i tote umasisiya. Ahowa, tahe pa'are fene lo yo luwaru a'i umasiyei ne totenamisiya.” ");
INSERT INTO sny_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Sosu Jisas lowe hesi heta arunatiyewe, omo hire ma'e si tame yaneye. Le aite lo ma'e au te'e tiyatiyei ne fi. Le apou eiye. “Tai ano, ane fara'u marepi orese a'i ape awera'iyenatiyei awere? Ahowa, ane marepi no umasirowa.” ");
INSERT INTO sny_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Jisas peri te'e tepa'asiye su, le si tame itorai. Le lu feni hesi heta aiwawe a'i nihe howeiteyei siyeye. Nihe lowe lo orese a'i ne. ");
INSERT INTO sny_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Sosu Jisas lowe arunatiyewe, omo hire ma'e si tame yaneye. Le aite lo ma'e peri aiwawe a'i au te'eteye. “Tai ano, ane fara'u wiyawi no ne ane ma'e auwe ape, awera'iyenatirowa awere? Ahowa, ane marepi ano ani fu ararorowa. Ane marepi no umasirowa.” ");
INSERT INTO sny_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Sosu le aite lo peri te'e tepa'asiye su, le lu disaipel lo ma'e si tame itorai. Le lowe ma'e eiye, “Fene nihe howeisiya awere? Fene tahe fetane a'i teritesiya awere? Siyere! Nowe ano ataheyerai tepa'asiye. Meni ape ane lu luwaru a'i ma'e henetiyei. ");
INSERT INTO sny_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Fene sinere! Nomo iyei ne! Meni ape ane ai lu owane ma'e henetiyei ape fai.” Jo 14:31 ");
INSERT INTO sny_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Sosu a'i pe le peri ape te'eye su, siyere! Meni Judas Jisas ma'e henerai. Le lu disaipel lo (12 disaipel) ta'i a'i ne. Au heseyei lu owane lu tamo, lu owane tere'e tamo, lowe lai ai lu tomu ne'ese, lu taune tomu ne'ese Judas mase eimawesawi. Lowe eine inapi, ti, me au aiwawe a'i anitetai. ");
INSERT INTO sny_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Sosu meni Judas Jisas henerai su, le yaru ta lowe ma'e ariariyeyei au te'eye. Le apou eiye, “Ane meni ta ya'ore erite wisereyeyei su, fene meni ape ereti lo ma'e anitere.” ");
INSERT INTO sny_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Sosu Judas Jisas henerai su, le Jisas ma'e eiye, “Atuatu siye meni, Pasi a'i.” Sosu le Jisas ya'ore erite wisereyeye. ");
INSERT INTO sny_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Sosu Jisas le ma'e eiye, “Kaiyemo, Ne ane lu owane ma'e henetiyei ne fai. Ne witane se a'i irore.” Sosu ai lu tamo Jisas lo ereti anite tawesirai. ");
INSERT INTO sny_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Sosu siyere! Meni ta'i Jisas mase iroteye ape, le ipari mene'e ereti se aniyewe, au heseyei meni owane tutawe lo wiyawi yahowa'i siye meni lo apaniye aine tou la'eye. Jo 18:26 ");
INSERT INTO sny_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Sosu Jisas le ma'e eiye, “Ne ipari mene'e no ape si tame fure. Lu werese ipari mene'e se ai atu irowei su, lowe lai ipari mene'e se aiwawe a'i temeniyerowa. Stt 9:6; KTH 13:10 ");
INSERT INTO sny_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Piyene ne yo seni ape irowe awere? Ne apou totere. Ane tai ano ma'e fara'u au pati aniyei ne uterowa. Serai le a'i lai fara'u ipari wisere a'i (ensel) tomu ne'ese lo ane ma'e au ferafereiyei ne eimawe arosairowa. ");
INSERT INTO sny_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Wanure! Ane Owane Sitewi lo ipari wisere a'i (ensel) ape ane fa ferafereiyei ne ute aniyei su, Owane Sitewi lo peri, tu naifa leseye ape, pefine henerairowata.” ");
INSERT INTO sny_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Sosu Jisas lu werese ape ma'e apou eiye, “Fene ane ne totesiya awere? Ane ta'arei siye meni awere? Fene piyene eine inapi, me au, ipari mene'e aitaisiya awere? Mi mi werese ane Owane Sitewi lo wesi fene lo ma'e au te'e atuatuwei ne onuteye. Ane sato onuteye su, fene ereti ano anite tawesiye ta'ama. Lu 19:47; 21:37 ");
INSERT INTO sny_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Tu naifa weriyei Owane Sitewi lo peri au te'e siye lu fene ne leseye. Serai yo seni fene lo fene irowe ape, wiyeme henerai tepa'asiye.” Sosu Jisas peri te'e tepa'asiye su, lu feni werese lo Jisas arunatiyewe, atoweiye iteroti. ");
INSERT INTO sny_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Sosu a'i pe ai lu werese Jisas lo ereti anite tawesiye ape, lowe meni Kaiafas ma'e heneti. Lu owane tere'e Kaiafas lo wesi ma'e ta'uweyei. ");
INSERT INTO sny_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ahowa, Pita lu werese eyeri ma'e mo'o umasiteye. Lowe Jisas Kaiafas lo wesi papu hene wiye su, Pita Kaiafas lo wesi nowe taire ma'e hene onuri. Ai lu tamo mase onuteye. Le Jisas lo peri etiyei ape siyeyei ne. ");
INSERT INTO sny_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Kaiafas lo wesi papu, au heseyei lu owane tamo, lu owane tere'e tamo, wesi papu ta'uweye ape, lowe peri wawero au te'eteye. Lowe Jisas aine tera'eyei ne toteye. ");
INSERT INTO sny_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ahowa, lowe yo seni luwaru a'i nehirowata. Lu tomu ne'ese Jisas ne peri wawero au te'eye. Ahowa, peri werese lowe lo Jisas etirowata. Nowe me'iye su, lu hesi ponei sahe au te'eyei ne teiteye. ");
INSERT INTO sny_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Lowesi apou eiye, “Meni ape apou au te'eye. Nomo wanuwe. Le apou eiye, ‘Ane fara'u Owane Sitewi lo wesi tutawe aine tapeti po'uterowa. Sosu nowe hesi heta i tepa'asiyei su, ane Owane Sitewi lo wesi eite si tame ta'anerowa.’” Jo 2:19-21 ");
INSERT INTO sny_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Sosu Owane Sitewi lo meni owane tutawe sine teiyewe, Jisas ma'e eiye, “Ne lu hesi lo peri wanuwe awere? Ne peri ta itiya'u au te'erowata awere? Lu hesi piye peri eti ne ma'e au fu te'eye awere?” ");
INSERT INTO sny_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ahowa, Jisas peri se ta'ama. Sosu au heseyei meni Owane tutawe le ma'e ei toweriye, “Ane ne ma'e ei toweriye. Owane Sitewi norohuwe ironamisiya ape, lo nihe se ne peri pefine nomo ma'e au te'ere. Ne Krais awere? Ne meni Owane Sitewi lai, hi awei ma'e eimawe arosai awere? Ne Owane Sitewi lo meni eime awere?” Ais 53:7; Mt 27:12 ");
INSERT INTO sny_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Sosu Jisas le ma'e eiye, “Peri no wiyeme a'i tene! Weiya! Nowe me'iye su, ane, meni ape, omo hire ma'e itorai ape, ane Owane Sitewi kairefiyeyei pefine a'i lo ereti eyate feni ma'e onunamitorowa. Nowe ye'ewi su, ane ni'arawe papu itorairowa. Fene werese ane ni'arawe hire ma'e siye anirowa.” Sng 110:1; Dan 7:13; Mt 24:30 ");
INSERT INTO sny_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Sosu a'i pe au heseyei meni owane tutawe Jisas lo peri wanuwe su, le ipari tahe lo ani erauwiye. Sosu eiye, “Le Owane Sitewi Pefine ne te'e naruwe. Nomo lu tere'e au te'eyei ne ei anirowata. Siyere! Fene werese peri lo ape wanu tepa'asiye. Peri lo ape Owane Sitewi ne te'e naru tepa'asiye. Mt 9:3; Jo 10:33 ");
INSERT INTO sny_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Fene piye totesiya awere?” Sosu lowe werese itiya'u uteye. “Le Owane Sitewi ma'e te'e naru tepa'asiye. Serai nomo le aine tera'erowa.” Wkp 24:16; Jo 19:7 ");
INSERT INTO sny_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Sosu lu tamo Jisas lo nihari sahe pisa'i sine'iye. Lowe le ma'e nihari ma'e ereti mokumoku se aineye. Lu tamo tere'e ereti se aine apasiye. Ais 50:6; 53:5 ");
INSERT INTO sny_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Lowe le ma'e eiye, “Ne meni ape Krais Owane Sitewi lai, hi awei ma'e eimawe arosai ape, ne nomo ma'e au te'ere. Eiwerai ne ereti mokumoku se aineye awere?” ");
INSERT INTO sny_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Sosu a'i pe Pita wesi nowe ma'e wesi taire onu ninaweteye. Nowe oso a'i su, wiyawi yahowa'i siye menitani lai Pita ma'e ei toweriyei ne henerai. Le ma'e eiye, “Siyere! Ne Jisas mase, Pani Galili ma'e fai ape, aiwawe a'i iroteye.” ");
INSERT INTO sny_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ahowa, Pita lowe ma'e itiya'u eiye, “Wawero a'i ne! Ane meni ape mase aiwawe iro ta'ame. Ane peri no so'oru ta'ama.” ");
INSERT INTO sny_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Sosu Pita wesi taire arunatiyewe, nowe ma'e fi. Sosu Wiyawi yahowa'i ani siye menitani tere'e ta Pita siyeye. Le lu taune ma'e eiye, “Meni ape le Jisas omo Nasaret lo meni aiwawe iroteye.” ");
INSERT INTO sny_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pita peri lo wanuwe su, le peri kairefi a'i se eiye, “Ahowa, ane meni ape so'oru ta'ama.” ");
INSERT INTO sny_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Nowe oso a'i su, lu tamo Pita ma'e te'eyei ne henerai. “Pefine a'i ne Jisas aiwawe a'i iroteye. Ne Jisas lo peri wou a'i te'esiya.” ");
INSERT INTO sny_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Sosu Pita peri luwaru a'i lowe ma'e au te'eye. “Ahowa! Ane meni ape so'oru ta'ama.” Sosu Pita peri ape te'e tepa'asiye su, irowe kakaruk aite peri erasi uteye. ");
INSERT INTO sny_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Sosu Pita irowe kakaruk aite lo peri wanuwe su, le Jisas lo peri ne toteye. Jisas nowe tu se apou au te'eye, “Ne nowe hesi heta ane ne me'iyeni ma'e atati arurowa. Serai irowe kakaruk aite uterowa su, ne yo seni ape iro tepa'asirowa.” Sosu le nowe ma'e fiyewe, luwei erasi irowe. Mt 26:34 ");
INSERT INTO sny_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Sosu a'i pe nowe esi mitaiyeye henerai su, Owane Sitewi lo wesi lu owane werese, ya'ariyei lu tamo wesi papu Jisas ne te'e tiyatiyei ne ta'uwerai. Lowe Jisas aine tera'eyei ne toteye. ");
INSERT INTO sny_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Sosu lowe Jisas ereti wafei se ti tawesiyewe, awei meni owane, iyape Pailat, ma'e heneti. ");
INSERT INTO sny_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Meni ape Judas Jisas lo etiyei siyeye su, le marepi orese a'i teriteteye. Serai le ma'aru tau meni ta werese ereti hesi werese au heseyei lu owane ya'ariyei lu owane ma'e si tame aiti. Judas Jisas Owane Sitewi lo wesi lu owane ma'e heneti. ");
INSERT INTO sny_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Le lowe ma'e eiye, “Ane Owane Sitewi ma'e yo seni luwaru a'i irowe. Meni ape yo seni werese lo wara'i a'i ne.” Ahowa, lowe le ma'e itiya'u eiye, “Etiri ape ne irowe ape, ne lai marepi no umasi tepa'asiye. Nomo ne ma'e yo seni ape irowei ne te'eye. Marepi nomo lo yahowa'i totesiya. Etiri ape ne ewiteyei no a'i lai.” ");
INSERT INTO sny_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judas peri lowe lo wanuwe su, le ma'aru werese fiyafe ma'e ani fu arowewe, wesi nowe ma'e fi. Nowe me'iye su, Judas lai wafei se pere'i topo lo sahe ti tawesiyewe, me nei sahe heri tera'eye. Ap 1:18-19; Mt 26:14-15 ");
INSERT INTO sny_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Judas ta'uwe wesi nowe ma'e fi su, Owane Sitewi lo wesi lu owane ma'aru werese ani ta'uwe fuwe. Sosu lowe apou eiye, “Nomo ma'aru eite Owane Sitewi lo wesi lo pa'are papu au furowata. Ma'aru eite nomo meni ta lo temeniyeyei ape, ete tepa'asiye. Ma'aru eito eite nomo Owane Sitewi ma'e siye ma'aru pa'are papu au furowata.” ");
INSERT INTO sny_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Serai lowe peri ta te'e tiyatiteye. Te'e tepa'asiye su, lowe ma'aru ape ta'aneyei awei ta eteye. Ta'aneyei awei ape meni topo peperi pa'are ta'aneteye ape. Piyene lowe awei tewi ape eteye awere? Lowe lu taune pani eyeri ma'e fai ape, temeniyeyei su, lowe tahe pa'are lowe lo fisiye yo ma'e funarirowa. ");
INSERT INTO sny_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Serai lowe awei tewi ape eteye su, lowe iyape tere'e au papowe, “Fisa'i lo Awei Tewi.” Iyape ape mi mi werese ironamitorowa. ");
INSERT INTO sny_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Sosu tu naifa weriyei Owane Sitewi lo peri au te'e siye meni Jeremaia apou leseye, “Lowe ma'aru tau meni ta werese ereti feni hesi (10) aniyewe, awei tewi ta eteye. Awei tewi ape sahe meni ta peperi pa'are ta'aneteye. Meni owane lai lowe ma'e awei tewi ape eteyei ne au te'eye. Ma'aru meni ta werese ereti feni hesi (10) ape Israel lo lu taune lai meni hepene eteyei ne ariariyeye.” Nowe ape se peri eite, Jeremaia leseye ape, wiyeme a'i henerai tepa'asiye. ");
INSERT INTO sny_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Sosu a'i pe Owane Sitewi lo wesi lu owane lai Jisas awei meni owane tutawe ma'e au teiyei ne heneti. Meni owane ape Jisas ma'e peri ta ei toweriye. Le apou ei toweriye, “Ne Juda lo meni owane tutawe awere?” Jisas le ma'e itiya'u eiye, “Ei! Ne peri wiyeme a'i au te'eye.” ");
INSERT INTO sny_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Sosu au heseyei lu owane tamo awei lu owane tamo peri luwaru a'i Jisas ma'e au te'eteye. Ahowa, Jisas peri ta itiya'u te'e ta'ame. Ais 53:7 ");
INSERT INTO sny_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Sosu Pailat le ma'e eiye, “Ne lowe lo peri werese wanu ta'ame awere? Lowe etiri luwaru a'i tomu ne'ese ne ma'e au fu te'eteye.” ");
INSERT INTO sny_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ahowa, Jisas peri werese lowe lo itiya'u te'e ta'ame. Serai Pailat Jisas ne hepene se su'ariye. ");
INSERT INTO sny_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ta'uwe hereiyei iyape Pasova, iyu menei weriyei weriyei sahe awei meni owane lai meni ta, kalabus wesi sahe iroteye ape, nowe ma'e hene arosairowa. Meni ape Israel lo lu taune lai ariariyerowa. ");
INSERT INTO sny_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Meni luwaru a'i ta kalabus wesi papu ironamiteye, iyape Barabas. Meni ape yo seni luwaru a'i ironamiteye. ");
INSERT INTO sny_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Serai lu taune tomu ne'ese meni Pailat ma'e ta'uwerai. Sosu le lowe ma'e apou ei toweriye. “Ane meni ta'i, kalabus wesi papu iroteye ape, nowe ma'e henerowa. Fene eiwerai ane nowe ma'e fa henerowa awere? Fene eiwerou totesiya awere? Ane meni Barabas nowe ma'e henerowa awere? Jisas nowe ma'e henerowa awere? Meni ape Jisas Owane Sitewi lai hi awei ma'e eimawe arosai.” ");
INSERT INTO sny_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Awei meni owane ape peri ape au te'eye su, le apou toteye. “Juda lo lu tewi ape Jisas ma'e marepi luwaru a'i totenamiteye. Lowe le ne marepi afofo a'i totenamisiya. Serene lowe lai Jisas ane ma'e etiyei ne henetai.” Jo 11:47-48; 12:19 ");
INSERT INTO sny_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Awei meni owane ape etiyei lo me to'u onuteye su, tani lo le ma'e peri ta le ma'e apou te'esai, “Meni ape wara'i wisere a'i tene! Ne etiri luwaru a'i ta le ma'e owe ape irore! Liyewe pasi ane le ne suwou ta siyeye. Ane marepi orese erasi a'i teriteteye.” ");
INSERT INTO sny_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ahowa, au heseyei lu owane tamo, awei ya'ariyei lu tamo, lowe lu taune werese ma'e peri kairefi a'i au te'eye, “Fene meni Barabas kalabus wesi nowe ma'e ei ani heneraire! Fene awei meni owane ma'e Jisas aine tera'eyei ne au te'ere.” ");
INSERT INTO sny_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Awei meni owane lowe ma'e itiya'u eiye, “Fene eiwerou a'i lu hesi ape ne totesiya awere? Jisas nowe ma'e ani arosaiyei awere? Barabas ani arosaiyei awere?” Lowe le ma'e itiya'u eiye, “Ne meni Barabas ani arosaire!” ");
INSERT INTO sny_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Sosu Pailat lowe ma'e ei toweriye. “Meni Jisas, Owane Sitewi lai eimawe arosai ape, ane le ma'e eiwerou irowei awere?” Lowe le ma'e itiya'u eiye, “Meni eite me tape'i sahe aine tera'ere!” ");
INSERT INTO sny_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Sosu Pailat lowe ma'e itiya'u eiye, “Piyene awere? Meni ape yo seni luwaru a'i iro ta'ame.” Ahowa, lu taune werese peri kairefi erasi a'i uteye, “Meni eite me tape'i sahe aine tera'ere.” ");
INSERT INTO sny_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Meni ape, Pailat peri lowe lo wanuwe su, le apou toteye. Lu taune ape mo marepi luwaru a'i toteteye. Lowe ai atuwei lo marepi toteye. Serai le sa'i tewi ta ei aniteye. Sa'i tewi ta aitai su, le ereti aiyawe lo sa'i au huwewe, lowe ma'e eiye, “Ereti hesi ano sa'i se au huwe su, ane fene ma'e apou au atuatusiya, ane yo seni luwaru a'i siye ta'ame. Ane le ma'e aine tera'erowata. Fene le ma'e aine tera'ereme su, fene a'i lai le me tape'i sahe aine tera'ere.” Lo 21:6-9 ");
INSERT INTO sny_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Sosu lu taune werese le ma'e apou uteye. “Ei, nomo meni ape me tape'i sahe aine tera'erowa. Nomo orese a'i eite teriterowa. Eimane nomo lo aiwawe a'i orese a'i eite teriterowa.” Ap 5:28 ");
INSERT INTO sny_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Sosu Pailat peri lowe lo wanuwe su, le meni Barabas kalabus wesi papu irote ape, nowe ma'e ani arosaiyewe, lu taune ma'e heneti. Sosu mo'o le ai lu tamo Jisas lo me'iyeni ma'e wafei se aineyei ne eimawesawi. Sosu lowe ma'e me tape'i sahe aine tera'eyei ne heneti. ");
INSERT INTO sny_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Sosu a'i pe awei meni owane lo ai lu tamo Jisas ta'uweyei wesi erasi papu hene wiye. Lowe ai lu werese Jisas ma'e ei ta'uwerai. ");
INSERT INTO sny_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Sosu lowe ipari tahe werese lo ani erauwewe, sosu lowe ipari tahe lo'u a'i ape se au ani asiye. Lu 23:11 ");
INSERT INTO sny_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Lowe wafei tohu ni'ari ape se tuhe wou ani ape'iye ta'aneyewe, Jisas lo mato sahe au ti atati asi arowe. Lowe me epi ta ereti sa'onare eyate feni lo se au aniteye. Lowe le ma'e lowe uporo ape'i onuwewe, lowe le ma'e peri ta apou te'e naruteye. Lowe apou te'eye, “Siyere! Juda lo meni owane tutawe.” ");
INSERT INTO sny_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Lowe pisa'i le ma'e sene'iye. Lowe me epi lo aniyewe, mato lo ma'e aineye. Ais 50:6 ");
INSERT INTO sny_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Lowe le ma'e peri te'e naru tepa'asiye su, lowe ipari tahe lo'u a'i le ani asiteye ape si tame au ani erauwewe, sosu ipari tahe lo, tu tame ani asiye ape, le ma'e si tame au ani asiye. Lowe ta'uwe wesi nowe ma'e me tape'i aine tera'e ti tawesiyei ne heneti. ");
INSERT INTO sny_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Sosu a'i pe lowe ta'uwe wesi erasi nowe ma'e heneye su, lowe meni ta iyape Saimon omo Sairini ma'e fai ape, lowe meni ape ma'e eiye, “Ne Jisas lo me tape'i omo hire ma'e sute yanere!” ");
INSERT INTO sny_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Lowe omo ta iyape Golgota Jisas hene yaneye. Omo ape lo peri sitewi apou ne. “Mato Pa'are lo Omo.” ");
INSERT INTO sny_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Sosu lowe Jisas ma'e wain sa'i horuse luwaru a'i ape Jisas au aye. Ahowa, Jisas sa'i tewi a'i asiyei irowewe, sosu sa'i ape a ta'ame. Sng 69:21 ");
INSERT INTO sny_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Sosu lowe Jisas me tape'i sahe aine tera'e ti tawesi heriye su, lowe tapiye tamo ipari tahe lo aniyei ne ani fu arosawi. Tapiye ape mo ai lu ta ipari tahe lo aniyei ne ariariyeye. Serai ai lu ape tapiye ariariyeye ape, le lai Jisas lo ipari tahe anirowa. Sng 22:18 ");
INSERT INTO sny_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Sosu lowe pa'eye tepa'asiye su, lowe senarepe sahe onuwewe, le ma'e siye ninaweteye. ");
INSERT INTO sny_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Sosu lowe metei sahe apou leseye, Meni ape Jisas Juda lo meni owane tutawe Lowe peri ape one towe sahe lese tepa'asiye su, lowe peri ape Jisas lo me tape'i pihatu sahe aine tawereye. ");
INSERT INTO sny_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Nowe ape se ta'arei lu hesi Jisas mase me tape'i sahe aine ti tawesiye. Ta'arei meni ta Jisas lo eyate feni ma'e au ti tawesiye. Ta'arei meni tere'e ta opi feni ma'e au ti tawesiye. Ais 53:12 ");
INSERT INTO sny_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Sosu a'i ape lu tamo Jisas ma'e atahe a'i teiteye su, lowe peri luwaru a'i le ma'e au te'e naruwe. Lowe le se niyeyeiteye. Sng 22:7; 109:25 ");
INSERT INTO sny_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Lowe le ma'e eiye, “Ne tu apou eiye, ‘Ane Owane Sitewi lo wesi tutawe aine tapeti fiyariyei. Sosu nowe hesi heta ane si tame ta'anerowa.’ Ne iyape no ei ani aroweye. Serai ne Owane Sitewi lo meni eime su, ne fara'u topo ne au si anire! Ne me tape'i hire saro arunatirowawe, hi eito itora!” Mt 26:61; Jo 2:19 ");
INSERT INTO sny_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Owane Sitewi lo wesi lu owane tamo, Owane Sitewi lo peri ani so'oruwe siye lu tamo, lowe aiwawe a'i Jisas ma'e peri luwaru a'i te'e naru niyeyeiteye. Lowe le ne eiye, ");
INSERT INTO sny_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Meni ape lu taune tere'e tamo ma'e si tame au hene aniteye. Ahowa, le topo a'i lai si anirowata. Le Juda lo meni owane tutawe pefine su, le fara'u me tape'i hire arunatirowawe, hi awei ma'e itorairowa. Le hi awei ma'e itoraiyei su, nomo fara'u le ne a'i tote tawesinamirowa. ");
INSERT INTO sny_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Meni ape Owane Sitewi pefine a'i ne tote tawesiyei su, sosu Owane Sitewi le ne marepi erasi a'i totenamisiya su, Owane Sitewi le ma'e au ferafereirowa. Meni ape topo le ne apou eiye, ‘Ane a'i lai Owane Sitewi lo meni eime pefine a'i ne!’” Sng 22:8 ");
INSERT INTO sny_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ta'arei lu hesi me tape'i sahe le mase ti tawesiteye ape, lowesi le ma'e au te'e naru niyeyeiteye. ");
INSERT INTO sny_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Sosu a'i pe poweiye ponei se nowe pasi a'i ito henerai, awei pani werese napetuwe. Sosu poweiye neriwei aiwawe a'i se pasi po'uteye. Nowe neriwei aiwawe a'i poweiye si tame tewi mitaiye fiyarirai. ");
INSERT INTO sny_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Sosu nowe neriwei (3 klok) Jisas peri kairefi erasi a'i apou uteye, Eloi, Eloi lama sabaktani! Peri ape Hibru lo peri apou te'eye, “Owane Sitewi ano, Owane Sitewi ano, piyene ne ane ne me'iyeni ma'e atati aruwe awere?” ");
INSERT INTO sny_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Sosu lu tamo me tape'i atahe sahe teiteye ape peri lo ape wanuwe su, lowe apou te'eye, “Meni Elaija ute anisiya awere?” ");
INSERT INTO sny_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Sosu meni ta witane a'i se ipari tahe aniyewe, me pite ta pihatu sahe ipari tahe ape tiye su, Jisas ma'e wain sa'i luwaru a'i ape au aye. Sng 69:21 ");
INSERT INTO sny_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ahowa, lu tere'e tamo apou eiye, “Weiya! Aru! Nomo pei siyere! Meni Elaija lai meni ape fara'u si tame hene anirowa awere? Piyete awere? Nomo pei ninawere!” ");
INSERT INTO sny_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Sosu Jisas peri kairefi erasi a'i tame uteye. Sosu hepene lo fi. Le temeniyeye. ");
INSERT INTO sny_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ipari tahe erasi a'i Owane Sitewi lo wesi tutawe, papu hire heriteye ape, hire ma'e ani erauwiye. Owane Sitewi lai ipari tahe ape hire ma'e ponei ani tou apeti itorai. Auwe erasi a'i awei pani werese tei auseriyeye. Tapiye erasi a'i tamo aine erauwiye. Kis 26:31-33; Hi 10:19-20 ");
INSERT INTO sny_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Fisiye yo werese toso tepa'asiye. Lu taune tomu ne'ese, Owane Sitewi lo yo umasinamiteye ape, tu temeniyeye ape, Owane Sitewi lai lowe fisiye yo sahe si tame au norohuwe sineye. ");
INSERT INTO sny_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Nowe me'iye se Owane Sitewi lo kairefi se Jisas fisiye sahe si tame au norohuwe sineye su, lu taune ape mo Owane Sitewi lo omo wara'i a'i wiri. Lu taune tomu ne'ese lowe siyeye. ");
INSERT INTO sny_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Sosu ai lu lo meni owane, ai lu tamo le mase iroteye ape, lowe Jisas au tei siyeteye ape, lowe auwe lo etiri werese auwe erasi tei auseriyeyei erasi teriteyei siyeteye. Lowe marepi atoweiye erasi a'i toteye. Lowe apou eiye, “Wanure! Wiyeme a'i, meni ape Owane Sitewi lo meni eime tene!” ");
INSERT INTO sny_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Taune tomu ne'ese Jisas lo me tape'i eyeri sahe tei ninaweteye. Lowe tu pani Galili sahe Jisas mase iroteyewe, le ma'e au noweinoweiteye. Lu 8:2-3 ");
INSERT INTO sny_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Menitani ta iyape Maria, omo pani Makdala ma'e fai. Menitani tere'e ta iyape Maria. Menitani ape Jems, Josep lo mai. Sosu menitani tere'e ta, Jems, Jon lo mai, Sebedi lo eimane hesi. ");
INSERT INTO sny_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Nowe neriwei pasi se meni ta ma'aru tomu ne'ese iroteye ape, iyape Josep, omo Arimatea ma'e fai. Le tu naifa Jisas lo peri tote tawesi umasinamiteye. ");
INSERT INTO sny_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Le Pailat, awei meni owane, ma'e ei toweriyei ne henerai. Le apou ei toweriyei, “Ane fara'u Jisas lo tahe pa'are ani itorairowawe, fisiye yo papu ma'e furowa awere?” Sosu Pailat ai lu lo ma'e eiye, “Ne Jisas lo tahe pa'are ape ani itorowawe, Josep ma'e aure!” Lo 21:22-23 ");
INSERT INTO sny_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Sosu Josep lai Jisas lo tahe pa'are aniye. Sosu le ipari tahe aseyaro a'i aniyewe, tahe pa'are lo sahe au napetu ti tawesiye. ");
INSERT INTO sny_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Le Jisas lo tahe pa'are au napetu ti tawesi tepa'asiye su, le fisiye yo he'i a'i topo lo papu ma'e fuwe. Fisiye yo ape tapiye erasi a'i papu horuseye. Jisas lo tahe pa'are fisiye yo papu ma'e fuwe su, le tapiye erasi ta fisiye yo hire au onu tawesiye. Le tapiye erasi fisiye yo hire noweri onuwe su, le wesi topo lo ma'e fi. Ais 53:9 ");
INSERT INTO sny_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Sosu taune hesi iyape Maria omo Makdala ma'e fai ape, sosu Maria tere'e lowesi fisiye atahe a'i yo sahe onuteye. ");
INSERT INTO sny_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Sosu a'i pe nowe mo'o se ta'uwe hereiyei lo etiri ta'uwe tepa'asiye su, au heseyei lu owane tamo, Farisi lu tamo, lowe awei meni owane tutawe Pailat ma'e ta'uwerai. ");
INSERT INTO sny_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Lowe le ma'e eiye, “Meni owane Jisas lai peri wawero te'enamiteye. Nomo peri lo wanuwe. Sosu nomo peri lo ape tote tawesiye. Le sato iroteye su, le apou eiye, ‘Ane temeniyeyei su, nowe hesi heta ane si tame norohuwe sinerowa.’ Mt 12:40; 16:21; Mk 9:31; 10:33-34; Lu 9:22; 18:31-33; Jo 2:19-21 ");
INSERT INTO sny_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Serai ne ai lu ma'e apou au te'ere, ‘Fene Jisas lo fisiye yo tei siyete.’ Serai lu tamo Jisas lo tahe pa'are ta'arei ani tahe anirowata. Nowe hesi heta i tepa'asiyei su, ai lu werese fara'u wesi towafi lo ma'e irowa. Jisas lo lu disaipel lai tahe pa'are lo ta'arei ani tahe aniyei su, lowe lu taune werese ma'e apou eiyei, ‘Jisas si tame norohuwe sineye.’ Lowe lu taune ma'e au te'e fiyariyei su, peri wawero ape lai peri wawero tere'e ape ani fu ararorowa.” ");
INSERT INTO sny_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Sosu Pailat lowe ma'e itiya'u eiye, “Ane ai lu tamo fene ma'e auwei. Fene ire! Ai lu werese fisiye yo ma'e henetire! Lowe fara'u fisiye yo ape sahe tei siyeterowa. Fene fisiye yo ape au kairefiyere!” ");
INSERT INTO sny_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Sosu lowe ai lu ape mo fisiye yo ma'e tei siyeyei ne heneti. Lowe fisiye yo sahe wafei tepi ani ti tawesirowawe, owe meni ta wafei ape owe ape ani eraure. Sosu lowe fisiye arunatiyewe, omo towafi lowe lo fi. ");
INSERT INTO sny_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sosu a'i pe nowe amou (Sabat) i tepa'asiye. Nowe poweiye tutawe esi pasi ape henerai su, taune hesi, Maria omo Makdala ma'e fai ape, Maria tere'e ta lowesi Jisas lo fisiye yo ma'e siyeyei ne fi. ");
INSERT INTO sny_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Siyere! Nowe ape se auwe erasi omo awei werese auseriyeye. Owane Sitewi lo ipari hire ma'e arunatiyewe, hi awei fisiye yo ma'e itorai. Le tapiye erasi ape, fisiye yo ti tawesiye ape, fisiye yo tewiye ma'e ani nowerisawi. Owane Sitewi lo ipari wisere a'i ape tapiye erasi hire ma'e onuteye. ");
INSERT INTO sny_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Taune hesi ape Owane Sitewi lo ipari ape siyeye. Nihari lo yehe erasi tei mitaiyeyei siyeye. Ipari tahe lo ape ni'arawe mi wapo wou a'i asiteye. ");
INSERT INTO sny_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ai lu ape mo Owane Sitewi lo ipari siye itorai. Lowe le siye itorai su, lowe atoweiye erasi iroteye. Tahe lowe lo auwe wou a'i auseriyeye. Lowe werese awei sahe winetai temeniyeye wou irowe. ");
INSERT INTO sny_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Sosu a'i pe taune hesi fisiye yo ma'e henerai su, Owane Sitewi lo ipari lowesi ma'e apou eiye, “Fenesi atoweiye sawa! Fenesi meni Jisas, me tape'i sahe temeniyeye ape, siyeyei ne fai. Ane marepi fenesi lo so'oruwe tepa'asiye. ");
INSERT INTO sny_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Siyere! Le lai sato ariye. Tu naifa le fenesi ma'e apou eiye, ‘Ane si tame norohuwe sinerowa.’ Peri lo ape wiyeme a'i henerai. Owane Sitewi lai le si tame norohuwe sine tepa'asiye. Fenesi aiya! Fenesi fisiye yo yaru wari siyera! Le sato ariye. Mt 12:40; 16:21 ");
INSERT INTO sny_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Fenesi witane se a'i Jisas lo lu disaipel ma'e au te'eyei ne ire! Lowe ma'e apou au te'ere! ‘Jisas si tame norohuwe sine tepa'asiye. Wanure! Le omo pani Galili ma'e tu fi. Omo pani ape sahe fene le siyerirowa.’ Wanure! Ane fenesi au te'eyei ne fai.” ");
INSERT INTO sny_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Sosu lowesi marepi hesi a'i teriteye. Lowesi Owane Sitewi lo ipari siyeye su, lowesi marepi atoweiye erasi teriteye. Sosu lowesi peri lo ape wanuwe su, lowesi marepi wisere a'i tote nine'inamiteye. Serai lowesi Jisas lo fisiye yo witane se a'i arunatiyewe, lu disaipel lo ma'e peri heneruwe au te'eyei ne iteroti. ");
INSERT INTO sny_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Taune hesi ape fisiye yo ape arunati su, Jisas yo sahe siye naituri. Le lowesi ma'e peri eriteye. Lowesi le siyeye su, lowesi Jisas lowe sahe ape'i onuri. Lowe lo ereti anite tawesiye. Lowesi le ma'e au te'e wisereyeteye. ");
INSERT INTO sny_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Sosu Jisas lowesi ma'e apou eiye, “Fenesi atoweiye sawa! Fenesi kaiyemo ano ma'e peri ta au te'etire. Lowe omo pani Galili ma'e fu ire! Omo ape sahe lowe ane fara'u siyerowa.” Mt 26:32 ");
INSERT INTO sny_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Sosu a'i pe taune hesi ape omo ape fi su, ai lu ape mo au heseyei lu owane ma'e peri werese au te'e areiyeri. ");
INSERT INTO sny_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Owane Sitewi lo wesi lu owane peri lowe lo wanuwe su, lowe Owane Sitewi lo wesi lu ya'ariyei owane werese ei ta'uwerai. Lowe werese ta'uwerai su, lowe ai lu werese ape mo ma'aru tomu ne'ese auwe. ");
INSERT INTO sny_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Lowe ai lu ma'e apou eiye, “Fene peri wiyeme a'i owe ape au te'ere. Ahowa, fene apou au te'ere, ‘Nowe pasiyeye su nomo nihe teiye su, Jisas lo lu disaipel fisiye yo papu wiyewe, tahe pa'are lo ta'arei ani tahe aiti.’ ");
INSERT INTO sny_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Sosu awei meni owane peri ape wanurowa su, fene ma'e au luwaruwe irowei ne toterowa su, nomo le ma'e peri ape au fareraiyerowa. Serai le fene ne etirowata.” ");
INSERT INTO sny_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Sosu a'i pe ai lu ape mo ma'aru aniyewe, Owane Sitewi lo wesi arunati. Lowe au heseyei lu owane lo peri wanu umasiteye. Lowe Juda lo lu taune werese werese ma'e peri wawero ya'ariyei lu ape au te'eye ape, te'e fiyariteye. Peri wawero ape lowe au te'e fiyariteye ape, ironamisiya. ");
INSERT INTO sny_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Sosu a'i pe Jisas lo lu disaipel ereti feni hesi lowe ta'i a'i (11) omo Jerusalem arunatiyewe, omo pani Galili ma'e fi. Lowe omo ape, Jisas tu ariariyeye ape, le ma'e yane siyeri. Mt 26:32 ");
INSERT INTO sny_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Sosu lowe le siyeye su, lowe le ma'e au te'e wisereyeteye. Ahowa, lu tamo marepi hesi iroteye. ");
INSERT INTO sny_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Sosu Jisas lowe ma'e henerai su, le lowe ma'e apou eiye, “Owane Sitewi lai ane ma'e kairefi erasi a'i auwe. Kairefiyeyei werese hire ma'e irosiya ape, le ane ma'e au tepa'asiye. Aiwawe a'i kairefiyeyei werese hi awei sahe irosiya ape, le ane ma'e au tepa'asiye. Jo 13:3; Ef 1:20-22 ");
INSERT INTO sny_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Serai ane fene ma'e au te'esiya. Fene omo omo werese ma'e ire. Fene lu taune werese peri ano au te'e fiyarite! Lowe peri ano wanu tote tawesirowa su, lowe fara'u lu feni ano henerairowa. Lowe lu feni ano henerairowa su, fene fara'u lowe sa'i se au hurowa. Fene Owane Sitewi Tai Pefine lo iyape se, meni eime lo iyape se, Hepene lo wara'i a'i se, lowe ma'e sa'i se au hurowa. Mk 16:15-16; Ap 1:8 ");
INSERT INTO sny_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Fene lu taune werese ma'e peri werese ano au te'e atuatu areiyete! Serai lowe peri werese ano wanu umasinamirowa. Wanure! Ane a'i lai fene mase ironamitorowa. Nowe ye'ewi ape henerairowa, ane fene mase ironamitorowa.” ");
INSERT INTO sny_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","One towe eite sahe Jisas lo peri heneruwe wisere a'i irosiya. Jisas Krais lai meni erasi pefine a'i tene! Jisas lai Owane Sitewi lo meni eime pefine a'i ne. ");
INSERT INTO sny_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Tu naifa weriyei meni ta Owane Sitewi lo peri leseye. Meni ape, iyape Aisaia, one towe ta se apou leseye, “Owane Sitewi lai meni eime topo lo awei hi ma'e eimawe arosairowa.” ");
INSERT INTO sny_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Meni ape pani ariye a'i sahe peri au te'e areiye fiyarisiya. Le apou eiye, “Fene meni ape lo yo, aiyeyei ape, au ta'uwe naneite.” Meni ape lai lu taune werese ma'e peri erasi au te'e fiyarirowa. “Lu taune werese wanute! Fene etiri luwaru werese a'i fu arunatire. Owane Sitewi lo meni eime pefine a'i aiyerowa.” ");
INSERT INTO sny_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Meni ape, Owane Sitewi eimawesai ape, iyape Jon pani ariye a'i sahe ironamiteye. Le Owane Sitewi lo peri au te'e fiyariteye. Le lu taune werese ma'e apou au te'e areiye fiyariteye, “Fene yo seni luwaru a'i fu arunatire. Yo seni luwaru a'i fene lo arunatiyei su, fene sa'i sahe ani huwei ne aiyere. Fene sa'i sahe ani huraiyei su, lu taune werese marepi hepene he'i a'i fene lo ma'e siye so'oruwerowa.” Ap 13:24; 19:4 ");
INSERT INTO sny_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Lu taune tomu ne'ese, omo pani Judia ma'e fai ape, sosu omo weniyei Jerusalem, iroteye ape, arunatiyewe, meni ape wanunarai. Lowe Jon lo peri wanuwe su, lowe ta'u yo seni luwaru a'i lowe lo ape au te'e areiyeye. Lowe yo seni luwaru a'i ape mo arunati su, Jon lai lowe Sa'i Jordan sahe au ani huwe. ");
INSERT INTO sny_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Meni ape Jon fe kamel lo tahe towe tou aniyewe, ipari tahe lo iwisiye. Le awiye mo'une tahe watipi sahe ti tawesiye. Le ya'e timene ateye. Le ineniye sa'i ateye. 2 Kin 1:8; Mt 11:8 ");
INSERT INTO sny_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Serai le lu taune ma'e apou au te'e areiyeye, “Meni erasi ta iyape se nowe ataheyewa. Ane meni yahowa'i ne. Meni ape iyape erasi a'i se. Ane lowe uporo ape'i onurowata. Ane lowe tahe wafei lo ape au ani erau ta'ama. Ap 13:25 ");
INSERT INTO sny_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ane fene sa'i sahe au ani husiya. Meni Owane Pefine a'i lai lu taune werese ma'e Owane Sitewi lo Hepene Wara'i a'i se au ani hurowa.” ");
INSERT INTO sny_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Sosu a'i pe Jisas omo Nasaret Galili lo pani sahe arunatiyewe, Sa'i Jordan ma'e itorai. Sosu Jon lai meni ape sa'i sahe au ani huwe. ");
INSERT INTO sny_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jisas sa'i ani hu tepa'asiye su, le sa'i papu wirai. Le sa'i papu arunatiyewe, wirai su, ni'arawe hire ma'e ponei erauwiye. Ni'arawe ponei erauwiye su, Owane Sitewi lo Hepene Wara'i a'i irowe sapuwe wou hire ma'e itoraiyewe, Jisas lo iyo'o hire sahe onurai. ");
INSERT INTO sny_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Sosu peri erasi ta ni'arawe ma'e apou te'e areiyeye, “Ne a'i lai meni eime ano ta'i pefine a'i ne. Ane ne a'i tote wawesiyenamisiya.” Sng 2:7; Ais 42:1; Mt 12:18; Mk 9:7 ");
INSERT INTO sny_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Sosu Owane Sitewi lo Hepene Wara'i a'i Jisas ma'e apou eiye, “Pani ariye a'i ma'e ire!” Sosu Jisas pani ariye a'i ma'e fiyewe, onuteye. Le onuteye su, pani ape sahe iroteye. You erawe, fe erawe, tomu ne'ese pani ape mase iroteye. ");
INSERT INTO sny_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Jisas pani ariye ape sahe poweiye pasi lu hesi ereti lowe werese woto a'i iroteye. Jisas le a'i lai woto a'i iroteye su, sepei luwaru aite iyape Satan, Jisas ma'e te'enarai. Le Jisas ma'e peri ta te'e areareyei ne toteye. Le apou eiye, “Jisas, ne lau erasi irosiya. Serai ne peri ano wanu umasire. Ne ayei etiri ta fara'u ta'anere, sosu ne are!” Ahowa, Jisas lai le ma'e itiya'u eiye. “Ahowa, ane peri no wanu umasirowata.” Owane Sitewi lo ipari wisere a'i (Ensel) Jisas ma'e itorai. Lowe Jisas ma'e au noweinoweiteye. Sng 91:11-13 ");
INSERT INTO sny_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Sosu a'i pe nowe me'iye su, ai atu siye lu tamo, Jon ereti lowe lo wafei se ti tawesiyewe, kalabus wesi papu ma'e ani fu arosawi. Sosu Jisas omo pani Galili sahe lu taune ma'e Owane Sitewi lo peri au te'e areiye fiyarinarai. Mk 6:17 ");
INSERT INTO sny_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Le apou au te'eye, “Nowe ape henerai tepa'asiye Owane Sitewi lai, lu taune werese ne au noweinoweiyei ape, ataheyewa. Fene werese yo seni luwaru a'i fene lo fu arunatire. Fene Owane Sitewi lo peri werese wanu tote tawesi umasire.” Mt 3:2 ");
INSERT INTO sny_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Sosu a'i pe Jisas hare ite Galili tewiye sahe iteye su, le lu hesi, hare honaiye fu aro ape, siyeye. Lu hesi ape lo iyape Saimon, sosu pa'ise lo iyape Andru. ");
INSERT INTO sny_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jisas lowesi ma'e apou eiye, “Fenesi ane mase aiyere! Ane fenesi ma'e wiyawi he'i a'i ta aurowa. Wiyawi ape fenesi ta'aneyei ape, fenesi lu taune werese Owane Sitewi ma'e hene anirowa. Ane lai yo ape fenesi ma'e au atuaturowa.” ");
INSERT INTO sny_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Sosu pereye a'i lowesi hare honaiye arunatiyewe, lowesi Jisas aiwawe a'i fi. ");
INSERT INTO sny_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yo sahe tewi oso ape iteye su, sosu le lu hesi tere'e siyeye. Lu hesi ape iyape Jems, sosu pa'ise lo iyape Jon. Lu hesi ape Sebedi lo eimane hesi. Lowesi hare honaiye lo yo ape ti iwisiteye. ");
INSERT INTO sny_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jisas lowesi ma'e apou eiye, “Fenesi ane mase aiyere!” Sosu lowesi lo aite ape, Sebedi lu tere'e tamo mase wai sahe arunatiyewe, lowesi Jisas aiwawe a'i fi. ");
INSERT INTO sny_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jisas lu hesiyo hesiyo mase omo Kaperneam ma'e heneri. Nowe amou (Sabat) se Jisas ta'uweyei wesi papu wiri. Saro ahe Jisas lu taune werese ma'e Owane Sitewi lo peri au te'e areiyeye. ");
INSERT INTO sny_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Lu taune peri ape wanuwe su, lowe hepene se su'ariye, lowe apou te'e tiyatiteye, “Meni ape lu owane, one towe leseteye ape, wou ta'ame. Peri lo ape tu nomo so'oru ta'ama. Le meni owane wou a'i peri ape au te'e areiyeye. Meni iyape se.” Mt 7:28-29 ");
INSERT INTO sny_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Sosu a'i pe meni ta sepei luwaru a'i lire papu iroteye ape, le Owane Sitewi lo ta'uweyei wesi ape papu wirai. Le hareyei erasi irowe. Apou hareye, ");
INSERT INTO sny_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Jisas, Ne piyene fai awere? Ne Jisas omo Nasaret lo meni tene! Ne nomo aine tera'eyei ne fai awere? Nomo ne siye so'oruweteye. Ne a'i lai Owane Sitewi lo meni eime pefine a'i tene!” Mk 5:7 ");
INSERT INTO sny_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Sosu Jisas sepei luwaru a'i ma'e apou eiye, “Peri sawa! Meni eite arunatire.” ");
INSERT INTO sny_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Jisas sepei luwaru a'i ma'e te'eye su, sepei luwaru a'i ape hareyei erasi irowe. Le meni ape lo tahe erasi a'i auseriye irowe, meni ape arunati fi. Mk 9:26 ");
INSERT INTO sny_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Lu taune, etiri ape siyeye su, lowe hepene se su'ariye. Lowe apou peri ta te'e tiyatiteye, “Sawi Amou! Meni ape peri he'i a'i au te'e atuatusiya. Le iyape erasi se. Sepei luwaru a'i ape peri lo ape wanuwe su, le peri lo umasiye.” ");
INSERT INTO sny_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Sosu witane a'i lu taune werese Galili lo pani sahe peri heneruwe ape wanuwe. Mt 4:24 ");
INSERT INTO sny_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Nowe mo'o su Jisas lu feni hesi lo, Jems, Jon, lowe Owane Sitewi lo ta'uweyei wesi arunatiyewe, Jisas lu feni werese lo aiwawe a'i, lowe Saimon, sosu pa'ise lo Andru lo wesi ma'e fi. ");
INSERT INTO sny_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Wesi ape ma'e henerai su, Saimon lo mai pape tahe umeri a'i iroteye. Lu taune tamo wesi papu iroteye ape, Jisas ma'e apou te'eye, “Menitani eite tahe umeri a'i irosiya.” ");
INSERT INTO sny_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Sosu Jisas menitani ape ma'e fi. Le menitani ape lo ereti sahe isawi hetesiyewe apou eiye, “Ne sine teire!” Sosu Jisas peri ape te'eye su, menitani ape lo tahe umeri a'i fara'uweyewe, arunati. ");
INSERT INTO sny_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Sosu a'i pe Jisas lo peri heneruwe omo pani werese au te'e fiyarisawi. Serai nowe neriwei su lowe lu taune tomu ne'ese u tahe se wesi ape sahe henetai. Lu taune u tahe se ape, lu taune sepei luwaru a'i lire papu iroteye ape mo, lowe aiwawe a'i lu taune werese wesi ma'e henetai. ");
INSERT INTO sny_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Lu taune tomu ne'ese omo pani werese ape sahe iroteye ape mo, lowe wesi ape yo tewiye sahe ta'uwerai. ");
INSERT INTO sny_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Serai Jisas lu taune tomu ne'ese u tahe se ape mo au ta'ane fara'uweye. Le sepei luwaru tomu ne'ese a'i au ta'ane sasarisawi. Sosu sepei luwaru a'i lu taune arunati su, le lowe werese ma'e apou eiye, “Fene ane ne owe ape te'e fiyarire!” Piyene awere? Sepei luwaru a'i ape mo Jisas ne so'oruweteye tene! Serai Jisas lowe lo peri au te'e amouweye. Mk 3:10-12 ");
INSERT INTO sny_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Esi pasi su Jisas woto a'i wesi ape arunatiyewe, ipo lu ta'ama ape ma'e fi. Owane Sitewi ma'e peri au te'eyei ne fi. Mt 14:23; Mk 6:46 ");
INSERT INTO sny_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Nowe me'iye su, Saimon, lu tamo mase le ani nehiyei ne fi. ");
INSERT INTO sny_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Lowe Jisas siyeye su, lowe le ma'e eiye, “Owane, lu taune werese ne ne ei toweriyei ne fai.” ");
INSERT INTO sny_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Sosu Jisas lowe ma'e itiya'u eiye, “Nomo omo eite arunatirowawe, omo tere'e ma'e iyei. Peri heneruwe wisere a'i ape lu taune werese ma'e au te'e fiyariyei.” ");
INSERT INTO sny_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Serai le omo ta'i ta'i a'i ma'e omo pani Galili sahe Owane Sitewi lo ta'uweyei wesi papu wiye. Le lu taune werese ma'e Owane Sitewi lo peri au te'e areiyeye. Le lu taune sepei luwaru a'i marepi hepene papu iroteye ape, au ta'ane sasarisawiteye. Mt 4:23; 9:35 ");
INSERT INTO sny_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Sosu a'i pe meni ta enite kairefi a'i tomu ne'ese se Jisas ma'e lowe uporo ape'i onurai Sosu le apou eiye, “Ne ane ne marepi erasi a'i ferafereiyei su, ne enite kairefi werese ano fara'u au ta'ane niyemaiyere.” ");
INSERT INTO sny_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Sosu Jisas meni ape ne marepi ferafereiyei ne toteye. Serai le ereti tesisawiyewe, meni ape hire ma'e fuwe. Sosu le ma'e eiye, “Ane ne ne au ferafereisiya. Ane enite kairefi werese no au ta'ane niyemaiyerowa.” ");
INSERT INTO sny_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Sosu Jisas meni ape enite tahe hire lo sahe fuwe su, enite kairefi a'i werese niyemaiyeye. ");
INSERT INTO sny_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jisas meni ape peri kairefi a'i se apou eiye, “Ne lu taune werese ma'e ane ne owe ape te'ete. Ne Juda lo meni owane ma'e enite kairefi werese no au atuatuwei ne ire. Ne iyei su, etiri tamo meni ape ma'e au heseyei ne aitire.” ");
INSERT INTO sny_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Tu naifa weriyei meni ta iyape Moses peri ta apou leseye, “Enite kairefi a'i no niyemaiyeyei su, etiri ta Juda lo meni owane ma'e au heseyei ne aitire. Serai lu taune werese enite kairefi a'i niyemaiyeyei ape siyerowa.” Sosu Jisas le ma'e apou tame eiye, “Ne lu taune werese ane ne ma'e owe ape te'ete!” Wkp 14:1-32 ");
INSERT INTO sny_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Meni ape Jisas arunatiyewe, fi su, le lu taune werese au te'e fiyariteye. Le apou eiye, “Jisas a'i lai enite kairefi a'i ano au ta'ane niyemaiyeye.” Serai lu taune werese peri lo ape wanuwe su, lowe Jisas ma'e siyenarai. Lowe werese Jisas ma'e henerai su, Jisas omo tere'e tere'e ma'e i ta'ame. Lu taune tomu ne'ese yo lo ape au einamiye. Serai le omo nowe ma'e iroteye. Lu taune tomu ne'ese omo pani tere'e tere'e ma'e fai ape, Jisas ma'e siyenarai. ");
INSERT INTO sny_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Me'iye poweiye ta se, Jisas omo Kaperneam ma'e si tame fi. Jisas wesi ta sahe iroteye. Lu taune tomu ne'ese Jisas, wesi ape sahe iroteye ape, wanunarai. ");
INSERT INTO sny_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Witane a'i lu taune tomu ne'ese wesi ape ma'e Jisas siyeyei ne ta'uwerai. Lu taune tomu ne'ese, Jisas iroteye ape, wesi ape papu teme'eriyeye. Lu taune tamo wesi nowe ma'e saro teiteye. Lu tamo wesi yo ape he'e tawesiye. Lu tere'e tamo wesi ape papu wirowata. Jisas lu taune werese siyeye su, le Owane Sitewi lo peri lowe ma'e au te'e areiyeye. ");
INSERT INTO sny_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Sosu lu hesiyo hesiyo, lowe meni lowe nono'oweyei a'i ape wari se sutaitetai. ");
INSERT INTO sny_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Lu taune tomu ne'ese yo he'e tawesiye. Ahowa, serai lowe meni ape Jisas ma'e wesi papu sutaite wi ta'ame. Serai lowe meni ape wesi me'iye hire ma'e sutaite wiye. Lowe wesi me'iye hire ma'e yo ta aine apeti toso fuwe. Lowe yo ape aine apeti toso fuwe su, sosu lowe meni lowe nono'oweyei ape wesi papu Jisas onuteye ape sahe, ani arowe. ");
INSERT INTO sny_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jisas meni ape siyeye su, le apou toteye, “Lu ape mo Owane Sitewi lo peri tote tawesisiya.” Sosu Jisas meni ereti lowe nono'oweyei a'i ape ma'e eiye, “Meni, ane yo seni luwaru a'i no ani sasari pamoweyei.” ");
INSERT INTO sny_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Juda lo lese siye lu tamo Jisas lo peri wanuwe su, lowe apou toteye, ");
INSERT INTO sny_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Sawi amou! Meni eite Owane Sitewi Pefine aiwawe a'i awere? Wawero! Meni eite meni luwaru a'i poto! Owane Sitewi ta'i a'i lai yo seni luwaru a'i au ta'ane sasari pamowesiya.” ");
INSERT INTO sny_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ahowa, Jisas marepi lowe lo siye so'oruweye su, le lowe ma'e apou ei toweriye, “Fene piyene marepi apou ape totesiya awere? ");
INSERT INTO sny_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Peri ano au te'eye ape, ane wiyawi ta'ane tohoteye awere? Piyete awere? Ane meni ape ma'e apou au te'eye su, ‘Ane yo seni luwaru a'i no ani pamoweyei.’ Atu tohoteyei awere? Fetane a'i awere? Ane peri ape au te'eye su, ane wiyawi orese se ta'ane ta'ame. Ane meni ape ma'e au te'eyei su, ‘Ne hire sine teire! Ne hawaiye no hese howeiteye ape, anirowawe, aiwawe sutetire.’ Peri ape atu tohoteyeisiya awere? Ahowa, fetane a'i tene! ");
INSERT INTO sny_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Serai ane fene ma'e au so'oruwe atuaturowa. Ane a'i lai, meni hire ma'e itorai ne. Ane fara'u yo seni luwaru a'i ani sasari pamoweyei tene!” ");
INSERT INTO sny_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Sosu Jisas meni ereti lowe nono'oweyei a'i ape ma'e eiye, “Meni, ne sine teire! Ne hawaiye no, hese howeiteye ape, anirowawe, aiwawe wesi no ma'e sutetire.” ");
INSERT INTO sny_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Jisas peri te'e tepa'asiye su, meni ape witane se sineteye. Le hawaiye lo aniyewe, sosu wesi topo lo ma'e suteti. Lu taune werese, wesi papu iroteye ape, lowe hepene erasi se su'ariye. Lowe apou te'eye, “Nomo peri wisere a'i Owane Sitewi ma'e au te'e wisereyeyei. Tu nomo pe etiri he'i apou ape eiwerai siye ta'ame! Nomo he'i a'i siyeye.” ");
INSERT INTO sny_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Sosu a'i pe Jisas hare ite tewiye ma'e si tame fi. Lu taune tomu ne'ese le ma'e peri lo wanuwei ne ta'uwerai. Sosu Jisas lowe ma'e Owane Sitewi lo peri au te'e areiyeteye. ");
INSERT INTO sny_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Peri te'e tepa'asiye su, le hare ite tewiye sahe fi. Le meni ta siyeye. Meni ape lo iyape Livai, Alfius lo meni eime. Livai wesi oso a'i ape sahe onuteye. Wiyawi lo ape takis ma'aru aniteye. Meni ape ta'arei a'i meni. Sosu Jisas le ma'e apou eiye, “Livai, ne ane mase aiyere!” Sosu Livai hire sineyewe, wesi oso lo ape arunatiyewe, Jisas mase fi. ");
INSERT INTO sny_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Me'iye su, Jisas lu disaipel lo mase Livai lo wesi ma'e ene ayei ne fi. Takis ma'aru ani siye lu tamo, lu tamo yo seni luwaru a'i ironamiteye ape, lowe aiwawe wesi ape sahe iroteye. Jisas lowe mase aiwawe ene ateye. Lowe Jisas mase nati wafei wou ne. ");
INSERT INTO sny_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Lowe ene a tepa'asiye su, lu tamo so'oruweyei erasi toteteye ape, lowe Jisas siyenarai. Lu tewi ape Farisi lo yo seni umasiteye. Sosu lu ape mo Jisas lo lu disaipel ma'e apou te'e toweriye, “Piyene Jisas lu luwaru a'i ape mase onu ateye awere? Lu ape mo ta'arei lu ne, lowe yo seni luwaru a'i werese ironamisiya.” Mt 11:19 ");
INSERT INTO sny_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jisas peri lowe lo ape wanuwe su, le lowe ma'e itiya'u apou eiye, “Ane dokta wou a'i ne. Lu ta u tahe se tamo irosiya ape su, ane lowe au ta'ane fara'uwerowa. Sosu lu ta u tahe wara'i a'i ape, lowe dokta ma'e irowata. Ane lu wisere a'i ei aniyei ne fai ta'ama. Ahowa, ane lu taune yo seni luwaru a'i ape, ei aniyei ne fai.” ");
INSERT INTO sny_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Sosu a'i pe Jon lo lu feni, sosu lu Farisi werese, lowe ene ayei siyenamiye. Lowe Jisas ma'e heneraiyewe. Peri ta Jisas ma'e te'e toweriyei ne fai. Lowe apou te'e toweriye, “Siyere! Jon lo lu feni, lu Farisi werese, lowe ene ayei siyenamisiya. Piyene lu disaipel no ayei werese siyenamiye ta'ame.” ");
INSERT INTO sny_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Sosu Jisas itiya'u eiye, “Meni ta tani lo naituwei su, lu taune werese ta'uwerai ape, lowe werese fara'u ene arowa. Ayei werese siyenamirowata. Lu tamo meni ape henetisawiyei su, tani lo ape lu taune werese mase ewiteyei erasi teriteyei. Lowe fara'u ayei werese siyenamirowa. ");
INSERT INTO sny_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Nowe ta su meni ape tani lo naituwei ape sato irotorowata. Nowe ape se lu taune werese ayei siyenamirowa.” ");
INSERT INTO sny_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Sosu Jisas apou te'eteye, “Ipari tahe papa'u a'i irosiya ape, ipari tahe he'i tewi se iwisirowata. Ahowa, me'iye su ipari tahe papa'u a'i sa'i se au huwei. Le ipari tahe ape taitiyei su, ipari tahe apetiyei. Yo erasi heneraiyei. ");
INSERT INTO sny_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Menitani ta ene towei su, le nau wahu wisere a'i se ani asiyei. Menitani nau wahu papa'u a'i sahe sa'i ani terosowei su, wahu ape erauwirowawe, nau ape awei peperi ma'e apa'asi itorowa.” ");
INSERT INTO sny_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sosu a'i pe nowe amou (Sabat) se, Jisas lu disaipel lo mase ta'aneyei awei kewi so sahe iteye. Lowe ta'aneyei awei sahe iteye su, lu disaipel lo ape kewi so une aniteye, sosu ene ateye. ");
INSERT INTO sny_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Sosu Jisas lo lu disaipel kewi so tamo ene ateye su, lu Farisi tamo lai lowe ma'e siyeye. Lowe Jisas ma'e apou eiye, “Sawi amou! Siyere! Lu disaipel no kewi lo'u tamo aniyewe, sosu ene ateye. Wiyawi ape nowe amou (Sabat). Nowe poweiye eite se lu taune werese wiyawi ta'anerowata.” Lo 23:25 ");
INSERT INTO sny_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Sosu Jisas lowe ma'e itiya'u apou eiye, “Fene etiri ta i'anenatiye awere? Meni owane fene lo, iyape Devit, le lau mase iroteye su, le lu disaipel lo mase Owane Sitewi lo wesi papu wiye. 1 Sml 21:1-6 ");
INSERT INTO sny_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Le lu disaipel lo mase Owane Sitewi lo nau ta'ase amou ateye. Owane Sitewi lai nau ta'ase amou ape lu taune werese ma'e nau ta'ase lo ape au siyenamiye. Au heseyei lu owane, le ta'i a'i fara'u nau ta'ase amou ape ene arowa. Au heseyei lo meni owane tutawe iyape Abiatar. Wkp 24:5-9 ");
INSERT INTO sny_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Nowe amou (Sabat) ape ta'aneye su, le lu taune ne nowe ape tei fetaneyeyei ne ta'aneye. Ahowa, nowe ape lai lu taune werese ma'e au noweinoweirowata. Lo 5:14 ");
INSERT INTO sny_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ane Meni Owane ape, Owane Sitewi lai hi awei ma'e eimawe arosai ape, ane a'i lai nowe amou (Sabat) ape au noweinoweinamitorowa.” ");
INSERT INTO sny_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Nowe amou (Sabat) poweiye ta se Jisas ta'uweyei wesi ape ma'e tame fi. Wesi ape sahe meni ereti luwaru a'i ta iroteye. ");
INSERT INTO sny_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Lu tamo Jisas ma'e siye etiyei ne toteye. Nowe amou (Sabat) poweiye ape se, lu taune werese wiyawi ta'aneyei ne amouweteye. Lowe apou toteye, nowe amou (Sabat) ape se, Jisas yo peri nomo lo arisiyei su, nomo le etirowa. Jisas meni ereti luwaru a'i ape au ta'ane fara'uweyei awere? Piyete awere? ");
INSERT INTO sny_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Sosu Jisas meni ereti luwaru a'i ape ma'e apou eiye, “Meni, ne ponei sahe sine teira!” ");
INSERT INTO sny_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Sosu Jisas lu werese ma'e apou ei toweriye, “Nowe amou (Sabat) lo eite se, nomo fara'u etiri wisere a'i wiyawi ta'aneyei amouweyei awere? Nomo fara'u etiri luwaru a'i wiyawi ta'aneyei amouwerowa awere? Nomo lu taune ferafereiyei amouwe tiyatirowa awere? Piyete awere?” Serai lowe werese peri te'e se ta'ame. Lu 14:3 ");
INSERT INTO sny_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Sosu Jisas lu werese ma'e ai marepi atati siye etiye. Le ahi tahe tomuwe. Jisas lu ape lo marepi kororu a'i siyeye su, le marepi ewiteye erasi a'i toteye. Sosu le meni ereti luwaru a'i se apou eiye, “Ne ereti tesi fareraiyere!” Sosu meni ereti luwaru a'i tesi fareraiyeye su, Jisas ereti luwaru a'i ape au ta'ane fara'uweye. ");
INSERT INTO sny_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Lu ape mo siyeye su, lu Farisi werese ta'uweyei wesi ape arunatiyewe, lowe Herot lo lu feni ma'e etiyei ne au te'eteye. Lowe Jisas aine tera'eyei ne toteye. Mt 22:15-16 ");
INSERT INTO sny_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Sosu Jisas meni ereti luwaru a'i au ta'ane fara'uweye su, le lu disaipel lo mase ta'uweyei wesi ape arunatiyewe, hare ite tewiye ma'e fi. Lu taune tomu ne'ese Galili lo omo pani sahe le mo'o fi. Lu taune Judia lo omo pani sahe le mo'o aiwawe a'i fi. ");
INSERT INTO sny_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Lu taune tomu ne'ese omo pani tere'e tere'e ma'e fai ape, lowe Jisas lo wiyawi erasi a'i ta'aneteye ape, wanuwe. Serai lowe Jisas ma'e siyeyei ne fai. Lu taune tamo omo Jerusalem ma'e fai. Lu taune omo pani Idumea ma'e fai. Lowe omo pani Sa'i Jordan feni eire ma'e fai. Sosu lu taune omo pani Tair sosu Saidon ma'e fai. ");
INSERT INTO sny_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Sosu Jisas lu taune werese siyeye su, le lu disaipel lo ma'e apou eiye, “Fene wai ta ta'uwe naneite. Lu taune tomu ne'ese ane ma'e hare ite sahe ani erete itesawi. Ane wai papu arowatowei su, lu taune werese ape ane ma'e tei ataheyerairowata.” ");
INSERT INTO sny_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Mi mi werese Jisas lai lu taune u tahe se au ta'ane fara'uweye. Serai lu taune tomu ne'ese u tahe se, enite kairefi a'i se lowe lo ereti se Jisas lo tahe sahe anite teriteyei ne aiyeteye. Mt 14:36 ");
INSERT INTO sny_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Lu taune tomu ne'ese, sepei luwaru a'i marepi hepene papu iroteye ape, Jisas siyeye su, lowe awei sahe ape'i onuwewe, sosu peri erasi apou hareye, “Jisas, ne a'i lai Owane Sitewi lo meni eime wiyeme a'i tene!” Lu 4:41 ");
INSERT INTO sny_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Sosu Jisas sepei luwaru a'i ma'e ai marepi se apou au itawiye, “Peri sawa! Fene iyape ano owe ape te'e fiyarite!” Mk 1:34 ");
INSERT INTO sny_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Sosu a'i pe Jisas omo hire ta ma'e yaneyewe, tapiye sahe onuwe. Le lo lu feni ta'i ta'i a'i, le lai au ariariyeye ape, ei aniye. Sosu lu disaipel lo ape le ma'e wanuwei ne fai. ");
INSERT INTO sny_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Sosu le lu ereti feni hesi lowe hesi a'i (12 disaipel) ei ariariyeye. Lowe lai le mase ironamiteyei. Lowe peri lo wanu umasiteyei su, lowe lu taune werese ma'e peri lo ape au te'e areiye fiyarirowa. ");
INSERT INTO sny_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Lowe meni ta, sepei luwaru a'i marepi hepene papu iroteye ape, siyeyei su, lowe kairefiyeyei lo aniyewe, sepei luwaru a'i werese ape mo au ta'ane sasarirowa. ");
INSERT INTO sny_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Le lu disaipel lo ereti feni hesi lowe hesi a'i (12) au ariariyeye. Iyape lowe lo apou a'i ne. Meni ta Saimon. Jisas meni ape iyape tere'e au eiye, Pita. Jo 1:42 ");
INSERT INTO sny_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Meni tere'e lo iyape Jems, Sebedi lo meni eime. Jems lo pa'ise, Jon. Jisas lai lowesi iyape tere'e au eiye, Boanerges. Iyape ape lo si tewi apou ape, pesiyei lo eimane. Lu 9:54 ");
INSERT INTO sny_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Lu tere'e le lai ei ariariyeye, Andru, meni tere'e Filip, meni tere'e Bartolomyu, meni tere'e Matyu, meni tere'e Tomas, meni tere'e Jems, Jems lo aite Alfius. Meni tere'e iyape Tadius, meni tere'e lo iyape Saimon. Meni ape omo Selot lo meni owane. Le Rom lo lu owane ai atuwei ne tiyatiteye. ");
INSERT INTO sny_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Sosu le Judas Iskariot ei ariariyeye. Meni ape lai Jisas ai lu tamo ma'e areare henetirowa. ");
INSERT INTO sny_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Sosu a'i pe Jisas lu disaipel lo mase omo hi ma'e itorai wesi ta ma'e fi. Lu taune tomu ne'ese le ma'e peri lo wanuwei ne ta'uwerai. Serai Jisas lu disaipel lo mase piye nowe se ene arowata. ");
INSERT INTO sny_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Sosu lu tewi topo lo tamo omo Nasaret ma'e fai ape, etiri werese wanuwe su, lowe Jisas ne apou toteye, “Jisas lo marepi meremereye irowe. Nomo le omo sitewi topo lo ma'e henetiyei.” ");
INSERT INTO sny_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Lu tamo, Owane Sitewi lo yo peri siye so'oruwe etiteye ape, lowe omo Jerusalem arunatiyewe, Jisas ma'e itorai. Lowe apou toteye, “Sepei luwaru iyape Belsebul Jisas lo marepi hepene papu ironamisiya. Le Belsebul lo kairefiyeyei se sepei luwaru a'i au ta'ane sasarisawisiya.” Mt 9:34; 10:25 ");
INSERT INTO sny_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Sosu Jisas lu tewi ape le ma'e ei aniye. Le lowe ma'e peri anowe se au te'eye. Le lowe ma'e apou eiye, “Fene eiwerou totesiya awere? Sepei luwaru, Satan lai fara'u le ta'u marepi hepene papu au ta'ane sasarirowa awere?” ");
INSERT INTO sny_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Omo ta lo lu owane, lowe ai atu tiyatiyei su, omo ape tei kairefiyerowata. ");
INSERT INTO sny_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Aiwawe a'i meni owane lai eimane lo ma'e ai atu tiyatiyei su, lowe werese tei kairefi irorowata. ");
INSERT INTO sny_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Sosu aiwawe a'i sepei luwaru a'i, Satan le a'i lai sepei luwaru a'i tere'e tere'e se ai atu tiyatiyei su, marepi lowe lo ponei erauwiyei. Serai le tei kairefiyerowata. Ahowa, le sepei luwaru a'i (Satan) lo aiwawe a'i po'uterowa. ");
INSERT INTO sny_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Wanure! Meni ta lai meni kairefi lo wesi ma'e etiri ta ta'arei aniyei ne toteyei su, le tu meni kairefi a'i wafei se ereti lowe ti tawesirowa. Serai le wesi lo ape papu wirowawe, etiri werese lo ta'arei anirowa. ");
INSERT INTO sny_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Peri ano wiyeme a'i tene. Wanure! Yo seni luwaru werese a'i, lu taune irowei ape, Owane Sitewi lai au ta'ane sasarirowa. Aiwawe a'i lu taune peri naruwe Owane Sitewi tai nomo lo ma'e au te'e naruwei su, Owane Sitewi lai yo seni luwaru a'i ape au ta'ane sasarirowa. ");
INSERT INTO sny_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ahowa, lu taune tamo Owane Sitewi lo Hepene Wara'i ma'e au te'e naruwei su, Owane Sitewi lai yo seni luwaru a'i lowe lo au ta'ane sasarinamirowata. Serai lowe yehe omo ma'e mi mi pasi pasi ironamitorowa. ");
INSERT INTO sny_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Lu tewi ape mo peri ape apou te'eye, “Jisas sepei luwaru a'i marepi hepene papu ironamisiya.” Serai Jisas peri ape ne au te'e areiyeye. ");
INSERT INTO sny_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Sosu a'i pe Jisas lo mai, pa'ise werese lo aiwawe a'i wesi ma'e henerai. Sosu lowe wesi nowe ma'e teiteye su, lowe peri ta le ma'e te'esawi. Mk 6:3; Jo 2:12; Ap 1:14 ");
INSERT INTO sny_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Lu taune tamo Jisas atahe a'i onuteye ape, lowe Jisas ma'e eiye, “Wanure! Mai no, pa'ise no, einei werese no, lowe nowe ma'e irosiyawe, ne ma'e peri te'eyei ne fai.” ");
INSERT INTO sny_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Sosu Jisas lowe ma'e itiya'u eiye, “Mai ano, pa'ise ano, einei ano, eiwerai awere?” ");
INSERT INTO sny_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Sosu Jisas lu taune werese, onuwe ape, atahe a'i yose siye etiye. Sosu le apou eiye, “Siyere! Lu taune eite mo, lowe werese mai ano, pa'ise ano, einei ano wiyeme a'i tene! ");
INSERT INTO sny_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Lu taune ape mo peri werese ano wanu tote tawesi umasiyei su, lowe mai ano, lowe pa'ise ano, lowe einei ano wiyeme a'i tene!” ");
INSERT INTO sny_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Sosu a'i pe Jisas lu disaipel lo mase hare ite tewiye ma'e si tame itori. Le lu taune tomu ne'ese ma'e Owane Sitewi lo peri au te'e fiyariteye. Lu taune tomu ne'ese le ma'e peri lo wanuwei ne ta'uwerai. Lu taune werese tei ataheyeteye. Jisas eiwerou ma'e teirowata. Le wai ta papu arowatowewe, wai pihatu sahe onuwe. Lu disaipel lo wai ape sa'i ma'e tewi itesawi. Sosu Jisas lu taune werese ma'e, hare ite tewiye sahe teiteye ape, peri anowe ta au te'eteye. Mk 3:7-9; Lu 5:1-3 ");
INSERT INTO sny_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Sosu Jisas lu taune werese ma'e peri anowe tamo au te'eteye. Le lowe ma'e apou au te'eteye, Mt 13:34; Mk 4:33-34 ");
INSERT INTO sny_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Fene werese peri anowe eite wanure! Meni ta me so ta'aneyei awei ma'e ani terosowei ne fi. ");
INSERT INTO sny_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Meni ape me so ani teroso fiyariteye su, me so tamo yo tewiye ma'e winetaiye. Witane a'i irowe tamo lai yo tewiye ma'e sine itoraiyewe, me so werese a tepa'asiye. ");
INSERT INTO sny_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Me so tamo awei tapiye a'i sahe winetaiye. Awei peperi tewi oso a'i. Serai me so witane a'i perati wirai. ");
INSERT INTO sny_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Sosu poweiye wirai su, poweiye lai wamu oso ape ti haroharoweye. Napi lo tapiye sahe tewi itori. Serai wamu werese ape ti haroharoweye ");
INSERT INTO sny_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Sosu me so tere'e tamo wafei saneyei ni'ari a'i ponei winetaiye. Wafei saneyei luwaru a'i ape wiraiyewe, me so ape napetu tawesiye. Serai me so lo meni patiye erasi a'i teirowata. Me so werese ta'erowata. ");
INSERT INTO sny_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Sosu me so tamo ta'ane awei wisere a'i sahe winetaiye. Me so ape peratiye su, me so werese erasi a'i etineye. Me so tamo wisere erasi a'i ta'eye. Me so tamo erasi a'i ta'eye. Me so tamo tewi oso a'i ta'eye. ");
INSERT INTO sny_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Lu taune apaniye se, fene peri anowe eite wanu tote tawesire.” ");
INSERT INTO sny_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Sosu a'i pe lu taune werese omo towafi lowe lo ma'e fiyariti. Jisas lu disaipel lo, sosu lu taune tamo le mase iroteye. Lowe le ma'e peri anowe lo sitewi ne apou te'e towerirai, “Peri anowe ape, ne lu taune werese ma'e au te'eye ape, piye peri lo sitewi te'esiya awere?” ");
INSERT INTO sny_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jisas itiya'u eiye, “Owane Sitewi lo marepi werese ape, ane lu taune ma'e peri anowe se au te'e fiyariye. Ane pereye fene ma'e au te'e areiyerowa. Lu taune tere'e tere'e peri anowe lo sitewi wanu so'oruwerowata. ");
INSERT INTO sny_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Tu naifa meni ta apou leseye. ‘Lu taune tamo Owane Sitewi lo marepi siye so'oruweyei su, lowe Owane Sitewi lo marepi wanu tote tawesirowata. Lowe Owane Sitewi lo peri wanuwei su, lowe Owane Sitewi lo peri lo sitewi ape wanu tote tawesi umasirowata. Lu taune tamo Owane Sitewi lo peri lo sitewi wanu tote tawesi umasiyei su, lowe Owane Sitewi ma'e si tame aiyeye su, sosu Owane Sitewi lai yo seni luwaru a'i lowe lo au ani ta'ane sasari pamoweye.’” ");
INSERT INTO sny_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Sosu le lowe ma'e apou ei toweriye, “Peri anowe lo sitewi fene wanu so'oruweye awere? Ane fene ma'e peri anowe tamo au te'eyei su, fene peri anowe lo sitewi werese wanu so'oruweyei awere? ");
INSERT INTO sny_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Wanure! Ane peri anowe lo sitewi ape fene ma'e au te'e areiyerowa. Meni ape me so ta'aneyei awei ma'e, ani teroso fiyariteye ape, me so ape mo Owane Sitewi lo peri aiwawe a'i au te'e fiyarisiya. ");
INSERT INTO sny_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Me so tamo yo mai tewiye ma'e winetaiyei su, apou wou a'i lu taune tamo Owane Sitewi lo peri wanuwei. Sepei luwaru a'i (Satan) lu taune ape mo ma'e witane a'i aiyeye su, Owane Sitewi lo peri ani tepa'asi anirowa. Serai lowe Owane Sitewi lo peri wanu tote tawesi umasirowata. ");
INSERT INTO sny_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Aiwawe a'i me so tamo awei tapiye sahe winetaiyei su, apou wou a'i ne. Lu taune tamo Owane Sitewi lo peri wanuwei. Lowe Owane Sitewi lo peri wanuwei su, lowe marepi wisere a'i se wanu toteyei. ");
INSERT INTO sny_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Sosu nowe me'iye su etiri luwaru a'i lowe ma'e heneraiyei, lu tamo yo seni luwaru a'i lowe ma'e irowei su, lowe Owane Sitewi lo peri arunatirowawe, lowe yo seni luwaru ape ma'e si tame umasirowa. ");
INSERT INTO sny_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Me so tamo wafei saneyei ni'ari a'i ponei sahe winetaiyei apou wou a'i ne. Owane Sitewi lo peri lu taune tamo ma'e au te'e fiyariyei su, lowe Owane Sitewi lo peri ape wanu toteyei. ");
INSERT INTO sny_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Sosu awei lo yo seni tamo marepi hepene werese lire papu wirowa. Lowe ma'aru lo marepi, arearesiya ape, erasi a'i toterowa. Awei lo etiri tere'e tere'e lai lu taune ape mo papu wirowa. Serai awei lo yo seni, ma'aru lo marepi, sosu etiri tere'e tere'e, lowe lai Owane Sitewi lo peri napetu leyau tepa'asirowa. Serai lu taune ape mo Owane Sitewi lo peri wanu tote tawesi umasirowata. Sosu lowe tei kairefiyerowata. Mt 19:23-24 ");
INSERT INTO sny_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Me so tamo awei wisere a'i ma'e winetaiyei apou wou a'i ne. Lu taune tomu ne'ese Owane Sitewi lo peri wanuwei su, lowe peri ape wanu tote tawesi umasinamirowa. Lowe Owane Sitewi lo marepi ape se tei kairefiyerowa. Serai lowe Owane Sitewi lo wiyawi werese irorowa. Lu taune tamo Owane Sitewi lo wiyawi oso a'i anirowa. Lu taune tamo Owane Sitewi lo wiyawi erasi a'i anirowa. Aiwawe a'i lu taune tamo Owane Sitewi lo wiyawi erasi pefine a'i au ta'anerowa.” ");
INSERT INTO sny_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Sosu Jisas lowe ma'e apou ei toweriye, “Fene yehe lam taiso fu mitaiyeyei su, fene wahu ta unahi papu fu fareyareyei awere? Ahowa, fene wari unahi fu fareyareyei awere? Ahowa, fene yehe lam taiso fu mitaiyeyei su, fene hire amerame a'i au teire. Serai lu taune werese wesi papu iroteye ape, yehe mitaiyeyei amerame a'i siyerowa. Mt 5:15; Lu 11:33 ");
INSERT INTO sny_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Lu taune tamo etiri ta fareyareyei ne toteyei su, Owane Sitewi lai etiri ape amerame a'i au atuatu areiyerowa. Aiwawe a'i lu taune tamo peri te'e fareyareyei ne toteyei su, Owane Sitewi lai peri ape amerame a'i au te'e fiyarirowa. Mt 10:26; Lu 12:2 ");
INSERT INTO sny_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Lu taune apaniye se, fene peri ano ape fa wanu tawesire.” ");
INSERT INTO sny_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Sosu le lowe ma'e apou au te'eye, “Weiyai! Fene peri tere'e tere'e tamo wanuwei ape, fene peri ape tote etire. Peri tamo wisere a'i ne. Peri tamo luwaru a'i ne. Fene peri luwaru a'i owe ape tote umasire. Fene lu taune lo yo seni siye eti tiyatiyei su, Owane Sitewi lai yo seni fene lo siye etirowa. Sosu Owane Sitewi yo seni fene lo luwaru a'i siye so'oruweyei su, le etiri orese erasi a'i fene ma'e aurowa. Mt 7:2 ");
INSERT INTO sny_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Lu taune tamo Owane Sitewi lo marepi erasi a'i tote tawesiyei su, Owane Sitewi lai lowe ma'e yo seni aseyaro lo erasi a'i aurowa. Lu taune tamo Owane Sitewi lo marepi me'iyeni ma'e atati aruwei su, Owane Sitewi lai etiri werese lowe lo ani tepa'asi anirowa.” Mt 13:12; 25:29; Lu 19:26 ");
INSERT INTO sny_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Sosu a'i pe Jisas peri anowe ta lowe ma'e apou au te'eye. “Owane Sitewi lo marepi apou wou a'i ne. Meni ta me so tamo ta'aneyei awei ma'e fu ani teroso fiyarisawirowa. ");
INSERT INTO sny_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Le me so ape awei sahe aine teroso fiyarisawirowa su, le wesi topo lo ma'e pasi a'i nihe howeiyei ne irowa. Nowe me'iye su me so ape perati wirairowa, wamu hire ma'e wirairowa. Me so perati wirairowa ape, meni ape eiwerou toterowa awere? Le so'oru ta'ama. ");
INSERT INTO sny_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Awei ape lai me so ape perati wiyei ne irorowa. Tu me so ape peratirowa. Sosu wamu lo ape hire ma'e wirairowa. Me'iye su, me so tei kairefiyerowa. Sosu erasi teirowa su, me so ape erasi a'i ta'erowa. ");
INSERT INTO sny_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Me so ayei siyeyei su, meni ape ipari mene'e lo me so lo meni patiye papa'u foro'oweyei ape, aine tou fusawirowawe me so ape mo wesi ma'e aitirowa.” Jol 3:13; KTH 14:15 ");
INSERT INTO sny_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Sosu a'i pe le apou te'eye, “Owane Sitewi lo marepi, eiwerou ane fene ma'e au te'e atuaturowa awere? Piye peri anowe ta ane au te'e atuaturowa awere? Serai fene Owane Sitewi lo marepi amerame a'i wanu tote areiyerowa. ");
INSERT INTO sny_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Owane Sitewi lo marepi saiyoho so wou a'i ne. Saiyoho so ta'aneyei awei sahe ani teroso fiyariyei su, me so ape oso oso a'i ne. Me so tere'e werese erasi a'i ne. ");
INSERT INTO sny_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Saiyoho so ape awei sahe ani terosowei su, le perati wirairowa. Saiyoho lo meni patiye erasi a'i teirowa. Saiyoho nei erasi a'i irorowa. Serai irowe tamo nei lo sahe onurowa. Aiwawe a'i lowe uri lowe lo saiyoho nei ape sahe ta'anerowa.” ");
INSERT INTO sny_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Sosu a'i pe Jisas lowe ma'e peri anowe tomu ne'ese au te'e fiyariteye. Le Owane Sitewi lo peri, peri anowe se au te'eye. ");
INSERT INTO sny_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Le lowe ma'e au te'eye su, le peri anowe a'i au te'eye. Le peri amerame a'i au te'e ta'ame. Sosu Jisas lu disaipel lo mase a'i iroteye su, le peri anowe lo sitewi lowe ma'e au te'e areiyeteye. ");
INSERT INTO sny_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Jisas peri anowe te'e tepa'asiye su, neriwei a'i le lu disaipel lo ma'e apou eiye, “Nomo hare ite tewiye feni ma'e iyatutiyei.” ");
INSERT INTO sny_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Lowe lu taune werese hare ite tewiye sahe arunatiyewe, hare ite ponei ma'e iyatuti. Jisas wai si ma'e onuwe. Wai tere'e tere'e aiwawe a'i lowe mase sa'i ape ma'e iyatuti. ");
INSERT INTO sny_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Lowe sa'i ponei sahe iroteye su, fiyari erasi ta henerai. Sa'i ei erasi a'i wai ani awetu awetowe. Sa'i erasi a'i wai papu teme'eriyeye. ");
INSERT INTO sny_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Sosu Jisas wai si ma'e me tuto'u sahe nihe howeiteye. Lowe sa'i ei erasi siyeye su, lowe atoweiye erasi a'i irowe. Lowe le eisoweye, apou eiye, “Meni Owane, sa'i ei lai nomo ani aporuwa. Ne nomo werese ne ewite se ta'ama awere? Nomo temeniye ataheyewa.” ");
INSERT INTO sny_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Sosu Jisas nihe lo petaneye su, le fiyaru, sa'i ei erasi ma'e apou eiye, “Fiyaru, sa'i ei titanere.” Pereye a'i fiyaru sa'i ei titane temeniyeye. ");
INSERT INTO sny_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Sosu Jisas lowe ma'e eiye, “Fene piyene atoweiyesiya awere? Fene Owane Sitewi lo marepi tote tawesi se ta'ama awere?” ");
INSERT INTO sny_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Lowe peri lo wanuwe su, lowe marepi atoweiye erasi irowe. Lowe a'i lai apou te'e tiyatiteye. “Meni eite eiwerai awere? Fiyaru, sa'i ei eite peri lo wanu umasiye.” ");
INSERT INTO sny_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Sosu a'i pe sa'i ei temeniye titaneye su, lowe hare ite tewiye ma'e iyatuti. Lowe wai sa'i tewiye ma'e furi. Omo pani ape ma'e, iyape Gerasa, wai lowe lo furi. ");
INSERT INTO sny_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Le wai ape arunatiyewe, awei sahe arowatowe. Witane a'i meni ta sepei luwaru a'i marepi hepene papu iroteye ape, le ma'e itero itorai. Meni ape fisiye yo sahe iroteye. ");
INSERT INTO sny_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Meni ape fisiye yo papu howeinamiteye. Le meni kairefi a'i ne. Owe lu tamo ereti lowe wafei kairefi a'i se ti tawesirowata. ");
INSERT INTO sny_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Lowe ereti lowe wafei se ti tawesiye su, le wafei ape ani erau tepa'asiye. Lu werese meni ape wafei se ti tawesirowata. Meni kairefi a'i ne. ");
INSERT INTO sny_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Mi mi pasi pasi meni ape, fisiye yo sahe iroteye ape, hare erasi uteye. Le tahe topo lo sahe tapiye se aine touwe. ");
INSERT INTO sny_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Meni ape Jisas eyeri ma'e siyerai su, le Jisas ma'e iterotaiyewe, le ma'e lowe uporo ape'i onuwe. ");
INSERT INTO sny_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Jisas meni ape siyeye su, le sepei luwaru a'i ma'e apou eiye, “Sepei luwaru a'i, ne meni ape arunatire. Ne howe ma'e hene tahesa!” Sosu sepei luwaru a'i ape Jisas ma'e hare erasi uteye, “Jisas, ne Owane Sitewi Pefine lo meni eime a'i ne. Ne nomo ma'e piye irowei awere? Owane Sitewi lo iyape se, ne nomo ma'e owe ape au luwaruwere.” Mk 1:24 ");
INSERT INTO sny_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Sosu Jisas le ma'e apou ei toweriye, “Iyape no eiwerou awere?” Sepei luwaru a'i le ma'e itiya'u eiye, “Iyape nomo lo tomu ne'ese a'i. Sepei tomu ne'ese meni marepi hepene papu ironamisiya.” ");
INSERT INTO sny_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Le Jisas ma'e peri ta ei toweriye, “Ne omo pani nowe ma'e owe ape eimawesawire!” ");
INSERT INTO sny_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Sepei luwaru a'i ape fe tomu ne'ese omo to'u nepesi ma'e siyeye. Lowe awei peperi ene ateye. ");
INSERT INTO sny_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Le Jisas ma'e ei toweriye, “Ne nomo fe tomu ne'ese ape ma'e eimawesawire. Serai nomo fe papu wirowa.” ");
INSERT INTO sny_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jisas lowe ma'e eiye, “Fene fe ape mo ma'e ire!” Sepei luwaru a'i werese a'i meni ape arunatiyewe, fe tomu ne'ese ape papu wiye. Sepei luwaru werese a'i fe papu wiri su, fe werese, omo to'u nepesi ene ateye ape, omo hi sa'i ma'e itero itori. Fe tomu ne'ese (2,000) sa'i papu tenise temeniyeye. ");
INSERT INTO sny_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Lu ape, fe au noweinoweiye ape, fe werese lowe lo sa'i papu tenise temeniyeye su, lowe omo towafi lowe lo ma'e atoweiye iteroti. Lowe lu taune werese omo tere'e tere'e ma'e te'e fiyariteye. Sosu lu taune werese fe ape siyeyei ne witane se fai. ");
INSERT INTO sny_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Lowe Jisas ma'e henerai. Lowe meni ape sepei luwaru a'i, marepi hepene papu iroteye ape wisere a'i siyeye. Le Jisas ma'e atahe a'i onuteye. Le ipari tahe ani asiteye. Marepi lo fara'u a'i toteteye. Lowe etiri werese siyeteye. Serai lowe atoweiye erasi iroteye. ");
INSERT INTO sny_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Lu tewi ape, fe au noweinoweiteye ape, lowe peri werese lu taune ma'e au te'e fiyariteye. Lowe meni sepei luwaru a'i papu iroteye ape ne au te'eye. Sosu fe werese ape mo, sa'i papu tenise temeniyeye ape ne au te'e fiyariteye. ");
INSERT INTO sny_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Lu taune peri lowe lo wanuwe su, lowe Jisas ma'e peri erasi se eiye, “Ne omo pani nomo lo fu arunatire.” ");
INSERT INTO sny_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Serai Jisas peri lowe lo wanuwe su, le lu feni mase wai papu arowatowe. Meni tu sepei luwaru a'i iroteye ape, le ma'e peri kairefi se apou ei toweriye, “Ane fara'u ne mase irowa awere?” ");
INSERT INTO sny_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jisas le ma'e itiya'u apou eiye, “Ahowa, ne wesi no ma'e, lu tewi no ma'e aiwawe a'i ire. Ne lowe werese ma'e te'e fiyarire. Meni Owane Pefine lai ne au ta'ane feraferei fara'uweye. Ne ferafereiyei lo ape ne au te'e fiyariteye.” ");
INSERT INTO sny_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Sosu meni ape Jisas arunatiyewe, lu taune werese ma'e omo pani Dekapolis sahe au te'e fiyariteye. “Jisas lai ane au ta'ane fara'uwe wisereyeye.” Lu taune werese peri lo wanuwe su, lowe hepene se su'ariye. Lowe Jisas ne marepi erasi a'i toteteye. ");
INSERT INTO sny_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jisas, lu disaipel lo mase, hare ite ponei iyatu toneri. Sa'i feni ma'e heneri su, lu taune werese Jisas lo peri wanuwei ne ta'uwerai. Jisas hare ite tewiye atahe sahe iroteye. ");
INSERT INTO sny_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ta'uweyei wesi meni owane ta Jisas ma'e henerai. Meni owane lo iyape Jairus. Le Jisas siyeye su, le le ma'e lowe uporo ape'i onuwe. ");
INSERT INTO sny_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Le Jisas ma'e peri kairefi se apou ei toweriye, “Owane, eime taune ano u tahe erasi se, temeniyeyei ne ataheyewa. Ne wesi ano aiyere. Ereti no eime taune ano hire ma'e isawe hetesiyere. Serai u tahe erasi lo ape au ta'ane fara'uwere. Sosu le si tame sinerowa.” ");
INSERT INTO sny_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Sosu Jisas meni ape mase wesi lo ma'e fi. Lu taune tomu ne'ese lowesi aiwawe mo'o umasiteye. Lowe Jisas sahe ataheye iteye. ");
INSERT INTO sny_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Lowe fi su, menitani ta u fisa'i weriyei iroteye. Iyu menei ereti feni hesi lowe hesi a'i (12) fisa'i nowe ma'e henerai. ");
INSERT INTO sny_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Menitani ape dokta tomu ne'ese ma'e siyenari. Lowe le ma'e fofowei erasi au ta'ane irowe. Le ma'aru werese lo dokta tomu ne'ese ma'e au po'uteye. Ahowa, fisa'i lo weriyei ironamiteye. Menitani lo u tahe erasi a'i ironamiteye. Foro'owe ta'ame. ");
INSERT INTO sny_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Le Jisas lo peri heneruwe wanuwe su, le lu taune werese ponei sahe me'iyeni ma'e fai. Le apou toteye, “Ane ipari tahe lo sahe ereti se isawe hetesiyerowa su, u tahe ano au ta'ane fara'uwerowa.” Serai menitani ape Jisas lo ipari tahe sahe ereti se isawe hetesiyeye. ");
INSERT INTO sny_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Witane a'i se fisa'i lo apuwe foro'oweye. Menitani ape apou toteye, “Fisa'i ano apuwe foro'owe tepa'asiye. Ane fara'u wisere a'i ne.” ");
INSERT INTO sny_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Aiwawe a'i witane a'i se Jisas apou eiye, “Kairefiyeyei ano tewi a'i tahe pa'are ano arunati.” Le me'iyeni ma'e atati siyeteye. Le apou ei toweriye, “Eiwerai ipari tahe ano sahe isawe hetesiyeye awere?” Lu 6:19 ");
INSERT INTO sny_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Lu disaipel lo apou eiye, “Meni Owane, ne lu taune tomu ne'ese siyesiya awere? Lowe ne ma'e tei ataheyesiya. Ne piyene apou ei toweriye awere? ‘Eiwerai ipari tahe ano sahe isawe hetesiyeye awere?’” ");
INSERT INTO sny_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Sosu Jisas atati siye etiye. Le menitani ape siyeye. ");
INSERT INTO sny_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ahowa, menitani ape atoweiye erasi irowe. Ereti lowe lo pere'eyeye. Le u tahe lo, wisere a'i irowe ape, so'oruweye tene! Le Jisas ma'e lowe uporo ape'i onuraiyewe, le ma'e apou eiye, “Ane lai apou toteye, ‘Ane ipari tahe no sahe isawe hetesiyerowa su, u tahe ano fara'u wisere a'i henerairowa.’” ");
INSERT INTO sny_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Sosu Jisas le ma'e itiya'u eiye. “Menitani, ne ane ne tote tawesiye su, tote tawesiyei no lai u tahe no ape au ta'ane fara'uwe wisereye tepa'asiye. Ne wesi no ma'e marepi fetane a'i se ire!” Mk 10:52; Lu 7:50; 17:19 ");
INSERT INTO sny_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jisas peri ape te'e tepa'asiye su, lu tamo Jairus ma'e henerai. Lowe apou eiye, “Eime taune no temeniyeye po'uteye. Ne Meni Owane Jisas owe ape heneta.” ");
INSERT INTO sny_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ahowa, Jisas peri lowe lo wanuwe su, le ta'uweyei wesi meni owane ma'e apou eiye, “Ne atoweiye sawa! Ne ane ne tote tawesire!” ");
INSERT INTO sny_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Sosu le lu taune werese werese ma'e apou au amouweye, “Fene ane owe ape umasita. Ane lu feni ano Pita, Jems, Jems lo pa'ise Jon, lowe hesi heta a'i lai ane meni Jairus mase aiwawe a'i iyei.” ");
INSERT INTO sny_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Le Jairus lo wesi ma'e henerai su, le no'u erasi wanuwe. Lowe luwei erasi a'i wanuteye. ");
INSERT INTO sny_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Le lu disaipel lo mase wesi papu wiyewe, lowe ma'e apou eiye, “Fene piyene lusiya awere? Fene no'u erasi piyene irosiya awere? Eime taune ape temeniye ta'ame. Le nihe howeisiya.” ");
INSERT INTO sny_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Lu taune werese wesi papu ta'uweteye ape, le ma'e niyeyei irowe. Serai le lowe werese nowe ma'e eimawesawi. Sosu le eime taune lo aite mai, Pita, Jems, Jon, lowe tewi wesi papu eime taune ape howeiteye ape sahe wiye. ");
INSERT INTO sny_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Le ereti lo se eime taune ape sahe aniteriyewe, eime taune ape ma'e eiye, “Talita kum.” Peri ape lo sitewi apou te'eye, “Eime taune oso, Ane ne se eiwa. Ne sinere!” Lu 7:14 ");
INSERT INTO sny_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Witane a'i eime taune ape sineyewe, uweiteye. Eime taune lo iyu menei apou ereti feni hesi lowe hesi a'i ne (12). Lu taune werese eime taune ape uweiyei siyeye su, lowe hepene se su'ariye. ");
INSERT INTO sny_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Sosu Jisas lowe werese ma'e peri kairefi se apou eiye, “Fene werese lu taune werese ma'e eime taune ape uweiyei lo peri ne owe ape te'e fiyarire!” Sosu le eime taune ape lo aite mai ma'e eiye, “Fenesi eime taune fenesi lo ape ayei ta au are!” ");
INSERT INTO sny_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Sosu a'i pe Jisas wesi ape arunatiyewe, le omo si tewi topo lo ma'e fi. Lu disaipel lo ape aiwawe a'i mo'o umasiye. ");
INSERT INTO sny_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Nowe amou (Sabat) ta henerai su, Jisas ta'uweyei wesi papu Owane Sitewi lo peri te'eyei ne wiye. Lu taune peri lo wanuwe su, lowe hepene se su'ariye. Lowe te'e te'e tiyatiteye, “Eiwerai meni ape ma'e peri lo au te'e atuatuteye awere? Eiwerai marepi wisere a'i le ma'e auwe awere? Le wiyawi erasi pefine a'i ta'aneteye ape, eiwerai le ma'e marepi wisere a'i auwe awere? Jo 7:15 ");
INSERT INTO sny_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Meni ape le wesi ta'ane siye meni. Menitani, Maria, meni ape auteiye. Nomo pa'ise werese lo so'oruwe tepa'asiye. Pafe Jems, Henei Josep, Waro Judas, Ere Saimon. Nomo lowe werese so'oruwesiya tene! Einei werese lo omo nomo lo saro irosiya.” ");
INSERT INTO sny_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Sosu Jisas lowe ma'e itiya'u eiye, “Owane Sitewi lo peri au te'e siye meni ta Owane Sitewi lo peri au te'e fiyariyei su, lu taune omo tere'e tere'e sahe le ma'e au te'e wisereyerowa. Ahowa, le Owane Sitewi lo peri omo si tewi sahe au te'eyei su, lu taune werese le me'iyeni ma'e arunatirowa. Lu tewi lo aiwawe a'i le ne me'iyeni ma'e atati arunatirowa.” Jo 4:44 ");
INSERT INTO sny_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Jisas Owane Sitewi lo peri omo si tewi lo sahe au te'eteye su, lu taune werese le ne me'iyeni ma'e atati arunati. Serai le wiyawi erasi pefine a'i ta'anerowata. Lu taune tewi oso a'i, u tahe iroteye ape, le ereti lo se lowe hire ma'e fuwewe, au ta'ane fara'uweye. ");
INSERT INTO sny_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Lu taune werese Jisas ne tote tawesi se ta'ame. Serai le lowe ne marepi erasi a'i tote ewiteye. Sosu a'i pe Jisas omo sitewi lo arunatiyewe, le omo tere'e tere'e ma'e Owane Sitewi lo peri au te'e fiyari. ");
INSERT INTO sny_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Sosu Jisas lu disaipel lo le ma'e ei aniye. “Ane fene hesi a'i hesi a'i lu taune ma'e Owane Sitewi lo peri au te'e fiyariyei ne eimawesawire. Ane fene ma'e kairefi erasi a'i ano aurowa. Meni ta sepei luwaru a'i iroteyei ape, fene kairefi ano se sepei ape au ta'ane sasarisawire. ");
INSERT INTO sny_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Fene iyei su, fene etiri tomu ne'ese owe ape aitire. Ahowa, fene ayei tamo mase owe ape aitire. Niye fene lo werese, ma'aru werese owe ape aitire. Fene me epi ta'i ta'i a'i fara'u anitetire. ");
INSERT INTO sny_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Lowe tahe ta'i a'i fara'u ani asitire. Fene ipari tahe hesi se owe ape ani asire.” ");
INSERT INTO sny_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Sosu le lowe ma'e eiye, “Fene wesi ta wiyei su, fene wesi ta'i a'i ape sahe irore. Fene wesi tere'e tere'e owe ape ire. ");
INSERT INTO sny_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Fene omo ta Owane Sitewi lo peri au te'e fiyariyei ne iyei su, lu taune ape mo peri fene lo wanu ta'ame, fene omo ape arunatire. Omo nowe ma'e iyei su, fene awei peperi lowe tahe sahe iroteyei ape ani ato periperenatiyei su, lu taune werese etiri ape siye so'oruwerowa. Owane Sitewi lai lowe ma'e ai marepi erasi a'i totesiya.” Lu 10:4-11; Ap 13:51 ");
INSERT INTO sny_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Jisas lowe ma'e te'e tepa'asiye su, lowe hesi a'i hesi a'i fi. Lowe lu taune werese ma'e apou au te'e fiyariteye, “Fene awei lo yo seni luwaru a'i arunatire. Sosu Owane Sitewi lo marepi ne tote tawesi umasire!” ");
INSERT INTO sny_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Lowe lu taune tamo sepei luwaru a'i iroteye ape, lowe sepei werese ape mo au ta'ane sasarisawiteye. Lowe lu taune u tahe se iroteye ape, lowe u tahe lowe lo au ta'ane fara'uweye. Lu taune enite se lowe me mapu lo fito wapo se enite sahe ani teroso arowewe, enite werese au ta'ane niyemaiyeye. Je 5:14 ");
INSERT INTO sny_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Nowe me'iye ta se Herot wiyawi erasi pefine a'i, Jisas ta'aneteye ape, wanuwe su, le lu tewi owane tamo lo ma'e ei toweriye, “Meni ape, lu taune u tahe se au ta'ane fara'uweteye ape, eiwerai awere?” Lu owane tamo le ma'e itiya'u eiye, “Meni ape Jon sa'i au hu siye meni. Ne meni ape lo mato aine tou aniye. Sosu Owane Sitewi lai meni ape si ta'ane norohuwe sineye. Serai le lai wiyawi erasi pefine a'i ape mo au ta'aneteye.” Mt 16:14; Mk 8:28; Lu 3:19-20 ");
INSERT INTO sny_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Lu tere'e tamo Meni ape ne te'eye, “Meni ape Elaija.” Lu tere'e apou te'eye, “Meni ape Owane Sitewi lo peri au te'e siye meni. Le Owane Sitewi lo peri au te'e siye lu, tu naifa iroteye ape, wou a'i ne.” ");
INSERT INTO sny_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ahowa, Herot Jisas lo wiyawi erasi pefine a'i ne ta'aneye wanuwe su, le apou toteye, “Wiyeme a'i meni ape Jon sa'i au hu siye meni tene! Ane lai Jon lo mato aine tou tera'eye tene. Sosu Owane Sitewi lai le au ta'ane norohuwe si sineye.” Sosu Herot marepi erasi a'i atoweiyenamiteye. ");
INSERT INTO sny_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Serai Jon lai Herot ma'e apou eiye su, “Ne pa'ise Filip lo naituwei au luwaruweye.” Herot ai atu siye lu tamo Jon ma'e eimawesawiyewe, ereti lo wafei kairefi a'i se ti tawesiye. Sosu lowe Jon kalabus wesi pani ma'e hene arunari. ");
INSERT INTO sny_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Sosu a'i pe Jon sa'i au hu siye meni awei lo meni owane Herot ma'e apou eiye, “Ne pa'ise Filip lo tani naituwe su, ne yo seni luwaru a'i irowe. Ne pa'ise lo naituwe ape au luwaruweye. Ne aiwawe a'i Owane Sitewi lo yo seni ape wanu arisiye.” Wkp 18:16 ");
INSERT INTO sny_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Serai menitani ape, Filip lo tani iyape Herodias, Jon ne ai marepi erasi a'i totenamiteye. Le Jon aine tera'eyei ne toteye. Ahowa, menitani ape Jon aine tera'erowata. ");
INSERT INTO sny_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herot Jon lo yo seni aseyaro a'i siyeye. Le Jon, Owane Sitewi lo yo seni wara'i a'i umasinamiteye ape, siye so'oruweyei ne toteteye. Serai le Jon kalabus sahe owe ape au luwaruwe irore. Nowe mi mi tomu ne'ese Herot Jon kalabus sahe peri lo wanuwei ne itori. Herot Jon lo peri wanuwe su, marepi lo orese erasi a'i toteteye. Ahowa, le peri lo ne marepi wisere a'i wanuteye. ");
INSERT INTO sny_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Nowe me'iye ta se Herot ene a hereiyei erasi ta, nowe ape mai le auteiye ape, au hereiye. Le awei lu owane werese, ai atu siye lu owane tamo, sosu Galili lu owane tamo le lowe werese wesi lo sahe ei ta'uwe aniye. ");
INSERT INTO sny_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Sosu menitani Herodias lo eime taune lowe ma'e yakowei wisere a'i iroteye. Eime taune ape yakowei wisereye iroteye su, Herot lu owane werese aiwawe a'i marepi wisere a'i toteteye. Yakowei ape tepa'asiye su, Herot eime taune ape ei aniye, apou eiye, “Ane yakowei no siyeye su, marepi ano wisereyeteye. Serai ane ne se eiye, ‘Ne etiri ta ane ma'e ei toweriyei su, ane lai ne ma'e aurowa.’” ");
INSERT INTO sny_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Sosu le menitani ape ma'e peri kairefi a'i se tame eiye, “Wanure! Ane ne se tame eiye, Ne ane ma'e etiri ta ei toweriyei su, ane lai wiyeme a'i ne ma'e aurowa. Marepi no apou a'i totereme su, ‘Ane awei pani ponei tewi a'i no aniyei.’ Wiyeme a'i ane lai awei pani ponei tewi a'i ano ne ma'e aurowa.” ");
INSERT INTO sny_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Sosu eime taune ape ene a hereiyei arunatiyewe, mai lo ma'e ei toweriyei ne fi. Le mai lo ma'e apou ei toweriye, “Ane piye aniyei ne ei toweriyei awere?” Sosu Herodias itiya'u apou eiye, “Ne Herot ma'e Jon lo mato aine touwei ne ei toweriyei.” ");
INSERT INTO sny_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Sosu menitani ape owane Herot ma'e witane a'i se si fiyewe, le ma'e ei toweriye, “Jon sa'i au husiye meni, kalabus irosiya ape, pereye a'i ane meni ape lo mato aine tou anirowawe, wahu sahe fuwei ne aitaire.” ");
INSERT INTO sny_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Herot eime taune lo peri wanuwe su, le marepi orese erasi a'i toteye. Ahowa, le eime taune ape ma'e peri te'e naneiyei, lu owane lo nihe se, au te'eye su, le apou toteye, “Ane peri ano fu umasirowa.” ");
INSERT INTO sny_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Serai Herot meni ta kalabus ma'e eimawesawi. Le meni ape eiye, “Ne Jon lo mato aine toure.” Sosu meni ape kalabus ma'e fiyewe, Jon lo mato aine tou po'uteye. Le Jon lo mato wahu papu fuwe. ");
INSERT INTO sny_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Sosu Jon lo mato wahu papu fuwe su, le eime taune ape ma'e aiti. Sosu eime taune ape wahu ape, Jon lo mato papu iroteye ape mai ma'e auwe. Herodias apou eiye, “Wisere a'i tene! Ane pereye etiri eite siye so'oruwesiya. Jon sa'i au hu siye meni temeniyeye.” ");
INSERT INTO sny_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Sosu Jon lo lu feni peri ape wanuwe su, lowe kalabus ma'e fiyewe, Jon lo tahe pa'are aniyewe, fisiye yo ma'e towasinari. ");
INSERT INTO sny_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Sosu a'i pe Jisas lo lu disaipel si tame fai. Lowe Jisas ma'e ta'uwerai su, wiyawi ape mo ne lowe ta'aneye ape, lowe peri Jisas ma'e au te'eye. Lu 10:17 ");
INSERT INTO sny_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Lu taune tomu ne'ese Jisas ma'e ta'uwerai. Jisas lowe ma'e wiyawi erasi pefine a'i au ta'aneteye. Lowe ene ayei nowe se ta'ama. Serai Jisas lu disaipel lo ei aniyewe lowe ma'e eiye, “Nomo pani lu taune ariyeye ape ma'e irowawe, nomo saro ahe onu fetaneyeteyei” ");
INSERT INTO sny_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Sosu lowe lu taune werese arunatiyewe, hare ite ma'e itori. Lowe wai papu arowatowe su, sa'i feni ma'e iyatu toneri. Lowe a'i lai onu fetaneyeteye. ");
INSERT INTO sny_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Lu taune tomu ne'ese lowe, siyesawi su, lowe apou toteye, “Lowe sa'i feni eire ma'e iyatutisiya.” Serai lowe omo towafi lowe lo arunatiyewe, Jisas mo'o hare ite tewiye ma'e iteroti. Lowe sa'i feni eire ma'e tu heneri. ");
INSERT INTO sny_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jisas lu disaipel lo mase wai yo seni tewi furi su, lowe lu taune tomu ne'ese siyeye. Le lowe siyeye su, le lowe ne marepi erasi a'i ewiteye. Lowe fe sipsip wou a'i ne. Lowe meni owane ta lowe au noweinoweiyei se ta'ama. Serai le lowe werese ma'e Owane Sitewi lo peri au te'e areiyeteye. Nam 27:17; Mt 9:36 ");
INSERT INTO sny_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Nowe neriwei su Jisas lowe ma'e au te'e fiyariteye su, Jisas lo lu disaipel le ma'e peri ta te'eyei ne fai, “Meni Owane, pani eite ariye a'i ne. Poweiye itori tepa'asiye. Mk 8:1-9 ");
INSERT INTO sny_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ne lu taune werese omo towafi lowe lo ma'e eimawesawire. Serai lowe ayei tamo fara'u etere.” ");
INSERT INTO sny_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ahowa, Jisas lowe ma'e itiya'u eiye, “Fene lowe werese ayei tamo au are.” Lu disaipel lo le ma'e itiya'u eiye, “Nomo omo ta irowawe, 200 Denarai se nau ta'ase eteyei awere? Sosu nomo lowe ma'e ene ayei au ayei awere?” ");
INSERT INTO sny_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Sosu Jisas lowe ma'e apou ei toweriye, “Fene nau ta'ase eiwerou a'i irosiya awere? Fene irowawe, nehi siyere.” Lowe siye tepa'asiye su, lowe Jisas ma'e si faiyewe, apou te'eye, “Nomo nau ta'ase ereti feni werese, sosu hare oso hesi a'i irosiya.” ");
INSERT INTO sny_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Sosu le lu taune werese ma'e apou eiye, “Fene werese senarepe saro onuti. Fene lu taune tewi a'i tewi a'i sato onura. Lu taune tewi a'i tewi a'i yaro ma'e onuri.” ");
INSERT INTO sny_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Lu taune weneri tewi tamo apou onuwe. Lu taune weneri tamo (100) ne. Lu taune weneri tamo (50) ne. ");
INSERT INTO sny_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Sosu Jisas nau ta'ase ereti feni aiwawe ape aniye. Hare oso hesi a'i ape aniye. Le Owane Sitewi lo omo ma'e aute siyeye, sosu nau ta'ase hare oso hesi ape Owane Sitewi ma'e au te'e wisereyeye. Mo'o su, le nau ta'ase tewi oso oso a'i ani topotowe. Sosu lu disaipel lo ma'e auwe. Lowe lu taune werese ma'e au none isafiyeteye. Sosu le hare oso hesi a'i ape ani topotowewe, sosu lu disaipel lo ma'e au none isafiyeteye. ");
INSERT INTO sny_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Lu taune werese ene a tepa'asiye su, lire lowe lo teme'eriyeye. Serai lowe marepi wisere a'i toteye. ");
INSERT INTO sny_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Lu taune werese ene a tepa'asiye su, lu disaipel lo nau ta'ase hare tewi a'i ipi sahe foruwe iroteye. Lowe ipi ereti feni hesi lowe hesi a'i (12 disaipel) nau ta'ase hare tewi a'i foruwe irowe ape, si ani asiteye. ");
INSERT INTO sny_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Lu (5,000) nawiteye ape, nau ta'ase hare tewi a'i ene aye. ");
INSERT INTO sny_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Pereye a'i se, Jisas lu feni ma'e apou eiye, “Fene wai papu arowatore. Fene omo Betsaida feni eire ma'e iyatu tonere. Ane lu taune werese omo towafi lowe lo ma'e eimawesawirowa. Sosu mo'o ane fene umasitairowa.” ");
INSERT INTO sny_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Sosu Jisas lu taune werese eimawesawi tepa'asiye su, le lu disaipel lo wai se iyatuti ape, siyesawi. Sosu Jisas omo hire ma'e yaneyewe, Owane Sitewi ma'e peri au te'eteye. Lu 5:16 ");
INSERT INTO sny_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Nowe pasiyeye su, wai ape hare ite ponei sahe iyatuteye. Jisas hare ite tewiye sahe iroteye. ");
INSERT INTO sny_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Fiyaru erasi a'i hare ite sahe henerai. Jisas sa'i ei wai pihatu ma'e apa'asiye siyeye. Sa'i ei ape lai lowe ani torutoro awetu awetowe. Lu werese wai papu iroteye ape, lowe wai ape iyatu tohoteye. Esi pasi su lowe wai se iyatuteye. Lowe yo senitewi ma'e iyatu furi ta'ame. Sosu Jisas hare ite hire awesetaiteye. Le wai ape awera'iyenatiyei ne toteye. ");
INSERT INTO sny_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ahowa, lu ape mo meni ape siyeye su, lowe atoweiye erasi iroteye. Lowe meni ape sepei siye toteye. Lu 24:37 ");
INSERT INTO sny_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Lu werese ape meni ape siyeyewe, marepi atoweiye erasi irowe. Ahowa, Jisas witane a'i lowe ma'e apou eiye, “Fene taweiru sawa! Ane lai ne. Marepi kairefiyere!” ");
INSERT INTO sny_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Sosu Jisas wai papu arowatowe su, fiyaru erasi a'i temeniye po'uteye. Serai lowe werese marepi erasi a'i hepene se su'ariye. Mk 4:39 ");
INSERT INTO sny_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Jisas nau ta'ase lu taune werese ma'e isafiye noneye su, lu disaipel lo Jisas lo kairefi tote i'aneye. Marepi lowe lo kairefiye luwaruweye. Serai lowe marepi erasi a'i hepene se su'ariye. ");
INSERT INTO sny_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Sosu a'i pe lowe wai iyatu toneriyewe, omo pani Genesaret lo yo senitewi ma'e furi. ");
INSERT INTO sny_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Jisas lu fene lo mase wai arunatiyewe, hare ite tewiye ma'e teiteye, lu taune werese lowe siye so'oruweye. ");
INSERT INTO sny_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Witane a'i lowe omo omo lu taune u tahe se ape mo me wari se Jisas ma'e sutaitetai. ");
INSERT INTO sny_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jisas omo omo werese ma'e fi su, lu tamo lai lu taune, u tahe se ape, lowe ta'uweyei ponei tewi amerame a'i ta sahe sutaite fuwe. Lowe Jisas ma'e te'e toweriye, “Fara'u lu taune werese u tahe se ape, ipari tahe tewi a'i no ereti lowe lo se isawe hetesiyeyei awere?” Serai lowe ipari tahe tewi no ma'e isawe hetesiyeye su, u tahe lowe lo au ta'ane fara'uweye. ");
INSERT INTO sny_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Sosu a'i pe lu Farisi tamo, sosu lu owane, Owane Sitewi lo yo peri siye te'e etiteye ape, lowe omo Jerusalem arunatiyewe, Jisas ma'e ta'uwerai. ");
INSERT INTO sny_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Lowe Jisas lo lu disaipel ereti unou a'i se ene ayei siyeye. Lowe ereti lowe lo sa'i au hu ta'ame. Lu 11:38 ");
INSERT INTO sny_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Lu Farisi werese, sosu Juda lo lu taune werese ene ayei su, lowe ya'ariyei lo peri umasiteye. Lowe ereti lowe lo sa'i sahe au ani taine huwe. ");
INSERT INTO sny_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Sosu aiwawe a'i lowe ayei lo maket pani amerame a'i ma'e fai su, lowe tepi tahe werese lowe lo sa'i sahe au huwe sasariye. Sosu mo'o lowe fara'u ene ayei. Lowe ya'ariyei lo peri werese umasiteye. Lowe sa'i pa'are oso tapiye pa'are erasi, etiri tere'e tere'e sa'i au huteye. Mt 23:25 ");
INSERT INTO sny_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Sosu lu Farisi ape, Owane Sitewi lo peri siye te'e eti siye lu ape mo, lowe Jisas ma'e peri ta apou te'e toweriye, “Lu disaipel no piyene lowe nomo lo ya'ariyei lo yo peri ape umasi ta'ame awere? Lowe ereti unou a'i se ene aye.” ");
INSERT INTO sny_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Sosu Jisas lowe ma'e itiya'u eiye, “Fene marepi hesi a'i tote siye lu ne. Tu naifa weriyei meni ta, iyape Aisaia peri wiyeme a'i fene ne one towe ta au leseye. Le peri pefine a'i apou leseye. ‘Lu taune tewi ape mo ane ma'e ahi a'i se au te'e wisereyesiya. Ahowa, marepi hepene lowe lo ane ne eyeri ma'e irosiya. ");
INSERT INTO sny_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Lowe ane ma'e au te'e wisereyesiya su, lowe marepi yahowa'i se au te'e wisereyesiya. Lowe lu taune werese ma'e awei lo marepi au te'e atuatu areiyeteye.’ ");
INSERT INTO sny_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Fene Owane Sitewi lo peri wiyeme a'i arisiye. Sosu fene ya'ariyei lo peri umasinamiteye.” ");
INSERT INTO sny_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Sosu le lowe ma'e peri tere'e ta apou eiye, “Fene Owane Sitewi lo yo peri wiyeme a'i werese aru fareyareteye. Serai fene ya'ariyei lo yo peri umasinamiteye. ");
INSERT INTO sny_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Meni tere'e ta, iyape Moses, one towe sahe apou leseye, ‘Fene aite, mai fene lo iyape lowesi lo ei ani arowere. Sosu peri lowesi lo wanu umasire. Meni ta aite mai lo ma'e au luwaruweyei su, lowe lai meni ape pei aine tera'e temeniyerowa.’ ");
INSERT INTO sny_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Fene apou au te'eye, ‘Meni ta aite mai ma'e apou au te'eyei, ane ma'aru tamo eite Owane Sitewi ma'e auwei ne totesiya. Serai ane fenesi ma'e au pati anirowata.’ Fene lai yo seni ape wisere a'i totesiya. ");
INSERT INTO sny_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Fene meni ape aite mai lo ma'e etiri ta au pati ta'aneyei ne einamisiya. ");
INSERT INTO sny_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Fene ya'ariyei lo peri umasiye su, fene Owane Sitewi lo peri wiyeme a'i au yahowa'i iro tepa'asiye. Fene ya'ariyei lo peri lu eimane yo'orei ma'e au te'e atuatu areiyeteye. Sosu fene ya'ariyei lo yo seni tomu ne'ese au te'e areiyeye ape, fene yo seni werese ape umasi tepa'asiye.” ");
INSERT INTO sny_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Sosu a'i pe Jisas lu taune werese le ma'e ei ta'uwerai. Sosu le lowe ma'e apou eiye, “Fene werese peri ano wanure! Sosu peri lo sitewi wanu so'oruwere. ");
INSERT INTO sny_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Etiri werese lu taune tamo ene ayei su, ayei ape lire papu wirowa. Ayei werese ape lire ma'e unou a'i au irorowata. Ahowa, etiri werese, marepi papu irosiya ape, ahi nowe ma'e heneraiyei su, etiri ape mo lai meni ape au luwaru unouwerowa.” Ap 10:14-15 ");
INSERT INTO sny_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Sosu Jisas peri ape te'e tepa'asiye su, le lu disaipel lo mase lu taune werese arunatiyewe, wesi ta papu wiye. Wesi ta papu wiye su, lowe le ma'e peri anowe lo ape ne te'e toweriye. ");
INSERT INTO sny_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Sosu Jisas lowe ma'e apou itiya'u eiye, “Fene peri anowe lo sitewi so'oru ta'ama awere? Ayei werese ape lo meni ta papu wiyei su, ayei ape lire ma'e unouwerowata. Fene peri ape so'oru ta'ama awere? ");
INSERT INTO sny_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ayei werese fene ene ayei ape, lire fene lo papu wiyei. Ayei werese apou ape mo marepi papu wirowata. Ahowa, ayei werese lire papu wiyei su, sosu nowe ma'e li se tu funarirowa.” Serai Jisas apou au te'e areiyeye, ayei werese wisere a'i ene arowa. ");
INSERT INTO sny_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jisas lowe ma'e apou te'eye, “Etiri werese ape mo marepi nowe ma'e henerowa. Etiri werese ape mo lai meni ape au luwaru unouwerowa. ");
INSERT INTO sny_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Etiri tomu ne'ese, marepi sahe irosiya ape, sosu ahi nowe ma'e henerowa su, etiri ape mo lai lu taune werese au luwaru unouwerowa. Marepi luwaru a'i toteyei, tafa'e yo seni luwaru a'i toteyei, etiri ta'arei aniyei ne toteyei, meni ta aine tera'eyei marepi toteyei. Naituwei au luwaruweyei. ");
INSERT INTO sny_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Etiri tamo nihe siye wisereyeyei, yo seni luwaruweyei, peri wawero a'i te'eyei, lu tamo taune siye wisereyeyei, meni iyape se lo yaru aniyei ne toteyei, te'e naru tiyatiyei, ane a'i tote wisereyesiya, marepi luwaru tote meremereyeyei. ");
INSERT INTO sny_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Etiri luwaru werese a'i ape, marepi papu irosiya ape lai, ahi nowe ma'e heneraisiya. Etiri werese ape mo lai lu taune werese au luwaruwe unouwesiya.” ");
INSERT INTO sny_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Sosu a'i pe Jisas lu disaipel lo mase wesi ape arunatiyewe, omo pani Taia ma'e fi. Omo Tair ma'e henerai su, lowe wesi ta eresene fareyareyei a'i wiyei ne toteye. Ahowa, lu taune tomu ne'ese lowe wesi ape wiyei siyeye. ");
INSERT INTO sny_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Sosu menitani ta Jisas wesi tere'e ape wiyei wanuwe su, le wesi ape papu wiye. Witane a'i Jisas ma'e lowe uporo ape'i onuri. Menitani ape lo eime taune oso ape sepei luwaru a'i lire papu iroteye. ");
INSERT INTO sny_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Menitani ape lu tewi tere'e ma'e fai. Nihari lo tere'e iyape Saria Fonisia. Menitani ape Juda lo yo peri umasi ta'ame. Sosu menitani ape Jisas ma'e apou ei toweriye, “Ne sepei luwaru a'i ape eime taune ano, marepi hepene papu irosiya ape, au ta'ane sasarisawire!” ");
INSERT INTO sny_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jisas le ma'e itiya'u eiye, “Ane tu wiyawi ano eimane werese ma'e Juda lo yo peri wanu umasisiya ape, au ta'aneyei. Meni ta eimane lo nau ta'ase anirowawe, sosu you ape ma'e fu arosawirowa. Yo seni ape luwaru a'i ne.” ");
INSERT INTO sny_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ahowa, menitani ape le ma'e itiya'u eiye, “Wiyeme a'i! Meni Owane, eimane tamo nau ta'ase ene ayei su, you werese, metei unahi iroteye ape, nau ta'ase tewi oso a'i ape, fiyafe sahe winetaiye ape, fara'u arowa.” ");
INSERT INTO sny_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Sosu Jisas le ma'e itiya'u eiye, “Ne peri ape wiyeme a'i te'eye. Ne wesi no ma'e ire! Ane sepei luwaru a'i eime taune no lo marepi hepene, papu iroteye ape, au ta'ane sasari tepa'asiye.” ");
INSERT INTO sny_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Menitani Jisas arunatiyewe wesi topo lo ma'e fi. Wesi lo ape wiye su, le eime taune lo wari sahe howeiteyei siyeye. Sepei luwaru a'i lai eime taune lo marepi hepene arunatiyewe, fi. ");
INSERT INTO sny_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Sosu a'i pe Jisas omo Tair arunatiyewe, omo Saidon ma'e yaneri. Sosu le omo Saidon arunatiyewe, Hare ite Galili ma'e heneri. Le Hare Ite Galili arunatiyewe, omo pani Dekapolis heneri. ");
INSERT INTO sny_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Lu tamo meni apaniye, wiyapu irowe ape Jisas ma'e henetai. Meni ape lo sorowe peri luwaru a'i te'eteye. Lowe Jisas ma'e apou te'e toweriye, “Ne ereti no se meni ape hire ma'e isawe hetesiyere.” ");
INSERT INTO sny_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Sosu Jisas meni ape pani ariye a'i heneti. Le ereti sa'onare hesi lo se meni ape lo apaniye hesi papu tewi te'eniye. Sosu Jisas pisa'i ereti sa'onare sahe tepehowewe, meni ape lo sorowe ma'e isawe fuwe. ");
INSERT INTO sny_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Sosu Jisas Owane Sitewi lo omo hire ma'e siye auweye. Le marepi orese teriteye, heyaneteyei erasi a'i irowewe, meni ape ma'e eiye, “Efata.” Peri si tewi eti lo apou a'i ne, “Apaniye tosore!” ");
INSERT INTO sny_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Pereye a'i meni ape lo apaniye toso tepa'asiye. Etiri sorowe sahe iroteye ape, tepa'asiye. Serai le peri a'i te'e areiyeteye. ");
INSERT INTO sny_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jisas meni ape au ta'ane fara'uwe tepa'asiye su, le lowe ma'e apou eiye, “Fene lu taune werese ma'e owe ape au te'e areiyere.” Ahowa, lowe lai peri erasi a'i lu taune werese ma'e au te'e areiye fiyariteye. Mk 1:43-45 ");
INSERT INTO sny_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Lu taune Jisas lo wiyawi erasi pefine a'i ape siyeye su, lowe hepene se su'ariye. Lowe apou au te'eye. “Etiri werese lo le ta'ane ape, wisere a'i ta'aneye. Lu tamo apaniye wiyapuweye ape, au ta'ane tosowe. Lu tamo ahi sorowe luwaru a'i ape, au ta'ane wisereyeye. Serai lowe peri au te'e areiyeteye.” Ais 35:5 ");
INSERT INTO sny_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Nowe me'iye ta se lu taune tomu ne'ese a'i (4,000) Jisas ma'e Owane Sitewi lo peri wanuwei ne ta'uwerai. Lowe peri lo wanuwe su, lowe ene ayei werese po'uteye. Serai lowe werese lau a'i iroteye. Jisas lai lu disaipel lo ma'e ei aniyewe, lowe ma'e eiye, ");
INSERT INTO sny_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ane lu taune werese marepi erasi a'i ewite totesiya. Ayei werese lowe lo ariye pefine a'i ne. Lowe poweiye hesi heta ane mase iroteye. Serai lowe lau erasi irosiya. Mk 6:34-44 ");
INSERT INTO sny_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Lowe werese lau erasi se, ane lowe omo towafi lowe lo eimawesawirowa su, lowe lai lau yo mai sahe erasi teriterowa. Serai lowe awei ma'e ninapune winetairowa. Lu taune tamo omo tere'e eyeri ma'e fai.” ");
INSERT INTO sny_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Sosu Jisas lo lu disaipel le ma'e te'e toweriye, “Lu taune tomu ne'ese a'i sato irosiya. Nomo eiwerou nau ta'ase lowe ma'e au ayei nehirowa awere? Pani eite ariye a'i tene. ");
INSERT INTO sny_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Sosu Jisas lowe ma'e ei toweriye, “Nau ta'ase, eiwerou a'i irosiya awere?” Lowe le ma'e itiya'u eiye, “Nomo ereti feni werese feni hesi a'i irosiya.” ");
INSERT INTO sny_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Sosu Jisas lu taune werese ma'e eiye, “Fene werese awei saro onure!” Sosu le nau ta'ase ereti feni werese feni hesi a'i ereti lo se aniteyewe, le Owane Sitewi ma'e au te'e wisereyeye. Sosu le nau ta'ase tewi pa tewi a'i ani topotowe. Sosu le lu disaipel lo ma'e auwe. Lu disaipel lo ape lai lu taune werese ma'e au none isafiyeteye. ");
INSERT INTO sny_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Lowe hare oso a'i tamo le ma'e aitai. Jisas hare ape ereti lo se aniteyewe, Owane Sitewi ma'e au te'e wisereyeye. Le lu disaipel lo ma'e tewi a'i auwe. Lu disaipel lo lai lu taune werese ma'e aiwawe a'i au none isafiyeteye. ");
INSERT INTO sny_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Lu taune werese nau ta'ase hare tewi pa tewi a'i ape ene a tepa'asiye su, lire lowe lo teme'eriyeye. Serai lowe otuwei a'i iroteye. Sosu nau hare foruwe iroteye ape, serai lu fene lo lai si ipi ma'e so asiye. ");
INSERT INTO sny_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Lu tomu ne'ese a'i (4,000), nau ta'ase hare tewi pa tewi a'i ene ateye. Lowe ene a tepa'asiye su, Jisas lowe omo towafi lowe lo ma'e eimawesawi. ");
INSERT INTO sny_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Pereye witane a'i Jisas lu disaipel lo mase hare ite ma'e itori. Lowe wai papu arowatowe. Lowe sa'i feni eire ma'e iyatu toneri. Omo pani Dalmanuta ma'e heneri. ");
INSERT INTO sny_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Sosu a'i pe lu Farisi tamo Jisas ma'e ai marepi te'eye. Lowe le ma'e apou te'eye, “Ne Owane Sitewi lo omo ma'e itorai su, ne nomo ma'e wiyawi erasi pefine a'i au atuatu areiyere. Serai nomo lai, ne, Owane Sitewi ma'e itorai ape, siye so'oruwerowa.” ");
INSERT INTO sny_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Sosu Jisas peri lowe lo wanuwe su, marepi lo orese erasi iroteye. Le heyaneteyewe, lowe ma'e eiye, “Piyene lu taune werese nowe pereye irosiya ape, Owane Sitewi lo yaru siyereme awere? Ane peri wiyeme a'i ta fene ma'e te'esiya, Owane Sitewi lai fene ma'e wiyawi erasi pefine a'i au atuatu areiyerowata.” Mt 12:39; Lu 11:29 ");
INSERT INTO sny_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Sosu Jisas lowe arunatiyewe, wai ape si tame arowatowe. Lowe sa'i feni eire ma'e iyatu toneri. ");
INSERT INTO sny_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Sosu a'i pe lu disaipel lo nau ta'ase aitaiyei tote i'aneye. Lowe nau ta'ase ta'i a'i wai papu aitai. ");
INSERT INTO sny_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jisas lowe ma'e peri kairefi a'i au eiye, “Weiyai! Fene Farisi lo wawe sa'i owe ape totere. Sosu Herot lo wawe sa'i owe ape totere.” Lu 12:1 ");
INSERT INTO sny_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Lu disaipel lo te'e tiyatiteye, “Nomo nau ta'ase i'aneye. Serai nomo lau erasi a'i irorowa.” ");
INSERT INTO sny_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jisas peri lowe lo te'eteye ape wanu so'oruwe a'i ne. Sosu lowe ma'e te'e toweriye, “Fene piye peri te'e tiyatisiya awere? Fene peri ano siye so'oru ta'ama awere? Marepi fene lo kairefi a'i awere? Mk 6:52 ");
INSERT INTO sny_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Fene nihe se, fene wiyawi ane ta'aneye ape, siye ta'ame awere? Fene apaniye se fene peri ano ane te'eteye ape, wanu ta'ame awere? Sosu fene etiri werese ane ta'aneteye ape, tote i'aneye awere? ");
INSERT INTO sny_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ane nau ta'ase tewi pa tewi a'i, ani topotowewe, sosu lu (5,000), none isafiyeye su, ipi eiwerou a'i foruwe iroteye awere?” Lowe le ma'e itiya'u eiye, “Nomo ereti feni hesi werese lowe hesi a'i (12) ipi sahe so asiteye.” Mk 6:41-44 ");
INSERT INTO sny_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Sosu ane nau ta'ase tewi pa tewi a'i lu (4,000) aiwawe a'i, none isafiyeye su, eiwerou a'i foruwe ipi sahe so asiteye awere? Sosu lowe le ma'e itiya'u eiye, “Nomo ipi ereti feni werese feni hesi a'i foruwe so asiteye.” ");
INSERT INTO sny_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Sosu le lowe ma'e apou eiye, “Fene wiyawi ape, ane ta'aneye ape, siye so'oru ta'ama awere?” ");
INSERT INTO sny_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Sosu lowe omo Betsaida lo yo senitewi ma'e furi. Lu tamo meni ta, nihe pokowe tawesiye ape, le ma'e henetai. Lowe le ma'e apou eiye, “Ne meni ape lo nihe ma'e isawe hetesiyere. Serai le nihe petenerowa.” ");
INSERT INTO sny_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Sosu Jisas meni ape ereti se aniteyewe, omo nowe ma'e heneti. Sosu le pisa'i nihe lo ma'e topohowe. Sosu le ereti lo se meni ape hire ma'e isawi hetesiyeye. Jisas lai le se peri ta ei toweriye, “Ne etiri ta siyesiya awere? Piyete awere?” ");
INSERT INTO sny_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Sosu meni ape nihe hire ma'e siye aroweye. Sosu le apou eiye, “Ane lu tamo siyesiya. Lowe me wou a'i uweisiya.” ");
INSERT INTO sny_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jisas meni ape lo nihe sahe ereti tame isawe hetesiyeye. Sosu meni ape nihe petaneye su, le siye etiyewe, etiri werese mi amerame a'i siyeye. Nihe lo wisere a'i ne. ");
INSERT INTO sny_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Sosu Jisas meni ape wesi topo lo ma'e eimawesawi su, le ma'e eiye, “Ne iyei su, ne omo nepawe ma'e owe ape wire.” ");
INSERT INTO sny_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Sosu a'i pe Jisas lu disaipel lo mase arunatiyewe, Sisaria Filipai lo omo ma'e yaneri. Lowe, yo sahe iteye ape, Jisas lowe ma'e ei toweriye, “Lu taune werese ane ne apou tote te'esiya awere? Ane eiwerai awere?” ");
INSERT INTO sny_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Sosu lowe Jisas ma'e itiya'u eiye, “Lu tewi tamo ne ne apou te'esiya, ‘Ne Jon sa'i au hu siye meni.’ Lu taune tere'e tamo ne ne apou te'esiya. ‘Ne meni Elaija.’ Lu taune tere'e tamo apou te'esiya. Ne Owane Sitewi lo peri au te'e siye meni.” Mk 6:15 ");
INSERT INTO sny_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Sosu Jisas lowe ma'e apou ei toweriye, “Wanure! Fene ane ne apou te'ere! Ane eiwerai awere?” Sosu Pita le ma'e itiya'u eiye, “Ne a'i lai Krais wiyeme a'i tene! Owane Sitewi Tai wiyeme a'i lai ne hi awei ma'e eimawe arosai.” Jo 6:68-69; Mk 9:9 ");
INSERT INTO sny_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Sosu Pita peri ape te'e tepa'asiye su, Jisas lowe ma'e eiye, “Fene werese lu taune ane ne owe ape te'e areiyete.” ");
INSERT INTO sny_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Sosu a'i pe Jisas lu disaipel lo ma'e peri tomu ne'ese au atuatu areiyeye. Le lowe ma'e apou eiye, “Ane, meni ape, Owane Sitewi hi awei ma'e eimawe arosai ape, fofowei erasi a'i teriterowa. Lu owane tomu ne'ese lai ane ne me'iyeni ma'e arunatirowa. Ya'ariyei lo lu owane tamo, au heseyei lu owane tamo, sosu Owane Sitewi lo peri siye te'e eti siye lu owane tamo, lowe lai Jisas ne me'iyeni ma'e atati arunatirowa. Lowe ane aine tera'eyei ne toteye. Lowe ane aine tera'eyei su, lowe ane fisiye yo ma'e furowa. Nowe hesi heta i tepa'asirowa su, Owane Sitewi lai ane si tame ta'ane norohuwe sinerowa.” ");
INSERT INTO sny_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jisas peri ape lowe ma'e au te'e areiyeteye. Sosu Pita Jisas feni ma'e heneti. Le Jisas ma'e ai marepi se apou eiye, “Ne peri ape, ne nomo ma'e au te'e areiyeye ape, owe ape te'ete!” ");
INSERT INTO sny_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ahowa, Jisas lu feni werese atati siyeyewe, le Pita ma'e ai marepi se peri lo ape au te'e fareraiyeye. Le Pita ma'e eiye, “Sepei Satan, ne me'iyeni ano ma'e teire! Ne Owane Sitewi lo marepi tote umasi ta'ame. Mi mi werese ne awei lo yo seni marepi a'i tote tawesi umasinamisiya.” ");
INSERT INTO sny_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Sosu Jisas lu taune werese, lu disaipel lo mase le ma'e ei aniye. Sosu le lowe ma'e apou te'eye, “Lu taune tamo ane umasiyei ne toteyei su, le marepi topo lo me'iyeni ma'e atati arunatite. Le me tape'i topo lo pei sutete. Sosu yo peri ano pei umasita. Mt 10:38-39; Lu 14:27 ");
INSERT INTO sny_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Lu taune tamo marepi hepene towafi lowe lo mi mi pasi pasi ironamiyei ne toteyei su, lu taune ape mo, mi mi pasi pasi temeniyerowa. Aiwawe a'i, lu taune tamo yo seni ano umasirowa, sosu au te'e areiyerowa su, sosu lu tamo lowe aine tera'erowa su, lowe marepi hepene he'i a'i mi mi pasi ironamitorowa. ");
INSERT INTO sny_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Wanure! Meni ta awei lo etiri werese aniyei su, sosu mo'o le mi mi pasi pasi yehe omo sahe ironamitorowa. Awei lo yo seni ape wisere a'i awere? Ahowa! Meni ape temeniyerowa su, etiri werese lo ape aiwawe a'i po'uterowa. ");
INSERT INTO sny_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Lu taune tamo marepi hepene he'i eteyei ne toteyei su, lowe piye etiri se au eterowa awere? Ahowa, lu taune werese marepi hepene he'i a'i eterowata. ");
INSERT INTO sny_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Pereye nowe eite se lu taune yo seni luwaru a'i umasinamisiya ape, ane meni ape, Owane Sitewi lai hi awei ma'e eimawe arosai ape, lowe ane ne neritaseyeyei irorowa. Aiwawe a'i lowe peri ano neritaseyeyei irorowa su, nowe ye'ewi se, ane Tai lo mitaiyeyei erasi mase, Owane Sitewi lo ipari wara'i a'i (Ensel) tomu ne'ese mase si awei ma'e tame itorairowa. Ane lai lowe ne neritaseyeyei irorowa.” Mt 10:33 ");
INSERT INTO sny_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Sosu a'i pe Jisas lu disaipel lo ma'e apou te'eteye. “Peri ano wiyeme a'i tene! Wanure! Ane fene ma'e eisiya. Owane Sitewi lo marepi werese kairefi lo mase itorairowa. Lu taune tamo ane mase irosiya ape, lowe Owane Sitewi lo marepi ape siyerowa. Lu taune tamo tere'e tu temeniyerowa. Serai lowe Owane Sitewi lo marepi siyerowata.” Mk 13:30 ");
INSERT INTO sny_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Nowe poweiye ereti feni werese feni ta'i a'i i tepa'asiye su, Jisas lu disaipel lo hesi heta, Pita, Jems, Jon, le lowe omo hire ma'e hene yaneye. Lu hesiyo hesiyo ape lowe a'i omo hire ma'e iroteye. Sosu lowe omo hire ma'e iroteye su, Owane Sitewi lai Jisas lo nihari mitaiyeyei erasi au iro tewi mitaiyeye. ");
INSERT INTO sny_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Jisas lo ipari tahe aiwawe a'i wapo mitaiyeyei erasi a'i irowe. Lu werese ipari tahe wapo a'i apou wou a'i sa'i au hurowata. ");
INSERT INTO sny_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Sosu lu hesi Owane Sitewi lo omo ma'e itoraiyewe, Jisas mase teiteye. Lu hesi lo iyape Elaija, sosu Moses. Lowesi Jisas mase te'e tiyateye. ");
INSERT INTO sny_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Sosu Pita Jisas ma'e apou eiye, “Atuatu siye meni owane, nomo lai ne mase irosiya. Eite wisere a'i ne. Nomo ipo wesi hesi heta ta'aneyei. Wesi no ta'i au ta'aneyei, Wesi ta'i Moses lo au ta'aneyei, sosu wesi ta'i Elaija lo au ta'aneyei.” ");
INSERT INTO sny_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pita peri ape te'eye su, le marepi topo lo ape so'oru ta'ama. Lowe werese atoweiye erasi iroteye. ");
INSERT INTO sny_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Pita peri lo ape te'e tepa'asiye su, ni'arawe erasi a'i itorai. Ni'arawe ape lowe werese napetuwe. Sosu peri no'u erasi a'i ni'arawe sahe apou te'eye, “Meni ape lai meni eime pefine a'i ano ne! Peri lo wanu tote tawesi umasire.” 2 Pi 1:17-18; Ap 3:22 ");
INSERT INTO sny_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Peri no'u te'e tepa'asiye su, ni'arawe ape hire ma'e perati fiyari po'uteye. Sosu Jisas lu disaipel lo hesi heta a'i (8) sato teiteye. Lu hesi ape Owane Sitewi lo omo hire ma'e si wiye. ");
INSERT INTO sny_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Sosu a'i pe Jisas lu disaipel lo ape omo hi ma'e itorai. Jisas lowe ma'e peri kairefi a'i se apou eiye, “Fene lu taune werese etiri ape, ne fene siyeye ape, owe ape au te'e fiyarite. Meni ape, Owane Sitewi lai hi awei ma'e eimawe arosai ape, ane temeniyerowa, sosu si tame ta'ane norohuwe sinerowa su, fene fara'u lu taune ma'e au te'e fiyaritowa.” ");
INSERT INTO sny_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Lu disaipel lo peri ape wanuwe su, lowe peri ape ne te'e tiyatiteye, “Peri ape lo sitewi eti si tame ta'ane norohuwe sinerowa. Piye peri lo sitewi te'esiya awere?” ");
INSERT INTO sny_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Sosu lowe le ma'e apou te'e toweriye. “Owane Sitewi lo peri te'e eti siye lu owane tamo, lowe apou te'eteye, ‘Meni Elaija tu henerairowa.’ Lowe piyene peri ape au te'eteye awere?” ");
INSERT INTO sny_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Sosu Jisas lowe ma'e itiya'u eiye, “Peri lowe lo wiyeme a'i ne. Meni Elaija tu henerairowa. Le henerairowa su, le etiri werese au fareraiyerowa. Sosu aiwawe a'i ane meni ape, Owane Sitewi lai hi awei ma'e eimawe arosai ape, ane fofowei tomu ne'ese teriterowa. Lu owane werese ane ne me'iyeni ma'e atati arunatirowa. Piyene lowe peri ape leseye awere? Mal 4:5; Sng 22:1-18; Ais 53:3 ");
INSERT INTO sny_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ahowa, ane fene ma'e eisiya, meni Elaija fai. Lu tewi ape le ma'e marepi lowe lo se au luwaruweye. Tu naifa weriyei meni ta Elaija ne apou ape leseye.” Mt 11:14 ");
INSERT INTO sny_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Sosu a'i pe lowe lu disaipel lo ma'e si tame itori. Lowe lu taune tomu ne'ese lu disaipel lo ma'e ta'uweraiyei siyeye. Owane Sitewi lo peri siye te'e eti siye lu tamo lowe Jisas lo lu disaipel ma'e ai peri erasi te'e tiyatiteye. ");
INSERT INTO sny_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Pereye a'i lu taune werese Jisas aiyeyei siyeye. Lowe hepene se su'ariye. Lowe le ma'e itape iterotiyewe, lowe le ma'e au te'e wisereyeye. ");
INSERT INTO sny_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Sosu Jisas lowe ma'e apou ei toweriye. “Fene ai peri ta lowe ma'e te'e tiyatisiya awere?” ");
INSERT INTO sny_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Sosu meni ta le ma'e itiya'u eiye, “Atuatu siye meni owane, ane meni eime ano lu disaipel no ma'e henetai. Meni eime ano sepei luwaru a'i lire papu irosiya. Sepei luwaru a'i ape lai meni eime ano lo ahi ani tomo'uteye. ");
INSERT INTO sny_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Sosu sepei ape meni eime wi ya'oreye su, sepei ape le hi awei ma'e fu arowe. Le ahi pisa'i wapo a'i heneraiteye. Meni eime pi ta'ani fekeke tawesiye. Tahe pa'are lo kairefi nono'oweye. Ane lu disaipel no ma'e apou ei toweriye, ‘Sepei luwaru a'i, meni eime ano papu irosiya ape, fene sepei luwaru a'i ape au ta'ane sasarire. Lowe au ta'ane sasarirowata.’” ");
INSERT INTO sny_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Sosu le lowe ma'e itiya'u eiye, “Fene, pereye irosiya ape, fene Owane Sitewi lo yo seni werese wanu tote tawesi ta'ame. Piye nowe ta se ane fene arunatiyei awere? Nowe tomu ne'ese ane marepi orese a'i fene lo teriteye. Piye nowe ta se fene kairefi a'i teiyei awere? Meni eime ape, sepei luwaru a'i papu irosiya ape, ane ma'e heneta.” ");
INSERT INTO sny_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Sosu lowe meni eime ape Jisas ma'e henetai. Sepei luwaru ape Jisas siyeye su, witane se a'i le meni eime ape hi awei sahe fu arowe. Sepei ape lai meni eime ape meremereyeyei au irowe. Le awei sahe howei nowerititeye. Sosu le pisa'i wapo a'i ahi yo ma'e topoho arosaiteye. ");
INSERT INTO sny_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Sosu Jisas meni eime ape lo aite ma'e apou ei toweriye, “Eiwerou su u tahe ape henerai awere?” Aite lo itiya'u eiye, “Meni eime oso a'i iroteye su, sepei luwaru a'i ape lai papu wiye. ");
INSERT INTO sny_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Nowe tomu ne'ese sepei luwaru a'i ape lai meni eime ano yehe, sa'i sahe fu arowe. Sepei luwaru a'i ape lai meni eime aine tera'eyei ne toteye. Ne nomo au tote ferafereiyei su, ne sepei luwaru a'i ape au ta'ane sasarisawire!” ");
INSERT INTO sny_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Sosu Jisas le ma'e itiya'u eiye, “Ne Owane Sitewi ne tote tawesiyei su, ne a'i lai sepei luwaru a'i ape au ta'ane sasarisawirowa. Lu taune werese Owane Sitewi ne tote tawesiyei su, lowe etiri werese werese au ta'anerowa.” Mt 21:21; Mk 11:23 ");
INSERT INTO sny_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Witane a'i meni eime lo aite Jisas ma'e peri erasi apou uteye, “Ane Owane Sitewi ne tote tawesiye. Tote tawesiyei ano oso a'i su, ne lai tote tawesiyei ano au kairefiyere.” ");
INSERT INTO sny_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Sosu Jisas lu taune tomu ne'ese witane a'i ta'uweraiyei siyeye su, le sepei luwaru a'i ape ma'e ai peri eiye, “Ne sepei luwaru a'i ahi tomo'ute tawesiye ape, apaniye te'ene tawesiye ape, ne meni eime ape arunatirowawe, nowe ma'e henera. Ne meni eime ape papu si tame owe ape wire.” ");
INSERT INTO sny_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Sepei luwaru a'i ape hareyei erasi uteye su, le meni eime hi awei sahe fu arowewe, nowe ma'e henerai. Meni eime ape hi awei sahe howeiteye, temeniyeyei wou a'i ne. Lu taune tamo apou te'eye, “Meni eime ape pefine temeniyeye.” Mk 1:26 ");
INSERT INTO sny_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ahowa, Jisas meni eime ereti se aniteyewe, si au ta'ane norohuwe sineye. Sosu meni eime sineteye. ");
INSERT INTO sny_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Sosu Jisas lu taune werese arunatiyewe, wesi ta papu wiye. Nowe me'iye su, Jisas lo lu disaipel le ma'e peri ta apou te'e toweriye, “Piyene nomo lai sepei luwaru ape au ta'ane sasarisawi ta'ame awere?” ");
INSERT INTO sny_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Sosu Jisas lowe ma'e itiya'u eiye, “Fene sepei luwaru a'i apou ape au ta'ane sasarisawiyei ne Owane Sitewi ma'e te'e towerite.” ");
INSERT INTO sny_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Sosu a'i pe Jisas lu disaipel lo aiwawe wesi ape arunatiyewe, lowe omo pani Galili ma'e fi. Lowe eresene fareyare a'i fi. Le lowe ma'e eiye, “Fene lu taune werese ma'e, ane eiwerou ma'e irosiya ape, peri owe ape te'e fiyarite.” Jo 7:1 ");
INSERT INTO sny_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Sosu Jisas lu disaipel lo ma'e apou au te'e atuatuteye, “Meni ape, Owane Sitewi lai hi awei ma'e eimawesai ape, meni ta lai ane awei lu owane ma'e etiyei ne henetirowa. Lowe ane aine tera'eyei ne toterowa. Lowe ane aine tera'erowawe, lowe ane fisiye yo papu furowa. Ane fisiye yo papu nowe hesi heta sato howei tepa'asirowa su, Owane Sitewi lai ane si ta'ane norohuwe sinerowa.” Mk 8:31; 10:32-34 ");
INSERT INTO sny_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ahowa, lu disaipel lo peri sitewi ape so'oru ta'ama. Lowe le ma'e te'e toweriyei ne atoweiyeye. Lu 9:45 ");
INSERT INTO sny_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Sosu a'i pe lowe omo Kaperneam ma'e henerai. Lowe wesi tere'e ta wiye su, Jisas lu disaipel lo ma'e apou ei toweriye, “Fene piye peri te'e tiyatiteye awere?” ");
INSERT INTO sny_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ahowa, lowe werese peri se ta'ama. Lowe peri ta apou te'e tiyatiteye, “Eiwerai meni tutawe heneraiyei awere?” ");
INSERT INTO sny_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Sosu Jisas me tuto'u sahe onuwewe, lu disaipel lo werese ma'e ei aniye. Le lowe ma'e eiye, “Meni ta tutawe heneraiyei ne toteyei su, le yaru ye'ewi ma'e henerairowa. Le lu taune werese ma'e wiyawi yahowa'i a'i henerairowa.” Lu 22:24; Mt 20:25-27; Mk 10:43-44 ");
INSERT INTO sny_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Sosu le meni eime oso ta ereti se aniteyewe, lowe ponei sahe au teiye. Le meni eime oso ereti se ya'oreteye su, lowe ma'e eiye, ");
INSERT INTO sny_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Lu taune ta meni eime eito eite iyape ano se au isafiye wisereyeyei su, le lai ane au isafiye wisereyeyei. Meni ape ane ne au isafiye wisereyeyei su, le tai ano ma'e aiwawe a'i au isafiye wisereyeyei. Tai ano lai ane hi awei ma'e eimawe arosai.” Mt 10:40 ");
INSERT INTO sny_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Sosu a'i pe Jon lai Jisas ma'e eiye, “Atuatu siye Meni Owane, nomo meni ta iyape no se sepei luwaru au ta'ane sasarisawiyei siyeye. Nomo meni ape einamiye. Le nomo mase umasi ta'ame.” ");
INSERT INTO sny_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ahowa, Jisas le ma'e itiya'u eiye, “Fene meni ape owe ape einamite. Meni ta iyape ano se wiyawi erasi pefine a'i ta'aneyei su, le ane ne peri au te'e narurowata. ");
INSERT INTO sny_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Meni ta nomo ma'e ai aturowata, le nomo mase ironamitorowa. Mt 12:30; Lu 11:23 ");
INSERT INTO sny_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ane fene ma'e peri wiyeme a'i au te'esiya. Meni ta fene yo peri ano umasiteye ape, le sa'i naretei fene ma'e au ayei su, Owane Sitewi lai le ma'e etiri wisere a'i ta aurowa. Mt 10:42 ");
INSERT INTO sny_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Meni eime oso eito eite, yo peri ano umasiteye ape, lu taune tamo meni eime ta yo seni luwaru a'i au atuatuwei su, Owane Sitewi lai meni ape ai marepi erasi a'i toterowa. Owane Sitewi lo ai marepi apou wou a'i ne. Lu tamo meni ape tapiye erasi a'i pere'i sahe wafei se ti tawesirowawe, sa'i papu fusawirowa. ");
INSERT INTO sny_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Aiwawe a'i ereti fene lo lai yo seni luwaru a'i ta ma'e au irowei su, fene ereti ape aine tou fusawire. Fene Owane Sitewi lo omo hire ma'e ereti ta'i a'i se wirowa. Eite wisere a'i ne. Fene yehe omo ma'e ereti hesi a'i se yo seni luwaru a'i ta ma'e au irowei. Eite luwaru a'i ne. ");
INSERT INTO sny_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","{Yehe omo sahe i'ere oso oso a'i weriyei weriyei ironamitorowa. Sosu yehe ape weriyei weriyei ironamitorowa.} Mt 5:30 ");
INSERT INTO sny_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Aiwawe a'i lowe fene lo lai yo seni luwaru a'i ta ma'e au irowei su, fene lowe ape aine tou fusawire. Fene Owane Sitewi lo omo hire ma'e lowe ta'i a'i se wirowa. Eite wisere a'i ne. Fene yehe omo ma'e lowe hesi a'i se yo seni luwaru a'i ta ma'e au irowei. Ape luwaru a'i tene! ");
INSERT INTO sny_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","{Yehe omo sahe i'ere oso oso a'i weriyei weriyei ironamitorowa. Sosu yehe ape weriyei weriyei ironamitorowa.} ");
INSERT INTO sny_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Sosu aiwawe a'i nihe fene lo lai yo seni luwaru a'i ta ma'e au irowei su, fene nihe ape ani tahe ani fusawire. Fene Owane Sitewi lo omo hire ma'e nihe ta'i a'i fa irote. Ape wisere a'i ne. Fene yehe omo ma'e nihe hesi a'i se yo seni luwaru a'i au irowei su, ape luwaru a'i tene! Mt 5:29 ");
INSERT INTO sny_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‘Yehe omo sahe i'ere oso oso a'i weriyei weriyei ironamitorowa. Sosu yehe ape weriyei weriyei ironamitorowa.’ ");
INSERT INTO sny_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Fene ipari sei fe lo'u, haiye sahe fuwei su, fi wisere a'i irorowa. Aiwawe a'i Owane Sitewi lai lu taune werese lo yo seni werese yehe fu meterowa. Yo seni luwaru a'i ape yehe lai tisoro'o tepa'asirowa. ");
INSERT INTO sny_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ipari sei wisere a'i ne. Sei ape ai lo po'uteyei su, eiwerai fi ape si furowa awere? Fene ipari sei lo fi wou a'i heneraire. Fene ipari sei fi wou a'i heneraiyei su, fene lu taune werese marepi fetane a'i au irotorowa.” Mt 5:13; Lu 14:34 ");
INSERT INTO sny_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Sosu a'i pe Jisas sineyewe, omo Kaperneam ape arunatiyewe, omo pani Judia ma'e fi. Le pani Sa'i Jordan feni eire ma'e fi. Lu taune tomu ne'ese le ma'e ta'uwerai. Mi mi werese lu taune le ma'e ta'uwerai su, le lowe ma'e au te'e atuatu areiyeteye. ");
INSERT INTO sny_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Lu Farisi tamo Jisas ma'e peri ta te'e toweriyei ne fai. Lowe le ma'e apou te'e toweriye, “Meni ta fara'u tani lo aite mai ma'e eimawesawiyei awere?” ");
INSERT INTO sny_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jisas lowe ma'e itiya'u eiye, “Meni Moses, piye peri le leseye awere?” ");
INSERT INTO sny_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Sosu lowe le ma'e itiya'u eiye, “Moses apou au te'eye, ‘Meni ta tani lo aite mai ma'e eimawesawiyei ne toteyei su, meni ape peri ta one towe sahe apou leseyei, ane tani ano aite mai ma'e si eimawesawirowa.’” ");
INSERT INTO sny_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ahowa, Jisas lowe ma'e itiya'u eiye, “Moses peri ape one towe sahe leseye su, le marepi kairefi a'i fene lo ne toteye. Serai le peri ape leseye. ");
INSERT INTO sny_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Tu naifa weriyei weriyei Owane Sitewi lai etiri werese au ta'aneteye su, ‘Le lai meni tutawe ape, sosu tani lo au ta'aneye.’ ");
INSERT INTO sny_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Serai meni ta tani naituwei ne toteyei su, lowesi wesi tere'e ma'e howeiteyei ne irowa. ");
INSERT INTO sny_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Meni ape tani lo naituwei su, lowesi tahe ta'i a'i henerairowa. Serai lowesi tahe tere'e tere'e iro ta'ame. Ahowa, lowesi tahe ta'i a'i iroteyei.’ ");
INSERT INTO sny_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Owane Sitewi lai meni ape tani lo naituwei su, lu tamo naituwei lai lowesi lo ape eiwerou au luwaruwerowata.” ");
INSERT INTO sny_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Sosu Jisas peri te'e tepa'asiye su, le lu disaipel lo mase wesi papu wiye. Lu disaipel lo le ma'e peri ape lo sitewi ne te'e toweriye. ");
INSERT INTO sny_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jisas lowe ma'e itiya'u eiye, “Meni ta tani lo aite mai ma'e eimawesawirowawe, menitani tere'e naituwei su, meni ape tafa'e yo seni luwaru a'i tani he'i a'i lo ma'e irowei. Mt 5:32 ");
INSERT INTO sny_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Sosu aiwawe a'i menitani ape meni he'i a'i lo arunatirowawe, meni tere'e naituwei su, menitani ape tafa'e yo seni luwaru a'i meni lo ma'e irowei.” ");
INSERT INTO sny_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Sosu a'i pe lu taune tomu ne'ese eimane oso oso a'i Jisas ma'e ereti lo se fa isawe hetesiyeyei ne henetai. Jisas lo lu disaipel lowe ma'e ai marepi se einamiteye. ");
INSERT INTO sny_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jisas etiri ape siyeye su, le lu disaipel lo ma'e ai peri erasi apou eiye, “Eimane oso ape ane ma'e henetaire. Fene lowe ane ma'e aiyeyei ne owe ape einamire. Owane Sitewi lo marepi eimane eitou eite wou a'i totesiya. ");
INSERT INTO sny_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Peri ano wiyeme a'i tene! Wanuwe! Ane fene ma'e eisiya, meni ta Owane Sitewi lo omo hire ma'e wiyei ne toteyei su, le eimane wou a'i Owane Sitewi lo marepi tote tawesi umasirowa. Meni ta eimane wou a'i Owane Sitewi lo marepi tote tawesi ta'ame su, le Owane Sitewi lo omo hire ma'e wirowata.” Mt 18:3 ");
INSERT INTO sny_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Sosu le eimane werese ereti lo se ya'oreyewe, lowe ma'e ereti lo se isawe hetesiyeye. Le lowe ma'e au te'e wisereyeteye. ");
INSERT INTO sny_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Sosu a'i pe Jisas lowe werese arunatiyewe, omo pani ma'e fi. Meni ta Jisas siyeye su, le Jisas ma'e iterotai. Le Jisas ma'e lowe uporo ape'i onuwewe, le ma'e ei toweriye, “Atuatu siye meni wisere a'i ne, Ane mi mi pasi pasi ironamiyei ne toteyei. Ane eiwerou irowei su, weriyei weriyei iroteyei awere?” ");
INSERT INTO sny_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Sosu Jisas le ma'e itiya'u eiye, “Ne piyene ane meni wisere a'i te'eye awere? Owane Sitewi ta'i a'i wisere a'i tene! ");
INSERT INTO sny_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ne Owane Sitewi lo yo peri so'oruwesiya tene! ‘Ne meni ta owe ape aine tera'ete. Ne tafa'e yo seni luwaru a'i owe ape irote. Ne etiri ta owe ape ta'areite. Ne peri wawero owe ape te'ete! Ne lu taune ma'e owe ape arearete. Ne aite mai no peri lowesi lo ape a'i wanu umasite.’” ");
INSERT INTO sny_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Meni ape Jisas ma'e itiya'u eiye, “Atuatu siye meni owane, ane meni eime oso a'i iroteye su, ane Owane Sitewi lo yo peri werese umasinamiteye.” ");
INSERT INTO sny_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Sosu Jisas meni ape siye etiye. Le marepi erasi a'i le ma'e tote wawesiyeye. Sosu Jisas le ma'e eiye, “Ne etiri ta te'e a'i ne. Ne etiri werese no ne lu tamo lai eterowawe, ne ma'aru werese ape lu taune etiri ma'aru ariye ape, ma'e none isafiyere. Sosu ne ma'aru werese ape lu none isafiyeyei su, ne Owane Sitewi lo omo hire ma'e etiri wisere anirowa. Sosu ne ane mo'o umasita.” ");
INSERT INTO sny_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Meni ape Jisas lo peri wanuwe su, le ereme se a'i irowe. Marepi lo orese a'i ne. Sosu le si fi. Meni ape etiri tomu ne'ese iroteye. ");
INSERT INTO sny_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Sosu Jisas lu taune ma'e atati siye etiye. Le lu disaipel lo ma'e apou eiye, “Meni ta ma'aru tomu ne'ese iroteyei su, le Owane Sitewi lo omo hire ape eiwerou wirowa awere? Meni ta ma'aru topo lo marepi erasi a'i toteteyei su, le Owane Sitewi lo omo hire ma'e wirowata.” ");
INSERT INTO sny_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Lu disaipel lo Jisas lo peri wanuwe su, lowe hepene se su'ariye. Ahowa, Jisas lowe ma'e itiya'u tame eiye, “Fene eimane wou a'i ne! Meni ta etiri ma'aru tomu ne'ese irosiya ape, Owane Sitewi lo omo hire ma'e wiyei ne toteyei su, le omo hire ma'e wirowata. ");
INSERT INTO sny_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Fene fara'u fe kamel ta ni'ari lo yo papu feni ma'e ni'ariye ani tahe aniyei awere? Ahowa! Meni ta fe kamel ape ni'ari lo yo papu feni ma'e ni'ariye ani tahe anirowata. Sosu aiwawe a'i meni ta lai, ma'aru, etiri tomu ne'ese irosiya ape, Owane Sitewi lo omo hire ma'e wirowata.” ");
INSERT INTO sny_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Lu disaipel lo ma'e hepene erasi a'i se su'ariye. Lowe le ma'e te'e toweriye, “Eiwerai Owane Sitewi lo omo hire ma'e wirowa awere? Eiwerai marepi hepene he'i weriyei weriyei irotorowa awere?” ");
INSERT INTO sny_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jisas lowe ma'e siye etiyewe, lowe ma'e itiya'u eisiya. “Lu taune werese marepi towafi lowe lo umasiyei su, lowe a'i lai omo hire ma'e wirowata. Ahowa, owe etiri ta Owane Sitewi a'i lai fara'u au ta'anerowata.” Owane Sitewi lai kairefiyeyei lo se etiri werese a'i fara'u ta'anerowa. ");
INSERT INTO sny_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Sosu Pita le ma'e eiye, “Siyere! Nomo etiri werese nomo lo arunatiyewe, ne mo'o umasiteye.” ");
INSERT INTO sny_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Sosu Jisas apou eiye, “Wanure! Peri ano wiyeme a'i tene! Ane fene ma'e eisiya. Lu taune tamo wesi towafi lowe lo, einei, airu, pa'ise towafi lowe lo, aite mai towafi lowe lo, eimane, ta'aneyei awei towafi lowe lo arunatirowawe, sosu Owane Sitewi lo peri lu taune tere'e ma'e au te'e fiyariyei ne iyei su, ");
INSERT INTO sny_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","lowe etiri werese lowe lo arunatiyei ape, nowe pereye ape se lowe etiri tomu ne'ese anirowa. Wesi tomu ne'ese, einei, airu, pa'ise tomu ne'ese, aite, mai, eimane tomu ne'ese, ta'aneyei awei tomu ne'ese, lowe etiri tomu ne'ese ape anirowa. Lu tamo lowe ma'e au luwaruwerowa su, sosu nowe ye'ewi se, lowe mi mi pasi pasi ironamitorowa. ");
INSERT INTO sny_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ahowa, lu taune tamo yaru tutawe heneraiyei ne toteyei su, lowe yaru ye'ewi ma'e teitorowa. Sosu aiwawe a'i lu taune tamo yaru ye'ewi irorowa su, lowe yaru tutawe ma'e irotorowa.” Mt 20:16; Lu 13:30 ");
INSERT INTO sny_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Sosu a'i pe lowe lu taune werese arunatiyewe, omo Jerusalem ma'e fi. Jisas yo ape sahe tu fi. Sosu lu disaipel lo mo'o umasiteye. Lowe marepi hepene se su'ariye. Lu taune ape mo Jisas mo'o umasiteye ape, lowe marepi atoweiyeye. Sosu Jisas lu disaipel lo feni eire ma'e henetiyewe, lowe ma'e etiri werese le ma'e heneraiyei ape, au te'e areiyeteye. ");
INSERT INTO sny_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Le lowe ma'e eiye, “Wanure! Nomo omo Jerusalem ma'e yaneyei. Meni ape, Owane Sitewi lai hi awei ma'e eimawe arosai ape, lu tamo ane ereti wafei se ti tawesirowawe, au heseyei lu owane tamo ma'e henetirowa. Au heseyei lu owane, sosu Owane Sitewi lo peri so'oruwe siye lu owane tamo, lowe ane etiyei ne henetirowa. Lowe ane ne apou te'erowa, ‘Meni ape fa temeniyere.’ Sosu lowe ane awei lo lu owane ma'e henetirowa. ");
INSERT INTO sny_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Lu ape mo lai ane ma'e te'e narurowa. Lowe ane ma'e pisa'i topoho sene'irowa. Lowe wafei se me'iyeni ano ma'e ainerowa. Sosu lowe ane aine tera'erowa. Ane fisiye yo papu poweiye hesi heta howei tepa'asirowa su, ane si norohuwe sinerowa.” Mk 8:31; 9:31 ");
INSERT INTO sny_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sosu a'i pe Jems, sosu pa'ise Jon, Sebedi lo eimane hesi, lowesi Jisas ma'e peri ta te'e toweriyei ne fai. Lowesi le ma'e te'eye, “Atuatu siye Meni Owane, notosi ne ma'e peri ta te'e toweriyei, Ne fara'u etiri ta notosi ma'e fa aure.” ");
INSERT INTO sny_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jisas lowesi ma'e itiya'u eiye, “Fenesi piye etiri ta ane fenesi ma'e auwei awere?” ");
INSERT INTO sny_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Sosu lowesi le ma'e apou te'e toweriye, “Ne Meni Owane Pefine mitaiyeyei erasi a'i se heneraiyei su, ne notosi ereti eyate feni ma'e, ereti opi feni ma'e onuwei ne aure. Notosi kairefi no se papu irotorowa.” ");
INSERT INTO sny_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ahowa, Jisas lowesi ma'e itiya'u eiye, “Fenesi peri ape lo si tewi so'oru ta'ama. Fenesi fara'u siye awe ano se sa'i ayei awere? Ane sa'i se au huwei su, fenesi fara'u sa'i ape se ani huwei awere?” Mk 14:36; Lu 12:50 ");
INSERT INTO sny_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Sosu lowesi le ma'e itiya'u eiye, “Ei, notosi siye awe no se sa'i ayei. Sosu notosi sa'i no se aiwawe a'i ani huwei.” Ap 12:2; KTH 1:9 ");
INSERT INTO sny_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","“Owane Sitewi a'i lai ereti eyate feni, ereti opi feni ma'e ano ariariye tepa'asiye. Eiwerai ereti eyate feni, ereti opi feni ma'e onurowa awere? Etiri ape ane lai au ariariyerowata.” ");
INSERT INTO sny_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Lu feni tere'e werese lo peri lowesi lo wanuwe su, lowe Jems, Jon ne ai peri erasi toteye. ");
INSERT INTO sny_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Sosu Jisas lu feni werese lo le ma'e ei aniyewe, lowe ma'e eiye, “Awei lo lu owane werese, lowe lu taune lowe lo ma'e kairefi se au noweinowei te ta'ame. Lu taune werese ape mo lowe lai lu owane lowe lo se ai peri ape wanuwe su, lowe marepi hepene tahe lowe lo orese erasi a'i teriteteye. Lu 22:25-26 ");
INSERT INTO sny_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ahowa, fene awei lo lu owane lo yo seni luwaru a'i wou umasi ta'ame. Meni ta meni owane erasi a'i heneraiyei ne toteyei su, le lu taune ma'e wiyawi yahowa'i pei henerairowa. Mt 23:11; Mk 9:35 ");
INSERT INTO sny_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Lu taune tamo tutawe heneraiyei ne toteyei su, lowe wiyawi yahowa'i ani siye lu fa heneraire! ");
INSERT INTO sny_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Peri ano wiyeme a'i tene! Meni ape, Owane Sitewi lai hi awei ma'e eimawe arosai ape, ane lai meni owane pefine a'i heneraiyei ne fai ta'ama. Opiya! Ane lu taune ma'e wiyawi yahowa'i irowei ne fai. Ane lai marepi hepene ano lu taune tomu ne'ese ne temeniyerowa. Ane lai lu taune werese si tame ete hene anirowawe, sosu lowe ma'e marepi hepene he'i aseyaro a'i aurowa.” ");
INSERT INTO sny_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Sosu a'i pe Jisas lu disaipel lo mase omo Jeriko ma'e henerai. Lowe lu taune tomu ne'ese mase omo Jeriko nowe ma'e arunatiyewe fi su, meni ta nihe pokowe niso'uwe tawesiteye ape, yo mai tewiye sahe onuteye. Meni ape iyape Bartimeus. Aite lo iyape Timeus. Le yo tewiye sahe lu taune lo ma'aru yahowa'i ei aniyei ne onuteye. ");
INSERT INTO sny_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Meni ape peri no'u erasi wanuwe su, le apou ei toweriye, “Eiwerai aiyesiya awere?” Lowe apou itiya'u le ma'e eiye, “Meni ape Jisas omo Nasaret ma'e fai ape, aiyesiya.” Le peri erasi Jisas ma'e hare uteye, “Jisas ne ya'ariyei Devit lo meni eime, ne ane ne ferafereire!” ");
INSERT INTO sny_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Lu taune tomu ne'ese meni ape lo peri wanuwe su, lowe meni ape ma'e ai peri se eiye, “Ne peri sawa!” Ahowa, meni ape peri erasi tame hare uteye, “Ya'ariyei Devit lo meni eime, ne ane ne ferafereire!” ");
INSERT INTO sny_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Sosu Jisas peri lo wanuwe su, le meni ape ei aniye. Lu tamo meni ape ma'e eiye, “Marepi no tote kairefiyere! Sinere! Le ne ei aniye.” ");
INSERT INTO sny_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Meni ape peri lowe lo wanuwe su, le ipari tahe lo ani tahe fusawiyewe, itero sineteyewe, Jisas ma'e fi. ");
INSERT INTO sny_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Sosu Jisas le ma'e apou ei toweriye, “Ane ne ma'e eiwerou irowei ne totesiya awere?” Sosu meni ape nihe pokowe tawesiye ape, le ma'e itiya'u eiye, “Atuatu siye meni owane, ane etiri werese a'i siyeyei ne totesiya.” ");
INSERT INTO sny_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Sosu Jisas le ma'e eiye, “Ne wesi no ire! Tote tawesiyei no lai nihe no au petane tepa'asiye.” Witane a'i meni ape lo nihe petene tepa'asiye. Sosu le Jisas mo'o umasiti. Mk 5:34 ");
INSERT INTO sny_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Sosu a'i pe Jisas lu feni mase lu taune tomu ne'ese, lowe omo Jerusalem atahe ma'e henerai. Lowe omo Betfage, sosu omo Betani iroteye su, le lu disaipel lo hesi a'i omo ta eimawesawi. Lowe Omo Oliv atahe a'i iroteye. ");
INSERT INTO sny_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Sosu le lowesi ma'e eiye, “Fenesi omo feni eire ma'e ire. Sosu wesi ta omo ma'e heneri su, fenesi fe donki yene yo'orei a'i wesi sahe siyerowa. Fe donki ape wafei se ti tawesi teisiya. Fe donki ape tu naifa meni ta lai onu ta'ame. Sosu wafei ape eraurowawe, fe donki ape aiwawe heneta. ");
INSERT INTO sny_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Meni ta fenesi ma'e apou ei toweriyei su, ‘Fene piyene fe donki ape wafei erausiya awere?’ Fenesi lowe ma'e itiya'u te'ere! ‘Meni Owane nomo lo fe donki ape anireme.’ Sosu witane a'i le fe donki fenesi mase eimawesawiyei.” ");
INSERT INTO sny_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Sosu lowesi Jisas arunatiyewe, wesi omo ma'e heneri. Lowe fe donki ta yo mai sahe siyeye. Fe donki ape wesi me tau sahe wafei se ti tawesiteye. Sosu lowesi fe donki lo wafei ani erauwe. ");
INSERT INTO sny_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Sosu lu tamo saro atahe teiteye ape, lowesi ma'e te'e toweriye, “Fenesi piyene fe donki ape lo wafei erausiya awere?” ");
INSERT INTO sny_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Sosu lowesi Jisas lo peri ape lowe ma'e apou eiye, “Meni Owane nomo lo fe donki ape aniyei ne totesiya.” Lowe peri ape wanuwe su, lowe apou eiye, “Ei, fara'u fe donki ape henetire.” ");
INSERT INTO sny_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Sosu lowesi fe donki ape Jisas ma'e heneti. Lowe ipari tahe lowe lo fe donki lo me'iyeni ma'e fu arowe. Sosu Jisas fe donki lo me'iyeni hire sahe onuteye. ");
INSERT INTO sny_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Lu taune tomu ne'ese ipari tahe lowe lo yo mai saro ani tahe lotowe. Lu taune tere'e tamo ta'aneyei awei ma'e fiyewe, siye towe tamo aniyewe, lowe yo mai sahe lotowe. ");
INSERT INTO sny_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Sosu lu taune tomu ne'ese tutu iteye, sosu lu taune tamo me'iye aiyeteye. Lowe werese peri erasi a'i hare uteye, “Meni Owane Pefine a'i aiyesiya. Fene werese meni ape ma'e, Meni Owane Pefine a'i lo iyape se aiyesiya ape, au te'e wisereye nine'ite. ");
INSERT INTO sny_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Fene Owane Sitewi Pefine a'i ma'e au te'e wisereyere! Nowe ape se le lai lu taune werese au noweinoweinamirowa ape, aiyesiya. Ya'ariyei meni owane Devit lo niyene aiyesiya. Meni Owane Pefine a'i aiyesiya. Fene iyape lo hire te'e ani arowete.” ");
INSERT INTO sny_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Sosu a'i pe Jisas omo Jerusalem ma'e heneri. Le Owane Sitewi lo wesi tutawe papu wiyewe, etiri werese siyeteye. Sosu le Owane Sitewi lo wesi tutawe arunatiyewe fi. Nowe neriwei su, le lu disaipel lo mase omo Betani ma'e iyei ne toteye. ");
INSERT INTO sny_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Nowe mo'o su, lowe omo Betani arunatiyewe, lowe omo Jerusalem ma'e fi. Yo mai sahe Jisas lau erasi teriteye. ");
INSERT INTO sny_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Sosu Jisas me owarape ta eyeri ma'e teteye ape siyeye. Motowe tomu ne'ese iroteye. Le me owarape ape ma'e so siyeyei ne fi. Me si sahe teirai su, so werese ariye. Motowe a'i iroteye. Me owarape lo nowe, so ta'esiya ape, henerai se ta'ame. Lu 13:6 ");
INSERT INTO sny_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Sosu le me owarape ape ma'e apou te'eye, “Mi mi weriyei me so werese owe ape ta'ere. Lu taune werese me so no ene arowata.” Lu disaipel lo peri lo wanu tote tawesiye. ");
INSERT INTO sny_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Sosu a'i pe lowe omo Jerusalem ma'e heneri. Le Owane Sitewi lo wesi tutawe papu wiye. Le lu tomu ne'ese etiri tamo metei sahe futeyewe, lu taune tamo lai ete aiseraiteye. Jisas metei werese ani aweto terosowewe, lu werese ape mo Owane Sitewi lo wesi tutawe nowe ma'e ani au sasarisawi. Lu tamo ma'aru tamo, hese erei tiyatiye ape, le metei lo ani aweto terosowe. Lu tamo irowe sapuwe ereti aniteye ape le me to'u werese lowe lo ani aweto terosowe. ");
INSERT INTO sny_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Lu taune werese, etiri tamo Owane Sitewi lo wesi tutawe papu suteteye ape, le lowe werese wesi ape papu einamiye. ");
INSERT INTO sny_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Sosu le lowe ma'e Owane Sitewi lo peri au atuatu te'e areiyeye, “Owane Sitewi lo one towe sahe apou leseye, ‘Wesi ano lu taune omo werese ape mo Owane Sitewi ma'e au te'e wisereyeyei ne fara'u fa ta'uweraite. Ahowa, fene Owane Sitewi lo wesi ape ta'arei wesi wou au iro henerai ne.’” ");
INSERT INTO sny_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Sosu au heseyei lu owane, sosu Owane Sitewi lo peri so'oruwe siye lu owane tamo, lowe Jisas lo peri ape wanuwe su, lowe ai marepi erasi a'i Jisas ne toteteye. Serai lowe Jisas aine tera'eyei ne toteye. Ahowa, lowe Jisas lo peri ne atoweiyeteye. Lu taune werese Jisas lo peri ape ne, lowe hepene se su'ariye. Mk 14:1 ");
INSERT INTO sny_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nowe neriwei su, Jisas lu disaipel lo mase omo Jerusalem arunatiyewe, fi. ");
INSERT INTO sny_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Sosu a'i pe nowe mo'o esi a'i su, Jisas lu disaipel lo mase si omo Jerusalem ma'e fi. Lowe me owarape ape iriyayeyei siyere. Me owarape ape napi, tahe, motowe werese foro'owe tepa'asiye. ");
INSERT INTO sny_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Sosu Pita me owarape ape siyeye su, le Jisas lo peri ape ne tote tawesiye. Le Jisas ma'e apou eiye, “Atuatu siye meni owane, me owarape ape siyere! Ne liyewe me ape ma'e eiye, ‘Me ape lo so fa luwaruwere!’ Pereye me ape iriyayeye.” ");
INSERT INTO sny_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Sosu Jisas lowe ma'e itiya'u eiye, “Fene Owane Sitewi ne tote tawesire. ");
INSERT INTO sny_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Peri wiyeme a'i ano ane fene ma'e te'e areiyesiya. Meni ta fara'u omo ape ma'e apou eiyei su, ‘Ne sinere! Ne hare ite erasi ma'e ye'i arore.’ Meni ape marepi erasi a'i se tote tawesiyei su, sosu marepi hesi se tote ta'ame su, le apou toteye, ‘Etiri ape wiyeme a'i henerairowa. Ane so'oruwesiya tene!’ Serai Owane Sitewi lai etiri ape au irowei ne. Mt 17:20 ");
INSERT INTO sny_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Serai ane fene ma'e eisiya, fene etiri ta, fene Owane Sitewi ma'e te'e toweriyei ape, fene Owane Sitewi ne tote tawesiyei su, Owane Sitewi lai etiri ape fene ma'e aurowa. Mt 7:7 ");
INSERT INTO sny_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Sosu aiwawe a'i, fene Owane Sitewi ma'e sine teirowawe, Owane Sitewi ma'e au te'e wisereyeyei su, fene marepi erasi totere! Meni ta lai fene ma'e au luwaruweye su, fene meni ape lo yo seni luwaru a'i fene ma'e irowe ape, tote i'anere! Fene yo seni luwaru a'i, meni ta fene ma'e irowe ape, tote i'aneyei su, aite fene lo, omo hire sahe irosiya ape, yo seni luwaru a'i fene lo tote i'anerowa.” Mt 6:14-15 ");
INSERT INTO sny_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","{Fene yo seni luwaru a'i, meni tere'e ta fene ma'e irowe ape, tote i'ane ta'ame su, Tai fene lo, omo hire ma'e irosiya ape, yo seni fene lo tote i'anerowata.} ");
INSERT INTO sny_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Sosu a'i pe lowe omo Jerusalem ma'e si tame henerai. Le Owane Sitewi lo wesi tutawe papu wiye su, au heseyei lu owane tamo, sosu Owane Sitewi lo peri so'oruwe siye lu tamo, lowe Jisas ma'e peri ta te'e toweriyei ne fai. ");
INSERT INTO sny_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Lowe le ma'e apou te'e toweriye, “Wiyawi erasi pefine a'i no ne, ne etiri ape mo ne iroteye ape, eiwerai ne irowei ne eimawesai awere? Eiwerai kairefi no auwe awere? Eiwerai kairefiyeyei ape ne ma'e auwe awere?” ");
INSERT INTO sny_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Sosu Jisas lowe ma'e itiya'u apou eiye, “Ane peri ta fene ma'e itiya'u ei towerisiya. Fene ane ma'e peri wiyeme a'i itiya'u au te'eyei su, ane fara'u fene ma'e kairefiyeyei ano, ane lu taune ma'e au ta'ane atuatuteye ape, te'e areiyerowa. ");
INSERT INTO sny_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Jon sa'i au hu siye meni lu taune ma'e sa'i au huteye su, fene eiwerou totesiya awere? Owane Sitewi lai Jon ma'e au ariariyeye awere? Lu tamo lai au ariariyeye awere? Fene ane ma'e itiya'u au te'e areiyere!” ");
INSERT INTO sny_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Sosu lowe a'i lai apou te'e te'e tiyatiteye, “Nomo apou te'eyei su, Owane Sitewi lai meni ape ariariyeye. Serai le nomo ma'e itiya'u eiyei, ‘Serai fene piyene meni ape ne tote tawesiteye awere?’ ");
INSERT INTO sny_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ahowa, nomo apou eiyei su, ‘Lu tamo meni ape ariariyeye.’ Lu taune werese nomo ma'e ai peri erasi toteyei. Lu taune werese lai Jon ne Owane Sitewi lo peri au te'e siye meni pefine a'i ne.” ");
INSERT INTO sny_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Sosu lowe Jisas ma'e apou itiya'u eiye, “Nomo so'oru ta'ama.” Sosu Jisas lowe ma'e itiya'u apou eiye, “Ane aiwawe a'i, ane fene ma'e eiwerou au te'e areiyerowata. Ane kairefiyeyei ano eiwerai auwe awere? Serai ane wiyawi ape au ta'aneteye.” ");
INSERT INTO sny_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Sosu a'i pe Jisas au heseyei lu owane ma'e peri anowe tamo au te'eteye. Le lowe ma'e apou eiye, “Meni ta ta'aneyei awei ta'aneteye. Le ta'aneyei awei lo tewiye ma'e tapiye fisahe yose ta'aneye. Meni ape ta'aneyei awei ape papu awei fisiye yo ta horuseye. Awei fisiye yo ape wiyawi lu tamo wafei wain so papu fu arowe lowe wafei so ape me au se hire aine tapoteye. Sosu le tapiye wesi ta pite a'i ta'aneye. Wiyawi lo ta'aneye tepa'asiye su, le wiyawi lu tamo au noweinoweiyei ne eteye. Sosu meni ape omo pani eyeri ma'e sewiyeyei ne fi. Ais 5:1-2 ");
INSERT INTO sny_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Sosu nowe ape se wafei so ape werese pere'eyeye ape, meni ape wiyawi meni yahowa'i ta'aneyei awei ma'e wafei ape lo so sa'i tewi a'i aniyei ne eimawesawi. ");
INSERT INTO sny_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Wiyawi lu ape mo wiyawi meni yahowa'i siye aniye su, lowe meni ape me au se aineyewe, omo topo lo ma'e ariye a'i si eimawesawi. ");
INSERT INTO sny_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Sosu meni owane ape wiyawi meni yahowa'i tere'e ta'aneyei awei ma'e wafei ape lo so sa'i aniyei ne eimawesai. Wiyawi lu ape mo meni ape siye aniye su, lowe meni ape lo mato me au se aine tepi'owe. Lowe tahe pa'are lo fofowei a'i au luwaruweye. Meni ape neritase erasi a'i irowe. ");
INSERT INTO sny_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Meni owane ape meni tere'e lowe ma'e eimawesawi. Lowe lai meni ape aine tera'eyewe, ta'aneyei awei nowe ma'e fu arowe. Sosu meni ape wiyawi lu tere'e tamo lowe ma'e wafei so sa'i aniyei ne eimawesawi. Lu ape mo lai wiyawi tamo me au se aineye. Wiyawi lu tere'e tamo aine tera'eye. ");
INSERT INTO sny_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Meni owane ape marepi erasi a'i toteye. ‘Ane meni ye'ewi ta'i a'i lowe ma'e eimawesawi papa. Ane meni eime ano ta'i a'i eimawesawirowa. Meni eime ta'i ano, ane lai erasi a'i totenamisiya ape, lowe lai meni eime ano wisere a'i au noweinowei irorowa.’ ");
INSERT INTO sny_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ahowa, wiyawi lu ape mo, meni eime ape siye aniye su, lowe apou tote te'e tiyatiteye, ‘Siyere! Meni owane lo meni eime ta'i a'i ape, nomo ma'e fai ape, siye aniye. Meni owane nomo lo ape temeniyeyei su, meni eime ape lai ta'aneyei awei eite tesi au noweinoweirowa.’ Wanure! Nomo meni eime ape aine tera'eyei. Serai nomo lai ta'aneyei awei ape tesi au noweinoweirowa. ");
INSERT INTO sny_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Sosu lowe meni eime ape aine tera'eye su, lowe tahe pa'are lo ta'aneyei awei nowe ma'e ani fu arosawi. Hi 13:12 ");
INSERT INTO sny_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Meni owane ape, le ta'aneyei awei lo wiyawi lu ape ma'e eiwerou irorowa awere? Wanure! Le lai aiyerowawe, wiyawi lu ape mo werese aine tera'erowa. Sosu le wiyawi lu tere'e tamo ta'aneyei awei ape au noweinoweiyei su, ane lu tere'e he'i ape au eterowa. ");
INSERT INTO sny_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Fene Owane Sitewi lo peri one towe sahe siye te'eteye awere? Wanure! ‘Me tou ape wiyawi lu werese lai ani nowe ma'e ani fusawi. Me tou ape tutawe wesi sahe henerairowa. ");
INSERT INTO sny_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Meni Owane pefine a'i lai etiri ape au ta'ane irowe. Nomo etiri ape siyeye su, nomo marepi erasi a'i toteteye.’” ");
INSERT INTO sny_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Au heseyei lu owane tamo lai lowe Jisas ma'e ereti wafei se ti tawesiyewe, kalabus ma'e henetiyei ne toteye. Ahowa, lowe lu taune werese lo ai peri atoweiyeye Jisas peri anowe ape te'eye su, le au heseyei lu owane ne au te'e areiyeteye. Serai lowe le arunatiyewe fi. ");
INSERT INTO sny_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Au heseyei lu owane tamo lai lu Farisi tamo awei meni owane Herot lo lu tewi tamo Jisas ma'e eimawesawi. Lowe Jisas ma'e peri wawero wanuwei ne fai. Lowe peri wawero ta Jisas au te'eyei su, lowe Jisas etiyei ne toteye. Mk 3:6 ");
INSERT INTO sny_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Sosu lowe Jisas ma'e peri ta te'e toweriyei ne fai. Lowe apou te'e toweriye, “Atuatu siye meni Owane, nomo ne meni wara'i pefine a'i tene! Aiwawe a'i lu tere'e tamo lai marepi no eterowata. Ne etiri erasi a'i ta nati wafei no au heserowata. Ahowa, ne Owane Sitewi lo peri wiyeme a'i lu taune werese ma'e au te'e areiyeteye. Ne peri ta nomo ma'e itiya'u au te'esa. Nomo yo peri umasiyei ne totesiya. Nomo fara'u takis ma'aru awei meni owane Sisar auwei awere? Piyete awere? ");
INSERT INTO sny_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Nomo awei meni owane ma'e ma'aru tewi ta auwei awere? Piyete awere?” Jisas marepi luwaru a'i lowe lo siye so'oruwe tepa'asiye. Sosu le lowe ma'e eiye, “Piyene fene peri ano au areareyei ne totesiya awere? Fene ane ma'aru tau ausa. Ane siyereme.” ");
INSERT INTO sny_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Sosu lowe ma'aru tau Jisas ma'e aitai. Sosu le lowe ma'e ei toweriye, “Nihari hepene eiwerou lo awere? Peri ta leseye ape eiwerou lo awere?” Sosu lowe le ma'e itiya'u eiye, “Nihari hepene ape, Sisar lo ne.” ");
INSERT INTO sny_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Sosu Jisas lowe ma'e itiya'u eiye, “Wiyeme tene! Serai fene meni Sisar lo etiri werese ape mo, fene awei meni owane Sisar si tame aure. Sosu aiwawe a'i Owane Sitewi lo etiri werese ape mo fene Owane Sitewi ma'e si aure.” Lu werese ape mo Jisas lo peri wanuwe su, lowe hepene se su'ariye. Ro 13:7 ");
INSERT INTO sny_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sosu lu owane tere'e iyape Sadyusi Jisas ma'e peri ta te'e toweriyei ne fai. Lowe apou toteye. “Lu taune werese temeniyeyei su, lowe si norohuwe sinerowata.” Lowe Jisas ma'e te'e toweriye. Ap 23:8 ");
INSERT INTO sny_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Atuatu siye meni owane, meni Moses yo peri ta apou leseye, ‘Meni ta tani lo naituwe. Nowe me'iye, meni ape temeniyeye. Lowesi eimane werese se ta'ama. Serai meni ape lo pa'ise tani lo naiturowa. Sosu lowesi eimane auteirowa. Eimane werese ape meni tu temeniyeye ape lo ne.’ ");
INSERT INTO sny_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Lu nairipi ereti feni werese feni hesi a'i iroteye. Meni eime poto tani lo naituwe. Nowe me'iye ta se meni eime poto temeniyeye. Eimane se ta'ama. ");
INSERT INTO sny_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Sosu meni eime pafe lai airu lo menitani weiname naituwe. Me'iye su pafe temeniyeye. Eimane autei ta'ame. Aiwawe a'i pafe lo tani weiname, Henei lai tame naituwewe, sosu temeniyeye. ");
INSERT INTO sny_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Aiwawe a'i lu nairipi werese ape lai tani ta'i ape a'i naituwe. Lu nairipi werese temeniyeye. Sosu menitani ape aiwawe a'i temeniyeye. ");
INSERT INTO sny_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Nowe ye'ewi se lu taune si norohuwe sinerowa su, lu nairipi werese ape, eiwerai menitani naiturowa awere? Awei sahe lu nairipi werese lai menitani ape naituwe ape, tepa'asiye.” ");
INSERT INTO sny_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Sosu Jisas lowe ma'e itiya'u eiye, “Fene Owane Sitewi lo peri lo sitewi werese so'oru ta'ama. Marepi fene lo luwaru a'i irosiya. Fene Owane Sitewi lo kairefi pefine a'i so'oru ta'ama. ");
INSERT INTO sny_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Lu taune werese si norohuwe sinerowa su, lu werese taune tamo naiturowata. Aiwawe a'i taune werese lu tamo naitu ene arowata. Ahowa, lowe werese Owane Sitewi lo ipari wisere wou a'i (ensel) irotorowa. ");
INSERT INTO sny_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Fene lu taune, si norohuwe sinerowa ape, lo peri totere! Meni Moses one towe sahe leseye. Owane Sitewi lai Moses ma'e ipo me oso po'o yehe lai ti etineye ape te'eye. Owane Sitewi lai Moses ma'e apou eiye, ‘Ane lai Abraham lo Owane Sitewi Pefine a'i tene! Ane lai aiwawe a'i Aisak lo Owane Sitewi Pefine a'i tene! Sosu ane Jekop lo Owane Sitewi Pefine a'i tene.’” ");
INSERT INTO sny_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Jisas apou eiye, “Le, lu taune temeniyeye ape, lo Owane Sitewi ta'ama. Ahowa, le a'i lai lu taune werese, norohu irosiya ape, lo Owane Sitewi pefine a'i tene!” ");
INSERT INTO sny_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Sosu a'i pe Owane Sitewi lo peri so'oruwe siye meni ta Jisas lo peri wanuwe su, le Jisas ma'e henerai. Le Jisas ma'e apou eiye, “Ne lu ape mo lo peri wiyeme a'i itiya'u te'e areiyeteye. Sosu ane peri ta ne ma'e ei toweriyei. Owane Sitewi lo yo peri tutawe ne piye peri te'esiya awere?” Lu 10:25-28 ");
INSERT INTO sny_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Sosu Jisas le ma'e itiya'u eiye, “Owane Sitewi lo yo peri tutawe apou a'i te'esiya. ‘Israel lo lu taune werese, Peri ano wanu etire! Owane Sitewi Pefine a'i nomo lo ne. Le Owane Sitewi Meni Owane Pefine ta'i a'i tene!’ ");
INSERT INTO sny_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Serai fene Owane Sitewi Pefine a'i fene lo ape marepi erasi a'i tote wawesiyenamite. Fene lai marepi werese se, hepene werese se, sosu kairefi werese se Owane Sitewi, Meni Owane Pefine a'i ma'e marepi erasi a'i tote wawesiyenamite. ");
INSERT INTO sny_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Owane Sitewi lo yo peri to'uresi apou wou a'i ne. ‘Fene lu taune tere'e tere'e ma'e marepi erasi a'i tote wawesiyenamite.’ Owane Sitewi lo yo peri ape mo lowe hesi erasi pefine a'i tene. Yo peri tere'e lai lowesi ma'e unahi irosiya.” ");
INSERT INTO sny_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Sosu Owane Sitewi lo peri so'oruwe siye meni ape le ma'e itiya'u eiye, “Atuatu siye meni owane, peri no wiyeme a'i tene! Ne peri ano ane ma'e wiyeme a'i te'e areiyeye. Ei, Owane Sitewi, Owane Pefine ta'i a'i ironamisiya. God tere'e tere'e werese ape mo lowe areareyei ne. ");
INSERT INTO sny_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Lu taune werese Owane Sitewi Pefine a'i ma'e marepi erasi a'i tote wawesiyenamite! Lowe marepi lowe lo werese se, marepi so'oruwe werese lowe lo se, kairefi lowe lo werese se, lowe lai Owane Sitewi ma'e marepi erasi a'i tote wawesiyenamite. Sosu aiwawe a'i lowe lu taune tere'e tere'e ma'e marepi wisere erasi a'i tote wawesiyenamite. Apou wou a'i lowe tahe pa'are towafi lowe lo au noweinoweinamisiya. Owane Sitewi lo yo peri hesi a'i ape lowe hesi lai Owane Sitewi lo yo peri tutawe a'i tene! Lu taune Owane Sitewi lo yo peri hesi ape umasiyei su, lowe fe sipsip Owane Sitewi ma'e auwei ne aine tera'erowata. Aiwawe a'i lowe etiri tamo Owane Sitewi ma'e au heseyei ne aitairowata.” Lo 4:35; Hos 6:6 ");
INSERT INTO sny_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Sosu Jisas peri ape wanuwe su, le meni ape ma'e itiya'u eiye, “Ne marepi wisere a'i tote te'eye. Ne Owane Sitewi lo marepi ataheye henerai.” Sosu lu tere'e werese Jisas ma'e peri ta te'e toweri ta'ame. Lowe Jisas lo peri ne atoweiyeye. ");
INSERT INTO sny_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Sosu Jisas lu taune ma'e Owane Sitewi lo wesi pefine a'i papu peri ta au te'e areiyeteye. Owane Sitewi lo peri so'oruwe siye lu tamo lowe apou au te'eye. “Meni Krais ape le Ya'ariyei nomo lo Devit lo meni eime tene! ");
INSERT INTO sny_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ya'ariyei nomo lo Devit, Owane Sitewi lo Hepene Wara'i a'i se apou te'eye. ‘Meni Owane Pefine a'i lai meni owane ano apou eiye, ne ereti eyate feni ano se onura. Ane lai airame werese no ape kairefiyeyei no unahi ani furowa.’ ");
INSERT INTO sny_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Meni Devit a'i lai meni ape apou eiye, ‘Ne Meni Owane Sitewi ano.’ Serai piyene meni owane ape Devit lo meni eime te'esiya awere?” Lu taune werese Jisas lo peri wanuteye su, lowe marepi wisere a'i iroteye. ");
INSERT INTO sny_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Sosu a'i pe Jisas lu taune ma'e peri ta au te'e atuatuteye. Le lowe ma'e eiye, “Fene weiyai! Owane Sitewi lo peri siye so'oruweyei siye lu ape mo ne, lowe ipari tahe pitase wisere a'i ani asiteye. Lowe maket lo nepawe sahe uweisiya su, lowe lu taune werese iyape lowe lo te'e aroweyei ne wanuwei ne totesiya. ");
INSERT INTO sny_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Lowe Owane Sitewi lo wesi papu sahe me to'u tutawe sahe onuwei ne toteye. Lowe ta'uwe hereiyei ape lo ene ayei me to'u tutawe sahe onuwei ne toteye. ");
INSERT INTO sny_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Lowe taune weiname ma'e peri wawero ta au te'eye. Sosu lowe taune weiname ape lo etiri werese, wesi papu iroteye ape, ta'arei anisiya. Aiwawe a'i lowe Owane Sitewi ma'e peri pitase a'i au te'e areareteye. Owane Sitewi lai lu ape mo ma'e fofowei erasi pefine a'i aurowa.” ");
INSERT INTO sny_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Sosu a'i pe Jisas ma'aru pa'are atahe a'i sahe onuteye. Le lu taune, Owane Sitewi ma'e ma'aru towafi lowe lo auwe ape, siyeyei ne onuteye. Lu taune tamo, ma'aru tomu ne'ese iroteye ape, lowe ma'aru tomu ne'ese ma'aru pa'are papu futeye. ");
INSERT INTO sny_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Sosu menitani weiname ta ma'aru pa'are ma'e henerai su, le ma'aru tewi oso oso po'o hesi papu fuwe. Aiwawe a'i ma'aru tau ta'i a'i ne. ");
INSERT INTO sny_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Sosu Jisas lu disaipel lo le ma'e ei aniye. Le lowe ma'e apou eiye, “Ane fene ma'e peri wiyeme a'i au te'esiya. Weiname tani ape, le ma'aru erasi pefine a'i Owane Sitewi ma'e auwe. Lu taune tere'e tere'e werese Owane Sitewi lo nihe se ma'aru oso oso a'i auwe. 2 Ko 8:12 ");
INSERT INTO sny_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Lu taune tere'e tere'e ape mo lowe ma'aru tomu ne'ese irosiya. Serai lowe ma'aru tewi oso po'o Owane Sitewi ma'e auwe. Ahowa, weiname tani ape ma'aru werese werese a'i lo Owane Sitewi ma'e auwe. Ma'aru werese lo po'uteye. Le etiri ta piye ma'aru se eterowata.” ");
INSERT INTO sny_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Sosu a'i pe Jisas lu disaipel lo mase Owane Sitewi lo wesi tutawe nowe ma'e arunati. Lu disaipel lo ta le ma'e eiye, “Atuatu siye Meni Owane, Siyere! Owane Sitewi lo wesi tapiye werese wisere a'i ne. Lowe wesi ape ta'ane wisereyeye.” ");
INSERT INTO sny_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Sosu Jisas le ma'e itiya'u apou eiye, “Ne wesi erasi ape siyere! Nowe me'iye ta su, ai lu tamo lai tapiye ape werese hi ani teroso fiyari arorowa. Tapiye ta'i ta tapiye tere'e hire furowata.” Lu 19:44 ");
INSERT INTO sny_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Sosu a'i pe Jisas lu disaipel lo mase Omo Oliv hire ma'e yaneye. Le awei sahe onuwewe, Owane Sitewi lo wesi tutawe siyeteye. Sosu lu feni tamo Pita, Jems, Jon, sosu Andru, lowe Jisas ma'e eresene a'i apou te'e toweriye. ");
INSERT INTO sny_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Lowe apou te'e toweriye, “Ne nomo ma'e etiri tamo, me'iye heneraiyei ape, nomo ma'e au te'e areiyere! Piye nowe se etiri ape henerairowa awere? Piye yaru nomo siyerowa awere? Serai etiri ape henerairowa.” ");
INSERT INTO sny_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Sosu Jisas lowe ma'e peri ta itiya'u au te'eye. “Fene Weiyai! Lu tamo lai fene ma'e peri wawero au te'e areareyei ne toterowa. Fene peri wawero lowe lo ape owe wanute! ");
INSERT INTO sny_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Lu ne'ese iyape ano se aiyerowawe, apou au te'eyei, ‘Ane a'i lai meni ape tene! Owane Sitewi lai ane fene ma'e eimawesai.’ Peri ape wawero a'i tene! Lowe lu taune tomu ne'ese ma'e au te'e arearerowa. ");
INSERT INTO sny_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Fene ai atuwei lo peri wanurowa. Ai atuwei lo peri heneruwe wanurowa su, fene owe ape atoweiyere! Etiri werese ape, tu henerairowa. Ahowa, nowe ye'ewi ape i'ero henerairowata. ");
INSERT INTO sny_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Omo ta lo ai lu, omo tere'e lo ai lu se ai atu tiyatirowa. Lu tewi ta ai lu tewi tere'e se ai atu tiyatirowa. Auwe erasi omo pani tere'e tere'e werese auseriyerowa. Nowe ape se lau erasi teriterowa. Etiri ape mo tu henerairowa. Menitani ta meni eime auteiyei su, le fofowei erasi teriteyei. Etiri ape mo aiwawe a'i ne. Orese nowe ape tu henerairowa. ");
INSERT INTO sny_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Fene weiyai! Lu tamo fene awei meni owane ma'e etiyei ne henetirowa. Lowe me'iyeni fene lo ma'e wafei se Owane Sitewi lo wesi papu ainerowa. Fene peri ano wanu umasirowa su, lowe fene awei lu owane tamo ma'e au teirowawe, fene lowe ma'e peri ano au te'e areiyerowa. Mt 10:17-20 ");
INSERT INTO sny_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Serai peri werese ano omo omo pani werese au te'e fiyari areiyerowa. ");
INSERT INTO sny_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ai lu tamo fene ereti lowe wafei se ti tawesirowawe, lu owane ma'e henetirowa su, fene owe ape atoweiyere! Nowe ape se fene peri te'e areiyere. Owane Sitewi lai fene ma'e peri lo ape au te'erowa. Fene peri towafi fene lo au te'e ta'ame. Ahowa, Owane Sitewi lo Hepene Wara'i a'i lai peri ape lowe ma'e au te'e areiyerowa. Lu 12:11-12 ");
INSERT INTO sny_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Meni ta pa'ise lo etiyei ne henetirowawe, aine tera'eyei ne toterowa. Meni ta meni eime topo lo ape aine tera'eyei ne henetirowa. Meni eime ta lai aite mai topo lo ma'e ai atu tiyatirowawe, sosu aine tera'eyei ne henetirowa. Mt 10:21 ");
INSERT INTO sny_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Iyape ano fene sahe irorowa su, lu werese fene ma'e ai marepi luwaru totenamirowa. Ahowa, fene iyape ano se tei kairefiyerowa su, nowe ye'ewi se fene marepi hepene he'i a'i ironamirowa. Mt 10:22; Jo 15:21 ");
INSERT INTO sny_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Wanure! Fene, peri ape siye te'eyei ape, Weiyai! Fene peri ano siye so'oruwere” Sosu Jisas lowe ma'e au te'e areiyeye, “Fene etiri luwaru a'i, Owane Sitewi lo wesi tutawe papu au teirowa ape, siyerowa su, lu taune werese, omo pani Judia irorowa ape, omo hire ma'e fareyareyei ne iteroti. Etiri luwaru a'i ape lai Owane Sitewi lo wesi tutawe ne au te'e naruwei ne au irowe. Dan 9:27; 11:31; 12:11 ");
INSERT INTO sny_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nowe ape se lu taune tamo wesi hire sahe irorowa ape, lowe wesi papu etiri tamo si aniyei ne wirowata. Lu 17:31 ");
INSERT INTO sny_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Aiwawe a'i lu taune tamo ta'aneyei awei ma'e, ta'aneyei ape mo, lowe wesi towafi lowe lo ma'e etiri aniyei ne si irowata. ");
INSERT INTO sny_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ahowa, taune eime tahe se, sosu taune, eimane towafi lowe lo mo'u au arowa ape, lowe weiyai! Lowe fofowei erasi teriterowa. Lu 23:29 ");
INSERT INTO sny_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Sosu fene Owane Sitewi ma'e te'e towerite, ‘Nowe ape se nowe naretei a'i owe ape heneraite.’ ");
INSERT INTO sny_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Nowe ape se etiri orese a'i omo pani werese napeturowa. Etiri orese a'i ape eito eite, tu naifa weriyei Owane Sitewi lai etiri werese ta'aneye ape, lu taune werese siye ta'ame. Nowe pereye eite se lu taune werese etiri orese a'i eito eite ape siye ta'ame. Aiwawe a'i nowe me'iye su etiri orese a'i ape eito eite lu taune werese siyerowata. Dan 12:1; KTH 7:14 ");
INSERT INTO sny_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Sosu aiwawe nowe orese a'i ape se, Meni Owane Pefine a'i lai nowe te'e oso a'i ariariye ta'ame su, lu taune werese temeniyerowa. Ahowa, lu taune werese, Owane Sitewi lai ariariyeye ape, lowe Owane Sitewi lo yo umasinamirowa su, le nowe orese a'i ape te'e oso a'i ariariyerowa. ");
INSERT INTO sny_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Sosu meni ta lai fene ma'e apou eiyei su, ‘Siyere! Meni ape Owane Sitewi lai hi awei ma'e eimawe arosai ape, irosiya. Aiwawe a'i siyere! Meni ape yaro ma'e irosiya ape, meni ape, Owane Sitewi lai awei hi ma'e eimawe arosai ape, irosiya.’ Wanure! Peri ape wawero a'i tene! Fene peri ape owe ape wanu umasite! ");
INSERT INTO sny_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Lu tamo apou eiyei su, ‘Ane meni ape, Owane Sitewi lai lu taune ma'e hi awei ma'e eimawe arosai.’ Peri wawero! Lu tere'e tamo apou eiyei su, ‘Owane Sitewi lai ane etiri tamo nowe me'iye su henerairowa ape, au te'e fiyariyei ne ariariyeye.’ Peri ape wawero a'i tene! Lowe lu taune iyape towafi lowe lo se u tahe se au ta'ane fara'uwerowa. Serai lowe Owane Sitewi lo lu feni yo luwaru a'i ma'e henetirowa.” KTH 13:13 ");
INSERT INTO sny_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Sosu Jisas apou eiye, “Fene weiyai! Wanure! Ane fene ma'e etiri werese, me'iye heneraiyei ape, au te'e areiyesiya.” ");
INSERT INTO sny_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Sosu a'i pe Jisas apou au te'eye, “Nowe orese fofowei luwaru erasi a'i ape po'uterowa su, nowe ape se poweiye mi pasi wou henerairowa. Yame lo mi tewi mitaiyerowata. ");
INSERT INTO sny_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Eiwariyemi tamo ni'arawe arunatirowawe, hi awei ma'e winetairowa. Etiri werese, ni'arawe sahe irosiya ape, lowe auseriyerowa. ");
INSERT INTO sny_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Nowe ape se lu taune werese, Owane Sitewi lo meni eime ni'arawe papu irosiya ape, kairefiyeyei erasi aiwawe a'i mitaiyeyei erasi mase itorairowa ape, siyerowa. KTH 1:7 ");
INSERT INTO sny_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Le itorairowa su, le Owane Sitewi lo ipari wisere a'i (ensel) omo omo werese eimawe fiyarisawirowa. Lowe lu taune werese, Owane Sitewi lo yo peri wanu umasisiya ape, hene ta'uwe anirowa. Lu taune werese omo omo eyeri ma'e hene ta'uwe anirowa. Lowe lu taune, ni'arawe sahe irosiya ape, eyeri ma'e aiwawe a'i hene ta'uwe anirowa.” Mt 13:41; Mk 13:32 ");
INSERT INTO sny_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Sosu a'i pe Jisas peri anowe ta au te'eye. Le apou eiye, “Fene peri anowe ape wanure! Fene me owarape aiwawe a'i totere! Fene me owarape towe so'oruwe heneye su, fene apou totere. Nowe lo me so ta'eyei henerairowa. ");
INSERT INTO sny_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Sosu aiwawe a'i fene etiri orese a'i, nowe me'iye su henerairowa ape, siyeyei su, fene apou fa totere. Nowe ape se Owane Sitewi lo meni eime heneraiyei, ataheyewa. Yo tewiye sahe tei ataheyeraiwa. ");
INSERT INTO sny_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ane fene ma'e peri wiyeme a'i te'esiya. Wanure! Lu taune tamo, pereye nowe eite se irosiya ape, lowe temeniyeyei ta'ama. Ahowa, lowe etiri ape mo heneraiyei siyerowa. ");
INSERT INTO sny_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Etiri werese, ni'arawe hire ma'e irosiya ape, sosu etiri werese, hi awei ma'e irosiya ape, lowe werese po'uterowa. Ahowa, peri wiyeme a'i ano weriyei weriyei ironamitorowa. ");
INSERT INTO sny_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Eiwerou su etiri werese ape henerairowa awere? Lu taune werese so'oru ta'ama. Aiwawe a'i Owane Sitewi lo ipari wisere a'i (ensel), lowe nowe ape so'oru ta'ama. Owane Sitewi lo meni eime aiwawe a'i, nowe ape so'oru ta'ama. Owane Sitewi ta'i a'i lai nowe ape so'oruwesiya tene! ");
INSERT INTO sny_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Serai ane fene ma'e au te'esiya. Fene weiyai! Ane si tame itorairowa. Serai fene tote etite. Fene werese nowe ape so'oru ta'ama. ");
INSERT INTO sny_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ape peri anowe ta wou a'i ne. Meni ta omo pani eyeri ma'e iyei ne totesiya. Le wiyawi meni yahowa'i werese ei aniye. Le lowe ma'e apou eiye, ‘Ane omo pani eyeri ma'e iyei ne. Fene etiri werese ano au noweinoweite.’ Sosu le meni wesi yo au noweinoweisiya ape ma'e apou eiye, ‘Ne wesi yo ano siye etite.’” ");
INSERT INTO sny_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Sosu le lowe werese ma'e eiye, “Serai ane fene ma'e aiwawe a'i au te'esiya. Fene etiri werese siye etite! Meni Owane fene lo si tame aiyerowa su, fene nowe tewi a'i ape so'oru ta'ama. Le nowe neriwei su aiyerowa awere? Nowe pasi po su aiyerowa awere? Nowe mitaiyeye su aiyerowa awere? Nowe esi a'i su aiyerowa awere? Lu 12:38 ");
INSERT INTO sny_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Meni Owane fene lo aiyerowa su, le fene nihe howeiteyei siyerairowa awere? Le fene howeiteyei, siyeyei su, le fene ma'e fofowei orese erasi a'i aurowa.” ");
INSERT INTO sny_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Sosu Jisas lu disaipel lo ma'e apou eiye, “Peri werese ape, ane fene ma'e eisiya ape, ane lu taune werese ma'e eisiya. Weiyai! Fene etiri werese siye etite!” ");
INSERT INTO sny_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Sosu a'i pe Juda lo ta'uwe hereiyei hesi a'i ataheyeye. Poweiye hesi a'i i tepa'asiye su, ta'uwe hereiyei iyape Pasova, sosu ta'uwe hereiyei tere'e nau ta'ase ene ayei. Au heseyei lu owane tamo, sosu Owane Sitewi lo peri so'oruwe siye lu tamo, lowe Jisas eresene a'i ereti wafei se ti tawesiyei ne toteye. Lowe le aine tera'eyei ne toteye. ");
INSERT INTO sny_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Lowe apou toteye, “Nowe ta'uwe hereiyei se, nomo Jisas ereti lowe ti tawesiyei su, lu taune werese nomo ma'e ai marepi toteyei. Lowe nomo ma'e ai marepi toteteyei su, lowe nomo ma'e au luwaruweyei. Serai nomo Jisas eresene a'i ereti ti tawesirowawe, sosu aine tera'erowa.” ");
INSERT INTO sny_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Sosu a'i pe Jisas lu disaipel lo mase omo Betani sahe onuteye. Meni ta iyape Saimon tu naifa Jisas enite kairefi a'i, iyape lepra, au ta'ane niyemaiyeye. Jisas lu disaipel lo mase Saimon lo wesi sahe onuteye. Lowe metei sahe ene aye su, menitani ta wesi ape papu wiye. Le sa'i heneri wisere a'i ape tapiye pa'are papu aitai. Sa'i heneri ape ma'aru tomu ne'ese se eteye. Menitani ape tapiye pa'are aine towesiyewe, sa'i werese Jisas lo mato hire ma'e ani teroso arowe. Lu 7:37-38 ");
INSERT INTO sny_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Lu tamo menitani ape siyeye su, lowe le ne ai marepi a'i te'e tiyatiye. Lowe apou te'eye, “Menitani ape piyene sa'i heneri a'i ape ani terososawi awere? ");
INSERT INTO sny_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Nomo sa'i ape meni ta ma'e au eteyei su, nomo ma'aru tomu ne'ese anirowawe, lu taune ma'e, ma'aru ariye ape, aurowa. Lowe menitani ape ne ai peri te'e tiyatiteye.” ");
INSERT INTO sny_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ahowa, Jisas lowe ma'e apou eiye, “Fene menitani ape ma'e ai marepi owe ape totere! Fene piyene le ma'e au luwaruweyei ne totesiya awere? Menitani ape ane ma'e wiyawi wisere a'i au ta'aneye. ");
INSERT INTO sny_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Fene lu taune, ma'aru ariye a'i ape, mi mi weriyei totenamisiya. Fene lowe ferafereiyei ne toteyei su, fene fara'u ma'aru tamo aure. Ahowa, ane fene mase nowe oso a'i irorowa. Ane fene mase weriyei iro ta'ame. Lo 15:11 ");
INSERT INTO sny_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Menitani ape ane ma'e etiri wisere a'i au ta'aneye. Le temeniyeyei ano totesiya. Serai le sa'i heneri wisere a'i tahe pa'are ano sahe ani teroso arowe. Me'iye su, ane fisiye yo ma'e funarirowa. Jo 19:40 ");
INSERT INTO sny_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ane fene ma'e peri pefine a'i au te'esiya. Omo omo werese sahe peri ano au te'e fiyariyei su, lu taune werese, menitani ape lo etiri irowe ape, te'enamirowa. Sosu lowe menitani ape ne marepi papu lowe lo wanu tote tawesinamirowa.” ");
INSERT INTO sny_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Sosu a'i pe Jisas lo lu disaipel ta iyape Judas Iskariot au heseyei lu owane tamo ma'e fi. Le Jisas au heseyei lu owane lo ereti se henetiyei ne toteye. ");
INSERT INTO sny_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Au heseyei lu owane Judas lo peri ape wanuwe su, lowe marepi nine'i erasi a'i toteye. Lowe ma'aru tamo le ma'e auwei ne te'e naneiye. Serai Judas lai Jisas lowe ma'e henetiyei ne toteye. Le lowe ma'e eiye, “Ane yo ta fene ma'e le henetiyei ne nehirowa.” ");
INSERT INTO sny_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Sosu a'i pe ta'uwe hereiyei nowe tutawe, iyape Pasova, henerai su, Juda lo lu fe sipsip tamo aine tera'eyei ne toteyewe, Owane Sitewi ma'e aurowa. Nowe ape se Jisas lo lu disaipel le ma'e apou eiye, “Ne eiwerou totesiya awere? Nomo eiwerou ma'e ene ayei etiri ta'uweyei awere? Sosu ne ta'uwe hereiyei ape arowa.” Kis 12:6 ");
INSERT INTO sny_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Sosu Jisas lu feni hesi a'i lo ei aniye. Le lowesi ma'e eiye, “Fenesi omo weniyei ma'e ire. Fenesi meni ta sa'i pa'are erasi iyo'o hire suteyei, siyere! Fenesi meni ape mo'o umasitire. ");
INSERT INTO sny_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Meni ape wesi papu wirowa su, fenesi wesi ape se meni topo ma'e apou te'e towerire! ‘Atuatu siye meni owane le ma'e ei toweriye. Tewi wesi ape eiwerou, irosiya awere? Serai ane lu feni ano mase ta'uwe hereiyei ape ene ayei ne.’ ");
INSERT INTO sny_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Sosu wesi se meni topo tewi wesi erasi, hire ma'e irosiya ape, fenesi ma'e atuaturowa. Etiri werese ta'uwe tepa'asiye. Tewi wesi ape sahe fenesi ta'uwe hereiyei ene ayei ape au ta'uwere! Serai nomo tewi wesi ape papu ene arowa.” ");
INSERT INTO sny_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Lu disaipel lo hesi ape arunatiyewe, omo weniyei ape ma'e heneri. Peri werese, Jisas au te'eye ape, lowesi siye tepa'asiye. Serai lowesi tewi wesi ape wiyewe, ta'uwe hereiyei lo ene ayei au fu ta'uwe naneiye. ");
INSERT INTO sny_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nowe neriwei su, Jisas lu disaipel lo mase tewi wesi ma'e ta'uweyei ne fai. ");
INSERT INTO sny_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Sosu Jisas lu feni werese lo mase metei sahe ene ayei ne onuwe su, Jisas lowe ma'e eiye, “Ane peri pefine a'i fene ma'e eisiya. Wanure! Meni ta, nomo ponei sato onusiya ape, ereti ano wafei se ti tawesirowawe, au heseyei lu owane ma'e henetirowa. Meni ape nomo ponei sato ene asiya.” Sng 41:9 ");
INSERT INTO sny_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Lu feni werese lo peri ape wanuwe su, lowe marepi hepene orese a'i teriteye lowe ta'i ta'i a'i le ma'e te'e toweriteye, “Ne ane ne te'esiya awere?” ");
INSERT INTO sny_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Sosu Jisas lowe ma'e itiya'u eiye, “Meni ape lu feni ano, meni ta lai nau ta'ase wahu papu ane aiwawe a'i furowawe, sosu arowa. ");
INSERT INTO sny_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Owane Sitewi lo meni eime temeniyerowa. Owane Sitewi lo one towe sahe tu naifa apou te'eye, ‘Meni ape Owane Sitewi lai, hi awei ma'e eimawe arosairowa ape, temeniyerowa.’ Ahowa, meni ape Owane Sitewi lo meni eime ai lu owane tamo ma'e ereti ti tawesirowawe, aine tera'eyei ne henetirowa su, meni ape weiyai! Mai lo autei ta'ame su, meni ape ane ma'e au luwaruwe irorowata. Serai wisere a'i ne. Ahowa, mai lo meni ape autei tepa'asiye su, Owane Sitewi lai le ma'e etiri luwaru a'i au irorowa.” ");
INSERT INTO sny_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Sosu a'i pe lowe ta'uwe hereiyei ape ene aye su, Jisas nau ta'ase ereti se aniteyewe, Owane Sitewi ma'e te'e wisereyeye. Sosu le nau ta'ase tewi pa tewi ani topoto noneye. Sosu le lowe ma'e apou eiye, “Fene nau ta'ase anire! Nau ta'ase ape tahe pa'are ano ne.” ");
INSERT INTO sny_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Sosu aiwawe a'i le siye auwe ereti se aniteyewe, Owane Sitewi ma'e ei wisereyeye. Sosu lowe ma'e auwe. Sosu lowe werese sa'i ape ene aye. ");
INSERT INTO sny_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Sosu le lowe ma'e eiye, “Sa'i ape fisa'i ano ne. Ane fisa'i ano lu taune ne au ani terosorowa. Ane lowe ma'e peri te'e naneiyei he'i a'i ano au ferafereiyei ne aurowa. Kis 24:8; Sek 9:11; Jer 31:31-34; 1 Ko 10:16; Hi 9:20 ");
INSERT INTO sny_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ane fene ma'e peri wiyeme a'i au te'esiya. Wanure! Ane wain sa'i tere'e tame arowata. Ane Owane Sitewi lo kairefiyeyei mase si tame itorairowawe, lu taune werese au noweinoweirowa su, ane fara'u wain sa'i he'i aurowa.” ");
INSERT INTO sny_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Sosu a'i pe lowe ene a tepa'asiye su, lowe Owane Sitewi lo iyape se yakowei ahi te'e ani aroweteye. Sosu lowe tewi wesi nowe ma'e arunatiyewe, Omo Oliv ma'e yaneye. ");
INSERT INTO sny_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Sosu Jisas lu disaipel lo ma'e apou eiye, “Tote tawesiyei fene lo tote i'ane po'uterowa. Tu naifa Owane Sitewi lo one towe sahe apou te'esiya. ‘Ane fe sipsip noweinowei siye meni aine tera'erowawe, sosu fe sipsip werese lo atoweiye itero fiyari howeirowa.’ ");
INSERT INTO sny_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ahowa, ane si tame norohuwe sineyei su, ane omo pani Galili ma'e tu irowa.” Mt 28:16; Mk 16:7 ");
INSERT INTO sny_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ahowa, Pita le ma'e apou eiye, “Lu tere'e tamo tote tawesiyei lowe lo tote i'aneyei su, ane lai ne ne tote i'anerowata.” ");
INSERT INTO sny_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Sosu Jisas le ma'e itiya'u eiye, “Ane ne ma'e peri wiyeme a'i te'esiya. Pereye pasi eite ne nowe hesi heta ane ne me'iyeni ma'e atati arunatirowa. Me'iye su, irowe kakaruk peri hesi a'i uterowa.” ");
INSERT INTO sny_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ahowa, Pita peri erasi a'i tame eiye, “Ane ne ne mase temeniyerowa. Ane ne me'iyeni ma'e atati arunatirowata.” Jisas lo lu disaipel werese peri ape aiwawe wou a'i te'eye. Jo 11:16 ");
INSERT INTO sny_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Sosu a'i pe Jisas lu disaipel lo mase ta'aneyei awei ma'e iyape Getsemani, heneri. Sosu Jisas lowe ma'e eiye, “Fene sato onure. Ane yaro ahe Owane Sitewi ma'e au te'erowa.” Jo 18:1 ");
INSERT INTO sny_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Sosu le lu hesi heta, Pita, Jems, Jon ei aniye. “Fene ane aiwawe iyei.” Lowe yaro ahe fi su, Jisas marepi orese a'i teriteteye. ");
INSERT INTO sny_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Sosu le lowe ma'e eiye, “Hepene ano orese a'i ironamisiya. Ane temeniye ataheyewa. Fene sato irote. Fene etiri werese siye etite.” Jo 12:27 ");
INSERT INTO sny_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Sosu le eyeri oso po'o ma'e fi. Le awei sahe winetaiyewe, Owane Sitewi ma'e au te'e tiyatiteye. Le apou eiye, “Ne yo tere'e irosiya su, ane yo eite feni se awera'iyenatirowa. Serai ane nowe luwaru a'i ape se awera'iyenatirowa.” ");
INSERT INTO sny_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Le apou ei toweriye, “Tai ano, etiri werese eite ne, ne fara'u irorowa. Serai ane ne ma'e apou tame ei towerisiya. Ne fara'u wiyawi no ane auwe eite, ani sasarire! Ahowa, ane marepi ano umasirowata. Ane marepi no a'i tote umasinamirowa.” Mk 10:38; Jo 6:38 ");
INSERT INTO sny_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Jisas peri tepa'asiye su, le lu feni hesi heta ma'e si tame fi. Le lowe nihe teiteyei siyeri. Le Pita ma'e apou ei toweriye, “Saimon, ne nihe howeisiya awere? Ne nowe tewi ta piyene etiri werese ape ne siye eti se ta'ama awere? ");
INSERT INTO sny_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Fene etiri werese luwaru ape ne siye etinamite. Sosu fene Owane Sitewi ma'e te'e towerite! Serai fene yo seni luwaru a'i ta fene ma'e henerairowata. Hepene fene lo kairefi a'i ne, Ahowa, tahe fene lo pere'e a'i ne.” ");
INSERT INTO sny_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Sosu le lowe arunatiyewe, yaru tewi ta sahe fiyewe, Owane Sitewi ma'e au te'e tiyatiteye. Le peri tu Owane Sitewi ma'e te'eteye ape, le peri aiwawe a'i te'eye. ");
INSERT INTO sny_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Le Owane Sitewi ma'e peri te'e tepa'asiye su, le lu feni hesi heta si tame siyeri. Lowe nihe teiteyei tame siyeri. Nihe lowe lo orese a'i ne. Lowe neritase teriteye. Serai lowe le ma'e peri se ta'ama. ");
INSERT INTO sny_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Sosu le yaru tewi ta sahe si tame fi, Owane Sitewi ma'e peri aiwawe a'i au te'e tepa'asiye su, le lu disaipel lo ma'e si tame fai. Sosu le lowe ma'e eiye, “Fene nihe teinamiteye awere? Tahe fene lo onota'ano a'i awere? Fara'u. Nowe ano henerai tepa'asiye. Siyere! Meni ape Owane Sitewi lo meni eime ereti wafei se ti tawesiyei ne fai. Le ane lu luwaru a'i ma'e henetirowa. ");
INSERT INTO sny_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Sinere! Nomo iyei ne. Siyere! Meni ape ane lu luwaru a'i ma'e henetiyei ne ataheyewa.” ");
INSERT INTO sny_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Sosu Jisas peri ape te'eye su, meni Judas, Jisas lo lu disaipel ta, le ma'e henerai. Le ai lu tomu ne'ese mase fai. Lowe mene'e, me au tamo Jisas ma'e aitai. Au heseyei lu owane, sosu Owane Sitewi lo peri so'oruwe siye lu tamo, lowe ai lu werese Jisas ma'e ereti wafei se ti tawesiyei ne eimawesai. ");
INSERT INTO sny_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Sosu Judas ai lu owane ma'e apou eiye, “Ane meni ape, Jisas, lo ahi si ma'e ahi tahe se te'e wisereyeyei. Ane meni ape ariariyeyei su, fene ereti wafei se ti tawesire! Ereti wafei se ti tawesiyei su, fene au heseyei lu owane ma'e henetire!” ");
INSERT INTO sny_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Sosu Judas Jisas ma'e henerai su, le Jisas apou eiye, “Meni Owane Pefine.” Sosu le Jisas lo ahi si ma'e ahi tahe lo se te'e ani ime wisereyeye. ");
INSERT INTO sny_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ai lu werese Judas lo yaru siyeye su, lowe Jisas lo ereti wafei se ti tawesiye. ");
INSERT INTO sny_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Sosu meni ta Jisas mase teiteye su, le ipari mene'e pite a'i ereti lo se aniteyewe, wiyawi yahowa'i a'i meni lo apaniye aine tou la'eye. Wiyawi yahowa'i meni ape Owane Sitewi lo wesi au heseyei lo meni owane erasi lo ne. ");
INSERT INTO sny_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Sosu Jisas lowe ma'e itiya'u eiye, “Fene ipari mene'e, me au se ane ma'e ereti wafei se ti tawesiyei ne heneti awere? Ane ta'arei meni wou a'i awere? ");
INSERT INTO sny_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Mi mi werese ane Owane Sitewi lo wesi tutawe sahe Owane Sitewi lo peri au te'e areiyeye su, ane fene mase iroteye. Ahowa, fene ereti ano wafei se ti tawesirowata. Tu naifa weriyei Owane Sitewi lo one towe sahe peri ape au te'e areiyeye. Pereye, peri ape wiyeme a'i henerai tepa'asiye.” Lu 19:47; 21:37; Jo 18:20 ");
INSERT INTO sny_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Jisas lo lu disaipel werese le a'i arunatiyewe, atoweiye iteroti. ");
INSERT INTO sny_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Yo'orei meni ta Jisas mo'o umasiti ape, le watipi sahe ipari tahe wapo a'i ani asiteye. Sosu ai lu tamo meni ape ereti aniteye. ");
INSERT INTO sny_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ahowa, meni ape ipari tahe erau fu arowe, liye pa'are ariye a'i iteroti. ");
INSERT INTO sny_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Sosu lowe aniteyewe Jisas au heseyei meni owane ma'e, heneti. Au heseyei lu owane tamo, ya'ariyei lu owane tamo, sosu Owane Sitewi lo peri siye so'oruwe erasi siye lu tamo wesi erasi ape sahe ta'uwerai. ");
INSERT INTO sny_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Lowe Jisas heneti su, Pita eyeri ma'e Jisas mo'o umasiti. Le au heseyei meni owane lo wesi nepawe papu wiye. Wesi nepawe ape papu ai lu tamo mase yehe atahe sahe umerisiyeyei ne onuteye. ");
INSERT INTO sny_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Sosu au heseyei lu owane tamo, awei lu owane tamo, lowe lu tamo ei aniye. Jisas lo yo seni iroteye ape, fu te'e areiyeye ne. Piye yo seni luwaru a'i ta Jisas iroteye awere? Ahowa, lowe Jisas lo yo seni luwaru a'i ta wanu ta'ame. Lowe Jisas aine tera'erowata. ");
INSERT INTO sny_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Lu tomu ne'ese peri wawero le ne fu te'eye. Peri towafi lowe lo marepi ta'i a'i se aiwawe ta'ame. ");
INSERT INTO sny_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Lu tamo sineteyewe, lowe peri wawero Jisas ne fu te'eye, Lowe apou eiye, ");
INSERT INTO sny_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Nomo le peri ape te'eye ape, wanuwe, Owane Sitewi lo wesi tutawe ape tu lu lai ta'aneye ape, ane lai aine tapeti po'uterowa. Sosu ane lai poweiye hesi heta Owane Sitewi lo wesi he'i a'i ta'anerowa. Ane ereti ano se au ta'anerowata.” Jo 2:19-21 ");
INSERT INTO sny_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Peri lowe lo peri wawero a'i tene! Lowe werese peri aiwawe a'i ta'ama. ");
INSERT INTO sny_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Sosu au heseyei meni owane sineteyewe, Jisas ma'e teiteye. Le Jisas ma'e apou ei toweriye, “Peri ape lu ne ne fu te'e areiyeye ape, ne piyene peri ta itiya'u te'eyei ta'ama awere?” ");
INSERT INTO sny_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ahowa, Jisas peri mo'uwei a'i irowe. Le peri itiya'u ei ta'ame. Sosu au heseyei meni owane ape le ma'e si tame ei toweriye, “Ne meni ape Owane Sitewi lai hi awei ma'e lu taune au ferafereiyei ne eimawesai awere? Ne Owane Sitewi Pefine a'i lo meni eime awere? Piyete awere?” ");
INSERT INTO sny_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Sosu Jisas le ma'e apou eiye, “Ane a'i lai tene! Nowe me'iye su, fene Owane Sitewi lo meni eime Owane Sitewi lo kairefiyeyei pefine a'i lo ereti eyate feni se onunamitorowa. Aiwawe a'i fene, ane ni'arawe ma'e itoraiyei ape, siye anirowa.” ");
INSERT INTO sny_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Au heseyei meni owane peri ape wanuwe su, le ipari tahe lo ani apeti tepetowe. Sosu eiye, “Wanure! Nomo lu tere'e tamo ei anirowata. ");
INSERT INTO sny_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Fene peri lo wanu tepa'asiye. Le Owane Sitewi Pefine a'i te'e naruwe. Fene eiwerou totesiya awere?” Lu werese lai peri ta'i a'i uteye, “Meni ape fa temeniyere!” Wkp 24:16; Jo 19:7 ");
INSERT INTO sny_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Lu tamo lai Jisas ma'e pisa'i sine'iye. Lowe ipari tahe se nihari lo ti tawesiyewe, sosu lowe le ma'e ereti ani amo'owe, sosu ereti se aineye. Lowe le aineye su, lowe le ma'e te'e toweriye, “Ne nomo ma'e peri pefine au te'ere! Eiwerai nihari no aineye awere?” Ai lu owane lai le ma'e nihari lo sahe aineteye. ");
INSERT INTO sny_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Sosu a'i pe Pita wesi nepawe hi ma'e onuteye. Wiyawi yahowa'i menitani ta wesi nepawe ma'e fai. Menitani ape au heseyei meni owane lo ne. ");
INSERT INTO sny_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Menitani wesi nepawe ma'e fai su, le Pita yehe sahe tahe onu umerisiyeteye. Le apou ei toweriye, “Ne lai Jisas, omo Nasaret ma'e fai ape, aiwawe a'i iroteye.” ");
INSERT INTO sny_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ahowa, Pita itiya'u eiye, “Wawero a'i ne! Peri ape, ne eiye ape, ane so'oru ta'ama.” Sosu le wesi nepawe nowe ma'e fi. Sosu irowe kakaruk peri uteye. ");
INSERT INTO sny_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Nowe ma'e hene fi su, wiyawi menitani ape Pita tame siyeye. Le lu tamo ma'e apou eiye, “Wanure! Meni ape Jisas lo lu disaipel tene!” ");
INSERT INTO sny_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pita itiya'u eiye, “Ahowa, ane meni ape so'oru ta'ama.” Nowe me'iye oso a'i lu tamo Pita atahe a'i teiteye ape, lowe ma'e eiye, “Peri pefine, ne lai meni ape lo lu feni tene! Ne omo pani Galili aiwawe a'i fai. Peri no aiwawe a'i ne.” ");
INSERT INTO sny_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ahowa, Pita lowe ma'e peri luwaru a'i au te'eye, sosu eiye, “Meni ape fene au te'esiya ape, ane le ne so'oru ta'ama.” ");
INSERT INTO sny_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Pita apou eiye su, witane a'i irowe kakaruk peri me'iye to'uresi tame uteye. Sosu Pita irowe kakaruk lo peri wanuwe su, le Jisas lo peri ape ne tame tote ewiteye. Tu Jisas le ma'e eiye, “Ne irowe kakaruk peri hesi uteyei wanuwei su, ne nowe hesi heta ane ne me'iyeni ma'e atati arurowa.” Sosu Pita luwei erasi a'i irowe. ");
INSERT INTO sny_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Esi pasi a'i su au heseyei lu owane, ya'ariyei lu owane tamo, sosu Owane Sitewi lo yo peri so'oruwe siye lu tamo, lu owane tere'e lowe wesi erasi ape sahe ta'uwerai. “Etiri lowe irowei ape, tote te'e eti tiyatiye. Nomo eiwerou irowei awere?” Sosu lowe Jisas lo ereti wafei se ti tawesiyewe, awei meni owane, iyape Pailat, ma'e eimawesawi. Lu 22:66 ");
INSERT INTO sny_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Sosu Pailat Jisas ma'e apou ei toweriye, “Ne Juda lo meni owane tutawe a'i awere?” Jisas le ma'e itiya'u eiye, “Ne peri pefine a'i te'eye.” ");
INSERT INTO sny_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Sosu au heseyei lu owane tamo lowe Jisas peri wawero au te'e areareye. ");
INSERT INTO sny_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Sosu Pailat le ma'e eiye, “Ne peri ape wanu ta'ame awere? Ne peri ta lowe ma'e itiya'u au te'e ta'ame awere? Lowe ne ma'e peri tomu ne'ese fu te'esiya. Ne peri lowe lo wanu ta'ame awere?” ");
INSERT INTO sny_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ahowa, Jisas peri ta lowe ma'e itiya'u ei ta'ame. Serai Pailat peri ape ne hepene se su'ariye. Ais 53:7; Mk 14:61 ");
INSERT INTO sny_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Sosu a'i pe Pailat marepi erasi a'i toteteye. Nowe ta'uwe hereiyei henerai su, meni Pailat meni ta'i, kalabus wesi sahe iroteye ape, erau arosawirowa. ");
INSERT INTO sny_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Meni ta iyape Barabas kalabus wesi sahe iroteye. Meni ape lu tewi lo mase awei lu owane ma'e ai atu tiyatiteye. Serai ai lu tamo meni ape kalabus wesi sahe hene fu arowe. Meni ape lai lu tere'e tamo aine tera'eye. ");
INSERT INTO sny_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Sosu lu taune tomu ne'ese Pailat ma'e meni ta te'e toweriyei ne fi. Lowe le ma'e apou te'e toweriye, “Iyu menei werese werese ne meni ta, kalabus wesi iroteye ape, ani erau arosaire.” ");
INSERT INTO sny_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Sosu Pailat lowe ma'e itiya'u eiye, “Ane Juda lo meni owane tutawe a'i fara'u ani erau arosairowa awere?” ");
INSERT INTO sny_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Au heseyei lu owane tamo Jisas meni Pailat ma'e heneti su, lowe lo ai marepi luwaru a'i Jisas ma'e totenamiteye. Serai Pailat lu taune werese ma'e ei toweriye, “Ane fara'u Jisas ani erau arosairowa awere?” ");
INSERT INTO sny_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ahowa, au heseyei lu owane lu taune werese ma'e ai marepi te'e tataiteye. Serai lu taune werese Pailat ma'e apou uteye. “Ne meni Barabas ani erau arosaire!” Ap 3:13-14 ");
INSERT INTO sny_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Sosu Pailat lowe ma'e itiya'u eiye, “Sosu ane meni Jisas ne eiwerou irowei awere? Le lai Juda lo meni owane tutawe a'i tene!” ");
INSERT INTO sny_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Sosu lowe le ma'e itiya'u uteye, “Meni eite me tape'i ape sahe aine tera'ere!” ");
INSERT INTO sny_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ahowa, Pailat lowe ma'e itiya'u ei toweriye, “Piyene awere? Le piye yo seni luwaru a'i irowe awere?” Ahowa, lu taune werese peri erasi a'i tame hare uteye, “Me tape'i ape sahe aine tera'ere!” ");
INSERT INTO sny_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Sosu Pailat lu taune ma'e marepi wisereyeyei ne toteye. Serai le meni Barabas kalabus wesi sahe ani erau arosai. Barabas kalabus wesi ani erau arosawi su, Pailat ai lu tamo ma'e eiye, “Fene Jisas henetirowawe, me'iyeni lo ma'e wafei se ainere!” Jisas lo me'iyeni ma'e aineye su, le ai lu ma'e me tape'i sahe aine tera'eyei ne heneti. ");
INSERT INTO sny_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Sosu a'i pe ai lu tamo Jisas wesi erasi ma'e heneti. Sosu lowe ai lu werese wesi papu ei aniye. ");
INSERT INTO sny_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Lowe Jisas lo ipari tahe ani erauwe. Sosu ipari tahe lo'u a'i le ma'e au ani asiye. Lowe wafei tohu ni'ari ape se ani ape'iye ta'aneyewe, Jisas lo mato sahe ti atati asi arowe. ");
INSERT INTO sny_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Sosu lowe peri erasi apou eiye, “Ei, Jisas, ne Juda lo meni owane tutawe a'i tene!” ");
INSERT INTO sny_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Sosu lowe Jisas lo mato sahe menei meni patiye se aineteye. Lowe Jisas ma'e sine'i te'e naruwe. Lowe le ma'e lowe uporo ape'i onu areareteye. ");
INSERT INTO sny_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Sosu lowe Jisas peri te'e naru tepa'asiye su, lowe ipari tahe lo'u a'i ani erauwewe, ipari tahe lo si tame au ani asiye. Sosu lowe le omo Jerusalem nowe ma'e me tape'i sahe aine tera'e tawesiyei ne heneti. ");
INSERT INTO sny_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Sosu a'i pe lowe omo nowe ma'e fi su, lowe meni ta iyape Saimon ereti aniteye. Meni ape omo Sairini ma'e fai. Meni ape Aleksander, sosu Rufus lo aite. Lowe Saimon apou eiye, “Ne Jisas lo me tape'i omo hire ma'e sutetire!” Ro 16:13 ");
INSERT INTO sny_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Sosu a'i pe lowe Jisas Omo Golgota ma'e heneti. Golgota lo iyape sitewi apou wou a'i “Mato Pa'are lo Omo”. ");
INSERT INTO sny_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Sosu lowe Jisas ma'e wain sa'i ta au ayei ne toteye. Ahowa, Jisas a ta'ame. ");
INSERT INTO sny_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Sosu lowe Jisas me tape'i sahe ni'ari se aine tawereyewe, hire ma'e au ani sineteye. Ipari tahe lo ape aniye ape, lowe tapiye oso ani fu arosawi. Eiwerai ipari tahe aniyei awere? Sng 22:18 ");
INSERT INTO sny_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Lowe me tape'i hire ma'e au ani sineteye su, nowe ape esi ponei a'i. ");
INSERT INTO sny_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Lowe etiye lo peri ta metei sahe apou leseye. Lowe apou leseye, ");
INSERT INTO sny_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Lowe ta'arei lu hesi ta Jisas mase aiwawe a'i me tape'i sahe aine tera'e tawesiteye. Meni ta eyate feni ma'e me tape'i se aine tawereteye. Meni ta opi feni se aine tawereye. ");
INSERT INTO sny_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","{Sosu Owane Sitewi lo one towe sahe pefine a'i henerai. Apou a'i leseye, ");
INSERT INTO sny_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Lu taune tamo Jisas lo me tape'i awera'iyenati ape, lowe Jisas ma'e peri luwaru a'i te'e naruwe. Mato pa'are lowe lo peipaiyeye, sosu te'eye, “Ne Owane Sitewi lo wesi tutawe aine tapeti fu arosawirowa awere? Sosu nowe hesi heta si tame au ta'anerowa awere? Peri wawero a'i tene! Sng 22:7; 109:25; Mk 14:58 ");
INSERT INTO sny_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ne ta'u au ferafereire! Me tape'i hire ma'e arunatirowawe, si hi awei sahe itora!” ");
INSERT INTO sny_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Sosu aiwawe a'i au heseyei lu owane, sosu Owane Sitewi lo peri so'oruwe siye lu tamo lowe le ma'e peri te'e naruwe. Lowe te'e tiyatiteye. Lowe apou eiye, “Le lu taune tere'e au ta'ane ferafereiteye. Ahowa, le ta'u au ferafereirowata. ");
INSERT INTO sny_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ne meni ape, Owane Sitewi lai awei hi ma'e eimawe arosai ape, sosu Juda lo meni owane tutawe a'i su, nomo ne ma'e eisiya, ne me tape'i hire arunatirowawe, hi awei ma'e itora! Ne hi awei ma'e itoraiyei su, nomo peri no tote tawesirowa. Peri wawero a'i tene!” Ta'arei lu hesi aiwawe a'i Jisas mase me tape'i sahe iroteye ape, lowe lai le ma'e peri luwaru a'i au te'e naruteye. ");
INSERT INTO sny_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Sosu a'i pe poweiye ponei a'i se, pasi a'i awei pani werese napetuwe. Poweiye wati su, pasi a'i tepa'asiyewe, sosu mitaiyeye si tame henerai. ");
INSERT INTO sny_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Sosu poweiye wati su, Jisas peri erasi a'i hare uteye, Eloi, Eloi, lama sabaktani ? Peri ape lo sitewi apou wou a'i ne, “Owane Sitewi ano, Owane Sitewi ano, piyene ne ane ne me'iyeni ma'e atati arunati awere?” ");
INSERT INTO sny_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Lu taune tamo peri ape wanuwe su, lowe apou eiye, “Wanure! Le meni Elaija ei aniye!” ");
INSERT INTO sny_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Meni ta witane a'i se wain sa'i luwaru a'i ipari tahe se ausi aniyewe, me pite a'i sahe wafei se ti tawesiye. Sosu le Jisas ma'e sa'i ape au aye. Sosu le apou eiye, “Weiya! Nomo meni Elaija itorairowa awere? Le Jisas lo tahe pa'are hi awei ma'e ani itorairowa awere?” Sng 69:21 ");
INSERT INTO sny_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Sosu Jisas peri erasi a'i tame hare uteye. Sosu Jisas lo hepene fi. ");
INSERT INTO sny_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Jisas temeniyeye su, ipari tahe erasi pite a'i Owane Sitewi lo wesi tutawe papu heriteye ape, Owane Sitewi lai ipari tahe ape hire ma'e ponei ani tou apeti itorai. ");
INSERT INTO sny_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ai lu owane Jisas atahe a'i teiye ape, le Jisas lo temeniyeyei siyeye su, le apou eiye, “Peri wiyeme a'i ne. Meni ape Owane Sitewi lo meni eime tene!” ");
INSERT INTO sny_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Taune tamo eyeri oso a'i ma'e teiteye ape, lowe Jisas temeniyeyei siyeye. Lowe lo iyape apou a'i ne, Maria, omo pani Makdala ma'e fai, Maria tere'e, Jems, sosu Josep lo mai, sosu menitani tere'e Salome. Lu 8:2-3 ");
INSERT INTO sny_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Jisas omo pani Galili ma'e iroteye su, taune ape mo lowe Jisas mo'o umasiteye. Lowe etiri ta le ma'e au pati aniteye. Taune tomu ne'ese tere'e tamo lowe Jisas mase omo Jerusalem ma'e yaneye. ");
INSERT INTO sny_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Nowe neriwei tase, meni ta Josep, omo Arimatea ma'e fai ape, le marepi lo au iro kairefiyeyewe, sosu awei meni owane Pailat ma'e Jisas lo tahe pa'are aniyei ne ei toweriye. Meni ape Juda lo meni owane. Le Jisas lo peri wanu tote tawesi umasiteye. Sosu nowe amou (Sabat) lo omo hire ma'e ninaweteye. Nowe ape se Juda lo lu taune etiri werese ta'uweye. Sosu nowe me'iye su nowe Sarere henerairowa. Nowe amou (Sabat) Juda lo lu taune wiyawi ta'anerowata. ");
INSERT INTO sny_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Sosu Josep meni Pailat Jisas lo tahe pa'are ei toweriyei ne henerai su, Pailat apou toteye, “Jisas temeniyeye awere?” Sosu le ai lu meni owane ei aniyewe, apou ei toweriye, “Jisas temeniyeye awere? Piyete awere?” ");
INSERT INTO sny_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ai lu meni owane ape Pailat ma'e itiya'u eiye, “Pefine a'i Jisas temeniyeye.” Sosu Pailat Josep ma'e eiye, “Ne fara'u Jisas lo tahe pa'are aitire! ");
INSERT INTO sny_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Sosu Josep ipari tahe wapo pite a'i eteye. Le Jisas lo tahe pa'are me tape'i hire sahe hi awei ma'e erau ani itorai. Le Jisas lo tahe pa'are ipari tahe ani noweri fuwewe, tapiye fisiye yo, lu tamo horuseye ape, papu funari. Tahe pa'are ape fisiye yo papu fuwe su, le tapiye erasi fisiye yo hire fu tawesiye. ");
INSERT INTO sny_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Taune hesi Maria, omo Makdala ma'e fai ape, sosu Maria tere'e, Josep lo mai, lowesi Jisas lo fisiye yo siyenari. ");
INSERT INTO sny_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sosu a'i pe nowe amou (Sabat) tepa'asiye su, taune hesi heta, Maria, omo Makdala ma'e fai ape, Maria, Jems lo mai, sosu Salome, lowe sa'i heneri wisere a'i se Jisas lo tahe pa'are sahe au ani imeyei ne aiti. ");
INSERT INTO sny_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Esi pasi henerai su, lowe Jisas lo tapiye fisiye yo ma'e fi. ");
INSERT INTO sny_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Lowe a'i lai te'e tiyatiteye, “Tapiye erasi hire fusiya ape, eiwerai tapiye fisiye yo nowe tewiye ma'e ani nowerisawirowa awere?” ");
INSERT INTO sny_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Lowe fisiye yo ape heneri su, lowe tu nihari hire siye ani aroweye. Sawi amou! Tapiye erasi ape nowe tewiye ma'e ani nowerisawi tepa'asiye. Tapiye ape erasi pefine a'i tene! ");
INSERT INTO sny_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Sosu lowe tapiye fisiye yo papu wiye. Meni ta, ipari tahe wapo pefine a'i ani asiye ape ereti eyate feni se onuteye. Lowe meni ape siyeye su, lowe hepene se su'ari atoweiyeteye. ");
INSERT INTO sny_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Sosu le lowe ma'e eiye, “Fene atoweiye sawa! Ne Jisas, omo Nasaret ma'e fai ape, nehisiya awere? Lowe le me tape'i sahe tawere aine tera'eye. Ahowa, le si tame norohuwe sine tepa'asiye. Le sato ariye. Siyere! Lowe tahe pa'are lo yaro ahe au howeiteye. Siyere! Le sato ariye. ");
INSERT INTO sny_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Sosu fene lu disaipel lo ma'e, Pita aiwawe a'i, peri heneruwe ape au te'eri! Fene lowe ma'e apou au te'ere, ‘Jisas omo pani Galili ma'e tu irowa.’ Fene omo pani ape heneriyei su, fene le saro siyerirowa. Tu naifa Jisas lai peri ape fene ma'e au te'e areiyeteye.” Mt 26:32; Mk 14:28 ");
INSERT INTO sny_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Sosu taune ape tapiye fisiye yo nowe ma'e itero heneye. Tahe lowe lo auseriyeye. Lowe hepene erasi Lowe atoweiye a'i irowe. Peri eite (16:9-20) irosiya ape, peri eite piye meni lai leseye awere? Lu so'oru siye tamo lowe so'oru ta'ama. Ya'ariyei one towe tomu tamo sahe peri eite iro te ta'ame. One towe tere'e tamo sahe peri eite iroteye. { ");
INSERT INTO sny_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Sosu a'i pe nowe tutawe se Jisas si tame sine norohuweye. Le menitani ta Maria, omo Makdala ma'e fai ape a'i se su'ari ya'oreye. Ahowa, lowe lu taune werese ma'e peri ape au te'e areiye ta'ame. Tu naifa Jisas menitani ape sepei luwaru a'i ereti feni werese feni hesi a'i (7) au ta'ane sasarisawi. ");
INSERT INTO sny_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Sosu menitani ape Jisas arunatiyewe, lu taune, le mase iroteye ape, au te'e areiyeteye. Lu taune ape mo Jisas lo temeniyeyei ewite luwei erasi irowe. ");
INSERT INTO sny_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Menitani ape peri heneruwe au te'eye su, lu taune werese tote tawesiye ta'ama. ");
INSERT INTO sny_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Sosu a'i pe lu hesi omo Jerusalem arunatiyewe, yo mai iteye su, Jisas nihari tere'e se lowesi yo mai sahe naitu siyeye. ");
INSERT INTO sny_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Sosu Jisas lowesi arunatiyewe fi su, lu hesi Jisas lo lu disaipel ma'e peri ape au te'e areiyeyei ne fi. Ahowa, lowe peri ape wanuwe su, lowe peri ape wanu tote tawesi ta'ame. ");
INSERT INTO sny_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Sosu a'i pe Jisas lo lu disaipel wesi papu iroteye. Lowe metei sahe ta'uwe ene ateye. Sosu Jisas wesi papu wiye su, le lu disaipel lo werese siyeye. Le lowe ma'e ai peri eiye, “Marepi fene lo kairefi luwaru a'i ne. Fene piyene peri ano wanu tote tawesi ta'ame awere? Lu taune tamo, ane si sine norohuwe ape, siyeye su, fene peri lowe lo wanu tote tawesi ta'ame.” 1 Ko 15:5 ");
INSERT INTO sny_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Sosu Jisas lowe ma'e eiye, “Fene lu taune werese omo werese ma'e peri ano au te'e fiyariyei ne ire! Ap 1:8 ");
INSERT INTO sny_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Lu taune tamo peri ano wanu tote tawesiyei su, fene lowe fara'u sa'i se au hure. Serai ane lowe ma'e marepi hepene he'i a'i weriyei weriyei aurowa. Lu taune tamo peri ano wanu tote ta'ame su, Owane Sitewi lai lowe yehe omo ma'e weriyei weriyei eimawe arosawirowa. Ap 2:38 ");
INSERT INTO sny_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Lu taune werese peri ano wanu tote tawesi umasiyei su, fene marepi hepene he'i a'i lowe lo siyeye. Lowe lu taune lo sepei luwaru a'i au ta'ane sasarirowa. Aiwawe a'i lowe peri tere'e he'i a'i se lu taune ma'e au te'e areiyerowa. Ap 2:4; 8:7 ");
INSERT INTO sny_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Lowe haru luwaru a'i ereti se aniteyewe, sosu lowe sa'i luwaru a'i ayei su, lowe fara'u teirowa. Lowe temeniyerowata. Lowe lu taune u tahe se ereti hire ma'e isawe hetesiyewe, fene u tahe lowe lo au ta'ane fara'uweye.” Lu 10:19; Ap 28:3-6 ");
INSERT INTO sny_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Sosu a'i pe Jisas peri ape te'e tepa'asiye su, Owane Sitewi lai le omo hire ma'e hene ani wiye. Le Owane Sitewi lo ereti eyate feni ma'e onuri. Ap 1:9-11; 2:33-34 ");
INSERT INTO sny_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Sosu Jisas lo lu disaipel wesi ape arunatiyewe, omo omo werese lu taune ma'e au te'e fiyariteye. Sosu lowe wiyawi erasi pefine a'i lu taune ma'e au ta'ane wisereyeteye. Lu taune werese wiyawi lowe lo ape siyeye su, lowe Owane Sitewi lo peri pefine a'i siye so'oruweteye.} Ap 14:3; Hi 2:3-4 ");
INSERT INTO sny_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","Ane peri eite, meni owane, Tiofilus, Meni Owane Pefine a'i lo wiyawi werese ne, ne ma'e lese ausawiyei ne totesiya. Lu tomu ne'ese Meni Owane Pefine a'i ape lo wiyawi werese siyeteye. Lowe one towe sahe leseye. Lu ape mo, lowe Meni Owane Pefine a'i ape mase uweinamiteye. Lowe, meni ape lo lu feni pefine a'i lowe etiri werese, le ironamiye ape, nomo ma'e au te'esai. Sosu a'i pe ane aiwawe a'i, etiri werese, le ironamiye ape, ane one towe sahe leseyei ne totesiya. Ane etiri werese, lowe leseye ape, siye te'e etinamiteye. Ane lu werese, le mase ironamiteye ape, ei toweriye. Lowe ane ma'e Meni Owane lo peri ne au te'e areiyeteye. Serai ane Meni Owane Pefine a'i lo wiyawi farere a'i au leseyei ne totesiya. Etiri werese, le tu irowe ape, ane tutawe leseyei. Etiri werese, le mo'o irowe ape, ane sosu mo'o leseyei. Ne peri ano siye te'eyei su, ne etiri werese, lowe ne ma'e au te'e atuatuteye ape, siye so'oruwe tepa'asiyei. Peri ape wiyeme a'i tene! Ap 1:1 ");
INSERT INTO sny_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","6","Nowe ta se awei lo meni owane iyape Herot, le omo pani Judia ma'e au noweinoweiteye. Nowe ape se au heseyei meni owane ta iyape, Sekaraia, iroteye. Meni ape lo niyene iyape Abiya. Abiya lo lu tewi ape mo, lowe me tahe heneri se ape yehe sahe Owane Sitewi ma'e au itomuteye. Meni Sekaraia lai Abiya lo wiyawi au ta'aneteye. Meni ape Sekaraia tani lo aiwawe a'i lowesi Owane Sitewi lo nihe se Owane Sitewi lo yo peri werese umasinamiteye. Lowesi yo seni aseyaro a'i ironamiteye. Tani lo, iyape Elisabet, ya'ariyei lo meni owane, Aron, lo lu tewi ma'e fai. ");
INSERT INTO sny_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Lowesi eimane tamo auteiye ta'ame. Elisabet menitani waiyari a'i iroteye. Sekaraia, tani lo aiwawe a'i, lowesi ya'ariyei naihe pefine a'i ne. ");
INSERT INTO sny_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Nowe ta se Sekaraia Owane Sitewi lo wesi sahe me tahe heneri a'i ape Owane Sitewi ma'e au itomuteye. Abiya lo lu tewi ape mo lai wiyawi ape ta'aneteye. Serai Sekaraia Owane Sitewi ma'e wiyawi lo ta'aneteye. ");
INSERT INTO sny_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Lowe Owane Sitewi lo wiyawi au ta'aneteye su, lowe meni ape Sekaraia me tahe heneri wisere a'i yehe sahe lei itomuteyei ne ariariyeye. Sosu le Owane Sitewi lo wesi tutawe papu me tahe heneri wisere a'i lei itomuwei ne wiye. Kis 30:7 ");
INSERT INTO sny_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Owane Sitewi lo wesi nowe ma'e lu taune tomu ne'ese Owane Sitewi ma'e te'e toweriteye. ");
INSERT INTO sny_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sosu a'i pe Owane Sitewi lo ipari wisere a'i ta meni ape ma'e itorai. Le tapiye wari yehe yaru ereti eyate feni ma'e teirai. ");
INSERT INTO sny_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sekaraia Owane Sitewi lo ipari wisere a'i ape siyeye su, le hepene se su'ariye. ");
INSERT INTO sny_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ahowa, Owane Sitewi lo ipari le ma'e eiye, “Sekaraia, ne taweiru sawa! Tu naifa ne Owane Sitewi ma'e etiri ta ei toweriteye ape, Owane Sitewi lai peri no, le ma'e ei toweriteye ape, wanuwe. Sosu le etiri ape ne ma'e auwei. Tani no meni eime ta auteiyei. Tani no meni eime auteiyei su, ne meni eime ape lo iyape Jon au papore. ");
INSERT INTO sny_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Meni eime ape auteiyei su, marepi fenesi lo le ne wisereye nine'inamirowa. Lu taune tamo meni eime fenesi lo ape ne Owane Sitewi ma'e au te'e wisereyeyei. ");
INSERT INTO sny_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Meni eime ape Owane Sitewi lo nihe se meni owane erasi a'i henerairowa. Le wain sa'i meremereye a'i sa'i luwaru a'i tere'e arowata. Le mai lo lire papu iroteyei su, Owane Sitewi lai meni ape ma'e Hepene Wara'i a'i lo eimawesaiyei. Owane Sitewi lo Hepene Wara'i a'i le ma'e marepi lo au te'e atuatuwei. Nam 6:3 ");
INSERT INTO sny_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Meni erasi heneraiyei su, le Israel lo lu taune tomu ne'ese ma'e Owane Sitewi lo peri au te'e fiyari areiyeyei. Serai lowe Owane Sitewi lo peri wanuwei su, lowe Owane Sitewi, Owane lowe lo ma'e metete atati teirowa. ");
INSERT INTO sny_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Meni eime fenesi lo tu henerairowa. Meni Owane Pefine a'i mo'o henerairowa. Le Owane Sitewi lo peri au te'e siye meni henerairowa. Le Owane Sitewi lo au te'e siye meni, Elaija, lo hepene wou a'i henerairowa. Le kairefi a'i henerairowa. Le lu taune ma'e apou au te'erowa, ‘Tai werese, fene eimane werese fene lo ma'e marepi ta'i a'i totete. Fene, Owane Sitewi lo peri arisinamisiya ape, fene yo seni aseyaro pei umasite.’ Meni ape, Jon, le lu taune lo marepi au fareraiyeyei. Sosu nowe me'iye su, Meni Owane Pefine a'i aiyerowa. Serai lowe Owane Sitewi lo peri wanu umasirowa.” Ma 3:1; 4:5-6; Mt 17:11-13 ");
INSERT INTO sny_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sosu Sekaraia Owane Sitewi lo ipari wisere a'i ma'e itiya'u eiye, “Etiri werese, ne ane ma'e au te'eye ape, wiyeme a'i awere? Wawero a'i tene! Ane, tani ano aiwawe a'i, notosi ya'ariyei naihe pefine henerai. Tani ano waiyari ironamisiya.” ");
INSERT INTO sny_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Sosu Owane Sitewi lo ipari wisere a'i le ma'e itiya'u eiye, “Iyape ano Gebriel. Ane Owane Sitewi Pefine a'i lo nihe atahe sahe teinamiteye. Le ane peri ape ne ma'e te'e areiyeyei ne eimawe arosai. Serai ane Owane Sitewi lo peri heneruwe wisere a'i ape ne ma'e au te'esiya. Dan 8:16; 9:21 ");
INSERT INTO sny_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Peri ano wanure! Owane Sitewi lai ahi no ani tomo'uterowa. Ne peri te'erowata. Sosu etiri werese, ane ne ma'e au te'eye ape, henerai tepa'asiyei su, Owane Sitewi fara'u ahi no ani anerowa. Ne Owane Sitewi lo peri wanu arisiye su, ahi no tomo'uterowa. Peri werese, Owane Sitewi ne ma'e au te'esiya ape, Owane Sitewi lo nowe se wiyeme a'i heneraiyei.” ");
INSERT INTO sny_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Owane Sitewi lo ipari te'e tepa'asiye su, le Sekaraia arunatiyewe fi. Lu taune tomu ne'ese Sakaraia ninawe no'otiteye. Lowe marepi erasi a'i toteye. Piyene le Owane Sitewi lo wesi tutawe nowe ma'e henerai ta'ama awere? ");
INSERT INTO sny_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Mo'o su Sekaraia Owane Sitewi lo wesi tutawe nowe ma'e henerai. Le Owane Sitewi lo wesi tutawe nowe ma'e henerai su, le peri te'erowata. Lowe le ne te'e tiyatiteye. Piye etiri le ma'e henerai awere? Owane Sitewi lai le ma'e suwou peri ta au atuatuteye awere? Le lowe ma'e ereti se au atuatuteye. Ahowa, le peri te'erowata. ");
INSERT INTO sny_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sosu nowe ta i tepa'asiye su, Sekaraia lo wiyawi tepa'asiye. Le wesi topo lo si tame fi. ");
INSERT INTO sny_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Nowe mo'o ta se Sekaraia lo tani eime tahe se henerai. Le wesi papu yame ereti feni werese iro fareyarenamiteye. Le apou eiye, ");
INSERT INTO sny_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Nowe iyu menei tomu ne'ese ane menitani waiyari a'i ironamiteye. Taune tomu ne'ese ane ma'e te'e narute ye. Lowe ane ma'e apou au te'eteye, ‘Ne menitani luwaru a'i ne.’ Pereye Owane Sitewi lai neritase ano au sasariye. Ane meni eime auteiyei su, lu taune tamo ane ne au te'e nine'irowa.” ");
INSERT INTO sny_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Sosu a'i pe Elisabet yame ereti feni werese feni ta'i a'i eime tahe se iroteye su, Owane Sitewi lai ipari wisere a'i lo, iyape Gebriel, omo Nasaret ma'e eimawe arosai. Omo Nasaret pani Galili sahe iroteye. ");
INSERT INTO sny_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Le menitani wati'are ma'e heneri. Menitani ape ne, lowe meni Josep lai le fa naituwei ne ariariyeye. Menitani lo iyape Maria. Le Juda lo meni owane Devit lo lu tewi ma'e fai. Mt 1:16,18 ");
INSERT INTO sny_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ipari Gebriel Maria lo wesi papu wiye su, le ma'e eiye, “Esi Maria, Owane Sitewi lai ne ne marepi wisere a'i totesiya. Meni Owane Pefine ne mase ironamisiya.” ");
INSERT INTO sny_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Sosu Maria peri ape wanuwe su, le tahe lo auseriyeteye. Le marepi erasi a'i apou toteye. “Peri lo sitewi eite, piye te'esiya awere?” ");
INSERT INTO sny_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Sosu ipari Gebriel le ma'e eiye, “Maria, taweiru sawa! Owane Sitewi lai ne ne marepi wisere a'i totenamisiya. ");
INSERT INTO sny_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Peri ano wanure! Ne eime tahe se henerairowa. Serai ne meni eime ta auteirowa. Ne meni eime ape lo iyape Jisas au papore. Ais 7:14; Mt 1:21-23 ");
INSERT INTO sny_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Le Meni Owane Pefine a'i henerairowa. Lu taune le ne a'i Owane Sitewi Pefine a'i lo meni eime au te'e areiyerowa. Tu naifa Owane Sitewi lai ya'ariyei Devit ma'e Juda lo meni owane pefine a'i au iro henerai. Sosu aiwawe a'i le meni eime lo ma'e owane Devit lo kairefiye aurowa. ");
INSERT INTO sny_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Sosu meni eime ape Meni Owane Pefine a'i henerairowa su, le ya'ariyei Jakop lo lu tewi werese mi mi pasi pasi weriyei au noweinoweirowa. Kairefiyeyei lo po'uterowata.” 2 Sml 7:12,13,16; Ais 9:7 ");
INSERT INTO sny_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Sosu menitani Maria ipari Gebriel ma'e itiya'u eiye, “Ne piye te'esiya awere? Ane meni ta mase howei ta'ame. Ane eime tahe se ta'ama.” ");
INSERT INTO sny_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Sosu ipari ape le ma'e itiya'u eiye, “Owane Sitewi lo Hepene Wara'i a'i ne ma'e itoraiyei. Owane Sitewi Pefine a'i lo kairefiyeyei ne ma'e napetuwei. Serai ne eime tahe se henerairowa. Ne meni eime auteiyei su, lu taune werese apou eiyei, ‘Meni eime ape Owane Sitewi lo meni eime pefine a'i tene!’ ");
INSERT INTO sny_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Wanure! Aita'i no Elisabet, le ya'ariyei naihe menitani, eime tahe se irosiya. Tu naifa le waiyari a'i ironamiteye. Pereye le yame ereti feni werese feni ta'i eime tahe se irosiya. ");
INSERT INTO sny_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Owane Sitewi lai etiri werese werese fara'u ta'ane henerairowa.” Stt 18:14 ");
INSERT INTO sny_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maria itiya'u eiye, “Wanure! Ane Owane lo wiyawi ta'ane siye menitani pefine a'i ne. Ane Meni Owane ano lo marepi umasinamiyei.” Sosu ipari Gebriel arunatiyewe fi. ");
INSERT INTO sny_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ipari Gebriel fi su, Maria witane a'i sineyewe, omo ta ma'e heneri. Le omo pani Judia ma'e heneri. Le menitani ta sahe sewiyeyei ne fi. ");
INSERT INTO sny_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Omo pani Judia ma'e heneri su, le Sekaraia lo wesi ma'e wiye. Le naihe tani aita'i lo eriteye. ");
INSERT INTO sny_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisabet, Maria lo peri ape wanuwe su, aita'i lo meni eime lire papu sepe'eyeye. Serai Owane Sitewi lo Hepene Wara'i a'i Elisabet ma'e lire papu wiye. ");
INSERT INTO sny_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Sosu le peri erasi a'i apou eiye, “Owane Sitewi lai ne ma'e au wisereyesiya. Ne lai taune werese hi ani ararowe. Owane Sitewi lai meni eime ape ma'e au wisereyeye. ");
INSERT INTO sny_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Marepi ano wisere a'i totenamisiya. Ne a'i lai, Meni Owane Pefine a'i ano auteirowa ape, ne ane ma'e sewiyeyei ne fai. Serai ane Owane Sitewi ma'e au te'e wisereyesiya. ");
INSERT INTO sny_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Wanure! Ne ane ma'e au eriteye su, meni eime ano lire papu irosiya ape, wisere erasi a'i sepe'eyeye. ");
INSERT INTO sny_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ne Owane Sitewi lo peri wanu umasiye. Sosu Owane Sitewi lai ne ma'e au pati ferafereiyei. Owane Sitewi lo peri ne ma'e au te'eye su, ne marepi papu se apou toteye. Etiri wiyeme a'i henerairowa. Serai ne marepi wisere a'i ironamisiya.” ");
INSERT INTO sny_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria itiya'u eiye, “Marepi ano Meni Owane ano lo iyape ei ani arowesiya. ");
INSERT INTO sny_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Hepene ano marepi wisere a'i ironamisiya. Piyene awere? Owane Sitewi lai yo seni luwaru a'i ano au sasari pamoweye. ");
INSERT INTO sny_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ane iyape erasi se ta'ame. Ane Meni Owane Pefine lo wiyawi menitani. Le ane marepi erasi a'i totesiya. Ane le ma'e au te'e wisereyesiya. Lu taune werese nowe weriyei weriyei a'i lowe ane ne marepi erasi a'i totenamirowa. ");
INSERT INTO sny_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Meni Owane pefine lai etiri tomu ne'ese a'i ane ma'e au irowe. Iyape topo lo wara'i pefine a'i ne. ");
INSERT INTO sny_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Le ferafereiyei lo lu taune werese ma'e nowe weriyei weriyei a'i napeturowa. Lu taune werese le ma'e marepi erasi a'i totenamisiya ape, le ferafereiyei lo lowe ma'e napeturowa. ");
INSERT INTO sny_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Le etiri tomu ne'ese ereti topo lo se ta'ane heneraiteye. Lu taune marepi towafi lowe lo erasi a'i totenamiye su, sosu iyape towafi lowe lo ei ani aroweye su, Owane Sitewi lai lowe omo omo werese ma'e eimawe fiyarisawi. ");
INSERT INTO sny_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Le awei lo lu owane hi ani araroteye. Lu taune tamo iyape se ta'ame ape, le iyape erasi lowe ma'e ei ani aroweteye. ");
INSERT INTO sny_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Lu taune lau erasi a'i ironamisiya ape, le etiri wisere a'i lowe ma'e au ene aye. Lu taune ma'aru erasi a'i iroteye ape, le lowe ma'aru ariye a'i eimawesawi. ");
INSERT INTO sny_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Owane Sitewi lai ya'ariyei nomo lo, Abraham, lu tewi werese ma'e aiwawe a'i te'e naneiyei lo auwe. Le lowe ma'e apou eiye, ‘Ane fene ma'e nowe weriyei weriyei a'i au ferafereiyei. Sosu ane fene werese ma'e au pati ferafereiyei.’” Sosu Maria lo peri tepa'asiye. Sng 98:3; Mai 7:20; Stt 17:7 ");
INSERT INTO sny_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Sosu a'i pe Maria aita'i mase yame hesi heta ironamiteye. Yame hesi heta i tepa'asiye su, Maria wesi topo lo ma'e si tame fi. ");
INSERT INTO sny_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Maria wesi topo lo ma'e fi su, Elisabet lo nowe henerai. Serai le meni eime lo auteiye. ");
INSERT INTO sny_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Elisabet meni eime lo auteiye su, lu taune werese, omo lo iroteye ape, lu tewi werese aiwawe a'i lowe apou eiye, “Owane Sitewi lai ferafereiyei lo ya'ariyei naihe menitani ma'e auwe. Nomo le aiwawe a'i Owane Sitewi ma'e au te'e wisereyesiya.” ");
INSERT INTO sny_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nowe ereti fene werese feni hesi heta (8) i tepa'asiye su, lu taune tamo wesi lowesi lo ma'e tahe touwei ne fai. Lowe meni eime tai lo iyape Sekaraia au papowei ne toteye. Stt 17:12; Wkp 12:3; Lu 2:21 ");
INSERT INTO sny_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ahowa, meni eime lo mai itiya'u eiye, “Ahowa, meni eime lo iyape Jon au papowei.” ");
INSERT INTO sny_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Lowe le ma'e itiya'u eiye, “Piyene ne iyape Jon au papowei awere? Lu tewi werese no iyape Jon se ta'ama.” ");
INSERT INTO sny_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Lowe meni eime lo aite ma'e ereti se aine aiya'o aniye. Lowe ereti peri se le ma'e eiye, “Ne piye iyape au papowei awere?” ");
INSERT INTO sny_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sosu Sekaraia ereti peri se one towe ta le ma'e faiye ne ereti se aine aiya'o aniteye. Le one towe ape sahe apou leseye, “Meni eime lo iyape Jon au papowe.” Lowe werese hepene se su'ariye. ");
INSERT INTO sny_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Le one towe sahe lese tepa'asiye su, witane a'i Owane Sitewi lai ahi lo au ta'ane fara'uweye. Ahi lo tomo'ute ta'ame. Serai le peri tame te'eteye. Le Owane Sitewi ma'e au te'e wisereyeye. ");
INSERT INTO sny_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Lowe werese Sekaraia lo peri wanuwe su, lowe marepi atoweiye a'i toteye. Lowe omo omo werese Judia ma'e au te'e fiyariteye. ");
INSERT INTO sny_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Lu taune werese peri lowe lo wanuwe su, lowe apou toteye, “Meni eime ape piye meni henerairowa awere? Owane Sitewi lo kairefiyeyei meni eime ape mase ironamitorowa.” ");
INSERT INTO sny_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Sosu a'i pe Owane Sitewi lai meni Sekaraia, meni eime Jon lo tai, Owane Sitewi lai Hepene Wara'i a'i lo Sekaraia lo marepi papu eimawe arosai. Serai le Owane Sitewi lo marepi lowe werese ma'e apou au te'e areiyeteye, ");
INSERT INTO sny_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Nomo, Israel lo lu taune, nomo Owane Sitewi Pefine a'i nomo lo iyape erasi a'i ei ani aroweteyei. Le awei ma'e nomo au ta'ane ferafereiyei ne itorai. Le seni luwaru werese a'i nomo lo au ani sasari pamoweyei ne itorai. Sosu le nomo werese si tame eterowa. ");
INSERT INTO sny_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Owane Sitewi lai nomo werese ma'e meni kairefi a'i ta auwe. Meni ape Devit lo lu tewi wiyeme a'i ne. Le yo seni luwaru werese a'i nomo lo ani sasari pamowerowa. ");
INSERT INTO sny_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Owane Sitewi Pefine a'i tu naifa weriyei au te'e siye lu ma'e te'e naneiyei lo au te'eteye. Lowe Owane Sitewi lo te'e naneiyei wanuwe su, lowe Juda lo lu tewi werese ma'e au te'eteye. ");
INSERT INTO sny_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Lowe apou te'eye, ‘Ai atu siye lu tamo fene ma'e au luwaruweyei. Sosu fene pani tere'e ma'e henetiyei su, Owane Sitewi Pefine a'i lai fene ma'e te'e nanei ta auwe. Le a'i lai fene si tame henetairowa. Lu werese fene ma'e ai marepi totenamiyei su, ane lai lowe werese hi ani ararowei.’ ");
INSERT INTO sny_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Tu naifa weriyei Owane Sitewi Pefine a'i ya'ariyei nomo lo ma'e te'e naneiyei ta au te'eye. Le apou eiye, ‘Ane ferafereiyei ano fene ma'e auwei. Ane fene werese ma'e au noweinoweiyei.’ ");
INSERT INTO sny_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Te'e naneiyei ape le ya'ariyei nomo lo, Abraham ma'e, au te'eye. ");
INSERT INTO sny_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ai atu siye lu tamo nomo pani tere'e ma'e henetiyei su, le a'i lai ai atu siye lu werese ai atu hi ani ararowwe, nomo si tame henetairowa. Serai nomo fara'u wiyawi lo weriyei weriyei ta'anenamitorowa. Nomo ai atu siye lu werese ma'e atoweiyerowata. ");
INSERT INTO sny_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Nomo wiyawi lo aniyei su, mi mi weriyei a'i yo seni nomo lo aseyaro farere a'i ironamirowa. ");
INSERT INTO sny_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Sosu, ne meni eime ano, ne meni erasi henerairowa su, ne Owane Sitewi Pefine a'i lo peri au te'e siye meni henerairowa. Ne tu irowawe, yo lo aiyeyei ape au ariariye nanere. Lu taune lo marepi toteyei amerame wara'i wisere a'i fa irote. Meni Owane Pefine a'i ne me'iye aiyerowa. ");
INSERT INTO sny_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Le irowa su, le Owane Sitewi wiyeme lo marepi Juda lo lu tewi werese ma'e au atuatu so'oruwerowa. Le lai yo seni luwaru werese a'i lowe lo, iroteye ape, tote i'anenamirowa. Serai marepi lowe lo aseyaro a'i henerairowa. ");
INSERT INTO sny_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Meni Owane Pefine a'i nomo werese ma'e marepi erasi a'i tote wawesiyenamisiya. Serai ferafereiyei lo nomo werese ma'e au ani napetu tawesinamiyei. Poweiye mi erasi wou a'i ne. Lu taune awei se eite ma'e au napetu tawesiye. ");
INSERT INTO sny_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Lu taune yo seni luwaru a'i pasi wou ironamisiya ape, Owane Sitewi lo ferafereiyei lowe ma'e fiyari arosairowa. Sosu aiwawe a'i lowe ma'e, temeniyeyei ne tote atoweiye iroteye ape mo, Owane Sitewi lai ferafereiyei lo lowe ma'e au napetu tawesiye. Le yo seni aseyaro nomo ma'e au atuaturowa. Serai le marepi fetane a'i nomo ma'e aurowa.” Sakaraia lo peri ape tepa'asiye. ");
INSERT INTO sny_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Sosu a'i pe meni eime lo erasi a'i henerai. Hepene lo kairefi a'i iro henerai. Le aite lo wesi arunatiyewe, pani ariye a'i ma'e ironamiteye. Nowe ta se le omo werese ma'e Juda lo lu taune werese ma'e Owane Sitewi lo peri au te'eyei ne heneri. ");
INSERT INTO sny_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Sosu a'i pe meni owane wiyeme iyape Sisar Ogastus yo peri ta au te'e fiyariteye. Le Rom lo omo pani werese au noweinoweiteye. Yo peri ape apou a'i te'eye, “Lu taune werese, lowe omo towafi lowe lo ma'e si tame iyei. Sosu lowe omo towafi lowe lo iyei su, meni owane iyape lowe lo lese aniyei.” ");
INSERT INTO sny_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Lowe peri so'oruweyei tutawe ape au te'e fiyariye su, meni owane erasi ta, iyape Kwirinius, le omo pani tewi a'i Siria au noweinoweinamiteye. ");
INSERT INTO sny_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Sosu lu taune werese omo sitewi towafi lowe lo fi su, omo ape lu owane lai lu taune werese lo iyape lese aniye. ");
INSERT INTO sny_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Sosu a'i pe meni ta iyape Josep omo Nasaret arunatiyewe, omo Betlehem ma'e yaneye. Omo Nasaret pani tewi Galili sahe iroteye. Sosu omo Betlehem pani tewi Judia sahe iroteye. Piyene Josep omo Betlehem ma'e yaneye awere? Omo Betlehem ya'ariyei Devit lo omo sitewi a'i ne. Josep Devit lo meni lu te'eye. Serai le omo Betlehem ma'e yaneye. Le menitani ta mase, naituwei ei naneiye ape, omo Betlehem ma'e yaneye. ");
INSERT INTO sny_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Lowesi iyape towafi lowesi lo au leseyei ne yaneye. Menitani Maria eime tahe se ne. ");
INSERT INTO sny_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Lowesi omo Betlehem henerai su, menitani meni eime auteiyei se nowe ataheyerai. Omo ape sahe wesi werese lu taune teme'eriyeye. ");
INSERT INTO sny_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Serai menitani ape fe bulmakau lo wesi sahe meni eime poto auteiye. Le meni eime poto ape ipari tahe se worone tawesiyewe, niye papu ani asiye. Sosu le meni eime lo fe bulmakau lo wahu sahe au howeiye. ");
INSERT INTO sny_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Nowe pasiyeye su omo nowe ma'e lu tamo fe sipsip au noweinoweiteye. Sosu lowe fetane a'i irowe. ");
INSERT INTO sny_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Pereye a'i Owane Sitewi lo ipari wisere a'i ta itorai. Mitaiyeyei erasi mase awei werese ma'e tewi mitaiye fiyariteye. Lowe mi erasi siyeye su, lowe taweiru a'i irowe. ");
INSERT INTO sny_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Sosu Owane Sitewi lo ipari wisere a'i lowe ma'e apou eiye, “Fene taweiru sawa! Wanure! Ane fene ma'e peri heneruwe wisere a'i au te'eyei. Peri heneruwe eite se lu taune werese lo marepi wisere a'i au irorowa. ");
INSERT INTO sny_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Pereye, Devit lo omo sitewi sahe, menitani ta meni eime poto auteiye. Tu naifa weriyei Owane Sitewi lai meni eime poto ape ariariyeye. Meni eime ape lu taune werese lo seni luwaru a'i au ta'ane sasarirowa. Le a'i lai meni owane Krais. Meni ape Owane Sitewi lai ariariyeye. Fene iyei su, fene meni eime poto fara'u siyerowa. ");
INSERT INTO sny_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Fene meni eime poto nehiyei su, fene meni eime ape siye so'oruwerowa. Fene meni eime ipari tahe worone tawesisiya ape, siyerowa. Meni eime ape fe bulmakau lo wahu papu saro howeisiya.” ");
INSERT INTO sny_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Sosu Owane Sitewi lo ipari wisere a'i lo peri au te'e tepa'asiye. Pereye a'i Owane Sitewi lo ipari wisere a'i a'i tomu ne'ese itorai. Lowe werese Owane Sitewi ma'e au te'e wisereye nine'iteye. Ipari werese ape mo Owane Sitewi ma'e au te'e wisereye nine'iteye su, lowe apou te'eye, ");
INSERT INTO sny_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Lu taune werese, fene Owane Sitewi ma'e peri erasi au te'e wisereyete. Sosu lu taune werese, Owane Sitewi lo peri tote umasisiya ape, marepi fetane a'i ape lowe ma'e mi mi weriyei ironamirowa. Owane Sitewi lai lowe ne marepi wisere a'i totenamisiya.” ");
INSERT INTO sny_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Sosu a'i pe Owane Sitewi lo ipari wisere werese a'i hire ni'arawe ma'e si tame wiye su, fe sipsip noweinowei siye lu, lowe te'e tiyatiye. Lowe apou te'eye, “Nomo omo Betlehem ma'e iyei. Nomo etiri ape, Owane Sitewi lai nomo ma'e au te'eye ape, nomo fara'u siyenariyei.” ");
INSERT INTO sny_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Lowe witane a'i arunatiyewe fi. Lowe omo Betlehem ma'e wiye su, lowe menitani Maria, meni lo Josep, sosu meni eime poto siyenari. Meni eime poto fe bulmakau lo wahu papu saro howeiteye. ");
INSERT INTO sny_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Lowe meni eime siye tepa'asiye su, lowe lu taune ma'e etiri werese, Owane Sitewi lo ipari wisere a'i lowe ma'e au te'eye ape, au te'e fiyariteye. ");
INSERT INTO sny_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Sosu lu taune werese peri heneruwe ape wanuwe su, lowe werese hepene se su'ariye. ");
INSERT INTO sny_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Sosu menitani Maria etiri werese ape mo marepi topo lo papu tote tawesiye. Lu 2:51 ");
INSERT INTO sny_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Sosu fe sipsip noweinowei siye lu ape mo, lowe fe sipsip ma'e si tame fiyewe, lowe Owane Sitewi ne au te'e wisereye nine'iye. Etiri werese lowe wanuwe ape, etiri werese lowe siyeye ape, etiri werese Owane Sitewi lo ipari lowe ma'e au te'eteye ape, pefine a'i tene! Serai lowe Owane Sitewi ma'e au te'e wisereye nine'iteye. ");
INSERT INTO sny_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Sosu a'i pe nowe ereti feni werese feni hesi heta i tepa'asiye su, lu tamo meni eime ape wesi towafi lowe lo ma'e tahe touwe. Lowesi meni eime iyape Jisas au papowe. Tu naifa Owane Sitewi lo ipari Gebriel Maria ma'e, meni eime lire papu iroteye ape, iyape Jisas au papowe. Lu 1:31 ");
INSERT INTO sny_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Nowe lu hesi werese (40) i tepa'asiye su, menitani, sosu meni eime, lowesi Moses lo yo peri umasiye. Lowesi au hu aseyaroweye su, nohuweripi, meni eime lowesi lo omo Jerusalem ma'e wiyewe, Owane Sitewi ma'e si auwe. Wkp 12:1-8 ");
INSERT INTO sny_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Moses lo yo peri sahe Owane Wiyeme tame eiye, “Menitani meni eime poto auteiyei su, le meni eime lo Owane Wiyeme lo ereti ma'e fu aure. Lowe meni eime ape meni aseyaro pei au ariariyere.” ");
INSERT INTO sny_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Lowesi Owane Sitewi ma'e irowe hesi a'i fu au hesere. Owane Sitewi lo yo peri apou a'i te'eye. “Irowe misate hesi a'i, irowe matu yene oture hesi a'i, lowesi irowe hesi a'i Owane Sitewi ma'e heneri se pei au itomu hese arowere.” Serai Maria, Josep lowesi lai Moses lo yo peri werese umasiteye. ");
INSERT INTO sny_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Omo Jerusalem sahe meni ta ironamiteye. Meni lo iyape, Simeon. Meni ape Owane Sitewi lo yo peri umasinamiteye. Yo seni lo aseyaro a'i iroteye. Le Owane Sitewi lo te'e naneiyei ape tote tawesiteye. Owane Sitewi lo te'e naneiyei ape apou a'i te'eye, “Owane Sitewi lai ai lu werese, Juda lo lu mase ai atuteye ape mo, hi ani fu ararorowa.” Owane Sitewi lo Hepene Wara'i a'i meni ape sahe ironamiteye. ");
INSERT INTO sny_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Nowe tu se Owane Sitewi lo Hepene Wara'i a'i meni ape ma'e apou eiye, “Ne i'ero temeniye ta'ame. Ne tu Meni Owane Pefine a'i, Owane Sitewi lai hi awei ma'e eimawe arosairowa ape, iyape Krais siyerowa. Meni Owane Krais, itoraiyei ape, siyerowa su, ne fara'u temeniyerowa.” ");
INSERT INTO sny_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Nowe ape se Josep, Maria aiwawe a'i, lowesi meni eime Jisas Owane Sitewi lo wesi ma'e heneti su, lowesi Owane Sitewi lo yo peri umasiyei ne toteye. Nowe ape se Owane Sitewi lo Hepene Wara'i a'i meni ape Simeon Owane Sitewi lo wesi ma'e eimawesawi. ");
INSERT INTO sny_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeon Jisas siyeye su, le meni eime ape ereti se ya'oreye. Sosu Owane Sitewi ma'e au te'e wisereyee. Le apou eiye, ");
INSERT INTO sny_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Meni Owane, te'e naneiyei no wiyeme a'i henerai. Ane wiyawi yahowa'i siye meni no. Ane Meni Owane Krais siye tepa'asiye. Ane marepi fetane a'i se fara'u temeniyerowa. ");
INSERT INTO sny_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Meni eime eite lu taune werese ma'e yo seni, aseyaro au ferafereiyei ape, ane meni eime eite siyeye. ");
INSERT INTO sny_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ne lu taune werese ma'e meni eime eite wiyawi no ta'aneyei ne eimawe arosai. ");
INSERT INTO sny_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Le wiyawi no lu tewi tere'e tere'e ma'e au atuatu fiyarirowa. Le mitaiyeyei erasi aiwawe a'i henerairowa. Le aiyerowa su, le Juda lo iyape erasi a'i ei ani arowerowa.” ");
INSERT INTO sny_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeon peri tepa'asiye su, Jisas lo aite, mai peri lo ne hepene se su'ariye. Lowesi peri lo ne marepi erasi a'i toteye. ");
INSERT INTO sny_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Sosu Simeon Owane Sitewi ma'e lowesi ne apou ei toweriye, “Owane Sitewi, ne lowesi ma'e au te'e wisereyere. Lowesi ma'e marepi fetane a'i aure.” Sosu le menitani Maria meni eime lo mai ma'e eiye. “Peri ano wanure! Owane Sitewi lai meni eime ape ariariyeye. Lu taune tomu ne'ese peri lo wanurowawe, le ma'e au te'e wisereyeyei. Lu taune tamo peri lo wanu ta'ame. Lowe Owane Sitewi lo peri me'iyeni ma'e atati arunatirowa. Lowe le ne te'e narurowa. Ais 8:14; Mt 21:42; 1 Pi 2:8 ");
INSERT INTO sny_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Serai lu tewi tamo hesi a'i hesi a'i lo marepi henerairowa. Lu tewi ta'i, lowe Owane Sitewi lo peri wanu umasirowa. Lu tewi tere'e lowe Owane Sitewi lo peri arisirowa. Owane Sitewi ma'e ai atu tiyatirowa. Owane Sitewi lai lu taune werese lo marepi ape au atuatu areiyerowa.” Sosu Simeon menitani Maria ma'e apou eiye, “Meni eime no erasi a'i heneraiyei su, ne marepi orese erasi a'i teriterowa. Fofowei a'i no aiwawe, ipari mene'e marepi aine tewi touwei wou a'i teriterowa.” ");
INSERT INTO sny_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Simeon peri tepa'asiye su, menitani owane iyape Ana, le Owane Sitewi lo marepi lu taune ma'e au te'eteye. Menitani ape Fanuel lo eime taune. Le lu tewi Aser ma'e fai. Le ya'ariyei naihe tani irowe. Tu naifa weriyei le meni ta naitu ene aye. Nowe iyu menei ereti feni werese feni hesi a'i i tepa'asiye su, meni lo ape temeniyeye. ");
INSERT INTO sny_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Meni lo temeniyeye su, le Owane Sitewi lo wesi papu wiye. Mi mi weriyei a'i le Owane Sitewi lo wesi saro ironamiteye. Iyu menei tomu ne'ese (84 aiwawe a'i), le Owane Sitewi lo wesi sahe ironamiteye. Le Owane Sitewi ne marepi erasi a'i totenamiteye. Nowe tomu ne'ese se le ayei werese amouweye. Mi mi pasi pasi werese le Owane Sitewi lo iyape ei ani aroweye. Nowe werese le Owane Sitewi lo wiyawi ta'anenamiye. ");
INSERT INTO sny_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Nowe ape se Simeon meni eime ereti se ya'oreye su, menitani Ana lowesi siyenarai. Le Owane Sitewi ma'e au te'e wisereyeye. Lu taune tomu ne'ese, Owane Sitewi lo te'e naneiyei wiyeme a'i ninaweteye ape, henerai. Owane Sitewi lo te'e naneiyei heneraiyei su, Owane Sitewi lai omo Jerusalem lo ai atu siye lu werese hi ani ararosawiyei. Menitani ape lowe ma'e meni eime ape ne au te'e areiyeye. Meni eime ape Owane Sitewi lo te'e naneiyei pefine a'i henerai. ");
INSERT INTO sny_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Sosu Josep, Maria lowesi Owane Sitewi lo yo peri werese umasiye su, lowesi meni eime aiwawe, pani Galili ma'e si tame heneti. Omo towafi lowe lo ma'e Nasaret heneri. Mt 2:23 ");
INSERT INTO sny_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Lowe omo Nasaret saro ironamiteye su, meni eime lowesi lo erasi kairefi a'i henerai. Le marepi wisere a'i tote ironamiteye. Mi mi weriyei Owane Sitewi lo marepi le ma'e ironamiteye. ");
INSERT INTO sny_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Nowe iyu menei werese, nowe Pasova se, lowe omo Jerusalem ma'e Pasova lo sitewi tote tawesiyei ne fi. Kis 12:24-27; 23:14-17; Lo 16:1-8 ");
INSERT INTO sny_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Sosu Jisas iyu menei ereti feni hesi lowe hesi a'i (12) i tepa'asiye su, lowe omo Jerusalem ma'e fi. Lowe ta'uwe hereiyei Pasova ene ayei ne toteye. ");
INSERT INTO sny_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ta'uwe hereiyei a tepa'asiye su, lowesi omo towafi lowe lo si tame fi. Meni eime Jisas omo Jerusalem sato iroteye. Aite, mai lowesi eiwerou ma'e le so'oru ta'ama. ");
INSERT INTO sny_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Lowesi yo sahe itiye su, lowesi apou toteye, “Le kaiyemo tamo mase aiwawe aiyesiya.” Nowe mi ta'i tepa'asiye su, lowesi Jisas kaiyemo tamo se ariye a'i te'e toweriteye. ");
INSERT INTO sny_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Lowesi le saro nehi po'uteye su, lowesi omo Jerusalem ma'e si tame nehiyei ne fi. ");
INSERT INTO sny_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Nowe hesi heta i tepa'asiye su, lowesi le Owane Sitewi lo wesi sahe siyeri. Le au heseyei lu owane mase onuteye. Le lu owane lo peri wanu etiteye. Aiwawe a'i le lu owane ma'e etiri tomu ne'ese ei toweriye. ");
INSERT INTO sny_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","So'oru atuatu siye lu owane werese Jisas lo peri wanuwe su, lowe marepi wisere erasi a'i toteteye. Le Owane Sitewi lo yo peri werese wanu so'oruwe tepa'asiye. Le peri itiya'u au te'eye su, lowe hepene se su'ariye. Meni eime etiri werese so'oruwe tepa'asiye. ");
INSERT INTO sny_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Lowesi Jisas siyeye su, lowesi tahe auseriye irowe. Sosu mai lo le ma'e ei toweriye, “Piyene marepi orese a'i notosi ma'e auwe awere? Siyere! Tai no ane aiwawe a'i notosi ne nehi po'uteteye. Notosi marepi orese a'i ne ne teriteteye.” ");
INSERT INTO sny_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Sosu le lowesi ma'e itiya'u eiye, “Fenesi piyene ane wesi tere'e sahe nehiti awere? Ane tai ano lo wesi sato iroteye. Fenesi so'oru ta'ama awere?” ");
INSERT INTO sny_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Lowesi peri lo sitewi, le lowesi ma'e au te'eye ape, so'oru ta'ama. ");
INSERT INTO sny_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Sosu le lowesi mase omo Jerusalem arunatiyewe, omo Nasaret ma'e heneri. Nowe mi mi weriyei a'i le tai mai lo peri wanu umasinamiteye. Mai lo etiri werese marepi topo lo sahe tote tawesinamiteye. Lu 2:19 ");
INSERT INTO sny_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Sosu a'i pe Jisas meni erasi a'i henerai. Le nowe iyu menei tomu ne'ese siyeye. Marepi lo wisere erasi a'i totenamiteye. Owane Sitewi lai lu taune werese aiwawe a'i le ne au te'e wisereyeye. 1 Sml 2:26; Snd 3:4 ");
INSERT INTO sny_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Awei meni Owane iyape Taiberias Sisar, Rom lo omo pani werese au noweinoweiteye. Le meni owane tutawe. Iyu menei ereti feni hesi lowe feni ta'i (15) i tepa'asiye su, awei lu owane tamo pani tewi a'i tewi a'i au noweinoweiteye. Meni owane Pontius Pailat, le omo pani Judia au noweinoweiteye. Meni owane Herot omo pani Galili au noweinoweiteye. Herot lo pa'ise Filip pani Ituria, omo pani Trakonitis aiwawe a'i, au noweinoweiteye. Meni owane Lisanias omo pani Abilene au noweinoweiteye. ");
INSERT INTO sny_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Nowe ape se au heseyei lu owane hesi a'i iyape Anas, sosu Kaiafas, lowesi Owane Sitewi lo wesi tutawe au noweinoweiteye. Sosu a'i pe Owane Sitewi lai meni Jon ma'e peri ta au te'eye. Jon Sekaraia lo meni eime pani ariye a'i saro howeiteye. ");
INSERT INTO sny_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Le Owane Sitewi lo peri wanuwe su, le pani ariye a'i arunatiyewe, Sa'i Jordan tewiye feni ma'e fi. Le lu taune werese ma'e apou eiye, “Fene werese yo seni luwaru a'i fene lo me'iyeni ma'e atati arunatire. Owane Sitewi ma'e si tame atati awetotire. Fene Owane Sitewi ma'e si tame atati awetotiyei su, ane fene werese sa'i se au huwei. Owane Sitewi lai yo seni luwaru werese a'i fene lo au sasari pamoweyei.” Ap 13:24 ");
INSERT INTO sny_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Owane Sitewi lo peri au te'e siye meni ta iyape, Aisaia, le meni Jon ne apou leseye. “Meni ta peri erasi pani ariye a'i sahe apou au uterowa. Apou au uterowa, ‘Fene werese Meni Owane Pefine lo yo mai aiyeyei ape au ariariye naneire. Yo mai lo au toso fareraiyere. ");
INSERT INTO sny_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Nepesi werese awei horuse fu teme'eriyere. Omo werese horuse fiyarisawire. Omo werese yo mai lo, onu tawesisiya ape, horuse fiyarisawire. Yo mai, ape'i ape'iyei ape, fene fareraiyere. Yo tapiye a'i se, fene tapiye werese horuse sasarire. Serai yo mai ape lo potu wisere a'i heneraiyei. ");
INSERT INTO sny_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Meni ape aiyerowa su, le lu taune werese, yo seni luwaru a'i iroteye ape, ete hene anirowa. Le yo seni luwaru werese a'i au sasari tepa'asirowa. Lu taune werese werese Owane Sitewi lo kairefiyeyei siyerowa.’” ");
INSERT INTO sny_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Serai meni Jon lu taune, le ma'e ani huwei ne fai ape, le lowe ma'e apou te'eye, “Fene haru aimesi lo yene, fene piyene fai awere? Eiwerai fene ma'e au te'eye, ‘Fene etiri luwaru a'i irowei su, Owane Sitewi lai etiri luwaru a'i itiya'u auwei. Serai fene ane ma'e sa'i ani huwei ne fai.’ Mt 12:34; 23:33 ");
INSERT INTO sny_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Serai fene ane ma'e sa'i ani huwei ne aiyeyei su, fene yo seni luwaru a'i werese fene lo arunatire. Marepi fene lo Owane Sitewi ma'e si tame atati awetore. Fene apou owe ape te'ere. ‘Meni Abraham ya'ariyei nomo lo ne. Nomo Owane Sitewi lo nihe se lu taune aseyaro a'i ne.’ Wawero tene! Ane fene ma'e au te'esiya. Owane Sitewi Pefine a'i, le a'i lai tapiye eite mo se Abraham lo eimane au ta'ane heneraiyei. Jo 8:33,39 ");
INSERT INTO sny_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Owane Sitewi lo peri ape apou wou a'i te'esiya, ‘Me ta me so wisere a'i ta'e ta'ame su, lu tamo lai me ape ourowawe, yehe ma'e fusawirowa.’” Mt 7:19 ");
INSERT INTO sny_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Lu taune werese peri lo wanuwe su, mi mi werese lowe le ma'e te'e toweriteye. “Nomo eiwerou irowei awere?” ");
INSERT INTO sny_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Le lowe ma'e itiya'u eiye, “Meni ta ipari tahe hesi irosiya ape, le meni ariye a'i ape ma'e ipari tahe ta'i aure. Meni ta ene ayei tamo futeyei su, le meni, lau a'i irosiya ape, meni ape ma'e nonere.” ");
INSERT INTO sny_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Nowe ta se Takis ma'aru ani siye lu tamo lowe meni Jon ma'e sa'i au ani huwei ne fai. Lowe le ma'e te'e toweriye, “Atuatu siye meni, nomo eiwerou irowei awere?” Lu 7:29 ");
INSERT INTO sny_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Sosu le lowe ma'e itiya'u eiye, “Fene lu taune werese ma'e owe ape arearere. Fene lowe lo ma'aru owe ape ta'arei anire. Awei meni owane takis ma'aru tewi a'i ariariyeye. Takis ma'aru ape a'i anire. Ma'aru tere'e tomu ne'ese owe ape ta'arei anite.” ");
INSERT INTO sny_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ai atu siye lu tamo le ma'e te'e toweriyei ne fai. Lowe apou ei toweriye, “Ne nomo ne totere. Nomo eiwerou irowei awere?” Sosu le lowe ma'e itiya'u eiye, “Fene lu ta lo ma'aru owe ape ai atu ta'arei anite. Fene peri me'iyeni ma'e tiyati owe ape te'e narute. Ma'aru towafi fene lo, fene aniyei ape, fene marepi fetane a'i totete.” ");
INSERT INTO sny_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Lu taune tomu ne'ese Jon ne marepi erasi a'i tote tiyatiteye. “Meni Jon eiwerai awere? Meni ape Krais awere? Le meni ape Owane Sitewi lai ariariyeye ape awere? Piyete awere? Tu naifa Owane Sitewi lai ya'ariyei nomo lo ma'e peri te'e naneiyei ta auwe. Nomo, meni ape lo aiyeyei ape ne, ninawesiya.” ");
INSERT INTO sny_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Sosu Jon peri lowe lo wanuwe su, le lowe ma'e itiya'u eiye, “Fene ane ma'e siyere. Ane meni Krais se ta'ama. Ane sa'i wara'i a'i se fene au huwei ne fai. Meni ta ane mo'o aiyeyei ape, le Meni Owane Pefine a'i ne. Ane meni yahowa'i a'i ne. Ane lowe tahe lo wafei ani tahe eraurowata. Meni ape aiyeyei su, le fene ma'e Owane Sitewi lo Hepene Wara'i a'i se au huwei. Yehe aiwawe a'i se au hu-wei. Ap 13:25 ");
INSERT INTO sny_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Meni ape aiyeyei su, le meni ta wou a'i nau teineyei ne fi. Le nau hamei teineyei su, nau fi le'iye papu itorowa. Nau hamei seni ani fusawiyei. Nau teine tepa'asiyei su, le nau motowe se weniyei. Wesi sahe fuwei. Nau hamei seni foro'o a'i su, le yehe sahe fusawiyei. Yehe ape noruwerowata.” ");
INSERT INTO sny_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Serai Jon lu taune werese ma'e Owane Sitewi lo peri heneruwe wisere a'i peri morose se au te'e atuatu fiyariye. ");
INSERT INTO sny_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","22","Nowe ta se Jon lu taune tamo ma'e sa'i se au huteye su, meni Jisas Jon ma'e sa'i se ani huwei ne fai. Sosu, Jisas Owane Sitewi ma'e au te'eye su, Owane Sitewi lai ni'arawe aine erauwiye. Owane Sitewi lo Hepene Wara'i a'i le ma'e irowe sapuwe wou a'i iyo'o sahe sine onurai. Peri ahi morose erasi a'i hire ma'e itorai. Jisas ma'e apou eiye, “Wanure! Ne meni eime ano ne! Ane ne ne marepi erasi a'i tote wawesiyenamisiya. Etiri werese no, ne iroteye ape, ane ne ne au wisereye nine'isiya.” Nowe mo'o ta se Jon meni Jisas sa'i au hu tepa'asiye su, le awei Owane Herot ma'e apou eiye, “Ne yo seni luwaru a'i irowe. Ne pa'ise no lo tani Herodias tafa'e yo seni luwaru a'i iroteye. Yo seni werese no luwaru a'i ne.” Herot Jon lo peri wanuwe su, le Jon ma'e ai marepi erasi a'i toteye. Le Jon kalabus wesi ma'e hene fu arunari. Mt 14:3-4; Mk 6:17-18; Jo 1:32 ");
INSERT INTO sny_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Sosu a'i pe Jisas nowe iyu menei meni ta werese, meni tere'e ta ereti feni hesi a'i (30) iroteye. Nowe ape se le wiyawi tutawe lo ta'aneye. Lu taune tamo le ne apou toteye, “Meni ape Josep lo meni eime awere?” Josep, Eli lo meni eime. ");
INSERT INTO sny_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli, Matat lo meni eime. Matat, Livai lo meni eime. Livai, Melki lo meni eime. Melki, Janai lo meni eime. Janai, Josep lo meni eime. ");
INSERT INTO sny_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josep, Matatias lo meni eime. Matatias, Amos lo meni eime. Amos, Nahum lo meni eime. Nahum, Esli lo meni eime. Esli, Nagai lo meni eime. ");
INSERT INTO sny_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai, Mat lo meni eime. Mat, Matatias lo meni eime. Matatias, Semen lo meni eime. Semen, Josek lo meni eime. Josek, Joda lo meni eime. ");
INSERT INTO sny_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda, Joanan lo meni eime. Joanan, Resa lo meni eime. Resa, Serubabel lo meni eime. Serubabel, Sealtiel lo meni eime. Sealtiel, Neri lo meni eime. ");
INSERT INTO sny_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri, Melki lo meni eime. Melki, Adi lo meni eime. Adi, Kosam lo meni eime. Kosam, Elmadam lo meni eime. Elmadam, Er lo meni eime. ");
INSERT INTO sny_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er, Josua lo meni eime. Josua, Elieser lo meni eime. Elieser, Jorim lo meni eime. Jorim, Matat lo meni eime. Matat, Livai lo meni eime. ");
INSERT INTO sny_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Livai, Simeon lo meni eime. Simeon, Juda lo meni eime. Juda, Josep lo meni eime. Josep, Jonam lo meni eime. Jonam, Eliakim lo meni eime. ");
INSERT INTO sny_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim, Melea lo meni eime. Melea, Mena lo meni eime. Mena, Matata lo meni eime. Matata, Natan lo meni eime. Natan, Devit lo meni eime. ");
INSERT INTO sny_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Devit, Jesi lo meni eime. Jesi, Obet lo meni eime. Obet, Boas lo meni eime. Boas, Salmon lo meni eime. Salmon, Nason lo meni eime. ");
INSERT INTO sny_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason, Aminadap lo meni eime. Aminadap, Atmin lo meni eime. Atmin, Arni lo meni eime. Arni, Hesron lo meni eime. Hesron, Peres lo meni eime. Peres, Juda lo meni eime. ");
INSERT INTO sny_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda, Jekop lo meni eime. Jekop, Aisak lo meni eime. Aisak, Abraham lo meni eime. Abraham, Tera lo meni eime. Tera, Nahor lo meni eime. ");
INSERT INTO sny_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor, Seruk lo meni eime. Seruk, Reu lo meni eime. Reu, Pelek lo meni eime. Pelek, Eber lo meni eime. Eber, Sela lo meni eime. ");
INSERT INTO sny_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela, Kainan lo meni eime. Kainan, Arpaksat lo meni eime. Arpaksat, Siem lo meni eime. Siem, Noa lo meni eime. Noa, Lamek lo meni eime. ");
INSERT INTO sny_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek, Metusela lo meni eime. Metusela, Enok lo meni eime. Enok, Jaret lo meni eime. Jaret, Mahalalel lo meni eime. Mahalalel, Kainan lo meni eime. Kainan, Enos lo meni eime. ");
INSERT INTO sny_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Enos, Set lo meni eime. Set, Adam lo meni eime. Adam, Owane Sitewi lo meni eime. Owane Sitewi lai Adam awei peperi se ta'aneye. ");
INSERT INTO sny_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Owane Sitewi lo Hepene Wara'i a'i Jisas lo marepi papu teme'eriyeye. Jisas Sa'i Jordan arunati su, Owane Sitewi lo Hepene Wara'i a'i lai le pani ariye a'i ma'e heneti. ");
INSERT INTO sny_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Nowe mi pasi lu hesi werese (40) Satan Jisas lo marepi luwaruweyei ne toteye. Nowe werese ape Jisas etiri werese ene a ta'ame. Nowe werese ape i tepa'asiye su, le lau erasi mase teriteteye. ");
INSERT INTO sny_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Sosu sepei Satan le ma'e eiye, “Ne Owane Sitewi lo meni eime pefine a'i su, ne tapiye eite ma'e apou eire, ‘Tapiye, ne nau ta'ase wou aresaiye heneraire.’” ");
INSERT INTO sny_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jisas le ma'e itiya'u eiye, “Wanure! Owane Sitewi lo peri sahe meni ta apou leseye, ‘Lu werese nau ta'ase a'i ene arowata.’” ");
INSERT INTO sny_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Serai sepei Satan lai Jisas omo erasi a'i hire ma'e hene yaneye. Le Jisas omo pani werese werese nowe witane se a'i au atuatu areiyeye. ");
INSERT INTO sny_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","Sosu sepei Satan le ma'e eiye, “Ne ane ma'e lowe uporo ape'i onurowawe, ane ma'e au te'e wisereyeyei su, ane ne ma'e omo pani werese werese a'i aunamiyei. Owane Sitewi lai tu naifa weriyei awei pani werese werese ane ma'e auwe. Serai ane marepi ano umasiyei. Ane fara'u meni ta ma'e tewi a'i auwei.” ");
INSERT INTO sny_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Sosu Jisas le ma'e itiya'u eiye, “Owane Sitewi lo peri sahe meni ta apou leseye, ‘Fene Owane Sitewi Pefine a'i ma'e au te'e wisereye nine'ite. Fene le ma'e lowe uporo ape'i onute.’” ");
INSERT INTO sny_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Serai sepei Satan lai Jisas omo Jerusalem ma'e si tame heneti. Le Jisas Owane Sitewi lo wesi tutawe me'iye ma'e hene wiye. Le Jisas ma'e eiye, “Ne Owane Sitewi lo meni eime pefine a'i su, ne topo ne hi ma'e fu ye'i arore.” ");
INSERT INTO sny_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Piyene awere? “Owane Sitewi lo peri sahe apou leseye, ‘Le ipari werese lo le ne au noweinoweiyei ne eimawe arosaiyei.’” Sepei Satan apou tame eiye, ");
INSERT INTO sny_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","“Meni tere'e apou leseye, ‘Owane Sitewi lai ipari tamo lo le ma'e eimawe arosaiyei. Lowe le ma'e ereti se anite tawesirowa. Serai tapiye werese lowe no tewirowata.’ Serai ne Owane Sitewi lo wesi me'iye hi ma'e winetaiyei su, Owane Sitewi lai ipari werese lo ne ma'e au noweinoweiyei ne eimawe arosairowa.” ");
INSERT INTO sny_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Sosu Jisas le ma'e itiya'u eiye, “Owane Sitewi lo peri apou te'eye. ‘Ne Owane Sitewi Pefine a'i no owe ape te'e arearete.’” ");
INSERT INTO sny_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Sepei Satan Jisas lo marepi meme'iyei ne tote tepa'asiye su, le Jisas arunatiyewe fi. Nowe mo'o ta se le Jisas lo marepi si tame meme'irowa. Hi 2:18; 4:15 ");
INSERT INTO sny_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Owane Sitewi lo Hepene Wara'i a'i lo kairefiyeyei Jisas mase ironamiteye. Jisas omo pani Galili si tame fi. Pani Galili ma'e heneri su, lu taune tomu ne'ese omo omo werese sahe Jisas fai ape ne, peri heneruwe lo wanuwei ne ta'uwerai. ");
INSERT INTO sny_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Sosu le ta'uweyei wesi werese papu wiye su, le Owane Sitewi lo peri lu taune ma'e au te'e fiyariye. Lowe peri lo wanuwe su, lowe le ma'e au te'e wisereyeye. ");
INSERT INTO sny_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Le Omo Nasaret ma'e omo sitewi lo heneri. Owane Sitewi lo nowe amou (Sabat) ariariyeye ape se, le ta'uweyei wesi papu Owane Sitewi lo peri au te'eyei ne wiye. Nowe ape se Juda lo lu taune Owane Sitewi ma'e au te'e wisereye nine'iteye. Le ta'uweyei wesi papu wiye. Le ponei sahe teiyewe, Owane Sitewi lo peri one towe sahe siye te'eye. ");
INSERT INTO sny_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Meni ta, one towe Aisaia leseye ape, Jisas ma'e siye te'eyei ne auwe. Jisas one towe aniye su, le peri ta siye nehiteye. Peri ta siyeye su, le apou siye te'eye. “Owane Sitewi lo peri sahe apou leseye. ");
INSERT INTO sny_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","‘Meni Owane Pefine lo Hepene ane mase ironamisiya. Le ane lu taune ma'e etiri ariye a'i irosiya ape, Owane Sitewi lo peri au te'eyei ne ariariyeye. Le ane ma'e apou te'eye. Ne kalabus lo wesi ma'e ire. Lu taune werese, kalabus wesi irosiya ape, ma'e eire, fene werese kalabus wesi fu arunatire. Le ane lu taune werese nihe pokowe se ma'e eimawesawi. Ane ma'e apou eiye, Ne lu taune nihe pokowe se werese nihe lowe lo au petanere. Ai atu siye lu tamo lu taune ma'e au luwaruweyei su, ne lowe ma'e au pati ta'aneyei ne ire. ");
INSERT INTO sny_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Owane Sitewi lo Hepene Wara'i a'i ane ma'e tame eiye, ne lu taune werese ma'e apou au te'erire. Nowe mo'o ta se Meni Owane Pefine a'i lai au pati ta'ane siye meni fene ma'e eimawesairowa.’” ");
INSERT INTO sny_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jisas siye te'e tepa'asiye su, le one towe ape ti tawesiye. Meni ta ma'e si tame auwe. Le one towe si tame au tepa'asiye su, le saro onuwe. Lu taune werese ta'uweyei wesi sahe le ma'e siye etiye. ");
INSERT INTO sny_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Sosu le lowe ma'e au te'eye, “Pereye Owane Sitewi lo peri fene wanuwe ape, le ane ne au te'eye. Serai ane fene ma'e henerai paite.” ");
INSERT INTO sny_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Lowe werese peri lo wanuwe su, lowe le ne marepi wisere a'i toteye. Lowe apou toteye, “Meni ape Josep lo meni eime awere? Peri ape, le nomo ma'e au te'eye ape, wisere a'i ne.” Lu 3:23; Jo 6:42 ");
INSERT INTO sny_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Sosu le lowe ma'e eiye, “Atu, fene ane ma'e peri ta apou eiyei, ‘Dokta, ne u tahe topo lo au ta'ane fara'uwere.’ Fene ane ma'e au te'eyei, ‘Etiri werese omo Kaperneam sahe, ne irowe ape, ne omo sitewi no Nasaret sahe aiwawe a'i fa irote.’” ");
INSERT INTO sny_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Sosu le lowe ma'e tame eiye, “Peri ano wiyeme a'i, ane fene ma'e eisiya, lu taune werese Owane Sitewi lo peri au te'e siye meni lo omo sitewi irosiya ape, lowe le ma'e au wisereye ta'ame. Jo 4:44 ");
INSERT INTO sny_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ahowa, ane fene ma'e peri wiyeme a'i se eisiya, tu naifa weriyei nowe Elaija se taune weiname tomu ne'ese pani Israel sahe iroteye. Nowe ape se, Owane Sitewi lai ni'arawe werese ti tawesinamiye. Nowe iyu menei hesi heta (3) yame ereti feni werese, feni ta'i a'i (6) sa'i ito ta'ame. Lu taune werese lau erasi a'i henerai. Pani werese sahe ayei werese ariye. 1 Kin 17:1,7 ");
INSERT INTO sny_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Owane Sitewi lai meni Elaija Israel lo taune weiname eimawesawi ta'ame. Ahowa, le menitani weiname omo Sarafat, omo pani Saidon sahe eimawesawi. 1 Kin 17:8-16 ");
INSERT INTO sny_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Aiwawe a'i Elisa lo nowe se Owane Sitewi lo peri au te'e siye meni, lu taune tomu ne'ese enite kairefi a'i, iyape lepra, pani Israel sahe iroteye. Meni ta'i a'i iyape Naman enite kairefi a'i ape niyemaiye po'uteye. Le pani Siria saro iroteye. Lowe werese Israel sahe enite kairefi a'i lepra ironamiteye ape, enite kairefi a'i lowe lo ironamiteye.” 2 Kin 5:1-14 ");
INSERT INTO sny_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Jisas Owane Sitewi lo wesi tutawe sahe peri ape au te'eteye su, lu taune tomu ne'ese le ne ai marepi erasi toteteye. ");
INSERT INTO sny_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Lowe ai marepi se sineyewe, Jisas ma'e omo nowe ma'e hene ani fu arosawi. Lowe le omo nipe ta ma'e heneti. Omo nipe ape sahe lowe omo Nasaret ta'aneye. Lowe Jisas omo nipe topo'o hi ma'e ani fu arowei ne toteye. ");
INSERT INTO sny_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ahowa, le lowe werese ponei sahe awera'iyenatiyewe fi. ");
INSERT INTO sny_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Sosu a'i pe le lowe awera'iyenatiyewe fi su, le omo Kaperneam, hi ma'e itori. Omo Kaperneam, Galili lo pani tewi a'i ne. Sosu le lu taune werese ma'e Owane Sitewi poweiye amou werese au te'e fiyariteye. Poweiye ape se Juda lo lu taune werese Owane Sitewi ma'e au te'e wisereye nine'iteye. ");
INSERT INTO sny_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Le peri werese lo au te'eye su, le peri lo kairefi a'i au te'eteye. Lu taune werese peri lo wanuwe su, lowe peri ape ne hepene se su'ariye. Mt 7:28-29 ");
INSERT INTO sny_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Nowe ta se le Owane Sitewi lo wesi sahe le meni ta, sepei luwaru a'i ironamiteye ape, siyeye. Meni ape Jisas ma'e peri morose erasi uteye, ");
INSERT INTO sny_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Jisas, Nasaret lo meni, ne piyene fai awere? Ne sepei werese aine tera'eyei ne fai awere? Ane ne so'oruwesiya tene! Ne Owane Sitewi lo meni wara'i a'i ne. Ne Owane Sitewi ma'e itorai ne.” ");
INSERT INTO sny_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Sosu Jisas sepei luwaru a'i ma'e peri lo einamiye. Le ma'e eiye, “Peri sawa! Ne meni ape nowe ma'e henera!” Sepei luwaru a'i lai meni ape hi awei ma'e ani fu arowe. Sosu le meni ape arunatiyewe, nowe ma'e henerai. Le meni ape si tame au luwaruweyei ne wi ta'ame. ");
INSERT INTO sny_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Lu taune werese etiri ape siyeye su, lowe werese hepene se su'ariye. Lowe ta'u te'e tiyatiteye. “Piye peri ape lo sitewi awere? Meni ape kairefi erasi a'i irosiya. Le sepei luwaru a'i ma'e au te'eye su, lowe werese peri lo wanu umasisiya.” ");
INSERT INTO sny_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Lu taune werese omo pani werese werese a'i Jisas lo peri heneruwe ape wanuwe. ");
INSERT INTO sny_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Sosu a'i pe Jisas Owane Sitewi lo wesi arunatiyewe fi. Le meni Saimon lo wesi ma'e fi. Saimon lo mai pape tahe umeri a'i iroteye. Lu tamo Jisas ma'e menitani ape ne te'e toweriye, “Ne fara'u menitani lo tahe umeri a'i au ta'ane sasariyei awere?” ");
INSERT INTO sny_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Sosu le menitani atahe a'i teiye su, le tahe umeri ape ma'e apou eiye, “Tahe umeri ape, menitani ape sahe arunatire.” Peri lo te'e tepa'asiye su, tahe umeri a'i ape arunati fara'uweye. Le sineyewe, ene ayei tamo lowe au ene aye. ");
INSERT INTO sny_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nowe neriwei poweiye itori su, lu tamo, lu taune tomu ne'ese u tahe tere'e tere'e se ape mo Jisas ma'e henetai. Le lowe werese ma'e ereti topo lo se fuwe. Serai lowe werese u tahe ape au ta'ane fara'uweye. ");
INSERT INTO sny_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Aiwawe a'i le lu taune tomu ne'ese sepei luwaru a'i iroteye ape, le ipari werese lowe nowe ma'e na'ari sasarisawi. Sepei lowe nowe ma'e henerai su, lowe hare erasi uteye, “Ne Owane Sitewi lo meni eime ne.” Sosu le peri lowe lo werese einamiye. Lowe werese Jisas ne so'oruweteye tene! Lowe apou toteye, “Owane Sitewi lai Jisas lu taune werese lo yo seni luwaru a'i au sasariyei ne eimawesai. Serai Jisas peri werese lowe lo einamiye.” Mt 8:29; Mk 3:11-12 ");
INSERT INTO sny_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Nowe esi pasi su, le Saimon lo wesi arunatiyewe, pani lu ta'ama ape ma'e fi. Lu taune tomu ne'ese Jisas nehitiye. Lowe le siyeye su, lowe le ma'e einamiyei ne toteye. Le lowe mase weriyei weriyei fa ironamite. Serai lowe le ne einamiyei ne toteye. ");
INSERT INTO sny_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Serai le lowe ma'e eiye, “Ane Owane Sitewi lo peri werese lu taune omo omo tere'e ma'e fa au te'e fiyariyei. Owane Sitewi lai ane wiyawi ape au te'eyei ne eimawe arosai.” ");
INSERT INTO sny_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Sosu le mi mi werese ta'uweyei wesi werese sahe, pani Judia iroteye ape, lu taune werese ma'e au te'e fiyari areiyenamiteye. Mt 4:23 ");
INSERT INTO sny_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Nowe ta se lu taune tomu ne'ese Jisas ma'e Owane Sitewi lo peri wanuwei ne ta'uwerai. Le au te'eye su, lu taune werese le ma'e tei ataheyetiteye. Le hare ite Galili lo tewiye sahe teiteye. Mt 13:1-2; Mk 3:9-10 ");
INSERT INTO sny_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Le wai hesi a'i sa'i tewiye sahe siyeye. Lu ape mo wai sa'i tewiye sahe teiyewe, lowe hare honaiye oro'oru a'i au sasariteye. ");
INSERT INTO sny_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Sosu Jisas wai ta papu wi atowe. Le Saimon lo wai papu aro atowe. Le Saimon ma'e eiye, “Wai no sa'i se erou oso a'i tewi itesawire.” Wai sa'i ma'e tewi itesawi su, le wai pihatu saro onuteye. Le lu taune werese ma'e Owane Sitewi lo peri au te'e atuatuteye. ");
INSERT INTO sny_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Le peri au te'e tepa'asiye su, le Saimon ma'e eiye. “Hare ite ponei ma'e tewi itesawire. Hare honaiye no sa'i papu fu arore. Ne hare tomu ne'ese aniyei.” ");
INSERT INTO sny_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Saimon le ma'e itiya'u eiye, “Meni Owane, nowe pasiyeye su, nomo hare honaiye sa'i papu ani fu arowe. Nomo hare tamo ani ta'ame. Nomo wiyawi erasi ta'ane tohoteteye, hare werese ariye. Fara'u, nomo peri no umasiyei. Nomo hare honaiye sa'i papu tame ani fu arowei.” Jo 21:3-8 ");
INSERT INTO sny_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Sosu lowe hare honaiye ani fu arowe su, hare tomu ne'ese hare honaiye sahe ti tawesiye. Hare tomu ne'ese honaiye ti tawesiye su, hare honaiye apetiyei wou irowe. ");
INSERT INTO sny_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Hare honaiye apetiyei ne irowe su, lowe lu disaipel lowe lo ei aniye. Hare honaiye fa ni'ariye wirai ne. Lowe hare honaiye lowe lo arunatiyewe, lowe Saimon lo hare honaiye aiwawe ni'ariye wiraiyei ne fi. Lowe hare tomu ne'ese wai hesi ape papu ani asiye. Hare ani asi tepa'asiye su, hare tomu ne'ese lai wai hesi ape teme'eriyeye. Hare wai hesi ape teme'eriyeye su, wai lowe lo aporu itowei ne ataheyeye. ");
INSERT INTO sny_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Serai Saimon Pita etiri werese siyeye su, le Jisas ma'e lowe uporo sahe ape'i onuwe. Le Jisas ma'e eiye, “Meni Owane ano, ane meni luwaru a'i ne. Yo seni werese ano unou a'i ne. Ne ane pei arunatire.” ");
INSERT INTO sny_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Le peri ape au te'eye su, le hare tomu ne'ese a'i, aniye ape ne, toteye. Serai le lu disaipel lo aiwawe a'i lowe marepi hepene se su'ariye. ");
INSERT INTO sny_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Lu hesi tere'e Saimon lo lu disaipel lowesi lo iyape apou a'i Jems, pa'ise lo Jon. Lowesi lo tai iyape Sebedi. Sosu Jisas Saimon ma'e apou eiye, “Ne taweiru sawa! Ne hare ani siye yo arunatiyei. Ne wiyawi he'i aniyei. Ne lu taune ane ma'e henetainamirowa.” ");
INSERT INTO sny_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Lowe wai sa'i tewi ma'e furi su, lowe etiri werese arunati, Jisas mase umasinamiteye. Mt 19:27 ");
INSERT INTO sny_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Nowe ta se le omo ta heneri. Omo ape sahe meni ta enite kairefi tomu ne'ese se, iyape lepra, ironamiteye. Meni ape Jisas siyeye su, le Jisas ma'e lowe uporo ape'i onurai. Le Jisas ma'e apou ei toweriye, “Meni Owane, ne marepi no umasiyei su, ne fara'u enite werese ano eite mo au ta'ane niyemaiyere. Serai tahe ano wara'i a'i heneraiyei.” ");
INSERT INTO sny_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Serai Jisas meni ape lo peri wanuwe su, le ereti lo se meni ape lo tahe sahe isawe heteye. Le meni ape ma'e eiye, “Ei! Ane marepi ano umasiyei. Enite kairefi a'i no niyemaiyeye.” Jisas peri te'e tepa'asiye su, pereye a'i enite kairefi lo niyemaiye tepa'asiye. ");
INSERT INTO sny_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Sosu Jisas le ma'e apou eiye, “Ne lu taune werese ma'e owe ape te'ere. Ahowa, ne enite werese no, niyemaiyeye ape, au heseyei meni owane ma'e au atuature. Ne au heseyei meni owane ma'e iyei su, ne ayei ta Owane Sitewi ma'e au heseyei ne aiti. Tu naifa weriyei meni Moses Owane Sitewi lo peri apou leseye. Ne Moses lo yo peri umasire. ‘Au heseyei meni owane enite kairefi a'i no niyemaiye tepa'asiye ape, siyeye su, lowe tahe no wara'i a'i au ei fara'uweye.’” ");
INSERT INTO sny_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Jisas lo peri heneruwe omo pani werese wanuwe su, lu taune tomu ne'ese Jisas ma'e peri lo wanuwei ne ta'uwerai. Lowe lu taune u tahe se Jisas ma'e fa au ta'ane fara'uweyei ne henetai. ");
INSERT INTO sny_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Lu taune tomu ne'ese Jisas ma'e tei ataheye teititeye su, nowe tomu ne'ese Jisas eresene a'i ipo ma'e Owane Sitewi ma'e au te'e tiyatiyei ne fi. ");
INSERT INTO sny_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nowe ta se Jisas lu taune ma'e au te'e fiyariteye su, au heseyei lu owane tame, lu Farisi tamo, Owane Sitewi lo yo peri so'oru siye lu tamo aiwawe a'i, lowe lu taune werese mase Jisas lo peri wanuwei ne ta'uwe onurai. Lowe omo pani werese Galili sahe, omo pani Judia werese, sosu omo Jerusalem ma'e fai. Lowe lu taune werese mase Jisas lo peri wanuwei ne ta'uwerai. Owane Sitewi Pefine a'i lai Jisas ma'e kairefiyeyei erasi a'i u tahe ta'ane fara'uweyei ne auwe. ");
INSERT INTO sny_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Le lu taune ma'e au te'eteye su, lu tamo meni ta'i wari se sutaitetai. Meni ape lowe hesi nono'oweyei a'i ne. Le uweirowata. Lu ape mo meni ape wari se sutaitetai su, lowe le Jisas ma'e sutaiterowata. ");
INSERT INTO sny_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Lu taune tomu ne'ese wesi yo sahe tei tawesiye. Lowe meni ape wesi me'iye hire ma'e sutaite wiye. Lowe wesi otowe me'iye ponei tepi'owe. Sosu lowe meni ape, wari sahe howeiye ape, wafei se hi ani ararowe. Lowe meni ape ponei sahe Jisas lo nihari ma'e hi ani ararowe. ");
INSERT INTO sny_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Sosu Jisas tote tawesiyei lowe lo siyeye su, le meni ape ma'e apou eiye, “Kaiyemo, ane yo seni luwaru werese a'i no au ta'ane sasari pamoweyei.” Lu 7:48; Ais 43:25 ");
INSERT INTO sny_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Owane Sitewi lo yo peri so'oruwe siye lu, lu owane Farisi aiwawe a'i Jisas lo peri wanuwe su, lowe apou te'e tiyatiteye. Lowe apou eiye, “Meni ape le Owane Sitewi ne au te'e naruwe. Eiwerai awere? Owe meni ta lai yo seni luwaru a'i au ta'ane sasarirowata. Owane Sitewi ta'i a'i lai yo seni luwaru a'i au ta'ane sasariei.” ");
INSERT INTO sny_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jisas marepi lowe lo siye so'oruwe tepa'asiye su, le lowe ma'e apou eiye, “Fene piyene marepi totesiya awere? ");
INSERT INTO sny_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ane fene ma'e peri hesi ei toweriye. Ane meni ape ma'e au te'eyei su, ane yo seni luwaru a'i werese no au ta'ane sasari pamowesiya. Peri ano ape wiyeme a'i awere? Peri wawero a'i awere? Fene siye so'oruwerowata. Ahowa, ane meni ape ma'e au te'eye su, ‘Meni, sinere! Hese howeiyei tapi no ani woronere.’ Fene peri ano wiyeme a'i siyeyei awere? Piyete awere? Marepi ano apou a'i totesiya. Meni ape, lowe hesi haroharo a'i iroteye ape, uwei ye'i sineyei su, fene peri wiyeme a'i ano siye so'oruwe tepa'asiyei. ");
INSERT INTO sny_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Fene wanure! Fene etiri ta pei siye so'oruwere. Ane meni ape, omo hire ma'e itorai ape, Owane Sitewi lai ane ma'e kairefiyeyei lo auwe. Owane Sitewi lo kairefiyeyei se ane fara'u meni ape lo lowe haroharo hesi a'i ape au ta'ane kairefiyerowa.” Sosu ne peri ano wiyeme a'i siye so'oruwerowa. Serai le meni ape siye etiyewe, le ma'e eiye, “Meni, ane ne ma'e eisiya, Sinere! Hawaiye no ani woronere. Wesi no ma'e ire!” Jo 5:8 ");
INSERT INTO sny_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Pereye a'i meni ape sineye. Le hawaiye lo ani woroneye. Wesi lo ma'e fi. Le wesi nowe ma'e heneye su, le Owane Sitewi ma'e au te'e wisereyenamiteye. ");
INSERT INTO sny_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Lu taune werese Jisas lo peri wanuwe su, lowe marepi hepene se su'ariye. Lowe werese Owane Sitewi ma'e au te'e wisereyenamiteye. Lowe werese marepi atoweiye a'i ne. Lowe peri te'e tiyatiteye. “Nowe pereye nomo etiri erasi pefine a'i siye areiye tepa'asiye.” ");
INSERT INTO sny_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Le peri te'e tepa'asiye su, le wesi papu arunatiyewe, nowe ma'e heneye. Le meni ta'i iyape Matyu siyeye. Le takis lo wesi sahe onuteye. Meni ape lo wiyawi apou a'i, takis ma'aru ani siye meni. Jisas meni ape ma'e eiye, “Ne ane mo'o umasita.” ");
INSERT INTO sny_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Meni ape Jisas lo peri wanuwe su, le etiri werese arunatiyewe, Jisas mo'o umasiti. ");
INSERT INTO sny_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Nowe pereye, lowesi Livai lo wesi ma'e fi. Le Jisas ma'e ayei erasi ta'uwe hereiyei au irowe. Lu tomu ne'ese Livai lo wesi sahe ene ayei ne ta'uwerai. Takis ma'aru ani siye lu tomu ne'ese, lu tere'e tere'e tomu ne'ese aiwawe a'i ei ta'uwerai. Lowe werese Jisas mase ene ateye. ");
INSERT INTO sny_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Lu Farisi tamo, Owane Sitewi lo yo peri lese siye lu tamo, lowe Jisas lo lu feni ma'e ai peri te'eye. Lowe apou te'eye, “Fene piyene takis ma'aru ani siye lu tamo, sosu lu yo seni luwaru a'i mase ene asiya awere?” Lu 15:1-2 ");
INSERT INTO sny_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jisas peri lowe lo wanuwe su, le lowe ma'e itiya'u apou eiye, “Fene u tahe se iroteyei su, fene meni dokta siyenari. Fene tahe u ta'ame su, fene meni dokta siyenarirowata. ");
INSERT INTO sny_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ane lu taune werese yo seni wara'i a'i irosiya ape, ei aniyei ne fai ta'ama. Ahowa, ane lu taune werese yo seni luwaru a'i ape ei aniyei ne fai. Lowe, yo seni luwaru a'i iroteye ape, me'iyeni ma'e pei atati arunatire.” ");
INSERT INTO sny_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Sosu lowe Jisas ma'e eiye, “Jon lo lu feni mi mi werese ayei werese lowe lo siyenamiye. Lowe ayei siyenamiyei su, lowe Owane Sitewi ma'e au te'eyei. Lu Farisi lo lu feni aiwawe a'i ironamisiya. Ahowa, siyere! Lu feni no erasi a'i ene asiya. Lowe sa'i tomu ne'ese asiya. Piyene lowe ene asiya awere?” ");
INSERT INTO sny_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Sosu Jisas lowe ma'e eiye, “Ane peri anowe ta fene ma'e au te'eyei. Nowe ta se meni ta tani lo naituwei su, lu werese fai ape, marepi wisere a'i irowei. Meni ape tani naituwei su, lu werese ayei siyenamirowata. Jo 3:29 ");
INSERT INTO sny_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Nowe mo'o ta aiyerowa su, meni ta, tani naituwei ape, lowe le ma'e henetirowawe, aine tera'erowa. Nowe ape se lowe ayei werese siyenamirowa. ");
INSERT INTO sny_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ane peri anowe tere'e fene ma'e au te'eyei. Meni ta ipari tahe he'i a'i aniyei su, le tewi a'i ani erauwirowata. Sosu ipari tahe weriyei sahe iwisiyei. Ahowa, le ipari tahe he'i tewi a'i ani tapetiyei su, le ipari tahe he'i a'i au luwaruweyei. Ipari tahe tewi a'i ani erauwirowawe, sosu ipari tahe weriyei ma'e iwisiyei su, ipari tahe tewi a'i ape aiwawe ta'ame. ");
INSERT INTO sny_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Meni ta wain sa'i he'i a'i ta'aneyei su, le fe meme lo tahe foro'o a'i papu ani asirowata. Le wain sa'i he'i a'i fe meme tahe foro'o ani asiyei su, wain sa'i he'i ape fe meme lo tahe perati irowei. Wain sa'i werese awei sahe teroso itorowa. Aiwawe a'i fe meme lo tahe luwaru a'i heneraiyei. ");
INSERT INTO sny_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ahowa, meni ta wain sa'i he'i a'i ta'aneyei su, le fe meme lo tahe he'i a'i papu ani asiyei. ");
INSERT INTO sny_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Meni ta wain sa'i weriyei ayei su, le wain sa'i he'i ayei onota'ano a'i ne. Le apou toteyei, wain sa'i weriyei wisere a'i tene!” ");
INSERT INTO sny_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Nowe amou (Sabat) se, Jisas lu disaipel lo mase, lowe kewi ta'aneyei awei sahe iteye. Lowe ta'aneyei awei sahe iteye su, Jisas lo lu feni kewi so tamo une aniye. Lowe kewi so ereti se ani tahe sasariyewe aye. Lo 23:25 ");
INSERT INTO sny_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Lu Farisi tamo lowe siyeye su, lowe Jisas ma'e apou te'e toweriye, “Lu feni no piyene Moses lo yo peri arisisiya awere? Lowe nowe amou lo yo peri arisiye.” Jo 5:10 ");
INSERT INTO sny_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","Sosu Jisas lowe ma'e itiya'u eiye, “Fene Owane Sitewi lo peri siye te'eye ta'ama awere? Nowe ta se ya'ariyei meni owane nomo lo, Devit, lau erasi iroteye. Le Owane Sitewi lo wesi tutawe papu wiri. Le nau ta'ase amou aniyewe aye. Le lu tewi lo ma'e nau ta'ase amou ape lowe aiwawe ene ateye. Lu yahowa'i a'i werese nau ta'ase amou ape ene arowata. Amou tene! Au heseyei lu owane lowe a'i lai nau ta'ase amou ape fara'u ene arorowa. Fene nowe amou ape lo sitewi so'oru ta'ama.” 1 Sml 21:1-6; Wkp 24:5-9 ");
INSERT INTO sny_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Le lowe ma'e eiye, “Ane, meni hire ma'e itorai ape, ane nowe amou lo Meni Owane Pefine a'i ne. Ane etiri ta nowe amou ape se ta'aneyei ne toterowa su, ane etiri fara'u ta'anerowa.” ");
INSERT INTO sny_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sosu a'i pe nowe amou tere'e nowe me'iye henerai su, le lu disaipel lo aiwawe a'i ta'uweyei wesi papu wiri. Le lu taune ma'e Owane Sitewi lo peri au te'e fiyariteye. Meni ta ta'uweyei wesi sahe ereti eyate feni lo nono'oweye a'i iroteye. ");
INSERT INTO sny_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Lu Farisi tamo, Owane Sitewi lo peri lese siye lu tamo, lowe Jisas siye etinarai. Le nowe amou ape su meni ape, ereti nono'oweye a'i ape, au ta'ane fara'uweyei awere? Piyete awere? Marepi lowe lo apou a'i toteye, “Jisas poweiye amou eite se meni ape au ta'ane fara'uweyei su, nomo le awei lo meni owane ma'e etiyei ne henetiyei.” ");
INSERT INTO sny_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ahowa, Jisas marepi lowe lo siye so'oruwe tepa'asiye. Serai le meni ape ereti nono'oweye a'i ape ei aniye. Le meni ape ma'e apou eiye, “Ne sinere! Ane ma'e aiya!” Serai meni ape sineyewe, Jisas ma'e fai. ");
INSERT INTO sny_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Sosu le lowe ma'e apou eiye, “Fene ane ma'e peri ta itiya'u te'ere. Ane peri ta fene ma'e ei towerisiya. Nowe amou se, ane wiyawi wisere a'i ta'aneyei su, ane Moses lo yo peri arisiyei awere? Piyete awere? Ane etiri luwaru a'i irowei su, ane yo peri ape arisiyei awere? Ane meni u tahe erasi se ape ta'ane fara'uweyei awere? Nowe amou se ane meni ape au ta'ane fara'uweyei awere? Ane yo peri ta arisiyei awere? Ane meni ta aine tera'eyei su, ane yo peri ta arisiyei awere? Fene peri ano ane ma'e itiya'u te'ere.” ");
INSERT INTO sny_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jisas peri te'e tepa'asiye su, le lowe werese ma'e siye etiye. Sosu le meni ape ma'e apou eiye, “Ereti no au tesi fareraiyere.” Meni ape Jisas lo peri wanuwe su, ereti lo tesi fareraiyeye. Ereti tesi fareraiyeye su, ereti lo kairefi a'i henerai. ");
INSERT INTO sny_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Lu Farisi meni ape lo ereti kairefi a'i siyeye su, lowe Jisas ne ai marepi erasi a'i toteye. Lowe apou te'e tiyatiye. “Nomo Jisas eiwerou irowei awere?” ");
INSERT INTO sny_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Sosu nowe ape se, le ta'uweyei wesi arunatiyewe, omo ta yaneye. Le omo ape sahe Owane Sitewi ma'e au te'eyei ne yaneye. Nowe pasi werese se le Owane Sitewi ma'e au te'e tiyatiteye. ");
INSERT INTO sny_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Nowe esi mitaiyeye su, le lu disaipel lo ei aniye. Le lu disaipel ereti feni hesi lowe hesi a'i (12) ariariyeye. Lu ereti feni hesi lowe hesi a'i ape le lowe ma'e iyape aposel au te'e ariariyeye. ");
INSERT INTO sny_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Lu disaipel lo iyape apou a'i ne, Meni Saimon, Jisas meni ape iyape tere'e au eiye, Pita. Meni Andru, Saimon lo pa'ise, nairi hesi lo iyape Jems, Jon, Meni Filip, Meni Bartolomyu, ");
INSERT INTO sny_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Meni Matyu, meni Tomas, meni tere'e Jems, le Alfius lo meni eime. Meni tere'e Saimon. Le Rom lo lu owane ma'e ai atu tiyatiteye. ");
INSERT INTO sny_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Meni Judas, le Jems lo meni eime, meni Judas Iskariot. Nowe me'iye su le Jisas Rom lo ai atu siye lu ma'e henetirowa. ");
INSERT INTO sny_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Sosu Jisas lu disaipel lo aiwawe a'i omo ape hi ma'e itorai. Lowe nepawe potu a'i heneri. Lu taune tomu ne'ese Jisas lo peri wanuwei ne ta'uweye. Lu taune tomu ne'ese omo pani Judia ma'e fai ape, lu taune tomu ne'ese omo Jerusalem ma'e fai ape, aiwawe a'i lu taune tomu ne'ese omo Saidon, omo Tair ma'e fai ape, ");
INSERT INTO sny_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Lowe werese Jisas lo peri wanuwei ne ta'uwerai. Lu taune u tahe se lowe Jisas ma'e au ta'ane fara'uweyei ne henetai. Lu taune tamo, sepei luwaru a'i lire papu iroteye ape, Jisas sepei luwaru werese a'i au ta'ane sasarisawi. ");
INSERT INTO sny_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Lu taune tomu ne'ese apou a'i toteye, “Ane meni ape hetesiyeyei su, u tahe ano wara'i heneraiyei.” Meni ta Jisas lo ipari tahe isawe hetesiyeyei su, Jisas lo kairefi meni ape lo u tahe au ta'ane fara'uweye. ");
INSERT INTO sny_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Serai Jisas lu disaipel lo ma'e atati siyeteye. Lowe ma'e apou eiye, “Fene etiri werese ariye a'i ape, fene marepi wisere a'i irore! Owane Sitewi lai fene werese au noweinoweirowa. ");
INSERT INTO sny_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Fene lau erasi irosiya ape, fene marepi wisere a'i irore. Owane Sitewi lai lire no au a teme'eriyerowa. Fene ewite erasi lusiya ape, fene marepi wisere a'i irorowa. Nowe me'iye su, fene marepi erasi a'i nine'irowa. ");
INSERT INTO sny_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ane, meni hire ma'e itorai ape, fene peri ano wanu umasinamiyei su, lu tamo fene ne ai marepi totenamiyei. Sosu lowe fene hi ani araronamiyei. Sosu lowe fene ma'e peri te'e narunamiyei. Sosu lowe iyape fene lo au luwaruweyei. Lu tamo etiri luwaru a'i ape fene ma'e irowei su, fene marepi wisere a'i irorowa. Jo 15:19; 16:2; 1 Pi 4:14 ");
INSERT INTO sny_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Fene nowe ape se marepi wisere a'i se nine'ite. Tu naifa weriyei lu tewi ape lo ya'ariyei, lowe Owane Sitewi lo au te'e siye lu werese ma'e aiwawe a'i au luwaruweteye. Aiwawe a'i lu tewi ape mo fene ma'e au luwaruwerowa su, fene marepi wisere a'i teritere. Lowe fene ma'e au luwaruwerowa su, nowe ye'ewi su, Owane Sitewi lai fene ma'e etiri wisere a'i neri a'i aurowa. Serai fene marepi wisere a'i irore. ");
INSERT INTO sny_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Fene ma'aru tomu ne'ese ironamisiya ape, weiyai! Pereye fene marepi fetane a'i terite tepa'asiye. Nowe mo'o su Owane Sitewi lai fene ma'e marepi luwaru a'i itiya'u aurowa. ");
INSERT INTO sny_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Fene lire a teme'eriyesiya ape, weiyai! Nowe me'iye su, fene lau erasi teriterowa. Fene pereye marepi nine'isiya ape, weiyai! Nowe me'iye su, fene ewite erasi lurowa. ");
INSERT INTO sny_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Lu tamo fene ne marepi au te'e wisereyesiya su, fene weiyai! Tu naifa weriyei lu tamo lai peri wawero te'e siye lu ma'e au te'e wisereyeteye. Lowe peri wawero te'e siye lu ma'e au wisereyeteye su, Owane Sitewi lowe ma'e etiri luwaru a'i itiya'u auwe. Serai pereye lu tamo fene ma'e au te'e wisereyerowa su, fene weiyai! Owane Sitewi lai fene ma'e etiri luwaru a'i itiya'u aurowa. ");
INSERT INTO sny_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ahowa, ane fene ma'e eisiya. Peri ano wanure! Lu tamo fene ma'e au luwaruweyei su, fene lowe ma'e marepi erasi a'i itiya'u au tote wawesiyenamite! Aiwawe a'i lu tamo ai marepi fene ma'e totenamiyei su, fene etiri wisere a'i lowe ma'e itiya'u pei atuatute. ");
INSERT INTO sny_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Lu tamo fene ma'e peri luwaru a'i au te'e naruwei su, fene lowe ma'e au te'e wisereyete. Lu ape mo fene ma'e au luwaruweyei su, fene Owane Sitewi ma'e lowe ne au te'e towerite. ");
INSERT INTO sny_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Meni ta ahi si eyate feni ma'e fene lo ereti se aineyei su, fene ahi si feni tere'e ma'e fene lo atati teite. Serai le ahi si feni tere'e ma'e fara'u ereti se aineyei. Meni ta fene ma'e ipari tahe ta fene ma'e ei toweriyei su, fene le ma'e ipari tahe hesi a'i fene lo aiwawe a'i aure. ");
INSERT INTO sny_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Meni ta fene ma'e etiri ta ei toweriyei su, fene etiri ape le ma'e aure. Meni ta lai etiri fene lo ta'arei aniyei su, fene etiri ape ne si itiya'u owe ape ei towerire. ");
INSERT INTO sny_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Fene apou a'i toteyei su, ‘Lu taune werese ane ne yo seni wisere a'i au iroreme.’ Fene apou a'i toteyei su, fene lowe ma'e yo seni wisere a'i aiwawe irore. Mt 7:12 ");
INSERT INTO sny_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Fene lu tewi fene lo a'i marepi erasi a'i tote wawesiyenamiyei su, etiri ape yahowa'i a'i ne. Lu taune luwaru a'i, lowe lu tewi lowe lo ma'e marepi erasi aiwawe a'i tote wawesiyenamiyei. ");
INSERT INTO sny_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Meni ta etiri wisere a'i fene ma'e irowei su, sosu fene le ma'e etiri wisere a'i itiya'u irowei su, yo seni ape yahowa'i a'i ne. Lu taune luwaru a'i yo seni aiwawe a'i irowei. Lowe etiri wisere a'i itiya'u irowei. ");
INSERT INTO sny_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Fene apou toteyei su, “Ane kaiyemo ano ma'e etiri ta auwei su, le etiri ta ane ma'e itiya'u aurowa. Marepi fene lo luwaru a'i ne. Yo seni yahowa'i a'i ne. Lu taune luwaru a'i lowe lu taune tere'e luwaru a'i ma'e etiri ta auwei. Lowe etiri ta auwei su, lowe etiri aiwawe a'i itiya'u aniyei ne toteyei. ");
INSERT INTO sny_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ane fene ma'e eisiya. Lu taune tamo fene ma'e au luwaruweyei su, fene lowe ne marepi wisere a'i totenamire. Fene lowe ma'e etiri wisere a'i irore. Lowe fene ma'e etiri ta ei toweriyei su, fene lowe ma'e etiri ape aure. Sosu fene lowe ma'e itiya'u owe ape ei towerire. Fene yo seni ape umasiyei su, Owane Sitewi lai nowe ye'ewi se fene ma'e etiri wisere neri a'i aurowa. Fene Owane Sitewi Pefine a'i lo eimane henerairowa. Le a'i lai lu taune luwaru a'i ma'e ferafereiyei lo auwe. Le aiwawe a'i lu taune tamo, marepi luwaru a'i irosiya ape, ma'e ferafereiyei lo auwe. ");
INSERT INTO sny_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Tai wiyeme fene lo lai lu taune werese ma'e au ferafereinamisiya. Serai fene ferafereiyei lo yo seni aiwawe a'i umasite. Fene lu taune werese ma'e au ferafereite. ");
INSERT INTO sny_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Fene lu taune tere'e lo yo seni owe ape hese ereite. Fene lu taune tere'e lo yo seni hese ereirowa su, Owane Sitewi lai yo seni fene lo ape au hese ereirowa. Serai fene lu taune tere'e lo yo seni owe ape hese ereite. Fene lu taune tamo apou owe ape te'ere, ‘Fene yehe omo ma'e ire.’ Fene lu taune tamo yehe omo ma'e te'e eimawesawiyei su, Owane Sitewi lai fene aiwawe a'i yehe omo ma'e eimawesawirowa. Meni ta fene ma'e au luwaruweyei su, fene meni ape lo yo seni tote i'ane arunatite. Fene lu taune lo yo seni tote i'ane arunatiyei su, Owane Sitewi lai yo seni luwaru a'i fene lo tote i'ane arunatirowa. Mt 6:14 ");
INSERT INTO sny_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Fene lu taune ma'e etiri ta auwei su, Owane Sitewi lai fene ma'e etiri ta itiya'u auwei. Le fene ma'e niye erasi a'i itiya'u auwei. Le etiri erasi a'i fene ma'e niye fene lo papu su'ari ani teroso asi arowe. Fene lu taune ma'e etiri oso a'i auwei su, Owane Sitewi lai aiwawe a'i fene ma'e etiri oso a'i ta auwei.” Mk 4:24 ");
INSERT INTO sny_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jisas lowe ma'e peri anowe ta au te'eteye, le apou au eiye, “Meni ta nihe lo pokowe tawesiyei su, le meni tere'e, nihe pokowe tawesiye ape, hene ani uweiterowata. Ahowa, lowesi afofoweyei. Lowesi yo mai sahe papu ninapune winetairowa. Mt 15:14 ");
INSERT INTO sny_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Eimane tamo lai meni owane towafi lowe lo ape eiwerou hi ani ararorowata. Ahowa, meni eime ta etiri werese siye so'oruweyei su, le meni owane lo wou heneraiyei. Mt 10:24-25 ");
INSERT INTO sny_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Fene piyene kaiyemo ta lo nihe oro'oru tewi oso a'i siyeyei awere? Fene me meni erasi nihe towafi fene lo papu siyerowata. ");
INSERT INTO sny_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Fene kaiyemo ma'e owe ape te'ere, ‘Ane fara'u oro'oru tewi oso a'i nihe no ani tahe aniyei.’ Ahowa, fene me meni erasi nihe towafi fene lo papu irosiya su, fene kaiyemo lo oro'oru tewi oso a'i nihe papu irosiya ape, ani tahe aniyei ne siyerowata. Fene marepi hesi a'i siye lu ne, fene tu me meni erasi, nihe towafi fene lo papu irosiya ape, ani tahe fusawire. Sosu fene me meni erasi, nihe fene lo sahe irosiya ape, ani tahe fusawi tepa'asiyei su, fene fara'u kaiyemo lo oro'oru tewi oso a'i nihe sahe irosiya ape, siye ani tahe fusawirowawe, siye etirowa.” ");
INSERT INTO sny_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Fene wanure! Me wisere a'i so luwaru a'i ta'erowata. Sosu aiwawe a'i me luwaru a'i ta so wisere a'i ta'eyerowata. ");
INSERT INTO sny_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Fene me so siyeyei su, fene me so eiwerou aiwawe a'i siyerowawe, meni ta momo, ni'ari wafei se ani ta'e anirowata. Aiwawe a'i meni ta patiyawe so, me owapiyo ani ta'eye anirowata. ");
INSERT INTO sny_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Meni wisere a'i marepi wisere a'i lo se toteyei su, le yo seni wara'i a'i ironamiyei. Aiwawe a'i meni luwaru a'i ta marepi luwaru a'i topo lo se toteyei su, le yo seni luwaru a'i ironamiyei. Lu taune werese peri ta au te'eyei su, lowe marepi lowe lo se au te'eyei.” ");
INSERT INTO sny_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Fene tomu ne'ese ane ma'e apou te'esiya ape, ‘Ne Meni Owane Pefine a'i nomo lo ne.’ Ahowa, fene peri ano wanu umasi se ta'ame. Mt 7:21 ");
INSERT INTO sny_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Lu taune ane ma'e aiyerowawe, sosu peri ano wanu umasiyei su, lowe meni ta wesi ta'aneyei lu wou a'i ne. ");
INSERT INTO sny_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Lowe meni ta wou a'i wesi he'i ta'anesiya. Meni ape wesi he'i ta'aneyei su, le awei yo erasi horuseye itowei. Sosu le me ne'ise tou opo asi arowei. Le tapiye aine leyau tawesi kairefiyeyei. Le me ne'ise opo asi arowei su, le fara'u wesi hire ma'e ta'aneyei. Serai sa'i erasi itoraiyei su, sa'i ei erasi wesi ape aine towesi narowata. Ahowa, wesi ape lo me ne'ise kairefi a'i teinamiyei. ");
INSERT INTO sny_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ahowa, meni tere'e ta peri ano wanu arisiyei su, le meni tere'e wou a'i ne. Meni ape wesi he'i ta'aneyei su, le me pere'e oso a'i eneri sahe horuse opo asi arowei. Sosu wesi he'i me pere'e hire ma'e ta'aneyei. Serai sa'i erasi itoraiyei su, sa'i ei erasi a'i wesi ape lo aine towesi naroweyei. Sosu wesi ape lo towesi to'ute naroweyei.” ");
INSERT INTO sny_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jisas lu taune werese ma'e peri au te'e tepa'asiye su, le omo Kaperneam ma'e fi. ");
INSERT INTO sny_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ai atu siye meni ta saro iroteye. Meni ape lo wiyawi yahowa'i a'i siye meni u tahe erasi a'i iroteye. Ai atu siye meni lai wiyawi meni yahowa'i a'i le ne a'i marepi wisere erasi a'i tote wawesiyeteye. Wiyawi meni yahowa'i a'i temeniyeyei ne ataheyeye. ");
INSERT INTO sny_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Serai ai atu siye meni Jisas omo ape heneraiyei wanuwe su, le Juda lo lu owane tamo Jisas ma'e eimawesawi. Lowe Jisas ma'e heneri su, lowe le ma'e apou te'e toweriye, “Ne ai atu siye meni lo wiyawi meni yahowa'i a'i au pati ta'ane fara'uwera.” ");
INSERT INTO sny_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Lowe Jisas ma'e heneri su, lowe Jisas ma'e peri kairefi a'i se te'e toweriye, “Ai atu siye meni ape meni wara'i a'i ne. Serai ne meni ape pei au ferafereire! ");
INSERT INTO sny_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Meni ape Juda lo lu taune werese ne marepi erasi a'i tote wawesiyenamisiya. Meni ape ta'uweyei wesi nomo lo ta'aneteye. Meni ape meni wara'i wisere a'i ne. Serai ne fara'u meni ape au ferafereire!” ");
INSERT INTO sny_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jisas peri lowe lo wanuwe su, le lowe mase aiwawe a'i fi. Lowe ai atu siye meni lo wesi ma'e atahe a'i heneri su, meni ape kaiyemo tamo Jisas ma'e eimawesai. Lowe le ma'e peri ta apou au te'esai, “Meni Owane, ane meni yahowa'i a'i ne. Ne Meni Owane Pefine a'i ne. Ne wesi ano wirowata. Wesi ano luwaru a'i ne. ");
INSERT INTO sny_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Serai ane a'i lai ne ma'e aiyerowata. Sosu ane lu owane ne ma'e ei aniyei ne eimawesawi. Ane meni yahowa'i a'i ne. Ne peri te'eyei su, wiyawi meni yahowa'i a'i ano u tahe po'uteyei. ");
INSERT INTO sny_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Wanure! Ane meni owane ta'i unahi irosiya. Ane peri lo wanu umasiyei. Ane ai atu siye meni owane ne. Ane ai atu siye lu tomu ne'ese au noweinoweisiya. Ane ai atu siye meni ta ma'e eiyei su, ‘Ne ire!’ Meni ape peri ano wanu umasiyei. Ane meni tere'e ma'e apou eiyei su, ‘Ne aiya!’ Meni ape peri ano wanu umasiyei. Aiwawe a'i ane wiyawi yahowa'i a'i meni ano ma'e eiyei su, ‘Ne wiyawi ape ta'anere!’ Wiyawi yahowa'i a'i meni ano peri ano wanu umasiyei. Serai ane fene ma'e apou eisiya, ne wiyawi yahowa'i meni ano au ta'ane fara'uwere!” ");
INSERT INTO sny_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Serai Jisas peri ape wanuwe su, le meni ape ne apou eiye, “Wisere a'i ne!” Sosu le ai atu siye meni ape ne marepi erasi a'i tote wawesiyenamiteye. Le lu taune werese ma'e mo'o umasiteye ape, apou eiye, “Wanure! Ane fene ma'e eisiya, meni ape lo tote tawesiyei erasi a'i irosiya. Le lu taune werese lo tote tawesiyei pani Israel sahe hi ani ararosiya!” ");
INSERT INTO sny_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Serai lu tewi ape mo, ai atu siye meni owane Jisas ma'e eimawesai ape, lowe Jisas arunatiyewe, ai atu siye meni lo wesi si tame fi su, lowe wiyawi yahowa'i a'i siye meni lo u tahe po'ute siyeye. ");
INSERT INTO sny_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Nowe me'iye su, Jisas, lu disaipel lo aiwawe a'i, omo Nain ma'e fi. Lu taune tomu ne'ese aiwawe a'i Jisas mase mo'o umasitai. ");
INSERT INTO sny_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Sosu lowe omo ape lo yo tewiye ahi ta'o heneri su, lu tamo meni temeniyeye ape, omo nowe ma'e fisiye yo papu fuwei ne sutaiteti. Menitani weiname lu taune tomu ne'ese aiwawe a'i fai. Meni temeniyeye ape ne, menitani weiname meni eime ta'i a'i auteiye. ");
INSERT INTO sny_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jisas menitani weiname siyeye su, le weiname ape ne marepi erasi a'i ewiteye. Le le ma'e eiye, “Luwei sawa!” ");
INSERT INTO sny_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Sosu le meni ape lo wari ma'e atahe a'i teiye. Le ereti lo wari sahe fuwe. Lu ape mo, wari sutaitetai ape saro a'i teiteye. Jisas meni ma'e, temeniyeye ape, apou eiye, “Yo'orei meni, ane ne ma'e eisiya. Ne si sinere!” ");
INSERT INTO sny_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Serai meni ape si sine onuwewe, lowe ma'e te'eteye. Sosu Jisas meni eime ape mai lo ma'e si tame auwe. 1 Kin 17:23; 2 Kin 4:36 ");
INSERT INTO sny_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Lu taune werese etiri ape siyeye su, lowe marepi atoweiye irowe. Lowe Owane Sitewi ma'e au te'e wisereyenamiteye. Lowe apou au te'eteye, “Owane Sitewi lo au te'e siye meni erasi nomo mase henerai tepa'asiye. Owane Sitewi lai lu taune werese lo ma'e au ferafereiyei ne itorai.” Lu 1:68 ");
INSERT INTO sny_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Lowe Jisas ne peri heneruwe omo pani werese Judia ma'e au te'e fiyariteye. Omo pani tere'e ma'e lowe peri heneruwe au te'e fiyariteye. ");
INSERT INTO sny_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jon lo lu feni tamo le ma'e Jisas ne peri heneruwe au te'eye. ");
INSERT INTO sny_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Meni Jon Jisas lo peri heneruwe wanuwe su, le lu feni hesi a'i lo ei aniye. Le lowesi Owane Jisas ma'e peri ta te'e toweriyei ne eimawesawi. Lowesi le ma'e apou te'e toweriyei, “Owane Sitewi lai meni owane hi awei ma'e eimawe arosairowa. Ne meni ape awere? Nomo meni tere'e siye nehi ninaweteyei awere?” ");
INSERT INTO sny_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Sosu lowesi Jisas ma'e henerai su, lowesi Jisas ma'e apou te'e toweriye, “Ne meni ape, Owane Sitewi, hi awei ma'e eimawe arosaiyei ape, awere? Piyete awere? Nomo meni tere'e ninaweteyei awere?” Sng 40:7; Mal 3:1; KTH 1:8 ");
INSERT INTO sny_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Nowe ape se Jisas lu taune lo u tahe tomu ne'ese au ta'ane fara'uweteye. Le lu taune lo marepi orese a'i au fareraiyeteye. Sosu le sepei luwaru a'i tomu ne'ese au ta'ane sasariteye. Sosu lu taune tamo nihe pokowe tawesiyei se, le nihe lowe lo au ani petaneteye. ");
INSERT INTO sny_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Serai le lowe ma'e itiya'u eiye, “Fenesi Jon ma'e si tame ire. Le ma'e peri heneruwe ano au te'ere, ‘Notosi peri lo wanuteye, sosu wiyawi lo siyeteye. Lu tamo nihe pokowe tawesiyei ape mo, le nihe lowe lo au ta'ane petaneye. Lu tamo lowe, haroharo a'i iroteye ape mo, le lowe haroharo a'i lowe lo au ta'ane kairefiyeteye. Lu taune tamo, enite kairefi a'i iroteye ape, le enite werese lowe lo au ta'ane niyemaiyeteye. Lu apaniye wiyapuweye se, le apaniye lowe lo au ta'ane fara'uweteye. Serai lowe peri amerame a'i wanuwe. Lu tamo temeniyeye ape, le lowe si tame hene sineteye. Lu taune ma'aru ariye a'i se, le peri heneruwe wisere a'i lowe ma'e au te'eteye. Ais 35:5-6; 61:1; Lu 4:18 ");
INSERT INTO sny_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Meni ta ane ne marepi hesi se tote ta'ame su, marepi lo wisereye nine'inamisiya.’” ");
INSERT INTO sny_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Lu hesi, Jon Jisas ma'e eimawesawi ape, lowesi Jisas lo peri wanuwe su, lowesi Jon ma'e si tame fi. Lowesi si fi su, Jisas lu taune werese ma'e Jon ne au te'eye. Le apou eiye, “Fene pani ariye a'i ma'e fi su, fene piye etiri siyeyei ne toteye awere? Meni Jon menei wou fiyaru lai au ani aunariyeye awere? ");
INSERT INTO sny_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ahowa, le menei wou ta'ama. Fene piye siyeyei ne fi awere? Meni ta'i ipari tahe wisere a'i ani asiye awere? Ahowa, wanure! Lu werese ipari tahe wisere a'i ani asinamiye ape, lowe owane lo wesi wisere a'i saro onusiya. Lowe werese etiri tomu ne'ese ironamisiya. ");
INSERT INTO sny_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ahowa, fene piye siyeyei ne fi awere? Owane Sitewi lo peri au te'e siye meni awere? Ei, ane fene ma'e eisiya! Meni ape Owane Sitewi lo peri au te'e siye lu werese hi ani ararowe. Lu 1:76 ");
INSERT INTO sny_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Tu naifa weriyei meni ta Owane Sitewi lo one towe sahe meni ape ne apou leseye, Owane Sitewi Meni Owane Krais ma'e apou eiye, ‘Wanure! Ane peri au te'e siye meni ano nihari no ma'e eimawesawiyei. Meni ape aiyerowa su, le yo no au ta'uwe naneirowa.’ Serai Jon henerai su, peri ape wiyeme a'i henerai. ");
INSERT INTO sny_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ane fene ma'e apou eisiya. Lu taune werese omo omo werese sahe, meni Jon lowe werese hi ani ararowe. Ahowa, meni ta'i, Owane Sitewi lo lu tewi sahe oso a'i iroteye ape, le lai meni ape Jon hi ani ararowe.” ");
INSERT INTO sny_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Sosu lu taune werese, lu tamo takis ma'aru ani siye ape, aiwawe a'i lowe Jisas lo peri wanuwe su, lowe apou eiye, “Owane Sitewi lo yo seni wisere a'i ne.” Lu tewi ape mo tu naifa Jon lai lowe ma'e sa'i se au huteye. Lu 3:12 ");
INSERT INTO sny_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ahowa, lu Farisi tamo, Owane Sitewi lo yo peri ani so'oru siye lu tamo, lowe Owane Sitewi lo marepi lo sitewi arisiye. Jon lai lowe ma'e sa'i se au hu ta'ame. Mt 21:32 ");
INSERT INTO sny_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Serai Jisas lowe ne apou au te'eye, “Lu tewi ape ne ane piye peri anowe wou au te'e areiyeyei awere? Lu tewi ape ne, nowe eite se irosiya ape, lowe piye yo seni wou a'i awere? ");
INSERT INTO sny_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Farisi lu tewi apou wou a'i, lowe eimane wou a'i ne. Eimane ape lai ta'uweyei pani tewi ma'e ta'uwe onurai. Lowe te'e tiyatiye apou eiye, ‘Nomo fene ne mene'e fateye su, fene unei ape'i te ta'ame. Nomo lu soposopowei ewite irowe su, fene lu ta'ame.’ ");
INSERT INTO sny_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Meni ape Jon, sa'i au hu siye meni, le fai su, le nau ta'ase, wain sa'i a ta'ame. Fene meni ape siyeye su, fene le ne apou te'eye. ‘Sepei luwaru a'i meni ape papu ironamisiya.’ ");
INSERT INTO sny_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Sosu ane, meni hire ma'e itorai ape, ane ene ayei ataiteye, wain sa'i ataiteye su, fene ane ne apou te'eye. ‘Meni ape ayei ahi a'i meni. Le meremereye a'i meni. Le lai takis ma'aru ani siye lu werese, lu taune seni luwaru a'i ironamisiya ape, le lowe mase ironamiteye.’ Lu 15:2 ");
INSERT INTO sny_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ahowa, lu taune werese Owane Sitewi lo peri wanu umasisiya ape, lowe Owane Sitewi ne tote te'esiya, ‘Etiri werese, ane irosiya ape, etiri ape mo lai ane meni pefine a'i ne au atuatusiya.’” ");
INSERT INTO sny_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Sosu a'i pe Jisas peri tepa'asiye su, Farisi meni ta Jisas ma'e ei toweriyei ne fai. “Ne wesi ano sahe ane mase ayei ne aiya!” Serai Jisas lu disaipel lo aiwawe a'i Farisi meni ape mase aiwawe fi. Lowe wesi papu wiye su, metei sahe ene ayei ne onuwe. ");
INSERT INTO sny_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Lowe metei ene ayei onuwe su, menitani ta, wesi omo ape sahe le yo seni luwaru a'i ironamiteye. Le Jisas Farisi lo wesi sahe wiyei wanuwe su, le tapiye pa'are sa'i heneri wisere a'i Jisas ma'e aitai. Mt 26:7; Mk 14:3; Jo 12:3 ");
INSERT INTO sny_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Menitani ape Jisas lo lowe ma'e ape'i onuwewe, le nihe sa'i se Jisas lo lowe sa'i au huteye. Sa'i au hu tepa'asiye su, le mato towe lo, lowe sahe au ani teine foro'oweye. Le Jisas lo lowe ma'e au nine'iteye. Le sa'i heneri a'i Jisas lo lowe sahe au ani teineye. ");
INSERT INTO sny_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Meni Farisi ape Jisas le mase aiwawe a'i ei aniye ayei ne ei toweriye ape, le menitani ape siyeye su, le marepi topo lo sahe apou toteye, “Meni ape Owane Sitewi lo peri au te'e siye meni ta'ama. Ahowa, meni ape Owane Sitewi lo peri au te'e siye meni su, le menitani lowe lo teriteye ape, siye so'oruweye. Menitani ape lo yo seni luwaru a'i ironamisiya.” ");
INSERT INTO sny_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jisas Farisi meni lo marepi siye so'oruweye su, le meni ape ma'e apou eiye, “Saimon, ane peri ta ne ma'e au te'eyei.” Farisi meni le ma'e itiya'u eiye, “Atuatu siye meni, ne ane ma'e au te'ere!” ");
INSERT INTO sny_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Serai Jisas le ma'e peri anowe ta au te'eye, “Meni owane ta lu hesi ma'e ma'aru neri a'i auwe. Nowe me'iye su, le lu hesi ape ei aniye. Le lowesi ma'e eiye, ‘Fenesi ma'aru ano itiya'u tame aure.’ Meni ta'i ma'aru tomu ne'ese aniye. Meni tere'e ma'aru tewi oso a'i aniye. ");
INSERT INTO sny_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Nowe me'iye su, meni owane ma'aru lo si itiya'u fu auwei ne ei aniye. Lowesi ma'aru ape mo si itiya'u aurowata. Meni owane ape lowesi ma'e apou eiye, ‘Fara'u a'i ne. Ane ma'aru neri a'i a'i ano fu arosawinamiyei. Fenesi ane ma'e owe ape itiya'u aure.’ Ane ne ma'e ei towerisiya, Piye lu hesi owane ne marepi erasi pefine a'i totesiya awere?” ");
INSERT INTO sny_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Sosu Saimon le ma'e itiya'u eiye, “Marepi ano apou a'i totesiya. Meni ape ma'aru tomu ne'ese aniye ape, le meni owane ne marepi erasi wiyeme a'i totesiya.” Sosu Jisas itiya'u eiye, “Ei, ne marepi no wiyeme a'i tote fareraiyeye.” ");
INSERT INTO sny_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Serai Jisas menitani ape ma'e atati siyeye. “Saimon, ne menitani eite siyere! Ane wesi no wirai su, ne sa'i ta lowe ano sahe au hu ta'ame. Ahowa, menitani ape nihe sa'i topo lo se lowe ano au huteye. Mo'o su, le mato towe topo lo, lowe ano au ani teine foro'oweteye. ");
INSERT INTO sny_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ane wesi wiye su, ne lowe ano ma'e au nine'i ta'ame. Ahowa, ane wesi no fai su, menitani eite lowe ano ma'e aunamiteye. ");
INSERT INTO sny_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ne mato ano sahe sa'i au fu ta'ame. Menitani eite lowe ano sahe sa'i heneri wisere a'i au ani teroso teineteye. ");
INSERT INTO sny_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Serai ane ne ma'e apou eisiya, ane menitani eite lo yo seni luwaru tomu ne'ese iroteye ape, ane lai au ta'ane sasari pamowe tepa'asiye. Serai menitani eite ane a'i marepi erasi pefine a'i tote nine'inamisiya. Ahowa, meni tere'e ta, yo seni luwaru oso a'i iroteye ape, sosu Owane Sitewi lai meni ape lo yo seni luwaru a'i ani pamoweye su, meni ape Owane Sitewi ne marepi tewi oso a'i totesiya.” ");
INSERT INTO sny_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Sosu le menitani ma'e apou eiye, “Menitani, ane yo seni luwaru werese a'i no au ta'ane sasari pamowe tepa'asiye.” ");
INSERT INTO sny_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Lu tamo le mase metei ene ayei ne onuwe ape, lowe apou toteye, “Meni ape eiwerai awere? Meni ape yo seni luwaru a'i au ta'ane sasariteye awere?” ");
INSERT INTO sny_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Serai le menitani ma'e apou eiye, “Tote tawesiyei no erasi a'i ne. Ane yo seni luwaru no au ta'ane sasari pamoweye. Serai ne menitani aseyaro a'i henerai. Ne marepi fetane a'i mase ire.” Lu 8:48; 18:42 ");
INSERT INTO sny_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Nowe me'iye su, Jisas lu feni werese lo (12 aiwawe a'i), lu taune werese ma'e omo omo werese sahe Owane Sitewi lo peri he'i a'i au te'e fiyariyei ne fi. Le lowe ma'e nowe ape se ne, Owane Sitewi lu taune werese au noweinoweirowa ape ne, au te'e areiyeye. ");
INSERT INTO sny_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Taune tamo lowe mase omo omo ma'e aiwawe fi. Tu naifa Jisas lai sepei luwaru a'i taune tamo nowe ma'e au ta'ane sasariteye. Taune tere'e tamo Jisas lai lowe lo u tahe au ta'ane fara'uweye. Menitani ta'i Jisas lai sepei luwaru a'i ereti feni werese fene hesi a'i (7) au ta'ane sasariteye. Menitani lo iyape Maria, omo Makdala ma'e fai. Mt 27:55-56; Mk 15:40-41; Lu 23:49 ");
INSERT INTO sny_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Taune hesi Joana, sosu Susana lowesi taune tere'e tomu ne'ese aiwawe a'i lowe ma'aru lowe lo Jisas ma'e ayei eteyewe, ene ayei ne auwe. Menitani Joana, Kusa lo tani. Kusa lai meni owane Herot lo etiri tamo au noweinoweiteye. ");
INSERT INTO sny_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Sosu a'i pe lu taune tomu ne'ese Jisas lo peri wanuwei ne ta'uwerai. Lu taune tamo omo omo eyeri ma'e fai. Lu taune le ma'e ta'uwerai su, le lowe ma'e peri anowe ta au te'eye. ");
INSERT INTO sny_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Meni ta ta'aneyei awei ma'e me so lo yehe sameyei ne fi. Le kewi so ani teroso fiyarisawi su, kewi so tamo yo mai tewi ma'e winetaiye. Lu taune tamo yo sahe uweitaiteye su, lowe kewi so hire ato teiteye. Kewi so tamo irowe lai oruwe sowateye. ");
INSERT INTO sny_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Kewi so tamo awei tewi tapiye a'i sahe winetaiye. Nowe me'iye su, kewi so peratiyewe wamu witane a'i wirai. Poweiye ponei su, kewi wamu poweiye tewi haroharoweye. Kewi napi sa'i tore anirowata. ");
INSERT INTO sny_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Kewi so tere'e tamo wafei ni'ari ponei sahe winetaiye. Kewi wamu wirai su, wafei ni'ari kewi wamu napetu tawesiteye. Serai kewi wamu wirowata. ");
INSERT INTO sny_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Kewi so tere'e tamo awei wisere a'i sahe winetaiye. Nowe me'iye su, kewi so peratiyewe, wamu erasi a'i wirai. Kewi erasi wirai tepa'asiye su, kewi so tomu ne'ese ta'eyei su, wahu 100 tamo se kewi so ani asi teme'eriyeye.” Sosu Jisas peri anowe au te'e tepa'asiye su, le lowe ma'e apou uteye. “Lu taune ta peri ano wanuwe su, lowe peri ano umasire.” ");
INSERT INTO sny_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Sosu a'i pe Jisas lo lu disaipel le ma'e apou te'e toweriye, “Peri anowe ape, piye sitewi lo te'esiya awere?” ");
INSERT INTO sny_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jisas lowe ma'e itiya'u eiye, “Owane Sitewi lai fene ma'e peri anowe lo sitewi au atuatu areiyerowa. Owane Sitewi fene ma'e nowe ape se, le lu taune werese au noweinoweirowa ape, peri pefine a'i au atuatu areiyerowa. Lu taune tere'e ane lai Owane Sitewi lo marepi fareyare a'i au te'erowata. Ane lowe ma'e peri anowe a'i au te'erowa. Ane lowe ma'e peri anowe se au te'eyei su, lowe etiri ta siyeye. ‘Ahowa, lowe etiri lowe siyeye ape, lowe etiri siye so'oruwerowata. Lowe peri ano wanuwei su, lowe peri lo sitewi ano wanu so'oruwerowata.’ ");
INSERT INTO sny_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Peri anowe ape apou te'esiya. Kewi so Owane Sitewi lo peri aiwawe a'i ne. ");
INSERT INTO sny_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Kewi so ape mo yo mai tewiye ma'e winetaiye ape, lowe lu taune wou a'i ne. Lowe Owane Sitewi lo peri wanuwe su, sepei Satan witane a'i Owane Sitewi lo peri marepi lowe lo sahe tore aniye. Serai lowe Owane Sitewi lo peri wanu umasirowata. Sosu lowe hepene he'i wisere a'i anirowata. ");
INSERT INTO sny_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Kewi so ape mo, awei tapiye a'i sahe winetaiye ape, lowe lu taune wou a'i ne. Lowe Owane Sitewi lo peri wisere a'i wanuwe su, lowe kairefi a'i tote tawesiye se ta'ame. Etiri yo seni luwaru a'i lowe ma'e heneraiyei su, yo seni luwaru a'i ape lai tote tawesiyei lowe lo tore aniyei. Lowe lo tote tawesiyei lo sitewi kairefiyeyei se ta'ama. Serai lowe tote tawesiyei lowe lo arunatiyei. ");
INSERT INTO sny_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Kewi so ape mo wafei ni'ari ponei sahe winetaiye ape, peri ape lo sitewi apou wou a'i ne. Lu taune Owane Sitewi lo peri wanuwe su, lowe marepi wisere a'i toteye. Ahowa, lowe etiri werese lowe lo ironamiye su, lowe awei lo yo seni umasinamiteye. Marepi orese a'i teriteyei, ma'aru lo yo seni awei lo yo seni marepi toteyei umasiyei, etiri ape mo tote tawesiyei lowe lo napetu ti tawesinamiteyei. Serai lowe tote tawesiyei lowe lo lu taune ma'e au te'erowata. ");
INSERT INTO sny_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Kewi so ape mo awei wisere a'i sahe winetaiye ape, peri ape lo sitewi apou a'i te'esiya, lu taune Owane Sitewi lo peri marepi wisere a'i se, marepi farere a'i se wanu tote tawesi umasinamiteye. Serai lowe tote tawesiyei lowe lo lu taune ma'e au te'e tote i'aneteyei. ");
INSERT INTO sny_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Sosu a'i pe meni ta yehe lam taiso fu mitaiyeye su, le lam ape wahu papu owe ape au onu fareyarere. Le wari unahi hi ma'e owe ape fu fareyarere. Ahowa, le wesi ponei sahe wafei se ti tawesi tewi mitaiyerowa. Serai lu taune wesi ape wirai su, lowe yehe lo tewi mitaiyeyei fara'u siyeyei. Mt 5:15; Lu 11:33 ");
INSERT INTO sny_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Etiri werese ape mo lu taune lai au fareyareteye ape, Owane Sitewi lai etiri werese ape mo lowe amerame a'i au atuatu areiyerowa. Meni ta yo seni, fareyareye irowei ape, yo seni werese lo ape lu taune werese lai amerame a'i siyerowa. Mt 10:26; Lu 12:2 ");
INSERT INTO sny_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Serai weiyai! Peri ano wanu etire! Lu taune tamo Owane Sitewi lo peri marepi wisere a'i se wanu tote tawesi umasinamiteyei su, Owane Sitewi lai tote tawesiyei lowe lo, erasi a'i au kairefiyerowa. Ahowa, lu taune tamo Owane Sitewi lo peri wanu arisiyei su, Owane Sitewi lai tote tawesiyei lowe lo tore ani ararowei. Lu taune tamo marepi wawero a'i toteyei su, ‘Nomo tote tawesiyei erasi irosiya.’ Owane Sitewi lai marepi lowe lo siyeyewe, tote tawesiyei lowe lo hi ani ararowei.” Mt 25:29; Lu 19:26 ");
INSERT INTO sny_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Wesi papu sahe Jisas lu taune tomu ne'ese ma'e au te'e fiyariye su, mai lo, pa'ise lo aiwawe a'i lowe le ma'e peri ta au te'eyei ne toteye. Ahowa, lowe Jisas ma'e ataheyerairowata. Lu taune werese wesi yo tewiye sahe tawesi teiye. ");
INSERT INTO sny_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Serai meni ta Jisas ma'e apou eiye, “Wanure! Mai no, pa'ise werese no nowe ma'e teisiya. Lowe ne ma'e peri ta au te'eyei ne totesiya.” ");
INSERT INTO sny_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jisas peri ape wanuwe su, le itiya'u eiye, “Mai ano, pa'ise ano, eiwerai awere? Mai ano, pa'ise ano apou wou a'i ne. Lu taune werese Owane Sitewi lo peri wanu tote tawesi umasinamisiya ape, lowe mai ano, lowe pa'ise werese ano ne.” ");
INSERT INTO sny_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Sosu a'i pe nowe me'iye su, Jisas, lu disaipel lo aiwawe a'i, hare ite Galili ma'e si tame fi. Lowe wai papu awetowe. Le lowe ma'e eiye, “Nomo hare ite feni eire ma'e iyatu toneriyei.” Sosu lowe wai sa'i ponei ma'e tewi itesawi. ");
INSERT INTO sny_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Lowe wai sa'i ponei ma'e iyatutiye su, Jisas wai lo si sahe nihe howeiteye. Jisas nihe howeiteye su, fiyaru erasi a'i hare ite ponei sahe henerai. Sa'i ei erasi a'i wai ani awetu awetowe. Lowe sa'i ei lai wai lowe lo ape ani aporuwei ne ataheyeye. ");
INSERT INTO sny_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Lowe werese sa'i ei erasi a'i ape ne atoweiyeye. Serai lowe Jisas eisowe sineye. Lowe le ma'e eiye, “Meni Owane, Meni Owane! Wai nomo lo eite sa'i ei lai ani aporuwei ne ataheyewa. Nomo werese sa'i papu itowa. Ne nomo au ferafereire!” Serai Jisas sineyewe, le fiyaru, sa'i ei erasi ma'e eiye, “Titanere!” Pereye a'i fiyaru sa'i ei titane po'uteye. Sa'i werese titane temeniyeye. ");
INSERT INTO sny_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Serai sa'i ei temeniyeye su, Jisas lowe ma'e eiye, “Tote tawesiyei fene lo, oso a'i awere?” Lowe marepi atoweiye hepene se su'ariye. Lowe te'e tiyatiteye, “Meni ape eiwerai awere? Le fiyaru, sa'i ei ma'e eiye su, lowesi peri lo wanu umasiye. Serai lowesi temeniyeye.” ");
INSERT INTO sny_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Sosu lowe omo pani Gerasa ma'e iyatutiteye. Lowe omo pani Galili ma'e arunatiyewe, omo Gerasa feni eire ma'e iyatutiteye. ");
INSERT INTO sny_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Lowe wai hare ite senitewi sahe furi su, meni ta sepei luwaru tomu ne'ese a'i ya'oreteye ape, wai senitewi aro teiteye. Le nowe tomu ne'ese a'i liye pa'are ariye a'i ironamiteye. Le pasi pasi werese wesi sahe howeirowata. Ahowa, le tapiye fisiye ma'e howeinamiteye. ");
INSERT INTO sny_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Meni ape Jisas siyeye su, le Jisas ma'e winetairai, meni ape Jisas ma'e peri hare uteyei erasi irowe, “Jisas, ne piyene ane ma'e au luwaruwenamisiya awere? Ne Owane Sitewi, Tai Pefine a'i lo meni eime ne. Ne ane ma'e owe ape au luwaruwere!” ");
INSERT INTO sny_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Sepei luwaru a'i werese meni ape sahe mi mi pasi pasi weriyei ya'orenamiteye. Lu tamo lai meni ape lo ereti, lowe wafei tepi tahe se au ti tawesiye su, sepei luwaru a'i lai wafei tepi tahe ape au ani erau sasarisawi. Lu tamo meni ape au noweinoweiteye su, lowe atoweiye iteroti. Meni ape wafei tepi tahe ani erauwe su, sepei luwaru a'i lai meni ape pani lu ariye a'i ma'e heneti. Jisas peri ape wanuwe su, le sepei luwaru werese a'i meni ape lo au sasariye. ");
INSERT INTO sny_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Serai Jisas le ma'e ei toweriye, “Iyape no eiwerou awere?” Sepei luwaru a'i le ma'e itiya'u eiye, “Iyape nomo lo tomu ne'ese ne!” Ipari tomu ne'ese meni ape papu ya'orenamiteye. ");
INSERT INTO sny_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Serai sepei luwaru a'i werese le ma'e te'e toweriye, “Ne nomo fisiye yo ma'e, sitewi ta'ame ape, owe ape eimawesawire.” ");
INSERT INTO sny_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Omo tewi ma'e, iroteye ape, fe tomu ne'ese awei ma'e horuse ene ateye. Sosu sepei luwaru a'i fe ape mo siyeye. Lowe Jisas ma'e te'e toweriye, “Ne fara'u nomo werese fe papu eimawesawire.” Jisas lowe ma'e eiye, “Ire!” ");
INSERT INTO sny_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Serai sepei luwaru a'i meni ape arunatiyewe, fe werese papu wiye. Sepei luwaru a'i fe papu wiye su, fe werese omo hire itero itoriyewe, sa'i hi ma'e papu wi tenise po'uteye. ");
INSERT INTO sny_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Lu werese, fe ape mo au noweinoweiteye ape, lowe omo lowe lo ma'e iteroti. Lowe lu taune werese omo pani ma'e peri heneruwe ape au te'e fiyarisawi. ");
INSERT INTO sny_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Serai lu taune peri heneruwe wanuwe su, lowe etiri ape siyeyei ne fai. Lowe Jisas ma'e henerai su, lowe meni ape, Jisas sepei luwaru a'i au sasariye ape, lowe meni marepi wisere a'i se siyerai. Le ipari tahe ani asiteye Jisas lo lowe sahe peri lo onu wanuteye. Lowe werese meni ape siyeye su, lowe marepi atoweiye irowe. ");
INSERT INTO sny_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Lu tamo Jisas sepei luwaru a'i au sasariye ape, siyeye su, lowe peri heneruwe lowe ma'e au te'e fiyariye. Lowe apou au te'eye, “Meni Jisas sepei luwaru a'i meni ape lo au sasariye su, le ipari werese fe nomo lo papu eimawesawi. Serai fe werese omo ma'e itori sa'i papu fi. Le lai meni eite au ta'ane fara'uweye.” ");
INSERT INTO sny_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Lu taune werese, omo pani Gerasa iroteye ape, peri heneruwe wanuwe su, lowe le ma'e te'e toweriye, “Ne omo pani nomo lo eite arunatirowawe ire.” Lowe werese marepi erasi a'i atoweiyenamiteye. Serai Jisas lu disaipel lo aiwawe a'i wai papu awetowewe, hare ite ponei tewi a'i iyatutiteye. ");
INSERT INTO sny_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Meni ape Jisas sepei luwaru a'i au sasariye ape, le ma'e ei toweriye, “Ane fara'u fene mase aiwawe iyei awere?” Jisas le omo topo lo ma'e eimawesawi apou itiya'u eiye, ");
INSERT INTO sny_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ahowa, ne wesi no ire. Ne lu taune werese ma'e apou au te'ere. “Peri ano wanure! Meni ape, Jisas, le sepei luwaru werese a'i ano au sasari po'uteye. Serai ane meni aseyaro a'i henerai.” Serai meni ape wesi lo ma'e fi. Le lu taune werese, omo werese iroteye ape apou au te'eye, “Jisas lai sepei luwaru a'i werese ano au sasarisawi.” ");
INSERT INTO sny_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Sosu a'i pe Jisas hare ite ape si tame iyatu toneri su, lu taune tomu ne'ese le ma'e wisere a'i au eriteyei ne ta'uwerai. Lowe Jisas onu ninaweteteye. ");
INSERT INTO sny_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Lowe wai sa'i senitewi ma'e furi su, meni ta iyape, Jairus, Jisas ma'e peri ta ei toweriyei ne fai. Meni ape ta'uweyei lo wesi meni owane ne. Le Jisas lo lowe sahe ape'i onurai. Le Jisas ma'e apou ei toweriye, “Meni Owane, ne wesi ano fa aiya. ");
INSERT INTO sny_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Eime taune ano u tahe erasi se temeniye ataheyewa.” Eime taune ta'i a'i lo iyu menei ereti feni hesi lowe hesi a'i ne (12). Jisas meni ape aiwawe fi su, lu taune tomu ne'ese yo mai lowesi lo tei tawesinamiteye. ");
INSERT INTO sny_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Sosu a'i pe menitani naihe Jisas ma'e heneri. Le u fisa'i se iyu menei ereti feni hesi lowe hesi a'i (12) fisa'i weriyei weriyei heneraiteye. Lu dokta tomu ne'ese u tahe se lo au ta'ane fara'uwerowata. ");
INSERT INTO sny_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Menitani apou toteye, “Ane ereti ano se Jisas lo ipari tahe tewi a'i sahe fu teriteyei su, u tahe ano po'uterowa.” Serai le Jisas lo me'iyeni ma'e ipari tahe lo sahe isawe hetesiyeye su, u tahe lo po'ute tepa'asiye. ");
INSERT INTO sny_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Sosu Jisas apou eiye. “Eiwerai ipari tahe ano sahe isawe hetesiye awere?” Lu taune ta'i ta'i a'i le ma'e itiya'u eiye, “Ane lai ta'ame.” Sosu Pita itiya'u eiye, “Meni Owane siyere! Lu taune tomu ne'ese ne ma'e ataheyeraiwa. Ne piyene apou ei toweriye, ‘Eiwerai ipari tahe ano isawe hetesiyeye awere?’” ");
INSERT INTO sny_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ahowa, Jisas itiya'u eiye, “Menitani ta ipari tahe ano sahe isawe hetesiyeye. Kairefiyeyei tewi a'i ano ane arunatiyewe, menitani tahe ape papu wiye.” ");
INSERT INTO sny_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Serai menitani ape fareyarerowata. Sosu le Jisas atahe ma'e auseriyetai. Le nihari lo awei ma'e epe'e arowe. Le le ma'e peri morose apou eiye, “Meni Owane, ane lai ipari tahe no sahe isawe hetesiyeye. Ane marepi se toteye, ‘Ane ipari tahe lo ereti ano se isawe hetesiyeyei su, u tahe ano po'ute tepa'asiyei.’ Serai ane ipari tahe no sahe isawe hetesiyeye su, u tahe ano po'ute tepa'asiye.” Lu taune werese lo nihe se, menitani ape le ma'e eiye. ");
INSERT INTO sny_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Sosu Jisas menitani ape ma'e eiye, “Menitani, tote tawesiyei no lai u tahe no au iro po'uteye. Ne marepi fetane a'i se ire!” Lu 7:50 ");
INSERT INTO sny_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jisas peri te'eye su, meni ta ta'uweyei wesi meni owane lo wesi ma'e fai. Le apou eiye, “Jairus, eime taune no temeniyeye. Ne meni owane ape piyene yahowa'i a'i owe ape henetaire awere!” ");
INSERT INTO sny_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jisas peri ape wanuwe su, le Jairus ma'e itiya'u eiye, “Taweiru sawa! Owane Sitewi ma'e tote tawesire! Ne Owane Sitewi ma'e tote tawesiyei su, eime taune no si tame sineteyei. U tahe lo po'ute tepa'asiyei.” ");
INSERT INTO sny_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Serai lowe Jairus lo wesi heneri su, le lu taune werese wesi papu wiyei ape, einamiye. Lu disaipel lo hesi heta, Pita, Jems, Jon, eime taune lo tai mai, le lowe a'i wesi tewi papu hene wiye. ");
INSERT INTO sny_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Lowe wesi tewi papu wiye su, lu taune tomu ne'ese ewite luwei erasi irowe. Sosu Jisas lowe werese ma'e eiye, “Luwei sawa! Eime taune ape temeniye ta'ame. Le nihe howeisiya.” ");
INSERT INTO sny_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Lu taune werese peri lo wanuwe su, lowe Jisas ma'e niyeyei erasi irowe. Lowe eime taune temeniyeyei so'oruweye a'i ne. ");
INSERT INTO sny_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Serai Jisas eime taune lo wari sahe atahe teiye su, le eime taune lo ereti aniteyewe, le ma'e eiye, “Eime taune, ne sinere!” ");
INSERT INTO sny_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Pereye a'i eime taune lo hepene tahe pa'are papu si tame wiye. Le wari lo sahe sine onuwe. Eime taune sine onuwe su, Jisas lowe ma'e eiye, “Fene eime taune ape ma'e ayei ta au are!” ");
INSERT INTO sny_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Eime taune lo tai mai siyeye su, lowesi hepene se su'ariye. Serai Jisas lowesi ma'e eiye, “Fenesi lu taune ma'e owe ape au te'ete!” ");
INSERT INTO sny_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Sosu a'i pe Jisas lu disaipel lo aiwawe a'i Jairus lo wesi arunati su, le lu disaipel (12) ei aniye. Le lowe ma'e kairefiyeyei ta auwe. Lowe kairefiyeyei lo se fara'u sepei luwaru a'i au ta'ane sasarisawiyei. Lu taune lo u tahe werese, lowe kairefiyeyei lo se au ta'ane fara'uweyei. ");
INSERT INTO sny_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Le omo pani werese ma'e Owane Sitewi lo peri au te'eyei ne, u tahe werese au ta'ane fara'uweyei ne eimawesawi. ");
INSERT INTO sny_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Le lowe ma'e eiye, “Fene iyei su, etiri werese mase owe ape aiti. Fene me epi, niye, nau ta'ase, ma'aru tamo owe ape aiti. Ipari tahe ta'i a'i fene ani asiyei. Ipari tahe tere'e owe ape aiti. ");
INSERT INTO sny_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Omo ta ma'e heneriyei su, fene wesi ta'i wire. Fene wesi ape sahe a'i ironamire. Fene Owane Sitewi lo peri au te'e tepa'asiyei su, fene wesi ape arunatirowawe ire. ");
INSERT INTO sny_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Lu taune tamo lai fene ma'e erite ta'ame su, fene lowe me'iyeni ma'e atati arure. Fene omo lowe lo arunatiyei su, fene awei onopu, lowe fene lo sahe irowei ape, aine tasenere. Fene peperi ato periperenatiyei su, fene lowe ma'e Owane Sitewi lo ai peri au atuatu areiyeyei.” Lu 10:4-11 ");
INSERT INTO sny_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Sosu Jisas lowe ma'e au te'e tepa'asiye su, lowe omo pani werese ma'e Owane Sitewi lo peri au te'eyei ne fi. Lowe lu taune u tahe werese au ta'ane fara'uweye. ");
INSERT INTO sny_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Sosu a'i pe awei meni owane iyape Herot. Le wiyawi werese, Jisas iroteye ape, wanuwe su, le marepi lo tote eti perati iroteye. Lu tamo le ma'e apou eiye, “Meni ape, wiyawi pefine erasi a'i iroteye ape, le meni Jon sa'i au hu siye meni ne. Le si tame norohuwe sineye.” Mt 16:14; Mk 8:28; Lu 9:19 ");
INSERT INTO sny_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Lu tamo tere'e apou eiye, “Meni ape Owane Sitewi lo peri au te'e siye meni Elaija si tame henerai.” Lu tamo tere'e apou eiye, “Meni ape Owane Sitewi lo peri au te'e siye meni tu naifa weriyei si tame norohuwe sineye.” ");
INSERT INTO sny_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Awei lo meni owane Herot meni ape ne apou toteye, “Ane lai Jon sa'i au hu siye meni lo mato aine tou aniye. Meni ape wiyawi erasi a'i irowe ape, eiwerai awere?” Le Jisas ma'e siyeriyei ne toteye. Lu 23:8 ");
INSERT INTO sny_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Sosu a'i pe Jisas lo lu feni si tame fai su, lowe le ma'e peri heneruwe, etiri werese irowe ape, ne au te'eye. Serai Jisas lu taune werese arunatiyewe, lu disaipel lo mase omo Betsaida ma'e eresene a'i fi. ");
INSERT INTO sny_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ahowa, lu taune werese lowe siyesawi. Sosu lowe werese mo'o umasiti. Lowe le ma'e ta'uwerai su, le lowe ma'e ei eriteye. Le Owane Sitewi lo peri lowe ma'e au te'e fiyariteye. U tahe werese lowe lo au ta'ane fara'uweye. ");
INSERT INTO sny_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Nowe poweiye itoriye su, lu feni werese lo le ma'e te'erai, “Ne lu taune werese omo omo lo ma'e eimawesawire! Nowe pasiyewa. Ne lowe ma'e ayei ta eteyei ne eimawesawire. Aiwawe a'i lowe fara'u wesi ta howeiyei ne nehiye. Omo eite sahe wesi ariye a'i ne.” ");
INSERT INTO sny_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ahowa, Jisas lu disaipel lo ma'e apou eiye, “Fene lai lowe ma'e ayei ta au ene are!” Lowe le ma'e itiya'u eiye, “Wanure, nomo nau ta'ase oso ereti feni werese hare hesi a'i irosiya. Nomo ayei ta eteyei ne iyei awere? Lu taune tomu ne'ese a'i ne!” ");
INSERT INTO sny_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Lu eiwerou a'i awere? Lu 5,000 aiwawe a'i ne! Ahowa Jisas lowe ma'e eiye, “Fene lu taune werese ma'e, weneri 50 aiwawe a'i, senarepe sahe ei ta'uwe onurire.” ");
INSERT INTO sny_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Sosu lu taune werese weneri ta weneri ta onuti. ");
INSERT INTO sny_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Lu taune onu tepa'asiye su, le nau ta'ase ereti feni werese, hare hesi ereti aniteye. Sosu Jisas hire ma'e siyeye su, Owane Sitewi ma'e au te'e wisereyeye. Sosu le ayei werese ani topoto lu feni ma'e auwe. Lu feni lu taune werese ma'e none ereititeye, none ereitaiteye. Lu taune werese lire ene a teme'eriyeye. Sosu lowe none ereiti tepa'asiye. ");
INSERT INTO sny_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Lowe werese ene a tepa'asiye su, lu disaipel ape mo nau ta'ase hare tewi a'i tamo si sowe ta'uwe aniyewe, ipi papu sowe asi lotowe. Lowe ipi ereti feni hesi lowe hesi a'i (12) sowe asi teme'eriyeye. ");
INSERT INTO sny_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Sosu a'i pe Jisas lu disaipel lo aiwawe a'i lu taune werese arunatiyewe, lu omo ariye a'i ma'e fi. Le Owane Sitewi ma'e au te'eyei ne fi su, le lowe ma'e ei toweriye, “Lu taune werese, lowe ane ne, ane piye meni totesiya awere?” ");
INSERT INTO sny_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Lowe le ma'e itiya'u te'eye, “Jon sa'i au hu siye meni, lu taune tere'e Elaija totesiya. Lu taune tere'e apou totesiya, ne Owane Sitewi lo peri au te'e siye ya'ariyei meni weriyei, si tame norohuwe sineye.” Lu 9:7-8 ");
INSERT INTO sny_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Sosu le lowe ma'e ei toweriye, “Fene lai, fene ane ne piye meni totesiya awere?” Sosu Pita le ma'e itiya'u eiye, “Ne meni wiyeme a'i Owane Sitewi lai ariariyeye ape.” Jo 6:68-69 ");
INSERT INTO sny_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Serai Jisas Pita lo peri wanuwe su, le lowe ma'e kairefi se apou eiye, “Fene peri eite lu taune werese owe ape au te'ete!” ");
INSERT INTO sny_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Le lowe ma'e tame eiye, “Ane meni pefine a'i, hire ma'e itorai ape, lu tamo lai ane ma'e au luwaruweyei. Ane fofowei erasi a'i teriteyei. Au heseyei lu owane werese, lu Farisi werese, Owane Sitewi lo yo peri lese siye lu werese, lowe ane ne me'iyeni ma'e atati arunatirowawe, peri ano arisirowa. Me'iye su lowe ane aine tera'erowa. Ahowa, nowe mi hesi heta se, Owane Sitewi lai ane si tame au ta'ane norohuwe sinerowa.” Lu 9:44; 18:32-33 ");
INSERT INTO sny_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Sosu le lowe werese ma'e apou eiye, “Meni ta ane umasiyei su, le ta'u marepi topo lo hi tote ani ararowei. Sosu mi mi werese se le me tape'i topo lo ani sutetire. Ane ma'e umasire. Etiri luwaru a'i lowe ma'e heneraiyei su, lowe ane ne kairefi a'i se pei tote tawesite. Sosu ane ma'e umasire. Mt 10:38; Lu 14:27 ");
INSERT INTO sny_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Lu taune marepi towafi lowe lo umasiyei su, awei lo etiri werese ne tote tawesiyei su, lowe nowe te'e oso a'i iroteyei. Ahowa, lu taune ane ne marepi erasi a'i toteyei su, sosu awei lo etiri me'iyeni ma'e atati aruwei su, Owane Sitewi lai lowe ma'e marepi hepene he'i a'i mi mi pasi pasi aurowa. Mt 10:39; Lu 17:33; Jo 12:25 ");
INSERT INTO sny_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Meni ta etiri werese werese a'i ani ta'uwe lotowei su, sosu nowe me'iye le temeniyeyei. Etiri werese lo eiwerou irorowa awere? Meni ape lo yo seni luwaru a'i tene! Meni ape marepi hepene he'i a'i mi mi pasi pasi ironamitorowata. ");
INSERT INTO sny_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Lu taune ta ane ne, peri werese ano aiwawe a'i ne, neritaseyeyei su, ane, meni pefine hire ma'e itorai ape, ane awei hi ma'e si tame itorairowa su, ane lowe ne au neritaseyerowa. Ane si tame aiyerowa su, ane mitaiyeyei erasi pefine ano aiwawe aiyerowa. Ane Owane Sitewi tai wiyeme lo mitaiyeyei erasi, sosu Owane Sitewi lo ipari wisere lo mitaiyeyei erasi ane mase aiyerowa. Mt 10:33; Lu 12:9 ");
INSERT INTO sny_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Peri wiyeme a'i wanure! Fene ane mase, pereye nowe irosiya ape, fene Owane Sitewi lo kairefiyeyei, hi awei ma'e itoraiyei ape, siyerowa. Fene Owane Sitewi lo kairefiyeyei siyerowa su, sosu fene fara'u temeniyerowa.” Jisas peri lo tepa'asiye. ");
INSERT INTO sny_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Nowe mi ereti feni werese feni hesi heta (8) i tepa'asiye su, Jisas lo disaipel hesi heta Pita, Jems, Jon, le omo hire sahe Owane Sitewi ma'e au te'e tiyatiyei ne hene yaneye. ");
INSERT INTO sny_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Le Owane Sitewi ma'e au te'e tiyatiye su, nihari lo tere'e henerai. Ipari tahe lo wapo pefine a'i henerai. Mi wara'i wou a'i ne. ");
INSERT INTO sny_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Jisas Owane Sitewi ma'e au te'eye su, lu hesi hi ma'e itorai. Lowesi lo iyape Moses, meni tere'e lo iyape, Elaija. Lowesi mi erasi mase itorai. Lowesi Jisas ma'e au te'eteye. Lowe Jisas lo temeniyeyei lo nowe henerai ape, omo Jerusalem sahe te'e tiyatiteye. Lu 9:22 ");
INSERT INTO sny_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Sosu Pita, lu hesi aiwawe fai ape, lowe nihe howeiteye. Lowesi nihe petane sine siyeye su, lowe Jisas lo mi pefine a'i lu hesi, le mase teiteye ape, siyeye. 2 Pi 1:16-18 ");
INSERT INTO sny_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Lu disaipel lowe ma'e siyeye su, lu hesi, itorai ape, ni'arawe hire ma'e si tame siye aroweye. Serai Pita Jisas ma'e eiye, “Meni Owane, nomo ne mase sato irosiya. Eite wisere a'i ne. Nomo ipo wesi hesi heta fara'u ta'aneyei. Ipo wesi ta'i ne ne ta'aneyei, ta'i Moses lo ne, ta'i Elaija lo ne ta'aneyei.” Pita peri topo lo so'oru ta'ama. ");
INSERT INTO sny_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Sosu Pita peri ape lo au te'eye su, aitu sapu erasi, hi ma'e itorai ape, lowe werese napetuwe. Aitu sapu lowe napetuwe su, lowe taweiru a'i iroteye. ");
INSERT INTO sny_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Wanure! Peri erasi aitu sapu ma'e apou uteye, “Meni ape meni eime ano ne! Ane tu naifa weriyei weriyei le ariariyeye. Fene peri lo wanu umasite!” Lu 3:22 ");
INSERT INTO sny_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Peri ape te'e tepa'asiye su, Jisas, lu disaipel hesi heta lo aiwawe a'i sato iroteye. Aitu sapu ape, lu hesi hire ma'e wiye. Lu disaipel hesi heta ape nowe ape se lowe lu taune werese ma'e etiri werese, lowe siyeye ape, au te'eye ta'ama. ");
INSERT INTO sny_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Nowe mo'o su, lowe omo ape hi ma'e itorai su, lu taune tomu ne'ese Jisas ma'e siyeyei ne ta'uwerai. ");
INSERT INTO sny_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Omo hi ma'e itorai su, meni ta'i le ma'e uteye, “Meni Owane, ne meni eime ano siyeyei ne fa aiya. Meni eime ape, meni eime ta'i a'i ano ne. ");
INSERT INTO sny_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Nowe tomu ne'ese se, sepei luwaru a'i le ya'orenamiteye. Le hareyei erasi uteteye. Sepei luwaru ape mo, lowe lai le hi awei ma'e fu arowe. Tahe werese lo auseriye meremereyenamiteye. Ahi pisa'i wapo a'i heneraiteye. Sepei luwaru a'i ape mo mi mi werese le ma'e au luwaruwenamiteye. Le meni eime arunatirowata. ");
INSERT INTO sny_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ane lu feni no ma'e meni eime ano ei toweriyei ne henetai. Lowe sepei luwaru a'i ape au ta'ane sasarirowata.” ");
INSERT INTO sny_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Sosu Jisas le ma'e itiya'u eiye, “Lu taune werese, fene tote tawesiyei fene lo ariye a'i awere? Fene marepi towafi fene lo tote fareraiye ta'ame. Nowe eiwerou a'i ane fene mase ironamirowa awere? Eiwerou su fene siye so'oruweyei awere?” Sosu le meni ape ma'e eiye, “Ne meni eime no heneta.” ");
INSERT INTO sny_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Sosu meni ape meni eime lo henetai su, sepei luwaru a'i ape mo meni eime hi awei ma'e fu arowe. Tahe lo erasi a'i auseriye meremereyeteye. Serai Jisas meni eime siyeye su, le sepei luwaru a'i einamiyewe, au sasarisawi. Meni eime ape wisere a'i henerai. Sosu Jisas le tai lo ma'e si tame auwe. ");
INSERT INTO sny_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Lu taune werese etiri ape siyeye su, apou toteye, “Nomo hepene se su'ariye, Owane Sitewi lai wisere pefine a'i tene!” Lu taune werese hepene se su'ariye irowe su, le lu disaipel lo ma'e apou eiye, ");
INSERT INTO sny_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Fene peri ano marepi fene lo papu wanu etire! Ane, meni pefine a'i hire ma'e itorai ape, meni ta lai ane lu tewi luwaru a'i ma'e au henetirowa.” Lu 9:22 ");
INSERT INTO sny_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Lu disaipel lo, peri lo sitewi wanu so'oru ta'ama. Owane Sitewi lai peri sitewi lo lowe ma'e fareyareteye. Lowe Jisas ma'e peri sitewi lo au ei toweriyei ne toteye su, Ahowa, lowe marepi atoweiyeye ne. Serai lowe le ma'e ei toweri ta'ame. Lu 18:34 ");
INSERT INTO sny_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Sosu a'i pe lu disaipel lo lowe ai peri au te'e tiyatiteye. Lowe apou ei toweriye, “Nomo eiwerai a'i tutawe henerairowa awere?” Lu 22:24 ");
INSERT INTO sny_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Serai Jisas marepi lowe lo siye so'oruwe tepa'asiye su, le meni eime ta lu disaipel lo ponei ma'e au ani teiteye. ");
INSERT INTO sny_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Sosu le lowe ma'e eiye, “Meni ta iyape ano se meni eime ape au isafiye wisereyerowa su, le ane ma'e aiwawe a'i au isafiye wisereyerowa. Serai meni ape ane ma'e au isafiye wisereyeyei su, le Owane Sitewi Pefine wiyeme a'i ma'e, ane hi ma'e eimawe arosai ape, meni ape le ma'e aiwawe a'i au isafiye wisereyeyei. Meni ta iyape topo lo hi ani ararowei su, le meni tutawe henerairowa.” Mt 10:40 ");
INSERT INTO sny_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Serai Jon le ma'e itiya'u eiye, “Meni Owane nomo lo, nomo meni ta sepei luwaru a'i iyape no se au ta'ane sasarisawi ape, siyeye. Serai nomo meni ape einamiei ne toteye.” ");
INSERT INTO sny_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jisas le ma'e itiya'u eiye, “Fene meni ape owe ape einamire. Meni ta wiyawi nomo lo aiwawe a'i ta'aneyei su, le nomo ma'e ai atu tiyatirowata.” Mt 12:30; Lu 11:23 ");
INSERT INTO sny_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Sosu a'i pe nowe ape se Jisas Owane Sitewi lo omo hire ma'e wiyei ne ataheyeraiwa. Serai le apou tote eti kairefiyeye, “Ane omo Jeruralem ma'e fa iyei ne.” ");
INSERT INTO sny_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Sosu le lu tamo tu eimawesawi. Lowe lu Samaria lo omo ma'e heneri su, lowe wesi ta Jisas, lu feni aiwawe a'i, nihe howeiraiyei ape, au ta'uwe naneiyei ne fi. ");
INSERT INTO sny_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Jisas lai omo Jeruralem ma'e kairefi a'i se iyei ne toteye. Serai Samaria lo lu taune le ne me'iyeni ma'e atati aruwe. Serai lowe wesi lo sahe howeirowata. ");
INSERT INTO sny_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Lu ape mo Jisas ma'e si tame fai su, lowe lu Samaria lo marepi au te'esai. Jisas lo lu disaipel hesi a'i Jems, Jon. Lowesi peri heneruwe ape wanuwe su, lowesi Jisas ma'e ei toweriye, “Nomo fara'u Owane Sitewi ma'e ei toweriyei, ‘Owane Sitewi ne yehe erasi hi awei se eito lowe werese fa ti sero'owei ne eimane arosa. Fara'u awere?’” 2 Kin 1:9-16 ");
INSERT INTO sny_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ahowa, Jisas lowe ma'e atati siye etiye su, lowesi ma'e eiye, “Ahowa!” ");
INSERT INTO sny_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Serai lowe werese omo ape awera'iyenatiyewe, omo tere'e ma'e howeiyei ne fi. ");
INSERT INTO sny_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Sosu a'i pe lowe omo tere'e ma'e fi su, meni ta Jisas ma'e eiye, “Ane lai ne eiwerou ma'e iyei ape, mi mi werese ane ne mase umasinamirowa.” ");
INSERT INTO sny_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jisas le ma'e itiya'u eiye, “Ne tu marepi no tote ereire. You erauwe awei yo sahe fara'u howeisiya. Irowe werese uri towafi lowe lo se howeisiya. Ahowa, ane, meni omo hire ma'e itorai ape, ane yaru ta howeiyei se ta'ama.” ");
INSERT INTO sny_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Sosu Jisas meni tere'e ma'e eiye, “Ne ane mo'o umasita!” Meni ape itiya'u eiye, “Ei, ane ne mo'o umasiyei. Weiya! Ane tu tai ano, temeniyeye ape, fisiye yo sahe towasi nariyei.” ");
INSERT INTO sny_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ahowa, Jisas le ma'e itiya'u eiye, “Lu tamo peri ano wanu umasi se ta'ama ape, lowe fara'u tahe pa'are werese towasi nariyei. Ne lai Owane Sitewi lo nowe se, le lu taune werese au noweinoweitorowa ape, ne lu taune ma'e omo omo werese sahe au te'e fiyarite. Ne lai Owane Sitewi lo kairefiyeyei ne omo omo werese sahe lu taune ma'e au te'e fiyarite.” ");
INSERT INTO sny_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Sosu meni tere'e Jisas ma'e eiye, “Owane, ane ne mo'o umasiyei. Weiya! Ane tu wesi ano ma'e fa iyei su, ane lu tewi ano eriteyei ne iyei. Mo'o su, ane ne mo'o umasiyei.” 1 Kin 19:20 ");
INSERT INTO sny_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ahowa Jisas le ma'e eiye. “Meni ta ane mo'o umasiyei ne toteyei su, le marepi farere a'i se umasiyei. Le marepi hesi a'i hesi a'i owe ape tote umasite. Meni ta marepi hesi a'i hesi a'i tote umasiyei su, le a'i lai, nowe ape se, Owane Sitewi lai lu taune werese au noweinoweitorowa ape, siyerowata. Owane Sitewi lai le ne me'iyeni ma'e atati arurowa.” ");
INSERT INTO sny_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Mo'o a'i pe Meni Owane Jisas lu feni tere'e tomu ne'ese (72 aiwawe a'i ne), Owane Sitewi lo peri au te'e fiyariyei ne ariariyeye. Le lowe werese hesi a'i hesi a'i omo omo werese ma'e eimawesawi. Nowe me'iye su omo omo werese lu hesi a'i hesi a'i au te'eye ape, le mo'o umasiyei. Mk 6:7 ");
INSERT INTO sny_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Sosu le lowe ma'e eiye, “Lu taune tomu ne'ese omo omo werese sahe Owane Sitewi lo yo seni umasi se ta'ama ape, serai fene Owane Sitewi fene ma'e lu taune ne apou ei towerire, ‘Owane Sitewi, lu weneri oso a'i tamo lai peri no au te'esiya. Lu taune tomu ne'ese peri no arisinamisiya. Serai ne lu ne'ese tere'e lowe ma'e au te'eyei ne ariariyere. Serai ne lowe ma'e peri no au te'e fiyariyei ne eimawesawire.’ Mt 9:37-38; Jo 4:35 ");
INSERT INTO sny_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Serai fene omo werese ma'e ire! Ane fene lu taune tamo ma'e, ai marepi Owane Sitewi ne totesiya ape, eimawesawiyei. Fene fe sipsip lo yene wou a'i ne. Ane fene lu taune ma'e eimawesawiyei su, lu taune ape mo you erauwe wou a'i ne. Lowe lai fene au luwaruweyei ne totesiya. Mt 10:16 ");
INSERT INTO sny_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Fene iyei su, ipi werese, owe ape wa'aretire, niye owe ape wa'aretire. Lowe tahe fene lo owe ape ani asire. Fene kaiyemo ta yo sahe siyeyei su, fene peri yahowa'i a'i owe ape tei te'e tiyatite. Mt 10:7-14; Mk 6:8-11; Lu 9:3-5 ");
INSERT INTO sny_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Fene meni owane ta lo wesi wiyei su, fene tu le ma'e apou eire, ‘Marepi fetane a'i lu taune ma'e wesi eite sahe ironamite.’ ");
INSERT INTO sny_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Meni ape marepi fetane a'i wesi ape sahe iroteyei ape, Owane Sitewi marepi fetane a'i le mase ironamirowa. Meni ta ai marepi wesi ape sahe iroteyei su, Owane Sitewi lo marepi fetane a'i fene ma'e si tame itiya'u aiyerowa. ");
INSERT INTO sny_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Wiyawi meni owane, le lai wiyawi lu tewi lo ma'e ma'aru auwei. Serai fene wesi ta wiyei su, meni owane lai fene ma'e ayei ta, sa'i ta au ene ayei. Ayei ape wiyawi ma'aru fene lo ne fene fara'u ayei lo ene are. Fene wesi tere'e tere'e ma'e owe ape sewiyetite! 1 Ko 9:6-14; 1 Ti 5:18 ");
INSERT INTO sny_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Sosu fene omo ma'e wiyei su, lu taune fene ma'e eriteyei su, fene ayei werese lowe fene ma'e au ene ayei ape, are. 1 Ko 10:27 ");
INSERT INTO sny_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Lu taune ta u tahe se, fene u tahe lowe lo au ta'ane fara'uwere! Sosu lowe ma'e eiye, ‘Nowe ape se, Owane Sitewi lu taune au noweinoweirowa ape, fene mase ataheyewa!’ ");
INSERT INTO sny_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ahowa, fene omo ta ma'e wiyei su, lu taune fene erite ta'ame su, fene omo lo pani amerame a'i ma'e ire! Lu taune werese ma'e apou eire, ");
INSERT INTO sny_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Peri nomo lo wanure! Peperi werese fene lo lowe nomo lo sahe nate tawesisiya su, nomo peperi werese au sasariyei. Nomo peperi fene lo au sasariyei su, marepi sitewi apou a'i totesiya, Owane Sitewi lai fene ma'e ai marepi totenamisiya. Fene werese etiri ta ani so'oruwere. Nowe ape se, Owane Sitewi lu taune au noweinoweirowa ape, wiyeme a'i fene ma'e ataheyewa.’ Ap 13:51; 18:6 ");
INSERT INTO sny_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ane fene ma'e eisiya. Nowe ye'ewi su Owane Sitewi lai lu taune werese lo yo seni au hese ereirowa su, lu taune tewi ape mo, omo Sodom sahe tu naifa iroteye ape, Owane Sitewi lai lowe ma'e fofowei oso a'i au irorowa. Ahowa, lu taune tewi ape mo peri fene lo wanu arisiyei su, Owane Sitewi lai yo seni lowe lo au hese ereirowa su, lowe fofowei erasi pefine a'i teriterowa. Stt 19:24-25; Mt 10:15; 11:24 ");
INSERT INTO sny_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Lu taune omo Korasin sahe irosiya ape, lu taune omo Betsaida sahe irosiya ape, fene werese weiyai! Ane wiyawi erasi pefine ne'ese a'i omo fene lo sahe au ta'ane atuatuteye. Meni ta Owane Sitewi lo wiyawi erasi pefine a'i ape mo, lu taune ma'e omo Saidon, omo Tair irosiya ape, au ta'aneteye su, lowe werese yo seni luwaru a'i, lowe iroteye ape, me'iyeni ma'e witane a'i arunatirowawe, Owane Sitewi ma'e atati teirowa. Lowe yo seni luwaru a'i lowe lo ape ne ewite erasi a'i toterowawe, lowe ipari tahe luwaru papa'u a'i se ani asiteye. Lowe yehe kere, peperi lo'u a'i tepi tahe werese sahe aniterowa. Lowe Owane Sitewi ma'e ewiteyei lowe lo au atuatu areiyerowa. ");
INSERT INTO sny_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Nowe ye'ewi se Owane Sitewi lai yo seni werese au hese ereirowa su, omo Tair, omo Saidon, lo lu tewi werese Owane Sitewi lai lowe ma'e fofowei oso a'i aurowa. Ahowa, fene werese Owane Sitewi lo peri wanu tote arisinamiteye su, Owane Sitewi fene werese ma'e fofowei erasi wiyeme a'i aurowa. ");
INSERT INTO sny_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Fene lu tewi omo Kaperneam sahe irosiya ape, eiwerai fene werese Owane Sitewi lo omo hire ma'e hene wirowa awere? Ahowa, fene Owane Sitewi lo omo hire ma'e wirowata. Owane Sitewi lai ane fene werese yehe omo pefine a'i ma'e ani fu arosawirowa.” ");
INSERT INTO sny_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Sosu Jisas lu feni werese lo (72 aiwawe a'i), le omo werese ma'e eimawesawi ape, tame au te'eye, “Lu taune werese peri fene lo wanu umasiyei su, lowe aiwawe a'i peri ano wanu umasiyei. Lu taune werese peri fene lo wanu tote arisiyei su, lowe werese peri ano wanu tote arisiyei. Lowe ane ne me'iyeni ma'e atati aruwei su, lowe lai, Owane Sitewi ne, ane hi awei ma'e eimawe arosai ape, lowe le ne aiwawe a'i me'iyeni ma'e atati arunatinamiyei.” Serai Jisas peri ape au te'e tepa'asiye su, le lowe werese omo omo werese ma'e Owane Sitewi lo peri au te'e fiyariyei ne eimawesawi. Mt 10:40; Lu 9:48; Jo 5:23 ");
INSERT INTO sny_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Sosu a'i pe lu feni werese lo, Jisas omo ma'e eimawesawi ape, lowe le ma'e si tame te'e areiyenarai. Lowe werese marepi wisere a'i se Jisas ma'e apou eiye, “Meni Owane, nomo sepei luwaru a'i ne iyape no se au sasariye su, lowe werese peri nomo lo wanu umasiye.” ");
INSERT INTO sny_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Sosu Jisas lowe ma'e itiya'u eiye, “Fene sepei luwaru a'i au sasariye su, ane lai sepei Satan, omo hire ma'e winetairai ape, siyeye. Mera'o mi wou winetairai. Jo 12:31; KTH 12:8-9 ");
INSERT INTO sny_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Peri ano wanure! Ane fene ma'e kairefiyeyei ano auwe. Fene haru aimesi, heripahari werese, fene lowe fene lo hire ma'e uweiti arowatowei su, lowe fene lo sahe tomuwei su, fene fofowei se teriterowata. Kairefiyeyei ano se fene lai sepei luwaru werese a'i hi ani ararowe. Lowe werese fene ma'e au luwaruwerowata. Sng 91:13; Mk 16:18 ");
INSERT INTO sny_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ahowa, fene etiri ape ne marepi wisere a'i owe ape tote-re. Ane apou a'i totesiya, sepei luwaru werese a'i peri fene lo wanu umasiyei. Fene marepi erasi a'i owe ape totere. Ahowa, fene werese marepi wisere a'i se apou totere. Fene werese iyape towafi fene lo ne Owane Sitewi lai omo lo sahe lese tepa'asiye. Fene marepi erasi a'i tote nine'ite.” Fl 4:3; KTH 3:5 ");
INSERT INTO sny_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Sosu a'i pe pereye nowe eite se, Jisas Owane Sitewi lo Hepene Wara'i a'i se Owane Sitewi Tai pefine a'i ma'e au te'e wisereyeteye. Le Owane Sitewi Tai Pefine a'i ma'e au te'eye, “Ane ne ma'e au te'e wisereyesiya. Ne omo hire ma'e no Meni Owane Pefine a'i ne! Awei hi ma'e aiwawe a'i ne. Ne Meni Owane Pefine a'i ne. Lu taune tomu ne'ese apou totesiya, ‘Nomo etiri werese siye so'oruwe tepa'asiye.’ Serai etiri werese ape mo, ne lowe ma'e au fareyaresiya. Ahowa, ne lu taune yahowa'i a'i ma'e etiri werese au atuatu areiyeye. Ei! Tai Meni Owane ano, ne etiri ape mo lowe ma'e, ne au fareyareye ape, ne lai marepi no umasinamiteye.” ");
INSERT INTO sny_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Sosu Jisas lowe ma'e au te'eye, “Tai ano lai etiri werese ane ma'e au noweinoweiyei ne auwe. Owe lu taune tamo lai meni eime pefine so'oruwerowata. Ahowa, Tai ano, ne a'i lai a'i ane ne so'oruwesiya tene. Aiwawe a'i owe lu taune tamo Tai ano ne so'oru ta'ama. Meni eime lo a'i Tai topo a'i so'oruwe tepa'asiye tene. Ane lai marepi ano se lu taune, ane ariariyeye ape, ane lowe ma'e Tai ano au atuatu areiyerowa.” Jo 3:35; 10:15 ");
INSERT INTO sny_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Jisas peri tepa'asiye su, le, lu disaipel lo (12) eresene a'i fi. Jisas lowe ma'e eiye, “Fene lai wiyawi erasi pefine a'i, ane ta'aneteye ape, siyeye. Serai marepi fene lo wisere a'i ironamisiya. ");
INSERT INTO sny_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Serai ane fene ma'e eisiya. Tu naifa weriyei Owane Sitewi lo peri au te'e siye lu tomu ne'ese, awei lu owane aiwawe a'i, lowe lai etiri werese ane ta'aneteye ape, siyeyei ne totesiya. Lowe werese etiri apou ape siye ta'ame. Fene lai etiri apou ape mo siyesiya. Lowe tu naifa peri apou ape mo wanuwei ne totesiya. Ahowa, lowe peri apou ape mo wanu se ta'ame. Fene lai peri werese wanu tepa'asiye. Serai fene Owane Sitewi ma'e au te'e wisereyete.” ");
INSERT INTO sny_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Sosu a'i pe meni ta, Owane Sitewi lo yo peri siye so'oruweye ape, le Jisas ma'e au areareyei ne fai. Le Jisas atahe a'i teirai. Apou ei toweriye, “Meni Owane, ane Owane Sitewi lo omo hire ma'e wiyei ne totesiya. Ane eiwerou irowei su, ane marepi hepene he'i weriyei weriyei ani ironamirowa awere?” Mt 22:35-40; Lu 18:18 ");
INSERT INTO sny_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Sosu Jisas le ma'e itiya'u eiye, “Owane Sitewi lo yo peri sahe piye leseye awere? Ne piye siye te'eye awere?” ");
INSERT INTO sny_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Meni ape Jisas ma'e itiya'u eiye, “Ne Meni Owane Pefine a'i marepi erasi a'i tote wawesiyenamite. Ne marepi hepene werese no se, hepene werese no se, kairefi werese no se, sosu marepi werese no se, ne etiri werese ape se, ne Meni Owane Pefine a'i ne, marepi erasi a'i tote wawesiyenamite. Ne lu taune werese ne aiwawe a'i marepi erasi a'i tote wawesiyenamite. Ne tahe pa'are topo no ape ne marepi erasi a'i tote wawesiyeyei su, sosu aiwawe a'i ne lu taune tere'e werese ne marepi erasi a'i tote wawesiyenamite.” ");
INSERT INTO sny_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jisas peri ape wanuwe su, le meni ape itiya'u eiye, “Peri no wiyeme a'i te'eye. Ne etiri werese ne umasinamiyei su, ne marepi hepene he'i a'i weriyei weriyei ironamirowa.” Wkp 18:5 ");
INSERT INTO sny_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Meni ape Jisas lo peri wanuwe su, le Jisas lo peri au hese ereiyei ne toteye. Le Jisas ma'e ei toweriye, “Eiwerai kaiyemo ano awere?” ");
INSERT INTO sny_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jisas le ma'e itiya'u eiye, “Juda lo meni ta omo Jerusalem ma'e arunatiyewe fi. Omo Jeriko ma'e heneriyei ne toteye. Yo mai sahe memetaiteye su, ta'arei lu luwaru a'i tamo le ma'e etiri lo ta'arei aniyei ne aine naye. Lowe tahe pa'are aine naye su, lowe ipari tahe werese lo ani erauwe. Lowe etiri werese lo ta'arei aniyewe, iteroti. Meni ape temeniyeyei ne ataheyeye. ");
INSERT INTO sny_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Nowe oso a'i su, au heseyei meni owane ta memetaiteye. Le meni ape siyeye su, le yo mai tewiye sahe awera'iyenatiyewe fi. ");
INSERT INTO sny_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Sosu aiwawe a'i meni tere'e ta, Livai lo lu tewi yo mai memetaiteye. Le meni ape siyeye su, le yo tewiye ma'e awera'iyenatiyewe fi. ");
INSERT INTO sny_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Sosu mo'o meni ta Samaria lo meni yo sahe memetaiteye. Samaria lo lu taune werese lai Juda lo lu tewi ne ai marepi totenamiteye. Samaria lo meni yo sahe memetaiteye su, le meni ape siyeye. Apou toteye, ‘Sawi amou! Lu luwaru a'i meni ape ma'e aine naye. Ane meni ape siye ferafereiyei.’ Ferafereiyei lo meni ape ne erasi a'i ne. ");
INSERT INTO sny_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Serai le meni ape ataheyerai. Le sa'i wisere a'i wain sa'i aiwawe a'i enite werese papu ani teroso teineye. Sosu le enite werese au nateye. Le meni ape fe donki lo hire ma'e au onuwe. Sosu le meni ape howeiyei wesi ma'e au noweinoweiyei ne heneti. ");
INSERT INTO sny_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Nowe mo'o su, le howeiyei wesi meni owane ma'e apou eiye, ‘Ne meni ape ne au noweinoweire. Ane ma'aru hesi a'i ne ma'e auwei. Ma'aru hesi a'i aiwawe ta'ame su, ane si tame aiyeyei su, ane ma'aru tere'e ne ma'e aurowa.’” ");
INSERT INTO sny_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Sosu Jisas Owane Sitewi lo yo peri ani so'oru siye meni ma'e apou ei toweriye, “Lu hesi heta ape ne, eiwerai meni ape, lu luwaru a'i aine naye ape, lo kaiyemo awere?” ");
INSERT INTO sny_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Meni ape itiya'u eiye, “Meni ape lai meni ma'e au ferafereiye.” Jisas le ma'e eiye, “Ei, ne yo seni apou ape aiwawe a'i irorite.” ");
INSERT INTO sny_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Sosu a'i pe Jisas lu disaipel lo aiwawe a'i yo mai memetaiteye. Lowe omo ta heneri su, menitani ta le ma'e ei toweriyei ne fai, “Meni Owane, ne wesi notosi lo sahe fetaneyeyei ne aiya.” Menitani iyape Mata. Le Jisas wesi lo ma'e heneti. ");
INSERT INTO sny_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Jisas wesi lo wiye su, Marta lo einei, iyape Maria, Jisas lo lowe saro onuteyewe, peri lo wanuteye. Jo 11:1; 12:2-3 ");
INSERT INTO sny_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ahowa, Marta lai etiri werese au ta'uwe naneiteye. Sosu le Jisas ma'e eirai, “Meni Owane, einei ano siyere! Le tahe onota'ano a'i ne! Ane etiri werese au ta'uwe naneiyei ne irosiya. Ane wiyawi erasi ta'ane tohotesiya. Ne Maria ma'e eire! ‘Ne einei no ma'e au pati ta'anere.’” ");
INSERT INTO sny_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Meni Owane Pefine a'i lai Marta ma'e itiya'u eiye, “Marta, Marta, ne etiri tomu ne'ese marepi orese a'i se totesiya. Ne marepi orese a'i owe ape totere! ");
INSERT INTO sny_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Menitani Maria, le peri ano wanuwei ne totesiya. Etiri werese tere'e yahowa'i a'i ne. Le yo seni pefine a'i umasiyei ne ariariyesiya. Serai ane le ma'e apou eirowata, ‘Ne einei no fa au pati ta'anere.’” Mt 6:33 ");
INSERT INTO sny_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Nowe mo'o su Jisas Mata lo wesi arunatiyewe fi su, le lu disaipel lo aiwawe a'i omo pani ta Owane Sitewi ma'e au te'eyei ne fi. Le Owane Sitewi ma'e au te'e tepa'asiye su, meni disaipel lo ta Jisas ma'e eirai. “Meni Owane, meni Jon sa'i au hu siye meni lu feni lo Owane Sitewi ma'e au te'eyei ne au atuatuwe. Ne nomo aiwawe a'i Owane Sitewi ma'e au te'eyei ne atuature.” ");
INSERT INTO sny_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","4","Jisas lowe ma'e eiye, “Fene Owane Sitewi ma'e au te'eyei su, fene peri eito eite apou au umasi te'ere, ‘Tai Pefine, iyape no wara'i a'i ne. Nowe ape se ne lu taune werese, au noweinoweitorowa ape, witane a'i fa itora. Ne mi mi werese nomo ma'e ayei etiri tamo aure. Ne yo seni luwaru a'i werese nomo lo au ta'ane sasari pamowere. Lu taune ta nomo ma'e au luwaruweyei su, serai nomo yo seni luwaru werese a'i lowe lo fa tote i'anerowa. Nomo yo seni luwaru a'i irowei ne totesiya su, ne nomo ma'e au tei kairefiyere. Serai nomo yo seni luwaru a'i ape awera'iyenatiyei.’” ");
INSERT INTO sny_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Sosu a'i pe le lowe ma'e eiye, “Nowe pasiyeyei su meni ta wesi no sewiyeyei ne fai. Ayei werese no ariye. Serai pasi ponei se, ne kaiyemo no lo wesi ma'e iyei su, le ma'e ei toweriyei, ‘Ne fara'u ene nau hesi heta ausaiyei awere? Nowe me'iye su ane ne ma'e itiya'u auwei. ");
INSERT INTO sny_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Meni ta pasi a'i se ane ma'e sewiyeyei ne fai. Le pani eyeri erasi ma'e fai. Ane ayei werese le ma'e au ayei ne po'uteye.’ ");
INSERT INTO sny_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Meni ape, wesi papu iroteye ape, le ma'e itiya'u eiye, ‘Ne peri no ane ma'e owe ape au te'e oreseyere. Wesi yo ano ti tawesi tepa'asiye. Nomo awaripi nihe teisiya. Ane etiri ta ne ma'e auwei ne sinerowata. Ne arunatirowawe ire!’ ");
INSERT INTO sny_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Weiya, ane fene ma'e eisiya, meni ape kaiyemo no iroteye ape, etiri ta ne ma'e auwei ne sine te ta'ame su, ne iyape lo ei uteteye, ei uteteye. Serai meni ape sineyei su, ne ma'e etiri ayei ta auwei. ");
INSERT INTO sny_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Sosu ane fene ma'e eisiya, fene Owane Sitewi ma'e etiri ta ne te'e toweriyei su, le fene ma'e aurowa. Fene Owane Sitewi lo marepi siye so'oruweyei ne toteyei su, le a'i lai fene ma'e marepi lo ne au atuatu areiyerowa. Ne Owane Sitewi lo yo tewiye sahe ereti se aineyei su, le ne ne yo ape au ani tosorowa. ");
INSERT INTO sny_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Lu taune werese Owane Sitewi ma'e ei toweriteyei su, le a'i lai lowe ma'e etiri ape auwei. Lowe Owane Sitewi ma'e siye nehi etiteyei su, le lai lowe ma'e au atuatu areiyeyei. Lowe Owane Sitewi lo yo tewiye sahe ereti se aineteyei su, le a'i lai yo ape lo lowe ne ani tosowei. ");
INSERT INTO sny_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ane fene, aite werese ne, eisiya. Meni eime no, ne ma'e hare ta'i ei toweriraiyei su, ne haru aimesi le ma'e aurowa awere? Ahowa! ");
INSERT INTO sny_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Meni eime no ne ma'e irowe hote ei toweriraiyei su, ne heripahari ta'i le ma'e aurowa awere? Piyete tene! ");
INSERT INTO sny_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Serai fene, yo seni luwaru a'i ironamiteye ape, etiri wisere a'i ta eimane werese fene lo aunamisiya su, fene Owane Sitewi ne totere. Owane Sitewi lai fene ma'e etiri luwaru a'i aurowa awere? Piyete tene! Fene Owane Sitewi hire ma'e ironamisiya ape, ei toweriyei su, le a'i lai fene ma'e Hepene Wara'i a'i lo aurowa.” ");
INSERT INTO sny_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Nowe ta me'iye su meni ta ahi tomo'ute tawesiyei se Jisas lai sepei luwaru a'i au sasarisawi. Sepei luwaru a'i au sasariye su, meni ape ahi lo au ta'ane fara'uweyewe, peri te'eteye. Lu taune werese etiri ta ape siyeye su, lowe hepene se su'ariye. ");
INSERT INTO sny_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Lu tamo le ne apou eiye, “Ahowa, meni ape, Jisas, le sepei luwaru werese a'i au sasarisawi su, le sepei Belsebul lo kairefi se au sasarisawi.” Sepei Belsebul, sepei luwaru a'i owane pefine a'i ne. Belsebul lo iyape tere'e sepei Satan. Mt 9:34; 10:25 ");
INSERT INTO sny_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Lu tere'e tamo lowe le ne au areareyei ne toteteye. Lowe le ma'e peri kairefiyeyei se te'e toweriye, “Ne nomo ma'e yaru hire ma'e itoraiyei ape au atuatu areiyere. Nomo yaru erasi a'i ta, hire ma'e itoraiyei ape, siyeyei su, nomo peri no wanu umasiyei.” Mt 12:38 ");
INSERT INTO sny_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jisas marepi lowe lo siye so'oruweye su, serai le lowe ma'e eiye, “Omo pani tewi pa tewi ta ai atu tiyatirowa su, omo pani ape kairefiyeyei se ta'ama. Ai atu siye lu tamo omo pani tere'e ma'e fai ape, lowe fara'u omo pani ape ai atu se hi ani ararorowa. Aiwawe a'i nairipi lo lu tewi, marepi ta'i a'i toteye ape, kairefi a'i teinamiteye. Lu tewi feni ape ne lowe ta'u, ai marepi ironamiteye ape, lu tewi feni ape kairefi se ta'ama. Lu tewi tere'e lowe ma'e aine tera'erowa. ");
INSERT INTO sny_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Serai sepei Satan lai sepei luwaru a'i tere'e ta au sasarisawiyei su, le kairefi a'i teinamirowata. Serai fene ane ne apou eirowata. ‘Jisas lai sepei Belsebul lo kairefi se sepei luwaru a'i tere'e au sasarisawi. Piyete tene! ");
INSERT INTO sny_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Sepei Belsebul lo kairefi a'i ne totere. Ane lai Belsebul lo kairefiyeyei se sepei luwaru a'i tere'e ta au sasarisawiyei su, lu tewi fene lo ne, eiwerou lo kairefiyeyei se lowe sepei luwaru a'i au sasarisawiyei awere? Lowe lai marepi fene lo au hese ereiyei. Lowe peri fene lo ne meremereye a'i te'erowa. ");
INSERT INTO sny_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ahowa, ane lai sepei luwaru werese a'i Owane Sitewi lo kairefiyeyei se au sasarisawiyei su, fene werese etiri erasi a'i ta, hire ma'e itoraiyei ape, siye so'oruwe tepa'asiyei. Owane Sitewi lo kairefiyeyei fene mase ironamitorowa. Fene werese etiri ape so'oru ta'ama. Ane lai sepei luwaru a'i ta Satan lo kairefi se au sasarisawirowata. ");
INSERT INTO sny_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Meni kairefi a'i ta eine inapi se wesi lo au noweinoweiyei su, ta'arei meni ta etiri werese lo ta'arei aniyei ne wirowata. ");
INSERT INTO sny_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ahowa, meni owane kairefi erasi a'i ta lai meni kairefi a'i ape lo wesi aine towesi wiyei ne totesiya su, le meni kairefi a'i lo eine inapi ani towesi fusawiyei. Serai le lai meni kairefi a'i lo wesi wirowawe, etiri werese ta'arei anirowa. Etiri werese ta'arei anirowa ape, le lu tewi lo ani nonetirowa. Kl 2:15 ");
INSERT INTO sny_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Meni ta yo seni ano umasi ta'ame su, le a'i lai ane ma'e ai atu tiyatiyei. Meni ta wiyawi ano ta'ane ta'ame su, le a'i lai wiyawi ano au ta'ane luwaruwe fiyarisawirowa. Lu 9:50 ");
INSERT INTO sny_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","26","Sepei luwaru a'i meni lo marepi hepene nowe ma'e heneraiyei su, le omo omo pani werese tei fetaneyeyei ne siye nehi etiyei. Le etiri ta papu siye wi ta'ame su, le marepi apou toteyei, ‘Ane meni lo marepi hepene papu si tame wiyei.’ Serai le meni ape si tame wiyei su, le marepi hepene lo wara'i a'i siyeyei. Serai le sepei luwaru a'i ereti feni werese feni hesi a'i ei aniyei. Lowe werese meni ape papu wiyei. Tu sepei luwaru a'i ta'i se meni ape lo marepi luwaru a'i ne. Sosu sepei luwaru a'i ereti feni werese feni hesi a'i papu wiyei su, meni ape lo marepi luwaru hepene pefine a'i tene!” ");
INSERT INTO sny_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Sosu a'i pe Jisas lu taune ma'e au te'eye su, menitani ta le ma'e peri morose a'i hare uteye, “Menitani ape, ne auteiye ape, sosu ne ma'e mo'u au aye ape, menitani ape le wisere a'i ironamisiya.” Lu 1:28,42,48 ");
INSERT INTO sny_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Sosu Jisas itiya'u eiye, “Ahowa, lu taune werese Owane Sitewi lo peri wanu tote umasisiya ape, lowe lai marepi wisere a'i ironamisiya.” ");
INSERT INTO sny_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Jisas Owane Sitewi lo peri au te'e fiyari areiyeteye su, lu taune tomu ne'ese peri lo wanuwei ne ta'uwerai. Serai le lowe ma'e au te'eye, “Lu taune werese, nowe ape se irosiya ape, lowe yo seni luwaru a'i ironamisiya. Fene apou totesiya, ‘Owane Sitewi lai yaru erasi a'i nomo ma'e pei atuatu areiyere.’ Ahowa Owane Sitewi lai tu naifa weriyei meni Jona ma'e yaru erasi a'i au atuatu areiyeye. Serai yaru erasi a'i ape le Jona ma'e au atuatuwe ape, le lai fene ma'e tame au atuatuwei. Yaru erasi a'i tamo tere'e le lai fene ma'e au atuaturowata. Mt 16:4 ");
INSERT INTO sny_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Owane Sitewi lai Jona ma'e yaru erasi pefine a'i ta au atuatu areiyeye. Lu taune werese, omo Niniva sahe iroteye ape, lowe yaru ape siye areiye tepa'asiye. Owane Sitewi lai meni Jona omo Ninive ma'e peri lo au te'e fiyariyei ne eimawesawi. Sosu aiwawe a'i ane ne, meni ape, Owane Sitewi hi awei ma'e eimawe arosai ape, Owane Sitewi lai ane ma'e yaru erasi pefine a'i ta au ta'anerowa. Sosu fene werese yaru ape aiwawe a'i siye areiyerowa. Le a'i lai ane lu taune werese ma'e nowe ape se peri lo au te'eyei ne eimawesai. Fene werese ane ne tote tawesi se ta'ama. ");
INSERT INTO sny_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Tu naifa weriyei Owane Sitewi lai meni owane Solomon ma'e marepi wisere erasi a'i le ma'e auwe. Menitani owane tutawe omo pani, eyeri erasi a'i ma'e fai ape, le meni owane Solomon lo marepi wisere a'i wanuwei ne fai. Nowe ye'ewi su, menitani owane tutawe ape, lu taune werese pereye irosiya ape, aiwawe a'i Owane Sitewi lai lowe werese si tame hene anirowa. Menitani owane tutawe ape le fene ne peri werese tu au te'e eti ereirowa. Menitani owane tutawe fene ne apou au te'e eti ereirowa, ‘Fene werese peri ano wanure! Ane omo pani eyeri erasi ma'e Solomon lo peri wisere a'i wanuwei ne fai. Fene peri lo arisinamiteye.’” Sosu Jisas lu taune ma'e tame te'eye, “Ane a'i lai meni owane Solomon hi ani ararowe. Ahowa, fene werese ane ne tote tawesi se ta'ama. 1 Kin 10:1-10 ");
INSERT INTO sny_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Nowe ye'ewi su, Owane Sitewi lai omo Ninive lo lu si tame hene anirowa su, lowe aiwawe a'i fene werese ne, pereye nowe irosiya ape, peri ta au te'e hese ereirowa. Lowe peri ta apou au te'e hese ereirowa, ‘Fene werese peri nomo lo wanure! Meni Jona omo Ninive Owane Sitewi lo peri au te'e fiyariyei ne fai su, nomo werese Owane Sitewi lo peri werese wanu umasiteye. Nomo yo seni luwaru werese a'i nomo lo me'iyeni ma'e atati arunati.’” Serai Jisas lowe ma'e eiye, “Ane meni Jona hi ani araronamisiya. Fene werese peri ano arisinamisiya.” Jna 3:5-10 ");
INSERT INTO sny_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Meni ta lam ta taiso fu mitaiyeyei su, le awei yo papu fu fareyare ta'ame. Aiwawe a'i le lam ape wahu erasi unahi fu fareyareye ta'ame. Ahowa, le wesi papu metei hire sahe au onu tewi mitaiyeyei. Lu taune werese wesi papu wiyei su, lowe fara'u mitaiyeyei erasi siyeyei. Mk 4:21; Lu 8:16 ");
INSERT INTO sny_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nihe fene lo tahe pa'are lo mi wou a'i ne. Nihe fene lo amerame a'i su, tahe pa'are werese fene lo mi erasi teme'eriyeyei. Sosu nihe fene lo pasiyeyei su, tahe pa'are werese fene lo aiwawe a'i pasiye teme'eriyeyei. ");
INSERT INTO sny_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Fene peri ano wanure! Weiyai, mi fene lo owe ape noroweyei su, fene pasi a'i saro ironamitorowata. ");
INSERT INTO sny_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Sosu serai marepi werese fene lo aseyaro ironamisiya. Marepi tewi fene lo papu etiri luwaru a'i iro ta'ame su, tahe pa'are werese fene lo aseyaro ironamisiya. Lu taune werese yo seni aseyaro fene lo siyeyei. Tahe pa'are fene lo yehe erei lo mitaiyeyei wou a'i ne.” ");
INSERT INTO sny_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Sosu a'i pe Jisas peri tepa'asiye su, meni Farisi ta le ma'e apou ei toweriye, “Ne poweiye ponei se wesi ano ma'e aiwawe ene ayei ne aiya.” Sosu Jisas le mase wesi lo papu wiyewe, metei sahe ene ayei ne onuwe. ");
INSERT INTO sny_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Sosu meni Farisi ape Jisas metei sahe onuwei siyeye su, le le ne hepene se su'ariye. Le marepi apou toteye, “Piyene Jisas ereti lo sa'i se au hu ta'ame awere? Nomo werese tu ereti nomo lo sa'i se au huwei. Sosu mo'o nomo fara'u ene ayei. Yo seni lo ape ne amouwesiya tene!” ");
INSERT INTO sny_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ahowa, Meni Owane Jisas le ma'e eiye, “Ne peri ano wanure! Lu weneri Farisi werese, fene siye auwe, wahu aiwawe a'i nowe ma'e sa'i se au huteye. Ahowa, marepi fene lo papu unou a'i teme'eriyenamisiya. Fene yo seni ta'arei tamo seni luwaru tere'e tere'e ironamisiya. ");
INSERT INTO sny_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Fene marepi meremereye a'i ne! Owane Sitewi lai tahe fene lo au ta'aneye. Le a'i lai marepi fene lo aiwawe a'i au ta'aneye. Serai fene marepi aiwawe aseyaro au hu aseyarowete. ");
INSERT INTO sny_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ahowa, fene marepi aseyaro se etiri ma'aru ta lu feni ma'e, ma'aru ariyeye ape, au isafiye noneyei su, fene marepi fene lo aseyaro a'i henerairowa. ");
INSERT INTO sny_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Fene Farisi werese weiyai! Fene haiye werese, one werese ani loto ta'uwe ereiyei su, fene ereti feni hesi (10) au ani ta'uwe ani lotowei. Fene tewi ta'i a'i (1) Owane Sitewi ma'e si tame auwei. Fene tewi tere'e werese fene ta'u ene ayei. Wisere a'i ne. Ahowa, fene etiri tere'e tamo awera'iyenati. Meni ta etiri luwaru a'i meni tere'e ma'e yahowa'i a'i se au luwaruweyei su, fene lai yo seni luwaru a'i ne me'iyeni ma'e atati aruwei. Aiwawe a'i fene meni ta marepi orese a'i se siyeyei su, fene Owane Sitewi lo marepi erasi a'i arisiyei. Serai fene meni ape ne au pati ta'aneyei ta'ama. Etiri ape fene werese awera'iyenati. Sosu fene etiri yahowa'i a'i umasi etinamisiya. ");
INSERT INTO sny_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Fene Farisi weiyai! Fene ta'uweyei wesi wiyei su, fene me tuto'u tutawe wisere a'i tu wiyei ne onuri. Fene ta'uwe pani tewi a'i ma'e ta'uweraiyei su, fene iyape towafi fene lo, ei ani arowe ape, wanuwei ne totesiya. ");
INSERT INTO sny_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Fene werese weiyai! Fene werese apou a'i ne. Lu tamo meni ta temeniyeye ape awei fisiye yo ma'e horuse asi arowei su, lu taune werese yaro eiwerou ma'e horuse asi arowei awere? Serai lowe werese fisiye yo ape hire ma'e uweiteyei. Fene Farisi apou wou a'i ne. Lu taune werese yo seni werese fene lo siyeyei su, lowe apou a'i toteyei, ‘Yo seni werese lowe lo wisere a'i ne.’ Ahowa, marepi fene lo luwaru a'i tene! Fene weiyai! Owane Sitewi lai etiri luwaru a'i fene ma'e itiya'u aurowa.” ");
INSERT INTO sny_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Yo peri siye so'oru siye meni ta Jisas ma'e itiya'u eiye, “Meni Owane, ne lu Farisi ne peri ape au te'eye su, ne nomo ma'e peri luwaru a'i au te'eye.” ");
INSERT INTO sny_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Sosu Jisas le ma'e itiya'u eiye, “Ane fene yo peri wanu so'oru siye lu ma'e aiwawe au te'esiya. Fene werese weiyai! Fene lu taune tomu ne'ese ma'e etiri orese a'i funamiteye. Ahowa, fene ta'u lu werese lo orese a'i ne me'iyeni fene lo ma'e atati arunati. Fene werese onota'ano a'i ne. Fene lu lo orese a'i au pati ta'anerowata. ");
INSERT INTO sny_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Fene werese weiyai! Ya'ariyei fene lo Owane Sitewi lo peri au te'e siye lu aine tera'eye. Sosu awei fisiye yo ma'e funariteye. Fene werese marepi ta'i a'i lowe aiwawe totesiya. Fene Owane Sitewi lo peri au te'e siye lu lo awei fisiye yo ma'e au lesesiya. ");
INSERT INTO sny_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Fene awei fisiye yo ma'e au leseyei su, fene marepi apou totesiya, ‘Ya'ariyei nomo lo yo seni nomo lai au wisereyesiya. Serai nomo fara'u awei fisiye yo ma'e au lesesiya. Serai Owane Sitewi lo nihe se fene yo seni luwaru a'i iroteye.’ ");
INSERT INTO sny_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Serai Owane Sitewi fene ne toteyei su, Owane Sitewi lo marepi wisere a'i apou eiye, ‘Ane peri ano au te'e siye lu lowe ma'e eimawesawiyei. Aiwawe a'i ane lu tamo peri ano au te'eyei ne ariariyerowawe, lowe ma'e eimawesawiyei. Serai lowe iyei su, lu tamo lowe tewi a'i tamo aine tera'eyei. Lu tewi tamo ma'e lowe lai au luwaruweyei. Owane Sitewi lai fene ma'e fofowei erasi a'i itiya'u aurowa. ");
INSERT INTO sny_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Tu naifa weriyei weriyei Owane Sitewi etiri werese ta'aneye su, lu tamo Owane Sitewi lo au te'e siye lu tomu ne'ese aine tera'eteye. Serai Owane Sitewi lai lowe lo lu tewi ma'e, pereye irosiya ape, fofowei erasi itiya'u aurowa. ");
INSERT INTO sny_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Meni ta tu naifa meni Abel aine tera'eye. Nowe me'iye su lu tamo tere'e Owane Sitewi lo au te'e siye lu tomu ne'ese aine tera'eye. Nowe me'iye su, lu tere'e Owane Sitewi lo au te'e siye meni iyape Sekaraia aine tera'eye. Lowe meni ape Owane Sitewi lo wesi tewi atahe ma'e tapiye wari potu a'i ponei sahe aine tera'eye. Ei, wanure! Ane lai fisa'i lowe lo ne lu tewi, pereye irosiya ape, ma'e itiya'u aurowa.’ ");
INSERT INTO sny_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Fene yo peri wanu so'oru siye lu werese weiyai! Owane Sitewi lai etiri luwaru a'i fene ma'e aurowa! Fene peri wisere a'i ne au fareyaresiya. Serai lu taune werese peri wisere a'i ape wanu se ta'ame. Fene ta'u peri wisere a'i ape ani so'oru ta'ama. Aiwawe a'i lu taune tamo peri ape wanuwei ne totesiya su, fene lai marepi lowe lo einamiteye.” ");
INSERT INTO sny_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Sosu a'i pe Jisas lowe arunatiyewe fi su, lu Farisi, Owane Sitewi lo yo peri wanu so'oru siye lu tamo, lowe Jisas ne ai marepi erasi a'i totenamiye. Lowe Jisas lo yo seni werese ne ei toweri etiteye. ");
INSERT INTO sny_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Lowe Jisas ne aine tera'eyei ne toteye. Lowe yo seni lo siye etiyei ne toteteye. “Jisas peri ta yo peri nomo lo hi ani ararowei awere? Le yo peri nomo lo au ani arisiyei su, nomo le pei aine tera'ere.” ");
INSERT INTO sny_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Jisas lo peri heneruwe omo omo werese ma'e au te'e fiyarisawi. Serai lu taune tomu ne'ese peri lo wanuwei ne ta'uwerai. Lowe tomu ne'ese lu taune tere'e lo lowe hire atoteye. Yaru werese ariye. Serai le lu disaipel lo ma'e Owane Sitewi lo peri au te'e atuatuwe. Le apou eiye, “Fene weiyai! Lu Farisi lo marepi owe ape tote umasite. Ahowa, Lu Farisi lo marepi fe wawe sa'i wou a'i ne. Mene'e lo aiwese lai fe wawe lo seni a'i horuse ape tou poruneyei su, fe lo'u horuse luwaru a'i asiyerowa. Farisi lo marepi aiwawe a'i ne. Lowe peri ta au te'enamiteye su, lowe ta'u yo seni tere'e ironamiteye. Lowe marepi hesi a'i ironamisiya. ");
INSERT INTO sny_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Lu tewi ape mo yo seni tamo tote fareyareyei su, Owane Sitewi lai yo seni, lowe fareyareteyei ape, amerame a'i au atuatu areiyerowa. Lowe peri ta tote fareyareyei su, Owane Sitewi nowe mo'o su lu taune werese ma'e peri lowe lo ape au te'e fiyari areiyerowa. Lu 8:17 ");
INSERT INTO sny_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Fene peri ta nowe pasi a'i se au te'eteyei su, lu taune werese nowe mitaiyeyei a'i se peri fene lo wanu areiyerowa. Fene wesi tewiye si papu peri eresene a'i te'e senana'oteye su, lu taune werese wesi nowe ma'e irosiya ape lai, lowe peri fene lo ute fiyarirowa. ");
INSERT INTO sny_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ane fene ma'e eisiya, kaiyemo ano, lu tamo fene aine tera'eyei ne toteyei su, fene lowe ne owe ape atoweiyere! Lowe tahe pa'are fene lo aine tera'eyei su, lowe hepene fene lo au luwaruwerowata. ");
INSERT INTO sny_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ahowa, ane fene ma'e apou eisiya. Fene marepi towafi fene lo au hese eti ereite. Fene yo seni luwaru a'i irowei su, Owane Sitewi lai fara'u fene aine tera'erowa. Sosu yehe omo ma'e ani fu arosawirowa. Fene meni ape ne erasi a'i fa atoweiyere! Ei, fene meni ape ne fa atoweiyere! ");
INSERT INTO sny_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Fene ayei ta, au hese ereiyei ne toteyei ape, fene irowe peserowe ereti feni werese ma'aru oso hesi a'i se ete aniyei. Wanure, Owane Sitewi lai irowe peserowe ta'i ape tote i'anerowata. ");
INSERT INTO sny_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Peri ano wiyeme a'i ne. Owane Sitewi lai mato towe werese fene lo nawiteye. Owane Sitewi lai fene werese au noweinoweinamisiya. Fene owe ape atoweiyere! Owane Sitewi lo nihe se fene lai irowe peserowe werese hi ani araronamiye. Lu 12:24; Ap 27:34 ");
INSERT INTO sny_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Sosu ane fene ma'e eisiya, lu taune tamo ane ne lu taune ma'e au te'e fiyariyei su, ane meni hire ma'e itorai ape, ane lowe ne Owane Sitewi lo ipari werese ma'e au te'e areiyerowa. ");
INSERT INTO sny_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ahowa, lu taune ta ane ne apou te'eyei su, ‘Ane Jisas ne so'oru ta'ama.’ Ane lowe ne Owane Sitewi lo ipari werese a'i lo nihe se lowe ne apou eirowa, ‘Ane lowe ne so'oru ta'ama.’ ");
INSERT INTO sny_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Lu taune tamo ane ne, meni hire ma'e itorai ape, peri te'e naruwei su, Owane Sitewi lai yo seni luwaru a'i lowe lo fara'u au sasari pamowerowa. Weiya, lu taune tamo Owane Sitewi lo Hepene Wara'i a'i ne peri au te'e naruwei su, Owane Sitewi lai mi mi pasi pasi weriyei le yo seni apou ape lowe lo au ani sasari pamowerowata. ");
INSERT INTO sny_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Lu tamo fene Owane Sitewi lo wesi sahe lu owane apou ape ma'e etiyei ne henetiyei su, fene marepi luwaru orese a'i owe ape totere. Fene owe ape totere, ‘Ane peri ta eiwerou au te'eyei awere? Ane piye peri au te'eyei awere?’ Piyene awere? Mk 13:11; Lu 21:12-15 ");
INSERT INTO sny_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Owane Sitewi lo Hepene Wara'i a'i nowe ape se peri lo ahi fene lo sahe au te'e atuatu areiyerowa. Serai fene peri wisere a'i au te'e areiyerowa.” ");
INSERT INTO sny_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Sosu a'i pe Jisas peri te'e tepa'asiye su, meni ta peri lo wanuwe ape le ma'e ei toweriyei ne fai. “Meni Owane, ne airu ano ma'e apou eirire, ‘Ne tai lo etiri iyami werese pa'ise no au hese erei nonetire.’” ");
INSERT INTO sny_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ahowa, Jisas le ma'e itiya'u eiye, “Meni, ane a'i lai au hese erei siye meni ta'ama. Ane peri tewi pa tewi wanu siye meni no ta'ama.” ");
INSERT INTO sny_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Sosu le lowe ma'e eiye, “Fene weiyai! Fene ma'aru lo marepi erasi a'i aniyei ne owe ape totenamite. Meni ta etiri tomu ne'ese ta'uwe aniyei su, marepi hepene papu lo wisereyerowata. Etiri tomu ne'ese ape mo marepi hepene pefine a'i irorowata.” 1 Ti 6:9-10 ");
INSERT INTO sny_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Sosu le lowe ma'e peri anowe ta apou au te'eye, “Meni ta etiri tomu ne'ese ta'uwe aniye. Ta'aneyei awei lo wisere a'i ne. Le ayei etiri tomu ne'ese tahe aniye. Sosu wesi lo ma'e ani fu lotowe. ");
INSERT INTO sny_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Serai meni ape marepi topo lo se erasi a'i totenamiteye. Le apou toteye, ‘Ane piye irowei awere? Wesi werese ano ayei etiri teme'eriyeye. Ane wesi tere'e ariye. Ayei ano ane eiwerou ma'e fu lotowei awere?’ ");
INSERT INTO sny_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Serai le apou te'eye. ‘Ane so'oruwesiya. Ane a'i lai wesi werese ano tapeti erauwei. Sosu ane wesi erasi, tomu ne'ese he'i a'i ta'aneyei. Ane wesi werese ta'ane tepa'asiyei su, ane ayei etiri werese ano wesi he'i ape papu ma'e ani fu lotowei. ");
INSERT INTO sny_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ane ayei etiri werese ano wesi he'i ani fu tepa'asiyei su, ane lai topo ane ma'e au eiyei, ‘Ane a'i lai ayei etiri tomu ne'ese ta'uwe ani tepa'asiye. Ne marepi hepene momotei a'i ironamirowa. Ane iyu menei tomu ne'ese fara'u arowa. Serai ane marepi momotei a'i ironamitorowa. Ane ayei erasi arowa, ane sa'i meremereye erasi a'i arowa. Sosu ane fara'u yo seni eito eite ironamirowa.’ ");
INSERT INTO sny_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ahowa, Owane Sitewi lai le ma'e itiya'u eiyei, ‘Marepi no meremereye a'i tene! Pereye pasi a'i se ne temeniyerowa. Etiri werese no, ne ta'uwe ani fu lotowe ape, ne temeniyeyei su, eiwerai etiri werese no aniyei awere?’” ");
INSERT INTO sny_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Jisas lowe ma'e tame eiye, “Meni ta ayei etiri tomu ne'ese ta'uwe aniyei su, le Owane Sitewi lo etiri werese anirowata. Serai le, Owane Sitewi lo nihe se, meni luwaru a'i tene! Mt 6:19-20 ");
INSERT INTO sny_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Sosu a'i pe le lu disaipel lo ma'e eiye, “Serene ane fene ma'e au te'esiya, fene etiri ta marepi erasi a'i owe ape totatote ewitete. Nomo piye ayei etiri ene ayei awere? Fene aiwawe a'i tahe pa'are towafi fene lo ne marepi erasi a'i owe ape totatotete. Nomo piye ipari tahe ani asiyei awere? ");
INSERT INTO sny_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Marepi hepene fene lo ene ayei etiri lo a'i ta'ame ne. Aiwawe a'i tahe pa'are towafi fene lo ipari tahe etiri lo a'i ta'ame ne. ");
INSERT INTO sny_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Fene irowe werese ne totere. Lowe werese awei sahe meso ta'aneyei awei sahe yehe same ta'ame. Lowe meso tamo ani tou anirowawe, wesi ta sahe ani ta'uwe furowata. Wanure! Owane Sitewi a'i lai irowe werese ape mo ene ayei lowe lo au ene anamisiya. Serai Owane Sitewi lai lowe ma'e au ene asiya su, le fene ma'e ayei etiri au ta'ame awere? Ahowa, fene werese Owane Sitewi lai au noweinoweisiya. Fene irowe werese hi ani ararosiya. ");
INSERT INTO sny_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Meni ta fene mase irosiya awere? Le apou tote ewiteyei su, ‘Ane a'i lai marepi ano se, ane iyu menei tomu ne'ese ironamisiya.’ Meni ape marepi topo lo ape owe ape totete. Meni lo ape marepi meremereye a'i ne. Fene etiri oso a'i tamo marepi erasi tote ewiteteye su, fene piyene etiri erasi pefine a'i tamo marepi tote ewitesiya awere? ");
INSERT INTO sny_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Serai meni ape etiri oso ape irorowata su, le etiri tere'e ne totatoterowata. ");
INSERT INTO sny_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Fene mesu werese ne totere! Lowe wiyawi ta ta'ane ta'ame. Lowe ipari tahe iwisi ta'ame. Ahowa, tunaifa weriyei Juda lo meni owane Solomon ipari tahe tomu ne'ese wisere a'i ani asiteye. Mesu lo nihari Solomon lo ipari tahe werese hi ani araroteye. ");
INSERT INTO sny_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Serai Owane Sitewi lai mesu werese nihari wisere a'i ta'anesiya su, lowe pereye wisere a'i ne. Nowe mo'o su, fene mesu werese po'uteyei ani fusawiyei. Wanure, Owane Sitewi lai fene werese au noweinoweinamisiya. Fene Owane Sitewi ne tote tawesiyei fene lo oso a'i ne. ");
INSERT INTO sny_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Fene ayei etiri, fene ene ayei ape ne, marepi erasi a'i owe ape totere. Aiwawe a'i fene piye sa'i, fene ayei ape, marepi erasi a'i owe ape totere. Fene marepi erasi a'i owe ape totatote ewitete. ");
INSERT INTO sny_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Lu taune werese omo omo werese sahe etiri ape mo marepi erasi a'i tote nehinamiyei ne totesiya. Ahowa, tai fene lo, hire ma'e irosiya ape, le lai etiri ape mo so'oruwesiya. Fene sa'i a ta'ame su, fene witane a'i temeniyeyei. Fene ayei etiri ene a ta'ame su, fene aiwawe a'i temeniyeyei. Owane Sitewi lai so'oruwesiya tene! ");
INSERT INTO sny_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ahowa, fene Owane Sitewi lo marepi tote nehi umasisiya su, le a'i lai ayei etiri, sa'i fene ma'e aurowa. ");
INSERT INTO sny_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Fene marepi ano umasisiya ape, fene taweiru sawa! Tai fene lo, hire ma'e irosiya ape, le marepi lo se omo lo fene ma'e aureme. ");
INSERT INTO sny_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Serai ane fene ma'e au te'esiya. Etiri werese fene lo lu tere'e tamo lai etere. Fene ma'aru aniyei ape, lu taune ma'e ma'aru ariye ape, au nonetire. Fene ma'aru fene lo a'i nonetiyei su, Owane Sitewi lai fene ma'e hire ma'e etiri lo au ta'uwe ani lotorowa. Omo hire ma'e etiri werese fene lo ne, Owane Sitewi lai ta'uwe ani lotowei ape, ta'arei lu werese etiri werese fene lo ta'arei anirowata. Aiwawe ya'e etiri werese au luwaruwerowata. Lu 18:22 ");
INSERT INTO sny_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Fene awei lo etiri ne marepi erasi a'i totenamiyei su, fene awei lo marepi tote umasinamiyei. Aiwawe a'i fene etiri werese, Owane Sitewi ma'e fai ape, marepi erasi a'i totenamirowa su, fene Owane Sitewi lo marepi tote umasinamirowa.” ");
INSERT INTO sny_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Sosu a'i pe Jisas lowe ma'e tame au te'eye, “Fene wiyawi yahowa'i a'i iro siye lu wou fa heneraire. Meni ta naituwe ta'uwe hereiyei iyei ne toteye. Serai le wiyawi yahowa'i ta'ane siye lu apou eiye, ‘Ane si tame aiyeyei su, fene yo ano ape ani tosore!’ Sosu le naituwe lo ta'uwe ure'iyei ma'e ta'uweyewe fi. Wiyawi yahowa'i a'i ta'ane siye lu lowe etiri werese ne au ta'uwenamiye. Ipari tahe lowe lo ani asi tepa'asiye, yehe erei werese taiso fu meteye. Lowe meni owane lowe lo si tame aiyeyei ne ninawesiya. Serai meni owane lowe si tame aiyeyei yo tewiye ape aineyei su, lowe fara'u witane a'i yo lo tosorowa. Serai fene wiyawi yahowa'i ta'ane siye lu ape aiwawe a'i fa heneraire. Mt 25:1-13 ");
INSERT INTO sny_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Meni owane si tame aiyeyei su, wiyawi yahowa'i a'i ta'ane siye lu werese lowe le ne ninawenamiteyei. Wiyawi yahowa'i a'i iro siye lu werese ninawenamiteyei su, meni owane ape lowe ne au wisereyeyei. Peri wiyeme a'i ane fene ma'e eisiya. Le ipari tahe lo ani asiyei, lowe metei sahe ei onurowawe, sosu lowe ma'e au ene arowa. ");
INSERT INTO sny_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Meni owane eiwerou su aiyeyei awere? Le pasi ponei aiyerowa awere? Nowe mitaiyeyei aiyerowa awere? Wiyawi yahowa'i a'i ta'ane siye lu lowe so'oru ta'ama. Serai lowe le ne ninawenamiteye. Sosu meni owane si tame aiyeyei su, wiyawi yahowa'i a'i ta'ane siye lu ninawenamiteyei. Le lowe le ne ninaweteyei siyeyei su, le marepi wisere a'i lowe ne au wisereyeyei. ");
INSERT INTO sny_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Peri ano wanu so'oruwere! Ta'areiye siye meni wesi ta aine tapeti wiyei ne toteyei. Wesi ape lo meni owane nowe ape siye so'oruwe tepa'asiyei su, ta'areiye siye meni ape wesi ape aine tapeti wirowata. Mt 24:43-44; 1 Te 5:2 ");
INSERT INTO sny_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ane fene ma'e au te'esiya. Fene etiri werese fene lo ani ta'uwe naneire. Fene etiri werese ani ta'uwe naneiyei su, ane, meni hire ma'e itorai ape, si tame aiyerowa su, fene werese nowe ape se so'oru ta'ama. Serai fene werese etiri werese ta'uwe naneinamite.” ");
INSERT INTO sny_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Sosu a'i pe Pita Jisas ma'e ei toweriye, “Meni Owane, ne peri anowe ape nomo ma'e au te'esiya awere? Lu taune tere'e werese ma'e au te'esiya awere?” ");
INSERT INTO sny_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Sosu Meni Owane lai le ma'e itiya'u eiye, “Ane lu taune werese ma'e peri ano wanu umasinamisiya ape, au te'esiya. Ane lu taune werese ma'e marepi wisere a'i ironamisiya ape, aiwawe lu taune werese ma'e marepi aseyaro a'i totenamisiya ape, au te'esiya. Ane lu owane werese ano ma'e apou eiyei, ‘Fene werese wiyawi ta'ane siye lu ano au noweinoweite.’ ");
INSERT INTO sny_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Serai meni owane wiyawi yahowa'i a'i ta'ane siye meni, wiyawi lo ta'ane tohoteyei ape, siyeraiyei su, le wiyawi yahowa'i a'i ta'ane siye meni ape ne marepi wisere a'i totenamiteye. ");
INSERT INTO sny_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Wiyeme a'i ane fene ma'e au te'esiya. Meni owane ape wiyawi yahowa'i a'i ta'ane siye meni ma'e etiri werese lo au noweinoweiyei ne ariariyerowa. Mt 25:21,23 ");
INSERT INTO sny_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ahowa, wiyawi yahowa'i a'i siye meni ape marepi topo lo se apou a'i toteyei su, ‘Meni owane ano witane se aiyerowata.’ Serai le wiyawi yahowa'i a'i ta'ane siye lu taune tere'e me au se aineyei. Le ayei tomu ne'ese ayei, sa'i meremereye a'i erasi ayei, sosu marepi meremereye a'i heneraiyei. ");
INSERT INTO sny_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Sosu nowe me'iye ta se, meni owane ape si tame aiyeyei. Wiyawi ta'ane siye meni ape nowe ape so'oru ta'ama. Le meni owane lo ne ninawe ta'ame. Meni owane si tame aiyerowa su, le wiyawi yahowa'i ta'ane siye meni luwaru a'i ape ma'e erasi wiyeme a'i tewi pa tewi aine tourowa. Sosu le meni ape lu taune werese ma'e Owane Sitewi lo peri umasi ta'ame ape, eimawesawiyei. ");
INSERT INTO sny_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Wiyawi yahowa'i a'i ta'ane siye meni ta, le meni owane lo marepi so'oruwe tepa'asiye su, Ahowa, le meni owane lo etiri ani ta'uwe nanei ta'ame. Aiwawe le meni owane lo marepi tote umasi ta'ame. Serai meni owane si tame aiyerowa su, le meni ape me'iyeni ma'e wafei se erasi a'i aine nateye. Je 4:17 ");
INSERT INTO sny_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ahowa, wiyawi yahowa'i a'i ta'ane siye meni tere'e meni owane lo marepi so'oru ta'ama su, le yo seni luwaru a'i irowei. Meni owane lo le me'iyeni ma'e wafei se oso a'i aine nateye. Serai Owane Sitewi lai lu tamo marepi wisere a'i auwei su, lu ape mo wiyawi erasi a'i fa ta'anere. Aiwawe a'i Owane Sitewi lai lu tamo etiri tomu ne'ese auwei su, le lowe ma'e etiri erasi a'i itiya'u ei toweriyei. Serai lu taune tamo lai meni ta'i a'i ma'e etiri tomu ne'ese a'i auwei su, lowe meni ape ma'e etiri tomu ne'ese itiya'u si tame ei towerirowa.” ");
INSERT INTO sny_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Sosu a'i pe Jisas lowe ma'e tame eiye, “Ane awei omo werese ma'e yehe fu etiyei ne fai. Marepi ano apou a'i totesiya. Ane yehe ape pereye a'i fa henera. ");
INSERT INTO sny_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Owane Sitewi lai wiyawi erasi a'i ane ma'e irowei ne auwei. Ane tahe pa'are ano fofowei erasi a'i teriterowa. Pereye ane marepi orese a'i fofowei erasi ne teritenamisiya. Ane wiyawi ape ani tepa'asiyei su, marepi ano wisere a'i ironamirowa. Mk 10:38-39 ");
INSERT INTO sny_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ane hi awei ma'e lu taune werese ma'e marepi fetane a'i ne auwei ne itorai ta'ama. Ahowa, ane hi awei ma'e lu tewi a'i ne hese ereiyei irowei ne itorai. Lu taune tewi tamo peri ano wanu umasiyei. Sosu lu taune tewi tere'e tamo peri ano wanu arisiyei. ");
INSERT INTO sny_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Nowe pereye eite se nohuweripi awaripi marepi hesi a'i hesi a'i tote umasinamisiya. Lu taune tewi hesi heta marepi ta'i a'i tote umasiyei. Lu taune tewi hesi aiwawe marepi tere'e tote umasinamiyei. Aiwawe a'i lu taune hesi ai marepi awaripi tewi hesi heta ma'e totenamisiya. ");
INSERT INTO sny_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Lowe awaripi tai ai marepi meni eime lo ne totenamiyei. Aiwawe a'i meni eime ape ai marepi tai lo ne totenamiyei. Sosu mai lai eime taune lo ne ai marepi totenamiyei. Aiwawe a'i eime taune lai ai marepi mai lo ne totenamiyei. Sosu mai pape lai ai marepi ewite lo ne totenamiyei. Aiwawe a'i ewite lai mai pape lo ma'e ai marepi totenamiyei.” Mai 7:6 ");
INSERT INTO sny_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Sosu a'i pe Jisas lu taune werese ma'e tame au te'eye, “Fene ni'arawe erasi yaru poweiye itorisiya ape, sine wi siyeyei su, fene apou toteyei, ‘Wiyeme a'i sa'i itorairowa.’ Serai nowe oso a'i su sa'i itorairowa. ");
INSERT INTO sny_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Sosu aiwawe a'i fene fiyaru ma'e yaru poweiye itorisiya ape, teriteyei su, fene tahe fene lo sahe teriteyei. Serai fene apou toteyei, ‘Owei! Pereye nowe poweiye erasi a'i heneraiyei.’ Wiyeme a'i poweiye erasi umeri a'i heneraiyei. ");
INSERT INTO sny_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Fene marepi hesi a'i umasinamisiya ape, fene ni'arawe, fiyaru lo etiri hire ma'e so'oruwe tepa'asiye. Fene piyene Owane Sitewi lo etiri werese, hi awei ma'e henerai ape, fene siye so'oru ta'ama awere?” ");
INSERT INTO sny_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Sosu Jisas lu taune werese ma'e au te'eye, “Fene werese piyene yo seni wara'i a'i au hese erei ta'ame awere? Aiwawe a'i fene yo seni luwaru a'i au hese erei ta'ame. Fene piyene fene etiri ape mo au hese erei ta'ame awere? ");
INSERT INTO sny_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Meni ta ne ma'e etiyei ne totesiya. Fenesi au hese erei siye meni ma'e yo sahe iteyei su, ne fara'u yo mai saro a'i marepi orese a'i ape au fareraiyeyei ne etire. Ne marepi orese a'i au fareraiye ta'ame su, meni ape ne au hese erei siye meni ma'e henetiyei. Serai le lai ne ai atu siye meni ereti lo ma'e fu henetiyei. Sosu ai atu siye lu ne kalabus lo wesi papu fu aroweyei. ");
INSERT INTO sny_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Serai ane fene werese ma'e au te'esiya. Fene kalabus lo wesi papu mi mi pasi pasi ironamirowa. Fene ma'aru werese topo lo ma'e itiya'u auwei su, fene fara'u kalabus lo wesi arunatirowawe nowe ma'e si tame henerairowa.” ");
INSERT INTO sny_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Sosu a'i pe nowe ape se lu tamo Jisas ma'e peri heneruwe apou au te'esai. Lowe apou te'eye, “Lu taune tamo omo pani Galili ma'e fai ape, Owane Sitewi ma'e fe bulmakau ta au heseyei ne toteye. Lowe fe bulmakau ta'i Owane Sitewi lo wesi ma'e heneti. Lowe fe bulmakau aine tera'eye su, awei meni owane Pailat ai atu siye lu tamo lowe ma'e aine tera'eyei ne eimawesawi. Ai atu siye lu lowe werese ti se tewi tera'eye.” ");
INSERT INTO sny_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Sosu le lowe ma'e itiya'u eiye, “Galili lo lu taune ape mo ne fene eiwerou totesiya awere? Yo seni luwaru a'i lowe lo erasi wiyeme a'i irowe awere? Serai ai atu siye lu lowe ti se tewi tera'eye. Yo seni luwaru a'i lowe lo Galili lo lu taune tere'e werese hi ani ararowe awere? Jo 9:2 ");
INSERT INTO sny_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ane fene ma'e eisiya. Ahowa, wanure! Fene yo seni luwaru a'i werese a'i fene lo me'iyeni ma'e atati aru ta'ame su, fene aiwawe a'i mi mi pasi pasi temeniye po'utenamirowa. ");
INSERT INTO sny_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Omo ta iyape Sailom, sahe lu taune ereti feni hesi lowe feni werese feni hesi heta (18) tapiye wesi pite a'i ta lu taune ape towesi wiyei ne tera'e ereye. Lu taune tewi ape mo, lowe yo seni luwaru a'i lowe lo omo Jerusalem lo lu taune werese lo yo seni luwaru a'i hi ani ararowe awere? ");
INSERT INTO sny_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ane fene ma'e eisiya. Ahowa, wanure! Fene yo seni luwaru werese a'i fene lo me'iyeni ma'e atati arunati ta'ame su, fene aiwawe a'i mi mi pasi pasi temeniye po'utenamirowa.” ");
INSERT INTO sny_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Sosu a'i pe Jisas peri anowe ta lowe ma'e au te'eye, “Meni ta me owarape ta'aneyei awei lo sahe yehe sameyei ne fi. Nowe me'iye su, me owarape erasi a'i henerai tepa'asiye. Nowe ta se le me ape siyenari. Le me owarape siyeye su, owarape so werese ariye. ");
INSERT INTO sny_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Sosu le wiyawi ta'ane siye meni lo ma'e apou eiye, ‘Iyu menei hesi heta i tepa'asiye su, ane owarape so siyenarai. Ane owarape so werese siye po'uteye. Ne me owarape eite oure. Piyene awei sahe yahowa'i a'i tei tawesisiya awere? Ane etiri tere'e yaru ape sahe yehe sameyei ne.’ Lu 3:9 ");
INSERT INTO sny_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Wiyawi ta'ane siye meni lo le ma'e itiya'u eiye, ‘Weiya, iyu menei eite se ane fara'u me ape lo si sahe awei peperi he'i horuse fuwei. Ane yesi yehe lipawi me si ape sahe fuwei. Sosu iyu menei ta'i i tepa'asiyei su, 2 Pi 3:9,15 ");
INSERT INTO sny_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Me owarape eite so ta'e ta'ame su, ane fara'u me ape ouwei. Sosu me owarape so ta ta'eyei su, wiyeme a'i ne.’” ");
INSERT INTO sny_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sosu a'i pe Jisas lu disaipel lo aiwawe a'i, ta'uweyei wesi ma'e fi. Le Owane Sitewi lo peri lu taune ma'e nowe amou se au te'e fiyariyei ne fi. ");
INSERT INTO sny_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Siyere! Menitani ta sato teiteye. Sepei luwaru a'i ta le ma'e u tahe erasi a'i au irowe. Iyu menei ereti feni hesi lowe feni werese, feni hesi heta (18 aiwawe a'i) menitani ape me'iyeni apou a'i epe'enamiteye. Le me'iyeni lo fareraiyerowata. ");
INSERT INTO sny_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Sosu Jisas le siyeye su, le menitani ape ei aniye. Le le ma'e apou eiye, “Menitani u tahe no po'uteye.” ");
INSERT INTO sny_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Le menitani lo me'iyeni ma'e ereti topo lo se isawe hetesiye. Ereti lo se isawe hetesiye su, pereye a'i u tahe lo po'uteye. Le me'iyeni lo au sine fareraiyeye. Sosu le Owane Sitewi ma'e erasi a'i au te'e wisereyeteye. ");
INSERT INTO sny_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Sosu ta'uweyei wesi meni owane etiri ape siyeye su, le Jisas ne ai marepi totenamiteye. Jisas nowe amou ape se menitani au ta'ane fareraiyeye. Eite amou ne. Sosu le lu taune werese ma'e eiye, “Nowe ereti feni werese feni ta'i se (6) nomo wiyawi fara'u ta'aneyei. Fene u tahe irowei su, fene nowe ape mo se au fara'uweyei ne aiyeyei. Fene nowe se amou au fara'uweyei ne owe ape aiyete. Nowe amou se au ta'ane fara'uweyeyei ne amouwesiya.” Kis 20:9-10; Lo 5:13-14 ");
INSERT INTO sny_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ahowa, Meni Owane Jisas le ma'e itiya'u eiye. Fene, marepi hesi a'i umasinamisiya ape, wanure, nowe amou se fene fe bulmakau, fe donki wesi lo sahe wafei se ani eraurowawe, sa'i ma'e au ayei ne henetirowa awere?” Lu 14:5 ");
INSERT INTO sny_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Menitani ape siyere. Le Juda lo menitani tene! Abraham lai menitani lo ya'ariyei ne. Ahowa, sepei Satan nowe iyu menei (18 aiwawe a'i) menitani me'iyeni ani epe'e ya'ore ironamiteye. Piyene ane u tahe lo poweiye amou se au ta'ane fareraiye ta'ame awere?” ");
INSERT INTO sny_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Sosu Jisas au te'eteye su, lu owane werese marepi neritase a'i teriteteye. Lu taune werese etiri wisere a'i, le irowe ape, siyeye su, lowe Owane Sitewi ma'e erasi a'i au te'e wisereyeteye. ");
INSERT INTO sny_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Serai le lowe ma'e tame au te'eteye. “Nowe ape se Owane Sitewi lai lu taune au noweinoweitorowa ape ne, peri piye anowe wou te'esiya awere? Ane piye peri te'esiya awere? Serai fene, Owane Sitewi yo seni tewi he'i a'i umasisiya ape, wanu so'oruwesiya. ");
INSERT INTO sny_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Nowe ape se, Owane Sitewi lai lu taune au noweinoweitorowa ape, apou wou a'i ne. Saiyoho so oso po'o a'i ne. Meni ta me so ape ta'aneyei awei lo sahe ani tosowei. Nowe me'iye su, me so ape peratiyewe, me erasi a'i henerai. Irowe tamo me ape lo nei sahe sine onuraiteye. Lowe me nei sahe uri lo ta'aneteye.” ");
INSERT INTO sny_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Sosu le lowe ma'e tame au te'eye, “Owane Sitewi lo marepi he'i a'i, hire ma'e iroteye ape, ane piye nihari wou au te'esiya awere? ");
INSERT INTO sny_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Owane Sitewi lo marepi apou wou a'i ne. Menitani ta siye fi tewi oso a'i nau erasi a'i papu fuwe. Nowe me'iye su, siye fi ape nau werese erasi meiyei irowe.” ");
INSERT INTO sny_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Sosu a'i pe Jisas ta'uweyei wesi ape arunatiyewe, omo tere'e tere'e ma'e Owane Sitewi lo peri au te'eyei ne fi. Le omo Jerusalem ma'e iyei ne toteye. ");
INSERT INTO sny_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Sosu meni ta le ma'e apou ei toweriye, “Meni Owane, lu taune eiwerou a'i Owane Sitewi lo omo hire ma'e wiyei awere? Lu taune tomu ne'ese awere? Lu taune tewi oso a'i awere?” Sosu Jisas le ma'e itiya'u eiye, ");
INSERT INTO sny_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Wanure! Yo hesi a'i irosiya. Yo ta'i potu erasi a'i ne. Lu taune tomu ne'ese yo ape winamisiya. Yo tere'e oso po'o a'i ne. Lu taune tewi oso a'i wiyei. Fene werese yo oso po'o a'i papu wiyei ne tohotete. Lu taune tomu ne'ese yo tewiye oso po'o a'i papu wiyei ne totesiya. Serai lowe wirowata. Owane Sitewi lowe ne awera'iyenatirowa. ");
INSERT INTO sny_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ane fene ma'e eisiya. Wesi ape lo meni owane sinerowawe, yo ape anite tawesiyei su, fene lai yo ape ani tosorowata. Fene yo tewiye sahe aine ta'aruwei su, fene meni owane ma'e apou hare uteye, ‘Meni Owane nomo lo, ne yo ape nomo ne ani tosore. Serai nomo wesi no wiraiyei.’ Meni Owane ape peri lowe lo wanuwei su, le lowe ma'e apou itiya'u eiyei, ‘Fene piye omo ma'e fai awere? Ane fene so'oru ta'ama.’ Mt 25:10-12 ");
INSERT INTO sny_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Sosu fene le ma'e itiya'u eiyei, ‘Nomo ne mase aiwawe a'i ayei ta sa'i ta ene ateye. Ne omo nomo lo yo mai sahe peri au te'eteye su, nomo sato iroteye.’ ");
INSERT INTO sny_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Sosu le lowe ma'e itiya'u eiyei, ‘Ane fene ma'e eisiya, omo ape fene fai ape, ane so'oru ta'ama. Fene werese, yo seni luwaru a'i ironamisiya ape, fene ane arunatire.’ Sng 6:8 ");
INSERT INTO sny_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Nowe ye'ewi su, fene Owane Sitewi lo peri au te'e siye lu werese omo hire ma'e siyerowa. Lu ya'ariyei fene lo meni Abraham, meni Aisak, meni Jekop, lowe werese Owane Sitewi lo omo hire sahe ironamirowa. Fene lowe siyerowa su, fene marepi orese erasi a'i totenamirowa. Fene ai peri pi se tomu ketetenirowa. Fene luwei erasi lunamitorowa. Fene werese Owane Sitewi lo omo ma'e wirowata. Owane Sitewi lai fene yehe omo ma'e ani fu arosawirowa. Mt 8:11-12 ");
INSERT INTO sny_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Lu taune tomu ne'ese poweiye wiraisiya ape, poweiye pihatu itorisiya ape, eyate feni, opi feni ma'e lu taune tomu ne'ese, omo omo werese ma'e aiyerowa ape, Owane Sitewi lo omo hire ma'e ene ayei ne ta'uwerairowa. Sng 107:3 ");
INSERT INTO sny_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Sosu siyere! Lu taune tamo marepi apou toterowa su, ‘Nomo lu taune yahowa'i a'i ne.’ Owane Sitewi lai lowe yaru tutawe hene au onurowa. Lu taune tere'e apou a'i toterowa su, ‘Nomo yaru tutawe pei heneraire.’ Owane Sitewi lai lowe yaru ye'ewi au ei onurowa.” Mt 19:30 ");
INSERT INTO sny_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Jisas peri lo au te'eteye su, lu Farisi tamo le ma'e apou eiye, “Ne omo tere'e ma'e fa ire. Ne omo tere'e fareyare ta'ame su, awei meni owane Herot ne ma'e aine tera'eyei ne totesiya.” ");
INSERT INTO sny_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Sosu Jisas lowe ma'e itiya'u eiye, “Fene meni owane Herot ma'e apou au te'eri. ‘Ne meni peri wawero a'i ne. Ane pereye, aperi aiwawe a'i wiyawi ano ta'aneei. Ane sepei luwaru a'i au sasariyei. Ane u tahe tomu ne'ese au ta'ane fara'uweyei. Sosu nowe eweye su, ane wiyawi ano ta'ane tepa'asiyei.” ");
INSERT INTO sny_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Weiya, ane pereye sosu aperi ane yo mai sahe iteyei. Sosu nowe eweye ane omo Jerusalem ma'e heneriyei. Owane Sitewi lo peri au te'e siye meni ta fa temeniyeyei su, le omo Jerusalem nowe ma'e temeniyerowata.” ");
INSERT INTO sny_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Sosu Jisas omo Jerusalem lo lu taune ma'e eiye. “Lu taune omo Jerusalem irosiya ape, peri ano wanure! Fene Owane Sitewi lo peri au te'e siye lu ape mo aine tera'eteye. Lu tamo Owane Sitewi lai fene ma'e au te'eyei ne eimawesai ape, fene tapiye se fusawiyewe, aine tera'eye. Nowe tomu ne'ese a'i se ane fene ane ma'e ei ta'uwenamiteye. Apou wou a'i irowe kakaruk mai lo yene haipi unahi ei ta'uwerai. Ahowa, fene peri ano arisinamisiya. Fene ane ma'e ta'uwerai ta'ama. ");
INSERT INTO sny_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Fene werese siyere! Owane Sitewi lai wesi werese fene lo arunati tepa'asiye. Sosu ane fene ma'e te'esiya, fene ane tame siyerowata. Nowe ye'ewi su, ane si tame aiyerowa su, fene ane ne apou eirowa. ‘Meni ape, omo hire ma'e itorai ape, owane pefine a'i lo iyape se aiyerowa. Le marepi wisere a'i au te'e nine'inami-rowa.’ Sng 118:26 Nowe ye'ewi ape se fene ane tame siyerowa. ");
INSERT INTO sny_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sosu a'i pe nowe amou (Sabat) se Jisas, lu feni aiwawe a'i, Farisi meni owane ta lo wesi papu nau ta'ase ene ayei ne wiye. Lu Farisi werese Jisas lo yo seni siye eti ereiyei ne toteye. ");
INSERT INTO sny_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Sosu meni ta ereti lowe meiyei a'i ponei sahe iroteye. ");
INSERT INTO sny_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Sosu Jisas lu Farisi tamo, Owane Sitewi lo yo peri ani so'oru siye lu tamo, ma'e apou ei toweriye, “Moses lo yo peri ape piye te'esiya awere? Nowe amou (Sabat) se nomo fara'u meni u tahe se au ta'ane fara'uweyei awere? Piyete awere?” Lu 6:9 ");
INSERT INTO sny_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ahowa, lowe werese peri itiya'u se ta'ama. Serai le meni ape ereti se aniteye su, le u tahe lo au ta'ane fara'uweyewe, omo lo ma'e eimawesawi. ");
INSERT INTO sny_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Sosu le lowe ma'e au atati eiye, “Fene meni eime fene lo ta fe bulmakau fene lo ta, sa'i pitomuwe papu wiyeineye su, fene witane a'i poweiye amou se, meni eime, fe bulmakau ni'ariraiyei awere? Piyete awere?” Mt 12:11; Lu 13:15 ");
INSERT INTO sny_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Lowe werese peri lo itiya'u te'e ta'ame. ");
INSERT INTO sny_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Sosu a'i pe lu werese, ene ayei ne fai ape, lowe werese yaru tutawe onuwei ne toteye. Jisas lowe siyeye. Le lowe ma'e peri anowe ta au te'eye, ");
INSERT INTO sny_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Meni owane ta ne naituwei lo ta'uwe hereiyei ei ta'uwe aniyei su, ne yaru tutawe owe ape onure. Ne yaru tutawe onuwei su, meni owane pefine aiwawe a'i aiyeyei ape, le piye yaru se onurowata. Snd 25:6-7 ");
INSERT INTO sny_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Sosu meni owane ne fene ei ta'uwe aniye ape, le ne ma'e eiraiyei, ‘Ne yaru no meni ape ma'e au onure.’ Sosu ne, yaru no onuwe ape, arunatiyei, yaru tewiye ma'e fiyafe sahe onuriyei. Ne lai neritase erasi a'i teriteyei. ");
INSERT INTO sny_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ahowa, meni owane ne naituwe lo ta'uwe hereiyei ma'e ei aniyei su, ne yaru tewiye ma'e fiyafe sahe onuri. Serai meni owane, ne ei aniyei ape, le ne yaru tewiye ma'e onuwei siyeraiyei. Le ne ma'e apou eiyei, ‘Kaiyemo ne yaru tewiye ma'e arunatirowawe, yaru soro ma'e onura.’ Serai lu taune ne mase metei onuwei ape ne siyeyei su, lowe ne ne marepi wisere a'i toteyei. ");
INSERT INTO sny_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Lu taune werese iyape towafi lowe lo ei ani aroweyei ape, Owane Sitewi lai lowe werese hi ani ararowei. Lu taune werese marepi towafi lowe lo hi ani ararowei su, Owane Sitewi lai iyape lowe lo ei ani aroweyei.” Mt 23:12; Lu 18:14 ");
INSERT INTO sny_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Sosu a'i pe le meni Farisi ma'e, le naituwe lo ta'uwe hereiyei ei aniye ape, apou eiye, “Ne ta'uwe hereiyei ta au ta'ane naneiyei ne toteyei su, ne kaiyemo tamo, nairipi tamo lu tewi no tamo, lu taune ma'aru irosiya ape tamo, ne lowe werese ape mo owe ape ei anire. Ne lowe ei aniyei su, nowe me'iye ta se lowe ne itiya'u si tame pei ei anirowa. Lowe ta'uwe hereiyei ma'e ne ei aniyei su, lowe ne ma'e itiya'u aurowa. ");
INSERT INTO sny_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ahowa, ne ta'uwe hereiyei au ta'ane naneiyei ne toteyei su, ne lu taune yahowa'i a'i ma'aru ariye ape, lu taune lowe luwaru a'i iroteye ape, lu taune uwei ta'ame ape, lu taune nihe pokoweyei se ape, ne lu taune apou ape mo, ta'uwe hereiyei no ma'e ei anire. ");
INSERT INTO sny_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ne lu taune weneri apou ape mo ei aniyei su, lowe ne ma'e si itiya'u arowata. Ahowa, Owane Sitewi lai marepi fene lo ne au wisereyerowa. Sosu ne marepi wisere erasi a'i teriteye. Nowe ye'ewi ape se lu taune yo seni aseyaro iroteyei ape, Owane Sitewi lai lowe si tame norohuwe sineyei su, nowe ape se le lowe ma'e etiri erasi a'i si tame itiya'u aurowa. Jo 5:29 ");
INSERT INTO sny_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Meni ta ta'uwe hereiyei saro onu ateye ape, le Jisas lo peri wanuwe su, le Jisas ma'e apou eiye, “Lu taune werese Owane Sitewi lo omo hire sahe onu arowa su, lowe marepi wisere a'i irorowa.” Lu 13:29 ");
INSERT INTO sny_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Sosu Jisas le ma'e peri anowe ta itiya'u apou eiye, “Meni owane ta'uwe hereiyei erasi au ta'ane naneiyei ne toteye. Lu taune erasi ma'e apou eiye, ‘Ayei etiri werese ta'uwe nanei tepa'asiyei su, ane fene werese wesi ano ma'e ei ta'uwe aniye.’ ");
INSERT INTO sny_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ta'uwe hereiyei lo nowe heneraiyei su, meni owane wiyawi yahowa'i a'i iro siye meni ma'e eiye, ‘Ne lu taune werese ma'e, ane tu ei aniye ape, ne lowe werese ma'e ei anire. Ayei etiri werese ta'uwe nanei tepa'asiye.’ ");
INSERT INTO sny_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Sosu wiyawi yahowa'i a'i ta'ane siye meni lowe werese ei aniye su, lowe werese le ma'e itiya'u eiye, ‘Ane ta'uwe hereiyei no aiyerowata. Ane ta'aneyei awei tewi a'i ete tepa'asiye, sosu ane ta'aneyei awei tewi ape pei siyerire. Serai ane aiyerowata.’ ");
INSERT INTO sny_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Meni tere'e le ma'e itiya'u apou eiye, ‘Weiya! Ane fe bulmakau hesi a'i ete tepa'asiye. Sosu ane ta'aneyei awei ano lowesi se pei au horusere. Serai ane ta'uwe hereiyei no ma'e aiyerowata.’ ");
INSERT INTO sny_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Meni tere'e apou eiye, ‘Ane tani ano he'i naitu tepa'asiye. Serai ane ta'uwe hereiye no ma'e aiyerowata.’ 1 Ko 7:33 ");
INSERT INTO sny_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Sosu wiyawi yahowa'i a'i ta'ane siye meni lai meni owane lo ma'e si tame eirai. Meni owane ai marepi erasi a'i toteye. Sosu le wiyawi yahowa'i a'i ta'ane siye meni ma'e apou eiye, ‘Ne omo lo yo mai ma'e ire. Lu taune ereti lowe luwaru a'i, lu taune eiwerou uwei ta'ame ape, lu taune ma'aru ariye ape, lu taune nihe pokoweyei irosiya ape, ne lu taune apou ape mo ta'uwe hereiyei ano ei ta'uwe anire.’ ");
INSERT INTO sny_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Wiyawi yahowa'i a'i ta'ane siye meni lu taune apou ape ei ani henetai. Sosu le meni owane lo ma'e si tame eirai. ‘Weiya! Ane marepi no umasiye, onuwei yaru tomu ne'ese irosiya.’ ");
INSERT INTO sny_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Sosu meni owane ape lai wiyawi yahowa'i a'i ta'ane siye meni ma'e eiye, ‘Ne ipo ma'e ire, ipo lu taune apou ape aiwawe a'i ei henetaire. Lu taune lai wesi ano fa teme'eriyere. ");
INSERT INTO sny_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ane ne ma'e eisiya. Lu taune weneri werese ape ane tu ei aniye ape, lowe wesi ano ma'e ta'uwe hereiyei ape sahe onu ene arowata.’” ");
INSERT INTO sny_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Sosu a'i pe Jisas ta'uwe hereiyei arunatiyewe fi. Lu taune tomu ne'ese le mase mo'o umasititeye. Le lowe ma'e atati te'eye, ");
INSERT INTO sny_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Meni ta, menitani ta ane mo'o umasiyei ma'e aiyeyei su, le ane ne tutawe marepi erasi a'i fu totete. Le tai mai, nairipi, einei werese fa arunatire. Le marepi topo lo pei hi ani ararore. Le etiri werese ape mo me'iyeni ma'e arunatiyei su, le marepi ano fa umasite. Serai le lu feni ano henerairowa. Lu 9:23 ");
INSERT INTO sny_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Nowe me'iye ta su, lu tamo lai ane me tape'i sahe aine tera'e temeniyerowa. Lowe me tape'i iyo'o ano sutetiyei ne furowa. Ane fofowei erasi a'i teriteyei. Serai ane fene ma'e te'esiya. ");
INSERT INTO sny_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Meni ta wesi ta'aneyei ne toteyei su, le wesi ape ta'aneyei etiri werese fa tote etire. Ma'aru ano fara'u wesi ape ta'ane tepa'asiyerowa awere? Piyete awere? ");
INSERT INTO sny_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Meni ape ma'aru lo tote eti ta'ame su, le me tou a'i horuse asirowa. Serai ma'aru werese lo po'uteyei su, le wesi lo ta'ane tepa'asirowata. Lu taune werese le ne au niyeyei irorowa. Sosu le neritase erasi a'i teriterowa. ");
INSERT INTO sny_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Lowe meni ape ne apou eiyei, ‘Meni ape siyere! Le wesi lo ape ta'aneyei ne toteye su, le wesi lo ape ta'ane tepa'asi ta'ame.’ ");
INSERT INTO sny_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Fene awei meni owane tutawe ne totere! Le awei meni owane tutawe tere'e ai atu tiyatiyei ne toteyei su, le ai atu siye lu werese lo nawitere. Le apou toteyei, ‘Ane awei meni owane tutawe tere'e ai atu tiyatiyei su, ane ai atu tiyatiyei awere? Ane le ma'e ai atu siye lu oso a'i se ai atu tiyatiyei awere? Awei meni owane tutawe tere'e lo ai atu siye lu 20,000 irosiya ape, ane fara'u ai atu siye lu 10,000 le ma'e ai atu tiyatiyei awere?’ ");
INSERT INTO sny_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Le apou totesiya. ‘Weiya, ane ai atu siye lu 10,000 meni owane tutawe tere'e lo ai atu siye lu 20,000 hi ani ararorowata. Serai ane awei meni owane ape ma'e ai aturairowata. Ane awei meni owane tutawe ape ma'e lu tamo te'eyei ne eimawesawiyei. Lowe marepi fetane a'i fa ironamite.’” ");
INSERT INTO sny_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Sosu Jisas lowe ma'e eiye, “Serai ane fene ma'e te'esiya. Fene etiri werese fene lo arunatiyei ta'ama su, fene lu feni ano henerairowata. ");
INSERT INTO sny_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Serai ipari sei fi wisere a'i ne. Ahowa, ipari sei lo fi po'uteyei su, fene piye se ani terosowei awere? ");
INSERT INTO sny_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ahowa, ipari sei lo fi po'uteyei su, luwaru a'i tene! Serai nomo ipari sei luwaru a'i ani fusawiyei. Meni ta peri ano wanuwei ne toteyei su, le peri ano wanu etiyei. Le fara'u ane ne tote tawesi umasinamirowa.” ");
INSERT INTO sny_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Sosu a'i pe takis ma'aru aniyei siye lu tamo, lu taune tere'e, Juda lo yo peri arisiye ape, lowe Jisas ma'e atahe a'i peri lo wanuwei ne ta'uwerai. ");
INSERT INTO sny_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Lu Farisi tamo, Juda lo yo peri lese siye lu tamo, lowe Jisas ne peri kokoti erasi a'i toteye. Lowe apou toteye. “Meni ape, Jisas, le lu taune yo seni luwaru irosiya ape, mase ene ateye. Le lowe ma'e au wisereye eritesiya. Yo seni ape amouwesiya.” Lu 5:30 ");
INSERT INTO sny_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Sosu Jisas lowe ma'e peri anowe ta au te'eye, ");
INSERT INTO sny_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Fene fe sipsip lu ereti feni werese (100 aiwawe a'i) irosiya. Sosu fe sipsip ta'i arunatiyewe fi. Ne fe sipsip tere'e werese (99) yaru amerame wisere a'i arunatiyewe, fe sipsip ta'i ani nehiti. Sosu ne fe sipsip ape nehitinauwe, nehitinauwe siyeri. Ese 34:11,16; Lu 19:10 ");
INSERT INTO sny_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Sosu le fe sipsip ape arunatiyewe fi ape, siyeye su, le fe sipsip ape wano'o sahe marepi wisereye nine'iyewe, si tame suteti. ");
INSERT INTO sny_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Sosu meni ape wesi lo si tame fai su, le kaiyemo mo werese lo ei ta'uwe aniye. Le lowe ma'e eiye, ‘Fene werese ane aiwawe Owane Sitewi ma'e au te'e wisereyere. Ane fe sipsip ano, ipo ma'e arunatiyewe fi ape, ane nehi siye te'i henetai.’ ");
INSERT INTO sny_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Owane Sitewi lo omo hire ma'e se aiwawe a'i ne. Meni ta yo seni luwaru a'i me'iyeni ma'e atati aruwei su, Owane Sitewi lai etiri werese, hire ma'e irosiya ape, ei ta'uwe aniyei. Marepi wisere erasi a'i au nine'inamirowa. Lu taune tomu ne'ese Owane Sitewi lo yo seni umasinamiye. Owane Sitewi lo ipari werese lowe ne aiwawe a'i marepi wisere a'i nine'inamisiya.” ");
INSERT INTO sny_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Menitani ta ma'aru tau ereti feni hesi iroteye su, le ma'aru tau ta'i winetainati. Menitani ape yehe erei fu etineyewe, wesi lo oro'oru koruwe nehiteye. Le oro'oru werese koruwe nehiteye su, le ma'aru tau ape nehi siyeye. ");
INSERT INTO sny_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Le ma'aru tau ape siyeye su, le kaiyemo mo werese lo ei ta'uwe aniye. Le lowe ma'e eiye, ‘Siyere! Ane ma'aru tau ano, winetainati ape, ane nehi siye tepa'asiye. Nomo werese marepi wisere erasi a'i au nine'inamirowa.’ ");
INSERT INTO sny_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Owane Sitewi lo omo hire ma'e aiwawe a'i ne. Owane Sitewi, ipari wisere werese a'i lo aiwawe a'i, meni ta, menitani ta yo seni luwaru a'i, me'iyeni ma'e atati arunati ape, lowe marepi wisere erasi a'i nine'inamirowa.” ");
INSERT INTO sny_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Sosu a'i pe Jisas peri anowe ta au te'eteye. Le apou eiye, “Meni owane ta eimane hesi iroteye. ");
INSERT INTO sny_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Eime Peiwe tai lo ma'e apou ei toweriye, ‘Tai ano, ne ma'aru tewi werese ano ausa!’ Sosu tai lowesi lo etiri ma'aru werese eime Peiwe lo tewi a'i erei auwe. ");
INSERT INTO sny_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Nowe me'iye ta se eime Peiwe etiri ma'aru werese lo ani ta'uweyewe, omo eyeri ma'e fi. Omo eyeri ma'e sahe eime Peiwe ma'aru werese ete po'uteteye. Le yo seni luwaru a'i ironamiteye. ");
INSERT INTO sny_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Sosu ma'aru werese po'uteye su, omo pani sahe lu taune werese lau erasi ironamiteye. Eime Peiwe aiwawe a'i lau erasi iroteye. ");
INSERT INTO sny_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Serai le meni owane ta ma'e wiyawi ani nehiyei ne fi. Meni owane ape eime Peiwe fe werese lo ma'e au ayei ne eimawesawi. ");
INSERT INTO sny_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Eime Peiwe lau erasi ironamiteye. Le fe lo sawi tahe siye wisereyeyewe, ene ayei ne totesiya. Lu werese le ma'e ayei ta au arowata. ");
INSERT INTO sny_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Serai eime Peiwe marepi farere a'i toteye. Le apou toteye, ‘Weiya, tai ano wiyawi ta'ane siye lu tomu ne'ese irosiya. Lowe werese nau ta'ase tomu ne'ese ene asiya. Ane lau erasi a'i temeniye ataheyewa! ");
INSERT INTO sny_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ane tai ano ma'e iyei ne. Ane le ma'e apou eiyei. Tai ano, ane Owane Sitewi ne yo seni luwaru a'i iroteye. Ane ne ne aiwawe a'i yo seni luwaru a'i iroteye. Sng 51:4 ");
INSERT INTO sny_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ne ane ne meni eime no eirowata. Ane meni yahowa'i a'i ne. Ane wiyawi meni yahowa'i a'i no henerayei.’ ");
INSERT INTO sny_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Sosu meni eime Peiwe sineyewe, tai lo ma'e si tame fi. Eime Peiwe tai ma'e eyeri aiyeteye su, tai lo le siye aniye. Sosu le marepi ferafereiyei erasi toteye. Meni eime lo ma'e iteroti. Le meni eime lo ya'ore tawesiri. Le meni eime lo tu nihari ya'ore ime imeye. ");
INSERT INTO sny_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Sosu eime Peiwe tai lo ma'e apou eiye, ‘Tai ano, ane Owane Sitewi ne yo seni luwaru a'i ironamiteye. Ane ne ne aiwawe a'i. Ne ane ne meni eime no eirowata. Ane meni yahowa'i a'i ne.’ ");
INSERT INTO sny_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ahowa, tai lo wiyawi yahowa'i a'i ta'ane siye lu ma'e eiye, ‘Fene witane a'i ipari tahe tutawe aiseri. Meni eime ano ma'e au asire. Fene afeiye ano aiseri, meni eime lo pere'i sahe au wa'arere. Fene lowe tahe aiseri, meni eime lo lowe au asire. ");
INSERT INTO sny_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Fe bulmakau yene piyo'u a'i hene aiseri. Fene fe bulmakau nei tou opaire. Nomo ta'uwe hereiyei ta au ta'aneyei. Nomo marepi wisere erasi a'i nine'inamiyei. ");
INSERT INTO sny_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Siyere! Meni eime ano tu temeniyeye. Pereye nowe eite se le si tame norohuwe sineye. Le arunati po'uteye, pereye nomo nowe eite se le sato irosiya.’ Sosu lowe werese marepi wisere erasi a'i nine'iteye. Ef 2:1,5 ");
INSERT INTO sny_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Sosu a'i pe eime Poto ta'aneyei awei sahe ta'aneteye. Neriwei su le wesi lo atahe a'i fai. Le no'u erasi a'i wanuwe. Le wau no'u yakowei ahi wanuwe. ");
INSERT INTO sny_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Sosu le wiyawi yahowa'i a'i ta'ane siye meni ta ei aniye. Le le ma'e ei toweriye, ‘Piyene no'u erasi a'i, ane wanuwe ape, henerai awere?’ ");
INSERT INTO sny_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Sosu wiyawi ta'ane siye meni le ma'e itiya'u eiye, ‘Pa'ise no si tame fai. Tai no fe bulmakau piyo'u a'i nei tou opaiye. Tai no lai pa'ise no si tame fai ape, au wisereye eritesiya.’ ");
INSERT INTO sny_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ahowa, eime Poto ai marepi erasi a'i toteye. Le wesi lo papu wi ta'ame. Sosu tai lai wesi lo nowe ma'e henerai. Le meni eime lo ma'e ei toweriye. Ne wesi papu wira. Marepi wisere a'i au iro nine'ire.’ ");
INSERT INTO sny_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Meni eime Poto tai lo ma'e itiya'u eiye, ‘Wanure, ane iyu menei tomu ne'ese wiyawi no ta'ane tohoteteye. Ane marepi werese no mi mi werese umasinamiteye. Ne fe meme ta'i ane ma'e nei tou opai au ta'ame. Sosu ane kaiyemo mo werese ano ei ta'uwe hereiyei au ta'ane ta'ame. ");
INSERT INTO sny_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ahowa, eime Peiwe no ne totere. Le ma'aru werese no ete po'uteye. Le yo seni luwaru a'i ironamiteye. Le taune luwaru a'i tamo tafa'e yo seni iroteye. Eime Peiwe no si tame fai su, ne fe bulmakau piyo'u a'i le ne nei tou opaiyewe, au ene ateye. ");
INSERT INTO sny_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Sosu tai lo le ma'e itiya'u eiye, ‘Meni eime ano. Ne mi mi pasi pasi ane mase ironamisiya. Etiri werese ano no a'i ne. ");
INSERT INTO sny_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pa'ise no tu temeniyeye. Pereye nowe eite se le si tame sineteye. Le arunati po'uteye. Nomo le sato siye irosiya. Serai nomo marepi wisere erasi a'i fu nine'iyei ne.’” ");
INSERT INTO sny_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Sosu a'i pe Jisas lu disaipel lo ma'e peri anowe ta au te'eye, “Meni owane ta wiyawi ta'ane siye meni iroteye. Meni Owane lai etiri werese lo meni ape ma'e au noweinoweiyei ne auwe. Lu tere'e tamo meni owane ma'e peri ta au te'esai. ‘Wiyawi ta'ane siye meni no etiri ma'aru no ne yo seni luwaru a'i ironamiye.’ ");
INSERT INTO sny_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Sosu meni owane lai wiyawi ta'ane siye meni ei aniye. Le le ma'e ei toweriye, ‘Ne piye etiri ma'aru ano yo seni luwaru a'i irowe awere? Ne ma'aru lo peri ape ne ane ma'e au te'esa. Ne wiyawi ano owe ape ta'anere. Ne ane arunatire!’ ");
INSERT INTO sny_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Sosu wiyawi ta'ane siye meni ape marepi apou toteye, ‘Ane piye irowei awere? Meni owane ano lai wiyawi ano au einamiye. Tahe ano pere'eyeye. Ane awei horuserowata. Ane yo mai sahe onuwewe, ma'aru yahowa'i a'i ei anirowata. Ane yo seni ape ne neritase erasi a'i ne. ");
INSERT INTO sny_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Weiya, ane so'oruwesiya. Ane etiri ta fa ta'aneyei. Ane pereye a'i wiyawi wisere a'i lu tamo ma'e au ta'anerowa. Serai wiyawi ano ariye po'uteyei su, ane fara'u wesi lowe lo ma'e isafiyeyei ne iyei. Lowe etiri tamo ane ma'e aurowa. ");
INSERT INTO sny_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Sosu le meni owane lo lu tamo, ma'aru etiri tamo yahowa'i a'i aniye ape mo, ei aniye. Serai le meni ta'i apou ei toweriye, ‘Ne meni owane ano ma'e ma'aru eiwerou a'i itiya'u, pei auwei awere?’ ");
INSERT INTO sny_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Sosu meni ape itiya'u eiye, ‘Ane meni owane no 100 dram me oliv lo fisa'i itiya'u fa auwei.’ Sosu wiyawi ta'ane siye meni le ma'e eiye, ‘Ne one towe sahe witane a'i se apou lesere, 50 dram itiya'u aure.’ ");
INSERT INTO sny_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Sosu wiyawi ta'ane siye meni ape meni tere'e ma'e apou ei toweriye, ‘Ne meni owane ano ma'e ma'aru etiri eiwerou a'i itiya'u auwei awere?’ Meni ape le ma'e itiya'u eiye, ‘Ane kewi so 100 wahu erasi meni owane no itiya'u fa auwei.’ Wiyawi ta'ane siye meni ape le ma'e eiye, ‘Ne one towe sahe lesere, ane 80 kewi so wahu se ape itiya'u auwei.’ ");
INSERT INTO sny_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Nowe me'iye su, meni owane ape wiyawi ta'ane siye meni lo ne toteye. Wiyawi ani siye meni ano, le etiri ano areareteye. Ahowa, ane meni ape au te'e wisereyesiya. Le marepi wisere a'i toteteye. ‘Wiyawi ta'ane siye meni ano awei lo marepi erasi a'i siye so'oruwesiya.’” Sosu Jisas apou eiye, “Lu taune werese, awei lo marepi umasisiya ape, lowe werese awei lo yo seni erasi a'i siye so'oruwesiya. Lu taune Owane Sitewi lo yo seni umasisiya ape, lowe awei lo yo seni siye so'oru ta'ama.” ");
INSERT INTO sny_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Sosu Jisas lowe ma'e tame eiye, “Ane fene ma'e eisiya. Fene lu taune tamo awei lo ma'aru etiri tamo au pati ta'aneyei ne auwei su, lowe nati wafei fene lo henerairowa. Sosu ma'aru fene lo ariye po'uteyei su, Owane Sitewi lai fene ne au noweinoweirowa. Le lai fene omo lo ma'e hene wirowa. Sosu fene le mase mi mi pasi pasi ironamitorowa. ");
INSERT INTO sny_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Meni ta etiri oso oso a'i ta au noweinoweinamiteyei su, le etiri erasi a'i aiwawe au noweinoweinamirowa. Sosu aiwawe a'i meni ta yo seni oso oso a'i au luwaruweyei su, le aiwawe a'i yo seni erasi a'i au luwaruweyei. Lu 19:17-26 ");
INSERT INTO sny_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Serai fene awei lo ma'aru ta au noweinowei luwaruweyei su, Owane Sitewi lai etiri lo se fene ma'e au noweinoweiyei ne aurowata. ");
INSERT INTO sny_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Fene meni tere'e lo etiri au noweinowei luwaruweyei su, eiwerai fene ma'e etiri towafi fene lo aurowa awere? ");
INSERT INTO sny_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Wiyawi yahowa'i ta'ane siye meni ta le lu owane hesi a'i lo wiyawi ta'anerowata. Le meni owane ta'i lo marepi werese umasirowa. Sosu le meni owane tere'e ma'e ai marepi totenamirowa. Aiwawe a'i le meni owane ne marepi erasi a'i tote wawesiyenamirowa. Sosu le meni owane tere'e lo marepi arisirowa. Fene awei lo ma'aru erasi a'i totenamiyei su, fene Owane Sitewi ne toterowata.” Mt 6:24 ");
INSERT INTO sny_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Sosu a'i pe lu Farisi tamo, lowe ma'aru marepi erasi totenamisiya ape, lowe Jisas lo peri sato onu wanuteye. Lowe le ne peri luwaru a'i te'e naruteye. ");
INSERT INTO sny_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Sosu Jisas lowe ma'e eiye, “Etiri werese, fene iroteye ape, fene lu taune lo nihe se au ironamiteye. Fene apou totesiya, ‘Yo seni nomo lo aseyaro a'i ne. Ahowa, Owane Sitewi lai marepi fene lo fareyareyei irosiya ape, Owane Sitewi lai siye so'oruwe tepa'asiye. Etiri werese ne, awei lo lu lai marepi erasi a'i totesiya ape, Owane Sitewi lo nihe se etiri werese ape mo ne, le lai oriyei ne totesiya. Mt 23:28; Lu 18:9-14 ");
INSERT INTO sny_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Tu naifa nowe mi mi werese, Owane Sitewi lo peri au te'e siye lu lai, Owane Sitewi lo yo peri, Owane Sitewi lo peri lu tamo one towe sahe leseye ape, lowe lu taune ma'e au te'e areiyeteye. Meni Jon sa'i au hu siye meni, henerai su, Owane Sitewi lo peri lu tamo, one towe sahe leseye ape, au te'e tepa'asiye. Jon lo nowe se lu tamo lai peri heneruwe wisere a'i apou au te'e fiyari areiyeteye. Nowe ape se Owane Sitewi lai lu taune werese au noweinoweitorowa ape, Owane Sitewi lai lu taune ma'e peri ape ne au te'enamiteye. Lu taune werese peri he'i wanuwe su, lowe werese Owane Sitewi lo omo sahe wiyei ne tote tohotereme. Mt 11:12-13 ");
INSERT INTO sny_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Nowe ye'ewi ta se ni'arawe werese awei werese perati po'uterowa. Weiya, Owane Sitewi lo peri werese arunati po'uterowata. Owane Sitewi lo peri tewi oso oso a'i arunati po'uterowata. Mt 5:18 ");
INSERT INTO sny_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Meni ta tani lo tai mai ma'e si tame eimawesawiyei ape, le menitani tere'e naituwei su, le yo seni luwaru a'i iroteyei. Meni tere'e lai menitani tu tai mai ma'e eimawesawi ape, le menitani ape naituwei su, meni ape tafa'e yo seni luwaru a'i iroteyei.” ");
INSERT INTO sny_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Sosu a'i pe Jisas peri anowe ta lowe ma'e au te'eteye, “Meni owane ta ma'aru tomu ne'ese iroteye. Le mi mi werese ipari tahe lo'u wisere a'i ani asiteye. Mi mi werese se le ta'uwe hereiyei au asiya. Yo seni apou ape irosiya. ");
INSERT INTO sny_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Meni yahowa'i a'i ta enite tomu ne'ese tahe werese lo ya'orenamiteye. Lu tamo meni ape, iyape Lasarus, meni owane ape lo yo sahe hene onuteye. ");
INSERT INTO sny_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Le nau ta'ase tewi a'i meni owane lo metei, unahi winetaiteye ape, sowateyei ne totesiya. You tamo meni ape lo enite werese sorowe se peyo'oteye. ");
INSERT INTO sny_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Nowe me'iye su, meni Lasarus temeniyeye. Owane Sitewi lo ipari wisere a'i tamo meni ape lo hepene hire ma'e, meni Abraham mase ironamiteye ape, hene wiye. Aiwawe a'i meni owane temeniyeye. Lu tamo tahe pa'are lo awei fisiye yo sahe fuwe. Owane Sitewi lai hepene lo yehe omo ma'e eimawe arosawi. ");
INSERT INTO sny_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Meni Owane lo hepene nihe lo hire ma'e Abraham eyeri ma'e siye ani aroweye. Le meni Lasarus, Abraham mase iroteye ape, siyeye. Meni Owane ape fofowei erasi a'i teriteye. ");
INSERT INTO sny_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Sosu le Abraham ma'e peri morose erasi a'i uteye, ‘Abraham, ya'ariyei ano, ne ane ne au ferafereire. Ne meni Lasarus ane ma'e ito eimawe arosa. Serai le ereti tepi lo sa'i naretei a'i sorowe ano au fu nareteiyere.’ ");
INSERT INTO sny_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ahowa, Abraham le ma'e itiya'u eiye, ‘Eimane, ne awei sato iroteye ape, ne etiri tomu ne'ese wisere a'i ta'uwe ani funamiteye. Nowe ape se meni ape Lasarus le etiri luwaru a'i teriteteye. Serai pereye, le lai marepi fetane a'i ironamisiya. Ne aiwawe a'i lai fofowei erasi a'i teritenamisiya! ");
INSERT INTO sny_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Siyere! Ne eyeri erasi hi yaro irosiya. Lasarus hire ma'e irosiya. Le hi ne ma'e itorirowata. Yaru yahowa'i a'i ponei sahe irosiya.’ ");
INSERT INTO sny_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Meni owane le ma'e eiye, ‘Ane ne ma'e ei towerisiya, ya'ariyei ano, ne meni Lasarus lu tewi ano hi ma'e peri ape au te'esaiyei ne eimawe ito arosawire. ");
INSERT INTO sny_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ane lu nairipi ereti feni werese (5) hi ma'e irosiya. Ne meni Lasarus nairipi ano te'e weiyai au te'eyei ne eimawe ito arosawire. Serai lowe fofowei erasi a'i, ane teritenamisiya ape, lowe yehe omo eite sahe fofowei erasi teriterairowata.’ ");
INSERT INTO sny_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ahowa, ya'ariyei Abraham le ma'e itiya'u eiye. ‘Wanure, lowe yo peri ta, ya'ariyei Moses leseye ape, Owane Sitewi lo peri au te'e siye lu werese lo peri irosiya ape, nairipi no ape mo lowe peri lowe lo fara'u wanuwei.’ ");
INSERT INTO sny_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ahowa, meni owane ape Abraham ma'e itiya'u eiye, ‘Ahowa, ya'ariyei auwe ano, lowe peri lowe lo wanu umasi ta'ame. Weiya, meni ta temeniyeyewe, si tame sineye su, le nairipi ano hi ma'e Owane Sitewi lo peri au te'eyei ne itoraiyei su, lowe peri werese ape mo wanu umasiyei. ");
INSERT INTO sny_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Sosu Abraham le ma'e itiya'u eiye, ‘Nairipi no ya'ariyei Moses lo peri, sosu Owane Sitewi lo peri au te'e siye lu lo peri wanu umasi ta'ame su, lowe meni ta temeniyeyewe, si tame sineye ape, lowe meni ape lo peri tote wanu umasi ta'ame.’” ");
INSERT INTO sny_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jisas peri anowe ape lowe ma'e au te'e tepa'asiye su, le lu disaipel lo ma'e apou eiye, “Ane peri wiyeme a'i ta fene ma'e au te'esiya. Meni ta marepi luwaru a'i lu taune ma'e au atuatuwei su, serai lowe yo seni luwaru a'i ape ne siye wisereyeyei. Sosu lowe yo seni luwaru a'i ape lo umasinamirowa. Lowe yo seni luwaru a'i umasiyei su, meni ape ne weiyai! Owane Sitewi lai le ma'e etiri luwaru erasi a'i itiya'u aurowa. ");
INSERT INTO sny_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Meni ape lu taune lo marepi tatai aniyei ne toteyei su, lu tamo tapiye erasi a'i meni ape lo pere'i sahe wafei se ti tawesirowawe, sosu sa'i ya'orei papu ani fu arorowa. Serai meni ape lu taune marepi kairefi se ta'ama ape, le marepi lowe lo au luwaruwerowata. Lowe meni ape ani fu arorowa su, yo seni lowe lo wisere a'i tene! ");
INSERT INTO sny_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Weiyai, fene marepi fene lo au noweinoweite. Meni ta yo ano umasisiya ape, si yo seni luwaru a'i irowei su, fene yo seni meni ape lo au fareraiyere. Sosu le yo seni luwaru a'i topo lo me'iyeni ma'e atati aruwei su, fene yo seni luwaru a'i lo fu tote i'anere. Mt 18:15 ");
INSERT INTO sny_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Sosu meni ape yo seni luwaru a'i fene ma'e nowe ereti feni werese feni hesi a'i se (7) au irowei. Sosu le fene ma'e si tame nowe ereti feni werese feni hesi a'i se (7) aiyeyei su, fene ma'e apou eiyei, ‘Ane yo seni luwaru a'i fene ma'e irowe.’ Fene lai yo seni ape lo fu tote i'anere.” ");
INSERT INTO sny_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Sosu a'i pe Jisas lo lu feni ta le ma'e apou eiye, “Meni Owane, peri ape no kairefi a'i ne. Ne tote tawesiyei nomo lo au kairefiyere!” ");
INSERT INTO sny_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Sosu Meni Owane Pefine a'i lowe ma'e itiya'u eiye, “Tote tawesiyei fene lo ne, saiyoho so oso a'i aiwawe a'i irosiya su, fene me saiyoho ape ma'e apou eiyei, ‘Saiyoho ne me napi mase tahe auwere, sosu sa'i erasi ponei sahe teirire.’ Saiyoho peri no wanurowawe, umasirowa. Mt 17:20; 21:21 ");
INSERT INTO sny_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Fene wiyawi yahowa'i a'i iro siye meni fene lo ma'e apou eiyei su, ‘Ne ta'aneyei awei ano ma'e ire. Ne ta'aneyei awei ano sahe wiyawi erasi a'i irore!’ Sosu neriwei su wiyawi yahowa'i a'i iro siye meni si tame aiyeyei su, fene piye peri meni ape ma'e apou eiyei awere? ‘Ne metei ano sahe onura, ane ne au ayei.’ ");
INSERT INTO sny_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ahowa, meni ape ta'aneyei awei ma'e si tame aiyeyei su, fene le ma'e apou eiyei, ‘Ne ipari tahe wara'i a'i ani asire. Mo'o ne ayei ano au opai naneire. Sosu ane ayei, sa'i a tepa'asiyei su, ne fara'u wesi no ene ayei sa'i are.’ ");
INSERT INTO sny_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Aiwawe a'i wiyawi yahowa'i a'i ta'ane siye meni lai etiri werese ape wanu umasi irowei su, meni owane lai meni ape au wisereye ta'ame. ");
INSERT INTO sny_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Fene aiwawe a'i irore! Owane Sitewi lai fene ma'e peri ta au te'eyei su, fene peri lo ape fu wanu umasire. Fene peri lo wanu umasiyei su, fene apou eire, ‘Nomo wiyawi yahowa'i a'i ta'ane siye lu no ne. Nomo peri no wanu umasi tepa'asiye.’” ");
INSERT INTO sny_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Sosu a'i pe Jisas lu disaipel lo mase omo Jerusalem ma'e iteye. Lowe pani Galili, pani Samaria ponei sahe iteye. ");
INSERT INTO sny_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Lowe omo ta heneri su, lowe lu ereti feni hesi (10) nowe ma'e siyeye. Lu werese ape mo enite kairefi a'i, iyape lepra, iroteye. Lowe eyeri ma'e teiteyewe, Jisas ma'e peri morose eiye. ");
INSERT INTO sny_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Lowe peri erasi apou uteye, “Jisas, Meni Owane, ne nomo ne au ferafereire!” Wkp 13:45-46 ");
INSERT INTO sny_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Sosu Jisas peri lowe lo wanuwe su, le lowe ma'e itiya'u eiye, “Fene au heseyei lu owane ma'e ire! Fene tahe fene lo lowe ma'e au atuature.” Sosu lowe werese au heseyei lu owane ma'e iyei ne toteye su, enite kairefi lowe lo wara'i a'i niyemaiye tepa'asiye. Wkp 14:2-3; Jo 3:3; 18:36 ");
INSERT INTO sny_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Meni ta'i tahe topo lo wara'i a'i siyeye su, le atatiyewe, Jisas ma'e si tame fai. Le Owane Sitewi ma'e peri erasi a'i se au te'e wisereyeye. ");
INSERT INTO sny_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Le Jisas ma'e henerai su, le Jisas ma'e lowe uporo ape'i onuwewe, Jisas ma'e au te'e wisereyeye. Meni ape pani Samaria ma'e fai. ");
INSERT INTO sny_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Sosu Jisas le ma'e itiya'u eiye, “Ane lu ereti feni hesi (10) enite kairefi a'i au ta'ane niyemaiyeye. Lu tere'e tere'e ape mo, eiwerou ma'e irosiya awere? ");
INSERT INTO sny_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Lu ereti hesi werese feni hesiyo hesiyo (9) ape mo, lowe si tame atatiyewe, Owane Sitewi ma'e au wisereye ta'ame awere? Meni ta'i a'i pani tere'e ma'e fai ape, le ta'i a'i si tame atatiyewe, Owane Sitewi ma'e au te'e wisereyeye.” ");
INSERT INTO sny_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Sosu Jisas meni ape ma'e apou eiye, “Sinere! Ne wesi no ire! Tote tawesiyei no lai enite kairefi no au ta'ane niyemaiyeye.” ");
INSERT INTO sny_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Sosu a'i pe lu Farisi tamo Jisas ma'e te'e toweriyei ne fai. Lowe apou te'e toweriye, “Nowe eiwerou su Owane Sitewi lai awei hi ma'e itoraiyei awere? Eiwerou su le awei lu owane werese hi ani ararosawirowa awere? Sosu eiwerou su le lu taune werese wisere a'i au noweinoweiyei awere?” Sosu Jisas itiya'u eiye, “Nowe ape, Owane Sitewi lai, lu taune au noweinoweirowa ape, heneraiyei su, lu taune werese yaro erasi a'i lo nowe ape se siyerowata. ");
INSERT INTO sny_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Lu taune werese apou au te'erowata, ‘Siyere! Owane Sitewi lo omo ape ne saro ironamisiya.’ Ahowa, aiwawe a'i lowe peri eite apou au te'erowata, ‘Weiya, Owane Sitewi lo omo ape ne feni yaro irosiya.’ Ahowa, wanure! Nowe ape se Owane Sitewi lai, lu taune werese au noweinoweisiya ape, fene mase pereye ironamisiya.” ");
INSERT INTO sny_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Sosu a'i pe Jisas peri ape itiya'u au te'eye su, le lu disaipel lo ma'e apou eiye, “Nowe ta se heneraiyei su, fene werese peri erasi apou eiyei, ‘Meni ape, hire ma'e itorai ape ne, awei hi ma'e witane se a'i fa itora. Nomo meni ape siyereme.’ Ahowa, fene nowe ape se siyerowata. ");
INSERT INTO sny_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Lowe fene ma'e apou au te'erowa. Meni hire ma'e itorai ape, le hi awei ma'e itorai tepa'asiye. Fene lai meni ape sato nehira! Fene feni yaro ma'e siye nehiti!’ Weiya! Ahowa, fene lowe mase owe ape ire! Fene lai lowe mo'o owe ape itero umasire.” Mk 13:21; Lu 21:8 ");
INSERT INTO sny_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","“Fene mera'o ne totere. Fene pasi a'i se mera'o siyeyei su, fene mera'o lo mi ni'arawe werese sahe tewi fiyari howeiyei. Sosu aiwawe a'i meni ape hire ma'e itorairowa ape, nowe ape se le hi awei ma'e itoraiyei su, lu taune werese omo omo werese sahe le ne aiwawe siyerowa. ");
INSERT INTO sny_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Weiya, meni ape tu fofowei erasi a'i fa teriteyei. Lu taune tomu ne'ese le ne me'iyeni ma'e atati aruwei. ");
INSERT INTO sny_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","27","Tu naifa weriyei yo seni apou ape aiwawe a'i henerai. Fene meni Noa ne totere. Lu taune werese ayei ahi a'i ene ateye. Lowe sa'i meremereye a'i ene anamiteye. Lowe taune naituteye. Lowe taune ma'aru eteteye. Sosu meni Noa lu tewi mase wai erasi papu arowato wiye su, lu taune werese yo seni apou ape ironamiteye. Sosu meni Noa wai erasi papu arowatowe su, Owane Sitewi lai sa'i erasi eimawe arosai. Sa'i ei erasi awei werese ani aporuwe. Serai lu taune werese sa'i papu wi teniseye. Sosu aiwawe a'i meni ape hire ma'e itorairowa ape, lu taune yo seni apou ape umasinamirowa. ");
INSERT INTO sny_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Aiwawe a'i fene meni Lot ne totere! Nowe ape se lu taune werese yo seni apou ape ironamiteye. Lowe werese ayei ahi a'i ene a iroteye. Lowe sa'i meremereye a'i anamiteye. Lowe etiri tamo etenamiteye, lowe etiri tamo au nonenamiteye. Lowe ta'aneyei awei towafi lowe lo yehe sameteye. Lowe wesi towafi lowe lo au ta'aneteye. Stt 18:20; 19:25 ");
INSERT INTO sny_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Sosu nowe ape se meni Lot tani lo mase omo Sodom arunatiyewe fi su, Owane Sitewi lai yehe erasi a'i omo ape sahe eimawe arosai. Serai yehe ape lai lu taune werese, Omo Sodom iroteye ape, yehe tisoro'owe po'uteye. ");
INSERT INTO sny_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Sosu aiwawe a'i ane, meni hire ma'e itorairowa ape, si tame itorairowa su, lu taune werese yo seni luwaru a'i apou ape ironamirowa. ");
INSERT INTO sny_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Nowe ape se, ane hi awei ma'e si tame itorairowa su, meni ta wesi topo lo hire ma'e onurowa ape, le wesi topo lo sahe owe ape wirowata. Ahowa, le etiri werese topo lo owe ape anirowata. Aiwawe a'i meni ta ta'aneyei awei topo lo sahe ta'anerowa su, le wesi topo lo si tame owe ape irowata. Ahowa, le etiri werese topo lo owe ape ani aitirowata. Mt 24:17-18 ");
INSERT INTO sny_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Fene meni Lot lo tani ne tote tawesire. Lot lo tani yo seni luwaru a'i siye wisereyeteye. Serai le omo Sodom ma'e si tame atati siyeyei ne toteye. Sosu Owane Sitewi lai menitani ape aine tera'eye. ");
INSERT INTO sny_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Serai ane fene ma'e apou eisiya. Meni ta hepene topo lo anite tawesyei ne totesiya su, sosu marepi topo lo umasinamirowa. Hepene topo lo le arunatirowa. Sosu aiwawe a'i meni ta marepi ano tote umasinamirowa su, sosu le temeniyerowa su, hepene topo lo mi mi pasi pasi ironamirowa. Lu 9:24 ");
INSERT INTO sny_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Peri ano wanure! Lu hesi lai wari ta'i sahe howeiteyei su, Owane Sitewi lai meni ta'i a'i hene wirowa. Sosu meni tere'e ape, Owane Sitewi lai saro ahe arunatirowa. ");
INSERT INTO sny_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Taune hesi nau taineteyei su, Owane Sitewi lai menitani ta'i a'i hene ani wirowa. Sosu menitani tere'e Owane Sitewi lai arunatirowa.” ");
INSERT INTO sny_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","{“Lu hesi ta'aneyei awei sahe ta'aneteyei su, Owane Sitewi lai meni ta'i a'i hene ani wirowa. Sosu meni tere'e ape, Owane Sitewi lai arunatirowa.”} ");
INSERT INTO sny_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Sosu Jisas peri au te'e tepa'asiye su, lu disaipel lo le ma'e itiya'u te'e toweriye, “Etiri ape mo henerairowa su, eiwerou ma'e henerairowa awere?” Sosu Jisas lowe ma'e itiya'u eiye, “Lu taune tomu ne'ese temeniyeyei su, irowe yaruwapi tomu ne'ese yaru ape sahe tepi tahe lowe lo ayei ne ta'uweraiyei. Fene werese yaru ape amerame a'i siyerowa.” ");
INSERT INTO sny_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Sosu a'i pe Jisas lu disaipel lo ma'e peri anowe ta au te'eye. Le lowe ma'e apou au te'eye, “Fene mi mi werese Owane Sitewi ma'e fa te'e towerinamire! Fene Owane Sitewi ma'e te'e toweriyei su, fene marepi orese a'i owe ape totere. Owane Sitewi lai peri fene lo wanuwei.” Kl 4:2; 1 Te 5:17 ");
INSERT INTO sny_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Sosu le peri anowe ape apou au te'eteye, “Omo ta sahe meni owane peri wanu eti siye meni onuteye. Le Owane Sitewi lo marepi umasi ta'ame. Aiwawe a'i le lu taune werese ne marepi erasi a'i tote ta'ame. ");
INSERT INTO sny_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Omo ape sahe weiname tani iroteye. Menitani ape lai meni owane ape mi mi werese ei toweriyei ne fai. ‘Ne ane ani pati ferafereire! Meni ta ane ma'e au luwaruwenamisiya. Serai ne yo seni ape lo au fareraiyere!’ ");
INSERT INTO sny_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Meni owane peri ape wanuwe su, le peri lo ape umasi ta'ame. Sosu mi mi werese menitani ape meni owane ei toweriyei ne fai. Meni owane ape marepi erasi a'i toteye. ‘Weiya! Ane Owane Sitewi lo marepi tote umasi ta'ame. Aiwawe a'i ane lu taune werese ne marepi erasi a'i tote ta'ame. ");
INSERT INTO sny_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Menitani ape lai marepi orese a'i ane ma'e aunamisiya. Menitani ape mi mi werese ane ma'e aiyeyei su, le marepi ano au luwaruweyei. Serai ane menitani ape au pati ta'aneyei su, le ane ma'e si tame aiyerowata.’” ");
INSERT INTO sny_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Sosu meni owane wiyeme apou eiye, “Peri wanu eti siye meni owane luwaru a'i ape ne, fene peri ape lo wanu etire! ");
INSERT INTO sny_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Meni owane lai menitani ape lo peri wanuwe su, fene Owane Sitewi ne erasi a'i totere! Aiwawe a'i lu taune werese, Owane Sitewi lo marepi umassiya ape, lowe Owane Sitewi ma'e mi mi pasi pasi werese peri lowe lo te'e towerinamiyei. Le a'i lai peri lowe lo wanuwei. Sosu le marepi lowe lo au hese etiyei. Le peri lo lowe ma'e witane a'i se itiya'u au te'eyei. ");
INSERT INTO sny_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ane fene ma'e au te'esiya. Lu tamo Owane Sitewi lo lu feni ma'e marepi orese a'i au irowei su, Owane Sitewi lai witane a'i se marepi orese a'i lowe lo au fareraiyeyei. Ahowa, ane meni hire ma'e fai ape, si tame aiyerowa su, lu taune ta'i ta'i a'i Owane Sitewi ne tote tawesiyei awere? Piyete awere?” ");
INSERT INTO sny_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Sosu a'i pe Jisas lu tamo ma'e peri anowe ta au te'eye. Lowe yo seni towafi lowe lo ei ani aroweteye. Lowe yo seni towafi lowe lo aseyaro toteye. Lowe lu taune tere'e werese ne ani araroteye. ");
INSERT INTO sny_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Sosu Jisas peri anowe lowe ma'e au te'eye. “Lu hesi Owane Sitewi lo wesi tutawe ma'e wiye. Lowesi Owane Sitewi ma'e au te'eyei ne toteye. Meni Farisi ta Moses lo yo peri werese umasinamiteye. Meni tere'e takis ma'aru ani siye meni. Lu taune werese meni apou ape toteye. Takis ma'aru ani siye lu werese lu luwaru a'i tene. ");
INSERT INTO sny_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Meni Farisi ape Owane Sitewi lo wesi ponei sahe teiteye. Le peri morose erasi a'i apou eiye, ‘Owane Sitewi ane ne ma'e au te'e wisereyesiya. Ane meni wisere a'i ne. Yo seni ano lu taune werese hi ani ararowe. Ane areareyei meni wou ta'ama. Ane etiri werese au hese etinamiye. Ane taune tafa'e yo seni luwaru a'i iro ta'ame. Ane takis ma'aru ani siye meni ape aiwawe wou ta'ama. ");
INSERT INTO sny_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ane nowe hesi a'i se ayei werese siyenamisiya. Ane ma'aru aniye su, ane ma'aru tewi a'i ne ma'e aunamiye.’ Ais 58:2-3; Mt 23:23 ");
INSERT INTO sny_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ahowa, meni tere'e ape, takis ma'aru ani siye meni, le Owane Sitewi lo wesi tutawe oweriye ma'e teiteye. Le nihe topo lo hi ma'e siyeteye. Le ereti neme tepi pi se tomuwe. Le Owane Sitewi ma'e apou au te'eye, ‘Owane Sitewi, ane yo seni luwaru a'i ironamisiya. Ne ane ma'e au ferafereire!’ Sng 51:1 ");
INSERT INTO sny_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ane fene ma'e te'esiya. Meni ape Owane Sitewi lo wesi arunati su, Owane Sitewi lai yo seni luwaru werese lo au sasari pamoweye. Owane Sitewi lo nihe se, meni ape wara'i a'i henerai. Meni tere'e ape Owane Sitewi lo nihe se yo seni luwaru a'i ironamitorowa. Lu taune werese iyape towafi lowe lo ei ani aroweyei su, Owane Sitewi lai lowe hi ani ararorowa. Lu taune werese marepi towafi lowe lo hi ani ararorowa su, Owane Sitewi lai lowe ne ei ani arowerowa.” Mt 23:12 ");
INSERT INTO sny_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Sosu a'i pe Jisas peri anowe au te'e tepa'asiye su, lu taune tomu ne'ese eimane oso lowe lo Jisas ma'e hene aitai. Lowe Jisas ma'e eimane ereti lo hetesiyeyei ne hene aitai. Jisas lowe ma'e ereti se hetesiye su, le eimane lowe lo ma'e au wisereyeteye. Ahowa, Jisas lo lu disaipel lowe, eimane lowe lo hene aitai ape, siyeye su, lowe ai marepi se tai mai Jisas ma'e aiyeyei ne einamiye. Lowe apou eiye, “Fene werese eimane werese fene lo Jisas ma'e owe ape hene aitai.” ");
INSERT INTO sny_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ahowa, Jisas eimane werese ei aniye. Le mai tai lowe lo ma'e eiye, “Fene fara'u eimane fene lo heneta. Fene lowe aiyeyei ne owe ape einamire! Owane Sitewi lo marepi aiwawe a'i ne. Nowe ape se Owane Sitewi lai lu taune au noweinoweirowa ape, le lu taune ma'e eimane eito eite wou a'i aurowa. ");
INSERT INTO sny_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Peri ano wiyeme a'i ne. Wanure! Omo hire ma'e Owane Sitewi lai lu taune au noweinoweirowa ape, fene omo lo ma'e wiyei ne totesiya su, fene eimane wou a'i fu heneraire. Fene marepi tote tawesiyei fene lo eimane wou ta'ame su, fene omo hire ma'e wirowata.” Mt 18:3 ");
INSERT INTO sny_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Sosu a'i pe Jisas eimane werese ereti se hetesiye tepa'asiye su, awei meni owane Jisas ma'e peri ta ei toweriyei ne henerai. Le Jisas ma'e apou ei toweriye, “Meni owane, ne wisere a'i ne! Ane marepi hepene he'i a'i mi mi pasi pasi aniyei ne totesiya. Ane piye wiyawi marepi hepene he'i a'i aniyei ne ta'aneyei awere?” Lu 10:25 ");
INSERT INTO sny_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Sosu Jisas le ma'e itiya'u eiye, “Ne piyene apou eiye awere? ‘Ne meni wisere a'i ne.’ Lu taune werese yo seni luwaru a'i ironamisiya. Owane Sitewi ta'i a'i le wisere a'i ne. ");
INSERT INTO sny_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ne Moses lo yo peri so'oruwesiya awere? ‘Ne taune tafa'e yo seni luwaru a'i owe ape irore! Ne meni ta owe ape aine tera'ere! Ne etiri tamo owe ape ta'arei anire! Ne lu tere'e tamo ne peri wawero owe ape au te'ere. Ne tai mai no marepi erasi a'i totenamite!’” ");
INSERT INTO sny_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Sosu meni owane lai Jisas ma'e itiya'u eiye, “Ei, ane mi mi pasi pasi weriyei yo seni werese ape mo wiyeme a'i umasiteye. Ane meni eime oso a'i su, ane yo seni apou ape mo umasiteye.” ");
INSERT INTO sny_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Sosu Jisas peri ape wanuwe su, le le ma'e eiye, “Ne etiri ta'i a'i po'uteye. Ne etiri werese no au hese ete ererowawe, lu taune werese, ma'aru ariye ape, nonetire! Etiri werese no nonetiyei su, ne ane mo'o umasite! Serai ne omo hire ma'e etiri tomu ne'ese ani ironamirowa.” ");
INSERT INTO sny_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ahowa, meni owane lai Jisas lo peri wanuwe su, le marepi orese a'i teriteye. Piyene awere? Le etiri, ma'aru tomu ne'ese iroteye. ");
INSERT INTO sny_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Sosu Jisas le ma'e siye etiye, apou eiye, “Lu taune, etiri ma'aru tomu ne'ese irosiya ape, lowe Owane Sitewi lo omo ma'e wirowata. Etiri kairefi a'i ne. Lowe etiri towafi lowe lo ne erasi a'i toteyei su, lowe Owane Sitewi lo omo ma'e wirowata. ");
INSERT INTO sny_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Peri anowe ape ne totere! Fene fe kamel ni'ari lo yo papu wafei se ani ni'ariye totesiye su, fene wiyawi erasi a'i tohoteyei. Ni'ari lo yo oso a'i ne. Fe kamel erasi wiyeme a'i ne. Fe kamel lai ipari tahe lo ni'ari lo yo wirowata. Aiwawe a'i lu tamo, etiri, ma'aru tomu ne'ese irosiya ape, lowe Owane Sitewi lo omo ma'e wirowata.” ");
INSERT INTO sny_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Sosu lu taune tamo Jisas lo peri wanuwe su, lowe le ma'e apou te'e toweriye, “Eiwerai Owane Sitewi lo omo hire ma'e fara'u wirowa awere?” ");
INSERT INTO sny_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Sosu Jisas itiya'u eiye, “Fene Owane Sitewi lo omo hire ma'e wiyei ne totesiya su, fene wiyawi wisere a'i owe ape ta'anete. Fene wiyawi wisere a'i ta'aneyei su, fene Owane Sitewi lo omo hire ma'e wirowata. Ahowa, Owane Sitewi a'i lai lu taune fara'u omo lo ma'e hene ani wirowa.” ");
INSERT INTO sny_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Sosu Pita le ma'e eiye, “Wanure! Nomo omo sitewi, sosu etiri werese a'i nomo lo arunatiyewe, ne ma'e mo'o umasitaiteye.” ");
INSERT INTO sny_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Le lowe ma'e itiya'u eiye, “Peri ano wiyeme a'i ne. Wanure! Lu taune tamo wesi towafi lowe lo, tani towafi lowe lo, metare tamo, tai mai towafi lowe lo, eimane werese arunatiyewe, sosu Owane Sitewi lo wiyawi ta'aneyei ne fi su, Owane Sitewi lai nowe pereye ape se lowe ma'e etiri tomu ne'ese itiya'u auwei. Sosu aiwawe a'i le a'i lai nowe ye'ewi su lowe ma'e marepi hepene he'i a'i aurowa. Serai lowe Owane Sitewi mase mi mi pasi pasi tei ironamitorowa.” ");
INSERT INTO sny_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Sosu a'i pe Jisas peri ape te'e tepa'asiye su, le lu disaipel werese lo pani feni eiro ma'e heneti. Sosu le lowe ma'e eiye, “Peri ano wanure! Nomo omo Jerusalem ma'e yaneyei. Tu naifa weriyei Owane Sitewi lo peri au te'e siye lu tamo lai, meni hire ma'e itorai ape ne, apou leseye. Lu 24:44 ");
INSERT INTO sny_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Lowe apou leseye, ‘Lu tamo lai meni ape hire ma'e itoraiyei ape, lu tewi tere'e ma'e henetiyei. Lowe lai meni ape ma'e te'e naruwei. Lowe tahe lo au luwaruweyei. Sosu lowe le ma'e pisa'i sine'iyei.’ Peri werese lowe lo, lowe tu naifa weriyei leseye ape, etiri werese ape ne, wiyeme a'i henerairowa. Lu 9:22,44 ");
INSERT INTO sny_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Lowe wafei se tahe lo sahe aineyei. Lowe tahe lo aineyei su, lowe lai le nowe mo'o su aine tera'eyei. Meni ape temeniyeyei su, lowe tapiye fisiye yo sahe tahe pa'are lo fu arowe. Sosu nowe hesi heta se Owane Sitewi lai meni ape si tame ta'ane norohuwe sineyei.’ Peri ape Owane Sitewi lo peri au te'e siye lu tamo apou leseye.” ");
INSERT INTO sny_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Sosu lu disaipel ape mo lo peri ape wanuwe su, lowe marepi sitewi so'oru ta'ama. Peri ape lo marepi sitewi ne Owane Sitewi lai lowe ma'e ani fu fareyareye. Ahowa, etiri werese ape ne, lowe lai so'oru ta'ama. Mk 9:32 ");
INSERT INTO sny_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Sosu a'i pe lowe omo Jerusalem ma'e yaneyei ne toteye. Sosu lowe omo Jeriko atahe ma'e henerai su, meni ta nihe pokoweyei se yo mai tewiye sahe onuteye. Le lu taune werese ma'e ma'aru ei aniteye. ");
INSERT INTO sny_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Meni ape yo mai tewiye sahe onuteye ape, le lu taune lo peri no'u erasi a'i wanu aniye. Serai le peri no'u ape ne ei toweriye. ");
INSERT INTO sny_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Lu tamo le ma'e itiya'u eiye, “Meni ape, Jisas, omo Nasaret ma'e fai ape, le nomo awera'iyenatiyei.” ");
INSERT INTO sny_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Meni ape peri lowe lo wanuwe su, le peri erasi apou uteye, “Jisas, ne Devit lo meni eime. Ne ane ne au ferafereire!” ");
INSERT INTO sny_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Lu tamo Jisas mase aiyeteye ape mo, lowe meni ape lo peri einamiyei ne toteye. Lowe le ma'e apou eiye, “Peri titanere!” Ahowa, meni ape peri erasi a'i tame uteye, “Devit lo meni eime, ne ane ne au ferafereire!” ");
INSERT INTO sny_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Sosu Jisas peri ape wanuwe su, le saro a'i teiteye. Le meni ape ei aniye. Lowe meni ape Jisas ma'e henetai su, le le ma'e apou ei toweriye, ");
INSERT INTO sny_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ane ne ma'e piye au irowei awere?” Sosu meni ape itiya'u eiye, “Meni owane, ane etiri werese siyereme.” ");
INSERT INTO sny_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Sosu Jisas le ma'e itiya'u eiye, “Siyere! Ane nihe no au ta'ane petaneye. Tote tawesiyei no lai nihe no au ta'ane petaneye!” ");
INSERT INTO sny_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Jisas peri te'e tepa'asiye su, pereye a'i meni ape etiri werese amerame a'i se tame siyeye. Le Jisas mo'o umasiteye. Le Owane Sitewi ma'e au te'e wisereyeteye. Lu taune werese meni ape siyeye su, lowe aiwawe a'i Owane Sitewi ma'e au te'e wisereyeye. ");
INSERT INTO sny_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Sosu a'i pe Jisas lu disaipel lo mase omo Jeriko ma'e wiye. Lowe omo ape sahe uweiteye su, lu taune tomu ne'ese Jisas mo'o umasiteye. ");
INSERT INTO sny_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Omo ape sahe meni ta, iyape Sakius, iroteye. Meni ape takis ma'aru ani siye meni owane. Meni ape ma'aru tomu ne'ese iroteye. ");
INSERT INTO sny_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Jisas yo mai sahe iteye su, meni ape Jisas siyeyei ne totesiya. Le apou toteye, “Meni ape Jisas, eiwerai awere?” Ahowa, le Jisas siyerowata. Lu taune tomu ne'ese le tei tawesiteye. Le meni te'e a'i ne. ");
INSERT INTO sny_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Sosu le Jisas siye ta'ame su, le soro ma'e iteroti iteye. Le me sesi hire ma'e Jisas siyeyei ne wiye. Jisas yo mai ape ma'e aiyeteye. ");
INSERT INTO sny_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Sosu Jisas me sesi ma'e henerai su, le me ape hire ma'e aute siyeye. Le le ma'e apou eiye, “Sakius, ne witane a'i itora. Ane wesi no ma'e ne mase aiwawe iroteyei ne iyei.” ");
INSERT INTO sny_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Le Jisas lo peri wanuwe su, le me ape witane a'i itorai. Le Jisas eriteyewe, wesi lo ma'e heneti. ");
INSERT INTO sny_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Lu taune tamo lai Jisas meni ape mase siyesawi su, lowe ai marepi toteteye. Lowe apou toteye. “Le meni luwaru a'i lo wesi ma'e fi. Yo seni luwaru a'i ne.” Lu 15:2 ");
INSERT INTO sny_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Sosu Sakius peri lowe lo wanuwe su, le sine teiyewe, Jisas ma'e eiye, “Meni Owane, weiya! Wanure! Etiri werese ano ne, ane tewi erasi a'i lu taune ma'aru etiri ariye a'i ape mo aurowa. Ane lu taune tamo ma'aru ta'i areareye su, ane lowe ma'e etiri ma'aru hesiyo hesiyo si itiya'u tame auwei.” Kis 22:1; Nam 5:6-7 ");
INSERT INTO sny_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Sosu Jisas le ma'e eiye, “Wanure! Pereye Owane Sitewi lai meni ape marepi hepene he'i a'i auwe. Meni ape sosu lu tewi werese lo, wesi sahe irosiya ape, Owane Sitewi lai lowe ma'e marepi hepene he'i auwe. Meni ape Abraham lo tote tawesiyei aiwawe a'i ne. Ap 16:31; Lu 13:16 ");
INSERT INTO sny_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ane, meni hire ma'e itorai ape, lu taune werese yo seni luwaru a'i ironamisiya ape, ane lai lowe ne siye nehiyei ne fai. Ane lowe siyeyei su, ane yo seni luwaru a'i lowe lo ani pamoweyei. Sosu ane lowe ma'e marepi hepene he'i a'i aurowa.” Lu 15:4; Jo 3:17; 1 Ti 1:15 ");
INSERT INTO sny_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Sosu a'i pe lu taune werese Jisas lo peri wanuwe su, Jisas lowe werese mase omo Jerusalem atahe a'i teiteye. Lu taune tomu ne'ese Jisas ne apou toteye, Jisas omo Jerusalem papu wiyei su, le meni owane wiyeme tutawe heneraiyei. Sosu le Owane Sitewi lo omo pani werese au noweinoweiyei. Ahowa, Jisas lowe ma'e peri anowe ta au te'eye. ");
INSERT INTO sny_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Le apou au te'eye, “Meni owane ta pani eyeri ma'e meni owane tutawe a'i heneraiyei ne fi. Meni ape meni owane tutawe a'i henerairowa su, le omo sitewi lo ma'e lu tamo au noweinoweirowa. ");
INSERT INTO sny_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Le etiri werese ta'uweye su, le wiyawi yahowa'i a'i ta'ane siye lu ereti feni hesi (10) ei aniye. Sosu le lowe ma'e eiye, ‘Ane fene ta'i ta'i a'i ma'aru meni ta werese (20) auwei. Fene ma'aru meni ta werese ape se wiyawi erasi a'i au ta'anere. Serai ane si tame aiyeyei su, fene ma'aru tomu ne'ese werese a'i ane ma'e itiya'u aure.’ ");
INSERT INTO sny_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ahowa, lu tamo meni owane ape ne ai marepi totenamisiya. Serai lowe lu tamo pani eyeri ma'e eimawesawi. Lowe pani ape lo meni owane ma'e apou eiye, ‘Meni ape luwaru a'i ne. Le omo pani nomo lo owe ape fu noweinoweire. Ne meni owane tutawe lo iyape le ma'e owe ape aure.’ ");
INSERT INTO sny_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Sosu meni ape meni owane tutawe henerai tepa'asiye su, le omo pani lo si tame fai. Si tame fai su, le wiyawi yahowa'i a'i ta'ane siye lu, lowe ma'e ma'aru auwe ape, ei aniye. Le lowe ei aniye su, le lowe ma'e apou ei toweriye, ‘Ane fene ma'e ma'aru meni ta werese (20) auwe su, fene piye wiyawi ta'aneteye awere? Ma'aru eiwerou a'i si aitai awere?’ ");
INSERT INTO sny_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Meni tutawe meni owane lo ma'e henerai su, le le ma'e eiye, ‘Ma'aru meni ta werese no se ane wiyawi erasi a'i ta'aneye. Serai ane ma'aru lu hesi werese (40) ne ma'e si tame aitaisiya.’ ");
INSERT INTO sny_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Sosu owane le ma'e eiye, ‘Wisere a'i ne. Ne wiyawi yahowa'i a'i ta'ane siye meni wisere a'i ne. Ne etiri oso a'i ape au noweinoweiye su, serai ane ne ma'e omo ereti feni hesi werese ape (10) noweinoweiyei ne au ariariyerowa.’ Lu 16:10 ");
INSERT INTO sny_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Sosu meni to'uresi meni owane lo ma'e fai. Le le ma'e apou eiye, ‘Wanure! Ane ma'aru meni ta werese (20) no se wiyawi erasi a'i ta'aneteye. Serai ane ma'aru ereti feni werese (5) ne ma'e si tame aitaisiya.’ ");
INSERT INTO sny_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Sosu owane wiyawi yahowa'i a'i ani siye meni ma'e eiye, ‘Wiyeme a'i ne. Ane omo ereti feni werese ne ma'e auwei. Ne lu taune omo ape mo sahe au noweinoweire.’ ");
INSERT INTO sny_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Sosu wiyawi yahowa'i a'i ani siye meni naite'e meni owane ma'e fai. Sosu le le ma'e eiye, ‘Meni Owane, siyere! Ane ma'aru meni ta werese no si tame aitai. Ane ma'aru meni ta werese (20) no hamau sahe ti tawesi asiteye. Sosu ane awei yo ta horuseyewe, sosu ma'aru no yo papu fu fareyareye. ");
INSERT INTO sny_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ane ne ne atoweiye a'i ne. Ne meni kairefi a'i ne. Ne wiyawi erasi ta'anerowata. Lu tere'e wiyawi no ta'aneyei su, ne etiri lowe lo aniteye. Lu tere'e tamo awei sahe kewi yehe sameyei su, ne kewi so werese lowe lo aniyei.’ ");
INSERT INTO sny_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Sosu owane le ma'e itiya'u eiye, ‘Ane peri topo lo se yo seni luwaru a'i no au hese etiyei. Ne wiyawi yahowa'i a'i siye meni luwaru a'i ne. Ne etiri ape so'oruwesiya awere? Lu tere'e wiyawi aniyei su, ane etiri lowe lo aniteyei awere? Aiwawe a'i, lu tere'e awei sahe kewi yehe sameyei su, ane kewi so werese lowe lo aniyei awere? ");
INSERT INTO sny_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ne ane ne atoweiyeye su, ne piyene ma'aru ano ne ma'aru wesi sahe fu ta'ame awere? Serai ane si tame aiyeyei su, ane ma'aru meni ta werese sosu ma'aru tere'e tamo aniyei.’ ");
INSERT INTO sny_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Sosu le lu tamo, saro a'i teiteye ape, le lowe ma'e eiye, ‘Fene ma'aru meni ta werese ano anire. Sosu fene meni ape ma'e ma'aru lu hesi werese ereti feni hesi (30) werese irosiya ape aure.’ ");
INSERT INTO sny_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Lowe meni owane ma'e apou itiya'u eiye. ‘Weiya, meni ape ma'aru lu hesi werese ereti feni hesi iro tepa'asiye. Ne piyene le ma'e auwei awere?’ ");
INSERT INTO sny_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ane fene ma'e eisiya, Wanure! Meni ta etiri ne'ese irosiya su, ane etiri tere'e tamo le ma'e tame aurowa. Ahowa, meni ta etiri irote ta'ame su, etiri oso lo irosiya ape, ane tamo etiri oso ape ani ta'ane sasari arosawirowa. Mt 13:12; Lu 8:18 ");
INSERT INTO sny_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Serai ane lu tewi tere'e ne au totesiya, lowe ane ne ai marepi erasi a'i totenamiteye. Lowe yo ano, meni owane wiyeme heneraiyei ne einamitereme. Ahowa, ane meni owane tutawe a'i henerai tepa'asiye. Serai fene lu tewi ape mo ane ma'e heneta. Fene lowe werese nihe ano se aine tera'ere!” ");
INSERT INTO sny_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Sosu a'i pe Jisas peri anowe au te'e tepa'asiye su, le lu disaipel lo mase omo Jerusalem ma'e yaneyei ne toteye. ");
INSERT INTO sny_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Lowe omo nepawe hesi a'i atahe ape sahe heneri. Omo hesi ape lo iyape omo Betfage, sosu omo Betani. Omo hesi ape omo iyape me Oliv atahe sahe iroteye. Jisas lu hesi omo Betani ma'e eimawesawi. ");
INSERT INTO sny_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Sosu le lowesi ma'e eiye, “Fenesi omo yaro ape ma'e ire. Fenesi omo ape wiyei su, fenesi fe donki yene ta wesi ma'e wafei mino se ti tawesiteyei ape, siyeriyei. Fe donki ape owe meni ta lai me'iyeni sahe onu ta'ame. Fenesi fe donki ape siyeyei su, fenesi wafei mino lo ape ani eraure. Fe donki ape ane ma'e heneta. ");
INSERT INTO sny_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Meni ta fenesi fe donki ape ne apou ei toweriyei su, ‘Fenesi piyene fe donki lo wafei mino ani erau awere?’ Serai fenesi le ma'e itiya'u te'ere, ‘Meni Owane notosi lo fe donki lo me'iyeni sahe onutiyei ne totesiya.’” ");
INSERT INTO sny_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Sosu lu hesi ape omo Betani ma'e fe donki henetaiyei ne fi. Lowe omo ape wiye su, lowe fe donki wesi ma'e wafei mino se tope'eni teiteye ape siyeye. Meni Owane lowesi lo etiri ape ne aiwawe a'i te'eye. ");
INSERT INTO sny_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Sosu lowesi fe donki lo wafei mino ani erauwe su, fe donki lo lu owane lai lowesi ma'e apou ei towerirai, “Fenesi piyene fe donki nomo lo wafei mino se ani erau awere?” ");
INSERT INTO sny_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Sosu lowesi lowe ma'e itiya'u eiye, “Meni Owane notosi lo fe donki fene lo me'iyeni sahe onutiyei ne totesiya.” Sosu lowe apou eiye, “Fara'u, henetire!” ");
INSERT INTO sny_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Sosu lowesi fe donki ape Jisas ma'e henetai. Lowe ipari tahe lowe lo fe donki lo me'iyeni hire fuwe. Sosu Jisas fe donki lo me'iyeni hire onuti. ");
INSERT INTO sny_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jisas fe donki lo me'iyeni hire onuwe su, le omo Jerusalem ma'e yaneyei ne toteye. Yo mai sahe iteye su, lu disaipel lo ipari tahe lowe lo yo mai sahe futeye. ");
INSERT INTO sny_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Sosu Jisas Omo Oliv itorai su, lu feni werese werese a'i yo tewiye sahe ta'uwerai. Lowe werese Owane Sitewi ma'e peri erasi uteye, “Nomo Owane Sitewi wiyeme ne au te'e wisereyesiya. Nomo wiyawi erasi a'i lo siyeteye. Serai nomo Owane Sitewi ma'e au te'e wisereyesiya. ");
INSERT INTO sny_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Owane Sitewi wiyeme lai meni owane hi ma'e eimawesai. Nomo le ma'e au te'e wisereye nine'isiya. Owane Sitewi lo marepi momotei a'i nomo ma'e itorai. Nomo meni owane lo iyape ei ani aroweyei.” ");
INSERT INTO sny_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Sosu lu Farisi tamo lu taune lo peri wanuwe su, lowe Jisas ma'e eiye, “Ei, Meni Owane, ne lu feni werese no peri einamire.” ");
INSERT INTO sny_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Sosu le lowe ma'e itiya'u eiye, “Ane peri ta fene ma'e au te'esiya. Wanure! Lu feni ano peri se au te'e ta'ame su, tapiye werese yo sahe irosiya ape, lowe Owane Sitewi ma'e peri erasi a'i au te'e wisereyeyei.” ");
INSERT INTO sny_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Sosu a'i pe le omo Jerusalem ma'e ataheye heneri. Le omo ape siyeye su, le omo ape ne luwei erasi ewite uteye. ");
INSERT INTO sny_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Le lu taune, omo Jerusalem sahe iroteye ape ne, apou eiye, “Etiri ape fene ma'e marepi momotei a'i auwei ape, fene werese etiri ape ne ani so'oru ta'ama. Ahowa, pereye nowe eite se Owane Sitewi lai etiri ape ne nihe fene lo se fareyareye. ");
INSERT INTO sny_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Nowe me'iye su, ai lu tamo lai fene erasi aine tera'eyei ne toterowa. Lowe tapiye fisahe pite a'i omo ape sahe yoseti ta'ane ti tawesirowa. Lowe lu taune werese, papu irorowa ape, titairu tawesiyei ne toteye. Fene nowe ma'e itero henerowata. ");
INSERT INTO sny_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Lowe fene noweripi aine tera'eyei ne toterowa. Lowe wesi werese fene lo aine towesi tapetirowa. Wesi aine towesi tapetirowa su, wesi tapiye werese ani fiyarisawirowa. Piyene etiri werese fene ma'e henerairowa awere? Ane lai fene ma'e ferafereiyei ne itorai. Ahowa, serai fene werese ane ne me'iyeni ma'e atati arunati. Fene marepi luwaru a'i towafi fene lo umasinamiteye.” Lu 21:6 ");
INSERT INTO sny_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jisas omo Jerusalem ne luwei tepa'asiye su, le omo Jerusalem papu wiye. Le Owane Sitewi lo wesi tutawe papu wiye. Owane Sitewi lo wesi tutawe papu wiye su, le lu tomu ne'ese, etiri eteye ape, siyeye. Le ai marepi erasi toteye su, le metei werese lowe lo ani teroso fiyarisawi. ");
INSERT INTO sny_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Le lowe ma'e apou uteye, “Wanure! Tu naifa weriyei meni ta apou leseye. ‘Wesi ano sahe fene lai Owane Sitewi ne au te'e wisereyesiya.’ Ahowa, fene Owane Sitewi lo wesi ape ta'arei wesi wou au iro henerai ne.” ");
INSERT INTO sny_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Sosu a'i pe le lu werese Owane Sitewi lo wesi tutawe sahe au sasari tepa'asiye su, le lu taune werese Owane Sitewi lo peri au te'e fiyariye. Le mi mi werese Owane Sitewi lo wesi sahe au atuatuteye. Sosu au heseyei lu Owane werese, sosu Owane Sitewi lo peri au lese siye lu, sosu awei lo lu owane, lowe werese Jisas aine tera'eyei ne toteye. Lu 21:37 ");
INSERT INTO sny_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ahowa, lu taune werese Jisas lo peri ne wanu wisereyeteye. Serai au heseyei lu owane, Owane Sitewi lo peri au lese siye lu tamo, lowe Jisas lo yo seni siye etirowata. Lowe le aine tera'eyei ne totesiya. Ahowa, lowe yo ape siye so'oruwerowata. ");
INSERT INTO sny_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Sosu a'i pe Jisas lu taune tomu ne'ese ma'e Owane Sitewi lo wesi tutawe sahe Owane Sitewi lo peri heneruwe wisere a'i ne au te'e atuatuteye su, lu owane tamo le ma'e te'e toweriyei ne fai. Lu ape mo au heseyei lu owane tamo, Owane Sitewi lo peri au lese siye lu tamo, sosu ya'ariyei lu owane, lowe Jisas ma'e apou te'e toweriye. ");
INSERT INTO sny_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“Ne peri nomo lo pei itiya'u te'ere. Eiwerai ne irowei ne eimawesai awere? Wiyawi erasi, ne irowe ape ne, eiwerai kairefi ape ne ma'e auwe awere?” ");
INSERT INTO sny_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Sosu Jisas lowe ma'e itiya'u eiye, “Ane peri ta fene ma'e ei toweriyei. Fene peri ano itiya'u au te'eyei su, ane fara'u peri no itiya'u au te'eyei. ");
INSERT INTO sny_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Fene peri ano itiya'u au te'ere. Jon lu taune sa'i se au huwe su, sa'i se huwe ape, Owane Sitewi lai ausai awere? Lu tamo ausai awere?” ");
INSERT INTO sny_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Lowe peri ape wanuwe su, lowe ta'u te'e tiyatiteye. Lowe apou toteye, “Nomo itiya'u apou au te'eyei su, Owane Sitewi lai Jon lo sa'i se au huwei ape ausai. Serai le nomo itiya'u eiyei, ‘Fene piyene Jon lo peri wanu umasi ta'ame awere?’ ");
INSERT INTO sny_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Sosu nomo itiya'u apou au te'eyei su, ‘Awei lu owane lai Jon lo sa'i se au huwei ape ausai.’ Nomo peri ape au te'eyei su, lu taune werese nomo ma'e ai marepi toteye. Lowe nomo ma'e tapiye ani fu tera'eyei. Lu taune werese apou a'i totesiya, Owane Sitewi lai Jon eimawesai.” ");
INSERT INTO sny_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Sosu lowe Jisas ma'e itiya'u eiye, “Ahowa, nomo so'oru ta'ama. Jon eiwerou ma'e fai awere?” ");
INSERT INTO sny_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Sosu Jisas lowe ma'e eiye, “Ane aiwawe a'i. Wiyawi erasi pefine a'i ano ne, ane irowe ape, ane fene ma'e ei toweriyei fene lo au te'erowata.” ");
INSERT INTO sny_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Sosu Jisas peri ei toweriyei lowe lo au te'e tepa'asiye su, le lu taune ma'e peri anowe ta au te'eye. Le apou eiye, “Meni ta ta'aneyei awei erasi a'i ta'aneye. Sosu le lu tere'e tamo lo ereti se au noweinoweiyei ne auwe. Sosu le lowe ma'e eiye, ‘Me so werese foro'oweyei su, ane si tame aiyerowawe, me so tewi a'i aniyei.’ Sosu meni owane ape pani eyeri ma'e fi. Le mi mi tomu ne'ese pani ape iroteye. Ais 5:1 ");
INSERT INTO sny_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Nowe me'iye su, awei ape sahe me so tomu ne'ese ta'eye. Serai meni owane wiyawi yahowa'i a'i ta'ane siye meni ta me so tewi a'i aniyei ne eimawesawi. Lu ape mo wiyawi yahowa'i a'i ani siye meni siye aniye su, lowe meni ape me au se aineyewe, si tame eimawesawi. Le me so tewi a'i tamo meni owane ma'e si aiti ta'ama. ");
INSERT INTO sny_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Wiyawi yahowa'i a'i ta'ane siye meni, meni owane lo ma'e si tame au te'eri. Serai meni owane wiyawi yahowa'i a'i ta'ane siye meni tere'e ta'aneyei awei lo ma'e eimawesawi. Lu ape mo, awei au noweinoweiteye ape, wiyawi yahowa'i a'i ta'ane siye meni ape siye aniye. Lowe le ma'e tahe lo au luwaruweye. Lowe meni ape me au se aine luwaruweye su, lowe lai le etiri ta ariye a'i se eimawesawi. ");
INSERT INTO sny_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Meni ape meni owane lo ma'e peri ape ne si tame au te'eri. Sosu meni owane wiyawi yahowa'i a'i ani siye meni naite'e lowe ma'e eimawesawi. Lu ape mo meni ape siye aniye su, lowe tahe lo eine se tewiye. Lowe le ta'aneyei awei nowe ma'e ani fu arosawi. ");
INSERT INTO sny_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Awei ape lo meni owane marepi erasi a'i apou toteye. Ane lowe ne piye irowei awere? Ane meni eime ano lowe ma'e eimawesawiyei. Lowe meni eime ano au luwaruwerowata. ");
INSERT INTO sny_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Sosu ta'aneyei awei ape lo meni owane lai meni eime lo lowe ma'e eimawesawi. Sosu meni eime ta'aneyei awei ma'e heneri su, lu ape mo le ne apou toteye. ‘Siyere! Meni owane lo meni eime aiyesiya. Meni owane nomo lo temeniyeyei su, ta'aneyei awei ape meni eime lo ma'e auwei. Weiya! Nomo meni eime ape aine tera'eyei su, sosu ta'aneyei awei ape nomo lo heneraiyei.’ ");
INSERT INTO sny_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Lu tewi ape mo meni eime aniteyewe, ta'aneyei awei nowe ma'e ani fu arosawi. Sosu lowe meni eime aine tera'eye, ta'aneyei awei ape lo meni owane le piye lu tewi ape mo ma'e irowei awere? ");
INSERT INTO sny_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Wanure! Le ta'aneyei awei lo ma'e iyei. Le lu tewi ape mo anite tawesiyewe, lowe werese ma'e aine tera'eyei. Lowe werese aine tera'eyei su, le ta'aneyei awei lo ape lu tewi tere'e ma'e au noweinoweiyei ne auwei.” Lu owane werese peri lo wanuwe su, lowe apou toteye, “Weiya! Le nomo ne au te'eye. Owane Sitewi lai nomo ma'e aine tera'erowata.” Sosu lowe peri erasi uteye, “Ahowa, etiri ape henerairowata!” ");
INSERT INTO sny_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Serai Jisas lowe siye etiyewe, lowe ma'e eiye, “Peri ano eite wanure! Tu naifa weriyei meni ta apou leseye, ‘Wesi ta'ane siye lu ape mo wesi ta'aneye su, lowe me tou ta'i ani fusawi. Nowe me'iye su, me tou ape tutawe henerai. Wesi me tou tutawe wou a'i henerai.’” ");
INSERT INTO sny_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“Lu taune werese tapiye tutawe sahe winetaiyei su, lowe pa'are werese towafi lowe lo towesi fiyariyei. Ahowa, tapiye tutawe lai lu taune ta sahe winetaiyei su, tapiye ape lai lowe aine tapo po'uteyei. Awei peperi wou a'i aine tapoti fiyariyei. Ane a'i lai tapiye ape ne.” Ais 8:14-15 ");
INSERT INTO sny_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Jisas peri anowe ape au te'e tepa'asiye su, au heseyei lu owane, Owane Sitewi lo peri lese siye lu aiwawe a'i, lowe Jisas ne ai marepi erasi toteteye. Lowe peri anowe ape ne apou toteye, “Peri anowe eite nomo ne au te'esiya.” Serai lowe Jisas ereti wafei se ti anite tawesiyei ne toteye. Ahowa, lowe lu taune werese ne atoweiyeye. ");
INSERT INTO sny_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Lowe Jisas ne tote tawesi ta'ame su, lowe Jisas lo yo seni werese siye etiye. Lowe lu tamo Jisas ne siye etiyei ne eimawesawi. Lowe yo seni lowe lo aseyaro areareye. Lowe Jisas lo peri werese siye etiye. Jisas lo peri luwaru a'i awere? Lowe apou toteye, “Jisas peri ta luwaru a'i au te'eyei su, nomo le fara'u awei lo lu owane ma'e henetiyei.” Lu 11:54 ");
INSERT INTO sny_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Sosu lowe Jisas ma'e peri ta te'e toweriyei ne fai. “Meni Owane, peri no wiyeme a'i ne. Sosu ne lu taune ma'e au atuatuwei su, peri no wisere a'i ne. Nomo so'oruwesiya tene! Ne yo hesi se umasi ta'ame. Ahowa, ne Owane Sitewi lo marepi wiyeme a'i se lu taune ma'e au te'e atuatusiya. ");
INSERT INTO sny_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ne peri nomo ma'e itiya'u eire. Nomo awei meni owane tutawe ma'e takis ma'aru ta fara'u auwei awere? Piyete awere?” ");
INSERT INTO sny_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jisas peri lowe lo wanuwe su, le apou toteye, “Lowe ane ne areareyei ne totesiya.” Sosu le lowe ma'e eiye, ");
INSERT INTO sny_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ma'aru tau ane ausa. Siyere! Nihari ape ne, eiwerou lo sato irosiya awere? Piye peri lowe ma'aru tau sahe lesesiya awere?” Lowe itiya'u eiye. “Awei lo meni owane Sisar lo nihari sato irosiya.” ");
INSERT INTO sny_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Sosu le lowe ma'e itiya'u eiye, “Wiyeme! Meni owane Sisar lo etiri werese ne fene le ma'e si tame aure. Sosu aiwawe a'i Owane Sitewi lo etiri werese ne, fene le ma'e si tame aure!” ");
INSERT INTO sny_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Lowe Jisas lo peri wanuwe su, lowe hepene se su ariye. Lowe Jisas ne lu taune werese lo nihe se au arearerowata. Ahowa, lowe peri tere'e ta te'e ta'ame. ");
INSERT INTO sny_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sosu a'i pe Jisas peri te'e tepa'asiye su, au heseyei lu owane tere'e le ma'e te'e toweriyei ne fai. Lu tewi ape mo iyape Sadyusi, marepi lowe lo apou toteye. “Lu taune temeniyeyei su, lowe si tame sineyei ta'ama.” ");
INSERT INTO sny_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Lowe Jisas ma'e apou te'e toweriye, “Meni Owane, tu naifa weriyei, meni Moses apou leseye, ‘Meni ta tani lo naituwe. Lowesi eimane autei ta'ame. Nowe me'iye su, meni ape temeniyeye. Airu temeniyeye su, pa'ise lo tani weiname lo ape pei naiture. Serai lowesi meni eime auteiyei. Ne peri nomo lo wanure! ");
INSERT INTO sny_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Lu nairipi ape ereti feni werese feni hesi a'i (7) iroteye. Airu ape tani lo naituwe. Meni eime autei ta'ame. Sosu Poto temeniyeye. ");
INSERT INTO sny_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Sosu aiwawe pa'ise Pafe lai poto lo tani weiname naituwe. Lowesi meni eime autei ta'ame. Pafe temeniyeye. ");
INSERT INTO sny_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Aiwawe a'i pa'ise Henei lai Pafe lo tani weiname naituwe. Lowesi meni eime autei ta'ame. Henei temeniyeye. Sosu aiwawe a'i pa'ise werese lai menitani weiname naituwe. Menitani ape meni eime autei ta'ame. Nairipi werese temeniyeye. ");
INSERT INTO sny_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Nowe me'iye su menitani weiname aiwawe a'i temeniyeye. ");
INSERT INTO sny_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Nomo ne ma'e te'e towerisiya. Nowe ye'ewi su, Owane Sitewi lai lu taune werese si tame hene ani wiyei su, eiwerai menitani ape naituwei awere? Nairipi werese awei sahe menitani ape naituwe.” ");
INSERT INTO sny_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Sosu Jisas lowe ma'e itiya'u eiye, “Marepi fene lo meremereye a'i ne. Awei sahe lu werese fara'u naituwei. Aiwawe a'i nohuweripi eime taune lowesi lo meni ta se aruwe. ");
INSERT INTO sny_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ahowa, nowe ye'ewi su, Owane Sitewi lai lu taune werese marepi lo umasinamiyei ape, si tame hene aniyei su, lowe werese naituwei ta'ama. Aiwawe a'i taune werese meni ta se aruwei ta'ama. ");
INSERT INTO sny_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Aiwawe a'i lowe werese tame temeniyerowata. Lowe Owane Sitewi lo ipari wara'i a'i wou heneraiyei. Ahowa, lowe werese Owane Sitewi lo eimane henerairowa. Piyene awere? Owane Sitewi lai lowe si tame hene aniyei. ");
INSERT INTO sny_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ei, nowe ye'ewi su Owane Sitewi lai lu taune werese si tame hene aniyei tene! Moses nomo ma'e au te'e atuatu areiyeye. Wanure! Me oso sahe yehe fu etineye ape ne, meni Moses apou leseye, ‘Meni Owane pefine a'i lai Abraham lo Owane Sitewi, Aisak lo Owane Sitewi, Jekop lo Owane Sitewi.’ ");
INSERT INTO sny_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Peri lo ape wiyeme a'i ne. Le a'i lai lu taune werese, temeniyeye ape, lo Owane Sitewi ta'ame. Ahowa! Le a'i lai lu taune werese, marepi hepene irosiya ape, lo Owane Sitewi tene!” ");
INSERT INTO sny_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Sosu Owane Sitewi lo peri lese siye lu tamo le ma'e itiya'u eiye, “Meni Owane, ne peri werese no wiyeme a'i tene!” ");
INSERT INTO sny_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ahowa, lowe werese le ne atoweiye iroteye. Serai lowe peri tere'e ta te'e toweri ta'ame. ");
INSERT INTO sny_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Sosu le lowe ma'e apou ei toweriye, “Lu owane tamo apou te'esiya, ‘Krais Devit lo lu tewi ma'e fai.’ Lowe piyene apou te'esiya awere? Devit tu henerai. Krais nowe mo'o henerai. Serai piyene le Krais lo meni eime awere? ");
INSERT INTO sny_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Owane Devit, tu naifa weriyei one towe sahe apou leseye, ‘Owane Sitewi lai Krais ma'e eiye, Meni owane ano, ne eyate feni ano onura. ");
INSERT INTO sny_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Ane airame werese no lowe no unahi hene ani fuwei. Lowe werese Krais lo kairefi unahi ironamitorowa.’ ");
INSERT INTO sny_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Serai meni owane Devit lai apou au te'eye, ‘Krais meni owane ano ne.’ Le piyene apou te'eye awere?” ");
INSERT INTO sny_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Lu taune werese Jisas lo peri wanuwe su, le lu disaipel lo ma'e apou eiye, ");
INSERT INTO sny_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Owane Sitewi lo peri lese siye lu tewi ape ne, fene lowe ne weiyai! Lowe ipari tahe pitase a'i ani asisiya. Lowe omo pani amerame a'i uweisiya. Lu tamo lowe ne apou eiyei, ‘Lu tewi ape wisere a'i ne.’ Lowe peri lowe lo wanuwe su, lowe iyape towafi lowe lo ei ani aroweyei. Lowe Owane Sitewi lo wesi sahe me tuto'u tutawe onuriyei ne totesiya. Lowe ta'uwe hereiyei ene ateyei su, lowe me tuto'u tutawe onuriyei ne totesiya! Lowe iyape towafi lowe lo ei ani aroweyei. ");
INSERT INTO sny_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Lowe taune weiname lo wesi ma'e wiyei su, lowe weiname areareyewe, etiri werese lo ta'arei aniyei. Lowe Owane Sitewi ma'e au te'eyei su, lowe peri pitase a'i lu taune lo nihe se au te'eyei. Peri werese lowe lo ahi yahowa'i a'i te'esiya. Lu tewi ape Owane Sitewi lai lowe ma'e orese erasi pefine a'i au luwaruweyei.” ");
INSERT INTO sny_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jisas Owane Sitewi lo wesi tutawe sahe au te'e atuatu tepa'asiye su, le lu taune, etiri ma'aru tomu ne'ese iroteye ape, siye aniye. Lowe ma'aru tewi a'i siye feri papu fu loto aroteye. ");
INSERT INTO sny_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Sosu mo'o le menitani weiname ma'aru tau oso hesi a'i siye feri papu fu loto arowei ne siye aniye. ");
INSERT INTO sny_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Jisas menitani weiname siye aniye su, le lu disaipel lo ma'e te'eye, “Peri ano wanure! Menitani weiname ma'aru werese ariye ape, le ma'aru erasi Owane Sitewi ma'e auwe. Le lu taune tere'e werese hi ani ararowe. 2 Ko 8:12 ");
INSERT INTO sny_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Lu taune tere'e werese ma'aru tewi oso po'o siye feri papu fu loto arowe. Lowe ma'aru tomu ne'ese wesi towafi lowe lo iroteye. Ahowa, menitani weiname ape ma'aru werese topo lo ariye. Le ma'aru werese topo lo Owane Sitewi ma'e auwe. Le ma'aru tau oso hesi a'i siye feri papu fu loto arowe su, ma'aru werese topo lo po'uteye. Le ayei ta eterowata.” ");
INSERT INTO sny_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Lu feni tamo Owane Sitewi lo wesi tutawe siye eti etiteye. Lowe tapiye wisere a'i siye etiteye. Lowe tapiye wisere se, leseye ape, siyeteye. Owane Sitewi lo wesi tutawe wisere a'i tene! Lu taune tomu ne'ese tapiye werese Owane Sitewi ma'e auwei ne aitai. Lowe Owane Sitewi lo wesi siyeteye su, Jisas apou eiye, ");
INSERT INTO sny_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Tapiye werese siyere! Nowe ta se heneraiyei su, lu tamo Owane Sitewi lo wesi tapiye werese aine tapeti fiyari arosawirowa. Tapiye werese fiyari po'uterowa.” Lu 19:44 ");
INSERT INTO sny_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Jisas lo lu disaipel le ma'e apou te'e toweriye, “Meni Owane, eiwerou su etiri ape henerairowa awere? Piye etiri tu henerairowa awere? Sosu nomo etiri tutawe siyeyei su, nomo nowe ape atahe a'i siye so'oruwerowa.” ");
INSERT INTO sny_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Le lowe ma'e itiya'u eiye, “Weiyai, lu tomu ne'ese fene areareyei ne toteyei. Lu taune tomu ne'ese iyape ano se aiyerowa. Lowe apou te'e arearerowa, ‘Ane lai meni ape, Owane Sitewi hi awei ma'e eimawe arosai ape ne! Owane Sitewi lai meni ape hi awei ma'e eimawe arosai. Nowe ape se henerai tepa'asiye.’ Peri lowe lo ape wawero ne! Fene peri lowe lo owe ape wanu umasite. ");
INSERT INTO sny_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Nowe me'iye tase, fene ai atuwei lo peri heneruwe wanuwei su, pani tere'e tere'e ai erasi atu tiyatiteyei. Fene atoweiye sawa! Etiri ape mo tu henerairowa. Ahowa, nowe ye'ewi ataheye henerai se ta'ama.” ");
INSERT INTO sny_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Sosu a'i pe Jisas lowe ma'e tame eiye, “Awei pani ta awei pani tere'e ma'e ai atu tiyatirowa. Omo ta omo tere'e ma'e ai atu tiyatirowa. Lu owane ta ai lu werese lo lu owane tere'e ma'e ai atu tiyatirowa. ");
INSERT INTO sny_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Fene auwe erasi tamo auseriye teriteyei. Awei pani tere'e tere'e ayei werese ariye po'uterowa. Lu taune werese lau erasi teriterowa. Lu taune tomu ne'ese u tahe tere'e tere'e ya'oreteyei. Fene etiri luwaru a'i ni'arawe ma'e siyerowa. Sosu fene etiri ape siyerowa su, fene atoweiye erasi a'i irorowa. ");
INSERT INTO sny_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Nowe ape se aiwawe a'i henerairowa. Etiri werese ape mo henerai se ta'ama. Lu ape lai fene, yo ano umasisiya ape, lowe fene wafei se ereti ti tawesirowa. Lowe fene ma'e au luwaruwerowa. Fene fofowei erasi a'i teriterowa. Lowe fene Owane Sitewi lo wesi ma'e etiyei ne henetirowa. Lowe fene kalabus sahe fu arorowa. Fene, peri ano umasinamisiya ape, lowe fene awei lu owane ma'e etiyei ne henetirowa. Lowe fene awei meni owane tutawe ma'e etiyei ne henetirowa. ");
INSERT INTO sny_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Lowe fene awei meni owane ma'e etiyei su, fene lowe ma'e peri ano fa au te'e areiyere. ");
INSERT INTO sny_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Lowe fene etiyei ne toteyei su, fene marepi erasi a'i owe ape totere. Ahowa, fene apou owe ape totere, ‘Lowe ane etiyei su, piye peri ane au te'eyei awere?’ Lu 12:11-12 ");
INSERT INTO sny_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Wanure! Ane a'i lai fene ma'e marepi wisere a'i auwei. Ane lai fene ma'e peri farere a'i au te'eyei. Serai fene fu te'e etiyei lowe lo fara'u itiya'u au te'eyei. Lowe peri fene lo wanuwei su, lowe fene etirowata. Lowe peri fene lo te'e narurowata. Ap 6:10 ");
INSERT INTO sny_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Nowe ape henerairowa su, tai mai fene lo fene awei meni owane ma'e etiyei ne henetiyei. Lu tewi, nairipi fene lo aiwawe a'i ne. Lowe fene etiyei ne. Lowe fene eti tepa'asiyei su, lowe fene tamo aine tera'eyei. Mt 10:21-22 ");
INSERT INTO sny_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Fene, iyape ano umasinamisiya ape, lowe fene ne ai marepi erasi a'i totenamiyei. ");
INSERT INTO sny_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Lowe fene ne ai marepi toteyei su, lowe fene aine tera'eyei ne toteyei. Ahowa, lowe fene aine tera'erowata. ");
INSERT INTO sny_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Nowe luwaru a'i henerairowa su, fene kairefi a'i teinamiyei su, Owane Sitewi lai hepene fene lo ani tepa'asi anirowa. Serai fene mi mi pasi pasi ironamitorowa. ");
INSERT INTO sny_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Nowe me'iye su, ai lu tomu ne'ese omo Jerusalem sahe tei yose tepa'asirowa. Fene ai lu ape mo siyerowa su, fene nowe ye'ewi ape se siye so'oruwerowa. Omo Jerusalem atahe a'i aine tapeti towesi fiyarirowa. ");
INSERT INTO sny_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Lu taune pani Judia sahe iroteyei ape, lowe omo hire ma'e fa itero yane fareyarere. Lu taune omo Jerusalem saro iroteyei ape, lowe omo nowe ma'e iterotiyei. Lu taune, pani tere'e sahe iroteyei ape, lowe omo Jerusalem papu owe ape wire. ");
INSERT INTO sny_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Piyene awere? Etiri luwaru tomu ne'ese omo ape ma'e henerairowa. Tu naifa weriyei, lu tamo etiri ape ne apou leseye. Serai etiri werese ape mo pei henerairowa. Jer 5:29; 46:10; Hos 9:7 ");
INSERT INTO sny_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Nowe ape se Owane Sitewi lo ai marepi lu taune werese ma'e irotorowa. Serai taune werese eime tahe se marepi orese a'i henerairowa. Taune werese eimane mo'u au arowa ape, lowe aiwawe a'i, marepi orese a'i teritenamirowa. Owane Sitewi lai awei pani werese fene lo ma'e au luwaruwerowa. ");
INSERT INTO sny_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Nowe ape se ai lu tomu ne'ese lu taune tamo, omo Jerusalem sahe iroteyei ape, ipari mene'e se aine tera'eyei. Lu tewi tere'e lai lu taune tamo wafei se ti tawesirowa. Sosu pani tere'e tere'e kalabus eyeri ma'e henetirowa. Lu tewi tere'e lowe ma'e hi ani ararorowa. Lowe omo Jerusalem lo lu taune werese mi mi werese au luwaruwerowa. Lowe mi mi ne'ese au luwaruwerowa su, nowe me'iye su, Owane Sitewi lai lowe au sasari fiyari tepa'asirowa. Sng 79:1; KTH 11:2 ");
INSERT INTO sny_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Nowe ape henerairowa su, etiri luwaru a'i tomu ne'ese poweiye, yame, eiwariyemi sahe henerairowa. Lu taune werese awei sahe irorowa ape, lowe etiri ape mo siyerowa su, lowe marepi erasi a'i atoweiyerowa. Lu taune sa'i ei erasi siyerowa su, sosu sa'i ei no'u erasi wanurowa su, lowe eiwerou ma'e atoweiye irowata. Ais 13:10; Ese 32:7; Jol 2:31; KTH 6:12-13 ");
INSERT INTO sny_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Lu werese etiri luwaru a'i ape mo siye anirowa su, lowe marepi taweiru a'i ne. Lowe etiri werese, lowe ma'e henerairowa ape, toterowa su, lowe atoweiye erasi a'i totenamirowa. Lowe nihe lowe lo awetu awetorowa. Lowe awei sahe tahe pere'eyeyei se winetairowa. Etiri werese, hire ma'e irotorowa ape, lowe auseriyerowa. ");
INSERT INTO sny_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Lu taune etiri ape mo siyerowa su, nowe ape se lowe ane meni tu hire ma'e itorai ape, ane ni'arawe mase itoraiyei ape, lowe siyerowa. Ane Owane Sitewi lo kairefiyeyei Owane Sitewi lo mi erasi aiwawe a'i itorairowa. Dan 7:13; Mt 26:64; KTH 1:7 ");
INSERT INTO sny_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Serai fene etiri werese henerairowa ape, siyerowa su, fene nihe fene lo hire ma'e siye arowere. Nowe ataheyerowa su, Owane Sitewi lai fene werese witane a'i hene wirowa.” ");
INSERT INTO sny_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Sosu a'i pe le peri tepa'asiye su, le lu fene lo ma'e peri anowe ta apou au te'eye. “Me owarape siyere, me werese aiwawe a'i siyere. ");
INSERT INTO sny_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Nowe ta se me owarape sahe towe werese winetaiyei. Towe werese winetai tepa'asiyei su, fene etiri ta siye so'oruwesiya. Me nei he'i nowe me'iye su heneraiyei. Fene me nei he'i a'i siyeyei su, fene etiri ta siye so'oruwesiya. Me so ape mo ta'eyei lo nowe ataheyeraiwa. ");
INSERT INTO sny_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Fene totere. Etiri werese awei sahe henerairowa ape fene siye so'oruwerowa su, fene aiwawe a'i Owane Sitewi lo nowe ape ataheyewa. ");
INSERT INTO sny_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ane peri wiyeme a'i fene ma'e au te'esiya. Wanure! Lu tewi werese awei sahe irorowa ape, lowe werese etiri werese ape mo siyerowa. Lu taune tamo temeniyerowata. Ahowa, etiri werese henerai tepa'asirowa su, lowe ta'i ta'i a'i temeniyerowa. ");
INSERT INTO sny_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Etiri werese hire ma'e irorowa ape, awei sahe irorowa ape, etiri werese towesi fiyari po'uterowa. Ahowa, peri werese pefine a'i ano mi mi pasi pasi ironamitorowa. Peri werese ano po'uterowata. Peri werese ano wiyeme a'i henerairowa. ");
INSERT INTO sny_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Fene werese weiyai! Fene sa'i luwaru a'i owe ape ene a meremereyete. Fene awei lo marepi owe ape totenamite. Fene yo seni luwaru a'i eito eite irowei su, Owane Sitewi lo nowe ape fene ma'e witane a'i heneraiyei. Fe la'inau aiwawe a'i ne. ");
INSERT INTO sny_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ane si tame itoraiyei su, nowe ape lu taune werese omo omo werese ma'e witane a'i henerairowa. ");
INSERT INTO sny_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Serai fene mi mi pasi pasi siye etire. Fene Owane Sitewi ma'e apou te'e towerinamite, ‘Owane Sitewi, ne nomo ma'e kairefiyeyei no aure. Serai nomo etiri werese luwaru a'i, henerairowa ape, awera'iyenatirowa. Sosu aiwawe a'i Jisas, meni ape tu hire ma'e itorai ape, le lai yo seni nomo lo au hese eti ereirowa su, nomo le ma'e neritase a'i se teirowata.’” ");
INSERT INTO sny_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Sosu a'i pe le peri ape au te'e tepa'asiye su, le nowe mi werese Owane Sitewi lo wesi tutawe sahe lu taune werese ma'e Owane Sitewi lo peri au te'e areiyeteye. Nowe neriwei su, le Owane Sitewi lo wesi tutawe arunatiyewe, omo ta iyape Oliv ma'e fi. Le pasi a'i omo ape ma'e iroteye. ");
INSERT INTO sny_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Nowe mitaiyeye su, le Owane Sitewi lo wesi tutawe sahe si tame wiye. Lu taune tomu ne'ese Owane Sitewi lo wesi sahe peri lo wanuwei ne fai. ");
INSERT INTO sny_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Sosu a'i pe Juda lo ta'uwe hereiyei iyape Pasova, atahe a'i heneraiyei. Nowe ape se Juda lo lu taune werese nau ta'ase a'i ene aye. ");
INSERT INTO sny_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Au heseyei lu owane tutawe, sosu Owane Sitewi lo peri lese siye lu werese, lowe Jisas aine tera'eyei ne toteye. Lowe marepi erasi a'i Jisas aine tera'eyei ne totenamiteye. Lowe yo ta siyerowata. Lowe lu taune werese ne atoweiyenamiteye. ");
INSERT INTO sny_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Sosu a'i pe sepei luwaru a'i tutawe, Satan, meni Judas papu wiye. Meni ape lo iyape tere'e Iskariot. Le Jisas meni lu disaipel aiwawe a'i iroteye. Jo 13:2,27 ");
INSERT INTO sny_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Le au heseyei lu owane tamo, sosu ai lu tamo, Owane Sitewi lo wesi au noweinoweiteye ape, le lowe ma'e au te'eyei ne fi. Le lowe ma'e apou ei toweriye, “Fene meni Jisas aine tera'eyei ne totesiya awere? Ane meni ape fene ma'e henetaiyei su, fene ma'aru eiwerou a'i ane ma'e auwei awere?” ");
INSERT INTO sny_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Au heseyei lu owane werese Judas lo peri wanuwe su, lowe marepi wisereye nine'iteye. “Wiyeme a'i ne! Nomo ne ma'e ma'aru tomu ne'ese auwei.” ");
INSERT INTO sny_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Sosu Judas lowe ma'e itiya'u eiye, “Ei, ane Jisas fene ma'e henetaiyei.” Sosu le lowe arunatiyewe fi. Le Jisas aine tera'eyei lo yo ape ne ani nehiti. Le apou toteye, “Jisas woto a'i iroteyei su, ane fara'u lowe ma'e henetiyei. Lu taune tomu ne'ese Jisas siyeowata.” ");
INSERT INTO sny_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Sosu a'i pe ta'uwe hereiyei, iyape Pasova, henerai tepa'asiye. Juda lo lu taune werese nau ta'ase a'i ene aye. Nowe ape se Juda lo meni owane fe sipsip ta'i aine tera'eyewe, Owane Sitewi ma'e au heseye. Kis 12:1-27 ");
INSERT INTO sny_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Sosu Jisas lu hesi Pita, Jon ei aniye. Le lowesi ma'e te'eye, “Fenesi wesi ta Pasova lo ene ayei ape ta'uweyei ne ire! Sosu nomo Pasova lo ta'uwe hereiyei ene arowa.” ");
INSERT INTO sny_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Lowesi le ma'e itiya'u te'e toweriye, “Eiwerou ma'e nomo ta'uwe hereiyei ta'uweyei awere?” ");
INSERT INTO sny_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Sosu le lowesi ma'e itiya'u eiye, “Wanure! Fenesi omo Jerusalem ma'e wiyei su, fenesi meni ta sa'i pa'are suteyei ape siyerowa. Fenesi meni ape mo'o umasire. Meni ape wesi lo wiyei su, wesi ape sahe nomo ta'uwe hereiyei ene ayei. ");
INSERT INTO sny_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Fenesi wesi ape papu wiyei su, fenesi wesi ape lo meni owane ape ma'e apou eire, ‘Meni Owane notosi lo, ne ma'e ei towerisiya, wesi eite tewi wesi ta irosiya awere? Serai ane lu disaipel ano mase ta'uwe hereiyei Pasova ene ayei. Wesi tewi ta irosiya awere?’ ");
INSERT INTO sny_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Meni ape fenesi ma'e wesi tewi ta erasi a'i hire ma'e au atuatuwei. Wesi yaru tewi ape etiri werese saro iroteyei, metei, me tuto'u saro iroteyei. Fenesi ayei etiri werese au ta'uwere.” ");
INSERT INTO sny_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Sosu lowesi Jisas arunati fiyewe, omo Jerusalem ma'e heneri. Etiri werese, Jisas lowesi ma'e au te'eye ape, wiyeme a'i henerai. Lowesi meni ta'i sa'i pa'are suteti siyesawi. Lowesi meni ape mo'o umasiti. Lowesi wesi tewi ape ma'e wiye su, lowesi ayei werese ene ayei ne ani ta'uwe naneiye. ");
INSERT INTO sny_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Nowe ape henerai su, Jisas lu disaipel lo mase wesi tewi ape sahe aiwawe ta'uwerai. Lowe werese metei sahe onuri. ");
INSERT INTO sny_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Sosu Jisas lu feni ma'e eiye, “Ane a'i lai marepi erasi a'i se ta'uwe hereiyei ape fene aiwawe ene ayei ne totesiya. Nomo Pasova ape ene a tepa'asiyei su, ane fofowei erasi a'i teriteyei. ");
INSERT INTO sny_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Wanure! Ane ta'uwe hereiyei ape ene a tepa'asiyei su, ane Pasova tere'e si tame arowata. Ahowa, ane si tame itoraiyei su, ane fara'u tame arowa. Nowe ape se Owane Sitewi lu taune au noweinoweirowa ape ta'uwe hereiyei Pasova lo eti wiyeme a'i henerairowa.” ");
INSERT INTO sny_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Sosu le peri te'e tepa'asiye su, le siye auwe wain sa'i mase ereti se aniye. Le Owane Sitewi ma'e hire ma'e au te'e wisereyeye. Sosu le lowe ma'e eiye, “Siya auwe eite anitere! Fene werese tewi are! ");
INSERT INTO sny_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Wanure! Ane wain sa'i tere'e tame arowata. Nowe ape se Owane Sitewi lai lu taune au noweinoweirowa ape, henerairowa su, ane fara'u wain sa'i tame arowa. Nowe ape se ane Meni Owane Pefine a'i henerairowa. Ane lu taune werese au noweinoweirowa.” ");
INSERT INTO sny_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Lu feni werese wain sa'i a tepa'asiye su, le nau ta'ase ereti se aniye. Le Owane Sitewi ma'e nau ta'ase ape au te'e wisereyeye su, le nau ta'ase tewi pa tewi ani topoto lotowe. Le lowe ma'e eiye, “Nau ta'ase tahe pa'are ano wou a'i ne. {Ane tahe pa'are ano fene ma'e auwei. Fene nau ta'ase ene anamiteyei su, fene ane ne tote etire.” ");
INSERT INTO sny_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Sosu lowe nau ta'ase ene a tepa'asiye su, le aiwawe a'i siye auwe ereti aniye. Le Owane Sitewi hire ma'e au ei te'e wisereyeye su, le lowe ma'e eiye, “Wain sa'i ape lai fisa'i ano wou a'i ne. Nowe me'iye su, ane fisa'i ano fene ne ani teroso arowei. Serai ane fene ma'e peri te'e naneiyei he'i auwei. Apou a'i au te'eyei. Fisa'i ano ani teroso arowei su, ane yo seni luwaru werese a'i fene lo au sasari po'utesawirowa.”} ");
INSERT INTO sny_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ahowa, weiya! Meni ta, ane ai lu ma'e areare henetiyei ape, le metei sato nomo aiwawe onusiya. Sng 41:9; Jo 13:21-22 ");
INSERT INTO sny_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Peri ano wiyeme a'i ne! Wanure! Ei, ane, meni hire ma'e itorai ne. Nowe me'iye su ane temeniyerowa. Owane Sitewi lai wiyawi ano ape ariariyeye. Ahowa, meni ape ne weiyai! Meni ape ane ai lu ma'e henetirowa su, le marepi orese erasi a'i teritenamirowa.” ");
INSERT INTO sny_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Lu feni werese Jisas lo peri wanuwe su, lowe a'i lai te'e tiyatiteye. “Eiwerai meni ape ai lu ma'e henetirowa awere? Ane lai awere? Ahowa, ane lai ta'ama.” ");
INSERT INTO sny_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Lowe a'i lai te'e tepa'asiye su, lowe ai peri ta au te'eye. Lowe apou te'e toweriye, “Nomo lo meni tutawe eiwerai henerairowa awere?” Lu 9:46 ");
INSERT INTO sny_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Sosu Jisas peri lowe lo wanuwe su, le lowe ma'e itiya'u te'eye, “Lu tewi tere'e lowe meni owane tutawe irosiya. Meni owane tutawe, le lu taune topo lo ma'e wiyawi erasi au none ereisiya. Lu taune topo lo lowe ma'e apou eisiya, ‘Meni Owane lowe kaiyemo mo nomo lo ne.’” Mt 20:25-27; Mk 10:42-45 ");
INSERT INTO sny_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ahowa, fene aiwawe a'i ta'ama. Meni ta meni owane heneraiyei ne totesiya ape, le meni yo'orei aiwawe a'i heneraiyei. Meni ta meni owane tutawe heneraiyei ne totesiya ape, le wiyawi yahowa'i a'i ani siye meni wou heneraiyei. Mt 23:11; Mk 9:35 ");
INSERT INTO sny_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ane fene ma'e ei toweriyei, eiwerai meni owane irosiya awere? Meni ta metei sahe onusiya awere? Meni yahowa'i a'i ta ayei ene a nonetisiya awere? Eiwerai meni iyape se irosiya awere? Meni ta metei sahe onusiya awere? Le a'i lai iyape se irosiya awere? Weiya, siyere! Ane a'i lai fene ma'e ayei au nonetisiya. Jo 13:12-15 ");
INSERT INTO sny_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Lu tamo ane ma'e au luwaruweye su, fene ane mase ironamiteye. Ahowa, fene ane mase teinamiteye. ");
INSERT INTO sny_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Tai ano kairefi he'i a'i ane ma'e au noweinoweiyei ne auwe. Serai ane fene ma'e kairefiyeyei ape aurowa. Fene ane mase lu taune au noweinoweirowa. ");
INSERT INTO sny_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nowe ye'ewi se, ane lu tewi he'i a'i ape mo au noweinoweiyei ne itorairowa su, fene ane mase ironamitorowa. Fene ane mase ene arowa. Sosu wain sa'i ane mase aiwawe arowa. Fene lu taune werese au noweinoweisiya. Fene Juda lo lu tewi werese ape mo peri lowe lo wanu au hese eti ereirowa.” Mt 19:28 ");
INSERT INTO sny_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Sosu a'i pe Jisas Pita ma'e eiye, “Saimon, Saimon, ne weiyai! Sepei Satan Owane Sitewi ma'e tote tawesiyei no ape ne ei toweriye. Le apou ei toweriye, ‘Ane Saimon Pita lo tote tawesiyei au hese siye etiyei. Tote tawesiyei lo meremereye a'i awere? Apou wou a'i menitani ta oro'oru kewi so ma'e au sasarisiya.’ ");
INSERT INTO sny_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ahowa, ane lai Owane Sitewi ma'e ne ne au ei toweriye. Serai tote tawesiyei no kairefi a'i teinamiteyei. Aiwawe a'i tote tawesiyei no ani fu aro luwaruwerowata. Sosu sepei Satan lai tote tawesiyei no au siye hese eti tepa'asiyei su, ne tame tei kairefiyerowa. Ne tame tei kairefiyeyei su, ne lu feni ano au pati tei kairefiyete.” Jo 17:15 ");
INSERT INTO sny_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Sosu Saimon Jisas ma'e itiya'u eiye, “Meni Owane, peri ano wanure! Ane ne mase kalabus wesi ma'e aiwawe iyei. Lu tamo ne aine tera'eyei ne toteyei su, ane ne mase temeniyeyei.” ");
INSERT INTO sny_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jisas le ma'e itiya'u eiye, “Pita, ane ne ma'e eisiya. Wanure! Nowe mitaiyeyei su, irowe Kakaruk aite peri uteyei ta'ama su, ne ane ne me'iyeni ma'e atati aruwei. Nowe hesi heta ne ane ne me'iyeni ma'e atati aruwei.” ");
INSERT INTO sny_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Sosu a'i pe Jisas lu disaipel lo ma'e te'eye, “Tu naifa ane fene Owane Sitewi lo peri au te'eyei ne eimawesawi su, fene ma'aru ipi, lowe tahe, niye fene lo aiti ta'ama. Ahowa, fene lau mase iroteye awere? Fene wesi sahe nihe howeiteye awere?” Lowe le ma'e itiya'u eiye, “Ahowa, nomo wisere a'i teinamiteye. Etiri werese po'ute se ta'ame.” Lu 9:3; 10:4 ");
INSERT INTO sny_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Sosu le lowe ma'e eiye, “Ahowa, weiya! Ane fene Owane Sitewi lo peri tame au te'e fiyariyei ne eimawesawiyei. Fene iyei su, fene ma'aru niye irosiya ape, fene fara'u aitire. Aiwawe a'i fene niye irosiya ape, fene fara'u aitire. Fene ipari mene'e pite a'i ariye su, fene ipari tahe fene lo meni ta fa etere. Sosu ma'aru aniyei su, fene ipari mene'e pite a'i etere. ");
INSERT INTO sny_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ane fene ma'e eisiya. Wanure! Tu naifa Owane Sitewi lo au te'e siye meni ta, le ane ne apou leseye, ‘Lu tamo meni ape kalabus wesi ma'e henetirowa su, le lu luwaru a'i mase irorowa.’ Aisaia ane ne apou leseye. Peri ape le leseye ape wiyeme a'i heneraiyei.” ");
INSERT INTO sny_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Sosu Jisas lo lu feni le ma'e itiya'u eiye, “Meni Owane ne siyere! Nomo ipari mene'e pite hesi a'i sato irosiya.” Sosu Jisas itiya'u eiye, “Fara'u papa. Nomo iyei ne.” ");
INSERT INTO sny_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Sosu a'i pe Jisas wesi nowe ma'e fi. Le Omo Oliv ma'e yaneye. Lu disaipel lo mo'o umasiye. Le pasi pasi werese omo ape ma'e yaneteye. ");
INSERT INTO sny_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Le omo hire ma'e yaneye su, le lowe ma'e te'eye, “Fene Owane Sitewi ma'e au te'ere. Serai fene yo seni luwaru a'i lo marepi owe ape umasite.” ");
INSERT INTO sny_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Jisas peri tepa'asiye su, le lowe arunatiyewe, eyeri oso a'i ma'e fi. Le awei sahe lowe uporo ape'i onuwewe, Owane Sitewi ma'e au te'e tiyatiteye. ");
INSERT INTO sny_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Le Owane Sitewi ma'e apou au te'eteye, “Tai ano, ane temeniyeyei wou ta'ama. Ne aiwawe totesiya su, ane fara'u temeniyeyei awera'iyenatiyei. Ahowa, ane marepi ano umasiyei ta'ama. Ane marepi no fu umasiyei.” ");
INSERT INTO sny_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","{Jisas peri lo au te'e tepa'asiye su, Owane Sitewi lo ipari wisere a'i ta hi ma'e Jisas lo marepi au kairefiyeyei ne itorai. ");
INSERT INTO sny_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Le marepi orese a'i teriteteye, le tahe lu'awi erasi henerai, fisa'i wou a'i awei sahe teroso itowe.} ");
INSERT INTO sny_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Jisas Owane Sitewi ma'e au te'e tepa'asiye su, le sineyewe, lu disaipel lo ma'e si tame fi. Lowe werese marepi orese a'i teriteye. Serai lowe werese nihe howeiteye. ");
INSERT INTO sny_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Sosu Jisas lowe ma'e eiye, “Fene piyene nihe teisiya awere? Sinere! Fene Owane Sitewi ma'e tame au te'ere! Serai fene yo seni luwaru a'i lo marepi owe ape fa umasire.” ");
INSERT INTO sny_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Sosu a'i pe Jisas lu disaipel lo ma'e au te'eteye su, lu tomu ne'ese Jisas ma'e henerai. Meni ape Judas, lu werese tu henerai. Le Jisas ma'e henerai su, le Jisas lo ahi tahe weniwe sahe eriteyei ne ani teineye. ");
INSERT INTO sny_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ahowa, Jisas le ma'e eiye, “Judas, ne ane meni hire ma'e itorai ape, ahi tahe weniwe ano sahe ariariyeyei ne ani teineye awere? Serai lu werese notosi siyeyei su, lowe ane kalabus wesi ma'e heneti.” ");
INSERT INTO sny_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Sosu lu disaipel lo etiri ape siyeye su, lowe Jisas ma'e te'e toweriye, “Meni Owane, nomo fara'u ipari mene'e se lowe ma'e ani tewiyei awere?” ");
INSERT INTO sny_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ahowa, meni ta ipari mene'e ereti se aniye su, le meni ta apaniye ai feni se aine la'eye. Meni ape au heseyei meni owane lo wiyawi yahowa'i a'i ta'ane siye meni. ");
INSERT INTO sny_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ahowa, Jisas itiya'u eiye, “Aru, fara'u papa.” Sosu le meni ape lo apaniye ereti se aniyewe, si tame fuwe. Apaniye ape au ta'ane fara'uweye. ");
INSERT INTO sny_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Sosu Jisas au heseyei lu owane tutawe mo owane tere'e aiwawe, le lowe ma'e ei toweriye, “Fene me au, ipari mene'e se ane ma'e anite tawesiyei ne aitai awere? Ta'arei siye meni wou a'i ne. Ahowa, ane ta'arei siye meni ta'ama. ");
INSERT INTO sny_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Mi mi werese ane Owane Sitewi lo wesi tutawe sahe peri au te'enamiteye. Nowe ape se fene ane anite tawesiye ta'ama. Ahowa, nowe ano henerai tepa'asiye. Fene sepei Satan lo marepi fa umasire.” ");
INSERT INTO sny_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Sosu a'i pe ai lu werese Jisas lo ereti wafei se anite ti tawesiye. Lowe Jisas omo Jerusalem ma'e heneti. Lowe au heseyei meni owane tutawe lo wesi ma'e heneti. Lowe Jisas heneti su, Pita lowe mo'o eyeri oso a'i umasiti. Sng 31:11 ");
INSERT INTO sny_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ai lu tamo Jisas wesi ma'e hene wiye su, lu tere'e nepawe amerame sahe yehe ani lei etineteye. Pita lowe mase aiwawe a'i onuteye. ");
INSERT INTO sny_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Lowe yehe sahe onuteye su, wiyawi yahowa'i a'i ta'ane siye menitani lai Pita siye etiye. Sosu le lowe ma'e apou te'eye, “Meni ape Jisas mase iroteye.” ");
INSERT INTO sny_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ahowa, Pita itiya'u eiye, “Wawero a'i ne! Menitani, ane meni ape so'oru ta'ama.” ");
INSERT INTO sny_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Nowe oso a'i su, meni tere'e Pita siyeye. Le Pita ma'e eiye, “Ne lai Jisas lo meni disaipel tene!” Ahowa, Pita le ma'e itiya'u eiye, “Ahowa, wanure! Ane ta'ama.” ");
INSERT INTO sny_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Nowe tewi i tepa'asiye su, meni tere'e Pita ne au te'eye, le apou eiye, “Ane so'oruwesiya tene! Meni eite Jisas mase ironamiteye. Peri te'eyei lo ape wanure! Le Jisas lo omo pani Galili aiwawe ma'e fai.” ");
INSERT INTO sny_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ahowa Pita apou itiya'u eiye, “Meni peri ano wanure! Ane peri no ne so'oru ta'ama.” Sosu Pita peri au te'e tepa'asiye su, irowe kakaruk aite peri erasi uteye. ");
INSERT INTO sny_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Sosu Jisas Pita ma'e atati siye etiye. Sosu Pita Jisas lo peri tu au te'eye ape marepi tote tawesiye. Apou a'i toteye, “Ne irowe kakaruk peri uteyei wanuwei su, ne nowe hesi heta ane ne me'iyeni ma'e atati aruwei.” ");
INSERT INTO sny_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Sosu Pita Jisas lo peri tote tawesiye su, le nowe ma'e heneye. Le marepi orese a'i luwei erasi irowe. ");
INSERT INTO sny_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Sosu a'i pe ai lu tamo Jisas ereti lowe wafei se anite ti tawesiye ape, lowe Jisas ne peri te'e naruwe. Lowe le ma'e me au se aineye. Lowe Jisas ne pa'eyei erasi irowe. ");
INSERT INTO sny_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Lowe ipari tahe se nihe lo ti tawesiye. Lowe nihe lo ti tawesiye su, lowe le ma'e te'e toweriteye, “Ne Owane Sitewi lo peri au te'e siye meni lai su, ne peri nomo ma'e au te'e areiyere. Eiwerai ne ma'e aineye awere?” Sosu lowe niyeyei erasi a'i irowe. ");
INSERT INTO sny_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Lowe werese peri wawero tomu ne'ese le ma'e te'e etiye. Aiwawe a'i lowe le se peri te'e naruwe. ");
INSERT INTO sny_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Nowe esi mitaiyeye su, Owane Sitewi lo wesi ya'ariyei lu ta'uwerai. Au heseyei lu owane tutawe, Owane Sitewi lo peri lese siye lu tamo, lowe Jisas ta'uweyei wesi ma'e te'e toweriyei ne heneti. ");
INSERT INTO sny_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Lowe Jisas ma'e apou te'e toweriye, “Ne peri nomo lo itiya'u au te'ere! Ne meni ape Owane Sitewi lai hi awei ma'e eimawe arosai awere?” Ahowa, Jisas itiya'u eiye, “Ane peri apou eiyei su, ‘Ei, ane meni ape tene!’ Fene peri ano tote tawesiyei ta'ama. Jo 3:12 ");
INSERT INTO sny_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Sosu aiwawe ane fene ma'e peri ta ei toweriyei su, fene peri ano itiya'u au te'eyei ta'ama. ");
INSERT INTO sny_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Nowe pereye eite se, sosu mi mi pasi pasi weriyei se ane, meni hire ma'e itorai ape, ane Owane Sitewi, Meni Owane kairefiyeyei pefine a'i lo ereti eyate feni ma'e onunamitorowa.” Ap 7:56 ");
INSERT INTO sny_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Sosu lowe werese le ma'e te'e toweriye, “Wanure! Ne Owane Sitewi lo meni eime awere?” Sosu Jisas lowe ma'e itiya'u eiye, “Ei, ane lai tene! Fene peri wiyeme a'i ape te'eye.” ");
INSERT INTO sny_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Lowe Jisas lo peri wanuwe su, lowe itiya'u eiye, “Wanure! Nomo peri tere'e tamo le ne wanu ta'ame. Nomo peri topo lo wanu tepa'asiye. Le apou eiye, ‘Ane lai Owane Sitewi lo meni eime!’ Nomo le fa etire.” ");
INSERT INTO sny_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Lowe werese Jisas lo peri wanuwe su, lowe werese marepi ta'i a'i toteye. Sosu lowe werese sineyewe, le awei meni owane ma'e etiyei ne heneti. ");
INSERT INTO sny_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Lowe Jisas meni Pailat ma'e heneti su, lowe peri etiyei au te'eye. Lowe apou eiye, “Meni eite lu taune werese lo marepi tatai aniteye. Le apou eiye, ‘Lu taune werese takis ma'aru awei meni owane tutawe Sisar ma'e owe ape aure.’ Aiwawe a'i le apou eiye, ‘Ane a'i lai meni owane tutawe. Ane a'i meni wiyeme Owane Sitewi lai hi ma'e eimawe arosai. Ane Krais tene!’ Peri werese lo wawero a'i tene!” ");
INSERT INTO sny_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Sosu meni Pailat peri lowe lo wanuwe su, le Jisas ma'e ei toweriye, “Ne Juda lo meni owane tutawe awere?” Jisas le ma'e itiya'u eiye, “Ei, ne peri wiyeme te'e tepa'asiye.” ");
INSERT INTO sny_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Sosu meni Pailat Jisas lo peri wanuwe su, le au heseyei lu owane ma'e, sosu lu taune werese ma'e apou eiye, “Wanure! Ane yo seni luwaru a'i ta meni ape sahe siye ta'ame.” ");
INSERT INTO sny_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ahowa lowe le ma'e si tame itiya'u eiye, “Meni ape lu taune werese lo marepi au luwaruweye. Le peri luwaru a'i tu omo Galili sahe au te'eye. Sosu mo'o le omo pani Judia sahe au te'e fiyariye. Serai le omo omo werese sahe lu taune ma'e au te'e atuatu fiyariteye.” ");
INSERT INTO sny_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ahowa, meni Pailat peri lowe lo wanuwe su, le lowe ma'e ei toweriye, “Meni eite lo omo sitewi, Galili irosiya awere?” Lowe itiya'u eiye, “Ei, le pani Galili ma'e fai.” ");
INSERT INTO sny_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Sosu meni Pailat peri ape wanuwe su, le apou toteye, “Meni eite pani Galili ma'e fai. Awei meni owane Herot le meni eite fa etire. Le Herot lo pani ma'e fai. Serai Herot meni eite fa etire!” Nowe ape se awei meni owane Herot omo Jerusalem sahe onuteye. Lu 3:1 ");
INSERT INTO sny_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Sosu a'i pe meni Herot peri eite wanuwe su, “Pailat Jisas ane ma'e etiyei ne eimawesawi.” Le marepi wisere a'i toteye. Le Jisas lo wiyawi werese ne wanuwe. Serai yame tomu ne'ese se le Jisas siyereme. Le wiyawi erasi a'i Jisas ta'aneye ape, le siyereme. ");
INSERT INTO sny_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Sosu Jisas Herot ma'e heneri su, le peri tomu ne'ese Jisas ma'e ei toweriye. Ahowa, Jisas peri werese itiya'u ei ta'ame. ");
INSERT INTO sny_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Au heseyei lu owane tamo, Owane Sitewi lo peri lese siye lu tamo sato iroteye. Lowe werese peri erasi se peri wawero te'e etiteye. ");
INSERT INTO sny_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Meni Herot ai lu werese lo aiwawe a'i Jisas ma'e au luwaruweye. Lowe le ma'e peri te'e naruwe. Lowe ipari tahe lo'u a'i au ani asiye. Ipari tahe lo'u a'i apou a'i toteye. Meni Owane tutawe lo ipari tahe wou a'i ne. Lowe le ne pa'eyei au irowe. Sosu Herot Jisas meni Pailat ma'e si tame eimawesawi. ");
INSERT INTO sny_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Lowesi Pailat Herot aiwawe tu lowesi ai peri tiyati a'i iroteye. Pereye lowesi pinasu weri henerai. ");
INSERT INTO sny_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Sosu a'i pe lowe Jisas meni Pailat si tame henetai su, Pailat lai, au heseyei lu owane werese awei lu owane werese, lu taune werese, le lowe werese ta'uweyei wesi ma'e ei aniye. ");
INSERT INTO sny_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Sosu le lowe ma'e te'eye, “Peri ano wanure! Fene meni eite ane ma'e etiyei ne henetai. Fene le ne peri etiyei apou a'i te'eye. ‘Meni eite lu taune werese marepi luwaru a'i tatai aniteye. Serai lowe awei lo yo peri arisiye.’ Ahowa, ane meni eite lo yo seni werese nihe fene lo siye eti hese ereiye. Serai ane yo seni luwaru a'i lo siye ta'ame. Peri fene lo, fene le ne te'e etiye ape, wawero a'i ne. ");
INSERT INTO sny_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Aiwawe meni owane Herot le meni eite lo yo seni luwaru a'i siye ta'ame. Serai le nomo ma'e si tame eimawesai. Yo seni werese lo aseyaro a'i ne. Serai ane le aine tera'erowata. ");
INSERT INTO sny_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Serai ane le ma'e tahe lo sahe wafei se aineyei. Tahe lo sahe aine tepa'asiye su, ane nowe ma'e ani arosawiyei.” ");
INSERT INTO sny_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","{Iyu menei ta'i ta'i werese a'i, nowe ta'uwe hereiyei se, awei meni owane, meni ta'i kalabus sahe iroteye ape, le kalabus nowe ma'e ani arosawiyei. Serai Pailat lu taune werese ma'e apou ei toweriye, “Ane ta'uwe hereiyei fene lo se meni ta'i kalabus sahe nowe ma'e ani arosawiyei. Ane fara'u meni eite Jisas kalabus nowe ma'e ani arosawiyei awere?”} ");
INSERT INTO sny_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ahowa, lu taune werese peri erasi itiya'u uteye, “Ahowa! Meni eite aine tera'ere! Meni ape Barabas kalabus nowe ma'e ani arosawire!” ");
INSERT INTO sny_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Meni ape Barabas le lu tewi lo aiwawe awei meni owane lo ai lu ma'e ai atu tiyatiteye. Le lu tamo aine tera'eteye. Serai ai lu tamo le kalabus sahe fu arosawi. ");
INSERT INTO sny_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Sosu Pailat Jisas nowe ma'e ani arosawireme. Serai le lu taune werese tame te'eye, “Ane yo seni luwaru a'i lo siye ta'ame. Serai ane le nowe ma'e ani arosawiyei.” ");
INSERT INTO sny_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Lu taune werese peri erasi a'i si tame uteye, “Ahowa, meni eite me tape'i sahe aine tera'ere! Me tape'i sahe aine tera'ere!” ");
INSERT INTO sny_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ahowa, Pailat lowe ma'e tame te'eye, “Fene piyene meni eite aine tera'eyei ne toteyei awere? Le piye yo seni luwaru a'i irowe awere? Ane yo seni luwaru a'i, meni eite sahe irosiya ape, siye ta'ame. Meni eite yo seni luwaru a'i irowe su, ane fara'u le me tape'i sahe aine tera'eyei. Ahowa, ane yo seni aseyaro lo siye eti ereisiya. Serai ane meni eite lo tahe wafei se aineyei su, ane le nowe ma'e ani arosawiyei.” ");
INSERT INTO sny_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ahowa! Lu taune werese peri erasi si tame uteye, “Ne meni eite me tape'i sahe aine tera'ere! Le me tape'i sahe aine tera'ere! Le me tape'i sahe aine tera'ere!” Pailat peri no'u erasi a'i wanuwe su, le marepi lowe lo ma'e tote atati aruwe. ");
INSERT INTO sny_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Serai meni Pailat lowe ma'e eiye, “Fara'u a'i ne. Ane ai lu tamo ma'e eiyei, fene meni eite henetire! Fene le me tape'i sahe aine tera'ere.” ");
INSERT INTO sny_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Pailat peri te'e tepa'asiye su, le ai lu tamo ma'e apou eiye, “Fene meni Barabas, kalabus wesi sahe irosiya ape, fene le nowe ma'e ani arosawire.” Meni Barabas, meni luwaru a'i ne. Le ai lu tamo ma'e ai atuwe. Sosu le lu tamo aine tera'eye. Serai lowe meni ape kalabus wesi sahe ani fu arosawi. Meni ape Pailat lai kalabus wesi nowe ma'e hene ani arosai. Sosu le Jisas ai lu tamo ma'e heneti. Serai le lu taune werese lo marepi umasiye. ");
INSERT INTO sny_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Sosu a'i pe ai lu tamo Jisas nowe ma'e heneti. Lowe me tape'i ta ta'ane tepa'asiye su, lowe meni ta iyape Saimon ereti aniteye. Meni ape Saimon, le omo pani Sairini ma'e fai. Lowe Jisas lo me tape'i meni ape lo iyo'o sahe au sutetiteye. Sosu Jisas omo nowe ma'e tututiteye. Meni ape, Saimon, Jisas lo me tape'i au sutetiye ape, mo'o umasiti. ");
INSERT INTO sny_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Jisas, ai lu werese, Saimon, lowe omo Jerusalem nowe ma'e itori. Lu taune tomu ne'ese ta'uwerai. Lowe werese mo'o umasitiye. Taune werese le ne marepi orese a'i lu ewiteteye. ");
INSERT INTO sny_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Sosu Jisas luwei erasi a'i wanuwe su, le taune werese ma'e atati siye etiye. Le lowe ma'e eiye, “Jerusalem lo taune werese, fene ane ne owe ape lu ewitere! Fene towafi fene ne a'i lu ewitere. Piyene awere? Owane Sitewi lai fene ma'e etiri luwaru erasi a'i eimawe arosairowa. Aiwawe a'i fene eimane werese fene lo lu ewitere. ");
INSERT INTO sny_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Wanure! Nowe ape se, lu tamo apou eiyei, ‘Taune werese waiyari a'i ape, taune werese mo'u fi foro'o a'i ta'ame ape, fene werese marepi wisere a'i nine'iteyei.’ Lu 21:23 ");
INSERT INTO sny_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Nowe ape se lu taune werese omo ta ma'e eiyei, ‘Omo, ne awei apuwase fiyarire. Nomo sahe winetaira.’ Sosu omo tere'e tere'e ma'e eiyei, ‘Omo werese fene nomo werese napetu tawesire! Nomo temeniyeyei su, etiri wisere a'i ne.’ ");
INSERT INTO sny_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Nowe ape se orese a'i ta'ame su, lu taune ape mo yo seni apou ape irowei. Serai nowe luwaru a'i henerairowa su, lowe piye yo seni apou ape irorowa awere?” ");
INSERT INTO sny_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Lowe omo nowe ma'e fi su, Ai lu lai lu luwaru a'i hesi aiwawe ereti aniteye. Lowe lowesi aiwawe me tape'i sahe aine tera'e tawesiyei ne heneti. ");
INSERT INTO sny_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ai lu werese Jisas lu hesi aiwawe omo hire ma'e yaneye. Omo ape iyape lo sitewi, “Mato Pa'are lo Omo.” Omo ape sahe lowe Jisas me tape'i sahe ni'ari se ereti lowe aine tawereye. Sosu lowe me tape'i hire ma'e au ani sineteye. Lowe meni luwaru a'i ta'i ereti eyate feni ma'e me tape'i sahe aine tawereyewe, au ani sineteye. Sosu meni luwaru a'i tere'e ereti opi feni ma'e me tape'i sahe aine tawereyewe, au ani sineteye. ");
INSERT INTO sny_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Lowe Jisas lo me tape'i sineye su, Jisas Owane Sitewi ma'e peri ta apou te'eye, {“Tai ano, lu eite mo, lowe etiri, lowe irowe ape, lowe so'oru ta'ama. Ne fara'u yo seni luwaru a'i lowe lo marepi no papu owe ape tote anite tawesire.”} Jisas Owane Sitewi ma'e au te'eye su, ai lu tamo Jisas unahi awei sato tapiye oso a'i ani fu arosawi. Tapiye ta'i a'i ai lu ta Jisas lo ipari tahe aniyei ne ariariyeye. Ai lu tere'e tere'e ipari tahe tere'e tamo lo erei noneye. Ais 53:12; Sng 22:18 ");
INSERT INTO sny_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Lu taune tomu ne'ese eyeri oso a'i sahe etiri werese ape mo tei siyeteye. Awei lu owane tamo Jisas ma'e te'e naruteye. Lowe apou eiye, “Le lu taune tere'e tamo au pati aniteye.” Ahowa, le apou eiye, “Owane Sitewi lai ane hi awei ma'e eimawe arosai. Peri lo ape wiyeme a'i su, le topo le eiwerou pati anirowata.” Sng 22:7-8 ");
INSERT INTO sny_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ai lu tamo aiwawe Jisas te'e naruteye. Lowe Jisas wain sa'i, uwaseye ape, au aye. Sng 69:21 ");
INSERT INTO sny_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Lowe apou eiye, “Ne Juda lo meni owane tutawe su, ne topo ne a'i lai hi ani erau itora.” ");
INSERT INTO sny_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Meni ta metei tewi oso a'i sahe peri ta leseye. Peri ape apou a'i leseye. Juda Lo Meni Owane Tutawe Le Jisas lo me tape'i hire ma'e ni'ari se aine tawere tawesiye. ");
INSERT INTO sny_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Meni luwaru a'i ta, me tape'i sahe iroteye ape, le aiwawe Jisas peri luwaru a'i te'e naruwe. Le apou eiye, “Ne Meni Owane Sitewi ariariyeye ape awere? Ne Meni Krais su, ne hi ma'e itore. Ne notosi aiwawe a'i ani eraure. Serai notosi aiwawe itoraiyei.” Le Jisas ma'e peri pisa'i te'e naruteye. ");
INSERT INTO sny_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ahowa, meni luwaru a'i tere'e ape le pinasu lo ma'e eiye, “Peri titanere! Ne Owane Sitewi Pefine atoweiye siye ta'ama awere? Wanure! Ne yo seni luwaru a'i ironamiteye su, lowe ne aiwawe a'i aine tera'eyei. ");
INSERT INTO sny_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ei, notosi yo seni luwaru a'i tomu ne'ese ironamiteye. Serai notosi me tape'i sahe temeniyeyei. Ne meni ape siyere! Meni ape yo seni werese aseyaro a'i ironamiteye. Piyene lowe le aine tera'eyei awere?” ");
INSERT INTO sny_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Sosu le Jisas ma'e atati eiye, “Jisas, ne si tame itorairowa su, ne marepi no papu ane tote anite tawesire.” ");
INSERT INTO sny_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Sosu Jisas le ma'e itiya'u eiye, “Peri ano wanure! Wiyeme a'i, pereye, ne ane aiwawe omo hire ma'e ironamiteyei.” ");
INSERT INTO sny_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Sosu a'i pe nowe poweiye ponei teiteye su, nowe pasiyeyei wou a'i henerai. Pasiyeyei awei pani werese napetu tawesi po'uteteye. Poweiye wati se nowe pasiyeyei ape tepa'asiye. ");
INSERT INTO sny_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Poweiye hire ma'e Owane Sitewi lai ereti se fu tawesiye. Aiwawe Owane Sitewi lo wesi tutawe sahe ipari tahe, wesi papu heriteye ape, Owane Sitewi lai ipari tahe ape tewi a'i tewi a'i ani erauwiye. Lu 8:2-3 ");
INSERT INTO sny_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Sosu Jisas peri erasi uteye, “Tai ano! Ane hepene ano ereti no ma'e auwei.” Sosu Jisas peri ape te'e tepa'asiye su, le temeniyeye. Sng 31:5 ");
INSERT INTO sny_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Sosu ai lu lo meni owane Jisas lo peri wanuwe su, le Owane Sitewi ma'e au te'e wisereyeye. Le apou eiye, “Wanure! Meni ape lo yo seni luwaru se ta'ame.” ");
INSERT INTO sny_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Lu taune werese etiri ape mo siyeteyei ne ta'uwerai ape, lowe werese marepi orese erasi a'i totenamiteye. Lowe wesi towafi lowe lo si tame fi. Lowe ereti neme lo tepi pi se tomuteye. ");
INSERT INTO sny_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jisas lo lu feni tomu ne'ese omo pani Galili ma'e fai ape, taune tomu ne'ese Jisas aiwawe mo'o umasiye. Lowe etiri werese ape mo eyeri oso a'i sahe tei siyeteye. ");
INSERT INTO sny_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Meni ta iyape Josep aiwawe iroteye. Meni ape Juda lo omo ta iyape Arimatea ma'e fai. Le nowe ape se, Owane Sitewi lai lu taune au noweinoweirowa ape, ninaweteye. Tu naifa au heseyei lu owane te'e ta'uwerai su, meni ape aiwawe iroteye. Lowe tere'e werese apou eiye, “Ei, nomo Jisas fa aine tera'ere.” Ahowa, meni ape apou eiye, “Ahowa, nomo Jisas aine tera'eyei ta'ama. Meni ape meni wisere a'i ne. Le Owane Sitewi lo marepi umasinamiteye.” ");
INSERT INTO sny_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Meni ape Jisas lo tahe pa'are aniyei ne toteye. Serai le awei meni owane Pailat ma'e ei toweriyei ne fi. ");
INSERT INTO sny_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pailat apou eiye, “Fara'u a'i ne. Ne tahe pa'are lo ani itoraire!” Sosu le Jisas lo tahe pa'are ani itorai. Le ipari tahe wapo a'i se Jisas lo tahe pa'are ani worone ti tawesiye. Sosu le tapiye fisiye yo papu au howeiye. Tapiye fisiye yo ape he'i a'i ta'aneye. ");
INSERT INTO sny_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Meni ape Jisas lo tahe pa'are fisiye yo sahe au howeiye su, nowe erese iroteye. Juda lo lu taune werese nowe amou (Sabat) au ta'uwe naneiteye. Poweiye amou ape ataheyerai. ");
INSERT INTO sny_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Taune tamo Jisas Pani Galili ma'e aiwawe fai ape, lowe meni ape mo'o umasitiye. Lowe Jisas lo fisiye yo siyeyei ne umasitiye. Eiwerou ma'e iroteye awere? Sosu tahe pa'are lo eiwerou fuwe awere? ");
INSERT INTO sny_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Lowe fisiye yo siyeye su, lowe wesi towafi lowe lo ma'e si tame fi. Lowe etiri sa'i tamo heneri a'i tomu ne'ese ta'uwe naneiteye. Lowe etiri sa'i werese ta'uwe nanei tepa'asiye su, lowe Moses lo yo peri umasiteye. Lowe poweiye amou ape tei fetaneyeteye. Sosu lowe Owane Sitewi ma'e au te'e wisereye nine'iteye. Kis 20:10; Lo 5:14 ");
INSERT INTO sny_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sosu a'i pe nowe tutawe (Sande) taune ape mo nowe esi pasi sineyewe, tapiye fisiye yo ma'e fi. Lowe Jisas lo tahe pa'are sahe etiri sa'i heneri a'i au ani teroso teineyei ne fi. ");
INSERT INTO sny_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Lowe tapiye fisiye yo heneri su, lowe apou toteye, “Eiwerai fisiye yo ahi ta'o lo tapiye ani nowerisawiyei awere?” Lowe fisiye yo henerai su, lowe fisiye yo ahi ta'o lo tapiye nowe ma'e ani nowerisawiyei siyeye. Fisiye yo lo tapiye ahi ta'o ape ariye a'i iroteye. ");
INSERT INTO sny_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Lowe fisiye yo papu wiye su, Meni Owane Jisas lo tahe pa'are siye ariye. ");
INSERT INTO sny_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Lowe hepene se su'ariye. Lowe marepi erasi a'i toteye. Lowe fisiye yo siye ariye su, siyere! Lu hesi papu siyeye. Ipari tahe lowesi lo mi erasi a'i aiwawe tewi mitaiyeye. ");
INSERT INTO sny_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Taune ape mo lu hesi ape siyeye su, lowe marepi atoweiye tote auseriyeteye. Lowe awei sahe lowe uporo ape'i onuwe. Sosu lu hesi ape lowe ma'e te'e toweriye, “Fene piyene meni hepene se, ironamisiya ape, fisiye yo papu nehisiya awere? ");
INSERT INTO sny_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Jisas sato ariye. Le si tame norohuwe sineye. Tu naifa fene le mase omo pani Galili sahe iroteye su, le fene ma'e peri ta au te'eteye, fene peri ape marepi tote eti tawesisiya awere? Lu 9:22 ");
INSERT INTO sny_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Le fene ma'e apou eiye, ‘Lu tamo ane, meni hire ma'e itorai ape, lowe ane lu luwaru a'i ma'e henetiyei. Lowe ane me tape'i sahe aine tawere tera'erowa. Sosu nowe hesi heta ane si tame norohuwe sinerowa.’” ");
INSERT INTO sny_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Owane Sitewi lo ipari hesi ape peri ape au te'eye su, taune ape mo Jisas lo peri marepi anite tawesinamiteye. ");
INSERT INTO sny_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Serai lowe Jisas lo tapiye fisiye yo arunatiyewe fi. Lowe Jisas lo lu disaipel ereti feni hesi lowe ta'i a'i (11) ma'e lu taune tere'e tere'e aiwawe a'i peri ape au te'eyei ne fi. ");
INSERT INTO sny_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Taune ape mo iyape lowe lo apou a'i ne. Maria, le omo Makdala ma'e fai. Menitani tere'e Jona, menitani tere'e Maria, Jems lo mai. Taune tere'e tamo lowe mase Jisas lo lu disaipel ereti feni hesi lowe ta'i a'i (11) ma'e peri ape au te'eye. ");
INSERT INTO sny_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Jisas lo lu disaipel peri lowe lo wanuwe su, lowe apou toteye, “Taune werese eite mo meremereye a'i henerai. Nomo peri lowe lo so'oru ta'ama.” Lowe taune lo peri tote tawesi ta'ame. ");
INSERT INTO sny_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","{Ahowa, Pita sineteyewe, tapiye fisiye yo ma'e iteroti. Le tapiye fisiye yo ma'e heneri su, le me'iyeni epe'e arowe. Fisiye yo papu siyeye. Le Jisas lo ipari tahe, lowe tahe pa'are lo noweri tawesiye ape, siyeye. Le wesi topo lo ma'e si tame fi. Le hepene se su'ariye. Eiwerou irowe awere?} ");
INSERT INTO sny_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Sosu a'i pe nowe ape se, Jisas lo lu feni hesi a'i omo ta iyape Emeus ma'e iyei ne toteye. Lowe omo Jerusalem arunatiyewe, omo Emeus ma'e heneri. Omo ape eyeri atahe a'i iroteye (11 kilomita). ");
INSERT INTO sny_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Lowesi yo sahe iteye su, lowesi etiri werese iroteye ape, te'e te'e tiyatiteye. ");
INSERT INTO sny_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Lowesi te'e tiyatiteye su, Jisas lai lowesi ma'e henerai. Le lowesi mase iteye. ");
INSERT INTO sny_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Lowesi meni ape siye so'oru ta'ama. Nihe lowesi lo aworu a'i ne. ");
INSERT INTO sny_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Sosu Jisas lowesi ma'e ei toweriye, “Fenesi itiye su, piye peri te'e te'e tiyatiteye awere?” Sosu lowesi tei fetaneye su, lowesi marepi orese a'i teriteye. ");
INSERT INTO sny_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Meni ta'i iyape Kliopas, le ma'e ei toweriye, “Ne omo Jerusalem he'i a'i fai awere? Ne etiri werese, heneraiteye ape ne, so'oru ta'ama awere?” ");
INSERT INTO sny_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Sosu Jisas lowesi ma'e itiya'u eiye, “Piye etiri ta heneraiteye awere?” Lowesi le ma'e itiya'u eiye, “Etiri werese Jisas ne, omo Nasaret ma'e fai ape, le Owane Sitewi lo au te'e siye meni tutawe ne. Peri werese lo wiyeme a'i ne. Le wiyawi erasi pefine a'i lu taune werese ne ta'aneteye. Owane Sitewi lo nihe se meni ape wara'i a'i tene! ");
INSERT INTO sny_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Au heseyei lu owane tamo, awei lu owane aiwawe a'i lowe Jisas etiyei ne heneti. Lowe apou eiye, “Le fa temeniyere. Serai lowe le me tape'i sahe aine tawere tera'eye. ");
INSERT INTO sny_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nomo werese marepi apou a'i toteye. Meni ape pani Israel lo lu taune werese si tame eteyei. Ahowa, pereye le temeniyeye. Etiri werese ape mo henerai su, pereye nowe hesi heta i tepa'asiye. Lu 19:11; Ap 1:6 ");
INSERT INTO sny_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Pereye esi pasi taune tamo Jisas lo fisiye yo ma'e fi. Lowe tahe pa'are lo siye ariye. Sosu lowe si tame iterotaiyewe, nomo ma'e peri te'e ausai. Lowe apou eiye, ‘Nomo suwou se Owane Sitewi lo ipari wisere hesi a'i siyeye. Lowesi nomo ma'e te'eye. Meni ape fene nehisiya ape, le si tame norohuwe sineye. Nomo werese hepene se su'ariye.’ ");
INSERT INTO sny_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Lu tamo lowe lo peri wanuwe su, lowe fisiye yo ma'e siyeyei ne fi. Lowe fisiye yo ma'e heneri su, lowe apou aiwawe a'i siyeye. Taune ape lo peri wiyeme a'i te'eteye. Lowe tahe pa'are lo le siye ta'ame.” Jo 20:3-10 ");
INSERT INTO sny_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Sosu Jisas lowesi ma'e itiya'u eiye, “Marepi fenesi lo meremereye a'i ne. Tu naifa weriyei, Owane Sitewi lo au te'e siye lu werese Jisas ne au te'enamiteye. Fenesi etiri werese ape mo siyeye su, fenesi peri lowe lo marepi tote anite tawesi ta'ame awere? Marepi fenesi lo kairefi luwaru a'i ne. Fenesi peri lowe lo wanu tote tawesi ta'ame. ");
INSERT INTO sny_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Peri ano wanure! Meni ape Jisas, Owane Sitewi lai meni ape hi ma'e fofowei erasi teriteyei ne eimawesai. Le a'i lai Owane Sitewi lo marepi umasiteye. Aiwawe a'i le etiri werese teriteye su, le omo hire ma'e wirowa. Serai Owane Sitewi lai le ma'e etiri werese si tame aurowa. Etiri werese fa henerairowa.” Lu 9:22 ");
INSERT INTO sny_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Tu naifa Moses, Owane Sitewi lo au te'e siye lu aiwawe a'i lowe one towe sahe peri ta Jisas ne leseye. Sosu Jisas lowe lo peri lo eti werese lowesi ma'e au te'e atuatu areiyeteye. Le tu Moses lo peri au atuatuteye. Sosu mo'o Owane Sitewi lo au te'e siye lu werese lo peri au te'eteye. Sng 22:1-21; Ais 53 ");
INSERT INTO sny_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","29","Sosu lowe omo Emeus ma'e atahe a'i heneri su, nowe pasiyeye. Jisas omo ape awera'iyenatiyei ne toteye su, lowesi le ma'e eiye, “Weiya! Nowe pasiyewa. Ne notosi aiwawe a'i wesi sahe howeira.” Sosu Jisas wesi lowesi lo ma'e aiwawe a'i fi. ");
INSERT INTO sny_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Lowe wesi papu wiye su, le lowesi mase metei sahe ene ayei ne onuri. Le nau ta'ase ereti aniteyewe, Owane Sitewi ma'e au te'e wisereyeye. Le nau ta'ase tewi pa tewi a'i ani topotowe su, le lowesi ma'e nonetiye. ");
INSERT INTO sny_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Le nau ta'ase nonetiye su, nihe lowesi lo amerame a'i siyeye. Lowesi Jisas amerame a'i siye wiyemeyeye. Pereye a'i lowe Jisas saro siye nehi po'utenati. Jisas te'i fi. ");
INSERT INTO sny_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Jisas po'utenatiyewe fi su, lowesi te'e te'e tiyatiye. Lowesi apou te'eye, “Meni ape notosi yo sahe uweitai su, le Owane Sitewi lo peri au te'e atuatu areiyeye su, marepi notosi lo erasi a'i totenamiteye. Le Owane Sitewi lo peri werese notosi ma'e au te'e atuatu areiyeteye.” ");
INSERT INTO sny_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Sosu pereye a'i lowesi omo Jerusalem ma'e si tame iteroti. Jisas lo lu disaipel ereti feni hesi lowe ta'i a'i (11) lu taune tere'e aiwawe a'i wesi sahe ta'uwerai. Lowesi lowe werese nehiyei ne fi. Lowesi lowe siyeye su, lowesi apou te'eye, ");
INSERT INTO sny_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","“Meni Owane nomo lo, le si tame norohuwe sineteye tene! Le Saimon ma'e heneri.” 1 Ko 15:4-5 ");
INSERT INTO sny_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Sosu lowesi lowe ma'e peri lowesi lo au te'eteye. Jisas lowesi mase yo sahe iteye. Le Owane Sitewi lo peri lowesi ma'e au te'e areiyeteye. Sosu lowe omo Emeus heneri su, le wesi lowesi lo ene ayei ne onuri. Le nau ta'ase tewi pa tewi a'i lowesi ma'e ani topotowewe, none ene aye su, nihe lowesi lo amerame a'i siyeye. Serai lowesi Jisas siye so'oruweye. ");
INSERT INTO sny_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Sosu a'i pe lowesi peri lowesi lo au te'e tepa'asiye su, Jisas lai lowe ponei sahe teiteye. ");
INSERT INTO sny_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Lowe le siyeye su, lowe werese atoweiye auseriyeteye. Lowe apou toteye, “Nomo sepei luwaru a'i siyesiya.” Mt 14:26 ");
INSERT INTO sny_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ahowa, Jisas lowe ma'e eiye, “Fene piyene marepi papu atoweiye auseriyesiya awere? Fene piyene marepi hesi a'i totesiya awere? ");
INSERT INTO sny_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ereti lowe ano siyere! Lowe ereti lowe ano ni'ari se aine tawereye. Fene enite niyame yaru ano siyere! Ane lai ne. Ereti fene lo enite niyame yaru ano sahe fa isawe hete siyere! Fene ane siyere! Ipari werese tahe pa'are ariye. Ane lai tahe pa'are ironamisiya. Fene ane siyere!” ");
INSERT INTO sny_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","{Sosu Jisas peri tepa'asiye su, le ereti lowe lo lowe ma'e au atuatuwe.} ");
INSERT INTO sny_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Lowe werese ereti lowe lo siyeye su, marepi lowe lo wisere erasi a'i nine'iteye. Lowe werese marepi hepene se su'ariye. Sosu Jisas lowe ma'e ei toweriye, “Fene ayei ta irosiya awere?” ");
INSERT INTO sny_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Lowe itiya'u eiye, “Ei, hare ta tetisisiya, ne hare eite ani are.” ");
INSERT INTO sny_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Sosu le nihe lowe lo se hare ape ani ene aye. ");
INSERT INTO sny_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Sosu a'i pe le hare a tepa'asiye su, le lowe ma'e eiye, “Ane tu fene mase iroteye su, ane peri ano fene ma'e au te'e areiyeteye. Moses, Owane Sitewi lo au te'esiye lu werese, lowe ane ne one towe sahe leseteye. Lu ape mo, one towe sahe leseteye ape, lowe ane ne aiwawe apou leseteye. Etiri werese ape mo nowe me'iye se fa heneraire.” Lu 9:22 ");
INSERT INTO sny_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Sosu le marepi lowe lo amerame a'i heneraiyei ne au irowe. Serai lowe Owane Sitewi lo peri werese lo eti siye so'oruwe tepa'asiye. ");
INSERT INTO sny_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Sosu le lowe ma'e eiye, “Tu naifa meni ta Owane Sitewi lo peri one towe sahe apou leseye. ‘Nowe me'iye su, meni ta ane ariariyeye ape, le etiri fofowei luwaru tomu ne'ese a'i teriterowa. Lowe meni ape aine tera'erowa. Sosu nowe hesi heta i tepa'asirowa su, le si tame norohuwe sinerowa. ");
INSERT INTO sny_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Jisas si tame norohuwe sineteye su, serai nomo Jisas lo iyape se lu taune werese ma'e fa au te'e fiyarirowa. Nomo tu omo Jerusalem sahe fa au te'e fiyarirowa. Mo'o omo omo pani werese sahe Jisas lo peri fa au te'e fiyarirowa. Lowe werese yo seni luwaru a'i me'iyeni ma'e atati arurowa. Serai Jisas lai yo seni luwaru werese a'i lowe lo ani pamowerowa.’ ");
INSERT INTO sny_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Etiri werese, Jisas iroteye ape, fene lai siye so'oruwe tepa'asiye. Aiwawe Jisas lo peri werese, le au te'eteye ape, fene lai wanuteye. Etiri werese, fene siyeteye ape, sosu etiri werese, fene wanuteye ape, fene lu taune werese ma'e au te'e fiyari areiyete. Jo 15:27; Ap 1:8 ");
INSERT INTO sny_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ane fene ma'e au te'esiya. Wanure! Ane hire ma'e wiyei su, ane lai Owane Sitewi lo te'e naneiyei fene ma'e si tame eimawe arosairowa. Owane Sitewi lo te'e naneiyei ape Owane Sitewi lo Hepene Wara'i a'i ne. Le fene papu wiyei su, fene Owane Sitewi lo kairefiyeyei anirowa. Weiya! Fene omo Jerusalem sato irore. Nowe ape se Owane Sitewi lo Hepene Wara'i a'i fene papu wiyei.” Jo 14:16; 15:26; Ap 1:4 ");
INSERT INTO sny_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Sosu a'i pe Jisas peri ape te'e tepa'asiye su, lowe omo Jerusalem nowe ma'e heneti. Le lowe omo Betani ma'e heneri. Lowe omo Betani ma'e heneri su, le ereti lo ani aroweyewe, Owane Sitewi ma'e au te'eye, “Tai ano, ne lowe ma'e au pati ferafereite. Ne lowe ma'e au noweinoweite.” ");
INSERT INTO sny_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Sosu le Owane Sitewi ma'e lowe ne au te'eteye su, le ni'arawe papu hire ma'e wiye. ");
INSERT INTO sny_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Sosu Jisas ni'arawe papu wiye su, lowe omo Jerusalem ma'e si tame fi. Lowe marepi wisere erasi a'i nine'inamiteye. Sosu lowe Jisas ma'e lowe uporo ape'i onuwewe, le ma'e au te'e wisereye nine'iteye. ");
INSERT INTO sny_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Lowe mi mi werese Owane Sitewi lo wesi tutawe papu witeye su, lowe Owane Sitewi ma'e au te'e wisereyenamiteye. ");
INSERT INTO sny_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Tu naifa weriyei weriyei peri pefine a'i ironamiteye. Etiri werese henerai ta'ama. Peri pefine a'i ape Owane Sitewi wiyeme a'i mase ironamiteye. Peri pefine a'i ape Owane Sitewi wiyeme tene! Jo 17:5; 1 Jo 1:1-2; KTH 19:13 ");
INSERT INTO sny_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Tu naifa weriyei weriyei peri pefine a'i ape Owane Sitewi mase ironamiteye. ");
INSERT INTO sny_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Owane Sitewi awei etiri werese au ta'aneyei ne toteye su, le meni eime lo ma'e apou eiye, “Meni eime ano, ne etiri werese au ta'anere.” Serai le etiri werese au ta'aneye. Etiri werese ta'aneye ape, peri pefine lai au ta'aneye. Owane Sitewi tere'e lai etiri werese au ta'ane ta'ame. 1 Ko 8:6; Kl 1:16-17; Hi 1:2 ");
INSERT INTO sny_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Le papu marepi hepene sato ironamisiya. Sosu marepi hepene ape lu taune ma'e mi erasi Jisas wou a'i tewi mitaiye fiyarisiya. Jo 5:26 ");
INSERT INTO sny_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Mi erasi ape pasi a'i ma'e tewi mitaiye fiyariye. Ahowa, pasi a'i mi erasi hi ani fu ararorowata. Jo 3:19 ");
INSERT INTO sny_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Sosu a'i pe mi erasi ape ne, Owane Sitewi lai meni ta'i au te'e fiyariyei ne eimawesai. Owane Sitewi Pefine a'i meni ta eimawesai, iyape Jon. Mt 3:1; Lu 1:13-17,76 ");
INSERT INTO sny_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Le mi erasi ape au te'e areiyeyei ne fai. Le mi erasi ape au te'e areiyeyei su, lu taune tamo mi erasi ape ne wanu tote tawesiyei. ");
INSERT INTO sny_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Meni ape lai mi erasi ta'ame ne. Ahowa, le mi erasi siyeyei su, sosu le lu taune ma'e au te'e fiyariyei. ");
INSERT INTO sny_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Sosu a'i pe mi erasi pefine a'i, lu taune werese ma'e au tewi mitaiye fiyarisiya ape, hi awei ma'e itorai. Lu taune ape mo, mi erasi pefine a'i ape aniyei su, lowe Owane Sitewi lo marepi pefine a'i siye so'oruwerowa. Jo 8:12 ");
INSERT INTO sny_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Mi erasi pefine a'i ape, le hi awei sato iroteye. Le a'i lai etiri werese lu taune aiwawe a'i, awei sahe irosiya ape, ta'aneye. Ahowa, lu taune werese lai, awei sahe iroteye ape, lowe le ne siye so'oru ta'ama. ");
INSERT INTO sny_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Le Juda lo lu tewi topo lo ape ma'e itorai, sosu lu tewi lo ape le ne wanu tote tawesi ta'ame. ");
INSERT INTO sny_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ahowa, lu taune werese, peri lo wanu toteyei ape, sosu iyape lo ne tote tawesi umasiyei su, le lowe werese ma'e kairefiyeyei lo auwe. Serai lowe Owane Sitewi lo eimane heneraiyei. ");
INSERT INTO sny_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Lu taune Owane Sitewi lo eimane heneraiyei su, Owane Sitewi lai lowe eimane lo au iro heneraiyei ne. Mai eimane auteiyei su, lowe Owane Sitewi lo eimane henerai ta'ame. Mai tai auteiyei ne toteyei su, eimane lowesi lo Owane Sitewi lo eimane henerai ta'ame. Sosu lu lo marepi eimane ne toteyei su, lowe Owane Sitewi lo eimane henerai ta'ama. Ahowa, Owane Sitewi lo eimane werese marepi lo se heneraiyei. Jo 3:3-6; Fl 2:7; Jo 2:11; 1 Pi 1:23 ");
INSERT INTO sny_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Peri wiyeme a'i ape lai tahe pa'are henerai. Sosu le nomo aiwawe ironamiteye. Nomo mi erasi lo siyeye. Mi erasi ape eime ta'i a'i lo ne. Le a'i lai Owane Sitewi Tai Pefine a'i ma'e fai. Le a'i lai Owane Sitewi lo ferafereiyei, sosu peri pefine a'i marepi hepene lo teme'eriyenamiye. ");
INSERT INTO sny_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Meni ape Jon, le ne au te'e fiyariye. Le peri erasi apou hare uteye, “Meni ape ne ane lai, le ne tu au te'eye ape, apou eiye, ‘Meni ape ane mo'o aiyerowa. Wiyawi ano ani tepa'asiyei su, le wiyawi lo heneraiyei. Le a'i lai ane hi ani ararosiya. Piyene awere? Le tu mi mi pasi pasi weriyei ironamiteye.’” ");
INSERT INTO sny_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Le marepi wisereye teme'eriyesiya. Serai le a'i lai nomo ma'e ferafereiyei ta'i ta'i a'i aunamisiya. ");
INSERT INTO sny_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Sosu Moses lai, ereti topo lo se, Owane Sitewi lo yo peri leseyewe, nomo ma'e auwe. Sosu a'i pe Owane Sitewi lo ferafereiyei ape, peri pefine lo etiri ape mo Jisas Krais sahe henerai. Kis 34:28; Ro 6:14 ");
INSERT INTO sny_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Lu taune werese werese a'i Owane Sitewi ma'e siye ta'ame. Ahowa, Owane Sitewi lo meni eime ta'i a'i, le a'i lai Owane Sitewi Tai Pefine a'i nomo ma'e au atuatuwe. Le Tai Pefine a'i wiyeme eyate feni ma'e onunamisiya. Kis 33:20; Jo 6:46; 1 Ti 6:16 ");
INSERT INTO sny_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Sosu a'i pe Juda lo lu owane tamo, lowe au heseyei lu owane tamo, sosu Livai lo lu tewi tamo Jon ma'e eimawesawi. Lowe le ma'e apou ei toweriyei ne fi, “Ne eiwerai awere?” ");
INSERT INTO sny_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Sosu lowe le ma'e apou ei toweriye su, le mi mi werese itiya'u au te'eteye, “Ane lai Krais ta'ama.” ");
INSERT INTO sny_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Serai lowe le ma'e ei toweriye, “Ne a'i lai eiwerai awere? Ne meni Elaija, tu naifa weriyei temeniyeye ape, ne meni ape awere?” Sosu le itiya'u eiye, “Ahowa, ane Elaija ta'ama.” Lowe si tame ei toweriye, “Sosu ne Owane Sitewi lo peri au te'e siye meni tutawe nomo ninawesiya ape, ne meni ape awere?” Sosu le itiya'u eiye, “Ahowa.” Lo 18:15,18; Mt 11:14 ");
INSERT INTO sny_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Sosu lowe si tame ei toweriye, “Ne eiwerai awere? Ne peri ta nomo ma'e itiya'u au te'ere. Serai nomo peri no lu owane nomo lo ma'e si tame au te'eyei. Ne ta'u piye peri au te'eyei awere?” ");
INSERT INTO sny_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Sosu Jon lowe ma'e Owane Sitewi lo au te'e siye meni Aisaia lo peri itiya'u eiye, “Ane peri no'u pani ariye a'i sahe hare utesiya, apou eisiya, ‘Meni owane wiyeme nomo lo ataheyeraisiya. Yo mai lo ape au fareraiye irore.’” ");
INSERT INTO sny_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Sosu lu Farisi ape mo lu tamo Jon ma'e eimawesai. Sosu le ma'e apou ei toweriye, ");
INSERT INTO sny_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Lowe le ma'e te'e toweriye, “Ne Krais ta'ama su, sosu ne Elaija ta'ama su, sosu ne Owane Sitewi lo peri au te'e siye meni tutawe ta'ama su, serai ne piyene lu taune ma'e sa'i se au husiya awere?” ");
INSERT INTO sny_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Sosu Jon itiya'u eiye, “Ane lu taune ma'e sa'i au husiya. Ahowa, meni ta'i fene mase teisiya ape, fene meni ape so'oru ta'ama. ");
INSERT INTO sny_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Le a'i lai ane mo'o fai. Ahowa, ane meni yahowa'i a'i ne. Ane lowe tahe wafei lo ani eraurowata.” Jo 1:15 ");
INSERT INTO sny_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Etiri ape mo omo Betani sahe henerai. Omo Betani Sa'i Jordan feni eire ma'e iroteye. Saro ahe Jon lai lu taune ma'e sa'i au huteye. ");
INSERT INTO sny_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Nowe mo'o su, Jon Jisas siye aniye. Sosu le lu taune ma'e apou eiye, “Siyere! Owane Sitewi lo fe sipsip yene aiwa. Le lu taune werese lo yo seni luwaru a'i au sasariyei. Ais 53:6-7; 1 Pi 1:18-19 ");
INSERT INTO sny_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Meni ape ne, ane le ne totesiya. Ane fene werese tu apou te'eye su, ‘Meni ta'i ane mo'o fai. Ahowa, ane meni yahowa'i a'i ne. Serai ane lowe tahe lo wafei ani eraurowata.’ Ane peri eite au te'eye su, ane le ne toteye. Jo 1:15 ");
INSERT INTO sny_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ane ta'u meni ape siye so'oru ta'ama. Ahowa, serai ane lu taune ma'e sa'i se au huwei ne fai. Piyene awere? Sosu Israel lo lu taune meni ape, Owane Sitewi lai ariariyeye ape, siye so'oruwerowa.” ");
INSERT INTO sny_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Sosu a'i pe Jon peri ape apou au te'eye, “Ane Owane Sitewi lo Hepene Wara'i a'i ni'arawe ma'e itorai siyeye. Irowe sapuwe wou a'i itorai. Sosu iyo'o lo hire ma'e onurai. Mt 3:16 ");
INSERT INTO sny_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Meni ape ne Owane Sitewi lai ariariyeye. Ane etiri ape so'oru ta'ama. Ahowa, Owane Sitewi lai ane sa'i se au huwei ne eimaweye ape, le ane ma'e apou eiye, ‘Meni eite, ne Owane Sitewi lo Hepene Wara'i a'i le ma'e siye itonamirai. Meni eite lai lu taune ma'e Owane Sitewi lo Hepene Wara'i se au huwei.’ ");
INSERT INTO sny_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Serai ane Owane Sitewi lo Hepene Wara'i a'i itorai siye tepa'asiye. Sosu le meni ape lo iyo'o hire sahe onuteye. Sosu ane lu taune werese ma'e le ne au te'e areiyesiya. ‘Le a'i lai Owane Sitewi lo meni eime ta'i pefine a'i ne. Sosu le lowe ma'e mi mi pasi pasi ironamirowa.’” Mt 3:17 ");
INSERT INTO sny_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Nowe mo'o su, Jon lu feni hesi lo aiwawe saro ahe teiteye. ");
INSERT INTO sny_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Sosu le Jisas siye aniye su, le apou eiye, “Siyere! Owane Sitewi lo fe sipsip yene aiwa.” Jo 1:29 ");
INSERT INTO sny_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Sosu a'i pe Jon lo lu feni hesi peri ape wanuwe su, lowesi Jon arunatiyewe, Jisas mo'o umasiye. ");
INSERT INTO sny_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Sosu Jisas lowesi ma'e atati siye ei toweriye, “Fenesi piye aniyei ne totesiya awere?” Sosu lowesi itiya'u eiye, “Rabai! Ne eiwerou ma'e howeisiya awere?” Rabai lo peri eti apou a'i, te'e atuatu siye meni. ");
INSERT INTO sny_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Sosu Jisas itiya'u eiye, “Fenesi siyera.” Sosu lowesi le ma'e mo'o fiyewe, wesi sahe le howeisiya ape, siyeye. Saro ahe lowesi le mase poweiye ape ironamiye. Nowe poweiye neriwei iroteye. ");
INSERT INTO sny_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Sosu a'i pe lu hesi Jon lo peri wanuwe ape, meni ta'i iyape Andru, Saimon Pita lo pa'ise, le Jisas mo'o umasiye. Mt 4:18-20 ");
INSERT INTO sny_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Sosu le Jisas arunati su, le airu lo Saimon nehiyei ne fi. Le Saimon siyeye su, le Jisas ne au te'eye, “Nomo meni ape Owane Sitewi lai wiyeme a'i ariariyeye ape siyeye.” Peri eti apou a'i Krais. ");
INSERT INTO sny_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Sosu a'i pe le Saimon Jisas ma'e henetai. Jisas meni Saimon siyeyewe, apou eiye, “Ne iyape no Saimon, Jon lo meni eime poto. Pereye ane lai ne iyape he'i a'i au eiyei, apou a'i Sifas.” Iyape lo eti apou a'i Pita. Peri nomo lo lo eti, tapiye. Mt 16:18 ");
INSERT INTO sny_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Nowe mo'o su, Jisas omo pani Galili ma'e iyei ne toteye. Le fi su, le meni Filip siyeye. Sosu le ma'e eiye, “Ne ane mo'o umasire.” ");
INSERT INTO sny_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Meni ape Filip, Andru, Pita lo omo sitewi Betsaida aiwawe ma'e fai. ");
INSERT INTO sny_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Sosu Filip meni Nataniel nehiyei ne fiyewe, le ma'e eiye, “Nomo meni ape, Moses tu naifa weriyei Owane Sitewi lo yo peri one towe sahe leseteye ape, siyeye. Sosu aiwawe Owane Sitewi lo peri au te'e siye lu le ne apou a'i leseteye. Meni ape Jisas, Josep lo meni eime omo Nasaret ma'e fai.” Lo 18:18; Ais 7:14; 9:6; Jer 23:5; Ese 34:23 ");
INSERT INTO sny_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nataniel itiya'u ei toweriye, “Omo Nasaret ma'e fai awere? Etiri wisere a'i omo Nasaret ma'e heneraisiya awere? Piyete!” Sosu Filip itiya'u eiye, “Weiya! Ne siyenara!” ");
INSERT INTO sny_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Sosu a'i pe Jisas meni Nataniel siye aniye su, Jisas le ne eiye, “Siyere! Israel lo meni wiyeme aiyesiya. Meni ape peri wawero marepi lo se ariye.” ");
INSERT INTO sny_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Sosu Nataniel Jisas ma'e ei toweriye, “Ne ane ne so'oruwe awere?” Sosu Jisas itiya'u eiye, “Ane tu ne me owarape unahi sahe siye onuwe. Mo'o, Filip lai ne ei aniye.” ");
INSERT INTO sny_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Sosu Nataniel le ma'e eiye, “Atuatu siye meni, ne Owane Sitewi lo meni eime tene! Ne Israel lo meni owane tutawe tene!” Mt 14:33; 16:16; Mk 3:11 ");
INSERT INTO sny_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Sosu Jisas itiya'u apou eiye, “Ne peri ano wanu tote anite tawesiye. Piyene awere? Ane ne me owarape, unahi sahe onuteye ape, siye so'oruweye. Wiyawi ape erasi pefine a'i ne. Nowe mo'o su, ne etiri pefine a'i tomu ne'ese siyerowa.” ");
INSERT INTO sny_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Sosu le tame te'eye, “Ane ne ma'e peri wiyeme a'i au te'esiya. Ne ni'arawe werese tou erauwiyei siyerowa. Serai ne Owane Sitewi lo ipari wisere a'i tamo meni hire ma'e itorai ape, ma'e hire wirowa, sosu hi itorairowa. Ane lai meni hire ma'e itorai ne.” Stt 28:12 ");
INSERT INTO sny_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Nowe hesi i tepa'asiye su, meni ta menitani, naituwe ape, omo Kana pani Galili sahe henerai. Jisas lo mai sato iroteye. ");
INSERT INTO sny_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jisas lu disaipel lo aiwawe a'i menitani naituwei ma'e einarai. ");
INSERT INTO sny_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Sosu a'i pe wain sa'i ariye su, Jisas lo mai le ma'e eiye, “Wain sa'i werese ariye.” ");
INSERT INTO sny_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Sosu Jisas itiya'u eiye, “Ne wiyawi eite ane irowei ne owe ape ei towerire. Nowe ano henerai ta'ama. Nowe ape se ane wiyawi ano irorowata.” Jo 7:30; 8:20 ");
INSERT INTO sny_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Sosu Jisas lo mai wiyawi yahowa'i ta'ane siye lu ma'e eiye, “Etiri werese, Jisas fene ma'e te'eyei ape, fa irore.” ");
INSERT INTO sny_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Sosu a'i pe tapiye pa'are ereti feni werese feni ta'i (6) sato iroteye. Juda lo lu lowe ta'u tapiye pa'are sa'i se ereti lowe au huteye. Tapiye pa'are ta'i (100 lita) sa'i se iroteye. ");
INSERT INTO sny_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Sosu Jisas wiyawi yahowa'i ani ta'ane siye lu ma'e au te'eye, “Fene sa'i wara'i tapiye pa'are sahe teroso asi aiwawe ere.” Sosu lowe sa'i wara'i teroso asi aiwawe teme'eriye fuwe. Ahi ta'o teme'eriyeye. ");
INSERT INTO sny_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Sosu le lowe ma'e eiye, “Fene sa'i tewi a'i sa'i pa'are sahe anire. Ayei meni owane ma'e aiti.” Sosu lowe sa'i tewi a'i sa'i pa'are sahe aro aniye, ayei meni owane ma'e aiti. ");
INSERT INTO sny_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Sosu ayei meni owane a tepa'asiye su, sa'i wara'i wain sa'i wisere a'i henerai. Le wain sa'i ape so'oru ta'ama. Ahowa, wiyawi yahowa'i ta'ane siye lu, sa'i aniye ape, wain sa'i henerai so'oruweye tene! Sosu ayei meni owane meni naituwei feni yaro ei aniye. Sosu eiye, ");
INSERT INTO sny_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Wain sa'i eite wisere a'i tene! Lu taune werese lowe ma'e wain sa'i wisere a'i tu au none isafiyeye. Sosu lowe wain sa'i anamiteye su, lowe meremereye a'i henerai. Sosu lu taune meremereye a'i ironamiye su, ayei meni owane werese wain sa'i luwaru a'i au none isafiyeye. Ahowa, ne lai wain sa'i wisere a'i mo'o au nonetiye.” ");
INSERT INTO sny_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Sosu a'i pe wiyawi erasi pefine a'i ape Jisas lai tutawe ta'aneteye. Wiyawi erasi pefine a'i tere'e ape Jisas lai wiyawi lo se Owane Sitewi lo kairefi a'i se au atuatuteye. Le yaru ape omo Kana, pani Galili sahe ta'aneteye. Serai le ta'aneye su, le mi erasi lo au atuatuteye. Sosu lu disaipel lo le ne tote tawesiteye. ");
INSERT INTO sny_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Sosu nowe mo'o Jisas, mai lo, pa'ise tamo, lu disaipel lo aiwawe omo Kana arunatiyewe, omo Kaperneam oweirai. Omo ape sahe lowe nowe oso a'i tamo howeiteye. Mt 4:13 ");
INSERT INTO sny_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Sosu a'i pe nowe Juda lo ta'uwe hereiyei tutawe atahe a'i heneraiyei, iyape Pasova. Sosu Jisas omo Jeusalem ma'e yaneye. Kis 12:1-27 ");
INSERT INTO sny_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Lowe Owane Sitewi lo wesi awei wonopu wiye su, le lu tamo, etiri tomu ne'ese ani hese eteteye ape, siyeye. Lu tamo fe bulmakau, fe sipsip, irowe sapuwe au hese eteye. Lu tere'e tamo metei sahe onuwewe, ma'aru erei aniteye. ");
INSERT INTO sny_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Serai le wafei wisu ta'aneye su, le lu werese fe sipsip, fe bulmakau aiwawe na'ari fiyari heneye. Le ma'aru werese lo ani teroso fiyarisawi. Sosu metei werese lo ani awetosawi. ");
INSERT INTO sny_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Sosu le lu, irowe sapuwe au hese eteye ape, ma'e eiye, “Fene irowe werese hene na'ari fiyarire! Fene Owane Sitewi Tai Pefine a'i ano lo wesi owe ape au hese eterowata.” ");
INSERT INTO sny_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Jisas lo lu disaipel yo seni lo ape siyeye su, lowe Owane Sitewi lo one towe peri marepi tote tawesiye, apou leseye, “Ane Owane Sitewi lo wesi marepi erasi a'i totenamisiya. Serai ane Owane Sitewi lo wesi aseyaro wara'i a'i au irowei.” ");
INSERT INTO sny_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Sosu a'i pe lu Juda le ma'e apou te'e toweriye, “Piye wiyawi ta ne nomo ma'e au atuatuwei awere? Eiwerai ne ma'e kairefiyeyei ape auwe awere? Serai ne etiri werese au sasarisawi.” ");
INSERT INTO sny_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Sosu Jisas itiya'u eiye, “Fene Owane Sitewi lo wesi eite tapeti towesiyei su, ane poweiye hesi heta si tame sine ta'aneyei.” Mt 26:61; 27:40 ");
INSERT INTO sny_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Sosu Juda lo lu itiya'u apou ei toweriye, “Sawi amou! Owane Sitewi lo wesi eite nowe iyu menei lu hesi werese ereti feni werese feni ta'i a'i (46 iyu menei aiwawe a'i) ta'anenamiteye. Sosu ne wesi eite poweiye hesi heta sine ta'aneye awere? Ahowa.” ");
INSERT INTO sny_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ahowa, Jisas lo marepi apou a'i toteye, “Wesi eite apou wou a'i tahe pa'are lo si tame sinerowa.” 1 Ko 6:19 ");
INSERT INTO sny_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Jisas mo'o temeniyeyei su, lu disaipel lo etiri werese ape mo, Jisas te'eye ape, tote tawesirowa. Sosu lowe, Owane Sitewi lo peri leseye ape, sosu Jisas lo peri wanu tote anite tawesiteye. Lu 24:6-8; Jo 12:16 ");
INSERT INTO sny_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Sosu a'i pe Jisas omo Jerusalem sahe Juda lo ta'uwerai hereiyei tutawe onuwe su, lu taune tomu ne'ese etiri wisere a'i tere'e wiyawi siyeye. Serai lowe iyape lo se tote tawesinamiye. Jo 7:31 ");
INSERT INTO sny_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ahowa, Jisas lu taune werese lo marepi so'oruweye tene! Serai le marepi lowe lo ma'e anite tawesirowata. ");
INSERT INTO sny_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Jisas lu taune lo marepi siye so'oruweye. Serai lu taune ta lu lo yo seni au te'e areiye su, le peri lowe lo wanurowata. ");
INSERT INTO sny_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Sosu a'i pe meni ta'i, Farisi lo meni owane, iyape Nikodemus. Le Juda lo meni owane ne. Jo 7:50; 19:39 ");
INSERT INTO sny_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Pasi a'i su, le Jisas ma'e sewiyeyei ne fai. Le Jisas ma'e apou eiye, “Atuatu siye meni, Nomo ne ne te'e atuatu siye meni, Owane Sitewi ma'e fai ape, so'oruweye. Wiyeme a'i! Owane Sitewi lai lu mase iro ta'ame su, lowe wiyawi erasi pefine a'i eite mo irorowata.” ");
INSERT INTO sny_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Sosu Jisas itiya'u apou eiye, “Ane peri wiyeme a'i ne ma'e au te'esiya. Lu taune tamo eimane he'i tame wou henerai ta'ama su, lowe Owane Sitewi lo omo hire ma'e siyerowata.” Mt 18:3; 1 Pi 1:23 ");
INSERT INTO sny_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Sosu Nikodemus itiya'u eiye, “Ahowa, lu tamo ya'ariyei irosiya su, lowe eimane he'i henerairowata. Wiyeme a'i! Le mai lo lire papu si tame wirowata. Serai mai lai meni ya'ariyei tame auteirowata.” ");
INSERT INTO sny_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jisas itiya'u eiye, “Ane peri wiyeme a'i ne ma'e au te'esiya. Mai tamo lai eimane autei ta'ame su, sosu aiwawe, Owane Sitewi lai le ma'e marepi hepene he'i au ta'ame su, le Owane Sitewi lo omo hire ma'e wirowata. Esr 36:25-27 ");
INSERT INTO sny_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Menitani ta eimane lo auteiyei su, eimane ape tahe pa'are heneraiyei. Owane Sitewi lo Hepene Wara'i meni ta papu wiraiyei su, meni ape marepi hepene he'i a'i aniyei. Le Owane Sitewi lo Hepene Wara'i a'i ma'e auteiyei. Jo 1:13 ");
INSERT INTO sny_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ne peri ano wanuwe su, ne eimane he'i tame heneraiyei. Ne hepene se owe ape su'ari hemirehemiye. ");
INSERT INTO sny_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Lu tamo Owane Sitewi lo Hepene Wara'i a'i ne totesiya. Le eiwerou ma'e fai awere? Owane Sitewi lo Hepene Wara'i a'i, fiyaru aiwawe a'i ne. Fiyaru lai marepi topo lo isiya aiyesiya. Sosu ne fiyaru no'u wanusiya. Sosu fiyaru eiwerou ma'e fi awere? Eiwerou ma'e fai awere? Serai lu taune apou a'i Owane Sitewi lo Hepene Wara'i a'i auteisiya. Lu lai lowe ne apou totesiya, Eiwerou ma'e fai awere?” ");
INSERT INTO sny_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Sosu Nikodemus itiya'u ei toweriye, “Etiri ape mo eiwerou piye heneraiyei awere?” ");
INSERT INTO sny_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jisas itiya'u eiye, “Ne Juda lo atuatu siye meni tene! Serai ne etiri ape mo wanu so'oruwe ta'ama awere? ");
INSERT INTO sny_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ane ne ma'e peri wiyeme a'i au te'esiya. Nomo peri ta au te'e fiyarisiya su, etiri werese, nomo au te'eyei ape, nomo ani so'oruwesiya tene! Sosu etiri ta nomo siyeye ape, nomo au te'eyei. Ahowa, fene werese peri nomo lo wanu tote tawesi umasiyei wou ta'ama. ");
INSERT INTO sny_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ane ne ma'e etiri werese, awei sahe irosiya ape, au te'esiya su, ne peri ano ape wanu anite tawesi wou ta'ama. Serai etiri tamo, hire ma'e irosiya ape, ane ne ma'e au te'esiya su, ne eiwerou tote eti aniyei awere? Ahowa. ");
INSERT INTO sny_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Lu taune werese Owane Sitewi lo omo ma'e wi ta'ame. Ahowa, meni ta'i Owane Sitewi mase ironamiteye. Meni ape omo hire ma'e itorai. ");
INSERT INTO sny_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Tu naifa weriyei Moses lai haru aimesi lo nihari se metei sahe ape leseye. Le haru ape ipo yahowa'i a'i ma'e ani sineye. Apou aiwawe a'i meni omo hire ma'e itorai ape, lu tamo le me tape'i sahe fa ani sineyei. Nam 21:9; Jo 8:28; 12:32 ");
INSERT INTO sny_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Serai lu taune werese meni ape ne tote wanu tawesisiya su, Owane Sitewi lai lowe ma'e marepi hepene he'i aurowa. Serai lowe mi mi pasi pasi weriyei ironamirowa. Jo 20:31 ");
INSERT INTO sny_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Sosu a'i pe Owane Sitewi lai lu taune werese, awei irosiya ape, marepi erasi a'i tote wawesiyenamisiya. Serai le meni eime ta'i topo lo a'i hi awei ma'e nomo ne au temeniyeyei ne eimawesai. Lu taune tamo le ne tote tawesi umasiyei su, Owane Sitewi lai lowe ma'e mi mi pasi pasi weriyei marepi hepene he'i aurowa. Sosu lowe temeniyenamirowata. Jo 3:36; 10:28; Ro 5:8; 8:32; 1 Jo 4:9-10 ");
INSERT INTO sny_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Owane Sitewi lai meni eime topo lo a'i hi awei ma'e eimawesai su, eime lo lu taune werese omo yehe ma'e eimawesawiyei ne aiye ta'ame. Ahowa, le meni eime topo lo lu taune werese ma'e marepi hepene he'i ne auwei ne eimawesai. Lu 19:10 ");
INSERT INTO sny_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Lu taune werese le ne tote tawesi umasiyei su, le yo seni luwaru a'i lowe lo au heserowata. Lu taune werese le ne tote tawesi ta'ame su, lowe a'i lai marepi towafi lowe lo umasiyei. Serai lowe omo yehe ma'e irowa. Jo 5:24 ");
INSERT INTO sny_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Lu taune tomu ne'ese yehe ma'e irowa. Marepi sitewi apou a'i te'esiya, ‘Ane a'i lai mi erasi a'i ne.’ Ane hi awei ma'e itorai su, lu taune tomu ne'ese lowe ane me'iyeni ma'e atati tei awetowe. Serai lowe yo seni luwaru a'i mi mi werese ironamiteye! Lowe werese pasi a'i uweitereme. Jo 1:5,9; 8:12 ");
INSERT INTO sny_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Lu taune werese yo seni luwaru a'i irowei ape, lowe mi erasi ai marepi ironamiyei. Lowe ane ma'e, mi erasi ape, aiye ta'ame. Lowe mi erasi aiyeyei su, lowe apou toteyei, ‘Mi erasi ape yo seni luwaru werese nomo lo amerame a'i au atuatuwei.’ ");
INSERT INTO sny_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Sosu lu taune tamo peri wiyeme a'i umasinamiyei su, lowe ane, mi erasi ape ma'e aiyerowa. Lowe ane ma'e aiyeyei su, Owane Sitewi lai yo seni wara'i werese a'i lowe lo lu taune ma'e au atuatu fiyariyei. Lu taune yo seni wara'i a'i lowe lo siyeyei su, lowe apou au te'eyei, ‘Lu taune ape mo lowe Owane Sitewi ma'e fai.’” ");
INSERT INTO sny_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Sosu a'i pe etiri ape mo te'e tepa'asiye su, Jisas lu feni aiwawe a'i, lowe omo pani Judia ma'e si tame fai. Lowe henerai su, Jisas lu feni mase iroteye. Le lu taune tamo sa'i se au huteye. Jo 4:1-2 ");
INSERT INTO sny_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Sosu Jon sa'i au hu siye meni, le lu taune tamo sa'i au huteye. Le sa'i Ainon omo Salim atahe a'i ne, sa'i au huteye. Omo ape sahe sa'i tomu ne'ese iroteye. Lu taune tomu ne'ese Jon ma'e sa'i au ani huwei ne fai. ");
INSERT INTO sny_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Nowe ape se meni owane Herot lai Jon kalabus wesi ma'e heneti ta'ame. ");
INSERT INTO sny_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Sosu a'i pe Juda lo meni ta Jon lo lu feni ma'e ai peri te'e tiyatiyei ne fai. Lowe apou ai peri te'e tiyatiye, “Meni sa'i au ani huteyei su, le marepi amerame a'i heneraiyei awere? Piyete awere?” ");
INSERT INTO sny_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Sosu lowe Jon ma'e ei toweriyei ne fai. Lowe apou ei toweriye, “Atuatu siye meni, meni ape ne mase, Sa'i Mai Jordan yaro ma'e iroteye ape, ne le ne au te'e fiyariye. Siyere! Lu taune tomu ne'ese le ma'e aiyesiya. Sosu le lowe sa'i au husiya.” ");
INSERT INTO sny_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Sosu Jon lowe ma'e itiya'u eiye, “Owane Sitewi lai meni ta ma'e wiyawi ta hire ma'e fai ape, auwei ta'ama su, le wiyawi lo anirowata. ");
INSERT INTO sny_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Fene peri ano wanu tepa'asiye. Ane peri ape apou au te'e fiyariye, ‘Ane a'i lai Krais se ta'ame ne. Ahowa, Owane Sitewi lai ane tu le ne au te'e fiyariyei ne eimawesai.’ Jo 1:20; Mt 11:10 ");
INSERT INTO sny_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Peri anowe ano wanure. Meni ta lai menitani lo naituwei su, meni ape menitani lo hene aniyei. Yereme lo meni ape lo peri no'u wanuwei su, le lowesi ne marepi wisere a'i au toteyei. Ane aiwawe a'i ne. Ane Jisas lo peri wanuwe su, ane le ne marepi wisere a'i au toteye. Marepi wisere a'i ano erasi pefine a'i ne. ");
INSERT INTO sny_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Meni ape iyape erasi a'i fa heneraiyei. Ane a'i lai iyape ano hi ani ararore.” ");
INSERT INTO sny_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Jon Jisas ne apou te'eteye, “Meni ape, hire ma'e itorai ape, le lu taune werese hi ani ararowe. Ane, awei ma'e fai ape, ane awei sato ironamiye. Sosu ane awei lo peri ne au te'enamiye. Meni ape, hire ma'e itorai ape, le lu taune werese hi ani araronamiye. Jo 8:23 ");
INSERT INTO sny_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Etiri werese meni ape lai siyeye, sosu wanuwe. Etiri ape mo le lu taune werese ma'e au te'e fiyariye. Sosu lu taune werese peri lo wanuwe su, lowe peri eti lo so'oru ta'ama. Jo 3:11 ");
INSERT INTO sny_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Lu taune werese peri lo wanu tote tawesi umasiye su, lu taune tere'e yo seni lowe lo siyeyei. Yo seni lowe lo siyeyei su, lowe apou au te'e fiyariyei, ‘Owane Sitewi a'i lai wiyeme a'i tene.’ ");
INSERT INTO sny_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Serai Owane Sitewi lai meni ape hi ma'e eimawe arosai. Le a'i lai Owane Sitewi lo peri werese au te'e fiyarisiya. Meni ape hi ma'e itorai su, Owane Sitewi lai le ma'e Hepene Wara'i a'i lo auwe. Sosu Owane Sitewi lo Hepene Wara'i meni ape lo marepi teme'eriye ironamiyei. ");
INSERT INTO sny_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Owane Sitewi Tai Pefine a'i meni eime lo marepi erasi a'i au totenamisiya. Le a'i lai etiri werese meni eime lo ma'e auwe. Serai meni eime lo etiri werese ape mo au noweinoweinamiyei. Mt 11:27; Jo 5:20 ");
INSERT INTO sny_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Lu taune tamo meni eime lo peri wanu tote tawesi umasiyei su, le lowe ma'e marepi hepene he'i a'i auwei. Sosu lowe mi mi pasi pasi weriyei ironamitorowa. Sosu lu taune tamo Owane Sitewi lo meni eime lo peri wanu umasi ta'ame su, lowe marepi hepene he'i a'i anirowata. Ahowa, Owane Sitewi lo ai marepi lowe ma'e ironamirowa.” Jo 3:16-18; 1 Jo 5:12 ");
INSERT INTO sny_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","Nowe ta se a'i pe meni ta iyape Jon, lu taune tamo sa'i au huteye. Sosu Jisas lu taune tomu ne'ese sa'i au huteye Ahowa, Jisas lai lu taune ma'e sa'i au hu ta'ame. Ahowa, lu disaipel lo lowe ma'e sa'i au huteye. Sosu, lu tewi iyape Farisi lowe apou wanuwe, “Jisas lai lu taune tomu ne'ese sa'i au huwewe, Jon lu taune Jisas lo sa'i ani hu tepa'asiye ape, lowe Jisas lo lu disaipel henerai. Sosu Jon lu taune oso a'i sa'i au huwe. Jisas lai Jon ma'e hi ani ararowe.” Jo 3:22 ");
INSERT INTO sny_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Lu Farisi peri ape au te'eye. Sosu Jisas peri lo ape wanuwe su, le marepi lowe lo apou toteye, “Nomo omo pani Judia pei arunatiyei.” Sosu lowe pani Judia arunati fi. Lowe omo pani Galili ma'e heneri. ");
INSERT INTO sny_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Sosu omo pani Galili henerai su, lowe omo pani Samaria fa awera'iyenati. ");
INSERT INTO sny_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Serai le lu feni aiwawe a'i, pani Samaria sahe iteye. Sosu lowe omo iyape Saika ma'e heneri. Saro ahe atahe a'i tu naifa meni Jekop awei pani tewi a'i meni eime lo Josep ma'e auwe. Stt 33:19; Jos 24:32 ");
INSERT INTO sny_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Awei pani ape sahe, Jekop pitomuwe ta'i horuseye. Sosu Jisas lu disaipel lo aiwawe a'i eyeri erasi ma'e iteye. Sosu lowe pitomuwe ape heneri su, le tahe onota'ano a'i iroteye. Le lu disaipel lo omo Saika ma'e eimawesawi. Lowe ayei eteyei ne fi. Sosu Jisas pitomuwe lo tapiye sahe onuteye. Poweiye ponei a'i iroteye. ");
INSERT INTO sny_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Jisas saro woto a'i onuteye. Lu disaipel lo omo Saika ma'e ene ayei eteyei ne fi. Sosu Jisas sato onuteye su, Samaria lo menitani ta sa'i pitomuwe ma'e heneraiyewe, sa'i pitomuwe ma'e sa'i aniyei ne fai. Jisas menitani ape siyeye su, le menitani ape ma'e eiye, “Sa'i ane ausa. Ane sa'i wawe mase ne.” ");
INSERT INTO sny_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Samaria lo menitani Jisas lo peri wanuwe su, serai le Jisas ma'e apou ei toweriye, “Ne Juda lo meni tene! Ane Samaria lo menitani. Ne piyene sa'i ausaiyei ne ei toweriye awere?” Menitani peri ape apou te'eye. Piyene awere? Juda lo lu taune Samaria werese ma'e ai marepi totenamiteye. Esr 4:1-5 ");
INSERT INTO sny_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Sosu Jisas menitani ma'e itiya'u apou eiye, “Ne sa'i tere'e Owane Sitewi ne ma'e auwei ape so'oru ta'ama. Aiwawe a'i, ne meni eite, sa'i ausaiyei ne ei toweriyei ape so'oru ta'ama. Ne peri ape wanu so'oruweyei su, ne meni eite apou ei toweriyei, ‘Owane Sitewi lo sa'i ausa.’ Serai ane Owane Sitewi lo sa'i ne ma'e aurowa. Serai ne mi mi pasi pasi weriyei ironamitorowa.” Jo 7:37-38; KTH 21:6 ");
INSERT INTO sny_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Sosu menitani ape apou eiye, “Meni Owane, wahu no ariye. Pitomuwe hi yaro a'i tene! Ne sa'i tamo sa'i pitomuwe sahe anirowata. Ne piye ma'e Owane Sitewi lo sa'i aniyei awere? Serai ane ayei su, ane mi mi pasi pasi ironamitorowa. ");
INSERT INTO sny_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Tu naifa weriyei Jekop ya'ariyei nomo lo sa'i pitomuwe eite horuseye. Le meni eime lo aiwawe a'i sa'i pitomuwe aro aniye, sosu sa'i aye. Le fe bulmakau, fe sipsip werese lo sa'i pitomuwe ma'e fai ape au aye. Nomo pereye sa'i hi aro ani anamisiya. Jekop meni owane erasi a'i ne. Serai ne meni owane wiyeme a'i henerai awere? Ne a'i lai Jekop hi ani ararowe awere? Wawero tene!” Jo 8:53 ");
INSERT INTO sny_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Sosu Jisas itiya'u apou eiye, “Jekop lo sa'i ne, lu taune werese lai sa'i eite ayei su, lowe sa'i si tame anamirairowa. ");
INSERT INTO sny_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ahowa, lu taune tamo Owane Sitewi lo sa'i, ane lowe ma'e auwei ape, lowe ayei su, lowe si tame arowata. Ahowa, lowe mi mi pasi pasi weriyei arowata. Ahowa, Owane Sitewi lo sa'i, ane auwei ape, peri apou wou a'i sa'i pitomuwe lowe papu sa'i teisainamisiya. Sosu marepi hepene wisere a'i mi mi pasi pasi weriyei ironamitorowa.” Jo 6:35 ");
INSERT INTO sny_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Sosu menitani le ma'e eiye, “Owane, ne ane ma'e sa'i eite ausa. Serai ane sa'i wawe tame teriterowata. Aiwawe a'i, ane sa'i pitomuwe ma'e sa'i hi aro anirowata.” Menitani peri apou a'i te'eye, serai le Jisas lo marepi so'oru ta'ama. ");
INSERT INTO sny_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jisas le ma'e apou eiye, “Menitani ire! Ne meni no ei hene aiserirowawe si tame aiye.” ");
INSERT INTO sny_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Sosu menitani ape le ma'e itiya'u eiye. “Ane meni se ta'ama.” Sosu Jisas le ma'e eiye. “Peri no wiyeme a'i ne. ‘Ane meni se ta'ama!’ ");
INSERT INTO sny_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Wiyeme a'i ne. Lu ereti feni werese ne naituwe. Sosu meni ape, ne mase irosiya ape, le meni no ta'ama. Peri no wiyeme a'i tene!” ");
INSERT INTO sny_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Sosu menitani le ma'e itiya'u eiye, “Owane Sitewi, marepi ano apou a'i totesiya, Ne a'i lai Owane Sitewi lo peri au te'e siye meni. ");
INSERT INTO sny_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ya'ariyei nomo lo omo eire sahe Owane Sitewi ma'e au te'e nine'i wisereyenamisiya. Ahowa, fene Juda lo lu werese apou te'esiya, ‘Lu taune werese omo Jerusalem a'i sahe Owane Sitewi ma'e fa au te'e wisereyere.’” Lo 12:5-14; Sng 122:1-5 ");
INSERT INTO sny_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Sosu Jisas itiya'u eiye, “Menitani, peri ano wanu tote tawesire! Nowe ta aiyeyei su, lu taune werese omo eire ma'e, sosu omo Jerusalem sahe Owane Sitewi Tai Pefine a'i ma'e au te'e wisereyerowata. ");
INSERT INTO sny_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Fene omo Samaria lo lu taune etiri ape ma'e au te'e wisereyesiya ape, fene le so'oru ta'ama. Nomo Owane Sitewi wiyeme a'i so'oruwesiya. Serai nomo le ma'e au te'e wisereyesiya. Serai Owane Sitewi lai marepi hepene he'i a'i le lu taune werese ma'e aurowa. Marepi hepene he'i a'i lai Juda lo lu tewi ma'e fai. 2 Kin 17:29-41; Ais 2:3; Ro 9:4-5 ");
INSERT INTO sny_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Wiyeme a'i ne. Nowe ta aiyeyei. Ahowa, nowe eite henerai tepa'asiye. Lu taune werese Owane Sitewi Tai Pefine a'i ma'e wiyeme a'i au te'e wisereyesiya ape, lowe peri wiyeme a'i au te'e wisereyesiya. Sosu marepi lo se Owane Sitewi ma'e au te'e wisereyesiya. Lu taune Owane Sitewi ma'e apou au te'e wisereye irosiya su, Owane Sitewi Tai Pefine a'i lai lowe ne marepi wisere a'i totenamisiya. ");
INSERT INTO sny_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Owane Sitewi a'i lai hepene ne. Lu taune werese le ma'e umasisiya ape, lowe le ne hepene se lowe lo pei au ei ani arowere. Sosu peri wiyeme a'i se au te'e wisereyesiya.” 2 Ko 3:17; Ro 12:1; Fl 3:3 ");
INSERT INTO sny_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Sosu a'i pe menitani eite le ma'e eiye, “Meni ape, Owane Sitewi lai ariariye ape, aiyerowa! Ane peri wiyeme a'i eite so'oruwesiya tene! Meni ape aiyeyei su, le etiri werese nomo ma'e au te'e areiyeyei.” Meni ape lo iyape Krais. ");
INSERT INTO sny_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Sosu Jisas le ma'e itiya'u eiye, “Ane meni ape, ne ma'e au te'esiya ape, ane meni ape tene!” Mk 14:61-62 ");
INSERT INTO sny_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Sosu a'i pe Jisas peri tepa'asiye su, lu disaipel lo henerai. Sosu lowe hepene se su'ariye. Piyene awere? Jisas Samaria menitani te'e tiyatiteye. Ahowa, lu disaipel lo peri se ta'ama. Marepi lowe lo apou toteye, “Ne piye nehisiya awere? Ne piyene menitani ape ma'e au te'e tiyatisiya awere?” ");
INSERT INTO sny_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Sosu menitani sa'i pa'are arunatiyewe, omo topo lo ma'e fi. Sosu le lu tamo ma'e Jisas ne au te'eye. ");
INSERT INTO sny_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Sosu a'i pe Samaria lo menitani omo lo ma'e heneri. Sosu le lu tamo ma'e apou eiye, “Peri ano wanure. Fene ane mase aiya. Meni ta yo seni werese ano ane ma'e au te'eye. Meni ape Krais awere? Piyete awere?” ");
INSERT INTO sny_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Sosu lowe menitani lo peri wanuwe su, lowe omo lo arunatiyewe, Jisas ma'e heneri. ");
INSERT INTO sny_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Menitani omo ma'e arunati su, Jisas lo lu disaipel le ma'e apou ei toweriye, “Atuatu siye meni, Ne etiri ta are.” ");
INSERT INTO sny_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ahowa, Jisas itiya'u apou eiye, “Ane ayei tere'e irosiya, fene ayei ape so'oru ta'ama.” ");
INSERT INTO sny_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Serai lu disaipel lo lowe ta'u aiwawe te'e tiyati toweriye, “Meni ta ayei le ma'e au ene aye awere?” ");
INSERT INTO sny_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Sosu Jisas lowe ma'e eiye, “Ayei ano apou wou a'i. Ane Owane Sitewi lo marepi fa umasi irowei. Le a'i lai ane hi awei ma'e eimawe arosai. Serai ane wiyawi lo pei ani tepa'asiyei. Jo 6:38 ");
INSERT INTO sny_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Jisas lu taune werese ne, peri lo wanu tote tawesi umasiyei ne toteye ape, toteye. Fene marepi fene lo apou totesiya, ‘Nowe yame hesiyo hesiyo i tepa'asiyei su, serai nomo kewi so foro'o a'i tou ani towesiyei.’ Fene siyere! Ane fene ma'e apou eisiya, nihe fene lo ei ani arowere! Kewi so werese foro'o tepa'asiye.” Lu 10:2 ");
INSERT INTO sny_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Sosu Jisas lowe ma'e tame eiye, “Meni ta peri ano au te'e fiyariyei su, le apou aiwawe a'i te'esiya. Le kewi so yehe sameyei ne fi. Meni ta peri au te'e fiyariyei su, lu taune tamo peri lo wanu tote tawesiyei, sosu yo ano umasiyei. Serai lowe marepi hepene he'i a'i teinamirowa. Meni ta Owane Sitewi lo peri lowe ma'e au te'esiya. Sosu meni tere'e ta lowe Jisas lo ereti ani fusiya su, lowesi Owane Sitewi ma'e au te'e wisereyesiya. Apou aiwawe a'i, awei lo wiyawi siye lu kewi so tou ani towesiyei su, lowesi marepi wisere a'i totesiya. Nowe ye'ewi se tepa'asiyei su, Owane Sitewi lowesi ma'e etiri wisere a'i aurowa. ");
INSERT INTO sny_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Peri eite wiyeme a'i tene! Meni ta kewi so yehe sameyei. Sosu meni tere'e kewi so foro'o a'i tou ani towesiyei, wesi ma'e ani fuwei. ");
INSERT INTO sny_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Lu taune tere'e wiyawi erasi a'i se lu taune ma'e peri ano au te'e fiyariye. Sosu ane fene lowe ane ma'e henetaiyei ne eimawesawi. Lowe ane ma'e aiyeteye su, ane lowe ma'e marepi hepene he'i a'i auwe. Serai wiyawi lowe lo ape ne, fene wiyawi lowe lo tewi a'i henerai.” ");
INSERT INTO sny_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Serai omo Saika lo lu tomu ne'ese Jisas lo peri wanuwe. Menitani ape lowe ma'e peri apou te'eye su, “Fene aiya! Meni ta yo seni ano ane ma'e au te'eye ape siyerai.” Lu tomu ne'ese menitani lo peri wanu tote tawesiye. Serai lu taune tomu ne'ese Jisas lo yo umasiye. ");
INSERT INTO sny_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Sosu a'i pe Samaria lu tamo le ma'e henerai. Sosu lowe werese le ma'e apou te'e toweriye, “Ne lu disaipel no aiwawe fara'u nomo mase irote.” Serai lowe Samaria lo lu taune mase poweiye hesi a'i iroteye. ");
INSERT INTO sny_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Jisas lu taune mase iroteye su, le lu taune tomu ne'ese Jisas lo peri wanu tote tawesi umasiye. ");
INSERT INTO sny_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Sosu lu ape mo menitani ma'e eiye, “Ne peri no au te'eye su, nomo meni ape ma'e siyeyei ne fai. Wiyeme a'i ne! Pereye a'i nomo lai peri ape lo wanuwe su, nomo peri lo wanu tote tawesiye. Etiri ape nomo so'oruwesiya tene!” Meni ape lai lu taune werese ma'e marepi hepene he'i aurowa. Serai lowe marepi hepene wara'i a'i mi mi pasi pasi ironamirowa. 1 Jo 4:14 ");
INSERT INTO sny_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Nowe hesi a'i i tepa'asiye su, Jisas lu disaipel lo aiwawe omo Saika arunati, sosu omo pani Galili ma'e heneri. ");
INSERT INTO sny_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Tu naifa Jisas apou au te'eye, “Owane Sitewi lo peri au te'e siye lu werese omo pani towafi lowe lo sahe lu taune lowe ma'e te'e naruwe.” Mt 13:57 ");
INSERT INTO sny_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Tu naifa Jisas lu disaipel lo aiwawe Jerusalem sahe iroteye su, lowe Juda lo ta'uwe hereiyei onu ene aye. Jisas sato iroteye su, le wiyawi wisere a'i au ani ironamiye. Lu taune, omo pani Galili ma'e fai ape, ta'uwe hereiyei sahe iroteye. Lowe Jisas lo wiyawi erasi pefine a'i siyeye. Serai Jisas omo pani Galili ma'e henerai su, lu taune werese le ma'e marepi wisere a'i eriteye. Jo 2:23 ");
INSERT INTO sny_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Sosu a'i pe Jisas omo Kana, pani Galili sahe, ma'e heneri. Tu naifa Jisas lai sa'i wara'i atati ani awetowe. Serai wain sa'i henerai. Sosu omo tere'e iyape omo Kaperneam pani Galili sahe, meni owane erasi a'i ta iroteye. Meni eime lo u tahe erasi a'i ya'orenamiteye. Temeniyeyei ne ataheyeteye. Jo 2:1-11 ");
INSERT INTO sny_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Sosu meni owane ape Jisas pani Judia arunatiyewe, omo pani Galili ma'e henerai ape wanuwe su, le Jisas ma'e siyerai. Sosu le apou eiye, “Meni Owane, meni eime ano temeniyeyei ne ataheyesiya. Ne wesi ano ma'e aiya. Sosu meni eime ano u tahe au fara'uwere.” Mt 8:5-6 ");
INSERT INTO sny_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Serai Jisas itiya'u le ma'e eiye, “Atu, fene werese wiyawi erasi siyeyei su, fene peri ano fara'u wanu tote tawesiyei. Fene wiyawi erasi siye ta'ame su, fene peri ano awera'iyenatiyei.” Jisas peri apou a'i te'eye. Serai le meni lo marepi ani siye so'oruweye. Jo 2:18; 1 Ko 1:22 ");
INSERT INTO sny_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Meni owane erasi ape le ma'e eiye, “Owane wiyeme, wesi ano itora. Meni eime ano temeniyeyei ne ataheyesiya.” ");
INSERT INTO sny_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Sosu Jisas meni owane ma'e eiye, “Wesi no ire! Meni eime no u tahe tepa'asiye.” Jisas peri tepa'asiye su, meni ape Jisas lo peri wanu tote tawesiye. Serai le wesi topo lo ma'e fi. Mt 8:13 ");
INSERT INTO sny_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Meni owane ape yo sahe iteye su, wiyawi yahowa'i siye lu tamo lo meni ape henerai. Lowe apou eiye, “Owane, meni eime no hepene se. U tahe lo tepa'asiye.” ");
INSERT INTO sny_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Sosu meni owane lowe ma'e apou ei toweriye, “Nowe eiwerou su u tahe tepa'asiye awere?” Sosu lowe itiya'u eiye, “Liyewe neriwei, nowe poweiye po a'i (1 klok) meni eime no u tahe tepa'asiye.” ");
INSERT INTO sny_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Meni eime lo tai wanuwe su, le nowe ape ani so'oruwe tepa'asiye. Nowe ape aiwawe a'i Jisas apou eiye, “Meni eime no u tepa'asiye.” Serai meni owane eite Jisas lo yo umasiye. Sosu noweripi awaripi lo aiwawe a'i Jisas lo marepi umasiye. ");
INSERT INTO sny_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jisas omo pani Judia arunati, pani Galili ma'e henerai. Le wiyawi erasi to'uresi au aniye. Tu le sa'i wara'i wain sa'i ma'e ani awetowe. Nowe ta se i tepa'asiye su, le meni owane erasi lo meni eime u tahe au fara'uweye. Jo 2:11 ");
INSERT INTO sny_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Sosu a'i pe nowe mo'o su Juda lo ta'uwe hereiyei erasi iyape Pasova, henerai. Serai Jisas lu disaipel lo aiwawe a'i omo Jerusalem ma'e yaneye. ");
INSERT INTO sny_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Sosu omo Jerusalem sahe sa'i fisiye erasi saro iroteye. Sa'i fisiye ape fe sipsip lo umaruwe yo atahe iroteye. Umaruwe yo ape fe sipsip si witiye, sosu si tame nowe ma'e henerai. Sa'i fisiye erasi ape Juda lo peri iyape eiye, Betesda. Sa'i fisiye ahi pa'o ereti feni werese iroteye. ");
INSERT INTO sny_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ahi pa'o ape sahe lu taune tomu ne'ese u tahe ya'orei onuteye. Lu tamo nihe pokowe tawesiye. Lu taune tamo lowe luwaru a'i ne. {Lu tamo pa'are lowe lo foro'oweye tahe lowe lo haroharoweye. ");
INSERT INTO sny_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Nowe tase Owane Sitewi lai ipari wisere a'i lo hi sato eimawe arosai. Le sa'i ani auseriye irowe. Sa'i auseriyeyei su, lu taune werese apou toteye, “Meni, menitani ta'i a'i tu sa'i papu wiyei su, u tahe lo fara'uweyei.”} ");
INSERT INTO sny_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Meni ta ahi pa'o saro howeinamiteye. Le iyu menei tomu ne'ese (38) u tahe lo ya'oreinamiteye. ");
INSERT INTO sny_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Sosu a'i pe Jisas sa'i fisiye ape ma'e henerai. Le meni eite, howeiye ape, siyeye su, le meni ape ne u tahe lo se iyu menei tomu ne'ese so'oruweye. Serai le meni ape ma'e apou ei toweriye, “Ne u tahe no henerai tepa'asireme awere?” ");
INSERT INTO sny_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Sosu meni u tahe se itiya'u eiye, “Meni Owane, sa'i auseriyeyei su, ane piye meni ta lai sa'i papu henetirowata. Sa'i auseriyeyei su, meni tere'e tu sa'i papu wiyei. Ane sa'i papu wirowata.” ");
INSERT INTO sny_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Sosu Jisas le ma'e eiye, “Sinere! Mesiye no anirowawe ire!” Mt 9:6 ");
INSERT INTO sny_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Sosu Jisas peri tepa'asiye su, meni ape lo u tahe po'uteye. Sosu le mesiye lo, noweriye ape, aniyewe fi. Jisas meni u tahe se au fara'uweye su, nowe amou (Sabat) iroteye. ");
INSERT INTO sny_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Serai Juda lo lu owane meni u tahe se ape siyeye su, lowe le ma'e ei toweriye, “Ne mesiye no suteyei amou ne. Nowe amou (Sabat) nomo lo ne.” Neh 13:19; Jer 17:21 ");
INSERT INTO sny_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ahowa, le itiya'u eiye, “Meni ape, u tahe ano au ta'ane fara'uweye ape, le apou eiye, ‘Mesiye no anirowawe suteti.’” ");
INSERT INTO sny_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Sosu lowe le ma'e te'e toweriye, “Meni ape eiwerai ne ma'e apou eiye awere? ‘Ne mesiye no suterowawe ire.’ Meni iyape eiwerai awere?” ");
INSERT INTO sny_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ahowa, le meni ape so'oru ta'ama. Jisas u tahe au ta'ane fara'uweye su, le eresene a'i lu taune ponei uweitiye. Lu taune tomu ne'ese saro tei iroteye. ");
INSERT INTO sny_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Sosu mo'o su, Jisas meni u tahe se Owane Sitewi lo wesi sahe siyeye. Le meni ape se apou eiye, “Siyere! U tahe no po'uteye. Ne seni luwaru a'i owe ape irote! Yo seni luwaru a'i owe ape umasite. Ne etiri luwaru a'i owe ape irote. Yo seni luwaru a'i umasiyei su, etiri luwaru erasi a'i ne ma'e ya'orenamirowa.” ");
INSERT INTO sny_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Sosu meni ape fi. Le Juda lo lu owane siyeye su, le lowe ma'e eiye, “Jisas lai u tahe ano ane au ta'ane fara'uweye.” ");
INSERT INTO sny_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Jisas nowe amou (Sabat) se meni au ta'ane fara'uweye su, Juda lo marepi apou a'i toteye, “Jisas lai nowe amou (Sabat) towesiye.” Serai Juda lo lu owane Jisas ma'e ai marepi toteye, sosu le ma'e au luwaruweyei ne toteye. ");
INSERT INTO sny_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ahowa, Jisas itiya'u eiye, “Wanure! Owane Sitewi Tai Pefine a'i ano wiyawi lo ta'anenamisiya. Sosu le ane wiyawi lo ta'aneyei ne eimawesai. Serai ane lai wiyawi lo ani ta'anenamisiya.” ");
INSERT INTO sny_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Jisas peri ape apou eiye su, “Owane Sitewi Tai Pefine a'i ano ne,” Juda lo lu owane le ma'e ai marepi erasi totenamiteye. Lowe Jisas aine tera'eyei ne toteteye. Lowe marepi apou a'i toteye. “Jisas nowe amou (Sabat) towesiye. Etiri ape luwaru a'i ne. Amou a'i ne.” Sosu Jisas apou eiye su, “Owane Sitewi Tai Pefine a'i ano ne. Owane Sitewi Pefine a'i sosu Jisas lowesi aiwawe a'i ne.” Serai lowe ai marepi luwaruweyewe, lowe le ma'e aine tera'eyei ne toteteye. Mt 26:4; Jo 7:1; 10:30 ");
INSERT INTO sny_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Sosu a'i pe Jisas lowe ma'e itiya'u apou eiye, “Wiyeme a'i! Ane fene ma'e eisiya. Kairefiyeyei ano se ane etiri ta irorowata. Ane Owane Sitewi Tai Pefine a'i ano lo wiyawi siyeyei su, ane lai meni eime lo wiyawi ape ane lai fara'u ani ta'aneyei. Tai Pefine a'i ano etiri ta wiyawi ta'anesiya su, ane le ma'e umasirowawe, sosu wiyawi lo aiwawe pati ta'aneyei. Jo 5:30 ");
INSERT INTO sny_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Peri eite wiyeme a'i. Owane Sitewi Tai Pefine a'i lai meni eime lo ne marepi erasi a'i tote wawesiyenamisiya. Etiri werese, Owane Sitewi Tai Pefine a'i ironamisiya ape, le ane ma'e au atuatu areiyesiya. Le wiyawi erasi a'i ta'anerowa, sosu le ane ma'e au atuaturowa. Fene wiyawi erasi a'i lo eite, ane ta'aneyei ape, siyeyei su, fene marepi hepene se su'ariyei. ");
INSERT INTO sny_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Serai Owane Sitewi Tai Pefine a'i ano lu tamo, temeniyeyei ape, si tame ta'ane norohuwe hene aniyei. Sosu lowe ma'e hepene aurowa. Sosu aiwawe ane meni eime lo lu taune tamo ma'e marepi hepene he'i aurowa. Marepi ano a'i ne. ");
INSERT INTO sny_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Peri eite wiyeme a'i. Owane Sitewi Tai Pefine a'i ano lu taune werese au hese etiyei ta'ama. Ahowa, le meni eime lo ma'e yo seni werese, au heseyei ape, ane ma'e auwe. Jo 5:27; Ap 10:42 ");
INSERT INTO sny_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Owane Sitewi Tai Pefine a'i wiyawi eite meni eime lo ma'e auwe. Serai lu taune werese meni meni eime lo iyape ei ani arowesiya. Pereye a'i lu taune werese lowesi lo iyape ei ani arowesiya. Lu taune tamo meni eime lo au te'e wisereye ta'ame su, lowe Owane Sitewi Tai Pefine a'i eime lo, hi awei ma'e eimawesai ape, lowe Tai Pefine a'i aiwawe a'i au te'e wisereye ta'ame. Fl 2:10-11; 1 Jo 2:23 ");
INSERT INTO sny_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Wiyeme a'i ane fene ma'e eisiya. Peri ano wiyeme a'i ne. Lu taune tamo peri ano wanuwei su, sosu le ma'e ane hi awei ma'e eimawe sai ape, lowe peri lo wanu tote tawesiyei su, Owane Sitewi lai lowe ma'e marepi hepene he'i a'i aurowa. Lowe Owane Sitewi lo marepi umasiyei su, Owane Sitewi lai yo seni lowe lo au hese ereiyei ta'ama. Lu taune ape mo temeniye awera'iyenatiyei, sosu mi mi pasi pasi weriyei ironamitorowa. Jo 3:15-18 ");
INSERT INTO sny_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Wiyeme a'i ne! Ane fene ma'e eiwa. Peri ano wiyeme a'i ne. Nowe ta ataheye heneraiwa. Ahowa, nowe eite henerai tepa'asiye. Lu taune werese yo seni luwaru a'i ironamisiya. Lowe Owane Sitewi lo meni eime lo peri no'u a'i wanuwei. Lu taune tamo peri no'u lo wanuwei su, lowe mi mi pasi pasi weriyei marepi hepene he'i anirowa. ");
INSERT INTO sny_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Peri eite wiyeme a'i ne. Owane Sitewi Tai Pefine a'i lai hepene se ironamisiya. Serai aiwawe a'i le meni eime lo ma'e hepene se auwe. Serai meni eime lo lu taune werese ma'e hepene he'i a'i aurowa. ");
INSERT INTO sny_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Sosu aiwawe a'i le a'i lai meni eime lo ma'e kairefi lo se auwe. Serai meni eime lo yo seni werese a'i au hese erei ironamisiya. Ane a'i lai meni ape, hire ma'e itorai ape ne. ");
INSERT INTO sny_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","29","Fene marepi tomu ne'ese owe ape totere. Nowe ta ataheyeraiwa. Lu taune werese, fisiye yo sahe irosiya ape, Owane Sitewi lo meni eime lo peri ahi wanuwei su, lowe werese marepi hepene aniyei, sosu fisiye nowe ma'e heneraiyei. Lu taune werese yo seni wisere a'i iroteye ape, Owane Sitewi lai lowe ma'e si tame norohuwe hene aniyei. Sosu mi mi pasi pasi weriyei tei ironamirowa. Sosu aiwawe lu taune werese, yo seni luwaru a'i iroteye ape, Owane Sitewi lai lowe ma'e si tame hene aniyei. Sosu yo seni werese lowe lo au hese ereirowa. Serai lowe werese mi mi pasi pasi weriyei temeniye ironamitorowa. Dan 12:2; Mt 16:27; Ap 24:15 ");
INSERT INTO sny_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Sosu a'i pe Jisas Juda lo lu owane ma'e au te'eye. Wiyawi ape, ane aniye ape, ane marepi ano umasi tote ta'ame. Ahowa, Ane lu taune lo yo seni au hese ereiyei su, ane Owane Sitewi Tai Pefine a'i ano lo peri wanuwei. Serai yo seni lowe lo werese, ane wisere a'i au hese ereiyei. Ane marepi ano umasi ta'ame. Ahowa, Owane Sitewi ane hi ma'e eimawe arosai ape, ane marepi lo umasinamirowa. Jo 5:19; 6:38 ");
INSERT INTO sny_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ane ta'i a'i yo seni werese ano ne au te'e fiyariyei su, fene marepi ano wawero a'i toteyei. Serai fene ane umasirowata. ");
INSERT INTO sny_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ahowa, meni ta'i tere'e yo seni ano ne au te'e fiyariye. Sosu peri ape, le au te'e fiyariye ape, wiyeme a'i tene. Ane lai so'oruwesiya tene! Serai fene peri lo fa wanure. ");
INSERT INTO sny_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Tu naifa fene lu tamo Jon sa'i au hu siye meni ma'e eimawesawi. Lowe Jon ma'e henerai su, le yo seni ano wiyeme a'i au te'e fiyariye. ");
INSERT INTO sny_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ahowa, marepi ano apou a'i tote ta'ame, ‘Lu tamo yo seni ano au te'e fiyariyei.’ Ahowa, ane fene ma'e peri eite mo au te'esiya, serai fene wanu tote tawesiyei su, ane fene ma'e marepi hepene he'i aurowa. ");
INSERT INTO sny_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Meni ape Jon yehe erei wou a'i ne. Pasi a'i su, yehe erei fu etineyei su, etiri oso oso yehe erei ta'uwerai. Jon apou wou a'i ne. Jon peri au te'e fiyariye su, lu taune tomu ne'ese ta'uwerai, peri lo wanuwe. Nowe oso a'i su, fene Jon lo peri marepi wisere a'i toteye. Pereye fene Jon arunatiyewe, ane mo'o umasisiya. ");
INSERT INTO sny_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Wiyawi ano ne, Owane Sitewi Tai Pefine a'i ano ane hi awei ma'e wiyawi lo ta'aneyei ne eimawe arosai. Le wiyawi lo ane ma'e auwe. Wiyawi ape mo, ane ani ta'aneye ape, wiyawi ape yo seni ano ne au te'e fiyariteye. Fene wiyawi ano siyesiya su, sosu peri ano wanusiya su, fene etiri ape so'oruwesiya tene! Apou a'i Owane Sitewi lai ane hi awei ma'e eimawe arosai. Wiyawi ape lai ane ne au te'e fiyariye ape, Jon lo peri ma'e hi ani fu arowe. Jo 3:2; 14:11 ");
INSERT INTO sny_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Sosu Owane Sitewi Tai Pefine a'i ano, ane hi ma'e eimawe arosai ape, le ane ne peri au te'eye. Mi mi werese werese fene peri no'u lo wanu ta'ame. Sosu aiwawe fene nihari tahe pa'are lo siye ta'ame. Mt 3:17; Jo 5:32; 8:18 ");
INSERT INTO sny_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Sosu aiwawe peri lo ape lai marepi fene lo papu iro ta'ame. Piyene awere? Fene meni ape, le eimawe arosai ape, wanu tote tawesi ta'ame. Sosu fene meni eime lo umasi ta'ame. ");
INSERT INTO sny_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Fene Owane Sitewi lo peri, one towe sahe leseye ape, siyeye ne nehinamisiya su, marepi fene lo apou a'i toteye, ‘Ane Owane Sitewi lo peri siye etinamisiya su, serai ane mi mi pasi pasi weriyei tei ironamisiya.’ Wiyeme a'i Owane Sitewi lo peri, leseye ape, peri ape ane ne au te'e areiyesiya. Fene marepi hepene he'i a'i anireme su, fene ane ne fa tote tawesiyei. Lu 24:27 ");
INSERT INTO sny_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Sosu fene ane ma'e aiyeyei su, ane fene ma'e marepi hepene he'i a'i aurowa. Ahowa, fene ane ma'e aiyeyei wou ta'ama. ");
INSERT INTO sny_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Marepi ano apou a'i totesiya, ‘Lu taune werese iyape ano te'e ani aroweyei wou ta'ama.’ ");
INSERT INTO sny_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ahowa, ane marepi fene lo so'oruwesiya. Fene marepi hepene papu Owane Sitewi ma'e marepi erasi a'i tote ta'ame. ");
INSERT INTO sny_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ane lai Owane Sitewi Tai Pefine a'i ano lo iyape se fai. Ane fai su, fene ane ma'e wisere a'i erite ta'ame. Ahowa, meni ta iyape yahowa'i se irowei ape, le iyape topo lo se aiyeyei su, fene meni ape wisere a'i eriteyei. ");
INSERT INTO sny_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Fene ta'u ta'i ta'i a'i iyape fene lo ei ani aroweye. Fene iyape erasi a'i siye nehi ta'ame. Iyape erasi a'i ape Owane Sitewi woto a'i ma'e fai. Serai fene peri ano wanu tote tawesiyei ta'ama. ");
INSERT INTO sny_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Fene marepi apou owe ape totere, ‘Ane fene lo yo seni Owane Sitewi Tai Pefine a'i ano ma'e fu te'erowa awere?’ Ahowa, ane fene fu te'erowata. Meni ta'i ta yo seni fene lo Tai Pefine a'i ano ma'e fu te'erowa ape, meni ape iyape Moses. Fene Moses lo yo peri umasisiya su, fene apou totesiya. Nomo marepi hepene he'i a'i anirowa. Fene Moses lo yo peri se marepi hepene he'i a'i anirowa awere? Piyete! Wawero a'i ne. Moses lo yo peri yo seni werese fene lo ape ne au hese ereirowa. Serai fene mi mi pasi pasi temeniye ironamitorowa. ");
INSERT INTO sny_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Wiyawi a'i ne, fene Moses lo yo peri wanu tote tawesi umasi ta'ame. Fene Moses lo peri wanu tote tawesiye su, fene ane ne aiwawe a'i tote tawesiyei. Piyene awere? Tu naifa weriyei Moses ane ne apou leseye. Ap 3:22 ");
INSERT INTO sny_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ahowa, fene peri, Moses leseteye ape, wanu tote tawesi ta'ame su, fene peri ano aiwawe a'i wanu tote tawesirowata.” ");
INSERT INTO sny_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Jisas peri tepa'asiye su, le lu feni aiwawe, Hare Ite Galili feni eire ma'e toneri. Hare ite lo iyape tere'e, Taiberias. ");
INSERT INTO sny_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Lowe fi su, lu taune tomu ne'ese mo'o umasiye. Lowe Jisas lo wiyawi erasi a'i siyeyei ne toteye. Lowe Jisas lu taune u tahe se fara'uweye ape siyeyei ne toteye. ");
INSERT INTO sny_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Sosu Jisas omo ta yaneye. Omo ape le lu disaipel lo aiwawe onuwe. ");
INSERT INTO sny_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Nowe ape se, ta'uwe hereiyei erasi ataheyerai. Ta'uwe hereiye iyape Pasova. ");
INSERT INTO sny_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Lu taune tomu ne'ese Jisas ma'e ta'uwerai su, Jisas nihe se lowe werese siyeye. Sosu le Filip ma'e apou ei toweriye, “Eiwerou ma'e nomo ene nau eteyei awere? Serai nomo lowe ma'e au ene ayei awere?” ");
INSERT INTO sny_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jisas Filip ma'e eiye su, le marepi topo lo so'oruweye. Le a'i wiyawi, eiwerou ta'aneye ape, so'oruwe tepa'asiye. ");
INSERT INTO sny_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Sosu Filip itiya'u eiye, “Eiwerou ma'e ma'aru tomu ne'ese aniyei awere? Nomo ma'aru (200) aniyei su, nomo ayei tamo eterowata. Nomo ayei eteyei su, lu taune werese ayei oso a'i lire lowe lo teme'eriye ta'ame.” ");
INSERT INTO sny_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Sosu meni tere'e iyape Andru, Saimon Pita lo pa'ise apou au te'eye, ");
INSERT INTO sny_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Siyere! Meni eime oso a'i nau ta'ase oso a'i ereti feni werese hare hesi a'i aitai. Etiri eite mo lu taune ma'e au arowata.” ");
INSERT INTO sny_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Sosu Jisas lu feni ma'e eiye, “Fene lu taune werese ma'e ei onure.” Omo ape sahe senarepe tomu ne'ese irowe. Lu taune werese senarepe sahe onuwe. Lu tomu ne'ese saro onuwe (5,000 aiwawe a'i). ");
INSERT INTO sny_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Lu taune werese onuwe su, Jisas nau ta'ase ereti feni werese ereti se aniye. Sosu le Owane Sitewi ma'e au te'e wisereyeye su, le lu disaipel lo ma'e auwe. Sosu lu disaipel lo lu taune werese ma'e, onuwe ape noneti. Nonetinauwe, nonetainauwe, lu taune werese lire lowe lo teme'eriyeye. Sosu le hare hesi a'i ereti lo se aniteye su, le Owane Sitewi ma'e au te'e wisereyeye. Sosu au ayei ne nonetiye. ");
INSERT INTO sny_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Sosu lu taune werese a tepa'asiye, lire lowe lo werese teme'eriyeye. Sosu Jisas lu disaipel lo ma'e eiye, “Fene ayei tewi a'i tewi a'i werese ani ta'uweye. Sosu etiri tamo foruwe irorowata.” ");
INSERT INTO sny_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Sosu lowe ayei tewi a'i tewi a'i ta'uwe anirowawe, ipi erasi ani fuwe. Sosu nau ta'ase tewi a'i hare tewi poruwe iroteye ape, si ipi papu ereti feni hesi lowe hesi a'i (12) ani asi teme'eriyeye. ");
INSERT INTO sny_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Serai lu taune werese Jisas lo wiyawi erasi a'i siyeye su, lowe apou eiye, “Etiri eite wiyeme a'i ne. Meni eite lai Owane Sitewi lo au te'e siye meni ape nomo ninawesiya ape, Owane Sitewi lai le awei ma'e eimawe arosai.” ");
INSERT INTO sny_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Sosu a'i pe Jisas lowe marepi ani so'oruweye. Marepi lowe lo apou a'i toteye. Lowe Jisas ereti tore ni'ari aniyei ne toteye. Sosu lowe le owane tutawe lowe lo hene ani irowei. Serai Jisas woto a'i omo hire ma'e si tame yaneye. Jo 18:36 ");
INSERT INTO sny_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Sosu a'i pe nowe pasiyeye su Jisas lo lu disaipel le omo sahe arunatiyewe, hare ite ma'e si tame itori. Lowe hare ite feni eire ma'e toneriyei ne totesiya. ");
INSERT INTO sny_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Lowe wai papu wi onuwe su, lowe hare ite omo Kaperneam ma'e toneriyei ne toteye. Sosu pasiyeye. Jisas lowe mase fi ta'ama. ");
INSERT INTO sny_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Lowe hare ite ponei sahe iroteye su, fiyaru erasi, sa'i ei aiwawe a'i henerai. ");
INSERT INTO sny_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Lowe wai iyatunauwe, iyatunauwe ponei ma'e iyatunauwe. Sosu iyatu fofoteye. Nihe siye aroweye su, sawi amou! Lowe Jisas sa'i hire awesetaiteye siyeye. Lowe Jisas sa'i hire awesetaite siyeye su, lu disaipel lo marepi taweiru erasi a'i toteye. ");
INSERT INTO sny_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Sosu Jisas lowe ma'e eiye, “Taweiru sawa! Ane lai ne.” ");
INSERT INTO sny_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Sosu lowe marepi fetane a'i toteye su, lowe apou eiye, “Wai papu wira.” Sosu Jisas wai papu wirai su, lowe pereye a'i sa'i feni eire omo Kaperneam ma'e seni tewi sahe furi. ");
INSERT INTO sny_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Nowe mo'o su, lu taune werese Jisas au ene aye ape, sa'i feni eite teiye. Liyewe lowe wai ta sa'i tewi ma'e siyeye. Lowe Jisas lo lu disaipel wai iyatuteyei siyesawi. Jisas lo lu disaipel lowe a'i lai wai papu wi ato ereye. Jisas wai papu wi ta'ame. ");
INSERT INTO sny_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Lu taune tamo omo Taiberias ma'e fai ape, lowe wai papu wiye, hare ite tonerai. Omo eite sahe liyewe Jisas nau ta'ase Owane Sitewi ma'e au te'e wisereyeyewe, sosu lu taune werese ma'e au nonetiteye. Lowe wai sa'i tewi eite ma'e furi. ");
INSERT INTO sny_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Lu taune werese Jisas nau ta'ase au ene ateye ape, lowe Jisas nehiyei ne toteye. Lowe Jisas siye ta'ame su, lowe wai ape mo papu wi atowe. Sosu omo Kaperneam ma'e sa'i toneri. Lowe Jisas nehiyei ne toteye. ");
INSERT INTO sny_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Sosu lowe Jisas omo Kaperneam sahe siyeye su, lowe le ma'e eiye, “Atuatu siye meni, eiwerou su ne saro ahe fai awere?” ");
INSERT INTO sny_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Sosu Jisas lowe ma'e itiya'u eiye, “Wiyeme a'i, ane fene au te'eyei. Piyene fene ane nehisiya awere? Fene nau ta'ase ene aye, sosu lire teme'eriyeye. Serai fene ane nehi siyesiya. Fene wiyawi erasi ano siyeye su, fene ane ne tote ta'ame. Fene lire fene lo ne erasi a'i toteye. ");
INSERT INTO sny_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Nau ta'ase liyewe ane au nonetiye ape, ayei ape awei ma'e fai. Awei lo ayei werese witane a'i uwaseyei. Fene ene ayei ape mo marepi erasi a'i owe ape totete. Ahowa, fene Owane Sitewi lo ene ayei marepi erasi a'i totete. Awei lo ene ayei witane a'i uwaseyei. Sosu Owane Sitewi lo ene ayei mi mi pasi pasi ironamirowa. Owane Sitewi lo ene ayei ane, meni hire ma'e itorai ape, fene ma'e auwei. Owane Sitewi Tai Pefine a'i ano a'i lai ane ma'e au te'e wisereyesiya.” Jo 6:48-58 ");
INSERT INTO sny_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Serai lowe le ma'e apou eiye, “Piye nomo irowei awere? Nomo Owane Sitewi lo wiyawi erasi a'i ani ta'aneyei ne totesiya. Serai Owane Sitewi nomo ma'e ayei wiyeme a'i lo auwei.” ");
INSERT INTO sny_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Sosu Jisas lowe ma'e apou itiya'u eiye, “Fene Owane Sitewi lo wiyawi ani ta'aneyei ne toteyei su, fene ane ne meni, Owane Sitewi lai hi awei ma'e eimawe arosai ape, fene peri lo fa wanu tote tawesire.” 1 Jo 3:23 ");
INSERT INTO sny_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","31","Sosu lowe le ma'e te'e, “Tu naifa weriyei ya'ariyei nomo lo, omo pani ariye iroteye ape, Owane Sitewi lo nau ta'ase, iyape mana, ani ta'uwe ateye. Serai Moses apou leseye, ‘Owane Sitewi lai lu taune werese lo ma'e nau ta'ase hi awei se ito ma'e aro ausai.’” Serai lowe le ma'e eiye, “Ne piye wiyawi erasi a'i irowei awere? Nomo wiyawi erasi no siyeyei su, nomo fara'u peri no wanu tote tawesiyei. Ne piye wiyawi erasi a'i ta'aneyei awere?” Mt 16:1; Jo 2:18; Kis 16:14-15; Nam 11:7-9; Sng 78:24 ");
INSERT INTO sny_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Sosu Jisas lowe ma'e apou eiye, “Peri eite wiyeme a'i ne. Ane fene ma'e eisiya, Moses nau ta'ase fene ma'e hi awei ma'e au aro sai ta'ama. Ahowa, Owane Sitewi Tai Pefine a'i ano fene ma'e nau ta'ase wiyeme a'i hi awei ma'e eimawe arosaisiya. ");
INSERT INTO sny_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Nau ta'ase wiyeme a'i hi awei ma'e eimawesaisiya ape, apou wou a'i te'eye. Nau ta'ase wiyeme a'i eite lu taune werese a'i ma'e marepi hepene he'i a'i aurowa.” ");
INSERT INTO sny_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Serai lowe le ma'e eiye, “Meni Owane, ne nau ta'ase pefine a'i nomo ma'e mi mi werese ene ayei ne aunamire.” ");
INSERT INTO sny_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Sosu Jisas lowe ma'e eiye, “Ane a'i lai nau ta'ase wiyeme a'i ne. Ane marepi hepene he'i a'i aurowa. Lu taune tamo ane ma'e aiyeyei su, lowe mi mi pasi pasi lau mase irorowata. Sosu aiwawe, lu taune tamo peri ano wanu tote tawesiyei su, lowe mi mi pasi pasi sa'i wawe irorowata. Jo 4:14 ");
INSERT INTO sny_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ahowa, ane fene ma'e te'e tepa'asiye, ‘Fene ane siye tepa'asiye. Ahowa, fene peri ano wanu tote tawesi ta'ame.’ ");
INSERT INTO sny_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Lu taune werese, Owane Sitewi Tai Pefine a'i ano ariariyeye ape, lowe werese ane ma'e aiyeyei. Sosu lu taune tamo ane ma'e aiyeyei su, ane mi mi pasi pasi lowe werese ma'e me'iyeni atati awetorowata. ");
INSERT INTO sny_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Owane Sitewi lai ane hi awei ma'e eimawe arosai. Ane hi awei ma'e itorai su, ane Owane Sitewi Tai Pefine a'i ano lo marepi umasiyei. Ane marepi ano umasirowata. ");
INSERT INTO sny_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Owane Sitewi Tai Pefine a'i ano, ane hi awei ma'e eimawe arosai ape, lo marepi apou wou a'i ne. Lu taune werese, Owane Sitewi lai ane ma'e auwe ape, ane lowe werese awera'iyenati ta'ame. Serai nowe ye'ewi su, ane a'i lai lowe werese si ta'ane norohuwe hene anirowa. Sosu marepi hepene he'i a'i aurowa. Lowe werese mi mi pasi pasi weriyei tei ironamirowa. Jo 10:28-29; 17:12 ");
INSERT INTO sny_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Owane Sitewi Tai Pefine a'i ano lo marepi apou wou tote te'eye, lu taune werese, eime lo siyeyei ape, sosu peri lo wanu tote tawesiyei ape, Owane Sitewi lai lowe werese ma'e marepi hepene he'i a'i aurowa. Sosu ane lai nowe ye'ewi se, lowe werese a'i si ta'ane norohuwe hene anirowa. Serai lowe mi mi pasi pasi weriyei tei ironamirowa.” ");
INSERT INTO sny_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Sosu a'i pe Jisas apou au te'eye su, “Ane a'i lai Owane Sitewi lo nau ta'ase hepene se ne,” Juda lo lu owane tamo Jisas ne ai marepi tote te'e tiyatiye. ");
INSERT INTO sny_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Sosu lowe apou te'eye, “Meni ape lai Jisas tene! Josep lo meni eime, nomo tai lo mai lo so'oruwe tene! Peri lo wanure! ‘Ane lai Owane Sitewi mase hi awei ma'e itorai.’ Wawero tene!” Mt 13:55 ");
INSERT INTO sny_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Sosu Jisas lowe ma'e itiya'u eiye, “Fene ai marepi owe ape tote te'e tiyatire. ");
INSERT INTO sny_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Owane Sitewi lai meni ta ariariye ei ani ta'ame su, meni ape ane ma'e aiyerowata. Ahowa, ane Owane Sitewi lai, hi awei ma'e eimawe arosai ape, serai Owane Sitewi lai meni ta ei aniyei su, meni ape ane ma'e aiyeyei. Sosu ane nowe ye'ewi se le si ta'ane norohuwe hene anirowa. Jo 6:65 ");
INSERT INTO sny_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Tu naifa weriyei Owane Sitewi lo au te'e siye lu tamo apou leseye, ‘Owane Sitewi lai lu taune werese ma'e au atuaturowa.’ Sosu aiwawe a'i lu taune werese Owane Sitewi Tai Pefine a'i ano lo peri wanuwe su, sosu ani so'oruweyei su, lowe werese ane ma'e aiyeyei. ");
INSERT INTO sny_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Lu taune werese Owane Sitewi Tai Pefine a'i ano siye ta'ame. Owane Sitewi lai meni ape hi awei ma'e eimawe arosai. Serai meni ape ne, ane a'i lai Tai Pefine a'i ano siyeye. Jo 1:18 ");
INSERT INTO sny_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Peri eite wiyeme a'i tene! Ane fene ma'e eiyei, lu taune tamo peri ano wanu tote tawesiyei su, lowe mi mi pasi pasi weriyei tei ironamitorowa. Jo 3:15-16 ");
INSERT INTO sny_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ane a'i lai Owane Sitewi lo nau ta'ase wiyeme a'i ne. Ane lai lu taune ma'e marepi hepene he'i a'i aurowa. Jo 6:32,58 ");
INSERT INTO sny_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ya'ariyei fene lo pani ariye a'i sahe lowe nau ta'ase Owane Sitewi hi ma'e eimawe arosai ape, a tepa'asiye. Nau ta'ase ape lowe ma'e marepi hepene he'i a'i aurowata. Serai nowe me'iye su, lowe werese temeniyeye. ");
INSERT INTO sny_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ane a'i lai Owane Sitewi lo nau ta'ase, hi awei ma'e eimawe arosai ape ne. Serai lu taune tamo nau ta'ase eite ene ayei su, ane lowe ma'e marepi hepene he'i a'i aurowa. Sosu mi mi pasi pasi weriyei tei ironamitorowa. ");
INSERT INTO sny_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ane a'i lai Owane Sitewi lo nau ta'ase hepene se hi awei ma'e eimawe aro sai. Lu taune tamo nau ta'ase ape ayei su, lowe mi mi pasi pasi weriyei tei ironamirowa. Nau ta'ase ape tahe pa'are ano ne. Lu taune werese omo omo werese sahe, ane lowe ne tahe pa'are ano au temeniyeyei. Serai lowe mi mi pasi pasi weriyei tei ironamirowa.” ");
INSERT INTO sny_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Sosu a'i pe lu Juda lo lu owane ta'u ai peri erasi a'i te'e tiyatiye. Lowe apou te'e tiyatiteye, “Meni eite nomo werese ma'e tahe pa'are lo auwei ne ayei awere? Wawero a'i tene!” ");
INSERT INTO sny_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Sosu Jisas itiya'u eiye, “Peri wiyeme a'i ne. Ane fene ma'e eisiya, fene, meni ape itorai ape, lo tahe pa'are a ta'ame su, sosu fisa'i lo a ta'ame su, fene marepi hepene he'i anirowata. ");
INSERT INTO sny_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Lu taune ta tahe pa'are ano ani ayei su, sosu fisa'i ano ani ayei su, lowe mi mi pasi pasi weriyei tei ironamitorowa. Sosu nowe ye'ewi se, ane lowe ma'e si hene anirowa. ");
INSERT INTO sny_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Pefine tahe pa'are ano ayei wiyeme a'i ne. Sosu aiwawe fisa'i ano sa'i wiyeme a'i ayei. ");
INSERT INTO sny_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Lu taune ta tahe pa'are ano ayei su, sosu fisa'i ano ayei su, ane meni eite papu wi ironamisiya. Sosu aiwawe le ane papu wi ironamisiya. ");
INSERT INTO sny_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Owane Sitewi Tai Pefine a'i ano hepene se ne. Le lai ane hi awei ma'e eimawe arosaiyewe, ane ma'e hepene se auwe. Serai lu taune ta tahe pa'are ano ayei su, ane le ma'e marepi hepene he'i auwei. 1 Jo 3:24 ");
INSERT INTO sny_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ya'ariyei fene lo nau ta'ase Owane Sitewi lowe ma'e eimawe arosai ape, ateye. Nau ta'ase ape marepi hepene he'i a'i au ta'ame. Ahowa, nowe me'iye su, lowe werese temeniyeye. Sosu ane lai Owane Sitewi lo nau ta'ase wiyeme a'i, hi awei ma'e eimawe arosai ape, lu taune ta nau ta'ase wiyeme a'i ayei su, lowe mi mi pasi pasi weriyei tei ironamisiya.” ");
INSERT INTO sny_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jisas peri werese eite au te'e fiyariye su, le ta'uwe wesi omo Kaperneam sahe au atuatuwe. ");
INSERT INTO sny_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Sosu lu feni lo tomu ne'ese peri ape mo wanuwe su, lowe marepi orese a'i toteye. Lowe apou toteye, “Peri eite orese a'i ne. Eiwerai fara'u wanusiya awere?” ");
INSERT INTO sny_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ahowa, Jisas lu feni lo marepi orese a'i ani so'oruweye su, le lowe ma'e eiye, “Fene peri ano wanuwewe, marepi fene lo orese a'i ne. Serai fene apou eiye, ‘Nomo peri ape lo wanu aniyei wou ta'ame.’ ");
INSERT INTO sny_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Peri ano wanure! Fene meni, hi awei ma'e itorai ape, hire ma'e si tame wiyei siyeyei su, fene peri ano wanu tote tawesirowata awere? Fene marepi luwaru a'i toteyei awere? ");
INSERT INTO sny_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Lu taune werese ta'u marepi hepene he'i anirowata. Sosu mi mi pasi pasi teinamirowata. Owane Sitewi lo Hepene Wara'i lai marepi hepene he'i aunamisiya. Peri ano, fene ma'e au te'eye ape, fene peri ano Owane Sitewi lo Hepene Wara'i ne wanuwei su, fene marepi hepene he'i a'i aniyei. Serai fene mi mi pasi pasi ironamirowa. ");
INSERT INTO sny_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ahowa, lu taune tamo peri ano wanu aniye taye. Meni eite Jisas ai atu siye lu tamo'ama.” Jisas piyene peri apou te'eye awere? Le lu taune werese lo marepi siye so'oruwe tepa'asiye. Jisas tu naifa weriyei weriyei lu taune werese siye so'oruweteye. Lu taune tamo wanu aniye. Lu tamo wanu ani ta'ame. Jisas lai lowe siye so'oruweye. Meni eite Jisas ai atu siye lu tamo ma'e hene areareye. Jisas tu naifa weriyei meni ape lo yo seni siye so'oruweye. Jo 13:11 ");
INSERT INTO sny_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Sosu Jisas apou eiye, “Ane fene ma'e eiye su, ‘Tu naifa weriyei ane lu taune werese lo marepi siye so'oruwe tepa'asiye.’ Peri eite wiyeme a'i tene! Peri eite lo marepi si apou a'i totesiya. Owane Sitewi Tai Pefine a'i ano lu taune tamo ei ani ariariye ta'ame su, le ane ma'e aiyerowata.” Jo 6:44 ");
INSERT INTO sny_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Sosu a'i pe lu feni lo tomu ne'ese peri eite wanuwe su, lowe Jisas me'iyeni ma'e atati ani arunati. Serai lowe le aiwawe uwei te ta'ame. ");
INSERT INTO sny_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Serai Jisas lu disaipel lo ma'e, ereti feni hesi lowe hesi a'i (12) ei toweriye, “Fene aiwawe ane ne me'iyeni ma'e atati arunatiyei awere? Sosu wesi towafi fene lo si tame iyei awere?” ");
INSERT INTO sny_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Sosu Saimon Pita le ma'e itiya'u eiye, “Owane, nomo si tame iyei su, eiwerou ma'e nomo si tame iyei awere? Ne a'i lai peri wiyeme a'i au te'esiya. Peri no eite se nomo mi mi pasi pasi ironamirowa. ");
INSERT INTO sny_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nomo werese peri no wanu tote tawesi umasiteye. Sosu aiwawe nomo ne a'i Owane Sitewi lo meni wara'i so'oruwe tene!” Mt 16:16 ");
INSERT INTO sny_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Sosu Jisas lowe ma'e itiya'u eiye, “Ane a'i lai fene werese (12) ariariyeye. Ahowa, meni ta'i, fene mase irosiya ape, meni luwaru a'i tene!” ");
INSERT INTO sny_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Serai Jisas lo marepi si apou a'i toteye, meni iyape Judas, Saimon Iskariot lo meni eime, meni eite Jisas lo lu disaipel (12) lowe aiwawe a'i iroteye. Mo'o su meni ape lai Jisas ai atu siye lu ma'e hene arearerowa. ");
INSERT INTO sny_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Sosu a'i pe Jisas peri ape mo te'e tepa'asiye su, le omo pani Galili sahe uweiteye. Le omo pani Judia i ta'ame. Jisas lo marepi sitewi apou a'i toteye, “Juda lo lu owane ane ma'e aine tera'eyei ne totesiya. Serai ane Judia lo omo pani irowata.” Jo 5:18 ");
INSERT INTO sny_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Nowe eite se, Juda lo ta'uwe hereiyei atahe a'i henerai iyape ipo wesi lo ta'uwe hereiyei. Wkp 23:34 ");
INSERT INTO sny_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","5","Jisas lo pa'ise mo lowe peri lo wanu tote tawesiye ta'ama. Serai lowe le ma'e apou eiye, “Ne pani Galili arunatiyewe, sosu omo pani Judia ma'e ire. Ne wiyawi no yaro ma'e au ta'anere. Lu taune werese, ne ma'e umasiye ape, lowe wiyawi no ne siyeyei sosu ne ne au te'e wisereyeyei. Marepi sitewi nomo lo apou a'i irowei su, lowe wiyawi eite fareyare ta'ame. Ahowa, lowe lai lu taune werese ma'e amerame a'i atuatuwei ne totesiya. Ne wiyawi erasi a'i irowei su, ne lu taune werese a'i ma'e au atuatuwei.” Ap 1:14 ");
INSERT INTO sny_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Sosu Jisas pa'ise werese lo ma'e itiya'u eiye, “Nowe ano se henerai ta'ama. Serai ane wiyawi erasi a'i lu taune werese ma'e au atuatuwei ta'ama. Serai pereye ane soro ma'e irowata. Ahowa, lu owane fene ma'e ai marepi iro ta'ame. Serai fene fara'u marepi fene lo iro umasiyei. ");
INSERT INTO sny_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ane lu taune werese lo yo seni ne apou au te'e fiyarisiya, ‘Yo seni werese lowe lo luwaru wiyeme a'i tene!’ Serai lu taune werese ane ne ai marepi totenamisiya. Fene lowe lo yo seni ne luwaru a'i au te'e ta'ame. Lowe fene ne ai marepi totenamirowata. ");
INSERT INTO sny_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Serai fene ta'u ta'uwe hereiyei ape soro ma'e ire! Ane ta'uwe hereiyei ape soro ma'e irowata. Piyene awere? Nowe ano se henerai ta'ama.” ");
INSERT INTO sny_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Sosu le peri eite te'e tepa'asiye su, le omo pani Galili saro iroteye. ");
INSERT INTO sny_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Sosu a'i pe pa'ise lo ta'uwe hereiyei soro ma'e yaneye su, le a'i lai soro ma'e eresene fareyare yaneye. Lu taune werese le ne siyesawi ta'ama. ");
INSERT INTO sny_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Sosu ta'uwe hereiyei henerai su, Juda lo lu owane Jisas nehiteye. Siye ta'ame su, lowe apou ei toweriye, “Jisas eiwerou ma'e irosiya awere?” ");
INSERT INTO sny_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Sosu lu taune werese le ne marepi orese a'i tote te'e tiyatiteye. Lu taune tamo apou a'i te'eye, “Meni ape yo seni wara'i a'i ne.” Ahowa, lu taune tere'e tamo apou a'i te'eye, “Ahowa, meni ape luwaru a'i ne. Le lu taune werese ne yo luwaru a'i tere'e ma'e hene aiti.” ");
INSERT INTO sny_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Lu taune werese Juda lo lu owane ne taweiru a'i ne. Serai lowe werese Jisas ne amerame a'i au te'e ta'ame. ");
INSERT INTO sny_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Sosu a'i pe ta'uwe hereiyei ape ponei i tepa'asiye su, Jisas lai Owane Sitewi lo wesi wiye. Owane Sitewi lo wesi papu wiye su, le lu taune werese ma'e au te'e atuatuwe. ");
INSERT INTO sny_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Jisas peri lo au te'e atuatuwe te'eye su, Juda lo lu owane marepi auseriyeye. “Sawi amou! Meni eite etiri werese ne wisere a'i ani so'oruwesiya. Piyene awere? Le skul ma'e onu ta'ame.” Mt 13:54; Lu 2:47 ");
INSERT INTO sny_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Sosu Jisas lowe ma'e itiya'u eiye, “Peri eite, ane au te'esiya ape, peri ape ano ta'ame ne. Peri ape Owane Sitewi Tai Pefine a'i ano lo ne, le ane, hi awei ma'e eimawe arosai. Serai ane marepi lo au te'e fiyariye. Jo 12:49; 14:10 ");
INSERT INTO sny_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Lu taune Owane Sitewi lo marepi umasiyei su, lowe piye peri wiyeme a'i wanu so'oruweyei. Lu taune ta Owane Sitewi lo marepi umasiyei ne totesiya su, le apou fa totere, ‘Peri ape, ane au te'e fiyariye ape, piye peri wiyeme a'i awere? Peri ape Owane Sitewi ma'e fai awere? Ane a'i lai marepi ano au te'e fiyarisiya awere?’ ");
INSERT INTO sny_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Lu taune tamo peri topo lo ne au te'esiya su, le a'i lai iyape lo erasi a'i ei ani aroweyei ne totesiya. Ahowa, ane, Owane Sitewi lai ane eimawe arosai ape, Owane Sitewi lo iyape ei ani aroweyei ne totesiya. Le a'i lai wiyeme a'i ne. Le yo seni luwaru werese a'i marepi hepene papu lo irorowata. Le a'i lai yo seni wara'i a'i ironamisiya. Jo 8:50 ");
INSERT INTO sny_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Tu naifa weriyei meni Moses fene werese ma'e Owane Sitewi lo yo peri au leseye. Ahowa, fene werese Owane Sitewi lo yo peri eite mo ani towesisiya. Owane Sitewi lo yo peri apou eiye, ‘Fene meni ta owe aine tera'ere.’ Fene apou totesiya. Meni eite Jisas Owane Sitewi lo yo peri towesiye. Serai nomo meni eite fa aine tera'ere. Fene piyene ane ma'e aine tera'eyei ne totesiya awere?” Ap 7:53; Ro 2:21-24 ");
INSERT INTO sny_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Sosu lu taune werese itiya'u eiye, “Ne sepei luwaru a'i papu irosiya. Eiwerai ne ma'e aine tera'eyei ne totesiya awere?” Jo 8:48; 10:20 ");
INSERT INTO sny_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Sosu Jisas lowe ma'e itiya'u eiye, “Ane wiyawi erasi ta'i a'i nowe amou se au irowewe, serai fene werese ane ma'e marepi luwaru a'i totesiya. ");
INSERT INTO sny_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","23","Ane meni ta'i nowe amou se au ta'ane fara'uweye. Fene ai marepi ane ne owe ape totere. Fene werese ya'ariyei fene lo aiwawe Moses lo yo peri wiyeme a'i umasisiya. Ya'ariyei fene lo tahe touwe. Fene meni eime fene lo Owane Sitewi lo nowe se tahe au touwe. Serai fene wiyawi ta'aneye. Ahowa, fene marepi fene lo apou toteye. Nowe amou eite se nomo wiyawi ta'ane ta'ame. Serai ane meni ta'i nowe amou se au fara'uweye su, fene ane ne ai marepi totenamiteye. Marepi fene lo meremereye a'i ne. Wkp 12:3; Stt 17:9-13; Jo 5:8-10,16 ");
INSERT INTO sny_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Meni ta wiyawi ta'i ta'aneyei su, wiyawi eite wisere a'i awere? Luwaru a'i awere? Fene nihe se a'i owe ape au hesere. Fene wiyawi eite au heseyei su, fene wiyawi lo marepi si au heseyei. Fene marepi wara'i a'i se au hesete.” ");
INSERT INTO sny_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Sosu a'i pe Jisas peri ape mo te'e tepa'asiye su, lu taune omo Jerusalem ma'e fai ape apou eiye, “Meni eite lu owane nomo lo lai le ma'e aine tera'eyei ne totesiya. ");
INSERT INTO sny_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Siyere! Le lu taune werese ma'e au te'e fiyarisiya su, lowe le ma'e ai peri te'erowata. Owane Sitewi nomo lo piye marepi totesiya awere? Meni eite Owane Sitewi lo ariariye siye meni, Krais aiwawe a'i ne, totesiya awere? Piyete awere? ");
INSERT INTO sny_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ahowa, meni ape lo omo sitewi nomo so'oruwe tene! Ahowa, meni ape Krais heneraiyei su, omo lo sitewi lu taune werese so'oruwe ta'ama.” Jo 7:41; 9:29 ");
INSERT INTO sny_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Serai Jisas Owane Sitewi lo wesi sahe peri erasi apou uteye, lu taune werese ma'e au atuatuweye, “Wanure, fene lai ane ne so'oruwe tene! Sosu aiwawe fene omo sitewi ano ne siye so'oruwesiya tene! Ahowa, Ane hi awei ma'e itorai su, ane marepi ano umasi ta'ame. Owane Sitewi Tai Pefine a'i ane, hi awei ma'e eimawesai ape, le a'i lai wiyeme a'i tene! Fene werese le ne so'oru ta'ama. Mt 11:27; Jo 8:55 ");
INSERT INTO sny_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ane Owane Sitewi Tai Pefine a'i ano ma'e itorai. Serai ane le ne so'oruwe tene! Le a'i lai ane hi awei ma'e eimawesai.” ");
INSERT INTO sny_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Sosu Juda lo lu owane Jisas ereti anite tawesiyei ne toteye. Ahowa, lowe le ma'e ereti anite tawesirowata. Marepi si apou a'i toteye, “Jisas lo nowe henerai ta'ame.” Serai lowe Jisas ereti anite tawesi ta'ame. Jo 7:44 ");
INSERT INTO sny_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Sosu lu taune tomu ne'ese Jisas lo peri wanu tote tawesiye. Lowe apou eiye, “Meni eite lai Krais tene! Meni tere'e wiyawi erasi a'i ta'aneyei awere? Ahowa, meni ape lo wiyawi lai wiyawi werese hi ani ararowe. Marepi nomo lo apou a'i toteye. Meni ape Krais tene!” ");
INSERT INTO sny_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Sosu lu Farisi tamo le ne lu taune lo peri wanuwe su, au heseyei lu owane pefine a'i, Farisi aiwawe a'i, lowe ai atu siye lu owane Jisas ma'e anite tawesiyei ne eimawesai. ");
INSERT INTO sny_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Serai Jisas apou eiye, “Nowe oso a'i su, ane fene mase irosiya. Nowe i tepa'asiyei su, ane temeniyeyei sosu Owane Sitewi Tai Pefine a'i ano ma'e ane si tame ta'ane norohuwe sinerowa. ");
INSERT INTO sny_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Fene ane ne nehi siyeyei. Ahowa, fene ane siyerowata. Ane omo hire ma'e iyei su, fene hire ma'e umasirowata.” Jo 8:21; 13:36 ");
INSERT INTO sny_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Sosu Juda lo lu owane lowe ta'u te'e tiyati towerisiya. “Meni ape eiwerou ma'e iyei awere? Serai nomo le ma'e siyerowata. Le Juda lo lu taune ma'e omo pani Grik sahe au te'e fiyariyei awere? Sosu aiwawe Grik lo lu taune ma'e au te'e fiyariyei awere? ");
INSERT INTO sny_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Le peri ape au te'eye su, piye marepi si au te'eye awere? ‘Fene ane ne nehiye siyeyei. Ahowa, fene ane siyerowata. Ane omo hire ma'e wirowa. Ahowa, fene ane mo'o aiyerowata.’” ");
INSERT INTO sny_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Sosu a'i pe ta'uwe hereiyei lo nowe ye'ewi henerai su, Jisas lu taune werese ma'e ponei tei irowe, sosu lowe ma'e peri erasi apou uteye, “Lu taune tamo sa'i ayei ne totesiya su, lowe ane ma'e fa aiyere. Lowe ane aiyeyei su, ane sa'i lowe ma'e au ayei. Wkp 23:36; Ais 55:1; Jo 4:14 ");
INSERT INTO sny_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Lu taune tamo peri ano wanu tote tawesiyei su, sosu yo seni ano umasiyei, fene Owane Sitewi lo peri wanure. ‘Lu taune ta peri ano wanu tote tawesiyei su, sa'i hepene se erasi a'i marepi hepene lowe lo papu nowe ma'e heneraiyei.’” ");
INSERT INTO sny_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Sa'i hepene se eite ne apou a'i te'eye. Lu taune ta peri ano wanu tote tawesiyei su, Owane Sitewi lai Hepene Wara'i lo lowe ma'e eimawe arosaiyei. Jisas etiri eite mo au te'eye su, Owane Sitewi lo Hepene Wara'i a'i hi awei ma'e itorai ta'ama. Jisas temeniyeyei su, sosu Owane Sitewi iyape erasi le ma'e auwei su, Owane Sitewi hepene Wara'i a'i lo hi awei ma'e eimawe arosaiyei. Jo 16:7; 20:22; Ap 2:4 ");
INSERT INTO sny_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Sosu Jisas peri ape au te'eye su, lu taune tamo marepi lowe lo apou toteye, “Meni eite Owane Sitewi lo au te'e siye meni wiyeme a'i ne.” Jo 6:14 ");
INSERT INTO sny_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ahowa, lu taune tere'e tamo apou toteye, “Meni ape Krais tene!” Lu taune tamo apou toteye, “Wawero a'i ne. Krais nomo lo omo pani Galili ma'e aiyerowata. Meni ape omo Nasaret pani Galili ma'e fai. Jo 1:46 ");
INSERT INTO sny_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Tu naifa weriyei Owane Sitewi lo peri apou leseteye, ‘Krais, Devit lo ya'ariyei lu feni. Devit lo omo sitewi iyape pani Judia sahe Betlehem ma'e fai.’” ");
INSERT INTO sny_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Lu taune werese Jisas ne marepi tere'e tere'e toteye. ");
INSERT INTO sny_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Lu taune tamo Jisas ma'e ereti anite tawesiyei ne toteye. Ahowa, lowe le ma'e ereti anite tawesi ta'ame. Piyene awere? Jisas lo nowe henerai se ta'ama. ");
INSERT INTO sny_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Sosu a'i pe ai atu siye lu ape, lowe au heseyei lu owane, lu Farisi aiwawe a'i lowe ma'e si tame fi. Lowe Jisas hene aitai ta'ama. Sosu au heseyei lu owane lowe ma'e ei toweriye, “Fene piyene Jisas henetai ta'ame awere?” ");
INSERT INTO sny_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Sosu ai atu siye lu owane lowe ma'e itiya'u eiye, “Meni ape iyape se ne. Lu tere'e peri lowe lo aiwawe a'i au te'e ta'ame.” Mk 1:22 ");
INSERT INTO sny_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Sosu lu Farisi apou a'i itiya'u eiye, “Atu, fene aiwawe. Meni ape fene yo seni luwaru a'i sahe hene ni'ariye awere? ");
INSERT INTO sny_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Juda lo lu owane werese yo seni lo ape umasi ta'ame. Nomo lu Farisi aiwawe a'i, nomo werese le ne umasi ta'ama. Jo 12:42 ");
INSERT INTO sny_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Lu taune werese Moses lo yo peri so'oru ta'ama. Serai lowe Jisas lo peri wanu tote tawesiye. Lowe Jisas lo peri wanu umasiyei su, Owane Sitewi lai lowe ma'e omo yehe eimawesawiyei.” ");
INSERT INTO sny_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Meni ta'i iyape Nikodemus, Tu naifa meni ape Jisas ma'e pasi a'i fai. Juda lo meni owane ne. Le Jisas au pati aniyei ne toteye. Jo 3:1-2 ");
INSERT INTO sny_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Le lowe ma'e eiye, “Ya'ariyei yo peri nomo lo apou au te'esiya, ‘Tu meni ape nomo ma'e fa aiyere. Nomo peri lo wanuwei su, nomo yo seni lo fara'u au heseyei.’” ");
INSERT INTO sny_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Lowe le ma'e itiya'u eiye, “Ne omo pani Galili ma'e fai awere? Ne Jisas lo lu tewi a'i awere? Ne Owane Sitewi lo peri sahe nehi siyere. Marepi nomo lo apou a'i toteye. Owane Sitewi lo au te'e siye lu werese omo pani Galili heneraiyei ta'ama.” Jo 7:41-42 Peri eite (7:53—8:11) piye meni lai leseye awere? Lu so'oru se tamo lowe so'oru ta'ama. Ya'ariyei one towe tomu tamo sahe peri eite iro te ta'ame. One towe tere'e tamo sahe peri eite iroteye. ");
INSERT INTO sny_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","{Lu taune werese wesi towafi lowe lo ma'e fi. ");
INSERT INTO sny_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Lu taune werese wesi towafi lowe lo fi su, Jisas Omo Oliv hire ma'e yaneye. ");
INSERT INTO sny_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Nowe mitaiyeye su, le ta'uwe wesi ma'e si tame wiye. Ta'uwe wesi wiye su, lu taune tomu ne'ese le ma'e ta'uwerai. Le lu taune werese siyeye su, le saro onuwewe, lowe ma'e Owane Sitewi lo peri werese au te'e atuatuwe. ");
INSERT INTO sny_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Sosu Owane Sitewi lo yo peri so'oruwe siye lu tamo lu Farisi aiwawe, lowe menitani ta, naituwei towesiye ape, siyeye. Serai lowe menitani ape Jisas ma'e henetai. Sosu lowe menitani eite lu taune werese ponei ma'e tei irowe. ");
INSERT INTO sny_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Sosu lowe le ma'e apou eiye, “Atuatu siye meni, menitani eite naituwe towesiye. Nomo a'i lai nihe nomo lo se siyeye. ");
INSERT INTO sny_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Serai Moses lo yo peri apou te'eye, ‘Menitani ta, naituwe ape, le tafa'e yo seni luwaru a'i irowe ape, fene le ma'e tapiye ani fusawi aine tera'ere.’ Ne piye peri te'esiya awere?” Wkp 20:10; Lo 22:22-24 ");
INSERT INTO sny_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Sosu lowe le ma'e te'e toweriye su, lowe Jisas au areareyei ne totesiya. Marepi si lowe lo apou a'i toteye, “Jisas lai Moses lo yo peri towesiyei su, nomo fara'u le etiyei.” Ahowa, Jisas peri se ta'ame. Le lowe uporo ape'i awei sahe onuwewe, sosu peperi sahe etiri ta leseye. ");
INSERT INTO sny_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Sosu lu owane le ma'e tame te'e towerinamiye. Sosu Jisas sineteye su, le lowe ma'e itiya'u eiye, “Meni ta fene mase yo seni luwaru a'i ariye su, le fara'u tapiye tutawe menitani ma'e fa fusawire.” Lo 17:7 ");
INSERT INTO sny_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Peri te'e tepa'asiye su, le lowe uporo si tame ape'i onuwe. Sosu peperi sahe ereti tepi se leseye. ");
INSERT INTO sny_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Sosu lu owane Jisas lo peri wanuwe su, lowe ta'i ta'i arunatiyewe fi. Ya'ariyei owane lu tu fi. Sosu mo'o lu tere'e tere'e arunatiyewe fi. Lowe werese fi su, Jisas menitani ape, lowesi a'i irowe. ");
INSERT INTO sny_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Sosu Jisas si tame sineye su, le menitani ma'e ei toweriye, “Lu owane werese eiwerou ma'e awere? Lu tamo ne ma'e eti ta'ame awere?” ");
INSERT INTO sny_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Sosu le itiya'u eiye, “Meni Owane, lu werese ariye.” Sosu Jisas itiya'u eiye, “Ane aiwawe a'i ne ma'e etirowata. Ne wesi no ire! Mi mi werese yo seni luwaru a'i owe ape irore!”} Jo 5:14 ");
INSERT INTO sny_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Sosu a'i pe Jisas lowe ma'e eiye, “Ane a'i lai lu taune werese lo mi tene! Lu taune tamo ane ma'e umasiyei su, lowe pasi aiwawe a'i uweirowata. Ahowa, lowe mi a'i se uweiyei. Sosu lowe mi mi pasi pasi ironamiyei.” Ais 49:6; Jo 1:4-9; 9:5; Jo 12:46 ");
INSERT INTO sny_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Sosu lu Farisi le ma'e eiye! “Wawero! Ne a'i lai ne ne au te'e fiyariye. Peri eite wawero a'i ne. Eiwerai ne pati te'esiya awere?” ");
INSERT INTO sny_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jisas lowe ma'e itiya'u eiye, “Ane peri ano ne au te'e fiyariye su, peri ano wiyeme a'i tene! Aiwawe a'i Owane Sitewi Tai Pefine a'i ano peri ano ne au pati te'esiya. Ane lai, omo sitewi ma'e fai ape, so'oruwesiya. Sosu aiwawe ane omo ma'e iyei ape so'oruwerowa. Ahowa, fene omo sitewi ano so'oru ta'ama. Aiwawe a'i ane omo ma'e iyei su, fene omo ape so'oru ta'ama. Jo 5:31-32; 7:28 ");
INSERT INTO sny_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Fene werese lu taune lo yo seni werese awei lo marepi a'i se au hesesiya. Ahowa, ane lai lu taune werese lo yo seni au heserowata. Jo 12:47 ");
INSERT INTO sny_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ane lu taune lo yo seni au heseyei su, ane yo seni au heseyei ape wiyeme a'i tene! Ane ta'i woto a'i au heserowata. Ahowa, Owane Sitewi Tai Pefine a'i ano ane hi ma'e wiyawi lo aniyei ne eimawesai. Serai ane Tai Pefine a'i ano aiwawe a'i notosi lu taune werese lo yo seni au heserowa. Jo 5:30; 8:29 ");
INSERT INTO sny_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Wanure! Yo seni fene lo apou eiye, ‘Lu hesi a'i peri ta'i au te'e fiyariyei su, peri lowesi lo wiyeme a'i tene!’ Lo 19:15 ");
INSERT INTO sny_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ane a'i lai ane ne au te'e fiyarisiya. Sosu aiwawe a'i Owane Sitewi Tai Pefine a'i ano ane ne au pati te'e fiyarisiya. Notosi a'i ane ne au te'e fiyarisiya su, serai peri ano wiyeme a'i tene!” 1 Jo 5:9 ");
INSERT INTO sny_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Sosu lu owane le ma'e te'e toweriye, “Owane Sitewi Tai Pefine a'i no eiwerou ma'e irosiya awere?” Sosu Jisas itiya'u eiye, “Fene ane ne so'oru ta'ama. Aiwawe a'i fene Owane Sitewi Tai Pefine a'i ano ne so'oru ta'ama. Fene ane ne so'oruweyei su, serai fene Tai Pefine a'i ano ne aiwawe a'i so'oruweyei.” ");
INSERT INTO sny_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Peri eite Jisas au te'e fiyariye su, le Owane Sitewi lo tewi wesi sahe ma'aru ani fusiya ape, au te'e fiyariye. Lu owane werese Jisas ereti anite tawesirowata. Marepi si aiwawe a'i toteye. Jisas lo nowe henerai ta'ama. Jo 7:30 ");
INSERT INTO sny_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Le lowe ma'e apou itiya'u tame eiye, “Ane omo tere'e iyei. Fene ane ne siye nehiyei ne toteyei. Ahowa, fene ane siyerowata. Ane omo iyei su, fene ane omo ma'e mo'o umasirowata. Serai fene yo seni luwaru a'i fene lo se temeniyeyei.” Jo 7:34; 13:33 ");
INSERT INTO sny_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Serai Juda lo lu owane apou te'e tiyatiye. “Jisas le topo aine tera'eyei awere? Le apou eiye, ‘Ane omo iyei su, fene ane mo'o umasirowata.’ Serai marepi nomo lo apou a'i toteye. Jisas topo le aine tera'eyei tene!” ");
INSERT INTO sny_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Sosu Jisas lowe ma'e eiye, “Fene lai hi awei ma'e fai. Ane lai omo hire ma'e fai. Fene lai hi awei ma'e irosiya. Ane lai hi awei ma'e fai ta'ama. Jo 3:31 ");
INSERT INTO sny_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ane tu apou eiye, ‘Fene werese yo seni luwaru a'i fene lo se temeniyerowa. Fene peri ano ne me'iyeni ma'e atati ani awetowei su, sosu ane meni eite Krais tote tawesi ta'ame su, wiyeme a'i fene werese yo seni luwaru a'i fene lo se temeniyerowa.’” ");
INSERT INTO sny_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Sosu lowe itiya'u te'e toweriye, “Ne eiwerai awere?” Jisas lowe ma'e eiye, “Ane mi mi werese fene ma'e au te'e tepa'asiye. ");
INSERT INTO sny_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ane etiri tomu ne'ese fene ma'e au te'e fiyariyei. Sosu aiwawe ane yo seni werese tomu ne'ese fene lo se au heserowa. Ahowa, le, ane hi awei ma'e eimawesai ape, le a'i lai wiyeme a'i tene! Le peri tomu ne'ese ane ma'e te'eyei ne auwe. Serai peri werese ane wanuwe su, ane lu taune werese omo werese sahe au te'e fiyariyei.” ");
INSERT INTO sny_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Lowe werese wanuwe su, marepi lowe lo apou a'i toteye, “Le meni tere'e ne au te'eye.” Ahowa, le Owane Sitewi Tai Pefine a'i lo ne au te'eteye. ");
INSERT INTO sny_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Serai Jisas lowe ma'e eiye, “Nowe ta su pe, meni hire ma'e itorai ape, fene hire ma'e ani aroweyei su, serai fene ane Krais siye so'oruweyei. Ane marepi ano umasirowata. Ahowa, Owane Sitewi Tai Pefine a'i ano ane ma'e etiri ta au te'eye su, ane peri lo au te'e fiyariyei. Jo 3:14 ");
INSERT INTO sny_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Sosu aiwawe a'i. Le ane, hi awei ma'e eimawesai ape, le ane mase irosiya. Le ane woto a'i ma'e arunati fi ta'ama. Wiyeme a'i! Etiri werese ane ta'aneyei su, ane Owane Sitewi ma'e au te'e wisereyeyei. Serai Owane Sitewi ane ne au te'e wisereyeyei.” ");
INSERT INTO sny_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Serai lu taune tomu ne'ese le ne tote tawesiyewe. Sosu le ma'e umasiye. ");
INSERT INTO sny_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Sosu a'i pe Jisas Juda lo lu taune, le mo'o umasiteye ape, le lowe ma'e eiye, “Fene peri ano umasinamiyei su, sosu fene werese lu feni ano wiyeme a'i heneraiyei tene! ");
INSERT INTO sny_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Sosu aiwawe a'i fene peri wiyeme a'i wanu so'oruweyei. Sosu peri wiyeme a'i eite se fene marepi fetane a'i au heneraiyei.” ");
INSERT INTO sny_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Sosu lowe le ma'e itiya'u eiye, “Nomo meni Abraham lo lu tewi a'i ne. Lu owane werese mi mi werese nomo tote tawesi ta'ame. Marepi no piye totesiya awere? ‘Fene marepi fetane a'i heneraiyei.’” Mt 3:9 ");
INSERT INTO sny_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Sosu Jisas lowe ma'e itiya'u eiye, “Peri ano wiyeme a'i ne. Ane fene ma'e eisiya. Lu taune werese yo seni luwaru a'i irowe su, yo seni luwaru a'i lowe lo lai lowe ma'e anite tawesiye. Ro 6:16,20 ");
INSERT INTO sny_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Lu taune werese, yo seni luwaru a'i, ya'orei anite tawesiye ape, lowe Owane Sitewi mase iro ta'ame. Ahowa, Owane Sitewi lo meni eime mi mi pasi pasi weriyei ironamitorowa. ");
INSERT INTO sny_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ane yo seni luwaru a'i fene lo au sasari pamoweyei su, ane fene ma'e marepi fetane a'i au irorowa. Serai fene marepi fetane a'i mi mi pasi pasi weriyei ironamitorowa. ");
INSERT INTO sny_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Peri no wiyeme a'i. ‘Nomo Abraham lo lu tewi ne.’ Ahowa, peri ano marepi hepene fene lo papu ai marepi irosiya. Serai fene ane ma'e aine tera'eyei ne totesiya. ");
INSERT INTO sny_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ane Owane Sitewi Tai Pefine a'i ano mase iroteye su, notosi etiri tomu ne'ese a'i siyeteye. Serai ane etiri ape mo fene ma'e au te'e fiyariyei. Fene aiwawe a'i. Fene tai fene lo mase iroteye su, etiri werese, tai fene lo irowe ape, fene aiwawe irowei. Serai fene ane aine tera'eyei ne totesiya.” ");
INSERT INTO sny_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Sosu lowe le ma'e itiya'u eiye, “Meni Abraham ya'ariyei meni owane nomo lo ne.” Sosu Jisas lowe ma'e eiye, “Fene Abraham lo lu tewi a'i su, serai fene werese Abraham lo wiyawi fa ta'anere. Mt 3:9 ");
INSERT INTO sny_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ahowa, fene ane aine tera'eyei ne totesiya. Owane Sitewi lai ane ma'e peri wiyeme a'i au te'eye. Serai ane fene ma'e peri wiyeme a'i eite au te'e fiyariye. Serai fene ane ma'e aine tera'eyei ne totesiya. Meni Abraham fene aiwawe se ta'ama. Abraham ya'ariyei owane fene lo, le Owane Sitewi lo au te'e siye lu au luwaruwe ta'ame. ");
INSERT INTO sny_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Fene werese tai fene lo yo seni luwaru a'i umasinamiteye.” Sosu lowe le ma'e eiye, “Mai nomo lo yo seni luwaru a'i irowe ta'ama. Serai mo'o nomo auteiye. Ahowa, nomo tai ta'i a'i irosiya. Tai nomo lo Owane Sitewi wiyeme a'i ne.” Ais 63:16 ");
INSERT INTO sny_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Sosu Jisas lowe ma'e eiye, “Ahowa, Owane Sitewi wiyeme a'i Owane Sitewi Tai Pefine a'i fene lo se ta'ame. Tai Pefine a'i ano wiyeme a'i ne. Sosu aiwawe tu ane le mase ironamiteye. Serai le ane hi awei ma'e eimawe arosai. Ane marepi ano umasi ta'ame. Ahowa, ane Owane Sitewi lo marepi a'i umasiye. Serai Owane Sitewi Tai Pefine a'i fene lo a'i su, fene werese ane ma'e marepi erasi a'i fa tote wawesiyete. ");
INSERT INTO sny_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Fene peri sitewi ano wanu so'oru ta'ama. Marepi fene lo apou a'i toteye, ‘Nomo peri lo wanuwei wou ta'ame.’ Serai fene apaniye te'ene tawesiye. ");
INSERT INTO sny_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Tai fene lo, sepei luwaru a'i Satan. Serai fene Satan lo yo seni umasiyei ne totesiya. Tu naifa weriyei le a'i lai aine tera'e siye meni wiyeme a'i tene! Peri wiyeme a'i marepi lo ironamirowata. Peri wiyeme wanure! Le a'i lai etiri werese wawero a'i au te'enamiye. Le peri wawero a'i au te'eyei su, le marepi topo lo umasiyei. Serai Satan peri wawero a'i iro siye meni. Peri wawero werese a'i le ma'e fai. Satan peri wawero lo aite tene. 1 Jo 3:8 ");
INSERT INTO sny_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ahowa, ane peri wiyeme a'i au te'e fiyariyei. Fene ane ne wanu tote tawesirowata. ");
INSERT INTO sny_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Lu taune werese ane ne apou au te'eyei ta'ama, ‘Meni ape yo seni luwaru a'i irowe.’ Ahowa, lu taune apou wou a'i te'erowata. Ane peri wiyeme a'i au te'e fiyariyei su, fene piyene peri ano wanu anirowata awere? 2 Ko 5:21; 1 Pi 2:22 ");
INSERT INTO sny_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Lu taune, Owane Sitewi lo marepi ta'i a'i iroteye ape, lowe Owane Sitewi lo peri wanu umasisiya. Fene werese Owane Sitewi ma'e fai ta'ama. Serai fene Owane Sitewi lo peri wanu umasirowata.” 1 Jo 4:6 ");
INSERT INTO sny_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Sosu a'i pe Juda lo lu tamo le ma'e eiye. “Wanure! Wiyeme a'i tene! Marepi nomo lo apou a'i toteye, ‘Ne omo Samaria lo meni tene! Ne sepei luwaru a'i marepi hepene papu irosiya.’” Mk 3:21-22 ");
INSERT INTO sny_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Sosu Jisas itiya'u eiye, “Ane sepei luwaru a'i papu ariye. Ahowa, ane Owane Sitewi Tai Pefine a'i ano lo iyape ei ani arowsiya. Sosu ate fene ane ma'e au te'e narusiya. ");
INSERT INTO sny_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Peri wiyeme a'i. Ane iyape ano ei ani arowerowata. Owane Sitewi Tai Pefine a'i wiyeme a'i iyape ano ei ani aroweyei ne totesiya. Lu taune tamo iyape ano ei ani aroweyei su, Owane Sitewi lai yo seni werese lowe lo au heseyei. ");
INSERT INTO sny_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Peri ano wiyeme a'i tene! Wanure! Lu taune tamo peri ano wanu tote tawesiyei su, lowe temeniyerowata.” Jo 5:24 ");
INSERT INTO sny_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Sosu Juda lo lu owane tamo le ma'e eiye, “Peri nomo lo wiyeme a'i tene! Sepei luwaru a'i marepi hepene no papu irosiya. Nomo so'oruwe tepa'asiye. Ya'ariyei owane nomo lo, Abraham, tu naifa weriyei temeniyeye. Sosu aiwawe Owane Sitewi lo au te'e siye lu werese temeniyeye. Nomo peri no wanuwe, ‘Nomo peri no wanu tote tawesiyei su, nomo mi mi pasi pasi weriyei temeniyerowata.’ Peri wawero tene! ");
INSERT INTO sny_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Wiyeme a'i ne a'i lai ya'ariyei owane nomo lo Abraham, hi ani ararowe ta'ama. Ahowa, ya'ariyei owane nomo lo temeniyeye. Sosu aiwawe a'i Owane Sitewi lo au te'e siye lu werese temeniyeye. Marepi no piye totesiya awere? Ne a'i lai hepene se mi mi pasi pasi weriyei teinamirowa awere? Wawero! Ne aiwawe temeniyerowa tene!” ");
INSERT INTO sny_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Sosu Jisas itiya'u eiye, “Ane a'i lai iyape ano ei ani aroweyei su, iyape ano yahowa'i ne. Ahowa, Owane Sitewi Tai Pefine a'i ano iyape ano ei ani arowenamisiya. Fene apou eiye, ‘Owane Sitewi wiyeme a'i Owane Sitewi Tai Pefine a'i nomo lo tene!’ Peri no wawero a'i tene! ");
INSERT INTO sny_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Fene werese Owane Sitewi ne so'oru ta'ama. Sosu ate ane a'i lai le ne wiyeme a'i so'oruwesiya. Aiwawe ane apou eiyei su, ‘Ane Owane Sitewi wiyeme a'i so'oru ta'ama.’ Ane peri wawero siye meni tene! Ahowa, ane le ne so'oruwe tepa'asiye. Sosu ane peri werese lo wiyeme a'i umasinamisiya. ");
INSERT INTO sny_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tu naifa weriyei ya'ariyei lu owane fene lo ane siyereme. Sosu le apou toteye. Wiyeme a'i, le aiyerowa tene! Sosu le Owane Sitewi ma'e au te'e wisereyeye.” ");
INSERT INTO sny_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Serai Juda lo lu tamo le ma'e eiye, “Ne iyu menei lu hesi tawerese ereti feni hesi siye ta'ame. Serai ne apou eiye, ‘Ane Abraham siye tepa'asiye.’ Wawero!” ");
INSERT INTO sny_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Sosu Jisas lowe ma'e eiye, “Peri ano wiyeme a'i tene! Wanure! Tu naifa weriyei Abraham lo mai le auteiye su, ane ironamiteye.” Jo 1:1 ");
INSERT INTO sny_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Sosu lowe Jisas lo peri wanuwe su, lowe ai marepi erasi totenamiteye. Lowe tapiye le ma'e ani fusawiyei ne totesiya. Ahowa, Jisas lu taune werese papu fareyareye. Serai lowe le siyerowata. Sosu le Owane Sitewi lo wesi nowe ma'e arunati fi. ");
INSERT INTO sny_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Sosu a'i pe Jisas lu disaipel lo aiwawe Owane Sitewi lo wesi arunati fi. Sosu lowe yo sahe iteye su, lowe meni ta'i, nihe pokoweyei tawesinamiteye ape, siyeye. Mai lo auteiye su, meni ape nihe pokoweyei tawesinamiteye. ");
INSERT INTO sny_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Lowe meni ape siyeye su, lu disaipel lo Jisas ma'e te'e toweriye, “Atuatu siye meni, eiwerai yo seni luwaru a'i irowe awere? Meni eite lai awere? Tai mai yo seni luwaru a'i irowe awere? Serai mai meni eite pokowe se auteiye.” Ese 18:20; Lu 13:2,4 ");
INSERT INTO sny_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Sosu Jisas lowe ma'e itiya'u eiye, “Ahowa, meni ape, aite mai aiwawe, yo seni luwaru a'i irowe ta'ama. Serai meni eite nihe pokoweyei se auteiye. Meni eite nihe pokoweyei se lo marepi si apou a'i totesiya. Serai Owane Sitewi lai meni eite se wiyawi erasi pefine a'i amerame a'i au ta'ane atuaturowa. Jo 11:4 ");
INSERT INTO sny_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Nomo hepene se irosiya su, nomo Owane Sitewi lo wiyawi au ta'anete. Nowe oso a'i su, ane awei sahe arunatirowawe, omo hire ma'e wiyei. Serai ane omo hire ma'e wiyei su, ane, meni hi awei ma'e eimawe arosai ape, ane Owane Sitewi lo wiyawi ani ta'anerowata. Fene aiwawe a'i, fene hepene se irosiya su, fene Owane Sitewi lo wiyawi pei ta'anete. ");
INSERT INTO sny_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ane hi awei ma'e irosiya su, ane a'i lai awei lo mi au tewi mitaiye fiyarisiya.” Mt 5:14; Jo 8:12 ");
INSERT INTO sny_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Sosu le peri tepa'asiye su, le peperi sahe pisa'i topohowewe, sosu le peperi ani tapowewe, nihe sahe ani teineye. Mk 8:23 ");
INSERT INTO sny_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Sosu le meni eite ma'e eiye, “Ne ire! Pitomuwe sahe, iyape Siloam nihe no sa'i au hure!” Siloam lo marepi si apou a'i toteye, “Eimawesawi.” Serai meni ape pitomuwe Siloam ma'e fi. Meni ape nihe sa'i au huwe su, nihe lo petane siyeye. Sosu le wesi topo lo ma'e si tame fi. ");
INSERT INTO sny_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Lu taune tamo meni ape lo omo irosiya ape, lowe le siyeye apou eiye, “Nomo meni ta, nihe pokoweyei tawesiye ape, iroteye. Le yo sahe ma'aru onu ei towerinamiteye. Meni ape lai awere?” ");
INSERT INTO sny_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Lu taune tere'e apou te'eye, “Ei meni ape lai ne.” Lu tere'e tere'e apou te'eye. “Ahowa, meni ape nihari aiwawe a'i ne.” Ahowa, meni ape lowe ma'e eiye, “Ane lai meni ape ne.” ");
INSERT INTO sny_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Serai lu taune werese le ma'e ei toweriye, “Ne lai meni eite irowe su, eiwerai nihe no au ta'ane petaneye awere?” ");
INSERT INTO sny_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Sosu le itiya'u eiye, “Meni ape, iyape Jisas, penare ani tapowewe, sosu nihe ano ani teineye. Nihe ani teineye su, le ane pitomuwe Siloam sa'i au huwei ne eimawesawi. Serai ane nihe ano sa'i au huwewe, sosu nihe ano au peteneye.” ");
INSERT INTO sny_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Serai lowe le ma'e te'e toweriye, “Meni ape eiwerou ma'e fi awere?” Le itiya'u eiye, “Ane so'oru ta'ama.” ");
INSERT INTO sny_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Sosu a'i pe lu owane meni ape, tu nihe pokowe tawesiye ape lu Farisi ma'e heneti. ");
INSERT INTO sny_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Sosu Jisas penare ani tapowe su, nowe amou eite se. Nowe amou se le meni, nihe pokowe tawesiye ape, au ta'ane fara'uweye. ");
INSERT INTO sny_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Sosu serai, lu Farisi le ma'e te'e toweriye, “Eiwerai nihe no au petaneye awere?” Sosu le lowe ma'e itiya'u eiye, “Meni ape penare nihe ano teineye su, ane nihe ano sa'i au huwewe, serai ane fara'u siyesiya.” ");
INSERT INTO sny_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Serai lu Farisi peri lo wanuwe su, lowe le ma'e eiye, “Meni ape nowe anou ape towesiye. Serai le Owane Sitewi ma'e fai ta'ama.” Ahowa, lu Farisi tere'e apou te'eye, “Meni ta wiyawi erasi pefine a'i irowei su, le meni luwaru a'i ta'ama.” Serai lu Farisi werese Jisas ne marepi hesi a'i hesi a'i toteteye. ");
INSERT INTO sny_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Sosu lowe meni nihe pokoweyei ma'e tame te'e toweriye, “Meni ape nihe no au petaneye su, piye marepi no meni ape ne totesiya awere?” Sosu le lowe ma'e itiya'u eiye. “Meni ape Owane Sitewi lo au te'e siye meni tene!” Jo 4:19 ");
INSERT INTO sny_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Meni ape peri tepa'asiye su, Juda lo lu owane le ne wawero a'i toteye ne! Marepi lowe lo apou a'i toteye, “Meni ape tu nihe pokoweyei tawesi ta'ame.” Serai lowe meni ape nihe pokowe lo tai mai ei aniye. ");
INSERT INTO sny_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Sosu lowesi fai su, lu owane lowesi ma'e te'e toweriye, “Meni ape meni eime fenesi lo awere? Fenesi auteiye su, le nihe pokoweyei tawesiye awere? Eiwerai nihe ape lo au petaneye awere?” ");
INSERT INTO sny_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Sosu meni eite lo tai mai lowe ma'e itiya'u eiye, “Ei, wiyeme a'i. Meni eite meni eime notosi lo tene! Notosi auteiye su, le nihe pokowe tawesinamiye. ");
INSERT INTO sny_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Eiwerai nihe lo au petaneye awere? Notosi so'oru ta'ama. Piyene le nihe se siyesiya awere? Notosi so'oru ta'ama. Le meni erasi henerai tepa'asiye. Fene le ma'e te'e towerire. Serai le a'i lai fene ma'e au te'eyei.” ");
INSERT INTO sny_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Meni eite lo tai mai Juda lo lu owane ne taweiru a'i ne. Juda lo lu owane werese marepi ta'i a'i toteye, “Lu taune tamo Jisas ne meni Krais au te'e fiyarisiya su, lu owane lowe ma'e Owane Sitewi lo wesi nowe hene ani fusawiyei.” ");
INSERT INTO sny_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Sosu lowesi lo marepi si aiwawe a'i toteye. Serai lowesi apou eiye, “Meni eime notosi lo meni erasi henerai tepa'asiye, fene le fa te'e towerire.” ");
INSERT INTO sny_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Sosu lu owane meni eite nihe pokoweyei tawesiye ape, nowe hesi a'i tame ei aniye. Sosu lowe le ma'e eiye, “Ne Owane Sitewi ma'e au te'e wisereyere! Ne peri wiyeme a'i nomo ma'e au te'ere. Meni eite, nihe no petaneye ape, le a'i lai yo peri nomo lo towesinamisiya. Le meni luwaru a'i ne.” Nomo peri eite wiyeme a'i so'oruwesiya. ");
INSERT INTO sny_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Sosu le lowe ma'e itiya'u eiye, “Meni eite yo peri fene lo towesinamisiya su, ane so'oru ta'ama. Ahowa, wanure! Ane etiri ta so'oruwesiya. Iyu menei tomu ne'ese i tepa'asiye su, ane nihe pokoweyei tawesinamiye. Serai pereye ane etiri werese siye areiyenamisiya.” ");
INSERT INTO sny_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Sosu lowe le ma'e te'e toweriye, “Meni eite lai piye ne ma'e au irowe awere? Piye yo se nihe no petaneye awere?” ");
INSERT INTO sny_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Le lowe ma'e itiya'u eiye, “Ane fene ma'e au te'e tepa'asiye. Fene peri ano wanu se ta'ama awere? Fene piyene peri ano tame wanureme awere? Marepi ano a'i totesiya. Fene aiwawe lu feni lo heneraiyei ne totesiya.” ");
INSERT INTO sny_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Sosu lowe le ma'e ai marepi totenamiteye. Le ma'e te'e naruwe. Lowe apou eiye, “Ne lai meni eite lo lu feni a'i ne. Nomo werese a'i lai Moses lo lu feni a'i ne. ");
INSERT INTO sny_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Owane Sitewi, Moses ma'e au te'eye. Nomo peri eite wiyeme a'i so'oruweye tene! Owane Sitewi meni eite ma'e au te'esiya awere? Ahowa, nomo, omo lo ma'e henerai ape, so'oru ta'ama.” ");
INSERT INTO sny_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Sosu meni ape lowe ma'e itiya'u eiye. “Wiyeme a'i tene! Fene etiri eite so'oru ta'ama awere? Meni eite lai nihe ano petaneye. Sosu fene, omo lo ape ma'e fai ape, so'oru ta'ama awere? ");
INSERT INTO sny_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Peri ano wanure! Owane Sitewi lai lu taune werese, yo seni luwaru a'i ironamisiya ape, le peri lowe lo wanu ta'ame. Ahowa, lu taune tamo Owane Sitewi lo iyape ei ani arowei su, sosu marepi lo umasiyei su, le a'i lai peri lowe lo wanuwei. Sng 34:15 ");
INSERT INTO sny_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Mai meni ta ape auteiye su, sosu nihe lo pokoweyei tawesiye su, lu taune werese nihe lo au petanerowata. Tu naifa weriyei sosu pereye a'i lu taune meni, nihe pokoweyei tawesiye ape, nihe lo au petanerowata. Ahowa, Jisas a'i lai meni nihe pokowe tawesisiya ape au petaneye. ");
INSERT INTO sny_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Owane Sitewi meni eite hi awei ma'e eimawe arosai ta'ama su, le nihe ano au petanerowata.” ");
INSERT INTO sny_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Sosu lowe ai marepi se itiya'u le ma'e eiye, “Mai no ne auteiye su, yo seni luwaru a'i marepi hepene no papu teme'eriyeye. Serai ne nomo ma'e au atuatuwei ne totesiya awere? Marepi owe ape totere!” Sosu lowe le ta'uwe wesi nowe ma'e hene ani fusawi. Sosu apou eiye, “Ne ta'uwe wesi si tame owe ape aiyete.” Sng 51:5 ");
INSERT INTO sny_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Sosu a'i pe lowe meni eite ta'uwe wesi nowe ma'e hene ani fusawi su, lu tamo au te'e tiyatiteye. Sosu Jisas peri lowe lo wanuwe su, le meni eite nehiyei ne fi. Le meni ape siyeye su, le meni eite apou ei toweriye, “Meni hire ma'e itorai ape, ne le ne wanu tote tawesisiya awere?” ");
INSERT INTO sny_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Sosu le Jisas ma'e itiya'u eiye, “Meni ape eiwerai awere? Ane meni ape ne wanu tote tawesiyei ne totesiya.” ");
INSERT INTO sny_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Sosu Jisas le ma'e eiye, “Ne meni eite siye tepa'asiye. Aiwawe a'i le ne ma'e au te'esiya. Ane a'i lai meni eite tene!” ");
INSERT INTO sny_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Sosu meni eite apou eiye, “Meni Owane Pefine a'i ne! Ane peri no wanu tote tawesisiya.” Serai le lowe uporo ape'i onuwewe, le ma'e au te'e wisereyeye. ");
INSERT INTO sny_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Sosu Jisas apou au te'eye, “Ane hi awei ma'e itorai su, marepi si apou a'i toteye. Ane lu taune werese lo yo seni au heseyei ne fai. Lu taune, yo seni luwaru a'i irowe ape, lowe meni nihe pokoweyei tawesiye aiwawe a'i ne. Serai ane nihe lo petaneyei. Lu taune tamo, marepi wara'i a'i toteye ape, ane lowe nihe pokoweyei au iro heneraiyei aiwawe a'i ne.” ");
INSERT INTO sny_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Sosu lu Farisi tamo peri lo wanuwe su, lowe le ma'e te'e toweriye, “Ne nomo ma'e au te'esiya, ‘Nomo nihe pokoweyei tawesiye.’” Mt 15:14 ");
INSERT INTO sny_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Sosu Jisas lowe ma'e eiye, “Fene apou te'esiya su, ‘Nomo yo seni luwaru a'i irorowata.’ Owane Sitewi lai fene au ferafereirowata. Ahowa, fene apou eiyei su, ‘Owane Sitewi ane yo seni luwaru a'i ironamiteye, Owane Sitewi lai yo seni luwaru a'i fene lo au sasari pamoweyei.’” ");
INSERT INTO sny_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Sosu a'i pe Jisas apou eiye, “Peri ano wanure! Wiyeme a'i ne. Ta'arei lu tamo fe sipsip ta'arei aniyei su, le tapiye se ti yose umaruwe yo wirowata. Ahowa, le tapiye sahe wirowawe, fe sipsip aine tera'e ta'arei aniyei. Le a'i lai ta'arei siye meni tene! ");
INSERT INTO sny_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Fe sipsip au noweinowei siye meni, le tapiye se ti yose umaruwe yo papu wiyei. ");
INSERT INTO sny_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Meni ape lai tapiye se ti yose aiyeyei su, umaruwe yo au noweinowei siye meni umaruwe yo le ne ani tosowei. Meni ape fe sipsip lo iyape ote aniyei. Fe sipsip peri no'u lo wanuwei. Serai fe sipsip werese lo tapiye se ti yose nowe ma'e le mo'o umasiyei. ");
INSERT INTO sny_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Sosu le fe sipsip werese nowe ma'e ei aniyei su, le tututeye. Sosu fe sipsip werese mo'o umasiyei. Lowe peri no'u lo wanu so'oruweyei su, serai lowe le ma'e umasiyei. ");
INSERT INTO sny_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Sosu meni ta tere'e fe sipsip ei aniyei su, lowe peri lo wanu ta'ame. Serai lowe le ma'e umasirowata. Lowe peri no'u lo wanuwei su, lowe itero fiyariyei. Lu tamo tere'e lo no'u, lowe wanu so'oruwe ta'ame.” ");
INSERT INTO sny_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Sosu Jisas peri anowe eite au te'eye su, Juda lo lu owane werese peri lo eti wanu so'oruwerowata. ");
INSERT INTO sny_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Serai Jisas lowe ma'e tame eiye, “Peri ano wiyeme a'i. Wanure! Ane fene ma'e au te'e areiyesiya. Ane a'i lai fe sipsip lo umaruwe yo ne. ");
INSERT INTO sny_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Lu tamo, tu fai ape, lowe fene ma'e eiye, ‘Ane a'i lai meni eite Owane Sitewi ariariyeye ape tene!’ Lowe fai su, lowe eresene a'i yo tere'e se wiyei ne totesiya. Lowe lo marepi sitewi apou a'i toteye, ‘Nomo lu taune werese lo marepi au luwaruweyei ne totesiya.’ Lowe werese ta'arei siye lu aiwawe a'i ne. Jer 23:1-2; Ese 34:2-3 ");
INSERT INTO sny_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ane a'i lai umaruwe yo a'i ne. Lu taune tamo ane wiraiyei su, ane lowe ma'e marepi hepene he'i a'i aurowa. Serai lowe ane ma'e si wiraiyei. Sosu ane lowe ma'e yo seni luwaru a'i lowe lo au sasari pamowerowawe, lowe ma'e marepi hepene he'i a'i aurowa. ");
INSERT INTO sny_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ta'arei meni aiyeyei su, marepi lo apou a'i toteyei. ‘Ane fe sipsip tamo ta'arei aniyei, sosu au luwaruweyei, sosu lowe aine tera'eyei. Ahowa, ane lu taune ma'e marepi hepene he'i a'i auwei ne fai. Ane marepi hepene he'i erasi a'i auwei ne fai. ");
INSERT INTO sny_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ane a'i lai fe sipsip lo au noweinowei siye meni wisere a'i ne. Fe sipsip lo au noweinowei siye meni wisere a'i ne. Le fe sipsip ma'e marepi erasi tote wawesiyesiya. Serai le fe sipsip lo ne temeniyeyei ne au atoweiye ta'ame. Ane lu taune werese ma'e aiwawe a'i marepi erasi a'i tote wawesiyesiya. Serai ane lai lowe ne au temeniyeyei. Sng 23:1; KTH 7:17 ");
INSERT INTO sny_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","13","Meni ta ma'aru se wiyawi ani siye meni, le fe sipsip lo au noweinowei siye meni ta'ame ne. Le fe sipsip werese lo ariye. Serai le ma'aru se wiyawi ta'aneyei. Sosu le fe sipsip au noweinoweiyei su, le fe sipsip marepi erasi a'i tote ta'ame. Sosu you erawe tamo fe sipsip aine tera'eyei ne aiyeyei su, ma'aru wiyawi meni atoweiye iterotiyei. Serai you erawe tamo fe sipsip werese ani umasi fiyarirowa. Sosu you erawe lai fe sipsip tamo tomu tera'e tou ene arowa. Ap 20:29 ");
INSERT INTO sny_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Ane a'i lai fe sipsip lo au noweinowei siye meni wisere a'i ne. Ane Owane Sitewi Tai Pefine a'i ano siye so'oruwesiya. Aiwawe a'i Tai Pefine a'i pefine a'i ano ane ne siye so'oruwesiya. Serai ane lu taune werese ne, yo seni ano umasisiya ape, siye so'oruwesiya. Aiwawe a'i lu taune werese ano ane ne siye so'oruwesiya. Serai ane lu taune werese ano ne au temeniyeyei. Mt 11:27; 1 Jo 3:16 ");
INSERT INTO sny_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ane fe sipsip tere'e, tapiye ti yoseye ape, nowe ma'e irosiya. Ane lowe werese ane ma'e ei anirowa. Lowe werese peri no'u ano wanu umasisiya. Ane lowe werese ta'uweraiyei. Serai lowe werese werese lu feni ta'i a'i heneraiyei. Sosu ane ta'i a'i lowe werese au noweinoweiyei Ais 56:8; Ese 34:23 ");
INSERT INTO sny_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Owane Sitewi Tai Pefine a'i ano wiyeme a'i ane ne marepi erasi a'i totesiya. Sosu aiwawe ane lu taune werese ano marepi erasi a'i totesiya. Serai ane lowe werese ma'e temeniyeyei no ape auwei. Ane temeniyeyei su, ane hepene se si tame hene aniyei. Fl 2:8-9 ");
INSERT INTO sny_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ane temeniyeyei su, meni ta ane aine tera'erowata. Ahowa, ane marepi ano umasisiya. Serai ane temeniyeyei ano ape auwei. Kairefiyeyei ano se, temeniyeyei ano ape, ane fara'u auwei. Sosu aiwawe kairefiyeyei ano se ane fara'u marepi hepene ano si tame hene aniyei. Peri wiyeme eite ane Owane Sitewi Tai Pefine a'i ano ma'e wanu aniye.” ");
INSERT INTO sny_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Sosu a'i pe Jisas peri ape lo au te'e tepa'asiye su, Juda lo lu taune werese marepi hesi a'i toteye. ");
INSERT INTO sny_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Lu taune tamo le ne apou te'eye, “Meni ape sepei luwaru a'i papu irosiya. Marepi lo meremereye a'i ne. Fene piyene peri lo wanusiya awere?” ");
INSERT INTO sny_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Sosu lu taune tere'e apou eiye, “Wanure! Meni ta sepei luwaru a'i papu irosiya ape, peri eite au te'erowata. Sepei luwaru a'i lai meni pokoweyei tawesiye ape, nihe lo au petanerowata.” ");
INSERT INTO sny_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Sosu a'i pe ta'uwe hereiyei ta iyape, Owane Sitewi lo wesi tosowe. Ta'uwe hereiyei ape lo nowe henerai tepa'asiye. Lu taune werese Owane Sitewi lo wesi ma'e Jerusalem sahe nowe ape marepi tote tawesiyei ne ta'uwerai. ");
INSERT INTO sny_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Nowe ape se naretei a'i ne. Sosu Jisas Owane Sitewi lo wesi sahe Solomon lo aise perei ma'e uweiye. ");
INSERT INTO sny_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Juda lo lu owane tamo Jisas ma'e siyeyei ne ta'uwerai. Sosu lowe le ma'e te'e toweriye, “Ne nomo ma'e amerame a'i fa au te'ere! Ne meni, Owane Sitewi lai hi ma'e eimawe arosaiyei ne ariariyeye ape, apou a'i Krais awere? Ne peri amerame a'i nomo ma'e itiya'u au te'ere!” ");
INSERT INTO sny_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Sosu Jisas lowe ma'e itiya'u eiye, “Ane fene ma'e au te'e tepa'asiye. Fene peri ano wanuwe awere? Ahowa, fene peri ano wanu tote tawesirowata. Wiyawi erasi pefine a'i, ane irowe ape, Owane Sitewi Tai Pefine a'i ano lo iyape se ane lai irowe. Wiyawi erasi pefine a'i ape ano ane ne amerame a'i au te'e areiye tepa'asiye. ");
INSERT INTO sny_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ahowa, fene werese fe sipsip ano ta'ame ne. Serai fene wiyawi erasi pefine a'i ano siyeye su, fene ane ne tote tawesi ta'ame. ");
INSERT INTO sny_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Fe sipsip werese ano peri no'u ano wanuwewe, ane ma'e umasisiya. Ane fe sipsip werese ano siya so'oruwesiya tene! ");
INSERT INTO sny_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Sosu ane lowe werese ma'e marepi hepene he'i a'i aurowa. Serai lowe mi mi pasi pasi weriyei ironamitorowa. Lowe mi mi pasi pasi temeniyerowata. Lu tamo lowe ereti ano sahe ani tepa'asi anirowata. Jo 3:16; 6:39 ");
INSERT INTO sny_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Owane Sitewi Tai Pefine a'i ano lu taune werese ano ane ma'e au tepa'asiye. Le a'i lai lu werese hi ani fu araro tepa'asiye. Lu tamo lu feni ano Tai Pefine a'i lo ereti sahe ani tepa'asi anirowata. ");
INSERT INTO sny_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ane sosu Owane Sitewi Tai Pefine a'i ano notosi ta'i a'i henerai ne. Notosi marepi ta'i a'i ne. Notosi wiyawi ta'i a'i ta'anesiya.” ");
INSERT INTO sny_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Sosu a'i pe Juda lo lu peri ape lo wanuwe su, lowe tapiye le ma'e ani fusawiyei ne toteye. ");
INSERT INTO sny_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Sosu Jisas itiya'u eiye, “Ane fene ma'e wiyawi erasi pefine a'i tamo Owane Sitewi Tai Pefine a'i ano ma'e fai ape, au atuatuwe. Piye wiyawi ano fene ane ma'e tapiye se ani fusawiyei awere?” ");
INSERT INTO sny_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Sosu Juda lo lu le ma'e itiya'u eiye, “Wiyawi erasi no nomo tapiye ne ma'e ani fusawiyei ta'ama. Ahowa, ne meni a'i ne. Marepi no apou a'i totesiya, ‘Ane Owane Sitewi aiwawe a'i ne!’ Ne Owane Sitewi ma'e au te'e naruwe. Serai marepi sitewi ape nomo ne ma'e tapiye ani fusawiyei.” Wkp 24:16 ");
INSERT INTO sny_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Sosu Jisas itiya'u eiye, “Tu naifa weriyei, lu tamo Owane Sitewi lo peri wanunamiteye. Yo peri fene lo sahe lowe ne apou leseteye, ‘Owane Sitewi lowe ma'e eiye, fene ane aiwawe a'i ne.’ ");
INSERT INTO sny_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","36","Owane Sitewi lai ane ma'e ariariyeye, sosu le ane hi awei ma'e eimawe arosai. Serai ane lai Owane Sitewi lo meni eime au te'esiya su, marepi fene lo apou a'i totesiya. ‘Le Owane Sitewi ma'e au te'e naruwe.’ Owane Sitewi lo peri wawero a'i au te'erowata. Ahowa, Owane Sitewi lo peri wiyeme a'i tene! Fene Owane Sitewi lo peri wanure! Owane Sitewi lai apou eiye, ‘Lu eite mo Owane Sitewi aiwawe a'i ne.’ Serai ane apou eiye su, ‘Ane Owane Sitewi lo meni eime ne.’ Fene marepi ape owe ape totere! ‘Ane Owane Sitewi ma'e au te'e naruwe.’ Ane Owane Sitewi ma'e au te'e naru ta'ame. ");
INSERT INTO sny_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Peri ano wanure! Wiyawi erasi pefine a'i ano ne, ane Owane Sitewi Tai Pefine a'i ano lo wiyawi ta'ane ta'ame su, fene ane ne owe ape wanu tote tawesire. ");
INSERT INTO sny_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ahowa, ane Owane Sitewi Tai Pefine a'i lo wiyawi ta'aneyei su, sosu fene ane ne fa wanu tote tawesire. Fene peri ano tote tawesi ta'ame su, fene wiyawi erasi ano fa siyere. Fene wiyawi ano siyeyei su, serai fene etiri ape siye so'oruwe tepa'asiye. Apou a'i so'oruweyei ape ne, Tai Pefine a'i ano lai ane papu irosiya. Sosu aiwawe ane lai Tai Pefine a'i ano papu irosiya.” Jo 14:10-11 ");
INSERT INTO sny_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Serai Juda lo lu Jisas ma'e ai marepi totenamiteye. Sosu lowe le ma'e ereti tame anite tawesiyei ne toteye. Ahowa, le eresene a'i lu taune werese mase fareyare fi. Sosu lowe le siye ta'ame. ");
INSERT INTO sny_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Sosu a'i pe Jisas Owane Sitewi lo wesi arunati fiyewe, le Sa'i Mai Jordan feni eire ma'e fi. Saro ahe tu naifa meni Jon lu taune tamo sa'i au huteye. Pani ape sahe Jisas saro iroteye. Jo 1:28 ");
INSERT INTO sny_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Sosu lu taune tomu ne'ese le ma'e ta'uwerai. Lowe le ne apou te'eye. “Meni ape Jon lai wiyawi erasi pefine a'i aiwawe a'i iro ta'ame. Ahowa, Jon lo peri werese Jisas ne wiyeme a'i tene!” ");
INSERT INTO sny_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Sosu omo ape sahe lu taune tomu ne'ese Jisas lo peri wanu tote tawesi umasiye. ");
INSERT INTO sny_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Sosu a'i pe meni ta iyape Lasarus, omo Betani iroteye ape, u tahe erasi a'i ya'oreye. Omo Betani sahe Lasarus, einei hesi aiwawe a'i iroteye. Lowesi lo iyape Maria, taune pa'ise lo Marta. Lu 10:38-39 ");
INSERT INTO sny_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Tu naifa Maria, Jisas lo lowe sa'i heneri se au ani teineye. Sosu le mato towe lo Jisas lo lowe au ani teine foro'oweye. Jo 12:3 ");
INSERT INTO sny_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Sosu Lasarus u tahe erasi a'i su, taune einei hesi Jisas ma'e peri ta ausawi. Lowesi apou eiye, “Meni Owane, kaiyemo no u tahe erasi a'i lai ya'oresiya. Ne le ne marepi erasi a'i tote wawesiyesiya.” ");
INSERT INTO sny_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Sosu Jisas peri eite wanuwe su, le apou eiye, “Lasarus lo u tahe au temeniyerowata. U tahe se ape Owane Sitewi lo iyape ei ani aroweyei. Sosu aiwawe Owane Sitewi lo meni eime lo iyape ei ani aroweyei.” Jo 9:3 ");
INSERT INTO sny_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Sosu Jisas lai taune einei hesi Maria, Marta, Lasarus aiwawe a'i marepi erasi a'i tote wawesiyenamiteye. ");
INSERT INTO sny_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Sosu Jisas Lasarus lo u tahe ne wanuwe su, le nowe poweiye hesi a'i omo ape sahe onuteye. ");
INSERT INTO sny_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Nowe poweiye hesi a'i i tepa'asiye su, le lu disaipel lo ma'e apou eiye, “Nomo omo Betani pani Judia sahe tame iyei.” ");
INSERT INTO sny_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Lu disaipel lo le ma'e eiye, “Atuatu siye meni, lu Juda ne ma'e tapiye se ani fusawiyei ne totesiya. Ne si tame iyei awere?” ");
INSERT INTO sny_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Sosu Jisas itiya'u eiye. “Nomo le ma'e iyei ne. Nowe tewi a'i ereti feni hesi lowe hesi a'i (12) poweiye ta'i sahe irosiya. Lu taune tamo poweiye lo mi a'i uweisiya su, lowe ato ninapunerowata. Lowe poweiye lo mi siyeye su, serai lowe ninapunerowata. Ane awei sahe irosiya su, ane Owane Sitewi Tai Pefine a'i ano lo wiyawi pei anite. ");
INSERT INTO sny_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ahowa, lu taune tamo pasi a'i iteyei su, mi werese ariye. Serai lowe ato ninapune winetaiyei. Ane a'i lai mi pefine a'i ne. Lu taune tamo ane ma'e umasiyei su, ane lowe ma'e mi pefine a'i auwei. Sosu lu taune ta ane ne wanu tote tawesiyei ta'ama su, lowe ato ninapuneyei. Lowe temeniyeyei aiwawe a'i ne.” ");
INSERT INTO sny_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Sosu le peri ape tepa'asiye su, mo'o le lu disaipel lo ma'e apou eiye, “Kaiyemo nomo lo Lasarus nihe howei tepa'asiye. Sosu ane le ma'e iyei. Serai ane le ma'e ani eisowe sineyei ne iyei.” ");
INSERT INTO sny_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Lu disaipel lo le ma'e te'eye, “Meni Owane, le nihe howeisiya su, le a'i fara'u eisowe sineyei. Sosu u tahe lo fara'u heneraiyei.” ");
INSERT INTO sny_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jisas lo marepi si apou a'i toteye, “Meni ape Lasarus, temeniye tepa'asiye.” Ahowa, lu disaipel lo marepi sitewi apou toteye, Lasarus lai nihe howeisiya. ");
INSERT INTO sny_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Sosu serai Jisas lowe ma'e au te'e areiyeye. “Lasarus temeniyeye. ");
INSERT INTO sny_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Lasarus temeniyeye su, nomo sato ahe onusiya. Ane fene ne marepi wisere a'i ne. Serai fene ane ne fu tote tawesire. Meni Lasarus temeniye ta'ame su, fene kairefiyeyei ano siye ta'ame. Sosu nomo le ma'e iyei ne.” ");
INSERT INTO sny_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Sosu Tomas, iyape tere'e Didimus, lu feni tere'e tamo ma'e eiye, “Nomo le mase iyei. Sosu le temeniyeyei su, nomo le mase aiwawe a'i temeniyeyei.” Mk 14:31 ");
INSERT INTO sny_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","18","Sosu a'i pe Jisas lu disaipel lo aiwawe a'i omo Betani ma'e fi. Omo Betani, Jerusalem ma'e atahe a'i ne. Lowe omo Betani heneri su, Lasarus fisiye yo papu poweiye hesiyo hesiyo i tepa'asiye. ");
INSERT INTO sny_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Sosu Juda lo lu taune tomu ne'ese einei hesi a'i ma'e ta'uwerai. Lowe lowesi ma'e metare lowesi lo ne marepi fetane a'i auwei ne fai. ");
INSERT INTO sny_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Sosu menitani Marta apou a'i wanuwe, “Jisas aiyesiya.” Serai le Jisas ma'e yo mai sahe siyeri. Sosu menitani Maria wesi papu onunamiteye. ");
INSERT INTO sny_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Sosu Marta Jisas ma'e eiye, “Owane, ne tu fai su, metare ano temeniye ta'ame. ");
INSERT INTO sny_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Etiri eite ane so'oruwe tepa'asiye. Ne Owane Sitewi ma'e etiri ta au ei toweriyei su, Owane Sitewi lai ne ma'e marepi no auwei.” ");
INSERT INTO sny_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Sosu Jisas le ma'e eiye, “Metare no si tame ta'ane norohuwe hene ani sinerowa.” ");
INSERT INTO sny_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Sosu Marta le ma'e eiye, “Wiyeme a'i ne. Nowe ye'ewi su, le si tame ta'ane norohuwe hene ani sinerowa. Ane so'oruwesiya!” Jo 6:40 ");
INSERT INTO sny_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Sosu Jisas itiya'u eiye, “Ane a'i lai lu taune werese ma'e hene anirowa. Sosu aiwawe ane a'i lai lowe ma'e marepi hepene he'i a