﻿USE sofia;
DROP TABLE IF EXISTS sofia.snx_vpl;
CREATE TABLE snx_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES snx_vpl WRITE;
INSERT INTO snx_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Sam wa Xotei ido ngidibi ido sam beli kului. Ido donyam Yesus Kristus. ");
INSERT INTO snx_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Propet Aisaian inggrengalox, “San hajo mob suma so ada nyi udumbin nomi ana kulodxo. Adun ino gaman gereidox. ");
INSERT INTO snx_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Suma be ido ma angi so rauxbe sam des ne mendelxo, ‘Xiliyai ido gaman gereisine, so tenemdax.’ ” ");
INSERT INTO snx_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Silane Jon Baptais desne so raurxbe nenxa sumaxangglixja yag kunggu dinjisilxo. Ido sam ne publab disne sumaxangglixja une yi soubxo ne udisne aib bulbane Xotei ana une xendei hunjax munjurulxo. ");
INSERT INTO snx_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Judia distrik xo Jerusalem taunx isxo sumaxangglixjax kumogxo adu sib mo soubxo. Andug indo une babdubane Jon ana Jodan yag kunggu dinjisilxo. ");
INSERT INTO snx_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon kamel ido uli ne bugax tag sine let kalembe xerix disilxo. Sisne adu habu xo bisin gagx ya hesilxo. ");
INSERT INTO snx_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Wa ido sam, “Sa bungex be suma be bail ana maxdixo. Adun sa yelubixone yoglodxo. Sa suma beli jal pinden ana ido su ido sel ne mberengdax kerejal. ");
INSERT INTO snx_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Sana nyingga yag kunggu dinggixam, nedine adun nyingga Kanin Mundor ana baptaisnggedxo.” ");
INSERT INTO snx_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Nal nenxa Yesus adu Nasaret taun Galili distrik maglib inggam lelane Jon ana Jodan yagbe yag kunggu dulxo. ");
INSERT INTO snx_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yesus yagbe sam loxolane lang hobox asine Xotei ido Mundor ne langbe sam goul pala yogololxo. ");
INSERT INTO snx_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Silane ma be lang bugbe sam yogololxo. Ma ne adu sis mendelxo, “Nyi hajo du, sa nyi dobisx na, sa nyi xasi pari beli xiliyai bisxna.” ");
INSERT INTO snx_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Sis nenx ya Kanin Mundor ana gasanx soilane so raurbe minjelxo. ");
INSERT INTO snx_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Adu mosne so raurbe meleng 40 silane Satan ana toum lox. Adu werapin juwan jagar silane Xotei ido sombu andug ana xumar soubxo. ");
INSERT INTO snx_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Bungex Jon talu halib hogobane, Yesus Galili distrik be mosne Xotei ido sam beli publab dis munjurulxo. ");
INSERT INTO snx_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Nal dax ne de xuradixo,” adu mendelxo, “Xotei ido kingdom dax kulubx na bulsine Xotei sib minjax! Ido sam beli wa xabu ud ayax!” ");
INSERT INTO snx_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Saimon xo ido aubi kanangge Endrux xumam xedel ne isxo kinggal, nenxa yag korob suwen asui soulxo. Sisne Yesus adu Galili yag koro xou soxsine woxsi asux xoxnjulxo. ");
INSERT INTO snx_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesus ana manjis munjurulxo, “Les sa soxbela! Silane sana nyisxa suma pax suwen xasuiya usernggedxm.” ");
INSERT INTO snx_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Nal nenx ya gasanx asux isxo suwen udisne adu sox youlxo. ");
INSERT INTO snx_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Adu giringx si mosne Jems Sebedi ido ngidibi xo ido aubi kanangge Jonx kubung maglib seoulx ne xoxnjulxo. Asux suwen gerei seoulxo. ");
INSERT INTO snx_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Gasanx Yesus asux manjulxo. Asux isxo alabi Sebedi kubung maglib nenxa kinggal suma jagar udinjisne asux Yesus sox youlxo. ");
INSERT INTO snx_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Andug Kapenamx taun minjoubxo. Sabat nal alane Yesus Ju indo bojou maglib mosne sumaxangglixja xele hunjisilxo. ");
INSERT INTO snx_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Adun andug sam munjiri silxo ne, suma xele pe xuraxo nedana sam palai silxo. Nenxa sumaxangglixja andug adu sam publab dulx ne andug pudox hali aiyoubxo. Adu manam sam ido xele suman sam palaijal. ");
INSERT INTO snx_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Sis silane suma be mundor hali ana alul lox ne Ju indo bojou inggam maalox, ");
INSERT INTO snx_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Yesus, Nasaret suma, nyi ga koxra gax si? Nyi ga alul gax lexam, e? Sa nyi xele nyi Xotei ido suma une xujalxo!” ");
INSERT INTO snx_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","“Tenenem a!” Yesus ana korlox, “Nyi hamegx adu udisne habrex da!” ");
INSERT INTO snx_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Mundor halin suma ne hagdulane rexrexasi xoeng alulsine habrexbe dalxo. ");
INSERT INTO snx_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Sumaxangglixja pudox hali amai youbxo. Sisne andug indo indo da inar aiyoubxo, “Mangau wa xa? Sam wa kexei ido bail dili! Adu mundor hali hegaganji xanden andug adu sam xe huiyisxa.” ");
INSERT INTO snx_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Adu ido sam ne Galili distrik maglib nenx ya serx belelai lox. ");
INSERT INTO snx_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Andug Ju indo bojou serx udisne Jems xo Jonx jagar Saimon xo Endrux isxo urumbe minjoubxo. ");
INSERT INTO snx_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saimon ido mugumabi do ngaring lane wil asilxo. Nenxa andug ana Yesus adu xasi serx mundoubxo. ");
INSERT INTO snx_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Silane adu xanggli ne sib mosne barge pesne soxorlox. Do ngaring adu udulane adu andug dubli palxo. ");
INSERT INTO snx_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Sabat nal ayox alane bunge seng kulolane suma kumogx indo gembax suma xo suma mundor halin alulnjulxo ne garwernjis Yesus sib leubxo. ");
INSERT INTO snx_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Taun ne maglib sumaxangglixja kumogx lesne urum mbour kulub nenxa tumbang aiyoubxo. ");
INSERT INTO snx_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Siylane Yesus ana gemba kulu dide dide aiyoxdi hunji silxo. Sisne mundor hali lambei xendei hunji silxo. Andug adu suma ye ne andug xele nenxa adu mundor hali xarwinji xanden samajal. ");
INSERT INTO snx_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Koglix hali so xaluxalugx, Yesus xuduasine so derx beb mosne geinalox. ");
INSERT INTO snx_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Saimon xo kinggal suma dagi jagar adu xedelasi mos ");
INSERT INTO snx_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","tordisne mundoubxo, “Sumaxangglixja kumogx nyi xedel mbisxa!” ");
INSERT INTO snx_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yesus andug sis munjurulxo, “Ga tubarbeb bili mosne sa sam nenx publab duda. Sa kulu nenx xasi yoglomonxo.” ");
INSERT INTO snx_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Sisne adu Galili distrik maglib nenxa lumbiasine Ju indo bojoube sam publab disne mundor hali xendeinji silxo. ");
INSERT INTO snx_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Suma hogar nyam wo dili ne adu sib les tomblongsine gwari inaralox, “Ae, nyi sa gereibax ud asine sa jaxal dube.” ");
INSERT INTO snx_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesus adu xasi pari xurang sisne barge soxorsi adu usub pidelxo ne sis mundulxo, “San yudxm. San nyi jaxal dumbixam!” ");
INSERT INTO snx_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Gasanx hogar nyam wo ne suma ne udulane adu beli alox. ");
INSERT INTO snx_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Yesus suma ne serx soisine kokoilox, “Suma be mundi mundiyaxjal nedine ino dodamug nei mosne Xotei ido kinggal suma ne usernjax. Sisne jaxal ido atra Moses ana manam sam bail dulxo ne soxsine jaxal ido atra ne yax, mangau simane suma xele aiyaxabarxo ino gemba ayox ayiux.” ");
INSERT INTO snx_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Nedine adu mosne ido beli alox ne sumaxangglixja sam ne boyoalox. Silane Yesus adu taun be palagx duxa dejal, ne adu taun xoub silxo. Nedine suma so kumogx adu sib le soubxo. ");
INSERT INTO snx_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Meleng dagi udisne, Yesus bili Kapenamx taunbe minjelxo. Suma kumogx xeubx ne adu ido urumbe silxo. ");
INSERT INTO snx_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Nenxa suma lambeiyai tumbang asine urum maglib talu be lolx si jal max asine les habrexbe mbourbe ne dide andosomx max tegteg aiyoubxo. Siybane adun Xotei sam publab disilxo. ");
INSERT INTO snx_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Suma 4 suma be kwesang xo bargex mexo ne xuwa baxlub sam soxomasi leubxo. ");
INSERT INTO snx_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Sumaxangglixjax ana so ne max tegteg abane andug suma ne pes Yesus sob minjax kumbli asine urum kunda xoxeng disne suma kwesang xo bargex mexo ido xuwa baxalu ne inggam sel be sam gosing dubane Yesus parib kulolxo. ");
INSERT INTO snx_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesus adu indo xabu ud xoxsine adu suma barge xo kwesangx mexo ne mundulxo, “Du, ino une ayox.” ");
INSERT INTO snx_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Manam sam ido xele suma dagi nenx njanjan soubxo. Ne andug indo udud maglib ud siyoubxo, ");
INSERT INTO snx_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Kulu xax suma ne adu sam sis mendex na? Adu Xotei asreisi ne awau sixna! Suma yen une xendeiyax kere? Xotei idoi kere!” ");
INSERT INTO snx_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yesus adu ido udud maglib gasanx xele uradulxo ne andug ud suxne pes soubxo. Siybane adun sis munjurulxo, “Kulu xax nyingga ud suxne pesxa? ");
INSERT INTO snx_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Sam uran xa suma wa munduda? ‘Ino une ayox’ ko ‘Ting asi ino baxalu pes minje’ ko? ");
INSERT INTO snx_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ne nyingga xele siyax, Suma ido Ngidibi adu miyanghanggub sumaxangglixjax une xendei hunjax bail dili.” Adun suma barge xo kwesang mexo ne mundixo, ");
INSERT INTO snx_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Sana nyi mumbrixama tingasi ino xuwa baxalu pes ino urumbe minje.” ");
INSERT INTO snx_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Adu tingasi suma kumogx nyambe ido xuwa baxalu gasanx pesne minjelxo. Nedana suma kumogxo pudox hali asine Xotei donyam peding disne sis mendoubxo, “Xehei, ga mangau sux wa nomi be xoxjal tenemxo!” ");
INSERT INTO snx_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesus bili yag koro xoub minjelane sumaxangglixjax lambeiyai les adu sib tumbang aiyoubxo. Siybane adun Xotei ido sam manamnjisilxo. ");
INSERT INTO snx_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Adu xensi mosne Alpius ngidibi Liwai takis pesxa sob nenxa njan asilxo xoxsine mundulxo, “Sa soxbe.” Yesus ana sis mundulane Liwai tingasine soxlox. ");
INSERT INTO snx_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yesus Liwai urumbe pin hes silane andug lambeiyai adu sox soubxo. Nenxa takis pesxa suma xo une suma xo Yesus ido sox sumax, adu jagar njanasi pin hes soubxo. ");
INSERT INTO snx_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Parisi andug manam sam ido xele suma andug ana adu xox youbxo ne adu une suma xo takis pesxa suma jagar pin hes silane andug ana ido sox suma inarnjoubxo, “Kulu xax adu takis pesxa suma xo une sumax jagar pin hesx na?” ");
INSERT INTO snx_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesus sam ne xes ne munjurulxo, “Suma gemba xujalxo ne dokta sob mo jalxa, suma gembax ya ne andug dokta sob mosxa. Sa suma une xujalxo ne manjax yogoljal, sa suma une dili nenx xasi yoglomonxo.” ");
INSERT INTO snx_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Jon ido sox suma xo Parisix andug pin kudeng ayoubxo. Siybane suma dagin lesne Yesus inar youbxo, “Kulu xax Jon ido sox suma xo Parisix indo sox suma xo andug pin kudeng asixa. Nedine nyi ino sox suma andug pin kudengajalx?” ");
INSERT INTO snx_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesus ne xes ne aib munjurulxo, “Pinaxa suma xanggli pax ne nenx jagar simane ido marar pin kudeng ayaxbarxo? Adu andug jagar six na, nenxa andug siyax kerejal. ");
INSERT INTO snx_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Nedine nal be dadxo, nal nenxa xanggli pax suma ne pen didei dubane nal nenxa andug pin kudeng ayaxbarxo. ");
INSERT INTO snx_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Suma ben bugax jagre kexei penane bugax ai nggina ayaxman. Bugax kexei nedana ai ne mundrung dudux, ne bodox xiliyai dadxo. ");
INSERT INTO snx_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Suma ben werapin xo mundrung penane wain kexei hogaxman. Wain bising ana denane wain xo werapin xo digi hali ayaxlox. Nenxa adu wain kexei ne werapin xo kexeib xuruxdox.” ");
INSERT INTO snx_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sabat bexo Yesus adu wit yu mbelembe minjelxo. Silane ido sox suman wit dagi tam kului soubxo. ");
INSERT INTO snx_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Parisin adu mundubxo, “Pinaxa andug Sabat ido manam sam xulaisi mangau ne yix a?” ");
INSERT INTO snx_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesus ana aib munjurulxo, “Nyingga wasaajalxa ne Devid xo ido sox sumax mamnjul mangau xa youbxo a? ");
INSERT INTO snx_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Nal nenxabe Abiata adu pris gadi silxo. Devid Xotei ido urum maglib mosne beret suma ben heaxjalxo pris indoiya heax ne adun kanin ne bubrax disne beret ne hesne ido suma jagar nanjulxo.” ");
INSERT INTO snx_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Sisne adun munjurulxo, “Xotei sumaxangglixja Sabat toromyax koraajal. Xotei Sabat sumaxangglixja toromnjax koraalox. ");
INSERT INTO snx_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nenxasi Suma ido Ngidibi adu dide sux Sabat ido Aiyama.” ");
INSERT INTO snx_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Nal bexo Yesus Ju indo bojou maglib minjelxo. Suma be barge kwadebx mexo ne adu nenx silxo. ");
INSERT INTO snx_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Nenxasi suma dagi andug Yesus Sabat xabe suma gereidox, nenxa andug nyam per soubxo. Andug ido ugel ne xoxsine mendax xasi. ");
INSERT INTO snx_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesus ana suma barge mexo ne mundulxo, “Nyi wa lema!” ");
INSERT INTO snx_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Sisne Yesus andug inarnjulxo, “Mangau xa Sabat xabe yaxmun ne beli? Mangau beli yax e, mangau hali yax e? Suma kexei sax toromnjax e, suma kiyangnjax e?” Sis munjurulane andug sam be mendejal tenenem asoubxo. ");
INSERT INTO snx_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Adu andug xoxnjoulxo ne andug pari tunggulnjisilxo. Nenxasi adu pari beli jal adu agraglane adu suma ne mundulxo, “Ino barge padid yu.” Adu barge padidlane ido barge belialox. ");
INSERT INTO snx_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Parisi andug gasanx mosne Herot ido sox suma jagar andug gaman xab sam Yesus taxaleb miyax nenxasi sam keredi soubxo. ");
INSERT INTO snx_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesus ido sox suma jagar andug so ne udisne andug Galili yag koro nenxabe minjoubxo. Sumaxangglixjax lambeiyai andug soxnjisne minjoubxo. ");
INSERT INTO snx_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Suma lambeiyai adu mangau xa yisilxone andug xes ne adu sib leubxo. Andug Galili xo Judia xo Idumiax distrik sam leubxo. Jerusalem taunbe xo Taia xo Saidon taun kolinjis soubxo ne inggam sam leubxo. Jodan yag inggamxa sam leubxo. ");
INSERT INTO snx_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Adu suma lambeiyai gereinjis silxane beli asoubx. Nenxa suma dagi gemba xone adu kundung dax nenxasi da bijaasi mo soubxo. Suma lambeiyai nenxa Yesus ana ido sox suma munjurulane kubung kanangge be pesne per huyubxo. Kulu xax suma lambei ana sin adu pari sung yax barxo. ");
INSERT INTO snx_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Mundor hali adu xoxsine tomblongsi xoeng haroisi sis mendoubxo, “Nyi Xotei ido Ngidibi.” ");
INSERT INTO snx_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Nedine Yesus ana andug sam kokonji silxo, andug adu suma ye ne sam boiyo aiyax kornjulxo. ");
INSERT INTO snx_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesus gabrab woxsine suma maranjixone manjulane adu sib xoubxo. ");
INSERT INTO snx_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Adun suma 12 maranjulxone adu jagar sibane adun donyam aposel hunjudxo. Sisne adun sonjum mos Xotei sam publab disne ");
INSERT INTO snx_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","mundor hali xendei yax bail hunjudxo. ");
INSERT INTO snx_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Yesus adu ido sox suma 12 maranjulxone indo donyam ne xiwad: Saimon, Yesus ana donyam Pita adu huyulxo, ");
INSERT INTO snx_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Sebedi ido ngidibi Jems ne aubi kanangge Jon ne adun donyam Boanerges ne hunjulxo. Donyam nenx ido kulu ne “asux kele du pala.” ");
INSERT INTO snx_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ne Endru ne Pilip ne Batolomiu ne Metiu ne Tomas ne Jems, Alpius ido ngidibi, ne Tadius ne Saimon be adu Selot suma, ");
INSERT INTO snx_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ne Judas Iskariot, Yesus ido sosolox suma. ");
INSERT INTO snx_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Sisne Yesus urum maglib pin heax mosne suma lambeiyai des tumbang abane Yesus ido sox suma jagar andug pin heax gogoin ayoubxo. ");
INSERT INTO snx_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Yesus ido malanggu sam xe sisne andug mendoubxo, “Yesus adu laxayiux.” Nenxa andug Yesus paxasi minjoubxo. ");
INSERT INTO snx_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Manam sam ido xele suman Jerusalem inggam yogolsine mendoubxo, “Bielsebul adu sib sixna! Adu mundor hali indo gadi nenxasi adu mundor hali xendei six.” ");
INSERT INTO snx_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Siybane Yesus andug manjisne yaul sam be sam munjurulxo, “Koxrai na Satan idoi aib Satan xendeidox? ");
INSERT INTO snx_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kantri be gobu ana indo indo aib xubrax barxone kantri ne si beli yaxman. ");
INSERT INTO snx_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Urum be maglib malanggu ne gobu ana indo indo aib xubrax barxone, urum ne si beli yaxman. ");
INSERT INTO snx_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Satan idoi aib ido xuber per huyudxone adu ido bail ne gobu ana adu bail tingayaxman. Adu ido nal ayox ne dex ined. ");
INSERT INTO snx_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Suma bena suma bail hali urum maglib mosne pinhalel lolx pax kerejal. Adu sel bail penane suma bail dili ne xaxoi xuradinane adu urum maglib monane pinhalel yuwemadox. ");
INSERT INTO snx_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Sa nyingga xabu munggrixam, Xotei ana sumaxangglixja indo une kumogx asreisine awau sixane hali ne ayox dudxo. ");
INSERT INTO snx_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Nedine Xotei ana sumaxangglixja ye Kanin Mundor asreisi awau sixane indo une ne xendeiyaxman. Une ne andosom sina sidxo.” ");
INSERT INTO snx_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Adu sam ne mendelxone pinaxa andug ana adu mundor hali dili mundoubxo. ");
INSERT INTO snx_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Sisne Yesus ido anyibi xo aubi kubex lesne deubxo. Andug habrexbe tinggring asine suma be soibane adun Jesus pes lema. ");
INSERT INTO snx_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Suma lambeiyai ana adu kwalisi njanjan asoubxo. Nedana andug ana adu mundoubxo, “Ino ama xo au kubex nyi xedelmbis leberxo. Habrexbe sixa.” ");
INSERT INTO snx_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Adun inarnjulxo, “Suma ye hajo ama xo au kubexo?” ");
INSERT INTO snx_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Sisne adu suma ye adu kwali soubx ne xoxnjisne munjurulxo, “Sa hajo ama kube xo aukube xone sixa wadi! ");
INSERT INTO snx_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Sumaxangglixja ye Xotei ido do ne sox sixane, ne hajo au kube, hajo mana kube, hajo ama kube.” ");
INSERT INTO snx_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesus bili aib Galili yag koro xoub suma xele hunjisilxo. Sumaxangglixja tumbangai adu xoul youbxo. Nenxa adu kubung bugbe pudoxasine njanasine yag koro bebeng udisne giringx minjelxo. Silane sumaxangglixja kumogx yag koro bebengbe nenxa soubx. ");
INSERT INTO snx_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Yesus adu mangau kumogx yaul sambe sam xele hunjisilxo. Sisne andug sis munjurulxo, ");
INSERT INTO snx_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Nyingga xiyaba! Suma be mosne yub wit ido wig taur lox. ");
INSERT INTO snx_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Adu wit ido wig taur silane dagi panjurungsi gamanbe kuloubane as ana lesne heoubx. ");
INSERT INTO snx_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Dagi miyang belib koljal, miyang duma karong usub barig kolsine miyanghanggu ne kol tang xujalxo, nenxa wox gasan youbxo. ");
INSERT INTO snx_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Nenxasi seng desne balag alane lilaalox, ne wit barig kol tang xujalxo. Nenxa wit xonggrongasi miyalxo. ");
INSERT INTO snx_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Wit wig dagi xaxare jingglang mbelembe kuloubx, ne andug wox sibane xaxare jingglang ana ngalagnjoubane andug iljal. ");
INSERT INTO snx_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Wit wig dagi miyanghanggu belib kuloubxo, ne andug wox beli sine wit beli gasa ayoubxo, dagi beli 30, dagi beli 60, dagi beli 100.” ");
INSERT INTO snx_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Sisne Yesus adu sis munjurulxo, “Suma ye adu dab dinggini dili ne adu xiyamin.” ");
INSERT INTO snx_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Adu idoi silane ido 12 sox suma xo sumaxangglixja andug Yesus jagar seoubxane andug ana Yesus yaul sam xasi inar youbxo. ");
INSERT INTO snx_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Adu sis munjurulxo, “Nyingga Xotei ido kingdom ido holox sam ne hanggixu. Nedine andug suma xoubx sixane sam kumogx ne yaul sam be inggam munjiri silxo. ");
INSERT INTO snx_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Nenxa, ‘andug xox saxabarxo, nedine andug pongnjaxaman, andug sam xe saxabarxo, nedine andug xele aiyaxabar, nedine andug indoi pari bul yaxabarx ne Xotei ana andug une xendei hunjudxo!’ ” ");
INSERT INTO snx_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Sisne Yesus andug sis munjurulxo, “Nyingga yaul sam wa pongnggijal e? Suxne nyingga koxrai na yaul sam kumogx ne pongnggedxo? ");
INSERT INTO snx_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Suma wit wig taurlox, ne sux suma Xotei ido sam beli publab disx na. ");
INSERT INTO snx_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Suma dagi andug wit wig gamanbe taurx ne pala. Nenxa suma andug sam xe gasan sixa, Satan ana lenane Xotei sam beli kweb maglib taurx ne xendei hunjudx. ");
INSERT INTO snx_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ne suma dagi andug wit wig so miyanghanggu duma usub taurnjulx ne pala. Andug sam xesne pe gasan disxa, sisne pari beli sixa. ");
INSERT INTO snx_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Nedine andug barig xujalxo, nenxa andug si tangyaxabar. Suma dagin Xotei sam nenxasi kulig hunjinane alualul njaxbarxo, ne indo udud tei pesxa ne ganjang kulodx. ");
INSERT INTO snx_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Suma dagi andug wit wig xaxare jingglang maglib nenxa taurx ne pala. Suma kulu ne andug sam xesxa. ");
INSERT INTO snx_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Nedine andug miyanghanggu wan ido pinhalel kumogx xasi ud lambei sixa. Andug indo jager udud dili sis andug moni pesne andug beli sax. Andug pinhalel lambeiyai dili ayax si, sisne andug miyanghanggu wanx ido pinhalel nenxasi pari proxounjisx. Andug mangau nedana Xotei ido sam kakabu yixanden andug iljalxa. ");
INSERT INTO snx_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Nedine suma dagi andug wit wig miyanghanggu belib kuliux ne pala, ne andug sam xesne pes bar sixane hepin babdisxa. Dagi beli 30, dagi beli 60, dagi beli 100.” ");
INSERT INTO snx_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Sisne Yesus ana andug sis munjurulxo, “Suma bena lam penane wob kabududx ko baxalu bogagub pidedx e? Jalxo. Adu lam penane baxalu usub pidedxo. ");
INSERT INTO snx_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Pinhalel kumogx holob sixane bunge palagdux babadox. Pinhalel kumogx ejex disxane bunge palagdux babadox. ");
INSERT INTO snx_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Suma ye dab dinggini dili andenane adu xiyamin.” ");
INSERT INTO snx_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yesus bili sis munjurulxo, “Sam nyingga xeberx ne nyingga udud beli si sax. Nyingga suma ye mangau xa yi hunjisxane kulu sux ne Xotei ana nyi xabe yinane bili usub toxeidox. ");
INSERT INTO snx_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Suma ye pinhalel dili ne Xotei adun pinhalel dagi toxeidox. Nedine suma pinhalel xujalxo, ne Xotei ana pinhalel dukangge baryiuxsix ne xendeidox.” ");
INSERT INTO snx_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesus adu bili sis mendelxo, “Xotei ido kingdom sux ned, suma bena pin wig taur yul miyanghanggub kulolxo. ");
INSERT INTO snx_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Kolu meleng adu wilasix xuduayiux ne pin wig idoi pongasi xoiyixo ne adu wox xaisix ne adu lol. ");
INSERT INTO snx_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Miyanghanggu idoi siyix xandene pin wox six, sisne mete alum pers sanying sine beli asix. ");
INSERT INTO snx_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Sisne wit ido beli xuradix xandenane korayax si ido nal kulub xandene adu korasix. Ne pin beli xuradixo.” ");
INSERT INTO snx_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ne bili Yesus sis munjurulxo, “Ga Xotei ido kingdom pinxa pala mendaxamun? Yaul sam xa mende munda ne totoidox ne nyingga pongnggedxo? ");
INSERT INTO snx_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Adu mastad ge ido wig pala. Adu ido ge ne nyaro nyaro ne nyi miyanghanggub besxama. ");
INSERT INTO snx_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Nedine suman be andenane, adu wox amainane alum ne pin kumogx yu maglib sixane yeyelunjina, bar xili xiliyaib nenxabe bugbe as lesne hamug ruxbe nenxabe jar per saxabarxo.” ");
INSERT INTO snx_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesus sumaxangglixja yaul sam be inggam munjri silxo. Indo udud xeleayax kere dinjisne sam munjri silxo. ");
INSERT INTO snx_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Adu yaul sam be sam ya, sumaxangglixja sam munjri silxo. Nedine Yesus ido sox suma jagar ya sibane adu sam kumogx ne bisalsi munjri silxo. ");
INSERT INTO snx_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Nal nenxa seng kambung alane Yesus ido sox suma sis munjurulxo, “Ga Galili yag koro xoub inggam minjax.” ");
INSERT INTO snx_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Sumaxangglixja tumbangai nenx udinjisne Yesus kubung maglib silane andug adu jagar kubungbe minjoubxo. Nenxabe kubung dagi jagar minjoubxo. ");
INSERT INTO snx_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Andug mo sabane tumur xiliyai dalxo. Sisne yuwal palom kubung maglib minjelxo. Ne yuwal palom ana kubung max dax koraalox. ");
INSERT INTO snx_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesus kubung kulub bebengbe nenx gadi gulong persine wilasilxo. Ido sox suma adu xududis mundoubx, “Inggreng Suma! Nyi ga xasi daxaman ne ga yag hes padal ayaxamun e?” ");
INSERT INTO snx_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesus xuduasine tumur hegagaisine yag palom mundulxo, “Tenenema! Maninasi sema!” Silane tumur mesne so pong dulxo. ");
INSERT INTO snx_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yesus adu ido sox suma munjurulxo, “Nyingga pinxa ula alul sixa? Nyingga xabu ud tei ajalxa e?” ");
INSERT INTO snx_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Andug ula hali yisne indoi indo sam sis mendoubxo, “Wa ye e? Nenxa tumur xo yuwal palomx adu sam xe huyisxa!” ");
INSERT INTO snx_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ne Yesus ido sox suma jagar Galili yag koro xoub inggamxa nenx Gerasenes indo miyanghanggub deoubxo. ");
INSERT INTO snx_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesus kubung udisne kulolane suma be mundor hali dili ne suma mexo hogsixa sob inggam gasanx les Yesus tordulxo. ");
INSERT INTO snx_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Suma ne adu mexo sumaxangglixja hogsixa sob nenxa wilasix. Nal ne suma ben adu xaxoi yax kerejal. Sen ana dide kerejal. ");
INSERT INTO snx_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Nal lambei andug adu ido barge hankap ana axoisine kwesang ain ana tindeng youbxo. Nedine adu hankap xo ain dide sux titoxour silxo. Adu bail hali. Suma ben adu tindeng yax kerejal. ");
INSERT INTO snx_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Meleng kere kolu meleng adu mex suma sob nenxa tombu gabra xalagbe nenxabe silxo. Adu xoengasine duma pes ne idoiya ido dodamug xanjaxanjang asilxo. ");
INSERT INTO snx_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Suma ne Yesus weyexya sam xoxsine adu baxeingasi mosne Yesus parib tomblong lox. ");
INSERT INTO snx_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Yesus adu sis mundulxo, “Mundor hali nyi suma wa udisne habrex da!” Silane adu sis maalox, “Yesus, Xotei Bugbex Tenemx Ido Ngidibi, nyi sa koxrabaxsi? Nyin Xotei donyambe sam sa alulbaxjal.” ");
INSERT INTO snx_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Sisne Yesus suma ne inarlox, “Nyi donyam ye?” Silane adun Yesus sis mundulxo, “Ga lambeiyai sixamun. Nenxa hajo donyam Xajax Suma Lambei.” ");
INSERT INTO snx_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Sisne adu Yesus xoengasi inar sebei silxo simane adu so nenxabe xendeinjaxjal. ");
INSERT INTO snx_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Nal nenxabe bol lexeingai gabra xalagbe nenxabe pin he soubxo. ");
INSERT INTO snx_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Silane mundor halina Yesus xoeng huyoubxo, “Nyi ga bol lexeingbe so ge. Sisne ga xarui gem bol maglib minjaxamun.” ");
INSERT INTO snx_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ne Yesus ana xaruinjulxo. Sibane mundor hali suma ne udisne bol maglib minjoubxo. Sibane bol lambei 2,000 suxne andug yag koro xou gabra xalag halib inggam nenx baxeing herrixasi kolsine yag hes moreng ayoubxo. ");
INSERT INTO snx_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Bol xumar suma andug babaxeingsine taunbe so kumogx taun xoubx dide mosne mangau dalxone munjroubxo. Sibane sumaxangglixja kumogx mosne mangau dalxone xox youbx. ");
INSERT INTO snx_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Andug Yesus sib lesne suma mundor hali lambei ana marai youbxo, ne njanasi lane xox youbxo. Hameg adu bugax tagsi udud pong lane adu njanasilxo. Ne sumaxangglixja xox sisne ula ayoubxo. ");
INSERT INTO snx_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Suma ye andug mangau ne xox youbxo andug ana sumaxangglixja munjroubxo. Ne suma be mundor halin marai la mangau dal nenxo bol moreng aiyoubx ne andug mendoubxo. ");
INSERT INTO snx_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Silane sumaxangglixjax indo miyang nenxa Yesus sam bail mundis xoengasine adu so ne udis minjaxasi inaryoubxo. ");
INSERT INTO snx_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesus adu kubung maglib minjax silane suma mundor halina alulox ne Yesus jagar minjax xoeng alox. ");
INSERT INTO snx_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yesus adu ongsi arwijal, nedine adu mundulxo, “Tubarbe ino aumbu sib minje, simane Aiyaman mangau kumogx nyi xabe yixone Xotei ido torom xo pari beli xo nyi xabe yixone munjrax.” ");
INSERT INTO snx_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Silane suma ne minjelxo. Adu mosne Dekapolis distrik indo sob nenxabe mangau xa Yesus ana adu xabe yulxone munjris xandelxo. Sumaxangglixja andug udud lambei pesoubxo. ");
INSERT INTO snx_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Sisne Yesus aib kubungbe sam yag koro inggamxa minjoubxo. Sumaxangglixja lambei Yesus sixbe yag koro xoub lesne xunggurasi kwali youbxo. ");
INSERT INTO snx_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Sisne Ju indo bojou ido gadi be adu lelxo. Ido donyam Jairus. Adu Yesus xoxsine lesne Yesus sib tomblong lox. ");
INSERT INTO snx_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Sisne adu Yesus xoengasi inarlox, “Hajo janx dukangge be miyax kora asixna! Aee, Yesus nyina adu barge usub pidemane adu beli ana kexei sidxo.” ");
INSERT INTO snx_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Silane Yesus adu jagar minjelxo. Sumaxangglixja lambeiyai indo indo dabijaxasi adu sox soubxo. ");
INSERT INTO snx_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Nenxabe xanggli be silxo ne adu 12 yar warum hwing silxo. ");
INSERT INTO snx_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Xanggli ne dokta lambei ana torom soubxo sisne adu moni kumogx gouralox. Nedine andug ana xurang xiliyai huyisne adu ido gemba huringen soubxo. ");
INSERT INTO snx_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Xanggli ne adu Yesus mangau xa persilxo ne sam xiyalxo. Ne adu ud siylox, “Sa adu ido kolos ya kundung dudane sa gemba beli dibedxo.” Nenxa adu loxsine Yesus gomborbe sumaxangglixja lambeiyai mbelem nenxa Yesus ido kolos ilong ne kundung dulxo. ");
INSERT INTO snx_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Gasanx ido ker desilxo ne deralox, sisne ido dodamug be gemba angi silxone hag dulxo. ");
INSERT INTO snx_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yesus xele gasanx dulxo ne bail dagi adu udisne minjelxo. Sisne Yesus adu xunggur maglib bulsi inaralox, “Yena sa kolosbe kundung dibixo?” ");
INSERT INTO snx_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Yesus ido sox suma adu sis mundoubxo, “Nyi xoxayax, sumaxangglixja lambeiyai ganggolmbisne da kundung asiberxo, ne inarnjax, ‘Yen sa kundung dibixo?’ ” ");
INSERT INTO snx_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Nedine Yesus nyam kwarengasine xedelasine suma yena mangau ne yixo. ");
INSERT INTO snx_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Siylane xanggli ne mangau xa adu xabe dalxone adu xelealox. Adu lesne Yesus ido kwesang kulub tomblongsine ula asine kakaralox. Sisne xabu xabu mangau xa adu xabe dalxone mende kiridulxo. ");
INSERT INTO snx_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ne adu xanggli ne mundulxo, “Janx, ino udud tei ned ana ino gemba pong dixo. Pari xosolox minjax. Nyi hameg belixama.” ");
INSERT INTO snx_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesus adu sam sis mundi silxane suma dagi Jairus urumbe sam leoubx. Jairus adu Ju indo bojou ido gadi silxo. Andug ana adu mundoubxo, “Ino jan mexo. Pinxax nyi sina Inggreng Suma kulig huyudxm, a?” ");
INSERT INTO snx_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Nedine Yesus adu sam mendoubxo ne gugaringnjulxo. Yesus Ju indo bojou ido gadi sis mundulxo, “Nyi ula ayaxjal, udud teiya sax.” ");
INSERT INTO snx_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yesus Pita, Jems xo ido aubi kanangge Jon indoi adu soxyax munjurulxo. Suma kumogx kornjulxo. ");
INSERT INTO snx_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Andug mosne Ju indo bojou ido gadi ido urumbe deoubxo. Yesus sumaxangglixja song haro xiliyai soubxo nenxabe xox njulxo. ");
INSERT INTO snx_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ne adu urum maglib mosne munjurulxo, “Nyingga pinxax song haro xiliyai yisxa? Xelag wa adu mejalx na. Adu wilayuxsix.” ");
INSERT INTO snx_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Nedine sumaxangglixja adu jaxale youbxo. Adu andug kumogx xendeinjulane habrexbe deubxo. Sisne adu xelag ido alabi xo anyibi xo suma dagi adu jagar xelag ne wil asilxo sib minjoubxo. ");
INSERT INTO snx_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ne Yesus bargebeb ya barsine mundulxo, “Talita koum!” Ne sam kulu sis mendelxo, “Dindongge kanangge, sa nyi sis mumbrixama, tinga!” ");
INSERT INTO snx_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Gasanx dindongge ne tingasine xensi kwalilox (pinax xa adu yar 12 dili). Gasanx andug pudox hali asine pari tunggulnjulxo. ");
INSERT INTO snx_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesus koko sam bail munjrulxo mangau dexone suma dagi munjraxjal. Sisne Yesus dindongge kanangge ne pin naiyax andug munjrulxo. ");
INSERT INTO snx_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesus adu so ne udisne adu ido tubar kulu Nasaret taunbe minjelxo. Sisne ido sox suma andug adu soxsine minjoubxo. ");
INSERT INTO snx_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sabat nal dalane adu Ju indo bojou maglib sam publab dis munjrisilxo. Sumaxangglixja lambei adu sam xe sisne andug pudox hali asine sis mendoubxo, “Suma wa sam wa xabe be pexo? Xele ne adu xabe six ne xele xa? Koxrayiux nenxa adu likong yisx na? ");
INSERT INTO snx_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ga xele, suma wa adu wam ana pinhalel kora tambi. Adu Maria ido ngidibi, ne ido aubi kanangge Jems, Josep, Judas, ne Saimon. Ido naibi kube wanx ga jagar sixamun.” Andug adu xasi pari iro pe soubxo. ");
INSERT INTO snx_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesus andug sis munjrulxo, “Propet adu xoub donyam dili. Nedine ido tubar kulu xo ido malanggu xo ido urumx adu asreisi gugaring sixa.” ");
INSERT INTO snx_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Adu likong be nenxabe babdaxaman. Gemba sumaxanggixjax kujekujexya nenxabe adun barnjulane andug beli ayoubxo. ");
INSERT INTO snx_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Sumaxangglixja andug Yesus xasi udud tei pejalx, nenxasi adu andug xasi pudox hali alox. Sisne Yesus tubar keredis xensi mosne Xotei ido sam ne xele hunjisilxo. ");
INSERT INTO snx_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yesus adu ido sox suma manjulane adu sib lebane andug mundor hali xendeiyax bail hunjisne lililx sonjulane andug minjoubxo. ");
INSERT INTO snx_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Wa ido manam sam munjrulxo, “Nyingga pinhalel be pepex jagar minjaxjal. Ne bred, kegle, moni, siot soux be paxjal. Nedine inggo dumbun xo sendelx neiya pepex minjax. ");
INSERT INTO snx_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Nyingga urum beb mos nenx sax. Bunge nyingga taun udis minjaxasi urum ne hagdax. ");
INSERT INTO snx_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ne tubar be nyingga gagrenggijalx ko nyingga sam xe hanggijal xandene, nyingga tubar ne udaxasine inggo kwesangbe tumbrum ne, nenxabe taursine minjax. Siybane indo ugel palag dux babadox.” ");
INSERT INTO snx_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Andug mos sumaxangglixjax bulsi Xotei sib minjaxasi sam publab dis munjri soubxo. ");
INSERT INTO snx_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Sisne andug mundor hali lambei xendei hunjisne suma gembaxone goreng agub per hunjixanden andug gemba pong dinjisilxo. ");
INSERT INTO snx_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Yesus ido donyam suma xele ayoubxo sisne King Herot adu mangau xa dalxo nenx ido sam ne xiyalxo. Suma dagi andug sis mendoubxo, “Adu Jon Baptais ne aib tingayux. Nenxa adu likong bail adu xabe six na nenxa adu kinggal bail desx na.” ");
INSERT INTO snx_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Nedine suma dagi andug sis mendesxa, “Adu Elaija.” Dagi mendesxa, “Adu propet nomi morengx ned.” ");
INSERT INTO snx_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Nedine Herot adu ne xesne mendelxo, “Adu Jon suma ye san adu xoxli toxour dudane miyalxo ne tingayux.” ");
INSERT INTO snx_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Herot aubi kanangge Pilip ido ngobi Herodias pes ido ngobi alox. Nenxa Jon ana King Herot mundulxo, “Nyi ino au ido ngobi ne pemenx ne nyi ugelmonxo.” Nenxasi Herot adu suma garingnjulane andug Jon tindengsine xaxoisi talu halib pidoubxo. ");
INSERT INTO snx_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","Herot adu xele Jon adu suma tenenemx ne kanin suma, nenxa adu Jon xasi ulaasine xumarsilxo. Herot adu Jon ido sam xiyaxasine adu udud lambei palxo. Siylane adu Jon ido sam xiyax udud tingasilxo. Nedine Pilip ido ngobi Herodias adu Jon xasi iro xiliyai pesne Jon taxas medaxsi, nedine adu siyax kerejal. ");
INSERT INTO snx_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Bunge Herodias adu nal beli xoxlox, ne King Herot adu hesam xiliyai ido anyibin palxo nal nenxabe babdulxo. Hesam nenxa Galili distrik ido gavman gadi naman naman xo xuber suma indo gadi naman xo Galili distrik indo gadi namanx andug hesam nenxabe soubx. ");
INSERT INTO snx_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodias ido asibi maglib lesne kwanyinglox. Herot xo gadi naman naman Herodias ido asibi xasi pari belinjulxo. Herot dindongge ne mundulxo, “Sa inarbemane pinxa nyi mendedxm, ne sa hambedxm.” ");
INSERT INTO snx_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Silane adu ido sam bail disne mendelxo, “Pinxa toto nyi sa inarbedxm ne sa nyi pinhalel kumogx hajo kingdom xabe sixne kwadebx nyi hambedxm.” ");
INSERT INTO snx_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Herodias ido asibi mosne ido anyibi inarlox, “Sa pinxa xasi inar da?” Anyibi sis mundulxo, “Jon Baptais ido gadi.” ");
INSERT INTO snx_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Silane Herodias asibi gasanx aib king sib mosne mundulxo, “Sa hamehamegya Jon Baptais nenx ido gadi tuberbeb persi habe!” ");
INSERT INTO snx_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ne king adu sam ne xesne adu pari xurang xiliyai palxo. Nedine gadi naman naman lesne hesam maglib soubx ne ido sam bail dulxo nenxasi adu ido asibi sam xendeiyax kerejal. ");
INSERT INTO snx_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Sisne king ana ido xajax gadi suma gasanx soilane mosne Jon ido gadi pes lax mundulxo. Jon talu halib silane adu mosne Jon ido xoxli toxour disne, ");
INSERT INTO snx_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","gadi tuber hogsi pes lelxo. Siylane adu dindongge ne huyulane, adun pesne ido anyibi huyulxo. ");
INSERT INTO snx_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Jon ido sox suma xe sis lesne Jon ido gubol pes mosne sub duma dinggini korax nenxabe pidoubxo. ");
INSERT INTO snx_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yesus ido sox suma andug aib lesne xulyoubxo. Sisne andug kinggal xa xo xelesamx hunjisoubxo ne Yesus mundoubxo. ");
INSERT INTO snx_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nenxabe sumaxangglixja lambei mo le asoubxo ne nal nenxabe adu ido sox suma jagar pin heax kerejal. Silane adu andug munjrulxo, “Aria, nyingga inggoiya sa jagar mos so der beb xarpideba.” ");
INSERT INTO snx_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Sisne andug indoiya kubungbe sam so derbe minjoubxo. ");
INSERT INTO snx_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Nedine suma lambei andug so ne mo soubxo ne xoxnjoubxo, ne andug kwesang ana babaxeingsi taun kumog keredis sam minjax so ne nomiasi minjoubxo. ");
INSERT INTO snx_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesus adu kubung yag koro xoub desne xoxlox ne sumaxangglixja lambeiyai soubxo. Adu xoxnjulxone sisne andug sipsip xumar suma xujalx ne pala, nenxa adu andug xasi pari xuranglox. Sisne adu kuluisi pinhalel lambei xasi xele sam hunjisilxo. ");
INSERT INTO snx_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Seng kulolane Yesus ido sox suma adu sib lesne mundoubxo, “Ga so der be sixamun ne seng kulax korax na. ");
INSERT INTO snx_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Nyi sumaxangglixja sonjuma tubar dagi kuluba urum keredis nenxabe monane indo indoiya pin hwaabira.” ");
INSERT INTO snx_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Nedine adu andug sam ongnjis munjrulxo, “Nyinggan andug pin hunjax.” Silane andug adu mundoubxo, “Xehei, sumaxangglixja lambeiyai sixa! Sisne 200 moni silba bred hoaasine hunjax kerejal!” ");
INSERT INTO snx_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Silane adu andug inarnjulxo, “Nyingga bred gelunggun six na? Nyingga mosne xoxba.” Andug xoxsine adu mundoubxo, “Bred 5 xo xumam lilxo.” ");
INSERT INTO snx_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Sisne Yesus sumaxangglixja kumogx xunggur dide dide njisne xaxare kexeibe njanjanyax munjrulxo. ");
INSERT INTO snx_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Silane andug xunggur dagi 100, dagi 50, sisne andug njanjan ayoubxo. ");
INSERT INTO snx_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Sisne Yesus bred 5 xo xumam lilxo pesne lang bugbe xoxsine Xotei kai huyisne bred ne gogobuisi ido sox suma hunjulane andug ana dodoisine sumaxangglixja hunjoubxo. Adun xumam lilxo dide gogobuisi sumaxangglixja kumogx pilagnjis hunjulxo. ");
INSERT INTO snx_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Sumaxangglixja kumogx andug hesne kere ayoubxo. ");
INSERT INTO snx_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ne pin hedu kumogx silane sox sumana gereisine pin kegle 12 hogax suxne silxo. ");
INSERT INTO snx_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Suma nenxabe pin heoubx ne 5,000. ");
INSERT INTO snx_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Nal nenxya gasan dis Yesus ido sox suma kubung maglib mosne nomiasi Betsaida taunbe yag inggamx ne minjax munjrulxo. Sis idoi sax nenxasi adu xunggur xendeinjulxo. ");
INSERT INTO snx_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Adu sumaxangglixja sonjisne adu geinayaxasi tombu xolxo. ");
INSERT INTO snx_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Bula alane kubung yag koro mbelembe nenx silxo. Ne Yesus idoiya aib nenx silxo. ");
INSERT INTO snx_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Yesus xoxnjulx ne tumur ana kubung bijailane ido sox suma kubung pes yag inggamxa minjax hanggar soubxo. Sisne kogli hali Yesus yag usub xensi andug sib mo silxo. Adu andug yelunjax silane ");
INSERT INTO snx_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ido sox suma adu yag usub sam xen silane xoxyoubxo. Ne andug xox sisne adu mundor halio si youbxo. Andug ula ulaisine haroiyoubxo. ");
INSERT INTO snx_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Andug kumogx adu xoxsine ula haliyoubxo. Nedine gasanx adu andug munjrulxo, “Nyingga teiya sax. Wa sa. Nyingga ula ayaxjal.” ");
INSERT INTO snx_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Sisne adu kubung alumasi andug jagar silxo, ne tumur ayoxasi so pong dulxo. Andug pudox hali aiyoubxo. ");
INSERT INTO snx_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Andug pari hog silxo. Nenxa andug sumaxangglixja bred dodoisi hunjisilxo ido kulu ne andug udud pongnjijal. ");
INSERT INTO snx_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Yesus ido sox suma jagar kubung pesne yag inggamx Genesaret so nenx desne kubung sel nding youbxo. ");
INSERT INTO snx_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ne andug kubung udisne habrexbe deubane, sumaxangglixja Yesus pala xoxsine gasanx pongnjulxo. ");
INSERT INTO snx_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Andug paripariasi so kumogx keredisne sumaxangglixjax gemba gembaxo ne baxalub persoubxo. Persine Yesus xabex silxone minjoubxo. ");
INSERT INTO snx_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Sis so xa adu silxone andug gemba sumaxangglixja gagrenjisne mo soubxo. Yesus tubar maglib ko taunbe ko taun habrexbe ne andug gemba sumaxangglixja so hobox be gagrenji soubxo. Andug ana adu gwarisi inar soubxo sis andug adu bugax aju ne kundung dixandenane indo gemba ayox asilxo. ");
INSERT INTO snx_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Parisi xo manam sam ido xele suma dagi andug Jerusalem udisne Yesus sib leoubxo. ");
INSERT INTO snx_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Andug Yesus ido sox suma dagi xoxnjoubxo ne andug barge soxor dili pin hesoubxo. ");
INSERT INTO snx_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Parisi xo Ju kumogx andug indo amsax mangau ne soxsi bar yang uradisne andug pin hesxa. ");
INSERT INTO snx_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Sisne Parisi meleng kere maketbe mon lenane andug bar yang uradis bunge andug pin hesxa. Andug indo amsax mangau dagi ne soxsine gamba xo wob xo tuber xo baxalux yang asixa.) ");
INSERT INTO snx_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Parisi xo manam sam ido xele suma dagi andug Yesus inar youbxo, “Pinax ino sox suma ne andug ga hago amsax indo mangau ne soxjal xa? Andug pin heax bar yang ajalxa.” ");
INSERT INTO snx_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Silane adun munjrulxo, “Propet Aisaia adu heniy sam nyingga xasi toto mendelxo. Nyingga jager suma sixa. Adu inggreng siylox, ‘Suma wa hajo donyam indo mob ana ya soxor sixa. Nedine andug indo xabu pari xalam sa xabe sijalxna. ");
INSERT INTO snx_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Andug sa xalong bisxane xabujal. Andug suma dagi udud soxsine suma xele hunjisxa.’ ");
INSERT INTO snx_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Nyingga Xotei ido manam sam soxjalxane nyingga amsax indo udud dagi manam sox sixa.” ");
INSERT INTO snx_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Sisne adu andug sis munjrulxo, “Nyingga Xotei sam asreisine inggo amsax mangau soxsi sax ne xele tangxo. ");
INSERT INTO snx_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses sis mendelxo, ‘Ino ala xo amax xasi haliy ayax,’ ne ‘Suma ye adu ala ko ama ko nyamang hunjudxo, ne adu miyadxo.’ ");
INSERT INTO snx_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Nedine suma be adu ido alabi xo anyibix munjrudxo, ‘Sa nyisxa toromgaxaman. Pinax nyisxa toromgax ne sa Xotei huyax mara xuradomonxo.’ ");
INSERT INTO snx_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Nenxa nyingga Parisi inggo mangau ne sux suma be ne adu alabi xo anyibix pinhalel be toromnjaxaman. ");
INSERT INTO snx_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Sisne nyingga inggo amsax indo mangau ne tidor si sox sixane nyingga Xotei sam gugaring sixa. Ne nyingga mangau ne mangau dagi sis yisxa.” Yesus adun sis munjrulxo. ");
INSERT INTO snx_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesus bili sumaxangglixja manjis lex mulabane munjrulxo, “Nyingga kumogx sa sam xesne pongnggemin. ");
INSERT INTO snx_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Pinhalel kumogx habrexbe sam suma maglib kolsine suma soxor huyijal. Nedine pinhalel kumogx suma maglib sam desx ne Xotei nyambe suma soxor huyisx.” ");
INSERT INTO snx_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Bunge Yesus sumaxangglixja xunggur ne udnjisne urum maglib minjelane ido sox suma andug yaulsam xa mendelxo nenxasi adu inaryoubxo. ");
INSERT INTO snx_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yesus andug sis munjrulxo, “Nyingga yaulsam ne pongnggijal e? Pinxa nyingga hesxa nedana nyingga soxor hanggax kerejal. ");
INSERT INTO snx_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Pinxa ne adu kweb maglib kolsix ne adu biasi desx. Ne adu ino pari maglib koljal.” (Yesus adu nenx mende siylox, ne hepin kumogx ne soxor xujalxo.) ");
INSERT INTO snx_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Sisne Yesus aib bili mendelxo, “Ne pin suma maglib sam desx ne Xotei nyambe suma soxor hunjisxna. ");
INSERT INTO snx_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Pinxa suma maglib sam desxne soxor huyisne sux, udud hali, huyeman manggau, yuwem, suma taxa, ");
INSERT INTO snx_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","suma be ngobi yei yixam, hali tambi, mangau hali kumogx, jager mangau yisxa, huyeman udud, waxar mangau, gomborbe sam, da dangga, xo nanar mangau. ");
INSERT INTO snx_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Mangau hali kumogxo ne suma maglib sam desx ne Xotei nyambe suma soxor hunjisx.” Yesus adun sis munjrulxo. ");
INSERT INTO snx_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Sisne Yesus adu tingasi so ne udisne mo siti Tair indo sob desne adu urum magli beb minjelxo. Adu nenx simane suma ben adu xeleayaxjal. Nedine adu dide nenxabe holopax kerejal. ");
INSERT INTO snx_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Adu nenxabe silane xanggli be asibi dukangge, ye adu mundor hali dili ne adu xe sisne gasan lesne Yesus kwesang kulub tomblonglox. ");
INSERT INTO snx_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Adu Girik xanggli. Siria kantri xo Ponisia sob maglib nenx nyam pidelxo. Adu Yesus mundor hali ido asibi maglib xendeiyax xasi gwarisi inar silxo. ");
INSERT INTO snx_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yesus adu sis mundulxo, “Ga mete xelag pin nanjax. Sin ga xelag indo pin ne xasui munda sang ana hedxo ne beli jal.” ");
INSERT INTO snx_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Xanggli adu Yesus ongsine mundulxo, “Aiyama, ne xabu, nedine sang andug baxalu bogagub sixa, ne andug dide xelag indo pinhedu ne heaxbarxo.” ");
INSERT INTO snx_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Silane Yesus adu mundulxo, “Ino sam beli mendemenxo nenxa nyi aib minje. Mundor hali ino janx hagdix uradix.” ");
INSERT INTO snx_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Adu aib ido urumbe minjelxo. Mosne ido asibi xoxlox ne adu baxalub wilasilxo. Ne mundor hali adu hagdulxo. ");
INSERT INTO snx_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesus taun Tair so udisne adu mos taun Saidon si desne adu xensi mos Dekapolis Galili yag koro xoub nenx dalxo. ");
INSERT INTO snx_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Silane suma ne adu dabxajox xo men padinggelxo ne adu sib pe lesne Yesus adun barge usub pidaxasi gwari inar youbxo. ");
INSERT INTO snx_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesus adu suma ne unggur xoub pes mosne barbug adu dabdingginib pidelxo. Sisne adu barbug mesel si suma ne men kundung dulxo. ");
INSERT INTO snx_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Yesus mundor bail pesne tarx lang bugbe xoxasine adu suma ne mundulxo, “Epata,” ne ido kulu sux, “Hobox aba!” ");
INSERT INTO snx_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Silane gasan suma ne adu dabdu pong huyisne pin be adu men padinggel udisilxo. Ne xujalx asine adu sam beli mende silxo. ");
INSERT INTO snx_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Silane Yesus adu mangau xa yisilxo ne adu andug kokonjisne suma be mundax kornjulxo. Yesus aib kokonjis sesebeinjulxo. Nedine andug dide sumaxangglixja munjri sebeinjisilxo. ");
INSERT INTO snx_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Andug sam ne xesne pudox hali asine mendoubxo, “Mangau kumogx adu yisxane beli. Adun siyixandene andug dabxajox ne sam xesxa, mob kandungx ne hobox xasi sam beli mendesxa.” ");
INSERT INTO snx_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Nal ne maglib sumaxangglixja lambeiyai des aib mul ayoubxo. Sisne andug heax pinbe xujalalox, ne Yesus ido sox suma manjis munjurulxo, ");
INSERT INTO snx_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Sa sumaxangglixja wanx xasi pari xurangbix. Andug sa jagar nal xalubi seberxo nedine andug heax pin xujalxo. ");
INSERT INTO snx_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ne andug mamx sixa ne sa andug aib sonjud indo urumbe minjaxabarxo. Ne dagi indo tubar weyexya, sina andug gaman nyam uringnjum ganjang kulaxabarxo.” ");
INSERT INTO snx_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Adu ido sox suma aib Yesus mundoubxo, “Ga so rauxbe sixamun nenxa bred xabex pen sumaxangglixja nanjaxamun?” ");
INSERT INTO snx_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Adu andug inarnjulxo, “Bred gonggulu gelunggun nyingga dili sixa?” Silane andug Yesus mundoubxo, “7 six.” ");
INSERT INTO snx_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Adu sumaxangglixja miyanghanggub njanjanyax munjurulxo. Sisne adu bred 7 gonggulu pesne Xotei kai huyulxo. Adu bred gogobuisine ido sox suma hunjulxo. Silane andug pesne sumaxangglixja njanjan soubxo dodoi hunjoubxo. ");
INSERT INTO snx_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Adu xumam dudu lilxo dili ne dide pesne Xotei kai huyulxo. Sisne ido sox suma hunjisne dodoiyax munjurulxo. ");
INSERT INTO snx_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Silane sumaxangglixja pin ne hesne kwebnjulxo. Bunge ido sox suman pin heduhedu ne gereisine kegle 7 hogax suxne silxo. ");
INSERT INTO snx_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Sumaxangglixja kumogx nenx deubx ne 4,000. Silane Yesus aib andug sonjulxo. ");
INSERT INTO snx_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Adu ido sox suma jagar kubung maglib pudoxasi woxsine Dalmanuta distrik so ne minjoubxo. ");
INSERT INTO snx_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Parisi lesne Yesus helahelang youbxo. Andug adu toum yis lang bugbe siga be yax inar youbxo. ");
INSERT INTO snx_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Silane Yesus ido udud maglib pari kulig xiliyai yulane munjrulxo, “Pinxa andug sumaxangglixja nal wanxya ido siga usernjax bail haliaborxo? Sa xabu toto nyingga munggrixam, andug siga be xoxyaxabar. Jalxo toto.” ");
INSERT INTO snx_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Sisne adu andug udinjisne aib pudoxasi kubung bugbe woxsine yag koro inggam minjoubxo. ");
INSERT INTO snx_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yesus ido sox suma bred dagi peslax lol dunjulx. Andug kubung maglib nenxabe bred gonggulu kujexya dili. ");
INSERT INTO snx_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesus andug xele sam hunjisne sis mendelxo, “Xoxyax! Nyingga Parisi xo Herod indo yis nenxa xox gereiyax!” ");
INSERT INTO snx_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Andug sox suma indoi indo sam ne bred xujalxo nenx ulengsi mendoubxo. ");
INSERT INTO snx_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesus adu andug sam xa mendesoubx ne adu xele ne adu inarnjulxo, “Pinax nyingga sis mendesx ga bred xujalxo? Nyingga ponggijalx e? Nyingga pari hobox xajalx e? ");
INSERT INTO snx_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nyingga nyamge dili nedine nyingga xoxjalx e? Nyingga dabdinggini dili nedine nyingga xejalx e? Ne nyingga lol dinggix e? ");
INSERT INTO snx_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Sa bred 5 pesne gobudis 5,000 suma hunjumxne nyingga kegle gelunggun bred heduhedu peoubxo e?” Andug mendoubx, “12.” ");
INSERT INTO snx_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yesus mendelxo, “Sisne bred 7 sa 4,000 sumaxangglixja asine gogobui yudane kegle gelunggun peoubxo e?” Ne andug sis mendoubxo, “7.” ");
INSERT INTO snx_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Yesus andug sis munjurulxo, “Nyingga ponggijalx e?” ");
INSERT INTO snx_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesus ido sox suma jagar Betsaida tubarbe minjoubx. Silane sumaxangglixja dagi suma be nyam burx adu sib pes lesne adu nyam burx ne kundung dax gwarisi inar soubxo. ");
INSERT INTO snx_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Silane Yesus nyam burx ne bar huyis tubar xoub pes minjelxo. Adu suma ne nyamgeb meselsine bargen kundung dis inarlox, “Nyi pinhalel be xox yixam e?” ");
INSERT INTO snx_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Nyam burx ne tirarasi ne so xoxsi mendelxo, “Sa sumaxangglixja xoxnjixam, nedine andug wam pala ola sixa.” ");
INSERT INTO snx_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Silane Yesus aib ido barge suma ne nyamgeb pidelane nyamge hoboxasine jaxal alane pinhalel kumogx xox belilox. ");
INSERT INTO snx_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Silane Yesus adu urumbe soi si mundulxo, “Nyi tubar maglib minjaxjal.” ");
INSERT INTO snx_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesus ido sox suma jagar tubar dagi Sisaria Pilipai taun kulub nenx mo soubxo. Andug xensi wox sibane Yesus andug inarnjulxo, “Sumaxangglixja andug sa xasi ye toto e?” ");
INSERT INTO snx_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ne andug adu sis mundoubxo, “Dagi mendesxa nyi Jon Baptais, dagi mendesxa nyi Elaija, sisne dagi nyi xasi mendesxa nyi propet be nomi silxo.” ");
INSERT INTO snx_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Silane adu andug inarnjulxo, “Ne nyingga sa xasi ye toto e?” Pita mendelxo, “Nyi Kristus.” ");
INSERT INTO snx_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Nedine Yesus kokonjis munjurulxo, “Nenxa nyingga sa xasi suma be mundaxjal.” ");
INSERT INTO snx_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Sisne Yesus ido sox suma sis galinjulxo, “Suma ido Ngidibi xurang xo kulig lambei pamin. Adu Ju indo gadi xo lola urum gadi naman xo manam sam ido xele suma andug ana ais yaxabarxo. Adu taxaleb miyadxo. Nal xalubi udin adu aib mesob inggam tingadox.” ");
INSERT INTO snx_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Adu sam ne pong toto ido sox suma munjurulxo. Silane Pita adu pes xoub mosne kuluisi nyamang huyulxo. ");
INSERT INTO snx_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Silane Yesus bulsi ido sox suma xoxnjisne Pita nyamang huyis mendelxo, “Satan, nyi sa gomborbe minje! Nyi Xotei ido udud pejalxam. Nedine nyi suma ido udud pesxam.” ");
INSERT INTO snx_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Sisne Yesus sumaxangglixja xo ido sox suma manjulane adu sib leubane munjurulxo, “Sumaxangglixja ye adu sa soxbax sine haliy asine kulig kumogx kubaisine sa soxbax. ");
INSERT INTO snx_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Sisne suma ye adu idoi ido xunun xumar sidxone adu ido xunun ne yuwamadox, nedine suma ye adu sa xo Xotei ido sam beli xasi xunun ududx ne adu ido xunun adu si ilongadox. ");
INSERT INTO snx_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ne suma be adu miyang wanxabe pinhalel kumogx pena sidxone adu ido xunun ne yuwamadox, pinxa beli adu xabe nenx dadxo e? ");
INSERT INTO snx_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ne suma be adu pinxana ido xunun hwa ana aib padxo? ");
INSERT INTO snx_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Hamegxa nal wa sumaxangglixja dagi Xotei gombor huyis ne mangau hali dide didei yisxa. Nenxasi sumaxangglixja ye sa xo hajo sam xasi domeisixne Suma ido Ngidibi adu ido Alabi uring xiliyaib sinane Xotei ido kanin sombu jagar yogolodox ne adu dide andug xasi domeidox.” ");
INSERT INTO snx_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Silane Yesus andug sis munjurulxo, “Sa nyingga xabu munggredxm, sumaxangglixja dagi maglib wanxabe sixane andug mejal sibane Xotei ido kingdom bail dili damane andug xoxyaxabarxo.” ");
INSERT INTO snx_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Bunge nal 6 udisne Yesus, Pita, Jems, Jonx gagrenjis gabra bugbex woxsine andug ya nenx soubxo. Silane nenxabe Yesus ido dodamug bulsine xox kulube ala andug xox youbxo. ");
INSERT INTO snx_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ido bugax pinhalel ne bulsi xapoisine andosom giligilingsine nyam helxo. Miyang wanxabe suma ben bugax sux yang ama apoiyax kerejal. ");
INSERT INTO snx_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Elaija xo Moses nenx desne Yesus jagar sam asoubane sox sumana andug xoxnjoubxo. ");
INSERT INTO snx_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pita adu Yesus mundulxo, “Inggreng Suma, ga wanxabe sixamun ne beli, nenxa ga sox suma gesu xalubi huyaxmun, be ino gesu, be Moses ido, be Elaija ido.” ");
INSERT INTO snx_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Sox suma andug ula xiliyai youbx nenxa Pita adu sam xa mendedox ne adu lol. ");
INSERT INTO snx_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Silane arom be lesne andug hamugnjulane xarom maglib inggam sam be dalxo, “Wa hajo du. Sa adu xasine paribeli xiliyai six. Nyingga adu sam xe huyisax!” ");
INSERT INTO snx_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ne gasanx sox suma andug xoxayoubxo ne suma dagi xoxnjijal. Yesus idoi ya andug jagar silxo. ");
INSERT INTO snx_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Andug gabra udis yogol sabane Yesus adu ido sox suma sis kokonjulane andug mangau xa xoxborxo ne suma be mundaxjal, si sibane mox Suma ido Ngidibi men aib xuduadox. ");
INSERT INTO snx_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Silane andug indo indo sam ne petangsine andug sam kulu “men aib uduadox” nenxa uleng soubxo. ");
INSERT INTO snx_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ne andug Yesus sis inar youbx, “Pinax andug manam sam ido xele suman Elaija nomiasi yogolax mendoubxo?” ");
INSERT INTO snx_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesus aib sis munjurulxo, “Elaija adu nomiasi lemane pinhalel kumogx gereidox. Nedine kulu xax sam wa Suma ido Ngidibi xurang xiliyai pena sidxone andug adu xasi ironjumane gombor huyaxabarxo ne inggreng xabe sis mendexo? ");
INSERT INTO snx_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Nedine sa nyingga sis munggrixam, Elaija adu le xuradixo, ne suma indo udud soxsine mangau didedide kumogx adu xabe yiseberxone, ne Xotei ido sam adu xasi inggrengxone six.” ");
INSERT INTO snx_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yesus adu sox suma xalubi jagar lex sox suma dagi xoxnjoubx ne andug sumaxangglixja tumbangai maglib nenx kwalinji soubxo. Sisne manam sam ido xele suma jagar sam datera asoubxo. ");
INSERT INTO snx_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Andug Yesus xox sisne udud brungungasi gasan baxeingasi adu sib mosne pari beli sam mundoubxo. ");
INSERT INTO snx_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesus andug sis inarnjulxo, “Nyingga andug jagar sam xa xasi datera asix a?” ");
INSERT INTO snx_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Suma be xunggur mbelembe silxone aib Yesus mundulxo, “Inggreng Suma, sa hajo du mundor halin mob kandung dinane sa nyi sib pe lexama. ");
INSERT INTO snx_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ido nal dadxo ne adu mundor hali nedana adu petang six. Ne adu miyanghanggub hwi dixandene adu kol paux asine dodamug dangga asix. Adu xalag kulu henane hulex mobdingginib sam desxna. Sa ino sox suma mundor hali xendeiyax inarnjumonxo ne andug kerejal.” ");
INSERT INTO snx_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesus adu sis mendelxo, “Nyingga sumaxangglixja, nyingga xabu udud tei xujalxo. Nal gelunggun sa nyingga jagar semenxo? Nal gelunggun sa nyingga inggo kulig kubai semenxo? Suma xelag ne sa sib pes leb.” ");
INSERT INTO snx_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Silane andug adu sib pe lebane mundor hali ne Yesus xoxsisne adu xelag ne gasan kakarasine kol miyanghanggub pauxasine mobdingginib sam hulex desne adu miyanghanggub ginggongalox. ");
INSERT INTO snx_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesus xelag ne ido alabi inarlox, “Nal gelunggun adu si silxo?” Silane adu mendelxo, “Xelag halib inggam sam lesne hamegx. ");
INSERT INTO snx_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Nal lambeb mundor hali nedana adu medax xasi ne balax xo yag korob hwidisilxo. Nenxa nyi mangau be yax kere xandene ga xasi pari xurangmbi xandene ga toromgem?” ");
INSERT INTO snx_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesus adu mendelxo, “Pinax nyi sis mendexam, ‘Nyin ne yax kere e?’ Ye adu sa xasi xabu ud tei dili ne pinhalel kumogx yax kere.” ");
INSERT INTO snx_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Silane xelag ne ido alabi gasan xoeng asine mendelxo, “Sa xabu ud tei dili, nedine sa hajoya xabu ud tei ne nyina toromane xiliyai yax!” ");
INSERT INTO snx_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesus adu sumaxangglixja unggur xoxnjulxone andug nenxabe babaxeingsi lesoubxo. Silane adu mundor hali ne korsi mundulxo, “Nyi mundor hali mob kandung xo dabxajox, sa nyi kokombixam nyi xelag wa hagdis aib adu maglib minjaxjal.” ");
INSERT INTO snx_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Silane mundor hali ne ngirengsine adu xelag ne bijai tangsi hagdis minjelxo. Silane xelag ne andosom me palai lox. Silane andug dagi mendoubx, “Adu mexo.” ");
INSERT INTO snx_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Nedine Yesus adu bar koib pesne soxorlane adu tingalox. ");
INSERT INTO snx_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Nal nenxabe Yesus urum maglib minjelane sox suma andug adu yobu inar youbxo, “Kulu xax ga mundor hali ne xendeiyax kerejal?” ");
INSERT INTO snx_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Adu munjrulxo, “Gein be sam ya mundor hali sux ne xendeidxm.” ");
INSERT INTO snx_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Silane Yesus xo ido sox sumax tubar ne udisne Galili distrik maglib minjoubxo. Yesus ido sox suma manam sam munjraxasi, nenxa adu nenxabe sidxune suma ben adu xele aiyaxjal. Adu munjurulxo, “Suma ido Ngidibi suma dagin sosolox bargeb pidebane adu taxan medaxabarxo. Adu me xuradin nal xalubi udinane aib uduadox.” ");
INSERT INTO snx_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Nedine adu ido sam kulu ne andug pongnjijal, sisne andug adu inaryax ula aiyoubx. ");
INSERT INTO snx_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Yesus ido sox suma jagar mos tubar Kapenam si deoubx. Adu urum maglib nenx sisne adu inarnjulx, “Pinax toto nyingga gamanbe inggo inggo sam uleng seberxo?” ");
INSERT INTO snx_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Nedine andug gamanbe suma ye xiliyai toto nenxasi andug indo indo uleng soubxo, nenxa andug tenenemasi sam be mende xujalxo. ");
INSERT INTO snx_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesus njanasine ido 12 sox suma manjisne munjurulxo, “Suma ye adu nomi aiyax asine adu mete haliy asine kumogx indo kinggal suma sax.” ");
INSERT INTO snx_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Adu xelag dukangge be pesne andug mbelembe tingdis pes lumsine andug munjurulxo, ");
INSERT INTO snx_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Suma ye adu sa xasi udasine xelag dukangge sux wa toromdox, ne adu sa torombisxna. Ne ye adu sa torombisne adu sa neiya torombijalx, adu dide ye sa sobin yoglomonx ne torom yix.” ");
INSERT INTO snx_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jon Yesus sis mundulxo, “Inggreng Suma! Ga suma be mundor hali ino donyam be sam xendei yulx ne ga xoxmunx. Nedine adu ga jagar kandongajal, nenxa ga adu kormunxo.” ");
INSERT INTO snx_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesus mendelxo, “Adu koryaxjal. Suma ye adu sa donyam besam likong yisidxone adu serx sa xasi sam hali mubraxman. ");
INSERT INTO snx_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ne suma ye ga talagijalx ne hago dubli. ");
INSERT INTO snx_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Sa xabu toto munggrixam, nyi Kristus ido suma sixanden, ne suma ye adu nyi gamba yag sa donyam besam hambixanden, ne adu ido hwapin padxo.” ");
INSERT INTO snx_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Yesus bili mendelxo, “Sina xelag ye sa xasi ud tei pesx nane suma ben uneb xasuidoxne, Xotei ana mangau hali tenemxo suma nenxabe yudx. Yinane duma gongglu xiliyai xoxlib ndingsi yuwalbe xasui saxne yeluidox. ");
INSERT INTO snx_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Ino barge bena nyi une pidax udud hambi xanden ne nyi toxourdax. Ne beli tenemx nyi barge kujexya jagar si bil xujalx sidxm. Ne hali toto nyi barge lilxo jagar sidxm ne nyi balax aiyox xujalx sob nenx xasuimbem kulodxm. ");
INSERT INTO snx_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ino kwesang bena nyi une pidax udud hambi xanden ne nyi toxourdax. Ne beli tenemx nyi kwesang kujexya jagar si bil xujalx sidxm. Ne hali toto nyi kwesang lilxo jagar sidxm ne nyi balax aiyox xujalx sob nenx xasuimbem kulodxm. ");
INSERT INTO snx_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ne ino nyamge bena nyi une pidax udud hambi xanden ne nyi duduxyax. Ne beli tenemx nyi nyamge kujexya jagar Xotei ido kingdom maglib minjedxm. Ne hali toto nyi nyamge lilxo jagar sidxm ne nyi balax aiyox xujalx sob nenx xasuimbem kulodxm. ");
INSERT INTO snx_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","So nenxabe ‘sumaxangglixja indo ambil ne moreng ayaxbar, ne balax mosu ayaxaman.’ ");
INSERT INTO snx_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ju indo mangau ne atrai kumogx biyarge pidemane atrai ne Xotei nyambe jaxalaiyax. Nenxasi balax ne Xotei ido sumaxangglixja kumogx xabe dadxone andug Xotei nyambe jaxalaiyax. ");
INSERT INTO snx_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Biyar adu beli. Nedine biyar ido kwaxeing aiyox xanden ne nyingga koxoraibane aib kwaxeing dili adox? Nyingga biyar ido kwaxeing pala saxabarxone inggo inggo jagar pari osolox sax.” Yesus adun sis munjrulxo. ");
INSERT INTO snx_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesus Kapenam so udisne Judia distrik indo so maglib minjelxo sis burbardis Jodan yag xoub minjoubxo. Aib bili suma xijirayai adu sib leubxo, sis ido mangau ne andug xele hunjisilxo. ");
INSERT INTO snx_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Parisi dagi les ne adu inar be sam toum youbxo, “Manam sam sis mendexo suma adu ngobix kandong toxour yax kere?” ");
INSERT INTO snx_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Adu aib mendelxo, “Pinxa Moses ana kokonggelxo?” ");
INSERT INTO snx_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Andug mendoubxo, “Moses adu suma ongnjixo ne suma adu wamoi be inggreng ana xanggli huyudxo. Xanggli huyinane kandong toxourdin xendeima minjedxo.” ");
INSERT INTO snx_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesus aib mendelxo, “Nyingga jajan tambi nenxa Moses manam ne inggrengasi hanggelxo. ");
INSERT INTO snx_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Nyingga xiyaba. Nomi tenemx Xotei pinhalel kumogx koraxalox. Adu ‘suma xo xangglixjax koranjulxo ne andug suma ayoubxo ne andug xanggli ayoubxo.’ ");
INSERT INTO snx_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Kulu nenxa suma adu alabi xo anyibixo udinjinane ido ngobi digi pag ana saxlul. ");
INSERT INTO snx_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Sux nenxa asux lilx ne dodamug kujex aiyaxlul.’ Nenxa asux lilxo si jalx, asux kujex. ");
INSERT INTO snx_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Nenxa Xotei ana turdinjiux ne suma adu toxourdax kerejal.” ");
INSERT INTO snx_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Andug urum maglib sisne sox suma Yesus sam nenxasi inar siyoubxo. ");
INSERT INTO snx_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Adu mendelxo, “Suma ye adu ngobi udina xanggli be padxo ne suma ne adu ngobi huyeman mangau yixna. ");
INSERT INTO snx_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Suxne xanggli ye adu gumblibi udina suma be padxo ne xanggli ne adu gumblibi huyeman mangau yixna.” ");
INSERT INTO snx_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Sumaxangglixja dagi indo xelag dudu pes Yesus sib leb kundung dinjaxasi, nedine sox suma andug nyamang hunjoubxo. ");
INSERT INTO snx_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Nedine Yesus adu xox sisne adu agraglox. Adu sis munjurulxo, “Hagdunjub xelag dudu sa sib leba sis andug kornjaxjal. Xotei ido kingdom ne sux nenx indo. ");
INSERT INTO snx_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Sa xabu toto munggrixama, sumaxangglixja xelag wa pala yaxabarxo ne Xotei ido kingdom ne andug ya paxbarxo.” ");
INSERT INTO snx_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Sisne adu xelag lumnjisne ido barge usub persine nyoblo hunjisilxo. ");
INSERT INTO snx_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Nal nenxa Yesus adu xensi minjax silane suma be baxeingasi adu sib lesne adu parib tomblonglox. Adu inarlox, “Inggreng Suma beli, pinxa toto sa sox na kexei pen sina sidxm a?” ");
INSERT INTO snx_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesus mundulxo, “Pinax nyi sa beli mubrixama? Xotei idoiya beli. ");
INSERT INTO snx_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Nyi manam sam xele: ‘Suma taxlaxjal, suma be ngobi yeiyaxjal, yuwemyaxjal, jager xatusam mendaxjal, jagerasi pinhalel paxjal, ino ala xo ama bogagub sax.’ ” ");
INSERT INTO snx_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Adu Yesus mundulxo, “Inggreng Suma, manam sam kumogxo ne sa xelag halib soxmonxo.” ");
INSERT INTO snx_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesus adu xoxsine adu xasi pari beli lox ne adu mendelxo, “Pin kujex nyi gambisxna. Nyi mos, pinhalel kumog so asine, moni yeibra sumaxangglixja hunjax. Nyi simane nyi Heven sob yereadxm. Ne nyi les sa soxbe.” ");
INSERT INTO snx_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Suma ne yere xiliyai dili, nenxa adu pala persine adu pari xurang pes minjelxo. ");
INSERT INTO snx_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesus xoxnjisne sox suma munjurulxo, “Suma pinhalel yere xone adu Xotei ido kingdom maglib minjax hanggardox!” ");
INSERT INTO snx_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ne sox suma andug sam nenxasi pudox hali ayoubxo. Nedine Yesus aib munjurulxo, “Du kube, Xotei ido kingdom maglib minjax hanggar xosix! ");
INSERT INTO snx_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kamel nidel bodo maglib minjax ne hanggarx. Nedine yere sumaxangglixja Xotei ido kingdom maglib minjax ne hanggar tenemxo.” ");
INSERT INTO snx_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ido sox suma pudox hali xiliyai youbxo sisne indoi indoi mbelembe sax sam asoubxo, “Ne ye toto kagonjudxo?” ");
INSERT INTO snx_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesus andug xoxnjisne mendelxo, “Suman pin ne yaxman, nedine Xotei ana kere. Xotei ana pinhalel kumogx yax kere.” ");
INSERT INTO snx_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pita adu mundulxo, “Xoxyu! Ga pinhalel kumogx udisne soxmbaxmun!” ");
INSERT INTO snx_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesus mendelxo, “San nyingga xabu munggredxm, sumaxangglijax kumogx ana sa xo kanin samx xasi tubar kulu udin ko aubi ko naibi ko anyibi ko alabi ko xelagi ko yu ko udnjudxne ");
INSERT INTO snx_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","adu hameg miyang wanx 100 padxo. Sumaxangglixja ye adu urum, aubikube, naibikube, anyibikube, xelag, yu padxo. Ne dide suma dagin andug alul yaxabarxo. Sinane nal bunge dadxone andug kexei sina saxabarxo. ");
INSERT INTO snx_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Nedine sumaxangglixja lambeiyai nomi aborxo ne andug bunge aiyaxbarxo. Sisne andug ye bunge aborxo ne nomi aiyaxbarxo.” Yesus adun sis munjrulxo. ");
INSERT INTO snx_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesus ido sox suma jagar andug Jerusalem taunbe wox sibane Yesus adu nomi alane ido sox suma andug udud lambei peoubxo. Silane sumaxangglixja andug soxnji soubxo ne ula aiyoubx. Yesus ido 12 sox suma gagrenjis xoub mosne pin xa adu xabe dax ne munjurulxo. ");
INSERT INTO snx_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Adu mendelxo, “Xiyaba. Ga hameg Jerusalem taunbe xoaxamun. Andug ana Suma ido Ngidibi lola urum gadi naman xo manam sam ido xele sumax indo bargeb pidaxabarxo. Andug adu xasi mendubxo adu ugel yiux, nenxa adu miyamin. Andug sam taxas adu taxas medinane andug ana adu Jentail indo bargeb pidaxabarxo. ");
INSERT INTO snx_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Andug ana adu dome sam mundinane mesel yinane hurixnane taxan medaxabarxo. Nal xalubi udinane adu aib xuduadox.” Yesus adun sis munjrulxo. ");
INSERT INTO snx_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sebedi ido ngidibi lilxo, Jems xo ido aubi kanangge Jonx, Yesus sib lesne inar youlxo. Asux sis mendulxo, “Inggreng Suma, yaxayo do pin be xasi inarmbianden nyi pin ne nyi yax hagax.” ");
INSERT INTO snx_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Adu asux inarnjulxo, “Pinxa nyisxa san yi hanggax ud pesxa?” ");
INSERT INTO snx_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Asux adu mundulxo, “Nal nenxya nyi kingdom maglib gadi sisne yaxa be ino bar belisax be ino bar koinsax be njanayax.” ");
INSERT INTO snx_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesus mendelxo, “Nyisxa pinxa xasi inaradox ne nyisxa xele ajalxa. Nyisxa xurang sa padxm ne nyisxa pax kere e? Sa miyadxm ne nyisxa miyax kere e?” ");
INSERT INTO snx_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Asux ongasine mendulxo, “Yaxa kere.” Yesus asux munjrixo, “Nyisxa sa yag gambab hesxam nenxabe yag henane mangau xa sa yag kungguadxm ne nyisxa kungguyaxlol ");
INSERT INTO snx_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","nedine hajo belixsa xo koinsaxbe njanyax ne san mendax kerejal. Njan so ne Xotei ana suma ye ido maraxo nen indo gerei hunjixo.” ");
INSERT INTO snx_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Nal nenxabe Yesus ido 10 sox suma dagi sam ne xe sisne andug Jems xo Jon xasi agragnjulxo. ");
INSERT INTO snx_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesus ido sox suma jagar manjisne munjurulxo, “Nyingga xele, suma andug Jentail indo gadi sixane andug Jentail xumarnjax bail hali asixa. Sisne andug indo suma xiliyai dide suma kumogx andug bogagub persixa. ");
INSERT INTO snx_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Nedine mangau ne nyingga mbelem saxjal. Suma ye adu suma xiliyai sax xasi, ne adu nyingga inggo kinggal suma sax. ");
INSERT INTO snx_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Suma ye adu nomi xasi sax ne adu suma kumogx indo kinggal suma lolx sax. ");
INSERT INTO snx_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ne pinax, Suma ido Ngidibi adu dide gan toromya xasi yogoljal. Nedine adu agu ne ga hwagem kexei sax toromgiux. Nenxasi kweing ana miyadxo.” Yesus adun sis munjrulxo. ");
INSERT INTO snx_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Silane andug lex Jeriko taunbe deoubx. Yesus ne ido sox suma andug sumaxangglixja lexeingai jagar taun udis mosabane suma nyam burx ne gaman xoub njanasine sumaxangglixja moni xasi inarnjisilxo. Ido donyam Batimeus ne ido alabi Timeus. ");
INSERT INTO snx_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Adu xiyalxone Yesus adu Nasaret suma adu le silxo. Adu kuluisi xoeng ayax sisne mendelxo, “Yesus, Devit ido ngidibi, nyi sa xasi pari xurangmbe!” ");
INSERT INTO snx_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Sumaxangglixja xe sisne adu korsine mundubxo, “Nyi tenenemasi si,” nedine adu andug sam xe hunjijal. Adu xoeng xiliyai yisne mendelxo, “Devit Ngidibi, nyi sa xasi pari xurangmbax!” ");
INSERT INTO snx_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesus tingasine mendelxo, “Adu maiba lemin.” Silane andug nyam burx ne maisi mundubxo, “Adun nyi mambix, nenxa nyi pari bailasi tingasine le.” ");
INSERT INTO snx_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Silane adu ido dubran bugax ilongai kabuasi silxo ne xasuilox. Sisne adu gasan tingasine Yesus sib lelxo. ");
INSERT INTO snx_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesus adu inarlox, “Ino udud ne sa nyi koxrambedxa?” Silane nyam burx ne Yesus sis mundulxo, “Inggreng Suma, sa xox aiyaxsi.” ");
INSERT INTO snx_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesus adu mundulxo, “Nyi minje. Ino udud tei nedana nyi belidxmbixo.” Ne gasanx ido nyamge beliasine adu nyam pidelxo. Silane adu gaman Yesus soxsine minjelxo. ");
INSERT INTO snx_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Sisne andug Betpeij xo Betani tubarbe deubxo. Tubar ne Olib ido Gabrab silxo. Tubar ne Jerusalem taun kulub silxo. Nenxabe Yesus ido sox suma lilxo sonjisne ");
INSERT INTO snx_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","munjurulxo, “Tubar taxausx ne maglib minjax. Sibane nenxabe dongki ulum nding youbxo nenx six ne xoxyaxbarxo. Ne adu suma ben usub njanajal. Mbereng dis pes wa lax. ");
INSERT INTO snx_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ye nyi inarmbixanden, ‘Kulu xa nyi wa yisxam?’ Adu mundax, ‘Aiyaman kinggal huyinane gasan soadox.’” ");
INSERT INTO snx_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Andug mosne dongki ulum gamanbe tingasilane jam mob be nding youbxo, ne tordoubxo. Sis andug mbereng doubxo. ");
INSERT INTO snx_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Suma dagi nenx tinggring soubx ne inarnjoubxo, “Nyisxa mangau xa yaxasi dongki mbereng dis xa?” ");
INSERT INTO snx_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Asux sam xa Yesus ana munjurulxo ne mendulxo. Suma andug asux aruwinjab minjoulxo. ");
INSERT INTO snx_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Asux dongki pes les Yesus sib des isxo dubran bugax ilongai pes dongki usub hulax youlane Yesus usub njanalox. ");
INSERT INTO snx_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Sumaxangglixja lambeiyai indo dubran bugax ilongai gamanbe hulax youbxo. Dagi yub mos wam bar toxourdis pes les gamanbe hulax youbxo. ");
INSERT INTO snx_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Sumaxangglixja dagi andug nomi ayoubxo xensi mosne dagi Yesus bunge ayoubxo. Andug haroisi minjoubxo, “Xotei xalongyax!” “Suma adu Aiyama donyambe sam lexo ne Xotei ana adu nyoblo huyudxo!” ");
INSERT INTO snx_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Xotei ana mangau beli asa gadi wanxabe adu ga xumargisidxo. Adu asa gadi hago was Devit ker maglib sam!” “Xotei Bugbe Toto xalongsi peding dax!” ");
INSERT INTO snx_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesus Jerusalem si dalxo sisne lola urumbe minjelxo. Adu pinhalel kumog xoxsi kwalilox, nedine bula alane adu ido sox suma jagar Betani tubarbe minjoubxo. ");
INSERT INTO snx_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Nal bexo ne andug Betani tubar udis mos soubxane Yesus adu mamlox. ");
INSERT INTO snx_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Weyexya sam kurap moi dili xoxlox. Adu xaxali dagi six e ne xeleayax minjelxo. Adu mos ne kulub dalxo. Adu xedelalox beli xaxali jalxo, moi ya silxo, ne pinxax kurap ido xaxali nal jal. ");
INSERT INTO snx_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Sila adu kurap mundulxo, “Nyi bili ilaxajal. Suma andug nyi heaxbar.” Adu sis mendelane adu ido sox suma sam ne xeoubxo. ");
INSERT INTO snx_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Andug Jerusalem taunbe desne Yesus lola urum xoub mosne adu pinhalel hwaasi so asoubx ne xendeinjulxo. Adu suma ye andug moni dapil asoubx nenx indo baxalu bul hunjisne suma ye andug goul so asoubxo indo njan so baxalu ne bul hunjulxo. ");
INSERT INTO snx_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Adu sumaxangglixja ye pinhalel pes lola urum xoub inggam mo le asoubxo ne kornjulxo. ");
INSERT INTO snx_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ne adu andug usernjisne munjurulxo, “Xotei ido inggreng sis mendexo: ‘Hajo urum ne kauntri kumogx sumaxangglixja sa xasi geinayax urum.’ Nedine nyingga ne yuwem suma ido holopax so olengborxo.” ");
INSERT INTO snx_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Sumaxangglixja kumog ido sam xesne pudox hali ayoubxo. Nenxa lola urum gadi naman xo manam sam ido xele suma andug Yesus xasi ula ayoubx. Nenxasi andug adu taxaleb miyax gaman xedelayoubx. ");
INSERT INTO snx_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kolu alane andug Jerusalem taun habrex deubxo. ");
INSERT INTO snx_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kogli bexo andug xensi mosne andug kurap wam barig kumogx lilaalox ne xox youbxo. ");
INSERT INTO snx_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pita udalox ne Yesus mundulxo, “Inggreng Suma, nyi ono! Wam kurap nyina saya soimonx ne adu lila ayiux!” ");
INSERT INTO snx_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesus andug aib sis munjrulxo, “Xotei xasi tei ud pax. ");
INSERT INTO snx_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Xabu toto sa nyingga munggrixam, suma yena gabra ne mundudxo, ‘Nyi tingasi pudoxasi yuwalbe kulo.’ Ne adu ud lilx xujalxone ne adu ud tei dili ne adu pin ne adu mendexo ne sin dadxo. Nenxa adu mangau ne toto sin de huyudxo. ");
INSERT INTO snx_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Nenxa sa nyingga munggrixama, pinxa nyi udud tei xasi geinbe sam inardxm, pin ne nyi padxm. ");
INSERT INTO snx_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Nyi gein kuluiyaxasine nyi suma ben unembixu sixne nyi udamonxo sixam ne nyi suma nen ido une ne xendeiyax. Sidxmne ino Ala Hevenbe sixnane adun nyi dide une xendei hambedxo.” ");
INSERT INTO snx_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Andug bili aib Jerusalem taun maglib leubane Yesus adu lola urum xoub xen silane lola urum gadi naman xo manam sam ido xele suma xo Ju indo gadix andug adu sib leubxo. ");
INSERT INTO snx_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Andug adu inar youbx, “Xabexbe bail xo donyam bugbe ne nyi pes mangau yisxam? Ne yen nyi bail hambin nyi mangau yisxam?” ");
INSERT INTO snx_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesus aib munjurulxo, “Sa nyingga inar kujex hanggedxm. Ne sa ongbax, ne siyba sa nyingga munggredxm sa bail xab sam mamangau yisxam. ");
INSERT INTO snx_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Jon sumaxangglixja yag kunggu dinjisilxo. Mangau ne Hevenbe sam e? Suma xabe sam e? Sa mubreba.” ");
INSERT INTO snx_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Andug indoi indoi sam uleng youbx ne sis mendoubxo, “Ga mendaxmun ne, ‘Hevenbe sam,’ ko, adun inargedxo, ‘Ne pinxax nyingga adu udud tei huyijalx?’ ");
INSERT INTO snx_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Nedine ga sin mendaxmun, ‘Suma xabe sam,’ ko?” Andug sumaxangglixja andug xasi ula ayoubane ne pinax andug kumogx udud tei ne Jon xabu toto Xotei ido mob suma. ");
INSERT INTO snx_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Nenxa andug Yesus aib mundubxo, “Ga lol sixamun.” Yesus mendelxo, “Nenxa sa bail xab sam sa mangau yisxam ne nyingga dide munggraxaman.” ");
INSERT INTO snx_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesus ana lola urum gadi naman xo manam sam ido xele suma xo Ju indo gadix yaul sam be sam munjurulxo, “Suma be grep yu biyalxo. Sisne adu mek ganggol lox. Adu so be boxololxo ne grep xaxali ido yag pax. Adu ido grep yu xumaryaxasi nenxa baxalu gesu dili huyulxo. Sisne adu grep yu kinggal suma dagi umaryax hunjulxo ne moni pesne huyaxasi. Adu sisne so dideb weyexya minjelxo. ");
INSERT INTO snx_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Grep xaxali nal alane ido mara ne paxasi. Nenxa grep yu alabi ido kinggal suma be soilax grep yu kinggal suma sib mosne grep xaxali ido mara andug ana huyaxasi grep yub minjelxo. ");
INSERT INTO snx_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Nedine andug adu tindeng youbxo. Taxlebane adu barseiya minjelxo. ");
INSERT INTO snx_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Silane adu kinggal suma be bili soilax andug sib minjelxo. Andug suma ne gadib taxas ne mangau yaxjal ne adu xabe youbxo. ");
INSERT INTO snx_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Adu bili be soalox, ne be ne andug ana taxalubxo. Adu bili dagi lambeiyai sonjulxo. Andug dagi hurihurinjoubxo, dagi kiyangnjoubxo.” ");
INSERT INTO snx_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Adu kujexya so aiyax silx. Ne ido ngidibi, ido parig bum. Adun kumogx ido bitong ne so asine mendelxo, ‘Andug sa du sam sox huyaxbarxo.’ ");
INSERT INTO snx_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Nedine grep yu kinggal suma indo indo sam ayoubxo, ‘Wa adu ido alabi sambom padxo. Aria ga taxasne hagoi yu ne pes xumaryax.’ ");
INSERT INTO snx_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Nenxa andug adu pes adu taxas me disne adu huidabane grep yu habrexbe dalxo. ");
INSERT INTO snx_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Mangau xa grep yu alabi yudxo? Adu lenane grep yu kinggal suma alulnjinane grep yu suma dagi hunjudxo. ");
INSERT INTO snx_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Nyingga Xotei sam wa wasa xajalx e? ‘Duma ne urum kora sumana asrei youbxo. Duma ne adu hamegxa urum bail dax lunggun tingayoxsix. ");
INSERT INTO snx_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Aiyaman mangau wa yixo. Nenx ga hago nyamgeb xox ne beli toto.’ ” Sam ne Yesus adun sis munjrulxo. ");
INSERT INTO snx_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Lola urum gadi naman xo manam sam ido xele suma xo Ju indo gadix andug xele Yesus yaul sam andug xasi mendelxo, nenxa andug adu baryax gaman xedelayoubxo. Nedine andug sumaxangglixja unggurasi ulaayoubxo. Nenxa andug adu udis minjoubxo. ");
INSERT INTO snx_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Silane andug Parasi dagi xo Herod ido sox suma dagix Yesus sib sonjoubxo. Andug Yesus ido ugel sam be mende xaimane andug paxasi. ");
INSERT INTO snx_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Andug adu sib les mendoubxo, “Inggreng Suma, ga xele nyi xabu suma. Ne nyi suma xasi ulaajalxam. Nyi xabu sam toto mendesxam. Andug koxraxo ne nyi udnjijalxam. Nedine nyi Xotei ido gaman xabu usernjomonxo. Sisa ido takis hoa aiyax kere e? Kere jal? Ne ga hoayaxamun e hoayaxman?” ");
INSERT INTO snx_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Nedine Yesus andug indo jager sam ne adu xele. Adu inarnjulxo, “Pinxax nyingga sa toumbixa? Rom indo moni be pes lebane sa xoxda.” ");
INSERT INTO snx_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Andug moni pes leubxane adu andug inarnjulxo, “Ye ido pala xo donyamx ne iwad?” Andug mendoubxo, “Sisa ido.” ");
INSERT INTO snx_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Sis Yesus andug munjurulxo, “Pinxa Sisa ido ne Sisa huyax. Pinxa Xotei ido ne Xotei huyax.” Ne andug adu xasi pudox hali ayoubxo. ");
INSERT INTO snx_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadyusi mendesxa suma mes aib udu ayax ne jalxo. Andug adu inar youbxo, ");
INSERT INTO snx_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Inggreng Suma, Moses ga xasi inggrengalox ne suma ye aubi mes ne ngobi udulxo ne xelag xujalxo, ne xanggli kobul pes ne ido aubi xasi xelag nyam babdax. ");
INSERT INTO snx_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Andug aubi kube 7 soubxo. Mulumx xanggli palxo ne xelag xujalx miyalxo. ");
INSERT INTO snx_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Aubi sox ne xanggli kobul palxo, nedine adu dide xelag xujalx miyalxo. Aubi gomborbe ne dide sux. ");
INSERT INTO snx_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Andug dide 7 aubi kube xelag nyam babdijal morengayoubxo. Sisne xanggli kobul adu dide sux miyalxo. ");
INSERT INTO snx_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Men aib uduayaxbarxo nal nenx ye ido ngobi adox? Andug 7 kumogx ido gumblibi aborxo.” ");
INSERT INTO snx_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesus munjrulxo, “Nyingga Xotei sam inggreng ne nyingga lolsixa. Nyingga dide Xotei ido bail ne lolsixa. Nenxa nyingga sam ugel sixa. ");
INSERT INTO snx_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Mes aib udu aiyax nal dadxone andug indo indo kandong ayaxabar. Andug Hevenbe sombu pala saxbarxo. ");
INSERT INTO snx_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Mes aib udu ayax xasi, nyingga Moses sam inggreng xabe wam segerbe yos uring asilxo ido xatu wasa ajalx? Xatu ne Xotei ana Moses mundulxo, ‘Sa Abram ido Xotei, ne Aisak ido Xotei, ne Jekob ido Xotei.’ ");
INSERT INTO snx_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Adu suma mexo indo Xotei jal. Adu suma kexei sixa indo Xotei. Nenxa nyingga andosom ugelborxo.” ");
INSERT INTO snx_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Manam sam ido xele suma be les ne Sadyusi andug Yesus jagar sam datara soubxo ne xiyalxo. Yesus ana andug indo sam ne aib munjrulxo ne adu xiyalxo. Silane adu Yesus inarlox, “Manam sam xa xiliyai toto?” ");
INSERT INTO snx_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesus ana aib munjurulxo, “Manam sam xiliyai tenemx ne xiwad: ‘Nyingga Israel xiyax, Xotei Aiyama hago kujexya. ");
INSERT INTO snx_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Nyingga Aiyama inggo Xotei nenxa inggo pari kumogx, xunun, udud xo bail kumogx do huyi sax.’ ");
INSERT INTO snx_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Sis ne dide manam sam be ido sox ne xiwad: ‘Nyi ino do ned sam ne nyi suma dagi donjisx sax.’ Manam sam kumogx lilx wa yelui xujalx.” ");
INSERT INTO snx_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Adu Yesus sis mundulxo, “Inggreng Suma, nyi ino sam ne milal, xabu toto Xotei kujexya nyi mendexam nedi, nenxa Xotei be xujalxo. ");
INSERT INTO snx_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Nyingga inggo pari kumogx, udud xo bail kumogx do de sax ne Xotei huyax. Ne nyi ino do ne sam ne nyi suma dagi donjisx sax. Manam lilxo ne atra kumogx yelui six.” ");
INSERT INTO snx_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesus adu xiyalxo ne suma ne sam beli aib mendelxo, sila Yesus ana adu mundulxo, “Nyi Xotei ido kingdom weyexya si jalxam.” Nenxa suma kumogx Yesus pin be xa inaryax ula youbxo. ");
INSERT INTO snx_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesus adu lola urum xoub sam userasine adu inarlox, “Pinxax manam sam ido xele suman Kristus adu Devit ido ngidibi ne sis mendesxa? ");
INSERT INTO snx_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Devit adu idoi Xotei ido Mundor ana sam publab dulxo, ‘Aiyaman hajo Aiyama mundulxo, Nyi hajo bar belixsaxbe njanasi simane san ino kumal suma ino kwesang bogagub tadanjudxm.’ ");
INSERT INTO snx_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Devit idoiya ido donyam Aiyama mendelxo. Koxraina adu bili aib ido ngidibi adox?” Sumaxangglixja unggur xijra adu xesne pari belinjisilxo. ");
INSERT INTO snx_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Adu user sam munjrulxo, “Manam sam ido xele suma nyingga nyam pidax. Andug bugax iloilong hogsine olasixane andug suma kumogx maket sob pari beli sam hunjax andug donjisx. ");
INSERT INTO snx_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Sisne andug Ju indo bojou maglib xo hesam xiliyai xabe andug donyam soxor ya njan so do youbxo. ");
INSERT INTO snx_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Andug xanggli kobul indo urum pera tungnjis peubxo. Andug hambalumasi gein didedide ilong youbxo. Sisxa suma ne hwa pin hali hali paxabarxo.” Yesus adun sis munjrulxo. ");
INSERT INTO snx_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesus lola urum xoub atrayax pinhalel pidubx ido so kwadeb njanalox. Sisne adu xijra andug moni pidax sob nenx moni per soubx ne xox silxo. Yere suma tumbangai moni xilixili per soubxo. ");
INSERT INTO snx_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Nedine xanggli kobul pinhalel xujalxo ne adu les moni dudu lilx xasuilox, ido kulig ne toea kujex pidelxo. ");
INSERT INTO snx_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesus ido sox suma manjul adu sib minjoubane adu mendelxo, “Sa xabu munggrixam, xanggli kobul wa adu moni pidixu ne yere suma moni kumogx pidiberxone yeluyixu. ");
INSERT INTO snx_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Andug yerex suma yereasi huyoubxo ne kobul adu yebraasi huyulxo. Ne adu pinhalel kumogx ido xumar yax dili ne huyi kiridulxo.” Yesus adun sis munjrulxo. ");
INSERT INTO snx_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesus sis lola urum xoub udis minjelane ido sox suma be nedana mundulxo, “Inggreng Suma, xox yu! Duma xilixiliyai xo urum xilixiliyai milamilalai ne!” ");
INSERT INTO snx_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Silane Yesus ana mundulxo, “Nyi urum xilixiliyai ne unyixam e? Dumage kujexya wa be dagi usub saxaman. Andug kumogx hagdunjub kulaxabarxo.” ");
INSERT INTO snx_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Sis Yesus lola urum kwadeb xabe Olib Gabrab njanasilane Pita, Jems, Jon ne Endru andug adu idoiya toto inar youbxo, ");
INSERT INTO snx_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ga mugre, nal xax pinhalel kumogx ne dadxo? Sinane pin xa ido siga nedana pinhalel kumogx des keredax kulubx?” ");
INSERT INTO snx_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesus andug munjurulxo, “Xelexeleasi sax nedana suma ben jagernggaxaman. ");
INSERT INTO snx_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Sumaxangglixja lambeiyai sa donyam pen len mendaxabarxo, ‘Sa Kristus.’ Sina andug sumaxangglixja lambeiyai jagernjaxabarxo. ");
INSERT INTO snx_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Nal bexo nyingga xajax xo xajax sam mundor be xes ulaxayaxjal. Pinhalel kulu sux ne dadxo, nedine nal benggri bunge dadxo. ");
INSERT INTO snx_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kauntri be be jagar ubredxo. Ne asa gadi be suma gagrenjin asa gadi be jagar xubraxabarxo. Sinane tubar dagi sarinja denane gase xiliyai dadxo. Kulig kumogx ne xanggli du paxasi xurang pesx ne pala. ");
INSERT INTO snx_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Nyingga xelexele ayax. Andug ana sin nyingga mejistret bargeb tadangginane pen mon Ju indo bojou be yalamgaxabarxo. Nyingga probins indo gadi xo kauntri indo asa gadix parib tinggring ayaxbarxo ne pinax sa xasi. Nyinggan mendabane andug sa xasi xele paxabarxo. ");
INSERT INTO snx_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Siymane Xotei ido sam beli ne tubar kumogx keredin nomi din mendaxabarxo. ");
INSERT INTO snx_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Nal xa nyingga tindenggis ne sam gerei yax o siyxanden nyingga sam be mendax udud tunggulayaxjal. Xotei ido Mundor ana udud xa mendax nal nenxya hanggedxo. Ne inggo udud jal. ");
INSERT INTO snx_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Aubin aubi taxas medax sosoloadox. Sinane alabin ngidibi dide siydox. Ngidibi kube tinggring ana alabi xo anyibix kube medinjax suma munjraxabarxo. ");
INSERT INTO snx_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nyingga sa xasi udud tei pen saxabarxo ne sumaxangglixja kumog nyingga ironjudxo. Nedine nyingga ye ting bail ana mox nal benggri xabe daxabarxo ne Xotei ana gagrenggin kagonggedxo. ");
INSERT INTO snx_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Nal xa nyingga xox yax pin hali so alul six ne denane langun sob tingadox. Suma Xotei sam wasaasine xele ayax. Siymane suma ye andug Judia sixane, jarui na gabrab xoaxbarxo. ");
INSERT INTO snx_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Suma ye adu ido urum kundab six ne, adu miyangbe kol na urum maglib mon pinhalel paxman. ");
INSERT INTO snx_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Suma ye yub sidx ne adu aib mon ido dubran bugax ilongai paxaman. ");
INSERT INTO snx_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Pari xurang xiliyai tenemxndi ne nal nenxabe, xangglixja kweb xo xangglixja xelag wal nanjisxa nenxabe dadxo! ");
INSERT INTO snx_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","19","Nal ne xurang xiliyai dadxo. Xurang ne kului si Xotei miyanghanggu koraalox nenx kerekere jal len hamegxa, sinane bunge bili kerekere sux ne saxman. Nenxa gein aba pin ne nal ru xabe daxman. ");
INSERT INTO snx_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Xotei adu nal kumogx ne hogodijal osine, sumaxangglixja kumogx saxabar. Nedine sumaxangglixja yeye ido maranjixu ne indo beli xasi, adu nal ne hogodixo. ");
INSERT INTO snx_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Nal nenxabe sumaxangglixja ben nyingga sin munggredxo, ‘Xoxba, Kristus six wad!’ ko ‘Xox ba, adu weyex six!’ Sam ne xe huyax jal. ");
INSERT INTO snx_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Jager Kristus xo jager Xotei ido mob sumax denane siga xo likongx user ayaxabarxo. Andug Xotei ido sumaxangglixja maraxo ne jagernjaxabarxo nedine andug gagrenjaxbar. ");
INSERT INTO snx_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Sa nyingga pinhalel kumogx bunge dadxo nenxasi munggrumxo. Nenxa nyingga xelexeleasi sax. ");
INSERT INTO snx_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Nal kumogx nenxabe kulig xiliyai ido nal nomi sux dadxo ne bunge, ‘seng xalug, ne xexelem ido uring daxman; ");
INSERT INTO snx_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Benanggar kumogx lang bugbe ureng ana yoglaxabarxo, sinane lang bugbe pinhalel kumogx renjingyaxbarxo.’ ");
INSERT INTO snx_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Nal nenxabe sumaxangglixjax Suma ido Ngidibi bail xiliyai xo ido uring milal tenemdi jagar arom maglib sam xoxyaxabarxo. ");
INSERT INTO snx_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Sin adu ido sombu kinggalnjum mon ido sumaxangglixja kumogx maraxo, ne so kumogx nenxa gagrenjin unggur dinjaxabarxo. Sin andosomx mon miyanghanggu bil be xo lang ido bil be daxabarxo. ");
INSERT INTO snx_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Nyingga wam kurab xabe xele paxabarxo. Sisi palai nane ido bar ne xosolox anane ido bobug padxo. Nenxabe nyingga xele ayaxabarxo seng nal kulubx. ");
INSERT INTO snx_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Sux ned, nal xa nyingga pinhalel kumogx ne dab xoxnjixane, nyingga xele ayax, ne Suma ido Ngidibi kulubx lex, mbourbe dex. ");
INSERT INTO snx_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Sa xabu nyingga munggrixam, sumaxangglixja nal wa kexei sibane mangau ne dadxo. ");
INSERT INTO snx_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Lang xo miyanghanggux ayox ayaxalul, nedine hajo sam ayox ayaxman. ");
INSERT INTO snx_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Suma be nal nen xo seng nyam ne xelejal, Xotei ido Sombu Hevenbe sixa nen xo ido Ngidibix dide xelejal, nedine Alabi idoi nal ne xele. ");
INSERT INTO snx_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Nyingga xeleasi xoxasi sax! Nyingga lol sixa nal xa xo dadxo. ");
INSERT INTO snx_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ne sux, suma be ne adu so udin minjedxo. Adu ido urum udinane ido kinggal suma urum xumaryax ne kuje kujex kinggal gadi didedidei ne yax hunjudxo. Sinane suma be mbour xumaryax mundudxo. ");
INSERT INTO snx_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Urum alabi adu bulax ko, kolu mbelem ko, muru xoeng asim ko, kogli hali ko aib dadxo ne nyingga lol sixa, nenxa xelexeleasi sax. ");
INSERT INTO snx_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Sina adu gasanx len, nyingga wil asib xoxnggedx nenxa. ");
INSERT INTO snx_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Sam xa sa nyingga munggrumenxo, ne sa sumaxangglixja kumogx munjrumonxo: ‘Xelexeleasi sax!’ ” Yesus adun sis munjrulxo. ");
INSERT INTO snx_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Nal wanxabe, lola urum ido kanin ido mul lilxo laham dadxo. Mul ne ido donyam, Pasova. Mul be ido donyam ne, Bred Yis Xujalxo Ne Ido Ge. Sisne lola urum gadi naman xo manam ido xele sumax andug yobu Yesus tindengsi taxalax nenxasi sam taxas soubxo. ");
INSERT INTO snx_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Andug mendoubxo, “Ju indo mul xiliyai be maglib nenx yaxjal, sina sumaxangglixjax xuber ting daxabarxo.” ");
INSERT INTO snx_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesus Betanis sisne suma Saimon nomi hogar gemba dili xo sisoubxo. Ne urum maglib baxalub nenx njanasi silxo. Silane xanggli be dumagen nggiling koraxo, ne goreng nad ana koraxo ne hwapin bugbex ido ne pes lelxo. Sisne adu nggiling xobrox disne Yesus gadib xuruxlox. ");
INSERT INTO snx_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Suma dagi jagar soubx ne ironjulane indo indo sis mendubxo, “Pinaxasi goreng ne alul yix, a? ");
INSERT INTO snx_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ne adu so ayox osine 300 silba moni yebra suma hunjax ne pex osine.” Sisne andug ironjul adu ngeser youbxo. ");
INSERT INTO snx_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Yesus mendelxo, “Adu uduba. Pinaxasi nyingga adu kulig huyix, a? Adu sa mangau milalai yibix. ");
INSERT INTO snx_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Yebra suma nal kere nyingga jagar saxabarxo, ne nal xa xo udud tingane toromyax. Nedine sa nal keredin nyingga jagar saxman. ");
INSERT INTO snx_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Adu mangau xa yax kere ne yix. Adu sa dodamug be goreng xurux yix ne, bunge hajo sub kulax ne gerei yix. ");
INSERT INTO snx_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Sa nyingga xabu munggrixam, miyanghanggu kumog wa so xabex be, sam beli wa mendaxabarxo ne, pin xa xanggli wa yixo ne dide mendenane adu udyaxbarxo.” ");
INSERT INTO snx_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Silane Judas Iskariot mos lola urum gadi naman sob desne Yesus xasi sosoloasi andug bargeb pidax munjurulxo. Judas Iskariot Yesus ido sox suma 12 maglib nenxabe silxo. ");
INSERT INTO snx_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Andug sam ne xes pari beliyainjulane sam bail dis adu moni huyax mundubxo. Siybane Judas Yesus andug bargeb pidax xasi gaman dagi xedelasilxo. ");
INSERT INTO snx_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Bred Yis Xujalxo Ne Ido Ge he nal kuluilox, ne indo mangau ne soxna sipsip ulum pen nal Pasova ne udna atra xayaxbarxo. Yesus sox suma nedana adu inar youbxo, “Nyi so xabe dodombis ne gan mon Pasova ne ido heax pinhalel ne gereiyaxamun?” ");
INSERT INTO snx_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Adu ido sox suma lilxo ne sonjis munjurulxo, “Siti maglib minjax silane suma be yag wob kubai na len nyisax tordinggedxo. Ne nyisxa adu soxyax. ");
INSERT INTO snx_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Adu urum xa maglib mo xandenane, urum ne ido alabi nyisxan mundax, ‘Inggreng Suman inarayox, “Sa hajo talu magli ne xabex be six, ne sa hajo sox suma jagar Pasova ido pin ne heaxamun?” ’ ");
INSERT INTO snx_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Adun talu magli urum biling lilxo bugbe ne usernggedxo, ne pin heax so xo njan sox gerei xuraxo. Nenxa hago pinhalel nenx gereiyax.” ");
INSERT INTO snx_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Sisne ido sox suma lilxo ne siti maglib mosne pin xa Yesus idoi munjurulx ne xox yolxo. Silane asuxa Pasova ido pinhalel ne nenxa gerei youlxo. ");
INSERT INTO snx_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Bula alane, Yesus ido sox suma 12 ne jagar nenx deubxo. ");
INSERT INTO snx_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Andug baxalub nenxabe njanjanasi pin he sabane, adu mendelxo, “Sa nyingga xabu munggrixam, nyingga maglib nenxa suma ben sa xasi sosolo pidedxo, ne adu sa jagar pin hesx.” ");
INSERT INTO snx_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Siylane andug pari ganjulxo. Sisne kujex kujex andug adu mundubxo, “Xabu, sa jal, e?” ");
INSERT INTO snx_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Adu munjurulxo, “Ne be 12 sox suma maglib nenx, ne ye sa jagar bred tuberbe kundung dixo ned. ");
INSERT INTO snx_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Suma ido Ngidibi udinggedxo, ne ido sam sis adu xasi inggrengxo. Nedine suma ye adu Suma ido Ngidibi xasi sosolo pidedxo ne xurang xiliyai padxo! Adu anyibin perjal osine, ne ido beli.” ");
INSERT INTO snx_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Andug pin he sabane Yesus bred be pes Xotei kai huyisne gobudulxo sis ido sox suma ne hunjisne munjurulxo, “Wa pab, wa hajo dodamug ido siga.” ");
INSERT INTO snx_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Sisne adu wain gamba pes Xotei kai huyis andug hunjulane andug kumogx heubxo. ");
INSERT INTO snx_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Adu sis munjurulxo, “Wa hajo ker ne asa sam ido siga, ne suma lambei xasi xurux yixam. ");
INSERT INTO snx_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Sa nyingga xabu munggrixam. Sa bili wain heaxaman ne bunge nal nenx Xotei ido kingdom wain kexei hedxm.” ");
INSERT INTO snx_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Sisne andug mundi xuradisne habrexbe des Olib Gabrab xoubxo. ");
INSERT INTO snx_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesus munjurulxo, “Nyingga kumogx udibin jarui yaxabarxo. Ne ido inggreng sux: ‘San sipsip xumar suma taxan medudane sipsip jaruina didedidei yaxabarxo.’ ");
INSERT INTO snx_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Nedine sa aib tinganane bunge sa nomi ana Galilix minjedxm.” ");
INSERT INTO snx_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pita babdulxo, “Sina suma kumogx ganjang kulaxabarxo, nedine sa xujalxo.” ");
INSERT INTO snx_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesus mendelxo, “Sa nyi xabu mumbrixam. Hameg, kolu wanxa, muru sam lilx dijal simane nyi inoi sa donyam xaxalang xalubi dudxm.” ");
INSERT INTO snx_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Nedine Pita danggaasi mundulxo, “Sina sa nyi jagar miyadxm, nedine sa nyi donyam xaxalang ayaxman.” Silane sox suma kumogx sam kujexya nei mendubxo. ");
INSERT INTO snx_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Andug so donyam Getsemani mendesxa ne minjubxo, sisne Yesus ana ido sox suma ne munjurulxo, “Wanx njanasi sibane sa mos geinada.” ");
INSERT INTO snx_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Adu Pita, Jems ne Jon gagrenjisne adu jagar minjubxo, sisne adu nomi pari xurang alulsine pari tunggul lox. ");
INSERT INTO snx_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Adu sis andug munjurulxo, “Hajo xunun pari xurang ana kabudixo ne adu me bil xabe six. Wanx sis xox asax.” ");
INSERT INTO snx_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Adu kambuix mosne, adu miyanghanggub kol tomblongsine geinalox, ne kereadox ne, nal ne adu yeluidox. ");
INSERT INTO snx_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Adu mendelxo, “Aba, Ala, pinhalel kumogx ne nyin yax kere. Nyi kulig wa xendeiyu. Nedine nyi sa udud wa soxyaxjal, nyi ino udud ne soxyax.” ");
INSERT INTO snx_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Sisne adu aib mox ido sox suma ne tordunjulx ne andug wiwil asoubxo. Adu Pita mundulxo, “Saimon, nyi wilamonx six e? Nyi xawa kujex xox asax kerejal e? ");
INSERT INTO snx_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Nyi xoxasi geinasi sax, siymane nyi toum xabe ganjang kulaxaman. Ino xunun adu dodoisix nedine ino dodamug adu xuling ayox six.” ");
INSERT INTO snx_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Bili adu mosne gein kulu kujex nei yulx. ");
INSERT INTO snx_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Andug nyam kumbom alulnjulxo. Sisne adu aib puluasi lesne adu bili xoxnjulx ne andug wiwil ana soubxo. Andug adu pinxax mundax ne lolol ayubxo. ");
INSERT INTO snx_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Adu bili le xalubi disne, adu andug munjurulxo, “Nyingga xarpidiberxo wiwilaborx six e? Ne kere! Xawa ne le xuradixo. Xoxba, Suma ido Ngidibi suma ben sosolo xasi une suma bargeb pidixu. ");
INSERT INTO snx_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Tinggring aba! Ga minjax! Suma sax xasi sosolo ayox ne le xuradixo!” ");
INSERT INTO snx_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Adu sam asilane Judas lelxo. Judas ne ido sox suma 12 maglib silxo. Suma xunggur singger xili ilong xo loblobx pesne adu xasi leubxo, ne lola urum gadi naman xo manam sam ido xele suma xo Ju indo gadin kinggalnjubxo. ");
INSERT INTO snx_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Sisne sosolo suma adu Yesus xasi andug jagar siga be gereisi youbxo, “Sa mui yixam ne suma nedi, tindengsi pes xumarsi minjax.” ");
INSERT INTO snx_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas Yesus sib ndengndengx mosne mundulxo, “Inggreng Suma!” Sisne muilox. ");
INSERT INTO snx_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Suma Yesus barsine tindeng youbxo. ");
INSERT INTO snx_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Siybane dagi kulubx tinggringasubx ne be singger pesne lola urum gadi naman xiliyai ido kinggal suma be damoib xanjangalox. ");
INSERT INTO snx_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesus mendelxo, “Nyingga singger xili ilong xo loblobx pes sa barbax lexa, ne nyingga uber suma ko yuwem suma be tindengya, e? ");
INSERT INTO snx_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nal kumogx sa nyingga jagar lola urum xoub sam beli munggrisoumxo, nedine nal nenx nyingga sa tindengbijal. Nedine mangau ne damane Xotei ido sam pidixu ne xabu ayaxasi.” ");
INSERT INTO snx_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Sisne sox suma kumogx adu udisne jarui youbxo. ");
INSERT INTO snx_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","52","Xelagu adu pin be hogjal, nedine adu bugax xapox ilong tagsine Yesus soxsilxo. Nal nenx andug adu barbane adu ido bugax udisne bisonggumx baxeingalox. ");
INSERT INTO snx_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Andug Yesus pes lola urum gadi naman xiliyai ido urumbe minjubxo, siybane lola urum gadi naman xo Ju indo gadi xo manam sam ido xele suma kumogx des tumbang ayoubxo. ");
INSERT INTO snx_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita adu weyexya pala soxsi mosne Ju indo bojou gadi xiliyai ido urum xoub ndengndeng minjelxo. Nenx adu xajax suma jagar njanasine adu balax xol silxo. ");
INSERT INTO snx_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Lola urum gadi naman ne Sanhedrin kumogx andug Yesus agub aju be xoxsine andug adu taxas medax xasi, nedine andug aju be tordijal. ");
INSERT INTO snx_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Suma lambeiyai jager sam adu xasi mendubxo, nedine indo sam mendubx ne kulu didedidei. ");
INSERT INTO snx_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Sis dagi tinggring sine jager sam adu sis mundubxo, ");
INSERT INTO snx_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ga xeunx ne adu sis mendelxo, ‘Sana suman koraxo lola urum wa alulnane nal xalubi maglib lola urum be koraxadxm ne suman korayaxabar.’ ” ");
INSERT INTO snx_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Siyoubx nedine indo sam ne kulu didedidei. ");
INSERT INTO snx_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Siylane Ju indo bojou gadi xiliyai andug parib tingasine Yesus inarlox, “Nyi sam be mendaxaman e? Sam wa xa suma sixa wad ana nyi kinyombis mendesxa e?” ");
INSERT INTO snx_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Nedine Yesus tenenem ana silxo ne ongnjis sam be munjrijal. Bili Ju indo bojou gadi xiliyai ana adu inarlox, “Nyi Kristus, Suma Xiliyai ga ud sixamun nenx ido Ngidibi e?” ");
INSERT INTO snx_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesus mendelxo, “Ne Sa. Ne nyingga xoxyaxbarxo Suma ido Ngidibi Xiliyai Bail Dili bargeb belix sab njan ana Hevenbe xarom maglib sam yoglodxo.” ");
INSERT INTO snx_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ju indo bojou gadi xiliyai ido xo hog silxo xo ne bubrax dulxo. Adu mendelxo, “Adu sam ne idoi mendex iwad. Ga suma be adu xabe aju xedelayax bili paxman. ");
INSERT INTO snx_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nyingga xeberx nedi adu Xotei asreisine awauyixo. Nyingga ud ai sixa?” Kumogx mendubx adu ugel yixo, nenxa adu miyamin. ");
INSERT INTO snx_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Sisne dagi nomi kuluisi adu meselsine nyamge nding huyubx, sis bar gonggulu dis taxas ne mundubx, “Nyi Xotei ido mob suma ido sam be mende!” Sisne xajax suman adu pes ne taxalubx. ");
INSERT INTO snx_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita urum xoub miyangx be nenx silxo. Silane lola urum gadi naman xiliyai ido kinggal xanggli be lelxo. ");
INSERT INTO snx_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Adu Pita balax xol silxo sisne adu andosomx kulubx mos xox gereilox. Xanggli ne sis mendelxo, “Nyi dide Yesus Nasaret suma ne jagar soumx.” ");
INSERT INTO snx_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Nedine adu xaxalangasi sis mendelxo, “Sa lol sixam. Nyi sam xa mendexam ne sa xelejal.” Sisne habrexbe mbour kulub minjelxo. ");
INSERT INTO snx_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Kinggal xanggli ne bili xox lox ne adu nenx silxo. Silane adu bili dagi tinggring asoubx ne munjurulxo, “Suma wa dide indo be.” ");
INSERT INTO snx_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Adu bili xaxalang alox. Kambuix sisi palai sine, dagi kulubx tinggring asubx ned Pita mundubx, “Nyi Galili suma, sisne xabu toto nyi indo suma be.” ");
INSERT INTO snx_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Adu kuluisi saya sam ne xoengasi sam mendelxo, sisne adu sam bail disne andug munjurulxo, “Suma wanx xasi sam asixane sa lol sixam.” ");
INSERT INTO snx_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Gasanx muru xoeng lilx dulxo. Silane Pita Yesus ana sam xa mundulx ne udalox, “Muru xoeng lilx dijal simane nyi sa donyam xaxalang xalubi dudxm.” Siylane adu pari tunggulane songalox. ");
INSERT INTO snx_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kogli hali tenemxndi, lola urum gadi naman xo Ju indo gadi xo manam sam ido xele suma xo Sanhedrin kumogx sam bil be desne bail doubx. Andug Yesus ndingsine adu pes Pailot barge pidubxo. ");
INSERT INTO snx_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pailot adu inarlox, “Nyi Ju indo asa gadi e?” Yesus adu sis mundulx, “Ex, ne xabu nyina mendexam.” ");
INSERT INTO snx_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Lola urum gadi naman adu pinhalel lambei xasi kinyoi youbxo. ");
INSERT INTO snx_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Sis bili Pailot adu inarlox, “Nyi sam be mendaxaman e? Andug nyi sam lambei kinyombisxane nyi xe jalxam e?” ");
INSERT INTO snx_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Nedine Yesus ongyijal, silane Pailot pudox hali alox. ");
INSERT INTO snx_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Yar keredis Pasova ido nal xabe suma ye talu halib xendeiyaxbarxo. Ne sumaxangglixja kumogx indoiya suma ne mendaxabarxo. ");
INSERT INTO snx_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Suma donyam Barabas o sisxane talu hali maglib silxo. Ne ye adu suma Rom gavman jagar sam datara xunggur ne seger be silxo. Nal be suma xunggur ne andug Rom gavman jagar dataraasi ne suma kiyang ayoubxo. ");
INSERT INTO snx_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Sumaxangglixja xunggurai Pailot sib loxsine mangau xa meleng kere adu yisilxone aib yax inar youbxo. ");
INSERT INTO snx_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pailot inaralox, “Nyingga san Ju indo asa gadi wa lolx hag duda minjema e?” ");
INSERT INTO snx_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pailot xele alox lola urum gadi naman andug Yesus xasi tera sam asine adu pes Pailot bargeb pidubxo, nenxa adu sis mendelxo. ");
INSERT INTO snx_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Nedine lola urum gadi naman xunggur xiliyai udud tingndi hunjisne andug Pailot maisi mundubx, ne Barabas hag disne Yesus hag daxjal. ");
INSERT INTO snx_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pailot andug inarnjulx, “Nyingga Ju indo asa gadi o sis xa. Ne sa adu mangau xa ida?” ");
INSERT INTO snx_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Andug xoeng haro youbxo, “Adu burbarbe kweingdxm miyama!” ");
INSERT INTO snx_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pailot inaralox, “Pinax xasi? Adu mangau hali xa yixo?” Nedine andug xoeng haro alul youbxo, “Adu burbarbe kweingdxm miyama!” ");
INSERT INTO snx_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pailot xunggur xiliyai ne udud gereinji hunjax xasi nenxa Barabas hagdul andug sib minjelxo. Adu Yesus pes xajax suma munjurulane hurix youbxo. Sisne andug burbarbe kweingndax xasi pes xoubx minjoubxo. ");
INSERT INTO snx_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Xajax suman Yesus pes gavana ido so ganggolx be ne maglib minjubxo. Sisne xajax suma kumogx manjubane leubxo. ");
INSERT INTO snx_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Andug bugax purpel be Yesus hog huyoubxo. Sisne sel jingglang pes turdis ganggongndisne, asa gadi ido hat kora palaisine adu gadib pidubxo. ");
INSERT INTO snx_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Sisne andug xoengasi awausi mundubxo, “O, Ju indo asa gadi!” ");
INSERT INTO snx_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Andug aib sebe xasi xangar danggal ana gadib taxas ne mesel soubxo. Sisne andug talaisi kwesang tomblongsine adu donyam pedingndi huyi soubxo. ");
INSERT INTO snx_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Sisne andug adu awau uradisne andug bugax xo purpel xendeisine ido bugax xo aib pidubx. Silane andug adu pes xoub mosne adu burbarbe kweing daxasi. ");
INSERT INTO snx_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Suma be ido donyam Saimon taun xoub inggam lesne adu taun maglib minjaxasi. Adu Sairin suma, ne Xaleksanda xo Rupusx isxo alabi. Ne ajax suma dagin adu burbar kubaiyax dangga doubxo. ");
INSERT INTO snx_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Andug Yesus so Golgota o sis mendesx ane minjubx, donyam ne ido kulu ne sux, Gadi Ngisili ido So. ");
INSERT INTO snx_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Sisne andug wain wam gag mur jagar bulsine adu huyubx, nedine adu pes hejal. ");
INSERT INTO snx_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Sisne andug adu burbarbe kweing doubxo. Sis ido bugax xo paxasi gusxe ayoubxo. Sisne suma be toto adun pin xa ne padxo. ");
INSERT INTO snx_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","9 kilok koglix andug adu burbarbe kweing doubxo. ");
INSERT INTO snx_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Andug adu kulu xax sam xasi kulig huyubx ne ido inggreng sux, “Ju indo Asa Gadi.” ");
INSERT INTO snx_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Andug yuwem suma lilxo Yesus kulub burbarbe kweingdunjubxo, be bar belixsax, be bar koinsax. ");
INSERT INTO snx_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Dagi ye andug adu yeluisine awau sam mundi soubx. Andug indo gadi korengasi ne mende soubx, “Nyi ye nenxa nyi lola urum wa alulsi nal xalubi maglib huyax mendumxo. ");
INSERT INTO snx_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Nyi inoi ino torom si burbar bugbe sam yoglo!” ");
INSERT INTO snx_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Lola urum gadi naman xo manam sam ido xele suma xo dide sam kulu nei indoi mendes ne adu awau soubxo, “Adu dagi toromnjisixu, nedine adu ido toromyax kerejal! ");
INSERT INTO snx_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Adu Kristus, ne Israel indo asa gadi, sidxone adu burbar udin na yoglodxo. Siyma ga unyin na udud tei paxamun!” Sinane yuwem suma lilxo adu jagar kweing ayulx ne asux dide awau yulxo. ");
INSERT INTO snx_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","12 kilok so xalug les miyanghanggu kumogx kabudis silx mox 3 kilok bula alox. ");
INSERT INTO snx_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Sisne 3 kilok Yesus bailx xoengasi sis mendelxo, “Eloi, Eloi, lema sabaktani?” Ido kulu sux, “Hajo Xotei, hajo Xotei, pinax nyi sa udibixam?” ");
INSERT INTO snx_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Suma dagi kulubx tinggring asubx ne andug ne xeubx, sisne andug mendubx, “Xiyaba, adu Elaija maisix.” ");
INSERT INTO snx_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Suma be baxeingasi mos, wain ngakraiyixo spans be yulx, sis danggal be sel pes bugbe persine Yesus huyum heaxasi. Adu mendelxo, “Mete adu udub sim. Ga xoxyax sina Elaijan mbe adu pes miyang be yoglodxo ko jalxo.” ");
INSERT INTO snx_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesus bail xoengasine, adu mundor hungsi miyalxo. ");
INSERT INTO snx_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Lola urum ido bugax xo xiliyai gadib sam bubraxasi kol kulub desne, kodekodebasi lilx alox. ");
INSERT INTO snx_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Xajax suma gadi adu Yesus parib ting asilxo ne adu Yesus ido xoeng xesne adu me xailox ne xoxlox, sisne adu mendelxo, “Xabu toto, suma wa Xotei ido Ngidibi!” ");
INSERT INTO snx_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Xangglixja dagi weyexya pala tinggringasi inggam xox soubxo. Andug maglib nenx, Maria Makdala ne Maria Jems kanangge xo Josep isxo anyibi, xo Salome ne andug soubxo. ");
INSERT INTO snx_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Galili nenx xangglixja ne andug adu xumar si sox soubxo. Ne xangglixja lambeiyai dagi ye adu jagar Jerusalemx leubx ne dide soubxo. ");
INSERT INTO snx_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Hameg pinhalel gereiyax ido nal, iblam Sabat. Ne nomi bula nyam lililx ne kulub alox ");
INSERT INTO snx_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","silane Josep Arimatea suma, ne adu lanja xiliyai suma be kaunsel maglib, ne ye adu idoi Xotei ido kingdom xasi sambun asilxo. Ne adu ula xujalxo Pailot sib mosne Yesus gubol xasi inarlox. ");
INSERT INTO snx_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Silane Pailot Yesus miyalxo sam ne xes pudox hali asine adu xajax suma gadi manjul leubxo. Sis Pailot Yesus xabu mexo e sis adu inaralox. ");
INSERT INTO snx_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pailot xajax suma gadi xabe sam xe gereilox ne xabu alox. Silane adu Yesus gubol Josep huyulxo. ");
INSERT INTO snx_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Sisne Josep bugax xapox dagi hwaasine Yesus gubol pes miyangbe yogolsine bugax xapox maglib persine ngalagalox. Sisne duma maglib sub koraxo nenxabe pidelxo. Sisne adu duma ginggongsi mos sub mbour gide dulxo. ");
INSERT INTO snx_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Makdala ne Maria Josep ido anyibi, ne asux so xabex be xox asulane asux nyambe Yesus ido gubol duma dingginib pidoubxo. ");
INSERT INTO snx_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sabat bunge xabe, Maria Makdala xo Maria Jems ido anyibi xo Salome andug Yesus gubol ildaxasi goreng kulog milal ne hwaxayoubxo. ");
INSERT INTO snx_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Nal kuluila kogli hali seng lox pinjrang lane andug gaman soxsine suma hogsixa sob minjoubxo. ");
INSERT INTO snx_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Andug indo indo da inarayoubxo, “Suma yen sub mob be duma ne ginggongdox?” ");
INSERT INTO snx_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Nedine andug weyexya sam xoxayoubxo ne duma xiliyai mob ne ginggong ba xoub minjelxo. ");
INSERT INTO snx_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Andug sumaxanggixja gubol hogsixa duma dinggini ne maglib minjoubxo ne xelagu be bugax xapox hogsi sub maglib bar belixsax nenx njan asilxo. Andug adu xoxsine pudox hali ayoubxo. ");
INSERT INTO snx_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Adu munjurulxo, “Nyingga pudox hali aiyaxjal. Nyingga Nasaret suma Yesus andug ana burbarbe kweing doborxo nenxasi xedelasixa e? Adu aib tingayox! Adu wanx sijalx. Wilayox so sambom ne xoxba. ");
INSERT INTO snx_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Nenxa mosne ido sox suma ne Pita ne munjrax, ‘Adu nomi xasi Galilix minjixo.’ Adu ido sam nomi nyingga munggrelxo ne nyingga adu nenx xoxyaxbarxo.” ");
INSERT INTO snx_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Xangglixjax ne do kakarnjisne lolol ayoubxo. Andug sumaxangglixja gubol hogsixa duma dinggini so ne udis baxeingasi minjoubxo. Andug ulasine, nenxa sumaxangglixjax be sam mundijal. ");
INSERT INTO snx_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Wik kujex ido nal, nal kuluisi kogli hali tenemxo, Yesus sumaxangglixja gubol hogsixa duma dinggini sob sam tingasine Maria Makdala sib mete dalxo. Xanggli ne adun 7 mundor hali xendei huyulxo. ");
INSERT INTO snx_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Maria mos suma dagi Yesus jagar soubxo ne andug yamu asoubxo ne mos munjurulxo. ");
INSERT INTO snx_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Adu andug xanggli nedana Yesus tingalox ne xoxsine sam munjurulxo. Nedine andug xes ne xabu o siyjal. ");
INSERT INTO snx_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Bunge sox suma lilxo ne taun xoub xensoulxane Yesus asux sib kulubeasine dalxo. ");
INSERT INTO snx_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Asux ana sam ne les suma kur be mendulxo ne dide andug xabu o siyjal. ");
INSERT INTO snx_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Bunge Yesus ido sox suma 11 pin hesoubxane Yesus andug sib desne ngesernjulxo ne andug adu xasi udud tei pe jal. Ne dide sumaxangglixja Yesus aib tingalox nenx ido sam munjurulxo ne andosomx xes pejal. ");
INSERT INTO snx_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Adun andug munjurulxo, “Miyanghanggu kumogxbe mosne sam beli wa sumaxangglixjax kumogx publab dis munjrax. ");
INSERT INTO snx_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Sumaxangglixjax ye sam wa xen udud tei pena yag kunggu ayaxbarxo ne Xotei ana andug gagrenjin kagonjudxo. Nedine sumaxangglixjax ye sam wa xen udud tei paxman ne adu hwa pin hali padxo. ");
INSERT INTO snx_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Sumaxangglixjax saxasi udud tei pes saxabarxo ne likong dagi andug ana yaxabarxo. Sa hajo donyambe sam andug mundor hali xendeinjis saxabarxo sinane andug men bulnane sam kexei mendaxabarxo. ");
INSERT INTO snx_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Andug bogi bargen paxbarxo, sin dide andug ngaram pin heaxabarxo ne moreng aiyaxbar andug barge gembax suma usub pidax barxone gemba pong dunjudxo.” Yesus adun sis munjurulxo. ");
INSERT INTO snx_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Aiyama Yesus adu andug jagar sam xuradisne Xotei ana adu pesne Hevenbe woxsine ido barge belixsab njan dixu six. ");
INSERT INTO snx_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Silane ido sox suma so kumogxbe mosne sam ne publab doubxo. Aiyama idoiya andug jagar kinggal pesne likong kumogx yisilxo ne ido sam bail desilxo. ");
ALTER TABLE snx_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
