﻿USE sofia;
DROP TABLE IF EXISTS sofia.snw_vpl;
CREATE TABLE snw_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES snw_vpl WRITE;
INSERT INTO snw_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Nnya Yesu Kristo banantii ayooto ninle n-ya mmle nɛ. Ɔka Dawid kɔna kuale kuakye ni Abraham leyo kamɛ. ");
INSERT INTO snw_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham lalofo Isak, ni di Isak kafɔɔ lalofo Yakob wɔ nialofo ni Yuda ku babilɛma nɛ. ");
INSERT INTO snw_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda kafɔɔ ku ɔsɔfɔ nɔɔ Tamai lalofo Peres ku Sera, ni di Sera kafɔɔ lalofo Hesron nɛ. Hesron kafɔɔ lalofo Aram. ");
INSERT INTO snw_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram kafɔɔ lataka aalofo Aminadab, ni di Aminadab kolofo Naheson nɛ. Naheson kafɔɔ lalofo Salmon. ");
INSERT INTO snw_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ni di Salmon kafɔɔ kɔtaka anlofo Boas wɔ di ɔya latoole ni Rahab nɛ. Boas kafɔɔ lalofo Obed, ɔya niale Rut nɛ. Obed kafɔɔ lataka aalofo Yisai, ");
INSERT INTO snw_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ni di Yisai kafɔɔ kolofo Ɔka Dawid nɛ. Diɛyɔ ni di ɔka Dawid suoto diɛlaase ni di obe wɔ kamɛ di Babilon batii lamufũ Israel batii baasifiko ni sɛlanle kamɛ di Babilon kasɔ suoto yi, kɔna nwu ninle nko mmle nikɔwa ni nɛ. Dawid ku ɔsanko wɔ niale ni Uria ɔsɔfo lalofo Salomo. ");
INSERT INTO snw_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ni di Salomo lalofo Rehoboam nɛ, ni di Rehoboam kolofo Abiya nɛ. Abiya kafɔɔ kolofo Asa nɛ. ");
INSERT INTO snw_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ni di Asa lalofo Yehosafat nɛ. Yehosafat kafɔɔ lalofo Yoram, ni di Yoram kafɔɔ kolofo Usia nɛ. ");
INSERT INTO snw_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia lalofo Yotam, ni di Yotam lalofo Ahas nɛ, ni di Ahas kafɔɔ kolofo Hiskia nɛ. ");
INSERT INTO snw_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hiskia lalofo Manase, ni di Manase lalofo Amon nɛ, ni di Amon kafɔɔ kolofo Yosia nɛ. ");
INSERT INTO snw_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosia lalofo Yekonia ku babilɛma suɔtɔbi di sɛlanle kamɛ di Babilon batii kasɔ suoto. ");
INSERT INTO snw_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Diɛyɔ ni di obe wɔ di Israel batii ladie ni di Babilon kasɔ suoto di sɛlanle kamɛ, diɛlaase ni di obe wɔ baalofo ni Yesu, bawa nɔɔ ayooto ninle n-ya mmle nɛ. Yekonia lalofo Sealtiel, ni di Sealtiel kafɔɔ lalofo Serubabel nɛ. ");
INSERT INTO snw_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabel lalofo Abihud, ni di Abihud lalofo Eliakim nɛ. Ni di Eliakim kafɔɔ kolofo Asor nɛ. ");
INSERT INTO snw_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asor lalofo Sadok, ni di Sadok lalofo Akim nɛ. Ni di Akim kafɔɔ kolofo Elihud nɛ. ");
INSERT INTO snw_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Elihud lalofo Eleasar, ni di Eleasar kafɔɔ kolofo Matan nɛ. ");
INSERT INTO snw_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Matan lalofo Yakob, ni di Yakob kafɔɔ kɔtaka anlofo Yosef wɔ niayɔ ni Maria wɔ nialofo ni Yesu wɔ bɔɔlɛɛ ni alɛ Kristo nɛ. ");
INSERT INTO snw_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Nkpo oso diayɔ ni di Abraham suoto dialaase ni di Dawid suoto yi, diabla lefosi ana anà. Diayɔ ni di Dawid suoto kafɔɔ dialase ni di obe wɔ di Babilon batii lamufũ Israel batii baasifiko ni kasɔ lɛma suoto kafɔɔ, diabla lefosi ana anà. Nkpo okle kafɔɔ diayɔ ni di obe nwu kamɛ dialaase ni di obe wɔ baalofo ni Kristo nwu kafɔɔ, diabla lefosi ana anà. ");
INSERT INTO snw_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Nnya mmle okle diawa ni fiɛ baalofo ni Yesu Kristo. Baakaalɛ Maria baata Yosef, kafɔɔ fiɛ babayɔ ni bawo yi, Maria lanya alɛ nfɛ alaka lɛmɛ. Yaa Ninwuna Klekle niata diawa ninkpo. ");
INSERT INTO snw_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yosef lale otii tinini di Yaa anu. Kafɔɔ atamiɛ alɛ ookpee nwɔ sinunsɔ di batii anu. Nioso aabla disibu alɛ, oodiɛ nwɔ buɛɛ. ");
INSERT INTO snw_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Obe wɔ ɔɔbla ni disibu le mmle aasifi aalaate nii, Yaa tɔkyɛntɛ ladiki suoto aatuo nwɔ di kɔlaafɔ kamɛ, ni aatɔkɔ nwɔ alɛ, “Yosef, Dawid leyo kamɛ obi, tanyɛkɛ Maria ɔsɔfɔ lɛfɔ ɔyɔ. Diekye lɛmɛ le alaka ni yi, Yaa Ninwuna osie kamɛ diekye. ");
INSERT INTO snw_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Abalofo osuɔtɔbi, faatika nwɔ leyooto falɛ Yesu, diekye nnwɔɔ nimadiki batii nɔɔ ankyeko sikpile lɛma kamɛ nɛ.” ");
INSERT INTO snw_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Asaa ya mmle amuu lawa kaanya alɛ, sɛlaa se di Yaa labuɛ aafenko ni di ɔlaa buɛtɛtɛ nɔɔ suoto kawa kaanya. Aabuɛ alɛ, ");
INSERT INTO snw_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Kabitɛ ka nínanye ni osuɔtɔ, malaka lɛmɛ, anlofo osuɔtɔbi. Babalɛɛ nwɔ alɛ Emanuel.” Lɛsɔdiki ninle alɛ Yaa nsiko wo. ");
INSERT INTO snw_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Nkpo oso obe wɔ di Yosef lasɛnkɛ nii, aayɔ Maria aabla ɔsɔfɔ nɔɔ fɛ mmle di Yaa tɔkyɛntɛ nwu nkpo latɔkɔ nwɔ nii. ");
INSERT INTO snw_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Kafɔɔ, Yosef ku Maria ditatofo bawo fɛ ɔsa ku ɔsɔfɔ dialaase di obe wɔ aalofo ni obi nɔɔ suɔtɔbi nwu nkpo. Ni di Yosef latika nwɔ leyooto alɛ Yesu nɛ. ");
INSERT INTO snw_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Di obe wɔ di Herode latoole ni sɛka yi, ni baalofo Yesu di okpoo wɔ baatɔɔlɛɛ ni Betlehem di Yudea kasɔ suoto nɛ. Di obe nwu nkpo kamɛ, ni di banumbentɛ ba ninye ni asaa di awɛntrɛbi suoto bawo lakye kufĩ katunkɔ baawa Yerusalem nɛ. ");
INSERT INTO snw_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ni baakaalɛ alɛ, “Ɔfɛ beelofo obi wɔ nimale ni sɛka di Yuda batii kasɔ suoto? Buɔnya lɛwɛntrɛbi nɔɔ di kufĩ katunkɔ. Nioso butɔɔwa bulɛ buɔbatansa nwɔ nɛ.” ");
INSERT INTO snw_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Obe wɔ di Ɔka Herode lanu ni ɔlaa wɔ mmle yi, ɔfɔɔ lasifi nwɔ ku Yerusalem batii bamuu osie kanya. ");
INSERT INTO snw_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Nkpo oso aalɛɛ Yaa olebatatɛ banɔɔfo bamuu ku kufiofa asaa batuotɛ aasiisa, ni aakaalɛ ma alɛ, “Ɔfɛ babalofo Kristo nwu nkpo?” ");
INSERT INTO snw_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Nfa nfɛ bɔɔtɔkɔ nwɔ alɛ, “Betlehem okpoo di Yudea kasɔ suoto babalofo nwɔ. Diekye nimmle okle di Yaa ɔlaa buɛtɛtɛ lɛkpana ni alɛ, ");
INSERT INTO snw_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Afɔ Betlehem di Yuda kasɔ, diele okpoo biibii fale di Yuda sekpoo kamɛ. Diekye afɔ kamɛ di tunletɛ kplɛ nwu madie ankye, amaleko kale nii Israel batii katũ.’ ” ");
INSERT INTO snw_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Nkpo oso Herode lalɛɛ bafɔɔ nwu nkpo niakye ni kufĩ katunkɔ di ɔlɔɔkɔ kaawofakɔ, ni aakaalɛ ma aanu obe wɔ kamɛ tutuutu baanya lɛwɛntrɛbi nwu nkpo lakyɔɔ nii. ");
INSERT INTO snw_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ninfɛ aadiki ma osuku alɛ batɔɔkyɛ Betlehem nɛ. Ni aatɔkɔ ma alɛ, “Bitɔɔkyɛ biɛlaawolaa obisɔ nwu nkpo nwaa. Nse biɛnyɔɔ, biekple biwa biɛbatɔkɔ mi alɛ ami kafɔɔ kakyɛ nnaasumu nwɔ.” ");
INSERT INTO snw_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Nioso bafɔɔ nwu nkpo layefe osuku baasifi. Obe wɔ nfɛ bakyɛ ni di osuku, baakple baanya lɛwɛntrɛbi nwu nkpo tutuutu baanya ni di kufĩ katunkɔ. Baanya ni nii, suoto layɔɔ ma osie kanya. Lɛwɛntrɛbi nwu nkpo laleko ma katũ diakyɛ dialaayila di lɛba le di obisɔ nwu nkpo late nii. ");
INSERT INTO snw_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ni baabuo di leyo nwu nkpo kamɛ nɛ. Nioso obe wɔ baanya ni obisɔ nwu nkpo ku ɔya Maria yi, baase akunkyi kaasɔ, baawakosa asi kasɔ baasumu nwɔ. Ninfɛ baasɛkɛtɛ kotofoe lɛma baadiki atasaa ya awo niefũ ni kɔya ninle ni koto sɛɛle, olufuii ku kloboo baatɔɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Nni kamaa, baafe di osuku bamba suoto baasifi okpoo lɛma. Diekye Yaa lasĩ ɔlaa aata ma kɔɔlaafɔ kamɛ alɛ, bataasinkple baalaafe di Herode ɔkyɛ. ");
INSERT INTO snw_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Obe wɔ baafɔɔ nwu nkpo lasifi ni kamaa yi, Yaa tɔkyɛntɛ onwii ladiki suoto aatuo Yosef di kɔɔlaafɔ kamɛ. Ni aatɔkɔ nwɔ alɛ, “Herode mawolaa obisɔ nwu nkpo alɛ oolo. Nkpo oso taka faakpaa obisɔ nwu nkpo ku ɔya bietoso bisifi Egipte kasɔ suoto. Biesiɛ ninfa dielaase di obe wɔ makple ntɔkɔfɔ nlɛ kple fawa ni.” ");
INSERT INTO snw_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Kakyɛ nwu nkpo Yosef lakpaa obisɔ nwu nkpo ku ɔya baatoso baasifi Egipte kasɔ suoto. ");
INSERT INTO snw_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Baasiɛ ninfa dialaase di obe wɔ di Herode lakpi nii. Nle mmle lawa ninkpo, diata alɛ ɔlaa wɔ di Yaa labuɛ aafenko ni di ɔlaa buɛtɛtɛ nɔɔ suoto lawa kaanya alɛ, “Egipte kamɛ lalɛɛ obi nii lakyeko.” ");
INSERT INTO snw_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Di obe wɔ di Herode latofo alɛ bafɔɔ nwu niakye ni kufĩ katunkɔ lakyɔnkyɔ nwɔ ni yi, ɔblɔ lafiɛ nwɔ osie kanya. Nkpo oso aakpee bakpɛtɛ nɔɔ baakyɛ Betlehem ku aba ya niɛtɛɛtɛ ni nfa fɛɛ, alɛ baalaalo babi suɔtɔbi ba nintoofũ ni alɛɛ anyɔ ku mba ninayifũ ni nkpo. Aabla nkpo ta mmle okle di bafɔɔ nwu nkpo latɔkɔ nwɔ ni obe wɔ baanya ni lɛwɛntrɛbi nwu nkpo. ");
INSERT INTO snw_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Babisɔ ba mmle olo lata alɛ ɔlaa wɔ di Yaa Ɔlaa Buɛtɛtɛ Yeremia labuɛ aatɛ ni lawa kaanya. Aabuɛ alɛ, ");
INSERT INTO snw_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Batii lanu sɛlɔ sewo di Rama alɛ boowi kaku osie kanya ku sɛnyaami. Rahel nikowi anta babi nɔɔ. Eesĩ kafɔɔ alɛ batanlo sɔɔ, diekye babi nɔɔ nwu nkpo lekpi.” ");
INSERT INTO snw_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Obe wɔ di Herode lakpi ni yi, Yaa tɔkyɛntɛ onwii ladiki suoto aatuo Yosef kɔɔlaafɔ kamɛ di Egipte. ");
INSERT INTO snw_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ni aatɔkɔ nwɔ alɛ, “Taka, faakpaa obisɔ nwu nkpo ku ɔya biekple bisifi Israel kasɔ suoto. Diekye batii ba nikomiɛ alɛ balo ni obisɔ nwu nkpo ntookpi.” ");
INSERT INTO snw_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Nkpo oso Yosef lataka, ni aakpaa obisɔ nwu nkpo ku ɔya baakple baasifi Israel kasɔ suoto nɛ. ");
INSERT INTO snw_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Kafɔɔ obe wɔ di Yosef lanu alɛ Arkelao wɔ ninle ni Herode obi nfɛ ninsi ni di ote lekpomii suoto oole ni sɛka di Yudea yi, aayɛkɛ nfa ɔkyɛ. Nioso Yaa tɔkyɛntɛ onwii lasĩ aatɔɔ kɔɔlaafɔ kamɛ alɛ atankyɛ nfa, ninfɛ aakɛ aasifi Galilea kasɔ ntɛɛ nwu suoto nɛ. ");
INSERT INTO snw_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Obe wɔ aalaabuo ni nfa, aasifi aalaasiɛ di okpoo wɔ bɔɔlɛɛ ni Nasaret. Nfa lɛma ɔlaasiɛ lata alɛ, ɔlaa wɔ di Yaa ɔlaa babuɛtɛtɛ labuɛ baatɛ ni alɛ, “Batii malɛɛ nwɔ ni Nasaret otii yi,” diawa kaanya ninkpo. ");
INSERT INTO snw_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Di obe nwu nkpo kamɛ yi, Yaa Ntu Kpeesatɛ Yohane lakyɛ Yudea ɔfaafuu kasɔ suoto, aakye kasɔ aatooyie Yaa ɔlaa lɛkya, ");
INSERT INTO snw_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","aatoobuɛ alɛ, “Bidiɛ sikpile ɔbla, diekye Yaa sɛka kalekɔ ntɔɔtɛɛtɛɛ.” ");
INSERT INTO snw_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yohane wɔ mmle niale otii wɔ suoto di Yaa Ɔlaa Buɛtɛtɛ Yesaia labuɛ aatɛ alɛ, “Otii onwii kɔfaa di ɔfaafuu kamɛ ambuɛ alɛ, ‘Bilolaa osuku bitɛ bita Saate nwu ɔwabee. Bikyɛkyɛsa aba ya abafe ni bitɛ nwɔ!’ ” ");
INSERT INTO snw_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Awu ya di Yohane lakpee ni yi, kapupɔnkɔ sinwini baayɔ baabla n-ya. Ni aayɔ bɔkɛɛ kukũ okũ aatika ofiamɛ nɛ. Alesaa nɔɔ kafɔɔ niale bablɔ ku akpakyekyee. ");
INSERT INTO snw_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Batii lakye Yerusalem okpoo ku Yudea kasɔ kamuu suoto ku sekpoo se simuu niɛtɛɛtɛɛ ni Yordan okle baawa ɔkyɛ nɔɔ. ");
INSERT INTO snw_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Baadiki sikpile lɛma baabuɛ, ni aakpeesa ma Yaa ntu di Yordan okle kamɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Obe wɔ di Yohane lanya Farisi batii ku Saduki batii kpinwu lawa ni ɔkyɛ nɔɔ alɛ akpeesa ma ni Yaa ntu yi, aatɔkɔ ma alɛ, “Aye kɔsaanwu kɔna! Owe niɛka ye alɛ biatoso di Yaa lɛkanko le nikɔwa ni kamɛ? ");
INSERT INTO snw_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Bibla asaa ya nimatuo alɛ bitookyi ni siikple lee kamɛ. ");
INSERT INTO snw_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Bitanyu bilɛ biatɔkɔ suoto lee bilɛ Abraham banantii bile. Diekye kɔtɔkɔ ye nlɛ, Yaa mafuo afuɔ ya mmle ɔyɔ ɔbla banantii anta Abraham. ");
INSERT INTO snw_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","“Nunua bia yi, batɔɔyɔ kafɛ beese di awoso sidu suoto kofokofoko. Kowoso lele ninantika abi biene yi, bababudi kũ, man-yɔ kũ mankpee di ɔtɔ kamɛ. ");
INSERT INTO snw_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Ami yi, ntu kɔyɔ nkpeesa ye Yaa ntu, diotuo alɛ bitookyi ni siitu lee kamɛ biediɛ ni sikpile ɔbla. Kafɔɔ otii wɔ ninkɔwa ni kaamaa nii yi, abayɔ Ninwuna Klekle ku ɔtɔ ankpeesa ye Yaa ntu. Otii nwu nkpo lɛtaka katɔɔ alenke mi, ninansiɛko alɛ katuka nwɔ ni bia ntokota. ");
INSERT INTO snw_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Akle kɔfɛɛ nɔɔ ninnɛɛ kamɛ, abafɛɛlɛ kufuo andiki ni di kamɔɔ kamɛ, an-yɔ kamɔɔ ankpete ni di owu kamɛ. Kafɔɔ abafiɛ kufuo nwu di ɔtɔ wɔ ninnaa ni kaloo kamɛ!” ");
INSERT INTO snw_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Di obe nwu nkpo kamɛ yi, Yesu lakye Galilea aawa Yohane nfũ di Yordan okle kotoko alɛ, Yohane akpeesa nwɔ Yaa ntu. ");
INSERT INTO snw_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Kafɔɔ Yohane lamiɛ alɛ ookyisa nwɔ ni disibu nwu oso, aatɔkɔ Yesu alɛ, “Ami dikpe ni alɛ lɛwa ɔkyɛ lɛfɔ feekpesɛɛ Yaa ntu. Diele afɔ nikawa ɔkyɛ nii!” ");
INSERT INTO snw_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Kafɔɔ Yesu ladiki kanya aatɔkɔ nwɔ alɛ, “Nu kasɔ, faata bubla ninkpo nunua. Diekye nle mmle nimatuo alɛ buɔbla Yaa dibiesaa nɛ.” Ninfɛ di Yohane lanu kasɔ aatɔɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Nioso obe wɔ baakpeesa Yesu Yaa ntu baaloo ni aatoodie ni di ntu nwu kamɛ, nfanwu osi niasɛkɛtɛ, ni aanya Yaa Niwuna latoosoo fɛ mmle di lɛlaapɔɔ nsoo nii, diabasiɛ nwɔ di suoto nɛ. ");
INSERT INTO snw_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ninfɛ di sɛlɔ lakye osi siabuɛ alɛ, “Nnya obi nii bɔmbɔtɛ ninle nwɔ mmle nɛ, oobuo mi anu nwaa.” ");
INSERT INTO snw_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ninfɛ di Yaa Ninwuna lakpaa Yesu aasifiko ɔfaafuu kamɛ alɛ, Abonsam alaasɔ nwɔ anyu nɛ. ");
INSERT INTO snw_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Di obe wɔ di Yesu ntoonii kanya kakũ ku kakyɛ ayi afosi ana eeloo nii, kɔka laklee nwɔ. ");
INSERT INTO snw_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ninfɛ di Abonsam lakyɛ ɔkyɛ nɔɔ aalaatɔkɔ nwɔ alɛ, “Nse Yaa obi fale, ni tɔkɔ afuɔ ya mmle falɛ akple alesaa.” ");
INSERT INTO snw_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Kafɔɔ Yesu ladiki kanya alɛ, “Kɔkpana Klekle Kukũ lebuɛ alɛ, ‘Diele alesaa lete suoto di otii nsiɛ nkpa. Kafɔɔ ansiɛ nkpa di ɔlaa lele niedie kuokye Yaa kanya kamɛ.’ ” ");
INSERT INTO snw_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ninfɛ di Abonsam lakpaa Yesu aasifiko Yerusalem ninle ni Yuda batii okpoo kplɛ klekle nwu kamɛ. Ninfɛ aayɔ nwɔ aalaatika di Yuda batii Olekatakɔ katakalekɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ninfɛ aatɔkɔ nwɔ alɛ, “Nse Yaa obi fale yi, faayefe fakye ninfũ fasifi kasɔ. Diekye Kɔkpana Klekle Kukũ lebuɛ alɛ, ‘Yaa makyesee batɔkyɛntɛ nɔɔ alɛ babakafɔ fɔ ku nnɛɛ lɛma, alɛ flaayɔ kɔkpaa lɛfɔ fasa di afuɔ kuanwii suoto.’ ” ");
INSERT INTO snw_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu ladiki kanya alɛ, “Kafɔɔ Kɔkpana Klekle Kukũ nwu nkpo lebuɛ alɛ, ‘Tansɔ Saate Yaa lɛfɔ faanyu.’ ” ");
INSERT INTO snw_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ninfɛ di Abonsam nwu nkpo lakple aakpaa Yesu aasifiko kobokote takale kunwii nsintɛɛ. Ninfɛ aadiki kayi ka mmle sɛka nlekɔ mmuu ku sɛlɛ ninya aatuo nwɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ni aatɔkɔ Yesu alɛ, “Nse fabapɛ akunkyi kaasɔ fansumu mi yi, kamayɔ asaa ya mmle ammuu nta fɔ.” ");
INSERT INTO snw_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ninfɛ di Yesu ladiki kanya aatɔkɔ nwɔ alɛ, “Satana, kyɛ mi di ɔlɔɔkɔ fasifi! Diekye Kɔkpana Klekle Kukũ lebuɛ alɛ, ‘Saate Yaa lɛfɔ lete faase katũ kaasɔ fanta. Lete nɔɔ kafɔɔ faatansa.’ ” ");
INSERT INTO snw_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ninfɛ di Abonsam nwu nkpo lakyɛ aadiɛ Yesu nɛ. Ni di Yaa batɔkyɛntɛ lawa babakyakaako nwɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Di obe wɔ di Yesu lanu alɛ batoomufũ Yohane bɛɛtɛ ni di leyo katenkɔ yi, ni aasifi Galilea nɛ. ");
INSERT INTO snw_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Atasiɛ di Nasaret, kafɔɔ aasifi aalaasiɛ di Kapernaum, okpoo wɔ ninte ni di Galilea Lekpo ɔlɔɔkɔ di Sebulon ku Naftali kasɔ suoto. ");
INSERT INTO snw_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Aasiɛ ninfa diata alɛ Yaa Ɔlaa Buɛtɛtɛ Yesaia ɔlaa wɔ aabuɛ aatɛ lawa kaanya alɛ, ");
INSERT INTO snw_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","16","“Sebulon ku Naftali batii ba ninsi ni di osuku wɔ niefe ni lekpo ku Yordan okle kamaa, ku Galilea kasɔ suoto mananle ni Yuda batii! Batii ba ninsi ni di ditunu kamɛ manya lɛkpa kplɛ. Ku mba ninsi ni di kasɔ ka di kukpi kole ni sɛka yi, lɛkpa makpa ninkpete ma di suoto.” ");
INSERT INTO snw_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Diayɔ ni di obe nwu kamɛ yi, ni di Yesu lakye ɔlaa nɔɔ kasɔ lɛkya oyie alɛ, “Bidiɛ sikpile ɔbla, diekye Yaa sɛka olebee ntɔɔtɛɛtɛɛ!” ");
INSERT INTO snw_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Obe wɔ di Yesu latoofe ni di Galilea lekpo kotoko yi, ni aanya basuɔtɔbi banyɔ banwii nɛ. Mma niale Simon, nwɔ baatɔɔlɛɛ ni Petro ku obilɛma Andrea, baatɔɔtaa asawu di lekpo nwu kamɛ, diekye kɔkpaku badikitɛ baale. ");
INSERT INTO snw_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesu latɔkɔ ma alɛ, “Biwa biɛbatikankoe, matuo ye mmle mandiki ni batii.” ");
INSERT INTO snw_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Nfanwu, ni baadiɛ asawu lɛma baatɛ, baatikanko nwɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Obe wɔ aakyɛ ni sitũ kɛɛkɛ, ni aakple aanya Yakobo ku obilɛma Yohane ninle ni Sebedeo babi nɛ. Baasiɛ di oklo lɛma kamɛ manko ote lɛma baatooloso asawu lɛma. Ni di Yesu lalɛɛ ma nɛ. ");
INSERT INTO snw_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Nfanwu, ni baadiɛ oklo ku ote lɛma, baatikanko nwɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu lakyɛ aakyi Galilea kasɔ kamuu suoto aatootuo batii asaa di Yuda batii nsiisakɔ. Aatooyie lɛkya di Yaa sɛka ole ɔlaa biene nwu suoto. Ni aayɔɔsa batii ba ninkofiɛ ni sifiɛ ate ate bamuu sifiɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Leyooto nɔɔ lakyaka Siria kasɔ kamuu suoto. Nkpo oso batii lakpaa batii ba bamuu nikofiɛ ni sifiɛ ate ate baawako ɔkyɛ nɔɔ monoofuo ni lele kuniwii ɔbla. Batii ba di anwuna kpile nisi ni kaamɛ ɔɔkɔkpɛko ma nii, mba nikofiɛ ni kakpibubu, ku mba niekpi ni kakyɛkakyɛ. Ni di Yesu layɔɔsa bamuu lɛma ofiɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Batii dikudi kpinwu lakye Galilea ku eekpoo kplɛ lefosi nwu kamɛ ku Yerusalem ku Yudea kasɔ suoto ku Yordan okle kamaa fɛɛ, baawa babatikanko nwɔ. ");
INSERT INTO snw_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Di Yesu lanya ni batii dikudi nwu nkpo yi, ni aasifi kobokote kunwii suoto nɛ. Obe wɔ aasiɛ ni kaasɔ yi, ni di basaatekete nɔɔ lawa ɔkyɛ nɔɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ni aakyako ma asaa otuo alɛ, ");
INSERT INTO snw_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Suoto siyɔɔ batii ba nietofo alɛ bale ni bapiitɛ di ninwuna kamɛ, diekye lelema ninle Yaa sɛka kalekɔ nwu nɛ. ");
INSERT INTO snw_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Suoto siyɔɔ batii ba nikowi ni sɛnyaami, diekye Yaa makpee ma kɔnɛɛ kaafutu. ");
INSERT INTO snw_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Suoto siyɔɔ batii ba niɛwakosa ni suoto kasɔ, diekye mma nimale kayi ka mmle asaa nɛ. ");
INSERT INTO snw_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Suoto siyɔɔ batii ba di anu lɛsɛɛ ma alɛ boosiɛ ni nkpa tinini di Yaa anu, diekye babawɛ lɛsaa le nimayɔɔ ma ni kafutu. ");
INSERT INTO snw_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Suoto siyɔɔ batii ba ninnya ni bawo lɛma nyaami, diekye mma di Yaa manya nyaami nɛ. ");
INSERT INTO snw_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Suoto siyɔɔ batii ba siitu lɛma ntika ni lɛɛba ninwii, diekye mma nimanya Yaa nɛ. ");
INSERT INTO snw_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Suoto siyɔɔ batii ba ninlolaa ni batii ntɛɛ, diekye mma di Yaa malɛɛ alɛ babi nɔɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Suoto siyɔɔ batii ba baatii ntikanko bɔɔnya ni dibuo, ta basi ni nkpa tinini di Yaa anu oso, diekye lelema ninle Yaa sɛka kalekɔ nwu nɛ. ");
INSERT INTO snw_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Suoto siyɔɔ ye nse batii letufa ye, bɛɛta ye biɛnya dibuo, bɛɛlaa sɛlaa kuafunu beetika ye, ta bitikanko mi ni oso. ");
INSERT INTO snw_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Binya suoto lɛyɔɔ biɛpɔ, diekye letota lee mpɔ di Yaa kafa. Nkpo okle kafɔɔ baatikanko Yaa ɔlaa babuɛtɛtɛ ba niale ye ni katũ, baata ma baanya dibuo nɛ. ");
INSERT INTO snw_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Ote bite fɛ mba biɛta batii bamuu. Kafɔɔ nse mba nwu nkpo ɔmɛnɛfɛ nɔɔ ntooloo, lɛsalɛsaa kuninwii nsinnaa babayɔ mankpee mi ni ɔmɛnɛfɛ. Disinnaa nfasũ kunnwii, nioso ɔyɔ man-yɔ manwii batii nnanafu mi manfe. ");
INSERT INTO snw_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ote bite fɛ lɛkpa biɛta kayi kamuu. Okpoo wɔ beebudi ni koobokote suoto ninwofa diidii. ");
INSERT INTO snw_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Otii kuonwii ninsɔ kandiɛ aayɔ lɛsaa aatĩi nwu. Kafɔɔ ɔyɔ an-yɔ antika lɛɛba le kubakpa kunta ni batii bamuu leeyo. ");
INSERT INTO snw_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Nkpo okle kafɔɔ dikpe ni ɔsaabla lee lɛkpa fɛ kandiɛ kuɔta batii nɛ. Ni babanya asaa biene lee ya biɔbla nii, man-yɔ lɛtansa manta Teeye wɔ ninkpe ni kaatoo.” ");
INSERT INTO snw_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Yesu lakple aabuɛ alɛ, “Bitannyu bilɛ ɔwa lɛwa nlɛ kɔmaklee Mose kufiofa ku Yaa ɔlaa babuɛtɛtɛ asaa otuo ndiki. Ninwa nlɛ kɔmaklee nya ndiki. Kafɔɔ ɔwa lɛwa nlɛ asaa ya beetuo ni kawa kaanya. ");
INSERT INTO snw_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Komiɛ nlɛ bitofo bilɛ, obe wɔ di osi ku kasɔ ka mmle lɛnya kakpe ni yi, blɔbakyɛlɛnsa kufiofa ko mmle bɛɛkpana bɛɛtɛ nii bia kabɛfɛɛ nɔɔ dilabadie kaamɛ, diɛlaase di obe wɔ di asaa ya kuufiofa nwu nkpo kotuo ni lɛwa ni kaanya. ");
INSERT INTO snw_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Nkpo oso nse otii owo lɛtaka eeyila di kufiofa ko mmle bia kabɛfɛɛ nɔɔ suoto, eetuo batii bamba kafɔɔ alɛ baabla ninkpo yi, abale otii yɛntɛle di Yaa sɛka kalekɔ nwu nkpo kamɛ. Nkpo okle kafɔɔ nse otii owo lɛbla di kufiofa ko mmle suoto, eetuo batii bamba kafɔɔ alɛ babla ninkpo yi, abale otii finle di Yaa sɛka kalekɔ nwu nkpo kamɛ. ");
INSERT INTO snw_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nkpo oso kɔtɔkɔ ye klekle ntikiti nlɛ, fiɛ bibafuo ni Yaa sɛka kalekɔ nwu nkpo obuo yi, diediki biesiɛ nkpa tinini fɛ mmle okle di Yaa komiɛ nii, dielenkee kufiofa batuotɛ ku Farisi batii nle. ");
INSERT INTO snw_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Bitoonu, baatɔkɔ bakofo alɛ, ‘Bitanlo otii.’ Ni otii lele niɛbla nkpo yi, dikpe ni bɛɛkanko nwɔ. ");
INSERT INTO snw_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Kafɔɔ nunua yi, ami kɔtɔkɔ ye nlɛ, otii lele niɛnya ɔblɔ eekpeeko obilɛma yi, babakanko nwɔ. Otii lele kafɔɔ niɛtɔkɔ owo nɔɔ alɛ, ‘Faale otii kuonwii’ yi, baalɛɛ nwɔ kaakankɔ di banɔɔfo anu. Otii lele kafɔɔ nimatɔkɔ owo nɔɔ alɛ, ‘Buutɛ fale’ yi, Yaa mananfi nwɔ kootoko di kawɔɔ ɔtɔ dibiɔ nwu kamɛ. ");
INSERT INTO snw_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Nkpo oso nse fakle lɛtasaa falɛ fɔɔkyɛnko Yaa di Ole ɔta nɔɔ akyikye suoto feenyuma falɛ ɔlaa owo nsi di minko owo lɛfɔ ntɛɛ yi, ");
INSERT INTO snw_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","nfanwu diɛ lɛtasaa lɛfɔ nwu nkpo fatɛ di oleɔta akyikye nwu nkpo katũ, faasifi bilaakpete bawo ntu ku owo lɛfɔ nwu nkpo fiɛ faawa fabayɔ lɛtasaa lɛfɔ nwu nkpo fata Yaa ole. ");
INSERT INTO snw_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Nse otii owo alɛ ɔɔkpaa fɔ ankyɛnko kakankɔ yi, miɛ obe bielolaa bawo ntɛɛ fiɛ biɛlaabuo kakankɔ nwu nkpo. Nse diele nkpo fiɛ biɛkyɛ biɛlaabuo kakankɔ nwu nkpo yi, dibafuo ɔwa alɛ abayɔ fɔ ankpee di kantɛ nnɛɛ kamɛ, kantɛ kafɔɔ n-yɔ fɔ ankpee di bamufũtɛ nnɛɛ kamɛ, mantɛfɔ leeyo. ");
INSERT INTO snw_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nwaako kɔta fɔ fantofo nlɛ, nfa fɔɔwa ɔbasiɛ diɛlaase di obe wɔ fatɔɔta ni letokonanfi lɛfɔ koto yɛntɛle. ");
INSERT INTO snw_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Bienu bilɛ beebuɛ alɛ, ‘Bitankpee asɔnɔ.’ ");
INSERT INTO snw_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Kafɔɔ ami kɔtɔkɔ ye nlɛ, osuɔtɔ lele niɛnya ɔsanko eeklee nwɔ ɔkɔnsɔ kamaa, atookpee asɔnɔ ku nnwɔɔ kofokofoko di otu nɔɔ kamɛ. ");
INSERT INTO snw_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Nkpo oso nse koletanɛɛ ninu lɛfɔ kɔta fɔ faambla okpile yi, faadiki ni fayu. Diekye yi, nse suoto sina lɛfɔ lɛba lewo leyu yi, dilɛ dilenke alɛ baayɔ suoto sina lɛfɔ simuu manfuki mamkpee di kawɔɔ ɔtɔ dibiɔ nwu kamɛ. ");
INSERT INTO snw_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nkpo okle kafɔɔ nse koletanɛɛ lɛfɔ kɔta fɔ fambla okpile yi, faabudi kũ fayu. Diekye yi, nse suoto sina lɛfɔ lɛba lewo leyu yi, dilɛ dilenke alɛ baayɔ suoto sina lɛfɔ simuu manfuki mankpee di kawɔɔ ɔtɔ dibiɔ nwu kamɛ. ");
INSERT INTO snw_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Beebuɛ alɛ, ‘Osuɔtɔ lele nialɛ oosĩ ɔsɔfɔ nɔɔ yi, dikpe nii ɛɛtɔɔ kusinkũ.’ ");
INSERT INTO snw_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Kafɔɔ ami yi, kɔtɔkɔ ye nlɛ, nse osuɔtɔ owo lesĩ ɔsɔfɔ nɔɔ, dilanle asɔnɔ eekpee yi, ni atɔɔta ɔsɔfɔ nɔɔ nwu nkpo lekpee asɔnɔ. Osuɔtɔ lele kafɔɔ niɛyɔ ɔsanko nwu beesĩ ni yi, atookpee asɔnɔ. ");
INSERT INTO snw_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Bitoonu kafɔɔ alɛ, baatɔkɔ bakofo alɛ, ‘Tansĩ ntam be fɛɛka ni ɔbla. Kafɔɔ bibla di lɛsaa le suooto biɛka ntam biɛta ni Saate nwu.’ ");
INSERT INTO snw_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Kafɔɔ nunua yi, kɔtɔkɔ ye nlɛ bitansinka lɛsalɛsaa kuniwii nse biobuɛ bilɛ bibabla lɛsaa lewo. Bitanka di osi diekye nfa ninle Yaa lɛkakpomii nɛ. ");
INSERT INTO snw_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ee bitanka di kasɔ, diekye Yaa nkpaa kasekɔ kale. Bitanka kafɔɔ di Yerusalem, diekye nwu ninle baka Ɔka nwu okpoo kplɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Tanka bia disi lɛfɔ, diekye flabafuo disi onwini lɛfɔ onwii ɔbla kupu ee kuwɔfɔ. ");
INSERT INTO snw_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Bita yii lee dibla yii, biɛta oowo lee dibla oowo. Nle mmle kamaa, lɛsaa lele biekple biebuɛ kyiditɛ nwu nfũ diekye. ");
INSERT INTO snw_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Bienu beebuɛ alɛ, ‘Nse feebiɛ owo lɛfɔ ninu yi, afɔɔ baabiɛ fɔ lele. Nse fɛɛkpa owo lɛfɔ lɛnyɛɛ yi, afɔɔ baakpa fɔ lele.’ ");
INSERT INTO snw_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Kafɔɔ nunua yi, kɔtɔkɔ ye nlɛ, nse owo lee lɛbla ye okpile yi, bitambla nwɔ okpile nwu biakyisa. Nse otii owo lɛpɛ fɔ kɔnɛɛ kootokosi di oletanɛɛkyɛ yi, faamunikĩisa kɔmɛntu tokosi kafɔɔ faatɔɔ apɛ. ");
INSERT INTO snw_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Nse otii owo alɛ ɔkpaa fɔ ankyɛnko kakankɔ anfũ fɔ awu ya fankpee fantɛ ni kasɔ yi, faadiki osi ale kafɔɔ fatɔɔ. ");
INSERT INTO snw_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nse sientɛ owo lesiɛ fɔ di suoto alɛ, tuka nwɔ atoo lɛkɔ ninwii yi, afɔ faatuka akɔ anyɔ. ");
INSERT INTO snw_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Nse otii owo lɛkaalɛ fɔ lɛsaa yi, faatɔɔ. Nse otii owo kafɔɔ alɛ fɛnsa nwɔ lɛsaa yi, faafɛnsa nwɔ. ");
INSERT INTO snw_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Bienu beebuɛ alɛ, ‘Bibɔmbɔ basiɛwo lee, biekyidi balo lee!’ ");
INSERT INTO snw_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Kafɔɔ nunua yi, ami kɔtɔkɔ ye nlɛ, bibɔmbɔ balo lee, biɛpɛ ɔlaa bita batii ba nikɔkpɛko ye ni. ");
INSERT INTO snw_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ni bibakple Teeye wɔ ninkpe ni kaatoo babi. Diekye nnwɔɔ ninta kufĩ nɔɔ mpɛ kunta batii kpile ku babienetɛ kyɛkyɛ. Anta kafɔɔ kanto nɔɔ nnɔɔ anta batii ba ninte ni tinini ku mba ninante ni tinini kyɛkyɛ. ");
INSERT INTO snw_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Nse batii ba nimbɔmbɔ ye ni lete mimbɔmbɔ yi, ni letota nwaa kuniwii nnaa di Yaa mata ye nii. Diekye bia akpooto bafuntɛ kafɔɔ mmbla nkpo. ");
INSERT INTO snw_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Nse basiɛwo lee lete minsɛɛsa yi, ni biibla lɛsaa le ninlenke ni baapɛ ni sɛfa. Bia batii ba ninanle ni bafũbanutɛ kafɔɔ mmbla nkpo. ");
INSERT INTO snw_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Bile batii ba niewo ni niimu fɛ mmle okle di Teeye wɔ ninkpe ni kaatoo lewo ni niimu. ");
INSERT INTO snw_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Bilolaa binyu nwaa alɛ biɛbla sifutulɛ lee di lɛkpaka alɛ batii kanya. Nse biɛbla asaa ya mmle di lɛkpaka yi, ni letota kuninwii nnaa ye di Teeye nfũ di Yaa Kafa. ");
INSERT INTO snw_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Nkpo oso nse fɔɔta piitɛ owo lɛsaa yi, tanyie ni lɛkya faata batii latofo fɛ mmle di baalaatɛ mbla ni di bawo kalɛɛkɔ ku lɛkpaka. Mambla nkpo ta mmle baatii katansa ma ni oso. Kafɔɔ kɔtɛ nta ye letofo nlɛ batoofũ letota lɛma kaayi ka mmle kamɛ kofokofoko. ");
INSERT INTO snw_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Nkpo oso nse fɔɔkyakaako piitɛ owo yi, bla ni di osuku wɔ suoto di siɛwo lɛfɔ wɔ bia minko nwɔ minfe ni yi, dilaatofo lɛsaa le fɛɛbla ni. ");
INSERT INTO snw_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ni lɛsaa le fɛɛbla ni masiɛ di lewofa kamɛ. Ni Teefɔ wɔ kafɔɔ ninnya ni lɛsaa di lewofa kamɛ yi, matafɔ letota biene. ");
INSERT INTO snw_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Nse biɔpɛ ɔlaa minta Yaa yi, bitambla fɛ mmle baatii ba nimbla ni asaa di anu anu mbla nii. Mambɔmbɔ ɔtaka oyila di Yaa batii kasiisakɔ ku akpaka alɛ batii bamuu kanya ma alɛ bɔɔpɛ ɔlaa manta. Kɔtɔkɔ ye nlɛ batoofũ letota lɛma kofokofoko. ");
INSERT INTO snw_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nioso nse fɔɔpɛ ɔlaa fanta Yaa yi, faabuo leyo tenle lɛfɔ kamɛ, faasɛɛ, faapɛ ɔlaa fata Teefɔ wɔ manannya ni. Ni Teefɔ wɔ ninnya ni lɛsaa di kawofakɔ yi, abatafɔ letota biene. ");
INSERT INTO snw_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Ni nse fɔɔpɛ ɔlaa fanta Yaa yi, tambuɛ sɛlaa se ninanfĩ ni ninwii ku sɛnyɔ fɛ mmle di batii ba ninanfũ banu ni mbla nii. Diekye mannyu alɛ nse bɛɛpɛ ɔlaa bɛɛta afiɔ bɛɛklɛsa yi, ni annu nɛ. ");
INSERT INTO snw_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Bitante fɛ mma, diekye Teeye Yaa n-ye lɛsaa le niefĩ ye ni kofokofoko fiɛ bia biɔkaalɛ nwɔ nii. ");
INSERT INTO snw_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Nkpo oso nnya mmle okle dikpe ni biɛtɔɔpɛ ɔlaa biɛtɔɔta ni Yaa. Bilɛ, ‘Teewo wɔ ninkpe ni di osi, ta balɛɛ leyooto lɛfɔ klekle nwu ku dibu. ");
INSERT INTO snw_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Sɛka kalekɔ lɛfɔ diwa wo kaamɛ. Ta babla fɔ dibiesaa kaasɔ ka mmle suoto fɛ mmle dikpe ni di osi. ");
INSERT INTO snw_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ta wo miɛ alesaa ya niefĩ wo ni. ");
INSERT INTO snw_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Faayɔ sikpile loo fakye wo, fɛ mmle okle di awo kafɔɔ buɔyɔ buɔkyɛ ni batii ba niɛbla wo ni sikpile. ");
INSERT INTO snw_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Tankpaa wo faakpee di ɔsɔ onyu siene kamɛ, kafɔɔ dikiwo fakyeko kpiletɛ nnɛɛ kamɛ. Diekye lelefɔ ninle sɛka kalekɔ ku osie ku leklekle ninnaa ni kaloo.’ ");
INSERT INTO snw_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Diekye nse biɛyɔ bawo lee sikpile se bɛɛbla ye ni biɛkyɛ ma yi, ni Teeye wɔ ninkpe ni di osi kafɔɔ mayɔ sele ye se biɛɛbla ni, ankyɛ ye. ");
INSERT INTO snw_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Kafɔɔ nse biɛyɔ bikyɛ bawo lee yi, ni Teeye kafɔɔ dilabayɔ siele ye se biɛɛbla ni akyɛ ye.” ");
INSERT INTO snw_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Yesu latuo asaa alɛ, “Nse bionii kanya yi, bitankatu anu fɛ mmle di balaatɛ mbla nii. Diekye mankatu anu alɛ batii kanya mantɛ nsũ alɛ boonii kanya. Kɔtɛ nta ye mintofo bilɛ batoofũ letota lɛma kofokofoko. ");
INSERT INTO snw_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Nse bionii kanya yi, biefoto anu biɛflɛɛ disi, ");
INSERT INTO snw_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","mmle okle di batii dilabatofo alɛ bionii ni kanya. Diediki Teeye wɔ manannya ni lete nikatofo. Ni Teeye wɔ ninnya ni asaa ya biɔbla ni di kawofakɔ mata ye letota biene. ");
INSERT INTO snw_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Bitansiisa lɛsaawɛ biatɛ biata suoto di kasɔ ka mmle suoto. Diekye kaasɔ ka mmle suoto yi, kɔbɔkɔbii ku kɔsanka nkpe manlalaasa nya nii, bayu kafɔɔ nkpe bababuo man-yu nya nii. ");
INSERT INTO snw_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Kafɔɔ yi, bisiisa lɛsaawɛ lee bitɛ bita suoto di Yaa kafa. Nfa yi, kɔbɔkɔbii ku kɔsanka nnaa babalalaasa nya nii. Bayu kafɔɔ nnaa bababuo man-yu nya nii. ");
INSERT INTO snw_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Diekye nfũ di lɛsaawɛ lɛfɔ nte nii, nfa kafɔɔ di otu lɛfɔ nwɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Otii anu nte fɛ kandiɛ ɛɛta suoto sina. Nse anu nlɛ fɔ yi, afɔ otii suoto sina lɛfɔ simuu nkpa. ");
INSERT INTO snw_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Kafɔɔ nse anu diɛlɛ fɔ yi, suoto sina lɛfɔ simuu masiɛ di ditunu kamɛ. Nkpo oso nse lɛkpa le ninsi fɔ ni kaamɛ nle ditunu, ni dibatɛ ninwɔfɔ fɔ osie kanya. ");
INSERT INTO snw_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Otii kuonwii dilabafuo basaate banyɔ ɔkpɛ ɔbla. Diekye abasĩ onwii ambɔmbɔ onwii. Ee abakyɔɔ onwii kotoko, ansĩ onwii kotoko ɔkyɔɔ. Flɔbafuo Yaa ku lɛsaawɛ ɔkpɛ ɔbla ɔkpɔtɔɔsa. ");
INSERT INTO snw_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Nkpo oso kɔtɔkɔ ye nlɛ, bitantoobu diisi sikitii di nle biale minsiɛ ni nkpa ku nle bianyi ni ku nle biaklee ni sutoto nɛ. Binyu, sɛɛ nkpa diefũ kɔya dilenkee alesaa? Suoto sina kafɔɔ diefũ kɔya silenkee akleesaa? ");
INSERT INTO snw_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Binyu bakansiɛ ba nikɔflɛlɛtɛ mankyi ni, mánkpɛ kofe, mánfee alesaa kafɔɔ bakpee di akpa. Kafɔɔ Teeye wɔ ninkpe ni di osi konyu ma obe lele. Biefũ kɔya bilenkee bakansiɛ? ");
INSERT INTO snw_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Owe nimafuo dii ninwii ɔyɔ ɔkyakaa ninkpa nɔɔ suoto, nse eebu nkpa nɔɔ disi osie kanya? ");
INSERT INTO snw_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Nkpo oso bitambu diisi sikiitii di akleesaa lee suoto. Aye binyu mmle okle di atoto ya nin-yɛ ni di lepoo kamɛ nkpee ammuɔ ni. Mantaa oleteku ee baaloso abula baata suoto. ");
INSERT INTO snw_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Kafɔɔ kɔtɔkɔ ye nlɛ, bia Ɔka Salomo omu, di lɛsaawɛ nɔɔ nimuu kamɛ, atakpee awu alɛ onyu aawo lepoo kamɛ atoto kpeele ya mmle kaamɛ lɛma onwii. ");
INSERT INTO snw_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ni nse Yaa lekpe sɛfa se mmle okle ninkpe nkpa sekpeele miɛ, kɔɔsɛɛ babayɔ sĩ mankpe ni di ɔtɔ kamɛ sinfiɛ nii, ni Yaa nwu nkpo dilaanyuma ye ata ye akleesaa lee alenkee sɛfa nwu nkpo? Ofũ onu lee diɛpɔ. ");
INSERT INTO snw_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Nkpo oso yi, bitansimbu diisi sikitii biatoobuɛ bilɛ, ‘Fɛ bubawɛ lɛsaa munle? Ee munwɛ lɛsaa munnyi, ee munwɛ lɛsaa munklee?’ ");
INSERT INTO snw_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Asaa ya mmle suoto di batii ba ninanle ni bafũbanutɛ ntoobu diisi osie kanya nɛ. Teeye wɔ ninkpe ni di osi n-ye alɛ, asaa ya mmle amuu lefi ye. ");
INSERT INTO snw_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Kafɔɔ bita anu asɛɛ ye di Yaa Kafa Sɛka ɔkpɛ suoto alenkee di asaa amuu ɔbla kamɛ, biɛbla nwɔ dibiesaa. Ni Yaa mayɔ asaa amuu bule ankyakaa ye. ");
INSERT INTO snw_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Nkpo oso bitansimbu disi kpinwu di kɔsɛɛ ko nikɔwa ni suoto. Dii nwu nkpo nimmu mabu disi ninta suoto. Dinaa alɛ biɛyɔ atoo bamba biɛkyakaa di dii nwu nkpo ale suoto. ");
INSERT INTO snw_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Bitankanko batii, alɛ Yaa kafɔɔ dilaakanko ye. ");
INSERT INTO snw_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Diekye Yaa makanko ye fɛ mmle okle biɛkanko ni batii. Lɛklapoosaa le biɛyɔ biɛklapoosa biɛta ni bawo lee, nninwu ke di Yaa mayɔ anklapoosa anta ye nɛ. ");
INSERT INTO snw_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Lɛ diɛbla fɔɔnya diku biibii le ninsi ni di owo lɛfɔ ninu, kafɔɔ flɔɔnya kawosokuu ka ninsi fɔ ni leele kamɛ? ");
INSERT INTO snw_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Lɛ faatɔkɔ obilee falɛ, ‘Lekoto tɛɛ ndiki fɔ diku biibii nwu ninsi fɔ ni niinu kamɛ.’ Di obe wɔ di kawosokuu nsi ni di afɔ omu lɛfɔ ninu kamɛ? ");
INSERT INTO snw_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Afɔ laatɛ! Lekatũ fadiki kawosokuu ka ninsi ni niinu lɛfɔ kamɛ fiɛ, ni fabafuo ɔnya nwaa, fandiki diku biibii le ninsi ni di obilee ninu kamɛ. ");
INSERT INTO snw_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Bitan-yɔ lɛsaa le ninte ni klekle biafuki biatɛ di batii ba ninte ni fɛ baweewee anu. Diekye nse biɛbla nkpo ɔtaka babataka mammufũ ye manwee. Bitan-yɔ lɛsaa futu kafɔɔ biatɛ di batii ba ninte ni fɛ aplakuo anu bilɛ bate. Diekye nse biɛyɔ biɛtɛ ma, ɔnanafũ babananafũ ni mankpɔnɔnfɔsa. ");
INSERT INTO snw_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Bikaalɛ Yaa asaa, abayɔ anta ye. Biwolaa asaa, abata ye minnya. Bipɛ nwɔ kokloo kɔnɛɛ, abasɛkɛtɛ anta ye. ");
INSERT INTO snw_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Diekye otii lele niɛkaalɛ Yaa asaa, an-yɔ antɔɔ. Otii lele niewolaa, antɔɔ annya. Otii lele kafɔɔ niɛpɛ Yaa kokloo kɔnɛɛ, ansɛkɛtɛ antɔɔ. ");
INSERT INTO snw_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Obi Ote kuonwii nnaa abayɔ difuɔ anta ni obi nɔɔ nse ɛɛkaalɛ nwɔ bloblo. ");
INSERT INTO snw_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Nkpo kafɔɔ anan-yɔ kɔsaanwu aatɔɔ nse ɛɛkaalɛ nwɔ kakpaku nɛ. ");
INSERT INTO snw_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Bia aye ba ninle ni bakpileblatɛ yi, biye mmle okle biayɔ asaa biene minta ni babi lee. Ni lɛ oso nfɛ di Teeye wɔ ninkpe ni di osi ate ni klekle dilaayɔ asaa biene ata batii ba niɛkaalɛ nwɔ ni alenkee! ");
INSERT INTO snw_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Asaa ya biomiɛ bilɛ batii bamba babla bata ye ni yi, aye bibla nkpo okle bita ma. Nle mmle ninle Mose kufiofa ku Yaa ɔlaa babuɛtɛtɛ asaa ya bootuo ni kasɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Bife di kayoko ka ninle ni kabiibii kamɛ bibuo. Diekye nse biefe di kayoko ka niɛblɛfɛ ni kamɛ, biedu osuku wɔ niɛyɔɔ ni suoto yi, bibabuo di ɔtɔ wɔ ninwɔɔsa ni kamɛ. Nnwu suoto kafɔɔ di batii kpinwu nkyɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Kafɔɔ kayoko ka osuku ninte keesifi ni nkpa be ninnaa ni kaloo kamɛ yi, ote kate biibii, osuku ninwu kafɔɔ nte maamaa kukpe osie kafɔɔ kuɔkyɛ. Batii ba nintɔɔnya ni osuku nwu nkpo kafɔɔ baapɔ. ");
INSERT INTO snw_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Bilolaa binyu nwaa di balaatɛ ba niɛbla ni suoto fɛ Yaa ɔlaa bauɛtɛtɛ. Manwa ɔkyɛ lee fɛle bafoso ba niɛyɔɔ nii. Kafɔɔ nwaako di situ lɛma kamɛ yi, bakplɛle bale. ");
INSERT INTO snw_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Nkpa lɛma letembi bibayɔ minnya ma mintɛ nsũ. Akpofoe dilaafu akpaloo abi otika, nkpo kafɔɔ di kakɔtɔkɔtɔ kowoso dilaafuo kukutu abi otika nɛ. ");
INSERT INTO snw_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Nkpo kafɔɔ di kowoso biene ntika abi biene nɛ. Kowoso lalaale kafɔɔ ntika abi lalaale nɛ. ");
INSERT INTO snw_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kowoso biene nintika abi lalaale. Nkpo kafɔɔ di kowoso lalaale nintika abi biene nɛ. ");
INSERT INTO snw_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kowoso lele kafɔɔ ninantika abi biene yi, mambudi kũ man-yu, makpee kũ ɔtɔ. ");
INSERT INTO snw_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nkpo oso, asaa ya di balaatɛ ba niɛbla ni suoto fɛ Yaa ɔlaa babuɛtɛtɛ bale nii, letembi lɛma bibayɔ mintofo ma. ");
INSERT INTO snw_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Diele otii lele nikɔlɛɛ mi ni alɛ, ‘Saate, Saate,’ nimakyɛ Yaa kafa. Kafɔɔ batii ba niɛbla ni Teemi wɔ ninkpe ni di osi dibiesaa nimakyɛ nfa. ");
INSERT INTO snw_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Obebe di Yaa lɛkankoyi nwu lewo yi, batii kpinwu matɔkɔ mi alɛ, ‘Saate! Leeyooto lɛfɔ nwu kamɛ, ni buayie Yaa ɔlaa lɛkya, buatososa anwuna kpile nɛ. Ni buabla sɛkpɛ se niɛbla ni ɔkpɛ ate ate kafɔɔ di leyooto lɛfɔ nwu kamɛ nɛ.’ ");
INSERT INTO snw_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Nfa nfɛ matɔkɔ ma nlɛ, ‘Ninye ye kaakɔkaakɔ! Bikyɛ mi di ɔlɔɔkɔ bisifi aye batii kpile.’ ");
INSERT INTO snw_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Nkpo oso, otii lele nienu sɛlaa nii se mmle, ɛɛyɔ sĩ ɛɛblako ɔkpɛ yi, ate fɛ otii wɔ niebe ni anu eetofo ni leyo di difuɔnkpaa suoto. ");
INSERT INTO snw_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Kanto lanɔɔ, sekle layii, afɛɛfɔ kafɔɔ lafɛ osie kanya di leyo nwu suoto. Kafɔɔ ditabiɛ, diekye baatofo ni di difuɔnkpaa suoto. ");
INSERT INTO snw_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Kafɔɔ otii lele nienu sɛlaa nii se mmle, anan-yɔ sĩ ablako ɔkpɛ yi, ate fɛ otii wɔ niebuu nii, eetofo ni leyo di kɔtɛ suoto. ");
INSERT INTO snw_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Kanto lanɔɔ, sekle layii, afɛɛfɔ kafɔɔ lafɛ di leyo nwu suoto. Ni diabiɛ wududu diapɛ kaasɔ kɔkyɛɛkɔkyɛɛ nɛ.” ");
INSERT INTO snw_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Obe wɔ di Yesu laloo ni sɛlaa se mmle obuɛ yi, diabla batii dikukdi nwu nkpo yaa, di mmle okle aatuo ni asaa. ");
INSERT INTO snw_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Asaa nɔɔ otuo ditate fɛ mmle okle di kufiofa batuotɛ ntuo nii. Kafɔɔ aatuo asaa ku sɛkambi. ");
INSERT INTO snw_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Obe wɔ di Yesu lasoo aakye ni kabokotee nwu suoto yi, batii dikudi kplɛ ninwii latikanko nwɔ. ");
INSERT INTO snw_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ni di osuɔtɔ onwii niatoofiɛ ni ofiɛ sɛɛle lawa ɔkyɛ nɔɔ, abapɛ akunkyi kaatũ nɔɔ, aase katũ kaasɔ aabuɛ alɛ, “Saate! Nse dilɛ fɔ, faafuo ɔta suoto nii mbla klekle.” ");
INSERT INTO snw_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu ladiki kɔnɛɛ aakpanko nwɔ, aatɔkɔ nwɔ alɛ, “Letuna, suoto lɛfɔ siklekle!” Nfanwu, ofiɛ nwu layɔɔ osuɔtɔ nwu nkpo. ");
INSERT INTO snw_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ninfɛ di Yesu latɔkɔ nwɔ alɛ, “Lolaa fanyu nwaa, tambuɛ ɔlaa kuonwii faatɔkɔ otii kuonwii. Kafɔɔ tɔɔkyɛ falaayɔ suoto lɛfɔ fatuo Yaa Oletatɛ, faata oleɔta asaa ya di Mose kufiofa letuo ni. Nni nimadiki nintuo batii alɛ nwaako, ofiɛ nwu nkpo, ntɔɔyɔɔ fɔ nɛ.” ");
INSERT INTO snw_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Obe wɔ di Yesu labuo ni Kapernaum okpoo kamɛ yi, Roma batii bakpɛtɛ nɔɔfo onwii lawa ɔkyɛ nɔɔ abatikiti nwɔ lekoto aatɔkɔ nwɔ alɛ, ");
INSERT INTO snw_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Saate! Kpɛmblatɛ nii kofiɛ osie kanya ate leeyo diobuo nwɔ alɛ, oloofuo bia ɔtaka.” ");
INSERT INTO snw_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu latɔkɔ nwɔ alɛ, “Mawa mayɔɔsa nwɔ ofiɛ.” ");
INSERT INTO snw_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ni baakpɛtɛ nɔɔfo nwu nkpo ladiki kanya alɛ, “Oowo, Saate! Ninsiɛko alɛ faawa mi leyo. Kafɔɔ afɔ yi, buɛ ɔlaa onwii lete, kpɛmblatɛ nii nwu nkpo mawɛ difiɛyɔɔ. ");
INSERT INTO snw_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Diekye ami kafɔɔ nle otii wɔ ninsi ni di banɔɔfo bawo kalɔ, ni di bakpɛtɛ bawo kafɔɔ nsi mi kaalɔ nɛ. Nse lɛtɔkɔ owo nlɛ, ‘Atɔɔkyɛ’ yi, ansifi. Nkpo kafɔɔ nse lɛtɔkɔ owo nlɛ, ‘Awa’ yi, anwa nɛ. Nse lɛtɔkɔ ɔlanle nii nlɛ, ‘Abla lɛsaa’ le, ni ambla nɛ.” ");
INSERT INTO snw_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Obe wɔ di Yesu lanu ni sɛlaa se mmle diabla nwɔ ɔkpɛ, ni aatɔkɔ batii ba niatikanko nwɔ ni alɛ, “Nwaako kɔtɔkɔ ye nlɛ, ninnya otii kuonwii di Israel batii kamɛ ninkpe ni ofũ onu kplɛ wɔ mmle okle. ");
INSERT INTO snw_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nwaako kɔtɔkɔ ye nlɛ, batii kpinwu makye kufĩ katunkɔ ku kufĩ kamɛɛkɔ manwa mamasiɛ di opunu katũ ku Abraham ku Isak ku Yakob, di Yaa kafa sɛka kalekɔ nwu kamɛ. ");
INSERT INTO snw_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Kafɔɔ Yaa mayɔ Yuda batii ba di Yaa sɛka kalekɔ nwu nkpo nle ni kale an-yu di ditunu kamɛ. Nfa babawi kaku manwee anyɛɛ nɛ.” ");
INSERT INTO snw_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ninfɛ di Yesu latɔkɔ bakpɛtɛ nɔɔfo nwu alɛ, “Tɔɔkyɛ leyo. Fɛ mmle okle feefũ feenu nii, dibawa kaanya ninta fɔ nkpo.” Nfanwu, ofiɛ layɔɔ bakpɛtɛ nɔɔfo nwu nkpo kpɛmblatɛ. ");
INSERT INTO snw_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu lakyɛ Petro leyo. Ni aalaanya Petro ɔmaato nte di ɔkla suoto ofiɛ lɛwɔɔfɔ ofiɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ninfɛ di Yesu lakyɛ aalaamufũ nwɔ di kɔnɛɛ nɛ. Nfanwu ofiɛ nwu nkpo layɔɔ nwɔ ni aataka aafũ nwɔ kɔfɔɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Di kɔtɔɔfɔ lawo nii, baakpaa batii kpinwu di anwuna kpile nsi ni baawako Yesu nfũ. Ni di Yesu latososa anwuna kpile nwu nkpo aadiki ma kaamɛ ku ɔlaa onwii obuɛ. Ni aayɔɔsa mba niatoofiɛ ni bamuu sifiɛ ninfa nɛ. ");
INSERT INTO snw_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Aabla nle mmle alɛ, ɔlaa wɔ di Yaa Ɔlaa Buɛtɛtɛ Yesaia labuɛ aatɛ ni kawa kaanya. Alɛ, “Nnwɔɔ omu nɔɔ eefũ wo suoto dibuo, eekpee disi kafɔɔ di sifiɛ loo simuu kalɔ.” ");
INSERT INTO snw_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Obe wɔ di Yesu lanya batii dikudi le kpinwu niamana nwɔ beekyi nwɔ nii yi, ni aatɔkɔ basaateketetɛ nɔɔ alɛ, “Bita butaalɛ busifi lekpo le mmle sɛmaa.” ");
INSERT INTO snw_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Nfanwu ni di kufiofa asaa tuotɛ onwii lawa nwɔ ɔkyɛ nɛ. Ni aabatɔkɔ nwɔ alɛ, “Saatuotɛ, kakɔ lele fabakyɛ, matikanko fɔ.” ");
INSERT INTO snw_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ninfɛ di Yesu latɔkɔ nwɔ alɛ, “Nkpikiti nkpe atuɛ ya kamɛ mansiɛ nii, bakansiɛ nkpe ayo mante nii. Kafɔɔ ami, Otii Obi, nnaa lɛba katɛ ni disi.” ");
INSERT INTO snw_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Osuɔtɔ bamba ninle ni basaateketetɛ nɔɔ onwii labuɛ alɛ, “Saate, tɛɛnkyɛ ninakookaa teemi fiɛ.” ");
INSERT INTO snw_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ninfɛ di Yesu ladiki kanya alɛ, “Tikankoe. Faadiɛ batii ba ninte ni fɛle bakpi, baakookaa mma bamu bakpi lɛma.” ");
INSERT INTO snw_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesu labuo di oklo onwii kamɛ, ni di basaateketetɛ nɔɔ kafɔɔ layie baabuo nɛ. Obe wɔ nfɛ bakyɛ nii, ");
INSERT INTO snw_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","nfanwu, kɔfɛɛfɔ siene kunwii niakyako ɔkpɛ di lekpo nwu suoto. Kuatɔɔpɛ ntu kuatookpete di oklo nwu kamɛ, kuamiɛ alɛ kuɔmɛɛ. Kafɔɔ di obe nwu kamɛ, Yesu late aatɔɔkyɔsĩi. ");
INSERT INTO snw_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Basaateketetɛ nwu nkpo lakyɛ baalaasɛnkɛsa nwɔ, ni baatɔkɔ nwɔ alɛ, “Saate, diki wo! Nfɛ buookpi lo!” ");
INSERT INTO snw_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ninfɛ di Yesu latɔkɔ ma alɛ, “Be oso biɔyɛkɛ nkpo? Ofũ onu lee diɛpɔ.” Nfanwu, Yesu lataka ni aamuɛ kɔfɛɛfɔ ku ntu nwu ninkɔkpɛ ni alɛ, “Diɛɔfɛ faate kloklo.” Ninfɛ dialo kanana nɛ. ");
INSERT INTO snw_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Diabla obiala lɛma yaaa. Ni baakaalɛ suoto lɛma alɛ, “Ɔmɛntii okle ninle nwɔ mmle di kɔfɛɛfɔ ku ntu be ninkɔkpɛ ni nnu nwɔ ɔlaa?” ");
INSERT INTO snw_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Obe wɔ di Yesu labuo Gadara kasɔ suoto leekpo nwu nkpo kakyɛ nyɔɔfa, batii banyɔ banwii di anwuna kple kɔkpɛko ni ladie baakye batii kakookaakɔ baawa babakyakako nwɔ. Baatii nwu nkpo lawɛ ni kobe osie kanya oso, otii kuonwii ninsinfuo ofe di osuku nwu nkpo suoto. ");
INSERT INTO snw_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Nfanwu ni baafaa osie kanya baabuɛ alɛ, “Afɔ Yaa Obi, be ninsi di awo ku afɔ ntɛɛ? Ole fatoole katũ fɛɛwa falɛ fɔɔbananfi wo kootoko fiɛ di obe wɔ di Yaa lɛtɛ ni nwo?” ");
INSERT INTO snw_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Aplakuo ɔlambu kplɛ onwii latoole alesaa di ntɛɛ nwu. ");
INSERT INTO snw_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Nioso anwuna kpile nwu latikiti Yesu lekoto alɛ, “Nse fabatososa wo fandiki yi, ni faatososa wo fakpee di aplakuo ɔlambo kplɛ nwu nkpo kamɛ.” ");
INSERT INTO snw_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ninfɛ di Yesu ladiki kanya aatɔkɔ nya alɛ, “Bitɔɔkyɛ nya kamɛ.” Ninfɛ aadie ma kaamɛ aasifi aplakuo nwu nkpo kamɛ nɛ. Ninfɛ di aplakuo ɔlambo nwu nkpo latoso kitikiti baakye kobokotee nwu nkpo ɔlɔɔkɔ baalaabuo di lekpo nwu kamɛ baamɛ ntu baakpi nɛ. ");
INSERT INTO snw_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Nioso aplakuo nwu bakpatɛ latoso baasifi okpoo baalaabuɛ lɛsaa le niawa ni di basuɔtɔ ba kamɛ di anwuna kpile nwu lasiɛ ni ku aplakuo nwu suoto baatɔkɔ batii. ");
INSERT INTO snw_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Nkpo oso okpoo nwu nkpo batii bamuu ladie baakyɛ alɛ bɔɔlaakyakako Yesu. Obe wɔ baakyakako nwɔ nii, baatikiti nwɔ lekoto alɛ adie ma kaasɔ suoto. ");
INSERT INTO snw_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu labuo di oklo nwu nkpo kamɛ aakple aataalɛ lekpo nwu nkpo aasifi okpoo nɔɔ. ");
INSERT INTO snw_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ninfɛ baakpaa osuɔtɔ onwii niafefee aate ni di ɔkla suoto baawako ɔkyɛ nɔɔ nɛ. Obe wɔ di Yesu lanya ni ofũ onu lɛma yi, ni aatɔkɔ osuɔtɔ nwu niafefee aate ni alɛ, “Obi nii, ta otu kute fɔ. Ntɔɔyɔ sikpile lɛfɔ lɛkyɛ fɔ.” ");
INSERT INTO snw_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Kufiofa batuotɛ bawo lawɛ ninfa, ni baabuɛ baatɔkɔ suoto alɛ, “Otii wɔ mmle kobuɛ mbusuo ɔlaa lo!” ");
INSERT INTO snw_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu latofo disibu lɛma nwu nkpo, ninfɛ aakaalɛ ma alɛ, “Be oso biobu disi kpile le mmle okle? ");
INSERT INTO snw_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Sɛlaa se mmle, lɛmɛnle niɛyɔɔ kuobuɛ? Alɛ, ‘Bɛɛyɔ sikpile lɛfɔ bɛɛkyɛ fɔ’ ɛɛ sɛɛ baabuɛ alɛ, ‘Taka faakyɛ’? ");
INSERT INTO snw_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Kamadiki ntuo ye nlɛ, ami, Otii Obi nwu, nkpe osie kaayi ka mmle alɛ kayɔ okpile nkyɛ.” Nkpo oso aatɔkɔ otii nwu niafefee aate ni kaasɔ alɛ, “Taka fayila, faayɔ ɔkla lɛfɔ, faatɔɔkyɛ leyo.” ");
INSERT INTO snw_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Osuɔtɔ nwu nkpo niataka, ni aayɔ ɔkla nɔɔ, aasifi leyo nɛ. ");
INSERT INTO snw_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Obe wɔ baatii lanya ni nle mmle yi, lɛyɛkɛ lamufũ ma, ni baatansa Yaa alɛ ɛɛyɔ osie wɔ mmle okle ɛɛta batii nɛ. ");
INSERT INTO snw_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu ladie ninfa aasifi. Obe wɔ akyɛ oosifi nii, ni aanya akpooto funtɛ onwii baatɔɔlɛɛ ni Mateo lasiɛ di akpooto kafunkɔ nɛ. Ni aatɔkɔ nwɔ alɛ, “Tikankoe!” Nfanwu, ni di Mateo lataka aatikanko nwɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Obe wɔ di Yesu latoole ni alesaa di Mateo leyo yi, akpooto bafuntɛ kpinwu ku bakpileblatɛ bawo lawa nfa baakyakaa di Yesu ku basaateketetɛ nɔɔ di alesaa nwu kalekɔ. ");
INSERT INTO snw_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Di Farisi batii bawo lanya ni nle mmle, ni baakaalɛ basaateketetɛ nɔɔ alɛ, “Obe oso di saatuotɛ lee kole alesaa ku akpooto bafuntɛ ku bakpileblatɛ bamba ba mmle?” ");
INSERT INTO snw_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu lanu ɔlaa wɔ baatoobuɛ nii, ni aadiki kanya alɛ, “Fablatɛ diefĩ batii ba ninoofiɛ nii, bafiɛtɛ di fablatɛ lefĩ. ");
INSERT INTO snw_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Bitɔɔkyɛ biɛlaawolaa lɛsaa le di Kɔkpana Klekle Kukũ kamɛ kotuo ni alɛ, ‘Sifutulɛ di Yaa komiɛ, diele babɔkɛɛ ɔyɔ ɔta ole.’ Ninwa babienetɛ ɔlɛɛ, bakpiletɛ oso lɛwa.” ");
INSERT INTO snw_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Di n-ya mmle sɛmaa, Ntu Kpeesatɛ Yohane batikankotɛ nɔɔ lawa Yesu nfũ babakaalɛ nwɔ alɛ, “Obe oso fiɛ di awo ku Farisi batii munnii ni kanya obe obe, fiɛ di basaateketetɛ lefɔ mma mánnii kanya?” ");
INSERT INTO snw_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ni di Yesu ladiki kanya alɛ, “Biefũ bienu bilɛ batii ba bɛɛlɛɛ bɛɛwako ni ɔsanko kayɔkɔ kawi sɛnyaami di obe wɔ di ɔsanko nwu nkpo ɔsa nsi ma ni kaamɛ? Oowo, dilabawa nkpo diidii! Kafɔɔ obe owo kɔwa babakpaa ɔsanko nwu nkpo ɔsa mansifiko nii. Di obe nwu nkpo kamɛ yi, babanii kanya. ");
INSERT INTO snw_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Otii kuonwii nin-yɔ dibula fɔle kakyɛɛ aakaa aatĩi dibula kofole kabɛkɔ. Diekye dibula fɔle nwu nkpo matuniisa lekofole nwu nkpo ninta alɛ, lekofole nwu nkpo mbɛ ninkyakaa. ");
INSERT INTO snw_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","“Nkpo okle kafɔɔ di otii kuonwii nin-yɔ nta fɔle aakpete di kɔbɔkɛɛkũ kofole kamɛ nɛ. Diekye nse bɛɛyɔ beekpete yi, kɔbɔkɛɛkũ nwu nkpo mabɛ nta nwu nkpo nwii, kɔbɔkɛɛkũ nwu nkpo kafɔɔ nlalaa. Nkpo oso kɔbɔkɛɛkũ fɔle kamɛ man-yɔ nta fɔle mankpete. Ni dibata alɛ nta nwu ku kɔbɔkɛɛkũ nwu nkpo dilabalala.” ");
INSERT INTO snw_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Di obe wɔ di Yesu latɔɔkakatɛko ma ni yi, Yuda batii kasiisakɔ ɔnɔɔfo onwii lawa ɔkyɛ nɔɔ, abapɛ akunkyi di katũ nɔɔ aabuɛ alɛ, “Obi sankobi nii ntookpi nunua, kafɔɔ wa fabatika nwɔ kɔnɛɛ di suoto, aakple awɛ nkpa.” ");
INSERT INTO snw_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Nkpo oso Yesu lataka aatikanko nwɔ, ni di basaateketetɛ nɔɔ kafɔɔ latikanko nwɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Obe wɔ di Yesu latoofe nii, ɔsanko onwii di asaa latoowii ni lefosi alɛɛ anyɔ lafe di Yesu sɛmaa aakpanko nwɔ awu kotokosi. ");
INSERT INTO snw_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ɔsanko nwu labla nkpo diekye aafũ aanu alɛ, “Nse lɛnya lɛkpanko nwɔ awu kamaa, ofiɛ nwu nkpo mayɔɔ mi.” ");
INSERT INTO snw_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesu lamunikĩi aanyu ɔsanko nwu nkpo ni aatɔkɔ nwɔ alɛ, “Obi nii, nya otu! Ofũ onu lɛfɔ ntɔɔyɔɔsa fɔ ofiɛ.” Nfanwu ni di ofiɛ nwu nkpo layɔɔ nwɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Nni kamaa, Yesu lasifi ɔnɔɔfo nwu nkpo leyo. Ni aanya kaku sinu bakpeetɛ ku mba nikowi kaku ku kudu nɛ. ");
INSERT INTO snw_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ni aatɔkɔ ma alɛ, “Otii biala adie kayi. Diekye ɔsankobi nwu nkpo diekpi, kafɔɔ ɔkyɔsĩi ɔɔkyɔsĩi.” Ninfɛ baatii nwu nkpo bamuu lɛma, baama nwɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Di obe wɔ baatososa batii nwu nkpo bamuu baadiki ni leeyo yi, Yesu labuo ɔsankobi nwu nkpo leyo kamɛ. Ni aamufũ nwɔ kɔɔnɛɛ, ni aasɛnkɛ aasiɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ɔlaa wɔ mmle lakpɛ kuakyaka kasɔ nwu nkpo aba aba. ");
INSERT INTO snw_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Obe wɔ di Yesu ladie ninfa oosifi nii, banumbiɛtɛ banyɔ banwii lataka baatikanko nwɔ, baatooyiisa kudu baatoobuɛ alɛ, “Ɔka Dawid Obi ee! Nya wo nyaami.” ");
INSERT INTO snw_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Obe wɔ di Yesu labuo ni leyo kamɛ yi, banumbiɛtɛ banyɔ nwu nkpo lawa ɔkyɛ nɔɔ, ni aakaalɛ ma alɛ, “Biefũ bienu bilɛ mafuo ye anu otikiti?” Ninfɛ baadiki kanya alɛ, “Yii, buofũ buonu.” ");
INSERT INTO snw_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ninfɛ di Yesu lakpanko ma anu, aatɔkɔ ma alɛ, “Diwa kaanya dita ye fɛ mmle biefũ bienu ni.” ");
INSERT INTO snw_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Nfanwu anu lɛma niatikiti. Ninfɛ di Yesu lakpee ma kufiofa osie kanya alɛ, “Bitambuɛ nle mmle biatɔkɔ otii kuonwii.” ");
INSERT INTO snw_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Kafɔɔ baadie ni ninfa yi, baasifi baalaayie ɔlaa wɔ mmle lɛkya di Yesu suoto baakyakasa ntɛɛ nwu nkpo kasɔ fɛɛ. ");
INSERT INTO snw_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Di obe wɔ baasuɔtɔ nwu nkpo latoosifi nii, batii banwii lakpaa omumu onwii di ninwuna kpile lasiɛ nii baawako Yesu nfũ. ");
INSERT INTO snw_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ni di Yesu latososa ninwuna kpile nwu nkpo aadiki di omumu nwu kamɛ nɛ. Nfanwu ni aakyako ɔtɔɔkakatɛ nɛ. Lɛsaa le mmle labla batii ba bamuu niayila ni ninfa yaaa, ni baabuɛ alɛ, “Buunya nle mmle okle di Israel kasɔ suoto bunya!” ");
INSERT INTO snw_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Kafɔɔ Farisi batii labuɛ alɛ, “Anwuna kpile ɔka niɛtɔɔ osie nwu akle ootososa anwuna kpile andiki.” ");
INSERT INTO snw_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu lakyɛ aakyi sekpoo ku nkpayotũ mmuu kamɛ. Aatuo asaa di Yuda batii nsiisakɔ. Aayie ɔlaa biene nwu lɛkya di Yaa sɛka kalekɔ suoto. Ni aayɔɔsa batii ba niatoofiɛ ni sifiɛ ate ate sifiɛ fɛɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Di obe wɔ aanya ni batii dikudi nwu nkpo yi, ɔlaa lɛma lanu nwɔ kafutu, diekye ditoobuo ma, banaa kyakaakotɛ kafɔɔ. Bate fɛ bafoso ba ninnaa ni kpatɛ. ");
INSERT INTO snw_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Nkpo oso aamunikĩi aatɔkɔ basaateketetɛ nɔɔ alɛ, “Ofiɛɛlɛ nwu mpɔ, kafɔɔ bafiɛlɛtɛ diɛpɔ. ");
INSERT INTO snw_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Nkpo oso bipɛ ɔlaa bita Saate nwu nimba ni ofiɛlɛ nwu nkpo bilɛ, aakyesee bafiɛlɛtɛ mamakyakaako di ofiɛlɛ nwu nkpo kamɛ mansiisa.” ");
INSERT INTO snw_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu lalɛɛ basaateketetɛ nɔɔ lefosi banyɔ nwu nkpo aasiisa ni aata ma osie alɛ baatososa anwuna kpile mandiki baatii kamɛ, manyɔɔsa sifiɛ ate ate kafɔɔ. ");
INSERT INTO snw_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Batɔkyɛntɛ nwu nkpo lefosi banyɔ nwu ayooto ninle n-ya mmle nɛ. Ɔkasale ninle Simon, nwɔ mankple manlɛɛ ni Petro, ku obilɛma Andrea, Yakobo ku obilɛma Yohane ba ninle ni Sebedeo babi ");
INSERT INTO snw_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ku Filipo ku Bartolomeo ku Toma ku akpooto funtɛ Mateo ku Yakobo wɔ ninle Alfeo obi ku Tadeo ");
INSERT INTO snw_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ku Simon wɔ niabɔmbɔ ni kale nɔɔ osie kanya ku Yuda Iskariot wɔ niadiki Yesu aata nii. ");
INSERT INTO snw_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu lakpee basuɔtɔ lefosi banyɔ ba mmle kɔtɔ ku kufiofa ko mmle alɛ, “Bitankyɛ batii ba ninanle ni Yuda batii kasɔ ku Samaria batii okpoo kuonwii kafɔɔ kamɛ. ");
INSERT INTO snw_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Kafɔɔ bitɔɔkyɛ Israel batii ba ninte ni fɛ bafoso ba nintooyu ni nfũ. ");
INSERT INTO snw_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Bitɔɔkyɛ biɛlaayie lɛkya bilɛ, ‘Yaa sɛka olebee nwu ntɔɔtɛɛtɛɛ.’ ");
INSERT INTO snw_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Biyɔɔsa bafiɛtɛ sifiɛ, biɛsɛnkɛsa bakpi. Biyɔɔsa batii ba ninkofiɛ ni ofiɛ sɛɛle sifiɛ, bietososa anwuna kpile kafɔɔ bidiki baatii kamɛ. Diele koto biɛta biɛya nle mmle biekyeko ɔkyɛ nii. Nkpo oso ayee biyɔ bita di koto ɔtanfũ kamɛ. ");
INSERT INTO snw_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Bitan-yɔ koto kukunwii biaklee di atofo lee kamɛ. ");
INSERT INTO snw_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Bitan-yɔ asaa ɔkaalɛ kotofo biaklee di osuku lee nwu ɔkyɛ kamɛ. Bitanklee awu nyɔɔfa, ee biaklee ntokota ee ɔkyɛnwoso kuonwii. Kpɛmblatɛ biala yi, nfũ ɔɔbla ni ɔkpɛ anle. ");
INSERT INTO snw_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Nse biebuo okpoo owo ee kakpaayotũ kawo kamɛ yi, biemiɛ otii biene wɔ nietuna alɛ oofũ ye ni. Biɛkyɛ bilaasiɛ di ɔkyɛ nɔɔ, dilaase di obe wɔ biedie ni ninfa. ");
INSERT INTO snw_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nse biebuo leyo lewo kamɛ yi, biɛsɛɛsa ma bilɛ, ‘Atoko ɔkyɛ ole ninle ye lele.’ ");
INSERT INTO snw_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nse leyo nwu nkpo batii letuna beefũ ye, ni biɛta atoko ɔkyɛ ole lee lɛsɛɛsa dite ninfa. Kafɔɔ nse baatuna bafũ ye, ni biɛta atoko ɔkyɛ ole lee nwu nkpo lɛsɛɛsa dikple diwa ɔkyɛ lee. ");
INSERT INTO snw_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Nse leyo lewo ee okpoo owo batii diefũ ye ee bakyɔɔ ye ɔlaa kotoko yi, bidie ninfa bisifi, biɛfɛntɛ nkpaasɔ lee kɔtɛ bitɛ ma. ");
INSERT INTO snw_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nwaako kɔtɔkɔ ye nlɛ, di lɛkakoyi nwu nkpo suoto, Yaa manya Sodom ku Gomora batii nyaami anlenkee okpoo nwu nkpo batii. ");
INSERT INTO snw_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Binu! Kokyesee ye fɛ bafoso di bakplɛle kamɛ. Nkpo oso bibe anu fɛ kɔsaanwu, kafɔɔ biɛbla buɛɛ fɛ ablonumaa. ");
INSERT INTO snw_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Bilolaa binyu, diekye batii madiki ye manta, mankpaa ye mankyɛnko kakankɔ. Babapɛ ye kafɔɔ di Yuda batii nsiisakɔ. ");
INSERT INTO snw_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ta ami oso, babakpaa ye mankyɛnko batunletɛ ku baka anu manaakanko ye. Ni biɛtɔkɔ ma ɔlaa biene nwu ku mba ninanle ni Yuda batii. ");
INSERT INTO snw_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nse bɛɛkpaa ye bɛɛkyɛnko kakankɔ yi, bitambu diisi di ɔlaa wɔ bibabuɛ ni suoto, ku mmle bibabuɛ nwu nii. Nse obe lewo alɛ biakakatɛ yi, Yaa omu mata ye ɔlaa wɔ biabuɛ nii. ");
INSERT INTO snw_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Diekye diele aye bamu nimakakatɛ. Teeye wɔ ninle ni Yaa Ninwuna nimakakatɛ ninfenko di suoto lee. ");
INSERT INTO snw_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Batii mayɔ babi lɛma manta alɛ balo. Balofotɛ kafɔɔ mabla nkpo di babilɛma suoto. Babi mataka di balofotɛ lɛma suoto alɛ balo ma. ");
INSERT INTO snw_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Otii biala makyidi ye ta ami oso. Kafɔɔ otii wɔ niekpee otu ɛɛlaase ni kaayɛntɛkɔ, Yaa matɔɔ nkpa. ");
INSERT INTO snw_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nse beetikanko ye di okpoo onwii kamɛ yi, bietoso bisifi ɔbamba kamɛ. Nwaako kɔtɔkɔ ye nlɛ bilabaloo sɛkpɛ lee ɔbla di Israel sekpoo simuu kamɛ fiɛ di ami, Otii Obi nwu, makple anwa. ");
INSERT INTO snw_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Saateketetɛ ninlenkee saatuotɛ nɔɔ, nkpo kafɔɔ di ɔlanle ninlenkee saate nɔɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Nkpo oso, saateketetɛ biala kamiɛ alɛ aate fɛ saatuotɛ nɔɔ. Nkpo okle kafɔɔ di ɔlanle kamiɛ alɛ, aate fɛ saate nɔɔ nɛ. Nse bɛɛlɛɛ leyo lewo ɔnɔɔfo alɛ anwuna kpile ɔka mɔ, ni blɔbalɛɛ leyo nwu kamɛ batii kafɔɔ ayooto kpile? ");
INSERT INTO snw_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Nkpo oso bitanyɛkɛ batii, diekye lɛsaa lele bɛɛyɔ lɛsaa beetĩi ee bɛɛbla beekookaa yi, Yaa madiki ni kayi. ");
INSERT INTO snw_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Lɛsaa lele kafɔɔ bienu biekyeko ɔkyɛ nii diitunu kamɛ yi, bidiki ni kayi. Lɛsaa lele kafɔɔ lɛtɔkɔ ye di kawofakɔ yi, biyie ni lɛkya di lɛkpaka. ");
INSERT INTO snw_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Bitanyɛkɛ batii ba ninlo ni suoto sina, kafɔɔ mananfuo ni ninwuna olo. Kafɔɔ biyɛkɛ Yaa wɔ ninfuo ni otii suoto sina ku ninwuna ɔwɔɔsa di kawɔɔ ɔtɔ kamɛ. ");
INSERT INTO snw_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Kaplɛ kanwii kafuo bia kutĩitĩi kɔnyɔ ɔya. Kafɔɔ kukanwii ninkpa kaapɛ kaasɔ alɛ, Teeye Yaa dieye nwu ole. ");
INSERT INTO snw_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Aye yi, bia disi lee sinwini yi, Yaa n-ye sĩ lɛpɔ. ");
INSERT INTO snw_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Nkpo oso yi, bitanyɛkɛ. Diekye biefũ kɔya bilenke kutĩitĩi kpinkidi. ");
INSERT INTO snw_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Otii lele niediki eebuɛ di batii anu alɛ, ole mi ale yi, amii madiki nwɔ kanya di Teemi anu di Yaa kafa nlɛ ole mi ale. ");
INSERT INTO snw_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Kafɔɔ nse otii owo lesĩ mi di batii anu alɛ aaye mi yi, ami, masĩ nwɔ di Teemi anu di osi nlɛ ninye nwɔ. ");
INSERT INTO snw_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Bitanyu bilɛ atoko ɔkyɛ ole lɛyɔ lɛwako kanyi ka mmle. Oowo! Ninwako atoko ɔkyɛ ole. Kafɔɔ kapamii lɛwako. ");
INSERT INTO snw_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Diekye lɛwa le lɛwa ni mata alɛ, ‘obi suɔtɔbi mataka anyila di ote suoto. Obi sankobi kafɔɔ mataka anyila di ɔya suoto. Ɔsanko kafɔɔ mataka anyila di ɔsa nɔɔ ɔya suoto. ");
INSERT INTO snw_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Otii lo nɔɔ kasale yi, abakye di nnwɔɔ omu nɔɔ leyo nɔɔ kamɛ.’ ");
INSERT INTO snw_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Otii lele niɛbɔmbɔ ote ee ɔya eelenkee mi yi, alaafuo mi saateketetɛ ole. Olele kafɔɔ niɛbɔmbɔ obi suɔtɔbi ee obi sankobi eelenkee mi yi, aasiɛko alɛ aale mi saateketetɛ. ");
INSERT INTO snw_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Otii lele ninan-yɔ atoo nɔɔ atuka, atikanko nnafukpaa nii yi, aasiɛko alɛ aale mi saateketetɛ. ");
INSERT INTO snw_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Otii lele niemiɛ alɛ ɔɔta nkpa nɔɔ yi, abayu mi. Kafɔɔ olele nieyu nkpa nɔɔ ta ami oso yi, abawɛ mi. ");
INSERT INTO snw_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Otii lele niefũ ye yi, ami eefũ. Otii lele kafɔɔ neifũ mi yi, ni eefũ Yaa wɔ niekpee mi ni kɔtɔ kafɔɔ. ");
INSERT INTO snw_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Otii lele niefũ Yaa Ɔlaa Buɛtɛtɛ alɛ Yaa ɔlaa buɛtɛ ale ni oso yi, abawɛ dibia di Yaa ɔlaa buɛtɛ nwu letota kamɛ ankyeko Yaa nfũ. Otii lele kafɔɔ niefũ otii wɔ ninte ni tinini, ta tininitɛ ale ni oso yi, abawɛ dibia di tinintɛ nwu nkpo letota kamɛ ankyeko Yaa nfũ. ");
INSERT INTO snw_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Bitofo nle mmle nwaa bilɛ, otii lele niekusii ntu yɔɔle kakɔkɔɛ kanwii ɛɛta batikankotɛ nii ba mmle ɔyɛntɛle kaamɛ lɛma ta ami oso, Yaa dilabasĩ nwɔ letota biene ɔta.” ");
INSERT INTO snw_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Obe wɔ di Yesu laloo ni batɔkyɛntɛ lefosi banyɔ nwu kufiofa okpee yi, aadie ninifa aasifi aalaatootuo asaa aatooyie ɔlaa nwu lɛkya di sekpoo se niɛtɛɛtɛɛ ni nfa. ");
INSERT INTO snw_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Obe wɔ di Ntu Kpeesatɛ Yohane lanu di leyo katenkɔ asaa ya di Kristo latɔɔbla ni yi, ni aakpee basaateketetɛ nɔɔ bawo baakyɛ Yesu nfũ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ni balaakaalɛ nwɔ alɛ, “Afɔ ninle otii wɔ di Yaa labuɛ aatɛ alɛ fabawa ni ɛɛ, sɛɛ buatoonyu osuku munta otii bamba?” ");
INSERT INTO snw_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ninfɛ di Yesu ladiki kanya alɛ, “Bikple biɛlaatɔkɔ Yohane asaa ya biɛnya ni ku n-ya bienu bilɛ lɛbla ni. ");
INSERT INTO snw_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Banumbiɛtɛ nfɛ kɔnya asaa, abafa nfɛ kɔtaka mankyɛ, batii ba ninkofiɛ ni sifiɛ sɛɛle suoto ntɔɔkpa, batokotĩitɛ nfɛ konu, bakpi kɔtaka mansiɛ nkpa, bapiitɛ kafɔɔ nfɛ konu ɔlaa biene nwu nkpo. ");
INSERT INTO snw_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Suoto mayɔɔ batii ba ninanya ni ɔlaa kpile kuonwii di suoto nii.” ");
INSERT INTO snw_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Di obe wɔ di basaateketetɛ nwu nkpo nfɛ kosifi nii yi, Yesu lakakatɛ di Yohane suoto aatɔkɔ batii dikudi nwu nkpo alɛ, “Obe wɔ biadie biakyɛ Yohane nfũ di ɔfaafuu kamɛ, be biatoonyu osuku bilɛ bianya? Lɛkpɛnyi le di kɔfɛɛfɔ latɔɔfɛ ni? ");
INSERT INTO snw_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Be lɛsaa biakyɛ bialaanya? Otii wɔ niakpe ntu aasiɛ ni di asaa biene kamɛ? Binyu, batii nwu nkpo okle yi, baka ayo mansiɛ! ");
INSERT INTO snw_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Aye bitɔkɔ mi, be biakyɛ bialaanya? Yaa ɔlaa buɛtɛtɛ? Nwaako katɔkɔ ye nii yi, otii wɔ biakyɛ bialaanya ni nlenke bia Yaa ɔlaa buɛtɛtɛ. ");
INSERT INTO snw_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Diekye Yohane ninle otii wɔ suoto di Kɔkpana Klekle Kukũ lebuɛ alɛ, ‘Makyesee tɔkyɛntɛ nii anlefɔ katũ analolaa osuku antɛ fɔ.’ ");
INSERT INTO snw_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nwaako katɔkɔ ye ni kafɔɔ, Ntu Kpeesatɛ Yohane lɛtaka katoo alenke otii lele nintoyisiɛ kayi ka mmle ɛɛbafe. Kafɔɔ otii wɔ ninle ni ɔyɛntɛle di Yaa sɛka kalekɔ nwu kamɛ yi, eekple ɛɛtaka katoo alenke Yohane nwu nkpo. ");
INSERT INTO snw_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Diɛyɔ ni di obe wɔ di Ntu Kpeesatɛ Yohane lakyako ni Yaa ɔlaa lɛkya oyie diɛbase ni di miɛ yi, batii ba di ninu lɛsɛɛ alɛ boobuo ni Yaa sɛka kalekɔ nwu nkpo yi, bootuo ma dibuo osie kanya. Kafɔɔ mba niinu lɛsɛɛ bɛɛkpɛ ni ku okyiini yi, mma nimabuo nfa nɛ. ");
INSERT INTO snw_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Yaa ɔlaa babuɛtɛtɛ ku Mose kufiofa Yaa ɔlaa baabuɛ baatɛ fiɛ diɛbadu Yohane obe suoto. ");
INSERT INTO snw_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ni nse bietuna bilɛ biofũ ɔlaa lɛma nwu minnu yi, Yohane ninle Elia wɔ baabuɛ baatɛ alɛ, abawa ni nɛ. ");
INSERT INTO snw_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Otii wɔ kunutoko nkpe nii yi, aanu. ");
INSERT INTO snw_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Nunua, be lɛsaa kayɔ miɛ akyɛnfɔɔle nkaatɛɛsa ko? Nkpo bate fɛ babisɔ ba ninsi bookpee ni kɔkyɔ di asaa kasunsukɔ nɛ. Bɔɔtɔkɔ dikudi bamba alɛ, ");
INSERT INTO snw_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Buasa sɛkafɔɔnu buata ye, kafɔɔ biasĩ otũ. Buakpee sikunu buata ye, kafɔɔ biasĩ kaku owi.’ ");
INSERT INTO snw_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Diekye obe wɔ di Yohane lawa nii, aanii kanya, atanyi nta kunwii. Kafɔɔ batii latɔkɔ nwɔ alɛ, ‘Ninwuna kpile ninsi nwɔ!’ ");
INSERT INTO snw_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Obe wɔ kafɔɔ di ami, Otii Obi nwu, lɛwa nii, lale, lanyi. Kafɔɔ batii labuɛ alɛ, ‘Banyu lenyatɛ ku tanyintɛ nwu lo! Ale akpooto bafuntɛ ku bakpiletɛ siɛwo!’ Kafɔɔ batii ba bamuu nintikanko ni Yaa ninumbe nkpaamaa, batoodiki beetuo alɛ ninumbe nwaa dile.” ");
INSERT INTO snw_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Seekpoo se di Yesu labla ni sɛkpɛ se niɛbla ni ɔkpɛ kpinwu kamɛ, batii ditakyi di sikpile lɛma. Nkpo oso diakpɛ nwɔ nyaami aabuɛ alɛ, ");
INSERT INTO snw_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Biyɔɔsa aye Korasin batii! Aye Betsaida batii kafɔɔ biyɔɔsa! Diekye sɛkpɛ se niɛbla ni ɔkpɛ, bɛɛbla ni kaamɛ lee, nse mambla sĩ di Tiro ku Sidon kamɛ yi, nse baakyisa nkpa kofokofoko, baafifia ntɔ di suoto, baanyukũ aboko, baatuo alɛ batookyi siikpile lɛma. ");
INSERT INTO snw_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nwaako kɔtɔkɔ ye nlɛ, di lɛkankoyi nwu nkpo suoto yi, Yaa manya Tiro ku Sidon sekpoo batii nyaami anlenkee ye. ");
INSERT INTO snw_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ni aye Kapernaum batii, bienyu bilɛ Yaa matakatɛsa ye asifiko osi? Oowo! Abawakosa ye kasɔ ankpee ye di kawɔɔ ɔtɔ kamɛ. Diekye sɛkpɛ se niɛbla ni ɔkpɛ bɛɛbla ni kaamɛ lee, nse mambla sĩ di Sodom yi, nse okpoo nwu nte diɛbase bia miɛ. ");
INSERT INTO snw_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Kɔtɔkɔ ye nlɛ, di lɛkankoyi nwu nkpo suoto yi, Yaa manya Sodom batii nyaami anlenkee ye.” ");
INSERT INTO snw_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Di obe nwu nkpo kamɛ yi, Yesu labuɛ alɛ, “Teete, osi ku kasɔ Saate, kɔpɛ fɔ sɛfa, diekye asaa ya fɛɛyɔ feekookaa ni bakũyentɛ ku banumbentɛ, nya fatoodiki feetuo batii ba ninanye ni akũ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Nwaako Teete, nkpo okle foomiɛ falɛ dite nɛ.” ");
INSERT INTO snw_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ni aakple aabuɛ alɛ, “Teemi lɛyɔ asaa amuu eekpee mi nínɛɛ kamɛ. Otii kuonwii dieye otii wɔ di Obi nwu nle nii, diediki Ote lete ninye. Nkpo okle kafɔɔ di otii kuonwii dieye otii wɔ di Ote nle ni nɛ yeidiki Obi lete ninye, ku batii ba di Obi nwu alɛ oodiki antuo nii. ");
INSERT INTO snw_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Biwa ɔkyɛ nii, aye ba bamuu nintuka atoo nutũle ditoobuo ye ni. Ami mata ye ɔnyɛɛ ɔtɛ. ");
INSERT INTO snw_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Biyɔ ɔkpɛ nii ɔbla bitika di suoto, bietekete bikyeko ɔkyɛ nii. Diekye lɛbla buɛɛ, lɛwakosa suoto kasɔ kafɔɔ di otu nii kamɛ, ni bibawɛ ɔnyɛɛ ɔtɛ. ");
INSERT INTO snw_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Diekye ɔkpɛ wɔ mata ye ni nnaa osie. Atoo nii kafɔɔ lɛbla fɛnflɛ.” ");
INSERT INTO snw_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Obe onwii kamɛ, Yesu ku basaateketetɛ nɔɔ latoofe di kofe kunwii kamɛ di Lɛnyɛɛtɛyi suoto. Kɔka laklee basaateketetɛ nɔɔ nwu nkpo, nkpo oso baafee kofe nwu alesaa awo baafini baatoowee. ");
INSERT INTO snw_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Obe wɔ di Farisi batii lanya ni mmle, ni batɔkɔ Yesu alɛ, “Nyu lo, basaateketetɛ lɛfɔ ntɔɔbla lɛsaa le di kufiofa nwu nkpo diɛta osuku alɛ baabla ni di Lɛnyɛɛtɛyi suoto.” ");
INSERT INTO snw_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ninfɛ di Yesu ladiki kanya aakaalɛ ma alɛ. “Diidii biika di Kɔkpana Klekle Kukũ kamɛ binya, lɛsaa le di Dawid labla ni di obe wɔ di kɔka laklee nwɔ ni ku batii nɔɔ? ");
INSERT INTO snw_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Aabuo Yaa leyo, nnwɔɔ ku batii nɔɔ baalaayɔ alesaa ya baata ni Yaa ole, baale. Nu Kuufiofa ditata osuku. Yaa olebatatɛ lete ninkpe osuku manle alesaa nwu nkpo fiɛ. ");
INSERT INTO snw_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Sɛɛ biika di Mose kufiofa kamɛ alɛ, di Lɛnyɛɛtɛyi biala suoto, nu manambla ɔkpɛ, Yaa olebatatɛ ba ninkpe ni di Yaa Olekatakɔ nwu nkpo ntaalɛ kufiofa nwu nkpo kafɔɔ, mankpi lɛpɔɔ? ");
INSERT INTO snw_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Kɔtɔkɔ ye nlɛ, lɛsaa le niefũ kɔya dilenke ni Yaa Olekatakɔ nsi ye kaamɛ ninfũ. ");
INSERT INTO snw_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kɔkpana Klekle Kukũ lebuɛ alɛ, ‘Nyaami ɔnya di ami Yaa komiɛ, diele alɛ biayɔ babɔkɛɛ minta ni ole kowolaa.’ Nse fɛ bienu ɔlaa wɔ mmle kasɔ nwaa yi, nse bitaalo batii ba ninankaatɛ alɛ baakpi lɛpɔɔ, lɛpɔɔ. ");
INSERT INTO snw_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Diekye ami Oti Obi nwu ninle Lɛnyɛɛtɛyi Saate.” ");
INSERT INTO snw_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Obe wɔ di Yesu ladie ni ninfa, ninfɛ aasifi Yuda batii kasiisakɔ kanwii nɛ. ");
INSERT INTO snw_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ni aalaakyakako osuɔtɔ onwii kɔɔnɛɛ lekpi nwɔ ni nɛ. Batii bawo lawɛ ninfa baatoomiɛ alɛ boolo Yesu lɛpɔɔ. Nioso baakaalɛ nwɔ alɛ, “Kufiofa loo lɛta osuku alɛ baayɔɔsa otii ofiɛ di Lɛnyɛɛtɛyi suoto?” ");
INSERT INTO snw_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ninfɛ di Yesu ladiki kanya, aakaalɛ ma alɛ, “Nse diɛwa alɛ onwii lee nkpe foso onwii, ɛɛkpa eebuo diibiɔ kamɛ di Lɛnyɛɛtɛyi suoto, ɔlɔbakpee kɔnɛɛ alɛ oodiki nwɔ? ");
INSERT INTO snw_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Mia kafɔɔ otii lefũ kɔya alenke foso. Nkpo oso yi, kufiofa loo lɛta osuku alɛ baanya nyaami di Lɛnyɛɛtɛyi suoto.” ");
INSERT INTO snw_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ninfɛ aatɔkɔ osuɔtɔ wɔ kɔɔnɛɛ nɔɔ lakpi ni alɛ, “Dilasa kɔnɛɛ lɛfɔ.” Ninfɛ aayilasa kũ nɛ. Nfanwu, kɔnɛɛ nwu nkpo niakple kualɛ fɛ mmle di kɔnyɔɔfa nte nii. ");
INSERT INTO snw_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ninfɛ di Farisi batii nwu nkpo lasifi, baalaakpee asi baawo mmle baalo ni Yesu nɛ. ");
INSERT INTO snw_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Di obe wɔ di Yesu lanu disibu kpile le di Farisi batii ladiki ni di suoto nɔɔ, aadie ninfa aasifi, ninfɛ di batii dikudi kpinwu latikanko nwɔ nɛ. Ninfɛ aayɔɔsa bafiɛtɛ bamuu sifiɛ kaamɛ lɛma nɛ. ");
INSERT INTO snw_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ninfɛ aasĩ ɔlaa aata ma alɛ, batandiki nwɔ kayi baata batii bamba di nni nkpo suoto nɛ. ");
INSERT INTO snw_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Aatɔkɔ ma nkpo okle alɛ Yaa ɔlaa wɔ aabuɛ aatɛ ni diefe ni di Ɔlaa Buɛtɛtɛ Yesaia suoto kawa kaanya fɛ mmle aabuɛ nii. Aabuɛ alɛ, ");
INSERT INTO snw_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Nwɔ mmle ninle kpɛmblatɛ nii wɔ lediki ni nɛ. Mbɔmbɔ nwɔ, obuo mi anu nwaa kafɔɔ. Mayɔ Ninwuna nii nkpee nwɔ kaamɛ alɛ abadiki lɛkakanko nii ambuɛ antɔkɔ nnle mmuu. ");
INSERT INTO snw_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Alabananfiko otii kuonwii ɔlaa ee amuɛ otii kuonwii. Alabakakatɛ osie kanya kafɔɔ di akpaka. ");
INSERT INTO snw_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Abatɛ otu kaasɔ buɛɛ anta mba ninnaa ni osie, abawɛ sifutulɛ kafɔɔ anta mba lɛɛkyakaako lefĩ nii. Abayila annyu kafɔɔ alɛ lɛkanko le ninte ni tinini lɛbla ɔkpɛ di osuku kanya. ");
INSERT INTO snw_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Nnwɔɔ suoto kafɔɔ di nnle mmuu mayɔ anu lɛma mantika nɛ.” ");
INSERT INTO snw_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ninfɛ baatii banwii lakpaa osuɔtɔ onwii niinwuna kpile lasiɛ ni atatoonu, atatoofuo ni ɔtɔɔkakatɛ baawako Yesu nfũ nɛ. Ninfɛ di Yesu latososa ninwuna nwu nkpo diaata alɛ ofiɛ nwu nkpo layɔɔ nwu aafuo ɔtɔɔkakatɛ, aafuo kafɔɔ ɔtɔɔnya nɛ. ");
INSERT INTO snw_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Diabla batii dikudi nwu nkpo niawɛ ni ninfa yaaa di lɛsaa le di Yesu labla ni suoto. Ni baakaalɛ alɛ, “Sɛɛ nnwɔɔ ninle Ɔka Dawid ɔnantii wɔ baabuɛ baatɛ alɛ abawa ni nɛ?” ");
INSERT INTO snw_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Obe wɔ di Farisi batii lanu ni ɔlaa wɔ mmle yi, ni baabuɛ alɛ, “Anwuna kpile ɔka Beelsebul niɛtɔɔ osie wɔ mmle. Nkpo oso oofuo anwuna kpile otososa odiki baatii kamɛ nɛ.” ");
INSERT INTO snw_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu latofo disibu lɛma nwu, ni aatɔkɔ ma alɛ, “Sɛka kalekɔ lele niɛsɛ bawo di akudi akudi bɛɛtaka bayɛ baawo suoto yi, manyila. Nkpo okle kafɔɔ se okpoo ee leyo lewo kamɛ batii lɛsɛ bawo akudi akudi bɔɔkpɛko bawo yi, mambiɛ. ");
INSERT INTO snw_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Nkpo oso nse dikudi lewo di Satana sɛka kalekɔ kamɛ kɔkpɛko dikudi nyɔɔfa yi, ni dioto alɛ sɛka kalekɔ nwu ntɔɔsɛ suoto, ni baasinkyo ku ɔnɔɔ. ");
INSERT INTO snw_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Biobuɛ bilɛ kotososa anwuna kpile ndiki diekye Beelsebul niɛtɛɛ osie nwu kɔbla nkpo. Ni nse nkpo kute mɔ, owe niɛta batii lee osie bootososa anwuna kpile mandiki baatii kamɛ? Ni lɛsaa le di batii lee kɔbla ni kotuo alɛ ole ye nnaa! ");
INSERT INTO snw_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Diele Beelsebul osie kule. Kafɔɔ Yaa Ninwuna niɛtɛɛ osie kotososa anwuna kpile ndiki baatii kamɛ. Nle mmle kotuo alɛ Yaa sɛka kalekɔ ntɔɔwa ye kamɛ kofokofoko. ");
INSERT INTO snw_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Nkpe osie wɔ ninlenke ni Satana ole, diekye otii kuonwii dilabafuo sientɛ leyo obuo ɔlɛ nwɔ asaa, diediki eemufũ sientɛ nwu nkpo ɛɛpɛ lekpo fiɛ ɛɛlɛ nwɔ asaa. ");
INSERT INTO snw_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Otii lele ninan-yɛ mi kamaa yi, ni ɛɛtaka ayɛ mi di suoto. Otii lele ninankyakaakoe busiisa, ni ɔsamiisa, ɔɔsaamiisa. ");
INSERT INTO snw_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Nle mmle oso, kɔtɔkɔ ye nlɛ Yaa mayɔ okpile lele baatii lɛbla ku ɔlaa kpile lele beebuɛ ankyɛ ma. Kafɔɔ otii lele niebuɛ ɔlaa kpile di Yaa Ninwuna Klekle suoto yi, Yaa dilabayɔ akyɛ nwɔ. ");
INSERT INTO snw_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Otii lele niebuɛ ɔlaa owo eeyila di Otii Obi nwu suoto yi, Yaa man-yɔ ankyɛ nwɔ. Kafɔɔ otii lele niebuɛ ɔlaa owo eeyila di Yaa Ninwuna Klekle suoto yi, Yaa dilabayɔ akyɛ nwɔ di nkpa be mmle kamɛ ee mbe nikɔwa ni kamɛ. ");
INSERT INTO snw_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Kowoso biene yi, biye bilɛ abi biene kuntika. Kowoso ko ninanlɛ yi, abi ya kuntika ni kafɔɔ ninlɛ. Kowoso biala, abi ya kuotika ni man-yɔ mantofo kowoso ko okle kule nii. ");
INSERT INTO snw_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Aye ba ninle ni batii kpile fɛ kɔsaanwu! Ɔlaa biene kuonwii nindie ye kaanya kamɛ! Asaa ya ninsi ni di otii disibu kamɛ yi, nnya ko andiki ambuɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Otii biene yi, asaa biene ya eekookaa ni di asaa nɔɔ katɛkɔ yi, nnya andiki kayi nɛ. Otii kpile kafɔɔ yi, sikpile se eekookaa ni kaamɛ nɔɔ, nsĩ andiki anwako kayi nɛ. ");
INSERT INTO snw_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Komiɛ nlɛ kamɛ kakpa ye klekle nlɛ, di lɛkanko di nwu suoto yi, otii biala ɔlaakuu lele atooyibuɛ yi, abata nwu nkuntaa. ");
INSERT INTO snw_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Aye bamu kanya kamɛ sɛlaa di Yaa mayɔ ankanko ye, anlo ye lɛpɔɔ ee anta ye lɛbɛ.” ");
INSERT INTO snw_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Nfa nfɛ di kufiofa batuotɛ bawo ku Farisi batii bawo latɔkɔ Yesu alɛ, “Saatuotɛ, buomiɛ bulɛ fabla dituosaa lewo fatuo buɔnya.” ");
INSERT INTO snw_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ninfɛ di Yesu ladiki kanya alɛ, “Nyu mmle di miɛ akyɛnfɔɔle lɛbla ni batii kpile, batikanko ni afiɔ ɔtɔ lo! Biomiɛ bilɛ mbla dituosaa, kafɔɔ, namabla. Dituosaa le lete babadiki mantuo ye minnya ni ninle Yaa Ɔlaa Buɛtɛtɛ Yona lele le okle nɛ. ");
INSERT INTO snw_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Fɛ mmle okle di Yona lale ni ayi atiɛ ku nkyɛ ntiɛ di kakpaku kplɛ nwu kafutu kamɛ yi, nkpo okle di Otii Obi nwu kafɔɔ male ayi atiɛ ku nkyɛ ntiɛ di kasɔ kamɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Di lɛkankoyi nwu suoto yi, Niniwe batii mataka manyila makanko ye malo ye lɛpɔɔ, diekye baakyi di sikpile lɛma suoto di obe wɔ baanu ni Yona ɔlaa obuɛ. Kɔtɔkɔ ye nlɛ otii onwii nkpe ninfũ ɛɛtaka katoo alenke ni Yona. ");
INSERT INTO snw_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Di lɛkankoyi nwu nkpo suoto yi, Ɔka Sanko wɔ niakye ni kala kasɔ mataka anyila ankanko ye anlo ye lɛpɔɔ. Diekye aakyɛ osuku wɔ niekyo ni fanfan aakye okpoo nɔɔ, aakyɛ Ɔka Salomo nfũ alɛ, ɔɔlaanu ninumbe nɔɔ sɛlaa. Kɔtɔkɔ ye nlɛ otii owo nkpe ninfũ ɛɛtaka katoo alenke ni Salomo. ");
INSERT INTO snw_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Nse beetososa ninwuna kpile lewo beediki di otii kamɛ yi, ninkyɛ nintookyi aba ya niekoso nii, nintoomiɛ kasiɛkɔ. Nse diɛwɛ kasiɛkɔ kukanwii yi, ");
INSERT INTO snw_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","nintɔkɔ suoto alɛ, ‘Makple nsifi lɛba kofole le lasiɛ nii.’ Nse eekple ɛɛbanya alɛ leyo nwu kamɛ nte foee, kafɔɔ beefiɛ kamɛ, beelolaa ni yi, ");
INSERT INTO snw_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ninkple ninsifi ninaakpaa anwuna kpile akuɛnsĩ ya ninlenke nwɔ nii, manwa mamasiɛ ninfa. Nse anwuna kpile nwu nkpo ntɔɔbla nkpo eeloo, otii nwu nkpo nkpa be nfɛ amasiɛ ni nlalaa ninlenkee nkpa kasale be aasiɛ nii. Nkpo okle diɔwa ɔbate di miɛ akyɛnfɔɔle kpile ya mmle suoto nɛ.” ");
INSERT INTO snw_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Di obe wɔ di Yesu latɔɔkakatɛko ni batii nwu nkpo yi, Yesu ɔya ku Yesu basuɔtɔbi lɛma lawa nfa. Baabayila kaayi alɛ boomiɛ alɛ bakakatɛko nwɔ. ");
INSERT INTO snw_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ninfɛ di batii ba onwii niayila ni ninfa onwii lɛma lakyɛ aalaatɔkɔ nwɔ alɛ, “Nyu, yaafɔ ku babilee n-yɛ kaayi alɛ bɔɔkakatɛkofɔ.” ");
INSERT INTO snw_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ninfɛ di Yesu ladiki kanya aakaalɛ ma alɛ, “Owe ninle mi ɔya ku babilɛma?” ");
INSERT INTO snw_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ninfɛ aayɔ kɔnɛɛ aatuo basaateketetɛ nɔɔ aabuɛ alɛ, “Nyu yaami ku babiloo lo! ");
INSERT INTO snw_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Otii lele niɛbla Teemi wɔ ninkpe ni kaatoo dibiesaa yi, nnwɔɔ ninle mi obilɛma suɔtɔbi ku obilɛma sankobi ku yaami nɛ.” ");
INSERT INTO snw_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Dii nwu nkpo Yesu ladie leeyo nwu nkpo aasifi lekpo kotoko. Ni aalaasiɛ ninfa aakyekasɔ aatootuo asaa nɛ. ");
INSERT INTO snw_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Batii ɔlambu wɔ niamana nwɔ baakyi ni laloolo, nioso aabuo di oklo onwii kamɛ aasiɛ. Ni baatii ɔlambu nwu nkpo layila di lekpo kotoko nɛ. ");
INSERT INTO snw_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ni aatuo ma asaa kpinwu di akpa kamɛ nɛ. Aabuɛ alɛ, “Obe onwii kamɛ, fekpɛntɛ onwii lakyɛ alesaa kubi ɔsa. ");
INSERT INTO snw_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Di obe wɔ aatɔɔsa ni alesaa kubi nwu koofe yi, kowo lakpete di osuku kotoko, ni baakansiɛ lasɛsɛɛ kũ baamɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Alesaa kubi nwu nkpo kowo lakpete di lɛkpankplabukii kasɔ suoto, nfũ kɔɔtɛ diɛpɔ ni nwaa. Ta kuubi nwu ditakyɛ ni kasɔ kamɛ nwaa oso, kuawolaa ɔkɔntɔ. ");
INSERT INTO snw_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Nkpo oso obe wɔ kuufĩ labadie nii, kuayɔɔ kuakpi, diekye sidu ninya ditakyɛ kasɔ kamɛ. ");
INSERT INTO snw_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Alesaa nwu nkpo kubi kowo lakpete di kakɔtɔkɔtɔ siwuu kamɛ. Obe wɔ aakɔntɔ nii, kakɔtɔkɔtɔ nwu nkpo lafukuti kaatĩi nya fɛɛ. ");
INSERT INTO snw_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Kafɔɔ alesaa kubi nwu nkpo kowo lakpete di kasɔ nwaa suoto kuatika abi. Awo latika abi kɔlafa. Awo kafɔɔ latika afosi akuɔ, ni di awo kafɔɔ latika afosi atiɛ nɛ.” ");
INSERT INTO snw_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ninfɛ di Yesu layɛntɛ, aatɔkɔ ma alɛ, “Otii wɔ kuunutoko nkpe nii yi, aanu!” ");
INSERT INTO snw_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ninfɛ di basaateketetɛ nɔɔ nwu nkpo lawa Yesu ɔkyɛ ni baakaalɛ nwɔ alɛ, “Be lɛsaa oso footuo batii nwu nkpo asaa di akpa kamɛ?” ");
INSERT INTO snw_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ninfɛ di Yesu ladiki kanya alɛ, “Aye di Yaa lediki Yaa Kafa Lɛsaatofo awofasaa eetuo, diele mma. ");
INSERT INTO snw_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Diekye otii wɔ ninkpe ni asaa ya mmle okle yi, Yaa matɔɔ ankyakaa alɛ aawɛ bia anlenkee mmle oomiɛ nii. Kafɔɔ otii wɔ ninnaa ni asaa nwu nkpo awo yi, kafui ka bia ninkpe nwɔ ni yi, babaklee manfũ nwɔ ni nnɛɛ. ");
INSERT INTO snw_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Lɛsaa le oso kotuo ma ni asaa di akpa kamɛ ninle alɛ, bɔɔnya kafɔɔ bɔɔlɔɔnya asaa batɛ nsũ. Nkpo okle kafɔɔ boonu kafɔɔ bloonu kasɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Nkpo oso Yaa Ɔlaa Buɛtɛtɛ Yesaia ɔlaa wɔ aabuɛ aatɛ ni ntɔɔwa kaanya fɛ mmle aabuɛ ni alɛ, ‘Bibanu kafɔɔ bilɔbanu kasɔ, bibaanya kafɔɔ bilɔbatofo. ");
INSERT INTO snw_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Diekye batii ba mmle disibu lɛbla buɛɛ, bakpe kafɔɔ setokopĩ, beetĩi anu lɛma kafɔɔ. Nse diele nkpo, se bɔɔnya, se boonu kafɔɔ, se disibu lɛma kafɔɔ ntabasɛkɛtɛ, alɛ baamunikĩi manwa ɔkyɛ nii, alɛ ami Yaa kayɔɔsa ma sifiɛ.’ ");
INSERT INTO snw_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Kafɔɔ aye yi, disi nlɛ ye lo! Diekye anu lee kɔnya, atoko lee kafɔɔ konu. ");
INSERT INTO snw_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Diekye nwaako kɔtɔkɔ ye nlɛ, Yaa ɔlaa babuɛtɛtɛ kpinwu ku batii ba ninte ni tinini lamiɛ osie kanya alɛ bɔɔnya lɛsaa le biɔnya nii, kafɔɔ batanya. Baamiɛ kafɔɔ osie kanya alɛ boonu lɛsaa le bionu nii, kafɔɔ batanu.” ");
INSERT INTO snw_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Yesu latɔkɔ basaateketetɛ nɔɔ alɛ, “Nunua yi, bikyɔɔ atoko bienu lɛsaa le di alesaa kubi santɛ suoto lɛkpa le mmle kotuo ni. ");
INSERT INTO snw_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Batii ba nienu ni Yaa Kafa suoto ɔlaa nwu nkpo, kafɔɔ manannu ni kasɔ yi, nkpo bate fɛ alesaa kubi ko niakpete ni di osukuntɛɛ suoto di kpiletɛ nwu nkpo lɛwa eebadiki ni ɔlaa nwu nkpo di situ lɛma kamɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Alesaa kubi ko niakpete ni di lɛkpakplabukii kasɔ suoto yi, mma ninle batii ba nienu ni ɔlaa nwu nkpo beefũ nwu beenu ni ninfa ninfa ku suoto lɛyɔɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Kafɔɔ di obe wɔ di ɔlaa nwu nkpo diese ni sidu kaamɛ lɛma oso yi, kunsiɛ ma kaamɛ kuaklɛ saa. Nkpo oso nse dibuo ku ditikanko lɛwa ma di suoto ta ɔlaa nwu oso yi, nfanwu mankple nkpaamaa. ");
INSERT INTO snw_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Alesaa kubi ko niabuo ni di kakɔtɔkɔtɔ siwuu kamɛ yi, mma ninle batii ba nienu ni ɔlaa nwu, kafɔɔ bɛɛyɔ disibu lɛma beetika ni di kayi ka mmle asaa kpinwu suoto, ku mmle baawɛ nya ni oso, atoofukuti eetĩi ɔlaa nwu nkpo, kuɔta alɛ kulootika abi. ");
INSERT INTO snw_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Alesaa kubi ko kafɔɔ niakpite ni di kasɔ nwaa suoto ninle batii ba nienu ni ɔlaa nwu beenu ni kasɔ. Beetika abi, bawo kɔlafa, bawo afosi akuɔ, bawo kafɔɔ afosi atiɛ.” ");
INSERT INTO snw_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu lapɛ ma lɛkpa bamba alɛ, “Yaa sɛka kalekɔ ntɛ fɛ nle mmle. Otii onwii lapɛ alesaa kubi biene di kofe nɔɔ kamɛ. ");
INSERT INTO snw_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Dii ninwii kakyɛ, obe wɔ baatii bamuu nfɛ nte nii, lo nɔɔ onwii lakyɛ aalaasa sɛfa kpile sinwii kubi di alesaa kubi biene nwu kamɛ, ni aasifi nɛ. ");
INSERT INTO snw_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Di obe wɔ di alesaa kubi nwu nkpo lakɔntɔ kuamuɔ kuakyako ni okpee yi, ni di sɛfa kpile kubi nwu kafɔɔ lakyako ɔkyɔɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Ninfɛ di kofe nwu nkpo saate bakpɛntɛ nɔɔ lawa ɔkyɛ nɔɔ babakaalɛ nwɔ alɛ, ‘Ɔnɔɔfo, diele alesaa kubi biene faapɛ di kofe lɛfɔ nwu kamɛ? Ni fɛ di sɛfa kpile se mmle nwu nkpo lekye?’ ");
INSERT INTO snw_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Ninfɛ di kofe nwu saate ladiki kanya alɛ, ‘Kpiletɛ onwii niɛbla nle mmle.’ “Ninfɛ di bakpɛntɛ nɔɔ nwu lakaalɛ nwɔ alɛ, ‘Ni foomiɛ falɛ bukyɛ bualaasifi sɛfa nwu nkpo buyu?’ ");
INSERT INTO snw_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Ninfɛ aatɔkɔ ma alɛ, ‘Oowo. Loobia nse biɛkyɛ sɛfa nwu nkpo osifi oyu yi, bibasifi alesaa kubi nwu nkpo kafɔɔ minkpɔtɔɔsa di sɛfa nwu nkpo. ");
INSERT INTO snw_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Aye bita akyuu lɛma anyɔ nwu nkpo ayila dilaase di alesaa nwu nkpo ofiɛlɛbee. Nfa nfɛ matɔkɔ bafiɛlɛtɛ nwu nlɛ, balekatũ basifi sɛfa nwu nkpo baanii sĩ akudi akudi baafiɛ sĩ. Nni kamaa baafiɛlɛ alesaa kubi nwu nkpo balaakpete mi di owu kamɛ.’ ” ");
INSERT INTO snw_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu lakple aapɛ ma lɛkpa bamba ninwii alɛ, “Yaa sɛka kalekɔ nte fɛ mmle okle. Otii onwii layɔ lewosobi biibii ninwii aapɛ koofe nɔɔ. ");
INSERT INTO snw_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Dile lewosobi le niebiibii dilenke ni di alewosobi amuu kamɛ. Kafɔɔ nse kuomuɔ, kumakple kolewoso ko niemuɔ kulenke ni alewoso amuu di kofe nwu kamɛ. Bakansiɛ nwa mamabla ayo lɛma di sɛla nɔɔ suoto.” ");
INSERT INTO snw_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu lakple aapɛ lɛkpa bamba aabuɛ alɛ, “Yaa sɛka kalekɔ nte fɛ mmle okle. Ɔsanko onwii layɔ kɔfa ko man-yɔ mannwɔtɔ ni nnaafũ kafui, aanwɔtɔ nnaafũ kotofo kunwii dialaase di obe wɔ di mmuu lataka ni.” ");
INSERT INTO snw_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Akpa kamɛ di Yesu lafe aatɔkɔ batii nwu nkpo sɛlaa se mmle simuu. Atakakatɛ aata ma, nse diele lɛkpa ɔɔpɛ. ");
INSERT INTO snw_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Aabla nkpo alɛ Yaa Ɔlaa buɛtɛtɛ ɔlaa wɔ aabuɛ aatɛ ni kawa kaanya. Aabuɛ alɛ, “Akpa kamɛ makakatɛ nta ma. Mabuɛ asaa ya mananye nii ntɔkɔ ma, diɛyɔ ni di kayi ka mmle kasɔ kayekɔ.” ");
INSERT INTO snw_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Obe wɔ di Yesu ladiki ni batii dikudi nwu nkpo osuku, ni aasifi leyo nɛ. Ninfɛ baasaateketetɛ nɔɔ lawa ɔkyɛ nɔɔ leeyo, babatɔkɔ nwɔ alɛ, “Diki lɛkpa le fɛɛpɛ ni kasɔ di sɛfa kpile suoto kofe fata wo.” ");
INSERT INTO snw_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ninfɛ di Yesu ladiki kasɔ alɛ, “Otii wɔ niasa ni alesaa kubi biene nwu ninle Otii Obi nwu nɛ. ");
INSERT INTO snw_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Kofe nwu nkpo kafɔɔ ninle kayi nɛ. Alesaa kubi biene nwu ninle batii ba ninle ni Yaa kafa batii nɛ. Sɛfa kpile nwu nkpo ninle batii ba ninle ni kpiletɛ nwu nkpo bale nɛ. ");
INSERT INTO snw_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Kpiletɛ wɔ kafɔɔ niasa ni sɛfa kpile nwu ninle Abonsam nɛ. Alesaa kubi nwu nkpo ofiɛlɛbee kafɔɔ ninle kayi kalookɔ nɛ. Alesaa kubi bafiɛlɛtɛ nwu nkpo ninle Yaa batɔkyɛntɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Fɛ mmle okle baasiisa ni sɛfa, baafiɛ sĩ ni di ɔtɔ kamɛ yi, nkpo okle kafɔɔ dibate di kayi kalookɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ami, Otii Obi nwu, makyesee Yaa batɔkyɛntɛ nii nkyeko osi, manwa mamasiisa batii ba bamuu ninkɔta batii mbla ni okpile ku batii ba bamuu ninkɔbla ni sikpile di Sɛka kalekɔ nii kamɛ. ");
INSERT INTO snw_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Babafuki ma makpee di kawɔɔ ɔtɔ wɔ nikofiɛ ni bembembe kamɛ. Nfa babawi kaku, manwee anyɛɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kafɔɔ Yaa batii makpa fɛ le kufĩ di Teete lɛma Sɛka kalekɔ kamɛ di osi. Otii wɔ kuunutoko nkpe nii, aanu. ");
INSERT INTO snw_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Yaa sɛka kalekɔ nte fɛ nle mmle okle. Obe onwii, otii onwii lakyɛ aalaawɛ lɛsaawɛ le niefũ ni kɔyɔ di kofe kunwii kamɛ beekookaa nii. Ni aakple aayɔ lɛsaa nwu nkpo aakookaa nɛ. Di suoto lɛyɔɔ kamɛ, ni aasifi aalaayɔ asaa nɔɔ amuu aasunsũ, ni aasifi aalaaya kofe nwu nkpo nɛ.” ");
INSERT INTO snw_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Yesu lakple aabuɛ alɛ, “Yaa sɛka kalekɔ lekple dite fɛ nle mmle. Asaa sunsutɛ onwii latoomiɛ aniibi ya niefũ ni kɔyɔ osie kanya. ");
INSERT INTO snw_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Obe wɔ aawɛ ni onii wɔ ninlɛ kulenke ni yi, aasifi aalaayɔ asaa nɔɔ ya amuu ninkpe nwɔ ni aasunsũ, aayɔ aalaaya oniibi nwu nkpo. ");
INSERT INTO snw_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Yaa sɛka kalekɔ lekple dite fɛ nle mmle okle. Kɔkpaku badikitɛ banwii lataa asawu baakpee di lekpo kamɛ, ni baadiki kakpaku ate ate nɛ. ");
INSERT INTO snw_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Obe wɔ di asawu nwu nkpo layii nii, baananfi nya baawako lekpo kotoko, ni baasiɛ kaasɔ baasɛsɛɛ kɔkpaku nwu nkpo nɛ. Baayɔ kubiene baakpete di kakyikyɛ kamɛ, ni baayɔ kɔlalaale kafɔɔ baawii nɛ. ");
INSERT INTO snw_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Nkpo okle diɔwa ɔbate di kayi kalookɔ nɛ. Yaa batɔkyɛntɛ mawa mamadiki babienetɛ mankyeko bakpileblatɛ kamɛ. ");
INSERT INTO snw_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Nse batɔɔyɔ bakpileblatɛ beefuki beekpee di kawɔɔ ɔtɔ kamɛ. Nfa di kaku owi ku anyɛɛ owee mawɛ nɛ.” ");
INSERT INTO snw_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu lakaalɛ ma alɛ, “Bienu lɛsaa biala lɛtɔkɔ ye ni kasɔ?” Ni baatɔkɔ nwɔ alɛ, “Yii, buonu kasɔ.” ");
INSERT INTO snw_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ninfɛ di Yesu latɔkɔ ma alɛ, “Ni nle mmle kotuo alɛ asaa batuotɛ lele nintookple Yaa sɛka kalekɔ asaa teketetɛ kamaa, nfɛ nte fɛ leyo saate wɔ nindiki asaa kofole ku asaa fɔle ankyeko ni asaa nɔɔ katɛkɔ anwako ni kayi.” ");
INSERT INTO snw_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Obe wɔ di Yesu laloo ni akpa nwu nkpo ɔpɛ yi, aadie ninfa aasifi. ");
INSERT INTO snw_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ninfɛ aakple aasifi nnwɔɔ omu nɔɔ okpoo lɛma nɛ. Ninfɛ aalaatuo asaa di kasiisakɔ lɛma nɛ. Batii ba nianu ni asaa nɔɔ otuo, diabla ma yaaa. Ninfɛ baakaalɛ suoto lɛma alɛ, “Ɔfɛ ɛɛwɛ lɛsaatofo le mmle nwu nkpo eekyeko? Ɔfɛ kafɔɔ ɛɛwɛ osie wɔ akle ɔɔblako ni sɛkpɛ se niɛbla ni ɔkpɛ antuo ni? ");
INSERT INTO snw_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Sɛɛ diele nnwɔɔ ninle asaa wolatɛ nwu obi? Diele ɔya kafɔɔ ninle Maria, diele babilɛma suɔtɔbi kafɔɔ ninle Yakobo ku Yosef ku Simon ku Yuda? ");
INSERT INTO snw_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Diele babilɛma sankobi bamuu kafɔɔ ninsiwo kaamɛ ninfũ nɛ? Ni owe niɛtɔɔ lɛsaatofo ku osie wɔ mmle okle?” ");
INSERT INTO snw_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Nioso diawɛ ma osie alɛ baafũ nwɔ, nkpo oso baasĩ nwɔ. Ninfɛ di Yesu latɔkɔ ma alɛ, “Batii mbu Yaa ɔlaa buɛtɛtɛ di kakɔbiala, diediki nnwɔɔ omu nɔɔ okpoo lɛma ku kafaabi nɔɔ batii kamɛ lete, manambu nwɔ.” ");
INSERT INTO snw_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ta batafũ Yesu baanu ni oso yi, atabla sɛkpɛ se niɛbla ni ɔkpɛ kpinwu di Nasaret batii kamɛ. ");
INSERT INTO snw_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Di obe nwu kamɛ yi, Herode wɔ niatoole ni sɛka di Galilea kasɔ suoto lanu Yesu leyooto. ");
INSERT INTO snw_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ni aatɔkɔ batii nɔɔ alɛ, “Otii wɔ mmle yi, Yaa Ntu Kpeesatɛ Yohane nintoo kple ɛɛtaka eekye bakpi kamɛ ɛɛwa. Nkpo oso akpe osie ɔɔbla sɛkpɛ se niɛbla ni ɔkpɛ antuo nɛ.” ");
INSERT INTO snw_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Aabuɛ ɔlaa wɔ mmle diekye Herode wɔ mmle niata baamufũ Yohane, aata baanii nwɔ, baatɛ nwɔ leeyo. Herode labla nle mmle ta Herodia wɔ ninle obilɛma Filipo ɔsɔfɔ oso. ");
INSERT INTO snw_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Diekye lɛsaa le niawa ni ninle alɛ, Yaa Ntu Kpeesatɛ Yohane lasĩ ɔlaa aata Herode alɛ, “Yaa kufiofa diɛta osuku alɛ, faafũ obilee ɔsɔfɔ Herodia fanyɔ.” ");
INSERT INTO snw_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Nkpo oso Herode lamiɛ alɛ oolo Yohane. Kafɔɔ aatɔɔyɛkɛ Yuda batii, diekye baatoobu Yohane fɛ le Yaa ɔlaa buɛtɛtɛ. ");
INSERT INTO snw_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Dii ninwii, Herode latoole lelofoyi nɔɔ, aalɛɛ batii kpinwu. Ni di Herodia obi sankobi lakyɛ aalaatũ di batii nwu nkpo anu nɛ. Katũ nɔɔ nwu nkpo labuo Herode anu osie kanya. ");
INSERT INTO snw_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ni aaka ntam aabuɛ alɛ, “Matafɔ lɛsaa lele fɛɛkaalɛ mi!” ");
INSERT INTO snw_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ninfɛ di ɔsankobi nwu nkpo ɔya latɔɔ disibu di lɛsaa le aakaalɛ ni suoto nɛ. Nkpo oso aakyɛ aalaakaalɛ Herode alɛ, “Komiɛ Yaa Ntu Kpeesatɛ Yohane disi di bɛɛsi bɛnkɛɛ kamɛ nunua.” ");
INSERT INTO snw_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Lɛsaa le mmle di ɔsankobi nwu nkpo lakaalɛ ni labuo ɔka Herode suoto. Kafɔɔ di ntam be aaka ni di banɔɔfo nwu nkpo bamuu anu oso, aata osuku alɛ babla di ɔsankobi nwu nkpo dibiesaa suoto batɔɔ. ");
INSERT INTO snw_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Nioso aakpee otii lakyɛ aalaabudi Yohane disi di leyo katenkɔ. ");
INSERT INTO snw_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ni aayɔ disi nwu nkpo aakpee di bɛɛsi bɛnkɛɛ kamɛ aawako ɔsankobi nwu nkpo nɛ. Ni di ɔsankobi nwu nkpo kafɔɔ layɔ disi nwu aakyɛnko ɔya nɛ. ");
INSERT INTO snw_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ni di Yohane basaateketetɛ nɔɔ labayɔ kpi nwu nkpo baasifiko baalaakookaa nɛ. Ni baakyɛ baalaatɔkɔ Yesu nɛ. ");
INSERT INTO snw_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Di obe wɔ di Yesu lanu alɛ batoolo ni Yohane yi, ni aayɔ oklo aadie ninfa aasifi laba le nielo ni baatii nnaa ni nɛ. Obe wɔ baatii lanu nfũ akpe nii, kpinwu lɛma ladie seekpoo lɛma baakyɛ nkpaa, baati nwɔ, baakyɛ ninfa. ");
INSERT INTO snw_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Obe wɔ di Yesu ladie ni di oklo kamɛ, aanya ni batii ɔlambu nwu nkpo, kafutu lanyinyii nwɔ di suoto lɛma. Ni aayɔɔsa mba niatoofiɛ ni bamuu sifiɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Di obe wɔ di kɔtɔɔfɔ lawo nii, basaateketetɛ nɔɔ lawa ɔkyɛ nɔɔ babatɔkɔ nwɔ alɛ, “Kale nfɛ koloo, nfũ bukpe ni kafɔɔ lekyo ku okpoo. Nkpo oso diki batii ba mmle osuku, baatɔɔkyɛ nkpaayotũ baalaamiɛ lelesaa bale.” ");
INSERT INTO snw_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesu ladiki kanya alɛ, “Diefĩ alɛ baasifi. Aye bamu bimiɛ lɛsaa lewo bita ma bale.” ");
INSERT INTO snw_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ni baasaateketetɛ nɔɔ nwu nkpo latɔkɔ nwɔ alɛ, “Alesaa ya lete bukle ni ninle bloblo akudi anɔɔ ku kɔkpaku sɛnle kɔnyɔ.” ");
INSERT INTO snw_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ninfɛ di Yesu latɔkɔ ma alɛ, “Biyɔ alesaa nwu biwakoe.” ");
INSERT INTO snw_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ni aatɔkɔ batii nwu nkpo bamuu alɛ basiɛ kaasɔ di sɛfa kɔnle nwu nkpo suoto. Ninfɛ aayɔ bloblo akudi anɔɔ ku kɔkpaku kɔyɔ nwu nkpo, ni aakplesa anu katoo aanyu osi aapɛ Yaa sɛfa nɛ. Ni aabɛbɛɛ bloblo nwu nkpo kɔkyɛɛ kɔkyɛɛ aata basaateketetɛ nɔɔ nɛ. Ni baasaateketetɛ nɔɔ kafɔɔ layɔ baata batii nwu nkpo nɛ. ");
INSERT INTO snw_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Obiala lɛma lale alesaa nwu nkpo aamiɛ. Nni kamaa, ni basaateketetɛ nɔɔ lasiisa kɔkyɛɛ kɔkyɛɛ ko niabu nii baakpete di nkyikyɛ kamɛ nɛ. Baawɛ lefosi nikyikyɛ nnyɔ pɔ. ");
INSERT INTO snw_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Batii ba niale ni alesaa nwu nkpo labla basuɔtɔ nkpe nnɔɔ. Bataka basanko ku babisɔ baakpee kaamɛ. ");
INSERT INTO snw_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ninfɛ di Yesu lata alɛ basaateketetɛ nɔɔ layie baabuo di oklo kamɛ alɛ balekatũ bataalɛ basifi lekpo nwu nkpo kakyɛ nyɔɔfa nɛ. Diabu lete nɔɔ ninfa alɛ oodiki batii nwu nkpo osuku. ");
INSERT INTO snw_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Di obe wɔ atoodiki batii nwu nkpo osuku eeloo ni kamaa, lete nɔɔ aakata aasifi kobokote osi alɛ ɔɔlaapɛ ɔlaa anta Yaa. Kale laloo, nioso Yesu lete niabu ninfa. ");
INSERT INTO snw_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Di obe nwu nkpo kamɛ, oklo nwu nkpo ntɔɔkyɛ sitũ nwaa. Lekpo ntu latɔɔkpɛko oklo nwu nkpo, diekye lekpo kɔfɛɛfɔ latɔɔfɛ kuatɔɔkyako oklo nwu nkpo. ");
INSERT INTO snw_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kolesɛtũ elomu etiɛ ku elomu ekuɔ ntɛɛ yi, Yesu lakyɛ di ntu osi aatoofe basaateketetɛ nɔɔ nwu nkpo nfũ. ");
INSERT INTO snw_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Di obe wɔ kamɛ baanyɔɔ akyɛ di ntu osi ɔɔwa nii, lɛyɛkɛ lapɛ ma baabuɛ alɛ, “Kpi dile!” Nkpo oso baayiisa kudu osie kanya! ");
INSERT INTO snw_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Nfanwu Yesu lakakatɛ aatɔkɔ ma alɛ, “Binya otu! Ami dile! Bitanyɛkɛ!” ");
INSERT INTO snw_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ninfɛ di Petro latɔkɔ nwɔ alɛ, “Saate, nse afɔ dile nwaako, ni faatɛɛ nkyɛ di ntu osi nwa ɔkyɛ lɛfɔ.” ");
INSERT INTO snw_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ninfɛ di Yesu latɔkɔ nwɔ alɛ, “Wa!” Ninfɛ di Petro ladie di oklo nwu kamɛ aakyako ɔkyɛ di ntu osi, aatoofe Yesu nfũ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Kafɔɔ di obe wɔ aanya ni kɔfɛɛfɔ ko niatɔɔfɛ ni osie kanya, lɛyɛkɛ lapɛ nwɔ, ni aakyako ɔmɛɛ di ntu nkpo kamɛ nɛ. Ni aafaa osie kanya aabuɛ alɛ, “Saate, diki mi!” ");
INSERT INTO snw_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Nfanwu ni di Yesu lananfi kɔnɛɛ nɔɔ aamufũ nwɔ, ni aatɔkɔ nwɔ alɛ, “Ofũ onu lɛfɔ diewo! Be oso fonoofũ mi fanu?” ");
INSERT INTO snw_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Banyɔ lɛma baabuo di oklo nwu nkpo kamɛ, ni kɔɔfɛɛfɔ nwu nkpo ladiɛ ɔfɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ninfɛ di basaateketetɛ nɔɔ nwu nkpo di oklo kamɛ lapɛ akunkyi baasumu nwɔ baabuɛ alɛ, “Nwaako, Yaa Obi fale!” ");
INSERT INTO snw_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Obe wɔ baataalɛ lekpo nwu nkpo baalaadu ni kayɛ nyɔɔfa di Genesaret kasɔ suoto yi, ");
INSERT INTO snw_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","batii lanya Yesu baatɛ nsũ ninfa. Nkpo oso baakyɛ baalaakpaa bafiɛtɛ ba ninkpe ni di ntɛɛ nwu nkpo fɛɛ baawako Yesu nfũ. ");
INSERT INTO snw_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ni baatikiti Yesu lekoto alɛ ata bafiɛtɛ bakpanko nwɔ awu kotoko lete pɛ. Batii ba bamuu niakpanko ni awu nɔɔ kotoko yi, sifiɛ lɛma layɔɔ ma. ");
INSERT INTO snw_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ninfɛ di Farisi batii bawo ku kufiofa asaa batuotɛ bawo lakye Yerusalem baawa Yesu nfũ babakaalɛ nwɔ alɛ, ");
INSERT INTO snw_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Be oso di basaateketetɛ lɛfɔ diloole afiofa ya di saa bakofo loo lediɛ bɛɛtɛ wo ni? Diekye mánfoto nnɛɛ lɛma fiɛ manle alesaa fɛ mmle di ɔsaabla loo kotuo nii.” ");
INSERT INTO snw_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ninfɛ di Yesu ladiki kanya alɛ, “Be oso di aye kafɔɔ biesĩ Yaa kufiofa ole, bitikanko saa bakofo loo ɔsaabla nkpaamaa? ");
INSERT INTO snw_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Yaa lebuɛ alɛ, ‘Bu teefɔ ku yaafɔ. Otii lele niɛkpaani ote ee ɔya, dikpe ni beelo nwɔ.’ ");
INSERT INTO snw_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Kafɔɔ biotuo bilɛ, nse otii owo nkpe lɛsaa alɛ ɔɔyɔ ankyakaako ote ee ɔya, eebuɛ alɛ, ‘Lɛyɔ lɛsaa le mmle nlɛ kɔta Yaa’ yi, ");
INSERT INTO snw_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","diesinfĩ alɛ otii nwu nkpo kabu ote ee ɔya. Di nle mmle ɔbla suoto yi, biesĩ Yaa kufiofa ole, bitikanko bawa lee nwu nkpo ɔsaabla nkpaamaa. ");
INSERT INTO snw_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Aye balaatɛ! Nwaako, ɔlaa wɔ di Yaa Ɔlaa Buɛtɛtɛ Yesaia labuɛ aatɛ ni di suoto lee ntɔɔwa kaanya. Aabuɛ alɛ. ");
INSERT INTO snw_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Batii ba mmle kanya fukiti ko man-yɔ mantansɛɛ, kafɔɔ mambɔmbɔ mi siitu lɛma kamɛ. ");
INSERT INTO snw_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Kasakasa bɔɔbla mi ɔkpɛ. Diekye bakle batii afiofa bootuo fɛle afiofa nii ale.’ ” ");
INSERT INTO snw_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ninfɛ di Yesu lalɛɛ batii dikudi nwu nkpo aawako ɔkyɛ nɔɔ ni aatɔkɔ ma alɛ, “Bikyɔɔ atoko, bienu kasɔ! ");
INSERT INTO snw_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Diele alesaa ya di otii nnle ankpee ni kaafutu kamɛ ninta alɛ ankpɔnɔnfɔ. Kafɔɔ sɛlaa se nindie sinkye ni otii kanya kamɛ ninta otii nkpɔnɔnfɔ.” ");
INSERT INTO snw_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ni baasaateketetɛ nwu nkpo lawa ɔkyɛ nɔɔ babatɔkɔ nwɔ alɛ, “Faye falɛ sɛlaa se feebuɛ ni lebuo Farisi batii nwu nkpo suoto osi kanya?” ");
INSERT INTO snw_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesu ladiki kanya aabuɛ alɛ, “Kowoso lele di Teemi wɔ ninkpe ni di osi diɛsɔ yi, abasifi kũ an-yu. ");
INSERT INTO snw_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Nkpo oso bitankpee ma kanya. Banumbiɛtɛ bale bɔɔkpaa banumbiɛtɛ wo lɛma. Nse numbiɛtɛ kafɔɔ kɔkpaa numbiɛtɛ wo nɔɔ yi, akyuu lɛma anyɔ, babanɔɔ mambuo diibiɔ kamɛ.” ");
INSERT INTO snw_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petro latɔkɔ nwɔ alɛ, “Diki lɛkpa nwu nkpo fɛɛpɛ ni kasɔ di alesaa ya ninkponɔfɔsa ni otii suoto fata wo.” ");
INSERT INTO snw_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ninfɛ di Yesu latɔkɔ ma alɛ, “Ni aye kafɔɔ batii ba ninoonu sɛlaa kasɔ biekple bile? ");
INSERT INTO snw_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Biye bilɛ lɛsaa lele di otii lekpee kaanya kamɛ, kafutu kamɛ ninsifi, nni kamaa, ankyɛ ni an-yu. ");
INSERT INTO snw_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Kafɔɔ sɛlaa se nindie sinkye ni otii kanya kamɛ yi, otii otu kamɛ sinkye. Sɛlaa nwu ninle asaa ya ninta alɛ otii nkpɔnɔnfɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Diekye disibu kpile le ninta alɛ otii nlo ni otii, ku lɛsɔnɔkpee ku seteeteelaa ku kayu ku sɛlaa kuafunu ku ditiikpɔnɔnfɔsa yi, otii otu kamɛ ankye. ");
INSERT INTO snw_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Asaa ya mmle ninta otii nkpɔnɔnfɔ nɛ. Kafɔɔ nse otii lele alesaa ananfoto kɔnɛɛ fɛ mmle di Farisi batii kotuo ni yi, nni nkpo nínkpɔnɔnfɔsa otii.” ");
INSERT INTO snw_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu ladie ninfa, ni aasifi ntɛɛ be niɛtɛɛtɛɛ ni sekpoo kplɛ se ninle ni Tiro ku Sidon nɛ. ");
INSERT INTO snw_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ni di Kana ɔsanko onwii ninkpe ni nintɛɛ nwu nkpo lawa Yesu nfũ, aafaa aatikiti nwɔ lekoto alɛ, “Saate nii, Ɔka Dawid Obi! Nyɛɛ nyaami! Ninwuna kpile ninwii kɔkpɛko obi nii sankobi, asi diibuo kamɛ osie kanya!” ");
INSERT INTO snw_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Kafɔɔ Yesu ditadiki kanya. Ninfɛ di basaateketetɛ nɔɔ lawa babatɔkɔ nwɔ alɛ, “Tososɔɔ aatɔɔkyɛ, diekye atikanko wo, ootĩisa wo atoko.” ");
INSERT INTO snw_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ninfɛ di Yesu ladiki kanya aatɔkɔ ɔsanko nwu alɛ, “Israel batii ba ninte ni fɛ bafoso ba nieyu nii, mma ɔkyɛ di Yaa lekpee mi nɛ.” ");
INSERT INTO snw_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Kafɔɔ ɔsanko wɔ mmle lapɛ akunkyi di Yesu nkpaatũ aatikiti nwɔ lekoto alɛ, “Saate nii, kyakaakoe!” ");
INSERT INTO snw_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesu ladiki kanya alɛ, “Diɛlɛ alɛ baayɔ babisɔ alesaa manfuki man-yu baweewee lɛma.” ");
INSERT INTO snw_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ninfɛ di ɔsanko nwu nkpo ladiki kanya alɛ, “Saate nii, nwaako kulɛ. Kafɔɔ baweewee kafɔɔ nkpe osuku manle alesaa kɔbɛfɛɛ ko ninkpa ni di saate lɛma opunu suoto kumpɛ ni kaasɔ.” ");
INSERT INTO snw_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Obe wɔ di Yesu lanu ni ɔlaa wɔ mmle yi, ni aatɔkɔ nwɔ alɛ, “O ɔsanko, ofũ onu lɛfɔ lemuɔ lo! Lɛsaa le foomiɛ ni yi, diwa kaanya dita fɔ.” Nkpo oso di obe nwu nkpo kamɛ tutuutu, ni di obi nɔɔ sankobi nwu ofiɛ layɔɔ nwɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu ladie ninfa aalaafe di Galilea Lekpo kotoko, ni aalaadu kabokotee kanwii ɔlɔɔkɔ, ni aakata ka aasifi aalaasiɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Batii dikudi kpinwu lawa nwɔ ɔkyɛ, ni baakpaa batii ba niefefee basi ni kaasɔ ku mba ninoofuo ni ɔkyɛ nwaa ku banumbiɛtɛ ku bamumu ku bafiɛtɛ bamba kpinwu baawako baabatɛ di anu nɔɔ, ni aayɔɔsa ma sifiɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Obe wɔ di batii nwu nkpo lanya bamumu kɔkakatɛ nii, batii ba ninoofuo ni ɔkyɛ nfɛ nkyɛ ni nwaa, batii ba niefefee basi ni kaasɔ ntoosie nii, banumbiɛtɛ kafɔɔ nfɛ kɔnya ni yi, diabla ma yaaa. Ni baatansa Israel Yaa nɛ. ");
INSERT INTO snw_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu lalɛɛ basaateketetɛ nɔɔ aawako ɔkyɛ nɔɔ, ni aatɔkɔ ma alɛ, “Batii ba mmle nwu nkpo ɔlaa konu mi kafutu, diekye batɔɔwɛ di ɔkyɛ nii ayi atiɛ amu kafɔɔ lɛsalɛsaa nnaa ma baale nii. Noomiɛ nlɛ ndiki ma osuku baatɔɔkyɛ leyo ku kɔka. Nse diele nkpo, babalaatokpi kɔka di osuku.” ");
INSERT INTO snw_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ni di basaateketetɛ nɔɔ lakaalɛ nwɔ alɛ, “Fɛ bubawɛ alesaa ɔfaafuu wɔ mmle kamɛ munta banankpantii ba mmle manle mammiɛ?” ");
INSERT INTO snw_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ni di Yesu lakaalɛ ma alɛ, “Bloblo akudi asɛ bikle?” Ni baasaateketetɛ nwu latɔkɔ nwɔ alɛ, “Bloblo akudi akuɛnsĩ ku kɔkpaku biibii kɔsɛɛ kowo ko bukle.” ");
INSERT INTO snw_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ninfɛ di Yesu latɔkɔ batii nwu nkpo alɛ basiɛ kaasɔ. ");
INSERT INTO snw_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ninfɛ di Yesu layɔ bloblo akudi akuɛnsĩ ku kɔkpaku nwu nkpo, ni aapɛ Yaa sɛfa nɛ. Ninfɛ aabɛbɛɛ alesaa nwu nkpo aata basaateketetɛ nɔɔ, ni baasaateketetɛ nwu nkpo kafɔɔ baayɔ baasɛ batii dikudi nwu nɛ. ");
INSERT INTO snw_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Bamuu lɛma baale baamiɛ. Obe wɔ baasaateketetɛ lasiisa ni kufui kufui ko niabu nii, baawɛ nkyikyɛ nkuɛnsĩ pɔ. ");
INSERT INTO snw_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Batii ba niale ni alesaa nwu nkpo labla basuɔtɔ nkpe nna. Bataka basanko ku babisɔ baakpee kaamɛ. ");
INSERT INTO snw_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ninfɛ di Yesu ladiki batii dikudi nwu nkpo osuku baasifi, ni aabuo di oklo kamɛ aasifi Magadan ntɛɛ nwu kasɔ suoto nɛ. ");
INSERT INTO snw_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farisi batii ku Saduki batii bawo lawa Yesu nfũ alɛ bɔbawolaa nwɔ kaanya. Nkpo oso baatɔkɔ nwɔ alɛ, “Bla dituosaa lewo fatuo wo buotofo bulɛ nwaako Yaa nfũ fɛɛkye.” ");
INSERT INTO snw_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Kafɔɔ Yesu ladiki kanya alɛ, “Nse kufĩ nfɛ kofe kamɛɛkɔ diɛ kolo lɛsɛɛ yi, mimbuɛ bilɛ kayi malɛ kɔsɛɛ. ");
INSERT INTO snw_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Nkpo okle kafɔɔ mimbuɛ ku kolesɛtũ bilɛ, ‘Alokonkyɛ lɛsɛɛ kayi lefuu nioso kanto manɔɔ.’ Minfuo mmle kaayi mate ni otofo nse bienyu osi. Kafɔɔ biloofuo atuosaa ya ninkɔwa ni di obe wɔ mmle kamɛ kasɔ onu! ");
INSERT INTO snw_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Aye miɛ akyɛnfɔɔle kpile, bitookple di Yaa nkpaamaa, biomiɛ bilɛ mbla dituosaa ntuo ye. Oowo! Bilabanya dituosaa kuniwii dilenkee Yona lele le okle.” Nkpo oso Yesu ladiɛ ma aasifi. ");
INSERT INTO snw_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Obe wɔ di basaateketetɛ nwu lataalɛ lɛpanta nwu nkpo baalaadu ni kayɛ nyɔɔfa yi, ni baanyuma alɛ baayɔ bloblo kuonwii bakle nɛ. ");
INSERT INTO snw_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ninfɛ di Yesu latɔkɔ ma alɛ, “Bilolaa binyu nwaa di Farisi batii ku Saduki batii kɔfa ko mankpee ni di nnaafũ kamɛ nintaka ni suoto.” ");
INSERT INTO snw_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ninfɛ baakyako obuɛ kaamɛ lɛma alɛ, “Mmle munan-yɔ bloblo kuonwii bukle ni oso obuɛ ɔlaa wɔ mmle?” ");
INSERT INTO snw_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu latofo ɔlaa wɔ baatoobuɛ nii, nioso aakaalɛ ma alɛ, “Be oso biobuɛ kaamɛ bilɛ biɛyɔ bloblo kuonwii bikle? Ofũ onu lee lɛtɛ kuɔwa kasɔ lo! ");
INSERT INTO snw_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ni biifuo otofo? Ni biloonyuma obe wɔ labɛbɛɛ bloblo akudi anɔɔ lasɛ ni batii nkpe nnɔɔ? Nkyikyɛ nsɛ kɔkyɛɛ kɔkyɛɛ ko biasiisa ni layii? ");
INSERT INTO snw_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Diɛkyakaa nii, bloblo akudi akuɛnsĩ ya layɔ lata ni basuɔtɔ nkpe nna mɔ? Nkyikyɛ nsɛ biasiisa kɔkyɛɛ kɔkyɛɛ nwu biayiisa? ");
INSERT INTO snw_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ni be oso minoofuo otofo bilɛ diele bloblo suoto kɔkakatɛ nta ye nlɛ, ‘Bilolaa binyu nwaa di Farisi batii ku Saduki batii kɔfa ko mankpee ni di nnaafũ kamɛ nintaka ni suoto’?” ");
INSERT INTO snw_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Nfa nfɛ di basaateketetɛ nwu nkpo lanu kasɔ alɛ diele kɔfa ko mankpee ni di nnaafũ kamɛ nintaka ni suoto ɔɔkakatɛ anta ma. Kafɔɔ di asaa ya di Farisi batii ku Saduki batii ntuo ni suoto alaka. ");
INSERT INTO snw_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu ku basaateketetɛ nɔɔ lasifi ntɛɛ be niɛtɛɛtɛɛ ni Kaesarea Filipi okpoo. Nfa aakaalɛ ma alɛ, “Owe baatii kobuɛ alɛ ami, Otii Obi nwu, nle?” ");
INSERT INTO snw_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ni baadiki kanya alɛ, “Bawo kobuɛ alɛ Yaa Ntu Kpeesatɛ Yohane. Bawo kafɔɔ kobuɛ alɛ Yaa Ɔlaa Buɛtɛtɛ Elia fale. Fiɛ baawo kafɔɔ kobuɛ alɛ Yeremia ee Yaa ɔlaa buɛtɛtɛ bamba owo fale.” ");
INSERT INTO snw_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ninfɛ di Yesu lakaalɛ ma alɛ, “Ni aye mɔ? Owe biobuɛ bilɛ nle?” ");
INSERT INTO snw_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ninfɛ di Simon Petro ladiki kanya alɛ, “Afɔ ninle Kristo nwu nkpo nɛ, Yaa wɔ ninkpe ni nkpa Obi.” ");
INSERT INTO snw_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ninfɛ di Yesu latɔkɔ nwɔ alɛ, “Yaa ntoowii fɔ lɛyɔɔ, Simon, Yona obi. Diekye diele otii kuonwii niediki nle mmle eetuo fɔ, kafɔɔ Teemi wɔ ninkpe ni di osi niediki eetuo fɔ. ");
INSERT INTO snw_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nkpo oso kɔtɔkɔ fɔ nlɛ afɔ ninle Petro di lɛsɔdiki ninle ni difuɔnkpaa. Difuɔnkpaa le mmle suoto kamatofo bafũbanutɛ nii dikudi nɛ. Bia kukpi osie dilɔbafuo ma olenkee. ");
INSERT INTO snw_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Kamayɔ Yaa sɛka kalekɔ osie nta fɔ. Lɛsaa lele feenii kaasɔ ka mmle suoto yi, Yaa kafɔɔ manii ni di osi. Lɛsaa lele kafɔɔ feefukuti di kasɔ ka mmle suoto yi, Yaa kafɔɔ mafukuti ni di osi.” ");
INSERT INTO snw_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ninfɛ di Yesu lakpee basaateketetɛ nɔɔ kufiofa alɛ, “Bitantɔkɔ otii kuonwii bilɛ ami ninle Kristo nwu.” ");
INSERT INTO snw_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Diayɔ ni di obe nwu nkpo kamɛ, Yesu lakye kasɔ aatɔɔtɔkɔ basaateketetɛ nɔɔ nwu nkpo alɛ, “Dikpe ni lɛkyɛ Yerusalem lɛlaafe diibuo kpinwu kamɛ di okpoo banɔɔfo ku oleɔta banɔɔfo ku kufiofa batuotɛ nnɛɛ kamɛ. Babalo mi, kafɔɔ dii tiɛfa Yaa masɛnkɛsɛɛ ankyeko bakpi kamɛ nsiɛ nkpa.” ");
INSERT INTO snw_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ninfɛ di Petro lakpaa Yesu aasifiko ɔlɔɔkɔ aalaasĩ ɔlaa aatɔɔ, ni aatɔkɔ nwɔ alɛ, “Saate, Yaa ata nle mmle dikyɛ di okyo. Diidii nle mmle dilabawafɔ di suoto!” ");
INSERT INTO snw_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesu lamunikĩi aatɔkɔ Petro alɛ, “Abonsam, kyɛ mi di ɔlɔɔkɔ fasifi! Fale disukutĩisaa fɛɛtɛɛ, diekye disibu le fakle ni yi, diele Yaa nfũ diekye. Otii disibu dile.” ");
INSERT INTO snw_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Nfa nfɛ di Yesu latɔkɔ basaateketetɛ nɔɔ alɛ, “Nse otii owo komiɛ alɛ awa abatikankoe, ni dikpe nii ansĩ suoto nɔɔ, an-yɔ aatoo nɔɔ, antikankoe. ");
INSERT INTO snw_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Diekye otii lele nikomiɛ alɛ ata nkpa nɔɔ, abayu mi, kafɔɔ otii lele nieyu nkpa nɔɔ ta ami oso yi, nwaako abawɛ mi. ");
INSERT INTO snw_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Obe nfasũ di otii mawɛ nse ɛɛwɛ kayi ka mmle asaa amuu eeyu nkpa nɔɔ? Ee lɛsaa lewo nkpe di otii kafuo ni ɔyɔ ɔkyɛlɛnsa ofũ nkpa nɔɔ? ");
INSERT INTO snw_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Diekye Otii Obi nwu nkpo kamawa di Ote lɛkpa kamɛ ku Yaa batɔkyɛntɛ nɔɔ, abata otii biala koto di nkpa nɔɔ be eesiɛ ni kanya. ");
INSERT INTO snw_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nwaako kɔtɔkɔ ye nlɛ, batii bawo nsi ye kaamɛ ninfũ, blɔwa ɔbakpi fiɛ babanya Otii Obi nwu nkpo kɔwa fɛ ɔka.” ");
INSERT INTO snw_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ayi akuɔ sɛmaa, Yesu lakpaa Petro, Yakobo ku obilɛma suɔtɔbi Yohane baasifi kobokote takale kunwii osi. Ni baalaasiɛ ninfa lete lɛma nɛ. ");
INSERT INTO snw_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Di obe wɔ baasiɛ ni ninfa, baanya nii, Yesu letembi ntookyi. Anu nɔɔ lakpa fɛle kufĩ, awu nɔɔ kafɔɔ lapu aatoosese di anu. ");
INSERT INTO snw_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ninfɛ di basaateketetɛ nwu nkpo batiɛ lanya Mose ku Elia bɔɔkakatɛko Yesu nɛ. ");
INSERT INTO snw_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Nioso Petro latakatɛsa sɛlɔ katoo aatɔkɔ Yesu alɛ, “Saate, diɛtɛ dilɛ alɛ buɔwa nfũ! Nse feetuna yi, mapɛ akpanta atiɛ. Alefɔ anwii, Mose ale anwii, Elia ale kafɔɔ anwii.” ");
INSERT INTO snw_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Di obe wɔ ayɛ ɔɔkakatɛ ni yi, dituntũ le niɛkpa ni lawa diabafukuti diatĩi ma di suoto. Ni sɛɛlɔ ladie diituntũ nwu kamɛ siabuɛ alɛ, “Obi nii bɔmbɔtɛ ninle nwɔ mmle nɛ. Nintuna nwɔ di suoto, oobuo mi anu nwaa. Bikyɔɔ nwɔ atoko!” ");
INSERT INTO snw_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Di obe wɔ baasaateketetɛ batiɛ nwu nkpo lanu ni sɛlɔ se mmle yi, lɛyɛkɛ lapɛ ma osie kanya, ni baafuusa anu kaasɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ni di Yesu lakple aawa ɔkyɛ lɛma abakpanko ma aatɔkɔ ma alɛ, “Bitaka! Bitanyɛkɛ!” ");
INSERT INTO snw_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ninfɛ baatakatɛsa anu katoo nɛ, batasinya otii kuonwii dilenkee Yesu lete. ");
INSERT INTO snw_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Di obe wɔ nfɛ boosoo mankye ni kobokote nwu nkpo suoto manwa nii, Yesu lakpee ma kufiofa alɛ, “Bitantɔkɔ otii kuonwii dituosaa le beediki beetuo ye ni ninfũ, diɛlaase di obe wɔ bɛɛtakatɛsa ni ami, Otii Obi nwu nkpo, beekyeko ni bakpi kamɛ.” ");
INSERT INTO snw_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ninfɛ di basaateketetɛ nwu nkpo lakaalɛ Yesu alɛ, “Ni obe oso di kufiofa batuotɛ labuɛ alɛ dikpe ni Elia lelekatũ ɛɛwa fiɛ di asaa ya mmle lɛwa kaanya?” ");
INSERT INTO snw_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ninfɛ di Yesu ladiki kanya aabuɛ alɛ, “Nwaako dile alɛ Elia lelekatũ ɛɛwa ɛɛba lololaa lɛsaa biala ɛɛtɛ. ");
INSERT INTO snw_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Kafɔɔ kɔtɔkɔ ye nlɛ Elia ntɔɔwa kofokofoko, kafɔɔ batii diɛnyɔɔ batɛ nsũ, ni baabla nwɔ amumu fɛ mmle dilɛ ma ni nɛ. Nkpo okle kafɔɔ bababla Otii Obi nwu amumu nɛ.” ");
INSERT INTO snw_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ninfɛ di basaateketetɛ nwu nkpo latofo alɛ Yaa Ntu Kpeesatɛ Yohane suoto ɔɔkakatɛtɛ anta ma nɛ. ");
INSERT INTO snw_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Di obe wɔ di Yesu ku basaateketetɛ nɔɔ lasoo baabadu ni batii dikudi nwu nkpo nfũ yi, osuɔtɔ onwii lawa Yesu nfũ aabapɛ akunkyi kaatũ nɔɔ. ");
INSERT INTO snw_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Ni aatɔkɔ Yesu alɛ, “Saate, nya obi nii suɔtɔbi wɔ mmle nyaami. Kakpibubu nsi nwɔ kɔɔnwɔtɔ nwɔ osie kanya. Obe lele ɔɔnɔɔ ambuo di ntu ku ɔtɔ kamɛ. ");
INSERT INTO snw_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Lɛkpaa nwɔ lɛwako basaateketetɛ lɛfɔ, kafɔɔ baafuo nwɔ ofiɛ ɔnyɔɔsa.” ");
INSERT INTO snw_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ninfɛ di Yesu ladiki kanya alɛ, “Aye miɛ akyɛnfɔɔle, be oso minoofũ mi binu, bikpe otokopĩ nkpo? Ɔmɛmbe okle kakpee otu nnanfi ye nnaase? Namasiɛ ye di ɔkyɛ obe lele! Bikpaa obisɔ nwu nkpo biwakoe ninfũ!” ");
INSERT INTO snw_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ninfɛ di Yesu lasĩ ɔlaa aata ninwuna kpile le niasiɛ ni di obisɔ nwu nkpo kamɛ, ninfɛ diadie nɛ. Nfanwu ni di ofiɛ nwu nkpo layɔɔ nwɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ninfɛ di basaateketetɛ nwu nkpo lawa Yesu nfũ babakaalɛ nwɔ buɛɛ alɛ, “Be oso munanfuo ninwuna kpile nwu nkpo otososa odiki?” ");
INSERT INTO snw_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ni di Yesu ladiki kanya alɛ, “Diekye ofũ onu lee diɛpɔ. Nwaako kɔtɔkɔ ye nlɛ, nse ofũ onu lee nte fɛ alesaa kubi biibii yɛntɛle yi, biafuo kobokote takale ko mmle ɔtɔkɔ bilɛ, ‘Taka ninfũ fasifi kamaa nwu falaayila!’ Kubasifi. Lɛsalɛsaa kuninwii ɔbla dilaba lenkee ye! ");
INSERT INTO snw_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Nse diele kanya onii ku ɔlaa ɔpɛ ɔta Yaa, bilaafuo ninwuna le mmle okle otososa odiki.” ");
INSERT INTO snw_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Di obe wɔ baasaateketetɛ nwu nkpo bamuu labasi ni di Galilea yi, Yesu latɔkɔ ma alɛ, “Babayɔ Otii Obi nwu nkpo mankpee di batii nnɛɛ kamɛ. ");
INSERT INTO snw_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Babalo nwɔ, kafɔɔ dii tiɛfa, Yaa makple ansɛnkɛsa nwɔ ankyeko bakpi kamɛ.” Nioso, basaateketetɛ nwu nkpo labuo nyaami. ");
INSERT INTO snw_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Di obe wɔ di Yesu ku basaateketetɛ nɔɔ lababuo ni Kapernaum, Yuda batii Olekatakɔ ato bafuntɛ labakaalɛ Petro alɛ, “Saatuotɛ lee kafɔɔ nta Olekatakɔ koto nwu nkpo?” ");
INSERT INTO snw_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ninfɛ di Petro ladiki kanya alɛ, “Be Oso. Anta!” Nkpo oso obe wɔ di Petro lakyɛ aalaabuo ni leyo, ni di Yesu lalekatũ aakaalɛ nwɔ alɛ, “Simon, lɛfɛɛnya? Bawe dikpe ni bɛɛta akpooto ku kale ato bɛɛta kayi ka mmle baka? Kale babi ɛɛ, sɛɛ bafɔɔ?” ");
INSERT INTO snw_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ninfɛ di Petro ladiki kanya alɛ, “Bafɔɔ.” Ninfɛ di Yesu labuɛ alɛ, “Dilɛ. Nse dinaa alɛ kale babi kata fiɛ! ");
INSERT INTO snw_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Kafɔɔ noomiɛ nlɛ buwolaa batii ba mmle kaanya, tɔɔkyɛ lekpo nwu nkpo kotoko falaataa dadiwa. Kakpaku ka kasale fabadiki ni yi, nyu ka kanya kamɛ, fabanya koto kowo nimawo ni ami ku kole ye fanta ni Olekatakɔ nwu koto. Diki koto nwu, faayɔ falaata koto ko busiko ma ni.” ");
INSERT INTO snw_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Di obe nwu nkpo kamɛ yi, basaateketetɛ nwu nkpo lawa Yesu nfũ babakaalɛ nwɔ alɛ, “Owe ninle otii finle di Yaa sɛka kalekɔ?” ");
INSERT INTO snw_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ninfɛ di Yesu lalɛɛ obisɔ biibii onwii aabayila ma di anu nɛ. ");
INSERT INTO snw_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ni aatɔkɔ ma alɛ, “Nwaako kɔtɔkɔ ye ntikiti nlɛ, nse biekyisa letembi lee bite fɛ babisɔ yi, diidii, bilababuo Yaa sɛka kalekɔ nwu nkpo. ");
INSERT INTO snw_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Otii wɔ niefũ kɔya alenke ni di Yaa sɛka kalekɔ nwu nkpo ninle, otii wɔ niɛwakosa ni suoto kasɔ, eekyi eete fɛ obisɔ wɔ mmle okle. ");
INSERT INTO snw_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Otii wɔ nimafũ ni obisɔ biibii wɔ mmle okle di leyooto nii kamɛ yi, ami eefũ. ");
INSERT INTO snw_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Nse Otii owo lɛta alɛ babisɔ ba mmle nwu nkpo onwii lɛma leyu ofũ onu nɔɔ kaamɛ nii, nse bɔɔyɔ kukuɔ dibinte beenii bɛɛsakasa nwɔ siimu beesoosa nwɔ beekpee di lekpo kakyofolekɔ ɛɛmɛ ntu eekpi yi, dibalɛ nwɔ ninlenkee. ");
INSERT INTO snw_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Kayi ka mmle batii bayɔɔsa di asaa ya nimata batii n-yu ni ofũ onu lɛma. Asaa nwu nkpo nnya obe lele abawa. Kafɔɔ otii wɔ suoto abafe anwa nii, ayɔɔsa! ");
INSERT INTO snw_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Nkpo oso nse kɔnɛɛ lɛfɔ, ee kɔkpaa lɛfɔ mata alɛ fambla okpile yi, faabudi kũ fayu. Dilɛ dilenke alɛ faayɔ kɔnɛɛ kunwii ee kɔkpaa kunwii fambuo di nkpa nwu kamɛ, alɛ faawɛ nnɛɛ nnyɔ ee nkpaa nnyɔ, man-yɔ fɔ manfuki mankpee di kawɔɔ ɔtɔ wɔ ninnaa ni kaloo kamɛ. ");
INSERT INTO snw_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Nse kafɔɔ, ninu lɛfɔ nikɔta fɔ fambla okpile yi, faadiki ni fayu. Diekye dilɛ dilenke alɛ, faayɔ ninu ninwii fambuo nkpa nwu nkpo kamɛ alɛ, faawɛ anu anyɔ man-yɔ fɔ manfuki mankpee di kawɔɔ ɔtɔ wɔ ninnaa ni kaloo kamɛ. ");
INSERT INTO snw_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Bilolaa binyu nwaa bilɛ bienyu babisɔ wɛkyɛ wɛkyɛ ba mmle nwu nkpo bilɛ baadie lɛsalɛsa di anu lee. Diekye nwaako kɔtɔkɔ ye ntikiti nlɛ, bakpe Yaa batɔkyɛntɛ ba nin-yɛ ni di Teemi wɔ ninkpe ni di osi anu obe lele. ");
INSERT INTO snw_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Diekye ami, Otii Obi nwu, lɛwa nlɛ kɔmadiki batii ba nieyu nii, nta ma nkpa. ");
INSERT INTO snw_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Lɛ biɛnya, nse otii nkpe bafoso kɔlafa di onwii leyu kaamɛ, ɔlabadiɛ afosi anaasĩ banaasĩ ba niebu ni koobokote osi batoole alesaa asifi alaawolaa onwii nwu nkpo nieyu ni? ");
INSERT INTO snw_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nwaako nse ɛɛnyɔɔ yi, abanya suoto lɛyɔɔ di onwii nwu nkpo suoto anlenkee afosi anaasĩ banaasĩ nwu nkpo niebu nii. ");
INSERT INTO snw_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Nkpo okle kafɔɔ di Teeye wɔ ninkpe ni di osi yi, oloomiɛ alɛ babisɔ ba mmle wɛkyɛ wɛkyɛ onwii lɛma ayu nɛ. ");
INSERT INTO snw_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Nse ofũonutɛ wo lɛfɔ lɛbla fɔ okpile yi, kyɛ ɔkyɛ nɔɔ falaadiki okpile wɔ ɛɛbla fɔ ni fatuo nwɔ. Faata ɔlaa nwu kusiɛ di batii lee banyɔ ntɛɛ lete. Nse eenu fɔ kasɔ yi, ni minko nwɔ kasiɛ ntookple kɛɛlɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Kafɔɔ nse aanu fɔ kasɔ yi, ni faamiɛ otii onwii ee banyɔ fakyakaa di suoto biɛkyɛ, baanuko fɔ ɔlaa nwu nkpo fɛle kamaa bayilatɛ, fɛ mmle okle bɛɛkpana ni Kɔɔkpana Klekle Kukũ kamɛ. ");
INSERT INTO snw_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Nse mma kafɔɔ aanu ma kasɔ yi, ni faata ɔlaa nwu kudu bafũbanutɛ ba ninkpe ni kaasiisakɔ nwu nkpo. Nse aanu kasiisakɔ nwu nkpo batii kafɔɔ kasɔ yi, ni faadiɛ nwɔ fɛle otii wɔ ninanfũ anu ni ee kpileblatɛ wɔ ninayikyisa ni nkpa. ");
INSERT INTO snw_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Nkpo oso kɔtɔkɔ ye nlɛ, lɛsaa lele bienii kaasɔ ka mmle suoto, Yaa n-yɛ ye kamaa di osi. Lɛsaa lele kafɔɔ biefukuti di kasɔ ka mmle suoto, Yaa n-yɛ ye kamaa di osi. ");
INSERT INTO snw_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Kokple ntɔkɔ ye kafɔɔ nlɛ, nse batii lee banyɔ biɛbla kanya kanwii lɛsaa lele suoto kaasɔ ka mmle, biɛkaalɛ, Teemi wɔ ninkpe ni di osi mabla anta ye. ");
INSERT INTO snw_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Diekye kakɔ lele batii banyɔ ee batiɛ lɛbla onwii leeyooto nii kamɛ, nsi ma nintɛɛ.” ");
INSERT INTO snw_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ninfɛ di Petro lawa Yesu nfũ aabakaalɛ nwɔ alɛ, “Saate, nse owo nii kɔbla okpile di suoto nii, sɛsɛ kayɔ nkyɛ nwɔ? Sikuɛnsĩ ɛɛ, sɛɛ lɛ?” ");
INSERT INTO snw_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ninfɛ di Yesu latɔkɔ nwɔ alɛ, “Diele nkpo! Kafɔɔ faayɔ fankyɛ nwɔ afosi akuɛnsĩ, sikuɛnsĩ. ");
INSERT INTO snw_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Nle mmle oso Yaa sɛka kalekɔ nte fɛ Ɔka wɔ ninkomiɛ alɛ ablako ni batii nɔɔ ba nikɔblako nwɔ ni ɔkpɛ nkuntaa. ");
INSERT INTO snw_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Di obe wɔ aanya aakye ni kasɔ, ni baakpaa osuɔtɔ onwii ninsiko nwɔ ni koto kpinwu baawako ɔkyɛ nɔɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Di obe wɔ di osuɔtɔ nwu nkpo nnaa lɛsalɛsaa abayɔ anta ni koto nwu oso, Ɔka nwu nkpo labuɛ alɛ, bayɔ nnwɔɔ ku ɔsɔfɔ nɔɔ ku babi ku lɛsaa biala ninkpe nwɔ basunsu bata koto nwu nkpo. ");
INSERT INTO snw_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Ninfɛ di osuɔtɔ nwu nkpo lapɛ akunkyi di Ɔka nwu nkpo katũ aatikiti nwɔ lekoto osie kanya alɛ, ‘Wɛ otu fatɛɛ, mata koto nwu nkpo kumuu!’ ");
INSERT INTO snw_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Osuɔtɔ nwu nkpo ɔlaa lakpɛ Ɔka nwu nkpo nyaami, nkpo oso aayɔ koto nwu nkpo aakyɛ nwɔ, aadiɛ nwɔ aasifi. ");
INSERT INTO snw_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Di osuɔtɔ wɔ mmle ladie aasifi nii, ni aakyɛ aalaakyakako kpɛntɛ wo nɔɔ wɔ ninsiko nwɔ ni koto kafuii nɛ. Ninfɛ di osuɔtɔ wɔ mmle lamufũ kpɛntɛ wo nɔɔ nwu nkpo siimu osie kanya aatɔkɔ nwɔ alɛ, ‘Tɛɛ koto nii ko kumuu fasikoe ni!’ ");
INSERT INTO snw_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Ninfɛ di kpɛntɛ wo nɔɔ nwu nkpo latikiti nwɔ lekoto aatɔkɔ alɛ, ‘Wɛ otu fatɛɛ, mata fɔ koto nwu nkpo komuu!’ ");
INSERT INTO snw_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Kafɔɔ aasĩ, ni aata baakpaa kpɛntɛ wo nɔɔ nwu nkpo baalaatɛ leeyo alɛ diediki ɛɛta koto nwu nkpo kumuu fiɛ baadiɛ nwɔ. ");
INSERT INTO snw_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nkpo oso, obe wɔ di bakpɛntɛ bamba lanya ni lɛsaa le di osuɔtɔ nwu nkpo labla nii, suoto ditayɔɔ ma ni baasifi baalaatɔkɔ Ɔka nwu nkpo lɛsaa le di osuɔtɔ nwu labla ni fɛɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Nkpo oso Ɔka nwu nkpo lakpee baalaalɛɛ osuɔtɔ nwu baawako nwɔ ni aatɔkɔ nwɔ alɛ, ‘Otii kpile fale. Di obe wɔ faatikiti mi ni lekoto, layɔ koto ko kumuu fasikoe nii lɛkyɛ fɔ. ");
INSERT INTO snw_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nse nkpo okle dikpe ni afɔɔ fan-yɔ fankyɛ kpɛntɛ wo lɛfɔ nwu fɛ mmle okle lanya fɔ ni nyaami nɛ.’ ");
INSERT INTO snw_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Nni nkpo oso ɔblɔ lafiɛ Ɔka nwu nkpo osie kanya, ni aata alɛ bakpaa osuɔtɔ nwu nkpo balaatɛ leeyo, baananfi nwɔ kootoko dilaase di obe wɔ ɛɛta ni koto nwu nkpo kumuu.” ");
INSERT INTO snw_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ninfɛ di Yesu layɛntɛ ɔlaa nwu alɛ, “Nkpo okle di Teemi wɔ ninkpe ni di osi mabla aye ba ninan-yɔ bikyɛ ni bafũbanutɛ wo lee di situ lee kamɛ nɛ.” ");
INSERT INTO snw_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Obe wɔ di Yesu labuɛ sɛlaa se mmle simuu aaloo nii, ninfɛ aadie di Galilea aasifi Yudea ntɛɛ nwu di Yordan okle sɛmaa nɛ. ");
INSERT INTO snw_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ni baatii dikudi ninwii kpinwu latikanko nwɔ nɛ, ni aayɔɔsa bamuu lɛma sifiɛ ninfa nɛ. ");
INSERT INTO snw_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ninfɛ di Farisi batii bawo lawa nwɔ ɔkyɛ baabawolaa nwɔ kaanya nɛ. Ni baakaalɛ nwɔ alɛ, “Mose kufiofa lɛta osuku alɛ osuɔtɔ kafuo ɔsɔfɔ osĩ di lɛsaa lele suoto?” ");
INSERT INTO snw_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ni di Yesu ladiki kanya alɛ, “Biika di Kɔkpana Klekle Kukũ kamɛ alɛ, kaasɔ kakyekɔ osuɔtɔ ku ɔsanko di Yaa labla? ");
INSERT INTO snw_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ninfɛ di Yaa labuɛ alɛ, ‘Nle mmle oso, osuɔtɔ madie di ote ku ɔya suoto ansifi manko ɔsɔfɔ nɔɔ manaabla onwii, banyɔ lɛma mankple suoto sina sinwii.’ ");
INSERT INTO snw_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nle mmle oso, baasinle batii banyɔ, kɔfɔɔ otii onwii nfɛ bale. Nkpo oso, dinaa alɛ otii lɛblasa lɛsaa le di Yaa ntoomufũ ɛɛbla ninwii.” ");
INSERT INTO snw_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ninfɛ di Farisi batii nwu nkpo lakaalɛ nwɔ alɛ, “Ni be oso di Mose lata osuku alɛ, osuɔtɔ kafuo ɔsɔfɔ kusinkũ ɔta ansĩ nwɔ antɔɔ ansifi?” ");
INSERT INTO snw_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ni di Yesu ladiki kanya alɛ, “Mose lata ye osuku alɛ biasĩ ɔsanko ta otokopĩ lee oso. Kafɔɔ kaasɔ kayekɔ di Yaa labla ni kayi yi, ditate nkpo. ");
INSERT INTO snw_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Kafɔɔ nunua kɔtɔkɔ ye nlɛ, nse osuɔtɔ owo lesĩ ɔsɔfɔ ninanle asɔnɔ eekpee, eekple ɛɛlaayɔ ɔsanko bamba, atookpee asɔnɔ.” ");
INSERT INTO snw_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ninfɛ di Yesu basaateketetɛ latɔkɔ nwɔ alɛ, “Nse nkpo dite di ɔsa ku ɔsɔfɔ ntɛɛ, ni diɛlɛ alɛ, baayɔ bawo.” ");
INSERT INTO snw_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ni di Yesu latɔkɔ ma alɛ, “Diele otii lele nimafuo asaa otuo ya mmle ofũ, diediki otii wɔ di Yaa lɛyɔ ɛɛta ni lete. ");
INSERT INTO snw_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Diekye lɛsaa le oso di basuɔtɔ bawo nle ni balɛma nkpe ate ate. Bawo yi, nkpo bɛɛtɛ beelofo ma nɛ. Bawo kafɔɔ yi, batii niɛbla nkpo. Fiɛ baawo kafɔɔ mma bamu niɛbla suoto balɛma, ta Yaa sɛka kalekɔ ɔkpɛ nwu oso. Otii wɔ nimafuo ni nle mmle ɔbla yi, aabla.” ");
INSERT INTO snw_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Batii bawo lakpaa babisɔ baawako Yesu Nfũ alɛ atika ma nnɛɛ di suoto aapɛ ɔlaa ata Yaa diisi lɛma. Kafɔɔ basaateketetɛ lasĩ ɔlaa baata batii nwu nkpo. ");
INSERT INTO snw_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ninfɛ di Yesu latɔkɔ basaateketetɛ nwu nkpo alɛ, “Bita babisɔ bawa ɔkyɛ nii, bitantũi ma osuku. Diekye batii fɛ babisɔ ba mmle okle kale ninle Yaa sɛka kalekɔ nwu nkpo.” ");
INSERT INTO snw_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Yesu layɔ kɔnɛɛ aatika ma di suoto aapɛ ɔlaa aata Yaa diisi lɛma, nni kamaa, ni aasifi aadiɛ ma nɛ. ");
INSERT INTO snw_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Dii ninwii osuɔtɔ onwii lawa Yesu ɔkyɛ aabakaalɛ nwɔ alɛ, “Saatuotɛ, lɛmɛnsaa biene kabla fiɛ di Yaa katɛɛ nkpa be ninnaa ni kaloo?” ");
INSERT INTO snw_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ninfɛ di Yesu ladiki kanya alɛ. “Be oso fɔɔkaalɛ mi ɔlaa fankyeko lɛsaa biene ɔbla suoto? Yaa lete ninle otii biene. Nse foomiɛ falɛ fawɛ nkpa be ninnaa ni kaloo yi, ni faale afiofa nɔɔ nwu nkpo.” ");
INSERT INTO snw_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ni di osuɔtɔ nwu nkpo lakaalɛ nwɔ alɛ, “Kɔmɛnfiofa?” Ni di Yesu latɔkɔ nwɔ alɛ, “Tanlo otii, tankpee asɔnɔ, tan-yu, tanyila sɛlaa kuafunu kamaa, ");
INSERT INTO snw_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","bu teefɔ ku yaafɔ, bɔmbɔ owo lɛfɔ, fɛ mmle okle fambɔmbɔ ni suoto lɛfɔ.” ");
INSERT INTO snw_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ninfɛ di okosopo nwu nkpo latɔkɔ Yesu alɛ, “Ntoole afiofa ya mmle amuu. Lɛsaa lewo lebu kakple mbla ni?” ");
INSERT INTO snw_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu latɔkɔ nwɔ alɛ, “Nse foomiɛ falɛ fawo nimu yi, tɔɔkyɛ flaayɔ asaa ya amuu ninkpe fɔ ni fasunsũ, faayɔ koto nwu nkpo fata bapiitɛ, ni fabakple saawɛntɛ di Yaa kafa. Nni kamaa, faawa fabatikankoe.” ");
INSERT INTO snw_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Obe wɔ di okosopo nwu nkpo lanu ni ɔlaa wɔ mmle yi, suoto ditayɔɔ nwɔ, ni aasifi nɛ. Diekye saawɛntɛ aale osie kanya. ");
INSERT INTO snw_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ninfɛ di Yesu latɔkɔ basaateketetɛ nɔɔ alɛ, “Nwaako kɔtɔkɔ ye nlɛ, dibawɛ osie fiɛ di basaawɛntɛ makyɛ Yaa sɛka kalekɔ nwu nkpo. ");
INSERT INTO snw_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kokple nse ye lɛtɔkɔ kafɔɔ nlɛ, diɛtɛ diɛyɔɔ diɛta kapupɔnkɔ alɛ aafe di paniɛ dituɛ kamɛ, dilenke alɛ saawɛntɛ kabuo Yaa sɛka kalekɔ nwu nkpo.” ");
INSERT INTO snw_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Di obe wɔ baasaateketetɛ lanu ni ɔlaa wɔ mmle diatɛ diabla ma ɔkpɛ. Nkpo oso baakaalɛ alɛ, “Ni se nkpo kute mɔ, owe nfɛ babata nkpa be ninnaa ni kaloo?” ");
INSERT INTO snw_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ninfɛ di Yesu layu ma di anu tuwĩi aatɔkɔ ma alɛ, “Otii kuonwii dilabafuo nle mmle ɔbla. Kafɔɔ Yaa nnwɔɔ lɛsalɛsaa nnaa nwɔ osie ku ɔbla.” ");
INSERT INTO snw_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ninfɛ di Petro lakakatɛ aabuɛ alɛ, “Nyu lo! Buodiɛ lɛsaa loo biala buɔtɛ butikanko fɔ. Ni be bubawɛ?” ");
INSERT INTO snw_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu latɔkɔ ma alɛ, “Nwaako kɔtɔkɔ ye nlɛ, nse Otii Obi nwu nkpo lɛbasiɛ di lɛkakpomii nɔɔ suoto, leeklekle kamɛ, di kayi fɔle ka nikɔwa ni kamɛ, aye lefosi batii banyɔ ba nintikankoe nii, ayee bibasiɛ di akakpomii suoto minkanko Israel batii, lefosi nfaabi nnyɔ nwu nkpo. ");
INSERT INTO snw_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Otii lele kafɔɔ niediɛ ayo ee babilɛma suɔtɔbi ee babilɛma sankobi ee ote ee ɔya ee babi ee afe ɛɛtɛ ta ami oso, abawɛ nya akyuu kɔlafa anlenkeesa bia. Yaa matɔɔ kafɔɔ nkpa be ninnaa ni kaloo. ");
INSERT INTO snw_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Kafɔɔ batii ba kpinwu ninle ni batunletɛ, makple bamaakpitɛ. Bamaakpitɛ kafɔɔ makple batunletɛ. ");
INSERT INTO snw_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Yaa sɛka kalekɔ nte fɛ nle mmle okle. Obe onwii kamɛ, osuɔtɔ onwii lataka ku kolesɛtũ alɛ, ɔlaamiɛ batii bawo manaabla dii kufĩ ɔkpɛ di awosobi ya mambla ni nta kofe mantɔɔ. ");
INSERT INTO snw_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Kofe saate nwu nkpo ku bakpɛntɛ nwu lale ɔkpɛ nwu kɔya. Lɛsɔnu lawa diatɔɔ alɛ abata ma dii kɔkpɛnto koto fututu kunwii. Ni aakpaa ma aasifiko kofe nwu nkpo nɛ. ");
INSERT INTO snw_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Di obe wɔ diapɛ ni abombo anaasĩ, osuɔtɔ nwu nkpo lakple aadie aakyɛ lɛkpaka, aalaanya basuɔtɔ bawo n-yɛ ninfa blɔbla lɛsalɛsaa. ");
INSERT INTO snw_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Nkpo oso, aatɔkɔ ma alɛ, ‘Aye kafɔɔ bitɔɔkyɛ kofe nii bilaabla ɔkpɛ, mata ye koto ko niesiɛko ni ɔkpɛ nwu.’ ");
INSERT INTO snw_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Nkpo oso baasifi kofe nwu nkpo. “Aakple aadie aakyɛ lɛkpaka di abombo lefosi anyɔ ku abombo atiɛ kamɛ aalaabla nkpo kafɔɔ. ");
INSERT INTO snw_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ditoobu kɛkɛɛ di abombo anɔɔ kapɛ nii, aakple aadie aakyɛ lɛkpaka, ni aalaanya basuɔtɔ bamba bawo n-yɛ ninfa. Ni aakaalɛ ma alɛ, ‘Be niɛwa fiɛ biɛlalaasa dii kufĩ kumu minambla ɔkpɛ kuonwii?’ ");
INSERT INTO snw_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Ninfɛ baatɔkɔ nwɔ alɛ, ‘Otii kuonwii diɛwa abayɔ wo alɛ bubabla ɔkpɛ.’ “Ninfɛ aatɔkɔ ma alɛ, ‘Ni bitɔɔkyɛ kofe nii biɛlaabla ɔkpɛ.’ ");
INSERT INTO snw_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Obe wɔ kɔɔtɔɔfɔ lawo nii, ni koofe nwu nkpo saate latɔkɔ kofe nwu nyuntɛ alɛ, ‘Lɛɛ bakpɛntɛ nwu nkpo faata ma koto lɛma. Kyekasɔ di mba niɛnyɛntɛ ni ɔwa falaase di bakasale suoto.’ ");
INSERT INTO snw_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Ninfɛ aayɔ koto fututu ninle ni dii kɔkpɛnto kunwii kunwii aata batii ba niawa ni kɔtɔɔfɔ abombo anɔɔ kamɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Nioso obe wɔ diadu ni batii ba niasifi ni kofe nwu nkpo ku olesɛ yi, baanyu alɛ babafũ koto manlenkee bawo lɛma. Kafɔɔ mma kafɔɔ koto nwu nkpo fututu kunwii kunwii baafũ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Di obe wɔ baafũ ni koto nwu nkpo yi, baakyako ɔkakatɛ di kofe nwu nkpo saate suoto alɛ, ");
INSERT INTO snw_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Batii ba mmle niɛwa ni kofe lɛyɛntɛle, lebombo ninwii lete bɛɛbla ɔkpɛ. Awo ba niɛbla ni ɔkpɛ dii nimu, kuufĩ lɛpɛ wo nii, koto nwu kunwii fɛɛta wo!’ ");
INSERT INTO snw_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Ninfɛ di kofe nwu nkpo saate latɔkɔ ma alɛ, ‘Basiɛwo, binu kasɔ, nintafaa ye! Munko ye niele ɔkpɛ kɔya bienu suoto kasɔ bilɛ, bibafũ dii kɔkpɛnto ninle koto fututu kunwii. ");
INSERT INTO snw_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Nkpo oso yi, bifũ koto lee biɛtɔɔkyɛ leyo. Ami omu ninlɛ kɔta batii yɛntɛle ba mmle koto okle lɛta ye nii. ");
INSERT INTO snw_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nkpe osuku mblako koto nii ɔkpɛ mmle okle dilɛ mi nii. Nkpo oso yi, bitanta ɔblɔ lafiɛ ye di sifutulɛ nii se lɛbla ni suoto.’ ” ");
INSERT INTO snw_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ninfɛ di Yesu layɛntɛ alɛ, “Nioso batii yɛntɛle mawa mamale bakasale, bakasale kafɔɔ mawa mamale bayɛntɛle.” ");
INSERT INTO snw_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Di obe wɔ di Yesu ku basaateketetɛ nɔɔ latoofe ni Yerusalem, aalɛɛ ma di ɔlɔɔkɔ. ");
INSERT INTO snw_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Ni aatɔkɔ ma alɛ. “Binu lo! Buofe Yerusalem, nfa babayɔ ami, Otii Obi nwu nkpo mankpee di olebatatɛ banɔɔfo ku kufiofa batuotɛ nnɛɛ kamɛ. Babalo nwɔ kukpi lɛpɔɔ. ");
INSERT INTO snw_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Babayɔ nwɔ mankpee di batii ba ninanle ni Yuda batii nnɛɛ kamɛ, babama nwɔ, babapɛ nwɔ, mampɛ nwɔ sibuɛ mankaasa di kowoso suoto. Kafɔɔ di dii tiɛfa suoto, Yaa masɛnkɛsa nwɔ aakyeko bakpi kamɛ, ansiɛ nkpa.” ");
INSERT INTO snw_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ninfɛ di Sebedeo ɔsɔfɔ lakpaa babi nɔɔ suɔtɔbi banyɔ aawako Yesu nfũ, abapɛ akunkyi kaatũ nɔɔ aatɔkɔ nwɔ alɛ, akyakaako ma. ");
INSERT INTO snw_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ninfɛ di Yesu lakaalɛ nwɔ alɛ, “Be lɛsaa foomiɛ?” Ninfɛ di ɔsanko nwu nkpo latɔkɔ nwɔ alɛ, “Komiɛ nlɛ, fabla fatɛɛ alɛ, nse fɛɛwa sɛka lɛfɔ ole yi, babi nii ba mmle banyɔ yi, onwii masiɛ di oletannɛɛ kyɛ lɛfɔ, onwii kafɔɔ masiɛ di kɔmɛntunnɛɛ kyɛ lɛfɔ.” ");
INSERT INTO snw_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesu latɔkɔ ma alɛ, “Bieye lɛsaa le biɔkaalɛ nii. Bibafuo dibuo le kamanya ni ɔnya?” Ninfɛ baadiki kanya alɛ, “Yii, bubafuo.” ");
INSERT INTO snw_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ninfɛ di Yesu latɔkɔ ma alɛ, “Nwaako, bibafuo. Kafɔɔ nnaa osuku ndiki otii wɔ nimasiɛ ni di oletannɛɛ kyɛ nii ku kɔmɛntu nnɛɛ kyɛ nii. Nsiɛkɔ be mmle nwu nkpo yi, dile batii ba nle di Teemi lelolaa ɛɛtɛ ɛɛta nii.” ");
INSERT INTO snw_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Di obe wɔ di basaateketetɛ lefosi bule lanu ni ɔlaa nwu nkpo yi, ɔblɔ lafiɛ ma osie kanya di basuɔtɔbi nwu nkpo banyɔ ninle ni bawo babilɛma suoto. ");
INSERT INTO snw_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Nkpo oso Yesu lalɛɛ ma aasiisa ni aatɔkɔ ma alɛ, “Biye bilɛ batunletɛ ba nikole ni sɛka di batii ba ninanfũ banu nii, bakpe osie di suoto lɛma mantuo suoto mankpee ma. ");
INSERT INTO snw_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Bitanta diate nkpo okle di kamɛ lee. Nse onwii lee komiɛ alɛ ale ɔnɔɔfo kaamɛ lee yi, ni dikpe ni eele kpɛmblatɛ ɛɛta babule. ");
INSERT INTO snw_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Nse onwii lee kafɔɔ komiɛ alɛ ale ɔkasale yi, ni dikpe ni ɛɛbla suoto fɛ obisɔ ɛɛta babule. ");
INSERT INTO snw_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Nkpo okle kafɔɔ di Otii Obi nwu nkpo diɛwa alɛ batii katɔɔbla sɛkpɛ mantɔɔtɔɔ nɛ. Kafɔɔ nnwɔɔ ɛɛwa alɛ ɔɔbla sɛkpɛ anta batii alɛ aayɔ nkpa nɔɔ kafɔɔ antɛ kaasɔ andiki batii kpi.” ");
INSERT INTO snw_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Di obe wɔ di Yesu ku basaateketetɛ nɔɔ ladie di Yeriko baatoosifi nii, batii dikudi kpinwu latikanko ma. ");
INSERT INTO snw_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Basuɔtɔ banyɔ banwii di anu labiɛ ma ni lasiɛ di osukulɔɔkɔ, ni baanu alɛ Yesu kɔwaalɛ anfe. Ni baakyako ɔfaa osie kanya baabuɛ alɛ, “Ɔka Dawid Obi ee! Nya wo nyaami!” ");
INSERT INTO snw_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Batii dikudi nwu nkpo lasĩ ɔlaa baata banumbiɛtɛ nwu nkpo osie kanya alɛ bamaasa kanya. Kafɔɔ mia nwu nfɛ baatɛ baafaa osie kanya baabuɛ alɛ, “Saate loo! Ɔka Dawid Obi ee! Nya wo nyaami kyu woo!” ");
INSERT INTO snw_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesu layila ni aalɛɛ ma aawako ɔkyɛ nɔɔ, ni aakaalɛ ma alɛ, “Be biomiɛ bilɛ mbla nta ye?” ");
INSERT INTO snw_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ninfɛ baadiki kanya baatɔkɔ nwɔ alɛ, “Ɔnɔɔfo, buomiɛ bulɛ fata wo butɔɔnya.” ");
INSERT INTO snw_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ɔlaa lɛma lakpɛ Yesu nyaami, ni aakpanko ma anu nɛ. Nfanwu ni baakyako ɔnya nɛ. Ninfɛ baatikanko Yesu nɛ. ");
INSERT INTO snw_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Di obe wɔ di Yesu ku basaateketetɛ nɔɔ kɔtɛtɛɛ ni Yerusalem, babadu ni Betfage di Nnɔnyi Awoso Kobokote ɔlɔɔkɔ yi, Yesu lakpee basaateketetɛ nɔɔ banyɔ alɛ balekatũ. ");
INSERT INTO snw_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ni aatɔkɔ ma alɛ, “Bitɔɔkyɛ kakpaayotũ ka ninte ye ni siitũ kamɛ, bibanya bɔkɛɛ wɔ ninte ni fɛ pɔnkɔ antuka ni aatoo beekpee nwɔ okũ, diibi kafɔɔ n-yɛ nwɔ ni di ɔlɔɔkɔ. Bidiki nwɔ di okũ biɛkpaa ma biwakoe. ");
INSERT INTO snw_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nse otii owo lɛkaalɛ ye ɔlaa owo yi, biɛtɔkɔ nwɔ bilɛ, ‘Saate nwu nikomiɛ ma.’ Abakplesa ma kafɔɔ anwako ye nunua.” ");
INSERT INTO snw_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nle mmle lawa kaanya fɛ mmle okle di Yaa ɔlaa buɛtɛtɛ onwii labuɛ aatɛ ni alɛ, ");
INSERT INTO snw_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Bitɔkɔ Sion batii bilɛ, ‘Binyu! Ɔka lee kɔwa ɔkyɛ lee. Ɛɛwakosa suoto kasɔ asi di bɔkɛɛ wɔ nintuka ni atoo ku dibi suoto ɔɔwa.’ ” ");
INSERT INTO snw_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Nkpo oso basaateketetɛ banyɔ nwu nkpo, lakyɛ baalaabla fɛ mmle okle di Yesu lakpee ma alɛ balaabla nii. ");
INSERT INTO snw_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ni baakyɛ baalaakpaa bɔkɛɛ wɔ nintuka ni atoo ku dibi nwu nkpo baawako nwɔ nɛ. Ni baablɛfɛsa abula lɛma baatika di suoto lɛma, ni di Yesu layie aasiɛ ma di suoto nɛ. ");
INSERT INTO snw_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ni baatii kpinwu di batii dikudi nwu nkpo kamɛ latɔtaa siwidi baadiki abula lɛma baatɛ di osuku suoto. Ni baawo kafɔɔ labudi sɛkaafɛ baatɛ di osuku suoto nɛ. ");
INSERT INTO snw_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ninfɛ di batii dikudi le niale Yesu katũ ku mba niakpi ni sɛmaa latɔɔtaa siwidi alɛ, “Bitansa Ɔka Dawid Obi nwu! Yaa lekusɛkusɛsa otii wɔ nikɔwa ni di Saate leyooto kamɛ! Bitansa Yaa!” ");
INSERT INTO snw_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Di obe wɔ di Yesu labuo ni Yerusalem, kudu niamu di okpoo omuu. Ni baatii latɔɔkaalɛ alɛ, “Owe dile?” ");
INSERT INTO snw_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ninfɛ di batii dikudi nwu nkpo labuɛ alɛ, “Yaa Ɔlaa Buɛtɛtɛ Yesu wɔ niekye ni Nasaret di Galilea kasɔ suoto dile!” ");
INSERT INTO snw_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu lakyɛ Yaa Olekatakɔ ni aalaatososa batii ba bamuu niatoosunsu ni asaa ku mba niatɔɔya ni asaa ninfa odiki leeyo nwu kamɛ nɛ. Aatutukusa koto babiɛtɛ siipunu aayu. Aatukusa mba ninsi boosunsu ni ablonuma kafɔɔ akpomii aayu. ");
INSERT INTO snw_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ni aatɔkɔ ma alɛ, “Bɛɛkpana di Kɔkpana Klekle Kukũ kamɛ alɛ, ‘Baalɛɛ mi leyo alɛ ɔlaa ɔpɛ katakɔ.’ Kafɔɔ aye, bitɔɔyɔ biɛbla bayu kawofakɔ!” ");
INSERT INTO snw_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ninfɛ di batii bawo lakpaa banumbiɛtɛ ku abafa baawako nwɔ di Yaa Olekatakɔ nwu nkpo nɛ. Ni di Yesu layɔɔsa ma sifiɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Obe wɔ di olebatatɛ banɔɔfo ku kufiofa batuotɛ lanya sɛkpɛ se niɛbla ni ɔkpɛ aabla nii ku mmle okle di babisɔ latɔɔfaa batoobuɛ di Yaa Olekatakɔ nwu kamɛ alɛ, “Bitansa Ɔka Dawid Obi nwu nkpo” yi, ɔblɔ lafiɛ ma osie kanya. ");
INSERT INTO snw_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Nkpo oso baakaalɛ Yesu alɛ, “Foonu ɔlaa wɔ baabisɔ nwu nkpo kobuɛ ni?” Ni di Yesu ladiki kanya alɛ, “Lenu. N-ye kafɔɔ nlɛ bitɔɔka di Kɔkpana Klekle Kukũ kamɛ alɛ, ‘Fɛɛbla babisɔ ku babifɔɔle alɛ baayɔ katansa ka niewo ni niimu manta fɔ.’ ” ");
INSERT INTO snw_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Di nni nkpo kamaa, Yesu ladiɛ olebatatɛ banɔɔfo nwu nkpo ku kufiofa batuotɛ aadie di okpoo, aasifi Betania, aalaate nfa. ");
INSERT INTO snw_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Obe wɔ kaale ntɔɔsɛ nii, di Yesu ntɔɔpɛ ankple ansifi ni okpoo ku kuolesɛtũ yi, kɔka laklee nwɔ. ");
INSERT INTO snw_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ni aanya kolewoso kunwii di osukulɔɔkɔ nɛ, ni aakyɛ kũ ɔlɔɔkɔ nɛ. Kafɔɔ atanya lɛwosobi kuninwii, dilenkee afata lete. Nkpo oso aatɔkɔ kowoso nwu nkpo alɛ, “Diɛyɔ di miɛ diesifi nii, flabasintika abi diidii.” Nfanwu, kolewoso nwu nkpo niayɔɔ. ");
INSERT INTO snw_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Obe wɔ di basaateketetɛ nwu nkpo lanya ni nle mmle, diabla ma ɔkpɛ osie kanya. Ni baakaalɛ alɛ, “Lɛ diɛbla fiɛ koolewoso ko mmle lefuo ɔyɔɔ nkpo wla?” ");
INSERT INTO snw_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ninfɛ di Yesu ladiki kanya alɛ, “Nwaako kɔtɔkɔ ye nlɛ, nse biefũ bienu siitu lee kamɛ, minanta dibla ye ɔtanfũ onu, bibafuo lɛsaa le lɛbla ni kolewoso ko mmle ɔbla. Diele bia nle mmle lete, kafɔɔ, bibafuo kobokote ko mmle ɔtɔkɔ bilɛ, ‘Taka ninfũ falaabuo di lekpo kamɛ,’ dibawa kaanya. ");
INSERT INTO snw_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Lɛsaa lele biɛpɛ ɔlaa biɛkaalɛ Yaa di ofũ onu kamɛ, bibafũ.” ");
INSERT INTO snw_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu lakple aakyɛ Yaa Olekatakɔ nwu nkpo. Di obe wɔ ootuo ni asaa, ni di Yaa olebatatɛ banɔɔfo ku okpoo banɔɔfo lawa nwɔ ɔkyɛ babakaalɛ nwɔ alɛ, “Ɔmɛnsuku fakpe fɔɔbla asaa ya mmle? Owe kafɔɔ niɛta fɔ osuku nwu nkpo?” ");
INSERT INTO snw_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ninfɛ di Yesu ladiki kanya alɛ, “Bitɛɛ nkaalɛ ye ɔlaa onwii, nse biediki kanya yi, ni amii matɔkɔ ye osuku wɔ nkpe fiɛ kɔbla ni asaa ya mmle nwu nkpo. ");
INSERT INTO snw_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ɔfɛ di Yohane lawɛ osuku fiɛ aatookpeesa batii Yaa ntu? Yaa nfũ kuakye ɛɛ, sɛɛ batii nfũ kuakye?” Ninfɛ baamumufũ ɔlaa nwu nimanima baanyu alɛ, “Be nfɛ buabuɛ? Nse buobuɛ bulɛ Yaa nfũ kuokye yi, abakaalɛ wo alɛ, ‘Ni be oso bitafũ Yohane bianu mɔ?’ ");
INSERT INTO snw_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Kafɔɔ nse buobuɛ bulɛ ‘otii nfũ kuokye’ yi, buɔyɛkɛ bulɛ batii ba mmle mabla wo lɛsaa, diekye bamuu lɛma beefũ beenu alɛ Yohane yi, Yaa ɔlaa buɛtɛtɛ aale.” ");
INSERT INTO snw_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Nioso baatɔkɔ Yesu alɛ, “Buoye.” Ninfɛ di Yesu latɔkɔ ma alɛ, “Nkpo okle kafɔɔ di amii, namatɔkɔ ye otii wɔ niɛtɛɛ ni osuku fiɛ kɔbla ni asaa ya mmle nɛ. ");
INSERT INTO snw_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Bibu ɔlaa wɔ mmle disi binyu. Osuɔtɔ onwii lawɛ babi suɔtɔbi banyɔ banwii. Ni aakyɛ aalaatɔkɔ ɔnɔɔfo le alɛ, ‘Obi, kyɛ falaabla ɔkpɛ koofe nii miɛ.’ ");
INSERT INTO snw_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Ninfɛ di obi nwu nkpo latɔkɔ ote alɛ, ‘Namafuo ɔkyɛ.’ Kafɔɔ sɛmaa, aakyɛlɛnsa disibu nɔɔ, ni aakyɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Ninfɛ di ote nwu nkpo lakyɛ obi nyɔɔfa nfũ, aalaatɔkɔ nwɔ ɔlaa nwu nkpo okle kafɔɔ. Ni aatuna alɛ, ‘Teete lenu, makyɛ.’ Kafɔɔ atakyɛ. ");
INSERT INTO snw_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Di babi ba mmle banyɔ kamɛ, owe niabla ote dibiesaa?” Ninfɛ baatɔkɔ nwɔ alɛ, “Obi nɔɔfo le nwu nkpo.” Ninfɛ di Yesu latɔkɔ ma alɛ, “Nwaako kɔtɔkɔ ye nlɛ, akpooto bafuntɛ ku basɔnɔkpeetɛ makaye Yaa sɛka kalekɔ nwu nkpo obuo. ");
INSERT INTO snw_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Diekye Yaa Ntu Kpeesatɛ Yohane lawa abatuo ye osuku biene wɔ suoto biafe nii, kafɔɔ bitafũ nwɔ bianu. Kafɔɔ akpooto bafuntɛ ku basɔnɔkpeetɛ lafũ nwɔ baanu. Kuntɛ bianya nle mmle, bíekyisa disibu lee bifũ nwɔ binu.” ");
INSERT INTO snw_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesu lakple aatɔkɔ ma alɛ, “Bikple binu lɛkpa bamba. Fekpɛntɛ onwii lakpɛ awosobi ya man-yɔ mambla ni nta kofe, ni aakpee kɔba aakyisa kofe nwu nkpo nɛ. Aabla lɛba le manka ni awosobi nwu nkpo mandiki ni nta. Aatofo lɛba le niataka ni kle, baayila mantoonyu ni kofe nwu. Ninfɛ aayɔ kofe nwu nkpo aakpee di bakpɛntɛ banwii nnɛɛ kamɛ alɛ batoonyu, ni aadie aasifi osuku nɛ. ");
INSERT INTO snw_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Di obe wɔ di awosobi nwu nkpo ɔtɛsɛbee lawo nii, kofe saate nwu nkpo lakpee bakpɛmblatɛ nɔɔ alɛ bakyɛ kofe nwu banyuntɛ nfũ baalaafũ kalekɔ nɔɔ bawako nwɔ. ");
INSERT INTO snw_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Kofe nwu nkpo banyuntɛ lamufũ bakpɛmblatɛ ba mmle, baapɛ onwii, baalo onwii, baasafɔ onwii kafɔɔ afuɔ. ");
INSERT INTO snw_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Nni sɛmaa kofe nwu nkpo saate lakple aakpee bakpɛmblatɛ bamba niapɔ baalenkee ni bakasale. Kafɔɔ kofe nwu nkpo banyuntɛ lakple baabla mankpo kafɔɔ laakpa nwu. ");
INSERT INTO snw_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Lɛyɛntɛle, aakpee ma nnwɔɔ omu nɔɔ obi, aabuɛ alɛ, ‘Lefũ lenu nlɛ babata obi nii nwu dibu.’ ");
INSERT INTO snw_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Kafɔɔ obe wɔ di kofe nwu nkpo banyuntɛ lanya ni obi nɔɔ nwu nkpo yi, ni baatɔkɔ bawo alɛ, ‘Nnya kofe saate obi wɔ nimale ni atesaa ninle nwɔ mmle nɛ. Biwa biɛta bulo nwɔ di atesaa nɔɔ nwu nkpo akple wo ale.’ ");
INSERT INTO snw_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Nioso baamufũ nwɔ baafuki baayu di kɔba nwu nkpo sɛmaa, ni baalo nwɔ nɛ.” ");
INSERT INTO snw_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ninfɛ di Yesu lakaalɛ ma alɛ, “Ni, nse kofe nwu nkpo saate lɛwa mɔ, be bienyu bilɛ ababla kofe nwu nkpo banyuntɛ?” ");
INSERT INTO snw_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ninfɛ baadiki nwɔ kanya alɛ, “Abalo kofe banyuntɛ kpile nwu nkpo an-yɔ kofe nwu ankpee di bayuntɛ bamba nnɛɛ kamɛ, mba nimatɔɔ ni kalekɔ nɔɔ di nta awosobi nwu nkpo ɔtɛsɛbee kamɛ di obe kanya.” ");
INSERT INTO snw_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ni di Yesu lakaalɛ ma alɛ, “Biika di Kɔkpana Klekle Kukũ kamɛ binya? Beebuɛ alɛ, ‘Difuɔ le baayotofotɛ lesĩ alɛ diɛlɛ nii, nni nintɔbakple difuɔ le niefĩ dilenke ni nɛ. Saate niɛbla lɛsaa kplɛ le mmle. Nioso diɛbla wo ɔkpɛ osie kanya!’ ” ");
INSERT INTO snw_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ninfɛ di Yesu latɔkɔ ma alɛ, “Nkpo oso kɔtɔkɔ ye nlɛ, Yaa maklee sɛka kalekɔ nɔɔ nwu nkpo anfũ ye di nnɛɛ kamɛ, an-yɔ anta batii ba nimabla nwɔ ni dibiesaa. ");
INSERT INTO snw_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Otii lele niɛnɔɔ ɛɛpɛ diifuɔ le mmle suoto mafefee kukuii kukuii. Kafɔɔ nse difuɔ nwu nkpo lɛkpa diɛpɛ di otii owo suoto yi, abakuɔ muɛmuɛ.” ");
INSERT INTO snw_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nioso di Olekatakɔ banɔɔfo ku Farisi batii lanu ni Yesu akpa ya mmle yi, baatofo alɛ mma alaka. ");
INSERT INTO snw_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Nkpo oso baamiɛ alɛ boomufũ nwɔ. Kafɔɔ baayɛkɛ batii dikudi nwu nkpo, diekye batii kpinwu lafũ Yesu fɛle Yaa ɔlaa buɛtɛtɛ. ");
INSERT INTO snw_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu lakple aatuo ma asaa di akpa kamɛ aabuɛ alɛ, ");
INSERT INTO snw_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Yaa sɛka kalekɔ nte fɛ nle mmle. Di obe onwii kamɛ, ɔka onwii lale ɔsanko ɔyɔ dii aata obi suɔtɔbi nɔɔ. ");
INSERT INTO snw_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ni aakpee bakpɛmbla nɔɔ alɛ bakyɛ baalaalɛɛ batii ba ɛɛkyaka ni di ɔsanko ɔyɔ nwu nkpo dii kalekɔ bawako. Kafɔɔ baasĩ alɛ bɔlɔɔwa. ");
INSERT INTO snw_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Nkpo oso aakple aakpee bakpɛmblatɛ bamba alɛ balaatɔkɔ batii nwu nkpo alɛ, ‘Dii ole alesaa nwu ntoobe, lelo nankyue suɔtɔ ku obiibii wɔ ninsi ni lɛla, lɛsaa biala ntoosi. Biwa ɔsanko ɔyɔ dii nwu kalekɔ.’ ");
INSERT INTO snw_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Kafɔɔ batii ba baakyakako ni nkpo, kuonwii lɛma ditakyɔɔ lɛlɛɛ nwu kotoko, baasifi sɛkpɛ lɛma mmɛ. Onwii lasifi kofe, onwii kafɔɔ lasifi asaa kasunsukɔ. ");
INSERT INTO snw_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Bawo kafɔɔ lamufũ bakpɛmblatɛ nwu nkpo, baapɛ ma, ni baalo ma nɛ. ");
INSERT INTO snw_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ɔblɔ lafiɛ ɔka nwu nkpo osie kanya ni aakyesee bakpɛtɛ nɔɔ baakyɛ baalaalo batii lotɛ nwu nkpo bamuu, ni baakpee okpoo lɛma nwu nkpo ɔtɔ baawɔɔsa nwu nɛ. ");
INSERT INTO snw_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Ninfɛ aalɛɛ bakpɛntɛ nɔɔ nwu nkpo aatɔkɔ ma alɛ, ‘Obi nii ɔsanko ɔyɔ alesaa nwu nkpo ntoosi, kafɔɔ batii ba lɛkyakako ni diesiɛko dii nwu nkpo kalekɔ. ");
INSERT INTO snw_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Nkpo oso nunua yi, bitɔɔkyɛ akpaka biɛlaalɛɛ batii lele biɛnya bilɛ bawa ɔsanko ɔyɔ dii kalekɔ nwu.’ ");
INSERT INTO snw_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Nioso bakpɛntɛ nwu nkpo ladie baasifi akpaka baalaalɛɛ batii ba bamuu baanya nii, babienetɛ ku bakpiletɛ baawako. Nioso ɔsanko kayɔkɔ nwu nkpo layii pɔ ku batii. ");
INSERT INTO snw_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Ni di ɔka nwu nkpo lawa alɛ ɔɔbaanyu batii ba bɛɛkyakako bɛɛwako ni nfa, ni aanya osuɔtɔ onwii diekpee ɔsanko ɔyɔ awo. ");
INSERT INTO snw_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ni di Ɔka nwu nkpo lakaalɛ nwɔ alɛ, ‘Siɛwo, lɛyiɛbla fiɛ fɛɛwa nfũ fanankpee ɔsanko ɔyɔ awo?’ Kafɔɔ osuɔtɔ nwu nkpo ditafuo kanya odiki. ");
INSERT INTO snw_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Ninfɛ di ɔka nwu nkpo latɔkɔ bakpɛmblatɛ nɔɔ alɛ, ‘Binii nwɔ nnɛɛ ku nkpaa biefuki nwɔ biyu kaayi diitunu nwu nkpo kamɛ. Nfũ kaaku owi ku anyɛɛ owee nkpe ni.’ ” ");
INSERT INTO snw_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ninfɛ di Yesu layɛntɛ ku lɛkpa le mmle alɛ, “Yaa lɛlɛɛ batii kpi, kafɔɔ, basɛɛ eediki kaamɛ.” ");
INSERT INTO snw_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Farisi batii bawo lakyɛ baalaabla disibu mmle okle baayɔ Yesu omu kanya kamɛ ɔlaa manwɛ nwɔ nii. ");
INSERT INTO snw_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Nkpo oso baakpee basaateketetɛ lɛma bawo ku batii ba nintikanko ni Herode baakyɛ Yesu nfũ. Obe wɔ baakyɛ ni ɔkyɛ nɔɔ, baatɔkɔ nwɔ alɛ, “Saatuotɛ, buye bulɛ nwaakotɛ falɛ, fantuo kafɔɔ Yaa ɔlaa nwu ninle ni nwaako ɔlaa, diekye fánnyu batii di anu faabla lɛsaa. Faayɔ nwu ole di batii sɛlaa se mambuɛ ni kafɔɔ. ");
INSERT INTO snw_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Nkpo oso, tɔkɔ wo disibu lɛfɔ. Kufiofa loo lɛta osuku alɛ buata akpooto munta Roma batii Ɔka Nɔɔfo ɛɛ, sɛɛ dinaa alɛ buɔta?” ");
INSERT INTO snw_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Kafɔɔ Yesu latofo disibu kpile le bakle ni di suoto nɔɔ, nioso aatɔkɔ ma alɛ, “Aye anu di anu basaablatɛ! Be oso biɛwa biowolaa mi kaanya? ");
INSERT INTO snw_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Bitɛɛ koto ko min-yɔ mintɔɔta ni akpooto nwu nkpo ninnyu.” Ninfɛ baayɔ koto nwu nkpo baawako nwɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ninfɛ di Yesu lakaalɛ ma alɛ, “Owe kunyii ku leyooto nintika di koto ko mmle suoto?” ");
INSERT INTO snw_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ninfɛ baadiki kanya alɛ, “Ɔka Kplɛ Kaesare dile.” Nioso Yesu latɔkɔ ma alɛ, “Ni biyɔ lɛsaa le ninle ni Ɔka Kplɛ Kaesare lele yi, bita Ɔka Kplɛ Kaesare. Biɛyɔ lɛsaa le kafɔɔ ninle ni Yaa lele yi, bita Yaa.” ");
INSERT INTO snw_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Obe wɔ baanu ni ɔlaa wɔ mmle yi, diabla ma yaaa, ni baasifi baadiɛ nwɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Dii nwu nkpo kale, Saduki batii ba nimbuɛ alɛ bakpi dilabasintaka bakye ni bakpi kamɛ lawa Yesu nfũ. ");
INSERT INTO snw_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ni baabatɔkɔ nwɔ alɛ, “Saatuotɛ, Mose latɔkɔ wo alɛ, nse osuɔtɔ owo lekpi eediɛ ɔsɔfɔ manko nwɔ banaa babi kubanwii yi, osuɔtɔ nwu nkpo obilɛma kafuo kpisɔfɔ nwu nkpo ɔyɔ, manko nwɔ manlofo babi. Ni baayɔ babi nwu nkpo mambla fɛ osuɔtɔ wɔ ninsinaa ni babi. ");
INSERT INTO snw_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Obe onwii, babilɛma suɔtɔbi bakuɛnsĩ banwii lawɛ wo kaamɛ ninfũ. Ni di ɔnɔɔfo le layɔ ɔsanko batalofo babi, ni aabafe aakpi nɛ. Ninfɛ di maatɛle labayɔ kpisɔfɔ nwu nkpo nɛ. ");
INSERT INTO snw_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Lɛsaa nwu nkpo kafɔɔ labla obilɛma suɔtobi nyɔɔfa nwu nkpo ku otiɛfa, dialaase di okuɛnsĩ le suoto. Kuonwii lɛma ditalofo ku ɔsanko nwu nkpo fiɛ baakpi. ");
INSERT INTO snw_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Yɛntɛyɛntɛ, ɔsanko nwu nkpo kafɔɔ labafe aakpi. ");
INSERT INTO snw_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Nimɔ, di dii le baakpi makple mantaka nii, owe lɛma ɔsɔfɔ di ɔsanko nwu nkpo male di obe wɔ baakuɛnsĩ lɛma nwu layɔ nwɔ ni?” ");
INSERT INTO snw_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ninfɛ di Yesu ladiki kanya alɛ, “Diele nkpo dibate saa. Lɛnya nlɛ bienu ɔlaa wɔ mmle kasɔ, diekye bieye sɛlaa se ninsi ni diɛ Kɔkpana Klekle Kukũ kamɛ, ee Yaa osie. ");
INSERT INTO snw_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Diekye di obe wɔ di bakpi mataka nii, babate fɛ Yaa batɔkyɛntɛ di osi, nioso sɛsa ku sɛsɔfɔ dilabasinwɛ. ");
INSERT INTO snw_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Biika lɛsaa le di Yaa labuɛ aatɔkɔ ye ni diekye ni baakpi okple ɔtaka osiɛ nkpa suoto? Aabuɛ alɛ, ");
INSERT INTO snw_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ami ninle Abraham Yaa ku Isak Yaa ku Yakob Yaa.’ Nle mmle kotuo alɛ, nnwɔɔ ninle batii ba ninkpe ni nkpa Yaa, diele bakpi Yaa ale.” ");
INSERT INTO snw_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Di obe wɔ di batii dikudi nwu nkpo lanu ni asaatuo ya mmle yi, diabla ma ɔkpɛ osie kanya. ");
INSERT INTO snw_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Di obe wɔ di Farisi batii lanu alɛ Yesu sɛlaa kanya didikibi lata alɛ Saduki batii nwu nkpo ditasinfuo ni kanya ɔbɛ yi, baakple baabasi. ");
INSERT INTO snw_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ni di onwii kaamɛ lɛma ninle ni kufiofa tuotɛ lawolaa Yesu kaanya aakaalɛ nwɔ alɛ, ");
INSERT INTO snw_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Saatuotɛ, kɔmɛnfiofa niefĩ kulenke di Mose afiofa nwu nkpo kamɛ?” ");
INSERT INTO snw_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ninfɛ di Yesu ladiki kanya alɛ, “Bɔmbɔ Saate Yaa lɛfɔ ku otu lɛfɔ omuu, ku ninwuna lɛfɔ nimuu ku disibu lɛfɔ nimuu. ");
INSERT INTO snw_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Nko mmle ninle kufiofa ko niefĩ kulenke ni, kule ni kɔkasale nɛ. ");
INSERT INTO snw_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Nko niekple kutikanko ni kuodie ni kɔkasale ninle alɛ, ‘Bɔmbɔ owo lɛfɔ fɛ mmle okle fambɔmbɔ ni suoto lɛfɔ.’ ");
INSERT INTO snw_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Afiofa ya mmle anyɔ suoto di Mose kufiofa ku Yaa ɔlaa babuɛtɛtɛ asaa otuo nkyɛ nɛ.” ");
INSERT INTO snw_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Obe wɔ di Farisi batii bawo lasi ni dikudi, Yesu lakaalɛ ma alɛ, ");
INSERT INTO snw_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Lɛ ninle ye disibu di Kristo nwu nkpo suoto? Owe leyo kamɛ eekye?” Ni baadiki kanya alɛ, “Ɔka Dawid leyo kamɛ eekye.” ");
INSERT INTO snw_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ninfɛ di Yesu lakaalɛ ma alɛ, “Nse nkpo kute mɔ, ni lɛ diɛbla fiɛ di Yaa Ninwuna lata Dawid lalɛɛ nwɔ alɛ Saate? Di Dawid nwu nkpo labuɛ alɛ, ");
INSERT INTO snw_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Yaa latɔkɔ Saate nii alɛ, “Siɛ di oletanɛɛkyɛ nii ninfũ dilaase di obe wɔ mayɔ balo lɛfɔ nkpee fɔ ni ninkpaa kalɔ.” ’ ");
INSERT INTO snw_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ni nse Dawid lalɛɛ Kristo nwu nkpo alɛ Saate, ni lɛ diɛbla fiɛ ale Dawid leyo kamɛ obi?” ");
INSERT INTO snw_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Otii kuonwii kaamɛ lɛma ditafuo Yesu ɔlaa nwu nkpo kanya odiki. Diayɔ ni di dii nwu nkpo kamaa, kuonwii ditasinkpee otu aakaalɛ Yesu ɔlaa kuonwii. ");
INSERT INTO snw_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Nni nkpo sɛmaa, Yesu lakakatɛ aata batii dikudi nwu nkpo ku basaateketetɛ nɔɔ. ");
INSERT INTO snw_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Ninfɛ aatɔkɔ ma alɛ, “Kufiofa batuotɛ ku Farisi batii ninle mba bɛɛta osuku alɛ baadiki ni Mose kufiofa nwu nkpo kasɔ. ");
INSERT INTO snw_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Nkpo oso bibla lɛsaa lele bɛɛtɔkɔ ye, biemufũ biklee osie kanya. Kafɔɔ bitantikanko ɔsaabla lɛma nkpaamaa, diekye baasi nkpa di asaa ya bootuo ni suoto. ");
INSERT INTO snw_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Beekpee atoo ya ninkpe ni onutũ beetukasa batii diisi alɛ batuka. Kafɔɔ mma bamu bolootuna alɛ bɔɔyɔ bia lɛnɛɛbi lɛma ninwii mankyaako batukatɛ nwu alɛ baatuka. ");
INSERT INTO snw_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Mambla lɛsaa biala baatii kanya ma ni fɛle Yaa bakpɛmblatɛ nwaa bale nii. Asaa ya man-yɔ mannii ni disi ku nnɛɛtũ lɛma lɛbla blɛfɛɛ, bɛɛkpana Kɔkpana Klekle sɛlaa beetika nya di suoto. Bɛɛbla kafɔɔ awu sɛkpaalɛ abinte beetika di awu lɛma suoto. ");
INSERT INTO snw_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Mambɔmbɔ osiɛ di nsiɛkɔ kplɛ di dii nlekɔ ku aba kplɛ osiɛ di Yuda batii nsiisakɔ kamɛ. ");
INSERT INTO snw_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Mammiɛ alɛ batii katɔwakasɔ mantɔɔsɛɛsa ma ku dibu laakpaka, mantɔɔlɛɛ ma kafɔɔ alɛ Basaatuotɛ. ");
INSERT INTO snw_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Kafɔɔ aye bafũbanutɛ yi, bitanta baalɛɛ ye basaatuotɛ, diekye saatuotɛ onwii lete ninkpe ye. Aye yi, bawo babilɛma bile. ");
INSERT INTO snw_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Bitanlɛɛ otii kuonwii kafɔɔ kaayi ka mmle bilɛ Teete, diekye Teete onwii lete ninkpe ye di osi. ");
INSERT INTO snw_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Bitanta baalɛɛ ye kafɔɔ alɛ Batunletɛ. Diekye otii onwii lete ninle ye tunletɛ, nnwɔɔ ninle Kristo nɛ. ");
INSERT INTO snw_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Kaamɛ lee, nwɔ ninle ni ɔnɔɔfo yi, dikpe nii eele kpɛmblatɛ ɛɛta bayɛntɛle. ");
INSERT INTO snw_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Otii wɔ niɛtakatɛsa ni suoto katoo yi, Yaa mawakosa nwɔ kasɔ. Otii wɔ kafɔɔ niɛwakosa ni suoto kasɔ yi, Yaa matakatɛsa nwɔ katoo. ");
INSERT INTO snw_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Biyɔɔsa, aye kufiofa batuotɛ ku Farisi batii! Aye anu di anu basaablatɛ! Biɛsɛɛ Yaa sɛka kalekɔ kayokontũ biekpee batii bilɛ batambuo. Aye bamu kafɔɔ biesĩ bilɛ biloobuo. Bietĩi mba kafɔɔ nikokpee ni okyiini alɛ boobuo ni osuku. ");
INSERT INTO snw_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Biyɔɔsa aye kufiofa batuotɛ ku Farisi batii! Aye anu di anu basaablatɛ! Minkyɛ bakpisɔfɔ nfũ bilɛ biɔkyakaako ma, kafɔɔ minkyɔnkyɔ ma minfũ ma asaa ninnɛɛ. Mimpɛ ɔlaa minklɛsa kafɔɔ bilɛ biɔyɔ minkyɔnkyɔ ma. Ta nkpo oso letokonanfi lee matɛ nimpɔ. ");
INSERT INTO snw_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Biyɔɔsa aye kufiofa batuotɛ ku Farisi batii! Aye anu di anu basaablatɛ! Mintaalɛ lekpo minkyɛ minkyi kayi aba aba mimmiɛ otii onwii minta Yaa. Nse bitɔɔwɛ otii nwu bieloo, mintuo nwɔ asaa anlalaa anlenkee bia aye bamu lee sɛnyɔ, alɛ aakyɛ kawɔɔ ɔtɔ nwu nkpo kamɛ! ");
INSERT INTO snw_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Biyɔɔsa aye batunletɛ ba di anu lebiɛ ni! Mintuo bilɛ, ‘Nse otii lɛka Yaa Olekatakɔ nwu nkpo yi, diɛbla lɛsalɛsaa, kafɔɔ nse otii lɛka koto sɛɛle ko ninte ni di Yaa Olekatakɔ nwu nkpo kamɛ yi, dikpe nii eediki ntam nwu nkpo.’ ");
INSERT INTO snw_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Banumbiɛtɛ babuutɛ! Lɛmɛnle niefĩ dilenke, koto sɛɛle nwu ɛɛ, sɛɛ Yaa Olekatakɔ ka niɛta koto sɛɛle nwu nkpo nte ni klekle? ");
INSERT INTO snw_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Biokple mintuo bilɛ, ‘Nse otii owo lɛka oleɔta akyikye nwu nkpo yi, diɛbla lɛsalɛsaa. Kafɔɔ nse ɛɛlɛɛ oleɔta wɔ nintika ni di oleɔta akyikye nwu nkpo suoto yi, ni dikpe nii eediki ntam nwu nkpo.’ ");
INSERT INTO snw_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Banumbiɛtɛ biɛtɛ bile nwaako! Lɛmɛnle niefĩ dilenke, oleɔta nwu ɛɛ, sɛɛ oleɔta akyikye ya niɛta oleɔta nwu nkpo nte ni klekle? ");
INSERT INTO snw_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Nkpo oso, nse otii owo lɛlɛɛ oleɔta akyikye nwu nkpo yi, ni atɔɔlɛɛ oleɔta akyikye nwu nkpo ku oleɔta wɔ omuu nintika nya ni di suoto. ");
INSERT INTO snw_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Nse ɛɛlɛɛ Yaa Olekatakɔ kafɔɔ yi, ni atɔɔlɛɛ Yaa Olekatakɔ nwu ku Yaa wɔ ninsi ni ninfa. ");
INSERT INTO snw_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Nkpo okle kafɔɔ nse otii owo lɛka osi yi, ni atɔɔka Yaa lɛkakpomii ku Yaa wɔ omu ninsi ni di lekpomii nwu suoto nɛ. ");
INSERT INTO snw_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Biyɔɔsa aye kufiofa batuotɛ ku Farisi batii! Aye anu di anu basaablatɛ! Biye mmle okle manta ni apasalɛbi ku kayee ku abulaa dikyuu lefosile nɔɔ manta ni Yaa, kafɔɔ biesĩ kufiofa asaatuo finle ya ninle ni batii ɔtannyu di anu ku nyaami ɔnya ku ote tinini biɛtɛ. Asaa ya mmle dikaatɛ alɛ biɛka ɔbla fiɛ biɛyɔ nnya nkpo kafɔɔ biɛkyakaa nɛ. ");
INSERT INTO snw_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Batunletɛ banumbiɛtɛ! Mindiki kabɔkɔbii biibii di nta anu, kafɔɔ asaa ya mimmɛ ni lemuɔ alenke kapupɔnkɔ! ");
INSERT INTO snw_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Biyɔɔsa aye kufiofa batuotɛ ku Farisi batii! Aye anu di anu basaablatɛ! Minfoto sipũ lee ku awansaa lee sɛmaa klekle, kafɔɔ kamɛ ninya leyii pɔ ku lɛkpɔnɔnfɔ fɛ mmle okle bieyii ni ku ditiitafaa ku onumbɛbɛɛ. ");
INSERT INTO snw_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Afɔ Farisi otii numbiɛtɛ, foto opũ lɛfɔ kamɛ lɛkasale, ni sɛmaa kafɔɔ makpa. ");
INSERT INTO snw_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Biyɔɔsa aye kufiofa batuotɛ ku Farisi batii! Aye anu di anu basaablatɛ! Bite fɛ sɛkya se beekpiitaa ni ku akaaloo siɔlɛ ni onyu kaayi osie kanya. Kafɔɔ kamɛ leyii pɔ ku bakpi buule ku akufi. ");
INSERT INTO snw_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Nkpo okle kafɔɔ biɛbla suoto fɛ batii biene baatii anu nɛ, kafɔɔ kamɛ lee leyii pɔ ku sɛlaa kuafunu ku sikpile. ");
INSERT INTO snw_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Biyɔɔsa aye kufiofa batuotɛ ku Farisi batii! Aye anu di anu basaablatɛ! Mimbla sɛkya biene minta Yaa ɔlaa babuɛtɛtɛ, minlolaa kafɔɔ batii ba niesiɛ ni nkpa biene sɛkya osie kanya. ");
INSERT INTO snw_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Mimbuɛ kafɔɔ bilɛ, ‘Nse minsiɛ nkpa di bawa lee obe kamɛ yi, nse biɛbla onwii ku mma bilo Yaa ɔlaa babuɛtɛtɛ nwu nkpo.’ ");
INSERT INTO snw_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Kafɔɔ nwaako ɔsaabla lee kodiki kuntuo alɛ batii ba nialo ni Yaa ɔlaa babuɛtɛtɛ nwu nkpo banantii bile. ");
INSERT INTO snw_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Nkpo oso yi, bibla bikyɛnko, biɛyɛntɛ lɛsaa le baawa lee lakye ni kasɔ. ");
INSERT INTO snw_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Batii kpile bile! Bite fɛ basaanwu ku abi! Bienyu bilɛ bibafuo otoso odie di Yaa letokonanfi le abananfi ye ni di ɔtɔ kawɔɔ kamɛ? ");
INSERT INTO snw_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Nle mmle oso, makyesee ye Yaa ɔlaa babuɛtɛtɛ ku banumbentɛ ku kufiofa batuotɛ, bibapɛ bawo minkaasa di kowoso suoto mankpi. Bibapɛ bawo kafɔɔ kowesee di nsiisakɔ lee, mintikanko babamba kafɔɔ mindiki di okpoo minsifiko okpoo bamba kamɛ. ");
INSERT INTO snw_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Di ɔsaabla wɔ mmle oso, batii ba ninte ni tinini bamuu ntɔ be batooyiwii ni kaasɔ suoto, matika ye diisi. Dibakye kasɔ di otii tinini Abel ntɔ suoto, ninaase di Barakia obi nɔɔ Sakaria wɔ bialo ni di Yaa Olekatakɔ kamɛ ku oleɔta akyikye obo. ");
INSERT INTO snw_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nwaako kɔtɔkɔ ye nlɛ, ntɔ be mmle beewii nii letokonanfi mawa di aye ba ninkpe ni nkpa miɛ disi. ");
INSERT INTO snw_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“O Yerusalem, Yerusalem, afɔ nialo Yaa ɔlaa babuɛtɛtɛ, faasafɔ batii ba kafɔɔ di Yaa lakpee fɔ ni ɔkyɛ aafuɔ faalo! Obe kpinwu ntoomiɛ nlɛ kosiisa babi lɛfɔ di afoko nii kalɔ fɛ mmle okle di kɔɔkɔɔbi ɔya nkpaa abi ankpee ni di afoko nɔɔ kalɔ, kafɔɔ floonu kasɔ! ");
INSERT INTO snw_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ta nle mmle oso, Yaa madiki okpoo wɔ mmle atoko manwɔɔsa nwu. ");
INSERT INTO snw_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nwaako kɔtɔkɔ ye nlɛ, biloosinwa mi ɔbanya diediki diɛlaase di obe wɔ biebuɛ bilɛ, ‘Yaa lekusɛkusɛsa otii wɔ nikɔwa ni di Saate leyooto kamɛ.’ ” ");
INSERT INTO snw_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Obe wɔ di Yesu ladie di Yaa Olekatakɔ nwu nkpo ninfa aatoosifi nii, ni di basaateketetɛ nɔɔ lawa ɔkyɛ nɔɔ babatootuo nwɔ Olekatakɔ nwu nkpo ku ayo ninya. ");
INSERT INTO snw_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ninfɛ di Yesu latɔkɔ ma alɛ, “Bilolaa asaa ya mmle nwu nkpo binyu nwaa. Diekye kɔtɔkɔ ye nlɛ bababiɛ nya amuu, bia difuɔ ku ninwii dilababu ditika di lewo nini suoto alɛ baasamiisa nya batɛ kaasɔ.” ");
INSERT INTO snw_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Di obe wɔ di Yesu lasifi aalaasiɛ ni di Nnɔnyi Awoso Kobokote suoto yi, ninfɛ di basaateketetɛ nɔɔ lawa ɔkyɛ nɔɔ buɛɛ babakaalɛ nwɔ alɛ, “Tɔkɔ wɔ ɔmɛmbe di asaa ya mmle mawa kaanya? Obe kafɔɔ nimale dituosaa alɛ fɔɔwa, ni kayi kalookɔ kafɔɔ ntoowo?” ");
INSERT INTO snw_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ninfɛ di Yesu latɔkɔ ma alɛ, “Bilolaa binyu nwaa alɛ otii kuonwii diɛkyɔnkyɔ ye. ");
INSERT INTO snw_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Diekye batii kpinwu mayɔ leyooto nii manwa ɔkyɛ lee, mamatɔkɔ ye alɛ, ‘Ami ninle Kristo nwu!’ Mankyɔnkyɔ batii kpinwu. ");
INSERT INTO snw_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Bibanu kakpɛ kudu sɛɛlɔɔkɔ lee ku kakpɛ sɛlaa fanfa, kafɔɔ bitanta lɛyɛkɛ lapɛ ye. Dikpe nii, asaa ya mmle okle lɛwa kafɔɔ dilootuo alɛ kayi kalookɔ ntoowo. ");
INSERT INTO snw_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Nnle mataka baawo suoto, sɛka nlekɔ kafɔɔ mataka baawo suoto. Nsɔ matũkũ di aba aba. Aka siene kafɔɔ makpɛ di aba aba. ");
INSERT INTO snw_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Asaa ya mmle amuu nte fɛ mmle lɛɛmɛ nkye kasɔ nintoonu ni mɛlakatɛ nintɔɔtɛ nii. ");
INSERT INTO snw_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Di obe nwu nkpo kamɛ yi, balo lee mata mammufũ ye mambla ye amumu, manlo ye bia. Batii bamuu makyidi ye ta ami oso. ");
INSERT INTO snw_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Di obe nwu kamɛ yi, batii kpinwu madiɛ ofũ onu lɛma. Babadiki bawo lɛma manta, mankyidi bawo lɛma kafɔɔ. ");
INSERT INTO snw_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Balaatɛ Yaa ɔlaa babuɛtɛtɛ kpinwu madie mankyɔnkyɔ batii kpinwu. ");
INSERT INTO snw_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Sikpile ɔbla mapɔ osie kanya di batii kamɛ alɛ batii kpinwu ditiibɔmbɔ mawa kasɔ. ");
INSERT INTO snw_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Kafɔɔ otii wɔ nimakpee otu anaase ni kaayɛntɛlekɔ kamawɛ nkpa be ninnaa ni kaloo. ");
INSERT INTO snw_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Batii mayie Yaa sɛka kalekɔ ɔlaa biene nwu nkpo lɛkya kaayi kamuu kamɛ, alɛ otii biala kawɛ osuku annu, fiɛ nfɛ di kayi kaloo nwu nkpo mawa. ");
INSERT INTO snw_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Nse biɛnya abusufɔɔsaa yɛkɛle ya di Yaa Ɔlaa Buɛtɛtɛ Daniel labuɛ aatɛ ni n-yɛ di Kakleklekɔ nwu nkpo yi, ni afɔ wɔ nikɔka ni kukũ ko mmle yi, nu kasɔ nwaa! ");
INSERT INTO snw_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Ni biɛta batii ba ninkpe ni di Yudia batoso basifi abokote osi balaawofa. ");
INSERT INTO snw_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Otii wɔ kafɔɔ nintika ni di leyo nɔɔ osi, atantɔkɔ alɛ oosoo anwa amayɔ lɛsalɛsa nɔɔ leeyo kamɛ ansifiko. ");
INSERT INTO snw_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Otii wɔ ninkpe ni koofe, atasinkple aatɔkɔ alɛ ooyie ammayɔ akleesaa nɔɔ leeyo. ");
INSERT INTO snw_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Di obe nwu nkpo kamɛ, dibatɛ ninwɛ osie ninta basanko ba ninlaka ni amɛ ku mba nikɔta babi nyɛɛfu nii. ");
INSERT INTO snw_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Bipɛ ɔlaa bita Yaa bilɛ, otoso osifi wɔ mmle nwu nkpo diɛwa di lɛwɔɔfɔ obe ee Lɛnyɛɛtɛyi suoto! ");
INSERT INTO snw_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Diekye dibuo kplɛ le nimawa ni di obe nwu nkpo kamɛ malenkee nle okle nintɔwa diɛbafe ni di obe wɔ kaayi lakye ni kasɔ diɛbase ni diɛ miɛ dii le mmle. Dibuo le mmle okle kafɔɔ dilabasinwa diidii. ");
INSERT INTO snw_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kafɔɔ Saate lɛkɔkɔlɛ ayi nwu nkpo. Se diele nkpo ɛɛbla se otii kuonwii dilababu. Kafɔɔ ta batii nɔɔ ba eediki ɛɛta ni suoto oso, ɛɛkɔkɔlɛ ayi nwu. ");
INSERT INTO snw_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Nioso se otii owo lɛtɔkɔ fɔ alɛ, ‘Nyu! Nnya Kristo ninfũ!’ ee ‘Nyɔɔ ninfa!’, tanfũ nwɔ faanu. ");
INSERT INTO snw_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Diekye batii mataka manlaa mambuɛ alɛ mma ninle Kristo nwu nkpo, bawo kafɔɔ mabuɛ alɛ Yaa ɔlaa babuɛtɛtɛ bale. Bababla sɛkpɛ se niɛbla ni sɛkpɛ ku atuosaa ate ate mantuo alɛ, nse dialɛ yi, baayɔ mankyɔnkyɔ bia batii ba di Yaa lediki eese ni lete. ");
INSERT INTO snw_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Binu! Nkpo oso ntoole katũ lɛtɔkɔ ye sɛlaa se mmle fiɛ di obe nwu mawo nɛ. ");
INSERT INTO snw_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Nse batii lɛtɔkɔ ye alɛ, ‘Binyu! Akpe di ɔfaafuu’ yi, bitankyɛ nfa. Ee nse bɛɛtɔkɔ ye alɛ, ‘Asi leeyo kamɛ’ yi, bitanfũ bianu. ");
INSERT INTO snw_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Diekye Otii Obi nwu nkpo mawa fɛ mmle okle di kanto mmunaa ankye ni kufĩ katunkɔ amafe ni kufĩ kamɛɛkɔ. ");
INSERT INTO snw_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Nkpo oso bitanyee bilɛ nfũ di lɛsaa lekpi dite nii, nfa di alente nsi nɛ. ");
INSERT INTO snw_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Diibuo kplɛ nwu nkpo kamaa, kufĩ mata ditunu, kɔwɛntɛ kafɔɔ dilabapu. Awɛntlɛbi kafɔɔ makpa ankye osi, osi asaa kafɔɔ matididi di aba ya atika nii. ");
INSERT INTO snw_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Nfanwu Otii Obi nwu nkpo dituosaa makyɔɔ di osi, kasɔ ka mmle batii bamuu mawi kaku di obe wɔ baatii manya Otii Obi nwu makyɔɔ ni di alokonkyɛ kamɛ ɔɔwa ku osie kplɛ di leklekle kamɛ. ");
INSERT INTO snw_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Abata manfɛ dikyukyoo kplɛ nwu nkpo. Abakyesee Yaa batɔkyɛntɛ nɔɔ di kayi ka mmle nkyakakɔ nwu nkpo nna, mansiisa batii nɔɔ ba eediki ni mankyeko kaasɔ disi le diɛlase ni diisi le. ");
INSERT INTO snw_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Bitekete lɛsaa bikyeko kolewoso suoto. Nse obe wɔ biɛnya bilɛ nfɛ kuodie ni sɛla fɔle kuokpee ni afata fɔle yi, mintofo bilɛ kanto ɔnɔɔbee nfɛ kowo. ");
INSERT INTO snw_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Nkpo okle kafɔɔ nse bienya asaa ya mmle nkpo amuu yi, bietofo bilɛ Kristo obe nwu nkpo ntɔɔtɛɛtɛɛ, nfɛ ayɛ di kayokontũ. ");
INSERT INTO snw_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nwaako kɔtɔkɔ ye nlɛ asaa ya mmle amuu mawa fiɛ di batii ba bamuu ninsi ni nkpa nunua maloo okpi. ");
INSERT INTO snw_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Osi ku kasɔ mafe, kafɔɔ sɛlaa nii nsĩ, silabafe diidii. ");
INSERT INTO snw_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Otii kuonwii dieye dii nwu nkpo ku obe wɔ kamɛ dibale nii. Yaa batɔkyɛntɛ ba ninkpe ni di osi dieye. Bia Obi nwu nkpo omu dieye, Ote lete ninnye. ");
INSERT INTO snw_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Otii Obi nwu nkpo ɔwabee mate fɛ lɛsaa le niawa ni di Noa obe kamɛ. ");
INSERT INTO snw_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Di obe nwu nkpo kamɛ fiɛ di kanto labanɔɔ aayii ni kayi yi, batii latoole baatoonyi. Basanko ku basuɔtɔ latoodiki bawo baatɔɔyɔ. Baatɔɔyɔ bawo kafɔɔ baatɔɔta asa, dialaase di dii le di Noa labuo ni di oklo nwu nkpo kamɛ. ");
INSERT INTO snw_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Kafɔɔ batatofo lɛsaa le niatɔɔwa nii, dialaase di obe wɔ di kanto lanɔɔ ntu labayɔ ni bamuu lɛma. Nkpo okle dibate nse Otii Obi nwu nkpo lɛwa nɛ. ");
INSERT INTO snw_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Di obe nwu nkpo kamɛ, basuɔtɔ banyɔ matɔɔbla ɔkpɛ koofe Yaa makpaa onwii andiɛ onwii. ");
INSERT INTO snw_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Basanko banyɔ kafɔɔ mawɛ di nnaafũ kakuɔkɔ, Yaa makpaa onwii andiɛ onwii. ");
INSERT INTO snw_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Nkpo oso bita anu lee ate kesekese, diekye bieye dii le di Saate lee kamawa nii. ");
INSERT INTO snw_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Nse fɛ leyo saate n-ye obe wɔ kamɛ di yu kamawa nii yi, biye bilɛ atabasiɛ ku anu kesekese ansoko nwɔ. Atabata yu nwu nkpo abiɛ kakɔkakɔ abuo nwɔ leyo kamɛ. ");
INSERT INTO snw_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Nkpo okle kafɔɔ dikpe nii biɛta anu lee lete kesekese obe lele nɛ, diekye Otii Obi nwu nkpo kamawa di obe wɔ kamɛ minoonyu osuku bilɛ abawa nii. ");
INSERT INTO snw_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Nimɔ owe ninle kpɛmblatɛ wɔ niebe ni anu ambla ni asaa di osuku suoto? Nnwɔɔ ninle otii wɔ di saate nɔɔ leyɔ nwɔ eese ni di bakpɛmblatɛ wo nɔɔ kanya alɛ aata ma ni alesaa di obe kanya nɛ. ");
INSERT INTO snw_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Nwaako suoto matɛ sinyɔɔ kpɛmblatɛ nwu nkpo nse saate nɔɔ lɛwa ɛbanyɔɔ alɛ ɔɔbla lɛsaa le aatɔkɔ nwɔ nii. ");
INSERT INTO snw_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nwaako kɔtɔkɔ ye nlɛ, saate nwu nkpo mayɔ kpɛmblatɛ wɔ mmle anse di asaa nɔɔ amuu kanya. ");
INSERT INTO snw_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Kafɔɔ nse kpɛmblatɛ kpile ale yi, ababuɛ antɔkɔ suoto alɛ, ‘Sua! Saate nii dilabawa nunua!’ ");
INSERT INTO snw_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Nkpo oso abakye kasɔ antɔɔpɛ bakpɛmblatɛ wo nɔɔ nwu nkpo. Nse atɔɔkyako ole, onyi ku batasiɛntɛ. ");
INSERT INTO snw_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Nse Saate nwu nkpo ntookple ɛɛwa di dii le ku obe wɔ di kpɛmblatɛ nwu nkpo diloonyu osuku aatɔɔ nii. ");
INSERT INTO snw_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Saate nwu nkpo mananfi kpɛmblatɛ nwu nkpo kootoko osie kanya, antɔɔ kalekɔ nɔɔ di anu di anu basaablatɛ kamɛ. Nfa di kaku owi ku anyɛɛ owee kamawɛ nɛ! ");
INSERT INTO snw_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Di obe nwu nkpo kamɛ, Yaa sɛka kalekɔ nwu nkpo mate fɛ mmle okle. Di obe onwii kamɛ, kokpeelebitɛ lefosi kowo layɔ bakandiɛ lɛma alɛ bɔɔlaakyakako ɔkafɔɔsa. ");
INSERT INTO snw_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Banɔɔ kaamɛ lɛma lale babuutɛ. Banɔɔ bule kafɔɔ lale banumbentɛ. ");
INSERT INTO snw_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Babuutɛ nwu nkpo layɔ bakandiɛ lɛma kafɔɔ bataklee nnɔfɔ kunwii baakyakaa. ");
INSERT INTO snw_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Kafɔɔ banumbentɛ nwu nkpo mma baabla nnɔfɔ baakpete di asaa kamɛ baakle baata bakandiɛ lɛma. ");
INSERT INTO snw_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ɔkafɔɔsa nwu nkpo laklɛ ku ɔwa, nkpo oso kokpeelebitɛ nwu nkpo lakyako sɛkyɔsĩ ɔkpa, ni baakyɔsĩi nɛ. ");
INSERT INTO snw_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Nkyɛntɛɛ fiɛ kuudu ladie alɛ, ‘Ɔkafɔɔsa nwu ntɔbabuo kyu woo! Bidie biwa biɛbakyakako nwɔ!’ ");
INSERT INTO snw_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Ninfɛ di bakpeelebitɛ lefosi nwu nkpo lataka wla baayiensa bakandiɛ lɛma nɛ. ");
INSERT INTO snw_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ninfɛ di babuutɛ nwu nkpo latɔkɔ banumbentɛ nwu nkpo alɛ, ‘Bitika wo nnɔfɔ lee nwu nkpo nnwo, diekye bakandiɛ loo ba bukle ni nfɛ konii.’ ");
INSERT INTO snw_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Ninfɛ di banumbentɛ nwu nkpo latɔkɔ ma alɛ, ‘Oo, nnɔfɔ be bukle ni dilabawo awo ku aye. Nkpo oso bitɔɔkyɛ basunsutɛ nfũ biɛlaaya.’ ");
INSERT INTO snw_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Nkpo oso babuutɛ nwu nkpo lasifi nnɔfɔ nwu nkpo kayakɔ. Obe wɔ baasifi ni osifi ni di ɔkafɔɔsa nwu nkpo lawa nɛ. Ninfɛ di kokpeelebitɛ kɔnɔɔ ko nialoolaa ni suoto latikanko nwɔ baabuo ɔsanko nwu kayɔkɔ nɛ, ni baasɛɛ leyo nɛ. ");
INSERT INTO snw_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Nni sɛmma, kokpeelebitɛ bulɛ nwu nkpo kafɔɔ lawa, ni baabuɛ alɛ, ‘Ɔnɔɔfo, Ɔnɔɔfo! Sɛkɛtɛ wo buobuo!’ ");
INSERT INTO snw_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Ninfɛ di ɔkafɔɔsa nwu nkpo latɔkɔ ma alɛ, ‘Oowo! Ninye ye.’ ” ");
INSERT INTO snw_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ninfɛ di Yesu layɛntɛ ku lɛkpa nwu alɛ, “Nkpo oso bita anu lee ate kesekese, diekye bieye dii nwu nkpo ee obe wɔ di Otii Obi nwu mawa nii. ");
INSERT INTO snw_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Di obe nwu nkpo kamɛ, Yaa sɛka kalekɔ nwu kamate fɛ nle mmle okle. Obe onwii kamɛ osuɔtɔ onwii lalolaa suoto aatoofe osuku, ni aalɛɛ bakpɛmblatɛ nɔɔ, aayɔ ma aase di asaa nɔɔ kanya nɛ. ");
INSERT INTO snw_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Aata obiala lɛma lɛsaa le aafuo ni okle di osei nɔɔ kanya. Aata onwii koto fututu nkpe nnɔɔ, ɔbamba kafɔɔ aatɔɔ koto nkpe nnyɔ, ɔbamba kafɔɔ aatɔɔ kakpe kanwii. Ni aadie aasifi osuku nɛ. ");
INSERT INTO snw_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Kpɛmblatɛ wɔ niafũ ni koto nkpe nnɔɔ, nfanwu aasifi aalaayɔ koto nɔɔ aakpee di ɔkpɛ ɔbla kamɛ aawɛ koto nkpe nnɔɔ atikasa. ");
INSERT INTO snw_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Nkpo okle kafɔɔ di kpɛmblatɛ wɔ niafũ ni koto nkpe nnyɔ lawɛ koto nkpe nnyɔ aatikasa nɛ. ");
INSERT INTO snw_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Kafɔɔ kpɛmblatɛ wɔ niafũ ni koto kakpe kanwii lasifi aalaakutu kasɔ aayɔ Saate nɔɔ koto aakookaa ninfa. ");
INSERT INTO snw_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Ayi kpinwu sɛmaa, bakpɛmblatɛ nwu nkpo Saate lɛma lakple aawa aabablako ma koto nwu nkpo nkuntaa. ");
INSERT INTO snw_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Kpɛmblatɛ wɔ niafũ ni koto nkpe nnɔɔ, layɔ koto nkpe nnɔɔ bamba aakyakaa, ni aabuɛ alɛ, ‘Ɔnɔɔfo, faatɛɛ koto nkpe nnɔɔ kafɔɔ lɛwɛ nkpe nnɔɔ bamba letikasa.’ ");
INSERT INTO snw_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Ninfɛ di Saate nɔɔ nwu nkpo latɔkɔ nwɔ alɛ, ‘Oo! Kpɛmblatɛ biene, fɛɛbla lɛsaa di osuku kanya nwaako! Di obe wɔ feelolaa fɛɛbla, feelolaa koto ko mmle kafuii feekle ni oso yi, mayɔ fɔ nse di koto kplɛ kanya. Wa fabasiɛ di suoto lɛyɔɔ nii kamɛ!’ ");
INSERT INTO snw_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Ninfɛ di kpɛmblatɛ wɔ kafɔɔ baata ni koto nkpe nnyɔ lawa ababuɛ alɛ, ‘Ɔnɔɔfo, faatɛɛ koto nkpe nnyɔ, kafɔɔ lɛwɛ nkpe nnyɔ bamba letikasa.’ ");
INSERT INTO snw_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Ninfɛ di Saate nɔɔ nwu nkpo latɔkɔ nwɔ alɛ, ‘Oo! Kpɛmblatɛ biene, fɛɛbla lɛsaa di osuku kanya nwaako! Di obe wɔ feelolaa fɛɛbla, feelolaa koto koto ko mmle kafuii feekle ni oso yi, mayɔ fɔ nse di koto kplɛ kanya. Wa fabasiɛ di suoto lɛyɔɔ nii kamɛ!’ ");
INSERT INTO snw_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Ninfɛ di kpɛmblatɛ wɔ kafɔɔ baata ni koto kakpe kanwii lawa ababuɛ alɛ. ‘Ɔnɔɔfo, n-ye nlɛ fale otii wɔ di ɔlaa lɛfɔ nkpe ni osie, fanfiɛlɛ ninfũ fanankpɛ nii. Fantɛsɛ ninfũ kafɔɔ fanampɛ ni lɛsalɛsaa. ");
INSERT INTO snw_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Kɔyɛkɛ ni oso, layɔ koto lɛfɔ nwu nkpo lalakutu kasɔ layɔ lakookaa. Nnya lɛsaa lɛfɔ. Fũ!’ ");
INSERT INTO snw_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Ninfɛ di Saate nɔɔ nwu nkpo latɔkɔ nwɔ alɛ, ‘Afɔ kpɛmblatɛ kpile, fakpe nkyɔkɔ lo! Faye falɛ nfiɛlɛ ninfũ ninankpe ni kowee, ntɛsɛ kafɔɔ ninfũ ninampɛ ni lɛsalɛsaa. ");
INSERT INTO snw_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ni be oso fanan-yɔ koto nii nwu nkpo falaatɛ di koto katɛkɔ alɛ nse lɛwa kafũ koto nwu nkpo nwɛ lɛsaa ntikasa?’ ");
INSERT INTO snw_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Ninfɛ di Saate nɔɔ nwu nkpo labuɛ alɛ, ‘Bifũ koto nwu nkpo di nnɛɛ nɔɔ biɛyɔ bita otii wɔ ninkle ni koto nkpe lefosi.’ ");
INSERT INTO snw_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Diekye otii wɔ ninkpe ni lɛsaa yi, nnwɔɔ babakple mankyakaa mampɔɔsa nɛ. Alɛ lɛsaa le ninkpe nwɔ ni kakple nimpɔ ninlenkee. Kafɔɔ otii wɔ ninnaa ni lɛsaa yi, kɛɛkɛɛ wɔ bia ninkpe nwu nii yi, babakle manfũ nwɔ ninnɛɛ kamɛ. ");
INSERT INTO snw_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Kpɛmblatɛ wɔ mmle diesinlɛ ata lɛsalɛsaa ɔblako, nkpo oso biyɔ nwɔ bifuki binyu kaayi di ditunu nwu nkpo kamɛ. Nfa abawi kaku anwee anyɛɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Nse Otii Obi nwu nkpo lɛwa fɛ Ɔka, di Yaa batɔkyɛntɛ lɛmana nwɔ beekyi yi, abasiɛ di lɛkakpomii nɔɔ suoto. ");
INSERT INTO snw_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Abasiisa nnle mmuu batii di anu nɔɔ, nse atɔɔsɛ ma ntɛɛ di akyuu anyɔ fɛ mmle okle di babɔkɛɛkpatɛ nsɛ ni batie ku bafoso ntɛɛ. ");
INSERT INTO snw_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Abata batii biene nyila di oletanɛɛkyɛ nɔɔ, anta batii kpile kafɔɔ nyila di ɔmɛtukyɛ nɔɔ. ");
INSERT INTO snw_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Nse Ɔka nwu nkpo ntɔɔtɔkɔ batii ba nin-yɛ nwɔ ni di oletanɛɛkyɛ alɛ, ‘Biwa, aye ninle batii ba di Teemi lewii ni lɛyɔɔ nɛ! Biwa biɛbasiɛ di sɛka kalekɔ nwu nkpo di Yaa lelolaa ɛɛta ye ni, diɛyɔ ni di kayi kasɔ kakyekɔ. ");
INSERT INTO snw_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Diekye di obe wɔ kɔɔka laklee mi nii, biatɛɛ alesaa lale. Obe wɔ di otukɔnsɔ laklee mi nii, biatɛɛ ntu lanyi. Obe wɔ kafɔɔ lababuo ye ni kɔfɔɔ, biafũ mi ku otu biene. ");
INSERT INTO snw_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Obe wɔ lakyɛ ni lɛkyɔtɔ, biatɛɛ asaa laklee. Obe wɔ latoofiɛ nii, bianyu mi. Obe wɔ kafɔɔ late ni leeyo, biawa biabanyu mi.’ ");
INSERT INTO snw_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Nfa nfɛ di batii biene nwu nkpo makaalɛ nwɔ alɛ, ‘Saate, ɔmɛmbe buanya fɔ kɔka laklee fɔ buata fɔ alesaa faale, ee ɔmɛmbe di otukɔnsɔ laklee fɔ buata fɔ ntu faanyi? ");
INSERT INTO snw_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ɔmɛmbe faabuo wo kɔfɔɔ buafũ fɔ ku otu biene, ee faakyɛ lɛkyɔtɔ buata fɔ asaa faaklee? ");
INSERT INTO snw_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ɔmɛmbe faatoofiɛ buawa buabasɛɛsa fɔ, ee faate leeyo katenkɔ buawa buabanyu fɔ?’ ");
INSERT INTO snw_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Nfa nfɛ di Ɔka nwu nkpo madiki kanya alɛ, ‘Nwaako kɔtɔkɔ ye nlɛ, di obe wɔ biɛnya biɛbla nle mmle biɛta ni babiloo ba mmle yɛntɛle onwii lɛma kamaa, ami biɛbla biɛta.’ ");
INSERT INTO snw_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Nfa nfɛ abatɔkɔ batii ba nin-yɛ nwɔ ni di ɔmɛtukyɛ alɛ, ‘Bikyɛ mi di ɔlɔɔkɔ bisifi aye ba di Yaa lɛkpaani ntika ni di suoto! Bitɔɔkyɛ kawɔɔ ɔtɔ wɔ ninnaa ni kaloo di Yaa lelolaa ɛɛtɛ ɛɛta ni Abonsam ku batɔkyɛntɛ nɔɔ kamɛ! ");
INSERT INTO snw_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Diekye kɔka laklee mi, kafɔɔ bitatɛɛ alesaa lale. Otukɔnsɔ laklee mi, kafɔɔ bitatɛɛ ntu lanyi. ");
INSERT INTO snw_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Labuo ye kɔfɔɔ, kafɔɔ bitafũ mi. Lakyɛ lɛkyɔtɔ, bitatɛɛ asaa laklee. Latoofiɛ bitawa biabasɛɛsɛɛ. Late leeyo kafɔɔ bitawa biabanyu mi.’ ");
INSERT INTO snw_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Nfa nfɛ babakaalɛ nwɔ alɛ, ‘Saate, ɔmɛmbe buanya fɔ kɔka laklee fɔ, ee otukɔnsɔ laklee fɔ, ee faabuo wo kɔfɔɔ, ee faakyɛ lɛkyɔtɔ, ee faatoofiɛ, ee faate leeyo fiɛ butakyakaako fɔ?’ ");
INSERT INTO snw_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Nfa nfɛ di Ɔka nwu nkpo matɔkɔ ma alɛ, ‘Nwaako kɔtɔkɔ ye nlɛ di obe wɔ bitabla dibiene biata ni babiloo ba mmle yɛntɛle yi, ami bitabla biata.’ ” ");
INSERT INTO snw_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Yesu layɛntɛ alɛ, “Batii ba mmle nwu nkpo masifi dibuo le ninnaa ni kaloo kamɛ. Batii biene kafɔɔ masifi nkpa be ninnaa ni kaloo kamɛ.” ");
INSERT INTO snw_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Di obe wɔ kamɛ di Yesu ntooloo ni asaa ya mmle amuu otuo yi, aatɔkɔ basaateketetɛ nɔɔ alɛ, ");
INSERT INTO snw_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Biye bilɛ ditoobu ayi anyɔ bubale ni Okpi Diisi Ofe Dii nwu nkpo. Babayɔ Otii Obi nwu nkpo manta mampɛ mankaasa di kowoso suoto.” ");
INSERT INTO snw_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ninfɛ di olebatatɛ banɔɔfo ku okpoo banɔɔfo balaasi di Oletatɛ Nɔɔfo Kaiafa leyo nɛ. ");
INSERT INTO snw_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ni baalaabla disibu mmle okle babamufũ ni Yesu di lɛwofa kamɛ manlo nwɔ ni nɛ. ");
INSERT INTO snw_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ni baabuɛ baatɔkɔ bawo alɛ, “Ditanwa alɛ buɔbla lɛsaa le mmle di ayi ya buole ni kamɛ. Se diele nkpo, batii manya ɔblɔ mantaka wo di suoto.” ");
INSERT INTO snw_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Di obe nwu nkpo kamɛ yi, Yesu lakyɛ Simon wɔ niafiɛ ni ofiɛ sɛɛle leyo di Betania. ");
INSERT INTO snw_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Yesu lawɛ di Betania okpoo diɛ Simon wɔ niafiɛ ni ofiɛ sɛɛle leyo. Ɔbe wɔ di Yesu lasiɛ aatoole ni alesaa, ɔsanko onwii lawa nfa. Aaklee difuɔ kylɔkylɔ lebo ninwii di nnɔnyi kɔnɔkɔnɔ be niefũ ni kɔya osie kanya lasiɛ ni kaamɛ. Ni aanyɛɛnɛ nnɔnyi nwu nkpo aakpete di Yesu disi nɛ. ");
INSERT INTO snw_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Obe wɔ baasaateketetɛ nɔɔ lanya ni nle mmle yi, ditaayɔɔ ma kafutu, ni baakaalɛ alɛ, “Be lɛsaa oso ɛɛlalaasa nnɔnyi be mmle, nkpo okle? ");
INSERT INTO snw_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Baafuo nnɔnyi be mmle osunsũ ku kɔya kplɛ, man-yɔ koto nwu nkpo manta bapiitɛ fiɛ!” ");
INSERT INTO snw_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesu lanu ɔlaa wɔ baatoobuɛ nii, ni aatɔkɔ ma alɛ, “Be oso biokpee ɔsanko wɔ mmle kubuɛ? Lɛsaa biene ninle nle mmle ɛɛbla ɛɛtɛɛ nii nɛ. ");
INSERT INTO snw_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Bapiitɛ nsi ye kaamɛ obe lele. Kafɔɔ ami, diele obe lele kamawɛ ye kaamɛ. ");
INSERT INTO snw_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nnɔnyi be mmle di ɔsanko wɔ mmle lɛyɔ eekpete mi ni di suoto yi, ololaa eelolaa mi ɛɛta okookaabee nii. ");
INSERT INTO snw_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nwaako kɔtɔkɔ ye nlɛ, kakɔ lele beeyie ɔlaa biene wɔ mmle lɛkya di kayi ka mmle kamɛ yi, lɛsaa le di ɔsanko wɔ mmle lɛbla nii, bababuɛ nwu man-yɔ mannyuma nwɔ.” ");
INSERT INTO snw_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ninfɛ di basaateketetɛ lefosi banyɔ nwu nkpo onwii lɛma wɔ baatɔɔlɛɛ ni Yuda Iskariot ladie aasifi olebatatɛ banɔɔfo nfũ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ni aalaakaalɛ ma alɛ, “Be bibatɛɛ nse lediki Yesu lɛta ye?” Ninfɛ baaka koto fututu afosi atiɛ baatɔɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Diayɔ di obe nwu nkpo kamɛ diasifi nii, Yuda latoomiɛ osuku wɔ suoto abafe andiki Yesu anta nii. ");
INSERT INTO snw_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Diɛ Bloblo wɔ Ninantaka ni Dii ole kamɛ, di dii kasale suoto yi, basaateketetɛ nwu nkpo lawa Yesu nfũ babakaalɛ nwɔ alɛ, “Ɔfɛ foomiɛ falɛ bulaawa Okpi Diisi Ofe Dii ole alesaa nwu buta fɔ?” ");
INSERT INTO snw_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ni aakpee ma osuɔtɔ onwii nfũ aatɔkɔ ma alɛ, “Bitɔɔkyɛ okpoo kamɛ biɛlaatɔkɔ nwɔ bilɛ, ‘Saatuotɛ alɛ, “Obe nii ntoowo. Ami ku basaateketetɛ nii, leyo lɛfɔ bubale Okpi Diisi Ofe alesaa nwu nkpo.” ’ ” ");
INSERT INTO snw_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Nkpo oso basaateketetɛ nwu nkpo labla fɛ mmle okle di Yesu latɔkɔ ma nii, baalaawa Okpi Diisi Ofe alesaa nwu nkpo baase. ");
INSERT INTO snw_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Di obe wɔ kɔɔtɔɔfɔ lawo nii, Yesu ku basaateketetɛ nɔɔ lefosi batii banyɔ nwu nkpo lasiɛ kaasɔ alɛ boole alesaa. ");
INSERT INTO snw_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Obe wɔ boole ni alesaa nwu nkpo, Yesu latɔkɔ ma alɛ, “Nwaako kɔtɔkɔ ye nlɛ otii onwii kaamɛ lee madiki mi anta.” ");
INSERT INTO snw_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ɔlaa nwu nkpo lakpanko basaateketetɛ nwu nkpo di otu kamɛ osie kanya ni baakyako nwɔ ɔkaalɛ onwii onwii alɛ, “Saate, nwaa n-ye nlɛ diele ami falaka, sɛɛ ami dile?” ");
INSERT INTO snw_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ninfɛ di Yesu ladiki kanya alɛ, “Otii wɔ niekpee ni kɔnɛɛ kaasɛfɛ ku ami, nimadiki mi anta. ");
INSERT INTO snw_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ami, Otii Obi nwu nkpo, makpi fɛ mmle okle di Kɔkpana Klekle Kukũ labuɛ nii. Kafɔɔ otii wɔ nimadiki ami, Otii Obi nwu nkpo, anta nii, ayɔɔsa. Nse bia batanlofo nwɔ, nse dilɛ nwɔ dilenke!” ");
INSERT INTO snw_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ninfɛ di Yuda wɔ niadiki nwɔ aata ni kafɔɔ lakaalɛ nwɔ alɛ, “Saatuotɛ, nwaa n-ye nlɛ diele ami falaka, sɛɛ ami dile?” Ninfɛ di Yesu latɔkɔ nwɔ alɛ, “Nnwu fatoobuɛ nɛ.” ");
INSERT INTO snw_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Di obe wɔ di Yesu ku basaateketetɛ nɔɔ nsi boole ni alesaa yi, ni aayɔ bloblo nɛ. Ni aapɛ Yaa sɛfa, aafee nwɔ, aayɔ aata basaateketetɛ nɔɔ, aatɔkɔ ma alɛ, “Bifũ bile. Nle mmle ninle suoto nii sina nɛ.” ");
INSERT INTO snw_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ninfɛ aayɔ opũ, ni aapɛ Yaa sɛfa, aayɔ aata ma aabuɛ alɛ, “Bamuu lee bifũ binyi. ");
INSERT INTO snw_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Nle mmle ninle ntɔ nii be bɛɛyɔ beese ni kaanya di Yaa kanya ninii le eenii ni ku batii nɛ. Beewii mi kaasɔ di batii kpinwu disi alɛ Yaa kayɔ sikpile lɛma ankyɛ ma. ");
INSERT INTO snw_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nwaako kɔtɔkɔ ye nlɛ, namasinnyi nta be mmle okle diidii diɛlaase di dii le di ami ku aye bubanyi ni nta fɔle di Teemi sɛka kalekɔ nwu nkpo kamɛ.” ");
INSERT INTO snw_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ninfɛ baasa onu onwii baatansa Yaa, ni baadie baasifi Nnɔnyi Awoso Kobokote suoto nɛ. ");
INSERT INTO snw_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Nfa nfɛ di Yesu latɔkɔ basaateketetɛ nɔɔ alɛ, “Miɛ kakyɛ yi, bamuu lee bibatoso mindiɛ mi nimbu lete nii. Diekye Kɔkpana Klekle Kukũ labuɛ alɛ, ‘Yaa malo bafosokpatɛ nwu nkpo se bafoso nwu bamuu ntɔɔsamii.’ ");
INSERT INTO snw_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Kafɔɔ nse beekple bɛɛsɛnkɛsɛɛ bɛɛwako nkpa kamɛ yi, male ye katũ nsifi Galilea.” ");
INSERT INTO snw_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ninfɛ di Petro latɔkɔ Yesu alɛ, “Mintɛ bawo nii bamuu matoso mandiɛ fɔ yi, ami diidii namatoso ndiɛ fɔ!” ");
INSERT INTO snw_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ninfɛ di Yesu latɔkɔ Petro alɛ, “Nwaako kɔtɔkɔ fɔ nlɛ, kakyɛ ka mmle fiɛ di kɔɔkɔ mabo nii, fababuɛ sitiɛ simu falɛ faaye mi.” ");
INSERT INTO snw_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petro ladiki kanya alɛ, “Nse bia olo alɛ booloe munko fɔ yi, diidii namabuɛ nlɛ ninye fɔ.” Basaateketetɛ bule bamuu kafɔɔ labuɛ nkpo. ");
INSERT INTO snw_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Nfa nfɛ di Yesu ku basaateketetɛ nɔɔ nwu nkpo lasifi lɛba le bɔɔlɛɛ ni Getsemane. Ni aatɔkɔ ma alɛ, “Bisiɛ ninfũ ninkyɛ sitũ naapɛ ɔlaa nta Yaa.” ");
INSERT INTO snw_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ni aakpaa Petro ku Sebedeo babi banyɔ nwu nkpo aakyakaa di suoto nɛ. Ditaklɛ ni aabuo nyaami, aakyako otũtũkũ di suoto nɔɔ kamɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ni aatɔkɔ ma alɛ, “Konu dibuo di otu nii kamɛ osie kanya fɛle kukpi ninkle mi. Aye bisiɛ ninfũ bietoonyunkoe.” ");
INSERT INTO snw_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ninfɛ aakyɛ sitũ kɛɛkɛ nɛ, ni aapɛ akunkyi aafuusa anu kaasɔ aapɛ ɔlaa alɛ, “Teete, nse diaalɛ yi, faata dibuo opũ wɔ mmle nwu nkpo kufe mi. Kafɔɔ diele mmle okle komiɛ nii, kafɔɔ bla di dibiesaa lɛfɔ suoto.” ");
INSERT INTO snw_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ni aakple aawa basaateketetɛ nɔɔ batiɛ nwu nkpo nfũ nɛ, aabanya ma baatɔɔkyɔsĩi. Ninfɛ aakaalɛ Petro alɛ, “Ni bilaafuo osiɛ otoonyunkoe lebombo ninwii pɛ? ");
INSERT INTO snw_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Bita anu lee ate kesekese biɛpɛ ɔlaa bita Yaa alɛ bilaabuo di ɔsɔ onyu kamɛ. Ninwuna komiɛ ɔbla, kafɔɔ suoto sina nnaa osie.” ");
INSERT INTO snw_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Nni sɛmaa Yesu lakple aasifi lɛnyɔɔfa aalaapɛ ɔlaa aata Yaa alɛ, “Teete, nse dibuo le mmle dilabawaalɛ mi dife, dikaatɛ alɛ lefe ni kaamɛ, dile fɔ dibiesaa yi, faata diwa kaanya.” ");
INSERT INTO snw_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Obe wɔ aakple aawa ni basaateketetɛ nɔɔ nwu nkpo nfũ, aabanya ma baatɔɔkyɔsĩi, batafuo bia anu otikiti. ");
INSERT INTO snw_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yesu lakple aadiɛ ma aatɛ, aasifi aalaapɛ ɔlaa aata Yaa ditiɛfa aabuɛ sɛlaa se okle aabuɛ abafe nii. ");
INSERT INTO snw_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ninfɛ aakple aawa basaateketetɛ nɔɔ nwu nkpo nfũ, aabakaalɛ ma alɛ, “Sɛkyɔsĩ biɔkyɔsĩi mintɛ ɔnyɛɛ nkpo nɛ? Binyu! Obe nwu ntoowo alɛ baayɔ ami Otii Obi nwu nkpo mankpee di bakpileblatɛ nnɛɛ kamɛ. ");
INSERT INTO snw_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Bitaka buosifi. Binyu, otii wɔ nikodiki mi anta ni ntɔɔtɛɛtɛɛ.” ");
INSERT INTO snw_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu lakple aayila aatɔɔkakatɛ ko ma fiɛ di Yuda wɔ ninle ni lefosi batii banyɔ nwu nkpo onwii lɛma lawa. Batii dikudi le di olebatatɛ banɔɔfo ku kufiofa batuotɛ ku okpoo banɔɔfo ladiki ni latikanko nwɔ baatɔɔwa. Baaklee nwosoku ku mpamii. ");
INSERT INTO snw_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Otii wɔ niadiki Yesu aata ni latɔkɔ ma aatɛ alɛ, “Otii wɔ kamaminiko mbla ni atuu yi, nnwɔɔ ninle nwɔ biowolaa ni nɛ. Biemufũ nwɔ.” ");
INSERT INTO snw_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Di Yuda lanya ni Yesu, ni aakyɛ ɔkyɛ nɔɔ aalaatɔkɔ nwɔ alɛ, “Saatuotɛ, atoko ɔkyɛ ole disiɛko fɔ.” Ninfɛ aaminiko nwɔ aabla nwɔ aatuu nɛ. ");
INSERT INTO snw_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ninfɛ di Yesu ladiki kanya alɛ, “Siɛwo, lɛsaa le oso fɛɛwa ni ta dipɛsɛwa!” Ninfɛ di batii nwu nkpo ladie baawa Yesu nfũ, ni baamufũ nwɔ, baakle kpinkpĩ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ni baatii ba niawɛ ni di Yesu ɔkyɛ, onwii lɛma ladiki kapamii nɔɔ di kotofo kamɛ aasafɔ Oletatɛ Nɔɔfo kpɛmblatɛ kotoko aakpa nɛ. ");
INSERT INTO snw_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ninfɛ di Yesu latɔkɔ nwɔ alɛ, “Kplesa kapamii lɛfɔ fakpee ninfũ feediki ni. Batii ba niɛyɔ ni kapamii yi, kapamii kanya manka. ");
INSERT INTO snw_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Sɛɛ bieye bilɛ kafuo Teemi ɔlɛɛ nkaalɛ lɛkyakaako, nfanwu ankyesee mi batɔkyɛntɛ nɔɔ ba ninkpe ni kaatoo, mba ninlenke akudi lefosi anyɔ? ");
INSERT INTO snw_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Kafɔɔ nse bɛɛwa bɛbakyakaakoe, ni lɛyibabla fiɛ di ɔlaa wɔ Kɔɔkpana Klekle Kukũ lebuɛ ɛɛtɛ alɛ diawa ni, kawa kaanya?” ");
INSERT INTO snw_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Nni kamaa, ni di Yesu lamunikĩi aakaalɛ batii dikudi nwu nkpo alɛ, “Be oso di mpamii ku nwosoku bikle biɛwa mi omufũ fɛle kpileblatɛ nɔɔfo nle? Lasiɛ di Yaa Olekatakɔ nwu nkpo dii biala latuo batii asaa, kafɔɔ bitatɔkɔ bilɛ biomufũ mi. ");
INSERT INTO snw_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Asaa ya mmle amuu lɛwa kaanya alɛ diata alɛ sɛlaa se di Yaa ɔlaa babuɛtɛtɛ lakpana ni di Kɔkpana Klekle Kukũ kamɛ kawa kaanya.” Ninfɛ di basaateketetɛ nɔɔ bamuu latoso baadiɛ nwɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ninfɛ di batii ba niamufũ ni Yesu lakpaa nwɔ baasifiko Oletatɛ Nɔɔfo Kaiafa leyo nɛ, nfũ di kufiofa batuotɛ ku okpoo banɔɔfo lasi nii. ");
INSERT INTO snw_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petro latikanko nwɔ sɛɛmaa fanfa aalaabuo Yaa Oletatɛ Nɔɔfo nwu leyo kaflɔnkɔ di bawo kalɛɛkɔ. Aakyɛ aalaasiɛ di asaa banyuntɛ ɔlɔɔkɔ aatoonyu mmle okle di ɔsaabla nwu nkpo mate kunfe nii. ");
INSERT INTO snw_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Olebatatɛ banɔɔfo ku bakantɛ nwu nkpo niawɛ ni ninfa bamuu lamiɛ alɛ boobudi kanya mantika di Yesu suoto mmle okle baafuo nwɔ ni olo. ");
INSERT INTO snw_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Kafɔɔ batawɛ ɔlaa kuonwii di suoto nɔɔ, nu batii kpinwu ladie baabudi nwɔ kanya. Lɛyɛntɛle, batii banyɔ banwii ladie, ");
INSERT INTO snw_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","bababuɛ alɛ, “Otii wɔ mmle labuɛ alɛ, ‘Kamabiɛ Yaa Olekatakɔ ka mmle, ninni kamaa, mayɔ ayi atiɛ nse ni letofo.’ ” ");
INSERT INTO snw_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ninfɛ di Oletatɛ ɔnɔɔfo lataka aayila aakaalɛ Yesu alɛ, “Feenu ɔlaa wɔ beebuɛ ni di suoto lɛfɔ? Ɔmɛnlaa ninkpe fɔ fambuɛ?” ");
INSERT INTO snw_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Kafɔɔ Yesu lamaasa kanya, atabuɛ ɔlaa kuonwii. Ninfɛ di Oletatɛ Nɔɔfo lakple aatɔkɔ nwɔ alɛ, “Lɛka Yaa wɔ ninkpe ni nkpa lekpete fɔ nlɛ tɔkɔwo, nse afɔ ninle Kristo nwu nkpo, Yaa wɔ ninkpe ni nkpa Obi.” ");
INSERT INTO snw_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ninfɛ di Yesu ladiki kanya alɛ, “Ɛɛ! Nwu fatoobuɛ fɛ mmle kute ni nɛ. Kafɔɔ kɔtɔkɔ ye nlɛ, diɛyɔ di nua diesifi nii, bibanya Otii Obi nwu nkpo nsi di Yaa wɔ ninlenke ni oletanɛɛkyɛ. Bibanyɔɔ kafɔɔ eekye osi ɔɔwa di alokonkyɛ kamɛ!” ");
INSERT INTO snw_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Obe wɔ di Oletatɛ Nɔɔfo lanu ni ɔlaa wɔ mmle, ni aabɛ awu nɔɔ aabuɛ alɛ, “Bienu! Ebuɛ mbusuo ɔlaa! Diesinfĩ alɛ otii kuonwii kayila ɔlaa owo kamaa! ");
INSERT INTO snw_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Lɛ biɛnya?” Ni baamuu lɛma baadiki kanya alɛ, “Eekpi lɛpɔɔ, dikpe ni eekpi!” ");
INSERT INTO snw_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ninfɛ baatufa sita baakpete nwɔ di anu, ni baapɛ nwɔ nɛ. Bawo kafɔɔ lapɛ nwɔ nnɛɛ di atokosi. ");
INSERT INTO snw_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ni baakaalɛ nwɔ alɛ, “Afɔ ninle Kristo nwu nɛ? Tɔkɔ wo, otii wɔ niɛpɛ fɔ ni!” ");
INSERT INTO snw_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Kafɔɔ Petro lasiɛ kaayi di leyo nwu kaflɔnkɔ fiɛ di Olebatatɛ ɔnɔɔfo kpɛmblatɛ ɔsankobi onwii lawa abatɔkɔ nwɔ alɛ, “Afɔɔ fatikanko Yesu wɔ niekye ni Galilea kasɔ!” ");
INSERT INTO snw_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Kafɔɔ Petro lasĩ di batii nwu nkpo bamuu anu aabuɛ alɛ, “Ninye ɔlaa kuonwii nkyeko ɔlaa wɔ foobuɛ ni suoto.” ");
INSERT INTO snw_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ninfɛ aadie aalaayila di kaflɔnkɔ nwu nkpo kayokontũ nɛ. Ninfɛ di kpɛmblatɛ ɔsankobi bamba lanya Petro, ni aatɔkɔ basuɔtɔ ba niayila ni ninfa alɛ, “Osuɔtɔ wɔ mmle kafɔɔ latikanko Yesu Nasaret Otii nwu nkpo.” ");
INSERT INTO snw_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ninfɛ di Petro lakple aasĩ aaka di asaa aabuɛ alɛ, “Ninye osuɔtɔ nwu nkpo kama!” ");
INSERT INTO snw_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ditaklɛ saa, ni di basuɔtɔ ba niayila ni ninfa lawa Petro nfũ babatɔkɔ nwɔ alɛ, “Nwaako, afɔɔ, onwii lɛma fale. Diekye mmle okle fɔɔkakatɛ nii, ditoodiki dietuo klekle.” ");
INSERT INTO snw_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ninfɛ di Petro labuɛ alɛ, “Lɛka nlɛ nwaako kobuɛ! Yaa ananfi mi kootoko nse ɔlaa kɔlaa! Ninye osuɔtɔ wɔ mmle.” Nfanwu, ni di kɔɔkɔ labo nɛ. ");
INSERT INTO snw_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ninfɛ di Petro lanyuma alɛ Yesu latɔkɔ nwɔ alɛ, “Fiɛ di kɔɔkɔ mabo nii, fabasĩ mi sitiɛ fambuɛ falɛ, faaye mi.” Nkpo oso aadie aasifi kayi aalaawi kaku osie kanya. ");
INSERT INTO snw_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kaleesɛ ku kolesɛtũ, olebatatɛ ku okpoo banɔɔfo bamuu, baabla disibu alɛ babalo Yesu. ");
INSERT INTO snw_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Bapɛ nwɔ lekpo ni baakpaa nwɔ baalaakpee di Roma Abaa Nɔɔfo Pilato nnɛɛ kamɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Obe wɔ di Yuda wɔ niadiki Yesu aata ni lanu alɛ beelo nwɔ ni kukpi lɛpɔɔ, diabuo nwɔ suoto osie kanya. Nioso aakplesa koto fututu afosi atiɛ nwu nkpo aakyɛnko olebatatɛ banɔɔfo ku okpoo banɔɔfo nwu nkpo. ");
INSERT INTO snw_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ni aatɔkɔ ma alɛ, “Lɛbla okpile di obe wɔ lediki otii wɔ ninambla ni okpile lɛta nlɛ balo nii.” Ni baatɔkɔ nwɔ alɛ, “Nnwu nkpo diɛkaako wo. Ɔlaa lɛfɔ kule!” ");
INSERT INTO snw_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ninfɛ di Yuda layɔ koto nwu nkpo aawii di Yaa Olekatakɔ nwu nkpo ninfa, ni aasifi aalaakpee suoto okũ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ni di olebatatɛ banɔɔfo nwu nkpo lakyɛ baalaasɛsɛɛ koto nwu nkpo ni babuɛ alɛ, “Yinaa alɛ buɔyɔ koto ko mmle buɔkpɔtɔɔsa di nko ninte ni di Yaa Olekatakɔ lɛlakaa kamɛ, diekye otii ntɔ koto kule. Kufiofa loo kafɔɔ diɛta osuku.” ");
INSERT INTO snw_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Di obe wɔ baakpee ni asi baawo, baatuna alɛ babayɔ koto nwu nkpo man-ya dibukii blatɛ kasɔ, nfa kafɔɔ babatookookaa bafɔɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Nle mmle oso, bia miɛ bɔɔlɛɛ kasɔ nwu nkpo alɛ Ntɔ Kasɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Nioso ɔlaa wɔ di Yaa Ɔlaabuɛtɛtɛ Yeremia labuɛ aatɛ ni lawa kaanya nwaako. Aabuɛ alɛ, “Baayɔ koto fututu afosi atiɛ ko di Israel batii latuna alɛ baata ni diisi nɔɔ, ");
INSERT INTO snw_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","baaya dibukii blatɛ kasɔ fɛ mmle di Saate latɔkɔ mi nii.” ");
INSERT INTO snw_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Baakpaa Yesu baalaase di Roma batii abaa ɔnɔɔfo Pilato anu. Ni aakaalɛ nwɔ alɛ, “Afɔ ninle Yuda batii Ɔka nwu nɛ?” Ninfɛ di Yesu ladiki kanya alɛ, “Nnwu fatoobuɛ nɛ.” ");
INSERT INTO snw_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Kafɔɔ obe wɔ di olebatatɛ banɔɔfo ku okpoo banɔɔfo nwu nkpo layila baatoobudi nwɔ ni kanya yi, Yesu ditakpee ma kanya. ");
INSERT INTO snw_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ninfɛ di Pilato lakaalɛ nwɔ alɛ, “Ni floonu sɛlaa se boobuɛ mantika fɔ ni di suoto?” ");
INSERT INTO snw_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Kafɔɔ Yesu lasĩ atabɛ kanya adiki ɔlaa kuonwii kanya. Nioso diabla abaa nɔɔfo nwu nkpo ɔkpɛ. ");
INSERT INTO snw_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Di Okpi Diisi Ofe Dii ole biala yi, Roma batii abaa ɔnɔɔfo wɔ mmle ndiɛ Yuda batii leyo batentɛ lele baatii nwu lɛkaalɛ ni anta ma. ");
INSERT INTO snw_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Di obe nwu nkpo kamɛ yi, leyo tentɛ onwii lawɛ ma baatii n-ye nwɔ ni osie kanya ta ɔsaabla nɔɔ lalaale oso. Baatɔɔlɛɛ nwɔ Baraba. ");
INSERT INTO snw_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nioso obe wɔ baatii dikudi labasi nii, Pilato lakaalɛ ma alɛ, “Owe biomiɛ bilɛ ndiɛ nta ye? Baraba ɛɛ, sɛɛ Yesu wɔ bɔɔlɛɛ ni Kristo?” ");
INSERT INTO snw_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Aakaalɛ ma ɔlaa nwu nkpo diekye aatofo alɛ onunsɛɛ kanya oso di Yuda banɔɔfotii lakpaa Yesu baawako nwɔ. ");
INSERT INTO snw_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Di obe wɔ di Pilato lawɛ ni di kakankɔ, ɔsɔfɔ lakpee nwɔ otii alɛ, “Diki nnɛɛ lɛfɔ di otii wɔ ninambla ni okpile ɔlaa kamɛ. Diekye kɔsa kukakyɛ, diɛ alaafɔ nii kamɛ, diabuo mi ta nnwɔɔ oso.” ");
INSERT INTO snw_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Kafɔɔ olebatatɛ banɔɔfo ku okpoo banɔɔfo nwu nkpo lakpee batii dikudi nwu nkpo ɔtɔ alɛ, baakaalɛ Pilato alɛ adiɛ Baraba ata ma, aalo Yesu. ");
INSERT INTO snw_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ninfɛ di Pilato lakaalɛ batii dikudi nwu nkpo alɛ, “Batii ba mmle banyɔ, ɔmɛnle lɛma biomiɛ bilɛ ndiɛ nta ye?” Ninfɛ baadiki kanya alɛ, “Baraba!” ");
INSERT INTO snw_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ni di Pilato lakple aakaalɛ ma alɛ, “Obe biomiɛ bilɛ mbla Yesu wɔ manlɛɛ ni Kristo nwu?” Ninfɛ di bamuu lɛma baakyako ɔfaa obuɛ alɛ, “Pɛ nwɔ sibuɛ fakaasa koowoso suoto nɛ!” ");
INSERT INTO snw_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Kafɔɔ Pilato lakple aakaalɛ ma alɛ, “Ɔmɛnkpile ɛɛbla fiɛ?” Kafɔɔ mia nfɛ baakple baatɔɔfaa osie kanya baatoobuɛ alɛ, “Pɛ nwɔ sibuɛ fakaasa koowoso suoto nɛ!” ");
INSERT INTO snw_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Di obe wɔ di Pilato lanya alɛ ɔlɔbasinfuo ni lele kuniwii ɔbla, kafɔɔ kudu nfɛ nimadie ni yi, ni aayɔ ntu, aafoto nnɛɛ nɔɔ di batii nwu nkpo dikudi anu, aabuɛ alɛ, “Nnɛɛ nii diesi di osuɔtɔ wɔ mmle kukpi kamɛ lo! Oleye kule lo!” ");
INSERT INTO snw_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ninfɛ di batii dikudi nwu nkpo bamuu labuɛ alɛ, “Kukpi nɔɔ lɛkpaani ditika di awo ku babiloo disi!” ");
INSERT INTO snw_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ninfɛ di Pilato ladiɛ Baraba aata ma nɛ. Kafɔɔ obe wɔ aata baapɛ Yesu ku mpile baaloo nii, ni aayɔ nwɔ aakpee ma ninnɛɛ alɛ balaapɛ nwɔ bakaasa di kowosa suoto nɛ. ");
INSERT INTO snw_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ninfɛ di Pilato bakpɛtɛ nɔɔ nwu nkpo lakpaa Yesu baasifiko abaa nwu kaflɔnkɔ, ninfɛ di bakpɛtɛ nwu nkpo bamuu lamana nwɔ baakyi nɛ. ");
INSERT INTO snw_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ninfɛ baaklee nwɔ akpeele baadiki di suoto, ni baayɔ awu sɛɛle ya niefũ ni kɔya wua baakpa nwɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ni baabla sɛkansi lɛkakoto baatũkũsɔɔ nɛ. Ninfɛ baayɔ ɔkyɛnwoso onwii baakleesɔɔ di koletanɛɛ nɔɔ nɛ. Ninfɛ baapɛ akunkyi kaatũ nɔɔ baama nwɔ baatɔɔtaa siwidi alɛ, “Yii yiiduu! Yuda batii Ɔka, asiɛ nkpa aklɛ!” ");
INSERT INTO snw_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ni baatufa sita baakpete nwɔ di suoto nɛ, ni baafũ owoso ninnɛɛ nɔɔ baatɔɔpɛ nwɔ diisi nɛ. ");
INSERT INTO snw_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Di obe wɔ baaloo nwɔ ni ɔma, baadiki nwɔ awu sɛɛle nwu di suoto baakplesa awu nɔɔ amu baakpee nwɔ. Ninfɛ baakpaa nwɔ baasifiko alɛ bɔɔlaapɛ nwɔ sibuɛ mankaasa koowoso suoto nɛ. ");
INSERT INTO snw_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Di obe wɔ batoodie boosifi nii, ni baakyakako osuɔtɔ onwii baatɔɔlɛɛ ni Simon nɛ. Aakye Kirene kasɔ. Ninfɛ di bakpɛtɛ nwu nkpo layila nwɔ di suoto alɛ afũ Yesu kowoso nwu nkpo atuka nɛ. ");
INSERT INTO snw_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ni baakpaa Yesu baalaadu lɛba le manlɛɛ ni Golgota lɛɛsɔdiki ninle ni alɛ Otii Disi Dikufi. ");
INSERT INTO snw_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ninfɛ baayɔ nta be bɛɛkpɔtɔɔsa ni ku kɔfa lonle baata Yesu alɛ anyi nɛ. Kafɔɔ obe wɔ aatu aanyu nii, aasĩ mi onyi. ");
INSERT INTO snw_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ninfɛ di bakpɛtɛ nwu nkpo lapɛ nwɔ sibuɛ baakaasa koowoso suoto nɛ. Nni kamaa, baayɔ awu nɔɔ baasɛ bawo di obe wɔ baawii ni atrebi baatofo n-ya di obiala lɛma kayɔ nii. ");
INSERT INTO snw_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Nni kamaa, ni baasiɛ ninfa baatoonyu nwɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ni baayɔ kataabookyɛɛ baapɛ baakaasa di lɛkantosi nɔɔ, ni baakpana lɛsaa le oso beelo nwɔ nii alɛ, “Nnya Yesu Yuda Batii Ɔka Nwu Ninle Nwɔ Nɛ.” ");
INSERT INTO snw_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Baapɛ bayu banyɔ kafɔɔ sibuɛ baakaasa di awoso suoto diɛ Yesu ɔlɔɔkɔ. Onwii lakaa diɛ oletanɛɛkyɛ nɔɔ, onwii kafɔɔ lakaa diɛ ɔmɛntukyɛ. ");
INSERT INTO snw_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Batii ba niatoofe ni ninfa bamuu latũkunsa asi, baatufa Yesu baabuɛ alɛ, ");
INSERT INTO snw_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Afɔ niabuɛ falɛ fababiɛ Yaa Olekatakɔ ka mmle, fanse ni letofo di ayi atiɛ kamɛ nɛ! Nse Yaa Obi fale nwaako, faasoo koowoso nwu fawa, faafũ suoto lɛfɔ nkpa buonyu!” ");
INSERT INTO snw_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Nkpo okle kafɔɔ di olebatatɛ banɔɔfo ku kufiofa batuotɛ ku okpoo banɔɔfo nwu nkpo kafɔɔ lama nwɔ alɛ, ");
INSERT INTO snw_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Aafũ batii bamba nkpa, kafɔɔ oloofuo suoto nɔɔ odiki. Diele nnwɔɔ ninle Yuda batii Ɔka nwu nkpo nɛ? Asoo koowoso nwu nkpo suoto awa buofũ nwɔ bunu! ");
INSERT INTO snw_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Eetika Yaa disi, ɔɔlɛɛ suoto kafɔɔ alɛ Yaa Obi ale. Nse nwaako Yaa mbɔmbɔ nwɔ yi, ni aabafũ nwɔ buonyu!” ");
INSERT INTO snw_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Nkpo okle kafɔɔ di bayu banyɔ ba baapɛ baakaasa ni di awoso suoto ku nnwɔɔ kafɔɔ latufa nwɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kakũ lefosi elomu ɛnyɔ lebe, kayi kamuu lawɔfɔ, dialaase di kɔtɔɔfɔ elomu etiɛ kamɛ. ");
INSERT INTO snw_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Di kɔtɔɔfɔ elomu etiɛ kamɛ okle, Yesu lafaa osie kanya aabuɛ alɛ, “Eli, Eli, lama sabaktani?” Lɛsɔdiki ninle alɛ, “Yaa nii, Yaa nii, be oso feediɛ mi nnɛɛ nkpo?” ");
INSERT INTO snw_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Batii ba bawo niayila ni ninfa, baanu ni ɔlaa nwu nkpo labuɛ alɛ, “Ɔɔlɛɛ Elia!” ");
INSERT INTO snw_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Nfanwu onwii kaamɛ lɛma latoso aalaayɔ oleteku aanyɔ di nta nyankale kamɛ, aayɔ aatũ di owoso suoto, aamiɛ alɛ ɔɔyɔ ankyɔɔ nwɔ annyi. ");
INSERT INTO snw_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Kafɔɔ batii bamba labuɛ alɛ, “Bita buyila buonyu, nse Elia kamawa amadiki nwɔ di kowoso suoto.” ");
INSERT INTO snw_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesu lakple aafaa lɛyɛntɛle, ninfɛ niinwuna nɔɔ ladie nɛ. ");
INSERT INTO snw_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Nfanwu, dibula le ninsaka ni di Yaa Olekatakɔ nwu nkpo kamɛ niabɛ di akyuu anyɔ diakye di osi dialaase kaasɔ. Kasɔ kafɔɔ latukũ, afuɔ labibiɛ. ");
INSERT INTO snw_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Sɛkya kafɔɔ labɛ siatikiti, Yaa batii klekle ba nintookpi bɛɛbafe ni bawo lataka baakye bakpi kamɛ. ");
INSERT INTO snw_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Baadie di sɛkya lɛma kamɛ obe wɔ di Yesu lakple aataka aakye ni bakpi kamɛ yi, baasifi Yerusalem okpoo klekle nwu nkpo kamɛ baalaadiki suoto baatuo batii kpinwu. ");
INSERT INTO snw_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Di obe wɔ di bakpɛtɛ ɔnɔɔfo ku bakpɛtɛ nwu nkpo niayila baatonyu ni Yesu lanya mmle okle kaasɔ latukũ ni ku aasaa ya amuu niabla ni yi, lɛyɛkɛ lapɛ ma osie kanya! Ninfɛ baabuɛ alɛ, “Nwaako, Yaa Obi ninle otii wɔ mmle!” ");
INSERT INTO snw_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Basanko ba kpinwu kafɔɔ niatikanko Yesu baatɔɔkyakaako nwɔ ni, baakye ni Galilea lawɛ ninfa. Baayila kaakyonkɔ baatoonyu asaa ya niatɔɔwa nii. ");
INSERT INTO snw_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Basanko nwu nkpo bawo kaamɛ lɛma niale Maria Magdalene, Maria wɔ ninle ni Yakobo ku Yosef ɔya ku Sebedeo ɔsɔfɔ. ");
INSERT INTO snw_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Obe wɔ kɔɔtɔɔfɔ lawo nii, osuɔtɔ onwii niale ni saawɛntɛ baatɔɔlɛɛ ni Yosef lawa, aakye Arimatea. Yesu saateketetɛ aale. ");
INSERT INTO snw_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Aakyɛ Pilato nfũ alɛ ayɔ Yesu kpi atɔɔ. Ninfɛ di Pilato lata osuku alɛ balaayɔ kpi nwu nkpo batɔɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ninfɛ di Yosef lasifi aalaayɔ kpi nwu nkpo, ni aayɔ dibula fututu aamiminisa nwɔ di suoto nɛ. ");
INSERT INTO snw_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ninfɛ aayɔ nwɔ aalaakokaa di ofuɔntuu ɔkya fɔle wɔ aakutu aata ni suoto kamɛ nɛ. Ninfɛ aamunusa difuɔ dibinte ninwii aatĩi ofuɔntuu nwu kanya nɛ. Ni aasifi nɛ. ");
INSERT INTO snw_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ninfɛ di Maria Magdalene ku Maria nyɔɔfa lasiɛ ninfa baakyɔɔ ɔkya nwu nkpo anu nɛ. ");
INSERT INTO snw_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Kaleesɛ niale ni Lɛnyɛɛtɛyi yi, olebatatɛ banɔɔfo ku Farisi batii lalɛɛ bawo di Pilato nfũ. ");
INSERT INTO snw_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ni baatɔkɔ nwɔ alɛ, “Ɔnɔɔfo, buonyuma bulɛ obe wɔ di laatɛ nwu nkpo lasiɛ ni nkpa yi, aabuɛ alɛ, ‘Nse lekpi yi, makple ntaka nkye bakpi kamɛ di ayi atiɛ kamɛ.’ ");
INSERT INTO snw_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nkpo oso ta falɛ basaanyuntɛ lɛlaayila beenyu ɔkya nwu nkpo osie kanya diɛlaase di ayi atiɛ kamɛ. Nse faata babla nle mmle yi, basaateketetɛ nɔɔ makyɛ manayu nwɔ mansifiko, manatɔkɔ batii alɛ, ‘Atɔɔtaka eekye bakpi kamɛ.’ Nse diɛwa ninkpo yi, sɛlaa kuafunu se babakple malaa ni malenkee lɛkasale.” ");
INSERT INTO snw_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ninfɛ di Pilato latɔkɔ ma alɛ, “Bita bakpɛtɛ bakyɛ balaayila banyu ɔkya nwu nkpo fɛ mmle dikaatɛ ni.” ");
INSERT INTO snw_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ninfɛ baakyɛ baalaatĩi ɔkya nwu nkpo kanya osie kanya baatɛ nwu nsũ nɛ. Ninfɛ baadiki bakpɛtɛ baase baatoonyu ɔkya nwu nkpo nɛ. ");
INSERT INTO snw_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Obe wɔ di Lɛnyɛɛtɛyi ntɔbafe nii, di Kɔsida kolesɛtũ, Maria Magdalene ku Maria wɔ nyɔɔfa lakyɛ alɛ bɔɔlaanyu Yesu ɔkya nwu nkpo. ");
INSERT INTO snw_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Nfanwu, kasɔ latũkũ osie kanya. Ni di Yaa tɔkyɛntɛ onwii lasoo aakye osi aawa, abamunusa difuɔ nwu nkpo di ɔkya kanya, ni aasiɛ ni di suoto nɛ. ");
INSERT INTO snw_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Suoto nɔɔ odiki otuo late fɛ ɔplalaa nimunaa, awu nɔɔ kafɔɔ lapu fɛle oleteku. ");
INSERT INTO snw_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Lɛyɛkɛ lamufũ basaanyuntɛ nwu nkpo osie kanya, baakyako otũtũkũ baaklee baabla fɛ bakpi. ");
INSERT INTO snw_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ninfɛ di Yaa tɔkyɛntɛ nwu nkpo latɔkɔ basanko nwu alɛ, “Bitanyɛkɛ. N-ye nlɛ Yesu wɔ baapɛ sibuɛ baakaasa ni koowoso suoto biowolaa. ");
INSERT INTO snw_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Anaa ninfũ. Atɔɔtaka akpe nkpa fɛ mmle aatɔkɔ ye nii. Biwa biɛbanyu lɛba le baatɛ nwu ni. ");
INSERT INTO snw_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Kanunua bipɛsɛwa biɛtɔɔkyɛ bilaatɔkɔ basaateketetɛ nɔɔ bilɛ, ‘Aatɔɔtaka eekye bakpi kamɛ. Atoole ye katũ oofe Galilea. Nfa bibanyɔɔ nɛ.’ Binyuma ɔlaa wɔ lɛtɔkɔ ye ni!” ");
INSERT INTO snw_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Nkpo oso baapɛsɛwa baakyɛ di ɔkya nwu katũ baasifi. Baatɔɔyɛkɛ, kafɔɔ suoto latɔyɔɔ ma baatoso alɛ bɔɔlaatɔkɔ basaateketetɛ nɔɔ ɔlaa nwu nkpo. ");
INSERT INTO snw_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Nfanwu, Yesu lakyakako ma di osuku. Ni aatɔkɔ ma alɛ, “Atoko ɔkyɛ ole disiɛko ye.” Ninfɛ baakpukuti baatɛɛtɛ nwɔ, baamufũ nwɔ nkpaa, baasumu nwɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ninfɛ di Yesu latɔkɔ ma alɛ, “Bitanyɛkɛ. Bitɔɔkyɛ biɛlaatɔkɔ babiloo bilɛ, batɔɔkyɛ Galilea, babanyɛɛ ninfa.” ");
INSERT INTO snw_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Di obe wɔ di basanko nwu nkpo ntɔɔkyɛ boosifi nii, basaanyuntɛ nwu nkpo bawo niatoonyu ni ɔkya nwu nkpo, baasifi okpoo kamɛ baalaatɔkɔ olebatatɛ banɔɔfo asaa ya amuu niawa ni ninfa. ");
INSERT INTO snw_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ninfɛ di olebatatɛ banɔɔfo nwu nkpo ku okpoo banɔɔfo, lalɛɛ bawo baabla disibu nɛ. Ni baata basaanyuntɛ nwu nkpo koto dikudi kplɛ ninwii nɛ, ");
INSERT INTO snw_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ni baatɔkɔ ma alɛ, “Bibuɛ bilɛ obe wɔ bite biɔkyɔsĩi ni ku kakyɛ, ni baasaateketetɛ nɔɔ labayu nwɔ baasifiko nɛ. ");
INSERT INTO snw_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Nse Abaa Nɔɔfo lenu ɔlaa wɔ mmle kafɔɔ yi, bubablako nwu ɔkpɛ, muntɔɔ annu kasɔ bulɛ, diele aye ninkyɛnko.” ");
INSERT INTO snw_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Basaanyuntɛ nwu nkpo lafũ koto nwu nkpo baabla fɛ mmle okle baakpee ma nii. Nioso ɔlaa lɛma nwu nkpo labiɛ kuabuo di Yuda batii kamɛ diɛbase bia miɛ. ");
INSERT INTO snw_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ninfɛ di basaateketetɛ nɔɔ lefosi onwii nwu nkpo, lakata baasifi Galilea di kobokote ko suoto di Yesu latɔkɔ ma alɛ basifi ni nɛ. ");
INSERT INTO snw_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Di obe wɔ baanyɔɔ nii, baase akunkyi kaasɔ baasumu nwɔ. Kafɔɔ batii bawo kaamɛ lɛma ditafũ baanu alɛ nnwɔɔ diale. ");
INSERT INTO snw_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ninfɛ di Yesu lakpukuti aatɛɛtɛɛ ma ni aatɔkɔ ma alɛ, “Yaa lɛyɔ osi ku kasɔ osie omuu eekpee mi di nnɛɛ kamɛ. ");
INSERT INTO snw_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nkpo oso bitɔɔkyɛ kayi ka mmle nnle mmuu kamɛ, biɛlaabla batii basaateketetɛ nii. Biekpeesa ma Yaa ntu di Ote, Obi, ku Ninwuna Klekle leyooto kamɛ. ");
INSERT INTO snw_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Bietuo ma bilɛ bakyɔɔ asaa ya amuu letuo ye ni atoko. Nwaako kamasiɛko ye obe lele ninaadu bia kayi ka mmle kalookɔ.”");
INSERT INTO snw_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Nnya ɔlaa biene wɔ niekye ni Yesu Kristo Yaa obi suoto kasɔ kakyekɔ. ");
INSERT INTO snw_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Binyu! Diawa fɛ mmle di Yaa Ɔlaa Buɛtɛtɛ Yesaia lakpana aatɛ ni kofokofoko alɛ, “Makyesee tɔkyɛntɛ nii anle fɔ katũ, aanaalolaa osuku antɛ fɔ. ");
INSERT INTO snw_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Otii nwu matooyie lɛkya di ɔfaafuu antoobuɛ alɛ, ‘Bilolaa osuku bitɛ bita Saate nwu ɔwabee. Bikyɛkyɛsa abaya abafe ni bitɛ nwɔ.’ ” ");
INSERT INTO snw_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Tɔkyɛntɛ nwu niale Yohane nɛ. Aawɛ di ɔfaafuu aabatookpeesa batii Yaa ntu. Aatɔɔtakɔ ma alɛ, “Bidiɛ sikpile lee ɔbla baakpeesa ye Yaa ntu, ni Yaa mayɔ sikpile lee ankyɛ ye.” ");
INSERT INTO snw_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Batii kpinwu lakye Yudea kasɔ ku Yerusalem okpoo kplɛ baakyɛ ɔfaafuu baalaanu Yohane ɔlaa. Baadiki sikpile lɛma baabuɛ ni aakpeesa ma Yaa ntu di Yordan okle kamɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Di obe wɔ mmle kamɛ Yohane lakpee kapupɔnkɔ sinwini awu, ni aayɔ bɔkɛɛ kukũ okũ aatika ofiamɛ nɛ. Alesaa nɔɔ niale akpakyekyee ku bablɔ. ");
INSERT INTO snw_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ɔlaa wɔ aatoobuɛ ninle alɛ, “Otii wɔ nimawa ni sɛɛmaa nii nlenke mi. Ale Otii wɔ ninansiɛko alɛ bia kadiki nwɔ ni ntokota fɛ kpɛmblatɛ. ");
INSERT INTO snw_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ami ntu kɔyɔ nkpeesa ye Yaa ntu, kafɔɔ nnwɔɔ abayɔ Ninwuna Klekle ankpeesa ye kaamɛ.” ");
INSERT INTO snw_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ditaklɛ, Yesu lakye Nasarɛt diɛ Galilea kasɔ aawa, ni di Yohane lakpeesa nwɔ Yaa ntu di Yordan okle kamɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nfanwu di Yesu latoodie ni di ntu nwu kamɛ, aanya kolo lasɛkɛtɛ, ni di Ninwuna Klekle latoosoo di suoto nɔɔ fɛ mmle di lɛlaapɔɔ nsoo ni nɛ. ");
INSERT INTO snw_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ni baanu sɛɛlɔ lakye osi siabuɛ alɛ, “Afɔ ninle Obi nii wɔ suoto ninantuna ni nɛ, foobuo mi anu nwaa.” ");
INSERT INTO snw_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Nfanwu Ninwuna Klekle lakpaa nwɔ aasifiko ɔfaafu. ");
INSERT INTO snw_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ni aasiɛ ninfa lete nɔɔ ayi afosi ana Satana lasɔ nwɔ aanyu nse abatikanko nwɔ. Babɔkɛɛ ba ninkpe ni kobe lawɛ ninfa, kafɔɔ di obe nwu kamɛ Yaa batɔkyɛntɛ lakye osi baabakpee nwɔ osie. ");
INSERT INTO snw_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Obe wɔ baatɛ ni Yohane leeyo katenkɔ sɛmaa, Yesu lakyɛ Galilea kasɔ aalaatoobuɛ ɔlaa biene wɔ niekye ni Yaa nfũ. ");
INSERT INTO snw_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Aatoobuɛ alɛ, “Obe biene nwu ntoowo, Yaa sɛka ole bee ntɔɔtɛɛtɛɛ, bidiɛ sikpile ɔbla biefũ ɔlaa biene nwu binu!” ");
INSERT INTO snw_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Obe wɔ di Yesu latoofe ni di Galilea lekpo ɔlɔɔkɔ, aanya kɔkpaku badikitɛ banyɔ banwii, Simon ku obilɛma Andrea baatoodiki kɔkpaku ku asawu. ");
INSERT INTO snw_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ninfɛ di Yesu latɔkɔ ma alɛ, “Biwa biɛbatikankoe, matuo ye mmle mandiki ni batii.” ");
INSERT INTO snw_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Nfanwu ni baadiɛ asawu lɛma, baatikanko nwɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Aakyɛ ni sitũ kɛɛkɛ, ni aanya babilɛma banyɔ banwii ninle ni Sebedeo babi Yakobo ku Yohane, baasiɛ di oklo kamɛ baatoololaa asawu lɛma. ");
INSERT INTO snw_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Di Yesu lanya ma nii, ni aalɛɛ ma alɛ batikanko nwɔ nɛ. Ni baadiɛ ote lɛma Sebedeo ku bakpɛntɛ nɔɔ di oklo kamɛ baatikanko nwɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ni baasifi Kapernaum okpoo nɛ. Obe wɔ di Yuda batii Lɛnyɛɛtɛyi nwu lawo nii, Yesu lasifi kasiisakɔ lɛma, ni aalaakya ko batii asaa otuo nɛ. ");
INSERT INTO snw_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Asaa nɔɔ otuo labla ma ɔkpɛ, diekye aatuo ma asaa fɛ otii wɔ ninkpe ni otumi, ninanle ni fɛ mmle di kufiofa batuotɛ ntuo nii. ");
INSERT INTO snw_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Nfanwu osuɔtɔ onwii di ninwuna kpile lasiɛ nii lawɛ kaamɛ lɛma, ");
INSERT INTO snw_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ni aafaa osie kanya aabuɛ alɛ, “Be foomiɛ di ɔkyɛ loo, afɔ Yesu Nasaret Otii ntɛɛ? Ɔwɔɔsa fɛɛwa wo? N-ye otii wɔ fale nii! Afɔ ninle Otii Klekle wɔ di Yaa lekyesee ni nɛ!” ");
INSERT INTO snw_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ni di Yesu lamuɛ nwɔ alɛ, “Lo kanana, faadie nwɔ kaamɛ!” ");
INSERT INTO snw_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ni di ninwuna kpile nwu latũkunsa osuɔtɔ nwu osie kanya, ni aafaa osie kanya, ni diadie nɛ. ");
INSERT INTO snw_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Diabla batii ba niayila ni ninfa bamuu ɔkpɛ diata baatɔɔkaalɛ bawo alɛ, “Be nɛ? Asaa otuo fɔle ale? Ɛɛyɔ otumi ootososa anwuna kpile annu!” ");
INSERT INTO snw_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ta nkpo oso Yesu leyooto lakyaka Galilea kasɔ kamuu. ");
INSERT INTO snw_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Nfanwu di Yesu ku batii nɔɔ ladie ni kaasiisakɔ nwu, baakpaa Yakobo ku Yohane baasifi Simon ku Andrea leyo. ");
INSERT INTO snw_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Baabuo ni nfa batii bawo latɔkɔ Yesu alɛ, Simon ɔmaato nte ofiɛ lɛwɔɔfɔ ofiɛ. ");
INSERT INTO snw_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Nioso Yesu lakyɛ ɔkyɛ nɔɔ aalaamufũ nwɔ kɔɔnɛɛ aatakatɛsa, ni di ofiɛ layɔɔ nwɔ nɛ, ni aataka aanyu ma kanya nɛ. ");
INSERT INTO snw_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Obe wɔ kuufĩ ntɔɔmɛɛ nii, baakpaa bafiɛtɛ kpinwu ku mba di anwuna kpile nsi ni baawako Yesu ɔkyɛ alɛ ayɔɔsa ma sifiɛ. ");
INSERT INTO snw_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ni diɛ okpoo nwu batii bamuu labasi diɛ kayokontũ nwu baatoonyu nɛ. ");
INSERT INTO snw_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ni aakya batii ba bamuu niatoofiɛ ni sifiɛ ate ate sifiɛ. Ni aatososa anwuna kpile atata nya osuku alɛ akakatɛ, diekye anwuna kpile nwu latofo otii wɔ okle ale nii. ");
INSERT INTO snw_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Yesu lataka kuyitatũ aadie leeyo aasifi lɛba le nialo ni lete nɔɔ, aalaapɛ ɔlaa aata Yaa. ");
INSERT INTO snw_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Sɛmaa Simon ku bawo nɔɔ lakyɛ baalaatowolaa Yesu. ");
INSERT INTO snw_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Obe wɔ baanyɔɔ nii, baatɔkɔ nwɔ alɛ, “Otii biala kowolaa fɔ!” ");
INSERT INTO snw_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ni aatɔkɔ ma alɛ, “Bita busifi sekpoo bibii bamba se niɛtɛɛtɛɛ ni, ninaabuɛ Yaa ɔlaa ninfa kafɔɔ nta ma, diekye nni oso lɛwa nɛ.” ");
INSERT INTO snw_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Nioso aakyɛ aatookyi nsiisakɔ lɛma nwu diɛ Galilea kasɔ aatoobuɛ Yaa ɔlaa, aatootososa anwuna kpile baatii suoto. ");
INSERT INTO snw_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ni di osuɔtɔ onwii niatoofiɛ ni ofiɛ sɛɛle lawa Yesu ɔkyɛ aalaapɛ akunkyi, aatootikiti nwɔ lekoto alɛ, “Nse dilɛ fɔ, faafuo ɔta suoto nii mbla klekle.” ");
INSERT INTO snw_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ɔlaa nɔɔ lakpɛ nwɔ nyaami, ni di Yesu ladiki kɔnɛɛ aakpanko nwɔ, aatɔkɔ nwɔ alɛ, “Letuna, suoto lɛfɔ siklekle!” ");
INSERT INTO snw_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Nfanwu, ofiɛ sɛɛle nwu layɔɔ nwɔ suoto nɔɔ laklekle. ");
INSERT INTO snw_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ni di Yesu ladiki nwɔ osuku aakpee nwɔ kufiofa alɛ, ");
INSERT INTO snw_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Nyu, tanaabuɛ ɔlaa wɔ mmle faatɔkɔ otii kuonwii, tɔɔkyɛ falaadiki suoto fatuo Yaa oletatɛ, faata ole di mmle di Mose lekpee kufiofa ɛɛtɛ ni di suoto okleklesa suoto, diatuo alɛ ɔfiɛ nwu ntɔɔyɔɔ fɔ ni.” ");
INSERT INTO snw_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Kafɔɔ aasifi nii, aalaatoobuɛ ɔlaa nwu aatɔɔkyakasa osie kanya, ta nkpo oso Yesu ditasinfuo kayi otoodie di okpoo kuonwii kamɛ. Ɔfaafuu aatoosiɛ, kafɔɔ batii lakple baakye aba aba batɔɔwa ɔkyɛ nɔɔ. ");
INSERT INTO snw_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ayi asɛɛ sɛmaa Yesu lakple aasifi Kapernaum okpoo. Di obe kakui kamɛ batii lanu alɛ akpe leeyo. ");
INSERT INTO snw_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ni baatii kpinwu lasi diɛ leyo le aabuo nii, diata alɛ baalaadu bia kayokontũ, bawo ditasinwɛ kayilakɔ. Ni aabuɛ Yaa ɔlaa aata ma nɛ. ");
INSERT INTO snw_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ni baatii bana latuka fiɛtɛ onwii niafefee nii baatɔɔwako ɔkyɛ nɔɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Batii lɛpɔ oso batawɛ osuku baatɛɛtɛɛ Yesu di leyo le kamɛ aawɛ nii, nioso baasifi baalaayie lɛkya osi baalaadufu kutuɛ, baasoosa fiɛtɛ nwu ku ɔkla nɔɔ wɔ suoto aate nii baatɛ kaasɔ di Yesu anu. ");
INSERT INTO snw_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Di Yesu lanya ni ofũ onu lɛma oso aatɔkɔ fefeetɛ nwu alɛ, “Obi nii, ntɔɔyɔ sikpile lɛfɔ bɛɛkyɛ fɔ.” ");
INSERT INTO snw_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Obe nwu kamɛ Yuda batii kufiofa batuotɛ bawo lasiɛ ninfa, baatoobu di disi lɛma kamɛ alɛ, ");
INSERT INTO snw_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Lɛ oso ɔɔkakatɛ nkpo? Eebuɛ mbusuo ɔlaa di Yaa suoto. Yaa lete nikafuo sikpile ɔyɔ ɔkyɛ!” ");
INSERT INTO snw_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Nfanwu Yesu latofo disbu lɛma ni aatɔkɔ ma alɛ, “Be oso biobu disi kpile nkpo? ");
INSERT INTO snw_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Lɛmɛnle niɛyɔɔ dilenke, alɛ baatɔkɔ otii wɔ niefefee ate ni alɛ, ‘Bɛɛyɔ sikpile lɛfɔ bɛɛkyɛ fɔ’ ɛɛ sɛɛ baabuɛ alɛ, ‘Taka, faayɔ ɔkla lɛfɔ faakyɛ’? ");
INSERT INTO snw_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ta biatofo bilɛ, Otii Obi, nkpe otumi kaasɔ ka alɛ aayɔ sikpile ankyɛ nii.” Ni aatɔkɔ otii wɔ niefefe ate ni alɛ, ");
INSERT INTO snw_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Kɔtɔkɔ fɔ nlɛ taka! Yɔ ɔkla lɛfɔ, faasifi leyo!” ");
INSERT INTO snw_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Nfanwu otii wɔ niafefee aate ni niataka aayɔ ɔkla nɔɔ, aadie ma kaamɛ aasifi. Diabla bamuu lɛma ɔkpɛ ni baatansa Yaa baabuɛ alɛ, “Buunya nnle mmle okle bunya!” ");
INSERT INTO snw_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ni di Yesu lakple aadie ninfa aasifi Galilea lekpo kotoko ni baatii kpinwu lawa nwɔ ɔkyɛ ninfa ni aatuo ma asaa nɛ. ");
INSERT INTO snw_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Obe wɔ aatoofe ni lekpo nwu kotoko ninfɛ aanya Lewi, Alfeo obi, asi di akpooto kafunkɔ oofũ akpooto, ni di Yesu latɔkɔ nwɔ alɛ, “Tikankoe!” Nfanwu ni aataka aatikanko nwɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Dii nwu kɔtɔɔfɔ Yesu ku basaateketetɛ nɔɔ lakyɛ Lewi leyo alɛ, bɔɔlaaleko nwɔ alesaa. Batii kpinwu latikanko nwɔ, batii ba niatikanko nwɔ ni nkpo bawo niale akpooto bafuntɛ ku bakpileblatɛ. ");
INSERT INTO snw_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Nioso obe wɔ di kufiofa batuotɛ ba ninle ni Farisi batii lanya alɛ Yesu kole ni alesaa ku bakpiletɛ ku akpooto bafuntɛ, baakaalɛ basaateketetɛ nɔɔ alɛ, “Lɛ oso ole alesaa ku akpooto bafuntɛ ku bakpileblatɛ bamba ba mmle?” ");
INSERT INTO snw_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Obe wɔ di Yesu lanu ni ɔlaa wɔ boobuɛ nii, ni aatɔkɔ ma alɛ, “Fablatɛ diefĩ batii ba ninoofiɛ nii, bafiɛtɛ di fablatɛ lefĩ. Ninwa babienetɛ ɔlɛɛ, bakpileblatɛ oso lɛwa.” ");
INSERT INTO snw_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Di obe nwu kamɛ, di Yohane basaateketetɛ ku Farisi basaateketetɛ nnii ni kanya oso, ni baatii bawo lawa baabakaalɛ Yesu alɛ, “Obe oso fiɛ diɛ Yohane basaateketetɛ ku Farisi basaateketetɛ nnii ni kanya fiɛ baasaateketetɛ lɛfɔ ninannii kanya?” ");
INSERT INTO snw_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ni di Yesu latɔkɔ ma alɛ, “Lɛ di ɔkafɔɔsa basiɛwo kanii kanya obe wɔ di ɔkafɔɔsa nkpe ma ni di ɔkyɛ? Balaafuo kanya onnii di obe wɔ akpe ma ni di ɔkyɛ. ");
INSERT INTO snw_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Kafɔɔ obe kɔwa babakpaa ɔkafɔɔsa mansifiko nii, obe nwu kamɛ babanii kanya nɛ. ");
INSERT INTO snw_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Kuonwii nín-yɔ dibula fɔle kakyɛɛ aakaa aatĩi dibula kofole kabɛkɔ. Se ɛɛbla nkpo, dibula fɔle nwu matuunii ninsifi lekofole kabɛkɔ nwu ninfoofoosa ninkyakaa. ");
INSERT INTO snw_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Kuonwii nín-yɔ nta fɔle aakpete di kɔbɔkɛɛkũ kotofo kofole kamɛ, se diɛwa ninkpo, nta fɔle nwu mata kotofo nwu mbɛ, ninta alɛ nta ku kotofo nwu nlalaa. Kɔbɔkɛɛkũ fɔle kamɛ man-yɔ nta fɔle mankpete.” ");
INSERT INTO snw_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Di Lɛnyɛɛtɛyi, Yesu ku basaateketetɛ nɔɔ latoofe di atita kofe kunwii kamɛ. Ni di basaateketetɛ nɔɔ, lafee atita nwu kɔɔne awo baatoowee nɛ. ");
INSERT INTO snw_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ta nkpo oso Farisi batii bawo Lakaalɛ Yesu alɛ, “Nyu! Be oso baasaateketetɛ lɛfɔ kɔbla nkpo, kuufiofa loo ninanta ni osuku di Lɛnyɛɛtɛyi suoto?” ");
INSERT INTO snw_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ni di Yesu ladiki kanya alɛ, “Sɛɛ biika lɛsaa le diɛ Ɔka Dawid ku batii nɔɔ labla ni di Kɔkpana Klekle kamɛ binya, obe wɔ kɔɔka lakle ma ni? ");
INSERT INTO snw_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Mmle aabuo ni Yaa Olekatakɔ diɛ obe wɔ di Abiatar lale ni Yaa Oletatɛ Nɔɔfo. Aadiki bloblo klekle wɔ mananta osuku alɛ otii wɔ ninanle ni Yaa oletatɛ kale ni aale ni, aayɔ owo aata manko bawo nɔɔ ba kafɔɔ niakyɛ ni bale ni?” ");
INSERT INTO snw_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ni di Yesu latɔkɔ ma alɛ, “Otii dibiene oso di Yaa lɛbla Lɛnyɛɛtɛyi, ni diele Lɛnyɛɛtɛyi oso ɛɛbla otii. ");
INSERT INTO snw_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nioso ami, Otii Obi, ninle Lɛnyɛɛtɛyi Saate.” ");
INSERT INTO snw_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesu lakple aakyɛ Yuda batii kasiisakɔ kanwii, otii onwii kɔɔnɛɛ nɔɔ lakatu ni lawɛ ninfa. ");
INSERT INTO snw_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Di obe nwu kamɛ, Yesu balo lawɛ ninfa. Baatoonyu osuku alɛ abayɔɔsa osuɔtɔ nwu ofiɛ di Lɛnyɛɛtɛyi nwu suoto mmle baayɔ ni ɔlaa di suoto nɔɔ. ");
INSERT INTO snw_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu latɔkɔ osuɔtɔ nwu kɔɔnɛɛ lɛkatu ni alɛ, “Taka fawa sitũ ninfũ.” ");
INSERT INTO snw_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ninfɛ di Yesu lakaalɛ batii nwu niawɛ ni ninfa alɛ, “Kufiofa lɛta osuku alɛ, baabla dibiene di Lɛnyɛɛtɛyi ɛɛ sɛɛ dikpile? Baafũ otii nkpa ɛɛ sɛɛ baadiɛ nwɔ ankpi?” Kafɔɔ baalo kanana. ");
INSERT INTO snw_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesu lanyunyu ma aafenko ku ɔblɔ. Disi osie lɛma oso kafutu lanyiyii nwɔ, ni aatɔkɔ fiɛtɛ nwu alɛ, “Yilasa kɔnɛɛ lɛfɔ!” Ni aayilasa kɔnɛɛ nɔɔ nɛ. Nfanwu ni kualɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Nioso Farisi batii ladie baalaakpee asi baawo ku Herodes batikankotɛ nɔɔ bawo mmle baalo ni Yesu. ");
INSERT INTO snw_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu ku basaateketetɛ nɔɔ ladie ninfa baasifi Galilea lɛpanta kotoko. Ni batii kpinwu niakye ni Galilea latikanko ma nɛ. ");
INSERT INTO snw_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Batii dikudi kafɔɔ lakye Yudea, Yerusalem, Idumea ku Yordan okle sɛmaa kuɛ Tiro ku Sidon ntɛɛ nwu baawa ɔkyɛ nɔɔ. Diekye baanu Yesu sɛkpɛ kplɛ se aatɔɔbla nii. ");
INSERT INTO snw_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ta batii dikudi nwu lɛpɔ oso Yesu latɔkɔ basaateketetɛ nɔɔ alɛ bamiɛ oklo owo batɔɔ aasiɛ kaamɛ mmle baatii dikudi nwu dilaba pimpi nwɔ ni. ");
INSERT INTO snw_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Aakya batii kpinwu sifiɛ, nioso diata alɛ bafiɛtɛ ba niakyɛ ni nfa latikanko baatoomiɛ osuku alɛ bɔɔkpanko nwɔ siifiɛ lɛma nyɔɔ ma. ");
INSERT INTO snw_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Batii bawo lawɛ ninfa di anwuna kpile lasiɛ ma ni kaamɛ. Nioso nse diɛwa alɛ bɛɛnya Yesu, manɔɔ nwɔ di nkpaatũ, manyiisa kudu mambuɛ alɛ, “Afɔ ninle Yaa obi!” ");
INSERT INTO snw_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Kafɔɔ Yesu lakpee anwuna kpile nwu kufiofa osie kanya alɛ batanta batii latofo otii wɔ okle ale nii. ");
INSERT INTO snw_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Nni sɛmaa Yesu lasifi kabokotee osi. Nfa aalaadiki basaateketetɛ ba omiɛ ni nɛ. ");
INSERT INTO snw_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Aadiki lefosi batii banyɔ ba aata ni leyoto alɛ batɔkyɛntɛ. Ni aatɔkɔ ma alɛ, “Ntoodiki ye nlɛ biatikankoe obe lele. Makpee ye kafɔɔ minaatoobuɛ mi ɔlaa biene. ");
INSERT INTO snw_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Mata ye otumi kafɔɔ mintososa anwuna kpile.” ");
INSERT INTO snw_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Nya batii ba di Yesu ladiki ni. Mma ninle Simon wɔ di Yesu lata ni leyoto alɛ Petro ");
INSERT INTO snw_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ku Yakobo ku obilɛma suɔtɔbi Yohane mba ninle ni Sebedeo babi ba di Yesu lata ma ni leyoto alɛ Boanege, lɛɛsɔ diki nɔɔ ninle ni ɔplalaa. ");
INSERT INTO snw_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Banyɛntɛle kafɔɔ ninle Andrea ku Filipo ku Bartolomeo ku Mateo ku Toma ku Yakobo wɔ ninle ni Alfeo obi ku Tadeo ku Simon wɔ niabɔmbɔ ni kale nɔɔ osie kanya ");
INSERT INTO snw_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","kuɛ Yuda Iskariot wɔ niadiki Yesu aata nii. ");
INSERT INTO snw_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesu ladie ni ninfa, aawa leyo ninwii kamɛ. Ni baati kpinwu lakple baabasi ninfa nɛ. Batii lɛpɔ oso Yesu ku basaateketetɛ nɔɔ ditawɛ kayaa baale alesaa. ");
INSERT INTO snw_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Baanantii nɔɔ lanu nii, baakyɛ alɛ bɔɔlaakpaa nwɔ, diekye batii latoobuɛ alɛ, “Disi kamɛ kɔkpɔtɔɔ nwɔ!” ");
INSERT INTO snw_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Kufiofa batuotɛ ba niakye Yerusalem baawa ni labuɛ alɛ, “Anwuna kpile ɔka Beelsebul ninsi di Yesu kamɛ. Nni suoto anfe antososa anwuna kpile baatii kamɛ nɛ!” ");
INSERT INTO snw_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Nioso Yesu lalɛɛ ma aawako ɔkyɛ nɔɔ, ni aakakatɛ aata ma di akpa kamɛ alɛ, “Lɛ di Abonsam kafuo suoto otososa odiki baatii kamɛ? ");
INSERT INTO snw_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Nse sɛka kalekɔ kawo lɛsɛ kɛtaka keeyila di suoto nɔɔ, ni sɛka kalekɔ nwu dilabafuo oyila. ");
INSERT INTO snw_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Nkpo kafɔɔ sɛ leyo lewo lɛsɛ di akyuu anyɔ bɔɔkpɛko bawo ni leyo nwu dilabafuo oyila. ");
INSERT INTO snw_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Nioso se Abonsam sɛka kalekɔ lɛsɛ ɛtaka eyila di suoto nɔɔ, kalaansifuo oyila, ni kalookɔ ni ka nɛ. ");
INSERT INTO snw_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Kɔtɔkɔ ye nlɛ otii kuonwii dilaafuo sientɛ leyo kamɛ obuo ɔlɛ nwɔ asaa, diediki ɛɛka nwɔ omufũ onii fiɛ aafuo nwɔ asaa ɔlɛ. ");
INSERT INTO snw_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Nwaako kɔtɔkɔ ye nlɛ Yaa mayɔ otii okpile lele ɛɛbla ku sibusufuɔlaa se eebuɛ ni di suoto nɔɔ ankyɛ nwɔ. ");
INSERT INTO snw_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Kafɔɔ olele nimabuɛ obusufɔlaa di Yaa Ninwuna Klekle suoto, Yaa dilabayɔ akyɛ nwɔ diidii, diekye eekpi lɛpɔɔ, ɛɛbla okpile wɔ nnaa ni kaloo.” ");
INSERT INTO snw_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu labuɛ sɛlaa se mmle, diekye baatoobuɛ alɛ, ninwuna kpile nsi nnwɔɔ Yesu. ");
INSERT INTO snw_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Di obe nwu kamɛ Yesu ɔya ku Yesu basuɔtɔbi lɛma labayila kaayi, ni baakpee otii alɛ balɛɛ nwɔ bata ma. ");
INSERT INTO snw_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Batii dikudi lasiɛ baamana nwɔ baakyi, ni baalaatɔkɔ nwɔ alɛ, “Nyu, yaafɔ ku babilee n-yɛ kaayi boowolaa fɔ!” ");
INSERT INTO snw_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ni aakaalɛ ma alɛ, “Bawe ninle yaami omu ku babiloo bamu?” ");
INSERT INTO snw_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ni aanyu batii ba ninsi bɛɛmana nwɔ beekyi ni, ni aabuɛ alɛ, “Binyu, yaami ku babiloo ninle mba ninsi ni ninfũ nɛ! ");
INSERT INTO snw_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Otii lele nikɔbla Yaa dibeesaa, nnwɔɔ ninle obiloo ku yaami nɛ.” ");
INSERT INTO snw_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu lakple aakye asaa katuosɔ diɛ Galilea Lekpo kotoko, batii dikudi lamana nwɔ baakyi. Batii nwu lɛpɔ oso aalaayie aasiɛ di oklo wɔ niatika ni di ntu osi. Batii dikudi nwu kafɔɔ layila di lekpo nwu kotoko. ");
INSERT INTO snw_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Atuo asaa kpinwu diɛ akpa kamɛ. Di asaa otuo nɔɔ kamɛ aatɔkɔ ma alɛ, ");
INSERT INTO snw_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Binu lo! Obe onwii alesaa kubi santɛ onwii lakyɛ kofe aalaasa alesaa kubi. ");
INSERT INTO snw_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Obe wɔ ɔɔsa ni alesaa kubi nwu nkpo koofe, kowo lakpete di osuku suoto, ni baakansiɛ lasɛsɛɛ kũ baamɛ nɛ ");
INSERT INTO snw_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","kowo kafɔɔ lakpete di afuɔ kasɔ, nfũ kɔɔtɛ diɛpɔ nii. Kɔtɛ ɔtampɔ oso, aawolaa ɔkɔntɔ. ");
INSERT INTO snw_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Obe wɔ kuufĩ labadie nii aayɔɔ, aafiɛ diekye sidu nɔɔ diɛkyɛ kasɔ ta afuɔ nwu oso. ");
INSERT INTO snw_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Kowo kafɔɔ labuo kakɔtɔkɔtɔ siiwuu kamɛ, ɔɔkɔntɔ anwa nii, siiwuu nwu kafɔɔ lakɔntɔ siafukuti siatĩi nya, nioso atafuo otika. ");
INSERT INTO snw_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Alesaa kubi nwu kowo kafɔɔ lakpete di kasɔ biene suoto. Nnya aakɔntɔ, aamuɔ aatika abi. Awo latika afosi atiɛ, awo afosi akuɔ, awo kafɔɔ latika kɔlafa.” ");
INSERT INTO snw_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yesu layɛntɛ ku sɛlaa se mmle alɛ, “Otii wɔ kuunutoko nkpe nii yi, aanu!” ");
INSERT INTO snw_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Obe wɔ di Yesu lete nfɛ nsi nii, basaateketetɛ nɔɔ ku lefosi batii banyɔ nwu lawa babakaalɛ nwɔ akpa nwu kasɔ. ");
INSERT INTO snw_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ni di Yesu latɔkɔ ma alɛ, “Yaa lediki asaa ya ninsi ni di Yaa sɛka kalekɔ ɛɛta ye. Kafɔɔ batii ba nsi ni sɛɛlɔɔkɔ, mma yi, akpa kamɛ babanu sɛlaa. ");
INSERT INTO snw_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Nioso, ditɔɔwa fɛ mmle bɛɛkpana ni Kɔɔkpana Klekle kamɛ alɛ, ‘Babanya, mankple manya, kafɔɔ blɔbanya batɛnsũ. Babanu, mankple manu, kafɔɔ blɔbanu kasɔ. Nse beenu kasɔ, bɛɛnya bɛɛtɛ nsũ, babakyi siitu lɛma kamɛ, Yaa n-yɔ sikpile lɛma ankyɛ ma!’ ” ");
INSERT INTO snw_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yesu lakaalɛ ma alɛ, “Biénu lɛkpa le mmle kasɔ? Ni lɛ bibafuo akpa bule amuu kasɔ onu? ");
INSERT INTO snw_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Alesaa kubi santɛ kɔsa Yaa ɔlaa nwu. ");
INSERT INTO snw_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Batii bawo nte fɛ alesaa kubi ko niakpete ni di osuku kotoko, nse beenu ɔlaa nwu, nfanwu Abonsam nwa amadiki ɔlaa nwu di situ lɛma kamɛ ansifiko. ");
INSERT INTO snw_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Batii bamba kafɔɔ nte fɛ kubi ko niakpete ni di afuɔ kasɔ. Nfanwu nse beenu ɔlaa nwu manfũ nwu ku suoto lɛyɔɔ. ");
INSERT INTO snw_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Kafɔɔ ɔlaa nwu sidu nimmufũ kaasɔ nwaa. Obe kakuii kamɛ ko manfũ nwu manu. Diekye nse nimiina ee ditikanko lɛwa ma di suoto di ɔlaa nwu ofũ onu kamɛ, mankple nkpaamaa. ");
INSERT INTO snw_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","“Batii bawo kafɔɔ nte fɛ kubi ko niakpete ni di kakɔtɔkɔtɔ siwuu kamɛ. Mma ninle batii ba ninu ni ɔlaa biene nwu, ");
INSERT INTO snw_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","kafɔɔ kayi ka mmle amiina ku koto onumbɛbɛɛ, ku asaa bamba ɔkɔnsɔ oklee nfukuti kuntĩi ɔlaa nwu alɛ, kunfuo abi otika. ");
INSERT INTO snw_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","“Batii bawo kafɔɔ nte fɛ kubi ko niakpete ni kaasɔ nwaa suoto. Baanu ɔlaaa biene nwu, baafũ nwu baanu baatika abi. Awo afosi atiɛ, awo afosi akuɔ, awo kafɔɔ kɔlafa.” ");
INSERT INTO snw_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu lakple aakaalɛ ma alɛ, “Nse bɛɛsɔ kandiɛ man-yɔ lɛsaa mantĩi nwɔ? Ee mpa kalɔ manse wɔ? Diele lɛsaa suoto man-yɔ mantika alɛ aakpa nwaa? ");
INSERT INTO snw_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Lɛsaa lele beekookaa Yaa madiki ni kayi, lɛsaa lele kafɔɔ beetĩi Yaa matikiti ni. ");
INSERT INTO snw_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Otii wɔ kunutoko nkpe ni, alolaa anu nwaa!” ");
INSERT INTO snw_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yesu lakple aatɔkɔ ma alɛ, “Bikyɔɔ atoko nwaa di sɛlaa se bionu ni suoto! Diekye leklapoosaa le biɛyɔ biɛklapoosa biɛta ni bawo lee, nninwu ke di Yaa mayɔ anklapoosa anta ye nɛ, bia lele ye malenkee. ");
INSERT INTO snw_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Diekye otii wɔ niɛkyɔɔ mi ni ɔlaa kotoko abawɛ lɛsɔnu ankyakaa. Kafɔɔ otii wɔ ninankyɔɔ mi ni ɔlaa kotoko kɛɛkɛɛ wɔ aye nii, Yaa maklee anfũ nwɔ ni nnɛɛ.” ");
INSERT INTO snw_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu lakple abuɛ alɛ, “Yaa sɛka kalekɔ nte fɛ mmle di otii nsa ni kamɔɔ kubi koofe. ");
INSERT INTO snw_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Nse kale ntooloo otii nwu naate ankyɔsĩi, nse kale ntɔɔsɛ antaka, kafɔɔ aaye mmle diɛ kamɔɔ kubi nwu mbla fiɛ kunkɔntɔ kuntika ni abi ambe nii. ");
INSERT INTO snw_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Kasɔ kamu ninta kamɔɔ kubi nwu mmuɔ kantika abi lɛnya. Lɛkasale kankɔntɔ, afata ndie. Sɛmaa kanlaka amɛ kandie kufuo, nni sɛmaa kansiɛ abi kanyi ntu kambe. ");
INSERT INTO snw_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Nse abi nwu ntoobe, fɛkpɛntɛ nwu n-yɔ kasaka diekye ofiɛlɛ bee ntoowo.” ");
INSERT INTO snw_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu lakple aabuɛ alɛ, “Be suoto kayɔ Yaa sɛka kalekɔ nkaatɛɛsa? Lɛmɛnkpa kayɔ ndiki ni kasɔ? ");
INSERT INTO snw_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Dite fɛ lewosobi biibii lewo. Fiɛ babapɛ ni nii, ninle lewosobi biibii diɛ awosobi kamɛ kaasɔ ka mmle suoto. ");
INSERT INTO snw_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Kafɔɔ nse bɛɛpɛ ni nintaka, nimuɔ ninlenkee awoso amuu. Kundie sɛla kplɛ, kunwɛ oyududu, ninwa alɛ bakansiɛ mbla ayo diɛ oyududu nɔɔ kalɔ masiɛ.” ");
INSERT INTO snw_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu latɔkɔ batii nwu ɔlaa biene di akpa ya mmle okle kamɛ, ni mmle okle baanu nwɔ ni kasɔ. ");
INSERT INTO snw_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Akpa lete kamɛ anfe ankakatɛ anta batii, kafɔɔ nse manko basaateketetɛ nɔɔ lete basi andiki asaa amuu kasɔ anta ma. ");
INSERT INTO snw_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Diɛ dii nwu nkpo kɔtɔɔfɔ, Yesu latɔkɔ basaateketetɛ nɔɔ alɛ, “Bita butaalɛ busifi lekpo le mmle sɛmaa.” ");
INSERT INTO snw_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Nioso baadiɛ batii dikudi nwu baasifi baalaabuo di oklo wɔ di Yesu labuo aasiɛ nii, ni baakpaa nwɔ baasifi nɛ. Seklo bamba kafɔɔ layila ninfa. ");
INSERT INTO snw_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Nfanwu kɔfɛɛfɔ siene lakyako ɔfɛ, ntu kɔpɛ nimbuo diɛ oklo kamɛ diɛta alɛ ntu laloo oklo kamɛ oyii baamɛɛ nii. ");
INSERT INTO snw_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Di obe nwu kamɛ Yesu omu lasiɛ diɛ oklo nwu sɛmaa lɛkyɛ, aatika disi di sumuyɛ aatɔɔkyɔsĩi. Ni baasaateketetɛ nɔɔ lasɛnkɛsɔɔ baakaalɛ nwɔ alɛ, “Saatuotɛ, faayɔ nwu ole falɛ buoloo okpi?” ");
INSERT INTO snw_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Nioso Yesu lasɛnkɛ. Aataka aayila nii, aamuɛ kɔfɛɛfɔ nwu aabuɛ alɛ, “Diɛ ɔfɛ!” Ninfɛ aatɔkɔ lɛkpo nwu alɛ, “Te kloklo!” Kɔfɛɛfɔ nwu ladiɛ ɔfɛ, ni dialo kanana nɛ. ");
INSERT INTO snw_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ni di Yesu lakaalɛ ma alɛ, “Be oso biɔyɛkɛ nkpo? Biefũ mi binu?” ");
INSERT INTO snw_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Lɛyɛkɛ lapɛ ma osie kanya ni baakaalɛ nimanima alɛ, “Omɛntii okle ninle nwɔ di kɔfɛɛfɔ ku lɛkpo nnu nwɔ ɔlaa?” ");
INSERT INTO snw_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Nni sɛmaa, Yesu ku basaateketetɛ nɔɔ lataalɛ baalaadu Galilea lekpo nwu kakyɛ nyɔɔfa di Gadara batii kasɔ. ");
INSERT INTO snw_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Obe wɔ di Yesu lasoo ni di oklo kamɛ, otii onwii niinwuna kpile lasiɛ ni ladie aakye sifuɔntuu se kamɛ mankookaa ni bakpi aabakyakako Yesu. ");
INSERT INTO snw_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Nfa ninle osuɔtɔ nwu kasiɛkɔ nɛ, otii kuonwii ninfuo kɔnyɛnɛ kukunwii ɔyɔ onii nwɔ. ");
INSERT INTO snw_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Obe lele se beekpee nwɔ sɛkpɛnkyɛ ninnɛɛ ku ninkpaa anfee sĩ. Nse kafɔɔ beenii nwɔ ku abɔɔsaa kɔnyɛnɛ ambudi kũ. Sientɛ kuonwii ditawɛ anfuo nwɔ ni olenkee. ");
INSERT INTO snw_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ansiɛ di batii kakookakɔ ku abokote kakũ ku kakyɛ aakyɛ aatookyi, antooyiisa kudu obe lele. An-yɔ afuɔ antɔɔkyankya suoto. ");
INSERT INTO snw_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Obe wɔ aanya ni Yesu kaakyonkɔ aatoso aalaapɛ akunkyi kaatũ nɔɔ. ");
INSERT INTO snw_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ni aayiisa kudu osie kanya alɛ, “Be ɔlaa ninsi di awo ku afɔ ntɛɛ, Yesu, Yaa wɔ ninlenke ni obi! Yaa oso, kotikiti fɔ lekoto, tannanfi mi kotoko!” ");
INSERT INTO snw_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Aabuɛ sɛlaa se mmle diekye Yesu latɔkɔ nwɔ alɛ, “Afɔ ninwuna kpile die nwɔ kaamɛ!” ");
INSERT INTO snw_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ni di Yesu lakaalɛ nwɔ alɛ, “Lɛ manlɛɛ fɔ?” Aadiki kanya alɛ, “Leyooto nii ninle dikudi, diekye buɔtɛ bupɔ!” ");
INSERT INTO snw_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Osuɔtɔ wɔ mmle di ninwuna kpile nsi nii, latikiti Yesu lekoto osie kanya alɛ atantososa anwuna nwu aadiki nintɛɛ nwu. ");
INSERT INTO snw_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Di obe nwu kamɛ aplakuo ɔlambu kplɛ onwii latoole asaa di kabokotee ɔlɔkɔ. ");
INSERT INTO snw_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Nioso anwuna kpile nwu di osuɔtɔ nwu kamɛ latikiti Yesu lekoto alɛ, “Diki wo osuku buɔlaabuo diɛ aplakuo nwu kamɛ!” ");
INSERT INTO snw_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ni aadiki nya osuku nɛ. Nfanwu anwuna kpile nwu ladie di osuɔtɔ nwu suoto aalaabuo di aplakuo nwu kamɛ. Aplakuo ɔlambu nwu omuu, nikawo ni fɛ nkpe nnyɔ latoso kitikiti aakye kabokotee nwu kalɔ aalaabuo leekpo nwu kamɛ aamɛ ntu aakpi. ");
INSERT INTO snw_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Nioso batii ba kɔkpa ni aplakuo nwu latoso baasifi baalaabuɛ ɔlaa wɔ niawa ni baakyakasa afe ku sekpoo. Ni baatii ladie baakyɛ alɛ bɔɔlaanyu lɛsaa le niawa nii. ");
INSERT INTO snw_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Obe wɔ baalaadu ni Yesu nfũ baanya otii wɔ kamɛ diɛ anwuna kpile dikudi nwu lasiɛ ni lakpee awu aasiɛ kasɔ, obe nwu ditɔɔkpa nwɔ. Nioso lɛyɛkɛ lapɛ bamuu lɛma. ");
INSERT INTO snw_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Batii ba niakasa ni otii wɔ kamɛ diɛ anwuna kpile nwu lasiɛ ni ɔnya latɔkɔ batii bamuu lɛsaa le niawa ni di osuɔtɔ nwu ku aplakuo nwu suoto. ");
INSERT INTO snw_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Nioso batii nwu latikiti Yesu lekoto baatɔkɔ nwɔ alɛ adie ma kaasɔ. ");
INSERT INTO snw_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Obe wɔ di Yesu latoobuo ni diɛ oklo kamɛ, otii wɔ kamɛ di anwuna kpile lasiɛ ni saa, latikiti nwɔ lɛkoto alɛ, tɛɛ ntikankofɔ. ");
INSERT INTO snw_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Kafɔɔ Yesu ditatɔɔ osuku. Ni ɔtɔkɔ nwɔ alɛ, “Tɔɔkyɛ leyo baatii lɛfɔ nfũ faadiki lɛsaa le di Saate lɛbla ɛɛta fɔ ni fabuɛ, faatɔkɔ ma ku mmle ɛɛnya fɔ ni nyaami.” ");
INSERT INTO snw_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Nioso osuɔtɔ nwu lasifi aalaabuɛ lɛsaa le di Yesu labla aatɔɔ ni diɛ ekpoo nwu lefosi aafenko. Diabla batii ba nianu ni ɔkpɛ. ");
INSERT INTO snw_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ɔbe wɔ di Yesu lasiɛ oklo aawaalɛ aakple aasifi ni lekpo sɛmaa, batii dikudi lakple baabasi nwɔ di suoto di lekpo kotoko. ");
INSERT INTO snw_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Yuda batii kasiisakɔ ɔnɔɔfo onwii manlɛɛ ni Yairo lawa nfa. Aanya ni Yesu, aapɛ akunkyi ninkpaatũ nɔɔ. ");
INSERT INTO snw_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Aatikiti nwɔ lekoto osie kanya aabuɛ alɛ, “Obi sankobi nii koloo okpi. Lekoto wa faabatika nwɔ kɔnɛɛ di suoto di ofiɛ kuyɔɔ nwɔ, aawɛ nkpa.” ");
INSERT INTO snw_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Nioso Yesu latikanko nwɔ baakyɛ. Batii dikudi latikanko nwɔ baamana nwɔ kpinkpĩ baakyi, Yesu lasiɛ ma nintɛɛ. ");
INSERT INTO snw_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ɔsanko onwii kafɔɔ lawɛ ma kaamɛ, asaa latoowii nwɔ fɛɛ lefosi alɛɛ anyɔ amu. ");
INSERT INTO snw_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Diabuo nwɔ ku suoto kɔfa omiɛ di bafatɛ kpinwu nnɛɛ, aalalaasa koto nɔɔ kumuu, kafɔɔ ofiɛ nwu katoo ko kua tɔɔtaka. ");
INSERT INTO snw_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Obe wɔ di ɔsanko nwu lanu ni Yesu lɛkpanko, aafe di Yesu sɛmaa baatii dikudi nwu kamɛ aakpanko Yesu awu. ");
INSERT INTO snw_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Aabla nkpo diekye aabuɛ aatɔkɔ suoto alɛ, “Nse lɛkpanko nwɔ awu kamaa, ofiɛ mayɔɔ mi.” ");
INSERT INTO snw_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Nfanwu aakpanko ni Yesu awu nwu, asaa owii nwu labudi. Nioso aatofo di suoto nɔɔ kamɛ alɛ ofiɛ nwu ntɔɔyɔɔ nwɔ. ");
INSERT INTO snw_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Nfanwu, Yesu latofo alɛ osie owo ledie nwɔ di suoto. Aakyi aakalɛ batii dikudi nwu alɛ, “Owe niɛkpanko mi awu?” ");
INSERT INTO snw_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Asaabateketɛ nɔɔ latɔkɔ nwɔ alɛ, “Nyu mmle batii dikudi lɛmana fɔ kpinkpi beekyi ni, fiɛ fɔɔkaalɛ falɛ owe niɛkpanko fɔ awu?” ");
INSERT INTO snw_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Kafɔɔ Yesu latookpekpe anu aatoowolaa otii wɔ niabla ni lɛsaa nwu. ");
INSERT INTO snw_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Difu lapɛ ɔsanko nwu, diekye aatofo lɛsaa le niɛwa ni di suoto kamɛ, nioso aayɔ lɛyɛkɛ ku ditũtũkũ aalaapɛ akunkyi di Yesu nkpaatũ ni aatɔkɔ nwɔ nwaako wɔ ninsi ni di ɔlaa nwu kamɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesu latɔkɔ nwɔ alɛ, “Obi sankobi nii, ofũ onu lɛfɔ lediki fɔ. Tɔɔkyɛ di suoto lɛyɔɔ kamɛ. Ofiɛ lɛfɔ nwu kuyɔɔ fɔ.” ");
INSERT INTO snw_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Obe wɔ di Yesu lakple aatɔɔkakatɛ ni, batɔkyɛntɛ lakye Yuda batii kasiisakɔ nɔɔfo Yairo leyo baawa alɛ, “Obi sankobi lɛfɔ nwu ntookpi nioso ɔnɔɔfo, tansinkpɛnsa Saatuotɛ dibuo okpee.” ");
INSERT INTO snw_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Di Yesu lanu ni ɔlaa nwu aatɔkɔ ɔnɔɔfo nwu alɛ, “Tanyɛkɛ, afɔ fũ fanu!” ");
INSERT INTO snw_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yesu ditatuna alɛ kuonwii atikanko nwɔ diediki Petro ku Yakobo ku obilɛma Yohane. ");
INSERT INTO snw_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Obe wɔ baawa ni Yairo leyo Yesu lanya alɛ batii lesi ninfa boowi kaku ku kudu osie kanya. ");
INSERT INTO snw_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Di Yesu labuo ni leyo kamɛ, ninfɛ aabuɛ alɛ, “Be ninle kudu ku kaku nwu biowi ni? Ɔbisɔ nwu diekpi ɔkyɔsĩi ɔɔkyɔsĩi!” ");
INSERT INTO snw_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Batii nwu lama nwɔ ni aata batii bamuu ladie, ni akpaa obi ote, obi ɔya ku basaateketetɛ nɔɔ batiɛ nwu ni baasifi nfũ diɛ obisɔ nwu lakpi aate ni nɛ. ");
INSERT INTO snw_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ni di Yesu lamufũ obisɔ nwu kɔɔnɛɛ aabuɛ seele lɛma alɛ, “Talita koumo!” Lɛsɔdiki ninle alɛ, “Okpeele, taka!” ");
INSERT INTO snw_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Nfanwu ɔsankobi nwu lataka aakyɛ. Lefosi alɛɛ anyɔ obi aale. Diatɛ diabla batii nwu ɔkpɛ osie kanya. ");
INSERT INTO snw_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesu lakpee ma kufiofa osie kanya alɛ batanta otii kuonwii lanu, ninfɛ aatɔkɔ ma alɛ, bamiɛ lelesaa batɔɔ ale. ");
INSERT INTO snw_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu ladie niinfa aawa okpoo lɛma, ku basaateketetɛ nɔɔ. ");
INSERT INTO snw_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Di Lɛnyɛɛtɛyi lawo nii, aakyako asaa otuo di Yuda batii kasiisakɔ. Asaa otuo nɔɔ labla batii ba nianu ni ɔkpɛ, ni baakaalɛ bawo alɛ, “Ɔfɛ di otii wɔ lanu sɛlaa se mmle eekyeko? Lɛmɛnsaatofo okle ninle nle mmle bɛɛtɔɔ ni! Lɛ ɔbla sɛkpɛ se niɛbla ni ɔkpɛ nkpo? ");
INSERT INTO snw_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Diele nnwɔɔ ninle Maria obi, saawolatɛ nwu? Diele babilɛma ninle Yakobo, Yose, Yuda, ku Simon? Babi lɛma sankobi kafɔɔ nsi wo kaamɛ.” Nioso baasĩ nwɔ. ");
INSERT INTO snw_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu latɔkɔ ma alɛ, “Batii mbu Yaa Ɔlaa buɛtɛtɛ di kakɔ biala diediki okpoo lɛma, kafaabi nɔɔ ku babi lɛma kamɛ manambu nwɔ.” ");
INSERT INTO snw_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Nioso atafuo lɛsaa le niɛbla ni ɔkpɛ ɔbla ninfa. Diediki bafiɛtɛ basɛɛ afuo kɔnɛɛ otika aatakatɛsa ma siifiɛ. ");
INSERT INTO snw_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Batii nɔɔ ɔtanfũ onu labla Yesu ɔkpɛ. Yesu lakyi nkpayetũ be niawɛ ni di ntɛɛ nwu aatootuo batii ɔlaa biene. ");
INSERT INTO snw_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Aalɛɛ batɔkyɛntɛ lefosi banyɔ nwu aasiisa, ni aasɛ ma banyɔ banyɔ aakpee ma kɔtɔ. Aata ma osie diɛ anwuna kpile suoto. ");
INSERT INTO snw_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ni aakpee ma kufiofa alɛ, di osuku lɛma ɔkyɛ kamɛ batanklee lɛsalɛsaa diediki ɔkyɛnwoso, batanklee alesaa, kotofo ko mankaalɛ ni asaa, batanklee koto. ");
INSERT INTO snw_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Bakpe ntokota kafɔɔ batanklee osi awu nyɔɔfa. ");
INSERT INTO snw_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Aatɔkɔ ma kafɔɔ alɛ, “Nse kakɔ lele beefũ ye kɔfɔɔ, bisiɛ ninfa dilaase di obe wɔ bibadie ni di okpoo nwu. ");
INSERT INTO snw_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nse biɛɛkyɛ okpoo wɔ baatii diefũ ye nii, ee baanu ye nii ɔlaa, biesifi bidiɛ ma, kafɔɔ biɛfɛntɛ nkpaasɔ lee kɔtɛ bitɛ ma. Nni nimatuo alɛ baasĩ ye ofũ nɛ.” ");
INSERT INTO snw_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Nioso baakyɛ baalaabuɛ Yaa ɔlaa baata batii alɛ, bikyi siikpile lee suoto, bietikanko Yaa sisuku. ");
INSERT INTO snw_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Baatososa anwuna kpile kpinwu baatii suoto, baafifia bafiɛtɛ kpinwu nnɔnyi, baayɔɔsa ma sifiɛ. ");
INSERT INTO snw_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Yesu leyooto lakyaka ntɛɛ nwu, Ɔka Herodes lanu, ni baatii bawo latoobuɛ alɛ, “Yohane Yaa Ntu Kpeesatɛ nwu bɛɛtakatɛsa beekyeko bakpi kamɛ, nioso akpe osie ɔɔbla sɛkpɛ se niɛbla ni ɔkpɛ nɛ.” ");
INSERT INTO snw_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Batii bawo kafɔɔ labuɛ alɛ, “Yaa Ɔlaa Buɛtɛtɛ Elia dile!” Babamba alɛ, “Yaa Ɔlaa buɛtɛtɛ wɔ niedie ni saa Yaa Ɔlaa buɛtɛtɛ owo ale!” ");
INSERT INTO snw_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Di Herodes lanu ni sɛlaa se mmle, aabuɛ alɛ, “Yohane wɔ lata baabudi ni disi bɛɛtakatɛsa beekyeko bakpi kamɛ nɛ!” ");
INSERT INTO snw_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Kaasɔ kakyekɔ, Herodes omu niata baamafũ Yohane baatɛ leeyo ta Herodia oso, diekye Herodes lafũ Herodia wɔ nle ni obi lɛma Filipo ɔsɔfɔ aayɔ. ");
INSERT INTO snw_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ni diɛ Yohane latɔkɔ nwɔ alɛ, “Kufiofa diɛta osuku alɛ faafũ obilee ɔsɔfɔ fanyɔ!” ");
INSERT INTO snw_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Nioso, Yohane ɔlaa latoobuo Herodia suoto, ni aakyidi Yohane nɛ, aamiɛ alɛ oolo nwɔ, kafɔɔ atafuo ta Herodes oso. ");
INSERT INTO snw_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Diekye Herodes n-ye alɛ Yohane nle otii biene ku otii klekle nkpo oso anyɛkɛ nwɔ, annyu alɛ lɛsalɛsaa diɛbla nwɔ kuntɛ sɛlaa nɔɔ ntofo nwɔ osie kanya ambɔmbɔ sĩ onu. ");
INSERT INTO snw_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Dii ninwii lɛsaa le di Herodia komiɛ ni lawa kaanya. Herodes lale lelofoyi dii nɔɔ. Aatũ opunu, aakyakako banɔɔfo ku Galilea okpoo banɔɔfo ku kakpɛ kanya bayilatɛ banɔɔfotii aawa alesaa kalekɔ. ");
INSERT INTO snw_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodia obi sankobi lakyɛ alesaa nwu kalekɔ, ni aatũ, diabuo Herodes ku batii ba aakyakako ni anu nwaa. Ɔka Herodes latɔkɔ ɔsankobi nwu alɛ, “Kaalɛ mi lɛsaa lele ninlɛ fɔ, amii mata fɔ!” ");
INSERT INTO snw_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Aaka ntam aatɔɔ alɛ, “Mayɔ lɛsaa lele fɛɛkaalɛ mi nta fɔ, diɛlaase ni bia sɛɛka nii kalekɔ kakyɛ!” ");
INSERT INTO snw_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ɔsankobi nwu ladie aalaakaalɛ ɔya alɛ, “Be ninkaalɛ?” Aatɔkɔ nwu alɛ, “Kaalɛ Yohane Yaa Ntu Kpeesatɛ disi!” ");
INSERT INTO snw_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nfanwu ɔsankobi nwu lapɛsɛwa aawa ɔka Herodes ɔkyɛ, ni aatɔkɔ nwɔ alɛ, “Komiɛ nlɛ budi Yohane Yaa Ntu Kpeesatɛ disi, faayɔ fakpee di bɛɛsi kamɛ fatɛɛ nunua!” ");
INSERT INTO snw_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ɔlaa nwu labuo Ɔka Herodes suoto osie kanya, kafɔɔ diɛ ntam be aaka ni ku batii ba aakyakako ni oso, aata miɛ alɛ ɔwaalɛ ɔlaa wɔ aabuɛ aatɛ nii. ");
INSERT INTO snw_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Nfanwu Ɔka Herodes lata disi buditɛ osuku alɛ akyɛ aalaabudi Yohane disi awako. Ni aakyɛ aalaabudi Yohane disi diɛ leyo katenkɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Aayɔ disi nwu aakpee di bɛɛsi aawako, aayɔ aata ɔsankobi nwu. Ɔsankobi nwu kafɔɔ layɔ aakyɛnko ɔya. ");
INSERT INTO snw_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Obe wɔ di Yohane basaateketetɛ lanu nii, baakyɛ baalaayɔ kpi nɔɔ nwu baalaakookaa. ");
INSERT INTO snw_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Batɔkyɛntɛ nwu di Yesu lakpee ni kɔtɔ lakple baawa ɔkyɛ nɔɔ, baabatɔkɔ nwɔ asaa ya baabla ni ku n-ya baatuo nii. ");
INSERT INTO snw_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nle mmle sɛmaa, batii kpinwu latɔɔwa ɔkyɛ lɛma diata alɛ batawɛ osuku bale alesaa, nioso Yesu latɔkɔ ma alɛ, “Biwa buɔlatɛ ɔnyɛɛ kɛɛkɛɛ.” ");
INSERT INTO snw_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ni baabuo di oklo kamɛ baasifi lɛba le nialo ni nɛ. ");
INSERT INTO snw_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Kafɔɔ batii lanya ma baatɛ nsũ nioso baakye sekpoo ate ate baatoso baatikanko ma baasifi nfũ di Yesu ku basaateketetɛ nɔɔ latoofe nii, diata alɛ batii nwu lakasa ma obuo. ");
INSERT INTO snw_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Obe wɔ di Yesu ladie ni diɛ oklo kamɛ aanya ni batii dikudi kplɛ nwu, ɔlaa lɛma lanu nwɔ kafutu, diekye baate fɛ bafoso ba di kpatɛ nnaa nii, ni aatuo ma asaa kpinwu nɛ. ");
INSERT INTO snw_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kɔɔtɔɔfɔ lawo nii, basaateketetɛ nɔɔ lawa babatɔkɔ nwɔ alɛ, “Nfũ bukpe ni lekyo ku okpoo, kale kafɔɔ nfɛ koloo. ");
INSERT INTO snw_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Diki ma osuku baasifi sekpoo biibii ku nkpaayotũ be niɛmana wo diekyi ni baalaamiɛ alesaa baya bale.” ");
INSERT INTO snw_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Kafɔɔ Yesu latɔkɔ ma alɛ, “Aye bamu bimiɛ alesaa bita ma bale!” Ni baabuɛ alɛ, “Ni ɔkyɛ buakyɛ munaayɔ otii awɛntɛ anɛ kɔkpento munaaya alesaa muwako ma manle?” ");
INSERT INTO snw_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ni di Yesu latɔkɔ ma alɛ, “Bitɔɔkyɛ biɛlaanyu bilɛ bloblo akudi asɛ ninte ye?” Baakple baabatɔkɔ nwɔ alɛ, “Bloblo akudi anɔɔ ku kɔkpaku sɛnle kɔnyɔ ko kule.” ");
INSERT INTO snw_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yesu latɔkɔ basaateketetɛ nɔɔ alɛ bata batii nwu basiɛ akudi akudi sɛɛfa lɛkɛtɛɛ kɔnle nwu suoto. ");
INSERT INTO snw_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Nioso baasiɛ diɛ akudi kanya, akudi awo kɔlafa, awo kafɔɔ afosi anɔɔ. ");
INSERT INTO snw_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yesu layɔ bloblo akudi anɔɔ ku kɔkpaku nwu kɔnyɔ, ni aanyu osi aakusɛkusɛsa nya. Aabɛbɛɛ bloblo nwu aata basaateketetɛ nɔɔ alɛ basɛ bata batii nwu, ni aabɛbɛɛ kɔkpaku nwu kɔnyɔ kafɔɔ aata batii nwu bamuu nɛ. ");
INSERT INTO snw_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Obiala lɛma lale aamiɛ. ");
INSERT INTO snw_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Obe wɔ baasaateketɛ nɔɔ lasiisa ni bloblo ku kɔkpaku kɔkyɛɛ ko niabu nii, baawɛ lefosi nkyikyɛ nkplɛ nnyɔ. ");
INSERT INTO snw_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Batii ba niale ni alesaa nwu basuɔtɔ lɛpɔ lawo nkpe nnɔɔ. ");
INSERT INTO snw_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Nfanwu Yesu latɔkɔ basaateketetɛ nɔɔ alɛ, babuo di oklo kamɛ wla baatɔɔsɔ okpoo wɔ bɔɔlɛɛ ni Betsaida di lekpo nwu sɛmaa. Ninfɛ aadiki batii dikudi nwu kafɔɔ osuku nɛ. ");
INSERT INTO snw_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Nni kamaa, Yesu omu kafɔɔ lasifi kabokotee osi aalaapɛ ɔlaa aata Yaa. ");
INSERT INTO snw_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kɔɔtɔfɔ lawo nii, oklo nwu kafɔɔ ntoodu lɛpanta nwu ntɛɛ. Yesu lete nfɛ niabu di kasɔ nwu suoto. ");
INSERT INTO snw_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Yesu lanya alɛ oklo nwu ɔwa kɔwɛ basaateketetɛ nɔɔ osie, diekye kɔfɛɛfɔ latɔɔkyakako ma. Di kuyitatũ elomu etiɛ kamɛ aakyɛ di ntu osi aatoofe ɔkyɛ lɛma, aamiɛ alɛ ɔɔwaalɛ ma anfe. ");
INSERT INTO snw_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Obe wɔ basaateketetɛ nɔɔ lanyɔɔ akyɛ ni di ntu osi ɔɔwa nii, ni baayiisa kudu alɛ, kpi ale! ");
INSERT INTO snw_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Bamuu lɛma baanyɔɔ nii, ɔfɔɔ lasifi ma. Ni di Yesu lakakatɛ ko ma aatɔkɔ ma alɛ, “Bita situ lee site, biitanyɛkɛ! Ami dile.” ");
INSERT INTO snw_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ni aayie aabuo di oklo nwu kamɛ di anu lɛma, ni diɛ afɛɛfɔ nwu ladiɛ ɔfɛ nɛ. Diatɛ diabla ma ɔkpɛ osie kanya! ");
INSERT INTO snw_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Diekye batanu kasɔ di lɛsaatuo le ninsi ni diɛ bloblo wɔ aata ma baale ni kamɛ, ditabudi ma diekye batafũ baanu. ");
INSERT INTO snw_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Obe wɔ baataalɛ ni lekpo nwu baalaadu ni kakyɛ nyɔɔfa, baalaasoo diɛ Genesaret okpoo. Ni baapɛ oklo nwu lekpo nɛ. ");
INSERT INTO snw_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Obe wɔ batosoo ni diɛ oklo nwu kamɛ batii lanya Yesu baatɛ nsũ. ");
INSERT INTO snw_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Nioso baatoso baalaatɔkɔ batii di ntɛɛ nwu, ta nkpo oso kakɔ lele beenu alɛ Yesu nkpe, mankɛnkɛ bafiɛtɛ ku atensaa lɛma manwako Yesu nfũ. ");
INSERT INTO snw_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Kakɔ lele di Yesu lɛkyɛ, nkpayetũ woo, sekpoo woo, ee sefensuku, mankɛnkɛ bafiɛtɛ mamatɛ di asaa kayakɔ aba aba, mantikiti nwɔ lekoto alɛ, ata bafiɛtɛ nwu bakpanko awu nɔɔ kotoko. Batii ba niakpanko nwɔ ni awu kotoko, sifiɛ layɔɔ ma. ");
INSERT INTO snw_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Farisi batii ku kufiofa batuotɛ bawo lakye Yerusalem baawa baabamana Yesu baakyi. ");
INSERT INTO snw_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Baanya alɛ basaateketetɛ nɔɔ lasiɛ baatoole ni alesaa, bawo ditafoto nnɛɛ fɛ mmle diɛ Farisi batii letuo batii alɛ batofoto nii. ");
INSERT INTO snw_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Baafuo otofo ta Farisi batii ku Yuda batii latɔɔbla bawa lɛma amanle ya baadiɛ baatɛ ma nii. Nioso diediki beefoto nnɛɛ lɛma fɛ mmle baatuo ma nii, fiɛ manle alesaa. ");
INSERT INTO snw_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Se bɛɛya lɛsaa lele di asaa kasunsukɔ, dikpe ni beefoto nnɛɛ lɛma fiɛ beele. Manle afiofa ya kpinwu bɛɛtaka bɛɛbatũ nii, fɛ mmle manfoto ni nkɔkɔɛ ku awambukii ku ntu adubukii. ");
INSERT INTO snw_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Nioso Farisi batii nwu ku basaatuotɛ nwu lakaalɛ Yesu alɛ, “Lɛ oso diɛ batikankotɛ lɛfɔ dilɔbla bawa loo amanle? Manle asaa kuntɛ baafoto nnɛɛ kafɔɔ!” ");
INSERT INTO snw_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu ladiki kanya alɛ, “Nwaako ɔlaa wɔ di Ɔlaa Buɛtɛtɛ Yesaia labuɛ ni di balaatɛ lee suoto kute nkpo. Fɛ mmle bɛɛkpana bɛɛtɛ alɛ, ‘Batii ba mmle kanya fukiti ko man-yɔ mantansɛɛ, kafɔɔ mámbɔmbɔ mi siitu lɛma kamɛ. ");
INSERT INTO snw_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kasakasa bɔɔbla mi ɔkpɛ. Diekye bakle batii afiofa bootuo fɛle afiofa nii ale.’ ");
INSERT INTO snw_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Dietuo alɛ batɔɔyɔ Yaa afiofa beekookaa, bɛɛyɔ batii ablasaa bootuo ye.” ");
INSERT INTO snw_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yesu lakple aatɔkɔ ma alɛ, “Biefe diɛ kakyɔnkyɔ osuku biediɛ Yaa afiofa biɛtɛ, biɔbla diɛ aye bamu lee saa amanle. ");
INSERT INTO snw_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Diɛ ɔtɛ onyu kamɛ, Mose lakpee kufiofa alɛ, ‘Bu teefɔ ku yaafɔ. Otii lele niɛkpaani ote ee ɔya, dikpe ni beelo nwɔ.’ ");
INSERT INTO snw_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Kafɔɔ biotuo bilɛ, nse otii owo nkpe lɛsaa alɛ ɔɔkyakaako ote ee ɔya, aafuo obuɛ alɛ, ‘Lɛsaa le nlɛ kɔta ye nii, ntoodiki ni lɛtɛ fɛ lɛsaa klekle nlɛ man-yɔ nta Yaa ole.’ ");
INSERT INTO snw_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Bilɔɔta ma osuku bilɛ bata balofotɛ lɛma asaa ya niefĩ ma nii! ");
INSERT INTO snw_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ote ko dite fɛle biɛyɔ bawa lee amanle biɔlalaasa Yaa afiofa. Mimbla asaa bamba kpinwu fɛ n-ya mmle okle.” ");
INSERT INTO snw_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Nni kamaa, Yesu lakple aalɛɛ batii dikudi nwu alɛ batɛɛtɛɛ nwɔ. Ni aatɔkɔ ma alɛ, “Bamuu lee bikyɔɔ mi atoko, bienu ɔlaa wɔ matɔkɔ ye ni kasɔ. ");
INSERT INTO snw_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Lɛsaa lele di otii léle eekpee kaafutu dilaata alɛ akpɔnɔnfɔ di Yaa anu. Kafɔɔ asaa ya nindie ankye ni otii otu kamɛ, nnya ninkpɔnɔnfɔsa nwɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Bienu kasɔ.” ");
INSERT INTO snw_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Nni kamaa, obe wɔ aadiɛ ma aasifi ni leyo ninwii, basaateketetɛ nɔɔ latɔkɔ nwɔ alɛ, adiki ɔlaa nwu kasɔ ata ma. ");
INSERT INTO snw_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yesu latɔkɔ ma alɛ, “Ni ayee bienu kasɔ? Ɔlaa wɔ mmle diɛkpa kamɛ alɛ lɛsaa lele di otii lele eekpee kaafutu kamɛ dilaafuo nwu ɔkpɔnɔnfɔsa? ");
INSERT INTO snw_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Diekye diele otii otu kamɛ nimbuo, kafɔɔ kafutu nɔɔ kamɛ nimbuo fiɛ ankyɛ ni andiki.” Nioso ɔlaa wɔ di Yesu kobuɛ ni ninfũ, kotuo alɛ alesaa amuu nlɛ alɛ baale. ");
INSERT INTO snw_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Aakple aabuɛ aakyakaa alɛ, “Lɛsaa le nindie ninkye ni otii otu kamɛ, nni ninta ambla okpile nɛ. ");
INSERT INTO snw_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Diekye otii otu kamɛ di disibu kpile nkye, nni ninta otii mbla asaa ya ninanlɛ ni nɛ. Asaa nwu awo ninle otetee ku kayu ku batii olo kuɛ ");
INSERT INTO snw_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","lɛsɔnɔkpee, onumbɛbɛɛ, disi osie ku ditii kyɔnkyɔ, suoto sĩna ɔkɔnsɔ akleesaa otikanko, batii odu okutu, onunsɛɛ, suoto katoo ɔtakatɛsa ku abuusaa ɔbla. ");
INSERT INTO snw_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Sikpile se mmle simuu nindie sinkye otii kamɛ nɛ, nsĩ kafɔɔ ninta otii nkpɔnɔnfɔ nɛ.” ");
INSERT INTO snw_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Sɛmaa, Yesu ladie aasifi kasɔ ka niɛtɛɛtɛ ni okpoo wɔ bɔɔlɛɛ ni Tiro. Aabuo leyo ninwii, kafɔɔ atamiɛ alɛ otii atofo alɛ akpe ninfa, atafuo owofa kafɔɔ. ");
INSERT INTO snw_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ɔsanko onwii, obi sankobi, ninwuna kpile lasiɛ nwɔ. Ɔsanko nwu lanu Yesu lɛkpanko ninfa, ni aati nwɔ aakyɛ aalaapɛ akunkyi di nkpaatũ nɔɔ. ");
INSERT INTO snw_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ninfɛ aatikiti Yesu lekoto alɛ atososa ninwuna nwu di obi suoto. Ɔsanko nwu Hela otii aale, kafɔɔ baalofo nwɔ di Foinike kasɔ. ");
INSERT INTO snw_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Kafɔɔ Yesu ladiki kanya alɛ, “Ta bata babisɔ alesaa bale bamiɛ fiɛ. Diekye diɛlɛ alɛ baayɔ babisɔ alesaa manta baweewee alɛ bale.” ");
INSERT INTO snw_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Nfa diɛ ɔsanko nwu kafɔɔ kokpee nwɔ kanya alɛ, “Ao, Saate, baweewee ba nsi ni diɛ opunu kalɔ di alesaa kalekɔ, nwɛ osuku manle alesaa ya baabisɔ kole oowiwii ni kaasɔ.” ");
INSERT INTO snw_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ninfɛ di Yesu latɔkɔ nwɔ alɛ, “Ta, kanya didiki le feediki ni ninfũ oso, tɔɔkyɛ leyo. Fabalaanya falɛ ninwuna kpile nwu ntoodie di obi lɛfɔ suoto.” ");
INSERT INTO snw_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ninfɛ di ɔsanko nwu lasifi leyo nɛ. Nfa aalaanya alɛ obi nɔɔ nwu nte kaatenkɔ nɔɔ ninwuna kpile nwu ntoodie diesifi. ");
INSERT INTO snw_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu ladie di Tiro ntɛɛ nwu aafe di Sidon, aasifi Galilea lɛpanta sɛmaa aalaata di ntɛɛ be diɛ ekpoo lefosi nkpe nii. ");
INSERT INTO snw_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nfa di batii banwii lakyeko osuɔtɔ wɔ ninoonu nii, onoofuo ni ɔkakatɛ nwaa kafɔɔ baawako Yesu nɛ. Baatikiti nwɔ lekoto alɛ atika nwɔ kɔnɛɛ, aayɔɔsa nwɔ ofiɛ. ");
INSERT INTO snw_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Nioso Yesu lakpaa nwɔ aasifiko lɛba le nielo nii baatii nnaa nii, ni di Yesu lakpee anɛɛ nɔɔ diɛ osuɔtɔ nwu atoko kamɛ nɛ. Aatufa sita aatika kɔɔnɛɛ, ayɔ aatusa osuɔtɔ nwu di ɔkplalomii. ");
INSERT INTO snw_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ninfɛ di Yesu lakplesa anu katoo aanyu osi ni aanwuna aadieko nwaa, ni aatɔkɔ osuɔtɔ nwu seele lɛma alɛ, “Hefata,” kasɔ ninle alɛ, “Tikiti!” ");
INSERT INTO snw_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Nfanwu, osuɔtɔ wɔ mmle atoko niatikiti, ɔkpalalomii nɔɔ okũ labudi ninfɛ aakyako ɔkakatɛ nwaa nɛ. ");
INSERT INTO snw_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesu lasĩ aata batii ba niayila ni ninfa alɛ batantɔkɔ otii kuonwii lɛsaa le baanya ni ninfa. Kafɔɔ batanu, bamuu lɛma baasifi baalaatoobuɛ mmle diawa nii. ");
INSERT INTO snw_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Batii ba bamuu nianu ni sɛlaa nwu, diabla ma yaaa! Ni baabuɛ alɛ, “Anlolaa asaa amuu ambla! Anta bamumu nkakatɛ, batokotĩitɛ kafɔɔ nnu!” ");
INSERT INTO snw_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ditaklɛ saa fiɛ baatii kpinwu labasi ninfa. Ta lɛsalɛsaa ditabu ma baale ni oso, Yesu lalɛɛ basaateketetɛ nɔɔ baawa nwɔ katũ ni aatɔkɔ ma alɛ, ");
INSERT INTO snw_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Batii ba ɔlaa konu mi kafutu diekye batɔɔwɛ di ɔkyɛ nii ayi atiɛ amu. Kafɔɔ lɛsalɛsaa diebu baawɛ manle nii. ");
INSERT INTO snw_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nse lediɛ ma nlɛ batɔɔkyɛ, loo babalaatookpi kɔka diɛ osuku. Diekye bawo lekye nkyonkɔ.” ");
INSERT INTO snw_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ninfɛ di basaateketetɛ nɔɔ lakaalɛ nwɔ alɛ, “Di ɔfaafuu wɔ mɔ, ɔfɛ di otii mawɛ alesaa anta batii ba mmle alɛ bale bamiɛ?” ");
INSERT INTO snw_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Nfa nfɛ di Yesu lakaalɛ ma alɛ, “Bloblo akudi asɛ bikle?” Ni baatɔkɔ nwɔ alɛ, “Bloblo akudi akuɛnsĩ bukle.” ");
INSERT INTO snw_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yesu latɔkɔ bamuu lɛma alɛ basiɛ kaasɔ. Ninfɛ aayɔ bloblo akudi akuɛnsĩ nwu, aapɛ Yaa sɛfa, ninfɛ aabɛbɛɛ nwɔ kɔkyɛɛ kɔkyɛɛ aata basaateketetɛ nɔɔ alɛ bayɔ bata batii nwu bamuu. Mma kafɔɔ, baayɔ baasɛ ma fɛɛ. ");
INSERT INTO snw_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Baanya alɛ kɔkpaku kɔsɛɛ kafɔɔ labu nii, Yesu layɔ kũ kafɔɔ ninfɛ aapɛ sɛfa nɛ. Aayɔ kũ aata basaateketetɛ nɔɔ alɛ bayɔ basɛ ma kafɔɔ. ");
INSERT INTO snw_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Batii ba lale alesaa nwu baamiɛ. Basuɔtɔ lete lɛpɔ labla nkpe nna. Baale baaloo nii, basaateketetɛ nɔɔ lasiisa kufii ko niabu nii baawɛ nkyikyɛ nkplɛ nkuɛnsĩ. Sɛmaa, Yesu ladiki ma osuku baasifi. ");
INSERT INTO snw_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ninfɛ di Yesu ku basaateketetɛ nɔɔ labuo di oklo kamɛ baataalɛ ntu baasifi kasɔ ka bɔɔlɛɛ ni Dalmanuta. ");
INSERT INTO snw_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Farisi batii lawa Yesu ɔkyɛ alɛ bɔɔbakaalɛ nwɔ sɛlaa mansɔ nwɔ mannyu. Nioso baatɔkɔ nwɔ alɛ abla atuosaa atuo ma baanya alɛ Yaa nfũ eekye. ");
INSERT INTO snw_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Kafɔɔ Yesu lanwuna faa, ni aakaalɛ ma alɛ, “Obe lɛsaa oso diɛ nunua babi komiɛ alɛ batɔɔnya atuosaa? Oowo, kɔtɔkɔ ye nlɛ nɔɔmatuo ye lɛsaa le biomiɛ bilɛ binya ni ninfũ!” ");
INSERT INTO snw_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ninfɛ aasifi aadiɛ ma aakple aalaabuo di oklo kamɛ aataalɛ lɛpanta nwu aasifi kakyɛ nyɔɔfa. ");
INSERT INTO snw_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Obe wɔ baatoofe nii, basaateketetɛ nɔɔ layee batakelee bloblo, dikudi ninwii ko niabu diɛ oklo kamɛ. ");
INSERT INTO snw_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ninfɛ di Yesu laka ma alɛ, “Bilolaa binyu biemufũ suoto lee biklee di Ɔka Herodes ku Farisi batii mmɔle nyankale suoto.” ");
INSERT INTO snw_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Basaateketɛ nɔɔ labuɛ baata baawo alɛ, “Ta nle munankle bloblo apɔ ni oso oobuɛ ɔlaa nwɔ nɛ?” ");
INSERT INTO snw_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Kafɔɔ Yesu latofo ɔlaa wɔ baatoobu ni oso aakaalɛ ma alɛ, “Obe oso biobuɛ bloblo ɔwɛnlaa? Diɛbase ni di nunua, biifuo ɔnya ɔtɛ nsũ, biinu kasɔ? Atoko nkpe ye opĩ nwaa! ");
INSERT INTO snw_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Bikpe anu, kafɔɔ bilɔɔnya! Bikpe atoko, kafɔɔ biloonu! ");
INSERT INTO snw_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Bitanya obe wɔ labɛbɛɛ bloblo akudi anɔɔ lata ni batii nkpe nnɔɔ baale ni? Nkyikyɛ nsɛ di kɔkyɛɛ kɔkyɛɛ ko niabu ni layii?” Ni baatɔkɔ nwɔ alɛ, “Nkyikyɛ lefosi nnyɔ.” ");
INSERT INTO snw_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yesu lakple aakaalɛ ma alɛ, “Di obe wɔ kafɔɔ lasɛ ni bloblo akudi akuɛnsĩ lata ni batii nkpe nna, kɔkyɛɛ kɔkyɛɛ nwu niabu nii, nkyikyɛ nsɛ kuayii?” Baatɔkɔ nwɔ alɛ, “Nkyikyɛ nkuɛnsĩ.” ");
INSERT INTO snw_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ni aakple aakalɛ ma alɛ, “Ni bia nua biinu kasɔ?” ");
INSERT INTO snw_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Obe wɔ baakyɛ baalaadu ni Betsaida, batii banwii lakpaa numbiɛtɛ onwii baawako Yesu nfũ, ni baatikiti nwɔ lekoto alɛ akpanko nwɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ninfɛ di Yesu lamufũ nwɔ kɔɔnɛɛ aakpaa nwɔ aadieko di okpoo ntɛɛ. Ni aafiɛ nwɔ sita di anu, aayɔ nnɛɛ aatika nwɔ di anu, aakaalɛ nwɔ alɛ, “Fɔɔnya lɛsaa lewo?” ");
INSERT INTO snw_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ninfɛ di osuɔtɔ nwu latakatɛsa anu aanyu osi aabuɛ alɛ, “Yii kɔnya batii, kafɔɔ bate fɛɛ awoso. Bakyɛ bookyi.” ");
INSERT INTO snw_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ninfɛ di Yesu lakple aakpanko osuɔtɔ nwu anu nɛ. Di obe nyɔɔfa wɔ mmle kamɛ, osuɔtɔ nwu latikiti anu nwaa aanyu, diakpa nwɔ aakyako asaa ɔnya klekle. ");
INSERT INTO snw_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ninfɛ di Yesu ladiki nwɔ osuku alɛ atɔɔkyɛ leyo nɔɔ, kafɔɔ ataasinkple aalaafe diɛ okpoo nwu kamɛ. ");
INSERT INTO snw_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Nni kamaa Yesu ku basaateketetɛ nɔɔ ladie ninfa baasifi nkpayotũ be niɛkaako ni Kaesarea di Filipi. Baakyɛ ni diɛ osuku, Yesu latɔkɔ ma alɛ, “Bitɔkɔ mi ɔmɛntiikle baatii kobuɛ alɛ nle?” ");
INSERT INTO snw_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Baatɔkɔ nwɔ alɛ, “Batii bawo kobuɛ alɛ, Yaa Ntu Kpeesatɛ Yohane fale. Bawo kafɔɔ kobuɛ alɛ Elia fale. Bawo kafɔɔ kobuɛ alɛ Yaa Ɔlaabuɛtɛtɛ onwii lɛma fale.” ");
INSERT INTO snw_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ninfɛ di Yesu lakple aakaalɛ ma alɛ, “Ni aye mɔ? Owe biefũ bienu bilɛ nle?” Petro latɔkɔ nwɔ alɛ, “Afɔ ninle Kristo wɔ bɛɛpɛ ni ɔfɔɔ nɛ.” ");
INSERT INTO snw_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ninfɛ di Yesu lakpee ma kufiofa alɛ batantɔkɔ kuonwi ɔlaa wɔ mmle baye beekyeko nwɔ ni suoto. ");
INSERT INTO snw_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ni di Yesu lakyako basaateketetɛ nɔɔ asaa otuo nɛ. Aatɔkɔ ma alɛ, “Dikpe nii Otii Obi lefe diibuo kpinwu kamɛ diɛ okpoo banɔɔfo ku Yaa olebatatɛ ku kufiofa batuotɛ nnɛɛ kamɛ mansĩ nwɔ. Babalo nwɔ, kafɔɔ, di dii tiɛfa, abakple ansɛnkɛ.” ");
INSERT INTO snw_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Aatɔkɔ ma sɛlaa se mmle klekle aaloo nii, ninfɛ di Petro lakpaa Yesu aasifiko ɔlɔɔkɔ ni aalaasĩ ɔlaa nwu aatɔɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Kafɔɔ di Yesu lamunikĩi aanyu ni basaateketetɛ nɔɔ, aasĩ ɔlaa nwu aata Petro alɛ, “Abonsam kyɛ mi di ɔlɔɔkɔ!” Ni aakple aabuɛ alɛ, “Disibu lɛfɔ nwu diekye Yaa nfũ kafɔɔ otii nfũ diekye!” ");
INSERT INTO snw_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Nioso Yesu lalɛɛ batii dikudi nwu ku basaateketetɛ nɔɔ aatɔkɔ ma alɛ, “Nse otii owo komiɛ alɛ awa abatikankoe, ni dikpe nii ansĩ suoto nɔɔ, an-yɔ aatoo nɔɔ, antikankoe. ");
INSERT INTO snw_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Diekye otii lele nialɛ ɔɔta nkpa nɔɔ, abayu mi, kafɔɔ otii lele nieyu nkpa nɔɔ diisi nii ta ɔlaa nii biene oso, abawɛ nkpa. ");
INSERT INTO snw_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Lɛmɛntota dibiene di otii mawɛ nse ɛɛwɛ kayi ka mmle asaa amuu eeyu nkpa nɔɔ? ");
INSERT INTO snw_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ee obelɛsaa di otii kayɔ ankyɛlɛnsa anfũ nkpa nwaa nwu? ");
INSERT INTO snw_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Nse otii owo lenunsɔ mi ku ɔlaa nii di Yaa ɔtanyɛkɛ di ayi kpile ya mmle kamɛ, ni ami, Otii Obi nwu, kafɔɔ manunsɔ nwɔ, nse lekple lɛwa di Teemi leklekle kamɛ ku Yaa batɔkyɛntɛ nɔɔ klekle.” ");
INSERT INTO snw_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ninfɛ di Yesu lakple aatɔkɔ ma alɛ, “Nwaako kɔtɔkɔ ye nlɛ, batii bawo kaamɛ lee dilɔbakpi, diediki bitɔɔnya bilɛ Yaa sɛka ole ntɔɔwa ku osie fiɛ.” ");
INSERT INTO snw_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ayi akuɔ sɛmaa, Yesu lakpaa Petro ku Yakobo ku Yohane baakyɛ kobokote takale kunwii osi. Lete lɛma niawɛ ninfa. Obe wɔ basaateketetɛ nɔɔ latoonyu nii, kakyi kanwii lawa di Yesu suoto. ");
INSERT INTO snw_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Awu nɔɔ lapu fututu osie kanya aatoosese di anu aalenke mmle diɛ otii kafoto lɛsaa nindie ni nintu. ");
INSERT INTO snw_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ninfɛ diɛ basaateketetɛ nɔɔ batiɛ nwu lanya Yaa Ɔlaa Babuɛtɛtɛ Mose ku Elia lakyɔɔ baatɔɔkakatɛko Yesu. ");
INSERT INTO snw_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Lɛyɛkɛ lapɛ Petro ku bawo nɔɔ diata alɛ, batatofo be baatoobuɛ. Ninfɛ di Petro latɔkɔ Yesu alɛ, “Saatuotɛ, nfũ loo lɛwa lɛtɛ dilɛ. Diki wo osuku buɔpɛ akpaayo atiɛ. Anwii alefɔ, anwii Mose, anwii kafɔɔ Elia.” ");
INSERT INTO snw_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ninfɛ di dituntũ ninwii labatĩi ma ku kunyĩi nɔɔ, ninfɛ sɛɛlɔ sinwii ladie di dituntũ nwu kamɛ diabuɛ alɛ, “Nnya obi nii bɔmbɔtɛ ninle nwɔ nɛ. Bikyɔɔ nwɔ atoko bienu nwɔ ɔlaa!” ");
INSERT INTO snw_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Nfanwu baanyunyu nii, batasinya kuonwii dilenkee Yesu lete niayila ma diɛ ɔlɔɔkɔ. ");
INSERT INTO snw_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Baakye kobokote osi boosoo manwa nii, Yesu lakpee ma kufiofa alɛ, “Bitantɔkɔ kuonwii lɛsaa le biɛnya ni ninfũ, diɛlase diɛ obe wɔ di ami, Otii Obi nwu, mataka nkye ni bakpi kamɛ.” ");
INSERT INTO snw_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Baakyɔɔ ɔlaa nwu atoko, kafɔɔ se nima nima basi, mantɔɔkaalɛ bawo alɛ, “Ɔtaka Baakpi kamɛ kasɔ mɔ?” ");
INSERT INTO snw_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ninfɛ baakaalɛ Yesu alɛ, “Lɛ oso di kufiofa batuotɛ labuɛ alɛ Yaa Ɔlaa Buɛtɛtɛ Elia kakasa Kristo ɔwa?” ");
INSERT INTO snw_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesu latɔkɔ ma alɛ, “Nwaako baabuɛ Elia maka Kristo katũ ole amalolaa asaa antɛ. Kafɔɔ bɛɛkpana Kɔɔkpana Klekle kamɛ alɛ Otii Obi nwu mafe diibuo kpinwu kamɛ. Babasĩ nwɔ kafɔɔ. Lɛ oso bienyu bilɛ baabuɛ nkpo? ");
INSERT INTO snw_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Kɔtɔkɔ ye nlɛ, Elia ntɔɔwa ɛɛbafe kofokofoko. Kafɔɔ batii ditafũ nwɔ, baabla nwɔ nle ninlɛ ma nii, fɛ mmle baakpana baatɛ ni di suoto nɔɔ.” ");
INSERT INTO snw_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Obe wɔ di Yesu ku basaateketetɛ nɔɔ batiɛ ba mmle lakple baawa ni bawo lɛma kamɛ, baanya alɛ batii kpinwu lamana ma baakyi, baatɔɔnanfi sɛlaa ku kufiofa batuotɛ bawo. ");
INSERT INTO snw_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Obe wɔ baatii nwu lanya alɛ Yesu nfɛ kɔwa nii, diabala ma ɔkpɛ, ninfɛ baatoso baalaakyakako nwɔ baasɛɛsa nwɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesu lakaalɛ basaateketetɛ nɔɔ alɛ, “Obe sɛlaa biyɛ biɔnanfi?” ");
INSERT INTO snw_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ninfɛ di osuɔtɔ onwii di batii nwu kamɛ latɔkɔ Yesu alɛ, “Saatuotɛ, lɛkpaa obi nii lɛwako ɔkyɛ lɛfɔ, ta niwuna kpile nsi nwɔ ni oso, oloofuo ɔkakatɛ. ");
INSERT INTO snw_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Obe lele nse ninwuna nwu kɔkpɛko nwɔ, annɔɔ ampɛ kaasɔ, afuuta ntoodie nwɔ kaanya, antoowee anyɛɛ, eebensa suoto tii. Ninfɛ lɛkpaa nwɔ lɛwako basaateketetɛ lɛfɔ nfũ nlɛ batososa ninwuna nwu di suoto nɔɔ, kafɔɔ baafuo.” ");
INSERT INTO snw_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ninfɛ di Yesu latɔkɔ ma alɛ, “Ee! Miɛ akyɛnfɔɔle lee, ofũ onu lee diɛpɔ! Sɛsɛ bilɛ nsiɛ ye kaamɛ fiɛ biefũ binu. Ee lɛ ninkle ye naase fiɛ bibanu asaa kasɔ? Bikpaa obisɔ nwu biwakoe!” ");
INSERT INTO snw_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ninfɛ baakpaa nwɔ baawako Yesu nfũ nɛ. Diɛ ninwuna kpile nwu lanya ɔnya Yesu, diawanyinsa obisɔ nwu, aanɔɔ aapɛ kaasɔ aakyako osisikiti, afuuta latoodie nwɔ kaanya. ");
INSERT INTO snw_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ninfɛ di Yesu lakaalɛ obisɔ nwu ote alɛ, “Diɛkyako nwɔ ni ɔbla mmle ditɔɔkɛlɛ?” Osuɔtɔ nwu latɔkɔ nwɔ alɛ, “Sibisɔ nɔɔ ke diakyako nwɔ ɔbla. ");
INSERT INTO snw_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Obe lele ninwuna le mmle komiɛ alɛ dilo nwɔ kokooko. Se diɛwa nkpo, ninta alɛ antɔɔnɔɔ antoobuo di ɔtɔ ee ntu kamɛ. Lekoto, nya wo nyaami faakyakaako wo, se lɛsaa le faafuo ni ɔbla dile!” ");
INSERT INTO snw_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu latɔkɔ nwɔ alɛ, “Lɛ oso fɔɔtɔkɔ mi falɛ se kafuo? Lɛsalɛsaa nnaa otii wɔ niefũ mi eenu ni osie.” ");
INSERT INTO snw_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Nfanwu, obisɔ nwu ote labuɛ osie kanya alɛ, “Nkpe ofũ onu kafɔɔ kuɔpɔ. Kyakaakoe ninwɛ ofũ onu nkyakaa!” ");
INSERT INTO snw_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Obe wɔ nfɛ di Yesu lanya alɛ batii kpinwu nfɛ kɔtɛɛtɛ nwɔ nii, ninfɛ aatɔkɔ ninwuna kpile nwu alɛ, “Afɔ ninwuna le ninanta batii lanu ni ku ɔtankakatɛ, kɔtɔkɔ fɔ nlɛ die di obisɔ nwu kamɛ, diidii kafɔɔ tamasimbuo nwɔ kaamɛ!” ");
INSERT INTO snw_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ninfɛ ninwuna le mmle layiisa kudu osie kanya, diawanyinsa obisɔ nwu diatɛ kaasɔ fiɛ diadie diasifi. Obisɔ wɔ late ninfa fɛ le okpi atookpi. Batii ba niayila ni ninfa latoobuɛ alɛ, “Eekpi.” ");
INSERT INTO snw_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Kafɔɔ Yesu lamufũ obisɔ nwu kɔɔnɛɛ aatakatɛsa aase. ");
INSERT INTO snw_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Sɛmaa obe wɔ di Yesu lalabuo ni leyo, basaateketetɛ nɔɔ lakyɛ baalaakaalɛ nwɔ buɛɛ alɛ, “Lɛ oso butafuo ninwuna kpile nwu otososa di obisɔ nwu kamɛ?” ");
INSERT INTO snw_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ninfɛ di Yesu latɔkɔ ma alɛ, “Diediki otii kɔpɛ ɔlaa anta Yaa, annii kanya wlawla fiɛ abafuo ninwuna le mmle okle otososa odiki di otii kamɛ.” ");
INSERT INTO snw_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesu ku basaateketetɛ nɔɔ ladie ninfa baafe di Galilea kasɔ. Yesu ditamiɛ alɛ otii kuonwii atofo nfũ akpe nii, ");
INSERT INTO snw_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","diekye aatootuo basaateketetɛ nɔɔ asaa. Aatɔkɔ ma alɛ, “Otii onwii madiki Otii Obi kálɔ anta batii alɛ balo nwɔ. Ni kafɔɔ dii tiɛfa, abakple ansɛnkɛ ansiɛ nkpa.” ");
INSERT INTO snw_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Kafɔɔ batanu ɔlaa wɔ aatɔkɔ ma ni kasɔ, baayɛkɛ batakaalɛ nwɔ ɔlaa nwu kasɔ. ");
INSERT INTO snw_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Baalabuo ni Kapernaum, baalabuo leyo. Nfa di Yesu lakaalɛ basaateketetɛ nɔɔ alɛ, “Obe ɔlaa biɛtɔɔ nanfi ko bawo biɔwa ni?” ");
INSERT INTO snw_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Kafɔɔ batadiki kanya. Diekye baatɔɔwa nii baatɔɔ nanfi alɛ bootofo otii wɔ nii lenke ni kaamɛ lɛma. ");
INSERT INTO snw_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ninfɛ di Yesu lasiɛ ni kaasɔ, aalɛɛ basaateketetɛ nɔɔ lefosi banyɔ nwu ni aatɔkɔ ma alɛ, “Olele nikomiɛ alɛ ale ɔkasale ni aabla suoto fɛ anaa kayilakɔ, aakyakaako bawo nɔɔ.” ");
INSERT INTO snw_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ninfɛ aata obisɔ onwii lawa aabayila sĩitũ lɛma. Aakpaa obisɔ wɔ aatika l'aatĩ nɔɔ ni aatɔkɔ ma alɛ, ");
INSERT INTO snw_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Otii lele niefũ obisɔ fɛ nwɔ mmle okle ta ami oso, ami eefũ. Otii lele niefũ mi, diele lete nii eefũ. Kafɔɔ ku Teemi wɔ niekpee mi ni kɔtɔ eefũ.” ");
INSERT INTO snw_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ninfɛ di Yohane latɔkɔ Yesu alɛ, “Saatuotɛ, buɔnya osuɔtɔ onwii kotososa anwuna kpile baatii suoto leeyoto lɛfɔ kamɛ. Buatɔkɔ nwɔ bulɛ adiɛ, diekye aasi wo kaamɛ.” ");
INSERT INTO snw_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesu latɔkɔ ma alɛ, “Bitantĩi nwɔ osuku, diekye otii wɔ ni kɔbla ni sɛkpɛ se niɛbla ni ɔkpɛ di leeyooto nii kamɛ, di nni kamaa, ɔlɔbamunikĩi wla akple abuɛ ɔlaa kpile di suoto nii. ");
INSERT INTO snw_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Diekye otii wɔ ninantaka ayila wo ni di suoto, awo ku nnwɔɔ, onwii bule. ");
INSERT INTO snw_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","“Nwaako kɔtɔkɔ ye nlɛ, nse otii lɛta ye ntu kakɔkwɛɛ kanwii bienyi ta ami Kristo bale bile ni oso, Yaa dilabasĩ nwɔ letota biene ɔta. ");
INSERT INTO snw_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Kafɔɔ se otii owo lɛta babisɔ ba mmle niefũ mi beenu nii, onwii lɛma lekple diɛ ofũ onu nɔɔ sɛmaa, otii nwu dibabuo nwɔ osie kanya! Se bɛɛyɔ okũ beenii difuɔ dibinte bɛɛsaka nwɔ siimuu, beefuki nwɔ beekpee di leekpo kamɛ, dialɛ nwɔ ninlenkee. ");
INSERT INTO snw_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","“Nioso se kɔnɛɛ lɛfɔ kunwii kɔlalaasa fɔ ofũ onu, nu kasɔ faabudi kũ fayu! Dilɛ dilenke alɛ faayɔ kɔnɛɛ kunwii fambuo di nkpa be ninnaa ni kaloo, alɛ faawɛ nnɛɛ nnyɔ, Yaa n-yɔ fɔ anfuki ankpee di ɔtɔ wɔ nikofiɛ kunaa ni kaloo kamɛ. ");
INSERT INTO snw_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Se loo kɔkpaa lɛfɔ kafɔɔ nikɔlalaasa fɔ ofũ onu, faabudi kũ fayu. Se nkpaa nnyɔ ɔwɛ alɛ baafuki fɔ mankpee diɛ ɔtɔ wɔ ninnaa ni kaloo kamɛ oso, fakpe kɔkpaa kunwi fasi nkpa be ninnaa ni kaloo, dilɛ dilenke. ");
INSERT INTO snw_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Se loo ninu lɛfɔ ninwii kafɔɔ nikɔlalaasa fɔ ofũ onu, faadiki ni fayu. Dibalɛfɔ ninlenkee alɛ faayɔ ninu ninwii fambuo Yaa sɛka kalekɔ, alɛ faawɛ anu anyɔ alɛ baafuki fɔ mankpee di ɔtɔ kplɛ wɔ nikofiɛ kunaa ni kaloo kamɛ. ");
INSERT INTO snw_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Nfa suoto beebuɛ alɛ, ‘Bakunnwɔɔ ba ninlalasa ni asaa ninfa, manankpi ni diidii! Ɔtɔ wɔ kafɔɔ ninfiɛ ni asaa ninfa, diidii kunnii.’ ");
INSERT INTO snw_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Diekye babayɔ ɔtɔ mankleklesa batii bamuu suoto, fɛ mmle man-yɔ mba mankleklesa oleɔta kafɔɔ. ");
INSERT INTO snw_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Mba nlɛ. Kafɔɔ nse ditooyu ɔmɛnɛfɛ ni mi, be baakple man-yɔ mankpee mi ɔmɛnɛfɛ? Nioso bita mba ɔkpɛ biene disiɛ ye kaamɛ, biesiɛ ku bawo lee di atoko ɔkyɛ ole kamɛ.” ");
INSERT INTO snw_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ninfɛ di Yesu ladie ninfa, aasifi Yudea kasɔ, aataalɛ Yordan okle. Batii kpinwu lakple baawa baabamana nwɔ baakyi ninfa, ninfɛ aatootuo ma Yaa ɔlaa fɛ mmle ambla ni ɔbla nɛ. ");
INSERT INTO snw_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Farisi batii bawo lawa Yesu ɔkyɛ alɛ bɔɔkyɔɔ nwɔ okũ. Baakaalɛ Yesu alɛ, “Kufiofa loo lɛta osuku alɛ osuɔtɔ kasĩ ɔsɔfɔ?” ");
INSERT INTO snw_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ni di Yesu ladiki kanya, aakaalɛ ma alɛ, “Obe kufiofa diɛ Mose lɛta ye?” ");
INSERT INTO snw_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ni baata ntale alɛ, “Mose lɛta osuku alɛ, osuɔtɔ wɔ nialɛ ansimbɔ ni ɔsɔfɔ, aakpana kukũ antɔɔ letofo fiɛ aasĩ nwɔ.” ");
INSERT INTO snw_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesu latɔkɔ ma alɛ, “Mose lakpana nle mmle aata ye di osuku wɔ mmle suoto diekye biesĩ bilɛ, baatantuo ye lɛsaa. ");
INSERT INTO snw_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Diɛ kayi kasɔkakyekɔ, Yaa labla osuɔtɔ ku ɔsanko. ");
INSERT INTO snw_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Nioso Kɔɔkpana klekle kukũ lebuɛ alɛ, ‘Nle mmle oso, osuɔtɔ madie di ote ku ɔya suoto ansifi manko ɔsɔfɔ nɔɔ manaabla onwii, ");
INSERT INTO snw_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","banyɔ lɛma mankple suoto sina sinwii.’ Di Yaa anu, otii onwii nfɛ bale. Diele batii banyɔ. ");
INSERT INTO snw_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Nioso batii ba di Yaa ntɔɔbla ni onwii kasɔ ka suoto, otii atamblasa ma ntɛɛ!” ");
INSERT INTO snw_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Sɛmaa obe wɔ baakyɛ ni leyo, basaateketetɛ nɔɔ lakaalɛ nwɔ ɔlaa wɔ aabuɛ aakyeko ni kufiofa nwu suoto. ");
INSERT INTO snw_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yesu ladiki kamɛ aata ma alɛ, “Osuɔtɔ wɔ niesĩ ni ɔsɔfɔ eekple ɛɛlayɔ ni ɔbamba, ntookpee asɔnɔ, ɛɛbla ɔsɔfɔ nɔɔ nwu kofole okpile. ");
INSERT INTO snw_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Nkpo nwu ke se ɔsanko lesĩ ɔsa ɛɛkyɛ asi ko osuɔtɔ bamba, nnwɔɔ kafɔɔ atookpee asɔnɔ, ɛɛbla ɔsa nɔɔ nwu kofole okpile.” ");
INSERT INTO snw_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Di obe nwu kamɛ tutuutu, batii banwii lakpaa babi lɛma baawako Yesu ɔkyɛ alɛ atika ma nnɛɛ di suoto aakusɛkusɛ ma. Kafɔɔ basaateketetɛ nɔɔ lalɔnko ma. ");
INSERT INTO snw_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Di Yesu lanya ni nkpo, ɔblɔ lafiɛ nwɔ, ni aatɔkɔ basaateketetɛ nɔɔ alɛ, “Bita babisɔ bawa ɔkyɛ nii, bitantĩi ma osuku. Diekye batii fɛ babisɔ ba mmle okle kale ninle Yaa sɛka kalekɔ nwu nkpo. ");
INSERT INTO snw_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nwaa kɔtɔkɔ ye nlɛ otii wɔ ninanfũ ni Yaa sɛka kalekɔ fɛ mmle di obisɔ nwakosa ni suoto kasɔ dilabuo nfa diidii.” ");
INSERT INTO snw_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ninfɛ aasiisa babisɔ ba niawɛ ni ninfa dikudi aatika ma nnɛɛ di suoto aata ma dikusɛkusɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Obe wɔ di Yesu lataka alɛ ooyefe ni osuku, osuɔtɔ onwii latoso aabadu nwɔ aapɛ akunkyi kaatũ nɔɔ, aakaalɛ nwɔ alɛ, “Saatuotɛ Biene, be kabla fiɛ kawɛ nkpa be ninnaa ni kaloo?” ");
INSERT INTO snw_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu lakaalɛ nwɔ alɛ, “Be oso fɔɔlɛɛ mi otii biene? Otii kuonwii nnaa ale ni bienetɛ, diediki Yaa lete. ");
INSERT INTO snw_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Faye Yaa afiofa amuu. ‘Tanlo otii, tankpee asɔnɔ, tan-yu, tanlaa faatika di otii suoto, tankyɔnkyɔ otii faafũ nwɔ asaa, bu teefɔ ku yaafɔ.’ ” ");
INSERT INTO snw_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Osuɔtɔ wɔ lakple aatɔkɔ nwɔ alɛ, “Saatuotɛ, diɛyɔ ni di sibisɔ nii, diɛbase ni bia miɛ, kole afiofa ya mmle amuu.” ");
INSERT INTO snw_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu lanyu nwɔ ku lɛbɔmbɔ ni aatɔkɔ nwɔ alɛ, “Lɛsaa ninwii ko niebu fɔ ɔbla. Tɔɔkyɛ faalaayɔ asaa ya amuu niikpe fɔ ni fasunsũ, faayɔ koto nwu fata bapiitɛ, se fatookple saawɛntɛ di Yaa kafa. Nni kamaa faabatikankoe nfɛ!” ");
INSERT INTO snw_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Obe wɔ di osuɔtɔ wɔ lanu ni ɔlaa wɔ, nnɛɛ lafee nwɔ aakyɛ aasifi ku sɛnyaami diekye asaa lawɛ nwɔ kpinwu. ");
INSERT INTO snw_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu lamunikĩi aanyu basaateketetɛ nɔɔ ni aatɔkɔ ma alɛ, “Dibawɛ osie fiɛ diɛ basaawɛntɛ mafuo Yaa sɛka kalekɔ obuo.” ");
INSERT INTO snw_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ɔlaa wɔ lata basaateketetɛ nɔɔ disi obu. Kafɔɔ Yesu lakple aatɔkɔ ma alɛ, “Babi nii, binyu mmle dikpe osie diɛta ni basaawɛntɛ alɛ baawɛ osuku mambuo ni Yaa sɛka kalekɔ! ");
INSERT INTO snw_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Nfa lɛma obuo mawɛ ma osie dilenke alɛ, kapupɔnkɔ kabuo di pandiɛ dituɛ anfe!” ");
INSERT INTO snw_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Aatɔkɔ ma ni ɔlaa wɔ mmle, diata ma disibu osie kanya! Ninfɛ baatɔɔkaalɛ bawo alɛ, “Ni owe mɔ, nimawɛ didiki?” ");
INSERT INTO snw_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ninfɛ di Yesu lanyu ma tuwĩi ni aatɔkɔ ma alɛ, “Otii kuonwii dilaafuo nle mmle ɔbla. Kafɔɔ nnwɔɔ Yaa, abafuo lɛsaa lele ɔbla.” ");
INSERT INTO snw_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ninfɛ di Petro lakakatɛ aabuɛ alɛ, “Ni awo mɔ? Nyu, buodiɛ asaa loo amuu buɔtɛ buɔwa butikanko fɔ.” ");
INSERT INTO snw_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ninfɛ di Yesu lakakatɛ aabuɛ alɛ, “Nwaa kɔtɔkɔ ye nlɛ bibawɛ asaa ya ninlenkee ni n-ya biediɛ biɛtɛ nii. Diekye otii lele niediɛ leyo nɔɔ ɛɛtɛ, ee babi lɛma, ee ɔya, ee ote, ee babi nɔɔ, ee kofe, ta ami ku ɔlaa biene nwu oso, ");
INSERT INTO snw_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","aawɛ asaa nwu anlenkee kɔlafa nɔɔ kaasɔ ka suoto. Abawɛ ayo ku babi lɛma ku baya ku babi ku afe. Kafɔɔ, abawɛ atikanko. Nni kamaa abawɛ nkpa be ninnaa ni kaloo di kayi ka fɔle nimawa ni kamɛ. ");
INSERT INTO snw_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Kafɔɔ batii kpinwu ba ninle ni katũ male bayɛntɛle. Bayɛntɛle kafɔɔ male bakasale.” ");
INSERT INTO snw_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Di obe wɔ baakyɛ di osuku baatoofe ni Yerusalem okpoo, Yesu lale katũ fiɛ basaateketetɛ nɔɔ latika. Ditutukũ lamufũ basaateketetɛ nɔɔ, lɛyɛkɛ kafɔɔ lapɛ batii ba niatikanko ma nii. Yesu lakple aalɛɛ basaateketetɛ nɔɔ lefosi banyɔ nwu di ɔlɔɔkɔ aalaatɔkɔ ma lɛsaa le nimawa nwɔ ni di suoto. ");
INSERT INTO snw_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Aatɔkɔ ma alɛ, “Binu! Buofe Yerusalem lɛba le babalaayɔ ami, Otii Obi, mankpee ni di Yaa olebatatɛ ku kufiofa batuotɛ nnɛɛ. Babalo mi lɛpɔɔ manyɔ mi mankpee di batii ba ninanle ni Yuda batii nnɛɛ, ");
INSERT INTO snw_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","mma kafɔɔ babakpee mi sinunsɔ, mantufa sita mankpete mi, mampɛ mi ku mpile, manloe. Kafɔɔ di dii tiɛfa suoto, mataka nsiɛ nkpa.” ");
INSERT INTO snw_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ni di Sebedeo babi dile ni Yakobo ku Yohane lawa Yesu nfũ baabatɔkɔ nwɔ alɛ, “Saatuotɛ, buomiɛ bulɛ bla lɛsaa ninwii fata wo.” ");
INSERT INTO snw_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesu lakaalɛ ma alɛ, “Be lɛsaa dile?” ");
INSERT INTO snw_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ni baatɔkɔ nwɔ alɛ, “Nse fɛbasiɛ di lɛkakpomii lɛfɔ nwu di Yaa kafa leeklekle kamɛ, buomiɛ bulɛ faata wo mumasiɛ fɔ di ɔlɔɔkɔ. Onwii loo di oletanɛɛkyɛ lɛfɔ, onwii kafɔɔ di ɔmɛntukyɛ lɛfɔ.” ");
INSERT INTO snw_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesu latɔkɔ ma alɛ, “Bieye lɛsaa le biɔkaalɛ nii! Biefũ bienu bilɛ bibafuo dibuo kakɔkɔɛ ka ntu manyi ni, onyi? Bibafuo ntu okpeesa amanle ya makpe ni dibuo kamɛ kaasɔ ka mmle okpe?” ");
INSERT INTO snw_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ni baatuna alɛ, “Bubafuo.” Yesu latɔkɔ ma alɛ, “Ɛɛ, bibanyi kakɔkɔɛ ka ntu be manyi nii, ku ntu okpeesa amanle ya okle makpe nii. ");
INSERT INTO snw_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Kafɔɔ nnaa osuku ndiki otii wɔ nimasiɛ ni di oletanɛɛkyɛ nii ee ɔmɛntukyɛ nii. Teemi omu mayɔ anta batii ba atoololaa ɛɛtɛ ni kofokofoko.” ");
INSERT INTO snw_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Obe wɔ basaateketetɛ nɔɔ lefosi ba niabu ni lanu ni ɔlaa nwu, baanya ɔblɔ di Yakobo ku Yohane suoto. ");
INSERT INTO snw_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Nioso Yesu lalɛɛ bamuu aasiisa aatɔkɔ ma alɛ, “Aye bamu biye bilɛ abaa banɔɔfotii ninanle ni Yuda batii, nkpe otumi di baatii bamuu kaasɔ suoto. Banɔɔfotii nwu kafɔɔ kotuo suoto maakpee ma. ");
INSERT INTO snw_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Kafɔɔ bitanta diate nkpo kaamɛ lee. Nse onwii kaamɛ lee komiɛ alɛ ale ɔnɔɔfo kaamɛ lee yi, ni dikpe ni eele kpɛmblatɛ ɛɛta babule. ");
INSERT INTO snw_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Se onwii kaamɛ lee komiɛ alɛ ale ɔkasale, ni aale ɔlanle ata batii bamuu. ");
INSERT INTO snw_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Nkpo okle kafɔɔ bia di Otii Obi nwu nkpo diɛwa alɛ batii katɔɔbla sɛkpɛ mantɔɔtɔɔ nɛ. Kafɔɔ nnwɔɔ ɛɛwa alɛ ɔɔbla sɛkpɛ anta batii alɛ aayɔ nkpa nɔɔ kafɔɔ antɛ kaasɔ andiki batii kpi.” ");
INSERT INTO snw_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Nle sɛmaa Yesu ku basaateketetɛ nɔɔ lalaabuo Yeriko. Baatoodie ni di okpoo nwu kamɛ, batii kpinwu latikanko ma. Obe wɔ baakyɛ ni di osuku, baafe numbiɛtɛ onwii bɔɔlɛɛ ni Bartimeo, Timeo obi aale. Aasiɛ kaasɔ aatɔɔkaalɛ asaa di osukulɔɔkɔ. ");
INSERT INTO snw_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Obe wɔ aanu alɛ Yesu Nasaret Otii nikofe nii, aayiisa kudu abuɛ alɛ, “Yesu! Dawid leyo kamɛ obi! Nyɛɛ nyaami!” ");
INSERT INTO snw_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Batii kpinwu ba niatoofe ni ninfa lasĩ ɔlaa baatɔɔ alɛ, adiɛ kudu oyiisa. Kafɔɔ mia aatɛ aayiisa kudu alɛ, “Dawid leyo kamɛ obi ee! Nyɛɛ nyaami kyu woo!” ");
INSERT INTO snw_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Di Yesu lanu nwɔ ni lɛlɛɛ, ni aayila, ni aabuɛ alɛ, “Bilɛɛ nwɔ bitɛɛ.” Ninfɛ baalɛɛ numbiɛtɛ nwu baabuɛ alɛ, “Ta suoto siyɔɔ fɔ! Taka pla, diekye ɔɔlɛɛ fɔ.” ");
INSERT INTO snw_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Kakuinwu, aafuki awu nɔɔ wua aayu aayefe aalaadu Yesu. ");
INSERT INTO snw_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu lakaalɛ nwɔ alɛ, “Obe foomiɛ falɛ mabla nta fɔ?” Numbiɛtɛ wɔ mmle latɔkɔ nwɔ alɛ, “Saatuotɛ, ta anu atikiti mi nintɔɔnya!” ");
INSERT INTO snw_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ninfɛ di Yesu latɔkɔ nwɔ alɛ, “Tɔɔkyɛ. Ofũonu lɛfɔ ntoo diki fɔ.” Kakuinwu, anu nɔɔ latikiti aakyako asaa ɔnya. Ninfɛ aatikanko Yesu, baasifi bamuu lɛma nɛ. ");
INSERT INTO snw_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Di obe wɔ baatɛɛtɛɛ ni Yerusalem baabadu ni Betfage ku Betania ntɛɛ nwu, baabadu kobokote ko bɔɔlɛ ni Nnɔnyi Awoso Kobokote. Nfa di Yesu lakyesee basaateketetɛ nɔɔ banyɔ alɛ batɔɔsɔ. ");
INSERT INTO snw_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ninfɛ aatɔkɔ ma alɛ, “Se biedu okpoo kasale wɔ bibabuo nii, bibanya bilɛ beekpee bɔkɛɛ wɔ ninte ni fɛ pɔnkɔ dibi okũ di otii kuonwii diisiɛ nwɔ ni di suoto. Bidiki nwɔ di okũ, biɛkpaa ni biwakoe. ");
INSERT INTO snw_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Se otii owo lɛkaalɛ ye alɛ, ‘Lɛ oso biɛkpaa ni?’ Bitɔkɔ nwɔ bilɛ Saate komiɛ ni ɔkpɛ ɔbla ko, abakplesa anwako nunua.” ");
INSERT INTO snw_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Nioso batii ba mmle banyɔ lakyɛ baalaanya alɛ beekpee bɔkɛɛ wɔ ninte ni fɛ pɔnkɔ okũ beese di osuɔtɔ onwii kayoko di osukulɔɔkɔ. Obe wɔ baatodiki ni ni di okũ, ");
INSERT INTO snw_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","batii ba banwii niayila ni ninfa lakaalɛ ma alɛ, “Obe biɔbla, be biodiki lɛpɔnkɔbi nwu mimblako?” ");
INSERT INTO snw_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ni baabuɛ fɛ mmle di Yesu latɔkɔ ma ni nɛ. Ni baasuɔtɔ nwu kafɔɔ ladiɛ ma baasifiko ni nɛ. ");
INSERT INTO snw_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Obe wɔ baakpaa bɔkɛɛ nwu baawako ni Yesu, baadiki abula lɛma baatika di bɔkɛɛ nwu suoto, ninfɛ di Yesu layie aasiɛ nwɔ kaamaa nɛ. ");
INSERT INTO snw_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Batii kpinwu lafukuti abula lɛma baatɛ di osuku, bawo kafɔɔ labudi afata di osukulɔɔkɔ baatɛ diɛ osuku nwu suoto alɛ anafu afe. ");
INSERT INTO snw_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Batii ba niale ni katũ ku mba niatikanko ni sɛɛmaa latɔɔtaa siwidi alɛ, “Hosiana! Di kusɛkusɛ ninle nwɔ nikɔwa ni di Saate leyooto kamɛ! ");
INSERT INTO snw_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Bikusɛkusɛsa Ɔka Dawid sɛka kalekɔ ka nikɔwa ni! Biɛtansa Yaa kaatoo!” ");
INSERT INTO snw_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Aabuo ni Yerusalem, Yesu lakyɛ Yuda batii Yaa Olekatakɔ. Aalaanyunyu asaa ya amuu niayila ni ninfa aafenko. Kafɔɔ ta kale nfɛ latooloo ni oso, aadie aasifi Betania ku basaateketetɛ nɔɔ lefosi banyɔ nwu baalaate nfa. ");
INSERT INTO snw_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Di obe wɔ kaale ntɔɔsɛ batoodie di Betania bɔɔwa nii, kɔka laklee Yesu. ");
INSERT INTO snw_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Aanya kaakyonkɔ alɛ kolewoso kunwii n-yɛ ku afata kpinwu bɔɔlɛɛkũ ni figi kowoso. Nioso aakyɛ aalaanyu nse kutika abi di osi. Kafɔɔ obe wɔ aadu ni kowoso nwu kalɔ, aanya alɛ kuotika abi kuanwii. Afata ko niatika. Obe wɔ kubakple kunkpee ni diiwo saa. ");
INSERT INTO snw_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ninfɛ di Yesu latɔkɔ kowoso nwu alɛ, “Kuonwii dilaasinkpee lewosobi lɛfɔ kaanya diidii!” Basaateketetɛ nɔɔ lanu alɛ aabuɛ nkpo. ");
INSERT INTO snw_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Baakyɛ baalabuo ni Yerusalem, Yesu lakyɛ Yuda batii Yaa Olekatakɔ ninfɛ aakyako mba niatoosunsu ni asaa ku mba niatɔɔya ni asaa ninfa ototososa odiki leeyo nwu kamɛ. Aatutukusa koto babiɛtɛ siipunu aayu. Aatukusa mba ninsi boosunsu ni ablonumaa kafɔɔ akpomii aayu. ");
INSERT INTO snw_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Nioso atatuna alɛ otii kuonwi atuka lɛsalɛsaa afenko di Yaa Olekatakɔ anu ninfa. ");
INSERT INTO snw_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ninfɛ aatuo ma asaa aatɔkɔ ma alɛ, “Bɛɛkpana di kɔkpana kelekele kukũ kamɛ alɛ, ‘Baalɛɛ mi leyo alɛ ɔlaa ɔpɛ katakɔ.’ Kafɔɔ aye, bitɔɔyɔ biɛbla bayu kawofakɔ!” ");
INSERT INTO snw_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Yaa olebatatɛ banɔɔfo ku kufiofa batuotɛ ba niawɛ ni ninfa lanu ɔlaa wɔ di Yesu labuɛ nii. Nioso baatoomiɛ osuku wɔ baafe baalo nwɔ nii. Kafɔɔ baatɔɔyɛkɛ ta mmle di asaa otuo nɔɔ labla ni ɔkpɛ oso. ");
INSERT INTO snw_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kɔɔtɔɔfɔ nkpaa lawo nii, Yesu ku basaateketetɛ nɔɔ ladie diɛ okpoo nwu kamɛ. ");
INSERT INTO snw_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kaleesɛ ku kuyitatũ, batooyefe osuku boosifi nii, baanya alɛ kolewoso nwu ntookpi ku sidu nɔɔ kuyɛ. ");
INSERT INTO snw_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petro lanyuma lɛsaa le niawa nii, ninfɛ aatɔkɔ Yesu alɛ, “Saatuotɛ, nyu kowoso ko faakpaani ni ntɔɔyɔɔ!” ");
INSERT INTO snw_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu latɔkɔ ma alɛ, “Bifũ Yaa binu. ");
INSERT INTO snw_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Kɔtɛ nta ye letofo nlɛ otii lele niɛtɔkɔ kobokote ko alɛ kutaka kulabuo diɛ lekpo kamɛ, di otu nɔɔ dietĩi nwɔ osuku, eefũ eenu, dibawa kanya ninkpo nintɔɔ. ");
INSERT INTO snw_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Nioso kɔtɔkɔ ye nlɛ, nse biɛpɛ ɔlaa biɛta Yaa, lɛsaa lele biɛkaalɛ nwɔ, biefũ bienu bilɛ bibawɛ, Yaa kafɔɔ mabla anta ye. ");
INSERT INTO snw_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Se biɛwakosa asi kasɔ bilɛ biɔpɛ ɔlaa minta Yaa, biɛnya bilɛ otii owo lɛbla ye okpile, biyɔ bikyɛ nwɔ mmle diɛ Teeye kaatoo kafɔɔ kayɔ sikpile lee ankyɛ ye ni. ");
INSERT INTO snw_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Kafɔɔ se biɛyɔ bikyɛ nwɔ, Teeye kaatoo kafɔɔ dilɔbayɔ sikpile lee akyɛ ye.” ");
INSERT INTO snw_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesu ku basaateketetɛ nɔɔ lakple baakyɛ Yerusalem. Obe wɔ di Yesu nkyɛ ni di Yaa Olekatakɔ, Yaa olebatatɛ banɔɔfo ku kufiofa batuotɛ ku okpoo banɔɔfo lakyɛ ɔkyɛ nɔɔ. ");
INSERT INTO snw_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ni baakaalɛ nwɔ alɛ, “Ɔmɛnsuku fakpe fɔɔbla asaa ya mmle? Owe kafɔɔ niɛta fɔ osuku nwu nkpo?” ");
INSERT INTO snw_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ninfɛ di Yesu ladiki kanya alɛ, “Bitɛɛ nkaalɛ ye ɔlaa onwii, nse biediki kanya yi, ni amii matɔkɔ ye osuku wɔ nkpe fiɛ kɔbla ni asaa ya mmle nwu nkpo. ");
INSERT INTO snw_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Bitɔkɔ mi, ɔfɛ di Yohane lawɛ osuku fiɛ aatookpeesa batii Yaa ntu? Yaa nfũ kuakye ɛɛ, sɛɛ batii nfũ kuakye?” ");
INSERT INTO snw_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ninfɛ baamumufũ ɔlaa nwu nimanima baanyu alɛ, “Be nfɛ buabuɛ? Nse buobuɛ bulɛ Yaa nfũ kuokye yi, abakaalɛ wo alɛ, ‘Ni be oso bitafũ Yohane bianu mɔ?’ ");
INSERT INTO snw_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Kafɔɔ nse buobuɛ bulɛ ‘Otii nfũ kuokye’ yi!” Bɔɔyɛkɛ nwu kafɔɔ obuɛ diekye bamuu lɛma beefũ beenu alɛ Yohane yi, Yaa ɔlaa buɛtɛtɛ aale. ");
INSERT INTO snw_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Nioso baatɔkɔ Yesu alɛ, “Buoye.” Ninfɛ di Yesu latɔkɔ ma alɛ, “Nkpo okle kafɔɔ di amii, namatɔkɔ ye otii wɔ niɛtɛɛ ni osuku fiɛ kɔbla ni asaa ya mmle nɛ.” ");
INSERT INTO snw_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ninfɛ di Yesu lapɛ ma lɛkpa alɛ, “Obe onwii, osuɔtɔ onwii lakpɛ awosobi ya man-yɔ mambla ni nta kofe. Aakpee kɔba aakyisa kofe nwu. Aakutu dibiɔ di kasɔ nwu ntɛɛ di nfũ abatoodiki ni awosobi nwu nta. Aatofo lɛba le niataka ni kle, baayila mantoonyu ni kofe nwu. Ninfɛ aayɔ kofe nwu nkpo aakpee di bakpɛntɛ banwii nnɛɛ kamɛ alɛ batoonyu, ni aadie aasifi osuku nɛ. ");
INSERT INTO snw_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Di obe lawo alɛ baatɛsɛ ni awosobi nwu, aakpee kpɛmblatɛ nɔɔ alɛ, akyɛ aalaafũ kalekɔ nɔɔ awako nwɔ. ");
INSERT INTO snw_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Kafɔɔ kofe nwu banyuntɛ lamufũ kpɛmblatɛ nwu, baapɛ nwɔ, baatososɔɔ aasifi nnɛɛ fukiti. ");
INSERT INTO snw_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Nni sɛmaa, kofe saate wɔ mmle lakple aakpee kpɛmblatɛ bamba. Aakyɛ nii, kofe banyuntɛ ba mmle lapɛ nwɔ baapila nwɔ disi baakpee nwɔ sinunsɔ nwaa. ");
INSERT INTO snw_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Osuɔtɔ wɔ lakple aakpee kpɛmblatɛ bamba, baalo nwɔ. Aakple aakpee babamba. Baapɛ bawo, baalo kafɔɔ babule. ");
INSERT INTO snw_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Otii wɔ niabu aakple ankpee nwɔ ni niale obi nɔɔ wɔ ambɔmbɔ nii. Lɛyɛntɛle aakple aakpee obi nɔɔ nwu. Ninfɛ aatɔkɔ suoto alɛ, ‘Lefũ lenu nlɛ babata obi nii nwu dibu.’ ");
INSERT INTO snw_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Kafɔɔ kofe nwu nkpo banyuntɛ latɔkɔ bawo alɛ, ‘Nnya kofe saate obi wɔ nimale ni atesaa ninle nwɔ mmle nɛ. Biwa biɛta bulo nwɔ di atesaa nɔɔ nwu nkpo akple wo ale!’ ");
INSERT INTO snw_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Nioso baamufũ obi nwu, baalo nwɔ. Baafuki nwɔ baayu diɛ kɔba nwu sɛmaa.” ");
INSERT INTO snw_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ninfɛ di Yesu lakaalɛ batii nwu alɛ, “Lɛ bienyu bilɛ kofe saate nwu mabla? Matɔkɔ ye! Abakyɛ nfa aanaalo kofe banyuntɛ nwu an-yɔ kofe nɔɔ ankpee baatii bamba nnɛɛ. ");
INSERT INTO snw_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","N-ye nlɛ bitɔka di Kɔkpana Klekle kamɛ lɛba le beebuɛ alɛ, ‘Difuɔ le baayotofotɛ lesĩ nii, nni nintookple difuɔ le niemufũ leyokɔ dikle ni nɛ. ");
INSERT INTO snw_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Saate niɛbla lɛsaa kplɛ le mmle. Nioso diɛbla wo ɔkpɛ osie kanya.’ ” ");
INSERT INTO snw_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Obe wɔ baanu ni ɔlaa wɔ mmle, Yuda batii batunletɛ lamiɛ osie kanya alɛ boomufũ Yesu. Diekye baatofo alɛ mma oso aapɛ lɛkpa nwu. Kafɔɔ baayɛkɛ batii dikudi le niayila ni ninfa. Nioso baadiɛ nwɔ baasifi. ");
INSERT INTO snw_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Sɛmaa, baakyesee Farisi batii bawo ku Herodes batikankotɛ bawo baakyɛ Yesu nfũ alɛ, baalaawolaa nwɔ kaanya di sɛlaa ɔkaalɛ kamɛ. ");
INSERT INTO snw_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Baadu nwɔ nii, baatɔkɔ nwɔ alɛ, “Saatuotɛ, buye bulɛ nwaako ɔlaa fambuɛ obe lele. Fanyɛkɛ otii, nkpo kafɔɔ fanannyu otii di anu nɛ. Kafɔɔ fantuo batii bamuu osuku wɔ ninkpaa otii kunsifiko ni Yaa nfũ. Nioso tɔkɔ wo se dilɛ alɛ buata akpooto munta Roma Batii Ɔka Kplɛ Kaesare. Buta ɛɛ, butanta?” ");
INSERT INTO snw_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Kafɔɔ Yesu lanya kakyɔnkyɔ osuku wɔ suoto baakyɛ nii, nioso aabuɛ alɛ, “Be oso biomiɛ bilɛ bikyɔɔ mi okũ? Biyɔ koto nwu biwakoe ninnyu.” ");
INSERT INTO snw_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Baayɔ koto nwu kunwii baawako nwɔ. Ni aakaalɛ ma alɛ, “Owe disi ku leyooto nintika?” Ni baadiki kanya alɛ, “Kaesare nintika.” ");
INSERT INTO snw_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ninfɛ di Yesu latɔkɔ ma alɛ, “Nioso biyɔ lɛsaa le ninle ni Kaesare lele bitɔɔ. Biɛyɔ lɛsaa le ninle ni Yaa lele kafɔɔ bita Yaa.” Ta nni oso, kanya ditasimbɛ ma, diekye diabla ma ɔkpɛ. ");
INSERT INTO snw_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ni di Saduki batii ba nimbuɛ alɛ nse otii lekpi alaasintaka akye ni bakpi kamɛ lawa Yesu nfũ baabakaalɛ nwɔ ɔlaa nɛ. ");
INSERT INTO snw_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Baakaalɛ nwɔ alɛ, “Saatuotɛ, Mose lakpana kufiofa ko mmle ɛɛtɛ wo alɛ, nse osuɔtɔ owo lekpi eediɛ ɔsɔfɔ ɛɛtɛ, manko nwɔ banaa obi, osuɔtɔ nwu nkpo obilɛma kayɔ kpisɔfɔ nwu nkpo manlofo babi. Ni babi nwu nkpo, batii manya ma fɛ osuɔtɔ wɔ ninnaa ni babi. ");
INSERT INTO snw_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Obe onwii, babilɛma suɔtɔbi bakuɛnsĩ banwii lawɛ. Ɔkasale layɔ ɔsanko aakpi obe wɔ manayilofo ni babi. ");
INSERT INTO snw_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ɔnyɔɔfa kafɔɔ layɔ nwɔ, nnwɔɔ kafɔɔ aakpi diɛ obe wɔ manko ɔsanko nwu bayilofo ni obi kuonwii. Obilɛma tiɛfa kafɔɔ labayɔ ɔsanko nwu, nnwɔɔ kafɔɔ aabafe aakpi di obe wɔ manayilofo ni obi. ");
INSERT INTO snw_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ta nkpo oso bakuɛnsĩ lɛma nwu layɔ ɔsanko wɔ onwii baaloo. Bamuu lɛma baakpi di obe wɔ batalofo ni obi ku ɔsanko nwu. Yɛntɛyɛntɛ, ɔsanko nwu kafɔɔ labakpi. ");
INSERT INTO snw_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Nimɔ, di dii le baakpi makple mantaka nii, owe lɛma ɔsɔfɔ di ɔsanko nwu nkpo male di obe wɔ baakuɛnsĩ lɛma nwu layɔ nwɔ ni?” ");
INSERT INTO snw_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ninfɛ di Yesu ladiki kanya alɛ, “Diele nkpo dibate saa. Lɛnya nlɛ bienu ɔlaa wɔ mmle kasɔ, diekye bieye sɛlaa se ninsi ni diɛ Kɔkpana Klekle Kukũ kamɛ, ee Yaa osie. ");
INSERT INTO snw_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Obe wɔ di bakpi mataka nii, babate fɛ Yaa batɔkyɛntɛ di osi, nioso sɛsa ku sɛsɔfɔ dilabasinwɛ. ");
INSERT INTO snw_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Kafɔɔ fɛ bakpi okple ɔtaka ɔlaa, Mose lakpana lɛsaa di Kɔkpana Klekle Kukũ kamɛ aakyeko dibuu le niatoofiɛ ni suoto. Sɛɛ biloonyuma? Nfa aakpana alɛ, Yaa latɔkɔ nwɔ alɛ, ‘Ami ninle Abraham Yaa, ku Isak Yaa, ku Yakob Yaa nɛ.’ ");
INSERT INTO snw_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Nle mmle kotuo alɛ, nnwɔɔ ninle batii ba ninkpe ni nkpa Yaa, diele bakpi Yaa ale. Katɔkɔ ye nii, aye biɛtɛ bieyu!” ");
INSERT INTO snw_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ni diɛ kufiofa tuotɛ onwii layila ninfa aanu ɔlaa wɔ baatoobuɛ nii. Ni aanu alɛ Yesu lalolaa ɔlaa nwu kanya aadiki nwaa. Ninfɛ aatɛɛtɛ Yesu aakaalɛ nwɔ alɛ, “Kɔmɛnfiofa ninle kufinle di afiofa nwu amuu kamɛ?” ");
INSERT INTO snw_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ninfɛ di Yesu latɔkɔ nwɔ alɛ, “Kufiofa ko niefĩ kulenke ni amuu ninle, ‘O Israel batii, bilolaa binu! Saate Yaa onwii ko ale, lete nɔɔ kafɔɔ ko ninkpe nɛ. ");
INSERT INTO snw_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Nioso dikpe nii fɛɛbɔmbɔ Saate lɛfɔ Yaa, ku otu lɛfɔ omuu, ku ninwuna lɛfɔ nimuu, ku disibu lɛfɔ nimmuu, ku osie lɛfɔ omuu.’ ");
INSERT INTO snw_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Kufiofa ko niekple kutikanko ni nko ninle alɛ, ‘Bɔmbɔ owo lɛfɔ fɛ mmle okle fambɔmbɔ ni suoto.’ Kufiofa kukunwii nsinnaa kulenke ni n-ya mmle.” ");
INSERT INTO snw_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ninfɛ di kufiofa tuotɛ nwu ladiki kanya alɛ, “Saatuotɛ, fɛɛkakatɛ nwaa! Nwaa dile fɛ mmle feebuɛ ni alɛ, Saate lete ninle Yaa, ni Yaa bamba kuonwii nsinnaa dilenkee ni nnwɔɔ. ");
INSERT INTO snw_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Nioso dikpe ni otii lɛbɔmbɔ Yaa ku otu nɔɔ omuu ku disibu nɔɔ nimuu ku osie nɔɔ omuu. Dikpe ni kafɔɔ, ambɔmbɔ owo nɔɔ fɛ mmle okle ambɔmbɔ ni suoto nɔɔ. Dilɛ alɛ otii katikanko afiofa ya mmle anlenkee alɛ ɔɔyɔ babɔkɛɛ ku oleɔta alɛ ɔɔta Yaa.” ");
INSERT INTO snw_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Diɛ Yesu lanya osuku biene wɔ di osuɔtɔ wɔ mmle ladiki ni kanya, ni aatɔkɔ nwɔ alɛ, “Faakyo di Yaa kafa nwu saa.” Nni kamaa, kuonwii ditasinkpee otu aakaalɛ Yesu ɔlaa kuonwii. ");
INSERT INTO snw_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Obe wɔ di Yesu latootuo ni ɔlaa biene nwu di Yuda batii Yaa Olekatakɔ, aakaalɛ ɔlaa alɛ, “Lɛ diawa fiɛ kuufiofa batuotɛ labuɛ alɛ Kristo wɔ bɛɛpɛ ni ɔfɔɔ, Dawid leyo kamɛ obi ale? ");
INSERT INTO snw_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dawid nwu omu, Ninwuna Klekle niakpaa nwɔ ni abuɛ alɛ, ‘Yaa latɔkɔ Saate nii alɛ, “Siɛ di oletanɛɛkyɛ nii, dilaase di, obe wɔ fabatakatɛsa nkpaa fantika ni di balo lɛfɔ suoto.” ’ ");
INSERT INTO snw_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Obe wɔ di Dawid omu lalɛɛ Kristo nwɔ bɛɛpɛ ni ɔfɔɔ alɛ Saate nii, lɛ nfɛ di Kristo nwu, makple anle nwɔ obi?” Batii kpinwu layila ninfa ku suoto lɛyɔɔ baatoonu sɛlaa se di Yesu layila aatoobuɛ nii. ");
INSERT INTO snw_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Di Yesu latootuo ni batii nwu asaa, aatɔkɔ ma alɛ, “Bilolaa binyu di kufiofa batuotɛ suoto. Manklee asaa kplɛ mantookyikyii akpaka mmle baatii kasɛɛsa ma ni ku dibu. ");
INSERT INTO snw_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Mammiɛ alɛ boosiɛ diɛ banɔɔfotii nsiɛkɔ di bawokalɛɛkɔ ku asaa kalekɔ di siipunu kplɛ ntũ. ");
INSERT INTO snw_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Mantafaa bakpisɔfɔ kafɔɔ manfũ ma asaa amuu ninnɛɛ. Mambla fɛ balɛ baatii anu, manklɛsa ɔlaa ɔpɛ ɔta Yaa di akpaka. Letoko nanfi lɛma mapɔ ninlenkee batii bamuu ale!” ");
INSERT INTO snw_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu lakyɛ aalaasiɛ di Yaa Olekatakɔ nwu ninfũ manta ni asaa, aatoonyu mmle di batii kofe mankpee ni ato di asaa ɔta lekpeesa kamɛ. Basaawɛntɛ kpinwu lata ato kplɛ alɛ bootuo suoto. ");
INSERT INTO snw_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Kafɔɔ kpisɔfɔ piitɛ onwii labafe aalaakpee mplɛ nnyɔ. ");
INSERT INTO snw_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ni di Yesu lalɛɛ basaateketetɛ nɔɔ aasiisa aatɔkɔ ma alɛ, “Nwaako kɔtɛ ntɔkɔ ye nlɛ, kpisɔfɔ piitɛ wɔ mmle niɛta koto alenke di batii ba bamuu niɛta ni koto kamɛ. ");
INSERT INTO snw_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Diekye batii ba bamuu niɛta ni asaa, di lɛsaawɛ lɛma kamɛ nle ninlɛ ma ni bɛɛyɔ bɛɛbata. Kafɔɔ ɔsanko wɔ mmle di dipii nɔɔ kamɛ, lɛsaa le ninkpe nwɔ aale ansiɛ ni nkpa nimuu ɛɛyɔ ɛɛbata nɛ.” ");
INSERT INTO snw_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Obe wɔ di Yesu ladie ni di Yuda batii Yaa Olekatakɔ oosifi nii, basaateketetɛ nɔɔ onwii latɔkɔ nwɔ alɛ, “Saatuotɛ, nyu afuɔ nwaa ya bɛɛyɔ beetofo ni ayo ya kplɛ ku mmle beetofo nya ni. Diɔlɛ onyu lo!” ");
INSERT INTO snw_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu latɔkɔ nwɔ alɛ, “Lolaa ayo biene ya mmle fanyu nwaa, diekye afuɔ ya mmle kuninwii dilɔɔbabu ditika leewo suoto alɛ blɔbabiɛ nya bakpakpaa bawii!” ");
INSERT INTO snw_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Di obe wɔ di Yesu lasifi aalaasiɛ ni di Nnɔnyi Awoso Kobokote suoto yi, nfa aanyu Yaa Olekatakɔ nwu di osuku kakyɛ nyɔɔfa. Ninfɛ di Petro ku Yakobo ku Yohane ku Andrea lawa ɔkyɛ nɔɔ buɛɛ baabakaalɛ nwɔ alɛ, ");
INSERT INTO snw_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Saate, tɔkɔ wo, ɔmɛmbe di nle mmle mawa? Be nimale dituosaa le bubayɔ muntofo bulɛ, obe nwu ntoowo ni?” ");
INSERT INTO snw_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ninfɛ di Yesu latɔkɔ ma alɛ, “Bilolaa binyu nwaa alɛ otii kuonwii lakyɔnkyɔ ye. ");
INSERT INTO snw_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Batii kpinwu mayɔ leyooto nii manwa ɔkyɛ lee, mamatɔkɔ ye alɛ, ‘Ami dile,’ man-yɔ mankyɔnkyɔ batii kpinwu. ");
INSERT INTO snw_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Bitanta diabla ye ɔkpɛ se bienu kakpɛ kudu di ɔlɔɔkɔ lee ee kakyonkɔ. Dikpe ni asaa ya mmle okle lɛwa. Kafɔɔ dietuo alɛ kayi kalookɔ ntoowo. ");
INSERT INTO snw_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nnle mataka baawo suoto, sɛka nlekɔ kafɔɔ mataka baawo suoto. Nsɔ matũkũ di aba aba. Aka siene kafɔɔ makpɛ di aba aba. Asaa ya mmle nte fɛ mmle lɛɛmɛ nkye kasɔ nintoonu ni mɛlakatɛ nintɔɔtɛ nii. ");
INSERT INTO snw_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Dikpe nii, bielolaa bienyu. Babamufũ ye mansifiko nkankɔ. Babapɛ ye di Yuda batii bawo nsiisakɔ. Ta ami oso, bibayila di baka ku batunletɛ anu, mintɔkɔ ma Yaa ɔlaa biene nwu nkpo. ");
INSERT INTO snw_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Kafɔɔ fiɛ di kayi kaloo mawa nii, dikpe nii beebuɛ Yaa ɔlaa biene nwu bɛɛtɔkɔ batii bamuu kaayi. ");
INSERT INTO snw_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Di obe wɔ babamufũ ye mansifiko ni kakankɔ, bitambu diisi di ɔlaa wɔ biofe ni obuɛ olesakatũ. Se obe nwu lewo, biebuɛ ɔlaa lele di Yaa Ninwuna Klekle mata ye ni. Diekye diele aye bamu ɔlaa bibabuɛ. Ninwuna Klekle nimata ye ɔlaa wɔ bibabuɛ nii. ");
INSERT INTO snw_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Batii mayɔ babilɛma manta alɛ balo. Balofotɛ kafɔɔ mabla nkpo di babi lɛma suoto. Babi mataka di balofotɛ lɛma suoto alɛ balo ma. ");
INSERT INTO snw_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Batii bamuu makyidi ye ta ami oso. Kafɔɔ otii wɔ niekpee otu ɛɛlaase ni kaayɛntɛlekɔ, kamawɛ nkpa be ninnaa ni kaloo. ");
INSERT INTO snw_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Binu ɔlaa wɔ matɔkɔye ni nwaa obebe biɛnya abusufɔɔsaa yɛkɛle n-yɛ di lɛba le ninankaatɛ alɛ aayila nii, ni biɛta batii ba ninkpe ni di Yudia batoso basifi abokote osi balaawofa. ");
INSERT INTO snw_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Otii wɔ kafɔɔ nintika ni di leyo nɔɔ osi, atantɔkɔ alɛ oosoo anwa amayɔ lɛsalɛsa nɔɔ leeyo kamɛ ansifiko. ");
INSERT INTO snw_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Otii wɔ ninkpe ni koofe, atasinkple aatɔkɔ alɛ ooyie ammayɔ akleesaa nɔɔ leeyo. ");
INSERT INTO snw_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Di obe nwu nkpo kamɛ, dibatɛ ninwɛ osie ninta basanko ba ninlaka ni amɛ ku mba nikɔta babi nyɛɛfu nii. ");
INSERT INTO snw_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Bipɛ ɔlaa bita Yaa bilɛ, obe nwu kutanwa di lɛwɔɔfɔ obe! ");
INSERT INTO snw_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Diekye dibuo le nimawa ni diɛ obe nwu kamɛ malenkee nle okle nintɔwa diɛbafe ni di obe wɔ kaayi lakye ni kasɔ diɛbase ni diɛ miɛ dii le mmle. Dibuo le mmle okle kafɔɔ dilabasinwa diidii. ");
INSERT INTO snw_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kafɔɔ Saate lɛkɔkɔlɛ ayi nwu nkpo. Se diele nkpo ɛɛbla se otii kuonwii dilababu. Kafɔɔ ta batii nɔɔ ba eediki ɛɛta ni suoto oso, ɛɛkɔkɔlɛ ayi nwu. ");
INSERT INTO snw_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Nioso se otii owo lɛtɔkɔ fɔ alɛ, ‘Nyu! Nnya Kristo ninfũ!’ ee ‘Nyɔɔ ninfa!’, tanfũ nwɔ faanu! ");
INSERT INTO snw_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Diekye batii mataka manlaa mambuɛ alɛ mma ninle Kristo nwu nkpo, bawo kafɔɔ mabuɛ alɛ Yaa ɔlaa babuɛtɛtɛ bale. Bababla sɛkpɛ se niɛbla ni sɛkpɛ ku atuosaa ate ate mantuo alɛ, nse dialɛ yi, baayɔ mankyɔnkyɔ bia batii ba di Yaa lediki eese ni lete. ");
INSERT INTO snw_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Nioso bilolaa binyu! Nkpo oso ntoole katũ lɛtɔkɔ ye sɛlaa se mmle simuu fiɛ di obe nwu mawo nɛ. ");
INSERT INTO snw_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ayi ya nimawa ni diibuo nwu sɛmaa, ‘Kufĩ mata ditunu, kɔwɛntɛ kafɔɔ dilabapu. ");
INSERT INTO snw_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Awɛntlɛbi kafɔɔ makpa ankye osi, osi asaa kafɔɔ matididi di aba ya atika nii.’ ");
INSERT INTO snw_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Nni kamaa batii manya Otii Obi nwu makyɔɔ di alokonkyɛ kamɛ ɔɔwa ku osie kplɛ di leklekle kamɛ. ");
INSERT INTO snw_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Abakyesee Yaa batɔkyɛntɛ kaayi ka mmle nkyakakɔ nwu nkpo nna, mansiisa batii nɔɔ ba eediki ni mankyeko kaasɔ disi le diɛlase ni diisi le. ");
INSERT INTO snw_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Bitekete lɛsaa bikyeko kolewoso suoto. Nse kuodie sɛlamii fɔle kuodie atoto kuokpee afata fɔle kamaa, bietofo bilɛ kanto ɔnɔɔ bee nfɛ kowo. ");
INSERT INTO snw_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Nkpo kafɔɔ se nfɛ diɛwa alɛ asaa ya lɛtɔkɔ ye ni nfɛ kɔkyɔɔ, ni bietofo bilɛ ni kayi kalookɔ nfɛ kɔtɛɛtɛɛ katoodu ni kayokontũ lɛfɔ tintĩ! ");
INSERT INTO snw_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nwaa kɔta ye mintofo nlɛ asaa ya mmle amuu mawa fiɛ di kale lee batii bamuu maloo okpi. ");
INSERT INTO snw_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Osi ku kasɔ kamuu mafe, kafɔɔ ɔlaa nii nnwu, kulabafe diidii. ");
INSERT INTO snw_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Otii kuonwii dieye dii nwu nkpo ku obe wɔ kamɛ dibale nii. Yaa batɔkyɛntɛ ba ninkpe ni di osi dieye. Bia Obi nwu nkpo omu dieye, Ote lete ninnye. ");
INSERT INTO snw_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Bilolaa binyu, biɛta anu lee ate kesekese, ta bieye dii le diɛ obe nwu mawo nii. ");
INSERT INTO snw_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ote di bate fɛ mmle diɛ otii ndie ni di okpoo nɔɔ alɛ ɔɔkyɛ ni osuku, andiɛ ni bakpɛmblatɛ nɔɔ leeyo. Aata obiala ɔkpɛ wɔ abatɔɔbla nii. Nni kamaa, aatɔkɔ otii wɔ nikonyu nwɔ ni ayo kayoko kplɛ alɛ alolaa kayoko anyu nwaa. ");
INSERT INTO snw_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Ta nninkpo oso ayee bilolaa suoto. Diekye bieye obe wɔ diɛ Saate lee mawa ammabuo nii. Diafuo ole alɛ kakũ, ee nkyɛntɛɛ, ee obe wɔ diɛ bakɔɔkɔ mbo nii, ee oyita. ");
INSERT INTO snw_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Se loo eefua ɛɛwa, mmle ninamate alɛ ɛɛbatũ ye bisi biɔkyɔsĩi nii. ");
INSERT INTO snw_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Lɛsaa le kɔtɔkɔ ye ni ninfũ, nni nwu ko nkle kɔtɔkɔ batii bamuu nɛ. Nni oso kafɔɔ bialolaa suoto nɛ.” ");
INSERT INTO snw_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ditoobu ayi anyɔ fiɛ di Yuda batii male ni ayi lɛma ya manlɛɛ ni Okpi Diisi Ofe Dii ku Bloblo wɔ Ninantaka Ni Olebee, man-yɔ mannyuma ni odie lɛma di Egipte. Olebatatɛ banɔɔfo ku kufiofa batuotɛ lawɛ ninfa baatoomiɛ osuku wɔ baawofa mamufũ Yesu manlo nii. ");
INSERT INTO snw_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ni baabuɛ baatɔkɔ bawo alɛ, “Ditanwa alɛ buɔbla lɛsaa le mmle di ayi ya buole ni kamɛ. Se diele nkpo, batii manya ɔblɔ mantaka wo di suoto.” ");
INSERT INTO snw_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu lawɛ di Betania okpoo diɛ Simon wɔ niafiɛ ni ofiɛ sɛɛle leyo. Ɔbe wɔ di Yesu lasiɛ aatoole ni alesaa, ɔsanko onwii lawa nfa. Aaklee difuɔ kylɔkylɔ lebo ninwii di nnɔnyi kɔnɔkɔnɔ be niefũ ni kɔya osie kanya lasiɛ ni kaamɛ. Ɔsanko wɔ mmle latikiti lebo nwu aanyɛɛnɛ nnɔnyi nwu aakpete di Yesu disi. ");
INSERT INTO snw_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Lɛsaa nwu lafiɛ batii ba niayila ni ninfa bawo ɔblɔ diata baabuɛ alɛ, “Be lɛsaa oso ɛɛlalaasa nnɔnyi be mmle, nkpo okle? ");
INSERT INTO snw_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Aafuo ɔyɔ osunsũ anwɛ lɛlɛɛ nɔɔ ɔkpɛ koto an-yɔ anta bapiitɛ.” Ta nnle mmle oso, baasĩ ɔlaa baatɔɔ ninfa osie kanya. ");
INSERT INTO snw_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Kafɔɔ Yesu latɔkɔ ma alɛ, “Bidiɛ nwɔ! Be oso biokpee ɔsanko wɔ mmle kubuɛ? Lɛsaa biene ninle nle mmle ɛɛbla ɛɛtɛɛ nii nɛ. ");
INSERT INTO snw_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Bapiitɛ nsi ye kaamɛ obe lele. Obe lele mimbɔ biafuo ma ɔkyakaako. Kafɔɔ ami, diele obe lele kamawɛ ye kaamɛ. ");
INSERT INTO snw_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ɔsanko wɔ lɛbla lɛsaa le aafuo ni ɔbla. Ɛɛyɔ nnɔnyi kɔnɔkɔnɔ be mmle eekpete mi, oololaa mi anta okookaa bee nii. ");
INSERT INTO snw_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nwaako kɔtɔkɔ ye nlɛ, kakɔ lele beeyie ɔlaa biene wɔ mmle lɛkya di kayi ka mmle kamɛ yi, lɛsaa le di ɔsanko wɔ mmle lɛbla nii, bababuɛ nwu man-yɔ mannyuma nwɔ.” ");
INSERT INTO snw_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ninfɛ di Yuda Iskariot, dile ni Yesu basaateketetɛ onwii lɛma, lakyɛ olebatatɛ banɔɔfo nfũ aalaatɔkɔ ma alɛ abadiki Yesu anta ma nɛ. ");
INSERT INTO snw_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Suoto layɔɔ ma nwaa diɛ ɔlaa wɔ aabatɔkɔ ma ni oso, mma kafɔɔ baabuɛ alɛ babatɔɔ koto. Nioso Yuda nfɛ lawɛ ninfa aatoomiɛ osuku wɔ suoto abafe andiki Yesu anta ma nii. ");
INSERT INTO snw_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Diɛ Bloblo wɔ Ninantaka ni Dii ole kamɛ, di dii kasale le suoto manlo ni Okpi Diisi Ofe lefosobi, Yesu basaateketetɛ nɔɔ lakaalɛ nwɔ alɛ, “Ɔfɛ foomiɛ falɛ bulaawa Okpi Diisi Ofe Dii ole alesaa nwu buta fɔ?” ");
INSERT INTO snw_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ninfɛ di Yesu ladiki banyɔ kaamɛ lɛma aatɔkɔ ma alɛ, “Bikyɛ okpoo, osuɔtɔ onwii mawa amakyakako ye atuka ntu dibukii. Bitikanko nwɔ biɛlaabuo leyo le kamɛ ababuo ni. ");
INSERT INTO snw_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Biɛkaalɛ leyo nwu saate bilɛ, ‘Saatuotɛ alɛ bukaalɛ fɔ nii, lɛmɛnyo kamɛ di ami ku basaateketetɛ nii, bubasiɛ munle Okpi Diisi Ofe alesaa?’ ");
INSERT INTO snw_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Abatuo ye leyo dibinte ninwii beetofo beetika ni di osi, nfũ beelolaa, beese ni asiɛsaa. Biwa mmiɛ dii nwu alesaa ninfa bita wo.” ");
INSERT INTO snw_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Basaateketetɛ ba ladie baasifi okpoo nwu, baalaanya lɛsaa biala fɛ mmle di Yesu latɔkɔ ma ni. Ni baawa Okpi Diisi Ofe alesaa nwu ninfa baase nɛ. ");
INSERT INTO snw_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Obe wɔ di kɔtɔɔfɔ lawo nii, Yesu ku basaateketetɛ nɔɔ nwu lefosi banyɔ lasifi baalaabuo nfa. ");
INSERT INTO snw_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Obe wɔ nfɛ baasiɛ baatoole ni alesaa di opunu katũ, Yesu labuɛ alɛ, “Nwaako kɔtɔkɔ ye nlɛ otii onwii kaamɛ lee madiki mi anta, nũ busi buole alesaa mmle.” ");
INSERT INTO snw_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ɔlaa nwu lata ma disibu, ninfɛ baatɔɔkaalɛ nwɔ onwii onwii alɛ, “Nwaa, n-ye nlɛ diele ami falaka, sɛɛ ami dile?” ");
INSERT INTO snw_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu latɔkɔ ma alɛ, “Onwii leefosi banyɔ lee kamɛ dile. Munko nwɔ niekpee kɔnɛɛ kaasɛfɛ ninfũ nɛ. ");
INSERT INTO snw_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ami, Otii Obi nwu nkpo, makpi fɛ mmle okle di Kɔkpana Klekle Kukũ labuɛ nii. Kafɔɔ otii wɔ nimadiki ami, Otii Obi nwu nkpo, anta nii, ayɔɔsa. Nse bia batanlofo nwɔ, nse dilɛ nwɔ dilenke!” ");
INSERT INTO snw_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Di obe wɔ di Yesu ku basaateketetɛ nɔɔ nsi boole ni alesaa yi, ni aayɔ bloblo nɛ. Ni aapɛ Yaa sɛfa, aafee nwɔ, aayɔ aata basaateketetɛ nɔɔ, aatɔkɔ ma alɛ, “Bifũ bile. Nle mmle ninle suoto nii sina nɛ.” ");
INSERT INTO snw_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ninfɛ aayɔ opũ, ni aapɛ Yaa sɛfa, aayɔ aata bamuu lɛma baanyi. ");
INSERT INTO snw_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ninfɛ aatɔkɔ ma alɛ, “Nle mmle ninle ntɔ nii be bɛɛyɔ beese ni kaanya di Yaa kanya ninii le eenii ni ku batii nɛ. Beewii mi kaasɔ di batii kpinwu disi. ");
INSERT INTO snw_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nwaako kɔtɔkɔ ye nlɛ, noosinwa nta be mmle onyi diɛlase di dii le makple nyi ni nta fɔle diɛ Yaa sɛka kalekɔ.” ");
INSERT INTO snw_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ninfɛ baasa onu onwii baatansa Yaa, ni baadie baasifi Nnɔnyi Awoso Kobokote suoto nɛ. ");
INSERT INTO snw_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Nfa di Yesu latɔkɔ basaateketetɛ nɔɔ alɛ, “Bamuu lee bibatoso mindiɛ mi. Diekye Kɔkpana Klekle Kukũ labuɛ alɛ, ‘Yaa malo bafosokpatɛ nwu nkpo se bafoso nwu bamuu ntɔɔsamii.’ ");
INSERT INTO snw_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Kafɔɔ nse beekple bɛɛsɛnkɛsɛɛ bɛɛwako nkpa kamɛ yi, male ye katũ nsifi Galilea.” ");
INSERT INTO snw_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ninfɛ di Petro latɔkɔ Yesu alɛ, “Mintɛ bawo nii bamuu matoso mandiɛ fɔ yi, ami diidii namatoso ndiɛ fɔ!” ");
INSERT INTO snw_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ni di Yesu latɔkɔ Petro alɛ, “Kɔta fɔ fantofo nwaa nlɛ miɛ kakyɛ fiɛ di kɔɔkɔ mabo ni sɛnyɔ afɔ omu fababuɛ sitiɛ simu falɛ faaye mi.” ");
INSERT INTO snw_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Petro lakple aatɔkɔ nwɔ osie kanya aalenkee lɛkasale alɛ, “Nse bia olo alɛ booloe munko fɔ yi, diidii namabuɛ nlɛ ninye fɔ.” Basaateketetɛ bule bamuu kafɔɔ labuɛ nkpo. ");
INSERT INTO snw_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Nni kamaa baalaadu lɛba le bɔɔlɛɛ ni Getsemane. Ni di Yesu latɔkɔ basaateketetɛ nɔɔ alɛ, “Bisiɛ ninfũ ninaapɛ ɔlaa nta Yaa.” ");
INSERT INTO snw_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ni aakpaa Petro ku Yakobo ku Yohane aasifiko nɛ. Otu latɔɔpɛ nwɔ, aakyako otũtũkũ kpakpa. ");
INSERT INTO snw_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ni aatɔkɔ ma alɛ, “Konu dibuo di otu nii kamɛ osie kanya fɛle kukpi ninkle mi. Aye bisiɛ ninfũ bietoonyu.” ");
INSERT INTO snw_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Aakyɛ ni sitũ kɛɛkɛ, aapɛ akunkyi, ni aafuusa anu kaasɔ aatikiti Ote lekoto alɛ, “Se dialɛ, ni, dibuo obe wɔ mmle dife mi.” ");
INSERT INTO snw_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ni aabuɛ alɛ, “Teete nii! Fanfuo asaa amuu ɔbla. Se feetuna, faatekete dibuo opũ wɔ mmle di suoto nii. Kafɔɔ tambla nle ninlɛ mi nii, bla dibiesaa lɛfɔ.” ");
INSERT INTO snw_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ninfɛ aakple aawa basaateketetɛ nɔɔ batiɛ nwu nfũ, aabatũ ma bɔɔkyɔsĩi. Ni aatɔkɔ Petro alɛ, “Simon, sɛkyɔsĩ bikle? Ni bilaafuo osiɛ otoonyunkoe lebombo ninwii pɛ?” ");
INSERT INTO snw_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ni aakple aatɔkɔ ma alɛ, “Bita anu lee ate kesekese biɛpɛ ɔlaa bita Yaa mmle minaabuo ni diɛ ɔsɔ onyu kamɛ. Ninwuna komiɛ ɔbla, kafɔɔ suoto sina nnaa osie.” ");
INSERT INTO snw_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Aakple aasifi aalaapɛ ɔlaa aata Yaa fɛ mmle aabuɛ ni lɛkasale. ");
INSERT INTO snw_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Obe wɔ aakple aawa ni basaateketetɛ nɔɔ nwu nkpo nfũ, aabanya ma baatɔɔkyɔsĩi, batafuo bia anu otikiti. Nioso batafuo ɔlaa kuonwii obuɛ ɔtɔkɔ Yesu. ");
INSERT INTO snw_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Aakple aawa ni ditiɛfa, aakaalɛ ma alɛ, “Sɛkyɔsĩ biɔkyɔsĩi mintɛ ɔnyɛɛ nkpo nɛ? Nfɛ dilɛ! Obe ntoowo! Batɔɔyɔ ami, Otii Obi nwu, beekpee diɛ bakpileblatɛ nnɛɛ kamɛ. Binyu, nfɛ bakyɛ diɛ osuku bɔɔwa. ");
INSERT INTO snw_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Bitaka buɔlaakyakako ma. Binyu! Otii wɔ niediki mi ɛɛta ni nleko ma katũ.” ");
INSERT INTO snw_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu lakple aayila aatɔɔkakatɛ ko ma fiɛ di Yuda wɔ ninle ni lefosi batii banyɔ nwu nkpo onwii lɛma lawa. Batii dikudi le di olebatatɛ banɔɔfo ku kufiofa batuotɛ ku okpoo banɔɔfo ladiki ni latikanko nwɔ baatɔɔwa. Baaklee nwosoku ku mpamii. ");
INSERT INTO snw_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Otii wɔ niadiki Yesu aata ni latɔkɔ ma aatɛ alɛ, “Otii wɔ kamaminiko mbla ni atuu yi, nnwɔɔ ninle nwɔ biowolaa ni nɛ. Biemufũ nwɔ, biɛkpaa nwɔ bisifiko, biɛta anu lee atika nwɔ di suoto.” ");
INSERT INTO snw_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Obe wɔ diɛ Yuda labadu ni nfa, ni aakpukuti aatɛɛtɛ Yesu, aalɛɛ nwɔ alɛ, “Saatuotɛ!” Ni aaminiko nwɔ aabla nwɔ aatuu nɛ. ");
INSERT INTO snw_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ninfɛ baamufũ Yesu nɛ, baakle nwɔ kpinkpĩ. ");
INSERT INTO snw_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Kafɔɔ batii ba niayila ni di Yesu ɔlɔɔkɔ onwii lɛma ladiki kapamii nɔɔ aasafɔ Oletatɛ Nɔɔfo kpɛmblatɛ onwii kotoko aakpa nɛ. ");
INSERT INTO snw_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ninfɛ di Yesu latɔkɔ ma alɛ, “Be oso di mpamii ku nwosoku bikle biɛwa mi omufũ fɛle kpileblatɛ nɔɔfo nle? ");
INSERT INTO snw_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Lasiɛ di Yaa Olekatakɔ nwu nkpo dii biala latootuo batii asaa, kafɔɔ bitatɔkɔ bilɛ biomufũ mi. Kafɔɔ fɛ mmle di Yaa Kɔkpana Klekle lebuɛ nii, dikpe nii, ninwa kaanya.” ");
INSERT INTO snw_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ninfɛ diɛ basaateketetɛ nɔɔ bamuu latoso baadiɛ nwɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Di obe wɔ mmle kamɛ, okosopo onwii lakpa kabulɛɛ fututu lete aatikanko Yesu aatoonyu ɔsaabla nwu omuu. Basaanyuntɛ nwu lamiɛ alɛ boomufũ okosopo nwu. Kafɔɔ kabulɛɛ fututu nɔɔ nwu ko baafuo ɔwɛ. Diekye aasikitisa suoto, ");
INSERT INTO snw_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","aadie ma ninnɛɛ. Ninfɛ aatoso aasifi ku lɛkyɔtɔ nɛ. Aadiɛko ma kabulɛɛ nɔɔ nwu. ");
INSERT INTO snw_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ninfɛ baakpaa Yesu baasifiko Oletatɛ Nɔɔfo leyo nɛ. Nfa diɛ Yaa olebatatɛ ku okpoo banɔɔfo ku kufiofa batuotɛ lasi nɛ. ");
INSERT INTO snw_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petro latikanko nwɔ sɛɛmaa fanfa aalaabuo Yaa Oletatɛ Nɔɔfo nwu leyo kaflɔnkɔ di bawo kalɛɛkɔ. Aalaasiɛ di asaa banyuntɛ ɔlɔɔkɔ, aatɔɔwɔfɔ ɔtɔ. ");
INSERT INTO snw_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Olebatatɛ banɔɔfo ku bakantɛ nwu nkpo niawɛ ni ninfa bamuu lamiɛ alɛ boobudi kanya mantika di Yesu suoto mmle baafuo nwɔ ni olo. Kafɔɔ batawɛ ɔlaa kuonwii di suoto nɔɔ. ");
INSERT INTO snw_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Batii kpinwu lababuɛ sɛlaa baatika nwɔ di suoto kafɔɔ nnya lɛma ditabla kanwii. ");
INSERT INTO snw_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Batii bawo kafɔɔ labayila baalaa sɛlaa kuafunu baatika di Yesu suoto alɛ, ");
INSERT INTO snw_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Buanu aabuɛ alɛ, ‘Mabiɛ Yaa Olekatakɔ ka mmle bɛɛyɔ nnɛɛ beetofo nii. Diɛ ayi atiɛ kamaa, makple ntofo lɛbamba ninanle batii nietofo nii.’ ” ");
INSERT INTO snw_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Batii ba mmle kafɔɔ, nnya lɛma ditabla kanwii di sɛlaa se baabuɛ ni di suoto nɔɔ. ");
INSERT INTO snw_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ninfɛ di Oletatɛ Nɔɔfo lataka aayila siitũ lɛma aakaalɛ Yesu alɛ, “Feenu ɔlaa wɔ beebuɛ ni di suoto lɛfɔ? Ɔmɛnlaa ninkpe fɔ fambuɛ?” ");
INSERT INTO snw_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Kafɔɔ Yesu lamaasa kanya atabuɛ ɔlaa kuonwii. Yaa Oletatɛ Nɔɔfo nwu lakple aakaalɛ Yesu alɛ, “Afɔ ninle Kristo nwu di Yaa lɛpɛ ni ɔfɔɔ ale ni Yaa Klekle Obi nɛ?” ");
INSERT INTO snw_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu latɔkɔ nwɔ alɛ, “Ami nɛ. Diɛyɔ di nua diesifi nii, bibanya Otii Obi nwu nkpo nsi di Yaa wɔ ninlenke ni oletanɛɛkyɛ. Bibanyɔɔ kafɔɔ eekye osi ɔɔwa di alokonkyɛ kamɛ!” ");
INSERT INTO snw_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ninfa nwu, Yaa Oletatɛ Nɔɔfo niabɛ awu nɔɔ ku ɔblɔ aabuɛ alɛ, “Falɛ obee ye? Diesinfĩ alɛ otii kuonwii kayila ɔlaa owo kamaa! ");
INSERT INTO snw_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Bienu mbusuo ɔlaa wɔ eebuɛ ni di Yaa suoto? Ɔmɛnlaa ninkpe ye mimbuɛ?” Ni bamuu lɛma baabuɛ alɛ, eekpi lɛpɔɔ, dikpe nii beelo nwɔ. ");
INSERT INTO snw_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Batii bawo kaamɛ lɛma lakyako sita otufa okpete Yesu. Baanii nwɔ anu, baakyako nwɔ ɔpɛ ku nnɛɛ lɛma. Ni baatɔɔtɔkɔ nwɔ alɛ, “Faye ni lɛsaa biala, tɔkɔ wo otii wɔ niɛpɛ fɔ ni!” Ninfɛ di basaanyuntɛ nwu kafɔɔ lakpaa nwɔ baalaapɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Di obe nwu kamɛ Petro lakple aawɛ di bawo kalɛɛkɔ nwu fiɛ di Yaa Oletatɛ Nɔɔfo kpɛmblatɛ sankobi nɔɔ onwii lawa nfa. ");
INSERT INTO snw_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Obe wɔ aanya alɛ Petro nsi ɔɔwɔfɔ ni ɔtɔ, ni aakyako nwɔ onyu tuwĩi aatɔkɔ nwɔ alɛ, “Afɔɔ faatikanko Yesu Nasaret Otii nwu!” ");
INSERT INTO snw_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ninfɛ di Petro labɛ ɔnyasie aabuɛ alɛ, “Obeeye? Ami noonu ɔlaa wɔ foobuɛ ni ninfũ kasɔ!” Ninfɛ aataka aadie di kayoko nɛ. Nfanwu aadu ni kayoko, kɔɔkɔ niabo. ");
INSERT INTO snw_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Okpeele wɔ mmle lakple aabanya Petro ninfa, ni aakple aatɔɔtɔkɔ batii ba niayila ni ninfa alɛ, “Onwii lɛma ale!” ");
INSERT INTO snw_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Kafɔɔ Petro lakple abe ɔnyasie. Ditale obe fiɛ diɛ batii ba niayila ni ninfa latɔkɔ nwɔ alɛ, “Flafuo ɔnyasie obe falɛ diele onwii lɛma fale diekye afɔɔ Galilea kasɔ feekye.” ");
INSERT INTO snw_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ninfɛ di Petro labuɛ alɛ, “Lɛka nlɛ nwaako kobuɛ! Yaa ananfi mi kootoko nse ɔlaa kɔlaa! Ninye osuɔtɔ wɔ mmle ɔlaa biobuɛ nii!” ");
INSERT INTO snw_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Nfanwu kɔɔkɔ niabo lɛnyɔɔfa, ninfɛ di Petro lanyuma mmle di Yesu latɔkɔ nwɔ alɛ, “Fiɛ di kɔɔkɔ mabo ni sɛnyɔ, fababuɛ sitiɛ falɛ faaye mi.” Obe wɔ diabudi nwɔ nii, aawi kaku. ");
INSERT INTO snw_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Dii nwu kuyitatũ Yaa olebatatɛ lakyakako okpoo banɔɔfo ku kufiofa batuotɛ kuɛ bakantɛ bamuu. Obe wɔ batoosiɛ beebu ni ɔlaa nwu disi ku mmle baabla ko nwɔ ni ɔkpɛ, baanii Yesu baakpaa nwɔ baasifiko Roma abaa ɔnɔɔfo wɔ bɔɔlɛɛ ni Pilato ɔkyɛ. ");
INSERT INTO snw_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Nfa diɛ Pilato lakaalɛ Yesu alɛ, “Afɔ ninle Yuda batii Ɔka nwu nɛ?” Ninfɛ di Yesu ladiki kanya alɛ, “Nnwu fatoobuɛ nɛ.” ");
INSERT INTO snw_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Yaa olebatatɛ nwu layɔ sɛlaa kpinwu baatika di Yesu suoto. ");
INSERT INTO snw_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Nioso Pilato lakple aakaalɛ nwɔ alɛ, “Floobuɛ ɔlaa kuonwii? Kyɔɔ atoko faanu sɛlaa se boobuɛ fɔ ni di suoto!” ");
INSERT INTO snw_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Kafɔɔ Yesu ditabɛ kanya, nioso diabla Pilato ɔkpɛ! ");
INSERT INTO snw_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Di Okpi Diisi Ofe Dii ole biala yi, Pilato ndiɛ Yuda batii leyo batentɛ lele, baatii nwu lɛkaalɛ ni anta ma. ");
INSERT INTO snw_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Di obe nwu kamɛ, baamufũ osuɔtɔ onwii bɔɔlɛɛ ni Baraba baalaatɛ leeyo ku batii nɔɔ. Ta kudu lɛma okpee ku batii olo di obe wɔ baataka baayila ni di Roma batii ɔka suoto. ");
INSERT INTO snw_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Obe wɔ baatii labasi nii, baanyumasa Pilato leyo batentɛ ba andiɛ antɔɔta ma ni obe lele di dii nwu ole kamɛ. ");
INSERT INTO snw_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ni aakaalɛ ma alɛ, “Biomiɛ bilɛ ndiɛ Yuda Batii Ɔka nwu nta ye?” ");
INSERT INTO snw_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilato lakaalɛ ma nkpo ta aatofo alɛ onunsɛɛ kanya oso di Yaa olebatatɛ nwu lakpaa Yesu baawako nwɔ. ");
INSERT INTO snw_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Kafɔɔ Yaa olebatatɛ nwu lamunikĩisa batii dikudi nwu disibu mmle diɛ Pilato kadiɛ Baraba bonwu anta ma nii. ");
INSERT INTO snw_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato lakple aakaalɛ batii dikudi nwu alɛ, “Obe biomiɛ bilɛ mbla otii wɔ biɔlɛɛ ni Yuda batii Ɔka nwu ninfũ?” ");
INSERT INTO snw_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ninfɛ baayiisa kudu baatɔkɔ nwɔ alɛ, “Pɛ nwɔ sibuɛ fakaasa koowoso suoto!” ");
INSERT INTO snw_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Kafɔɔ Pilato lakple aakaalɛ ma alɛ, “Ɔmɛnkpile ɛɛbla fiɛ?” Kafɔɔ mia nfɛ baakple baatɔɔfaa osie kanya baatoobuɛ alɛ, “Pɛ nwɔ sibuɛ fakaasa koowoso suoto!” ");
INSERT INTO snw_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ta Pilato komiɛ alɛ suoto siyɔɔ ma ni oso, aadiɛ Baraba aata ma. Ni aata baapɛ Yesu nwaa ku mpile, ni aayɔ nwɔ aakpee ma ninnɛɛ alɛ balaapɛ nwɔ sibuɛ bakaasa koowoso suoto nɛ. ");
INSERT INTO snw_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Bakpɛtɛ nwu lakpaa Yesu baasifiko Roma batii abaa banɔɔfo leyo diɛ bawo kalɛɛkɔ, ni baalɛɛ bakpɛtɛ bule alɛ bawa nɛ. ");
INSERT INTO snw_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ninfɛ baayɔ awu sɛɛle ya niefũ ni kɔya wua baakpa nwɔ fɛ ɔka, ni baabla sɛkansi lɛkakoto baatũkũsɔɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ni baayila baatookpee nwɔ sinunsɔ alɛ, “Yii yiiduu! Yuda batii Ɔka, asiɛ nkpa aklɛ!” ");
INSERT INTO snw_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Baayɔ kawesee baatɔɔpɛ nwɔ diisi, baatufa sita baakpete nwɔ di suoto. Ninfɛ baapɛ akunkyi kaatũ nɔɔ baawakosa asi kasɔ baatɔɔ. ");
INSERT INTO snw_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Obe wɔ batooloo nwɔ ni ɔma, baadiki nwɔ awu sɛɛle nwu di suoto baakplesa awu nɔɔ baakpee nwɔ. Ninfɛ baakpaa nwɔ baasifiko alɛ bɔɔlaapɛ nwɔ sibuɛ mankaasa koowoso suoto nɛ. ");
INSERT INTO snw_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Obe wɔ baatoofe nii, baakyakako osuɔtɔ onwii bɔɔlɛɛ ni Simon, aakye kakpayotũ kanwii ɔɔwa Yerusalem. Ninfɛ di bakpɛtɛ nwu nkpo layila nwɔ di suoto alɛ afũ Yesu kowoso nwu nkpo atuka nɛ. Simon nwu lakye Kireni kasɔ. Babi nɔɔ kafɔɔ niale Aleksandro ku Rufo. ");
INSERT INTO snw_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ni baakpaa Yesu baalaadu lɛba le manlɛɛ ni Golgota lɛɛsɔdiki ninle ni alɛ Otii Disi Dikufi. ");
INSERT INTO snw_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Nfa baayɔ nta be bɛɛkpɔtɔɔsa ni ku kɔfa lonle nimata alɛ ɔlɔbanu ni dibuo baatɔɔ alɛ anyi, kafɔɔ Yesu ditanyi. ");
INSERT INTO snw_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ninfɛ di bakpɛtɛ nwu nkpo lapɛ nwɔ sibuɛ baakaasa koowoso suoto nɛ. Nni kamaa, baayɔ awu nɔɔ baasɛ bawo di obe wɔ baawii ni atrebi baatofo n-ya di obiala lɛma kayɔ nii. ");
INSERT INTO snw_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Baapɛ Yesu sibuɛ baakaasa koowoso suoto ku oyita elomu ɛnaasĩ. ");
INSERT INTO snw_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Baapɛ kataaboo kakyɛɛ sibuɛ baakaasa nwɔ diɛ lɛkantosi baakpana lɛsaa le oso baalo nwɔ nii alɛ, “Nnwɔɔ ninle Yuda Batii Ɔka nɛ.” ");
INSERT INTO snw_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Baapɛ bayu banyɔ kafɔɔ sibuɛ baakaasa di awoso suoto diɛ Yesu ɔlɔɔkɔ. Onwii lakaa diɛ oletanɛɛkyɛ nɔɔ, onwii kafɔɔ lakaa diɛ ɔmɛntukyɛ. ");
INSERT INTO snw_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Diawa ninkpo fɛle mmle baakpana ni diɛ Kɔkpana Klekle Kukũ kamɛ alɛ, “Baalo nwɔ manko bakpileblatɛ.” ");
INSERT INTO snw_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Batii ba niatoofe ni ninfa bamuu latũkunsa asi, baatufa Yesu baabuɛ alɛ, “Ɛhɛɛ! Afɔ niabuɛ falɛ fababiɛ Yaa Olekatakɔ ka mmle, fanse ni letofo di ayi atiɛ kamɛ nɛ! ");
INSERT INTO snw_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Soo koowoso nwu fawa, faafũ suoto lɛfɔ nkpa buonyu!” ");
INSERT INTO snw_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","41 Nkpo okle kafɔɔ di olebatatɛ banɔɔfo ku kufiofa batuotɛ nwu nkpo lama nwɔ baatoobuɛ kaamɛ lɛma alɛ, “Aafũ batii bamba nkpa kafɔɔ oloofuo suoto nɔɔ odiki! ");
INSERT INTO snw_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Se nwɔ bɔɔlɛɛ ni Yuda Batii Ɔka, dile ni Kristo wɔ di Yaa lɛpɛ ni ɔfɔɔ ale nwaako, aasoo di kowoso suoto awa buofũ nwu bunu!” Batii ba banyɔ baakaasa ni di awoso suoto ku nnwɔɔ kafɔɔ latufa nwɔ. ");
INSERT INTO snw_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kakũ lefosi elomu ɛnyɔ lebe, kayi kamuu lawɔfɔ. Dialaase di kɔtɔɔfɔ elomu etiɛ kamɛ. ");
INSERT INTO snw_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Di kɔtɔɔfɔ elomu etiɛ kamɛ okle, Yesu lafaa osie kanya aabuɛ alɛ, “Eli, Eli, lama sabaktani?” Lɛsɔdiki ninle alɛ, “Yaa nii, Yaa nii, be oso feediɛ mi nnɛɛ nkpo?” ");
INSERT INTO snw_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Batii ba bawo niayila ni ninfa, baanu ni ɔlaa nwu nkpo labuɛ alɛ, “Bikyɔɔ atoko! Ɔɔlɛɛ Elia.” ");
INSERT INTO snw_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Nfanwu onwii kaamɛ lɛma latoso aalaayɔ oleteku aanyɔ di nta nyankale kamɛ, aayɔ aatũ di owoso suoto, aamiɛ alɛ ɔɔyɔ ankyɔɔ nwɔ annyi. Kafɔɔ batii bule labuɛ alɛ, “Bita buyila buonyu, nse Elia kamawa amadiki nwɔ di kowoso suoto!” ");
INSERT INTO snw_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesu lakple aafaa osie kanya ninfɛ aakpi nɛ. ");
INSERT INTO snw_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Nfanwu, dibula le ninsaka ni di Yaa Olekatakɔ nwu nkpo kamɛ niabɛ di akyuu anyɔ diakye di osi dialaase kaasɔ. ");
INSERT INTO snw_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Di bakpɛtɛ ɔnɔɔfo wɔ niayila ni di kowoso nwu katũ lanu mmle di Yesu lafaa fiɛ aakpi nii, ni aabuɛ alɛ, “Nwaako, Yaa Obi ninle otii wɔ mmle!” ");
INSERT INTO snw_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Basanko bawo kafɔɔ layila kaakyonkɔ baatoonyu asaa ya niatɔɔwa nii. Bawo niale Maria Magdalene ku Salome ku Maria wɔ babi ninle ni Yakobo bisɔ ku Yose. ");
INSERT INTO snw_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Di obe wɔ di Yesu lawɛ ni di Galilea kasɔ, mma niatootikanko nwɔ baatɔɔ kyakaako nwɔ nɛ. Basanko kpinwu ba latikanko nwɔ baakyɛ ni Yerusalem ke layila ninfa. ");
INSERT INTO snw_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Asaa ya mmle amuu lawa fiɛ diadu Yuda batii Lɛnyɛɛtɛyi. Nfɛ diofe ni kɔɔtɔɔfɔ, ");
INSERT INTO snw_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Yuda batii ɔnɔɔfotii onwii bɔɔlɛɛ ni Yosef eekye ni Arimatea, lakpee otu aakyɛ aalanya Roma batii ɔnɔɔfo Pilato. Yosef wɔ mmle ninle otii wɔ niatookpee ni osie diɛ Yaa sɛka kalekɔ ɔwabee nɛ. Obe wɔ aadu ni Pilato nfũ, aatikiti nwɔ lekoto alɛ atɔɔ osuku aalaayɔ Yesu kpi alaakookaa, fiɛ di Lɛnyɛɛtɛyi diwo. ");
INSERT INTO snw_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Diabla Pilato ɔkpɛ obe wɔ aanu alɛ Yesu lawolaa ni okpi nkpo. Nioso aalɛɛ bakpɛtɛ ɔnɔɔfo wɔ niayila ni kaanya ninfa aakaalɛ nwɔ aanu nkaakyonkɔse nwaa Yesu ntookpi. ");
INSERT INTO snw_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Di ɔnɔɔfo nwu latɔkɔ nwɔ alɛ kute ni nkpo, Pilato lata Yosef osuku alɛ alaayɔ kpi nwu akookaa. ");
INSERT INTO snw_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ninfɛ di Yosef lasifi aalaayɔ Yesu kpi nwu nkpo, ni aayɔ dibula fɔle le aaya ni aamiminisa nwu di suoto nɛ. Ni aayɔ aalaakookaa di ofuɔntuu kamɛ beekutu ni di kabokotee ɔlɔɔkɔ. Ninfɛ aamunusa difuɔ aatĩi ofuɔntuu nwu kanya nɛ. ");
INSERT INTO snw_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Obe nwu kamɛ, Maria Magdalene ku Maria dile ni Yosef ɔya layila baatonyu lɛba le baakookaa ni Yesu. ");
INSERT INTO snw_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Kaleesɛ dile ni Lɛnyɛɛtɛyi kɔtɔɔfɔ, Maria Magdalene ku Maria dile ni Yakobo ɔya ku Salome lakyɛ baalaaya kɔfa kɔnɔkɔnɔ alɛ babalaafifia di Yesu kpi suoto. ");
INSERT INTO snw_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Nioso kaasɛ ni Kɔsida kolesɛtũ, baataka baakyɛ di ɔkya katũ. ");
INSERT INTO snw_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Baatoofe nii baatɔɔkaalɛ bawo alɛ, “Owe bubawɛ abamunusa difuɔ le kplɛ di akya kanya anta wo?” Baakaalɛ bawo ta difuɔ nwu lamuɔ nwaa. Kafɔɔ baadu ni nfa, baanya alɛ batoomunusa difuɔ nwu beekyisa. ");
INSERT INTO snw_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Nioso baabuo ni di ɔkya nwu kamɛ, baanya alɛ okosopo onwii nsi diɛ oletanɛɛkyɛ. Aaklee abula fututu! Ɔfɔɔ lasifi ma. ");
INSERT INTO snw_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ninfɛ di okosopo nwu latɔkɔ ma alɛ, “Bitanyɛkɛ. N-ye nlɛ Yesu Nasaret Otii wɔ baakasa ni koowoso suoto biowolaa. Anaa ninfũ! Atɔɔtaka, akpe nkpa! Binyu! Nnya nfũ baatɛ nwɔ ni. ");
INSERT INTO snw_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Nioso bitɔɔkyɛ biɛlaa tɔkɔ basaateketetɛ nɔɔ ku Petro bilɛ, ‘Yesu ntoole ye katũ oofe Galilea kasɔ. Nfa bibanyɔɔ nɛ, fɛ mmle aatɔkɔ ye aatɛ nii.’ ” ");
INSERT INTO snw_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Diabla basanko ba ɔkpɛ, ni baakyɛ di ɔkya nwu katũ ku lɛyɛkɛ baatoso baasifi nɛ. Baakyɛ di osuku baatoosifi nii, batatɔkɔ otii ɔlaa kuonwii, ta lɛyɛkɛ lamufũ ma ni oso. ");
INSERT INTO snw_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Obe wɔ di Yesu lataka aakye ni baakpi kamɛ di Kɔsida kolesɛtũ, Maria Magdalene aaka suoto odiki otuo, nwɔ kamɛ aatososa ni anwuna kpile akuɛnsĩ di obe onwii kamɛ. ");
INSERT INTO snw_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Aakyɛ aalaatɔkɔ Yesu batikakotɛ nɔɔ alɛ, Yesu ntɔɔtaka di obe wɔ basi boowi kaku ta kukpi nɔɔ oso. ");
INSERT INTO snw_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Obe wɔ di Maria latɔkɔ ma alɛ, Yesu ntɔɔtaka akpe nkpa ni ɛɛnyɔɔ nii, batafũ nwɔ baanu. ");
INSERT INTO snw_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Nni sɛmaa, Yesu ladiki suoto aatuo basaateketetɛ nɔɔ banyɔ, obe wɔ baakye Yerusalem boofe ni sekpoo nwu. Batatofo nwɔ di kasɔ kakyekɔ. ");
INSERT INTO snw_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Kafɔɔ sɛmaa baabatofo nii, baakple baasifi baalaatɔkɔ babule. Kafɔɔ batafũ ma baanu. ");
INSERT INTO snw_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Lɛyɛntɛle, Yesu ladiki suoto aatuo basaateketetɛ nɔɔ lefosi onwii di obe wɔ basi boole ni alesaa. Aananfiko ma ɔlaa ta banaa ni ofũ onu oso, bakpe kafɔɔ otokopĩ kpã ta batafũ batii ba nianyɔɔ nii baanu di obe wɔ atɔɔtaka, akpe ni nkpa. ");
INSERT INTO snw_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ni aatɔkɔ ma alɛ, “Bitɔɔkyɛ kayi kamuu biɛlaayie Yaa ɔlaa biene nwu lɛkya diɛ batii bamuu kamɛ. ");
INSERT INTO snw_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Otii wɔ nimafũ ɔlaa biene nwu annu nii, eefũ ni Yaa ntu okpeesa, Yaa madiki nwɔ di sikpile letokonanfi kamɛ. Otii wɔ kafɔɔ ninaanfũ anu nii, Yaa malo nwɔ lɛpɔɔ. ");
INSERT INTO snw_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Yaa mata bafũbanutɛ osie mambla ablasaa ya niɛbla ni ɔkpɛ kpinwu. Babatososa anwuna kpile di leyooto nɔɔ kanya. Bababuɛ sele ate ate. ");
INSERT INTO snw_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Se beemufũ asaanwu ee beenyi kɔfa kpile, dilababla ma lɛsalɛsaa. Se beetika nnɛɛ lɛma di bafiɛtɛ suoto, babawɛ osie.” ");
INSERT INTO snw_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Di Saate Yesu lakakatɛ aata basaateketetɛ nɔɔ aaloo ni sɛmaa, Yaa lakpaa nwɔ aasifiko osi, ni aasiɛ di oletanɛɛkyɛ nɔɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Batikankotɛ nɔɔ kafɔɔ lakyi kakɔ biala baabuɛ ɔlaa biene nwu. Saate lɛma lasiɛ ma kaamɛ aadiki atuo alɛ ɔlaa nɔɔ nwu ɔlaa biene kule di ablasaa ate ate ya baatɔɔbla ni di otumi nɔɔ kanya.");
INSERT INTO snw_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Obiloo Tiofilo, batii kpinwu lekpee ɔnyɛɛ bɛɛbla mmle baafuo nii, bɛɛkpana lɛsaa biala niawa ni kaamɛ loo bɛɛtɛ. ");
INSERT INTO snw_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Baakpana nya baatɛ fɛ mmle baatii ba nianya ni asaa ya mmle ku anu lɛma kaasɔ kakyekɔ latɔkɔ wo nii, ku mba kafɔɔ nia buɛ nwu nii. ");
INSERT INTO snw_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nkpo oso, bienetɛ Tiofilo, ta nntoobuo di asaa ya mmle kamɛ nwaa lɛnyu ni diɛyɔ ni kaasɔ kakyekɔ oso, ntɔɔbla disibu nlɛ, dilɛ alɛ kakpana nya fɛ mmle diawa ni klekle nta fɔ. ");
INSERT INTO snw_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Kɔbla nle mmle ta mmle faatofo ni onukware omuu wɔ ninsi ni di asaa ya baatootuo fɔ ni suoto. ");
INSERT INTO snw_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Di obe wɔ kamɛ di Herode latoole ni sɛka di Yudea kasɔ suoto, Yaa oletatɛ onwii lawɛ baatɔɔlɛɛ nwɔ ni Sakaria. Aakye olebatatɛ dikudi le manlɛɛ ni Abia kamɛ. Sakaria wɔ mmle ɔsɔfɔ baatɔɔlɛɛ Elisabet nɛ. Nnwɔɔ kafɔɔ aakye Yaa oletatɛ wɔ baatɔɔlɛɛ ni Aaron kafaabi kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ɔsa ku ɔsɔfɔ wɔ mmle, baasiɛ nkpa biene di Yaa anu. Baale kafɔɔ Saate afiofa nwu amuu, baakyɛ di sisuku nɔɔ suoto. ");
INSERT INTO snw_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Batii ba mmle ditawɛ obi kuonwii, diekye Elisabet ɔlɛma aale. Banyɔ lɛma kafɔɔ batoobe beefũ alɛɛ kpinwu. ");
INSERT INTO snw_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Dii ninwii, Sakaria latɔɔbla ɔkpɛ nɔɔ fɛ oletatɛ di Yuda batii Olekatakɔ, diekye dikudi lɛma suoto nfɛ diadu. ");
INSERT INTO snw_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Diekye, di olebatatɛ ɔsaabla kanya, baawii atrebi baadiki Sakaria alɛ akyɛ Yaa Olekatakɔ aalaafiɛ odufii di Yaa oleɔta akyikye suoto. ");
INSERT INTO snw_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Obe wɔ aawɛ ni ninfa aatoofiɛ ni odufii nwu, batii dikudi bule kafɔɔ lawɛ kaayi baatɔɔpɛ ɔlaa baatɔɔta Yaa. ");
INSERT INTO snw_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ninfɛ di Yaa tɔkyɛntɛ onwii lakyɔɔ di oleɔta akyikye oletanɛɛkyɛ, aadiki suoto aatuo nwɔ di obe wɔ ayɛ ofiɛ ni olufii nwu. ");
INSERT INTO snw_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Di Sakaria lanyɔɔ nii, aabla tro, lɛyɛkɛ lapɛ nwɔ osie kanya. ");
INSERT INTO snw_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Kafɔɔ Yaa tɔkyɛntɛ nwu latɔkɔ nwɔ alɛ, “Sakaria, tanyɛkɛ! Yaa ntoonu fɔ ɔlaa ɔpɛ, ɔsɔfɔ lɛfɔ Elisabet malofo obi suɔtɔbi anta fɔ. Faatika nwɔ leyooto falɛ Yohane. ");
INSERT INTO snw_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Suoto mayɔɔ fɔ osie kanya se beelofo nwɔ. Nkpo okle kafɔɔ di suoto mayɔɔ batii kpinwu nɛ. ");
INSERT INTO snw_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Aba le otii finle di Yaa anu. Atannyi wanyi ee nta siene kunwii. Ni dibayɔ ni di olofobee nɔɔ, Ninwuna Klekle mayii nwɔ kamɛ pɔ. ");
INSERT INTO snw_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Nnwɔɔ nimakplesa Israel batii kpinwu anwako Saate Yaa lɛma nfũ nɛ. ");
INSERT INTO snw_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Abale Saate katũ anwa di osie ku sɛkambi kamɛ fɛ mmle di Yaa Ɔlaa Buɛtɛtɛ Elia late nii. Di lɛwa nɔɔ kamɛ abalolaa babi ku bate ntɛɛ. Abata batokopĩtɛ disibu nkyi mambu disi fɛ batii klekle. Abalolaa kafɔɔ Saate batii nɔɔ mansiɛ mansoko nwɔ.” ");
INSERT INTO snw_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ninfɛ di Sakaria lakaalɛ Yaa tɔkyɛntɛ nwu alɛ, “Be nimata nfũ ɔlaa wɔ mmle nnu? Diekye ntoobe kofokofoko, ɔsɔfɔ nii kafɔɔ ntoobe laakpa nwu.” ");
INSERT INTO snw_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ninfɛ di Yaa tɔkyɛntɛ nwu latɔkɔ nwɔ alɛ, “Ami ninle Gabriel wɔ ninyila ni di Yaa anu nɛ. Nnwɔɔ niekpee mi alɛ, matɔkɔ fɔ ɔlaa biene wɔ mmle nɛ. ");
INSERT INTO snw_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Kafɔɔ faafũ mi ɔlaa wɔ mmle nimawa ni kaanya di obe biene kamɛ fanu. Ta nkpo oso fabakple omumu flabasinfuo ɔkakatɛ, diɛlase di obe wɔ kamɛ di ɔlaa wɔ mmle kɔtɔkɔ fɔ ni lɛwa ni kaanya.” ");
INSERT INTO snw_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Di obe wɔ kamɛ diɛ asaa ya mmle amuu latɔwa nii, diabla batii ba niayila ni kaayi baasoko ni Sakaria ɔkpɛ. Diekye batatofo lɛsaa le oso aatɔɔklɛ ni di Yaa Olekatakɔ nwu nkpo. ");
INSERT INTO snw_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Obe wɔ nfɛ di Sakaria ladie ni di Yaa Olekatakɔ nwu, atafuo ma ɔkakatɛko. Nioso nnɛɛ nfɛ aatoowiwii aayɔ aatɔɔkakatɛko ma. Nioso batatofo alɛ, odiki otuo aanya. ");
INSERT INTO snw_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Obe wɔ di Sakaria ɔkpɛ ɔbla ntooloo ni di Yaa Olekatakɔ nwu, aadie ninfa aasifi leyo. ");
INSERT INTO snw_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ni di obe owo kamɛ, ɔsɔfɔ nɔɔ Elisabet labalaka lɛmɛ, aawofasa suoto awɛntɛ anɔɔ amu, atadie kayi. ");
INSERT INTO snw_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ninfɛ di Elisabet labuɛ alɛ, “Nunua, Yaa ntoole mi sibualɛ, atootekete mi sinunsɔ di suoto di batii anu.” ");
INSERT INTO snw_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Di awɛntɛ akuɔ kamɛ nfɛ di Elisabet nlaka ni lɛmɛ, Yaa lakpee tɔkyɛntɛ nɔɔ Gabriel alɛ akyɛ okpoo wɔ bɔɔlɛɛ ni Nasaret, di Galilea kasɔ suoto. ");
INSERT INTO snw_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Yaa tɔkyɛntɛ wɔ mmle layɔ kanya aakyɛnko kakpeelebitɛ ka baakaalɛ baata ni osuɔtɔ wɔ baatɔɔlɛɛ ni Yosef, aakye ni ɔka Dawid kɔna kamɛ. Kakpeelebitɛ nwu leyooto niale Maria nɛ. ");
INSERT INTO snw_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Yaa tɔkyɛntɛ nwu lawa Maria nfũ aabatɔkɔ nwɔ alɛ, “Kɔsɛɛsa fɔ! Saate nwu nsiko fɔ, eekusɛkusɛsa fɔ kafɔɔ.” ");
INSERT INTO snw_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Yaa tɔkyɛntɛ wɔ mmle ɔlaa wɔ aatɔkɔ ni Maria latɔɔ disibu, diekye atanu ɔlaa nwu kasɔ. ");
INSERT INTO snw_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ninfɛ di Yaa tɔkyɛntɛ latɔkɔ nwɔ alɛ, “Maria, tanyɛkɛ, diekye Yaa ntoole fɔ sibualɛ. ");
INSERT INTO snw_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Fabalaka lɛmɛ, fanlofo obi suɔtɔbi, fantika nwɔ leyooto falɛ Yesu. ");
INSERT INTO snw_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Abale otii kplɛ, babalɛɛ nwɔ alɛ Yaa wɔ ninlenke ni petee Obi. Saate nɔɔ Yaa mase nwɔ sɛka fɛ mmle aase ni ɔwa nɔɔ Dawid. ");
INSERT INTO snw_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Abale sɛka di Yakob kɔna kamɛ obe lele. Diidii sɛka kalekɔ nɔɔ nnaa kaloo.” ");
INSERT INTO snw_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Nfa nfɛ di Maria lakaalɛ Yaa tɔkyɛntɛ nwu alɛ, “Lɛ nfɛ di nle mmle mawa kaanya, ninanye ni osuɔtɔ?” ");
INSERT INTO snw_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Nfa nfɛ di Yaa tɔkyɛntɛ nwu ladiki kanya alɛ, “Ninwuna Klekle mawafɔ di suoto, Yaa wɔ ninlenke ni osie kafɔɔ matikafɔ di suoto. Ta nkpo oso Obi Klekle nwu fɔɔwa ni ɔbalofo, baalɛɛ nwɔ alɛ, Yaa omu Obi. ");
INSERT INTO snw_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Nunua, komiɛ nlɛ fatofo falɛ, leyo lee kamɛ ɔsanko wɔ ninle ni Elisabet bɔɔlɛɛ ni ɔlɛma, nfɛ alaka lɛmɛ, nu atoobe nkpo. Kɔwɛntɛ kuɔnle nɔɔ nfɛ asi ni nɛ. ");
INSERT INTO snw_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Diekye lɛsalɛsaa nnaa Yaa osie ku ɔbla.” ");
INSERT INTO snw_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ninfɛ di Maria latɔkɔ nwɔ alɛ, “Nyu lo, Saate kpɛmblatɛ nle. Abla aatɛɛ fɛ mmle okle feebuɛ ni.” Ninfɛ di Yaa tɔkyɛntɛ nwu lasifi aadiɛ nwɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Di ayi nwu kamɛ Maria lataka aapɛsɛwa aalolaa suoto, aakyɛ okpoo onwii di Yudea kasɔ di kabokoee suoto, aalaabuo Sakaria leyo, aasɛɛsa Elisabet. ");
INSERT INTO snw_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Diawa alɛ obe wɔ di Elisabet lanu ni Maria lɛsɛɛsa, obi wɔ ninsi nwɔ ni kaafutu kamɛ lakpɛ. Nfanwu Ninwuna Klekle niayii Elisabet kamɛ pɔ. ");
INSERT INTO snw_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ninfɛ aakakatɛ aabuɛ osie kanya alɛ, “Beekusɛkusɛsa fɔ di basanko bamuu kamɛ, beekusɛkusɛsa kafutu lɛfɔ kamɛ obi kafɔɔ! ");
INSERT INTO snw_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Sɛmɛmbualɛ ninle nse, alɛ, Saate nii ɔya kawa amasɛɛsɛɛ? ");
INSERT INTO snw_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Di obe wɔ kamɛ fɛɛkyako mi ni ɔsɛɛsa, nfanwu obi wɔ ninsi mi ni kaafutu kamɛ niɛkyako ɔkpɛ ku suoto lɛyɔɔ. ");
INSERT INTO snw_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Suoto siyɔɔ fɔ osie kanya, diekye feefũ feenu falɛ ɔlaa wɔ di Yaa lɛkakatɛ eekyeko ni suoto lɛfɔ mawa kaanya.” ");
INSERT INTO snw_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria lataka aabuɛ alɛ, “Otu nii kɔtansa Saate nwu. ");
INSERT INTO snw_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Suoto kɔyɔɔ ninwuna nii di Yaa wɔ ninle mi ni Dikitɛ suoto, ");
INSERT INTO snw_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","diekye eenyuma mi, ami wɔ ninle nwɔ ni kpɛmblatɛ ninandie ni lɛsalɛsaa. Nioso diɛyɔ ni di nua diesifi nii, ana ya nikɔwa ni sɛɛmaa, mawa mamalɛɛ mi suoto lɛyɔɔ otii, ");
INSERT INTO snw_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Diekye di lɛsaa le di Yaa wɔ ninklenke nii, lɛbla ɛɛtɛɛ ni oso. Leyooto nɔɔ ninle klekle nɛ. ");
INSERT INTO snw_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nyaami nɔɔ ɔnya nte diɛta mba ninyɛkɛ nwɔ nii, diɛyɔ ni kɔɔna diesfi ni kɔɔna, ");
INSERT INTO snw_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Eediki osie nɔɔ kayi, ɛɛsamiisa batii ba nintakatɛsa ni suoto lɛma katoo ku disibu lɛma nimuu, ");
INSERT INTO snw_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ɛɛtakatɛsa baka siene laakpomii lɛma suoto, ni ɛɛtakatɛsa mba niɛwakosa ni suoto lɛma kasɔ katoo nɛ. ");
INSERT INTO snw_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ɛɛta batii ba di aka nkle ni lele alesaa biene beemiɛ, kafɔɔ ɛɛta basaawɛntɛ lesifi ku kɔka. ");
INSERT INTO snw_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Eenyuma ntam nɔɔ be aaka aata ni bawa loo, ni atɔɔwa alɛ ɔɔbadiki bakpɛmblatɛ nɔɔ Israel nɛ. ");
INSERT INTO snw_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Atoonyuma alɛ ootuo nyaami nɔɔ ɔnya di Abraham suoto ku banantii nɔɔ diesifi ni, dinnaa ni kaloo.” ");
INSERT INTO snw_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria lasiɛ di Elisabet nfũ fɛ awɛntɛ atiɛ fiɛ aakple aasifi leyo nɔɔ. ");
INSERT INTO snw_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Di obe lawo alɛ Elisabet kalofo nii, ni aalofo obi suɔtɔbi nɛ. ");
INSERT INTO snw_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ni di Elisabet bawo nɔɔ ku banatii nɔɔ lanu mmle okle di Yaa lele nwɔ ni sibualɛ, ni baamuu lɛma lanyako nwɔ suoto lɛyɔɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Obe wɔ di obi nwu nkpo lafũ ni ayi anɛ, baawa alɛ bɔɔbabudi nwɔ lɛsɔkɔsɔkɔ, ni baamiɛ alɛ bɔɔyɔ ote Sakaria leyooto mantika nwɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Kafɔɔ ɔya ditatunako ma, ni aatɔkɔ ma alɛ, “Batika nwɔ leyooto bilɛ, Yohane.” ");
INSERT INTO snw_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ninfɛ baananfiko nwɔ ɔlaa baakaalɛ nwɔ alɛ, “Ɔnantii lee kuonwii diloole leyooto le mmle okle fiɛ de?” ");
INSERT INTO snw_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Nioso, baawiwii nnɛɛ baakaalɛ obisɔ nwu ote alɛ, lɛmɛnyooto omiɛ alɛ bayɔ batika obi nɔɔ nwu. ");
INSERT INTO snw_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ninfɛ di Sakaria lakaalɛ alɛ batɔɔ lɛkpanafuɔ, ni aakpana aatika alɛ, “Leyooto nɔɔ ninle Yohane.” Diabla bamuu lɛma ɔkpɛ osie kanya. ");
INSERT INTO snw_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Nfanwu, Sakaria lakple aakyako ɔkakatɛ, ni aakyako Yaa ɔtansa nɛ. ");
INSERT INTO snw_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Lɛyɛkɛ lapɛ manko mba ninsi bakaako ni bawo. Batii labuɛ ɔlaa wɔ mmle baakyakasa sekpoo se simuu ninkpe ni di Yudea kobokotee kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Batii ba bamu nianu ni sɛlaa se mmle latoobu diisi baatɔɔkaalɛ alɛ, “Ɔmɛntiikle di obisɔ wɔ mmle kɔwa ɔbale?” Diekye diakpa kɔmɛ alɛ, Yaa otumi ntika nwɔ di suoto. ");
INSERT INTO snw_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Diawa alɛ Yaa Ninwuna Klekle layii Yohane ote Sakaria kamɛ, ni aabuɛ Yaa ɔlaa alɛ, ");
INSERT INTO snw_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Bita butansa Saate, Israel Yaa nwu diekye atɔɔwa kale nɔɔ ɔkyakaako, ɛɛwa ma kafɔɔ odiki. ");
INSERT INTO snw_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Atɔɔta wo Dikitɛ wɔ ninkpe ni osie nwɔ niekye ni kpɛmblatɛ nɔɔ Dawid kɔna kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Yaa labuɛ ɔlaa wɔ mmle aatɛ kofokofoko diefe ni di ɔlaa babuɛtɛtɛ nɔɔ suoto alɛ, ");
INSERT INTO snw_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","abadiki wo ankyeko bakpileblatɛ ku batii ba niekyidi wo ni bamuu nnɛɛ kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Aabuɛ alɛ abanya bawa loo nyaami abanyuma kafɔɔ kanya ninii klekle le aanii ni ku mma. ");
INSERT INTO snw_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Aaka ntam aata ɔwa loo Abram osie kanya alɛ, ");
INSERT INTO snw_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","abadiki wo ankyeko bakyiditɛ loo nnɛɛ kamɛ, abata mambla nwɔ ɔkpɛ kafɔɔ di ɔtanyɛkɛ kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Alɛ ababla wo klekle, munte tinini di anu nɔɔ di nkpa loo mmuu disiɛbi kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Kafɔɔ, afɔ obi nii, babalɛɛfɔ alɛ Yaa wɔ ninlenke ni ɔlaa buɛtɛtɛ. Fabale Saate nwu katũ, fanlolaa osuku fantɛ fanta ɔwabee nɔɔ. ");
INSERT INTO snw_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Fabata batii nɔɔ kafɔɔ ntofo alɛ babawɛ didiki, ku sikpile lɛma se babayɔ mankyɛ ma ni oso. ");
INSERT INTO snw_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Yaa loo lɛyɔɔ buɛɛ, annya nyaami. Abakyesee wo dikitɛ wɔ ninkpa ni fɛ mmle kuufĩ nkpa nii. ");
INSERT INTO snw_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Abata lɛkpa le mmle nwa di batii ba ninsi ni di ditunu kamɛ di kukpi lɛyɛkɛ nkle ma nii alɛ, abakpaa wo anfenko di atoko ɔkyɛ ole osuku suoto.” ");
INSERT INTO snw_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Nioso obisɔ nwu lamuɔ di suoto sina kamɛ ku Yaa Ninwuna kamɛ osie kanya. Aasiɛ di ɔfaafuu di lɛba le baatii diesi ni diaalase di obe wɔ aadiki ni suoto kayi di Israel kafaabi anu. ");
INSERT INTO snw_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Di obe nwu kamɛ, Ɔka Kplɛ Kaesare Augusto lata otumi alɛ baka batii bamuu ba ninkpe ni di Roma sɛka kalekɔ kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Di batii ɔka kasale wɔ mmle kamɛ, abaa ɔnɔɔfo wɔ baatɔɔlɛɛ ni Kirenio niatoole sɛka di Siria kasɔ suoto. ");
INSERT INTO snw_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Nkpo oso otii biala lasifi okpoo nɔɔ alɛ balaaka nwɔ. ");
INSERT INTO snw_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Nioso Yosef kafɔɔ ladie di Nasaret okpoo di Galilea kasɔ aasifi Betlehem di Yudea kasɔ suoto, nfũ baalofo ni ɔka Dawid. Yosef lasifi nfa diekye Dawid ɔnantii aale. ");
INSERT INTO snw_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Manko Maria wɔ baakaalɛ baatɔɔ ni niasifi nfa alɛ balaaka ma. Aalaka lɛmɛ kafɔɔ. ");
INSERT INTO snw_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Obe wɔ baawɛ ni di Betlehem, Maria obe lawo alɛ aalofo. ");
INSERT INTO snw_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ni aalofo obi suɔtɔbi nɔɔ kasale nɛ. Ni aayɔ sikplakpi aamiminisa nwɔ, aayɔ nwɔ aatensa di lɛsaa le mankpee ni babɔkɛɛ alesaa kamɛ nɛ. Diekye batawɛ leyo di bafɔɔ kafunkɔ. ");
INSERT INTO snw_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Diawa alɛ bafoso bakpatɛ banwii lawɛ nintɛɛ nwu kasɔ suoto, baatoonyu bafoso lɛma ku kakyɛ. ");
INSERT INTO snw_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Yaa tɔkyɛntɛ onwii ladiki suoto aatuo ma, ni di Saate leklekle lakpa diakpete ma di suoto nɛ. Ta nkpo oso baayɛkɛ osie kanya, ");
INSERT INTO snw_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","kafɔɔ Yaa tɔkyɛntɛ nwu latɔkɔ ma alɛ, “Bitanyɛkɛ, ɔlaa biene nkyɛnko, nwɔ nimata ye ni suoto lɛyɔɔ osie kanya ku batii bamuu. ");
INSERT INTO snw_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Di miɛ dii le mmle suoto, batoolofo Saate wɔ ninle ni Kristo bɛɛtaye di ɔka Dawid okpoo kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Lɛsaa le bibanya mintɛ ni nsũ, diotuo alɛ kute ni nkpo ninle alɛ, bibanya beemiminisa obifɔɔle nwu ku sikplakpi, bɛɛyɔ nwɔ beetensa di bafoso lɛsaa le manle ni alesaa kamɛ.” ");
INSERT INTO snw_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Nfanwu, Yaa batɔkyɛntɛ dikudi kplɛ ninwii niakye osi baakyɔɔ babakyakaa di nwɔ nkpo suoto baatɔɔtansa Yaa alɛ, ");
INSERT INTO snw_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Leklekle baata Yaa di osi fanfan, di suoto lɛyɔɔ diwa di batii ba suoto di Yaa mbɔmbɔ ni kaayi!” ");
INSERT INTO snw_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Di obe wɔ di Yaa batɔkyɛntɛ nwu lakple baasifi ni osi baadiɛ ma ni, bafoso bakpatɛ nwu labuɛ baatɔkɔ suoto lɛma alɛ, “Bita bukyɛ Betlehem buɔlaanyu lɛsaa le niɛwa ni, di Saate nwu ntɔɔtɔkɔ wo ni.” ");
INSERT INTO snw_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Nioso baapɛsɛwa baakyɛ baalanya Maria ku Yosef ku obifɔɔle nwu niate ni di babɔkɛɛ alesaa lekpeesaa nwu kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nioso obe wɔ baanyɔɔ ni nkpo, baabuɛ lɛsaa biala di Yaa tɔkyɛntɛ nwu latɔkɔ ma aakyeko ni obisɔ nwu suoto. ");
INSERT INTO snw_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Batii ba bamuu nianu ni bafoso bakpatɛ ba mmle ɔlaa wɔ baabuɛ nii, diabla ma ɔkpɛ. ");
INSERT INTO snw_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maria lamufũ sɛlaa se mmle simuu aakpee diisi, aatoobusĩ disi osie kanya. ");
INSERT INTO snw_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ninfɛ baafoso bakpatɛ ba mmle lakple baasifi, ni baatɔɔtansa Yaa di asaa ya amuu baanu, baanya ni suoto nɛ. Diekye diawa kaanya tutuutu fɛ mmle di Yaa tɔkyɛntɛ nwu latɔkɔ ma nii. ");
INSERT INTO snw_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Di ayi anɛ kamaa, obe wɔ di obe lawo alɛ baabudi ni obisɔ nwu lɛsɔkɔsɔkɔ, ni baatika nwɔ leyooto alɛ Yesu, fɛ mmle di Yaa tɔkyɛntɛ nwu labuɛ aatɛ ni fiɛ baalaka nwɔ ni lɛmɛ. ");
INSERT INTO snw_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Obe wɔ di obe lawo alɛ Yosef ku Maria kabla suoto okleklesa amanle fɛ mmle di Mose kufiofa letuo nii. Ni baakpaa obifɔɔle nwu nkpo kafɔɔ baasifiko Yerusalem alɛ, bɔɔyɔ nwɔ manakpee di Saate nnɛɛ kamɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Fɛ mmle bɛɛkpana beekpee ni di Yaa kufiofa kukũ kamɛ alɛ, “Obi suɔtɔbi kasale lele beelofo, baadiki nwɔ lete base bata Saate nwu.” ");
INSERT INTO snw_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Nioso baakyɛ alɛ bɔɔlaayɔ Abronuma anyɔ ee alaapɔɔ anyɔ manta Yaa ole, fɛ mmle di Saate nwu kufiofa lebuɛ nii. ");
INSERT INTO snw_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Di obe nwu nkpo kamɛ, osuɔtɔ onwii baatɔɔlɛɛ ni Simeon lawɛ di Yerusalem. Aale otii biene wɔ ninyɛkɛ ni Yaa, aasiɛ aatoonyu osuku aatɔɔta Israel didiki. Yaa Ninwuna Klekle lasiɛko nwɔ, ");
INSERT INTO snw_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ni diatɔɔ aatoofo alɛ ɔlabakpi, diediki diɛlase di obe wɔ atɔɔnya ni Saate Dikitɛ nwu baabuɛ alɛ babalofo nii. ");
INSERT INTO snw_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Yaa Ninwuna Klekle lakpaa Simeon diasifiko Yuda batii Yaa Olekatakɔ nwu. Obe wɔ baalofotɛ ba mmle lakpaa obifɔɔle nwu baawako alɛ bɔɔbla fɛ mmle kuufiofa nwu lebuiɛ ni mantɔɔ nii, ");
INSERT INTO snw_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ninfɛ di Simeon lafũ obifɔɔle nwu aaklee ninnɛɛ, ni aapɛ Yaa sɛfa alɛ, ");
INSERT INTO snw_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Saate, nunua, fatɔɔnya fɛɛbla di ntam be faaka ni kanya oso, diki ami, kpɛmblatɛ lɛfɔ, osuku aatɔɔkyɛ di atoko ɔkyɛ ole kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ami omu, ntoodiki anu nii lɛnya Dikitɛ lɛfɔ nwu, ");
INSERT INTO snw_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","nwɔ fɛɛta falɛ awa ni di nnle batii anu. ");
INSERT INTO snw_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Nnwɔɔ ninle lɛkpa le nimadiki dibiesaa lɛfɔ kayi anta ni batii ba ninanle ni Yuda batii nɛ. Annanfi dibu kafɔɔ anwako ni Israel batii lɛfɔ kale kamɛ nɛ.” ");
INSERT INTO snw_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Sɛlaa se di Simeon labuɛ ni di obifɔɔle nwu suoto labla Yosef ku Maria ɔkpɛ. ");
INSERT INTO snw_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ni di Simeon lakusɛkusɛsa ma, aatɔkɔ ɔya Maria alɛ, “Obisɔ wɔ mmle Yaa niekyesee nwɔ ale didiki ku kawɔɔ ɛɛta batii kpinwu di Israel. Ale nsũ be niekye ni Yaa nfũ baatii kpinwu mataka manyila nwɔ ni di suoto. ");
INSERT INTO snw_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Alɛ abadiki batii disi kamɛ sɛwofalaa kayi antuo. Afɔ kafɔɔ, diefe ni di nle mmle kamɛ oso, fabanu otu kamɛ dibuo fɛ kapamii kobe piɔ̃piɔ̃ bakle bootofo fɔ di otu kamɛ.” ");
INSERT INTO snw_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Ɔsanko onwii lawɛ aale ni Yaa ɔlaa buɛtɛtɛ, nnwɔɔ baatɔɔlɛɛ Hana nɛ. Ɔsanko nwu ote niale Fanuel, aakye Aser kafaabi kamɛ. Alɛɛ akuɛnsĩ ko manko ɔsa baayɔ bawo fiɛ aakpi aadiɛ nwɔ. Ni kamaa aale kpisɔfɔ alɛɛ afosi anɛ alɛɛ ana. Obe lele ankyɛ Yuda batii Yaa Olekatakɔ kakũ ku kakyɛ anaatɔɔtansa Yaa, annii kanya, antɔɔpɛ ɔlaa antɔɔta Yaa. ");
INSERT INTO snw_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Di obe nwu kamɛ tutuutu, nnwɔɔ kafɔɔ aawa aabapɛ Yaa sɛfa, ni aakakatɛ aakyeko obisɔ nwu nkpo suoto aata batii ba bamuu ninsi boonyu osuku manta ni Yerusalem didiki nɛ. ");
INSERT INTO snw_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Di obe wɔ di Yosef ku Maria ntooloo ni amanle nwu ɔbla fɛ mmle di Yaa kufiofa kukũ letuo nii, baakple baasifi okpoo lɛma di Nasaret, di Galilea kasɔ suoto. ");
INSERT INTO snw_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Obisɔ nwu lamuɔ, aawɛ suoto osie, aawɛ kafɔɔ ninumbe osie kanya. Yaa sibualɛ latika nwɔ di suoto. ");
INSERT INTO snw_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Lɛlɛɛ biala, Yesu balofotɛ nkyɛ Yerusalem manaale dii le manlɛɛ ni alɛ, Okpi Diisi Ofe Dii. ");
INSERT INTO snw_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Nioso obe wɔ di Yesu lafũ ni lefosi alɛɛ anyɔ baakpaa nwɔ baakyɛ dii nwu kalekɔ di Yerusalem, fɛ mmle mambla ni saa. ");
INSERT INTO snw_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Di obe wɔ batooloo ni dii nwu nkpo ole, baakple baatoosifi okpoo lɛma, kafɔɔ Yesu lakple aasiɛ di Yerusalem. Balofotɛ nɔɔ ditatofo. ");
INSERT INTO snw_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Baanyu alɛ asi baatii nwu kamɛ, nkpo oso baakyɛ dii kufĩ osuku fiɛ baakyako nwɔ owolaa di basiɛwo nɔɔ ku batii nɔɔ kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Obe wɔ batanyɔɔ nii, baakple baasifi Yerusalem baalaatoowolaa nwɔ. ");
INSERT INTO snw_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Di dii tiɛfa kamɛ, ni baakyɛ baalaanyɔɔ di Yuda batii Yaa Olekatakɔ nɛ. Aasiɛ ku Yuda batii basaatuotɛ bawo aatoonu ma, nnwɔɔ kafɔɔ aatɔɔkaalɛ ma sɛlaa. ");
INSERT INTO snw_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Batii ba bamuu nianu nwɔ ni sɛlaa, diabla ma kpo, diekye di lɛɛsɔnu kplɛ le aayɔ aatoodiki ni sɛlaa se baatɔɔkaalɛ nwɔ ni kasɔ oso. ");
INSERT INTO snw_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Obe wɔ di Yesu balofotɛ lanyɔɔ nii, diabla ma yaaa. Ni di ɔya lakaalɛ nwɔ alɛ, “Obi, obe oso fɛɛbla wo nkpo? Ami ku Teefɔ ditɔɔbla wo ninunsɛɛ buokyi munwolaa fɔ.” ");
INSERT INTO snw_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ninfɛ di Yesu ladiki kanya alɛ, “Be oso biokyi minwolaa mi? Bieye bilɛ Teemi leyo dikpe ni lesiɛ?” ");
INSERT INTO snw_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Kafɔɔ batanu ɔlaa wɔ aatɔkɔ ma ni kasɔ. ");
INSERT INTO snw_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ninfɛ di Yesu latikanko ma baasifi Nasaret nɛ. Aawakosa suoto kasɔ aata ma. Ɔya lamufũ sɛlaa se mmle aakpee diisi aatoobu sĩ disi osie kanya. ");
INSERT INTO snw_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu lalolaa aamuɔ aawɛ suoto osie. Aawɛ kafɔɔ ninumbe. Aabuo batii ku Yaa anu osie kanya. ");
INSERT INTO snw_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Di lefosi alɛɛ anɔɔ ya kamɛ di ɔka nɔɔfo Kaesare Tiberio latoole ni sɛka, Yaa ɔlaa buɛtɛ Yohane wɔ ninle ni Sakaria obi lafũ ɔlaa aakyeko Yaa nfũ di obe wɔ aasiɛ ni di ɔfaafuu kamɛ. Ni di Pontio Pilato lale Abaa ɔnɔɔfo di Yudea kasɔ suoto nɛ. Herode kafɔɔ latoole sɛka di Galilea kasɔ suoto. Di obe nwu kamɛ tutuutu, Herode obilɛma Filipo kafɔɔ latoole sɛka di kasɔ ka bɔɔlɛɛ ni Iturea ku Trakoniti ntɛɛ nwu suoto. Ni di ɔka Lisania kafɔɔ latoole sɛka di Abilene kasɔ suoto nɛ. Di obe wɔ mmle kamɛ kafɔɔ, ni di Hana ku Kaiafa lale Yaa olebatatɛ banɔɔfo nɛ. ");
INSERT INTO snw_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ninfɛ di Yohane lakyɛ aakyi Yordan okle sɛmaa ku ntɛɛ nwu mmuu aatoobuɛ Yaa ɔlaa alɛ, “Bikyi siikpile lee kamɛ biefũ Yaa ntu okpeesa, di Yaa ayɔ sikpile lee akyɛ ye.” ");
INSERT INTO snw_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Fɛ mmle bɛɛkpana bɛɛtɛ ni di Yaa Ɔlaa Buɛtɛtɛ Yesaia kukũ kamɛ alɛ, “Otii onwii kɔfaa di ɔfaafuu kamɛ ambuɛ alɛ, ‘Bilolaa osuku bitɛ Saate nwu ɔwabee. Biɛkyɛkyɛsa abaya abafe ni bitɛ nwɔ. ");
INSERT INTO snw_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Bietĩi abaya amuu niekyofo ni. Biebiɛ kafɔɔ abokote ku kobokotee amuu bitɛ kaasɔ. Bieyilasa sisuku se niɛkɔnkɔ ni. Biɛkylɔkylɔsa abaya kafɔɔ niekukyukukyu ni. ");
INSERT INTO snw_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Kayi batii bamuu manya Yaa Didiki!’ ” ");
INSERT INTO snw_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Batii kpinwu ladie baawa alɛ Yohane akpeesa ma Yaa ntu. Ni aatɔkɔ ma alɛ, “Aye kɔsaanwu kɔna! Owe niɛka ye alɛ biatoso di Yaa lɛkanko le nikɔwa ni kamɛ? ");
INSERT INTO snw_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Bibla asaa ya nimatuo alɛ bitookyi ni siikpile lee kamɛ. Biediɛ obuɛ ɔtɔkɔ suoto lee bilɛ Abraham banantii bile. Diekye kɔtɔkɔ ye nlɛ, Yaa mafuo afuɔ ya mmle ɔyɔ ɔbla banantii anta Abraham. ");
INSERT INTO snw_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Nunua bia yi, batɔɔyɔ kafɛ beese di awoso sidu suoto kofokofoko. Kowoso lele ninantika abi biene yi, bababudi kũ, man-yɔ kũ mankpee di ɔtɔ kamɛ.” ");
INSERT INTO snw_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ninfɛ baatii nwu lakaalɛ nwɔ alɛ, “Ni be nfɛ buabla nunua?” ");
INSERT INTO snw_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ninfɛ aadiki kanya, aatɔkɔ ma alɛ, “Otii lele nikpe osi awu anyɔ, ayɔ anwii ata otii wɔ ninnaa ni kuanwii. Otii wɔ kafɔɔ nikpe ni alesaa, asɛko owo nɔɔ wɔ di alesaa nnaa ni.” ");
INSERT INTO snw_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Akpooto bafuntɛ bawo kafɔɔ lawa alɛ, bakpeesa ma Yaa ntu. Ni baakaalɛ nwɔ alɛ, “Saatuotɛ, be dikpe ni buɔbla?” ");
INSERT INTO snw_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ninfɛ di Yohane latɔkɔ ma alɛ, “Bitanfũ akpooto bialenkeesa n-ya bɛɛta ye alɛ biafũ nii.” ");
INSERT INTO snw_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Bakpɛtɛ bawo kafɔɔ lakaalɛ nwɔ alɛ, “Ni awo mɔ? Be dikpe ni buɔbla?” Ninfɛ aatɔkɔ ma alɛ, “Bitan-yɔ suoto osie biafũ koto di otii kuonwii nnɛɛ, ee bitambudi otii kuonwii kanya di osuku kpile suoto. Bita ato lee ya biofũ ni sɛɛkpɛ mmɛ abuoye anu.” ");
INSERT INTO snw_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Batii osuku onyu lakyako katoo ɔtaka, ni baatoobu alɛ, loo Yohane ninle Kristo wɔ boonyu ni osuku alɛ abawa ni nɛ. ");
INSERT INTO snw_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Nioso Yohane latɔkɔ ma alɛ, “Ami, ntu kɔyɔ nkpeesa ye. Kafɔɔ otii wɔ nikɔwa ni sɛɛmaa nii nlenkee mi. Otii wɔ ninansiɛko alɛ bia kadiki nwɔ ni ntokota. Nnwɔɔ, abayɔ Ninwuna Klekle ku ɔtɔ ankpeesa ye. ");
INSERT INTO snw_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Akle kɔfɛɛ nɔɔ di nnɛɛ kamɛ, abafɛɛlɛ ni kamɔɔ andiki ni kufuo kaamɛ, an-yɔ kamɔɔ abi ankpete di owu kamɛ. Kafɔɔ kufuo nkũ, abafiɛ kũ di ɔtɔ wɔ ninaanii ni diidii kamɛ.” ");
INSERT INTO snw_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yohane latɔkɔ batii nwu Yaa ɔlaa biene nwu di sisuku ate ate suoto, ni aaka ma alɛ, bakyisa nkpa, di nkpa lɛma disiɛbi kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Kafɔɔ Yohane lasĩ ɔlaa aata Herode wɔ niale ni abaa ɔnɔɔfo, diekye aafũ obilɛma ɔsɔfɔ wɔ baatɔɔlɛɛ ni Herodia aayɔ, ku sikpile bamba se kpinwu aabla ni oso. ");
INSERT INTO snw_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Nioso okpile wɔ ninlenke ni di Herode lakple aabla ni, ninle alɛ, aamufũ Yohane aatɛ leeyo. ");
INSERT INTO snw_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Obe wɔ di Yohane ntooloo ni batii Yaa ntu okpeesa, aakpeesa Yesu kafɔɔ. Obe wɔ di Yesu latɔɔpɛ ɔlaa aatɔɔta ni Yaa, kolo lasɛkɛtɛ. ");
INSERT INTO snw_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ninfɛ di Yaa Ninwuna Klekle lasoo nwɔ di suoto fɛ mmle di lɛlaapɔɔ nsoo ni nɛ. Ninfɛ baanu sɛlɔ lakye osi siabuɛ alɛ, “Afɔ ninle obi nii wɔ suoto ninantuna ni nɛ. Foobuo mi anu nwaa.” ");
INSERT INTO snw_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu lafũ fɛ alɛɛ afosi atiɛ di obe wɔ aakye ni ɔkpɛ nɔɔ kasɔ. Batii lanyu alɛ Yosef obi ale. Yosef ote niale Eli. ");
INSERT INTO snw_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli ote niale Mattat, Mattat ote niale Lewi, Lewi ote niale Melki, Melki ote niale Yanai, Yanai ote niale ni Yosef. ");
INSERT INTO snw_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yosef ote niale Matatia, Matatia ote niale Amos, Amos ote niale Nahaum, Nahaum ote niale ni Esli, Esli ote niale Nagai. ");
INSERT INTO snw_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai ote niale Mahat, Mahat ote niale ni Matatia, Matatia ote niale Semein, Semein ote niale Yosef, Yosef ote niale ni Yuda. ");
INSERT INTO snw_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yuda ote niale Yohanan, Yohanan ote niale Resa, Resa ote niale Sorobabel, Sorobabel ote niale Sealtiel, Sealtiel ote kafɔɔ niale Neri. ");
INSERT INTO snw_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri ote niale Melki, Melki ote niale Adi, Adi ote niale Kosam, Kosam ote niale Elmadam, Elmadam ote niale Er. ");
INSERT INTO snw_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er ote niale Yosua, Yosua ote niale Elieser, Elieser ote niale Yorim, Yorim ote niale Matat, Matat ote niale Lewi. ");
INSERT INTO snw_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lewi ote niale Simeon, Simeon ote niale Yuda, Yuda ote niale Yosef, Yosef ote niale Yonam, Yonam ote niale Eliakim. ");
INSERT INTO snw_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim ote niale Melea, Malea ote niale Mena, Mena ote niale Matata, Matata ote niale Natan, Natan ote niale Dawid. ");
INSERT INTO snw_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dawid ote niale Yisai, Yisai ote niale Obed, Obed ote niale Boas, Boas ote niale Salomo, Salomo ote niale Nahason. ");
INSERT INTO snw_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahason ote niale Aminadab, Aminadab ote niale Adimin, Adimin ote niale Arni, Arni ote niale Hesron, Hesron ote niale Peres, Peres ote niale Yuda. ");
INSERT INTO snw_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuda ote niale Yakob, Yakob ote niale Isak, Isak ote niale Abraham, Abraham ote niale Tera, Tera ote niale Nahor, ");
INSERT INTO snw_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor ote niale Serug, Serug ote niale Regu, Regu ote niale Peleg, Peleg ote niale Eber, Eber ote niale Sala. ");
INSERT INTO snw_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala ote niale Kainan, Kainan ote niale Arfaksad, Arfaksad ote niale Sem, Sem ote niale Noa, Noa ote niale Lamek. ");
INSERT INTO snw_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek ote niale Metusala, Metusala ote niale Henok, Henok ote niale Yared, Yared ote niale Mahalaleel, Mahalaleel ote niale Kainan. ");
INSERT INTO snw_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kainan ote niale Enos, Enos ote niale Set, Set ote niale Adam, Adam ote kafɔɔ niale Yaa nɛ. ");
INSERT INTO snw_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Obe wɔ di Yesu ladie ni di Yordan okle nwu kamɛ, aayii pɔ ku Ninwuna Klekle. Ni di Ninwuna nwu lakpaa nwɔ aasifiko ɔfaafuu kamɛ, ");
INSERT INTO snw_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","lɛɛba le di Abonsam lasɔ nwɔ aanyu ni ayi afosi ana amu. Di obe nwu kamɛ, Yesu ditale lɛsalɛsaa, nioso kɔka lakle nwɔ osie kanya di ayi nwu kayɛntɛkɔ. ");
INSERT INTO snw_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ninfɛ di Abonsam latɔkɔ nwɔ alɛ, “Nse Yaa obi fale, ni tɔkɔ difuɔ le mmle falɛ dikple alesaa.” ");
INSERT INTO snw_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Kafɔɔ Yesu latɔkɔ nwɔ alɛ, “Kɔkpana Klekle Kukũ lebuɛ alɛ, ‘Diele alesaa lete suoto di otii nsiɛ nkpa.’ ” ");
INSERT INTO snw_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Nni kamaa, Abonsam lakpaa nwɔ aalaase di lɛba le niataka ni suoto. Ni aatuo nwɔ kayi asaa ku sɛka nlekɔ mmuu di onumpoo lɛpɛ kamɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ni aatɔkɔ nwɔ alɛ, “Kamayɔ kayi kamuu otumi wɔ mmle ku kamɛ lɛsaawɛ nta fɔ, diekye ami bɛɛyɔ bɛɛta, otii lele kafɔɔ ninlɛ mi kafuo nwɔ ɔyɔ ɔta. ");
INSERT INTO snw_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Nioso asaa ya amuu makple fɔ ale nse fabase katũ kasɔ fantɛɛ.” ");
INSERT INTO snw_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ninfɛ di Yesu latɔkɔ nwɔ alɛ, “Kɔkpana Klekle Kukũ lebuɛ alɛ, ‘Saate Yaa lɛfɔ lete faase katũ kaasɔ fanta. Lete nɔɔ kafɔɔ faatansa.’ ” ");
INSERT INTO snw_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Nni kamaa, Abonsam lakpaa Yesu aasifiko Yerusalem aalaatika nwɔ di Yuda batii Yaa Olekatakɔ lɛkya kapiɔ̃piɔ̃kɔ, ni aatɔkɔ nwɔ alɛ, “Nse Yaa obi fale, faayefe fakye ninfũ fasifi kasɔ. ");
INSERT INTO snw_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Diekye Kɔkpana Klekle Kukũ lebuɛ alɛ, ‘Yaa mata batɔkyɛntɛ nɔɔ nyila mannyu fɔ.’ ");
INSERT INTO snw_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","‘Babaklee fɔ di nnɛɛ lɛma kamɛ di osi alɛ, bia falaatuula diifuɔ kuninwii suoto.’ ” ");
INSERT INTO snw_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Kafɔɔ Yesu latɔkɔ nwɔ alɛ, “Kɔkpana Klekle Kukũ lebuɛ alɛ, ‘Tansɔ Saate Yaa lɛfɔ faanyu.’ ” ");
INSERT INTO snw_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Obe wɔ di Abonsam lasɔ Yesu di sisuku se mmle suoto aaloo nii, aayidiɛ nwɔ kɛɛkɛ aasifi. ");
INSERT INTO snw_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ninfɛ di Yesu lakple aasifi Galilea nɛ. Yaa Ninwuna Klekle otumi lasiɛ nwɔ kaamɛ. Ni di suoto nɔɔ ɔlaa lakyaka ntɛɛ nwu nɛ. ");
INSERT INTO snw_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Aatuo asaa di Yuda batii nsiisakɔ, obiala latansa asaa nɔɔ otuo. ");
INSERT INTO snw_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Nni kamaa, Yesu lakyɛ Nasaret ninle ni okpoo wɔ baaklee nwɔ aamuɔ nii. Ni di Lɛnyɛɛtɛyi suoto, aakyɛ Yuda batii kasiisakɔ fɛ mmle ambɔmbɔ ni ɔbla. Ni aataka aayila alɛ ɔɔka asaa di Kɔkpana Klekle Kukũ kamɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ninfɛ baayɔ Yaa Ɔlaa Buɛtɛtɛ Yesaia kukũ baatɔɔ nɛ. Ni aatikiti kukũ nwu aanya lɛba le bɛɛkpana ni alɛ, ");
INSERT INTO snw_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Saate Ninwuna ntika mi di suoto, diekye eediki mi alɛ, kayɔ ɔlaa biene nwu nwako bapiitɛ. Eekyesee mi kafɔɔ alɛ kayie lɛkya nta batii ba beemufũ bɛɛpɛ ni akpo alɛ baawɛ difukiti. Ku mba di anu lebiɛ nii, alɛ baanya. Ku batii ba beenyinka bɛɛtɛ ni kaasɔ ku dibuo alɛ, baawɛ ɔnyɛɛ ɔtɛ. ");
INSERT INTO snw_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Alɛ kata mantofo kafɔɔ alɛ obe ntoowo di Saate madiki ni batii nɔɔ.” ");
INSERT INTO snw_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ninfɛ di Yesu latĩi kukũ nwu nkpo, aakplesa aata tɔkyɛntɛ nwu, ni aasiɛ kaasɔ nɛ. Batii ba bamuu niawɛ ni di kasiisakɔ nwu lakyako nwɔ onyu tuwĩi. ");
INSERT INTO snw_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ni aatɔkɔ ma alɛ, “Kɔkpana Klekle Kukũ lɛba le mmle biene lɛka ni ninfũ, nintɔɔwa kaanya miɛ dii le mmle nɛ.” ");
INSERT INTO snw_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Sɛlaa nɔɔ se aabuɛ ni lamufũ di batii nwu situ osie kanya, ku mmle aablako ni ɔkplalomii nɔɔ ɔkpɛ, diabla batii nwu ɔkpɛ. Ni baakaalɛ alɛ, “Diele nnwɔɔ ninle Yosef obi nwu nkpo nɛ?” ");
INSERT INTO snw_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ni di Yesu latɔkɔ ma alɛ, “N-ye nlɛ bibapɛ mi lɛkpa le mmle bilɛ, ‘Fablatɛ, bla suoto kɔfa.’ Bibakple mintɔkɔ mi kafɔɔ bilɛ, ‘Asaa ya okle bianu bilɛ labla ni di Kapernaum, mbla nya kafɔɔ di okpoo nii.’ ” ");
INSERT INTO snw_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ninfɛ di Yesu lakple aatɔkɔ ma alɛ, “Kɔtɔkɔ ye nlɛ, mánfũ Yaa ɔlaa buɛtɛtɛ di nnwɔɔ omu nɔɔ okpoo. ");
INSERT INTO snw_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Binu! Nwaako diale alɛ bakpisɔfɔ kpinwu lawɛ di Israel kasɔ suoto di obe wɔ di Elia lawɛ nii. Di kanto ladiɛ ni ɔnɔɔ alɛɛ atiɛ ku ɔfã, di kɔka kplɛ lawa ni kaasɔ nwu kamuu suoto. ");
INSERT INTO snw_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Kafɔɔ, Yaa ditakyesee Elia alɛ akyɛ kuonwii lɛma nfũ. Kafɔɔ aakyesee nwɔ aakyɛ bakpisɔfɔ nfũ di Sarep okpoo kamɛ di Sidon kasɔ suoto. ");
INSERT INTO snw_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Nkpo nwu kafɔɔ baatii kpinwu latoofiɛ ofiɛ sɛɛle di Israel kasɔ di Yaa Ɔlaa Buɛtɛtɛ Elia obe kamɛ nɛ. Kafɔɔ kuonwii ditawɛ difiɛyɔɔ kaamɛ lɛma, dilenkee Naeman wɔ niakye ni Siria kasɔ lete niawɛ difiɛyɔɔ.” ");
INSERT INTO snw_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Obe wɔ baatii ba niawɛ ni di kasiisakɔ nwu lanu ni ɔlaa wɔ mmle, ɔblɔ lafiɛ ma osie kanya di Yesu suoto. ");
INSERT INTO snw_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ni baataka, baananfi Yesu baadieko di okpoo nwu baasifiko kobokote ko suoto baabudi ni okpoo nwu kobembe, alɛ bootukusɔɔ mankpee di kɔwɛ kamɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Kafɔɔ Yesu lafe ma nintɛɛ aasifi. ");
INSERT INTO snw_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Nni nkpo kamaa, Yesu lasifi Kapernaum okpoo kamɛ di Galilea kasɔ suoto. Ni di Lɛnyɛɛtɛyi suoto aalaakya ko batii asaa otuo nɛ. ");
INSERT INTO snw_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Asaa nɔɔ otuo labla ma ɔkpɛ, diekye aatuo nya ku otumi. ");
INSERT INTO snw_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Otii onwii lawɛ di Yuda batii kasiisakɔ nwu niinwuna kpile lasiɛ nii. Ni aafaa osie kanya aabuɛ alɛ, ");
INSERT INTO snw_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Oo! Be foomiɛ di ɔkyɛ loo, afɔ Yesu Nasaret Otii? Ɔwɔɔsa fɛɛwa wo? N-ye otii wɔ fale nii! Afɔ ninle Otii Klekle wɔ di Yaa lekyesee ni nɛ!” ");
INSERT INTO snw_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ninfɛ di Yesu lakpee ninwuna nwu kufiofa alɛ, “Lo kanana! Faadie nwɔ kaamɛ!” Ninfɛ di ninwuna kpile nwu lanwanyisa nwɔ aatɛ kaasɔ di batii nwu anu nɛ. Ni aadie nwɔ kaamɛ aasifi nɛ, kafɔɔ lɛsalɛsaa ditabla osuɔtɔ nwu. ");
INSERT INTO snw_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Diabla batii nwu bamuu yaaa, ni baakaalɛ bawo alɛ, “Ɔmɛnlaa ninle nwɔ? Otii wɔ mmle lɛyɔ otumi ku osie kplɛ antososa anwuna kpile andiki di batii suoto.” ");
INSERT INTO snw_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Nioso Yesu leyooto lakyaka ntɛɛ nwu sekpoo simuu kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu ladie di Yuda batii kasiisakɔ, ni aasifi Simon leyo nɛ. Simon ɔmaato late aatoofiɛ kɔbɔ ofiɛ osie kanya. Ninfɛ baata Yesu latofo nɛ. ");
INSERT INTO snw_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ninfɛ aakyɛ aalaayila diɛ atensaa nɔɔ ɔlɔɔkɔ ni aasĩ ɔlaa aata ofiɛ nwu nɛ. Nfanwu, ofiɛ nwu layɔɔ nwɔ, ni aataka aanyu ma kanya nɛ. ");
INSERT INTO snw_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Obe wɔ kuufĩ ntɔɔmɛɛ nii, batii ba bamuu baafiɛtɛ ate ate nkpe ni lakpaa ma baawako Yesu nfũ. Ni aatika ma nnɛɛ di suoto aayɔɔsa bamuu lɛma sifiɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Anwuna kpile kpinwu kafɔɔ ladie baatii kamɛ baatooyiisa kudu alɛ, “Afɔ ninle Yaa obi nwu nɛ!” Kafɔɔ Yesu ditata anwuna kpile nwu osuku alɛ abuɛ ɔlaa kuonwii, diekye baatofo alɛ nnwɔɔ ninle Kristo wɔ bɛɛpɛ ni ɔfɔɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Kaale lasɛ nii, Yesu ladie di okpoo nwu aasifi lɛba le nialo nii, batii nwu lakyako nwɔ owolaa. Obe wɔ baanyɔɔ nii, baamiɛ alɛ se atansifi aadiɛ ma fiɛ. ");
INSERT INTO snw_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Kafɔɔ aatɔkɔ ma alɛ, “Dikpe nii lɛkyɛ lɛlaabuɛ Yaa sɛka kalekɔ ɔlaa biene nwu di sekpoo bamba kamɛ, diekye nni oso di Yaa lekyesee mi nɛ.” ");
INSERT INTO snw_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Nkpo oso aabuɛ Yaa ɔlaa di Yuda batii nsiisakɔ nwu mmuu di kasɔ nwu suoto. ");
INSERT INTO snw_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Dii ninwii, Yesu layila di lekpo le bɔɔlɛɛ ni alɛ Genesaret kotoko. Ni baatii dikudi nwu latoosisikiti alɛ bɔɔtɛɛtɛɛ nwɔ mmle baanu ni Yaa ɔlaa wɔ ababuɛ nii. ");
INSERT INTO snw_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yesu lanya ekolo ɛnyɔ n-yɛ di lekpo nwu kotoko ninfa, kɔkpaku badikitɛ ladiɛ sĩ bɛɛkyɛ boofoto asawu lɛma. ");
INSERT INTO snw_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ninfɛ di Yesu layie aabuo di oklo onwii kamɛ, nwɔ ninle ni Simon ole. Ni aatɔkɔ nwɔ alɛ atukusa oklo nwu kuɔkyɛ ntu kamɛ kɛkɛɛ. Oklo nwu kamɛ di Yesu lasiɛ aatuo batii dikudi nwu asaa nɛ. ");
INSERT INTO snw_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Obe wɔ aatuo ma asaa aaloo nii, Yesu latɔkɔ Simon alɛ, “Tukusa oklo nwu fakyɛnko sitũ nintu nwu kamɛ lɛɛba le niekyofo ni, di afɔ ku basiɛwo lɛfɔ biɛtaa asawu bidiki kɔkpaku.” ");
INSERT INTO snw_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ni di Simon labuɛ alɛ, “Ɔnɔɔfo, kakyɛ ka kpe buɔbla ɔkpɛ ku ninunsɛɛ, kafɔɔ butadiki lɛsalɛsaa. Kafɔɔ bubataa asawu nwu fɛ mmle feebuɛ nii.” ");
INSERT INTO snw_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Baataa asawu nwu, ni baadiki kɔkpaku kpinwu diata alɛ asawu lɛma lakyako ɔbɛbɛɛ. ");
INSERT INTO snw_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Nioso, baawii nnɛɛ baalɛɛ basiɛwo lɛma diɛ oklo nyɔɔfa kamɛ alɛ bawa babakyakaako ma. Baawa babadiki kɔkpaku baayiisa eklo ɛnyɔ be mmle kamɛ pɔ alɛ kɛkɛɛ niabu di eklo nwu kamɛɛ ni nintu kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Obe wɔ di Simon Petro lanya lɛsaa le niawa nii, ni aapɛ akunkyi di Yesu katũ, aatɔkɔ nwɔ alɛ, “Saate, tantɛɛtɛɛ mi, diekye kpileblatɛ nnle!” ");
INSERT INTO snw_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Kɔkpaku ko kpinwu baadiki ni ninfa oso, dibla nnwɔɔ ku basiɛwo nɔɔ ɔkpɛ osie kanya. ");
INSERT INTO snw_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Nkpo okle kafɔɔ diabla Simon basiɛwo ba ninle Sebedeo babi, Yakobo ku Yohane ɔkpɛ nɛ. Ninfɛ di Yesu latɔkɔ Simon alɛ, “Tanyɛkɛ. Diɛyɔ ni di nua diesifi nii, batii dikitɛ nfɛ fabale.” ");
INSERT INTO snw_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Nni kamaa, baananfi seklo nwu baase di lekpo kotoko, ni baadiɛ lɛsaa biala baatɛ, baasifi baalaatikanko Yesu nɛ. ");
INSERT INTO snw_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Obe onwii, Yesu lakyɛ okpoo onwii kamɛ, nfũ di osuɔtɔ onwii lawɛ aatoofiɛ ni ofiɛ sɛɛle. Obe wɔ di osuɔtɔ wɔ mmle lanya ni Yesu, ni aapɛ akunkyi di Yesu katũ aatikiti nwɔ lekoto alɛ, “Saate! Nse dilɛ fɔ, faafuo ɔta suoto nii mbla klekle.” ");
INSERT INTO snw_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu ladiki kɔnɛɛ aakpanko nwɔ, aatɔkɔ nwɔ alɛ, “Letuna, suoto lɛfɔ siklekle!” Nfanwu, ni di ɔfiɛ nwu layɔɔ nwɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ninfɛ di Yesu lakpee nwɔ kufiofa alɛ, “Tantɔkɔ otii kuonwii. Kafɔɔ tɔɔkyɛ falaayɔ suoto lɛfɔ fatuo Yaa oletatɛ, faata ole di mmle di Mose lekpee kufiofa ɛɛtɛ ni di suoto okleklesa suoto, diatuo alɛ ɔfiɛ nwu ntɔɔyɔɔ fɔ ni.” ");
INSERT INTO snw_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Kafɔɔ Yesu leyooto lakyaka kayi osie kanya. Diata alɛ batii kpinwu latɔɔwa alɛ bɔbatoonu nwɔ asaa otuo anyɔɔsa ma sifiɛ. ");
INSERT INTO snw_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Kafɔɔ obe obe, andie ankyɛ lɛba le nielo ni anaatɔɔpɛ ɔlaa antɔɔta Yaa. ");
INSERT INTO snw_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Dii ninwii obe wɔ di Yesu latotuo ni asaa, Yuda batii dikudi le bɔɔlɛɛ ni Farisi batii ku kufiofa batuotɛ bawo lakye Galilea ku Yudea ku Yerusalem kasɔ aba aba baawa nfa. Ni di Yaa Ninwuna lasiɛ di Yesu kamɛ alɛ ɔɔyɔɔsa batii sifiɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Nfanwu, batii banwii niakpaa osuɔtɔ onwii niafefee aate ni di ɔkla suoto baawako. Baatoomiɛ osuku wɔ baayɔ nwɔ mambuoko ni leyo le di Yesu lawɛ nii, man-yɔ osuɔtɔ nwu mantɛ ni di anu nɔɔ. ");
INSERT INTO snw_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Kafɔɔ batii lɛpɔ nwu oso, batafuo osuku ɔwɛ. Nle mmle oso, baatuka nwɔ baalaayie lɛkya osi. Ni baadufu kutuɛ di lɛkya nwu suoto baasoosa fiɛtɛ nwu ku ɔkla nɔɔ wɔ suoto aate nii, baatɛ di Yesu anu di batii nwu ntɛɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Di Yesu lanya ni ofũ onu lɛma oso, ni aatɔkɔ osuɔtɔ nwu alɛ, “Siɛwo nii, ntɔɔyɔ sikpile lɛfɔ lɛkyɛ fɔ!” ");
INSERT INTO snw_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ninfɛ di Farisi batii ku kufiofa batuotɛ lakyako bawo ɔkaalɛ alɛ, “Owe ninle nwɔ mmle nikobuɛ ni mbusuo ɔlaa wɔ mmle? Yaa lete nikafuo sikpile ɔyɔ ɔkyɛ!” ");
INSERT INTO snw_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Obe wɔ di Yesu latofo ni disibu lɛma, ni aakaalɛ ma alɛ, “Be oso biobu sɛlaa se mmle okle disi? ");
INSERT INTO snw_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Lɛmɛnle niɛyɔɔ dilenke di sɛlaa se mmle obuɛ kamɛ, ‘Bɛɛyɔ sikpile lɛfɔ bɛɛkyɛ fɔ’ ɛɛ sɛɛ baabuɛ alɛ, ‘Taka faakyɛ’? ");
INSERT INTO snw_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Kamadiki ntuo ye nlɛ ami, Otii Obi nkpe, otumi kaasɔ ka mmle suoto n-yɔ okpile nkyɛ.” Ninfɛ aatɔkɔ otii wɔ niekpi ni kakyɛkakyɛ alɛ, “Kɔtɔkɔ fɔ nlɛ, taka faayɔ ɔkla lɛfɔ faatɔɔkyɛ leyo!” ");
INSERT INTO snw_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Nfanwu, osuɔtɔ nwu nkpo niataka aayila baati nwu anu, aayɔ atensaa nɔɔ ya suoto aate nii, aasifi leyo, aakyako Yaa ɔtansa. ");
INSERT INTO snw_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Lɛsaa le mmle labla batii nwu bamuu ɔkpɛ! Nioso lɛyɛkɛ lapɛ bamuu lɛma, ni baatansa Yaa, baabuɛ alɛ, “Be mɔ lɛsaa kplɛ buɔnya miɛ nkpo?” ");
INSERT INTO snw_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Nni kamaa, Yesu ladie leeyo nwu kamɛ, ni aanya akpooto funtɛ onwii baatɔɔlɛɛ ni Lewi, aasiɛ di akpooto kafunkɔ. Ninfɛ aatɔkɔ nwɔ alɛ, “Tikankoe!” ");
INSERT INTO snw_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Nfanwu, Lewi ladiɛ lɛsaa biala aatɛ, ni aataka aatikanko nwɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lewi lata baawa alesaa biene leeyo nɔɔ, aatũ opunu kplɛ aata Yesu. Baakyakako akpooto bafuntɛ kpinwu ku batii bamba kafɔɔ. ");
INSERT INTO snw_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Farisi batii ku kufiofa batuotɛ ba niawɛ ni di alesaa nwu kalekɔ lakye kasɔ baatɔɔnanfiko Yesu basaateketetɛ ɔlaa alɛ, “Be oso biole minwee ku akpooto bafuntɛ ku bakpileblatɛ bamba ba mmle?” ");
INSERT INTO snw_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ninfɛ di Yesu ladiki kanya alɛ, “Fablatɛ diefĩ batii ba ninoofiɛ nii, bafiɛtɛ di fablatɛ lefĩ. ");
INSERT INTO snw_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ninwa babienetɛ ɔlɛɛ, bakpiletɛ oso lɛwa.” ");
INSERT INTO snw_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Batii bawo lakaalɛ alɛ, “Lɛ diɛwa fiɛ di Yohane basaateketetɛ nnii kanya mampɛ ɔlaa manta Yaa wlawla, Farisi batii basaateketetɛ kafɔɔ mbla nkpo, kafɔɔ bale fɔ mma obe lele manle manyi?” ");
INSERT INTO snw_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ninfɛ di Yesu ladiki kanya alɛ, “Biefũ bienu bilɛ batii ba bɛɛkyakako bɛɛwako ni ɔsanko kayɔkɔ kaanii kanya di obe wɔ di ɔsanko nwu nkpo ɔsa nkpe ma ni di ɔkyɛ? Oowo! Diidii dilaafuo ɔwa nkpo! ");
INSERT INTO snw_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Kafɔɔ, dii lewo kɔwa, babakpaa ɔsanko nwu ɔsa di ɔkyɛ lɛma mansifiko nii. Nfa nfɛ babakyako kanya onii nɛ.” ");
INSERT INTO snw_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Nni kamaa, Yesu lapɛ ma lɛkpa le mmle alɛ, “Otii konwii nimbɛ dibula fɔle aakaa aatĩi lekofole kabɛkɔ. Nse otii owo lɛbla nkpo, abalalaasa dibula fɔle nwu. Ni kafɔɔ, lekofole nwu nkpo ku lɛfɔle nwu nkpo dilabakaatɛɛ bia. ");
INSERT INTO snw_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Nkpo kafɔɔ kuonwii nin-yɔ nta fɔle aakpete di bɔkɛɛ kukũ kotofo kofole kamɛ nɛ. Diekye nse diɛwa nkpo, nta fɔle nwu nkpo mafuu ninta alɛ, kɔbɔkɛɛkũ kotofo nwu nkpo mbɛ, nta nwu nkpo kafɔɔ nwii nyinlalaa. ");
INSERT INTO snw_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nioso dikaatɛ alɛ baayɔ nta fɔle mankpete di kɔbɔkɛɛkũ fɔle kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Diɛkyakaa nii, otii kuonwii ninyi nta kofole, nfɛ oosiɛ nii aakple aakaalɛ nfɔle. Nse diele nkpo ɔlaa wɔ ababuɛ ni ko ninle alɛ, ‘Nkofole nwu nlɛ dilɛnke nfɔle!’ ” ");
INSERT INTO snw_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Di Lɛnyɛɛtɛyi ninwii suoto, Yesu ku basaateketetɛ nɔɔ latoofe di atita kofe kunwii kamɛ. Ninfɛ di basaateketetɛ nɔɔ nwu lakyako atita nwu ofee, baafini nya baakyako owee nɛ. ");
INSERT INTO snw_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ninfɛ di Farisi batii bawo lakaalɛ ma alɛ, “Be oso biɔbla lɛsaa le di kufiofa loo diɛta ni osuku alɛ babla ni di Lɛnyɛɛtɛyi suoto?” ");
INSERT INTO snw_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ninfɛ di Yesu ladiki kanya alɛ, “Biika lɛsaa le di Dawid labla ni ku bawo nɔɔ di Kɔkpana Klekle Kukũ kamɛ binya, di obe wɔ kɔɔka laklee ma ni? ");
INSERT INTO snw_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Dawid lakyɛ Yaa Olekatakɔ kamɛ aalaayɔ alesaa ya baata ni Yaa ole, aale ni. Aayɔ awo kafɔɔ aata bawo nɔɔ lale ni. Nu kuufiofa loo diɛta osuku alɛ otii bamba kale ni alesaa nwu nkpo. Diediki Yaa oletatɛ lete pɛ nikale ni.” ");
INSERT INTO snw_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ninfɛ di Yesu labuɛ aanyɛntɛ alɛ, “Ami, Otii Obi, ninle Lɛnyɛɛtɛyi Saate.” ");
INSERT INTO snw_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Di Lɛnyɛɛtɛyi bamba suoto Yesu lakyɛ Yuda batii kasiisakɔ, aalaatuo asaa. Osuɔtɔ onwii lawɛ ninfa di koletanɛɛ nɔɔ lakatu nii. ");
INSERT INTO snw_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Kufiofa batuotɛ ku Farisi batii bawo lawɛ ninfa baatoomiɛ osuku wɔ baafe man-yɔ ni ɔlaa di Yesu suoto oso, baadiki anu baase nwɔ baatoonyu, nse, abayɔɔsa ofiɛ di Lɛnyɛɛtɛyi nwu suoto. ");
INSERT INTO snw_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Di Yesu latofo ma ni disibu nwu oso, ni aatɔkɔ osuɔtɔ nwu kɔɔnɛɛ lɛkatu ni alɛ, “Taka, fawa sitũ ninfũ.” Ni di osuɔtɔ nwu lataka aakyɛ aalaayila ma diɛ anu nɛ. ");
INSERT INTO snw_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ninfɛ di Yesu lakaalɛ ma alɛ, “Be di kufiofa loo lɛta osuku alɛ buabla di Lɛnyɛɛtɛyi suoto? Dilɛ alɛ buabla dibiene di lɛnyɛɛtɔyi suoto ɛɛ, buabla dikpile? Ee dilɛ alɛ buafũ batii nkpa ɛɛ, sɛɛ buawɔɔsa mi?” ");
INSERT INTO snw_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yesu lanyu batii nwu bamuu aafenko, ni aatɔkɔ osuɔtɔ nwu alɛ, “Yilasa kɔnɛɛ lɛfɔ.” Ni aayilasa kũ nɛ, nfanwu kɔnɛɛ nɔɔ nwu lakple kualɛ. ");
INSERT INTO snw_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ɔblɔ lafiɛ batii nwu bamuu ni baakyako disi obu di lɛsaa le babafuo ni Yesu ɔbla. ");
INSERT INTO snw_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Di obe nwu kamɛ, Yesu lasifi kabokotee kanwii osi, alɛ ɔɔlaa pɛ ɔlaa anta Yaa. Aawɛ ninfa kakyɛ kamuu, aatɔɔpɛ ɔlaa aatɔɔta Yaa. ");
INSERT INTO snw_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Obe wɔ kaale lasɛ nii, aalɛɛ basaatekete nɔɔ bamuu aasiisa, ni aadiki lefosi batii banyɔ kaamɛ lɛma, aata ma leyooto alɛ, batɔkyɛntɛ. ");
INSERT INTO snw_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Mma ninle, Simon wɔ aata ni leyooto alɛ, Petro ku obilɛma suɔtɔbi Andrea ku Yakobo ku Yohane ku Filipo ku Bartolomeo, ");
INSERT INTO snw_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ku Mateo ku Toma ku Yakobo wɔ ninle ni Alfeo obi ku Simon wɔ manlɛɛ ni alɛ otii wɔ nimbɔmbɔ ni okpoo nɔɔ. ");
INSERT INTO snw_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Ku Yakobo obi Yuda ku Yuda Iskariot wɔ niabakple ni otii dikitatɛ. ");
INSERT INTO snw_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Di obe wɔ di Yesu ku batɔkyɛntɛ nɔɔ lasosoo baakye ni kabokotee nwu osi, baabayila lɛɛba le ninte ni yaaa. Ni di basaateketetɛ nɔɔ kpinwu bawo lawɛ ninfa ku batii dikudi kplɛ ninwii le niakye ni Tiro ku Sidon. ");
INSERT INTO snw_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Baawa alɛ, bɔɔbanu asaa ya di Yesu kotuo nii, anyɔɔsa ma sifiɛ ate ate se boofiɛ nii. Batii ba di anwuna kpile latɔɔhaa ni kafɔɔ lawa aayɔɔsa bamuu lɛma sifiɛ. ");
INSERT INTO snw_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Batii ba mmle bamuu lakpee ɔnyɛɛ baakpanko nwɔ, mmle siifiɛ lɛma kayɔɔ ma nii. Diekye osie owo latoodie di Yesu suoto kamɛ diatɔɔyɔɔsa batii bamuu sifiɛ. ");
INSERT INTO snw_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu latakatɛsa anu aanyu basaateketetɛ nɔɔ, ni aatɔkɔ ma alɛ, “Suoto siyɔɔ aye bapiitɛ, dikye Yaa sɛka kalekɔ ninle ye kale! ");
INSERT INTO snw_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Suoto siyɔɔ aye ba kɔɔka nkle ni nunua diekye aye nimamiɛ nɛ! Suoto siyɔɔ aye ba nikowi ni nunua, diekye aye nimama nɛ! ");
INSERT INTO snw_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Suoto siyɔɔ ye nse batii lekyidi ye, beesĩ ye, beetufa ye, beebuɛ kafɔɔ alɛ batii kpile bile ta ami, Otii Obi, oso! ");
INSERT INTO snw_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Binya suoto lɛyɔɔ nse n-ya mmle amuu kɔwa, bietũ ku suoto lɛyɔɔ, diekye Yaa mata ye letota kplɛ di Yaa kafa. Diekye asaa ya mmle okle di bawa lɛma layɔ baabla Yaa ɔlaa babuɛtɛtɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Aye ba ninle ni basaawɛntɛ biyɔɔsa, diekye bitɔɔwɛ suoto lɛyɔɔ lee ninfũ! ");
INSERT INTO snw_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Aye ba nintoole biemiɛ ni nunua biyɔɔsa, diekye kɔka kɔwa ye ɔbaklee! Aye ba nikɔma ni miɛ, biyɔɔsa diekye biɔwa sɛnyaami obuo ku kaku owi! ");
INSERT INTO snw_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Biyɔɔsa, aye ba baatii kɔtansa ni miɛ, diekye nkpo okle kafɔɔ di bawa lɛma latansa balaatɛ Yaa ɔlaa babuɛtɛtɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Kafɔɔ aye ba nikonu mi ni ɔlaa, kɔtɔkɔ ye nlɛ, bibɔmbɔ balo lee, biɛbla dibiene bita ma. ");
INSERT INTO snw_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Batii ba ninkpaani ye nii, bikaalɛ dikusɛkusɛ bita ma. Batii ba kafɔɔ nikɔbla ye ni amumu, bipɛ ɔlaa bita Yaa diisi lɛma. ");
INSERT INTO snw_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nse otii owo kafɔɔ lɛpɛ fɔ kɔnɛɛ kootokosi, faamunikĩisa kɔnyɔɔfa kafɔɔ fatɔɔ apɛ. Nse otii owo lefũ fɔ osi awu kplɛ, faadiɛko nwɔ kalɔ ale kafɔɔ. ");
INSERT INTO snw_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Otii lele niɛkaalɛ fɔ lɛsaa, faatɔɔ. Nse otii owo lɛyɔ fɔ lɛsaa, tambuɛ falɛ dikpe ni eekplesa ni ɛɛwako. ");
INSERT INTO snw_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Lɛsaa le biomiɛ bilɛ batii babla bata ye nii, nni okle biɛɛbla bita ma nɛ. ");
INSERT INTO snw_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Nse mimbɔmbɔ batii ba nimbɔmbɔ ye ni lete, ni lɛmɛnkusɛkusɛ bibawɛ? Bia bakpileblatɛ mbɔmbɔ batii ba nimbɔmbɔ ma nii. ");
INSERT INTO snw_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ni nse batii ba nimbla ye ni dibiene lete mimbla dibiene minta, sɛmɛnfa babapɛ ye? Bia bakpileblatɛ mbla nkpo. ");
INSERT INTO snw_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ni nse minfɛnsa asaa minta batii ba lete biye bilɛ babakplesa manwako ye nii, lɛmɛnkusɛkusɛ bibawɛ? Bia bakpileblatɛ nfɛnsa asaa manta bawo alɛ baakplesa manwako ma! ");
INSERT INTO snw_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Kafɔɔ, bibɔmbɔ balo lee, biɛbla dibiene bita ma. Bifɛnsa ma asaa, kafɔɔ bitantika anu bilɛ babakplesa manwako ye kokooko. Nse biɛbla nkpo, bibawɛ letota kplɛ. Ni babalɛɛ ye alɛ Yaa wɔ ninlenke ni babi. Diekye Yaa nkpe sifutulɛ ɛɛta batii ba di asaa nimbuo ni anu ku basiensietɛ. ");
INSERT INTO snw_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Binya nyaami fɛ mmle okle di Teeye nnya ni nyaami. ");
INSERT INTO snw_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Bitankanko bawo lee, ni Yaa kafɔɔ dilɔbakanko ye. Bitanlo bawo lee lɛpɔɔ, ni Yaa kafɔɔ dilɔbalo ye lɛpɔɔ. Biyɔ bikyɛ bawo lee, ni Yaa kafɔɔ mayɔ ankyɛ ye. ");
INSERT INTO snw_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Bita batii asaa, ni Yaa kafɔɔ mata ye asaa. Nwaako, Yaa mata siwu lee nyii pɔ di sifutulɛ nɔɔ kanya. Diekye leklapoosaa le biɛyɔ biɛklapoosa biɛta ni bawo lee, nninwu okle di Yaa mayɔ anklapoosa anta ye nɛ.” ");
INSERT INTO snw_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ninfɛ di Yesu lapɛ ma lɛkpa alɛ, “Numbiɛtɛ dilɔbafuo numbiɛtɛ wo nɔɔ katũ oleko, se diele nkpo, ni banyɔ lɛma babakpa mambuo diibiɔ kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Saateketetɛ kuonwii ninlenkee saatuotɛ nɔɔ. Kafɔɔ nse saateketetɛ ntooloo asaa nɔɔ otekete, ote ante fɛ mmle di saatuotɛ nɔɔ nte nii. ");
INSERT INTO snw_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Lɛ diɛbla fɔɔnya diku biibii le ninsi ni di owo lɛfɔ ninu, kafɔɔ fɔlɔɔnya kawosoku ka ninsi fɔ ni leele kamɛ? ");
INSERT INTO snw_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Lɛ dibawa alɛ faatɔkɔ owo lɛfɔ falɛ, ‘Lekoto, owo nii, tɛɛ ndiki fɔ diku niinu.’ Kafɔɔ fɔlɔɔnya kawosoku ka ninsi fɔ ni niinu kamɛ? Afɔ laatɛ! Lekatũ fadiki kawosoku ka ninsi ni niinu lɛfɔ kamɛ fiɛ, ni fabafuo ɔnya nwaa, fandiki diku biibii le ninsi ni di obilee ninu kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Kowoso biene níntika abi lalaale, kowoso lalaale kafɔɔ níntika abi biene. ");
INSERT INTO snw_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kowoso biala, abi ya ootika ni man-yɔ mantofo kũ. Mántɛsɛ akpaloo abi di kukutuwoso suoto, nkpo kafɔ manantɛsɛ akutu di akpaloo dikũmii suoto nɛ. ");
INSERT INTO snw_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Otii biene yi, asaa biene ya eekookaa ni di otu nɔɔ kamɛ andiki asaa biene kayi ankyeko. Kafɔɔ otii kpile nnwɔɔ, asaa kpile ya eekookaa ni di otu nɔɔ kamɛ andiki asaa kpile ankyeko. Diekye asaa ya nintooyii ni otii otu kamɛ, nnya ambuɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Be lɛsaa oso biɔlɛɛ mi Saate, kafɔɔ mimbla di lɛsaa le kɔtɔkɔ ye ni suoto? ");
INSERT INTO snw_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Otii lele niɛwa ɔkyɛ nii, annu mi ɔlaa, ambla nwu di suoto, matuo ye otii wɔ ale nii. ");
INSERT INTO snw_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ate fɛ otii wɔ nikotofo ni leyo, eekutu ni kasɔ diekyofo nii, ese ni lɛsɔse nɔɔ di afuɔ suoto. Nse okle leyii, kuobiɛ kuɔbasa di seyoyiɛ nwu suoto, leyo nwu nimbla lɛsalɛsaa, diekye diɛwɛ lɛba biene diyɛ. ");
INSERT INTO snw_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Kafɔɔ otii wɔ ninnu mi ni ɔlaa anaamufũ nwu aaklee nii, ate fɛ otii wɔ nietofo ni leyo di kɔtɛ suoto lɛɛsɔse nɔɔ nnaa ni osie. Nioso nse okle leyii kuobiɛ kuɔbasa leyo nwu, nimbiɛ osie kanya wududu ninkaa kaasɔ!” ");
INSERT INTO snw_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Obe wɔ di Yesu latɔkɔ batii sɛlaa se mmle simuu aaloo nii, ni aasifi Kapernaum nɛ. ");
INSERT INTO snw_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Roma batii bakpɛtɛ nɔɔfo onwii lawɛ ninfa, aawɛ kpɛmblatɛ onwii ambɔmbɔ ni osie kanya. Kpɛmblatɛ wɔ mmle latoofiɛ osie kanya diabu kɛɛkɛɛ aakpi nii. ");
INSERT INTO snw_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Nioso obe wɔ aanu ni Yesu lɛkpanko, aakpee Yuda batii banɔɔfo bawo alɛ bakyɛ baalaatɔkɔ nwɔ aawa abayɔɔsa kpɛmblatɛ nɔɔ nwu ofiɛ atɔɔ. ");
INSERT INTO snw_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Obe wɔ baatii ba mmle lawa ni Yesu nfũ, baatikiti nwɔ lekoto osie kanya alɛ, “Osuɔtɔ wɔ mmle lesiɛko alɛ faatɔɔ lɛkyakaako, ");
INSERT INTO snw_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","diekye ambɔmbɔ kale loo. Nnwɔɔ nietofo Yuda batii kasiisakɔ ɛɛta wo nɛ.” ");
INSERT INTO snw_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Nioso Yesu lataka aatikanko ma. Obe wɔ di Yesu nfɛ kɔtɛɛtɛɛ ni bakpɛtɛ nɔɔfo nwu leyo, ni aakpee basiɛwo nɔɔ alɛ bakyɛ baalaatɔkɔ Yesu alɛ, “Saate, tankpee suoto dibuo. Diekye ami, ninsiɛko alɛ, faawa mi leyo. ");
INSERT INTO snw_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nkpo kafɔɔ ninasiɛko alɛ kawa fɔ anu nɛ. Nkpo oso afɔ buɛ ɔlaa onwii pɛ, kpɛmblatɛ nii mawɛ osie. ");
INSERT INTO snw_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Diekye ami kafɔɔ nsi di ɔnɔɔfo wɔ ninlenke mi ni kalɔ. Ni baakpɛtɛ nsi mi kaalɔ. Nse lɛtɔkɔ onwii nlɛ, ‘Akyɛ nfũ,’ ni ankyɛ nɛ. Nse lɛtɔkɔ ɔbamba nlɛ, ‘Awa ninfũ,’ ni anwa nɛ. Nse lɛtɔkɔ kpɛmblatɛ nii nlɛ, ‘Bla nle,’ ni ambla nɛ.” ");
INSERT INTO snw_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Obe wɔ di Yesu lanu ni ɔlaa wɔ aabuɛ nii, diabla nwɔ ɔkpɛ. Ninfɛ aamunikĩi aatɔkɔ batii dikudi le niatikanko nwɔ ni alɛ, “Kɔtɔkɔ ye nlɛ, diidii ninnya ofũ onu wɔ mmle okle di Israel batii kamɛ nnya!” ");
INSERT INTO snw_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Obe wɔ baatii ba baakpee ni kɔtɔ lakple baalaabuo ni leyo, baanya alɛ kpɛmblatɛ nwu sitoosie nwɔ. ");
INSERT INTO snw_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ninkpo kamaa, Yesu lakyɛ okpoo wɔ bɔɔlɛɛ ni Nain kamɛ. Basaateketetɛ nɔɔ ku batii dikudi kpinwu latikanko nwɔ. ");
INSERT INTO snw_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Obe wɔ aadu ni okpoo nwu kasũkunya, aakyakako batii kodie bakle kpi boofenko kakookaakɔ. Otii wɔ niakpi nii, obisuɔtɔbi onwii nwu pɛ aale aata kpisɔfɔ nwu nɛ. Batii dikudi kpinwu di okpoo nwu kamɛ lawɛ di kpisɔfɔ nwu ɔkyɛ. ");
INSERT INTO snw_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Obe wɔ di Yesu lanya ni ɔsanko wɔ mmle, aakpɛ nwɔ nyaamii. Ninfɛ di Yesu latɔkɔ nwɔ alɛ, “Diɛ owi.” ");
INSERT INTO snw_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ninfɛ di Yesu lafe kaamɛ lɛma aalaakpanko kpi alakaa nwu nɛ. Ninfɛ baatii ba niatuka ni kpi nwu nkpo layila nɛ. Ni di Yesu labuɛ alɛ, “Okosopo! Kɔtɔkɔ fɔ nlɛ taka!” ");
INSERT INTO snw_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nfanwu kpi nwu nkpo niataka aasiɛ, aakyako ɔkakatɛ. Ni di Yesu lakpaa nwɔ aata ɔya nɛ. ");
INSERT INTO snw_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Lɛyɛkɛ lapɛ batii nwu bamuu osie kanya, ni baatansa Yaa nɛ. Ta nkpo oso baabuɛ alɛ, “Yaa ɔlaa buɛtɛtɛ kplɛ nintɔɔwa wo kamɛ! Yaa ntoosoo ɛwa batii nɔɔ odiki!” ");
INSERT INTO snw_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Yesu suoto ɔlaa wɔ mmle lakpɛ kuakyaka Yuda kasɔ nwu suoto ku aba bule amuu. ");
INSERT INTO snw_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Obe wɔ di Yohane basaateketetɛ latɔkɔ ni Yohane sɛlaa se mmle, nfanwu aalɛɛ batii banyɔ kaamɛ lɛma. ");
INSERT INTO snw_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ni aakpee ma Saate nwu nfũ alɛ balaakaalɛ nwɔ alɛ, “Afɔ ninle otii wɔ alɛ abawa ni ɛɛ, sɛɛ buatoonyu osuku muntɔɔta otii bamba?” ");
INSERT INTO snw_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Nioso obe wɔ baawa ni Yesu nfũ, baatɔkɔ nwɔ alɛ, “Ntu kpeesatɛ Yohane lekpee wo alɛ buwa buɔbakaalɛ fɔ alɛ, ‘Afɔ ninle otii wɔ aabuɛ alɛ abawa ni ɛɛ, sɛɛ buanyu osuku munta otii bamba?’ ” ");
INSERT INTO snw_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Di obe nwu nkpo kamɛ, Yesu ntɔɔyɔɔsa batii kpinwu sifiɛ, ate ate, eetososa anwuna kpile baatii suoto, eetikiti kafɔɔ banumbiɛtɛ kpinwu anu. ");
INSERT INTO snw_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ninfɛ di Yesu ladiki kanya aatɔkɔ Yohane basaateketetɛ nwu alɛ, “Bikple biɛlaatɔkɔ Yohane asaa ya biɛnya ni ku n-ya bienu ni bilɛ, banumbiɛtɛ nfɛ kɔnya asaa, abafa nfɛ kɔtaka ankyɛ, batii ba nikofiɛ ni sifiɛ sɛɛle suoto ntɔɔkpa, batokotĩitɛ nfɛ konu, bakpi kɔtaka mansiɛ nkpa, bapiitɛ kafɔɔ nfɛ konu ɔlaa biene nwu nkpo. ");
INSERT INTO snw_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Suoto mayɔɔ batii ba ninanya ni ɔlaa kpile kuonwii di suoto nii.” ");
INSERT INTO snw_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Obe wɔ di Yohane basaateketetɛ ntoosifi beeloo nii, Yesu lakye kasɔ aatɔɔkakatɛ aatɔɔta batii dikudi nwu nkpo di Yohane suoto alɛ, “Obe wɔ biadie biakyɛ ni Yohane nfũ di ɔfaafuu kamɛ, be biatoonyu osuku bilɛ bianya? Lɛkpɛnyi le di kɔfɛɛfɔ latɔɔfɛ ni? ");
INSERT INTO snw_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Be lɛsaa biadie biakyɛ bialaanya? Otii wɔ niakpe ntu aasiɛ ni di asaa biene kamɛ? Batii ba ninlolaa suoto mansiɛ ni di suoto lɛyɔɔ kamɛ yi, baka ayo mansiɛ. ");
INSERT INTO snw_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Aye bitɔkɔ mi, be biakyɛ bialaanya? Yaa ɔlaa buɛtɛtɛ? Nwaako katɔkɔ ye nii, otii wɔ biakyɛ bialaanya ni nlenke bia Yaa ɔlaa buɛtɛtɛ. ");
INSERT INTO snw_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Diekye Yohane ninle otii wɔ di Kɔkpana Klekle Kukũ lebuɛ alɛ, ‘Makyesee tɔkyɛntɛ nii anlefɔ katũ, analolaa osuku antɛ fɔ.’ ” ");
INSERT INTO snw_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yesu lakple aatɔkɔ ma alɛ, “Yohane nlenke Otii biala beelofo ni kaayi ka mmle kamɛ. Kafɔɔ otii wɔ ninle ni ɔyɛntɛle di Yaa sɛka kalekɔ, nlenke Yohane.” ");
INSERT INTO snw_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Batii nwu nkpo bamuu lanu Yohane ɔlaa biene wɔ aabuɛ nii, kyenkye akpooto bafuntɛ lafũ Yaa dibiesaa baanu, ninfɛ aakpeesa ma Yaa ntu nɛ. ");
INSERT INTO snw_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Kafɔɔ Farisi batii ku kufiofa batuotɛ lasĩ Yaa dibiesaa, nioso Yohane ditakpeesa ma Yaa ntu. ");
INSERT INTO snw_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesu lakple aabuɛ aakyakaa alɛ, “Nunua, be lɛsaa kayɔ miɛ akyɛnfɔɔle nkaatɛɛsa ko? ");
INSERT INTO snw_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nkpo bate fɛ babisɔ ba ninsi bookpee ni kɔkyɔ di asaa kasunsukɔ nɛ. Bɔɔtɔkɔ dikudi bamba alɛ, ‘Buasa sɛkafɔɔnu buata ye, kafɔɔ biasĩ otũ. Buakpee sikunu buata ye, kafɔɔ biasĩ kaku owi.’ ");
INSERT INTO snw_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ntu kpeesatɛ Yohane lawa, aanii kanya, atanyi nta kafɔɔ diidii, biatɔkɔ nwɔ bilɛ, ‘Ninwuna kpile ninsi nwɔ!’ ");
INSERT INTO snw_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ni di ami, Otii Obi, kafɔɔ lɛwa, lele, lenyi. Ni biobuɛ bilɛ, ‘Banyu lenyatɛ ku tanyintɛ nwu lo! Ale akpooto bafuntɛ ku bakpileblatɛ siɛwo!’ ");
INSERT INTO snw_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Kafɔɔ batii ba bamuu nintikanko ni Yaa ninumbe nkpaamaa, batoodiki beetuo alɛ ninumbe nwaa dile.” ");
INSERT INTO snw_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Farisi otii onwii lalɛɛ Yesu alɛ awa abale ko nwɔ alesaa. Nioso Yesu lakyɛ leyo nɔɔ aalaasiɛ alɛ ooleko nwɔ alesaa. ");
INSERT INTO snw_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ɔsanko onwii lawɛ di okpoo nwu kamɛ, aale sɔnɔkpeetɛ. Nioso obe wɔ aanu alɛ Yesu lɛwa akpe ni di Farisi otii nwu leyo oole ni alesaa, aayɔ lebo kylɔkylɔ ninwii di nnɔnyi kɔnɔkɔnɔ layii ni aawako. ");
INSERT INTO snw_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Aabayila di Yesu ɔlɔɔkɔ, aatoowi kaku aatookpete di Yesu nkpaatũ. Ni di ɔsanko nwu nkpo layɔ disi nɔɔ sinwini aatoosunsũ nnumɛɛ be niakpete ni di Yesu nkpaa nɛ. Aafĩfĩɔ nwɔ nkpaatũ, ni aanyɛɛnɛ nnɔnyi kɔnɔkɔnɔ nwu kafɔɔ aakpete nwɔ ninkpaatũ nɛ. ");
INSERT INTO snw_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Obe wɔ di Farisi otii wɔ niakyakako ni Yesu lanya ni nle mmle, aabuɛ di disi nɔɔ kamɛ alɛ, “Nse otii wɔ mmle Yaa ɔlaa buɛtɛtɛ ale nwaako, se dikpeni antofo ɔsanko wɔ mmle otiikle wɔ ale ni fiɛ ɛɛwa ɔɔkpanko nwɔ nii!” ");
INSERT INTO snw_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ninfɛ di Yesu latɔkɔ nwɔ alɛ, “Simon, nkpe ɔlaa komiɛ nlɛ ntɔkɔfɔ nii.” Ninfɛ di Simon labuɛ alɛ, “Saatuotɛ, tɔkɔ mi ɔlaa wɔ kule ni.” ");
INSERT INTO snw_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ninfɛ di Yesu lakye kasɔ aatɔkɔ nwɔ alɛ, “Otii onwii lawɛ aatɔɔfɛnsa ato, aatɔɔta batii, ni baatii banyɔ banwii lasiɛko nwɔ koto nɛ. Onwii lasiɛko koto ko nikawo ni fɛ otii kɔwɛntɛto. Ɔnyɔɔfa kafɔɔ lasiɛko fɛ awɛntɛ lefosi kɔkpɛnto. ");
INSERT INTO snw_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Batii ba mmle banyɔ kuonwii dilɔbafuo koto nwu nkpo ɔta. Nkpo oso, ato fɛnsatɛ nwu layɔ ato ya baasiɛko nwɔ ni aakyɛ ma. Baatii ba mmle kamɛ, ɔmɛnle lɛma feenyu falɛ ababɔmbɔ ato fɛnsatɛ nwu anlenkee?” ");
INSERT INTO snw_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ninfɛ di Simon labuɛ alɛ, “Lefũ lenu nlɛ otii wɔ koto nimpɔ kulenke nii.” Ninfɛ di Yesu latɔkɔ nwɔ alɛ, “Feelolaa feebuɛ, nkpo kute nɛ.” ");
INSERT INTO snw_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Nfa nfɛ di Yesu lamunikĩi aanyu ɔsanko nwu, ni aatɔkɔ Simon alɛ, “Fɔɔnya ɔsanko wɔ mmle? Obe wɔ lɛwa ni leyo lɛfɔ, faatɛɛ ntu nfoto nkpaa, kafɔɔ ɔsanko wɔ mmle lɛyɔ nnumɛɛ nɔɔ eefoto mi nkpaa ɛɛyɔ disi sinwini nɔɔ eesunsũ mi. ");
INSERT INTO snw_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Faafũ mi fabla mi atuu ku suoto lɛyɔɔ. Kafɔɔ diɛyɔ ni di obe wɔ lɛbabuo ni nfũ, ayidiɛ mi nkpaatũ ofĩfĩɔ. ");
INSERT INTO snw_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Faatɛɛ nnɔnyi falɛ nkpee diisi. Kafɔɔ ɔsanko wɔ mmle lɛyɔ nnɔnyi kɔnɔkɔnɔ eekpeete mi ninkpaatũ. ");
INSERT INTO snw_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Nkpo oso kɔtɔkɔfɔ nlɛ, di lɛbɔmbɔ kplɛ le eediki eetuo mi ni oso, diotuo alɛ batɔɔyɔ sikpile nɔɔ se kpinwu ɛɛbla ni bɛɛkyɛ nwɔ. Otii wɔ kafɔɔ bɛɛyɔ sikpile kɛɛkɛɛ bɛɛkyɛ nii, lɛbɔmbɔ nɔɔ kafɔɔ kɛɛkɛɛ ninle.” ");
INSERT INTO snw_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Nfa nfɛ di Yesu latɔkɔ ɔsanko nwu alɛ, “Batɔɔyɔ sikpile lɛfɔ bɛɛkyɛ fɔ.” ");
INSERT INTO snw_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Obe wɔ baatii ba niasiɛ ni di alesaa kalekɔ nwu ninfa lanu ni ɔlaa wɔ di Yesu labuɛ nii, baakaalɛ suoto alɛ, “Owe ninle nwɔ ninfũ oofuo bia batii sikpile ɔyɔ ɔkyɛ ma ni?” ");
INSERT INTO snw_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ninfɛ di Yesu latɔkɔ ɔsanko nwu alɛ, “Ofũ onu lɛfɔ ntoodiki fɔ, nioso tɔɔkyɛ ku atoko ɔkyɛ ole.” ");
INSERT INTO snw_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Obe owo kamaa, Yesu lakyɛ aatookyi sekpoo ku nkpayotũ kamɛ, aatoobuɛ ɔlaa biene nwu di Yaa sɛka kalekɔ suoto. Lefosi batii banyɔ ba kafɔɔ aadiki ni latikanko nwɔ. ");
INSERT INTO snw_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Basanko ba di Yesu layɔɔsa ni sifiɛ ate ate ku mba aatososa ni anwuna kpile aadiki ni kaamɛ lɛma kafɔɔ latikanko nwɔ. Di kamɛ lɛma onwii lasiɛ baatɔɔlɛɛ ni Maria Magdalene, nwɔ kamɛ di Yesu latososa ni anwuna kpile akuɛnsĩ. ");
INSERT INTO snw_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ɔsanko bamba kafɔɔ kaamɛ lɛma niale nwɔ baatɔɔlɛɛ ni Yohana, ɔsa baatɔɔlɛɛ Kusa, aale ni Herode kakankɔ asaa nyuntɛ nɔɔfo nɛ. Basanko bamba kpinwu ku nwɔ kafɔɔ baatɔɔlɛɛ ni Susana latikanko Yesu, baatɔɔyɔ mma bamu asaa ya baatɔɔwɛ nii baatɔɔkyakaako Yesu ku basaateketetɛ nɔɔ. ");
INSERT INTO snw_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Batii kpinwu lakye sekpoo ate ate baatɔɔwa Yesu nfũ. Ni di obe wɔ baatii kpinwu ntɔɔbasi nii, Yesu lapɛ ma lɛkpa le mmle alɛ, ");
INSERT INTO snw_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Alesaa kubi santɛ onwii lakyɛ aalaasa alesaa kubi. Obe wɔ ɔɔsa ni kubi nwu koofe kamɛ, kowo lakpete di osuku suoto batii lananafu kũ, bakansiɛ kafɔɔ labasɛsɛɛ kũ baale. ");
INSERT INTO snw_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Kowo kafɔɔ lakpete di afuɔ kasɔ. Di obe wɔ kuakɔntɔ nii, kutawɛ ntu ku kasɔ nwaa kuayila. Nkpo oso kuayɔɔ kuakpi. ");
INSERT INTO snw_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Alesaa kubi nwu kowo lakpete di siwuu sɛfa kamɛ. Ni siiwuu sɛfa nwu lamuɔ siafukiti siatĩi alesaa kubi nwu kumuu nɛ. ");
INSERT INTO snw_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Alesaa kubi nwu kowo kafɔɔ lakpete di kasɔ biene suoto. Kuakɔntɔ kuamuɔ kuatika abi alafa alafa.” Di Yesu latoobuɛ ni sɛlaa se mmle, aanyɛntɛ alɛ, “Otii wɔ kuunutoko nkpe nii yi, aanu!” ");
INSERT INTO snw_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Yesu basaateketetɛ nɔɔ lakaalɛ nwɔ lɛkpa nwu nkpo kasɔ. ");
INSERT INTO snw_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ninfɛ aatɔkɔ ma alɛ, “Aye beediki lɛsaatofo le niewofa ni di Yaa sɛka kalekɔ beetuo. Kafɔɔ batii bule akpa kamɛ bɛyɔ bɛɛta ma alɛ, ‘Babanya asaa, kafɔɔ blɔbanya batɛ nsũ. Babanu kafɔɔ, blɔbanu kasɔ.’ ");
INSERT INTO snw_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Lɛkpa nwu lɛsɔdiki ninle nle mmle nɛ. Alesaa kubi nwu nkpo baasa ni ninle Yaa ɔlaa nɛ. ");
INSERT INTO snw_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Alesaa kubi nwu nkpo niakpete ni di osuku suoto ninle batii ba, nse beenu ɔlaa nwu nkpo, Abonsam nwa amadiki nwu di situ lɛma kamɛ, mmle manaafũ banu alɛ Yaa kadiki ma anta ma ni nkpa. ");
INSERT INTO snw_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Nko kafɔɔ niakpete ni di afuɔ kasɔ suoto, ninle batii ba nse beenu ɔlaa nwu nkpo, manfũ nwu ku suoto lɛyɔɔ. Kafɔɔ kumbuo ma kaamɛ nwaa. Manfũ nwu manu di obe kakuii kamɛ. Nkpo oso nse ɔsɔ onyu lɛwa ma di suoto, mankple nkpaamaa. ");
INSERT INTO snw_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Alesaa kubi ko kafɔɔ niakpete ni di siwuu sɛfa kamɛ ninle, batii ba nienu ni ɔlaa nwu nkpo, kafɔɔ kayika mmle nimiina ku lɛsaawɛ ku kayi suoto omɛnɛfɛ okpee nfukiti nintĩi ma, mámmuɔ baatika abi. ");
INSERT INTO snw_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Alesaa kubi ko niakpete ni di kasɔ biene suoto, ninle batii ba nse beenu ɔlaa biene nwu nkpo, mammufũ nwu manklee ku situ biene. Manwakosa suoto kasɔ mankpee okyiini ninaadu obe wɔ beetika ni abi. ");
INSERT INTO snw_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Otii kuonwii ninsɔ kandiɛ, aayɔ lɛsaa aatĩi nwɔ. Ee aayɔ ase di mpa kalɔ. Kafɔɔ antakatɛsa kandiɛ nwu antika lɛɛba le niɛtaka nii, alɛ aakpa anta batii ba nikɔwa ni leyo nwu kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Lɛsaa lele niewofa kaakɔ lele, babadiki ni kayi. Lelele kafɔɔ beetĩi bɛɛtɛ diitunu kamɛ, babanya ni mandiki ni manwako lɛkpa kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Bilolaa atoko bikyɔɔ di sɛlaa se bianu ni suoto. Otii wɔ nienu, eenu ni kasɔ, abakple annu kasɔ anlenkee bia. Otii wɔ ninankyɔɔ ni atoko, kɛɛkɛɛ wɔ eenyu alɛ eenu nii bia, babakle manfũ nwɔ ninnɛɛ mansifiko.” ");
INSERT INTO snw_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yesu ɔya ku Yesu basuɔtɔbi lɛma lawa nwɔ ɔnya, kafɔɔ batafuo nwɔ ɔnya, ta batii dikudi nwu oso. ");
INSERT INTO snw_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ninfɛ baatii bawo lakyɛ baalaatɔkɔ Yesu alɛ, “Yaafɔ ku babilee suɔtɔbi n-yɛ kaayi boomiɛ alɛ banya fɔ.” ");
INSERT INTO snw_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ninfɛ di Yesu latɔkɔ bamuu lɛma alɛ, “Yaami ku babiloo suɔtɔbi ninle batii ba nikonu ni Yaa ɔlaa bɔɔbla nwu ni di suoto nɛ.” ");
INSERT INTO snw_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Dii ninwii, Yesu labuo di oklo kamɛ ku basaateketetɛ nɔɔ. Ni aatɔkɔ ma alɛ, “Bita butaalɛ busifi lekpo le mmle sɛmaa.” Nkpo oso baayefe osuku baakyako osifi. ");
INSERT INTO snw_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Obe wɔ batika ni di ntu osi bɔɔkyɛ nii, Yesu lakyɔsĩi. Nfanwu, kɔfɛɛfɔ siene kunwii niakyako ɔfɛ di ntu nwu osi, ntu lakyako ɔpɛ obuo di oklo nwu kamɛ. Nioso diata alɛ baasiɛ di kukpi ku nkpa ntɛɛ. ");
INSERT INTO snw_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Nioso basaateketetɛ nɔɔ nwu nkpo lakyɛ baalaasɛnkɛsa Yesu, baatɔkɔ nwɔ alɛ, “Ɔnɔɔfo, ɔnɔɔfo! Nfɛ buokpi lo!” Ninfɛ di Yesu lataka aayila aamuɛ kɔfɛɛfɔ ku ntu nwu nikɔkpɛ ni suoto, ni diate kloklo dialo kanana nɛ. ");
INSERT INTO snw_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ni aakaalɛ basaateketetɛ nɔɔ alɛ, “Fɛ di ofũ onu lee nkpe?” Kafɔɔ oyila ko baayila baatoonyu yaaa, lɛyɛkɛ kafɔɔ lapɛ ma. Ni baatɔɔkaalɛ bawo alɛ, “Ɔmɛntii okle ninle nwɔ? Ankakatɛ anta kɔfɛɛfɔ ku ntu be nikɔkpɛ ni alɛ ankyɔɔ nwɔ atoko!” ");
INSERT INTO snw_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesu ku basaateketetɛ nɔɔ lataalɛ baalaadu Galilea lekpo kotoko kakyɛ nyɔɔfa di Gadara kasɔ suoto. ");
INSERT INTO snw_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Obe wɔ di Yesu lasoo ni di oklo, osuɔtɔ onwii di anwuna kpile nsi ni ladie aakye okpoo nwu kamɛ abakyakako nwɔ. Ditɔɔklɛ di osuɔtɔ wɔ mmle disinkpee ni awu, ánsiɛ kafɔɔ leeyo. Sɛkya kamɛ ko ansiɛ. ");
INSERT INTO snw_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Di obe wɔ aanya ni Yesu, aayiisa kudu osie kanya aapɛ akunkyi di Yesu katũ. Ni aabuɛ alɛ, “Yesu, Yaa wɔ ninlenke ni Obi! Ɔmɛnlaa ninsi munkofɔ ntɛɛ? Kotikiti fɔ lekoto, tannanfi mi kootoko.” ");
INSERT INTO snw_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Osuɔtɔ wɔ mmle labuɛ nkpo, diekye Yesu lamuɛ ninwuna kpile nwu ninsi nwɔ ni kaamɛ alɛ, “Didie nwɔ kaamɛ!” Obe kpinwu kamɛ ninwuna kpile nwu mmufũ osuɔtɔ nwu nkpo, nse beekpee nwɔ nkɔkyɔ ninnɛɛ ku nkpaa, anfefee mi kafɔɔ. Ninwuna nwu nkpaa nwɔ ninsifiko ɔfaafuu kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu lakaalɛ nwɔ alɛ, “Lɛ manlɛɛ fɔ?” Ninfɛ aatɔkɔ Yesu alɛ, “Ami manlɛɛ dikudi nɛ.” Aabuɛ nkpo diekye anwuna kpile nwu nsi nwɔ kaamɛ apɔ. ");
INSERT INTO snw_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ninfɛ di anwuna nwu nkpo latikiti Yesu lekoto alɛ, atantososa ma aakpee di lɛba le manfuki anwuna kpile mankpee ni di dibiɔ le ninaani kase, diibuo nsi ni kaamɛ. ");
INSERT INTO snw_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Aplakuo ɔlambu kplɛ onwii latoole alesaa di kabokotee nkpaa ninfa. Ni di anwuna kpile nwu latikiti Yesu lekoto alɛ, ata ma balaabuo di aplakuo nwu kamɛ. Ninfɛ di Yesu lata ma osuku nɛ. ");
INSERT INTO snw_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Nfanwu anwuna kpile nwu ladie di osuɔtɔ nwu kamɛ aalaabuo di aplakuo nwu kamɛ. Ni di aplakuo ɔlambu nwu latoso kitikiti aakye kabokotee nwu nkpaa aalaakpa aabuo diɛ lekpo kamɛ aamɛmɛɛ ntu aakpi nɛ. ");
INSERT INTO snw_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Obe wɔ baatii ba niatɔɔkpa ni aplakuo nwu lanya lɛsaa le niawa nii, baatoso baasifi sekpoo simuu ku afe kamɛ baalaabuɛ ɔlaa nwu baakyakasa. ");
INSERT INTO snw_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Nioso batii ladie baakyɛ alɛ bɔɔlaanyu lɛsaa le niawa nii. Di obe wɔ babadu ni Yesu nfũ, baanya osuɔtɔ wɔ di Yesu latososa ni anwuna kpile nwu aadiki ni kaamɛ nsi di Yesu nkpaatũ. Ditɔɔkpa nwɔ eekpee awu asi kloklo. Bamuu lɛma, lɛyɛkɛ lapɛ ma. ");
INSERT INTO snw_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Batii ba nianya mmle okle diawa nii, latɔkɔ batii bule mmle okle diabla fiɛ diakpa ni osuɔtɔ wɔ kamɛ diɛ anwuna kpile lasiɛ nii. ");
INSERT INTO snw_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Nkpo oso ntɛɛ nwu batii bamuu di Gadara kasɔ lawa babatikiti Yesu lekoto alɛ, adie ma kaasɔ suoto asifi, diekye baayɛkɛ. Nkpo oso Yesu labuo di oklo kamɛ aasifi. ");
INSERT INTO snw_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Osuɔtɔ wɔ kamɛ di Yesu latososa anwuna kpile nwu aadiki ni kaamɛ, latikiti Yesu lekoto alɛ, “Tɛɛ ntikanko fɔ.” Kafɔɔ Yesu ditatuna ni aatɔkɔ nwɔ alɛ, ");
INSERT INTO snw_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Tɔɔkyɛ leyo, faalaabuɛ lɛsaa le di Yaa lɛbla ɛɛta fɔ ni.” Ninfɛ di osuɔtɔ nwu nkpo lakple aasifi okpoo nwu kamɛ aalaatoobuɛ lɛsaa le di Yesu labla atɔɔ ni nɛ. ");
INSERT INTO snw_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Di obe wɔ di Yesu lakple aataalɛ lekpo nwu aasifi nii, batii nwu nkpo lafũ nwɔ osie kanya, diekye bamuu lɛma baatoonyu nwɔ osuku. ");
INSERT INTO snw_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ninfɛ di osuɔtɔ onwii baatɔɔlɛɛ ni Yairo, ale ni Yuda batii kasiisakɔ ɔnɔɔfo lawa abapɛ akunkyi di Yesu nkpaatũ aatikiti nwɔ lekoto alɛ, awa baakyɛ leyo nɔɔ, ");
INSERT INTO snw_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","diekye obi nɔɔ sankobi onwii wɔ ninkpe nwɔ ni, atoofũ ni fɛ lefosi alɛɛ anyɔ, latookpi. Obe wɔ di Yesu layefe osuku oofe nii, batii kpinwu latikanko nwɔ baamana nwɔ kpinkpĩ baakyi. ");
INSERT INTO snw_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Baatii nwu nkpo kamɛ, ɔsanko onwii diɛ asaa latoowii ni osie kanya fɛ lefosi alɛɛ anyɔ lasiɛ kaamɛ. Ɔsanko wɔ mmle ntɔɔlalaasa koto nɔɔ kumuu di bafatɛ sɛkyɛ alɛ diayɔɔ nwɔ, kafɔɔ kuonwii ditafuo nwɔ kɔfa ɔbla. ");
INSERT INTO snw_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Nioso aafe di Yesu sɛmaa di batii nwu kamɛ, aalaakpanko nwɔ awu kotokosi. Nfanwu, asaa owii nwu niabudi. ");
INSERT INTO snw_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ninfɛ di Yesu lakaalɛ alɛ, “Owe niɛkpankoe?” Kafɔɔ kuonwii ditabuɛ alɛ nnwɔɔ niɛkpanko nwɔ. Ninfɛ di Petro lakaalɛ nwɔ alɛ, “Saate, nyu mmle okle baatii nwu lɛmana fɔ kpinkpĩ beekyi ni!” ");
INSERT INTO snw_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Kafɔɔ Yesu labuɛ alɛ, “N-ye nlɛ otii lɛkpankoe, diekye osie owo ledie mi kaamɛ.” ");
INSERT INTO snw_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Obe wɔ di ɔsanko nwu lanya alɛ Yesu ntootofo lɛsaa le aabla nii, atafuo suoto owofasa. Aadie aawa aabapɛ akunkyi di Yesu katũ ku ditũtũkũ di batii nwu anu. Ninfɛ aadiki aabuɛ lɛsaa le oso aakpanko nwɔ nii, ku mmle di ofiɛ nwu layɔɔ nwɔ ni ninfanwu nɛ. ");
INSERT INTO snw_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Nkpo oso Yesu latɔkɔ nwɔ alɛ, “Obi nii sankobi, ofũ onu lɛfɔ ntɔɔyɔɔsa fɔ ofiɛ. Tɔɔkyɛ di atoko ɔkyɛ ole kamɛ.” ");
INSERT INTO snw_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Di obe wɔ di Yesu lekple akle ɔlaa nwu oobuɛ nii, tɔkyɛntɛ onwii niakye Yuda batii kasiisakɔ ɔnɔɔfo Yairo leyo aawa lɛba nwu. Ni aabatɔkɔ nwɔ kanya alɛ, “Obi lɛfɔ sankobi nwu ntookpi kofokofoko. Nioso taansinkpɛnsa saatuotɛ ninwuna odiki!” ");
INSERT INTO snw_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Kafɔɔ di Yesu lanu ni ɔlaa nwu nkpo, aatɔkɔ Yairo alɛ, “Tanyɛkɛ. Afɔ fũ fanu falɛ obi lɛfɔ nwu dibayɔɔ nwɔ.” ");
INSERT INTO snw_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Obe wɔ di Yesu labuo ni Yairo leyo yi, atata osuku alɛ otii kuonwii abuo leyo nwu kamɛ ku nnwɔɔ, diediki Petro ku Yakobo ku ɔsankobi nwu ote ku ɔya lete aata osuku baabuo. ");
INSERT INTO snw_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Batii bamuu ninfa layila baatoowi kaku ta obisɔ nwu oso. Ninfɛ di Yesu latɔkɔ ma alɛ, “Bitansinwi kaku, obisɔ nwu diekpi ɔkyɔsĩi ɔɔkyɔsĩi.” ");
INSERT INTO snw_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ninfɛ baatii nwu bamuu lama nwɔ nɛ, diekye baye alɛ atookpi. ");
INSERT INTO snw_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ninfɛ di Yesu lamufũ nwɔ di kanɛɛtũ, ni aalɛɛ nwɔ alɛ, “Obi nii, taka!” ");
INSERT INTO snw_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nfanwu ɔsankobi nwu ninwuna niakple diabuo, aasɛnkɛ. Ninfɛ di Yesu latɔkɔ ma alɛ, bamiɛ lɛsaa batɔɔ ale. ");
INSERT INTO snw_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Lɛsaa le mmle labla ɔsankobi nwu balofotɛ ɔkpɛ, kafɔɔ Yesu lakpee ma kufiofa alɛ, batantɔkɔ otii kuonwii lɛsaa le niɛwa nii. ");
INSERT INTO snw_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Nni kamaa, Yesu lalɛɛ basaateketetɛ nɔɔ lefosi banyɔ nwu asiisa, ni aadiki ma osuku aata ma kafɔɔ otumi alɛ baayɔ mantososa anwuna kpile amuu, manyɔɔsa sifiɛ ate ate kafɔɔ. ");
INSERT INTO snw_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ninfɛ aakpee ma alɛ batɔɔkyɛ baalaabuɛ Yaa sɛka kalɛkɔ sɛlaa bata batii, baayɔɔsa bafiɛtɛ sifiɛ. ");
INSERT INTO snw_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Fiɛ nfɛ babasifi nii, Yesu latɔkɔ ma alɛ, “Bitan-yɔ lɛsalɛsaa biaklee di osuku nwu biofe ni kamɛ. Bitanklee ɔkyɛnwoso, ee asaa ɔkaalɛ kotofo ee alesaa ee koto. Bitanklee bia osi awo nyɔɔfa. ");
INSERT INTO snw_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Kakɔ lele beefũ ye, biesiɛ leeyo nwu nkpo dilaase di dii le bibadie ni di okpoo nwu nkpo kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Nse baafũ ye di okpoo owo kamɛ, nfɛ biodie ninfa minsifi, biɛfɛntɛ nkpaasɔ lee kɔtɛ bitɛ ma. Nni nimatuo alɛ baasĩ ye ofũ nɛ.” ");
INSERT INTO snw_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ninfɛ di basaateketetɛ nwu nkpo lasifi, baakyɛ baalaakyi nkpayotũ mmuu kamɛ, baabuɛ Yaa ɔlaa biene nwu baayɔɔsa kafɔɔ batii sifiɛ kaakɔ biala. ");
INSERT INTO snw_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Obe wɔ di Herode wɔ niatoole ni sɛka di Galilea kasɔ lanu ni asaa ya niatɔɔwa nii, aakpɔkpɔtɔ. Diekye batii bawo latoobuɛ alɛ, Ntu Kpeesatɛ Yohane nintookple ɛɛtaka eekye bakpi kamɛ ɛɛwa. ");
INSERT INTO snw_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Batii bamba kafɔɔ latoobuɛ alɛ, Elia ntookple ɛɛwa. Ni baawo kafɔɔ latoobuɛ alɛ Yaa ɔlaa buɛtɛtɛ owo nintookple ɛɛtaka ɛɛwa ninkpa. ");
INSERT INTO snw_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ni di Herode labuɛ alɛ, “Ami niata baabudi Yohane disi, ni owe ninle otii wɔ mmle suoto konu sɛlaa se mmle nkyeko ni?” Nkpo oso Herode latoomiɛ osuku wɔ abafe annya ni Yesu. ");
INSERT INTO snw_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Obe wɔ baasaateketetɛ nwu nkpo lakple baawa nii, baatɔkɔ Yesu asaa ya amuu baabla nii. Ninfɛ di Yesu lakpaa lete lama aasifiko okpoo wɔ bɔɔlɛɛ ni Betsaida nɛ. ");
INSERT INTO snw_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Obe wɔ baatii kpinwu lanu nii, ni baatikanko nwɔ baakyɛ nfa nɛ. Yesu kafɔɔ lafũ ma, ni aakakatɛ aata ma di Yaa sɛka kalekɔ suoto nɛ. Ni aayɔɔsa mba niatoofiɛ ni kaamɛ lɛma sifiɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Obe wɔ kuufĩ nfɛ kofe ni ɔmɛɛ, ninfɛ di basaateketetɛ nɔɔ lefosi banyɔ nwu nkpo lawa Yesu nfũ baabatɔkɔ nwɔ alɛ, “Ta batii nwu nkpo batɔɔkyɛ nkpayotũ ku afe ya baatii nte ni, ɛɛtɛtɛɛ wo ni kamɛ, baalaamiɛ alesaa ku ntenkɔ. Diekye lɛba le bukpe nii ayo nnaa ninfũ.” ");
INSERT INTO snw_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Kafɔɔ Yesu latɔkɔ ma alɛ, “Aye bamu bimiɛ alesaa bita ma bale.” Nfa nfɛ baatɔkɔ Yesu alɛ, “Alesaa ya bukle ni ninfũ ninle bloblo akudi anɔɔ ku kɔkpaku kɔnyɔ, sɛɛ foomiɛ falɛ bukyɛ buɔlaaya alesaa buwako banankpantii ba?” ");
INSERT INTO snw_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Basuɔtɔ ba niawɛ ni ninfa kabla fɛ nkpe nnɔɔ. Ninfɛ di Yesu latɔkɔ basaateketetɛ nɔɔ nwu alɛ, “Bita batii nwu nkpo basiɛ kaasɔ akudi akudi. Diikudi ninwii dibla fɛ batii afosi anɔɔ.” ");
INSERT INTO snw_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Di basaateketetɛ nwu labla nkpo baalo nii, ");
INSERT INTO snw_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ninfɛ di Yesu layɔ bloblo akudi anɔɔ ku kɔkpaku kɔnyɔ nwu nkpo, ni aatakatɛsa anu aanyu osi nɛ. Ninfɛ aapɛ Yaa sɛfa diisi lɛnya nɛ. Ninfɛ abɛbɛɛ nya aayɔ aata basaateketetɛ nɔɔ alɛ basɛ bata batii nwu nɛ. ");
INSERT INTO snw_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Bamuu lɛma baale baamiɛ, ni basaateketetɛ nwu lasiisa kɔkyɛɛ kɔkyɛɛ ko niabu ni nɛ. Kuayii lefosi nkyikyɛ nnyɔ. ");
INSERT INTO snw_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Dii ninwii obe wɔ di Yesu lete latɔɔpɛ ɔlaa aatɔɔta ni Yaa, basaateketetɛ nɔɔ lawa ɔkyɛ nɔɔ. Ni aakaalɛ ma alɛ, “Owe baatii kobuɛ alɛ nnle?” ");
INSERT INTO snw_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ninfɛ baatɔkɔ nwɔ alɛ, “Batii bawo kobuɛ alɛ Ntu Kpeesatɛ Yohane fale. Bawo kafɔɔ kobuɛ alɛ, Elia fale. Fiɛ baawo kafɔɔ kobuɛ alɛ, aaa Yaa ɔlaa buɛtɛtɛ onwii nintookple ɛɛtaka ɛɛwa ninkpa.” ");
INSERT INTO snw_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ninfɛ aakaalɛ ma alɛ, “Ni aye mɔ, owe biobuɛ bilɛ nnle?” Ninfɛ di Petro ladiki kanya alɛ, “Afɔ ninle Kristo wɔ bɛɛpɛ ni ɔfɔɔ nɛ.” ");
INSERT INTO snw_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ninfɛ di Yesu laakpee ma kufiofa osie kanya alɛ, batantɔkɔ otii kuonwii ɔlaa wɔ mmle. ");
INSERT INTO snw_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Yesu lakple aatɔkɔ ma alɛ, “Dikpe ni, ami, Otii Obi nwu, lefe di dibuo kamɛ di okpoo banɔɔfo ku olebatatɛ banɔɔfo ku kufiofa batuotɛ nnɛɛ kamɛ, beesĩ mi, beelo mi. Kafɔɔ di dii tiɛfa kamɛ, Yaa makple ansɛnkɛsɛɛ ankyeko bakpi kamɛ anwako nkpa.” ");
INSERT INTO snw_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ninfɛ di Yesu latɔkɔ bamuu lɛma alɛ, “Nse otii owo komiɛ alɛ awa abatikankoe, ni dikpe nii ansĩ suoto nɔɔ, an-yɔ aatoo nɔɔ, antikankoe dii biala. ");
INSERT INTO snw_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Diekye otii lele nikomiɛ alɛ ata nkpa nɔɔ, abayu mi. Kafɔɔ otii lele nieyu nkpa nɔɔ ta ami otikanko oso, nwaako, abawɛ nkpa. ");
INSERT INTO snw_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Lɛmɛntota biene di otii mawɛ nse ɛɛwɛ kayi ka mmle asa amuu eeyu nkpa nɔɔ? ");
INSERT INTO snw_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Nse ami ku asaatuo nii ya kotuo ni amuu lɛkpɛ otii owo sinunsɔ, otii nwu kafɔɔ makpɛ, ami, Otii Obi nwu, sinunsɔ di obe wɔ mawa ni lɛɛkpa nii kamɛ ku Yaa batɔkyɛntɛ klekle bamuu lɛkpa kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nwaako, kɔtɔkɔ ye nlɛ batii bawo nsi kaamɛ lee ninfũ, bɔlɔɔwa ɔbakpi diɛlase di obe wɔ di Yaa lediki sɛka nɔɔ kalekɔ eetuo ma nii.” ");
INSERT INTO snw_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Fɛ nanwɔkyĩ sɛmaa di Yesu labuɛ ni sɛlaa se mmle, aakpaa Petro ku Yohane ku Yakobo aasifiko kabokotee kanwii osi alɛ, bɔɔlaapɛ ɔlaa manta Yaa. ");
INSERT INTO snw_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Obe wɔ ɔɔpɛ ɔlaa anta ni Yaa, anu nɔɔ lakyi. Awu nɔɔ kafɔɔ lapu fututu aatoosese di anu. ");
INSERT INTO snw_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Nfanwu, ni baasuɔtɔ banyɔ banwii labayila baatɔɔkakatɛ ko nwɔ nɛ. Basuɔtɔ nwu niale Mose ku Elia nɛ. ");
INSERT INTO snw_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Baakyɔɔ di Yaa kafɔɔ leklekle kamɛ, ni bakakatɛko Yesu di osuku wɔ suoto abafe anyɛntɛ lɛsaa le di Yaa komiɛ ni kuukpi nɔɔ kamɛ di Yerusalem nɛ. ");
INSERT INTO snw_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petro ku bawo nɔɔ labuo sɛɛkyɔsi kamɛ osie kanya, kafɔɔ baasɛnkɛ baanya leklekle le kamɛ di Yesu lasiɛ nii ku batii banyɔ ba niayila nwɔ ni di ɔlɔɔkɔ. ");
INSERT INTO snw_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Obe wɔ baatii nwu nkpo latoosifi nii, Petro latɔkɔ Yesu alɛ, “Saate, nwaako nfũ mmle loo ɔwa lɛtɛ dilɛ! Ta bupɛ akpanta atiɛ ninfũ. Anwii alefɔ, anwii Mose ale, anwii kafɔɔ Elia ale.” Atatɛ aatofo bia ɔlaa wɔ aatoobuɛ nii. ");
INSERT INTO snw_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Di obe wɔ eekple ayɛ ɔɔkakatɛ nii, dituntũ ninwii lasoo diawa, diablɛfɛ diatĩi ma suoto. Basaateketetɛ nwu nkpo layɛkɛ obe wɔ diituntũ le mmle lakyɔɔ ma ni di suoto. ");
INSERT INTO snw_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ninfɛ di sɛlɔ ladie di dituntũ nwu kamɛ siabuɛ alɛ, “Nnya Obi nii ninle nnwɔ nɛ. Nnwɔ lediki nii bikyɔɔ nwɔ atoko!” ");
INSERT INTO snw_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Obe wɔ sɛɛlɔ nwu laloo ni ɔkakatɛ, baanya nii, Yesu lete nfɛ niabu aayila. Basaateketetɛ nwu layɔ asaa ya baanya ni ninfa baakookaa, batabɛ kanya baatɔkɔ otii kuonwii di obe nwu nkpo kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kaleesɛ, Yesu ku basaateketetɛ nɔɔ nwu batiɛ lasoo baakye kabokotee nwu nkpo osi baawa. Ninfɛ baatii kpinwu lawa babakyaka ko nwɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ninfɛ di osuɔtɔ onwii lafaa osie kanya aabuɛ alɛ, “Saatuotɛ! Kotikiti fɔ lekoto, nyu obi nii! Obi nwu onwii Pɛ! ");
INSERT INTO snw_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ninwuna kpile ninwii nkpɛko nwɔ, ninta alɛ nfanwu, anyiisa kudu osie kanya. Ambensa suoto anfuki nwɔ anlaasa kaasɔ, afuuta ntoodie nwɔ kaanya. Nse diɔkpɛko nwɔ nkpo ninwɛ osie fiɛ niinwuna nwu ndiɛ nwɔ. ");
INSERT INTO snw_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Letikiti basaateketetɛ lɛfɔ lekoto nlɛ batososa ninwuna kpile nwu batɛɛ, kafɔɔ baafuo ni otososa.” ");
INSERT INTO snw_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ninfɛ di Yesu latɔkɔ ma alɛ, “Aye, miɛ akyɛnfɔɔle, be oso biloofũ mi binu, biɔbla otokopĩ nkpo? Ɔmɛmbe okle biomiɛ bilɛ nsiɛko ye naase? Ɔmɛmbe okle kakpee otu nnanfi ye nnaase?” Ni aatɔkɔ osuɔtɔ nwu alɛ, “Kpaa obi lɛfɔ nwu fawako ninfũ.” ");
INSERT INTO snw_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Obe wɔ di ote kɔkpaa nwɔ aanwako nii, nfanwu, ninwuna kpile nwu niapɛ nwɔ diatɛ kaasɔ aakyako ɔnananfi tii. Ninfɛ di Yesu lamuɛ ninwuna nwu aadiki di obisɔ nwu nkpo kamɛ, aayɔɔsɔɔ ofiɛ, aakpaa nwɔ aata ote nɛ. ");
INSERT INTO snw_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Diabla batii nwu bamuu ɔkpɛ di Yaa otumi kplɛ wɔ mmle suoto. Obe wɔ di asaa ya amuu di Yesu labla ni latɔɔbla ni batii nwu ɔkpɛ oso, Yesu latɔkɔ basaateketetɛ nɔɔ alɛ, ");
INSERT INTO snw_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Bitanyee lɛsaa le lakye kasɔ latɔɔtɔkɔ ye nii! Babayɔ ami, Otii Obi nwu, mankpee di batii nnɛɛ kamɛ.” ");
INSERT INTO snw_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Kafɔɔ basaateketetɛ ba mmle ditanu ɔlaa wɔ mmle kasɔ. Dile lɛsaa le baayɔ baawofasa ma nii, kafɔɔ baayɛkɛ nwɔ ɔlaa ɔkaalɛ di ɔlaa nwu suoto. ");
INSERT INTO snw_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Kananfi kanwii labuo di basateketetɛ nwu ntɛɛ alɛ, owe niefũ kɔya kaamɛ lɛma alenke. ");
INSERT INTO snw_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Di Yesu latofo lɛsaa le disi baatoobu ni oso aayɔ obisɔ onwii aase diɛ anu lɛma di katũ nɔɔ. ");
INSERT INTO snw_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ninfɛ aatɔkɔ ma alɛ, “Otii wɔ niefũ obisɔ wɔ mmle leeyooto nii kamɛ, ami eefũ. Otii wɔ kafɔɔ niefũ mi nii, eefũ otii wɔ niekpee mi ni kɔtɔ. Diekye otii wɔ niɛwakosa ni suoto kasɔ nnwɔɔ niefũ kɔya alenke bamuu nɛ.” ");
INSERT INTO snw_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ninfɛ di Yohane latɔkɔ Yesu alɛ, “Ɔnɔɔfo, buanya osuɔtɔ onwii kotososa anwuna kpile baatii suoto leeyoto lɛfɔ kamɛ, ni buatɔkɔ nwɔ bulɛ adiɛ, diekye aasi wo kaamɛ.” ");
INSERT INTO snw_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ninfɛ di Yesu latɔkɔ basaateketetɛ nɔɔ alɛ, “Bitantĩi nwɔ osuku. Diekye otii wɔ ninantaka ayila wo ni di suoto, bitofo bilɛ, ni ayɛ wo kamaa.” ");
INSERT INTO snw_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Di obe ntɔɔtɛɛtɛɛ alɛ Yaa kakpaa Yesu ansifiko ni osi, aabla disibu, aadie aayefe osuku aatoofe Yerusalem. ");
INSERT INTO snw_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Aakyesee batɔkyɛntɛ bawo alɛ balekatũ basɔ kakpayotũ kanwii kamɛ di Samaria, balaalolaa asaa batɛ bata ɔwa nɔɔ. ");
INSERT INTO snw_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Kafɔɔ di okpoo nwu batii latofo alɛ ɔwaalɛ ɔɔwalɛ anfe ni Yerusalem oso, batatuna alɛ boofũ nwɔ. ");
INSERT INTO snw_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Di obe wɔ di basaateketetɛ nɔɔ ba ninle ni Yohane ku Yakobo latofo nii, baalɛɛ Yesu alɛ, “Saate, foomiɛ falɛ bulɛɛ ɔtɔ kuookye osi kuwa kubawɔɔsa ma?” ");
INSERT INTO snw_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ninfɛ di Yesu lamunikĩi aasĩ ɔlaa aata ma nɛ. ");
INSERT INTO snw_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ninfɛ di Yesu ku basaateketetɛ nɔɔ lawaalɛ baasifi kakpayotũ bamba nɛ. ");
INSERT INTO snw_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Obe wɔ bakyɛ di osuku boofe nii, osuɔtɔ onwii lawa aabatɔkɔ Yesu alɛ, “Saatuotɛ, kakɔ lele fabakyɛ, matikanko fɔ.” ");
INSERT INTO snw_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ninfɛ di Yesu latɔkɔ nwɔ alɛ, “Nkpikiti nkpe atuɛ ya kamɛ mansiɛ nii, bakansiɛ nkpe ayo mante nii. Kafɔɔ ami Otii Obi, nnaa lɛba katɛ ni disi.” ");
INSERT INTO snw_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ni di Yesu latɔkɔ otii bamba alɛ, “Tikankoe.” Kafɔɔ otii nwu labuɛ alɛ, “Saate, tɛɛnkyɛ ninakookaa teemi fiɛ.” ");
INSERT INTO snw_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ninfɛ di Yesu latɔkɔ nwɔ alɛ “Ta batii ba ninte ni fɛ bakpi bakookaa mma bamu bakpi lɛma. Kafɔɔ afɔ yi, tɔɔkyɛ falaabuɛ Yaa sɛka kalekɔ ɔlaa nwu.” ");
INSERT INTO snw_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Otii bamba kafɔɔ latɔkɔ Yesu alɛ, “Saate, matikanko fɔ. Kafɔɔ tɛɛ osuku ninkyɛ naata batii nii bamu letofo fiɛ.” ");
INSERT INTO snw_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ninfɛ di Yesu latɔkɔ nwɔ alɛ, “Otii wɔ nfɛ ninkle ni lɛnwa ayɛ ni katũ, ookple annyu ni sɛmaa, diesiɛko ata Yaa sɛka kalekɔ nwu ɔkpɛ.” ");
INSERT INTO snw_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Nle mmle sɛmaa, Saate nwu ladiki basuɔtɔ afosi akuɛnsĩ basuɔtɔ banyɔ bamba, aakpee ma banyɔ banyɔ alɛ bakyɛ sekpoo ku nkpayotũ be kamɛ ɔɔwa ni ɔbakyɛ. ");
INSERT INTO snw_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ni aatɔkɔ ma alɛ, “Ofiɛlɛ nwu mpɔ, kafɔɔ bafiɛlɛtɛ diɛpɔ. Nkpo oso bipɛ ɔlaa bita Saate nwu nimba ni ofiɛlɛ nwu nkpo bilɛ, aakyesee bafiɛlɛtɛ mamakyakaako di ofiɛlɛ nwu nkpo kamɛ mansiisa.” ");
INSERT INTO snw_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Bitɔɔkyɛ! Kokyesee ye fɛ afosobi di bakplɛle kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Bitanklee koto lekpeesa ee asaa ɔkaalɛ kotofo ee ntokota. Bitanyila di osuku kafɔɔ bilɛ biɔsɛɛsa otii kuonwii. ");
INSERT INTO snw_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Leyo lele kamɛ biebuo, bile katũ bisɛɛsa ma bilɛ, ‘Atoko ɔkyɛ ole disiɛko leyo le mmle batii.’ ");
INSERT INTO snw_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Kafɔɔ nse otii wɔ nimbɔmbɔ ni atoko ɔkyɛ ole owo nkpe ninfa, ni biɛta atoko ɔkyɛ ole lee ditikanko nwɔ. Kafɔɔ nse kuonwii nnaa yi, ni biɛta atoko ɔkyɛ ole lee dikple diwa ye ɔkyɛ. ");
INSERT INTO snw_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Bikple bisiɛ di leyo le kamɛ beefũ ye ni. Bile, bienyi lɛsaa lele bɛɛta ye, diekye kpɛmblatɛ ninfũ koto. Bitandie leeyo lewo kamɛ, biasifi lɛbamba kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Okpoo lele kamɛ biɛkyɛ, beefũ ye yi, biele lɛsaa lele bɛɛta ye. ");
INSERT INTO snw_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Biɛyɔɔsa bafiɛtɛ ba ninkpe ni di okpoo nwu kamɛ sifiɛ. Biɛtɔkɔ okpoo nwu batii bilɛ, ‘Yaa sɛka kalekɔ nwu ntɔɔtɛɛtɛɛ ye.’ ");
INSERT INTO snw_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Kafɔɔ nse biɛkyɛ okpoo owo kamɛ, di okpoo nwu batii diefũ ye, biɛkyɛ okpoo nwu lɛkpaka biebuɛ bilɛ, ");
INSERT INTO snw_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Okpoo lee kɔtɛ ko ninka wo ni di nkpaasɔ, buɔfɛntɛ muntɛ ye. Kafɔɔ binyuma bilɛ Yaa sɛka ole bee ntɔɔtɛɛtɛɛ!’ ");
INSERT INTO snw_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nioso kɔtɔkɔ ye ntikiti nlɛ di lɛkankoyi suoto, Yaa manya Sodom okpoo nyaami, anlenkee okpoo nwu! ");
INSERT INTO snw_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Korasin okpoo batii, biyɔɔsa! Betsaida okpoo batii, ayee biyɔɔsa! Nse Tiro ku Sidon sekpoo kpile nwu kamɛ nimbla sɛkpɛ se niɛbla ni ɔkpɛ ntuo, nse batoosiɛ kaasɔ kofokofoko, beenyukũ sikplakpi, beefifia ntɔ di suoto beetuo alɛ batookyi di sikpile lɛma! ");
INSERT INTO snw_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Yaa manya Tiro ku Sidon sekpoo nyaami anlenkee ye di lɛkankoyi suoto. ");
INSERT INTO snw_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ni afɔ Kapernaum, foonyu falɛ babatakatɛsa fɔ katoo mansifiko osi? Babawakosa fɔ kasɔ mankpee fɔ di kawɔɔ kamɛ!” ");
INSERT INTO snw_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ninfe di Yesu latɔkɔ basaateketetɛ nɔɔ alɛ, “Otii lele niɛkyɔɔ ye atoko, ami ɛɛkyɔɔ atoko. Otii lele kafɔɔ niesĩ ye, ami eesĩ. Otii lele kafɔɔ niesĩ mi, eesĩ otii wɔ niekpee mi ni kɔtɔ.” ");
INSERT INTO snw_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Batii afosi akuɛnsĩ batii banyɔ nwu lakple baawa ku suoto lɛyɔɔ kplɛ. Ni baatɔkɔ Yesu alɛ, “Saate, bia anwuna kpile lanu wo ɔlaa aadie, buatososa nya ni di leyooto lɛfɔ kamɛ.” ");
INSERT INTO snw_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ninfɛ di Yesu latɔkɔ ma alɛ, “Lanya Satana kɔkpa ankye osi fɛ mmle di ɔplalaa mmunaa nii. ");
INSERT INTO snw_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Bikyɔɔ atoko bienu nwaa! Ntɔɔta ye otumi nlɛ biafuo ɔkyɛ di asaanwu ku nnkpakana suoto, ku lo nwu situmi nɔɔ simuu suoto alɛ lɛsalɛsa dilaabla ye. ");
INSERT INTO snw_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Kafɔɔ, bitanta suoto layɔɔ ye alɛ anwuna kpile lɛkyɔɔ ye ni atoko oso. Kafɔɔ suoto siyɔɔ ye alɛ Yaa ntɔɔkpana ye ayooto ɛɛtɛ di Yaa kafa.” ");
INSERT INTO snw_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Di obe nwu kamɛ, Yaa Ninwuna lakpee Yesu suoto lɛyɔɔ ni aabuɛ alɛ, “Teete, osi ku kasɔ Saate, kɔpɛ fɔ sɛfa. Diekye asaa ya fɛɛyɔ feekookaa ni bakũyentɛ ku banumbentɛ, nnya fatoodiki feetuo batii ba ninanye ni akũ nɛ. Nwaako, Teete, nkpo okle foomiɛ falɛ dite nɛ.” ");
INSERT INTO snw_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ninfɛ aakple aabuɛ alɛ, “Teemi lɛyɔ asaa amuu eekpee mi ninnɛɛ kamɛ. Kuonwii dieye otii wɔ ninle ni Obi nwu, diediki Ote lete. Otii kuonwii kafɔɔ dieye Ote nwu diediki Obi lete ku batii ba di Obi nwu nkpo komiɛ alɛ adiki atuo nii.” ");
INSERT INTO snw_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ninfɛ di Yesu lamunikĩi aatɔkɔ basaateketetɛ nɔɔ nwu nkpo buɛɛ alɛ, “Aye leleye nlɛ alɛ biɔnya asaa ya biɔnya ni lo! ");
INSERT INTO snw_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Kɔtɔkɔ ye nlɛ, Yaa ɔlaa babuɛtɛtɛ kpinwu ku baka lamiɛ alɛ bɔɔnya lɛsaa le biɔnya nii, kafɔɔ batanya. Baamiɛ kafɔɔ alɛ boonu lɛsaa le bionu nii, kafɔɔ batanu.” ");
INSERT INTO snw_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Kufiofa tuotɛ onwii lawa ku disibu alɛ ɔɔbasɔ Yesu annyu. Ni aakaalɛ nwɔ alɛ, “Saatuotɛ, be kabla fiɛ kawɛ nkpa be ninnaa ni kaloo?” ");
INSERT INTO snw_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ninfɛ di Yesu ladiki kanya aakaalɛ nwɔ alɛ, “Lɛ Kɔɔkpana Klekle Kukũ lebuɛ fiɛ? Lɛ feenu ɔlaa nwu nkpo kafɔɔ kasɔ?” ");
INSERT INTO snw_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ninfɛ di osuɔtɔ nwu nkpo ladiki kanya alɛ, “Bɔmbɔ Saate Yaa lɛfɔ ku otu lɛfɔ omuu, ku ninwuna lɛfɔ nimuu ku osie lɛfɔ omuu ku disibu lɛfɔ nimuu, ni faabɔmbɔ owo lɛfɔ kafɔɔ fɛ mmle fambɔmbɔ ni suoto.” ");
INSERT INTO snw_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ninfɛ di Yesu latɔkɔ nwɔ alɛ, “Mmle feebuɛ nii, nkpo kute nɛ. Ni bla nkpo fabawɛ nkpa.” ");
INSERT INTO snw_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Kafɔɔ kufiofa tuotɛ nwu nkpo lamiɛ alɛ ɔɔta suoto lɛbɛ, nioso aakaalɛ Yesu alɛ, “Owe ninle mi owo?” ");
INSERT INTO snw_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ninfɛ di Yesu ladiki kanya alɛ, “Obe onwii, osuɔtɔ onwii lawɛ, aakye Yerusalem aatoofe Yeriko okpoo, ni baayu lamufũ nwɔ di osuku nɛ. Baapɛ nwɔ, baadiki nwɔ asaa di suoto, ni baadiɛ nwɔ baatɛ ninfa, ooloo okpi. ");
INSERT INTO snw_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ni diabawa alɛ Yaa oletatɛ onwii labafe di osuku nwu suoto. Kafɔɔ obe wɔ aanya ni osuɔtɔ nwu nkpo di osukulɔɔkɔ, aawaalɛ nwɔ aafe kaakyɛ nyɔɔfa aasifi. ");
INSERT INTO snw_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nkpo okle di oletatɛ kyakaakotɛ onwii kafɔɔ bɔɔlɛɛ ni Lewi labatoofe nɛ. Obe wɔ aanya ni osuɔtɔ nwu, nnwɔɔ kafɔɔ aawaalɛ nwɔ aafe di osuku kakyɛ nyɔɔfa aasifi. ");
INSERT INTO snw_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Kafɔɔ Samaria otii onwii latoofe osuku, aakyɛ di osuku nwu nkpo suoto, abakyakako osuɔtɔ nwu. Obe wɔ aanyɔɔ nii, kafutu lanyinyii nwɔ. ");
INSERT INTO snw_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ninfɛ aakyɛ aalaadu nwɔ, ninfɛ aayɔ nnɔnyi ku nta aakpete nwɔ di nkɔ nwu suoto, ninfɛ aaninii nwɔ nkɔ nwu mmuu nɛ. Ni aakɛnkɛ osuɔtɔ nwu nkpo aatika di nnwɔɔ omu nɔɔ bɔkɛɛ wɔ suoto aasiɛ nii. Ni aakpaa nwɔ aasifiko bafɔɔ kafunkɔ, aalaanyu nwɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Obe wɔ kale lasɛ nii, Samaria otii nwu layɔ koto kowo aata bafɔɔ kafunkɔ nyuntɛ, aatɔkɔ nwɔ alɛ, ‘Toonyu fiɛtɛ nwu. Nse kokple mmafe, lɛsaa lele feekple fɛɛlalaasa di suoto nɔɔ, kamata nta fɔ.’ ” ");
INSERT INTO snw_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Nfa nfɛ di Yesu lakaalɛ kufiofa tuotɛ nwu alɛ, “Afɔ fɔɔnya nii, di batii ba mmle batiɛ kamɛ, owe lɛma ninle osuɔtɔ wɔ niabuo ni baayu nnɛɛ kamɛ siɛwo?” ");
INSERT INTO snw_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ninfɛ di kufiofa tuotɛ ladiki kanya alɛ, “Otii wɔ nianyɔɔ ni nyaami.” Ni di Yesu latɔkɔ nwɔ alɛ, “Afɔɔ yi, tɔɔkyɛ falaabla nkpo.” ");
INSERT INTO snw_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Dii ninwii Yesu ku basaateketetɛ nɔɔ latoofe osuku, ni baalaadu okpoo onwii nɛ. Nfa di ɔsanko onwii bɔɔlɛɛ ni Marta lafũ nwɔ kɔfɔɔ di leyo nɔɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta wɔ mmle lawɛ obilɛma sankobi onwii baatɔɔlɛɛ ni Maria. Ɔsanko wɔ mmle lalasiɛ di Yesu nkpaatũ aatoonu nwɔ asaa otuo. ");
INSERT INTO snw_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Leyo ɔsaabla latika di Marta lete suoto, nioso diatoobuo nwɔ suoto. Ni aakyɛ aalaatɔkɔ Yesu alɛ, “Saate, ni faayɔ nwu ole falɛ obiloo ntoodiɛ leyo sɛkpɛ eetika mi di suoto? Tɔkɔ nwɔ aawa abakyakaakoe!” ");
INSERT INTO snw_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ninfɛ di Yesu latɔkɔ nwɔ alɛ, “Marta! Nyu mmle fookpee ni suoto kubuɛ di asaa kpinwu suoto lo. ");
INSERT INTO snw_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Lɛsaa ninwii pɛ niefĩ. Nni ninle dibiene le di Maria ntoodiki ni nɛ. Kuonwii kafɔɔ dilabafũ nwɔ ninnɛɛ.” ");
INSERT INTO snw_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Dii ninwii, Yesu lawɛ lɛɛba ninwii aatɔɔpɛ ɔlaa aatɔɔta Yaa. Obe wɔ aaloo nii, Saateketetɛ nɔɔ onwii lawa nwɔ ɔkyɛ abatɔkɔ nwɔ alɛ, “Saate, tuo wo mmle mampɛ ɔlaa manta ni Yaa, fɛ mmle di Yohane latuo ni basaateketetɛ nɔɔ.” ");
INSERT INTO snw_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ninfɛ di Yesu latɔkɔ ma alɛ, “Nse biɔpɛ ɔlaa minta Yaa yi, biebuɛ bilɛ, ‘Teete, ta balɛɛ leyooto lɛfɔ klekle nwu ku dibu. Sɛka kalekɔ lɛfɔ diwa wo kaamɛ. ");
INSERT INTO snw_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ta wo dii alesaa ya buale ni obe lele. ");
INSERT INTO snw_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Faayɔ sikpile loo fakyɛ wo, diekye awo kafɔɔ mun-yɔ munkyɛ otii lele niɛbla wo okpile. Tankpaa wo faakpee di ɔsɔ onyu kamɛ.’ ” ");
INSERT INTO snw_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ninfɛ di Yesu latɔkɔ basaateketetɛ nɔɔ alɛ, “Nse diɛwa alɛ onwii kamɛ lee lɛkyɛ siɛwo nɔɔ nfũ di nkyɛntɛɛ ɛɛlaatɔkɔ nwɔ alɛ, ‘Siɛwo, fɛnsa mi bloblo akudi atiɛ awo, ");
INSERT INTO snw_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","diekye siɛwo nii onwii lekye osuku ɛɛwa ɛbasoosa di ɔkyɛ nii nunua. Lelesaa kuninwii diete mi kamayɔ ntɔɔ anle nii!’ ");
INSERT INTO snw_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Di siɛwo lɛfɔ nwu lɛtɔkɔfɔ alɛ, ‘Tandiki mi ninwuna! Munko babi nii nfɛ bute, butɔɔsɛɛ leyo kafɔɔ kofokofoko. Namasinfuo kafɔɔ okple ɔtaka mayɔ lɛsalɛsaa kuninwii nta fɔ.’ ");
INSERT INTO snw_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Kɔtɔkɔ ye nlɛ, se kuntɛ ɔlɔbataka ayɔ bloblo nwu nkpo aatɔɔ ta siɛwo nɔɔ ale ni oso, abataka an-yɔ lɛsaa lele niefĩ nwɔ antɔɔ, nse sinunsɔ diɛkpɛ nwɔ eekpee okyiini ayɛ ɔɔkaalɛ, ɔkaalɛ. ");
INSERT INTO snw_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Nkpo oso kɔtɔkɔ ye nlɛ bikaalɛ Yaa asaa, abayɔ anta ye. Biwolaa asaa, abata ye minnya. Bipɛ nwɔ kokloo kɔnɛɛ, abasɛkɛtɛ anta ye. ");
INSERT INTO snw_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Diekye otii lele niɛkaalɛ Yaa asaa, an-yɔ antɔɔ. Otii lele niewolaa, antɔɔ anya. Otii lele kafɔɔ niɛpɛ Yaa kokloo kɔnɛɛ, ansɛkɛtɛ antɔɔ. ");
INSERT INTO snw_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Aye ba ninle ni babi bate, nse obi lee lɛkaalɛ ye kakpaku, min-yɔ kɔsaanwu mintɔɔ? ");
INSERT INTO snw_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ee min-yɔ kakpakana mintɔɔ nse ɛɛkaalɛ ye lɛkɔɔkɔfuɔ? ");
INSERT INTO snw_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Bia aye ba ninle ni bakpileblatɛ yi, biye mmle okle biayɔ asaa biene minta ni babi lee. Ni lɛ oso nfɛ di Teeye wɔ ninkpe ni di osi ate ni klekle dilaayɔ Ninwuna Klekle ata batii ba niɛkaalɛ nwɔ ni alenkee!” ");
INSERT INTO snw_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Di obe onwii, Yesu latootososa ninwuna kpile ninwii ninanfuo ni ɔkakatɛ di otii onwii kamɛ. Obe wɔ di ninwuna nwu ladie ni di otii nwu kamɛ, aakyako ɔkakatɛ. Lɛsaa le mmle labla batii ba niayila ni ninfa ɔkpɛ. ");
INSERT INTO snw_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Kafɔɔ batii bawo labuɛ alɛ, “Anwuna kpile ɔka wɔ bɔɔlɛɛ ni Beelsebul niɛtɔɔ otumi nwu nkpo ootososa nya andiki.” ");
INSERT INTO snw_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Batii bawo kafɔɔ lamiɛ alɛ bɔɔkyɔɔ Yesu okũ, nioso baatɔkɔ nwɔ alɛ, abla lɛsaa le niɛbla ni ɔkpɛ, diatuo alɛ Yaa nfũ eekye ni. ");
INSERT INTO snw_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Kafɔɔ Yesu latofo lɛsaa le bakle ni di disibu lɛma kamɛ. Nkpo oso aatɔkɔ ma alɛ, “Kale ka niɛsɛ ni suoto akudi akudi kɔɔkpɛko ni suoto, ninyila diidii. Leyo le kafɔɔ niɛsɛ suoto bɛɛtaka bayɛ ni baawo suoto mbiɛ. ");
INSERT INTO snw_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Nkpo oso nse Satana sɛka kalekɔ lɛsɛ suoto akudi akudi bɔɔkpɛko bawo, lɛ sɛɛka kalekɔ lɛma nwu mayila? Biobuɛ bilɛ kotososa anwuna kpile diekye Beelsebul niɛtɛɛ otumi fiɛ kɔbla nkpo. ");
INSERT INTO snw_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ni nse Beelsebul suoto kofe ntososa nya, ni owe suoto baatikankotɛ lee mma, baafe baatososa anwuna kpile baadiki baatii kamɛ? Aye bamu batikankotɛ lee kodiki mantuo alɛ ole ye nnaa. ");
INSERT INTO snw_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Oowo! Kafɔɔ Yaa otumi kamɛ kotososa anwuna kpile ndiki. Nle mmle kotuo kafɔɔ klekle alɛ, Yaa sɛka kalekɔ ntɔɔwa ye kamɛ kofokofoko. ");
INSERT INTO snw_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Nse sientɛ owo lɛyɔ akpɛsaa nɔɔ amuu ɛɛkpakũ ayɛ oonyu leyo nɔɔ yi, lɛsalɛsaa nɔɔ kuninwii nin-yu. ");
INSERT INTO snw_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Kafɔɔ nse otii wɔ ninkpe ni osie alenke nwɔ ni lɛbakpɛ ko nwɔ eelenkee nwɔ, anklee akpɛsaa nɔɔ ya suoto eetika ni disi anfũ di nnɛɛ nɔɔ, lenkeetɛ nwu n-yɔ asaa ya beefũ nii mansɛ ku bawo nɔɔ. ");
INSERT INTO snw_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Otii lele ninan-yɛ mi kamaa, nwaako ɛɛtaka ayɛ mi di suoto. Otii lele kafɔɔ ninankyakaakoe busiisa kamaa, ɔsamiisa ansamiisa. ");
INSERT INTO snw_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Nse ninwuna kpile ledie di otii kamɛ, ninaakyɛ ninkyi aba ya niekoso nii ninmiɛ lɛba le diasiɛ nii. Nse diɛwɛ lɛba kuninwii, ninmbuɛ alɛ, ‘Makple nsifi leyo nii le kamɛ ladie nii.’ ");
INSERT INTO snw_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Nkpo oso ninkple ninwa, ninmanya alɛ batoofiɛ leyo nwu kamɛ nimuu, bɛɛbla ni klekle. ");
INSERT INTO snw_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ta nkpo oso, ninkple ninsifi ninaakpaa anwuna kpile akuɛnsĩ ya ninkpe osie alenke nwɔ nii, manwa, mamayie mansiɛ di otii nwu kamɛ. Di kayɛntɛkɔ, otii nwu nkpo nkpa be nfɛ ansiɛ ni, nlalaa ninlenkee nkpa kasale be aasiɛ nii.” ");
INSERT INTO snw_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Di obe wɔ di Yesu ntoobuɛ sɛlaa se mmle eeloo ni sɛmaa, ɔsanko onwii lafaa osie kanya baatii nwu kamɛ aabuɛ alɛ, “Suoto siyɔɔ ɔsanko wɔ nialakafɔ ni lɛmɛ aata fɔ lɛnyɛɛ, faanyɛɛfu ni!” ");
INSERT INTO snw_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ninfɛ di Yesu labuɛ alɛ, “Kafɔɔ batii ba nikonu ni Yaa ɔlaa, bɔɔbla nwu ni di suoto, di suoto siyɔɔ!” ");
INSERT INTO snw_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Obe wɔ baatii dikudi labasi ni di Yesu ɔkyɛ, ninfɛ aatɔkɔ ma alɛ, “Miɛ akyɛnfɔɔle ntɔɔlalaa lo! Sɛkpɛ se niɛbla ni ɔkpɛ bomiɛ alɛ banya, kafɔɔ blɔbanya dituosaa kuninwii dilenkee Yona lele le okle. ");
INSERT INTO snw_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Fɛ mmle ke di Yaa Ɔlaa Buɛtɛtɛ Yona lale ni ɔtɛ onyu aata ni Niniwe batii, nkpo kafɔɔ di Otii Obi nwu male ɔtɛ onyu anta miɛ akyɛnfɔɔle nɛ. ");
INSERT INTO snw_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Di lɛkankoyi suoto, ɔka sanko wɔ niakye ni kala kasɔ, mataka anyila ankanko miɛ akyɛnfɔɔle anlo ye lɛpɔɔ diekye aakye okpoo nɔɔ fanfa aawa alɛ ɔɔbanu Ɔka Salomo ninumbe asaa otuo. Kafɔɔ kɔtɔkɔ ye nlɛ otii wɔ ninlenke ni Salomo nkpe ninfũ. ");
INSERT INTO snw_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Niniwe batii mataka manyila di lɛkankoyi nwu kamɛ mankanko ye manlo ye lɛpɔɔ. Diekye di obe wɔ di Yona latɔkɔ ma ni Yaa ɔlaa, baakyisa nkpa, baadiɛ sikpile lɛma ɔbla. Kafɔɔ nwaako kɔtɔkɔ ye nlɛ, otii onwii nsi ye kaamɛ ninfũ alenke ni Yona! ");
INSERT INTO snw_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Otii kuonwii ninsɔ kandiɛ ayɔ akookaa ee ayɔ lɛsaa atĩi nwɔ. Kafɔɔ an-yɔ antika lɛsaa suoto, lɛɛba le dibakpa ninta ni batii ba nikobuo ni leyo. ");
INSERT INTO snw_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Anu lɛfɔ nte fɛ kandiɛ diɛta suoto lɛfɔ simuu. Nse anu lɛfɔ nlɛ, ni afɔ otii omuu fankpa, kafɔɔ nse anu lɛfɔ diɛlɛ, afɔ otii omuu fansiɛ di ditunu kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Nkpo oso lolaa fanyu falɛ lɛkpa le ninsi fɔ ni kaamɛ dilaakple ditunu. ");
INSERT INTO snw_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Nse lɛkpa leyii fɔ kamɛ, di lɛba lɛfɔ kuninwii diesi di ditunu kamɛ, ni afɔ otii omuu fabakpa fante klekle, fɛ mmle di kandiɛ nkpa ankpete ni di lɛsaa suoto ninkpa nii.” ");
INSERT INTO snw_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Di obe wɔ di Yesu laloo ni lɛkakatɛ, Farisi otii onwii lalɛɛ nwɔ alɛ awa abaleko nwɔ alesaa leeyo. Nioso aakyɛ alɛ ɔɔlaaleko nwɔ alesaa. ");
INSERT INTO snw_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Diabla Farisi otii nwu ɔkpɛ obe wɔ aanya alɛ Yesu ditafoto kɔnɛɛ, di amanle lɛma kanya fiɛ aakyako ni alesaa ole. ");
INSERT INTO snw_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Nkpo oso Saate nwu latɔkɔ nwɔ alɛ, “Aye Farisi batii, minfoto sĩpũ ku abɛsibii lee kayi, kafɔɔ kamɛ lee leyii pɔ ku kayu kuɛ asaakuu ɔbla. ");
INSERT INTO snw_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Biébe anu! Diele Yaa wɔ niɛbla ni asaa nwu amuu kayi niɛbla kamɛ kafɔɔ? ");
INSERT INTO snw_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Biyɔ lɛsaa biala ninsi di abɛsibii ku nkɔkɔɛ lee kamɛ bita bapiitɛ, ni lɛsaa lee biala makpa di afiofa lee kanya. ");
INSERT INTO snw_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Biyɔɔsa, aye Farisi batii! Diekye min-yɔ alesaa lee lefosi le ku kɔba lee kamɛ sɛfa se nimpɛ ni ɔkɔnɔ nwaa ate ate minta Yaa. Kafɔɔ biesĩ lɛbɛ ɔta di osuku kanya ku Yaa lɛbɔmbɔ. Nle mmle dikpe ni biɛbla biɛkyakaa di n-ya biɔbla ni kofokofoko nɛ, dinaa alɛ biediɛ kuninwii biɛtɛ. ");
INSERT INTO snw_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Biyɔɔsa, aye Farisi batii! Diekye mimbɔmbɔ nsiɛkɔ kplɛ osiɛ di nsiisakɔ lee, mimmiɛ kafɔɔ bilɛ batii batɔɔsɛɛsa ye ku dibu di akpaka. ");
INSERT INTO snw_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Biyɔɔsa, diekye bite fɛ sɛkya se mɔnɔɔnya nii, baatii nkyɛ sĩ ni di suoto, ta mananye ni oso.” ");
INSERT INTO snw_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ninfɛ di kufiofa batuotɛ onwii lɛma latɔkɔ Yesu alɛ, “Saatuotɛ, nse foobuɛ nkpo, ni footufa awo kafɔɔ nɛ.” ");
INSERT INTO snw_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ninfɛ di Yesu ladiki kanya aatɔkɔ nwɔ alɛ, “Biyɔɔsa aye basaatuotɛ kafɔɔ. Atoo ya baatii dilabafuo ni otuka, nnya minkpee min-yɔ mintukasa ma nɛ. Minsunko ma nnɛɛ kafɔɔ bilɛ biɔkyakaako ma mantuka atoo nwu nkpo. ");
INSERT INTO snw_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Biyɔɔsa, diekye mimbla sɛkya biene minta Yaa ɔlaa babuɛtɛtɛ. Kafɔɔ Yaa ɔlaa bauɛtɛtɛ ba mmle bawa lee nialo ma. ");
INSERT INTO snw_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Aye bamu bitoofũ biekpee bilɛ, bieetuna di lɛsaa le baawa lee labla nii. Diekye baalo Yaa ɔlaa babuɛtɛtɛ nwu. Ni di ayee bielolaa sɛkya lɛma nwu nɛ. ");
INSERT INTO snw_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Nle mmle oso di Yaa ninumbe labuɛ alɛ, ‘Makyesee Yaa ɔlaa babuɛtɛtɛ ku batɔkyɛntɛ kaamɛ lɛma, kafɔɔ babalo bawo, mantikanko bayɛntɛle.’ ");
INSERT INTO snw_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Nkpo oso Yaa mananfi miɛ akyɛnfɔɔle bamuu laatoko di Yaa ɔlaa babuɛtɛtɛ ba bamuu batoolo ni diɛyɔ ni di kayi ka mmle kasɔ kakyekɔ. ");
INSERT INTO snw_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Diayɔ ni di obe wɔ baalo Abel diɛlase ni di Sakaria wɔ baalo ni di oleɔta akyikye ku kakleklekɔ obo. Nwaako kɔtɔkɔ ye nlɛ, Yaa mananfi miɛ akyɛnfɔɔle laatoko, ta ɔsaabla wɔ mmle fɛɛ oso. ");
INSERT INTO snw_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Biyɔɔsa, aye kufiofa batuotɛ! Diekye leyo le kamɛ ninumbe nte nii, biɛsɛɛ kayoko nɔɔ biediki saafĩi. Diekye aye bamu biesĩ bilɛ biloobuo nii, biotĩi batii ba kafɔɔ nikomiɛ alɛ babuo ni osuku.” ");
INSERT INTO snw_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Obe wɔ di Yesu ladie ni ninfa, Farisi batii ku kufiofa batuotɛ lakyako Yesu suoto ɔlaa obuɛ ku ɔblɔ, Baakaalɛ nwɔ sɛlaa kpinwu di asaa ate ate suoto. ");
INSERT INTO snw_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Diekye baatoomiɛ osuku wɔ suoto baafe mantika nwɔ ni ɔlaa di suoto alɛ ɛɛbla ni okpile. ");
INSERT INTO snw_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Obe wɔ baatii nkpe nkpe bawo labasi ni dikudi, baakyako ni bia bawo ɔnanafũ, Yesu lakye kasɔ aatɔɔtɔkɔ basaateketetɛ nɔɔ alɛ, “Bilolaa binyu di Farisi batii mmɔle nyankale le suoto, dile ni sɛlaa kuafunu ɔsaabla lɛma. ");
INSERT INTO snw_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Lɛsaa lele baatii lɛbla beekookaa, dibadie kayi klekle. Ee owofalaa kuonwii nnaa alɛ blɔbanu ni diidii. ");
INSERT INTO snw_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Nkpo oso ɔlaa lele biebuɛ diitunu kamɛ, kubadie kayi kakũ kpanamantãa. Ɔlaa lele kafɔɔ biebuɛ sɛɛwɛɛwɛɛ leeyo kamɛ, kubadie kayi manyie nwu lɛkya lɛɛkpaka. ");
INSERT INTO snw_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Basiɛwo, kɔtɔkɔ ye nlɛ, bitanyɛkɛ batii ba ninlo ni suoto sina, ninni kamaa, lɛsalɛsaa nsinnaa ma babakple manfuo ni ɔbla. ");
INSERT INTO snw_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Kamatuo ye otii wɔ biayɛkɛ nii, biyɛkɛ Yaa wɔ nse atoolo eeloo, eekple akpe ni osie an-yɔ anfuki ankpee ni di ɔtɔ wɔ nikofiɛ ni kunaa ni kaloo kamɛ. Nwaako kɔtɔ ye nlɛ, nnwɔɔ ninle otii wɔ biayɛkɛ ni nɛ. ");
INSERT INTO snw_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Diele mplɛ nnyɔ pɛ man-ya kutĩitĩi kɔnɔɔ? Kafɔɔ Yaa ninyee kukanwii. ");
INSERT INTO snw_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Bia disi lee sinwini yi, Yaa n-ye sĩ lɛpɔɔ. Nkpo oso yi, bitanyɛkɛ. Diekye biefũ kɔya bilenke kutĩitĩi. ");
INSERT INTO snw_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Nwaako kɔtɔkɔ ye nlɛ, otii lele nimadiki ambuɛ baatii anu alɛ ole mi ale ami, Otii Obi nwu, kafɔɔ madiki mbuɛ di Yaa batɔkyɛntɛ anu nlɛ ole mi ale. ");
INSERT INTO snw_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Kafɔɔ otii wɔ nimasĩ mi ni di batii anu, ami, Otii Obi, kafɔɔ mansĩ nwɔ di Yaa batɔkyɛntɛ anu. ");
INSERT INTO snw_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Otii lele nimabuɛ ɔlaa kpile owo anyila di Otii Obi nwu suoto, Yaa mayɔ ankyɛ nwɔ. Kafɔɔ otii wɔ nimabuɛ ni ɔlaa kpile diɛ Ninwuna Klekle suoto, Yaa dilabayɔ akyɛ nwɔ. ");
INSERT INTO snw_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Nse bɛɛkpaa ye bɛɛkyɛnko Yuda batii nsiisakɔ ee banɔɔfo ku baka anu alɛ bɔɔkanko ye yi, bitambu diisi di ɔlaa wɔ bibabuɛ mindiki ni suoto kanya. ");
INSERT INTO snw_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Diekye Yaa Ninwuna Klekle nimatuo ye ɔlaa wɔ biabuɛ ni di obe nwu nkpo kamɛ.” ");
INSERT INTO snw_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Osuɔtɔ onwii lasiɛ baatii dikudi nwu kamɛ, ni aatɔkɔ Yesu alɛ, “Saatuotɛ, tɔkɔ obiloo aasɛ atesaa ya di teewo lediɛ ɛɛtɛ ni aatɛɛ ale mi.” ");
INSERT INTO snw_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ninfɛ di Yesu ladiki kanya alɛ, “Osuɔtɔ, owe niɛtɛɛ osuku kakanko ee kasɛ atesaa lee nta batii lee banyɔ?” ");
INSERT INTO snw_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ninfɛ aatɔkɔ bamuu lɛma alɛ, “Bilolaa binyu, di onumbɛbɛɛ lele suoto, diekye otii nkpa nwaa diesi di lɛsaawɛ le ninkpe nwɔ ni lɛɛpɔ kanya.” ");
INSERT INTO snw_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ninfɛ di Yesu lapɛ ma lɛkpa le mmle alɛ, “Fekpɛntɛ saawɛntɛ onwii lawɛ, kaasɔ nɔɔ lalɛ ni alesaa osie kanya. ");
INSERT INTO snw_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Nioso aabu diisi aabuɛ alɛ, ‘Lɛ mabla? Diekye nnaa lɛba le mayɔ alesaa ya mmle ntɛ nii. ");
INSERT INTO snw_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“ ‘Ninfɛ aabuɛ aatɔkɔ suoto alɛ, lɛsaa le kamabla ni ninle alɛ, kama biɛ alesaa katɛkɔ kofole nwu. Nintofo lɛfɔle le niemuɔ dilenke nii. Nfa matɛ alesaa ya lɛwɛ ni ku asaa bamba nɛ. ");
INSERT INTO snw_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ni kamatɔkɔ suoto nlɛ, disi nlɛ fɔ! Fakpe asaa biene ya mmle amuu alɛɛ kpinwu. Nioso tɛ ɔnyɛɛ, faale, faanyi, faale nkpa.’ ");
INSERT INTO snw_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Kafɔɔ Yaa latɔkɔ nwɔ alɛ, ‘Afɔ buutɛ! Miɛ kakyɛ ka mmle babafũ fɔ nkpa ninnɛɛ. Ni owe nfɛ nimale asaa ya mmle fesiisa fɛɛtɛ fɛɛta ni suoto?’ ” ");
INSERT INTO snw_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ninfɛ di Yesu layɛntɛ alɛ, “Nkpo dibate ninta batii ba niesiisa asaa bɛɛta ni suoto kaasɔ ka mmle suoto nɛ, kafɔɔ banaa ni lɛsalɛsaa di Yaa anu nɛ.” ");
INSERT INTO snw_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ninfɛ di Yesu latɔkɔ basaateketetɛ nɔɔ alɛ, “Nkpo oso kɔtɔkɔ ye nlɛ, bitankpɛ sikitii di nle biale minsiɛ ni nkpa suoto ee nle biakpee ee minklee ni suoto. ");
INSERT INTO snw_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Nkpa lefũ kɔya dilenke alesaa, nkpo kafɔɔ di suoto lefũ kɔya silenke akleesaa nɛ. ");
INSERT INTO snw_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Binyu bakwakwalobi. Mankpɛ kofe, manfiɛlɛ kafɔɔ. Banaa alesaa katɛkɔ ee siwu, kafɔɔ Yaa nta ma alesaa! Aye yi, biefũ kɔya bilenke bakansiɛ fanfanfa! ");
INSERT INTO snw_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Owe nimafuo dii ninwii ɔyɔ ɔkyakaa ninkpa nɔɔ suoto, nse eebu nkpa nɔɔ disi osie kanya? ");
INSERT INTO snw_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ni, di obe wɔ minoofuo ni asaa pitipiti ɔbla, be oso biodiki suoto ninwuna di asaa bamba suoto? ");
INSERT INTO snw_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Binyu mmle okle di atoto leepoo kamɛ mmuɔ anlɛ ni onyu. Ántaa oleteku ee aloso awu ata suoto. Kafɔɔ kɔtɔkɔ ye nlɛ Ɔka Salomo omu, di lɛsaawɛ nɔɔ nimuu kamɛ, atakpee awu alɛ onyu awo lepoo kamɛ atoto kpeele ya mmle kaamɛ lɛma onwii. ");
INSERT INTO snw_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ni nse Yaa lekpee sɛfa se mmle okle ninkpe ni nkpa sekpeele miɛ, kɔɔsɛɛ babayɔ mankpee ni di ɔtɔ kamɛ sinfiɛ nii. Ni Yaa nwu nkpo dilaanyuma ye ata ye akleesaa lee alenkee sɛfa nwu nkpo? Ofũ onu lee diɛpɔ. ");
INSERT INTO snw_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Nkpo oso bitankpɛ sikitii di nle bibale ku nle bibanyi ni suoto. Bitambu kafɔɔ disi sikitii. ");
INSERT INTO snw_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Diekye n-ya mmle di kayi batii bamuu ntikanko obe lele nɛ. Teeye n-ye alɛ asaa ya mmle amuu lefĩ ye. ");
INSERT INTO snw_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kafɔɔ, biwolaa Yaa sɛka kalekɔ, ni abayɔ asaa ya mmle amuu anta ye. ");
INSERT INTO snw_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Bafoso nii dikudi biibii, bitanyɛkɛ! Diekye dilɛ Teeye alɛ ɔɔyɔ sɛka kalekɔ nɔɔ anta ye. ");
INSERT INTO snw_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Biyɔ suoto lee asaa bisunsũ, biɛyɔ koto nwu bita bapiitɛ. Biemiɛ kotontofo ko ninamalalaa ni bita suoto, biekookaa lɛsaawɛ lee di Yaa kafa ninfũ abate anta ye ni. Diekye yu kuonwii dilabafuo ɔkyɛ ɔlaayɔ, bakunsũ kafɔɔ dilabafuo ɔkyɛ ɔlawee. ");
INSERT INTO snw_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Diekye nfũ di lɛsaawɛ lɛfɔ nte nii, nfa kafɔɔ di otu lɛfɔ nwɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Bilolaa suoto bita lɛsaa lele nimawa, biɛta bakandiɛ lee batɔɔkpa. ");
INSERT INTO snw_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Bite fɛ batii ba nikonyu osuku manta ni saate lɛma alɛ, abakye ɔsanko kayɔkɔ anwa ni. Nse ɛɛwa ɛbapɛ kokoloo kɔnɛɛ, nfanwu, baasɛkɛtɛ nwɔ. ");
INSERT INTO snw_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Suoto mayɔɔ bakpɛmblatɛ ba di saate lɛma manya ma basi boonyu ni osuku nse eekple ɛɛwa! Kɔtɔkɔ ye nlɛ, abadiki awu antɛ ampɛ lɛtapo d iɔtɔ, antɔkɔ ma alɛ basiɛ kaasɔ, nnwɔɔ omu nɔɔ anse ma opunu anta ma alesaa manle. ");
INSERT INTO snw_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Nse nkyɛntɛɛ ee kolesɛtũ di saate nwu lɛwa, ɛɛbatũ ma basi boonyu osuku, suoto matɛ sinyɔɔ ma lo! ");
INSERT INTO snw_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Biye bilɛ nse leyo saate matofo obe wɔ kamɛ di yu mawa amayu nwɔ nii, see atabatɔɔ osuku abiɛ nwɔ leyo abuo. ");
INSERT INTO snw_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Nkpo oso ayee bisiɛ bitoonyu osuku, diekye ami, Otii Obi nwu, mawa di obe wɔ minoonyu osuku bitɛɛ nii.” ");
INSERT INTO snw_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ninfɛ di Petro lakaalɛ Yesu alɛ, “Saate, lɛkpa le mmle lete loo falaka ɛɛ, sɛɛ ku batii bamuu falaka?” ");
INSERT INTO snw_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ninfɛ di Yesu ladiki kanya alɛ, “Kpɛmblatɛ wɔ nimbla ni lɛsaa di osuku kanya, nnwɔɔ di saate nɔɔ n-yɔ anse di bakpɛmblatɛ bule kanya nɛ. Nnwɔɔ nimata bakpɛmblatɛ bule alesaa fɛ mmle diesiɛko ni di obe biene kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Babakusɛkusɛsa kpɛmblatɛ nwu nkpo nse saate nɔɔ lɛwa ɛba nyɔɔ ɔbla ɔkpɛ wɔ eekpee nwɔ ni ninnɛɛ! ");
INSERT INTO snw_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nwaako kɔtɔkɔ ye nlɛ, saate nwu nkpo mayɔ kpɛmblatɛ nwu anse di asaa nɔɔ amuu kanya. ");
INSERT INTO snw_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“Kafɔɔ nse kpɛmblatɛ nwu nkpo lebuɛ alɛ, ‘Saate nii maklɛ di osuku nwu fiɛ abawa.’ Nkpo oso ɛɛkyako bakpɛmblatɛ bule ɔpɛ dile ni basanko ku basuɔtɔ, ɛɛkyako suoto lɛyɔɔ ɔnya, anle, anwee, annyi nta ansiɛ, ");
INSERT INTO snw_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","saate nɔɔ nwu mawa di dii le ku obe wɔ kamɛ onoonyu osuku atɔɔ nii. Saate nɔɔ nwu mananfi nwɔ kootoko osie kanya, antɔɔ kasiɛkɔ di batokopĩtɛ kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Kpɛmblatɛ wɔ ninye lɛsaa le di saate nɔɔ komiɛ alɛ abla atɔɔ ni fiɛ eesĩ ni ɔbla, ta áalolaa suoto alɛ ɔɔbla ni oso, lɛpɛ le mampɛ nwɔ ni mpɔ. ");
INSERT INTO snw_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Kafɔɔ kpɛmblatɛ wɔ ninanye lɛsaa le di saate nɔɔ komiɛ alɛ abla nii, kafɔɔ ɛɛbla lɛsaa le baananfi nwɔ ni kootoko, letokonanfi nɔɔ kɛɛkɛɛ ninle. Otii wɔ bɛɛta ni asaa kpinwu, nkpo okle kafɔɔ mamiɛ asaa kpinwu mankyeko ɔkyɛ nɔɔ nɛ. Kafɔɔ otii wɔ beekple bɛɛta balenke nii, nkpo okle babafũ manlenkeesa di ɔkyɛ nɔɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ɔtɔ lɛwa okpee kaasɔ ka mmle suoto, komiɛ kafɔɔ nlɛ kuakɛsɛɛ wla. ");
INSERT INTO snw_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Yaa ntu okpeesa onwii nkpe babakpeesɛɛ nii. Nioso ninwɛ onwu nwuna diɛlase di obe wɔ beekpeesɛɛ mi nii. ");
INSERT INTO snw_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Bienyu bilɛ atoko ɔkyɛ ole lɛwako kayi ka mmle? Oowo! Diele atoko ɔkyɛ ole, kafɔɔ kasɛ. ");
INSERT INTO snw_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Diɛyɔ ni nua diesifi nii, batii banɔɔ leeyo ninwii kamɛ ntɛɛ masɛ. Batii batiɛ mataka manyila baanyɔ suoto, banyɔ bule kafɔɔ mataka manyila baatiɛ suoto. ");
INSERT INTO snw_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Obi ote mataka anyila di obi suɔtɔbi suoto, obi suɔtɔbi kafɔɔ mataka anyila di ote suoto. Obi ɔya mataka anyila di obi sankobi suoto, obi sankobi kafɔɔ mataka anyila di ɔya suoto. Ɔmaato mataka anyila di obisɔfɔ suoto, obisɔfɔ kafɔɔ mataka anyila di ɔmaato suoto.” ");
INSERT INTO snw_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu latɔkɔ batii nwu nkpo kafɔɔ alɛ, “Nse biɛnya alokonkyɛ di kufĩ kamɛɛkɔ, bilɛ kanto manɔɔ. Ninwa kafɔɔ kanya. ");
INSERT INTO snw_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Nse biɛnya kɔfɛɛfɔ kɔfɛ kunkye kala kasɔ, mimbuɛ bilɛ difila nfɛ kɔwa. Ninwa kafɔɔ kaanya. ");
INSERT INTO snw_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Aye balaatɛ! Minfuo osi ku kasɔ onyu mintofo lɛsaa le nimawa ni mimbuɛ, ni be oso minoonu obe wɔ mmle kasɔ? ");
INSERT INTO snw_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Be oso minaabuo sɛɛla kamɛ bitofo lɛsaa biene le dikpe ni biɛbla ni? ");
INSERT INTO snw_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nse otii owo lɛlɛɛfɔ lɛka di bakantɛ nfũ, fe di osuku biala suoto bilolaa ɔlaa nwu bita baawo fiɛ biɛlaadu kakankɔ. Nse diele nkpo, abayɔ fɔ ankpee di kantɛ nnɛɛ, kantɛ nwu n-yɔ fɔ ankpee di bamufũtɛ nnɛɛ mantɛfɔ leeyo. ");
INSERT INTO snw_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Kɔta fɔ fantofo nlɛ, nfa fɔɔwa ɔbasiɛ yiɛlaase di obe wɔ fatɔɔta ni letokonanfi lɛfɔ koto yɛntɛle nɛ.” ");
INSERT INTO snw_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Di obe nwu nkpo kamɛ, batii bawo lawɛ ninfa latɔkɔ Yesu mmle di Pilato lalo ni Galilea batii bawo di obe wɔ baatɔɔta ole baatɔɔta ni Yaa. ");
INSERT INTO snw_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ninfɛ di Yesu lakaalɛ ma alɛ, “Bienyu bilɛ mmle okle beelo ni Galilea batii ba mmle oso, mma ninle bakpileblatɛ balenke Galilea batii bamuu bule? ");
INSERT INTO snw_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Oowo, diele nkpo kute! Nioso kɔtɔkɔ ye nlɛ, nse biékyi di sikpile lee ɔbla kamɛ, nkpo okle di aye kafɔɔ biɔwa ɔbakpi nɛ. ");
INSERT INTO snw_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ni lefosi batii banɛ ba di Siloa leyo kplɛ nwu labiɛ diapɛ, baakpi ni mɔ? Bienyu bilɛ, nle mmle oso, mma ninle bakpileblatɛ balenke batii ba bamuu ninkpe ni di Yerusalem? ");
INSERT INTO snw_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Oowo, diele nkpo kute! Kɔtɔkɔ ye nlɛ, nse biékyi di sikpile lee suoto, nkpo kafɔɔ di bamuu lee biɔwa ɔbakpi nɛ.” ");
INSERT INTO snw_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ninfɛ di Yesu lapɛ lɛkpa le mmle aatɔkɔ ma alɛ, “Obe onwii kamɛ, osuɔtɔ onwii lawɛ, aasɔ kolewoso kunwii di kofe nɔɔ kamɛ. Dii ninwii aakyɛ alɛ ɔɔlamiɛ kowoso nwu nkpo dibi, kafɔɔ, atawɛ kuninwii. ");
INSERT INTO snw_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ninfɛ di osuɔtɔ nwu latɔkɔ kofe nɔɔ nyuntɛ alɛ, ‘Nyu! Alɛɛ atiɛ amu nkyɛ ni nfũ komiɛ ni kowoso ko mmle dibi nlɛ kɔtɛsɛ, kafɔɔ ninwɛ kuninwii. Budi kũ fayu! Diekye nɔɔnya lɛsaa le oso kuyɛ ni kaasɔ ka mmle suoto.’ ");
INSERT INTO snw_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Kafɔɔ kofe nwu nkpo nyuntɛ labuɛ alɛ, ‘Saate, ta kukple kuyila lɛlɛɛ ninwii buonyu. Kamakutu kũ kalɔ nkpete asaa ya nimata lɛba le kuyɛ ni n-yɔɔ ninsiɛ lɛla munnyu. ");
INSERT INTO snw_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ni nse lɛlɛɛ lekyi kuofuo abi otika kpinwu, ni kulɛ nɛ. Kafɔɔ nse kúofuo abi otika, ni faafuo kũ obudi oyu nfɛ.’ ” ");
INSERT INTO snw_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Di Lɛnyɛɛtɛyi ninwii suoto, Yesu latotuo asaa di Yuda batii kasiisakɔ kanwii kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ɔsanko onwii lawɛ ninfa di ninwuna kpile ninwii latɔkpɛko ni lefosi alɛɛ anɛ amu. Ninwuna nwu nkpo lata alɛ, obe lele ɔsanko nwu nkpo lebo, ánfuo suoto oyilasa. ");
INSERT INTO snw_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Obe wɔ di Yesu lanyɔɔ nii, aalɛɛ nwɔ, ni aatɔkɔ nwɔ alɛ, “Ɔsanko, ofiɛ lɛfɔ nwu ntɔɔyɔɔfɔ!” ");
INSERT INTO snw_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ninfɛ di Yesu layɔ kɔnɛɛ aatika di ɔsanko nwu suoto nɛ. Nfanwu, ɔsanko wɔ mmle niataka aayila wlɔlɔ, aakyako Yaa ɔtansa nɛ. ");
INSERT INTO snw_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Yuda batii kasiisakɔ nwu nkpo ɔnɔɔfo lanya ɔblɔ osie kanya di mmle di Yesu layɔɔsa ni ofiɛ di Lɛnyɛɛtɛyi nwu oso. Nkpo oso aatɔkɔ batii nwu nkpo alɛ, “Ayi akuɔ ninkpe wo mumbla ni sɛkpɛ. Nkpo oso biwa di ayi nwu nkpo kamɛ baayɔɔsa ye sifiɛ, diele di Lɛnyɛɛtɛyi suoto!” ");
INSERT INTO snw_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ninfɛ di Saate ladiki kanya aatɔkɔ nwɔ alɛ, “Aye balaatɛ! Mindiki banankyue ku bapɔnkɔ lee di sikũ minkpama minkyɛnko ntu kanyinkɔ di Lɛnyɛɛtɛyi suoto. ");
INSERT INTO snw_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Binyu ɔsanko wɔ mmle ninle ni Abraham ɔnantii di Satana lenii ni lefosi alɛɛ anɛ amu. Diɛlɛ alɛ baafukuti nwɔ di Lɛnyɛɛtɛyi suoto?” ");
INSERT INTO snw_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yesu sɛlaa se aabuɛ ni lata sinunsɔ lakpɛ balo nɔɔ. Kafɔɔ batii bule lanya suoto lɛyɔɔ di sɛkpɛ kplɛ se simuu aabla ni oso. ");
INSERT INTO snw_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesu lakaalɛ ma alɛ, “Be lɛsaa di Yaa kafa nwu nkpo ledie? ");
INSERT INTO snw_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ote dite fɛ, otii niɛyɔ lewosobi biibii ninwii ɛɛpɛ di kofe nɔɔ. Diakɔntɔ nii, diamuɔ, diɛbakple kowoso dibinte kunwii di bakansiɛ lɛbla ni ayo lɛma di sɛla nɔɔ suoto.” ");
INSERT INTO snw_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesu lakple aakaalɛ alɛ, “Be lɛsaa suoto mayɔ Yaa sɛka kalekɔ nwu nkaatɛsa? ");
INSERT INTO snw_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ote dite fɛ ɔsanko onwii niɛyɔ lɛnyakasaa eekpee di bloblo nnaafũ kotofo kunwii bɛɛnwɔtɔ ni kamɛ diɛlase di obe wɔ di nnafũ nwu bɛɛnwɔtɔ ni lɛtaka nii.” ");
INSERT INTO snw_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu lafe di sekpoo ku nkpayotũ kamɛ aatootuo batii asaa di obe wɔ aatoofe ni Yerusalem. ");
INSERT INTO snw_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Nfanwu otii onwii lakaalɛ nwɔ alɛ, “Teete, batii ba nimawɛ ni didiki, basɛɛ babale ɛɛ, sɛɛ lɛ?” ");
INSERT INTO snw_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Kpee okyiini faafe di kayoko biibii nwu kamɛ fabuo. Diekye batii kpinwu mamiɛ alɛ boobuo osie kanya, kafɔɔ bɔlɔbafuo obuo. ");
INSERT INTO snw_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Diekye obe kɔwa di leyo saate masɛɛ ni kayoko nwu nkpo. Bibaka kaayi minkyako kokloo kɔnɛɛ ɔpɛ mimbuɛ bilɛ, ‘Teete, sɛkɛtɛ wo!’ “Kafɔɔ abatɔkɔ ye alɛ, ‘Ninye ye nfũ biekye nii!’ ");
INSERT INTO snw_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Nfa nfɛ bibakyako obuɛ bilɛ, ‘Awo ku afɔ niale, buanyi, faatuo wo kafɔɔ asaa di okpoo loo le!’ ");
INSERT INTO snw_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Kafɔɔ abakple antɔkɔ ye alɛ, ‘Ninye ye nfũ biekye nii! Bikyɛ mi di ɔlɔɔkɔ bisifi, aye bakpileblatɛ!’ ");
INSERT INTO snw_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Nfa nfɛ bibawi nku, minwee anyɛɛ, di obe wɔ bibanya Abraham ku Isak ku Yakob ku Yaa ɔlaa babuɛtɛtɛ bamuu nsi ni di Yaa kafa. Kafɔɔ aye, babafuki ye man-yu kaayi alɛ bitambuo. ");
INSERT INTO snw_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Batii makye kufĩ katunkɔ ku kamɛɛkɔ manwa. Bawo nkye katoo ku kala kasɔ manwa mamasi di opunu katũ di Yaa kafa, manle, manyi. ");
INSERT INTO snw_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nioso batii ba ninle ni bayɛntɛle, mawa mamale bakasale. Mba kafɔɔ ninle ni bakasale mawa mamale bayɛntɛle.” ");
INSERT INTO snw_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Di obe nwu nkpo kamɛ kafɔɔ, Farisi batii bawo lawa Yesu nfũ babatɔkɔ nwɔ alɛ, “Pɛsɛwa fadie ninfũ fasifi kakɔ bamba, diekye ɔka Herode komiɛ alɛ alo fɔ.” ");
INSERT INTO snw_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ninfɛ di Yesu latɔkɔ ma alɛ, “Bikyɛ biɛlatɔkɔ ahia nwu nkpo bilɛ, ‘Miɛ, matososa anwuna kpile, kɔsɛɛ nnyɔɔsa bafiɛtɛ sifiɛ. Di dii tiɛfa suoto, maloo ɔkpɛ nii.’ ");
INSERT INTO snw_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Kafɔɔ dikpe nii lɛkyɛ osuku miɛ ku kɔsɛɛ ku sakale. Diekye diɛkaatɛ alɛ baalo Yaa ɔlaa buɛtɛtɛ di lɛba bamba kuninwii ninanle ni Yerusalem okpoo kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“O Yerusalem, Yerusalem, afɔ nialo Yaa ɔlaa babuɛtɛtɛ, faasafɔ batii ba kafɔɔ di Yaa lakpeefɔ ni ɔkyɛ aafuɔ faalo! Obe kpinwu ntoomiɛ nlɛ kosiisa babi lɛfɔ di afoko nii kalɔ fɛ mmle okle di kɔɔkɔɔbiɔya nkpaa abi ankpee ni di afoko nɔɔ kalɔ, kafɔɔ floonu kasɔ. ");
INSERT INTO snw_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ta nle mmle oso, Yaa madiki okpoo wɔ mmle atoko manwɔɔsa nwu. Nwaako kɔtɔkɔ ye nlɛ, biloosinwa mi ɔbanya diediki diɛlaase di obe wɔ biebuɛ bilɛ, ‘Yaa lekusɛkusɛsa otii wɔ nikɔwa ni di Saate leyooto kamɛ!’ ” ");
INSERT INTO snw_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Di Lɛnyɛɛtɛyi ninwii suoto, Yesu lakyɛ Farisi batii ɔnɔɔfo onwii leyo ninfũ baalɛɛ nwɔ alɛ abale ni alesaa. Batii lawɛ ninfa baatɔɔtɛtɛɛ nwɔ osie kanya. ");
INSERT INTO snw_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Osuɔtɔ onwii di nnɛɛ ku nkpaa lafufu ni lawa Yesu nfũ. ");
INSERT INTO snw_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ninfɛ di Yesu lakaalɛ kufiofa batuotɛ ku Farisi batii alɛ, “Kufiofa loo lɛta wo osuku alɛ buayɔɔsa otii ofiɛ di Lɛnyɛɛtɛyi suoto ɛɛ, sɛɛ kuɔta wo osuku?” ");
INSERT INTO snw_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Kafɔɔ batafuo kanya ɔbɛ obuɛ ɔlaa kuonwii. Ninfɛ di Yesu lamufũ osuɔtɔ nwu nkpo aayɔɔsa nwɔ ofiɛ, ni aatɔɔ aasifi nɛ. ");
INSERT INTO snw_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ninfɛ aakaalɛ ma alɛ, “Nse onwii lee obi ee bɔkɛɛ nɔɔ lɛkpa eebuo di dibiɔ kamɛ di Lɛnyɛɛtɛyi suoto, bilɔbadiki nwɔ dii nwu nkpo?” ");
INSERT INTO snw_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Kafɔɔ batafuo nwɔ ɔlaa nwu kanya odiki. ");
INSERT INTO snw_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Obe wɔ di Yesu lanya mmle di batii ba baakyakako ni latoodiki ni nsiɛkɔ kplɛ, ninfɛ aapɛ ma lɛkpa ninwii alɛ, ");
INSERT INTO snw_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Nse otii owo lɛkyakako fɔ ɛɛwako ɔsanko nɔɔ kayɔkɔ yi, tansiɛ di kasiɛkɔ kplɛ. Diekye dibafuo ɔwa alɛ bɛɛkyakako otii wɔ niɛtaka katoo alenke fɔ ni ninfa. ");
INSERT INTO snw_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ni otii wɔ niɛkyakako ni batii lee banyɔ mawa amatɔkɔ fɔ alɛ, ‘Taka faata otii wɔ mmle abasiɛ ninfa.’ Nioso fabataka fanaasiɛ di lɛba yɛntɛle ku sinunsɔ. ");
INSERT INTO snw_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Nkpo oso nse bɛɛkyakako fɔ bɛɛwako lɛba yi, kyɛ faalaasiɛ di kasiɛkɔ yɛntɛle. Nse otii wɔ niɛkyakako fɔ ni lɛwa yi, ni abatɔkɔ fɔ alɛ, ‘Siɛwo nii, taka ninfa, fabasiɛ di kasiɛkɔ kplɛ’ Nle mmle matakatɛsa fɔ katoo di batii ba bamuu bɛɛkyakako bɛɛwako ni ninfa anu. ");
INSERT INTO snw_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Diekye otii lele niɛtakatɛsa suoto katoo, Yaa mawakosa nwɔ kasɔ. Otii lele kafɔɔ niɛwakosa suoto kasɔ, Yaa matakatɛsa nwɔ katoo.” ");
INSERT INTO snw_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ninfɛ di Yesu latɔkɔ otii wɔ niakyakako nwɔ alɛ abale ni alesaa alɛ, “Nse fɔɔkyakako batii falɛ bawa babale alesaa yi, tanlɛɛ basiɛwo ee babilee ee banantii lɛfɔ ee basaawɛntɛ wo lɛfɔ lete. Ta mmle di mma kafɔɔ baalɛɛ fɔ alɛ wa fabaleko ma ni oso. Ni se dite nkpo, ni tofo falɛ lɛsaa le fɛɛbla fɛɛta ni koto nfɛ bɔɔta manta fɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Kafɔɔ nse foole dii le mmle okle yi, faalɛɛ bapiitɛ, ku batii ba ninoofuo ni ɔkyɛ nwaa, ku abafa ku banumbiɛtɛ. ");
INSERT INTO snw_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Nle mmle mata alɛ Yaa mawii fɔ lɛyɔɔ. Diekye batii ba mmle okle dilɔbafuo fɔ lɛsalɛsaa ɔbla ɔta. Yaa nimata fɔ koto di dii le baatii biene makple mantaka mankye ni bakpi kamɛ.” ");
INSERT INTO snw_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Obe wɔ baatii ba niasiɛ ni di opunu katũ onwii lɛma lanu ni sɛlaa se mmle, aatɔkɔ Yesu alɛ, “Suoto matɛ sinyɔɔ batii ba nimale ni alesaa di Yaa kafa nwu nkpo osie kanya.” ");
INSERT INTO snw_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ninfɛ di Yesu latɔkɔ nwɔ alɛ, “Di obe onwii kamɛ, osuɔtɔ onwii latũ opunu kplɛ, ni aakyakako batii kpinwu aawako alesaa nwu kalekɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Obe wɔ di alesaa nwu olebee ntoowo nii, aakpee batɔkyɛntɛ nɔɔ alɛ balaatɔkɔ batii ba aakyakako ni alɛ bawa. Diekye lɛsaa biala ntoosi! ");
INSERT INTO snw_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Kafɔɔ bamuu lɛma baakyako osuku ɔkaalɛ onwii onwii. Otii kasale latɔkɔ tɔkyɛntɛ nwu alɛ, ‘Lɛya kasɔ kanwii, nioso kɔkyɛ nnaanyu ka.’ Nkpo oso laatɔkɔ nwɔ falɛ, ‘Lekoto, namafuo ɔwa.’ ");
INSERT INTO snw_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Ɔbamba kafɔɔ alɛ, ‘Lɛya banankyue banyɔ banyɔ akyuu anɔɔ. Osuku nfɛ n-yɛ kafɔɔ kofe ma ɔsɔ onyu nse balɛ nɛ. Nle mmle oso, laatɔkɔ nwɔ falɛ, “Lekoto, namafuo ɔwa.” ’ ");
INSERT INTO snw_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Ɔbamba kafɔɔ alɛ, ‘Nunua wɔ mmle ntɔɔyɔ ɔsanko nɛ, nkposo namafuo ɔwa.’ ");
INSERT INTO snw_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Tɔkyɛntɛ nwu nkpo lakple aakyɛ aalaatɔkɔ saate nɔɔ sɛlaa se mmle simuu. Saate nɔɔ nwu lanya ɔblɔ osie kanya ni aatɔkɔ tɔkyɛntɛ nɔɔ alɛ, ‘Pɛsɛwa fatɔɔkyɛ okpoo sisuku ku akpaka faalaalɛɛ bapiitɛ ku batii ba ninoofuo ni ɔkyɛ nwaa ku banumbiɛtɛ ku abafa fawako.’ ");
INSERT INTO snw_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Ditaklɛ tɔkyɛntɛ nwu nkpo lakyɛ aakple aabatɔkɔ saate nɔɔ alɛ ntɔlaabla nkpo, kafɔɔ kasiɛkɔ lekple keebu. ");
INSERT INTO snw_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Nkpo oso saate nwu latɔkɔ tɔkyɛntɛ nwu alɛ, ‘Tɔɔkyɛ sekpoo kplɛ sisuku ku sibiibii suoto faakpee batii bamuu osie faakpaa ma fawako alɛ leyo nii kamɛ kayii. ");
INSERT INTO snw_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Kɔtɔkɔ ye ntikiti nlɛ batii ba bamuu lɛlɛɛ ni fiɛ beesĩ ni ɔwa, kuonwii lɛma dilabatu alesaa nii ya mmle anyu!’ ” ");
INSERT INTO snw_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Di obe onwii kamɛ baatii dikudi ninwii ku Yesu latɔɔkyɛ nii, ni aamunikĩi aatɔkɔ ma lɛ, ");
INSERT INTO snw_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Otii lele niɛwa ɔkyɛ nii, anambɔmbɔ mi alenkee ote ku ɔya, ɔsɔfɔ nɔɔ ku babi, babilɛma sankobi ku basuɔtɔbi ku nnwɔɔ omu nɔɔ suoto yi, ɔlɔbafuo mi saateketetɛ ole. ");
INSERT INTO snw_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Otii lele ninan-yɔ atoo nɔɔ atuka atikankoe di nkpaamaa, ɔlɔbafuo mi saateketetɛ ole. ");
INSERT INTO snw_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Nse otii lee owo komiɛ alɛ atofo leyo kplɛ lewo, lɛkasale ansiɛ kaasɔ ambu asaa ya nimafĩ ni leeyo nwu otofo kamɛ. Ambu koto ko ninte nwɔ nii, nse kubawo antofo fiɛ ankye kasɔ. ");
INSERT INTO snw_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Nse aabla nkpo, fiɛ ɛɛlaase lɛsɔse, ɔlɔbafuo leyo nwu otofo oloo. Batii ba bamuu nimanya ni leyo nwu siyiɛkuu mananloo ni otofo makyako leyo tofotɛ nwu ɔma alɛ, ");
INSERT INTO snw_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Otii wɔ mmle lekye leyo kasɔ, kafɔɔ aaloo otofo.’ ");
INSERT INTO snw_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Nse ɔka owo nkle bakpɛtɛ nkpe lefosi oofe ɔka wo nɔɔ wɔ ninkle ni bakpɛtɛ nkpe afosi anyɔ ɔkpɛ ko, abasiɛ ambu diisi nse osie wɔ ninkpe nwɔ ni, abafuo ɔka nwu ɔkpɛ ko. ");
INSERT INTO snw_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ni nse ɛɛnya alɛ ɔlɔbafuo ɔkɔ nwu osie oyilako, abakyesee batii, manaakyakako ɔka nwu nkpo, di obe wɔ anayitɛɛtɛɛ ma nii, mantikiti nwɔ lekoto, mankaalɛ onwii ɔbla.” ");
INSERT INTO snw_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Nfa nfɛ di Yesu layɛntɛ ɔlaa nɔɔ obuɛ ɔtɔkɔ ma alɛ, “Nkpo okle di aye kafɔɔ bilaafuo mi basaateketetɛ ole, diediki biediɛ lɛsaa biala biɛtɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Mba nlɛ. Kafɔɔ nse ditooyu ɔmɛnɛfɛ ni mi, lɛsalɛsa nsinnaa baakple man-yɔ mankpee mi ni ɔmɛnɛfɛ. ");
INSERT INTO snw_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Diesinlɛ dita bia kasɔ, ee bia lefleku, owii nfɛ man-yɔ manwii. “Nkpo oso aye ba kuunutoko nkpɛ nii binu!” ");
INSERT INTO snw_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Dii ninwii akpooto bafuntɛ ku bakpileblatɛ lawa Yesu nfũ babanu nwɔ ɔlaa. ");
INSERT INTO snw_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ninfa, Farisi batii ku kufiofa batuotɛ lakye kasɔ baatɔɔkakatɛ nwɔ di suoto alɛ, “Osuɔtɔ wɔ mmle lefũ bakpileblatɛ, anle bia alesaa ku mma!” ");
INSERT INTO snw_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Nkpo oso Yesu lapɛ ma lɛkpa alɛ, ");
INSERT INTO snw_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Nse diɛwa alɛ onwii lee nkpe bafoso kɔlafa, di onwii leyu kaamɛ, ɔlɔbadiɛ bafoso afosi anaasĩ banaasĩ nwu nkpo di alesaa kalekɔ alaawolaa onwii wɔ nieyu ni, diɛlaase di obe wɔ ɛɛnyɔɔ ni? ");
INSERT INTO snw_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ni nse ɛɛnyɔɔ, suoto dilabayɔɔ nwɔ osie kanya akɛnkɛ nwɔ atika di nimuusi. ");
INSERT INTO snw_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Akpaa nwɔ awako leyo. Abalɛɛ basiɛwo nɔɔ ku leyo nɔɔ batii ansiisa antɔkɔ ma alɛ, ‘Suoto kɔtɛ sinyɔɔ mi osie kanya, diekye ntɔɔnya foso nii nwu niayu nii. Biwa biɛbanyakoe suoto lɛyɔɔ!’ ");
INSERT INTO snw_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nioso kɔtɔkɔ ye nlɛ nkpo kafɔɔ di suoto lɛyɔɔ kplɛ mawɛ di Yaa kafa, nse kpileblatɛ onwii lekyi, ninlenkee babienetɛ afosi anaasĩ batii banaasĩ ba kaakyi diefĩ ni nɛ. ");
INSERT INTO snw_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Ee nse koto fututu lefosi nkpe ɔsanko owo, eeyu kunwii, lɛ ambla? Ansɔ kandiɛ anse, anfiɛ leyo nɔɔ kamɛ anwolaa kũ nwaa ninaase di obe wɔ ɛɛnya kũ nii. ");
INSERT INTO snw_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Nse ɛɛnya kũ, anlɛɛ bawo nɔɔ ku leyo nɔɔ batii ansiisa, antɔkɔ ma alɛ, ‘Suoto kɔtɛ sinyɔɔ mi osie kanya, diekye ntɔɔnya koto nii nwu niayu nii, bibanyakoe suoto lɛyɔɔ.’ ");
INSERT INTO snw_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nwaako kɔtɔkɔ ye nlɛ, nkpo okle kafɔɔ di Yaa batɔkyɛntɛ nnya suoto lɛyɔɔ di kpileblatɛ onwii wɔ niekyi ni suoto nɛ.” ");
INSERT INTO snw_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu lakple abuɛ akyakaa alɛ, “Osuɔtɔ onwii lawɛ, aawa babi suɔtɔbi banyɔ banwii. ");
INSERT INTO snw_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ninfɛ di obisɔnle latɔkɔ ote alɛ, ‘Teete, yɔ kalekɔ nii ka fabatɛɛ ni di asaa lɛfɔ kamɛ fatɛɛ ninua.’ Nkpo oso osuɔtɔ nwu nkpo layɔ asaa nɔɔ aasɛ aata babi nwu nkpo banyɔ. ");
INSERT INTO snw_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Di ayi awo kamaa, obisɔnle nwu nkpo layɔ asaa nɔɔ nwu amuu aasunsũ aafũ koto aadie leeyo, aasifi kale bamba fanfanfa. Aalaasiɛ nkpa lɛlaale, aalalaasa koto nɔɔ nwu kumuu. ");
INSERT INTO snw_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Obe wɔ aale koto nɔɔ nwu kumuu kualoo nii, ditaklɛ, kɔka kplɛ kunwii labakpɛ kaasɔ nwu nkpo suoto. Aabakple piitɛ, nle aale ni lawɛ nwɔ osie. ");
INSERT INTO snw_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Nioso aayɔ suoto aalaakpee awoba di osuɔtɔ onwii nfũ di kasɔ nwu suoto. Ninfɛ di osuɔtɔ nwu lakpaa nwɔ aasifiko kakpayotũ nɔɔ alɛ, alaatoonyu nwɔ aplakuo nɛ. ");
INSERT INTO snw_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Kɔka oso, aamiɛ alɛ se aatoole aplakuo nwu alesaa awo, kafɔɔ kuonwii ditatɔɔ osuku alɛ ale. ");
INSERT INTO snw_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Nioso, osuɔtɔbi nwu lababuo di suoto nɔɔ kamɛ aabuɛ alɛ, ‘Batii ba di teemi lefũ bɔɔbla sɛkpɛ mantɔɔ nii, alesaa diefĩ ma, boole mammiɛ. Ni di mi nsi ninfũ kɔka kolo mi nɛ! ");
INSERT INTO snw_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Makple nsifi teemi nfũ nnaatɔkɔ nwɔ nlɛ, “Teete, lɛbla okpile leyila di Yaa ku afɔ suoto. ");
INSERT INTO snw_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ninsinsiɛko alɛ faalɛɛ mi alɛ obi lɛfɔ. Kafɔɔ yɔ mi fabla fɛle bakpɛmblatɛ lɛfɔ onwii lɛma feefũ ni.” ’ ");
INSERT INTO snw_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Nfanwu ni aataka aayɔ asaa aayefe osuku aatoofe ote nfũ nɛ. “Obe wɔ akyɛ di osuku fanfa ɔɔwa nii, ni di ote lanyɔɔ nɛ. Ɔlaa nɔɔ lakpɛ ote nyaami. Ni aatoso aakyɛ aalaaminiko nwɔ ku suoto lɛyɔɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Ninfɛ di obi labuɛ alɛ, ‘Teete, lɛbla okpile leyila di Yaa ku afɔ suoto. Ninsinsiɛko alɛ faalɛɛ mi falɛ obi lɛfɔ!’ ");
INSERT INTO snw_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Kafɔɔ, ote latɔkɔ bakpɛmblatɛ nɔɔ alɛ, ‘Bipɛsɛwa! Biɛyɔ awu biene anwii bibakpee nwɔ. Biɛyɔ lɛkɔnii ku ntokota biene bibakpee nwɔ. ");
INSERT INTO snw_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Nle mmle kamaa, biɛkyɛ bilaamufũ nankyue wɔ ninsi ni lɛla bilo biɛwa alesaa, buɔnya suoto lɛyɔɔ. ");
INSERT INTO snw_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Diekye obi nii wɔ mmle, buɔyɔ fɛ aakpi. Kafɔɔ atookple ɛɛsɛnkɛ. Aayu, kafɔɔ butookple buɔnyɔɔ.’ Nioso, baakyako suoto lɛyɔɔ ɔnya. ");
INSERT INTO snw_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Di obe nwu nkpo kamɛ, obi nɔɔ nɔɔfo lafe kofe. Obe wɔ atookye kofe ɔɔwa nfɛ ɔɔtɛɛtɛɛ ni leyo, aanu sinu ku katũ kanya osie kanya. ");
INSERT INTO snw_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Nioso, aalɛɛ kpɛmblatɛ onwii, ni aakaalɛ nwɔ alɛ, ‘Be ninkpe leeyo?’ ");
INSERT INTO snw_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ninfɛ di kpɛmblatɛ nwu ladiki kanya aatɔkɔ nwɔ alɛ, ‘Obilee nintookple ɛɛwa, ni di teefɔ lɛta beelo nankyue wɔ ninsi ni lɛla nɛ, diekye atookple ɛɛwa buɛɛ okpile kuonwii dietũ nwɔ.’ ");
INSERT INTO snw_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Nkpo oso obi nɔɔfole nwu lanya ɔblɔ osie kanya alɛ, oloosinkyɛ leyo. Ta nkpo oso, ote ladie aakyɛ ɔkyɛ nɔɔ aalaatikiti nwɔ lekoto alɛ awa baasifi leyo. ");
INSERT INTO snw_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Kafɔɔ obi nwu lamunikĩi aakaalɛ ote alɛ, ‘Nyu lo! Ntɔɔbla ɔkpɛ lɛta fɔ alɛɛ ya kpe fɛ ɔlanle. Diidii kafɔɔ ninsĩ fɔ ɔlaa onu. Obe fatɔɔbla fɛɛtɛɛ ami? Diidii bia tie, fayitɛɛ falɛ nnya suoto lɛyɔɔ ku bawo nii. ");
INSERT INTO snw_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Kafɔɔ obi lɛfɔ wɔ mmle nintɔɔlalaasa fɔ ni asaa ku basanko basɔnɔkpeetɛ lekple ɛɛwa nii, fatoolo nankyue wɔ ninsi ni lɛla fɛɛtɔɔ nnwɔɔ!’ ");
INSERT INTO snw_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Ninfɛ di ote latɔkɔ nwɔ alɛ, ‘Obi nii, munkofɔ ninsi ninfũ obe lele, lɛsaa lele kafɔɔ ninkpe mi, lele fɔ dile. ");
INSERT INTO snw_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Kafɔɔ, dikpe nii munya suoto lɛyɔɔ, mumpɔ. Diekye buɔyɔ bulɛ okpi di obilee lakpi, ni eekple ɛɛsɛnkɛ nɛ. Oyu aayu ni buokple buɔnyɔɔ nɛ.’ ” ");
INSERT INTO snw_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu latɔkɔ basaateketetɛ nɔɔ alɛ, “Osuɔtɔ onwii lawɛ, aale saawɛntɛ. Aawɛ kpɛmblatɛ onwii niatoonyu nwɔ ni asaa. Ni baabatɔkɔ saawɛntɛ nwu nkpo alɛ, asaa nyuntɛ nɔɔ kole nwɔ kote. ");
INSERT INTO snw_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Nkpo oso saawɛntɛ wɔ mmle lalɛɛ saanyuntɛ nwu nkpo aatɔkɔ nwɔ alɛ, ‘Be lɛsaa ninle nle konu nkyeko ni suoto lɛfɔ nkpo? Babla nkuntaa di asaa nii ya amuu foonyu ni suoto fatɛɛ. Diekye flabasinfuo mi asaa nyuntɛ ole.’ ");
INSERT INTO snw_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Ninfɛ di kpɛmblatɛ nwu latɔkɔ suoto alɛ, ‘Saate nii nfɛ madiɛ mi di ɔkpɛ kamɛ. Lɛ nfɛ mabla? Nnaa osie kafɔɔ makpɛ ni kofe. Asaa ɔkaalɛ kafɔɔ nkpɛ mi sinunsɔ. ");
INSERT INTO snw_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ahaa! Nfɛ n-ye lɛsaa le mabla nii! Ni nse ɔkpɛ nii lɛba die mi di nnɛɛ, baasiɛwo nii matoofũ mi ni laayo lɛma, mantoonyu mi ni kanya.’ ");
INSERT INTO snw_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Nkpo oso aalɛɛ batii ba ninsiko ni saate nɔɔ koto onwii onwii. Ni aakaalɛ ɔkasale alɛ, ‘Lɛ fasiko saate nii?’ ");
INSERT INTO snw_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Ninfɛ di totɛ nwu latɔkɔ nwɔ alɛ, ‘Nsiko nwɔ nnɔfɔ ataase kɔlafa.’ “Ni di saanyuntɛ nwu nkpo latɔkɔ nwɔ alɛ, ‘Nya koto lɛfɔ kukũ ninfũ. Siɛ kaasɔ, faakpana falɛ afosi anɔɔ pɛ niebu.’ ");
INSERT INTO snw_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Ninfɛ aakaalɛ ɔnyɔɔfa alɛ, ‘Ni afɔ mɔ? Lɛ koto fasiko?’ “Ninfɛ di nnwɔɔ kafɔɔ aabuɛ alɛ, ‘Diɛbla atitabi atofo kɔlafa.’ “Ninfɛ di saanyuntɛ nwu nkpo latɔkɔ nwɔ alɛ, ‘Nya kukũ lɛfɔ ninfũ. Kpana afosi anɛ.’ ");
INSERT INTO snw_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Nle mmle oso, saate nwu nkpo latansa saanyuntɛ nwu ninambla ni asaa di osuku kanya alɛ eebe anu. Nwaako, batii ba ninsi ni kaayi lebe anu di kayi asaa ɔbla suoto balenke batii ba ninsi ni di Yaa kafa lɛkpa kamɛ.” ");
INSERT INTO snw_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ninfɛ di Yesu lakple aabuɛ aakyakaa alɛ, “Aye biyɔ kayi asaa ɔwɛ bikyakaako batii. Nse nnya nkpo ntɔɔbafe yi, Yaa mafũ ye di kafa nɔɔ ka ninnaa ni kaloo. ");
INSERT INTO snw_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Otii lele nielolaa asaa ya ninle ni abiibii eenyu di osuku kanya, abafuo akplɛ kafɔɔ onyu di osuku kanya. Otii lele ninanlolaa asaa ya ninle ni abiibii anyu di osuku kanya, ɔlɔbafuo n-ya ninle kplɛ kafɔɔ onyu di osuku kanya. ");
INSERT INTO snw_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ni nse biloofuo kayi ka mmle asaa ololaa oklee di osuku kanya, ni lɛ nfɛ di otii mafuo ye ofũ onu alɛ biafuo ninwuna kamɛ asaa ya di Yaa lɛta ye ni oklee di osuku kanya? ");
INSERT INTO snw_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ni nse biloofuo otii bamba lɛsaa onyu di osuku kanya, ni lɛ nfɛ dibabla fiɛ baayɔ nle ninle ye ni lele manta ye? ");
INSERT INTO snw_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Kpɛmblatɛ kuonwii dilaafuo basaate banyɔ sɛkpɛ ɔbla. Diekye abasĩ onwii ambɔmbɔ onwii. Ee abakyɔɔ onwii ɔlaa kotoko, ansĩ onwii kotoko ɔkyɔɔ. Flɔbafuo Yaa ku lɛsaawɛ ɔkpɛ ɔbla ɔkpɔtɔɔsa.” ");
INSERT INTO snw_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Obe wɔ di Farisi batii lanu ni sɛlaa se di Yesu labuɛ nii, baama nwɔ diekye baabɔmbɔ koto osie kanya. ");
INSERT INTO snw_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ninfɛ di Yesu latɔkɔ ma alɛ, “Aye ninle mba ninta ni suoto lɛbɛ di batii anu nɛ. Kafɔɔ Yaa n-ye ye situ kamɛ. Diekye asaa ya niefũ ni kɔya di batii anu yi, diedie lɛsalɛsaa di Yaa anu. ");
INSERT INTO snw_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Mose kufiofa ku Yaa ɔlaa babuɛtɛtɛ asaa ya bɛɛkpana bɛɛtɛ nii, labla ɔkpɛ dialaase di Ntu Kpeesatɛ Yohane obe. Diɛyɔ ni di obe nwu kamɛ, ni bɛɛkyako Yaa sɛka kalekɔ ɔlaa biene nwu obuɛ nɛ. Otii biala kɔkpɛ ku okyiini ambuo Yaa sɛka kalekɔ nwu kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Kafɔɔ, diɛtɛ diɛyɔɔ alɛ osi ku kasɔ kafe, ninlenkee alɛ Mose kufiofa kabɛfɛɛ kadie kaamɛ alɛ baabla. ");
INSERT INTO snw_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Osuɔtɔ lele niesĩ ɔsɔfɔ ɛɛlaayɔ ɔsanko bamba, ntookpee asɔnɔ. Osuɔtɔ wɔ kafɔɔ nimayɔ ni ɔsanko wɔ beesĩ ni, ntookpee asɔnɔ. ");
INSERT INTO snw_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Osuɔtɔ onwii lawɛ, aale saawɛntɛ. Obe lele ankpee asaa ya niefũ ni kɔya. Aasiɛ nkpa obe lele di suoto lɛyɔɔ kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Piitɛ onwii kafɔɔ lawɛ baatɔɔlɛɛ nwɔ ni Lasaro. Nkɔ latitika nwɔ di suoto kpinwu. Nioso mankpaa nwɔ manasiɛsa di saawɛntɛ nwu koyokontũ. ");
INSERT INTO snw_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Antoonyu osuku alɛ nse saawɛntɛ nwu nkpo kole alesaa yi, kɔbɛfɛɛ ko nikɔkpa kumpɛ ni kaasɔ aayɔ anle. Baweewee bia ninwa mamatɔɔya nwɔ nkɔ. ");
INSERT INTO snw_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Piitɛ nwu nkpo labakpi, Yaa batɔkyɛntɛ labakpaa nwɔ baasifiko Abraham nkpaatũ di Yaa kafa baatɔɔnya suoto lɛyɔɔ. Saawɛntɛ nwu kafɔɔ labakpi baakookaa nwɔ. ");
INSERT INTO snw_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Di bakpi kamɛ ninfa, obe wɔ asi ni diibuo kamɛ, aatakatɛsa anu aanyu osi. Ni aanya Abraham fanfanfa di osi nɛ. Lasaro lasiɛ nwɔ di nkpaatũ. ");
INSERT INTO snw_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Nfanwu saawɛntɛ nwu lalɛɛ osie kanya alɛ, ‘Teete Abraham! Nyɛɛ nyaami, faata Lasaro ayɔ lɛnɛɛ nɔɔ alaanyɔ nintu nwo kamɛ abalɛsɛsa di ɔkplalomii nii suoto diɛyɔɔ mi kɛɛkɛ. Diekye kofiɛ di ɔtɔ wɔ mmle kamɛ!’ ");
INSERT INTO snw_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Kafɔɔ Abraham latɔkɔ nwɔ alɛ, ‘Obi nii, nyuma falɛ di nkpa lɛfɔ kamɛ, asaa biene lete faafũ. Lasaro nnwɔɔ yi, asaa kpile lete aafũ. Kafɔɔ nunua yi, nfɛ ɔɔnya suoto lɛyɔɔ ninfũ, kafɔɔ afɔ fasi diibuo kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Diɛkyakaa nii kafɔɔ yi, dibiɔ kplɛ ninwii nte di awo ku afɔ ntɛɛ. Nse otii owo komiɛ alɛ ataalɛ awa nfa, ɔlɔbafuo. Nkpo kafɔɔ di otii kuonwii dilɔbafuo okye ninfa ɔtaalɛ ɔwa ɔkyɛ loo nɛ.’ ");
INSERT INTO snw_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Nfa nfɛ di saawɛntɛ latɔkɔ nwɔ alɛ, ‘Teete Abraham, kotikiti fɔ lekoto nlɛ kpee Lasaro aakyɛ teemi leyo. ");
INSERT INTO snw_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Nkpe babilɛma suɔtɔbi, banɔɔ ninfa. Aalaakpee ma kufiofa osie kanya alɛ balaawa lɛba le mmle di dibuo nkpe ni.’ ");
INSERT INTO snw_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Ninfɛ di Abraham latɔkɔ nwɔ alɛ, ‘Mose ku Yaa ɔlaa babuɛtɛtɛ nkpe di babilee suɔtɔbi nfũ. Dikpe ni mankyɔɔ ma ɔlaa wɔ boobuɛ ni atoko.’ ");
INSERT INTO snw_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Kafɔɔ saawɛntɛ nwu lakple aabuɛ alɛ, ‘Teete Abraham, blɔbanu ma ɔlaa! Kafɔɔ nse otii owo lɛtaka eekye bakpi kamɛ, ɛɛkyɛ ɛɛlaatɔkɔ ma yi, babanu nwɔ ɔlaa mankyi siikpile lɛma kamɛ.’ ");
INSERT INTO snw_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Kafɔɔ Abraham lakple aatɔkɔ nwɔ alɛ, ‘Nse blɔbanu Mose ku Yaa ɔlaa babuɛtɛtɛ ɔlaa kamaa, nse otii lɛtaka eekye bakpi kamɛ kafɔɔ ɛɛkyɛ ɔkyɛ lɛma yi, blɔbanu nwɔ ɔlaa!’ ” ");
INSERT INTO snw_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu latɔkɔ basaateketetɛ nɔɔ alɛ, “Asaa ya nimakpaa otii ankpee ni di okpile kamɛ mawa kokooko. Kafɔɔ otii wɔ suoto abafe anwa nii, ayɔɔsa! ");
INSERT INTO snw_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Nse bɛɛyɔ kukuɔ beenii bɛɛsakasa nwɔ siimu, bɛɛyɔ nwɔ beefuki beekpee di lekpo kamɛ, ditabalɛ nwɔ ninleenkee alɛ aata babisɔ ba mmle onwii lɛma mbla okpile. “Nse obilee lɛbla okpile yi, faasĩ ɔlaa fatɔɔ. Nse eekyi di otu kamɛ, eetikiti lekoto, faayɔ fakyɛ nwɔ. ");
INSERT INTO snw_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Nkpo oso bilolaa binyu nwaa di lɛsaa lele biɔɔbla. ");
INSERT INTO snw_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nse ɛɛbla fɔ okpile sikuɛnsĩ, di dii ninwii kamɛ, eekple ɛɛwafɔ ɔkyɛ di sikuɛnsĩ nwu nkpo kamɛ, ɛɛbatikiti fɔ lekoto, faayɔ fakyɛ nwɔ.” ");
INSERT INTO snw_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Yesu batɔkyɛntɛ nɔɔ latikiti nwɔ lekoto alɛ, “Saate, ta ofũ onu loo kupɔ.” ");
INSERT INTO snw_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ninfɛ di Saate nwu latɔkɔ ma alɛ, “Nse bikpe ofũ onu fɛ sɛfá dibi, biafuo kowoso ko mmle ɔtɔkɔ bilɛ sifi suoto ninfũ mmle, ‘Falaasɔ suoto di lekpo kamɛ,’ ku babla ninkpo. ");
INSERT INTO snw_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Biyɔ bilɛ onwii lee nkpe kpɛmblatɛ wɔ nikɔkpɛ nwɔ ni kofe, ee oonyu nwɔ ni bafoso. Nse eeyie koofe, bibatɔkɔ nwɔ bilɛ, pɛsɛwa fabasiɛ kaasɔ faale alesaa lɛfɔ? ");
INSERT INTO snw_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Oowo! Kafɔɔ bibatɔkɔ nwɔ bilɛ, ‘Lolaa suoto faakpee awu, faawa alesaa, faatɛɛ ale mi nle, ninyi nloo fiɛ faalaale, ale fɔ.’ ");
INSERT INTO snw_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Nse kpɛmblatɛ nwu lɛkyɔɔ saate nɔɔ kotoko, kyinkyinaa dile alɛ saate nwu lɛpɛ kpɛmblatɛ nɔɔ nwu sɛfa? ");
INSERT INTO snw_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Nkpo kafɔɔ ayee, nse bitooloo sɛkpɛ lee se bɛɛta ye alɛ biabla nii, biabuɛ bilɛ, ‘Awo, bakpɛmblatɛ ba ninandie ni lɛsalɛsaa ko bule. Lɛsaa le dikpe ni buɔbla nii, nni butɔɔbla nɛ.’ ” ");
INSERT INTO snw_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Obe wɔ di Yesu latoofe ni Yerusalem, aafe di Samaria ku Galilea kɔmɛ suoto. ");
INSERT INTO snw_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Aatoofe kaakpaayotũ kanwii kamɛ, ni aakyakako basuɔtɔ lefosi bawo niatoofiɛ ni ofiɛ sɛɛle nɛ. Baayila fanfa. ");
INSERT INTO snw_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ni baafaa osie kanya baabuɛ alɛ, “Teete Yesu! Nya wo nyaami!” ");
INSERT INTO snw_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesu lanya ma ni aatɔkɔ ma alɛ, “Bitɔɔkyɛ biɛlaayɔ suoto bituo Yaa oletatɛ aanyunyu ye nwaa.” Obe wɔ bakyɛ ni di osuku boofe nii, ni di ofiɛ nwu layɔɔ ma nɛ. ");
INSERT INTO snw_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Nioso obe wɔ di onwii lɛma lanya alɛ ofiɛ nwu ntɔɔyɔɔ nwɔ nii, aapɛ aakple aatɔɔtansa Yaa ku kudu osie kanya. ");
INSERT INTO snw_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ninfɛ aakyɛ aawa aabapɛ akunkyi di Yesu nkpaatũ, aapɛ nwɔ sɛfa nɛ. Osuɔtɔ nwu nkpo Samaria otii aale. ");
INSERT INTO snw_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ninfɛ di Yesu lakaalɛ alɛ, “Diele basuɔtɔ lefosi lɛyɔɔsa ofiɛ? Ni fɛ baanaasĩ bule nkpe? ");
INSERT INTO snw_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Lɛ diɛwa fiɛ di otii wɔ ninanle ni Yuda otii niɛpɛ eekple ɛɛwa ɔɔpɛ Yaa sɛfa?” ");
INSERT INTO snw_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ninfɛ di Yesu latɔkɔ nwɔ alɛ, “Taka, faatɔɔkyɛ. Ofũ onu lɛfɔ ntɔɔyɔɔsa fɔ ofiɛ.” ");
INSERT INTO snw_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Diawa alɛ Farisi batii bawo lakaalɛ Yesu obe wɔ di Yaa sɛka kalekɔ nwu mawa nii. Yesu latɔkɔ ma alɛ, “Yaa sɛka kalekɔ nwu dilɔbawa di osuku wɔ batii manya nii. ");
INSERT INTO snw_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Kuonwii dilɔbabuɛ alɛ, ‘Binyu lo! Nyaka ninfũ,’ ee ‘Nyaka ninfa.’ Diekye Yaa sɛka kalekɔ nwu nkpo nfɛ nsi ye kaamɛ.” ");
INSERT INTO snw_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ninfɛ aatɔkɔ basaateketetɛ nɔɔ alɛ, “Obe kɔwa bibamiɛ bilɛ biɔnya ni ami, Otii Obi nwu, ayi nii nwu lewo, kafɔɔ bilɔɔwa ɔbanya! ");
INSERT INTO snw_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Batii bawo kamawa mamatɔkɔ ye alɛ, ‘Binyu nfa lo, akpe ninfa,’ ee ‘Binyu nfũ lo, akpe ninfũ!’ Kafɔɔ bitankyɛ bialaawolaa mi ninfa! ");
INSERT INTO snw_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Diekye fɛ mmle di ɔplalaa mmunaa ni di osi, kunkye ni kakyɛ kanwii, kumafe ni kakyɛ bamba, kɔtɔkɔ ye nlɛ nkpo di ami, Otii Obi nwu nkpo, ɔwabee kamate nɛ. ");
INSERT INTO snw_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Kafɔɔ lɛkasale, dikpe nii, lefe di dibuo kpinwu kamɛ, miɛ batii nsĩ mi. ");
INSERT INTO snw_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Fɛ mmle diawa ni di Noa obe kamɛ, nkpo okle kafɔɔ diɔwa ɔbawa di ami, Otii Obi nwu, ɔwabee kamɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Di obe nwu kamɛ, batii latoole baatoonyi. Basanko ku basuɔtɔ latoobuo di sɛsa ku sɛsɔfɔ kamɛ, baayɔ basankobi kafɔɔ baatɔɔta asa dialase di dii le di Noa labuo ni di oklo kplɛ nwu kamɛ. Fiɛ nfɛ di kanto labanɔɔ ntu layii kasɔ kamuu, diawɔɔsa batii bamuu. ");
INSERT INTO snw_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Dibate fɛ mmle diawa ni di Lot obe kamɛ kafɔɔ. Batii latoole baatoonyi, baatɔɔya asaa baatoosunsũ. Bawo latɔɔkpɛ afe, bawo kafɔɔ latootofo ayo. ");
INSERT INTO snw_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Dii le di Lot ladie ni di Sodom, ni di ɔtɔ ku ɔtɔ afuɔ lakye osi kuabakpete di okpoo nwu kamɛ, kuawɔɔsa bamuu lɛma nɛ. ");
INSERT INTO snw_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Nkpo okle kafɔɔ diɔwa ɔbate di dii le di ami, Otii Obi nwu, kamadie nkyɔɔ ni nɛ. ");
INSERT INTO snw_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Di dii nwu nkpo suoto, Otii wɔ kafɔɔ nintika ni di leyo nɔɔ osi, atantɔkɔ alɛ oosoo anwa amayɔ lɛsalɛsa nɔɔ leeyo kamɛ ansifiko. Nkpo okle kafɔɔ di otii wɔ ninkpe ni koofe, atasinkple aatɔkɔ alɛ ooyie ammayɔ lɛsalɛsaa nɛ. ");
INSERT INTO snw_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Binyuma lɛsaa le niawa ni di Lot ɔsɔfɔ suoto! ");
INSERT INTO snw_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Otii lele niemiɛ alɛ ɔɔta nkpa nɔɔ, abayu mi. Otii lele kafɔɔ nieyu nkpa nɔɔ, abakple anwɛ mi. ");
INSERT INTO snw_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Kɔtɔkɔ ye nlɛ di dii nwu nkpo kakyɛ, batii banyɔ mate di atensaa anwii suoto, Yaa makpaa onwii ansifiko, andiɛ ɔnyɔɔfa nnte. ");
INSERT INTO snw_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Basanko banyɔ matookuɔ nnaafũ di kukuɔ suoto, kafɔɔ Yaa makpaa onwii ansifiko andiɛ ɔnyɔɔfa di kukuɔ katũ. ");
INSERT INTO snw_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Basuɔtɔ banyɔ mayila koofe mantɔɔkpɛ, Yaa makpaa onwii ansifiko andiɛ ɔnyɔɔfa antɔɔkpɛ.” ");
INSERT INTO snw_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ninfɛ di basaateketetɛ nɔɔ lakaalɛ nwɔ alɛ, “Saate di ɔfɛ?” Ninfɛ di Yesu ladiki kanya alɛ, “Lɛba le lɛɛsaa lekpi dite nii, nfa di alente nsi nɛ.” ");
INSERT INTO snw_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesu Lapɛ lɛkpa aatuo basaateketetɛ nɔɔ lɛsaa alɛ, dikpe nii, obe lele, bɛɛtɔɔpɛ ɔlaa bɛɛtɔɔta Yaa di nnɛɛ ɔtanfeesa kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Aatɔkɔ ma alɛ, “Kantɛ onwii lawɛ di okpoo onwii kamɛ, ananyɛkɛ ni Yaa ee otii. ");
INSERT INTO snw_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Kpisɔfɔ onwii kafɔɔ lawɛ di okpoo nwu nkpo kamɛ, aatɔɔkyɛ kantɛ nwu nkpo nfũ wlawla aalaatootikiti nwɔ lekoto alɛ, ‘Kyakaakoe ta balo nii oso.’ ");
INSERT INTO snw_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Diaklɛ, kantɛ nwu nkpo ditatookpee ɔlaa nwu kanya. Kafɔɔ sɛmaa aabatɔkɔ suoto alɛ, ‘Kuntɛ ninyɛkɛ Yaa ee labu otii yi, ");
INSERT INTO snw_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ta kubuɛ ko di kpisɔfɔ wɔ mmle kokpee mi ni oso, manyu nlɛ lɛtɔɔ lɛbɛ. Se diele nkpo, obe lele abatɔɔwa nfũ amatoodiki mi ninwuna.’ ” ");
INSERT INTO snw_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ninfɛ di Saate nwu lakple aabuɛ aatɔkɔ ma alɛ, “Binu ɔlaa wɔ di kantɛ wɔ mmle kpile labuɛ ni. ");
INSERT INTO snw_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ni, Yaa dilɔbatuna ata batii nɔɔ ba bamuu ninpɛ ɔlaa mantɔɔ ni kakũ ku kakyɛ? Sɛɛ bienyu bilɛ ɔlɔbapɛsɛwa akyakaako ma? ");
INSERT INTO snw_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nwaako kɔtɔkɔ ye nlɛ Yaa matuna ma wla. Kafɔɔ nse Otii Obi nwu lɛwa, abanya batii ba niefũ beenu ni kaasɔ ka mmle?” ");
INSERT INTO snw_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesu lakple aapɛ lɛkpa ninwii di batii ba ninnyu alɛ bate ni tinini, mannyu ni batii bamba alɛ baate ni fɛ mma. ");
INSERT INTO snw_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Ni aatɔkɔ ma alɛ, “Obe onwii kamɛ, batii banyɔ banwii lakyɛ Yaa Olekatakɔ alɛ bɔɔlaapɛ ɔlaa manta Yaa. Onwii lale Farisi otii, ɔnyɔɔfa kafɔɔ lale akpooto funtɛ. ");
INSERT INTO snw_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farisi otii nwu lablasa suoto aayila aapɛ ɔlaa aata Yaa aabuɛ alɛ, ‘Yaa, kɔpɛ fɔ sɛfa, diekye nnaa koto onumbɛbɛɛ, ninle otii kpile, ninle sɔnɔkpeetɛ fɛ mmle baatii bamba mbla nii. Kɔpɛ fɔ sɛfa kafɔɔ alɛ, ninte fɛ akpooto funtɛ nwu nkpo nin-yɛ ni ninfa. ");
INSERT INTO snw_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nnii kanya ayi anyɔ di osuku kaanya kamɛ. N-yɔ kafɔɔ asaa ya amuu ninwɛ ni lefosile nwako fɔ.’ ");
INSERT INTO snw_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Kafɔɔ akpooto funtɛ nwu nkpo layila fanfa, atakplesa bia anu aanyu osi. Ni aayɔ kɔnɛɛ aatika nintɛɛ aabuɛ alɛ, ‘Yaa, kpileblatɛ nle, nyɛɛ nyaami!’ ” ");
INSERT INTO snw_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ninfɛ di Yesu latɔkɔ ma alɛ, “Kɔtɔkɔ ye nlɛ, akpooto funtɛ nwu nkpo lakple aasifi leyo, klekle di Yaa anu aalenkee Farisi otii nwu nkpo. Diekye otii lele niɛtakatɛsa suoto katoo, Yaa mawakosa nwɔ kasɔ. Kafɔɔ otii lele niɛwakosa suoto kasɔ, Yaa matakatɛsa nwɔ katoo.” ");
INSERT INTO snw_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Batii bawo lakpaa babi lɛma baawako Yesu nfũ alɛ atika ma nnɛɛ di asi. Obe wɔ di Yesu batɔkyɛntɛ lanya ni batii nwu nkpo, baasĩ ɔlaa baata ma ta lɛsaa nwu oso. ");
INSERT INTO snw_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Kafɔɔ Yesu lalɛɛ babisɔ nwu nkpo aawako ɔkyɛ nɔɔ, ni aabuɛ alɛ, “Bita babisɔ bawa ɔkyɛ nii, bitantĩi ma osuku. Diekye batii fɛ babisɔ ba mmle okle kale ninle Yaa sɛka kalekɔ nwu nkpo nɛ. ");
INSERT INTO snw_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Binyuma nle mmle, otii lele ninanfũ Yaa kafa nwu fɛ obisɔ, dilɔbabuo nfa diidii.” ");
INSERT INTO snw_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Yuda batii tunletɛ onwii lakaalɛ Yesu alɛ, “Saatuotɛ biene, be kabla fiɛ kawɛ nkpa be ninnaa ni kaloo?” ");
INSERT INTO snw_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ninfɛ di Yesu lakaalɛ nwɔ alɛ, “Be oso fɔɔlɛɛ mi otii biene? Otii kuonwii nnaa ale ni bienetɛ, diediki Yaa lete. ");
INSERT INTO snw_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Faye Yaa afiofa amuu. ‘Tanlo otii, tankpee asɔnɔ, tan-yu, tanlaa faatika di otii suoto, bu teefɔ ku Yaafɔ.’ ” ");
INSERT INTO snw_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ninfɛ di ɔnɔɔfo nwu labuɛ alɛ, “Diɛyɔ ni bia sibisɔ nii obe, lɛkyako afiofa ya mmle nwu nkpo ole.” ");
INSERT INTO snw_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Obe wɔ di Yesu lanu ni ɔlaa wɔ mmle, ni aatɔkɔ nwɔ alɛ, “Diebu fɔ lɛsaa ninwii dikpe ni fɛɛbla nii. Laayɔ asaa lɛfɔ amuu fasunsũ, faayɔ koto nwu fata bapiitɛ, ni fabawɛ asaa di Yaa kafa. Nni kamaa faawa fabatikankoe.” ");
INSERT INTO snw_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kafɔɔ obe wɔ di osuɔtɔ wɔ mmle lanu ni sɛlaa se mmle, suoto ditayɔɔ nwɔ, diekye saawɛntɛ aatɛ aale. ");
INSERT INTO snw_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu lanya alɛ suoto ditayɔɔ nwɔ, nioso aabuɛ alɛ, “Dikpe osie diɛta basaawɛntɛ fiɛ bababuo Yaa kafa! ");
INSERT INTO snw_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Diɛbla lɛsaa le niɛyɔɔ diɛta ni kapupunkɔ alɛ aafe di paniɛ dituɛ, dilenke alɛ saawɛntɛ kabuo ni Yaa sɛka kalekɔ.” ");
INSERT INTO snw_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Batii ba nianu ni sɛlaa se mmle lakaalɛ Yesu alɛ, “Ni owe nfɛ nimawɛ didiki?” ");
INSERT INTO snw_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ninfɛ di Yesu labuɛ alɛ, “Lɛsaa le di otii dilɔbafuo ni ɔbla diidii, Yaa nnwɔɔ abafuo ni ɔbla.” ");
INSERT INTO snw_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ninfɛ di Petro latɔkɔ Yesu alɛ, “Nyu! Awo buodiɛ ayo loo buɔtɛ buɔwa butikanko fɔ.” ");
INSERT INTO snw_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ninfɛ di Yesu latɔkɔ ma alɛ, “Nwaako dile. Kafɔɔ kɔta ye mintofo nlɛ otii lele niediɛ leyo nɔɔ ɛɛtɛ, ee ɔsɔfɔ nɔɔ ɛɛtɛ, ee babilɛma suɔtɔbi ɛɛtɛ, ee ote ku ɔya ɛɛtɛ, ee babi nɔɔ ɛɛtɛ, ta Yaa sɛka kalekɔ oso, ");
INSERT INTO snw_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","abawɛ asaa nwu nkpo ampɔɔsa di nkpa be mmle kamɛ ku nkpa be nikɔwa dinnaa ni kaloo kafɔɔ kamɛ.” ");
INSERT INTO snw_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu lalɛɛ batɔkyɛntɛ nɔɔ lefosi batii banyɔ nwu di ɔlɔɔkɔ ni aatɔkɔ ma alɛ, “Binu lo! Nfɛ buofe Yerusalem, nfũ di asaa ya di Yaa ɔlaa babuɛtɛtɛ lɛkpana bɛɛtɛ ni di ami, Otii Obi nwu, suoto mawa ni kaanya. ");
INSERT INTO snw_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Batii mayɔ mi mankpee di batii ba ninanle ni Yuda batii nnɛɛ kamɛ, babama mi, mantufa mi, mantufa sita kafɔɔ mankpete mi di suoto. ");
INSERT INTO snw_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Babapɛ mi, manlo mi, kafɔɔ dii tiɛfa kamaa, makple ntaka nkye bakpi kamɛ.” ");
INSERT INTO snw_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Kafɔɔ basaateketetɛ nɔɔ ditanu sɛlaa se mmle kuonwii kasɔ. Sɛlaa se mmle lɛsɔnu lawofa ma. Nioso batanu ɔlaa wɔ di Yesu latoobuɛ ni kasɔ. ");
INSERT INTO snw_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Obe wɔ nfɛ di Yesu latɔɔtɛɛtɛɛ ni Yeriko, numbiɛtɛ onwii lasiɛ di osukulɔɔkɔ aatɔɔkaalɛ asaa. ");
INSERT INTO snw_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Obe wɔ aanu batii kpinwu kofe nii, aakaalɛ alɛ, “Ɔmɛnlaa kule?” ");
INSERT INTO snw_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ninfɛ baatɔkɔ nwɔ alɛ, “Yesu Nasaret Otii nikofe.” ");
INSERT INTO snw_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ninfɛ aafaa osie kanya aabuɛ alɛ, “Yesu, Ɔka Dawid Obi ee! Nyɛɛ nyaami!” ");
INSERT INTO snw_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Nioso batii ba niale ni katũ lamuɛ nwɔ alɛ, alo kanana. Kafɔɔ mianfɛ aakple aafaa osie kanya aakyakaa alɛ, “Dawid Obi ee! Nyɛɛ nyaami!” ");
INSERT INTO snw_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Nkpo oso Yesu layila, ni aatɔkɔ ma alɛ, bakpaa numbiɛtɛ nwu nkpo bawako nwɔ nɛ. Obe wɔ di numbiɛtɛ nwu ladu ni Yesu nfũ, ninfɛ aakaalɛ nwɔ alɛ, ");
INSERT INTO snw_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Be foomiɛ falɛ mbla nta fɔ?” Ninfɛ di numbiɛtɛ nwu labuɛ alɛ, “Saatuotɛ, ta anu atikiti mi nintɔɔnya!” ");
INSERT INTO snw_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ninfɛ di Yesu latɔkɔ nwɔ alɛ, “Ni nyaɛ! Ofũonu lɛfɔ ntoodiki fɔ.” ");
INSERT INTO snw_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Nfanwu, osuɔtɔ nwu lakyako ɔnya, ninfɛ aatikanko Yesu sɛɛmaa aatɔɔtansa Yaa nɛ. Obe wɔ baatii dikudi nwu nkpo kafɔɔ lanya ni nle mmle, bamuu lɛma baatansa Yaa. ");
INSERT INTO snw_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu labuo Yeriko okpoo kamɛ ɔɔwaalɛ anfe. ");
INSERT INTO snw_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Akpooto funtɛ ɔnɔɔfo onwii lawɛ ninfa baatɔɔlɛɛ nwɔ ni Sakeo, koto late nwɔ osie kanya. ");
INSERT INTO snw_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Aamiɛ alɛ ɔɔnya otii wɔ di Yesu nle nii, kafɔɔ atafuo nwɔ ɔnya ta batii lɛpɔ oso, diekye otii kunkudu aale. ");
INSERT INTO snw_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Nkpo oso aatoso aale batii nwu katũ, aalaayie kowoso kunwii alɛ, ɔɔnya Yesu. Diekye aatofo alɛ Yesu mafe ninfa. ");
INSERT INTO snw_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Obe wɔ di Yesu labadu ni kowoso nwu kalɔ, aatakatɛsa anu aanyu osi ni aatɔkɔ Sakeo alɛ, “Sakeo, pɛsɛwa fasoo fawa, diekye leyo lɛfɔ masoosa miɛ.” ");
INSERT INTO snw_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Nioso Sakeo lapɛsɛwa aasoo aawa, aabafũ Yesu ku suoto lɛyɔɔ kplɛ. ");
INSERT INTO snw_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Batii nwu nkpo bamuu nianya ni lakye kasɔ baatoonwununuu di Yesu suoto alɛ, “Osuɔtɔ wɔ mmle kofe kpileblatɛ wɔ mmle nfũ osoosa.” ");
INSERT INTO snw_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Sakeo lataka aayila, ni aabuɛ aatɔkɔ Saate alɛ, “Teete! Nyu lo! Mayɔ asaa ya ninkpe mi ni kakyɛ kanwii nta bapiitɛ. Otii lele kafɔɔ ntoyitafaa mata lɛsaa nwu ntɔɔ, nkyakaa nwɔ di akyuu ana kamɛ.” ");
INSERT INTO snw_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ninfɛ di Yesu latɔkɔ nwɔ alɛ, “Miɛ nkpa ɔwɛ ntɔɔwa leyo le mmle kamɛ. Diekye osuɔtɔ wɔ mmle kafɔɔ Abraham ɔnantii ale. ");
INSERT INTO snw_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ami, Otii Obi, ɔwa lɛwa nlɛ, kɔmawolaa ndiki mba nintooyu nii.” ");
INSERT INTO snw_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Obe wɔ batii nwu nkpo konu ni sɛlaa se mmle, Yesu lakple aapɛ ma lɛkpa ninwii. Diekye obe nwu nfɛ ɔɔtɛɛtɛɛ Yerusalem. Baanyu alɛ Yaa sɛka kalekɔ nwu nfɛ makyɔɔ. ");
INSERT INTO snw_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Nioso aatɔkɔ ma alɛ, “Obe onwii, osuɔtɔ finle onwii lawɛ, aatoofe kale kanwii fanfa alɛ bɔɔlaase nwɔ sɛka ankple anwa okpoo nɔɔ. ");
INSERT INTO snw_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Fiɛ abasifi nii, aalɛɛ bakpɛmblatɛ nɔɔ lefosi aasiisa. Ni aata obiala lɛma koto sɛɛle kunwii kunwii nɛ. Ni aatɔkɔ ma alɛ, ‘Biyɔ koto nwu bitɔɔblako ɔkpɛ dilaase di obe wɔ kamawa ni.’ ");
INSERT INTO snw_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Kafɔɔ osuɔtɔ wɔ mmle okpoo nɔɔ batii nimbɔmbɔ nwɔ, nkpo oso baakpee batii sɛɛmaa nɔɔ alɛ, ‘Buloomiɛ osuɔtɔ wɔ mmle bulɛ ale wo ɔka.’ ");
INSERT INTO snw_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Kafɔɔ baase osuɔtɔ nwu sɛka aakple aawa okpoo nɔɔ. Nfanwu ni aakpee baalɛɛ bakpɛmblatɛ nɔɔ baatɔɔ alɛ, babatɔkɔ nwu mmle bɛɛblako ni koto ko aata ma ni ɔkpɛ, ku mmle bɛɛwɛ ni. ");
INSERT INTO snw_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Ninfɛ di kpɛmblatɛ kasale nɔɔ alɛ, ‘Teete, koto nwu, lɛwɛ lefosi lɛkyakaa di nko faatɛɛ ni suoto.’ ");
INSERT INTO snw_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Ninfɛ di Saate nwu latansa nwɔ aatɔkɔ nwɔ alɛ, ‘Lafe! Feelolaa fɛɛbla! Kpɛmblatɛ biene fale! Di obe wɔ feelolaa lɛsaabii le mmle feeklee ni di osuku wɔ mmle suoto oso, mayɔ fɔ nse di eekpoo lefosi kanya.’ ");
INSERT INTO snw_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Kpɛmblatɛ nyɔɔfa kafɔɔ lawa aabatɔkɔ nwɔ alɛ, ‘Teete, di koto ko faatɛɛ nii, lɛwɛ anɔɔ lɛkyakaa di nkunkpo suoto!’ ");
INSERT INTO snw_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Ninfɛ di Saate nwu nkpo latɔkɔ kpɛmblatɛ nwu nyɔɔfa alɛ, ‘Afɔ yi, mayɔ fɔ nse di eekpoo ɛnɔɔ kanya!’ ");
INSERT INTO snw_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Kpɛmblatɛ bamba lawa aabatɔkɔ nwɔ alɛ, ‘Teete, nnya koto sɛɛle lɛfɔ nwu faatɛɛ ni. Layɔ lakookaa di kadukufi kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Latɔɔyɛkɛ fɔ diekye otii siene fale. Fan-yɔ lɛsaa le ninanle fɔ ni lele. Fanfiɛlɛ ninfũ kafɔɔ fanankpɛ nii.’ ");
INSERT INTO snw_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Ninfɛ di Saate nwu latɔkɔ nwɔ alɛ, ‘Afɔ kpɛmblatɛ kpile fale! Afɔ omu kanya kamɛ sɛlaa mayɔ nlo fɔ lɛpɔɔ. Faye falɛ otii siene nle. N-yɔ lɛsaa le ninanle mi ni lele. Nfiɛlɛ kafɔɔ ninfũ ninankpɛ nii. ");
INSERT INTO snw_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ni se faye nkpo mɔ, be oso fanan-yɔ koto nii nwu falaatɛ di koto katɛkɔ? Alɛ nse lɛwa kamawɛ nfasũ nkyakaa.’ ");
INSERT INTO snw_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Ninfɛ aatɔkɔ batii ba niayila ni ninfa alɛ, ‘Bifũ koto sɛɛle nwu di nnɛɛ nɔɔ biɛyɔ bita kpɛmblatɛ wɔ ninkpe ni koto sɛɛlɛ lefosi.’ ");
INSERT INTO snw_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Kafɔɔ batii nwu latɔkɔ nwɔ alɛ, ‘Teete, kpɛmblatɛ nwu nkle koto lefosi kofokofoko!’ ");
INSERT INTO snw_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Ninfɛ di saate nwu ladiki kanya alɛ, ‘Kɔtɔkɔ ye nlɛ otii wɔ lɛɛsaa nkpe nii, nnwɔɔ babakple mankyakaa nɛ. Kafɔɔ otii wɔ lɛsalɛsaa nnaa nii, kɛɛkɛɛ wɔ ninkpe nwɔ nii, babaklee manfũ nwɔ ninnɛɛ. ");
INSERT INTO snw_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Nunua yi, balo nii ba ninoomiɛ alɛ nle ma ni ɔka, bikpaa ma biwako nfũ biɛbalo ma di anu nii.’ ” ");
INSERT INTO snw_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Obe wɔ di Yesu latɔkɔ ma ɔlaa wɔ mmle aaloo nii, aalekatũ aasifi Yerusalem. ");
INSERT INTO snw_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Di obe wɔ nfɛ ɔɔtɛɛtɛɛ ni Betfage ku Betania di nnɔnyi kobokote ɔlɔɔkɔ, aakpee basaateketetɛ nɔɔ banyɔ alɛ bale katũ. ");
INSERT INTO snw_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ni aatɔkɔ ma alɛ, “Bitɔɔkyɛ okpoo wɔ ninte ye ni siitũ ninfa. Nse biebuo nwu kaamɛ, bibanya lɛpɔnkɔbi ninwii nsi di okũ, di otii kuonwii diisiɛ ni ni diidii. Bidiki ni di okũ, biɛkpaa ni biwakoe. ");
INSERT INTO snw_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Nse otii owo lɛkaalɛ ye alɛ be lɛsaa oso biodiki ni, biɛtɔkɔ nwɔ bilɛ, ‘Saate komiɛ ni.’ ” ");
INSERT INTO snw_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Batɔkyɛntɛ nwu lakyɛ baalaanya fɛ mmle okle di Yesu latɔkɔ ma nii. ");
INSERT INTO snw_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Obe wɔ baatoodiki ni lɛpɔnkɔbi nwu, saate ni ni lakaalɛ ma alɛ, “Be lɛsaa oso biodiki ni?” ");
INSERT INTO snw_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ninfɛ di basaateketetɛ nwu nkpo ladiki kanya alɛ, “Saate nwu komiɛ alɛ ablako ni ɔpkɛ.” ");
INSERT INTO snw_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ninfɛ baakpaa lɛpɔnkɔbi nwu baawako Yesu nɛ. Ninfɛ baayɔ abula lɛma baatika di lɛpɔnkɔbi nwu kamaa, ni baakyakaako Yesu aayie aasiɛ ni kaamaa nɛ. ");
INSERT INTO snw_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Obe wɔ nfɛ asi ni, ninni suoto bɔɔkyɛ nii, batii layɔ abula lɛma baatɛ di osuku suoto. ");
INSERT INTO snw_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Obe wɔ di Yesu nfɛ kɔtɛɛtɛɛ ni Yerusalem, di lɛba le di osuku lesoo kuosifi ni Nnɔnyi Awoso Kobokote, basaateketetɛ nɔɔ dikudi nwu lakyako Yaa sɛfa ɔpɛ baatɔɔtansa nwɔ kafɔɔ ku sɛlɔ siene di asaa kplɛ ya bɛɛnya ni oso. ");
INSERT INTO snw_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Baatoobuɛ alɛ, “Yaa akusɛkusɛsa ɔka wɔ nikɔwa ni di Saate leyooto kamɛ! Atoko ɔkyɛ ole diwɛ di Yaa kafa, Yaa lele ninle leklekle!” ");
INSERT INTO snw_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ni di Farisi batii ba bawo niawɛ ni baatii dikudi nwu kamɛ latɔkɔ Yesu alɛ, “Saatuotɛ, sĩ ɔlaa fata basaateketetɛ lɛfɔ, baadiɛ kudu oyiisa!” ");
INSERT INTO snw_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ninfɛ di Yesu ladiki kanya alɛ, “Kɔtɔkɔ ye nlɛ, nse batii ba mmle lɛmaasa kanya, afuɔ amu makye kasɔ ankyako kudu oyiisa.” ");
INSERT INTO snw_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Di Yesu nfɛ kɔtɛɛtɛɛ ni Yerusalem okpoo aanya nwu nii, aawi kaku diisi ninwu. ");
INSERT INTO snw_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ni aabuɛ alɛ, “Nse fɛ oye faye lɛsaa le niefĩ diɛta ni atoko ɔkyɛ ole miɛ! Kafɔɔ nunua, flɔbafuo ɔnya! ");
INSERT INTO snw_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Obe onwii kɔwa di balo lee mamana ye mankyi nii kaakɔ biala. Babatĩi ye di aba amuu alɛ kuonwii dilɔbawɛ osuku adie ee abuo. ");
INSERT INTO snw_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Babawɔɔsa okpoo wɔ mmle ku batii ba bamuu ninsi ni kaamɛ. Blɔbadiɛ bia difuɔ kuninwii ditika leewo suoto. Diekye bitatofo obe wɔ di Yaa lawa ye ni odiki!” ");
INSERT INTO snw_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesu lakyɛ Yaa Olekatakɔ, ni aakyako basaasunsutɛ otososa odiki nɛ. ");
INSERT INTO snw_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ni aatɔkɔ ma alɛ, “Bɛɛkpana di Kɔkpana Klekle Kukũ kamɛ alɛ, ‘Baalɛɛ mi leyo alɛ ɔlaa ɔpɛ katakɔ.’ Kafɔɔ aye, bitɔɔyɔ biɛbla bayu kawofakɔ!” ");
INSERT INTO snw_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Dii biala Yesu latuo asaa di Yaa Olekatakɔ nwu ninfa. Yaa ɔlaa babuɛtɛtɛ ku kufiofa batuotɛ ku okpoo banɔɔfo lamiɛ alɛ boolo nwɔ. ");
INSERT INTO snw_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Kafɔɔ batawɛ osuku wɔ suoto baafe manlo nwɔ nii. Diekye batii bamuu latɔɔkyɔɔ nwɔ ɔlaa atoko osie kanya. ");
INSERT INTO snw_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Dii ninwii obe wɔ di Yesu lawɛ ni di Yaa Olekatakɔ aatootuo ni batii asaa, aatɔɔtɔkɔ ma ni kafɔɔ ɔlaa biene nwu, Yaa olebatatɛ banɔɔfo ku kufiofa batuotɛ ku okpoo banɔɔfo lakyɛ ɔkyɛ nɔɔ. ");
INSERT INTO snw_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ninfɛ baabakaalɛ nwɔ alɛ, “Tɔkɔ wo, ɔmɛnsuku fakpe fɔɔbla asaa ya mmle? Owe kafɔɔ niɛta fɔ osuku nwu nkpo?” ");
INSERT INTO snw_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ninfɛ di Yesu ladiki kanya alɛ, “Amii bitɛɛ nkaalɛ ye ɔlaa onwii biɛtɔkɔ mi. ");
INSERT INTO snw_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ɔfɛ di Yohane lawɛ osuku fiɛ aatookpeesa batii Yaa ntu? Yaa nfũ kuakye ɛɛ, sɛɛ batii nfũ kuakye?” ");
INSERT INTO snw_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ninfɛ baamumufũ ɔlaa nwu nimanima baanyu alɛ, “Be nfɛ buabuɛ? Nse buobuɛ bulɛ Yaa nfũ kuakye yi, abakaalɛ wo alɛ, ‘Ni be oso bitafũ Yohane bianu mɔ?’ ");
INSERT INTO snw_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Kafɔɔ nse buobuɛ bulɛ otii nfũ kuakye yi, batii ba mmle niesi ni ninfũ masafɔ wo afuɔ, diekye bamuu lɛma beefũ beenu alɛ Yohane yi, Yaa ɔlaa buɛtɛtɛ aale.” ");
INSERT INTO snw_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Nioso baatɔkɔ Yesu alɛ, “Buoye nfũ kuakye nii.” ");
INSERT INTO snw_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ninfɛ di Yesu latɔkɔ ma alɛ, “Nkpo okle kafɔɔ di amii, namatɔkɔ ye otii wɔ niɛtɛɛ ni osuku fiɛ kɔbla ni asaa ya mmle nɛ.” ");
INSERT INTO snw_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ninfɛ di Yesu lapɛ lɛkpa le mmle aata batii nwu alɛ, “Obe onwii, osuɔtɔ onwii lakpɛ awosobi ya man-yɔ mambla ni nta kofe. Ni aayɔ kofe nwu nkpo aakpee di bakpɛntɛ banwii nnɛɛ kamɛ alɛ, batoonyu batɔɔtɔɔ nɛ. Ni aadie aasifi osuku, aalaasiɛ ninfa aaklɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Di obe lawo alɛ baatɛsɛ ni awosobi nwu, aakpee kpɛmblatɛ nɔɔ onwii alɛ, akyɛ aalaafũ kalekɔ nɔɔ di kofe banyuntɛ nwu nfũ awako nwɔ. Kafɔɔ kofe banyuntɛ nwu nkpo lapɛ kpɛmblatɛ nwu baatososɔɔ aasifi nnɛɛ fukuti. ");
INSERT INTO snw_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Nioso, aakple aakpee kpɛmblatɛ bamba. Kafɔɔ kofe banyuntɛ nwu nkpo lakple baapɛ nwɔ baakpee nwɔ sinunsɔ baatososɔɔ aasifi nnɛɛ fukuti. ");
INSERT INTO snw_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ni, aakple aakpee kpɛmblatɛ tiɛfa nɛ. Kafɔɔ kofe banyuntɛ nwu lapɛ nwɔ baatika nwɔ nkɔ baatososɔɔ baadiki koofe nwu kamɛ ninfa. ");
INSERT INTO snw_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Ni koofe nwu saate lakaalɛ alɛ, ‘Be nfɛ kakple mbla? Ninfɛ aatɔkɔ suoto alɛ, kamakyesee obi nii bɔmbɔtɛ. Loobia babata obi nii nwu dibu.’ ");
INSERT INTO snw_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Kafɔɔ obe wɔ di kofe nwu nkpo banyuntɛ lanya ni obi nɔɔ nwu nkpo, ni baatɔkɔ bawo alɛ, ‘Nnya kofe saate obi wɔ nimale ni atesaa ninle nwɔ mmle nɛ. Bita bulo nwɔ di atesaa nɔɔ nwu nkpo akple wo ale!’ ");
INSERT INTO snw_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Nioso baananfi obi nwu nkpo baadiki di kofe nwu kamɛ, ni baalo nwɔ nɛ.” Ninfɛ di Yesu lakaalɛ ma alɛ, “Be bienyu bilɛ kofe saate nwu mabla kofe banyuntɛ nwu? ");
INSERT INTO snw_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Kɔtɔkɔ ye nlɛ abawa amalo kofe banyuntɛ nwu nkpo, an-yɔ kofe nwu ankpee koofe banyuntɛ bamba nnɛɛ kamɛ.” Obe wɔ baatii nwu nkpo lanu ni ɔlaa wɔ mmle baabuɛ alɛ, “Oowo! Dilɔbawa nkpo!” ");
INSERT INTO snw_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesu lanyu ma tuwĩi ni aakaalɛ ma alɛ, “Ni be di Kɔkpana Klekle ko mmle kotuo? Nko niebuɛ alɛ, ‘Difuɔ le baayotofotɛ lesĩ alɛ diɛlɛ nii, nni bia nintoobakple difuɔ le nintoofũ kɔya dilenke ni di afuɔ amuu kamɛ nɛ.’ ");
INSERT INTO snw_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Otii lele niɛnɔɔ ɛɛpɛ diifuɔ le mmle, suoto nɔɔ mabibiɛ wɔkyɔwɔkyɔ. Otii lele kafɔɔ diifuɔ le mmle lɛkpa diɛpɛ, suoto nɔɔ makuɔ muɛmuɛ.” ");
INSERT INTO snw_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Kufiofa batuotɛ ku ole batatɛ banɔɔfo lamiɛ alɛ boomufũ Yesu ninfa, diekye baatofo alɛ lɛkpa le di Yesu lapɛ nii mma aalaka. Kafɔɔ baayɛkɛ batii nwu nkpo. ");
INSERT INTO snw_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ta nkpo oso, baamiɛ osuku bamba wɔ suoto baafe mammufũ nwɔ nii. Nioso baata batii bawo asaa di lewofa kamɛ. Ni baabla onwii baakyɛ Yesu ɔkyɛ fɛ batii biene bale. Baakyɛ alɛ bɔɔlaawolaa nwɔ kaanya ku sɛlaa kaalɛle sewo. Mmle okle baawɛ osuku man-yɔ nwɔ mankpee ni di Roma abaa ɔnɔɔfo nnɛɛ kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Nioso banyawolaatɛ ba mmle lakyɛ Yesu nfũ. Ni baatɔkɔ nwɔ alɛ, “Saatuotɛ, buye bulɛ lɛsaa lele feebuɛ, ee feetuo kute nkpo. Buye kafɔɔ bulɛ fánnyu otii di anu faabla lɛsaa. Kafɔɔ fantuo nwaako ɔlaa wɔ di Yaa komiɛ ni fanta batii. ");
INSERT INTO snw_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Nioso buomiɛ bulɛ butofo, dilɛ alɛ buata akpooto munta Roma Batii Ɔka Kplɛ ɛɛ, sɛɛ diɛlɛ?” ");
INSERT INTO snw_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Kafɔɔ Yesu latofo kakyɔnkyɔ osuku wɔ suoto bakyɛ nii, nioso aatɔkɔ ma alɛ, ");
INSERT INTO snw_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Biyɔ koto fututu nwu biwakoe nnyu. Obe wɔ baayɔ baakyɛnko nwɔ nii, aakaalɛ ma alɛ owɛ kunyii ku leyooto nintika?” ");
INSERT INTO snw_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ninfɛ baadiki kanya alɛ, “Ɔka Kplɛ Kaesare lele dile.” Ninfɛ di Yesu latɔkɔ ma alɛ, “Ni biyɔ lɛsaa le ninle ni Ɔka Kplɛ lele, bita Ɔka Kplɛ. Biɛyɔ lɛsaa lele ninle Yaa lele bita Yaa.” ");
INSERT INTO snw_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Batafuo ɔlaa kuonwii ɔwɛ, ɔyɔ omufũ nwɔ di batii nwu anu. Nioso batasinfuo ɔlaa kuonwii obuɛ. Diabla ma ɔkpɛ di ɔlaa wɔ di Yesu ladiki ni kanya oso. ");
INSERT INTO snw_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ninfɛ di Saduki batii ba nimbuɛ alɛ bakpi dilɔbasintaka ni bawo lawa Yesu nfu babatɔkɔ nwɔ alɛ. ");
INSERT INTO snw_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Saatuotɛ, Mose lakpana kufiofa ko mmle ɛɛtɛ wo alɛ, ‘Nse osuɔtɔ owo lekpi eediɛ ɔsɔfɔ, manko nwɔ banaa obi, osuɔtɔ nwu nkpo obilɛma osuɔtɔbi kayɔ kpisɔfɔ nwu nkpo manlofo babi. Ni babi nwu nkpo, batii manya ma fɛ osuɔtɔ wɔ ninnaa ni babi.’ ");
INSERT INTO snw_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Obe onwii babilɛma suɔtɔbi bakuɛnsĩ banwii lawɛ. Osuɔtɔbi nɔɔfole labayɔ ɔsanko, batalofo obi, aabafe aakpi. ");
INSERT INTO snw_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ni di obilɛma suɔtɔbi nyɔɔfa kafɔɔ labayɔ kpisɔfɔ nwu nɛ. ");
INSERT INTO snw_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Otiɛfa kafɔɔ laakpanwu. Lɛsaa le mmle lawa babilɛma suɔtɔbi nwu bakuɛnsĩ suoto. Bamuu lɛma baakpi batalofo obi. ");
INSERT INTO snw_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Yɛntɛyɛntɛ, ɔsanko nwu omu labakpi. ");
INSERT INTO snw_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Nimɔ, di dii le baakpi makple mantaka nii, owe lɛma ɔsɔfɔ di ɔsanko nwu nkpo male di obe wɔ baakuɛnsĩ lɛma nwu layɔ nwɔ ni?” ");
INSERT INTO snw_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu ladiki kanya alɛ, “Nkpa be mmle kamɛ lete di basuɔtɔ ku basanko kɔyɔ bawo. ");
INSERT INTO snw_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Kafɔɔ basuɔtɔ ku basanko ba niesiɛko alɛ baataka mankye ni bakpi kamɛ mansiɛ ni nkpa be mmle yi, blosinwa sɛsa ku sɛsɔfɔ ɔbatoole. ");
INSERT INTO snw_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Babate fɛ Yaa batɔkyɛntɛ, blosinwa ɔbakpi kafɔɔ. Yaa babi nfɛ bale diekye batɔɔtaka beekye bakpi kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mose lɛkpasa kamɛ klekle di Kɔkpana Klekle Kukũ kamɛ alɛ bakpi makple mantaka mansiɛ nkpa. Diekye obe wɔ aayila ni di owuu dibuu le niatoofiɛ ni ɔlɔɔkɔ aabuɛ di Saate suoto alɛ, ‘Abraham Yaa, Isak Yaa ku Yakob Yaa.’ ");
INSERT INTO snw_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Nle mmle kotuo alɛ, nnwɔɔ ninle batii ba ninkpe ni nkpa Yaa, diele bakpi Yaa ale. Diekye di anu nɔɔ bamuu lɛma bakpe nkpa.” ");
INSERT INTO snw_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Kufiofa batuotɛ bawo ladiki kanya alɛ, “Nwaako, Saatuotɛ, feelolaa kanya feediki!” ");
INSERT INTO snw_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Di nni nkpo kamaa, kuonwii ditasinkpee otu aakaalɛ Yesu ɔlaa kuonwii. ");
INSERT INTO snw_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesu lakaalɛ ma alɛ, “Lɛ diɛbla fiɛ baatii kobuɛ alɛ, Otii wɔ bɛɛpɛ ni ɔfɔɔ Dawid ɔnantii ale? ");
INSERT INTO snw_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Diekye Dawid omu labuɛ di sinu kukũ kamɛ alɛ, ‘Saate nwu latɔkɔ Saate nii alɛ, “Siɛ kaasɔ di oletanɛɛkyɛ nii ");
INSERT INTO snw_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","diɛlase di obe wɔ mayɔ balo lɛfɔ nkpee ni di nkpaasɔ lɛfɔ kalɔ.” ’ ");
INSERT INTO snw_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ni nse Dawid lalɛɛ nwɔ alɛ Saate, lɛ dibawa fiɛ di otii wɔ bɛɛpɛ ni ɔfɔɔ male Dawid ɔnantii?” ");
INSERT INTO snw_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Obe wɔ baatii bamuu n-yɛ bɔɔkyɔɔ ni ɔlaa wɔ di Yesu latoobuɛ ni atoko, aatɔkɔ basaateketetɛ nɔɔ alɛ, ");
INSERT INTO snw_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Bilolaa suoto binyu di kufiofa batuotɛ suoto. Batii ba mmle mbɔmbɔ awu kplɛ okpee, mankyɛ mantookyi lɛkpaka alɛ batii katɔɔsɛɛsa ma ku suoto kasɔ ɔwakosa. Mambɔmbɔ nisiɛkɔ kplɛ di Yuda batii nsiisakɔ ku dii nlekɔ. ");
INSERT INTO snw_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Mankyɛ bakpisɔfɔ nfũ manatafaa ma manfũ ma asaa ninnɛɛ. Mantakatɛsa suoto katoo baatii anu manklɛsa ɔlaa ɔpɛ ɔta Yaa. Letoko nanfi lɛma mapɔ ninlenkee batii bamuu lele!” ");
INSERT INTO snw_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Di Olekatakɔ ninfa, Yesu latakatɛsa anu ni aanya mmle di basaawɛntɛ layɔ asaa ɔta lɛma baatookpee ni di asaa ɔta lekpeesa kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ni aanya mmle kafɔɔ di kpisɔfɔ piitɛ onwii labafe aalaakpee ni mplɛ nnyɔ di asaa ɔta lekpeesaa nwu kamɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ni aatɔkɔ ma alɛ, “Nwaako kɔtɔkɔ ye nlɛ, kpisɔfɔ piitɛ wɔ mmle niɛta koto alenke batii bule. ");
INSERT INTO snw_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Diekye batii bule yi, di lɛsaawɛ lɛma kamɛ nle ninlɛ ma ni bɛɛyɔ bɛɛbata. Kafɔɔ ɔsanko wɔ mmle di dipii nɔɔ kamɛ, lɛsaa le ninkpe nwɔ aale ansiɛ ni nkpa nimuu ɛɛyɔ ɛbata nɛ.” ");
INSERT INTO snw_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Di obe nwu nkpo kamɛ, basaateketetɛ bawo latɔɔkakatɛ di Yaa Olekatakɔ nwu nkpo suoto. Di mmle okle diɔlɛ ni onyu ku afuɔ ya bɛɛyɔ beetofo ni nii, ku asaa ɔta ya baayɔ baata ni Yaa. Ninfɛ di Yesu latɔkɔ ma alɛ, ");
INSERT INTO snw_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Asaa ya amuu biɔnya ni ninfũ, obe owo kɔwa di difuɔ kuninwii dilababu ditika ni leewo suoto. Bababiɛ amuu mantɛ kaasɔ.” ");
INSERT INTO snw_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ninfɛ baakaalɛ nwɔ alɛ, “Saatuotɛ, ɔmɛmbe di nle mmle mawa? Be nimale dituosaa le bubayɔ muntofo bulɛ, obe nwu ntoowo ni?” ");
INSERT INTO snw_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesu latɔkɔ ma alɛ, “Bilolaa binyu nwaa alɛ otii kuonwii diɛkyɔnkyɔ ye. Batii kpinwu mayɔ leyooto nii manwa ɔkyɛ lee, mamatɔkɔ ye alɛ, ‘Ami dile,’ ni kafɔɔ, ‘Obe nwu ntoowo.’ Kafɔɔ bitantikanko ma di nkpaamaa. ");
INSERT INTO snw_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Bitanyɛkɛ nse bienu kakpɛ kudu ku batii ɔtaka oyila baawo suoto. Dikpe nii asaa ya mmle lɛkasa ɔwa, kafɔɔ dilootuo alɛ kayi kalookɔ ntɔɔtɛɛtɛɛ.” ");
INSERT INTO snw_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yesu lakple aabuɛ aakyakaa alɛ, “Nnle mataka baawo suoto, sɛka nlekɔ kafɔɔ mataka baawo suoto. ");
INSERT INTO snw_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Nsɔ matũkũ osie kanya. Aka siene kafɔɔ makpɛ di aba aba. Sifiɛ ate ate kafɔɔ mawa di aba aba kpi. Ayɛkɛsaa ku atuosaa kafɔɔ matɔkyɔɔ di osi. ");
INSERT INTO snw_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Fiɛ di asaa ya mmle mawa nii, batii matikanko ye, mamufũ ye. Batii mayɔ ye mankpee di bakantɛ nnɛɛ kamɛ, mankanko ye di Yuda batii nsiisakɔ mantɛ ye laayo. Babakpaa ye manwako baka anu ku batunletɛ anu, ta ami oso. ");
INSERT INTO snw_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Di obe nwu nkpo kamɛ, osuku kule kuɔsɛkɛtɛ kuɔta ye alɛ, biabuɛ Yaa ɔlaa biene nwu nkpo. ");
INSERT INTO snw_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Bita disiɛ ye diisi alɛ, bilaabu ɔlaa wɔ bibabuɛ mindiki ni suoto kanya diisi bialesakatũ. ");
INSERT INTO snw_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Diekye ami omu nimata ye lɛsaatofo ku ɔlaa wɔ bibabuɛ nii, alɛ balo lee dilabafuo oyila di ɔlaa lee nwu suoto, ee bayɔ nwu babudi ye kanya. ");
INSERT INTO snw_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Balofotɛ ku babilee suɔtɔbi ku banantii lee ku basiɛwo lee madiki ye manta, manlo bawo kaamɛ lee. ");
INSERT INTO snw_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Batii bamuu makyidi ye ta ami oso. ");
INSERT INTO snw_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Kafɔɔ bia asi lee onwini onwii dilabayu. ");
INSERT INTO snw_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Nse biekpee situ osie kanya, bibawɛ nkpa be ninnaa ni kaloo. ");
INSERT INTO snw_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Nse obe lele biɛnya bakpɛtɛ lɛmana Yerusalem okpoo beekyi, ni bietofo bilɛ okpoo nwu obiɛ bee ntoowo. ");
INSERT INTO snw_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Di obe nwu kamɛ, biɛta batii ba ninkpe ni di Yudia batoso basifi abokote osi balaawofa. Mba kafɔɔ ninkpe ni di okpoo kamɛ, baadie. Mba kafɔɔ ninkpe ni di nkpaayotũ ku afe, batasinkple baawa okpoo kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Diekye obe nwu kamɛ ninle letokonanfi ayi ya bɛɛtɛ nii, alɛ sɛlaa se di Kɔkpana Klekle lebuɛ ni kawa kaanya. ");
INSERT INTO snw_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Di obe nwu nkpo kamɛ, dibatɛ ninwɛ osie ninta basanko ba ninlaka ni amɛ ku mba nikɔta babi nyɛɛfu nii. Dibuo dibinte mawa di kasɔ nwu suoto. Diekye Yaa ɔblɔ mawa di batii ba mmle suoto. ");
INSERT INTO snw_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Babalo bawo ku mpamii. Babamufũ bawo kafɔɔ mansifiko nsɔ bamba suoto. Batii ba ninanle ni Yuda batii male sɛka di Yerusalem suoto ninaase di obe wɔ di Yaa lɛtɛ ma nii.” ");
INSERT INTO snw_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Atuosaa madiki suoto kayi di kufĩ ku kɔwɛntɛ ku awɛntrɛbi suoto. Di kasɔ ka mmle suoto, lɛyɛkɛ mapɛ batii di nnle mmuu kamɛ mankpɔkpɔtɔ mambla biɔɔ ta lekpo sɛlɔ ku mmle diɔkpɛ ni oso. ");
INSERT INTO snw_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Batii matoloo ɔnyɛɛ ta lɛyɛkɛ, di obe wɔ basoko ni lɛsaa le nikɔwa ni kaayi kamuu suoto oso. Diekye osi asaa kafɔɔ matididi di aba ya atika nii. ");
INSERT INTO snw_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Di nni nkpo sɛmaa, batii manya Otii Obi nwu makyɔɔ di alokonkyɛ kamɛ ɔɔwa ku osie kplɛ di leklekle kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nse asaa ya mmle lɛkyako ɔwa bielolaa suoto bisiɛ ta bitoonyu osuku, diekye didiki lee obe ntɔɔtɛɛtɛɛ.” ");
INSERT INTO snw_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ninfɛ di Yesu lapɛ ma lɛkpa ninwii alɛ, “Bibu disi di kolewoso ku awoso bamba suoto. ");
INSERT INTO snw_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Nse biɛnya afata lɛnya koyie afɔle, mintofo bilɛ kanto ɔnɔɔbee nfɛ kɔtɛɛtɛɛ. ");
INSERT INTO snw_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Nkpo okle kafɔɔ nse biɛnya asaa ya mmle kɔwa, bietofo bilɛ Yaa sɛka kalekɔ nfɛ mawa. ");
INSERT INTO snw_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Nwaako kɔtɔkɔ ye nlɛ, asaa ya mmle amuu mawa fiɛ baatii ba ninkpe ni nkpa nunua bamuu makpi. ");
INSERT INTO snw_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Osi ku kasɔ mafe, kafɔɔ ɔlaa nii nwu kulabafe diidii. ");
INSERT INTO snw_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Bilolaa binyu nwaa bilɛ biɛyɔ obe lee bita alesaa ole ku nta onyi osiɛ bilenkeesa. Ku kayi ka mmle asaa omiɛ kpinwu suoto. Se diele nkpo, dii nwu nkpo mawa ninmafua ye. ");
INSERT INTO snw_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Fɛ mmle di okũ ndiki ni bɔkɛɛ. Diekye dibawa di batii bamuu suoto kaayi ka mmle kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Nkpo oso bilolaa binyu, biɛtɔɔpɛ ɔlaa bitɔɔta Yaa alɛ biawɛ osie minfe di asaa ya mmle nimawa ni amuu kamɛ, alɛ biakyɔɔ di ami Otii Obi nwu anu di leklekle kamɛ di lɛkankoyi nwu suoto.” ");
INSERT INTO snw_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Di ayi nwu nkpo kamɛ, Yesu latuo batii asaa di Yaa Olekatakɔ nwu kamɛ, kafɔɔ nse kɔtɔɔfɔ lewo, andie ansifi Nnɔnyi Awoso Kobokote suoto anaasiɛ kakyɛ. ");
INSERT INTO snw_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Di kolesɛtũ biala batii nwu nkpo bamuu ntaka mankyɛ Yaa Olekatakɔ mananu nwɔ asaa otuo. ");
INSERT INTO snw_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Bloblo wɔ ninantaka ni, manlɛɛ ni Okpi Diisi Ofe Dii ole bee latɛɛtɛɛ. ");
INSERT INTO snw_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Olebatatɛ banɔɔfo ku kufiofa batuotɛ latɔyɛkɛ ni batii nwu nkpo oso, baatoomiɛ osuku wɔ suoto baafe manlo ni Yesu di lewofa kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ninfɛ di Abonsam labuo di Yuda wɔ baatɔɔlɛɛ ni Iskariot kamɛ nɛ. Yesu basaateketetɛ lefosi batii banyɔ onwii lɛma aale. ");
INSERT INTO snw_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Nkpo oso Yuda lasifi olebatatɛ banɔɔfo ku Yaa Olekatakɔ banyuntɛ banɔɔfo nfũ. Ni aalaakakatɛko ma di osuku wɔ suoto abafe andiki Yesu anta ma ni nɛ. ");
INSERT INTO snw_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Suoto layɔɔ ma nwaa, ni baatɔkɔ nwɔ alɛ babatɔɔ koto nɛ. ");
INSERT INTO snw_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ni di Yuda latuna nɛ. Nkpo oso aakye kasɔ aatoomiɛ osuku wɔ suoto abafe andiki Yesu anta ni baatii dilabatofo nii. ");
INSERT INTO snw_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Nni kama, dii le manlo ni lefosobi di Okpi Diisi Ofe Dii labawo di bloblo wɔ ninantaka ni ayi ole kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ni di Yesu lakpee Petro ku Yohane aatɔkɔ ma alɛ, “Bitɔɔkyɛ biɛlaawa Okpi Diisi Ofe alesaa bitawo buɔbale.” ");
INSERT INTO snw_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ninfɛ baakaalɛ nwɔ alɛ, “Ɔfɛ foomiɛ falɛ bulaawa alesaa nwu buse?” ");
INSERT INTO snw_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ninfɛ aadiki kanya alɛ, “Nse biebuo Yerusalem okpoo kamɛ, osuɔtɔ onwii mawa amakyakako ye atuka ntu dibukii. Bitikanko nwɔ biɛlaabuo leyo le kamɛ ababuo ni. ");
INSERT INTO snw_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Biɛkaalɛ leyo nwu saate bilɛ, ‘Saatuotɛ alɛ bukaalɛ fɔ nii, “Lɛmɛnyo kamɛ di ami ku basaateketetɛ nii, bubasiɛ munle Okpi Diisi Ofe alesaa?” ’ ");
INSERT INTO snw_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Abatuo ye leyo dibinte ninwii beetofo beetika ni di osi, nfũ beelolaa, beese ni asiɛsaa. Biwa miɛ dii nwu alesaa ninfa bita wo.” ");
INSERT INTO snw_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Baakyɛ baalaanya fɛ mmle di Yesu latɔkɔ ma nii. Ni baawa Okpi Diisi Ofe alesaa nwu ninfa baase nɛ. ");
INSERT INTO snw_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Di obe nwu lawo nii, Yesu ku batɔkyɛntɛ nɔɔ lasiɛ kaasɔ di opunu katũ babale ni alesaa. ");
INSERT INTO snw_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ni aatɔkɔ ma alɛ, “Dile mi dibiesaa alɛ kaleko ye Okpi Diisi Ofe alesaa ya mmle fiɛ kafe diibuo kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Diekye kɔtɔkɔ ye ntikiti nlɛ, noosinwa nya ɔbale diɛlaase di obe wɔ di Yaa sɛka kalekɔ nwu lɛwa nii.” ");
INSERT INTO snw_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Nni kamaa, ni di Yesu layɔ opũ ni aapɛ Yaa sɛfa aabuɛ alɛ, “Bifũ nle mmle bienyi bita baawo. ");
INSERT INTO snw_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Diekye kɔtɔkɔ ye nlɛ diɛyɔ ni nunua diesifi nii, noosinwa nta be mmle okle onyi diediki Yaa sɛka kalekɔ nwu lɛwa.” ");
INSERT INTO snw_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ninfɛ aayɔ bloblo ni aapɛ Yaa sɛfa nɛ. Ni aafee, aayɔ aata ma, aabuɛ alɛ, “Nle mmle ninle suoto nii sina se bɛɛyɔ bɛɛta ni diisi lee nɛ. Bibla nle mmle, biɛyɔ bitoonyuma mi.” ");
INSERT INTO snw_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Nkpo okle kafɔɔ, di alesaa nwu nkpo kamaa, aayɔ opũ nwu, ni aabuɛ alɛ, “Opũ wɔ mmle ninle kanya ninii fɔle le di Yaa lɛyɔ ntɔ nii eese ni kaanya, beewii ni kaasɔ di disi lee nɛ. ");
INSERT INTO snw_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Kafɔɔ binyu lo, otii wɔ nimadiki mi anta ni lekpee kɔnɛɛ kaasɛfɛ ninfũ oolekoe alesaa. ");
INSERT INTO snw_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ami, Otii Obi nwu nkpo, makpi fɛ mmle di Yaa lɛtɛ nii. Kafɔɔ otii wɔ nimadiki mi anta nii, ayɔɔsa!” ");
INSERT INTO snw_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ninfɛ di basaateketetɛ nɔɔ nwu lakyako bawo ɔkaalɛ alɛ, owe mɔ kaamɛ lɛma nimabla lɛsaa le mmle okle. ");
INSERT INTO snw_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Kananfi kanwii lababuo di basaateketetɛ nwu kamɛ alɛ, owe lɛma boonyu alɛ alenke baamuu lɛma kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ninfɛ di Yesu latɔkɔ ma alɛ, “Batii ba ninanle ni Yuda batii, baka lɛma kole sɛsaate di batii lɛma suoto. Batunletɛ ba mmle nkpe lɛyooto mammiɛ alɛ batii ba mmle katɔɔlɛɛ ma ni dile ni basiɛwo. ");
INSERT INTO snw_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Kafɔɔ diele nkpo dikpe ni ninte kaamɛ lee. Kafɔɔ nwɔ ninle ni ɔnɔɔfo kaamɛ lee dikpe nii ambla suoto fɛle obisɔ. Nwɔ kafɔɔ ninle ni tunletɛ kabla suoto fɛle kpɛmblatɛ. ");
INSERT INTO snw_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Owe ninle ɔnɔɔfo, nwɔ ninsiɛ ni kaasɔ anle ni alesaa ɛɛ, sɛɛ nwɔ ninse ni opunu? Kamɛ lɛkpa klekle alɛ nwɔ ninsi oole ni alesaa ninle ɔnɔɔfo. Kafɔɔ nsi ye kaamɛ fɛle kpɛmblatɛ. ");
INSERT INTO snw_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Biakpee situ biatikankoe di abuo nii amuu kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Nioso fɛ mmle di Teemi lɛtɛɛ otumi alɛ kale ni sɛka, nkpo okle kafɔɔ mata ye otumi nwu nɛ. ");
INSERT INTO snw_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Bibale alesaa minnyi di alesaa nii kalekɔ di sɛka nii kalekɔ. Bibasiɛ di akakpomii suoto minnle sɛka di Israel nfaabi lefosi nnyɔ nwu suoto.” ");
INSERT INTO snw_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yesu latɔkɔ Simon Petro alɛ, “Simon, Simon, Satana lɛkaalɛ osuku alɛ ɔɔsɔ ye annyu, ansɛ abiene andiki di alalaale kamɛ fɛ mmle di fekpɛntɛ nfɛɛlɛ kufuo andiki ni kaamɔɔ kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Kafɔɔ ntɔɔpɛ ɔlaa lɛta Yaa diisi lɛfɔ Simon, alɛ ofũ onu lɛfɔ dilaayu. Alɛ nse fɛɛpɛ feekple fɛɛwa ɔkyɛ nii, faakpee babilee suɔtɔbi osie.” ");
INSERT INTO snw_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ninfɛ di Petro latɔkɔ nwɔ alɛ, “Saate, lelolaa suoto nlɛ munko fɔ buate leeyo, nkpi ku afɔ!” ");
INSERT INTO snw_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ninfɛ di Yesu latɔkɔ nwɔ alɛ, “Petro, kɔtɔkɔ fɔ nlɛ, kakyɛ ka mmle fiɛ di kɔɔkɔ mabo nii, fababuɛ sitiɛ simu falɛ faaye mi.” ");
INSERT INTO snw_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ninfɛ di Yesu lakaalɛ basaateketetɛ nɔɔ alɛ, “Obe onwii kamɛ lakpee ye ni kɔtɔ, bitaklee ni koto katofoe ku kokpetetofo ku ntokota, lɛsaa lewo lafĩ ye?” Ninfɛ baadiki kanya alɛ, “Lɛsalɛsaa ditafĩ wo.” ");
INSERT INTO snw_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ninfɛ di Yesu latɔkɔ ma alɛ, “Kafɔɔ nunua otii lele ninkpe koto katofoe kawo ee kokpetetofo kowo, aayɔ aklee. Otii wɔ kafɔɔ ninnaa ni kapamii, ayɔ awu nɔɔ asunsũ alaaya kapami kawo. ");
INSERT INTO snw_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Diekye kɔtɔkɔ ye nlɛ, Kɔkpana Klekle ɔlaa wɔ kuobuɛ nii alɛ, ‘Bababu nwɔ mankpee di bakpileblatɛ kamɛ,’ dikpe nii diɛwa kaanya. Diekye ɔlaa wɔ bɛɛkpana ni di suoto nii, nwaako nfɛ diɔɔwa kaanya.” ");
INSERT INTO snw_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ni basaateketetɛ nɔɔ nwu latɔkɔ nwɔ alɛ, “Saate, nnya mpamii nnyɔ!” Ni di Yesu latɔkɔ ma alɛ, “Mminkpo mpɔ.” ");
INSERT INTO snw_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu ladie di okpoo aasifi Nnɔnyi Awoso Kobokote osi fɛ mmle ambla nii. Ni baasaateketetɛ nɔɔ kafɔɔ latikanko nwɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Obe wɔ baadu ni lɛba nwu nkpo, Yesu latɔkɔ basaateketetɛ nɔɔ alɛ, “Bipɛ ɔlaa bita Yaa alɛ bilaabuo di ɔsɔ onyu kamɛ.” ");
INSERT INTO snw_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ni aadiɛ ma aakyɛ sitũ kɛɛkɛ, ni aapɛ akunkyi aapɛ ɔlaa aata Yaa nɛ. ");
INSERT INTO snw_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ni aabuɛ alɛ, “Teete, nse dilɛfɔ, ni faata dibuo opũ wɔ mmle kufe mi. Kafɔɔ diele dibiesaa nii, ta dibiesaa lɛfɔ diwa kaanya.” ");
INSERT INTO snw_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ninfɛ di Yaa tɔkyɛntɛ onwii lakyɔɔ aakye osi abakpee nwɔ osie nɛ. ");
INSERT INTO snw_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ni aakple aapɛ ɔlaa aata Yaa osie kanya ku dibuo di otu kamɛ. Apipi ya niatoosoo aatookpete ni kaasɔ late fɛ ntɔ. ");
INSERT INTO snw_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Obe wɔ di Yesu laloo ni ɔlaa ɔpɛ ɔta Yaa, aataka aawa basaateketetɛ nɔɔ nfũ, aabanya ma baatɔɔkyɔsĩi. Ta lɛhaale niatika ma ni di suoto oso. ");
INSERT INTO snw_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ninfɛ aakaalɛ ma alɛ, “Be lɛsaa oso biɔkyɔsĩi? Bitaka biɛpɛ ɔlaa bita Yaa mmle minaabuo ni di ɔsɔ onyu kamɛ.” ");
INSERT INTO snw_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Obe wɔ di Yesu n-yɛ ɔɔkakatɛ nii, batii dikudi ninwii niakye baawa. Yuda wɔ niale ni saateketetɛ di lefosi banyɔ nwu kamɛ nialeko ma katũ. Ni aakyɛ Yesu nfũ alɛ ɔɔlaaminko nwɔ ambla nwɔ aatuu nɛ. ");
INSERT INTO snw_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Kafɔɔ Yesu lakaalɛ nwɔ alɛ, “Yuda, atuu ɔbla fɔɔyɔ fandiki ami, Otii Obi nwu, fanta?” ");
INSERT INTO snw_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Obe wɔ di basateketetɛ nwu lanya lɛsaa le nimawa nii, baakaalɛ Yesu alɛ, “Saate, bublako mpamii loo ɔkpɛ?” ");
INSERT INTO snw_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ninfɛ di saateketetɛ onwii layɔ kapamii aasafɔ Oletatɛ Nɔɔfo kpɛmblatɛ nɔɔ koletanɛɛ kotoko aakpa nɛ. ");
INSERT INTO snw_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Kafɔɔ Yesu latɔkɔ nwɔ alɛ, “Oowo! Tambla nkpo!” Ninfɛ di Yesu layɔ kɔnɛɛ aatika di kpɛmblatɛ nwu nkpo kotoko, ni kuakple kuate fɛ mmle kuate ni nɛ. ");
INSERT INTO snw_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ni di Yesu lakaalɛ olebatatɛ banɔɔfo ku Olekatakɔ banyuntɛ banɔɔfo ku okpoo banɔɔfo nwu niawa nwɔ ni omufũ alɛ, “Be oso di mpamii ku nwosoku bikle biɛwa mi omufũ fɛle kpileblatɛ nɔɔfo nle? ");
INSERT INTO snw_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Lasiɛ di Yaa Olekatakɔ nwu nkpo dii biala, kafɔɔ bitatɔkɔ bilɛ biomufũ mi. Kafɔɔ Yaa niɛta ye osuku wɔ mmle. Ni di Satana ditunu kamɛ otumi kole sɛka nunua nɛ.” ");
INSERT INTO snw_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Baamufũ Yesu ni baakpaa nwɔ baasifiko Oletatɛ Nɔɔfo leyo nɛ. Petro latikanko nwɔ sɛɛmaa fanfa. ");
INSERT INTO snw_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Batii bawo lakutaa ɔtɔ di leyo nwu nkpo kaflɔnkɔ, ni di Petro kafɔɔ lakyɛ aalaasiɛ ma kaamɛ aatɔɔwɔfɔ ɔtɔ nwu nɛ. ");
INSERT INTO snw_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Obe wɔ di ɔsanko kpɛmblatɛ onwii lanya Petro nsi ni di ɔtɔ nwu katũ, ni aanyu nwɔ tuwĩi aakyɔɔ nwɔ lɛnɛɛ aabuɛ alɛ, “Osuɔtɔ wɔ mmle kafɔɔ Yesu tikankotɛ ale.” ");
INSERT INTO snw_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Kafɔɔ Petro lasĩ aabuɛ alɛ, “Ɔsanko, diidii ninye nwɔ!” ");
INSERT INTO snw_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Di obe kakuii sɛmaa, osuɔtɔ onwii kafɔɔ lanya Petro ni aatɔkɔ nwɔ alɛ, “Afɔɔ onwii lɛma fale!” Kafɔɔ Petro lakple aadiki kanya alɛ, “Osuɔtɔ, kpa woo! Ninye nwɔ!” ");
INSERT INTO snw_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Diabla ni fɛ lebombo ninwii sɛmaa, osuɔtɔ bamba onwii lakple aabuɛ osie kanya aatika difuɔ alɛ, “Ɔlaa ɔnanfi kuonwii nnaa alɛ osuɔtɔ wɔ mmle diele Yesu tikankotɛ, diekye Galilea otii ale!” ");
INSERT INTO snw_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Kafɔɔ Petro ladiki kanya alɛ, “Osuɔtɔ, ninye ɔlaa wɔ foobuɛ nii!” Nfanwu ayɛ ɔɔkatatɛ nii, kɔɔkɔ niabo. ");
INSERT INTO snw_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Nfanwu di Saate lamunikĩi aanyu Petro tuwĩi nɛ. Ninfɛ di Petro lanyuma ɔlaa wɔ di Saate latɔkɔ nwɔ ni alɛ, “Fiɛ di kɔɔkɔ mabo ni ku kakyɛ ka, fababuɛ sitiɛ simu falɛ faaye mi.” ");
INSERT INTO snw_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ni di Petro ladie aasifi kayi aalaawi kaku osie kanya nɛ. ");
INSERT INTO snw_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Batii ba niatoonyu ni Yesu, baama nwɔ, baapɛ nwɔ kafɔɔ. ");
INSERT INTO snw_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Baanii nwɔ anu baapɛ nwɔ, ni baakaalɛ nwɔ alɛ, “Owe niɛpɛ fɔ? Tɔkɔ wo!” ");
INSERT INTO snw_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ni baatufa nwɔ kafɔɔ di sisuku bamba kpinwu suoto nɛ. ");
INSERT INTO snw_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Obe wɔ kaale lasɛ nii, okpoo banɔɔfo ku olebatatɛ banɔɔfo ku kufiofa batuotɛ labasi, ni baakpaa Yesu baawako bawokalɛɛkɔ nwu nkpo nɛ. ");
INSERT INTO snw_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Di bawo kalɛɛkɔ nwu, ni baakaalɛ Yesu alɛ, “Tɔkɔwo nsɛ afɔ ninle Kristo wɔ bɛɛpɛ ni ɔfɔɔ.” Ninfɛ aadiki kanya alɛ, “Mintɛ lɛtɔkɔ ye, bilɔɔwa mi ɔbafũ onu. ");
INSERT INTO snw_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ni nse lɛkaalɛ ye ɔlaa owo kafɔɔ, bilɔɔwa mi kanya okpee. ");
INSERT INTO snw_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kafɔɔ diɛyɔ ni di nua diesifi nii, ami, Otii Obi nwu, masiɛ di Yaa wɔ ninlenke ni oletanɛɛkyɛ.” ");
INSERT INTO snw_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ninfɛ bamuu lɛma baakaalɛ nwɔ alɛ, “Nioso afɔ ninle Yaa Obi nwu nɛ?” Ninfɛ aadiki kanya alɛ, “Aye bamu nikobuɛ bilɛ nnwɔɔ nle nɛ.” ");
INSERT INTO snw_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ni baabuɛ alɛ, “Diesinfĩ alɛ otii kuonwii kayila ɔlaa owo kamaa! Awo bamu butoonu ɔlaa wɔ eebuɛ nii!” ");
INSERT INTO snw_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Nfanwu batii dikudi nwu lataka baakpaa Yesu baasifiko Pilato nfũ. ");
INSERT INTO snw_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Nfa baakyako nwɔ kanya obudi alɛ, “Buomufũ osuɔtɔ wɔ mmle ɔɔkyɔnkyɔ batii loo anfenko di osuku lalaale suoto. Ɔɔtɔkɔ ma alɛ batanta akpooto lɛma baata Roma Batii Ɔka Kplɛ, ni aatɔkɔ ma kafɔɔ alɛ nnwɔɔ ninle Kristo wɔ bɛɛpɛ ni ɔfɔɔ, ni ɔka ale.” ");
INSERT INTO snw_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ni di Pilato lakaalɛ nwɔ alɛ, “Afɔ ninle Yuda batii Ɔka nwu nɛ?” Ninfɛ di Yesu ladiki kanya alɛ, “Nnwu fatoobuɛ nɛ.” ");
INSERT INTO snw_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ni di Pilato latɔkɔ olebatatɛ ku batii dikudi nwu nkpo alɛ, “Ninya okpile kuonwii di osuɔtɔ wɔ mmle suoto baalo nwɔ ni lɛpɔɔ.” ");
INSERT INTO snw_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Kafɔɔ baayila osie kanya baabuɛ alɛ, “Asaa otuo nɔɔ kokpee kudu di Yuda batii kamɛ. Aakye kasɔ di Galilea, ni atɔɔwa ɛɛbadu nfũ kafɔɔ nɛ.” ");
INSERT INTO snw_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Obe wɔ di Pilato lanu ni ɔlaa wɔ mmle, aakaalɛ alɛ, “Ni osuɔtɔ wɔ mmle Galilea otii ale?” ");
INSERT INTO snw_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Nkpo oso obe wɔ aatofo alɛ Yesu lekye ni Galilea kale kakyɛ ka di Herode kole ni sɛka, ni aakyesee nwɔ Herode nfũ nɛ. Herode wɔ mmle lawɛ di Yerusalem di obe nwu kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Suoto layɔɔ Herode di obe wɔ aanya ni Yesu. Diekye atoonu nwɔ leyooto kofokofoko, aatoomiɛ kafɔɔ alɛ aanyɔɔ. Aatoonyu osuku kafɔɔ alɛ aanya Yesu kɔbla sɛkpɛ se niɛbla ni ɔkpɛ. ");
INSERT INTO snw_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Nkpo oso Herode lakaalɛ Yesu sɛlaa kpinwu, kafɔɔ Yesu ditadiki ɔlaa kuonwii kanya. ");
INSERT INTO snw_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Nioso olebatatɛ ku kufiofa batuotɛ ladie baawa sitũ bababudi Yesu kanya, osie kanya. ");
INSERT INTO snw_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herode ku bakpɛtɛ nɔɔ lama Yesu osie kanya baatufa nwɔ. Ni baayɔ awukyɔ biene biene anwii baakpee nwɔ, ni baakplesɔɔ baasifiko Pilato nfũ nɛ. ");
INSERT INTO snw_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Dii nkpo kale, Herode ku Pilato lakple basiɛwo. Diekye saa, bawo balo baale. ");
INSERT INTO snw_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilato lalɛɛ olebatatɛ, okpoo banɔɔfo ku batii bamuu aasiisa. ");
INSERT INTO snw_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ni aatɔkɔ ma alɛ, “Biɛkpaa osuɔtɔ wɔ mmle biɛwakoe bilɛ, ɔɔkyɔnkyɔ ye afenko di osuku lalaale suoto. Ntoowolaa ɔlaa nwu kamɛ di anu lee. Kafɔɔ ninnya okpile kuonwii di sɛlaa se biebuɛ bietika nwɔ ni di suoto. ");
INSERT INTO snw_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herode kafɔɔ diɛnya okpile kuonwi di suoto nɔɔ fiɛ ɛɛkplesa nwɔ eekyesee wo. Otii wɔ mmle diɛbla okpile kuonwii baalo nwɔ lɛpɔɔ manta ni kukpi. ");
INSERT INTO snw_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Nkpo oso mata mampɛ nwɔ, nindiɛ nwɔ ansifi.” ");
INSERT INTO snw_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Di Okpi Diisi Ofe Dii ole biala kamɛ, Pilato lɛblasaa dile andiɛ leyotentɛ onwii anta ma. ");
INSERT INTO snw_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Nfa nfɛ baamuu lɛma baayiisa kudu osie kanya alɛ, “Lo nwɔ! Faadiɛ Baraba fata wo!” ");
INSERT INTO snw_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Baraba wɔ mmle, baatɛ nwɔ leeyo di kudu kowo aakpee ni di okpoo kplɛ kamɛ aalo ni batii bawo oso. ");
INSERT INTO snw_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato lamiɛ alɛ oodiɛ ni Yesu oso, aakple aalaakakatɛ aata batii nwu nkpo. ");
INSERT INTO snw_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Kafɔɔ baakple baayiisa kudu baalenkeesa kɔkasale alɛ, “Pɛ nwɔ sibuɛ fakaasa koowoso suoto! Pɛ nwɔ sibuɛ fakaasa koowoso suoto!” ");
INSERT INTO snw_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ninfɛ di Pilato lakple aakaalɛ ma ditiɛfa alɛ, “Ɔmɛnkpile ɛɛbla fiɛ? Ninnya lɛsaa le ɛɛbla ni oso kalo nwɔ lɛpɔɔ alɛ aakpi nii! Mata mampɛ nwɔ kowesee nindiɛ nwɔ ansifi.” ");
INSERT INTO snw_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Kafɔɔ mia nfɛ baakple baatɔɔfaa osie kanya baatoobuɛ alɛ, “Dikpe nii fɛɛta bɛɛpɛ Yesu sibuɛ bɛɛkaasa koowoso suoto.” Lɛyɛntɛle kudu lɛma nwu labalenkee Pilato nnɛɛ. ");
INSERT INTO snw_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Nkpo oso Pilato lababudisa ɔlaa nwu nkpo fɛ mmle baatii nwu komiɛ nii. ");
INSERT INTO snw_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ni aadiɛ otii wɔ boomiɛ ni aata ma nɛ. Nwɔ baatɛ ni leeyo ta kudu ko aakpee, aalo ni batii oso. Ni aadiɛ Yesu aakpee ma ninnɛɛ kamɛ alɛ balaabla nwɔ fɛ mmle boomiɛ ni. ");
INSERT INTO snw_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Bakpɛtɛ lakpaa Yesu baasifiko. Ni di obe wɔ bakyɛ di osuku boofe nii, baakyakako Kirene otii onwii baatɔɔlɛɛ ni Simon aakye kakpaayotũ ɔɔwa Yerusalem. Ni baayilasa nwɔ, baanyinka nwɔ alɛ afũ Yesu kowoso nwu atuka. Ni aafũ aatikanko Yesu nɛ. ");
INSERT INTO snw_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Batii dikudi lewo latikanko Yesu di nkpaamaa, basanko bawo kafɔɔ lasiɛ ma kaamɛ baatoowi kaku baatɔɔtɔɔ. ");
INSERT INTO snw_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ninfɛ di Yesu lamunikĩi aatɔkɔ ma alɛ, “Yerusalem basanko, bitanwi biatɛɛ, kafɔɔ biwi bita suoto ku babilee. ");
INSERT INTO snw_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Diekye ayi awo kɔwa baatii mabuɛ alɛ, ‘Suoto siyɔɔ ɔlɛma ku olofofɔtɔ wɔ kamɛ di obi didie ni diidii ku lɛnyɛɛ le manayinyɛɛfu ni diidii!’ ");
INSERT INTO snw_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Obe nwu ninle obe wɔ batii matɔkɔ abokote alɛ, ‘Bibiɛ bikpete wo!’ Mantɔkɔ kobokotee kafɔɔ alɛ, ‘Biwofasa wo!’ ");
INSERT INTO snw_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Diekye nse kowoso kɔɔnle kofiɛ mmle okle mɔ, ni lɛ kookosole mafiɛ?” ");
INSERT INTO snw_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Di obe nwu nkpo kamɛ, bakpɛtɛ nwu lakpaa basuɔtɔ banyɔ banwii ninle ni bakpileblatɛ baakyakaa di Yesu, boofenko olo. ");
INSERT INTO snw_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Obe wɔ baadu ni lɛba le bɔɔlɛɛ ni Otii Disi Dikufi, baapɛ Yesu sibuɛ baakaasa koowoso suoto ninfa, ku bakpileblatɛ banyɔ. Baapɛ onwii baakaasa di Yesu oletanɛɛkyɛ, ɔnyɔɔfa kafɔɔ di ɔmɛntukyɛ. ");
INSERT INTO snw_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ni di Yesu labuɛ alɛ, “Teete, yɔ fakyɛ ma, diekye baaye lɛsaa le bɔɔbla nii.” Nni kamaa, baayɔ awu nɔɔ baasɛ bawo di obe wɔ baawii ni atrebi baatofo n-ya di obiala lɛma kayɔ nii. ");
INSERT INTO snw_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Batii dikudi nwu nkpo layila baatoonyu nwɔ. Ni di Yuda batii batunletɛ nwu kafɔɔ layila baatɔɔma Yesu baatoobuɛ alɛ, “Aafũ batii bamba nkpa, bita afũ suoto nɔɔ kafɔɔ, nse nnwɔɔ ninle Kristo wɔ di Yaa lɛpɛ ni ɔfɔɔ!” ");
INSERT INTO snw_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Nkpo okle di bakpɛtɛ nwu kafɔɔ lama Yesu nɛ. Baayɔ nta nyankale baakyɛnko nwɔ alɛ anyi. ");
INSERT INTO snw_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ni baatɔkɔ nwɔ alɛ, “Nse afɔ ninle Yuda batii ɔka, faafũ suoto lɛfɔ nkpa buonyu!” ");
INSERT INTO snw_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Di lɛkantosi nɔɔ, baakpana sɛlaa se mmle alɛ, “Nnya Yuda Batii Ɔka ninle nwɔ nɛ.” ");
INSERT INTO snw_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Bakpileblatɛ banyɔ ba baapɛ baakasa ni koowoso suoto onwii lɛma latufa Yesu alɛ, “Diele afɔ ninle Kristo wɔ bɛɛpɛ ni ɔfɔɔ? Diki suoto faadiki wo kafɔɔ ɛɛ!” ");
INSERT INTO snw_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Kafɔɔ ɔnyɔɔfa lasĩ ɔlaa aatɔɔ aatɔkɔ nwɔ alɛ, “Fɔlɔɔyɛkɛ Yaa? Beelo fɔ lɛpɔɔ fɛ mmle okle beelo nwɔ ni lɛpɔɔ. ");
INSERT INTO snw_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Kafɔɔ awo lɛpɔɔ le beelo wo nii, lesiɛko wo. Diekye lɛsaa le buɔbla ni letokonanfi buofũ nɛ. Kafɔɔ nnwɔɔ aabla okpile kuonwii.” ");
INSERT INTO snw_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ninfɛ aatɔkɔ Yesu alɛ, “Yesu, nyuma mi nse feebuo sɛka lɛfɔ ole kamɛ.” ");
INSERT INTO snw_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ni di Yesu latɔkɔ nwɔ alɛ, “Nwaako kɔtɔkɔ fɔ nlɛ, miɛ wɔ mmle, munko fɔ bubabuo Paradiso kamɛ.” ");
INSERT INTO snw_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Di obe wɔ diapɛ ni fɛ kakũ lefosi elomu ɛnyɔ, kufĩ ladiɛ ɔpɛ, kayi kamuu lawɔfɔ, dialaase di kɔtɔɔfɔ elomu etiɛ kamɛ. ");
INSERT INTO snw_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ni di dibula le niasaka ni di Yaa Olekatakɔ labɛ di nkyɛ nnyɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ni di Yesu lafaa osie kanya aabuɛ alɛ, “Teete, leyɔ ninwuna nii, lekpee di nnɛɛ lɛfɔ kamɛ.” Obe wɔ aabuɛ ɔlaa wɔ mmle aaloo nii, ni aakpi nɛ. ");
INSERT INTO snw_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Baakpɛtɛ ɔnɔɔfo nwu lanya lɛsaa le niawa nii, ni aatansa Yaa aabuɛ alɛ, “Nwaako otii wɔ mmle, otii biene ale.” ");
INSERT INTO snw_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Obe wɔ baatii ba niawa ni nfa alɛ bɔɔbaanyu lɛsaa le nikɔwa ni lanya ni lɛsaa le niawa nii, baakple baasifi ayo, baayɔ nnɛɛ baatika nintɛɛ ku sɛyaami. ");
INSERT INTO snw_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Batii ba bamuu ninye ni Yesu ku basanko ba niatikanko nwɔ baakye ni Galilea layila kaakyonkɔ baatoonyu asaa. ");
INSERT INTO snw_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Osuɔtɔ onwii lawɛ baatɔɔlɛɛ ni Yosef. Aakye Arimatea di Yudea kasɔ suoto. Aale otii biene wɔ baatii mbu ni osie kanya. Aasiɛ aatoonyu osuku obe wɔ di Yaa sɛka kalekɔ mawa nii. ");
INSERT INTO snw_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Mintɛ aale Yuda batii Bakantɛ onwii lɛma yi, atatunako ma di disibu le baabla ni ku lɛsaa le baabla ni suoto. ");
INSERT INTO snw_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Aakyɛ Pilato nfũ aalaafũ Yesu kpi. ");
INSERT INTO snw_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ni aasoosa kpi nwu nkpo di kowoso suoto aayɔ dibula fututu aamiminisa nwɔ di suoto. Ni aayɔ nwɔ aalaakookaa di ofuɔnntuu ɔkya wɔ kamɛ manayikookaa ni otii kuonwii kaamɛ diidii nɛ. ");
INSERT INTO snw_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Dii nwu nkpo Fiida diale, baatoololaa suoto baatɔɔta Lɛnyɛɛtɛyi kale ɔsɛ. ");
INSERT INTO snw_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Basanko ba niatikanko Yesu baakye ni Galilea latikanko Yosef baakyɛ baalaanyu ɔkya nwu ku mmle baayɔ Yesu baakookaa ni kaamɛ. ");
INSERT INTO snw_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ni baakple baasifi leyo, baalaabla kɔfa kɔnɔkɔnɔ ku nnɔnyi be man-yɔ manfifia ni di kpi suoto baatɛ. Ni baatɛ ɔnyɛɛ di Lɛnyɛɛtɛyi suoto fɛ mmle di Yuda batii kufiofa nwu letuo ni nɛ. ");
INSERT INTO snw_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Di Kɔsida kolesɛtũ, basanko nwu lakyɛ ɔkya nwu katũ, baaklee kɔfa kɔnɔkɔnɔ ko baabla baase nii. ");
INSERT INTO snw_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ni baanya alɛ baamunusa difuɔ nwu di ɔkya kanya nɛ. ");
INSERT INTO snw_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Nkpo oso baabuo di ɔkya nwu kamɛ, kafɔɔ batanya Saate Yesu kpi nwu. ");
INSERT INTO snw_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Lɛsaa nwu labla ma yaaa. Nfanwu batii banyɔ banwii niakyɔɔ baakpee asaa fututu ya nikosesee ni di anu. ");
INSERT INTO snw_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Basanko nwu layɛkɛ osie kanya, ni baawakosa asi kasɔ baata batii nwu nɛ. Ni baatii nwu lakaalɛ, ma alɛ, “Be oso biowolaa otii wɔ ninkpe ni nkpa baakpi kamɛ? ");
INSERT INTO snw_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Anaa ninfũ. Atɔɔtaka! Binyuma ɔlaa wɔ aatɔkɔ ye ni, di obe wɔ aawɛ ni di Galilea alɛ, ");
INSERT INTO snw_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Dikpe nii, bɛɛyɔ Otii Obi nwu beekpee di bakpileblatɛ nnɛɛ kamɛ. Bɛɛpɛ nwɔ sibuɛ bɛɛkaasa koowoso suoto. Ni ayi atiɛ kamaa, abakple antaka ankye bakpi kamɛ.’ ” ");
INSERT INTO snw_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ni baasanko nwu lanyuma sɛlaa nɔɔ nwu nkpo nɛ. ");
INSERT INTO snw_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Baakple ni di ɔkya nwu katũ, baabuɛ sɛlaa se mmle simuu baatɔkɔ batɔkyɛntɛ lefosi onwii nwu ku babule bamuu. ");
INSERT INTO snw_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Basanko nwu niale Maria Magdalene ku Yohana ku Maria wɔ ninle ni Yakobo ɔya. Mma ku basanko bamba niatɔkɔ batɔkyɛntɛ nwu sɛlaa se mmle nɛ. ");
INSERT INTO snw_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Kafɔɔ batɔkyɛntɛ nwu lanyu alɛ, sɛlaa se baasanko nwu lebuɛ nii, sɛlaakuu sile batafũ sĩ baanu. ");
INSERT INTO snw_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Kafɔɔ Petro lataka aatoso aakyɛ ɔkya nwu katũ. Obe wɔ aadu ni nfa aakɛnsa aanyu ɔkya nwu kamɛ, kafɔɔ akookaabula lete aanya, atansinnya lɛsalɛsaa. Ni aakple aasifi leyo, diabla nwɔ yaaa di lesaa le niawa ni suoto. ");
INSERT INTO snw_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Di dii nwu nkpo kale kafɔɔ, Yesu batikankotɛ banyɔ banwii latoofe kakpaayotũ kanwii manlɛɛ ni Emaus kamɛ. Diawo fɛ akɔ akuɛnsĩ diedie ni di Yerusalem. ");
INSERT INTO snw_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Baatɔɔkakatɛko bawo di lɛsaa biala niawa ni suoto. ");
INSERT INTO snw_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Obe wɔ bakyɛ bɔɔkakatɛ mambuo ni sɛɛlaa nwu kamɛ yi, Yesu omu lakpukuti aatɛɛtɛɛ ma, baakyako ɔkyɛ. ");
INSERT INTO snw_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Baanyɔɔ, kafɔɔ batatofo alɛ nnwɔɔ diale. ");
INSERT INTO snw_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ninfɛ di Yesu lakaalɛ ma alɛ, “Ɔmɛnlaa bikyɛ biobuɛ di osuku?” Ni baayila baabla anu ku sɛnyaami. ");
INSERT INTO snw_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ni di onwii kaamɛ lɛma bɔɔlɛɛ ni Kleopa lakaalɛ Yesu alɛ, “Lete lɛfɔ ninle ɔfɔɔ di Yerusalem, fananye asaa ya niɛwa ni ninfa di ayi asɛɛ ya mmle kamɛ?” ");
INSERT INTO snw_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ni di Yesu lakaalɛ alɛ, “Be lɛsaa niawa?” Ni baadiki kanya alɛ, “Asaa ya niawa ni di Yesu Nasaret Otii suoto. Osuɔtɔ wɔ mmle Yaa ɔlaa buɛtɛtɛ aale. Nnwɔɔ di Yaa ku batii bamuu lɛnya alɛ, nwaako akpe otumi di asaa nɔɔ ɔbla ku sɛlaa nɔɔ obuɛ kamɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Yuda batii Yaa olebatatɛ banɔɔfo ku okpoo banɔɔfo loo layɔ nwɔ baakpee di Roma abaa ɔnɔɔfo nnɛɛ kamɛ, aalo nwɔ kukpi lɛpɔɔ baakaasɔɔ koowoso suoto baalo. ");
INSERT INTO snw_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nse nnwɔɔ buotika anu bulɛ ale otii wɔ nimadiki ni Israel batii bamuu nɛ. Ni nni nkpo kamaa, miɛ ninle dii tiɛfa di sɛlaa se mmle lawa ni nɛ. ");
INSERT INTO snw_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Basanko bawo kafɔɔ lɛbatɔkɔ wo ɔlaa wɔ niɛbla ni ɔkpɛ. Diekye bɛɛkyɛ ɔkya nwu katũ miɛ ku kolesɛtũ ko mmle. ");
INSERT INTO snw_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Kafɔɔ baanya kpi nɔɔ. Beekple bɛɛwa bɛɛbatɔkɔ wo alɛ Yaa batɔkyɛntɛ bawo lediki suoto beetuo ma. Ni bɛɛtɔkɔ ma alɛ, Yesu nkpe nkpa nɛ. ");
INSERT INTO snw_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Batii bawo lɛkyɛ ɔkya nwu katũ bɛɛlaanya fɛ mmle baasanko nwu lɛbabuɛ nii, kafɔɔ baanyɔɔ.” ");
INSERT INTO snw_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ninfɛ di Yesu latɔkɔ ma alɛ, “Biébe anu! Lɛ oso di ofũ onu lee lɛbla buɛɛ di asaa ya di Yaa ɔlaa buɛtɛtɛ nwu latɔkɔ ye ni suoto? ");
INSERT INTO snw_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Bieye bilɛ dikpe ni Kristo wɔ bɛɛpɛ ni ɔfɔɔ kafe diibuo le mmle kamɛ fiɛ ababuo di sɛka nɔɔ klekle nwu kamɛ?” ");
INSERT INTO snw_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ni di Yesu ladiki kɔsa aata ma di sɛlaa se beebuɛ ni di Kɔkpana Klekle Kukũ kamɛ di suoto nɔɔ nɛ. Diɛyɔ ni di Mose obe diɛlase ni di Yaa ɔlaa babuɛtɛ bamuu obe suoto. ");
INSERT INTO snw_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Obe wɔ nfɛ bɔɔtɛɛtɛɛ ni kakpaayotũ ka boofe nii, Yesu labla fɛ ɔɔwaalɛ anfe sitũ. ");
INSERT INTO snw_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Kafɔɔ baasĩ baatɔɔ baatɔkɔ nwɔ alɛ, “Kufĩ nfɛ mamɛɛ ni oso, akple aate di ɔkyɛ lɛma.” Nkpo oso aatikanko ma alɛ ɔɔlaate di ɔkyɛ lɛma. ");
INSERT INTO snw_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Aasiɛ kaasɔ alɛ oole alesaa ku mma. Ni aayɔ bloblo aapɛ Yaa sɛfa, ni aafee aayɔ aata ma nɛ. ");
INSERT INTO snw_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Nfanwu anu lɛma niasɛkɛtɛ baanya Yesu baatɛ nsũ, kafɔɔ aayu di anu lɛma. ");
INSERT INTO snw_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ni baatoobuɛ baatɔɔtɔkɔ bawo alɛ, “Obe wɔ ɛɛtɔɔkakatɛ kowo ni di osuku eetoodiki Kɔkpana Klekle Kukũ kasɔ ɛɛtɔɔta wo nii, suoto diɛtɔɔyɔɔ wo di otu kamɛ?” ");
INSERT INTO snw_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Nfanwu ni baataka baakple baasifi Yerusalem nɛ. Ni baanya batɔkyɛntɛ batii lefosi onwii nwu ku batii bamba beesi basi nɛ. ");
INSERT INTO snw_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ni baatɔkɔ batii nwu banyɔ alɛ, “Nwaako Saate nwu ntɔɔtaka eekye bakpi kamɛ, atoodiki suoto eetuo Simon.” ");
INSERT INTO snw_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ninfɛ di batii nwu banyɔ kafɔɔ latɔkɔ ma lɛsaa le niawa ni di osuku suoto ku mmle baanyɔɔ baatɛ ni nsũ di obe wɔ aafee bloblo aata ma nii. ");
INSERT INTO snw_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Obe wɔ baatii nwu nkpo banyɔ nkle ɔlaa lɛma boobuɛ manayiloo nii, nfanwu Yesu niadie aayila ma kaamɛ. Ni aatɔkɔ ma alɛ, “Atoko ɔkyɛ ole disiɛko ye.” ");
INSERT INTO snw_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Lɛyɛkɛ lapɛ ma osie kanya alɛ kpi bɔɔnya. ");
INSERT INTO snw_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Kafɔɔ aatɔkɔ ma alɛ, “Be oso diisibu lee kɔkpɔkpɔtɔ nkpo? Be oso minofũ binu? ");
INSERT INTO snw_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Binyu mi nnɛɛ ku nkpaa. Biɛkpankoe kafɔɔ binyu, bietofo bilɛ ami dile. Diekye kpi nnaa suoto sina ku akufi, fɛ mmle biɔnya bilɛ nkpe nii.” ");
INSERT INTO snw_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Aabuɛ nwu aaloo nii, ni aatuo ma nnɛɛ ku nkpaa nɔɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Suoto latɔɔyɔɔ ma osie kanya, di lɛsaa nwu labla ma ni ɔkpɛ, batafuo ofũ onu. Ninfɛ di Yesu lakaalɛ ma alɛ, “Lelesaa lewo nkpe ye ninfũ?” ");
INSERT INTO snw_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ni baayɔ kakpaku fiɛle kawo baatɔɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ni aafũ aawee di anu lɛma nɛ. ");
INSERT INTO snw_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ninfɛ di Yesu latɔkɔ ma alɛ, “Nle mmle ninle asaa ya latɔkɔ ye ni di obe wɔ lawɛ ni di ɔkyɛ lee nɛ. Lɛsaa lele bɛɛkpana beekyeko suoto nii di Mose kufiofa kukũ kamɛ, Yaa ɔlaa babuɛtɛtɛ akũ kamɛ ku sinu akũ kamɛ ntɔɔwa kaanya.” ");
INSERT INTO snw_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ni aasɛkɛtɛ ma disibu baanu Kɔkpana Klekle Kukũ kasɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ni aatɔkɔ ma alɛ, “Bɛɛkpana bɛɛtɛ alɛ Kristo wɔ bɛɛpɛ ni ɔfɔɔ mafe diibuo kamɛ, abataka ankye bakpi kamɛ di dii tiɛfa suoto. ");
INSERT INTO snw_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ni leeyooto nɔɔ kamɛ basaateketetɛ nɔɔ kayie lɛkya manta nnle mmuu alɛ baakyisa situ, alɛ Yaa kayɔ sikpile lɛma ankyɛ ma. Lɛkya le mmle oyie makye kasɔ di Yerusalem. ");
INSERT INTO snw_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Aye ninle sɛlaa se mmle kamaa bayilatɛ kaakɔ lele nɛ. ");
INSERT INTO snw_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ami omu mayɔ lɛsaa le di Teemi lebuɛ ɛɛtɛ alɛ abata ye ni nkyesee ye. Kafɔɔ bisiɛ di Yerusalem okpoo kamɛ diɛlaase di obe wɔ di otumi makye osi kumabuo ye ni kaamɛ.” ");
INSERT INTO snw_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Nni kamaa, Yesu lakpaa basateketetɛ nwu adieko di Yerusalem okpoo kamɛ aasifiko Betani ɔlɔɔkɔ. Ni aakplesa nnɛɛ katoo aatama dikusɛkusɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Di obe wɔ ɔɔta ma ni dikusɛkusɛ ninfa, ni baabla baawo suoto nɛ, ni di Yaa lakpaa nwɔ aasifiko osi nɛ. ");
INSERT INTO snw_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ninfɛ baapɛ akunkyi basumu nwɔ, ni baakple baasifi Yerusalem ku suoto lɛyɔɔ nimu nɛ. ");
INSERT INTO snw_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ni baatɔɔkyɛ Yaa Olekatakaɔ wlawla baalaatɔɔtansa Yaa nɛ.");
INSERT INTO snw_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Kaasɔ kakyeko fiɛ bababla ni kayi ka mmle yi, Ɔlaa nwu lawɛ. Nnwu ku Yaa niawɛ. Ɔlaa nwu nkpo kafɔɔ ninle Yaa nɛ. ");
INSERT INTO snw_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Diayɔ ni kaasɔ kakyekɔ yi, Ɔlaa nwu ku Yaa niawɛ. ");
INSERT INTO snw_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ɔlaa nwu suoto di Yaa lafe aabla lɛsaa biala nɛ. Lɛsalɛsaa kuninwii nnaa alɛ diele Ɔlaa nwu nkpo suoto beefe fiɛ bɛɛbla ni nii. ");
INSERT INTO snw_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ɔlaa nwu kamɛ di nkpa lɛtaa diekye nɛ. Nkpa nwu nkpo kafɔɔ lɛyɔ lɛkpa diɛwako batii bamuu. ");
INSERT INTO snw_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Lɛkpa le mmle kafɔɔ lɛkpa di ditunu kamɛ. Ditunu kafɔɔ diefuo lɛkpa le mmle otĩi. ");
INSERT INTO snw_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Di obe nwu nkpo kamɛ, Yaa lakyesee otii onwii. Leyooto nɔɔ ninle Yohane nɛ. ");
INSERT INTO snw_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Nnwɔɔ niawa aabakakatɛ aata batii di lɛkpa nwu nkpo suoto nɛ, alɛ batii bamuu kanu ɔlaa nɔɔ nwu alɛ, baafũ mannu. ");
INSERT INTO snw_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Diele Yohane wɔ mmle ninle lɛkpa nwu nkpo. Nnwɔɔ ɔwa ko aawa aabakakatɛ di lɛkpa nwu nkpo suoto. ");
INSERT INTO snw_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Di obe nwu nkpo kamɛ yi, lɛkpa le nimu nimu ninkpa ninta ni batii bamuu nfɛ kɔwa kayi ka mmle kamɛ. ");
INSERT INTO snw_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ɔlaa nwu nkpo lawɛ kaayi ka mmle kamɛ, kafɔɔ kayi ka mmle ditatofo nwɔ, nu ninnwɔɔ suoto di Yaa lafe aabla kayi ka mmle. ");
INSERT INTO snw_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Aawa nnwɔɔ omu nɔɔ batii nfũ, kafɔɔ batii nɔɔ nwu nkpo ditafukuti nnɛɛ baafũ nwɔ. ");
INSERT INTO snw_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Kafɔɔ batii ba bamuu niafũ nwɔ nii, baafũ nwɔ kafɔɔ baanu nii, ɛɛta ma osuku alɛ, baale Yaa babi. ");
INSERT INTO snw_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Batalofo batii ba mmle fɛ mmle okle di osuɔtɔ ku ɔsanko nnya bawo fiɛ manlofo ni babi, ee otii dibiesaa kanya. Kafɔɔ Yaa omu nfɛ nietuna alɛ baale nwɔ babi. ");
INSERT INTO snw_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ɔlaa nwu nkpo lɛbakple otii kuasiɛ wo kaamɛ, nwaako ole ku sibualɛ leyii nwɔ kamɛ pɔ. Buanya kafɔɔ Lɛkpa nɔɔ. Lɛkpa le aafũ aakyeko ni Ote nfũ ta Obi onwii ale nwɔ ni oso. ");
INSERT INTO snw_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohane lakakatɛ aata batii aakyeko nwɔ suoto, aafaa aabuɛ alɛ, “Nnya otii wɔ mmle suoto labuɛ nlɛ, ‘Otii wɔ nikɔwa ni sɛɛmaa nii lɛtaka katoo alenke mi, diekye akpe kofokofoko fiɛ nfɛ bɛɛbabla mi.’ ” ");
INSERT INTO snw_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ta sibualɛ ku nwaako ɔlaa nwu leyii nwɔ ni kamɛ oso, obe lele oowii wo lɛyɔɔ. ");
INSERT INTO snw_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Lɛkasale, Yaa layɔ kufiofa nɔɔ nwu aafenko di Mose suoto aata wo. Kafɔɔ eele wo sibualɛ ku nwaako ɔlaa nwu nkpo diefe ni di Yesu Kristo suoto. ");
INSERT INTO snw_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Otii kuonwii diinya Yaa anya diidii. Diediki Obi nwu nkpo onwii ninkyɛkyɛ ni ku Yaa, akpe ni di Ote nfũ, nnwɔɔ niediki nwɔ eetuo batii nɛ. ");
INSERT INTO snw_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yuda batii batunletɛ lakpee olebatatɛ ku Lewi batii bawo baakye Yerusalem alɛ, bakyɛ baalaakaalɛ Yohane alɛ, nnwɔɔ owe ale. ");
INSERT INTO snw_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yohane ditasĩ kanya odiki, ni aatɔkɔ ma aatikiti alɛ, “Diele ami ninle Kristo nwu nkpo.” ");
INSERT INTO snw_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ninfɛ di olebatatɛ nwu lakple baakaalɛ nwɔ alɛ, “Ni owe fale mɔ? Afɔ ninle Yaa Ɔlaa Buɛtɛtɛ Elia?” Ninfɛ di Yohane ladiki kanya alɛ, “Diele nnwɔɔ nle.” Ninfɛ baakple baakaalɛ nwɔ alɛ, “Afɔ ninle Yaa ɔlaa buɛtɛtɛ wɔ baabuɛ baatɛ alɛ abawa ni nɛ?” Ninfɛ aadiki kanya alɛ, “Oowo.” ");
INSERT INTO snw_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Nkpo oso baatɔkɔ nwɔ alɛ, “Ni tɔkɔwo otii wɔ fale ni. Diekye dikpe ni buɔkplesa kanya buɔkyɛnko batii ba niekpee wo ni kɔtɔ. Ɔmɛnlaa fakpe fambuɛ di suoto lɛfɔ?” ");
INSERT INTO snw_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ninfɛ di Yohane ladiki kanya aatɔkɔ ma alɛ, fɛ mmle okle di Yaa Ɔlaa Buɛtɛtɛ Yesaia lakpana aatɛ nii, “Ami ninle otii wɔ sɛlɔ nikɔfaa ni di ɔfaafuu kamɛ simbuɛ ni alɛ, bilolaa osuku bitɛ bita Saate nwu ɔwabee nɛ.” ");
INSERT INTO snw_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ninfɛ di batii ba baakpee ni kɔtɔ baakye ni Farisi batii kamɛ, ");
INSERT INTO snw_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","baakaalɛ Yohane alɛ, “Nni, nse faale Kristo, ee Elia, ee Yaa ɔlaa buɛtɛtɛ nwu nkpo mɔ, ni lɛ oso fookpeesa batii Yaa ntu?” ");
INSERT INTO snw_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ninfɛ di Yohane ladiki kanya alɛ, “Ami yi, kokpeesa batii Yaa ntu, kafɔɔ otii onwii n-yɛ kaamɛ lee minanye nwɔ nii. ");
INSERT INTO snw_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Nnwɔɔ ninle otii wɔ nintikankoe ni sɛɛmaa abawa ni nɛ, otii wɔ ninansiɛko alɛ bia kadiki nwɔ ni ntokokata sikũ.” ");
INSERT INTO snw_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Asaa ya mmle amuu lawa di Betania okpoo diɛ Yordan okle sɛmaa. Nfa di Yohane latokpeesa batii Yaa ntu nɛ. ");
INSERT INTO snw_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Di kale lasɛ nii, Yohane lanya Yesu latɔɔwa ɔkyɛ nɔɔ, ni aabuɛ aatɔkɔ batii ba niayila nwɔ ni di ɔlɔɔkɔ alɛ, “Nnya Yaa Oleɔta Lefosobi nwu nkpo niɛwa ni kayi ka mmle alɛ ɔbatekete ni batii sikpile di suoto lɛma! ");
INSERT INTO snw_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Nnwɔɔ ninle otii wɔ suoto latɔɔkakatɛ ni di obe wɔ labuɛ nlɛ, ‘Otii onwii kɔwa sɛmaa nii, nnwɔɔ ɛɛtakakatoo aleneke mi, diekye, akpe kofokofoko fiɛ bia bɛɛbabla mi.’ ");
INSERT INTO snw_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ami omu kafɔɔ ntatofo nlɛ nnwɔɔ nɛ. Kafɔɔ lɛwa kokpeesa batii Yaa ntu alɛ kadiki nwu ntuo Israel batii bamuu.” ");
INSERT INTO snw_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ninfɛ di Yohane lakple aabuɛ di suoto nɔɔ alɛ, “Lanya Yaa Ninwuna kosoo ninkye osi, fɛ mmle di lɛlaapɔɔ nsoo nii, diabasiɛ nwɔ di suoto. ");
INSERT INTO snw_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Kaasɔ kakyekɔ yi, ntatofo nwɔ. Kafɔɔ Yaa wɔ niekpee mi alɛ makpeesa ni batii nɔɔ ntu yi, aatɔkɔ mi alɛ, ‘Otii wɔ suoto fabanya Ninwuna nii lesoo diɛbasiɛ ni di suoto nɔɔ yi, nnwɔɔ ninle otii wɔ nimakpeesa ni batii ku Ninwuna Klekle nɛ.’ ");
INSERT INTO snw_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nkpo oso amii ntɔɔnya. Nioso nwaako kɔtɔkɔ ye ntikiti nlɛ nnwɔɔ ninle Yaa Obi nwu nkpo nɛ.” ");
INSERT INTO snw_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Kaleesɛ yi, Yohane ku basaateketetɛ nɔɔ banyɔ lakple baayila ninfa. ");
INSERT INTO snw_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Obe wɔ aanya Yesu latoofe ni yi, ni aabuɛ alɛ, “Nnya Yaa Oleɔta Lefosobi nwu nkpo!” ");
INSERT INTO snw_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Obe wɔ di Yohane basaateketetɛ banyɔ nwu nkpo lanu aabuɛ ni ɔlaa nwu nkpo yi, ni baasifi baalaatikanko Yesu nɛ. ");
INSERT INTO snw_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Obe wɔ di Yesu lamunikĩi aanya alɛ batikanko nwɔ nii, ni aakaalɛ ma alɛ, “Obe lɛsaa biowolaa?” Ni baadiki kanya, baakaalɛ nwɔ alɛ, “Rabi,” leyooto le mmle lɛsɔdiki ninle alɛ Saatuotɛ, “Lekoto, ɔfɛ fasi?” ");
INSERT INTO snw_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ninfɛ di Yesu latɔkɔ ma alɛ, “Biwa biɛbanyu.” Di obe nwu nkpo kamɛ diabla fɛ kɔtɔɔfɔ abombo ana. Nkpo oso baatikanko nwɔ baakyɛ baalaanyu nfũ asi nii, ninfɛ baayɛntɛ nwɔ osiɛko dii nwu nkpo kale nɛ. ");
INSERT INTO snw_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Basaateketetɛ nwu nkpo nianu ni Yohane ɔlaa wɔ aabuɛ fiɛ baatikanko ni Yesu onwii lɛma niale Andrea wɔ niale ni Simon Petro obilɛma nɛ. ");
INSERT INTO snw_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Nfanwu ni aanya obilɛma Simon nɛ, ni aatɔkɔ nwɔ alɛ, “Butɔɔnya Mesia nwu nkpo.” Ɔlaa wɔ mmle kasɔ ninle alɛ Kristo wɔ bɛɛpɛ ni ɔfɔɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ninfɛ aakpaa Simon aakyɛnko Yesu nɛ. Obe wɔ di Yesu lanyu ni Simon, ni aabuɛ alɛ, “Afɔ ninle Simon, Yohane Obi nɛ. Kafɔɔ nunua yi, babatɔɔlɛɛ fɔ alɛ Kefas,” ee Petro, ayooto ya mmle lɛsɔdiki ninle alɛ difuɔnkpaa nɛ. ");
INSERT INTO snw_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Obe wɔ kaale lasɛ nii, Yesu labla disibu alɛ ɔɔkyɛ Galilea kasɔ suoto. Ni aanya osuɔtɔ onwii manlɛɛ ni Filipo nɛ, ni aatɔkɔ nwɔ alɛ, “Wa fabatikankoe.” ");
INSERT INTO snw_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipo wɔ mmle lakye Betsaida, okpoo wɔ di Andrea ku Petro kafɔɔ lakye nii. ");
INSERT INTO snw_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Obe wɔ di Filipo lakyɛ aalaanya ni Natanael, ni aatɔkɔ nwɔ alɛ, “Butɔɔnya otii wɔ suoto di Mose ku Yaa ɔlaa babuɛtɛtɛ lakpana asaa baakyeko ni di Kɔkpana Klekle Kukũ kamɛ. Nnwɔɔ ninle Yesu wɔ niekye ni Nasaret nɛ. Yosef obi ale.” ");
INSERT INTO snw_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ninfɛ di Natanael lakaalɛ nwɔ alɛ, “Lɛsaa biene lewo kafuo odie okye Nasaret fiɛ?” Ninfɛ di Fililpo latɔkɔ nwɔ alɛ, “Afɔ yi, wa fabanyu!” ");
INSERT INTO snw_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Obe wɔ di Yesu lanya Natanael kɔwa ni ɔkyɛ nɔɔ, ni aabuɛ aakyeko di suoto nɔɔ alɛ, “Nnya Israel obi omu omu ninle nwɔ mmle nɛ. Kakyɔnkyɔ kukanwii diesi nwɔ kaamɛ.” ");
INSERT INTO snw_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Obe wɔ di Natanael lanu ni ɔlaa wɔ mmle, ni aakaalɛ Yesu alɛ, “Lɛ diɛbla fiɛ faye mi?” Ninfɛ di Yesu ladiki kanya aatɔkɔ nwɔ alɛ, “Ntɔɔnya fɔ kofokofoko di kubue nwu nkpo kalɔ fiɛ di Filipo lalɛɛ fɔ.” ");
INSERT INTO snw_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ninfɛ di Natanael ladiki kanya aabuɛ aatɔkɔ Yesu alɛ, “Saatuotɛ, nwaako afɔ ninle Yaa Obi nwu nkpo nɛ. Israel Batii Ɔka ninle afɔ!” ");
INSERT INTO snw_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ninfɛ di Yesu latɔkɔ nwɔ alɛ, “Ta mmle lɛtɔkɔ fɔ nlɛ lɛnya fɔ ni di kubue nwu nkpo kalɔ oso fatoofũ feenu? Ni fabanya asaa kplɛ ya niɛtaka katoo alenke ni nle mmle.” ");
INSERT INTO snw_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ninfɛ di Yesu lakple aatɔkɔ nwɔ alɛ, “Nwaako kɔtɔkɔ fɔ nlɛ, fabanya mmle okle di kolo masɛkɛtɛ nii, di Yaa batɔkyɛntɛ matooyie mantoosoo ni di ami, Otii Obi nwu, suoto.” ");
INSERT INTO snw_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Di ayi atiɛ sɛmaa, baayɔ ɔsanko di okpoo wɔ bɔɔlɛɛ ni Kana di Galilea kasɔ suoto. Yesu ɔya lakyɛ nfa. ");
INSERT INTO snw_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ni baakyakako Yesu ku basaateketetɛ nɔɔ kafɔɔ di ɔsanko nwu nkpo kayɔkɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Obe wɔ di nta be baatɔɔblako ni ɔkpɛ laloo nii, ninfɛ di Yesu ɔya lakyɛ Yesu nfũ aalaatɔkɔ nwɔ alɛ, “Nta be bɔɔblako ni ɔkpɛ ntooloo ma.” ");
INSERT INTO snw_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ninfɛ di Yesu latɔkɔ ɔya alɛ, “Mma, diele afɔ nimatɔkɔ mi lɛsaa le dikpe ni lɛbla nii. Diekye obe wɔ dikaatɛ alɛ lɛta ni lɛkyakaako diiwo.” ");
INSERT INTO snw_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ninfɛ di Yesu ɔya lakyɛ aalaatɔkɔ bakpɛmblatɛ ba niatɔɔblako ni nta nwu nkpo ɔkpɛ alɛ, “Lɛsaa lele ɛɛtɔkɔ ye alɛ bibla yi, biɛbla.” ");
INSERT INTO snw_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Yuda batii ɔsaabla kuale alɛ baafoto suoto fiɛ baabuo ayo. Nkpo oso baase afuɔ sɛpɔɔlɔ kplɛ akuɔ ninfa, di ntu adubukii fɛ ana ee anɔɔ nikayii ni ninwii kamɛ. ");
INSERT INTO snw_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ninfɛ di Yesu latɔkɔ bakpɛmblatɛ nwu alɛ, “Bidu ntu biyiisa sɛpɔɔlɔ nwu nkpo kamɛ.” Nkpo oso baadu ntu baakpete sĩ kaamɛ siayii tɛkɛtɛkɛ. ");
INSERT INTO snw_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ninfɛ di Yesu latɔkɔ bakpɛmblatɛ nwu alɛ, “Bikusii ntu nwu nwo bikyɛnko osuɔtɔ nwu nin-yɛ ni di ɔsaabla nwu kanya.” Ninfɛ baakusii mi baakyɛnko nwɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Obe wɔ di ɔnɔɔfo nwu nin-yɛ ni di ɔsaabla nwu nkpo kanya latu ntu be nintookple ni nta aanyu nii, atatofo nfũ di nta nwu nkpo lakye nii. Kafɔɔ bakpɛmblatɛ nwu nkpo niakusii mi nii, mma, baatofo. Nkpo oso ɔnɔɔfo nwu nkpo lalɛɛ ɔsanko nwu nkpo ɔsa, ");
INSERT INTO snw_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ni aatɔkɔ nwɔ alɛ, “Otii biala n-yɔ nta biene anta batii manyi, nse nfɛ boosiɛ fiɛ nfɛ an-yɔ mbe ninanlɛ ni anwako ma manyi. Kafɔɔ afɔ mianwu nfɛ fɛɛyɔ mbiene fɛɛwako nɛ.” ");
INSERT INTO snw_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Nle mmle di Yesu labla ni di Kana okpoo di Galilea kasɔ ninle ɔkpɛ wɔ niabla ni ɔkpɛ kasale aabla ni aayɔ aadiki ni lɛkpa nɔɔ aatuo ni nɛ. Ni di basaateketetɛ nɔɔ lafũ nwɔ baanu nɛ. ");
INSERT INTO snw_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Di nle mmle sɛmaa, Yesu ku ɔya ku babilɛma suɔtɔbi ku basaateketetɛ nɔɔ lasifi Kapernaum, baalaasiɛ ninfa ayi asɛɛ awo. ");
INSERT INTO snw_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ditoobu ayi asɛɛ di Yuda batii Okpi Diisi Ofe Dii olebee nfɛ mawo nii, Yesu lakyɛ Yerusalem. ");
INSERT INTO snw_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Obe wɔ aakyɛ ni Yaa Olekatakɔ nwu nkpo kamɛ, aalaanya batii kosunsũ banankyue ku bafoso ku ablonumaa. Aanya kafɔɔ batii ba nikobiɛ ni ato nsi di sipunu lɛma katũ. ");
INSERT INTO snw_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Nkpo oso aayɔ sikũ aaloso mpile, ni aatososa batii nwu nkpo ninkosunsũ ni babɔkɛɛ nwu ku banankyue ku bafoso nwu nkpo aadiki di Yaa Olekatakɔ nwu kamɛ nɛ. Ni aatukusa koto babiɛtɛ sipunu nwu aayu, aasamiisa koto nwu nkpo kafɔɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ninfɛ aatɔkɔ batii ba niatoosunsũ ni ablonumaa alɛ, “Bidieko ma ninfũ bisifiko! Biediɛ Teemi leyo ɔyɔ ɔbla asaa kasunsukɔ!” ");
INSERT INTO snw_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Nfa nfɛ di basaateketetɛ nɔɔ lanyuma ɔlaa wɔ bɛɛkpana ni Kɔɔkpana Klekle Kukũ kamɛ alɛ, “O Yaa, lɛbɔmbɔ nii di Leyo lɛfɔ suoto lɛta ninu lɛsɛɛ mi.” ");
INSERT INTO snw_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ta nle mmle oso, Yuda batii batunletɛ lawa Yesu nfũ babakaalɛ nwɔ alɛ, “Lɛmɛntuosaa faafuo ɔbla otuo wo alɛ fakpe osuku fambla lɛsaa le mmle?” ");
INSERT INTO snw_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ninfɛ di Yesu ladiki kanya alɛ, “Bibiɛ Yaa Leyo le mmle bitɛ kaasɔ, di ayi atiɛ kamɛ yi, makple nse ni letofo.” ");
INSERT INTO snw_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ninfɛ baakaalɛ Yesu alɛ, “Be foobuɛɛ? Obe wɔ bɛɛyɔ alɛɛ afosi ana alɛɛ akuɔ beetofo ni Leyo le mmle, fabayɔ ayi atiɛ fanse ni letofo?” ");
INSERT INTO snw_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Batanu ɔlaa wɔ mmle kasɔ. Diekye leyo le suoto di Yesu latɔɔkakatɛ ni niale suoto nɔɔ sina nɛ. ");
INSERT INTO snw_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Nioso, sɛmaa, obe wɔ di Yaa lasɛnkɛsa Yesu aakyeko ni bakpi kamɛ fiɛ nfɛ di basaateketetɛ nɔɔ lanyuma alɛ aabuɛ ɔlaa wɔ mmle. Nkpo oso baafũ Kɔkpana Klekle kamɛ sɛlaa se bɛɛkpana ni ku ɔlaa wɔ di Yesu labuɛ ni baanu. ");
INSERT INTO snw_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Obe wɔ di Yesu lawɛ ni di Yerusalem di Okpi Diisi Ofe Dii olebee nwu kamɛ yi, batii kpinwu lafũ nwɔ baanu, di obe wɔ baanya ni sɛkpɛ se niɛbla ni ɔkpɛ ate ate se aabla ni oso. ");
INSERT INTO snw_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Kafɔɔ Yesu omu ditadiɛ suoto nnɛɛ ata ma, diekye aatofo batii nwu bamuu. ");
INSERT INTO snw_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Nkpo oso ditafĩ alɛ otii kuonwii katɔkɔ nwɔ batii ba okle bale nii, diekye nnwɔɔ omu aye otii letembi kaasɔ ka mmle suoto. ");
INSERT INTO snw_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Di obe nwu nkpo kamɛ yi, Yuda batii tunletɛ onwii lawɛ baatɔɔlɛɛ ni Nikodemo. Aasiɛ di dikudi le baatɔɔlɛɛ ni Farisi batii kamɛ. ");
INSERT INTO snw_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Dii ninwii kakyɛ, aamaa buɛɛ aawa Yesu nfũ, ni aabaakaalɛ nwɔ alɛ, “Saatuotɛ, buye bulɛ Yaa nfũ feekye. Diekye otii kuonwii dilabafuo sɛkpɛ se niɛbla ni ɔkpɛ, fɔɔbla ni ɔbla, nse Yaa diesiko nwɔ.” ");
INSERT INTO snw_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ninfɛ di Yesu latɔkɔ nwɔ alɛ, “Nwaako kɔtɔkɔ fɔ nlɛ, nse baase otii lelofo yi, ɔlɔbafuo Yaa sɛka kalekɔ nwu nkpo kamɛ ɔnya.” ");
INSERT INTO snw_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ninfɛ di Nikodemo lakaalɛ nwɔ alɛ, “Be foobuɛɛ? Lɛ nse otii ntoomuɔ baakple manse nwɔ lelofo, sɛɛ okple aakple ansifi ɔya kafutu kamɛ, mankple manse nwɔ lelofo lɛnyɔɔfa?” ");
INSERT INTO snw_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ninfɛ di Yesu latɔkɔ nwɔ alɛ, “Nwaako kɔtɔkɔ fɔ nlɛ, nse baase otii lelofo di ntu ku Yaa Ninwuna kamɛ, ɔlɔbafuo Yaa sɛka kalekɔ nwu nkpo kamɛ obuo. ");
INSERT INTO snw_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Diekye otii wɔ beefe di suoto sina kamɛ beelofo ni yi, suoto sina kamɛ otii ale. Kafɔɔ nwɔ beelofo ni di Yaa Ninwuna kamɛ yi, ninwuna kamɛ otii ale. ");
INSERT INTO snw_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Nkpo oso tanta diabla fɔ ɔkpɛ alɛ lɛtɔkɔ fɔ nlɛ dikpe nii beese ye lelofo. ");
INSERT INTO snw_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Kɔfɛɛfɔ nfɛ kunfe nfũ ninlɛkũ nii. Fannukũ diwi, kafɔɔ fántofo nfũ kuokye nii, ku nfũ kuofe nii. Nkpo okle kafɔɔ dite ku otii wɔ beelofo ni di Ninwuna kamɛ nɛ.” ");
INSERT INTO snw_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ninfɛ di Nikodemo lakaalɛ Yesu alɛ, “Lɛ ninle mmle kamafuo ɔwa kaanya?” ");
INSERT INTO snw_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ninfɛ di Yesu latɔkɔ nwɔ alɛ, “Saatuotɛ kplɛ fale di Israel batii kamɛ. Ni be oso floonu asaa ya mmle kasɔ? ");
INSERT INTO snw_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nwaako kɔtɔkɔ fɔ nlɛ munkakatɛ di asaa ya buye ni suoto, asaa ya butɔɔnya ni kafɔɔ mun-yɔ kanya loo mundiki mumbuɛ. Kafɔɔ kuonwii lee dilootuna alɛ afũ ɔlaa wɔ lɛkya buoyie ni anu. ");
INSERT INTO snw_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nse lɛkakatɛ di kayi ka mmle asaa suoto lɛta fɔ fananfũ mi fanu mɔ, ni lɛ dibabla nse lekakatɛ lɛta fɔ di Yaa kafa asaa suoto fiɛ fabafũ mi fannu? ");
INSERT INTO snw_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Otii kuonwii diikata akyɛ osi anya, dilenkee ami, Otii Obi nwu lete niakye osi aawa kasɔ ka mmle nwu suoto. ");
INSERT INTO snw_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Fɛ mmle okle di Mose latakatɛsa kɔsaanwu ko baayɔ lɛbɔɔsaa baabla ni aasaka ni koowoso suoto di ɔfaafuu kamɛ yi, nkpo okle kafɔɔ dikpe ni bɛɛtakatɛsa ami, Otii Obi nwu nkpo katoo nɛ, ");
INSERT INTO snw_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","alɛ otii lele niefũ mi eenu, aawɛ nkpa be ninnaa ni kaloo. ");
INSERT INTO snw_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Diekye Yaa ntɛ ambɔmbɔ kayi ka mmle osie kanya, ni ɛɛyɔ Obi nɔɔ onwii nwu ɛɛta alɛ, otii lele niefũ nwɔ eenu, alaawɔɔ. Kafɔɔ, aawɛ nkpa be ninnaa ni kaloo. ");
INSERT INTO snw_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Diekye Yaa diekyesee Obi nɔɔ nwu alɛ abakanko batii kaayi ka mmle alo ma lɛpɔɔ. Kafɔɔ alɛ diefe ni di Obi nɔɔ nwu suoto, batii kawɛ didiki. ");
INSERT INTO snw_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Batii ba niefũ Yaa Obi nwu beenu nii, Yaa dilaakanko ma alo ma lɛpɔɔ. Kafɔɔ batii ba ninanfũ nwɔ banu nii, batookpi lɛpɔɔ kofokofoko, diekye baafũ Yaa Obi nwu nkpo onwii banu. ");
INSERT INTO snw_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Lɛsaa le oso baakanko ma manlo ma ni lɛpɔɔ ninle alɛ, lɛkpa ntookye osi diɛwa kayi ka mmle kafɔɔ batii kɔbɔmbɔ ditunu manlenkee lɛkpa nwu nkpo, diekye ɔsaabla lɛma lɛbla dikpile. ");
INSERT INTO snw_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Diekye otii lele nimbla sikpile yi, ankyidi lɛkpa nwu, nioso ánwa lɛkpa nwu nkpo nfũ, diekye ɔɔyɛkɛ alɛ nse ɛɛwa lɛkpa nwu nkpo nfũ yi, babadiki ɔsaabla nɔɔ kayi. ");
INSERT INTO snw_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Kafɔɔ otii wɔ nimbla ni lɛsaa di osuku kanya yi, anwa lɛkpa nwu nkpo nfũ alɛ, lɛkpa nwu nkpo kadiki nintuo alɛ nwaako, ambla asaa di Yaa dibiesaa kanya.” ");
INSERT INTO snw_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Di nle mmle sɛmaa, Yesu ku basaateketetɛ nɔɔ lasifi Yudea ntɛɛ nwu baalaawɛ ninfa obe owo aatookpeesa batii Yaa ntu. ");
INSERT INTO snw_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Di obe nwu nkpo kamɛ, Yohane kafɔɔ lawɛ di Aenon wɔ niatɛɛtɛɛ ni Salim aatookpeesa batii Yaa ntu, diekye ntu lawɛ ninfa diapɔ. Nioso batii kpinwu latɔɔkyɛ ɔkyɛ nɔɔ ninfa aatookpeesa ma Yaa ntu. ");
INSERT INTO snw_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Di obe nwu nkpo kamɛ yi, bayimufũ Yohane batɛ leeyo. ");
INSERT INTO snw_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Dii ninwii ɔlaa ɔnanfi labuo di Yohane basaateketetɛ bawo ku Yuda otii onwii ntɛɛ di suoto ofoto ɔsaabla suoto. ");
INSERT INTO snw_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Nkpo oso baakyɛ Yohane nfũ baalaakaalɛ nwɔ alɛ, “Saatuotɛ, foonyuma osuɔtɔ wɔ niawɛ ni di ɔkyɛ lɛfɔ, faadiki nwɔ faatuo wo ni di Yordan okle kakyɛ nyɔɔfa? Nnwɔɔ kafɔɔ nfɛ ookpeesa batii Yaa ntu, batii bamuu nfɛ kosifi ɔkyɛ nɔɔ!” ");
INSERT INTO snw_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ninfɛ di Yohane ladiki kanya alɛ, “Otii kuonwii dilabafuo lɛsalɛsaa kuninwii ɔwɛ, nse diele Yaa niɛtɔɔ. ");
INSERT INTO snw_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Aye bamu bionyuma bilɛ latɔkɔ ye nlɛ, ‘Diele ami ninle Kristo nwu nkpo, kafɔɔ ami yi, okyesee ko di Yaa lekyesee mi alɛ kale nwɔ katũ.’ ");
INSERT INTO snw_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ɔkafɔɔsa ole ninle ɔkafɔɔsɔfɔ. Kafɔɔ nse ɔkafɔɔsa siɛwo wɔ nin-yɛ ni di ɔlɔɔkɔ eenu ɔkafɔɔsa sɛlɔ yi, suoto n-yɔɔ nwɔ osie kanya. Nkpo okle kafɔɔ di amii, ntoonu nwɔ ni sɛlɔ, suoto lɛyɔɔ nii ntɔɔbla nimu nɛ. ");
INSERT INTO snw_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Nioso, dikpe nii nnwɔɔ ɛɛtaka katoo, amii dikpe nii lɛwa kasɔ. ");
INSERT INTO snw_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Otii wɔ niekye osi ɛɛwa ni lɛtaka katoo alenke bamuu. Otii wɔ kafɔɔ niekye ni kasɔ ka mmle suoto, kasɔ ka mmle otii ko ale, kasɔ ka mmle suoto asaa kafɔɔ suoto lete ankakatɛ. Otii wɔ niekye osi ɛɛwa ni nlenke asaa amuu. ");
INSERT INTO snw_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Oobuɛ lɛsaa le ɛɛnya ni ku nle eenu nii, kafɔɔ otii kuonwii diefũ nwɔ ɔlaa anu. ");
INSERT INTO snw_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Batii ba niefũ nwɔ ɔlaa beenu nii, kodiki mantuo klekle alɛ Yaa ɔlaa nte nkpo. ");
INSERT INTO snw_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Otii wɔ di Yaa lekyesee ni kodiki Yaa ɔlaa ambuɛ, diekye Yaa lɛyɔ Ninwuna nɔɔ eekpee nwɔ kaamɛ pɔ. ");
INSERT INTO snw_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Yaa mbɔmbɔ Obi nwu nkpo, ni ɛɛyɔ lɛsaa biala eekpe nwɔ di nnɛɛ kamɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","“Otii lele niefũ Obi nwu eenu, akpe nkpa be ninnaa ni kaloo. Otii lele kafɔɔ niesĩ Obi nwu atoko ɔkyɔɔ dilabawɛ nkpa, ni Yaa letokonanfi kafɔɔ matika nwɔ di suoto.” ");
INSERT INTO snw_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Di obe nwu nkpo kamɛ yi, Farisi batii lanu alɛ Yesu nfɛ kokpeesa batii Yaa ntu, basaateketetɛ nɔɔ kafɔɔ nfɛ latɔɔpɔ baatoolenkee Yohane bale. ");
INSERT INTO snw_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Nwaako baabuɛ nii, Yesu omu ditakpeesa otii kuonwii Yaa ntu, kafɔɔ basaateketetɛ nɔɔ niatookpeesa batii. ");
INSERT INTO snw_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Nioso obe wɔ di Yesu lanu ɔlaa wɔ baatoobuɛ nii, ninfɛ aadie di Yudea kasɔ suoto aakple aasifi Galilea nɛ. ");
INSERT INTO snw_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Di osuku nɔɔ nwu nkpo ɔkyɛ kamɛ, dikpe nii eefe di Samaria kasɔ suoto. ");
INSERT INTO snw_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ninfɛ di Yesu lalaadu Sikar wɔ ninle ni Samaria okpoo onwii kamɛ nɛ. Okpoo nwu lɛtɛɛtɛɛ kasɔ ka di ɔwa lɛma Yakob layɔ aata ni obi nɔɔ Yosef. ");
INSERT INTO snw_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ntu dibiɔ le di Yakob lakutu ni late ninfa. Obe wɔ di Yesu labadu ni ntu dibiɔ nwu nkpo nfa, ditoobuo nwɔ ni di osuku nwu nkpo ɔkyɛ kamɛ, aasiɛ ni di ɔlɔɔkɔ. Diabla fɛ kakũ lefosi abombo anyɔ kamɛ. ");
INSERT INTO snw_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Di obe nwu kamɛ Samaria ɔsanko onwii lawa alɛ ɔɔbadu ntu. Ninfɛ di Yesu latɔkɔ nwɔ alɛ, “Tɛɛ ntu nnyi.” ");
INSERT INTO snw_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Di obe nwu nkpo kamɛ, Yesu basaateketetɛ nɔɔ lafe okpoo alɛ bɔɔlaaya alesaa manwako. ");
INSERT INTO snw_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ninfɛ di ɔsanko nwu nkpo lakaalɛ nwɔ alɛ, “Be oso di afɔ Yuda otii fɔɔkaalɛ ami Samaria otii ntu?” Aakaalɛ nwɔ ɔlaa nwu nkpo diekye Yuda batii ku Samaria batii nimbla asaa anwii. ");
INSERT INTO snw_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ninfɛ di Yesu ladiki kanya alɛ, “Nse fɛ oye faye lɛsaa le di Yaa nta ni ku otii wɔ nikɔkaalɛ fɔ alɛ tɔɔ ntu anyi nii, nse bia afɔ nitɔbakaalɛ nwɔ, anta fɔ ntu be ninta ni nkpa.” ");
INSERT INTO snw_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ninfɛ di ɔsanko nwu nkpo labuɛ alɛ, “Ɔnɔɔfo, ntu didusaa nnaafɔ, dibiɔ le mmle kafɔɔ lekyofo, ni ɔfɛ fabawɛ ntu be ninta ni nkpa fankyeko? ");
INSERT INTO snw_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ɔwa loo Yakob niakutu dibiɔ le mmle aata wo, nnwɔɔ omu ku babi ku banankyue nɔɔ lanyi ntu di dibiɔ le mmle kamɛ. Obuɛ foobuɛ falɛ fɛɛtakakatoo falenke nwɔ ɛɛ, sɛɛ lɛ?” ");
INSERT INTO snw_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ninfɛ di Yesu ladiki kanya alɛ, “Otii lele nienyi ntu di dibiɔ le mmle kamɛ yi, otukɔnsɔ makple kunklee nwɔ. ");
INSERT INTO snw_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Kafɔɔ otii lele nienyi ntu be kamatɔɔ ni yi, otukɔnsɔ dilabasinklee otii nwu nkpo diidii. Ntu nwu nkpo kamatɔɔ ni makple ntu kataakɔ di kamɛ nɔɔ nintɔɔ nkpa ntu, nintɔɔ kafɔɔ nkpa be ninnaa ni kaloo.” ");
INSERT INTO snw_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ninfɛ di ɔsanko nwu latɔkɔ Yesu alɛ, “Ɔnɔɔfo, ni tɛɛ ntu nwu nkpo nnwo, mmle okle di otukɔnsɔ dilabasinklee mi ni diidii. Ni namasinwa nfũ mmle kafɔɔ nlɛ kamadu ntu.” ");
INSERT INTO snw_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Nfa nfɛ di Yesu latɔkɔ nwɔ alɛ, “Tɔɔkyɛ faalaalɛɛ ɔsa lɛfɔ biɛwa.” ");
INSERT INTO snw_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ninfɛ di ɔsanko nwu latɔkɔ Yesu alɛ, “Nnaa kɔsa.” Ni di Yesu latɔkɔ nwɔ alɛ, “Kute nkpo nse feebuɛ falɛ fanaa kɔsa. ");
INSERT INTO snw_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Nwaako feebuɛ. Diekye fatɔɔyɔ basa banɔɔ diɛbafe. Bia minko nwɔ ninsi ni nunua wɔ mmle aale fɔ kɔsa kumu kumu.” ");
INSERT INTO snw_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ninfɛ di ɔsanko nwu ladiki kanya alɛ, “Ɔnɔɔfo, ntɔɔnya nlɛ Yaa ɔlaa buɛtɛtɛ fale! ");
INSERT INTO snw_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Awo Samaria batii yi, buye bulɛ kobokote ko mmle suoto di bawa loo latoosumu Yaa. Kafɔɔ aye Yuda batii biobuɛ bilɛ Yerusalem lete dikpe nii, beesumu Yaa.” ");
INSERT INTO snw_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ninfɛ di Yesu latɔkɔ nwɔ alɛ, “Ɔsanko, fũ ɔlaa wɔ mmle kɔtɔkɔ fɔ ni fanu. Obe kɔwa batii bamuu dilabasinwakosa asi kasɔ bata Yaa di kobokote ko mmle suoto, ee Yerusalem. ");
INSERT INTO snw_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Aye Samaria batii yi, bieye lɛsaa le biosumu nii. Kafɔɔ awo Yuda batii yi, buye otii wɔ buosumu nii. Diekye, didiki yi, awo Yuda batii kamɛ diekye. ");
INSERT INTO snw_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Kafɔɔ obe kɔwa, obe nwu nkpo kafɔɔ ntoowo di batii ba ninsumu ni Yaa di osuku kanya, kamasumu Teete nwu di Yaa Ninwuna kamɛ ku nwaako ole kamɛ. Diekye batii ba mmle okle di Yaa komiɛ alɛ batansɔɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Obe wɔ di Yaa nle ni Ninwuna oso, dikpe ni batii ba nikosumu nwɔ nii, basumu nwɔ di Ninwuna kamɛ ku nwaako ole kamɛ.” ");
INSERT INTO snw_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ninfɛ di ɔsanko nwu latɔkɔ Yesu alɛ, “N-ye nlɛ otii wɔ bɛɛpɛ ni ɔfɔɔ manlɛɛ ni Kristo kamawa. Nse ɛɛwa yi, abatɔkɔ wo lɛsaa biala.” ");
INSERT INTO snw_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ninfɛ di Yesu ladiki kanya alɛ, “Ami wɔ mmle nikɔkakatɛko fɔ ni ninfũ mmle yi, ami ninle otii nwu nkpo nɛ.” ");
INSERT INTO snw_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Di obe nwu nkpo kamɛ yi, Yesu basaateketetɛ nɔɔ lakple, nioso diabla ɔkpɛ alɛ ɔɔkakatɛko ɔsanko nwu nkpo. Kafɔɔ kuonwii lɛma ditafuo ɔsanko nwu ɔkaalɛ alɛ, “Be foomiɛ” ee bakaalɛ Yesu alɛ, “Be oso fɔɔkakatɛ ko nwɔ?” ");
INSERT INTO snw_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ɔsanko nwu ladiɛ ditubukii nɔɔ nwu nkpo ninfa, aakple aasifi okpoo aalaatɔkɔ batii alɛ, ");
INSERT INTO snw_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Biwa biɛbanyu otii wɔ niɛtɔkɔ mi ni lɛsaa biala ntooyibla lɛnya ni! Sɛɛ nnwɔɔ ninle Kristo nwu nkpo?” ");
INSERT INTO snw_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Nkpo oso batii nwu nkpo ladie di okpoo nwu nkpo kamɛ baakyɛ alɛ bɔɔlaanyu Yesu. ");
INSERT INTO snw_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Di obe nwu nkpo kamɛ kafɔɔ, Yesu basaateketetɛ latootikiti nwɔ lekoto alɛ, “Saatuotɛ, bale alesaa!” ");
INSERT INTO snw_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Kafɔɔ Yesu latɔkɔ ma alɛ, “Nkpe alesaa male ni, minanye nii.” ");
INSERT INTO snw_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Nkpo oso basaateketetɛ nɔɔ lakye kasɔ baatɔɔkaalɛ bawo alɛ, “Sɛɛ otii owo ntɔɔwako nwɔ alesaa awo eele?” ");
INSERT INTO snw_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesu latɔkɔ ma alɛ, “Alesaa nii ninle alɛ kabla otii wɔ niekpee mi ni kɔtɔ dibiesaa, alɛ kaloo ɔkpɛ wɔ eekpee mi alɛ mabla ni ɔbla. ");
INSERT INTO snw_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Aye nimbuɛ bilɛ, ‘Awɛntɛ ana kamaa, se ofiɛlɛbee ntoowo.’ Kafɔɔ kɔtɔkɔ ye nlɛ, bitakatɛsa anu bienyu kofe nwu nkpo, alesaa nwu nkpo ntɔɔsɛɛ, dikpe nii nfɛ manfiɛlɛ nya nii. ");
INSERT INTO snw_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Otii wɔ nikofiɛlɛ ni yi, nnwɔɔ di Yaa nta koto, ansiisa alesaa nwu nkpo kafɔɔ anta nkpa be ninnaa ni kaloo nɛ. Nkpo oso otii wɔ nimpɛ ni ku otii wɔ ninfiɛlɛ nii yi, akyuu lɛma anyɔ manya suoto lɛyɔɔ osie kanya. ");
INSERT INTO snw_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Nkpo oso ɔlaa nwu nkpo mambuɛ alɛ, ‘Otii onwii mpɛ, ɔbamba kafɔɔ nfiɛlɛ ni yi, kute nkpo.’ ");
INSERT INTO snw_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ami yi, lekpee ye nlɛ, biakyɛ minaafiɛlɛ alesaa di nfũ minankpɛ dibuo ye nii. Batii bamba lɛbla ɔkpɛ ninfa diebuo ma. Kafɔɔ aye yi, biɔwɛ kowee di ɔkpɛ lɛma ɔbla kamɛ.” ");
INSERT INTO snw_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Di obe nwu nkpo kamɛ yi, Samaria batii kpinwu niakye ni okpoo nwu nkpo lafũ Yesu baanu. Diekye ɔsanko nwu nkpo latɔkɔ ma alɛ, “Ɛɛtɔkɔ mi lɛsaa biala ntooyibla lɛnya nii.” ");
INSERT INTO snw_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Nioso obe wɔ di Samaria batii nwu nkpo lawa ni Yesu nfũ yi, baatikiti nwɔ lekoto alɛ asiɛ ma diɔkyɛ, nioso aasiɛ di ɔkyɛ lɛma ayi anyɔ. ");
INSERT INTO snw_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Nioso batii bamba kpinwu lakple baafũ Yesu baanu, ta sɛlaa nɔɔ se aabuɛ ni oso. ");
INSERT INTO snw_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ni baatɔkɔ ɔsanko nwu alɛ, “Butoofũ buoonu nfɛ, diele di sɛlaa se fɛɛtɔkɔ wo ni oso, diekye awo bamu loo butoonu nwɔ ɔlaa, butootofo kafɔɔ bulɛ, nwaako nnwɔɔ ninle kayi ka mmle dikitɛ.” ");
INSERT INTO snw_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Di Yesu lale ni ayi anyɔ ninfa, ni aadie aasifi Galilea kasɔ suoto nɛ. ");
INSERT INTO snw_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Nnwɔɔ omu nɔɔ aabuɛ alɛ, “Mámbu Yaa ɔlaa buɛtɛtɛ kuonwii di nnwɔɔ omu nɔɔ okpoo.” ");
INSERT INTO snw_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Kafɔɔ obe wɔ di Yesu labuo ni Galilea, batii nwu ninfa lafũ nwɔ osie kanya, diekye obe wɔ baakyɛ ni Okpi Diisi Ofe Dii kalekɔ di Yerusalem yi, baanya asaa ya amuu aabla ni ninfa. ");
INSERT INTO snw_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ninfɛ di Yesu lakple aasifi Kana di Galilea kasɔ, di lɛba le ayɔ ntu aabla ni nta nɛ. Abaa ɔnɔɔfotii onwii lawɛ ninfa di Kapernaum di obi nɔɔ suɔtɔbi latoofiɛ nii. ");
INSERT INTO snw_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Obe wɔ di osuɔtɔ nwu nkpo lanu alɛ Yesu ntookple di Yudea ɛɛwa ni Galilea, ni aakyɛ ɔkyɛ nɔɔ aalaatikiti nwɔ lekoto alɛ awa abayɔɔsa obi nɔɔ nwu nkpo nikoloo ni okpi ofiɛ. ");
INSERT INTO snw_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ninfɛ di Yesu latɔkɔ nwɔ alɛ, “Nse biɛ́nya sɛkpɛ se niɛbla ni ɔkpɛ ku atuosaa mínfũ bianu.” ");
INSERT INTO snw_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ninfɛ di ɔnɔɔfotii nwu latɔkɔ nwɔ alɛ, “Saate, lekoto wa wla fabanyu obi nii nwu mmle okle anamakpi ni.” ");
INSERT INTO snw_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ninfɛ di Yesu latɔkɔ nwɔ alɛ, “Tɔɔkyɛ, obi lɛfɔ nwu nkpo mawɛ nkpa.” Ni di ɔnɔɔfotii nwu nkpo lafũ Yesu ɔlaa wɔ aatɔkɔ nwɔ ni aanu, ni aasifi nɛ. ");
INSERT INTO snw_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Obe wɔ nfɛ akyɛ di osuku oosifi ni leyo, ni baakpɛntɛ nɔɔ lawa baabakyakako nwɔ baatɔkɔ nwɔ alɛ obi lɛfɔ nwu nkpo ntɔɔtaka di ofiɛ. ");
INSERT INTO snw_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ninfɛ aakaalɛ ma alɛ ɔmɛmbe kamɛ aataka di ofiɛ? Ninfɛ baatɔkɔ nwɔ alɛ, “Kɔsa kakũ olomu onwii kamɛ di lɛwɔɔfɔ ofiɛ nwu nkpo layɔɔ nwɔ.” ");
INSERT INTO snw_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ninfɛ di obisɔ nwu nkpo ote lanyuma alɛ, di obe nwu nkpo kamɛ tutuutu di Yesu latɔkɔ nwɔ alɛ, “Obi lɛfɔ nwu nkpo mawɛ nkpa.” Nkpo oso ɔnɔɔfotii wɔ mmle ku leyo nɔɔ kamɛ batii bamuu lafũ Yesu baanu. ");
INSERT INTO snw_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Nle mmle niale ɔkpɛ wɔ niabla ni ɔkpɛ nyɔɔfa di Yesu labla ni di obe wɔ aakye Yudea aawa ni Galilea kasɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Nle mmle sɛmaa, Yesu lakple aakyɛ Yerusalem di obe wɔ di Yuda batii kole ni dii lɛma ninwii. ");
INSERT INTO snw_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Di bafoso kayoko ɔlɔɔkɔ di Yerusalem, lɛpanta ninwii nte manlɛɛ ni Betesda di Hebri sele kamɛ. Bɛɛpɛ akpanta anɔɔ beekyisa lɛpanta nwu nkpo. ");
INSERT INTO snw_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Bafiɛtɛ ɔlambu kplɛ late di akpanta nwu nkpo kalɔ baale ni banumbiɛtɛ ku mba di nkpaa lɛma lekpi nii ku mba niekpi ni kakyɛkakyɛ. Baate baasoko ntu nwu nkpo ɔbakaa. ");
INSERT INTO snw_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","(Diekye Yaa tɔkyɛntɛ onwii nwa amabakaa ntu nwu nkpo di obe obe. Fiɛtɛ lele niɛkasa obuo di ntu nwu nkpo kamɛ di obe wɔ di Yaa tɔkyɛntɛ lɛbabakaa mi nii, ofiɛ lele kule, kunyɔɔ fiɛtɛ nwu nkpo.) ");
INSERT INTO snw_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Osuɔtɔ onwii lawɛ ninfa aatoofiɛ ni alɛɛ afosi atiɛ alɛɛ anɛ amu. ");
INSERT INTO snw_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Obe wɔ di Yesu lanyɔɔ nii, aatofo alɛ osuɔtɔ wɔ mmle ntoote diofiɛ diɛklɛ. Nioso aakaalɛ nwɔ alɛ, “Foomiɛ falɛ ofiɛ lɛfɔ nwu nkpo kuyɔɔ fɔ?” ");
INSERT INTO snw_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ninfɛ di fiɛtɛ nwu nkpo ladiki kanya alɛ, “Ɔnɔɔfo, otii kuonwii nnaa mi abakyakaakoe an-yɔ mi ankpee ni di lɛpanta nwu nkpo kamɛ nse bɛɛbakaa ntu nwu. Nse kɔkpɛ nlɛ kanaabuo yi, otii bamba nle mi katũ, anka mi ɔlaabuo.” ");
INSERT INTO snw_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ninfɛ di Yesu latɔkɔ nwɔ alɛ, “Taka! Faayɔ ɔkla lɛfɔ, faakyɛ.” ");
INSERT INTO snw_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Nfanwu ofiɛ layɔɔ osuɔtɔ nwu nkpo, aayɔ ɔkla nɔɔ, aakyako ɔkyɛ. Dii le di ɔlaa wɔ mmle lawa nii, Lɛnyɛɛtɛyi diale. ");
INSERT INTO snw_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Nkpo oso Yuda batii banɔɔfotii latɔkɔ osuɔtɔ nwu di Yesu layɔɔsa ni ofiɛ alɛ, “Miɛ Lɛnyɛɛtɛyi dile, kufiofa loo diɛta osuku alɛ faaklee ɔkla lɛfɔ.” ");
INSERT INTO snw_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ninfɛ di osuɔtɔ nwu nkpo ladiki kanya alɛ, “Osuɔtɔ wɔ niɛyɔɔsɛɛ ni ofiɛ niɛtɔkɔ mi alɛ n-yɔ ɔkla nii ninkyɛ.” ");
INSERT INTO snw_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ninfɛ baakaalɛ nwɔ alɛ, “Owe ninle otii nwu niɛtɔkɔfɔ alɛ, ‘Yɔ ɔkla lɛfɔ faakyɛ ni’?” ");
INSERT INTO snw_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Kafɔɔ osuɔtɔ nwu nkpo baayɔɔsa ni ofiɛ dieye otii wɔ di Yesu nle nii. Diekye batii dikudi niawɛ ninfa nkpo, Yesu kafɔɔ ntooyu ma kaamɛ. ");
INSERT INTO snw_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Di nni nkpo sɛmaa, Yesu lanya osuɔtɔ nwu nkpo di Yaa Olekatakɔ, ni aatɔkɔ nwɔ alɛ, “Nyu lo! Nunua fatoosie nii, tansimbla okpile. Nse diele nkpo, ni lɛsaa le ninlenke ni nle mmle nikamabla fɔ.” ");
INSERT INTO snw_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ninfɛ di osuɔtɔ nwu nkpo lasifi aalaatɔkɔ Yuda batii banɔɔfotii nwu nkpo alɛ, Yesu ninle otii nwu nkpo niayɔɔsa nwɔ ni ofiɛ. ");
INSERT INTO snw_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Nkpo oso Yuda batii nwu nkpo lakyako Yesu otikanko, diekye Lɛnyɛɛtɛyi suoto aayɔɔsa nwɔ ofiɛ. ");
INSERT INTO snw_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Kafɔɔ Yesu latɔkɔ ma alɛ, “Obe lele Teemi kɔbla ɔkpɛ, nkpo oso dikpe ni amii lɛbla.” ");
INSERT INTO snw_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ɔlaa wɔ mmle aabuɛ ni lakple diata alɛ Yuda batii banɔɔfotii lamiɛ osie kanya alɛ boolo nwɔ. Diele alɛ aataalɛ ni Lɛnyɛɛtɛyi kufiofa nwu nkpo lete oso, kafɔɔ aabuɛ alɛ Yaa ninle nwɔ Kote. Ni nle mmle kotuo alɛ, oonyu suoto nɔɔ alɛ manko Yaa bakyɛkyɛ. ");
INSERT INTO snw_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Nioso Yesu latɔkɔ ma alɛ, “Nwaako kɔtɔkɔ ye nlɛ, Yaa Obi nwu dilaafuo lɛsalɛsaa ɔbla di nnwɔɔ omu nɔɔ kamɛ. Kafɔɔ lɛsaa le ɛɛnya Ote kɔbla nii, nni ambla nɛ. ");
INSERT INTO snw_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Diekye Ote nwu mbɔmbɔ Obi nwu. Nioso lɛsaa lele di Ote nwu omu kɔbla, aantuo Obi nwu nimuu. Abatuo nwɔ bia asaa kplɛ ya ninlenke ni n-ya mmle alɛ bamuu lee dibabla ye yaaa. ");
INSERT INTO snw_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Fɛ mmle okle di Ote nwu nsɛnkɛsa bakpi anta ma ni nkpa yi, nkpo okle kafɔɔ di Obi nwu nta mba eediki ni nkpa nɛ. ");
INSERT INTO snw_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ote nwu nkpo omu nínkanko otii kuonwii. Kafɔɔ ɛɛyɔ lɛkanko biala eekpee di Obi nwu nkpo nnɛɛ kamɛ niimu ");
INSERT INTO snw_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","alɛ, batii bamuu kabu Obi nwu nkpo, fɛ mmle okle boobu ni Ote. Otii lele ninambu Obi nwu nkpo yi, ni aambu Ote wɔ kafɔɔ niekyesee nwɔ nii. ");
INSERT INTO snw_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Nwaako kɔtɔkɔ ye nlɛ, otii lele nienu mi ɔlaa, eefũ otii wɔ niekpee mi ni kɔtɔ eenu yi, akpe nkpa be ninnaa ni kaloo. Blabakanko nwɔ, kafɔɔ atoofe kuukpi kamɛ, eebuo nkpa fɔle nwu kamɛ kofokofoko. ");
INSERT INTO snw_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nwaako kɔtɔkɔ ye, obe kɔwa, obe nwu nkpo kafɔɔ ntɔɔwa kofokofoko di bakpi manu ni Yaa Obi nwu nkpo sɛlɔ, mba nimanu nii, mataka mansiɛ nkpa. ");
INSERT INTO snw_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Fɛ mmle okle di Ote nwu nkpo omu ninle ni nkpa kataakɔ yi, nkpo okle kafɔɔ ɛɛbla Obi nɔɔ nwu alɛ aale nkpa kataakɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ɛɛtɔɔ osuku alɛ aakanko, diekye Otii Obi nwu ale. ");
INSERT INTO snw_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Bitanta nle mmle labla ye ɔkpɛ. Diekye obe kɔwa di bakpi bamuu manu nwɔ ni sɛlɔ, ");
INSERT INTO snw_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","mandie di sɛkya lɛma kamɛ. Mba niɛbla ni dibiene mataka mansiɛ nkpa, mba kafɔɔ niɛbla ni sikpile babataka manfũ lɛpɔɔ olo. ");
INSERT INTO snw_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Ninfuo lɛsalɛsaa kuninwii ɔbla di ami omu osie nii kamɛ. Nkanko di mmle okle lete di Yaa lɛtɔkɔ mi ni kanya. Nkpo oso lɛkanko nii lewo. Diekye nimmbla nle ninlɛ mi nii, kafɔɔ nle ninlɛ ni otii wɔ niekpee mi ni kɔtɔ. ");
INSERT INTO snw_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Nse lediki suoto nii kanya yi, ni suoto nii kanya odiki nwu nkpo diewo nimu. ");
INSERT INTO snw_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Kafɔɔ otii onwii nkpe oodiki mi ni suoto kanya, n-ye kafɔɔ nlɛ, kanya ka oodiki ni di suoto nii nte nkpo. ");
INSERT INTO snw_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Biekpee batii bɛɛkyɛ Yohane nfũ bɛɛlaakaalɛ nwɔ sɛlaa beekyeko suoto nii, ɛɛtɔkɔ ma kafɔɔ ɔlaa nwɔ ninte ni nkpo. ");
INSERT INTO snw_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Diele kafɔɔ alɛ komiɛ otii kaayi ka mmle alɛ aadiki mi kanya. Lebuɛ ɔlaa wɔ mmle alɛ biawɛ didiki. ");
INSERT INTO snw_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohane late fɛ kandiɛ baasɔ aayila aatɔɔkpa nii, biatuna bilɛ biɔnya ni suoto lɛyɔɔ di lɛkpa nɔɔ nwu nkpo kamɛ di obe kakui kamɛ. ");
INSERT INTO snw_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Kafɔɔ ami yi, suoto kanya ka ninkpe mi kodiki ni lɛtaka katoo dilenke nka di Yohane ladiki nii. Diekye sɛkpɛ se di Teemi lekpee mi ni di nnɛɛ kamɛ alɛ kabla nloo ni kɔbla ni kotuo alɛ, nnwɔɔ niekpee mi kɔtɔ. ");
INSERT INTO snw_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Teemi wɔ kafɔɔ niekpee mi ni kɔtɔ, nikodiki mi suoto kanya. Diidii biinu nwɔ sɛlɔ ee binyɔɔ kafɔɔ anu ku anu. ");
INSERT INTO snw_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Bieemufũ ɔlaa nɔɔ nwu nkpo kafɔɔ bikpee di situ lee kamɛ. Diekye bieefũ otii wɔ eekpee ye ni binu. ");
INSERT INTO snw_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Biotekete Kɔkpana Klekle Akũ kamɛ sɛlaa obe lele ku disibu bilɛ bibawɛ nkpa be ninnaa ni kaloo. Kɔkpana nwu nkpo kafɔɔ kodiki mi suoto kanya. ");
INSERT INTO snw_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Kafɔɔ biesĩ bilɛ bilɔɔwa ɔkyɛ nii alɛ kata ye nkpa. ");
INSERT INTO snw_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Noomiɛ batii kɔlɛɛ kaasɔ ka mmle suoto, ");
INSERT INTO snw_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","diekye n-ye batii ba okle bile nii, n-ye kafɔɔ nlɛ binaa lɛbɔmbɔ biɛta Yaa di situ lee kamɛ. ");
INSERT INTO snw_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Lɛwa di Teemi leyooto kamɛ kafɔɔ biefũ mi. Kafɔɔ nse otii bamba lɛwa di leyooto nɔɔ nimu kamɛ yi, bibafukuti nnɛɛ lee minfũ nwɔ. ");
INSERT INTO snw_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Lɛ dibabla fiɛ bibafuo mi ofũ onu, di obe wɔ biomiɛ kɔlɛɛ minkyeko ni aye bamu bawo nfũ, minoomiɛ kɔlɛɛ bikyeko ni nwɔ lete ninle ni Yaa nfũ? ");
INSERT INTO snw_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Bitanyu bilɛ ami ninle otii wɔ nimalo ye lɛpɔɔ nta ni Teemi. Kafɔɔ Mose wɔ kufiofa bietika ni anu nimalo ye lɛpɔɔ! ");
INSERT INTO snw_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Nse nwaako biefũ Mose bienu yi, nse bitabafũ mi kafɔɔ minnu, diekye ami suoto di Mose nwu nkpo lɛkpana asaa eekyeko. ");
INSERT INTO snw_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Kafɔɔ di obe wɔ minanfũ lɛsaa le ɛɛkpana ni binu nii, lɛ dibabla fiɛ bibafũ sɛlaa se kobuɛ ni minnu?” ");
INSERT INTO snw_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Di nni nkpo sɛmaa, Yesu lataalɛ lekpo le manlɛɛ ni Galilea lekpo, obe owo kafɔɔ manlɛɛ ni Tiberia lekpo aasifi kakyɛ nyɔɔfa. ");
INSERT INTO snw_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Batii kpinwu latikanko nwɔ diekye baanya sɛkpɛ kplɛ se aabla aayɔɔsa ni mba niatoofiɛ ni sifiɛ. ");
INSERT INTO snw_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ninfɛ di Yesu ku basaateketetɛ nɔɔ layie baasifi kobokote osi baalaasiɛ kaasɔ ninfa. ");
INSERT INTO snw_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Di obe nwu nkpo kamɛ Yuda batii Okpi Diisi Ofe Dii ole bee ntɔɔtɛɛtɛɛ. ");
INSERT INTO snw_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Obe wɔ di Yesu latakatɛsa anu aanyu aanya alɛ batii dikudi kpinwu kɔwa ni ɔkyɛ nɔɔ yi, ni aakaalɛ Filipo alɛ, “Ɔfɛ bubawɛ alesaa munya munta batii ba mmle nwu nkpo manle?” ");
INSERT INTO snw_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yesu labuɛ ɔlaa wɔ mmle alɛ ɔɔyɔ ansɔ Filipo annyu, diekye nnwɔɔ omu aye lɛsaa le ɔwa ni ɔbabla. ");
INSERT INTO snw_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ninfɛ di Filipo ladiki kanya alɛ, “Nse buɔyɔ bia batii alafa anyɔ dii kɔkpɛnto buɔɔya alesaa buɔta batii ba mmle nkpo bamuu yi, dilabawo ma bale bia kafui kafui!” ");
INSERT INTO snw_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ninfɛ di Yesu tikankotɛ nɔɔ onwii kaamɛ lɛma ninle ni Andrea, Simon Petro obilɛma, labuɛ alɛ, ");
INSERT INTO snw_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Okosopo onwii nsi ninfũ akle ni abloblo kudi anɔɔ ku kɔkpaku kɔnyɔ. Kafɔɔ be di nle mmle mabla banankpantii ba mmle nwu nkpo?” ");
INSERT INTO snw_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ninfɛ di Yesu latɔkɔ basaateketetɛ nɔɔ alɛ, “Bita batii nwu nkpo bamuu basiɛ kaasɔ.” Sɛfa kɔɔnle lɛkɛtɛɛ kpinwu lawɛ ninfa. Batii nwu nkpo bamuu lasiɛ kaasɔ. Basuɔtɔ ba niawɛ ni kaamɛ lɛma labla fɛ batii nkpe nnɔɔ. ");
INSERT INTO snw_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ninfɛ di Yesu lafũ bloblo nwu nkpo, ni aapɛ Yaa sɛfa, ni aasɛ aata batii nwu nkpo bamuu niasiɛ ni ninfa nɛ. Nkpo okle kafɔɔ aasɛ kɔkpaku nwu nkpo aata bamuu lɛma, obiala lawɛ aawee fɛ mmle okle oomiɛ nii. ");
INSERT INTO snw_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Di obe wɔ bamuu lɛma batoole beemiɛ nii, Yesu latɔkɔ basaateketetɛ nɔɔ alɛ, “Bisiisa kɔkyɛɛkɔkyɛɛ nwu nkpo niebu ni alɛ kukanwii dilalalaa.” ");
INSERT INTO snw_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Nkpo oso baasiisa bloblo akudi anɔɔ nwu nkpo baatii nwu lale ni kɔkyɛɛkɔkyɛɛ nɔɔ kuayii lefosi nkyikyɛ nnyɔ pɔ. ");
INSERT INTO snw_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Obe wɔ baatii nwu nkpo lanya ɔkpɛ wɔ mmle niabla ni ɔkpɛ di Yesu labla nii, baabuɛ alɛ, “Nwaako, nnya nwɔ mmle ninle Yaa Ɔlaa buɛtɛtɛ wɔ nikɔwa ni kayi ka mmle nɛ.” ");
INSERT INTO snw_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesu latofo alɛ boomiɛ alɛ bamufũ nwɔ osie kanya bayɔ nwɔ base ɔka. Nkpo oso aadie ma kaamɛ lete nɔɔ aakple aasifi abokote suoto. ");
INSERT INTO snw_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Obe wɔ kɔɔtɔɔfɔ lawo nii, Yesu basaateketetɛ nɔɔ lasoo baakyɛ lekpo kotoko. ");
INSERT INTO snw_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ninfɛ baayie baabuo di oklo kamɛ, baataalɛ baakple baakyɔɔ anu Kapernaum nɛ. Kale laloo, kafɔɔ Yesu diikple awa ɔkyɛ lɛma. ");
INSERT INTO snw_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Di obe nwu nkpo kamɛ, kofɛɛfɔ siene kunwii lakyako ɔfɛ, lekpo ntu nwu nkpo kafɔɔ lakyako ɔkpɛ osie kanya. ");
INSERT INTO snw_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Di obe nwu kamɛ, basaateketetɛ nwu ntɔɔwa oklo di ntu nwu osi bɛɛkyɛ fɛ akɔ atiɛ diɔkyɛ ni di lɛɛnafa kamɛ, ni baanya Yesu nkyɛ di ntu osi ɔɔwa oklo nwu nfũ nɛ. Nni nkpo oso, ɔfɔɔ lasifi ma! ");
INSERT INTO snw_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ninfɛ di Yesu latɔkɔ ma alɛ, “Bitanyɛkɛ! Ami dile.” ");
INSERT INTO snw_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ni di otu lɛma late nɛ. Ni baakpaa Yesu baakpee di oklo kamɛ nɛ. Nfanwu, ni baadu nfũ boofe ni nɛ. ");
INSERT INTO snw_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Obe wɔ kaale lasɛ nii, batii ba niasiɛ ni di lekpo nwu kakyɛ nyɔɔfa, baatofo alɛ oklo onwii niayila di lekpo nwu kotoko. Baatofo kafɔɔ alɛ Yesu ditasiɛ di nwu nkpo kaamɛ aakyakaa ku basaateketetɛ nɔɔ fiɛ baayefe osuku. Diekye basaateketetɛ nɔɔ lete niabuo nwu kaamɛ baasifi. ");
INSERT INTO snw_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Di obe nwu kamɛ, seklo bamba se niakye ni Tiberia okpoo lawa siabayila di lekpo kotoko, di lɛba le niɛtɛɛtɛɛ ni nfũ baatii nwu nkpo lale ni bloblo di obe wɔ di Saate lapɛ ni Yaa sɛfa. ");
INSERT INTO snw_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Nkpo oso, obe wɔ di batii nwu nkpo lanya alɛ Yesu ee basaateketetɛ nɔɔ nnaa ni ninfa oso, baabuo di seklo nwu nkpo kamɛ baasifi Kapernaum baalaatoowolaa nwɔ. ");
INSERT INTO snw_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Obe wɔ baatii nwu lanya ni Yesu di lekpo nwu nkpo kakyɛ nyɔɔfa, ni baakaalɛ nwɔ alɛ, “Saatuotɛ, ɔmɛmbe fɛɛwa nfũ?” ");
INSERT INTO snw_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ninfɛ di Yesu ladiki kanya alɛ, “Nwaako kɔtɔkɔ ye nlɛ, bloblo wɔ lata ye biale biamiɛ ni oso biowolaa mi. Diele sɛkpɛ se niɛbla ni ɔkpɛ bianya labla ni kasɔ bienu ni oso. ");
INSERT INTO snw_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Bitankpɛ biata alesaa ya nimalalaa nii, kafɔɔ bikpɛ bita alesaa ya ninkpe ɛɛta ni nkpa be ninnaa ni kaloo. Nnya ninle alesaa ya di Otii Obi nwu kamata ye ni nɛ. Diekye nnwɔɔ ninle otii wɔ di Yaa Ote lese lɛnɛɛ eediki ni nɛ.” ");
INSERT INTO snw_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Nioso batii nwu lakaalɛ Yesu alɛ, “Ni be ninle lɛsaa le buabla ni diatuo alɛ buɔbla ni Yaa dibiesaa?” ");
INSERT INTO snw_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ninfɛ di Yesu latɔkɔ ma alɛ, “Lɛsaa le di Yaa komiɛ alɛ bibla ni ninle alɛ, biafũ otii wɔ eekyesee ni minnu.” ");
INSERT INTO snw_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ninfɛ baakple baakaalɛ nwɔ alɛ, “Be ninle ɔkpɛ wɔ niɛbla ni ɔkpɛ fababla fantuo alɛ buafũ fɔ munnu ni? Nwu ninle ɔmɛnle? ");
INSERT INTO snw_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Waawa loo anɛ lale alesaa ya manlɛɛ ni mana di ɔfaafuu kamɛ, fɛ mmle okle di Kɔkpana Klekle Kukũ lebuɛ ni alɛ, ‘Aata ma alesaa ya niekye ni Osi baale.’ ” ");
INSERT INTO snw_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ninfɛ di Yesu latɔkɔ ma alɛ, “Nwaako kɔtɔkɔ ye nlɛ, diele Mose niata ye alesaa ya niekye ni osi biale. Kafɔɔ Teemi ninta ye alesaa amuamu ya niekye ni osi. ");
INSERT INTO snw_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Diekye alesaa ya di Yaa lɛta ni ninle otii wɔ niekye osi ɛɛwa ni, ɔɔta ni batii kaayi nkpa.” ");
INSERT INTO snw_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Nkpo oso baatɔkɔ nwɔ alɛ, “Saate, ta wo alesaa ya mmle nwu nkpo obe lele.” ");
INSERT INTO snw_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ninfɛ di Yesu latɔkɔ ma alɛ, “Ami ninle alesaa nwu nkpo ninkpe ni nkpa nɛ. Otii lele niɛwa ɔkyɛ nii, diidii kɔka dilabaklee nwɔ. Otii lele kafɔɔ niefũ mi eenu, diidii otukɔnsɔ dilabaklee nwɔ. ");
INSERT INTO snw_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Kɔtɔkɔ ye nlɛ, bitɔɔnyɛɛ, kafɔɔ biloofũ mi binu. ");
INSERT INTO snw_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Otii lele di Teemi lɛyɔ ɛɛtɛɛ kamawa ɔkyɛ nii. Olele kafɔɔ niɛwa ɔkyɛ nii namasĩ nwɔ diidii. ");
INSERT INTO snw_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Diekye diele okye lekye osi lewa nlɛ kɔbabla ami omu dibiesaa. Kafɔɔ ɔwa lɛwa nlɛ kɔbabla otii wɔ niekpee mi ni kɔtɔ dibiesaa. ");
INSERT INTO snw_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Otii wɔ kafɔɔ niekpee mi ni kɔtɔ dibiesaa dile alɛ, batii ba bamuu ɛɛyɔ ɛɛtɛɛ nii, kuonwii lɛma dilaayu, kafɔɔ alɛ kasɛnkɛsa bamuu lɛma mansiɛ nkpa di dii yɛntɛle nwu nkpo suoto. ");
INSERT INTO snw_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Diekye lɛsaa le di Teemi komiɛ ni ninle alɛ batii ba bamuu niɛnya ni Obi nwu, beefũ kafɔɔ beenu nii kawɛ nkpa be ninnaa ni kaloo. Ni masɛnkɛsa ma mansiɛ nkpa di dii yɛntɛle nwu nkpo suoto.” ");
INSERT INTO snw_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Nfa nfɛ di Yuda batii nwu lakye kasɔ baatoonwununuu nwɔ di suoto nɛ, diekye aabuɛ alɛ, “Ami ninle alesaa ya niakye osi lawa ni nɛ.” ");
INSERT INTO snw_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Nkpo oso baakaalɛ alɛ, “Diele Yesu wɔ mmle ninle Yosef obi nwu nkpo nɛ, sɛɛ lɛ? Buye nwɔ ote ku ɔya de! Lɛ nfɛ diɛwa fiɛ oobuɛ alɛ nnwɔɔ niekye osi ɛɛwa?” ");
INSERT INTO snw_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ninfɛ di Yesu latɔkɔ ma alɛ, “Bidiɛ ɔkakatɛ di kamɛ lee. ");
INSERT INTO snw_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Otii kuonwii dilabafuo ɔkyɛ nii ɔwa diediki Teemi wɔ niekpee mi ni kɔtɔ niɛnanfi nwɔ ɛɛwako ɔkyɛ nii. Alɛ ami kasɛnkɛsa nwɔ ansiɛ nkpa di dii yɛntɛle nwu nkpo suoto. ");
INSERT INTO snw_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Yaa ɔlaa babuɛtɛtɛ onwii lɛkpana alɛ, ‘Yaa omu nimatuo batii bamuu asaa.’ Nkpo oso, otii lele niɛkyɔɔ Ote nwu nkpo atoko, eetekete asaa eekyeko ɔkyɛ nɔɔ, anwa ɔkyɛ nii. ");
INSERT INTO snw_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Nle mmle dilootuo alɛ otii biala ntɔɔnya Ote nwu nkpo. Kafɔɔ otii wɔ niekye ni Yaa nfũ ninle otii wɔ lete nintɔɔnya ni Ote nwu. ");
INSERT INTO snw_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nwaako kɔtɔkɔ ye nlɛ otii wɔ niefũ eenu nii, nkpe nkpa be ninnaa ni kaloo. ");
INSERT INTO snw_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ami ninle alesaa ya ninta ni nkpa nɛ. ");
INSERT INTO snw_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Waawa lee anɛ lale alesaa ya manlɛɛ ni mana di ɔfaafuu kamɛ, kafɔɔ baakpi. ");
INSERT INTO snw_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Kafɔɔ alesaa ya niekye osi ɛɛwa nii nle n-ya okle alɛ otii lele niele nya, ɔlɔbakpi. ");
INSERT INTO snw_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ami ninle alesaa ya ninkpe ni nkpa niakye osi aawa ni nɛ. Nse otii owo lele alesaa ya mmle, abasiɛ nkpa ninnaa ni kaloo. Alesaa ya mmle ninle suoto nii sina nɛ. Nsĩ kamayɔ nta alɛ kayi ka mmle batii kawɛ nkpa nɛ.” ");
INSERT INTO snw_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Nle mmle oso Yuda batii nwu nkpo lakye kasɔ baatɔɔnanfi ɔlaa osie kanya kaamɛ lɛma alɛ, “Lɛ di osuɔtɔ wɔ mmle mayɔ suoto sina nɔɔ anta wo alɛ bule?” ");
INSERT INTO snw_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ninfɛ di Yesu latɔkɔ ma alɛ, “Nwaako kɔtɔkɔ ye nlɛ, nse biele Otii Obi nwu suoto sina, binyi nwɔ ntɔ, ni bilabawɛ nkpa di kamɛ lee. ");
INSERT INTO snw_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Otii lele niele suoto nii sina nwu, eenyi ntɔ nii nwu nkpo kafɔɔ, ni akpe nkpa be ninnaa ni kaloo, ni kamasɛnkɛsa nwɔ ansiɛ nkpa di dii yɛntɛle nwu nkpo suoto. ");
INSERT INTO snw_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Diekye suoto nii sina nwu nkpo ninle alesaa nwu amuamu, ntɔ nii nwu kafɔɔ ninle dinyinsaa nimunimu. ");
INSERT INTO snw_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Otii lele niele mi suoto sina nwu eenyi mi ntɔ nwu kafɔɔ nsi mi kaamɛ, ami kafɔɔ nsi nwɔ kaamɛ. ");
INSERT INTO snw_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Fɛ mmle okle di Teemi wɔ ninkpe ni nkpa lekpee mi ni kɔtɔ, di nnwɔɔ kamɛ nkpe ni nkpa oso yi, nkpo okle kafɔɔ di otii wɔ niele mi ni suoto sina kafɔɔ masiɛ nkpa ta ami oso nɛ. ");
INSERT INTO snw_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Nya alesaa ya niakye osi aawa nii, aate fɛ nnyankpo okle di waawaa lee anɛ lale ni baakpi nii. Nkpo oso otii lele niele alesaa ya mmle masiɛ nkpa ninnaa ni kaloo.” ");
INSERT INTO snw_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Asaa ya mmle di Yesu labuɛ aatuo asaa di Yuda batii kasiisakɔ di Kapernaum nɛ. ");
INSERT INTO snw_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Obe wɔ di basaateketetɛ nɔɔ kpinwu lanu ni sɛlaa se mmle yi, baabuɛ alɛ, “Asaatuo ya mmle nkpe osie! Owe nimafuo nya ofũ?” ");
INSERT INTO snw_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Otii kuonwii ditatɔkɔ Yesu ɔlaa kuonwii kafɔɔ aatofo alɛ basaateketetɛ nɔɔ latoonwununu di sɛlaa se mmle suoto. Nioso aakaalɛ ma alɛ, “Sɛlaa se mmle kototofo ye di atokoɛ? ");
INSERT INTO snw_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ni se diɛwa alɛ biɛɛnya Otii Obi nwu kokple ansifi osi di lɛba le aawɛ ni saa mɔ, ni lɛ dibate ye? ");
INSERT INTO snw_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Lɛsaa le ninta ni nkpa ninle Yaa Ninwuna nɛ. Otii osie nwu diesi di lɛsalɛsaa kuninwii kamɛ. Sɛlaa se ntoobuɛ lɛta ye ni ninwako Yaa Ninwuna nkpa. ");
INSERT INTO snw_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Kafɔɔ batii kpinwu kaamɛ lee diefũ banu.” Yesu labuɛ sɛlaa se mmle diekye kaasɔ kakyekɔ aatofo batii ba ninamafũ banu nii, ku otii wɔ nimadiki nwɔ anta nii. ");
INSERT INTO snw_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ninfɛ aakple aabuɛ alɛ, “Nle mmle oso latɔkɔ ye nlɛ otii kuonwii dilabafuo ɔkyɛ nii ɔwa diediki Ote nwu nkpo nietuo nwɔ osuku.” ");
INSERT INTO snw_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Nle mmle oso Yesu basaateketetɛ nɔɔ kpinwu lakple nkpaamaa, batasintuna alɛ bootikanko nwɔ. ");
INSERT INTO snw_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Nkpo oso, Yesu lamunikĩi aakaalɛ batɔkyɛntɛ nɔɔ lefosi banyɔ nwu nkpo kafɔɔ alɛ, “Aye kafɔɔ biomiɛ bilɛ bikple nkpaamaa ɛɛ, sɛɛ lɛ?” ");
INSERT INTO snw_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ninfɛ di Simon Petro ladiki kanya alɛ, “Saate, owe nfũ nfɛ buofe? Afɔ ninkpe sɛlaa se ninta ni nkpa be ninnaa ni kaaloo. ");
INSERT INTO snw_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nunua, butoofũ buonu buɔnya kafɔɔ buɔtɛnsũ bulɛ afɔ ninle Otii Klekle wɔ niekye ni Yaa nfũ.” ");
INSERT INTO snw_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ninfɛ di Yesu latɔkɔ ma alɛ, “Ami niediki lefosi batii lee banyɔ, kafɔɔ onwii nle Abonsam kaamɛ lee.” ");
INSERT INTO snw_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yesu latoobuɛ ɔlaa wɔ mmle di Yuda suoto, nnwɔɔ niale Simon Iskariot obi nɛ. Diekye di lefosi batii banyɔ nwu nkpo kamɛ, nnwɔɔ niadiki Yesu aata nɛ. ");
INSERT INTO snw_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Di nle mmle sɛmaa, Yesu lakyɛ aakyi di Galilea kasɔ suoto. Atamiɛ alɛ ɔɔkyɛ ankyi di Yudea kasɔ suoto. Diekye, Yuda banɔɔfotii latoomiɛ osuku alɛ boolo nwɔ. ");
INSERT INTO snw_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Di obe nwu nkpo kamɛ, Yuda batii akpanta kalɔ osiɛ ayi ole bee ntɔɔtɛɛtɛɛ. ");
INSERT INTO snw_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Nkpo oso Yesu babilɛma latɔkɔ nwɔ alɛ, “Die ninfũ faatɔɔkyɛ Yudea kasɔ suoto alɛ basaateketetɛ lɛfɔ kanya fɔ ɔsaabla. ");
INSERT INTO snw_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Diekye otii kuonwii ninkookaa lɛsaa le ɔɔbla nii nse oomiɛ alɛ batii batofo nwɔ nwaa. Di obe wɔ fɔɔbla ni aasaa ya mmle nwu nkpo okle yi, diki suoto fatuo kayi batii bamuu baatofo fɔ!” ");
INSERT INTO snw_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Baatɔkɔ nwɔ sɛlaa se mmle diekye babilɛma suɔtɔbi bamu ditafũ nwɔ baanu. ");
INSERT INTO snw_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Nfa nfɛ di Yesu latɔkɔ ma alɛ, “Obe nii diiwo. Kafɔɔ aye yi, obe lele nkaatɛko ye. ");
INSERT INTO snw_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Diekye aye yi, kayi ka mmle batii dilabafuo ye okyidi. Kafɔɔ ami yi, beekyidi mi, diekye kodiki ntɔkɔ ma klekle nlɛ ɔsaabla lɛma diɛɛlɛ. ");
INSERT INTO snw_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Aye yi, bitɔɔkyɛ Ayi nwu nkpo kalekɔ. Ami nɔɔwa nfa, diekye obe nii diiwo saa.” ");
INSERT INTO snw_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Obe wɔ aatɔkɔ ma nkpo okle aaloo ni yi, nnwɔɔ omu aakple aasiɛ di Galilea ninfa. ");
INSERT INTO snw_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Obe wɔ di babilɛma suɔtɔbi ntoosifi ni ayi nwu nkpo kalekɔ beeloo ni yi, Yesu kafɔɔ lakyɛ, atakyɛ alɛ batii banyɔɔ kafɔɔ aakyɛ di lɛwofa kamɛ. ");
INSERT INTO snw_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Yuda batii banɔɔfotii latowolaa nwɔ di ayi nwu nkpo kalekɔ baatɔɔkaalɛ alɛ, “Ɔfɛ di osuɔtɔ nwu nkpo nkpe?” ");
INSERT INTO snw_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Batii latoobuɛ sɛwɛɛwɛɛ baakakatɛ kpinwu di Yesu suoto. Batii bawo labuɛ alɛ, “Otii biene ale.” Batii bamba kafɔɔ labuɛ alɛ, “Oowo! Otii kpile ale. Ɔɔkyɔnkyɔ batii anfenko di osuku kpile suoto.” ");
INSERT INTO snw_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Kafɔɔ otii kuonwii ditafuo odiki obuɛ osie kanya diekye baatɔɔyɛkɛ Yuda batii banɔɔfotii. ");
INSERT INTO snw_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Obe wɔ nfɛ di ayi nwu nkpo ole nfɛ kodu ni ntɛɛ yi, Yesu lakyɛ Yuda batii Olekatakɔ aalaatuo batii asaa. ");
INSERT INTO snw_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Asaa nɔɔ otuo labla Yuda batii banɔɔfotii ɔkpɛ, ni baakaalɛ alɛ, “Lɛ diɛbla fiɛ di osuɔtɔ wɔ mmle n-ye lɛsaa nkpo okle, di obe wɔ anankyɛ ni asaa kateketekɔ kukanwii?” ");
INSERT INTO snw_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ninfɛ di Yesu ladiki kanya aatɔkɔ ma alɛ, “Asaa ya kotuo ni diele ami omu asaa otuo ale. Kafɔɔ Yaa wɔ niekpee mi ni kɔtɔ ale ale. ");
INSERT INTO snw_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Otii lele nikomiɛ alɛ abla Yaa dibiesaa matofo nse asaa ya kotuo ni Yaa nfũ eekye ee ami omu osie nii kamɛ lɛyɔ kɔkakatɛ. ");
INSERT INTO snw_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Otii lele ninkakatɛ di nnwɔɔ omu osie nɔɔ kamɛ yi, ni oomiɛ alɛ ayɔ katansa ata nnwɔɔ omu nɔɔ suoto. Kafɔɔ otii wɔ nikomiɛ alɛ atansa ni otii wɔ niekpee nwɔ ni kɔtɔ yi, ambla asaa di osuku kanya, ni aanlaa kafɔɔ. ");
INSERT INTO snw_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Diele Mose niayɔ kufiofa nwu nkpo aata ye, sɛɛ lɛ? Kafɔɔ otii kuonwii kaamɛ lee diloole kufiofa nwu nkpo. Ni be oso biomiɛ bilɛ biloe?” ");
INSERT INTO snw_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ninfɛ di batii nwu nkpo latɔkɔ Yesu alɛ, “Ninwuna kpile ninsi fɔ kaamɛ! Owe nikomiɛ alɛ alo fɔ?” ");
INSERT INTO snw_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ninfɛ di Yesu ladiki kanya alɛ, “Lɛsaa ninwii le lɛbla, ninfɛ diɛbla bamuu lee yaaa nɛ. ");
INSERT INTO snw_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mose lakpee ye kufiofa alɛ biabudi babi lee asɔkɔsɔkɔ. Kafɔɔ diele nnwɔɔ niakye kasɔ, waawa lee anɛ niakye kasɔ bia saa obe kamɛ. Kafɔɔ mimbudi babi lee asɔkɔsɔkɔ di Lɛnyɛɛtɛyi suoto. ");
INSERT INTO snw_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ni nse mimbudi babi lee asɔkɔsɔkɔ di Lɛnyɛɛtɛyi suoto alɛ bilaataalɛ Mose kufiofa nwu nkpo, ni be oso biɔnyakee ɔblɔ ta lɛyɔɔsa ni otii ofiɛ diɛyɔɔ nwɔ ni di Lɛnyɛɛtɛyi suoto? ");
INSERT INTO snw_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Nse biɔkanko yi, bitannyu otii di anu biaka lɛka! Kafɔɔ yi, bika di mmle di ɔlaa nwu nte ni.” ");
INSERT INTO snw_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ninfɛ di batii ba bawo niakye ni Yerusalem okpoo, baakaalɛ alɛ, “Diele osuɔtɔ wɔ mmle di Yuda banɔɔfotii komiɛ alɛ balo ni nɛ? ");
INSERT INTO snw_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Binyu! Nnwɔɔ nin-yɛ di lɛkpaka ɔɔkakatɛ nɛ! Otii kuonwii kafɔɔ dilɔɔkaalɛ nwɔ ɔlaa kuonwii! Sɛɛ kamɛ ntɔɔkpa ma klekle nfɛ alɛ nnwɔɔ ninle Kristo nwu nkpo? ");
INSERT INTO snw_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Kafɔɔ nse Kristo nwu nkpo lɛwa yi, otii kuonwii dilabatofo nfũ eekye nii. Kafɔɔ otii wɔ mmle nnwɔɔ bamuu loo buye nfũ eekye nii.” ");
INSERT INTO snw_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Di obe wɔ di Yesu latootuo ni asaa di Olekatakɔ nwu nkpo ninfa yi, aatakatɛsa sɛlɔ katoo aakaalɛ alɛ, “Obuɛ biobuɛ bilɛ biye mi, biye nfũ kafɔɔ lekye ni? Diele ami omu osie nii kamɛ lɛwa! Otii wɔ niekpee mi ni kɔtɔ ninlaa. Aye bieye nwɔ. ");
INSERT INTO snw_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Kafɔɔ ami n-ye nwɔ. Diekye ɔkyɛ nɔɔ lekye, nnwɔɔ kafɔɔ niekpee mi kɔtɔ.” ");
INSERT INTO snw_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Nle mmle oso, baamiɛ alɛ boomufũ nwɔ. Kafɔɔ otii kuonwii ditafuo nwɔ ɔkpanko, diekye obe nɔɔ diiwo. ");
INSERT INTO snw_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Kafɔɔ kaamɛ lɛma batii bawo kpinwu lafũ nwɔ baanu baatɔɔkaalɛ alɛ, “Ni nse Kristo nwu nkpo lɛwa, ababla sɛkpɛ se niɛbla ɔkpɛ silenke ni nse di otii wɔ mmle lɛbla ni?” ");
INSERT INTO snw_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Di obe wɔ di Farisi batii lanu ni sɛlaa se baatii kobuɛ ni di Yesu suoto oso yi, baabla onwii ku olebatatɛ banɔɔfo, baakpee asaa banyuntɛ alɛ bakyɛ blaamufũ Yesu. ");
INSERT INTO snw_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ninfɛ di Yesu latɔkɔ ma alɛ, “Makple nsiɛ di ɔkyɛ lee di obe kakui kamɛ, nni kamaa se ntoosifi otii wɔ niekpee mi ni kɔtɔ nfũ. ");
INSERT INTO snw_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Bibawolaa mi kafɔɔ bilɔbanyɛɛ, diekye lɛba le kamasiɛ nii, bilɔbafuo nfa ɔwa.” ");
INSERT INTO snw_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ninfɛ di Yuda batii nwu lakaalɛ bawo alɛ, “Ɔfɛ di otii wɔ mmle kofe oso fiɛ, bulɔbanyɔɔ? Sɛɛ abasifi Hela batii sekpoo di nfũ baatii loo nsi ni anaatuo Hela batii asaa? ");
INSERT INTO snw_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Be alaka di obe wɔ eebuɛ alɛ ‘Bibawolaa mi, kafɔɔ bilɔbanyɛɛ. Nfũ kafɔɔ kamasiɛ nii, bilabafuo nfa ɔwa?’ ” ");
INSERT INTO snw_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Dii yɛntɛle le di ayi nwu nkpo boole kamɛ, dile dii finle, Yesu lataka aayila aatakatɛsa sɛlɔ katoo aabuɛ alɛ, “Otii lele di otukɔnsɔ nkle, awa ɔkyɛ nii, abanyi ntu. ");
INSERT INTO snw_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Fɛ mmle okle di Kɔkpana Klekle lebuɛ ni di otii wɔ niefũ mi eenu ni suoto alɛ, ‘Ntu be nikɔtaa ninansɔɔ ni diidii, ninta alɛ otii nsiɛ ni nkpa, ntu nwu nkpo kamatoobiɛ nintoofe di otu nɔɔ kamɛ.’ ” ");
INSERT INTO snw_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesu labuɛ ɔlaa wɔ mmle di Ninwuna le baatii ba niefũ nwɔ beenu ni kamafũ ni suoto. Diekye di obe nwu nkpo kamɛ yi, bayiyɔ Ninwuna nwu nkpo bata. Diekye Yesu diibuo di Sɛka ole nɔɔ nwu nkpo lɛkpa kamɛ. ");
INSERT INTO snw_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Obe wɔ baatii nwu nkpo lanu ni Yesu sɛlaa se mmle yi, bawo kaamɛ lɛma labuɛ alɛ, “Nwaako Yaa Ɔlaa Buɛtɛtɛ nwu nkpo ninle otii wɔ mmle.” ");
INSERT INTO snw_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Babamba kafɔɔ labuɛ alɛ, “Nnwɔɔ ninle Kristo nwu nɛ.” Bawo kafɔɔ labuɛ alɛ, “Kristo nwu nkpo diele Galilea abadie ankye! ");
INSERT INTO snw_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Diekye Kɔkpana Klekle Kukũ lebuɛ alɛ, Kristo nwu nkpo Ɔka Dawid leyo kamɛ abakye. Babalofo nwɔ di Betlehem, di okpoo wɔ di Dawid lasiɛ nii.” ");
INSERT INTO snw_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ta Yesu oso, batii nwu nkpo lasɛ. ");
INSERT INTO snw_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Bawo lamiɛ alɛ boomufũ nwɔ, kafɔɔ otii kuonwii ditafuo nwɔ ɔkpanko. ");
INSERT INTO snw_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Obe wɔ di Basaanyuntɛ nwu nkpo lakple baasifi ni Farisi batii ku olebatatɛ banɔɔfo nwu nkpo nfũ yi, baakaalɛ ma alɛ, “Obe oso minammufũ nwɔ biwako?” ");
INSERT INTO snw_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ninfɛ di basaanyuntɛ nwu nkpo latɔkɔ ma alɛ, “Diidii buunu otii kuonwii akakatɛ nwaa fɛ mmle okle di osuɔtɔ wɔ mmle lɛkakatɛ nii!” ");
INSERT INTO snw_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ninfɛ di Farisi batii nwu nkpo lakaalɛ ma alɛ, “Aye kafɔɔ osuɔtɔ nwu nkpo lɛkyɔnkyɔ ye? ");
INSERT INTO snw_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Bitoyinu ɔnɔɔfotii owo ee Farisi otii owo ntoyifũ nwɔ eenu? ");
INSERT INTO snw_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Batii dikudi le mmle nimuu dieye Mose kufiofa nwu nkpo. Nkpo oso lɛkpaani ntikanko ma!” ");
INSERT INTO snw_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Farisi otii wɔ bɔɔlɛɛ ni Nikodemo nintoyikyɛ ni Yesu nfũ lasiɛ ma kaamɛ, ninfɛ aakaalɛ ma alɛ, ");
INSERT INTO snw_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Kufiofa loo lɛta osuku alɛ baalo otii lɛpɔɔ di obe wɔ manayilɛɛ nwɔ banu nwɔ ni kanya kamɛ ɔlaa di lɛsaa le ɛɛbla ni suoto?” ");
INSERT INTO snw_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ninfɛ ninnwɔɔ kafɔɔ baakaalɛ nwɔ alɛ, “Afɔ kafɔɔ Galilea feekye ɛɛ, sɛɛ lɛ? Buo diakũ kamɛ fanyu! Fabanya falɛ Yaa ɔlaa buɛtɛtɛ kuonwii dilabakye Galilea awa diidii.” ");
INSERT INTO snw_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","(Ninfɛ di obiala lɛma lasifi ayo lɛma nɛ.) ");
INSERT INTO snw_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Kafɔɔ Yesu nnwɔɔ aasifi kobokote ko manlɛɛ ni Nnɔnyi Awoso Kobokote osi. ");
INSERT INTO snw_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Obe wɔ kaale lasɛ ni ku kuyitatũ yi, Yesu lakple aasifi Yuda batii Olekatakɔ. Ninfɛ di batii nwu nkpo bamuu lawa ɔkyɛ nɔɔ babasiɛ baamana nwɔ baakyi, ni aasiɛ kaasɔ aakyako ma asaa otuo nɛ. ");
INSERT INTO snw_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ninfɛ di kufiofa asaa batuotɛ ku Farisi batii lakpaa ɔsanko onwii baamufũ oodie ni ɔsa kamaa nnɛɛ nnɛɛ baawako babase nwɔ di bamuu lɛma anu nɛ. ");
INSERT INTO snw_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ninfɛ baatɔkɔ Yesu alɛ, “Saatuotɛ, buomufũ ɔsanko wɔ mmle nnɛɛ nnɛɛ osuɔtɔ bamba kotenko nwɔ. ");
INSERT INTO snw_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Di kufiofa loo kanya yi, Mose lɛta wo osuku alɛ dikpe ni buasafɔ ɔsanko wɔ mmle okle afuɔ munlo. Ni lɛ di afɔ foobuɛ?” ");
INSERT INTO snw_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Baakaalɛ Yesu ɔlaa wɔ mmle alɛ bɔɔyɔ manwolaa nwɔ kaanya mmle okle baalo nwɔ ni lɛpɔɔ. Kafɔɔ ninfɛ aawa kasɔ aayɔ lɛnɛɛ nɔɔ aakyako asaa ɔkpana kaasɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Obe wɔ baayila ninfa bɔɔkaalɛ nwɔ ni akaalɛ yi, ninfɛ aatakatɛsa suoto aatɔkɔ ma alɛ, “Olele kaamɛ lee ninayibla okpile diidii yi, aaka nwɔ difuɔ oyu ɔsafɔ.” ");
INSERT INTO snw_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ninfɛ aakple aawa kasɔ aayɔ lɛnɛɛ nɔɔ aakyako asaa ɔkpana kaasɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Obe wɔ baanɔɔfo nwu nkpo lanu ni ɔlaa nwu yi, ni baakyako osifi onwii onwii fɛ mmle okle balekatũ batika ni nɛ. Ni diabu Yesu ku ɔsanko nwu lete ninfa nɛ. ");
INSERT INTO snw_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ninfɛ di Yesu latakatɛsa suoto, ni aakaalɛ ɔsanko nwu alɛ, “Ɔsanko, fɛ baatii nwu nkpo ntoofe? Kuonwii lɛma diebu aalo fɔ ni lɛpɔɔ?” ");
INSERT INTO snw_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ninfɛ di ɔsanko nwu nkpo latɔkɔ nwɔ alɛ, “Ɔnɔɔfo, oowo lo!” Nkpo oso, Yesu latɔkɔ nwɔ alɛ, “Nii ni ami kafɔɔ, noolo fɔ lɛpɔɔ. Nioso, tɔɔkyɛ. Kafɔɔ, taasinkple faalaasiɛ faatɔɔbla sikpile.” ");
INSERT INTO snw_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Di nni nkpo sɛmaa, Yesu lakple aabuɛ aatɔkɔ batii nwu nkpo alɛ, “Ami ninle kayi ka mmle lɛkpa. Otii lele nietikanko mi, abawɛ lɛkpa le ninta ni nkpa. Diidii kafɔɔ ɔlɔbakyɛ di ditunu kamɛ.” ");
INSERT INTO snw_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ninfɛ di Farisi batii nwu nkpo latɔkɔ nwɔ alɛ, “Afɔ omu lɛfɔ nikodiki suoto kanya. Nkpo oso suoto lɛfɔ kanya odiki nwu nkpo diedie lɛsalɛsaa.” ");
INSERT INTO snw_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ninfɛ di Yesu latɔkɔ ma alɛ, “Kuntɛ kodiki suoto kanya yi, suoto nii kanya nwu kodiki ni nte nkpo. Diekye n-ye nfũ lekye nii, n-ye nfũ kafɔɔ kofe nii. Aye bieye nfũ lekye nii, ee nfũ kofe nii. ");
INSERT INTO snw_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Aye yi, sitiinyu kanya minkanko. Kafɔɔ ami yi, ninkanko otii kuonwii. ");
INSERT INTO snw_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Nse bia nlɛ kɔkanko yi, lɛkanko nii ntabakyɛ di osuku kanya. Diekye diele lete nii ninkanko. Teemi wɔ niekpee mi ni kɔtɔ, munko nwɔ ninkanko nɛ. ");
INSERT INTO snw_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Bɛɛkpana di kufiofa lee kamɛ alɛ, nse batii banyɔ kanya nkaatɛ di ɔlaa owo suoto yi, ni ɔlaa nwu nte nkpo. ");
INSERT INTO snw_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ami yi, ndiki suoto nii kanya. Teemi wɔ kafɔɔ niekpee mi ni kɔtɔ kafɔɔ ndiki mi suoto kanya.” ");
INSERT INTO snw_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ninfɛ baakaalɛ Yesu alɛ, “Ɔfɛ di Teefɔ nwu nkpo nkpe?” Ni aatɔkɔ ma alɛ, “Bieye mi. Bieye Teemi kafɔɔ. Diekye nse oye biye mi yi, nse bitabatofo Teemi kafɔɔ.” ");
INSERT INTO snw_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu labuɛ sɛlaa se mmle di obe wɔ ootuo ni asaa di Yaa Olekatakɔ di lɛba le niɛtɛɛtɛɛ ni nfũ manta ni koto. Kafɔɔ otii kuonwii ditafuo nwɔ omufũ diekye obe nɔɔ diiwo. ");
INSERT INTO snw_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu lakple aatɔkɔ ma alɛ, “Ami yi, kamasifi. Bibawolaa mi, kafɔɔ bibakpi di sikple lee kamɛ. Lɛba le kafɔɔ kofe nii bilabafuo nfa ɔwa.” ");
INSERT INTO snw_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Nioso Yuda batii banɔɔfotii lakaalɛ alɛ, “Suoto oofe olo oso oobuɛ alɛ, ‘Bilabafuo lɛba le kofe ni ɔwa’?” ");
INSERT INTO snw_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ninfɛ di Yesu latɔkɔ ma alɛ, “Aye yi, kasɔ ka mmle suoto biekye. Kafɔɔ ami yi, osi lekye lɛwa. Aye yi, kayi ka mmle batii bile. Kafɔɔ ami yi, diele kayi ka mmle otii nle. ");
INSERT INTO snw_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Nioso latɔkɔ ye nlɛ, bibakpi di sikpile lee kamɛ nɛ. Nse biefũ binu bilɛ nle otii wɔ nnle nii, nwaako bibakpi di sikpile lee kamɛ.” ");
INSERT INTO snw_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ninfɛ baakaalɛ nwɔ alɛ, “Owe fale?” Ninfɛ di Yesu latɔkɔ ma alɛ, “Lɛsaa le lɛtɔkɔ ye kaasɔ kakyekɔ nlɛ nle ni yi, nni nwu kɔtɔkɔ ye nlɛ nle nɛ. ");
INSERT INTO snw_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nkpe sɛlaa kpinwu kabuɛ di suoto lee nlo ye ni lɛpɔɔ ta nkpa lee oso fiɛ. Kafɔɔ otii wɔ niekpee mi ni kɔtɛ ninlaa. Nioso ɔlaa wɔ lenu lekye ko ni ɔkyɛ nɔɔ yi, nwu lete lɛkya koyie nta kayi batii nɛ.” ");
INSERT INTO snw_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Batanu kasɔ alɛ Yesu yi, Ote suoto aatɔɔkakatɛ aatɔɔta ma. ");
INSERT INTO snw_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Nioso aatɔkɔ ma alɛ, “Obe wɔ bibatakatɛsa ni Otii Obi nwu katoo yi, obe nwu nkpo bibatofo bilɛ ami ninle otii wɔ lebuɛ nlɛ nnle ni nɛ. Nimbla lɛsalɛsaa kafɔɔ di ami omu osie nii kamɛ. Lɛsaa le kafɔɔ di Teemi lekpeemi alɛ mbuɛ nii, nni nimbuɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Otii wɔ niekpee mi ni kɔtɔ kafɔɔ nsikoe. Aadiɛ mi lete, diekye obe lele mbla lɛsaa le nimbuo nwɔ ni anu.” ");
INSERT INTO snw_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Obe wɔ di Yesu labuɛ ni sɛlaa se mmle okle oso yi, batii kpinwu lafũ nwɔ baanu. ");
INSERT INTO snw_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Nkpo oso Yesu latɔkɔ Yuda batii ba niafũ nwɔ baanu ni alɛ, “Nse biemufũ asaa otuo nii bieklee, ni nwaako basaateketetɛ nii bile. ");
INSERT INTO snw_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ni bibatofo nwaako ɔlaa nwu, ni ɔlaa nwu nkpo mata ye minwɛ kayaa.” ");
INSERT INTO snw_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ninfɛ baatii nwu latɔkɔ Yesu alɛ, “Abraham banantii bule, diidii kafɔɔ buukple otii kuonwii ɔlanle. Ni be oso foobuɛ falɛ bubawɛ kayaa?” ");
INSERT INTO snw_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ninfɛ di Yesu latɔkɔ ma alɛ, “Nwaako kɔtɔkɔ ye nlɛ, otii lele nikɔbla okpile yi, ale ɔlanle ɛɛta okpile. ");
INSERT INTO snw_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ɔlanle nínle saate nɔɔ atesaa. Kafɔɔ obi ninle ote atesaa obe lele. ");
INSERT INTO snw_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Nkpo oso nse Yaa Obi nwu lɛtafɔ kayaa yi, ni fɛɛwɛ kayaa kamu kamu. ");
INSERT INTO snw_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","N-ye nlɛ Abraham banantii bile. Kafɔɔ biomiɛ bilɛ bilo mi, diekye biloofũ asaa otuo nii ya kotuo ye ni binu. ");
INSERT INTO snw_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Lɛsaa le di Teemi letuo mi ni yi, nni suoto kɔkakatɛ nɛ. Aye kafɔɔ lɛsaa le di teeye lɛtɔkɔ ye ni yi, nni biɔbla nɛ.” ");
INSERT INTO snw_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ninfɛ baatɔkɔ nwɔ alɛ, “Abraham ninle wo kote.” Ninfɛ di Yesu latɔkɔ ma alɛ, “Nse nwaako Abraham babi bile yi, bitababla asaa fɛ mmle okle aabla nii. ");
INSERT INTO snw_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Kafɔɔ ami wɔ nikɔtɔkɔ ye ni nwaako ɔlaa nwu lenu lekyeko ni Yaa nfũ yi, ami biomiɛ bilɛ bilo nɛ. Abraham ditabla nle mmle okle. ");
INSERT INTO snw_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Asaa ya di teeye omu labla nii, nnya biɔbla nɛ.” Ninfɛ baatɔkɔ Yesu alɛ, “Buole basɔnɔbi. Kote kunwii ninkpe wo, nkũ ninle Yaa nɛ.” ");
INSERT INTO snw_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ninfɛ di Yesu latɔkɔ ma alɛ, “Nse nwaako Yaa ninle ye Kote yi, nse bitababɔmbɔ mi, diekye Yaa nfũ lekye lɛwa. Ninwa ku ami omu osie, nnwɔɔ niekyesee mi. ");
INSERT INTO snw_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Be oso minoonu lesaa le kobuɛ ni kasɔ? Diekye ɔlaa nii kototofo ye di atoko. ");
INSERT INTO snw_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Diekye teeye ninle Abonsam, nioso biomiɛ bilɛ bitikanko teeye dibiesaa nɛ. Diayɔ ni bia kaasɔ kakyekɔ, batii lotɛ ale. Diidii kafɔɔ ayitikanko onukwale, diekye onukwale diesi nwɔ kaamɛ. Nse ɛɛlaa kafɔɔ nkpa nɔɔ letembi oodiki kayi antuo, diekye laatɛ ale. Nnwɔɔ kafɔɔ ninle balaatɛ bamuu kote nɛ. ");
INSERT INTO snw_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ta ami kobuɛ ni onukwale oso, nkpo oso minoofũ mi binu nɛ. ");
INSERT INTO snw_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Owe lee nkafuo mi okpile lɛpɔɔ olo? Ni nse kobuɛ onukwale mɔ, be oso minoofũ mi binu? ");
INSERT INTO snw_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Otii wɔ niekye ni Yaa nfũ yi, ankyɔɔ Yaa ɔlaa atoko. Kafɔɔ, aye minankye ni Yaa nfũ oso yi, minkyɔɔ nwɔ ɔlaa atoko.” ");
INSERT INTO snw_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ninfɛ di Yuda batii nwu lakaalɛ Yesu alɛ, “Nse buobuɛ bulɛ Samaria otii fale, mmia kafɔɔ ninwuna kpile nsi fɔ kaamɛ, diele nwaako ɔlaa kule?” ");
INSERT INTO snw_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ninfɛ di Yesu latɔkɔ ma alɛ, “Ninwuna kpile diesi mi kaamɛ. Ami kɔyɔ dibu nta Teemi, kafɔɔ aye biɔlalaasa mi leyooto. ");
INSERT INTO snw_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Noomiɛ dibu nta suoto. Kafɔɔ otii onwii nkpe oomiɛ ni antɛɛ nii, nnwɔɔ kafɔɔ ninkanko di osuku kanya nɛ. ");
INSERT INTO snw_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nwaako kɔtɔkɔ ye, otii lele niɛkyɔɔ mi asaa otuo atoko dilabakpi diidii!” ");
INSERT INTO snw_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ninfɛ di Yuda batii nwu nkpo latɔkɔ nwɔ alɛ, “Mia nfɛ butootofo nwaako bulɛ, ninwuna kpile ninsi fɔ nɛ. Diekye Abraham lakpi, Yaa kanya badikitɛ kafɔɔ lakpi, kafɔɔ foobuɛ falɛ, otii lele niɛkyɔɔ fɔ asaa otuo atoko dilabakpi diidii! ");
INSERT INTO snw_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Teewo Abraham lakpi, ni obuɛ foobuɛ falɛ fɛɛtaka katoo falenke nwɔ? Yaa kanya badikitɛ kafɔɔ lakpi. Ni ɔmɛntii okle foonyu falɛ fale?” ");
INSERT INTO snw_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ninfɛ di Yesu ladiki kanya alɛ, “Nse nlɛ kɔtansa suoto yi, suoto nii ɔtansa nwu nkpo dilabadie lɛsalɛsaa. Teemi ninle otii wɔ nikɔtansɛɛ nii, otii wɔ biobuɛ bilɛ nnwɔɔ ninle ye ni Yaa. ");
INSERT INTO snw_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Mmia kafɔɔ bieye nwɔ. Kafɔɔ ami n-ye nwɔ. Nse lebuɛ nlɛ ninye nwɔ yi, ni ntookple laatɛ fɛle aye. N-ye nwɔ, kɔkyɔɔ nwɔ kafɔɔ ɔlaa atoko. ");
INSERT INTO snw_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Teeye Abraham lanya suoto lɛyɔɔ alɛ abanya ɔwabee nii. Aanya nwu kafɔɔ, suoto layɔɔ nwɔ.” ");
INSERT INTO snw_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ninfɛ di Yuda batii latɔkɔ Yesu alɛ, “Fayifũ alɛɛ afosi anɔɔ, ni obuɛ foobuɛ falɛ fatɔɔnya Abraham nɛ?” ");
INSERT INTO snw_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Nfa nfɛ di Yesu latɔkɔ ma alɛ, “Nwaako kɔtɔkɔ ye nlɛ, fiɛ babalofo ni Abraham, ami nfɛ nkpe.” ");
INSERT INTO snw_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Obe wɔ aatɔkɔ ma ni ɔlaa nwu nkpo, ninfɛ baatii nwu nkpo layɔ afuɔ alɛ bɔɔsafɔ nwɔ nɛ. Kafɔɔ Yesu lawofasa suoto, ni aadie di Yaa Olekatakɔ nwu kamɛ ninfa aasifi nɛ. ");
INSERT INTO snw_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Obe onwii kamɛ di Yesu lakyɛ aatoofe nii, aakyakako osuɔtɔ onwii niabiɛ ni anu, diayɔ ni bia kalofokɔ nɔɔ. ");
INSERT INTO snw_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ninfɛ di basaateketetɛ nɔɔ lakaalɛ nwɔ alɛ, “Saatuotɛ, owe niabla okpile oso beelofo osuɔtɔ wɔ mmle numbiɛtɛ? Nnwɔɔ omu nɔɔ okpile kule ɛɛ, sɛɛ balofotɛ nɔɔ niabla okpile?” ");
INSERT INTO snw_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ninfɛ di Yesu ladiki kanya alɛ, “Osuɔtɔ wɔ mmle anu ya niebiɛ nwɔ ni yi, diele nnwɔɔ niabla okpile ee balofotɛ nɔɔ niabla ni okpile oso. Kafɔɔ eebiɛ anu alɛ baadiki Yaa osie mantuo batii diefe ni di suoto nɔɔ. ");
INSERT INTO snw_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Di obe wɔ kaale diiloo nii, dikpe nii, buɔbla otii wɔ niekpee mi ni kɔtɔ ɔkpɛ. Diekye kale kɔwa ɔbaloo di otii kuonwii dilabasinfuo ni ɔkpɛ ɔbla. ");
INSERT INTO snw_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Di obe wɔ lɛnya nkpe ni kaayi ka mmle, ami ninle kayi ka mmle lɛkpa.” ");
INSERT INTO snw_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Obe wɔ di Yesu labuɛ nkpo aaloo nii, ni aatufa sita aakpete kaasɔ aanwɔtɔ kɔtɛ, ni aayɔ kɔtɛ nwu nkpo aafifia di osuɔtɔ nwu anu nɛ. ");
INSERT INTO snw_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ni aatɔkɔ nwɔ alɛ, “Tɔɔkyɛ falaafoto anu di lɛpanta le bɔɔlɛɛ ni Siloa kamɛ.” Siloa lɛsɔdiki ninle alɛ beekpee nwɔ. Nkpo oso osuɔtɔ wɔ mmle lasifi aalaafoto anu. Aapɛ aakple aawa nii, nfɛ ɔɔnya. ");
INSERT INTO snw_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ninfɛ di basiɛwo nɔɔ ku mba ninyɔɔ ansiɛ antɔɔkaalɛ ni asaa, latɔɔkaalɛ bawo alɛ, “Diele osuɔtɔ wɔ mmle ninsiɛ antɔɔkaalɛ ni asaa nɛ, sɛɛ lɛ?” ");
INSERT INTO snw_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Bawo labuɛ alɛ nnwɔɔ dile. Bawo kafɔɔ labuɛ alɛ, “Oowo, diele nnwɔɔ dile. Otii niedie nwɔ.” Nkpo oso, osuɔtɔ nwu nkpo omu labuɛ alɛ, “Ami dile!” ");
INSERT INTO snw_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ninfɛ baakaalɛ nwɔ alɛ, “Lɛ diɛwa fiɛ nfɛ fɔɔnya?” ");
INSERT INTO snw_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ninfɛ aatɔkɔ ma alɛ, “Osuɔtɔ wɔ bɔɔlɛɛ ni Yesu nianwɔtɔ kɔtɛ aafifia mi di anu, ni aatɔkɔ mi alɛ, ntɔɔkyɛ Siloa ninaafoto anu, ninfɛ lasifi nɛ. Lalaaloo ni anu ofoto, ni lakyako ɔnya nɛ.” ");
INSERT INTO snw_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ni baakaalɛ nwɔ alɛ, “Ɔfɛ di osuɔtɔ nwu nkpo nkpe?” Ni aatɔkɔ ma alɛ, “Ninye.” ");
INSERT INTO snw_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ninfɛ baatii nwu lakpaa osuɔtɔ nwu nkpo di anu labiɛ ni baakyɛnko Farisi batii nfũ nɛ. ");
INSERT INTO snw_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Dii le di Yesu lanwɔtɔ kɔtɛ aafifia ni di osuɔtɔ nwu anu aatikiti ni yi, Lɛnyɛɛtɛyi diale. ");
INSERT INTO snw_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Nkpo oso Farisi batii kafɔɔ baakaalɛ osuɔtɔ nwu mmle diɛwa fiɛ nfɛ ɔɔnya nii. Ninfɛ aatɔkɔ ma alɛ, “Kɔtɛ di osuɔtɔ nwu lanwɔtɔ aafifia mi di anu ni lalaafoto anu nɛ. Ni lɛkyako ɔnya nɛ.” ");
INSERT INTO snw_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ninfɛ di Farisi batii nwu bawo labuɛ alɛ, “Otii wɔ niabla ni lɛsaa le mmle yi, diele Yaa nfũ eekye. Diekye aabla di Lɛnyɛɛtɛyi kufiofa suoto.” Ninfɛ di bawo kafɔɔ labuɛ alɛ, “Kafɔɔ lɛ di kpile blatɛ kafuo sɛkpɛ se niɛbla ni ɔkpɛ ɔbla otuo?” Ninfɛ kaasɛ labuo di batii nwu nkpo ntɛɛ. ");
INSERT INTO snw_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Nioso Farisi batii nwu lakple baakaalɛ osuɔtɔ nwu nkpo alɛ, “Foobuɛ falɛ nnwɔɔ nietikiti fɔ ni anu, ni lɛ foobuɛ di suoto nɔɔ?” Ninfɛ aatɔkɔ ma alɛ, “Yaa ɔlaa buɛtɛtɛ ale.” ");
INSERT INTO snw_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Bia nle Yuda batii nwu ditafuo ofũ onu alɛ osuɔtɔ nwu nkpo numbiɛtɛ aale fiɛ atookple ɔɔnya, dialaase di obe wɔ baalɛɛ balofotɛ nɔɔ. ");
INSERT INTO snw_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ninfɛ baakaalɛ ma alɛ, “Obi lee ninle nwɔ nɛ? Nnwɔɔ bilɛ bielofo ni numbiɛtɛ nɛ? Ni lɛ diɛbla fiɛ nfɛ ɔɔnya?” ");
INSERT INTO snw_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ninfɛ di balofotɛ nɔɔ ladiki kanya alɛ, “Buye bulɛ obi loo ale, buolofo ni numbiɛtɛ. ");
INSERT INTO snw_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Kafɔɔ mmle diɛbla fiɛ nfɛ ɔɔnya nii, buoye. Otii wɔ kafɔɔ nietikiti nwɔ ni anu yi, buoye nwɔ. Nioso bikaalɛ nwɔ, atoomuɔ aafuo ni suoto kanya odiki!” ");
INSERT INTO snw_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Balofotɛ nwu labuɛ ɔlaa wɔ mmle diekye baatɔɔyɛkɛ Yuda batii banɔɔfotii nwu nkpo. Diekye baabuɛ baatɛ alɛ otii lele niediki eebuɛ ku kanya nɔɔ alɛ Yesu ninle Kristo nwu nkpo yi, babadiki nwɔ di Yuda batii kasiisakɔ nwu. ");
INSERT INTO snw_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Nkpo oso di osuɔtɔ nwu nkpo balofotɛ nɔɔ lababuɛ alɛ, “Atoomuɔ aafuo ni suoto kanya odiki, bikaalɛ nwɔ.” ");
INSERT INTO snw_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Banɔɔfotii nwu lakple baalɛɛ osuɔtɔ nwu nkpo baalofo ni numbiɛtɛ lɛnyɔɔfa, baatɔkɔ nwɔ alɛ, “Ka di Yaa falɛ bababuɛ nwaako! Awo buye bulɛ kpile blatɛ ninle otii wɔ nietikitifɔ ni anu!” ");
INSERT INTO snw_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ninfɛ di osuɔtɔ nwu nkpo ladiki kanya alɛ, “Kpile blatɛ ale woo, aale kpile blatɛ woo, ninye. Lɛsaa le lete n-ye ni ninle alɛ, saa, anu labiɛ mi, kafɔɔ nunua nfɛ kɔnya!” ");
INSERT INTO snw_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ni baakaalɛ nwɔ alɛ, “Be aablafɔ? Lɛ aabla fiɛ aatikiti fɔ anu?” ");
INSERT INTO snw_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ninfɛ di osuɔtɔ nwu ladiki kanya alɛ, “Ntɔɔtɔkɔ ye kofokofoko kafɔɔ biloonu. Be oso biomiɛ bilɛ nkple ntɔkɔ ye? Sɛɛ ayee biomiɛ bilɛ bikple nwɔ basaateketetɛ?” ");
INSERT INTO snw_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ninfɛ di banɔɔfotii nwu nkpo lakpaani osuɔtɔ nwu nkpo baatɔkɔ nwɔ alɛ, “Afɔ ko nikale nwɔ saateketetɛ. Awo yi, Mose basaateketetɛ bule. ");
INSERT INTO snw_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Buye bulɛ Yaa lakakatɛ aata Mose. Kafɔɔ otii wɔ mmle, buoye bia nfũ eekye nii!” ");
INSERT INTO snw_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ninfɛ di osuɔtɔ nwu ladiki kanya aabuɛ alɛ, “Ɔmɛnlaa ninle nwɔ? Bieye nfũ eekye nii, kafɔɔ nnwɔɔ nietikiti mi anu nɛ! ");
INSERT INTO snw_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Buye bulɛ Yaa ninkyɔɔ bakpileblatɛ atoko. Kafɔɔ batii ba ninkyɔɔ nwɔ ni ɔlaa atoko mambla nwɔ ni dibiesaa, mma ankyɔɔ atoko nɛ. ");
INSERT INTO snw_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Diɛyɔ ni kaayi ka mmle kasɔ kakyekɔ, diidii buunu bulɛ otii kuonwii letikiti otii wɔ beelofo ni numbiɛtɛ anu. ");
INSERT INTO snw_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Nse otii wɔ mmle diele Yaa nfũ eekye, alaafuo lɛsalɛsaa le mmle ɔbla.” ");
INSERT INTO snw_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ninfɛ di banɔɔfotii nwu ladiki kanya alɛ, “Beelofofɔ di sikpile kamɛ feemuɔ! Afɔ nikomiɛ falɛ fatuo wo asaa ɛɛ, sɛɛ lɛ?” Ninfɛ baadiki nwɔ di Yuda batii kasiisakɔ nwu nɛ. ");
INSERT INTO snw_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu lanu alɛ baadiki osuɔtɔ nwu di kasiisakɔ lɛma kamɛ. Nioso, aanyɔɔ nii, ni aakaalɛ nwɔ alɛ, “Feefũ Otii Obi nwu feenu?” ");
INSERT INTO snw_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ninfɛ di osuɔtɔ nwu nkpo ladiki kanya alɛ, “Ɔnɔɔfo, tɔkɔ mi otiikle wɔ ale ni, mmle okle kafũ nwɔ nnu ni.” ");
INSERT INTO snw_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ninfɛ di Yesu latɔkɔ nwɔ alɛ, “Fatɔɔnyɔɔ kofokofoko. Nnwɔɔ ninle otii wɔ nikɔkakatɛkofɔ ni nɛ.” ");
INSERT INTO snw_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ni di osuɔtɔ nwu labuɛ alɛ, “Saate, lefũ lenu!” Ninfɛ aapɛ akunkyi di Yesu katũ aatansa nwɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ninfɛ di Yesu labuɛ alɛ, “Lɛwa kayi ka mmle nlɛ kɔmakanko alɛ, batii ba di anu lebiɛ ni ka-nya. Alɛ mba nikɔnya ni kafɔɔ anu kabiɛ ma.” ");
INSERT INTO snw_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Farisi batii ba niawɛ ni ninfa lanu ɔlaa wɔ di Yesu labuɛ nii, ni baakaalɛ nwɔ alɛ, “Beeye! Awo kafɔɔ banumbiɛtɛ bule?” ");
INSERT INTO snw_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ninfɛ di Yesu ladiki kanya alɛ, “Nse banumbiɛtɛ bile yi, se biekpi lɛpɔɔ. Kafɔɔ di obe wɔ biobuɛ bilɛ biɔnya ni kamaa, biekpi lɛpɔɔ.” ");
INSERT INTO snw_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesu latɔkɔ ma alɛ, “Nwaako kɔtɔkɔ ye nlɛ, otii lele ninanfe di kayoko abuo lefosoyo nwu nkpo kamɛ, eeyie di kɔba nwu suoto eebuo yi, yu ku asaa lalaasatɛ ale. ");
INSERT INTO snw_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Kafɔɔ otii wɔ nimafe ni di kayoko nwu nkpo ambuo nii, nnwɔɔ ninle bafoso nwu kpatɛ omu nɛ. ");
INSERT INTO snw_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Kayoko nyuntɛ nsɛkɛtɛ kayoko antɔɔ. Bafoso nwu nkpo nnu nwɔ sɛlɔ. Nse ɛɛlɛɛ ma ku leyooto le eetika ma nii, ankpaa ma andieko. ");
INSERT INTO snw_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Nse ɛɛkpaa ma eedieko yi, anleko ma katũ, bafoso nwu nkpo ntikanko nwɔ, diekye baye nwɔ sɛlɔ. ");
INSERT INTO snw_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Blɔbatikanko otii bamba, babatoso nwɔ, diekye baaye nwɔ sɛlɔ.” ");
INSERT INTO snw_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu lapɛ ma lɛkpa le mmle, kafɔɔ batanu lɛsaa le aatɔkɔ ma ni kasɔ. ");
INSERT INTO snw_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Nkpo oso Yesu lakple aatɔkɔ ma alɛ, “Nwaako kɔtɔkɔ ye nlɛ, ami ninle kayoko nwu nkpo lɛta bafoso nwu nɛ. ");
INSERT INTO snw_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Batii ba bamuu niale mi katũ baawa nii, bayu ku asaa balalaasatɛ baale. Nkpo oso bafoso nwu nkpo ditanu ma sɛlɔ. ");
INSERT INTO snw_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ami ninle kayoko nwu nkpo. Otii lele niefe di suoto nii eebuo, abawɛ nkpa. Ababuo andie, anwɛ alesaa biene kalekɔ. ");
INSERT INTO snw_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Yu nnwɔɔ ɔwa anwa amayu, anlo, anlalasa asaa. Kafɔɔ ami ɔwa lɛwa nlɛ batii kawɛ nkpa, nkpa be niewo ni niimu kamɛ. ");
INSERT INTO snw_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Ami ninle bafosokpatɛ biene nwu letuna nlɛ kokpi ni baafoso nwu nkpo disi nɛ. ");
INSERT INTO snw_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Otii wɔ beefũ kooto kanya ɔɔkpa ni bafoso, baafoso nwu nkpo diele nnwɔɔ omu bale oso, nse ɛɛnya ɔkplɛle kɔwa yi, antoso andiɛ bafoso nwu nkpo. Nkpo oso, ɔkplɛle nwu mmufũ bafoso nwu nkpo, ansamiisa ma ta aale ni bafoso nwu nkpo kpatɛ omu omu oso. ");
INSERT INTO snw_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Otii wɔ mmle ntoso ansifi, diekye koto kanya beefũ nwɔ ɔɔbla ɔkpɛ nwu nkpo. Diekye bafoso nwu nkpo ɔlaa dietika nwɔ di otu. ");
INSERT INTO snw_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Ami ninle bafosokpatɛ biene nwu. Fɛ mmle okle di Teete n-ye mi, di ami kafɔɔ n-ye nwɔ nii, nkpo okle kafɔɔ n-ye bafoso nii, mma kafɔɔ baye mi nɛ. Ni letuna nlɛ kokpi diisi lɛma nɛ. ");
INSERT INTO snw_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Bafoso bamba nkpe bale mi ni bale manansi ni di bafoso kɔba ko mmle kamɛ. Dikpe ni lɛkpaa ma lɛwako bɛɛbanu mi sɛlɔ, bamuu lɛma beekple bafoso banwii, beesiɛ di bafosokpatɛ onwii kalɔ. ");
INSERT INTO snw_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Teete mbɔmbɔ mi, diekye letuna nlɛ kɔyɔ nkpa nii nta, sɛmaa, ninkple nfũ mi. ");
INSERT INTO snw_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Diele otii kuonwii niefũ mi nkpa ninnɛɛ, kafɔɔ ami omu nietuna nlɛ kɔyɔ nta. Nwaako, nkpe osuku n-yɔ nkpa nii nta, nkpe osuku kafɔɔ nkple nfũ mi. Nle mmle di Teemi lekpee mi alɛ mbla nɛ.” ");
INSERT INTO snw_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yesu sɛlaa se mmle aabuɛ ni oso, kasɛ lakple kaabuo di Yuda batii ntɛɛ. ");
INSERT INTO snw_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Batii kpinwu kaamɛ lɛma latoobuɛ alɛ, “Ninwuna kpile ninsi nwɔ kaamɛ. Oobuo afĩi kafɔɔ! Be oso nfɛ buakple munyila muntɔɔkyɔɔ nwɔ atoko?” ");
INSERT INTO snw_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Kafɔɔ batii bamba latoobuɛ alɛ, “Otii wɔ di ninwuna kpile nsi nii, dilaafuo ɔkakatɛ fɛ mmle! Lɛ nfɛ di ninwuna kpile mafuo ɔta alɛ numbiɛtɛ nnya?” ");
INSERT INTO snw_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Yuda batii latoole dii lɛma le manlɛɛ ni Olekatakɔ Okleklesa Dii, baatɔɔta Yaa di Yerusalem. Lɛwɔɔfɔ obe kamɛ diale. ");
INSERT INTO snw_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ni di Yesu lakyɛ aatoofe di Yaa Olekatakɔ lɛba le bɔɔlɛɛ ni Salomo ablalakyi nɛ. ");
INSERT INTO snw_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ninfɛ di Yuda batii labamana nwɔ baakyi, ni baakaalɛ nwɔ alɛ, “Lɛ oso feediɛ wo buobu diisi nkpo? Tɔkɔ wo! Kubio afɔ ninle Kristo nwu nkpo?” ");
INSERT INTO snw_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ninfɛ di Yesu latɔkɔ ma alɛ, “Ntɔɔtɔkɔ ye ɔlaa wɔ mmle kofokofoko, kafɔɔ biloofũ mi binu. Asaa ya kɔbla nfe ni di Teemi osie kamɛ kodiki mi suoto kanya fiɛ. ");
INSERT INTO snw_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Kafɔɔ biloofũ binu, diekye biekye bafoso nii nwu nkpo kamɛ. ");
INSERT INTO snw_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Bafoso nii nnu mi sɛlɔ. N-ye ma, mma kafɔɔ batikankoe. ");
INSERT INTO snw_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nioso lɛta ma nkpa be ninnaa ni kaloo, blɔbawɔɔ diidii. Kuonwii kafɔɔ dilabafuo ma ɔkpafɛ ofũ mi ninnɛɛ kamɛ. ");
INSERT INTO snw_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Teemi niɛyɔ ma eekpee mi di nnɛɛ kamɛ, eemuɔ kafɔɔ alenke lɛsaa biala. Kuonwii kafɔɔ dilabafuo ma ɔkpafɛ ofũ di Teete nnɛɛ kamɛ diidii. ");
INSERT INTO snw_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ami ku Teete, onwii bule.” ");
INSERT INTO snw_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ninfɛ di Yuda batii nwu nkpo lakple baayɔ afuɔ alɛ bɔɔsafɔ Yesu nɛ. ");
INSERT INTO snw_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ninfɛ di Yesu labuɛ aatɔkɔ ma alɛ, “Ntɔɔbla sɛkpɛ biene kpinwu di anu lee letuo ye, nse di Teete lekpee mi alɛ mbla nii. Ɔmɛnle suoto oso biomiɛ bilɛ bisafɔ mi afuɔ?” ");
INSERT INTO snw_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ninfɛ di Yuda batii nwu nkpo ladiki kanya alɛ, “Buloomiɛ bulɛ busafɔ fɔ afuɔ di ɔkpɛ biene kuonwii suoto, kafɔɔ mbusuo ɔlaa wɔ feebuɛ ni oso! Diekye otii ko fale kafɔɔ fɔɔbla suoto falɛ Yaa fale!” ");
INSERT INTO snw_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ninfɛ di Yesu ladiki kanya alɛ, “Bɛɛkpana di kufiofa lee Kukũ kamɛ alɛ, Yaa lebuɛ alɛ, ‘Bite fɛ Yaa.’ ");
INSERT INTO snw_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Buye kafɔɔ bulɛ, ɔlaa wɔ Kɔɔkpana Klekle lebuɛ nii, kute nkpo obe lele. Yaa kafɔɔ lalɛɛ batii ba niafũ ni ɔlaa biene nwu alɛ, ‘Bite fɛ Yaa.’ ");
INSERT INTO snw_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Kafɔɔ ami yi, Teete niediki mi eekpee mi kayi ka mmle. Ni be oso nfɛ buobuɛ bilɛ, lebuɛ mbusuo ɔlaa ta lebuɛ nlɛ Yaa Obi nle? ");
INSERT INTO snw_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nse diele lɛsaa le di Teemi komiɛ alɛ mbla ni kɔbla yi, ni bitanfũ mi bianu. ");
INSERT INTO snw_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Kafɔɔ nse nni kɔbla yi, kuntɛ biefũ mi binu yi, ni biefũ sɛkpɛ se kɔbla ni binu. Ni bibatofo, minnu kasɔ kafɔɔ bilɛ, Teete nwu nkpo nsi mi kaamɛ, ami kafɔɔ nsi nwɔ kaamɛ.” ");
INSERT INTO snw_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Yuda batii nwu nkpo lamiɛ alɛ bookple mammufũ Yesu, kafɔɔ aadie ma kaamɛ aasifi. ");
INSERT INTO snw_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ni di Yesu lasifi aakple aalaataalɛ Yordan okle, aasifi lɛba le di Yohane Yaa Ntu Kpeesatɛ latookpeesa ni batii Yaa ntu saa, aalaasiɛ ninfa. ");
INSERT INTO snw_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Batii kpinwu lawa ɔkyɛ nɔɔ bababuɛ alɛ, “Yohane ditabla ɔkpɛ wɔ niabla ni ɔkpɛ kuonwii aatuo. Kafɔɔ sɛlaa se simuu aabuɛ ni di otii wɔ mmle suoto lɛwa kaanya nkpo.” ");
INSERT INTO snw_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ninfɛ baatii kpinwu lafũ Yesu baanu ninfa nɛ. ");
INSERT INTO snw_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Osuɔtɔ onwii baatɔɔlɛɛ ni Lasaro lakye okpoo wɔ baatɔɔlɛɛ ni Betania, latoofiɛ. Babilɛma sankobi banyɔ banwii niale ni Maria ku Marta kafɔɔ lasiɛ di okpoo nwu nkpo kamɛ. ");
INSERT INTO snw_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maria wɔ mmle niale otii wɔ niayɔ nɔnyi kɔnɔnkɔnɔ aakpete ni di Saate nkpaatũ aayɔ disi sinwini nɔɔ aasunsũ ni nɛ. Obilɛma suɔtɔbi niale Lasaro wɔ niatoofiɛ ni nɛ. ");
INSERT INTO snw_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Babilɛma sankobi nwu nkpo latika Yesu kanya alɛ, “Saate, siɛwo lɛfɔ bɔmbɔtɛ kofiɛ.” ");
INSERT INTO snw_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Obe wɔ di Yesu lanu ni kanya ka mmle, aabuɛ alɛ, “Lasaro ofiɛ wɔ mmle dilabale nwɔ kukpi kaloo. Kafɔɔ nle mmle lɛwa kaanya alɛ baayɔ mantakatɛsaa Yaa leyooto katoo. Diefe ni di nle mmle kamɛ kafɔɔ, baayɔ mantakatɛsa Yaa Obi nwu nkpo katoo.” ");
INSERT INTO snw_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu labɔmbɔ Marta ku obilɛma sankobi ku Lasaro osie kanya. ");
INSERT INTO snw_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Kafɔɔ aafũ kanya alɛ Lasaro kofiɛ nii, aasiɛ ninfũ aawɛ ni ayi anyɔ aakyakaa. ");
INSERT INTO snw_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Nni nkpo sɛmaa, ni aatɔkɔ basaateketetɛ nɔɔ alɛ, “Bita bukple busifi Yudea nfɛ.” ");
INSERT INTO snw_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ninfɛ di basaateketetɛ nɔɔ nwu nkpo ladiki kanya alɛ, “Saatuotɛ, kɔsanklo ko mmle di Yuda batii nwu nkpo ninfa lamiɛ alɛ bɔɔsafɔ fɔ afuɔ! Ni fookple fammiɛ falɛ fɔɔkyɛ nfa nɛ?” ");
INSERT INTO snw_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ninfɛ di Yesu ladiki kanya alɛ, “Diele lefosi ambombo anyɔ ninsi di dii kufĩ kamɛ? Nse otii nkyɛ di dii kamɛ diɛkpa ni oso yi, ántuula. Diekye kayi lɛkpa ntɔɔ antɔɔnya. ");
INSERT INTO snw_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Kafɔɔ nse akyɛ ku kakyɛ yi, antuula. Diekye, lɛkpa nsinnaa.” ");
INSERT INTO snw_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Obe wɔ di Yesu labuɛ ɔlaa wɔ mmle aaloo nii, aakple aabuɛ aakyakaa alɛ, “Siɛwo loo Lasaro kɔkyɔsĩi, kafɔɔ makyɛ naasɛnkɛsa nwɔ.” ");
INSERT INTO snw_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ninfɛ di basaateketetɛ nɔɔ ladiki kanya alɛ, “Saate, nse ɔkyɔsĩi ɔɔkyɔsĩi yi, ni dibayɔɔ nwɔ.” ");
INSERT INTO snw_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ɔlaa wɔ di Yesu latobuɛ ninle alɛ Lasaro ntookpi, kafɔɔ basaateketetɛ lanyu alɛ sɛkyɔsĩ fukuti suoto aatɔɔkakatɛ. ");
INSERT INTO snw_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Nioso Yesu latɔkɔ ma aatikiti alɛ, “Lasaro ntookpi. ");
INSERT INTO snw_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Kafɔɔ, aye oso, dilɛ alɛ ntawɛ ninfa fiɛ aakpi, ta mmle okle biafũ mi minnu nii. Bita bukyɛ ɔkyɛ nɔɔ.” ");
INSERT INTO snw_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ninfɛ di Toma wɔ bɔɔlɛɛni Lɛtabi latɔkɔ basaateketetɛ wo nɔɔ alɛ, “Bita awo kafɔɔ bukyɛ ku Saatuotɛ buɔlaakpi ku nnwɔɔ.” ");
INSERT INTO snw_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Obe wɔ di Yesu lakyɛ aalaabuo nii, aanu alɛ dii nwu nkpo niale dii naafa baakookaa ni Lasaro nɛ. ");
INSERT INTO snw_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Diedie ni di Betania diesifi ni Yerusalem, ditakyo. Lekyo kate fɛ akɔ anyɔ. ");
INSERT INTO snw_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Nioso Yuda batii kpinwu lakyɛ alɛ bɔɔlaakpee Maria ku Marta kɔnɛɛ kaafutu, ta obilɛma suɔtɔbi nwu nkpo kukpi oso. ");
INSERT INTO snw_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Obe wɔ di Marta lanu alɛ Yesu nfɛ kɔwa nii, ni aadie aalaakyako nwɔ nɛ. Kafɔɔ Maria lasiɛ leeyo. ");
INSERT INTO snw_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ninfɛ di Marta latɔkɔ Yesu alɛ, “Saate, nse fɛ faanwɛ ninfũ se obiloo diekpi! ");
INSERT INTO snw_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Kafɔɔ bia nle n-ye nlɛ, lɛsaa lele fɛɛkaalɛ Yaa, ababla anta fɔ.” ");
INSERT INTO snw_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ninfɛ di Yesu latɔkɔ nwɔ alɛ, “Obilee mataka ansiɛ nkpa.” ");
INSERT INTO snw_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ninfɛ di Marta ladiki kanya alɛ, “N-ye nlɛ abakple antaka di obe wɔ baakpi makple mantaka ni di Dii Yɛntɛle nwu nkpo suoto.” ");
INSERT INTO snw_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ninfɛ di Yesu latɔkɔ nwɔ alɛ, “Ami ninle otii wɔ nintakatɛsa ni baakpi nta ma ni nkpa nɛ. Otii lele niefũ mi eenu, kuntɛ eekpi, abasiɛ nkpa. ");
INSERT INTO snw_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Otii lele kafɔɔ ninkpe nkpa eefũ mi eenu yi, diidii kafɔɔ ɔlɔbakpi. Feefũ nle mmle feenu?” ");
INSERT INTO snw_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Obe wɔ di Yesu lakaalɛ nwɔ ni nkpo, ni di Marta ladiki kanya alɛ, “Yii, Saate, lefũ lenu nlɛ afɔ ninle Kristo, Yaa Obi wɔ beebuɛ bɛɛtɛ ni kofokofoko alɛ abawa ni kayi nɛ.” ");
INSERT INTO snw_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Obe wɔ di Marta labuɛ ɔlaa wɔ mmle aaloo nii, ni aakple aasifi aalaalɛɛ obilɛma Maria buɛɛ aatɔkɔ nwɔ alɛ, “Saatuotɛ ntɔbabuo, ɔɔkaalɛ fɔ disi kafɔɔ.” ");
INSERT INTO snw_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Obe wɔ di Maria lanu ni ɔlaa wɔ mmle, ni aapɛsɛwa aadie aalaakyakako nwɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Di obe nwu nkpo kamɛ, Yesu lakple aayila di lɛba le di Marta lakyɛ aalaakyakako nwɔ nii. Diekye ayibuo kakpayotũ nwu kamɛ. ");
INSERT INTO snw_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Obe wɔ di Yuda batii ba niawɛ ni leeyo ku Maria baatookpee nwɔ ni kɔnɛɛ kaafutu lanya alɛ aataka wla aadie nii, baatikanko nwɔ. Diekye baanyu alɛ, ɔkya katũ oofe, aanaawi kaku. ");
INSERT INTO snw_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Obe wɔ di Maria lalaadu ni lɛba le di Yesu layila ni, aanyɔɔ nii, nfanwu, ni aapɛ akunkyi kaatũ nɔɔ aabuɛ alɛ, “Saate, nse fɛ faanwɛ ninfũ nse obiloo diekpi!” ");
INSERT INTO snw_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Obe wɔ di Yesu lanya mmle okle di Maria latoowi ni ku mmle okle di Yuda batii ba kafɔɔ niatikanko nwɔ ni latoowi ko nwɔ nii, diakpanko nwɔ otu, ni aabla hũ di suoto nɔɔ kamɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ni aakaalɛ alɛ, “Ɔfɛ biakookaa nwɔ?” Ninfɛ baatɔkɔ nwɔ alɛ, “Saate, wa fabanyu.” ");
INSERT INTO snw_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ninfɛ di Yesu lawi nɛ. ");
INSERT INTO snw_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ninfɛ di Yuda batii nwu nkpo labuɛ alɛ, “Binyu mmle okle ambɔmbɔ nwɔ ni lo!” ");
INSERT INTO snw_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Kafɔɔ batii bawo kaamɛ lɛma labuɛ alɛ, “Aatikiti numbiɛtɛ anu. Ni be oso nfɛ atafuo ɔbla alɛ, Lasaro atankpi?” ");
INSERT INTO snw_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Diakple diakpanko Yesu di otu osie kanya, ni aakyɛ aalaadu ɔkya nwu niale ni ofuɔntuu, baayɔ difuɔ baatĩi ni kanya nɛ. ");
INSERT INTO snw_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ninfɛ di Yesu latɔkɔ ma alɛ, “Bikyisa difuɔ nwu di ɔkya nwu nkpo kanya.” Ninfɛ di Marta, kpi nwu nkpo obilɛma sankobi latɔkɔ nwɔ alɛ, “Saate, abakpete! Diekye miɛ ninle dii naafa buokookaa nwɔ ni nɛ!” ");
INSERT INTO snw_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ninfɛ di Yesu latɔkɔ Marta alɛ, “Nintɔkɔfɔ nlɛ nse feefũ feenu, fabanya Yaa osie wɔ ninkpe nwɔ ni?” ");
INSERT INTO snw_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ni baatii nwu nkpo lakyisa difuɔ nwu nkpo di ɔkya nwu kanya nɛ. Ninfɛ di Yesu latakatɛsa anu aanyu osi ni aabuɛ alɛ, “Teete, kɔpɛ fɔ sɛfa alɛ nse lɛlɛɛ fɔ fantuna mi. ");
INSERT INTO snw_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","N-ye nlɛ obe lele fantuna mi. Kafɔɔ kobuɛ ɔlaa wɔ mmle ta batii ba mmle nin-yɛ ni ninfũ oso, alɛ baatofo alɛ afɔ niekpee mi.” ");
INSERT INTO snw_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Obe wɔ aabuɛ ɔlaa wɔ mmle aaloo nii, ni aafaa osie kanya aabuɛ alɛ, “Lasaro yee, die fawa!” ");
INSERT INTO snw_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Nfanwu, ni aadie aawa nɛ. Akookaasaa ya baakookaa nwɔ ni lamimini nwɔ nnɛɛ ku nkpaa. Dibula le kafɔɔ baayɔ baamiminisa nwɔ anu latĩi nwɔ anu. Ninfɛ di Yesu latɔkɔ ma alɛ, “Bifukuti nwɔ asaa nwu di suoto, aatɔɔkyɛ.” ");
INSERT INTO snw_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Obe wɔ di Yuda batii ba niawa ni Maria nfũ lanya lɛsaa le di Yesu labla nii, kpinwu lafũ nwɔ baanu. ");
INSERT INTO snw_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Kafɔɔ bawo lasifi Farisi batii nfũ baalaatɔkɔ ma lɛsaa le di Yesu labla nii. ");
INSERT INTO snw_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Nkpo oso Farisi batii ku olebatatɛ banɔɔfo lakyaka ku Yuda batii batunletɛ ni baakaalɛ bawo alɛ, “Lɛ buɔbla? Diekye osuɔtɔ wɔ mmle ntɔɔbla sɛkpɛ se niɛbla ni ɔkpɛ kpinwu! ");
INSERT INTO snw_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nse buodiɛ nwɔ ɛɛkyɛ sitũ mmle okle yi, ni otii biala kamafũ nwɔ anu. Ni Roma batunletɛ mataka wo di suoto mamabiɛ Yaa Olekatakɔ loo ka mmle, ku Kale loo kamuu!” ");
INSERT INTO snw_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ni di onwii kaamɛ lɛma baatɔɔlɛɛ ni Kaiafa, aale ni Oletatɛ Nɔɔfo di lɛlɛɛ nwu kamɛ latɔkɔ ma alɛ, “Lɛsɔnu lee lekyo lo! ");
INSERT INTO snw_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Bieye bilɛ dilɛ dilenke alɛ otii onwii kakpi di kale kamuu disi alɛ batii bamuu kawɔɔ ni ɛɛ, sɛɛ lɛ?” ");
INSERT INTO snw_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Nwaako baabuɛ nii, atabuɛ ɔlaa wɔ mmle di nnwɔɔ omu nɔɔ suoto nɔɔ kamɛ. Kafɔɔ fɛ mmle aale Oletatɛ Nɔɔfo di lɛlɛɛ nwu nkpo kamɛ yi, ni aabuɛ ɔlaa aatɛ alɛ Yesu kɔwa ɔbakpi di Yuda batii bamuu disi nɛ. ");
INSERT INTO snw_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Diele kafɔɔ alɛ aakpi di lete lɛma disi. Kafɔɔ alɛ aasiisa Yaa babi ba niɛsasami ni di kayi ka mmle aba aba ambla ma onwii. ");
INSERT INTO snw_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Dieyɔ di dii nwu nkpo diasifi nii, ni di Yuda batii batunletɛ lakyako osuku omiɛ alɛ boolo Yesu nɛ. ");
INSERT INTO snw_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ta nle mmle oso, Yesu ditasinfuo ɔkyɛ otoofe di Yuda batii kamɛ lɛɛkpaka. Nkpo oso aadie ku basaateketetɛ nɔɔ baalaasiɛ di okpoo wɔ bɔɔlɛɛ ni Efraim, diɛtɛɛtɛɛ ni ɔfaafuu kamɛ. ");
INSERT INTO snw_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Di obe nwu nkpo kamɛ, Yuda batii Okpi Diisi Ofe Dii olebee ntɔɔtɛɛtɛɛ. Nioso batii kpinwu lakye kaasɔ nwu nkpo aba aba baakyɛ Yerusalem alɛ bɔɔlaabla suoto okleklesa ɔsaabla fiɛ di dii nwu nkpo olebee nwo. ");
INSERT INTO snw_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Obe wɔ baasi ni di Yaa Olekatakɔ nwu nkpo baatoowolaa Yesu, baatɔɔkaalɛ bawo alɛ, “Lɛ biɛɛnya, sɛɛ alabafuo dii le mmle nwu nkpo kalekɔ ɔwaɛ?” ");
INSERT INTO snw_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ni di olebatatɛ banɔɔfo ku Farisi batii lata letofo alɛ, nse otii owo n-ye nfũ di Yesu nkpe nii, aawa ababuɛ baakyɛ baalaamufũ nwɔ. ");
INSERT INTO snw_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ditoobu ayi akuɔ fiɛ di Okpi Diisi Ofe Dii ole nwu mawo nii, Yesu lakyɛ Lasaro nfũ di Betania okpoo, dile ni osuɔtɔ wɔ di Yesu lasɛnkɛsa ni kuukpi kamɛ. ");
INSERT INTO snw_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ni baawa alesaa baata Yesu ninfa nɛ. Marta niatɔɔsɛ alesaa nwu nkpo. Lasaro kafɔɔ lasiɛ di batii ba niatoole ni alesaa nwu nkpo kamɛ ku Yesu. ");
INSERT INTO snw_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ninfɛ di Maria layɔ nnɔnyi kɔnɔkɔnɔ be niefũ ni kɔya osie kanya lebo kplɛ baayɔ lɛsaa le bɔɔlɛɛ ni nard baabla nii aabakpete di Yesu nkpaatũ, ni aayɔ disi sinwini nɔɔ aasunsũ nɛ. Ni di nnɔnyi nwu nkpo ɔkɔnɔ lafũ leyo nwu nkpo kamɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ninfɛ di Yesu saateketetɛ onwii kaamɛ lɛma bɔɔlɛɛ ni Yuda Iskariot, nwɔ nimadiki nwɔ anta nii, labuɛ alɛ, ");
INSERT INTO snw_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Be lɛsaa oso manaayɔ nnɔnyi be mmle baasunsũ bawɛ batii alafa atiɛ dii kɔkpɛnto, bayɔ koto nwu nkpo bata bapiitɛ?” ");
INSERT INTO snw_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Aabuɛ ɔlaa wɔ mmle, diele alɛ aayɔ nwu ni ole di bapiitɛ suoto oso, kafɔɔ ta yu aale ni oso. Diekye nnwɔɔ nfũ di koto katofoe lɛma lawɛ nɛ. Aatooyu koto nwu nkpo kowo kaamɛ. ");
INSERT INTO snw_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ninfɛ di Yesu latɔkɔ nwɔ alɛ, “Bidiɛ nwɔ! Biɛtɔɔ aablako lɛsaa le eekookaa ɛɛta ni lekookaayi nii ɔkpɛ. ");
INSERT INTO snw_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Bapiitɛ nsi ye kaamɛ obe lele. Kafɔɔ ami, diele obe lele kamawɛ ye kaamɛ.” ");
INSERT INTO snw_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Obe wɔ di Yuda batii kpinwu lanu alɛ Yesu ntɔɔwa akpe ni di Betania, baakyɛ nfa. Diele alɛ Yesu lete oso baakyɛ nfa, kafɔɔ alɛ bɔɔlaanyu Lasaro wɔ aatakatɛsa aakyeko ni kukpi kamɛ. ");
INSERT INTO snw_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Nkpo oso olebatatɛ banɔɔfo labla disibu alɛ babalo Lasaro kafɔɔ. ");
INSERT INTO snw_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Diekye nnwɔɔ oso, Yuda batii latoosĩ ma, balaatoofũ Yesu baatoonu. ");
INSERT INTO snw_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Kaleesɛ, batii dikudi le niawa ni Okpi Diisi Ofe Dii kalekɔ nwu nkpo lanu alɛ, Yesu nfɛ kɔwa Yerusalem. ");
INSERT INTO snw_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Nkpo oso baabudi sɛkaafɛ, ni baadie baakyɛ baalaakyakako nwɔ, baatɔɔtaa siwidi alɛ, “Hosiana! Bitansa otii wɔ nikɔwa ni di Saate leyooto kamɛ! Bitansa Israel Batii Ɔka nwu!” ");
INSERT INTO snw_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu lawɛ bɔkɛɛ wɔ ninte ni fɛ lɛpɔnkɔbi aasiɛ ni di suoto fɛ mmle okle di Kɔkpana Klekle Kukũ labuɛ ni alɛ, ");
INSERT INTO snw_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Aye Sion batii, bitanyɛkɛ! Binyu Ɔka lee ninsi di bɔkɛɛ wɔ ninte ni fɛ lɛpɔnkɔbi suoto ɔɔwa nɛ.” ");
INSERT INTO snw_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Basaateketetɛ nɔɔ ditanu lɛsaa le mmle kasɔ kaasɔ kakyekɔ. Kafɔɔ obe wɔ di Yaa latakatɛsa Yesu aakyeko ni bakpi kamɛ aatɔɔ ni dibu yi, nfa nfɛ baanyuma alɛ Kɔkpana Klekle labuɛ ɔlaa wɔ mmle aakyeko suoto nɔɔ, nni batɔɔbla bɛɛtɔɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Batii ba niayila ni di Yesu ɔkyɛ fiɛ aalɛɛ Lasaro aakyeko ni ɔkya kamɛ, aasɛnkɛsa nwɔ aakyeko ni bakpi kamɛ, baakyɛ baalaabuɛ lɛsaa le niawa ni baakyakasa. ");
INSERT INTO snw_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Lɛsaa le oso di batii dikudi nwu nkpo lakyɛ baalaakyakako ni Yesu niale alɛ, baanu ɔkpɛ wɔ niabla ni ɔkpɛ wɔ aabla nii. ");
INSERT INTO snw_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Farisi batii latɔkɔ bawo alɛ, “Biɔnya, dilɔɔlɛ dita wo saa! Binyu batii bamuu kaayi ntoodie batikanko nwɔ!” ");
INSERT INTO snw_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Hela batii bawo lasiɛ di batii ba niakyɛ Yerusalem alɛ bɔɔlaatɔ ni Yaa di Okpi Diisi Ofe Dii nwu nkpo kamɛ. ");
INSERT INTO snw_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ni baakyɛ Filipo nfũ, nwɔ niakye ni Betsaida di Galilea kasɔ, baalaatɔkɔ nwɔ alɛ, “Ɔnɔɔfo, buomiɛ bulɛ bunya Yesu.” ");
INSERT INTO snw_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ninfɛ di Filipo lakyɛ aalaanya Andrea nɛ, ni baanyɔ lɛma baakyɛ baalaatɔkɔ Yesu nɛ. ");
INSERT INTO snw_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ninfɛ di Yesu ladiki kanya alɛ, “Obe nwu nkpo ntoowo alɛ baakpee Otii Obi nwu nkpo dibu kplɛ. ");
INSERT INTO snw_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nwaako kɔtɔkɔ ye nlɛ, nse bayipɛ dititabi kaasɔ dibuu yi, dititabi ninwii lete dile. Kafɔɔ nse batɔɔpɛ ni kaasɔ diebuu yi, fiɛ nfɛ nimakpɛ ninkple atitabi kpinwu. ");
INSERT INTO snw_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Otii lele niɛbɔmbɔ nkpa nɔɔ, abayu mi. Kafɔɔ otii lele niekyidi nkpa nɔɔ kaayi ka mmle yi, abakookaa mi anta nkpa be ninnaa ni kaloo. ");
INSERT INTO snw_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Otii lele nikomiɛ alɛ abla mi ɔkpɛ yi, aatikankoe. Diekye nfũ nkpe nii, nfa kafɔɔ di kpɛmblatɛ nii nwu nkpo kamawɛ nɛ. Otii biala kafɔɔ niɛbla mi ɔkpɛ yi, Teemi makpee nwɔ dibu. ");
INSERT INTO snw_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Nunua yi, otu nii kowi kaku. Be nfɛ nimbuɛ? Mbuɛ nlɛ, ‘Teete, tanta dibuo le mmle lawa mi di suoto’ ɛɛ, sɛɛ lɛ? Kafɔɔ nkpo oso lɛwa nɛ, alɛ kafe ni kaamɛ. ");
INSERT INTO snw_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Teete, takatɛsa leyooto lɛfɔ katoo!” Ninfɛ di sɛlɔ lakye osi siabuɛ alɛ, “Ntɔɔtakatɛsa ni katoo kofokofoko. Kamakple ntakatɛsa ni katoo kafɔɔ.” ");
INSERT INTO snw_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Batii dikudi le niayila ni ninfa lanu sɛlɔ nwu nkpo, ni baawo labuɛ alɛ kanto niekpududuu. Bawo kafɔɔ labuɛ alɛ, “Yaa tɔkyɛntɛ owo niɛkakatɛ ko nwɔ.” ");
INSERT INTO snw_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ninfɛ di Yesu latɔkɔ ma alɛ, “Diele ami oso di sɛlɔ se mmle ledie, kafɔɔ aye oso siedie. ");
INSERT INTO snw_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","“Obe ntoowo alɛ Yaa kakanko kayi ka mmle. Obe kafɔɔ ntoowo alɛ aatososa nwɔ nikole ni kayi ka mmle sɛka. ");
INSERT INTO snw_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nse batɔɔkɛnkɛ mi kaasɔ ka mmle suoto beesifiko osi yi, kamananfi batii bamuu nwako ɔkyɛ nii.” ");
INSERT INTO snw_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesu labuɛ ɔlaa wɔ mmle alɛ ɔɔyɔ antuo kukpi ko okle ɔɔwa ni ɔbakpi. ");
INSERT INTO snw_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ninfɛ di batii dikudi nwu nkpo ladiki kanya alɛ, “Buye di kufiofa loo kamɛ alɛ, Kristo nwu nkpo kamasiɛ nkpa ninnaa ni kaloo. Lɛ oso nfɛ foobuɛ falɛ Otii Obi nwu babatakatɛsa nwɔ katoo? Owe ninle Otii Obi nwu nkpo?” ");
INSERT INTO snw_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ninfɛ di Yesu ladiki kanya alɛ, “Lɛkpa nwu nkpo masiɛ ye kaamɛ di obe kakui kamɛ. Nioso obe wɔ di lɛkpa nwu nkpo nkpe nii yi, bidiki nkpaa bikyɛ. Nse diele nkpo, kale maloo ye. Otii wɔ kafɔɔ ninkyɛ ni diitunu kamɛ yi, aaye nfũ oofe nii. ");
INSERT INTO snw_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Nkpo oso bifũ lɛkpa nwu nkpo binu di obe wɔ dikpe ye ni diɔkyɛ, alɛ biakple lɛkpa kamɛ batii.” Obe wɔ di Yesu labuɛ ɔlaa wɔ mmle aaloo nii, ninfɛ aasifi aadiɛ ma aalaawofasa suoto nɛ. ");
INSERT INTO snw_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Nu di Yesu labla sɛkpɛ se niɛbla ɔkpɛ di anu lɛma yi, batafũ nwɔ baanu. ");
INSERT INTO snw_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ta mmle okle di Yaa Ɔlaa Buɛtɛtɛ Yesaia ɔlaa wɔ aabuɛ aatɛ ni kawa ni kaanya oso. Aabuɛ alɛ, “Saate, owe niefũ ɔlaa wɔ buabuɛ ni aanu? Owe kafɔɔ di Saate ladiki osie nɔɔ aatuo?” ");
INSERT INTO snw_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ta nkpo oso batafuo ofũ onu, diekye Yesaia lakple aabuɛ alɛ, ");
INSERT INTO snw_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Yaa lebiɛ ma anu, alɛ blaanya asaa ku anu lɛma. Ɛɛta ma bɛɛwɛ setokopĩ, alɛ blaanu sɛlaa. Yaa labuɛ alɛ, ‘Blabamunikĩi bawa ɔkyɛ nii, alɛ kayɔɔsa ma sifiɛ.’ ” ");
INSERT INTO snw_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yesaia labuɛ ɔlaa wɔ mmle, diekye aanya Yesu leklekle, ni aabuɛ ɔlaa aakyeko suoto nɔɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Nu diate nkpo, Yuda batii batunlete kpinwu lafũ Yesu baanu. Kafɔɔ batafuo odiki obuɛ di lɛkpaka. Diekye baatɔɔyɛkɛ alɛ Farisi batii matososa ma di kasiisakɔ lɛma nwu nkpo kamɛ. ");
INSERT INTO snw_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Diekye mambɔmbɔ alɛ batii katansa ma manlenkee alɛ, Yaa katansa ma. ");
INSERT INTO snw_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesu labuɛ ku sɛlɔ siene alɛ, “Otii lele niefũ mi eenu yi, diele lete nii eefũ eenu. Kafɔɔ ku otii wɔ niekpee mi ni kafɔɔ eefũ eenu. ");
INSERT INTO snw_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Otii lele niɛnyɛɛ yi, ɛɛnya otii wɔ kafɔɔ niekpee mi nii. ");
INSERT INTO snw_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Lɛwa kayi ka mmle fɛle lɛkpa. Alɛ otii lele niefũ mi eenu yi, ɔlɔbasiɛ di ditunu kamɛ. ");
INSERT INTO snw_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Nse otii owo lenu mi ɔlaa anankyɔɔ nwu atoko yi, diele ami nimalo nwɔ lɛpɔɔ. Diekye ninwa kayi ka mmle nlɛ kamalo batii lɛpɔɔ, kafɔɔ ɔwa lɛwa nlɛ kɔmata ma nkpa. ");
INSERT INTO snw_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Otii lele niesĩ mi ananfũ mi ɔlaa anu yi, otii wɔ nimalo nwɔ ni lɛpɔɔ nkpe. Sɛlaa se lebuɛ ni nimalo nwɔ lɛpɔɔ di dii yɛntɛle nwu nkpo suoto. ");
INSERT INTO snw_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Diekye nwaako katɔkɔ ye nii, diele ami omu osie layɔ lakakatɛ. Kafɔɔ Teete wɔ niekpee mi ni niatɛɛ ɔlaa wɔ dikpe ni kabuɛ ni ku mmle labuɛ nwu nii. ");
INSERT INTO snw_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","N-ye nlɛ sɛlaa nɔɔ nwu nkpo ninta nkpa be ninnaa ni kaloo. Nkpo oso sɛlaa se labuɛ nii, labuɛ sĩ fɛ mmle okle di Teete lakpee mi alɛ mbuɛ sĩ nii.” ");
INSERT INTO snw_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Fiɛ kaale masɛ manle ni Okpi Diisi Ofe Dii nwu nkpo yi, Yesu latofo alɛ obe ntoowo alɛ nfɛ aadie kaasɔ ka mmle suoto, ansifi Ote nfũ. Aabɔmbɔ batii ba niale nwɔ ni bale kaasɔ ka mmle suoto obe lele. Aabɔmbɔ ma aalaase kaayɛntɛlekɔ. ");
INSERT INTO snw_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Kɔtɔɔfɔ nwu nkpo, Yesu ku basaateketetɛ nɔɔ lasiɛ baatoole alesaa. Di obe nwu nkpo kamɛ Abonsam ntɔɔyɔ eekpee di Yuda wɔ niale ni Simon Iskariot obi disi kamɛ kofokofoko alɛ aadiki Yesu anta. ");
INSERT INTO snw_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu latofo alɛ Ote lɛyɔ osie omuu eekpee nwɔ di nnɛɛ kamɛ. Aatofo alɛ Yaa nfũ aakye, ɔkyɛ nɔɔ kafɔɔ ookple anfe. ");
INSERT INTO snw_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Nkpo oso aataka di alesaa nwu nkpo kalekɔ, aadiki osi awu nɔɔ aatɛ, aayɔ ɔsa aanii ɔtɔ. ");
INSERT INTO snw_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ninfɛ aanyɛɛnɛ ntu aakpete di bɛɛsi kamɛ, ni aakyako basaateketetɛ nɔɔ nkpaa ofoto nɛ. Ni aayɔ ɔsa wɔ aanii ni ɔtɔ aatoosunsũ ma nkpaa nɛ. ");
INSERT INTO snw_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Obe wɔ di Yesu labadu ni Simon Petro suoto yi, Petro lakaalɛ nwɔ alɛ, “Saate, ami nkpaa fɔɔwa ɔbafoto?” ");
INSERT INTO snw_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ninfɛ di Yesu latɔkɔ nwɔ alɛ, “Floonu lɛsaa le kɔbla ni kasɔ, kafɔɔ sɛmaa yi, fabanu kasɔ.” ");
INSERT INTO snw_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ninfɛ di Petro latɔkɔ nwɔ alɛ, “Diidii, namata fɔ fafoto mi nkpaa!” Ninfɛ di Yesu latɔkɔ nwɔ alɛ, “Nse faatɛɛ osuku nfotofɔ nkpaa yi, ni flabasinfuo mi saateketetɛ ole.” ");
INSERT INTO snw_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Nkpo oso, Petro latɔkɔ nwɔ alɛ, “Saate, nse nkpo kute, ni tanfoto mi nkpaa lete. Foto mi nnɛɛ ku disi kafɔɔ!” ");
INSERT INTO snw_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ninfɛ di Yesu latɔkɔ nwɔ alɛ, “Otii lele nintookpe ntu kamaa, atoodie ntu okpe, nkpaa lete nfɛ aafoto. Aye yi, bitoodie klekle, diediki otii onwii lete.” ");
INSERT INTO snw_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Diekye Yesu latofo otii wɔ nimadiki nwɔ anta nii, nkpo oso aabuɛ alɛ, “Bamuulee biedie klekle, diediki otii onwii lete.” ");
INSERT INTO snw_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Obe wɔ di Yesu ntooloo ma ni nkpaa ofoto yi, aakplesa osi awu nɔɔ nwu nkpo aakpee, ni aakple aalaasiɛ kaasɔ nɛ. Ni aakaalɛ basaateketetɛ nɔɔ nwu nkpo alɛ, “Bienu lɛsaa le lɛbla lɛta ye ni kasɔ? ");
INSERT INTO snw_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Minlɛɛ mi bilɛ Saatuotɛ ku Saate. Osuku kule minlɛɛ mi nkpo, diekye otii nwu okle nle nɛ. ");
INSERT INTO snw_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nse, ami Saate lee ku Saatuotɛ, ntoofoto ye nkpaa yi, ni dikpe ni ayee, biefoto bawo nkpaa. ");
INSERT INTO snw_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ntɔɔbla ɔtɛ onyu lɛta ye alɛ, ayee biabla fɛ mmle okle lɛbla lɛta ye nii. ");
INSERT INTO snw_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nwaako kɔtɔkɔ ye nlɛ, kpɛmblatɛ kuonwii dielenke saate nɔɔ. Nkpo okle kafɔɔ di tɔkyɛntɛ ninlenkee otii nwɔ niekpee nwɔ ni kɔtɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nunua nfɛ biye ni lɛsaa le dikpe ni biɛbla nii, suoto mayɔɔ ye nse biɛyɔ biekpee di ɔkpɛ ɔbla kamɛ. ");
INSERT INTO snw_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ɔlaa wɔ mmle kobuɛ nii, diele bamuu lee nlaka. Diekye n-ye mba lediki nii. Dikpe ni Kɔkpana Klekle Kukũ kamɛ sɛlaa se bɛɛkpana ni lɛwa kaanya alɛ, ‘Otii wɔ munko nwɔ buokpee kɔnɛɛ kaasɛfɛ buole ni lɛtaka eeyila mi di suoto.’ ");
INSERT INTO snw_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Kole katũ ntɔkɔ ye sɛlaa se mmle ntɛ fiɛ simawa kaanya. Nse siɛbaawa kaanya yi, ni bibafũ mi minu bilɛ nle Otii wɔ nnle nii. ");
INSERT INTO snw_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nwaako kɔtɔkɔ ye nlɛ otii lele niefũ otii wɔ lekpe ni kɔtɔ yi, ami eefũ. Otii lele kafɔɔ niefũ mi yi, eefũ otii wɔ niekpee mi ni kɔtɔ.” ");
INSERT INTO snw_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Obe wɔ di Yesu labuɛ sɛlaa se mmle aaloo nii, aabuo nyaami osie kanya di otu kamɛ. Ni aadiki kanya alɛ, “Nwaako kɔtɔkɔ ye nlɛ otii onwii kaamɛ lee madiki mi anta.” ");
INSERT INTO snw_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Diabla basaateketetɛ nwu ɔkpɛ, ni baamunikĩi baatoonyu bawo di anu nɛ. Diekye batatofo owe lɛma di Yesu lalaka. ");
INSERT INTO snw_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Basaateketetɛ nwu nkpo onwii lɛma, nwɔ di Yesu mbɔmbɔ ni lasiɛ di Yesu ɔlɔɔkɔ tintintĩ. ");
INSERT INTO snw_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ninfɛ di Simon Petro lamunaasa anu aakpee nwɔ alɛ, “Kaalɛ nwɔ otii wɔ alaka ni.” ");
INSERT INTO snw_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ta nkpo oso saateketetɛ nwu nkpo lakɛnsa simu aakyɛnko Yesu ɔlɔɔkɔ, ni aakaalɛ nwɔ alɛ, “Saate, owe dile?” ");
INSERT INTO snw_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ninfɛ di Yesu ladiki kanya alɛ, “Otii wɔ kamayɔ alesaa nnyɔ kuutu nta nii, nnwɔɔ nɛ.” Ninfɛ aabɛ alesaa nwu kakyɛ aanyɔ kuutu aayɔ aata Yuda wɔ ninle ni Iskariot obi nɛ. ");
INSERT INTO snw_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Nfanwu di Yuda lafũ ni alesaa nwu nkpo, ni di Satana layie aabuo nwɔ kaamɛ nɛ. Ninfɛ di Yesu latɔkɔ nwɔ alɛ, “Pɛsɛwa, faabla lɛsaa le falɛ fɔɔbla ni.” ");
INSERT INTO snw_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Kafɔɔ kuonwii lɛma di alesaa kalekɔ nwu nkpo ditanu kasɔ lɛsaa le oso di Yesu latɔkɔ ni Yuda ɔlaa nwu nkpo. ");
INSERT INTO snw_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Basaateketetɛ nwu nkpo bawo lanyu alɛ di Yuda ninkle ma ni koto katofoe oso, loo Yesu ɔtɔkɔ aatɔkɔ nwɔ alɛ, atɔɔkyɛ alaaya asaa ya babayɔ manle ni dii nwu nkpo awako. Ee alaayɔ koto kowo akyɛnko bapiitɛ. ");
INSERT INTO snw_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Di Yuda lafũ alesaa nwu nkpo aaloo nii, nfanwu, ni aadie aasifi nɛ. Obe nwu nkpo kafɔɔ kale ntooloo. ");
INSERT INTO snw_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Di obe wɔ di Yuda ntoosifi nii, ninfɛ di Yesu labuɛ alɛ, “Nunua batɔɔtakatɛsa Otii Obi nwu leyooto katoo, diefe ni di suoto nɔɔ kafɔɔ batɔɔtakatɛsa Ote leyooto katoo. ");
INSERT INTO snw_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ni nse batɔɔtakatɛsa Yaa leyooto katoo diefe ni di Obi nwu suoto, ni Yaa kafɔɔ matakatɛsa Obi nwu nkpo leyooto katoo diefe ni di suoto nɔɔ. Ababla ni kafɔɔ ku nkye. ");
INSERT INTO snw_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Babi nii, namasinsiɛ diɛ ɔkyɛ lee nklɛ. Bibawolaa mi. Sɛlaa se latɔkɔ ni Yuda batii banɔɔfo, nsinwu kafɔɔ kɔtɔkɔ ye nunua nlɛ, ‘Lɛba le kofe nii, bilabafuo nfa ɔkyɛ.’ ");
INSERT INTO snw_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Nunua yi, kufiofa fɔle kɔta ye. Bibɔmbɔ bawo! Fɛ mmle okle labɔmbɔ ye nii, nkpo okle yekpe ni biɛbɔmbɔ bawo nɛ. ");
INSERT INTO snw_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nse mimbɔmbɔ bawo yi, ni batii bamuu manya alɛ kubio basaateketetɛ nii bile.” ");
INSERT INTO snw_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ninfɛ di Petro lakaalɛ nwɔ alɛ, “Saate, ɔfɛ foofe?” Ninfɛ di Yesu ladiki kanya aatɔkɔ nwɔ alɛ, “Lɛba le kofe ni nunua yi, flɔbafuo mi otikanko ɔwa. Kafɔɔ sɛmaa yi, fabatikankoe fanwa.” ");
INSERT INTO snw_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ninfɛ di Petro lakaalɛ nwɔ alɛ, “Saate, be oso ninaafuo fɔ otikanko nunua? Lelolaa suoto nlɛ kakpi bia diisi lɛfɔ!” ");
INSERT INTO snw_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ninfɛ di Yesu lakaalɛ nwɔ alɛ, “Kubio feelolaa suoto falɛ faakpi diisi nii? Nwaako kɔtɔkɔ fɔ nlɛ, fiɛ di kɔɔkɔ mabo nii, fababuɛ sitiɛ simu falɛ, faaye mi.” ");
INSERT INTO snw_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ninfɛ di Yesu latɔkɔ basaateketetɛ nɔɔ alɛ, “Bitanta otu lapɛ ye. Bifũ Yaa binu, biefũ ami kafɔɔ binu. ");
INSERT INTO snw_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Mbuokɔ kpinwu nkpe di Teemi leyo, kosifi ninaalolaa lɛba ntɛ ye. Nse kuote nkpo yi, namatɔkɔ ye. ");
INSERT INTO snw_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nse ntɔlalolaa lɛba lɛtɛ ye leloo yi, makple nwa makpaa ye nsifiko ɔkyɛ nii, alɛ nfũ nkpe nii yi, aye kafɔɔ bibasiɛ ninfa. ");
INSERT INTO snw_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Biye osuku wɔ nintika kuosifi ni nfũ kofe nii.” ");
INSERT INTO snw_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ni di Toma lakaalɛ nwɔ alɛ, “Saate, munanye nfũ foofe nii, lɛ dibabla fiɛ bubatofo osuku nwu nkpo?” ");
INSERT INTO snw_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ninfɛ di Yesu latɔkɔ nwɔ alɛ, “Ami ninle osuku nwu, onukware nwu, ku nkpa nwu nɛ. Otii kuonwii dilɔbafuo Teete nfũ ɔkyɛ diediki eefe di suoto nii. ");
INSERT INTO snw_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nse fɛ biye mi yi, nse biye Teete nwu kafɔɔ. Kafɔɔ diɛyɔ ni nunua, nfɛ biye nwɔ, bitɔɔnyɔɔ kafɔɔ.” ");
INSERT INTO snw_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ninfɛ di Filipo latɔkɔ Yesu alɛ, “Saate, tuo wo Teete nwu nkpo, nse nfɛ dipɔ wo.” ");
INSERT INTO snw_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ninfɛ di Yesu ladiki kanya alɛ, “Filipo, obe kpinwu wɔ ntoosiɛko ni bamuu lee diɛbase bia nua, be oso fanayitofo mi? Otii lele nintɔɔnyɛɛ yi, atɔɔnya Teete nwu kafɔɔ. Ni be oso fookple fambuɛ falɛ, ‘Tuo wo Teete nwu nkpo’? ");
INSERT INTO snw_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Sɛɛ Filipo, faafũ fanu falɛ nsi di Teete nwu nkpo kamɛ, Teete nwu nkpo kafɔɔ nsi mi kaamɛ? Sɛlaa se latɔkɔ ye ni yi, siékye ɔkyɛ nii. Kafɔɔ Teete wɔ ninsi mi ni kaamɛ nikɔbla ɔkpɛ nɔɔ. ");
INSERT INTO snw_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Bifũ mi binu nse lɛtɔkɔ ye nlɛ nsi di Teete kamɛ, nnwɔɔ kafɔɔ asi mi kaamɛ. Nse biéfũ sɛlaa se mmle binu yi, ni bifũ binu ta sɛkpɛ se kɔbla ni oso. ");
INSERT INTO snw_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Nwaako kɔtɔkɔ ye nlɛ otii lele niefũ mi eenu, ababla asaa ya lɛbla nii. Nwaako ababla bia n-ya ninlenke nii, diekye nfɛ kosifi Teete nfũ. ");
INSERT INTO snw_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Lɛsaa lele kafɔɔ biɛkaalɛ di leyooto nii kamɛ kamabla, alɛ baatakatɛsa Teete leyooto katoo diefe ni di Obi nwu suoto. ");
INSERT INTO snw_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Lɛsaa lele biɛkaalɛ mi leeyooto nii kamɛ, kamabla nta ye.” ");
INSERT INTO snw_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Yesu lakpe aabuɛ alɛ, “Nse mimbɔmbɔ mi yi, bibale mi afiofa. ");
INSERT INTO snw_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ni kamakaalɛ Teete anta ye Kyakaakotɛ bamba wɔ nimasiɛko ye ni obe lele. ");
INSERT INTO snw_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Nnwɔɔ ninle Ninwuna le nindiki antuo ɔlaa nukwale di Yaa suoto nɛ. Kayi ka mmle dilabafuo nwɔ ɔnya ee atofo nwɔ. Kafɔɔ aye biye nwɔ, diekye akpe ye diɔkyɛ, asi ye kaamɛ kafɔɔ. ");
INSERT INTO snw_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Nse lesifi yi, namadiɛ ye fɛ bakuɛbi. Kamakple nwa ɔkyɛ lee. ");
INSERT INTO snw_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Di obe kakui kamɛ kayi ka mmle dilabasinyɛɛ. Kafɔɔ aye bibanyɛɛ. Ta nkpe ni nkpa kafɔɔ oso ayee, bibasiɛ nkpa. ");
INSERT INTO snw_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Nse dii nwu nkpo lewo yi, bibatofo bilɛ nsi di Teemi kamɛ, ayee kafɔɔ bisi mi kaamɛ, fɛ mmle okle nsi ye ni kaamɛ. ");
INSERT INTO snw_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Otii lele niefũ mi afiofa eele nya yi, nnwɔɔ ninle otii wɔ nimbɔmbɔ mi ni nɛ. Teemi kafɔɔ mabɔmbɔ otii wɔ nimbɔbɔ mi nii. Ami kafɔɔ kamabɔmbɔ nwɔ ndiki suoto nii kafɔɔ ntuo nwɔ.” ");
INSERT INTO snw_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yuda, diele nwɔ ninle ni Iskariot labuɛ alɛ, “Saate, lɛ dibawa alɛ fabadiki suoto fantuo wo alɛ kayi ka mmle batii dilabanya fɔ?” ");
INSERT INTO snw_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ninfɛ di Yesu ladiki kanya alɛ, “Otii lele nimbɔmbɔ mi yi, abakyɔɔ mi asaa otuo kotoko. Teemi kamabɔmbɔ nwɔ, nse Teemi ku ami omu, butɔɔwa ɔkyɛ nɔɔ buɔbadiki nwɔ kasiɛ. ");
INSERT INTO snw_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Otii lele kafɔɔ ninambɔmbɔ mi yi, ankyɔɔ mi asaa otuo kotoko. Asaa otuo ya kafɔɔ bienu mi letuo ni yi, aale ami omu asaa otuo, kafɔɔ Teete wɔ niekpee mi ni asaa otuo ale. ");
INSERT INTO snw_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Ntɔɔtɔkɔ ye sɛlaa se mmle di obe wɔ lekple nkpe ye ni diɔkyɛ. ");
INSERT INTO snw_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Kyakaakotɛ wɔ ninle ni Ninwuna Klekle di Teete makyesee ye ni di leyooto nii kamɛ, kamatuo ye lɛsaa biala, anta ye minyuma sɛlaa se simuu ntɔɔtɔkɔ di nii. ");
INSERT INTO snw_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Atoko ɔkyɛ ole ninle lɛsaa le kodiɛko ye nii. Ami omu atoko ɔkyɛ ole kɔyɔ nta ye. Nɔɔyɔ nta ye fɛ mmle okle di kayi nn-yɔ kanta nii. Bitanta otu lapɛ ye biabu diisi, bitanyɛkɛ. ");
INSERT INTO snw_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Bienu lebuɛ lɛtɔkɔ ye nlɛ, ‘Nfɛ kosifi, kafɔɔ makple nwa ye ɔkyɛ.’ Nse mimbɔmbɔ mi yi, suoto kamayɔɔ ye alɛ nfɛ kokple nsifi Teete nfũ. Diekye ɛɛtakakatoo alenke mi. ");
INSERT INTO snw_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ntɔɔtɔkɔ ye sɛlaa se mmle simuu fiɛ sibawa kaanya, ni nse siɛbawa kaanya yi, bibafũ minnu. ");
INSERT INTO snw_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Namasinfuo okple ɔkakatɛko ye ɔkyɛnko sitũ, diekye kayi ka mmle tunletɛ nfɛ kɔwa. Anaa osie kuonwii di suoto nii, ");
INSERT INTO snw_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Kafɔɔ dikpe ni kayi ka mmle letofo alɛ mbɔmbɔ Teete nwu nkpo, nkpo oso kɔbla lɛsaa biala fɛ mmle okle eekpee mi ni nɛ. “Yoo, biwa buɔɔkyɛ ninfũ busifi.” ");
INSERT INTO snw_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Ami ninle kolewoso nwaa nwu nkpo nɛ, Teemi kafɔɔ ninle alewoso nwu kofe kpɛntɛ. ");
INSERT INTO snw_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ɔla lele ninka mi di suoto kunootika abi kamaa, ambudi nwu an-yu. Olele kafɔɔ nikotika abi, ambɛblɛ nwu alɛ kuaklekle kuntika abi kumpɔɔsa. ");
INSERT INTO snw_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Batookleklesa ye suoto kofokofoko di asaa ya letuo ye ni suoto oso. ");
INSERT INTO snw_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Bibla onwii ku ami, ni amii mabla onwii ku aye. Diekye ɔla kuonwii ninfuo abi otika di nwu omu suoto, nse kuɔɔka di kowoso suoto. Nkpo okle kafɔɔ di ayee, bilɔbafuo abi otika nse biɛɛbla onwii ku ami nɛ. ");
INSERT INTO snw_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Ami ninle kolewoso nwu nkpo, ni di ayee bile sɛla nɛ. Olele niɛbla onwii ku ami, di amii labla onwii ku nnwɔɔ yi, abatika abi kpinwu. Diekye bilabafuo lɛsalɛsaa ɔbla nse ninsi kaamɛ. ");
INSERT INTO snw_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Otii lele ninambla onwii ku ami yi, mambudi nwɔ man-yu fɛ owosola kunkoso. Mansiisa sewosola nwu nkpo mankpee sĩ ɔtɔ sinfiɛ. ");
INSERT INTO snw_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Nse biɛbla onwii ku ami, di ɔlaa ni kafɔɔ nsi ye kaamɛ yi, ni biɛkaalɛ lɛsaa lele biomiɛ, kamabla nta ye. ");
INSERT INTO snw_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nse biotika abi kpinwu yi, dibata batii ntakatɛsa Teemi leyooto katoo. Ni diotuo kafɔɔ alɛ basaateketetɛ nii bile. ");
INSERT INTO snw_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Mbɔmbɔ ye fɛ mmle okle di Teete mi mbɔmbɔ mi nii. Nkpo oso bisiɛ di lɛbɔmbɔ nii nwu kamɛ alɛ kabɔmbɔ ye obe lele. ");
INSERT INTO snw_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nse biole mi afiofa yi, ni bibasiɛ mi di lɛbɔmbɔ nwu kamɛ, fɛ mmle okle lele ni Teemi afiofa lesiɛ nwɔ ni di lɛbɔmbɔ kamɛ. ");
INSERT INTO snw_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Ntɔɔtɔkɔ ye sɛlaa se mmle alɛ suoto lɛyɔɔ nii kasiɛ ye kaamɛ, alɛ suoto lɛyɔɔ lee kafɔɔ kawo nimu. ");
INSERT INTO snw_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Kufiofa ko kokpee ye ni ninle nko mmle nɛ. Bibɔmbɔ bawo fɛ mmle okle labɔmbɔ ye ni. ");
INSERT INTO snw_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Lɛbɔmbɔ le niɛtaka katoo dilenke ni ninle alɛ otii kayɔ nkpa nɔɔ antɛ kaasɔ anta baawo nɔɔ disi. ");
INSERT INTO snw_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nse biɛbla di kufiofa nii ko mmle suoto, ni basiɛwo nii bile. ");
INSERT INTO snw_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Noosinlɛɛ ye nlɛ bakpɛmblatɛ nii bile, diekye kpɛmblatɛ dieye lɛsaa le di saate nɔɔ kɔbla nii. Nunua kɔlɛɛ ye nlɛ basiɛwo, diekye ntɔɔtɔkɔ ye lɛsaa biala lenu lekyeko ni Teemi nfũ. ");
INSERT INTO snw_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Diele aye niediki mi, kafɔɔ ami niediki ye nlɛ, bitɔɔkyɛ biɛlaatika abi kpinwu. Alɛ abi ya bibatika nii, baanya nya obe lele. Alɛ Teete nwu kamata ye lɛsaa lele biɛkaalɛ nwɔ di leyooto nii kamɛ. ");
INSERT INTO snw_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nkpo oso kufiofa ko kokpee ye ni ninle alɛ, bibɔmbɔ bawo.” ");
INSERT INTO snw_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Yesu lakple aabuɛ alɛ, “Nse kayi batii lekyidi ye yi, bitofo bilɛ batoole katũ beekyidi mi. ");
INSERT INTO snw_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nse fɛ onwii biɛbla ku kayi ka mmle batii di ɔsaabla lɛma kamɛ yi, bataba bɔmbɔ ye fɛle balema. Kafɔɔ lediki ye lekyeko ni kayi ka mmle batii kamɛ, minasinle ma ni bale oso yi, nkpo oso beekyidi ye nɛ. ");
INSERT INTO snw_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Binyuma ɔlaa wɔ latɔkɔ ye ni nlɛ, ‘Kpɛmblatɛ kuonwii dielenke saate nɔɔ.’ Nse baakpɛ mi kamaa, ni ayee, babakpɛ ye. Nse mankyɔɔ mi asaa otuo atoko yi, se aye kafɔɔ batabakyɔɔ ye ale atoko. ");
INSERT INTO snw_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Kayi batii mababla ye asaa ya mmle amuu ta balemi bile ni oso. Diekye baaye otii wɔ niekpee mi ni kɔtɔ. ");
INSERT INTO snw_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Nse nfɛ ntanwa labakakatɛ lata ma yi, nse batabalo ma okpile lɛpɔɔ. Kafɔɔ nunua mmle nfɛ dite nii, basinnaa osuku ɔkaalɛ kuonwii di sikpile lɛma suoto. ");
INSERT INTO snw_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Otii lele niekyidi mi kamaa, eekyidi Teemi kafɔɔ. ");
INSERT INTO snw_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nse fɛ ntambla ɔkpɛ wɔ di otii kuonwii diibla anya ni kaamɛ lɛma yi, nse baakpi okpile lɛpɔɔ ku ninwii. Kafɔɔ mmle nfɛ dite nii, batɔɔnya asaa ya amuu lɛbla nii, kafɔɔ beekyidi ami ku Teemi. ");
INSERT INTO snw_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Dikpe nii asaa ya mmle amuu lɛwa kaanya fɛ mmle okle bɛɛkpana ni Kɔɔkpana Klekle Kukũ kamɛ alɛ, ‘Beekyidi mi kasakasa.’ ");
INSERT INTO snw_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Kamakyesee ye kyakaakotɛ wɔ niekye ni Teete nfũ ninle ni Ninwuna Klekle le nindiki antuo ɔlaa nukwale di Yaa suoto nɛ. Nse ɛɛwa, abadiki mi suoto kanya anta ye nɛ. ");
INSERT INTO snw_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Aye kafɔɔ bibadiki mi suoto kanya minta batii, diekye bitɔɔwɛ di ɔkyɛ nii diɛyɔ ni bia kasɔ kakyekɔ.” ");
INSERT INTO snw_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Ntɔɔtɔkɔ ye sɛlaa se mmle simuu, mmle okle di nnɛɛ dilaafee ye ni di ofũ onu lee kamɛ. ");
INSERT INTO snw_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Babatososa ye mandiki di nsiisakɔ lɛma kamɛ. Obe kafɔɔ kɔwa, otii onwii kamalo ye, annyu alɛ Yaa ɔkpɛ ɔɔbla. ");
INSERT INTO snw_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Batii mabla ye asaa ya mmle, diekye baaye Teete nwu ee ami. ");
INSERT INTO snw_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Kafɔɔ ntɔɔtɔkɔ ye sɛlaa se mmle alɛ nse obe nwu nkpo lewo bɛɛbla nya yi, ni bibanyuma bilɛ latɔkɔ ye. “Ntatɔkɔ ye sɛlaa se mmle kaasɔ kakyekɔ diekye lawɛ di ɔkyɛ lee. ");
INSERT INTO snw_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Kafɔɔ nunua yi, nfɛ kosifi otii wɔ niekpee mi ni nfũ. Kafɔɔ kuonwii lee diɛkaalɛ mi nfũ kofe nii. ");
INSERT INTO snw_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Kafɔɔ nunua ntɔɔtɔkɔ ye nii, situ lee ntooyii pɔ ku sɛnyaami. ");
INSERT INTO snw_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Kafɔɔ nwaako kɔtɔkɔ nii, dilɛ diɛta ye alɛ lesifi. Diekye nse ninsifi, kyakaakotɛ nwu nkpo dilabawa ye ɔkyɛ. Kafɔɔ nse lesifi, kamanaa kyesee nwɔ anwa. ");
INSERT INTO snw_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Nse ɛɛwa, abadiki ntuo batii kaayi alɛ beekpi lɛpɔɔ siikpile suoto. Babatofo mmle kafɔɔ manankyɛ ni tinini, mantofo alɛ Yaa makanko ma kafɔɔ. ");
INSERT INTO snw_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Babakpi lɛpɔɔ ta okpile oso, diekye baafũ mi banu. ");
INSERT INTO snw_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Babatofo kafɔɔ alɛ baakyɛ tinini. Diekye, nfɛ kokple nsifi Teete nfũ. Bilabasinnyɛɛ kafɔɔ. ");
INSERT INTO snw_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Mantofo alɛ Yaa makanko ma kafɔɔ, diekye Yaa ntoolo otii wɔ ninle ni kayi ka mmle tunletɛ lɛpɔɔ kofokofoko. ");
INSERT INTO snw_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Nkpe sɛlaa kpinwu katɔkɔ ye nii, kafɔɔ nunua wɔ mmle yi, bilabafuo simuu kasɔ onu. ");
INSERT INTO snw_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Kafɔɔ nse Yaa Ninwuna le nindiki antuo ni ɔlaa nukwale di Yaa suoto lɛwa, abaleko ye katũ anta ye mintofo onukware nwu nkpo omuu. Diekye ɔlɔbakakatɛ di nnwɔɔ omu osie kamɛ, kafɔɔ abakakatɛ di nle eenu nii, antɔkɔ ye kafɔɔ asaa ya amuu nimawa nii. ");
INSERT INTO snw_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Abata mantakatɛsa mi leyooto katoo, diekye abayɔ ɔlaa wɔ lebuɛ ni antɔkɔ ye. ");
INSERT INTO snw_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Lɛsaa biala ninle Teete lele yi, ami nimba. Nkpo oso lɛtɔkɔ ye nlɛ, Ninwuna nwu nkpo mayɔ ɔlaa wɔ lebuɛ ni antɔkɔ ye.” ");
INSERT INTO snw_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yesu lakple aabuɛ alɛ, “Di obe kakui kamɛ yi, bilabasinnyɛɛ. Kafɔɔ dilabaklɛ bibakple minnyɛɛ.” ");
INSERT INTO snw_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ninfɛ di basaateketetɛ nɔɔ bawo lakaalɛ bawo alɛ, “Ɔlaa wɔ mmle obuɛ ni kasɔ mɔ? Diekye eebuɛ alɛ di obe kakui kamɛ bulabasinnyɔɔ. Kafɔɔ di obe kakuii kamɛ kafɔɔ bubakple munyɔɔ. Eekple eebuɛ kafɔɔ alɛ, ‘Diekye nfɛ kosifi Teete nfũ.’ ");
INSERT INTO snw_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ɔlaa wɔ eebuɛ alɛ, ‘Di obe kakui kamɛ’ ni be diotuo? Buoye be alaka!” ");
INSERT INTO snw_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu latofo alɛ basaateketetɛ nɔɔ lamiɛ alɛ bɔɔkaalɛ nwɔ ɔlaa di nni nkpo suoto. Nkpo oso, aakaalɛ ma alɛ, “Le buɛ nlɛ, ‘Di obe kakui kamɛ bilabasinnyɛɛ, di obe kakui kamɛ kafɔɔ, bibakple minnyɛɛ.’ Nwu suoto biɔkaalɛ bawo sɛlaa nɛ? ");
INSERT INTO snw_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nwaako kɔtɔkɔ ye nlɛ, bibawi kaku mimbuo sɛnyaami, kafɔɔ kayi batii mma, suoto nimayɔɔ ma. Bibabuo sɛnyaami, kafɔɔ sɛnyaami lee nwu nkpo makyi ninkple ye suoto lɛyɔɔ. ");
INSERT INTO snw_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Nse lɛmɛ ntoobe ɔsanko yi, ambuo nyaami, diekye obe nɔɔ ntoowo abanu ni dibuo. Kafɔɔ nse atoolofo obi nwu nkpo yi, aanyee dibuo nwu nkpo. Diekye suoto kɔyɔɔ nwɔ alɛ atoolofo obi ɛɛwako kayi ka mmle. ");
INSERT INTO snw_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Nkpo okle dite ye nɛ. Nunua yi, bitoobuo sɛnyaami, kafɔɔ makple nnya ye nii, situ lee mayii ku suoto lɛyɔɔ. Suoto lɛyɔɔ le okle di otii kuonwii dilabafuo ye ni ofũ ninnɛɛ diidii. ");
INSERT INTO snw_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Nse obe nwu nkpo lewo yi, bilabakaalɛ mi lɛsalɛsaa. Nwaako kɔtɔkɔ ye nlɛ, Teete mata ye lɛsaa lele biɛkaalɛ nwɔ di leyooto nii kamɛ. ");
INSERT INTO snw_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Diɛbase bia nua, biikaalɛ lɛsalɛsaa di leyooto nii kamɛ. Bikaalɛ, babata ye, di suoto lɛyɔɔ lee dibla nimu. ");
INSERT INTO snw_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Ntɔɔtɔkɔ ye sɛlaa se mmle lefenko di akpa kamɛ. Kafɔɔ obe kɔwa ninɔmasin-yɔ akpa nkakatɛ nta ye nii. Di obe nwu nkpo kamɛ, kamakakatɛ nta ye klekle di Teete suoto. ");
INSERT INTO snw_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Nse obe nwu nkpo lewo yi, bibakaalɛ nwɔ lɛsaa di leyooto nii kamɛ. Diele obuɛ kobuɛ nlɛ, ami kamakaalɛ nwɔ diisi lee. ");
INSERT INTO snw_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Diekye Teete nwu nkpo omu mbɔmbɔ ye. Ambɔmbɔ ye diekye mimbɔmbɔ mi, biefũ bienu kafɔɔ bilɛ ɔkyɛ nɔɔ lakye. ");
INSERT INTO snw_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nwaako Teete nfũ lakye lawa kayi ka mmle, nfɛ kokple ndie kaayi ka mmle nsifi Teete nwu nkpo nfũ.” ");
INSERT INTO snw_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ninfɛ di basaateketetɛ nɔɔ nwu latɔkɔ nwɔ alɛ, “Nunua nfɛ fɔɔkakatɛ fanta wo klekle ninanle ni akpa kamɛ. ");
INSERT INTO snw_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nunua, nfɛ buye bulɛ faye lɛsaa biala, diesinfĩ alɛ otii kuonwii kakple ankaalɛ fɔ ɔlaa kuonwii. Nle mmle lete ntɔɔta wo buofũ buonu bulɛ Yaa nfũ feekye.” ");
INSERT INTO snw_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ninfɛ di Yesu lakaalɛ ma alɛ, “Bitoofũ bienu nfɛ? ");
INSERT INTO snw_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Obe kɔwa, babasamiisa bamuu lee, obiala lee nsifi ni nnwɔɔ omu nɔɔ leyo mindiɛ mi nii. Obe nwu kafɔɔ ntoowo. Kafɔɔ nwaako diele lete nii ninsi, diekye Teete nsikoe. ");
INSERT INTO snw_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ntɔɔtɔkɔ ye ɔlaa wɔ mmle, mmle okle di atoko ɔkyɛ ole kasiɛko ye nii, ta mmle okle biɛbla ni onwii ku ami oso. Kayi ka mmle batii mata dibuo mbuo ye. Kafɔɔ bikpee otu! Diekye ntoolenkee kayi ka mmle!” ");
INSERT INTO snw_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Di obe wɔ di Yesu labuɛ salaa se mmle aaloo nii, ni aatakatɛsa anu aanyu osi ni aabuɛ alɛ, “Teete, obe nwu nkpo ntoowo. Takatɛsa Obi lɛfɔ nwu leyooto katoo, di Obi lɛfɔ nwu kafɔɔ atakatɛsa fɔ leyooto katoo. ");
INSERT INTO snw_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Diekye fɛɛtɔɔ osie di batii bamuu suoto falɛ, aata mba fɛɛyɔ fɛɛtɔɔ ni nkpa be ninnaa ni kaloo. ");
INSERT INTO snw_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Nkpa nwu nkpo ninnaa ni kaloo ɔwɛ ninle alɛ, batii katofo alɛ leete lɛfɔ pɛ ninle ni onukware Yaa, mantofo Yesu Kristo wɔ feekyesee nii. ");
INSERT INTO snw_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ntɔɔtakatɛsa fɔ leyooto katoo baatii kamɛ kaasɔ ka mmle suoto. Diekye ntooloo ɔkpɛ wɔ feekpee mi falɛ mbla ni ɔbla. ");
INSERT INTO snw_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Teete, nunua yi, kple fatakatɛsɛɛ leyooto katoo di anu lɛfɔ fɛ mmle okle late ni di obe wɔ lawɛ di ɔkyɛ lɛfɔ fiɛ faabla ni kayi. ");
INSERT INTO snw_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Ntoodiki fɔ letuo batii ba feediki fɛɛtɛɛ ni kaayi ka mmle kamɛ. Balefɔ bale, ni fɛɛyɔ ma fɛɛtɛɛ nɛ. Batɔɔkyɔɔ fɔ ɔlaa atoko. ");
INSERT INTO snw_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nunua kafɔɔ, nfɛ baye alɛ, lɛsaa biala fɛɛyɔ feekpee mi di nnɛɛ kamɛ, ɔkyɛ lɛfɔ diekye. ");
INSERT INTO snw_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ntɔɔyɔ ɔlaa lɛfɔ wɔ faayɔ faakpee mi ni ninnɛɛ falɛ nta ma ni lɛta ma, baafũ nwu kafɔɔ. Nfɛ baye kafɔɔ alɛ nwaako ɔkyɛ lɛfɔ lakye, beefũ beenu kafɔɔ alɛ afɔ niakpee mi kɔtɔ. ");
INSERT INTO snw_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Kɔpɛ ɔlaa nta diisi lɛma. Nɔɔpɛ ɔlaa nta di kayi kamuu batii disi, kafɔɔ mba fɛɛyɔ feekpee mi ni ninnɛɛ kamɛ disi kɔpɛ ɔlaa nta. Diekye balefɔ bale. ");
INSERT INTO snw_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","“Batii ba bamuu ninkpe mi nii, bale fɔ bale, mba kafɔɔ ninkpe fɔ nii, bale mi bale. Mma kamɛ bɛɛtakatɛsa leyooto nii katoo nɛ. ");
INSERT INTO snw_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Nunua kafɔɔ, nfɛ kokple nwa ɔkyɛ lɛfɔ. Ninsinsi kaayi ka mmle kamɛ, kafɔɔ mma basi. Teete Klekle, nyu ma ku leyooto lɛfɔ osie, dile ni leyooto le fɛɛtɛɛ nii. Di mmle okle baabla ni onwii, fɛ mmle okle di ami ku afɔ buɔbla ni onwii. ");
INSERT INTO snw_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Di obe wɔ lawɛ ni di ɔkyɛ lɛma yi, lanyu ma ku leyooto lɛfɔ nwu osie, dile ni leyooto le fɛɛtɛɛ nii. Laklee ma alɛ kuonwii lɛma ditayu, diediki nwɔ lete dikaatɛ alɛ ɛɛwɔɔ ni, Kɔɔkpana Klekle Kukũ kamɛ sɛlaa kawa ni kaanya. ");
INSERT INTO snw_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Nunua nfɛ kɔwa ɔkyɛ lɛfɔ. Nioso kobuɛ sɛlaa se mmle kaayi ka mmle kamɛ nɛ, mmle okle baawɛ ni suoto lɛyɔɔ nii siitu lɛma kamɛ ninwo ni nimu. ");
INSERT INTO snw_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ntɔɔyɔ ɔlaa lɛfɔ nwu nkpo lɛta ma. Ta nkpo oso kayi ka mmle lekyidi ma, diekye baasinle kayi ka mmle bale, fɛ mmle okle ninanle ni kayi ka mmle ole. ");
INSERT INTO snw_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","“Diele ɔkaalɛ kɔkaalɛ nlɛ faadiki ma kaayi ka mmle kamɛ. Kafɔɔ kɔkaalɛ nlɛ faanyu ma fandiki ma di Kyiditɛ nwu nkpo nnɛɛ kamɛ. ");
INSERT INTO snw_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Fɛ mmle okle ninanle ni kayi ka mmle ole yi, nkpo okle di mma kafɔɔ mananle kayi ka mmle bale nɛ. ");
INSERT INTO snw_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Bla ma klekle fata suoto di onukware nwu nkpo kamɛ. Ɔlaa lɛfɔ nwu ninle onukware nɛ. ");
INSERT INTO snw_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Kokpee ma kayi batii nfũ, fɛ mmle okle feekpee mi ni kayi batii nfũ. ");
INSERT INTO snw_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ta mma oso, labla suoto nii klekle lata fɔ, di mmle okle di mma kafɔɔ baabla ni suoto klekle di onukware nwu kamɛ. ");
INSERT INTO snw_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Nɔɔpɛ ɔlaa nta di lete lɛma disi, kafɔɔ ku mba nimafũ mi mannu ni di ɔlaa biene lɛfɔ nwu nkpo babatɔkɔ ma ni suoto. ");
INSERT INTO snw_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Teete, kɔpɛ ɔlaa nta nlɛ bamuu lɛma baabla onwii. Ta ma basiɛ wo kaamɛ, fɛ mmle okle fasi mi ni kaamɛ, di ami kafɔɔ nsi fɔ ni kaamɛ. Ta ma babla onwii alɛ kayi batii matofo alɛ kubio afɔ niekpee mi kɔtɔ. ");
INSERT INTO snw_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","“Leyooto biene le fɛɛyɔ fɛɛtɛɛ nii, nninwu okle lɛyɔ lɛta ma nɛ, alɛ baabla onwii, fɛ mmle okle munko fɔ buɔbla ni onwii. ");
INSERT INTO snw_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ami nsi ma kaamɛ, afɔɔ fasi mi kaamɛ, alɛ baabla onwii niimu kamɛ, mmle okle kaayi batii matofo alɛ nwaako afɔ niekpee mi kɔtɔ, fambɔmbɔ ma kafɔɔ fɛ mmle okle fambɔmbɔ mi nii. ");
INSERT INTO snw_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Teete, afɔ niɛyɔ ma fɛɛtɛɛ, nioso komiɛ nlɛ bawɛ ninfũ nkpe nii, alɛ baanya mmle okle fɛɛtakatɛsɛɛ ni leyooto katoo, dile ni leyooto le fɛɛtɛɛ nii. Diekye faabɔmbɔ mi fiɛ bia fɛɛbabla kayi. ");
INSERT INTO snw_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Teete, fate tinini. Kayi ka mmle batii dieye fɔ, kafɔɔ ami n-ye fɔ. Batii ba mmle kafɔɔ n-ye alɛ, afɔ niekpee mi kɔtɔ. ");
INSERT INTO snw_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Lediki fɔ letuo ma. Kamakple ntɔɔbla nkpo, mmle okle di lɛbɔmbɔ le fakpe fatɛɛ nii kamasiɛ ma ni kaamɛ, alɛ ami kafɔɔ kasiɛ ma ni kaamɛ.” ");
INSERT INTO snw_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Obe wɔ di Yesu lapɛ ɔlaa aata Yaa aaloo nii, manko basaateketetɛ nɔɔ baasifi baalaataalɛ kaklee ka baatɔɔlɛɛ ni Kedron. Nnɔnyi awoso kɔba kunwii lawɛ ninfa, ninfɛ di Yesu ku basaateketetɛ nɔɔ lasifi baalaabuo kũ kaamɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yuda wɔ niadiki nwɔ aata ni kafɔɔ n-ye nfa, diekye Yesu ku basaateketetɛ nɔɔ latɔɔkyaka ninfa obe lele. ");
INSERT INTO snw_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Nioso Yuda kafɔɔ lakyɛ kɔba nwu nkpo kamɛ, aalaakpaa Roma batii bakpɛtɛ dikudi ku Olekatakɔ banyuntɛ ba di olebatatɛ banɔɔfo ku Farisi batii lakpee nii. Baaklee bakandiɛ ku nka ku akpɛsaa. ");
INSERT INTO snw_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Di obe wɔ di Yesu latofo asaa ya amuu nimawa nwɔ ni di suoto oso yi, ni aadie aawa sitũ aabaakaalɛ ma alɛ, “Owe biowolaa?” ");
INSERT INTO snw_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ninfɛ baadiki kanya alɛ, “Yesu Nasaret Otii nwu buowolaa.” Ninfɛ di Yesu latɔkɔ ma alɛ, “Nyɛɛ ninfũ!” Yuda wɔ niadiki nwɔ aata ni kafɔɔ layila ma kaamɛ. ");
INSERT INTO snw_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Obe wɔ di Yesu latɔkɔ ma alɛ, “Nyɛɛ ni ninfũ” yi, bamuu lɛma baakple sɛmaa sɛmaa baanɔɔ baapɛ kaasɔ. ");
INSERT INTO snw_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yesu lakple aakaalɛ ma lɛyɔɔfa alɛ, “Owe biowolaa?” Ninfɛ baabuɛ alɛ, “Yesu Nasaret Otii nwu.” ");
INSERT INTO snw_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ninfɛ di Yesu latɔkɔ ma alɛ, “Ntɔɔtɔkɔ ye kofokofoko nlɛ nyɛɛ ninfũ.” Ninfɛ di Yesu lakple aatɔkɔ ma alɛ, “Nse nwaako ami biowolaa yi, ni biɛta batii ba mmle osuku baatɔɔkyɛ.” ");
INSERT INTO snw_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Yesu labuɛ ɔlaa nwu nkpo mmle okle di ɔlaa wɔ aabuɛ aatɛ ni kawa ni kaanya. Aabuɛ alɛ, “Teete, batii ba bamuu fɛɛyɔ fɛɛtɛɛ nii, ninta kuonwii lɛma ayu.” ");
INSERT INTO snw_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simon Petro laklee kapamii ninfa. Ninfɛ aadiki ka aasafɔ Oletatɛ Nɔɔfo kpɛmblatɛ koletanɛɛ kotoko aakpa nɛ. Kpɛmblatɛ nwu nkpo leyooto niale Malkus nɛ. ");
INSERT INTO snw_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ninfɛ di Yesu latɔkɔ Petro alɛ, “Kplesa kapamii lɛfɔ nwu nkpo fakpee di kotofo ko kamɛ feediki ka ni! Foonyu falɛ dibuo opũ wɔ di Teemi lɛyɔ ɛɛtɛɛ nii, namanyi nwu?” ");
INSERT INTO snw_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ninfɛ di Roma batii bakpɛtɛ ku ɔnɔɔfo lɛma ku Yuda batii asaa banyuntɛ lamufũ Yesu baanii nɛ. ");
INSERT INTO snw_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ninfɛ baakpaa nwɔ lɛkasale baakyɛnko Hana nfũ nɛ. Hana wɔ mmle niale Kaiafa ɔlɔ nɛ. Kaiafa wɔ mmle kafɔɔ niale Oletatɛ Banɔɔfo Nɔɔfo di lɛlɛɛ nwu nkpo kamɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaiafa wɔ mmle niata Yuda batii batunletɛ disibu alɛ dilɛ dilenke alɛ otii onwii kakpi di nnle mmuu disi. ");
INSERT INTO snw_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Petro ku saateketetɛ bamba onwii latikanko Yesu sɛɛmaa. Kafɔɔ saateketetɛ nwu nkpo yi, Oletatɛ Nɔɔfo nwu nkpo n-ye nwɔ nwaa, nkpo oso aatikanko Yesu baakyɛ baalaabuo Oletatɛ Nɔɔfo nwu nkpo kaflɔnkɔ. ");
INSERT INTO snw_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Kafɔɔ Petro nnwɔɔ, aayila kaayi di kayoko kplɛ ɔlɔɔkɔ. Ninfɛ di saateketetɛ bamba nwu nkpo lakple aadie aakyɛ kayi aalaakakatɛko ɔsankobi wɔ niayila ni di kayoko nwu kanya, ni aata Petro kafɔɔ labuo leyo nwu nkpo kaflɔnkɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Nfa nfɛ di ɔsankobi nwu niayila ni kaayoko nwu kanya lakaalɛ Petro alɛ, “Afɔ kafɔɔ diele osuɔtɔ nwu nkpo saateketetɛ onwii lɛma fale?” Ninfɛ di Petro labuɛ alɛ, “Kpa woo! Ninsi ma kaamɛ.” ");
INSERT INTO snw_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Lɛwɔɔfɔ lawɛ, nkpo oso bakpɛmblatɛ nwu nkpo ku basaanyuntɛ nwu lakutaa akaa ɔtɔ baamana nwu baakyi baatɔɔwɔfɔ nwu. Nkpo oso Petro kafɔɔ lakyɛ aalaayila ma di ɔlɔɔkɔ aatɔɔwɔfɔ ɔtɔ nwu. ");
INSERT INTO snw_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Oletatɛ Nɔɔfo lakaalɛ Yesu sɛlaa aakyeko basaateketetɛ nɔɔ suoto ku asaa nɔɔ otuo suoto. ");
INSERT INTO snw_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ninfɛ di Yesu ladiki kanya alɛ, “Obe lele latɔɔkakatɛ latɔɔta batii bamuu lɛɛkpaka. Latuo asaa kafɔɔ di Yuda batii nsiisakɔ ku Olekatakɔ lɛma, nfa di batii nwu bamuu masi nɛ. Ntabuɛ ɔlaa kuonwii kafɔɔ di lɛwofa kamɛ. ");
INSERT INTO snw_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ni be oso di ami nfɛ fɔɔkaalɛ sɛlaa? Kaalɛ batii ba nianu mi ni lɛkakatɛ. Mma yi, baye sɛlaa se labuɛ nii.” ");
INSERT INTO snw_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Obe wɔ di Yesu labuɛ ni ɔlaa wɔ mmle yi, basaanyuntɛ nwu nkpo onwii lɛma lapɛ Yesu kɔnɛɛ kootokosi aakaalɛ nwɔ alɛ, “Ɔmɛnsuku fakpe fandiki Oletatɛ Nɔɔfo kanya mmle okle?” ");
INSERT INTO snw_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ninfɛ di Yesu lakaalɛ nwɔ alɛ, “Nse lebuɛ ɔlaa wɔ ninanlɛ ni yi, faabuɛ fatɔkɔ otii biala ninfũ. Kafɔɔ nse ɔlaa wɔ kobuɛ ni ninte nkpo mɔ, ni be oso fɔɔpɛ mi?” ");
INSERT INTO snw_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ninfɛ di Hana lata baakpaa Yesu di lekpo le kamɛ baapɛ nwɔ ni baasifiko Oletatɛ Nɔɔfo Kaiafa nfũ nɛ. ");
INSERT INTO snw_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Di obe nwu nkpo kamɛ yi, Petro lakple aayila aatɔɔwɔfɔ ɔtɔ nwu. Ninfɛ di batii nwu nkpo lakaalɛ nwɔ alɛ, “Diele osuɔtɔ wɔ mmle saateketetɛ onwii lɛma fale?” Ninfɛ di Petro lasĩ abuɛ alɛ, “Kpa woo! Ninsi ma kaamɛ.” ");
INSERT INTO snw_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ninfɛ di Oletatɛ Nɔɔfo kpɛmblatɛ onwii wɔ ninle ni otii wɔ kotoko di Petro labudi ni obilɛma lakaalɛ nwɔ alɛ, “Diele afɔ lanya mimko nwɔ di kɔba nwu nkpo kamɛ nɛ?” ");
INSERT INTO snw_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ninfɛ di Petro lakple aasĩ aabuɛ alɛ, “Kpa woo!” Nfanwu, ni di kɔɔkɔ labo nɛ. ");
INSERT INTO snw_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Kolesɛtũ yi, baakpaa Yesu baadieko di Kaiafa leyo baasifiko Roma batii abaa nɔɔfo leyo. Kafɔɔ Yuda batii banɔɔfotii ditabuo leyo nwu kamɛ. Diekye baamiɛ alɛ suoto lɛma sibla klekle mmle okle babafuo ni kukpi diisi ofe dii nwu nkpo ole. ");
INSERT INTO snw_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ta nkpo oso Pilato ladie aakyɛ ɔkyɛ lɛma kaayi aalaakaalɛ ma alɛ, “Ɔmɛnlaa biɛwako di osuɔtɔ wɔ mmle suoto?” ");
INSERT INTO snw_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ninfɛ baadiki kanya alɛ, “Nse aabla okpile kuonwii yi, nse buɔkpaa nwɔ buwako ɔkyɛ lɛfɔ.” ");
INSERT INTO snw_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ninfɛ di Pilato latɔkɔ ma alɛ, “Nse nkpo yi, ni aye bamu bikpaa nwɔ bisifiko biɛlaakanko nwɔ di kufiofa lee kanya.” Ninfɛ di Yuda batii batunletɛ latɔkɔ Pilato alɛ, “Baata wo osuku alɛ bualo otii kuonwii kukpi lɛpɔɔ.” ");
INSERT INTO snw_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Nle mmle nwu lawa alɛ, sɛlaa se di Yesu labuɛ aatɛ ni di kukpi ko okle ɔɔwa ni ɔbakpi kawa kaanya. ");
INSERT INTO snw_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ninfɛ di Pilato lakple aasifi leyo, ninfɛ aalɛɛ Yesu aakaalɛ nwɔ alɛ, “Afɔ ninle Yuda Batii Ɔka nwu nɛ?” ");
INSERT INTO snw_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Nfa nfɛ di Yesu lakaalɛ nwɔ alɛ, “Afɔ omu lɛfɔ nikɔkaalɛ mi ɔlaa wɔ mmle ɛɛ, sɛɛ batii bawo niɛtɔkɔ fɔ suoto ni ɔlaa?” ");
INSERT INTO snw_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ninfɛ di Pilato kafɔɔ ladiki kanya alɛ, “Foonyu falɛ Yuda otii nle? Afɔ omu lɛfɔ kale batii bamu ku olebatatɛ banɔɔfo niɛkpaa fɔ bɛɛwakoe. Be fɛɛbla?” ");
INSERT INTO snw_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Nfa nfɛ di Yesu kɔtɔkɔ nwɔ alɛ, “Sɛka kalekɔ nii diekye kayi ka mmle kamɛ. Nse fɛ kayi ka mmle kamɛ di sɛka kalekɔ nii lekye yi, nse batikankotɛ nii ntabakpɛ mantɛɛ, se baayɔ mi bakpee di Yuda banɔɔfotii nnɛɛ kamɛ. Kafɔɔ sɛka kalekɔ nii diekye kayi ka mmle kamɛ.” ");
INSERT INTO snw_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Obe wɔ aatɔkɔ nwɔ ni ɔlaa wɔ mmle, ni di Pilato lakaalɛ nwɔ alɛ, “Ni Ɔka fale?” Ninfɛ di Yesu latɔkɔ nwɔ alɛ, “Afɔ nikobuɛ falɛ Ɔka nle. Beelofo mi bɛɛwako kayi ka mmle bɛɛta lɛsaa ninwii, ninle ni alɛ, kadiki onukware nwu nkpo ntuo. Otii lele ninye onukware nwu nkpo kamaa, ankyɔɔ mi atoko.” ");
INSERT INTO snw_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ninfɛ di Pilato lakaalɛ nwɔ alɛ, “Be ninle onukware nwu?” Obe wɔ di Pilato labuɛ ɔlaa wɔ mmle aaloo nii, ninfɛ aadie aasifi Yuda batii nwu nkpo nfũ kaayi ni aalaatɔkɔ ma alɛ, “Ninnya okpile kuonwii di suoto nɔɔ kayila nlo nwɔ ni lɛpɔɔ. ");
INSERT INTO snw_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Kafɔɔ di ɔsaabla lee kanya, nse biole Okpi Diisi Ofe Dii nwu nkpo, dikpe nii lediɛ leyo tentɛ onwii lɛta ye. Nioso, biomiɛ bilɛ ndiɛ Yuda Batii Ɔka nwu nkpo nta ye?” ");
INSERT INTO snw_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ninfɛ di bamuu lɛma baafaa baabuɛ alɛ, “Kpa woo! Diele nnwɔɔ, kafɔɔ Baraba buomiɛ!” Kafɔɔ Baraba wɔ mmle lataka aayila di abaa suoto. ");
INSERT INTO snw_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Nkpo oso Pilato lata baakpɛtɛ lakpaa Yesu baasifiko baalaapɛ nwɔ osie kanya ku mpile. ");
INSERT INTO snw_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ni baayɔ sɛkansi baabla lekoto baatũkũsɔɔ diisi nɛ. Ninfɛ baayɔ awu sɛɛle ya niefũ ni kɔya wua baakpa nwɔ fɛ ɔka nɛ. ");
INSERT INTO snw_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ninfɛ baatɔɔtaa siwidi alɛ, “Yii yiiduu! Yuda batii Ɔka nfɛ kɔwa kyu woo!” Nse bɛɛtɔkɔ nwɔ nkpo kamaa, faanya nii, batɔɔpɛ nwɔ kɔnɛɛ kootokosi. ");
INSERT INTO snw_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Nni nkpo sɛmaa, Pilato lakple aadie aakyɛ kayi di batii dikudi nwu nkpo nfũ aalaatɔkɔ ma alɛ, “Binyu! Kamakpaa nwɔ nwako anu lee, bibanya bilɛ, nínya okpile kuonwii di suoto nɔɔ eesiɛko alɛ baalo nwɔ ni kukpi lɛpɔɔ.” ");
INSERT INTO snw_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Nioso Yesu ladie aawa kayi ninfa, aatũkũ sɛkansi lekoto, aakpee kafɔɔ awu sɛɛle wua. Ninfɛ di Pilato latɔkɔ ma alɛ, “Binyu! Nnya otii nwu ninle nwɔ nɛ!” ");
INSERT INTO snw_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Obe wɔ di olebatatɛ banɔɔfo ku Olekatakɔ basaanyuntɛ lanyɔɔ nii, baafaa baabuɛ alɛ, “Pɛ nwɔ sibuɛ fakaasa koowoso suoto! Pɛ nwɔ fakaasa koowoso suoto!” Ninfɛ di Pilato latɔkɔ ma alɛ, “Aye bamu bikpaa nwɔ bisifiko, biɛlaapɛ nwɔ sibuɛ bikaasa koowoso suoto. Ami, ninnya okpile kuonwii di suoto nɔɔ kalo nwɔ ni kukpi lɛpɔɔ.” ");
INSERT INTO snw_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Nfa nfɛ di batii dikudi nwu nkpo latɔkɔ nwɔ alɛ, “Bukpe kufiofa nikotuo alɛ aakpi nii, diekye oobuɛ alɛ Yaa Obi ale.” ");
INSERT INTO snw_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Di obe wɔ di Pilato lanu ni ɔlaa wɔ mmle yi, lɛyɛkɛ lakple diapɛ nwɔ osie kanya. ");
INSERT INTO snw_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ninfɛ aakple aasifi leyo aalaakaalɛ Yesu alɛ, “Ɔfɛ feekye?” Kafɔɔ Yesu ditatɔɔ ntale kunwii. ");
INSERT INTO snw_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ninfɛ di Pilato lakaalɛ nwɔ alɛ, “Lɛɛ! Flookpee mi kanya? Sɛɛ faaye falɛ nkpe otumi kadiɛ fɔ, ee nta mampɛ fɔ sibuɛ mankaasa koowoso suoto?” ");
INSERT INTO snw_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ninfɛ di Yesu latɔkɔ nwɔ alɛ, “Nse diele fɛ ɔta bɛɛta fɔ osie nwu nkpo beekyeko osi yi, nse faawɛ otumi nwu nkpo di suoto nii. Nkpo oso otii wɔ niɛyɔ mi eekpee fɔ ni ninnɛɛ kamɛ okpile nlenke ole fɔ.” ");
INSERT INTO snw_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Di obe wɔ di Pilato lanu ni ɔlaa wɔ mmle yi, aamiɛ osuku wɔ suoto aafe andiɛ ni Yesu. Kafɔɔ batii nwu nkpo lafaa baabuɛ alɛ, “Nse feediɛ nwɔ, ni diotuo alɛ faasinle Ɔka Kplɛ Kaesare siɛwo! Diekye otii lele niɛbla suoto ɔka kamaa, ni ɛɛtaka ayɛ di Ɔka Kplɛ suoto!” ");
INSERT INTO snw_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Di obe wɔ di Pilato lanu ni sɛlaa se mmle yi, ninfɛ aakpaa Yesu aadieko nɛ. Ninfɛ di nnwɔɔ omu aalaasiɛ di lɛkankokpomii suoto nɛ, di lɛba le bɔɔlɛɛ ni afuɔ kasiisakɔ. Di Hebri sele kamɛ manlɛɛ lɛba nwu nkpo alɛ Gabata. ");
INSERT INTO snw_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Dii nwu nkpo lale suoto ololaa dii diata Okpi Diisi Ofe Dii ole nwu nkpo. Diabla fɛ kakũ lefosi ɛnyɔ. Ninfɛ di Pilato latɔkɔ Yuda batii nwu nkpo alɛ, “Nnya Ɔka lee nwu nkpo!” ");
INSERT INTO snw_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Kafɔɔ mia nfɛ baakple baatɔɔfaa osie kanya baatoobuɛ alɛ, “Kpaa nwɔ fasifiko! Kpaa nwɔ fasifiko! Pɛ nwɔ sibuɛ fakaasa koowoso suoto!” Ninfɛ di Pilato lakaalɛ ma alɛ, “Biomiɛ bilɛ mpɛ Ɔka lee nwu nkpo sibuɛ nkaasa koowoso suoto?” Ninfɛ di olebatatɛ banɔɔfo nwu nkpo ladiki kanya alɛ, “Ɔka kuonwii nnaa wo dilenkee Roma Batii Ɔka Kplɛ nwu nkpo!” ");
INSERT INTO snw_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Obe wɔ baabuɛ ɔlaa nwu baaloo nii, ninfɛ di Pilato kafɔɔ layɔ Yesu aakpee ma di nnɛɛ kamɛ alɛ balaapɛ nwɔ sibuɛ bakaasa koowoso suoto nɛ. Nkpo oso, bakpɛtɛ nwu lakpaa Yesu baasifiko. ");
INSERT INTO snw_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Baata nnwɔɔ omu aatuka kowoso ko suoto babapɛ nwɔ mankaasa ni aalaadunko lɛba le baatɔɔlɛɛ ni Otii Disi Dikufi. Di Hebri sele kamɛ manlɛɛ ni Golgota. ");
INSERT INTO snw_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Nfa baapɛ nwɔ sibuɛ baakaasa koowoso suoto nɛ. Baapɛ basuɔtɔ banyɔ banwii kafɔɔ sibuɛ baakaasa di awoso bamba suoto, di Yesu oletanɛɛkyɛ ku ɔmɛntunɛɛkyɛ. ");
INSERT INTO snw_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato lata baakpana lɛsaa bakaasa di Yesu kowoso nwu nkpo osi. Sɛlaa se aakpana ni ninle nse mmle nɛ. Yesu Nasaret Otii nwu, Yuda Batii Ɔka. ");
INSERT INTO snw_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yuda batii kpinwu laka lɛsaa le mmle, diekye lɛba le baakaasa ni Yesu koowoso suoto ditakyo ku okpoo kplɛ nwu nkpo. Diɛkyakaa nii, baakpana sɛlaa se mmle di Roma, Hebri ku Griki batii sele kamɛ. ");
INSERT INTO snw_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Nioso olebatatɛ banɔɔfo lasĩ ɔlaa nwu, ni baatɔkɔ Pilato alɛ, “Tankpana falɛ, ‘Yuda Batii Ɔka,’ kafɔɔ kpana falɛ, ‘Otii wɔ mmle kobuɛ alɛ, “Ami ninle Yuda Batii Ɔka.” ’ ” ");
INSERT INTO snw_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ninfɛ di Pilato ladiki kanya alɛ, “Lɛsaa le ntɔɔkpana nii, ntɔɔkpana kofokofoko.” ");
INSERT INTO snw_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Di obe wɔ baakpɛtɛ nwu ntɔɔkaasa Yesu koowoso suoto beeloo nii, ni baayɔ akleesaa baasɛ di akyuu ana nɛ, baakpɛtɛ nwu obiala lɛma layɔ dikyuu ninwii nɛ. Kafɔɔ awu anwii labu. Awu nwu nkpo diele ɔkaa baakaa nya, kafɔɔ oloso baaloso nya baakyeko simu baalaase kaalɔ. ");
INSERT INTO snw_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ninfɛ di bakpɛtɛ nwu latɔkɔ bawo alɛ, “Bitanta buabɛ awu ya mmle nkpo. Kafɔɔ bita buwii atrebi bunyu owe ale abale.” Nle mmle nwu nkpo lawa kaanya alɛ, Kɔkpana Klekle ɔlaa wɔ beebuɛ bɛɛtɛ ni kawa kaanya. Baabuɛ baatɛ alɛ, “Bɛɛyɔ mi akleesaa bɛɛsɛ bawo. Beewii kafɔɔ atrebi di awu ya ninkpee ntɛ ni kasɔ.” Nni ninle lesaa le kafɔɔ di baakpɛtɛ nwu ntɔɔbla ni nɛ. ");
INSERT INTO snw_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Batii ba niayila ni di Yesu kowoso nwu nkpo baapɛ nwɔ sibuɛ baakaasa ni ɔlɔɔkɔ niale, Yesu ɔya ku ɔya obilɛma ku Maria wɔ ninle ni Klopa ɔsɔfɔ ku Maria Magdalene. ");
INSERT INTO snw_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Obe wɔ di Yesu lanya saateketetɛ wɔ ambɔmbɔ ni nwaa ku ɔya n-yɛ nii, ni aatɔkɔ ɔya alɛ, “Mma, nnya obi lɛfɔ!” ");
INSERT INTO snw_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ninfɛ aatɔkɔ saateketetɛ nwu nkpo alɛ, “Nyu, nnya mma lɛfɔ!” Diayɔ ni di obe nwu nkpo kamɛ, ni di saateketetɛ nwu nkpo lakpaa Yesu ɔya aasifiko leyo nɔɔ, aalaasiɛ di ɔkyɛ nɔɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yesu latofo nfɛ alɛ, lɛsaa biala ntooloo. Ta mmle di Yaa ɔlaa wɔ baabuɛ baatɛ ni kawa ni kaanya oso, Yesu labuɛ alɛ, “Otu kɔnsɔ nkle mi.” ");
INSERT INTO snw_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Lɛba le di ɔlaa wɔ mmle lawa nii, ntu lekpetesa kplɛ ninwii layila ninfa, di nta nyankale layii kamɛ diayila nii. Nkpo oso, baayɔ oleteku baanii di owoso onwii suoto bɔɔlɛɛ ni hisope baalaanyɔ di nta nwu nkpo kamɛ, ni baatakatɛsa baakyɔɔ Yesu kaanya nɛ. ");
INSERT INTO snw_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Obe wɔ di Yesu lanyi nta nwu nkpo aaloo nii, ni aabuɛ alɛ, “Kutooloo.” Ninfɛ aawakosa disi kasɔ ni ninwuna nɔɔ ladie nɛ. ");
INSERT INTO snw_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ninfɛ di Yuda batii batunletɛ latɔkɔ Pilato alɛ ata ma osuku baalaafee basuɔtɔ ba baapɛ bakaasa ni di kowoso suoto nkpaa, baatekete bakpi lɛma di kowoso suoto. Baakaalɛ nle mmle diekye Fiida diale, batamiɛ kafɔɔ alɛ bakpi lɛma kasaka di kowoso suoto dilaadu Lɛnyɛɛtɛyi nwu nkpo suoto. Diekye Lɛnyɛɛtɛyi nwu nkpo dii finle dile diɛta ma. ");
INSERT INTO snw_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ta nkpo oso bakpɛtɛ nwu lakyɛ baalaafee otii kasale nkpaa, ni baakyɛ baalaafee ɔnyɔɔfa kafɔɔ nle nɛ. Dile ni mba baakaasa ni awoso suoto di Yesu ɔlɔɔkɔ. ");
INSERT INTO snw_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Kafɔɔ obe wɔ baakyɛ Yesu nfũ, baanya alɛ atookpi kofokofoko. Ta nkpo oso batafee nwɔ nkpaa. ");
INSERT INTO snw_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Kafɔɔ bakpɛtɛ nwu nkpo onwii lɛma ladiki lɛkplɔ nɔɔ aatofo Yesu di ɔfankyi. Ninfɛ di ntɔ ku ntu ladie nɛ. ");
INSERT INTO snw_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Otii wɔ nianya ni lɛsaa le mmle niawa nii, niɛkpana ɔlaa eekyeko nwu di suoto ɔɔta wo. Ɔlaa lele ɛɛtɔkɔ wo kute nkpo. Aye kafɔɔ alɛ ɔlaa wɔ oobuɛ ni nte nkpo. Oobuɛ nwu antɔkɔ ye alɛ biafũ minu. ");
INSERT INTO snw_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Nle mmle lawa kaanya nkpo alɛ Kɔkpana Klekle Kukũ kamɛ ɔlaa wɔ eebuɛ ɛɛtɛ kawa kaanya alɛ, “Bɔlɔbafee nwɔ dikufi kuniwii.” ");
INSERT INTO snw_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Bɛɛkpana kafɔɔ di lɛba bamba alɛ, “Batii manya otii wɔ beetofo ni lɛkplɔ di ɔfankyi.” ");
INSERT INTO snw_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Nle mmle sɛmaa, Yosef wɔ niakye ni okpoo wɔ baatɔɔlɛɛ ni Arimatea, lakyɛ Pilato nfũ aalaatikiti nwɔ lekoto alɛ, adiɛko nwɔ Yesu kpi. Yosef wɔ mmle lale Yesu saateketetɛ, kafɔɔ di lewofa kamɛ, diekye aatɔɔyɛkɛ Yuda batii banɔɔfo. Ni di Pilato latɔkɔ nwɔ alɛ aafuo kpi nwu nkpo ɔbafũ, ni aalaafũ nwɔ aasifiko nɛ. ");
INSERT INTO snw_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ni di Nikodemo wɔ niakasa ni Yesu nfũ ɔkyɛ ku kakyɛ latikanko Yosef nwu nkpo nɛ. Ninfɛ aayɔ kɔfa ko man-yɔ manlolaa ni kpi, bɛɛyɔ klobo ku kɔfa kɔnɔnkɔnɔ ko manlɛɛ ni aloe kpinwu aaklee nɛ. Kɔfa nwu nkpo lɛpɔ kawo fɛ bakiloo afosi atiɛ. ");
INSERT INTO snw_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ninfɛ baasuɔtɔ ba mmle banyɔ lalolaa Yesu kpi nwu ku kɔfa nwu, baayɔ dibula fututu baamiminisa nwɔ di suoto fɛ mmle di Yuda batii mbla ni kpi fiɛ mankookaa nii. ");
INSERT INTO snw_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Kɔba kunwii lawɛ di lɛba le baalo ni Yesu. Di kɔba nwu kamɛ, ɔkya fɔle onwii late ninfa manayikookaa ni otii kuonwii kaamɛ diidii. ");
INSERT INTO snw_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Di obe wɔ di dii nwu nkpo kaleesɛ nimale ni Lɛnyɛɛtɛyi, fiɛ di ɔkya nwu nkpo latɛɛtɛɛ ni nfa oso yi, ni baayɔ Yesu baakookaa ninfa nɛ. ");
INSERT INTO snw_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Kɔsida kolesɛtũ di obe wɔ kaayi diikpa nii, Maria Magdalene lakyɛ ɔkya nwu katũ, ni aalaanya alɛ difuɔ le baayɔ baatĩi ni ɔkya nwu kanya baamunusa ni baakyisa. ");
INSERT INTO snw_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ninfɛ aatoso aasifi Simon Petro ku saateketetɛ wɔ di Yesu mbɔmbɔ ni nfũ nɛ. Ni aalaatɔkɔ ma alɛ, “Batii bawo lɛkyɛ bɛɛlaaklee Saate nwu beediki di ɔkya kamɛ, buoye nfũ kafɔɔ bɛɛyɔ nwɔ bɛɛlaatɛ nii!” ");
INSERT INTO snw_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ninfɛ di Petro ku saateketetɛ bamba nwu nkpo ladie baatoofe ɔkya nwu katũ nɛ. ");
INSERT INTO snw_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Akyuu lɛma anyɔ baatootoso kafɔɔ, saateketetɛ bamba nwu nkpo latoso aalaafe Petro, aaka nwɔ ɔkya nwu nkpo katũ ɔlaadu. ");
INSERT INTO snw_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Aawakasɔ aakɛnsa aanyu ɔkya nwu nkpo kamɛ, aanya abula fututu nwu, kafɔɔ atabuo di ɔkya nwu kamɛ. ");
INSERT INTO snw_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simon Petro latikanko nwɔ di nkpaamaa aabadu nfa, ni aafe nwɔ aabuo di ɔkya nwu nkpo kamɛ, ni aanya abula fututu nwu nkpo niate ni ninfa nɛ. ");
INSERT INTO snw_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Dibula le baayɔ baanii ni Yesu disi late ninfa. Kafɔɔ ditate di abula fututu nwu nkpo ɔlɔɔkɔ. Nni baakatu ni baatɛ lete di ɔlɔɔkɔ. ");
INSERT INTO snw_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ninfɛ di saateketetɛ wɔ niakasa ni ɔkya nwu nkpo katũ odu kafɔɔ labuo di ɔkya nwu kamɛ nɛ. Aanya akookaasaa nwu nkpo okle, ni aafũ aanu nɛ. ");
INSERT INTO snw_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Diekye di obe nwu kamɛ yi, bayinu Yaa ɔlaa wɔ niabuɛ alɛ dikpe ni Yesu lekple ɛɛtaka eekye ni kukpi kamɛ kasɔ. ");
INSERT INTO snw_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ninfɛ di basaateketetɛ nwu nkpo lakple baasifi ayo lɛma nɛ. ");
INSERT INTO snw_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maria layila di ɔkya nwu kotoko aatoowi kaku. Obe wɔ aatoowi ni nkpo, ni aawakasɔ alɛ oonyu ɔkya nwu kamɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ninfɛ aanya Yaa batɔkyɛntɛ banyɔ lakpee asaa fututu, baasiɛ ninfũ baayɔ Yesu baatɛ ni nɛ. Onwii lasiɛ di lɛkantosi nɔɔ, ɔnyɔɔfa kafɔɔ lasiɛ di nkpaalɔ nɔɔ. ");
INSERT INTO snw_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ninfɛ baakaalɛ nwɔ alɛ, “Ɔsanko, be oso foowi kaku?” Ninfɛ aadiki kanya alɛ, “Batii bawo labayɔ Saate nii beesifiko. Ninye nfũ kafɔɔ bɛɛyɔ nwɔ bɛɛlaatɛ nii!” ");
INSERT INTO snw_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Obe wɔ aabuɛ ɔlaa nwɔ mmle aaloo nii, ninfɛ aamunikĩi aanyu sɛmaa nɛ, ni aanya alɛ Yesu n-yɛ, kafɔɔ atatofo alɛ Yesu diale. ");
INSERT INTO snw_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ninfɛ di Yesu lakaalɛ nwɔ alɛ, “Ɔsanko, be oso foowi kaku? Owe foowolaa?” Kafɔɔ Maria lanyu alɛ otii wɔ nikonyu ni lɛba nwu dile. Nkpo oso aatɔkɔ nwɔ alɛ, “Teete, lekoto, nse afɔ niɛyɔ nwɔ feesifiko yi, faatuo mi nfũ fɛɛyɔ nwɔ fɛɛlaatɛ ni, ninkyɛ naakpaa nwɔ.” ");
INSERT INTO snw_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Nfa nfɛ di Yesu lalɛɛ nwɔ alɛ, “Maria!” Ninfɛ aamunikĩi aanyu Yesu, ni aalɛɛ nwɔ di Hebri sele kamɛ alɛ, “Rabuni!” Lɛsɔdiki ninle alɛ Saatuotɛ. ");
INSERT INTO snw_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ninfɛ di Yesu latɔkɔ nwɔ alɛ, “Diɛ mi ɔkpanko, diekye ninkple nsifi Teete nwu nfũ di osi. Kafɔɔ tɔɔkyɛ babiloo nfũ faalaatɔkɔ ma falɛ, kokple nsifi Teemi ku Yaa nii nfũ di osi. Ale ni aye kafɔɔ Teeye ku Yaa lee.” ");
INSERT INTO snw_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Nkpo oso, Maria Magdalene lakyɛ aalaatɔkɔ basaateketetɛ nwu nkpo alɛ atɔɔnya Saate nwu. Ni aatɔkɔ ma sɛlaa se simuu di Yesu latɔkɔ nwɔ ni nɛ. ");
INSERT INTO snw_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Di Kɔsida nwu nkpo kɔtɔɔfɔ yi, basaateketetɛ nwu lasi dikudi di leyo ninwii kamɛ, baasɛɛ leyo nwu ta baatɔɔyɛkɛ ni Yuda batii batunletɛ nwu nkpo oso. Nfanwu, ninfɛ di Yesu lawa aabayila ma nintɛɛ nɛ. Ni aatɔkɔ ma alɛ, “Atoko ɔkyɛ ole disiɛko ye.” ");
INSERT INTO snw_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Obe wɔ aabuɛ ɔlaa nwu nkpo aaloo nii, ni aatuo ma nnɛɛ ku ɔfankyi nɔɔ nɛ. Ni di suoto lɛyɔɔ layii basaateketetɛ nwu kamɛ pɔ di obe wɔ baanyɔɔ ni nɛ. ");
INSERT INTO snw_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Nni nkpo sɛmaa, Yesu lakple aatɔkɔ ma alɛ, “Atoko ɔkyɛ ole disiɛko ye. Fɛ mmle okle di Teete lekpee mi ni kɔtɔ, nkpo okle di ami kafɔɔ kokpee ye nɛ.” ");
INSERT INTO snw_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ninfɛ aanwuna aakpete ma di suoto aatɔkɔ ma alɛ, “Bifũ Ninwuna Klekle nwu nkpo. ");
INSERT INTO snw_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nse biɛyɔ batii sikpile biɛkyɛ ma yi, ni Yaa kafɔɔ ntɔɔyɔ ɛɛkyɛ ma. Nse biɛɛyɔ bikyɛ ma yi, ni Yaa kafɔɔ diɛyɔ akyɛ ma.” ");
INSERT INTO snw_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Di obe wɔ kamɛ di Yesu lawa ma ni ɔkyɛ yi, basaateketetɛ lefosi banyɔ nwu nkpo onwii wɔ baatɔɔlɛɛ ni Toma, mankple manlɛɛ nwɔ ni Lɛtabi, ditawɛ ma kaamɛ. ");
INSERT INTO snw_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Nkpo oso obe wɔ aawa nii, basaateketetɛ nwu nkpo latɔkɔ nwɔ alɛ, “Butɔɔnya Saate nwu!” Ninfɛ di Toma latɔkɔ ma alɛ, “Nse ninnya sibuɛ mpɛkɔ nwu nkpo ninnɛɛ nɔɔ n-yɔ lɛnɛɛ nii nkpee kaamɛ, ee n-yɔ kɔnɛɛ nii nkpee di ɔfankyi nɔɔ nwu nkpo kamɛ yi, namafũ nnu diidii.” ");
INSERT INTO snw_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Nnanwɔkyi onwii sɛmaa, basaateketetɛ ba mmle lakple baasi leeyo kamɛ, nni nkpo Toma nfɛ lasiɛ ma kaamɛ. Baasɛɛ leyo nwu nkpo, kafɔɔ Yesu lawa aabayila ma nintɛɛ, ni aatɔkɔ ma alɛ, “Atoko ɔkyɛ ole disiɛko ye.” ");
INSERT INTO snw_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ninfɛ aatɔkɔ Toma alɛ, “Bayɔ lɛnɛɛ lɛfɔ fakpee ninfũ, faanyu mi nnɛɛ kamɛ. Faayɔ kɔnɛɛ lɛfɔ fakpanko mi ɔfankyi nwu. Diɛ ɔtanfũ onu lɛfɔ nwu nkpo, faafũ fanu!” ");
INSERT INTO snw_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ninfɛ di Toma ladiki kanya aabuɛ alɛ, “Saate nii ku Yaa nii!” ");
INSERT INTO snw_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ninfɛ di Yesu lakaalɛ nwɔ alɛ, “Ta fɛɛnyɛɛ ni oso feefũ feenu. Babakusɛkusɛsa batii ba ninanyɛɛ ni fiɛ beefũ beenu nii!” ");
INSERT INTO snw_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu lakple aabla sɛkpɛ se niɛbla ni ɔkpɛ kpinwu di basaateketetɛ nɔɔ anu, kafɔɔ baakpana bakpee di kukũ ko mmle kamɛ. ");
INSERT INTO snw_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Kafɔɔ bɛɛkpana n-ya mmle bɛɛtɛ alɛ biafuo ofũ onu bilɛ Yesu ninle Kristo nwu nkpo, Yaa Obi nwu nkpo. Di nnwɔɔ ofũ onu wɔ mmle kamɛ yi, bibawɛ nkpa. ");
INSERT INTO snw_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Di nle mmle sɛmaa yi, Yesu lakple aadiki suoto aatuo basaateketetɛ nɔɔ di Tiberia Lekpo ɔlɔɔkɔ. Nnya mmle okle aadiki suoto aatuo ni. ");
INSERT INTO snw_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Dii ninwii, Yesu basaateketetɛ banwii lasi, mma ninle Simon Petro ku Toma wɔ bɔɔlɛɛ ni Lɛtabi ku Natanael wɔ niakye ni Kena di Galilea kasɔ suoto ku Sebedeo babi ku basaateketetɛ bamba banyɔ. ");
INSERT INTO snw_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ninfɛ di Petro latɔkɔ ma alɛ, “Kɔkyɛ naadiki kɔkpaku.” Nfanwu, ni baatɔkɔ nwɔ alɛ, “Awoo, buɔwa munkyɛ.” Nkpo oso bamuu lɛma baalaabuo di oklo kamɛ baasifi. Kafɔɔ dii nwu nkpo kakyɛ, batadiki kakpaku kukanwii. ");
INSERT INTO snw_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Obe wɔ nfɛ kuufĩ kotũ nii, Yesu lawa aabaayila di lekpo nwu nkpo katũ. Kafɔɔ basaateketetɛ nwu nkpo ditatofo alɛ Yesu diale. ");
INSERT INTO snw_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ninfɛ aakaalɛ ma alɛ, “Bakosopo, ni, biediki lɛsalɛsaa?” Ninfɛ baadiki kanya alɛ, “Oowo lo!” ");
INSERT INTO snw_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ninfɛ aatɔkɔ ma alɛ, “Bitaa asabu lee nwu nkpo bikpee di oklo nwu nkpo oletanɛɛkyɛ, bibadiki lɛsaa.” Nkpo oso baataa asabu nwu nkpo. Baadiki kɔkpaku kpinkidi alɛ, batasinfuo asabu nwu ɔtɔɔnanfi. ");
INSERT INTO snw_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ninfɛ di saateketetɛ wɔ di Yesu mbɔmbɔ ni latɔkɔ Petro alɛ, “Saate dile!” Obe wɔ di Petro lanu alɛ Saate dile nii, ni aayɔ osi awu wua nɔɔ aaminisa di ɔtɔ nɛ, diekye aadiki nya aatɛ. Ni aayefe aabuo di ntu kamɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Kafɔɔ basaateketetɛ nwu nkpo bule, baasiɛ di oklo kamɛ baatɔɔnanfi asabu nwu nkpo niayii ni ku kɔkpaku baatɔɔwako lekpo kotoko. Batakyo ku lekpo kotoko, nkpo diate fɛ nnɛɛ ditika afosi anɔɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Di obe wɔ baadie di oklo kamɛ baabadu ni kasɔ, baanya akaa ɔtɔ beekutaa nii, di kɔkpaku kowo latika nii, bloblo owo kafɔɔ late ninfa. ");
INSERT INTO snw_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ninfɛ di Yesu latɔkɔ ma alɛ, “Biyɔ kɔkpaku lee ko biediki ni kowo biwako.” ");
INSERT INTO snw_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ninfɛ di Simon Petro layie aabuo di oklo kamɛ, ni aananfi asabu nwu nkpo aawako lekpo kotoko nɛ. Kɔkpaku kplɛ layii asabu nwu nkpo kamɛ kuoawo kɔlafa afosi anɔɔ kɔkpaku kutiɛ. Nu kɔɔkpaku nwu nkpo lapɔ nkpo, asabu nwu nkpo ditabɛ. ");
INSERT INTO snw_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ninfɛ di Yesu latɔkɔ ma alɛ, “Biwa biɛbale alesaa.” Basaateketetɛ nwu nkpo kuonwii lɛma ditafuo otu okpee ɔkaalɛ nwɔ alɛ, “Afɔ owe dile?” Diekye baatofo alɛ Saate nwu diale. ");
INSERT INTO snw_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Nioso Yesu lakyɛ aalaayɔ bloblo, ni aayɔ aata ma nɛ. Nkpo okle kafɔɔ aayɔ kɔkpaku nwu aata ma nɛ. ");
INSERT INTO snw_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Nle mmle niale ditiɛfa di Yesu ladiki suoto aatuo ni basaateketetɛ nɔɔ, di obe wɔ aataka aakye ni kukpi kamɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Di obe wɔ batoole alesaa beeloo nii, Yesu lakaalɛ Simon Petro alɛ, “Simon, Yohane obi, fambɔmbɔ mi fanlenkee mba mmle?” Ninfɛ aadiki kanya alɛ, “Yii, Saate! Faye falɛ mbɔmbɔ fɔ.” Ninfɛ di Yesu latɔkɔ nwɔ alɛ, “Toonyu afosobi nii.” ");
INSERT INTO snw_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yesu lakple aakaalɛ nwɔ lɛnyɔɔfa alɛ, “Simon, Yohane obi, fambɔmbɔ mi?” Ni aatɔkɔ nwɔ alɛ, “Yii, Saate! Faye falɛ, mbɔmbɔ fɔ.” Ni di Yesu latɔkɔ nwɔ alɛ, “Toonyu bafoso nii.” ");
INSERT INTO snw_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yesu lakple aakaalɛ nwɔ ditiɛfa alɛ, “Simon, Yohane obi, fambɔmbɔ mi?” Ɔlaa wɔ mmle labuo Petro suoto, diekye ditiɛfa niale nni nkpo di Yesu lakaalɛ alɛ, “Fambɔmbɔ mi?” Nioso, aatɔkɔ nwɔ alɛ, “Saate! Faye lɛsaa biala. Faye kafɔɔ falɛ mbɔmbɔ fɔ!” Ninfɛ di Yesu latɔkɔ nwɔ alɛ, “Toonyu bafoso nii. ");
INSERT INTO snw_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nwaako kɔtɔkɔ fɔ nlɛ, obe wɔ fale ni okosopo yi, fantaka fanlolaa suoto fansifi lɛba le ninlɛ fɔ nii. Kafɔɔ nse fataba be yi, fabatakatɛsa nnɛɛ lefɔ fankyɔɔ, otii bamba nnii fɔ, mankpaa fɔ mansifiko lɛba le fonoomiɛ falɛ fakyɛ nii.” ");
INSERT INTO snw_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ɔlaa wɔ mmle di Yesu labuɛ ni yi, ootuo mmle okle di Petro kamakpi nii, an-yɔ dibu anta ni Yaa. Nle sɛmaa, ni di Yesu latɔkɔ nwɔ alɛ, “Tikankoe!” ");
INSERT INTO snw_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Petro lamunikĩi aanyu sɛmaa, ni aanya saateketetɛ wɔ di Yesu mbɔmbɔ ni ntikanko ma sɛɛmaa nɛ. Saateketetɛ nwu niale nwɔ niasiɛ aakaako ni Yesu di kɔtɔɔfɔ alesaa nwu nkpo kalekɔ aakaalɛ Yesu alɛ, “Saate, owe nimadiki fɔ anta?” ni nɛ. ");
INSERT INTO snw_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Obe wɔ di Petro lanyɔɔ nii, ni aakaalɛ Yesu alɛ, “Saate, ni wɔ mmle mɔ, be nimawa nwɔ di suoto?” ");
INSERT INTO snw_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ninfɛ di Yesu ladiki kanya alɛ, “Nse nlɛ asiɛ nkpa dilaadu obe wɔ kamawa nii, ɔmɛnle ninle fɔ ole? Afɔ yi, tikankoe!” ");
INSERT INTO snw_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Nioso ɔlaa wɔ mmle labiɛ kuabuo di Yesu basaateketetɛ nwu nkpo kamɛ alɛ, saateketetɛ wɔ mmle dilaba kpi. Kafɔɔ Yesu ditabuɛ alɛ, ɔlɔbakpi. Ɔlaa wɔ aabuɛ ni ninle alɛ, “Nse nlɛ asiɛ nkpa dilaadu obe wɔ kamawa nii, ɔmɛnle ninle fɔ ole?” ");
INSERT INTO snw_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Nnwɔɔ ninle saateketetɛ wɔ nikɔkakatɛ ni di sɛɛlaa se mmle suoto nɛ. Nnwɔɔ kafɔɔ niɛkpana sĩ ɛɛtɛ nɛ. Buye kafɔɔ bulɛ sɛlaa se simuu eebuɛ ni nte nkpo. ");
INSERT INTO snw_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Asaa bamba kpinwu nkpe di Yesu labla nii. Nse fɛ ɔkpana alɛ bɔɔkpana lɛsaa biala le aabla ni mantɛ ninwii ninwii yi, lefũ lenu nlɛ, kayi ka mmle batii ditabawɛ akũ ya mmle nwu nkpo amuu katɛkɔ.");
INSERT INTO snw_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Obiloo Teofilo, diɛ kukũ nii kasale kamɛ, lakpana latɔkɔfɔ asaa ya amuu di Yesu labla ni diayɔ ni di obe wɔ aakye ni ɔkpɛ nɔɔ kasɔ dialaase ni di obe wɔ di Yaa lakpaa nwɔ aasifiko ni osi. Fiɛ aakpaa nwɔ aasifiko ni osi, Yesu latuo batɔkyɛntɛ nɔɔ ba aadiki ni asaa, diafe ni di Yaa Ninwuna Klekle osie kamɛ. ");
INSERT INTO snw_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Diɛ ayi afosi ana kamɛ kuukpi nɔɔ kamaa, aadiki suoto aatuo ma siisuku ate ate suoto diatuo alɛ nwaako akpe ni nkpa. Mma nianyɔɔ nii, aakakatɛko ma di Yaa sɛka kalekɔ suoto. ");
INSERT INTO snw_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Di obe wɔ baasi nii, aakpee ma kufiofa aabuɛ alɛ, “Bitandie di Yerusalem, kafɔɔ yi, bisiɛ bisoko Yaa Ninwuna le nikɔwa ni, nle suoto latɔkɔ ye nlɛ Teemi labuɛ aatɛ alɛ abata ye nii. ");
INSERT INTO snw_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yohane nnwɔɔ yi, ntu, mmi aayɔ aakpeesa batii Yaa Ntu nɛ. Kafɔɔ di ayi asɛɛ kamɛ yi, Yaa mayɔ Ninwuna Klekle nɔɔ ankpeesa ye.” ");
INSERT INTO snw_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Obe wɔ di batɔkyɛntɛ ku Yesu lakple baakyaka nii yi, baakaalɛ nwɔ alɛ, “Saate, nunua foomiɛ falɛ fakplesa sɛka kalekɔ nwu nkpo fata Israel?” ");
INSERT INTO snw_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ni di Yesu latɔkɔ ma alɛ, “Diefĩ alɛ biatofo obe wɔ ee ayi ya di Teemi labuɛ ee ɛɛtɛ ni di osie nɔɔ kanya alɛ nle mmle mawa nii. ");
INSERT INTO snw_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Kafɔɔ se Ninwuna Klekle nwu nkpo lɛwa ye di suoto yi, abakpee ye osie minle mi suoto ɔlaa babuɛtɛ di Yerusalem ku Yudea kasɔ kamuu ku Samaria sekpoo, diɛlaase ni di kasɔ kayɛntɛlekɔ.” ");
INSERT INTO snw_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Diɛ lɛkakatɛ le mmle sɛmaa, Yaa lakpaa nwɔ aasifiko osi, ni baayila baatoonyu nwɔ tuwĩi dialaase di obe wɔ aayu ma ni di anu di alokoonkyɛ kamɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Baayila baatoonyu ni osi tuwĩi oosifi ni yi, nfanwu basuɔtɔ banyɔ banwii lakpee asaa fututu baayila ma di ɔlɔɔkɔ, ");
INSERT INTO snw_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ni baasuɔtɔ nwu nkpo latɔkɔ ma alɛ, “Galilea batii, be oso biyɛ bionyu osi nkpo? Yesu wɔ di Yaa lɛkpaa eekyeko ni ɔkyɛ lee eesifiko ni osi yi, nkpo okle kafɔɔ abakple ankye osi anwa fɛ mmle bienyɔɔ eesifi ni osi nɛ.” ");
INSERT INTO snw_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Nni kamaa, batɔkyɛntɛ nwu nkpo lakple di kobokote ko bɔɔlɛɛ ni nnɔnyi awoso kobokote osi baasifi Yerusalem okpoo kamɛ. Diedie ni ninfa diɛlaabuo ni okpoo lewo lɛkɔ ninwii. ");
INSERT INTO snw_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Obe wɔ baalaabuo ni okpoo kamɛ, baayie baasifi baalaabuo leyo le mansiɛ nii. Batii ba niawɛ ni ninfa niale Petro ku Yohane ku Yakobo ku Andrea ku Filipo ku Toma ku Bartolomeo ku Mateo ku Yakobo nwɔ ninle ni Alfeo obi ku Simon wɔ niabɔmbɔ ni kale nɔɔ osie kanya ku Yakobo obi Yuda. ");
INSERT INTO snw_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Batii ba mmle latoosi obe lele ku basanko bawo ku Yesu ɔya Maria ku Yesu basuɔtɔbi lɛma ku disibu ninwii baatɔɔpɛ ɔlaa baatɔɔta Yaa. ");
INSERT INTO snw_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Diɛ ayi nwu nkpo kamɛ yi, mba niafũ baanu ni labasi, lɛpɔ lɛma lawo fɛ batii kɔlafa afosi anyɔ. Ninfɛ di Petro lataka aayila aatɔkɔ ma alɛ, ");
INSERT INTO snw_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Babiloo, asaa ya baakpana ni di Kɔkpana Klekle Kukũ kamɛ yi, dikpe nii ɛɛwa kanya fɛ mmle di Yaa Ninwuna lafe ni di Ɔka Dawid suoto aabuɛ aatɛ ni di Yuda suoto, otii wɔ nialeko ni batii ba niamufũ ni Yesu katũ. ");
INSERT INTO snw_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yuda lasiɛ diikudi loo le mmle kamɛ, di Yesu ladiki nwɔ alɛ, se aabla ni batɔkyɛntɛ ɔkpɛ.” ");
INSERT INTO snw_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Kafɔɔ aabla okpile, aafũ koto ko baata baaya ni kasɔ ka suoto aalaakpi nii. Lɛba le aakpa aapɛ ni kaasɔ, aabiɛ diɛ sɛfɔtɔ nɔɔ ladie siawii ni kaayi. ");
INSERT INTO snw_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Kukpi nɔɔ ko mmle ɔlaa lakyaka Yerusalem, batii bamuu lanu. Nioso bɔɔlɛɛ lɛba le aakpi ni seele lɛma alɛ Akeldama, lɛsɔdiki nɔɔ kotuo alɛ ntɔ kasɔ. ");
INSERT INTO snw_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Nioso Petro lakakatɛ abuɛ kafɔɔ alɛ, “Bɛɛkpana di Dawid Sinu Kukũ kamɛ alɛ, ‘Leyo nɔɔ dite difukuti. Kuonwii kafɔɔ atansiɛ ni kaamɛ.’ Bɛɛkpana kafɔɔ alɛ, ‘Bita otii bamba ayila di ɔkpɛ nɔɔ kanya.’ ");
INSERT INTO snw_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Nioso, dikaatɛ alɛ, otii owo kabuo wo kaamɛ fɛ ɔlaa nwu nkpo kamaa yilatɛ di Saate loo Yesu ɔtaka diɛ bakpi kamɛ. Dikaatɛ alɛ eele otii wɔ niasiɛ ni diikudi loo le mmle kamɛ diɛyɔ ni di obe wɔ diawo ku Yesu buakyɛ buatookyi ni, diɛyɔ di obe wɔ di Yohane latoobuɛ ni Yaa Ntu Okpeesa ɔlaa, diɛlaase ni di obe wɔ di Yaa lakpaa Yesu di ɔkyɛ loo aasifiko ni osi.” ");
INSERT INTO snw_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Nioso baadiki batii banyɔ, mma niale Matias ku Yosef wɔ baatɔɔlɛɛ ni Barsaba, baakple baatɔɔlɛɛ nwɔ ni kafɔɔ Yusto. ");
INSERT INTO snw_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Nioso baapɛ ɔlaa baata Yaa alɛ, “Saate loo, afɔ nin-ye otii biala disibu kamɛ. Nioso tuo wo otii wɔ feediki ni baatii ba mmle banyɔ kamɛ alɛ aabla ni ɔkpɛ fɛ tɔkyɛntɛ di Yuda kanya, nwɔ niediɛ ɔkpɛ nɔɔ ɛɛtɛ eesifi ni lɛba le ninlɛ nwɔ ni.” ");
INSERT INTO snw_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ninfɛ baawii atrebi di batii ba mmle banyɔ disi alɛ boonyu alɛ, owe suoto di batika, ni diatika di Matias suoto nɛ. Nioso baayɔ nwɔ baakyakaa di batii lefosi onwii nwu suoto. ");
INSERT INTO snw_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Nioso obe wɔ di dii le bɔɔlɛɛ ni Pentekoste dii nwu lawo ni yi, bafũbanutɛ bamuu lakyɛ baalaasi lɛɛba ninwii. ");
INSERT INTO snw_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Nfanwu, baanu sɛlɔ sewo lakye osi fɛ mmle di afɛɛfɔ kplɛ nfɛ nii. Ninfɛ sɛɛlɔ nwu nkpo layii leyo le kamɛ baawɛ ni nɛ. ");
INSERT INTO snw_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ni baanya lɛsaa fɛ ɔtɔ ɔkplalomii labasoo di obiala lɛma suoto nɛ. ");
INSERT INTO snw_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ninfɛ di Yaa Ninwuna labuo baamuu lɛma kamɛ nɛ, ni baakyako sele ate ate obuɛ fɛ mmle okle di Ninwuna Klekle lata ma ni osuku nɛ. ");
INSERT INTO snw_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Di obe nwu kamɛ, Yuda batii ba ninyɛkɛ ni Yaa niakye ni kayi ka mmle aba aba, lawɛ di Yerusalem. ");
INSERT INTO snw_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Nioso baanu ni sɛlɔ kplɛ nwu, batii kpinwu latoso baakyɛ nfa. Obe wɔ di obiala lɛma lanu alɛ, bafũbanutɛ nwu nkpo, nin-yɛ boobuɛ ma ni sele ate ate yi, diabla ma ɔkpɛ. ");
INSERT INTO snw_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Nioso, lɛyɛkɛ lapɛ ma, baakpɔkpɔtɔ kafɔɔ, ni baakyako suoto ɔkaalɛ alɛ, “Batii ba mmle bamuu, diele Galilea batii bale? ");
INSERT INTO snw_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ni lɛ diɛbla fiɛ buonu ma lɛkakatɛ di sekpoo loo sele kamɛ? ");
INSERT INTO snw_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","10","Bule Partia batii ku Media batii ku Elam batii, ni bawo kafɔɔ lekye Mesopotamia ku Yudea ku Kapadokia ku Ponto ku Asia ku Frigia ku Panfilia ku Egipte ku Libia abaya ninkaako ni Kirene ku bafɔɔ ba niekye ni Roma bale ni Yuda batii ku batii ba nitoobuo ni di Yuda batii akudi kamɛ ");
INSERT INTO snw_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ku Kreta batii ku Arabia batii. Kafɔɔ awo badudu buonu bulɛ boobuɛ Yaa sɛkpɛ kplɛ se ɔɔbla nii, di sele loo kamɛ.” ");
INSERT INTO snw_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Nioso, diabla ma ɔkpɛ baayila ninfa, baatɔɔkaalɛ bawo alɛ, “Ɔmɛnlaa ninle nwɔ nɛ?” ");
INSERT INTO snw_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Kafɔɔ batii bawo niayila ni ninfa lama ma alɛ, “Nta nikosiɛnsa ma diele lɛsalɛsaa.” ");
INSERT INTO snw_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Nfa nfɛ di Petro lataka ayila ku batɔkyɛntɛ lefosi onwii nwu, ni aatakatɛsa sɛlɔ katoo abuɛ alɛ, “Aye Yuda batii ku aye ba ninkpe ni di Yerusalem, komiɛ nlɛ ndiki sɛlaa se mmle kasɔ nta ye, nioso bikyɔɔ mi atoko nwaa. ");
INSERT INTO snw_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Diele nta baatii ba mmle kosiɛ. Aye bamu biɔnya bilɛ olesɛ olomu ɛnaasĩ nintɔɔpɛ. ");
INSERT INTO snw_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Kafɔɔ asaa ya biɔnya ni mmle yi, nnya ninle sɛlaa se di Yaa Ɔlaa Buɛtɛtɛ Yoel labuɛ aatɛ nii. ");
INSERT INTO snw_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Aabuɛ alɛ, ‘Yaa lebuɛ alɛ, “Diɛ ayi yɛntɛle kamɛ, kamakyesee Ninwuna nii di batii bamuu suoto. Babi lee suɔtɔbi ku basankobi mabuɛ mi ɔlaa, bakosopo lee kafɔɔ manya awofasaa. Banɔɔfo lee kafɔɔ masɛ alaafɔ. ");
INSERT INTO snw_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Nwaako, diɛ ayi nwu nkpo kamɛ, mayɔ Ninwuna nii nkpee di bakpɛmblatɛ nii, basuɔtɔ ku basanko kamɛ. Bababuɛ mi ɔlaa. ");
INSERT INTO snw_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ni kafɔɔ matuo atuosaa di osi, mabla sɛkpɛ se niɛbla ni ɔkpɛ kaasɔ. Bibanya ntɔ ku ɔtɔ ku kɔyɔ kpinwu ndie. ");
INSERT INTO snw_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Kufĩ makyi kumbla tunutunu, kɔwɛntɛ kafɔɔ masɛɛ fɛ ntɔ. Fiɛ nfɛ di Saate dii kplɛ nwu ku lɛklɛɛyi nwu nkpo kamawa. ");
INSERT INTO snw_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Di obe nwu kamɛ, otii lele niɛlɛɛ Saate diɛ nyaami ɔnya kamɛ mawɛ nkpa.” ’ ” ");
INSERT INTO snw_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Ninfɛ di Petro lakple aabuɛ alɛ, “Israel batii woloo, binu! Yesu Nasaret Otii nwu ninle nwɔ di Yaa ladiki nii. Yaa lafe di suoto nɔɔ aadiki nle mmle aatuo di sɛkpɛ se niabla ni ɔkpɛ ku atuosaa ya aabla aatuo ni ku osie nɔɔ kaamɛ lee, fɛ mmle okle di bamuu lee biye nii. ");
INSERT INTO snw_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Kafɔɔ di Ote omu osuku ɔta kamɛ ku mmle ɛɛtɛ ni kanya, aadiɛ nwɔ aata ye, ni biafe di bakpileblatɛ suoto bialo nwɔ di obe wɔ biapɛ nwɔ sibuɛ biakaasa ni di kowoso suoto. ");
INSERT INTO snw_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Kafɔɔ Yaa lakple aatakatɛsa nwɔ aakyeko bakpi kamɛ, aadie aakye di kukpi nnɛɛ kamɛ, diekye kukpi nkɔnii ditafuo nwɔ omufũ oklee. ");
INSERT INTO snw_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Nioso di Ɔka Dawid labuɛ nwɔ suoto ɔlaa alɛ, ‘Lanya Saate nwu n-yɛ mi di anu obe lele. Ta ayɛ di oletanɛɛkyɛ nii asũ mi ni oso, nɔɔyɛkɛ. ");
INSERT INTO snw_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ta nle mmle oso, otu nii kamɛ leyii pɔ ku suoto lɛyɔɔ, mayɔ sɛlɔ nii ntansa nwɔ obe lele! Kuntɛ kamakpi yi, kamasiɛ nkpa di osuku onyu kamɛ. ");
INSERT INTO snw_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Diekye flabadiɛ ninwuna nii kafɔɔ disiɛ kuukpi kamɛ. Diɛkyakaa nii, flabatuna falɛ otii klekle lɛfɔ abuu di ɔkya kamɛ. ");
INSERT INTO snw_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Afɔ nietuo mi nkpa lɛfɔ osuku nwu, osiɛ di anu lɛfɔ kafɔɔ ntɛɛ suoto lɛyɔɔ nwaa.’ ");
INSERT INTO snw_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Nioso, babiloo, kɔtɔkɔ ye ntikiti nlɛ, ɔwa loo Dawid lakpi, baakookaa nwɔ, kafɔɔ ɔkya nɔɔ lekple kute wo kaamɛ bia mmiɛ. ");
INSERT INTO snw_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Kafɔɔ Yaa ɔlaa buɛtɛtɛ aale. Aatofo ɔlaa wɔ di Yaa labuɛ aatɛ aaka ntam alɛ, abata Dawid ɔnantii male sɛka fɛ mmle okle di Dawid lale nii. ");
INSERT INTO snw_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Diekye Dawid latofo ni nle mmle aalesa ni katũ oso, aabuɛ aatɛ alɛ, Kristo mataka ankye kukpi kamɛ. Blabadiɛ nwɔ aka kukpi kamɛ, nkpo kafɔɔ diɛ suoto sina nɔɔ dilababuu di ɔkya kamɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yesu wɔ mmle di Yaa lɛtakatɛsa eekyeko bakpi kamɛ nɛ. Ta nwaa ɔlaa kule ni oso, ni baamuu loo buoodiki nwu kayi mumbuɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Nunua wɔ mmle yi, Ote Yaa ntɔɔtakatɛsɔɔ katoo, asi diɛ oletanɛɛkyɛ nɔɔ, ni ɛɛyɔ Ninwuna Klekle nɔɔ ɛɛtɔɔ fɛ mmle okle aabuɛ aatɛ nii. Nni aatɔɔyɔ eekpete wo di suoto nɛ. Nioso biɔnya, minnu ɔsaabla wɔ nikɔbla ni ninfũ nɛ. ");
INSERT INTO snw_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Diele Dawid omu niataka aakyɛ osi. Kafɔɔ aabuɛ alɛ, ‘Saate Yaa latɔkɔ Saate nii alɛ, “Siɛ diɛ oletannɛɛkyɛ nii diɛlaase di obe wɔ lɛyɔ balo lɛfɔ lekpee ni di nkpaa lɛfɔ kalɔ.” ’ ");
INSERT INTO snw_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Nioso komiɛ nlɛ aye Israel batii bamuu biatofo bilɛ, Yaa niɛbla alɛ Yesu, nwɔ di aye biakaasa ni koowoso suoto bialo ni kale Saate ku nwɔ di Yaa lɛpɛ ni ɔfɔɔ.” ");
INSERT INTO snw_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Obe wɔ di batii ba mmle lanu ni Petro sɛlaa se mmle yi, diakpanko ma di situ lɛma kamɛ. Nioso baakaalɛ nwɔ ku batɔkyɛntɛ wo nɔɔ alɛ, “Babiloo, blesaa buɔɔbla?” ");
INSERT INTO snw_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ni di Petro latɔkɔ ma alɛ, “Dikpe ni beikyi siitu lee kamɛ biediɛ sikpile ɔbla, biemunikĩi biɛwa Saate nwu nfũ, biefũ Yaa ntu okpeesa nwu di Yesu Kristo leyooto kamɛ, di mmle okle di Yaa kamayɔ sikpile lee ankyɛ ye nii, minfũ ni Yaa Ninwuna Klekle fɛ mmle okle di Saate labuɛ aatɛ nii. ");
INSERT INTO snw_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Diekye ntam be mmle nte dita ye ku babi lee ku mba nimakye ni fanfa ku batii ba bamuu di Saate loo Yaa kamalɛɛ anwako ni ɔkyɛ nɔɔ.” ");
INSERT INTO snw_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Petro lakakatɛ ko ma aaklɛsa, aatikiti ma lekoto, aaka ma abuɛ alɛ, “Bidiki suoto lee bikyeko letokonanfi le nikɔwa ni kamɛ, di miɛ bakpileblatɛ suoto!” ");
INSERT INTO snw_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Nle mmle oso, batii kpinwu kaamɛ lɛma lafũ Petro ɔlaa nwu baanu, ni baakpeesa ma Yaa ntu di Yesu leyooto kamɛ nɛ. Lɛpɔ lɛma kate fɛ batii nkpe ntiɛ. Mma niale mba baayɔ baakyakaa ni di mba niefũ beenu ni suoto dii nwu nɛ. ");
INSERT INTO snw_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Baayɔ obe lɛma omuu baata batɔkyɛntɛ nwu, baatuo ma asaa, baatɔɔpɛ ɔlaa baatɔɔta Yaa, baatɔɔkpɔtɔ kafɔɔ baatoole alesaa, baasiɛ di onwii ɔbla kamɛ. ");
INSERT INTO snw_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Sɛkpɛ kplɛ se di Yaa labla aafenko ni di batɔkyɛntɛ nwu suoto oso, diabla batii nwu bamuu ɔkpɛ, baayɔ dibu baata Yaa. ");
INSERT INTO snw_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Bafũbanutɛ ba mmle latɔɔkyaka obe lele, baatɔɔsɛko bawo kafɔɔ asaa lɛma. ");
INSERT INTO snw_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Man-yɔ suoto lɛma asaa mansunsũ, man-yɔ koto nwu mansɛ manta ma fɛ mmle diefĩ ni obiala lɛma. ");
INSERT INTO snw_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Baatɔɔkyɛ Yaa Olekatakɔ dii biala, baatoosi kafɔɔ akudi akudi baatoole oko di ayo lɛma ku suoto lɛyɔɔ ku otu biene. ");
INSERT INTO snw_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Baatɔɔpɛ Saate sɛfa, baatɔɔtansa nwɔ kafɔɔ. Nioso batii bamuu layɔ dibu baata ma. Dii biala, Yaa layɔ batii ba niɛwɛ ni didiki aatɔɔkyakaa ma. ");
INSERT INTO snw_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Dii ninwii, Petro ku Yohane lakyɛ Yaa Olekatakɔ di obe wɔ di Yuda batii nkyɛ manaapɛ ɔlaa manta ni Yaa, diabla fɛ kakũ elomu etiɛ kamɛ. ");
INSERT INTO snw_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Obe wɔ baadu ni Yaa Olekatakɔ kayokontũ ka bɔɔlɛɛ ni alɛ, kɔɔlɛ ni onyu, nfa baanya osuɔtɔ onwii lefefee ate diayɔ ni di kalofokɔ nɔɔ kamɛ. Baatii nɔɔ nkpaa nwɔ manaatɛ ninfa dii biala alɛ atɔɔkaalɛ ato di batii ba nikobuo ni Yaa Olekatakɔ nwu. ");
INSERT INTO snw_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Obe wɔ aanya Petro ku Yohane latoobuo ni Olekatakɔ nwu yi, aakaalɛ ma alɛ batikɔɔ koto kowo. ");
INSERT INTO snw_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ninfɛ bayila baatoonyu nwɔ tuwĩi, ni di Petro latɔkɔ nwɔ alɛ, “Nyu wo!” ");
INSERT INTO snw_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ninfɛ di osuɔtɔ nwu latakatɛsa anu aatoonyu ma, aatoonyu osuku alɛ babatikɔɔ lɛsaa nɛ. ");
INSERT INTO snw_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ni di Petro latɔkɔ nwɔ alɛ, “Koto kukunwii diete mi mata fɔ! Kafɔɔ, mata fɔ lɛsaa le ninkpe mi nii! Kɔtɔkɔ fɔ nlɛ di Yesu Kristo Nasaret Otii leyooto kamɛ nlɛ, taka faakyɛ!” ");
INSERT INTO snw_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ninfɛ di Petro lamufũ osuɔtɔ wɔ mmle di koletanɛɛ nɔɔ aatɔɔ aataka aayila. Nfanwu nkpaa ku anankpokufi nɔɔ amuu niawɛ osie. ");
INSERT INTO snw_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ninfɛ aakple katoo aayefe, aayila di nkpaa nɔɔ suoto nɛ. Ni aakyako ɔkyɛ aatoofenfe, oyeyefe, aatɔɔtansa Yaa nɛ. Ni aatikanko ma aabuo di Yaa Olekatakɔ nwu nɛ. ");
INSERT INTO snw_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Batii ba niawɛ ni ninfa, baanyɔɔ akyɛ, baanu kafɔɔ mmle ɔɔtansa ni Yaa. ");
INSERT INTO snw_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Obe wɔ baatofo alɛ, nnwɔɔ niale ato kaalɛtɛ wɔ niasiɛ ni di Kayoko ka nikɔlɛ ni onyu ɔlɔɔkɔ, diabla ma ɔkpɛ di lɛsaa le niawa nwɔ ni di suoto. ");
INSERT INTO snw_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Nfanwu batii kpinwu latoso baakyɛ ɔkyɛ lɛma di lɛba le baatɔɔlɛɛ ni Salomo lɛkpata kamɛ di Yaa Olekatakɔ. Baakyɛ baalanya alɛ osuɔtɔ nwu nkle Petro ku Yohane kpinkpĩ, ofiɛ nɔɔ ɔyɔɔ kafɔɔ labla ma ɔkpɛ! ");
INSERT INTO snw_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Obe wɔ di Petro lanya ni batii nwu yi, aatɔkɔ ma alɛ, “Israel batii, belɛsaa oso lɛsaa le mmle lɛbla ye ɔkpɛ nkpo, bionyu wo nkpo tuwĩi? Bitannyu bilɛ awo bamu osie ee leklekle loo kanya buɔɔyɔ buɔɔyɔɔsa otii wɔ mmle ofiɛ! ");
INSERT INTO snw_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Diekye Yaa layɔ dibu aata Obi nɔɔ Yesu. Yaa wɔ mmle ninle Abraham ku Isak ku Yakob kafɔɔ Yaa nɛ. Fɛ mmle kafɔɔ ale ni bawa loo Yaa. Nnwɔɔ Obi nɔɔ Yesu di aye biayɔ biata bilɛ balo nɛ. Biasĩ nwɔ kafɔɔ di Pilato anu biabuɛ bilɛ bieye nwɔ, diɛ obe wɔ di Pilato latɛ alɛ see odiɛ nwɔ ni fiɛ. ");
INSERT INTO snw_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Mintɛ Yesu nle otii tinini ku klekletɛ, aye biasĩ nwɔ, ni biatuna bilɛ adiɛ batii lotɛ nwu, aayɔ otii biene nwu ase kaanya nɛ. ");
INSERT INTO snw_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Bialo otii wɔ ninta ni nkpa. Kafɔɔ Yaa lakple aasɛnkɛsa nwɔ aakyeko bakpi kamɛ! Awo bamu buanyɔɔ ku anu loo! ");
INSERT INTO snw_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Di Yesu leyooto kamɛ ni di osuɔtɔ wɔ mmle biye ni biɔnya ni ninfũ ntɔɔwɛ difiɛyɔɔ nɛ. Diekye di Yesu ofũ onu kamɛ, ni di Yaa ntɔɔyɔɔ sɔɔ ofiɛ di anu lee nɛ. ");
INSERT INTO snw_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Babiloo, n-ye nlɛ di ɔtantofo kamɛ ni di aye ku banɔɔfo lee biabla lɛsaa le mmle okle nɛ. ");
INSERT INTO snw_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Kafɔɔ, Yaa labuɛ aafenko di ɔlaa babuɛtɛtɛ nɔɔ suoto kofokofoko alɛ, dikpe nii Kristo nɔɔ lefe diibuo le mmle okle kamɛ. Osuku wɔ suoto eefe ɛɛta ɔlaa babuɛtɛtɛ nɔɔ ɔlaa lɛwa ni kaanya nɛ. ");
INSERT INTO snw_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","20","Nioso, bikyi siikpile ɔbla suoto, bietikanko Yaa, mmle okle aafoto ye ni sikpile di suoto minwɛ ni ɔnyɛɛɔtɛ wɔ niekye ni Yaa nfũ, ta mmle okle aakyesee ye ni Kristo Yesu wɔ eediki ɛɛta ye ni. ");
INSERT INTO snw_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Dikpe nii Yesu lesiɛ di osi diɛlaase di obe wɔ di Ote lelolaa asaa amuu ɛɛtɛ fɛ mmle di ɔlaa babuɛtɛtɛ nɔɔ klekle labuɛ baatɛ ni kofokofoko. ");
INSERT INTO snw_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Fɛ mmle di Mose labuɛ alɛ, ‘Saate lee Yaa madiki ɔlaa buɛtɛtɛ onwii ankyeko kamɛ lee fɛ mmle eediki mi nii. Nioso binu nwɔ ɔlaa lele abatɔkɔ ye ni. ");
INSERT INTO snw_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Kafɔɔ otii lele ninanu nwɔ ɔlaa, Yaa madiki nwɔ baatii nɔɔ kamɛ, anwɔɔsɔɔ.’ ");
INSERT INTO snw_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Nwaako, Yaa ɔlaa babuɛtɛtɛ bamuu diɛyɔ ni di Samuel diesifi ni mba niawa ni sɛɛmaa nɔɔ, baabuɛ baatɛ di asaa ya nikɔwa ni di miɛ ayi ya mmle nwu nkpo suoto. ");
INSERT INTO snw_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Yaa wɔ niabla ni kanya ninii le mmle ku bate lee diafe ni di ɔlaa babuɛtɛtɛ nɔɔ suoto. Aye ninle kanya ninii le mmle baletɛ nɛ. Fɛ mmle aatɔkɔ ni Abraham alɛ, diefe ni di ɔnantii nɔɔ suoto, abakusɛkusɛsa kayi ka mmle kamuu. ");
INSERT INTO snw_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nioso di Yaa ladiki Obi nɔɔ kayi, aaka nwɔ ɔkyɛ lee okyesee, mmle okle aakyakaako ye mindiɛ ni sikpile ɔbla.” ");
INSERT INTO snw_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Obe wɔ di Petro ku Yohane n-yɛ bɔɔkakatɛko ni batii nwu yi, Yaa olebatatɛ bawo ku Yaa Olekatakɔ banyuntɛ ɔnɔɔfo ku Saduki batii bawo kafɔɔ lawa nfa. ");
INSERT INTO snw_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Obe wɔ baanu alɛ Petro ku Yohane lawɛ ninfa bootuo ni asaa di Yesu Ɔtaka suoto, diotuo alɛ bakpi mataka mansiɛ ni nkpa, ɔblɔ lafiɛ ma osie kanya! ");
INSERT INTO snw_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Nioso baamufũ ma. Ta kaale latooloo ni oso, baatɛ ma leeyo kale lasɛ. ");
INSERT INTO snw_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Kafɔɔ, batii ba nianu ni sɛlaa lɛma nwu kasɔ, baafũ ɔlaa biene wɔ mmle baanu. Nioso lɛpɔ lɛma labla fɛ basuɔtɔ nkpe nnɔɔ. ");
INSERT INTO snw_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Obe wɔ kaale lasɛ nii, diawa alɛ Yuda batii batunletɛ bawo ku okpoo banɔɔfo ku kufiofa batuotɛ lakyaka di Yerusalem. ");
INSERT INTO snw_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Baawa baabasi ku Yaa Oletatɛ Nɔɔfo Hana ku Kaiafa ku Yohane ku Aleksandro ku Oletatɛ Nɔɔfo batii nɔɔ bawo kafɔɔ. ");
INSERT INTO snw_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ninfɛ baakpaa Petro ku Yohane baakyɛnko ma ninfa nɛ. Ninfɛ baakaalɛ ma alɛ, “Ɔmɛnsuku suoto biɛbla nle mmle? Owe leyooto ku osie kamɛ biɛbla lɛsaa le mmle okle?” ");
INSERT INTO snw_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Nfanwu, Petro wɔ nieyii ni ku Yaa Ninwuna Klekle lataka aayila aatɔkɔ ma alɛ, “Batunletɛ loo ku okpoo banɔɔfo, ");
INSERT INTO snw_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","se biomiɛ bilɛ bitofo lɛsaa biene le buɔbla buɔta ni otii wɔ ninkpaa lakpi ni ninfũ ku mmle buɔɔyɔɔsɔɔ ni ofiɛ, ");
INSERT INTO snw_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ni kɔta ye mintofo, aye ku Israel batii bamuu nlɛ, di Yesu Kristo Nasaret Otii leyooto kamɛ, nwɔ di aye biatuna baapɛ baakaasa ni di kowoso suoto, kafɔɔ Yaa lakple aasɛnkɛsa nwɔ aakyeko ni kukpi kamɛ, ni di otii wɔ mmle lɛwɛ osie nɛ. ");
INSERT INTO snw_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Nioso Yesu wɔ mmle suoto di Kɔkpana Klekle lakakatɛ alɛ, ‘Difuɔ le baayotofotɛ lesĩ nii, nni nitɔbakple difuɔ le niefũ ni kɔya dilenke ni afuɔ bule nɛ.’ ");
INSERT INTO snw_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Lete nɔɔ ninle batii dikitɛ, diekye nnwɔɔ lete di Yaa lɛta leyooto ku osie di batii bamuu kamɛ alɛ aafuo wo ni nkpa ɔta.” ");
INSERT INTO snw_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Obe wɔ baatunletɛ nwu ku banɔɔfo nwu nkpo lanya mmle okle di Petro ku Yohane lakakatɛ ni ku sɛkambi, banaa ni kayilakɔ kukanwii, manan-ye ni kukũ kafɔɔ yi, diabla ma ɔkpɛ. Nfa nfɛ diabudi ma alɛ Yesu basiɛwo baale. ");
INSERT INTO snw_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Kafɔɔ baanya otii wɔ baayɔɔsa ni ofiɛ n-yɛ ni di anu lɛma oso, batafuo ɔlaa kuonwii obuɛ. ");
INSERT INTO snw_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Nioso baata ma baadie di kasikɔ lɛma nwu, ninfɛ baakpee asi baawo nɛ. ");
INSERT INTO snw_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Bawo lakaalɛ alɛ, “Be lɛsaa buabla batii ba mmle? Bulabafuo osĩ bulɛ lɛsaa le bɛɛbla ni diele lɛsaa le niɛbla ni ɔkpɛ, diekye otii biala di Yerusalem nfɛ n-ye, baatoonu kafɔɔ ɔlaa wɔ mmle. ");
INSERT INTO snw_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Kafɔɔ bita bukpee ma kufiofa alɛ blasinkakatɛ bata otii kuonwii di Yesu leyooto kamɛ mmle okle di ɔlaa wɔ mmle dilaasinkpɛ ni.” ");
INSERT INTO snw_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Nioso baakple baalɛɛ ma baawako kasikɔ lɛma, ni baasĩ baata ma alɛ diedie ni di nunua, bataasintɔkɔ otii kuonwii ɔlaa ee batuo asaa di Yesu leyooto kamɛ. ");
INSERT INTO snw_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ninfɛ di Petro ku Yohane ladiki kanya alɛ, “Aye bamu bibu binyu. Lɛmɛnle nimakpee Yaa suoto lɛyɔɔ? Nse buɔkyɔɔ ye kufiofa atoko ɛɛ, sɛɛ nse buɔkyɔɔ Yaa ɔlaa atoko? ");
INSERT INTO snw_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Asaa ya buɔnya ni ku n-ya buonu nii, bulaafuo kanya ɔmaasa osiɛ kloklo.” ");
INSERT INTO snw_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Nioso banɔɔfotii di kasikɔ nwu lafunaa ma osie kanya ni baadiɛ ma nɛ. Diekye batii bamuu latɔɔtansa Yaa di ɔsaabla nwu suoto, nioso batawɛ lɛsaa le suoto baafe mananfi ma ni kootoko. ");
INSERT INTO snw_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Otii wɔ baayɔɔsa ni ofiɛ ntoofũ alenke alɛɛ afosi ana. ");
INSERT INTO snw_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Di obe wɔ kamɛ baadiɛ ma nii, Petro ku Yohane lasifi bawo lɛma nfũ baalaatɔkɔ ma mmle okle di olebatatɛ banɔɔfo ku okpoo banɔɔfo lɛtɔkɔ ma nii. ");
INSERT INTO snw_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Nioso bafũbanutɛ ba mmle bamuu lasi, ni baapɛ ɔlaa baata Yaa alɛ, “O Saate, afɔ wɔ niɛbla ni osi ku kasɔ ku lekpo ku asaa ya amuu ninsi ni kaamɛ. ");
INSERT INTO snw_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Afɔ niafe di Ninwuna Klekle lɛfɔ suoto ni di Ɔwa loo kpɛmblatɛ lɛfɔ Dawid labuɛ alɛ, ‘Be oso di kayi batii kɔta lɛhaa, be oso kafɔɔ baatii kobu asi kpile kasakasa? ");
INSERT INTO snw_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Kayi baka ku batunletɛ lɛbla onwii bayɛ bɔɔkpɛ Saate Yaa ku Kristo nɔɔ.’ ");
INSERT INTO snw_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Nwaako ɔlaa kule alɛ Herode ku Pontio Pilato ku Israel batii ku mba ninanle ni Yuda batii lesi kanya di okpoo wɔ mmle kamɛ, bɛɛtaka bayɛ di kpɛmblatɛ lɛfɔ klekletɛ Yesu suoto, nwɔ fɛɛpɛ ni ɔfɔɔ. ");
INSERT INTO snw_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Kafɔɔ, afɔ, di osie ku ninumbe lɛfɔ kamɛ, faayila faanya falɛ baasi baabla di sɛlaa se faabuɛ faatɛ falɛ sibawa ni kanya. ");
INSERT INTO snw_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","O Saate, nunua wɔ mmle nyu lɛyɛkɛ le bɔɔyɔ mankpee wo ni di suoto, faata awo bakpɛmblatɛ lɛfɔ, sɛkambi se buafuo ni ɔlaa lɛfɔ nwu obuɛ. ");
INSERT INTO snw_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Kpanko batii fayɔɔsa ma sifiɛ, faabla sɛkpɛ se niɛbla ni ɔkpɛ ku atuosaa kpinwu di Yesu Obi Klekle lɛfɔ leyooto kamɛ.” ");
INSERT INTO snw_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Obe wɔ baapɛ ɔlaa baata Yaa baaloo nii, lɛba le baasi ni latũkũ, Yaa Ninwuna layii bamuu lɛma kamɛ pɔ, ninfɛ baakyako ɔlaa biene nwu obuɛ ku sɛkambi nɛ. ");
INSERT INTO snw_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Di obe nwu nkpo kamɛ yi, bafũbanutɛ ba mmle bamuu labla onwii di nkpa disiɛbi ku disibu kamɛ, kuonwii lɛma ditanyu lete nɔɔ lele, lɛsaa lele niawɛ olele lɛma diale bamuu lɛma lele. ");
INSERT INTO snw_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Batɔkyɛntɛ ba mmle layie Yaa ɔlaa lɛkya ku otu biene ku osie, diekye ni di Saate Yesu ɔtaka okye baakpi kamɛ suoto. Nioso Yaa dikusɛkusɛ kplɛ lasiɛko bamuu lɛma. ");
INSERT INTO snw_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Kuonwii ditale piitɛ kaamɛ lɛma, diekye mba niawɛ ni ayo ee nsɔ, baayɔ baasunsũ. ");
INSERT INTO snw_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Ni baayɔ ato ya baawɛ ni babakpee di batɔkyɛntɛ nnɛɛ, ni baasɛ baata bamuu lɛma fɛ mmle okle diafĩ ma nii. ");
INSERT INTO snw_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ni kafɔɔ osuɔtɔ onwii lawɛ baatɔɔlɛɛ ni Yosef aakye ni Lewi banantii kamɛ diɛ Kipro kasɔ. Batɔkyɛntɛ latɔɔ leyooto alɛ Barnaba, lɛɛsɔdiki kotuo ni alɛ ɔnyɛɛkpeetɛ. ");
INSERT INTO snw_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Nnwɔɔ kafɔɔ aalaayɔ kasɔ nɔɔ aasunsũ aayɔ koto aawako batɔkyɛntɛ nwu. ");
INSERT INTO snw_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Osuɔtɔ onwii kafɔɔ lawɛ baatɔɔlɛɛ ni Anania, ku ɔsɔfɔ nɔɔ Safira. Mma kafɔɔ baayɔ kasɔ lɛma kawo baasunsũ. ");
INSERT INTO snw_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Kafɔɔ aadiki koto nwu kowo aakookaa, fiɛ aayɔ kubule aawako batɔkyɛntɛ nwu. Ɔsɔfɔ nɔɔ Safira kafɔɔ latunako nwɔ. ");
INSERT INTO snw_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ninfɛ di Petro lakaalɛ nwɔ alɛ, “Anania, be oso fɛta Abonsam osuku, ɛɛta fɔ fɛɛlaa fɛɛta Yaa Ninwuna Klekle? Alɛ fandiki kasɔ ka faayɔ faasunsũ ni koto kowo fantɛ? ");
INSERT INTO snw_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Afɔ nimba kasɔ nwu fiɛ faayɔ faasunsũ, koto ko kafɔɔ baata fɔ nii afɔ nimba. Be niata fɔ osuku alɛ faabla disibu kpile le mmle okle? Diele otii fɛɛlaa fɛɛta, kafɔɔ Yaa fɛɛlaa fɛɛta!” ");
INSERT INTO snw_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Nfanwu di Anania lanu ni ɔlaa wɔ mmle, aanɔɔ aapɛ kaasɔ, aakpi! Batii ba bamuu nianu nii, lɛyɛkɛ lapɛ ma osie kanya. ");
INSERT INTO snw_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Bakosopo ba niasiɛ ma ni kaamɛ layɔ dibula baamiminisa nwɔ baayɔ nwɔ baalaakookaa. ");
INSERT INTO snw_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Di abombo atiɛ kamɛ kamaa, ɔsɔfɔ nɔɔ kafɔɔ lawa nfa anan-ye lɛsaa le nintɔɔwa nii. ");
INSERT INTO snw_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ni di Petro lakaalɛ nwɔ alɛ, “Tɔkɔ mi, minko ɔsa lɛfɔ, kasɔ lee ka biayɔ biasunsũ ni koto ko baataye ni, kumuu nɛ?” Ni di ɔsanko nwu labuɛ alɛ, “Yii, kumuu nɛ.” ");
INSERT INTO snw_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Petro latɔkɔ nwɔ alɛ, “Be oso minko ɔsa lɛfɔ biɛbla kanya kanwii biɔsɔ Saate Ninwuna minnyu? Nyu, bakosopo ba niɛyɔ ɔsa lɛfɔ bɛɛlaakookaa nii nfɛ n-yɛ kaayokontũ babayɔ afɔ kafɔɔ mansifiko.” ");
INSERT INTO snw_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Nfanwu, nnwɔɔ kafɔɔ anɔɔ aapɛ kaasɔ, aakpi. Obe wɔ baakosopo ba mmle lawa babanya alɛ aatookpi ate nii, ni baayɔ nnwɔɔ kafɔɔ baalaakookaa di ɔsa ɔlɔɔkɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Nioso lɛyɛkɛ lapɛ mba niefũ beenu ni ku batii ba bamuu nianu ni lɛsaa le niawa nii osie kanya. ");
INSERT INTO snw_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Yaa labla atuosaa ku sɛkpɛ se niabla ni ɔkpɛ aafenko di batɔkyɛntɛ suoto baatii nwu kamɛ. Bafũbanutɛ ba mmle nkyaka di Yuda batii Olekatakɔ kasikɔ ka manlɛɛ ni Salomo Lɛkpata kamɛ. ");
INSERT INTO snw_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Batii ba ninayikyi ni layɔ dibu baata ma, kafɔɔ batafuo otu okpee otoobuo ma kaamɛ. ");
INSERT INTO snw_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Kafɔɔ batii kpinwu basuɔtɔ ku basanko, lakyi siikpile lɛma kamɛ, baafũ Saate baanu. ");
INSERT INTO snw_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Batii bawo layɔ bafiɛtɛ lɛma baatensa di mpa ku sɛkla suoto baalaatɛ diɛ akpaka, di aba ya beefũ beenu alɛ se Petro kofe kunyii nɔɔ makpete ni di bafiɛtɛ nwu suoto sifiɛ nyɔɔ ma nii! ");
INSERT INTO snw_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Baakpaa bafiɛtɛ ku batii ba di anwuna kpile ladiki ni kasiɛ baakyeko sekpoo se niɛmana Yerusalem siekyi ni baawako ɔkyɛ lɛma, baayɔɔsa bamuu kafɔɔ sifiɛ. ");
INSERT INTO snw_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Nioso Yuda batii Oletatɛ Nɔɔfo ku batii nɔɔ ba niekye ni dikudi le bɔɔlɛɛ ni Saduki batii kamɛ, lakye kasɔ baatɔɔkpɛko batɔkyɛntɛ nwu nkpo sɛsɔfɔwo osie kanya. ");
INSERT INTO snw_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Nkpo oso, baamufũ ma baalaatɛ leeyo. ");
INSERT INTO snw_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Kafɔɔ di kakyɛ yi, Yaa tɔkyɛntɛ onwii labasɛkɛtɛ leyo katenkɔ nwu nkpo kayoko aata ma baadie. Ni aatɔkɔ ma alɛ, ");
INSERT INTO snw_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Bitɔɔkyɛ Yuda batii kasikɔ biɛlaatoobuɛ nkpa fɔle be mmle ɔlaa omuu bita batii!” ");
INSERT INTO snw_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Nioso obe wɔ kaale lasɛ nii, baakyɔɔ Yaa tɔkyɛntɛ ɔlaa atoko, baasifi Yaa Olekatakɔ baalaakyako asaa otuo. Nioso di obe nwu kamɛ, Oletatɛ Nɔɔfo ku bakyakaakotɛ nɔɔ, baalɛɛ bawo ku Yuda batii banɔɔfo baasiisa, ni baakpee batii alɛ balaadiki batɔkyɛntɛ nwu leeyo katenkɔ bawako ma nɛ. ");
INSERT INTO snw_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Kafɔɔ obe wɔ baakyɛ nii, batanya ma! Nioso baakple babatɔkɔ ma alɛ, ");
INSERT INTO snw_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Buɔɔkyɛ nii, bɛɛsɛɛ leyo nwu kayoko kpa, batii ba nikonyu ni nfa n-yɛ di kayokontũ nwu. Kafɔɔ obe wɔ buɔɔsɛkɛtɛ nii, kuonwii diesi di leyo nwu kamɛ!” ");
INSERT INTO snw_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Di obe wɔ di Yaa Olekatakɔ banyuntɛ ɔnɔɔfo ku Yaa olebatatɛ banɔɔfo lanu ni ɔlaa wɔ mmle, otu lakpanko ma nwaa, diekye baaye lɛsaa le kafɔɔ niɛwa ni di batɔkyɛntɛ nwu suoto. ");
INSERT INTO snw_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ni di otii onwii lawa aabatɔkɔ ma alɛ, “Batii ba biemufũ biɛtɛ ni leeyo, nkpe di Yaa Olekatakɔ bootuo batii asaa.” ");
INSERT INTO snw_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Nfanwu basaanyuntɛ nɔɔfo ku batii nɔɔ lataka baakyɛ Yaa Olekatakɔ baalaamufũ ma baawako. Batayɔ osie baakpaa ma, diekye baatɔɔyɛkɛ alɛ, batii nwu masafɔ ma afuɔ. ");
INSERT INTO snw_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Baakpaa batɔkyɛntɛ nwu baawako nii, ni baata ma baayila di Yuda banɔɔfotii anu nɛ. Ni di Yaa Oletatɛ Nɔɔfo lakaalɛ ma alɛ, ");
INSERT INTO snw_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Butakpee ye kufiofa bulɛ bitaasinkple biakakatɛ biata kuonwii di Yesu leyooto kamɛ? Kafɔɔ bitɔɔkpɛnsa ɔlaa wɔ mmle omuu di Yerusalem kamɛ. Biomiɛ bilɛ biyɔ kukpi nɔɔ letokonanfi bitikawo di suoto!” ");
INSERT INTO snw_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ni di Petro ku batɔkyɛntɛ bamba nwu ladiki kanya alɛ, “Yaa dikpe ni buɔkyɔɔ atoko, diele batii. ");
INSERT INTO snw_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Yesu wɔ biatuna baapɛ baakaasa ni koowoso suoto aakpi nii, di bawaloo Yaa latakatɛsa nwɔ aakyeko ni bakpi kamɛ, akpe nkpa. ");
INSERT INTO snw_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Yaa lɛtɔɔ kayilakɔ kplɛ di oletanɛɛkyɛ nɔɔ. Ɛɛyɔ nwɔ ɛɛbla kafɔɔ Tunletɛ ku Dikitɛ alɛ Israel batii kawɛ osuku mankyi di situ lɛma kamɛ, manwɛ sikpile lɛma kafɔɔ ɔyɔɔkyɛ. ");
INSERT INTO snw_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Awo ku Yaa Ninwuna Klekle le ɛɛyɔ ɛɛta ni batii ba nikɔkyɔɔ nwɔ ni kotoko, awo ninle sɛlaa se mmle babuɛtɛ nɛ.” ");
INSERT INTO snw_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Obe wɔ baanu ni ɔlaa wɔ mmle, ɔblɔ lakple kuafiɛ ma nwaa, baamiɛ alɛ boolo batɔkyɛntɛ nwu nkpo. ");
INSERT INTO snw_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Kafɔɔ Farisi otii onwii kaamɛ lɛma baatɔɔlɛɛ ni Gamaliel ditatunako ma. Batii bamuu latoobu osuɔtɔ wɔ mmle nwaa, diekye Mose kufiofa tuotɛ aale. Nnwɔɔ niataka aayila ni aabuɛ alɛ bata batɔkyɛntɛ nwu nkpo badie kɛɛkɛ. ");
INSERT INTO snw_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ninfɛ aakakatɛ aata ma alɛ, “Israel batii wo nii, bilolaa binyu nwaa di lɛsaa le biomiɛ bilɛ biɔbla ni di batii ba mmle suoto! ");
INSERT INTO snw_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Obe onwii nintɔbafe nii, osuɔtɔ onwii lawɛ baatɔɔlɛɛ ni Teuda, labla suoto alɛ, otii finnle ale. Batii alafa ana latikanko nwɔ. Baalo nwɔ nii, batikankotɛ nɔɔ lasamii, dikudi nwu nkpo labiɛ kualoo. ");
INSERT INTO snw_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Nni kamaa, di batii ɔka bee kamɛ, Yuda, nnwɔ niakye ni Galilea lasiisa batii bawo aakyakaa di suoto, baatikanko nwɔ. Nnwɔɔ kafɔɔ baalo nwɔ, ni baatikankotɛ nɔɔ kafɔɔ lasamii nɛ. ");
INSERT INTO snw_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Nioso ɔlaa wɔ kɔtɔkɔ ye ni ninle alɛ, bidiɛ batii ba mmle baatɔɔkyɛ. Nse asaa ya bootuo ni ku asaa ya bɔɔbla nii, nse mma bamu ɔkpɛ kule, dilabaklɛ fiɛ kubabiɛ. ");
INSERT INTO snw_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Kafɔɔ nse Yaa ɔkpɛ kule, bulɔbafuo ma osuku otĩi. Nse diele nkpo, dii kɔwa bibanya bilɛ Yaa biɛɛtaka biyɛ biɔɔkpɛ ko!” ");
INSERT INTO snw_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Batii nwu kaasikɔ nwu nkpo lafũ Gamaliel ɔlaa nwu baakpee. Nioso, baalɛɛ batɔkyɛntɛ nwu baawako kamɛ lɛma, ni baapɛ ma nɛ. Ni baakple baatɔkɔ ma alɛ bataasimbuɛ ɔlaa kuonwii di Yesu leyooto kamɛ. Ni baadiɛ ma nɛ. ");
INSERT INTO snw_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Kafɔɔ baatoosifi nii, suoto latɔyɔɔ ma nwaa diekye baanya alɛ Yaa lefũ ma eekpee fɛ batii ba beekpee ni sinunsɔ ta Yesu oso. ");
INSERT INTO snw_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Nle mmle sɛmaa, dii biala baakyako asaa otuo baatooyie ɔlaa biene nwu kafɔɔ lɛkya baatoobuɛ di Yaa Olekatakɔ ku batii ayo alɛ, Yesu ninle Dikitɛ nwu. ");
INSERT INTO snw_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Di obe wɔ kamɛ di basaateketetɛ nwu nkpo labakyako ni ɔtɔɔpɔ yi, kananfi labuo di Yuda batii ba nikobuɛ ni Griki sele ku mba nikobuɛ ni Yuda batii sele nntɛɛ. Diekye se bɔɔsɛ dii alesaa, ánwo bakpisɔfɔ ba nikobuɛ ni Griki sele. ");
INSERT INTO snw_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ta nle mmle oso batɔkyɛntɛ lefosi banyɔ nwu lalɛɛ basaateketetɛ bamuu baasiisa baatɔkɔ ma alɛ, “Dikpe nii buɔyɔ obe loo buɔta ɔlaa biene nwu obuɛ diele di alesaa ɔsɛ suoto. ");
INSERT INTO snw_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","4","Nunua, babiloo, binyu biediki basuɔtɔ bakuɛnsĩ ba di Yaa Ninwuna ntika ni di suoto beebe ni anu kaamɛ lee. Buɔɔyɔ ma buse di ɔkpɛ wɔ mmle kanya, alɛ awo kafɔɔ buawɛ obe munta Yaa ɔlaa biene nwu obuɛ ku ɔlaa ɔpɛ ɔta Yaa.” ");
INSERT INTO snw_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ɔlaa wɔ mmle lalɛ bamuu lɛma onu, nioso baadiki Stefano otii wɔ ninkpe ni ofũ onu diɛ Yaa Ninwuna leyii nwɔ ni kamɛ pɔ. Baadiki kafɔɔ Filipo ku Prokoro ku Nikanora ku Timona ku Parmena ku osuɔtɔ wɔ niakyi aabla ni Yuda otii baatɔɔlɛɛ ni Nikolao niakye ni Antiokia. ");
INSERT INTO snw_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Batii bakuɛnsĩ ba mmle baadiki baatuo batɔkyɛntɛ nwu nɛ. Ni di mma kafɔɔ baatika ma nnɛɛ baapɛ ɔlaa baata Yaa diisi lɛma, baata ɔkpɛ nwu nkpo ɔbla nɛ. ");
INSERT INTO snw_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Nioso Yaa ɔlaa nwu lakple kuatɔɔkpɛ nwaa. Basaateketetɛ kafɔɔ di Yerusalem lakyako ɔpɔ nwaa. Ni kafɔɔ Yuda batii Yaa olebatatɛ kpinwu lakyi baafũ baanu. ");
INSERT INTO snw_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stefano, otii wɔ di Yaa lale ni sibualɛ aabla ni sɛkpɛ se niɛbla ni ɔkpɛ ku atuosaa kpinwu aatuo ni baatii nwu kamɛ. ");
INSERT INTO snw_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ni di Yuda batii dikudi le niale ni balanle batoodiɛ ni baakye ni Kirene ku Aleksandria ku mba niakye ni Kilikia ku Asia baakyako Stefano ɔlaa ɔnanfiko. ");
INSERT INTO snw_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Kafɔɔ kuonwii lɛma diikudi nwu kamɛ ditafuo nwɔ oyilako di lɛkakatɛ nɔɔ kamɛ, ta ninumbe le di Yaa Ninwuna latɔɔ ni oso. ");
INSERT INTO snw_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Nioso baanii kanya ku batii bawo alɛ baalaa mantika nwɔ di suoto alɛ, “Buonu Stefano kɔkakatɛ anyila di Mose ku Yaa suoto.” ");
INSERT INTO snw_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Sɛlaa kuafunu se mmle, lata okpoo banɔɔfo ku kufiofa batuotɛ ku batii ba mmle lanya ɔblɔ nwaa. Nioso bamufũ nwɔ baasifiko kakankɔ lɛma. ");
INSERT INTO snw_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ni baawako batii bawo, baabalaa baatika di Stefano suoto alɛ, “Obe lele ɔɔkakatɛ anyila di Yaa Olekatakɔ ka mmle klekle ku Mose kufiofa suoto. ");
INSERT INTO snw_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Buonu kafɔɔ oobuɛ alɛ otii wɔ niekye ni Nasaret, bɔɔlɛɛ nwɔ ni Yesu, ababiɛ Yaa Olekatakɔ ka mmle ankyɛlɛnsa kafɔɔ Mose afiofa ya ɛɛta wo nii.” ");
INSERT INTO snw_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Di obe nwu kamɛ, batii ba bamuu niasiɛ ni di kakankɔ nwu lanya alɛ Stefano anu latɔkpa fɛ Yaa tɔkyɛntɛ ale. ");
INSERT INTO snw_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Yaa Oletatɛ Nɔɔfo lakaalɛ Stefano alɛ, “Sɛlaa se boobuɛ ni di suoto lɛfɔ ninfũ site nkpo?” ");
INSERT INTO snw_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stefano ladiki kanya alɛ, “Bate nii ku babiloo, binu. Yaa ladiki leklekle nɔɔ aatuo ɔwa loo Abraham di Mesopotamia kasɔ suoto fiɛ aadie aasifi Haran kasɔ suoto aalaasiɛ. ");
INSERT INTO snw_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Nfa ɔɔtɔkɔ nwɔ alɛ, ‘Die fadiɛ batii lɛfɔ ku kasɔ lɛfɔ faasifi kasɔ ka matuo fɔ ni!’ ");
INSERT INTO snw_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Nioso aataka aadie di kasɔ nɔɔ suoto aalaasiɛ di Haran diɛlaase di obe wɔ di Ote lakpi nii. Nni kamaa, Yaa lakpaa nwɔ aawako kasɔ ka suoto bisi ni miɛ. ");
INSERT INTO snw_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Yaa ditata Abraham kalekɔ kukanwii ninfa, bia kasɔ nwu kakyɛɛ atabɛ aatɔɔ. Kafɔɔ aatɔkɔ nwɔ aatɛ alɛ, dii lewo kɔwa kasɔ nwu makple nnwɔɔ ku babi kale. Di obe wɔ kamɛ di Yaa latɔkɔ ni Abraham ɔlaa wɔ mmle bia, ayilofo obi kuonwii! ");
INSERT INTO snw_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Nya ɔlaa wɔ di Yaa lakple aatɔkɔ nwɔ aatɛ ni, alɛ, banantii nɔɔ bamuu makple bafɔɔ di batii bawo kasɔ suoto, babakple batii nwu bakpɛmblatɛ mansiɛ ma kafɔɔ lɛɛkpaa kalɔ diibuo kamɛ, di alɛɛ alafa ana kamɛ. ");
INSERT INTO snw_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ni aakple aatɔkɔ nwɔ alɛ, ‘Malo batii ba kasɔ basi bɔɔbla sɛkpɛ manta ma ni lɛpɔɔ. Nni kamaa, babadie kaasɔ nwu suoto manwa mamasumu mi kaasɔ ka mmle suoto busi nii.’ ");
INSERT INTO snw_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ni di Yaa layɔ lɛsɔkɔsɔkɔ obudi kanya onii aata Abraham di obe nwu kamɛ fɛ kanya ninii le nimasiɛ ni di nnwɔɔ ku Yaa nntɛɛ ku banantii nɔɔ nɛ. Nioso Abraham lalofo Isak ni aabudi nwɔ lɛsɔkɔsɔkɔ di obe wɔ aafũ ni ayi anɛ nɛ. Isak lalofo Yakob ni aabudi nwɔ lɛsɔksɔkɔ nɛ. Ni di Yakob kafɔɔ lalofo babi lefosi banyɔ ba niɛbla ni Yuda batii nfaabi be ninle ni lefosi nfaabi nnyɔ nɛ. Aabudi bamuu kafɔɔ asɔkɔsɔkɔ. ");
INSERT INTO snw_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Yakob babi ba mmle lasɛɛsa anu di obilɛma Yosef suoto. Baamufũ nwɔ baasunsũ baata batii ba niakpaa nwɔ baasifiko ni Egipte kasɔ suoto. Kafɔɔ Yaa lasiɛko nwɔ, ");
INSERT INTO snw_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","aadiki nwɔ aakyeko abuo nɔɔ amuu kamɛ. Yaa latɔɔ ninumbe, aale nwɔ sibualɛ. Nioso Egipte Ɔka Farao lababɔmbɔ nwɔ aayɔ nwɔ aase di Egipte kale kamuu kanya ku leyo nɔɔ asaa kanyayilatɛ. ");
INSERT INTO snw_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Di obe nwu kamɛ, kɔka kplɛ lakpɛ diɛ Egipte ku Kanaan kasɔ suoto diananfi dibuo diawako bate loo suoto deikye batawɛ alesaa baatoole. ");
INSERT INTO snw_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Nioso obe wɔ di Yakob lanu alɛ alesaa lawɛ ni di Egipte, ni aakpee babi nɔɔ lɛkasale alɛ bakyɛ baalaaya alesaa nwu awo bawako nɛ. ");
INSERT INTO snw_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Obe wɔ di Yakob babi lakple baakyɛ ni nfa lɛnyɔɔfa, alɛ bɔɔlaaya ni alesaa, Yosef ladiki suoto aatuo ma, aadiki ma kafɔɔ aatuo Ɔka Farao. ");
INSERT INTO snw_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Nioso Yosef latɔkɔ ma alɛ se bɛɛkyɛ, baalaakpaa Ote lɛma Yakob ku babi nɔɔ bamuu ku batii lɛma bawako Egipte. Di obe nwu kamɛ, lɛpɔ lɛma kabla fɛ batii afosi akuɛnsĩ batii banɔɔ. ");
INSERT INTO snw_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Nioso Yakob lasifi Egipte aalaasiɛ ninfa dialaadu obe wɔ aakpi nii. Babi nɔɔ kafɔɔ lasiɛ ninfa baalaadu obe wɔ baakpi nii. ");
INSERT INTO snw_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Baakplesa ma baasifiko okpoo wɔ bɔɔlɛɛ ni Sekem. Baalaakookaa ma di ɔkya kamɛ kaasɔ ka di Abraham laya ni diɛ Hamor kafaabi nfũ ku koto. ");
INSERT INTO snw_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Obe wɔ di Yaa ntam be aaka aata ni Abraham nfɛ kɔtɛɛtɛɛ nii, kafaabi loo batii ntɔɔpɔ di Egipte kasɔ. ");
INSERT INTO snw_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Diabawa kafɔɔ alɛ ɔka fɔle Farao wɔ niatoole ni sɛka di Egipte, ditatofo Yosef. ");
INSERT INTO snw_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ɔka Farao wɔ mmle lakyɔnkyɔ batii loo, aawɛ kafɔɔ disi osie di suoto lɛma, aayila ma di suoto alɛ baayɔ babi lɛma baatooyu alɛ baatookpi. ");
INSERT INTO snw_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Di obe nwu kamɛ kafɔɔ baalofo Mose nɛ. Ale obi wɔ niatɔɔlɛ ni onyu nwaa. Nioso balofotɛ nɔɔ layɔ nwɔ baalaawofasa leeyo awɛntɛ atiɛ. ");
INSERT INTO snw_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Obe wɔ manamasinfuo nwɔ ni owofasa yi, baadiki nwɔ baase kaayi. Farao obi sankobi lakyɛ aalaafũ nwɔ aaklee nwɔ fɛ nnwɔɔ omu nɔɔ kafutu kamɛ obi. ");
INSERT INTO snw_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Baatuo nwɔ Egipte batii ninumbe aamuɔ koni, aabakple otii finle di lɛɛkakatɛ ku sɛkpɛ kpinwu ɔbla kamɛ. ");
INSERT INTO snw_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Obe wɔ aafũ ni alɛɛ afosi ana, diawa nwɔ disibu alɛ dikpe nii ɛɛkyɛ ɛɛlaanyu Israel batii wo nɔɔ mmle bɔɔbla ma nii. ");
INSERT INTO snw_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Nioso di obe nwu kamɛ aakyɛ ni nfa, aanya Egipte otii kɔbla Israel otii amumu. Nioso Mose lakyɛ aalaafũ nwɔ, aalo kafɔɔ Egipte otii nwu nkpo. ");
INSERT INTO snw_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mose labu alɛ babilɛma manu kasɔ alɛ, Yaa niekyesee nwɔ alɛ, abadiki ma, kafɔɔ batanu kasɔ nkpo. ");
INSERT INTO snw_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Kaleesɛ, aakple aawa, aanya Israel batii banyɔ kɔkpɛ. Aakyɛ aalaakpanaa ma ni aatɔkɔ ma alɛ, ‘Binyu, babilɛma bile, nioso diɛɛkaatɛ alɛ biaatɔɔkpɛ nkpo.’ ");
INSERT INTO snw_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Kafɔɔ otii wɔ niatɔɔbla ni obilɛma amumu latukusa Mose, aakaalɛ nwɔ alɛ, ‘Owe niediki fɔ alɛ faayila wo kaanya, fanlewo kantɛ? ");
INSERT INTO snw_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Sɛɛ foomiɛ falɛ faloe fɛ mmle okle faalo ni Egipte otii kɔsa?’ ");
INSERT INTO snw_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Di Mose lanu ni ɔlaa wɔ mmle, lɛyɛkɛ lapɛ nwɔ nwaa. Nioso aatoso aalaawofa di Midian kasɔ suoto fɛ ɔfɔɔ. Nfa aalofo babi suɔtɔbi banyɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Alɛɛ afosi ana sɛmaa, Yaa tɔkyɛntɛ ladiki suoto aatuo nwɔ di owuufa bibii onwii niatoofiɛ ni ku ɔtɔ di ɔfaafuu kasɔ ka nintɛɛtɛɛ ni Sinai kobokote. ");
INSERT INTO snw_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Obe wɔ di Mose lanya ni nle mmle, diabla nwɔ ɔkpɛ. Aakpukuti aatɛɛtɛɛ alɛ oololaa annyu lɛsaa le dile nii, ni di Yaa lalɛɛ nwɔ aatɔkɔ nwɔ alɛ, ");
INSERT INTO snw_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ami ninle bawa lee Abraham ku Isak ku Yakob Yaa.’ Mose layɛkɛ aakyako otũtũkũ nioso atasinfuo nfa onyu. ");
INSERT INTO snw_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Ni di Yaa latɔkɔ nwɔ alɛ, ‘Diki ntokota lɛfɔ! Diekye kasɔ klekle suoto fayɛ. ");
INSERT INTO snw_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nwaako ntɔɔnya dibuo le kamɛ baatii nii nsi ni di Egipte kasɔ suoto. Diekye ntoonu ma lɛlɛɛ le boowi kaku manlɛɛ mi nii. Nioso ntɔɔwa nlɛ kodiki ma. Wa, ninkpee fɔ Egipte.’ ");
INSERT INTO snw_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Mose wɔ mmle niale otii wɔ di Israel babi lasĩ baakakatɛ nwɔ di suoto alɛ, ‘Owe niɛbla fɔ kanyayilatɛ loo ku kantɛ?’ Nnwɔɔ Mose nwu, di Yaa lakpee alɛ akyɛ aalaayila ma kaanya, aale ma dikitɛ diefe ni di Yaa tɔkyɛntɛ wɔ aadiki aatuo nwɔ ni lɛkyakaako kamɛ, diɛ ɔtɔ wɔ niatoofiɛ ni di owuufa kamɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Aakpaa ma aadieko di Egipte diefe ni sɛkpɛ se niabla ni ɔkpɛ kamɛ, diɛ Egipte ku lekpo sɛɛle kotoko ku obe wɔ baatɔɔkyɛ ni di ɔfaafuu kamɛ alɛɛ afosi ana amu. ");
INSERT INTO snw_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Mose wɔ mmle omu niatɔkɔ Israel batii alɛ, ‘Yaa makyesee ye ɔlaa buɛtɛtɛ onwii ankyeko kamɛ lee fɛ mmle eediki mi nii. Abadiki nwɔ ankyeko banantii lee kamɛ.’ ");
INSERT INTO snw_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Mose niale otii wɔ niasiisa ni bawa loo di obe wɔ kamɛ di Israel batii lawɛ ni di ɔfaafuu kamɛ. Nnwɔɔ niale otii wɔ di Yaa tɔkyɛntɛ lakakatɛko ni di Sinai kobokote osi nɛ. Nnwɔɔ kafɔɔ niafũ Yaa ɔlaa wɔ ninkpe ni nkpa aawako wo nɛ. ");
INSERT INTO snw_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Kafɔɔ, bawa loo ditakyɔɔ Mose ɔlaa atoko. Baasĩ nwɔ baamiɛ alɛ bookple mansifi Egipte kasɔ suoto. ");
INSERT INTO snw_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Nioso baatɔkɔ Mose obilɛma Aaron alɛ, ‘Bla Yaa bamba fata wo, nnwɔ nimakpaa wo ni, diekye buoye lɛsaa le nintɔɔwa ni di Mose wɔ niɛkpaa wo eedieko ni di Egipte kasɔ.’ ");
INSERT INTO snw_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Nfa nfɛ bɔɔbla afiɔ fɛ nankyue, ni baatɔɔta nya ole nɛ, baale dii kafɔɔ ku suoto lɛyɔɔ baata lɛsaa le di mma bamu baabla nii. ");
INSERT INTO snw_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ta nle mmle oso Yaa lakple ma kaamaa aadiɛ ma. Nioso baawɛ ninfa baatɔɔtɔ kufĩ ku awɛntrɛbi. Fɛ mmle di Yaa ɔlaa buɛtɛtɛ lakpana ni di Kɔkpana Klekle Kukũ kamɛ alɛ, ‘Israel batii, diele ami biayɔ babɔkɛɛ biata ole, alɛɛ afosi ana ya biawɛ ni di ɔfaafuu kamɛ. ");
INSERT INTO snw_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Kafɔɔ biayɔ Molok akpanta ku Ronfa awɛntrɛbi afiɔ biabla biatɔɔta ole. Nioso kamata mammufũ bamuu lee balanle mankpaa ye mansifiko Babilon sɛmaa fanfa.’ ");
INSERT INTO snw_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Bawa loo layɔ Yaa akpanta baaklee di ɔfaafuu kamɛ diotuo alɛ asiko ma nii. Baabla nya di letembi le kamɛ di Yaa ladiki aatuo ni Mose alɛ abla nii. ");
INSERT INTO snw_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ni sɛmaa bawa loo ba niafũ ni akpanta nwu di bate lɛma nfũ laklee nya di obe wɔ di Yosua lakpaa ma baalaakpɛko ni batii ba di Yaa latososa ni kaasɔ ka mmle suoto. Nfa baablako akpanta ya mmle ɔkpɛ dialaase di ɔka Dawid obe kamɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Yaa lakyakaako Dawid nwaa. Nioso Dawid lakaalɛ Yaa alɛ aatɔɔ osuku aatofo kasiɛkɔ ata nnwɔɔ Yakob Yaa. ");
INSERT INTO snw_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Kafɔɔ, Salomo nfɛ niabatofo kasiɛkɔ nwu. ");
INSERT INTO snw_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Kafɔɔ Yaa wɔ ninlenke nii, ninsiɛ di leyo le kamɛ batii lɛyɔ nnɛɛ beetofo nii. Yaa labuɛ aafenko di ɔlaa buɛtɛtɛ nɔɔ suoto alɛ, ");
INSERT INTO snw_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Osi ninle mi lɛkakpomii, kasɔ kafɔɔ ninle mi nkpaa kasekɔ. Lɛmɛnyo okle biafuo mi otofo ɔta? Ee ɔfɛ ninle nfũ kasiɛ ni? ");
INSERT INTO snw_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Diele ami niɛbla asaa amuu?’ ” ");
INSERT INTO snw_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Ni di Stefano lakple aatɔkɔ ma alɛ, “Batokopĩtɛ bile nwaako! Situ lee nkpe osie di Yaa suoto. Biesĩ Yaa ɔlaa kafɔɔ onu fɛ mmle baate lee labla nii. Obe lele biɔtaka minyila di Yaa Ninwuna Klekle suoto. ");
INSERT INTO snw_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ɔmɛ Yaa ɔlaa buɛtɛtɛ di bawa lee ditamiɛ alɛ boolo? Baalo Yaa ɔlaa babuɛtɛ ba niabuɛ alɛ Tininitɛ wɔ aapɛ ni ɔfɔɔ kɔwa nii. Tininitɛ nwu nkpo kafɔɔ biediɛ biɛta, bɛɛyɔ nwɔ beelo nɛ. ");
INSERT INTO snw_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Aye ninle batii ba niafũ ni Yaa kufiofa nwu nkpo biakyeko ni Yaa batɔkyɛntɛ nnɛɛ kamɛ, kafɔɔ biesĩ kufiofa nwu ole.” ");
INSERT INTO snw_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Obe wɔ baanu ni Stefano sɛlaa se aabuɛ nii, ɔblɔ lafiɛ ma baakyako anyɛɛ owee okpee nwɔ. ");
INSERT INTO snw_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Kafɔɔ ta Yaa Ninwuna Klekle le niayii ni Stefano kamɛ pɔ oso, aatakatɛsa anu aanyu osi, ni aanya Yaa lɛkpa ku Yesu n-yɛ di Yaa oletanɛɛkyɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ni aatɔkɔ ma alɛ, “Binyu! Kɔnya Yaa Kafa lɛsɛkɛtɛ, Otii Obi nwu nkpo n-yɛ di Yaa oletanɛɛkyɛ!” ");
INSERT INTO snw_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ni baayiisa kudu osie kanya, baayɔ nnɛɛ baatĩi atoko lɛma, ni baatu wididi baamufũ nwɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Baananfi nwɔ baadiki di okpoo, ni baakyako nwɔ afuɔ ɔsafɔ nɛ. Batii ba niananfi nwɔ baadieko ni ladiki awu lɛma baatɛ di okosopo wɔ bɔɔlɛɛ ni Saulo ɔkyɛ. ");
INSERT INTO snw_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Obe wɔ kamɛ bɔɔsafɔ nwɔ ni afuɔ, Stefano lalɛɛ Yaa aabuɛ alɛ, “Saate Yesu, fũ ninwuna nii!” ");
INSERT INTO snw_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ni aapɛ akunkyi aafaa osie kanya aabuɛ alɛ, “Saate, tanta ma okpile wɔ mmle koto, feenu!” Aabuɛ ɔlaa wɔ mmle aaloo nii, ni aakpi nɛ. ");
INSERT INTO snw_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulo latuna di Stefano olo suoto. Diayɔ ni di dii nwu nkpo, ni baakye kasɔ baatootikanko batii ba niafũ baanu ni di Yerusalem, ni baatoso baasifi Yudea ku Samaria nɛ. Kafɔɔ batɔkyɛntɛ nwu lasiɛ di Yerusalem. ");
INSERT INTO snw_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Yesu bafũbanutɛ bawo layɔ Stefano baawi ku sɛnyaami baalaakookaa. ");
INSERT INTO snw_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Saulo layɔ aatika di suoto osie kanya, aatoomiina mba niefũ beenu nii, aatookyi ayo aatoomufũ basuɔtɔ ku basanko aalaatɔɔtɛ leeyo katenkɔ. ");
INSERT INTO snw_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Mba niafũ baanu ni latoso baadie di Yerusalem, baakyɛ baatokyi kakɔ biala baatobuɛ Saate ɔlaa biene nwu nkpo. ");
INSERT INTO snw_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipo lakyɛ Samaria okpoo kplɛ onwii aalaabuɛ Kristo ɔlaa biene nwu nkpo aatɔkɔ batii. ");
INSERT INTO snw_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Batii kpinwu lakyɔɔ nwɔ ɔlaa wɔ aabuɛ ni atoko, diekye baanya sɛkpɛ kplɛ se aabla aatuo nii. ");
INSERT INTO snw_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Aatososa anwuna kpile di batii kpinwu kamɛ, anwuna kpile ya mmle layiisa adu osie kanya fiɛ aadie. Aayɔɔsa kafɔɔ batii ba niakpi ni kakyɛkakyɛ sifiɛ ku mba di nnɛɛ ku nkpaa lakpi nii. ");
INSERT INTO snw_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Nle mmle oso, suoto lɛyɔɔ lawɛ di Samaria okpoo kamɛ nwaa! ");
INSERT INTO snw_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Osuɔtɔ onwii lawɛ di Samaria baatɔɔlɛɛ ni Simon, aale otii wɔ niaklee ni afa nwaa. Di obe kpinwu kamɛ, aayɔ afa nɔɔ nwu aatɔɔbla sɛkpɛ kplɛ se niabla ni batii ɔkpɛ. Nioso aanyu alɛ sientɛ owo ale. ");
INSERT INTO snw_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Samaria banɔɔfo ku babisɔ bamuu mbu nwɔ, diekye di sɛkpɛ se ɔɔbla antuo ni oso. Nioso mambuɛ di suoto nɔɔ alɛ, “Nnwɔɔ ninle Yaa kafa osie wɔ bɔɔlɛɛ ni osie kplɛ nɛ.” ");
INSERT INTO snw_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Di afa nɔɔ ɔbla labla ma ni ɔkpɛ di obe kpinwu kamɛ oso, mankyɔɔ nwɔ ɔlaa atoko. ");
INSERT INTO snw_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Kafɔɔ obe wɔ baafũ Filipo ɔlaa biene wɔ aabuɛ ni di Yaa sɛka kalekɔ ku Yesu Kristo suoto baanu nii, basuɔtɔ ku basanko lafũ Yaa ntu okpeesa di Yesu Kristo leyooto kamɛ. ");
INSERT INTO snw_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon omu kafɔɔ lafũ aanu. Aafũ ni Yaa ntu okpeesa nwu nkpo, aatikanko Filipo kakɔ lele oofe. Aanya ni sɛkpɛ kplɛ ku atuosaa ya niatikanko nii, diabla nwɔ ɔkpɛ! ");
INSERT INTO snw_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Nioso obe wɔ di batɔkyɛntɛ nwu di Yerusalem lanu alɛ Samaria batii ntoofũ Yaa ɔlaa beenu nii, baakyesee Petro ku Yohane ɔkyɛ lɛma. ");
INSERT INTO snw_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Baalaabuo nii, baapɛ ɔlaa baata Yaa di mba niafũ baanu ni suoto alɛ baafũ Yaa Ninwuna Klekle. ");
INSERT INTO snw_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Diekye di obe nwu kamɛ, bayifũ Yaa Ninwuna Klekle, dilenke Yaa ntu be baakpeesa ma in di Saate Yesu leyooto kamɛ. ");
INSERT INTO snw_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Nioso, Petro ku Yohane latika ma nnɛɛ di suoto, ni baafũ Yaa Ninwuna Klekle nɛ. ");
INSERT INTO snw_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Di Simon lanya alɛ batɔkyɛntɛ latika mba niafũ baanu ni nnɛɛ baafũ ni Yaa Ninwuna Klekle, ni aayɔ koto alɛ ɔɔta Petro ku Yohane nɛ, ");
INSERT INTO snw_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ni aabuɛ alɛ, “Amii bitɛɛ osie nwu owo alɛ nse letika otii lele kɔnɛɛ, abafũ Yaa Ninwuna Klekle nwu.” ");
INSERT INTO snw_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Kafɔɔ Petro latɔkɔ nwɔ alɛ, “Minko koto lɛfɔ bibawɔɔ! Feenyu falɛ faafuo Yaa lɛtasaa ɔya ku koto? ");
INSERT INTO snw_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Kablakɔ ee kalekɔ kukanwii nnaa fɔ di ɔkpɛ wɔ mmle kamɛ, diekye otu lɛfɔ diɛkpa di Yaa anu. ");
INSERT INTO snw_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Diɛ disibu kpile le mmle, faapɛ ɔlaa fata Saate. Loobia abayɔ okpile lɛfɔ ankyɛ fɔ di disibu kpile le mmle suoto. ");
INSERT INTO snw_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Diekye lɛnya nlɛ fakpe onumbɛbɛɛ, mmia kafɔɔ okpile ntoole fɔ otu kamɛ!” ");
INSERT INTO snw_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ninfɛ di Simon latɔkɔ Petro ku Yohane alɛ, “Bipɛ ɔlaa bita Saate bitikiti lekoto di diisi nii, alɛ sɛlaa se biebuɛ ni dilaawa di suoto nii!” ");
INSERT INTO snw_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Di obe wɔ di Petro ku Yohane ntoloo ni Yaa ɔkpɛ ku ɔlaa biene lɛkya oyie di Samaria, baakple baasifi Yerusalem, bafe kafɔɔ di Samaria sekpoo kpinwu kamɛ baabuɛ ɔlaa biene nwu. ");
INSERT INTO snw_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Yaa tɔkyɛntɛ onwii latɔkɔ Filipo alɛ, “Taka faatɔɔkyɛ ɔfaafuu osuku wɔ niekye ni Yerusalem kuosoo kuosifi ni Gasa.” ");
INSERT INTO snw_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Nioso aataka aasifi osuku nwu suoto. Aatoofe nii, aakyakako ɔnɔɔfotii wɔ ninnyu ni Etiopia ɔka sanko wɔ bɔɔlɛɛ ni Kandake akesinɔsaa, lekye Yerusalem Yaa ɔlaa kapɛkɔ. ");
INSERT INTO snw_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Obe wɔ aatoofe ni leyo, asiɛ di keke wɔ di bapɔnkɔ nnanfi ni kamɛ, aatɔɔka Kɔkpana Klekle di Yaa Ɔlaa Buɛtɛtɛ Yesaia lɛkpana nii. ");
INSERT INTO snw_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Nioso Yaa Ninwuna Klekle latɔkɔ Filipo alɛ, “Tɔɔkyɛ, faalaatikanko bapɔnkɔ keke nwu nkpo.” ");
INSERT INTO snw_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filipo latoso aakyɛ ɔkyɛ nɔɔ, ni aanu alɛ ɔnɔɔfo nwu nkpo kɔka Yesaia kukũ nɛ. Ni aakaalɛ nwɔ alɛ, “Foonu asaa ya fɔɔka ni kasɔ?” ");
INSERT INTO snw_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ni di ɔnɔɔfo nwu ladiki kanya alɛ, “Oowo, lɛ kabla kanu kasɔ di otii kuonwii nnaa aadiki kasɔ antɛɛ ni?” Nioso aatikiti Filipo lekoto alɛ, abuo di keke nwu nkpo kamɛ, aasiɛ nwɔ di ɔlɔɔkɔ. ");
INSERT INTO snw_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Sɛlaa se aatɔɔka ni di Kɔkpana Klekle Kukũ nwu kamɛ niale alɛ, “Bɛɛkpaa nwɔ fɛ foso boofenko olo, ee fɛ lefosobi le di saate konwiɛ nwɔ ni sinwini ate ni kloklo, nkpo kafɔɔ atabuɛ ɔlaa nɛ. ");
INSERT INTO snw_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Baawakosa nwɔ kasɔ, kuonwii kafɔɔ ditaka aatɔɔ. Kuonwii dilabafuo ɔlaa kuonwii obuɛ di banantii nɔɔ suoto, diekye baadiki nwɔ nkpa kaasɔ ka mmle suoto.” ");
INSERT INTO snw_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ɔnɔɔfo nwu lakaalɛ Filipo alɛ, “Lekoto tɔkɔ mi, owe suoto di Yaa Ɔlaa Buɛtɛtɛ Yesaia kɔkakatɛ? Suoto nɔɔ alakaɛɛ sɛ otii bamba alaka?” ");
INSERT INTO snw_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Nioso Filipo lakye kasɔ aakakatɛ. Aakye kasɔ di Yaa ɔlaa wɔ mmle suoto, ni aatɔkɔ nwɔ ɔlaa biene wɔ niekye ni Yesu suoto nɛ. ");
INSERT INTO snw_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Obe wɔ bakyɛ ni di osuku nwu suoto boosifi nii, baadu lɛba ninwii di ntu nte nii. Ni di ɔnɔɔfo nwu latɔkɔ Filipo alɛ, “Nya ntu nwo. Be nikatĩi mi osuku alɛ, naafũ Yaa ntu okpesa nwu nkpo?” Ni di Filipo latɔkɔ nwɔ alɛ, “Nse feefũ feenu ku otu lɛfɔ omuu, faafuo ofũ.” ");
INSERT INTO snw_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ni di ɔnɔɔfo nwu labuɛ alɛ, “Lefũ Yesu Kristo lenu nlɛ Yaa Obi ale.” Nioso aayilasa keke nwu di pɔnkɔ kɔnanfi nii, ni baabuo di ntu nwu kamɛ nɛ, ni di Filipo lakpeesa nwɔ Yaa ntu di Yesu Kristo leyooto kamɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Obe wɔ kamɛ baadie ni di ntu nwu kamɛ, Saate Ninwuna lakpaa Filipo aasifiko. Ɔnɔɔfo wɔ mmle ditasinkple aanyɔɔ. Kafɔɔ lete nɔɔ aasifi ku suoto lɛyɔɔ. ");
INSERT INTO snw_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Obe wɔ di Filipo latofo nii, atɔlaadie di Asoto okpoo kamɛ. Aadie ni ninfa aatoosifi nii, aatoobuɛ ɔlaa biene nwu di sekpoo se ninkpe ni di osuku, dialaase di obe wɔ aabuo ni Kaesarea okpoo kamɛ. ");
INSERT INTO snw_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Di obe nwu nkpo kamɛ, Saulo latikanko Saate basaateketetɛ ku ninunsɛɛ alɛ oolo ma. Ni aakyɛ Yuda batii Yaa Oletatɛ Nɔɔfo nfũ, ");
INSERT INTO snw_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ni aakaalɛ nwɔ alɛ atɔɔ akũ ya nimatɔɔ ni osie an-yɔ anklee antɔɔkyɛ ni Yuda batii nsiisakɔ di Damasko anatoomufũ ni basuɔtɔ ku basanko ba nintikanko ni ofũ onu fɔle nwu anwako ni Yerusalem. ");
INSERT INTO snw_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Di obe wɔ nfɛ ɔɔtɛɛtɛɛ ni Damasko, nfanwu ɔtɔ onwii lamunaa kuakye osi kuamana nwɔ kuakyi. ");
INSERT INTO snw_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ni anɔɔ aapɛ kaasɔ nɛ. Ni aanu sɛlɔ sewo kɔkaalɛ nwɔ alɛ, “Saulo, Saulo, be oso fatikankoe nkpo?” ");
INSERT INTO snw_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ni di Saulo lakaalɛ alɛ, “Saate, owe fale?” Ni sɛɛlɔ nwu latɔkɔ nwɔ alɛ, “Ami ninle Yesu wɔ fatikanko ni osie kanya nɛ. ");
INSERT INTO snw_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Kafɔɔ, taka faatɔɔkyɛ okpoo kamɛ. Babatɔkɔ fɔ lɛɛsaa le dikpe ni fɛɛbla nii.” ");
INSERT INTO snw_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Basuɔtɔ ba niatikanko ni Saulo, baayila batabuɛ ɔlaa kuonwii. Baanu sɛlɔ kafɔɔ batanya otii kuonwii. ");
INSERT INTO snw_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Di Saulo lataka aayila aatikiti ni anu, oloosinnya. Nioso baaklee nwɔ di kɔnɛɛ baabuoko Damasko okpoo kamɛ. ");
INSERT INTO snw_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Nioso aasiɛ ninfa ayi atiɛ ɔlɔɔnya, atale alesaa, atanyi ntu kafɔɔ. ");
INSERT INTO snw_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Di obe nwu nkpo kamɛ, bafũbanutɛ onwii lawɛ di Damasko, nwɔ baatɔɔlɛɛ ni Anania. Saate ladiki suoto aatuo nwɔ ni aalɛɛ nwɔ alɛ, “Anania!” Ni aatuna aabuɛ alɛ, “Teete, nnyɛ!” ");
INSERT INTO snw_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ni di Saate labuɛ aatɔkɔ nwɔ alɛ, “Taka, faatɔɔkyɛ osuku wɔ bɔɔlɛɛ ni osuku tinini suoto, faakyɛ Yuda leyo, faakaalɛ osuɔtɔ wɔ niekye ni Tarso bɔɔlɛɛ ni Saulo, akpe ninfa ɔɔpɛ ɔlaa anta Yaa. ");
INSERT INTO snw_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Diekye ntoodiki letuo nwɔ nlɛ osuɔtɔ wɔ bɔɔlɛɛ ni Anania lɛwa ɛɛbatika nwɔ nnɛɛ alɛ aakple antɔɔnya.” ");
INSERT INTO snw_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ninfɛ di Anania ladiki kanya abuɛ alɛ, “Saate, ntoonu kpinwu asaa kpile ya di osuɔtɔ wɔ mmle ntɔɔbla ni bafũbanutɛ lɛfɔ di Yerusalem! ");
INSERT INTO snw_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Lenu kafɔɔ alɛ eefũ osie kukũ eekyeko Yaa olebatatɛ banɔɔfo nfũ alɛ aamufũ bafũbanutɛ lɛfɔ bamuu di Damasko!” ");
INSERT INTO snw_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Kafɔɔ Saate latɔkɔ nwɔ alɛ, “Tɔɔkyɛ falaabla fɛ mmle lɛtɔkɔ fɔ ni. Diekye ntoodiki Saulo fɛ otii nii wɔ nimayɔ ɔlaa biene nwu nkpo ankyɛnko ni mba ninanle ni Israel batii ku baka anu ku Israel batii bamuu. ");
INSERT INTO snw_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ami omu matuo nwɔ mmle okle dikpe ni diebuo nwɔ ni ta ami oso.” ");
INSERT INTO snw_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Nioso Anania lakyɛ aalaabuo leyo le di Saulo lawɛ nii, ni aatika nwɔ nnɛɛ di suoto nɛ, ni aatɔkɔ nwɔ alɛ, “Obiloo Saulo, Saate Yesu wɔ niadiki suoto aatuo fɔ ni di osuku, nnwɔɔ niekpee mi ɔkyɛ lɛfɔ alɛ faakple faanya, fanfũ kafɔɔ Yaa Ninwuna kaamɛ lɛfɔ.” ");
INSERT INTO snw_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Nfanwu, diabla Saulo fɛle apoo awo niefiɛ nwɔ di anu suoto, niakple aakyako ɔnya nɛ. Ninfɛ aataka aata baakpeesa nwɔ Yaa ntu nɛ. ");
INSERT INTO snw_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ninfɛ aale alesaa nɛ, niakple aawɛ osie nɛ. Nioso Saulo lasiɛ di bafũbanutɛ nwu nfũ di Damasko ayi asɛɛ. ");
INSERT INTO snw_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Nfanwu aasifi Yuda batii nsiisakɔ aalaatobuɛ alɛ Yesu ninle Yaa Obi. ");
INSERT INTO snw_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Nioso batii ba bamuu nianu nwɔ ni ɔlaa, diabla ma ɔkpɛ. Ni baakaalɛ bawo alɛ, “Diele osuɔtɔ wɔ mmle niatoolo Yesu wɔ mmle batikankotɛ di Yerusalem nɛ? Nioso kafɔɔ ɛɛwa nfũ alɛ ɔɔbamufũ bafũbanutɛ, ankpaa ma ankyɛnko olebatatɛ banɔɔfo.” ");
INSERT INTO snw_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Saulo lawɛ osie di ɔlaa wɔ mmle obuɛ kamɛ. Nioso Yuda batii ba niawɛ ni di Damasko ditafuo ɔlaa kuonwii obuɛ. Diekye aakpasa kamɛ klekle aatuo alɛ Yesu ninle Kristo. ");
INSERT INTO snw_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ayi awo sɛmaa, Yuda batii lalɛɛ bawo baabla disibu alɛ babalo Saulo. ");
INSERT INTO snw_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Kafɔɔ batii bawo lawa babatɔkɔ Saulo alɛ, boomiɛ alɛ balo nwɔ. Kakũ ku kakyɛ, balo nɔɔ latooyila baatoonyu nyoko be manfe mambuo ni okpoo nwu kamɛ, mmle baawɛ nwɔ manlo nii. ");
INSERT INTO snw_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Nioso di nkyɛntɛɛ, batii nɔɔ ba niafũ baanu ni layɔ nwɔ baakpee di kakyikyɛ kamɛ baafenko di oyoyiɛ kutuɛ baasoosa nwɔ baase kaasɔ. ");
INSERT INTO snw_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saulo lakyɛ aalaabuo Yerusalem, aamiɛ alɛ oobuo di mba niafũ baanu ni kamɛ ninfa, kafɔɔ batafũ nwɔ baanu alɛ atookyi, nioso baatɔɔyɛkɛ nwɔ. ");
INSERT INTO snw_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Nioso Barnaba lakpaa nwɔ aakyɛnko batɔkyɛntɛ nwu nfũ, ni aatɔkɔ ma mmle di Saulo ntɔɔnya ni Saate di obe wɔ aatoofe ni Damasko. Aatɔkɔ ma kafɔɔ ɔlaa wɔ di Saate latɔkɔ nwɔ nii, ku mmle di Saulo labuɛ ni ɔlaa biene nwu di Yesu leyooto kamɛ di Damasko ku sɛkambi. ");
INSERT INTO snw_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Nioso baafũ nwɔ baakpee kaamɛ lɛma. Diayɔ ni di obe nwu kamɛ, aasiɛ ma kaamɛ, obe lele aatoobuɛ Yaa ɔlaa di Yerusalem ku sɛkambi. ");
INSERT INTO snw_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Yuda batii ba nimbuɛ ni Griki sele ku Saulo labuo sɛɛlaa sewo kamɛ baanyu, kafɔɔ baamiɛ alɛ boolo nwɔ. ");
INSERT INTO snw_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Nioso obe wɔ di bafũbanutɛ bawo lanu alɛ batii ba mmle komiɛ alɛ balo nwɔ nii, baakpaa nwɔ baasifiko Kaesarea, ni baakyesee nwɔ aasifi Tarso nɛ. ");
INSERT INTO snw_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Di obe wɔ mmle kamɛ, diefe ni di Yaa Ninwuna Klekle lɛkyakako kamɛ oso, bafũbanutɛ ba niawɛ ni di Yudea ku Galilea ku Samaria kasɔ suoto yi, atoko lakyɛ ma ole, batasintɔɔyɛkɛ. Nioso baabapɔ, baayɔ dibu kafɔɔ baata Saate nwu. ");
INSERT INTO snw_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Petro lakyɛ aatookyi aatoonyu Kristo batii bamuu, diɛ osuku nɔɔ ɔkyɛ kamɛ, aakyɛ aalaanyu bafũbanutɛ ba niawɛ ni di okpoo wɔ bɔɔlɛɛ ni Lida. ");
INSERT INTO snw_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Nfa aanya osuɔtɔ onwii baatɔɔlɛɛ ni Ainea, eefefee ate di ɔkla oloofuo ɔtaka alɛɛ anɛ amu. ");
INSERT INTO snw_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Obe wɔ di Petro lanyɔɔ nii, aatɔkɔ nwɔ alɛ, “Ainea, nyu! Yesu Kristo ntɔɔyɔɔsa fɔ ofiɛ! Taka fayila! Faatakatɛsa ɔkla lɛfɔ.” Nfanwu aasie aataka aayila. ");
INSERT INTO snw_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Batii ba bamuu niawɛ ni di Lida ku Saron okpoo kamɛ, lanya Ainea nkyɛ nii, baayɔ nkpa lɛma baata Saate. ");
INSERT INTO snw_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ɔsanko onwii lawɛ di Yopa baatɔɔlɛɛ nwɔ Tabita. Di Griki sele kamɛ, baatɔɔlɛɛ nwɔ Dorka, kasɔ ninle alɛ káfɛ. Aale otii wɔ niafũ aanu nii, aatɔɔbla sifutulɛ aatɔɔta bapiitɛ obe lele. ");
INSERT INTO snw_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Diawa alɛ ofiɛ lapɛ nwɔ aakpi. Nioso basiɛwo nɔɔ lakpeesa nwɔ ntu, baalolaa nwɔ baatɛ di ayo ya beetofo beetika ni baawo ninwii kamɛ di osi. ");
INSERT INTO snw_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Nioso obe wɔ baanu alɛ Petro ntɔɔwa akpe ni di Lida, diɛ Lida lɛtɛɛtɛɛ ni Yopa oso, baakpee batii banyɔ alɛ balatikiti nwɔ lekoto aatikanko ma nkpaa nkpaa awa Yopa. ");
INSERT INTO snw_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Nioso Petro lataka aatikanko ma, baalaabuo nii, baakpaa nwɔ baasifiko leyo le osi di Dorka late nii. Bakpisɔfɔ ba niawɛ ni ninfa bamuu baamana Petro baakyi boowi kaku. Baaklee awu ya di Dorka lakaa ni aawɛ ni nkpa baatootuo nwɔ. ");
INSERT INTO snw_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Nioso Petro latɔkɔ bamuu alɛ badie di leyo nwu kamɛ, ni aapɛ akunkyi aapɛ ɔlaa aata Yaa nɛ. Ninfɛ aamunikĩi aanyu Dorka kpi, ni aabuɛ alɛ, “Tabita, taka!” Nfanwu ni aatikiti anu nɛ. Aanya ni Petro ni aataka aasiɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ninfɛ di Petro lakyɔɔ nwɔ kɔnɛɛ nɛ, ni di nnwɔɔ kafɔɔ aakpee nwɔ kole nwɔ ni aataka aayila nɛ. Ninfɛ di Petro lakple aalɛɛ bafũbanutɛ nwu ku bakpisɔfɔ nwu aawako nɛ. Ninfɛ aayɔ nwɔ akpe ni nkpa, aakpee ma di nnɛɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Nioso ɔlaa wɔ mmle lakyaka okpoo nwu kamɛ, ni baatii kpinwu lafũ Saate baanu nɛ. ");
INSERT INTO snw_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Nni kamaa, Petro lasiɛ di Yopa okpoo ayi awo diɛ osuɔtɔ wɔ baatɔɔlɛɛ ni Simon nfũ, nwɔ niatɔɔbla ni babɔkɛɛ akũ ɔkpɛ. ");
INSERT INTO snw_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Di obe nwu kamɛ, osuɔtɔ onwii lawɛ di Kaesarea okpoo kamɛ baatɔɔlɛɛ ni Kornelio. Aale kakpɛ kanyayilatɛ di Roma bakpɛtɛ ba manlɛɛ ni Italia bakpɛtɛ. ");
INSERT INTO snw_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Aale Yaa yɛkɛtɛ, nnwɔɔ ku leyo nɔɔ batii bamuu n-yɔ dibu manta Yaa. Osuɔtɔ wɔ mmle layɔ otu nɔɔ omuu aabla dibiene aata batii, ambɔmbɔ ɔlaa ɔpɛ ɔta Yaa kafɔɔ. ");
INSERT INTO snw_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Dii ninwii kakũ elomu etiɛ kamɛ, aanya odiki otuo. Di odiki otuo nwu nkpo kamɛ yi, aanya Yaa tɔkyɛntɛ onwii lawa nwɔ ɔkyɛ, ni aalɛɛ nwɔ alɛ, “Kornelio!” ");
INSERT INTO snw_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Di Kornelio lanyɔɔ nii, lɛyɛkɛ lamufũ nwɔ nwaa. Ni aakaalɛ nwɔ alɛ, “Saate, be dile?” Ninfɛ di Yaa tɔkyɛntɛ wɔ mmle latɔkɔ nwɔ alɛ, “Sifutulɛ ku ɔlaa ɔpɛ ɔta Yaa lɛfɔ, ntoodu Yaa nfũ. Nioso atɔɔwa fɔ onyuma. ");
INSERT INTO snw_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Kpee batii bawo baakyɛ Yopa baalaalɛɛ otii wɔ bɔɔlɛɛ ni Simon Petro bawako fɔ. ");
INSERT INTO snw_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Akpe diɛ Simon leyo, nwɔ ninsi ni di lekpo ɔlɔɔkɔ, ɔɔbla ni babɔkɛɛ akũ ɔkpɛ.” ");
INSERT INTO snw_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Obe wɔ di Yaa tɔkyɛntɛ nwu lasifi nii, Kornelio lalɛɛ bakpɛmblatɛ nɔɔ banyɔ ku kpɛtɛ nɔɔ onwii, nwɔ ninyila annyu nwɔ nii, ale ni Yaa yɛkɛtɛ. ");
INSERT INTO snw_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ni aatɔkɔ ma lɛsaa le niawa nii, ni aakpee ma alɛ bakyɛ Yopa. ");
INSERT INTO snw_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Kaale lasɛ nii, baakyɛ ni di osuku boofe nii, nfɛ bɔɔtɛɛtɛɛ ni okpoo nwu, Petro layie aakyɛ leyo le asi ni nsintɛɛ di kakũ alɛ ɔɔlaapɛ ɔlaa anta Yaa. ");
INSERT INTO snw_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Kɔka laklee nwɔ, aatoomiɛ lɛsaa alɛ oole, obe wɔ baatɔɔwa ni alesaa nwu, aanya odiki otuo. ");
INSERT INTO snw_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Aanya osi lasɛkɛtɛ, ni aanya lɛsaa fɛ dibula fututu kplɛ bɛɛpɛ ni akpa sɛɛnya nɔɔ ana nwu nkpo kosoo ninwa kasɔ. ");
INSERT INTO snw_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Di dibula le mmle kamɛ yi, babɔkɛɛ ate ate kpinwu ku basaanwu ku bakansiɛ lasiɛ kaamɛ. ");
INSERT INTO snw_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ninfɛ aanu sɛlɔ sinwii latɔkɔ nwɔ alɛ, “Petro, taka! Faalo fawee.” ");
INSERT INTO snw_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Kafɔɔ Petro labuɛ alɛ, “Oowo, Saate! Diidii ninwee babɔkɛɛ ba di awo Yuda batii munanle ni, munankpanko ni kafɔɔ!” ");
INSERT INTO snw_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Sɛlɔ se mmle lakple siatɔkɔ nwɔ alɛ, “Lɛsaale di Yaa ntookleklesa nii, tansinnyu falɛ dieklekle!” ");
INSERT INTO snw_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Aanya odiki otuo wɔ mmle sitiɛ simu. Ditiɛfa kamaa baayɔ dibula nwu nkpo baasifiko osi. ");
INSERT INTO snw_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Obe wɔ di Petro latoobu ni diisi, ɔɔkaalɛɛ suoto alɛ be di odiki otuo wɔ mmle kutuo ni yi, nfanwu batii ba di Kornelio lakpee ni okpoo nwu ntɔɔkaalɛ bɛɛnya Simon leyo, nfɛ bayɛ kafɔɔ di kayokontũ. ");
INSERT INTO snw_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Baalɛɛ baakaalɛ alɛ ɔfɔɔ owo nkpe ninfũ bɔɔlɛɛ ni Simon Petro? ");
INSERT INTO snw_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Di Petro lasiɛ oobu disi alɛ oonu ni odiki otuo nwu kasɔ yi, ni di Yaa Ninwuna latɔkɔ nwɔ alɛ, “Nyu! Batii batiɛ bawo kowolaa fɔ. ");
INSERT INTO snw_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Taka faakyɛ falaanya ma. Tanyɛkɛ ma otikanko ɔkyɛ, diekye ami niekpee ma.” ");
INSERT INTO snw_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Nioso Petro lakyɛ aalaanya ma, ni aabuɛ alɛ, “Ami ninle otii wɔ biowolaa ni nɛ. Aye ninkyɛ, nfũ loo buɛɛ.” ");
INSERT INTO snw_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ni baatɔkɔ nwɔ alɛ, “Buokye Kornelio nfũ, nwɔ ninle ni Roma batii kakpɛ kanyayilatɛ nɛ. Otii biene ale, anyɛkɛ Yaa kafɔɔ. Yuda batii bamuu mbɔmbɔ nwɔ ɔlaa. Yaa tɔkyɛntɛ onwii latɔkɔ nwɔ alɛ akpee otii baalɛɛ fɔ batɔɔ, aanu ɔlaa wɔ nikpe fɔ ni.” ");
INSERT INTO snw_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Nioso Petro lata bafɔɔ nwu labuo kasiɛkɔ nɔɔ aafũ ma, aabla ma kɔfɔɔ, aata baate nfa. Kaale lasɛ nii, aalolaa suoto ku bafũbanutɛ bawo di Yopa baatikanko ma baasifi. ");
INSERT INTO snw_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Baabuo Kaesarea kaleesɛ. Di obe nwu kamɛ Kornelio ntoosiisa leyo nɔɔ batii basi basoko Petro ɔwabee. ");
INSERT INTO snw_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Obe wɔ di Petro alɛ oobuo ni leyo, Kornelio lapɛ akunkyi di Petro katũ aase disi kaasɔ aatɔɔ. ");
INSERT INTO snw_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Nioso Petro latɔkɔ nwɔ alɛ, “Taka! Amii otii nle.” ");
INSERT INTO snw_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Petro latɔɔkakatɛko Kornelio obe wɔ boofe ni leyo kamɛ, nfa aanya batii kpinwu lesi basi. ");
INSERT INTO snw_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ni di Petro latɔkɔ ma alɛ, “Aye bamu biye bilɛ Yuda batii kufiofa diɛta osuku alɛ kabuo otii wɔ ninanle ni Yuda kafaabi otii kasiɛkɔ ee katɛɛtɛɛ nwɔ. Kafɔɔ Yaa ntoodiki eetuo mi alɛ ntaanyu otii kuonwii alɛ aaklekle ee ɛɛkpɔnɔnfɔ. ");
INSERT INTO snw_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Nioso obe wɔ baawa mi ni ɔlɛɛ, ni lataka lawa nɛ. Bita nkaalɛ ye, be oso biowolaa mi?” ");
INSERT INTO snw_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Nioso, Kornelio latɔkɔ nwɔ alɛ, “Diɛbla fɛ miɛ dii naafa nɛ, latɔɔpɛ ɔlaa latɔɔta Yaa di obe wɔ mmle okle kamɛ dile ni kakũ elomu etiɛ kamɛ. Nfanwu, osuɔtɔ onwii niakyɔɔ mi di anu, aakpee awu ya niatosesee ni di anu! ");
INSERT INTO snw_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","32","Aatɔkɔ mi alɛ, ‘Kornelio, sifutulɛ lefɔ ɔbla ku ɔlaa ɔpɛ ɔta Yaa lɛfɔ ntoodu Yaa nfũ! Kpee otii owo aakyɛ Yopa, aalaalɛɛ osuɔtɔ wɔ bɔɔlɛɛ ni Simon Petro, nwɔ ninsi ni di Simon wɔ nikɔbla ni babɔkɛɛ akũ ɔkpɛ nfũ diɛ lekpo ɔlɔɔkɔ.’ ");
INSERT INTO snw_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Nioso lakpee otii ninfa ninfa nlɛ abalɛɛ fɔ nɛ, dilɛ alɛ fɛɛwa nkpaa nkpaa. Nioso bamuu loo busi ninfũ di Yaa anu, buonyu osuku bulɛ buanu ɔlaa lele di Saate alɛ faatɔkɔ wo.” ");
INSERT INTO snw_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ninfɛ di Petro latɔkɔ ma alɛ, “Mianfɛ ntoonu kasɔ nlɛ nwaako Yaa ninkpee kasɛ di batii nntɛɛ. ");
INSERT INTO snw_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Kale lele otii niɛwakosa suoto kasɔ ɛɛta Yaa, ɛɛbla nwɔ dibiesaa, nnwɔɔ di Yaa nfũ nɛ. ");
INSERT INTO snw_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Biye ɔlaa biene wɔ di Yaa lakyesee ni Israel batii alɛ, diefe ni di Yesu Kristo suoto, babawɛ atoko ɔkyɛ ole. Nnwɔɔ kafɔɔ ninle batii bamuu Saate nɛ. ");
INSERT INTO snw_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Batoobuɛ ɔlaa wɔ mmle beefenko di Yudea kasɔ kamuu suoto, baakye kasɔ di Galilea di obe wɔ kamɛ di Yohane layie ni lɛkya di Yaa ntu okpeesa suoto sɛmaa. ");
INSERT INTO snw_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Biye mmle okle di Yaa layɔ Ninwuna Klekle nɔɔ ku osie aakpee ni di Yesu Nasaret Otii nwu kamɛ. Aakyi aba kpinwu aatɔɔbla dibiene, aayɔɔsa batii ba bamuu di Abonsam latɔɔkpɛko ni sifiɛ, diekye Yaa lasiɛko nwɔ. ");
INSERT INTO snw_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Buodiki mumbuɛ asaa ya buanya aabla ni di Israel kasɔ ku Yerusalem kamɛ. Ni kamaa baakaasa nwɔ koowoso suoto baalo. ");
INSERT INTO snw_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Kafɔɔ, Yaa lakple aasɛnkɛsa nwɔ aakyeko kukpi kamɛ dii tiɛfa, aata batii lanyɔɔ. ");
INSERT INTO snw_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Diele batii bamuu nianyɔɔ. Kafɔɔ awo ba aadiki nii, awo nianyɔɔ nɛ. Mia kafɔɔ buale, buanyi ku nnwɔɔ, aataka aakye ni kukpi kamɛ. ");
INSERT INTO snw_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ni aatɔkɔ wo alɛ, bubuɛ ɔlaa biene wɔ mmle buta batii. Buodiki bubuɛ kafɔɔ bulɛ nnwɔɔ Yesu di Yaa lediki alɛ aakanko batii ba ninkpe ni nkpa ku bakpi bamuu. ");
INSERT INTO snw_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Yaa ɔlaa babuɛtɛtɛ bamuu labuɛ di suoto nɔɔ alɛ, olele niefũ nwɔ eenu mawɛ sikpile nɔɔ ɔyɔ ɔkyɛ di leyooto nɔɔ osie kamɛ.” ");
INSERT INTO snw_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Obe wɔ di Petro diiloo ni lɛkakatɛ, ni di Yaa Ninwuna lawa di batii ba bamuu ninsi boonu ni Petro ɔlaa nwu suoto nɛ! ");
INSERT INTO snw_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Yuda batii ba niefũ beenu ni baatikanko Petro baakye ni Yopa, lanya alɛ Yaa ntɔɔyɔ Ninwuna Klekle nɔɔ eekpete ni di batii ba ninanle ni Yuda batii suoto, diabla ma ɔkpɛ. ");
INSERT INTO snw_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Diekye baanu boobuɛ sele fɔle mantansa Yaa Nimuɔ nɔɔ. Nioso Petro labuɛ alɛ, ");
INSERT INTO snw_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Batii ba mmle lefũ Ninwuna Klekle, fɛ mmle okle di awoo buafũ nii. Lɛsaa lewo katĩi ma osuku alɛ balaakpeesa ma Yaa ntu?” ");
INSERT INTO snw_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Nioso aata ma osuku alɛ, bakpeesa ma Yaa ntu di Yesu Kristo leyooto kamɛ. Nni sɛmaa, baatikiti Petro lekoto alɛ asiɛko ma ayi asɛɛ. ");
INSERT INTO snw_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ditafũ obe fiɛ di batɔkyɛntɛ ku bafũbanutɛ bamba di Yudea lanu alɛ mba ninanle ni Yuda batii kafɔɔ ntoofũ Yaa ɔlaa beenu. ");
INSERT INTO snw_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Nioso obe wɔ di Petro lakple aasifi ni Yerusalem, Yuda batii ba niefũ beenu nii ditatunako nwɔ, ni baabuɛ alɛ, ");
INSERT INTO snw_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Fɛɛbla onwii ku batii ba ninambudi ni asɔkɔsɔkɔ, feekpe kafɔɔ kɔnɛɛ kaasɛfɛ kanwii kamɛ biele alesaa!” ");
INSERT INTO snw_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Nioso Petro ladiki sɛlaa se mmle simuu kasɔ aata ma, aatɔkɔ ma alɛ, ");
INSERT INTO snw_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Di obe wɔ latɔɔpɛ ɔlaa latɔɔta ni Yaa di Yopa yi, ni lanya odiki otuo nɛ. Nfa lanya dibula kplɛ ninwii bakle ni atokosi ana nwu boosoosa mankyeko osi manwako kasɔ di anu nii. ");
INSERT INTO snw_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Lalolaa kamɛ lanyu nii, lanya babɔkɛɛ ate ate di dibula kplɛ nwu suoto, babɔkɛɛ ba nikpe ni nkpaa nna ku mba ninkpe ni kobe ku mba ninkpɔkɔ ni kaasɔ ku bakansiɛ ba munanle ni kafɔɔ. ");
INSERT INTO snw_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ni lanu sɛlɔ latɔkɔ mi alɛ, ‘Petro! Taka! Faalo fawee.’ ");
INSERT INTO snw_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Ni labuɛ nlɛ, ‘Oowo! Saate, diidii! Ninle lɛsaa le di Yuda batii ninanle ni di kufiofa kanya, ninanklekle ni ee diɛkpɔnɔnfɔ ni nnya.’ ");
INSERT INTO snw_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Kafɔɔ sɛlɔ nwu lakple siakye osi siabuɛ alɛ, ‘Lɛsaa le di Yaa ntookleklesa nii, tansinnyu falɛ dieklekle.’ ");
INSERT INTO snw_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","“Diabla nkpo sitiɛ simu. Nni sɛmaa, baayɔ dibula nwu ku babɔkɛɛ nwu niasiɛ ni kaamɛ baasifiko osi. ");
INSERT INTO snw_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Di obe nwu kamɛ, batii batiɛ ba baakpee baakye ni Kaesarea alɛ babalɛɛ mi ni ntɔɔwa bɛɛbabuo leyo le lasiɛ nii. ");
INSERT INTO snw_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Yaa Ninwuna latɔkɔ mi alɛ ntikanko ma nkyɛ, ntaanyɛkɛ. Babiloo bafũbanutɛ ba mmle bakuɔ latikankoe buakyɛ bualaabuo osuɔtɔ wɔ niakpee alɛ babalɛɛ mi ni leyo. ");
INSERT INTO snw_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Aatɔkɔ wo kafɔɔ mmle okle di Yaa tɔkyɛntɛ ladiki suoto aatuo nwɔ ni leeyo nɔɔ, aatɔkɔ nwɔ kafɔɔ alɛ, ‘Kpee otii aakyɛ Yopa aalaawolaa Simon Petro. ");
INSERT INTO snw_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Abatɔkɔ fɔ sɛlaa se nimata alɛ afɔ ku leyo lɛfɔ batii bamuu minwɛ ni didiki.’ ");
INSERT INTO snw_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Lakye kasɔ kɔtɔkɔ ma ni ɔlaa biene nwu, ni di Yaa Ninwuna Klekle lawa ma di suoto fɛ mmle okle diawa wo ni di suoto kaasɔ kakyekɔ nɛ! ");
INSERT INTO snw_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ni lanyuma ɔlaa wɔ di Saate labuɛ ni alɛ, ‘Yohane layɔ ntu aakpeesa batii. Kafɔɔ, Yaa mayɔ Ninwuna Klekle ankpeesa ye.’ ");
INSERT INTO snw_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Nse Yaa niɛta batii ba ninanle ni Yuda batii lɛtasaa le mmle fɛ mmle okle aayɔ aata wo ni di obe wɔ buafũ Saate Yesu Kristo buonu nii, owe nle katĩi Yaa osuku?” ");
INSERT INTO snw_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Di obe wɔ baanu in sɛlaa se mmle, baadiɛ ɔlaa lɛma nwu ɔnanfi, ni baakye kasɔ baatɔɔtansa Yaa alɛ, “Yaa ntɔɔta batii ba ninanle ni Yuda batii osuku alɛ baakyi manwa ɔkyɛ nɔɔ alɛ baawɛ nkpa.” ");
INSERT INTO snw_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Di obe wɔ kamɛ di asaa ya mmle latɔɔwa nii, bafũbanutɛ ba niatoso ni ditikanko le niawa ma ni di suoto ta Stefano olo oso, baasifi Foinike ku Kipro ku Antiokia. Baatookyi baatoobuɛ ɔlaa biene nwu, kafɔɔ diele batii bamuu baatɔɔtɔkɔ, Yuda batii lete baatɔɔtɔkɔ. ");
INSERT INTO snw_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Kafɔɔ, bafũbanutɛ ba niakye Kipro ku Kirene lakyɛ Antiokia baalaatoobuɛ Saate Yesu ɔlaa nwu baatɔɔta batii ba ninanle ni Yuda batii. ");
INSERT INTO snw_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Diekye Saate osie latika ma di suoto, nioso batii kpinwu lakyi baafũ Saate nwu baanu. ");
INSERT INTO snw_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Di obe wɔ di bafũbanutɛ ba niawɛ ni di Yerusalem lanu ni lɛsaa le nikɔwa ni ninfa, baakyesee Barnaba alɛ atɔɔkyɛ Antiokia. ");
INSERT INTO snw_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Aalaabuo ni nfa aanya mmle okle di Yaa ntɔɔkyakaako ma nii, suoto layɔɔ nwɔ nwaa, nioso aakpee ma osie aapɔɔsa alɛ balolaa Saate nwu basumu ku otu biene, baatikanko nwɔ osie kanya. ");
INSERT INTO snw_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnaba lale otii biene aawɛ ofũ onu, Yaa Ninwuna Klekle lasiɛ nwɔ kaamɛ. Nioso batii kpinwu lafũ Saate nwu baanu. ");
INSERT INTO snw_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ninfɛ di Barnaba lakyɛ Tarso aalaawolaa Saulo nɛ. ");
INSERT INTO snw_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Obe wɔ aanyɔɔ nii, aakpaa nwɔ aawako Antiokia, banyɔ lɛma baasiɛ ninfa lɛlɛɛ niwii, baatuo batii dikudi nwu kplɛ asaa. Nioso di Antiokia baakasa bafũbanutɛ ɔlɛɛ alɛ Kristo bale nɛ. ");
INSERT INTO snw_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Di obe nwu kamɛ, ni di Yaa ɔlaa babuɛtɛtɛ bawo lakye Yerusalem baawa Antiokia nɛ. ");
INSERT INTO snw_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ni di onwii kaamɛ lɛma bɔɔlɛɛ ni Agabo, lataka aayila di Yaa Ninwuna Klekle kamɛ, ni aabuɛ aatɛ alɛ, kɔka dibinte kɔwa kaayi kamuu suoto. Ɔlaa wɔ mmle lawa kaanya di obe wɔ di Klaudio latoole ni sɛka. ");
INSERT INTO snw_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Nioso bafũbanutɛ ba mmle labla alɛ boosiisa asaa fɛ mmle baafuo ni mankyesee babilɛma ba ninkpe ni di Yudea. Nioso baata fɛ mmle di onwii onwii lɛma kafuo nii. ");
INSERT INTO snw_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Baakũ asaa nwu baaloo nii, baayɔ baata Barnaba ku Saulo, ni baayɔ baakyɛnko bafũbanutɛ ba ninkpe ni di Yudea banɔɔfo nɛ. ");
INSERT INTO snw_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Diɛ obe nwu nkpo kamɛ, Ɔka Herode lakyako bafũbanutɛ bawo ɔkpɛko. ");
INSERT INTO snw_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ni aata baalo Yakobo, dile ni Yohane obilɛma ku kapamii nɛ. ");
INSERT INTO snw_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Obe wɔ aanya alɛ suoto layɔɔ ni Yuda batii di lɛsaa le aabla ni oso, aamufũ Petro kafɔɔ di obe wɔ kamɛ boole ni Bloblo wɔ Ninantaka ni dii. ");
INSERT INTO snw_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Baayɔ nwɔ baatɛ leeyo, ni baadiki banyuntɛ bana bana akudi ana alɛ batoonyu nwɔ nɛ. Herode latɛ alɛ, abakanko nwɔ lɛɛkpaka, nse batooloo Okpi Diisi Ofe Dii nwu ole. ");
INSERT INTO snw_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Nioso baakpee Petro leeyo, banyuntɛ latoonyu nwɔ. Kafɔɔ, bafũbanutɛ nwu latɔɔpɛ ɔlaa baatɔɔta Yaa diisi nɔɔ osie kanya. ");
INSERT INTO snw_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Obe wɔ di Herode latɛ alɛ abadiki Petro anta ni batii nse kale lɛsɛ, Petro late aatɔɔkyɔsĩi di banyuntɛ banyɔ obo. Baapɛ nwɔ akpo anyɔ. Mia kafɔɔ banyuntɛ bawo layila di leyo katenkɔ nwu kayoko. ");
INSERT INTO snw_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Nfanwu, lɛkpa lewo lakpete leenyo nwu kamɛ. Ni di Yaa tɔkyɛntɛ onwii lawa aabaayila di Petro ɔlɔɔkɔ. Ni aapɛ Petro kɔnɛɛ niimuusi aasɛnkɛsa nwɔ abuɛ alɛ, “Pɛsɛwa, faataka!” Nfanwu ni di akpo nwu lafukuti di nnɛɛ nɔɔ aapɛ kaasɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ni di Yaa tɔkyɛntɛ nwu latɔkɔ nwɔ alɛ, “Yɔ awu lɛfɔ ku ntokota fakpee.” Ni di Petro labla nkpo nɛ. Ni di Yaa tɔkyɛntɛ nwu lakple aatɔkɔ nwɔ alɛ, “Yɔ awu wua lɛfɔ nwu kafɔɔ fakpee, faatikankoe.” ");
INSERT INTO snw_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ni di Petro lataka aatikanko nwɔ aadie leeyo nwu kamɛ nɛ. Di obe wɔ mmle nwu kamɛ, diate Petro fɛ lɛsaa le ɔɔnya nii, kɔlaafɔ kule ɔɔsɛ. ");
INSERT INTO snw_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Baafe di banyuntɛ kayoko kasale ku kayɔɔfa ni baalaadu abɔɔsaa kayoko kplɛ ka niɛkyɔɔ ni okpoo anu nɛ. Kayoko nwu nkpo kamu, niasɛkɛtɛ suoto, ni baafe ninka kafɔɔ baadie nɛ. Baakyɛ ni sitũ kɛɛkɛ, ni di Yaa tɔkyɛntɛ nwu layɛ di Petro anu aasifi nɛ. ");
INSERT INTO snw_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Nfa nfɛ di Petro latofo lɛsaa le niawa ni nɛ. Ni aabuɛ alɛ, “Nwaako, Saate niekyesee tɔkyɛntɛ nɔɔ alɛ abadiki mi di Herode nnɛɛ kamɛ ku asaa ya di Yuda batii konyu osuku alɛ bababla mi ni kamɛ.” ");
INSERT INTO snw_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Obe wɔ diabudi nwɔ nii, ni aasifi Maria nwɔ bɔɔlɛɛ ni Yohane Marko ɔya leyo nɛ. Nfa di batii kpinwu lasi baatɔɔpɛ ɔlaa baatɔɔta Yaa nɛ. ");
INSERT INTO snw_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Petro lapɛ kayi kokloo kɔnɛɛ, ni di ɔsankobi tɔkyɛntɛ wɔ bɔɔlɛɛ ni Roda lawa alɛ ɔbasɛkɛtɛ kayoko nwu. ");
INSERT INTO snw_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Obe wɔ aatofo alɛ Petro sɛlɔ sile nii, suoto layɔɔ nwɔ siawaalɛ! Atasɛkɛtɛ kayoko nwu, ni aatoso aasifi batii nwu kamɛ aalaatɔkɔ ma alɛ Petro ntɔɔwa ayɛ kookloo sɛmaa. ");
INSERT INTO snw_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Kafɔɔ batafũ baanu, nioso baakaalɛ nwɔ alɛ, “Foobuo afĩiɛ?” Ɔsankobi nwu nkpo labensa kanya alɛ, nwaa ni! Ni baabuɛ alɛ, “Loobia Yaa tɔkyɛntɛ wɔ nikonyu ni Petro dile.” ");
INSERT INTO snw_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Di obe nwu nkpo kamɛ kafɔɔ, Petro lakple aayila aatɔɔpɛ ɔpɛ kokloo kɔnɛɛ. Ni baalaasɛkɛtɛ nii nnwɔɔ diale, diabla ma ɔkpɛ osie kanya. ");
INSERT INTO snw_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Nioso Petro lawii ma kɔnɛɛ alɛ balo kanana. Ni aatɔkɔ ma mmle okle di Yaa lediki nwɔ ni di leyo katenkɔ nɛ. Ni aatɔkɔ ma alɛ batɔkɔ Yakobo ku bafũbanutɛ ba niebu ni. Nni sɛmaa, aadie aadiɛ ma, aasifi lɛba bamba. ");
INSERT INTO snw_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Kaale lasɛ nii, kakpɔkpɔtɔ dibinte labuo di banyuntɛ ba nikonyu ni leyo katenkɔ nwu kamɛ. Baakaalɛ kafɔɔ alɛ, “Be niɛbla Petro, fɛ eefe?” ");
INSERT INTO snw_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herode lata ma baawolaa nwɔ, kafɔɔ batanya Petro. Nioso aata baakanko leyo bayuntɛ nwu, ni aata osuku alɛ balo ma nɛ. Nni sɛmaa Herode ladie di Yudea aasifi Kaesarea aalaale obe owo ninfa. ");
INSERT INTO snw_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Obe wɔ mmle kamɛ, Herode lanya ɔblɔ aakpeeko Tiro ku Sidon batii. Nioso batii bawo lakye Tiro ku Sidon okpoo baakyɛ alɛ bɔɔlaanyɔɔ. Lɛkasale, baalaanya Blasto, otii wɔ nin-yɛ ni di Herode asaa kanya alɛ, akyakaako ma. Ni baakyɛ Herode nfũ baalaabla onwii ku nnwɔɔ, diekye Herode okpoo manwɛ alesaa mankyeko. ");
INSERT INTO snw_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Dii le di Ɔka Herode latɛ nii, aakpee akasaa, aasiɛ di lɛkakpomii suoto aakakatɛ ata batii. ");
INSERT INTO snw_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Batii nwu layiisa kudu osie kanya alɛ, “Diele otii nikɔkakatɛ, Yaa nikɔkakatɛ!” ");
INSERT INTO snw_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Nfanwu, Yaa tɔkyɛntɛ lakpee Herode ofiɛ, diekye atayɔ katansa aata Yaa. Nioso aabuo akudikudi aakpi. ");
INSERT INTO snw_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Nioso Yaa ɔlaa biene nwu lakpɛ kuakyaka kayi, bafũbanutɛ kafɔɔ labapɔ kpinwu. ");
INSERT INTO snw_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Nioso obe wɔ di Barnaba ku Saulo ntooloo ni ɔkpɛ wɔ baakpee ma ni ɔbla, baakple di Yerusalem, ni baakpaa Yohane wɔ manlɛɛ ni Marko baasifiko nɛ. ");
INSERT INTO snw_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Di Antiokia, Yaa ɔlaa babuɛtɛtɛ bawo ku basaatuotɛ lawɛ di bafũbanutɛ dikudi nwu kamɛ. Mma niale Barnaba ku Simeon, nwɔ manlɛɛ ni otii wɛɛfɛɛ ku Lukio wɔ niekye ni Kirene ku Manaen, obisɔ wɔ baananfi ni di Ɔka Herode leyo ku sibisɔ ku Saulo. ");
INSERT INTO snw_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Obe wɔ baatoosumu ni Saate, baatoonii ni kanya, Ninwuna Klekle latɔkɔ ma alɛ, “Bidiki Barnaba ku Saulo bise lete bitɛɛ, alɛ baabla ɔkpɛ wɔ oso lɛlɛɛ ma ni.” ");
INSERT INTO snw_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Nioso baanii kanya, baatika ma nnɛɛ baapɛ ɔlaa baadiki Yaa diisi lɛma, ni baata ma osuku baasifi nɛ. ");
INSERT INTO snw_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Yaa Ninwuna Klekle latuo ma osuku, baasifi okpoo wɔ bɔɔlɛɛ ni Seleukia. Nfa baayɔ oklo baataalɛ baasifi kasɔ ka nintu lɛmana diekyi ni bɔɔlɛɛ ni Kipro nɛ. ");
INSERT INTO snw_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Obe wɔ baabuo ni okpoo wɔ bɔɔlɛɛ ni Salami, baasifi Yuda batii kasiisakɔ baalaabuɛ Saate ɔlaa nwu. Marko Yohane kafɔɔ latikanko ma fɛ kyakaakotɛ. ");
INSERT INTO snw_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Nle mmle sɛmaa, baataalɛ baasifi baalabuo okpoo wɔ bɔɔlɛɛ ni Pafo. Nfa baakyakako Yuda otii onwii niale ni fatɛ bɔɔlɛɛ ni Bar-Yesu. Aabla suoto alɛ ale Yaa ɔlaa buɛtɛtɛ. ");
INSERT INTO snw_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Fatɛ wɔ mmle ku okpoo nwu kanyayilatɛ wɔ bɔɔlɛɛ ni Sergio Paulo niale basiɛwo. Nioso kanyayilatɛ wɔ mmle niale ni numbentɛ lalɛɛ Barnaba ku Saulo alɛ bawa, diekye aamiɛ alɛ onu Yaa ɔlaa nwu. ");
INSERT INTO snw_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Kafɔɔ baakyɛ nii, fatɛ wɔ mmle bɔɔlɛɛ ni di Griki sele kamɛ alɛ Elima, lananfiko ma ɔlaa. Aamiɛ alɛ oodiki kanyayilatɛ nwu disibu ku ofũ onu ankyeko ɔlaa wɔ di Saulo ku Barnaba latoobuɛ nii. ");
INSERT INTO snw_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","10","Nioso Saulo, nwɔ kafɔɔ bɔɔlɛɛ ni Paulo, layii pɔ ku Ninwuna Klekle, nianyu fatɛ di anu tuwĩi aabuɛ alɛ, “Afɔ Abonsam obi, feeyii pɔ ku kakyɔnkyɔ ku kalalaa, feekyidi lɛsaa biene ɔbla, obe lele foomunikĩisa Yaa ɔlaa nwu fanta sɛlaa kuafunu. Fabanya! ");
INSERT INTO snw_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ni aatɔkɔ nwɔ alɛ Yaa mananfi fɔ kootoko. Anu mabiɛ fɔ flabanya kufĩ kafɔɔ diɛlaase ni di obe owo kamɛ!” Nfanwu kɔmaa latĩi Elima anu diawɔfɔ nwɔ atasintɔɔnya. Ni aakyako nnɛɛ ɔnwanwanyi otikiti batii lekoto alɛ baklee nwɔ di nnɛɛ. ");
INSERT INTO snw_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Di obe wɔ di okpoo kanyayilatɛ nwu lanya ni lɛsaa le mmle diabla nwɔ ɔkpɛ, nioso aafũ Saate ɔlaa nwu aanu. Diekye lɛsaa le baatuo nwɔ ni di Saate suoto labla nwɔ ɔkpɛ. ");
INSERT INTO snw_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Nni sɛmaa, Paulo ku mba niatikanko nwɔ ni labuo di oklo kamɛ, baadie di Pafo baasifi Perge wɔ ninkpe ni di Panfilia. Nfa di Yohane Marko lakple ma sɛɛmaa, aakple aasifi Yerusalem nɛ. ");
INSERT INTO snw_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Nni sɛmaa, baadie di Perge baasifi Antiokia di Pisidia kɔmɛ suoto. Di Lɛnyɛɛtɛyi suoto, baakyɛ Yuda batii kasiisakɔ baalaasiɛ kaasɔ baatii nwu kamɛ. ");
INSERT INTO snw_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Di obe wɔ batɔɔka asaa di Mose kufiofa kukũ ku Yaa ɔlaa babuɛtɛtɛ akpanasaa beeloo nii, kasiisakɔ nwu ɔnɔɔfo labuɛ aatɔkɔ ma alɛ, “Babiloo, nse onwii lee nkpe ɔlaa wɔ nimakpee wo ni osie, ni aawa ababuɛ.” ");
INSERT INTO snw_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Nioso Paulo lataka aakplesa kɔnɛɛ alɛ balo. Ni aatɔkɔ ma alɛ, “Israel batii ku aye ba ninanle ni Israel batii biobu ni Yaa, bikyɔɔ mi atoko! ");
INSERT INTO snw_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Awo Israel batii Yaa ladiki bawa loo, aabla ma kale kplɛ di obe wɔ baale ni bafɔɔ di Egipte kasɔ suoto. Yaa lakpaa ma aadieko di Egipte kasɔ suoto ku osie nɔɔ. ");
INSERT INTO snw_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Aanyu ma di ɔfaafuu kamɛ di obe wɔ bakyɛ bookyi nii di alɛɛ afosi ana kamɛ. ");
INSERT INTO snw_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Aawɔɔsa nnle nkuɛnsĩ di Kanaan kasɔ suoto, ni aayɔ ma kasɔ aata Israel batii keekple ma kale nɛ. ");
INSERT INTO snw_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ɔsaabla wɔ mmle lafũ alɛɛ alafa ana afosi anɔɔ. “Ninle mmle sɛmaa, Yaa lata ma bakantɛ baayila ma kaanya dialaase di Yaa Ɔlaa Buɛtɛtɛ Samuel obe. ");
INSERT INTO snw_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ni baakaalɛ nwɔ alɛ ase ɔka ata ma. Ni di Yaa lata ma Kis obi Saul wɔ niakye ni Benyamin kɔna kamɛ, aale sɛka alɛɛ afosi ana nɛ. ");
INSERT INTO snw_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Kafɔɔ Yaa latakatɛsa nwɔ di sɛɛka suoto, ni aayɔ Dawid aase sɛka nwu nɛ. Dawid wɔ mmle niale otii wɔ suoto di Yaa labuɛ alɛ, ‘Yese obi Dawid ninle otii wɔ di otu nii mbɔmbɔ nii, diekye ababla mi abiesaa amuu.’ ");
INSERT INTO snw_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Di Dawid kɔna kamɛ, ni di Yaa ladiki Dikitɛ wɔ ninle ni Yesu aata Israel batii fɛ mmle abuɛ aatɛ ni nɛ. ");
INSERT INTO snw_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Nioso fiɛ di Yesu mawa nii, Ntu Kpeesatɛ Yohane lawa aabatɔkɔ Israel batii bamuu alɛ, bakyi di sikpile lɛma kamɛ, baatika Yaa anu, baakpeesa ma Yaa ntu. ");
INSERT INTO snw_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Di obe wɔ di Yohane ɔkpɛ nfɛ kɔwa ni kaloo, aakaalɛ alɛ, ‘Owe bienyu bilɛ nnle? Diele ami ninle otii wɔ bionyu osuku bilɛ abawa ni? Oowo! Otii nwu nkpi mi kamaa ɔɔwa. Otii wɔ ninansiɛko alɛ kabla ɔkpɛ kuonwii nta nii.’ ");
INSERT INTO snw_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Babiloo, aye ba ninle ni Abraham babi ku aye ba ninanle ni Yuda batii biɔyɛkɛ ni Yaa, didiki le mmle bamuu loo bɛɛyɔ bɛɛta! ");
INSERT INTO snw_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Batii ba ninkpe ni di Yerusalem ku banɔɔfo lɛma ditatofo alɛ Yesu ninle Dikitɛ nwu. Batanu Yaa ɔlaa babuɛtɛtɛ ɔlaa wɔ baabuɛ baatɛ ni kasɔ, bɔɔka ni obe lele di Lɛnyɛɛtɛyi nwu suoto. Kafɔɔ di obe wɔ baalo nwɔ ni lɛpɔɔ, bɛɛta alɛ Yaa ɔlaa babuɛtɛtɛ ɔlaa ntɔɔwa kaanya. ");
INSERT INTO snw_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Batanya okpile kuonwii di suoto nɔɔ eesiɛko ni kukpi, kafɔɔ baatɔkɔ Pilato alɛ ata balo nwɔ. ");
INSERT INTO snw_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Di obe wɔ batɔɔbla asaa ya di Yaa Kɔkpana Klekle Kukũ labuɛ ni di kukpi nɔɔ suoto beeloo nii, baadiki nwɔ koowoso suoto, baalaakookaa nwɔ di ɔkya kamɛ. ");
INSERT INTO snw_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Kafɔɔ Yaa lasɛnkɛsa nwɔ aakyeko bakpi kamɛ, aawako nkpa kamɛ. ");
INSERT INTO snw_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Nni sɛmaa, aadiki suoto kpinwu aatuo batii ba niakyɛ ni ku nnwɔɔ baakye Galilea baawa ni Yerusalem. Mma ninle batii ba nikodiki nwɔ ɔlaa mambuɛ ni nɛ. ");
INSERT INTO snw_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","“Nioso buɔyɔ ɔlaa biene nwu buɔwako ye nɛ. Ɔlaa nwu ninle alɛ, Yaa ntɔɔbla ɔlaa wɔ aabuɛ aatɛ ni bawa loo, diekye Yesu lataka aakye kukpi kamɛ. Fɛ mmle okle bɛɛkpana ni di Dawid sinu nyɔɔfa kamɛ alɛ, ‘Obi nii fale. Miɛ, ntookple fɔ kote.’ ");
INSERT INTO snw_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Nya ɔlaa wɔ di Yaa labuɛ ni di ɔtaka nɔɔ okye di kukpi kamɛ, diidii alaabuu di ɔkya kamɛ. ‘Mayɔ dikusɛkusɛ klekle le labuɛ latɛ lata ni Dawid nta fɔ.’ ");
INSERT INTO snw_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Nioso aakple aabuɛ di Dawid onu bamba kamɛ alɛ, ‘Flabatuna falɛ Klekletɛ lɛfɔ nwu abuu di ɔkya kamɛ.’ ");
INSERT INTO snw_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Ɔlaa wɔ mmle diele Dawid kulaka, diekye Dawid lasiɛ aabla Yaa ɔkpɛ obe lele fɛ mmle okle di Yaa komiɛ nii, aakpi nii baakookaa nwɔ, abuu kafɔɔ di ɔkya kamɛ. ");
INSERT INTO snw_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Kafɔɔ otii wɔ di Yaa latakatɛsa aakyeko ni kukpi kamɛ, suoto nɔɔ sina ditabuu. ");
INSERT INTO snw_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Babiloo, binu! Nioso di Yesu wɔ mmle leyooto kamɛ, ni di Yaa mayɔ sikpile lee ankyɛ ye nɛ. ");
INSERT INTO snw_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Otii lele niefũ Yesu eenu, Yaa matɔɔ lɛbɛ, di sikpile se simuu di Mose kufiofa diefuo wo ni odiki diidii. ");
INSERT INTO snw_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Nioso bilolaa binyu! Bitanta sɛlaa se di Yaa ɔlaa babuɛtɛtɛ labuɛ ni lawa ye di suoto. ");
INSERT INTO snw_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Diekye Yaa labuɛ alɛ, ‘Aye ba ninankyɔɔ mi ni ɔlaa kotoko, bilolaa binyu, nse diele nkpo, dibabla ye ɔkpɛ alɛ bibawɔɔ! Diekye lɛsaa le kɔbla ni di obe lee wɔ mmle kamɛ, nse otii owo lediki kasɔ ɛɛta ye bia yi, bilɔɔwa ɔbafũ onu.’ ” ");
INSERT INTO snw_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Di obe wɔ di Paulo ku Barnaba nfɛ kodie kaasiikɔ lɛma nwu mansifi nii, batii nwu latɔkɔ ma alɛ bakple bawa, baakple babakakatɛ bata ma di ɔlaa wɔ mmle suoto di Lɛnyɛɛtɛyi le nikɔwa ni kamɛ. ");
INSERT INTO snw_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Obe wɔ baatii ntoodie ni kaasikɔ nwu, Yuda batii ku mba nintookyi bɛɛbla ni Yuda batii bɔɔyɛkɛ ni Yaa, latikanko Paulo ku Barnaba. Batɔkyɛntɛ nwu lakakatɛ baakpee ma osie alɛ bakpee ɔnyɛɛ baasiɛ di Yaa sibualɛ nwu kamɛ. ");
INSERT INTO snw_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Lɛnyɛɛtɛyi le niatikanko nii, kɛɛkɛɛ niabu se batii bamuu di okpoo nwu lawa baabanu Saate ɔlaa wɔ baabuɛ nii. ");
INSERT INTO snw_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Di obe wɔ di Yuda batii banɔɔfo lanya ni batii dikudi le niawa ni kasikɔ nwu, diakple ma ninunsɛɛ, baananfiko Paulo ɔlaa di sɛlaa se aatoobuɛ nii, baatufa nwɔ kafɔɔ. ");
INSERT INTO snw_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Kafɔɔ Paulo ku Barnaba lakpee otu baatɔkɔ ma alɛ, “Dikaatɛ alɛ baabuɛ Yaa ɔlaa biene wɔ mmle manta Yuda batii lɛkasale. Kafɔɔ biesĩ nwu ni oso, minoobu suoto bilɛ biawɛ ni nkpa be ninnaa ni kaloo oso, bubadiɛ ye munsifi batii ba ninanle ni Yuda batii nfũ. ");
INSERT INTO snw_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Diekye nkpo ninle kufiofa ko di Yaa lata wo ni alɛ, ‘Ntɔɔyɔ fɔ lɛbla fɛ lɛkpa lɛta batii ba ninanle ni Yuda batii. Mmle okle kaayi kamuu kawɛ ni didiki.’ ” ");
INSERT INTO snw_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Nioso obe wɔ di mba ninanle ni Yuda batii lanu ni ɔlaa wɔ mmle, suoto layɔɔ ma, baatansa Yaa ɔlaa nwu. Nioso batii ba di Yaa ladiki ɛɛta ni nkpa be ninnaa ni kaloo lakple bafũbanutɛ. ");
INSERT INTO snw_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Nioso Yaa ɔlaa nwu lakyaka kasɔ nwu kamuu suoto. ");
INSERT INTO snw_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Kafɔɔ Yuda batii lata basanko ba diibu ntika ni di suoto, baye ni Yaa ku okpoo banɔɔfo lataka baayila di Paulo ku Barnaba suoto, baatososa ma di okpoo nwu kamɛ. ");
INSERT INTO snw_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Nioso di obe wɔ boodie ni di okpoo nwu kamɛ, baafɛntɛ nkpaasɔ lɛma kɔtɛ baatɛ di okpoo nwu diotuo alɛ, okpoo nwu batii diefũ ma nii. Nni nkpo sɛmaa, baadie baasifi Ikonion. ");
INSERT INTO snw_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Bafũbanutɛ ba mmle lanya suoto lɛyɔɔ, Yaa Ninwuna kafɔɔ layii ma kamɛ pɔ. ");
INSERT INTO snw_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Obe wɔ baabuo ni Ikonion kafɔɔ, Paulo ku Barnaba lakyɛ Yuda batii kasiisakɔ ka niawɛ ni ninfa. Obe wɔ baatɔkɔ ni Yuda batii ku Griki batii ɔlaa biene nwu, batii kpinwu kaamɛ lɛma lafũ ɔlaa nwu baanu. ");
INSERT INTO snw_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Kafɔɔ Yuda batii ba nintafũ Yaa ɔlaa nwu baanu nii, lakpee kakpɔkpɔtɔ di batii ba ninanle ni Yuda batii nntɛɛ, ni baataka baayila di Paulo ku Barnaba suoto nɛ. ");
INSERT INTO snw_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Kafɔɔ batɔkyɛntɛ nwu lasiɛ di okpoo nwu kamɛ obe owo baabuɛ ɔlaa biene nwu ku ɔtɔ. Nioso Saate kafɔɔ lafe di suoto lɛma aabla sɛkpɛ se niabla ni ɔkpɛ kpinwu, diotuo alɛ sifutulɛ nɔɔ ɔlaa biene nwu nte ni nkpo. ");
INSERT INTO snw_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ni di okpoo nwu batii lasɛ di akyuu anyɔ, dikyuu ninwii latikanko Yuda batii, dikyuu nyɔɔfa kafɔɔ latikanko batɔkyɛntɛ nwu nɛ. ");
INSERT INTO snw_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","6","Nioso batii ba ninanle ni Yuda batii ku Yuda batii bamu ku banɔɔfo lɛma lasi kanya alɛ bababla ma amumu mansafɔ ma afuɔ. Obe wɔ baatɔkyɛntɛ nwu lanu nii, baatoso baasifi Listra ku Derbe di Likaonia ku sekpoo se ninkpe ni di nntɛɛ nwu. ");
INSERT INTO snw_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Baalaabuɛ ɔlaa biene nwu ninfa. ");
INSERT INTO snw_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Baakyɛ ni Listra, baanya osuɔtɔ onwii di nkpaa lakpi nwɔ asi ni kaasɔ. Diayɔ ni di dii le baalofo nwɔ nii, diidii aditaka akyɛ. ");
INSERT INTO snw_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Aasiɛ aanu Paulo ɔlaa biene wɔ aabuɛ nii. Paulo lanya alɛ, osuɔtɔ nwu ntoofũ ɔlaa nwu eenu baayɔɔsɔɔ ni ofiɛ, nioso aanyu nwɔ tuwĩi. ");
INSERT INTO snw_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Paulo latɔkɔ nwɔ alɛ, “Taka fayila di nkpaa lɛfɔ suoto!” Ni di osuɔtɔ nwu layefe aataka aayila aakyako ɔkyɛ okyi nɛ. ");
INSERT INTO snw_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Obe wɔ baatii dikudi nwu lanya lɛsaa le di Paulo labla nii, baayiisa kudu osie kanya baabuɛ di Likaonia sele kamɛ alɛ, “Afiɔ bale! Beekple batii bɛɛwa wo kamɛ!” ");
INSERT INTO snw_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Nioso baatika Barnaba leyooto alɛ Seus. Ni baatika Paulo kafɔɔ leyooto alɛ Herme, diekye nnwɔɔ niatɔɔkakatɛ. ");
INSERT INTO snw_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Nioso afiɔ ya bɔɔlɛɛ ni Seus tɔtɛ di katɔkɔ nɔɔ nkaako ni okpoo lɔɔkɔ, layɔ banankyue ku atoto aawako alɛ nnwɔɔ ku batii nɔɔ bɔɔbata ole manta batɔkyɛntɛ nwu di okpoo kasukunya. ");
INSERT INTO snw_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Kafɔɔ obe wɔ di Paulo ku Barnaba lanu lɛsaa le di batii nwu lamiɛ alɛ bɔɔbla nii, baananfi awu lɛma baabɛbɛɛ, diekye batamiɛ alɛ batii nwu babla nkpo. Nioso baatoso baabuo baatii nwu kamɛ. Ni bayiisa kudu ");
INSERT INTO snw_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","baabuɛ alɛ, “Teete anɛ, be oso biɔbla nkpo? Awoo yi, batii bule fɛ aye! Buɔwa nfũ mmle bulɛ buɔbatɔkɔ ye ɔlaa biene nwu, alɛ biakyi mindiɛ asaa ya mmle ninanfĩ ni ɔbla, minwa Yaa wɔ ninkpe ni nkpa nfũ. Nnwɔɔ niɛbla osi ku kasɔ, lekpo ku asaa ya amuu ninsi ni kaamɛ! ");
INSERT INTO snw_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Saa yi, Yaa ladiɛ nnle mmuu batii kaasɔ ka mmle, baabla lɛsaa le ninlɛ ma nii. ");
INSERT INTO snw_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Kafɔɔ obe lele oodiki antuo di asaa biene nɔɔ ɔbla suoto, diotuo alɛ nwaako akpe nii. Obe lele, asaa nkpe oonyumasa ye ni sifutulɛ nɔɔ. Anta ye kanto obe lele ku alesaa kubi ku alesaa di obe kanya, ku suoto lɛyɔɔ kafɔɔ siitu lee kamɛ.” ");
INSERT INTO snw_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Nu baatɔkɔ ma sɛlaa se mmle simuu, diawɛ ma osie fiɛ baatii ba mmle ladiɛ oleɔta lɛma nwu ɔta ɔta ma. ");
INSERT INTO snw_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Kafɔɔ Yuda batii bawo lakye Antiokia di Pisidia kɔmɛ suoto ku Ikonion baawa baabamunikĩisa batii nwu disibu, baata baasafɔ Paulo afuɔ baawududusɔɔ kaasɔ baadieko di okpoo nwu kamɛ, diekye baabu alɛ atookpi. ");
INSERT INTO snw_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Kafɔɔ obe wɔ di bafũbanutɛ ba niawɛ ni ninfa labamana nwɔ baakyi nii, aakple aataka aasifi okpoo nwu kamɛ. Kaale lasɛ nii, nnwɔɔ ku Barnaba baasifi Derbe okpoo. ");
INSERT INTO snw_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Paulo ku Barnaba labuɛ ɔlaa biene nwu di Derbe. Obe wɔ baawɛ ni bafũbanutɛ bawo kpinwu ninfa baakple baasifi Listra ku Ikonion ku Antiokia di Pisidia. ");
INSERT INTO snw_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Baakpee bafũbanutɛ nwu osie, baakpee ma kafɔɔ otu alɛ bakle ofũ onu lɛma ku nwaako obuɛ. Baatɔkɔ ma kafɔɔ alɛ, “Dikpe nii buofe di abuo kpinwu kamɛ fiɛ buobuo Yaa Sɛka Kalekɔ nwu.” ");
INSERT INTO snw_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Paul ku Barnaba ladiki batunletɛ baata nsiisakɔ nwu mmuu, baapɛ ɔlaa baata Yaa, baanii kanya. Ni baayɔ ma baakpee di Saate wɔ beefũ beenu ni nnɛɛ kamɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Batoofe ni di sekpoo se ninkpe ni di Pisidia beeloo nii, baawa di Panfilia kasɔ suoto. ");
INSERT INTO snw_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Baabuɛ ɔlaa biene nwu kafɔɔ di Perge fiɛ baasifi Atalia. ");
INSERT INTO snw_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Nfa baasiɛ oklo baafe di ntu osi baakple baawa Antiokia nɛ. Lɛba le di bufũbanutɛ nwu layɔ ma baakpee ni di Saate nnɛɛ kamɛ baata ni ɔkpɛ wɔ batalaloo ni ɔbla. ");
INSERT INTO snw_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Baabuo ni Antiokia, baalɛɛ bafũbanutɛ ba niawɛ ni bamuu baasiisa dikudi, ni baabɔ ma osuku wɔ beekye ni amanniɛ nɛ. Baatɔkɔ ma kafɔɔ asaa ya amuu di Saate lafe di suoto lɛma aabla nii ku mmle okle aasɛkɛtɛ osuku aata ni batii ba ninanle ni Yuda batii baafũ Yaa ɔlaa baanu nii. ");
INSERT INTO snw_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ninfɛ baasiɛ di Antiokia di bafũbanutɛ nwu nfũ baaklɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Obe wɔ di Paulo ku Barnaba lawɛ ni di Antiokia, batii bawo lakye Yudea baawa babatootuo bafũbanutɛ asaa alɛ, “Nse baabudi ye asɔkɔsɔkɔ di Mose kufioa kanya yi, bilaafuo didiki ɔwɛ.” ");
INSERT INTO snw_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Paulo ku Barnaba lananfiko batii nwu ɔlaa wɔ mmle osie kanya. Nioso, baadiki Paulo ku Barnaba ku batii bamba bawo di Antiokia alɛ bakyɛ Yerusalem baalaanya batɔkyɛntɛ ku banɔɔfo lɛma di ɔlaa wɔ mmle suoto. ");
INSERT INTO snw_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Nioso kasiisakɔ nwu batii ladiki ma osuku baasifi, baalaafe di Foenisia ku Samaria sekpoo kamɛ baasɛɛsa bafũbanutɛ ba ninkpe ninfa. Baatɔkɔ ma mmle okle di batii ba ninanle Yuda batii kafɔɔ layɔ suoto lɛma baata ni Saate. Ɔlaa wɔ mmle lata ma suoto lɛyɔɔ nwaa. ");
INSERT INTO snw_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Obe wɔ baalaabuo ni Yerusalem, bafũbanutɛ ku batɔkyɛntɛ ku banɔɔfo lɛma lafũ ma nwaa. Ninfɛ di Paulo ku Barnaba latɔkɔ ma asaa ya amuu di Yaa labla aafenko ni di suoto lɛma nɛ. ");
INSERT INTO snw_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Kafɔɔ Farisi batii dikudi le niakyi ni siitu lɛma kamɛ baafũ Kristo baanu ni bawo lataka baayila baabuɛ alɛ, “Dikpe nii, babiloo ba ninanle ni Yuda batii kaamɛ loo, beebudi ma asɔkɔsɔkɔ bɛɛbla kafɔɔ di Mose kufiofa suoto.” ");
INSERT INTO snw_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Nioso batɔkyɛntɛ ku banɔɔfo lɛma lasi alɛ boomumufũ ɔlaa wɔ mmle mannyu. ");
INSERT INTO snw_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Obe wɔ batɔɔnanfi ɔlaa nwu bɛɛklɛsa nii, Petro lataka aayila ni aatɔkɔ ma alɛ, “Babiloo, biye bilɛ obe owo nintɔbafe nii, Yaa ladiki mi kaamɛ lee lalaabuɛ ɔlaa biene nwu latɔkɔ batii ba ninanle ni Yuda batii alɛ baafũ mannu. ");
INSERT INTO snw_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Yaa wɔ kafɔɔ ninye ni batii otu kamɛ, ladiki aatuo alɛ aafũ ma, aata ma kafɔɔ Ninwuna nɔɔ fɛ mmle okle aayɔ aata ni awo kafɔɔ. ");
INSERT INTO snw_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Atakpee kasɛ di awo ku mma nntɛɛ, diekye aafũ ma di ofũ onu lɛma oso. Aayɔ sikpile lɛma kafɔɔ aakyɛ ma fɛ mmle okle aayɔ sele wo aakyɛ wo nii. ");
INSERT INTO snw_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ni nua mɔ, be oso biɔsɔ Yaa minnyu? Be oso buɔyɔ aatoo ya di awo ku bawa loo munanfuo ni otuka, muntukasa bafũbanutɛ ba mmle nwu? ");
INSERT INTO snw_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Oowo! Diekye buofũ buonu nii, ni buɔwɛ didiki di Saate Yesu sibualɛ kamɛ nɛ, nkpo kafɔɔ nimma beefũ beenu bɛɛwɛ didiki nɛ.” ");
INSERT INTO snw_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Batii nwu bamuu baalo kanana baatoonu Barnaba ku Paulo sɛkpɛ kplɛ ku atuosaa ya baabuɛ alɛ Saate labla aafenko ni di suoto lɛma aatuo ni batii ba ninanle ni Yuda batii. ");
INSERT INTO snw_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Obe wɔ baaloo ni lɛkakatɛ lɛma, Yakobo kafɔɔ lataka aayila aabuɛ alɛ, “Babiloo bikyɔɔ mi atoko! ");
INSERT INTO snw_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simon Petro ntoonyumasa wo lɛkasale alɛ Yaa ladiki lɛbɔmbɔ nɔɔ aatuo batii ba ninanle ni Yuda batii, aadiki bawo kaamɛ lɛma alɛ baale nwɔ ni bale. ");
INSERT INTO snw_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ɔlaa wɔ di Yaa ɔlaa babuɛtɛtɛ labuɛ baatɛ nii nkaatɛ ku ɔlaa wɔ mmle. Baabuɛ alɛ, ");
INSERT INTO snw_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Nle mmle sɛmaa, makple nwa mase Dawid sɛka kalekɔ nwu kafɔɔ letofo. Mase aba ya kafɔɔ niebibiɛ ni letofo, nta ninkple ninwɛ osie. ");
INSERT INTO snw_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Nfa nfɛ baatii ba niebu nii ku mba ninanle ni Yuda batii lɛlɛɛ ni fɛ bale mi babatofo mi. Nkpo di Yaa lebuɛ ɛɛtɛ ");
INSERT INTO snw_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","kofokofoko baatii n-ye ni nɛ.’ ” ");
INSERT INTO snw_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Nioso Yakobo labuɛ alɛ, “Ole mi ninle alɛ bitanta buakpee batii ba ninanle ni Yuda batii bookyi manwa ni Yaa nfũ kubuɛ. ");
INSERT INTO snw_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Kafɔɔ bita bukpana kukũ buta ma bulɛ baasĩ alesaa ya ninankpa ni kɔmɛ, bɛɛyɔ bɛɛta ni afiɔ ole, baasĩ lɛsɔnɔkpee ku babɔkɛɛ ba beemimina beelo ni ku ntɔ ole. ");
INSERT INTO snw_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Diekye Mose kufiofa nwu bɔɔka kũ di Yuda batii kasiisakɔ kofokofoko di Lɛnyɛɛtɛyi biala kamɛ. Booyie sɛlaa nɔɔ nwu kafɔɔ lɛkya di sekpoo simuu kamɛ.” ");
INSERT INTO snw_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Nioso batɔkyɛntɛ nwu ku banɔɔfo lɛma labla onwii ku dikudi lɛma nwu, baadiki batii bawo diikudi nwu kamɛ baakyakaa di Paulo ku Barnaba suoto baakpee ma Antiokia. Baadiki basuɔtɔ banyɔ di bafũbanutɛ nwu mmbu ni nwaa, mma niale Yuda wɔ manlɛɛ ni Barsaba ku Silas nɛ. ");
INSERT INTO snw_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Kukũ ko baakle baakyɛnko ni kamɛ sɛlaa ninle alɛ, Awo, batɔkyɛntɛ ku banɔɔfo ba ninle ni babilee ba ninkpe ni di Yerusalem, buɔsɛɛsa babiloo ba ninanle ni Yuda batii biekye ni Antiokia ku Siria ku Kilikia. ");
INSERT INTO snw_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Buonu alɛ batii bawo niekye ni kamɛ loo ninfũ bɛɛwa ɔkyɛ lee, bɛɛyɔ sɛlaa sewo bɛɛbakpɔkpɔtɔsa ye disibu di asaa otuo kamɛ. Kafɔɔ, diele awo niekpee ma bulɛ babatɔkɔ ye sɛlaa nwu. ");
INSERT INTO snw_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","26","Nioso buokpee asi baawo buotika difuɔ bulɛ, buodiki batii bawo kaamɛ loo buɔkyakaa di Barnaba ku Paulo ninle ni babiloo bɔmbɔtɛ bulɛ bawa. Diekye bɛɛyɔ nkpa lɛma bɛɛta di Saate loo Yesu Kristo ɔkpɛ suoto. ");
INSERT INTO snw_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Nioso, buokyesee ye Yuda ku Silas, babatɔkɔ ye sɛlaa se buɔkpana nii. ");
INSERT INTO snw_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Diekye Yaa Ninwuna ku awo buofũ buokpee bulɛ diɛkaatɛ alɛ buɔyɔ atoo nutũle kuanwii buotika ye di suoto dilenkee n-ya mmle nwu nkpo. ");
INSERT INTO snw_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Bitanle alesaa ya bɛɛyɔ bɛɛta ni afiɔ ole, bisĩ ntɔ onyi, bisĩ babɔkɛɛ ba beemimina beelo ni ole ku lɛsɔnɔkpee. Se biɛbla di afiofa ya mmle suoto, dibalɛ ninta ye. Bisiɛ di kotoko ɔkyɛ ole kamɛ. ");
INSERT INTO snw_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Nioso obe wɔ baadiki ni batɔkyɛntɛ nwu osuku baaloo nii, baasifi Antiokia. Baalaabuo nii, baalɛɛ bafũbanutɛ nwu baasiisa. Ni baayɔ kukũ ko baakyeko ni Yerusalem baata ma nɛ. ");
INSERT INTO snw_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Obe wɔ baatii nwu laka ni kukũ nwu, suoto layɔɔ ma di ɔnyɛɛ okpeelaa nwu suoto. ");
INSERT INTO snw_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Diekye Yuda ku Silas Yaa ɔlaa babuɛtɛtɛ baale, nioso baadiki sɛlaa kasɔ baata ma baapɔɔsa, baakpee ma kafɔɔ ɔtɔ ku osie. ");
INSERT INTO snw_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Baasiɛ ni ayi asɛɛ ninfa, baadiki ma osuku ku atoko ɔkyɛ ole, baakple baasifi batii ba niakyesee ma ni nfũ di Yerusalem. ");
INSERT INTO snw_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Kafɔɔ Silas, lakple alɛ osiɛ ninfa. ");
INSERT INTO snw_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Nioso Paulo ku Barnaba lakple baasiɛ di Antiokia ninfa, mma ku batii bamba kpinwu baawɛ ninfa baatootuo asaa, baatooyie Saate ɔlaa biene nwu kafɔɔ lɛkya. ");
INSERT INTO snw_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Di ayi awo sɛmaa, Paulo latɔkɔ Barnaba alɛ, “Ta bukple bukyɛ bulaanyu babiloo ba ninkpe ni di sekpoo se simuu butooyie Saate ɔlaa biene nwu lɛkya buofe ni, buonyu bulɛ lɛ bakle.” ");
INSERT INTO snw_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnaba latuna kafɔɔ aamiɛ alɛ, dikpe ni ɛɛkpaa Yohane wɔ bɔɔlɛɛ ni Marko bɛɛkyɛ. ");
INSERT INTO snw_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Kafɔɔ Paulo nnwɔɔ atatuna nkpo! Diekye obe wɔ di nnwɔɔ ku mma baatoofe ni Panfilia, Marko Yohane lakple aasifi aadiɛ ma ninfa. ");
INSERT INTO snw_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Nioso kananfi labuo di batii ba mmle banyɔ nntɛɛ osie kanya di Marko ɔlaa wɔ mmle suoto, nioso diawa alɛ baasɛ bawo sisuku. Barnaba lakpaa Marko baafe di ntu osi baasifi Kipro. ");
INSERT INTO snw_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Paulo kafɔɔ lakpaa Silas, ni di bafũbanutɛ ba niawɛ ni ninfa layɔ ma baakpee di Yaa nnɛɛ kamɛ, ni baasifi nɛ. ");
INSERT INTO snw_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Baafe di Siria ku Kilikia baakpee bafũbanutɛ ba ninkpe ni ninfa osie. ");
INSERT INTO snw_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Ni di Paulo ku Silas ladie baakyɛ okpoo wɔ bɔɔlɛɛ ni Derbe nɛ. Baabuo ni nfa, baawaalɛ baasifi Listra. Nfa baakyakako ofũonutɛ wɔ bɔɔlɛɛ ni Timoteo nɛ. Ɔya lale Yuda otii wɔ niafũ Kristo aanu nii. Kafɔɔ ote lale Griki otii. ");
INSERT INTO snw_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Bafũbanutɛ ba ninkpe ni di Listra ku Ikonion, bamuu mambu Timoteo nwaa. ");
INSERT INTO snw_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulo lamiɛ alɛ nnwɔɔ Timoteo ɔɔkpaa ansifiko, nioso aabla nwɔ Yuda batii suoto ɔkyɛlɛnsa amanle. Aabla nkpo, diekye Yusa batii ba niawɛ ni di nntɛɛ nwu n-ye alɛ ote Griki otii ale. ");
INSERT INTO snw_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Baadie baatookyi ni sekpoo nwu kamɛ, baatɔkɔ bafũbanutɛ sɛlaa se di batɔkyɛntɛ ku Yerusalem banɔɔfo labuɛ nii. Nioso baatɔkɔ ma alɛ mma kafɔɔ babla ninkpo. ");
INSERT INTO snw_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Nioso batii ba mmle labakyako ɔpɔ, nkpo kafɔɔ di ofũ onu lɛma labawɛ osie nɛ. ");
INSERT INTO snw_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Nle mmle sɛmaa, baasifi Frigia ku Galatia, diekye Yaa Ninwuna Klekle ditata ma osuku alɛ bayie ɔlaa biene nwu lɛkya di Asia kasɔ suoto. ");
INSERT INTO snw_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Obe wɔ baalaadu ni Misia kɔmɛ, baamiɛ alɛ boobuo Bitinia kasɔ suoto. Nfa kafɔɔ, Yesu Ninwuna Klekle dita ta ma osuku alɛ bakyɛ nfa. ");
INSERT INTO snw_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Nioso baakple baamunikĩi baafe di Misia kasɔ baasifi okpoo wɔ bɔɔlɛɛ ni Troa. ");
INSERT INTO snw_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Kakyɛ nwu, Paulo lanya odiki otuo di kɔlaafɔ kamɛ. Kɔɔlaafɔ nwu kamɛ yi, aanya osuɔtɔ onwii niekye ni Makedonia, n-yɛ otikiti lekoto alɛ, “Bitaalɛ biwa Makedonia biɛbakyakaako wo kyu woo!” ");
INSERT INTO snw_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Ta odiki otuo wɔ mmle oso, nfanwu, buololaa suoto, ni buasifi Makedonia nɛ. Diekye nle mmle kotuo wo alɛ Saate komiɛ alɛ aakpee wo buɔkyɛ bulaayie ɔlaa biene nwu lɛkya ninfa. ");
INSERT INTO snw_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ni bualaayɔ oklo di Troa, buawaalɛ buasifi Samotrake. Ni kaale lasɛ nii, buasifi bualaabuo Neapoli nɛ. ");
INSERT INTO snw_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Buadie ni ninfa, buasifi Filipi wɔ ninle ni Makedonia okpoo kplɛ. Nfa kafɔɔ Roma batii kasiɛkɔ kale. Buasiɛ ninfa di ayi awo kamɛ. ");
INSERT INTO snw_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Di Lɛnyɛɛtɛyi suoto, buadie di okpoo nwu kamɛ, buakyɛ oklelɔɔkɔ di lɛba le buanyu bulɛ batii nkyɛ manaapɛ ɔlaa manta ni Yaa. Ni buawakasɔ buasiɛ ninfa buatɔɔtɔkɔ basanko ba niawa ni nfa Yaa ɔlaa nɛ. ");
INSERT INTO snw_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Batii ba nianu ni ɔlaa nwu onwii lɛma niale Lidia nɛ. Aatoosunsũ abula sɛɛle aakye ni Tiatira. Aale ɔsanko wɔ kafɔɔ ninyɛkɛ ni Yaa nwaa. Nioso obe wɔ aatoonu ni ɔlaa nwu, Saate latɔɔ lɛsɔnu aafũ ɔlaa wɔ omuu di Paulo labuɛ ni ninfa. ");
INSERT INTO snw_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Nioso obe wɔ di nnwɔɔ ku leyo nɔɔ batii bamuu ntoofũ ni Yaa ntu okpeesa nwu, aatikiti wo lekoto alɛ, “Se biefũ biekpee bilɛ ntoofũ Saate lenu, ni biwa biɛbasiɛ di ɔkyɛ nii.” Nioso aananfiko wo ɔlaa wɔ mmle dialaase di obe wɔ buatuna bualaasiɛ ni di ɔkyɛ nɔɔ. ");
INSERT INTO snw_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Dii ninwii buatoofe ni Yaa ɔlaakapɛkɔ buakyakako ɔlanlesankobi onwii di anwuna kpile nsi ni kaamɛ ampɛ ni sɛbɔ. Ambla koto kpinwu anta basaate nɔɔ di sɛbɔ nwu ɔpɛ kamɛ. ");
INSERT INTO snw_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ni di ɔsankobi wɔ mmle latikanko wo ku Paulo oyiisa kudu alɛ, “Batii ba mmle Yaa di osi bakpɛmblatɛ bale, nioso bɛɛwa nfũ alɛ bɔɔbatuo ye nkpa ɔwɛ Osuku!” ");
INSERT INTO snw_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Aabla nkpo ayi kpinwu. Nioso diatuudi Paulo, ni aamunikĩi aatɔkɔ ninwuna nwu nikɔbla ni ɔkpɛ di ɔsankobi nwu kamɛ alɛ, “Di Yesu Kristo leyooto kamɛ die di ɔsankobi nwu kamɛ!” Nfanwu, ninwuna kpile nwu ladie di ɔsankobi nwu kamɛ! ");
INSERT INTO snw_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Nioso obe wɔ baasaate nɔɔ lanya alɛ osuku wɔ manfe manwɛ ni koto ntoodie ma ni di nnɛɛ, baamufũ Paulo ku Silas baananfi ma baasifiko bakantɛ baanɔɔfo nfũ di lɛkpaka. ");
INSERT INTO snw_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Baabuɛ baatɔkɔ banɔɔfo nwu alɛ, “Batii ba mmle Yuda batii bale, bɛɛwa bɔɔlalaasa wo okpoo. ");
INSERT INTO snw_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Bɛɛwa bootuo batii asaa ya nin-yɛ ni di Roma batii afiofa suoto.” ");
INSERT INTO snw_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Nioso batii kpinwu labamana ma baakyi, baayila di Paulo ku Silas suoto. Ni di bakantɛ nwu lata baananfi ma awu baadiki di suoto, ni baata osuku alɛ bapɛ ma ku kowesee nɛ. ");
INSERT INTO snw_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Batɔɔpɛ ma nwaa beeloo nii, baatɛ ma leeyo, ni baatɔkɔ otii wɔ nikonyu ni leyo batentɛ alɛ, alolaa ma anyu nwaa. ");
INSERT INTO snw_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ta baatɔkɔ nwɔ ni nkpo oso, aayɔ ma aakpee di leyo katenkɔ nwu nntɛɛ lele, aapɛ ma lekpo kafɔɔ aatɛ. ");
INSERT INTO snw_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Di nkyɛntɛɛ, Paulo ku Silas lakyako ɔlaa ɔpɛ ɔta Yaa, baatɔɔtansa nwɔ kafɔɔ ku sinu, mba kafɔɔ niate ni leeyo ninfa latoonu sinu lɛma nwu. ");
INSERT INTO snw_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Nfanwu, kasɔ latũkũ osie kanya, diatũkunsa leyo katenkɔ nwu lɛsɔse nyoko mmuu lasɛkɛtɛ, akpo ya kafɔɔ baapɛ ni leyo batentɛ, amuu lafukuti. ");
INSERT INTO snw_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Nioso leeyo katenkɔ nyuntɛ lataka aanya alɛ leyo katenkɔ nyoko lɛsɛkɛtɛ dite nii, aabu alɛ leyo batentɛ nwu letoso beesifi. Nioso aananfi kapamii nɔɔ alɛ oolo suoto. ");
INSERT INTO snw_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Kafɔɔ, Paulo lanya lɛsaa le alɛ ɔɔbla ni suoto oso, aalɛɛ nwɔ aatɔkɔ nwɔ alɛ, “Tambla! Nya wo ninfũ.” ");
INSERT INTO snw_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ni di leyo katenkɔ nyuntɛ nwu labuɛ alɛ bawako nwɔ kanniɛ. Ni aapɛsɛwa aabuo leyo nwu ku lɛyɛkɛ, aapɛ akunkyi di Paulo ku Silas katũ. ");
INSERT INTO snw_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ni aakpa ma aadieko leeyo nwu kamɛ, aakaalɛ ma alɛ, “Teete anɛ, be dikpe ni mbla fiɛ di Yaa kafũ mi?” ");
INSERT INTO snw_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ni baatɔkɔ nwɔ alɛ, “Fũ Saate Yesu Kristo fanu, ni afɔ ku leyo lɛfɔ batii bamuu, Yaa mafũ ye.” ");
INSERT INTO snw_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Nioso baakyɛ baalaatɔkɔ nnwɔɔ ku leyo nɔɔ batii bamuu, Saate ɔlaa biene nwu. ");
INSERT INTO snw_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Nioso kakyɛ nwu leyo katenkɔ nyuntɛ nwu lakpaa ma aalaakaasa ma nkɔ nwu di suoto. Ninfɛ aafũ Yaa ntu okpeesa nwu, nnwɔɔ ku leyo nɔɔ batii bamuu nɛ. ");
INSERT INTO snw_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ninfɛ aakpaa Paulo ku Silas aasifiko leyo ni aata ma alesaa baale nɛ. Suoto layɔɔ nnwɔɔ ku leyo nɔɔ batii osie kanya, diekye baafũ Yaa baanu. ");
INSERT INTO snw_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Kaleesɛ, okpoo nwu bakantɛ lakpee bamufũtɛ baakyɛ baalaatɔkɔ otii wɔ ninnyu ni leyo batentɛ alɛ, baadiɛ “Basuɔtɔ nwu baatɔɔkyɛ.” ");
INSERT INTO snw_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Nioso leyo katenkɔ nyuntɛ nwu latɔkɔ Paulo ku Silas alɛ, “Bakantɛ alɛ ndiɛ ye biɛtɔɔkyɛ. Nioso bitɔɔkyɛ ku atoko ɔkyɛ ole.” ");
INSERT INTO snw_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ni di Paulo latɔkɔ bamufũtɛ nwu alɛ, “Bɛɛpɛ wo lɛɛkpaka, di obe wɔ manankanko wo nii, beekple bɛɛtɛ wo leeyo. Mia kafɔɔ, Roma batii bule! Ninfɛ boomiɛ alɛ badiɛ wo leewofa kamɛ alɛ otii konwii atannu? Oowo, dilaba lɛ nkpo! Bita mma bamu bawa babadiɛ wo!” ");
INSERT INTO snw_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Nioso bamufũtɛ nwu lakple baalaatɔkɔ bakantɛ nwu ɔlaa wɔ mmle. Obe wɔ kafɔɔ baanu alɛ Paulo ku Silas Roma batii bale nii, baayɛkɛ osie kanya! ");
INSERT INTO snw_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Nkpo oso baakyɛ baalaatikiti ma lekoto, ni baadiki ma leeyo katenkɔ nɛ. Ni baatɔkɔ ma alɛ badie di okpoo nwu, baatɔɔkyɛ kakɔ bamba. ");
INSERT INTO snw_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Nioso Paulo ku Silas ladie leeyo katenkɔ baasifi Lidia leyo. Nfa baalaanya bafũbanutɛ nwu. Ninfɛ baakple baakpee ma osie, fiɛ nfɛ baadie di okpoo nwu baasifi nɛ. ");
INSERT INTO snw_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Di obe wɔ baakyɛ baalaafe ni di Anfipoli ku Apolonia, baalaabuo Tesalonika. Nfũ di Yuda batii kasiisakɔ lawɛ nii. ");
INSERT INTO snw_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Nioso fɛ mmle di Paulo mbla ni obe lele, aakyɛ aalaakakatɛ aata ma di kasiisakɔ lɛma nwu, di anyɛɛtɛyi atiɛ kamɛ, aatuo ma asaa aatikanko bawo di Kɔkpana Klekle Kukũ kamɛ. ");
INSERT INTO snw_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ni aadiki kasɔ aata ma klekle di dibuo le baabuɛ baatɛ alɛ Kristo mawa aamanya ni suoto, ku mmle abakple antaka ni kuukpi kamɛ ansiɛ ni nkpa nɛ. Paulo latɔkɔ ma alɛ, “Yesu, otii wɔ suoto ɔlaa kɔtɔkɔ ye ni ninle Kristo nwu nɛ.” ");
INSERT INTO snw_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ɔlaa wɔ aadiki kasɔ aata ma ni lakyisa batii bawo situ, baafũ baanu baatikanko Paulo ku Silas. Nkpo kafɔɔ di ɔlaa nwu kamɛ lakpa Griki batii kpinwu ku basanko ba diibu ntika ni di suoto manyɛkɛ ni Yaa, baakyi siitu lɛma kamɛ. ");
INSERT INTO snw_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Kafɔɔ anu labasɛɛ Yuda banɔɔfotii nwu di suoto lɛma. Nioso baamiɛ batii kpile bawo di okpoo nwu kamɛ, ni baakpee okpoo nwu kamɛ batii ɔtɔ nɛ. Ni baasiisa batokopĩtɛ baakpee ma kudu, ni baakyɛ baalaamana Yason leyo baakyi alɛ, boomufũ Paulo ku Silas mankpaa ma mansifiko okpoo nwu, lɛkpaka. ");
INSERT INTO snw_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Kafɔɔ batanya ma ni oso, baamufũ Yason ku bafũbanutɛ bawo, baananfi ma baakpaa ma baasifiko kasikɔ lɛma. Nfa nfɛ baatooyiisa kudu alɛ, “Batii bawo kokyi kakɔ biala bookpee kudu, batɔɔwa nfũ kafɔɔ bookpee kudu nwu. ");
INSERT INTO snw_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Ni di Yason kafɔɔ lefũ ma di leyo nɔɔ nɛ. Batii ba mmle kafɔɔ bɛtaka bayɛ di Ɔka Kplɛ Kaesare kufiofa suoto. Bootuo kafɔɔ alɛ osuɔtɔ wɔ bɔɔlɛɛ ni Yesu ninle Ɔka!” ");
INSERT INTO snw_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Obe wɔ baanu ni ɔlaa wɔ mmle, ɔblɔ lafiɛ kudu bakpeetɛ dikudi nwu ku okpoo banɔɔfo. ");
INSERT INTO snw_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Nioso baata alɛ Yason ku batii nɔɔ baata letokonanfi koto fiɛ baadiɛ ma. ");
INSERT INTO snw_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Nfanwu kaakyɛ lawo nii, bafũbanutɛ ba niawɛ ni di okpoo nwu, lakpaa Paulo ku Silas baatosoko baasifiko Beroia. Baalaabuo ni nfa, baasifi Yuda batii kasiisakɔ baalaabuɛ ɔlaa biene nwu. ");
INSERT INTO snw_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Kafɔɔ Beroia batii mma, diasɛkɛtɛ ma dialenkee Tesalonika batii. Nioso baakyɔɔ atoko baanu lɛkakatɛ lɛma. Obe lele, baatoowolaa di Kɔkpana Klekle kamɛ alɛ, boonyu alɛ sɛlaa se di Paulo atoobuɛ nii, site nkpo. ");
INSERT INTO snw_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Nioso batii kpinwu kaamɛ lɛma lafũ baanu. Griki basanko ba diibu latika ni di suoto ku basuɔtɔ lɛma kpinwu lakyisa situ. ");
INSERT INTO snw_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Kafɔɔ obe wɔ di Yuda batii ba ninkpe ni di Tesalonika lanu alɛ Paulo nkpe ninfa ooyie ni ɔlaa biene nwu lɛkya di Beroia, baataka baakyɛ nfa baalaakpee kudu di okpoo nwu batii kamɛ. ");
INSERT INTO snw_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Nfanwu, bafũbanutɛ ba ninkpe ni ninfa lakpaa Paulo baasifiko lekpo kotoko. Kafɔɔ Silas ku Timoteo lasiɛ di Beroia. ");
INSERT INTO snw_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Mba niakpaa Paulo baasifiko ni lakpaa nwɔ baalaabuoko Atene. Nfa nfɛ baakple nɛ, Paulo latika ma kanya alɛ batɔkɔ Silas ku Timoteo alɛ, bapɛsɛwa babakyakako nwɔ. ");
INSERT INTO snw_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Obe wɔ di Paulo lasiɛ di Atene aasoko ni Silas ku Timoteo yi, diabuo nwɔ suoto obe wɔ aanya alɛ okpoo nwu batii lɛyɔ suoto bɛɛta ni afiɔ ɔtɔ, di okpoo nwu kafɔɔ layii ni ku afiɔsaa. ");
INSERT INTO snw_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Nioso aakyɛ aalaakakatɛ aata Yuda batii ku batii bamba ba kafɔɔ ninyɛkɛ ni Yaa di kasiisakɔ lɛma. Obe lele kafɔɔ, aatɔɔkakatɛ aatɔɔta mba aatɔɔkyakako ni di lɛkpaka. ");
INSERT INTO snw_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Nioso obe onwii, nnwɔɔ ku dikudi le ninle ni Epikuro batii ku Stoa batii ba ninsi ni di kayi ninumbe kamɛ lakyako ɔlaa ɔnanfi ku Paulo, ni baakaalɛ alɛ, “Be lɛsaa suoto di kakatɛtɛ wɔ mmle kɔkakatɛ ni?” Nioso batii bawo labuɛ alɛ, “Ditefɛ nsɔ bamba afiɔ suoto ɔɔkakatɛ.” Batii ba mmle labuɛ nkpo diekye baanu alɛ, Paulo latooyie Yesu ɔlaa biene nwu lɛkya ku okple ɔtaka nɔɔ di kukpi kamɛ. ");
INSERT INTO snw_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ta nle mmle oso, baakpaa nwɔ baasifiko lɛba le manka ni aka bɔɔlɛɛ ni Areopago banɔɔfo kasiisakɔ, ni baabuɛ alɛ, “Buomiɛ bulɛ bunu kasɔ, asaa fɔle ya footuo ni ninfũ. ");
INSERT INTO snw_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Diekye sɛlaa se foobuɛ ni kɔbla wo ɔkpɛ. Nioso buomiɛ bulɛ bunu sɛlaa nwu kasɔ.” ");
INSERT INTO snw_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Diekye Atene batii bamuu ku bafɔɔ ba ninsi ni kaasɔ ka mmle suoto nkpe obe bɛɛta sɛlaa fɔle obuɛ ku onu obe lele. ");
INSERT INTO snw_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Ninfɛ di Paulo lataka aayila di batii ba mmle anu di kasikɔ nwu, ni aatɔkɔ ma alɛ, “Di sisuku simuu suoto, lɛnya nlɛ aye Atene batii, nwaako anu lee ntika di afiɔ oleɔta suoto. ");
INSERT INTO snw_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Diekye latookyi nii, lanya aba ya minta ni ole, lanya bɛɛkpana di oleɔta difuɔ ninwii suoto alɛ, ‘Nle mmle buɔyɔ buɔta Teete loo wɔ munanye ni nɛ.’ Nioso Teete nwu minanye ni fiɛ biɔtɔɔ ni ole yi, nnwɔɔ suoto ɔlaa komiɛ nɛ ntɔkɔ ye nɛ. ");
INSERT INTO snw_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Teete wɔ mmle ninle asaa amuu saate nɛ, nnwɔɔ niɛbla osi ku kasɔ ku asaa ya amuu ninsi ni kaamɛ, anansiɛ ni kafɔɔ leeyo le baatii lɛyɔ nnɛɛ beetofo ni kamɛ. ");
INSERT INTO snw_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ánle kafɔɔ batii nnɛɛ kamɛ ɔkpɛ lɛsalɛsaa, diekye nnwɔɔ ninta batii nkpa ku ninwuna ku amiɛsaa lɛma. ");
INSERT INTO snw_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Nnwɔɔ niɛbla batii bamuu diefe ni di otii onwii suoto alɛ, baasiɛ fɛ ntɔ nnwii babi di kasɔ kamuu suoto. Nnwɔɔ omu niɛbla obe wɔ baasiɛ ni ɛɛta ma ku aba ya baasiɛ nii. ");
INSERT INTO snw_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ɛɛbla nle mmle ɛɛta awo batii alɛ, buawolaa nwɔ osuku muntikanko, mmle okle buanyɔɔ nii, diekye aakyo wo fanfa. ");
INSERT INTO snw_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Diekye fɛ mmle di akpa lee lediki eebuɛ ni alɛ, ‘Nnwɔɔ ninkpe oso di awoo bukpe, busi nwɔ kaamɛ, munte nwɔ kaamɛ.’ Beebuɛ kafɔɔ alɛ, ‘Banantii nɔɔ bule.’ ");
INSERT INTO snw_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Nfɛ bule ni Yaa babi oso, disinnaa alɛ, buabu bulɛ Yaa nte fɛ lɛsaa le batii lɛyɔ nnɛɛ bɛɛbla nii, fɛ mmle man-yɔ koto sɛɛle ee kufututu ee kowoso ee difuɔ mawola ni lɛsaa lewo letembi. ");
INSERT INTO snw_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Diayɔ ni di kayi kasɔ kakyekɔ diɛbase ni di obe wɔ mmle kamɛ, Yaa ditananfi batii kootoko ta batatofo nwɔ ni oso. Kafɔɔ nunua, eekpee wo kufiofa alɛ awo bamuu kaakɔ biala buakyisa anu loo di asaa ya mmle nwu suoto, mumunikĩisa anu munnyu nwɔ. ");
INSERT INTO snw_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Diekye atɔɔtɛ dii abafe ni di otii wɔ suoto eediki eese alɛ, abawa amankanko wo ni di nkpa loo suoto. Di nwaako ole kamɛ, aadiki nwɔ ɛɛpɛ ni ɔfɔɔ nwu kafɔɔ aatuo wo klekle di obe wɔ aatakatɛsɔɔ aakyeko ni bakpi kamɛ aawako ni nkpa.” ");
INSERT INTO snw_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Kafɔɔ obe wɔ baanu alɛ Paulo lakakatɛ ni di okple ɔtaka okye ni kukpi kamɛ yi, batii bawo lama nwɔ. Bawo kafɔɔ labuɛ alɛ, “Buomiɛ bulɛ bukple bunu sɛlaa se mmle okle.” ");
INSERT INTO snw_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Nioso, Paulo lasifi aadiɛ ma. ");
INSERT INTO snw_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Kafɔɔ batii bawo latikanko nwɔ, baakple bafũbanutɛ. Batii ba mmle onwii lɛma ninle Areopago ɔnɔɔfo wɔ bɔɔlɛɛ ni Dionisio ku ɔsanko onwii bɔɔlɛɛ ni Damari ku babamba kafɔɔ. ");
INSERT INTO snw_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Nni kamaa, Paulo ladie di Atene aasifi Korinto. ");
INSERT INTO snw_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Nfa aakyɛ aalaanya Yuda otii wɔ bɔɔlɛɛ ni Akwila, baalofo ni di Ponto. Nnwɔɔ ku ɔsɔfɔ nɔɔ Priskila baakye Italia baawa nfa ninadiklɛ nii, diekye kasɔ nwu ɔka wɔ bɔɔlɛɛ ni Klaudio labuɛ alɛ Yuda batii bamuu badie di Roma basifi. Paulo lakyɛ aalaanya ma, ");
INSERT INTO snw_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ni aasiɛ di ɔkyɛ lɛma aatɔɔkyakaako ma nɛ, diekye babɔkɛɛ akũ akpanta bablatɛ baale fɛ nnwɔɔ. Ɔkpɛ nwu kafɔɔ abla aatoole nɛ. ");
INSERT INTO snw_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Di Lɛnyɛɛtɛyi biala, Paulo nkyɛ Yuda batii kasiisakɔ anaatoodiki sɛlaa kasɔ antɔɔta Yuda batii ku Griki batii bamuu alɛ baakyisa situ lɛma. ");
INSERT INTO snw_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Obe wɔ di Silas ku Timoteo lakye Makedonia baawa nii, Paulo layɔ obe nɔɔ omuu aata ɔlaa biene nwu lɛkya oyie, ni aakpasa kamɛ aatuo Yuda batii nwu alɛ, nwaako, Yesu ninle nwɔ di Yaa lɛpɛ ni ɔfɔɔ. ");
INSERT INTO snw_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Obe wɔ di Yuda batii nwu lataka baayila nwɔ ni di suoto, baabuɛ ni sɛlaa kpile, Paulo lasɔkɔ awu nɔɔ kudu aakpee ma, ni aatɔkɔ ma alɛ, “Nse biɛwɔɔ, nnɛɛ nii aku, nkpaa nii aku aye bamu atoo ale. Diɛyɔ di nua diesifi nii, nfɛ kosifi batii ba ninanle ni Yuda batii nfũ, nnaatɔkɔ ma ɔlaa biene nwu.” ");
INSERT INTO snw_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Nioso di Paulo ladie ni ninfa, aasifi aalaasiɛ di osuɔtɔ onwii nfũ, atale Yuda otii. Baatɔɔlɛɛ nwɔ Tito Yusto. Aale otii wɔ niatɔɔyɛkɛ ni Yaa, aasiɛ aakaako Yuda batii kasiisakɔ. ");
INSERT INTO snw_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kasiisakɔ nwɔ ɔnɔɔfo wɔ batɔɔlɛɛ ni Krispo ku leyo nɔɔ batii bamuu lafũ Saate baanu, Korinto batii kpinwu bawo kafɔɔ lanu ɔlaa nwu baafũ baanu, ni baakpeesa bamuu lɛma Yaa ntu nɛ. ");
INSERT INTO snw_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Dii ninwii kakyɛ, Saate latɔkɔ Paulo di kɔlaafɔ kamɛ alɛ, “Tanyɛkɛ! Tandiɛ ɔlaa nwu kafɔɔ obuɛ. ");
INSERT INTO snw_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Diekye nsiko fɔ, otii kuonwii kafɔɔ dilabafuo fɔ lɛsalɛsaa ɔbla. Batii kpinwu nkpe di okpoo wɔ mmle kamɛ bale mi ni bale.” ");
INSERT INTO snw_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Nioso Paulo lasiɛ di okpoo nwu kamɛ lɛlɛɛ ninwii ku ɔfã, aatootuo batii Yaa ɔlaa. ");
INSERT INTO snw_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Kafɔɔ obe wɔ baase ni Galio fɛ Roma batii abaa ɔnɔɔfo di Akaia kasɔ suoto, Yuda batii bawo labla onwii, baayɔ ɔlaa di Paulo suoto, baamufũ nwɔ baakpaa nwɔ baasifiko kakankɔ lɛma. ");
INSERT INTO snw_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Baatɔkɔ abaa ɔnɔɔfo nwu alɛ, “Osuɔtɔ wɔ mmle kɔmunikĩisa batii disibu alɛ baatoosumu Yaa di osuku wɔ nin-yɛ ni di kufiofa loo suoto.” ");
INSERT INTO snw_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Kafɔɔ obe wɔ di Paulo lakye kasɔ alɛ oodiki ni kanya, ni di Galio wɔ niale ni abaa ɔnɔɔfo labuɛ aatɔkɔ Yuda batii nwu alɛ, “Aye Yuda batii binu! Nse ɔlaa wɔ bikle biɛwa ko ni nfũ okpile wɔ nin-yɛ ni kuufiofa loo suoto kule yi, ntɔbawɛ otu nkyɔɔ ye ɔlaa kotoko. ");
INSERT INTO snw_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Kafɔɔ diekye ni di aye bamu sɛlaa ɔnanfi di ayooto ku afiofa lee suoto yi, aye bamu bilaabuɛ. Diele ami beese alɛ kale kantɛ nta ye di sɛlaa se mmle suoto.” ");
INSERT INTO snw_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Nioso aatososa ma aadiki di kakankɔ nɔɔ nwu. ");
INSERT INTO snw_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Nioso batii dikudi le mmle lamufũ Sostene, nwɔ ninle ni kasiisakɔ lɛma nwu ɔnɔɔfo baapɛ nwɔ di kakankɔ nwu ɔlɔɔkɔ. Kafɔɔ Galio ditakpee kanya. ");
INSERT INTO snw_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paulo lasiɛ di bafũbanutɛ nfũ di Korinto okpoo kamɛ ayi kpinwu. Nni kamaa, aaklaa bafũbanutɛ nwu, ni di nnwɔɔ ku Akwila ku Priskila baafe di ntu osi baasifi Siria nɛ. Kafɔɔ fiɛ abasifi nii, Paulo lata baakpaasu nwɔ disi di Kenkrea, diekye di Yuda batii ɔsaabla kanya di ntam be aaka aatɛ ni oso. ");
INSERT INTO snw_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Obe wɔ baabuo ni Efeso yi, aadiɛ Priskila ku Akwila ninfa. Kafɔɔ nnwɔɔ aasifi Yuda batii kasiisakɔ aalaabuo sɛɛlaa sɛwo kamɛ ku Yuda batii. ");
INSERT INTO snw_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Baatikiti nwɔ lekoto alɛ asiɛko ma kɛkɛɛ, kafɔɔ obe ditawɛ nwɔ. ");
INSERT INTO snw_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ta nkpo oso aatoosifi nii, aatɔkɔ ma alɛ, “Nse Yaa letuna, makple nwa ye ɔkyɛ.” Ni aakple aalaabuo di oklo kamɛ aadie di Efeso aasifi nɛ. ");
INSERT INTO snw_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Obe wɔ kafɔɔ aalaabuo ni Kaesarea, aakyɛ Yerusalem, ni aalaasɛɛsa bafũbanutɛ ba ninkpe ni ninfa nɛ. Ni aafe aasifi Antiokia nɛ. ");
INSERT INTO snw_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Paulo lasiɛ ninfa obe kɛɛkɛ, ni aasifi aalaafe di Galatia ku Frigia nsɔ suoto nɛ. Ni aatookpee bafũbanutɛ ba niawɛ ni ninfa bamuu osie nɛ. ");
INSERT INTO snw_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Yuda otii onwii lawa Efeso. Baatɔɔlɛɛ nwɔ Apolo, baalofo nwɔ di Aleksandria. Aale otii wɔ niatofo ni lɛkakatɛ, aatofo Kɔkpana Klekle kamɛ sɛlaa nwaa kafɔɔ. ");
INSERT INTO snw_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Baatuo nwɔ Saate osuku wɔ suoto baasiɛ ni nkpa, ɔtɔ lasiɛ nwɔ, nioso aabuɛ Yesu ɔlaa, aatuo asaa nwaa kafɔɔ di suoto nɔɔ. Kafɔɔ, Yohane ntu okpeesa ɔsaabla lete ko aatofo. ");
INSERT INTO snw_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Nioso obe wɔ aayila aatɔɔkakatɛ ni ku sɛkambi di Yuda batii kasiisakɔ, Priskila ku Akwila lanu nwɔ, ni baakpaa nwɔ baasifiko leyo, baalaadiki Yaa sɛlaa nwu kamɛ nwaa baatɔɔ baakyakaa nɛ. ");
INSERT INTO snw_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Nioso obe wɔ di Apolo latoobu diisi alɛ ɔkyɛ ni Akaia, Efeso bafũbanutɛ lakyakaako nwɔ, ni baakpana kukũ baata bafũbanutɛ ba ninkpe ni di Akaia alɛ, nse ɛɛbabuo nfa, balolaa nwɔ bafũ nwaa. Obe wɔ aalaabuo ni nfa, aakyakaako batii kpinwu ba nintoofũ beenu nii, diefe ni di Yaa sibualɛ ɔnya oso. ");
INSERT INTO snw_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Di sɛlaa se aananfiko ni Yuda batii di lɛkpaka yi, aayɔ suoto osie ku Kɔkpana Klekle kamɛ sɛlaa aakpasa sɛlaa kamɛ klekle alɛ, Yesu ninle nwɔ di Yaa lɛpɛ ni ɔfɔɔ. ");
INSERT INTO snw_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Obe wɔ di Apolo lawɛ ni di Korinto yi, Paulo kafɔɔ lafe di nkpaa osuku kplɛ, aalaabuo Efeso. Nfa aakyɛ aalaanya bafũbanutɛ bawo nɛ. ");
INSERT INTO snw_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Ni aakaalɛ ma alɛ, “Diayɔ di obe wɔ biefũ bienu nii, bitoofũ Yaa Ninwuna Klekle?” Ni baadiki kanya lɛ, “Oowo, be ninle Yaa Ninwuna Klekle? Diidii buunu ɔlaa kuonwii nkpo.” ");
INSERT INTO snw_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ni di Paulo lakple aakaalɛ ma alɛ, “Ɔmɛ Yaa ntu okpeesa biafũ mɔ?” Ni baatɔkɔ nwɔ alɛ, “Yohane, Yaa Ntu Kpeesatɛ nnle nwu.” ");
INSERT INTO snw_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Ni di Paulo ladiki kasɔ aatuo ma alɛ, “Yohane lakpeesa batii ba nintookyi ni siikpile lɛma kamɛ ku Yaa ntu. Ni aatɔkɔ ma alɛ bafũ otii wɔ ninkpi nwɔ kamaa ɔɔwa ni banu. Otii nwu ninle Yesu Kristo nɛ.” ");
INSERT INTO snw_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Nioso baanu ni ɔlaa wɔ mmle, baata baakpeesa ma Yaa ntu di Saate Yesu leyooto kamɛ. ");
INSERT INTO snw_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Obe wɔ kafɔɔ di Paulo latika ma ni nnɛɛ di suoto, Yaa Ninwuna lawa ma di suoto, ni baakyako sele ate ate obuɛ, baabuɛ Yaa ɔlaa kafɔɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Lɛpɔ lɛma lawo fɛ basuɔtɔ lefosi banyɔ. ");
INSERT INTO snw_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Paulo lakyɛ Yuda batii kasiisakɔ aalaatoodiki sɛlaa kamɛ aatɔɔta ma ku otu okpee awɛntɛ atiɛ. Aamiɛ alɛ oomunikĩisa ma disibu anta Yaa sɛka kalekɔ nwu suoto. ");
INSERT INTO snw_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Kafɔɔ batii bawo lawɛ otokopĩ kaamɛ lɛma, batafũ ɔlaa nwu baanu, baatii dikudi anu lɛɛkpaka baabuɛ sɛlaa kpile di Saate sisuku suoto. Nioso Paulo lakpaa mba niafũ baanu ni aasifiko Tirano asaa katuoko aalaatootuo ma asaa ninfa dii biala. ");
INSERT INTO snw_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Di alɛɛ anyɔ kamɛ, aatuo asaa, ni di ɔlaa biene wɔ mmle labiɛ kuakyaka Asia kasɔ kamuu nɛ. Nioso batii ba ninle ni Yuda batii ku mba ninanle ni Yuda batii kafɔɔ baanu ɔlaa nwu. ");
INSERT INTO snw_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Yaa labla sɛkpɛ se niɛbla ni ɔkpɛ siekyi ni lete aafenko di Paulo suoto. ");
INSERT INTO snw_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Nse bia bɛɛyɔ awu nɔɔ awo kafɔɔ bɛɛlaatika di bafiɛtɛ suoto mansie, anwuna kpile kafɔɔ latoodie di batii ba kamɛ asiɛ nii. ");
INSERT INTO snw_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Yuda batii bawo ba niakyɛ baatookyi baatootososa ni anwuna kpile kafɔɔ lamiɛ alɛ bɔɔyɔ Saate Yesu leyooto mantososa anwuna kpile. Ni baabuɛ alɛ, “Bulɛ die di Yesu otii wɔ suoto di Paulo kɔkakatɛ nii!” ");
INSERT INTO snw_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Yuda batii olebatatɛ ɔnɔɔfo wɔ baatɔɔlɛɛ ni Skeva, babi suɔtɔbi bakuɛnsĩ niatɔɔbla asaa ya mmle. ");
INSERT INTO snw_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Kafɔɔ baakakatɛ baata ni ninwuna kpile ninwii, ninwuna kpile nwu labuɛ alɛ, “N-ye Yesu, n-ye kafɔɔ Paulo. Aye mɔ, bawe bile?” ");
INSERT INTO snw_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Nioso Otii wɔ suoto di ninwuna kpile nwu lasiɛ nii, latu aabuo ma di suoto aakpɛko ma, aalenkee ma. Aatika ma nkɔ nwaa, ni baatoso baadie leeyo kamɛ ku akyɔtɔ nɛ! ");
INSERT INTO snw_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Lɛsaa le niawa ni ninfũ mmle lakyaka Efeso okpoo omuu, alɛ Yuda batii ku okpoo nwu batii bamuu lanu. Ta nkpo oso, lɛyɛkɛ lapɛ ma nwaa, nioso baayɔ dibu baata Yesu leyooto osie kanya. ");
INSERT INTO snw_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Nioso batii ba niakyisa ni situ lɛma, lawa babadiki sikpile lɛma baabuɛ di batii anu. ");
INSERT INTO snw_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Nioso batii ba niasiɛ ma ni kaamɛ baale ni bafatɛ, layɔ sɛfakũ ku afa akũ lɛma baabatɛ, ni baakpee nya ɔtɔ di batii anu nɛ. Baasiisa ni akũ nwu nkpo baakpee ni ɔtɔ kɔya labla fɛ koto futu nkpe afosi anɔɔ. ");
INSERT INTO snw_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Osuku wɔ mmle suoto di Yaa ɔlaa lafe kuatɔɔkpɛ kuatoomuɔ ni ku osie nɛ. ");
INSERT INTO snw_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Di nle mmle kamaa, Yaa Ninwuna ladiki aatuo Paulo alɛ alaafe di Makedonia ku Akaia asifi Yerusalem. Paulo labuɛ kafɔɔ alɛ, “Nse lebuo nfa yi, dikpe nii lɛkyɛ lɛlaanyu Roma kafɔɔ.” ");
INSERT INTO snw_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Nioso aakpee bakyakaakotɛ nɔɔ banyɔ, Timoteo ku Erasto, ni baale nwɔ katũ baasifi Makedonia nɛ. Ni aakple aasiɛ di Asia ninfa obe kɛkɛɛ aakyakaa nɛ. ");
INSERT INTO snw_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Di obe nwu kamɛ, kudu kplɛ kunwii lawa di Efeso ta Kristo ofũ onu osuku nwu otikanko oso. ");
INSERT INTO snw_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Nle mmle lakye kasɔ di otii wɔ baatɔɔlɛɛ ni Demetrio, nwɔ nin-yɔ koto fututu ambla afiɔ sanko ya baatɔɔlɛɛ ni Artemis leyo ansunsũ anta ni batii. Ɔkpɛ wɔ mmle ɔbla lananfi nfasũ diawako bakpɛmblatɛ nɔɔ. ");
INSERT INTO snw_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Dii ninwii, Demetrio lalɛɛ batii ba mmle ku koto banyanakĩisatɛ ba nikɔbla ni ɔkpɛ lɛma nwu okle, aatɔkɔ ma alɛ, “Babiloo, biye bilɛ lɛlɛ loo lekye ɔkpɛ wɔ mmle buɔbla ni kamɛ. ");
INSERT INTO snw_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Nunua, bionu, biɔnya kafɔɔ klekle lɛsaa le di Paulo kɔbla nii. Ɔɔtɔkɔ batii aamunikĩisa ma disibu alɛ, afiɔ ya bɛɛyɔ nnɛɛ bɛɛbla ni diele afiɔ ya baawa kasɔ manta nii. Diele Efeso ninfũ lete oobuɛ ɔlaa wɔ mmle. Atoobuɛ ɔlaa wɔ mmle di Asia kasɔ kamuu suoto. Batii kafɔɔ ntoofũ beenu! ");
INSERT INTO snw_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Nioso nfɛ dibata alɛ ɔkpɛ loo nlalaa. Diele bia nni lete, nfɛ dibata kafɔɔ alɛ batii dilabansimbu afiɔ sanko loo Artemis leyo bakpee di lɛsalɛsaa kamɛ. Nimuɔ nɔɔ kafɔɔ mayu. Nse nnwɔɔ ninle afiɔ ya bɔɔwa kasɔ manta ni di Asia kakɔ biala ku kayi kamuu fiɛ!” ");
INSERT INTO snw_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Obe wɔ baanu ni Demetrio lɛkakatɛ nwu, ɔblɔ lafiɛ ma, ni baakyako kudu oyiisa baatoobuɛ alɛ, “Efeso Afiɔ Sanko Artemis ninle Afiɔ Kplɛ ya ninlenke nii!” ");
INSERT INTO snw_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Nioso okpoo nwu omuu kamɛ layii ku kudu. Ninfɛ baasi dikudi, baamufũ Paulo bakpɛmblatɛ wo nɔɔ banyɔ ba bɔɔlɛɛ ni Gaio ku Aristarko ba niakyɛ ni Makedonia nɛ. Ni baakpaa ma baasifiko okpoo nwu kakankɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Nioso Paulo kafɔɔ, lamiɛ alɛ oobuo baatii nwu kamɛ ankyɛ nfa, kafɔɔ bafũbanutɛ nwu ninfa ditatɔɔ osuku. ");
INSERT INTO snw_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Nntɛɛ nwu banɔɔfotii ba niale ni Paulo basiɛwo, baakpee nwɔ otii, baatikiti nwɔ lekoto alɛ, atankpɛnsa suoto ɔkyɔɔsa bia kafii! ");
INSERT INTO snw_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Di obe nwu kamɛ, kudu layii kasikɔ lɛma nwu kamɛ. Nioso batii ba niakyɛ ni nfa, otii ku ɔlaa nɔɔ aatoobuɛ. Nioso batii kpinwu ditatofo lɛsaa le oso baasi ni ninfa. ");
INSERT INTO snw_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ninfɛ di Yuda batii nwu lata Aleksandro layila ma kaanya alɛ adiki lɛsaa le niɛwa ni kamɛ ata ma. Nioso Aleksandro latakatɛsa kɔnɛɛ katoo alɛ balo kanana aatɔkɔ ma ɔlaa. ");
INSERT INTO snw_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Kafɔɔ obe wɔ baatii ba mmle latofo alɛ Yuda otii ale nii, baakyɛ kasɔ baatooyiisa kudu osie kanya, diaklɛ fɛ abombo anyɔ. Ni baatoobuɛ alɛ, “Efeso Afiɔ Sanko Artemis ninle Afiɔ Kplɛ ya ninlenke nii!” ");
INSERT INTO snw_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Yɛntɛ yɛntɛ fiɛ di okpoo nwu kukũ kpanatɛ lafuo ma ni olosa, aatɔkɔ ma alɛ, “Efeso batii wo nii, awo ba dudu buye bulɛ Efeso ninfũ ninle Artemis Afiɔ Kplɛ kasiɛkɔ. Buye kafɔɔ bulɛ difuɔ klekle nwu niakpa diakye ni osi, ɔkyɛ loo ninfũ dite. ");
INSERT INTO snw_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Otii kuonwii dilabafuo ɔlaa wɔ mmle obuɛ alɛ kuote nkpo. Nkpo oso bitɛ situ kaasɔ, bitambla lɛsalɛsaa ku ɔblɔ. ");
INSERT INTO snw_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Batii ba mmle biemufũ biɛwako ni nfũ yi, baayu lɛsalɛsa bakyeko Artemis Afiɔ Sanko leyo, baakpɔnɔnfɔsa nwɔ leyooto kafɔɔ. ");
INSERT INTO snw_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Kafɔɔ nse Demetrio ku bakpɛntɛ wo nɔɔ lɛnya alɛ bakpe ɔlaa owo ku otii owo, ɔlaa bakantɛ nkpe ninfũ. Bukpe ayi ya kafɔɔ manka ni sɛlaa. Baafuo ɔlaa nwu ɔyɔ ɔwako nfũ. Mambuɛ manta ma di osuku kanya. ");
INSERT INTO snw_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Kafɔɔ nse ɔlaa bamba owo kule yi, ni biɛta babuɛ di okpoo banɔɔfo nfũ bata ye. ");
INSERT INTO snw_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Diekye nle mmle niɛwa nii, nse bielolaa binyu, babayɔ ɔlaa di suoto lee di kudu ko mmle oso. Mia kafɔɔ bilabafuo kanya odiki. Babananfi ye kootoko.” ");
INSERT INTO snw_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Obe wɔ aabuɛ sɛlaa se mmle aloo nii, aata ma baasamii. ");
INSERT INTO snw_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Di obe wɔ kuudu nwu nkpo ntooloo nii, Paulo lalɛɛ bafũbanutɛ nwu nkpo aasiisa. Aakpee ma osie. Ni aakaalɛ ma osuku, aadie aasifi Makedonia nɛ. ");
INSERT INTO snw_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Di osuku nɔɔ ɔkyɛ kamɛ, Paulo lafe di nntɛɛ nwu sekpoo kamɛ, aakpee batii osie ku Yaa ɔlaa, fiɛ nfɛ aalaabuo Akaia. ");
INSERT INTO snw_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Aasiɛ ninfa awɛntɛ atiɛ. Di obe wɔ aatoololaa suoto alɛ oosifi ni Siria, ni aatofo alɛ, Yuda batii bawo kɔtɛ nwɔ kalá di osuku alɛ babablo nwɔ. Nioso aabla disibu alɛ, ookple anaafe di Makedonia ansifi. ");
INSERT INTO snw_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Nioso obe wɔ aatoosifi nii, batii bawo latikanko nwɔ. Batii nwu niale Sopater wɔ niakye ni Beroia ale ni Piro obi ku Aristarko ku Sekundo baakye ni Tesalonika ku Gaio wɔ niakye ni Derbe ku Tihiko ku Trofimo ba niakye ni Asia ntɛɛ nwu ku Timoteo. ");
INSERT INTO snw_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Baale katũ baalaasoko wo di okpoo wɔ bɔɔlɛɛ ni Troa. ");
INSERT INTO snw_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Nioso obe wɔ di Yuda batii bloblo wɔ ninantaka ni ayi ole lafe nii, buayɔ oklo di Filipi, ni buasifi bualaakyakako ma di Troa di ayi anɔɔ sɛmaa. Ni buasiɛ ninfa ayi akuɛnsĩ nɛ. ");
INSERT INTO snw_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Dii kasale di nawɔkyi kamɛ, buasi dikudi di Yaa opunu katũ alesaa ole suoto. Diekye Paulo kɔwa ni ɔbasifi kaleesɛ oso, aakakatɛ diaklɛ, dialadu bia nkyɛntɛɛ. ");
INSERT INTO snw_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Nioso baasɔ bakandiɛ kpinwu baabase di ayo ya beetofo beetika ni baawo nle kamɛ buasiɛ ni di osi. ");
INSERT INTO snw_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Obe wɔ di Paulo latɔɔkakatɛ ditɔɔklɛ nii, sɛkyɔsĩ layɔ okosopo wɔ baatɔɔlɛɛ ni Eutiko di obe wɔ aasiɛ ni di sɛfle kotoko di ayo nwɔ osi. Obe wɔ atɔɔkyɔsĩi eesifi ni kamɛ, ni aakpa aakye ayo nwu letofo sitiɛ osi aabapɛ kaasɔ nɛ. Baakyɛ baalaakɛnkɛ nwɔ nii, aatookpi. ");
INSERT INTO snw_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Kafɔɔ di Paulo lasoo aakyɛ ni kasɔ, aamufũ osuɔtɔbi nwu aakpee di suoto, aabuɛ alɛ, “Bitampɛ kamuntũ! Akpe nkpa!” ");
INSERT INTO snw_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Nioso bamuu lɛma baakple baasifi leyo nwu osi. Ni baalaale opunu katũ alesaa nwu nɛ. Paulo lakple aakakatɛ ko ma dialaase di obe wɔ kaale lasɛ ni fiɛ nfɛ aasifi. ");
INSERT INTO snw_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Baakpaa okosopo nwu kafɔɔ baasɛnkɛsa ni baasifiko leyo. Nioso otu late ma. ");
INSERT INTO snw_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Ninfɛ di Paulo lafe di nkpaa osuku aasifi Aso nɛ. Kafɔɔ awo ba niatoofe ni nfa ku nnwɔɔ, buayɔ oklo buale nwɔ katũ bulɛ bubalaatɔɔkyaka ninfa munkpaa nwɔ fɛ mmle okle aabuɛ nii. ");
INSERT INTO snw_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Nioso obe wɔ aabakyakako wo ni di Aso, ni di awo ba dudu buayɔ oklo buasifi Mitilene nɛ. ");
INSERT INTO snw_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Kaleesɛ, bualaabuo Kio. Dii nyɔɔfa, bualaabuo Samo. Dii tiɛfa kafɔɔ bualaabuo Mileto. ");
INSERT INTO snw_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paulo lamiɛ alɛ buɔɔwaalɛ Efeso munfe, diekye atamiɛ alɛ ɔɔlalaasa obe kuonwii di Asia kasɔ ninfa. Diekye aamiɛ alɛ nse diaaba nwɔ, abuo Yerusalem fiɛ di Pentekoste dii nwu diwo. ");
INSERT INTO snw_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Nioso obe wɔ baalaabuo ni Mileto, Paulo lakpee Efeso bafũbanutɛ banɔɔfotii otii alɛ bawa babakyakako nwɔ. ");
INSERT INTO snw_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Obe wɔ baawa nii, aatɔkɔ ma alɛ, “Babiloo, biye mmle okle lasiɛ ye ni di ɔkyɛ obe lele, diayɔ ni di dii kasale, di obe wɔ lababuo ni Asia kasɔ suoto diɛbase ni di nua. ");
INSERT INTO snw_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Bianya mmle okle labla ni Saate ɔkpɛ di suoto kasɔ ɔwakosa kamɛ, nu lafe di dibuo ku kaku owi kamɛ diɛ Yuda batii omiɛ wɔ baamiɛ alɛ booloe ni oso. ");
INSERT INTO snw_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Kafɔɔ biye bilɛ ninkookaa ye lɛsaa lee nimakyakaako ye nii, nle n-ye ni di Yaa suoto, di Yaa ɔlaa obuɛ ku otuo kamɛ, lɛɛkpaka ku ayo le kamɛ. ");
INSERT INTO snw_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Kakɔ lele lakyɛ, laka Yuda batii ku mba ninanle ni Yuda batii osie kanya nlɛ, badiɛ sikpile ɔbla, baakyi basifi Yaa nfũ, baafũ Saate Yesu Kristo kafɔɔ banu. ");
INSERT INTO snw_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Nunua kafɔɔ, Yaa Ninwuna kɔtɔkɔ mi alɛ ntɔɔkyɛ Yerusalem, ninye kafɔɔ lɛsaa le nimanawa mi ni di suoto ninfa. ");
INSERT INTO snw_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Kafɔɔ lɛsaa le ko n-ye ninle alɛ, di okpoo lele kamɛ, Yaa Ninwuna ntɛɛ letofo alɛ leyo ote ku dibuo nsokoe ninfa. ");
INSERT INTO snw_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Nkpa nii diedie lɛsalɛsaa ditɛɛ. Lɛsaa le niefĩ mi ni ninle alɛ kabla lɛsaa le di Saate Yesu lekpee mi alɛ mbla nii. Lɛsaa le di Yesu lekpee mi alɛ mbla ni ninle alɛ, katɔkɔ batii Saate ɔlaa biene nwu fɛ mmle di Yaa lɛnya wo ni nyaami. ");
INSERT INTO snw_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Nunua n-ye nlɛ aye ba nianu mi ni asaa otuo di Yaa sɛka kalekɔ nwu suoto, kuonwii lee dilabasinnyɛɛ. ");
INSERT INTO snw_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Nioso kɔta ye letofo miɛ wɔ mmle nlɛ, nse onwii lee leyu didiki nɔɔ, blɔbalo mi lɛpɔɔ diidii. ");
INSERT INTO snw_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Diekye ninkookaa ye lɛsalɛsa di Yaa komiɛ alɛ biabla nii. ");
INSERT INTO snw_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ta nle mmle oso, bilolaa suoto binyu. Diekye Yaa Ninwuna niɛbla ye batunletɛ alɛ biaklee babi nɔɔ ba ɛɛyɔ eekpee ye ni di nnɛɛ. Bilolaa ma biklee, diekye Yaa lewii Obi nɔɔ ntɔ kaasɔ diisi lɛma eediki ma. ");
INSERT INTO snw_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","N-ye kafɔɔ nlɛ, nse ntoosifi, batii mataka ye di suoto mansamiisa ye, blɔbanya ye nyaami. Fɛ mmle okle di ɔkplɛle ntikanko ni bafoso ansamiisa ma nii. ");
INSERT INTO snw_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Bia batii bawo kaamɛ le, mataka manyila di nwaako ɔlaa nwu suoto, mankyɔkyɔ ye mintikanko ma. ");
INSERT INTO snw_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Bilolaa binyu, bienyuma mmle okle layɔ nnumɛɛ owi kafɔɔ latuo ye ni asaa kakũ ku kakyɛ di alɛɛ atiɛ ya lasiɛ ye ni kaamɛ. ");
INSERT INTO snw_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Nunua yi, kɔyɔ ye nkpee di Yaa nnɛɛ kamɛ, alɛ aayɔ ɔlaa nɔɔ anle ye sibualɛ. Ɔlaa nɔɔ wɔ ninkpee ni batii nɔɔ osie ku mmle kubata ye minle ni Yaa kafa asaa ku batii ba bamuu eediki eese lete ɛɛta ni suoto. ");
INSERT INTO snw_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ntasɛɛsa anu di otii kuonwii koto ee awu suoto. ");
INSERT INTO snw_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Aye bamu biye bilɛ nnɛɛ nii be mmle layɔ labla ɔkpɛ wɔ labla latoole nii, nwu kafɔɔ layɔ latoonyu batii ba niatikankoe buatɔɔbla ni ɔkpɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Labla asaa ya mmle amuu layɔ latuo ye mmle okle buatɔɔkyakaa ko ni bapiitɛ. Binyuma kafɔɔ ɔlaa wɔ di Saate Yesu labuɛ ni, ‘Ɔta nwako dikusɛkusɛ ninlenke ofũ.’ ” ");
INSERT INTO snw_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Obe wɔ di Paulo laloo ni lɛkakatɛ nɔɔ, ni aapɛ akunkyi kaasɔ, ni manko ma baapɛ ɔlaa baata Yaa nɛ. ");
INSERT INTO snw_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Batii nwu bamuu lakpee nwɔ nnɛɛ siimu baawi, baafifiɔ nwɔ akpoo, ta oosifi andiɛ ma ni oso. ");
INSERT INTO snw_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Lɛsaa le kafɔɔ niabla ma ni nyaami ninle alɛ, aabuɛ alɛ, blɔbasinkple banyɔɔ. Ninfɛ baatikanko nwɔ baakpaa nwɔ baalaadunko oklo katũ nɛ. ");
INSERT INTO snw_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Di obe wɔ butɔɔklaa ma buoloo nii, buasifi bualaabuo di oklo kamɛ buataalɛ buasifi Kos. Ni kaale lasiɛ nii, buasifi bualaabuo Rodo, buadie ninfa buasifi Patara. ");
INSERT INTO snw_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Nfa buayɔ oklo onwii niatoofe ni Foenisia, buasifi nɛ. ");
INSERT INTO snw_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Buanya Kipro kasɔ, ni buawaalɛ nfa buafe di nkpaalɔ lɛkyɛ bualaabuo Tiro okpoo Seria kasɔ. Ni buakyɛ lɛba le baatoofe ni atoo odiki di oklo nwu kamɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ni buasoo di oklo nwu kamɛ buakyɛ bualaanya bafũbanutɛ ba niawɛ ni ninfa nɛ. Buasiɛ di ɔkyɛ lɛma ayi akuɛnsĩ. Yaa Ninwuna ladiki aatuo ma lɛɛsaa le nimanawa ni di Paulo suoto. Nioso baatɔkɔ Paulo alɛ, atankyɛ Yerusalem. ");
INSERT INTO snw_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Kafɔɔ obe wɔ di ayi ya buasiɛ ni ninfa laloo ni buoosifi nii, bafũbanutɛ ba mmle ku basɔfɔ lɛma ku babi bamuu, baakpaa wo bualadu lekpo kotoko, ni bamuu loo buapɛ akunkyi buapɛ ɔlaa buata Yaa nɛ. ");
INSERT INTO snw_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Ni buaklaa bawo nɛ. Ninfɛ bualaabuo di oklo kamɛ, ni di mma kafɔɔ baakple baasifi ayo nɛ. ");
INSERT INTO snw_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Buadie ni di Tiro, buabayila di Ptolemai. Ni buakyɛ bualaasɛɛsa bafũbanutɛ ba ninkpe ni ninfa nɛ. Buasiɛ di ɔkyɛ lɛma dii ninwii. ");
INSERT INTO snw_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Kaleesɛ, buadie ninfa buasifi Kaesarea. Ni buakyɛ bualaasiɛ di Yaa ɔlaa biene buɛtɛ Filipo nfũ nɛ. Aasiɛ di bakyakaakotɛ bakuɛnsĩ ba baadiki ni kamɛ di Yerusalem. ");
INSERT INTO snw_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Aawɛ babi kpeelebitɛ bana, manadiyɔ ni asa, Yaa ɔlaa babuɛtɛtɛ kafɔɔ baale. ");
INSERT INTO snw_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Buasiɛ ninfa ayi awo. Obe wɔ buawɛ ni ninfa, Yaa ɔlaa buɛtɛtɛ onwii baatɔɔlɛɛ ni Agabo lakye Yudea aawa nfa. ");
INSERT INTO snw_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Obe wɔ aawa wo ni ɔkyɛ yi, ni aayɔ Paulo ofiamɛ, aanii nnwɔɔ omu nɔɔ nnɛɛ ku nkpaa, ni aabuɛ alɛ, “Yaa Ninwuna Klekle kobuɛ alɛ, nkpo okle di Yuda batii manii otii wɔ nimba ni ofiamɛ wɔ mmle di Yerusalem, man-yɔ nwɔ mankpee di batii ba ninanle Yuda batii nnɛɛ kamɛ nɛ.” ");
INSERT INTO snw_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Nioso obe wɔ buanu ni ɔlaa wɔ mmle, awo ku batii ba niawɛ ni ninfa, buatikiti Paulo lekoto bulɛ atankyɛ Yerusalem. ");
INSERT INTO snw_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Nfanwu aatɔkɔ wo alɛ, “Be oso biowi kaku mimbiɛsɛɛ otu nkpo? Ninlolaa suoto nta leyo ote lete di Yerusalem, letuna nlɛ bia kakpi ninfa ta Saate Yesu oso.” ");
INSERT INTO snw_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Nioso obe wɔ buanya bulɛ, bulɔbafuo nwɔ ni disibu okyisa, buadiɛ nwɔ, ni buabuɛ bulɛ, “Yaa dibiesaa diwa kaanya.” ");
INSERT INTO snw_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Di ayi asɛɛ awo kamaa, bualolaa suoto buasifi Yerusalem. ");
INSERT INTO snw_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Bafũbanutɛ bawo kafɔɔ di Kaesarea latikanko wo. Ni baakpaa wo baasifiko ɔnɔɔfo wɔ niakye ni Kipro baatɔɔlɛɛ ni Mnason nfũ alɛ, bulaasoosa ninfa. Ɔnɔɔfo wɔ mmle lale otii wɔ niafũ aanu ni kofokofoko. ");
INSERT INTO snw_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Obe wɔ buabuo ni Yerusalem, bafũbanutɛ ba niawɛ ni ninfa baafũ wo ku suoto lɛyɔɔ. ");
INSERT INTO snw_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Kaleesɛ, Paulo lakpaa wo buakyɛ bualaanya Yakobo, Yerusalem bafũbanutɛ banɔɔfo bamuu kafɔɔ lawɛ ninfa. ");
INSERT INTO snw_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Buasɛɛsa ma bualoo nii, Paulo latɔkɔ ma asaa ya amuu di Yaa labla aafenko ni di nnwɔɔ Paulo suoto, di batii ba ninanle ni Yuda batii kamɛ. ");
INSERT INTO snw_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Baanu nwɔ ɔlaa baaloo nii, bamuu lɛma baatansa Yaa. Ni baatɔkɔ wɔ alɛ, “Obiloo, faye? Batii nkpe nkpe ba ninle ni Yuda batii batoofũ beenu nii, lemufũ Mose kufiofa nwu bakle kpinkpĩ. ");
INSERT INTO snw_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Bawo latɔkɔ ma alɛ footuo Yuda batii ba bamuu ninkpe ni di batii ba ninanle ni Yuda batii kasɔ falɛ batantikanko Mose kufiofa. Diɛkyakaa nii, falɛ batambudi babi lɛma asɔkɔsɔkɔ ee batikanko afiofa lɛma. ");
INSERT INTO snw_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Lɛ nfɛ buɔbla nunua? Diekye babanu alɛ fatɔɔwa.” ");
INSERT INTO snw_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Nioso baabuko nwɔ disi alɛ, “Basuɔtɔ bana bawo nsi wo kaamɛ, bɛɛka ni ntam. ");
INSERT INTO snw_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Kpaa ma fasifiko Yuda batii Yaa Olekatakɔ nfa. Kpaasu disi nwu ku mma. Faakyakaako ma bata disi ɔkpaasu koto ko manta ni. Nle mmle mata otii biala nnya alɛ, sɛlaa se baabuɛ ni di suoto lɛfɔ diete nkpo. Ni bia afɔ omu lɛfɔ, fɔɔbla di Mose kufiofa nwu suoto. ");
INSERT INTO snw_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Kafɔɔ mba ninanle ni Yuda batii batookyi beekple ni bafũbanutɛ, buakpana kukũ, ni buatɔkɔ ma bulɛ, badiɛ alesaa ya bɛɛyɔ bɛɛta ni afiɔ olé ole, baadiɛ kafɔɔ ntɔ onyi, batanle babɔkɛɛ ba kafɔɔ beenwunukũusa simu beelo nii, baadiɛ kafɔɔ lɛsɔnɔkpee.” ");
INSERT INTO snw_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Nioso kaleesɛ Paulo lakpaa basuɔtɔ ba mmle nwu, ni baakyɛ baalaabla disi ɔkpaasu amanle nwu. Nni sɛmaa, aakyɛ Yuda batii Yaa Olekatakɔ aalaata lɛtatofo ayi ya di disi ɔkpaasu nwu mafũ nii, ku obe wɔ babayɔ asaa manwako, manta ni ole diisi lɛma. ");
INSERT INTO snw_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Kafɔɔ ditoobu ayi asɛɛ di ayi akuɛnsĩ nwu mawo nii, Yuda batii bawo lakye Asia kasɔ baawa baabanya Paulo di Yuda batii Yaa Olekatakɔ. Ni baasiisa batii bawo dikudi, baamufũ nwɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Ni baayiisa kudu alɛ, “Israel basuɔtɔ biwa bibakyakaako wo kyu woo! Osuɔtɔ wɔ mmle kokyi aba aba antuo asaa anyila di Yuda batii suoto, Mose kufiofa suoto, ku Yaa Olekatakɔ suoto. Ɛɛkpaa Griki batii bia eebuoko Yuda batii Yaa Olekatakɔ, ɔɔkpɔnɔnfɔsa lɛba klekle le mmle!” ");
INSERT INTO snw_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Baabuɛ nkpo diekye di obe owo kamɛ, baanya alɛ, Paulo ku Trofimo wɔ ninle ni Efeso otii nkyɛ di Yerusalem okpoo. Nioso baabu alɛ aakpaa nwɔ aakyɛnko Yuda batii Yaa Olekatakɔ. ");
INSERT INTO snw_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Ta kudu nwu baatooyiisa ni oso, batii bamuu lataka baatoso baakyɛ baalaamufũ Paulo baananfi nwɔ baadiki di Yaa Olekatatɔ. Baamufũ nyoko baasɛɛ. ");
INSERT INTO snw_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Di obe wɔ baamiɛ alɛ boolo nwɔ nii, Roma batii bakpɛtɛ banɔɔfo ɔnɔɔfo lanu alɛ kudu ntoobuo di Yerusalem okpoo omuu kamɛ. ");
INSERT INTO snw_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Nfanwu, ni aakpaa bakpɛtɛ banɔɔfo bawo ku bakpɛtɛ baakyɛ lɛba le kuudu nwu nkpe ni nɛ. Obe wɔ kuudu bakpeetɛ nwu lanya ni bakpɛtɛ nwu ku ɔnɔɔfo lɛma, baadiɛ Paulo ɔpɛ. ");
INSERT INTO snw_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Nfanwu bakpɛtɛ banɔɔfo ɔnɔɔfo nwu lamufũ Paulo, ni aata baayɔ ɛkpɛnkyɛ ɛnyɔ baakpee nwɔ nɛ. Ni aakaalɛ alɛ, “Owe ninle osuɔtɔ wɔ mmle, be ɛɛbla?” ");
INSERT INTO snw_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Di batii nwu kamɛ otii biala ku ɔlaa nɔɔ baatoobuɛ. Kudu nwu oso bakpɛtɛ banɔɔfo nɔɔfo nwu ditatofo lɛsaa le niawa nii, nioso aata alɛ bakpaa Paulo balaatɛ di leyo katenkɔ. ");
INSERT INTO snw_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","36","Obe wɔ baadu ni kayoko nkatakɔ, nfɛ diabawa alɛ bakpɛtɛ ba mmle lakɛnkɛ Paulo ninfa diekye anu lasɛɛ batii nwu di Paulo suoto. Nioso batii nwu latikanko ma ku kudu osie kanya baatoobuɛ alɛ, “Balo nwɔ!” ");
INSERT INTO snw_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Kafɔɔ obe wɔ nfɛ babayɔ Paulo mankpee ni leeyo kamɛ, aatɔkɔ bakpɛtɛ ɔnɔɔfo onwii alɛ, “Komiɛ nlɛ nkakatɛ kafɔɔ kɛɛkɛɛ.” Ni di bakpɛtɛ ɔnɔɔfo nwu lakaalɛ nwɔ alɛ, “Beeye! Foonu Griki sele?” ");
INSERT INTO snw_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Ni aakple aakaalɛ nwɔ alɛ, “Ni faale Egipte otii wɔ niakpaa batiilotɛ nkpe nna ba niataka baayila ni di abaa suoto obe owo nitɔɔbafe ni kamɛ, baatoso baasifi ni ɔfaafuu kasɔ?” ");
INSERT INTO snw_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Ninfɛ di Paulo ladiki kanya alɛ, “Yuda otii nle. Lekye Tarso di Kilikia kasɔ. Okpoo nwu kafɔɔ, okpoo finle kule. Lekoto, tikɛɛ nkakatɛ nta batii ba mmle.” ");
INSERT INTO snw_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Ninfɛ di bakpɛtɛ banɔɔfo ɔnɔɔfo nwu latuna alɛ Paulo akakatɛ ata ma nɛ. Ni di Paulo lataka aayila di kayoko kakatakɔ nwu, ni aawii ma kɔnnɛɛ alɛ balo kanana. Obe wɔ baalo ni kanana, ni aakakatɛ ko ma di Yuda batii sele kamɛ alɛ, ");
INSERT INTO snw_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Teete anɛ ku babiloo, bikyɔɔ mi atoko, biɛtɛɛ ndiki suoto kanya di anu lee bienu.” ");
INSERT INTO snw_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Di obe wɔ baanu alɛ Yuda batii sele ɔɔkakatɛko ma nii, baakple balo kanana baalenkee lɛkasale. Ni di Paulo latɔkɔ ma alɛ, ");
INSERT INTO snw_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Yuda otii nle, baalofo mi kafɔɔ di Tarso di Kilikia kasɔ suoto. Kafɔɔ, Yerusalem baaklee mi lakyɛ sukuu. Gamaliel nfũ latekete asaa. Baatuo mi bawa loo afiofa nwu klekle. Layɔ otu nii lata Yaa, lasumu nwɔ ku okyiini fɛ mmle okle di ayee biɔbla ni miɛ. ");
INSERT INTO snw_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Diayɔ ni di obe nwu, latikanko bafũbanutɛ ba niatɔɔkyɛ ni di Kristo osuku nwu suoto, lata baalo ma. Lamufũ basuɔtɔ ku basanko kafɔɔ latɛ leeyo katenkɔ. ");
INSERT INTO snw_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Yaa Oletatɛ Nɔɔfo ku kasiisakɔ ɔnɔɔfo biala n-ye alɛ ɔlaa wɔ kobuɛ ni nte nkpo, diekye mma ninkpana akũ mantɛɛ fiɛ nimbla asaa ya mmle. Ni di obe wɔ latoofe ni Damasko, baatɛɛ osie alɛ, nse lɛnya bafũbanutɛ ba ninkpe ni ninfa, nimmufũ ma, nkpee ma sɛkpɛnkyɛ, ninkpaa ma nwako Yerusalem baananfi ma di atoko. ");
INSERT INTO snw_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Di obe wɔ kofe ni Damasko ditoobu kɛɛkɛɛ mabuo nii, fɛ kakũ lefosi elomu ɛnyɔ kamɛ, nfanwu lakpa le ninkpe ni osie lakye osi diabakpete mi, diamana mi diakyi! ");
INSERT INTO snw_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Ninfɛ lanɔɔ lapɛ kaasɔ nɛ, ni lanu sɛlɔ sinwĩi kɔkakatɛkoe alɛ, ‘Saulo, Saulo, be oso fatikankoe nkpo?’ ");
INSERT INTO snw_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“Ni lakaalɛ nlɛ, ‘Saate, owe fale?’ “Ni aakple aatɔkɔ mi alɛ, ‘Ami ninle Yesu Nasaret Otii wɔ fatikanko ni osie kanya.’ ");
INSERT INTO snw_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Munko batii ba niakyɛ ni lanya lɛkpa nwu, kafɔɔ batanu otii wɔ niatɔkakatɛkoe ni sɛlɔ. ");
INSERT INTO snw_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“Ni lakaalɛ nwɔ nlɛ, ‘Saate, be nimbla?’ “Ni aatɔkɔ mi alɛ, ‘Taka, faatɔɔkyɛ Damasko okpoo. Nfa babatɔkɔ fɔ asaa ya amuu di Yaa lɛtɛ alɛ fababla nii.’ ");
INSERT INTO snw_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Anu labiɛ mi, ta ɔtɔ nwu lɛkpa osie oso. Nioso munko mba niakyɛ ni nfɛ niaklee mi ninnɛɛ bualaabuo Damasko. ");
INSERT INTO snw_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Osuɔtɔ onwii lawɛ di okpoo nwu, bɔɔlɛɛ nwɔ ni Anania. Aale otii wɔ ninyɛkɛ ni Yaa nwaa, aamufũ afiofa loo kafɔɔ aaklee osie kanya. Yuda batii ba bamuu kafɔɔ ninkpe ni ninfa mmbu nwɔ osie kanya. ");
INSERT INTO snw_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Otii wɔ mmle labayila di ɔlɔɔkɔ nii, ni aabuɛ alɛ, ‘Obiloo Saulo, tikikti anu!’ Nfanwu, anu latikiti mi, ni lanyu nwɔ nɛ! ");
INSERT INTO snw_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ni aatɔkɔ mi alɛ, ‘Bawa loo Yaa niediki fɔ alɛ faatofo nwɔ dibiesaa, fannya Klekletɛ nɔɔ nwu kafɔɔ, fannu nwɔ sɛlɔ kafɔɔ. ");
INSERT INTO snw_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Diekye fabale nwɔ ɔlaa buɛtɛ di aba aba fantɔkɔ batii bamuu lɛsaa le fɛɛnya ni ku nle feenu nii. ");
INSERT INTO snw_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Nunua be feekple fasoko? Taka, faafũ ntu okpeesa amanle nwu. Faalɛɛ nwɔ, aafotofɔ sikpile adiki di suoto.’ ");
INSERT INTO snw_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Nni kamaa, lakple lasifi Yerusalem. Obe wɔ lawɛ di Yaa Olekatakɔ latɔɔpɛ ɔlaa latɔɔta ni Yaa yi, diabla mi fɛ sɛkyɔsĩ niayɔ mi, ni lanya odiki otuo nɛ. ");
INSERT INTO snw_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Nfa nfɛ di Saate omu latɔkɔ mi alɛ, ‘Pɛsɛwa faadie di Yerusalem, diekye nfũ mmle batii dilabanu fɔ ɔlaa wɔ fababuɛ ni di suoto nii.’ ");
INSERT INTO snw_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","“Kafɔɔ ladiki kanya labuɛ nlɛ, ‘Saate, bamuu lɛma baye alɛ nkyɛ Yuda batii nsiisakɔ naamufũ mba niefũ fɔ beenu nii mpɛ ma. ");
INSERT INTO snw_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Di obe wɔ baatoolo ni ɔlaa buɛtɛ lɛfɔ Stefano, lawɛ ninfa, latunako ma, mba niatoolo nwɔ nii, baadiki akpeele lɛma baatɛɛ laklee di obe wɔ bɔɔsafɔ nwɔ ni afuɔ.’ ");
INSERT INTO snw_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","“Kafɔɔ Saate nwu latɔkɔ mi alɛ, ‘Taka, faatɔɔkyɛ, diekye makyesee fɔ fanfa di batii ba ninanle ni Yuda batii kamɛ!’ ” ");
INSERT INTO snw_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Di obe nwu kamɛ, batii ba mmle layila kloklo baatoonu Paulo ɔlaa. Kafɔɔ obe wɔ aabuɛ ni ɔlaa yɛntɛle wɔ mmle, bamuu lɛma baayiisa kudu osie kanya alɛ, “Aa! Bilo nwɔ, diɛkaatɛ alɛ aakple ansiɛ nkpa!” ");
INSERT INTO snw_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ni baayiisa kudu osie kanya, baakyako awu lɛma ɔbɛbɛɛ, ni baatɔɔsa kɔtɛ kafɔɔ di osi ku ɔblɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Ni baakpɛtɛ banɔɔfo ɔnɔɔfo nwu lata alɛ bakpaa Paulo balaakpee leeyo nwu kamɛ baapɛ nwɔ baawolaa kamɛ lɛsaa le oso di Yuda batii nwu diloomiɛ alɛ banyɔɔ ni anu. ");
INSERT INTO snw_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Di obe wɔ baatoonii nwɔ alɛ bɔɔpɛ nii, Paulo lakaalɛ bakpɛtɛ ɔnɔɔfo onwii alɛ, “Osuku kule alɛ baapɛ Roma otii wɔ manadikanko balo nwɔ ni lɛpɔɔ?” ");
INSERT INTO snw_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Ni di ɔnɔɔfo wɔ mmle lakyɛ bakpɛtɛ banɔɔfo ɔnɔɔfo nwu nfũ alaakaalɛ nwɔ alɛ, “Be falɛ fɔɔblaa? Osuɔtɔ wɔ mmle Roma otii ale lo!” ");
INSERT INTO snw_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Nioso bakpɛtɛ banɔɔfo ɔnɔɔfo wɔ mmle lakyɛ Paulo nfũ alaakaalɛ, nwɔ alɛ, “Beeye, Roma otii fale?” Ni di Paulo latuna alɛ, “Yii, Roma otii nle!” ");
INSERT INTO snw_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Ni di bakpɛtɛ banɔɔfo ɔnɔɔfo nwu latɔkɔ Paulo alɛ, “Amii, Roma otii nle. Kafɔɔ ami koto dikudi lata fiɛ lekple Roma otii!” Ni di Paulo latɔkɔ nwɔ alɛ, “Ami, Roma obi tintĩ nle beelofo nii.” ");
INSERT INTO snw_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Nfanwu bakpɛtɛ ba niayila alɛ babapɛ nwɔ mankaalɛ nwɔ ni kanya nɔɔ ɔlaa niakyɛ nwɔ di ɔlɔɔkɔ baasifi. Lɛyɛkɛ kafɔɔ lapɛ bakpɛtɛ banɔɔfo ɔnɔɔfo nwu obe wɔ aatofo alɛ Roma otii ninle ni Paulo fiɛ beemufũ nwɔ kafɔɔ bɛɛpɛ ni lekpo. ");
INSERT INTO snw_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Bakpɛtɛ banɔɔfo ɔnɔɔfo nwu lamiɛ alɛ ootofo lɛsaa le niawa ni oso di Yuda batii bamuu n-yɛ ni di Paulo suoto. Nioso kaale lasɛ nii, aalɛɛ Yuda batii olebatatɛ banɔɔfo ku bakantɛ lɛma aasiisa. Ni aata baafukuti Paulo, baakpaa nwɔ baawako anu lɛma alɛ, baabuo di ɔlaa nwu kamɛ. ");
INSERT INTO snw_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paulo lakyako Bakantɛ nwu niasi ni onyu di anu tuwĩi, ni aabuɛ alɛ, “Babiloo, otu nii diloolo mi lɛpɔɔ di mmle okle nsi ni nkpa di Yaa anu diɛbase bia miɛ.” ");
INSERT INTO snw_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Nioso Anania wɔ ninle ni Yuda batii Yaa Oletatɛ Nɔɔfo labuɛ aatɔkɔ batii ba niayila baakaako ni Paulo alɛ bapɛ nwɔ kaanya. ");
INSERT INTO snw_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Nfanwu, Paulo latɔkɔ nwɔ alɛ, “Yaa mapɛ fɔ! Afɔ oyiyiɛ wɔ beekpiitaa ni ku akaaloo fututu, ɔmɛ kanktɛ fale! Fasi ninfa fɔɔkankoe di kufiofa kanya, kafɔɔ, afɔ fatɔɔtaalɛ kufiofa fɛɛta osuku falɛ bapɛ mi!” ");
INSERT INTO snw_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Batii ba niayila ni di Paulo ɔlɔɔkɔ lakaalɛ nwɔ alɛ, “Yaa Oletatɛ Nɔɔfo footufa?” ");
INSERT INTO snw_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Nioso Paulo ladiki kanya alɛ, “Babiloo, ninye nlɛ Yaa Oletatɛ Nɔɔfo ale, se ninkakatɛko nwɔ nkpo. Diekye di Kɔkpana Klekle Kukũ kamɛ, beebuɛ alɛ, ‘Bitambuɛ ɔlaa kpile kuonwii di batunletɛ lee suoto.’ ” ");
INSERT INTO snw_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Obe wɔ di Paulo latofo alɛ batii ba niasi ni bawo nle ni Saduki batii, baawo kafɔɔ nle ni Farisi batii yi, nioso aabuɛ osie kanya alɛ, “Babiloo, Farisi otii nnle! Farisi otii kafɔɔ nielofo mi! Bɔɔkankoe ninfũ miɛ ta lefũ lenu nlɛ, bakpi makple mantaka ni oso!” ");
INSERT INTO snw_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Nioso obe di Paulo laloo ni ɔlaa wɔ mmle obuɛ, ni kaananfi labuo di Saduki ku Farisi batii nntɛɛ, ni baasɛ di akyuu anyɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Diekye Saduki batii kobuɛ alɛ bakpi dilabasintaka, ni Yaa batɔkyɛntɛ ku anwuna kafɔɔ nnaa. Kafɔɔ Farisi batii lefũ asaa nwu atiɛ beenu. ");
INSERT INTO snw_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Nfa di kakpɔkpɔtɔ kplɛ labuo ma nintɛɛ nɛ. Ni kuufiofa batuotɛ ba ninle ni Farisi batii layila Paulo ɔlaa kamaa nɛ. Ni baatakatɛsa kanya katoo baabuɛ alɛ, “Buɔnya okpile kuonwii di osuɔtɔ wɔ mmle suoto! Loobia Yaa tɔkyɛntɛ ee ninwuna lewo niɛkakatɛ diɛtɔɔ kubio!” ");
INSERT INTO snw_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Kananfi labawɛ osie, ta nkpo oso bakpɛtɛ banɔɔfo ɔnɔɔfo nwu layɛkɛ alɛ babananfi Paulo mambɛbɛɛ. Nioso aatɔkɔ bakpɛtɛ nɔɔ alɛ bakyɛ baalaakpaa nwɔ baatii nwu kamɛ basifiko leyo katenkɔ. ");
INSERT INTO snw_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Dii nwu nkpo kakyɛ, Saate Yesu labayila di Paulo ɔlɔɔkɔ ni aatɔkɔ nwɔ alɛ, “Paulo, kpee osie! Fɛ mmle okle feebuɛ mi ni ɔlaa di Yerusalem ninfũ, dikpe nii fɛɛbla nkpo di Roma kafɔɔ.” ");
INSERT INTO snw_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Kaleesɛ, Yuda batii bawo labasi baaka ntam alɛ, nse bayilo Paulo, blɔbale alesaa ee banyi lɛsalɛsaa! ");
INSERT INTO snw_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Batii ba niabla ni lɛsaa nwu mawo fɛ batii afosi ana ku kamaa. ");
INSERT INTO snw_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ni baakyɛ di Yaa olebatatɛ banɔɔfo ku batunletɛ lɛma nfũ baalaabuɛ alɛ, “Buɔka ntam bulɛ bulɔbale ee bunyi lɛsalɛsaa, diɛlase di obe wɔ buolo ni Paulo. ");
INSERT INTO snw_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Nioso aye ku Bakantɛ bikple bikpee bakpɛtɛ ɔnɔɔfo nɔɔfo otii bilɛ, akple akpaa Paulo awako ye. Biɛbla fɛle biomiɛ bilɛ biɔkaalɛ nwɔ sɛlaa sewo minkyakaa. Nse nfɛ bɔɔkpaa nwɔ manwako, awo bubalo nwɔ di osuku fiɛ abadu nfũ.” ");
INSERT INTO snw_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Kafɔɔ Paulo ɔfa nɔɔ suɔtɔbi lanu kanwumbe ka baatookũ ni di Paulo suoto, nioso aakyɛ leyo katenkɔ aalaatɔkɔ nwɔ. ");
INSERT INTO snw_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Nioso Paulo lalɛɛ bakpɛtɛ ɔnɔɔfo nwu onwii lɛma aatɔkɔ nwɔ alɛ, “Akpaa okosopo wɔ mmle akyɛnko ɔnɔɔfo nɔɔfo lɛma. Akpe ɔlaa finle onwii alɛ ɔɔtɔkɔ nwɔ.” ");
INSERT INTO snw_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Nioso, bakpɛtɛ ɔnɔɔfo nwu lakpaa okosopo wɔ mmle aakyɛnko ɔnɔɔfo nɔɔfo lɛma nfũ. Ni aatɔkɔ nwɔ alɛ, “Paulo wɔ bɛɛtɛ ni leeyo niɛlɛɛ mi ɛɛtɔkɔ alɛ, nkpaa okosopo wɔ mmle nwako fɔ aatɔkɔ fɔ ɔlaa onwii.” ");
INSERT INTO snw_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Nioso bakpɛtɛ ɔnɔɔfo nɔɔfo wɔ mmle lamufũ okosopo nwu kɔɔnɛɛ aakpaa nwɔ aasifiko ɔlɔɔkɔ, ni aakaalɛ nwɔ alɛ, “Be ɔlaa foomiɛ falɛ fatɔkɔ mi?” ");
INSERT INTO snw_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Ni aatɔkɔ nwɔ alɛ, “Yuda batii bawo lɛbla onwii ku banɔɔfo lɛma alɛ babawa mankaalɛ fɔ alɛ faakpaa Paulo fanwako kakankɔ lɛma kɔsɛɛ fɛle boomiɛ alɛ bakaalɛ nwɔ sɛlaa sewo. ");
INSERT INTO snw_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Kafɔɔ tannu ma ɔlaa, diekye batii bawo ninlenke ni batii afosi ana lewofa basi di osuku bɔɔtɛ nwɔ kala alɛ babalo nwɔ. Batii ba mmle lɛka ntam alɛ babalo Paulo fiɛ babale ee manyi ntu. Nioso nfɛ basi di osuku nunua wɔ mmle alɛ bababla nkpo.” ");
INSERT INTO snw_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Bakpɛtɛ banɔɔfo ɔnɔɔfo wɔ mmle latɔkɔ obisɔ nwu alɛ, “Tanta kuonwii latofo alɛ fɛbatɔkɔ mi ɔlaa wɔ mmle, feenu!” Ninfɛ aata okosopo nwu lasifi nɛ. ");
INSERT INTO snw_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Nioso bakpɛtɛ banɔɔfo ɔnɔɔfo wɔ mmle lalɛɛ bakpɛtɛ banɔɔfo banyɔ, ni aatɔkɔ ma alɛ, “Bidiki bakpɛtɛ alafa anyɔ, balolaa suoto babasifi Kaesarea di miɛ kakyɛ ɛlomu ɛnaasĩ kamɛ. Biediki bapɔnkɔ basiɛtɛ afosi akuɛnsĩ ku akplɔ bakleetɛ alafa anyɔ bikyakaa. ");
INSERT INTO snw_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Bita Paulo bapɔnkɔ asiɛ, biɛkpaa nwɔ bisifiko Ɔka Felike nfũ, bienyu bilɛ eebuo nfa buɛɛ.” ");
INSERT INTO snw_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ninfɛ di bakpɛtɛ ɔnɔɔfo nɔɔfo nwu lakpana kukũ fɛ mmle aata ma baasifiko nɛ. ");
INSERT INTO snw_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Ami Klaudio Lisia niɛkpana kukũ ko mmle kokyesee afɔ Ɔka Biene Felike ku lɛsɛɛsa. ");
INSERT INTO snw_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Yuda batii lamufũ osuɔtɔ wɔ mmle baamiɛ alɛ boolo nwɔ fiɛ munko bakpɛtɛ nii buakyɛ buaalafũ nwɔ, diekye lanu alɛ Roma otii ale ni oso. ");
INSERT INTO snw_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Nioso lakpaa nwɔ lawako kakankɔ lɛma nlɛ konu lɛsaa le ɛɛbla nii. ");
INSERT INTO snw_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Kafɔɔ labanya nlɛ diɛkaatɛ alɛ baalo nwɔ ee baatɛ nwɔ leeyo, diekye ɔlaa wɔ bɛɛyɔ ni di suoto nɔɔ n-yɛ di mma bamu afiofa suoto. ");
INSERT INTO snw_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Kafɔɔ obe wɔ di otii onwii layu aakpee mi ni kootoko alɛ bookũ nwɔ ni kanwumbe alɛ babalo nwɔ nii, nfanwu, labla nlɛ kɔyɔ nwɔ nkyesee fɔ nkpaa nkpaa. Nintɔkɔ batii ba niɛyɔ ni ɔlaa di suoto nɔɔ nlɛ, ɔlaa lele bakpe di suoto nɔɔ bayɔ bawako anu lɛfɔ bababuɛ ninfa. ");
INSERT INTO snw_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Nioso bakpɛtɛ ba mmle labla fɛ mmle baatɔkɔ ma nii. Kakyɛ nwu baakpaa Paulo baasifiko Antipatri. ");
INSERT INTO snw_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Ni kaaleesɛ, kasɔ bakpɛtɛ lakple baawa leyo katenkɔ nwu, kafɔɔ baata bapɔnkɔ basiɛtɛ lakpaa Paulo baasifiko Keasarea. ");
INSERT INTO snw_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Obe wɔ baabuo nii, baayɔ Paulo ku kukũ ko baata ma nii, baata Ɔka nwu. ");
INSERT INTO snw_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Nioso aaka kukũ nwu, ni aakaalɛ Paulo lɛba le eekye nii. Obe wɔ aatofo alɛ Kilikia eekye nii, ");
INSERT INTO snw_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Ni aatɔkɔ nwɔ alɛ, “Kama nu kanya lɛfɔ ɔlaa, nse batii ba niɛyɔ ni ɔlaa di suoto lɛfɔ lɛwa.” Nioso aata baayɔ Paulo baakpee di Ɔka Herode leyo katenkɔ. Ni aata kafɔɔ bakpɛtɛ layila baatoonyu nwɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Di ayi anɔɔ sɛmaa, Yaa Oletatɛ Nɔɔfo Anania ku Yuda batii banɔɔfo bawo ku kanyadikitɛ wɔ bɔɔlɛɛ ni Tertulo baakyɛ Kaesarea. Baawa Felike nfũ alɛ bɔɔbadiki Paulo sikpile mantɔkɔ nwɔ. ");
INSERT INTO snw_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Nioso obe wɔ baalɛɛ Paulo bawako nii, Tertulo lakye kasɔ ku lɛkakatɛ alɛ, “Ɔnɔɔfo loo wɔ buobu ni, obe kpinwu ditɔɔwa alɛ busi ni di atoko ɔkyɛ ole kamɛ nɛ, diekye di ninumbe ku lɛsaatofo le fɛɛyɔ fɔɔkpaa wo ni oso. Butɔɔnya kafɔɔ kakyi kpinwu biene ka nintɔɔwa ni di kasɔ loo ka mmle suoto. ");
INSERT INTO snw_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Lɛsaa le mmle nle lɛsaa le niebuo ni awo Yuda batii bamuu anu. Nioso buɔpɛ fɔ sɛfa. ");
INSERT INTO snw_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Noomiɛ nlɛ nlalaasa fɔ obe, nioso buotikitifɔ lekoto bulɛ faale wo sibualɛ fankyɔɔ wo kotoko di ɔlaa kakui wɔ bukle ni di osuɔtɔ wɔ mmle suoto. ");
INSERT INTO snw_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","“Diekye butɔɔnya bulɛ kudu kpeetɛ ale, akyɛ ookyi aba aba ookpee kudu di Yuda batii nntɛɛ di kayi kamuu. Eekple ale kafɔɔ dikudi le ninle ni Nasaret batii dikudi lalaale tunletɛ. ");
INSERT INTO snw_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Diɛkyakaa nii, aamiɛ alɛ ɔɔkpɔnɔnfɔsa Yuda batii Yaa Olekatakɔ, ninfɛ buamufũ nwɔ nɛ. Buamiɛ bulɛ buɔkanko nwɔ di kufiofa loo kanya fiɛ. ");
INSERT INTO snw_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Kafɔɔ bakpɛtɛ banɔɔfo ɔnɔɔfo Lisia lawa aabafũ nwɔ di nnɛɛ loo kamɛ ku osie. Ni aabuɛ alɛ, batii ba niɛyɔ ni ɔlaa di Paulo suoto bawa di anu lɛfɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Nse afɔ omu lɛfɔ fɛɛkaalɛ nwɔ sɛlaa yi, fabanya falɛ sɛlaa se buobuɛ ni di suoto nɔɔ simuu nte nkpo.” ");
INSERT INTO snw_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ni di Yuda batii bamuu lasi kanya baabuɛ alɛ, sɛlaa se simuu di Tertulo lebuɛ ni di suoto nɔɔ site nkpo. ");
INSERT INTO snw_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Obe wɔ di Ɔka wɔ mmle lawii ni Paulo kɔnɛɛ alɛ akakatɛ nii, Paulo labuɛ alɛ, “Teete, n-ye nlɛ fatɔɔka Yuda batii sɛlaa di alɛɛ kpinwu kamɛ. Nioso suoto kɔyɔɔ mi alɛ madiki suoto kanya di anu lɛfɔ. ");
INSERT INTO snw_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Fɛ mmle faye nii, diɛbla fɛ lefosi ayi anyɔ nɛ, lɛkyɛ Yerusalem nlɛ kɔlata ole di Yuda batii Yaa Olekatakɔ kamɛ. ");
INSERT INTO snw_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Yuda batii diɛnyɛɛ alɛ kɔnanfi ɔlaa ku otii di Yaa Olekatakɔ, ee banyɛɛ kokpee kudu di Yuda batii kasiisakɔ ee lɛkpaka lɛba lewo. ");
INSERT INTO snw_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Batii ba mmle nnaa lɛsalɛsaa babayila ni di suoto mambuɛ alɛ, sɛlaa se boobuɛ mi ni di suoto nte ni nkpo. ");
INSERT INTO snw_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Kafɔɔ, lefũ lekpee nlɛ, kosumu bawa loo Yaa di osuku wɔ boobuɛ alɛ diɛlɛ nii. Kafɔɔ lefũ asaa ya amuu bɛɛkpana ni di Mose kufiofa kamɛ ku Yaa ɔlaa babuɛtɛtɛ akũ kamɛ lenu. ");
INSERT INTO snw_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Nkpe osuku onyu fɛ mmle di mma kafɔɔ bakpe ni osuku onyu alɛ batii biene ku bakpiletɛ, Yaa masɛnkɛsa ma ankyeko bakpi kamɛ. ");
INSERT INTO snw_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Ta nle mmle oso, kokpee osie nlɛ disibu biene kawɛ mi di Yaa ku batii anu. ");
INSERT INTO snw_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Alɛɛ kpinwu nsinnaa in di Yerusalem nɛ. Ninfɛ lɛkyɛ nlɛ kɔlaata bapiitɛ asaa, ninta ole kafɔɔ nta Yaa. ");
INSERT INTO snw_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Obe wɔ latɔɔbla ni disi ɔkpaasu amanle nwu, ni di Yuda batii bawo labanyɛɛ di Yaa Olekatakɔ ninfa nɛ. Diele munko adu bakpeetɛ niawɛ ninfa. Kudu kuninwii kafɔɔ ditawɛ ninfa. ");
INSERT INTO snw_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Yuda batii bawo niakye ni Asia kasɔ niawɛ ninfa. Nse mma dikaatɛ alɛ manwa ɔkyɛ lɛfɔ ninfũ, nse ɔlaa owo nkpe ma di suoto nii, mambuɛ. ");
INSERT INTO snw_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Ee batii ba ninsi ni ninfũ, ta ma babuɛ okpile wɔ lɛpɔɔ baalo mi ni, di obe wɔ di Yuda batii bakantɛ banɔɔfo lakankoe ni. ");
INSERT INTO snw_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Ɔlaa wɔ ko latakatɛsa sɛlɔ katoo labuɛ ni ninle alɛ, ‘Bɔɔkankoe ninfũ miɛ ta lefũ lenu nlɛ bakpi mataka ni oso.’ Kaalɛ ma nse nle mmle ninle mi okpile wɔ lɛbla ni.” ");
INSERT INTO snw_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Nioso Felike wɔ ninye ni ofũ onu osuku nwu nwaa, latɔkɔ Yuda batii ba mmle alɛ, “Bidiɛ biesoko dilaase di obe wɔ di bakpɛtɛ banɔɔfo ɔnɔɔfo Lisia mawa ni fiɛ nimbudisa ɔlaa wɔ mmle.” ");
INSERT INTO snw_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ni aatɔkɔ bakpɛtɛ ɔnɔɔfo alɛ baakpaa Paulo baalaakpee leeyo nɛ. Kafɔɔ batambla nwɔ amumu, baalolaa nwɔ banyu, bata kafɔɔ basiɛwo nɔɔ osuku se lɛsaa lewo lefĩ nwɔ baabla batɔɔ. ");
INSERT INTO snw_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Di ayi awo sɛmaa, Felike ku ɔsɔfɔ nɔɔ Drusila wɔ ninle ni Yuda otii lawa, ni aata baakpaa Paulo baawako, ni aatɔkɔ ma Yesu Kristo ofũ onu ɔlaa nɛ. ");
INSERT INTO snw_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Di obe wɔ di Paulo lasiɛ aatoodiki sɛlaa kasɔ di nkpa biene osiɛ suoto aatɔɔtɔɔ nii, ku suoto omufũ oklee ku Yaa lɛkanko le nikɔwa nii, lɛyɛkɛ lapɛ Felike. Ni aatɔkɔ Paulo alɛ, “Taka faatɔɔkyɛ. Nse lɛwɛ obe nwaa makple nlɛɛ fɔ.” ");
INSERT INTO snw_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Aabu kafɔɔ alɛ Paulo matɔkɔ alɛ, oomiɛ koto kowo ammufũ nwɔ kɔɔkpaa, nioso obe lele anta manlɛɛ Paulo mantɔɔ manko nwɔ mankakatɛ. ");
INSERT INTO snw_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Di alɛɛ anyɔ sɛmaa, baadiki Felike, ni baayɔ Porkio Festo baawako kasiɛkɔ nɔɔ nɛ. Kafɔɔ ta Felike lamiɛ alɛ Yuda batii babɔmbɔ nwɔ ni ɔlaa oso, aata Paulo lakple aasiɛ di leeyo katenkɔ. ");
INSERT INTO snw_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Di Festo lababuo ni sɛka kalekɔ nɔɔ di ayi atiɛ sɛmaa, aadie di Keasarea aakyɛ Yerusalem. ");
INSERT INTO snw_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Nfa di Yaa olebatatɛ banɔɔfo ku Yuda batii banɔɔfo latɔkɔ nwɔ Paulo suoto ɔlaa nɛ. Ni baatikiti nwɔ lekoto alɛ ");
INSERT INTO snw_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ata bakpaa Paulo bawako Yerusalem. Diekye disibu lɛma niale alɛ, babasiɛ mansoko nwɔ di osuku. Nse oofe see batoolo nwɔ. ");
INSERT INTO snw_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Kafɔɔ Festo latɔkɔ ma alɛ, “Leyo di Paulo nte di Kaesarea. Mia kafɔɔ kɔwa nfa ɔbasifi di obe kakui kamɛ. ");
INSERT INTO snw_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Nioso bita banɔɔfo lee bawa nfa nse bakpe ɔlaa owo di osuɔtɔ wɔ mmle suoto babadiki babuɛ.” ");
INSERT INTO snw_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Di Festo lasiɛ ni ninfa fɛ ayi anɛ ee lefosi kamaa, aakple aasifi Kaesarea. Dii le aakple ni kaleesɛ, aalɛɛ Paulo ɔlaa nwu di kakankɔ. ");
INSERT INTO snw_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Di Paulo lababuo ni kakankɔ nwu ninfa, Yuda batii ba niakye ni Yerusalem baawa nii, labamana Paulo baakyi, baabudi Paulo kanya ku sɛlaa kpinwu osie kanya. Kafɔɔ batawɛ ɔtɛ onyu kuonwii baatuo alɛ, sɛlaa se boobuɛ ni di suoto nɔɔ nte nkpo. ");
INSERT INTO snw_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Paulo ladiki suoto kanya aabuɛ alɛ, “Nintaalɛ Yuda batii kufiofa ee nkpɔnɔnfɔsa Yaa Olekatakɔ ee nyila di Roma Ɔka kufiofa suoto.” ");
INSERT INTO snw_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Kafɔɔ Festo lamiɛ alɛ oobuo Yuda batii anu, nioso, aakaalɛ Paulo alɛ, “Foomiɛ falɛ fasifi Yerusalem nimatɔɔka ɔlaa lɛfɔ nwu ninfa?” ");
INSERT INTO snw_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Ni di Paulo latɔkɔ nwɔ alɛ, “Oowo. Ɔka Kplɛ Kaesare kakankɔ n-yɛ nɛ. Nfũ kafɔɔ dikpe ni bɛɛkankoe. Fɛ mmle di afɔ omu lɛfɔ faye ni, nimbla okpile di Yuda batii suoto. ");
INSERT INTO snw_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Nse lɛbla lɛsaa le dikaatɛ alɛ baalo mi, ninsĩ nlɛ batanloe! Kafɔɔ nse nimbla okpile kuonwii, dinaa alɛ afɔ ee otii bamba lɛyɔ mi eepkee di batii ba mmle nnɛɛ. Nioso komiɛ nlɛ ɔlaa nii kute di Ɔka Kplɛ Kaesare anu aabuɛ nwu atɛɛ!” ");
INSERT INTO snw_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Nioso Festo ku banɔɔfo wo nɔɔ lakpee asi baawo ni aatɔkɔ nwɔ alɛ, “Fɛɛnya feebuɛ falɛ fɔɔyɔ ɔlaa lɛfɔ fantɛ ni di Ɔka Kplɛ Kaesare anu oso, Kaesare anu ko fabakyɛ.” ");
INSERT INTO snw_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Di ayi awo sɛmaa, Ɔka Agripa ku obilɛma sankobi Bernike lawa Festo nfũ di Kaesarea alɛ bɔbasɛɛsa nwɔ mantɔɔ ɔfɔɔ. ");
INSERT INTO snw_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Baasiɛ ninfa ayi kpi, nioso Festo layɔ Paulo ɔlaa aatɔkɔ Ɔka wɔ mmle alɛ, “Osuɔtɔ onwii nte leeyo ninfũ mmle di Felike lesifi eediɛ nwɔ nii. ");
INSERT INTO snw_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Obe wɔ lakyɛ ni Yerusalem yi, Yaa olebatatɛ banɔɔfo ku Yuda batii banɔɔfo latɔkɔ mi ɔlaa nɔɔ, ni baatɔkɔ mi alɛ, nlo nwɔ lɛpɔɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","“Kafɔɔ latɔkɔ ma nlɛ, Roma batii kufiofa diɛta osuku alɛ baalo otii lɛpɔɔ fiɛ baakanko nwɔ. Dikpe ni bɛɛtɔɔ osuku alɛ manko batii ba niɛwɛ ni ɔlaa, bɛɛkyaka anu ku anu beebuɛ ɔlaa nwu fiɛ, se baalo nwɔ lɛpɔɔ, fiɛ manlo nwɔ. ");
INSERT INTO snw_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Di obe wɔ baawa ni nfũ di ɔlaa wɔ mmle oso yi, ntafenko nwu sɛmaa. Kaleesɛ, ni lata baakpaa osuɔtɔ wɔ mmle baawakoe di kakankɔ nɛ. ");
INSERT INTO snw_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Kafɔɔ, ɔlaa wɔ baayɔ ni di suoto nɔɔ ditale okpile wɔ lanyu nlɛ loo baabuɛ alɛ ɛɛbla nii. ");
INSERT INTO snw_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Sɛlaa se ko baabuɛ ni niale ɔlaa ɔnanfi ku Paulo di mma bamu ofũ onu lɛma suoto, ku osuɔtɔ onwii bɔɔlɛɛ ni Yesu alɛ atookpi nii. Kafɔɔ Paulo kobuɛ alɛ akpe ni nkpa! ");
INSERT INTO snw_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Diakpɔkpɔtɔ mi, nioso ntatofo mmle kabudisa ni ɔlaa nwu. Nioso lakaalɛ Paulo se eetuna alɛ bɔɔyɔ ɔlaa nwu mansifiko Yerusalem manaabuɛ ninfa. ");
INSERT INTO snw_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Kafɔɔ Paulo labuɛ alɛ oomiɛ alɛ ayɔ ɔlaa nɔɔ ata Ɔka Kplɛ Kaesare. Nioso lata nlɛ bayɔ nwɔ bakpee leeyo diɛlaase di obe wɔ mata mankpaa nwɔ mansifiko ni nfa.” ");
INSERT INTO snw_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Ni di Ɔka Agripa latɔkɔ Festo alɛ, “Komiɛ nlɛ ami omu nnu nwɔ kanya ɔlaa.” Ni di Festo latɔkɔ nwɔ alɛ, “Yoo, kɔsɛɛ fabanu nwɔ kanya ɔlaa!” ");
INSERT INTO snw_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Ninfɛ kaale lasɛ nii, Ɔka Agripa ku Bernike lawa kakankɔ nwu di Sɛɛka kanya. Bakpɛtɛ banɔɔfo ku okpoo nwu kamɛ banɔɔfo latikanko ma baawa. Ni di Festo lakpee alɛ balaakpaa Paulo bawako nɛ. ");
INSERT INTO snw_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Ni di Festo labuɛ alɛ, “Ɔka Agripa ku aye ba niesi ni ninfũ, biɔnya osuɔtɔ wɔ mmle? Yuda batii ba bamuu ninkpe ni di Yerusalem ku Kaesarea lɛyɔ ɔlaa di suoto nɔɔ alɛ diɛkaatɛ alɛ aakple ansiɛ nkpa. ");
INSERT INTO snw_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Kafɔɔ ninnya okpile wɔ ɛɛbla ni oso eesiɛko alɛ baalo nwɔ nii. Kafɔɔ obe wɔ di nnwɔɔ omu nɔɔ ɛɛkaalɛ alɛ ɔɔyɔ ɔlaa nɔɔ anta ni Ɔka Kplɛ letuna nlɛ kɔkpaa nwɔ nsifiko nfa. ");
INSERT INTO snw_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Kafɔɔ nnaa ɔlaa kuonwii katɛ nkpana ni di suoto nɔɔ nkyɛnko ni Ɔka Kplɛ. Diekye aabla okpile kuonwii nwaako. Nioso ntɔɔkpaa nwɔ lɛwako ye, kyenkye afɔ Ɔka Agripa, nse bitoonu nwɔ kanya kamɛ ɔlaa bieloo, kawɛ ɔlaa nkpana nkyeko suoto nɔɔ. ");
INSERT INTO snw_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Diekye, diɛlɛ alɛ faayɔ leyo tentɛ fankyesee Ɔka bamba falɛ akanko nwɔ alɛ, faakpana okpile wɔ ɛɛbla ni fakyakaa.” ");
INSERT INTO snw_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agripa latɔkɔ Paulo alɛ, “Osuku nkpe fɔ alɛ faabuɛ ɔlaa lɛfɔ fandiki suoto kanya.” Nioso Paulo lakplesa kɔnɛɛ katoo, ni aakakatɛ aadiki suoto kanya alɛ, ");
INSERT INTO snw_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Ɔka Loo Biene Agripa, disi nlɛ mi alɛ anu lɛfɔ madiki suoto kanya miɛ di sɛlaa se di Yuda batii lɛyɔ ni di suoto nii. ");
INSERT INTO snw_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Diekye n-ye nlɛ afɔ faye Yuda batii kufiofa ku amanle lɛma amuu nwaa. Nioso lese fɔ akunkyi, wɛ otu fatɛɛ, faakyɔɔ mi ɔlaa kotoko. ");
INSERT INTO snw_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Yuda batii bamuu n-ye mmle okle lasiɛ ni nkpa diayɔ ni bia sibisɔ nii, di okpoo nii ku Yerusalem kafɔɔ. ");
INSERT INTO snw_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Nse bababuɛ nwaako, baye kofokofoko alɛ, lasiɛ nkpa fɛ Farisi otii, di Yuda batii dikudi le ninle ni afiofa loo mulenkee ni kasumu lele. ");
INSERT INTO snw_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Lɛsaa le oso bɔɔkankoe ni ninfũ mmle ninle alɛ, osuku onyu nkpe mi di ntam be di Yaa laka aata ni bawo loo suoto. ");
INSERT INTO snw_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Ntamu be mmle kafɔɔ oso di Israel nfaabi lefosi nnyɔ latoonyu osuku baatoosumu ni oso, baatɔɔtɔ Yaa kakũ ku kakyɛ nɛ. Ɔka Loo Biene, osuku onyu wɔ mmle oso di Yuda batii lesi kanya di suoto nii nɛ. ");
INSERT INTO snw_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Be oso dikpe ye osie alɛ biafũ minnu bilɛ Yaa ntakatɛsa bakpi? ");
INSERT INTO snw_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Ami niayɔ latika di suoto nlɛ mabla nle kafuo nii nnyila di Yesu Nasaret Otii nwu batii suoto. ");
INSERT INTO snw_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Yuda batii Yaa olebatatɛ banɔɔfo latɛɛ osie alɛ lamufũ batii Klekle nwu kpinwu latɛ leeyo di Yerusalem. Mba kafɔɔ baalo ni kaamɛ lɛma, ami niata oso baalo ma. ");
INSERT INTO snw_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Latikanko ma osie kanya ku ɔblɔ lalaadu bia sekpoo bamba se niakyo ni kamɛ. Lata baabla ma amumu di Yuda batii nsiisakɔ. Layila ma di suoto baabuɛ mbusuo sɛlaa di Yesu suoto baakple nwɔ di nkpaamaa. ");
INSERT INTO snw_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Nle mmle oso latoofe Damasko ku osie fɛ mmle di Yaa olebatatɛ banɔɔfo latɛɛ ni kanya. ");
INSERT INTO snw_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Ɔka Loo Biene, kukũ kpanamantãa latoofe ni osuku nwu, ni di lɛkpa le nikɔkpa dilenke ni kufĩ, lakpa diakye osi diamana mi diakyi ku batii ba niatoofe nii. ");
INSERT INTO snw_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Ninfɛ baamuu loo buanɔɔ buapɛ kaasɔ nɛ. Ni lanu sɛlɔ sinwii kobuɛ di Yuda batii sele kamɛ alɛ, ‘Saulo, Saulo, be oso fatikankoe nkpo? Di balɛ alɛ faayɔ kɔkpaa fantɔɔsa di owuu alɛ diebuo fɔ.’ ");
INSERT INTO snw_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","“Ni lakaalɛ nlɛ, ‘Afɔ owe dile, Saate?’ “Ni sɛɛlɔ nwu nkpo labuɛ alɛ, ‘Ami Yesu wɔ fatikanko ni osie kanya dile. ");
INSERT INTO snw_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Nunua, taka fayila! Diekye ntoodiki suoto letuo fɔ alɛ kamayɔ fɔ mbla kpɛmblatɛ nii. Fabatɔkɔ batii asaa ya amuu fɛɛnya ni ninfũ ku n-ya kɔwa ni ɔbadiki otootuo fɔ nii. ");
INSERT INTO snw_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Kamadiki fɔ di Yuda batii ku mba ninanle ni Yuda batii ba kamɛ kokyesee fɔ ni nnɛɛ kamɛ. ");
INSERT INTO snw_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Fabatikiti ma anu, fammunikĩisa ma fankyeko ditunu kamɛ fanwako lɛkpa kamɛ. Fabadiki ma fankyeko Abonsam osie kamɛ fanwako Yaa nfũ, alɛ Yaa kayɔ sikpile lɛma ankyɛ ma, alɛ baawɛ kasiɛkɔ di batii ba eediki eese ni lete ɛɛta ni suoto diekye beefũ mi beenu.’ ");
INSERT INTO snw_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Nioso, Ɔka Agripa, ntasĩ odiki otuo wɔ lanya lakyeko ni osi ɔbla! ");
INSERT INTO snw_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Lakye ɔlaa biene nwu obuɛ ɔta Damasko batii, ku Yerusalem batii ku Yuda batii bamuu ku mba ninanle ni Yuda batii kafɔɔ. Latɔkɔ ma nlɛ, bakyi siikpile lɛma kamɛ, baamunikĩi bawa Yaa nfũ, baatɔɔbla kafɔɔ asaa ya nimatuo alɛ nwaako batookyi ni. ");
INSERT INTO snw_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Nle mmle oso di Yuda batii ba mmle baamufũ mi di Yaa Olekatakɔ nɛ. Baamiɛ kafɔɔ alɛ boolo mi. ");
INSERT INTO snw_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Kafɔɔ, Yaa ntoodiki mi di nnɛɛ lɛma kamɛ diɛbase bia miɛ. Nioso lekple nsi nkpa kodiki sɛlaa se mmle mbuɛ ntɔkɔ aye banɔɔfo ku batii bamuu nɛ. Sɛlaa se mmle kobuɛ ni ninfũ, nsĩnwu di Yaa ɔlaa babuɛtɛtɛ bamuu ku Mose labuɛ alɛ sibawa kaanya nɛ. ");
INSERT INTO snw_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Alɛ Kristo nwu di Yaa lɛpɛ ni ɔfɔɔ mawa amanya dibuo. Nnwɔɔ kafɔɔ nimale otii kasale wɔ nimataka ankye ni bakpi kamɛ nɛ. Abayɔ lɛkpa kafɔɔ anwako Yuda batii ku mba ninanle ni Yuda batii bamuu.” ");
INSERT INTO snw_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Nfanwu, Festo lafaa aabuɛ alɛ, “Paulo, fatoobuo afĩi! Dikunye lɛfɔ nwu kpinwu ntɔɔlalaasa fɔ disi kamɛ!” ");
INSERT INTO snw_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Ni di Paulo ladiki kanya aabuɛ alɛ, “Festo bienetɛ, noobuo afĩi. Tan-yɔ ɔlaa wɔ mmle faakpeeko kɔkyɔ. Nwaako kɔtɔkɔ fɔ. ");
INSERT INTO snw_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Nwaako, Ɔka Agripa n-ye sɛlaa se mmle kobuɛ ni ninfũ. Nioso kɔkakatɛ nwu ku sɛkambi nɛ. Lefũ lenu klekle nlɛ batabla asaa ya mmle baawofasa nwɔ. ");
INSERT INTO snw_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Ɔka Agripa, feefũ Yaa ɔlaa babuɛtɛtɛ feenu? N-ye nlɛ feefũ feenu.” ");
INSERT INTO snw_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Ni di Agripa lakaalɛ Paulo alɛ, “Foonyu falɛ faafuo mi Kristo ole ɔbla di obe kakuii wɔ mmle kamɛ?” ");
INSERT INTO snw_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Ni di Paulo ladiki kanya alɛ, “Di obe kakuii kamɛ woo, di obe kaanale kamɛ woo, kɔpɛ ɔlaa nta Yaa nlɛ, afɔ ku mba nikonu mi miɛ biakyi minte fɛ mmle nte nii. Kafɔɔ diele fɛ mmle nsi ni di nkɔnii kamɛ!” ");
INSERT INTO snw_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Ninfɛ di Ɔka Agripa ku Festo ku Bernike ku batii bule bamuu baataka baasifi nɛ. ");
INSERT INTO snw_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Obe wɔ batoodie ni ninfa, baakakatɛ di Paulo ɔlaa nwu suoto baabuɛ alɛ, “Otii wɔ mmle diɛbla lɛsaa le baalo nwɔ nii ee baatɛ nwɔ ni leeyo katenkɔ.” ");
INSERT INTO snw_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Nioso Agripa latɔkɔ Festo alɛ, “Baafuo osuɔtɔ wɔ mmle odiɛ nse diele fɛ nnwɔɔ nialɛ bayɔ ɔlaa nɔɔ balaatɛ di Kaesare anu oso.” ");
INSERT INTO snw_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Di obe wɔ baabuɛ alɛ butɔɔkyɛ ni Roma di Italia, baayɔ Paulo ku leyo batentɛ bawo baakpee di bakpɛtɛ ɔnɔɔfo wɔ baatɔɔlɛɛ ni Yulio nnɛɛ kamɛ. Nnwɔɔ ninnyu batii ba ninyila mannyu ni Roma bakpɛtɛ dikudi le bɔɔlɛɛ ni Ɔka Kplɛ Dikudi nɛ. ");
INSERT INTO snw_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Ni buayɔ oklo wɔ niakye ni Adramitio, kuatoofe ni Asia kasɔ. Nioso awo ku Makedonia otii wɔ bɔɔlɛɛ ni Aristarko niekye ni Tesalonika niasiɛ di oklo nwu kamɛ. ");
INSERT INTO snw_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Kaleesɛ, bualaabuo Sidon lekpo kotoko. Yulio lale Paulo sifutulɛ, aatɔɔ osuku di okpoo nwu kamɛ alɛ, akyɛ aalaanya basiɛwo nɔɔ alɛ baatɔɔ asaa ya niefĩ nwɔ ni abayɔ anklee ni osuku. ");
INSERT INTO snw_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Buakple buadie ninfa ku oklo, kafɔɔ ta kɔfɛɛfɔ siene lafɛ kuatɔɔkyakako wo ni oso, buafe di Kipro kalɔ nɔɔ lɛkyɛ buatoso kɔfɛɛfɔ nwu. ");
INSERT INTO snw_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Nioso buafe di Kilikia lekpo osi ku Panfilia lekpo osi buawa Mira lekpo kotoko di Likia kasɔ suoto. ");
INSERT INTO snw_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Nfa di bakpɛtɛ ɔnɔɔfo nwu nikɔkpaa wo ni lanya oklo onwii niakye ni Aleksandria, latoofe Italia kasɔ suoto. Ni aayɔ bamuu loo aakpee di oklo nwu kamɛ nɛ. ");
INSERT INTO snw_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Di ayi kpinwu kamɛ, osuku nwu ɔkyɛ labawɛ osie fiɛ buafuo Knido okpoo obuo. Kɔfɛɛfɔ siene nwu niatɔɔfɛ ni ninfa oso, batafuo ɔkyɛ tinini. Nioso obe wɔ buabuo ni Salmone, buakɛ buafe di Kreta, nfa kasɔ ntĩi kɔfɛɛfɔ siene kanya. ");
INSERT INTO snw_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Butakyo di lekpo kotoko, sebe fiɛ buabadu lɛba le bɔɔlɛɛ ni oklo kayilakɔ nwaa. Ditakyo di okpoo wɔ bɔɔlɛɛ ni Lesea. ");
INSERT INTO snw_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Buale obe kpinwu di osuku nwu ɔkyɛ kamɛ, kanya onii bee kafɔɔ ntoofe. Osuku ɔkyɛ di ntu osi di obe nwu kamɛ kafɔɔ labawɛ osie nwaa. Nioso Paulo laka ma aatɔkɔ ma alɛ, ");
INSERT INTO snw_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Teete anɛ, ntɔɔnya nlɛ osuku loo wɔ mmle ɔkyɛ diɛyɔ ni di nunua wɔ mmle mawɛ osie nwaa, diekye oklo wɔ mmle kamalalaa, ku asaa kpinwu, batii nkpa kafɔɔ kamawɔɔ.” ");
INSERT INTO snw_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Kafɔɔ bakpɛtɛ ɔnɔɔfo wɔ mmle lafũ oklo kanyayilatɛ ku oklo saate kɔka aalenkee nwɔ di Paulo labuɛ nii. ");
INSERT INTO snw_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Nioso obe wɔ di oklo kayilakɔ nwu diɛlɛ alɛ baasiɛ ni di lɛwɔɔfɔ obe kamɛ oso, osuku bakyɛntɛ nwu mba ninlenke nii baatuna alɛ boosifi, baatoonyu alɛ loo bababuo Foinike. Ni, babafuo osiɛ ninfa di lɛwɔɔfɔ obe. Diekye Foinike nle okpoo di Kreta kasɔ suoto ninkpe ni seklo nnyilakɔ, nintĩi ni kɔfɛɛfɔ kanya di kufĩ katunkɔ. ");
INSERT INTO snw_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Di obe nwu kamɛ, kɔfɛɛfɔ kunwii latɔɔfɛ buɛɛ kuokye nkpaalɔ lɛkyɛ kuatɔɔwa, nioso diate oklo bawantɛ nwu fɛ osuku nwu ɔkyɛ malɛ ma. Nioso baafukuti oklo lekpo, ni baatu baafe di kasɔ ka bɔɔlɛɛ ni Kreta lekpo kotoko nɛ. ");
INSERT INTO snw_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Ditaklɛ kɔfɛɛfɔ siene ko manlɛɛ ni, Katoo kufĩ katunkɔ kɔfɛɛfɔ, lakyako ɔfɛ okye Kreta kasɔ suoto. ");
INSERT INTO snw_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Ni kɔɔfɛɛfɔ nwu labalɛ oklo nwu nɛ. Ditaba wo buamunikĩisa oklo nwu buakyɔɔ kɔfɛɛfɔ nwu anu. Nioso buata kɔfɛɛfɔ nwu osuku kuatuka wo kuatɔɔkyɛnko. ");
INSERT INTO snw_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Sɛmaa fiɛ, buawɛ kawofakɔ kawo di kasɔ ka di ntu lɛmana diekyi ni bɔɔlɛɛ ni Kauda, di sɛmaa lɛkyɛ. Diawɛ osie fiɛ buafuo oklo biibii wɔ bukle ni di oklo kplɛ kamɛ onii ɔkaasa di lɛsaa suoto. ");
INSERT INTO snw_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Di obe wɔ baamufũ nwu nii, baayɔ okũ baanii oklo kplɛ nwu kafɔɔ. Baatɔɔyɛkɛ alɛ kɔfɛɛfɔ mafɛ nwu kunsifiko apatapata lɛba di Libia lekpo kotoko. Nioso baasoosa abula ya ninta oklo nkyɛ nii. Nle mmle oso kɔfɛɛfɔ ko mmle laklee oklo nwu aakyɛ aatookyiko. ");
INSERT INTO snw_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Kɔfɛɛfɔ siene nwu latɔɔfɛ ɔfɛ, nioso kaleesɛ, baakyako oklo kamɛ asaa ya aatuka ni odiki oyu di lekpo kamɛ. ");
INSERT INTO snw_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Dii tiɛfa, baayɔ oklo akpɛmblasaa awo baayu di ntu kamɛ. ");
INSERT INTO snw_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Kɔfɛɛfɔ siene ko mmle lafɛ ayi kpi. Nioso kufĩ ee awɛntrɛbi ɔnya ditawɛ. Butasinwɛ osuku onyu bulɛ bubawɛ nkpa! ");
INSERT INTO snw_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Obe wɔ baatii ntoosiɛ ayi kpinwu alesaa ɔtanle ni yi, Paulo lataka aayila di anu lɛma, aatɔkɔ ma alɛ, “Babiloo, nse minnu mi ɔlaa, bitantu di Kreta yi, se dibuo le mmle diɛwa wo di suoto, se asaa loo kafɔɔ dieyu. ");
INSERT INTO snw_vpl VALUES (